﻿USE sofia;
DROP TABLE IF EXISTS sofia.apr_vpl;
CREATE TABLE apr_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES apr_vpl WRITE;
INSERT INTO apr_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Nga bet tapiti rara ke Yesu Kirisi nga, ngan Yesu tani, in sasa ke Dawiti, inbe Dawiti in sasa ke Awaram. ");
INSERT INTO apr_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Ngan rara tani in bet tapiti le ipa ye Awaram a ise nga, ngan nen. Awaram ikere ngan le natunu la Esaka i. Inbe Esaka in Yakop tamana. Inbe Yakop in Yuda iye di toonoo le taini tamadi. ");
INSERT INTO apr_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Inbe Yuda tani in Peres iye Sarra yo tinadi Tamar nga, ngan tamadi. Inbe Peres in Esron tamana. Inbe Esron in Ram tamana. ");
INSERT INTO apr_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Inbe Ram in Aminadap tamana. Inbe Aminadap in Nason tamana. Inbe Nason in Salmon tamana. ");
INSERT INTO apr_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Inbe Salmon tani, in Boas yo tinana Reap i, in tamana. Inbe Boas in Obet yo tinana Rutu i, in tamana. Inbe Obet in Yesi tamana. ");
INSERT INTO apr_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Inbe Yesi in Dawiti yo iyei tool kuto mai pang tana kidi Isrel le imot i, in tamana. Inbe Dawiti tani in Solomon tamana. Ngan Solomon tinana in mugu ngan Uria rimana. ");
INSERT INTO apr_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Inbe Solomon in Reoboam tamana. Inbe Reoboam in Abia tamana. Inbe Abia in Asa tamana. ");
INSERT INTO apr_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Inbe Asa in Yeosapet tamana. Inbe Yeosapet in Yeoram tamana. Inbe Yeoram in Usia tamana. ");
INSERT INTO apr_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Inbe Usia in Yotam tamana. Inbe Yotam in As tamana. Inbe As in Isikia tamana. ");
INSERT INTO apr_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Inbe Isikia in Manase tamana. Inbe Manase in Amon tamana. Inbe Amon in Yosaia tamana. ");
INSERT INTO apr_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Inbe Yosaia in Yekonia iye di taini tamadi. Ngan ye kene tani in di Babilon tikap di Yuda tina a la titar di ye tana yo kidi i. ");
INSERT INTO apr_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Inbe ye kene yo di Babilon tikap di Yuda tina a la titar di ye tana kidi nga, motong la Yekonia tani in iyei Seltiel tamana nga. Inbe Seltiel in Serubabel tamana. ");
INSERT INTO apr_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Inbe Serubabel in Abiut tamana. Inbe Abiut in Eliakim tamana. Inbe Eliakim in Asor tamana. ");
INSERT INTO apr_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Inbe Asor in Sadok tamana. Inbe Sadok in Akim tamana. Inbe Akim in Iliut tamana. ");
INSERT INTO apr_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Inbe Iliut in Iliesa tamana. Inbe Iliesa in Matan tamana. Inbe Matan in Yakop tamana. ");
INSERT INTO apr_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Inbe Yakop in Yosep tamana. Ngan Yosep tani in iyooloo Madia yo ipasuiu Yesu a tiweta ye Kirisi, tool tani yo Maro ipootoo bet si ikap di tooltool ki a ipamulu di ye so dook tiap yo bet igarung di i. ");
INSERT INTO apr_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Le rara tani in bet tapiti a ipa ye Awaram le ise ye Dawiti nga, ngan pudi sangaul be balana pai. Lo ngan bet imadit ye Dawiti le ise ye kene yo di Babilon tikap di Yuda la titar di ye tana kidi nga, ngan di rara tina ngan pudi sangaul be balana pai. Lo ngan bet imadit mulu ye kene yo tinepe Babilon ye in le ise ye lal yo Kirisi pombe in nga, ngan di rara tina ngan pudi sangaul be balana pai lapau. ");
INSERT INTO apr_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Gasanga ke Yesu Kirisi yo tinana ipasuiu i, in ipa nen. Tinana yo Madia in titarkala pang Yosep bet iyooloo, bong yeru tigaua tiao, inbe tikamata Madia tani in kapono ye kase yo Maro Amunu Silene ikauu panga i. ");
INSERT INTO apr_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Ngan nintooroo yo Yosep i, in tool noonoonoo, le lono bet iwetewete Madia la mallangana a ipammoo la di tooltool le imot matadi tiap. Bong lon kaua urata bet ole ipas le isukraii mos leu le ikino sollono. ");
INSERT INTO apr_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Bong tina yo lon kaua urata nen nga, le mooloo tiap inbe bangabangana ke Tool Mai atu isi pombe pang ye, ye mianga ki a iwete panga. Iyei ne, “Yosep, ong in Dawiti natunu. Ken kutattadai a lom kap gogo dada belebele leu ye yo bet kouo Madia a kuyooloo, ngan be, yesoo kase yo kapono ye i, in Maro Amunu Silene la ikauu panga i. ");
INSERT INTO apr_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Le ole ipasuiu natunu tamoto, lo ngan bet kusu ene ye Yesu, yesoo ye la bet ole ipamulu di tooltool ki ye sennene kidi yo bet igarung di i.” ");
INSERT INTO apr_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Ngan so le imot yo pombe nga, ngan iyeie betanga ke Tool Mai yo mugu ngan iweta pang Maro koonoo a iweta in le kanono pombe moolmool. ");
INSERT INTO apr_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Ngan betanga tani in nen, “Garup atu yo iye tamoto sa tipa pitiao i, in ole kapono a ipasuiu natunu tamoto, lo ngan bet tisua ye Imanuel.” Ngan betanga tani yo Imanuel i, in punu ben, “Maro inepe yidi.” ");
INSERT INTO apr_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Yosep imi nen, le kene yo imadit ye in nga, ngan le iyei ben tina yo bangabangana ke Tool Mai iwete panga nga. Le ila la ikaua Madia tani a iyooloo, a iyei rimana. ");
INSERT INTO apr_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Bong kene yo iyooloo ye in nga, ngan le yeru tipa le tiken toko pitiap le lo Madia ipasuiu natunu tamoto tani. Motong la Yosep isua ye Yesu nga. ");
INSERT INTO apr_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Ye kene yo Madia ipasuiu Yesu ye malala mai tiap Betlem ye tana mai ke Yudia ye in nga, ngan Erot iyei tool kuto mai pang tana mai yo Yudia i. Inbe ye kene tani in di tooltool ke bet tikamata kanpitiki ngan lodi kaua urata ye nga, ngan pattu ke ni yo ke ipa ye a ise i, ngan tilo pang Yerusalem ");
INSERT INTO apr_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","lo tipa a titortor di tooltool nen. Tiyei ne, “Ai, kase mai tiap yo tinana ipasuiu a bet iyei tool kuto mai pang di Yuda i, in inepe ngai? Am nga amkamata kanpitiki iyei ben tarkilanga ki ye ni yo ke ipa ye a ise i, ngan nanga la amse bet se amsung panga nga.” ");
INSERT INTO apr_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Tiwete betanga nen, le di tooltool pattu la tillaikoodi pang Erot yo tool kuto mai i, in a ilongo, ngan le lon sakarungu le dook tiap yege. Inbe di tooltool ke Yerusalem yo tilongo betanga tani nga, ngan di le imot lodi sakarungu ye lapau. ");
INSERT INTO apr_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Ngan tina Erot ilongo betanga nen, le nga ikiu di tooltool maimai ke paroranga so pang Maro, inbe di pannoongoo ke wer ke Maro, ngan man tigaua. Motong la itor di nen, “Ai, ni yo Kirisi tinana ipasuiu ye i, in ngai?” ");
INSERT INTO apr_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Ngan tiraua betanga ki nen, “Ole tinana ipasuiu Betlem ye tana mai ke Yudia, yesoo mugu ngan Maro koonoo iwodo betanga nen ilo ye rau ngan iwete nen, ");
INSERT INTO apr_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Ang di tooltool ke Betlem yo kanepe ye tana mai kidi Yuda nga, ngan malala kiang o ke bet ipa mur mata ye di malala kapala yo edi maimai pang tana mai kidi Yuda, ngan tiap, yesoo tool yo bet matan kala di tooltool kiau ke Isrel i, in ole pombe ye malala kiang.’ ” ");
INSERT INTO apr_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Tiwete pang Erot nen, motong la ikiu di tooltool yo ke bet tikamata kanpitiki ngan lodi kaua urata ye nga, ngan sollono bet man iye di leu tigaua, inbe itor panin di ye soo lal moolmool yo kanpitiki pombe ye i. ");
INSERT INTO apr_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Itor panin di a imot, motong la iwanga di bet tila pang Betlem nga. Inbe iwete pang di nen, “Kala ngan kasere kase in dook le le kapusye. Le bet kapusye nga, ngan palbe leu be man kawete pau a nen ngan au lapau la akamata, a asung panga.” ");
INSERT INTO apr_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Ngan di tooltool yo lodi kaua urata ye di kanpitiki nga, ngan tilongo betanga ke Erot a imot, motong la tigege sila inepe, inbe tipa mulu. Ngan le tikamata kanpitiki tani yo tikamata mugu i, inbe titoo titoo le la tukbe ke ete le iken ye ni tani yo kase inepe ye i. ");
INSERT INTO apr_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Ye kene tani, in di tooltool tina ngan tikamata kanpitiki tani yo la tukbe nga, le lodi ponana mai san. ");
INSERT INTO apr_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Motong la tilo rumu lono a lo tikamata kase tani iye tinana Madia, motong tigun turudi le du damodi toko tana, inbe tisung panga. Motong la tipolo llugu kidi a tikap so dook mata panga; so ben pat dook mata yo ene gol i, inbe so dook mata san yo tarungu lo ye ei ngan kutana ikini dook mata i, inbe so ke saliningi kini ki dook mata san yo tiwete ene ye mir i. ");
INSERT INTO apr_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Le nga tinepe a nga tiken, ngan timi bet Maro iwete pang di nen, bet timulu a tila pang ye Erot be. Ngan la le titoo dada san a timulu a tidu pang ni kidi nga. ");
INSERT INTO apr_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Di tooltool tina ngan timulu a tidu, motong la bong a Yosep iken, ngan ikamata bangabangana ke Tool Mai ye mianga ki. Ngan bangabangana tani in iwete panga nen, “Yosep, kumadit a kouo kase in iye tinana a kakoo a kala pang tana mai Isip la kanepe nango le lo awete pong mulu ngan, yesoo Erot ni ngo ikapge bet isere kase i le ipusye nga, ngan ole iraumate a imata.” ");
INSERT INTO apr_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Yosep tani in imi nen, le nga imadit tina le ikaua Madia iye natunu bong a tikoo pang Isip, ");
INSERT INTO apr_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","a la tinepe tinepe le lo Erot tani in imata. Ngan nen le betanga yo Maro koonoo iwete nga, ngan kanono pombe moolmool. Mugu ngan Maro koonoo tani in iwete nen, “Natuk tamoto inepe Isip, le akiuu ngan la le igege Isip a iman nga.” ");
INSERT INTO apr_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Erot itar tinini ngan tool sa mala bet pombe pang ye a iwete panga tiap. Le nga lon tar nen, bet di tooltool tina yo ke bet lodi kaua urata ye kanpitiki nga, ngan o tillungu, le katen malmal dook tiap. Motong la iman tina le iwanga di tooltool ki ke patokongo bet la tiraumatamata di kakase tamoto ke Betlem inbe di kakase tamoto kapala yo tinepe potai pang Betlem yo rai kidi ru inbe isi pang lopo nga, ngan le imot. Yesoo, lal yo Yesu tinana ipasuiu ye i, in ikauu ye di tooltool yo lodi kaua urata ye kanpitiki, ngan oo. ");
INSERT INTO apr_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Ngan nen le betanga yo Maro koonoo Yedimia iweta i, in kanono pombe moolmool. ");
INSERT INTO apr_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Yedimia tani in iwete nen, “Tilongo tool atu itang meneng malala Rama ni, ngan itang le itang katkat dook tiap yege. Rakele la itang ye di natunu i, bong bet tilele, ngan ilongo kidi tiap, yesoo di natunu tina ngan timmata a imot oo.” ");
INSERT INTO apr_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Yosep iye Madia tinepe Isip le lo Erot imata, motong la bong atu ngan Yosep iken ngan imi bet bangabangana ke Tool Mai atu iwete panga nen. ");
INSERT INTO apr_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Iyei ne, “Yosep, kumadit a kouo Madia iye natunu a kamulu pang ye tana kidi Isrel, yesoo di tooltool yo lodi bet tiraumata kase i nga, ngan timmata oo.” ");
INSERT INTO apr_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Motong la Yosep imadit tina ngan le ikaua Madia iye natunu a timulu a tila pang ye tana kidi Isrel. ");
INSERT INTO apr_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Bong ngan Yosep ilongo bet Erot natunu Akilus in iloni a iyei tool kuto mai pang tana mai Yudia. Le nga Yosep itattadai bet imulu pang ni nga. Le ye mianga ki san mulu, ngan bangabangana ke Tool Mai iwete panga bet ila pang ni be, bong bet idik a ila pang ye tana mai san yo Galili i. ");
INSERT INTO apr_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Ngan tina ila nga, ngan le la inepe ye malala atu yo ene Nasaret i. Ngan le iyeie betanga kidi Maro koonoo yo tiweta in le kanono pombe moolmool. Ngan betanga tani in iwete nen, “Ole tiweta bet ye in tool ke Nasaret.” ");
INSERT INTO apr_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Ke kapala iman a ila, motong la ye ke atu in ngan Yowan yo irriu di tooltool i, in ipa le la pombe ye ni soorookoonoo atu ke tana mai Yudia, inbe iwetewete betanga ke Maro pang di tooltool. ");
INSERT INTO apr_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Ngan iwete pang di nen, “Kaportak lomu, yesoo ole mooloo tiap, inbe dada yo Maro bet matan kala di tooltool ki ye i, in ole si pombe mallangana.” ");
INSERT INTO apr_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Yowan tani, in mukot ngan Maro koonoo yo Esai i, in iwetewete ye nen, “Ole kalongo tool atu kalngana ye ni soorookoonoo, in iwete le koonoo maimai nen, ‘Kakarata dada pang Tool Mai, inbe kayeii le dundunngana panga bet ipa ye.’” ");
INSERT INTO apr_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Yowan tani in sousoungu ki ngan tikarata ye asara ke solanga burum yo ene kamel in bulbulini. Inbe iwittoo galini ye bittoongoo ki yo tikarata ye asara kulini i. E kaningi ki yo ikan nga, ngan ikan sis inbe iyin bagil surunu. ");
INSERT INTO apr_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Ye kene tani in di tooltool yo tipa pang ye nga, ngan kapala tipa ke Yerusalem, inbe ke malala maimai tiap ke Yudia nga le imot. Inbe di tooltool ke malala kapala le imot yo iken potai pang ye ran Yodan, ngan di lapau la timan pang ye nga. ");
INSERT INTO apr_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Di tooltool tina timan, motong la titulu lodi panga ye sennene kidi, inbe irriu di ye ran Yodan. ");
INSERT INTO apr_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Bong yeiso bet Yowan ikamata di tooltool ke budanga ru yo tiwete edi ye di Paresi le di Sedusi, ngan alunu timan pang ye a bet man irriu di, motong la iwete pang di nen, “Ai, ang ngan ben moto dook tiap di natunu! Sei iwete bet kayei nen ngan ole kasuru kate malmal ke Maro yo bet pang dama ni ngan pombe i? ");
INSERT INTO apr_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Kumata le bet kaportak lomu moolmool nga, ngan ole tikamatang ye dada kiang yo kayei nga ben ang ngan kaportak lomu moolmool. ");
INSERT INTO apr_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Inbe ken lomu tar bet ang ngan tamamu la Awaram i, a bet nen ngan Maro igarungang tiap, ngan be. Awete pang nen, Maro ke bet iportak di pat nga le tiyei ben Awaram di natunu. ");
INSERT INTO apr_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Ngan matau nain la iken kai punu in. Ngan la kai le imot yo tipu ngan titar kanodi dook mata ngan tiap nga, ngan ole Maro itarakat di a ikatte di lo ei lono. ");
INSERT INTO apr_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“Ang di tooltool yo kaportak lomu nga, ngan au i arriu ang ye ran leu. Bong tool yo bet itoo au a isi i, in gurana ki mai san le illosau. Ngan nen le akamatau ben au i tool dook mata ke bet aloni ben poranga ki a akap loningi ke kene a ade in tiap. Ngan tool tani in ole irriu ang ye Maro Amunu Silene ipa ye ei. ");
INSERT INTO apr_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Ye in yoo ke pitiningi in iken ye bene, le ole itaurai dingding patunu ke kaningi le igaun yo kanono ngan ilo ye badabada ki, inbe kulini ngan idaun di ye ei yo ikan nen le taukan motingi i.” ");
INSERT INTO apr_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Ye kene tani yo Yowan irriu di tooltool ye in nga, ngan Yesu ipa ke Galili a iman pang ran Yodan bet man Yowan irriuu lapau. ");
INSERT INTO apr_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Bong Yowan ikapge bet ilele Yesu a iyei nen be. Le nga iwete panga nen, “Ai, au i la ke bet kurriu au i. E nga gelei bet kuman pang yau bet man arriu ong nga?” ");
INSERT INTO apr_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Bong ngan Yesu iraua betanga ki nen, “Lom leu, inbe kuyei urata i dookoot nga, yesoo nga dook mata bet aru tayei nen, a bet nen ngan tatoo dada dook mata noonoonoo le imot yo Maro lono panga nga.” Ngan nen le Yowan ipas le itoo leu. ");
INSERT INTO apr_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Yowan irriuu a imot, motong Yesu imulu ke ran lono a ise pang ete, ngan pattu leu be lang katene koon panganga, inbe ikamata Maro Amunu Silene iro a isi pang ye ben man utu bet si iwot ye. ");
INSERT INTO apr_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Inbe tool atu kalngana iwetewete ke malala ke Maro a isi nen. Iyei ne, “Tool in au natuk. Au i lok panga mai san, inbe lok ponana ye.” ");
INSERT INTO apr_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Motong la Maro Amunu Silene ipasongosongo Yesu bet ila pang ye ni soorookoonoo atu, a bet nen ngan la tool kuto mai kidi so sidi itoua. ");
INSERT INTO apr_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Ngan la Yesu yetaleu inepe ye ni tani nga, ngan isapariuu le ikan so tiap ye ke le bong sangaul pai le pitolo belebele. ");
INSERT INTO apr_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Motong la tool dook tiap ke touanga i, in man pombe pang ye a iwete panga nen, “Ai, bet ong i Maro natunu moolmool nga, ngan kuwete a pat nga tiportak le tiyei porong a kon.” ");
INSERT INTO apr_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Bong ngan Yesu iraua betanga ki nen, “Rau ke Maro iwete nen, ‘Porong leu la bet itoko di tooltool ye nepongo kidi, in tiap, bong betanga le imot yo ipa ye Maro koonoo nga, ngan la itoko di tooltool ye nepongo kidi nga.’ ” ");
INSERT INTO apr_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Motong la tool kuto mai kidi so sidi tani in ikaua Yesu a yeru tilo ye malala mison ke Maro yo Yerusalem i, a lo ipatokode le ikodo bareme mai ke sungunu pono meneng ete ni, inbe iwete panga nen. Iyei ne, ");
INSERT INTO apr_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","“Bet ong i Maro natunu moolmool nga, ngan kupas le kudu tana ni, yesoo Rau ke Maro iwete nen, ‘Ole iwanga di bangabangana ki pong a tisipong ye bedi, a bet nen ngan pat isolo kem katene be.’ ” ");
INSERT INTO apr_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Bong ngan Yesu iraua betanga ki nen, “Rau ke Maro iwete lapau nen, ‘Ken kutouo Maro yo Tool Mai kiong, in be.’ ” ");
INSERT INTO apr_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Motong la tool kuto mai kidi so sidi tani in ikaua Yesu mulu a yeru tilo kawal kutono meneng ete ni, a lo ipitnai malala le so matana matana ke tana mai i le imot yo dook mata nga, ngan panga. ");
INSERT INTO apr_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Motong la iwete panga nen, “Kumata bet kugun turum le du damom toko tana, inbe kusung pau nga, ngan ole akap so nga le imot pong.” ");
INSERT INTO apr_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Bong ngan Yesu iraua betanga ki nen, “Satan, kukoo yau! Yesoo, Rau ke Maro iwete nen, ‘Kusung pang Maro yo Tool Mai kiong i, inbe kuraua panga yetaleu.’ ” ");
INSERT INTO apr_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Yesu iwete nen pang tool kuto mai kidi so sidi tani a ikoo ye, motong la di bangabangana ke Maro tisi a si tiloni. ");
INSERT INTO apr_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Ye kene yo Yesu ilongo bingi ke Yowan yo titaru lo rumu dook tiap kidi talnga dikidiki lono ye in nga, le nga imulu a ilo pang tana mai Galili. ");
INSERT INTO apr_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Ilo, ngan le igege malala Nasaret, inbe la inepe ye malala mai yo ene Kapenam i. Ngan malala mai Kapenam tani in iken potai pang ye ran Galili gigini, ye tana ke di rara kidi Sebulen le Naptali. ");
INSERT INTO apr_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Ngan ye dada tani yo Yesu iyeii nen i, in le iyeie betanga ke Maro koonoo Esai yo iweta in le kanono pombe. Ngan Esai tani in iyei ne, ");
INSERT INTO apr_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Ang di rara ke Sebulen le Naptali nga kalongo. Ang ngan di tooltool yo kanepe pang ke tiek du nga, inbe ang ngan di tooltool yo kanepe potai pang ye ran Yodan koonoo kapala nga, inbe ang ngan di tooltool yo kanepe ye tana mai Galili ye ni yo di tooltool yo tipa ye di rara kidi Yuda tiap ngan tinepe ye i. ");
INSERT INTO apr_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Di tooltool kiang yo tinepe todo lono nga, ngan tikamata sul maiyoko. Inbe di tooltool kiang yo todo mai ke matenge iduk di nga, ngan sul tani in ilangarai di lapau.” ");
INSERT INTO apr_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Ye kene tani in Yesu ipamaditi urata ki ke bet iwetewete bingi dook mata ke Maro pang di tooltool. Ngan le iwete pang di nen, “Kaportak lomu, yesoo mooloo tiap, inbe dada yo Maro bet matan kala di tooltool ki ye i, in ole si pombe mallangana.” ");
INSERT INTO apr_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Motong la Yesu ipelele ran koonoo Galili a ila, ngan ikamata di tooltool ru, yeru ngan taidi le toodi. Ngan atu, in ene la Simon i, inbe tiwete ene san ye Pita, in iye taini yo Antares i. Yeru ngan tikatte pu kidi du ran lono a bet tikap i ye, yesoo di ngan tiyei urata ye kaungu i bet tiyawar a tikap pat ye. ");
INSERT INTO apr_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Bong ngan Yesu ipusye di nga, le nga iwete pang di nen, “Suru nga, kaman katoo au. Ang ngan di tooltool ke kaungu i, bong ole apatomonai ang ye urata ke kaungu di tooltool.” ");
INSERT INTO apr_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Yeiso bet iwete pang di nen, ngan le pattu leu inbe yeru tigege pu kidi sila ikino, inbe titoo a tiye tila. ");
INSERT INTO apr_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Yesu iye di suru tina ngan tipa kasin a tila, inbe ikamata di tooltool ru mulu, ngan taidi le toodi lapau. Di tooltool ru tina, ngan atu ene la Yemis yo Sebedi natunu i, in iye taini Yowan. Di ngan tiye tamadi Sebedi tinepe ookoo pono kidi a tikarata pu kidi, inbe Yesu ikamata di le nga koonoo pang di bet titoo lapau. ");
INSERT INTO apr_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Yeiso bet yeru tilongo tina yo koonoo pang di nga, ngan le pattu leu inbe tigege tamadi sila inepe ye ookoo kidi tani, inbe yeru timadit a titoo Yesu a tila. ");
INSERT INTO apr_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Yesu ila ipa ye malala kapala ke tana mai Galili in le imot a ipatomonai di tooltool ye rumu kidi Yuda ke gaongo in lono, inbe iwetewete bingi dook mata pang di tooltool ye dada yo Maro bet matan kala di tooltool ki ye i. Inbe ikarata di tooltool yo matamatenge matana matana ikap di nga, ngan le tinidi dook mata mulu. ");
INSERT INTO apr_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Ngan ye urata tina yo Yesu iyei nen nga, ngan bingi ki idada a iwakaia tana mai Siria in le imot a tilonga, le nga tikap di tooltool yo matamatenge matana matana ikap di ngan pang ye Yesu a bet man iyei di le tinidi dook mata mulu. Le nga di tooltool yo tinidi massingi mai mata nga, inbe di tooltool yo so sidi idiwidiwi di nga, inbe di tooltool yo matadi taltalai ngan timol du tana a titangarur nga, inbe di tooltool yo tikap rama nga, ngan timan pang ye Yesu, inbe iyei di le tinidi dook mata mulu. ");
INSERT INTO apr_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Ngan tina tilongo bingi ke Yesu yo iyei urata nen nga, le nga di tooltool alunu le alunu san tipa ke Galili, inbe ke Dekapolis, inbe ke Yerusalem le tana mai Yudia, inbe di tooltool kapala tipa ke malala le imot yo iken ke ran Yodan koonoo kapala nga, ngan di le imot la tipa a titoo Yesu nga. ");
INSERT INTO apr_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Yesu ikamata di tooltool alunu tina timan pang ye nga, le nga ilo ye kawal atu madini a lo iwur, inbe di galiunu timan pang ye. ");
INSERT INTO apr_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Motong la imadit a bet ipatomonai di, ngan le iwete nen, ");
INSERT INTO apr_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Di tooltool yo lodi galanga ben di ngan ballingadi tiap ye so ke Maro nga, ngan lodi ponana, yesoo Maro ole iyei urata dook mata pang di a matan kala di. ");
INSERT INTO apr_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Inbe di tooltool yo lodi madoko nga, ngan lodi ponana, yesoo Maro ole iyei urata dook mata pang di a ipamede di. ");
INSERT INTO apr_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Inbe di tooltool yo pallongadi nga, ngan lodi ponana, yesoo Maro ole iyei urata dook mata pang di a ikaua tana mai i le imot pang di. ");
INSERT INTO apr_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Inbe di tooltool yo pitolo di le morak di ye dada dook mata noonoonoo ke Maro nga, ngan lodi ponana, yesoo Maro ole iyei urata dook mata pang di a ipapon di ye. ");
INSERT INTO apr_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Inbe di tooltool yo lodi mulumulu ye di tooltool kapala a tiyei dada dook mata pang di nga, ngan lodi ponana, yesoo Maro ole iyei urata dook mata pang di a lon mulumulu ye di lapau. ");
INSERT INTO apr_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Inbe di tooltool yo lodi iken galangana nga, ngan lodi ponana, yesoo Maro ole iyei urata dook mata pang di le tikamata matana. ");
INSERT INTO apr_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Inbe di tooltool ke karatanga di tooltool kapala lodi a bet tinepe ye lo silene nga, ngan lodi ponana, yesoo Maro ole iyei urata dook mata pang di, inbe ole tikiu di bet di ngan ye di natunu. ");
INSERT INTO apr_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Inbe di tooltool yo di tooltool kapala tikap malmal pang di a tigarung di ye yo titoo dada dook mata noonoonoo ke Maro nga, ngan lodi ponana, yesoo Maro ole iyei urata dook mata pang di a matan kala di. ");
INSERT INTO apr_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Inbe ang di tooltool yo di tooltool kapala lodi dook tiap pang a tingelerai ang inbe tigarungang a tisopo koodi pang ye betanga doko ye yo katoo au nga, ngan lomu ponana, yesoo Maro ole iyei dada dook mata pang. ");
INSERT INTO apr_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Bong bet tiyei urata nen pang nga, ngan lomu ponana a kayoro, yesoo balingi ke urata kootoonoo kiang la inamang a iken ye malala ke Maro ngo. Ngan dada dook tiap kidi yo nen nga, ngan la mugu ngan tiyei pang di Maro koonoo nga. ");
INSERT INTO apr_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Ang ngan kayei ben tiek pang di tooltool ke tana mai i le imot. Bong kumata bet tiek tani in gurana ki imot nga, ngan ole kayeie tiek tani in balai bet iyei tiek mulu nga? Tiek yo nen i, in dook tiap oo, le ke bet tayeie so sa mulu ye tiap. Le bet nen ngan takatte du tana pono a bet nen ngan di tooltool tiyirtoo ye kedi. ");
INSERT INTO apr_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Inbe ang ngan kayei ben sul pang di tooltool ke tana mai i le imot. Le matamu too dook ngan, kumata le malala mai sa bet iken kawal kutono nga, ngan o ke bet itarkoo tiap. ");
INSERT INTO apr_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Inbe di tooltool ke bet tilanga sul ngan tipatudu ye bor tiap. Bong ole tipawoti lo ete a ikan le ilangaraia rumu lono, a bet nen ngan di tooltool tikamata ni ye. ");
INSERT INTO apr_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Le gaongo leu, ang nga kanepe ben sul yo ilangaraia ni i, a bet nen ngan di tooltool ole tikamata dada dook mata kiang yo kayei nga, inbe tiyitmaka Tamamu yo inepe ye malala ki ete ni, in ene. ");
INSERT INTO apr_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Ken lomu tarau bet au asi nga bet si agarung wer ke Maro too betanga yo kidi Maro koonoo, ngan be. Au i asi nga bet si agarung tiap, bong asi bet si ayei betanga tina ngan a kanono pombe le imot. ");
INSERT INTO apr_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Awete pang moolmool nen, betanga yo iken ye wer ke Maro ngan o ke bet kasin pa bet ilene, ngan tiap. Ole iken nen le imot le ipa ye wodenge ki yo maimai tiap nga, le ilo ye lal yo bet lang le tana imot ye i. Le betanga tina le imot yo iken ye wer ke Maro nga, ngan ole kanono pombe le imot. ");
INSERT INTO apr_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Ngan nen le kumata bet tooltool sa iwala murini pang betanga mai tiap atu yo iken ye wer ke Maro nga, too ipatomonai di tooltool kapala bet tiyei dada gaongo nen i, in ole ene mai tiap ye di tooltool yo Maro bet matan kala di nga. Bong sei tool yo itoo wer le betanga tina ke Mose nga le imot, inbe ipatomonai di tooltool ye a bet titoo i, in ole ene mai ye di tooltool yo Maro bet matan kala di nga. ");
INSERT INTO apr_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Awete pobe pang nen, kumata le dada kiang yo kayei nga bet itoo dada dook mata noonoonoo ke Maro le illos dada kidi Paresi le di pannoongoo ke wer ke Maro, ngan tiap nga, ngan o ke bet lo kagaua ye di tooltool yo Maro bet matan kala di, ngan tiap yege. ");
INSERT INTO apr_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Ang nga kalongo betanga yo mugu ngan tiweta pang di sasa kiidi, in oo. Ngan betanga tani in nen, ‘Ken karaumata di tooltool be. Kumata le tool sa bet iraumata tool atu nga, ngan ole tikauu lo tipatokode ye ni ke karatanga betanga a ikap masngana ye dada ki tani yo iyeii i.’ ");
INSERT INTO apr_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Bong nga bet awete pang nen, kumata le tool sa bet katen malmal pang ene atu nga, ngan ole tikauu lo tipatokode ye ni ke karatanga betanga a ikap masngana ye dada ki tani. E le kumata tool sa bet iwete pang ene bet ye in tool dook tiap nga, ngan ole tikauu lo ye di tooltool kuto maimai ke karatanga betanga. Bong kumata le tool sa bet iwete pang ene bet ye in tool kapakapa nga, ngan ken ikauwai ye dook, ole nen ngan Maro ikatte du inepe ye malala ke masngana yo ei ikan ye le taukan motingi i. ");
INSERT INTO apr_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","“Ngan la kumata bet kop so ke paroranga pang ni ke paroranga so, inbe lom tutu urata dook tiap yo mugu ngan kuyei pang em a katen malmal pong nga, ");
INSERT INTO apr_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","ngan kutar so kiong tina sila dama ke ni ke paroranga so in. Inbe kulkulunu ngan ole kumulu le la kuye em tani in kakarata betanga le dook ngan, lo ngan bet kumulu man kuyei paroranga ye so tina ngan pang Maro. ");
INSERT INTO apr_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Inbe kumata le tool atu lono bet ikau ong pang ye ni ke karatanga betanga le angru kapa dada go nga, ngan palbe be angru kakarata betanga tani in dada le imot. Kumata bet tiap nga, ngan ole em tani in ikau ong lo ye di tooltool maimai ke karatanga betanga a titarong kula ye di gaunu bedi, a bet nen ngan di gaunu titarong lo ye rumu dook tiap kidi talnga dikidiki lono. ");
INSERT INTO apr_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Awete pong moolmool nen, taukam dada yo bet kupas a kusi tana ye i. Bong ole kunepe so rumu dook tiap kidi talnga dikidiki tani in lono, le lo kuyimi porai pat pi yo titar pong bet kuyimi rumu tani in ye nga, ngan le imot, ngan la bet kusi tana nga. ");
INSERT INTO apr_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Ang nga kalongo betanga yo mugu ngan tiweta, in oo. Ngan betanga tani in nen, ‘Ken kayei bauk be.’ ");
INSERT INTO apr_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Bong nga bet awete pang nen, kumata le tool atu bet ikamata garup atu ngan matana gorengana ye le lon kaua urata ye bet yeru tipa nga, ngan tool in ben iyeie dada dook tiap ke bauk ye garup tani in ye yo lon kaua urata ye nen nga. ");
INSERT INTO apr_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","“Le kumata bet matam oonoo in iyolong le bet kopsap ye sennene nga, ngan kupaii a kotte. Ngan dook mata bet kugege tinim kapala a ikino, ngan la bet tinim le imot in o ke bet tikatte du ye malala ke masngana tiap nga. ");
INSERT INTO apr_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Inbe kumata bet bem oonoo iyolong le kopsap ye sennene nga, ngan kusaputu a kotte. Ngan dook mata bet kugege tinim kapala a ikino, ngan la bet tinim le imot in o ke bet tikatte du ye malala ke masngana tiap nga. ");
INSERT INTO apr_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Ang nga kalongo betanga yo mugu ngan tiweta, in oo. Ngan betanga tani in nen, ‘Kumata le tool atu lono bet isukraia rimana nga, ngan ole ikaua rau yo tiwodo betanga ke parsukraingi ilo ye i, in pang rimana.’ ");
INSERT INTO apr_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Bong nga bet awete pang nen, kumata bet tamoto atu rimana iyei bauk tiap, inbe isukraii sorok nga, ngan tamoto in ikapsap, yesoo iyeie garup in le ikapsap ye dada ke kerenge. Le kumata bet garup tani in iyooloo tamoto san nga, ngan garup in iyei dada dook tiap ke bauk. Inbe tamoto paunu yo iyooloo garup tani yo nintooroo isukraii in nga, ngan ye in iyei dada dook tiap ke bauk lapau. ");
INSERT INTO apr_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Ang nga kalongo betanga yo mugu ngan tiweta pang di sasa kiidi, in oo. Ngan betanga tani in nen, ‘Bet kapamede betanga ye so atu bet kayeii nga, ngan ken kagarungu be. Bong kayeie so tani yo kapamede betanga pang Tool Mai ye bet ole kayeii i.’ ");
INSERT INTO apr_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Bong nga bet awete pang nen, bet kapamede betanga kiang nga, ngan ken kawete moolmool le ete be. Inbe ken kapootoo malala ke Maro ene a bet kapamede betanga kiang ye be, yesoo malala ke Maro in kakawa ki ke burungu. ");
INSERT INTO apr_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Inbe ken kapootoo tana ene a bet kapamede betanga kiang ye be, yesoo tana i la Maro itar kene lo pono i. Inbe ken kapootoo Yerusalem ene a bet kapamede betanga kiang ye be, yesoo Yerusalem in malala mai ke Tool Mai yo iyei tool kuto mai pang tana mai le imot i. ");
INSERT INTO apr_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Inbe ken kapootoo kutomu a bet kapamede betanga kiang ye be, yesoo ang tapmu nga taukamu gurana yo bet kayeie kutomu raunu atu le ikoko too imukku ye i. ");
INSERT INTO apr_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Ngan nanga, bet nen ngan kapas le kayei ne, ‘E’ ngan ‘E’ le iken leu, too bet kayei ne, ‘Tiap’ ngan ‘Tiap’ le iken leu. Bong bet kawete betanga san mulu le ipa ye betanga yo bet kawete nga, ngan betanga yo ngan ipa ye tool dook tiap Satan. ");
INSERT INTO apr_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Ang nga kalongo betanga yo mugu ngan tiweta, in oo. Ngan betanga tani in nen, ‘Kumata bet tool atu igarungu ene matana nga, ngan ole kakaua tool tani in kootoonoo a kagarungu ene tani in matana lapau. Inbe kumata bet tool atu iraukata ene dongana nga, ngan kakaua tool tani in kootoonoo a karaukata ene tani in dongana lapau.’ ");
INSERT INTO apr_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Bong nga bet awete pang nen, ken karau kiang a kayei dada gaongo leu pang di tooltool yo tiyei dada dook tiap pang, ngan be. Kumata bet tool atu ipodo pangam oonoo nga, ngan kuportak le kupasanga pangam ngas pang ye. ");
INSERT INTO apr_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Inbe kumata bet tool atu ikau ong pang ye ni ke karatanga betanga a iwete pong bet kouo sousoungu kiong yo mannipunu in panga nga, ngan bet nen ngan kouo sousoungu kiong yo matolene in panga lapau. ");
INSERT INTO apr_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Inbe kumata bet tool atu iwete le koon mede ye betanga pong bet kusolo burum ki a bet kupa ye manga mooloo atu nga, ngan kumalum panga a angru kapa ye manga mooloo san mulu le lo iyei ben manga mooloo ru. ");
INSERT INTO apr_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Inbe kumata bet tool sa itorong ye so kiong nga, ngan kouo so yo itorong ye i, in panga. E kumata le tool sa lono bet ikaua so kiong sa bet iyei urata ki ye lo ngan bet ipamule pang yong nga, ngan kurutaii be. ");
INSERT INTO apr_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Ang nga kalongo betanga yo mugu ngan tiweta, in oo. Ngan betanga tani in nen, ‘Lomu pang di diemu mai san, inbe lomu dook tiap pang di koi kiang.’ ");
INSERT INTO apr_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Bong nga bet awete pang nen, lomu pang di koi kiang mai san, inbe kapatarau pang Maro ye di tooltool yo tikamatang ngan katoo au a le tigarungang nga. ");
INSERT INTO apr_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Kumata bet kayei dada nen nga, ngan ole tikamatang ben ang ngan Maro di natunu. Ngan ye in iyeie ke ki le isini ye di tooltool yo dook mata nga, inbe ye di tooltool yo dook tiap nga lapau. Inbe iyeie ki a imol pang di tooltool yo titoo dada dook mata noonoonoo ke Maro nga, inbe pang di tooltool yo titoo dada dook mata noonoonoo ki tiap, ngan lapau. ");
INSERT INTO apr_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Inbe kumata le bet lomu mai san pang di tooltool yo lodi mai san pang, ngan leu nga, ngan ole kakaua soo balingi ye urata kootoonoo kiang? Gelei, di tooltool ke sodaningi pat o tiyei dada nen tiap, too? ");
INSERT INTO apr_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Inbe kumata le bet kawete lo ponana kiang dook mata pang di sogamu leu nga, ngan soo dada kayeii le kallos di tooltool kapala ye i? Di tooltool yo lodi galanga ye Maro tiap ngan tiyei dada nen lapau. ");
INSERT INTO apr_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Ngan nanga, ole katoo dada dook mata noonoonoo le imot, dawa ben Tamamu yo inepe ye malala ki ete ni, in itoo dada dook mata noonoonoo le imot nga.” ");
INSERT INTO apr_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Motong la Yesu iwete pang di galiunu mulu nen, “Ken kakap tutang dook leu ye dada dook mata noonoonoo ke Maro yo bet kayei nga. Le ken kayei la di tooltool matadi a bet tikamata ngan tiyitmak emu ye, ngan be. Kumata bet kayei nen nga, ngan o ke bet kakaua balingi sa ye urata kootoonoo kiang ye Tamamu yo inepe ye malala ki ete ni, in tiap. ");
INSERT INTO apr_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Ye kene yo lomu bet kakap so pang di tooltool yo timaka ye so nga, ngan ken kamaia so dawa ben tauru a kawete pang di tooltool ye so tina, ngan be. Dada yo nen i, in kidi tooltool ke kaplungunu. Di ngan lodi bet tiyei nen ye rumu kidi Yuda ke gaongo, too ye ni ke yawaringi so, a bet nen ngan di tooltool tiyitmak edi ye. Bong awete pang moolmool nen, di tooltool yo tiyei dada nen nga, ngan tikap balingi ye urata kootoonoo kidi oo. ");
INSERT INTO apr_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Bong ye kene yo bet kalon di tooltool yo timaka ye so nga, ngan ken le bemu ngas in lon galanga ye so yo bet bemu oonoo iyei, ngan be, ");
INSERT INTO apr_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","a bet nen ngan katarkoo dada dook mata kiang le iken sollono. Ngan la bet Tamamu yo ikamata so yo iken sollono i, in ole ikap balingi pang ye urata kootoonoo kiang nga. ");
INSERT INTO apr_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Ye kene yo bet kapatarau ye in nga, ngan ken kayei ben di tooltool ke kaplungunu yo tiyei, ngan be. Di ngan lodi bet tikodo dama kidi tooltool ye rumu kidi Yuda ke gaongo inbe ye ni ke yawaringi so, inbe tipatarau a bet nen ngan di tooltool tikamata di, ngan tiyitmak edi. Bong awete pang moolmool nen, di tooltool yo tiyei dada nen nga, ngan tikap balingi ye urata kootoonoo kidi oo. ");
INSERT INTO apr_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Bong ang nga ye kene yo bet kapatarau ye in nga, ngan kalo rumu lono kiang a katiukala dada, inbe kapatarau pang Tamamu yo ke bet takamata tiap i. Ngan la bet Tamamu yo ikamata so yo iken sollono i, in ole ikap balingi pang ye urata kootoonoo kiang nga. ");
INSERT INTO apr_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Inbe ye kene yo bet kapatarau ye in nga, ngan ken kawete gogo betanga a kayolo pataraungu ben di tooltool yo lodi galanga ye Maro tiap ngan tiyei, nga be. Yesoo, di ngan lodi tar bet tiwete tootoo betanga nen ilo ye pataraungu kidi le mooloo, ngan la bet Maro ole ilongo pataraungu kidi nga. ");
INSERT INTO apr_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Le ken katoo dada kidi be, yesoo soo so yo lomu bet Tamamu ilonang ye nga, ngan ye in lon galanga ye mukot, motong la katoru ye nga. ");
INSERT INTO apr_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Le dada dook mata yo bet kapatarau ngan katoo in nen. Kayei ne, ‘Tamamam yo kunepe ye malala kiong ete ni, in ampatarau pong nen, bet di tooltool nga le imot tiparanaia em. ");
INSERT INTO apr_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Inbe kusi a si matam kalam am le imot, inbe di tooltool ke tana i bet titoo lom dawa ben di tooltool ke malala kiong titoo lom nga. ");
INSERT INTO apr_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Inbe kaningi yo ke katai nga, ngan kop pam. ");
INSERT INTO apr_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Inbe kugiri sennene kiam yo amyei nga, dawa ben am lapau amgiri sennene kidi diemam yo tiyei pam nga. ");
INSERT INTO apr_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Inbe kupasongosongam le ken amkapsap ye dada dook tiap ke touanga be, bong kou am le kupalisam ye tool dook tiap Satan.’ ");
INSERT INTO apr_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Nen le kumata bet di tooltool tiyei dada dook tiap ke sennene pang nga, ngan kagiri sennene kidi tina yo tiyei nga. Ngan la bet Tamamu yo inepe ye malala ki ete ni, in ole igiri sennene kiang lapau nga. ");
INSERT INTO apr_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Bong kumata le bet kagiri sennene kidi tooltool tiap nga, ngan Tamamu o ke bet igiri sennene kiang tiap lapau. ");
INSERT INTO apr_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Kene yo bet kasapa ye kaningi so a bet kasung pang Maro ye in nga, ngan ken kayei ang le matamu mallai ben di tooltool ke kaplungunu tiyei, ngan be. Yesoo, di ngan tiyei di tapdi le matadi mallai a bet tipitnai di pang di tooltool a tikamata di ngan tiyei ne, ‘Tool ni ngo ye taunu isapariuu ye kaningi so a bet isung pang Maro.’ Bong awete pang moolmool nen, di tooltool yo tiyei dada nen nga, ngan tikap balingi ye urata kootoonoo kidi oo. ");
INSERT INTO apr_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Bong bet kusapa ye kaningi so nga, ngan kupusu matam ye ran, inbe kusalini kutom ye so ke saliningi. ");
INSERT INTO apr_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Ngan kayei nen a bet nen ngan di tooltool lodi galanga yang ye yo kasapa ye kaningi so, ngan be. Bong Tamamu yo ke bet takamata tiap i, in yetaleu la bet lon galanga yang i. Tamamu tani yo lon galanga ye so yo iken sollono i, in ole ikap balingi pang ye urata kootoonoo kiang. ");
INSERT INTO apr_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Ken burum le balingi ke tana pono nga ikap matamu a kawinnoko be. Yesoo, balingi yo ke tana pono nga, ngan rapa le piroro tigarung, inbe di tooltool ke pinnau ole tisaua koongoo le siri a lo tipinau lapau. ");
INSERT INTO apr_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Bong dook mata ngan nen, bet ang tapmu kawinnoko burum le balingi yo Maro bet ikap pang ye urata kootoonoo kiang nga. Yesoo, malala ke Maro yo iken ete ni, in rapa le piroro sa bet tigarung so ki tiap, inbe di tooltool ke pinnau sa ke bet tisaua koongoo le siri ki a lo tipinau so ki, ngan tiap lapau. ");
INSERT INTO apr_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Ngan la malala tani yo so dook mata kiang iken ye i, in ole kagaua lomu le imot pang ye lapau. ");
INSERT INTO apr_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Ngan matamu ngan dawa ben sul. Le kumata bet matamu igalanga dook mata nga, ngan ole sul lulngana ilangaraia tinimu mai i le imot inbe kakamata ni. ");
INSERT INTO apr_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Bong kumata bet matamu igalanga tiap nga, ngan ole todo iduku tinimu mai i le imot inbe kakamata ni tiap. Ngan nanga, kumata le sul lulngana yo bet iken lomu in todo iduku nga, ngan ole todo tani yo iken lomu i, in todo maiyoko. ");
INSERT INTO apr_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Tool sa ke bet iyei urata pang di tooltool kuto maimai ru tiap. Kumata bet iyei nen nga, ngan ole lono dook mata pang atu le ilongo betanga ki a itoo, inbe lono dook tiap pang san a iwala murini panga. Le ang nga ke bet kayei urata pang Maro, inbe kayei urata ke kaungu pat lapau tiap. ");
INSERT INTO apr_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Le nga bet awete pang nen, ken lomu madoko ye nepongo kiang ke tana i, ye so yo bet kakap a kakan le kayin, nga be. Inbe ken lomu madoko ye tinimu ye so yo bet kawit a itarkoo tinimu, nga be. Ngan ye Maro matana nga, ngan nepongo kiang, in so maiyoko, bong so yo bet kakap a kakan, in so mai tiap. Inbe tinimu nga lapau, ngan illoso so yo bet kawit a katarkoo ye nga. ");
INSERT INTO apr_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Oo, kakamata di man. Di ngan tikapgi so kumu le itar kanono, lo ngan bet tigogo kanono, ngan tiap. Inbe di ngan ke bet tire badabada yo bet titar kaningi kidi ye nga, ngan tiap lapau, bong Tamamu yo inepe ye malala ki ete ni, in ye la ipakan di i. Le awete pang nen, ang tooltool nga, Maro ikamatang ben ang nga kallos di man ye matana. ");
INSERT INTO apr_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Ngan nanga, bet ang tina ngan atu lon madoko ye so yo bet iloni ye nepongo ki ke tana i nga, ngan ole gelei, urata tani yo iyeii nen i, in ole iloni ye nepongo ki a iseke kasin pang dama a ila, too? O tiap! ");
INSERT INTO apr_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“E nga gelei a lomu madoko mai mata ye so ke lonloningi nga? Oo, kakamata di ool ke karam lono yo tisup nga. Di tapdi ngan tiyei toko urata sa bet tikarata moro pang di ye, ngan tiap. ");
INSERT INTO apr_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Bong nga bet awete pang ye tool kuto mai yo Solomon i. Ye in tool ballingana, le moro ki yo itar lo tinini nga, ngan dook mata san. Bong di ool tina nga, ngan moro kidi ngan dook mata le dook mata ki taunu le illos moro yo ke Solomon nga. ");
INSERT INTO apr_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Atoo, ang nga katara lomu medana pang Maro mai mata tiap. Kakamata, dingding sorok yo ke bet tikodo katai nga leu, e mongmong ngan tisaput a tikatte lo ei ikan di nga, ngan Maro ikap moro dook mata pang di. Le gelei, ang nga o ke bet ikap moro dook mata pang tiap, too? O tiap! Dada dook mata yo bet iyei pang ngan ole illos dada dook mata yo iyei pang di ool le dingding nga. ");
INSERT INTO apr_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Le ken lomu madoko a kayei ne, ‘Nga ole takana soo so?’ too ‘Nga ole tayini soo so?’ too ‘Nga ole talonlon ye soo so?’ ngan be. ");
INSERT INTO apr_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Di tooltool yo lodi galanga ye Maro tiap nga, ngan lodi kap gogo dada bet tikap so yo nen nga. Bong Tamamu yo inepe ye malala ki ete ni, in lon galanga ye so yo kamaka ye, ngan oo. ");
INSERT INTO apr_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Bong dada dook mata yo bet kayeii le imugu pang i, in nen. Kakau ang pang Maro a matan kalang ben ang ngan di tooltool ki, inbe kakapge bet katoo dada dook mata noonoonoo yo Maro lono bet katoo nga. Ngan kumata le bet kayei nen nga, ngan ole ikap so tina nga le imot pang. ");
INSERT INTO apr_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Le bet nen ngan ken lomu madoko mata ye so yo ke mongmong, ngan be. So ke mongmong, ngan so ki ye taunu bet lon madoko ye. Inbe so ke katai, ngan so ke katai leu.” ");
INSERT INTO apr_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Motong la Yesu iwete pang di galiunu mulu nen, “Ken kakamata dada kidi diemu ngan kawete bet di ngan tooltool dook tiap, ngan be. Ole nen ngan Maro ikamatang ben ang nga tooltool dook tiap lapau. ");
INSERT INTO apr_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Kumata bet kakamata dada kidi ngan kawete bet di ngan tooltool dook tiap a bet tiyemenai di nga, ngan gaongo leu, Maro ole iwetang nga tooltool dook tiap a bet iyemenai ang nen lapau. Le dada yo kayei pang di diemu nga, ngan Maro ole iyei nen pang lapau. ");
INSERT INTO apr_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","“Nga gelei bet kumata tidi maitiap yo iken ye taim matana i, e lom tutu kai palini maiyoko yo iken ye matam, in tiap nga? ");
INSERT INTO apr_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Bet ong taum kumata kai palini maiyoko yo iken ye matam, in tiap nga, ngan gelei bet kuwete pang taim ne, ‘Taik, au i lok bet apaia tidi maitiap yo iken ye matam in.’ ");
INSERT INTO apr_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Ona, ong in tool ke kaplungunu! Lom bet nen ngan ong taum kukulu kai palini maiyoko yo iken ye matam in mugu a kumata ni dook, lo ngan bet kupaia tidi maitiap yo iken ye taim matana i. ");
INSERT INTO apr_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Awete pang, ken kakap so mison ke Maro ngan pang di gaunu be, inbe ken kakatte matauu kiang ngan pang di ga be. Kumata bet kakap pang di nga, ngan ole tiyirngan ye kedi le dook tiap, lo ngan bet tiportak inbe tikanang a tisarrakang le morrana. ");
INSERT INTO apr_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Kumata bet katoro Maro ye so bet ikap pang nga, ngan ole ikap pang. Inbe kumata le kasere so nga, ngan ole ilonang le kapusye. Inbe kumata bet kapitpiti dada nga, ngan Maro ole iso dada pang. ");
INSERT INTO apr_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Ngan nen, yesoo di tooltool le imot yo tipatarau a titoro Maro bet ikap so pang di nga, ngan ole tikap so tina. Inbe di tooltool le imot yo tisere so nga, ngan ole ilon di le tipusye. Inbe di tooltool le imot yo tipitpiti dada nga, ngan ole Maro iso dada pang di. ");
INSERT INTO apr_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","“Ngan ang tina ngan atu bet natunu itoru bet ikap porong panga nga, ngan ole ikaua pat panga, too? Tiap! ");
INSERT INTO apr_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Too, bet natunu itoru bet ikaua i panga nga, ngan ole ikaua moto panga, too? Tiap yege! ");
INSERT INTO apr_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Ang nga dada kiang yo kayei ngan dook tiap, bong lomu galanga ye dada yo bet kakap so dook mata leu pang di natumu a kalon di ye i. Ngan nanga, Tamamu yo inepe ye malala ki ete ni, in illosang ye dada dook mata ki yo iyei nga, le ole ikap so dook mata pang di tooltool yo bet titoru ye so nga. ");
INSERT INTO apr_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Ngan nanga, dada dook mata yo lomu bet di tooltool tiyei pang nga, ngan ang ole kayei dada gaongo leu pang di nen lapau. Le betanga i, in wer ke Maro yo ikauu pang Mose, inbe betanga yo di Maro koonoo tiwete nga, ngan pudi igaua ye. ");
INSERT INTO apr_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Kadewe ye dada ke koongoo yo koonoo kase i, in leu. Yesoo, dada ke koongoo le dada ke panga yo idu pang ye malala ke kaungu masngana i, in somai san le di tooltool alunu la tipa ye a titoo nga. ");
INSERT INTO apr_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Bong dada ke koongoo le dada ke panga yo ilo pang ye malala ke kaungu nepongo dook mata i, in mai tiap le di tooltool alunu tiap la tipusye a titoo nga. ");
INSERT INTO apr_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Ken kakamatang dook leu ye di tooltool ke kaplungunu yo tiwete di ye Maro koonoo nga. Di ngan kumata bet timan pang yang nga, ngan ole kakamata di ben di asara dook mata yo edi sipsip nga, bong moolmool tiap, ye lodi ngan di ngan dawa ben di gaunu gok yo malmalidi nga. ");
INSERT INTO apr_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Le di tooltool yo tiyei urata nen nga, ngan ole lomu galanga ye di ye dada kidi yo tiyei nga. Oo kakamata, di tooltool bet tila ye ooroo kaudangdang nga, ngan ole gelei, la tigogo ooroo wain puana ye, too? Tiap! Too, bet tila ye kai marini nga, ngan ole gelei, la tikaut kun puana ye, too? Tiap yege! ");
INSERT INTO apr_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Ngan gaongo leu, kai dook mata in bet ipu nga, ngan ole kanono dook mata. E kai dook tiap in bet ipu nga, ngan ole kanono dook tiap. ");
INSERT INTO apr_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Ngan nanga, ye kene yo kai dook mata bet ipu ye in nga, ngan o ke bet itar kanono dook tiap, ngan tiap. Inbe kene yo kai dook tiap bet ipu ye in nga, ngan o ke bet itar kanono dook mata, ngan tiap lapau. ");
INSERT INTO apr_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Inbe kai le imot yo tipu ngan titar kanodi dook tiap nga, ngan ole titarakat di a tikatte di lo ei lono. ");
INSERT INTO apr_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Ngan nanga, di tooltool ke kaplungunu yo tiwete di ye Maro koonoo nga, ngan ang nga ole lomu galanga ye di ye dada kidi yo tiyei nga.” ");
INSERT INTO apr_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Di tooltool yo tikiu au ye ‘Tool Mai, Tool Mai’ nga, ngan o ke bet di le imot tilo tigaua ye di tooltool yo Maro bet matan kala di, ngan tiap. Bong di tooltool la tiyei so le titoo Tamak yo inepe ye malala ki ete ni, in lono le imot nga, ngan di leu la bet tilo nga. ");
INSERT INTO apr_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Le pang dama ni, ye lal yo Maro itaru bet ikarata betanga kidi tooltool ye in nga, ngan ole di tooltool alunu la bet tikiu au a tiyei ne, ‘Tool Mai, Tool Mai! Nga gelei, ye ong em, ngan am nga amkaua koom a amwete betanga kiong pang di tooltool a tilonga. Inbe ye ong em, ngan amgiri di so sidi ye di tooltool a tikoo. Inbe ye ong em, ngan amyei mos matana matana ye lapau.’ ");
INSERT INTO apr_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Ngan tiwete nen, lo ngan bet ole awete pobe pang di nen, ‘Atoo, au i lok galanga yang pitiap yege. Ang nga di tooltool ke geingi dada dook tiap, le kakoo yau a kala!’ ");
INSERT INTO apr_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Di sima tooltool yo tilongo betanga kiau, ngan tiparama a titoo dook le imot nga, ngan di ngan dawa ben tool ke lo galanga yo ire rumu ki lo pat pono i. ");
INSERT INTO apr_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Le ye kene yo bet ki imol a oongoo ipot, inbe muru mai ube a iman itaktaka rumu ki tani nga, ngan o iduku tiap. Yesoo, ipe sawa ke rumu tani in le idu lopo inbe pat iparama le imede san. ");
INSERT INTO apr_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Bong di sima tooltool yo tilongo betanga kiau, ngan tiparama a titoo dook tiap nga, ngan di ngan dawa ben tool kapa yo ire rumu ki du ululu pono i. ");
INSERT INTO apr_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Le yeiso bet ki mol a oongoo ipot, inbe muru mai ube a iman itaktaka rumu ki tani, ngan iduku a idu tana le du imassoroko.” ");
INSERT INTO apr_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Ye kene yo Yesu iwetewete ye so tina a imot ye in nga, ngan le di tooltool malala mai tina yo tilongo betanga ki nga, ngan titakrai ye patomonaingi ki, ");
INSERT INTO apr_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","yesoo patomonaingi ki dawa ben di pannoongoo ke wer ke Maro, ngan tiap, bong patomonaingi ki ipa ye gurana ke Maro. ");
INSERT INTO apr_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Ye kene yo Yesu igege kawal madini a imulu a isi ye in nga, ngan di tooltool alunu le alunu kaiye la titoo nga. ");
INSERT INTO apr_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Ngan tool atu yo botoboto medana ikana tinini i, in iman le man igun turunu du Yesu kene punu ke dama, inbe iwete panga nen, “Tool Mai, kumata bet lom nen nga, ngan kuyei au le tinik igalanga mulu.” ");
INSERT INTO apr_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Motong la Yesu itara bene lo tool tani in pono, inbe iwete panga nen, “Dook mata, au i lok nen, le ole tinim igalanga mulu.” Ngan le pattu leu inbe botoboto medana tina ngan imapmap, inbe tinini dook mata mulu. ");
INSERT INTO apr_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Motong la Yesu iwete betanga medana panga a ilele nen, “Ai, ken kula ngan kugasa pang di tooltool ye so yo ayeii yong i, in be. Bong kupa so le la ong taum kupitnai ong pang tool ke paroranga so pang Maro in mugu. Lo ngan bet kuyei paroranga ye so pang Maro ye yo tinim igalanga mulu, dawa ben tina yo wer ke Mose iwete nga, a bet nen ngan di tooltool lodi galanga ye yo tinim igalanga koot nga.” ");
INSERT INTO apr_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Ye kene yo Yesu ipa le lo pombe malala mai Kapenam ye in nga, ngan tool turana bulbulini ke patokongo kidi Rom, in man itoro Yesu bet iloni. ");
INSERT INTO apr_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Iyei ne, “Tool Mai, kapraingi kiau ni imasoposopo le ke bet ipulles tiap, inbe imassingi mai san le ye nani la ipas le iken leu rumu ni.” ");
INSERT INTO apr_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Motong la Yesu iwete panga nen, “Ole ala akarata le tinini dook mata mulu.” ");
INSERT INTO apr_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Ngan tool tani iraua betanga ke Yesu nen, “Atoo, Tool Mai, o nen tiap! Au i lok tarau ngan au i tool dook mata ke bet kuman a kulo rumu lono kiau tiap. Bong kupas le kuwete ye koom leu, inbe kapraingi kiau tani ole tinini dook mata mulu. ");
INSERT INTO apr_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Awete nen nga, yesoo anepe gurana ke tool mai kiau yo matan kalau i, in parmana. Inbe au tauk i di tooltool kiau ke patokongo nga, ngan tinepe gurana kiau parmana lapau. Le kumata bet awete pang atu nen, ‘Kula,’ ngan ole ila. E bet awete pang san nen, ‘Kuman,’ ngan ole iman. E bet awete pang kapraingi kiau nen, ‘Kuyeie urata i,’ ngan ole itoo kook a iyeie urata tani.” ");
INSERT INTO apr_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Yesu ilongo betanga ke tool turana bulbulini ke patokongo tani yo iwete nen nga, le itakrai ye. Motong la iwete pang di tooltool budanga mai tina ngan nen, “Awete pang moolmool nen, au i apusye toko tool sa ke Isrel yo itara lono medana mai mata dawa ben tool i, ngan tiap. ");
INSERT INTO apr_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Le awete pang nen, di tooltool alunu kaiye dawa ben ye i ole tipa ke ni yo ke ipa ye a ise i, inbe ye ni yo ke idu ye i, a timan tiye Awaram ye Esaka inbe Yakop man tiwur, inbe tikan so ye lal yo Maro itaru bet matan kala di tooltool ki ye i. ");
INSERT INTO apr_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Bong di tooltool yo Maro ipootoo di panga mugu nga, ngan ole inganga di a tidu diki a du tinepe todo maiyoko lono. Ngan ye ni tani in ole timassingi a titangtang, inbe tikanen dongadi a iparrasa.” ");
INSERT INTO apr_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Yesu iwete nen a imot, motong la iwete pang tool turana bulbulini ke patokongo tani in nen, “Ai, kula. So yo kutorau ye i, in ole pombe ben tina yo kutara lom medana bet ole pombe nga.” Le ye kene tani, in kapraingi ke tool mai tani in tinini dook mata mulu. ");
INSERT INTO apr_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Motong la Yesu ipa le la pombe ye ni ke Pita, a ilo rumu lono ki. Ngan ikamata Pita roonoo garup yo matamatenge ikauu le tinin ges a ikenen moi pono nga. ");
INSERT INTO apr_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Le nga Yesu itoko garup tani in bene, ngan le pattu leu be matamatenge ikoo ye le tinini dook mata mulu. Motong la imadit a ikarata kaningi pang Yesu a bet ikan. ");
INSERT INTO apr_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Yesu iye di tinepe le du rrai, motong la di tooltool yo so sidi tidiwidiwi di nga, ngan di sogadi tikap di a timan pang ye. Motong la iwete pang di so sidi tina a inganga di a tikoo, inbe iyei di tooltool yo matamatenge ikap di nga, ngan le tinidi dook mata mulu. ");
INSERT INTO apr_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Ngan tina Yesu iyei nen, le iyeie betanga ke Maro koonoo yo Esai i, in le kanono pombe moolmool. Ngan Esai tani in iwete nen, “Ye in igiri matamatenge kiidi, inbe iyei idi le tiniidi dook mata mulu.” ");
INSERT INTO apr_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Yesu ikamata di tooltool alunu san man tigaua le tigaliuu, le nga iwete pang di galiunu bet tisuku ookoo kidi inbe tipoi saut a bet tila ke ran koonoo san. ");
INSERT INTO apr_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Motong la pannoongoo ke wer ke Maro atu in iman pang ye Yesu man iwete panga. Iyei ne, “Pannoongoo, au i ole atoo ong ye ni nangai yo bet kupa pang ye nga.” ");
INSERT INTO apr_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Ngan Yesu iraua betanga ki nen, “Di gaunu gok ngan agoro kidi ke kenongo, inbe di man ngan giniu kidi ke kenongo lapau, bong Tool Moolmool ke Maro, in taukan ni yo bet iken a imaryoo ye i.” ");
INSERT INTO apr_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Motong la tool san yo Yesu galiunu, in iwete pang Yesu nen, “Tool mai, ole kumalum pau a la akelmaia tamak mugu ngan, lo ngan bet man atoo ong.” ");
INSERT INTO apr_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Bong ngan Yesu iraua betanga ki nen, “Di tooltool yo titoo Maro tiap le tinepe dawa ben di tooltool matedi nga, ngan ole di tapdi tikelmai di diedi yo timmata koot nga. Bong ong in kuman a man kutoo au.” ");
INSERT INTO apr_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Motong la Yesu ipas lo ookoo pono, inbe di galiunu titoo a tipas lo ookoo pono lapau a tikooi a tila. ");
INSERT INTO apr_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Tikooi a tila me pono, inbe pattu leu be eng mai imadit. Ngan eng tani in isi le mai mata, le kokor ki popobe a ipases lo ookoo lono, bong Yesu iken mata a ila oo. ");
INSERT INTO apr_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Ngan tina eng mai nen nga, le nga di galiunu la tipoongoo a tiyei ne, “Tool Mai, kulonam! Nga bet tamere a tallede!” ");
INSERT INTO apr_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Tipoongoo, motong la iwete pang di nen, “Ai, ang nga katara lomu medana pau mai tiap sa. Nga gelei a katattadai mata nga?” Motong la imadit tina le iwete katkat pang eng le kokor tina, le imata le manini susube dook mata. ");
INSERT INTO apr_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Ngan iyei nen a di galiunu tina tikamata, le titakrai, inbe di tapdi tipartortor nen, “Ona tiap! I tool balai a le eng le kokor tilongo koonoo nga?” ");
INSERT INTO apr_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Ye kene tani yo Yesu iye di galiunu tila tisolo ran koonoo kapala ye tana kidi tooltool ke Gadara nga, ngan di tooltool ru yo so sidi tidiwidiwi di a tinepe agoro lono kidi matenge ngan tisi pang ye Yesu. Yeru ngan di so sidi tidiwidiwi di le guradi mata, inbe tikap malmal le tool sa ke bet ipa a ikapus di ye ni tani, in tiap. ");
INSERT INTO apr_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Di tooltool ru tina tikamata Yesu, motong koodi panga nen, “Atoo! Ong i Maro Natunu. Nga soo so bet kuyeii pam i? Ngan lal yo Maro itaru bet ikap masngana pam ye i, in pombe tiao, bong kuman ni nga bet man kop masngana pam, too?” ");
INSERT INTO apr_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Ye kene tani in di ga alunu la tisu a tikanen ben manga mooloo kasin ye di nga. ");
INSERT INTO apr_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Le nga di so sidi tina titoro Yesu a timangmang ye nen, “Bet kungangam nga, ngan kumalum pam a la amdewe a amlo di ga ngo lodi.” ");
INSERT INTO apr_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Yesu iman tina le iwete pang di nen, “Kapas a kala.” Yo ngan tina le tipas a tisi tana a tila tidewe lo ga tina ngan lodi. Motong la ga budanga tina ngan tidada a tila sakar matana a tipas du ran lono le taun tidaup a timmata. ");
INSERT INTO apr_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Ngan nen le di tooltool yo matadi kala di ga nga, ngan titattadai ye so yo tikamata nga. Le tina tidada a tilo pang malala kidi, a lo tikaua bingi ye so le imot yo pombe ye di ga nga, inbe ye di tooltool ru tina yo so sidi tidiwidiwi di nga, ngan lapau. ");
INSERT INTO apr_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Motong di tooltool yo tinepe ye malala mai tani nga, ngan di le imot tidu bet du tikamata Yesu. Tidu tikamata, motong la tiwete panga a timangmang ye bet ikoo ye ni kidi a ila pang ye ni san mulu. ");
INSERT INTO apr_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Motong la Yesu iyiri lo ookoo pono, a isaut mulu pang ran koonoo san. Ngan le la pombe ye malala ki ye taunu. ");
INSERT INTO apr_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Ila pombe, motong di tooltool pattu titokotoko tool atu yo ikap rama le ipas le iken leu moi pono i, in a timan pang ye. Yesu ikamata di tooltool tina, ngan titara lodi medana panga moolmool nga, le tina iwete pang tool yo ikap rama in nen. Iyei ne, “Natuk, ken lom mede leu. Sennene kiong, ngan agir oo.” ");
INSERT INTO apr_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Ye kene tani in di pannoongoo pattu ke wer ke Maro tilongo yo Yesu iwete nen nga, le nga di tapdi tiwetewete pang di nen, “Ona, tiap! Tool i nga gelei a iwete betanga nen nga? Nga o bet ikaua Maro nene, too?” ");
INSERT INTO apr_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Tiyei nen ngan Yesu lon galanga ye lodi mukot, le nga itor di. Iyei ne, “Nga gelei bet lomu kap gogo dada dook tiap nen nga? ");
INSERT INTO apr_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Soo betanga imarra bet aweta i? Bet awete panga nen, ‘Sennene kiong ngan agir oo,’ too bet awete panga nen, ‘Kumadit a kupa’? ");
INSERT INTO apr_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Bong au i lok bet ayei nen, a bet nen ngan ole lomu galanga nen, Tool Moolmool ke Maro, in gurana ki mai ye tana i ke bet igiri sennene kidi tooltool.” Yesu iwete nen a imot, motong la iwete pang tool yo ikap rama in nen, “Kumadit, a kouo moi kiong a kula pang rumu kiong.” ");
INSERT INTO apr_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Motong la tool tani, in imadit a ila pang malala ki. ");
INSERT INTO apr_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Yeiso bet di tooltool malala mai tina ngan tikamata so yo Yesu iyeii i, ngan le titakrai, inbe tiyitmaka Maro ene ye yo ikaua gurana ki mai pang di tooltool nga. ");
INSERT INTO apr_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Yesu igege ni tani, inbe ipa a ila, ngan ikamata tool atu ke sodaningi pat yo ene Matiu i, in iwurur rumu ke sodaningi pat in lono. Motong la Yesu iwete panga nen, “Ai, kuman kutoo au.” Yo ngan tina le imadit a itoo Yesu. ");
INSERT INTO apr_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Motong la tinepe a kene san in Matiu ikaua Yesu iye di galiunu pang rumu ki bet lo tikan so. Ngan le di tooltool alunu ke sodaningi pat, inbe alunu ke geingi sennene, ngan di lapau la tilo a tiye Yesu tiwur, inbe tikan so nga. ");
INSERT INTO apr_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Yeiso bet di Paresi tikamata di yo tiyei nen nga, yo ngan le taun titor di galiunu nen, “Ai! Nga gelei bet pannoongoo kiang ni iye di tooltool ke sodaningi pat inbe di tooltool ke geingi sennene tigaua a tikan so nga?” ");
INSERT INTO apr_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Di Paresi tiwete nen, ngan Yesu ilongo di oo. Le nga ikatte betanga pang di nen, “Di tooltool yo tinidi dook mata nga, ngan tool ke bar ke bet ipa pang ye di tiap, bong di tooltool la matamatenge ikap di nga. ");
INSERT INTO apr_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Au i lok bet kala ngan lomu kaua urata dook ye betanga yo Maro iweta a iken ye rau ki i, in lono ki balai? Ngan betanga tani in nen, ‘Dada yo lok panga mata i, in nen, bet lomu mulumulu ye di tooltool a kayei dada dook mata pang di, bong ye dada yo ke paroranga so pau, in tiap.’ Ngan nanga, asi nga bet si akiu di tooltool yo noonoodi, nga tiap, bong asi bet si akiu di tooltool yo ke sennene nga.” ");
INSERT INTO apr_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Motong la Yowan yo irriu di tooltool in di galiunu timan pang ye Yesu a man titoru. Tiyei ne, “Ai, nga gelei bet amye di Paresi nga amsapa ye kaningi so, e di galium nga tisapa ye kaningi so tiap nga?” ");
INSERT INTO apr_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Ngan Yesu iraua torungu kidi nen, “Kumata tamoto atu yo bet ikere i, in ikiu di sogana le di tooltool ki bet man tiye tinepe ye kerenge ki nga, ngan gelei, ole lodi madoko a tisapa ye kaningi, too tiap? Tiap yege! Bong pang dama ni ngan ole di tooltool tikaua tool tani yo bet ikere in le igege di tooltool ki nga, ngan la bet ole lodi madoko a tisapa ye kaningi nga.” ");
INSERT INTO apr_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Motong la Yesu iwete pang di mulu nen, “Tool sa ke bet ikaua mala timunu yo paunu i a idede sousoungu ki yo gurunu in gimono ye tiap. Kumata bet iyei nen le bet ingasi nga, ngan mala timunu tani yo paunu i, in ole irauwat le isarraka sousoungu gurunu tani le dook tiap. ");
INSERT INTO apr_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Inbe gaongo leu, di tooltool ke bet tipaling ooroo wain surunu yo paunu, ngan ilo ye dap gurunu yo tikarata ye asara kulini, in tiap. Kumata le bet tiyei nen, inbe ran medana isung nga, ngan ole dap gurunu tani putumbe le dap in dook tiap, inbe ran medana tina ngan imati du tana. Ngan nanga, ooroo wain surunu yo paunu nga, ngan ole tipaling lo ye dap yo paunu nga, ngan la bet yeru le ru tiken dook nga.” ");
INSERT INTO apr_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Yesu nga iwetewete pang di tooltool tina ngan go, inbe tool kuto mai ke rumu kidi Yuda ke gaongo in idu le du igun turunu du Yesu kene punu ke dama, inbe iwete panga nen, “Atoo, natuk garup ni dookoot yege imata nga. Bong lok bet ayong tadi rumu kiau, a bet nen ngan di kupaloko bem lo pono, ngan imagur mulu.” ");
INSERT INTO apr_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Motong la Yesu imadit a iye di galiunu titoo tool kuto mai tani a tiye tidi. ");
INSERT INTO apr_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Ye kene yo tidi ye in nga, ngan garup atu yo iyolo rara ye rai sangaul be ru i, in ipa ke Yesu murini le isulmaia bene la itoko sousoungu matolene ki, in matana. ");
INSERT INTO apr_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Ngan garup tani, in ye taunu lon wetewete nen, “Kumata le bet atoko sousoungu ki leu nga, ngan ole tinik dook mata mulu.” ");
INSERT INTO apr_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Bong Yesu iyetaii le nga iportak ngan ikamata garup tani. Le iwete panga nen, “Natuk, ken lom mede leu. Lo medana kiong yo kutaru pau i, in la ikaratong le tinim dook mata mulu i.” Tina Yesu iwete panga nen nga, ngan le ye kene tani in tinini dook mata mulu. ");
INSERT INTO apr_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Motong la Yesu ipa le di pombe ye rumu ke tool kuto mai tani in a ilo lono, ngan ikamata di tooltool yo timai kure, inbe di tooltool budanga mai yo titangtang a tipadingi ni nga. ");
INSERT INTO apr_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Le nga Yesu ipasak pang di. Iyei ne, “Ai, kakoo a kadu tana! Garup kase in imata tiap, bong iken mata leu.” Ngan nen le di tooltool tina tingeleraii ye yo iwete nen nga. ");
INSERT INTO apr_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Motong la iwete a di tooltool tina ngan di le imot tidu tana, inbe ilo rumu lono ye ni yo garup kase in iken ye i, a lo itoko bene, ngan le imadit a imagur mulu. ");
INSERT INTO apr_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Ngan nen le bingi ke garup kase tani, in ipa le ingaua tana mai i le imot. ");
INSERT INTO apr_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Motong la Yesu igege malala tani, inbe ipa mulu nga. Ngan di tooltool mata kis ru titoo a koodi panga nen, “Atoo, Dawiti natunu! Lom pam a kulonam.” ");
INSERT INTO apr_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Yesu ipa a ilo rumu lono, ngan di tooltool mata kis ru tina ngan timan pang ye. Motong la itor di yeru nen, “Angru katara lomu medana yau bet ole ayeie urata nen yang angru?” Ngan yeru tiraua betanga ki nen, “E, Tool Mai.” ");
INSERT INTO apr_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Motong la Yesu itar bene lo yeru matadi, inbe iyei ne, “Ye lo medana kiang yo angru kataru pau i, in la ole so tani in pombe pang yang.” ");
INSERT INTO apr_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Ngan le di tooltool ru tina ngan matadi rere. Motong la iwete betanga medana pang di nen, “Ken angru kapapos pang di tooltool kapala ye so yo pombe pang yang i, in be.” ");
INSERT INTO apr_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Bong ngan yeru tipa bet tikaua bingi ye urata yo Yesu iyeii pang di yeru i, in pang di tooltool ke malala nga le imot ye tana mai tani a tilonga. ");
INSERT INTO apr_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Ye kene tani, in di tooltool ru tina ngan tipa a tila, inbe di tooltool kapala tikaua tool san yo so sidi idiwidiwoo a men modo le iwetewete tiap i, in a timan pang ye Yesu. ");
INSERT INTO apr_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Motong la Yesu inganga so sidi ye tool tani in a iwetewete nga. Ngan tina iyei nen, le nga di tooltool tina yo tigaua nga, ngan tikamata le titakrai, inbe tiyei ne, “Ona! Mugu ngan amkamata so sa nen pombe Isrel tiap sa.” ");
INSERT INTO apr_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Bong ngan di Paresi tiyei ne, “Tiap! Tool in inganga di so sidi ye gurana yo tool kuto mai kidi so sidi ikauu panga i.” ");
INSERT INTO apr_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Motong la Yesu ipa mulu a ila ye malala atu atu nga le imot, inbe ilo ye rumu kidi Yuda ke gaongo a ipatomonai di, inbe iwetewete pang di ye bingi dook mata ke dada yo Maro bet matan kala di tooltool ki ye i. Inbe ikarata di tooltool yo matamatenge matana matana ikap di nga, ngan le tinidi dook mata mulu. ");
INSERT INTO apr_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Ngan Yesu ikamata di tooltool malala mai yo man tigaua nga, ngan lono pang di mai san. Yesoo, di ngan moonoo alunu pompombe pang ye di, inbe di tapdi ke bet tilon di tiap, le di ngan dawa ben di sipsip yo taukadi taudi yo bet matan kala di nga. ");
INSERT INTO apr_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Ikamata di nen, le nga iwete pang di galiunu. Iyei ne, “Kaningi alunu kaiye la isullungu a iken kumu ngo, bong di tooltool ke urata yo bet tikap a tiwinnoko nga, ngan alunu tiap. ");
INSERT INTO apr_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Ngan nanga, ole kapatarau pang Tool Mai yo kumu taunu i, a bet nen ngan iwanga di tooltool ke urata sa mulu la tikap kaningi kanono a tiwinnoko.” ");
INSERT INTO apr_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Yesu ikiu di galiunu sangaul be ru a man tigaua, motong la ikap gurana pang di bet tiyei urata ye, a bet nen ngan tinganga di so sidi, inbe tikarata di tooltool yo matamatenge matana matana ikap di nga, ngan le tinidi dook mata mulu. ");
INSERT INTO apr_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Ngan di galiunu tina sangaul be ru nga, ngan edi nen: atu ene la Simon yo tikiui ene san ye Pita i; inbe Simon tani in taini kase yo Antares i; inbe Sebedi di natunu ru yo Yemis iye taini Yowan nga; ");
INSERT INTO apr_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","inbe Pilip iye Batolomiu inbe Tomas ye Matiu yo tool ke sodaningi pat i; inbe Yemis san yo Alpias natunu i; inbe Tadias; ");
INSERT INTO apr_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","inbe Simon yo tool ke sorringi di Rom ye tana kidi Yuda i; inbe Yuta Iskariot, tool tani yo bet pang dama ni ngan itara Yesu la di koi ki bedi i. ");
INSERT INTO apr_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Yesu ikap gurana ki pang di galiunu tina yo sangaul be ru ngan a imot, motong la iwanga di, inbe iwete pang di nen, “Lok bet kapa ngan kala ye di tooltool yo tipa ye rara kidi Yuda tiap nga, ngan be. Inbe kapa nga, ngan ken kalo ye malala maimai kidi Samaria, ngan atu sa be. ");
INSERT INTO apr_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Bong bet kapa nga, ngan le kala ye di tooltool ke Isrel yo di ngan dawa ben di sipsip yo tilledi nga. ");
INSERT INTO apr_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","E le bet kala nga, ngan kawetewete bingi dook mata bi e i pang di tooltool. Kayei ne, ‘Ole mooloo tiap, inbe dada yo Maro bet matan kala di tooltool ki ye i, in ole si pombe mallangana.’ ");
INSERT INTO apr_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Inbe urata yo bet kayei nga, ngan nen. Kakarata di tooltool yo matamatenge ikap di nga, ngan a tinidi dook mata mulu. Inbe tooltool bet timmata nga, ngan kapamadit di a timagur. Inbe kakarata di tooltool yo botoboto medana ikan di nga, ngan le tinidi galanga mulu. Inbe di tooltool yo so sidi tidiwidiwi di nga, ngan kanganga so sidi ye di le tinidi dook mata mulu. Ngan gurana kiau yo akauu pang bet alonang ye i, in kayimoo tiap, bong akauu sorok pang. Ngan nanga, lok bet ang lapau kalon sorok di tooltool ye, bong kakiulai ye balingi be. ");
INSERT INTO apr_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Inbe ye kene yo bet kapa ye in nga, ngan ken kakap pat a katar lo ye depe mai tiap kiang ke tarungu pat be. Le pat ke yimoongoo so yo ene gol le silba le kapa nga, ngan ken kakap be. ");
INSERT INTO apr_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Inbe ken kasolo depe kiang be. Inbe ken kakap sorok lonloningi kiang san mulu, inbe loningi ke kemu san mulu be. Inbe ken kakap toto ke panga lapau be. Yesoo, kumata bet tool iyei urata, ngan la bet ikap loningi ye di tooltool yo iyei urata pang di nga. ");
INSERT INTO apr_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Soo malala mai, too malala kase bet kapa le la pombe ye nga, ngan matamu saraia tool sa yo dook mata nga a ikau ang a kaye kanepe ye rumu ki. Ole kaye leu kanepe le lo soo lal yo bet kagege inbe kapa pang ye malala san mulu ye i. ");
INSERT INTO apr_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Inbe kapa le kalo ye rumu atu nga, ngan kawete pang di tooltool yo tinepe ye rumu in nen. Kayei ne, ‘Maro ikaua lo silene ki pang.’ ");
INSERT INTO apr_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Ngan kumata le di tooltool ke rumu ngan bet lodi dook mata pang nga, ngan betanga kiang dook mata tani ole inepe ye di. Bong kumata bet lodi dook mata pang tiap nga, ngan betanga dook mata kiang ke lo silene tani, in ole imulu a iman pang yang. ");
INSERT INTO apr_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Inbe kumata bet kapa le la pombe ye malala atu, le di tooltool ki lodi bet tikau ang tiap, inbe titar talngadi bet tilongo betanga kiang tiap nga, ngan kagege malala in. Bong kene yo bet kagege nga, ngan kataurai gauru ke kemu sila ikino ye malala tani in. ");
INSERT INTO apr_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Awete pang moolmool nen, ye lal yo Maro itaru bet ikarata betanga kidi tooltool ye in nga, ngan ole iyemenai di tooltool ke malala tani in ye urata moonoo dook tiap ki taunu le illoso urata moonoo dook tiap yo bet pombe pang di tooltool ke malala mai ru, Sodom le Gomora nga.” ");
INSERT INTO apr_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Motong la Yesu iwete betanga san mulu pang di galiunu nen, “Kapalongo! Ayawarang a kala nga, ngan la kanepe ben di sipsip yo tinepe kataunu ye di gaunu gok nga. Ngan nanga, ole kakauwai yang dook leu dawa ben di moto, inbe ole kanepe moonoombe dawa ben di man yo utu nga. ");
INSERT INTO apr_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Le ken kakauwai yang dook leu ye di tooltool yo bet tigarungang nga. Di ngan ole tiparamang a tikau ang lo kakodo dama kidi kuto maimai ke karatanga betanga, inbe ole tikau ang kalo rumu lono kidi Yuda ke gaongo a bet nen ngan tikap koro a tiwalisang ye. ");
INSERT INTO apr_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Yesoo kayei urata ye raingi bingi dook mata kiau nga, ngan ole tikau ang lo kakodo dama kidi tooltool yo matadi kala malala maimai kidi nga, inbe lo kakodo dama ke di tooltool yo tiyei kuto maimai pang tana maimai kidi nga, ngan lapau. Ngan ole tiyei nen a bet nen ngan kawete bingi dook mata kiau pang di tooltool maimai tina, inbe pang di tooltool yo tipa ye di rara ke Yuda tiap nga. ");
INSERT INTO apr_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Bong ye kene tani yo tikau ang bet lo kakodo dama kidi kuto maimai kidi ye in nga, ngan ken lomu madoko ye soo betanga yo bet kawete, too dada yo bet karau betanga kidi ye, in be. Awete pang nen, ye kene tani in Maro Amunu Silene la bet ipasongosongang ye betanga yo bet kawete pang di nga. ");
INSERT INTO apr_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Ngan betanga tina yo bet kawete nga, ngan ang tapmu la bet kawete nga tiap, bong Tamamu Amunu Silene yo inepe lomu i, in ye la bet iwetewete i. ");
INSERT INTO apr_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Inbe ye kene tani in di rara atu ben toodi le taidi nga, ngan atu ole ikaua san a itaru la di koi ki bedi, a bet nen ngan tiraumate le imata. Inbe di kakase tamadi ole tiyei dada gaongo nen leu pang di natudi. Inbe di kakase ole tisak betanga ke di tamadi le tinadi lapau, inbe tiwete pang di tooltool kapala bet la tiraumata di a timmata. ");
INSERT INTO apr_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Inbe di tooltool le imot ole tiyei koi pang a bet tigarungang, yesoo ang nga katara lomu medana ye betanga kiau a katoo au. Bong di sima tooltool yo tikodo le timede ye lo medana kidi a tikodo nen le lo timmata nga, ngan Maro ole ikap di a ipamulu di ye so dook tiap yo bet igarung di i. ");
INSERT INTO apr_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Ngan nanga, kumata bet kala ye malala atu, le bet di tooltool ki tikamatang ben katoo au a bet tigarungang nga, ngan kakoo tarrai a kala pang ye malala san mulu. Awete pang moolmool nen, urata yo bet kapa ye malala maimai ke tana mai Isrel inbe kayeii i, in ole kayeii le imot tiao, inbe ole Tool Moolmool ke Maro isi pombe. ");
INSERT INTO apr_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Ngan kase yo inepe ye ni ke patomonaingi i, in o ke bet illoso pannoongoo ki le ilo ete ye, ngan tiap. Inbe tool yo iyei urata ben kapraingi in lapau, o ke bet illoso tool mai ki le ilo ete ye, ngan tiap lapau. ");
INSERT INTO apr_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Bong kumata bet kase mai tiap ke patomonaingi in ise le se inepe dawa ben pannoongoo ki nga, ngan dook mata. Inbe kumata bet tool ke kapraingi in ise le se inepe dawa ben tool mai ki nga, ngan dook mata lapau. Ngan nen le kumata bet tikiui kuto mai ke rumu in ye tool kuto mai kidi so sidi yo ene Belsebul in nga, ngan di tooltool ki yo iye di tinepe ngan ole tikiu edi ye so dook tiap le dook tiap ki taunu nen lapau. ");
INSERT INTO apr_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Bong ken katattadai di tooltool yo bet tigarungang, ngan be. So tina le imot yo di tooltool titarkoo a iken sollono nga, ngan pang dama ni ngan ole Maro ipapos se mallangana a bet nen ngan di tooltool tikamata. Inbe betanga yo titarkoo le di tooltool ke bet tilongo tiap nga, ngan ole ise mallangana le imot lapau a di tooltool lodi galanga ye. ");
INSERT INTO apr_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Ngan nanga, betanga yo idi leu tanepe inbe awete pang sollono nga, ngan ole kawete la mallangana pang di tooltool le imot a tilongo. Inbe betanga yo amangunngun ye pang nga, ngan ole kakodo malala katene, inbe kakaua bingi ye pang di tooltool le imot a tilongo. ");
INSERT INTO apr_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","“Ken katattadai di tooltool yo tiraumatamata di tooltool bobodi leu, bong ke bet tiraumata kauredi tiap, nga be. Bong ole katattadaia Maro, yesoo yetaleu in la gurana ki mai ke bet igarung di tooltool bobodi le ipa ye kauredi a ikatte di tidu ye malala ke masngana i. ");
INSERT INTO apr_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Kumata bet di tooltool tiyimi man natunu ru nga, ngan ole tiyimi di ye pat mai tiap kooroonoo atu. Bong man tina ngan Tamamu la matan kala di i, le kumata bet imalum ye di tiap nga, ngan o ke bet atu sa imol a idu tana tiap. ");
INSERT INTO apr_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","31","Le kumata bet Maro matan kala di man dook mata nen nga, ngan ole matan kalang dook mata lapau, yesoo ye matana ngan ang nga kallos di man. Maro lon galanga yang dook mata san, le kinkatingi ke kutomu raunu nga, ngan lon galanga ye le imot lapau. Ngan nen le ken katattadai be!” ");
INSERT INTO apr_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Motong la Yesu iwete pang di mulu nen, “Sei tool bet iwetewete ek pang di tooltool la mallangana bet ye in au galiuk nga, ngan au lapau, ole awete ene pang Tamak yo inepe ye malala ki ete ni la mallangana, bet tool in galiuk moolmool. ");
INSERT INTO apr_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Bong sei tool bet ipataukala ek ye di tooltool bet ye in galiuk tiap nga, ngan au lapau, ole apataukala ene ye Tamak yo inepe ye malala ki ete ni, bet tool in galiuk tiap lapau. ");
INSERT INTO apr_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Ken lomu tarau bet asi tana nga bet si agauagaua di tooltool a bet tinepe ye lo silene, ngan be. Au i asi nga bet si akaua lo silene pang di tooltool tiap, bong au i akaua pul ke patokongo la asi nga. ");
INSERT INTO apr_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Moolmool, asi nga bet si ayei di tooltool a bet nen ngan tiparpoto. Ngan nen le ‘tamoto kase in ole iportak le iyei koi pang tamana, inbe garup kase in ole iyei koi pang tinana, inbe garup kerenge atu in ole iyei koi pang roonoo garup, ");
INSERT INTO apr_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","inbe tool atu in rara ki ye taunu yo iye di tinepe ye rumu atu nga, ngan ole tiportak le tiyei koi panga.’ ");
INSERT INTO apr_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Sei tool yo lono pang tamana too tinana mai san, le illoso lono yo pau i nga, ngan ye in tool dook mata ke bet iyei galiuk tiap. Inbe tool yo lono pang natunu tamoto too natunu garup mai san, le illoso lono yo pau i nga, ngan ye in tool dook mata ke bet iyei galiuk tiap. ");
INSERT INTO apr_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Inbe sei tool yo lono bet isolo urata moonoo ben kai palasingi ki a itoo au tiap i, in tool dook mata ke bet iyei galiuk tiap. ");
INSERT INTO apr_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","E sei tool yo lono mai san ye nepongo ki ke tana i mai mata a iparama i, in ole ilene. Bong sei tool yo lono mai san ye nepongo ki ke tana i tiap, inbe iraia tinini le imot bet iyei urata kiau i, in ole ipusye nepongo dook mata yo taukan motingi i. ");
INSERT INTO apr_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Ngan nanga, sei tool bet ikau ang a iyei urata dook mata pang nga, ngan ben ikau au a iyei urata dook mata pau lapau. Inbe sei tool bet iyei urata dook mata pau nga, ngan iyei urata dook mata pang Tool Mai yo iwangau a asi, in lapau. ");
INSERT INTO apr_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Inbe sei tool bet ikamata tool atu ben ye in Maro koonoo atu le ikauu a iyei urata dook panga nga, ngan tool tani in ole ikap so dook mata gaongo leu ben ke di Maro koonoo ngan ye urata kootoonoo ki. Inbe sei tool bet ikamata tool atu ben ye in tool noonoonoo atu ke Maro le ikauu a iyei urata dook mata panga nga, ngan tool tani in ole ikap so dook mata gaongo leu ben ke di tooltool noonoodi ngan ye urata kootoonoo ki lapau. ");
INSERT INTO apr_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Inbe kumata le sei tool bet ikaua ran silene ruku atu pang di kakase maimai tiap nga atu a bet iyinu, yesoo ye in galiuk nga, ngan awete pang moolmool nen, tool in balingi yo bet ikauu ye urata kootoonoo ki i, in o ke bet ilene tiap.” ");
INSERT INTO apr_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Yesu ipatomonai di galiunu sangaul be ru ngan a imot, motong la igege ni tani in, inbe ipa mulu a ila ye malala maimai ke tana mai Galili la ipatomonai di tooltool, inbe iwetewete bingi dook mata ke Maro pang di. ");
INSERT INTO apr_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Ye kene tani in Yowan yo irriu di tooltool in titaru lo rumu dook tiap kidi talnga dikidiki lono oo. Le nga ye kene yo ilongo bingi ke Kirisi bet iyei urata ke Maro nga, motong la iwanga di galiunu bet la titoro Yesu. ");
INSERT INTO apr_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Le nga iwete pang di nen, “Kala ngan katoru nen. Kayei ne, ‘I ong tool tani yo Maro ipamede betanga ye bet ole iwanga a isi, in naii, too ole amtar matamam a amnama tool san mulu?’” ");
INSERT INTO apr_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Tila la titoru, motong la Yesu iraua betanga kidi nen, “Kamulu a kala ngan kawete pang Yowan ye betanga yo kalongo nga, inbe ye so yo kakamata ye matamu nga. ");
INSERT INTO apr_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Kayei ne, ‘Di mata kis tikamata ni mulu; inbe di tooltool yo kedi dook tiap nga, ngan kedi dook mata a tipa; inbe di tooltool yo botoboto medana ikan di nga, ngan tinidi dook mata mulu; inbe di tooltool yo talngadi dikidiki nga, ngan tilongo betanga; inbe di tooltool yo timmata koot nga, ngan timadit mulu; inbe di tooltool yo ballingadi tiap nga, ngan tilongo bingi dook mata.’ ");
INSERT INTO apr_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Ngan tool yo ikamatau ngan itara lono medana pau le imede i, in Maro ole iyei urata dook mata panga le lon ponana ye.” ");
INSERT INTO apr_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Yowan di galiunu tina ngan tigege a tila, motong la Yesu imadit ye betanga pang di tooltool malala mai tina ye Yowan tani nen. Iyei ne, “Ai, kene yo kala pang ye ni soorookoonoo nga, ngan kala bet la kakamata soo so? Bet la kakamata piu kaini yo muru iwalisi a ila bet iman i, too? ");
INSERT INTO apr_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Too gelei, bet la kakamata tool atu yo itar moro dook mata lo tinini i, too? O tiap! Di tooltool yo titar moro dook mata ilo tinidi le tinidi dook mata ye nga, ngan di tooltool yo nen nga, ngan tipas le tinepe leu ye rumu mai ke tool yo iyei kuto mai pang tana mai atu i. ");
INSERT INTO apr_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Oo kawete ngan, soo so kala bet la kakamata i? Nga o bet la kakamata Maro koonoo atu, too? E, moolmool. Bong nga bet awete pang nen, ye ni illos di Maro koonoo kapala yo ke mugu nga le imot. ");
INSERT INTO apr_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Ye tani in la Rau ke Maro iwetewete ye nen i. Iyei ne, ‘Kapalongo! Ole awanga tool atu ke bet imugu a ikaua bingi yong. Inbe ye la bet imugu a ikarata dada pong i.’ ");
INSERT INTO apr_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Awete pang moolmool nen, kataunu ye di tooltool yo tinepe tana i nga, ngan sa yo bet illoso Yowan yo irriu di tooltool i, in tiap. Bong ye di tooltool yo Maro matan kala di nga, ngan di le imot le isi ye kase maitiap kidi atu, ngan ke bet tilloso Yowan. ");
INSERT INTO apr_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Ngan ye kene yo Yowan ipamaditi urata ki le se dookoot nga, ngan dada yo Maro bet igaua di tooltool ki ye taunu a bet matan kala di ye i, in iman potai a bet pombe mallangana. Inbe di tooltool kapala tikapge bet tilo a tiye di tooltool yo Maro bet matan kala di nga, ngan tigaua. ");
INSERT INTO apr_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Ngan so tani yo mugu ngan Mose iye di Maro koonoo tiwetewete ye bet pombe i, in le se imot ye lal yo ke Yowan i. ");
INSERT INTO apr_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Kumata le katara lomu medana ye betanga kidi nga, ngan dook mata. Ngan nanga, Yowan in Ilia tani yo mugu ngan di Maro koonoo tiwetewete ye bet ole isi i. ");
INSERT INTO apr_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Le sei tool bet talngana nga, ngan itar talngana dook a ilongo betanga kiau nga. ");
INSERT INTO apr_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Nga ole ayei balai bet awete le ananpootoo di tooltool yo dookoot tinepe nga ye dada kidi nga? Di tooltool tina, ngan dawa ben di kakase yo tiwur ye ni ke yawaringi kaningi, inbe koodi pang di diedi nen, ");
INSERT INTO apr_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Am nga ammai kure pang a bet nen ngan kasiki, bong lomu pang sianga tiap sa. E amwou lelang pang a bet nen ngan katang, bong lomu pang tangini tiap lapau sa.’ ");
INSERT INTO apr_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Yowan in isi ngan isapariuu ye kaningi le yinungu. Ngan le tiwete mur ye nen, ‘Ai, tool ni so sidi inepe ye.’ ");
INSERT INTO apr_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Motong la Tool Moolmool ke Maro isi, ngan ikan bet iyin ngan le tiwete mur ye lapau. Tiyei ne, ‘Kakamata, tool ni tool mata kaningi inbe tool ke yinungu ran medana sa. Le iye di tooltool ke sodaningi pat le tooltool ke geingi sennene tigaua, inbe tikan be tiyin.’ Bong awete pang nen, ole kakamata lo galanga ke Maro ye dada yo bet iyeii le itara kanono dook mata ye i.” ");
INSERT INTO apr_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Di tooltool ke malala maimai kapala yo Yesu ipa bet iyei gogo mos matana matana a tikamata nga, ngan lodi bet tiportak lodi a titoo tiap. Ngan la le Yesu katen malmal a ipasak pang di nga. ");
INSERT INTO apr_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Iyei ne, “Atoo, ang di tooltool ke malala mai Korasin le Betsaida nga, ken kakamatang dook leu. Nga yo bet tool sa ilo malala mai Taia le Saidon lo iyei mos yo dawa ben ayei ye malala kiang nga, ngan matin nga le di tooltool ke Taia le Saidon tiportak lodi mukot ye sennene kidi yo tiyei nga, inbe tiwit mala pirara a tiwurur kaua punu a bet nen ngan tipapos lo madoko yo kidi nga. ");
INSERT INTO apr_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Bong awete pang nen, ye lal yo Maro itaru bet ikarata betanga kidi tooltool ye in nga, ngan ole iyemenai ang di tooltool ke Korasin le Betsaida ngan ye urata moonoo dook tiap ki taunu le ole illoso urata dook tiap masngana yo bet pombe pang di tooltool ke Taia le Saidon i. ");
INSERT INTO apr_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Inbe ang di tooltool ke malala mai Kapenam ngan lomu tar balai, ole Maro iyitmakang le kalo meneng lang katene ni, too? Tiap yege! Ole ikatte ang kadu meneng lopo ni, ye ni kidi matenge. Inbe mos yo pombe pang yang nga, ngan yo bet pombe ye malala mai Sodom a di tooltool ki tikamata nga, ngan matin nga tiportak lodi le tilledi tiap, bong nga tinepe go. ");
INSERT INTO apr_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Bong awete pang nen, ye lal yo Maro itaru bet ikarata betanga kidi tooltool ye in nga, ngan di tooltool ke Sodom ole urata moonoo masngana la bet pombe pang ye di i. Bong ang nga urata moonoo ke masngana yo dook tiap le illoso kidi i, in la bet pombe pang yang i.” ");
INSERT INTO apr_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Ye kene tani in Yesu ipatarau pang Maro nen, “Tamak, ong in Tool Mai ke lang inbe tana. Le au i ayitmaka em, yesoo kutarkoo so tina ngan ye di tooltool yo di tapdi tikamata di ben lo galanga kidi mai mata nga, inbe kupapos pang di tooltool yo taukadi lo galanga a tinepe le dawa ben di kakase nga. ");
INSERT INTO apr_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Le moolmool Tamak, ong taum kutoo lom yo dook mata i, inbe kuyei so nen.” ");
INSERT INTO apr_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Yesu ipatarau a imot, motong la iyei ne, “So le imot nga Tamak la itar lo bek i. Ngan tool sa yo bet lon galanga ye Natunu, ngan tiap, bong Tamana yetaleu la lon galanga ye i. Inbe tool sa yo bet lon galanga ye Tamana, ngan tiap, bong Natunu yetaleu la lon galanga ye i. Inbe di tooltool yo Natunu lono bet ipitnaia Tamana pang di nga, ngan di leu la bet lodi galanga ye Tamana tani in nga.” ");
INSERT INTO apr_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Motong la Yesu iwete mulu nen, “Ang di sima tooltool yo kasolo so moonoo le tinimu mallai nga, ngan kaman pang yau a man akaua maryoongoo dook mata pang. ");
INSERT INTO apr_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Kakaua kai palini kiau a kataru lo gurimu a bet nen ngan ole kayei urata kiau, dawa ben asara yo ene bulumakau in taunu itara kai palini ilo gurini a bet iyei urata ki nga. Au i tool ke kate malmal tiap, bong au tauk arautoo au le du anepe lopo. Le kayei nen, a bet nen ngan apatomonai ang a kakaua maryoongoo dook mata. ");
INSERT INTO apr_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Awete pang nen, yesoo kai palini yo bet ataru lo gurimu a kayei urata kiau ye i, in imoo tiap. Inbe so yo bet akap pang a kasolo nga, ngan imoo tiap lapau.” ");
INSERT INTO apr_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Ye kene tani in Yesu iye di galiunu timadit ye panga a tipa so le tilo kumu lono ke dingding patunu yo ke kaningi nga, ngan kene tani in lal kidi Yuda ke sungunu. Tilo tipa kumu lono, ngan di galiunu pitolo di le tikap dingding tina ngan patunu pattu a tikan. ");
INSERT INTO apr_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Bong di Paresi pattu tikamata di yo tiyei nen nga, le nga tipasak pang Yesu. Tiyei ne, “Ai, kumata! Di galium ngo tiyei dada yo wer kiam Yuda igunkalam bet amyei ye lal ke sungunu tiap nga.” ");
INSERT INTO apr_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Motong la Yesu iraua betanga kidi nen, “Ang nga kakinkata rau yo igasa so yo Dawiti iyeii ye kene yo iye di tooltool ki pitolo di ye i, in tiap, too? ");
INSERT INTO apr_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Ye in idewe a ilo rumu ke Maro lono, lo ikap porong yo tiyei paroranga ye ngan a iye di tooltool ki tikan. Ngan porong tina ngan ke bet di tooltool sorok tikan tiap, bong di tooltool ke paroranga so pang Maro, ngan di leu la bet tikan nga. ");
INSERT INTO apr_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Inbe nga bet atorang, ang nga kakinkata betanga ke Mose yo iwete ye di tooltool ke paroranga so pang Maro, nga lapau? Kanakana ye lal kidi Yuda ke sungunu nga, ngan tilo bareme mai ke sungunu lono a tiyei urata kidi ke paroranga so. Ngan tina tiyei nen, le ben tigarungu lal ke sungunu tani, bong ye Maro matana ngan tikapsap tiap sa. ");
INSERT INTO apr_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Bong awete pang nen, so yo maiyoko le illoso bareme ke sungunu i, in ye naii. ");
INSERT INTO apr_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Ngan Rau ke Maro iwete nen, ‘Dada yo lok panga mata i, in nen, bet lomu mulumulu ye di tooltool a kayei dada dook mata pang di, bong ye dada yo ke paroranga so pau, in tiap.’ Ngan la kumata bet lomu galanga dook ye betanga i punu nga, ngan o ke bet kagarung di tooltool yo tiyei toko busunu siap, ngan tiap. ");
INSERT INTO apr_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Awete pang nen, yesoo Tool Moolmool ke Maro, in ye la iyei Tool Mai pang lal kidi Yuda ke sungunu i.” ");
INSERT INTO apr_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Yesu igege ni tani, inbe ipa mulu le la pombe malala, a ipa so le ilo rumu kidi Yuda ke gaongo, in lono. ");
INSERT INTO apr_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Ilo ngan ipusye tool atu yo bene ikap rama in inepe rumu lono. Ngan di Paresi tisere dada yo bet tikaua Yesu pang ye di kuto maimai ke karatanga betanga a tiweteweta ye urata ki yo iyei nga. Le nga titoru nen, “Ai, nga bet amtorong. Bet tool sa igiri matamatenge kidi tooltool ye lal ke sungunu nga, ngan ole gelei, tool in iyei sennene, too tiap?” ");
INSERT INTO apr_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Motong la iraua betanga kidi nen, “Kumata le ang tina ngan atu bet asara ki yo ene sipsip in bet imol du gomo lono ye lal ke sungunu nga, ngan ole gelei, tool tani o ke bet la ikauu a iyiti se ete tiap, too? ");
INSERT INTO apr_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Bong awete pang nen, di tooltool nga so mai san ye Maro matana, le tillos di sipsip. Ngan la dook mata ke bet tayei urata a talon di ye lal ke sungunu lapau.” ");
INSERT INTO apr_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Motong la iwete pang tool tani yo ikap rama in nen, “Oo, kupadunu bem in.” Yeiso bet ipadunu bene tani, ngan le dook mata mulu le lo gaongo ye bene san. ");
INSERT INTO apr_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Bong di Paresi katedi malmal pang Yesu, le timadit a tidu tana du tigaua, inbe tikarata betanga yo bet tiraumate ye i. ");
INSERT INTO apr_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Yesu lon galanga ye dada yo bet di Paresi tiyeii panga i, le nga igege malala tani in, inbe ikoo pang ye ni san mulu. Ngan di tooltool alunu titoo a tila, motong la ilon di a ikarata matamatenge kidi le imot. ");
INSERT INTO apr_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Motong la iwetekala di bet ken tipaposi lo mallangana be. ");
INSERT INTO apr_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Ngan nen le betanga yo mugu ngan Maro koonoo Esai iweta i, in iyeii le kanono pombe. Ngan betanga tani in nen, ");
INSERT INTO apr_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“In kapraingi kiau yo apootoo pau in nain. Ye in lok panga mai san, le lok ponana ye dook. Au i ole amaia gurana ke Amuk Silene ilo ye, a nen ngan la iwetewete pang di tooltool yo tipa ye rara kidi Yuda tiap nga, ye dada dook mata noonoonoo yo lok bet titoo nga. ");
INSERT INTO apr_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Inbe ye in o ke bet iwete katkat, inbe iye di tooltool tiparsu ye betebetanga, ngan tiap. Inbe tool sa ke bet ilongo kalngana yo iwetewete le koonoo maimai malala katene, ngan tiap lapau. ");
INSERT INTO apr_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Di tooltool yo taukadi guradi le dawa ben piu kaini yo muru igorumu le telbe in nga, ngan o ke bet igarung di tiap. Inbe di tooltool yo ke bet di tapdi tilon di ye nepongo kidi tiap, le dawa ben sul yo ikan ngan matana kumukumu in nga, ngan o ke bet igarung di tiap lapau. Ole iyei nen le le lo so nga le imot titoo dada dook mata noonoonoo yo Maro lono bet titoo nga. ");
INSERT INTO apr_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Ngan nen le ene ole ingaua ni mai i le imot, inbe di tooltool yo tipa ye rara kidi Yuda tiap nga ole titar matadi, inbe tinamu ye so yo bet iyeii i.” ");
INSERT INTO apr_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Ye kene tani in di tooltool pattu tikaua tool atu yo so sidi idiwidiwoo le matan kis inbe men modo le iwetewete tiap i, in a iman pang ye Yesu. Motong la man Yesu iyeii le ikamata ni, inbe koon marra a iwetewete mulu nga. ");
INSERT INTO apr_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Ngan nen le di tooltool yo man tigauagaua nga, ngan tikamata so tani ngan titakrai ye. Le nga tiyei ne, “Ai, tool i o Dawiti Natunu, pa oo?” ");
INSERT INTO apr_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Bong di Paresi tilongo yo tiwetewete nen nga, le nga tiyei ne, “Tiap, tool in inganga di so sidi ye gurana ke kuto mai kidi so sidi yo ene Belsebul i.” ");
INSERT INTO apr_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Ngan Yesu lon galanga ye lodi, ngan oo. Le nga iwete pang di nen, “Ai, kumata bet di tooltool ke tana mai atu bet tiparpoto le tinepe ye budanga ru, inbe tipatoko nga, ngan ole di tapdi tigarung di. Inbe kumata bet rara atu yo tinepe ye rumu atu, too tinepe ye malala atu nga, ngan bet tiparpoto le tinepe ye budanga ru, inbe di tapdi tipatoko nga, ngan ole di le imot tilledi. ");
INSERT INTO apr_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Ngan gaongo leu ye Satan lapau. Kumata bet di tooltool ki tiparpoto le tinganga di diedi nga, ngan ole Satan tani in ikodo le imede balai? ");
INSERT INTO apr_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Ngan kumata betanga yo kawete ngan moolmool bet au i anganga di so sidi ye gurana ke Belsebul nga, ngan sei ilon di tooltool kiang a le tinganga di so sidi i? Belsebul tiap, too? Ngan nen le urata tina yo di tooltool kiang tina tiyei nen nga, ngan ipaposang ye betanga kiang yo kawete pau nga, ngan kallung ye. ");
INSERT INTO apr_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Bong kumata bet Maro Amunu la ikaua gurana ki pau a anganga di so sidi ye nga, ngan ole lomu galanga nen, dada yo Maro bet matan kala di tooltool ki ye i, in ye la pombe a iken mallangana pang i. ");
INSERT INTO apr_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Oo, nga bet atorang mulu. Kumata tool atu bet irookoo rumu ke tool atu yo gurana ki mai mata i a bet lo ipinau so ki nga, ngan ole iyei balai? Kulkulunu ngan ole iparama tool tani yo gurana ki mai mata in mugu a ipauu ngan, lo ngan bet lo ikap so ki tina yo iken rumu lono nga. ");
INSERT INTO apr_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Sei tool yo itoo au tiap i, in dawa ben koi kiau. Inbe tool yo ilonau a bet aye amgaua di tooltool pang Maro tiap i, in dawa ben tool yo bet inganga di tooltool a tikoo ye Maro i. ");
INSERT INTO apr_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Ngan nen le awete pang nen, sennene le imot kidi tooltool yo tiyei, inbe betanga dook tiap yo tiwete a tikan pasemau ye nga, ngan ole Maro igiri sennene kidi. Bong betanga dook tiap yo tiwete a tikan paseme Maro Amunu Silene ye nga, ngan ole Maro igiri sennene kidi ngan pitiap yege. ");
INSERT INTO apr_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Inbe kumata bet tool sa iwete mur ye Tool Moolmool ke Maro nga, ngan ole Maro igiri sennene ki. Bong kumata bet iwete mur ye Maro Amunu Silene nga, ngan sennene ki in ole iken nen dookoot nga, inbe pang dama ni a ila, ngan ole Maro igiri tiap lapau.” ");
INSERT INTO apr_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Motong la Yesu ikatte betanga san mulu pang di nen, “Kai yo dook mata i, in bet ipu nga, ngan ole itar kanono dook mata. Inbe kai yo dook tiap i, in bet ipu nga, ngan ole itar kanono dook tiap. Le kai tina ngan puadi la bet tipapos di, ngan lod galanga ye di nga. ");
INSERT INTO apr_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Ang nga moto dook tiap di natunu! Le ang ngan ke bet kawete betanga sa yo dook mata nga tiap. Ngan nen, yesoo so yo iken tool lono nga, ngan la iwete a ipas ye koonoo si mallangana nga. ");
INSERT INTO apr_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Tool yo dook mata i, in lon kaua urata ye so yo dook mata ngan leu, le ye dada le betebetanga ki nga, ngan ole ipapos so yo iken lono nga. Inbe tool yo dook tiap i, in lon kaua urata ye so yo dook tiap ngan leu, le ye dada le betebetanga ki nga, ngan ole ipapos so yo iken lono nga. ");
INSERT INTO apr_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Bong awete pang nen, ye lal yo Maro itaru bet ikarata betanga kidi tooltool ye in nga, ngan di tooltool ole tipapos betanga dook tiap kidi yo mugu ngan tiwete tana pono ngan se mallangana le imot. ");
INSERT INTO apr_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Le betanga kiang ang tapmu yo kawete tana pono nga, ngan la bet ipaposang se mallangana a nen ngan Maro iwetang ben ang ngan tooltool dook mata, too ang ngan tooltool dook tiap nga.” ");
INSERT INTO apr_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Yesu iwete pang di nen a imot, motong di Paresi pattu tiye di pannoongoo ke wer ke Maro tiwete pang Yesu nen. Tiyei ne, “Pannoongoo, lomam bet kuyeie mos sa a amkamata, a bet nen ngan iyei tarkilanga pong.” ");
INSERT INTO apr_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Motong la Yesu iraua betanga kidi nen, “Di tooltool yo dookoot tinepe nga, ngan titara lodi le imede ye Maro tiap, bong tiyei dawa ben garup dook tiap yo idada nintooroo a la iyei bauk i. Le kanakana nga, ngan titorau bet ayeie mos ke Maro sa a tikamata. Bong mos sa bet ayeii a tikamata tiap. Ole tikamata mos ataleu yo pombe ye Maro koonoo yo Yona i, in leu. ");
INSERT INTO apr_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Mugu ngan Yona iken i kapono lono ye ke tol inbe bong tol. Ngan gaongo leu, Tool Moolmool ke Maro ole iken tana lono ye ke tol inbe bong tol lapau. ");
INSERT INTO apr_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Ngan ye lal tani yo Maro itaru bet ikarata betanga kidi tooltool ye in nga, ngan ole di tooltool ke Ninibe tikodo dama ke Maro, inbe tipapos di tooltool yo dookoot tinepe nga, ye dada dook tiap kidi yo tiyei nga. Awete nen nga, yesoo di Ninibe tilongo betanga ke Yona tina yo iwete nga, ngan le tiportak lodi mulu. Bong Tool atu yo dookoot kaye kanepe i, in illoso Yona. ");
INSERT INTO apr_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Inbe ye lal yo Maro itaru bet ikarata betanga kidi tooltool ye in nga, ngan garup ene mai atu yo inepe ye ni yo karaka ipa ye i, in ole ikodo dama ke Maro, inbe ipapos di tooltool yo dookoot tinepe nga, ye dada dook tiap kidi yo tiyei nga. Awete nen, yesoo garup tani, in inepe ke tana damono, bong ipa ye manga mooloo a ise pang Yerusalem bet se ilongo betanga dook mata ke Solomon yo ipatomonai di tooltool ye nga. Bong Tool atu yo dookoot kaye kanepe i, in illoso Solomon.” ");
INSERT INTO apr_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Motong la Yesu ikatte betanga san mulu pang di nen, “Kumata so sidi bet ipas ye tool atu lono nga, ngan ole la ipa ye ni soorookoonoo a matan sarai ye ni dook mata yo bet inepe ye i. Bong kumata bet matan sarai le ikamata ni sa dook bet inepe ye tiap nga, ");
INSERT INTO apr_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","ngan ole iyei ne, ‘Au i nga ole amulukala rumu kiau yo mugu ngan agege i.’ Ngan kene yo imulu a ila pombe ye in nga, ngan ikamata rumu tani in tool sa inepe ye tiap, bong tisoraii le igalanga, inbe so yo iken rumu lono ngan iken dook mata ye nene. ");
INSERT INTO apr_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Motong la so sidi tani in imulu la iwete pang di diene so sidi limi be ru yo tillosi ye geingi dada dook tiap nga, ngan bet tiyei ene a tiye tila pang ye rumu tani bet la tinepe ye. Awete pang nen, tool tani in mugu ngan nepongo ki ben dook tiap mata tiap, bong yo dookoot nga nepongo ki dook tiap le dook tiap ki taunu. Ngan nanga, dada gaongo leu la bet pombe pang ye di tooltool dook tiap yo dookoot tinepe nga.” ");
INSERT INTO apr_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Yesu iwetewete pang di tooltool tina go, inbe tinana le di taini lodi bet tiye tiwetewete pa, le nga man tikodo ke diki, inbe tinamu. ");
INSERT INTO apr_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Motong la tool atu iwete panga nen, “Ai, tinam le di taim la man tikododo diki nga, ngan lodi bet kuye di kawetewete pa.” ");
INSERT INTO apr_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Ngan Yesu iraua betanga ki nen, “Di sima tinak le di taik nga?” ");
INSERT INTO apr_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Motong la isulmai di galiunu, inbe iyei ne, “Oo, kakamata, di tinak le di taik me e nga. ");
INSERT INTO apr_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Kumata le di sima tooltool bet titoo Tamak yo inepe ye malala ki ete ni i, in lono nga, ngan di ngan la di tinak le di taik nga.” ");
INSERT INTO apr_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Motong la ye ke tani in Yesu ipas a igege rumu tani, inbe ipa mulu le du iwur ran koonoo ke Galili. ");
INSERT INTO apr_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Ngan di tooltool alunu la tidu pompombe pang ye a tigaliuu le ni mangana siap. Le nga ipas lo ookoo lono, a lo iwur, inbe di tooltool tina ngan tikodo ke tana. ");
INSERT INTO apr_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Motong la iwete pang di ye so alunu ngan ikatte betanga ye. Nen le iwete pang di nen, “Ye kene atu ngan tool ke kapgingi atu in ikap dingding patunu ke kaningi bet la igiri kumu ki. ");
INSERT INTO apr_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Ngan kene yo igiri ye in nga, ngan kapala imol du dada katene. Ngan nen le di man tikamata le man tikan. ");
INSERT INTO apr_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Inbe dingding patunu kapala ngan imol du ye tana yo ke lopo ki in bongarngar le tana dook mata ke ete ngan mai mata tiap nga. Ngan nen le palbe leu be tisup, ");
INSERT INTO apr_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","bong ye kene yo ke ise a isini katkat ye in nga, ngan igesnai dingding supana tina le timallai a tiwod, yesoo ramini idu lopo mata tiap. ");
INSERT INTO apr_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Inbe dingding patunu kapala ngan imol du ooroo kaudangdang lono. Ngan nen le tisup pa ye kaudangdang le ooroo kaudangdang tani in iturai di le tisup dook tiap. ");
INSERT INTO apr_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Bong dingding patunu kapala yo imaruru du ye tana dook mata nga, ngan tisupsup dook mata le tipu belebele. Ngan kaini kapala ngan tipu ngan puadi ben 100, inbe kaini kapala ngan puadi 60, inbe kaini kapala ngan puadi 30. ");
INSERT INTO apr_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Le sei tool bet talngana nga, ngan itar talngana dook a ilongo betanga kiau nga.” ");
INSERT INTO apr_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Motong la di galiunu timan man titoru. Tiyei ne, “Ai, nga gelei bet kuwete betanga pang di tooltool ngan kotte betanga pang di nen nga?” ");
INSERT INTO apr_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Ngan Yesu iraua betanga kidi nen, “Mugu ngan dada yo Maro bet matan kala di tooltool ki ye i, in iken sollono, bong dookoot nga ye in lon ponana bet ipaposi pang a lomu galanga ye dook. Bong di tooltool kapala, ngan tiap. ");
INSERT INTO apr_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Kumata le sei tool bet lon galanga ye betanga ke Maro a itoo nga, ngan ole Maro ipagalanga lono ye betanga ki sa mulu le lo galanga ki ilo ete. Bong sei tool yo lon galanga ye betanga ki kasin, bong itoo tiap i, in Maro ole ikutak lo galanga kasin yo iken ye ngan le inepe sorok. ");
INSERT INTO apr_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Ngan ye punu i la le bet awete pang di tooltool, ngan akatte betanga ye i, yesoo di ngan tikamata urata ke Maro, bong o ke bet tikilala tiap. Inbe di ngan tilongo betanga ke Maro, bong o ke bet tilonga ngan lodi galanga ye punu nga tiap. ");
INSERT INTO apr_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Di ngan tiyei nen, le tiyeie betanga ke Maro koonoo Esai yo iweta i, in le kanono pombe moolmool. Ngan Esai ikaua Maro koonoo inbe iwete nen, ‘Kanakana ngan ole kalongo betanga yo Maro iwete nga, bong o ke bet lomu galanga ye tiap. Inbe kanakana ngan ole kakamata so yo Maro iyei nga, bong o ke bet kakilala tiap. ");
INSERT INTO apr_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Yesoo, di tooltool tina ngan lodi parkat le betanga ke Maro ilo lodi tiap, inbe tidikidiki talngadi le ke bet tilongo betanga ye tiap, inbe matadi kilikili le ke bet tikamata ni ye tiap. Ngan yo bet tiyei nen tiap nga, ngan matin nga le tikamata so ye matadi, inbe tilongo betanga ye talngadi, inbe lodi galanga ye, a bet nen ngan tiportak lodi a timulu pang yau man akarata di le dook mata.’ ");
INSERT INTO apr_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Bong ang nga lomu ponana, yesoo Maro iyei dada dook mata pang le matamu galanga a kakamata so, inbe talngamu nga gimono ke longono betanga. ");
INSERT INTO apr_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Awete pang moolmool nen, mugu ngan di Maro koonoo inbe di tooltool yo noonoodi ngan alunu la lodi bet tikamata so yo dookoot kakamata nga, bong le tikamata toko siap. Inbe lodi bet tilongo betanga ben yo dookoot kalongo nga, bong le tilongo toko siap lapau. ");
INSERT INTO apr_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Kapalongo a awete nini kattenge betanga ke tool yo igiri dingding patunu lo kumu lono ki i, in punu pang. ");
INSERT INTO apr_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Di tooltool yo tilongo bingi dook mata ke Maro ye dada yo bet matan kala di tooltool ki ye i, bong lodi galanga ye tiap nga, ngan di ngan ben dingding patunu yo imaruru du dada katene nga. Di ngan betanga ke Maro ilo lodi, bong isup tiao, inbe tool dook tiap Satan iman tina ngan le ikutak betanga ke Maro yo iken lodi nga. ");
INSERT INTO apr_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Inbe dingding patunu yo imol du ye tana yo ke lopo ki in bongarngar nga, ngan ben di tooltool yo tilongo betanga ke Maro ngan tikauu palbe leu a lodi ponana ye nga. ");
INSERT INTO apr_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Bong tina taukadi ramidi yo bet idu pang lopo nga, le ke bet tinepe le mooloo tiap. Ngan kumata bet moonoo sa pombe pang ye di, too di tooltool tikamata di ben titoo betanga ke Maro le bet tigarung di nga, ngan ole palbe leu inbe tigege lodi medana yo titaru i, inbe tiwala muridi pang Maro. ");
INSERT INTO apr_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Inbe dingding patunu kapala yo imol du ooroo kaudangdang lono nga, ngan ben di tooltool yo tilongo betanga ke Maro, bong lodi rru mai san ye nepongo kidi ke tana i, inbe balingi matana matana ke tana pono ikap matadi mai san. Ngan so tina ngan ikap matadi nen, le iduku betanga ke Maro yo iken lodi i, le betanga tani in itara kanono tiap. ");
INSERT INTO apr_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Bong dingding patunu yo imol du ye tana dook mata nga, ngan ben di tooltool yo tilongo betanga ke Maro ngan tikauu a lodi galanga ye nga. Ngan nen le di ngan titar kanodi alunu dook mata dawa ben dingding patunu yo tipu ngan kaini kapala titar kanodi ben 100, inbe kaini kapala ngan kanodi 60, inbe kaini kapala ngan kanodi 30 nga.” ");
INSERT INTO apr_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Motong la Yesu iwete le ikatte betanga san mulu pang di nen, “Dada yo Maro bet matan kala di tooltool ki ye i, in dawa ben tool atu yo igiri dingding patunu ke kaningi lo kumu lono ki i. ");
INSERT INTO apr_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Bong yeiso bet bong a di tooltool tikenen mata le imot, motong koi ki iman a lo igiri dingding dook tiap patunu lo ikatbon yo dook mata nga, inbe ikoo a ila. ");
INSERT INTO apr_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Le ye kene yo dingding dook mata patunu bet tisupsup nga, ngan dingding dook tiap patunu lapau tiye di tisupsup. ");
INSERT INTO apr_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","“Motong la di kapraingi ke kumu taunu tani la tiwete panga nen. Tiyei ne, ‘Tool mai, ong i kugiri dingding dook mata patunu idu ye kumu kiong, e dingding dook tiap patunu ngo ipa ngai a se tisupsup ye kumu kiong lapau nga?’ ");
INSERT INTO apr_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","“Ngan kumu taunu iraua betanga kidi nen, ‘Ona, o koi kiau sa la iyei dada nen pau i.’ “Motong la di kapraingi ki titoru. Tiyei ne, ‘Le nga lom balai, bet la amlama dingding dook tiap ngo, too?’ ");
INSERT INTO apr_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","“Ngan iyei ne, ‘Tiap. Yesoo, kumata bet la kalama di nga, ngan ole kalama le ipa ye dingding yo dook mata nga lapau. ");
INSERT INTO apr_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Le ken kalama be, bong sila tiken nen a tidada gaongo a tilo le lo ye lal yo ke saputungu dingding ngan. Ngan ye lal tani in ole awete pang di tooltool ke saputungu dingding bet tilama dingding yo dook tiap ngan mugu a tiliki ye ooroo, inbe tikatte lo ei ikan. Lo ngan bet tisaput dingding yo dook mata ngan a tikap kanono lo tigaun badabada lono kiau.’” ");
INSERT INTO apr_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Motong la Yesu iwete le ikatte betanga san mulu pang di tooltool tina nen, “Dada yo Maro bet matan kala di tooltool ki ye i, in dawa ben kai mastet patunu yo tool atu ikauu a ipe du kumu lono ki i. ");
INSERT INTO apr_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Ngan kai patunu kapala yo bet kupe nga maimai, bong mastet in maitiap. Bong kumata bet isup a ise le mai nga, ngan ole illos so le imot yo kupe du kumu lono nga. Le di man yo tiro lang katene nga, ngan ole timan man tire giniu kidi ye bene a tinepe ye.” ");
INSERT INTO apr_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Motong la Yesu ikatte betanga san mulu pang di nen. Iyei ne, “Dada yo Maro bet matan kala di tooltool ki ye i, in dawa ben yis yo tataru lo ye porong ngan iyeii a isung i. Garup atu ikaua so mai tiap tani a itaru ilo ye porong tina maiyoko in a ipargarungnaii ye, ngan le iyeie porong tani a isung le imot.” ");
INSERT INTO apr_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Ngan betanga le imot yo Yesu iwete pang di tooltool budanga mai yo man tigaua nga, ngan iwete le ikatte betanga ye leu. Inbe betanga sa yo bet iweta ngan punu iken mallangana pang di ngan tiap, bong ikatte betanga leu pang di. ");
INSERT INTO apr_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Ngan tina iyei nen nga, le iyeie betanga ke Maro koonoo atu yo iweta in le kanono pombe moolmool. Ngan Maro koonoo tani iwete nen, “Au i bet awete pang di, ngan ole akatte betanga leu. Inbe so le imot yo iken sollono ye kene yo Maro itar lang le tana ye in nga, ngan ole awete pang di ye.” ");
INSERT INTO apr_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Yesu iwetewete pang di a imot, motong la igege di, inbe idewe a ilo pang rumu lono. Ngan di galiunu titoo a tilo ye rumu lono a lo titoru. Tiyei ne, “Ai, lomam bet kupagalanga betanga lono ke dingding dook tiap yo isupsup kumu lono in pam dook a lomam galanga ye.” ");
INSERT INTO apr_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Motong la iraua betanga kidi nen, “Tool yo ananpootoo ye kumu taunu bet igiri dingding patunu dook mata lo kumu ki i, in Tool Moolmool ke Maro. ");
INSERT INTO apr_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","E kumu in tana mai i le imot. Inbe dingding dook mata patunu nga, ngan di tooltool yo Maro igaua di panga bet matan kala di nga. Inbe dingding dook tiap, ngan di tooltool yo tool dook tiap, Satan, iyei mai pang di nga. ");
INSERT INTO apr_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Inbe koi ke kumu taunu yo igiri dingding dook tiap patunu lo kumu lono i, in tool kuto mai kidi so sidi. Inbe lal ke saputungu dingding, in lal yo bet tana i imot ye i. E di kapraingi ke kumu taunu nga, ngan di bangabangana ke Maro. ");
INSERT INTO apr_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Ngan dingding dook tiap yo tilama a bet tidaun ye ei nga, ngan ye lal yo Maro itaru bet tana i imot ye in nga, ngan ole di bangabangana ki tiyei nen lapau. ");
INSERT INTO apr_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Le ye kene tani in Tool Moolmool ke Maro ole iwanga di bangabangana ki si tikap di tooltool yo tiyei di tooltool a la tiyei sennene nga, le tipa ye di tooltool kapala yo tikapsap ye sennene nga, ngan a tikoo ye di tooltool yo Maro bet matan kala di nga. ");
INSERT INTO apr_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Ngan ole tikap di a tikatte di lo ei somai lono. Ngan ni tani in di tooltool tina ole timassingi a titangtang, inbe tikanen dongadi a iparrasa. ");
INSERT INTO apr_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Bong di tooltool yo noonoodi nga, ngan ole milmilbe dawa ben ke matana, inbe ole tilo ye malala ke Tamadi a tiye di tooltool yo matan kala di nga, ngan tinepe. Le sei tool bet talngana nga, ngan itar talngana dook a ilongo betanga kiau nga.” ");
INSERT INTO apr_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Motong la Yesu iwete le ikatte betanga san mulu pang di galiunu nen, “Dada yo Maro bet matan kala di tooltool ki ye i, in dawa ben pat ke yimoongoo so yo iken ye karei mai atu a tikelmaii du tana lono i. Ngan pat tani in iken nen le tool san ipusye, motong la itarkoo mulu sila iken. Ngan nen le tool tani in lon ponana kaiye le ila, ngan la iyawar so ki ngan le imot a ikap pat ye, a bet nen ngan imulu la iyimi tana tani yo tikelmaia pat ye i, in panga.” ");
INSERT INTO apr_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Motong la ikatte betanga san mulu nen, “Dada yo Maro bet matan kala di tooltool ki ye i, in dawa ben tool atu yo ipa bet isere pat ke gomo yo sallinene dook mata i. ");
INSERT INTO apr_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Kumata bet ipa le ipusye atu yo sallinene dook mata le dook mata kaiye in nga, ngan ole la iyawar so ki le imot a ikap pat ye, a bet nen ngan imulu la iyimi pat ke gomo tani, in panga.” ");
INSERT INTO apr_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Motong la Yesu ikatte betanga san mulu pang di nen, “Dada yo Maro bet matan kala di tooltool ki ye i, in dawa ben pu yo di tooltool tikatte du ran lono a tikap di i matana matana ye i. ");
INSERT INTO apr_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Yeiso bet di i tilo tilo le pu tani in ipon, motong di tooltool ke yoosoongoo tiyolo pu tani in idi tana. Idi tana, motong la du tiwur, inbe tipinai di i yo dook mata nga, ngan a ilo karei lono. E yo dook tiap nga, ngan tikatte di. ");
INSERT INTO apr_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Ngan dada gaongo leu nen la bet pombe pang ye di tooltool ye lal yo Maro itaru bet tana i imot ye i. Ye kene tani in di bangabangana ke Maro ole tisi bet si tipinai di tooltool ke geingi dada dook tiap nga, ngan a tikoo ye di tooltool yo noonoodi nga. ");
INSERT INTO apr_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Lo ngan bet tikatte di tooltool ke geingi dada dook tiap nga, ngan tidu ye ei somai lono. Ngan ni tani in ole timassingi a titangtang, inbe tikanen dongadi a iparrasa.” ");
INSERT INTO apr_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Motong la Yesu itor di galiunu nen, “Betanga le imot yo awete nga, ngan ang nga lomu galanga ye punu lapau?” Ngan di galiunu tiyei ne, “E.” ");
INSERT INTO apr_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Motong la Yesu iwete pang di nen, “Ngan nen le di pannoongoo ke wer ke Maro yo lodi galanga dook ye dada yo Maro bet matan kala di tooltool ki ye in nga, ngan ke bet tipatomonai di tooltool ye betanga paunu inbe ye betanga gurunu lapau. Le di ngan dawa ben rumu taunu atu ilo rumu lono ki a lo ipadu so dook mata ki yo paunu nga, inbe yo gurunu ngan lapau a isi tana.” ");
INSERT INTO apr_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Ye kene yo Yesu ikatte betanga tina ngan pang di a imot nga, ngan le imadit a igege ni tani in. ");
INSERT INTO apr_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Inbe ipa ngan le lo pombe ye malala ki ye taunu, motong la ilo rumu kidi Yuda ke gaongo in lono, a lo ipatomonai di tooltool. Ngan di tooltool tina tilongo betanga ki le tisorreke ni ye, le nga di tapdi tipartortor. Tiyei ne, “Ona tiap! Tool i lo galanga inbe gurana yo iyei mos ye nga, ngan ikap ngai? ");
INSERT INTO apr_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Tool i, tool ke renge rumu, in natunu. Inbe tinana la Madia i. Inbe di taini la Yemis ye Yosep ye Simon inbe Yuta nga. ");
INSERT INTO apr_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Inbe di lini nanga la taye di tanepe ni nga. E tool i nga ikap lo galanga le gurana nga ngai?” ");
INSERT INTO apr_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Ngan tina tikamata ben ye in tool sorok nga, le tiwala muridi panga. Bong ngan Yesu iwete pang di nen, “Awete pang nen, kumata bet tool iyei Maro koonoo nga, ngan di tooltool ke malala ki ye taunu inbe di rara ki nga, ngan di leu la lodi bet tilongo betanga ki inbe tiraua panga tiap nga.” ");
INSERT INTO apr_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Ngan nen le iyei mos sa alunu tiap, yesoo di tooltool ke malala ki titara lodi medana panga tiap. ");
INSERT INTO apr_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Ye kene tani in Erot Andepas yo iyei tool kuto mai a matan kala tana mai ke Galili i, in ilongo bingi ke Yesu ye urata maimai yo iyei nga, ");
INSERT INTO apr_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","le nga iwete pang di kapraingi ki. Iyei ne, “Ai, tool ni o Yowan yo irriu di tooltool, in pa oo. Ye tani la o imadit mulu ye ni ke matenge i, ngan la le gurana ki mai san ke bet iyei gogo mos ye nga.” ");
INSERT INTO apr_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Erot tani, in mugu ngan iwete le di tooltool ki tikaua Yowan a tipauu, motong la titaru lo rumu dook tiap kidi talnga dikidiki lono, yesoo Yowan ipasak panga ye yo iyooloo toonoo Pilip rimana yo Erodias in nga. ");
INSERT INTO apr_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Ye kene tani in Yowan iwete pang Erot nen, “Ong i nga kopsap ye wer ye yo kuyooloo garup in nga.” ");
INSERT INTO apr_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Ngan nen le Erot lono mai san bet iraumata Yowan a imata, bong itattadai di tooltool ke Yuda, yesoo di ngan tikamata Yowan ben ye in Maro koonoo atu. ");
INSERT INTO apr_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Tinepe, tinepe, le tilo ye kene yo bet lodi tut ye lal yo Erot tinana ipasuiu ye i, motong la iyeie kanningi maiyoko atu bet tikanen ye lal tani in. Inbe ye kene tani in Erodias natunu garup, in man iki la di tooltool maimai tina matadi, le Erot ikamata ngan lon ponana ye mai san. ");
INSERT INTO apr_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Le nga Erot ipamede betanga ki pang garup kase tani nen, “Awete pong moolmool le ete nen. Soo so yo lom panga mai mata i, in kuweta, ngan ole akauu pong.” ");
INSERT INTO apr_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Motong la garup kase tani la itoro tinana ye so yo bet Erot ikauu panga i, ngan tinana iwete panga ye Yowan yo irriu di tooltool in kutono. Le nga itoo tinana koonoo a imulu la iwete pang Erot nen, “Lok bet kukurutu Yowan yo irriu di tooltool, in gurini, inbe kunono kutono lo ye tawiri atu a kuwi pau dookoot nga.” ");
INSERT INTO apr_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Ngan tool kuto mai tani in ilongo betanga ke garup kase tani ngan lon moo ye dook. Bong ngan ipamede betanga medana a iwete moolmool le ete la di diene tina yo iye di tikan so, ngan matadi oo, le nga iwete bet tikaua so yo garup kase tani iwete ye, in panga. ");
INSERT INTO apr_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Ngan nen le iwanga di tooltool ki yo bet matadi kala nga, ngan tilo rumu kidi talnga dikidiki lono a lo tisaputu Yowan tani in gurini. ");
INSERT INTO apr_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Motong la tikaua kutono a tinona lo tawiri lono, inbe tikauu pang garup kase tani a ikauu lo ikauu pang tinana. ");
INSERT INTO apr_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Motong la Yowan di galiunu tilongo bingi ki yo imata koot nga, le nga timan man tikaua bobono a la tikelmaii. Motong la tila la tikaua bingi ye pang Yesu nga. ");
INSERT INTO apr_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Ye kene tani in Yesu ilongo bingi ke Yowan yo imata nga, motong la igege malala tani, inbe ipasnaka panga le du iyiri ye ookoo atu a ila pang ye ni balim koonoo atu. Bong di tooltool alunu tilongo bingi ke Yesu yo ila nga, motong la tigege malala kidi, inbe tipa tana a titoo a tila. ");
INSERT INTO apr_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Le nga ye kene yo la ookoo ki isolo tana ye in nga, ngan Yesu ikamata di tooltool malala mai tina yo tinepe nga. Ngan nen le ye in lono pang di, le nga ikarata di a matamatenge kidi imot, inbe tinidi dook mata mulu. ");
INSERT INTO apr_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Tinepe ye ni tani in a du rrai, motong la Yesu di galiunu timan tiwete panga nen, “Ai, ni yo tanepe ye i, i ni balim koonoo, inbe nga rrai oo. Le kuwete pang di tooltool nga a tila pang ye malala kapala, a bet nen ngan la di tapdi tiyimi kaningi yo bet tikan nga.” ");
INSERT INTO apr_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Motong la Yesu iraua betanga kidi nen, “Di tooltool nga o ke bet tila tiap. Ole ang tapmu kakap kaningi pang di a tikan.” ");
INSERT INTO apr_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Ngan di galiunu tiwete panga nen, “Ona tiap! Am nga porong kiam nga dukumu limi, inbe i paranga kiam nga ru leu.” ");
INSERT INTO apr_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Motong la Yesu iwete pang di nen, “Kakap porong le i ngan man yau.” ");
INSERT INTO apr_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Inbe iwete pang di tooltool malala mai tina bet du tiwur dingding pono. Motong la ikap porong dukumu limi ipa ye i ru tina, inbe itada pang lang katene a iwete lo ponana ki pang Maro ye. Motong la itepalapala a isuket pang di galiunu bet timalimi di tooltool tina ye a tikan. ");
INSERT INTO apr_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Ngan di tooltool tina ngan di le imot tikan tikan le lo kapodi sung dook. Motong la di galiunu tiwinnoko kaningi naunu naunu tina yo tiwulai nga, ngan le tipadid ye karei sangaul be ru le lo ipon. ");
INSERT INTO apr_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Ngan kinkatingi kidi tooltool yo tikan so nga, ngan di tamoto leu ngan ben 5,000. Bong di garup le kakase kidi yo tiye di tikan so nga, ngan tikinkat di tiap. ");
INSERT INTO apr_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Tikan so a imot, motong la Yesu ipagaigai di galiunu bet tisuku ookoo kidi, a bet nen ngan tipoi a timugu pang ran koonoo kapala. E ye taunu in bet sila inepe a itar di tooltool tina a tila pang malala kidi kidi ngan. ");
INSERT INTO apr_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Itar di a tila, motong la yetaleu inau a ilo pang kawal bet lo ipatarau. Ngan ke bet idu iyara a bet ni burrum, ngan Yesu yetaleu inepe la kawal ngo. ");
INSERT INTO apr_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","E di galiunu tina ngan tipoi a tila ke ran kataunu ni, a manga mooloo ye tana oo. Bong eng ipakala di ke dama le nga tirookoorookoo kokor maimai dook. ");
INSERT INTO apr_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Ngan Yesu inepe kawal le lo pang malama, motong la idu a ipa ran pono pang ye di a ila. ");
INSERT INTO apr_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Ipa a ila potai pang ye di, motong la tikamata yo ipa ran pono a bet ila pang ye di nga. Le nga titattadai a titangarur, inbe tisulu. Tiyei ne, “Ai, nisene atu la iman pang yidi i!” ");
INSERT INTO apr_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Bong palbe leu be Yesu koonoo pang di nen, “Katattadai be! I au tani naii. Ken lomu mede leu.” ");
INSERT INTO apr_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Motong la Pita iwete panga nen, “Tool Mai, bet in ong moolmool nga, ngan kuwete le apa ran pono a amala pang yong.” ");
INSERT INTO apr_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Ngan Yesu iyei ne, “Oo, nen ngan kuman.” Motong la Pita ipas a igege ookoo, inbe idu ipa ran pono a ila pang ye Yesu. ");
INSERT INTO apr_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Bong ye kene yo ipa a ila ye in nga, ngan ikamata kokor ke eng tani maimai leu, le nga itattadai, inbe kotorbe kasin pang ran lono. Yo ngan le taun koonoo palbe pang Yesu. Iyei ne, “Atoo, Tool Mai, kulonau!” ");
INSERT INTO apr_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Motong la palbe leu be Yesu iro bene du ikauu a iyitmaki, inbe iwete panga. Iyei ne, “Ong i kutara lom medana pau mai mata tiap sa! Nga gelei, a le bet lom rru nga?” ");
INSERT INTO apr_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Ye kene yo yeru tila a tiyiri lo ookoo lono ye in nga, ngan le eng mai tani in imata. ");
INSERT INTO apr_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Motong la Yesu di galiunu yo tinepe ookoo lono nga, ngan tisung panga. Tiyei ne, “Moolmool yege, ong i Maro Natunu moolmool sa.” ");
INSERT INTO apr_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Motong la tipoi saut a tila, ngan le la tisolo ye malala atu yo ene Genesaret i. ");
INSERT INTO apr_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Yeiso bet di tooltool ke malala tani ngan tikilala Yesu, motong tiwanga pang di tooltool ke malala kapala yo iken potai pang ye malala tani nga le imot. Le nga di tooltool tina ngan tikap di tooltool kidi yo matamatenge ikap di nga, ngan a timan pang ye Yesu. ");
INSERT INTO apr_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Timan, motong la timangmang ye bet imalum a di tooltool yo matamatenge ikap di nga, ngan tipas le titoko sousoungu matana ki leu, a bet nen ngan matamatenge kidi imot. Ngan nen le di tooltool yo titoka nga, ngan tinidi dook mata mulu. ");
INSERT INTO apr_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Ye kene tani in di Paresi pattu tiye di pannoongoo ke wer ke Maro, ngan tipa ke Yerusalem a timan pang ye Yesu man titoru. Tiyei ne, ");
INSERT INTO apr_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Ai, nga gelei a di galium nga titoo dada kidi sasa kiam tiap nga? Kumata, di ngo titoo momo kiam ke ngasingi bede a tingas bedi mugu lo ngan bet tikan so, ngan tiap!” ");
INSERT INTO apr_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Motong la iraua betanga kidi nen, “Nga gelei a karautoo wer ke Maro, inbe katoo momo kidi sasa kiang ang tapmu nga? ");
INSERT INTO apr_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Awete nen nga, yesoo Maro iwete nen, ‘Kuraua pang tamam le tinam a kulongo betanga kidi.’ Inbe iwete mulu nen, ‘Bet tool iwete betanga dook tiap a bet igarungu tamana too tinana ye nga, ngan karaumate a imata.’ ");
INSERT INTO apr_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Bong ang nga dada kiang yo kapatomonai di tooltool ye i, in nen. Kumata le tool atu in pat le so ki bet ilono tamana too tinana ye, bong iwete pang di nen, ‘So kiau yo bet alonang ye a kakap yau nga, ngan awetekala a akap ye lo ponana kiau pang Maro oo,’ ");
INSERT INTO apr_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","ngan kumata bet iyei nen nga, ngan ang nga kawete bet tool tani in ke bet ipamulu so tina ye Maro inbe ilono tamana too tinana ye tiap. Le ye dada kiang yo kayeii nen i, in ang nga katoo momo kiang ang tapmu, inbe karautoo betanga ke Maro ye. ");
INSERT INTO apr_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Ang nga tooltool ke kaplungunu sa! Le betanga ke Maro yo mugu ngan ikap pang Esai a iwetewete yang nga, ngan moolmool sa. Ngan betanga tina ngan iwete nen, ");
INSERT INTO apr_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Di tooltool nga tiyitmaka ek ye koodi pono leu, bong lodi yo bet pau nga, ngan iken manga mooloo yau. ");
INSERT INTO apr_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Di ngan tiwete bet tipatomonai di tooltool ye betanga ke Maro yo moolmool i, bong tiap, tipatomonai di tooltool ye dada le momo yo ke di sasa kidi nga leu. Ngan la le sungunu kidi yo kanakana ngan tisung pau ye nga, ngan taukan kanono.’ ” ");
INSERT INTO apr_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Yesu iwete pang di tooltool maimai tina a imot, motong la ikiu di tooltool malala mai a timan pang ye, inbe iwete pang di. Iyei ne, “Katar talngamu ye betanga kiau i, inbe lomu kaua urata ye. ");
INSERT INTO apr_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","So yo bet tool ikani ye koonoo a ilo kapono lono i, in ke bet igarungu le giri leu ye Maro matana tiap. Bong so yo iken tool lono, lo ngan bet ipas ye koonoo a isi in la bet igarungu le giri leu ye Maro matana i.” ");
INSERT INTO apr_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Motong la di galiunu timan pang ye man titoru. Tiyei ne, “Ai, nga lom galanga ye di Paresi ngo lapau? Di ngo tilongo betanga kiong yo kuweta i le lodi dook tiap ye sa.” ");
INSERT INTO apr_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Ngan iraua betanga kidi nen, “Tamak yo inepe ye malala ki ete ni, in so le imot yo ipe tiap nga, ngan ole igama di le ipa ye ramidi. ");
INSERT INTO apr_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Le lomu rru ye di pang soo? Sila tikino! Di ngan dawa ben di tooltool mata kis yo bet tipitnaia dada pang di diedi nga. Bong awete pang nen, kumata bet tool mata kis atu bet irara ene mata kis san nga, ngan ole yeru le ru, bet timol du gomo lono.” ");
INSERT INTO apr_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Motong la Pita iwete panga nen, “Ole kupagalanga lomam ye kattenge betanga yo kuweta i, in lono ki.” ");
INSERT INTO apr_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Tina Pita iwete nen nga, le nga Yesu itor di nen, “Nga gelei, ang nga o taukamu lo galanga lapau, too? ");
INSERT INTO apr_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Nga gelei, ang nga o ke bet kakap tarrai betanga tiap, too? Kalongo, so yo bet tool ikani ye koonoo a ilo kapono lono i, in ole ipa ye dada ki a idu pang tana. ");
INSERT INTO apr_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Bong so dook tiap la iken tool lono, lo ngan bet ipas ye koonoo a isi pang tana i, in la bet igarungu tool tani le giri leu ye Maro matana i. ");
INSERT INTO apr_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Le so dook tiap yo awete iken tool lono lo ngan bet ipas ye koonoo nga, ngan so nen: lon kap gogo dada dook tiap, inbe iyei dada dook tiap ke raumatenge di tooltool a timmata, inbe iyei bauk, inbe ikapsap ye dada ke kerenge, inbe iyei dada dook tiap ke pinnau, le isopo koonoo ye betanga doko, inbe illung pang di tooltool a igarung edi. ");
INSERT INTO apr_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Le dada dook tiap yo nen nga, ngan la igarungu tool le giri leu ye Maro matana nga. Bong bet ingas bene tiap bet ikap so a ikan, in ke bet igarungu le giri leu ye Maro matana tiap.” ");
INSERT INTO apr_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Yesu iwete pang di galiunu nen a imot, motong la igege malala tani, inbe ipa le la pombe ye tana mai yo malala mai ru Taia le Saidon iken ye i. ");
INSERT INTO apr_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Motong la garup atu ke Kenan yo ipa ye rara kidi Yuda tiap a inepe ye ni tani i, in iman pang ye man itang panga, inbe iyei ne, “Tool Mai, ong in Dawiti Natunu. Lom pau! Natuk garup ni so sidi idiwidiwoo a igarungu, le imassingi dook tiap yege.” ");
INSERT INTO apr_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Bong ngan Yesu mala bet iwete toko kan betanga siap. Le nga di galiunu timan ye man tiwete panga nen, “Ai, kuwete pang garup ni a ikoo a ila, yesoo ye la itangtang a itoo idi i.” ");
INSERT INTO apr_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Motong la iraua betanga kidi nen, “Au i Tamak iwangau a asi nga pang di tooltool ke Isrel leu. Di ngan dawa ben di sipsip yo taukadi taudi a tilledi nga.” ");
INSERT INTO apr_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Motong la garup tani in ipa le iman potai ye Yesu, inbe igun turunu du kene punu ke dama, inbe iyei ne, “Tool Mai, kulonau!” ");
INSERT INTO apr_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Ngan Yesu iwete panga nen, “Kumata bet takap kaningi kidi kakase a takatte mugu pang di gaunu bet tikan nga, ngan in dada dook tiap.” ");
INSERT INTO apr_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Bong ngan garup tani in iraua betanga ki nen, “Tool Mai, betanga kiong in moolmool. Bong di gaunu nga, ole tikan kaningi morrana yo imaruru du kakawa parmana ke di taudi nga, ngan lapau.” ");
INSERT INTO apr_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Motong la iwete pang garup tani nen, “Garup, kutara lom medana pau mai mata. Le so yo lom bet alonong ye i, in ole pombe ben tina yo kuwete nga.” Ye kene yo Yesu iwete nen ye in nga, ngan le pattu leu be natunu garup tani in tinini dook mata mulu. ");
INSERT INTO apr_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Yesu igege ni tani, inbe imadit a ila pang ran koonoo Galili. Motong la ipa a ilo pang kawal atu madini a lo iwur a inepe. ");
INSERT INTO apr_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Motong la di tooltool alunu le alunu kaiye la timan pang ye nga, ngan tikap di tooltool yo kedi dook tiap nga, inbe di tooltool yo matadi kisis nga, inbe di tooltool kapala yo turadi ikalel nga, inbe di tooltool yo medi modo a tiwetewete tiap nga, inbe di tooltool kapala yo matamatenge matana matana ikap di nga, ngan a timan tigaun di Yesu kene punu, inbe ikarata di le tinidi dook mata mulu. ");
INSERT INTO apr_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Ngan nen le di tooltool tina yo man tigaua nga, ngan tikamata di le titakrai ye yo di tooltool yo medi modo ngan tiwetewete mulu; inbe di tooltool yo turadi ikalel nga, ngan dook mata mulu; inbe di tooltool yo kedi dook tiap nga, ngan tipa mulu; inbe di tooltool yo matadi kisis nga, ngan tikamata ni mulu. Le lodi ponana a tiyitmaka Maro kidi Isrel, in ene. ");
INSERT INTO apr_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Motong la Yesu ikiu di galiunu a man iwete pang di nen, “Au i lok pang di tooltool nga san, yesoo timan a man taye di tanepe nanga ye ke tol oo, le dookoot nga taukadi so yo bet tikani i. Bong lok bet awete a timagiri pang malala kidi, ngan tipa ye pitolo kidi tiap. Kumata bet ayei di nen nga, ngan ole la matadi taltalai ye pitolo kidi dada mai.” ");
INSERT INTO apr_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Motong la di galiunu tiwete panga nen, “Dook mata, bong ni balim koonoo sa. Ole amkap porong le alunu ngai bet ampakan di tooltool malala mai nga ye i?” ");
INSERT INTO apr_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Tiwete nen, motong la Yesu itor di nen, “Porong kiang ngan dukumu pi?” Ngan tiyei ne, “Porong kiam nga dukumu limi be ru, inbe i kiam natnatunu pattu nanga la ikenen nga.” ");
INSERT INTO apr_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Motong la Yesu iwete pang di tooltool budanga mai tina bet du tiwur tana. ");
INSERT INTO apr_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Inbe ikap porong limi be ru ngan ipa ye i tina, inbe iwete lo ponana ki pang Maro ye. Motong la itepalapala a isuket pang di galiunu a timalimi di tooltool budanga mai tina ye. ");
INSERT INTO apr_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Ngan di tooltool tina ngan di le imot tikan le kapodi sung dook mata. Motong la Yesu di galiunu tiwinnoko kaningi naunu naunu tina yo iken nga, ngan a tipadid ye karei limi be ru le lo ipon. ");
INSERT INTO apr_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Ngan di tooltool tina yo tigaua a Yesu ipakan di nga, ngan tikinkat di tamoto leu nga, ngan ben 4,000. Bong di garup le di kakase kidi yo tiye di tikan so nga, ngan tikinkat di tiap. ");
INSERT INTO apr_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Yesu itar di tooltool tina a timulumulu pang ye malala kidi kidi, motong la iyiri lo ookoo pono a ila pang ye tana mai san yo iken potai pang ye malala yo ene Magadan i. ");
INSERT INTO apr_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Tinepe a kene san, motong la di Paresi le di Sedusi timan pang ye Yesu bet man titoua. Le nga titoru bet iyeie mos ke Maro sa pang di a tikamata, a nen ngan lodi galanga ye ben ye in iyei urata ke Maro. ");
INSERT INTO apr_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Motong la iraua betanga kidi nen, “Rrai bet ke idu le kakamata tete ikororo nga, ngan ole kayei ne, ‘Mongmong ngan ole eng siap.’ ");
INSERT INTO apr_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Inbe muntu bet ke ise le kakamata lang katene ikoro inbe ikolomuk nga, ngan ole kayei ne, ‘Katai nga ole eng pa, inbe ki imol.’ Le ang nga kakamata so yo ke lang katene nga, inbe lomu galanga ye, ngan le moolmool ben tina yo kawete nga. Bong so kapala yo pombe pang yang dookoot nga, ngan ang nga kakamata ngan o ke bet lomu galanga ye tiap. ");
INSERT INTO apr_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Di tooltool yo dookoot tinepe nga, ngan titara lodi le imede ye Maro tiap, bong tiyei dawa ben garup dook tiap yo idada nintooroo a la iyei bauk i. Le kanakana nga, ngan lodi bet ayeie mos ke Maro sa a tikamata. Bong mos sa bet ayeii a tikamata tiap. Ole tikamata mos ataleu yo pombe ye Maro koonoo yo Yona, in leu.” Yesu iwete pang di nen, inbe igege di sila tinepe, be ikoo a ila. ");
INSERT INTO apr_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Ye kene tani in Yesu iye di galiunu tikooi ye ookoo a tisaut pang ran koonoo kapala, ngan di galiunu lodi kalli le tikap toko kadi porong siap. ");
INSERT INTO apr_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Motong la Yesu iwete pang di nen, “Ken kakap tutang, inbe kakauwai yang dook leu ye yis kidi Paresi le di Sedusi.” ");
INSERT INTO apr_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Ye kene yo di galiunu tilongo Yesu iwetewete ye so maitiap tani yo ilo ye porong ngan iyeii a isung le imot in nga, ngan di tapdi tiwetewete pang di nen. Tiyei ne, “Iwete nen nga, yesoo ye yo idi nga takap toko porong siap nga.” ");
INSERT INTO apr_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Bong Yesu lon galanga ye yo di tapdi tiwetewete nen, ngan oo, le nga iwete pang di. Iyei ne, “Barau, ang nga katara lomu medana pau mai tiap sa. Nga gelei bet ang tapmu kawetewete kataunu yang ye yo kakap toko porong siap nga? ");
INSERT INTO apr_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Gelei, ang nga o lomu galanga tiao, too? Nga o lomu kalli porong dukumu limi yo di tooltool 5,000 tikan ngan pa oo? Porong tina ngan naunu naunu yo kawinnoko a kapadid lo karei lono nga, ngan le ikan karei ponene pi? ");
INSERT INTO apr_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Inbe nga o lomu kalli porong dukumu limi be ru yo di tooltool 4,000 tikan ngan pa oo. Porong tina ngan naunu naunu yo kawinnoko a kapadid lo karei lono nga, ngan le ikan karei ponene pi? ");
INSERT INTO apr_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Nga gelei bet lomu galanga ye betanga yo aweta pang mugu, in lono ki tiap nga? Au i awete pang ye porong moolmool tiap. Bong awete pang bet ken kakauwai yang dook leu ye so kidi Paresi le di Sedusi yo bet iyei ang le ben so yo tatar lo ye porong, ngan ole iyeie porong a isung le imot i.” ");
INSERT INTO apr_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Yesu iwete pang di nen, motong la se lodi galanga nen, nga iwete pang di bet tikauwai ye di dook leu ye so yo titar lo ye porong ngan ole iyeie porong a isung le imot, in tiap. Bong iwete pang di bet nen ngan tikauwai ye di dook leu ye patomonaingi kidi Paresi le di Sedusi ole nen ngan igarung di. ");
INSERT INTO apr_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Yesu ipa a ila pombe pang ye tana mai yo potai pang ye malala yo ene Sisaria Pilipai i, motong la itor di galiunu nen, “Ai, di tooltool tiwete bet Tool Moolmool ke Maro in sei?” ");
INSERT INTO apr_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Ngan di galiunu tiraua torungu ki nen, “Di tooltool kapala tiwete bet ye in Yowan yo irriu di tooltool i, inbe di kapala ngan tiwete bet ye in Ilia. Inbe di tooltool kapala ngan tiwete bet ye in Yedimia, too ye in o Maro koonoo atu.” ");
INSERT INTO apr_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Motong la itor di mulu nen, “Ngan ang tapmu nga, kawete bet au i sei?” ");
INSERT INTO apr_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Ngan Simon Pita iraua betanga ki nen, “Ong i Kirisi, tool tani yo Maro ipootoo bet si ipamulu di tooltool ki ye so dook tiap yo bet igarung di i. Ong i Maro yo inepe nen le taukan matenge i, in natunu moolmool.” ");
INSERT INTO apr_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Motong la iwete pang Pita nen, “Simon, Yona natunu, Maro iyeie urata dook mata pong, yesoo tool sa la ipaposo betanga i pong, ngan tiap. Bong Tamak yo inepe ye malala ki ete ni, in ye taunu la ipaposau pong i. ");
INSERT INTO apr_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Le awete pong nen, ong i em yo Pita i, in lono ki ben pat. Inbe ole agaua di tooltool le imot yo tigaua ye bareme kiau nga, ngan man apatokodo di lo tikodo pat tani, in pono. Ngan nen le o ke bet gurana ke matenge in iraukede di a timol, ngan tiap. ");
INSERT INTO apr_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Inbe au i ole akaua gurana mai pong bet matam kala di tooltool yo Maro ipootoo di panga bet matan kala di nga. Le soo so bet kugunkala ke tana i nga, ngan ole Maro igunkala ye malala ki nen lapau. Inbe soo so bet kumalum ye ke tana i nga, ngan ole Maro imalum ye ke malala ki nen lapau.” ");
INSERT INTO apr_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Motong la Yesu iwete betanga medana pang di galiunu nen, bet ken tiwete pang tool atu sa ye yo ye in Kirisi tani i, nga be. ");
INSERT INTO apr_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Ye kene tani in Yesu imadit ye betanga pang di galiunu a ipagalanga lodi ye matenge ki. Ngan nen le iwete pang di nen, bet ole ilo pang Yerusalem, a bet nen ngan di tooltool maimai kidi Yuda, tiye di tooltool maimai ke paroranga so pang Maro, inbe di pannoongoo ke wer ke Maro, ngan tikap urata moonoo alunu ke masngana panga a isolo, inbe tiraumate le imata. Ngan ole iken ye ke ru, lo ngan bet ye tol ki ngan ole imadit mulu ye ni ke matenge. ");
INSERT INTO apr_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Ngan Pita ilongo tina yo iwete nen nga, le nga ipasnaka Yesu a yeru leu tila manga mooloo kasin, inbe ipasak panga. Iyei ne, “Tool Mai, o tiap! Au i lok bet so yo nen ngan pombe pang yong tiap!” ");
INSERT INTO apr_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Motong la Yesu iportak pang ye a iwete katkat panga. Iyei ne, “Satan, kukoo yau a kudu ke murik! Nga gelei a lom bet kuyakala dada kiau nga? Betanga yo kuwete nga, ngan kutoo Maro lono tiap, bong kutoo di tooltool ke tana lodi.” ");
INSERT INTO apr_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Motong la Yesu iwete pang di galiunu nen, “Kumata tool atu lono bet itoo au nga, ngan ye taunu irautoo le du inepe lopo, inbe isolo kai palasingi ki a itoo au. ");
INSERT INTO apr_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","E sei tool yo lono mai san ye nepongo ki ke tana i mai mata a iparama i, in ole ilene. Bong sei tool yo lono mai san ye nepongo ki ke tana i tiap, inbe iraia tinini le imot bet iyei urata kiau i, in ole ipusye nepongo dook mata yo taukan motingi i. ");
INSERT INTO apr_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Le kakamata, tool bet iyau balingi matana matana le imot ke tana i panga, lo ngan bet imata a ila nga, ngan ole balingi tina ngan iloni balai? Too, soo so dook mata ke bet tool sa ikauu pang Maro a bet ikaua nepongo dook mata tani yo taukan motingi in panga i? So siap! ");
INSERT INTO apr_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Awete pang nen, yesoo pang dama ni nga, ngan ole Tool Moolmool ke Maro iye di bangabangana ke Maro ole tisi pang tana. Ye kene tani ngan Tamana lulngana ole iken ye, inbe isi a bet si ikap balingi pang di tooltool atu atu ye urata kootoonoo kidi yo tiyei nga. ");
INSERT INTO apr_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Awete pang moolmool nen, di tooltool kapala yo dookoot taye di takododo ni nga, ngan ole timmata tiao, inbe tikamata Tool Moolmool ke Maro isi bet si matan kala di tooltool ki le imot nga.” ");
INSERT INTO apr_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Ye kene tani in, tinepe le ke limi be atu iman a ila, motong la Yesu ikaua Pita inbe Yemis iye taini Yowan a tilo pang kawal yo kutono lo ete yege i, bet lo di leu tinepe nango. ");
INSERT INTO apr_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Tilo tinepe le nga Yesu di galiunu tina bet matadi pang ye, ngan tinini idik le san mulu le damono i milmilbe ben ke matana, inbe sousoungu le mala ki nga ikoko san le ilangaraia ni ben sul lulngana. ");
INSERT INTO apr_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Ngan nen le mooloo tiap, inbe tikamata Mose iye Ilia si pombe a tiye Yesu tiwetewete. ");
INSERT INTO apr_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Motong la Pita iwete pang Yesu nen, “Tool Mai, nga dook mata ke bet idi nga tanepe nanga. Kumata bet ong lom nen lapau nga, ngan ole are badabada tol; atu pong, san pang Mose, inbe san pang Ilia.” ");
INSERT INTO apr_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Pita iwetewete nen pang Yesu go, inbe eng tene ikoko le milmilbe, in isi le si rur ki iloko la podi. Inbe tool atu kalngana pombe eng tene tani lono in iwete nen, “Tool in au natuk. Au i lok panga mai san, inbe lok ponana ye. Le kalongo betanga ki yo bet iwete pang nga!” ");
INSERT INTO apr_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Yeiso bet di galiunu tilongo betanga tina, motong titattadai le tiro du tisilingan matadi pang tana. ");
INSERT INTO apr_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Bong Yesu ipa le iman potai ye di a itoko di, inbe iwete pang di nen, “Kamadit! Ken katattadai be!” ");
INSERT INTO apr_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Le nga di tol timadit a bet matadi gaga, ngan tikamata tool sa mulu siap, bong tikamata Yesu yetaleu la ikododo i. ");
INSERT INTO apr_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Motong la tipa ke kawal a bet tisi, ngan Yesu iwete betanga medana pang di nen, “Ken kawetewete pang tool sa ye so yo kakamata nga, ngan be. Bong iken yang leu le ilo ye lal yo bet Tool Moolmool ke Maro imata a imadit mulu ye i.” ");
INSERT INTO apr_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Iwete pang di galiunu a imot, motong la titoru. Tiyei ne, “Nga gelei a di pannoongoo ke wer ke Maro tiwete bet ole Ilia la bet imugu a isi, lo ngan bet Mesaia itoo nga?” ");
INSERT INTO apr_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Motong la iwete pang di nen, “Betanga in moolmool. Ilia bet imugu a isi nga bet si ikarata so le imot le dook mata mulu. ");
INSERT INTO apr_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Bong awete pang nen, Ilia in isi oo. Bong di tooltool tikilala dook tiap, le dada dook tiap le imot yo lodi bet tiyei panga nga, ngan le tiyei panga moolmool. Ngan dada gaongo leu la bet tiyei pang Tool Moolmool ke Maro a isolo urata moonoo ke masngana ye lapau nga.” ");
INSERT INTO apr_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Yesu iwete nen a imot, motong la di galiunu lodi galanga nen, ye i nga iwetewete ye Yowan yo irriu di tooltool i. ");
INSERT INTO apr_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Ye kene yo Yesu iye di galiunu tol tina ngan tisi ye in nga, ngan le si pombe pang ye di tooltool budanga mai. Motong la tool atu in ipa le iman potai pang ye Yesu, inbe igun turunu du kene punu ke dama. ");
INSERT INTO apr_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","Inbe iyei ne, “Tool Mai, lom pau a kulono natuk tamoto ni ngan. Ye in isolo masngana maiyoko, yesoo matan patadatada a imol du tana, inbe itangurngur. Inbe lal kapala ngan ole imol du ei le ran lono lapau. ");
INSERT INTO apr_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Le akauu pang ye di galium a bet tikarata a tinini dook mata, bong ke bet tikarata a tinini dook mata mulu tiap.” ");
INSERT INTO apr_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Tool tani iwete nen, motong la Yesu iyei ne, “Ona tiap! Ang di tooltool yo dookoot kanepe nga, ngan katara lomu le imede ye Maro tiap, bong lomu kap gogo dada dook tiap alunu san. Nga ole ke pi mulu bet nen ngan ayang tanepe, inbe awete a kayei dada yo nen ngan mulu ye nga? Oo, kakaua kase in a iman yau me e ni.” ");
INSERT INTO apr_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Tikauu man, motong la Yesu ipasak pang so sidi tani a ikoo ye, le pattu leu inbe kase tani in tinini dook mata mulu. ");
INSERT INTO apr_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Motong la Yesu di galiunu di leu tila ye Yesu la titoru. Tiyei ne, “Ai, nga gelei, a le bet amnganga so sidi ni, ngan le ikoo ye tiap nga?” ");
INSERT INTO apr_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","21","Motong la Yesu iraua betanga kidi nen, “Ang nga katara lomu medana pang Maro mai tiap san. Awete pang moolmool nen, kumata bet lo medana kiang yo kataru pang Maro, in mai tiap le dawa ben kai mastet patunu leu nga, ngan ke bet kawete pang kawal ni nen, ‘Kudik ye ni in, a la kukodo meneng e ni’, ngan ole ila. Le so sa yo bet kasak ye bet kayeii tiap, ngan tiap.” ");
INSERT INTO apr_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Kene atu in Yesu iye di galiunu tigaua tana mai Galili, motong la iwete pang di nen, “Ole titara Tool Moolmool ke Maro la di tooltool bedi, ");
INSERT INTO apr_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","a bet nen ngan tiraumate a imata. Ngan ole iken ye ke ru, lo ngan bet ye ke tol ki ngan ole imadit mulu ye ni ke matenge.” Ngan iwete pang di nen a tilongo le lodi madoko ye mai san. ");
INSERT INTO apr_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Yesu iye di galiunu tipa mulu le lo pombe ye malala mai Kapenam, motong la di tooltool yo tiyei urata ye kaungu pat pang bareme mai ke sungunu nga, ngan man titoro Pita. Tiyei ne, “Ai, pannoongoo kiang ni kanakana ngan itar pat ke yimoongoo so pang bareme mai ke sungunu lapau, too tiap?” ");
INSERT INTO apr_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Ngan Pita iyei ne, “E, kanakana nga iyei nen.” Motong la Pita imulu a ila pang ye rumu yo Yesu inepe lono i nga. Ila le nga iwete toko betanga siao, inbe Yesu isangkala ye betanga. Iyei ne, “Simon, lom balai? Di tooltool yo tiyei kuto maimai pang tana maimai le imot nga, kanakana ngan pat yo tikap bet tiyei urata kidi ye nga, ngan tikap ye di tooltool kidi tapdi yo tiye di tinepe nga, too tikap ye di tooltool ke malala san?” ");
INSERT INTO apr_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Ngan Pita iyei ne, “Di tooltool ke malala san.” Motong la Yesu iyei ne, “Ngan nen le di tooltool kidi tapdi yo tiye di tinepe nga, ngan o ke bet titar pat kidi tiap. ");
INSERT INTO apr_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Bong kumata bet idi nga takap pat pang di tooltool yo tiyei urata ye kaungu pat pang bareme mai ke sungunu ngo tiap nga, ngan ole katedi malmal paidi. Le kudu du kotte ooroo kiong ke konnanga in idu ran lono a kukonana. Ngan i yo bet kukona kulkulunu i, in kuwi a kupakaka koonoo, ngan ole kupusye pat atu iken i tani in koonoo lono. Lo ngan bet kouo pat tani, a nen ngan kuwi pang di tooltool tina ye aru kanada.” ");
INSERT INTO apr_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Ye kene tani in Yesu di galiunu timan pang ye man titoru. Tiyei ne, “Ai, am nga ole sei bet ene mai a iyei kuto mai le imugu pang di tooltool yo Maro bet matan kala di i?” ");
INSERT INTO apr_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Motong la Yesu koonoo pang tool kase mai tiap atu a iman pang ye, a lo ipatokode kataunu kidi galiunu tina, ");
INSERT INTO apr_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","inbe iwete pang di nen, “Awete pang moolmool nen, kumata bet kaportak lomu mulu le kayei dawa ben kase mai tiap i, tiap nga, ngan o ke bet kalo kagaua ye di tooltool yo Maro bet matan kala di nga, ngan tiap. ");
INSERT INTO apr_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Ngan nanga, sei tool bet ye taunu irautoo le du inepe lopo le dawa ben kase mai tiap i nga, ngan tool tani in ye la bet ene mai ye di tooltool yo Maro bet matan kala di nga. ");
INSERT INTO apr_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","“Inbe kumata bet sei tool itara lono medana pau le bet ilono tool kase mai tiap atu nen nga, ngan tool in ilonau lapau. ");
INSERT INTO apr_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Bong sei tool yo bet iyei di kakase maimai tiap yo titara lodi medana pau koot nga, ngan atu, le bet ikapsap ye sennene nga, ngan ye in ole isolo urata moonoo dook tiap. Le moolmool, kumata bet tituku pat somai yo ke raunganingi dingding patunu ngan atu lo gurini, inbe tikatte du tiek lono ye ni yo lama ni a bet nen ngan idaup a imata nga, ngan ben dook kasin, yesoo bong urata moonoo dook tiap yo bet isola ye dada dook tiap ki tani yo iyeii i, in ole dook tiap le dook tiap ki taunu. ");
INSERT INTO apr_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","“Atoo, ang tooltool ke tana mai i le imot yo kayei di tooltool kapala a tikapsap ye sennene nga, ngan ken kakamatang dook leu! Moolmool, so yo nen nga, ole pombe pang ye di tooltool, bong atoo, ang sima tooltool yo kayei so nen a pombe nga, ken kakamatang dook leu! ");
INSERT INTO apr_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Le kumata bet bem too kem atu iyolong la kuyei sennene nga, ngan kusaputu a kotte. Dook mata ke bet bem too kem ataleu, ngan la bet kulo kunepe ye nepongo dook mata yo taukan motingi in nga. Bong kumata bet bem ru inbe kem ru iken nga, ngan ole tiyolong la kuyei sennene, a nen ngan tikatte ong lo ei yo ikan nen le taukan motingi i, in lono. ");
INSERT INTO apr_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Inbe kumata le matam atu bet iyolong la kuyei sennene nga, ngan kupaii a kotte. Dook mata ke bet matam ataleu, ngan la bet kunepe ye nepongo dook mata yo taukan motingi in nga. Bong kumata bet matam le ru iken nga, ngan ole tiyolong la kuyei sennene, a nen ngan tikatte ong a kudu ye malala ke masngana ye ei yo ikan nen le taukan motingi i.” ");
INSERT INTO apr_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","11","Motong la Yesu iwete mulu nen, “Ken matamu ru di kakase maimai tiap yo nen nga, ngan atu, ben ye in tool sorok, nga be. Awete pang nen, yesoo di bangabangana ke Maro yo matadi kala di nga, ngan kanakana nga tikodo dama ke Tamak a tiye tinepe ye malala ki yo ete ni. ");
INSERT INTO apr_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Atorang, ang nga lomu balai? Kumata bet tool atu in asara ki yo edi sipsip nga, ngan 100, bong bet atu ilene nga, ngan ole tool tani in iyei balai? Ole igege di yo 99 ngan sila tinepe kawal madini, inbe la isere yo ilene i. ");
INSERT INTO apr_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Awete pang moolmool nen, kumata bet ila ipa a isere sipsip ki tani yo ilene in le bet ipusye nga, ngan ole lon ponana le lon ponana ye kaiye, le illoso lo ponana ki yo pang di sipsip ki tina yo tilledi tiap nga. ");
INSERT INTO apr_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Ngan gaongo leu, Tamamu yo inepe ye malala ki ete ni, in lono bet kase maitiap yo nen ngan atu sa ilene be.” ");
INSERT INTO apr_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Motong la Yesu iwete pang di galiunu mulu nen, “Kumata bet em atu yo itara lono medana pang Maro i, in bet iyeie urata dook tiap atu pong nga, ngan kula ye a la angru leu kanepe, inbe kuwetewete panga a nen ngan kupagalanga lono ye urata dook tiap ki yo iyeii pong i. Kumata bet kuwete panga le bet ilongo betanga kiong nga, ngan dook mata ole angru kagaua lomu mulu. ");
INSERT INTO apr_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Bong kumata bet kuwete panga le ilongo betanga kiong tiap nga, ngan kula kouo tool atu too ru mulu a timan yong, inbe kuye di kala pang ye, a bet nen ngan la tisu ong ye betanga yo bet angru kawetewete ye nga, dawa ben tina yo Rau ke Maro iwete nga. ");
INSERT INTO apr_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Ngan kumata le lono bet ilongo betanga kiang tiap nga, ngan kawete pang di tooltool yo tigaua ye bareme ke Yesu nga, ngan a man tilonong bet kaye tool tani kakarata betanga. Bong kumata le lono bet ilongo betanga kidi tooltool tina, ngan tiap lapau nga, ngan ole kakamata ben ye in tool gok yo lon galanga ye Maro tiap i, too ye in ben tool ke sodaningi pat. ");
INSERT INTO apr_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Awete pang moolmool nen, soo so bet kugunkala ke tana i nga, ngan ole Maro igunkala ye malala ki. Inbe soo so bet kumalum ye ke tana i nga, ngan ole Maro imalum ye ke malala ki nen lapau. ");
INSERT INTO apr_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Nga bet awete pang mulu nen. Kumata bet ang tooltool ru kagaua lomu le atu, inbe katoro Tamak yo inepe ye malala ki ete ni ye so sa nga, ngan ole iyeie so tani, in pang. ");
INSERT INTO apr_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Ngan nanga, ye soo ni bet di tooltool ru too tol timan tigaua ye inbe tipootoo ek nga, ngan au i ole anepe ye di.” ");
INSERT INTO apr_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Motong la Pita iman pang ye Yesu man itoru nen, “Tool Mai, nga bet atorong. Ole agiri sennene ke ek yo bet iyei pau nga, le papi? Ole agiri sennene tina ngan le lo limi be ru, too?” ");
INSERT INTO apr_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Motong la Yesu iwete panga nen, “Awete pong nen, kugiri sennene ki le lo limi be ru tiap, bong kugiri sennene ki le lo 77. ");
INSERT INTO apr_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“Ngan nen le dada yo Maro bet matan kala di tooltool ki ye i, in dawa ben tool yo iyei tool kuto mai pang tana mai atu le imot i. Ngan tool mai tani in lono bet iye di kapraingi ki tikarata betanga ye bun kootoonoo ki. ");
INSERT INTO apr_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Ye kene yo imadit ye karatanga betanga ye in nga, ngan iwete le tikaua tool atu yo ikap pat gol ben 10,000 a iyei bun panga i, in a iman pang ye. ");
INSERT INTO apr_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Bong taukan pat yo bet iraua bun ki tani ye nga. Motong la tool kuto mai tani in iwete betanga medana pang di tooltool ki bet ole tikauu a tiyawari le ipa ye rimana le di natunu inbe so ki nga le imot, a bet di tooltool tiyimi di, ngan tikap pat tina a tiraua bun ki ye. ");
INSERT INTO apr_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","“Bong kapraingi ki tani in ilongo betanga ki nen, le nga igun turunu du dama ke tool mai tani, inbe iwete a imangmang ye nen, ‘Alei, ken katem malmal pau be! Ole arau bun kiau le imot yo akap yong nga, ngan pong mulu.’ ");
INSERT INTO apr_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Ngan nen le tool kuto mai ke kapraingi tani in lono panga, le iwete panga bet bun ki ngan irau be. Dookoot, sila ikino. Inbe imalum panga a ila. ");
INSERT INTO apr_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Bong ye kene yo kapraingi tani in ila ye in nga, ngan ikamata ene kapraingi atu yo ikap pat yo ene silba i, in 100 a iyei bun panga i. Le nga la iparama ene tani a ikisi gurini, inbe iwete le kon mede panga nen, ‘Oo, palbe be awete ngan kurau tarrai bun kiong yo kop yau nga.’ ");
INSERT INTO apr_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","“Bong kapraingi tani in ilongo betanga ke ene tani, le nga igun turunu du dama ki, inbe iwete a imangmang ye nen, ‘Alei, ken katem malmal pau be! Ole arau bun kiau le imot yo akap yong nga, ngan pong mulu.’ ");
INSERT INTO apr_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","“Bong lono pang longono betanga ke ene tani, in tiap. Ngan nen le nga iwete bet titaru lo rumu dook tiap kidi talnga dikidiki lono a bet lo inepe nango, inbe irau bun ki le le imot. ");
INSERT INTO apr_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Ngan di kapraingi kapala tikamata dada tani yo pombe pang ye edi i, le lodi madoko mai san. Motong la tila la tiwete pang tool kuto mai kidi ye soo dada yo pombe a tikamata i. ");
INSERT INTO apr_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","“Motong la tool kuto mai tani, in ikiui kapraingi ki tani man iwete panga nen, ‘Ai, ong i tool dook tiap sa! Mugu ngan kumangmang a kutang pau, le awete bet bun kiong ngan kurau be. Dookoot, sila ikino. ");
INSERT INTO apr_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Au i alele lok yong, e nga gelei a kutoo dada gaongo leu nen a kulele lom ye em kapraingi san ni tiap nga?’ ");
INSERT INTO apr_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Ngan tina iyei nen nga, le tool kuto mai in katen malmal panga mai san le iwete bet titaru lo rumu dook tiap kidi talnga dikidiki lono a bet isolo urata masngana nango, inbe irau bun ki le le imot.” ");
INSERT INTO apr_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Yesu iwete betanga tina a imot, motong la iwete pang di galiunu nen, “Nga bet awete pang nen, kumata bet kalele lomu ye di diemu a kagiri sennene kidi yo tiyei pang, ngan tiap nga, ngan i dada ataleu tani yo bet Tamak yo inepe ye malala ki ete ni, in iyeii pang ang atu atu le imot, in naii.” ");
INSERT INTO apr_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Ye kene tani in Yesu iwete betanga tina a imot, motong la igege tana mai Galili, inbe ila pang tana mai ke Yudia yo iken ke ran Yodan koonoo kapala i. ");
INSERT INTO apr_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Ngan di tooltool malala mai la titoo lapau nga, motong la ikarata di tooltool yo matamatenge ikap di nga, ngan le tinidi dook mata mulu. ");
INSERT INTO apr_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Motong la di Paresi pattu timan pang ye bet man titoua. Le nga titoru nen, “Ai, bet tamoto atu isukraia rimana sorok nga, ngan idada wer yo kiidi in pono, too tiap?” ");
INSERT INTO apr_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Ngan Yesu iraua betanga kidi nen, “Ang nga o kakinkata betanga ke Maro yo iken ye rau ki, in tiap, too? Ngan betanga tani in nen, mukot yege ye kene yo Maro itar so le imot a pompombe ye in nga, ngan ‘ikarata di tooltool le tamoto be garup.’ ");
INSERT INTO apr_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Inbe betanga ke Maro yo iken ye rau ki in iwete mulu nen, ‘Ye punu yo nen in la le tamoto bet ikere nga, ngan ole igege tamana le tinana, inbe la iye rimana tinepe gaongo, a bet nen ngan yeru tigaua le tinidi ataleu.’ ");
INSERT INTO apr_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Ngan nen le yeru ke bet tinepe ben di tooltool ru mulu tiap, bong tigaua tinidi le tiyei ben tool ataleu. Ngan nanga, soo so yo bet Maro ye taunu ipakere a igaua le atu koot nga, ngan ken tool sa ipoto le iken ki ki mulu be.” ");
INSERT INTO apr_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Motong la titoro Yesu nen, “Bong nga gelei, a wer ke Mose iwete bet kumata le tool sa lono bet isukraia rimana nga, ngan iwodo betanga ke parsukraingi ilo ye rau a ikauu panga, inbe inganga a ila nga?” ");
INSERT INTO apr_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Motong la Yesu iwete pang di nen, “Mose imalum pang bet kasukrai di rimamu, yesoo ang nga kutomu mede san dawa ben pat. Bong mukot yege nga, ngan dada yo nen, ngan siap. ");
INSERT INTO apr_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Awete pang nen, sei tool yo rimana iyei bauk tiap, inbe isukraii sorok a la iyooloo garup san mulu i, in iyei dada dook tiap ke bauk.” ");
INSERT INTO apr_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Motong la di galiunu tiwete panga. Tiyei ne, “Kumata le bet dada yo nen ngan bet iken kataunu ke tamoto ye rimana nga, ngan dook mata bet tamoto in ikere be.” ");
INSERT INTO apr_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Ngan Yesu iwete pang di nen, “Di tooltool le imot la bet tikaua betanga i nga tiap, bong di tooltool kapala leu la bet Maro ipamede di le tikaua betanga kiau i nga. ");
INSERT INTO apr_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Di tamoto matana matana la tikere tiap a tinepe nga. Yesoo, di tamoto kapala ngan tinadi tipasui di ngan tinidi dook tiap le ke bet tikere tiap. Inbe di tamoto kapala, ngan di tooltool tigarung tinidi a imata le ke bet tikere ngan o titar di kakase tiap. Inbe di tamoto kapala ngan lodi pang kerenge tiap, yesoo lodi bet tinepe nen a tiwetewete pang di tooltool ye dada yo Maro bet matan kala di tooltool ki ye i. Le sei tool bet ikaua betanga kiau i, in ikauu a itoo.” ");
INSERT INTO apr_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Motong la ye kene tani in di tooltool tikap di kakase a tila pang ye Yesu, a bet nen ngan la ipaloko bene lo podi, inbe ipatarau ye di. Bong Yesu di galiunu tikamata di yo tiyei nen nga, le tipasak pang di a tisoror di. ");
INSERT INTO apr_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Bong ngan Yesu iwete pang di nen, “Ai, ken kasoror di kakase ngan be! Bong kamalum pang di a timan pang yau. Yesoo, di tooltool yo bet lo tigaua ye di tooltool yo Maro bet matan kala di nga, ngan dawa ben di kakase tina nga.” ");
INSERT INTO apr_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Motong la Yesu ipaloko bene lo di kakase tina ngan podi, inbe ipamede di ye betanga dook mata le imot, motong la igege ni tani in a ipa mulu nga. ");
INSERT INTO apr_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Ye kene tani in tool atu iman tina ngan le man iwete pang Yesu. Iyei ne, “Pannoongoo, nga bet atorong. Soo dada dook mata bet ayeii, ngan ole akaua nepongo dook mata yo taukan motingi in nga?” ");
INSERT INTO apr_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Ngan Yesu iwete panga nen, “Nga gelei a kutorau ye soo so yo dook mata in nga? Tool ataleu in la tool dook mata i. Le lom bet kouo nepongo dook mata yo taukan motingi in nga, ngan ole kutoo wer ke Maro ngan dook le imot.” ");
INSERT INTO apr_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Bong tool tani in itoro Yesu mulu nen, “Soo wer ke Maro kuwete ye i?” Ngan Yesu iyei ne, “Wer ke Maro yo awete ye ngan nen: ‘Ken kuraumata di tooltool be; inbe ken kuyei bauk be; inbe ken kupinau be; inbe ken kusopo koom ye betanga doko be; ");
INSERT INTO apr_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","inbe kuraua pang tamam le tinam a kulongo betanga kidi.’ Inbe san in nen, ‘Lom pang di diem mai san dawa ben yo ong taum lom pong mai san nga.’ ” ");
INSERT INTO apr_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Ngan tool kase paunu tani iyei ne, “Wer yo kuwete nga, ngan atoo le imot. Bong soo so ayeii tiao i?” ");
INSERT INTO apr_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Motong la Yesu iwete panga nen, “Kumata le lom bet kunepe dook mata le taukam busunu ye Maro matana nga, ngan kumulu la kuyawar so kiong ngo le imot a kop pat ye, lo ngan bet kop pat kiong tina pang di tooltool yo ballingadi tiap nga. Kumata le bet kuyei nen nga, ngan la bet pang dama ni ngan Maro ole ikap so dook mata yo iken ye malala ki ngo pong nga. Ngan kuyei nen a imot, lo ngan bet kuman man kutoo au.” ");
INSERT INTO apr_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Bong tool kase paunu tani in ilongo betanga nen nga, le lon madoko ye a ikoo a ila, yesoo ye in ballingana le so ki alunu san. ");
INSERT INTO apr_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Motong la Yesu iwete pang di galiunu tina nen, “Awete pang moolmool nen, tool yo ballingana nen i, in ole urata imoo panga mai san bet ilo igaua ye di tooltool yo Maro bet matan kala di nga. ");
INSERT INTO apr_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Nga bet awete pang mulu nen. Kumata bet asara mai ke solanga burum yo ene kamel i, in ikapge bet idewe ye sar gimono maitiap in nga, ngan ole gelei, urata imoo panga, too? E, moolmool! Ngan ole gaongo leu, kumata le tool yo ballingana in lono bet ilo igaua ye di tooltool yo Maro bet matan kala di nga, ngan ole urata imoo panga nen lapau.” ");
INSERT INTO apr_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Yesu di galiunu tina tilongo betanga yo iweta i, ngan le titakrai belebele ye. Le nga titoru nen, “Ona tiap! Bet nen nga, ngan ole sei tool bet Maro ipamule ye so dook tiap yo bet igarungu i?” ");
INSERT INTO apr_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Motong la Yesu matan kenen ye di, inbe iyei ne, “Tool sa ikapge bet iyei so nen nga, ngan ole imoo panga le isak ye, bong so le imot ngan imarra pang Maro le ke bet isak ye tiap.” ");
INSERT INTO apr_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Motong la Pita iyei ne, “Am nga amgege so kiam le imot, inbe la amman bet man amtoo ong nga. Le nga soo so bet ole amkauu a ilonam i?” ");
INSERT INTO apr_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Ngan Yesu iwete pang di nen, “Awete pang moolmool nen. Pang dama ni ye kene yo bet Maro itar lang le tana paunu a bet pombe ye in nga, ngan ole Tool Moolmool ke Maro lo iwur ye kakawa dook mata ki ke burungu, inbe ipaposo gurana ki yo mai i. Ngan ye kene tani in ang tooltool yo katoo au nga, ngan ole kawur ye kakawa ke burungu yo sangaul be ru nga lapau, inbe kayei tooltool maimai pang di rara ke di Isrel yo sangaul be ru nga. ");
INSERT INTO apr_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Inbe sei tool yo igege rumu ki, too di toonoo le taini le lini, too tamana le tinana, too di natunu, too kumu ki, inbe man itoo au i, in Maro ole ikap so yo nen ngan alunu le alunu san panga le kinkatingi ki ben 100 le illos so ki yo igege koot nga. Inbe ole ikaua nepongo dook mata yo taukan motingi i, in lapau. ");
INSERT INTO apr_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Bong di tooltool alunu yo timugu nga, ngan pang dama ni ngan ole du tikimur. Inbe di tooltool alunu yo tikimur nga, ngan pang dama ni ngan ole lo timugu.” ");
INSERT INTO apr_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Yesu ikatte betanga atu mulu pang di nen, “Dada yo Maro bet matan kala di tooltool ki ye i, in dawa ben kumu taunu atu yo imadit muntu yege a ila bet la ikap di tooltool panga bet man tikaua urata ye kumu ki ke ooroo yo ene wain i. ");
INSERT INTO apr_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Ila ikap di tooltool tina pattu, motong la iye di tikarata betanga bet ole iyimi di ye pat yo ene silba in atu ye ke atu. Motong la iwanga di bet tidi tikaua urata ye kumu ki tani yo ke wain i. ");
INSERT INTO apr_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","“Kumu taunu tani inepe le ke ise pang ete kasin ye so ben ke matana limi be pai, motong la ila pang ye ni ke yawaringi kaningi le so, ngan ikamata di tooltool kapala yo taukadi urata a tikododo sorok nga. ");
INSERT INTO apr_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Le nga iwete pang di nen, ‘Ai, ang lapau kaman a kadi kakaua urata ye kumu kiau ke wain ni ngan. Lo ngan bet ole ayimang le lo ige urata kootoonoo kiang.’ ");
INSERT INTO apr_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Ngan iwete pang di nen, le tilongo betanga ki a tidi. “Motong la inepe kasin le ke se isolokati ye so ben ke matana sangaul be ru, ngan ila ipa a iyei nen mulu. Inbe pang rrai ye so ben ke matana tol, ngan ila iyei dada gaongo leu nen. ");
INSERT INTO apr_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Ngan inepe le ke idu pang lopo mulu ye so ben ke matana limi, motong la ipa mulu a ila, ngan ikamata di tooltool kapala mulu tikododo sorok a tinepe. Le nga iwete pang di nen, ‘Ai, nga gelei a kayei toko urata siap inbe kakodo sorok ni ye ke mooloo i a du rrai nga?’ ");
INSERT INTO apr_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","“Ngan tiyei ne, ‘Am nga amkododo sorok nen, yesoo tool sa ikap urata pam bet amyei tiap.’ “Motong iwete pang di nen, ‘Dook mata! Bet nen ngan ang lapau kadi kakaua urata ye kumu kiau ke ooroo wain ni.’ ");
INSERT INTO apr_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Ngan di tooltool tina tikaua urata a nga du rrai bet ni burrum, motong la kumu taunu iwete pang tool ki yo matan kala di tooltool ki ke urata i. Iyei ne, ‘Kukiu di tooltool ke urata ngo a timan man kuyimi di. Bong bet kuyimi di nga, ngan kumadit ye di tooltool yo akap di mur nga, le lo imot ye di tooltool yo akap di mugu nga.’ ");
INSERT INTO apr_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","“Motong la tool tani ikiu di tooltool yo tila tikaua urata mur ye ke matana limi nga, ngan a man iyimi di ye pat silba atu atu le le imot. ");
INSERT INTO apr_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Ngan nen le di tooltool tina yo timugu muntu ye urata nga, ngan kene yo bet man tikap pat ye in nga, ngan lodi tar nen, bet di ngan ole tikap belebele pat. Bong tiap, di le imot tikap pat silba atu atu le imot lapau. ");
INSERT INTO apr_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Di tooltool tina ngan tikap pat a tikamata, ngan le tiwete gogo betanga pang kumu taunu. Tiyei ne, ");
INSERT INTO apr_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‘Ai, di tooltool yo kop di mur a long tikaua urata nga, ngan tiyei urata ye ke matana ataleu. Bong am nga amkaua urata mai san, inbe ke isinam tina muntu ngan le le du rrai. E nga gelei bet kuyimi urata kootoonoo kidi ye pat gaongo ben kiam nga?’ ");
INSERT INTO apr_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“Motong la kumu taunu iraua betanga tani pang di tooltool tina ngan atu nen. Iyei ne, ‘Tool kiau, au i ayeie dada sa yo dook tiap pong, ngan tiap. Au i awete pang bet kakaua urata ye ke atu nga, ngan ole ayimang ye pat silba atu atu, ngan ong i o lom ponana ye betanga kiau i tiap, too? Tiap! ");
INSERT INTO apr_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Kakap pat kiang a kala. Au i lok bet akap pat pang di tooltool yo tipa mur nga, le lo gaongo ben yo akap pang nga. ");
INSERT INTO apr_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","So yo nga so kiau. Too gelei, au i o ke bet atoo lok a agiri pat kiau au tauk ye soo so yo lok bet ayeii, in tiap, too? Too gelei, ang nga lomu dook tiap pau ye yo ayei dada dook mata pang di tooltool kapala nga, too?’” ");
INSERT INTO apr_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Yesu ikatte betanga nen a imot, motong la iwete pang di tooltool tina nen, “Kakamata koot? Tool yo ikimur i, in ole lo imugu, inbe yo imugu i, in ole du ikimur.” ");
INSERT INTO apr_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Yesu ipa bet ilo pang Yerusalem, motong la ikap di galiunu tina yo sangaul be ru nga, ngan a iye di leu tinepe, inbe iwete pang di nen, ");
INSERT INTO apr_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Ai, idi nga dookoot bet tapa a talo pombe Yerusalem nga, ngan ole tikaua Tool Moolmool ke Maro a titaru la di tooltool maimai ke paroranga so pang Maro le di pannoongoo ke wer ke Maro, ngan bedi. Ngan di tooltool tina ole tikarata betanga bet tiraumate le imata. ");
INSERT INTO apr_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Le nga ole tisuketi la di tooltool yo tipa ye rara kidi Yuda tiap nga, ngan bedi, a bet nen ngan tipalele sere ye, inbe tiwalisi ye koro, lo ngan bet tipatota lo kai palasingi kaini a imata. Bong ole iken ye ke ru, lo ngan bet ye ke tol ki ngan ole imadit mulu ye ni ke matenge.” ");
INSERT INTO apr_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Motong la Sebedi rimana in ikap di natunu ru yo Yemis iye Yowan nga, ngan a tila pang ye Yesu. Motong la igun turunu du dama ke Yesu, inbe itoru bet iyeie so sa panga. ");
INSERT INTO apr_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Motong la Yesu itoru nen, “Soo so lom bet ayeii pong i?” Ngan garup tani iyei ne, “Lok bet ye kene yo kuyei kuto mai a matam kala di tooltool ye in nga, ngan kop di natuk tamoto ru nga le atu iwur ke bem oonoo, inbe san iwur ke bem ngas.” ");
INSERT INTO apr_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Motong la Yesu iraua betanga ki panga iye di natunu nen, “Ang nga, so yo kator ye i, in lomu galanga ye moonoo ki tiap. Angru kakanamai ang ngan balai, o ke bet kayin ye ruku ke masngana yo bet ayin ye i, too?” Ngan yeru tiyei ne, “E, amkanamai am ngan o ke bet amyei nen.” ");
INSERT INTO apr_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Motong la Yesu iwete pang di yeru nen, “Dook mata, angru nga ole kayin ye ruku kiau. Bong o ke bet apootang le atu iwur ke bek oonoo, inbe san iwur ke bek ngas, ngan tiap. Yesoo, Tamak in la bet ipootoo di tooltool a lo tiwur ye ni tani yo ikarata pang di i.” ");
INSERT INTO apr_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Ngan di galiunu kapala yo sangaul nga, ngan tilongo betanga kidi yeru yo titoro Yesu ye i, le katedi malmal pang di. ");
INSERT INTO apr_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Le nga Yesu ikiu di le imot a timan man iwete pang di nen, “Ang nga lomu galanga nen, di tooltool kuto maimai ke di tooltool yo tipa ye rara kidi Yuda tiap nga, ngan tikodo le timede ye gurana kidi, inbe tidada di tooltool kidi podi. Inbe di kuto maimai kidi kapala yo edi ilo ete nga, ngan tirautoo di tooltool kidi le bet tinepe la gurana kidi parmana, inbe titoo betanga yo kidi nga. ");
INSERT INTO apr_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Bong dada yo nen nga, ngan au i lok bet iken yang be. Le kumata ang tina ngan atu lono bet iyei kuto mai pang nga, ngan ole ye taunu irautoo le iyei ben kapraingi kiang. ");
INSERT INTO apr_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Inbe sei tool lono bet imugu pang nga, ngan ole ye taunu irautoo le iyei ben poranga kiang. ");
INSERT INTO apr_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Ngan gaongo leu, Tool Moolmool ke Maro isi tana bet si di tooltool tiyei urata panga a bet tiloni ye, ngan tiap. Bong isi bet si ilon di tooltool, inbe iraia tinini bet imata, a bet nen ngan Maro iyemenai di tooltool ye sennene kidi yo tiyei, ngan be.” ");
INSERT INTO apr_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Ye kene yo Yesu iye di galiunu tigege malala Yeriko a tipa ye in nga, ngan di tooltool budanga mai la titoo di a tiye di tila lapau nga. ");
INSERT INTO apr_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Tila, ngan di tooltool mata kis ru tiwurur dada gigini. Ngan yeru tilongo betanga bet ole Yesu ipa nen a iman, le nga koodi le mai nen, “Tool Mai, ong in Dawiti natunu. Lom pam a kulonam!” ");
INSERT INTO apr_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Ngan di tooltool budanga mai tina tipasak pang di, inbe tilele di bet koodi dookoot. Bong tiap, yeru koodi mulu le somai nen, “Tool Mai, ong in Dawiti natunu. Lom pam a kulonam!” ");
INSERT INTO apr_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Motong la Yesu ikodo, inbe itor di yeru. Iyei ne, “Angru, soo so lomu bet ayeii pang i?” ");
INSERT INTO apr_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Ngan yeru tiyei ne, “Tool Mai, am nga lomam bet matamam rere a amkamata ni.” ");
INSERT INTO apr_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Yeru tiwete nen, le nga Yesu lono pang di mai san. Motong la itar bene lo yeru matadi, ngan le pattu leu be yeru matadi rere a tikamata ni. Ngan nen le timadit a titoo Yesu a tiye tila. ");
INSERT INTO apr_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Yesu iye di galiunu tipa a tilo potai pang malala mai Yerusalem, ngan le tilo pombe ye malala san yo ene Betpage i. Ngan Betpage tani in iken ye kawal Olip in madini. Tilo pombe, motong la Yesu iwanga di galiunu ru, inbe iwete pang di nen, ");
INSERT INTO apr_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","“Nga ole angru kamugu a kalo pang ye malala yo iken pang dama ni. E kalo nga, ngan ole pattu leu be kakamata asara pakara atu yo ene donki i, in tiwatu iye natunu a tikododo. Le bet kakamata di nga, ngan karuku ooroo ye di a kadede di yeru a kasi pang yau. ");
INSERT INTO apr_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","E kumata bet tool sa itorang ye di nga, ngan kawete panga nen. Kayei ne, ‘Tool Mai lono bet iyei urata ki ye di ngan, lo ngan bet ole palbe leu be ipamulu di pang yong a tise.’” ");
INSERT INTO apr_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Iyei nen le ole iyeie betanga ke Maro koonoo yo iwodo nga le kanono pombe moolmool. ");
INSERT INTO apr_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Ngan betanga tina yo Maro koonoo iwodo ngan nen, “Kawete pang di tooltool ke Saion nen, ‘Kakamata, tool kuto mai kiang yo bet matan kala tana mai kiang le imot i, in ye la bet ise pang yang i. Ye in tool ke lo silene pang di tooltool nga le imot, inbe iwur donki pono. Ye la iwur donki kase paunu pono a ise pang yang i.’” ");
INSERT INTO apr_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Motong la di galiunu ru tina tilo, ngan le lo tiyei ben tina yo Yesu iwete pang di nga. ");
INSERT INTO apr_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Tilo tikaua donki tani le ipa ye natunu a tisi pang ye Yesu. Motong la yeru tidut sousoungu matolene kidi a tiyoo lo donki tina ngan podi, inbe Yesu irookoo lo iwur ye sousoungu tina ngan pono. ");
INSERT INTO apr_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Motong la di tooltool tina budanga mai ngan kapala tidut sousoungu matolene kidi ngan lapau, a tiyoo du dada katene, inbe di kapala ngan tisaput kai bene bene a tiyoo du dada katene lapau. ");
INSERT INTO apr_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Inbe di tooltool tina ngan kapala yo timugu bet Yesu itoo di, inbe di kapala yo tikimur nga, ngan di le imot koodi le mai. Tiyei ne, “Tayitmaka Dawiti natunu in ene! Maro ole iyei urata dook mata pang ye tool yo isi ye Tool Mai ene i! Tayitmaka Maro ene le ilo ete!” ");
INSERT INTO apr_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Ngan tiyei nen le lo Yesu pombe Yerusalem, ngan le di tooltool budanga mai yo tinepe ye malala mai tani nga, ngan di le imot titakrai ye, le nga di tapdi tipartortor nen, “Ai, i sei tool pombe i?” ");
INSERT INTO apr_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Motong la di tooltool tina yo tiye Yesu tipa nga, ngan tiyei ne, “I Yesu! I Maro koonoo yo ipa ke malala Nasaret ke tana mai Galili i, in naii.” ");
INSERT INTO apr_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Motong la Yesu ilo pang koongoo lono ke bareme mai ke sungunu, a lo inganga di tooltool yo tiyawar so le tiyimimi so koongoo lono ke rumu tani in nga. Inbe ipatudtud kakawa ke palokanga so kidi tooltool yo tiraukol pat nga, inbe kakawa ke burungu kidi tooltool yo tiyawar man utu pang paroranga, ngan lapau. ");
INSERT INTO apr_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Motong la iwete pang di nen, “Betanga ke Maro yo tiwode lo ye rau ki in iwete nen. ‘Rumu kiau i, ole tiweta ye rumu ke pataraungu.’ Bong ang nga kayeii le iyei ben ‘ni kidi tooltool ke pinnau bet tiko ye.’ ” ");
INSERT INTO apr_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Ye kene tani in inepe bareme mai ke sungunu lono, inbe di tooltool yo matadi kisis le di tooltool yo kedi dook tiap nga, ngan tilo pang ye, a lo ikarata di le tinidi dook mata mulu. ");
INSERT INTO apr_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Bong di tooltool maimai ke paroranga so pang Maro, inbe di pannoongoo ke wer ke Maro, ngan tikamata mos dook mata tina yo iyei nga, inbe tilongo di kakase yo kookoodi bareme mai ke sungunu lono nen, “Tayitmaka Dawiti natunu, in ene!” Ngan nen le di tooltool kuto maimai tina lodi dook tiap san. ");
INSERT INTO apr_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Le nga titoro Yesu nen, “Ai, ong i kulongo betanga yo di kakase maimai tiap ngo koodi ye ngan lapau?” Ngan iraua betanga kidi nen, “E, alongo lapau. Bong nga gelei, ang nga o kakinkata betanga yo iken ye Rau ke Maro, in tiap, too? Betanga tani in iwete nen, ‘Maro ong taum la kupamadit di kakase paunu inbe di kakase yo maimai tiap ngan lodi i, ngan la le di nga tiyitmaka em ye koodi nga.’ ” ");
INSERT INTO apr_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Yesu iwete pang di nen a imot, motong la igege di sila tinepe ye malala mai tani in, inbe imadit a idu pang malala san yo ene Betani i, le du bong a iken nango. ");
INSERT INTO apr_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Tiken le muntu yege, inbe Yesu iye di galiunu timadit a tigege malala tani, inbe timulu pang Yerusalem. Tipa dada a tilo ngan Yesu pitola. ");
INSERT INTO apr_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Le nga bet matana pang nen, ngan ikamata kai pik atu ikodo ke dada koonoo. Motong la ipa a ila potai ye a bet ikamata, ngan kanono siap, bong raunu leu. Motong la ipasak pang kai pik tani nen, “Ong i o ke bet kupu mulu pitiap yege.” Ngan le pattu leu inbe kai pik tani in iwod. ");
INSERT INTO apr_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Ngan di galiunu tikamata kai pik tani yo pattu leu be iwod nga, le titakrai, inbe tiyei ne, “Ona, kai pik ni nga balai a le pattu leu be iwod nga?” ");
INSERT INTO apr_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Motong la Yesu iraua betanga kidi nen, “Awete pang moolmool nen. Kumata bet katara lomu medana pang Maro le lomu rru tiap nga, ngan o ke bet kayei so dawa ben yo ayeii ye kai pik ni, in leu tiap. Bong ang nga ke bet kawete pang kawal ni ne, ‘Kumadit a ong taum kupas le kudu tiek lono ni,’ ngan ole so pombe ben tina yo kawete nga. ");
INSERT INTO apr_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Le kumata bet katara lomu medana moolmool pang Maro, inbe kapatarau a katoru ye soo so bet ikap pang nga, ngan ole ikap pang le imot.” ");
INSERT INTO apr_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Yesu ipa le ilo koongoo lono ke bareme mai ke sungunu, motong la nga ipatomonai di tooltool. Ngan di tooltool maimai ke paroranga so pang Maro, inbe di tooltool maimai kidi Yuda timan pang ye man titoru. Tiyei ne, “Ai, sei itarong a le kuyei urata nen i? Inbe sei ikaua gurana pong bet kuyei urata nen ye i?” ");
INSERT INTO apr_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Motong la Yesu iwete pang di nen, “Dook mata, bong nga bet atorang ye torungu kiau atu ngan. Kumata bet karauu nga, ngan la bet awete pang ye sei tool yo ikaua gurana pau a le ayei urata i nga. ");
INSERT INTO apr_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Oo, kawete! Yowan yo irriu di tooltool i, in ikaua gurana ngai a le iyei urata ki ye nga? Gurana tani in ipa ye Maro yo inepe ye malala ki ete ni, too ipa ye di tooltool ke tana leu?” Motong la di tooltool tina ngan sila di tapdi tiwetewete nen, “Ona! Kumata le tawete bet Maro yo inepe ye malala ki ete ni, in la ikaua gurana pang Yowan in nga, ngan ole itoridi nen. Iyei ne, ‘Ngan nga gelei a le katara lomu medana ye betanga ki tiap nga?’ ");
INSERT INTO apr_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Bong kumata le tawete bet di tooltool ke tana i leu la tikaua gurana pang Yowan nga, ngan o dook mata tiap lapau. Idi nga tatattadai bet di tooltool tigarungidi nga, yesoo di le imot nga tiwete bet Yowan in Maro koonoo atu moolmool.” ");
INSERT INTO apr_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Ngan nen le tiraua betanga ke Yesu nen, “Am nga lomam galanga tiap sa.” Motong la Yesu iyei ne, “Nen ngan au lapau, o ke bet awete pang ye sei tool yo ikaua gurana pau a le ayei urata nen ye i, in tiap.” ");
INSERT INTO apr_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Motong la Yesu iwete le ikatte betanga atu pang di tooltool tina nen, “Ang lomu balai ye betanga kiau yo awete nga? Oo kakamata, tool atu in natunu tamoto ru. Ngan ila ye yo mai i a la iwete panga nen. Iyei ne, ‘Natuk, katai nga lok bet kudi kouo urata ye kumu kiidi ke ooroo wain ni.’ ");
INSERT INTO apr_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","“Ngan natunu tani iraua betanga ki nen, ‘Na, au i tinik booroomoo, le o adi akaua urata tiap.’ Bong inepe kasin, motong la lon portak mulu a idi iyei urata nga. ");
INSERT INTO apr_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","“Motong la tool tani, in ila pang ye natunu kase a la iwete panga ben tina iwete pang yo mai in nga. Ngan le natunu tani in iyei ne, ‘Tamak, ngan dook mata. Au i lok ponana bet ayei urata pong.’ Bong inepe, ngan tinin booroomoo le ke bet idi iyei urata tiap.” ");
INSERT INTO apr_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Motong la Yesu itor di tooltool maimai tina nen, “Oo, ngan di kakase ru tina nga, ngan sei kase itoo tamana koonoo a idi iyei urata i?” Ngan tiyei ne, “Natunu la mai i.” Motong la Yesu iwete pang di nen, “Awete pang moolmool nen, di tooltool ke sodaningi pat, inbe di garup ke dada, ole timugu pang a tilo tigaua ye di tooltool yo Maro bet matan kala di nga. ");
INSERT INTO apr_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Awete pang nen nga, yesoo Yowan in iman bet man ipitnai dada dook mata noonoonoo ke Maro yo bet kayei nga, bong ang nga katara lomu medana ye betanga ki tiap. Ang nga kayei nen, bong di tooltool ke sodaningi pat, inbe di garup ke dada la tilongo betanga ki le titara lodi medana ye nga. Ang nga kakamata so yo nen ngan oo, bong o ke bet kaportak lomu a katara lomu medana panga, ngan tiap.” ");
INSERT INTO apr_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Motong la Yesu ikatte betanga san mulu pang di tooltool maimai tina nen, “Katar talngamu dook, a nen ngan kalongo kattenge betanga san i. Tool tana taunu atu in ikapgi kumu atu ke ooroo wain, motong la ikap koongoo ye. Inbe ikele tana atu kumu lono a ikarata bet tipisi wain puana tina ngan surunu idu ye. Inbe ire rumu atu le ilo ete pang di tooltool yo bet lo tinepe ye a matadi kala kumu tani nga. Motong la itara kumu tani in lo di tooltool ke kapgingi pattu bedi, a bet matadi kala, inbe tiyei urata ye. Inbe ye taunu in ipa a ila pang ye malala san yo iken ni mooloo i. ");
INSERT INTO apr_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Ngan tinepe le lal ke bet tigogo wain puana ye in potai, motong la iwanga di kapraingi ki bet tila la tikap kan wain tina ngan puana sa. ");
INSERT INTO apr_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","“Bong tila, ngan di tooltool tina yo tikaua urata ye kumu tani nga, ngan tiparama di kapraingi tina a tiraua atu, inbe san in tiraumate le imata, inbe san in tikatu ye pat. ");
INSERT INTO apr_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Motong la kumu taunu tani in iwanga di kapraingi ki kapala mulu, ngan alunu le tillos di yo tila mugu nga. Ngan di tooltool tina yo tikaua urata ye kumu nga, ngan tiyei dada gaongo leu pang di nen lapau. ");
INSERT INTO apr_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Motong la kumu taunu tani, in lon wete nen, ‘Dookoot nga ole awanga natuk tamoto i a ila, ngan la bet ole tiraua panga nga.’ ");
INSERT INTO apr_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","“Bong ye kene yo di tooltool ke kapgingi tina ngan tikamata natunu tani ye in nga, ngan di tapdi tiwetewete nen, ‘Kakamata, kumu taunu tani in natunu la iman i. Kumata le bet pang dama ni nga, ngan ole ikolo tamana ye kumu i a iyei kumu taunu. Le kaman a taraumate le imata, a bet nen ngan so yo tamana bet ikap panga nga, ngan takap le imot paidi.’ ");
INSERT INTO apr_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Nen le tikauu a tiyolle a tikatte du ke diki, inbe tiraumate le imata.” ");
INSERT INTO apr_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Motong la Yesu itor di nen, “Ye kene yo kumu taunu tani bet ipa mur a ila nga, ngan lomu tar bet ole iyeie soo dada pang di tooltool yo itar di bet tikaua urata ye kumu ki nga?” ");
INSERT INTO apr_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Ngan di tooltool maimai tina tiyei ne, “Ole inganga di tooltool dook tiap tina a igarung di le dook tiap yege. Lo ngan bet ikaua kumu ki in pang di tooltool kapala a tikaua urata ye, a bet nen ngan tinepe le lo lal ke goganga ooroo wain puana nga, ngan tigogo a tikap kan sa.” ");
INSERT INTO apr_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Motong la Yesu iwete pang di mulu nen, “Ang nga o kakinkata betanga ke Maro yo iken ye rau ki, in tiap, too? Ngan betanga tani in nen, ‘Pat yo di tooltool ke renge rumu lodi panga tiap a tisukraii i, in la iyei pat dook mata yo bet ipamede rumu le imede i. Tool Mai iyeie so nen, le amkamata ye matamam, ngan dook mata san.’ ” ");
INSERT INTO apr_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Motong la Yesu iyei ne, “Dada yo bet kalo kagaua ye di tooltool yo Maro bet matan kala di i, in ole ikutaki yang, inbe ikauu pang di tooltool kapala yo tilongo betanga ki ngan titoo dook mata nga. ");
INSERT INTO apr_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Le kumata sei tool bet imol le du irauu pang ye pat tani nga, ngan ole turana bokobokobe le morrana. E kumata bet pat tani in imol le du ikata tool sa nga, ngan ole igarungu tool tani le dook tiap yege.” ");
INSERT INTO apr_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Di tooltool maimai ke paroranga so pang Maro, inbe di Paresi tilongo kattenge betanga ke Yesu yo iweta pang di i, le lodi galanga bet nga iwetewete ye di. ");
INSERT INTO apr_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Ngan nen le nga tisere dada yo bet tiparama ye i, bong ngan titattadai di tooltool malala mai yo tinepe nga, yesoo di le imot ngan tiwete bet Yesu in Maro koonoo atu. ");
INSERT INTO apr_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Motong la Yesu isudungu kattenge betanga pang di tooltool maimai tina a iwete pang di mulu nen, ");
INSERT INTO apr_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Dada yo Maro bet matan kala di tooltool ki ye i, in dawa ben tool yo iyei kuto mai pang tana mai atu i. Ngan tool tani in iyeie mailang mai atu ye kerenge ke natunu tamoto. ");
INSERT INTO apr_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Ngan nen le iwanga di kapraingi ki bet la tiwete pang di tooltool yo mugu ngan itara betanga pang di bet timan ye kerenge nga. Bong di kapraingi ki tina tila tiwete pang di, ngan tinidi booroomoo le lodi pang maningi tiap. ");
INSERT INTO apr_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","“Motong la iwanga di kapraingi ki kapala mulu a bet tila, ngan iwete pang di nen, ‘Kala nga, ngan la kawete pang di tooltool yo atara betanga pang di ngan nen, bet akarata so a dook oo. Inbe au i araumata bulumakau tamoto atu, inbe bulumakau kapala yo lodi belebele nga, ngan la araumata di inbe akum di a ime oo. Le kawete pang di a timan man taye di takana mailang ke kerenge i.’ ");
INSERT INTO apr_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","“Di kapraingi ki tina tila tiwete pang di tooltool tina, bong lodi pang bangana ki tiap, le tikoo a tipa kidi kidi. Atu in idi pang kumu ki, inbe san in ila pang ye urata ki ke kaungu pat. ");
INSERT INTO apr_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Inbe di kapala ngan timadit tina le tiparama di kapraingi ke tool mai tani, a tigarung di, inbe tiraumatamata di a timmata. ");
INSERT INTO apr_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Tina tiyei nen nga, le tool tani yo iyei kuto mai pang tana mai i, in katen malmal a iwanga di tooltool ki ke patokongo a tila tiraumatamata di tooltool tina le imot yo tiraumatamata di kapraingi ki nga, inbe tidaunu malala mai kidi in a ei ikani. ");
INSERT INTO apr_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","“Motong la tool kuto mai tani in iwete pang di kapraingi ki nen, ‘Mailang ke kerenge i akarata a imot oo, bong di tooltool yo awanga pang di bet timan ye nga, ngan ayeisa di ngan tooltool dook mata a man aye di amkani, bong tiap. ");
INSERT INTO apr_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Le dookoot nga kala la kapa ye ni ke yawaringi so, le bet kakamata di tooltool sa nga, ngan kawete pang di le imot a timan ye mailang ke kerenge i.’ ");
INSERT INTO apr_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Motong la tila tipa ye ni ke yawaringi so a tipusye di tooltool yo dook mata nga inbe di tooltool yo dook tiap nga, ngan tiwete pang di le imot bet tila ye mailang tani. Ngan nen le tilo tilo le rumu ke kaningi so in ipon ye di. ");
INSERT INTO apr_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Di tooltool tina timan a tilo ye ni tani, motong la tool mai tani iman a bet lo ikamata di, ngan ikamata tool atu in isousou ye sousoungu ke kerenge tiap. ");
INSERT INTO apr_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Le nga itoru nen, ‘Ai, tool kiau, nga gelei bet kusousou ye sousoungu ke kerenge tiap, inbe kuse ni nga?’ Itoru nen, le nga tool tani isere betanga a sila ipalongo leu. ");
INSERT INTO apr_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","“Motong la tool kuto mai tani, in iwete pang di kapraingi ki nen, ‘Oo, kakap ooroo a kapau tool i kene le bene a kakatte du pang ni todo lono ke diki ni. Kakatte du ye ni yo bet timassingi a titangtang inbe tikanen dongadi a iparrasa ye i.’” ");
INSERT INTO apr_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Motong la Yesu iwete pang di tooltool tina nen, “Kalongo koot? Maro ikiu di tooltool alunu la bet timan pang ye nga, bong ole alunu tiap yo ipootoo di panga nga, ngan di leu la bet tilo ye nga.” ");
INSERT INTO apr_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Di Paresi tigege Yesu a tidu ke diki, motong la tigaua inbe tiraua betanga bet titoua ye betanga sa. ");
INSERT INTO apr_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Motong la tiwanga di galiudi tiye di tooltool pattu yo tikata suanga ye Erot nga, a tila pang ye. Tila, motong la tiwete panga nen, “Pannoongoo, am nga lomam galanga yong nen, bet ong i kuwete betanga kiong nga, ngan moolmool le imot. Inbe kupatomonai di tooltool ye dada moolmool ke Maro le imot. Inbe ong i kutattadaia kam tooltool siap. Le kumata bet kuwete pang di nga, ngan lom rru ye di bet di tooltool balai, ngan tiap, bong ole kuwete betanga gaongo leu pang di. ");
INSERT INTO apr_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Ngan nanga, ole kuwete pam ngan. Ong i lom balai? Nga dook mata bet idi nga tatar pat pang tool kuto mai kidi Rom yo Sisa i, too tiap?” ");
INSERT INTO apr_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Titoru nen, bong Yesu lon galanga ye dada dook tiap yo iken lodi a le titoru ye in oo. Le nga iyei ne, “Ang nga di tooltool ke kaplungunu sa! Nga gelei a kakapge bet katou au nga? ");
INSERT INTO apr_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Kakaua pat yo kanakana ngan tatar pang Sisa ngan atu a kapitnaii a akamata.” Motong la tikaua pat tina ngan atu pang ye. ");
INSERT INTO apr_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Motong la itor di nen, “Sei kannungana inbe ene iken ye pat i nga?” ");
INSERT INTO apr_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Ngan tiyei ne, “In Sisa.” Motong la Yesu iwete pang di nen, “Aoo, ngan dook mata! Bet so ke Sisa, ngan kakap pang Sisa. E so ke Maro, ngan kakap pang Maro.” ");
INSERT INTO apr_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Ye kene yo tilongo betanga ke Yesu ye in nga, ngan le titakrai ye betanga ki. Le nga tigege sila inepe, inbe tikoo a tila. ");
INSERT INTO apr_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Motong la ye ke tani ataleu in di Sedusi timan pang ye Yesu bet man titoru. Ngan di Sedusi tina ngan di Yuda pattu yo tiwete bet di tooltool timmata nga, ngan o ke bet timadit mulu tiap. Le nga man titoro Yesu nen, ");
INSERT INTO apr_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Pannoongoo, mugu ngan Mose iwete pam nen. Kumata le tool atu bet ikere le rimana ipasuiu kan kase siap, inbe tamoto tani in imata nga, ngan taini ole ikoli a iyooloo tap ke toonoo, a bet nen ngan garup tani in ipasui kase sa panga nga, ngan ole iseke rara ke toonoo tani in pang dama a ila. ");
INSERT INTO apr_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Mose iwete paidi nen, bong amtorong, ole kuwete balai? Oo, tool atu in natunu tamoto limi be ru, ngan tinepe yam. Ngan toodi yo mumuganga in ikere, ngan le rimana ipasui toko kan kase siao, inbe imata. Le igege sila inepe a taini yo itoo i, in iyooloo tap ke toonoo tani. ");
INSERT INTO apr_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Bong taini tani iyooloo, ngan gaongo leu, taukan natunu go, inbe imata. Motong la taidi san yo tol kidi, in ikauu a iyooloo, ngan gaongo leu nen lapau. Ngan tiyei nen nen le du imot ye taidi kase yo limi be ru kidi i. ");
INSERT INTO apr_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Motong la garup tani in ye lapau imata a itoo di nga. ");
INSERT INTO apr_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Ngan nanga, kuwete pam ngan, ye lal yo bet di tooltool matedi bet timadit mulu ye in nga, ngan garup tani ole iyei sei rimana? Yesoo, di tamoto tina yo limi be ru nga, ngan di le imot tiyooloo garup tani oo.” ");
INSERT INTO apr_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Motong la Yesu iraua betanga kidi nen, “Ang nga kawete googoomu, yesoo lomu galanga ye betanga yo iken ye Rau ke Maro, ngan tiap. Inbe lomu galanga ye gurana ke Maro, ngan tiap lapau. ");
INSERT INTO apr_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Ye lal yo di tooltool matedi bet timadit mulu ye in nga, ngan o ke bet tikere mulu tiap. Di ngan ole tinepe dawa ben di bangabangana ke Maro yo tinepe ye malala ki ngo. ");
INSERT INTO apr_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Bong ye di tooltool yo timmata lo ngan bet timadit mulu nga, ngan ang nga o kakinkata betanga ke Maro yo iweta pang a iken ye rau, in tiap, too? Ngan betanga tani in iwete nen ye di sasa kiidi yo timmata koot nga, ngan nen, ");
INSERT INTO apr_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Au i Maro ke Awaram ye Esaka inbe Yakop.’ Le i Maro kidi tooltool yo timmata koot nga, ngan tiap, bong i Maro kidi tooltool yo tinepe maguredi nga.” ");
INSERT INTO apr_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Ye kene tani in di tooltool budanga mai la tilongo betanga ke Yesu nga, le nga titakrai ye patomonaingi ki. ");
INSERT INTO apr_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Di Paresi tilongo bet Yesu ikatkalakala dada ye di Sedusi ye betanga le tisere betanga nga, le nga di Paresi tina tigaua, inbe timan pang ye. ");
INSERT INTO apr_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Motong la tool kidi Paresi tina ngan atu yo kuto mai ke wer ke Maro i, in imadit tina le bet itouo Yesu ye betanga, le nga itoru. Iyei ne, ");
INSERT INTO apr_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Pannoongoo, soo wer ke Maro imugu le illos di wer kapala i?” ");
INSERT INTO apr_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Motong la Yesu iraua torungu ki nen, “‘Lomu pang Maro yo Tool Mai kiang i, in mai san, inbe kagaua lomu le tinimu ipa ye lo galanga kiang le imot panga.’ ");
INSERT INTO apr_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Le i wer ataleu yo imugu inbe illos di wer kapala le imot i, in naii. ");
INSERT INTO apr_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Inbe wer san yo itoo i, in nen. ‘Lom pang di diem mai san dawa ben yo ong taum lom pong mai san nga.’ ");
INSERT INTO apr_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Le awete pang nen, wer ke Maro le imot yo ikap pang Mose, inbe betanga yo di Maro koonoo tiwodo nga, ngan di le imot pudi nga igaua le iken ye wer ru leu tina nga.” ");
INSERT INTO apr_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Di Paresi tina ngan tigauagaua a tinepe go, inbe Yesu itor di nen, ");
INSERT INTO apr_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Ai, ang nga lomu tar balai ye Kirisi? Bet in sei natunu?” Ngan tiyei ne, “Ye in Dawiti natunu.” ");
INSERT INTO apr_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Motong la Yesu iwete pang di. Iyei ne, “Nga gelei a Maro Amunu ipamaditi Dawiti lono a le ikiui Kirisi tani in ye Tool Mai nga? Kakamata, Dawiti in iwete nen, ");
INSERT INTO apr_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Maro yo Tool Mai i, in iwete pang Tool Mai kiau nen, “Kuwur ye bek oonoo a kunepe nen le lo atar di koi kiong a tidu ke kem parmana.” ’ ");
INSERT INTO apr_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Le kakamata, Dawiti ye taunu la iweta ye Tool Mai ki i. E nga gelei a le ang nga kawete bet ye in Dawiti natunu nga?” ");
INSERT INTO apr_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Tina Yesu itor di nen nga, le sila tipalongo leu. Le tool sa mala bet iwete a iraua betanga ki, ngan tiap. Ngan nen le ye kene tani in a ilo nga, ngan tool sa mala bet itoro Yesu ye betanga sa mulu, ngan tiap lapau. ");
INSERT INTO apr_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Motong la Yesu iwete pang di galiunu tiye di tooltool budanga mai ngan nen, ");
INSERT INTO apr_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Di pannoongoo ke wer ke Maro tiye di Paresi nga, ngan tikaua malala ke Mose, inbe tipatomonai ang ye wer ke Maro ben tina yo mugu ngan Mose iyei nga. ");
INSERT INTO apr_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Le bet nen ngan katoo betanga kidi a kayei so le imot yo tiwete pang bet kayei nga. Bong ken katoo di ye dada kidi yo tiyei nga be, yesoo di tapdi nga tiyei so le titoo betebetanga kidi yo tiwetewete pang di tooltool ye, ngan tiap. ");
INSERT INTO apr_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Di ngan tikap wer matana matana a man tiwete bet di tooltool titoo, le imoo pang di mai san dawa ben tiliki burum moonoo a tipaloka lo di tooltool poopoodi a bet tisola nga. Bong di tapdi ngan lodi bet titara bedi boroborene atu la tilon di tooltool tina yo tisolo burum moonoo tani, ngan tiap. ");
INSERT INTO apr_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","“Inbe so le imot yo tiyei nga, ngan tiyei bet nen a di tooltool tikamata. Le so yo tiwodo betanga ke Maro ilo ye, a bet tipau lo ye damodi le bedi nga, ngan tikarata le somaimai a bet nen ngan di tooltool tikamata. Inbe ye moro yo tituru a tiwat ilo ye sousoungu mooloo mooloo kidi ke pataraungu ngan matana nga, ngan tiyei le mooloonoo a bet nen ngan di tooltool tikamata, ngan tiyitmak edi ye. ");
INSERT INTO apr_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Nen le ye kene yo bet tilo ye gaongo ke mailang, too tilo ye rumu kidi Yuda ke gaongo nga, ngan lodi bet tilo dama a lo tiwur ye kakawa kidi tooltool yo edi maimai nga a bet di tooltool tiyitmak edi. ");
INSERT INTO apr_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Inbe di ngan lodi bet tipa ye ni ke yawaringi so, a nen ngan di tooltool tiwete lo ponana kidi pang di, inbe tikiu di ye ‘Tool mai ke Patomonaingi.’ ");
INSERT INTO apr_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Bong ang nga ken lomu bet di tooltool tikiu ang ye ‘Tool mai ke Patomonaingi’ be, yesoo ang le imot nga taimu le toomu. Inbe tool ataleu la iyei kuto mai pang i. ");
INSERT INTO apr_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Inbe ken tool sa ke tana i bet ikiu ang ye ‘tamamu,’ ngan be, yesoo ang nga Tamamu ataleu, in ye la inepe ye malala ki ete ni. ");
INSERT INTO apr_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Inbe ang nga lomu bet tikiu ang ye ‘pannoongoo’ be, yesoo ang nga Pannoongoo kiang ataleu, in la Kirisi i. ");
INSERT INTO apr_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Ngan nanga, kumata bet ang tina nga atu lono bet iyei mai pang nga, ngan ole iyei ben kapraingi kiang. ");
INSERT INTO apr_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Yesoo, sei tool yo ye taunu iyitmaki le ilo ete i, in ole Maro itaru le idu lopo ni. Bong sei tool yo ye taunu itaru le idu lopo i, in ole Maro iyitmaki le ilo ete ni.” ");
INSERT INTO apr_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","14","Motong la Yesu iwete mulu nen, “Atoo, ang di pannoongoo ke wer ke Maro inbe di Paresi nga, ang nga tooltool ke kaplungunu sa, le ken kakamatang dook leu! Ang tapmu nga kalo kagaua ye di tooltool yo Maro bet matan kala di, ngan tiap. Bong di tooltool yo tikapge bet tilo nga, ngan kawono kala dada ye di le ke bet tilo tiap. ");
INSERT INTO apr_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Atoo, ang di pannoongoo ke wer ke Maro inbe di Paresi nga, ang nga di tooltool ke kaplungunu sa, le ken kakamatang dook leu! Ang nga kapa ye ni mai i le imot ke bodanga inbe tiek pono, a bet nen ngan kayeie tool sa le iyei galiumu. Ngan kumata bet tool atu ilongo betanga kiang le bet iportaka lono a itoo ang nga, ngan ye in kayeii le iyei dada dook tiap le lo illosang ye dada dook tiap yo kiang nga. Ngan nen le pang dama ni nga, ngan ole kaye kadu pang ye malala ke masngana. ");
INSERT INTO apr_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Atoo, ang nga tooltool mata kis yo lomu bet karara di tooltool kapala nga, le ken kakamatang dook leu! Ang nga kapatomonai di tooltool nen, ‘Kumata bet tool sa ipootoo bareme mai ke sungunu a bet ipamede betanga ki ye nga, ngan betanga ki in ben so sorok. Bong kumata bet tool sa ipootoo pat gol yo iken bareme mai ke sungunu lono ni, a bet ipamede betanga ki ye nga, ngan ole iyei so tina yo ipamede betanga ye nga.’ ");
INSERT INTO apr_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Ang di tooltool mata kis nga kapakapa sa! Soo so maiyoko le illoso ene i? Lomu tar bet pat gol la illoso bareme mai ke sungunu i, too bareme mai ke sungunu la illosi i? Ole lomu galanga nen, pat gol in iken ye bareme ke sungunu, ngan la le bareme mai ke sungunu iyeie pat tani le iyei ben pat mison ke Maro nga. ");
INSERT INTO apr_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Inbe kawete nen lapau, ‘Kumata bet tool sa ipootoo kakawa ke paroranga so a bet ipamede betanga ki ye nga, ngan betanga ki in ben so sorok. Bong kumata bet ipamede betanga ki ngan ipootoo so yo tikap pang paroranga a lo iken kakawa ke paroranga so pono nga, ngan ole iyei so tina yo ipamede betanga ye nga.’ ");
INSERT INTO apr_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Ang nga tooltool mata kis sa! Soo so maiyoko inbe dook mata le illoso ene i, so ke paroranga, too kakawa ke paroranga so? Ole lomu galanga nen, kaningi le so ke paroranga ngan iken kakawa ke paroranga so pono nga, ngan la le iyei so ke paroranga tina le iyei ben so mison ke Maro nga. ");
INSERT INTO apr_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Ngan nanga, sei tool bet ipootoo kakawa ke paroranga so a bet ipamede betanga ki ye nga, ngan ipootoo so ke paroranga le imot yo iken ye kakawa tani pono nga, ngan lapau. ");
INSERT INTO apr_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Inbe sei tool bet ipootoo bareme mai ke sungunu a bet ipamede betanga ki ye nga, ngan ipamede betanga ki ye le ipa ye Maro ye taunu yo inepe lono i, in lapau. ");
INSERT INTO apr_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Inbe sei tool bet ipootoo malala ke Maro ene a bet ipamede betanga ki ye nga, ngan ipamede betanga ki ye kakawa ke Maro ke burungu inbe ye Maro ye taunu yo iwurur ye kakawa tani in lapau. ");
INSERT INTO apr_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Atoo, ang di pannoongoo ke wer ke Maro inbe di Paresi nga, ang nga di tooltool ke kaplungunu sa, le ken kakamatang dook leu! Kanakana ngan katoo wer maimai tiap kapala le kagogo so matana matana kiang ke kumu yo ben kudu le ooroo puana ke kaningi le so kapala nga, a katar le iken ye budanga sangaul, lo ngan bet kakaua budanga tina, ngan atu pang Maro. Bong nga gelei a katoo wer maimai yo ke Maro nga, ngan tiap nga? Ngan wer maimai tina ngan nen: kakarata betanga ke di diemu ye dada yo dook mata moolmool nga; inbe lomu mulumulu ye di diemu a kayei dada dook mata pang di; inbe katara lomu medana le iken so pang Maro leu. Le dook mata ngan nen, ole katoo wer maimai tina nga le imot le ipa ye wer yo maimai tiap, ngan lapau. ");
INSERT INTO apr_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Ang nga tooltool mata kis yo lomu bet karara di tooltool kapala nga. Inbe ang nga ben tool yo ikamata so maitiap ben baranges ilo ye sur ki, ngan ole italiki i. Bong ikamata asara mai yo ene kamel yo ilo sur lono ki, in tiap, le bet iyini sur ngan itona le ipa ye sur a ilo kapono lono. ");
INSERT INTO apr_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Atoo, ang di pannoongoo ke wer ke Maro inbe di Paresi nga, ang nga di tooltool ke kaplungunu sa, le ken kakamatang dook leu! Ang nga kangas ruku le omai kiang diki ki nga le igalanga dook mata san, bong lono ngan ipon ye giri dawa ben tool yo gadagadana inbe matana so i. ");
INSERT INTO apr_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Ang di Paresi nga matamu kisis! Bet nen ngan kangas ruku le omai kiang lono mugu le igalanga dook ngan, ngan la bet diki ki ngan ole igalanga lapau nga. ");
INSERT INTO apr_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Atoo, ang di pannoongoo ke wer ke Maro inbe di Paresi nga, ang nga di tooltool ke kaplungunu sa, le ken kakamatang dook leu! Ang nga dawa ben agoro yo titar di tooltool matedi ye i, inbe tisama diki ki ye kau kookoonoo le tikamata ngan dook mata san i. Bong lono in ipon ye di tooltool turadi inbe ye so yo giri leu nga. ");
INSERT INTO apr_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Ngan gaongo leu, ang nga nen lapau. Ye kanomu diki ki nga di tooltool tikamatang, ngan tiwete bet ang nga katoo dada dook mata noonoonoo ke Maro nga le imot. Bong tiap, ye lomu ngan ipon ye kaplungunu le dada yo dook tiap nga. ");
INSERT INTO apr_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Atoo, ang di pannoongoo ke wer ke Maro inbe di Paresi nga, ang nga di tooltool ke kaplungunu sa, le ken kakamatang dook leu! Ang nga kakarata agoro yo titar di Maro koonoo bobodi ye nga le dook mata san. Inbe kamoro gomo koonoo kidi tooltool noonoodi ke Maro. ");
INSERT INTO apr_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Inbe ang nga kawete nen, ‘Ye kene yo di sasa kiam tinepe ye in nga, ngan yo bet am lapau amnepe nga, ngan matin nga ke bet amlon di a amye di amraumata di Maro koonoo, nga tiap.’ ");
INSERT INTO apr_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Le betanga kiang yo kawete nga, ngan ang tapmu kapaposang nen, bet ang nga sasa kidi tooltool yo mugu ngan tiraumatamata di Maro koonoo nga. ");
INSERT INTO apr_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Le kumata bet nen nga, ngan ang kamadit a kakap malala kidi! Le soo dada dook tiap ke sennene bet di sasa kiang tiyei le imot tiap nga, ngan ang kaseke di ye a kayei le lo imot. ");
INSERT INTO apr_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","“Ang nga moto dook tiap, inbe ang nga moto dook tiap di natunu! Ole Maro ipaposang ye urata dook tiap yo kayei nga, a ikatte ang du ye malala ke masngana. Le ole kasuru kate malmal ke Maro balai? ");
INSERT INTO apr_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Ngan nanga, au i ole awanga di Maro koonoo le di tooltool yo ke lo galanga nga inbe di pannoongoo bet timala pang yang a mala tipatomonai ang ye dada kiau. Bong di tooltool tina, ngan ole karaumatamata di kapala a timmata, inbe di kapala ngan kapatoto di tilo kai palasingi kaini, inbe di kapala ngan ole kawalis di rumu lono kiang ke gaongo, inbe kanin di a katoo di ye malala maimai nga le imot. ");
INSERT INTO apr_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Ngan nen le Maro ikaua urata moonoo dook tiap pang, ye yo karaumatamata di tooltool noonoodi a rara kidi imati ye tana i nga. Ngan dada ke raumatenge di tooltool noonoodi, in imadit mugu ye Awel le ise ye Berekia natunu Sakaria, yo di sasa kiang tiraumate kataunu ke bareme mai ke sungunu inbe kakawa ke paroranga so i. ");
INSERT INTO apr_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Awete pang moolmool nen, dada dook tiap yo kaye di sasa kiang kayei nga, ngan ole kootoonoo pombe pang yang ang di tooltool yo dookoot kanepe nga.” ");
INSERT INTO apr_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Yesu iwete pang di a imot, motong la iwete mulu nen, “Atoo, Yerusalem, Yerusalem, ong i la di tooltool kiong tiraumatamata di Maro koonoo a timmata, inbe tikap pat a tikatmatamata di tooltool yo Maro iwanga di a timala pang yong nga. Inbe ye lal alunu ngan au i lok bet agaua di tooltool kiong a tigaua le imot yau, dawa ben tareke tinana igaua di natunu a ipatud di ye balini nga. Bong di tooltool kiong lodi bet timan tigaua yau tiap. ");
INSERT INTO apr_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Le kutar talngam a kulongo, ole Maro igege bareme mai kiong ke sungunu tani a ilo, inbe bareme tani in sila iken sorok. ");
INSERT INTO apr_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Awete pong nen, dookoot nga o ke bet di tooltool kiong tikamatau mulu tiap, le ilo ye lal yo bet tiyei ne, ‘Maro kuyeie urata dook mata pang tool yo isi ye Tool Mai ene i.’ ” ");
INSERT INTO apr_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Yesu igege bareme mai ke sungunu tani, inbe ipa a bet ila. Motong la di galiunu timan pang ye bet man tiwete panga, inbe tipitnai rumu maimai yo ke bareme ke sungunu, ngan panga. ");
INSERT INTO apr_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Motong la iwete pang di nen, “Ang nga kakamata so tina nga le imot ngan dook mata, too? Bong awete pang moolmool nen, pang dama ni ngan ole pat ke rumu tina nga, ngan atu sa yo bet iken a iloko lo ene pono dawa ben dookoot nga, ngan tiap. Bong ole tiraukedekede di le imot a timol du tana le tiken kidi kidi.” ");
INSERT INTO apr_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Ngan Yesu ipa le ilo ye kawal Olip a lo yetaleu iwur, motong la di galiunu tilo pang ye a iye di leu tinepe, inbe titoru. Tiyei ne, “Oo, kuwete pam ngan, ole soo lal bet so tani in pombe ye i? Inbe soo tarkilanga bet amkamata mugu, ngan ole lomam galanga ben lal kiong yo bet kumulu ye i, inbe lal yo tana i bet imot ye i, in iman potai koot i?” ");
INSERT INTO apr_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Titoru nen, motong la iwete pang di nen, “Ken kakamatang dook leu ye di tooltool yo bet tillungang nga. ");
INSERT INTO apr_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Yesoo, di tooltool alunu ole timan pang yang man tipootoo ek, inbe tiyei ne, ‘Au Kirisi tani naii!’ Ngan ole tikap llungunu ye di tooltool alunu le titara lodi medana ye betanga kidi. ");
INSERT INTO apr_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Ole kalongo bingi ke patokongo yo pombe ye malala kapala nga, inbe talngamu rau bet patokongo mai sa ole pombe ye tana maimai kapala lapau, bong ken katattadai a lomu sakarungu be. So yo nen nga ole pombe moolmool, bong so yo awete pang ye nga, ngan lal ki o pombe tiao. ");
INSERT INTO apr_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Ngan di tooltool ke tana mai atu ole timadit a tiye di tooltool ke tana mai san tipatoko. Inbe di tooltool ke tool kuto mai atu ole timadit a tiye di tooltool ke tool kuto mai san tipatoko. Inbe ole pitolo maimai pompombe ye tana kapala, inbe nauningi mai itak ye tana kapala a tana itangarur. ");
INSERT INTO apr_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Ngan urata moonoo yo nen ngan ole pompombe mugu, dawa ben garup kapon massingi ye natunu a bet ipasuiu nga. ");
INSERT INTO apr_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Ye kene tani in, ole di tooltool tikau ang a titarang kalo ye ni ke karatanga betanga, a bet nen ngan tikap urata moonoo ke masngana pang, a tirau ang le kammata. Inbe di tooltool ke tana maimai nga le imot ole tikadonang, yesoo ang nga katara lomu medana pau. ");
INSERT INTO apr_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Inbe ye kene tani in, di tooltool alunu yo titara lodi medana pau nga, ngan ole tiwala muridi pau, inbe di tapdi tiparkadon a titar di diedi la di koi kidi bedi. ");
INSERT INTO apr_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Inbe di tooltool ke kaplungunu yo tiwete di ye Maro koonoo nga, ngan ole alunu la bet pompombe a tipa bet tillungu di tooltool alunu nga. ");
INSERT INTO apr_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Inbe di tooltool o ke bet lodi pang di diedi mai san mulu tiap, yesoo dada dook tiap alunu ole pombe ye tana i le mai san. ");
INSERT INTO apr_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Bong di sima tooltool yo tikodo le timede ye lo medana kidi a tikodo nen le lo timmata nga, ngan Maro ole ikap di a ipamulu di ye so dook tiap yo bet igarung di i. ");
INSERT INTO apr_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Inbe bingi dook mata ke dada yo Maro bet matan kala di tooltool ki ye i, in ole tiweteweta pang di tooltool ke tana mai i le imot a tilonga, ngan la bet lal tani yo bet tana i imot ye i, in pombe nga. ");
INSERT INTO apr_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Pang dama ni ngan ole kakamata so dook tiap ki taunu in ikodo ye ni mison ke Maro bet igarungu, dawa ben mugu ngan Maro koonoo yo Tanel i, in iwetewete ye nga. Le ong sei tooltool bet kukinkata betanga tani nga, ngan lom kaua urata ye dook, a nen ngan lom galanga ye. ");
INSERT INTO apr_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Ngan nanga, le bet kakamata so nen nga, ngan ang di tooltool yo kanepe ye tana mai Yudia nga, ngan kakoo tarrai a kalo pang kawal. ");
INSERT INTO apr_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Inbe kumata bet tool sa inepe rumu pono ki nga, ngan ken idu tana a lo ikaua so ki yo iken rumu lono ngan atu sa, ngan be, bong ipas le igege sila ikino leu. ");
INSERT INTO apr_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Inbe kumata bet tool sa inepe kumu lono ki nga, ngan ken imulu pang rumu ki du ikaua sousoungu matolene ki, ngan be, bong ipas le igege sila ikino leu. ");
INSERT INTO apr_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Ye kene tani in di garup yo kapodi nga, inbe di garup yo tiyei borrenge ye di natudi a tipayinin di nga, ngan barau, ole imoo pang di yo bet tikoo nga. ");
INSERT INTO apr_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Le bet nen ngan kapatarau pang Maro nen, ken so tani in pombe ye lal ke mou, too ye lal yo kidi Yuda ke sungunu i, in be. ");
INSERT INTO apr_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Yesoo, urata moonoo dook tiap yo bet pompombe a igarung di tooltool nga, ngan urata moonoo dook tiap ki taunu. Le kulkulunu yege ye kene yo Maro itar lang le tana ye i, le se dookoot nga, ngan urata moonoo dook tiap yo pompombe ngan sa yo bet gaongo ye, ngan tiap. Inbe pang dama ni nga, ngan ole urata moonoo dook tiap gaongo nen sa yo bet pompombe mulu, ngan tiap lapau. ");
INSERT INTO apr_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Nga yo bet Maro lono bet ipamodo lal ke urata moonoo dook tiap tani in tiap nga, ngan matin nga le tool sa yo bet inepe dook mata, ngan tiap. Bong lono ye di tooltool yo ipootoo di panga nga, ngan la le bet ipamodo lal ke urata moonoo tani in nga. ");
INSERT INTO apr_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Nen le ye kene tani in, kumata bet tool sa man iwete pang nen, ‘Kakamata, Kirisi bi e i!’ too, bet iyei ne, ‘Ye meneng e ni!’ ngan ken katara lomu medana ye betanga ki be. ");
INSERT INTO apr_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Awete pang nen, yesoo ole di tooltool ke kaplungunu yo tiwete bet di nga Kirisi, inbe di tooltool ke kaplungunu kapala yo tiwete bet di ngan Maro koonoo nga, ngan ole alunu la bet timan pang yang nga. Di ngan ole tiyei gogo mos le urata maimai a iyei ben tarkilanga pang di, a bet tikaua llungunu ye di tooltool. Inbe ole tikapge bet tikaua llungunu ye di tooltool yo Maro ipootoo di panga nga, a bet nen ngan la titoo di lapau. ");
INSERT INTO apr_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Oi, kakamata koot? So tina yo bet pombe nga, ngan awete pang ye oo. ");
INSERT INTO apr_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Nen le kumata bet tool sa iwete pang nen, ‘Kakamata, Kirisi meneng, inepe ni soorookoonoo ni,’ ngan ken kalongo ki a kala be. Too, bet iyei ne, ‘Kirisi naii, lo inepe rumu lono i,’ ngan ken katara lomu medana ye betanga ki be. ");
INSERT INTO apr_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Yesoo, ye lal tani, in ole dawa ben kili yo itai a lulngana imadit ye ni yo ke ise ye i, a ipa so le idu ye ni yo ke iyara ye i a di tooltool le imot tikamata nga. Le gaongo leu ye lal yo Tool Moolmool ke Maro bet isi ye in nga, ngan ole di tooltool le imot tikamata nen lapau. ");
INSERT INTO apr_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Ye ni nangai bet so matene ngan bobono iken ye i, in ni tani yo bet di kamoko timan man tigaua ye i.” ");
INSERT INTO apr_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Motong la Yesu iwete pang di galiunu mulu nen, “Ye kene yo bet urata moonoo dook tiap tina ngan pombe pang ye di tooltool nga, ngan ole pattu leu inbe ‘ke ole matan kumukumu, inbe taudu ole isini mulu tiap. Inbe di kanpitiki ole timakedekede ke lang katene a timol a tisi, inbe so ke lang katene yo gurana kidi maimai mata nga, ngan ole titangarur.’ ");
INSERT INTO apr_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","“Ye kene tani in, tarkilanga ke Tool Moolmool ke Maro, ole pombe lang katene a di tooltool tikamata. Ngan la bet di tooltool ke ni mai i le imot ke tana i ole titang, yesoo ole tikamata Tool Moolmool ke Maro inepe eng tene pono ke lang katene, a ipa ye gurana ke Maro inbe ye lulngana mai a isi pang tana. ");
INSERT INTO apr_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Inbe ole iwanga di bangabangana ki a timai so dawa ben tauru a itang le mai, inbe tisi bet si tigaua di tooltool yo ipootoo di panga a tinepe ye tana gigini tina nga. Ngan di bangabangana ki ole tipa ye ni mai i le imot ke tana i le tipa so le la titaua ni yo lang imot ye i, a bet tikap di tooltool ke Maro a man iye di tigaua. ");
INSERT INTO apr_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Dookoot nga lok bet ole kakap lo galanga ye kai pik in raunu. Ye kene yo bet suddana pombe ye bene a bet itar raunu paunu nga, ngan ole lomu galanga nen, rai mai o potai oo. ");
INSERT INTO apr_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Ngan gaongo leu, ye kene yo bet kakamata so le imot yo awetewete nga bet pompombe nga, ngan lomu galanga nen, lal ke so tina yo awetewete ye in o iman potai ye dada oo. ");
INSERT INTO apr_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Awete pang moolmool nen, di tooltool yo dookoot tinepe matadi rerene go nga, ngan ole timmata tiao, inbe so tina le imot yo awete pang ye nga, ngan ole pombe. ");
INSERT INTO apr_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Lang le tana nga ole tilledi, bong betanga kiau nga o ke bet kasin pa ilene, ngan tiap.” ");
INSERT INTO apr_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Motong la Yesu iwete mulu nen, “Tool sa yo bet lon galanga ye ke, too soo ke matana yo bet so tina ngan pompombe ye i, in tiap. Inbe di bangabangana ke Maro yo tinepe ye malala ki nga, ngan lodi galanga ye tiap, inbe Maro Natunu in lon galanga ye tiap lapau, bong Tamana yetaleu in la lon galanga ye i. ");
INSERT INTO apr_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Inbe ye lal yo Tool Moolmool ke Maro bet imulu a isi ye i, in ole di tooltool tiyei dada gaongo leu dawa ben yo mugu ngan pombe ye lal ke Noa nga. ");
INSERT INTO apr_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Ye kene tani in di tooltool tikan bet tiyin, inbe tamoto le garup tikerere, inbe tikap di natudi garup a la tipakere di pang di tamoto kapala, le le ilo ye lal ke Noa yo bet iyiri a ilo ookoo lono ye i. Motong la oongoo mai pombe a igarung di le imot nga. ");
INSERT INTO apr_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Di ngan mala bet le lodi galanga kasin pa ye soo so yo bet pombe pang ye di, in pitiap yege. Bong tinepe nen le lo oongoo mai tani in pombe a iraumatamata di tooltool tina budanga mai ngan le imot. Le in dada gaongo leu tina yo bet pombe lapau ye lal yo Tool Moolmool ke Maro bet imulu a isi ye i. ");
INSERT INTO apr_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Ye kene tani, ngan kumata bet di tamoto ru tinepe kumu lono nga, ngan atu ole Maro ikauu, inbe san in igege sila ikino. ");
INSERT INTO apr_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Inbe gaongo leu, kumata bet di garup ru titutngan dingding patunu pang sopalanga porong nga, ngan atu ole Maro ikauu, inbe san in igege sila ikino. ");
INSERT INTO apr_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“Ngan nen le ken kakauwai yang dook leu, yesoo ang nga lomu galanga ye lal yo bet Tool Mai kiang isi ye i, in tiap. ");
INSERT INTO apr_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Bong ole lomu galanga nen. Kumata bet rumu taunu in lon galanga ye soo lal yo bet bong ngan tool ke pinnau bet man isaua rumu ki ye in nga, ngan tool tani ole matan rere nen a ikodokala rumu ki, a bet nen ngan tool ke pinnau o ke bet isaua rumu ki a ilo lono tiap. ");
INSERT INTO apr_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Ngan nanga, ang nga lapau kakaratang dook, lo ngan bet kanepe, yesoo Tool Moolmool ke Maro ole isi ipatakrai ang ye lal atu yo ang nga lomu tar bet o isi ye tiap i.” ");
INSERT INTO apr_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Motong la Yesu ikatte betanga san mulu pang di nen, “Tool mai yo bet ipa ye panga mooloo, in ole itara tool balai bet matan kala so ki, inbe ikap kaningi pang di kapraingi ki kapala ye lal tani yo itaru panga i? Ye in ole ikamata di kapraingi ki tina ngan atu yo lon galanga ye urata inbe itoo betanga ki dook mata i, in la bet itaru i. ");
INSERT INTO apr_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Le kumata bet kapraingi tani in iyei urata dook mata nen leu, le bet tool mai ki imulu a iman pombe le ikamata urata tina yo iyei nga, ngan kapraingi tani in ke bet lon ponana. ");
INSERT INTO apr_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Awete pang moolmool nen, tool mai ki ole itaru le iyei kuto mai a bet matan kala so ki nga le imot. ");
INSERT INTO apr_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Bong kumata bet kapraingi tani in tool dook tiap nga, ngan ole lon kaua urata nen, ‘Tool mai kiau ni ila manga mooloo mukot san le ke bet imulu tarrai tiap.’ ");
INSERT INTO apr_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Le taun imadit tina ngan le irau sorok di kapraingi kapala, inbe ila ye di tooltool ke yinungu ran medana, a iye di tikan be tiyin. ");
INSERT INTO apr_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Bong ole tool mai ki imulu a iman ipatakraii ye ke atu yo kapraingi ki tani in lon tar bet o iman ye tiap i, inbe ye ke matana yo lon galanga ye tiap i. ");
INSERT INTO apr_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Le kumata bet tool mai ki tani in iman ikamata yo iyei nen nga, ngan ole isaputputu le morrana, lo ngan bet itaru lo ye di tooltool ke kaplungunu yo tinepe ye malala dook tiap nga, a lo iye di timassingi a titangtang, inbe tikanen dongadi a iparrasa.” ");
INSERT INTO apr_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Ye kene tani in Yesu iwete pang di a imot, motong la ikatte betanga san mulu pang di nen, “Lal yo bet Tool Moolmool ke Maro isi bet si matan kala di tooltool ke Maro ye i, in ole dawa ben di garup nene sangaul atu yo tikap sul kidi a tila pang ye tamoto yo lal ki bet ikere i. ");
INSERT INTO apr_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Di garup tina ngan di diedi limi ngan taukadi lo galanga, e di diedi kapala yo limi ngan la lodi galanga nga. ");
INSERT INTO apr_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Nen le di limi tina yo taukadi lo galanga nga, ngan tikap sul kidi, bong tila ngan tikap toko ran ke sul pitiap. ");
INSERT INTO apr_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Bong di limi yo lodi galanga nga, ngan tikap sul kidi, inbe tipaling ran pang sul kidi ye dap maimai tiap a tikap lapau. ");
INSERT INTO apr_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Le di garup sangaul tina la tinama tamoto yo bet ikere i, bong iman tarrai tiap le nga matadi ge a tiken mata. ");
INSERT INTO apr_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Tiken, tiken le lo bong kataunu, inbe tilongo tool atu koonoo le mai nen, ‘Ai, tamoto tani yo bet ikere paunu in ye la pombe i, a kamadit a kasi si kakamata.’ ");
INSERT INTO apr_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","“Motong la di garup tina sangaul ngan timadit palbe leu a tikarata sul kidi. ");
INSERT INTO apr_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Ngan di garup yo taukadi lo galanga nga, ngan tiwete pang di diedi yo lodi galanga ngan nen, ‘Ai, kakap ran kiang kasin pam, yesoo sul kiam mooloo tiap nga bet timmata.’ ");
INSERT INTO apr_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","“Bong tiraua betanga kidi nen, ‘Ona, o amkap pang tiap, yesoo ran nga mai ke bet ige yidi a kasin pam inbe pang, ngan tiap. Le dook mata nen, ole kala ye ni yo tiyawar ran ye i, a bet nen ngan la ang tapmu kayimi kamu pa.’ ");
INSERT INTO apr_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","“Bong ye kene yo tipa dada liwoonoo a bet la tiyimi ran ye in nga, ngan tamoto tani yo bet ikere, in pombe. Ngan nen le di garup limi yo tipare dook a tinamu nga, ngan timadit a tiye tamoto tani tilo pang rumu lono a titiukala dada le imede, inbe tikana mailang ke kerenge tani. ");
INSERT INTO apr_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Motong la di garup nene limi tina yo la tiyimi ran nga, ngan di lapau timulu a timan man tiwete nen, ‘Tool mai, tool mai, kuso dada pam!’ ");
INSERT INTO apr_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","“Bong tool tani in iraua betanga kidi nen, ‘Awete pang moolmool nen, au i lok galanga yang pitiap yege.’” ");
INSERT INTO apr_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Yesu iwete pang di nen a imot, motong la iwete pang di mulu nen, “Ngan nanga, ang tapmu ken kakauwai yang dook leu, yesoo ang nga lomu galanga ye lal le ke matana yo bet Tool Mai kiang pombe ye i, in tiap.” ");
INSERT INTO apr_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Motong la Yesu ikatte betanga san mulu pang di nen, “Dada yo Maro bet matan kala di tooltool ki ye i, in dawa ben tool atu yo lono bet ipa a idu ye ni manga mooloo san i. Ngan bet ipa nen nga, le nga ikiu di kapraingi ki a timan ye, motong la itar balingi ki kapala la bedi a bet nen ngan tikaua urata ye a matadi kala. ");
INSERT INTO apr_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Ngan tool tani in ikamata di kapraingi ki ye lo galanga le gurana kidi, inbe imalimi di atu atu ye pat. Nen le kapraingi ki atu in ikap pat gol limi panga, inbe san in ikap pat gol ru panga, inbe san in ikaua pat gol atu panga. Motong la imadit a ipa pang ye malala yo iken ni mooloo san i, a du inepe nango. ");
INSERT INTO apr_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Ngan kapraingi ki yo ikap pat gol limi i, in imadit palbe leu a ila iyei urata ye pat tina, ngan le ikap pat gol limi mulu. ");
INSERT INTO apr_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Inbe kapraingi ki san yo ikap pat gol ru i, in nen lapau, imadit a ila iyei urata ye pat tina, ngan le ikap pat gol ru mulu. ");
INSERT INTO apr_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Bong kapraingi ki yo ikaua pat gol atu i, in ila le la itaia tana a ikelmaia pat ke tool mai ki tani a itarkoo sila iken. ");
INSERT INTO apr_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Tinepe, tinepe le mos kaiye, motong la tool mai kidi kapraingi tina, in imulu a ilong pombe. Motong la iwete pang di kapraingi ki tina bet man tigaua a bet ipalongo di ye pat yo ikap pang di nga tiyeie soo urata ye. ");
INSERT INTO apr_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Ngan tool yo ikap pat gol limi i, in ikap le ipa ye pat gol limi mulu yo ikap nga, a iman iyei ne, ‘Tool mai, mugu ngan kop pat gol limi pau, bong kumata, dookoot nga ayei urata ye pat kiong tina le akap pat gol limi mulu.’ ");
INSERT INTO apr_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","“Motong la tool mai ki iwete panga nen, ‘Dook mata! Ong i kapraingi dook mata le kuyei urata dook mata ye pat yo akap pong nga! Mugu ngan atarong bet matam kala urata mai tiap, ngan matam kala dook mata san. Le dookoot nga ole atarong a kuyei mai pang so alunu a bet matam kala. Kuman a man aru tanepe, inbe lod ponana.’ ");
INSERT INTO apr_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Motong la tool san yo ikap pat gol ru i, in ye lapau iman ye tool mai tani man iwete panga nen, ‘Tool mai, mugu ngan kop pat gol ru pau, bong kumata, dookoot nga ayei urata ye pat kiong tina le akap pat gol ru mulu.’ ");
INSERT INTO apr_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","“Tool tani iwete nen, le nga tool mai ki iyei ne, ‘Dook mata! Ong i kapraingi dook mata le kuyei urata dook mata ye pat yo akap pong nga! Mugu ngan atarong bet matam kala urata mai tiap, ngan matam kala dook mata san. Le dookoot nga ole atarong a kuyei mai pang so alunu a bet matam kala. Kuman a man aru tanepe, inbe lod ponana.’ ");
INSERT INTO apr_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Motong la tool san yo ikaua pat gol atu i, in ye lapau iman ye tool mai tani man iwete panga nen, ‘Tool mai, au i lok galanga yong. Ong i tool malmalini, le kanakana nga bet di tooltool tipe kaningi kidi lo kumu lono nga, ngan ole kugamagama a kop pong ong taum leu. Inbe ye tana kapala yo di tooltool tipe so puana kidi ye nga, ngan ole kop kanono ngan pong lapau. ");
INSERT INTO apr_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Ngan nen le au i atattadai ong, le pat kiong gol atu yo kuwi pau i, in ala ataia tana a akelmaii ye. Le kumata, i pat kiong tani naii.’ ");
INSERT INTO apr_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“Motong la tool mai ki tani in iwete panga nen, ‘Ong i kapraingi dook tiap, inbe ong i tool ke tini booroomoo. Nga gelei, ong i lom galanga yau bet kanakana ngan agamagama kaningi kidi tooltool yo tipe du kumu lono nga, inbe ole akap sorok kaningi kidi tooltool yo tipe ye tana kapala ngan lapau, too? ");
INSERT INTO apr_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Le nga gelei a lom bet kutara pat kiau i ilo ye rumu ke tarungu pat tiap nga? Nga yo bet kuyei nen nga, ngan matin nga ye kene yo bet amulu a along ye in nga, ngan akaua pat kiau tani, inbe tipaloko kasin mulu lo pono lapau.’ ");
INSERT INTO apr_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","“Le nga tool mai tani in iwete pang di tooltool ki kapala nen, ‘Ai, kakaua pat gol atu yo iken ye tool in, a la kakauu pang tool yo pat gol ki sangaul i. ");
INSERT INTO apr_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Yesoo, di sima tooltool yo tiyei urata dook mata ye so yo tikap nga, ngan ole akap so mulu pang di, le so kidi alunu kaiye. Bong di sima tooltool yo tiyei urata ye so kasin leu yo tikap ngan tiap nga, ngan ole akap so tina kasin leu, ngan ye di. ");
INSERT INTO apr_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Le kapraingi dook tiap, in kakauu a kakatte du diki ye ni todo lono ni. Ngan ye ni tani, ole timassingi a titangtang, inbe tikanen dongadi a iparrasa.’” ");
INSERT INTO apr_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Yesu iwete pang di galiunu nen a imot, motong la iwete pang di mulu nen, “Ye lal yo Tool Moolmool ke Maro bet ole imulu a isi ye in nga, ngan ole iye di bangabangana ki le imot tisi, a bet si ipitnaia lulngana yo maiyoko i. Inbe ole iwur ye kakawa ke tool yo iyei kuto mai pang di tooltool le imot i, a bet nen ngan ikarata betanga kidi tooltool. ");
INSERT INTO apr_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Lo ngan bet di tooltool ke ni mai i le imot, ole timan tigaua ke dama ki, inbe ipoto di le tinepe ye budanga ru. Ole iyei dawa ben tool yo matan kala di asara i, in ipoto di asara yo edi sipsip nga le tinepe kandot ye di asara yo edi meme nga. ");
INSERT INTO apr_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Ngan tool tani ole itar di sipsip le tinepe ye arono oonoo, inbe di meme ngan tinepe ye arono ngas. ");
INSERT INTO apr_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","“Le ye dada gaongo leu, tool mai tani yo iyei kuto mai pang di tooltool i, in ipoto di tooltool a imot, lo ngan bet iwete pang di tooltool yo tinepe ye arono oonoo ngan nen, ‘Ang nga, Tamak iyei urata dook mata pang, le lomu ponana a kaman. Ang nga, kulkulunu yege ye kene yo Maro itar lang le tana ye in tiao nga, ngan ikarata ni pang ang di tooltool ki yo bet kagaua a matan kalang nga, ngan oo. Le kaman man kanepe ye malala tani i, inbe kakap so dook mata yo bet Maro ole ikap pang nga. ");
INSERT INTO apr_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Yesoo ang nga ye kene yo pitolau ye in nga, ngan kakap kaningi pau a akan. Inbe ye kene yo morakau ye in nga, ngan kakap ran pau a ayin. Inbe ye kene yo apa ngan taukak ni yo bet anepe ye in nga, ngan kakau au a katarau ye rumu kiang. ");
INSERT INTO apr_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Inbe kene yo au i taukak so ke lonloningi ye in nga, ngan ang nga kakap so ke lonloningi pau. Inbe kene yo matamatenge mai ikau au ye in nga, ngan ang nga matamu kalau dook mata. Inbe kene yo titarau lo rumu dook tiap kidi talnga dikidiki lono ye in nga, ngan ang nga kapa man kakamatau lapau.’ ");
INSERT INTO apr_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Lo ngan bet di tooltool tina yo noonoodi nga, ngan ole tiraua betanga ki a titoru nen, ‘Tool Mai, kuwete pam ngan. Ye soo lal amkamatong ngan pitolong, a le amkap kaningi pong a kon ye i, too amkamatong ngan morakong, a le amkap ran pong a kuyin ye i? ");
INSERT INTO apr_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Too, ye soo lal kupa ngan taukam ni yo bet kunepe ye i, a le amkamatong ngan amkau ong a kulo rumu kiam, too ye soo lal taukam so ke lonloningi, a le amkap so ke lonloningi pong ye i? ");
INSERT INTO apr_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Inbe ye soo lal amkamatong ngan matamatenge mai ikau ong, too titarong lo rumu dook tiap kidi talnga dikidiki lono a le ampa mala amkamatong ye i?’ ");
INSERT INTO apr_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","“Motong la Tool Mai yo iyei kuto mai pang di in ole iwete pang di nen, ‘Awete pang moolmool nen, soo so bet kayeii pang tool kiau atu i, in so tani in ben kayeii pau. Nen le kumata bet kayeie dada dook mata pang tool kiau atu yo taukan ene in nga, ngan gaongo leu, so tani in ben kayeii pau.’ ");
INSERT INTO apr_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Lo ngan bet iportak a iwete pang di tooltool yo tinepe ke arono ngas ngan nen. ‘Ang nga, Maro igarungang ye betanga le ang nga ole kallemu. Kakoo yau! Kakoo le kalo ye ei yo ikan nen le taukan motingi i, in lono. Ngan ei ni Maro la ikarata pang tool kuto mai kidi so sidi iye di bangabangana ki i. ");
INSERT INTO apr_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Awete pang nen nga, yesoo ye kene yo pitolau ye in nga, ngan le mala bet kakap toko kak kaningi pa bet akan, ngan tiap. Inbe au i morakau nga, ngan le mala bet kakap toko kak ran pa bet ayin, ngan tiap. ");
INSERT INTO apr_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Inbe ye kene yo apa ngan au i taukak ni yo bet anepe ye in nga, ngan le mala bet kakau au a katarau lo rumu kiang, ngan tiap. Inbe au i taukak so ke lonloningi nga, ngan le mala bet kakap toko kak so ke lonloningi siap. Inbe ye kene yo matamatenge mai ikau au, inbe titarau lo rumu dook tiap kidi talnga dikidiki lono ngan lapau, ang nga le lomu bet kapa man kapakelau a matamu kalau, ngan tiap.’ ");
INSERT INTO apr_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Lo ngan bet di tooltool tina ole titoru nen, ‘Tool Mai, kuwete pam ngan. Ye soo lal amkamatong ngan pitolong, too morakong, too kupa ngan ong in taukam ni yo bet kunepe ye i, too taukam so ke lonloningi, too matamatenge mai kau ong, too titarong kulo rumu dook tiap lono, ngan le am nga amlonong ye tiap i?’ ");
INSERT INTO apr_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","“Ngan Tool Mai tani in ole iraua betanga kidi nen, ‘Awete pang moolmool nen. Soo so bet kayeii pang tool kiau nga atu tiap i, in so tani in ben kayeii pau tiap lapau. Nen le kumata bet kayeie dada dook mata sa pang tool kiau atu yo taukan ene, in tiap lapau nga, ngan gaongo leu, so tani in ben kayeii pau tiap lapau.’” ");
INSERT INTO apr_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Motong la Yesu iwete pang di nen, “Ngan nanga, di tooltool tina yo dook tiap nga, ngan ole Maro inganga di a tilo ei lono a lo tisolo masngana yo iken nen le taukan motingi i. Bong di tooltool yo noonoodi nga, ngan ole lo tikaua nepongo dook mata yo taukan motingi i.” ");
INSERT INTO apr_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Ye kene tani in Yesu iwetewete ye so tina ngan a imot, motong la iwete pang di galiunu nen, ");
INSERT INTO apr_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Ang nga lomu galanga nen, ke ru leu la iken pang dama go nga, bet ole talo ye lal maiyoko kidi Yuda yo tiweta ye Paskimoolooningi Ke Maro i. Ye lal tani in ngan ole titara Tool Moolmool ke Maro la di koi ki bedi, a nen ngan tipatota lo kai palasingi kaini a imata.” ");
INSERT INTO apr_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Iwete nen a imot, motong la di tooltool maimai ke paroranga so pang Maro, inbe di tooltool maimai ke di Isrel, tilo tigaua ye rumu mai ke tool kuto mai ke paroranga so yo ene Kepas i. ");
INSERT INTO apr_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Di ngan tigaua a tiwetewete, inbe tisere dada sa yo bet tillung pang Yesu ye, a bet nen ngan tikauu a tiraumate ye i. ");
INSERT INTO apr_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Bong di tapdi tiwetewete pang di nen, “O ke bet tayei dada nen panga ye lal maiyoko yo ke sungunu in tiap. Kumata bet tayei nen a di tooltool tikamatidi nga, ngan ole katedi malmal le taun tipamaditi patokongo.” ");
INSERT INTO apr_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Ye kene yo Yesu iye di galiunu tinepe malala Betani ye in nga, ngan tinepe ye rumu ke Simon, tool yo mugu ngan botoboto medana ikani i. ");
INSERT INTO apr_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Le nga Yesu iwurur ye kakawa ke kaningi so a ikanen so go, inbe garup atu in ikaua dap maitiap yo tikarata ye pat sallinene dook mata, inbe tipalingi ye so ke saliningi yo kini ki dook mata in a ise pang ye Yesu, motong la itioo lo kutono nga. Ngan so ke saliningi tani, in di tooltool tiyimoo ye pat mai san. ");
INSERT INTO apr_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Ngan di galiunu tikamata garup tani yo iyei nen nga, le lodi dook tiap. Le nga tiyei ne, “Ona tiap! Nga gelei a ingele ye so ke saliningi dook mata i a iti soroki nen nga? ");
INSERT INTO apr_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Nga yo bet tayawari nga, ngan matin nga le takap pat mai ye, lo ngan bet takap pat tina ngan pang di tooltool yo ballingadi tiap nga.” ");
INSERT INTO apr_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Di galiunu tiwete nen, bong ngan iraua betanga kidi nen, “Nga gelei a koomu kaua garup i nga? Dada yo iyeii pau i, in dook mata le dook mata san. ");
INSERT INTO apr_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Kapalongo, di tooltool yo ballingadi tiap nga, ngan kanakana ngan ole kaye di kanepe, bong au i o ke bet ayang tanepe ye ke yo kanakana, ngan tiap. ");
INSERT INTO apr_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Ngan nanga, garup i, so ke saliningi dook mata yo itioo ilo ye tinik i, in bet nen a ikarata bobok pang kene yo bet tikelmai au ye i. ");
INSERT INTO apr_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Awete pang moolmool nen, pang dama ni ye ni nangai bet di tooltool tipa bet tiwetewete bingi dook mata ke Maro pang di tooltool ye in nga, ngan ole tiwete urata dook mata yo garup i iyeii pau i, in lapau, a bet nen ngan di tooltool lodi tutu ye.” ");
INSERT INTO apr_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Yesu iwete nen a imot, motong la di galiunu tina yo sangaul be ru nga, ngan atu kidi yo ene Yuta Iskariot i, in ila pang ye di tooltool maimai ke paroranga so pang Maro. ");
INSERT INTO apr_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Motong la itor di nen, “Ai, kumata le bet atara Yesu la bemu nga, ngan ole soo so bet kakauu pau i?” Tina iwete nen nga, le di kuto maimai tina ngan tikap pat silba sangaul tol panga. ");
INSERT INTO apr_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Nen le ye kene tani in a ilo nga, ngan Yuta lon kaua urata a isere dada yo bet ikaua Yesu a itaru la di kuto maimai tina ngan bedi ye i. ");
INSERT INTO apr_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Tinepe a tilo ye ke yo imugu pang lal yo di Yuda bet tigaua a tikana porong yo taukan so bet iyeii a isung i, in pombe. Motong la di galiunu timan pang ye, a man titoru. Tiyei ne, “Ni nangai lom bet ole amkarata kaningi ke Paskimoolooningi ke Maro a bet takani ye i?” ");
INSERT INTO apr_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Motong la iwete pang di nen, “Kapa le kalo malala mai ni lono, a kala ye tool atu yo inepe i, inbe kawete panga nen. Kayei ne, ‘Pannoongoo kiam iwangam bet man amwete pong nen: Lal yo Maro ipootoo pau i, in iman potai oo. Le au i lok bet aye di galiuk amgaua a lomam ponana, inbe amkana kaningi ke Paskimoolooningi ke Maro in ye rumu lono kiong.’” ");
INSERT INTO apr_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Ngan le Yesu di galiunu tina tilo le lo tiyei so ben tina yo iwete pang di nga, a tikarata kaningi ke Paskimoolooningi ke Maro nango. ");
INSERT INTO apr_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Tinepe le ke idu a rrai, motong la Yesu iye di galiunu tina yo sangaul be ru nga, ngan lo tiwur ye kakawa ke kaningi so, inbe tikan so. ");
INSERT INTO apr_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Ye kene yo tikanen so ye in nga, ngan Yesu iwete pang di nen, “Awete pang moolmool nen, ang tina nga atu la bet itarau la di koi kiau bedi i.” ");
INSERT INTO apr_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Yesu iwete nen a di galiunu tina tilongo, le nga lodi moo mai san ye betanga ki, le nga di atu atu le imot timadit a titoru nen, “Tool Mai, au i la kuwete nen yau i, too tiap?” ");
INSERT INTO apr_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Motong la iraua torungu kidi nen, “Tool atu kiang yo amru amtoko porong inbe amsili du omai lono i, in ye la bet itarau la di koi kiau bedi i. ");
INSERT INTO apr_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Le Tool Moolmool ke Maro ole tiraumate a imata ben tina yo tiwodo betanga ki lo ye Rau ke Maro nga. Bong barau, tool yo bet itara Tool Moolmool ke Maro la di koi ki bedi i, in ole isolo masngana mai le mai ki taunu. Nga yo bet tinana ipasuiu tiap nga, ngan matin nga le dook mata.” ");
INSERT INTO apr_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Motong la Yuta, tool tani yo bet itara Yesu la di koi ki bedi i, in imadit tina le itoru. Iyei ne, “Pannoongoo, au i la kuwete nen yau i, too tiap?” Ngan Yesu iraua betanga ki nen, “E, dawa ben tina la kuwete koot nga.” ");
INSERT INTO apr_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Tikanen so go, inbe Yesu ikaua porong atu a iwete lo ponana ki pang Maro ye, motong la itepalapala a ikap pang di galiunu tina, inbe iwete pang di nen, “Bi, kakap a kakan. I au medak.” ");
INSERT INTO apr_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Motong la ikaua ruku yo ooroo wain surunu iken lono in a iwete lo ponana ki pang Maro ye, motong ikauu pang di galiunu tina, inbe iwete pang di nen, “Ang le imot kakauu a kayinu. ");
INSERT INTO apr_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","I au rara kiau yo bet apamede betanga medana pang ye i. Ngan la le apatioo bet nen a Maro ilon di tooltool alunu a igiri sennene kidi ye. ");
INSERT INTO apr_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Awete pang nen, au i o ke bet ayin ooroo wain surunu mulu tiap, le ilo ye lal yo Tamak Maro bet matan kala di tooltool ki ye i, ngan la bet ayang tagaua, inbe tayin nga.” ");
INSERT INTO apr_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Yesu iwete nen a imot, motong la iye di galiunu tiwouo woungu ke sungunu atu, inbe tipas a tidu tana a tilo pang kawal Olip. ");
INSERT INTO apr_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Motong la Yesu iwete pang di galiunu nen, “Bong katai ngan so yo bet pombe pang yau i, in ang nga ole kakamata le kagege lomu medana yo kataru pau i, inbe ang le imot kakoo yau. Awete pang nen, yesoo betanga yo tiwode lo ye Rau ke Maro in iwete nen, ‘Au i ole araumata tool yo matan kala di sipsip i, ngan ole di sipsip ki tina timayiriyiri a tikoo.’ ");
INSERT INTO apr_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Bong ole amadit mulu ye ni ke matenge, lo ngan bet amugu pang le la anamang la Galili ngo.” ");
INSERT INTO apr_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Yesu iwete pang di galiunu nen, motong la Pita iwete panga. Iyei ne, “Kumata le di galium kapala nga tikamata so yo pombe pang yong i, le di le imot bet tigege lodi medana yo titaru pong i, inbe tikoo yong nga, ngan au i o ke bet akoo yong pitiap yege.” ");
INSERT INTO apr_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Motong la Yesu iraua betanga ke Pita nen, “Awete pong moolmool nen, bong katai nga, ngan ole tareke itang tiao, inbe kupataukala a kuwete le patol bet ong i lom galanga yau tiap.” ");
INSERT INTO apr_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Bong Pita iyei ne, “O tiap! Kumata le lodi bet au i tiraumatau lapau a aru tammata nga, ngan o ke bet awete a apataukalong bet au i lok galanga yong tiap, ngan tiap.” Ngan iwete nen le Yesu di galiunu tina ngan di le imot tiwete betanga gaongo nen lapau. ");
INSERT INTO apr_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Motong la Yesu ikap di galiunu a tilo pang ye ni atu yo tiwete ene ye Getsemani i. Tilo pombe, motong iwete pang di nen, “Si kawur nanga, inbe au ole ala ni la apatarau pang Maro ngan.” ");
INSERT INTO apr_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Ngan le ikaua Pita iye Sebedi di natunu ru nga, a iye di tila. Bong Yesu ikanamaii, ngan lon madoko le lon moo san. ");
INSERT INTO apr_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Le nga iwete pang di galiunu tol tina nen, “Au i lok moo mai san le ayetai ben nga bet amata. Le kanepe nanga, inbe matamu rere a kanat.” ");
INSERT INTO apr_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Iwete pang di nen a ila manga mooloo kasin, motong la igun turunu le du damon toko tana, inbe ipatarau. Iyei ne, “Tamak, kumata le bet dada sa dook mata iken nga, ngan lom pau a kukutaka ruku ke masngana i yau. Bong ken kutoo au lok be, kutoo ong taum lom leu.” ");
INSERT INTO apr_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Motong la imulu a iman pang ye di galiunu tol tina, ngan ikamata di tiken mata oo. Le nga itoro Pita nen, “Nga gelei, ang tol nga ke bet matamu rere a ayang tanat dook a tanepe ye manga kasin nga tiap, too? ");
INSERT INTO apr_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Matamu rere a kanat dook inbe kapatarau, a nen ngan touanga sa bet pombe pang yang nga, ngan o ke bet kamol tiap. Moolmool, lomu ngan bet kayei urata yo nen nga, bong tinimu ngan taukan gurana.” ");
INSERT INTO apr_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Motong la igege di a ila pattu mulu le paru ki la ipatarau nen, “O Tamak, kumata le dada dook mata sa bet kukutaka ruku ke masngana in yau tiap a bet ayinu nga, ngan dook mata. Bong kutoo ong taum lom leu.” ");
INSERT INTO apr_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Yesu ipatarau a imot a bet imulu a iman pang ye di galiunu tol tina, ngan ikamata di tikenen mata oo, yesoo matadi ge mai mata. ");
INSERT INTO apr_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Le nga igege di sila tinepe, inbe imulu a ila pattu mulu le patol ki bet la ipatarau. Ngan le ipatarau gaongo leu ben tina yo la ipatarau mugu nga. ");
INSERT INTO apr_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Motong la imulu a iman pang ye di galiunu tol tina man iwete pang di nen, “Ai, nga kamaryoo a kakenen mata go, too? Kakamata, lal yo tool atu bet itara Tool Moolmool ke Maro la di tooltool ke sennene bedi ye i, in potai oo. ");
INSERT INTO apr_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Le kamadit a tala! Tool tani yo bet itarau la di koi kiau bedi i, in ye la iman i.” ");
INSERT INTO apr_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Ye kene tani in Yesu iwetewete nen go, inbe di galiunu tina sangaul be ru ngan atu kidi yo ene Yuta i, in iman pombe. Iman ngan iye di tooltool budanga mai yo tikap pul le kai ke patokongo ngan la iye di timan nga. Di tooltool tina, ngan di tooltool maimai ke paroranga so pang Maro inbe di tooltool maimai kidi Yuda la tiwanga di a timan nga. ");
INSERT INTO apr_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Ngan Yuta tani ikarata betanga pang di tooltool tina ngan mugu nen, bet ole iyeie so sa pang Yesu a iyei ben tarkilanga pang di. Ngan iwete nen, “Kakamata tool atu bet awarra a asomo pangana i, in tool tani nain, a kakauu a kaparama le imede.” ");
INSERT INTO apr_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Tina nen nga, le pattu leu inbe Yuta ipa pobe pang ye Yesu a ila le la iyei ne, “O bong dook mata, Pannoongoo!” Inbe iwarra a isomo pangana. ");
INSERT INTO apr_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Motong la Yesu iwete panga nen, “Tool kiau, so yo kuman bet man kuyeii i, in nen bet kuyei tarraii.” Motong la di tooltool tina tipa pobe la titokolana Yesu a tiparama. ");
INSERT INTO apr_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Ngan nen le di tooltool tina yo tiye tinepe nga, ngan atu in iposo pul ki ke patokongo a itarakede kapraingi ke tool kuto mai ke paroranga so pang Maro, in talngana, le imakede. ");
INSERT INTO apr_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Bong Yesu iwete pang tool tani nen, “Ai, kupariri pul kiong in a ilo ye nene mulu. Awete pong, di tooltool yo tikap pul ke patokongo a tipatoko ye nga, ngan ole pul tina ngan igarung di a timmata. ");
INSERT INTO apr_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Nga gelei, ong i o lom galanga tiap, too? Kumata le kook pang Tamak bet ilonau nga, ngan ole pattu leu be iyawar di bangabangana ki alunu kaiye le kinkatingi kidi illos di budanga sangaul be ru ngan a tisi tilonau. ");
INSERT INTO apr_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Bong kumata bet ayei nen nga, ngan betanga yo di Maro koonoo tiwodo lo ye Rau ke Maro nga, ngan ole kanono pombe moolmool tiap. Yesoo, betanga ke Maro tina ngan iwete bet so nen nga, ngan ole pombe pang yau.” ");
INSERT INTO apr_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Ye kene tani in Yesu iwete pang di tooltool budanga mai tina ngan nen, “Ai, au i tool dook tiap ke patokongo le pinnau, la kakap pul le kai ke patokongo a kaman bet man kaparamau nga, too? Nga gelei, a kanakana ngan kakamatau awurur koongoo lono ke bareme mai ke sungunu a apatomonai di tooltool, ngan lomu bet kakau au a kaparamau ye ni tani in tiap nga? ");
INSERT INTO apr_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Bong dookoot, dada nen ngan le imot bet pombe yau, a bet nen ngan iyeie betanga yo mugu ngan di Maro koonoo tiwode lo ye Rau ke Maro i, in le kanono pombe moolmool.” Yesu iwete nen, motong la di galiunu le imot tigege sila inepe, inbe tikoo belebele a tila. ");
INSERT INTO apr_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Di tooltool yo tikaua Yesu a tiparama nga, ngan tikauu a ilo ye rumu ke tool kuto mai ke paroranga so pang Maro yo ene Kepas i. Ngan rumu tani, in di pannoongoo ke wer ke Maro inbe di tooltool maimai kidi Yuda, ngan tilo tigaua lono mugu a tinepe oo. ");
INSERT INTO apr_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Ngan Pita lapau itoo Yesu a ilo, bong le ben ipa manga mooloo kasin ye. Itoo a ipa so le ilo koongoo lono ke rumu ke tool kuto mai ke paroranga so tani, motong la ipa le la iye di gaunu yo bet matadi kala rumu ngan tiwur, ngan lono bet inepe a bet ikamata so yo bet pombe pang ye Yesu i. ");
INSERT INTO apr_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Motong la di tooltool maimai ke paroranga so pang Maro, inbe di kuto maimai kapala yo matadi kala momo le nepongo kidi Yuda nga, ngan tikapge bet tisere tool yo ke bet man illung a isopo koonoo ye betanga pang Yesu ye urata ki yo iyei nga, a bet nen ngan tiraumate le imata. ");
INSERT INTO apr_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Bong di tooltool alunu yo timan tillung a tisopo koodi ye betanga pang Yesu nga, ngan betanga kidi sa yo bet kanono, ngan tiap. Tiyei nen nen le taun di tooltool ru tilo dama tina ngan le tiwete nen. ");
INSERT INTO apr_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Tiyei ne, “Tool i mugu ngan iwete nen, ‘Au i ke bet asaua bareme mai ke sungunu yo ke Maro i, lo ngan bet apatokode mulu ye ke tol leu.’” ");
INSERT INTO apr_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Motong la tool kuto mai ke paroranga so in imadit lo ikodo, inbe itoro Yesu. Iyei ne, “Ai, nga gelei a lom bet kurau betanga kidi tiap nga? Nga ole kuwete balai ye betanga yo di tooltool tina nga tiweta yong i?” ");
INSERT INTO apr_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Iwete nen, bong ngan Yesu mala bet iwete toko betanga siap, ipas le ipalongo leu. Motong la tool kuto mai tani in iwete panga mulu nen, “Dookoot nga lok bet kuwete betanga moolmool ki taunu pam ye Maro yo inepe nen le taukan matenge, in matana. Oo kuwete, ong i Kirisi yo Maro Natunu i, too?” ");
INSERT INTO apr_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Ngan Yesu iyei ne, “E, dawa ben tina la kuwete koot nga. Bong lok bet awete betanga i pang ang nga le imot nen. Pang dama ni nga, ngan ole kakamata Tool Moolmool ke Maro iwur ye Maro yo gurana ki mai mata i, in bene oonoo, inbe ipa ye eng tene a isi pang tana.” ");
INSERT INTO apr_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Iwete nen, le tool kuto mai ke paroranga so pang Maro in katen malmal a isarraka sousoungu mooloo ki, inbe iyei ne, “Tool i nga iwete nen, ye i ole ikaua malala ke Maro, le nga bet tasere di tooltool sa mulu bet man tipapos urata ki yo iyei, ngan paidi pang soo? Kakamata, dookoot nga ang tapmu kalongo yo iwete bet ye i ole ikaua malala ke Maro, ngan oo. ");
INSERT INTO apr_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Le nga lomu bet ole tayeie soo so pang tool i?” Ngan di tooltool tina ngan di le imot tiyei ne, “Iyei urata dook tiap, le nga dook mata bet taraumate a imata.” ");
INSERT INTO apr_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Motong la di tooltool tina ngan tikorokoronaia matana, inbe tilok bedi a titutu, inbe kapala ngan tipodo pangana, ");
INSERT INTO apr_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","inbe tiyei ne, “Oo Kirisi, kuwete bet ong i Maro koonoo moolmool nga, ngan kuwete too. I sei irau ong i?” ");
INSERT INTO apr_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Ye kene tani in Pita iwurur damadama ke rumu tani in ke koongoo lono, inbe garup kase atu yo iyei kapraingi i, in ipa a iman ye. Motong la iwete panga nen, “Ai, ong i kuye Yesu ke Galili i, in kanepe lapau.” ");
INSERT INTO apr_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Bong ngan Pita ipataukala a iwete la di tooltool tina ngan le imot matadi nen, “Au i lok galanga ye betanga yo kuweta i, in tiap yege.” ");
INSERT INTO apr_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Motong la Pita imadit a ipa le la ikodo ye dada ke koongoo, ngan garup kase san yo iyei kapraingi i, in ikamata. Le nga iwete pang di tooltool yo tinepe potai ye nga. Iyei ne, “Tool ni akamata iye Yesu ke Nasaret i, in tinepe lapau.” ");
INSERT INTO apr_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Bong ngan Pita koon mede le ipataukala a iwete mulu nen, “Awete pang moolmool le ete, au i lok galanga ye tool ni pitiap yege!” ");
INSERT INTO apr_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Tinepe le mooloo mata tiap, inbe di tooltool yo tikododo potai ye Pita nga, ngan timan pang ye man tiwete panga. Tiyei ne, “Ai, ngan moolmool sa! Ong i tool kidi atu, yesoo ye kanga ke betanga kiong i la ipaposong a le amkilalong ye i.” ");
INSERT INTO apr_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Tina yo ngan le Pita iwete nen, “Kumata le bet allung nga, ngan dook mata nen bet Maro igarungau. Le awete pang moolmool le ete nen, tool ni au i lok galanga ye pitiap yege!” Ngan iwete nen le pattu leu inbe tareke itang. ");
INSERT INTO apr_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Motong la se Pita lon tutu betanga yo Yesu iweta panga i. Ngan mugu ngan Yesu iwete panga nen, “Ole tareke itang tiao, inbe ole kupataukala a kuwete le patol bet ong i lom galanga yau tiap.” Ngan nen le Pita lon madoko a ikoo a idu ke diki du itang belebele. ");
INSERT INTO apr_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Ye bong tani in tinepe le du muntu yege, inbe di tooltool maimai ke paroranga so inbe di tooltool maimai kidi Yuda tigaua a tiraua betanga bet tiraumata Yesu a imata. ");
INSERT INTO apr_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Le nga tipauu ye ooroo medana, inbe tikauu a lo titaru la Pailot bene. Ngan Pailot tani in tool kuto mai ke Rom yo matan kala di tooltool le imot ke tana mai Yudia i. ");
INSERT INTO apr_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Ye kene tani in Yuta, tool tani yo itara Yesu la di koi ki bedi i, in yeiso bet ikamata di tooltool kuto maimai tina ngan tipamede betanga bet ole tiraumate a imata nga, ngan le lon sakarungu ye urata dook tiap yo iyeii panga i. Le nga ikap pat silba sangaul tol tina yo tikap panga nga, ngan bet la ipamulu pang di tooltool maimai ke paroranga so tiye di tooltool kuto maimai kidi Yuda. ");
INSERT INTO apr_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Inbe iwete pang di nen, “Atoo, au i ayeie sennene mai san, yesoo tool yo ataru la bemu a bet karaumate i, in taukan busunu.” Bong ngan di kuto maimai tina tiwete panga nen, “In am so kiam tiap. In ong so kiong bet sila lom madoko ye.” ");
INSERT INTO apr_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Ngan nen le Yuta ikatte pat silba tina ngan sila ikino bareme mai ke sungunu lono, inbe ikoo a ila le la ye taunu ikono le imata. ");
INSERT INTO apr_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Motong la di tooltool maimai tina ke paroranga so pang Maro nga, ngan tikap pat silba tina, inbe tiyei ne, “Pat nga tayimi urata kootoonoo ki ye bet taraumata tool i. Le ye wer kiidi ngan nen, pat yo nen nga ke bet tatar lo ye depe yo ke bareme ke sungunu, in tiap.” ");
INSERT INTO apr_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Le nga tigaua lodi bet pat tina ngan tiyimi tana kasin kidi tooltool ke karatanga bor le so kapala ye tana, ngan pa. A bet nen ngan di tooltool ke malala san yo man tiye di tinepe ngan bet timmata nga, ngan tikelmai di ye. ");
INSERT INTO apr_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Ye punu in la le tana tani yo tiyimoo i, ngan mukot le se dookoot nga, ngan tiwete ene ye Tana Ke Rara nga. ");
INSERT INTO apr_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Tina tiyei nen nga, le tiyeie betanga ke Maro koonoo Yedimia yo iweta i, in le kanono pombe moolmool. Ngan iwete nen, “Ole tikap pat silba sangaul tol yo di Isrel tiraua betanga bet iyei ben pat ke yimoongoo tool tani ye nga, ");
INSERT INTO apr_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","inbe la tiyimi tana kidi tooltool ke karatanga bor ye. Inbe so tani yo tiyeii nen i, in itoo betanga yo Tool Mai iwete pau nga.” ");
INSERT INTO apr_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Tikaua Yesu lo tipatokode a ikodo dama ke tool kuto mai kidi Yuda, motong la itoru. Iyei ne, “Oo kuwete, ong i la tool kuto mai yo matam kala di Yuda le imot i, too?” Ngan Yesu iyei ne, “E, dawa ben tina la kuwete koot nga.” ");
INSERT INTO apr_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Motong la di tooltool maimai ke paroranga so pang Maro, inbe di tooltool maimai kidi Yuda, ngan tisopo koodi ye betanga alunu pang Yesu, bong mala bet iwete toko betanga sa a bet irau betanga kidi ye, ngan tiap, sila ipas le ipalongo leu. ");
INSERT INTO apr_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Le nga Pailot itoru nen, “Ai, ong i kulongo betanga alunu yo di kuto maimai tiwetewete yong, ngan lapau?” ");
INSERT INTO apr_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Bong ngan Yesu mala bet iwete toko kan betanga sa a bet iraua betanga ki ye, ngan tiap, sila ipas le ipalongo leu. Ngan nen le Pailot itakrai belebele ye yo ye taunu ikata suanga ye tiap nga. ");
INSERT INTO apr_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Ye momo ke tool kuto mai ke Rom tani, in nen. Ye rai kanakana nga, ngan kumata bet lo tigoro lal kidi Yuda ke bet tikanen inbe lodi tut ye Paskimoolooningi Ke Maro nga, ngan di tooltool yo tinepe rumu dook tiap kidi talnga dikidiki lono nga, ngan ole ipadu atu a idu tana. Bong ole di tooltool le imot tipootoo tool yo lodi bet ipadua a isi diki in ene. ");
INSERT INTO apr_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Ye kene tani in tool dook tiap atu yo ene Barabas i, in inepe rumu dook tiap kidi talnga dikidiki lono. Ye in di tooltool nga le imot ngan lodi galanga ye. ");
INSERT INTO apr_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Ngan nen le nga di tooltool le imot man tigaua, motong la Pailot itor di nen, “Oo, sei lomu bet apadua isi tana i; Barabas, too Yesu yo tiweta ye Kirisi i?” ");
INSERT INTO apr_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Pailot itor di nen, yesoo lon galanga ye di tooltool kuto maimai kidi Yuda tina ngan lodi dook tiap pang Yesu, yesoo tikamata ben di tooltool tiyitmaka ene, ngan la le titaru la bene nga. ");
INSERT INTO apr_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Le nga Pailot tani in iwurur ye kakawa ke karatanga betanga go, inbe rimana iwanga ye betanga naii panga. Iyei ne, “Ai, ken kuyeie so sa pang tool yo taukan busunu i, in be. Yesoo, bong ngan akamata ye mianga le dookoot nga lok massingi ye mai san.” ");
INSERT INTO apr_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Bong di tooltool maimai ke paroranga so pang Maro, inbe di tooltool maimai kidi Yuda, ngan tiso di tooltool le imot lodi bet koodi pang Pailot a nen ngan ipadu Barabas a isi tana, e bet tiraumata Yesu a imata. ");
INSERT INTO apr_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Motong la Pailot itor di tooltool tina mulu. Iyei ne, “Ai, di tooltool ru tina nga, sei tool lomu bet apadua a isila tana yang i?” Ngan di le imot tikata bet koodi le mai nen, “Barabas!” ");
INSERT INTO apr_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Motong la Pailot itor di mulu. Iyei ne, “Lomu balai ye Yesu yo tiweta ye Kirisi i? Ole ayeie soo panga?” Ngan di le imot tikata bet koodi le mai nen, “Kupatota lo kai palasingi kaini a imata!” ");
INSERT INTO apr_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Le nga Pailot itor di nen, “Nga gelei? Soo dada dook tiap ikapsap ye i?” Bong di tooltool tina ngan oorootang a koodi le mai mulu nen, “Kupatota lo kai palasingi kaini a imata!” ");
INSERT INTO apr_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Le Pailot lon galanga nen, kumata bet iwete nga, ngan o ke bet tilongo betanga ki tiap. Inbe ikamata di ngan bet tipamaditi patokongo. Le nga ikap ran a ingas bene la di tooltool tina ngan le imot matadi, inbe iwete pang di nen, “Kumata bet tool i imata nga, ngan au i taukak busunu. Le urata yo bet kayeii ye i, in so kiang.” ");
INSERT INTO apr_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Motong la di tooltool tina tiwete panga nen, “Ngan dook mata, dada dook tiap sa bet amyeii panga le imata nga, ngan ole urata moonoo ke matenge ki in isolo yam inbe ye di natumam nen lapau.” ");
INSERT INTO apr_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Motong la Pailot ipadu Barabas a idu pang ye di. Bong iwete a di tooltool ke patokongo tisaliti Yesu ye ooroo medana, motong la ikauu a itaru la bedi a tikauu bet du tipatota lo kai palasingi kaini nga. ");
INSERT INTO apr_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Motong la di tooltool ke patokongo tina ngan tikaua Yesu a tilo rumu lono ke tool kuto mai tani, inbe tikiu di diedi kapala ke patokongo nga le imot a timan tigaua ye Yesu. ");
INSERT INTO apr_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Motong la tidudu sousoungu ki du tana, inbe tisousouu ye mala kooroonoo atu. ");
INSERT INTO apr_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Inbe tikaua ooroo yo dongana iso in a titali, motong la titaru lo Yesu kutono. Inbe tikaua toto kidi tooltool kuto maimai panga a titaru lo bene oonoo, motong la tigun turudi du dama ki a tipalele sere ye. Tiyei ne, “Aa, tool kuto mai yo matam kala di Yuda le imot i, kemai dook!” ");
INSERT INTO apr_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Ngan tiyei nen, motong la tikorokoronaii, inbe tikaua toto tani a tirau tootoo kutono ye. ");
INSERT INTO apr_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Tipalele sere ye a imot, motong la tidudu sousoungu tani yo tisousouu ye i, inbe tisousouu ye sousoungu ki ye taunu mulu, inbe tikauu a tila bet la tipatota lo kai palasingi kaini. ");
INSERT INTO apr_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Di tooltool ke patokongo tina ngan tikaua Yesu a tiye tipa a tila, ngan titauaraia tool atu ke malala mai Sairini yo ene Simon i. Motong la tiparama a tiwete le koodi mede ye betanga panga bet ilono Yesu a isolo kai palasingi ki pa. ");
INSERT INTO apr_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Ngan nen le tipa a tilo pombe ye ni yo tiwete ene ye Golgata i. (Ngan betanga yo Golgata in punu ben Tool Kutono Ruruana). ");
INSERT INTO apr_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Motong la di tooltool ke patokongo tina ngan tipargarungnaia ooroo wain puana surunu in ilo ye bar ke bet ipammata tool tinini a iyetai tiap i, inbe tikauu pang Yesu a bet iyinu. Bong iyin toka, ngan lono panga tiap. ");
INSERT INTO apr_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Motong la tipatoto Yesu lo kai palasingi kaini nga. Tiyeii nen, motong la di tina ngan di tapdi tiparsu ye sousoungu le so ki, le nga titoo moomoo kidi a tikatte madamada a bet tipusye sima tooltool yo bet ole tikap so ki tina nga. ");
INSERT INTO apr_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Tikatte madamada a imot, motong la sila tiwur ye ni tani a bet matadi kala Yesu. ");
INSERT INTO apr_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Ngan ke ete, ye ni yo Yesu kutono ilo pang ye i, in tiwodo betanga yo tikadoni ye a le tirauu nga, ngan nen: I Yesu, Tool Kuto Mai Yo Matan Kala Di Yuda Le Imot I. ");
INSERT INTO apr_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Ye kene tani in tipatoto di tooltool ke pinnau ru lapau a tiye Yesu tinepe. Atu in tipatota lo kai palasingi kaini le inepe ke Yesu bene oonoo, inbe san in tipatota lo kai palasingi kaini le inepe ke bene ngas. ");
INSERT INTO apr_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Ngan di tooltool yo tipa a tila be timan nga, ngan tikilkiloi, inbe tikan paseme Yesu. ");
INSERT INTO apr_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Tiyei ne, “In ong tool tani yo kuwete bet kusaua bareme mai ke sungunu, lo ngan bet kupatokode mulu ye ke tol leu i, too? Bet nen ngan ong taum kulonong! Kumata bet ong in Maro Natunu moolmool nga, ngan kugege kai palasingi in a kusi tana!” ");
INSERT INTO apr_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Inbe gaongo leu ye di tooltool maimai ke paroranga so pang Maro tiye di pannoongoo ke wer ke Maro inbe di tooltool maimai kidi Yuda nga, ngan di lapau tipalele sere ye Yesu nen. ");
INSERT INTO apr_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Tiyei ne, “Kakamata, kanakana ngan ilon di tooltool kapala, bong nga gelei a le ye taunu iloni tiap nga? Ye i iyei tool kuto mai pang di tooltool ke tana mai Isrel le imot, too? Kumata bet igege kai palasingi ni a isi tana dookoot nga, ngan la bet tatara lodo medana panga nga. ");
INSERT INTO apr_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Ye i itara lono medana pang Maro, inbe iwete bet ye in Maro Natunu, too? Le kanepe a takamata too, ole Maro lono panga a iloni dookoot nga, too?” ");
INSERT INTO apr_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Tipalele sere ye nen, inbe gaongo leu ye di tooltool ke pinnau ru tina yo tipatoto di lo kai palasingi kaini, ngan tikan paseme Yesu lapau. ");
INSERT INTO apr_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Ye kemai ye ke matana sangaul be ru, ngan todo maiyoko iduku tana mai i le imot, a iken nen le du rrai ye ke matana tol. ");
INSERT INTO apr_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Ngan potai pang ye ke matana tol, motong la Yesu koonoo le mai nen, “Eloi, Eloi, lema sabaktani?” Ngan betanga tina ngan lono ki nen, “Maro kiau, Maro kiau, nga gelei a le kugegau nga?” ");
INSERT INTO apr_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Tina Yesu koonoo nen nga, ngan le di tooltool kapala yo tikododo potai nga, ngan tilongo le nga tiyei ne, “Ngo koonoo pang Ilia.” ");
INSERT INTO apr_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Motong la palbe leu inbe di tooltool tina ngan atu idada la kaua so ben punpun a isilia du ye ooroo wain surunu yo malingene in lono, inbe isuiu ye piu kaini a isulmaii lo pang ye Yesu koonoo a bet iyinu. ");
INSERT INTO apr_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Bong ngan di diene kapala tiwete panga nen, “Oi, kugege sila inepe a takamata toka. Ole Ilia si iloni, too tiap?” ");
INSERT INTO apr_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Motong la Yesu koonoo mulu le somai, inbe imaroon pattu leu le tina imata yege. ");
INSERT INTO apr_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Le ye kene tani in pattu leu inbe mala matolene yo tituka bareme mai ke sungunu lono i, in imassarak ke ete a ipa so le idu lopo le iyei paru. Inbe nauningi mai itak le pat maimai nga perperbe. ");
INSERT INTO apr_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Inbe agoro yo kidi matenge nga, ngan perperbe a koon panganga, inbe di tooltool yo mugu ngan Maro ipootoo di panga motong timmata nga, ngan di alunu la timadit mulu nga. ");
INSERT INTO apr_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Ngan nen le tigege gomo kidi matenge a tisi diki, inbe tinepe nen le lo Yesu imadit mulu ye matenge ki. Motong la tilo ye malala mai mison ke Maro yo Yerusalem i, a lo di tooltool alunu tikamata di. ");
INSERT INTO apr_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Ngan tool turana bulbulini ke patokongo, in iye di tooltool ki ke patokongo yo matadi kala Yesu nga, ngan tikamata nauningi mai yo itak i, inbe so kapala yo pompombe nga, le titattadai, inbe tiyei ne, “Ona, moolmool sa, tool i Maro Natunu!” ");
INSERT INTO apr_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Inbe di garup alunu yo titoo Yesu ke Galili a timan bet man tiloni ye so nga, ngan tikodo manga mooloo kasin ye kai palasingi, inbe tikamata so tina yo pompombe ngan ye matadi lapau. ");
INSERT INTO apr_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Ngan le atu in ene la Madia ke malala mai Makdala, inbe san in Madia ninsou yo Yemis ye Yosep tinadi i, inbe garup san in Sebedi di natunu tamoto ru ngan tinadi. ");
INSERT INTO apr_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Ke du a rrai, motong la tool ballingana atu ke malala yo ene Arimatia i, in iman pang ye rumu ke Pailot. Ngan tool tani in ene la Yosep i, inbe ye in Yesu galiunu lapau. ");
INSERT INTO apr_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Ila ye Pailot, motong la itoru bet imalum panga a nen ngan ikaua Yesu bobono. Ngan Pailot imalum panga le iwete pang di tooltool ki ke patokongo bet tikaua Yesu bobono panga. ");
INSERT INTO apr_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Motong la Yosep ikaua Yesu bobono tani a iduku ye mala kookoonoo paunu, ");
INSERT INTO apr_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","inbe lo itaru ye agoro paunu ki ke tarungu di matenge. Ngan agoro tani, in mugu ngan Yosep iwete pang di tooltool a tikeli ke sakar madini. Ngan Yosep tani lo itara Yesu bobono, motong la ipulu pat somai atu la ikatkala agoro tani in koonoo ye, inbe ila pang ni ki. ");
INSERT INTO apr_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Ngan Madia, garup ke Makdala, inbe ninsou Madia san, in yeru sila tinepe a tiwur potai pang ye agoro tani in koonoo. ");
INSERT INTO apr_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Tiken ye bong atu a du muntu, ngan lal tani yo bet tipare so pang lal kidi Yuda ke sungunu i, in ila oo. Motong la di tooltool maimai ke paroranga so pang Maro tiye di Paresi tila pang ye Pailot bet la tikamata. ");
INSERT INTO apr_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Tila, motong la tiwete pang Pailot nen, “Tool mai, am nga lomam tutu betanga ke tool kaplungunu ni. Ye kene yo inepe matana rerene go nga, ngan iwete nen, ‘Ole amata a aken ye ke ru, le ye ke tol kiau ngan ole amadit mulu.’ ");
INSERT INTO apr_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Le nga lomam bet kuwete pang di tooltool kiong ke patokongo a la tikodokala agoro ni le lo ke tol nga imot ngan. Ole nen ngan di galiunu timan man tipinaua bobono ni, inbe tila la tiwete pang di tooltool bet tool ni imata a nga imadit mulu oo. Kumata bet tiyei nen nga, ngan ole betanga kidi paunu yo bet tillung ye i, in ole ingaua ni mai i le imot, le illoso betanga ki doko yo iweta mugu i.” ");
INSERT INTO apr_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Motong la Pailot iwete nen, “Kakap di tooltool ke patokongo pattu a kala, inbe la kakodokala agoro tani ben tina yo kawete nga.” ");
INSERT INTO apr_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Le tina tila a la titara so ben tarkilanga ke tool mai tani in ilo ye pat somai tani yo tikatkala agoro koonoo ye i. Inbe titar di tooltool ke patokongo a tikodokala. ");
INSERT INTO apr_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Lal kidi Yuda ke sungunu in iman a ila, inbe ke san yo Sande i, in pombe. Motong la ye muntu ke ke tani ngan Madia ke malala Makdala iye Madia san tila bet la matadi so agoro tani. ");
INSERT INTO apr_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Tila pombe le mooloo tiap, inbe nauningi mai itak, yesoo bangabangana ke Tool Mai atu ipa ke malala ke Maro a isi le si ipulu pat tani yo ikatkala agoro koonoo in a ikoo. Motong la lo iwur pat tani in pono. ");
INSERT INTO apr_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Ngan bangabangana tani, in tinini i lulngana dawa ben kili itai, inbe sousoungu ki ikoko le ikoko san dawa ben eng tene kookoonoo nga. ");
INSERT INTO apr_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Ngan di tooltool ke patokongo pattu yo tikodokala agoro tani nga, ngan tikamata bangabangana tani le titattadai belebele a timolol du tikenen tana pono ben di tooltool matedi. ");
INSERT INTO apr_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Motong la bangabangana tani iwete pang di garup ru tina nen, “Ken katattadai be! Au i lok galanga yang nen, nga bet man kasere Yesu, tool yo tipatota lo kai palasingi kaini a imata i. ");
INSERT INTO apr_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Bong ye in inepe ni tiap. Ye in imadit mulu ye ni ke matenge oo, ben tina iwete nga. Le kaman man kakamata nene yo iken ye i. ");
INSERT INTO apr_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Lo ngan bet kamulu palbe a la kawete pang di galiunu nen. Kayei ne, ‘Yesu imadit mulu ye ni ke matenge a imugu a ila pang Galili oo. Ole la kakamata nango.’” Bangabangana tani in iwete pang di nen a imot, motong la iwete mulu nen, “Oo, betanga tani nain la dookoot nga aweta pang koot i.” ");
INSERT INTO apr_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Di garup ru tina titattadai belebele, bong lodi ponana mai san lapau. Ngan nen le tigege agoro tani, inbe tidada tarrai bet la tiwete pang Yesu di galiunu ye so tina yo pombe a tikamata nga. ");
INSERT INTO apr_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Tidada dada liwoonoo go, inbe pattu leu be Yesu pombe pang ye di a iwete pang di nen, “Muntu dook.” Motong la yeru tila potai ye a tigun turudi du dama ki, inbe tiparama kene a tisung panga. ");
INSERT INTO apr_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Motong la Yesu iwete pang di yeru nen, “Ken katattadai be! Bong angru kala ngan kawete pang di taik ngo a tila pang Galili. Ole la tikamatau nango.” ");
INSERT INTO apr_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Ye kene yo di garup ru tina ngan tipa dada liwoonoo ye in nga, ngan di tooltool ke patokongo tina yo tikodokala agoro ngan pattu tilo malala mai a lo tikaua bingi pang di tooltool maimai ke paroranga so pang Maro, ye so le imot yo pombe pang ye di nga. ");
INSERT INTO apr_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Motong la di tooltool maimai tina ke paroranga so pang Maro tiye di tooltool maimai kidi Yuda tigaua, inbe tiwetewete ye dada yo bet titoo in nen, bet ole tikap pat alunu pang di tooltool ke patokongo a bet nen ngan ken tipapos pang di tooltool kapala ye so yo pombe, in be. ");
INSERT INTO apr_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Le nga tiwete pang di nen, “Le bet kawete pang di tooltool nga, ngan kawete nen. Kayei ne, ‘Am nga, bong amkenen mata, inbe Yesu di galiunu timan tipinaua bobono a tikauu a tila oo.’ ");
INSERT INTO apr_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Le kumata bet betanga i la tool kuto mai kidi Rom ni ilonga nga, ngan am nga ole amtarkoo ang inbe amkarata betanga panga, a nen ngan kanepe ye moonoo be.” ");
INSERT INTO apr_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Ngan nen le di tooltool ke patokongo tikap pat tina, inbe tiyei dawa ben tina tiwete pang di nga. Le betanga tani i, in di tooltool tina tigasa nen a ingaua ni mai i le imot ye di tooltool kidi Yuda, a iken nen le se dookoot katai nga. ");
INSERT INTO apr_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Motong la Yesu di galiunu sangaul be atu, ngan tila pang Galili a tipa so a tilo ye kawal yo Yesu iwete pang di bet tilo ye i. ");
INSERT INTO apr_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Ye kene yo tilo a tikamata ye in nga, ngan le tisung panga. Bong di galiunu kapala ngan lodi rru kasin. ");
INSERT INTO apr_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Motong la Yesu iman potai ye di a iwete pang di nen, “Au i, Maro kaua gurana mai pau, le ayei Tool Mai pang so le imot yo iken ye malala ke Maro nga, inbe yo iken tana pono, ngan lapau. ");
INSERT INTO apr_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Ngan nanga, kala la karaia bingi dook mata i pang di tooltool ke ni mai i le imot a tilonga, a bet nen ngan tiportak lodi le tiyei galiuk. Inbe karriu di ye Tamana ene, inbe ye Natunu ene, inbe ye Maro Amunu Silene ene lapau. ");
INSERT INTO apr_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Inbe kapatomonai di a titoo betanga le imot yo awete pang ye nga. Le awete pang nen, au i ole anepe yang nen ye ke nga le imot, le ilo ye lal yo bet tana i imot ye i.” ");
INSERT INTO apr_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Bingi dook mata ke Maro Natunu yo Yesu Kirisi i, in imadit nen. ");
INSERT INTO apr_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Mukot yege ni nga, ngan Maro koonoo yo Esai in iwodo betanga ke Maro yo iwete ngan nen. “Kapalongo! Ole awanga tool atu ke bet imugu a ikaua bingi yong. Inbe ye in la bet ikarata dada pong i. ");
INSERT INTO apr_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Ole kalongo tool atu kalngana ye ni soorookoonoo, in iwete le koonoo maimai nen, ‘Kakarata dada pang Tool Mai, inbe kayeii le dundunngana panga bet ipa ye.’” ");
INSERT INTO apr_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Ngan rai alunu iman a ila, motong la betanga tina ngan kanono pombe ye kene yo Yowan pombe ye ni soorookoonoo a irriu di tooltool ye i. Ye in iwetewete pang di tooltool bet tiportak lodi ye dada dook tiap kidi yo tiyei nga, inbe irriu di a bet nen ngan Maro igiri sennene kidi. ");
INSERT INTO apr_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Ngan le di tooltool ke tana mai Yudia le imot, inbe ke Yerusalem alunu kaiye la tidu pang ye, a du titulu lodi panga ye sennene kidi, inbe irriu di ye ran Yodan nga. ");
INSERT INTO apr_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Ngan Yowan tani in sousoungu ki yo isousou ye nga, ngan tikarata ye asara yo ene kamel in bulbulini, inbe iwittoo galini ye bittoongoo yo tikarata ye asara kulini i. Inbe ikan sis, inbe iyin bagil surunu. ");
INSERT INTO apr_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Inbe ye in iwetewete pang di tooltool tina nen, “Tool yo bet ole ipa mur yau a isi i, in gurana ki mai san le illosau. Ngan nen le akamatau ben au i tool dook mata ke bet aloni ben poranga ki a atur du aruku ooroo ye loningi ke kene tiap. ");
INSERT INTO apr_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Au i arriu ang ye ran leu, bong ye in ole irriu ang ye Maro Amunu Silene.” ");
INSERT INTO apr_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Ye kene yo Yowan iyei urata ki ye in nga, ngan Yesu ipa ke malala Nasaret yo iken ye tana mai Galili in a isi pang ye Yowan le si irriuu ye ran Yodan. ");
INSERT INTO apr_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Le nga bet Yesu imadit ke ran lono a ise pang ete nga, ngan pattu leu be ikamata malala ke Maro koon panganga, inbe ikamata Maro Amunu Silene iro a isi pang ye ben man utu. ");
INSERT INTO apr_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Inbe tool atu kalngana iwetewete ye malala ke Maro a isi nen. Iyei ne, “Ong in au Natuk. Au i lok pong mai san, inbe lok ponana yong.” ");
INSERT INTO apr_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Yesu ilongo betanga tina a imot, motong la palbe leu be Maro Amunu Silene iwanga bet ipa le la pombe ye ni soorookoonoo atu. ");
INSERT INTO apr_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Ila le la iye di asara gok leu tinepe ye ni tani ye ke sangaul pai, inbe ye kene tani in Satan iman itoua. Bong di bangabangana ke Maro tisi matadi so a tiloni. ");
INSERT INTO apr_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Ye kene yo titara Yowan lo rumu dook tiap ke di talnga dikidiki lono ye in nga, motong la Yesu ipa le la pombe ye tana mai Galili a iwetewete bingi dook mata ke Maro nga. ");
INSERT INTO apr_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Ngan le iwete pang di tooltool nen, “Lal ke Maro tani in pombe oo. Le mooloo tiap, inbe dada yo Maro bet matan kala di tooltool ki ye i, in ole si pombe mallangana. Ngan nanga, kaportak lomu ye sennene kiang yo kayei nga, inbe katara lomu medana ye bingi dook mata ke Maro.” ");
INSERT INTO apr_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Motong la ye kene atu, ngan Yesu ipelele ran koonoo Galili a ila, ngan ikamata Simon iye taini Antares yo tikatte pu kidi du ran lono a bet tikap i ye, yesoo yeru ngan tiyei urata ye kaungu i bet tiyawar a tikap pat ye. ");
INSERT INTO apr_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Le nga iwete pang di nen, “Suru nga, kaman katoo au. Ang ngan di tooltool ke kaungu i, bong ole apatomonai ang ye urata ke kaungu di tooltool.” ");
INSERT INTO apr_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Tilongo tina yo Yesu iwete nen nga, le nga palbe leu be yeru tigege pu kidi sila ikino, inbe titoo a tiye tila. ");
INSERT INTO apr_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Motong la bet ipa kasin mulu a ila, ngan ikamata Sebedi di natunu ru nga, Yemis iye taini Yowan yo tidau ye ookoo kidi inbe tikarata pu kidi nga. ");
INSERT INTO apr_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Le nga ye kene yo ikamata di ye in nga, ngan palbe leu be iman tina le koonoo pang di yeru. Motong la yeru tigege tamadi Sebedi iye di tooltool yo tikap di ye urata nga, ngan sila tinepe ookoo pono, inbe titoo Yesu a tila. ");
INSERT INTO apr_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Yesu iye di galiunu tipa le la pombe malala mai Kapenam. Inbe ye kene yo lal kidi Yuda ke sungunu in pombe nga, ngan Yesu ole ilo rumu kidi Yuda ke gaongo in lono a lo ipatomonai di tooltool. ");
INSERT INTO apr_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Ngan le di tooltool tina yo tilongo patomonaingi ki nga, ngan titakrai ye patomonaingi ki, yesoo patomonaingi ki dawa ben di pannoongoo ke wer ke Maro, ngan tiap, bong patomonaingi ki ipa ye gurana ke Maro. ");
INSERT INTO apr_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Di ngan lodi kaua urata nen go, inbe mooloo tiap bet tool atu yo so sidi idiwidiwoo a inepe rumu tani kidi Yuda ke gaongo in lono i, in koonoo katkat pang Yesu. Iyei ne, ");
INSERT INTO apr_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Yesu ke Nasaret, ngan soo so bet kuyeii pam i? Nga kuman bet man kugarungam, too? Au i lok galanga yong oo, ong in tool tani yo Maro ipootoo panga ye taunu i.” ");
INSERT INTO apr_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Bong Yesu iwete le koon mede ye betanga a ilele so sidi tani. Iyei ne, “Ai, kuwetewete dookoot! Kupas ye tool in a kusi tana!” ");
INSERT INTO apr_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Motong la so sidi tani in itaktaka tool tani a ikatte du tana, inbe isulu katkat a igege a ikoo. ");
INSERT INTO apr_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Le nga di tooltool le imot yo tikamata so tina nga, ngan titakrai, inbe tiwete pang di diedi nen, “Ona tiap! I soo so nen i? I patomonaingi paunu, inbe ipa ye gurana mai san, le ipas le iwete leu inbe di so sidi tilongo betanga ki a titoo.” ");
INSERT INTO apr_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Motong la palbe leu be bingi ke Yesu idada le ingaua tana mai yo Galili in le imot. ");
INSERT INTO apr_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Yesu iye di galiunu kapala tigege rumu kidi Yuda ke gaongo in a tisi tana, motong la tiye Yemis ye Yowan tipa pang ye rumu ke Simon iye Antares a tila. ");
INSERT INTO apr_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Tila, ngan Simon roonoo garup in matamatenge ikauu le tinin ges a ikenen moi pono ki. Ngan tiwete pang Yesu ye. ");
INSERT INTO apr_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Le nga Yesu ipa so a ilo ye le lo itoko bene, inbe iloni a ipamaditi. Ngan le matamatenge tani in ikoo ye, inbe imadit a ikarata kaningi pang di bet tikan. ");
INSERT INTO apr_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Ye kene tani in rrai le nga ke idu, motong la di tooltool tiyau di tooltool le imot yo matamatenge ikap di, inbe so sidi idiwidiwi di nga, ngan a timan pang ye Yesu. ");
INSERT INTO apr_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Ngan le di tooltool alunu kaiye ke malala Kapenam la timan tigaua damadama ke rumu tani nga. ");
INSERT INTO apr_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Motong la Yesu ikarata di tooltool alunu yo matamatenge matana matana ikap di nga, inbe inganga di so sidi alunu ye di tooltool lapau. Ngan di so sidi tina ngan lodi galanga ye ben ye in sei nga, bong ilele di le ke bet tiwetewete tiap. ");
INSERT INTO apr_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Tiken bong le du muntu bongmai koot todotodo go, inbe Yesu imadit tina le igege rumu yo tiken ye i, inbe ila pang ye ni yo taukan tooltool i, bet la yetaleu inepe inbe ipatarau. ");
INSERT INTO apr_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Motong la Simon iye di diene timadit a tila bet la tisere, ");
INSERT INTO apr_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","le nga ye kene yo tipusye ye in nga, ngan le tiwete panga nen, “Ai, di tooltool malala mai la tiserong ngo.” ");
INSERT INTO apr_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Bong ngan Yesu iraua betanga kidi nen, “Nga ole tapa a tadik mulu pang ye malala kapala yo iken potai pang ye ni nga, a bet nen ngan awetewete bingi dook mata pang di tooltool ki lapau. Yesoo, ye punu naii la Maro iwangau a asi ye i.” ");
INSERT INTO apr_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Ngan nen le Yesu imadit tina le ipa a ila ye malala le imot yo iken ye tana mai Galili nga, inbe ilo rumu kidi Yuda ke gaongo ngan lono lo iwetewete bingi dook mata ke Maro pang di tooltool, inbe inganga di so sidi ye di. ");
INSERT INTO apr_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Tool atu yo botoboto medana ikani i, in iman pang ye Yesu man igun turunu du kene punu, inbe imangmang ye a iwete panga. Iyei ne, “Ai, kumata bet lom nen nga, ngan kuyei au le tinik igalanga mulu.” ");
INSERT INTO apr_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Le nga Yesu lono panga, motong la isulmaia bene la itoko tool tani, inbe iwete panga nen, “Dook mata, au i lok nen, le ole tinim igalanga mulu.” ");
INSERT INTO apr_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Ngan le pattu leu be botoboto medana tani in igege, inbe tinini igalanga dook mata. ");
INSERT INTO apr_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Motong la bet iwanga tool tani in a ila nga, ngan le iwete betanga medana panga nen, ");
INSERT INTO apr_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Ken kula ngan kugasa pang di tooltool ye so tani yo ayeii yong i, in be. Bong kupa so le la ong taum kupitnai ong pang tool ke paroranga so pang Maro in mugu. Lo ngan bet kuyei paroranga ye so pang Maro ye yo tinim igalanga mulu, dawa ben tina yo wer ke Mose iwete nga, a bet nen ngan di tooltool lodi galanga ye yo tinim igalanga koot nga.” ");
INSERT INTO apr_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Bong ngan tool tani in ila le la ikaua bingi ye so yo pombe pang ye nga. Ngan ye punu in la le Yesu ke bet ipa lo ipapos matana mulu ye tiap i, le inepe diki ye ni yo taukan tooltool i. Bong ngan di tooltool ke ni mai i le imot tipa a timan pang ye. ");
INSERT INTO apr_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Yesu inepe a ke kapala iman a ila, motong la imulu pang malala Kapenam. Ngan nen le di tooltool tilongo bingi ki yo imulu a man inepe rumu nga. ");
INSERT INTO apr_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Le nga di tooltool alunu kaiye tilo tigaua ye rumu tani yo inepe ye i, in le ipon le man itaua dada le manga sa mulu yo bet di tooltool tipa ke diki a tilo, ngan siap. Inbe iwetewete betanga ke Maro pang di. ");
INSERT INTO apr_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Inbe di tooltool kapala yo timan pang ye nga, ngan pai kidi ngan titokotoko tool atu yo ikap rama in a timan pang ye Yesu. ");
INSERT INTO apr_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Bong ngan ni manga pa yo bet tikaua tool tani a tilo pang ye, ngan siap, yesoo di tooltool alunu kaiye san. Ngan nen le tikauu a tilo rumu pono ke ete, motong la tisaua ni gimono atu le itarye ni yo Yesu inepe ye i, inbe tipadua le ipa ye moi ki a idu pang ye. ");
INSERT INTO apr_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Ye kene tani in Yesu ikamata ben di tooltool tina ngan titara lodi medana panga moolmool nga, le tina iwete pang tool tani yo ikap rama in nen. Iyei ne, “Natuk, sennene kiong ngan agir oo.” ");
INSERT INTO apr_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Ngan di pannoongoo ke wer ke Maro ngan pattu tiwurur a tilongo betanga yo Yesu iwete nen nga, le nga di tapdi lodi kaua urata nen, ");
INSERT INTO apr_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Ona tiap, nga gelei a tool i iwete nen nga? Nga o bet ikaua Maro nene, too? Tool sa yo bet igiri sennene kidi tooltool ngan tiap, bong Maro yetaleu.” ");
INSERT INTO apr_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Le tina pattu leu be Yesu lon galanga ye di ye yo lodi kaua urata nen nga, le nga itor di nen, “Nga gelei bet lomu kaua urata nen nga? ");
INSERT INTO apr_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Soo betanga imarra bet aweta pang tool kap rama tani i? Bet awete panga nen, ‘Sennene kiong ngan agir oo,’ too bet awete panga nen, ‘Kumadit, a kouo moi kiong a kupa’? ");
INSERT INTO apr_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Bong au i lok bet ayei nen, a bet nen ngan ole lomu galanga bet Tool Moolmool ke Maro in gurana ki mai ye tana i, ke bet igiri sennene kidi tooltool.” Motong la Yesu iwete pang tool yo ikap rama in nen, ");
INSERT INTO apr_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Ai, awete pong, kumadit a kouo moi kiong a kula pang rumu kiong.” ");
INSERT INTO apr_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Motong la di tooltool le imot matadi ikenen ye, inbe imadit tina le ikaua moi ki a ipa a ila. Ngan nen le di tooltool tina yo tikamata nga, ngan titakrai a tiyitmaka Maro ene. Tiyei ne, “Mugu ngan amkamata so sa yo nen, ngan tiap!” ");
INSERT INTO apr_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Motong la igege malala tani, inbe ipa mulu a idu pang ye ran ke Galili. Idu, ngan di tooltool alunu kaiye la timan pang ye man tiye tipa, inbe ipatomonai di nga. ");
INSERT INTO apr_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Le nga ipa a ila ngan ikamata Alpias natunu yo Liwi i, in iwurur rumu ke sodaningi pat in lono. Motong la Yesu iwete panga nen, “Ai, kuman kutoo au.” Le nga Liwi imadit tina le itoo a yeru tila. ");
INSERT INTO apr_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Motong la tinepe a kene san in Yesu iye di galiunu tinepe rumu ke Liwi a tiye tikan so. Ngan di tooltool alunu ke sodaningi pat, inbe alunu ke geingi sennene nga, ngan di lapau tilo a tiye Yesu tikan so, yesoo di tooltool yo ben di nga, ngan titoo Yesu a tiye tipa. ");
INSERT INTO apr_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Le nga ye kene tani in di pannoongoo ke wer ke Maro pattu yo di Paresi nga, ngan tikamata Yesu iye di tooltool ke geingi sennene, inbe di tooltool ke sodaningi pat tigaua a tikan so nga. Motong la titor di galiunu nen, “Ai, nga gelei bet iye di tooltool ke sodaningi pat, inbe di tooltool ke geingi sennene tigaua a tikan so nga?” ");
INSERT INTO apr_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Ngan Yesu talngana katbe tina yo tiwete nen nga, le nga iwete pang di nen, “Di tooltool yo tinidi dook mata nga, ngan tool ke bar ke bet ipa pang ye di tiap, bong di tooltool la matamatenge ikap di nga. Ngan nanga, au i asi nga bet si akiu di tooltool yo noonoodi nga tiap, bong di tooltool yo ke sennene nga.” ");
INSERT INTO apr_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Ye kene kapala ngan Yowan yo irriu di tooltool i, in di galiunu, inbe di Paresi ngan tisapa ye kaningi so. Le nga di tooltool pattu timan ye Yesu man titoru. Tiyei ne, “Yowan di galiunu, inbe di Paresi galiudi nga tisapa ye kaningi so, e nga gelei bet di galium nga tisapa ye kaningi so tiap nga?” ");
INSERT INTO apr_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Motong la Yesu iraua torungu kidi nen, “Kumata tamoto atu yo bet ikere i, in ikiu di tooltool ki bet man tiye tinepe ye kerenge ki nga, ngan gelei, ole tisapa ye kaningi, too tiap? Tiap yege! Ye kene yo tiye tinepe ye in nga, ngan o ke bet tiyeie so sa yo nen, ngan tiap. ");
INSERT INTO apr_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Bong pang dama ni ngan ole di tooltool tikaua tool tani yo bet ikere in le igege di tooltool ki nga, ngan la bet ye kene tani ngan ole tisapa ye kaningi nga.” ");
INSERT INTO apr_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Motong la Yesu iseke betanga ki mulu nen. Iyei ne, “Tool sa ke bet ikaua mala timunu yo paunu i a idede sousoungu ki yo gurunu in gimono ye tiap. Kumata bet iyei nen le bet ingasi nga, ngan mala timunu tani yo paunu i, in ole irauwat le isarraka sousoungu ki le dook tiap. ");
INSERT INTO apr_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Inbe tool sa ke bet ipaling ooroo wain surunu yo paunu ngan ilo ye dap gurunu yo tikarata ye asara kulini, in tiap. Kumata le bet iyei nen, inbe ooroo surunu tina ngan isung nga, ngan ole ipirpala dap tani a imatiti du tana, le dap pa ye wain tina ngan ole dook tiap. Bong tiap, ole ipaling ooroo wain surunu yo paunu ngan ilo ye dap paunu yo tikarata ye asara kulini i.” ");
INSERT INTO apr_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Ye lal kidi Yuda ke sungunu atu in ngan Yesu iye di galiunu tipa ye dada yo ipa kumu lono ke dingding i. Le nga ye kene yo titoo dada tani a tila nga, ngan di galiunu tikap dingding tina ngan puana pattu a bet tikan. ");
INSERT INTO apr_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Bong ngan di Paresi pattu tikamata di, le nga tiwete pang Yesu nen, “Ai, kumata! Nga gelei a di galium ngo tiyei dada yo wer kiam Yuda igunkalam bet amyei ye lal ke sungunu tiap nga?” ");
INSERT INTO apr_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","26","Motong la Yesu iraua betanga kidi nen, “Ang nga kakinkata rau yo igasa so yo Dawiti iyeii ye kene yo Abiata iyei tool kuto mai ke paroranga so pang Maro ye, in pitiap, too? Ye kene tani ngan iye di tooltool ki pitolo di le tisere so yo bet tikani i. Motong la idewe a ilo rumu ke Maro lono, lo ikap porong yo tiyei paroranga ye nga. Ngan porong tina, ngan di tooltool ke paroranga so leu la bet tikan nga, bong di tooltool sorok, ngan tiap. Bong Dawiti ikap porong tina a ikan, inbe ikap pang di tooltool ki a tikan lapau.” ");
INSERT INTO apr_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Motong la Yesu iwete porai betanga ki nen, “Maro itara lal kidi Yuda ke sungunu pang di tooltool, bong itar di tooltool pang lal kidi Yuda ke sungunu tiap. ");
INSERT INTO apr_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Ngan nen le Tool Moolmool ke Maro, in ye la iyei Tool Mai pang lal kidi Yuda ke sungunu i, in lapau.” ");
INSERT INTO apr_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Tinepe le lal kidi Yuda ke sungunu san mulu pombe, motong la Yesu imulu a ilo rumu kidi Yuda ke gaongo in lono, ngan tool atu yo bene ikap rama i, in inepe. ");
INSERT INTO apr_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Inbe di tooltool kapala yo tiye tinepe nga, ngan tisere dada yo bet tikaua Yesu pang ye di kuto maimai ke karatanga betanga a tiweteweta ye urata ki yo iyei nga. Le nga matadi kenen ye bet tikamata, ole ikarata tool tani yo ikap rama in ye lal kidi Yuda ke sungunu, too tiap. ");
INSERT INTO apr_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Le nga Yesu iwete pang tool tani yo bene ikap rama in nen, “Oi, kumadit a se kukodo dama kidi tooltool nga.” ");
INSERT INTO apr_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Motong la itor di tooltool tina nen, “Wer ke Maro iwete balai ye lal kidi Yuda ke sungunu? Iwete bet tayei dada dook mata pang di tooltool, too bet tayei dada dook tiap pang di? Too, iwete bet talon di a tinepe dook mata, too bet tagarung di a timmata?” Yesu itor nen, bong tiwete kan betanga siap. ");
INSERT INTO apr_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Tina tiyei nen nga, le nga Yesu katen malmal a matan koropalanga pang di. Inbe lon moo san lapau, yesoo di ngan kutodi mede dawa ben pat. Motong la iwete pang tool tani nen, “Oo, kupadunu bem in.” Le nga bet ipadunu bene, ngan bene tani in dook mata mulu. ");
INSERT INTO apr_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Yeiso bet di Paresi tikamata yo iyei nen nga, ngan tina timadit le tidu tana du tiye di tooltool pattu yo tikata suanga ye Erot nga, ngan tigaua a tiwetewete ye dada yo bet tiraumata Yesu ye i. ");
INSERT INTO apr_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Motong la Yesu iye di galiunu tigege ni tani, inbe tidu pang ran Galili, ngan le di tooltool alunu kaiye ke tana mai Galili la titoo di a tidu nga. ");
INSERT INTO apr_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Inbe ye kene yo di tooltool kapala tilongo betanga ye so le imot yo iyei nga, ngan le tipa ke malala kidi a timan bet man tikamata lapau. Ngan nen le tipa ke tana mai Yudia le Idumia, inbe ke Yerusalem, inbe ke ran Yodan koonoo kapala, inbe ke malala mai Taia le Saidon a timan. ");
INSERT INTO apr_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Ngan tina di tooltool alunu kaiye man tigaua nga, le nga Yesu la iwete pang di galiunu bet tisere ookoo atu panga bet iyiri ye, a bet nen ngan di tooltool man tigaua a tiparloko le tiloko la pono be. ");
INSERT INTO apr_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Yesoo ikarata di tooltool alunu kaiye a tinidi dook mata koot nga, ngan nen le di tooltool kapala yo matamatenge ikap di nga, ngan tisurpak di diedi a tikapge bet la titoka lapau. ");
INSERT INTO apr_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Inbe di tooltool yo so sidi tinepe ye di nga, ngan kanakana bet tikamata Yesu nga, ngan ole timol du tiken dama ki inbe koodi le mai nen, “Alei, ong in Maro Natunu.” ");
INSERT INTO apr_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Bong Yesu ipasak pang di a iwetekala di bet ken tipaposi lo mallangana be. ");
INSERT INTO apr_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Tinepe le kene san, motong la Yesu ipa a ilo pang ye kawal atu, inbe ikiu di tooltool yo lono pang di nga, ngan bet timan pang ye. Timan pombe, ");
INSERT INTO apr_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","motong la ipootoo di tooltool sangaul be ru bet tiyei aposol, a bet nen ngan tiyei ene, inbe pang dama ni ngan ole iwanga di la tiwetewete betanga ke Maro pang di tooltool. ");
INSERT INTO apr_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Inbe ole ikap gurana pang di, a bet nen ngan tinganga di so sidi ye di tooltool lapau. ");
INSERT INTO apr_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Ngan di tooltool sangaul be ru tina yo ipootoo di panga nga, ngan edi nen: Simon yo Yesu isu ene san ye Pita i, ");
INSERT INTO apr_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","inbe Sebedi di natunu yo Yemis iye taini Yowan nga. Di ngan Yesu isu edi paunu ye Boaneges. Ngan edi tani in punu nen, Looloo di Natunu. ");
INSERT INTO apr_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Inbe ipootoo Antares iye Pilip, ye Batolomiu, inbe Matiu iye Tomas, ye Yemis yo Alpias natunu i, inbe Tadias iye Simon yo tool ke sorringi di Rom ye tana kidi Yuda i, ");
INSERT INTO apr_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","inbe Yuta Iskariot yo pang dama ni ngan ole itara Yesu la di koi ki bedi i, in lapau. ");
INSERT INTO apr_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Yesu iye di galiunu timulu a tilo rumu, inbe di tooltool alunu kaiye timan pang ye di man tiye di tigaua mulu, le manga sa yo bet tikan so ye, ngan tiap. ");
INSERT INTO apr_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Inbe ye kene tani in di sogana tilongo ben ikan so tiap nga, le nga tila bet la tikauu, yesoo di ngan lodi tar bet o iyei kapa. ");
INSERT INTO apr_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Ngan di pannoongoo ke wer ke Maro yo tipa ke Yerusalem a tisi nga, ngan tiwetewete ye Yesu nen. Tiyei ne, “Ai, tool in Belsebul la inepe ye i. Le ye in inganga di so sidi ye gurana ke Belsebul yo tool kuto mai kidi so sidi i.” ");
INSERT INTO apr_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Ngan Yesu ilongo di tina yo tiwete nen nga, le nga ikiu di a timan pang ye, motong la ikatte betanga atu pang di nen, “Nga gelei, ole Satan iyei koi pang di tooltool ki ye taunu a inin di a tikoo, too? Tiap yege! ");
INSERT INTO apr_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Kumata bet di tooltool ke tana mai atu bet tiparpoto le tinepe ye budanga ru, inbe tipatoko nga, ngan ole tikodo le timede balai? ");
INSERT INTO apr_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Inbe kumata bet rara atu yo tinepe ye rumu atu nga, ngan bet tiparpoto le tinepe ye budanga ru, inbe di tapdi tipatoko nga, ngan ole tikodo le timede balai? ");
INSERT INTO apr_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Ngan gaongo leu ye Satan lapau. Kumata bet di tooltool ki tiyei koi pang di diedi le bet tiparpoto a tinepe ye budanga ru nga, ngan o ke bet Satan tani in ikodo le imede tiap, yesoo gurana ki ngan imot le ipa so oo. ");
INSERT INTO apr_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Le kakamata, tool sa ke bet la irookoo rumu ke tool atu yo gurana ki mai mata i, inbe lo ikap sorok so yo iken rumu lono ki, ngan tiap. Bong kulkulunu ngan ole iparama tool tani yo gurana ki mai mata in mugu a ipauu ngan, lo ngan bet lo ikap so ki tina yo iken rumu lono nga.” ");
INSERT INTO apr_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Motong la Yesu iwete mulu pang di nen, “Awete pang moolmool nen, sennene le imot yo di tooltool tiyei, ngan ipa ye betanga yo tikan paseme Maro ye nga, ngan ole igiri. ");
INSERT INTO apr_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Bong di sima tooltool yo tikan paseme Maro Amunu Silene nga, ngan Maro o ke bet igiri sennene kidi tina ngan tiap, bong ole iken nen le taukan motingi.” ");
INSERT INTO apr_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Yesu iwete pang di nen, yesoo di ngan tiwete bet ye in so sidi inepe ye. ");
INSERT INTO apr_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Motong la ye kene tani in Yesu tinana le di taini tipa le man pombe ye rumu yo inepe ye i, le nga tikodo ke diki inbe tiwanga panga bet isi pang ye di ngan. ");
INSERT INTO apr_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Ngan di tooltool alunu kaiye la tiwur le tigaliuu nga, inbe lo tiwete panga nen, “Ai, tinam le di taim la man tinepepe diki nga, ngan titor yong.” ");
INSERT INTO apr_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Bong ngan Yesu iraua betanga kidi nen, “Tinak sei, inbe di sima taik nga?” ");
INSERT INTO apr_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Motong la matana pang ye di tooltool tina yo tiwur le tigaliuu nga, inbe iwete pang di nen, “Oo, kakamata, di tinak le di taik me e nga. ");
INSERT INTO apr_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Kumata le di sima tooltool yo bet titoo Maro lono nga, ngan di ngan la di tinak le di taik nga.” ");
INSERT INTO apr_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Tinepe a kene san, motong la Yesu ipamaditi urata ki ke patomonaingi di tooltool ye betanga ke Maro mulu ran koonoo Galili nga. Ngan ye kene tani in di tooltool yo man tigaua a tigaliuu nga, ngan alunu le alunu san. Le nga iyiri a lo iwur ookoo atu pono, inbe tisurpaki le du idau manga mooloo kasin, inbe ipatomonai di. Inbe di tooltool tina, ngan di le imot tinepe ke tana ke ran koonoo a tilongo betanga ki. ");
INSERT INTO apr_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Ngan le so yo ipatomonai di ye, ngan alunu la ikatte betanga ye nga. Le nga iwete pang di nen, ");
INSERT INTO apr_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Katar talngamu a kapalongo! Ye kene atu ngan tool ke kapgingi atu in ikap dingding patunu ke kaningi bet la igiri kumu ki. ");
INSERT INTO apr_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Ngan kene yo igiri ye in nga, ngan kapala imol du dada katene. Ngan nen le di man tikamata le man tikan. ");
INSERT INTO apr_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Inbe dingding patunu kapala ngan imol du ye tana yo ke lopo ki in bongarngar le tana dook mata ke ete ngan mai mata tiap nga. Ngan nen le palbe leu be tisup, ");
INSERT INTO apr_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","bong ye kene yo ke ise a isini katkat ye in nga, ngan igesnai dingding supana tina le timallai a tiwod, yesoo ramini idu lopo mata tiap. ");
INSERT INTO apr_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Inbe dingding patunu kapala ngan imol du ooroo kaudangdang lono. Ngan nen le tisup pa ye kaudangdang le ooroo kaudangdang tani in iturai di le ke bet tipu a titar kanodi tiap. ");
INSERT INTO apr_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Bong dingding patunu kapala ngan imol du ye tana yo dook mata nga. Ngan nen le tisup dook mata le tipu a titar kanodi. Ngan kaini kapala ngan titar kanodi 30, inbe kapala ngan kanodi 60, inbe kapala ngan kanodi 100.” ");
INSERT INTO apr_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Yesu iwete nen a imot, motong la iyei ne, “Sei tool bet talngana ke longono betanga nga, ngan itar talngana dook a ilongo betanga kiau nga.” ");
INSERT INTO apr_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Ye kene yo di tooltool malala mai tina ngan tigege Yesu a tila le iye di galiunu leu inbe di tooltool kapala yo titoo ngan tinepe ye in nga, motong la titoru ye betanga yo ikatte nga. ");
INSERT INTO apr_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Le nga iwete pang di nen, “Mugu ngan dada yo Maro bet matan kala di tooltool ki ye i, in iken sollono, bong dookoot nga ye in lon ponana bet ipaposi pang. Bong di tooltool yo tinepe diki nga, ngan ole tilongo betanga ye dada tani ngan ye kattenge betanga leu, ");
INSERT INTO apr_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","a bet nen ngan, ‘kanakana ngan ole tikamata so yo Maro iyei nga, bong o ke bet tikilala tiap. Inbe kanakana ngan ole tilongo betanga yo iwete nga, bong o ke bet lodi galanga ye tiap, ole nen ngan bet tiportak lodi nga, ngan Maro igiri sennene kidi!’ ” ");
INSERT INTO apr_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Motong la Yesu iwete pang di mulu nen, “Kumata bet lomu galanga ye betanga yo akatte ye dingding patunu in punu tiap nga, ngan ole lomu galanga ye betanga kapala yo akatte ngan punu balai? ");
INSERT INTO apr_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Betanga tani yo akatte in punu nen. Dingding patunu yo tool ke kapgingi in la igiri nga, ngan ben betanga ke Maro. ");
INSERT INTO apr_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Inbe dingding patunu yo imol du dada katene nga, ngan ben di tooltool kapala yo tilongo betanga ke Maro, bong palbe leu be Satan ikaua betanga tani yo iken lodi in a ikutaki ye di. ");
INSERT INTO apr_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Inbe dingding patunu yo imol du ye tana yo ke lopo ki in bongarngar nga, ngan ben di tooltool kapala yo tilongo betanga ke Maro ngan le tikauu palbe leu a lodi ponana ye nga. ");
INSERT INTO apr_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Bong betanga tina ngan tiparama le iken so lodi tiap dawa ben dingding supadi yo ramidi idu lopo mata tiap nga. Ngan nen le tikodo le timede ye manga modono kasin leu. Bong ye kene yo moonoo sa pombe pang ye di, too di tooltool tikamata di ben titoo betanga ke Maro le bet tigarung di nga, ngan ole palbe leu inbe tigege lodi medana yo titaru i, inbe tiwala muridi pang Maro. ");
INSERT INTO apr_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Inbe dingding patunu yo imol du ooroo kaudangdang lono nga, ngan ben di tooltool kapala yo tilongo betanga, ");
INSERT INTO apr_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","bong lodi rru mai san ye nepongo kidi yo ke tana i, inbe balingi le pat ikap matadi mata, inbe matadi gorengana ye so matana matana yo ke tana nga lapau. Ngan nen le so tina ngan ikap matadi le iduk betanga ke Maro yo iken lodi nga, le ke bet ipu a itar kanono tiap lapau. ");
INSERT INTO apr_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Inbe dingding patunu yo imol du ye tana dook mata nga, ngan ben di tooltool yo tilongo betanga ke Maro, inbe tikauu a tiparama le imede nga. Ngan nen le di ngan titar kanodi alunu dook mata dawa ben dingding kaini yo tipu ngan titar kanodi 30, inbe kapala ngan kanodi 60, inbe kapala ngan kanodi 100 nga.” ");
INSERT INTO apr_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Motong la Yesu iwete pang di mulu nen, “Tool bet ikaua sul a ise rumu lono nga, ngan gelei, ole itaru du bor parmana, too ole itaru du kakawa ke kenongo parmana? Tiap! Ole ipawoti lo ete. ");
INSERT INTO apr_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Le soo so yo di tooltool titarkoo a iken sollono nga, ngan ole Maro ipapos se mallangana le imot. Inbe soo betanga yo titarkoo le di tooltool ke bet tilongo tiap nga, ngan ole ise mallangana le imot lapau. ");
INSERT INTO apr_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Sei tool bet talngana ke longono betanga nga, ngan itar talngana dook a ilongo betanga kiau nga.” ");
INSERT INTO apr_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Motong la Yesu isudungu betanga ki pang di mulu nen, “Katar talngamu ye betanga yo kalongo nga, inbe lomu kaua urata ye dook. Yesoo, kumata le kakapge bet lomu galanga ye betanga kiau punu nga, ngan ole akap lo galanga pang ye betanga tina ipa ye betanga kapala lapau. ");
INSERT INTO apr_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Kumata le sei tool bet lon galanga ye betanga ke Maro a itoo nga, ngan ole Maro ipagalanga lono ye betanga ki sa mulu. Bong sei tool yo lon galanga ye betanga ki kasin, bong itoo tiap i, in Maro ole ikutak lo galanga kasin yo iken ye ngan le inepe sorok.” ");
INSERT INTO apr_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Motong la Yesu iwete pang di lapau nen, “Dada yo Maro bet matan kala di tooltool ki ye i, in dawa ben tool atu yo ikap dingding patunu ke kaningi bet la igiri ye kumu ki i. ");
INSERT INTO apr_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Le kanakana nga bet iken mata bong, too imadit muntu a iyei urata ki nga, ngan dingding patunu tina ngan supadi tisup a tise. Bong tool tani in lon galanga ye dada yo iyei balai a le tisup ye, in tiap. ");
INSERT INTO apr_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Tana ye taunu la iyei dingding patunu tina le tisup a tipu le titar puadi i. Ngan kulkulunu bet tisup a tise ngan titar kaidi, motong la titar kuludi, lo ngan bet puadi pombe ye nga. ");
INSERT INTO apr_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Inbe ye kene yo puadi tina ngan bet imede a imatu nga, ngan ole ikaua sele ki yo matana koene in la isaput ye. Yesoo, lal ke winnokanga dingding puana ke kaningi in pombe oo.” ");
INSERT INTO apr_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Motong la Yesu iwete pang di mulu nen, “Ole tawete dada yo Maro bet matan kala di tooltool ki ye i, in dawa ben soo so? Too, soo betanga yo bet takatte ngan tawete nini ye i? ");
INSERT INTO apr_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Dada yo Maro bet matan kala di tooltool ki ye i, in dawa ben kai yo ene mastet in patunu. Ngan kai patunu kapala yo kupe nga maimai, bong mastet in maitiap. ");
INSERT INTO apr_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Bong ye kene yo bet kupe ye in nga, ngan ole isup le somai le illos so le imot yo kape kumu lono nga. Inbe ole lo itar bene somaimai le di man yo tiro lang katene nga, ngan ole tire giniu kidi ye inbe tiko ye rur ki.” ");
INSERT INTO apr_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Ngan tina Yesu iwetewete pang di tooltool ye betanga ke Maro nga, ngan ikatte betanga gaongo leu alunu kaiye pang di. Inbe kumata le bet lodi galanga ye betanga ki nga, ngan la bet isitoo betebetanga pang di ye dada yo nen in nga. ");
INSERT INTO apr_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Nen le ye kene yo iwetewete betanga ke Maro pang di tooltool ye in nga, ngan ikatte betanga leu. Bong ye kene yo iye di galiunu leu tinepe ye in nga, ngan iwete nin betanga tina yo ikatte ngan punu le imot pang di a bet lodi galanga ye. ");
INSERT INTO apr_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Ye kene tani in rrai ki, motong la Yesu iwete pang di galiunu nen, “Ai, nga ole tala ke ran koonoo kapala.” ");
INSERT INTO apr_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Motong la tigege di tooltool malala mai tina ngan sila tinepe, inbe tiyiri ye ookoo yo Yesu inepe pono i, inbe tiye tikooi a tila. Ngan le di tooltool yo tinepe ye ookoo kapala nga, ngan di lapau tikooi a tiye di tila. ");
INSERT INTO apr_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","38","Tikooi a tila, le nga Yesu idu ke ookoo kirini du iken a ipaloko kutono lo ye kaliki le iken mata a ila oo, inbe mooloo tiap bet eng mai imadit tina le kokor ki popobe a ipases lo ookoo pono. Ngan nen le kasin leu be ookoo kidi imere. Motong la di galiunu du tipoongoo a tiwete panga nen, “Pannoongoo, kumadit! Nga gelei, o lom pam tiap, too? Nga bet tamere a tallede!” ");
INSERT INTO apr_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Le nga Yesu imadit lo ikodo, inbe iwete katkat pang eng le kokor tina. Iyei ne, “Dookoot! Kanepe moonoombe!” Motong la eng mai tani in imata inbe manini susube dook mata. ");
INSERT INTO apr_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Motong la iwete pang di galiunu nen, “Nga gelei a katattadai mata nen nga? Ang nga o katara lomu medana pau tiap, too?” ");
INSERT INTO apr_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Iwete pang di nen, bong di galiunu titattadai le di tapdi tipartor nen, “Ona tiap! I soo tool nen i a le eng le kokor tilongo koonoo nga?” ");
INSERT INTO apr_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Yesu iye di galiunu tipoi a tisautu ran le la pombe ran koonoo kapala ye tana kidi tooltool ke Gerasa. ");
INSERT INTO apr_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Le nga ye kene yo iye di galiunu bet tipas ke ookoo pono a tidi pang tana nga, ngan tool atu yo so sidi tinepe ye i, in palbe leu be ipas ye agoro kidi matenge a ipot le pot itauaraii. ");
INSERT INTO apr_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","4","Ngan tool tani in inepe agoro lono ke di matenge, inbe mugu ngan tipau kene le bene ye ooroo medana, bong gurana san le ikupkuprai ooroo medana tina, inbe igoromkat so medana yo tikapidi kene ye nga. Ngan nen le dookoot nga tool sa yo gurana ke bet iparama a ipauu mulu, ngan tiap. ");
INSERT INTO apr_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Le ye ke le bong tina yo kanakana nga, ngan ipa ye agoro kidi matenge le ni yo arono nga, inbe isululu a ikoropalapala tinini ye pat. ");
INSERT INTO apr_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Ye kene tani in ikamata Yesu ipa ni mooloo go, inbe idada a ila le la imol du igun turunu Yesu kene punu. ");
INSERT INTO apr_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Motong la Yesu iwete pang so sidi tani nen, “Ong in so sidi, le kupas a kusi tana ye tool in!” Le nga tool tani in koonoo le mai nen, “Atoo! Yesu, ong i Maro yo inepe ete ni, in natunu! Nga soo so bet kuyeii pau i? Kupamede betanga ye Maro ene pau nen, bet ken kop masngana pau be.” ");
INSERT INTO apr_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Motong la Yesu itoru nen, “Ong i em sei?” Le nga iraua betanga ke Yesu nen, “Au i ek la Budanga i, yesoo am nga alunu.” ");
INSERT INTO apr_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Motong la tool tani in itor tootoo Yesu a imangmang ye bet ken inganga di a tikoo ye ni tani be. ");
INSERT INTO apr_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Ye kene tani ngan di ga budanga mai atu tinepe potai a tikanen kawal madini. ");
INSERT INTO apr_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Le nga di so sidi tina titoro Yesu a timangmang ye nen, “Ai, kungangam a amla ye di ga ngo, inbe kumalum pam a amdewe a amlo lodi.” ");
INSERT INTO apr_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Motong la Yesu imalum pang di a tipas ye tool tani a tisi tana, inbe tila la tidewe a tilo di ga tina ngan lodi. Le nga di ga tina ngan tidada a tila sakar matana a tipas du ran lono le taun tidaup a timmata. Ngan di ga tina ngan kinkatingi kidi ben 2,000. ");
INSERT INTO apr_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Motong la di tooltool yo matadi kala di ga nga, ngan tikamata so yo pombe i, le nga tikoo a tidada lo tikaua bingi ye malala mai kidi, inbe ye malala kapala yo iken potai ye, ngan lapau. Le nga di tooltool timadit a tidu bet du tikamata soo so yo pombe i. ");
INSERT INTO apr_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Tidu du pombe, ngan tikamata tool tani yo mugu ngan di so sidi alunu tidiwidiwoo i, in kuton kaua urata dook mulu, inbe isousou ye sousoungu a iwurur. Ngan nen le titattadai. ");
INSERT INTO apr_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Motong la di tooltool tina yo tikamata so yo pombe ye tool tani in nga, ngan tigasa pang di tooltool tina, inbe tiwete pang di ye so yo pombe ye di ga tina, ngan lapau. ");
INSERT INTO apr_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Le nga di tooltool tina ngan timadit a tiwete pang Yesu a timangmang ye bet ikoo ye ni kidi inbe ila pang ni san. ");
INSERT INTO apr_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Motong la Yesu imulu bet du iyiri lo ookoo pono a iye di galiunu timulu a tila, ngan tool tani yo so sidi idiwidiwoo i, in itoru a imangmang ye bet imalum panga a nen ngan iye tila. ");
INSERT INTO apr_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Bong ngan Yesu imalum panga tiap. Iyei ne, “Kumulu a kulo malala kiong lo kuwete pang di sogam ye so maiyoko yo Tool Mai iyeii pong i, inbe ye dada yo lono pong a le ilonong ye i.” ");
INSERT INTO apr_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Motong la tool tani in imulu a ilo pang tana yo ene Dekapolis i, a lo igasa pang di tooltool ye so tina le imot yo Yesu iyei panga nga. Ngan nen le di tooltool le imot yo tilongo betanga ki nga, ngan titakrai. ");
INSERT INTO apr_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Yesu iye di galiunu tikaua ookoo a tisautu ran mulu a tila ke koonoo kapala. Le nga ye kene yo tila tisolo ye in nga, ngan le di tooltool alunu kaiye la timan tigaua le tigaliuu ran koonoo nga. ");
INSERT INTO apr_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Motong la tool atu yo ene Yairus in ipa a idu. Ngan ye in kuto mai atu yo iye di diene matadi kala rumu kidi Yuda ke gaongo i. Le nga ye kene yo du ikamata Yesu ye in nga, ngan le iro du igun turunu potai pang kene punu, ");
INSERT INTO apr_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","inbe itoru a imangmang ye nen. Iyei ne, “Ai, natuk garup kase ni ngo bet imata. Le atoo, kuman a ayong tadi rumu kiau di kupaloko bem lo pono, a bet nen ngan tinini dook mata mulu a inepe.” ");
INSERT INTO apr_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Motong la Yesu itoo a bet yeru tidi pang rumu ki. Ngan le di tooltool malala mai tina ngan titoo di lapau, bong tigaliuu le tiparlokoloko. ");
INSERT INTO apr_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Inbe garup atu yo iyolo rara ye rai sangaul be ru i, in ye lapau iye di tooltool tina tipa. ");
INSERT INTO apr_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Ngan garup tani, in mugu ngan ikamata di tooltool ke bar alunu kaiye bet tiloni ye matamatenge ki, ngan tiloni dook tiap, inbe tikap masngana mai panga. Inbe ye in ikatte pat ki le imot bet iyimi urata kidi lapau, bong di atu sa ke bet iloni a tinini dook mata mulu nga tiap, bong tiyeii a matamatenge ki tani in idik le lo maiyoko. ");
INSERT INTO apr_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","28","Ngan tina ilongo bingi ke Yesu ye so yo iyei nga, ngan le lon tar nen, “Kumata le bet atoko sousoungu ki leu nga, ngan ole matamatenge kiau imot le tinik dook mata mulu.” Motong la ipalanai di tooltool malala mai tina, inbe ipa ke Yesu murini le isulmaia bene la itoko sousoungu matolene ki. ");
INSERT INTO apr_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Motong le pattu leu be iyetai ben rara mooloo yo ikauu, in imot, inbe tinini dook mata mulu oo. ");
INSERT INTO apr_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Inbe Yesu lapau palbe leu be iyetai ben gurana ki kasin ilungmaii oo. Le nga iportak pang ye di tooltool malala mai tina, inbe itor di nen, “Ai, sei itoko sousoungu kiau i?” ");
INSERT INTO apr_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Le nga di galiunu tiwete panga nen, “Kumata, di tooltool malala mai la tigaliu ong le tiparlokoloko nga. E nga gelei bet kutor ye tool yo itokong in nga?” ");
INSERT INTO apr_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Bong ngan Yesu matan sarsarai bet ikamata tool yo iyei dada nen i. ");
INSERT INTO apr_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Motong la garup tani in lon galanga ye so yo pombe pang ye nga, le nga itattadai a itangarur, inbe ila tina le la igun turunu du Yesu kene punu, inbe ipapos so le imot yo pombe pang ye nga. ");
INSERT INTO apr_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Motong la Yesu iwete panga nen, “Natuk, lo medana kiong yo kutaru pau i, in la ikaratong le tinim dook mata mulu i. Le kula ngan le la kunepe ye lo silene ke Maro, yesoo matamatenge kiong in imot oo.” ");
INSERT INTO apr_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Yesu iwetewete pang garup tani in go, inbe di tooltool pattu tipa ye rumu ke Yairus a pot pombe. Le nga tiwete pang Yairus nen, “Atoo, natum garup in imata oo. Le ken kuporo pannoongoo in bet idi mulu be.” ");
INSERT INTO apr_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Di tooltool tina ngan tiwete nen, bong ngan Yesu lono bet itar talngana ye betanga kidi yo tiweta, in tiap. Le nga iwete pang tool kuto mai yo matan kala rumu kidi Yuda ke gaongo in nen, “Ken kutattadai be, bong kuparama lo medana yo kutaru pau in le imede.” ");
INSERT INTO apr_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Motong la ikodokala di tooltool malala mai tina bet ken sa titoo be. Le nga ikaua Pita inbe Yemis iye taini Yowan leu a iye di tidi. ");
INSERT INTO apr_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Tidi pombe ye rumu ke tool kuto mai tani, ngan Yesu ikamata di tooltool yo tiwou aisor, inbe titang le titit a tipadingi ni nga. ");
INSERT INTO apr_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Motong la idewe a ilo rumu lono lo iwete pang di nen, “Ai, nga gelei katangtang a kapadingi ni nen nga? Kase maitiap in imata tiap, bong iken mata leu.” ");
INSERT INTO apr_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Ngan di tooltool tina ngan tilongo yo Yesu iwete nen nga, le nga tingeleraii. Motong la inganga di le imot a tidu tana, inbe ikaua kase tani in tamana le tinana inbe di galiunu yo tiye di tidi nga, ngan leu la tiye tilo ye rumu lono yo kase tani in iken ye i. ");
INSERT INTO apr_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Tilo, motong la itoko bene inbe iwete panga nen, “Talita kum!” Ngan betanga nga punu nen, “Garup maitiap, awete pong nen, kumadit!” ");
INSERT INTO apr_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Motong la pattu leu be garup kase tani in imadit le lo ikodo a ipa. Ngan garup kase tani in rai ki sangaul be ru leu. Inbe di tooltool tina yo tikamata so yo pombe panga nga, ngan titakrai belebele. ");
INSERT INTO apr_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Bong Yesu iwetekala di nen. Iyei ne, “Ken kawete pang di tooltool kapala ye so yo pombe i be.” Motong la iwete pang garup kase tani in tamana le tinana bet tikap so panga a ikan nga. ");
INSERT INTO apr_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Motong la Yesu igege malala tani in, inbe imulu pang ye malala mai ki ye taunu. Ngan le di galiunu titoo lapau a tiye tila. ");
INSERT INTO apr_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Tila tinepe le lal kidi Yuda ke sungunu bet pombe nga, ngan ilo rumu kidi Yuda ke gaongo in lono a lo ipatomonai di tooltool ye betanga ke Maro. Ngan le di tooltool alunu yo tilongo betanga ki nga, ngan titakrai, inbe tiyei ne, “Ona tiap! Tool i ikap patomonaingi le lo galanga ki nga, ngai? Inbe nga gelei a iyei gogo mos matana matana ye ye taunu bene nga? ");
INSERT INTO apr_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Nga gelei, ye i tool ke malala san la bet lod sarara ye nga, too? Tiap! Idi nga lod galanga ye bet ye i tool ke renge rumu leu, inbe tinana la Madia i. Inbe di taini la Yemis ye Yosep, inbe Yuta ye Simon nga, inbe di lini le imot la taye di tanepe ni nga.” Ngan tina tikamata ben ye in tool sorok nga, le tiwala muridi panga. ");
INSERT INTO apr_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Motong la Yesu iwete pang di nen, “Awete pang nen, kumata bet tool iyei Maro koonoo nga, ngan di tooltool ke malala ki ye taunu, inbe di rara ki tipa ye di tooltool yo iye di tinepe ye rumu atu nga, ngan di leu la lodi bet tilongo betanga ki inbe tiraua panga tiap nga.” ");
INSERT INTO apr_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Ngan tina yo tiyei nen nga, le ke bet Yesu iyei toko mos sa ye malala tani, in tiap. Bong ipas le ipaloko bene lo ye di tooltool pattu yo matamatenge ikap di ngan leu. Ngan nen le di tooltool tina yo ikarata di le tinidi dook mata mulu nga, ngan alunu tiap. ");
INSERT INTO apr_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Ngan nen le itakrai, inbe lon sarara ye yo di tooltool ke malala ki ye taunu titara lodi medana panga tiap nga. Yesu igege malala ki tani, inbe ipa a iwakai malala tina yo atu atu nga, inbe ipatomonai di tooltool ye betanga ke Maro. ");
INSERT INTO apr_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Ngan nen le ikiu di galiunu tina yo sangaul be ru nga, ngan man tigaua. Motong la ipatar di le ru ru a bet iwanga di a tila, inbe ikap gurana pang di atu atu bet tinganga di so sidi ye. ");
INSERT INTO apr_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Inbe ikap betanga pang di nen, “Ken kakap so sa ye panga kiang be, bong ole kakap toto kiang ke panga leu. Le so ben porong le depe, inbe pat ke yimoongoo so nga, ngan ken kakap be. ");
INSERT INTO apr_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Inbe loningi ke kemu ngan kaparir, bong ken kakap sorok lonloningi kiang san mulu be. ");
INSERT INTO apr_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Ye kene yo bet kapa le la pombe ye malala atu, le bet tikau ang a titarang ye soo rumu nga, ngan kanepe ye rumu tani in leu, le lo lal yo bet kamadit a kagege malala mai tani in. ");
INSERT INTO apr_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Inbe kumata bet kala ye malala kapala le di tooltool ki lodi bet tikau ang tiap, inbe titar talngadi bet tilongo betanga kiang tiap nga, ngan ye kene yo bet kagege malala tani in nga, ngan kataurai gauru ke kemu du tana, a bet nen ngan iyei ben tarkilanga pang di ye dada dook tiap kidi yo tiyeii pang i.” ");
INSERT INTO apr_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Yesu iwete pang di nen a imot, motong la di galiunu tina ngan timadit a tila la tiwetewete pang di tooltool bet tiportak lodi ye dada dook tiap ke sennene yo tiyei nga. ");
INSERT INTO apr_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Inbe tinganga di so sidi alunu ye di tooltool. Inbe tisalin di tooltool alunu yo matamatenge ikap di nga, ngan ye kai olip surunu, ngan le tinidi dook mata mulu. ");
INSERT INTO apr_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Ye kene tani in bingi ke Yesu idada le ingaua ni mai i le imot, le Erot yo iyei tool kuto mai pang tana mai tani, in ilongo lapau. Le nga di tooltool kapala ngan tiwete bet ye in Yowan tani yo irriu di tooltool i, in ye la o imadit mulu ye ni ke matenge i, ngan la le gurana ki mai san ke bet iyei gogo mos ye nga. ");
INSERT INTO apr_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Inbe di tooltool kapala ngan tiwete bet ye in Ilia. Inbe di kapala ngan tiwete bet ye in Maro koonoo atu dawa ben di Maro koonoo yo ke mukot nga. ");
INSERT INTO apr_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Bong ye kene yo Erot ilongo betanga nen ye in nga, ngan le iwete nen, “Tiap, tool ni o Yowan tani yo akurutu gurini mugu i, in ye la o imadit mulu ye ni ke matenge i.” ");
INSERT INTO apr_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Ngan iwete nen, yesoo mugu ngan iwanga di tooltool ki la tikaua Yowan a tiparama, inbe tipauu ye ooroo medana a titaru lo rumu dook tiap kidi talnga dikidiki lono. Ngan iyei nen, yesoo Yowan ipammoo ye yo iyooloo toonoo Pilip rimana yo ene Erodias in nga. ");
INSERT INTO apr_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Le ye kene tani in ngan Yowan iwete pang Erot nen, “Ong i nga kopsap ye wer koot sa ye yo kouo toom rimana a kuyooloo nga.” ");
INSERT INTO apr_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Tina Yowan iwete nen nga, le nga Erodias lono dook tiap le katen malmal pang Yowan, inbe lono bet iraumate a imata. Bong ngan le ipusye dada sa bet iraumate ye, in tiap, ");
INSERT INTO apr_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","yesoo Erot in lon galanga bet Yowan in tool noonoonoo, inbe ye in tool yo Maro ipootoo panga ye taunu i. Ngan nen le itattadaii le matan kala dook mata. Inbe kanakana ye kene yo Erot ilongo betanga ke Yowan yo iwetewete nga, ngan le lon madoko ye mai san, bong talngana gorengana ye bet ilongo. ");
INSERT INTO apr_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Tinepe, tinepe, a lo tigoro lal ke Erot yo tinana ipasuiu ye i, in pombe. Motong la ye kene tani in Erot iyeie mailang maiyoko atu bet lon ponana ye lal tani yo tinana ipasuiu ye i. Le nga ikiu di tooltool yo itar di a tiyei kuto maimai bet matadi kala tana maimai kapala nga, inbe di tooltool kuto maimai yo matadi kala di tooltool ke patokongo tiye di tooltool maimai ke tana mai Galili nga, ngan man tigaua bet tikan so. Ngan nen le Erodias ikamata ben in lal dook mata tani yo bet iraumata Yowan ye i. ");
INSERT INTO apr_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Le nga ye kene tani in tikan so a tinepe, inbe Erodias natunu garup in ilo rumu lono a lo iki pang di. Ngan le Erot iye di diene tina yo tigaua bet tikan so nga, ngan tikamata le lodi ponana ye. Motong la tool kuto mai tani yo Erot i, in iwete pang garup nene tani in nen, “Ai, kumata le kutorau ye so sa bet akauu pong nga, ngan ole akauu pong.” ");
INSERT INTO apr_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Motong la Erot tani in ipamede betanga medana, inbe iwete moolmool le ete panga. Iyei ne, “Bet kutorau ye so le imot yo ayei kuto mai panga a matak kala nga, ngan ole apoto kataunu le iken ye budanga ru, lo ngan bet akaua budanga atu pong.” ");
INSERT INTO apr_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Le nga garup nene tani in ipas a idu ke tana du itoro tinana nen, “Tinak, soo so bet ole atoro Erot ye bet ikauu pau i?” Motong la tinana iraua betanga ki nen, “Ole kutoru a bet nen ngan ikaua Yowan yo irriu di tooltool i, in kutono pong.” ");
INSERT INTO apr_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Motong la palbe leu be garup tani in imulu tarrai a ilo pang ye Erot lo iwete panga nen, “Au i lok bet kukurutu Yowan yo irriu di tooltool i, in gurini, inbe kunono kutono lo ye tawiri atu a kuwi pau dookoot nga.” ");
INSERT INTO apr_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Erot ilongo betanga nen le nga lon madoko ye mai san. Bong ngan lono bet ipalele betanga ki mulu tiap, yesoo ipamede betanga medana a iwete moolmool le ete la di diene tina yo iye di tikan so nga, ngan matadi oo. ");
INSERT INTO apr_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Le nga pattu leu be Erot tani, in iwanga tool ki atu ke patokongo a ila rumu dook tiap kidi talnga dikidiki lono la isaputu Yowan gurini, inbe ikaua kutono a iman. ");
INSERT INTO apr_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Motong la tool ke patokongo tani in inono Yowan kutono lo ye tawiri atu, inbe ikauu a iman le man ikauu pang garup tani. Motong la garup tani in ikauu pang tinana nga. ");
INSERT INTO apr_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Le nga ye kene tani ngan Yowan di galiunu tilongo betanga ye so yo pombe pang ye nga, motong la timan man tikaua bobono a la titaru ye agoro yo ke tarungu di tooltool matedi i. ");
INSERT INTO apr_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Yesu di aposol ki tina yo iwanga di a tila nga, ngan timulu a timan le man tigaua le tigaliuu, inbe tigasa panga ye urata kidi yo tiyei nga, inbe ye betanga yo tipatomonai di tooltool ye nga. ");
INSERT INTO apr_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Ye kene tani in di tooltool alunu kaiye la tila be timan nga le Yesu iye di aposol ki tina ngan taukadi manga yo bet timaryoo a bet nen ngan tikan so ye i. Le nga iwete pang di aposol ki nen, “Ai, nga ole idi leu tapa le tala ye ni yo taukan tooltool i, inbe tamaryoo kasin ngan.” ");
INSERT INTO apr_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Le nga di leu tiyiri ye ookoo atu a tipoi le tila ye ni atu yo taukan tooltool i. ");
INSERT INTO apr_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Bong di tooltool alunu kaiye la tikamata di yo tila nga, inbe tikilala di. Le nga di tooltool yo ke malala maimai nga, ngan timadit a tidada tana a timugu le tila ye ni balim tani yo Yesu iye di aposol ki bet tila pang ye i. ");
INSERT INTO apr_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Tila pombe, le nga ye kene yo Yesu ipas ke ookoo pono a bet idi pang tana nga, ngan ikamata di tooltool malala mai yo tinepe nga, le lono pang di, yesoo ikamata di leu tinepe dawa ben di sipsip yo taukadi taudi yo bet matan kala di nga. Motong la imadit bet ipatomonai di nga, ngan le ipatomonai di ye so alunu. ");
INSERT INTO apr_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Yesu ipatomonai di tooltool tina ngan le le ke du a nga rrai. Le nga di galiunu tila pang ye la tiwete panga nen, “Ai, ni yo tanepe ye i, i ni balim koonoo sa, inbe nga rrai a nga bet todo. ");
INSERT INTO apr_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Le kuwete pang di tooltool nga a tila pang ye ni kapala, too ye malala kapala yo iken potai nga, a bet nen ngan la di tapdi tiyimi kaningi yo bet tikan nga.” ");
INSERT INTO apr_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Bong ngan Yesu iraua betanga kidi nen, “Tiap! Ole ang tapmu kakap kaningi pang di a tikan.” Motong la tiwete panga nen, “Ona tiap, nga lom bet la amyimi kaningi pang di tooltool malala mai nga, too? Kumata bet la amyimi kaningi ye pat silba ke yimoongoo so ben 200 nga, ngan lom tar bet ole ige di lapau, too?” ");
INSERT INTO apr_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Yesu di galiunu tina ngan tiwete nen, motong la itor di nen, “Kala la kakamata, porong kiang ngo dukumu pi?” Tila la tikamata, motong la timulu man tiwete pang Yesu nen, “Porong kiam ngo dukumu limi, inbe i paranga kiam nga ru leu.” ");
INSERT INTO apr_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Motong la Yesu iwete pang di galiunu bet tipatar di tooltool tina le imot ye budanga atu atu, inbe tiwete pang di a du tiwur dingding lalana pono. ");
INSERT INTO apr_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Le nga di tooltool tina ngan du tiwur ye budanga atu atu. Ngan budanga kapala ngan di tooltool ki ben 100, inbe kapala ngan di tooltool ki ben 50. ");
INSERT INTO apr_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Motong la Yesu ikap porong dukumu limi tina ngan ipa ye i ru nga, inbe itada a matan lo pang ye malala ke Maro, inbe iwete lo ponana ki pang Maro ye. Motong la itepalapala porong tina, inbe ikap pang di galiunu a timalimi di tooltool tina ye. Motong la itekatkat i ru tina, inbe timalimi di ye lapau. ");
INSERT INTO apr_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Ngan le di tooltool tina ngan di le imot tikan le lo kapodi sung dook. ");
INSERT INTO apr_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Motong la di galiunu tiwinnoko porong le i naunu naunu tina yo tiwulai nga, ngan le tipadid ye karei sangaul be ru le lo ipon. ");
INSERT INTO apr_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Ngan di tooltool tina yo tigaua bet tikan so nga, ngan di tamoto leu ngan kinkatingi kidi ben 5,000. ");
INSERT INTO apr_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Tikan so a imot, motong la Yesu iwete pang di galiunu a ipagaigai di bet palbe be tiyiri lo ookoo pono a bet timugu a tila pang malala Betsaida yo iken ke ran koonoo kapala i. Inbe ye ole inepe a iwete pang di tooltool tina a tiparmayiri a tila pang ye malala kidi ngan. ");
INSERT INTO apr_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Le nga itar di a tila le imot, motong la inau a ilo pang kawal bet lo ipatarau. ");
INSERT INTO apr_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Ye kene yo ke idu a bet bong nga, ngan Yesu yetaleu inepe tana, inbe di galiunu tipoi ye ookoo a tila kataunu kat ke ran. ");
INSERT INTO apr_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Ngan Yesu ikamata di galiunu tina yo tirauwat ye poingi nga, yesoo tisosala eng mai. Le nga pang malama, motong la ipa ke kawal a isi a ipa ran pono a idu pang ye di nga. Ngan ipa a idu nga, ngan lono bet ikapus di, ");
INSERT INTO apr_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","50","bong ngan di galiunu tina ngan tikamata le tiyeisa o mariyaua la ipa ran pono i. Ngan nen le titattadai a koodi belebele, yesoo di le imot tikamata. Bong ngan palbe leu inbe Yesu iwete pang di nen, “Katattadai be! I au tani naii. Ken lomu mede leu.” ");
INSERT INTO apr_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Motong la iyiri a ilo ookoo lono a lo iye di tinepe, inbe eng mai tani in imata. Ngan nen le di galiunu tina ngan titakrai belebele, ");
INSERT INTO apr_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","yesoo di ngan lodi galanga dook tiap ye mos yo Yesu iyeii ye porong i, in punu. Ngan di ngan lodi mede mata. ");
INSERT INTO apr_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Yesu iye di galiunu tipoi sautu ran a tila ke koonoo kapala le la tisolo ye malala atu yo ene Genesaret i, inbe tiwata ookoo nango. ");
INSERT INTO apr_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Le nga yeiso bet tipas ke ookoo tani in lono a bet tidi pang tana, ngan di tooltool tikamata Yesu le tikilala. ");
INSERT INTO apr_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Motong la di tooltool tina ngan tidada a tila tika bingi ye malala kapala yo iken ye tana mai tani nga. Ngan nen le ye kene yo di tooltool tilongo bet Yesu ipa le la pombe ye malala in nga, ngan ole tisolo di tooltool yo matamatenge ikap di nga ye sasaka a tila pang ye ni yo Yesu inepe ye i. ");
INSERT INTO apr_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Ngan nen le ye malala maimai le malala yo kakase nga, inbe ye malala kapala yo iken kataunu ye tana mai tani nga, ngan kumata bet Yesu ipa le la pombe ye malala tina ngan atu nga, ngan ole tikap di tooltool kidi yo matamatenge ikap di nga, ngan du titar di mallangana ye ni ke yawaringi so. Inbe titoro Yesu a timangmang ye bet imalum pang di tooltool tina, a bet nen ngan titoko sousoungu ki matana leu. Ngan le di tooltool tina le imot yo titoka nga, ngan tinidi dook mata mulu. ");
INSERT INTO apr_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Di Paresi tiye di pannoongoo pattu ke wer ke Maro ngan tipa ke Yerusalem a tisi le si tigaua le tigaliui Yesu a tiye tinepe. ");
INSERT INTO apr_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","4","Ngan di Paresi tina tiye di Yuda kapala le imot, ngan tiparama momo ke di sasa kidi yo ke mugu ngan a tise. Ngan nen le kumata bet tila tipa ye ni ke yawaringi so le bet timulu a timan nga, ngan o ke bet tikan so tiap, bong ole titoo momo kidi ke ngasingi bedi mugu, ngan la bet tikan so nga. Inbe di ngan titoo momo ke di sasa kidi ngan alunu san ye ngasingi ruku le dap inbe bor le so kapala lapau. Ngan tinepe, tinepe, le nga tikamata Yesu di galiunu pattu yo titoo momo kidi ke ngasingi bedi in tiap. Ngan nen le lodi dook tiap pang di, yesoo di ngan bedi giri leu inbe tikap so a tikan. ");
INSERT INTO apr_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Le nga di Paresi tina ngan tiye di pannoongoo ke wer ke Maro ngan titoro Yesu nen, “Ai, nga gelei bet di galium ngo titoo dada le momo kidi sasa kiam tiap, bong bedi giri leu inbe tikap so a tikan nga?” ");
INSERT INTO apr_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Motong la Yesu iraua betanga kidi nen, “Betanga ke Maro yo mugu ngan ikap pang Esai a iwetewete yang nga, ngan moolmool sa. Ang nga tooltool ke kaplungunu sa, dawa ben betanga tina yo iwodo a iken ye Rau ke Maro nga. Ngan betanga tina ngan iwete nen, ‘Di tooltool nga tiyitmaka ek ye koodi pono leu, bong lodi yo bet pau nga, ngan iken manga mooloo yau. ");
INSERT INTO apr_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Di ngan tiwete bet tipatomonai di tooltool ye betanga ke Maro yo moolmool i, bong tiap, tipatomonai di tooltool ye dada le momo yo ke di sasa kidi nga leu. Ngan la le sungunu kidi yo kanakana ngan tisung pau ye nga, ngan taukan kanono.’ ");
INSERT INTO apr_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Ngan nanga, ang nga kawil wer yo ke Maro nga a iken, inbe kaparama dada le momo kidi tooltool yo tipatomonai ang ye bet katoo nga.” ");
INSERT INTO apr_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Motong la iseke betanga ki mulu nen, “Nga gelei, lomu tar bet nga o kayeie dada dook mata ye yo kawala murimu pang wer yo ke Maro nga, inbe ang tapmu la katoo dada le momo yo kiang nga, too? ");
INSERT INTO apr_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Kakamata, wer ke Maro atu yo Mose iweta in nen, ‘Kuraua pang tamam le tinam a kulongo betanga kidi.’ Inbe wer san in nen, ‘Bet tool iwete betanga dook tiap a bet igarungu tamana too tinana ye nga, ngan karaumate a imata.’ ");
INSERT INTO apr_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Bong ang nga dada kiang yo kapatomonai di tooltool ye i, in nen. Kumata le tool atu, in pat le so ki bet ilono tamana too tinana ye, bong iwete pang di nen, ‘So kiau yo bet alonang ye a kakap yau nga, ngan awetekala a akap ye lo ponana kiau pang Maro oo,’ ");
INSERT INTO apr_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","ngan kumata bet iyei nen nga, ngan ang nga kawete bet tool tani in ke bet ipamulu so tina ye Maro inbe ilono tamana too tinana ye tiap. ");
INSERT INTO apr_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Le ye dada kiang yo kayeii nen i, in ang nga katoo momo kiang ang tapmu, inbe karautoo betanga ke Maro ye. Inbe dada alunu mulu yo kayei nga, ngan gaongo leu.” ");
INSERT INTO apr_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Yesu iwete pang di nen a imot, motong la ikiu di tooltool malala mai tina ngan mulu a timan pang ye man iwete pang di nen. Iyei ne, “Ang le imot katar talngamu ye betanga kiau i, inbe lomu kaua urata ye. ");
INSERT INTO apr_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","16","So yo bet tool ikani ye koonoo a ilo kapono lono i, in ke bet igarungu le giri leu ye Maro matana tiap. Bong so yo iken tool lono, lo ngan bet ipas ye koonoo a isi in la bet igarungu le giri leu ye Maro matana i.” ");
INSERT INTO apr_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Yesu iwete pang di tooltool malala mai tina nen a imot, motong la igege di sila tinepe, inbe ilo pang rumu lono. Motong la di galiunu titor panini ye betanga tani yo ikatte, in punu. ");
INSERT INTO apr_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Le nga Yesu iwete pang di nen, “Ona, ang nga o taukamu lo galanga lapau, too? Nga gelei, ang nga ke bet kakap betanga kiau palbe tiap, too? Kalongo, so yo bet tool ikani ye koonoo a ilo kapono lono i, in ke bet igarungu le giri leu ye Maro matana tiap, ");
INSERT INTO apr_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","yesoo bong so yo nen nga, ngan lo igarungu tool tani in lono tiap. Bong ole lo iken ye matuk le kodokodo ki leu, lo ngan bet itoo dada ki a idu pang tana.” Ngan tina Yesu iwete nen nga le ipagalanga lodi nen, bet kaningi tina yo matana matana nga le imot, ngan dook mata ke bet takan. ");
INSERT INTO apr_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Motong la iwete mulu nen, “So yo iken tool lono, lo ngan bet ipas ye koonoo a isi in la bet igarungu le giri leu ye Maro matana i. ");
INSERT INTO apr_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Inbe dada tina yo awete ye bet ipas ke tool lono a isi pang diki, ngan nen; lono dook tiap pang tool san, inbe ikapsap ye dada ke di kerenge, inbe iyei dada dook tiap ke pinnau le raumatenge di tooltool a timmata, inbe iyei bauk. ");
INSERT INTO apr_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","Inbe dada dook tiap yo ke matana so in iso panga, inbe lon kases pang di diene, inbe ikap llungunu ye di tooltool, inbe taukan moomoonoo ye dada dook tiap yo iyei mallangana nga, inbe matana gorengana ye so kidi diene a lono dook tiap pang di, inbe illung pang di tooltool a igarung edi, inbe koon payiti a iyei dada dook tiap kapala ben di tooltool yo lodi galanga ye Maro tiap nga. ");
INSERT INTO apr_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Ngan dada dook tiap tina nga le imot iken tool lono, lo ngan bet ipas a isi ke diki nga, ngan ole igarungu tool le giri leu ye Maro matana.” ");
INSERT INTO apr_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Motong la Yesu imadit a igege malala tani, inbe ipa le ila ye ni yo iken potai pang ye malala mai Taia i. Ngan lono bet di tooltool tikamata tiap, le nga idewe a ilo rumu atu lono. Bong ngan tikamata le di tooltool lodi galanga ye ni yo inepe ye i. ");
INSERT INTO apr_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","Ngan garup atu yo so sidi idiwidiwi natunu garup kase i, in ilongo tina yo Yesu iman inepe nga, le nga palbe leu be ila le la igun turunu du kene punu, inbe itoru a imangmang ye bet inganga so sidi a ikoo ye natunu garup tani. Ngan garup tani in ipa ye rara kidi Yuda tiap, inbe tinana ipasuiu la Ponisia ke tana mai Siria ngo. ");
INSERT INTO apr_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Le nga Yesu iwete panga nen, “Kumata bet takap kaningi kidi kakase a takatte mugu pang di gaunu bet tikan nga, ngan in dada dook tiap. Bong kulkulunu ngan ole tapakan di kakase le kapodi sung go, lo ngan bet takatte kaningi naunu naunu yo kidi nga, ngan pang di gaunu kooti.” ");
INSERT INTO apr_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Motong la garup tani in iraua betanga ki nen, “E, Tool Mai, betanga kiong in moolmool. Bong ye kene yo di kakase tikan so ye in nga, ngan di gaunu yo tinepe kakawa parmana nga, ngan ole tikan kaningi morrana kidi yo imaruru du kakawa parmana, ngan lapau.” ");
INSERT INTO apr_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Yesu ilongo tina yo iwete nen nga, le nga iyei ne, “Ong in kuraua betanga kiau dook mata san, le lom ponana, inbe kumulu a kula pang rumu kiong. So sidi igege natum garup tani oo.” ");
INSERT INTO apr_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Motong la imulu a ila pang rumu ki, ngan ikamata natunu tani in so sidi igege a ila inbe tinini dook mata a ikenen moi pono ki. ");
INSERT INTO apr_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Motong la Yesu imadit a igege tana mai yo malala mai Taia iken ye i, inbe ila pang ye malala mai san yo ene Saidon i, motong la bet imulu ngan iwakai le ipa kataunu ye tana yo ene Dekapolis i, le du pombe ye ran Galili. ");
INSERT INTO apr_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Idu pombe le inepe nango, motong la di tooltool pattu tikaua tool atu a tila pang ye. Ngan tool tani in talngan dikidiki, inbe men modo le ke bet iwetewete tiap lapau. Le nga tila, motong la titoro Yesu a timangmang ye bet itara bene lo tool tani in pono, a bet nen ngan tinini dook mata mulu. ");
INSERT INTO apr_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Le nga Yesu ikaua tool tani in a yeru tigege di tooltool malala mai tina le tila manga mooloo kasin, inbe itar bene boroborene lo tool tani in talngana lono. Motong la ikoronai ngoonoo lo ye bene boroborene, inbe itar lo ye tool tani in mene. ");
INSERT INTO apr_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Motong la itada le matana lo pang ye malala ke Maro, inbe itang le iparama amunu a iwete pang tool tani nen, “Epata!” Ngan betanga tani in punu nen, “Kupanganga!” ");
INSERT INTO apr_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Ngan le pattu leu be talngana gimono ngan imapolo, inbe mene iyolo le iwetewete dook mata mulu lapau. ");
INSERT INTO apr_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Motong la Yesu iwetekala di bet ken tikaua bingi pang tool sa ye so yo pombe in be. Bong tiap! Moolmool iwete betanga nen pang di kaiye, bong ngan di tooltool tina ngan tikaua bingi ye le ikenen leu, le bingi ki ingaua ni. ");
INSERT INTO apr_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Ngan nen le di tooltool tina le imot yo tilongo bingi ki nga, ngan titakrai belebele. Inbe tiyei ne, “Ona tiap! So le imot yo iyei nga, ngan dook mata san. Le kakamata, ikarata di tooltool yo talngadi dikidiki inbe medi modo nga, le tilongo betanga inbe tiwetewete.” ");
INSERT INTO apr_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Ye kene tani in di tooltool malala mai timan tigaua mulu a tinepe le le kaningi kidi imot, motong la Yesu ikiu di galiunu a timan pang ye man iwete pang di nen, ");
INSERT INTO apr_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Au i lok pang di tooltool nga san, yesoo timan a man taye di tanepe nanga ye ke tol oo, le dookoot nga taukadi so yo bet tikani i. ");
INSERT INTO apr_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Kumata bet atar di a tipa ye pitolo kidi a tila pang rumu kidi nga, ngan ole matadi taltalai a timol dada, yesoo di tooltool tina ngan kapala tipa ke ni mooloo san la le timan ni nga.” ");
INSERT INTO apr_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Motong la di galiunu tiraua betanga ki nen, “Ona, idi nga tanepe ye ni balim koonoo sa! Ole takap porong ngai bet tapakan di tooltool malala mai nga ye i?” ");
INSERT INTO apr_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Motong la Yesu itor di nen, “Porong kiang ngan dukumu pi?” Ngan di galiunu tina tiyei ne, “Porong kiam nga dukumu limi be ru.” ");
INSERT INTO apr_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Motong la Yesu iwete pang di tooltool malala mai tina bet du tiwur tana. Inbe ikap porong tina yo limi be ru nga, a iwete lo ponana ki pang Maro ye. Motong la itepalapala, inbe ikap pang di galiunu bet la timalimi di tooltool tina ye. Ngan le di galiunu tina ngan tiyei ben yo iwete pang di nga. ");
INSERT INTO apr_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Inbe di ngan i kidi paranga pattu lapau, le nga tikap pang Yesu a iwete lo ponana ki pang Maro ye. Motong la iwete pang di galiunu bet la timalimi di tooltool tina ngan ye. ");
INSERT INTO apr_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Ngan le di tooltool tina ngan tikan le kapodi sung dook mata. Motong la Yesu di galiunu tiwinnoko kaningi naunu naunu tina yo iken nga, ngan a tipadid ye karei limi be ru le lo ipon. ");
INSERT INTO apr_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Ngan di tooltool tina yo tigaua a tikan so nga, ngan kinkatingi kidi ben 4,000. Le nga tikan so a imot, motong la Yesu itar di a timulumulu a tila. ");
INSERT INTO apr_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Motong la palbe leu be iye di galiunu tiyiri ye ookoo kidi, inbe tikooi a tisaut a tila pang tana mai Dalmanuta nga. ");
INSERT INTO apr_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Tila pombe Dalmanuta a tinepe, motong la di Paresi pattu timan a man tiye Yesu tiwetewete a tiparsu ye betanga. Ngan lodi bet titoua, le nga titoru bet iyeie mos sa a iyei tarkilanga panga ben Maro yo inepe ye malala ki ete ni, in la iwanga a isi i. ");
INSERT INTO apr_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Bong ngan Yesu lon moo mai san ye di. Le nga iyei ne, “Nga gelei bet ang tooltool yo ke dookoot nga kator bet kakamata mos sa a iyei tarkilanga pau nga? Awete pang moolmool nen, au i o ke bet apitnaia tarkilanga sa a kakamata, ngan tiap.” ");
INSERT INTO apr_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Motong la igege di tooltool tina ngan sila tinepe, inbe iye di galiunu timulu a du tiyiri lo ookoo pono, motong la tipoi a tila pang ran koonoo kapala nga. ");
INSERT INTO apr_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Yesu di galiunu lodi kalli le mala bet tikap toko porong dukumu sa mulu tiap, bong dukumu ataleu la tikauu a idu ookoo pono i. ");
INSERT INTO apr_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Motong la Yesu ikap noonoongoo pang di nen, “Ken kakap tutang, inbe kakauwai yang dook leu ye yis kidi Paresi tiye Erot.” ");
INSERT INTO apr_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Ye kene yo di galiunu tilongo Yesu iwetewete ye so maitiap tani yo ilo ye porong ngan iyeii a isung le imot in nga, ngan di tapdi tiwetewete a tiyei ne, “Iwete nen nga, yesoo ye yo lod kalli le takap toko porong siap nga.” ");
INSERT INTO apr_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Bong ngan Yesu lon galanga ye so yo tiwetewete ye ngan oo, le nga itor di. Iyei ne, “Ai, nga gelei bet ang tapmu kawetewete ye yo kakap toko porong siap nga? Ang nga kakamata so yo ayei nga, e lomu galanga yau tiao, too? Ang nga o kutomu mede mata dawa ben pat, too? ");
INSERT INTO apr_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Ang nga matamu, bong nga gelei a kakamata so sa ye tiap nga? Inbe ang nga talngamu, bong nga gelei a kalongo betanga ye tiap nga? Ang nga o lomu tut pitiap yege, too? ");
INSERT INTO apr_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Oo, ye kene yo atepalapala porong dukumu limi pang di tooltool 5,000 ye in nga, ngan le kapadid karei pi ye porong naunu naunu tina le lo ipon nga?” Ngan di galiunu tina ngan tiyei ne, “Karei sangaul be ru.” ");
INSERT INTO apr_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Motong la itor di mulu nen, “Inbe ye kene yo atepalapala porong dukumu limi be ru pang di tooltool 4,000 ye in nga, ngan le kapadid karei pi ye porong naunu naunu tina le lo ipon nga?” Ngan tiyei ne, “Karei limi be ru.” ");
INSERT INTO apr_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Motong la Yesu iwete pang di nen, “Ngan nga gelei a le lomu galanga pitiao nga?” ");
INSERT INTO apr_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Yesu iye di galiunu tina ngan tila pombe Betsaida, motong la di tooltool pattu tikaua tool atu yo matan kis in a timan pang ye Yesu. Timan, motong la tiwete panga, inbe timangmang ye bet itara bene lo ye tool tani a bet nen ngan matana dook mata. ");
INSERT INTO apr_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Le nga Yesu itoko tool tani yo matan kis in bene, inbe idede a yeru tidu ke diki ke malala tani in. Motong la ikoronai ngoonoo ilo ye tool tani in matana, inbe itara bene lo pono. Inbe itoru nen, “Kumata so sa lapau, too?” ");
INSERT INTO apr_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Ngan tool tani in matana pang ete, inbe iwete nen, “E, akamata di tooltool tipa, bong igalanga tiap, dawa ben kai ila be iman nga.” ");
INSERT INTO apr_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Tina iwete nen nga, le Yesu itara bene mulu lo ye tool tani in matana. Ngan le matana irere le dook mata, inbe ikamata so le imot iken mallangana. ");
INSERT INTO apr_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Motong la Yesu iwete panga nen, “Ken kupa le kulo malala lono be, bong kupa so le kudi rumu kiong.” ");
INSERT INTO apr_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Yesu iye di galiunu titoo dada a tilo pang ye malala kapala yo iken potai pang ye malala mai Sisaria Pilipai i. Ngan tipa dada go, inbe itor di galiunu tina nen, “Ai, di tooltool tiwete bet au i sei?” ");
INSERT INTO apr_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Ngan tiyei ne, “Di tooltool kapala tiwete bet ong in Yowan yo irriu di tooltool i, inbe kapala ngan tiwete bet ong in Ilia. Inbe di tooltool kapala ngan tiwete bet ong in Maro koonoo atu yo ke mukot nga.” ");
INSERT INTO apr_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Motong la Yesu itor di mulu nen, “Ngan ang nga, kawete bet au i sei?” Ngan Pita iraua betanga ki nen, “Ong in Kirisi, tool yo Maro ipootoo bet si ipamulu di tooltool ki ye so dook tiap yo bet igarung di i.” ");
INSERT INTO apr_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Motong la Yesu iso lodi bet ken tiwete nini pang tool sa be. ");
INSERT INTO apr_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Motong la Yesu imadit a ipatomonai di galiunu tina nen, “Tool Moolmool Ke Maro ole isolo moonoo le masngana alunu kaiye. Inbe di tooltool maimai kidi Yuda tiye di tooltool maimai ke paroranga so pang Maro, inbe di pannoongoo ke wer ke Maro ole tiwala muridi panga inbe tiraumate le imata. Bong ole iken ye ke ru, lo ngan bet ye tol ki ngan ole imadit mulu ye ni ke matenge.” ");
INSERT INTO apr_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Yesu iwete pang di a ipagalanga lodi ye betanga i, motong la Pita ikauu a yeru leu tila manga mooloo kasin, inbe ipasak panga a bet ilele ye betanga yo iweta i. ");
INSERT INTO apr_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Bong Yesu idalele a matana pang ye di galiunu kapala, inbe ipasak pang Pita. Iyei ne, “Satan, kukoo yau a kudu ke murik. Betanga yo kuwete nga, ngan kutoo Maro lono tiap, bong kutoo di tooltool ke tana lodi.” ");
INSERT INTO apr_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Motong la ikiu di tooltool malala mai tina ngan tiye di galiunu man tigaua, inbe iwete pang di nen, “Kumata tool atu lono bet man itoo au nga, ngan ye taunu irautoo le du inepe lopo, inbe isolo kai palasingi ki a itoo au. ");
INSERT INTO apr_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Yesoo, sei tool yo lono mai san ye nepongo ki ke tana i mai mata a iparama i, in ole ilene. Bong sei tool yo lono mai san ye nepongo ki ke tana i tiap, inbe iraia tinini le imot pau bet iyei urata ke bingi dook mata kiau i, in ole ikaua nepongo dook mata yo taukan motingi i. ");
INSERT INTO apr_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Inbe kumata tool atu bet iyau balingi matana matana le imot ke tana i panga, lo ngan bet imata a ila nga, ngan ole balingi tina ngan iloni balai? ");
INSERT INTO apr_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Too, soo so dook mata ke bet tool sa ikauu pang Maro a bet nen ngan iraukolo nepongo ki yo ilene in ye i? So siap! ");
INSERT INTO apr_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Di tooltool yo dookoot tinepe nga, ngan tikapsap ye dada yo dook tiap nga, inbe tiwala muridi pau a tiyei dawa ben garup yo idada nintooroo la iyei bauk i. Ngan la kumata tool atu bet moomoonoo yau inbe ye betanga kiau le ipataukala ye di tooltool tina ngan matadi nga, ngan ye kene yo bet Tool Moolmool ke Maro imulu a isi ye i, in ole moomoonoo ye tool tani lapau. Ye in ole iye di bangabangana ke Maro yo ipootoo di panga ye taunu nga, ngan tisi inbe ole ipitnaia Tamana lulngana yo maiyoko in mallangana a di tooltool tikamata, bong ye kene tani ole moomoonoo ye di tooltool yo mugu ngan moomoodi ye nga.” ");
INSERT INTO apr_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Motong la Yesu iwete pang di mulu nen, “Awete pang moolmool nen, di tooltool kapala yo dookoot taye di takododo ni nga, ngan ole timmata tiao inbe tikamata dada yo Maro bet matan kala di tooltool ki ye i, in ipa ye gurana ki ole pombe mallangana.” ");
INSERT INTO apr_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Tinepe le nga ke limi be atu iman a ila, motong la Yesu ikaua Pita iye Yemis inbe Yowan a iye di tipa a tilo pang kawal yo kutono lo ete yege i, bet lo di leu tinepe nango. Tilo, motong la di galiunu tikamata tina yo tinini idik le san mulu nga. ");
INSERT INTO apr_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Inbe sousoungu le mala ki nga ikoko le milmilbe nga. Ngan di tooltool yo ke tana i nga, ngan sa ke bet ingas so ki le ikoko nen tiap yege. ");
INSERT INTO apr_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Motong la di galiunu tina yo tol nga, ngan tikamata Ilia iye Mose yo pombe a tiye Yesu tiwetewete nga. ");
INSERT INTO apr_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Le nga Pita iwete pang Yesu nen, “Pannoongoo, nga dook mata ke bet idi nga tanepe nanga. Le kumalum pam, a bet nen ngan amre badabada tol; atu pong, san pang Mose, inbe san pang Ilia.” ");
INSERT INTO apr_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Ngan Pita isere betanga yo bet iweta i, ngan la le iwete sorok nen nga, yesoo iye di diene ngan titattadai belebele. ");
INSERT INTO apr_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Motong la eng tene atu isi le si rur ki iloko la podi, inbe tool atu kalngana pombe eng tene tani lono in iwete nen. Iyei ne, “Tool in au Natuk yo lok panga mai san i. Le kalongo betanga ki yo bet iwete pang nga!” ");
INSERT INTO apr_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Ngan tool tani kalangana iwete nen a imot, le palbe leu inbe Yesu di galiunu tina bet matadi sarai, ngan tikamata toko tool siap. Bong Yesu yetaleu la iye di tinepe i. ");
INSERT INTO apr_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Motong la ye kene yo iye di galiunu tipa ke kawal a bet timulu a tidu ye in nga, ngan iwete betanga medana pang di bet ken tigasagasa pang tool sa ye so yo tikamata, ngan be. Bong bet iken ye di leu le ilo ye lal yo bet Tool Moolmool ke Maro igege ni ke matenge a imadit mulu ye i. ");
INSERT INTO apr_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Le nga di galiunu tina ngan tilongo koonoo a titoo betanga ki le so tina ngan iken ye di leu. Inbe nga di tapdi tiwetewete a tiyei ne, “Oo, betanga yo iwete bet ole igege ni ke matenge a imadit mulu ye i, in punu balai?” ");
INSERT INTO apr_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Motong la titoru nen, “Nga gelei a di pannoongoo ke wer ke Maro tiwete bet Ilia ole imugu a isi, lo ngan bet Mesaia itoo nga?” ");
INSERT INTO apr_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Ngan Yesu iraua betanga kidi nen, “Betanga in moolmool. Ilia ole imugu a isi bet si ikarata so le imot yo iken dook tiap nga, le iken dook mata. Bong ole gelei ye betanga yo tiwodo mukot lo ye Rau ke Maro nga? Ngan betanga tina ngan nen, bet Tool Moolmool ke Maro ole isolo masngana mai san, inbe di tooltool ole tiwala muridi panga. ");
INSERT INTO apr_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Bong bet awete pang nen, Ilia tani in isi oo. Inbe dada dook tiap le imot yo di tooltool lodi bet tiyei panga nga, ngan tiyei panga moolmool, dawa ben betanga tina yo tiwodo ye a iken ye Rau ke Maro nga.” ");
INSERT INTO apr_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Ye kene yo Yesu iye di galiunu tol tina ngan tipa le du pombe pang ye di galiunu kapala nga, ngan tikamata di tooltool malala mai yo tigaua a tigaliu di nga. Inbe di pannoongoo ke wer ke Maro pattu ngan tiye di tiparsu ye betanga. ");
INSERT INTO apr_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Ngan yeiso bet di tooltool malala mai tina ngan tikamata Yesu, ngan le titakrai belebele inbe palbe leu be tidada a tila le la tiwete lo ponana kidi panga. ");
INSERT INTO apr_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Motong la Yesu itor di galiunu tina nen, “Ai, soo so kaye di tooltool ngan kaparsu ye i?” ");
INSERT INTO apr_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Ngan tool atu yo inepe kataunu ye di tooltool malala mai tina i, in imadit a iraua betanga ki nen, “Atoo, Pannoongoo, au i akaua natuk la aman pang yong nga, yesoo so sidi idiwidiwoo a iyeii le koon kis le ke bet iwetewete tiap. ");
INSERT INTO apr_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Kanakana ngan kumata bet so sidi tani in imadit ye nga, ngan ole ikatte du tana a isodangadanga a ngoon sian du, inbe ikanen dongana a iparrasa. Ngan la aman bet man ator di galium nga bet tinganga so sidi ye, bong ngan ke bet tiloni tiap.” ");
INSERT INTO apr_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Motong la Yesu iyei ne, “Ona tiap! Ang di tooltool yo dookoot kanepe nga, ngan katara lomu le imede ye Maro tiap. Nga ole ke pi mulu bet nen ngan ayang tanepe inbe awete a kayei dada yo nen ngan mulu ye nga? Oo, kakaua kase in a iman yau.” ");
INSERT INTO apr_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Motong la tikaua kase tani a ila pang ye nga. Bong yeiso bet so sidi tani in ikamata Yesu, ngan le pattu leu be idiwidiwi kase tani a ikatte du tana du itangarur a itapulpul, inbe ngoon sian du ye koonoo. ");
INSERT INTO apr_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Motong la Yesu itoro kase tani in tamana nen, “Ngan iyei nen ye taudu pi koot?” Le nga tamana iraua betanga ki nen, “So i pombe panga ye kene yo ye kene kase go nga. ");
INSERT INTO apr_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Inbe ye kene kapala bet so sidi tani in imadit ye nga, ngan ole ikatte lo ei lono, too ran lono, inbe ikapge bet iraumate a imata. Bong kumata le kukanamai ong ke bet kuyei so nen nga, ngan lom pam a kulonam.” ");
INSERT INTO apr_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Motong la Yesu iyei ne, “Nga gelei a kuwete pau, bet kumata le akanamai au ke bet ayei so nen, ngan ayei nga? Awete pong nen, kumata tool bet itara lono medana nga, ngan so sa yo bet imoo pang Maro bet iloni ye, ngan tiap.” ");
INSERT INTO apr_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Le nga pattu leu be kase tani in tamana koonoo le mai. Iyei ne, “Au i atara lok medana, bong lo medana kiau i mai mata tiap. Le lok bet kulonau a atara lok le imede moolmool.” ");
INSERT INTO apr_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Ye kene tani in Yesu ikamata di tooltool malala mai tina ngan timadit bet tidada a tila pang ye di nga, le nga ipasak pang so sidi tani. Iyei ne, “Ong so sidi yo kuyeie kase i a koonoo le talngana kisis i, in awete le kook mede ye betanga pong bet kupas a kugege le kumulukala mulu be.” ");
INSERT INTO apr_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Motong la so sidi tani in isulu paue a ikatte kase tani le idu tana a itangarur belebele, inbe ipas a ila. Ngan ipas a ila inbe kase tani in sila iken le tau pulesingi ye dawa ben tool imata nga. Le nga di tooltool malala mai tina ngan tikamata le tiyei ne, “Ona, o imata oo.” ");
INSERT INTO apr_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Bong ngan Yesu itoko bene inbe ipamaditi le lo ikodo. ");
INSERT INTO apr_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Motong la imulu a ila le ilo rumu lono, le lo iye di galiunu leu tinepe. Motong la titoru nen, “Ai, nga gelei a le bet amnganga so sidi ni, ngan le ikoo ye tiap nga?” ");
INSERT INTO apr_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Ngan Yesu iyei ne, “So sidi yo nen nga, ngan ole tanganga di ye dada ke pataraungu leu.” ");
INSERT INTO apr_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Motong la Yesu iye di galiunu tigege malala tani, inbe tipa so le tila tana mai Galili. Ngan lono bet di tooltool sa lodi galanga ye ni yo bet la tinepe ye in tiap, ");
INSERT INTO apr_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","yesoo lono bet di leu tinepe inbe ipatomonai di. Nen le iwete pang di nen, “Ole titara Tool Moolmool ke Maro la di tooltool bedi, a bet nen ngan tiraumate a imata. Ngan ole iken ye ke ru, lo ngan bet ye ke tol ki, ngan ole imadit mulu ye ni ke matenge.” ");
INSERT INTO apr_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Ngan di galiunu tina ngan tilongo patomonaingi ki, ngan lodi galanga ye betanga ki yo iwete ngan punu tiap. Bong titattadai bet titoru, a bet nen ngan iwete nin pang di nga. ");
INSERT INTO apr_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Yesu iye di galiunu tipa a la pombe malala mai Kapenam, le nga tilo rumu lono. Motong la itor di galiunu tina nen, “Ai, soo so tapa dada a taman ngan kaweteweta a kaparsu ye i?” ");
INSERT INTO apr_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Bong di galiunu tina ngan tiwetewete tiap, sila tikodo be tipalongo leu, yesoo timan dada ngan tiwetewete a tiparsu ye sei tool bet iyei kuto mai a imugu pang di i. ");
INSERT INTO apr_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Motong la Yesu du iwur, inbe ikiu di galiunu tina yo sangaul be ru nga, ngan a timan pang ye man iwete pang di. Iyei ne, “Sei tool yo lono bet ene mai le imugu pang di diene i, in ole ye taunu irautoo ene le idu lopo, inbe iyei ben kapraingi a ilon di tooltool nga le imot.” ");
INSERT INTO apr_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Motong la ikaua kase mai tiap atu man ipatokode lo ikodo kataunu kidi. Motong la iwookoo, inbe iwete pang di galiunu nen, ");
INSERT INTO apr_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Kumata sei tool bet lon tutau le ikaua kase mai tiap yo nen i a iloni nga, ngan ye in ikau au a ilonau lapau. Inbe kumata sei tool bet ikau au a ilonau nga, ngan ye in ilonau leu tiap, bong ilono Tamak yo iwangau a asi i, in lapau.” ");
INSERT INTO apr_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Motong la Yowan iwete pang Yesu nen, “Pannoongoo, am nga amkamata tool atu ipootoo em, inbe inganga di so sidi ye. Le amwete panga a amlele, yesoo ye in inepe ye budanga kiidi tiap.” ");
INSERT INTO apr_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Bong ngan Yesu iwete pang di nen, “Tiap, ken kalele be! Kumata tool atu bet iyei mos ye gurana ke au ek nga, ngan ke bet palbe leu be iportak a igarungau ye betanga dook tiap, ngan tiap. ");
INSERT INTO apr_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Yesoo, tool yo iyei koi paidi tiap i, in ben tool kiidi. ");
INSERT INTO apr_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Awete pang moolmool nen, kumata tool sa bet ikaua ran ruku atu pong bet kuyinu yesoo ong in tooltool ke Kirisi nga, ngan Maro ole lon kali urata ki tiap, le pang dama ni ngan ole ikaua balingi dook mata panga ye urata kootoonoo ki.” ");
INSERT INTO apr_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Motong la Yesu iwete mulu nen, “Kumata tool atu bet iyei di kakase maimai tiap yo titara lodi medana pau koot nga, ngan atu le bet ikapsap ye sennene nga, ngan tool tani in ole isolo urata moonoo dook tiap. Le moolmool, kumata bet tituku pat somai yo ke raunganingi dingding patunu ngan atu lo gurini, inbe tikatte du tiek lono a bet nen ngan idaup a imata nga, ngan ben dook kasin, yesoo bong urata moonoo dook tiap yo bet isola ye dada dook tiap ki tani yo iyeii i, in ole dook tiap le dook tiap ki taunu. ");
INSERT INTO apr_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","Ngan nanga, kumata le bem atu bet iyolong la kuyei sennene nga, ngan kusaputu a kotte. Dook mata in nen, bet bem ataleu, ngan la bet ole kulo ye malala ke Maro lo kunepe ye nepongo dook mata yo iken nen le taukan motingi in nga. Bong dook tiap in nen, bet bem ru iken ngan ole tiyolong la kuyei sennene, a nen ngan tikatte ong a kudu ye malala ke masngana yo ei ki ikan nen le taukan motingi i. ");
INSERT INTO apr_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","Inbe kumata le kem atu bet iyolong la kuyei sennene nga, ngan kusaputu a kotte. Dook mata in nen, bet kem ataleu nga, ngan la bet ole kulo ye malala ke Maro lo kunepe ye nepongo dook mata yo iken nen le taukan motingi in nga. Bong dook tiap in nen, bet kem ru iken ngan ole tiyolong la kuyei sennene, a nen ngan tikatte ong a kudu ye malala ke masngana. ");
INSERT INTO apr_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Inbe matam lapau, kumata le matam atu bet iyolong la kuyei sennene nga, ngan kupaii a kotte. Dook mata in nen, bet matam ataleu nga, ngan la bet ole kulo kugaua ye di tooltool yo Maro bet matan kala di nga. Bong dook tiap in nen, bet matam ru iken ngan ole tiyolong la kuyei sennene, a nen ngan tikatte ong a kudu ye malala ke masngana. ");
INSERT INTO apr_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Ngan ye malala tani, in ‘di motomoto maimai tiap yo bet tikan di tooltool nga, ngan timatamata tiap. Inbe ei ki ikan nen le taukan motingi.’ ");
INSERT INTO apr_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Awete pang nen, yesoo di tooltool ke paroranga so pang Maro titirtir tiek lo ye so yo bet tiyei paroranga ye, ngan pono, lo ngan bet tidaun ye ei, a nen ngan dook mata ye Maro matana. Ngan gaongo leu, urata moonoo ole pombe pang yang a itou ang, a bet nen ngan kayei ben so ke paroranga yo titirtir tiek lo pono lo ngan bet tidaun nga. ");
INSERT INTO apr_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Tiek in so dook mata, bong kumata bet gurana ki imot nga, ngan ole kuyeie tiek tani in balai bet iyei tiek mulu nga? Dada siap! Ngan nanga, ang nga ole kayei dawa ben tiek dook mata, inbe kapaposo lo silene ke Maro pang di tooltool, a bet nen ngan kaye di kagauagaua dook mata.” ");
INSERT INTO apr_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Yesu imadit a igege ni tani in, inbe ipa le la pombe tana mai Yudia yo iken ke ran Yodan koonoo kapala i. Ngan le di tooltool malala mai timan tigaua pang ye mulu. Le nga itoo dada yo kanakana ngan iyeii i, inbe ipatomonai di ye betanga ke Maro. ");
INSERT INTO apr_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Motong la di Paresi pattu timan pang ye bet man titoua. Le nga titoru nen, “Ai, bet tamoto atu isukraia rimana nga, ngan idada wer yo kiidi in pono, too tiap?” ");
INSERT INTO apr_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Motong la Yesu iraua betanga kidi nen, “Wer yo Mose ikap pang nga, ngan iwete balai?” ");
INSERT INTO apr_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Ngan tiyei ne, “Mose imalum pam bet kumata le tamoto atu lono bet isukraia rimana nga, ngan ole iwodo rau ke parsukraingi, lo ngan bet ikauu pang rimana tani, inbe inganga a ila.” ");
INSERT INTO apr_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Motong la Yesu iraua betanga kidi nen, “Ye yo Mose iwodo wer nen pang nga, yesoo ang nga kutomu mede san dawa ben pat. ");
INSERT INTO apr_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Bong kulkulunu yege, ye kene yo Maro itar lang le tana ye in nga, ngan ‘ikarata di tooltool le tamoto be garup.’ Ngan la le betanga yo iken ye Rau ke Maro ngan iwete nen, ");
INSERT INTO apr_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","‘Ye punu yo nen in la le tamoto bet ikere nga, ngan ole igege tamana le tinana, inbe la iye rimana tinepe gaongo, ");
INSERT INTO apr_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","a bet nen ngan yeru tigaua le tinidi ataleu.’ Ngan nen le yeru ke bet tinepe ben di tooltool ru mulu tiap, bong tigaua tinidi le tiyei ben tool ataleu. ");
INSERT INTO apr_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Ngan nanga, soo so yo bet Maro ye taunu ipakere a igaua le atu koot nga, ngan ken tool sa ipoto le iken ki ki mulu be.” ");
INSERT INTO apr_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Yesu iwete pang di nen a imot, le nga iye di galiunu timulu a tilo rumu lono. Motong la di galiunu tina ngan titoru ye betanga tani nga. ");
INSERT INTO apr_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Le nga iraua betanga kidi nen, “Sei tool bet isukraia rimana, inbe la iyooloo garup san nga, ngan tool tani in igarungu kerenge ki iye rimana ye dada dook tiap ke bauk yo iyeii i. ");
INSERT INTO apr_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","E kumata garup atu bet isukraia nintooroo, inbe la iyooloo tamoto san nga, ngan garup tani in iyei dada dook tiap ke bauk lapau.” ");
INSERT INTO apr_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Di tooltool pattu tikap di natudi yo maimai tiap ngan a timan pang ye Yesu, a bet nen ngan man itoko kutodi inbe ipamede di ye betanga dook mata. Bong ngan di galiunu tipasak pang di a tisoror di. ");
INSERT INTO apr_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Ngan Yesu ikamata di galiunu tina yo tiyei nen nga, le nga katen malmal a iwete pang di nen, “Ai, ken kasoror di kakase ngan be! Bong kamalum pang di a timan pang yau, yesoo di tooltool yo bet lo tigaua ye di tooltool yo Maro bet matan kala di nga, ngan dawa ben di kakase tina nga. ");
INSERT INTO apr_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Awete pang moolmool nen, kumata le tool atu imalum pang Maro bet iyei tool mai panga inbe matan kala dawa ben di kakase tina ngan tiap nga, ngan o ke bet lo igaua ye di tooltool yo Maro bet matan kala di ngan tiap.” ");
INSERT INTO apr_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Motong la ikap di kakase tina ngan man iwarara di a itar bene lo podi, inbe ipamede di ye betanga dook mata nga. ");
INSERT INTO apr_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Yesu imadit a bet ipa mulu, ngan tool atu idada gorri a ila le la igun turunu du kene punu, inbe itoro nen. Iyei ne, “Pannoongoo, ong i tool dook mata. Nga bet atorong, ole ayeie soo so, a bet nen ngan akaua nepongo dook mata yo taukan motingi in nga?” ");
INSERT INTO apr_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Motong la Yesu iraua betanga ki nen, “Nga gelei bet kukiu au ye tool dook mata nga? Idi nga tool sa yo dook mata, ngan tiap, bong Maro yetaleu in la dook mata i. ");
INSERT INTO apr_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Ong i lom galanga ye wer yo Maro ikap pang Mose ngan oo. Wer tina ngan iwete nen: ‘Ken kuraumata di tooltool be, inbe ken kuyei bauk be, inbe ken kupinau be, inbe ken kusopo koom ye betanga doko be, inbe ken koom paweserai di diem a kop sorok so kidi be, inbe kuraua pang tamam le tinam a kulongo betanga kidi.’ ” ");
INSERT INTO apr_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Motong la tool tani in iraua betanga ke Yesu nen, “Pannoongoo, ye kene yo au kase go le se dookoot au mai nga, ngan atoo wer tina yo kuwete ngan le imot.” ");
INSERT INTO apr_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Ngan iwete nen, le nga Yesu lono panga mai san le matan kenen ye. Motong la iyei ne, “Dook mata, bong so atu la kuyeii tiao i. Le ole kula la kuyawar so kiong ngo le imot, inbe kop pat ki a kop pang di tooltool yo ballingadi tiap nga. Kumata le bet kuyei nen nga, ngan la bet pang dama ni ngan Maro ole ikap so dook mata yo iken ye malala ki ngo pong nga. Ngan kuyei nen a imot, lo ngan bet kuman man kutoo au.” ");
INSERT INTO apr_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Tool tani in ilongo tina yo Yesu iwete nen nga, le nga lon madoko, inbe matan mallikanga a ipa a ila, yesoo ye in tool ballingana le so ki alunu san. ");
INSERT INTO apr_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Motong la Yesu iportak a matana pang ye di galiunu, inbe iwete pang di nen, “Di tooltool yo ballingadi nen nga, ngan ole urata mai pang di bet tilo tigaua ye di tooltool yo Maro bet matan kala di nga.” ");
INSERT INTO apr_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Ngan iwete nen le nga di galiunu tilongo betanga tina le titakrai. Bong ngan Yesu iwete pang di mulu nen, “Di natuk nga, ole urata mai pang di tooltool yo lodi bet tilo tigaua ye di tooltool yo Maro bet matan kala di nga. ");
INSERT INTO apr_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Le kakamata, kumata bet asara mai ke solanga burum yo ene kamel i, in ikapge bet idewe ye sar gimono maitiap in nga, ngan ole gelei, urata imoo panga, too? E, moolmool! Ngan ole gaongo leu, kumata le tool yo ballingana in lono bet ilo igaua ye di tooltool yo Maro bet matan kala di nga, ngan ole urata imoo panga nen lapau.” ");
INSERT INTO apr_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Yesu di galiunu tina ngan tilongo betanga nen mulu le nga titakrai belebele. Motong la di tapdi tiwetewete nen, “Ona tiap! Bet nen nga, ngan ole sei tool bet Maro ipamule ye so dook tiap yo bet igarungu i?” ");
INSERT INTO apr_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Motong la Yesu matan kenen ye di, inbe iyei ne, “Tool sa ikapge bet iyei so nen nga, ngan ole imoo panga le isak ye. Bong bet Maro nga, ngan so le imot ngan imarra panga le ke bet isak ye tiap.” ");
INSERT INTO apr_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Motong la Pita iwete panga nen, “Am nga amgege so kiam le imot, inbe la amman bet man amtoo ong nga.” ");
INSERT INTO apr_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Ngan Yesu iraua betanga ki nen, “Awete pong moolmool nen. Kumata bet tool atu lon tutau inbe bingi dook mata kiau le igege rumu ki, too di toonoo le taini le lini, too tinana le tamana, too di natunu, too kumu le so ki nga, ");
INSERT INTO apr_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","ngan Maro ole ikap so yo nen ngan alunu le alunu san panga le kinkatingi ki ben 100 le illos so ki yo igege koot nga. Le tool tani in dookoot nga ye kene yo inepe ye tana i nga, ngan ole ikap rumu, inbe di toonoo le taini le lini, inbe di tinana le di natunu, inbe kumu ki, ngan alunu. Inbe ole di tooltool tikamata yo itoo au nga, le ole tigarungu lapau, bong pang dama ni nga, ngan ole ikaua nepongo dook mata yo taukan motingi i. ");
INSERT INTO apr_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Bong di tooltool alunu yo timugu nga, ngan pang dama ni ngan ole du tikimur. Inbe di tooltool alunu yo tikimur nga, ngan pang dama ni ngan ole lo timugu.” ");
INSERT INTO apr_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Yesu iye di galiunu tipa mulu a bet titoo dada a tilo pang Yerusalem nga, ngan le imugu inbe titoo. Ngan tina tikamata yo imugu pang Yerusalem nga, le di galiunu tina ngan lodi sakarungu, inbe di tooltool tina yo titoo di nga, ngan titattadai. Motong la ikap di galiunu yo sangaul be ru nga, ngan a iye di leu tila manga mooloo kasin la iwete pang di mulu ye so yo bet pombe pang ye i. ");
INSERT INTO apr_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Iyei ne, “Kapalongo, dookoot katai nga bet talo pang Yerusalem nga, ngan ole tikaua Tool Moolmool ke Maro a titaru la di tooltool maimai ke paroranga so pang Maro nga, inbe di pannoongoo ke wer ke Maro, ngan bedi. Lo ngan bet tiraua betanga bet ole tiraumate a imata. Le ole tisuketi la di tooltool yo tipa ye di rara kidi Yuda tiap nga, ngan bedi. ");
INSERT INTO apr_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Ngan la bet di tooltool tina ngan tipalele sere ye a tikorokoronaii, inbe tikap koro a tiwalisi tinini ye, inbe tiraumate le imata. Bong ole ye ke tol ki, ngan la bet imadit mulu ye ni ke matenge nga.” ");
INSERT INTO apr_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Yesu iwetewete ye matenge ki a imot, motong la Sebedi natunu tamoto ru yo Yemis iye Yowan nga, ngan timan pang ye man titoru nen. Tiyei ne, “Pannoongoo, ngan so atu yo amru nga lomam panga mata i, in lomam bet amtorong ye, a nen ngan ole kuyeii pam.” ");
INSERT INTO apr_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Ngan Yesu iraua betanga kidi yeru nen, “Soo so angru lomu bet ayeii pang i?” ");
INSERT INTO apr_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Ngan yeru tiyei ne, “Am nga lomam bet ye kene yo bet Maro itarong le kuyei kuto mai a matam kala di tooltool ye in nga, ngan ole kumalum pam amru, a nen ngan atu iwur ke bem oonoo, inbe san iwur ke bem ngas.” ");
INSERT INTO apr_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Motong la Yesu iwete pang di yeru nen, “Ang nga, so yo kator ye i, in lomu galanga ye moonoo ki tiap. Angru kakanamai ang ngan balai, o ke bet kayin ye ruku ke masngana yo bet ayin ye i, too? Inbe o ke bet karriu ye rriungu yo bet arriu ye i, too?” ");
INSERT INTO apr_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Ngan yeru tiyei ne, “E, amkanamai am ngan o ke bet amyei nen.” Motong la Yesu iwete pang di nen, “Dook mata, angru nga ole kayin ye ruku yo bet ayin ye i, inbe karriu ye rriungu yo bet arriu ye i. ");
INSERT INTO apr_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Bong betanga yo katorau ye bet atarang atu le iwur ke bek oonoo, inbe san iwur ke bek ngas i, in urata kiau bet ayeii tiap. In urata ke Maro, ye la bet ole ikarata ni tina ngan pang di tooltool yo ipootoo di koot nga.” ");
INSERT INTO apr_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Yesu di galiunu yo sangaul nga, ngan tilongo betanga ke Yemis iye Yowan yo titoru nen nga, le nga katedi malmal pang di yeru. ");
INSERT INTO apr_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Le nga Yesu ikiu di le imot man tigaua, inbe iwete pang di nen, “Ang nga lomu galanga nen, di tooltool kuto maimai ke di tooltool yo tipa ye di rara kidi Yuda tiap nga, ngan tikodo le timede ye gurana kidi, inbe tidada di tooltool kidi podi. Inbe di kuto maimai kidi kapala yo edi ilo ete nga, ngan tirautoo di tooltool kidi le bet tinepe la gurana kidi parmana, inbe titoo betanga yo kidi nga. ");
INSERT INTO apr_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Bong dada yo nen nga, ngan au i lok bet iken yang be. Le kumata ang tina ngan atu lono bet iyei kuto mai pang nga, ngan ole ye taunu irautoo le iyei ben kapraingi kiang. ");
INSERT INTO apr_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Inbe kumata le ang atu lono bet imugu pang nga, ngan ole iyei ben poranga kiang ang le imot. ");
INSERT INTO apr_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Yesoo, Tool Moolmool ke Maro isi tana bet si di tooltool tiyei urata panga bet tiloni ye, ngan tiap. Bong isi bet si ilon di tooltool inbe iraia tinini bet imata, a bet nen ngan Maro iyemenai di tooltool ye sennene kidi yo tiyei, ngan be.” ");
INSERT INTO apr_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Yesu iye di galiunu tipa le la pombe Yeriko, motong la bet timadit ye panga mulu nga, ngan tiye di tooltool alunu la tigege malala mai tani in, inbe tipa a tila nga. Ngan le la titauaraia tool mata kis atu yo iwurur dada gigini a igaugau pat le so ye di tooltool bet tikap panga i. Ngan tool tani in ene la Batimias i, inbe ye in Timias natunu. ");
INSERT INTO apr_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Le nga ye kene yo ilongo betanga bet Yesu ke Nasaret la ipa a iman in nga, ngan imadit tina le koonoo le mai nen. Iyei ne, “Yesu, ong in Dawiti natunu. Lom pau a kulonau!” ");
INSERT INTO apr_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Ngan le di tooltool alunu tipasak panga a tilele bet koonoo dookoot. Bong ngan tool tani in koonoo le mai mulu. Iyei ne, “Atoo, Dawiti Natunu, lom pau a kulonau!” ");
INSERT INTO apr_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Motong la Yesu ikodo, inbe iyei ne, “Kawete panga a iman.” Le nga koodi pang tool mata kis tani a tiwete panga nen, “Ai, kutattadai be! Kumadit. Ye in koonoo pong bet kuman pang ye ngan.” ");
INSERT INTO apr_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Motong la tool tani in ikatte sousoungu matolene ki in pang diki sila ikino, inbe imadit purukbe le lo ikodo a ila pang ye. ");
INSERT INTO apr_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Ila ye, motong la Yesu itoru nen, “Soo so lom bet ayeii pong i?” Ngan tool mata kis tani in iyei ne, “Pannoongoo, au i lok bet matak rere a akamata ni.” ");
INSERT INTO apr_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Motong la Yesu iyei ne, “Kula, lo medana kiong yo kutaru i, in la ilonong a ikaratong le matam dook mata i.” Le tina pattu leu be matan rere a ikamata ni, inbe itoo Yesu a iye tipa dada a tila. ");
INSERT INTO apr_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Yesu iye di galiunu tipa a tilo potai pang Yerusalem, ngan le tilo pombe ye malala Betpage inbe Betani yo iken kawal Olip madini nga. Motong la Yesu iwanga di galiunu tina ngan ru, ");
INSERT INTO apr_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","inbe iwete pang di nen, “Angru kamugu a kalo ye malala yo iken pang dama i. Ngan kumata bet kapa le lo pombe nga, ngan ole kakamata asara ke solanga di tooltool yo ene donki i, in kase paunu atu yo tiwatu i. Ngan donki tani in tool sa iwur pono a idada ye pitiao. Lo ngan bet angru karuku ooroo ki, inbe kadede a kasi. ");
INSERT INTO apr_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Le kumata bet tool sa ikamatang le itorang nen, ‘Ai, nga gelei a kayei nen nga?’ ngan kawete panga nen, ‘Tool Mai bet iyei urata ki ye, lo ngan bet ole palbe leu be ipamule a ise.’” ");
INSERT INTO apr_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Motong la di galiunu ru tina ngan tipa le lo pombe, ngan tikamata donki kase paunu tani in tiwatu ke diki potai pang ye dada ke rumu atu. Motong la bet tiruku ooroo ki, ");
INSERT INTO apr_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","ngan di tooltool pattu yo tikododo ye ni tani in nga, ngan titor di. Tiyei ne, “Ai, angru ngan in soo so kayeii i? Nga gelei a bet karuku donki in nga?” ");
INSERT INTO apr_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Ngan tiraua betanga kidi ye betanga yo Yesu iwete pang di nga. Motong la di tooltool tina ngan timalum pang di bet tikaua donki tani in a tidu. ");
INSERT INTO apr_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Yeru tikauu a tidu ye Yesu, motong la tidut sousoungu matolene kidi ngan a tiyoo lo donki tani in pono, inbe Yesu lo iwur ye. ");
INSERT INTO apr_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Inbe di tooltool malala mai yo tiye di tipa nga, ngan tidut sousoungu matolene kidi a tiyoo du dada katene, inbe di kapala ngan tila karam lono la tisaput kai bene bene man titar du dada katene lapau. ");
INSERT INTO apr_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Inbe di tooltool kapala yo tipa le timugu, inbe di kapala yo tikimur nga, ngan koodi le mai. Tiyei ne, “Tayitmaka Maro ene! Maro ole iyei urata dook mata pang tool yo isi ye Tool Mai ene i. ");
INSERT INTO apr_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Maro ole iyei urata dook mata pang tool yo isi bet si iyei tool kuto mai a matan kalam i, in dawa ben sasa kiidi yo Dawiti i. Tayitmaka Maro ene le ilo ete!” ");
INSERT INTO apr_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Ngan Yesu lo pombe Yerusalem, motong la ipa so le ilo koongoo lono ke bareme mai ke sungunu lo ikodo inbe matan kapsanin so tina le imot yo iken bareme lono nga. Bong ngan ke idu a bet bong, le nga ipas a iye di galiunu yo sangaul be ru nga, ngan tigege Yerusalem inbe timulu a tidu pang Betani. ");
INSERT INTO apr_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Tidu tiken a muntu, motong la tigege Betani a bet timulu a tilo pang Yerusalem, ngan Yesu pitola. ");
INSERT INTO apr_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Le nga bet matan la ngan ikamata kai pik atu in ikodo manga mooloo kasin in raunu iwutu belebele. Motong la ipa le ila potai a nen ngan matan sarai too, kanono sa lapau, too tiap. Bong ngan ikamata toko kanono siap, raunu leu, yesoo in lal yo bet kai pik ipu ye, in tiap. ");
INSERT INTO apr_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Motong la Yesu iwete pang kai pik tani nen, “Dookoot katai nga a ilo, ngan o ke bet kupu a nen ngan di tooltool tikan puam mulu, ngan tiap.” Ngan le di galiunu tilongo tina yo iwete nen nga. ");
INSERT INTO apr_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Yesu iye di galiunu tipa le lo pombe Yerusalem, motong la ipa so le ilo koongoo lono ke bareme mai ke sungunu lo inganga di tooltool yo man tigaua a tiyawar so kidi inbe di diedi tiyimi nga. Inbe ipatudtud kakawa ke palokanga so kidi tooltool yo tiraukol pat nga, inbe kakawa ke burungu kidi tooltool yo tiyawar man utu pang paroranga, ngan lapau ");
INSERT INTO apr_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Inbe igunkala di tooltool tina bet ken tikap so yo nen nga mulu inbe tipa a tilo bet tisi koongoo lono ke bareme mai ke sungunu be. ");
INSERT INTO apr_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Motong la ipatomonai di ngan iwete pang di nen, “Betanga yo Maro iwete a tiwodo lo iken ye rau ki ngan nen, ‘Rumu kiau i, ole tiweta ye rumu ke pataraungu kidi tooltool ke tana maimai nga le imot.’ Bong ang nga kayeii le iyei ben ‘ni kidi tooltool ke pinnau bet tiko ye.’ ” ");
INSERT INTO apr_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Di tooltool maimai ke paroranga so pang Maro, tiye di pannoongoo ke wer ke Maro ngan tilongo betanga yo Yesu iwete nga, le nga timadit a tisere dada yo bet tiraumate ye i. Yesoo, tikamata di tooltool malala mai tilongo patomonaingi ki, ngan le titakrai ye a titoo nga, ngan nen le titattadaia Yesu. ");
INSERT INTO apr_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Ye kene tani in Yesu iye di galiunu ngan tinepe le du rrai, motong la tigege malala mai tani in a tila. ");
INSERT INTO apr_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Yesu iye di galiunu tina ngan tiken bong le du muntu, motong la bet tipa a tila, ngan tikamata kai pik tani in iwod a ipa so le idu ye ramini. ");
INSERT INTO apr_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Motong la Pita lon tut le nga iwete pang Yesu nen, “Pannoongoo, kumata! Kai pik tani yo kuwetetoo i, in iwod oo.” ");
INSERT INTO apr_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Le nga Yesu iraua betanga ki nen, “Katara lomu medana pang Maro. ");
INSERT INTO apr_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Awete pang moolmool nen, kumata tool atu bet iwete pang kawal i nen, ‘Kumadit a ong taum kupas le kudu tiek lono ni,’ ngan kumata tool tani in bet lono rru tiap, bong itara lono medana bet so tani in ole pombe nga, ngan Maro ole iyeii le pombe moolmool ben tina yo iwete nga. ");
INSERT INTO apr_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Ngan nen le awete pang nen, kumata bet kapatarau a katoro Maro ye soo so bet ikap pang, inbe katara lomu medana panga bet ikap pang moolmool nga, ngan ole ikap pang le imot. ");
INSERT INTO apr_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","26","Inbe ye kene yo bet lo kakodo a kapatarau ye in nga, ngan kumata le bet lomu tut dada dook tiap ke sennene yo tool atu iyei pang nga, ngan kagiri dada dook tiap ki tina ngan. Ngan la bet Tamamu Maro yo inepe ye malala ki ete i, in ole igiri sennene kiang nga.” ");
INSERT INTO apr_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Yesu iye di galiunu tipa le lo pombe mulu Yerusalem, motong la ye kene yo ilo a lo ipa koongoo lono ke bareme mai ke sungunu ye in nga, ngan di tooltool maimai ke paroranga so pang Maro, tiye di pannoongoo ke wer ke Maro, inbe di kuto maimai ke di Yuda nga, ngan timan pang ye. ");
INSERT INTO apr_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Le nga man titoru nen, “Ai, sei itarong a le kuyei urata nen i? Inbe sei ikaua gurana pong bet kuyei urata nen ye i?” ");
INSERT INTO apr_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Motong la Yesu iraua betanga kidi nen, “Dook mata, bong nga bet atorang ye torungu kiau atu ngan. Kumata bet karauu nga, ngan la bet awete pang ye sei tool yo ikaua gurana pau a le ayei urata i nga. ");
INSERT INTO apr_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Oo, kawete! Yowan yo irriu di tooltool i, in sei ikaua gurana panga a le iyei urata ki nga? Gurana tani in ipa ye Maro yo inepe ye malala ki ete ni, too ipa ye di tooltool leu?” ");
INSERT INTO apr_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Motong la di tooltool tina ngan sila di tapdi tiwetewete nen, “Ona! Kumata le tawete bet Maro yo inepe ye malala ki ete ni, in la ikaua gurana pang Yowan in nga, ngan ole itoridi nen. Iyei ne, ‘Ngan nga gelei a le katara lomu medana ye betanga ki tiap nga?’ ");
INSERT INTO apr_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Bong kumata le tawete bet di tooltool ke tana i leu la tikaua gurana pang Yowan nga, ngan o dook mata tiap lapau.” Ngan ye yo tiwete nen nga, ngan titattadai, yesoo di tooltool le imot tiwete bet Yowan in Maro koonoo atu moolmool. ");
INSERT INTO apr_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Ngan nen le tiraua betanga ke Yesu nen, “Am nga lomam galanga tiap sa.” Motong la Yesu iyei ne, “Nen ngan au lapau, o ke bet awete pang ye sei tool yo ikaua gurana pau a le ayei urata nen ye i, in tiap.” ");
INSERT INTO apr_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Yesu iwetewete pang di tooltool maimai kidi Yuda tina mulu nga, ngan le ikatte betanga pang di nen, “Tool atu in ipe ooroo yo ene wain in kumu atu. Motong la ikaua koongoo ki le iparkat, inbe ikele gomo atu a ikarata le dook mata bet tipisi wain surunu ngan idu ye. Inbe ire rumu atu le ilo ete pang di tooltool yo bet lo tinepe ye a matadi kala kumu tani nga. Motong la itara kumu tani in lo di tooltool ke kapgingi pattu bedi a bet matadi kala, inbe tiyei urata ye. Inbe ye taunu in ipa a ila pang ye malala san yo iken ni mooloo i. ");
INSERT INTO apr_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Ila inepe nango, inbe tilo ye lal yo bet tigogo ooroo wain puana ye i, motong la tool tani in iwanga kapraingi ki atu a ila pang ye di tooltool tina yo matadi kala kumu ki nga. Ngan iwanga bet la ikap wain puana ki yo bet tipoto panga nga, ngan a ikap a iman. ");
INSERT INTO apr_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Bong di tooltool ke kapgingi tina ngan tiparama a tirauu, inbe tinganga a ipa bene koonoo a ila. ");
INSERT INTO apr_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Motong la kumu taunu tani in iwanga kapraingi ki san mulu a ila pang ye di. Ngan di tooltool tina ngan tiraupala kutono, inbe tiyei dada dook tiap panga a tipammoo. ");
INSERT INTO apr_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Motong la kumu taunu tani in iwanga kapraingi ki san mulu a ila. Ngan le di tooltool tina ngan tiraumate le imata. Motong la iwanga di kapraingi ki alunu mulu a tila, ngan le di kapala ngan tiparama di a tirau di, inbe di kapala ngan tiraumata di le timmata. ");
INSERT INTO apr_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","“Ngan nen le tool ataleu yo inepe a bet iwanga i, in ye taunu natunu yo lono panga mai san i. Le nga lon wete nen, ‘I au natuk moolmool, le kumata bet awanga a ila nga, ngan ole tiraua panga.’ ");
INSERT INTO apr_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","“Bong ngan di tooltool ke kapgingi tina tikamata yo ipa a iman nga, le nga di tapdi tiwetewete nen, ‘Kakamata, kumu taunu tani in natunu la iman i. Kumata le bet pang dama ni nga, ngan ole ikolo tamana ye kumu i a iyei kumu taunu. Le kaman a taraumate le imata, a bet nen ngan so yo tamana bet ikap panga nga, ngan takap le imot paidi.’ ");
INSERT INTO apr_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Le nga tila tikauu a tiraumate le imata, motong la tikaua bobono a tikatte du ke diki ye kumu ke ooroo wain tani nga.” ");
INSERT INTO apr_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Yesu iwete pang di nen a imot, motong la itor di nen, “Ngan nen le kumu taunu tani in ole iyeie soo so pang di tooltool ke kapgingi tina? Ye in ole iman man iraumatamata di tooltool tina le imot, inbe itara kumu tani in lo di tooltool kapala bedi a nen ngan matadi kala. ");
INSERT INTO apr_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Ang nga kakinkat betanga yo iken ye Rau ke Maro nga lapau, too tiap? Betanga tina ngan iwete nen, ‘Pat yo di tooltool ke renge rumu lodi panga tiap a tisukraii i, in la iyei pat dook mata yo bet ipamede rumu le imede i. ");
INSERT INTO apr_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Tool Mai iyeie so nen, le amkamata ye matamam, ngan dook mata san.’ ” ");
INSERT INTO apr_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Ngan di kuto maimai kidi Yuda tina ngan tilongo betanga nen nga, le nga tisere dada yo bet tikaua Yesu a tiparama ye i. Yesoo, lodi galanga bet betanga yo iwete nga, ngan ikatte ye di. Bong ngan titattadai di tooltool malala mai yo tinepepe nga, le nga tigege sila inepe, inbe tikoo a tila. ");
INSERT INTO apr_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Di Yuda tina tila tinepe, motong la tiwanga di Paresi tiye di tooltool pattu yo tikata suanga ye Erot nga, a timulu a tila pang ye Yesu. Ngan tila bet la titoua ye betanga sa, a nen ngan bet koon kapsap ye nga, ngan tikauu lo tipatokode ye ni ke karatanga betanga. ");
INSERT INTO apr_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Le nga tila ye, motong la tiwete panga nen, “Pannoongoo, am nga lomam galanga bet betanga kiong yo kuwete ngan moolmool leu. Inbe ong i ke bet kutattadaia kam tool siap. Le kumata bet kuwete pang di nga, ngan lom rru ye di bet di tooltool balai, ngan tiap, bong ole kuwete betanga gaongo leu pang di, inbe kupatomonai di tooltool ye dada moolmool yo ke Maro ngan le imot. Ngan la bet amtorong nga, ong i lom balai? Nga dook mata bet idi nga tatar pat pang tool kuto mai kidi Rom yo Sisa i, too tiap?” ");
INSERT INTO apr_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Bong ngan Yesu lon galanga ye dada dook tiap kidi yo iken lodi in oo, le nga iwete pang di nen, “Nga gelei a kakapge bet katou au nga? Kakaua pat silba ngan atu iman a man akamata.” ");
INSERT INTO apr_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Le nga tikaua pat tina ngan atu panga, motong la itor di nen, “Sei kannungana inbe ene iken ye pat i nga?” Ngan tiyei ne, “In Sisa.” ");
INSERT INTO apr_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Motong la iwete pang di nen, “Aoo, ngan dook mata! Bet so ke Sisa, ngan kakap pang Sisa. E so ke Maro, ngan kakap pang Maro.” Le nga di tooltool tina ngan titakrai ye betanga ki yo iwete nga. ");
INSERT INTO apr_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Motong la di Sedusi pattu timan pang ye Yesu bet man titoru. Ngan di Sedusi tina, ngan di Yuda pattu yo tiwete bet di tooltool timmata nga, ngan o ke bet timadit mulu tiap. Le nga man titoro Yesu nen, ");
INSERT INTO apr_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Pannoongoo, mugu ngan Mose iwodo betanga atu bet tatoo in nen. Kumata le tool atu bet ikere le rimana ipasuiu kan kase siap, inbe tamoto tani in imata nga, ngan taini ole ikoli a iyooloo tap ke toonoo, a bet nen ngan garup tani in ipasui kase sa panga nga, ngan ole iseke rara ke toonoo tani in pang dama a ila. ");
INSERT INTO apr_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Mose iwete paidi nen, bong amtorong, ole kuwete balai? Oo, tool atu in natunu tamoto limi be ru. Ngan tinepe, le nga toodi yo mumuganga i, in iyooloo garup atu, bong rimana tani in ipasui toko kan kase siao, inbe imata. ");
INSERT INTO apr_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Motong la taini yo itoo in ikoli a iyooloo tap ke toonoo tani. Bong ngan rimadi tani in ipasui toko kan kase siao, inbe ye lapau imata. Motong la taidi yo tol kidi i, in itoo dada gaongo leu ben di toonoo a iyooloo tap kidi tani in. ");
INSERT INTO apr_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Ngan di tamoto tina yo limi be ru nga, ngan di le imot tiyooloo garup tani yo ataleu i. Bong ngan le ipasui toko kadi kase siap, inbe timmata. Motong la garup tani, in imata lapau a itoo di nga. ");
INSERT INTO apr_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Le lomam bet kuwete pam ngan, ye lal yo bet di tooltool matedi bet timadit mulu ye in nga, ngan garup tani in ole iyei sei rimana? Yesoo, di tamoto tina yo limi be ru nga, ngan di le imot tiyooloo garup tani in oo.” ");
INSERT INTO apr_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Motong la Yesu iraua betanga kidi nen, “Ang nga kawete googoomu, too? E, moolmool, yesoo ang nga lomu galanga ye betanga yo iken ye Rau ke Maro, ngan tiap. Inbe lomu galanga ye gurana ke Maro, ngan tiap lapau. ");
INSERT INTO apr_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Ye lal yo bet Maro ipamadit di tooltool yo timmata koot ngan mulu ye in nga, ngan di tooltool o ke bet tikere mulu tiap. Di ngan ole tinepe dawa ben di bangabangana ke Maro yo tinepe ye malala ki ngo. ");
INSERT INTO apr_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Le dookoot nga bet awete pang ye di tooltool yo timadit mulu ye ni ke matenge nga. Ang nga kakinkat betanga ke Mose yo iwodo a igasa kai mai tiap yo ei ikan ye i, in lapau, too tiap? Ye kene tani in Maro kalngana pombe ye ei tani a iwete pang Mose ye di sasa kiidi nen, ‘Au i Maro ke Awaram ye Esaka inbe Yakop.’ ");
INSERT INTO apr_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Le i Maro kidi tooltool yo timmata koot nga, ngan tiap, bong i Maro kidi tooltool yo tinepe maguredi nga. Le ang nga kawete googoomu.” ");
INSERT INTO apr_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Pannoongoo ke wer ke Maro ngan atu yo man inepe lapau i, in ilongo di Sedusi tina yo tiye Yesu tiparsu ye betanga nga. Le nga ikamata Yesu ngan irau betanga kidi dook mata san. Motong la iman tina le itoru nen, “Ai, soo wer ke Maro imugu le illos di wer yo kapala ngan le imot i?” ");
INSERT INTO apr_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Motong la Yesu iraua betanga ki nen, “Wer yo imugu pang di wer yo kapala nga, in nen: ‘Ang di Isrel katar talngamu a kapalongo. Tool Mai yo Maro kiidi i, in yetaleu la Maro moolmool i. ");
INSERT INTO apr_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Le lomu pang Maro yo Tool Mai kiang i, in mai san, inbe kagaua lomu le tinimu ipa ye gurana le lo galanga kiang le imot panga.’ ");
INSERT INTO apr_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","E wer san yo itoo i, in nen, ‘Lom pang di diem mai san dawa ben yo ong taum lom pong mai san nga.’ Ngan wer sa mulu yo imugu le illos di wer ru nga, ngan tiap.” ");
INSERT INTO apr_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Motong la tool tani in iraua betanga ke Yesu nen, “Dook mata, pannoongoo! Betanga kiong yo kuwete bet Maro i, in Maro ataleu ngan moolmool. Le ni maro sa mulu siap, bong yetaleu. ");
INSERT INTO apr_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Ngan nen le am nga bet amgaua lomam le ipa ye gurana le lo galanga kiam le imot panga. Inbe lomam pang di diemam mai san dawa ben yo am tapmam lomam pam mai san nga. Ngan dada yo nen in dook mata kaiye le illos so yo tadaun a tayei paroranga ye nga, inbe so kapala yo taparoro pang Maro, ngan lapau.” ");
INSERT INTO apr_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Ngan Yesu ikamata tool tani in ben lo galanga ki dook mata le iraua betanga ki dook, motong la iwete panga nen, “Ai, ong i kunepe potai bet lo kugaua ye di tooltool yo Maro bet matan kala di nga.” Yesu iwete pang tool tani in nen a imot, motong la ye kene tani in a ilo ngan di tooltool tina titattadai le titoro Yesu mulu tiap. ");
INSERT INTO apr_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Ye kene yo Yesu lo inepe koongoo lono ke bareme mai ke sungunu a ipatomonai di tooltool nga, ngan le itor di nen, “Ai, nga gelei a di pannoongoo ke wer ke Maro tiwete bet Kirisi in Dawiti natunu nga? ");
INSERT INTO apr_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Kakamata, Maro Amunu Silene la ipamaditi Dawiti lono, le Dawiti ye taunu iwete nen, ‘Maro yo Tool Mai i, in iwete pang Tool Mai kiau nen. “Kuwur ye bek oonoo a kunepe nen le lo atar di koi kiong a tidu ke kem parmana.” ’ ");
INSERT INTO apr_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Le kakamata, Dawiti ye taunu la iweta ye Tool Mai ki i. E nga gelei a di tooltool tiwete bet ye in Dawiti natunu nga?” Ngan di tooltool malala mai yo titar talngadi ye betanga ke Yesu nga, ngan tilongo le lodi ponana kaiye. ");
INSERT INTO apr_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Motong la Yesu ipatomonai di ngan le iwete nen, “Ken kakamatang dook leu ye di pannoongoo ke wer ke Maro nga. Di ngan lodi bet tisousou ye sousoungu mooloo mooloo kidi yo pat ki mai san nga, inbe tipa mallangana ye ni ke yawaringi so, a bet nen ngan di tooltool bet tikamata di ngan tiwete lo ponana kidi pang di. ");
INSERT INTO apr_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Inbe di ngan kumata bet tilo ye rumu kidi Yuda ke gaongo in lono nga, ngan lodi bet lo tiwur ye kakawa ke burungu yo iken ke dama nga, inbe kumata bet tila ye mailang nga, ngan lodi bet lo tiwur ye kakawa kidi tooltool yo edi maimai nga. ");
INSERT INTO apr_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Inbe di ngan tikaua llungunu ye di garup yo tap nga a tipinau rumu le so kidi. Inbe kene yo bet tipatarau ye in nga, ngan tiyolo pataraungu kidi le mooloo san. Ngan di tooltool tina yo nen nga, ngan ole Maro iyemenai di le dook tiap yege.” ");
INSERT INTO apr_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Yesu ila le la iwur potai pang ye ni yo bet titar pat ilo ye depe ke bareme mai ke sungunu ye i. Inbe nga matan kenen ye di tooltool malala mai yo timan bet man titar pat kidi ilo ye depe ke bareme mai ke sungunu nga. Ngan le di tooltool yo ballingadi nga, ngan alunu la man titar kaiye pat kidi ilo ye depe nga. ");
INSERT INTO apr_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Bong garup tap atu yo ballingana tiap i, in iman le itar pat maitiap kooroonoo ru leu. Ngan pat tina ngan gurana ki mai tiap. ");
INSERT INTO apr_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Motong la Yesu ikiu di galiunu a timan pang ye man iwete pang di nen, “Awete pang moolmool nen, garup tap i ballingana tiap, bong itar pat mai san le illos pat yo di tooltool kapala titar lo ye depe ke tarungu pat nga. ");
INSERT INTO apr_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Di ngan tooltool ballingadi le pat kidi alunu san, bong titar mai tiap. Ngan garup i ballingana tiap, bong ye in iraia lono bet itar pat ki tina yo bet iyimi kaningi panga ye nga, ngan le imot ilo ye depe ke tarungu pat.” ");
INSERT INTO apr_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Yesu imadit a igege bareme mai ke sungunu, inbe ipa a bet idu pang diki nga, ngan di galiunu tina ngan atu iwete panga. Iyei ne, “Ona, Pannoongoo! Kumata, bareme ke sungunu i tire ye pat somaimai le dook mata san! Inbe rumu kapala yo tikodo potai ye nga, ngan dook mata san lapau.” ");
INSERT INTO apr_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Motong la Yesu iraua betanga ki nen, “Nga o kumata rumu maimai yo tire nga la kuwete nen nga, too? Awete pong nen, pat ke rumu tina nga, ngan atu sa yo bet iken a iloko lo ene pono dawa ben dookoot nga, ngan tiap. Bong ole tiraukedekede di le imot a timol du tana le tiken kidi kidi.” ");
INSERT INTO apr_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Le nga tinaua kawal Olip a tilo le lo iwur, inbe matan la ngan ikamata bareme mai ke sungunu iken ke kapala. Motong la Pita iye Yemis inbe Yowan iye Antares di leu timan pang ye man titoru nen, ");
INSERT INTO apr_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Oo, kuwete pam ngan, ole soo lal bet so tina ngan pombe ye i? Inbe soo tarkilanga bet amkamata mugu, ngan ole lomam galanga ben so tina ngan kanono bet pombe moolmool nga?” ");
INSERT INTO apr_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Motong la Yesu iraua betanga kidi nen, “Ken kakamatang dook leu ye di tooltool yo bet tillungang nga. ");
INSERT INTO apr_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Yesoo, di tooltool alunu ole timan pang yang man tipootoo ek inbe tiyei ne, ‘Au tool tani naii.’ Ngan ole tikap llungunu ye di tooltool alunu le titara lodi medana ye betanga kidi. ");
INSERT INTO apr_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Kumata ye kene yo bet kalongo bingi ke patokongo mai, inbe talngamu rau bet patokongo mai sa ole pombe nga, ngan ken katattadai a lomu sakarungu be. So tina yo nen nga ole pombe moolmool, bong so yo awete pang ye nga, ngan lal ki o pombe tiao. ");
INSERT INTO apr_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Ngan di tooltool ke tana mai atu ole timadit a tiye di tooltool ke tana mai san tipatoko. Inbe di tooltool ke tool kuto mai atu ole timadit a tiye di tooltool ke tool kuto mai san tipatoko. Inbe nauningi mai ole itak ye malala yo kapala nga, inbe pitolo mai ole pombe lapau. Ngan moonoo yo nen ngan ole pompombe mugu, dawa ben masngana yo pombe pang ye garup mugu, lo ngan bet ipasui i. ");
INSERT INTO apr_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Ngan nanga, ken ang tapmu kakauwai yang dook leu. Yesoo, ole tikau ang kapala lo kakodo dama ke di tooltool kuto maimai kidi Yuda yo matadi kala momo le nepongo kidi nga, inbe tikau ang a kalo rumu kidi Yuda ke gaongo in lono a lo tirau ang ye ooroo medana. Inbe tikamatang ye yo katoo au nga, ngan ole tikau ang lo kakodo dama ke di kuto maimai yo matadi kala di Yuda nga, inbe di kuto maimai yo matadi kala tana maimai nga. Ngan ye kene yo bet tiyei koi pang nen ye in nga, ngan ole dada koon panganga pang bet kagasa pang di tooltool maimai tina ye so yo kakamata nga. ");
INSERT INTO apr_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Bong kulkulunu ngan ole kawetewete bingi dook mata kiau i pang di tooltool ke tana maimai nga le imot ngan, lo ngan bet so tina yo awete pang ye ngan pombe. ");
INSERT INTO apr_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Le ye kene yo tiparamang inbe tikau ang a bet lo kakodo ye ni ke karatanga betanga ye in nga, ngan ken lomu madoko ye betanga yo bet kawete, ngan be. Bong ye kene tani in nga, ngan soo betanga lomu kap bet kawete nga, ngan kawete leu. Yesoo, betanga tina le imot yo bet kawete nga, ngan ang tapmu la bet kawete nga tiap, bong Maro Amunu Silene la bet iwete betanga tina i. ");
INSERT INTO apr_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","“Inbe ye kene tani in di rara atu ben toodi le taidi nga, ngan atu ole ikaua san a itaru la di koi ki bedi, a bet nen ngan tiraumate le imata. Inbe di tooltool ole tiyei dada gaongo nen leu pang di natudi. Inbe di kakase ole tisak betanga ke di tamadi le tinadi lapau, inbe tiwete pang di tooltool kapala bet la tiraumata di a timmata. ");
INSERT INTO apr_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Inbe di tooltool le imot ole tiyei koi pang a bet tigarungang, yesoo ang ngan katara lomu medana ye betanga kiau a katoo au. Bong di sima tooltool yo tikodo le timede ye lo medana kidi a tikodo nen le lo timmata nga, ngan Maro ole ikap di a ipamulu di ye so dook tiap yo bet igarung di i.” ");
INSERT INTO apr_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Motong la Yesu iwete pang di mulu nen, “Pang dama ni ngan ole kakamata so dook tiap ki taunu in ikodo ye ni mison ke Maro bet igarungu. Le ong sei tooltool bet kukinkata betanga tani nga, ngan lom kaua urata ye dook, a nen ngan lom galanga ye. Ngan nanga, le bet kakamata so nen nga, ngan ang di tooltool yo kanepe ye tana mai Yudia nga, ngan kakoo tarrai a kalo pang kawal. ");
INSERT INTO apr_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Inbe kumata bet tool sa inepe rumu pono ki nga, ngan ken idu tana a idewe rumu ki lo ikap so ki sa, ngan be, bong ipas le igege sila ikino leu. ");
INSERT INTO apr_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Inbe kumata bet tool sa inepe kumu lono ki nga, ngan ken imulu pang rumu ki du ikaua sousoungu matolene ki be, bong ipas le igege sila ikino leu. ");
INSERT INTO apr_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Ngan di garup yo kapodi, inbe di garup yo tiyei borrenge ye di natudi a tipayinin di nga, ngan ye kene tani in nga, ngan barau, ole imoo pang di yo bet tikoo nga. ");
INSERT INTO apr_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Le bet nen ngan kapatarau pang Maro nen, ken so tani in pombe ye lal ke mou be. ");
INSERT INTO apr_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Yesoo, ye lal tani nga, ngan urata moonoo dook tiap yo bet pompombe a igarung di tooltool nga, ngan urata moonoo dook tiap ki taunu. Le kulkulunu yege ye kene yo Maro itar lang le tana ye i, le se dookoot nga, ngan urata moonoo dook tiap yo pompombe ngan sa yo bet gaongo ye ngan tiap. Inbe pang dama ni nga, ngan ole urata moonoo dook tiap gaongo nen sa yo bet pompombe mulu, ngan tiap lapau. ");
INSERT INTO apr_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Kumata yo bet Tool Mai ipamodo lal ke moonoo tani in tiap nga, ngan matin nga le di tooltool nga le imot tilledi. Bong ngan lono pang di tooltool ki ye taunu yo ipootoo di panga koot nga, ngan la le ipamodo lal tani in nga. ");
INSERT INTO apr_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Inbe ye kene tani in kumata le tool atu iwete pang nen, ‘Kakamata, Kirisi bi e i!’ too, bet iyei ne, ‘Kakamata, ye meneng e ni!’ ngan ken katara lomu medana ye betanga ki be. ");
INSERT INTO apr_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Awete pang nen, yesoo ole di tooltool ke kaplungunu yo tiwete bet di nga Kirisi, inbe di tooltool ke kaplungunu kapala yo tiwete bet di ngan Maro koonoo nga, ngan ole alunu la bet timan pang yang nga. Di ngan ole tiyei gogo mos le urata maimai a iyei ben tarkilanga pang di, a bet tikaua llungunu ye di tooltool. Inbe ole tikapge bet tikaua llungunu ye di tooltool yo Maro ipootoo di panga nga, a bet nen ngan la titoo di lapau. ");
INSERT INTO apr_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Ngan nen le ken kakauwai yang dook leu. Oi, kakamata koot? So tina le imot yo bet pombe nga, ngan awete pang ye oo.” ");
INSERT INTO apr_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Motong la Yesu iwete mulu nen, “Ye lal yo moonoo tina ngan bet pombe le imot ye in nga, ngan ‘ke ole matan kumukumu, inbe taudu ole isini mulu tiap. ");
INSERT INTO apr_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Inbe di kanpitiki ole timakedekede ke lang katene a timol a tisi, inbe so ke lang katene yo gurana kidi maimai mata nga, ngan ole titangarur.’ ");
INSERT INTO apr_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","“Inbe ye kene tani in nga, ngan di tooltool ke ni mai i le imot ole tikamata Tool Moolmool ke Maro inepe ye eng tene, inbe ipa ye gurana mai ke Maro inbe ye lulngana a isi pang tana. ");
INSERT INTO apr_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Inbe ole iwanga di bangabangana ki a si tipa ye tana gigini tina yo pai nga, inbe tigaua di tooltool yo Maro ye taunu ipootoo di panga nga, ngan a timan pang ye. Nen le di bangabangana tina ole tipa le la titaua ni yo tana le lang imot ye i, a bet tikap di tooltool ke Maro a man iye di tigaua.” ");
INSERT INTO apr_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Motong la Yesu ikatte betanga atu pang di nen, “Dookoot nga lok bet ole kakap lo galanga ye kai pik in raunu. Ye kene yo bet suddana pombe ye bene a bet itar raunu paunu nga, ngan ole lomu galanga nen, rai mai o potai oo. ");
INSERT INTO apr_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Ngan gaongo leu, ye kene yo bet kakamata so tina nga bet pompombe ye in nga, ngan ole lomu galanga nen, lal ke so tina yo awetewete ye in o iman potai ye dada oo. ");
INSERT INTO apr_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Awete pang moolmool nen, di tooltool yo dookoot tinepe matadi rerene go nga, ngan ole timmata tiao, inbe so tina le imot yo awete pang ye nga, ngan ole pombe. ");
INSERT INTO apr_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Ngan lang le tana nga ole tilledi, bong betanga yo kiau nga, ngan o ke bet kasin pa ilene, ngan tiap.” ");
INSERT INTO apr_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Motong la Yesu iwete pang di mulu nen, “Tool sa yo bet lon galanga ye ke, too ye soo ke matana yo bet so tina ngan pompombe ye i, in tiap. Inbe di bangabangana ke Maro yo tinepe ye malala ki nga, ngan lodi galanga ye tiap, inbe Maro Natunu in lon galanga ye tiap lapau, bong Tamana yetaleu in la lon galanga ye i. ");
INSERT INTO apr_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Ngan nen le ken kakauwai yang, inbe kakamatang dook leu. Yesoo, ang ngan lomu galanga ye soo lal yo bet so tina ngan pompombe ye i, in tiap. ");
INSERT INTO apr_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Bong lal tani in ole pombe dawa ben tool atu yo ikarata betanga bet idu pang ni san i. Le nga bet igege rumu ki nga, ngan ikap urata pang di kapraingi ki ngan atu atu bet tiyei. Inbe iwete pang kapraingi ki yo ikodokala dada in nen, ‘Ken kukauwai dook leu.’ ");
INSERT INTO apr_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","“Ngan nanga, ken kakamatang dook leu, yesoo ang ngan lomu galanga dook ye lal yo bet rumu taunu tani in imulu a ilong ye i, in tiap. Ole imulu a ilong rrai, too bong kataunu, too pang malama tareke ipadu tamoto nga, too ole imulu a ilong muntu bongmai koot? ");
INSERT INTO apr_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Kumata le bet ipatakrai ang ye panga ki nga, ngan ken kaken mata be, ole nen ngan ipusye ang. ");
INSERT INTO apr_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Ngan betanga yo awete pang nga, ngan awete pang di tooltool le imot lapau. Awete nen, ken kakamatang dook leu!” ");
INSERT INTO apr_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Ole tinepe le ke ru mulu iman a ila ngan la bet tilo ye lal ke Paskimoolooningi ke Maro, inbe ye lal yo di Yuda tigaua a tikana porong yo taukan so bet iyeii a isung i, in bet pombe nga. Inbe ye kene tani, in di tooltool maimai ke paroranga so pang Maro nga, ngan tiye di pannoongoo ke wer ke Maro ngan tisere dada yo bet tikaua Yesu a tiparama sollono, inbe tiraumate ye i. ");
INSERT INTO apr_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Tiyei ne, “O ke bet tayei dada nen panga ye lal maiyoko yo ke sungunu in tiap, ole nen ngan di tooltool bet tikamatidi nga, ngan katedi malmal a tipamaditi patokongo.” ");
INSERT INTO apr_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Yesu inepe la Betani ngo ye rumu ke Simon, tool tani yo mugu ngan botoboto medana ikani i. Le nga iwurur ye kakawa ke kaningi so a ikanen so, inbe garup atu ipa a ilo. Ngan garup tani in ilo ngan ikaua dap maitiap yo tikarata ye pat sallinene dook mata, inbe tipalingi kai nad surunu yo kini ki dook mata i, in ilo ye i. Motong la igoromkata dap tani in koonoo, inbe iti kai surunu tani yo pat ki mai mata in lo Yesu kutono. ");
INSERT INTO apr_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Bong di tooltool pattu yo tinepe ye kene tani in nga, ngan tikamata le nga katedi malmal a di tapdi tiwetewete a tiyei ne, “Ona tiap, nga gelei a ingele ye so ke saliningi dook mata i a iti soroki nen nga? ");
INSERT INTO apr_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Nga yo bet tayawari nga, ngan matin nga le takap pat silba ben 300, lo ngan bet takap pat tina ngan pang di tooltool yo ballingadi tiap nga.” Ngan tiwete nen, inbe tipasak panga a tikanni. ");
INSERT INTO apr_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Bong ngan Yesu iwete pang di nen “Ai, kagege sila inepe! Nga gelei a koomu kauu nga? Dada yo iyeii pau i, in dook mata le dook mata san. ");
INSERT INTO apr_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Kapalongo, di tooltool yo ballingadi tiap nga, ngan kanakana ngan ole kaye di kanepe. Nen le ye kene yo lomu bet kalon di ye in nga, ngan ole kalon di. Bong au i o ke bet ayang tanepe ye ke yo kanakana, ngan tiap. ");
INSERT INTO apr_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Le soo so garup i ke bet iyeii pau i, in iyeii oo. Ye in iti kai surunu tani in ilo ye tinik nga, ngan dawa ben ikarata bobok ye kene yo bet tikelmai au ye i. ");
INSERT INTO apr_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Ngan nen le awete pang moolmool nen, pang dama ni ye ni nangai bet di tooltool tipa bet tiwetewete bingi dook mata ke Maro pang di tooltool ye in nga, ngan ole tiwete urata dook mata yo garup i iyeii pau i, in lapau, a bet nen ngan di tooltool lodi tutu ye.” ");
INSERT INTO apr_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Motong la Yesu di galiunu tina yo sangaul be ru nga, ngan atu kidi yo ene Yuta Iskariot i, in ila la iwete pang di tooltool maimai ke paroranga so pang Maro ngan ye dada yo bet itara Yesu lo bedi ye i. ");
INSERT INTO apr_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Ngan tilongo tina yo iwete nen nga le lodi ponana dook, motong la tipamede betanga panga bet ole tikap pat pattu panga. Le nga Yuta tani in ila la inam, inbe lon kaua urata ye lal nangai dook mata ke bet itara Yesu la di tooltool maimai tina ngan bedi ye i. ");
INSERT INTO apr_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Tinepe a tilo ye ke yo imugu pang lal yo di Yuda bet tigaua a tikana porong yo taukan so yo bet iyeii a isung i, in pombe. Le nga di Yuda titoo dada le momo kidi a bet tiraumata asara yo ene sipsip in a tikani, inbe lodi tut ye Paskimoolooningi ke Maro. Motong la Yesu di galiunu tina ngan titoru nen, “Ni nangai lom bet la ampare kaningi yo bet la kon ye lal ke Paskimoolooningi ke Maro ye i?” ");
INSERT INTO apr_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Le nga Yesu iwete pang di galiunu ru yo bet iwanga di a tila ngan nen, “Angru kapa le lo pombe malala mai lono nga, ngan ole tool atu yo isolo ran bor somai in itauarai ang dada, lo ngan bet katoo a kaye kala. ");
INSERT INTO apr_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Katoo a kala le kakamata bet idewe pang ye rumu atu nga, ngan katoo a kalo le lo katoro rumu taunu nen. Kayei ne, ‘Pannoongoo kiam iwete bet man amtorong nen: Rumu lono yo kukarata pau bet se aye di galiuk amnepe ye inbe amkana kaningi ke Paskimoolooningi ke Maro ye i, in la nangai i?’ ");
INSERT INTO apr_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Ngan ole tool tani in ipitnaia rumu lono somai atu yo iken ke ete, in pang. Ngan rumu lono tani in tikarata kakawa ke burungu le ke kaningi so, inbe so yo kapala ngan tipare a iken ye oo. Lo ngan bet angru kalo a lo kapare kaningi paidi nango.” ");
INSERT INTO apr_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Motong la di galiunu ru tina ngan tigege sila inepe, inbe tipa le lo pombe ye malala mai tani in. Ngan le tikamata so tina le imot ngan pombe ben tina yo Yesu iwete pang di nga. Motong la yeru tipare kaningi yo bet tikan ye lal ke Paskimoolooningi ke Maro nga. ");
INSERT INTO apr_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Tinepe le ke idu a rrai, motong la Yesu iye di galiunu tina yo sangaul be ru nga, ngan tipa le lo pombe. ");
INSERT INTO apr_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Le nga tilo le lo tiwur ye kakawa ke kaningi a nga tikan so, motong la Yesu iwete pang di. Iyei ne, “Awete pang moolmool nen, ang tina nga atu yo dookoot ngan amru amwur inbe amkan so i, in ole itarau la di koi kiau bedi.” ");
INSERT INTO apr_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Ngan di galiunu tilongo tina yo iwete nen nga, le lodi moo mai san. Le nga di atu atu titoru nen, “Ai, au i la kuwete nen yau i, too tiap?” ");
INSERT INTO apr_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Ngan iyei ne, “Ang tina yo sangaul be ru nga, ngan atu kiang yo amru amtoko porong inbe amsili du omai lono i, in ye la bet iyei nen i. ");
INSERT INTO apr_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Ngan nen le Tool Moolmool ke Maro ole tiraumate a imata ben tina yo tiwodo betanga ki lo ye Rau ke Maro nga. Bong barau, tool yo bet itara Tool Moolmool ke Maro la di koi ki bedi i, in ole isolo masngana mai le masngana mai ki taunu. Nga yo bet tinana ipasuiu tiap nga, ngan matin nga le dook mata.” ");
INSERT INTO apr_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Le nga tikanen so go, inbe Yesu ikaua porong atu a iwete lo ponana ki pang Maro ye, motong itepalapala a ikap pang di galiunu tina, inbe iwete pang di nen. Iyei ne, “Bi, kakap. I au medak.” ");
INSERT INTO apr_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Motong la ikaua ruku a iwete lo ponana ki pang Maro ye, inbe ikauu pang di galiunu tina ngan di le imot a tiyin ye. ");
INSERT INTO apr_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Inbe iwete pang di nen, “I au rara kiau yo bet apamede betanga medana pang ye i. Ngan la le apatioo bet nen a Maro ilon di tooltool alunu ye. ");
INSERT INTO apr_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Awete pang moolmool nen, au i o ke bet ayin ooroo wain surunu mulu tiap, le ilo ye lal paunu yo Maro bet matan kala di tooltool ki ye i, ngan la bet ayin mulu nga.” ");
INSERT INTO apr_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Yesu iwete nen a imot, motong la iye di galiunu tiwouo woungu ke sungunu atu, inbe tipas a tidu tana a tilo pang kawal Olip. ");
INSERT INTO apr_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Yesu iye di galiunu tipa a bet tilo pang kawal Olip, ngan iwete pang di nen, “Ang nga ole kagege lomu medana yo kataru pau i, inbe ang le imot kakoo yau. Awete pang nen, yesoo betanga yo tiwode lo ye Rau ke Maro in iwete nen, ‘Au i ole araumata tool yo matan kala di sipsip i, ngan ole di sipsip ki tina timayiriyiri a tikoo.’ ");
INSERT INTO apr_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Bong ole amadit mulu ye ni ke matenge, lo ngan bet amugu pang le la anamang la Galili ngo.” ");
INSERT INTO apr_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Motong la Pita iwete panga nen, “Kumata le di galium nga le imot bet tigege lodi medana yo titaru pong i, inbe tikoo yong nga, ngan au i o ke bet akoo yong tiap.” ");
INSERT INTO apr_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Motong la Yesu iraua betanga ke Pita nen, “Awete pong moolmool nen, dookoot bong katai nga, ngan ole tareke itang le paru tiao, inbe kupataukala a kuwete le patol bet ong i lom galanga yau tiap.” ");
INSERT INTO apr_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Bong ngan Pita iwete le koon mede a iyei ne, “O tiap! Kumata le lodi bet au i tiraumatau lapau a aru tammata nga, ngan o ke bet awete a apataukalong bet au i lok galanga yong tiap, ngan tiap.” Ngan le di galiunu tina yo kapala nga, ngan di le imot tiwete betanga gaongo nen lapau. ");
INSERT INTO apr_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Yesu iye di galiunu tipa le lo pombe ye ni atu yo ene Getsemani i. Motong la iwete pang di nen, “Si kawur nanga, inbe au ole ala apatarau pang Maro ngan.” ");
INSERT INTO apr_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Motong la ikaua Pita iye Yemis inbe Yowan a iye di leu tila. Ngan tila, bong Yesu ikanamaii, ngan lon madoko le lon moo mai san. ");
INSERT INTO apr_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Le nga iwete pang di galiunu tina ngan nen, “Au i lok moo mai san le ayetai ben nga bet amata. Le kanepe nanga, inbe matamu rere a kanat.” ");
INSERT INTO apr_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Motong la ipa le ila manga mooloo kasin, inbe iro du igun turunu tana a ipatarau pang Maro bet dada sa dook mata iken nga, ngan lono panga a ipalele lal ke masngana yo bet pombe pang ye i. ");
INSERT INTO apr_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Le nga ipatarau nen, “Tamak, so tina le imot nga, ngan sa yo bet imoo pong, ngan tiap. Le au i lok bet kukutaka ruku ke masngana i yau. Bong ken kutoo au lok be, kutoo ong taum lom leu.” ");
INSERT INTO apr_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Yesu ipatarau nen a imot, motong la bet imulu a ila, ngan ikamata di galiunu tina yo tol nga, ngan tiken mata oo. Le nga iwete pang Pita nen, “Ona Simon, nga kukenen mata, too? O ke bet matam rere a kunat ye manga kasin nga tiap, too? ");
INSERT INTO apr_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Ngan nanga, matamu rere a kanat dook inbe kapatarau, a nen ngan touanga sa bet pombe pang yang nga, ngan o ke bet kamol tiap. Moolmool, lomu ngan bet kayei urata yo nen nga, bong tinimu ngan taukan gurana.” ");
INSERT INTO apr_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Yesu iwete pang di nen, motong la igege di a imulu la ipatarau pattu mulu dawa ben yo iyei mugu nga. ");
INSERT INTO apr_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Motong la bet imulu a iman pang ye di, ngan ikamata di tina yo tikenen mata mulu nga, yesoo matadi ge mai mata. Ngan nen le lodi galanga ye soo betanga yo bet tiweta panga, in tiap. ");
INSERT INTO apr_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Le nga Yesu la ipatarau patol ki a imulu a iman, motong la iwete pang di galiunu tina. Iyei ne, “Ai, nga kamaryoo a kakenen mata go, too? Kaken mata dookoot! Lal tani in pombe oo. Kakamata, dookoot nga tool atu bet itara Tool Moolmool ke Maro la di tooltool ke sennene bedi. ");
INSERT INTO apr_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Le kamadit a tala! Tool tani yo bet itarau la di koi kiau bedi i, in ye la iman i.” ");
INSERT INTO apr_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Yesu iwetewete nen go, inbe di galiunu tina yo sangaul be ru nga, ngan atu kidi yo ene Yuta i, in ipa man pombe. Iman ngan iye di tooltool malala mai yo tikap pul le kai ke patokongo ngan la timan nga. Di ngan di tooltool maimai ke paroranga so pang Maro, tiye di pannoongoo ke wer ke Maro, inbe di tooltool maimai kidi Yuda la tiwanga di a timan nga. ");
INSERT INTO apr_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Ngan tool tani yo bet itara Yesu la di koi ki bedi i, in ikarata betanga pang di tooltool tina ngan mugu nen, bet ole iyeie so sa pang Yesu a iyei ben tarkilanga pang di. Ngan iwete nen, “Kakamata tool atu bet awarra a asomo pangana i, in tool tani nain, a kakauu a kaparama le imede, inbe matamu kala dook a kadede a kala.” ");
INSERT INTO apr_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Motong la Yuta tani in palbe leu be ipa gorro Yesu a ila le la iwete panga nen, “Pannoongoo!” Inbe iwarra a isomo pangana. ");
INSERT INTO apr_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Le nga di tooltool yo iye di tila nga, ngan titokolana Yesu a tiparama. ");
INSERT INTO apr_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Motong la di tooltool tina yo tikododo potai pang ye nga, ngan atu in iposo pul ki ke patokongo tina le itarakede kapraingi ke tool kuto mai ke paroranga so pang Maro, in talngana, le imakede. ");
INSERT INTO apr_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Motong la Yesu iwete pang di tooltool tina yo bet man tiparama ngan nen, “Ai, au i tool dook tiap ke patokongo le pinnau la kakap pul le kai ke patokongo a kaman bet man kaparamau nga, too? ");
INSERT INTO apr_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Ye ke kanakana ngan ayang tanepe koongoo lono ke bareme mai ke sungunu a apatomonai di tooltool, ngan lomu bet kakau au a kaparamau ye ni tani in tiap. Bong dookoot bet so nen pombe, a bet nen ngan iyeie betanga tani yo tiwode lo ye Rau ke Maro in le kanono pombe moolmool.” ");
INSERT INTO apr_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Motong la Yesu di galiunu tina yo tiye tila nga, ngan di le imot tigege sila inepe, inbe tikoo belebele a tila. ");
INSERT INTO apr_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Ngan tamoto koskos atu yo itoo Yesu a tila ye ni tani i, in ipariri so siap bong iwiti mala koonoo leu. Le nga bet tikauu a tiparama lapau, ");
INSERT INTO apr_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","ngan tikapsapi le tikaua mala ki sila ikino, inbe idada tinini koonoo a ila. ");
INSERT INTO apr_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Di tooltool tina tiparama Yesu, motong tikauu a tilo pang rumu lono ke tool kuto mai ke paroranga so pang Maro nga, ngan le di tooltool maimai ke paroranga so pang Maro, tiye di tooltool maimai kidi Yuda, inbe di pannoongoo ke wer ke Maro, ngan di le imot man tigaua inbe tinepe a tinam. ");
INSERT INTO apr_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Ngan Pita lapau itoo Yesu a ilo, bong le ben ipa manga mooloo kasin ye. Itoo a ipa so le ilo koongoo lono ke rumu ke tool kuto mai ke paroranga so tani, motong la ipa le la iye di gaunu yo bet matadi kala rumu ngan tiwur, inbe ei loo. ");
INSERT INTO apr_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Inbe di tooltool maimai ke paroranga so pang Maro, ngan tiye di tooltool kuto maimai kidi Yuda le imot yo matadi kala momo le nepongo kidi nga, ngan tikapge bet tisere di tooltool bet man tipaposo Yesu ye urata yo ikapsap ye nga, a bet nen ngan tiraumate le imata. Bong ngan mala bet tipusye toko siap. ");
INSERT INTO apr_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Moolmool, di tooltool alunu la man tisopo koodi panga ye betanga kidi yo ke kaplungunu nga, bong ngan betanga kidi yo tiwete ngan gaongo tiap le taukan kanono. ");
INSERT INTO apr_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Motong la di tooltool tina ngan pattu timadit lo tikodo, inbe tisopo koodi panga ye betanga kidi yo ke kaplungunu ngan a tiwete nen, ");
INSERT INTO apr_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Am nga amlongo tool in iwete nen. Iyei ne, ‘Au i ole asaua bareme mai ke sungunu yo di tooltool tire i, lo ngan bet ole apatokodo san mulu ye ke tol leu. Ngan bareme san tani, in dawa ben yo di tooltool tire ye bedi, in tiap.’” ");
INSERT INTO apr_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Tiwete nen, bong ngan betanga kidi gaongo tiap, le taukan kanono lapau. ");
INSERT INTO apr_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Motong la tool kuto mai ke paroranga so pang Maro in imadit lo ikodo dama kidi, inbe itoro Yesu. Iyei ne, “Ai, nga gelei a lom bet kurau betanga kidi tiap nga? Nga ole kuwete balai ye betanga yo di tooltool tina nga tiweta yong i?” ");
INSERT INTO apr_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Bong ngan Yesu iraua betanga ki tiap, ipas le ipalongo leu. Motong la tool kuto mai ke paroranga so pang Maro tani in itoru mulu nen, “Oo kuwete, ong i Kirisi, tool tani yo Maro ipootoo bet si ikap di tooltool ki a ipamulu di ye so dook tiap yo bet igarung di i, too? Inbe ong i Maro tani yo bet iyei urata dook mata pang di tooltool i, in Natunu, too tiap?” ");
INSERT INTO apr_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Ngan Yesu iyei ne, “E, au tani naii. Ngan pang dama ni nga, ngan ang nga ole kakamata Tool Moolmool ke Maro iwur ye Maro yo gurana ki mai mata in bene oonoo, inbe ipa ye eng tene a isi pang tana.” ");
INSERT INTO apr_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Tina Yesu iwete nen nga, le nga tool kuto mai ke paroranga so pang Maro in katen malmal a isarraka sousoungu mooloo ki, inbe iyei ne, “Imot oo! Nga bet tasere di tooltool sa mulu bet man tipaposi paidi pang soo? ");
INSERT INTO apr_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Ang nga o kalongo yo iwete bet ye in ole ikaua malala ke Maro, ngan oo. Le nga lomu bet ole tayeie soo so pang tool i?” Ngan di tooltool tina ngan di le imot tigaua koodi, inbe tiyei ne, “Ye in iyei dada dook tiap a taraumate le imata.” ");
INSERT INTO apr_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Motong la di tooltool tina ngan kapala timadit a tikorokoronaii, inbe tipaukala matana ye mala, motong la tilok bedi a tirauu, inbe titoru nen. Tiyei ne, “Oo, bet ong i Maro koonoo moolmool nga, ngan kuwete too.” Inbe di gaunu tikauu a tila a la tirauu. ");
INSERT INTO apr_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Pita tani in inepe la koongoo lono ngo, inbe garup nene atu yo iyei kapraingi pang tool kuto mai ke paroranga so pang Maro, in ipa a iman. ");
INSERT INTO apr_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Iman ngan ikamata Pita yo ei loo nga, le nga matan kenen ye, inbe iyei ne, “Ai, ong i kuye Yesu yo ke Nasaret i, in kanepe lapau.” ");
INSERT INTO apr_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Bong ngan Pita ipataukala le nga iyei ne, “Atoo, au i nga lok sarara le lok galanga ye soo so yo kuwetewete ye, in tiap.” Motong la ipas a ipa a idu potai pang ye dada koonoo nga, ngan tareke atu itang. ");
INSERT INTO apr_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Ye kene yo garup kapraingi tani in ikamata mulu nga, ngan ila le la iwete pang di tooltool yo tikododo potai ye ni tani nga, ngan nen, “Ai, tool in di tooltool tina ngan atu kidi.” ");
INSERT INTO apr_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Bong ngan Pita ipataukala mulu. Le nga tinepe le mooloo tiap, inbe di tooltool yo tikododo potai ye nga, ngan tiwete panga nen, “Moolmool sa, ong i di tooltool tina ngan atu kidi, yesoo ong i tool ke Galili lapau.” ");
INSERT INTO apr_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Bong ngan Pita koonoo mede ye betanga a ipamede betanga ki, inbe iyei ne, “Kumata le bet allung nga, ngan dook mata nen bet Maro igarungau. Le awete pang moolmool le ete nen, au i lok galanga ye tool yo kawetewete ye, in tiap.” ");
INSERT INTO apr_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Ngan iwete nen, le tina pattu leu inbe tareke itang mulu le paru ki. Motong la se Pita lon tutu betanga yo Yesu iweta i. Ngan mugu ngan Yesu iwete pang Pita nen, “Dookoot bong katai nga, ngan ole tareke itang le paru tiao, inbe kupataukala a kuwete le patol bet ong i lom galanga yau tiap.” Ngan nen le Pita lono dook tiap le iman tina le itang belebele. ");
INSERT INTO apr_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Tinepe le nga muntu bongmai koot, motong la di tooltool maimai ke paroranga so pang Maro, tiye di tooltool maimai kidi Yuda, inbe di pannoongoo ke wer ke Maro, inbe di tooltool kuto maimai kidi Yuda le imot yo matadi kala momo le nepongo kidi nga, ngan la tigaua inbe tiwetewete a tiraua betanga ye soo so yo bet tiyeii pang Yesu i. Motong la tipauu ye ooroo medana, inbe tikauu a tila la titaru la Pailot bene nga. ");
INSERT INTO apr_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Tila pombe, motong la Pailot itoru nen, “Oo kuwete, ong i la tool kuto mai yo matam kala di Yuda le imot i, too?” Ngan Yesu iraua betanga ki nen, “E, dawa ben tina la kuwete koot nga.” ");
INSERT INTO apr_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Ngan di tooltool maimai ke paroranga so pang Maro tisopo koodi ye betanga alunu kaiye panga. ");
INSERT INTO apr_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Le nga Pailot itoru mulu nen, “Nga gelei ole kurau betanga kidi nga tiap, too? Kumata, so alunu kaiye la tiwetewete yong nga.” ");
INSERT INTO apr_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Bong ngan Yesu mala bet iwete toko betanga sa a bet iraua betanga ki ye, ngan tiap. Ngan nen le Pailot itakrai belebele ye yo ye taunu ikata suanga ye tiap nga. ");
INSERT INTO apr_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Ye rai kanakana nga, ngan kumata bet lo tigoro lal kidi Yuda ke bet tikanen inbe lodi tut ye Paskimoolooningi ke Maro nga, ngan di tooltool yo tinepe rumu dook tiap kidi talnga dikidiki lono nga, ngan ole Pailot ipadu atu a idu tana. Bong ole di tooltool le imot tipootoo tool yo lodi bet ipadua a isi diki in ene. ");
INSERT INTO apr_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Ye kene tani in tool atu yo ene Barabas i, in iye di diene tinepe rumu dook tiap kidi talnga dikidiki lono. Di ngan ye kene yo tipamaditi patokongo a bet tinganga di Rom nga, ngan le tiraumatamata di tooltool kapala ke Rom. ");
INSERT INTO apr_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Ngan nen le di tooltool malala mai tina yo tigaua nga, ngan tila pang ye Pailot la titoru bet iyei dawa ben yo rai kanakana ngan iyei nga. ");
INSERT INTO apr_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Motong la Pailot tani in itor di nen, “Ai, lomu bet apadu tool kuto mai yo matan kala di Yuda le imot in a isi pang yang, too?” ");
INSERT INTO apr_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Ngan Pailot iwete nen nga, yesoo ye in lon galanga bet di tooltool maimai ke paroranga so pang Maro nga, ngan lodi dook tiap pang Yesu, yesoo tikamata ben di tooltool tiyitmaka ene, ngan la le tikauu a la titaru lo bene nga. ");
INSERT INTO apr_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Bong ngan di tooltool maimai ke paroranga so pang Maro ngan tiso di tooltool malala mai tina ngan lodi bet koodi pang Pailot a bet ipadu Yesu be, bong bet nen ngan ipadu Barabas a isi pang ye di. ");
INSERT INTO apr_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Motong la Pailot itor di mulu nen, “Lomu balai ye tool yo kawete bet ye in tool kuto mai yo matan kala di Yuda le imot i? Ole ayeie soo so panga?” ");
INSERT INTO apr_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Ngan koodi le mai nen, “Kupatota lo kai palasingi kaini a imata!” ");
INSERT INTO apr_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Motong la Pailot itor di mulu nen, “Nga gelei? Soo dada dook tiap ikapsap ye i?” Bong di tooltool tina ngan oorootang a koodi le mai mulu nen, “Kupatota lo kai palasingi kaini a imata!” ");
INSERT INTO apr_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Ngan Pailot tani in lono bet iyei di tooltool malala mai tina a lodi ponana, le nga ipadu Barabas si tana a idu pang ye di. Inbe iwete a di tooltool ke patokongo tisaliti Yesu ye ooroo medana, motong la ikauu a itaru la bedi a tikauu bet du tipatota lo kai palasingi kaini nga. ");
INSERT INTO apr_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Di tooltool ke patokongo tikaua Yesu a tilo koongoo lono ke rumu ke Pailot. Motong la tikiu di diedi tooltool ke patokongo ngan a di le imot timan. ");
INSERT INTO apr_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Motong la tisousouu ye sousoungu yo kooroonoo dook mata i, inbe tikaua ooroo yo dongana iso in a titali, motong la titaru lo Yesu kutono. ");
INSERT INTO apr_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Inbe tiwete panga nen, “Aa, tool kuto mai yo matam kala di Yuda le imot i, kemai dook!” ");
INSERT INTO apr_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Motong la tikaua toto atu a tirauraua kutono ye, inbe tikorokoronaii. Motong la tigun turudi a tiyei tomonai dawa ben bet tiyitmak ene nga. ");
INSERT INTO apr_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Ngan tipalele sere ye a imot, motong la tidudu sousoungu tani yo kooroonoo dook mata i, inbe tisousouu ye sousoungu ki ye taunu mulu. Motong la tikauu a tila bet la tipatota lo kai palasingi kaini. ");
INSERT INTO apr_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Tikaua Yesu a tila le la titauaraia Simon ke malala mai Sairini yo Aleksanda ye Rupus tamadi i. Ye in ipa ke ni san a iman a bet ilo pang koongoo lono ke malala mai tani in. Motong la di tooltool ke patokongo tina ngan tiparama a tiwete le koodi mede ye betanga panga bet ilono Yesu a isolo kai palasingi ki pa. ");
INSERT INTO apr_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Inbe di tooltool ke patokongo tina, ngan tipawewe Yesu a tilo pang ye ni yo tiwete ene ye Golgata i. (Ngan betanga yo Golgata in punu ben, Tool Kutono Ruruana). ");
INSERT INTO apr_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Tilo, motong la tipargarungnai ooroo wain surunu in ilo ye bar, inbe tikauu pang Yesu a bet iyinu. Bong lono panga tiap le isukraii. ");
INSERT INTO apr_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Motong la di tooltool ke patokongo tina ngan tipatoto Yesu lo kai palasingi kaini, inbe tikap sousoungu le so ki a bet timalimi di tapdi ye. Le nga titoo moomoo kidi a tikatte madamada bet ole tipusye sima tooltool yo bet tikap so tina ngan atu atu pang di nga. ");
INSERT INTO apr_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Le ye ke matana limi be pai la tipatoto Yesu lo kai palasingi kaini ye i. ");
INSERT INTO apr_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Motong la tiwodo betanga tina yo tikadoni ye a le tirauu, ngan nen: Tool Kuto Mai Yo Matan Kala Di Yuda Le Imot I. ");
INSERT INTO apr_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","28","Inbe ye kene tani yo tipatoto Yesu lo kai palasingi kaini ye in nga, ngan le tipatoto di tooltool ru ke pinnau lapau. Le atu inepe ke Yesu bene oonoo, inbe san ke bene ngas. ");
INSERT INTO apr_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Ngan di tooltool tina yo tipa a tila be timan nga, ngan matadi gaga pang ye a tikilkiloi. Inbe tikan paseme, a tiyei ne, “Ai! In ong tool tani yo kuwete bet ole kusaua bareme mai ke sungunu, lo ngan bet kupatokode mulu ye ke tol leu i, too? ");
INSERT INTO apr_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Bet nen ngan ong taum kulonong a kugege kai palasingi in a kusi tana, e too.” ");
INSERT INTO apr_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Inbe gaongo leu ye di tooltool maimai ke paroranga so pang Maro, inbe di pannoongoo ke wer ke Maro, ngan di lapau di tapdi tiwetewete a tiyei sere ye Yesu. Inbe tiyei ne, “Kakamata, kanakana ngan ilon di tooltool kapala, bong nga gelei a le ye taunu iloni tiap nga? ");
INSERT INTO apr_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Iwete bet ye in Kirisi, tool yo Maro ipootoo bet si ipamulu di tooltool ki i, inbe tool kuto mai yo matan kala di Isrel le imot i, too? Kumata bet igege kai palasingi ni a isi tana dookoot nga, ngan la bet takamata, ngan tatara lodo medana ye nga.” Inbe di tooltool ru tina yo tipatoto di lo kai palasingi kaini potai pang ye Yesu nga, ngan di lapau tikan paseme Yesu. ");
INSERT INTO apr_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Kemai ye ke matana sangaul be ru, ngan todo iduku tana mai i le imot, a iken nen le du rrai ye so ben ke matana tol. ");
INSERT INTO apr_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Motong la ye ke matana tol nga, ngan Yesu koonoo le mai nen, “Eloi, Eloi, lema sabaktani?” Ngan betanga tina ngan lono ki nen, “Maro kiau, Maro kiau, nga gelei a le kugegau nga?” ");
INSERT INTO apr_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Ye kene tani in di tooltool pattu yo tikododo potai ye nga, ngan tilongo tina yo iwete nen nga, le nga tiyei ne, “Ai, kalonga lapau, ngo koonoo pang Ilia.” ");
INSERT INTO apr_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Motong la tool atu idada la ikaua so ben punpun a isilia du ye ooroo wain surunu yo malingene in lono, inbe isuiu ye piu kaini a isulmaii lo pang Yesu koonoo a bet iyinu. Inbe iwete nen, “Oi, tagege si inepe a takamata toka. Ole Ilia si iloni a iyunu ye kai palasingi ni a isi tana, too tiap?” ");
INSERT INTO apr_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Motong la Yesu koonoo le somai, inbe imaroon pattu leu le tina imata yege. ");
INSERT INTO apr_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Ngan nen le mala matolene yo tituka bareme mai ke sungunu lono i, in imassarak ke ete a ipa so le idu lopo le iyei paru. ");
INSERT INTO apr_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Inbe ye kene tani in tool kuto mai yo matan kala di tooltool ke patokongo i, in ikododo dama ke Yesu. Nen le ilongo tina yo Yesu koonoo le mai nga, inbe ikamata so tina yo Yesu iyei motong imata nga, le nga iyei ne, “Ona, moolmool sa, tool i Maro Natunu!” ");
INSERT INTO apr_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Ngan di garup pattu ngan tikodo ben manga mooloo kasin, inbe tikamata so yo pombe pang ye Yesu nga. Ngan le di garup tina, ngan atu in ene Madia ke malala Makdala, inbe san in Madia yo Yemis kase in iye Yoses tinadi i, inbe garup san in Salume. ");
INSERT INTO apr_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Di ngan, ye kene yo Yesu inepe Galili ye in nga, ngan titoo a tiloni. Inbe di garup yo titoo a tiye tilo pang Yerusalem nga, ngan alunu kaiye la tinepe lapau nga. ");
INSERT INTO apr_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Ye kene tani in lal ke parenge, yesoo mongmongini ki ngan ole tilo ye lal kidi Yuda ke sungunu. Le nga tinepe a du rrai, ");
INSERT INTO apr_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","motong la Yosep ke malala mai Arimatia i, in lono atu bet ikaua Yesu bobono. Ngan Yosep tani in di tooltool alunu tiyitmaka ene, inbe ye in inepe ye budanga ke di tooltool kuto maimai ke karatanga betanga kidi Yuda. Inbe ye taunu in inam bet ikamata dada yo Maro bet matan kala di tooltool ki ye i, in pombe mallangana. Le nga itattadai tiap, bong ipa so le lo ikodo dama ke Pailot, a itoru bet ikaua Yesu bobono. ");
INSERT INTO apr_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Ngan ye kene yo Pailot ilongo betanga ben Yesu imata koot nga, ngan le itakrai. Motong la ikiui tool kuto mai yo matan kala di tooltool ke patokongo in man itoru nen, “Ai, kuwete, Yesu tani in imata koot, too tiap?” ");
INSERT INTO apr_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Ngan tool kuto mai tani in iyei ne, “Imata oo.” Motong la Pailot imalum pang Yosep bet la ikaua Yesu bobono nga. ");
INSERT INTO apr_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Le nga Yosep la iyimi mala kookoonoo a ikap a ila, motong la iyunu Yesu bobono a iyiti du tana. Inbe ipiuu ye mala tani le dook mata, motong la ikauu la itaru ye agoro ke tarungu di matenge yo tikeli sakar madini i, in lono. Inbe itapulu pat somai atu la ikatkala agoro tani in koonoo ye. ");
INSERT INTO apr_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Ngan Madia tani ke malala Makdala i, in iye Madia san yo Yoses tinana i, ngan tiye di tinepe lapau le tikamata ni tani yo titara Yesu bobono ye i. ");
INSERT INTO apr_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Tinepe ye lal kidi Yuda ke sungunu tani in a imot, motong la Madia ke malala Makdala in iye Madia san yo Yemis tinana i, inbe Salume, ngan tiyimi kai surunu yo kini ki dook mata nga bet la tisalini Yesu bobono ye. ");
INSERT INTO apr_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Motong la muntu bongmai koot ye ke yo Sande in nga, ngan ke ipiti matana tiao, inbe di tol timadit a bet tila pang ye agoro tani yo titara Yesu bobono ye i. ");
INSERT INTO apr_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Tipa a tila ngan di tapdi tiwetewete nen, “Ai, ole sei tool bet ipulu pat a ikoo ye agoro koonoo paidi i?” ");
INSERT INTO apr_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Bong ngan ye kene yo bet matadi gaga ye in nga, ngan tikamata pat somai tani in tipulu a ikoo ye agoro koonoo oo. ");
INSERT INTO apr_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Le nga tidewe a bet tilo pang agoro tani in lono, ngan tikamata tamoto koskos atu in iwur ke bedi oonoo. Inbe isousou ye sousoungu kookoonoo mooloonoo. Ngan tikamata le nga titattadai. ");
INSERT INTO apr_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Motong la tool tani in iwete pang di nen, “Ken katattadai be! Au i lok galanga bet ang ngan kaman bet man kasere Yesu ke Nasaret yo tipatota lo kai palasingi kaini a imata i. Bong ye in inepe ni tiap. Ye in imadit mulu ye ni ke matenge oo. Le kaman man kakamata ni yo titara bobono ye i. ");
INSERT INTO apr_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Bong kakamata nene, lo ngan bet kamulu a kala la kakaua bingi pang di galiunu, inbe Pita lapau. Ngan kawete pang di nen, ‘Yesu imugu a ila pang Galili oo. Le katoo a kala ngan la bet la kakamata nango, ben tina yo mugu ngan iwete pang nga.’” ");
INSERT INTO apr_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Tina yo ngan le di garup tina ngan titattadai a titangarur le dook tiap yege, inbe tipas a tidu tana le tina tidada a tigege agoro tani in a tila. Ngan le tiwete toko pang tool siap, bong tipa so a tila, yesoo titattadai. ");
INSERT INTO apr_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Ye Sande muntu yege ngan Yesu imadit mulu ye ni ke matenge, inbe la pombe pang ye Madia ke Makdala in mugu. Ngan ye in mugu ngan Yesu inganga di so sidi limi be ru ye. ");
INSERT INTO apr_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Motong la Madia tani in ila bet la iwete pang di tooltool tina yo tiye Yesu tipa nga. Ngan di ngan lodi madoko a nga titangtang ye. ");
INSERT INTO apr_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Ila le la iwete pang di bet Yesu imagur mulu le ikamata ye matana, bong ngan titara lodi medana ye betanga ki tiap. ");
INSERT INTO apr_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Madia iwete pang di nen a imot, motong la Yesu di galiunu ru tigege malala mai inbe tipa a tila, motong la Yesu pombe pang ye di. Bong ngan tikilala tarrai tiap, yesoo matan palele mulu le dawa ben mugu nga tiap. ");
INSERT INTO apr_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Motong la yeru timulu la tiwete pang di diedi kapala, bong ngan di diedi tina ngan titara lodi medana ye betanga kidi yeru tiap lapau. ");
INSERT INTO apr_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Le ye kene san, ngan di galiunu tina yo sangaul be atu nga, ngan tigaua a tikanen so, inbe Yesu ipa le lo pombe pang ye di. Ngan le ipasak pang di, yesoo di tooltool tikamata yo imadit mulu nga le la tiwete pang di, bong ngan kutodi imede mata le lodi bet titara lodi medana ye betanga kidi tiap. ");
INSERT INTO apr_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Motong la iwete pang di nen, “Nga ole kala kapa ye ni mai i le imot, inbe kawetewete bingi dook mata kiau pang di tooltool nga le imot. ");
INSERT INTO apr_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Ngan nen le kumata sei tool bet itara lono medana ye a karriuu nga, ngan Maro ole ikauu a ipamule ye so dook tiap yo bet igarungu i. Bong kumata sei tool bet itara lono medana ye tiap nga, ngan Maro ole ipaposi ye dada dook tiap ki yo iyeii i, a bet nen ngan iyemenaii ye. ");
INSERT INTO apr_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","E di tooltool yo titara lodi medana ye bingi dook mata kiau nga, ngan ole akap gurana pang di bet tiyei mos ye. Le ye gurana ke au ek, ngan ole tinganga di so sidi ye di tooltool, inbe ole tiwetewete ye di malala malala koodi. ");
INSERT INTO apr_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Inbe kumata le bet tikaua moto dook tiap ye bedi, too tiyin ran yo tigarung ye bar dook tiap nga, ngan o ke bet igarung di tiap yege. Inbe kumata le bet tipaloko bedi lo di tooltool yo matamatenge ikap di ngan podi, inbe tipatarau pang Maro bet ilon di nga, ngan ole tinidi dook mata mulu.” ");
INSERT INTO apr_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Tool Mai Yesu iwete pang di nen a imot, motong la Maro ikauu a ipamule a ilo pang ye malala ki nga, ngan le lo iwur ye bene oonoo. ");
INSERT INTO apr_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Motong la di galiunu tina ngan tila la tiwetewete bingi dook mata ki ye ni mai i le imot nga. Ngan le Tool Mai Yesu inepe ye di a ilon di ye urata kidi, inbe ipamede di le tiyei mos matana matana a bet nen ngan di tooltool tikamata ngan lodi galanga ben betanga kidi tina ngan moolmool. ");
INSERT INTO apr_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Tool mai Tiopilus, nga bet awete pong nen, mugu ngan di tooltool alunu la titouo bedi bet tiwodo betanga ke so tina le imot yo Maro iyei a pombe kataunu yam nga. ");
INSERT INTO apr_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Ngan nen le tiwodo betanga tina yo tilongo ye di tooltool yo kulkulunu yege, ngan di tapdi tikamata so tina ngan kanono moolmool ye matadi, inbe tikaua urata ye a tiraia bingi ki paidi nga. ");
INSERT INTO apr_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Ngan tina au tauk i ator panin di tooltool tina a tipagalangau dook ye so tina ngan punu, ngan la akamata ngan dook mata ke bet au lapau awodo betanga galangana pong ye so tina yo pombe nga. ");
INSERT INTO apr_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Le awodo rau i pong a bet nen ngan kukinkati ngan lom galanga nen, betanga yo tipatomonai ong ye nga, ngan moolmool le imot. ");
INSERT INTO apr_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Ye kene yo Erot iyei tool kuto mai a matan kala tana mai Yudia ye in nga, ngan tool atu ke paroranga so pang Maro, in ene la Sakaria i. Ye in inepe ye budanga atu ke di tooltool ke paroranga so pang Maro yo tiweta ye Abia i. Ngan iye rimana yo Ilisapet, ngan Aron di sasa ki. ");
INSERT INTO apr_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Inbe yeru ngan tiyei dada dook mata ye Maro matana. Inbe titoo noonoongoo le wer ke Maro nga le imot, le tinepe le taukadi busunu ye matana. ");
INSERT INTO apr_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Bong yeru taukadi natudi, yesoo Ilisapet ipassui tiap le iye Sakaria tinepe tinepe a tiyei konga konga oo. ");
INSERT INTO apr_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Ye kene atu in Sakaria iye di diene tooltool ke paroranga so yo tinepe ye budanga ke Abia nga, ngan lal kidi bet tilo tiyei urata kidi ye bareme mai ke sungunu. Ngan le Sakaria ilo bareme mai ke sungunu lono bet lo iyei urata ki ke paroranga so pang Maro. ");
INSERT INTO apr_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Motong la titoo momo kidi ke bet tikatte madamada a bet nen ngan tipusye sei tool ke paroranga so, bet ole ilo idaun so kini ki dook mata ben kai maiyo kulini in pang Maro i. Ngan le Sakaria tani, in ye la madamada ipaposi bet ilo bareme mai ke sungunu lono i. ");
INSERT INTO apr_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Ngan ye kene yo Sakaria lo idaun so ke paroranga pang Maro ye in nga, ngan di tooltool alunu la tigaua ke bareme diki ki a tipattarau nga. ");
INSERT INTO apr_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Sakaria ilo, motong la bangabangana ke Tool Mai atu pombe pang ye le ikodo ke kakawa yo bet tidaun so kini ki dook mata ye i, in madini oonoo. ");
INSERT INTO apr_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Ngan yeiso bet Sakaria ikamata bangabangana ke Maro tani, motong le itakrai inbe itattadai belebele. ");
INSERT INTO apr_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Bong ngan bangabangana tani iwete panga nen, “Sakaria, ken kutattadai be! Maro ilongo pataraungu kiong oo. Le rimam Ilisapet ole ipasuiu kase tamoto pong. Lo ngan bet kusu ene ye Yowan. ");
INSERT INTO apr_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Ong i ole lom dook mata a lom ponana ye mai san, inbe di tooltool alunu ole lodi ponana ye kene yo bet tinana ipasuiu ye i, ");
INSERT INTO apr_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","yesoo ye in ole Maro ikamata ben tool ene mai. Inbe ye in o ke bet iyin ooroo wain surunu le ran medana tiap. Inbe kene yo inepe tinana kapono lono ye in nga, ngan ole Maro Amunu Silene ipaponi. ");
INSERT INTO apr_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Inbe ole ilon di tooltool alunu ke Isrel a nen ngan tiportak lodi a timulu pang ye Maro yo Tool Mai kidi i. ");
INSERT INTO apr_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Inbe ye in ole Maro Amunu Silene ikaua gurana mai panga dawa ben ke Ilia, a imugu pang Tool Mai. Inbe ole ilon di tooltool maimai a tiportak lodi, a bet nen ngan lodi mai san pang di natudi mulu. Inbe ye in ole ilon di tooltool ke sak noonoongoo, a bet nen ngan titoo wer dook mata kidi tooltool yo noonoodi nga. Inbe ole ilon di tooltool a tikarata lodi le dook mata, inbe tinama Tool Mai yo bet pombe i.” ");
INSERT INTO apr_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Bangabangana ke Maro iwete nen a imot, motong la Sakaria tani iwete panga nen, “Ai, nga ole lok galanga balai, bet betanga kiong i moolmool nga? Yesoo, au i ayei konga, inbe rimak ngan iyei konga lapau oo.” ");
INSERT INTO apr_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Motong la bangabangana tani ke Maro in iraua betanga ki nen, “Au i Gabrel! Inbe kanakana ngan akodo dama ke Maro. Ngan Maro ye taunu la iwangau bet si akaua bingi dook mata i pong i. ");
INSERT INTO apr_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Bong nga gelei, ong i kutara lom medana ye betanga kiau tiap, too? Ngan nen le dookoot nga ole mem modo le ke bet kuwetewete tiap a kunepe nen le ilo ye lal yo Maro ye taunu itaru bet ole so tani in kanono pombe moolmool ye i.” ");
INSERT INTO apr_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Ngan nen le ye kene tani in di tooltool budanga mai tina yo tigaua a tinama Sakaria ke diki nga, ngan tinam kaiye le nga lodi kau urata nen, “Tiap, nga gelei a le isi tarrai tana tiap nga.” ");
INSERT INTO apr_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Motong la yeiso bet ipas a isi tana, ngan men modo le ke bet iwetewete pang di tiap, bong ipas le iyei tomonai pang di ye bene leu. Le nga lodi tar bet o ikamata so sa bareme mai ke sungunu lono, ngan la le ke bet iwetewete tiap a inepe nen leu nga. ");
INSERT INTO apr_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Ngan lal ke Sakaria yo bet iyei urata ke paroranga so ngan lo imot, motong la imulu pang malala ki. ");
INSERT INTO apr_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Le nga tinepe le mooloo tiap, inbe rimana Ilisapet in kapono le ipa mallangana tiap, bong ipas le inepe rumu lono leu ye taudu limi. ");
INSERT INTO apr_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Motong la Ilisapet tani iyei ne, “So i, Tool Mai la lono pau a iyeii pau i. Le dookoot nga ke bet moomook mulu ye di tooltool matadi tiap.” ");
INSERT INTO apr_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Ye kene yo Ilisapet kapono a inepe le taudu limi be atu iman a ila ye in nga, ngan Maro iwanga bangabangana ki yo ene Gabrel in a idu pang ye malala mai yo ene Nasaret i. Ngan malala tani, in iken ye tana mai Galili. ");
INSERT INTO apr_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Bangabangana tani in bet idu pang ye garup nene atu yo ene Madia i. Ngan garup nene tani in titarkala pang tamoto yo ene Yosep i. Ngan Yosep tani in Dawiti yo mugu ngan iyei tool kuto mai i, in sasa ki. ");
INSERT INTO apr_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Le nga bangabangana tani in idu pombe pang ye Madia, motong la iwete lo ponana ki panga, inbe iwete nen, “Tool Mai inepe yong, le iyeie urata dook mata san pong.” ");
INSERT INTO apr_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Bong Madia ilongo betanga ki tina, ngan lon sarrara mai san. Inbe ikapge bet lon kaua urata ye soo betanga tina yo iwete nga, ngan lono ki balai? ");
INSERT INTO apr_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Motong la bangabangana iwete panga nen, “Madia, ken kutattadai be. Maro lono pong mai san a iyeie urata dook mata pong. ");
INSERT INTO apr_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Le kulongo, ong i ole kapom ye kase tamoto atu. Le ye kene yo bet kupasuiu ye in nga, ngan ole kusu ene ye Yesu. ");
INSERT INTO apr_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Ye in ole ene mai, inbe ole tiweta bet ye in Maro yo inepe ete, in natunu. Inbe Tool Mai Maro ole itaru a iyei tool kuto mai a ikolo sasa ki yo Dawiti i. ");
INSERT INTO apr_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Inbe ye in ole iyei tool kuto mai a matan kala Yakop di sasa ki le ikenen leu a ila. Moolmool, ye in ole iyei tool kuto mai le ikenen leu le taukan motingi.” ");
INSERT INTO apr_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Motong la Madia itoro bangabangana ke Maro tani in nen, “Ona, au i garup nene, inbe aye tamoto sa ampa pitiap. E so i nga ole pombe pang yau balai?” ");
INSERT INTO apr_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Ngan bangabangana iraua betanga ki nen, “Maro Amunu Silene ole isi yong, inbe Maro yo inepe ete i, in gurana ki ole si idukong. Le kase tani yo Maro ipootoo panga ye taunu a kapom ye i, in ole di tooltool tiweta bet ye in Maro Natunu. ");
INSERT INTO apr_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Inbe kumata, tinam oom Ilisapet yo iyei kolman, inbe tiwete bet tau pasuiungu ki i, in dookoot nga kapono a inepe ye taudu limi be atu oo. ");
INSERT INTO apr_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Ngan nen, yesoo so sa yo bet Maro isak ye a bet iyei tiap, ngan tiap.” ");
INSERT INTO apr_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Motong la Madia tani in iyei ne, “Au i ben kapraingi ke Tool Mai. Le so yo kuwete pau ye, in bet iyeii a pombe pang yau, ngan dook mata.” Motong la bangabangana ke Maro igege sila inepe, inbe imulu a ilo. ");
INSERT INTO apr_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Ye kene tani in Madia ikarata so ki tina ngan le imadit a ipa tarrai a ilo pang ye malala mai atu yo iken ye kawal ke tana mai Yudia i. ");
INSERT INTO apr_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Ngan ipa le lo pombe, motong la ilo rumu lono ke Sakaria lo ikamata Ilisapet, ngan le iwete lo ponana ki panga. ");
INSERT INTO apr_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Ye kene yo Ilisapet ilongo lo ponana ke Madia yo iweta panga i nga, ngan le natunu yo iken kapono lono i, in ipulles, inbe Maro Amunu Silene isi ipapono Ilisapet tani. ");
INSERT INTO apr_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Ngan nen le koonoo le mai nen, “Maro iyei urata dook mata pong le kullos di diem garup kapala nga le imot. Inbe iyei urata dook mata pang kase yo bet kupasuiu i, in lapau.” ");
INSERT INTO apr_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Motong la Ilisapet tani in iwete mulu nen, “Ngan dook mata, bong au i tool dook mata balai a le Tool Mai kiau tinana i bet ise pang yau nga? ");
INSERT INTO apr_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Kulongo, kene yo kuwete lo ponana kiong pau a alongo ye in nga, ngan le kase maitiap tani yo iken kapok lono i, in lon ponana lapau le ipulles. ");
INSERT INTO apr_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Ong i, Maro iyei urata dook mata pong, yesoo betanga yo Tool Mai iwete pong nga, ngan kutara lom medana ye bet ole kanono pombe pang yong moolmool.” ");
INSERT INTO apr_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Motong la Madia iyei ne, “Au i agaua lok le imot bet ayitmaka Tool Mai ene. ");
INSERT INTO apr_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Inbe lok mai i le imot lon ponana mai san pang Maro yo ipamulau ye so dook tiap tani yo bet igarungau i. ");
INSERT INTO apr_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Au i garup sorok ben kapraingi ki leu, bong ye in lon tutau mai san. Le pang dama ni nga, ngan ole di tooltool le imot tikamatau, ngan ole tiwete bet Maro la iyei urata dook mata pau i. ");
INSERT INTO apr_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Ngan ye in gurana ki mai san, le iyeie so maiyoko dook mata pau bet ilonau ye. Inbe Maro yetaleu in inepe le taukan busunu, le ayitmaka ene. ");
INSERT INTO apr_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Ye in tool ke bet ilele lono ye di tooltool le imot yo titattadaii a tiraua panga nga, ngan la ilon di tooltool yo dookoot tinepe nga, inbe ole ilon di tooltool kapala yo bet pang dama ni ngan pombe nga. ");
INSERT INTO apr_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Ngan ye taunu in iyei urata maimai nga ye bene. Le di tooltool yo lodi tar di bet di tapdi nga edi maimai nga, ngan igiri di a tikoo. ");
INSERT INTO apr_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Inbe irautoo di tooltool maimai yo tiyei kuto maimai nga, inbe iyitmak di tooltool yo taukadi edi nga. ");
INSERT INTO apr_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Inbe ikap so dook mata alunu pang di tooltool yo tikana pitolo nga, bong di tooltool yo ballingadi nga, ngan inganga di le tipa bedi koonoo a tila. ");
INSERT INTO apr_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Inbe ye in ilon di kapraingi ki yo idi tooltool ke Isrel nga, ngan dook mata, yesoo lon tutu betanga yo mugu ngan ipamede pang sasa kiidi i, bet ole lon mulumulu ye Awaram iye di sasa ki a ilon di nen le ikenen leu le taukan motingi.” ");
INSERT INTO apr_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Madia tani in iye Ilisapet tinepe ye so ben taudu tol, motong la imulu a idu pang malala ki nga. ");
INSERT INTO apr_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Lal ke Ilisapet bet ipasui in pombe, ngan le ipasuiu natunu tamoto. ");
INSERT INTO apr_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Le nga di rara ke Ilisapet tipa ye di tooltool yo iye di tigaua malala nga, ngan tilongo tina yo Tool Mai lono panga a iloni dook mata le ipasuiu natunu nga, le nga tiye Ilisapet tani in lodi ponana. ");
INSERT INTO apr_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Tinepe a ke limi be ru iman a ila, le ye ke limi be tol ki, motong la titoo momo kidi a timan bet man tikoro kase tani in tinini, inbe lodi bet tisu ene ye tamana tani yo Sakaria i. ");
INSERT INTO apr_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Bong ngan tinana Ilisapet iwete pang di nen, “Tiap! Tasu ene ye Yowan.” ");
INSERT INTO apr_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Motong la di tooltool tina tiwete panga nen, “Ai, kataunu ye di rara kiang nga sa ene nen tiap.” ");
INSERT INTO apr_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Motong la tiyei tomonai ye bedi a bet titoro tamana, ye in lono bet ole isua ye sei. ");
INSERT INTO apr_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Ngan tamana tani iyei tomonai pang di ye bene bet tikaua so ke wodwodenge atu panga a bet iwodo ene. Ngan le iwodo betanga nen, “Kase i ene la Yowan i.” Ngan nen le di tooltool le imot yo tigaua nga, ngan tikamata le titakrai. ");
INSERT INTO apr_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Motong la pattu leu inbe Sakaria tani koonoo imarra, inbe mene mooloo mulu a iwetewete, inbe iyitmaka Maro ene. ");
INSERT INTO apr_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Ngan nen le di tooltool tina yo tiye di tigaua malala nga, ngan tikamata mos tani yo pombe i, le titakrai ye mai san. Motong la so tina yo pombe nga, ngan di tooltool tipa bet tiwete le bingi ki ila ye malala nga le imot yo iken ye kawal ke tana mai Yudia nga. ");
INSERT INTO apr_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Le nga di tooltool le imot yo tilongo bingi tani nga, ngan lodi kaua urata ye, inbe tipartortor ye. Tiyei ne, “Ai, kase ni pang dama ni ngan ole iyei tool balai na?” Ngan tipartortor nen, yesoo tikamata ben gurana ke Tool Mai iken ye. ");
INSERT INTO apr_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Motong la Maro Amunu Silene idiwidiwi Yowan tamana yo Sakaria i, le nga ikaua Maro koonoo inbe iwete nen, ");
INSERT INTO apr_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Idi le imot bet tayitmaka Tool Mai yo Maro kiidi Isrel, in ene! Yesoo, ye in isi bet si ilonidi tooltool ki a nen ngan ipamulidi ye so dook tiap tani yo bet igarungidi i. ");
INSERT INTO apr_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Ngan tool yo Maro ikaua gurana mai panga bet si ipamulidi ye so dook tiap tani yo bet igarungidi i, in ipa ye rara ke kapraingi ki tani yo Dawiti i. ");
INSERT INTO apr_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Ngan mukot yege ni nga, ngan di Maro koonoo yo ipootoo di panga ye taunu nga, ngan tiwete nen, ");
INSERT INTO apr_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","ole ilonidi a ipamulidi ye di koi kiidi bedi, inbe ye di tooltool yo lodi dook tiap paidi nga. ");
INSERT INTO apr_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Inbe lon tutu betanga medana ki yo mugu ngan ipamede pang di sasa kiidi i, le ole lon mulumulu yidi a ilonidi. ");
INSERT INTO apr_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Moolmool, ye taunu iwete moolmool le ete bet ipamede betanga medana tani in pang sasa kiidi yo Awaram i. ");
INSERT INTO apr_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Ngan nanga, ole ikau idi ye di koi kiidi bedi a ipamulidi, inbe ole ipamedidi a bet nen ngan tapas le tayei urata ki leu, le ke bet tatattadai mulu tiap. ");
INSERT INTO apr_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Inbe dookoot tanepe nga, ngan ole tatoo dada dook mata yo Maro lono bet tatoo nga, inbe tatoo dada dook mata noonoonoo yo ki nga. ");
INSERT INTO apr_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","“Ngan ong natuk i, pang dama ni, ngan ole di tooltool tikiu ong ye Maro koonoo atu ke Maro yo inepe ete i. Inbe ole kumugu a kukarata dada pang Tool Mai. ");
INSERT INTO apr_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Inbe ole kupagalanga di tooltool lodi a bet nen ngan lodi galanga ye dada yo Maro bet igiri sennene kidi ye, inbe ye dada yo bet ipamulu di ye so dook tiap tani yo bet igarung di i. ");
INSERT INTO apr_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Le Maro ole iyei nen, yesoo ye in lono paidi mai san a ilele lono yidi. Ngan la tool atu yo iwanga ke malala ki a isi pang yidi i, in ole dawa ben ke se ipiti matana nga. ");
INSERT INTO apr_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","A nen ngan lulngana ilangarai di tooltool yo tinepe ni todo lono a gurana ke matenge iparama di nga, inbe ipassongidi le tapa ye dada yo bet tanepe ye lo silene ke Maro i.” ");
INSERT INTO apr_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Tinepe le lo Yowan tani in maiyoko, inbe Maro Amunu Silene ipamede lono le gurana ki mai san. Motong la ila ye ni soorookoonoo atu yo taukan tooltool i, a la inepe nango le ilo ye lal ki yo bet ye taunu ipaposi ye urata ki pang di Isrel i. ");
INSERT INTO apr_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Ye kene tani in, ngan Sisa Agustus itara betanga medana atu pang di tooltool nga le imot yo tinepe ye tana mai Rom nga, bet di le imot ole tiwodo edi ilo ye rau ke kaungu di tooltool edi. ");
INSERT INTO apr_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Ngan dada ke kaungu di tooltool edi i, in pombe kulkulunu ye kene yo Kurinius iyei tool kuto mai bet matan kala tana mai Siria ye i. ");
INSERT INTO apr_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Le nga di tooltool le imot yo tinepe ye malala kidi diedi nga, ngan timulumulu pang ye malala kidi tapdi, a bet la titar edi. ");
INSERT INTO apr_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Ngan Yosep tani in ipa ye rara ke Dawiti. Le nga imadit ye malala Nasaret ke tana mai Galili a ilo pang Yudia ye malala mai ke Dawiti, yo ene Betlem i. ");
INSERT INTO apr_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Ngan Yosep tani in ikaua Madia, yo titarkala panga bet iyooloo, in a yeru tilo bet lo titar edi ilo ye rau lapau. Bong ye kene tani, in Madia kapono maiyoko ke pasuiungu oo. ");
INSERT INTO apr_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Le nga yeru tinepe Betlem go, inbe lal yo bet Madia ipasuiu natunu ye i, in pombe, ");
INSERT INTO apr_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","ngan le ipasuiu natunu tamoto mumuganga. Motong la iduku ye mala, inbe ipatakeno du ye koror yo titar kaningi kidi asara ilo ye i, in lono, yesoo rumu yo ke di lowo nga, ngan ipon le imot. ");
INSERT INTO apr_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Ye ni tani in di tooltool pattu tinepe ke diki ke malala mai tani, a nen ngan bet bong ngan matadi kala di asara kidi yo edi sipsip nga. ");
INSERT INTO apr_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Motong la bangabangana ke Tool Mai atu in idu pombe pang ye di, inbe Tool Mai lulngana ilangarai di le titattadai mai san. ");
INSERT INTO apr_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Bong ngan bangabangana tani in iwete pang di nen, “Oi, ken katattadai be! Kapalongo, au i akaua bingi dook mata pang la asi nga. Bingi dook mata tani in ole iyei di tooltool nga le imot le lodi ponana belebele. ");
INSERT INTO apr_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Dookoot bong katai i, garup atu ipasuiu natunu malala mai ke Dawiti. Ngan kase tani in Tool Mai Kirisi yo mugu ngan Maro itara betanga medana ye bet ole ikau ang le imot a ipamulang ye so dook tiap tani yo bet igarungang i. ");
INSERT INTO apr_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Inbe tarkilanga ki yo bet lomu galanga ye, in nen. Ole kakamata kase atu yo tiduku ye mala, inbe tipatakeno du iken koror lono yo titar kaningi kidi asara ilo ye i.” ");
INSERT INTO apr_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Bangabangana ke Maro tani in iwete nen a imot, ngan le pattu leu inbe di bangabangana ke Maro liliti mai tipa ke malala ke Maro a tisi ye bangabangana tani a tikodo, inbe tiyitmaka Maro ene. Tiyei ne, ");
INSERT INTO apr_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Tayitmaka Tool Mai Maro yo inepe ete i, in ene. Inbe di tooltool ke tana yo Maro lono pang di mai san nga, ngan ole ikaua lo silene ki pang di a tinepe ye.” ");
INSERT INTO apr_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Motong la di bangabangana ke Maro tina ngan tigege di sila tinepe, inbe timulu a tilo pang ye malala ke Maro. Le taun di tooltool yo matadi kala di asara nga, ngan timadit le tiyei ne, “Oo, nga ole talo pang Betlem a lo takamata so tani yo pombe ni a Tool Mai iweta paidi i.” ");
INSERT INTO apr_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Le nga tipa tarrai a tilo, ngan le lo tikamata Madia iye Yosep inbe kase maitiap tani yo tipatakeno du ikenen koror lono i. ");
INSERT INTO apr_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Tikamata kase tani a imot, motong la tiwete tomonai betanga tina yo bangabangana ke Maro in iwete pang di ye kase maitiap tani nga. ");
INSERT INTO apr_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Ngan nen le di tooltool le imot yo tilongo betanga kidi tooltool yo matadi kala di asara nga, ngan titakrai ye. ");
INSERT INTO apr_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Bong Madia in itar betanga tina ngan le imot lo lono, inbe lon kaua urata ye. ");
INSERT INTO apr_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Motong di tooltool yo matadi kala di asara ngan timulu pang ye urata kidi mulu, inbe tiyitmaka Maro ene le ilo ete. Yesoo, lodi ponana ye so le imot yo tilongo inbe tikamata nga, ngan le kanono moolmool ben tina yo bangabangana ke Maro iwete pang di ye nga. ");
INSERT INTO apr_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Ngan ke limi be ru iman a ila, le ye ke limi be tol ki, motong la titoo momo kidi Yuda a bet tikoro kase maitiap tani in tinini, inbe tisu ene ye Yesu nga. Ngan ene tani in bangabangana ke Maro iweta mugu pang Madia, motong la kapono ye nga. ");
INSERT INTO apr_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Motong la tinepe le ilo ye lal ke bet Yosep iye Madia titoo betanga yo iken ye wer ke Maro yo ikap pang Mose nga, a bet tikarata di le tinidi igalanga ye Maro matana. Le nga yeru tikaua natudi tani a tilo pang Yerusalem, bet lo titara kase tani lo Tool Mai bene, ");
INSERT INTO apr_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","ben tina Wer ke Tool Mai iwete nga. Ngan iwete nen, “Di kakase tamoto mumuganga le imot yo tinadi tipasui di nga, ngan bet tikap di pang Tool Mai.” ");
INSERT INTO apr_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Le nga yeru tilo lo titoo Wer ke Tool Mai yo iweta a tiwode lo ye rau bet tiparoro “man utu ru, too man utu kase ru” panga i. ");
INSERT INTO apr_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Ye kene tani in tool atu yo inepe Yerusalem, in ene la Simion i. Ngan ye in tool noonoonoo, inbe igaua lono le atu pang Maro. Inbe Maro Amunu Silene ipamede bet inepe a inam le lo ikamata tool yo Maro ipootoo bet ole iyei di tooltool ke Isrel le lodi iken dook mata i. ");
INSERT INTO apr_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Inbe mugu ngan Maro Amunu Silene iwete panga nen, bet ole inepe nen le ikamata Tool Mai Kirisi yo Maro ipamede betanga medana ye i, ngan la bet imata nga. ");
INSERT INTO apr_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Nen le Simion tani in Maro Amunu idiwidiwoo bet imadit a ilo pang koongoo lono ke bareme mai ke sungunu. Motong la Yosep iye Madia tikaua natudi Yesu a tilo bareme mai ke sungunu lono, in lapau, a bet tiyei urata le titoo betanga tina yo Wer ke Maro iwete bet tiyei nga. ");
INSERT INTO apr_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Ngan nen le Simion tani in ikaua kase tani le isipoo ye bene, inbe itada pang ete bet iwete lo ponana ki pang Maro ye. Iyei ne, ");
INSERT INTO apr_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Oo Tool Mai, au i akamata so kanono moolmool ye matak, ben tina yo kutara betanga medana ye pau nga, le bet nen ngan kumalum pau, au kapraingi kiong, a amata dookoot nga, ngan lok ponana. ");
INSERT INTO apr_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Yesoo, dookoot nga akamata tool yo bet ipamulam ye so dook tiap tani yo bet igarungam i, in ye matak oo. ");
INSERT INTO apr_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Ngan tool tani yo kupootoo bet iyei urata tani i, in pombe mallangana ye di tooltool nga le imot matadi. ");
INSERT INTO apr_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Ye in ben sul loloana, le ole lulngana ilangarai di tooltool yo tipa ye rara kidi Yuda tiap nga a bet tikamata ni ye, inbe ole di tooltool tipayit di tooltool kiong ke Isrel edi ye.” ");
INSERT INTO apr_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Ngan nen le Yesu tamana le tinana tilongo betanga ke Simion tina yo iwete nga, le yeru lodi belebele leu ye. ");
INSERT INTO apr_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Motong la Simion ipamede di ye betanga dook mata, inbe iwete pang Yesu tinana Madia nen, “Kase i, Maro ye taunu la itaru i, a bet nen ngan iyei di tooltool ke Isrel, le alunu la bet tiwala muridi pang Maro a irautoo di, inbe alunu la bet titara lodi medana pang Maro a iyitmak di nga. Maro itaru bet iyei tarkilanga panga, bong di tooltool alunu ole tiyei ben koi ki. ");
INSERT INTO apr_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Ngan la ole so tina iken sollono ye di tooltool lodi nga, ngan ole ise le iken mallangana. Inbe ong taum in ole lom massingi ye dawa ben pul matana la bet isopala lom i.” ");
INSERT INTO apr_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","37","Garup atu yo itoko urata ben Maro koonoo i, in ene la Ana i. Ye in Panuel natunu garup, inbe ye in ipa ye rara ke Aser. Mugu ngan ikere le iye nintooroo tinepe ye rai limi be ru. Motong nintooroo imata a iyei tap a inepe sorok le se rai ki 84 a iyei konga ki taunu. Ngan Ana tani in igege bareme mai ke sungunu pitiap yege, bong ye ke le bong, ngan inepe bareme mai ke sungunu lono bet ipatarau a isung pang Maro. Inbe ye lal kapala ngan ole isapa ye kaningi so, inbe ipas le ipatarau leu. ");
INSERT INTO apr_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Ngan ye kene yo Yosep iye Madia tikaua Yesu a tilo bareme mai ke sungunu lono nga, ngan ye lapau inepe. Le iman ikodo potai ye di, inbe iwete lo ponana ki pang Maro. Inbe igasa kase tani in pang di tooltool le imot yo titar matadi a tinama Maro bet ipamulu di tooltool ke Yerusalem nga. ");
INSERT INTO apr_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Yosep iye Madia tiyei so le imot yo Wer ke Tool Mai iwete bet tiyei, ngan a imot, motong la timulu a tidu pang tana mai Galili, pang ye malala mai kidi tapdi yo Nasaret i. ");
INSERT INTO apr_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Motong la kase tani in kene idik mulu le gurana ki mai. Inbe Maro ipaponi ye lo galanga le lon galanga dook mata san, inbe Maro lono panga le iyeii dook mata lapau. ");
INSERT INTO apr_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Ye rai kanakana nga, ngan Yesu di tamana le tinana tilo pang Yerusalem ye gaongo mai kidi Yuda yo tiwete ene ye Paskimoolooningi ke Maro i. ");
INSERT INTO apr_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Le nga tinepe a Yesu rai ki sangaul be balana ru, motong la di tamana le tinana titoo momo ke lal maiyoko kidi Yuda tani le tikaua Yesu lapau a tiye tilo pang Yerusalem. ");
INSERT INTO apr_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Ngan tilo tinepe ye lal ke Paskimoolooningi tani in a imot, motong la Yesu di tamana le tinana bet timulu pang malala kidi. Ngan kase mai tiap tani yo Yesu i, in sila inepe nango la Yerusalem ngo, bong tamana le tinana lodi galanga ye yo sila inepe, ngan tiap. ");
INSERT INTO apr_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Yeru tiyeisa o iye di diedi kapala ngan tipa. Le nga yeru tipa ye ke atu a tidu. Motong la yeru tisere, a titortor di rara kidi le di tooltool kidi kapala ye nga. ");
INSERT INTO apr_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Bong yeru mala bet tipusye tiap, motong la timulu pang Yerusalem bet lo matadi saraii. ");
INSERT INTO apr_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Ngan yeru tikaua urata mai san ye serenge le lo ke tol ki, motong la tipusye Yesu tani yo inepe bareme mai ke sungunu lono nga. Ye in iye di pannoongoo tiwur a ilongo betanga kidi, inbe itor panin di ye betanga kapala. ");
INSERT INTO apr_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Ngan di tooltool yo tilongo Yesu tani in irau betanga kidi kuto maimai tina ngan dook mata nga, le nga titakrai ye lo galanga ki. ");
INSERT INTO apr_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Inbe di tamana le tinana tina ngan tikamata le titakrai belebele ye lapau. Motong la tinana iwete panga nen, “Alei natuk, nga gelei bet kuyei dada nen pam nga? Au i aye tamam nga lomam madoko yong, le amkaua urata mai san ye serengong.” ");
INSERT INTO apr_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Motong la Yesu itor di nen, “Nga gelei bet angru kaserau nga? Angru nga lomu galanga yau nen o ke bet anepe ye ni san mulu tiap, bong bet anepe ye rumu ke Tamak leu.” ");
INSERT INTO apr_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Bong yeru lodi galanga ye betanga yo iweta i, in lono ki tiap. ");
INSERT INTO apr_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Motong la Yesu iye di timulu a tidu pang Nasaret du tinepe, inbe ipas le itoo betanga ke di tamana le tinana leu. Bong tinana in itar so tina ngan le imot lo lono, inbe lon kaua urata ye. ");
INSERT INTO apr_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Ngan Yesu kene idik mulu le iyei tool maiyoko, inbe lo galanga ki ise le mai. Inbe Maro lono dook mata panga, inbe di tooltool le imot lodi dook mata panga lapau. ");
INSERT INTO apr_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Ye kene yo Sisa Taibirias inepe ben tool kuto mai a matan kala tana maimai ke Rom le imot ye in nga, ngan itar di tooltool kapala bet tiloni a matadi kala tana kapala. Le ye rai sangaul be limi tina yo itoko urata ki tani nga, ngan Pontius Pailot iyei tool kuto mai pang tana mai Yudia, inbe Erot in iyei tool kuto mai pang tana mai Galili, inbe toonoo Pilip in iyei tool kuto mai pang tana mai Ituria inbe Tarakonitis, inbe Lisanias in iyei tool kuto mai pang tana mai Abilene. ");
INSERT INTO apr_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Inbe ye kene tani in Anas iye Kepas titoko urata ben tooltool kuto maimai ke paroranga so pang Maro. Ngan ye kene tani in Yowan yo Sakaria natunu i, in inepe ye ni soorookoonoo, inbe Maro ikap betanga ki panga. ");
INSERT INTO apr_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Motong la Yowan ipa a ila ye malala le imot yo iken potai pang ye ran Yodan nga, inbe iwetewete betanga ke Maro pang di. Iyei ne, “Kaportak lomu a kaman arriu ang, ngan la bet Maro igiri sennene kiang nga.” ");
INSERT INTO apr_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Ngan iyei nen le dawa ben betanga ke Maro yo mukot ngan Maro koonoo yo Esai in iwode i. In iwete nen, “Ole kalongo tool atu kalngana ye ni soorookoonoo, in iwete le koonoo maimai nen, ‘Kakarata dada pang Tool Mai, inbe kayeii le dundunngana panga bet ipa ye. ");
INSERT INTO apr_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Kapoopoo ni yo moolai nga le imot, inbe kakel kawal le ni yo ipolkatkat nga le si puspusngana. Inbe dada kapala yo ikalel nga, ngan kapadun mulu le dundunngana. Inbe dada kapala yo bussukana nga, ngan kasamomo le puspusngana. ");
INSERT INTO apr_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Ngan la bet di tooltool le imot tikamata urata ke tool tani yo Maro iwanga bet si ipamulu di ye so dook tiap tani yo bet igarung di in nga.’” ");
INSERT INTO apr_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Motong la di tooltool alunu kaiye tila pang ye Yowan bet la irriu di. Bong iwete pang di tooltool yo tiportak lodi moolmool tiap nga, ngan nen, “Ai, ang ngan ben moto dook tiap di natunu! Sei iwete bet kayei nen ngan ole kasuru kate malmal ke Maro yo bet pang dama ni ngan pombe i? ");
INSERT INTO apr_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Kumata le bet kaportak lomu moolmool nga, ngan ole tikamatang ye dada kiang yo kayei nga ben ang nga kaportak lomu moolmool. Inbe ken kawete bet ang ngan tamamu la Awaram i, a bet nen ngan Maro igarungang tiap, ngan be. Awete pang nen, Maro ke bet iportak di pat nga le tiyei ben Awaram di natunu. ");
INSERT INTO apr_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Ngan matau nain la iken kai punu in. Ngan la kai le imot yo tipu ngan titar kanodi dook mata tiap nga, ngan ole Maro itarakat di a ikatte di lo ei lono.” ");
INSERT INTO apr_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Ngan di tooltool budanga mai tina tilongo betanga ke Yowan, le nga titoru nen, “Ona, nga ole amyei balai?” ");
INSERT INTO apr_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Motong la Yowan iraua betanga kidi nen, “Tool bet sousoungu ki ru nga, ngan ikaua atu pang tool san yo taukan sousoungu i. Inbe tool bet so ki ke kaningi nga, ngan itoo dada gaongo leu nen lapau ye tool yo taukan so ke kaningi i.” ");
INSERT INTO apr_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Ye kene tani in di tooltool ke sodaningi pat ngan timan pang ye Yowan bet man irriu di lapau. Le nga titoru nen, “Pannoongoo, am nga ole amyei balai?” ");
INSERT INTO apr_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Motong la iwete pang di nen, “Le bet kakap pat ye di tooltool nga, ngan kakap le lo ige kinkatingi yo tool kuto mai kiang itaru i, in leu. Ken kallung di a kalloso kinkatingi tani, in be.” ");
INSERT INTO apr_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Motong la di tooltool ke patokongo pattu titoro Yowan kanana. Tiyei ne, “Ngan am nga, ole amyei balai?” Ngan Yowan iwete pang di nen, “Ken kapatangarur di tooltool lodi a bet titattadai ngan tikap pat pang be, inbe ken kakap sorok di tooltool lo tikodo ye ni ke karatanga betanga be. Bong pat yo bet kakap ye urata kootoonoo kiang, ngan leu la bet lomu ponana ye nga.” ");
INSERT INTO apr_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Ngan di tooltool tina ngan titar matadi a tinama Kirisi yo bet isi i, ngan tikamata Yowan le lodi tar bet ye in o Kirisi tani naii. ");
INSERT INTO apr_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Bong Yowan iwete pang di nen, “Au i arriu ang ye ran leu, bong tool yo bet ipa mur yau a isi i, in ole irriu ang ye Maro Amunu Silene ipa ye ei. Ngan tool tani in gurana ki mai san, le illosau. Ngan nen le akamatau ben au i tool dook mata ke bet aloni ben poranga ki a aruku ooroo ke loningi ke kene tiap. ");
INSERT INTO apr_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Ngan ye in ipa ye urata ke pitiningi la isi nga. Ole itoko yoo ye bene, inbe itaurai dingding patunu ke kaningi, le igaun kanono ilo ye badabada ki, inbe kulini ngan idaun di ye ei yo ikan nen le taukan motingi i.” ");
INSERT INTO apr_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Yowan ikatte betanga alunu pang di ye bingi dook mata tani yo ikauu pang di i, a nen ngan bet tilongo ngan tiportak lodi. ");
INSERT INTO apr_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Ngan Yowan tani in ipasak pang tool kuto mai yo Erot i, in ye yo isada Erodias yo toonoo rimana in a iyooloo nga, inbe ye urata dook tiap kapala yo iyei nga lapau. ");
INSERT INTO apr_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Motong la Erot tani in iyeie dada dook tiap san mulu ye yo iwete a titara Yowan lo rumu dook tiap kidi talnga dikidiki lono nga. ");
INSERT INTO apr_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Ye kene yo Yowan irriu di tooltool ye in nga, ngan Yesu lapau iman pang ye bet man irriuu. Le nga irriuu a imot, motong la Yesu ipatarau tina ngan le malala ke Maro koon panganga. ");
INSERT INTO apr_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Inbe Maro Amunu Silene iro ke malala ki a isi pang ye ben man utu. Inbe tool atu kalngana iwetewete ye malala ke Maro a isi nen. Iyei ne, “Ong in au Natuk. Au i lok pong mai san, inbe lok ponana yong.” ");
INSERT INTO apr_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Kene yo Yesu ipamaditi urata ki ye in nga, ngan rai ki so ben sangaul tol. Ngan le di tooltool lodi taru bet ye in Yosep natunu, inbe Yosep in Eli natunu, ");
INSERT INTO apr_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","inbe Eli in Matat natunu, inbe Matat in Liwi natunu, inbe Liwi in Melki natunu, inbe Melki in Yanai natunu, inbe Yanai in Yosep natunu, ");
INSERT INTO apr_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","inbe Yosep in Matatias natunu, inbe Matatias in Amos natunu, inbe Amos in Naum natunu, inbe Naum in Esli natunu, inbe Esli in Nagai natunu, ");
INSERT INTO apr_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","inbe Nagai in Mat natunu, inbe Mat in Matatias natunu, inbe Matatias in Semen natunu, inbe Semen in Yosek natunu, inbe Yosek in Yoda natunu, ");
INSERT INTO apr_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","inbe Yoda in Yoanan natunu, inbe Yoanan in Resa natunu, inbe Resa in Serubabel natunu, inbe Serubabel in Sealtiel natunu, inbe Sealtiel in Neri natunu, ");
INSERT INTO apr_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","inbe Neri in Melki natunu, inbe Melki in Adi natunu, inbe Adi in Kosam natunu, inbe Kosam in Elmadam natunu, inbe Elmadam in Er natunu, ");
INSERT INTO apr_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","inbe Er in Yesua natunu, inbe Yesua in Eliesa natunu, inbe Eliesa in Yorim natunu, inbe Yorim in Matat natunu, inbe Matat in Liwi natunu, ");
INSERT INTO apr_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","inbe Liwi in Simion natunu, inbe Simion in Yuda natunu, inbe Yuda in Yosep natunu, inbe Yosep in Yonam natunu, inbe Yonam in Eliakim natunu, ");
INSERT INTO apr_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","inbe Eliakim in Mela natunu, inbe Mela in Mena natunu, inbe Mena in Matata natunu, inbe Matata in Natan natunu, inbe Natan in Dawiti natunu, ");
INSERT INTO apr_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","inbe Dawiti in Yesi natunu, inbe Yesi in Obet natunu, inbe Obet in Boas natunu, inbe Boas in Salmon natunu, inbe Salmon in Nason natunu, ");
INSERT INTO apr_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","inbe Nason in Aminadap natunu, inbe Aminadap in Atmin natunu, inbe Atmin in Ani natunu, inbe Ani in Esron natunu, inbe Esron in Peres natunu, inbe Peres in Yuda natunu, ");
INSERT INTO apr_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","inbe Yuda in Yakop natunu, inbe Yakop in Esaka natunu, inbe Esaka in Awaram natunu, inbe Awaram in Tera natunu, inbe Tera in Naor natunu, ");
INSERT INTO apr_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","inbe Naor in Seruk natunu, inbe Seruk in Reu natunu, inbe Reu in Pilek natunu, inbe Pilek in Eber natunu, inbe Eber in Sela natunu, ");
INSERT INTO apr_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","inbe Sela in Kainan natunu, inbe Kainan in Apaksat natunu, inbe Apaksat in Sem natunu, inbe Sem in Noa natunu, inbe Noa in Lamek natunu, ");
INSERT INTO apr_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","inbe Lamek in Metusela natunu, inbe Metusela in Inok natunu, inbe Inok in Yaret natunu, inbe Yaret in Malalel natunu, inbe Malalel in Kenan natunu, ");
INSERT INTO apr_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","inbe Kenan in Inos natunu, inbe Inos in Set natunu, inbe Set in Atam natunu, inbe Atam in Maro natunu. ");
INSERT INTO apr_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Maro Amunu Silene ipapono Yesu, motong la igege ran Yodan, inbe imulu a ila. Ngan Maro Amunu Silene ipasongosonga bet ipa pang ye ni soorookoonoo atu. ");
INSERT INTO apr_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Ngan Yesu yetaleu ila inepe ye ni soorookoonoo tani ye ke sangaul pai, inbe tool kuto mai kidi so sidi iman a man itoua. Ngan ye ke tina yo Yesu inepe ye nga, ngan ikan toko so pitiap le nga pitolo belebele. ");
INSERT INTO apr_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Motong la tool kuto mai kidi so sidi iwete panga nen, “Ai, bet ong i Maro natunu moolmool nga, ngan kuwete a pat i iportak le iyei porong a koni.” ");
INSERT INTO apr_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Bong Yesu iraua betanga ki nen, “Rau ke Maro iwete nen, ‘Porong leu la bet itoko di tooltool ye nepongo kidi, in tiap.’ ” ");
INSERT INTO apr_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Motong la tool kuto mai kidi so sidi tani in ikaua Yesu a yeru tilo kawal kutono lo ipitnai so matana matana ke tana i le imot nga, ngan panga. ");
INSERT INTO apr_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Motong la iwete pang Yesu nen, “Au i ole akaua gurana mai pong bet kuyei tool ene mai a matam kala so matana matana tina ke tana i le imot. So tina nga le imot, nga so kiau. Le sei tool lok bet akap panga nga, ngan ole akap panga. ");
INSERT INTO apr_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Ngan kumata bet kusung pau nga, ngan ole akap so tina nga le imot pong.” ");
INSERT INTO apr_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Bong ngan Yesu iraua betanga ki nen, “Rau ke Maro iwete nen, ‘Kusung pang Maro yo Tool Mai kiong i, inbe kuraua panga yetaleu.’ ” ");
INSERT INTO apr_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Motong la tool kuto mai kidi so sidi tani in ikaua Yesu a yeru tilo pang Yerusalem, a lo ipatokode le ikodo bareme mai ke sungunu pono meneng ete ni, inbe iwete panga nen, “Bet ong i Maro natunu moolmool nga, ngan kupas ni le kudu tana ni, ");
INSERT INTO apr_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","yesoo Rau ke Maro iwete nen, ‘Ole iwanga di bangabangana ki si matadi kalong dook mata. ");
INSERT INTO apr_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Ole tisipong ye bedi, a bet nen ngan pat isolo kem katene be.’ ” ");
INSERT INTO apr_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Motong la Yesu iraua betanga ki nen, “Rau ke Maro iwete nen, ‘Ken kuyei dada dook tiap yo bet kutouo Maro yo Tool Mai kiong, in be.’ ” ");
INSERT INTO apr_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Tool kuto mai kidi so sidi itouo Yesu ye dada matana matana, ngan tiap. Motong la ikoo ye Yesu, inbe inam ye kene san mulu. ");
INSERT INTO apr_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Motong Maro Amunu Silene ipamede Yesu le gurana, inbe imulu a ila pang tana mai Galili. Ngan bingi ke Yesu tani in ipa le ingaua tana mai Galili le imot a di tooltool le imot tilonga. ");
INSERT INTO apr_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Inbe kanakana ngan ole ilo rumu kidi Yuda ke gaongo in lono, lo ipatomonai di tooltool. Ngan le di tooltool tina ngan le imot tiyitmaka ene. ");
INSERT INTO apr_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Motong Yesu ipa mulu a ila pang ye malala mai Nasaret, ye ni tani yo ye kase ngan inepe le lo ye mai ye i. Le nga ye lal kidi Yuda ke sungunu in pombe, ngan ilo rumu kidi Yuda ke gaongo in lono, ben tina yo iyei kanakana nga. Ilo lo ikodo dama, inbe ikinkata betanga yo iken ye Rau ke Maro in pang di tooltool. ");
INSERT INTO apr_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Motong la tikaua rau ke Maro koonoo yo Esai in panga. Le nga bet iperenaii ngan ipusye betanga yo iken ye rau tani in iwete nen, ");
INSERT INTO apr_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Tool Mai Amunu si inepe yau, yesoo ye taunu ipootau bet akaua bingi dook mata pang di tooltool yo ballingadi tiap nga. Inbe iwangau bet si awete pang di tooltool yo tinepe rumu dook tiap kidi talnga dikidiki lono nga, ngan bet tipas a tisi tana; inbe akarata di tooltool mata kis nga, a bet nen ngan matadi rere mulu; inbe alon di tooltool yo diedi tiyei di dook tiap a tikaua urata moonoo dook tiap pang di nga, a bet nen ngan tisolo urata moonoo dook tiap tani in mulu be. ");
INSERT INTO apr_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Inbe iwangau bet si akaua bingi pang di tooltool nen, bet dookoot nga i lal ke Tool Mai yo bet si iyei urata dook mata pang di tooltool ye i.” ");
INSERT INTO apr_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Motong la Yesu ilulu rau tani mulu, inbe ipamule pang tool yo matan kala rau i, inbe du iwur. Le nga di tooltool tina yo tinepe rumu ke gaongo tani in lono nga, ngan matadi kenen ye. ");
INSERT INTO apr_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Motong la iwete pang di nen, “Betanga ke Maro yo iken ye rau ki a kalonga i, in dookoot katai nga kanono pombe moolmool.” ");
INSERT INTO apr_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Di tooltool tina tilongo betanga dook mata yo iwete nga, le titakrai ye, inbe tiyitmaka ene. Bong ngan di tapdi tipartortor a tiyei ne, “Ai, tool i Yosep natunu, too? E nga gelei bet le iwete betanga nen nga?” ");
INSERT INTO apr_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Ngan nen le Yesu iwete pang di nen, “Ang nga lok galanga yang bet ole kakatte betanga atu pau ye betanga kidi maimai kiang yo mugu ngan tiweta i. Ole kayei ne, ‘Tool ke bar bet nen ngan ong taum kukaratong ngan.’ Ngan ole kawete pau bet ayei mos sa ye malala kiau tauk i a bet kakamata, dawa ben mos yo kalongo ayei pang di tooltool ke Kapenam nga.” ");
INSERT INTO apr_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Motong la Yesu iwete pang di mulu nen, “Awete pang moolmool nen, tool yo Maro koonoo i ke bet di tooltool ke malala ki tilongo betanga ki tiap. ");
INSERT INTO apr_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Kapalongo, mugu ngan ye lal yo ke Ilia i, ngan di garup tap ke Isrel alunu kaiye la tinepe nga. Ngan ye kene tani, in ke kan le ki imol tiap ye rai tol inbe taudu limi be atu, le pitolo mai pombe ye tana maimai nga le imot. ");
INSERT INTO apr_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Bong Maro iwanga Ilia pang ye di garup tap yo tinepe Isrel, ngan siap. Bong iwanga a ilo pang ye garup tap yo inepe Serepat potai pang ye malala mai Saidon i. ");
INSERT INTO apr_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Inbe kene san, ye lal ke Maro koonoo yo Ilisa in nga, ngan di tooltool alunu ke Isrel la botoboto medana in ikan di nga. Bong di tooltool tina yo ke Isrel ngan sa tinini dook mata mulu tiap. Bong Naiman ataleu ke tana mai san Siria in la tinini dook mata mulu i.” ");
INSERT INTO apr_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Yesu iwete nen le di tooltool le imot yo tinepe rumu ke gaongo tani a tilongo betanga ki nga, ngan katedi malmal dook tiap. ");
INSERT INTO apr_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Inbe timadit tina le tinganga Yesu bet ikoo ye malala mai tani a idu diki. Motong la tikauu a tilo ye arono matana yo tikarata malala mai ye i, a bet nen ngan tikauu a tikatte du ke madini ye ni yo dook tiap i. ");
INSERT INTO apr_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Bong Yesu ipa le ipalanai di tooltool budanga mai tina ngan a ila. ");
INSERT INTO apr_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Motong la Yesu idu inepe ye malala mai Kapenam yo iken ye tana mai Galili i. Le nga lal kidi Yuda ke sungunu pombe, ngan Yesu ilo ye rumu kidi Yuda ke gaongo, inbe ipatomonai di tooltool. ");
INSERT INTO apr_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Ngan le di Yuda tina titakrai ye patomonaingi ki, yesoo betanga ki ipa ye gurana ke Maro. ");
INSERT INTO apr_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Inbe ye kene tani, in tool atu inepe ye rumu ke gaongo tani, bong tool tani in so sidi inepe ye. Le so sidi idiwidiwoo le nga koonoo le somai. Iyei ne, ");
INSERT INTO apr_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Atoo! Yesu ke Nasaret, ngan soo so bet kuyeii pam i? Nga kuman bet man kugarungam, too? Au i lok galanga yong oo, ong in Tool Tani Yo Maro Ipootoo Panga Ye Taunu I.” ");
INSERT INTO apr_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Motong la Yesu ipasak pang so sidi tani a iwete katkat panga. Iyei ne, “Ai, kuwetewete dookoot! Kupas ye tool in a kusi tana!” Motong la so sidi ikatte tool tani du tana sila dama kidi tooltool tina, inbe ipas a ikoo, bong igarungu tiap. ");
INSERT INTO apr_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Ngan nen le di tooltool tina tikamata le nga titakrai, inbe tiwete pang di diedi nen, “Ona tiap! I soo patomonaingi nen i na? Patomonaingi ki ipa ye gurana mai san, le ipas le iwete leu, inbe di so sidi tilongo betanga ki a tikoo!” ");
INSERT INTO apr_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Le nga bingi ke so tina yo Yesu iyei nga, ngan ipa a ingaua tana mai i le imot. ");
INSERT INTO apr_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Yesu imadit a igege rumu kidi Yuda ke gaongo tani, inbe ipa a ilo pang ye rumu ke Simon. Ngan Simon roonoo garup in matamatenge ikauu le tinin ges mai san. Le nga titoro Yesu bet iloni. ");
INSERT INTO apr_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Motong Yesu la ikodo le iture pang ye, inbe ipasak pang matamatenge bet ikoo ye garup tani, ngan le matamatenge tani in ikoo ye. Motong la palbe leu be garup tani imadit a ikarata kaningi pang di bet tikan. ");
INSERT INTO apr_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Tinepe a pang rrai, ngan di tooltool yo matamatenge mai ikap di nga, ngan di sogadi tiyau di a tilo pang ye Yesu. Motong la Yesu ipaloko bene lo di tooltool tina ngan di atu atu podi, le matamatenge kidi imot inbe tinidi dook mata mulu. ");
INSERT INTO apr_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Inbe di so sidi tina yo inganga di ye di tooltool nga, ngan tipas a tikoo ye di, inbe koodi le mai nen, “Ong in Maro natunu!” Ngan tiwete nen, yesoo di ngan lodi galanga ye bet ye in Kirisi. Bong ngan Yesu ipasak pang di, inbe ilele di bet tiwetewete be. ");
INSERT INTO apr_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Muntu bongmai koot, inbe Yesu imadit tina ngan le ipa pang ye ni yo taukan tooltool i. Motong la di tooltool timadit a nga tisere. Le nga tisere a tipusye, motong la tiwete panga bet ipa be, bong bet sila iye di tinepe. ");
INSERT INTO apr_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Bong ngan iwete pang di nen, “Au i, Maro iwangau bet si apa bet araia bingi dook mata ke dada yo Maro bet matan kala di tooltool ki ye i, in pang di malala kapala lapau. Yesoo, ye punu naii la Maro iwangau a asi ye i.” ");
INSERT INTO apr_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Ngan nen le ipa ye tana mai Yudia le imot, inbe ilo rumu kidi Yuda ke gaongo a lo iraia bingi dook mata pang di tooltool a tilonga. ");
INSERT INTO apr_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Ye kene atu in Yesu ikododo tana ke ran somai yo ene Genesaret, in koonoo, inbe di tooltool alunu timan pang ye a tigaliuu a tiparkat le tiparlokoloko a bet nen ngan tilongo betanga ke Maro. ");
INSERT INTO apr_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Ngan Yesu ikamata ookoo ru ke di tooltool ke yoosoongoo yo long tisolo tana ran koonoo a tikenen nga, inbe nga tingas pu kidi. ");
INSERT INTO apr_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Motong la Yesu ipas a ilo ye ookoo tina ngan atu pono. Ngan ookoo tani in ke Simon, le nga iwete pang Simon bet isurpaki kasin pang kono. Motong la Yesu iwur ookoo tani in pono, inbe ipatomonai di tooltool tina ye. ");
INSERT INTO apr_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Le nga iwetewete pang di a imot, motong la iwete pang Simon nen, “Ai, kapoi pang lama ni a kadu, lo ngan bet kakatte pu kiang tina du, a nen ngan kakap i sa ye.” ");
INSERT INTO apr_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Motong la Simon tani iraua betanga ki nen, “Atoo, tool mai, ye bong mooloo i, am le imot guramam bet le amkaua i sa, ngan le amkap toko i siap. Bong dookoot kuwete oo, le ole atoo koom a akatte pu mulu du.” ");
INSERT INTO apr_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Yeiso bet tikatte pu tina du ngan le tikap belebele di i alunu san le kasin leu be pu kidi tina ngan pukpukbe. ");
INSERT INTO apr_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Le nga tipatai pang di diedi yo tinepe ye ookoo san nga, ngan bet man tilon di. Motong la timan a tiye di tiyau i tina ngan a tipadid ookoo kidi tina ru nga, ngan le kasin leu be timere. ");
INSERT INTO apr_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Simon Pita ikamata so tina nen nga, le nga igun turunu du Yesu kene punu ke dama, inbe iwete panga nen, “Tool Mai, kukoo yau le manga mooloo, yesoo au i tool dook tiap ke geingi sennene.” ");
INSERT INTO apr_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Iwete panga nen, yesoo iye di diene tikamata i tina yo tikap nga, ngan le titakrai ye. ");
INSERT INTO apr_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Ngan Pita di diene yo Sebedi di natunu ru nga, Yemis iye Yowan, ngan di lapau tikamata i tina nen nga le titakrai ye lapau. Motong la Yesu iwete pang Simon nen, “Kutattadai be! Dookoot katai a ilo nga, ngan ole kouo urata ke kaungu di tooltool a timan pang yau.” ");
INSERT INTO apr_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Ngan nen le tiyolo ookoo kidi tina ngan ilo ete, inbe tigege so kidi ngan le imot sila ikino, inbe titoo Yesu a tila. ");
INSERT INTO apr_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Kene atu in Yesu inepe ye malala mai atu, inbe tool atu yo botoboto medana ikana tinini mai i le imot i, in iman le man ikamata Yesu. Motong la iro du iken Yesu kene punu ke dama, inbe imangmang ye a iwete panga nen, “Tool Mai, bet lom nen nga, ngan kuyei au le tinik igalanga mulu.” ");
INSERT INTO apr_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Motong la Yesu isulmaia bene la itoko tool tani, inbe iwete panga. Iyei ne, “Dook mata, au i lok nen, le ole tinim igalanga mulu.” Ngan le pattu leu be botoboto medana tina imapmap, inbe tinini dook mata mulu. ");
INSERT INTO apr_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Motong Yesu iwete betanga medana pang tool tani nen, “Ai, ken kula kugasa pang di tooltool ye so yo ayeii yong ye, in be. Bong kupa so le la ong taum kupitnai ong pang tool ke paroranga so pang Maro in mugu. Lo ngan bet kuyei paroranga ye so pang Maro ye yo tinim igalanga mulu, dawa ben tina yo wer ke Mose iwete nga, a bet nen ngan di tooltool lodi galanga ye yo tinim igalanga koot nga.” ");
INSERT INTO apr_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Bong Yesu bingi ki ipa a ingaua ni mai le imot ye so tina yo iyei nga. Le nga di tooltool alunu kaiye timan bet man tilongo betanga ki, inbe ikarata di ye matamatenge kidi a bet nen ngan tinidi dook mata mulu. ");
INSERT INTO apr_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Bong ye ke kapala ngan Yesu igege di tooltool tina, inbe ila ye ni yo taukan tooltool i la yetaleu inepe, inbe ipatarau. ");
INSERT INTO apr_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Ye kene atu in Yesu ipatomonai di tooltool yo iye di tinepe nga, inbe di Paresi le di pannoongoo ke wer ke Maro ngan tiwurur lapau. Ngan di tooltool tina ngan tipa ke malala mai Yerusalem, inbe ke malala le imot yo iken ye tana mai Galili le Yudia a tisi. Ye kene tani in Tool Mai ikaua gurana mai pang Yesu bet ikarata di tooltool yo matamatenge ikap di nga. ");
INSERT INTO apr_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Le nga di tooltool pattu titokotoko tool atu yo kene le bene ikap rama i, in ye moi ki a tikapge bet tilo pang rumu lono, a bet nen ngan lo titaru dama ke Yesu. ");
INSERT INTO apr_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Bong ni mangana pa bet tilo ye tiap, yesoo di tooltool alunu mata le tisak. Le nga tirookoo a tilo ke rumu pono, motong la tisaua ni gimono atu a tipadua le ipa ye moi ki ye ni gimono tani a idu dama ke Yesu. Ngan nen le tool tani in du pombe kataunu kat kidi tooltool budanga mai tina. ");
INSERT INTO apr_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Tiyei nen le Yesu ikamata di ben di nga titara lodi medana panga moolmool nga, le tina iwete pang tool tani nen, “Tool kiau, sennene kiong ngan agir oo.” ");
INSERT INTO apr_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Nen le nga di Paresi le di pannoongoo ke wer ke Maro ngan tilongo Yesu yo iwete nen nga, le nga lodi wetewete nen, “Ona tiap! I sei tool a iwete betanga nen nga? Nga o bet ikaua Maro nene, too? Tool sa yo bet igiri sennene kidi tooltool ngan tiap, bong Maro yetaleu.” ");
INSERT INTO apr_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Ngan Yesu lon galanga ye di ye yo lodi kaua urata nen, ngan oo, le nga itor di nen, “Nga gelei bet lomu kaua urata ye dada nen nga? ");
INSERT INTO apr_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Soo betanga imarra bet aweta i? Bet awete panga nen, ‘Sennene kiong ngan agir oo’, too bet awete panga nen, ‘Kumadit a kupa’? ");
INSERT INTO apr_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Bong au i lok bet ayei nen, a bet nen ngan ole lomu galanga bet Tool Moolmool ke Maro, in gurana ki mai ye tana i ke bet igiri sennene kidi tooltool.” Motong la Yesu iwete pang tool yo ikap rama in nen, “Ai, awete pong, kumadit a kouo moi kiong a kula pang rumu kiong.” ");
INSERT INTO apr_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Le tina pattu leu be tool ikap rama tani in imadit purukbe le lo ikodo di tooltool tina ngan matadi. Motong la ikaua moi ki yo iken pono in a ipa, inbe iyitmaka Maro ene a ila pang rumu ki. ");
INSERT INTO apr_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Ngan nen le di tooltool malala mai tina ngan tikamata so tani le titakrai ye mai san, inbe tiyitmaka Maro ene. Inbe di tapdi tiwetewete nen, “Ona! Dookoot katai nga takamata so matana san mulu pombe sa.” ");
INSERT INTO apr_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Yesu igege di tooltool tina, inbe ipa a ila ngan ikamata tool ke sodaningi pat yo ene Liwi i, in iwurur rumu ke sodaningi pat in lono. Motong la Yesu iwete panga nen, “Ai, kuman kutoo au.” ");
INSERT INTO apr_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Ngan le Liwi tani in imadit tina le igege so ki ke urata ngan le imot, inbe itoo Yesu. ");
INSERT INTO apr_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Motong la Liwi iyeie mailang mai atu rumu ki pang Yesu. Ngan le di tooltool alunu ke sodaningi pat tiye di tooltool kapala la tilo tiye di tigaua, inbe tikan so nga. ");
INSERT INTO apr_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Bong di Paresi inbe pannoongoo ke wer ke Maro yo tigaua ye budanga kidi Paresi nga, ngan tikamata Yesu iyei nen, le nga katedi malmal, inbe tipasak pang Yesu di galiunu tina. Tiyei ne, “Ai, nga gelei bet kaye di tooltool ke sodaningi pat inbe di tooltool ke geingi sennene kagaua a kakan le kayin nga?” ");
INSERT INTO apr_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Ngan Yesu iraua betanga kidi nen, “Di tooltool yo tinidi dook mata nga, ngan tool ke bar ke bet ipa pang ye di tiap, bong di tooltool la matamatenge ikap di nga. ");
INSERT INTO apr_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Ngan nanga, au i asi nga bet si akiu di tooltool yo noonoodi nga tiap, bong di tooltool yo ke geingi sennene nga, a bet nen ngan tiportak lodi.” ");
INSERT INTO apr_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Motong la di tooltool tina titoro Yesu nen, “Ai, amkamata Yowan yo irriu di tooltool in di galiunu, inbe di Paresi lapau galiudi nga, ngan tisapa ye kaningi inbe tipatarau. Bong nga gelei bet di galium nga tisapa ye kaningi le yinungu tiap nga?” ");
INSERT INTO apr_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Ngan Yesu iraua torungu kidi nen, “Kumata tamoto atu yo bet ikere i, in ikiu di sogana le di tooltool ki bet man tiye tinepe ye kerenge ki nga, ngan gelei, ole tisapa ye kaningi, too tiap? Tiap yege! ");
INSERT INTO apr_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Bong pang dama ni ngan ole di tooltool tikaua tool tani yo bet ikere in le igege di tooltool ki nga, ngan la bet ye kene tani ngan ole tisapa ye kaningi nga.” ");
INSERT INTO apr_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Motong la Yesu ikatte betanga san mulu pang di nen, “Tool sa ke bet ikaua sousoungu paunu a isarraki bet ikap timunu pa a idede sousoungu gurunu gimono ye tiap. Kumata le bet iyei nen nga, ngan ole igarungu sousoungu paunu i, inbe sousoungu gurunu tani in o dook tiap lapau, yesoo mala timunu paunu tani yo bet idede sousoungu gurunu ye i, in gaongo ye gurunu in tiap. ");
INSERT INTO apr_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Inbe tool sa ke bet ipaling ooroo wain surunu yo paunu, ngan ilo ye dap gurunu yo tikarata ye asara kulini, in tiap. Kumata le bet iyei nen, inbe ran medana tina ngan isung nga, ngan ole dap gurunu tani perbe le dap dook tiap, inbe ran medana tina ngan imatiti du tana. ");
INSERT INTO apr_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Ngan nanga, ole kapalingi ooroo surunu yo paunu ngan ilo ye dap paunu yo tikarata ye asara kulini nga. ");
INSERT INTO apr_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Inbe di tooltool yo tiyin ooroo surunu tikarata mugu nga, ngan tiwete bet lodi pang ooroo surunu yo tikarata paunu, ngan tiap. Bong tiwete bet ooroo surunu yo gurunu, ngan la dook mata nga.” ");
INSERT INTO apr_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Ye lal kidi Yuda ke sungunu atu in, ngan Yesu iye di galiunu tipa a titoo dada, ngan le tilo kumu lono ke dingding patunu ke kaningi. Motong Yesu di galiunu tikap dingding patunu tina pattu a tiwuluwulu ye bedi a kulini du tana, inbe tikan kanono. ");
INSERT INTO apr_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Ngan di Paresi pattu tikamata di, le nga tipasak pang di nen, “Ai, nga gelei a kayei dada yo wer kiam Yuda igunkalam bet amyei ye lal ke sungunu tiap nga?” ");
INSERT INTO apr_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Motong la Yesu iraua betanga kidi Paresi tina nen, “Ang nga kakinkata rau yo igasa so yo Dawiti iyeii ye kene yo iye di tooltool ki pitolo di ye i, in pitiap, too? ");
INSERT INTO apr_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Ye in idewe a ilo rumu ke Maro lono, lo ikap porong yo tiyei paroranga ye nga. Ngan porong tina, ngan di tooltool ke paroranga so leu la bet tikan nga, bong di tooltool sorok, ngan tiap. Bong Dawiti ikap porong tina a ikan, inbe ikap pang di tooltool ki a tikan lapau.” ");
INSERT INTO apr_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Motong la Yesu iwete pang di nen, “Tool Moolmool ke Maro, in ye la iyei Tool Mai pang lal kidi Yuda ke sungunu i.” ");
INSERT INTO apr_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Ke kapala iman a ila, motong la lal kidi Yuda ke sungunu san mulu pombe. Le nga Yesu ilo rumu kidi Yuda ke gaongo a ipatomonai di tooltool. Ngan le ipusye tool tamoto atu yo bene oonoo ikap rama i. ");
INSERT INTO apr_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Ngan di Paresi pattu, inbe di pannoongoo ke wer ke Maro nga, ngan tisere dada yo bet tikaua Yesu pang ye di kuto maimai ke karatanga betanga a tiweteweta ye urata ki yo iyei nga. Le nga matadi kenen ye bet tikamata, ole ikarata tool tani yo ikap rama in ye lal kidi Yuda ke sungunu, too tiap. ");
INSERT INTO apr_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Bong Yesu ikamata di tina yo lodi wetewete nen nga, le nga iwete pang tool tani yo bene ikap rama in nen, “Oi, kumadit a se kukodo dama kidi tooltool nga.” Le nga tool tani imadit lo ikodo ye ni tani in. ");
INSERT INTO apr_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Motong la Yesu iwete pang di nen, “Oo, nga bet atorang. Wer ke Maro iwete balai ye lal kidi Yuda ke sungunu? Iwete bet tayei dada dook mata pang di tooltool, too bet tayei dada dook tiap pang di? Too, iwete bet talon di tooltool a tinepe dook mata, too bet tagarung di a timmata?” ");
INSERT INTO apr_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Yesu matana pang ye di tooltool tina le imot, motong iwete pang tool yo bene ikap rama in nen, “Oo, kupadunu bem in.” Le nga tool tani ipadunu bene, ngan bene tani in dook mata mulu. ");
INSERT INTO apr_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Bong di kuto maimai ke wer ke Maro tiye di Paresi katedi malmal dook tiap pang Yesu, le di tapdi tiwetewete ye soo so yo bet tiyeii pang Yesu i. ");
INSERT INTO apr_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Ke kapala iman a ila, motong la ye ke atu in Yesu inau a ilo pang ye kawal atu a bet nen ngan lo ipatarau pang Maro. Le ye bong tani in ipas le ipatarau pang Maro le du muntu. ");
INSERT INTO apr_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Muntu ke se, motong la ikiu di galiunu tina a timan ye, ngan le ipootoo di sangaul be ru la itar di bet tiyei aposol panga nga. ");
INSERT INTO apr_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Ngan di tooltool tina ngan atu ene la Simon yo Yesu ikiui ene san ye Pita i. Inbe ipootoo Antares yo Simon tani in taini i, inbe Yemis ye Yowan ye Pilip, inbe Batolomiu, ");
INSERT INTO apr_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","inbe Matiu ye Tomas ye Yemis yo Alpias natunu i, inbe Simon yo tiwete ene san ye Selot i, ");
INSERT INTO apr_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","inbe Yuta yo Yemis natunu i, inbe Yuta Iskariot, tool tani yo bet pang dama ni ngan itara Yesu la di koi ki bedi i. ");
INSERT INTO apr_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Motong Yesu iye di aposol ki tina sangaul be ru, ngan tipa ke kawal a tisi a si tikodo ye tana lolowo atu. Ngan di galiunu tina alunu kaiye tinepe nangan. Inbe di tooltool alunu kaiye tipa ke tana mai Yudia, inbe malala mai Yerusalem a tisi, inbe kapala tipa ke tiek ye malala maimai yo Taia le Saidon, ngan tise a se tinepe lapau. ");
INSERT INTO apr_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Di ngan timan pang ye Yesu a bet man tilongo betanga ki, inbe ikarata di ye matamatenge kidi a nen ngan tinidi dook mata mulu. Inbe di tooltool kapala yo so sidi tinepe ye di nga, ngan inganga so sidi ye di a tinidi dook mata mulu. ");
INSERT INTO apr_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Inbe di tooltool alunu tina tikapge bet titoko Yesu tinini, yesoo gurana mai san iken ye, le ikarata di tooltool le imot yo matamatenge ikap di, ngan le tinidi dook mata mulu. ");
INSERT INTO apr_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Motong la Yesu matana pang ye di galiunu tina, inbe iyei ne, “Ang di tooltool yo ballingamu tiap nga, ngan lomu ponana, yesoo Maro ole iyei urata dook mata pang a matan kalang. ");
INSERT INTO apr_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Ang di tooltool yo dookoot ngan kakana pitolo nga, ngan lomu ponana, yesoo ole Maro iyei urata dook mata pang le kakan kapo sung. Ang di tooltool yo dookoot ngan katangtang nga, ngan lomu ponana, yesoo ole Maro iyei urata dook mata pang le kangele. ");
INSERT INTO apr_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Ang di tooltool yo di tooltool tikamatang katoo Tool Moolmool ke Maro, a lodi dook tiap pang inbe tingangang nga, ngan lomu ponana. Inbe ang di tooltool yo tiwete betanga dook tiap pang, inbe tigarung emu a tiwete bet ang ngan di tooltool dook tiap nga, ngan lomu ponana lapau, yesoo ole Maro iyei urata dook mata pang. ");
INSERT INTO apr_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","“Kumata le bet tiyei urata nen pang nga, ngan lomu ponana a kapases, yesoo balingi ke urata kootoonoo kiang la inamang a iken ye malala ke Maro ngo. Awete nen nga, yesoo mugu ngan di tiudi tiyei urata gaongo nen ngan pang di Maro koonoo lapau. ");
INSERT INTO apr_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Bong atoo, ang tooltool yo ballingamu nga, ngan ken kakamatang dook leu, yesoo so yo lomu ponana ye nga, ngan nangan leu la kakap koot nga. ");
INSERT INTO apr_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Atoo, ang di tooltool yo dookoot ngan kakan kapo sung nga, ken kakamatang dook leu, yesoo pang dama ni, ngan ole kakana pitolo. Atoo, ang di tooltool yo dookoot ngan lomu ponana a kangele nga, ngan ken kakamatang dook leu, yesoo pang dama ni nga, ngan ole lomu madoko a katang. ");
INSERT INTO apr_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Atoo, ang di tooltool yo di tooltool kapala tiyitmak emu nga, ngan ken kakamatang dook leu, yesoo in dada tani yo mugu ngan di tiudi tiyeii pang di tooltool kaplungunu yo tiwete di ye Maro koonoo, in nain.” ");
INSERT INTO apr_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Yesu iwete mulu nen, “Bong ang di tooltool yo katar talngamu a kalongo betanga kiau nga, ngan awete pang nen, lomu pang di koi kiang mai san, inbe kayei dada dook mata pang di tooltool yo tigarungang, ngan lapau. ");
INSERT INTO apr_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Inbe di tooltool yo tiwete betanga dook tiap a bet tigarungang ye nga, ngan kapatarau pang Maro bet iyei urata dook mata pang di. Inbe di tooltool yo tiyei dada dook tiap pang nga, ngan kapatarau pang Maro ye di, a bet nen ngan ilon di. ");
INSERT INTO apr_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Kumata bet tool atu ipodo pangam nga, ngan kuportak le kupasanga pangam san pang ye lapau. Inbe kumata bet tool atu ipinau sousoungu matolene kiong nga, ngan ken kulele be, bong kumalum panga a ikaua sousoungu mannipunu kiong in lapau. ");
INSERT INTO apr_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Inbe kop so pang di tooltool le imot yo titorong ye so nga. Inbe kumata bet tool atu ikap so kiong nga, ngan ken kuwete katkat panga a ipamulu be. ");
INSERT INTO apr_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Ngan nanga, dada dook mata yo lomu bet di tooltool tiyei pang nga, ngan ang ole kayei dada gaongo leu pang di nen lapau. ");
INSERT INTO apr_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Kumata bet lomu mai san pang di tooltool yo lodi mai san pang, ngan leu nga, ngan ole sei bet ikamatang a iyitmak emu bet ang nga tooltool dook mata i? Ngan di tooltool ke geingi sennene, ngan lodi mai san pang di tooltool yo lodi mai san pang di, ngan lapau. ");
INSERT INTO apr_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Kumata bet kayei dada dook mata pang di tooltool yo tiyei dada dook mata pang, ngan leu nga, ngan ole sei bet ikamatang a iyitmak emu bet ang nga tooltool dook mata i? Ngan di tooltool ke geingi sennene, ngan tiyei dada gaongo leu nen lapau. ");
INSERT INTO apr_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Inbe kumata bet kakap so ye bun pang di tooltool yo lomu tar di bet ole tirau, ngan leu nga, ngan ole sei bet ikamatang a iyitmak emu bet ang nga tooltool dook mata i? Ngan di tooltool ke geingi sennene, ngan lapau, tikap so ye bun pang di diedi tooltool ke geingi sennene, yesoo lodi tar di nen bet ole tirau bun tina dook le imot. ");
INSERT INTO apr_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Bong lomu mai san pang di koi kiang, inbe kayei dada dook mata pang di. Inbe kakap so ye bun pang di tooltool yo lomu tar bet di ngan ke bet ole tirau bun kootoonoo kiang tiap nga. Kumata le bet kayei nen nga, ngan la bet pang dama ni nga, ngan ole Maro ikap balingi maiyoko pang ye urata kootoonoo kiang, inbe kanepe ben Tool Mai Maro yo inepe ete in di natunu. Yesoo, ye in iyei dada dook mata pang di tooltool yo lodi ponana panga tiap nga, inbe pang di tooltool yo ke geingi dada dook tiap, ngan lapau. ");
INSERT INTO apr_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Le lomu mulumulu ye di tooltool a lomu dook mata pang di ben yo Tamamu lono mulumulu yang a lono dook mata pang nga.” ");
INSERT INTO apr_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Yesu iwete mulu nen, “Ken kakamata dada kidi diemu yo tiyei, ngan kawete bet di ngan tooltool dook tiap, ngan be. Ole nen ngan Maro ikamatang ben ang nga tooltool dook tiap lapau. Inbe ken kakamata dada kidi diemu yo tiyei, ngan kawete bet di ngan tooltool ke geingi sennene le dook mata ngan nen bet Maro iyemenai di ye. Ole nen ngan Maro ikamatang ben ang nga tooltool ke geingi sennene le dook mata bet iyemenai ang lapau. Inbe kumata le bet kagiri sennene kidi diemu yo tiyei pang nga, ngan ole Maro igiri sennene kiang nen lapau. ");
INSERT INTO apr_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Kakap so pang di tooltool ngan ole Maro ikap so pang lapau. Moolmool, ole Maro ikap so dook mata alunu kaiye pang a ipaponang le idu lopo bet ise a ipon takataka le bet imasukurai. Le dada yo kayei pang di diemu nga, ngan Maro ole iyei nen pang lapau.” ");
INSERT INTO apr_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Motong la Yesu ikatte betanga pang di nen, “Ke bet tool mata kis atu irara ene mata kis san, too? Tiap! Ngan ole yeru timol du gomo lono. ");
INSERT INTO apr_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Ngan kase yo inepe ye ni ke patomonaingi i, in o ke bet illoso pannoongoo ki le ilo ete ye, ngan tiap. Bong kumata bet itar talngana dook a ikap betanga ke pannoongoo ki le lon galanga ye dook nga, ngan ye in ole dawa ben pannoongoo ki. ");
INSERT INTO apr_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Nga gelei bet kumata tidi maitiap yo iken ye taim matana i, e lom tutu kai palini maiyoko yo iken ye matam, in tiap nga? ");
INSERT INTO apr_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Bet ong taum kumata kai palini maiyoko yo iken ye matam, in tiap nga, ngan gelei bet kuwete pang taim ne, ‘Taik, au i lok bet apaia tidi maitiap yo iken ye matam in.’ Ona, ong in tool ke kaplungunu! Lom bet nen ngan ong taum kukulu kai palini maiyoko yo iken ye matam in mugu a kumata ni dook, lo ngan bet kupaia tidi maitiap yo iken ye taim matana i.” ");
INSERT INTO apr_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Yesu ikatte betanga san mulu nen, “Kai yo dook mata i, in bet ipu ngan kanono dook tiap, ngan tiap. Inbe gaongo leu, kai yo dook tiap i, in bet ipu ngan kanono dook mata, ngan tiap lapau. ");
INSERT INTO apr_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Ngan la kai tina bet takamata puadi, ngan ole lod galanga ye di bet in kai dook mata, too kai dook tiap. Le di tooltool ke bet tila ye kai marini, a la tikaut kun puana ye tiap. Inbe di tooltool ke bet tila ye ooroo kaudangdang, a la tigogo oodoo puana ye tiap lapau. ");
INSERT INTO apr_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Ngan gaongo leu, tool yo dook mata i, in lon kaua urata ye so yo dook mata ngan leu, le ye dada le betebetanga ki nga, ngan ole ipapos so yo iken lono nga. Inbe tool yo dook tiap i, in lon kaua urata ye so yo dook tiap ngan leu, le ye dada le betebetanga ki nga, ngan ole ipapos so yo iken lono nga. Yesoo, so yo iken tool lono nga, ngan la iwete a ipas ye koonoo si mallangana nga.” ");
INSERT INTO apr_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Yesu iwete mulu nen, “Nga gelei bet kakiu au ye ‘Tool Mai, Tool Mai,’ bong katoo betanga kiau tiap nga? ");
INSERT INTO apr_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Ngan tool yo iman potai yau a ilongo betanga kiau a itoo i, in tool balai? Ole awete nini tool tani in pang. ");
INSERT INTO apr_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Ye in dawa ben tool atu yo lono bet ire rumu ki i. Bong kulkulunu ngan ikele tana le idu lopo san, lo ngan bet ipe sawa du, inbe ikatete pat le du iparama sawa punu. Motong la ire rumu ki lo sawa tina ngan pono. Le kene yo bet ki imol a oongoo mai ipot le bet itaktaka rumu ki tani ye in nga, ngan iduku tiap, yesoo tool in ire rumu ki le imede san. ");
INSERT INTO apr_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Bong tool yo ilongo betanga kiau le itoo tiap i, in dawa ben tool atu yo ire rumu ki, bong ikele tana du lopo tiap, inbe ikatete pat le du iparama sawa punu tiap. Bong ipe sawa du sorok, inbe ire rumu ki lo sawa tina ngan pono. Yeiso bet ki imol a oongoo mai ipot, inbe itaktaka rumu ki tani, ngan le pattu leu be rumu ki tani iduku le imassoroko.” ");
INSERT INTO apr_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Yesu iwete betanga tina ngan pang di tooltool tina a imot, motong la ipa a idu pang malala mai Kapenam. ");
INSERT INTO apr_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Ngan tool atu turana bulbulini ke patokongo, in kapraingi ki yo lono panga mai san i, in matamatenge mai atu ikauu le bet imata. ");
INSERT INTO apr_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Ngan tool mai tani in ilongo Yesu yo man inepe i, le nga iwanga di tooltool maimai kidi Yuda pattu bet la tiwete pang Yesu a bet man ikarata kapraingi ki tani a tinini dook mata mulu ngan. ");
INSERT INTO apr_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Tila ye Yesu, motong tiwete panga, inbe timangmang ye nen, “Ai, tool ni tool dook mata san, le dook mata ke bet ole kuloni lapau, ");
INSERT INTO apr_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","yesoo ye ni lono paidi Yuda nga le imot mai san, inbe ye la ire rumu ke gaongo atu pam i.” ");
INSERT INTO apr_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Motong la Yesu iye di tooltool tina tila pang ye tool mai ke patokongo tani. Le nga Yesu ipa le ila potai pang ye rumu ke tool tani, inbe tool mai tani, in iwanga di tooltool ki pattu bet la tiwete pang Yesu nen. Tiyei ne, “Tool Mai, tool mai kiam iwangam bet man amwete betanga ki pong nen, ‘Dookoot, ke bet urata iporong tiap, yesoo au i lok tarau ngan au i tool dook mata ke bet kuman a kulo rumu lono kiau tiap. ");
INSERT INTO apr_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Inbe au i akamatau ngan au tool dook mata ke bet amala pang yong tiap lapau. Bong bet nen ngan kupas le kuwete ye koom leu, inbe kapraingi kiau tani ole tinini dook mata mulu. ");
INSERT INTO apr_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Awete nen nga, yesoo anepe gurana ke tool mai kiau yo matan kalau, in parmana. Inbe au tauk i di tooltool kiau ke patokongo nga, ngan tinepe gurana kiau parmana lapau. Le kumata bet awete pang atu nen, “Kula,” ngan ole ila. E bet awete pang san nen, “Kuman,” ngan ole iman. E bet awete pang kapraingi kiau nen, “Kuyeie urata i,” ngan ole itoo kook a iyeie urata tani.’” ");
INSERT INTO apr_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Yesu ilongo tina yo tool mai ke patokongo tani iwete nen nga, le tina itakrai, inbe iportak pang ye di tooltool malala mai tina yo titoo nga, inbe iwete pang di nen, “Awete pang nen, au i apusye tool sa ke Isrel itara lono medana mai mata ben tool i tiap.” ");
INSERT INTO apr_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Motong la di tooltool tina yo tool mai ke patokongo iwanga di pang Yesu nga, ngan timulu a tila pang rumu ngan tikamata kapraingi ki tani in tinini dook mata mulu oo. ");
INSERT INTO apr_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Le nga mooloo tiap inbe Yesu ipa a ilo pang ye malala mai atu yo ene Nain i. Ngan di galiunu inbe di tooltool malala mai la tiye tilo nga. ");
INSERT INTO apr_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Le nga ilo potai pang ye dada ke koongoo ke malala mai tani, ngan itauarai di tooltool yo tisolo tamoto koskos atu yo imata i, in ke malala tani in lono a bet tisi pang diki nga. Ngan tool matene tani, in tinana ipasuiu yetaleu, inbe nintooroo imata le iyei garup tap a inepe. Le nga di tooltool alunu la tiye garup tani in tipa ke malala lono a tisi nga. ");
INSERT INTO apr_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Ngan ye kene yo Tool Mai ikamata garup tani ye in nga, ngan lono panga mai san. Le nga iwete panga nen, “Ai, kutang be.” ");
INSERT INTO apr_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Motong la ila potai la itoko sasaka ke tool matene tani, le nga di tooltool yo tisola nga, ngan sila tikodo. Inbe Yesu iwete pang tool matene tani nen, “Tamoto koskos, awete pong, kumadit!” ");
INSERT INTO apr_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Ngan le tamoto koskos tani in imadit le lo iwur, inbe iwetewete. Motong la Yesu ipamule mulu pang ye tinana nga. ");
INSERT INTO apr_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Ngan le di tooltool malala mai tina tikamata gurana mai ke Maro nen nga, le titakrai ye mai san, inbe tiyitmaka Maro ene. Tiyei ne, “Maro koonoo atu yo ene mai in la dookoot nga pombe kataunu kiidi koot i.” Inbe tiyei ne, “Maro isi bet si ilon di tooltool ki.” ");
INSERT INTO apr_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Motong la di tooltool tina, tila tiwete pang di tooltool ye so yo Yesu iyeii a tikamata i, le bingi ki idada le ingau malala tina ngan le imot yo iken ye tana mai Yudia nga. ");
INSERT INTO apr_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Yowan di galiunu tiwete panga ye so le imot yo Yesu iyei nga. Motong la Yowan tani in ikiu di galiunu ru a timan, ");
INSERT INTO apr_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","inbe iwete pang di nen, “Kala pang ye Yesu la katoru nen. Kayei ne, ‘I ong tool tani yo Maro ipamede betanga ye bet ole iwanga a isi i, in naii, too ole amtar matamam a amnama tool san mulu?’” ");
INSERT INTO apr_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Di tooltool ru tina tila pombe pang ye Yesu, motong la tiyei ne, “Ai, Yowan yo irriu di tooltool i, in iwangam pong la amman nga. Bet man amtorong nen, ong i tool tani yo Maro ipamede betanga ye bet ole iwanga a isi i, in naii, too ole amtar matamam a amnama tool san mulu?” ");
INSERT INTO apr_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Ye kene tani, in Yesu ikaua urata ye karatanga di tooltool alunu kaiye yo matamatenge ikap di nga. Inbe inganga so sidi ye di tooltool kapala, inbe ikarata di tooltool yo mata kis nga, ngan matadi a tikamata ni mulu. ");
INSERT INTO apr_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Le nga Yesu iraua betanga ke Yowan di galiunu ru tina nen, “Angru kamulu a kala ngan kawete pang Yowan ye betanga yo kalongo nga, inbe ye so yo kakamata ye matamu nga. Kayei ne, ‘Di mata kis tikamata ni mulu; inbe di tooltool yo kedi dook tiap nga, ngan kedi dook mata a tipa; inbe di tooltool yo botoboto medana ikan di nga, ngan tinidi dook mata mulu; inbe di tooltool yo talngadi dikidiki nga, ngan tilongo betanga mulu; inbe di tooltool yo timmata koot nga, ngan timadit mulu; inbe di tooltool yo ballingadi tiap nga, ngan tilongo bingi dook mata.’ ");
INSERT INTO apr_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Ngan tool yo ikamatau ngan itara lono medana pau le imede i, in Maro ole iyei urata dook mata panga le lon ponana ye.” ");
INSERT INTO apr_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Yowan di galiunu ru tina yo iwanga di, ngan timulu a tila, motong la Yesu imadit ye betanga pang di tooltool malala mai tina ye Yowan tani nen. Iyei ne, “Ai, kene yo kala pang ye ni soorookoonoo nga, ngan bet la kakamata soo so? Bet la kakamata piu kaini yo muru iwalisi a ila be iman i, too? Tiap. ");
INSERT INTO apr_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Ngan kala nga bet la kakamata soo so? Bet la kakamata tool atu yo itar moro ki dook mata i, too? Tiap. Di tooltool yo titar moro kidi dook mata ilo tinidi le tinidi dook mata ye nga, ngan tipas le tinepe rumu mai ke tool mai yo matan kala tana mai kidi, in leu. ");
INSERT INTO apr_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Bong soo so kala nga bet la kakamata i? Kala bet la kakamata Maro koonoo atu, too? E, ye tani nain. Le nga bet awete pang nen, Maro koonoo tani in illos di Maro koonoo kapala yo ke mugu nga. ");
INSERT INTO apr_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Ye tani in la Rau ke Maro iwetewete ye nen i. Iyei ne, ‘Kapalongo! Ole awanga tool atu ke bet imugu a ikaua bingi yong. Inbe ye la bet imugu a ikarata dada pong i.’ ");
INSERT INTO apr_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Awete pang nen, kataunu ye di tooltool yo tinepe tana i nga, ngan sa yo bet illoso Yowan, in tiap. Bong ye di tooltool yo Maro bet matan kala di nga, ngan di le imot le isi ye kase maitiap kidi atu, ngan ke bet tilloso Yowan.” ");
INSERT INTO apr_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Motong la di tooltool le imot tiye di tooltool ke sodaningi pat tilongo betanga tina yo Yesu iwete nen nga, le tiyei ne, “Maro in dada ki dook mata kaiye.” Tiwete nen, yesoo di ngan Yowan yo irriu di tooltool i, in irriu di oo. ");
INSERT INTO apr_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Bong di Paresi le di kuto maimai ke wer ke Maro, di ngan timalum pang Yowan bet irriu di tiap. Le tiwala muridi pang dada dook mata ke Maro yo ipitnaii pang di i. ");
INSERT INTO apr_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Motong la Yesu iwete mulu pang di nen, “Nga ole ayei balai bet awete le ananpootoo di tooltool yo dookoot tinepe nga ye dada kidi nga? Di nga ben di sima tooltool? ");
INSERT INTO apr_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Di ngan ben di kakase yo tiwur ye ni ke yawaringi kaningi, inbe koodi pang di diedi kakase kapala nen, ‘Am nga ammai kure pang a bet nen ngan kasiki, bong lomu pang sianga tiap sa. E amwou lelang pang a bet nen ngan katang, bong lomu pang tangini tiap lapau sa.’ ");
INSERT INTO apr_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Yowan yo irriu di tooltool i, in isi ngan ikan porong le iyin ran medana tiap. Ngan le kawete mur ye nen, ‘Ai, tool ni so sidi inepe ye.’ ");
INSERT INTO apr_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Motong Tool Moolmool ke Maro isi ngan ikan be iyin, ngan le kawete mur ye lapau. Kayei ne, ‘Kakamata, tool ni tool mata kaningi inbe tool ke yinungu ran medana sa. Le iye di tooltool ke sodaningi pat le di tooltool ke geingi sennene tigaua, inbe tikan be tiyin.’ ");
INSERT INTO apr_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Bong awete pang nen, ole kakamata lo galanga ke Maro ye dada yo bet iyeii le itara kanono dook mata ye i.” ");
INSERT INTO apr_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Ye kene atu in tool atu kidi Paresi ikiui Yesu bet lo yeru tikan so rumu ki. Le nga Yesu ilo rumu ke Paresi tani lo yeru tiwurur ye kakawa ke kaningi so. ");
INSERT INTO apr_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Ngan garup atu ke geingi sennene yo inepe ye malala mai tani lapau i, in ilongo tina yo Yesu ilo ikan so rumu ke Paresi tani nga. Le nga ikaua dap maitiap yo tikarata ye pat sallinene dook mata inbe tipalingi kai surunu kini ki dook mata ilo ye i, in a ilo pang ye rumu ke Paresi tani. ");
INSERT INTO apr_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Ilo, ngan le ikodo ke Yesu murini potai pang ye Yesu kene, inbe itang, le lulunu tomtombe du ingau Yesu kene. Motong la garup tani imusmus lulunu tina yo ingau Yesu kene, ngan ye ye taunu kutono raunu, inbe iwarara Yesu kene a isom. Motong la ikaua dap yo tipalingi ye kai surunu kini ki dook mata i, in a isalin Yesu kene ye. ");
INSERT INTO apr_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Ngan nen le Paresi tani yo ikiui Yesu bet lo yeru tikan so i, in ikamata so tani yo garup in iyeii i, le nga lon wetewete nen, “Ona, kumata bet tool i Maro koonoo moolmool nga, ngan ole lon galanga ye garup yo itoka i, bet i garup balai nga. Inbe ole lon galanga ye ben ye ni garup ke geingi sennene.” ");
INSERT INTO apr_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Motong la Yesu iwete pang Paresi tani nen, “Simon, au i betanga kiau atu bet aweta pong.” Ngan Simon iyei ne, “Pannoongoo, ngan dook mata, a kuwete betanga kiong in pau.” ");
INSERT INTO apr_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Motong la Yesu iwete panga nen, “Tooltool ru nga tikap pat ye tool atu le iyei bun pang di yeru. Ngan atu in ikap pat alunu ben 500, inbe san in ikap pat kasin ben 50. ");
INSERT INTO apr_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Bong di tooltool ru tina ngan taukadi pat yo bet tirau bun kidi yo tikap ye tool tani nga. Le nga tool tani lono pang di yeru, le iwete pang di bet tirau pat ki ngan be, bet dookoot sila ikino. Ngan nen le lom tar bet di tooltool ru tina, ngan sei lono mai san moolmool pang tool tani yo tikap pat ye i?” ");
INSERT INTO apr_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Motong la Simon iyei ne, “Au i lok tar bet tool la ikap pat alunu a iyei bun panga bong irau tiap i.” Ngan Yesu iyei ne, “E, ong in kuwete dook mata.” ");
INSERT INTO apr_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Motong la Yesu iportak le matana pang ye garup tani, inbe iwete pang Simon nen, “Kumata garup i lapau? Ase rumu lono kiong, ngan kop ran pau bet angas kek ye tiap. Bong garup i ingas kek pono ye ye taunu lulunu, motong la imusmus ye ye taunu kutono raunu. ");
INSERT INTO apr_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Ong i kuwarrau a kusomo pangak pitiap. Bong kene yo ase rumu lono kiong ye le se dookoot nga, ngan garup i iwarara kek a isom. ");
INSERT INTO apr_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ong i kouo kai surunu ke saliningi sa a kusalini kutok ye tiap, bong garup i ikaua so ke saliningi kini ki dook mata la man isalin kek ye i. ");
INSERT INTO apr_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Ngan nanga, bet awete pong nen, garup i sennene ki mai san, bong Maro igir oo, le lono pau mai san. Bong tool yo sennene ki mai tiap le bet Maro igiri i, in ole lono pau mai san mai mata tiap.” ");
INSERT INTO apr_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Motong la Yesu iwete pang garup tani nen, “Oo, sennene kiong ngan Maro igir oo.” ");
INSERT INTO apr_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Le nga tooltool kapala yo tiye tikan so nga, ngan di tapdi tiwetewete nen, “Tool i, ye tool balai a le iwete bet igiri sennene kidi tooltool nga?” ");
INSERT INTO apr_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Motong la Yesu iwete pang garup tani nen, “Ye lom medana yo kutaru pau i, in la le Maro ipamulong ye so dook tiap tani yo bet igarungong i. Le kula ngan le la kunepe ye lo silene ke Maro.” ");
INSERT INTO apr_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Tinepe kasin, motong la Yesu imadit a ipa a ila ye malala maimai le ye malala kapala a iraia bingi dook mata pang di tooltool ye dada yo Maro bet matan kala di tooltool ki ye i. Ngan le di galiunu sangaul be ru nga, ngan tiyei ene a tiye tipa. ");
INSERT INTO apr_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Inbe di garup pattu yo mugu ngan Yesu inganga di so sidi ye di inbe ikarata di le matamatenge kidi imot nga, ngan di lapau titoo Yesu. Di garup tina ngan atu ene la Madia yo tikiui ene san ye Makdala i. Ye in mugu ngan Yesu inganga di so sidi limi be ru ye. ");
INSERT INTO apr_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Inbe Yoana yo Kusa rimana i, in itoo Yesu lapau. Ngan Kusa tani in iyei ben tool kuto mai atu a matan kala rumu ke Erot. Inbe Susana iye di garup kapala lapau la titoo Yesu nga. Di garup tina ngan tikap so kidi tapdi pang Yesu iye di galiunu a tilon di ye lapau. ");
INSERT INTO apr_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Ngan di tamoto malala mai la tipa ye malala maimai kapala a timan le man tigaua. Motong la Yesu ikatte betanga atu pang di nen, ");
INSERT INTO apr_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Ye kene atu ngan tool ke kapgingi atu in ikap dingding patunu ke kaningi bet la igiri kumu ki. Ngan kene yo igiri ye in nga, ngan kapala imol du dada katene. Ngan nen le di tooltool tipa pono, inbe di man yo tiro lang katene ngan tikamata le man tikan. ");
INSERT INTO apr_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Inbe dingding patunu kapala ngan imol du ye tana yo ke lopo ki in bongarngar i, le tisup dook mata a tise, bong mooloo tiap inbe timallai a tiwod, yesoo bong tana tani ke lopo ki in bongarngar le taukan ran. ");
INSERT INTO apr_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Inbe dingding patunu kapala ngan imol du ooroo kaudangdang lono. Ngan nen le tisup pa ye kaudangdang le ooroo kaudangdang tani in iturai di le tisup dook tiap. ");
INSERT INTO apr_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Bong dingding patunu kapala ngan imol du ye tana yo dook mata nga. Ngan nen le tisup dook le dingding tina kaini atu atu ngan titar kanodi alunu belebele ben 100.” Yesu ikatte betanga pang di nen a imot, motong la koonoo nen, “Sei tool bet talngana ke longono betanga nga, ngan itar talngana dook a ilongo betanga kiau nga.” ");
INSERT INTO apr_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Ngan Yesu di galiunu titoru bet iwete nini betanga tani yo ikatte i, in punu pang di. ");
INSERT INTO apr_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Motong la iwete pang di nen, “Mugu ngan dada yo Maro bet matan kala di tooltool ki ye i, in iken sollono, bong dookoot nga ye in lon ponana bet ipaposi pang a lomu galanga ye dook. Bong di tooltool kapala nga, ngan ole akatte betanga pang di leu. Ngan nanga, ‘Ole tikamata urata ke Maro, bong o ke bet tikilala tiap. Inbe ole tilongo betanga ke Maro, bong o ke bet lodi galanga ye punu nga tiap.’ ” ");
INSERT INTO apr_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Motong la Yesu iwete nini betanga tani yo ikatte i, in punu pang di nen, “Dingding patunu tina, ngan ben betanga ke Maro. ");
INSERT INTO apr_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Inbe dingding patunu yo imol du dada katene nga, ngan ben di tooltool kapala yo tilongo bingi dook mata ke Maro. Bong tool kuto mai kidi so sidi iman tina ngan le ikaua betanga tani yo iken lodi in a ikutaki ye di. Ngan tina nen le titara lodi medana pang Maro a bet nen ngan ikap di a ipamulu di ye so dook tiap yo bet igarung di i, in tiap. ");
INSERT INTO apr_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Inbe dingding patunu yo imol du ye tana yo ke lopo ki in bongarngar nga, ngan ben di tooltool kapala yo tilongo betanga ke Maro le tikauu a lodi ponana ye nga. Bong betanga tina ngan tiparama le imede tiap, ngan nen le titara lodi medana ye mai mata tiap lapau. Yeiso bet touanga pombe pang ye di ngan tigege lodi medana yo titaru i, inbe tiwala muridi pang Maro. ");
INSERT INTO apr_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Inbe dingding patunu yo imol du ooroo kaudangdang lono nga, ngan ben di tooltool kapala yo tilongo bingi dook mata ke Maro. Bong lodi rru bet ole titoo too tiap, yesoo lodi madoko mata ye nepongo kidi ke tana i, inbe balingi le so dook mata kapala yo bet tikap a lodi ponana ye nga. Ngan nen le di ngan ben dingding patunu yo tisup bong titar kanodi tiap nga. ");
INSERT INTO apr_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Bong dingding patunu yo imol du ye tana dook mata nga, ngan ben di tooltool yo lodi ken dook mata bet tilongo bingi dook mata ke Maro a titara lodi medana ye. Inbe di ngan tikodo le timede ye lo medana kidi lapau. Ngan nen le di ngan ben dingding patunu yo tisup a tise le titar kanodi alunu kaiye nga.” ");
INSERT INTO apr_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Motong la Yesu ikatte betanga san mulu nen, “Tool sa ke bet ilanga sul ki bong, lo ngan bet inona lo bor lono a itarkoo tiap. Inbe ole itaru du kakawa ke kenongo parmana, tiap lapau. Bong ole ipawoti lo ete, a bet nen ngan di tooltool bet tise rumu lono ki ngan tikamata ni ye lulngana. ");
INSERT INTO apr_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Ngan nanga, so le imot yo di tooltool titarkoo a iken sollono nga, ngan pang dama ni ngan ole Maro ipapos se mallangana. Inbe betanga yo titarkoo le di tooltool ke bet tilongo tiap nga, ngan ole ise mallangana le imot lapau a di tooltool lodi galanga ye. ");
INSERT INTO apr_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Ngan ang ngan ken kakauwai yang dook a bet nen ngan katar talngamu dook a kalongo betanga kiau. Kumata le sei tool bet lon galanga ye betanga ke Maro a itoo nga, ngan ole Maro ipagalanga lono ye betanga ki sa mulu. Bong sei tool yo lon galanga ye betanga ki kasin, bong itoo tiap i, in Maro ole ikutak lo galanga kasin yo lon tar bet iken ye nga, ngan le inepe sorok.” ");
INSERT INTO apr_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Motong la ye kene tani in Yesu tinana le di taini timan bet man tikamata. Bong ngan rumu ipon ye di tooltool malala mai, le tisak bet tilo rumu lono. ");
INSERT INTO apr_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Le nga tool atu lo iwete pang Yesu nen, “Ai, tinam le di taim la man tikododo diki nga, ngan lodi bet tikamatong.” ");
INSERT INTO apr_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Motong la Yesu iraua betanga ki nen, “Di tooltool yo tilongo betanga ke Maro le bet titoo nga, ngan di ngan la di tinak le di taik nga.” ");
INSERT INTO apr_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Ye kene atu in Yesu iwete pang di galiunu tina nen, “Ai, nga ole tala ke ran koonoo kapala.” Le nga tiyiri lo ookoo pono, motong la tikooi a tila. ");
INSERT INTO apr_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Ngan tikooi me pono go, inbe Yesu iken mata. Bong eng mai imadit tina le tiek ipases a ilo ookoo lono, le kasin leu be ookoo kidi imere. ");
INSERT INTO apr_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Le nga di galiunu tina ngan tipoongoo. Tiyei ne, “Tool mai, tool mai, kumadit! Nga bet tallede!” Motong la Yesu imadit tina le iwete katkat pang eng le kokor tina, le taun katen si, inbe ran manini dook mata. ");
INSERT INTO apr_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Motong la Yesu iportak pang ye di galiunu tina, inbe iwete pang di nen, “Ai, ngan lomu medana yo bet kataru pau i, in la nangai i?” Bong di galiunu tina titakrai belebele, inbe tatattadai lapau, le di tapdi tiwetewete pang di nen, “Ona tiap! I soo tool nen i a le iwete katkat pang eng le ran ngan le tilongo koonoo nga?” ");
INSERT INTO apr_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Ye kene tani in Yesu iye di galiunu tina ngan tipoi ye ookoo kidi a tila le la pombe ye tana mai kidi tooltool ke Gerasa yo iken ke ran Galili koonoo kapala i. ");
INSERT INTO apr_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Tila pombe, le nga Yesu ipas ke ookoo pono a idi pang tana, ngan tool ke malala mai tani in atu yo so sidi idiwidiwoo i, in ipot le pot itauaraii. Ye in mukot yege ni nga, ngan iwit toko mala sa yo bet iyakala tinini ye, ngan tiap. Inbe inepe ye rumu siap lapau, bong ipas le inepe agoro lono kidi matenge leu. ");
INSERT INTO apr_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Yeiso bet tool tani in ikamata Yesu, motong la itang le mai, inbe imol du igun turunu Yesu kene punu, inbe koonoo le mai. Iyei ne, “Atoo! Yesu, ong i Maro yo inepe ete ni, in natunu. Nga soo so bet kuyeii pau i? Atorong bet ken kop masngana pau be!” ");
INSERT INTO apr_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Ngan koonoo le mai nen, yesoo bong Yesu ipasak pang so sidi tani bet ikoo ye tool tani in a isi tana. Ngan kanakana ngan di tooltool kapala tiparama a tipau kene le bene ye ooroo medana, inbe tikodo a matadi kala. Bong so sidi idiwidiwoo le gurana mata le ikupkuprai ooroo medana tina, inbe idada a ila inepe ye ni yo taukan tooltool i. ");
INSERT INTO apr_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Motong la Yesu itoru nen, “Ong i em sei?” Ngan iraua betanga ke Yesu nen, “Au i ek la Budanga i.” Ngan iwete nen, yesoo bong so sidi alunu la tinepe ye tool tani nga. ");
INSERT INTO apr_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Ngan di so sidi tina titor tootoo Yesu a timangmang ye nen, “Atoo, ken kungangam a amdu amnepe ye tana gimono yo taukan launu, in be.” ");
INSERT INTO apr_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Ngan ga budanga mai tisu a tikanen ye kawal atu yo iken potai pang ye di i, in madini. Motong la di so sidi tina titoro Yesu a timangmang ye bet imalum pang di a tila la tidewe a tilo di ga tina ngan lodi. Ngan le Yesu imalum pang di bet tila. ");
INSERT INTO apr_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Le nga di so sidi tina ngan tipas a tigege tool tani, inbe tidada a tila le la tidewe a tilo di ga tina ngan lodi. Motong di ga tina ngan tidada a tila sakar matana a tipas du ran lono le taun tidaup a timmata. ");
INSERT INTO apr_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Le nga di tooltool tina yo matadi kala di ga nga, ngan tikamata so tani in ye matadi. Motong la tidada a tilo lo tikaua bingi pang di tooltool yo tinepe ye malala maimai inbe ye malala yo kapala ngan lapau. ");
INSERT INTO apr_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Di tooltool tilongo bingi, le nga tidu bet du tikamata so tina yo pombe nga. Ngan tidu pompombe pang ye Yesu nga, ngan tikamata tool tani yo so sidi igege i, in kuton kaua urata dook mulu, inbe isousou ye sousoungu a iwurur potai pang ye Yesu kene punu nga. Ngan nen le titattadai. ");
INSERT INTO apr_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Motong di tooltool tina yo tikamata Yesu inganga di so sidi ye tool tani nga, ngan tigasa urata tani yo Yesu iyeii panga le tinini dook mata mulu i, in pang di tooltool tina yo tisi nga. ");
INSERT INTO apr_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Ngan di tooltool le imot ke tana mai Gerasa tilongo gasanga tina le titattadai belebele, le nga tiwete pang Yesu bet ikoo ye ni kidi, inbe ila pang ye ni san mulu. Motong la Yesu ipas lo ookoo pono a bet imulu a ila. ");
INSERT INTO apr_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Bong tool tani yo so sidi ikoo ye i, in itoro Yesu a imangmang ye bet imalum panga a nen ngan iye tila. Bong ngan Yesu imalum panga tiap. Iyei ne, ");
INSERT INTO apr_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Kumulu a kulo pang ye malala kiong, lo kugasa pang di tooltool ye so dook mata yo Maro iyeii pong i.” Motong la tool tani, in imulu a ilo pang malala mai a lo igasa pang di tooltool ye so tina le imot yo Yesu iyei panga nga. ");
INSERT INTO apr_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Motong la Yesu igege ni tani, inbe iye di galiunu tiyiri ye ookoo kidi a timulu a tila pang ran koonoo kapala. Ngan le di tooltool malala mai yo titar matadi ye a tinamu nga, ngan tikamata le lodi ponana ye yo imulu a ilong pang ye di nga. ");
INSERT INTO apr_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Inbe tool atu yo ene Yairus i, in ipa a idu. Ngan ye in tool mai atu yo matan kala rumu kidi Yuda ke gaongo i. Le nga idu ikamata Yesu, motong la igun turunu du Yesu kene punu, inbe itoru a imangmang ye bet yeru tidi pang rumu ki. ");
INSERT INTO apr_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Ngan imangmang ye nen, yesoo bong Yairus tani in natunu garup ataleu, inbe rai ki sangaul be ru leu, bong matamatenge mai ikauu le bet imata. Motong la Yesu ipa a bet idi pang ye rumu ke tool tani, ngan le di tooltool malala mai tina ngan titoo lapau le tiparlokoloko. ");
INSERT INTO apr_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Ngan garup atu yo iyolo rara ye rai sangaul be ru i, in inepe lapau. Bong tool sa bet ikamata a iloni, a nen ngan ikarata le tinini dook mata mulu, ngan tiap. ");
INSERT INTO apr_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Motong la garup tani in ipa ke Yesu murini le isulmaia bene la itoko sousoungu matolene ke Yesu, in matana. Yeiso bet iyei nen, ngan le pattu leu be rara mooloo tani in imot ye le iwodowodo dook mata. ");
INSERT INTO apr_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Motong la Yesu itor di nen, “Ai, sei itokau i?” Ngan di tooltool tina ngan di le imot tipataukala, motong la Pita iyei ne, “Tool mai, di tooltool malala mai san la tigaliu ong le tiparlokoloko nga.” ");
INSERT INTO apr_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Bong ngan Yesu iyei ne, “Tool atu la itokau i, le ayetai ben gurana kiau kasin ilungmai au oo.” ");
INSERT INTO apr_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Motong la garup tani in lon tar nen o ke bet itarkoo tiap. Le nga itattadai, inbe itangarur a iman tina le igun turunu du Yesu kene punu, inbe iwete pang di tooltool tina ngan le imot ye soo so a le itoko Yesu, ngan le pattu leu be tinini dook mata mulu ye i. ");
INSERT INTO apr_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Motong la Yesu iwete panga nen, “Natuk, lo medana kiong yo kutaru pau i, in la ikaratong le tinim dook mata mulu i. Le kula ngan le la kunepe ye lo silene ke Maro.” ");
INSERT INTO apr_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Yesu iwetewete pang garup tani in go, inbe tool atu ipa ye rumu ke Yairus a ipot pombe. Le nga iwete pang Yairus nen, “Atoo, natum garup in imata oo. Le ken kuporo pannoongoo in bet idi mulu be.” ");
INSERT INTO apr_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Yesu ilongo betanga tina yo tool tani in iwete nga, le nga iwete pang Yairus nen, “Ken kutattadai be, bong kuparama lo medana yo kutaru pau in le imede, ngan natum ole imadit mulu.” ");
INSERT INTO apr_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Yesu iwete nen a imot, motong la kene yo tipa le di pombe rumu ke Yairus tani nga, ngan ilele di tooltool bet titoo a tilo rumu lono be. Le ikaua Pita ye Yowan ye Yemis inbe garup kase tani in tamana le tinana leu, la iye di tilo rumu lono nga. ");
INSERT INTO apr_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Tilo ngan di tooltool le imot yo tinepe rumu nga, ngan titangtang inbe tiwou aisor. Motong la Yesu iwete pang di a ilele di nen, “Katang dookoot! Garup kase in imata tiap, bong iken mata leu.” ");
INSERT INTO apr_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Ngan nen le di tooltool tina tingeleraia Yesu ye yo iwete nen nga, yesoo lodi galanga nen, garup kase in imata oo. ");
INSERT INTO apr_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Motong la Yesu itoko garup kase tani in bene, inbe koonoo panga nen, “Natuk, kumadit.” ");
INSERT INTO apr_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Le nga garup kase tani in imagur mulu le tina pattu leu be imadit le lo ikodo. Motong la Yesu iwete pang tamana le tinana bet tikap so panga a ikan. ");
INSERT INTO apr_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Ngan garup kase tani in tamana le tinana tikamata yo imadit mulu nga, le tina titakrai. Bong ngan Yesu ilele di bet ken tiwete pang tool sa ye so yo pombe, in be. ");
INSERT INTO apr_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Ye kene atu ngan Yesu ikiu di aposol ki tina yo sangaul be ru nga man tigaua, motong la ikap gurana pang di, inbe imalum pang di bet tila la tiyei urata nga, ngan ole gurana kidi ke bet tinganga di so sidi ye di tooltool, inbe tikarata di tooltool yo matamatenge ikap di nga le tinidi dook mata mulu. ");
INSERT INTO apr_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Inbe iwanga di bet tila la tiraia bingi dook mata pang di tooltool ye dada yo Maro bet matan kala di tooltool ye i, inbe tikarata di tooltool yo matamatenge ikap di nga le tinidi dook mata mulu. ");
INSERT INTO apr_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Motong la Yesu iwete pang di nen, “Ken kakap so sa ye panga kiang be. Le so ben toto ke panga le depe, inbe porong le pat, ngan ken kakap be. Inbe kakap sorok lonloningi kiang san mulu be. ");
INSERT INTO apr_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Ngan kapa le lo pombe ye malala atu le soo rumu tikauu pang bet kanepe ye nga, ngan kanepe ye rumu tani in leu, le lo lal yo bet kamadit a kagege malala mai tani in. ");
INSERT INTO apr_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Bong kumata bet kala ye malala atu le di tooltool ki lodi bet tikau ang tiap nga, ngan ye kene yo bet kagege malala tani in nga, ngan kataurai gauru ke kemu sila ikino, a bet nen ngan iyei ben tarkilanga pang di ye dada dook tiap kidi yo tiyeii pang i.” ");
INSERT INTO apr_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Motong la di aposol tina ngan tipa a tila ye malala in le ngan tila ye malala san a tiraia bingi dook mata pang di tooltool, inbe tikarata di tooltool yo matamatenge ikap di nga, le tinidi dook mata mulu. ");
INSERT INTO apr_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Ngan Erot, tool kuto mai yo matan kala tana mai Galili i, in ilongo bingi ke so tina le imot yo Yesu iyei nga, ngan le lon sakarungu, yesoo di tooltool kapala ngan tiwete bet Yowan ke rriungu di tooltool tani yo imata koot i, in la o imadit mulu a inepe i. ");
INSERT INTO apr_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Ngan di kapala tiwete bet o Ilia la pombe mulu i, inbe di kapala ngan tiwete bet o Maro koonoo yo ke mukot nga, ngan atu la imadit mulu i. ");
INSERT INTO apr_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Bong ngan Erot iparu longono betanga yo tiwete ye Yesu nen nga, le nga iyei ne, “Tiap, Yowan tani, in akurutu gurini oo. Bong i sei tool alongo bingi ki nen i?” Ngan Erot lono bet le ikamata Yesu matana pa a nen ngan ikilla. ");
INSERT INTO apr_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Di aposol ke Yesu yo iwanga di a tila nga, ngan timulumulu a timan pompombe pang ye, le nga tigasa urata kidi yo la tiyei, ngan pang Yesu. Motong la Yesu ikap di a tigege di tooltool kapala, inbe iye di leu tila pang ye malala mai atu yo ene Betsaida i. ");
INSERT INTO apr_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Bong ngan di tooltool malala mai tina ngan lodi galanga yo bet Yesu ila pang ye malala tani in nga, le nga titoo lapau a tila. Tila pompombe a Yesu ikamata di, ngan le lon ponana, motong la iwetewete pang di ye dada yo Maro bet matan kala di tooltool ye i, inbe ikarata di tooltool kapala yo matamatenge ikap di nga, le tinidi dook mata mulu. ");
INSERT INTO apr_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Yesu ipatomonai di tooltool malala mai tina le le du rrai. Motong la di aposol ki tina yo sangaul be ru nga, ngan timan pang ye man tiyei ne, “Tool Mai, ni yo tanepe ye i, i ni balim sa. Le kuwete pang di tooltool nga a tila pang ye ni kapala, too ye malala kapala yo iken potai nga, a bet nen ngan la tisere kaningi le rumu ke kenongo ye nga.” ");
INSERT INTO apr_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Bong ngan Yesu iraua betanga kidi nen, “Tiap! Ole ang tapmu kakap so pang di a tikan.” Ngan di galiunu tiraua betanga ki nen, “Ona tiap! Di tooltool nga alunu san. Inbe porong kiam nga dukumu limi, inbe i paranga kiam nga ru leu. Bong lom balai, bet la amyimi kaningi sa mulu pang di tooltool malala mai nga man tikan, too?” ");
INSERT INTO apr_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","(Ngan di tooltool tina, ngan tikinkat di tamoto leu ngan ben 5,000). Motong la Yesu iwete pang di galiunu bet tipatar di tooltool tina ye budanga atu atu le di tooltool sangaul limi ngan tinepe ye budanga atu. ");
INSERT INTO apr_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Le nga di galiunu tina tipatar di tooltool tina le tiwur ben tina yo Yesu iwete nga. ");
INSERT INTO apr_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Motong la Yesu ikap porong dukumu limi ipa ye i ru tina, inbe itada a matan lo pang ye malala ke Maro, inbe iwete lo ponana ki pang Maro ye. Motong la itepalapala a isuket pang di galiunu bet timalimi di tooltool tina ye a tikan. ");
INSERT INTO apr_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Ngan di tooltool tina ngan di le imot tikan tikan le lo kapodi sung dook. Motong la di galiunu tiwinnoko kaningi naunu naunu tina yo tiwulai nga, ngan le tipadid ye karei sangaul be ru le lo ipon. ");
INSERT INTO apr_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Ye kene atu in Yesu yetaleu inepe a ipatarau nga, ngan di galiunu tina ngan tinepe lapau. Le nga itor di nen, “Ai, di tooltool malala mai nga tiwete bet au i sei?” ");
INSERT INTO apr_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Ngan di galiunu tiyei ne, “Di tooltool kapala tiwete bet ong in Yowan yo irriu di tooltool i, inbe kapala tiwete bet ong in Ilia. Inbe di tooltool kapala tiwete bet ong in Maro koonoo atu yo ke mukot nga, ngan atu la o imadit mulu i.” ");
INSERT INTO apr_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Motong la Yesu itor di mulu nen, “Ngan ang tapmu nga, kawete bet au i sei?” Ngan Pita iraua betanga ki nen, “Ong in Kirisi, tool tani yo Maro ipootoo bet si ipamulu di tooltool ki ye so dook tiap tani yo bet igarung di i.” ");
INSERT INTO apr_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Motong la Yesu iwete betanga medana pang di galiunu tina a iso lodi bet ken tigasagasa pang di tooltool kapala be. ");
INSERT INTO apr_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Motong la Yesu iwete pang di galiunu mulu nen, “Tool Moolmool ke Maro ole isolo moonoo le masngana alunu kaiye. Inbe di tooltool maimai kidi Yuda tiye di tooltool maimai ke paroranga so pang Maro, inbe di pannoongoo ke wer ke Maro, ngan ole tiwala muridi panga, inbe tiraumate le imata. Bong ole iken ye ke ru, lo ngan bet ye ke tol ki ngan ole imadit mulu ye ni ke matenge.” ");
INSERT INTO apr_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Motong la iwete pang di galiunu tina le imot nen, “Kumata tool atu lono bet man itoo au nga, ngan ye taunu irautoo le du inepe lopo, inbe kanakana ngan isolo kai palasingi ki a itoo au. ");
INSERT INTO apr_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Yesoo, sei tool yo lono mai san ye nepongo ki ke tana i mai mata a iparama i, in ole ilene. Bong sei tool yo lono mai san ye nepongo ki ke tana i tiap, inbe iraia tinini le imot bet iyei urata kiau i, in ole ikaua nepongo dook mata yo taukan motingi i. ");
INSERT INTO apr_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Le kakamata, tool bet iyau balingi matana matana le imot ke tana i panga, lo ngan bet imata a ila nga, ngan ole balingi tina ngan iloni balai? ");
INSERT INTO apr_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Inbe kumata sei tool bet moomoonoo yau, inbe moomoonoo ye betanga kiau le ipataukala ye di tooltool tina ngan matadi nga, ngan ye kene yo bet Tool Moolmool ke Maro imulu a isi ye i, in ole moomoonoo ye tool tani lapau. Ye in ole ipa ye lulngana, inbe ye Tamana iye di bangabangana ke Maro yo ipootoo di panga ye taunu ngan lulngadi lapau a isi nga, bong ye kene tani ole moomoonoo ye di tooltool yo mugu ngan moomoodi ye nga. ");
INSERT INTO apr_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Awete pang moolmool nen, di tooltool kapala yo dookoot taye di takododo ni nga, ngan ole timmata tiao, inbe tikamata dada yo Maro bet matan kala di tooltool ki ye i, in ole pombe mallangana.” ");
INSERT INTO apr_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Tinepe le lo so ben ke limi be tol iman a ila, motong la ikaua Pita iye Yowan inbe Yemis a iye di tilo pang kawal bet lo di leu tinepe nango, a nen ngan ipatarau. ");
INSERT INTO apr_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Le nga ye kene yo Yesu ipatarau ye in nga, ngan matan palele, inbe sousoungu le mala ki nga ikoko le ikoko belebele dawa ben kili itai nga. ");
INSERT INTO apr_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Inbe mooloo tiap bet di Maro koonoo ru yo Mose iye Ilia nga, ngan pombe pang ye Yesu a tiye tiwetewete. ");
INSERT INTO apr_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Di ngan tipa ye Maro lulngana la tisi bet si tiye Yesu tiwetewete ye betanga yo Maro ikarata bet Yesu ole imata Yerusalem, lo ngan bet igege tana i a bet ilo nga. ");
INSERT INTO apr_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Ngan Pita iye di diene ru nga, ngan matadi ge dook tiap le nga titure. Bong yeiso bet kene yo di tol titakrai a timadit ye in nga, ngan tikamata Yesu lulngana, inbe suru tina yo tiye tikododo nga. ");
INSERT INTO apr_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Le nga ye kene yo Mose ye Ilia tina ngan bet tigege Yesu a tilo, motong la Pita iwete panga nen, “Tool Mai, nga dook mata ke bet idi nga tanepe nanga. Le kumalum pam, a bet nen ngan amre badabada tol; atu pong, san pang Mose, inbe san pang Ilia.” (Ngan Pita isere betanga yo bet iweta i, ngan la le iwete sorok nen nga.) ");
INSERT INTO apr_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Pita iwetewete pang Yesu go, inbe eng tene isi le si rur ki iloko la podi, le di galiunu tina ngan titattadai ye yo eng tene isi le si iloko la podi nga. ");
INSERT INTO apr_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Inbe tool atu kalngana pombe eng tene tani lono in iwete nen, “Tool in au natuk yo apootoo bet iyei urata kiau i. Le kalongo betanga yo bet iwete pang nga!” ");
INSERT INTO apr_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Ngan tool tani in kalngana iwete nen a imot, motong la di galiunu tina bet matadi sarai ngan tikamata Yesu ataleu la ikododo i. Le nga ye kene yo bet timulu ke kawal a tidu ye in nga, ngan di galiunu di tapdi tipataukala betanga le tigasagasa pang tool sa ye so tina yo tikamata, ngan tiap. ");
INSERT INTO apr_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Yesu iye di galiunu tol tina tinepe le mongmongini ki, motong la tipa ke kawal a tisi, ngan le di tooltool malala mai tipa a timan titauarai di dada. ");
INSERT INTO apr_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Ngan tool atu yo ipa kataunu ye di tooltool malala mai tina i, in koonoo pang Yesu nen, “Atoo, Pannoongoo, atorong bet kulonau a kumata natuk tamoto ni ngan, yesoo bong ni natuk ataleu tani nani. ");
INSERT INTO apr_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Ngan kanakana nga bet so sidi idiwidiwoo nga, ngan ole palbe leu be isulukat a ikatte du tana, inbe isodangadanga a ngoonoo sian du. Ngan nen le so sidi tani in igarungu tinini le ke bet ikoo ye pitiap yege. ");
INSERT INTO apr_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Ngan la aman bet man ator di galium nga bet tinganga so sidi ye, bong ngan ke bet tiloni tiap.” ");
INSERT INTO apr_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Motong la Yesu iyei ne, “Ona tiap! Ang di tooltool yo dookoot kanepe nga, ngan katara lomu le imede ye Maro tiap, bong lomu kap dada dook tiap alunu san. Nga ole ke pi mulu bet nen ngan ayang tanepe inbe awete a kayei dada yo nen ngan mulu ye nga?” Motong la iwete pang tool tani nen, “Oo, kouo natum in a iman yau me e ni.” ");
INSERT INTO apr_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Motong la bet ikaua kase tani a iman pang ye Yesu, ngan so sidi tani in idiwidiwoo a ikatte du tana le isodangadanga, inbe ngoonoo sian du. Bong ngan Yesu ipasak pang so sidi tani a inganga, inbe ikarata kase tani in le tinini dook mata mulu. Motong la ipamule pang ye tamana mulu. ");
INSERT INTO apr_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Ngan nen le di tooltool malala mai tina yo tinepe nga, ngan titakrai, yesoo bong tikamata ben gurana ke Maro in mai san ye yo ikarata kase tamoto tani in nga. Ye kene tani yo di malala mai tina ngan tikamata so le imot yo Yesu iyei nga le nga titakrai a lodi kaua urata ye go nga, ngan Yesu iwete pang di galiunu nen, ");
INSERT INTO apr_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Katar talngamu dook ye betanga kiau a kalongo. Ole titara Tool Moolmool ke Maro la di koi ki bedi.” ");
INSERT INTO apr_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Bong betanga ke Yesu yo iwete nga, ngan di galiunu lodi galanga ye tiap. Inbe betanga tina ngan punu iken mallangana pang di ke bet lodi galanga ye tiap lapau. Bong ngan di galiunu tina ngan titattadai bet titoru ye soo so yo iwetewete ye nga. ");
INSERT INTO apr_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Motong ye kene atu in Yesu di galiunu tina ngan di tapdi tiwetewete a tiparsu ye sei tool bet iyei kuto mai a imugu pang di i. ");
INSERT INTO apr_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Ngan Yesu lon galanga ye betanga tina yo tiparsu ye a ikenen lodi ngan oo. Le nga ikaua tool kase mai tiap atu a iman ipatokode gigini. ");
INSERT INTO apr_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Inbe iwete pang di nen, “Kumata sei tool bet lon tutau le ikaua kase maitiap yo nen in a iloni nga, ngan ye in ikau au a ilonau lapau. Inbe kumata sei tool bet ikau au a ilonau nga, ngan ye in ilono Tamak yo iwangau a asi i, in lapau. Yesoo, sei tool yo ye taunu irautoo le idu lopo ye di diene kapala nga le imot i, in ye la bet Maro ikamata ben ene mai i.” ");
INSERT INTO apr_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Yowan ilongo tina yo Yesu iwete nen nga, motong la iyei ne, “Tool mai, amkamata tool atu in ipootoo em, inbe inganga di so sidi ye. Le amkapge bet amwete panga a amlele, yesoo ye in inepe ye budanga kiidi tiap.” ");
INSERT INTO apr_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Ngan Yesu iwete pang Yowan nen, “Tiap, ken kalele be! Yesoo, tool yo iyei koi pang tiap i, in ben tool kiang.” ");
INSERT INTO apr_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Ngan lal tani yo Maro itaru bet ikaua Yesu a ilo pang ye malala ki i, in iman potai oo. Le nga Yesu igaua lono le atu bet ole ilo pang malala mai Yerusalem. ");
INSERT INTO apr_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Motong la iwanga di tooltool pattu yo bet timugu a lo tipare so panga nga, ngan a tilo pang ye malala atu kidi Samaria. ");
INSERT INTO apr_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Bong ngan di tooltool ke malala tani in lodi bet tikaua Yesu a ilo rumu kidi tiap, yesoo lodi galanga nen nga bet ilo pang Yerusalem. ");
INSERT INTO apr_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Le nga di galiunu ru tina yo Yemis ye Yowan nga, ngan tikamata dada dook tiap yo di Samaria tiyeii pang Yesu i, motong la yeru tiwete panga nen, “Tool mai, nga lom balai, bet koomam a ei ipa ke malala ke Maro a isi si igarung di tooltool nga, too?” ");
INSERT INTO apr_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Bong ngan Yesu idalele a ipasak pang di yeru. ");
INSERT INTO apr_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Motong la tipa mulu a tila pang ye malala san nga. ");
INSERT INTO apr_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Yesu iye di galiunu tipa dada go, inbe tool atu iwete panga nen, “Au i ole atoo ong ye ni nangai yo bet kupa pang ye nga.” ");
INSERT INTO apr_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Motong la Yesu iwete panga nen, “Di gaunu gok ngan agoro kidi ke kenongo, inbe di man ngan giniu kidi ke kenongo lapau, bong Tool Moolmool ke Maro, in taukan ni yo bet iken a imaryoo ye i.” ");
INSERT INTO apr_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Motong la Yesu iwete pang tool san mulu nen, “Ai, kuman kutoo au.” Bong ngan tool tani iwete pang Yesu nen, “Tool Mai, nga dook mata, bong ole kumalum pau a la akelmaia tamak mugu ngan, lo ngan bet man atoo ong.” ");
INSERT INTO apr_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Ngan Yesu iwete panga nen, “Di tooltool yo titoo Maro tiap le tinepe dawa ben di tooltool matedi nga, ngan ole di tapdi tikelmai di diedi yo timmata koot nga. Bong ong in kula a la kuraia bingi dook mata ke dada yo Maro bet matan kala di tooltool ki ye i.” ");
INSERT INTO apr_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Motong la tool san mulu iwete pang Yesu nen, “Tool Mai, au i lok bet atoo ong. Bong kulkulunu ngan ole kumalum pau a amulu la akamata di sogak, inbe aye di amwetewete a atoko bedi ngan.” ");
INSERT INTO apr_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Motong la Yesu iwete panga nen, “Tool atu bet itoko poi ye ookoo ki, bong kanakana ngan idalele pang mur nga, ngan o iyei urata dook tiap. Ngan gaongo leu, kumata le tool atu bet itoo au, bong kanakana ngan lono mulumulu ye so ki ke tana i nga, ngan ye in tool dook mata ke bet lo igaua ye di tooltool yo Maro bet matan kala di, ngan tiap lapau.” ");
INSERT INTO apr_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Ngan tinepe, motong la Yesu ipootoo di tooltool 72 mulu a ikap urata pang di, motong la ipatar di le di ru ru, inbe iwanga di bet timugu a tila pang ye malala maimai le malala kakase kapala yo lono bet ole ipa pang ye nga. ");
INSERT INTO apr_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Inbe iwete pang di nen, “Kaningi alunu kaiye la isullungu a iken kumu ngo, bong di tooltool ke urata yo bet tikap a tiwinnoko nga, ngan alunu tiap. Ngan nanga, ole kapatarau pang Tool Mai yo kumu taunu i, a bet nen ngan iwanga di tooltool ke urata sa mulu la tikap kaningi kanono a tiwinnoko. ");
INSERT INTO apr_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Ngan nen bet kala! Bong lomu tut, au i awangang a kala nga, ngan ole la kayei ben di sipsip natunu yo tinepe kataunu ye di gaunu gok nga. ");
INSERT INTO apr_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Bong ken lomu ru ye so kapala yo bet kakap ngan be. Le so ben pat le depe ke lonloningi, inbe loningi ke kemu ngan o ke bet kakap a kapa ye tiap. Inbe di tooltool yo bet katauarai di dada nga, ngan ken kakodo a kawete lo ponana kiang pang di be. ");
INSERT INTO apr_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","“Ye kene yo bet kapa le la pombe ye malala atu, le bet tikau ang a titarang ye rumu atu nga, ngan kulkulunu ngan ole kawete pang di tooltool yo tinepe ye rumu tani, ngan nen. Kayei ne, ‘Lo silene ke Maro iken yang.’ ");
INSERT INTO apr_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Le kumata bet tool dook mata ke lo silene sa bet inepe ye rumu in nga, ngan ole betanga kiang dook mata tani in la inepe ye. Bong kumata bet tool yo inepe ye rumu in tool dook mata ke lo silene tiap nga, ngan betanga dook mata kiang tani, in ole imulu a iman pang yang. ");
INSERT INTO apr_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Ngan nen le kanepe so ye rumu tani in, le ken kapa a kala ye rumu kapala be. Inbe kaningi le ran yo bet tikap pang nga ngan kapas le kakan be kayin leu, yesoo kumata le bet tool iyei urata nga, ngan la bet ikap so ye urata kootoonoo ki nga. ");
INSERT INTO apr_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","“Ye kene yo kapa le la pombe ye malala mai atu le bet di tooltool ki lodi ponana yang, inbe tikau ang nga, ngan kapas le kakan kaningi yo bet tikap pang ngan leu. ");
INSERT INTO apr_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Ngan urata yo bet kayeii ye malala tani in nen: kakarata di tooltool yo matamatenge ikap di nga, ngan le tinidi dook mata mulu, inbe kakaua bingi dook mata pang di a kayei ne, ‘Mooloo tiap, inbe dada yo Maro bet matan kala di tooltool ki ye i, in ole si pombe mallangana pang yang.’ ");
INSERT INTO apr_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Bong ye kene yo bet kapa le la pombe ye malala mai atu, le bet di tooltool ki lodi ponana yang inbe tikau ang tiap nga, ngan kadu kakodo dada katene ke malala tani, inbe kawete pang di nen, ");
INSERT INTO apr_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Gauru ke malala kiang yo ingaungau kemam nga, ngan la bet amtaurai mulu du tana nga, a nen ngan ipaposang ye dada dook tiap kiang yo kayeii pam i. Bong lomu galanga nen; mooloo tiap, inbe dada yo Maro bet matan kala di tooltool ki ye i, in ole si pombe mallangana.’ ");
INSERT INTO apr_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Awete pang nen, ye lal yo Maro itaru bet ikarata betanga kidi tooltool ye in nga, ngan ole iyemenai di tooltool ke malala tani in ye urata moonoo dook tiap ki taunu le illoso urata moonoo dook tiap yo bet pombe pang di tooltool ke malala mai Sodom i.” ");
INSERT INTO apr_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Motong la Yesu iwete mulu nen, “Atoo! Ang di tooltool ke malala mai Korasin le Betsaida nga, ken kakamatang dook leu. Nga yo bet tool sa ilo malala mai Taia le Saidon lo iyei mos yo dawa ben ayei ye malala kiang nga, ngan matin nga le di tooltool ke Taia le Saidon tiportak lodi mukot ye sennene kidi yo tiyei nga, inbe tiwit mala pirara a tiwurur kaua punu a bet nen ngan tipapos lo madoko kidi. ");
INSERT INTO apr_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Bong ye lal yo Maro itaru bet ikarata betanga kidi tooltool ye in nga, ngan ole iyemenai ang di tooltool ke Korasin le Betsaida ngan ye urata moonoo dook tiap ki taunu le ole illoso urata dook tiap masngana yo bet pombe pang di tooltool ke Taia le Saidon i. ");
INSERT INTO apr_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Inbe ang di tooltool ke malala mai Kapenam nga lomu tar balai, ole Maro iyitmakang le kalo meneng lang katene ni, too? Tiap yege! Ole ikatte ang kadu meneng lopo ni, ye ni kidi matenge.” ");
INSERT INTO apr_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Motong la Yesu iwete pang di galiunu tina ngan mulu nen, “Sei tool bet ilongo betanga kiang a itoo nga, ngan ye in itoo betanga kiau. E sei tool bet iwala murini pang nga, ngan ye in iwala murini pau lapau. E sei tool bet iwala murini pau nga, ngan ye in iwala murini pang Maro yo iwangau a asi i.” ");
INSERT INTO apr_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Tinepe a ke alunu iman a ila, motong la di tooltool 72 tina yo Yesu iwanga di a tila nga, ngan timulu a timan. Ngan lodi ponana kaiye ye urata kidi yo la tiyei nga, le nga man tigasa pang Yesu a tiyei ne, “Tool Mai, ampootoo em bet amnganga di so sidi ye nga, ngan le titoo koomam lapau.” ");
INSERT INTO apr_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Motong la Yesu iraua betanga kidi nen, “Akamata tool dook tiap, Satan, imol ke lang katene a isi dawa ben kili itai nga. ");
INSERT INTO apr_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Ngan kalongo. Au i awonai gurana kiau pang bet la kayirtoo di moto le di so ben dongo parangana bet tigarung di tooltool nga, inbe gurana kiang mai le kallos di koi kiang, le so sa yo ke bet igarungang, ngan tiap. ");
INSERT INTO apr_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Bong ken lomu ponana ye yo di so sidi tilongo betanga kiang a titoo koomu, ngan be. Bong bet nen ngan lomu ponana ye yo Maro iwodo emu ilo ye rau yo iken ye malala ki ni nga.” ");
INSERT INTO apr_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Ye kene tani in, Maro Amunu Silene ipapono Yesu le lon ponana kaiye, le nga iyei ne, “Tamak, ong in Tool Mai ke lang inbe tana. Le au i ayitmaka em, yesoo kutarkoo so tina ngan ye di tooltool yo di tapdi tikamata di ben lo galanga kidi mai mata nga, inbe kupapos pang di tooltool yo taukadi lo galanga a tinepe le dawa ben di kakase nga. Le moolmool Tamak, ong taum kutoo lom yo dook mata i, inbe kuyei so nen.” ");
INSERT INTO apr_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Motong la Yesu iwete pang di tooltool tina mulu nen, “So le imot nga Tamak la itar lo bek i. Ngan tool sa yo bet lon galanga ye Natunu, ngan tiap, bong Tamana yetaleu la lon galanga ye i. Inbe tool sa yo bet lon galanga ye Tamana, ngan tiap, bong Natunu yetaleu la lon galanga ye i. Inbe di tooltool yo Natunu lono bet ipitnaia Tamana pang di nga, ngan di leu la bet lodi galanga ye Tamana tani in nga.” ");
INSERT INTO apr_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Motong la Yesu iportak pang ye di galiunu a bet iwete pang di leu, ngan iwete nen, “Maro iyei urata dook mata pang ang tooltool yo kakamata so tina yo ayei nga. ");
INSERT INTO apr_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Awete pang nen, di tooltool kuto maimai yo matadi kala tana nga, ngan tiye di Maro koonoo yo ke mukot nga, ngan lodi bet tikamata so ben yo dookoot ngan ang kakamata nga, bong ngan le tikamata toko siap. Inbe lodi bet tilongo betanga ben yo dookoot ngan ang kalongo nga, bong ngan le tilongo toko siap lapau.” ");
INSERT INTO apr_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Motong la tool kuto mai atu yo lon galanga mata ye wer ke Maro i, in imadit lo ikodo a bet nen ngan itouo Yesu ye betanga. Le nga itoru nen, “Pannoongoo, nga ole ayei balai bet akaua nepongo dook mata yo taukan motingi i?” ");
INSERT INTO apr_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Motong la Yesu iraua torungu ki nen, “Rau yo tiwodo wer ke Maro ye i, in kukinkati ngan iwete balai?” ");
INSERT INTO apr_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Motong tool kuto mai tani in iraua betanga ke Yesu nen, “Wer ke Maro iwete nen, ‘Lomu pang Maro yo Tool Mai kiang i, in mai san, inbe kagaua lomu le tinimu ipa ye gurana le lo galanga kiang le imot panga.’ Inbe wer san yo itoo i, in nen, ‘Lom pang di diem mai san dawa ben yo ong taum lom pong mai san nga.’ ” ");
INSERT INTO apr_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Motong la Yesu iwete panga nen, “Ong in kuraua betanga kiau dook mata san. Le kumata bet kuyei nen nga, ngan la bet kouo nepongo dook mata yo takan motingi in nga.” ");
INSERT INTO apr_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Bong tool kuto mai tani ke wer ke Maro in lono nen, bet ye in ikapsap toko ye wer ke Maro siap, le nga itoro Yesu nen. Iyei ne, “Ai, ngan di sima diek kuwete ye di bet ayei dada nen pang di nga?” ");
INSERT INTO apr_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Motong la Yesu iraua betanga ki nen, “Ye kene atu ngan tool atu kidi Yuda ipa ke Yerusalem a bet idu pang Yeriko. Ngan di tooltool ke pinnau titokolani a tikap lonloningi ipa ye so ki le imot, inbe tirauu tirauu le dook tiap yege, le imata sap sila ikino dada katene, inbe tikoo a tila. ");
INSERT INTO apr_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Ye kene tani in tool atu ke paroranga so pang Maro itoo dada tani in a bet idu lapau, ngan ikamata. Le nga ipa gis ye la itoo dada gigini san a idu. ");
INSERT INTO apr_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Ngan gaongo leu, tool atu yo ipa ye rara ke Liwi in itoo dada tani a bet idu ngan ikamata tool tani yo ikenen dada katene nga, le nga ipa gis ye lapau la itoo dada gigini san a idu. ");
INSERT INTO apr_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Bong tool atu ke Samaria in itoo dada tani a bet isi ngan le si pombe ye ni yo tool tani in ikenen ye i, ngan ikamata yo imassingi a ikenen nga, le nga lono panga. ");
INSERT INTO apr_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Motong la ipa le ila potai ye la ikamata moonoongoo ki tina, le nga ititi ran medana ipa ye kai olip surunu ilo ye, inbe isarrak mala a ipau moonoongoo tina ye. Motong la ipamaditi a iyitmaki lo iwur asara ki ke solanga di tooltool yo ene donki in pono, inbe ipayira ye la itaru ye rumu atu kidi lowo, inbe yeru tinepe a matan kala. ");
INSERT INTO apr_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Tinepe a mongmongini ki, motong la ikap pat silba ru la ikap pang rumu taunu, inbe iwete panga nen, ‘Nga ole matam kala tool i dook, bong kumata bet kotte pat kiong sa mulu ye nga, ngan amulu a aman lo ngan bet kuwete pau a nen ngan arau pat kiong tina.’” ");
INSERT INTO apr_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Motong Yesu titoro tool kuto mai tani ke wer ke Maro in nen, “Ngan lom tar balai ye di tooltool tol tina nga? Sei tool ikamata tool tani yo di tooltool ke pinnau tirauu i, in le iyei ben ene moolmool i?” ");
INSERT INTO apr_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Motong la kuto mai ke wer tani in iraua betanga ke Yesu nen, “Tool yo lono panga le iloni dook mata i.” Motong la Yesu iyei ne, “Kula ngan kuyei dada gaongo leu nen pang di diem lapau.” ");
INSERT INTO apr_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Yesu iye di galiunu tina tipa a tila, ngan le la pombe ye malala atu. Ngan garup atu yo ene Mata i, in ikamata Yesu, le nga ikauu a ilo rumu ki. ");
INSERT INTO apr_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Ngan Mata tani in taini garup atu, ene la Madia i. Ye in ikamata Yesu nen nga, le nga iman iwur potai pang ye, inbe itar talngana a ilongo betanga ke soo so yo iwetewete ye nga. ");
INSERT INTO apr_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Bong Mata tani in itu ye dawaingi le karatanga kaningi yo bet tiye Yesu tikan nga, le nga ila la iwete pang Yesu nen, “Tool Mai, ngan lom pau yo taik i igegau a iman bet autaleu ayei urata mai nga lapau, too? Kuwete panga a iman man ilonau ye urata pa.” ");
INSERT INTO apr_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Bong ngan Tool Mai iraua betanga ki nen, “Mata, Mata, akamatong ngan lom madoko ye so matana matana alunu san. ");
INSERT INTO apr_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Bong so dook mata ataleu yo bet kakauu ngan ilonang i, in la taim Madia lono panga mai mata le ikauu oo. Le o ke bet takauu a takutaki ye tiap.” ");
INSERT INTO apr_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Ye kene atu in Yesu inepe ye ni atu, inbe ipatarau. Le nga ipatarau a imot, motong la di galiunu tina ngan atu iwete panga nen, “Tool Mai, kupatomonai am ye dada ke pataraungu dawa ben yo mugu ngan Yowan ipatomonai di galiunu nga.” ");
INSERT INTO apr_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Motong la Yesu iwete pang di nen, “Kene yo bet kapatarau ye in nga, ngan kawete nen. Kayei ne, ‘Tamamam, ampatarau pong nen, bet di tooltool nga le imot tiparanaia em, inbe kusi a si matam kalam am le imot. ");
INSERT INTO apr_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Inbe kaningi yo ke ke tina atu atu nga, ngan kop pam. ");
INSERT INTO apr_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Inbe kugiri sennene kiam, yesoo am nga ole amgiri sennene kidi diemam yo tiyei pam, ngan lapau. Inbe kupasongosongam le ken amkapsap ye dada dook tiap ke touanga be.’” ");
INSERT INTO apr_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Motong la Yesu iwete pang di mulu nen, “Ang tina ngan atu, bet bong kataunu lo ngan bet ila rumu ke tool ki la ipoongoo a iwete panga nen. Iyei ne, ‘Tool kiau, au i lok bet kop porong dukumu tol pau. ");
INSERT INTO apr_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Yesoo, tool kiau atu ipa ye dada mooloo la le man pombe rumu kiau nga. Bong ngan au i taukak kaningi yo bet akauu panga a ikani i.’ ");
INSERT INTO apr_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Motong la tool tani yo inepe rumu lono in iraua betanga ki nen, ‘Ai, ken kupadingau be. Ngan dada ke rumu in apamede le imede, inbe aye rimak le di natuk nga bet amken mata sa. Le o ke bet amadit a akap so pong tiap.’ ");
INSERT INTO apr_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Ngan awete pang nen, tool tani, in rumu tamana tani, in ye tool ki, bong le ke bet imadit a ikap porong panga tiap. Bong tina ene tani in taukan moomoonoo ye yo ipame torungu rumu tamana tani mata ye porong nga, le ole imadit a ikap so tina le imot panga. ");
INSERT INTO apr_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Le awete pang nen, kumata bet katoro Maro ye so bet ikap pang nga, ngan ole ikap pang. Inbe kumata le kasere so nga, ngan ole ilonang le kapusye. Inbe kumata bet kapitpiti dada nga, ngan Maro ole iso dada pang. ");
INSERT INTO apr_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Ngan nen, yesoo di tooltool le imot yo tipatarau a titoro Maro bet ikap so pang di nga, ngan ole tikap so tina. Inbe di tooltool le imot yo tisere so nga, ngan ole ilon di le tipusye. Inbe di tooltool le imot yo tipitpiti dada nga, ngan ole Maro iso dada pang di. ");
INSERT INTO apr_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Ngan ang di kakase tamadi ngan atu bet natunu itoru bet ikap i panga nga, ngan ole ikaua moto panga, too? Tiap! ");
INSERT INTO apr_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Too, bet natunu itoru bet ikaua man natunu katalungana panga nga, ngan ole ikaua dongo parangana panga, too? Tiap yege! ");
INSERT INTO apr_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Ngan ang di kakase tamadi ngan dada kiang yo kayei ngan dook tiap, bong lomu galanga ye dada yo bet kakap so dook mata leu pang di natumu a kalon di ye i. Ngan nanga, Tamamu yo inepe ye malala ki ete ni, in illosang ye dada dook mata ki yo iyei nga, le ole ikaua Amunu Silene pang di sima tooltool yo bet titoru ye nga.” ");
INSERT INTO apr_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Ngan tool atu in so sidi inepe ye a iyeii le koon moo ye betebetanga le ke bet iwetewete tiap. Motong la Yesu inganga so sidi tani in ye a ikoo le koon marra a iwetewete mulu. Ngan nen le di tooltool malala mai tikamata tina yo iwetewete mulu nga, le titakrai. ");
INSERT INTO apr_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Bong ngan di tooltool kapala tiyei ne, “Ai, tool in inganga di so sidi ye gurana ke tool kuto mai kidi so sidi yo ene Belsebul i.” ");
INSERT INTO apr_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Inbe di kapala ngan tikapge bet titouo Yesu, le nga titoru bet iyeie mos sa a iyei ben tarkilanga panga bet tikamata, a nen ngan lodi galanga ben gurana yo iyei urata ye nga, ngan ipa ye Maro. ");
INSERT INTO apr_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Ngan Yesu ikamata di tina yo lodi kaua urata nen nga, le nga iwete pang di nen, “Kumata bet di tooltool ke tana mai atu bet tiparpoto le tinepe ye budanga ru, inbe tipatoko nga, ngan ole di tapdi tigarung di. Inbe kumata bet rara atu yo tinepe ye rumu atu nga, ngan bet tiparpoto le tinepe ye budanga ru, inbe di tapdi tipatoko nga, ngan ole di le imot tilledi. ");
INSERT INTO apr_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Ngan gaongo leu ye Satan lapau. Kumata bet di tooltool ki bet tiparpoto le tinepe ye budanga ru, inbe di tapdi tipatoko nga, ngan ole Satan tani in ikodo le imede balai? Ngan awete nen, yesoo ang ngan kawete mur yau bet Belsebul la ikap gurana ki pau bet anganga di so sidi ye i. ");
INSERT INTO apr_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Ngan kumata betanga yo kawete ngan moolmool bet au i anganga di so sidi ye gurana ke Belsebul nga, ngan sei ilon di tooltool kiang a le tinganga di so sidi i? Belsebul tiap, too? Ngan nen le urata tina yo di tooltool kiang tina tiyei nen nga, ngan ipaposang ye betanga kiang yo kawete pau nga, ngan kallung ye. ");
INSERT INTO apr_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Bong kumata bet Maro ye taunu la ikaua gurana ki pau a anganga di so sidi ye in nga, ngan ole lomu galanga nen; dada yo Maro bet matan kala di tooltool ki ye i, in ye la pombe a iken mallangana pang i. ");
INSERT INTO apr_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Ngan tool turana bulbulini atu bet ipare dawa ki dook inbe ikodokala rumu ki nga, ngan ole so ki iken dook mata. ");
INSERT INTO apr_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Bong kumata bet tool san yo gurana ki mai mata le ke bet illoso ene i, in iman le irauu nga, ngan ole ikap dawa le so ki ke patokongo tina yo ikodokala rumu ki ye nga, inbe lo ikap so ke tool tani le imot a imalimi pang di diene. ");
INSERT INTO apr_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Sei tool yo itoo au tiap i, in dawa ben koi kiau. Inbe tool yo ilonau a bet aye amgaua di tooltool pang Maro tiap i, in dawa ben tool yo bet inganga di tooltool a tikoo ye Maro i.” ");
INSERT INTO apr_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Motong la Yesu iwete mulu nen, “Kumata so sidi bet ipas ye tool atu lono nga, ngan ole la ipa ye ni soorookoonoo a matan sarsarai ye ni dook mata yo bet inepe ye i. Bong kumata bet matan sarai le ikamata ni sa dook bet inepe ye tiap nga, ngan ole iyei ne, ‘Au i nga ole amulukala rumu kiau yo mugu ngan agege i.’ ");
INSERT INTO apr_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Ngan kene yo imulu a ila pombe ye in nga, ngan ikamata rumu tani in tisoraii le igalanga, inbe so yo iken rumu lono nga iken dook mata ye nene. ");
INSERT INTO apr_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Motong la so sidi tani in imulu la iwete pang di diene limi be ru yo tillosi ye geingi dada dook tiap nga, ngan bet tiyei ene a tiye tila pang ye rumu tani bet la tinepe ye. Awete pang nen, mugu ngan tool tani in nepongo ki ben dook tiap mata tiap, bong yo dookoot nga nepongo ki dook tiap le dook tiap ki taunu.” ");
INSERT INTO apr_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Ye kene tani yo Yesu iwetewete betanga tina ngan pang di nga, ngan di tooltool malala mai man tigaua lapau, le nga garup atu yo inepe kataunu ye di i, in iyiti koonoo inbe iyei ne, “Tinam yo ipasui ong inbe iyei borrenge yong le ong mai i, in ole Maro iyei urata dook mata panga le lon ponana.” ");
INSERT INTO apr_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Bong ngan Yesu iraua betanga ki nen, “Di tooltool yo titar talngadi dook a tilongo betanga ke Maro inbe titoo nga, ngan ole Maro iyei urata dook mata pang di le lodi ponana.” ");
INSERT INTO apr_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Di tooltool kapala mulu timanen man pompombe ye ni tani yo Yesu inepe ye i. Motong la Yesu iwete pang di nen, “Di tooltool yo dookoot tinepe nga, ngan di tooltool ke geingi dada dook tiap. Le kanakana nga, ngan titorau bet ayeie mos ke Maro sa a tikamata. Bong mos sa bet ayeii a tikamata tiap. Ole tikamata mos ataleu yo pombe ye Maro koonoo yo Yona, in leu. ");
INSERT INTO apr_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Mugu ngan di tooltool ke Ninibe tikamata so yo pombe pang ye Yona i, le iyei tarkilanga pang di ben ye in Maro iwanga pang di la ila nga. Ngan nen le so yo bet pombe pang ye Tool Moolmool ke Maro ngan ole iyei tarkilanga pang ang di tooltool yo dookoot kanepe ngan ben ye in Maro iwanga pang la isi nga. ");
INSERT INTO apr_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Ngan ye lal yo Maro itaru bet ikarata betanga kidi tooltool ye in nga, ngan garup ene mai atu yo inepe ye ni yo karaka ipa ye i, in ole ikodo dama ke Maro, inbe ipapos di tooltool yo ke dookoot nga, ye dada dook tiap kidi yo tiyei nga. Au i awete nen, yesoo garup tani, in inepe ke tana damono, bong ipa ye manga mooloo a ise pang Yerusalem bet se ilongo betanga dook mata ke Solomon yo ipatomonai di tooltool ye nga. Bong Tool atu yo dookoot kaye kanepe i, in illoso Solomon. ");
INSERT INTO apr_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Inbe ye lal tani yo Maro itaru bet ikarata betanga kidi tooltool ye in nga, ngan ole di tooltool ke Ninibe tikodo dama ke Maro, inbe tipapos di tooltool yo ke dookoot nga, ye dada dook tiap kidi yo tiyei nga. Awete nen nga, yesoo di Ninibe tilongo betanga ke Yona tina yo iwete nga, ngan le tiportak lodi mulu. Bong Tool atu yo dookoot kaye kanepe i, in illoso Yona.” ");
INSERT INTO apr_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Motong la Yesu iwete pang di mulu nen, “Tool sa ke bet ilanga sul ki bong, lo ngan bet itarkoo, too ipatudu ye bor, ngan tiap. Bong ole ipawoti lo ete, a bet nen ngan di tooltool bet tise rumu lono ki ngan tikamata ni ye lulngana. ");
INSERT INTO apr_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Ngan matamu ngan dawa ben sul kiang. Le kumata bet matamu igalanga dook mata nga, ngan ole sul lulngana ilangaraia tinimu mai i le imot inbe kakamata ni. Bong kumata bet matamu igalanga tiap nga, ngan ole todo iduku tinimu mai i le imot inbe kakamata ni tiap. ");
INSERT INTO apr_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Ngan nanga, ken kakamatang dook leu, ole nen ngan kawete bet sul lulngana iken lomu, bong tiap, todo iduku le imot. ");
INSERT INTO apr_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Bong kumata le bet sul lulngana tani in ilangaraia tinimu mai i le imot, le kasin pa iken todo lono tiap nga, ngan ole ilangarai ang dawa ben sul moolmool yo lulngana ilangarai ang i.” ");
INSERT INTO apr_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Yesu iwete nen pang di a imot, motong la tool Paresi atu in ikiuu bet la yeru tikan so rumu ki. Motong la ilo rumu ke Paresi tani in lono lo iwur moi pono potai pang ye kakawa ke kaningi so. ");
INSERT INTO apr_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Le nga Paresi tani in ikamata Yesu le itakrai ye yo itoo momo kidi Yuda ke ngasingi bedi in tiap, inbe ikan so nga. ");
INSERT INTO apr_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Motong la Tool Mai tani in iwete panga nen, “Ang Paresi nga, ngan bet kangas ruku le omai kiang ke kaningi so nga, ngan ole kangas diki ki leu. Bong lomu rru ye lono yo giri le giri leu, ngan tiap. Ngan dada kiang yo kayei nga, ngan gaongo leu. Ngan nen le kangas bemu, bong lomu nga ipon ye dada dook tiap yo ke sennene le pasakalanga so nga. ");
INSERT INTO apr_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Ang nga ben di tooltool kapakapa! Ngan tool yo bet ikarata so atu i, in ole ikarata diki ki le ipa ye lono lapau, too? ");
INSERT INTO apr_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Bong awete pang nen, so yo iken ruku lono nga, ngan kayoon a kakap pang di tooltool yo ballingadi tiap nga, a nen ngan kalon di ye. Ngan kumata le bet kayei nen nga, ngan ole Maro ikamata ngan lono dook mata pang ye dada kiang yo kayeii i. ");
INSERT INTO apr_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Atoo, ang di Paresi nga, ken kakamatang dook leu! Ang ngan kapoto so maitiap kiang yo ben laki le lombo le kudu ke kumu kiang nga, le iken ye budanga sangaul, motong la kakaua budanga atu pang Maro. Bong nga gelei bet kakarata betanga ke di diemu ye dada yo dook mata moolmool nga tiap, inbe lomu pang Maro mai san tiap lapau nga? Ngan kumata bet kayei dada yo dook mata nen nga, le ipa ye urata kiang tina yo kayei kanakana nga, ngan matin nga le dook mata san. ");
INSERT INTO apr_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Atoo, ang di Paresi nga, ken kakamatang dook leu! Ang ngan bet kalo ye rumu kidi Yuda ke gaongo in lono nga, ngan lomu bet le lo kawur dama ye kakawa kidi tooltool yo edi maimai nga. Inbe lomu bet la kapa ye ni ke yawaringi so, a nen ngan di tooltool bet tikamatang nga, ngan tiwete lo ponana kidi pang. ");
INSERT INTO apr_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","“Atoo, ken kakamatang dook leu! Ang ngan dawa ben gomo ke matenge yo iken tana lono le di tooltool lodi galanga ye tiap a tipa pono i.” ");
INSERT INTO apr_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Motong tool kuto mai atu ke wer ke Maro i, in iraua betanga ke Yesu nen, “Ona tiap! Pannoongoo, betanga kiong tina kuwete nga, ngan betanga medana leu le kugarungam ye lapau sa.” ");
INSERT INTO apr_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Motong la Yesu iwete panga nen, “Atoo, ang di kuto maimai ke wer ke Maro nga, ken kakamatang dook leu! Ang ngan kapaloko so moonoo alunu san ilo di tooltool podi le tisak ye solanga ki. Bong ang tapmu nga gelei lomu bet katara bemu boroborene atu la kalon di ye so moonoo tani yo tisola in tiap nga? ");
INSERT INTO apr_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","“Atoo, ken kakamatang dook leu! Ang ngan kakarata agoro ke matenge pang di Maro koonoo yo mugu ngan di sasa kiang tiraumatamata di nga. ");
INSERT INTO apr_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Ngan dada tina yo kayeii i, in ipaposang ben ang ngan lomu ponana yo di sasa kiang tiraumatamata di Maro koonoo a timmata nga, ngan la le lomu tut di a bet kakarata agoro kidi matenge pang di nga. ");
INSERT INTO apr_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Ye punu in la le Maro ye taunu itoo lo galanga ki a iwete nen, ‘Nga ole awanga di Maro koonoo inbe di aposol kiau a tila pang ye di, bong ole di tooltool tikamata di yo titoo au nga, le ole tigarung di kapala, inbe di kapala ngan tiraumatamata di le timmata.’ ");
INSERT INTO apr_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Ngan nen le ang tooltool yo dookoot kanepe nga, ngan ole Maro iyemenai ang ye di Maro koonoo tina yo karaumatamata di a rara kidi imati nga, yesoo bong ang ngan katoo dada kidi sasa kiang yo tiyei mugu nga. Ngan di sasa kiang tina ngan tiyei dada dook tiap nen ye kene tani yo Maro itara tana ye in le se dookoot nga. ");
INSERT INTO apr_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Le dada dook tiap tani in imadit ye kene yo Kaen iraumata Awel ye i, in le ise ye Sakaria yo di tooltool tiraumate kataunu ke bareme mai ke sungunu inbe pat gauningi ke paroranga so pang Maro ye i. Le moolmool, ang tooltool yo dookoot kanepe nga, ngan ole Maro iyemenai ang ye dada dook tiap le imot yo di sasa kiang tiyei nga. ");
INSERT INTO apr_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Atoo, ang di kuto maimai ke wer ke Maro nga, ken kakamatang dook leu! Ang ngan kawono kala dada ye di tooltool le ke bet lodi galanga ye Maro tiap. Ngan ang tapmu ngan katoo dada tani tiap, inbe kawono kala dada ye di tooltool kapala yo tikapge bet titoo dada tani in nga.” ");
INSERT INTO apr_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","54","Yesu iwete nen a imot, motong la igege di sila tinepe rumu lono, inbe ipas a idu tana. Ngan di kuto maimai ke wer ke Maro tina tiye di Paresi katedi malmal panga dook, le nga ye kene tani in tisere dada yo bet tiwete mur ye a tisopo koodi panga ye betanga i, inbe titoru ye torungu matana matana, a bet nen ngan tipalonga too, ole koon kapsap ye betanga sa bet tikan paseme ye, too tiap. ");
INSERT INTO apr_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Ye kene tani in di tooltool alunu le alunu san le ke bet takinkat di tiap ngan man tigaua a tiparlokoloko le kapala tikododo lo di diedi kedi pono. Motong la Yesu imadit tina le iwete pang di galiunu mugu nen, “Ken kakauwai yang dook leu ye yis kidi Paresi. Yesoo, dada dook tiap kidi yo ke kaplungunu in dawa ben so mai tiap tani yo tataru lo ye porong ngan iyeie porong a isung le imot i. ");
INSERT INTO apr_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Ngan so tina le imot yo di tooltool titarkoo a iken sollono nga, ngan pang dama ni ngan ole Maro ipapos se mallangana a bet nen ngan di tooltool tikamata. Inbe betanga yo titarkoo le di tooltool ke bet tilongo tiap nga, ngan ole ise mallangana le imot lapau a di tooltool lodi galanga ye. ");
INSERT INTO apr_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Ngan nanga, betanga tina yo katarkoo inbe kawetewete ye todo lono nga, ngan ole pombe mallangana le di tooltool tilongo. Inbe betanga yo kanepe rumu lono a ang tapmu kamangunngun ye lo talngamu nga, ngan ole du tikodo malala katene, inbe tikaua bingi ye pang di tooltool le imot a tilongo. ");
INSERT INTO apr_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Di tooltool kiau nga, awete pang nen, ken katattadai di tooltool yo bet tiraumatamatang, bong pang dama ni nga, ngan o ke bet tiyeie so sa mulu pang tiap nga, ngan be. ");
INSERT INTO apr_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Bong nga bet apaposo sei tool yo bet katattadaii i, in Maro. Yetaleu in la bet katattadaii i, yesoo kumata bet iraua tool atu le imata nga, ngan ye in gurana ki ke bet ikatte tool tani, in idu ye malala ke masngana. Le awete pang nen, ken katattadaia Maro leu. ");
INSERT INTO apr_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Kakamata, di man maimai tiap nga, ngan di tooltool tiyimi limi ye pat kooroonoo ru leu. Bong man tina ngan Maro ke bet lon kalli atu tiap. ");
INSERT INTO apr_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Ngan nanga, ken katattadai be, yesoo ang nga kallos di man yo maimai tiap nga le imot. Maro lon galanga yang dook mata san, le kinkatingi ke kutomu raunu nga, ngan lon galanga ye le imot lapau.” ");
INSERT INTO apr_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Yesu iwete mulu pang di nen, “Awete pang nen, sei tool bet iwetewete ek pang di tooltool la mallangana bet ye in au galiuk nga, ngan Tool Moolmool ke Maro lapau, ole iwete ene pang di bangabangana ke Maro bet ye in galiuk moolmool. ");
INSERT INTO apr_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Bong sei tool bet ipataukala ek ye di tooltool bet ye in galiuk tiap i, in ole Tool Moolmool ke Maro ipataukala ene ye di bangabangana ke Maro bet tool in galiuk tiap lapau. ");
INSERT INTO apr_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Sei tool bet iwete mur ye Tool Moolmool ke Maro nga, ngan Maro ole igiri sennene ki. Bong sei tool bet ikan paseme Maro Amunu Silene ye betanga dook tiap nga, ngan Maro o ke bet igiri sennene ki pitiap yege. ");
INSERT INTO apr_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Ngan ye kene yo tikau ang bet kalo rumu kidi Yuda ke gaongo in lono a bet lo kakodo dama kidi kuto maimai yo matadi kala di Yuda, ngan ken lomu madoko ye betanga yo bet kawete a karau betanga kidi ye, ngan be. Too, bet tikau ang lo kakodo dama kidi tooltool edi maimai nga, ngan ken lomu madoko ye dada yo bet karau betanga kidi ye, ngan be. ");
INSERT INTO apr_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Yesoo ye kene tani in Maro Amunu Silene ole ipasongosongang ye betanga yo bet kawete nga.” ");
INSERT INTO apr_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Motong la di tooltool malala mai tina, ngan atu imadit le iwete pang Yesu nen, “Pannoongoo, au i tamak imata oo. Le lok bet kuwete pang took mai i a ipoto so yo ke tamamam nga, le kapala panga, inbe kapala pau.” ");
INSERT INTO apr_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Bong ngan Yesu iwete panga nen, “Tool kiau, ngan sei itarau bet ayei tool mai, inbe akarata betanga kiang angru, a bet nen ngan apoto so kiang i?” ");
INSERT INTO apr_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Motong la Yesu iwete pang di tooltool malala mai tina nen, “Ken kakamatang dook leu! Bet tiap nga, ngan ole so matana matana ke tana i ikap matamu. Ngan kumata bet so kiang alunu mata nga, ngan ole so tina ngan ilonang balai bet kanepe ye nepongo dook mata nga?” ");
INSERT INTO apr_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Motong la Yesu ikatte betanga atu pang di nen, “Tool ballingana atu in ipe so du kumu ki, ngan ipu le itar kanono alunu kaiye. ");
INSERT INTO apr_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Le nga ye taunu lon wetewete nen, ‘Nga ole ayei balai? Au i, badabada kiau sa lono koonoo ke bet akap kaningi kiau tina ngan man atar lo lono, ngan tiap.’ ");
INSERT INTO apr_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Motong la iyei ne, ‘Urata yo bet ayeii i, in nen. Ole asaua badabada kiau nga, inbe are mulu le maimai dook, a nen ngan atar kaningi kiau le imot ye kapala, inbe so kiau ye kapala. ");
INSERT INTO apr_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Lo ngan bet au tauk awete pau nen, “Dookoot nga la so kiau alunu san le ole iken kaiye ye rai alunu nga. Ngan nanga, dookoot nga ole amaryoo a awur leu, inbe kanakana ngan ole lok ponana a akan be ayin leu.” ’ ");
INSERT INTO apr_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","“Bong ngan Maro iwete panga nen, ‘Barau, ong i tool kapa moolmool sa. Ye bong yo katai i, ngan ole kumata. Lo ngan bet so tina le imot yo kuwinnoko pong ong taum nga, ngan ole sei bet ikap i?’” ");
INSERT INTO apr_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Motong la Yesu iyei ne, “Ngan so yo nen nga, ngan ole pombe pang ye di tooltool yo lodi pang so ke Maro tiap, inbe lodi bet tigaua so yo ke tana nga a bet nen ngan ballingadi ye nga. Bong ye balingi le so kidi tina nga, ngan Maro ikamata di ye ngan tinepe dawa ben di tooltool ballingadi tiap.” ");
INSERT INTO apr_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Motong la Yesu iportak pang ye di galiunu tina, inbe iyei ne, “Le nga bet awete pang nen, ken lomu madoko ye nepongo kiang ke tana i, ye so yo bet kakap a kakan, nga be. Inbe ken lomu madoko ye tinimu ye so yo bet kawit a itarkoo tinimu, nga be. ");
INSERT INTO apr_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Yesoo, ye Maro matana nga, ngan nepongo kiang, in so maiyoko, bong so yo bet kakap a kakan, in so mai tiap. Inbe tinimu nga lapau, ngan illoso so yo bet kawit a katarkoo ye nga. ");
INSERT INTO apr_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Kakamata di man yo balu nga. Di ngan tikapgi so kumu le itar kanono, lo ngan bet lo tigogo kanono, ngan tiap. Inbe di ngan ke bet tire rumu too badabada yo bet titar kaningi kidi ye nga, ngan tiap lapau. Bong Maro ye taunu la ipakan di i. Le awete pang nen, ang di tooltool nga, Maro ikamatang ben ang nga kallos di man ye matana. ");
INSERT INTO apr_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Ngan nanga, bet ang tina ngan atu lon madoko ye so yo bet iloni ye nepongo ki ke tana i nga, ngan ole gelei, urata tani yo iyeii nen i, in ole iloni ye nepongo ki a iseke kasin pang dama a ila, too? O tiap! ");
INSERT INTO apr_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Ngan so maitiap yo nen ngan ke bet kayei tiap nga, ngan gelei a lomu madoko mata ye so matana matana kapala nga? ");
INSERT INTO apr_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“Oo, kakamata di ool yo tisup nga. Di tapdi ngan tiyei toko urata sa bet tikarata moro pang di ye, ngan tiap. Bong nga bet awete pang ye tool kuto mai yo Solomon i. Ye in tool ballingana, le moro ki yo itar lo tinini nga, ngan dook mata san. Bong di ool tina nga, ngan moro kidi ngan dook mata le dook mata ki taunu le illos moro yo ke Solomon nga. ");
INSERT INTO apr_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Atoo, ang nga katara lomu medana pang Maro mai mata tiap. Kakamata, dingding sorok yo ke bet tikodo katai nga leu, e mongmong ngan tisaput a tikatte lo ei ikan di nga, ngan Maro ikap moro dook mata pang di. Le gelei, ang nga o ke bet ikap moro dook mata pang tiap, too? O tiap! Dada dook mata yo bet iyei pang ngan ole illos dada dook mata yo iyei pang di ool le dingding nga. ");
INSERT INTO apr_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Ngan nanga, ken lomu kap gogo urata matana matana a lomu madoko ye so yo bet kakan le kayin nga be. ");
INSERT INTO apr_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Yesoo, di tooltool ke tana i yo lodi galanga ye Maro tiap nga, ngan lodi kap gogo dada bet tikap so yo nen nga. Bong ang nga ken kayei nen be, yesoo Tamamu in lon galanga ye soo so kamaka ye, ngan oo. ");
INSERT INTO apr_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Bet nen ngan dada dook mata yo bet kayeii i, in nen. Kakau ang pang Maro a matan kalang ben ang ngan di tooltool ki. Ngan kumata le bet kayei nen nga, ngan ole ikap so tina nga le imot pang. ");
INSERT INTO apr_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Ang nga ben di asara yo edi sipsip nga, ngan budanga maitiap atu. Bong ken katattadai be, yesoo Tamamu in lon ponana bet ole ikau ang lo kagaua ye di tooltool yo bet matan kala di nga. ");
INSERT INTO apr_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Le bet nen ngan kayawar so kiang nga pang di tooltool a tiyimi, a nen ngan kakap pat ki a kalon di tooltool yo ballingadi tiap nga. Kumata le bet kayei dada dook mata nen nga, ngan balingi dook mata yo bet Maro ikap pang ye urata kootoonoo kiang nga, ngan la iken ye malala ki ngo. Ngan balingi tina, ngan ole iken dook dawa ben katar lo ye depe medana ke tarungu pat yo ke bet imin tiap i. Le ke bet ilene tiap, inbe di tooltool ke pinnau ke bet tipinau tiap, inbe di rapa ke bet tigarungu tiap lapau. ");
INSERT INTO apr_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Ngan ye ni tani yo so dook mata kiang iken ye i, in ole kagaua lomu le imot pang ye lapau.” ");
INSERT INTO apr_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Motong la Yesu iwete pang di mulu nen, “Kakaratang bet kayei urata pau nga, ngan kawit mala kiang dook le imede, inbe kalanga sul kiang a ilolo. ");
INSERT INTO apr_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Le kayei ben di tooltool kapraingi yo tinam a titar matadi ye tool mai kidi yo ila ye kaningi ke kerenge i. Ye kene yo bet imulu a iman le bet ipitpiti dada nga, ngan le palbe leu be tiso dada panga. ");
INSERT INTO apr_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Kumata le tool mai tani in imulu a iman le bet ikamata di kapraingi ki tina ngan matadi rere go nga, ngan ke bet lodi ponana dook. Awete pang moolmool nen, tool mai tani in ole lon ponana ye di kapraingi ki tina, le ole ye taunu iwiti mala ki le imede, inbe iwete pang di a tiwur le tiwakaia kakawa ke kaningi so, inbe irai so pang di a tikan. ");
INSERT INTO apr_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Ngan kumata bet tool tani in imulu bong kataunu, too pang malama tareke ipadu tamoto, le bet ikamata di kapraingi ki bet matadi rere go nga, ngan ole di kapraingi ki tina ngan lodi ponana. ");
INSERT INTO apr_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Bong ole lomu galanga nen. Kumata bet rumu taunu in lon galanga ye soo lal yo tool ke pinnau in itaru bet man isaua rumu ki ye in nga, ngan ole ikodokala rumu ki, a bet nen ngan tool ke pinnau o ke bet isaua rumu ki a ilo lono tiap. ");
INSERT INTO apr_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Ngan nanga, ang nga lapau kakaratang dook, lo ngan bet kanepe, yesoo Tool Moolmool ke Maro ole isi ipatakrai ang ye lal atu yo ang nga lomu tar bet o isi ye tiap i.” ");
INSERT INTO apr_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Motong Pita itoro Yesu nen, “Tool Mai, nga bet atorong ye betanga yo kotte pam i. Ngan kuweta pam leu, too kuweta pam amye di tooltool nga le imot?” ");
INSERT INTO apr_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Motong la Tool Mai iraua betanga ki nen, “Tool mai yo bet ipa ye panga mooloo, in ole itara tool balai bet matan kala so ki, inbe ikap kaningi pang di kapraingi ki kapala ye lal tani yo itaru panga i? Ye in ole ikamata di kapraingi ki tina ngan atu yo lon galanga ye urata inbe itoo betanga ki dook mata i, in la bet itaru i. ");
INSERT INTO apr_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Le kumata bet kapraingi tani in iyei urata dook mata nen leu, le bet tool mai ki imulu a iman pombe le ikamata urata tina yo iyei nga, ngan kapraingi tani in ke bet lon ponana. ");
INSERT INTO apr_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Awete pang moolmool nen, tool mai ki ole itaru le iyei kuto mai a bet matan kala so ki nga le imot. ");
INSERT INTO apr_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Bong kumata bet kapraingi tani in ye taunu lon wete nen, ‘Tiap. Tool mai kiau ni ngo ipa ye panga mooloo le o iman tarrai tiap,’ le nga imadit tina ngan le irau sorok di kapraingi kapala yo tamoto le garup nga, inbe ikan le iyin ran medana a kuton moo ye. ");
INSERT INTO apr_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Ngan ole tool mai ki imulu a iman ipatakraii ye ke atu yo kapraingi ki tani in lon tar bet o iman ye tiap i, inbe ye ke matana yo lon galanga ye tiap i. Le kumata bet tool mai ki tani in iman ikamata yo iyei nen nga, ngan ole isaputputu le morrana, inbe ikatte du ye di tooltool yo titara lodi medana tiap nga. ");
INSERT INTO apr_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Tool kapraingi yo bet lon galanga dook ye tool mai ki in lono, bong ipare tiap, inbe iyei soo so yo tool mai ki lono bet iyei, ngan tiap nga, ngan ole tool mai ki tani in irauu le gurana. ");
INSERT INTO apr_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Bong tool kapraingi yo lon galanga ye tool mai ki tani in lono tiap, inbe iyei urata dook tiap yo ke bet ikaua koro ye nga, ngan ole tool mai ki irauu mosmos leu. Le di tooltool yo Maro ikap so alunu pang di nga, ngan ole iwete pang di bet tipamulu so alunu tina ngan panga mulu. Kumata bet di tooltool tikap so alunu pang tool atu a titar lo bene nga, ngan ole titoro tool tani bet ipamulu so alunu san pang di.” ");
INSERT INTO apr_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Motong la Yesu iwete mulu nen, “Au i asi nga bet si apata ei ye tana i. Le au i lok nen, bet ei i ilolo a bet nen ngan ikan tarrai so. ");
INSERT INTO apr_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Bong dookoot nga urata dook tiap masngana ole pombe pang yau, le au i lok moo mai san, le ole anepe nen le talo ye lal yo bet masngana tani in imot ye i. ");
INSERT INTO apr_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Ngan lomu tarau bet asi tana i nga, ngan bet si agauagaua di tooltool a tinepe ye lo silene, too? Tiap yege! Awete pang nen, au i asi nga bet si agelpoto di tooltool. ");
INSERT INTO apr_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Le dookoot katai a ilo nga, ngan di tooltool limi ngan di rara atu, bong di tooltool tina ngan tiparpoto le tinepe ye budanga ru. Le di tol yo tinepe ye budanga atu nga, ngan ole tikadon di yo ru nga. Inbe di ru yo tinepe ye budanga san nga, ole tikadon di yo tol nga. ");
INSERT INTO apr_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Di ngan ole tiparpoto le tinepe kidi kidi nen, le kase tamoto in ole tamana ikadoni, inbe ye lapau ole ikadono tamana. Inbe kase garup in ole tinana ikadoni, inbe ye lapau ole ikadono tinana. Inbe tool kase tamoto tani in tinana ole ikadono natunu tamoto tani in rimana, inbe garup tani lapau, in ole ikadono roonoo garup tani.” ");
INSERT INTO apr_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Motong la Yesu iwete pang di tooltool malala mai tina ngan nen, “Kumata bet kakamata eng tene itun ke yoro punu nga, ngan ole pattu leu be kawete ne, ‘Nga bet ki imol.’ Ngan ole ki imol moolmool. ");
INSERT INTO apr_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","E bet kakamata karaka ipa le dongana popobe nga, ngan ole kayei ne, ‘Nga bet rai mai a ke isini.’ Ngan ole ke isini moolmool. ");
INSERT INTO apr_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Awete pang nen, ang nga di tooltool ke kaplungunu sa. Ang nga kakamata so yo ke lang le tana nga, ngan lomu galanga dook ye so yo bet pombe nga, bong nga gelei a kakamata so yo dookoot Maro iyei a pompombe nga, bong lomu galanga ye tiap nga?” ");
INSERT INTO apr_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Motong la Yesu iwete mulu pang di nen, “Nga gelei bet ang tapmu nga matamu too dada le noonoongoo dook mata yo bet kayei, ngan tiap nga? ");
INSERT INTO apr_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Kumata bet koi kiong ikau ong bet kala pang ye tool kuto mai ke karatanga betanga nga, ngan kene yo bet angru kapa dada go nga, ngan kutor tomonaii a bet nen ngan angru kakarata betanga a kaparsogorai inbe kagau lomu mulu. Ngan kumata le bet kuyei nen tiap nga, ngan ole iyolong kulo ye tool ke karatanga betanga, lo ngan bet tool ke karatanga betanga tani in itarong kulo ye gaunu ki bene, a nen ngan itarong kulo ye rumu dook tiap kidi talnga dikidiki lono. ");
INSERT INTO apr_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Awete pong nen, taukam dada yo bet kupas a kusi tana ye i. Bong ole kunepe so rumu dook tiap kidi talnga dikidiki tani in lono, le lo kuyimi porai pat pi yo titar pong bet kuyimi rumu tani in ye nga, ngan le imot, ngan la bet kusi tana nga.” ");
INSERT INTO apr_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Yesu iwetewete pang di a imot, motong la di tooltool pattu yo titar talngadi ye betanga ki nga, ngan tigasa panga ye Pailot yo iwanga di tooltool ki ke patokongo la tiraumata di tooltool ke Galili pattu nga. Ngan ye kene tani in bet tiparoro so pang Maro lapau. Ngan nen le rara kidi imati a idu igaua pa ye rara kidi asara tina yo bet tiyei paroranga ye pang Maro nga. ");
INSERT INTO apr_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Motong la Yesu iraua betanga kidi nen, “Lomu balai ye di tooltool ke Galili tina yo tiraumata di a timmata nga, ngan di tooltool dook tiap ke geingi sennene le tillos di tooltool kapala yo ke Galili, ngan la tiyei dada nen pang di nga, too? ");
INSERT INTO apr_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Tiap! Bong awete pobe pang nen, kumata bet kaportak lomu mulu pang Maro tiap nga, ngan ole Maro igarungang gaongo leu dawa ben di tooltool ke Galili tina yo tiraumatamata di nga. ");
INSERT INTO apr_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Inbe lomu balai ye di tooltool sangaul inbe balana limi be tol ke Yerusalem yo rumu mooloo ke Siloam iduku du ikaltoo di a timmata nga? Ngan lomu tar bet di ngan tooltool dook tiap ke sennene le tillos di tooltool kapala yo tinepe Yerusalem nga, too? ");
INSERT INTO apr_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Tiap! Bong awete pobe pang nen, kumata bet kaportak lomu mulu pang Maro tiap nga, ngan ole Maro igarungang gaongo leu dawa ben di tooltool ke Yerusalem tina yo rumu iduku du irau di nga.” ");
INSERT INTO apr_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Motong la Yesu ikatte betanga atu mulu pang di nen, “Tool atu in ipe kai yo ene pik in ye kumu ki ke ooroo yo ene wain i. Motong ye kene atu ngan ila bet la matan sarai kai pik tani in kanono, bong ila ngan ikamata toko kanono siap. ");
INSERT INTO apr_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Motong la iwete pang tool ki yo itaru bet matan kala kumu ki i. Iyei ne, ‘Ai, ye rai tol ngan aman bet man matak so kai pik kanono, bong ipu tiap, le taukan kanono. Le ke bet ikodo nen a ikap sorok tana gorengana tiap. Le kutara a idu tana.’ ");
INSERT INTO apr_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","“Motong la tool tani yo matan kala kumu ki i, in iyei ne, ‘Tool mai, ngan dook mata, bong au i lok bet ikodo kasin ye rai atu mulu ngan, inbe akel tana ke punu ngo a atar asara tedi sa ilo punu, inbe takamata toka ngan. ");
INSERT INTO apr_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Kumata bet talo ye rai san pang dama i, le bet ipu a itar kanono nga, ngan o dook mata. Bong kumata bet ipu tiap nga, lo ngan bet kuwete a atara du tana.’” ");
INSERT INTO apr_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Lal kidi Yuda ke sungunu in pombe, le nga Yesu ilo rumu kidi Yuda ke gaongo in lono a lo ipatomonai di tooltool yo tigaua ye sungunu nga. ");
INSERT INTO apr_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Ngan garup atu yo inepe ye gaongo lapau i, in so sidi iyeii le matamatenge mai ikauu ye rai sangaul inbe balana limi be tol. Le udut turana ki ikoi le ke bet ipa tot tiap. ");
INSERT INTO apr_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Le nga Yesu ikamata, motong la koonoo panga a iman pang ye, man iwete panga nen, “Garup, matamatenge kiong in ole akaratong ye, ngan ole tinim dook mata mulu.” ");
INSERT INTO apr_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Motong la ipaloko bene lo garup tani in pono, ngan le pattu leu be ipadunu le lo ikodo tot le tina lon ponana, inbe iyitmaka Maro ene. ");
INSERT INTO apr_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Bong tool kuto mai yo matan kala rumu kidi Yuda ke gaongo i, in ikamata Yesu yo ikarata garup tani in ye lal kidi Yuda ke sungunu nga, le tina katen malmal dook. Motong la iman tina le iwete katkat pang di tooltool tina ngan nen, “Ai, ke yo ke urata nga, ngan limi be atu leu. Le lomu bet kaman bet man tool atu ikaratang ye matamatenge kiang a tinimu dook mata mulu nga, ngan kaman ye ke tina ngan. Bong kaman ye lal kidi Yuda ke sungunu bet man ikaratang ye matamatenge kiang be.” ");
INSERT INTO apr_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Motong la Tool Mai iraua betanga ki nen, “Ona tiap! Ang nga di tooltool ke kaplungunu sa. Ngan gelei bet ye lal kidi Yuda ke sungunu nga, ngan kala kapolo ooroo ye di asara kiang yo bulumakau le donki ngan ye rumu kidi, inbe kadede di bet du tiyin ran nga? ");
INSERT INTO apr_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Ngan garup i sasa ke Awaram, bong Satan igarungu le matamatenge ikauu ye rai sangaul inbe balana limi be tol oo. Ngan nanga, kumata lok bet aloni a agiri matamatenge tani in ye lal kidi Yuda ke sungunu nga, ngan ole gelei, bet ayei nen nga, ngan dook tiap, too?” ");
INSERT INTO apr_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Ye kene yo Yesu iwete pang di nen ye in nga, ngan le di koi ki moomoodi dook tiap yege. Bong di tooltool kapala ngan tikamata urata dook mata tina yo iyei nga, ngan le lodi ponana kaiye. ");
INSERT INTO apr_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Motong la Yesu iwete pang di mulu nen, “Dada yo Maro bet matan kala di tooltool ki ye i, in dawa ben soo so? Too, ole ananpootoo ye soo so, a nen ngan lomu galanga ye nga? ");
INSERT INTO apr_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Dada yo Maro bet matan kala di tooltool ki ye i, in dawa ben kai yo ene mastet, in patunu. Ngan tool atu ikaua mastet patunu tani in la ipe du kumu ki, ngan le isup le lo iyei ben kai somai. Inbe itar bene somaimai le di man yo tiro lang katene nga, ngan man tire giniu kidi ye a tinepe ye.” ");
INSERT INTO apr_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Motong la Yesu iwete pang di mulu nen, “Dada tani yo Maro bet matan kala di tooltool ki ye i, in ole ananpootoo ye soo so mulu? ");
INSERT INTO apr_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Nga ole ananpootoo ye yis yo tataru lo ye porong ngan iyeii a isung i. Garup atu ikaua so mai tiap tani a itaru ilo ye porong tina maiyoko in a ipargarungnaii ye, ngan le iyeie porong tani a isung le imot.” ");
INSERT INTO apr_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Motong la Yesu imadit mulu bet itoo dada a ilo pang Yerusalem nga, ngan le lo pombe ye malala maimai le malala kakase kapala yo ikenen dada nga, inbe ipatomonai di tooltool. ");
INSERT INTO apr_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Le nga tool atu itoru nen, “Tool Mai, ngan pang dama ni nga, ngan ole di tooltool kasin leu la bet Maro ikap di a ipamulu di ye so dook tiap tani yo bet igarung di i, too?” Motong la Yesu iyei ne, ");
INSERT INTO apr_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Awete pang nen, dada yo bet ilo pang ye malala ke Maro i, in mai tiap. Le guramu a bet nen ngan kapa ye dada tani in a kalo. Yesoo, di tooltool alunu kaiye la ole tikapge bet titoo dada tani in a tilo nga, bong o ke bet tilo tiap. ");
INSERT INTO apr_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Ngan pang dama ni ngan rumu taunu ole iman tina le itiukala dada, inbe kaman le man kakodo ke diki a kapitpiti dada, inbe kayei ne, ‘Tool Mai, kuso dada pam.’ “Bong ngan ole iraua betanga kiang nen, ‘Ang nga kapa ke ngai? Au i lok galanga yang pitiap yege.’ ");
INSERT INTO apr_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","“Lo ngan bet kawete panga nen, ‘Ona tiap! Am tina nga la kuman malala kiam man kupatomonai am inbe am yong tagauagaua ye kaningi le yinungu nga, e nga gelei bet lom sarrara yam nga?’ ");
INSERT INTO apr_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","“Bong ngan ole iwete pang nen, ‘Ang nga ke soo malala? Atoo, au i lok galanga yang pitiap yege. Ang nga di tooltool ke geingi dada dook tiap, le kakoo yau a kala!’ ");
INSERT INTO apr_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","“Ngan ole kala bet matamu lo ngan kakamata Awaram ye Esaka ye Yakop tiye di Maro koonoo yo ke mugu nga, ngan tilo tigaua di tooltool yo Maro bet matan kala di nga. Bong ang tapmu ngan ole tingangang a du kanepe diki, a bet nen ngan katangtang, inbe kakanen dongamu a iparrasa. ");
INSERT INTO apr_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Inbe di tooltool yo tipa ye ni mai le imot nga, ngan ole timan a tilo lo tiye di tooltool yo Maro bet matan kala di nga, ngan tigaua, inbe tiwur a tikan so. ");
INSERT INTO apr_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Ngan nanga, di tooltool yo dookoot ngan tikimur nga, ngan ole tise le lo timugu. E di tooltool yo dookoot ngan timugu nga, ngan ole tidu le du tikimur yege.” ");
INSERT INTO apr_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Ye kene tani in di Paresi pattu timan le man tiwete pang Yesu nen, “Ai, nga ole kugege ni, inbe kula pang ye ni sa mulu ngan, yesoo Erot ni ngo lono bet ole iraumatong a kumata.” ");
INSERT INTO apr_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Ngan Yesu iraua betanga kidi nen, “Kala kawete pang gaunu gok ni nen, ‘Katai inbe mongmong nga, ngan ole anganga di so sidi yo tinepe ye di tooltool nga, inbe akarata di tooltool yo matamatenge ikap di nga, le tinidi dook mata mulu. Le malama ngan la bet ayei porai urata kiau le imot nga.’ ");
INSERT INTO apr_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Bong katai inbe mongmong bet malama ngan ole apa le ikenen leu a alo pombe, yesoo ni sa mulu bet tiraumata Maro koonoo ye tiap. Ni ataleu yo bet tiraumate ye le imata i, in la Yerusalem ni.” ");
INSERT INTO apr_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Motong la Yesu tani in iparau nen, “Atoo, Yerusalem, Yerusalem, ong i la di tooltool kiong tiraumatamata di Maro koonoo a timmata, inbe tikap pat a tikatmatamata di tooltool yo Maro iwanga di a timala pang yong nga. Inbe ye lal alunu ngan au i lok bet agaua di tooltool kiong a tigaua le imot yau, dawa ben tareke tinana igaua di natunu a ipatud di ye balini nga. Bong di tooltool kiong lodi bet timan tigaua yau tiap. ");
INSERT INTO apr_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Le kutar talngam a kulongo, ole Maro igege bareme mai kiong ke sungunu tani a ilo, inbe bareme tani in sila iken sorok. Awete pong nen, dookoot nga o ke bet di tooltool kiong tikamatau mulu tiap, le ilo ye lal yo bet tiyei ne, ‘Maro kuyeie urata dook mata pang tool yo isi ye Tool Mai ene i.’ ” ");
INSERT INTO apr_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Ye kene atu in lal kidi Yuda ke sungunu in pombe, le nga Yesu ilo bet lo ikan so ye rumu ke tool kuto mai atu kidi Paresi nga, ngan di tooltool matadi ikenen ye bet tikamata ole iyeie so sa lapau, too tiap. ");
INSERT INTO apr_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Ngan tool atu yo tinin sarer i, in inepe potai pang ye Yesu lapau. ");
INSERT INTO apr_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Le nga Yesu ikamata tool tani, motong la itor di kuto maimai ke wer ke Maro tiye di Paresi nen, “Ai, nga bet atorang. Wer ke Maro iwete balai, bet takarata di tooltool yo matamatenge ikap di nga, ngan ye lal kidi Yuda ke sungunu lapau, too tiap?” ");
INSERT INTO apr_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Bong ngan tiwete toko betanga siap. Tipas le tipalongo leu. Le nga Yesu ipaloko bene lo ye tool tani in a ikarata ye matamatenge ki le tinini dook mata mulu, motong la iwete panga bet ila pang ni ki nga. ");
INSERT INTO apr_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Motong la Yesu iwete pang di mulu nen, “Kumata le ang tina ngan atu bet natunu, too asara ki yo bulumakau, in bet imol du ran kelingi atu lono ye lal kidi Yuda ke sungunu nga, ngan ole gelei, palbe leu be la kayit tarraii a ise ete mulu, too?” ");
INSERT INTO apr_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Ngan le tirau toko betanga ki pitiap yege. ");
INSERT INTO apr_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Ye kene tani in Yesu ikamata di tooltool yo tikiu di a tise rumu lono ye mailang tani in nga, ngan lodi bet lo tiwur ye kakawa yo bet di tooltool edi maimai ngan tiwur ye nga. Le nga ikatte betanga atu pang di nen, ");
INSERT INTO apr_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Kumata bet tool atu ikiu ong a kula ye mailang ke kerenge nga, ngan ken katem ro lo kuwur ye kakawa kidi tooltool yo edi maimai nga, ngan be. Yesoo, ole nen ngan bet mailang taunu tani in ipootoo tool san yo ene mai le illosong i, in ye la bet lo iwur ye kakawa tani i. ");
INSERT INTO apr_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Le kumata bet kuyei nen nga, ngan mailang taunu yo ikiu ang angru i, in ole man iwete pong nen, ‘Tool kiau, kumadit ye kakawa in a kuwi pang tool i a iwur ye.’ Ngan ole moomoom a kumadit le kukoo du kuwur meneng mur yege ni. ");
INSERT INTO apr_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Ngan nanga, kumata bet tool atu ikiu ong bet kula ye mailang ki nga, ngan kulo le lo kuwur ye kakawa yo ke mur nga, a bet nen ngan tool tani yo ikiu ong i, in iman le bet man ikamatong nga, ngan ole iwete pong nen. Iyei ne, ‘Atoo, tool kiau, kumadit a kulo le lo kuwur ye kakawa dook mata meneng ke dama ngo atu.’ Ngan kumata le bet iyei nen pong nga, ngan ole iyitmaka em la di diem kapala yo kuye di kalo ye mailang tani nga, ngan matadi. ");
INSERT INTO apr_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Awete pang nen, yesoo sei tool yo ye taunu iyitmaki le ilo ete i, in ole Maro itaru le idu lopo ni. Bong sei tool yo ye taunu itaru le idu lopo i, in ole Maro iyitmaki le ilo ete ni.” ");
INSERT INTO apr_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Motong la Yesu iwete pang Paresi tani yo ikiuu bet man ikan so rumu ki i, in nen, “Bet kukiu di tooltool a bet kuye di kakan so kemai, too rrai nga, ngan ken kukiu di tooltool kiong, too di taim le toom, too di rara kiong kapala, too di tooltool ballingadi yo tinepe potai yong, ngan be. Yesoo, kumata le bet kuyei nen nga, ngan pang dama ni nga, ngan ole di lapau tikiu ong ye kanningi kidi, inbe tirau kanningi kiong tina. ");
INSERT INTO apr_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Bong bet kuyeie kanningi kiong atu nga, ngan kukiu di tooltool yo ballingadi tiap nga, inbe di tooltool yo turadi ikalel nga, inbe di tooltool yo kedi dook tiap nga, inbe di tooltool yo matadi kisis nga. ");
INSERT INTO apr_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Di ngan o ke bet tiyeie kanningi sa bet tirau so kiong ye, ngan tiap. Bong Maro ole iyei urata dook mata pong, yesoo pang dama ni nga, ngan ye kene yo Maro bet ipamadit di tooltool noonoodi yo timmata koot ngan le timadit mulu ye ni ke matenge nga, ngan ole iraukol so kiong tina ngan pong.” ");
INSERT INTO apr_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Di tooltool tina yo tiye Yesu tiwur le tiwakaia kakawa ke kaningi so nga, ngan atu ilongo tina yo Yesu iwete nen nga, le nga iwete panga nen, “Di tooltool yo tilo bet lo tigaua ye di tooltool yo Maro bet matan kala di inbe tiye di tiwur bet tikana mailang tani nga, ngan Maro ole iyei urata dook mata pang di le lodi ponana.” ");
INSERT INTO apr_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Bong ngan Yesu iraua betanga ki nen, “Tool atu in iyeie mailang maiyoko, motong la ikiu di tooltool alunu la timan bet man tikana mailang ki tani in nga. ");
INSERT INTO apr_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Ye kene yo ikarata kaningi ke mailang tani in a imot, motong la iwanga kapraingi ki bet la iwete pang di tooltool yo ikiu di bet man tikana mailang tani ngan nen, ‘Ai, kaman a tala la kakan so. Kaningi ngo, amkarata a imot oo.’ ");
INSERT INTO apr_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","“Bong di tooltool tina ngan di le imot lodi bet tila ye mailang tani in tiap, le nga di atu atu tiwete lodi pang kapraingi tani. Le nga tool yo ila ye mugu in iwete panga nen, ‘Au i dookoot yege sa ayimi tana atu nga, le nga bet ala akamata. Le asogorai ong nen, o amala ye mailang in tiap.’ ");
INSERT INTO apr_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","“Inbe tool san in iwete panga nen, ‘Au i dookoot yege sa ayimi asara yo ene bulumakau ngan sangaul atu nga, le nga bet ala la ayei toko urata ye di. Le asogorai ong nen, o amala ye mailang in tiap.’ ");
INSERT INTO apr_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","“Inbe tool san mulu in iyei ne, ‘Au i dookoot yege sa akere paunu nga, le o ke bet amala ye mailang in tiap.’ ");
INSERT INTO apr_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Motong la kapraingi tani in ikap betanga kidi tooltool tina, ngan a imulu la iwete pang tool mai ki a ilongo, le katen malmal, le nga iwete pang kapraingi ki tani in nen. Iyei ne, ‘Oo, palbe kula la kutoo dada maimai inbe dada kapala ke malala mai i, le bet kupusye di tooltool yo ballingadi tiap nga, inbe di tooltool yo turadi ikalel nga, inbe di tooltool yo matadi kisis nga, inbe di tooltool yo kedi dook tiap nga, ngan kop di a timan rumu man tikana mailang kiau i.’ ");
INSERT INTO apr_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","“Ngan kapraingi tani in itoo tool mai ki koonoo, inbe la ikap di tooltool tina a timan rumu. Bong ikamata rumu ngan ipon tiap, le nga la iwete pang tool mai ki tani in nen, ‘Tool mai, kumata nga, atoo koom bet akap di tooltool tina a tise rumu, bong rumu lono mai la iken sorok go i.’ ");
INSERT INTO apr_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","“Motong la tool mai tani in iwete pang kapraingi ki nen, ‘Kupa le kukapusu malala mai i, inbe kudu kutoo dada kakase ngo, inbe la kudada koongoo ke kumu le bet kumata di tooltool sa nga, ngan kuwete le koom mede pang di a tise, a bet nen ngan rumu kiau i ipon dook ye di tooltool yo bet tikana mailang i nga. ");
INSERT INTO apr_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Awete pong nen, di tooltool yo akiu di mugu bet tise ye mailang kiau ngan le tise tiap nga, ngan o ke bet tikan toko kaningi naunu ke mailang i pitiap yege.’” ");
INSERT INTO apr_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Di tooltool malala mai san la titoo Yesu a tiye tipa nga. Le nga iportak bet iwete pang di nen, ");
INSERT INTO apr_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Kumata tool atu lono bet man itoo au, bong lono yo itaru pang tamana le tinana, inbe rimana le di natunu, inbe di lini le taini, inbe ye taunu nepongo ki in mai mata le illoso lono yo itaru pau in nga, ngan o ke bet iyei au galiuk tiap. ");
INSERT INTO apr_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Inbe sei tool yo lono bet isolo urata moonoo ben kai palasingi ki, a itoo au tiap i, in o ke bet iyei au galiuk tiap lapau. ");
INSERT INTO apr_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Ngan kumata tool atu lono bet ire rumu mooloo atu pang di tooltool yo itar di bet matadi kala kumu ki nga, ngan ole iwur inbe lon kaua urata dook ye pat pi yo bet iyimi renge ke rumu tani in ye nga. A nen ngan matan too, ole pat ki tina ngan ige renge ke rumu tina yo iyimi ngan bet ire ye le imot, too tiap. ");
INSERT INTO apr_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Kumata le iyei nen tiap, inbe ikel sawa a ipatokodo leu, inbe rumu tani in kanono o ke bet ire le imot tiap nga, ngan ole di tooltool tikamata urata ki nen, le tiyei sere ye a tingeleraii. ");
INSERT INTO apr_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Inbe ole tiwete nen, ‘Atoo, kakamata tool ni too, katen ro ye renge rumu ki ngan iyeisa ole ire le imot.’ ");
INSERT INTO apr_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Ngan gaongo leu, kumata tool kuto mai yo matan kala tana mai atu i, in lono bet la iye tool kuto mai san tipatoko nga, ngan o ke bet imadit tina le ila la yeru tipatoko tiap. Bong kulkulunu ngan ole iwur, inbe lon kaua urata dook ngan, yesoo ye taunu in tooltool ki ke patokongo ngan kinkatingi kidi ben 10,000 leu. E tool kuto mai san yo bet man ipamaditi patokongo i, in di tooltool ki ke patokongo ngan kinkatingi kidi ben 20,000. Ngan nen le tool kuto mai tani in ole lon wete nen, ‘Ai, bet amadit ye patokongo nga, ngan ole gurak le alloso kuto mai san ni ye patokongo i, too tiap?’ ");
INSERT INTO apr_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Ngan kumata bet tool kuto mai tani in lon kaua urata le lon tar bet o ke bet illosi tiap nga, ngan ye kene yo kuto mai san tani in inepe manga mooloo go nga, ngan ole iwanga di tooltool pattu a tila bet la tiwete silli kuto mai tani, a bet nen ngan lon sil inbe tikarata betanga ke patokongo tani le imot. ");
INSERT INTO apr_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Ngan gaongo leu, kumata ang tina ngan atu bet iwala murini pang so ki ke tana nga le imot tiap nga, ngan o ke bet iyei au galiuk tiap lapau.” ");
INSERT INTO apr_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Motong la Yesu iseke betanga ki mulu nen, “Tiek in so dook mata, bong kumata bet gurana ki imot nga, ngan ole kuyeie tiek tani in balai bet iyei tiek mulu nga? ");
INSERT INTO apr_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Ngan tiek yo taukan gurana nen i, in dook mata ke bet tatar lo ye asara tedi yo tigaun pang penge so, nga tiap, inbe o ke bet iyeie tana le gurana tiap lapau. Bong bet nen ngan takatte. Sei tool bet talngana ke longono betanga nga, ngan itar talngana dook a ilongo betanga kiau nga.” ");
INSERT INTO apr_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Ngan di tooltool ke sodaningi pat, inbe di tooltool kapala yo ke geingi sennene mata nga, ngan timan tigaua le tigaliui Yesu, inbe titar talngadi ye betanga ki. ");
INSERT INTO apr_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Le nga di Paresi tiye di pannoongoo ke wer ke Maro tikamata le tikap malmal panga a tiwete mur ye nen, “Ai, tool ni nga gelei a iye di tooltool ke geingi sennene tigauagaua, inbe iye di tikan so nga?” ");
INSERT INTO apr_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Motong la Yesu ikatte betanga atu pang di nen, ");
INSERT INTO apr_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Kumata le ang tina ngan atu asara ki yo edi sipsip ngan 100, bong bet atu ilene nga, ngan ole igege di sipsip ki yo 99 ngan sila tinepe sorok ye ni kidi yo bet tikanen ye i, inbe ila la ipa a isere tani yo ilene i le lo ipusye. ");
INSERT INTO apr_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Ye kene yo bet la isere sipsip ki tani ilene in le ipusye nga, ngan ole lon ponana kaiye le ole ikauu a itaru lo poopoonoo, inbe itaure a imulu a ila pang malala ki. ");
INSERT INTO apr_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Ngan ye kene yo ila pombe rumu ki nga, ngan ole ikiu di tooltool ki, inbe di tooltool yo tinepe potai ye rumu ki nga, ngan man tigaua, inbe iwete pang di nen, ‘Kaman a man ayang lod ponana, yesoo sipsip kiau atu yo ilene i, in apusye a akauu mulu oo.’” ");
INSERT INTO apr_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Motong la Yesu iyei ne, “Awete pang nen, lo ponana yo nen ngan gaongo leu ben yo iken ye malala ke Maro ngo. Kumata le tool atu ke geingi sennene bet iportaka lono pang Maro ye dada dook tiap ki yo iyei nga, ngan Maro iye di bangabangana ki ole lodi ponana ye mai san. Ngan moolmool, di tooltool yo 99 nga, ngan ole lodi ponana ye di lapau, bong o lodi ponana ye di mata tiap, yesoo di ngan tooltool noonoodi le taukadi urata yo bet tiportak lodi nga.” ");
INSERT INTO apr_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Motong la Yesu ikatte betanga san mulu pang di nen, “Kumata bet garup atu in pat ki silba sangaul atu, bong bet atu ilene rumu ki nga, ngan ole iyei balai? Ole ilanga sul ki a bet ikamata ni ye, inbe ikaua narong a isoraia rumu lono ki, inbe matan sarai dook le lo ipusye pat ki tani mulu. ");
INSERT INTO apr_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Ye kene yo bet isere pat ki tani ilene in le ipusye nga, ngan ole ikiu di tooltool ki, inbe di tooltool yo tinepe potai ye rumu ki nga, ngan man tigaua, inbe iwete pang di nen, ‘Kaman a man ayang lod ponana, yesoo pat kiau atu yo ilene i, in apusye a akauu mulu oo.’” ");
INSERT INTO apr_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Motong la Yesu iyei ne, “Awete pang nen, lo ponana yo nen ngan gaongo leu ben yo iken ye malala ke Maro ngo. Kumata le tool atu ke geingi sennene bet iportaka lono pang Maro ye dada dook tiap ki yo iyei nga, ngan Maro iye di bangabangana ki ole lodi ponana ye mai san.” ");
INSERT INTO apr_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Motong la Yesu ikatte betanga san mulu nen, “Tool atu in natunu tamoto ru. ");
INSERT INTO apr_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Ngan natunu tamoto yo kase in iwete pang tamana nen, ‘Tamak, au i lok bet kupoto so kiong nga le paru a nen ngan kop yo kiau ngan pau.’ Motong la tamadi ipoto so ki tina ngan le paru, inbe ikap pang di natunu. ");
INSERT INTO apr_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","“Le nga tinepe le mooloo tiap, inbe natunu kase tani in iyawar so ki tina ngan pang di tooltool a tiyimi bet ikap pat ye. Motong la ikap pat ki, inbe ila bet la inepe ye tana mai atu yo iken ni mooloo san i. Inbe igiri pat ki tina ngan ye dada dook tiap ki yo iyei nga. ");
INSERT INTO apr_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Ngan igiri pat ki tina ngan a imot, inbe pitolo maiyoko pombe ye tana mai tani yo inepe ye in le imot, le isere so yo bet ikani i. ");
INSERT INTO apr_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Le nga tool tani in ila la itoro malala taunu atu bet iyei urata panga. Ngan le tool ke malala tani in iwete panga bet la matan kala di ga ki, a nen ngan ipakan di. ");
INSERT INTO apr_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Ila, ngan ikamata ooroo puana kulini yo di ga tikan nga, ngan lono bet ikap a ikan lapau, yesoo bong tool sa ikap kaningi panga bet ikan tiap. ");
INSERT INTO apr_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","“Motong la se lon tut, le nga ye taunu lon wetewete nen, ‘Tiap, di kapraingi ke tamak le imot ngo kaningi kidi alunu san bet tikan, bong au naii aman anepe sorok ni, ngan la le bet amata ye pitolo nga! ");
INSERT INTO apr_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Le nga, ole amulu a ala pang ye tamak, la awete panga nen, “Tamak, au i ayei dada dook tiap ke sennene ye Maro matana, inbe ye ong taum matam lapau. ");
INSERT INTO apr_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Le dookoot nga, au i tool dook tiap le ke bet kukiu au ye natum mulu tiap, bong bet nen ngan kutarau le ayei urata ben kapraingi kiong nga.” ’ ");
INSERT INTO apr_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Motong la imadit a ipa mulu pang ye tamana a ila. “Bong ngan kene yo ipa manga mooloo go nga, ngan tamana ikamata a ikilla, le lono panga mai san. Le imadit tina le idada a ila le la iwarra a lon ponana ye, inbe isomo pangana. ");
INSERT INTO apr_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","“Motong la natunu tani in iwete panga nen, ‘Tamak, au i ayei dada dook tiap ke sennene ye Maro matana inbe ye ong taum matam lapau. Le dookoot nga, au i tool dook tiap le ke bet kukiu au ye natum mulu tiap.’ ");
INSERT INTO apr_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","“Bong ngan tamana ikiu di kapraingi ki a timan man iwete pang di nen, ‘Oo, palbe be kalo kakaua sousoungu kiau mooloo ni si kasousouo natuk i ye, inbe katara padodo lo ye bene boroborene, inbe kakap loningi ke kede panga a iparir. ");
INSERT INTO apr_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Lo ngan bet kala la kakaua asara yo ene bulumakau in natunu yo itup belebele ni, man karaumate, inbe kayeie mailang a takani, inbe lod ponana, ");
INSERT INTO apr_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","yesoo natuk i ben imata oo, motong la imagur mulu nga. Ye in ila a la ilene oo, motong la man tapusye a takauu mulu nga.’ Motong la tiyeie mailang tani a tikanen ye, inbe lodi ponana. ");
INSERT INTO apr_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Ye kene tani in natunu yo mai i, in inepe kumu. Le nga imulu a iman potai pang ye rumu, ngan ilongo tina yo tipodo pari a tiwou, inbe tisiki nga. ");
INSERT INTO apr_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Motong la koonoo pang kapraingi ke tamana tina ngan atu a isi le si itoru nen, ‘Ai, di tooltool ngo tiyeie soo so?’ ");
INSERT INTO apr_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","“Ngan kapraingi tani iwete panga nen, ‘Taim tani in imulu a iman oo, ngan la le tamam iraumata bulumakau natunu atu yo itup belebele i, in ye, yesoo tamam lon ponana ye yo ikamata taim ipa dook mata le man pombe mulu nga.’ ");
INSERT INTO apr_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","“Ngan natunu yo mai in ilongo betanga nen, le nga katen malmal le lono bet ilo rumu lono tiap. Motong la tamana ipas a idu tana bet du iwete silli, inbe ikarata betanga panga. ");
INSERT INTO apr_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Bong ngan iraua betanga ke tamana nen, ‘Kumata, au i aru tanepe ye rai alunu san, le ayei urata ben poranga kiong. Inbe kuwete pau ye urata le so nga, ngan arau koom, too asak noonoongoo kiong tiap lapau. Bong lom bet kouo asara maitiap atu ben meme natunu in pau a araumate, a nen ngan aye di tooltool kiau amkani, inbe lomam ponana ye, ngan tiap sa. ");
INSERT INTO apr_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Bong yeiso bet natum yo iyau so kiong la igiri ye di garup lekelekedi le imot i, in imulu a iman, ngan le lom ponana, inbe kuraumata bulumakau natunu yo itup belebele in ye sa.’ ");
INSERT INTO apr_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","“Motong la tamana iwete panga nen, ‘Alei, natuk! Ong in kanakana ngan aru tanepe le so kiau le imot nga, nga so kiong. ");
INSERT INTO apr_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Bong dookoot katai nga, ngan idi le imot bet lodo dook mata inbe lodo ponana, yesoo taim i ben imata oo, motong la imagur mulu nga. Ye in ila a la ilene oo, motong la man tapusye a takauu mulu nga.’” ");
INSERT INTO apr_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Yesu iwete pang di galiunu nen, “Tool ballingana atu, in itara tool ki atu bet matan kala so ki. Motong la di tooltool pattu man tisopo koodi pang tool ballingana tani in nen, ‘Ai, tool kiong yo kutaru bet matan kala so kiong i, in igarung so kiong dook.’ ");
INSERT INTO apr_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Motong la ikiui tool ki tani in man iwete panga nen, ‘Au i alongo betanga atu yong ben ong i matam kala so kiau dook tiap. Le ole kukarata rau a kuwete nin pat pi yo matam kala so kiau ngan kuyei urata ye nga, yesoo ong in o ke bet kuyei mai a matam kala so kiau mulu tiap.’ ");
INSERT INTO apr_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","“Motong la tool tani ye taunu lon wetewete nen, ‘Atoo, dookoot nga au i ole ayei balai na? Tool mai kiau i nga bet ingangau ye urata sa. Ngan au i taukak gurak yo bet ayup kumu nga. Inbe moomook lapau yo bet ator di tooltool kapala a tilonau ye pat le so nga. ");
INSERT INTO apr_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Oo, dookoot nga au i lok galanga ye soo so yo bet ayeii i, a bet nen ngan di tooltool bet tikamatau nga, ngan ole lodi ponana yau inbe tikiu au a alo rumu kidi ye kene yo bet tool mai kiau ingangau ye urata ki i.’ ");
INSERT INTO apr_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","“Motong la ikiu di tooltool atu atu yo bun kidi ikenen go ye tool mai ki tani nga, ngan a timan pang ye. Le nga tool tina ngan atu yo imugu a iman i, in itoru nen, ‘Ai, so pi kop ye tool mai kiau a iyei bun pong nga?’ ");
INSERT INTO apr_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","“Ngan tool tani iyei ne, ‘Akap kai yo ene olip, in surunu yo tipaling lo ye bor maimai nga, ngan kinkatingi ki 100.’ “Motong la tool tani yo ke bet matan kala so i, in iwete panga, ‘Oo, palbe kuwur tarrai nin, inbe kouo rau kiong yo tiwodo bun kiong ye i, inbe kudik wodenge ke kinkatingi ki ngan mulu le isi ye 50 leu.’ ");
INSERT INTO apr_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","“Motong la tool san mulu iman pang ye ngan man itoru nen, ‘Ong in, so pi kop a iyei bun pong nga?’ “Ngan tool tani iyei ne, ‘Akap dingding patunu ke kaningi yo tipadid ilo ye karei nga, ngan kinkatingi ki 100.’ “Motong la tool yo ke bet matan kala so i, in iwete panga nen, ‘Kouo rau kiong yo tiwodo bun kiong ye i, inbe kudik wodenge ke kinkatingi ki ngan mulu le isi ye 80 leu.’ ");
INSERT INTO apr_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Le nga tool mai ke tool tani yo matan kala so ki dook tiap i, in ilongo betanga ye urata tina yo tool ki tani in iyei nga, le nga ipayiti ye, yesoo tool in iyei urata dook tiap, bong le iyei dada dook mata yo bet ye taunu iloni ye i. Le moolmool, di tooltool yo ke tana i nga, ngan lodi galanga dook mata ye dada matana matana yo bet tiyei urata ke tana i ye nga, le tillos di tooltool ke Maro yo tinepe ye lulngana nga. ");
INSERT INTO apr_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Awete pang nen, balingi le so kiang ke tana i nga, ngan kalon di tooltool kapala ye, a nen ngan kaye di kagaua dook. Ngan la bet nen ngan pang dama ni bet balingi le so kiang tina ngan imot nga, ngan Maro ole lon ponana bet ikau ang a lo kanepe ye nepongo dook mata yo taukan motingi i. ");
INSERT INTO apr_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“Ngan kumata sei tool bet matan kala so yo mai tiap, in dook nga, ngan ole ke bet matan kala so yo maimai, ngan dook mata nen lapau. Bong kumata sei tool bet matan kala so yo mai tiap, in dook tiap nga, ngan ole matan kala so yo maimai, ngan dook tiap nen lapau. ");
INSERT INTO apr_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Ngan nen le kumata bet kanakana ngan matamu kala balingi le so ke tana i dook tiap nga, ngan ole sei bet itara lono yang ngan ikap so moolmool pang bet matamu kala i? ");
INSERT INTO apr_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Inbe kumata bet di tooltool titarang bet matamu kala so kidi, le bet matamu kala dook tiap le ilene nga, ngan ole sei bet ikap so tina yo nen ngan pang mulu i? ");
INSERT INTO apr_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Tool kapraingi sa ke bet iyei urata pang di tooltool kuto maimai ru tiap. Kumata bet iyei nen nga, ngan ole lono dook mata pang atu le ilongo betanga ki a itoo, inbe lono dook tiap pang san a iwala murini panga. Le ang nga ke bet kayei urata pang Maro, inbe kayei urata ke kaungu pat lapau tiap.” ");
INSERT INTO apr_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Di Paresi ngan di tooltool tina yo matadi pat mata nga. Le nga tilongo betanga tina yo Yesu iwete nen nga, ngan le tikan paseme Yesu ye. ");
INSERT INTO apr_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Motong la Yesu iwete pang di nen, “Ai, ang nga o lomu tar bet dada yo kayei nga, ngan o dook mata ye di tooltool matadi, too? Bong Maro lon galanga ye so yo iken lomu, ngan oo. Ngan so yo di tooltool tikamata ngan dook mata pang di nga, ngan Maro ikamata ngan ben so dook tiap le dook tiap ki taunu. ");
INSERT INTO apr_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Mugu ngan di tooltool tiwetewete pang ye wer ke Maro inbe ye betanga kidi Maro koonoo yo tiwodo ilo ye rau nga. Ngan tiyei nen le le ise ye lal yo Yowan ke rriungu di tooltool in pombe ye i. Bong ye lal tani yo ke Yowan in nga, ngan tiwetewete bingi dook mata pang di tooltool ye dada yo Maro bet matan kala di tooltool ki ye i. Ngan nen le tooltool alunu tilonga, le di lapau tikapge bet tilo, a bet nen ngan lo tigaua ye di tooltool yo Maro bet matan kala di nga. ");
INSERT INTO apr_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Ngan lang le tana nga, ngan o ke bet iken le mos tiap, inbe imot. Bong betanga tina yo iken ye wer ke Maro nga, ngan ole ikenen nen a tala, le o ke bet wodenge ki kasin pa ilene tiap yege.” ");
INSERT INTO apr_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Motong la Yesu iwete mulu nen, “Sei tool bet isukraia rimana, inbe la iyooloo garup san nga, ngan ye in iyei dada dook tiap ke bauk. Inbe kumata sei tamoto bet iyooloo garup atu yo mugu ngan nintooroo isukraii in nga, ngan ye in iyei dada dook tiap ke bauk lapau.” ");
INSERT INTO apr_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Motong la Yesu iwete mulu nen, “Mugu ngan tool ballingana atu in inepe. Le nga ye ke kanakana nga, ngan iwit mala yo puspusngana dook mata nga, inbe isousou ye sousoungu ki yo kooroonoo dook mata i, inbe ikan kaningi yo dook mata ngan leu. ");
INSERT INTO apr_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Ngan potai pang ye dada ke rumu ke tool ballingana tani, in tool atu yo ballingana tiap in tikauu a titaru a ikenen. Ye in ene la Lasarus i, bong botobotana le botobotana leu. ");
INSERT INTO apr_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Ngan ye in pitolo belebele le itar matana ye kaningi morrana bet imaruru du kakawa ke kaningi so ke tool ballingana tani in parmana nga, ngan ole ikap a ikan. Inbe di gaunu tipa man tiyoongoo botoboto ki tina a tidamdam. ");
INSERT INTO apr_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Tinepe, le nga tool ballingana tiap tani, in imata. Motong la bangabangana ke Maro si ikauu le lo titaru a iye Awaram tinepe. Inbe tool ballingana tani, in imata lapau a tikelmaii. ");
INSERT INTO apr_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Ngan le tool ballingana tani in idu inepe ye malala ke masngana, le tina isolo masngana mai san. Le nga bet matana pang ete, ngan ikamata Awaram inepe ni mooloo san, inbe ikamata Lasarus tani in inepe potai pang ye Awaram nga. ");
INSERT INTO apr_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Motong la tool ballingana tani in koonoo nen, ‘Atoo, tamak Awaram, au i anepe ye ei dook tiap lono le asolo masngana mai san, le lom pau inbe kuwete pang Lasarus in a isili bene boroborene atu matana idu ye ran, lo ngan bet isi si itaru lo ye mek i, a bet nen ngan mek isilsil kasin ngan.’ ");
INSERT INTO apr_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“Bong ngan Awaram iraua betanga ki nen, ‘Natuk, nga ole lom kaua urata dook ngan. Ye kene yo kunepe matam rerene go nga, ngan balingi le so kiong alunu san le nepongo kiong dook mata kaiye. Inbe Lasarus in barau taukan so le nepongo ki sa dook tiap. Bong dookoot nga ole inepe ye lo ponana la ni nga, inbe ong in ole sila kunepe nangan a kusolo masngana mai nen. ");
INSERT INTO apr_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Inbe so san mulu in nen, kataunu kiam amyang i, in Maro itara moolai somai atu bet iyei ben ker paidi. Le di tooltool yo tinepe ni nga, ngan kumata le lodi bet tisaut a timala pang yang nga, ngan o ke bet timala tiap. Inbe ang tooltool yo kanepe nin nga, ngan sa ke bet isaut ke nin a iman pang yam tiap lapau.’ ");
INSERT INTO apr_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“Motong la tool ballingana tani in iyei ne, ‘Atoo, tamak, bet nen ngan atorong bet kuwanga tarraia Lasarus a imulu a idu pang ye rumu yo ke tamak i, ");
INSERT INTO apr_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","yesoo, au i di taik limi nango la tinepe ni ngo. Le lok bet Lasarus ye taunu idu a du iwete tootoo pang di bet tiyei dada yo dook mata nga, a bet nen ngan bet timmata nga, ngan di lapau titoo au a se tinepe ye malala ke masngana i be.’ ");
INSERT INTO apr_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","“Bong ngan Awaram iwete panga nen, ‘Betanga ke Mose inbe kidi Maro koonoo yo tikap pang di nga, ngan la iken ye di ngo, le bet nen ngan tilongo betanga tina, inbe titoo.’ ");
INSERT INTO apr_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","“Motong la tool ballingana tani in iyei ne, ‘Atoo, tamak Awaram, o tiap! Bong kumata bet tool yo timmata koot nga, ngan atu imadit mulu ye ni ke matenge, inbe ye taunu idu le du iwete betanga nga pang di nga, ngan la bet ole tiportak lodi ye dada dook tiap kidi ke sennene yo tiyei nga.’ ");
INSERT INTO apr_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","“Le nga Awaram iyei ne, ‘Kumata bet tilongo betanga ke Mose inbe kidi Maro koonoo tiap nga, ngan o ke bet tilongo betanga ke tool yo imadit mulu ye ni ke matenge, lo ngan bet ikap betanga a la iwete pang di i, in tiap lapau.’” ");
INSERT INTO apr_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Yesu iwete pang di galiunu nen, “So matana matana la bet pompombe, ngan ole igarung di tooltool le tikapsap ye dada dook tiap ke sennene nga. Bong atoo, tool yo bet iyei dada dook tiap moonoo nen a pombe pang ye di tooltool le bet tikapsap ye sennene i, in ole Maro iyemenaii le dook tiap yege. ");
INSERT INTO apr_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Ngan kumata le tool tani in bet isokkara di kakase yo maimai tiap ngan atu lono, le bet ikapsap ye sennene nga, ngan tool tani in ole isolo urata moonoo dook tiap. Le moolmool, kumata bet tituku pat somai yo ke raunganingi dingding patunu ngan atu lo gurini, inbe tikatte du tiek lono a bet nen ngan idaup a imata nga, ngan ben dook kasin, yesoo bong urata moonoo dook tiap yo bet isola ye dada dook tiap ki tani yo iyeii i, in ole dook tiap le dook tiap ki taunu. ");
INSERT INTO apr_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Le bet nen ngan ang tapmu lapau, ken kakamatang dook leu. “Ngan kumata em atu bet iyei dada dook tiap ke sennene pong nga, ngan kula ye la kuwete panga a kupassonga ye dada. Kumata le bet ilongo betanga kiong le bet iportaka lono nga, ngan lom panga a kugiri sennene ki. ");
INSERT INTO apr_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Le kumata bet em tani in iyei dada dook tiap ke sennene pong a iman iwete pong bet iportaka lono oo, lo ngan bet iyei dawa ben yo mugu nga, ngan mulu le lo limi be ru ye ke atu nga, ngan bet nen ngan lom panga a kugiri sennene ki.” ");
INSERT INTO apr_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Di aposol ke Yesu tiwete panga nen, “Tool Mai, am nga lomam bet kuyeie lo medana kiam yo amtaru pong i, in le lo mai.” ");
INSERT INTO apr_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Motong la Tool Mai tani in iwete pang di nen, “Ngan dook mata, bong kumata bet lo medana kiang yo kataru pang Maro, in mai tiap le dawa ben kai mastet patunu leu nga, ngan ke bet kawete pang kai somai i nen, ‘Kugamong le kupa ye ramim, inbe du kupe ong meneng tiek pono ni,’ ngan ole ilongo betanga kiang a itoo.” ");
INSERT INTO apr_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Motong la Yesu iwete mulu nen, “Bet ang tina nga atu bet iwete pang kapraingi ki la itara tana ye kumu ki, too bet la matan kala di sipsip ki nga, ngan ye kene yo bet kapraingi ki tani in imulu a iman pang rumu ki nga, ngan ole iwete panga balai? Ole iyei ne, ‘Kupa tarrai se kuwur, a nen ngan kon so,’ too? ");
INSERT INTO apr_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Tiap! Ole iwete pang kapraingi ki tani in nen, ‘Kudawai kaningi kiau nga, lo ngan bet kukaratong le dook, inbe kuso kaningi kiau tina a kop man akan. Ole akan be ayin mugu le kapok sung ngan, lo ngan bet ong kon be kuyin mur kooti.’ ");
INSERT INTO apr_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Ngan lom balai, ole iwete lo ponana ki sa pang kapraingi ki tani yo iwete panga ye soo urata ngan le ilongo koonoo a iyeii, in lapau, too tiap? Tiap! ");
INSERT INTO apr_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Ngan nen le ang lapau bet kayei porai urata yo Maro iwete pang ye bet kayei ngan le imot nga, ngan kawete panga nen. Kayei ne, ‘Am nga ben di kapraingi kiong sorok leu, le soo urata kiong yo kop pam bet amyei nga, ngan ampas le amyei leu.’” ");
INSERT INTO apr_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Motong la Yesu itoo dada a bet ilo pang Yerusalem. Ngan le ipa kataunu ye ker ke malala mai ru yo Samaria inbe Galili nga. ");
INSERT INTO apr_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Le nga ipa a ilo bet lo pombe ye malala kase atu, ngan di tooltool sangaul atu yo botoboto medana ikan di nga, ngan man titauaraii dada mai. Le nga la tikodo manga mooloo ye kasin, ");
INSERT INTO apr_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","inbe koodi le mai. Tiyei ne, “Atoo, Yesu! Tool mai, lom pam a kulonam!” ");
INSERT INTO apr_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Motong la Yesu ikamata di le iwete pang di nen, “Kamulu a kalo, ngan le lo ang tapmu kapitnai tinimu pang di tooltool ke paroranga so pang Maro nga.” Le nga bet tipa a timulu a tilo, ngan botoboto kidi tina ngan imapmap le tinidi dook mata mulu. ");
INSERT INTO apr_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Motong la di tooltool tina ngan atu in ikamata tinini ngan dook mata mulu nga, le nga imulu tak pang ye Yesu a idu, ngan lon ponana le koonoo le mai, inbe iyitmaka Maro ene. ");
INSERT INTO apr_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Ngan ipa le idu potai ye Yesu, motong igun turunu le du damon toko tana kene punu, inbe iwete lo ponana ki panga. Ngan tool tani in tool ke Samaria. ");
INSERT INTO apr_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Yesu ikamata le nga iyei ne, “Ai, ayeisa ang tooltool tina yo sangaul nga, ngan la akaratang le imot a tinimu dook mata mulu nga. Bong ngan di diem yo limi be pai nga, ngan tila ngai? ");
INSERT INTO apr_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Gelei, di tooltool tina ngan sa lono bet imulu a iman iyitmaka Maro ene tiap, la le tool ke malala san i, yetaleu imulu a iman bet man iyitmaka Maro ene nga?” ");
INSERT INTO apr_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Motong la Yesu iwete pang tool tani in nen, “Oo, kumadit a kula. Lo medana kiong yo kutaru pau i, in la Maro ikaratong ye a le tinim dook mata mulu i.” ");
INSERT INTO apr_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Ye kene atu ngan di Paresi titoro Yesu nen, “Lal yo Maro itaru bet matan kala di tooltool ki ye i, in ole nge lo pombe?” Motong la Yesu iraua betanga kidi nen, “Lal yo Maro itaru bet matan kala di tooltool ki ye i, in so ke bet kakamata ye matamu a lomu galanga ye, ngan tiap. ");
INSERT INTO apr_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Ngan nen le ke bet di tooltool tiyei ne, ‘Kakamata! Ye bi e i,’ too tiyei ne, ‘Kakamata! Ye meneng e ni,’ ngan tiap. Awete pang nen, yesoo bong lal yo Maro itaru bet matan kala di tooltool ki ye i, in pombe pang yang oo.” ");
INSERT INTO apr_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Motong la Yesu iwete pang di galiunu nen, “Awete pang nen, pang dama ni ye lal atu yo bet pombe in nga, ngan ole lomu bet le kakamata Tool Moolmool ke Maro, bong o ke bet kakamata tiap. ");
INSERT INTO apr_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Ngan di tooltool kapala ole tiwete pang nen, ‘Kakamata, tool tani bi e i,’ too tiyei ne, ‘Kakamata, ye meneng e ni.’ Bong ngan ken kalongo betanga kidi a katoo di be. ");
INSERT INTO apr_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Awete nen, yesoo lal yo Tool Moolmool ke Maro bet imulu a isi pang tana ye in nga, ngan ole dawa ben kili itai a lulngana ilangaraia lang katene mai i le imot. ");
INSERT INTO apr_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Bong mugu ngan ole isolo masngana alunu san, inbe di tooltool yo dookoot tinepe nga, ngan ole tiwala muridi panga lapau. ");
INSERT INTO apr_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","“Ngan dada dook tiap ben yo tiyei ye lal ke Noa nga, ngan gaongo leu la bet ole tiyei lapau ye lal yo Tool Moolmool ke Maro bet imulu a isi ye i. ");
INSERT INTO apr_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Ye lal ke Noa nga, ngan di tooltool tikan be tiyin, inbe tamoto le garup tikerere, inbe tikap di natudi garup a la tipakere di pang di tamoto kapala, le le ilo ye lal ke Noa yo bet iyiri a ilo ookoo lono ye i. Motong la oongoo mai pombe a iraumatamata di tooltool yo tilo ookoo lono tiap nga, ngan a timmata le imot. ");
INSERT INTO apr_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","“Inbe ye lal ke Loto nga, ngan di tooltool tiyei urata gaongo nen leu. Di ngan tikan be tiyin, inbe tiyawar so le tiyimi so kidi diedi, inbe tikapgi le titu ye renge rumu kidi. ");
INSERT INTO apr_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Bong ye kene yo Loto imadit a igege Sodom a ila nga, ngan le ei ipa ye pat lutene imol ke lang katene dawa ben ki, a isi le si iraumatamata di tooltool ke Sodom tina a timatamata le imot. ");
INSERT INTO apr_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","“Ngan gaongo leu, ye lal yo Tool Moolmool ke Maro bet imulu a isi pombe mallangana ye in nga, ngan ole di tooltool tiyei dada nen lapau. ");
INSERT INTO apr_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Ngan lal tani in bet pombe nga, ngan tool atu bet inepe rumu pono ki, inbe so ki dook mata sa iken rumu lono nga, ngan o ke bet lon tut so ki tina ngan a idu ikap tiap, bong ipas le igege sila ikino leu. Inbe gaongo leu, tool atu bet inepe kumu ki nga, ngan o ke bet lon tut so ki tina ngan a imulu pang rumu ki tiap, bong ipas le igege sila ikino leu. ");
INSERT INTO apr_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Lomu tut ye so yo pombe pang ye Loto rimana i. ");
INSERT INTO apr_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Bet sei tool lono mai pang nepongo ki ke tana i mai mata a ikapge bet iparama i, in ole ilene. Bong sei tool yo lono mai san ye nepongo ki ke tana i tiap, inbe iraia tinini le imot pau i, in ole ikaua nepongo dook mata yo taukan motingi i. ");
INSERT INTO apr_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Awete pang nen, ye kene tani in, kumata bet Tool Moolmool ke Maro imulu a isi pombe bong, le di tooltool ru tiken gaongo ye kakawa ke kenongo atu nga, ngan atu ole Maro ikauu, inbe san in igege sila ikino. ");
INSERT INTO apr_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","36","Inbe gaongo leu, kumata bet di garup ru titutngan dingding patunu pang sopalanga porong nga, ngan atu ole Maro ikauu, inbe san in igege sila ikino.” ");
INSERT INTO apr_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Ngan Yesu di galiunu tilongo tina yo iwete nen nga, le nga titoru. Tiyei ne, “Tool Mai, so tina nga, ngan ole pombe ngai?” Ngan Yesu iraua torungu kidi a ikatte betanga nen, “Ye ni yo so imata ngan bobono iken ye i, in ni tani yo bet di kamoko timan man tigaua ye i.” ");
INSERT INTO apr_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Motong la Yesu ikatte betanga atu mulu pang di galiunu bet ipatomonai di, a nen ngan kanakana ngan tinidi bese ye pataraungu, bong tinidi booroomoo be. ");
INSERT INTO apr_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Le nga iyei ne, “Ngan ye malala mai atu, in tool kuto mai atu ke karatanga betanga in inepe ye. Bong tool tani, in itattadaia Maro tiap, inbe lono rru ye di tooltool tiap lapau. ");
INSERT INTO apr_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Ngan garup tap atu inepe ye malala mai tani in lapau, le nga kanakana ngan iman pang ye tool ke karatanga betanga tani man iyei ne, ‘Ai, koi kiau bet igarungau sa, le bet nen ngan kulonau inbe kukarata betanga kiau i le dook.’ ");
INSERT INTO apr_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","“Mugu ngan tool tani lono bet ilongo betanga ke garup tani in tiap, bong inepe kasin, motong la ye taunu lon wete nen, ‘Au i atattadaia Maro tiap, inbe lok rru ye di tooltool tiap lapau, ");
INSERT INTO apr_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","bong garup tap i kanakana ngan ikaurai au mata san. Le ole aloni a akarata betanga ki le dook ngan. Kumata le ayei nen nga, ngan la bet isitoo maningi pang yau tiap nga.’” ");
INSERT INTO apr_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Motong la Tool Mai iwete pang di mulu nen, “Ole katar talngamu a kalongo betanga yo tool dook tiap ke karatanga betanga tani in iwete nga. ");
INSERT INTO apr_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Ngan ole gelei? Di tooltool yo Maro ipootoo di panga ye taunu nga, ngan kumata bet titang panga ye ke le bong tina yo kanakana nga, ngan ole gelei, o ke bet Maro ilon di a ikarata betanga kidi tiap? Too, kumata bet titoru nga, ngan ole gelei, o ke bet ilon di tarrai tiap, too? Tiap yege! ");
INSERT INTO apr_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Awete pang nen, ole palbe leu be ilon di a ikarata betanga kidi le dook mata. Bong kene yo bet Tool Moolmool ke Maro imulu a isi ye in nga, ngan ole ikamata di tooltool yo tinepe ye tana i nga, ngan titara lodi medana pang Maro, too tiap?” ");
INSERT INTO apr_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Di tooltool kapala ngan titara lodi ye di tapdi bet di nga tooltool noonoodi, inbe matadi ru di diedi ben di ngan tooltool dook tiap. Le nga Yesu ikatte betanga atu pang di nen, ");
INSERT INTO apr_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Di tooltool ru tilo bareme mai ke sungunu lono bet lo tipatarau pang Maro. Ngan tool atu in Paresi, inbe san in tool ke sodaningi pat. ");
INSERT INTO apr_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Tilo, motong la tool ke Paresi in imadit a ikodo, inbe ye taunu ipatarau ye pang Maro. Iyei ne, ‘Maro, awete lo ponana kiau pong ye yo au i dawa ben di tooltool kapala nga tiap. Di ngan tipinau, le tiyei dada dook tiap, inbe tiyei bauk. Bong au i tool dook mata le dawa ben tool ke sodaningi pat i tiap lapau. ");
INSERT INTO apr_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Ngan kanakana ye wik atu atu nga, ngan asapa ye kaningi so ye ke ru, inbe apatarau pong. Inbe so kiau le imot yo akap nga, ngan ole apoto le atar ye budanga sangaul, lo ngan bet akaua budanga atu pong.’ ");
INSERT INTO apr_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“Bong tool ke sodaningi pat in ikodo manga mooloo ye Paresi tani, ngan lono bet matana lo pang ye malala ke Maro tiap. Bong itoo momo kidi Yuda a ipodo katene bet ipitnaia lo madoko ki, inbe iyei ne, ‘Maro, au i tool dook tiap ke sennene, bong lom pau a kulonau.’” ");
INSERT INTO apr_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Motong la Yesu iyei ne, “Awete pang nen. Ye kene tani in tool ke sodaningi pat in imulu a ila pang rumu ki nga, ngan yetaleu in la Maro ikamata ben ye in tool noonoonoo ye matana i. Bong tool san in tiap, yesoo sei tool yo ye taunu iyitmaki le ilo ete i, in ole Maro itaru le idu lopo ni. Bong sei tool yo ye taunu itaru le idu lopo i, in ole Maro iyitmaki le ilo ete ni.” ");
INSERT INTO apr_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Di tooltool tikap di natudi yo kakase nga, ngan a tise pang ye Yesu bet se ipaloko bene lo kutodi, inbe ipamede di ye betanga dook mata. Ngan le di galiunu tikamata di, le nga tipasak pang di a tisoror di. ");
INSERT INTO apr_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Bong Yesu ikiu di kakase tina a timan potai ye, inbe iwete pang di galiunu nen, “Ai, ken kasoror di kakase ngan be! Bong kamalum pang di a timan pang yau, yesoo di tooltool yo bet lo tigaua ye di tooltool yo Maro bet matan kala di nga, ngan dawa ben di kakase tina nga. ");
INSERT INTO apr_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Awete pang moolmool nen, kumata le tool atu imalum pang Maro bet iyei tool mai panga inbe matan kala dawa ben di kakase tina ngan tiap nga, ngan o ke bet lo igaua ye di tooltool yo Maro bet matan kala di, ngan tiap.” ");
INSERT INTO apr_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Motong la tool kuto mai atu in itoro Yesu nen, “Pannoongoo, ong in tool dook mata. Nga bet atorong, ole ayeie soo so, a bet nen ngan akaua nepongo dook mata yo taukan motingi in nga?” ");
INSERT INTO apr_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Motong la Yesu iraua betanga ki nen, “Nga gelei bet kukiu au ye tool dook mata nga? Idi nga tool sa yo dook mata, ngan tiap, bong Maro yetaleu in la dook mata i. ");
INSERT INTO apr_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Ong in lom galanga ye wer yo Maro ikap pang Mose ngan oo. Wer tina ngan iwete nen: ken kuyei bauk be, inbe ken kuraumata di tooltool be, inbe ken kupinau be, inbe ken kusopo koom ye betanga doko be, inbe kuraua pang tamam le tinam a kulongo betanga kidi.” ");
INSERT INTO apr_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Motong la tool ene mai tani iyei ne, “Ye kene yo au kase go le se dookoot au mai nga, ngan atoo wer tina yo kuwete ngan le imot.” ");
INSERT INTO apr_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Ngan Yesu ilongo betanga ki yo iwete nga, motong la iwete mulu panga nen, “Dook mata, bong so atu la kuyeii tiao i. Ngan nanga, ole kuyawar so kiong le imot, inbe kop pat ki a kop pang di tooltool yo ballingadi tiap nga. Kumata le bet kuyei nen nga, ngan la bet pang dama ni ngan Maro ole ikap so dook mata yo iken ye malala ki ngo pong nga. Ngan kuyei nen a imot, lo ngan bet kuman man kutoo au.” ");
INSERT INTO apr_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Ngan tool tani ilongo betanga tina Yesu iwete panga nen nga, ngan le lon madoko ye san, yesoo ye in tool ballingana le so ki alunu san. ");
INSERT INTO apr_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Yesu matana pang ye tool tani, inbe iwete nen, “Atoo! Di tooltool yo ballingadi nen nga, ngan ole urata mai pang di bet tilo tigaua ye di tooltool yo Maro bet matan kala di nga. ");
INSERT INTO apr_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Le moolmool, kumata bet asara mai ke solanga burum yo ene kamel i, in ikapge bet idewe ye sar gimono maitiap in nga, ngan ole gelei, urata imoo panga, too? E, moolmool! Ngan ole gaongo leu, kumata le tool yo ballingana in lono bet ilo igaua ye di tooltool yo Maro bet matan kala di nga, ngan ole urata imoo panga nen lapau.” ");
INSERT INTO apr_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Ye kene tani in di tooltool tina yo tiye di tinepe nga, ngan tilongo tina yo iwete nen nga, le nga titoru nen, “Ona tiap! Bet nen nga, ngan ole sei tool bet Maro ipamule ye so dook tiap yo bet igarungu i?” ");
INSERT INTO apr_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Motong la Yesu iwete pang di nen, “So yo nen nga, ngan imoo pang di tooltool le tisak ye. Bong bet Maro nga, ngan so le imot ngan imarra panga le ke bet isak ye tiap.” ");
INSERT INTO apr_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Motong la Pita iwete panga nen, “Am nga amgege so kiam le imot sila ikino, inbe la amman bet man amtoo ong nga.” ");
INSERT INTO apr_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Ngan Yesu iwete pang di nen, “Awete pang moolmool nen. Kumata tool atu bet igege rumu ki, too di toonoo le taini, too tamana le tinana, too di natunu, inbe man itoo au a iwetewete pang di tooltool ye dada yo Maro bet matan kala di tooltool ki ye in nga, ");
INSERT INTO apr_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","ngan ole dookoot ye kene yo inepe ye tana i nga, ngan Maro ole ikap bele so dook mata panga le illos so ki yo igege koot nga. Inbe pang dama ni nga, ngan ole ikaua nepongo dook mata yo taukan motingi i.” ");
INSERT INTO apr_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Motong la Yesu ikap di galiunu tina yo sangaul be ru nga, ngan a iye di leu tila manga mooloo kasin la iwete pang di nen, “Kapalongo, dookoot nga bet talo pombe Yerusalem nga, ngan ole so tina le imot yo mugu ngan di Maro koonoo tiwodo betanga ki a iken ye rau bet ole pombe pang ye Tool Moolmool ke Maro nga, ngan ole kanono pombe moolmool. ");
INSERT INTO apr_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Ngan talo ngan ole tisuketi la di tooltool yo tipa ye rara kidi Yuda tiap ngan bedi, a nen ngan tikan paseme, inbe tipalele sere ye a tikorokoronaii. ");
INSERT INTO apr_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Inbe tikap koro a tiwalisi tinini ye, inbe tiraumate le imata. Bong ole iken ye ke ru, lo ngan bet ye ke tol ki ngan ole imadit mulu ye ni ke matenge.” ");
INSERT INTO apr_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Di galiunu tilongo tina yo iwete nen nga, ngan le lodi galanga dook ye betanga ki tina ngan punu tiap, yesoo betanga yo iwete nga, ngan punu iken mallangana pang di bet nen ngan lodi galanga ye tiap. ");
INSERT INTO apr_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Yesu iye di galiunu tipa le timan pombe potai pang malala mai Yeriko nga, ngan titauarai tool mata kis atu yo iwurur dada gigini a igaugau pat le so ye di tooltool bet tikap panga i. ");
INSERT INTO apr_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Ngan ilongo di tooltool malala mai tina yo koodi ngaungaube a tise a bet se tikapusu nga. Le nga itor nen, “Ai, di tooltool nga tiyei soo?” ");
INSERT INTO apr_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Ngan tiwete panga nen, “Ona, Yesu ke Nasaret la ipa a ise i, ngan bet ikapusong.” ");
INSERT INTO apr_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Motong la tool mata kis tani in koonoo le mai nen, “Yesu, ong in Dawiti natunu. Lom pau a kulonau!” ");
INSERT INTO apr_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Le nga di tooltool tina ngan kapala yo timugu nga, ngan tipasak panga a tilele bet koonoo dookoot. Bong ngan tool tani in koonoo le mai mulu nen, “Atoo, Dawiti Natunu, lom pau a kulonau!” ");
INSERT INTO apr_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Motong la Yesu ikodo, inbe iwete pang di tooltool tina ngan atu bet idede a iman pang ye. Tool mata kis tani in iman potai ye Yesu, motong la Yesu itoru nen, ");
INSERT INTO apr_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Ai, soo so lom bet ayeii pong i?” Ngan tool mata kis tani in iyei ne, “Tool Mai, au i lok bet matak rere a akamata ni.” ");
INSERT INTO apr_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Motong Yesu iwete panga nen, “Ole kumata ni mulu. Ngan lo medana kiong yo kutaru i, in la ilonong a ikaratong le matam dook mata i.” ");
INSERT INTO apr_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Le tina pattu leu be matan rere a ikamata ni, motong la iyitmaka Maro ene, inbe itoo Yesu a ipa a ilo nga. Ye kene tani in di tooltool tikamata so yo pombe i, le tina di le imot tiyitmaka Maro ene lapau. ");
INSERT INTO apr_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Yesu ipa a ilo pombe malala mai Yeriko, le nga bet itoo dada a ipa so a ila. ");
INSERT INTO apr_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Ngan tool kuto mai atu ke sodaningi pat yo ene Sakias i, in inepe ye malala mai tani in. Bong ye in tool ballingana lapau. ");
INSERT INTO apr_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Ngan Sakias tani in lono bet le ikamata Yesu pa, a nen ngan bet ikilla. Bong ngan kene moddono mata le ke bet ikamata Yesu tiap, yesoo di tooltool malala mai san la tiye Yesu tipa le tigaliuu nga. ");
INSERT INTO apr_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Le nga Sakias tani in idada a imugu le ilo ke dama ye dada yo Yesu bet ipa ye a ila i, inbe irookoo kai somai atu le lo inepe kaini, a nen ngan Yesu bet itoo dada tani in a ila nga, ngan ikamata. ");
INSERT INTO apr_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Le nga Yesu itoo dada tani in a ila le la itarye ni tani, inbe itada pang ete, ngan ikamata Sakias tani, le nga iwete panga nen, “Sakias, palbe be kupa tarrai a kusi tana! Dookoot katai nga ole anepe ye rumu kiong.” ");
INSERT INTO apr_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Sakias ilongo nen, le tina lon ponana kaiye. Le nga irookoo tarrai a idu tana, motong la ikaua Yesu a yeru tila pang rumu ki. ");
INSERT INTO apr_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Ngan di tooltool tina le imot tikamata Yesu yo lo inepe ye rumu ke Sakias nga, le nga tikap malmal panga a tiwete mur ye. Tiyei ne, “Ona tiap! Nga gelei a bet lo inepe ye rumu ke tool dook tiap ke sennene ni nga?” ");
INSERT INTO apr_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Motong la Sakias tani in imadit le lo ikodo, inbe iwete pang Tool Mai Yesu nen, “Tool Mai, kupalongo! Dookoot katai nga ole apoto so kiau le paru, lo ngan bet akap kapala pang di tooltool yo ballingadi tiap nga. Inbe kumata le akaua llungunu ye tool atu bet akap sorok so ki nga, ngan ole araua so ki tina, inbe akap so pai mulu panga ye so ki tina ngan kootoonoo.” ");
INSERT INTO apr_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Motong la Yesu iwete panga nen, “Dookoot katai nga ole Maro ipamulong kuye di tooltool le imot yo kuye di kanepe ye rumu i nga, ngan ye so dook tiap tani yo bet igarungang i, yesoo ong i kutara lom medana panga, le ong i ben sasa ke Awaram moolmool nga. ");
INSERT INTO apr_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Ngan awete nen, yesoo Tool Moolmool ke Maro isi tana i nga, ngan bet si isere di tooltool yo tilledi nga, a nen ngan ikap di a ipamulu di ye so dook tiap yo bet igarung di i.” ");
INSERT INTO apr_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Di tooltool malala mai tina yo tigaua nga, ngan titar talngadi a tilongo betanga ke Yesu yo iwetewete nga. Ngan tina Yesu ipa a ilo potai pang ye malala mai Yerusalem nga, ngan le di tooltool tina tiyeisa lal yo Maro itaru bet matan kala di tooltool ki ye i, in la o iman potai koot i. ");
INSERT INTO apr_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Ngan nen le Yesu ikatte betanga atu pang di nen, “Tool mai atu, in nga bet idu pang ye tana mai atu yo iken ni mooloo i, ngan idu bet du titaru a iyei tool kuto mai yo bet matan kala di tooltool ki, lo ngan bet imulu a ilong pang ye malala ki kooti. ");
INSERT INTO apr_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Le nga ye kene yo bet imadit a ipa ye in nga, ngan ikiu di kapraingi ki yo sangaul atu nga, ngan man tigaua. Motong la ikap pat yo ene gol ngan sangaul a imalimi di atu atu ye, inbe iwete pang di nen, ‘Pat yo akap pang koot nga, ngan bet la kayei urata ke kaungu pat ye le le amulu a along.’ ");
INSERT INTO apr_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","“Bong ngan tool mai tani in di tooltool ke malala lono ki, lodi dook mata panga tiap. Le nga ipa a imugu, motong la tiwanga di tooltool kidi pattu a titoo bet du tiwete pang di tooltool maimai ke tana mai tani yo bet idu ye in nen. Tiyei ne, ‘Am nga lomam bet katara tool in a iyei kuto mai pam, inbe matan kalam tiap.’ ");
INSERT INTO apr_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Bong ngan di tooltool maimai ke tana mai tani in lodi bet tilongo betanga kidi tooltool tina tiap. Le nga titara tool tani a bet iyei tool kuto mai pang di, motong la imulu a ilong pang malala ki nga. Ilong, motong la iwanga pang di kapraingi ki tina yo mugu ngan ikap pat pang di nga, ngan bet timan. Ye in lono bet itor tomonai di ye pat ki tina yo ikap pang di nga, ngan tiyei urata ke kaungu pat ye, a nen ngan tikap sa mulu la ye lapau, too tiap? ");
INSERT INTO apr_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","“Le nga kapraingi ki yo iman mugu i, in iman le man iyei ne, ‘Tool mai, au i ayei urata ye pat kiong tani yo kuwi pau i, ngan le akap pat sangaul atu mulu la ilo pono nga.’ ");
INSERT INTO apr_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","“Motong la tool kuto mai tani in iyei ne, ‘Ona, ong i kapraingi dook mata! Ong in kuyei urata dook mata ye so maitiap tani yo akauu pong i, ngan le matam kala dook mata san. Ngan nanga, ole atarong bet kuyei tool mai atu a bet nen ngan matam kala malala maimai sangaul atu.’ ");
INSERT INTO apr_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","“Motong la kapraingi san yo itoo i, in iman le man iyei ne, ‘Tool mai, au i ayei urata ye pat kiong tani yo kuwi pau i, ngan le akap pat limi mulu la ilo pono nga.’ ");
INSERT INTO apr_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","“Le nga tool kuto mai tani in iwete panga nen, ‘Dook mata, ole atarong bet kuyei tool mai atu a bet nen ngan matam kala malala maimai limi.’ ");
INSERT INTO apr_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Motong la kapraingi tina ngan san mulu iman le man iyei ne, ‘Tool mai, pat kiong tani yo kuwi pau i, in bi. Kumata nga, aduku ye mala, motong la atarkoo dook mata a iken nga, ");
INSERT INTO apr_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","yesoo ong i tool gadagadam le au i atattadai ong. Kanakana ngan ong i kop sorok pat kidi diem yo titar nga, inbe kugamagama kaningi ke kumu yo di diem tikapgi, ngan lapau.’ ");
INSERT INTO apr_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","“Motong la tool kuto mai tani in iwete panga nen, ‘Ona, ong i kapraingi dook tiap sa! Betanga kiong yo dookoot ong taum kuwete nga, ngan ipaposong ye urata dook tiap kiong oo. Le ole ayemenai ong ye. Yesoo, ong i lom galanga yau bet au i tool gadagadak, inbe kanakana ngan au i akap sorok pat kidi diek yo titar nga, inbe agamagama kaningi ke kumu yo di diek tikapgi, ngan lapau. ");
INSERT INTO apr_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Le bet nen nga, ngan gelei a kutara pat kiau i ilo ye rumu ke tarungu pat, tiap nga? Kumata bet kuyei nen nga, ngan la bet pat kiau tani idik mulu pang ete, a bet nen ngan amulu a along nga, ngan akaua pat kiau tani le ipa ye pat yo bet titar ilo pono mulu nga.’ ");
INSERT INTO apr_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","“Motong la tool kuto mai tani in iwete pang di tooltool yo tikodo potai pang ye ngan nen, ‘Kakaua pat in ye tool in, inbe kakauu pang tool yo pat ki sangaul atu i.’ ");
INSERT INTO apr_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","“Ngan di tooltool tina ngan tiyei ne, ‘Tool mai, ngan dook mata, bong tool ni pat yo ikap koot ngo sangaul atu oo!’ ");
INSERT INTO apr_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","“Motong la tool kuto mai tani in iyei ne, ‘Awete pang nen, di tooltool yo so kidi nga, ngan ole akap so sa mulu pang di. Bong tool yo taukan so i, in so kasin yo bet ikap nga, ngan ole akap ye. ");
INSERT INTO apr_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Bong di koi kiau yo lodi bet ayei tool kuto mai a matak kala di tiap nga, ngan kakap di le timan matak i, inbe man karaumatamata di le imot a timmata.’” ");
INSERT INTO apr_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Yesu ikatte betanga nen pang di a imot, motong la imadit ye panga mulu a itoo dada bet ilo pang Yerusalem nga. ");
INSERT INTO apr_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Yesu iye di galiunu titoo dada a bet tilo pang malala mai Yerusalem nga, ngan tipa le tilo potai ye malala Betpage inbe Betani yo iken ye kawal yo ene Olip in madini nga. Motong la Yesu iwanga di galiunu tina ngan ru, ");
INSERT INTO apr_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","inbe iwete pang di nen, “Angru kamugu a kalo ye malala yo iken pang dama i. Ngan kumata bet kapa le lo pombe nga, ngan ole kakamata asara ke solanga di tooltool yo ene donki i, in kase paunu atu yo tiwatu i. Ngan donki tani in tool sa iwur pono a idada ye pitiao. Lo ngan bet angru karuku ooroo ki, inbe kadede a kasi. ");
INSERT INTO apr_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Le kumata bet tool sa ikamatang le itorang nen, ‘Ai, nga gelei a karuku ooroo ke donki in nga?’ ngan kawete panga nen, ‘Tool Mai bet iyei urata ki ye ngan.’” ");
INSERT INTO apr_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Motong la di galiunu ru tina yo iwanga di nga, ngan timugu a tilo ngan le lo yeru tikamata so dawa ben tina yo Yesu iwete pang di ye nga. ");
INSERT INTO apr_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Motong la yeru bet tiruku ooroo ke donki natunu tani, ngan di taunu tikamata di le nga titor di nen, “Ai, nga gelei a bet angru karuku ooroo ke donki natunu in nga?” ");
INSERT INTO apr_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Ngan tiyei ne, “Tool Mai bet iyei urata ki ye ngan.” ");
INSERT INTO apr_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Motong la yeru tidede donki tani in a tidu pang ye Yesu. Tidu, motong la tidut sousoungu matolene kidi ngan a tiyoo lo donki tani in pono, inbe tiyiti Yesu lo iwur ye. ");
INSERT INTO apr_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Motong la yeiso bet donki tani isola a bet itoo dada a ilo, ngan le di tooltool kapala yo tiye tipa nga, ngan tidut sousoungu matolene kidi lapau a tiyoo du dada katene ye ni yo bet ipa ye a ilo i. ");
INSERT INTO apr_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Ngan ise potai pang ye ni yo dada ki ipa ke kawal Olip a bet idu i, motong Yesu di galiunu malala mai tina yo titoo nga, ngan lodi ponana a tiyitmaka Maro ene, yesoo ye mos tina le imot yo Yesu iyei a tikamata ye matadi koot nga. Le nga koodi le mai nen, ");
INSERT INTO apr_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","“Maro ole iyei urata dook mata pang ye tool kuto mai yo isi ye Tool Mai ene i. Maro yo inepe ye malala ki ete ni, in iyei idi tooltool le imot le tanepe ye lo silene ki. Le tayeie ene le ilo ete ke bet di tooltool tipayiti ye!” ");
INSERT INTO apr_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Bong ngan di Paresi pattu yo tipa kataunu ye di tooltool malala mai tina ngan tilongo yo koodi nen nga, le nga tiwete pang Yesu. Tiyei ne, “Pannoongoo, kulele di galium nga a koodi dookoot!” ");
INSERT INTO apr_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Motong la Yesu iraua betanga kidi nen, “Awete pang nen, kumata le bet alele di nga, ngan ole pat nga di tapdi la bet koodi a tiyitmaka Maro ene nga.” ");
INSERT INTO apr_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Yesu ipa a ilo potai pang Yerusalem, ngan ikamata, le nga itang ye. ");
INSERT INTO apr_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Inbe iwete nen, “Atoo, Yerusalem, dookoot katai nga, ngan au i lok bet di tooltool kiong lodi galanga dook ye so yo bet iyei di le tinepe ye lo silene dook mata i. Bong so tina ngan iken mallangana tiap, le o ke bet lodi galanga ye tiap. ");
INSERT INTO apr_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Atoo, Yerusalem, ngan pang dama ni nga, ngan lal dook tiap atu yo bet pombe pang yong nga, ngan ole di koi kiong timan a man tiwudu tana le iwakaia koongoo kiong i. Inbe ole tikodokalakalong ye gigim tina nga le imot a tigaliu ong le tiparkat. ");
INSERT INTO apr_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Ngan ole man tisorreke koongoo kiong du tana, inbe lo tiraumatamata di tooltool kiong yo tinepe koongoo lono nga. Ngan o ke bet tigege pat kiong sa a iloko lo ene san pono, ngan tiap, yesoo bong kukilala tool yo Maro iwanga bet isi ipamulong ye so dook tiap yo bet igarungong i, in tiap.” ");
INSERT INTO apr_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Yesu ilo pombe Yerusalem, motong la ipa so a ilo koongoo lono ke bareme mai ke sungunu nga, ngan ikamata di tooltool yo tiyawar so kidi koongoo lono nga. Le nga inganga di, ");
INSERT INTO apr_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","inbe iwete pang di nen, “Betanga yo tiwodo lo iken ye Rau ke Maro nga, ngan iwete nen, ‘Rumu kiau i, in rumu ke pataraungu.’ Bong ang nga kayeii le iyei ben ‘ni kidi tooltool ke pinnau bet tiko ye.’ ” ");
INSERT INTO apr_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Ngan ye ke kanakana nga, ngan Yesu lo ipatomonai di tooltool koongoo lono ke bareme mai ke sungunu tani. Bong ngan di tooltool maimai ke paroranga so pang Maro nga, ngan tiye di pannoongoo ke wer ke Maro, inbe di tooltool maimai kapala kidi Yuda nga, ngan tikapge bet tisere dada yo bet tiraumata Yesu tani ye a imata i. ");
INSERT INTO apr_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Bong ngan tikamata di tooltool yo talngadi gorengana bet tilongo betanga ki nga, ngan nen le ke bet tiyeie so sa panga tiap. ");
INSERT INTO apr_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Ye kene atu in Yesu inepe koongoo lono ke bareme mai ke sungunu a nga ipatomonai di tooltool, inbe iwetewete bingi dook mata ke Maro pang di. Inbe di tooltool maimai ke paroranga so pang Maro, tiye di pannoongoo ke wer ke Maro, inbe di tooltool maimai kidi Yuda timan pang ye. ");
INSERT INTO apr_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Le nga man titoro Yesu nen, “Ai, kuwete pam ngan! Sei itarong bet kuyei urata nen i? Inbe sei ikaua gurana pong bet kuyei urata nen ye i?” ");
INSERT INTO apr_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Ngan Yesu iraua torungu kidi nen, “Dook mata, bong nga bet atorang ye torungu kiau atu ngan. ");
INSERT INTO apr_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Oo, kawete! Yowan yo irriu di tooltool i, in sei ikaua gurana panga a le iyei urata ki nga? Gurana tani in ipa ye Maro yo inepe ye malala ki ete ni, too ipa ye di tooltool leu?” ");
INSERT INTO apr_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Motong la di tooltool tina ngan sila di tapdi tiwetewete nen, “Ona! Kumata le tawete bet Maro yo inepe ye malala ki ete ni, in la ikaua gurana pang Yowan in nga, ngan ole itoridi nen. Iyei ne, ‘Ngan nga gelei a le katara lomu medana ye betanga ki tiap nga?’ ");
INSERT INTO apr_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Bong kumata le tawete bet di tooltool ke tana i leu la tikaua gurana pang Yowan nga, ngan o dook mata tiap lapau. Ole di tooltool nga tikap pat a tikatmatamatidi ye, yesoo di le imot nga, ngan lodi mede bet Yowan in Maro koonoo atu.” ");
INSERT INTO apr_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Ngan nen le tiraua torungu ki nen, “Am nga lomam galanga tiap ye sei imalum pang Yowan a le iyei urata ki i.” ");
INSERT INTO apr_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Motong la Yesu iyei ne, “Nen ngan au lapau, o ke bet awete pang ye sei tool yo ikaua gurana pau a le ayei urata nen ye i, in tiap.” ");
INSERT INTO apr_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Yesu iwetewete pang di tooltool maimai kidi Yuda tina, ngan nen a imot. Motong la iportak pang ye di tooltool malala mai tina, inbe ikatte betanga atu mulu pang di. Iyei ne, “Tool atu in ipe ooroo yo ene wain in kumu atu. Motong la itara kumu tani in lo di tooltool ke kapgingi pattu bedi a bet matadi kala, inbe tiyei urata ye. Inbe ye taunu imadit a igege malala ki a la inepe kaiye ye malala san. ");
INSERT INTO apr_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Ila inepe nango, inbe tilo ye lal yo bet tigogo ooroo puana ye i, motong la tool tani in iwanga kapraingi ki atu a ila pang ye di tooltool yo matadi kala kumu ki nga. Ngan iwanga bet la iwete pang di, a nen ngan la tikap wain puana sa ye kumu ki tani, in panga. Bong ngan di tooltool ke kapgingi tina ngan tirauu, inbe tinganga a ipa bene koonoo a ila. ");
INSERT INTO apr_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Motong la kumu taunu tani in iwanga kapraingi ki san mulu a ila. Bong ngan di tooltool tina ngan tiraua kapraingi tani a tiyei dada dook tiap panga a tipammoo, inbe ipa bene koonoo lapau a ila. ");
INSERT INTO apr_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Motong la kumu taunu tani in iwanga kapraingi yo tol ki i, in mulu a ila. Bong ngan le di tooltool tina ngan tirauu a tigarungu tinini le dook tiap yege, inbe tikatte du ke diki. ");
INSERT INTO apr_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","“Motong la kumu taunu tani in lon wete nen, ‘Ona tiap! Nga ole ayei balai na? Dookoot, nga ole awanga natuk tamoto yo lok panga mai san i a ila. Kumata le ayei nen nga, ngan la bet ole tiraua panga nga.’ ");
INSERT INTO apr_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","“Bong ye kene yo di tooltool ke kapgingi tina ngan tikamata ye in nga, ngan di tapdi tiwetewete nen, ‘Kakamata, kumu taunu tani in natunu la iman i. Kumata le bet pang dama ni nga, ngan ole ikolo tamana ye kumu i a iyei kumu taunu. Le kaman a taraumate le imata, a bet nen ngan so yo tamana bet ikap panga nga, ngan takap le imot paidi.’ ");
INSERT INTO apr_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Le nga tila tikauu a tiyolle a tikatte du ke diki, inbe tiraumate le imata.” Yesu iwete pang di nen a imot, motong la itor di nen, “Ngan nen le kumu taunu tani in ole iyeie soo so pang di tooltool ke kapgingi tina? ");
INSERT INTO apr_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Ye in ole iman man iraumatamata di tooltool tina le imot, inbe itara kumu tani in lo di tooltool kapala bedi a nen ngan matadi kala.” Ngan yeiso bet di tooltool tina tilongo yo Yesu iwete nen nga, le nga tiyei ne, “Ona tiap! Ken iyei urata nen be!” ");
INSERT INTO apr_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Motong la Yesu matana pang ye di tooltool tina, inbe itor di nen, “Betanga ke Maro yo tiwodo lo ye rau nga, ngan punu balai? Ngan betanga tina ngan iwete nen, ‘Pat yo di tooltool ke renge rumu lodi panga tiap a tisukraii i, in la iyei pat dook mata yo bet ipamede rumu le imede i.’ ");
INSERT INTO apr_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Ngan di tooltool tina le imot yo bet timol le du tirau di pang ye pat i nga, ngan ole turadi bokobokobe le morrana. E bet pat tani in imol le du ikata tool sa nga, ngan ole igarungu tool tani le dook tiap yege.” ");
INSERT INTO apr_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Yesu iwete nen, ngan di tooltool maimai ke paroranga so pang Maro tiye di pannoongoo ke wer ke Maro nga, ngan lodi galanga nen bet nga ikatte betanga ye di. Le nga lodi bet le tikauu ye kene tani in a tiparama, bong ngan titattadai di tooltool yo man tigaua nga. ");
INSERT INTO apr_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Motong la di tooltool kuto maimai ke paroranga so pang Maro, tiye di pannoongoo ke wer ke Maro tina ngan tiwanga di tooltool kidi pattu a bet lo tigoigoi ye Yesu. Di ngan tillung bet lo tilongo betanga ki, inbe titar talngadi ye, a bet nen ngan Yesu iwete le bet koon kapsap ye betanga sa nga, ngan ole la tillaikoodi pang di tooltool maimai tina ye betanga ki, a bet nen ngan tikauu la titaru lo tool kuto mai yo matan kala malala mai Yudia i, in bene. ");
INSERT INTO apr_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Le nga tilo, motong la tiwete pang Yesu nen, “Pannoongoo! Am nga lomam galanga bet betanga kiong yo kuwetewete a kupatomonai di tooltool ye nga, ngan igalanga le imot. Le betanga kiong yo kuwete pang di tooltool yo edi maimai, inbe edi maimai tiap nga, ngan gaongo leu. Inbe kupatomonai di tooltool ye dada moolmool yo ke Maro ngan le imot. ");
INSERT INTO apr_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Ngan la bet amtorong nga, ong i lom balai? Nga dook mata bet ole am tooltool ke Yuda nga amtar pat pang tool kuto mai kidi Rom yo Sisa i, too tiap?” ");
INSERT INTO apr_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Bong ngan Yesu lono galanga yo di tooltool tina ngan tikapge bet tillungu, ngan oo. Le nga iwete pang di nen, ");
INSERT INTO apr_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Kapitnaia pat silba ngan atu a akamata.” Le nga tipitnaia pat tina ngan atu pang Yesu a ikamata, motong la itor di nen, “Sei kannungana inbe ene iken ye pat i nga?” Ngan tiyei ne, “In Sisa.” ");
INSERT INTO apr_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Motong la iwete pang di nen, “Aoo, ngan dook mata! Bet so ke Sisa, ngan kakap pang Sisa. E so ke Maro, ngan kakap pang Maro.” ");
INSERT INTO apr_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Le nga di koi ki tina ngan titakrai ye betanga yo Yesu iraua betanga kidi ye i. Le tiwete toko betanga siap, sila tiwur inbe tipas le tipalongo leu. Yesoo bong taukadi dada yo bet tikaua llungunu ye Yesu, a nen ngan ikapsap ye betanga sa ye di tooltool matadi nga. ");
INSERT INTO apr_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Motong la di Sedusi pattu timan pang ye Yesu bet man titoru. Ngan di Sedusi tina, ngan di Yuda pattu yo tiwete bet di tooltool timmata nga, ngan o ke bet timadit mulu tiap. Le nga man titoro Yesu nen, ");
INSERT INTO apr_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Pannoongoo, mugu ngan Mose iwodo betanga atu bet tatoo in nen. Kumata le tool atu bet ikere le rimana ipasuiu kan kase siap, inbe tamoto tani in imata nga, ngan taini ole ikoli a iyooloo tap ke toonoo, a bet nen ngan garup tani in ipasui kase sa panga nga, ngan ole iseke rara ke toonoo tani in pang dama a ila. ");
INSERT INTO apr_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Mose iwete paidi nen, bong amtorong, ole kuwete balai? Oo, tool atu in natunu tamoto limi be ru. Ngan tinepe, le nga toodi yo mumuganga i, in iyooloo garup atu, bong rimana tani in ipasuiu kan kase siao, inbe imata. ");
INSERT INTO apr_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Motong la taini yo itoo in ikoli a iyooloo tap ke toodi tani. Bong ngan rimadi tani in ipasuiu kan kase siao, inbe imata lapau. ");
INSERT INTO apr_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Motong la taidi yo tol kidi i, in itoo di toonoo a iyooloo tap kidi tani in lapau. Ngan di tamoto tina yo limi be ru nga, ngan titoo dada gaongo leu, ngan le taukadi natudi, inbe di le imot timmata a tila. ");
INSERT INTO apr_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Motong la garup tani, in imata lapau. ");
INSERT INTO apr_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Ngan nanga, kuwete pam ngan, ye lal yo bet di tooltool matedi bet timadit mulu nga, ngan garup tani in ole iyei sei rimana? Yesoo, di tamoto tina yo limi be ru nga, ngan di le imot tiyooloo garup tani in oo.” ");
INSERT INTO apr_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Motong la Yesu iraua betanga kidi nen, “Di tamoto le garup yo ke dookoot nga, ngan ole tikere. ");
INSERT INTO apr_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Bong pang dama ni nga, ngan di tooltool yo Maro lono pang di mai san inbe ipamadit di ye ni ke matenge a bet lo iye di tinepe gaongo ye malala ki nga, ngan o ke bet tikere mulu tiap. ");
INSERT INTO apr_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Di tooltool tina ngan ole tinepe ben di bangabangana ke Maro nga, le o ke bet timmata mulu tiap. Inbe di ngan ole tiyei ben Maro di natunu moolmool nga, yesoo ipamadit di ye ni ke matenge le se tinepe ye nepongo dook mata yo taukan motingi i. ");
INSERT INTO apr_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Ngan Mose iwodo betanga nen ye kene yo Maro ye taunu ipitnaii panga ye ei loloana yo lo ikan ye kai mai tiap i. Ngan Mose tani bet iwete paidi nen, yesoo ye kene tani in Maro iwete panga nen, ‘Au i Maro ke Awaram ye Esaka inbe Yakop.’ Ngan nen le Mose bet ipapos paidi ben di tooltool yo timmata koot nga, ngan ole timadit mulu. ");
INSERT INTO apr_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Le Maro i, Maro kidi tooltool yo timmata koot nga, ngan tiap, bong Maro kidi tooltool yo tinepe maguredi nga.” ");
INSERT INTO apr_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Yesu iwete nen, motong la di pannoongoo ke wer ke Maro pattu tiwete panga nen, “Ona, pannoongoo! Betanga kiong yo kuwete nga, ngan dook mata san.” ");
INSERT INTO apr_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Ngan le ye kene tani in a ilo nga, ngan tool sa mulu mala bet itoro Yesu ye betanga sa mulu, ngan tiap. ");
INSERT INTO apr_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Motong Yesu itor di kuto maimai tina ngan nen, “Ai, nga gelei a le di tooltool tiwete bet Kirisi in Dawiti natunu nga? ");
INSERT INTO apr_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Ngan awete pang nen, mukot yege ni nga, ngan Dawiti ye taunu iwodo betanga ki ilo ye rau yo ene Rau ke Woungu in nen: ‘Maro yo Tool Mai i, in iwete pang Tool Mai kiau nen, “Kuwur ye bek oonoo a kunepe nen ");
INSERT INTO apr_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","le lo arautoo di koi kiong a tidu tinepe ke kem parmana.” ’ ");
INSERT INTO apr_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Le kakamata, Dawiti ye taunu la iweta ye Tool Mai ki i. E nga gelei a di tooltool tiwete bet ye in Dawiti natunu nga?” ");
INSERT INTO apr_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Di tooltool malala mai tina ngan titar talngadi go pang Yesu ye betanga yo iwetewete nga, inbe iportak a iwete pang di galiunu. Iyei ne, ");
INSERT INTO apr_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Ken kakaptutang dook leu ye di pannoongoo ke wer ke Maro nga. Di ngan lodi bet tisousou ye sousoungu mooloo mooloo kidi yo pat ki mai san nga, inbe tipa mallangana ye ni ke yawaringi so, a bet nen ngan di tooltool bet tikamata di ngan tiwete lo ponana kidi pang di. Inbe di ngan kumata bet tilo ye rumu kidi Yuda ke gaongo in lono nga, ngan lodi bet lo tiwur ye kakawa ke burungu yo iken ke dama nga, inbe kumata bet tila ye mailang nga, ngan lodi bet lo tiwur ye kakawa kidi tooltool yo edi maimai nga. ");
INSERT INTO apr_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Inbe di ngan tikaua llungunu ye di garup yo tap nga a tipinau rumu le so kidi. Inbe kene yo bet tipatarau ye in nga, ngan tiyolo pataraungu kidi le mooloo san. Ngan di tooltool tina yo nen nga, ngan ole Maro iyemenai di le dook tiap yege.” ");
INSERT INTO apr_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Motong la Yesu bet matan gaga a matan la ngan ikamata di tooltool ballingadi yo titartar pat kidi lo ye depe ke tarungu pat ke bareme mai ke sungunu nga, ");
INSERT INTO apr_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","ngan le ikamata garup tap atu lapau. Ngan ye in ballingana tiap, le la itar pat maitiap kooroonoo ru leu la ilo ye depe ke tarungu pat tani nga. ");
INSERT INTO apr_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Yesu ikamata garup tap tani, le taun imadit le iwete nen, “Awete pang moolmool nen, garup tap i ballingana tiap, bong itar pat mai san le illos pat yo di tooltool kapala titar nga, ");
INSERT INTO apr_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","yesoo, di ngan tooltool ballingadi le pat kidi alunu san, bong titar mai tiap. Ngan garup i ballingana tiap, bong ye in iraia lono bet itar pat ki tina yo bet iyimi kaningi panga ye nga, ngan le imot a ilo ye depe ke tarungu pat.” ");
INSERT INTO apr_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Yesu di galiunu pattu tiparwetewete ye bareme mai ke sungunu yo tikamata, ngan dook mata san ye pat yo tire ye nga, inbe ye so dook mata kapala yo di tooltool tikap a man timoromoro bareme tani ye nga. Bong ngan Yesu iwete pang di nen, ");
INSERT INTO apr_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Awete pang nen, pat le so tina yo dookoot kakamata ngan iken dook mata ye bareme mai ke sungunu i, bong lal atu yo bet pang dama ni ngan pombe i, ngan ole pat tina ngan atu sa yo bet iloko lo ene pono dawa ben dookoot nga, ngan tiap. Bong ole tiraukedekede di le imot a timol du tana le tiken kidi kidi.” ");
INSERT INTO apr_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Le nga di tooltool tina ngan titoro Yesu nen, “Pannoongoo, ole soo lal bet so tina ngan pombe ye i? Inbe soo tarkilanga bet amkamata mugu, ngan lomam galanga ben so tina ngan ole pombe moolmool ye i.” ");
INSERT INTO apr_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Motong la Yesu iyei ne, “Ken kakamatang dook leu, le ken tool sa ikap llungunu yang be. Yesoo, di tooltool alunu ole timan pang yang man tipootoo ek, inbe tiyei ne, ‘Au tool tani naii!’ Inbe ole tiyei ne, ‘Lal tani in iman potai oo.’ Bong ken kalongo betanga kidi a katoo di be. ");
INSERT INTO apr_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Kumata ye kene yo bet kalongo bingi ke patokongo mai, inbe talngamu rau bet di tooltool ke tana mai atu bet tiparsu ye betanga sa le bet tiye di diedi tipatoko nga, ngan ken katattadai be! So tina yo nen nga ole pombe moolmool mugu, bong so yo awete pang ye nga, ngan lal ki o pombe tiao.” ");
INSERT INTO apr_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Motong la Yesu iwete pang di mulu nen, “Ngan di tooltool ke tana mai atu ole timadit a tiye di tooltool ke tana mai san tipatoko. Inbe di tooltool ke tool kuto mai atu ole timadit a tiye di tooltool ke tool kuto mai san tipatoko. ");
INSERT INTO apr_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Inbe nauningi mai ole itak ye tana i, inbe pitolo mai ole pombe, inbe matamatenge maimai ole pombe ye malala kapala a igarung di tooltool lapau. Inbe matamu pang lang katene nga, ngan ole kakamata mos matana matana pombe, a bet nen ngan iyei di tooltool a titattadai le dook tiap yege. ");
INSERT INTO apr_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Bong so tina ngan le imot ole pombe tiao, inbe di koi kiau ole tikamatang yo katoo au nga, ngan ole tikau ang a tiparamang a tigarungang. Inbe ole tikau ang sa lo kakodo ye ni ke karatanga betanga ye rumu kidi Yuda ke gaongo in lono, inbe titarang lo kanepe rumu dook tiap kidi talnga dikidiki lono. Inbe ole tikau ang sa lapau lo kakodo dama kidi tooltool kuto maimai yo matadi kala tana mai kiang nga, inbe di tooltool maimai yo matadi kala malala kiang nga, ngan matadi, yesoo ye yo ang ngan katoo au nga. ");
INSERT INTO apr_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Ngan dada tina yo tiyei pang nen nga, ngan bet nen a tiso dada pang bet kawetewete bingi dook mata kiau pang di. ");
INSERT INTO apr_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Le ken lomu madoko ye betanga yo bet kawete a karau betanga kidi ye, ngan be, ");
INSERT INTO apr_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","yesoo bong au tauk ole atar betanga dook mata yo bet kawete ngan lo lomu, inbe akaua lo galanga dook mata yo bet karau betanga kidi ye i, in pang. Ngan nen le di koi kiang tina ngan o ke bet tiwete bet nga kallung, a bet nen ngan tirautoo betanga kiang tina yo kawete nga, ngan tiap. ");
INSERT INTO apr_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Inbe ye kene tani in, ole di tamamu le tinamu, tiye di toomu le taimu, inbe di sogamu le di tooltool kiang ole katedi malmal pang a titarang la di koi kiang bedi, inbe tiraumatamatang kapala a kammata. ");
INSERT INTO apr_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Ngan di tooltool le imot ole tiyei koi pang a bet tigarungang, yesoo ang ngan katara lomu medana ye betanga kiau inbe katoo au. ");
INSERT INTO apr_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Bong kutomu raunu tina le imot nga, ngan o ke bet atu sa ilene tiap. ");
INSERT INTO apr_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Ngan nen le kakodo le kamede dook ye betanga ke Maro, ngan la bet ole kakaua nepongo dook mata yo taukan motingi in nga.” ");
INSERT INTO apr_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Motong la Yesu iwete pang di mulu nen, “Ye kene yo bet kakamata di tooltool ke patokongo nga bet man tikodo le tiwakaia malala mai Yerusalem nga, ngan ole lomu galanga nen, lal yo bet man tigarungu malala mai tani in ye i, in o potai oo. ");
INSERT INTO apr_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Le bet kakamata so nen pombe nga, ngan ang tooltool yo kanepe ye tana mai Yudia nga, ngan kakoo tarrai a kalo pang kawal. Inbe ang tooltool yo kanepe malala mai tani in lono nga, ngan kapas a kadu ke diki. Inbe ang tooltool yo kanepe ke diki nga, ngan ken kalo pang malala mai tani, in lono be. ");
INSERT INTO apr_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Awete pang nen, yesoo ye kene tani in lal ke Maro bet iyemenai di tooltool ke Isrel tina yo tiwala muridi panga nga. Ngan so tina ngan ole kanono pombe moolmool ben tina yo mugu ngan di Maro koonoo tiwodo betanga ki ilo ye rau nga. ");
INSERT INTO apr_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Ye kene tani in di garup yo kapodi nga, inbe di garup yo tiyei borrenge ye di natudi a tipayinin di nga, ngan barau, ole imoo pang di yo bet tikoo nga. Ngan awete nen, yesoo urata dook tiap ki taunu la bet pombe ye tana i, inbe Maro ole ipaposo kate malmal ki yo bet igarung di tooltool tina yo tiwala muridi panga nga. ");
INSERT INTO apr_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Ngan di koi kidi Yuda tina, ole timan man tirau di a titaramatamata di kapala ye pul ke patokongo. Inbe di Yuda tina ngan kapala ole tikap di a tiparama di a la titar di ye tana maimai kapala. Inbe di tooltool yo tipa ye rara kidi Yuda tiap nga, ngan ole timan man tidada di tooltool tina yo ke Yerusalem nga, ngan podi le ilo ye lal yo Maro itaru pang di bet urata kidi tani yo tiyeii i, in imot ye i.” ");
INSERT INTO apr_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Motong la Yesu iwete pang di mulu nen, “Ye kene tani in nga, ngan ole tarkilanga matana matana la bet pombe ye ke le taudu inbe ye di kanpitiki nga. Inbe ye tana mai i nga, ngan di tooltool ke ni mai i le imot ngan ole titattadai inbe lodi sakarungu dook tiap ye yo tilongo mununu ke dugu yo iyit le ilo ete ni a popobe nga. ");
INSERT INTO apr_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Ngan Maro ole itak so yo ke lang katene nga, a bet nen ngan di tooltool tikamata ngan ole lodi galanga ye so dook tiap tina yo bet pombe ye tana i nga. Ngan nen le di tooltool tina kapala ole titattadai ye yo tikamata so nen nga, ngan ole matadi taltalai a timol du tiken tana. ");
INSERT INTO apr_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Inbe ye kene tani in nga, ngan di tooltool ole tikamata Tool Moolmool ke Maro inepe ye eng tene, inbe ipa ye gurana ke Maro inbe lulngana maiyoko a isi. ");
INSERT INTO apr_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Le ye kene tani yo kakamata so tina ngan bet pompombe ye in nga, ngan kamadit le lo kakodo, inbe katada pang ete. Yesoo, lal tani yo Maro bet ikau ang a ipamulang ye i, in isi potai oo.” ");
INSERT INTO apr_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Yesu iwete pang di nen a imot, motong ikatte betanga atu pang di. Iyei ne, “Ai, matamu too ye kai pik, inbe ye kai yo kapala nga le imot lapau. ");
INSERT INTO apr_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Ye kene yo kakamata di kai tina ngan bet suddadi pompombe ye bedi a titar raudi paunu nga, ngan ole lomu galanga nen, rai mai o potai oo. ");
INSERT INTO apr_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Ngan gaongo leu, ye kene yo bet kakamata so tina nga bet pompombe ye in nga, ngan ole lomu galanga nen; mooloo tiap, inbe dada yo Maro bet matan kala di tooltool ki ye i, in ole si pombe mallangana. ");
INSERT INTO apr_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“Awete pang moolmool nen, di tooltool yo dookoot tinepe matadi rerene go nga, ngan ole timmata tiao, inbe so tina le imot yo awete pang ye nga, ngan ole pombe. ");
INSERT INTO apr_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Lang le tana nga ole tilledi, bong betanga yo kiau nga, ngan o ke bet kasin pa ilene, ngan tiap.” ");
INSERT INTO apr_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Motong la Yesu iyei ne, “Ngan nanga, ken kakap tutang dook leu. Le kaningi yo bet kakan, inbe ran yo bet kayin nga, ngan ikap matamu mata be. Inbe ken lomu madoko mata ye nepongo kiang ke tana i lapau be. Ngan kumata le so yo nen ngan bet ikap matamu mata nga, ngan lal ke Tool Mai tani in ole pombe pang yang le ipatakrai ang, ");
INSERT INTO apr_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","dawa ben di asara yo lodi galanga ye dowo tiap le la titingi ye nga. Ngan awete pang nen, yesoo lal tani in ole pombe pang ye di tooltool yo tinepe ye tana mai i le imot nga. ");
INSERT INTO apr_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Ngan nanga, kanakana ngan ang tapmu kakauwai yang dook, inbe kakodo le kamede ye pataraungu pang Maro. Ngan la bet lal ke so dook tiap tina ngan bet pombe nga, ngan o ke bet igarungang tiap. Inbe kapatarau ye lal yo bet Tool Moolmool ke Maro isi bet si ikarata betanga kidi tooltool ye in nga, ngan ole ang le imot lo kakodo dama ki, ngan o ke bet moomoomu ye tiap lapau.” ");
INSERT INTO apr_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Yesu iwete nen a imot, motong la ye ke kanakana nga, ngan ole ilo koongoo lono ke bareme mai ke sungunu, inbe ipatomonai di tooltool. Inbe ye rrai kanakana nga, ngan ole ipa a ilo ye kawal yo ene Olip i, a lo bong ngan iken nango. ");
INSERT INTO apr_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Inbe ye muntu kanakana nga, ngan ole di tooltool malala mai timadit muntu bongmai koot a tilo koongoo lono ke bareme mai ke sungunu a lo titar talngadi ye patomonaingi ke Yesu. ");
INSERT INTO apr_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Lal maiyoko kidi Yuda yo bet tikana porong yo taukan so bet iyeii a isung i, inbe lodi tut ye Paskimoolooningi ke Maro i, in dookoot nga iman potai oo. ");
INSERT INTO apr_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Ye kene tani in di tooltool maimai ke paroranga so pang Maro tiye di pannoongoo ke wer ke Maro nga, ngan ke bet tikaua Yesu mallangana ye di tooltool tina ngan matadi tiap, yesoo titattadai di. Le nga tigaua, inbe tisere dada yo bet tikauu a tiparama, a bet nen ngan tiraumate le imata ye i. ");
INSERT INTO apr_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Motong la tool dook tiap Satan, in idiwidiwi Yuta yo tikiui ene san ye Iskariot i, in lono. Ngan Yuta tani, in Yesu di galiunu tina yo sangaul be ru nga, ngan atu kidi. ");
INSERT INTO apr_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Motong la Yuta tani in ilo ikamata di tooltool maimai ke paroranga so pang Maro nga, ngan tiye di tooltool kuto maimai yo matadi kala di gaunu yo tikodo kala bareme mai ke sungunu nga, a bet lo iye di tiwetewete, inbe tikarata betanga ye dada yo bet itara Yesu tani in la bedi ye i. ");
INSERT INTO apr_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Ngan tilongo tina yo iwete nen nga le lodi ponana dook, motong la tigaua lodi bet ole tikap pat pattu panga. ");
INSERT INTO apr_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Le nga Yuta tani in lono dook mata ye betanga kidi le la inam, inbe lon kaua urata ye lal nangai dook mata ke bet di tooltool malala mai tina ngan tinepe tiap, inbe itara Yesu la bedi nga. ");
INSERT INTO apr_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Motong la lal maiyoko tani kidi Yuda yo bet tikana porong yo taukan so bet iyeii a isung i, inbe lodi tut ye Paskimoolooningi ke Maro, in pombe. Le nga ye kene tani in, ngan ole di Yuda tina bet tiraumata asara yo ene sipsip in natunu a bet tiyei paroranga ye a tikan ye lal ke Paskimoolooningi tani. ");
INSERT INTO apr_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Motong la Yesu iwanga Pita ye Yowan bet yeru timugu la tipare kaningi pang di. Le nga iwete pang di nen, “Suru, nga ole angru kamugu a kala la kapare kaningi paidi yo bet takan ye lal ke Paskimoolooningi ke Maro i nga.” ");
INSERT INTO apr_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Motong la yeru titoro Yesu nen, “Ni nangai lom bet la ampare kaningi tina ngan ye i?” ");
INSERT INTO apr_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Motong la Yesu iwete pang di yeru nen, “Kumata bet angru kapa le lo pombe malala mai tani in lono nga, ngan ole tamoto atu yo isolo ran bor somai in itauarai ang dada. Ngan katoo a kaye kalo pang ye rumu yo bet lo idewoo i. ");
INSERT INTO apr_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Ngan kalo, lo ngan bet katoro rumu taunu nen, ‘Pannoongoo kiam iwete bet man amtorong nen: Rumu lono yo kukarata panga bet se iye di galiunu tinepe ye, inbe tikana kaningi ke Paskimoolooningi ke Maro ye i, in la nangai i?’ ");
INSERT INTO apr_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Ngan ole rumu taunu tani in ipitnaia rumu lono somai atu yo iken ke ete i, in pang. Ngan rumu lono tani in tikarata kakawa ke burungu le ke kaningi so ye oo. Lo ngan bet angru kalo lo kapare kaningi nango.” ");
INSERT INTO apr_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Motong la di galiunu ru tina ngan tigege di a tilo nga, ngan le lo tikamata so tina le imot ngan pombe ben tina yo Yesu iwete pang di ye nga. Motong la yeru tipare kaningi yo bet tikan ye lal ke Paskimoolooningi ke Maro nga. ");
INSERT INTO apr_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Ngan lal ke kaningi so pombe, le nga Yesu iye di aposol ki tina ngan lo tiwur le tiwakaia kakawa yo ke kaningi so i. ");
INSERT INTO apr_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Motong la Yesu iwete pang di aposol ki tina ngan nen, “Au i lok dook mata san bet le ayang takana kaningi ke Paskimoolooningi ke Maro i, mugu ngan, lo ngan bet asolo urata moonoo dook tiap ke masngana kooti. ");
INSERT INTO apr_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Awete pang nen, yesoo au i o ke bet akana kaningi ke Paskimoolooningi ke Maro tani in mulu tiap, le ilo ye lal yo Maro itaru bet matan kala di tooltool ki ye i, in pombe. Ye kene tani in, ngan la bet Maro ole ipitnaia Paskimoolooningi tani, in punu le iken mallangana pang nga.” ");
INSERT INTO apr_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Motong la ikaua ruku atu a iwete lo ponana ki pang Maro ye, inbe iyei ne, “Kakaua ruku i a ang le imot kasuketketi kataunu yang, inbe kayin ran ki nga kasin kasin. ");
INSERT INTO apr_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Awete pang nen, yesoo au i o ke bet ayin ooroo surunu mulu tiap, le ilo ye lal yo Maro bet matan kala di tooltool ki ye i.” ");
INSERT INTO apr_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Motong la Yesu ikaua porong atu a iwete lo ponana ki pang Maro ye, inbe itepalapala a ikap pang di galiunu tina, inbe iwete pang di nen, “Bi, i au medak la akauu pang i. Le ole kakani a bet nen ngan lomu tutu matenge kiau ye.” ");
INSERT INTO apr_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Ngan tikana porong tani a imot, motong la itoo dada gaongo leu ye ruku. Le iwete nen, “Ooroo wain surunu yo iken ruku i lono nga, ngan rara kiau yo bet apamede betanga medana paunu pang ye i. Ngan la le apatioo bet nen a Maro ilonang ye. ");
INSERT INTO apr_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Bong kakamata! Tool yo bet itarau la di koi kiau bedi i, in ye la amru amkan so gaongo ye kakawa ke kaningi so i. ");
INSERT INTO apr_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Ngan nen le Tool Moolmool ke Maro ole itoo dada tani yo mugu ngan Maro iweta a itaru panga i. Bong barau, tool yo bet itara Tool Moolmool ke Maro la di koi ki bedi i, in ole isolo masngana mai le masngana mai ki taunu.” ");
INSERT INTO apr_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Yesu di galiunu tina, ngan tilongo yo iwete nen nga, le nga di tapdi tipartortor nen, “Ai, in sei kiidi bet iyeie dada nen i?” ");
INSERT INTO apr_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Motong la ye kene tani in Yesu di galiunu tina ngan di tapdi tiparsu ye betanga kataunu ye di, bet ole sei tool iyei kuto mai a imugu pang di i. ");
INSERT INTO apr_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Le nga Yesu iwete pang di nen, “Ai, di tooltool kuto maimai ke di tooltool yo tipa ye rara kidi Yuda tiap nga, ngan tikodo le timede ye gurana kidi, inbe tidada di tooltool kidi podi. Inbe di tooltool tina yo gurana kidi mai le di diedi tinepe parmadi nga, ngan di tapdi lodi bet di tooltool tikiu di ye ‘Di Tooltool ke Maroro.’ ");
INSERT INTO apr_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Bong ang nga, ken kayei nen be. Le kumata tool atu kataunu yang lono bet iyei tool mai le imugu pang nga, ngan ole ye taunu irautoo le idu meneng lopo yege ni, dawa ben tool kase yo taukan ene i. Inbe kumata le tool atu lono bet iyei tool kuto mai a bet matan kalang nga, ngan ole iyei ben kapraingi kiang. ");
INSERT INTO apr_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Nga bet atorang, sei tool ene mai i, tool yo iwur ye kakawa ke kaningi so i, too tool yo iso kaningi a ikap la irai di tooltool yo tiwur ye kakawa ke kaningi so i? Ngan tool yo ene mai i, in tool tani yo iwur ye kakawa a bet ikan so i. Bong au i dookoot ayang tanepe nga, ngan ayei dawa ben kapraingi kiang, a bet nen ngan alonang. ");
INSERT INTO apr_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Mugu ngan ayang tanepe, inbe moonoo matana matana la pompombe pang yau nga, bong ngan le kakoo yau tiap. ");
INSERT INTO apr_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Ngan nen le ben tina Tamak imalum pau le itarau bet ayei tool kuto mai a matak kala so nga le imot nga, ngan la au lapau amalum pang le ole atarang bet kayei tooltool kuto maimai nen lapau. ");
INSERT INTO apr_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Ngan nanga, kumata le pang dama ni bet ayei tool kuto mai a matak kala so nga le imot nga, ngan ole ayang tawur le tawakaia kakawa kiau ke kaningi so a takan be tayin, inbe ole lo kawur ye kakawa ke burungu ke di tooltool kuto maimai, a bet nen ngan matamu kala di rara ke Isrel yo sangaul be ru nga.” ");
INSERT INTO apr_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Motong la Yesu iwete pang Simon nen, “Simon, Simon, kupalongo! Satan itor bet ole itou ang atu atu ye lo medana kiang, dawa ben tool ke kapgingi bet itaurai dingding patunu a bet kulini ikoo ye kanono nga. ");
INSERT INTO apr_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Bong ngan Simon, au i apatarau yong oo, a bet nen ngan lo medana kiong yo kutaru pau i, in ilene le ipa so be. Ngan nen le ye kene yo bet kuportaka lom mulu pau ye in nga, ngan kupamede di diem kapala yo titara lodi medana pau nga, ngan lodi, a bet nen ngan tikodo le timede lapau.” ");
INSERT INTO apr_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Motong la Pita iyei ne, “Tool Mai, au i araia lok bet ole titaridi aru lo rumu dook tiap kidi talnga dikidiki lono, a bet nen ngan aru le ru bet tammata.” ");
INSERT INTO apr_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Motong la Yesu iraua betanga ke Pita nen, “Atoo, Pita! Awete pong nen, dookoot bong katai nga, ngan ole tareke itang tiao, inbe kupataukala a kuwete le patol bet ong i lom galanga yau tiap.” ");
INSERT INTO apr_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Motong la Yesu iwete pang di galiunu tina nen, “Ye kene yo awangang bemu koonoo a kala bet la kayei urata kiau ye in nga, ngan le kakap toko depe ke tarungu pat, le depe ke lonloningi, inbe loningi ke kemu ngan sa a kala tiap. Bong kene tani in le kamaka ye so sa lapau, too tiap?” Ngan le di galiunu tina tiyei ne, “Tiap.” ");
INSERT INTO apr_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Motong la iwete pang di nen, “Bong dookoot nga, tool bet depe ki ke tarungu pat, ngan ikauu. Inbe tool bet depe ki ke tarungu lonloningi nga, ngan ikauu lapau. Inbe kumata le tool bet taukan pul ke patokongo nga, ngan ole iyawara sousoungu matolene ki, a bet nen ngan ikap pat tina, inbe iyimi kan atu. ");
INSERT INTO apr_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Ngan awete pang nen, yesoo betanga yo tiwodo ilo ye Rau ke Maro nga, ngan iwete nen, ‘Di tooltool ole tikamata dawa ben ye in tool dook tiap atu.’ Le ole tiyei dada nen pau, yesoo so tina le imot yo tiwodo betanga ki lo iken ye Rau ke Maro nga, ngan ole kanono pombe pang yau moolmool le imot.” ");
INSERT INTO apr_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Yesu iwete pang di nen, motong la di galiunu tina ngan tiyei ne, “Tool Mai, kumata! Am nga pul kiam ke patokongo ngan ru nanga la ikenen nga.” Motong la iwete pang di nen, “Ngan dook mata.” ");
INSERT INTO apr_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Motong la Yesu igege malala mai tani, inbe ipa a ilo pang kawal Olip ben tina yo kanakana ngan iyei nga. Le nga di galiunu tina ngan titoo lapau a tiye tilo. ");
INSERT INTO apr_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Ngan tilo a lo pombe ye ni tani, motong la iwete pang di nen, “Ai, kapatarau, a nen ngan touanga sa bet pombe pang yang nga, ngan o ke bet kamol tiap.” ");
INSERT INTO apr_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Motong la igege di galiunu tina, inbe ipa le ila manga mooloo kasin, dawa ben manga yo tool atu bet ikat ye pat ngan le la pumbe ye i. Motong la du igun turunu, inbe ipatarau. Iyei ne, ");
INSERT INTO apr_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Tamak, kumata le lom dook mata nga, ngan kukutaka ruku ke masngana i yau. Bong ken kutoo au lok be, kutoo ong taum lom leu.” ");
INSERT INTO apr_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Yesu ipatarau nen, motong la bangabangana atu ke Maro ipa ye malala ke Maro a isi pombe pang ye a ipamede. ");
INSERT INTO apr_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Ngan Yesu ye taunu ikanamaii ngan lon madoko inbe tinin moo mai san, le nga ipatarau le gurana. Inbe sapirana yo irar ye tinini mai i le imot a imol du tana nga, ngan dawa ben rara patunu. ");
INSERT INTO apr_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Yesu ipatarau a imot, motong la imadit a imulu a ila pang ye di galiunu tina. Ila, ngan ikamata di yo tiken mata koot nga, yesoo bong lo madoko mai irau di le guradi tiap. ");
INSERT INTO apr_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Motong la iwete pang di nen, “Ai, nga gelei a kaken mata nga? Kamadit a kapatarau, a nen ngan touanga sa bet pombe pang yang nga, ngan o ke bet kamol tiap.” ");
INSERT INTO apr_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Yesu iwetewete nen go, inbe di tooltool malala mai tipa le lo pombe. Di tooltool tina ngan Yuta yo Yesu di galiunu tina yo sangaul be ru nga, ngan atu kidi i, in ye la irara di a tilo i. Le nga Yuta tani in ipa so le ila potai ye Yesu la iwarra, inbe isomo pangana. ");
INSERT INTO apr_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Motong la Yesu itoru nen, “Yuta, nga bet kutara Tool Moolmool ke Maro la di koi ki bedi, la le se kusomo pangana nen nga, too?” ");
INSERT INTO apr_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Ye kene tani in yeiso bet Yesu di galiunu tina ngan tikamata so tani yo bet pombe pang ye i, le nga tiyei ne, “Tool Mai, nga lom balai, bet amraumatamata di tooltool nga ye pul kiam ke patokongo nga, too?” ");
INSERT INTO apr_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Tiwete nen, motong la atu kidi iposo pul ki ke patokongo tina le itarakede kapraingi ke tool kuto mai ke paroranga so pang Maro, in talngana oonoo, le imakede. ");
INSERT INTO apr_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Bong ngan Yesu ikamata, le nga iyei ne, “Dookoot! Ken kuyei dada yo nen i, in mulu be.” Motong la Yesu itara bene ilo ye tool tani in talngana, ngan le talngana tani in dook mata mulu. ");
INSERT INTO apr_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Motong la Yesu iwete pang di tooltool maimai ke paroranga so pang Maro, tiye di tooltool kuto maimai yo matadi kala di gaunu yo tikodo kala bareme mai ke sungunu nga, inbe di tooltool maimai kidi Yuda yo timan bet man tikauu a tiparama nga, ngan nen. Iyei ne, “Ai, au i tool ke patokongo le pinnau la kakap pul le kai ke patokongo a kaman bet man kaparamau nga, too? ");
INSERT INTO apr_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Ye ke kanakana ngan ayang tanepe koongoo lono ke bareme mai ke sungunu nga, ngan lomu bet kakau au a kaparamau tiap. Bong dookoot, katai nga lal kiang, yesoo gurana ke todo in mai san, le idukang.” ");
INSERT INTO apr_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Yesu iwete nen a imot, motong la tikauu a tiparama, inbe tikauu a tiye tidu. Ngan tidu, motong la tikauu a tipa so le tilo rumu lono ke tool kuto mai ke paroranga so pang Maro. Ngan le Pita lapau itoo di a ilo, bong le ipa ben manga mooloo kasin. ");
INSERT INTO apr_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Ilo, ngan di tooltool pattu tipata ei ke koongoo lono ke rumu tani, inbe sila tiwur gaongo a ei loo di. Le nga Pita ila la iye di tiwur. ");
INSERT INTO apr_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Motong la garup nene atu yo iyei kapraingi i, in ikamata Pita tani yo iwurur ei loloana tani in gigini nga, le nga matan kenen ye le ikamata dook, motong la iyei ne, “Ai, tool in ye lapau iye Yesu tinepe.” ");
INSERT INTO apr_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Bong ngan Pita ipataukala, le nga iyei ne, “Atoo, garup, au i lok galanga ye tiap.” ");
INSERT INTO apr_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Ngan tinepe le mooloo tiap, inbe tool san mulu ikamata Pita le nga la iyei ne, “Ai, ong lapau, ong i di tooltool tina yo iye di tinepe nga, ngan atu la ong i.” Bong Pita iyei ne, “Atoo, tool kiau, au i tiap.” ");
INSERT INTO apr_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Le nga tinepe kasin mulu, motong la tool san mulu ikamata, le nga iwete katkat a iyei ne, “Moolmool sa, tool in ye lapau iye tinepe, yesoo ye in tool ke Galili.” ");
INSERT INTO apr_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Bong Pita iyei ne, “Atoo, tool kiau, au i lok galanga ye betanga yo kuwetewete ye, ngan tiap!” Ngan iwetewete nen go, le tina pattu leu inbe tareke itang. ");
INSERT INTO apr_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Motong la Tool Mai iportak a matan kenen ye. Le nga Pita tani in lon tut betanga tina yo mugu ngan iwete panga nga. Ngan Tool Mai iwete nen, “Dookoot bong katai nga, ngan ole tareke itang tiao, inbe kupataukala a kuwete le patol bet ong i lom galanga yau tiap.” ");
INSERT INTO apr_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Ngan nen le Pita ikoo a idu ke diki du itang belebele. ");
INSERT INTO apr_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Di tooltool tina yo matadi kala Yesu nga, ngan tipalele sere ye, inbe tirauu. ");
INSERT INTO apr_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Motong la tipaukala matana ye mala, inbe titoru nen, “Oo, bet ong i Maro koonoo moolmool nga, ngan kuwete too. I sei irau ong i?” ");
INSERT INTO apr_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Inbe di tooltool tina ngan tiwete betanga kapala yo dook tiap nga, ngan panga lapau. ");
INSERT INTO apr_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Ngan tinepe a muntu le nga ke ise, motong la di kuto maimai kidi Yuda nga, ngan tiye di tooltool maimai ke paroranga so pang Maro, inbe di pannoongoo ke wer ke Maro nga, ngan di le imot timan tigaua. Motong la tikaua Yesu a lo ikodo dama kidi ye ni ke karatanga betanga, inbe tiyei ne, ");
INSERT INTO apr_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","“Oo, kuwete pam ngan. Ong i Kirisi, tool tani yo Maro ipootoo bet si ikap di tooltool ki a ipamulu di i, too tiap?” Motong la Yesu iraua betanga kidi nen, “Kumata le awete pang nga, ngan ang nga o ke bet katara lomu medana ye betanga kiau tiap. ");
INSERT INTO apr_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Inbe kumata le bet atorang ye betanga sa nga, ngan o ke bet karaua betanga kiau tani, in tiap lapau. ");
INSERT INTO apr_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Bong awete pang nen, dookoot katai a ilo nga, ngan ole Tool Moolmool ke Maro iwur ye Maro yo gurana ki mai mata i, in bene oonoo.” ");
INSERT INTO apr_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Yesu iwete nen, motong la di tooltool maimai tina ngan di le imot titoru nen, “Ai, ngan nen le ong i o Maro Natunu, too?” Motong la iraua betanga kidi nen, “Ang tapmu bet kawete nen nga, ngan dook mata. I au tani naii.” ");
INSERT INTO apr_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Motong la di tooltool tina ngan tiyei ne, “Imot oo! Nga bet tasere di tooltool sa mulu bet man tipaposi paidi pang soo? Dookoot nga iwete a ipaposi ye betanga ki a talongo oo.” ");
INSERT INTO apr_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Motong la di tooltool maimai tina timadit a tikaua Yesu a tilo pang ye Pailot. ");
INSERT INTO apr_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Tilo, motong la tipatokode dama ke Pailot, inbe timadit a tisopo koodi panga nen, “Am nga amkaua tool i, yesoo igarung di tooltool kiam lodi ye betanga ki yo iwete nga, le bet titoo. Ngan ye in iwetekalam bet ken amtar pat pang Sisa be, inbe iwete bet ye in Kirisi, tool kuto mai yo bet matan kalam am Yuda nga le imot i.” ");
INSERT INTO apr_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Motong la Pailot itoru nen, “Oo kuwete, ong i la tool kuto mai yo matam kala di Yuda le imot i, too?” Ngan Yesu iraua betanga ki nen, “E, dawa ben tina la kuwete koot nga.” ");
INSERT INTO apr_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Motong la Pailot iwete pang di tooltool maimai ke paroranga so pang Maro nga, ngan tiye di tooltool malala mai tina ngan nen, “Au i apusye busunu sa yo tool i ikapsap ye, nga tiap.” ");
INSERT INTO apr_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Bong ngan di tooltool tina ngan di le imot tiwete le koodi mede. Tiyei ne, “Tiap, ye in ipa le iwakaia tana mai Yudia i le imot, inbe igarung di tooltool lodi ye patomonaingi ki. Ngan ye in imadit ye urata nen ye tana mai Galili, ngan la le ipa so le se pombe ni nga.” ");
INSERT INTO apr_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pailot ilongo tina yo tiwete nen nga, le nga itor di nen, “Ai, ngan tool i ke Galili, too?” ");
INSERT INTO apr_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Ye kene tani in Erot, yo iyei tool kuto mai pang Galili i, in inepe Yerusalem lapau. Le nga yeiso bet Pailot ilongo yo Yesu in tool ke Galili nga, motong la iwete a tikauu a ila pang ye Erot. ");
INSERT INTO apr_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Ngan kene tani in tikaua Yesu a tila la Erot ikamata, ngan le lon ponana mai san, yesoo bong ilongo bingi ki mukot, le itar matana ye bet ikamata pa, a bet nen ngan ikamata mos yo bet Yesu iyei nga. ");
INSERT INTO apr_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Le nga Erot tani in itor kaiye Yesu ye torungu alunu san, bong ngan Yesu irau toko torungu ki tina, ngan siap. ");
INSERT INTO apr_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Ngan di tooltool maimai ke paroranga so pang Maro, tiye di pannoongoo ke wer ke Maro nga, ngan tilo tikodo lapau, le nga tipamede betanga kidi a tikapge bet tiwetewete Yesu a tipaposi ye busunu ki. ");
INSERT INTO apr_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Motong la Erot iye di tooltool ki ke patokongo nga, ngan tipalele sere ye Yesu, inbe tikan paseme. Motong la tisousouu ye sousoungu sallinene dook mata ben ye tool kuto mai nga, inbe tikauu mulu a tila pang ye Pailot. ");
INSERT INTO apr_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Ngan mugu ngan Pailot iye Erot yeru ngan ben koi, bong ye kene tani in le yeru tigaua lodi dook mata san. ");
INSERT INTO apr_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Tipamulu Yesu a ila, motong la Pailot tani in ikiu di tooltool maimai ke paroranga so pang Maro tiye di kuto maimai yo matadi kala di Yuda nga, inbe di tooltool malala mai tina ngan di le imot timan tigaua, ");
INSERT INTO apr_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","inbe iwete pang di nen, “Ang nga kakaua tool i a imulu a iman pang yau, inbe kawete bet ye in igarung di tooltool lodi ye patomonaingi ki le bet titoo. Bong mugu ngan ang le imot kanepe, inbe atoru, ngan le apusye toko busunu sa yo ikapsap ye ben ang kawete nga tiap. ");
INSERT INTO apr_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Inbe Erot lapau ipusye toko busunu ki siap, ngan la le ipamule a iman pang yidi nga. Le kakamata, tool i iyei toko so sa yo dook tiap ke bet nen ngan imata ye, ngan tiap. ");
INSERT INTO apr_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","17","Le nga ole awete a tiwalisi leu, inbe titaru a ila.” ");
INSERT INTO apr_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Bong ngan di tooltool tina ngan le imot oorootang a koodi nen, “Kuraumata tool in a imata! Inbe kupadu Barabas a isi pang yam.” ");
INSERT INTO apr_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","(Ngan Barabas tani in titaru lo inepe rumu dook tiap kidi talnga dikidiki lono, yesoo ye kene in ipamaditi patokongo ye di tooltool kuto maimai ke malala mai tani in nga, ngan le iraumata tool atu a imata.) ");
INSERT INTO apr_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Ngan Pailot lono bet le ipadu Yesu a ila, le nga koonoo a isadaua di mulu. ");
INSERT INTO apr_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Bong ngan di tooltool tina ngan le imot koodi tootoo nen, “Kupatota lo kai palasingi kaini a imata! Kupatota lo kai palasingi kaini a imata!” ");
INSERT INTO apr_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Motong la Pailot iwete pang di mulu le patol ki nen, “Nga gelei? Soo dada dook tiap tool i ikapsap ye i? Au i apusye toko busunu ki sa yo ikapsap ye, a bet nen ngan imata ye, ngan tiap. Le nga ole awete a tiwalisi ye koro leu, inbe tiwulaii a ila.” ");
INSERT INTO apr_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Bong ngan koodi tootoo a timangmang ye Yesu bet tipatota lo kai palasingi kaini. Le nga di tooltool tina ngan di le imot oorootang le mai a tirautoo betanga ke Pailot. ");
INSERT INTO apr_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Motong la Pailot tani ilongo betanga kidi tina yo tiwete nen nga, le nga imalum pang di bet ole itoo betanga kidi. ");
INSERT INTO apr_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Motong la Pailot ipadu tool talnga dikidiki tani yo tisoror di Rom ngan tipatoko a iraumata tool atu le imata a titaru lo rumu dook tiap kidi talnga dikidiki lono i, in a idu pang ye di. Inbe Pailot isukete Yesu la di tooltool ke patokongo bedi, a nen ngan la tiyeie soo so yo di tooltool tina ngan lodi bet tiyeii panga i. ");
INSERT INTO apr_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Di tooltool ke patokongo tina ngan tikaua Yesu a tila dada nga, ngan le la tikamata Simon ke malala mai Sairini yo ipa ke ni san a iman a bet ilo pang malala mai tani in lono i. Motong la tiparama a tipaloko kai palasingi ke Yesu tani in lo poopoonoo, inbe tiwete panga bet isola a itoo Yesu. ");
INSERT INTO apr_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Inbe di tooltool malala mai tiye di garup pattu yo tipododo katedi inbe titangtang a tititit ye nga, ngan titoo lapau. ");
INSERT INTO apr_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Motong la Yesu idalele pang ye di, inbe iwete pang di nen, “Di garup ke malala mai Yerusalem nga, ken katang yau be. Bong bet nen nga, ngan ang tapmu katang yang inbe katang ye di natumu ngan lapau. ");
INSERT INTO apr_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Ngan awete pang nen, yesoo bong lal dook tiap atu yo bet pombe i, in ole masngana mai la bet pombe pang yang a igarungang i. Ye kene yo so tani in pombe nga, ngan ole di tooltool tiwete nen, ‘Ang garup yo kapasui toko pitiap nga, inbe ang garup yo taukamu natumu bet kapayin di nga, ngan lomu ponana, yesoo Maro iyei urata dook mata pang.’ ");
INSERT INTO apr_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Inbe ye kene tani in nga, ngan ole di tooltool tiwete pang di kawal nen, ‘Atoo, kaduku a kamol si poomam!’ Inbe ole tiwete pang di arono yo bussukana nga, ngan nen, ‘Atoo, kamol a si kakaltoo am!’ ");
INSERT INTO apr_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Ngan au i dawa ben kai yo lalana i, inbe la di tooltool bet tiyeie dada dook tiap nen pau nga. E ang ngan dawa ben kai yo bodene i, bong bet pang dama ni nga, ngan ole tiyeie soo so pang na?” ");
INSERT INTO apr_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Ye kene tani yo tikaua Yesu bet la tiraumate ye in nga, ngan le tikap di tooltool talnga dikidiki ru yo tiyei dada dook tiap nga, ngan lapau, la du tiraumata di le tipa ye Yesu nga. ");
INSERT INTO apr_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Ngan tipa a tilo pombe ye ni yo tiwete ene ye Tool Kutono Ruruana i, motong la di tooltool ke patokongo tina nga tipatoto Yesu ilo kai palasingi kaini le ipa ye di tooltool talnga dikidiki ru tina. Le atu ituku ke Yesu madini oonoo, inbe san ke madini ngas. ");
INSERT INTO apr_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Motong la tinepe, inbe Yesu iyei ne, “Tamak, lom pang di a kugiri sennene kidi, yesoo bong di nga lodi galanga dook tiap ngan la le tiyei dada nen nga.” Motong la di tooltool ke patokongo tina ngan di tapdi tiparsu ye sousoungu le so ki, le nga titoo moonoo kidi a tikatte madamada a bet tipusye sima tooltool yo bet ole tikap so ki tina nga. ");
INSERT INTO apr_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Di tooltool malala mai tina ngan tikododo a matadi kenen ye Yesu, inbe di kuto maimai yo matadi kala di Yuda nga, ngan tiyei sere ye. Tiyei ne, “Kakamata, kanakana ngan ilon di tooltool kapala, e nga gelei bet ye taunu iloni tiap nga? Kumata bet ye ni Kirisi moolmool yo Maro ipootoo panga ye taunu bet si ikap di tooltool ki a ipamulu di in nga, ngan matin nga le ye taunu iloni oo.” ");
INSERT INTO apr_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Ngan di tooltool ke patokongo lapau tikan paseme Yesu a tiyei sere ye, inbe timan man tikap ooroo wain surunu yo malingene ngan panga. ");
INSERT INTO apr_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Inbe tiyei ne, “Kumata le bet ong in tool kuto mai kidi Yuda moolmool nga, ngan ong taum kulonong e too.” ");
INSERT INTO apr_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Motong la tiwodo betanga pattu a tirauu lo ye kai palasingi ke Yesu kutono ke ete. Ngan betanga tina ngan tiwodo nen: I Tool Kuto Mai Yo Matan Kala Di Yuda Le Imot I. ");
INSERT INTO apr_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Inbe di tooltool talnga dikidiki ru yo tituku di le tipa ye Yesu nga, ngan atu in ikan paseme Yesu, le nga iwete panga nen, “Ai, bet kuwete ong in Kirisi nga, ngan ong taum kulonong, inbe kulonam amru lapau!” ");
INSERT INTO apr_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Bong ngan tool talnga dikidiki tina san in ipasak pang ene tani a ilele, inbe iwete panga nen, “Ong in lapau kouo masngana gaongo leu ben ye i, e nga gelei, kutattadaia Maro tiap, too? ");
INSERT INTO apr_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Aru nga moolmool, tiyemenai idi ye urata dook tiap kidi tina yo tayei, ngan kootoonoo. Bong tool i iyei toko dada sa dook tiap, ngan tiap.” ");
INSERT INTO apr_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Motong la tool tani in iwete pang Yesu nen, “Yesu, kene yo bet kulo malala kiong lo kuyei kuto mai a matam kala di tooltool kiong ye in nga, ngan ken lom tutau.” ");
INSERT INTO apr_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Ngan Yesu iwete panga nen, “Awete pong moolmool nen, katai nga ole ayong tanepe ye malala ke Maro yo nepongo ki dook mata i.” ");
INSERT INTO apr_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Ye kene tani in kemai ye ke matana sangaul be ru, ngan todo iduku tana mai i le imot, a iken nen le du rrai ye so ben ke matana tol. ");
INSERT INTO apr_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Le nga ke matan ikumukumu, inbe mala matolene yo tituka bareme mai ke sungunu lono i, in imassarak le iyei paru. ");
INSERT INTO apr_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Inbe Yesu koonoo le somai nen, “Tamak, atarau lo bem.” Yesu iwete nen a imot, inbe imaroon pattu leu le tina imata yege. ");
INSERT INTO apr_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Ye kene tani in tool turana bulbulini yo iye di tooltool ke patokongo tipatoto Yesu lo kai palasingi kaini, in ikamata so tina yo pombe nga, ngan ye matana, le iyitmaka Maro ene, inbe iwete nen, “Ona, moolmool sa, tool i tool noonoonoo.” ");
INSERT INTO apr_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Ngan yeiso di tooltool tina yo lo tigaua bet koodi tada nga, ngan tikamata so tina yo pombe nga, motong la titoo momo kidi a tipodo katedi bet tipitnaia lo madoko kidi, inbe timulu a tila pang malala kidi. ");
INSERT INTO apr_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Bong di tooltool le imot yo lodi galanga ye Yesu, ngan tipa ye di garup yo titoo ke Galili a tilo nga, ngan sila tikodo manga mooloo kasin, inbe tikamata so tina yo pompombe nga. ");
INSERT INTO apr_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Ngan tool atu yo ene Yosep i, in inepe lapau. Ye in iyei dada dook mata pang di tooltool, inbe ye in tool kuto mai atu kidi Yuda ke karatanga betanga lapau. ");
INSERT INTO apr_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Bong Yosep tani in itara lono le igaua la ye di diene kuto maimai kapala yo tigaua lodi bet ole tiyei urata dook tiap pang Yesu nga, ngan tiap. Ngan ye in malala mai ki la Arimatia i, bong nga itar matana bet ole ikamata lal yo Maro itaru bet matan kala di tooltool ki ye i. ");
INSERT INTO apr_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Le nga Yosep tani in ilo pang ye Pailot bet lo itoru a bet ikaua Yesu bobono, ngan le Pailot tani imalum panga. ");
INSERT INTO apr_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Motong la ila iyunu Yesu bobono tani a iyiti du tana, motong iduku ye mala kookoonoo, inbe ikauu la itaru ye agoro ke tarungu di matenge yo tikeli sakar madini i, in lono. Ngan agoro tani in titar toko tool matene sa bobono ye mugu tiap. ");
INSERT INTO apr_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Ye kene tani in di Yuda tina ngan bet tipare kaningi pang di, yesoo kumata le bet ke idu nga, ngan ole lal kidi Yuda ke sungunu tani in pombe. ");
INSERT INTO apr_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Ngan di garup tina yo tiye Yesu tipa ke Galili a tise nga, ngan titoo Yosep bet la tikamata agoro tani, inbe tikamata Yesu bobono bet Yosep itaru balai nga. ");
INSERT INTO apr_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Tikamata a imot, motong la timulu a tila pang rumu kidi la tipare kai surunu yo kini ki dook mata nga. Bong ngan lal kidi Yuda ke sungunu in pombe, le nga titoo wer ke Maro a timaryoo ye urata ye lal tani in. ");
INSERT INTO apr_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Tinepe a lal kidi Yuda ke sungunu tani in imot, le nga Sande muntu bongmai koot. Motong la di garup tina ngan tikap kai surunu tina yo tipare nga, ngan a tilo pang ye agoro ke tarungu di matenge tani. ");
INSERT INTO apr_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Tilo, ngan tikamata pat yo tikatkala agoro tani in koonoo ye i, in tipulu a ikoo ye agoro koonoo oo. ");
INSERT INTO apr_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Motong la di garup tina ngan tidewe a tilo pang agoro tani in lono, ngan tikamata Tool Mai Yesu bobono tani in iken tiap. ");
INSERT INTO apr_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Le nga lodi kaua urata ye go, inbe pattu leu be tikamata di tooltool ru yo sousoungu kidi ikoko le milmilbe nga, ngan yeru pombe le tikodo potai ye di. ");
INSERT INTO apr_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Ngan di garup tina ngan tikamata di, le nga titattadai le titud so pang tana. Motong la di tooltool ru tina ngan tiwete pang di nen, “Ai, nga gelei a kaman bet man kasere tool magurene yo si inepe kataunu ye di tooltool matedi in nga? ");
INSERT INTO apr_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Ye in inepe ni tiap. Ye in imadit mulu ye ni ke matenge oo. Ngan lomu tut ye betanga yo mugu ngan kaye kanepe Galili inbe iwete pang nga. ");
INSERT INTO apr_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Ngan ye in iwete nen, ‘Ole tikaua Tool Moolmool ke Maro a titaru la di tooltool dook tiap ke sennene bedi, a nen ngan tipatota lo kai palasingi kaini a imata. Ngan ole iken ye ke ru, bong ye ke tol ki nga, ngan ole amadit mulu.’” ");
INSERT INTO apr_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Motong la di garup tina ngan lodi tut ye betanga tina ke Yesu nga. ");
INSERT INTO apr_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Motong la tigege agoro ke matenge tani, inbe timulu a tilo lo tiwete pang di aposol ke Yesu yo sangaul be atu nga, ngan tipa ye di galiunu kapala. ");
INSERT INTO apr_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Ngan di garup tina yo tilo tikaua bingi pang di aposol ke Yesu ye so yo pombe nga, ngan atu in ene la Madia ke malala mai Makdala i, inbe Yoana iye Madia san yo Yemis tinana i, inbe di garup kapala lapau. ");
INSERT INTO apr_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Bong ngan di aposol ke Yesu tina ngan titara lodi medana ye betanga kidi tiap, yesoo betanga kidi tina yo tiwete, ngan tilongo ngan ben kidi tooltool kapakapa nga. ");
INSERT INTO apr_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Bong ngan Pita imadit tina le idada a idu pang ye agoro ke matenge tani yo titara Yesu bobono ye i. Idu, motong la itud a ipakele lo pang agoro lono, ngan ikamata mala tina yo tiduku Yesu ye nga, ngan leu ikenen. Motong la imulu tak a ilo pang malala, inbe ye taunu lon kaua urata ye so yo pombe in nga. ");
INSERT INTO apr_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Ye kene tani in Yesu di galiunu ru tipa a bet tidu pang ye malala atu yo ene Emeus i. Ngan manga yo iken kataunu ye Yerusalem inbe Emeus nga, ngan mooloo kasin. ");
INSERT INTO apr_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Le nga Yesu di galiunu ru tina ngan tipa, inbe tiwetewete ye so tina le imot yo pompombe Yerusalem nga. ");
INSERT INTO apr_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Ye kene yo yeru tipa bet tiwetewete a di tapdi tipartortor ye in nga, ngan Yesu ye taunu pombe pang ye di le lo iye di tipa gaongo. ");
INSERT INTO apr_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Bong ngan Maro iwonokala matadi, le ke bet yeru tikilala Yesu tiap. ");
INSERT INTO apr_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Motong la Yesu itor di yeru nen, “Ai, soo so angru kapa a kasi ngan kaweteweta i?” Yesu itor di nen, le tina betanga imot ye di yeru, inbe matadi mallikanga a sila tikodo so. ");
INSERT INTO apr_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Motong la di galiunu ru tina ngan atu yo ene Kiliopas i, in iman tina le itoro Yesu nen, “So yo amwetewete ye i, in di tooltool ke Yerusalem nga, ngan di le imot lodi galanga ye. Ngan ong i lowo atu ke malala mai Yerusalem lapau, e gelei bet lom galanga ye so yo airi ngan pombe i, in tiap nga?” ");
INSERT INTO apr_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Motong la Yesu iyei ne, “Soo so pombe i?” Motong la di galiunu tina ngan tiyei ne, “Amru nga amwetewete ye Yesu yo ke Nasaret i. Ye in Maro koonoo atu, le urata ki yo iyei inbe betanga ki yo iwete la di tooltool matadi nga, ngan ipa ye gurana ke Maro lapau. ");
INSERT INTO apr_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Bong di tooltool maimai ke paroranga so pang Maro tiye di kuto maimai kiam yo matadi kalam Yuda nga, ngan titaru la di tooltool kuto maimai ke Rom bedi, a nen ngan bet tipatota lo kai palasingi kaini a tirauu le imata. ");
INSERT INTO apr_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Bong am nga, amtara lomam medana bet Yesu in la Maro iwanga bet si ikau am tooltool ke Isrel a ipamulam i. Bong tirauu le imata a iken ye ke ru oo, inbe ke tol ki la dookoot katai i. ");
INSERT INTO apr_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","23","Ngan dookoot muntu katai nga, ngan so san mulu pombe. Di garup kiam pattu tisokat muntu bongmai koot a tila ye agoro tani yo titara Yesu bobono ye i, ngan tikamata tiap le timulu a man tiwete pam le amtakrai. Inbe tiwete pam bet tila ngan tikamata so dawa ben mianga ye di bangabangana ke Maro yo tiwete pang di bet Yesu in imagur mulu oo. ");
INSERT INTO apr_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Motong la di diemam pattu lapau tidada a tila ye agoro ke matenge tani, ngan tikamata so moolmool ben di garup tina ngan man tiwete nga, bong tikamata Yesu tani tiap.” ");
INSERT INTO apr_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Motong la Yesu iwete pang di yeru nen, “Ona, ang nga ben di tooltool kapakapa nga, le ke bet katar tarrai lomu medana ye betanga le imot yo di Maro koonoo tiwete, ngan pitiap yege. ");
INSERT INTO apr_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Di Maro koonoo tina ngan tiwete bet Kirisi ole isolo masngana alunu san mugu ngan, lo ngan bet Maro ipamaditi mulu inbe iyeie ene le ilo ete ke bet di tooltool tipayiti ye.” ");
INSERT INTO apr_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Motong la Yesu tani in ye taunu iwete nin betanga tina le imot yo tiwodo lo ye Rau ke Maro ye nga, ngan pang di. Ngan le imadit ye betanga yo iken ye rau ke Mose nga, le ilo ye rau yo ke di Maro koonoo nga le imot. ");
INSERT INTO apr_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Ngan iye di tipa bet iwetewete pang di le tidu potai pang ye malala tani in, le nga Yesu iyei tomonai ben bet ipa le ikenen leu pang dama. ");
INSERT INTO apr_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Bong ngan di galiunu ru tina, ngan tilele a tiwete panga nen, “Ai, nga ole amyong tanepe ngan, yesoo rrai a nga bet bong.” Motong la ilo a lo iye di tinepe nga. ");
INSERT INTO apr_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Ye kene tani in lo tinepe, le nga tiye Yesu la tiwur ye kakawa ke kaningi so, motong la ikaua porong atu a iwete lo ponana ki pang Maro ye, inbe itepala a bet ikauu pang di yeru. ");
INSERT INTO apr_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Motong la se yeru matadi galanga, inbe tikilala Yesu. Bong ngan pattu leu be pilikbe mulu le ke bet tikamata tiap. ");
INSERT INTO apr_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Le nga yeru di tapdi tiwetewete nen, “Ona tiap! Yesu moolmool sa! Ngan nen le taye tapa dada a tasi, inbe iwete nin betanga yo iken ye Rau ke Maro ngan punu paidi nga, ngan la le tayetai ben ei ikan a ilolo lodo nga sa.” ");
INSERT INTO apr_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Motong la palbe leu be yeru timadit tina ngan le timulu a tilo pang Yerusalem. Tilo a lo tipusye di aposol ke Yesu tina yo sangaul be atu nga, ngan tiye di tooltool kapala yo tiye di tinepe nga. Le nga tigaua, ");
INSERT INTO apr_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","motong la di diedi tina ngan tikaua bingi pang di yeru. Tiyei ne, “Moolmool sa! Tool Mai imadit mulu oo, le ye taunu pombe pang Simon.” ");
INSERT INTO apr_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Motong la di galiunu ru tina ngan tikaua bingi pang di lapau ye so yo titoo dada a tidu ngan pombe pang ye di i. Inbe tiwete pang di ye Yesu yo tikilla tiap le lo tiye tiwur a itepala porong bet tikani, motong tikilla i. ");
INSERT INTO apr_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Di galiunu tina ru ngan tiwetewete go, inbe palbe leu be Yesu ye taunu pombe le lo ikodo kataunu kidi, inbe iyei ne, “Lo silene ke Maro iken yang.” ");
INSERT INTO apr_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Ngan tina pombe pang ye di nen nga, le nga titattadai belebele a titangarur, yesoo tiyeisa o tikamata mariyaua. ");
INSERT INTO apr_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Bong ngan Yesu iyei ne, “Ai, nga katattadai au yesoo? E nga gelei bet lomu rru yau nen nga? ");
INSERT INTO apr_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Oo, kakamata bek le kek, nga too. I au tani naii! Inbe man katokau a kakamatau, too. Ngan mariyaua i, in medana le turana moolmool dawa ben au i tiap.” ");
INSERT INTO apr_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Ngan Yesu tani in iwete pang di nen, motong la ipitnai bene le kene pang di a tikamata. ");
INSERT INTO apr_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Di tooltool tina tikamata ngan le lodi ponana kaiye, bong lodi rru go le titara lodi medana moolmool tiap. Motong la Yesu itor di nen, “Ang nga kamu so sa ke kaningi lapau?” ");
INSERT INTO apr_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Motong la tikap i mene pattu panga. ");
INSERT INTO apr_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Le nga ikap a matadi ikenen ye, inbe ikan. ");
INSERT INTO apr_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Motong la iwete pang di aposol ki tina ngan nen, “Lomu tut ye kene yo ayang tanepe mugu nga, ngan awete pang nen. Betanga le imot yo iken ye wer ke Maro yo iwete pang Mose a iwodo nga, inbe ye rau ke di Maro koonoo, inbe ye Rau ke Woungu nga, ngan ole kanono pombe yau le imot.” ");
INSERT INTO apr_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Motong la Yesu ipamadit lodi ye betanga yo iken ye Rau ke Maro nga, le taun lodi galanga. ");
INSERT INTO apr_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Le nga Yesu iwete pang di nen, “Betanga tina yo tiwodo ngan nen: Kirisi ole isolo masngana mai a imata, lo ngan bet iken ye ke ru, le ye ke tol ki nga, ngan ole imadit mulu ye ni ke matenge. ");
INSERT INTO apr_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Inbe tiwodo betanga nen, bet di tooltool ole tila bet la tiwetewete bingi dook mata ki pang di tooltool kapala. Bong kulkulunu ngan ole timadit nanga la Yerusalem nga, mugu ngan, lo ngan bet ole tipa a tila ye tana maimai nga le imot, inbe tiwetewete bingi tani pang di tooltool ye au ek. Le ole tiwete pang di nen, ‘Kumata bet kaportak lomu ye dada dook tiap kiang yo kayei nga, ngan ole Maro igiri sennene kiang.’ ");
INSERT INTO apr_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Ngan so le imot yo pombe a kakamata koot nga, ngan ang nga la bet la kawetewete pang di tooltool ye nga. ");
INSERT INTO apr_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Mukot yege ni nga, ngan Tamak ipamede betanga medana nen, bet ole ikaua Amunu Silene pang. Le nga au i ole alo, lo ngan bet ayawari a isi pang yang. E ang nga kagege Yerusalem be, kanepe nanga le lo Maro Amunu Silene tani in ipa ye malala ke Maro a isi ikaua gurana mai pang ngan.” ");
INSERT INTO apr_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Motong la Yesu ikap di galiunu tina a tipa le tidu potai pang Betani. Motong la Yesu iyiti bene, inbe ipamede di ye betanga dook mata, a bet nen ngan Maro iyei urata dook mata pang di. ");
INSERT INTO apr_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Ye kene tani in itoro Maro bet ipamede di galiunu tina nga, ngan le iwetewete nen go, inbe Maro ikauu a igege di, inbe ilo pang ye malala ke Maro. ");
INSERT INTO apr_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Motong la di galiunu tina tisung panga a imot, inbe lodi ponana kaiye a timulu a tilo pang Yerusalem. ");
INSERT INTO apr_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Inbe ye ke kanakana nga, ngan tilo tinepe bareme mai ke sungunu lono, inbe tiyitmaka Maro ene. ");
INSERT INTO apr_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Kulkulunu yege, ye kene yo Maro itar so nga le imot a pompombe tiao nga, ngan Betanga inepe. Le Betanga tani in iye Maro tinepe, inbe ye taunu in Maro. ");
INSERT INTO apr_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Le ye kene tani in nga, ngan Betanga iye Maro tinepe. ");
INSERT INTO apr_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Ye in la dada ke so tina le imot yo Maro itar a pompombe nga. Le so sa yo pombe ye dada san mulu, ngan tiap. ");
INSERT INTO apr_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Inbe Betanga tani in nepongo dook mata ipa ye. Inbe nepongo dook mata tani, in la iyei ben sul a ilangarai di tooltool nga le imot i. ");
INSERT INTO apr_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Ngan sul tani, in ilangaraia ni yo todo lono i, inbe todo in taukan gurana yo bet illosi nga. ");
INSERT INTO apr_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Kene atu in Maro iwanga tool atu a si pombe, in ene la Yowan i. ");
INSERT INTO apr_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Ye in isi bet si iwetewete pang di tooltool ye sul tani, a bet nen ngan di tooltool nga le imot tilongo betanga ki ngan titara lodi medana panga. ");
INSERT INTO apr_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Yowan ye taunu in sul tani in tiap. Bong ye in isi nga, ngan bet si iwetewete pang di tooltool ye sul tani in leu. ");
INSERT INTO apr_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Ngan sul tani, in sul moolmool yo bet isi tana a bet si ilangarai di tooltool le imot i. ");
INSERT INTO apr_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Le Betanga tani in si inepe la tana nga. Ye taun in dada ke so tina le imot yo Maro itar a pompombe nga, bong ngan le di tooltool ke tana i tikilala tiap. ");
INSERT INTO apr_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Ngan bet isi pang ye tana ki ye taunu, bong ngan di rara ki lodi ponana ye a bet tikauu, ngan tiap. ");
INSERT INTO apr_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Bong di tooltool yo titara lodi medana panga a tikauu nga, ngan di la bet imalum pang di a tiyei ben Maro di natunu nga. ");
INSERT INTO apr_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Ngan di tooltool tina yo bet tiyei ben Maro di natunu nga, ngan pombe ye rara ke di tamadi le tinadi, too ye tool ke tana i sa lono, too ye dada ke di kerenge, ngan tiap, bong ye Maro ye taunu lono ngan la iyei di le tiyei ben di natunu nga. ");
INSERT INTO apr_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Ngan Betanga tani in iportak le iyei ben tooltool a si amye amnepe. Ye in lono pam mai san a iyei dada dook mata pam, inbe itoo dada moolmool yo ke Maro nga. Inbe amkamata ben Tamana iyeie ene le ilo ete ke bet di tooltool tipayiti ye, yesoo ye in Natunu ataleu. ");
INSERT INTO apr_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Yowan iwetewete pang di tooltool ye, le tina koonoo le mai nen. Iyei ne, “Tool tani, in tool yo mugu ngan awete pang ye a ayei ne, ‘Tool atu yo bet itoo au a ipa mur a isi i, in ene mai san le illosau, yesoo ye kene yo tipasui au ye tiao nga, ngan ye in inepe mukot.’” ");
INSERT INTO apr_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Dada ki yo bet lono paidi mai san a iyei dada dook mata paidi ye nga, ngan ke bet imot tiap. Ngan nen le iyei urata dook mata paidi le ikenen leu nen a tala. ");
INSERT INTO apr_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Moolmool, wer ke Maro ngan ipa ye Mose bene, bong dada yo bet Maro lono paidi mai san a iyei urata dook mata paidi nga, inbe dada dook mata moolmool yo ki nga, ngan ipa ye Yesu Kirisi. ");
INSERT INTO apr_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Ngan idi nga tool sa ikamata toko Maro pitiap yege. Bong Maro Natunu ataleu yo iye tinepe i, in ye la ipitnaia Maro pang di tooltool a lodi galanga ye i. ");
INSERT INTO apr_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Kene atu in di kuto maimai kidi Yuda yo tinepe Yerusalem nga, ngan tiwanga di tooltool ke paroranga so pang Maro, tiye di rara ke Liwi yo tiyei urata bareme mai ke sungunu lono ngan bet la titoro Yowan bet ye in sei. ");
INSERT INTO apr_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Titoru, ngan le ipataukala tiap, bong iwete pobe pang di nen, “Au i Mesaia, tool yo Maro ipootoo bet si ikap di tooltool ki a ipamulu di ye so dook tiap yo bet igarung di i, in tiap.” ");
INSERT INTO apr_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Motong la titoru mulu nen, “Ngan ong i sei? Ong i Maro koonoo yo Ilia i, too?” Ngan Yowan iyei ne, “Tiap.” Motong la titoru mulu. Tiyei ne, “Ngan ong i o Maro koonoo yo amtar matamam ye bet isi i, too?” Ngan iraua torungu kidi nen, “Tiap.” ");
INSERT INTO apr_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Motong la titoru mulu a tiyei ne, “Ngan ong i sei? Am nga lomam bet kuwete ninong dook pam, a bet nen ngan la amwete pang di tooltool yo tiwangam a amman nga. Ngan ong taum i kuwetong ye sei?” ");
INSERT INTO apr_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Motong la Yowan iwete pang di ye betanga ke Maro koonoo Esai yo mukot ngan iwete nen, “Au i tool atu yo kalongo kalngana ye ni soorookoonoo a iwete le koonoo maimai nen, ‘Kakarata dada le igalanga pang Tool Mai bet ipa ye.’” ");
INSERT INTO apr_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Motong la di tooltool pattu yo di Paresi tiwanga di nga, ngan timan ");
INSERT INTO apr_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","le man titoro Yowan nen. Tiyei ne, “Ai, ngan ong i bet Kirisi tiap, inbe Ilia tiap, inbe Maro koonoo yo amtar matamam ye, in tiap nga, ngan nga gelei a le kurriu di tooltool nga?” ");
INSERT INTO apr_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Motong la iraua betanga kidi nen, “Au i arriu di tooltool ye ran leu, bong tool atu yo dookoot man ikododo kataunu kiang i, in lomu galanga ye tiap. ");
INSERT INTO apr_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Ye in tool tani yo bet itoo au a ipa mur a isi i. Inbe ye in ene mai san, le au i akamatau ben au i tool dook mata ke bet aloni ben poranga ki a aruku ooroo ye loningi ke kene tiap.” ");
INSERT INTO apr_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Ngan so tina nga pombe ye malala yo ene Betani i, inbe malala tani in iken ke ran Yodan koonoo kapala ye ni yo ke ipa ye a ise i. Ngan ye ni tani in la Yowan irriu di tooltool ye i. ");
INSERT INTO apr_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Tinepe le nga mongmongini ki, motong la Yowan ikamata Yesu ipa a iman pang ye, le nga iyei ne, “Ai, kakamata! Sipsip Natunu Ke Maro yo isi bet si imata a bet nen ngan igiri sennene kidi tooltool ke tana i, in la iman i! ");
INSERT INTO apr_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Ye in tool tani yo mugu ngan awete pang ye, a ayei ne, ‘Tool atu yo bet itoo au a ipa mur a isi i, in ene mai san le illosau, yesoo ye kene yo tipasui au ye tiao nga, ngan ye in inepe mukot.’ ");
INSERT INTO apr_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Moolmool, mugu ngan au tauk i lok galanga ye tiap. Bong ye punu yo dookoot ngan man arriu di tooltool ye ran in nga, ngan bet nen a nen ngan di tooltool ke Isrel lodi galanga ye.” ");
INSERT INTO apr_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Motong la Yowan isudungu betanga ki mulu a iwete nen, “Akamata Maro Amunu Silene igege malala ke Maro a isi dawa ben man utu le si iwot ye. ");
INSERT INTO apr_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Ngan au i lok galanga ye tiap lapau, bong ngan tool yo iwangau bet si arriu di tooltool ye ran i, in iso talngak nen, ‘Kumata le bet kumata Amuk Silene isi le si iwot ye tool atu nga, ngan tool tani in la bet irriu di tooltool ye Amuk Silene i.’ ");
INSERT INTO apr_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Le akamata so tina yo nen ngan pombe pang ye, ngan la bet awete pang nen: Ye in Maro Natunu moolmool.” ");
INSERT INTO apr_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Tinepe a mongmongini ki, motong la Yowan iye di galiunu ru timulu a tila ye ni tani in mulu. ");
INSERT INTO apr_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Inbe nga ikamata Yesu yo ipa a iman a ila nga, motong la iwete pang di nen, “Ai, kakamata! Sipsip Natunu ke Maro meneng, e ni!” ");
INSERT INTO apr_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Ngan ye kene yo Yowan di galiunu ru ngan tilongo tina yo iwete nen ye in nga, ngan yeru timadit a tila le la titoo Yesu. ");
INSERT INTO apr_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Motong la Yesu bet iportak ngan ikamata di tina yo titoo nga, le nga itor di nen, “Ai, nga angru kasere soo so?” Ngan yeru tikiui Yesu ye di Ibru koodi inbe tiyei ne, “Rabai, ngan kunepe ngai?” (Ngan betanga yo “Rabai” in punu ben “Pannoongoo.”) ");
INSERT INTO apr_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Motong la Yesu iraua betanga kidi nen, “Angru kaman a tala la kakamata.” Ngan ye kene tani in ke idu le so ben ke matana pai la yeru tiye Yesu tila la tikamata ni tani yo inepe ye i, inbe tiye tinepe tinepe le du bong. ");
INSERT INTO apr_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Ngan di tooltool ru tina yo tilongo betanga ke Yowan a le titoo Yesu nga, ngan atu in Antares yo Simon Pita taini i. ");
INSERT INTO apr_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Ngan Antares tani in inepe, motong la igege Yesu inbe ila la isere toonoo Simon. Le nga isere a ipusye, motong la ikaua bingi panga nen, “Simon, am nga ampusye Mesaia.” (Ngan betanga yo “Mesaia” i, in punu ben “Kirisi.”) ");
INSERT INTO apr_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Motong la ikauu a tila pang ye Yesu nga. Ngan tila, le nga Yesu ikamata, motong la matan kenen ye, inbe iyei ne, “Ai, ong i Simon tani yo Yowan natunu i. Bong pang dama ni ngan ole tikiui em ye Sipas.” (Ngan ene yo Sipas i, in bet tiportaki ngan punu ben Pita). ");
INSERT INTO apr_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Tinepe a mongmongini ki, motong la Yesu lon kau urata bet ila pang Galili. Le nga ilo ngan ipusye Pilip, motong la iwete panga nen, “Ai, kuman a man kutoo au.” ");
INSERT INTO apr_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Ngan Pilip tani in iye Antares ye Pita ngan di ke malala yo ene Betsaida i. ");
INSERT INTO apr_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Motong la Pilip ila bet la isere Nataniel ngan ipusye, le nga iwete panga nen, “Am nga ampusye tool tani yo mugu ngan Mose iwodo betanga ki lo ye Wer ke Maro i, inbe di Maro koonoo lapau tiwodo betanga ye i. Ye in Yesu ke Nasaret, inbe tamana la Yosep i.” ");
INSERT INTO apr_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Bong ngan Nataniel imadit tina le iwete panga nen, “Ona tiap! Ai, Nasaret la o ke bet so dook mata yo nen nga pombe ye i, too?” Motong la Pilip iwete panga nen, “Kuman a tala la ong taum kumata ye matam.” ");
INSERT INTO apr_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Ngan ye kene tani in Yesu ikamata Nataniel yo ipa a iman nga, le nga iyei ne, “Kakamata, tool yo ipa a iman i, in tool moolmool ke Isrel. Inbe ye ni dada yo ke kaplungunu ngan sa iken ye, ngan tiap.” ");
INSERT INTO apr_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Yesu iwete nen, le nga Nataniel itoru. Iyei ne, “Ai, ngan ong i lom galanga yau balai?” Motong la Yesu iraua betanga ki nen, “Ye kene yo Pilip koonoo pong ye tiao nga, ngan akamatong yo kunepe ye kai yo tiwete ene ye pik i, in parmana nga.” ");
INSERT INTO apr_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Motong la Nataniel iyei ne, “Pannoongoo, ong in Maro Natunu moolmool! Inbe ong in tool kuto mai yo bet matam kala tana kidi Isrel le imot i!” ");
INSERT INTO apr_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Motong la Yesu iwete panga nen, “Ngan ong in kutara lom medana pau nga, yesoo ye yo awete bet akamatong kunepe kai pik parmana nga, too? Awete pong nen, pang dama ni nga, ngan ole ayei urata maimai le illoso so yo dookoot kumata i.” ");
INSERT INTO apr_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Motong la Yesu iseke betanga ki a iwete pang di mulu nen, “Awete pang moolmool nen, pang dama ni nga, ngan ole kakamata malala ke Maro koon panganga, inbe ole kakamata di bangabangana ke Maro bet tipa a tilo be tisi ye Tool Moolmool ke Maro nga.” ");
INSERT INTO apr_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Tinepe le nga ke ru iman a ila le ye ke tol ki, motong la tiyeie mailang atu ke kerenge la malala mai Kana yo iken ye tana mai ke Galili i. Ngan Yesu tinana in ila nango la inepe ye kerenge tani. ");
INSERT INTO apr_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Inbe Yesu iye di galiunu ngan tikiu di bet tila ye kerenge tani in lapau. ");
INSERT INTO apr_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Le nga ye kene tani in, di tooltool yo tikiu di nga, ngan tikan be tiyin le le ran medana kidi yo wain nga, ngan imot. Motong la Yesu tinana iwete panga nen, “Ai, di tooltool nga timaka ye wain sa.” ");
INSERT INTO apr_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Ngan iraua betanga ki nen, “Atoo, tinak nga gelei bet koom kautau a alo ye mailang i lapau nga? Lal kiau yo bet ayei urata kiau ye i, in pombe tiao.” ");
INSERT INTO apr_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Motong la tinana iwete pang di kapraingi yo matadi kala kaningi ngan nen, “Kumata le bet iwete pang ye soo so bet kayeii nga, ngan kayeii leu.” ");
INSERT INTO apr_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Ngan rumu tani in bor ki somaimai limi be atu yo tikarata ye pat nga, ngan tikododo potai pang ye ni yo tinepe ye i. Ngan bor tina ngan titar pang di Yuda bet titoo momo kidi ngan tikap ran ki, a bet nen ngan tingas so kidi le igalanga ye Maro matana. Inbe bor tina ngan atu atu nga, ngan ke bet tipaling ran le somai ilo ye. ");
INSERT INTO apr_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Motong la Yesu iwete pang di kapraingi tina nen, “Kapaling ran lo ye bor ngan.” Le nga tipaling ran lo ye bor tina ngan atu atu le lo iponen. ");
INSERT INTO apr_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Motong la iwete pang di nen, “Oo, kakut ran tina ngan pattu, inbe kakap pang tool mai yo matan kala mailang i.” Le nga tiyei ben tina yo iwete pang di nga. ");
INSERT INTO apr_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Motong la bet tool mai tani in iyin toko, ngan ran tina ngan iportak a iyei wain oo. Le nga lon sarrara ye wain nga tikap ngai, bong ngan di kapraingi yo tipaling ran nga, ngan di leu la lodi galanga ye nga. Motong la tool mai tani in ikiui tamoto yo bet ikere i, in a iman pang ye man, ");
INSERT INTO apr_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","iwete panga nen, “Ai, di tooltool le imot nga, ngan ole timalimi wain yo dook mata ngan pang di tooltool a tiyin mugu. Le kumata bet tiyin kaiye koot nga, ngan la bet timalimi di ye wain yo ben nen be nga. Bong ong i kuyei nen tiap, kupataukala wain yo dook mata ngan a iken le se dookoot yege, motong la kupapos nga.” ");
INSERT INTO apr_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Ngan i mos tani yo Yesu iyeii kulkulunu yege a bet nen ngan ye taunu ipaposi ben ye in Maro iyeie ene le ilo ete ke bet di tooltool tipayiti ye. Ngan iyeii ye malala mai Kana yo iken ye tana mai ke Galili i. Inbe di galiunu tikamata, ngan le titara lodi medana ye. ");
INSERT INTO apr_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Ngan mailang ke kerenge tani in imot, motong la Yesu iye tinana le di taini inbe di galiunu tigege malala mai tani a tidu pang Kapenam. Tidu, ngan le du tinepe ye ke ben alunu kasin. ");
INSERT INTO apr_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Tidu tinepe nango, le lo lal maiyoko kidi Yuda ke sungunu yo tiweta ye Paskimoolooningi ke Maro in potai bet pombe, le nga Yesu ilo pang Yerusalem. ");
INSERT INTO apr_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Motong la ipa so a ilo koongoo lono ke bareme mai ke sungunu, ngan ikamata di tooltool yo tiyawar bulumakau le sipsip le man nga. Inbe ikamata di tooltool kapala lapau yo tiwurur ye kakawa kidi a tiraukol pat nga. ");
INSERT INTO apr_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Le nga ikap ooroo pattu a ipirak le dook mata pang salitingi di. Motong la inin di tooltool tina le imot tipa ye di sipsip le bulumakau kidi a tidu tana ye bareme mai ke sungunu. Inbe igirigiri pat ke di tooltool ke raukolingi pat ngan du tana, inbe ipatudtud kakawa kidi. ");
INSERT INTO apr_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Inbe ila la iwete pang di tooltool yo tiyawar man kidi ngan nen, “Kakap man kiang nga a kakoo ye ni! Nga gelei bet kayeie rumu ke Tamak i, le iyei ben ni ke yawaringi so nga!” ");
INSERT INTO apr_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Ngan ye kene yo Yesu iyei nen ye in nga, ngan le di galiunu lodi tut ye betanga pattu yo iken ye Rau ke Maro nga. Ngan betanga tina ngan iwete nen, “Au i lok yo mai san ye rumu kiong i, in ikanene lok dawa ei ikanau nga.” ");
INSERT INTO apr_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Bong ngan di kuto maimai ke di Yuda tikamata tina yo iyei nen nga, le nga tiwete panga nen, “Ai, nga ole kuyeie soo mos bet iyei ben tarkilanga pam, a bet nen ngan amkamata ngan lomam galanga yong nen, bet ong i Maro itarong la le kuyei so yo nen ngan le imot nga?” ");
INSERT INTO apr_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Motong la Yesu iraua betanga kidi nen, “Kumata bet kasaua bareme mai ke sungunu i nga, ngan ole apatokode mulu ye ke tol.” ");
INSERT INTO apr_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Yesu iwete nen, motong la di Yuda tiyei ne, “Ona tiap, bareme mai i tire ye rai sangaul pai inbe balana limi be atu, motong la imot nga. E nga gelei a kuwete bet ole kupatokode mulu ye ke tol leu nga?” ");
INSERT INTO apr_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Bong bareme mai yo Yesu iwetewete ye i, in iwete ye ye taunu tinini. ");
INSERT INTO apr_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Ngan nanga, ye kene yo imadit mulu ye ni ke matenge ye in nga, ngan le di galiunu tina lodi tutu betanga ki yo iweta i. Motong la titara lodi medana ye betanga yo iken ye Rau ke Maro nga, inbe ye betanga ki yo iweta i. ");
INSERT INTO apr_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Le nga ye kene yo Yesu inepe Yerusalem ye lal maiyoko ke di Yuda ke sungunu yo tiwete ene ye Paskimoolooningi ke Maro ye in nga, ngan di tooltool alunu kaiye tikamata mos tina yo iyei nga, le titara lodi medana panga. ");
INSERT INTO apr_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Bong ngan Yesu matan ru di, yesoo lon galanga ye di tooltool tina, ngan oo. ");
INSERT INTO apr_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Ye in ke bet isere tool san a iwete nin dada kidi tooltool panga, ngan tiap. Yesoo ye taunu, in lon galanga ye so le imot yo iken di tooltool lodi, ngan oo. ");
INSERT INTO apr_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Tool atu ke di Paresi yo ene Nikodimas i, in inepe. Ye in kuto mai atu, inbe inepe ye budanga ke di kuto maimai kidi Yuda yo ke karatanga betanga nga. ");
INSERT INTO apr_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Ngan bong, motong la iman pang ye Yesu man iwete panga nen, “Pannoongoo, am nga lomam galanga yong nen, ong i Maro iwangong a kusi bet si kuyei ben pannoongoo. Yesoo, kumata le bet Maro inepe ye tool tiap nga, ngan o ke bet iyei mos yo ben ong kuyei, ngan tiap.” ");
INSERT INTO apr_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Motong la Yesu iraua betanga ki nen, “Awete pong moolmool nen, kumata tool sa bet iportaka lono le iyei ben tool paunu mulu tiap nga, ngan o ke bet lo igaua ye di tooltool yo Maro bet matan kala di nga, ngan tiap.” ");
INSERT INTO apr_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Motong la Nikodimas itoru mulu nen, “Ngan gelei ye tool yo iyei kolman koot i, in ole iyei balai a bet iyei tool paunu mulu nga? Tool tani in ke bet imulu a ilo tinana kapono lono, lo ngan bet tinana ipasuiu mulu, ngan tiap.” ");
INSERT INTO apr_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Motong la Yesu iraua betanga ki nen, “Awete pong moolmool nen, kumata tool sa bet iportaka lono le iyei ben tool paunu mulu ye ran, inbe ye Maro Amunu Silene, tiap nga, ngan o ke bet lo igaua ye di tooltool yo Maro bet matan kala di nga, ngan tiap. ");
INSERT INTO apr_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Ngan so yo di tooltool ke tana tiyeii a pombe i, in so ke tana, bong so yo Maro Amunu Silene iyeii a pombe i, in so ke Maro Amunu. ");
INSERT INTO apr_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Le ken kutakrai ye betanga yo aweta pong bet kuportaka lom le kuyei ben tool paunu mulu, ngan be. ");
INSERT INTO apr_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Awete pong nen, muru i bet ipa nga, ngan ole ipa pang ye ni yo bet ipa pang ye i. Ngan ole kulongo mununu, bong o ke bet lom galanga ye ni yo ipa ye a iman i, too ye ni yo bet ila pang ye i, in tiap. Ngan dada gaongo leu, ye urata yo Maro Amunu Silene iyeii ye di tooltool a bet iportak lodi le tiyei ben di tooltool paunu mulu nga.” ");
INSERT INTO apr_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Ngan tina Yesu iwete nen nga, le nga Nikodimas itoru. Iyei ne, “Ai, so yo kuwetewete ye nga, ngan ole pombe balai?” ");
INSERT INTO apr_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Motong la Yesu iraua betanga ki nen, “Ong i pannoongoo, inbe em mai ye di pannoongoo kapala yo ke di Isrel nga. E nga gelei a lom galanga ye so nga tiap nga? ");
INSERT INTO apr_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Awete pong moolmool nen, am nga amwetewete ye soo so yo lomam galanga ye nga, inbe ampapos soo so yo amkamata nga. Bong ang nga lomu bet kakap betanga kiam yo amwetewete pang ye, ngan tiap. ");
INSERT INTO apr_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Au i awete pang ye so yo ke tana i nga, bong ngan katara lomu medana ye tiap. Ngan nanga, kumata le bet awete pang ye so yo ke malala ke Maro nga, ngan ole katara lomu medana ye balai? ");
INSERT INTO apr_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Ngan ni tool sa yo ilo koot ye malala ke Maro, ngan siap. Bong Tool Moolmool ke Maro yetaleu in la ipa ye malala ke Maro a isi i. ");
INSERT INTO apr_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Mugu ngan Mose ikarata tomonaia moto kannungana ye pat sallinene, motong la itaru lo ye kai inbe ipatokode le ikodo ye ni soorookoonoo, a bet nen ngan di tooltool tikamata ngan timmata be. Ngan dada gaongo leu ole pombe ye Tool Moolmool ke Maro. Ye in ole titaru lo ye kai inbe tipatokode le lo ikodo, ");
INSERT INTO apr_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","a bet nen ngan di tooltool le imot yo titara lodi medana panga nga, ngan ole tikaua nepongo dook mata yo taukan motingi i. ");
INSERT INTO apr_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","“Maro lono pang di tooltool ke tana i mai san, ngan la le iraia Natunu tani yo ataleu in pang di nga, a bet nen ngan di sima tooltool yo titara lodi medana panga nga, ngan bet tilledi be, bong tikaua nepongo dook mata yo taukan motingi i. ");
INSERT INTO apr_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Yesoo, Maro iwanga Natunu a isi ye tana i nga, ngan bet si ipapos di tooltool ye urata dook tiap kidi yo tiyei nga, a bet nen ngan iyemenai di ye, ngan tiap. Bong iwanga a isi nga bet si ikap di tooltool le imot a ipamulu di ye so dook tiap yo bet igarung di i. ");
INSERT INTO apr_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Ngan nen le di sima tooltool yo titara lodi medana ye nga, ngan o ke bet Maro iyemenai di tiap. Bong di sima tooltool yo titara lodi medana panga tiap nga, ngan Maro ikarata betanga kidi oo, le ole iyemenai di. Yesoo, di ngan titara lodi medana ye Maro Natunu tani yo ataleu i, in tiap. ");
INSERT INTO apr_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Ngan ye punu yo bet Maro iyemenai di tooltool ye i, in nen: Maro iwanga sul a isi tana i oo, bong ngan di tooltool lodi pang sul lulngana tiap. Di ngan lodi pang dada dook tiap yo ke todo lono nga, ngan mai san, yesoo di ngan ran kidi geingi dada yo dook tiap nga. ");
INSERT INTO apr_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Inbe di tooltool le imot yo tiyei dada dook tiap nga, ngan tiyei koi pang sul. Di ngan titattadai bet timan potai ye sul ngan ipapos dada dook tiap yo kidi ngan se mallangana nga, ngan nen le tinepe manga mooloo ye. ");
INSERT INTO apr_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Bong di sima tooltool yo titoo dada moolmool ke Maro nga, ngan lodi bet tinepe ye sul lulngana, a bet nen ngan di tooltool tikamata, ngan lodi galanga ben titoo Maro lono ye dada kidi yo tiyei nga.” ");
INSERT INTO apr_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Yesu iwetewete pang Nikodimas a imot, motong la iye di galiunu timadit a tila pang tana mai Yudia nga. Ngan le la tinepe kasin nango, inbe ikaua urata ye rriungu di tooltool. ");
INSERT INTO apr_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Ngan Yowan lapau itu ye rriungu di tooltool ye malala Ainon yo iken potai pang ye malala mai Salim i, yesoo ni tani in ran ki alunu san. Ngan la le di tooltool tila le ikenen leu pang ye ni tani a bet la irriu di nga. ");
INSERT INTO apr_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","(Ngan ye kene tani in Erot itara Yowan ilo rumu dook tiap kidi talnga dikidiki lono tiao.) ");
INSERT INTO apr_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Ngan betanga atu in iken kataunu ye Yowan di galiunu tiye tool atu kidi Yuda. Di ngan tiwetewete a tiparsu ye momo kidi Yuda yo bet titoo a tirriu le tinidi igalanga dook mata ye Maro matana i. ");
INSERT INTO apr_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Motong la Yowan di galiunu tina ngan tila pang ye la tiwete panga nen, “Pannoongoo, lom tut ye tool yo mugu ngan angru kanepe ran Yodan koonoo kapala, inbe kuwetewete pang di tooltool ye i, in dookoot nga di tooltool le imot ngo la tigaua pang ye, inbe irriu di.” ");
INSERT INTO apr_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Motong la iraua betanga kidi nen, “Dada yo nen ngan sa ke bet pombe sorok pang ye tool tiap. Bong kumata le bet Maro yo inepe ye malala ki ete ni, in ipamede tool bet iyei so yo nen nga, ngan ole iyei. ");
INSERT INTO apr_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Ngan ang tapmu nga kalongo betanga yo mugu ngan awete pang inbe ayei ne, ‘Au i Mesaia, tool yo Maro ipootoo bet si ikap di tooltool ki a ipamulu di ye so dook tiap yo bet igarung di i, in tiap. Bong au i Maro iwangau a asi bet si amugu panga.’” ");
INSERT INTO apr_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Motong la Yowan ikatte betanga atu pang di nen, “Kumata le tamoto atu bet iyooloo garup atu nga, ngan ole garup tani in iyei ben ye rimana. Inbe tamoto tani yo bet ikere i, in tool ki atu yo ipare so pang kerenge ki i, in ole ikodo a itar talngana bet ilongo ene tani yo bet iman i. Le yeiso bet ilongo kalngana, ngan ole lon ponana le lon ponana kaiye. Ngan dada gaongo leu, dookoot nga au i lok ponana le lok ponana kaiye nen lapau. ");
INSERT INTO apr_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Ngan nanga, ye in ene ole ilo pang ete, inbe au ek ole idu pang lopo. ");
INSERT INTO apr_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","“Ngan tool yo ipa ye malala ke Maro a isi i, in ene mai san le illos di tooltool nga le imot. Inbe tool yo ke tana i, in ke tana le iwetewete ye so yo ke tana i nga leu. Bong tool yo ipa ye malala ke Maro a isi i, in ene mai san le inepe ete ye di tooltool nga le imot. ");
INSERT INTO apr_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Ye in iwetewete ye soo so yo ikamata inbe ilongo ye malala ke Maro nga. Bong ngan tool sa ikap betanga ki a iparama le imede, nga tiap. ");
INSERT INTO apr_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Bong kumata le tool bet ikap betanga ki tina a iparama le imede nga, ngan ole ipaposi ben ye in itara lono medana pang Maro bet betanga ki ngan moolmool. ");
INSERT INTO apr_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Tool tani yo Maro iwanga a isi i, in si iwetewete betanga ke Maro. Yesoo, Maro ikaua Amunu Silene panga a ipaponi ye, le manga pa bet iken tiap. ");
INSERT INTO apr_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Ngan Tamana lono pang Natunu tani in mai san, le itar so tina nga le imot lo bene. ");
INSERT INTO apr_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Ngan nen le sei tool bet itara lono medana pang Natunu nga, ngan ole ikaua nepongo dook mata yo taukan motingi i. Bong kumata sei tool bet iwala murini pang Natunu tani, in nga, ngan o ke bet ikaua nepongo dook mata yo taukan motingi i, in tiap. Bong kate malmal ke Maro ole iken ye nen a tala.” ");
INSERT INTO apr_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Ye kene tani in di Paresi tilongo betanga bet Yesu illoso Yowan a irriu di tooltool alunu kaiye le tiyei ben di galiunu a titoo nga. ");
INSERT INTO apr_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Bong ngan Yesu ye taunu la irriu di tooltool tina, ngan tiap, di galiunu la tirriu di nga. ");
INSERT INTO apr_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Le nga Yesu talngan rau bet di Paresi tilongo betanga ye di tooltool tina yo titoo ngan oo. Motong la imadit a igege tana mai Yudia, inbe imulu a ila pang tana mai Galili mulu nga. ");
INSERT INTO apr_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Ngan itoo dada yo ipa kataunu ye tana mai Samaria in a ila. ");
INSERT INTO apr_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Le nga ipa nen a ila, ngan le la pombe ye malala mai atu kidi Samaria yo ene Saika i. Ngan malala tani in iken potai pang ye tana kasin yo mugu ngan Yakop ikap pang natunu Yosep nga. ");
INSERT INTO apr_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Inbe ran gimono yo mugu ngan Yakop ikeli i, in iken ye ni tani lapau. Ngan tina Yesu ipa ye dada mooloo a ila le panga rauu, le nga la iwur potai pang ye ran kelingi tani in gigini. Ngan ke ise isolokati kataunu kat le igoro ke matana sangaul be ru. ");
INSERT INTO apr_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Le nga Yesu inepe, inbe di galiunu tilo pang malala mai lono bet lo tiyimi kaningi pang di. Inbe mooloo tiap bet garup atu ke Samaria isi bet si idok ran ki. Motong la Yesu iwete panga nen, “Atoo, nga ole kukut ran pattu se ayin ngan.” ");
INSERT INTO apr_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Motong la garup tani in iwete panga nen, “Ai, ong i tool kidi Yuda, inbe au i garup ke Samaria. E nga gelei a kutorau bet akut ran pong a kuyin nga?” (Ngan garup tani in iwete panga nen, yesoo di Yuda ngan tiye di Samaria tigauagaua tiap.) ");
INSERT INTO apr_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Motong la Yesu iraua betanga ki nen, “Kumata bet lom galanga ye so dook mata yo bet Maro ikauu pang di tooltool ye lo ponana ki i, inbe ye tool yo itorong bet kop ran panga a iyin in nga, ngan matin nga le kutoru a nen ngan ikaua ran yo bet ikaua nepongo dook mata pang di tooltool i, in pong.” ");
INSERT INTO apr_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Motong la garup tani in iwete panga nen, “Tool Mai, ran i idu lopo san, inbe ong i taukam so yo bet kukut ran ye i. E nga ole kouo ran yo bet ikaua nepongo dook mata pang di tooltool i, in ngai? ");
INSERT INTO apr_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Sasa kiidi yo Yakop i, in ikele ran naii pam. Inbe ye taunu iye di natunu tiye di asara ki yo edi bulumakau le sipsip nga, ngan di le imot tiyini ran tani i lapau. Bong ong i gelei, o kulloso Yakop la kuwete bet kouo ran yo bet ikaua nepongo dook mata pang di tooltool i, too?” ");
INSERT INTO apr_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Motong la Yesu iraua betanga ki nen, “Di tooltool le imot yo tiyini ran i nga, ngan ole morak di mulu. ");
INSERT INTO apr_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Bong kumata sei tool bet iyini ran yo bet akauu panga in nga, ngan o ke bet moraku mulu tiap. Bong ran tani in ole iyei ben ran punu nga, inbe rongrongbe ke lono, a nen ngan ikaua nepongo dook mata yo taukan motingi i, in panga.” ");
INSERT INTO apr_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Motong la garup tani iyei ne, “Atoo, Tool mai, nga ole kouo ran tani in pau, a nen ngan morakau a amulu si adoko ran i mulu be.” ");
INSERT INTO apr_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Motong la Yesu iwete panga nen, “Kulo lo kouo nimtooroo, lo ngan bet angru kasi.” ");
INSERT INTO apr_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Bong ngan garup tani in iraua betanga ki nen, “Atoo, au i taukak niktooroo.” Motong la Yesu iyei ne, “Betanga kiong yo kuwete bet ong i taukam nimtooroo, ngan moolmool. ");
INSERT INTO apr_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Yesoo, ong in kuyooloo tamoto limi oo, inbe tamoto yo dookoot angru kanepe ni, in nimtooroo tiap. Le betanga kiong yo kuwete nga, ngan moolmool le imot.” ");
INSERT INTO apr_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Motong la garup tani in iyei ne, “Tool mai, akamatong ngan ong i Maro koonoo atu. ");
INSERT INTO apr_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Mugu ngan di sasa kiam tisung ye kawal bi e i. Bong ang Yuda nga kawete bet ni yo bet tagaua a tasung ye i, in la Yerusalem leu i.” ");
INSERT INTO apr_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Motong la Yesu iwete panga nen, “Garup, kutara lom medana ye betanga kiau. Ye lal atu yo bet pombe i, in di tooltool ole se tisung pang Tamada ye kawal i mulu tiap, inbe lo tisung panga Yerusalem tiap lapau. ");
INSERT INTO apr_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Ang Samaria nga kasung pang tool yo lomu galanga ye tiap i. Bong am Yuda nga amsung pang tool yo lomam galanga ye i. Yesoo, dada yo Maro bet ipamulu di tooltool ye so dook tiap yo bet igarung di i, in ipa yam Yuda. ");
INSERT INTO apr_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Bong lal tani yo awete pong ye bet pombe i, in dookoot nga pombe oo. Le di tooltool yo bet tisung moolmool nga, ngan ole tisung pang Tamada ye gurana ke Maro Amunu yo bet ipasongosongo di ye nga, inbe ye dada yo moolmool nga. Yesoo, Tamada in lono dook mata ye di tooltool yo tisung panga nen nga. ");
INSERT INTO apr_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Maro i ben amunu le ke bet takamata tiap, le di tooltool yo bet tisung panga nga, ngan ole tisung panga ye gurana ke Maro Amunu yo bet ipasongosongo di nga, inbe ye dada yo moolmool nga.” ");
INSERT INTO apr_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Yesu iwete nen a imot, motong la garup tani in iyei ne, “Au i lok galanga ye Mesaia yo tiwete ene ye Kirisi i, in ole isi. Inbe ye kene yo bet isi ye in nga, ngan ole ipagalanga lodo ye so nga le imot.” ");
INSERT INTO apr_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Motong la Yesu iwete panga nen, “Ai, au tani naii la dookoot nga awetewete pong i.” ");
INSERT INTO apr_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Yesu iwetewete pang garup tani in go, inbe di galiunu timulu ke malala mai a tisi. Ngan tikamata yo yeru tiwetewete nga, le titakrai. Bong di atu sa mala bet itoru nen, “Nga kusere soo so?” too “Nga gelei a kuye garup i kawetewete nga?” ngan tiap. ");
INSERT INTO apr_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Motong la garup tani in igege bor ki ke ran in sila iken, inbe imulu a ilo pang malala lo iwete pang di tooltool nen, ");
INSERT INTO apr_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Ai, kaman a tadu du kakamata tool atu ni ngan. Tool ni iwete pau ye so le imot yo ayei mugu nga. Ye ni o Kirisi tani, too?” ");
INSERT INTO apr_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Motong la di tooltool tina ngan tigege malala mai tani, inbe tidu pang ye bet du tikamata. ");
INSERT INTO apr_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Ngan ye kene tani in Yesu di galiunu tiwete panga nen, “Pannoongoo, kon so pa ngan.” ");
INSERT INTO apr_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Bong ngan iwete pang di nen, “Au i kaningi kiau yo bet akan nga, ngan ang nga lomu galanga ye tiap.” ");
INSERT INTO apr_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Ngan iwete nen, le nga di galiunu di tapdi tiwetewete nen, “Ai, o tool sa ikap kaningi si ikap panga a ikan, too?” ");
INSERT INTO apr_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Motong la Yesu iyei ne, “Kaningi yo kiau i, in nen, bet ole atoo tool yo iwangau a asi, in lono, inbe ayei porai urata ki. ");
INSERT INTO apr_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Ang nga kawete bet taudu pai mulu la iken pang dama nga, lo ngan bet takana so matana. Bong awete pang nen, matamu gaga a kakamata kumu nga, ngan dingding patunu ke kaningi nga, ngan isullungu ke bet tagogo oo. ");
INSERT INTO apr_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Ngan tool yo iyei urata ye goganga kaningi i, in dookoot nga ikap pat ye urata kootoonoo ki. Moolmool, dookoot nga ye in la igogo kaningi yo ke nepongo dook mata yo taukan motingi i. Ngan nen le tool yo ke penge kaningi in iye tool yo ke goganga kaningi i, in ole yeru le ru bet lodi ponana. ");
INSERT INTO apr_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Ngan nen le betanga yo tiweta in kanono pombe moolmool nen, ‘Tool atu ole ipe so, inbe tool san ole igogo kaningi kanono.’ ");
INSERT INTO apr_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Au i awangang bet la kagogo kaningi kanono ke kumu yo kayei urata ye tiap nga. Ngan di diemu kapala la urata rau di ye kumu tina ngan, inbe ang nga bet kala kumu leu la kagogo kaningi kanono tina yo pombe ye urata kootoonoo kidi nga.” ");
INSERT INTO apr_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Di tooltool alunu ke Samaria yo tinepe ye malala mai tani nga, ngan tilongo betanga ke garup tani, le nga titara lodi medana pang Yesu. Yesoo, garup tani in iwete nen, “Tool ni iwete pau ye so le imot yo ayei mugu nga.” ");
INSERT INTO apr_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Le nga di tooltool ke Samaria yo tidu pang ye Yesu nga, ngan titoru a timangmang ye bet iye di tinepe kasin ngan. Motong la sila iye di tinepe ye ke ru. ");
INSERT INTO apr_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Ngan nen le di tooltool alunu mulu la titara lodi medana pang Yesu lapau nga, yesoo di tapdi tilongo betanga ye ye taun koonoo. ");
INSERT INTO apr_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Motong la tiwete pang garup tani in nen, “Am nga amtara lomam medana ye betanga kiong yo kuwete ngan leu tiap. Bong dookoot nga am tapmam amlongo betanga ye le lomam galanga nen: Ye in tool tani yo isi bet si ipamulu di tooltool ke tana i ye so dook tiap yo bet igarung di i.” ");
INSERT INTO apr_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Yesu iye di tooltool ke Samaria tinepe ye ke ru tina ngan a imot, motong la igege di sila tinepe inbe ila pang Galili. ");
INSERT INTO apr_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","(Ngan mugu ngan Yesu ye taunu iwete nen, bet tool atu iyei Maro koonoo nga, ngan o ke bet di tooltool ke malala ki ye taunu tilongo betanga ki inbe tiraua panga tiap.) ");
INSERT INTO apr_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Ngan ye kene tani in ipa le la pombe Galili nga, ngan le di tooltool ke Galili lodi ponana ye a tikauu. Yesoo, di ngan tilo Yerusalem ye lal maiyoko kidi Yuda ke sungunu yo tiwete ene ye Paskimoolooningi ke Maro in nga, ngan tikamata so tina le imot yo iyei nga, ngan lapau. ");
INSERT INTO apr_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Motong la Yesu ipa mulu a ila pombe ye malala mai Kana yo iken ye tana ke Galili i. Ngan Kana in malala tani yo mugu ngan iportaka ran le iyei wain ye i. Ye kene tani in tool mai atu yo matan kala urata ke tool kuto mai ki i, in natunu tamoto yo inepe Kapenam in matamatenge mai ikauu. ");
INSERT INTO apr_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Ngan tool mai tani in ilongo betanga ke Yesu bet igege Yudia a iman pang Galili nga, le nga ila pang ye la itoru a imangmang ye bet yeru tidu pang Kapenam, a nen ngan du ikamata natunu a ikarata le tinini dook mata mulu. Yesoo, mooloo tiap ngo bet natunu tani imata. ");
INSERT INTO apr_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Ngan iwete nen, motong la Yesu iwete panga nen, “Ang tooltool nga ole kakamata mos matana matana inbe urata maimai yo ayei nga, ngan la bet o katara lomu medana yau nga, too?” ");
INSERT INTO apr_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Ngan tool mai tani in iwete panga nen, “Tool mai, kupa tarrai a kuman a aru tadu, mooloo tiap natuk ni ngo bet imata.” ");
INSERT INTO apr_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Motong la Yesu iyei ne, “Kudu. Natum ni ole imata tiap.” Le nga tool mai tani in itara lono medana ye betanga ke Yesu, inbe imulu a idu. ");
INSERT INTO apr_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Ngan ye kene yo ipa dada go ye in nga, ngan itauarai di kapraingi ki yo tikaua bingi ke natunu tani in a tise nga. Le nga tiwete panga nen, “Ai, natum tani, in tinini dook mata mulu oo.” ");
INSERT INTO apr_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Motong la itor di ye ke matana yo tinini dook mata mulu ye i. Ngan tiwete nen, “Rono pang rrai ye so ben ke matana atu, ngan matamatenge ikoo ye a tinini dook mata mulu.” ");
INSERT INTO apr_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Motong la kase tani in tamana lon galanga nen, rono ye so ben ke matana atu, ngan Yesu iwete panga nen, “Natum ni ole imata tiap.” Ngan nen le tool mai tani in iye di tooltool yo tinepe rumu ki nga, ngan di le imot titara lodi medana pang Yesu. ");
INSERT INTO apr_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Le i mos ru ki yo iyeii ye kene yo ipa ke Yudia a imulu a ila Galili ye i. ");
INSERT INTO apr_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Yesu inepe a ke kapala iman a ila, le nga lal maiyoko kidi Yuda san mulu bet pombe, motong la imadit a ilo pang Yerusalem. ");
INSERT INTO apr_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Ilo Yerusalem, ngan pombe ye ran atu yo tiwete ene ye di Ibru koodi, ngan tiweta ye Betseda i. Ngan ran tani in iken potai pang ye dada ke koongoo yo tiweta ye Dada Kidi Sipsip, inbe tire bale limi le iwakaii i. ");
INSERT INTO apr_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","4","Inbe di tooltool malala mai yo matamatenge ikap di nga, ngan tikenen bale tina ngan parmana. Di ngan kapala matadi kisis, inbe kapala ngan kedi dook tiap, inbe kapala ngan tikap rama. ");
INSERT INTO apr_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Ngan tool kidi atu yo ikap rama a ikenen ye ni tani lapau i, in matamatenge ikauu mukot le inepe ye rai sangaul tol inbe balana limi be tol oo. ");
INSERT INTO apr_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Ngan ye kene tani in Yesu ikamata yo ikenen nga, le nga lon tar nen tool i o matamatenge ikauu mukot. Motong la itoru nen, “Ai, ngan lom bet tinim dook mulu, too?” ");
INSERT INTO apr_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Ngan tool tani se iraua betanga ki nen, “Atoo, tool mai, au i taukak tool yo bet ilonau a ikau au a adu ran lono ye kene yo ran bolbolbe ye i. Au tauk i akapge bet adu ran lono, bong di diek yo timugu nga, ngan ole tidada sukau a tidu ran lono, inbe akino.” ");
INSERT INTO apr_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Motong la Yesu iwete panga nen, “Kumadit! Kouo moi kiong a kupa.” ");
INSERT INTO apr_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Yesu iwete nen, le tina pattu leu inbe tool tani in tinini dook mata mulu, inbe imadit a ikaua moi ki a ipa a ila. Ngan ye ke tani yo Yesu ikarata ye i, in ye lal kidi Yuda ke sungunu, ");
INSERT INTO apr_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","le di Yuda tikamata yo ikaua moi ki a ipa nga, le nga tiwete panga nen, “Ai, katai nga lal kiidi Yuda ke sungunu, inbe wer kiidi igunkalidi bet tayei dada yo nen ngan be.” ");
INSERT INTO apr_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Bong ngan iraua betanga kidi nen, “Tool yo ikaratau a le tinik dook mata mulu i, in ye la iwete pau bet akaua moi kiau a apa i.” ");
INSERT INTO apr_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Motong la titoru nen, “Sei tool iwete pong bet kouo moi kiong a kupa i?” ");
INSERT INTO apr_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Ngan tool tani yo tinini dook mata mulu i, in lon sarrara ye tool yo iwete panga nen i, yesoo Yesu la ikatbon di tooltool malala mai yo tinepe ye ni tani in nga. ");
INSERT INTO apr_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Mooloo tiap, inbe Yesu ilo bareme mai ke sungunu lono, ngan ikamata tool tani in, le nga iwete panga. Iyei ne, “Kumata! Ong i tinim dook mata mulu oo. Le ken kuyei sennene mulu be. Ole nen ngan moonoo san mulu yo dook tiap san i, in la bet pombe pang yong i.” ");
INSERT INTO apr_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Motong la tool tani in ila la iwete pang di Yuda nen, “Tool tani yo ikaratau a le tinik dook mata mulu i, in Yesu.” ");
INSERT INTO apr_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Ngan so tina nga Yesu iyei ye lal kidi Yuda ke sungunu, ngan nen le di Yuda tina bet tigarungu. ");
INSERT INTO apr_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Bong ngan Yesu iwete pang di nen, “Tamak i, kanakana ngan ikaua urata le taukan maryoongoo. Le au i ayei urata nen lapau.” ");
INSERT INTO apr_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Ye punu in la le di Yuda tikapge bet tisere dada sa yo bet tiraumate ye i. Yesoo, tiwete idada wer pono kidi ye lal ke sungunu leu tiap, bong iwete bet Maro in ye taunu Tamana. Le ye betanga ki yo nen i, in iwete bet ye in gaongo ben Maro lapau. ");
INSERT INTO apr_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Yesu ilongo tina yo di Yuda tiwete nen nga, motong la iraua betanga kidi nen, “Awete pang moolmool nen, Natunu i ke bet iyeie so sa ye ye taunu lono tiap, bong ole iyei so yo ikamata Tamana iyei, ngan leu. Yesoo, soo so yo Tamana iyei nga, ngan Natunu ole iyei nen lapau. ");
INSERT INTO apr_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Ngan Tamana lono pang Natunu mai san le ole ipitnai so le imot yo iyei nga, ngan panga. Inbe Tamana ole ipitnai so maimai kapala mulu panga le illos so yo dookoot kakamata iyei koot nga. Ngan nen le ole katakrai belebele ye. ");
INSERT INTO apr_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Le nen, Tamana in ipamadit di tooltool yo timmata koot nga le timagur mulu, inbe ikaua nepongo dook mata pang di. Ngan nanga, Natunu ole iyei nen lapau a ikaua nepongo dook mata yo taukan motingi in pang di tooltool ye ye taunu lono. ");
INSERT INTO apr_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Inbe so san mulu in nen, Tamana in ole ikarata betanga ke tool sa tiap, bong urata tani ke karatanga betanga ke di tooltool i, in isuku la Natunu bene, ");
INSERT INTO apr_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","a bet nen ngan di tooltool le imot ole tiraua pang Natunu dawa ben tina yo tiraua pang Tamana nga. Kumata le sei tool bet iraua pang Natunu tiap nga, ngan iraua pang Tamana yo iwanga a isi i, in tiap lapau.” ");
INSERT INTO apr_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Awete pang moolmool nen, sei tool ilongo betanga kiau, inbe itara lono medana pang tool yo iwangau a asi i, in ikaua nepongo dook mata yo taukan motingi i. Inbe tool tani in o ke bet tipaposi ye urata dook tiap ki yo iyei ngan sa, a bet nen ngan Maro iyemenaii ye, ngan tiap, yesoo igege dada ke matenge inbe inepe ye nepongo dook mata yo taukan motingi in oo. ");
INSERT INTO apr_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Awete pang moolmool nen, lal yo bet pombe i, in dookoot nga pombe oo. Le di tooltool yo tinepe ben timmata koot nga, ngan ye kene yo bet tilongo Maro Natunu kalngana a bet titoo nga, ngan ole tikaua nepongo dook mata yo taukan motingi i. ");
INSERT INTO apr_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Ngan Tamana in nepongo dook mata tani in ipa ye. Le gaongo leu ikaua gurana tani in pang Natunu le nepongo dook mata tani in ipa ye lapau. ");
INSERT INTO apr_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Inbe Tamana ikaua gurana mai panga bet ikarata betanga ke di tooltool ye dada le urata kidi yo tiyei nga, yesoo ye in Tool Moolmool ke Maro. ");
INSERT INTO apr_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","“Ken katakrai ye betanga yo awete nga be. Yesoo, lal yo bet pombe i, in ole di tooltool le imot yo timmata a tikenen agoro lono kidi ke matenge nga, ngan tilongo kalngana, ");
INSERT INTO apr_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","ngan ole timadit a tisi tana. Lo ngan bet di tooltool yo tiyei dada dook mata nga, ngan ole timadit a timagur mulu inbe tinepe ye nepongo dook mata yo taukan motingi i. Inbe di tooltool yo tiyei dada dook tiap nga, ngan ole timadit a timagur mulu, lo ngan bet tipapos di ye urata dook tiap kidi yo tiyei nga, a bet nen ngan tiyemenai di ye. ");
INSERT INTO apr_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Au i ke bet ayeie so sa ye au tauk lok tiap. Au i alongo Tamak koonoo le atoo betanga ki, inbe akarata betanga ke di tooltool ye dada kidi yo tiyei nga. Ngan nen le urata kiau ke karatanga betanga tani, in ipa dook mata, yesoo atoo au tauk lok tiap, bong atoo Tamak yo iwangau a asi i, in lono.” ");
INSERT INTO apr_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Motong la Yesu iwete mulu nen, “Kumata bet au tauk awetewete pang ye urata le dada kiau au tauk nga, ngan ole kawete bet betanga kiau nga moolmool tiap. ");
INSERT INTO apr_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Bong tool san la bet ikaua nek a iwetewete, inbe ipaposau ye urata le dada kiau yo ayei nga. Le lok galanga nen, betanga ki yo bet iwetewete yau nga, ngan moolmool le imot. ");
INSERT INTO apr_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Mugu ngan kawanga di tooltool a tila ye Yowan bet la titor yau nga, ngan le iwete betanga moolmool pang di yau lapau. ");
INSERT INTO apr_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Moolmool, au i asere tool ke tana i sa bet iwetewete yau tiap, bong awete nen pang nga, ngan bet nen a nen ngan Maro ikau ang a ipamulang ye so dook tiap yo bet igarungang i. ");
INSERT INTO apr_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Yowan in iyei ben sul loloana le ilolo a ilangarai di tooltool. Ngan le lomu ponana ye sul ki ye manga modono kasin. ");
INSERT INTO apr_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","“Bong so san mulu yo ipaposau le illos betanga ke Yowan yo iwetewete yau i, in nen. Urata yo Tamak itar la bek bet ayei porai nga, ngan la ayei le ipaposau pang di tooltool bet au i Tamak la iwangau a asi i. ");
INSERT INTO apr_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Ngan Tamak yo iwangau a asi i, in ye taunu la iwetewete yau a ipaposau i. Bong ang nga kalongo toko kalngana, inbe kakamata toko matana pitiao. ");
INSERT INTO apr_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Inbe kaparama betanga ki sa a iken lomu tiap, yesoo ang nga katara lomu medana pang tool yo iwanga a isi i, in tiap. ");
INSERT INTO apr_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Kanakana ngan ang nga kasitoo kinkatingi betanga ke Maro yo iken ye rau ki nga, yesoo lomu tar nen, betanga tina ngan la bet ikaua nepongo dook mata yo taukan motingi in pang i. Bong awete pang nen, betanga tina yo iken ye Rau ke Maro nga, ngan la iwetewete yau a ipaposau nga. ");
INSERT INTO apr_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Bong ang nga lomu bet kaman pang yau, a bet nen ngan man kakaua nepongo dook mata yo taukan motingi i, in tiap. ");
INSERT INTO apr_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Au i asere tool ke tana i sa bet iyitmaka ek, nga tiap, ");
INSERT INTO apr_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","bong au i lok galanga yang oo. Ang ngan lomu pang Maro mai san tiap. ");
INSERT INTO apr_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Au i akaua Tamak damono ngan la le apa ye ene a asi nga, bong lomu pau tiap. Bong kumata le tool atu bet ipa ye ye taunu ene a iman nga, ngan ole pattu leu be lomu ponana ye a katoo betanga ki. ");
INSERT INTO apr_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Ang ngan lomu ponana yo bet di diemu tiyitmakang nga, bong lomu bet kayeie dada dook mata sa pang Maro yetaleu, a bet nen ngan iyitmakang ye, nga tiap. Ngan bet nen nga, ngan ole katara lomu medana pau balai? ");
INSERT INTO apr_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","“Ken lomu tar bet au i la bet lo akodo dama ke Tamada, inbe awetewetang a apaposang ye urata dook tiap kiang yo kayei, nga be. Bong tool yo bet iwetewetang a ipaposang pang Tamada ye urata kiang yo kayei nga, in la Mose, tool tani yo katara lomu ye bet ole ilonang i. ");
INSERT INTO apr_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Kumata bet katara lomu medana ye betanga ke Mose nga, ngan ole katara lomu medana ye betanga kiau lapau, yesoo betanga yo Mose iwodo nga, ngan iwetewete yau i. ");
INSERT INTO apr_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Bong kumata bet katara lomu medana ye betanga yo Mose iwodo, ngan tiap nga, ngan ole kayei balai bet katara lomu medana ye betanga kiau yo awete nga?” ");
INSERT INTO apr_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Tinepe a ke kapala iman a ila, motong la Yesu imadit a ila pang ye ran yo Galili i, in koonoo kapala. Ngan ran tani in tiwete ene san ye Taibirias. ");
INSERT INTO apr_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Ngan di tooltool malala mai tikamata mos yo iyei ye di tooltool yo matamatenge ikap di nga, le nga di lapau timadit a titoo. ");
INSERT INTO apr_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Motong la Yesu inau a ilo ye kawal atu madini a lo iye di galiunu tiwur. ");
INSERT INTO apr_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Ngan ye kene tani in, lal kidi Yuda ke sungunu yo tiweta ye Paskimoolooningi ke Maro i, in potai oo. ");
INSERT INTO apr_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Le nga Yesu bet matan gaga, ngan ikamata di tooltool malala mai tina yo timan pang ye nga, motong la itoro Pilip nen, “Ai, nga ole tayimi kaningi ngai pang di tooltool nga bet tapakan di ye nga?” ");
INSERT INTO apr_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Ngan betanga ke Yesu yo itor ye i, in bet nen a itoua ye, yesoo ye taunu in lon galanga ye so yo bet iyeii, in oo. ");
INSERT INTO apr_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Itoro Pilip nen, le nga Pilip iraua betanga ki. Iyei ne, “Ona, kumata bet tayimi porong ye pat silba ke yimoongoo so ben 200 nga, ngan o ke bet di tooltool nga le imot ole di atu atu tikanen kasin kasin leu.” ");
INSERT INTO apr_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Motong la Yesu galiunu san yo Antares i, ye in Simon Pita taini, in iwete pang Yesu nen, ");
INSERT INTO apr_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Tool kase atu yo inepe ni, in porong ki nga dukumu limi, inbe i paranga ki ru leu. Bong di tooltool nga malala mai san. Le bet nen ngan ole porong le i tina nga ilonidi balai?” ");
INSERT INTO apr_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Antares iwete panga nen, motong la Yesu iyei ne, “Kawete pang di tooltool ngan a sila tiwur.” Ngan ni tani in dingding isup ye le alunu, le di tooltool tina ngan du tiwur dingding pono. Ngan kinkatingi kidi tamoto leu ngan ben 5,000. ");
INSERT INTO apr_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Di tooltool tina ngan du tiwur, motong la Yesu ikap porong dukumu tina a iwete lo ponana ki pang Maro ye, inbe itepalapala a iwete bet timalimi di tooltool tina ngan ye. Motong la iyei nen lapau ye i ru tina a timalimi di, ngan le tikap le lo ige di tooltool tina le imot. ");
INSERT INTO apr_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Ngan le tikan tikan le lo kapodi sung, motong la Yesu iwete pang di galiunu nen, “Kawinnoko kaningi naunu naunu yo iken ngan a kagaua dook, ken le kagege kasin pa a ilene sorok be.” ");
INSERT INTO apr_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Motong la di galiunu tina tiwinnoko porong dukumu limi yo di tooltool tina ngan tikan bet tiwulai naunu naunu nga, ngan a tipadid ngan le ikan karei ponene sangaul be ru. ");
INSERT INTO apr_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Le di tooltool tina ngan tikamata mos tani yo Yesu iyeii i, le tiyei ne, “Moolmool yege, i Maro koonoo tani yo tatar matada ye bet ole isi tana, in naii.” ");
INSERT INTO apr_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Ngan Yesu ilongo tina yo tiwete nen nga, le nga lon galanga ye di nen, nga bet tiparama a nen ngan titaru a iyei tool kuto mai yo bet matan kala tana kidi le imot i. Le nga igege di, inbe yetaleu ilo pang kawal. ");
INSERT INTO apr_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Ye kene tani in tinepe le du rrai, motong la Yesu di galiunu tidu pang ran koonoo. ");
INSERT INTO apr_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Tidu, tinam ngan Yesu pombe pang ye di tarrai tiap. Motong la tisuku ookoo atu a tiyiri ye, a bet tisautu ran a tila pang Kapenam yo iken ke ran koonoo kapala i, ngan bong oo. ");
INSERT INTO apr_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Tikooi a tila, ngan eng mai imadit a kokor ki popobe le dook tiap yege. ");
INSERT INTO apr_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Ngan di galiunu tina, ngan tipoi ye ookoo tani a tila kataunu, le manga mooloo kasin. Inbe matadi nen ngan tikamata Yesu yo ipa ran pono a ipot potai pang ye ookoo nga, le nga titattadaii. ");
INSERT INTO apr_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Bong ngan Yesu iwete pang di nen, “Katattadai be! I au tani naii.” ");
INSERT INTO apr_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Motong la lodi ponana ye a tikauu a ilo ookoo lono, ngan le pattu leu be ookoo ila isolo ye ni tani yo bet tila pang ye i. ");
INSERT INTO apr_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Tinepe a mongmongini ki, motong la di tooltool malala mai tina yo tinepe ran koonoo kapala nga, ngan lodi galanga nen, rono ngan tikamata ookoo ataleu la iken ye ni yo tinepe ye i. Inbe ookoo tani in tikamata toko Yesu pa bet iye di galiunu tiyiri ye, nga tiap, bong di galiunu leu la tiyiri ye a tila nga. ");
INSERT INTO apr_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Motong la ookoo pattu kidi Taibirias tilong le long tisolo potai pang ye ni tani yo Tool Mai iwete lo ponana ki pang Maro ye porong, motong di tooltool tikan i. ");
INSERT INTO apr_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Ngan tina di tooltool tina ngan tikamata toko Yesu iye di galiunu pitiap nga, le nga tiyiri ye ookoo tina ngan a tila pang Kapenam bet la tisere Yesu. ");
INSERT INTO apr_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Di tooltool malala mai tina tila le la tipusye Yesu ran koonoo kapala, motong la titoru. Tiyei ne, “Pannoongoo, kuman ni nga ye soo lal?” ");
INSERT INTO apr_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Motong la Yesu iraua betanga kidi nen, “Awete pang moolmool nen, ang nga kaman kaserau nga, ngan ye mos yo ayeii a iyei ben tarkilanga kiau a kakamata, in tiap, bong ye porong yo apakanang ye a kakan ngan le kapomu sung belebele ye nga. ");
INSERT INTO apr_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Ngan nen le ken urata porang ye kaungu kaningi yo bet ibi palbe le dook tiap, in be, bong bet nen ngan urata porang ye kaungu kaningi yo bet ikaua nepongo dook mata yo taukan motingi i. Ngan kaningi tani in ole Tool Moolmool ke Maro la bet ikauu pang i, yesoo Tamana Maro ipootoo bet ye la ole iyei urata tani i.” ");
INSERT INTO apr_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Yesu iwete pang di nen, motong la titoru nen, “Nga ole amyei balai a bet nen ngan amyei urata ke Maro yo lono dook mata ye nga?” ");
INSERT INTO apr_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Motong la Yesu iraua betanga kidi nen, “Urata ke Maro in nen, bet katara lomu medana pang tool yo Maro iwanga a isi i.” ");
INSERT INTO apr_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Iwete pang di nen, motong la titoru. Tiyei ne, “Ole kuyeie soo mos a nen ngan iyei ben tarkilanga kiong pam bet amkamata, ngan amtara lomam medana yong i? ");
INSERT INTO apr_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Mugu ngan di sasa kiam tikana porong yo ene mana in ye ni soorookoonoo, ben betanga tina yo tiwodo lo ye Rau ke Maro nga. Ngan betanga tina ngan iwete nen, ‘Ye in ikap porong yo ipa ye malala ke Maro, ngan pang di tooltool bet tikan.’ ” ");
INSERT INTO apr_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Motong la Yesu iwete pang di nen, “Mose la ikap porong yo ipa ye malala ke Maro ngan pang di tooltool bet tikan, in tiap, bong Tamak la ikap pang di i. Inbe ye la ikaua porong moolmool yo ipa ye malala ke Maro, in pang i. ");
INSERT INTO apr_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Ngan porong moolmool ke Maro i, in tool yo ipa ye malala ke Maro a isi bet si ikaua nepongo dook mata yo taukan motingi i, in pang di tooltool ke tana i.” ");
INSERT INTO apr_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Yesu iwete nen, motong la tiwete panga. Tiyei ne, “Tool mai, bet nen nga, ngan kanakana ngan kouo porong tani in pam.” ");
INSERT INTO apr_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Motong la Yesu iwete pang di nen, “Au tauk i la porong tani yo ke nepongo dook mata i. Ngan nen le sei tool bet iman yau nga, ngan o ke bet pitola mulu tiap. Inbe sei tool bet itara lono medana pau nga, ngan o ke bet moraku mulu tiap lapau. ");
INSERT INTO apr_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Bong dawa ben awete pang koot nga, ang nga kakamata gurana kiau oo, bong lomu bet katara lomu medana pau tiap. ");
INSERT INTO apr_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Di tooltool le imot yo Tamak ikap di pau nga, ngan ole timan pang yau. Inbe sei tool bet iman pang yau nga, ngan o ke bet anganga tiap lapau. ");
INSERT INTO apr_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Yesoo, au i apa ye malala ke Maro a asi nga, ngan bet si atoo au tauk lok tiap, bong bet si atoo Tool yo iwangau a asi i, in lono. ");
INSERT INTO apr_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Inbe Tool yo iwangau a asi i, in lono nen, bet ken agege di tooltool yo ikap di pau nga, ngan sa le ilene be. Bong bet apamadit di le imot ye lal yo itaru bet ikarata betanga kidi tooltool ye i. ");
INSERT INTO apr_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Ngan Tamak lono nen, bet di tooltool le imot yo titar matadi pang Natunu a titara lodi medana panga nga, ngan ole tikaua nepongo dook mata yo taukan motingi i, inbe ole apamadit di ye lal yo itaru bet ikarata betanga kidi tooltool ye i.” ");
INSERT INTO apr_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Di Yuda tilongo tina yo Yesu iwete bet ye in porong moolmool yo ipa ye malala ke Maro a isi i, le nga katedi malmal a timadit tina le tipasa mur ye. ");
INSERT INTO apr_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Tiyei ne, “Ona tiap! Tool i Yesu, inbe ye in tamana la Yosep i, too? Idi nga lod galanga ye tamana le tinana, e nga gelei bet dookoot nga iwete bet ye in ipa ye malala ke Maro a isi nga?” ");
INSERT INTO apr_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Motong la Yesu iwete pang di nen, “Ai, katemu malmal a kapasa mur yau dookoot! ");
INSERT INTO apr_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Tool sa ke bet itoo ye taunu lono a iman pang yau, ngan tiap, bong bet Tamak yo iwangau a asi i, in ipamaditi lono bet iman, ngan la bet iman pang yau nga. Inbe tool yo nen, in ole apamaditi mulu ye lal yo Maro itaru bet ikarata betanga kidi tooltool ye i. ");
INSERT INTO apr_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Le betanga yo Maro koonoo iwode a iken ye Rau ke Maro in nen, ‘Ole Maro ipatomonai di tooltool nga le imot.’ Ngan nen le di sima tooltool le imot yo tilongo betanga ke Tamak a lodi galanga ye nga, ngan ole timan pang yau. ");
INSERT INTO apr_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Ngan tool sa yo ikamata Tamak koot, ngan tiap, bong tool ataleu yo iye Maro tinepe motong isi i, in leu la ikamata Tamak i. ");
INSERT INTO apr_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Le awete pang moolmool nen, sei tool itara lono medana pau nga, ngan ikaua nepongo dook mata yo taukan motingi i, in oo. ");
INSERT INTO apr_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Au tauk i la porong ke nepongo dook mata tani i. ");
INSERT INTO apr_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Di sasa kiang tikana porong yo ene mana, in ye ni soorookoonoo nga, ngan di le imot timmata. ");
INSERT INTO apr_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Bong porong moolmool tani in ipa ye malala ke Maro a isi, le kumata bet di tooltool tikani, ngan o ke bet timmata tiap. ");
INSERT INTO apr_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Ngan au i la porong tani ke nepongo dook mata yo ipa ye malala ke Maro a isi i. Le kumata sei tool bet ikana porong tani in nga, ngan ole inepe ye nepongo dook mata yo taukan motingi i. Ngan porong tani in au tauk medak yo bet akauu pang di tooltool ke tana i le imot i, a bet nen ngan tikaua nepongo dook mata tani.” ");
INSERT INTO apr_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Yesu iwete nen, le nga di Yuda tina tilongo, le katedi malmal a di tapdi tiparsu inbe tiwetewete nen, “Nga ole tool i iyei balai bet ikap medana a takan nga?” ");
INSERT INTO apr_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Motong la Yesu ikatte betanga pang di nen, “Awete pang moolmool nen, kumata le bet kakana Tool Moolmool ke Maro medana tiap, inbe kayini rara ki tiap lapau nga, ngan o ke bet kakaua nepongo sa yo dook mata, ngan tiap. ");
INSERT INTO apr_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Bong kumata sei tool bet ikana medak, inbe iyin rara kiau nga, ngan ole ikaua nepongo dook mata yo taukan motingi i. Inbe ye lal yo Maro itaru bet ikarata betanga kidi tooltool ye in nga, ngan ole apamaditi mulu ye ni ke matenge. ");
INSERT INTO apr_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Yesoo, au medak in kaningi moolmool, inbe rara kiau in la ran moolmool ke yinungu i. ");
INSERT INTO apr_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Ngan nen le tool yo ikana medak bet iyin rara kiau i, in ole inepe yau, inbe au i anepe ye. ");
INSERT INTO apr_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Tamak yo nepongo dook mata ipa ye i, in ye la iwangau a asi i. Ngan ye in ikaua nepongo dook mata tani in pau. Ngan nen le ye dada gaongo leu ben yo ikaua nepongo dook mata pau nga, ngan la au i ole akaua nepongo dook mata pang di tooltool yo tikana medak nga. ");
INSERT INTO apr_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Le porong moolmool tani yo ipa ye malala ke Maro a isi, in naii. Ngan porong i dawa ben yo mugu ngan di sasa kiang tikani, motong timmata, in tiap. Bong sei tool bet ikana porong moolmool i nga, ngan ole ikaua nepongo dook mata yo taukan motingi i.” ");
INSERT INTO apr_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Ngan Yesu iwete betanga yo nga malala mai Kapenam, ye kene yo lo ipatomonai di tooltool ye rumu kidi Yuda ke gaongo in lono ye i. ");
INSERT INTO apr_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Ye kene tani in Yesu di galiunu alunu la tilongo betanga ki tina yo iwetewete nga, le nga tiyei ne, “Atoo, betanga yo ipatomonai idi ye nga, ngan imoo san. Nga ole sei tool bet ikap i?” ");
INSERT INTO apr_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Bong ngan Yesu lon galanga ye di yo tipasa mur ye betanga ki tina, ngan oo. Le nga iwete pang di nen, “Nga gelei, betanga yo awete nga igarung lomu, too? ");
INSERT INTO apr_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Ngan le bet kakamata Tool Moolmool ke Maro bet imulu a ilo pang ete ye ni yo mugu ngan inepe ye in nga, ngan ole kawete balai? ");
INSERT INTO apr_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Maro Amunu la bet ikaua nepongo dook mata yo taukan motingi in pang di tooltool i. Bong di tooltool ke tana ngan taukadi gurana yo bet tiyei nen ye i. Ngan nanga, betanga yo awete pang ngan ipa ye Maro Amunu, le betanga tina ngan la bet ikaua nepongo dook mata yo taukan motingi in pang i. ");
INSERT INTO apr_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Bong ang kapala ngan katara lomu medana pau tiap.” Yesu iwete nen, yesoo ye kene yo imadit ye urata ki ye in nga, ngan lon galanga ye di tooltool yo bet titara lodi medana panga tiap nga, inbe lon galanga ye tool yo bet pang dama ni ngan ole itaru la di koi ki bedi, in lapau. ");
INSERT INTO apr_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Motong la Yesu iwete mulu nen, “Ye punu in la le awete pang bet tool sa ke bet itoo ye taunu lono a iman pang yau, ngan tiap, bong bet Tamak ipamede bet iman, ngan la bet iman pang yau nga.” ");
INSERT INTO apr_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Ye kene tani in tilongo tina yo Yesu iwete nen nga, le nga di galiunu alunu la tigege a timulumulu pang ni kidi le titoo mulu tiap nga. ");
INSERT INTO apr_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Motong la Yesu itor di galiunu tina yo sangaul be ru ngan nen, “Nga gelei, ang nga lomu bet kagegau a kala lapau, too?” ");
INSERT INTO apr_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Motong la Simon Pita iraua betanga ki nen, “Tool Mai, sei tool bet amla ye i? Ong i, betanga kiong nga ke bet ikaua nepongo dook mata yo taukan motingi i, in pang di tooltool. ");
INSERT INTO apr_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Le am nga lomam galanga yong, inbe amtara lomam medana nen, bet ong i la Tool Tani Yo Maro Ipootoo Panga Ye Taunu I.” ");
INSERT INTO apr_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Pita iwete nen, motong la Yesu iraua betanga ki nen, “Ang di galiuk yo sangaul be ru nga, ngan au tauk la apootang i. Bong emu atu in tool kuto mai kidi so sidi inepe ye!” ");
INSERT INTO apr_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","(Ngan Yesu iwete nen nga ye Yuta yo Simon Iskariot natunu i. Ye in Yesu di galiunu tina yo sangaul be ru nga, ngan atu kidi, bong pang dama ni ngan ole itara Yesu la di koi ki bedi i.) ");
INSERT INTO apr_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Yesu iwete pang di galiunu nen a imot, motong la ipa a iwakaia tana mai kidi Galili leu. Ngan lono bet inepe manga mooloo ye tana mai ke Yudia, yesoo di Yuda ngo tinamu bet ila mulu ni kidi nga, ngan ole tiraumate a imata. ");
INSERT INTO apr_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Bong ye kene tani in lal kidi Yuda ke sungunu yo tiweta ye Mailang ke Badabada i, in iman potai oo. ");
INSERT INTO apr_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Le nga Yesu di taini tiwete panga nen, “Ai, ong i nga ole kugege ni, inbe kulo pang Yudia, a bet nen ngan di galium tikamata mos yo bet kuyei nga. ");
INSERT INTO apr_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Yesoo, kumata tool sa lono bet di tooltool lodi galanga ye nga, ngan ke bet inepe nen inbe iyei urata ki sollono, ngan tiap. Le lom bet kuyei so nen nga, ngan kulo lo ong taum kupapos matam mallangana, a nen ngan di tooltool le imot tikamata so yo kuyei nga.” ");
INSERT INTO apr_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Yesu di taini tina ngan tiwete panga nen, yesoo di ngan titara lodi medana panga tiap. ");
INSERT INTO apr_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Motong la iwete pang di nen, “Lal nga le imot nga, ngan kiang, bong au i lal moolmool yo kiau i, in pombe tiao. ");
INSERT INTO apr_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Ngan di tooltool ke tana i nga, ngan o ke bet lodi dook tiap pang, ngan tiap, bong ole lodi dook tiap pau, yesoo apapos di ye dada dook tiap kidi yo tiyei nga. ");
INSERT INTO apr_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Le bet nen ngan ang kalo ye Mailang ke Badabada tani. E au i o alo tiap, yesoo lal moolmool kiau in pombe tiao.” ");
INSERT INTO apr_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Yesu iwete pang di nen a tilo, inbe ye sila inepe Galili. ");
INSERT INTO apr_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Di taini tina ngan tilo pang ye mailang tani, motong la ye lapau itoo di a ilo. Ngan ipa mallangana tiap, bong ipa sollono le di tooltool tikamata tiap. ");
INSERT INTO apr_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Ye kene tani ngan di tooltool maimai kidi Yuda yo tinepe ye gaongo mai kidi tani in nga, ngan tisere Yesu. Le nga titortor ye a tiyei ne, “Ai, tool tani in ise lapau, too tiap?” ");
INSERT INTO apr_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Le di tooltool malala mai tina yo tigauagaua nga, ngan timangunngun a tiwetewete ye. Ngan di tooltool kapala tiyei ne, “Ye ni tool dook mata.” E di kapala ngan tiyei ne, “Tiap, ye ni illung di tooltool.” ");
INSERT INTO apr_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Bong di tooltool tina ngan ke bet tiwetewete mallangana ye urata yo Yesu iyei, ngan tiap, yesoo titattadai di tooltool maimai kidi Yuda. ");
INSERT INTO apr_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Ye kene tani, in gaongo mai tani in imadit le ilo kataunu tiao, inbe Yesu ipa a ilo koongoo lono ke bareme mai ke sungunu a lo ipatomonai di tooltool. ");
INSERT INTO apr_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Ngan di Yuda tilongo betanga ki tina yo ipatomonai di tooltool ye nga, le nga titakrai ye patomonaingi ki. Inbe tiyei ne, “Ona, tool i inepe toko ye ni ke patomonaingi pitiap. E nga ikaua lo galanga mai i ngai?” ");
INSERT INTO apr_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Motong la Yesu iwete pang di nen, “Betanga yo apatomonai ang ye nga, ngan betanga kiau au tauk tiap, bong ipa ye tool yo iwangau a asi i. ");
INSERT INTO apr_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Le kumata bet sei tool itara lono moolmool bet itoo Maro lono nga, ngan ole lon galanga nen, bet betanga yo apatomonai ang ye nga, ngan ipa ye Maro, too akap ye au tauk lok la awete nga. ");
INSERT INTO apr_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Ngan tool yo ikap betanga ye ye taunu lono a iwete i, in lono bet iyei nen a di tooltool tiyitmaki ye. Bong sei tool yo iyei urata bet di tooltool tiyitmaka tool yo iwanga a isi in ene nga, ngan ye in betanga ki ngan moolmool, le dada yo ke kaplungunu ngan sa iken ye, nga tiap. ");
INSERT INTO apr_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Mugu ngan Mose ikap wer ke Maro pang oo, bong ang ngan sa iparama wer tina, inbe itoo dook, nga tiap. E nga gelei a kakapge bet karaumatau a amata nga?” ");
INSERT INTO apr_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Motong la di tooltool malala mai tina ngan tiwete panga nen, “Ai, ong i o so sidi idiwidiwong! Ngan di sima tooltool tikapge bet tiraumatong nga?” ");
INSERT INTO apr_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Le nga Yesu iwete pang di nen, “Au i ayeie mos atu ye lal kidi Yuda ke sungunu a kakamata, ngan la le ang le imot katakrai ye. ");
INSERT INTO apr_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Bong mugu ngan Mose ikap betanga pang ye dada ke koranga tiniidi nga, ngan le kakoro di natumu yo tamoto ngan tinidi ye lal kiidi Yuda ke sungunu lapau. (Ngan moolmool dada in dookoot imadit ye Mose a ise, nga tiap, bong in dada gurunu ipa ye di sasa kidi.) ");
INSERT INTO apr_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Ngan nen le ang ngan kumata le lal kidi natumu ke koranga tinidi in bet igoro lal kidi Yuda ke sungunu nga, ngan kapas le kakoro tinidi leu. Yesoo, lomu bet katoo wer ke Maro yo iwete pang Mose a iwodo ngan dook. E nga gelei bet katemu malmal pau ye tool atu yo akarata ye lal kidi Yuda ke sungunu a tinini dook mata mulu le imot, in nga? ");
INSERT INTO apr_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Ang nga ken kakamata tool leu, inbe kawete bet ye in tool dook mata, too dook tiap, ngan be! Bong bet nen ngan kanepe a lomu kaua urata ye dada ki dook ngan, lo ngan bet kawete nen kooti.” ");
INSERT INTO apr_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Yesu iwetewete nen a imot, motong la di tooltool pattu ke Yerusalem timadit tina le tiwete nen, “Ai, i tool tani yo tikapge bet tiraumate a imata i? ");
INSERT INTO apr_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Kakamata, ye in iwetewete betanga ki mallangana la di tooltool matadi a tilongo ngan le tiwete toko kan betanga siap. Ngan di tooltool maimai nga lodi tar balai, i Kirisi tani yo Maro ipootoo bet si ikap di tooltool ki a ipamulu di i, in naii, too? ");
INSERT INTO apr_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Bong tool i, lod galanga ye malala ki, le ye in o Kirisi tiap. Yesoo, ye kene yo bet Kirisi isi pombe ye in nga, ngan o ke bet tool sa lon galanga ye malala ki yo ipa ye a isi i, in tiap.” ");
INSERT INTO apr_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Ngan Yesu inepepe koongoo lono ke bareme mai ke sungunu a ipatomonai di tooltool go, inbe isulu katkat a iwete nen, “Ai, ang nga lomu galanga yau, inbe lomu galanga ye malala kiau yo apa ye a asi i. Bong atoo au tauk lok la asi nga tiap, Tamak la iwangau a asi i. Inbe dada ki yo iyei nga, ngan moolmool le imot. Ang nga lomu galanga ye tiap, ");
INSERT INTO apr_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","bong au i lok galanga ye, yesoo au i amru amnepe, motong la iwangau a asi nga.” ");
INSERT INTO apr_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Yesu iwete nen, le nga di Yuda tina ngan tilongo le katedi malmal a tikapge bet tikauu a tiparama. Bong ngan le tool sa iparama tiap, yesoo lal ki in pombe tiao. ");
INSERT INTO apr_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Bong di tooltool yo tinepe ye ni tani nga, ngan alunu la tilongo betanga ki le titara lodi medana panga nga. Le nga tiwete nen, “Ye kene yo bet Kirisi isi ye in nga, ngan ole iyei gogo mos a iyei ben tarkilanga panga le illoso tool i tiap, too?” ");
INSERT INTO apr_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Di Paresi tilongo yo di tooltool malala mai tina ngan tiwetewete a timangunngun ye so yo Yesu iyei nga, le nga tiye di tooltool maimai ke paroranga so pang Maro ngan tiwanga di gaunu yo tikodokala bareme mai ke sungunu nga, ngan bet la tikaua Yesu a tiparama. ");
INSERT INTO apr_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Motong la Yesu iyei ne, “Lal yo bet ayang tanepe ye nga, ngan mooloo tiap, lo ngan bet amulu a alo pang ye Tamak yo iwangau a le asi i. ");
INSERT INTO apr_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Ang nga ole kakaua urata mai ye serengau, bong o kakamatau tiap. Inbe ni yo bet lo anepe ye i, in o ke bet kalo ye tiap.” ");
INSERT INTO apr_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Le nga di Yuda tina ngan di tapdi tiwetewete nen, “Ai, tool i nga ole bet ilo pang ngai a bet takamata mulu tiap nga? Ole ila pang ye di diede kapala yo la tinepe nin la nin kataunu ye di Girik nga, a bet nen ngan la ipatomonai di Girik, too? ");
INSERT INTO apr_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Ngan dookoot nga iwete nen, ‘Ole kakaua urata mai ye serengau, bong o kakamatau tiap. Inbe ni yo bet lo anepe ye i, in o ke bet kalo ye tiap.’ Ngan betanga ki nga, ngan punu balai?” ");
INSERT INTO apr_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Ngan ke yo Mailang ke Badabada tani bet imot ye i, in tikamata ben lal maiyoko pang di. Le nga ye kene tani in Yesu imadit lo ikodo, inbe iwete le koonoo maimai nen, “Kumata sei tool bet moraku nga, ngan iman pang yau, a nen ngan man akap ran panga a iyin. ");
INSERT INTO apr_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Yesoo, betanga yo iken ye Rau ke Maro ngan iwete nen, sei tool bet itara lono medana pau nga, ngan ole ran yo ke nepongo dook mata i, in pombe lono a rongrongbe a idu.” ");
INSERT INTO apr_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Yesu iwete nen nga, ngan ikatte betanga ye Maro Amunu Silene yo bet pang dama ni nga, ngan ole iwanga si ipapon di tooltool yo titara lodi medana panga ngan lodi i. Bong ye kene tani in Maro iwanga Amunu Silene a isi tiao, yesoo iyeie Yesu ene le ilo ete ke bet di tooltool tipayiti ye tiao lapau. ");
INSERT INTO apr_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Di tooltool malala mai tina ngan tilongo yo Yesu iwete nen nga, le nga kapala tiwete nen, “Moolmool sa! Tool i Maro koonoo tani yo tanamu bet isi, in naii.” ");
INSERT INTO apr_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Tiwete nen, ngan di diedi kapala tiyei ne, “Tiap! Ye in Kirisi, tool tani yo Maro ipootoo bet si ipamulu di tooltool ki i.” Ngan tiwete nen, bong ngan di kapala tiyei ne, “Nga gelei, bet Kirisi ole ipa ke Galili, too? Tiap yege! ");
INSERT INTO apr_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Betanga yo iken ye Rau ke Maro ngan iwete bet Kirisi in ole pombe ye rara ke Dawiti. Inbe ole tipasuiu Betlem ye malala yo mugu ngan Dawiti inepe ye i.” ");
INSERT INTO apr_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Ngan tina di tooltool tiwete gogo betanga ye Yesu nen nga, le nga di tapdi tiparpoto le tinepe ye budanga ru. ");
INSERT INTO apr_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Ngan le di tooltool kapala lodi bet tikaua Yesu a tiparama, bong ngan le tool sa itara bene ye tiap. ");
INSERT INTO apr_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Motong la di gaunu tina yo tikodokala bareme mai ke sungunu nga, ngan timulu a tila pang ye di tooltool maimai ke paroranga so pang Maro tiye di Paresi. Tila, motong la di tooltool maimai tina ngan titor di nen, “Nga gelei bet kakaua tool ni a kaman tiap nga?” ");
INSERT INTO apr_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Ngan di gaunu tina tiyei ne, “Mugu ngan tool sa iwete betanga dawa ben yo dookoot nga tool ni iwetewete ye nga, ngan tiap.” ");
INSERT INTO apr_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Motong la di Paresi tirau betanga kidi nen, “Ang nga o ikaua llungunu yang lapau, too? ");
INSERT INTO apr_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Ngan kakamatam Paresi amye di kuto maimai yo matadi kala di Yuda nga, ngan sa itara lono medana panga, too? ");
INSERT INTO apr_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Tiap yege! Di tooltool malala mai ngo, yo lodi galanga ye wer ke Maro tiap nga, ngan di ngan tiyei kapakapa a tilongo panga sa. Bong dookoot, ole Maro igarung di.” ");
INSERT INTO apr_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Di Paresi tina ngan tiwete nen, motong la edi atu yo ene Nikodimas i, in mugu ngan ila ye Yesu la yeru tiwetewete, in itor di nen. Iyei ne, ");
INSERT INTO apr_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Nga gelei, wer kiidi iwete bet tayemenai sorok di tooltool, too? Tiap, iwete bet kulkulunu ngan ole talongo betanga ke tool atu, a nen ngan lod galanga dook ye urata ki yo iyei nga, lo ngan bet tayemenaii kooti.” ");
INSERT INTO apr_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Motong la di Paresi tina ngan tiwete panga nen, “Ona, ong i ke Galili lapau, too? Kumata betanga yo iken ye Rau ke Maro nga, ngan iwete toko pa bet Maro koonoo ole ipa ke Galili, nga tiap.” ");
INSERT INTO apr_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Motong la di tooltool tina ngan tiparmayiri a tila pang ye rumu kidi atu atu nga. ");
INSERT INTO apr_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Di tooltool tina ngan timayiri a tila pang rumu kidi atu atu, bong Yesu in imadit a ilo pang kawal Olip. ");
INSERT INTO apr_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Ilo inepe le muntu bongmai koot, motong la imulu a idu a ilo koongoo lono ke bareme mai ke sungunu. Ngan le di tooltool le imot timan pang ye man tigaua a tigaliuu le tiparkat, motong la du iwur, inbe ipatomonai di nga. ");
INSERT INTO apr_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Inbe di pannoongoo ke wer ke Maro tiye di Paresi tikaua garup atu yo iyei bauk, in a timan le man tipatokode dama kidi tooltool tina, ");
INSERT INTO apr_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","inbe tiwete pang Yesu. Tiyei ne, “Pannoongoo, garup i kerenge, bong tikamata yo iye tamoto san tiyei bauk nga. ");
INSERT INTO apr_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Ngan ye wer ke Maro yo iwete pang Mose a iwodo ngan nen, garup atu bet iyei dada nen nga, ngan ole takatmate ye pat a imata. Le dookoot nga ole kuwete balai?” ");
INSERT INTO apr_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Di kuto maimai tina ngan tiye di Paresi lodi bet titoua. Ngan la le titoru nen nga, a nen ngan bet Yesu koon kapsap ye betanga sa nga, ngan tiweteweta a tipaposi ye betanga ki tina yo iwete nga. Bong ngan Yesu itud du iwodowodo tana ye bene boroborene. ");
INSERT INTO apr_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Ngan ye kene tani in di tooltool tina ngan titor tootoo, le nga itot a imadit le lo ikodo, inbe iwete pang di nen, “Kumata bet ang tina ngan atu bet taukan sennene nga, ngan ye la bet ikaua pat a ikata garup tani in ye mugu i.” ");
INSERT INTO apr_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Iwete pang di nen, motong la itud du iwodowodo tana mulu nga. ");
INSERT INTO apr_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Ngan tilongo tina yo Yesu iwete nen nga, le nga di atu atu tipases a tidu pang tana. Di tooltool yo maimai ngan timugu, inbe yo kakase paunu nga, ngan titoo di a tidu le tiwulaia Yesu yetaleu iye garup tani in sila ikododo dama ki. ");
INSERT INTO apr_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Motong la itot a imadit le lo ikodo, inbe itoro garup tani nen, “Garup, di tooltool tina ngan tila ngai koot? Nga gelei a atu kidi inepe bet ipaposong ye urata dook tiap kiong yo kuyeii i, a bet nen ngan tiyemenai ong ye, in tiap nga?” ");
INSERT INTO apr_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Ngan garup tani in iyei ne, “Tool mai, tool atu sa yo inepe, ngan tiap.” Motong la Yesu iwete panga nen, “Au lapau, au i o ke bet apaposong ye urata dook tiap kiong yo kuyeii i, in tiap. Le dookoot nga kula ngan kuwulaia dada dook tiap kiong ke geingi sennene i.” ");
INSERT INTO apr_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Motong la Yesu iwete pang di tooltool tina yo ipatomonai di ngan mulu nen, “Au i la bet ayei ben sul pang di tooltool ke tana i. Le kumata sei tool bet iman itoo au nga, ngan o ke bet ipa todo lono mulu tiap, bong ole ikaua sul ke nepongo dook mata yo taukan motingi i.” ");
INSERT INTO apr_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Le nga di Paresi tiwete panga nen, “Ai, ong i nga ong taum kuwetewete ye urata le dada kiong yo kuyei nga sa. Ngan nanga, di tooltool yo tilongo betanga kiong nga, ngan o ke bet titara lodi medana ye betanga kiong pitiap yege.” ");
INSERT INTO apr_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Motong la Yesu iraua betanga kidi nen, “Moolmool, au tauk i awetewete ye urata le dada kiau yo ayei nga, bong di tooltool ke bet titara lodi medana ye betanga kiau, yesoo au i lok galanga ye ni yo apa ye a asi i, inbe ye ni yo bet amulu a alo pang ye i. Bong ang nga lomu galanga ye ni yo apa ye a asi i, inbe ye ni yo bet amulu a alo pang ye i, in tiap. ");
INSERT INTO apr_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Ang nga bet kakarata betanga kidi diemu ye dada kidi yo tiyei nga, ngan katoo dada kidi tooltool ke tana i leu. Bong au tauk i akarata betanga ke tool sa ye dada ki yo iyei nga, ngan tiap. ");
INSERT INTO apr_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Bong kumata le bet akarata betanga ke tool sa ye dada ki yo iyei nga, ngan matin nga le atoo betanga yo moolmool nga leu. Yesoo, autaleu la akarata betanga, i tiap, bong aye Tamak yo iwangau a asi i, in la amru amyei urata nen i. ");
INSERT INTO apr_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Ngan ye wer kiang ang tapmu i, in tiwode nen, bet di tooltool ru tiwete betanga atu nga, ngan betanga kidi in moolmool. ");
INSERT INTO apr_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Le kumata bet au tauk i awetewete ye urata le dada kiau yo ayei nga, inbe Tamak yo iwangau a asi in ikata suanga ye nga, ngan betanga kiau ngan moolmool.” ");
INSERT INTO apr_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Yesu iwete nen, motong la di Paresi tina ngan titoru. Tiyei ne, “Tamam yo kuweta i, in inepe ngai?” Motong la iraua betanga kidi nen, “Ang nga lomu galanga yau tiap, ngan la le lomu galanga ye Tamak tiap nga. Kumata bet lomu galanga yau nga, ngan ole lomu galanga ye Tamak lapau.” ");
INSERT INTO apr_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Ngan ye kene tani in Yesu inepe potai pang ye rumu lono sokalanga yo titar pat ke bareme mai ke sungunu ye i, inbe iwete betanga nga a ipatomonai di tooltool ye. Bong tool sa ikauu a bet iparama ngan tiap, yesoo lal ki, in pombe tiao. ");
INSERT INTO apr_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Motong la Yesu iwete pang di tooltool tina ngan mulu nen, “Au i bet agegang nga, ngan ole kaserau, bong o kakamatau tiap. Inbe ang nga ole kammata ye sennene kiang yo kayei nga. Ngan nen le ni yo bet alo pang ye i, in ang nga o ke bet kalo ye tiap.” ");
INSERT INTO apr_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Di Yuda tina ngan tilongo yo Yesu iwete nen nga, le nga di tapdi tipartortor a tiyei ne, “Ai, kakamata ole ye taun iraumate a imata, too? Ye punu in la le iwete nen, ‘Ni yo bet alo pang ye i, in ang nga o ke bet kalo ye tiap’ nga, too.” ");
INSERT INTO apr_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Di tooltool tina tiwete nen, bong ngan Yesu isitoo betanga pang di a iyei ne, “Ang nga malala kiang naii lopo i, bong au i malala kiau la ete ni. Inbe ang nga ke tana i, bong au i ke tana i tiap. ");
INSERT INTO apr_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Ngan nen la le mugu ngan awete pang bet ole kammata ye sennene kiang nga. Le kumata bet katara lomu medana pau bet Au Tauk I Tool Tani Yo Inepe Nen I, in tiap nga, ngan ole kammata ye sennene kiang tina yo kayei nga.” ");
INSERT INTO apr_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Motong la di tooltool tina ngan titoru nen, “Oo, ngan ong i sei?” Le nga iraua betanga kidi nen, “Au tauk awete ninau pang mukot le se dookoot nga. ");
INSERT INTO apr_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Ngan au i betanga kiau alunu san la bet awete a apaposang ye urata dook tiap kiang yo kayei nga. Bong o ayei nen tiap, yesoo Tool yo iwangau a asi i, in betanga ki ngan moolmool. Ngan la betanga yo alongo ye nga, ngan nanga la awete le imot pang di tooltool ke tana i nga.” ");
INSERT INTO apr_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Yesu iwete pang di tooltool tina nen, bong di ngan lodi galanga ye yo nga iwetewete pang di ye Tamana, ngan tiap. ");
INSERT INTO apr_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Motong la iwete pang di nen, “Ye kene yo bet kayitmaka Tool Moolmool ke Maro ene ye in nga, ngan ole lomu galanga nen, Au Tauk I Tool Tani Yo Inepe Nen I. Le au i ayeie so sa ye au tauk lok tiap, bong awete betanga ben tina yo Tamak ipatomonai au ye nga, ngan leu. ");
INSERT INTO apr_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Ngan Tamak yo iwangau a le asi i, in inepe yau. Le ke bet igegau a si autaleu anepe nga tiap, yesoo kanakana ngan atoo lono ye so le imot yo ayei nga.” ");
INSERT INTO apr_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Di tooltool tina tilongo betanga yo Yesu iwetewete nga, ngan le di alunu la titara lodi medana panga nga. ");
INSERT INTO apr_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Motong la Yesu iwete pang di Yuda tina yo titara lodi medana panga ngan nen, “Kumata bet kakap betanga kiau yo apatomonai ang ye nga le katoo nga, ngan ang nga ole kayei ben di galiuk moolmool. ");
INSERT INTO apr_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Inbe ole lomu galanga ye betanga moolmool, inbe betanga moolmool tani ole ipamulang ye so yo ikau ang a iparamang i.” ");
INSERT INTO apr_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Yesu iwete nen, motong la di Yuda tina ngan tiwete panga. Tiyei ne, “Ai, am nga sasa kiam la Awaram i, le tool sa ikau am a amyei poranga panga pitiap. E nga gelei kuwete pam bet betanga moolmool tani bet ipamulam ye so yo bet ikau am a iparamam in nga?” ");
INSERT INTO apr_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Motong la Yesu iwete pang di nen, “Awete pang moolmool nen, di tooltool yo tiyei sennene nga, ngan tiyei ben poranga pang sennene. ");
INSERT INTO apr_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Ngan tool yo iyei poranga pang tool mai ki i, in ke bet inepe so ye tool mai ki, ngan tiap, bong tool mai tani in natunu leu la bet inepe so ye i. ");
INSERT INTO apr_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Ngan nanga, kumata le bet Natunu ipamulang ye so yo bet ikau ang a iparamang in nga, ngan ole ipamulang moolmool le kagege so tani in. ");
INSERT INTO apr_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Au i lok galanga yang bet ang nga sasa kiang la Awaram i. Bong lomu pang betanga kiau tiap, ngan nen le kakapge bet karaumatau a amata. ");
INSERT INTO apr_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Au i awetewete pang ye so yo Tamak ipitnai pau nga. E ang ngan kayei so le katoo dada yo tamamu iwete pang ye nga.” ");
INSERT INTO apr_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Yesu iwete nen, motong la di Yuda tina ngan tiyei ne, “Am nga tamamam la Awaram i.” Motong la Yesu iwete nen, “Kumata bet ang nga Awaram di natunu moolmool nga, ngan matin nga le dada kiang ngan gaongo ben ke Awaram. ");
INSERT INTO apr_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Ngan au i awete pang ye betanga moolmool yo alongo ye Maro nga. Bong ang nga kakapge bet karaumatau a amata. Ngan Awaram in iyei dada yo nen, ngan tiap. ");
INSERT INTO apr_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Le ang nga kayei dada ben yo ang tapmu tamamu iyei nga.” Yesu iwete pang di nen, ngan le tiraua betanga ki nen, “Am nga di tinamam tiyei bauk la le kapodi a tipasui am, nga tiap. Am nga Tamamam ataleu in la Maro i.” ");
INSERT INTO apr_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Motong la Yesu iwete pang di nen, “Kumata le ang nga Tamamu moolmool la Maro in nga, ngan matin nga le lomu pau mai san, yesoo au i aye Maro amnepe, motong la asi nga. Inbe au i atoo au tauk lok la asi, nga tiap, bong ye la iwangau a asi i. ");
INSERT INTO apr_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Bong nga gelei a lomu galanga ye betanga kiau yo awete ngan tiap nga? Ngan ye punu in nen, ang nga lomu bet kalongo betanga kiau tina ngan kaparama, ngan tiap. ");
INSERT INTO apr_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Le ang nga tamamu la tool kuto mai kidi so sidi i. Ngan nen le lomu mede bet katoo dada yo ye lon dook mata ye nga. Ngan kulkulunu yege nga, ngan ye in tool ke raumatenge di tooltool. Inbe iparama betanga yo moolmool in tiap, yesoo betanga moolmool ngan sa iken ye tiap. Ngan ye kene yo bet illung nga, ngan ole iwete betanga ki ke kaplungunu, yesoo ye in tool ke llungunu, inbe betanga yo ke kaplungunu nga, ngan tamana la ye in. ");
INSERT INTO apr_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Bong au i awete betanga yo moolmool ngan pang, ngan le katara lomu medana ye betanga kiau, nga tiap. ");
INSERT INTO apr_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Ngan ang nga sei tool ikamatau ben au i akapsap ye sennene i? Le kumata bet au i nga awetewete pang ye betanga moolmool nga, ngan gelei a katara lomu medana ye betanga kiau tiap nga? ");
INSERT INTO apr_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Maro di natunu nga, ngan ole tilongo betanga ki yo iwete nga. Le ye punu yo lomu bet kalongo betanga ke Maro ye tiap i, in nen, ang nga Maro di natunu tiap.” ");
INSERT INTO apr_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Yesu iwete nen, motong la di Yuda tiraua betanga ki. Tiyei ne, “Am nga amwete bet ong in tool ke Samaria, inbe so sidi la idiwidiwong i. Ngan moolmool, too?” ");
INSERT INTO apr_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Motong la Yesu iyei ne, “Tiap! Au i so sidi sa idiwidiwau tiap. Ngan au i nga ayitmaka Tamak ene, bong ang nga karautoo ek. ");
INSERT INTO apr_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Au tauk i lok bet ayeie ek le ilo ete ke bet di tooltool tipayitau ye, nga tiap, bong Maro la lono bet iyei dada nen pau i. Inbe ye in la tool ke karatanga betanga kidi tooltool i. ");
INSERT INTO apr_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Le awete pang moolmool nen, kumata sei tool bet ikap betanga kiau nga le itoo nga, ngan o ke bet imata pitiap yege.” ");
INSERT INTO apr_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Di Yuda tilongo tina yo iwete nen nga, le nga tiyei ne, “Dookoot nga la lomam galanga yong nga, ong i so sidi idiwidiwong. Kumata, Awaram iye di Maro koonoo ngan di le imot timmata. Bong ngan kuwete nen, ‘Kumata sei tool bet ikap betanga kiau le itoo nga, ngan o ke bet imata pitiap yege.’ ");
INSERT INTO apr_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Nga gelei, ong in em mai le kulloso tamada Awaram iye di Maro koonoo yo timmata koot nga, too? Ngan lom tar bet ong in tool balai a le kuwete nen nga?” ");
INSERT INTO apr_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Motong la Yesu iraua betanga kidi nen, “Kumata bet au tauk i ayeie ek le ilo ete ke bet di tooltool tipayitau ye nga, ngan urata kiau yo ayei ngan ben so sorok. Bong Tamak yo kawete bet ye in Maro kiang i, in ye la iyeie ek le ilo ete i. ");
INSERT INTO apr_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Ngan ang nga lomu galanga ye tiap, bong au i lok galanga ye. Ngan kumata le awete bet au i lok galanga ye tiap nga, ngan au i tool ke kaplungunu dawa ben ang nga. Bong lok galanga ye, ngan la le akap betanga ki inbe atoo nga. ");
INSERT INTO apr_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Mugu ngan tamamu yo Awaram in lon ponana bet ikamata lal kiau yo bet asi ye i. Yeiso bet ikamata, ngan le lon ponana kaiye.” ");
INSERT INTO apr_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Di Yuda tilongo tina yo Yesu iwete pang di nen nga, le nga tiwete panga. Tiyei ne, “Ona, ong i rai kiong sangaul limi tiao, e nga gelei a kuwete bet kumata Awaram nga?” ");
INSERT INTO apr_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Motong la Yesu iraua betanga kidi nen, “Awete pang moolmool nen, ye kene yo tipasuiu Awaram tani in tiao nga, ngan Au I Anepe Nen mukot yege.” ");
INSERT INTO apr_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Yesu iwete nen, motong la di Yuda tina tikap pat a bet tikatu ye, bong ngan itarkoo a igege bareme mai ke sungunu lono inbe idu pang tana. ");
INSERT INTO apr_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Yesu igege di Yuda tina, motong la ipa a ila, ngan ikamata tool atu in matan kis. Ngan tool tani in kene yo tinana ipasuiu ye i, ngan matana nga ikis nen. ");
INSERT INTO apr_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Motong la di galiunu tikamata tool tani le nga titoru nen, “Pannoongoo, sei iyei sennene a le tinana ipasuiu ngan matan kis nen nga, ye taunu, too tamana le tinana?” ");
INSERT INTO apr_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Titoru nen, motong la Yesu iraua betanga kidi nen, “Ye taunu, too tamana le tinana la tiyei sennene ngan la le matana nga ikis nen, ngan tiap. Bong so yo nen in bet pombe ye, a bet nen ngan ikarata dada pang Maro bet ipitnai gurana le urata ki le iken mallangana pang di tooltool. ");
INSERT INTO apr_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Dookoot nga ni galanga nen, le ken tayei urata ke tool yo iwangau a asi i. Kumata bet tanepe nen le lo bong pombe nga, ngan kene tani in tool sa ke bet iyei urata yo nen ngan mulu tiap. ");
INSERT INTO apr_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Ngan ye kene yo anepe ye tana i nga, ngan au i la bet ayei ben sul pang di tooltool ke tana i.” ");
INSERT INTO apr_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Yesu iwete nen a imot, motong la ikoronai ngoonoo du ye tana, inbe isaraii ye bene le iyei ben tingi, motong ikap a isama tool mata kis tani, in matana ye. ");
INSERT INTO apr_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Inbe iwete panga nen, “Kula le la kupusu matam ye ran kelingi yo ene Siloam ni.” (Ngan betanga yo Siloam i, in punu ben Tiwanga). Le nga tool tani in ila la ipusu matana, motong la ye kene yo bet imulu a ila pang rumu ki ye in nga, ngan le matan galanga a ikamata ni ye dook mata. ");
INSERT INTO apr_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Motong la di tooltool yo tinepe potai ye nga, ngan tiye di tooltool kapala yo mugu ngan tikamata igaugau pat le so ye di tooltool nga, ngan tikamata le tipartortor nen, “Ai, i tool tani yo mugu ngan iwurur a igaugau pat le so in naii, too?” ");
INSERT INTO apr_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Ngan di tooltool kapala tiyei ne, “E, ye tani naii.” Bong di kapala tiyei ne, “Tiap, ye in matana dawa ben tool tani in leu, bong in tool san.” Ngan tiwete nen, motong la tool tani iyei ne, “Ai, i au tani naii.” ");
INSERT INTO apr_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Le nga di tooltool tina ngan titoru. Tiyei ne, “Nga kuyei balai a le matam rere, inbe kumata ni ye nga?” ");
INSERT INTO apr_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Motong la iwete pang di nen, “Tool yo tipootoo ene ye Yesu i, in iyei tana le iyei ben tingi, motong la isama matak ye, inbe iwete pau bet la apusu matak ye ran kelingi yo Siloam i. Le nga ala la apusu matak ye ran tani, ngan la le matak rere a akamata ni ye nga.” ");
INSERT INTO apr_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Iwete nen, motong la di tooltool tina ngan titoru. Tiyei ne, “Ngan tool tani in inepe ngai?” Ngan iyei ne, “Atoo, au i lok galanga ye tiap.” ");
INSERT INTO apr_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Motong la tikaua tool tani yo mugu ngan matan kis i, in a tila pang ye di Paresi. ");
INSERT INTO apr_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Yesoo, ye kene yo Yesu iyei tana le ben tingi a ikarata tool tani in matana le dook mata ye i, in ye lal kidi Yuda ke sungunu. ");
INSERT INTO apr_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Motong la di Paresi tina ngan titoro tool tani. Tiyei ne, “Ai, matam nga gelei a le dook mata nga?” Ngan tool tani in iwete pang di nen, “Isama matak ye tana yo iyei le ben tingi nga, motong la apusu matak ye ran, ngan la le dookoot nga matak rere a akamata ni ye nga.” ");
INSERT INTO apr_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Iwete pang di nen, motong la di Paresi kapala tiyei ne, “Tool in Maro iwanga la isi, nga tiap, yesoo ikap tutu lal kiidi Yuda yo ke sungunu, in tiap.” Bong di Paresi tina kapala tiyei ne, “Nga gelei, tool yo ke geingi sennene i, in ke bet iyei mos yo nen nga?” Ngan nen le di tapdi tiparpoto. ");
INSERT INTO apr_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Motong la di Paresi tina ngan tiportak bet titoro tool mata kis tani, in mulu nen, “Lom tar bet tool tani yo iyei ong le matam rere i, in tool balai?” Ngan iraua betanga kidi nen, “Ye in Maro koonoo atu.” ");
INSERT INTO apr_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Mugu ngan tool tani in matan kis, motong la dookoot nga matan rere nga, bong di kuto maimai ke di Yuda titara lodi medana ye yo nen, ngan tiap. Le nga tiwanga pang tamana le tinana a timan. ");
INSERT INTO apr_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Timan, motong la titor di nen, “Ai, i angru natumu tani yo kawete bet ye kene yo tinana ipasuiu ye in nga, ngan matan kis, in naii, too? Ngan nga gelei a le dookoot ngan ikamata ni nga?” ");
INSERT INTO apr_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Ngan tamana le tinana tiyei ne, “Amru nga lomam galanga ben i natumam, inbe kene yo tinana ipasuiu ye in nga, ngan matan kis. ");
INSERT INTO apr_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Bong gelei a le dookoot nga ikamata ni, inbe sei tool iyei matana nga le irere i, in amru nga lomam galanga ye tiap. Le bet nen ngan katoru. Ye in tool maiyoko, le ole ye taunu iwete pang.” ");
INSERT INTO apr_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Ngan tool tani in tamana le tinana titattadai di Yuda, ngan la le tiwete betanga nen nga. Titattadai di nen, yesoo mugu ngan di kuto maimai ke di Yuda tiraua betanga bet kumata le tool sa iwete a ipapos ben Yesu in Kirisi nga, ngan ole tigunkala le ke bet ilo rumu kidi Yuda ke gaongo in lono lo iye di tigaua mulu tiap. ");
INSERT INTO apr_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Ngan ye punu in la le tool tani tamana le tinana tiyei ne, “Katoru. Ye in tool maiyoko oo.” ");
INSERT INTO apr_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Motong la di Yuda tina ngan tikiui tool tani yo matan kis in paru ki man tiwete panga nen, “Dookoot nga kuyitmaka Maro ene, inbe kuwete betanga moolmool pam ye matana. Oo kuwete, am nga lomam galanga bet tool yo kuweta i, in tool ke geingi sennene.” ");
INSERT INTO apr_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Tiwete nen, motong la iraua betanga kidi nen, “Au i lok galanga tiap bet ye in tool ke geingi sennene, too tiap. Bong so ataleu yo lok galanga ye, in nen, mugu ngan matak kis, bong dookoot nga matak rere le akamata ni ye.” ");
INSERT INTO apr_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Motong la di Yuda tina ngan titoru mulu nen, “Tool tani in iyeie soo so pong? Inbe iyei matam balai a irere nga?” ");
INSERT INTO apr_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Titoru nen, motong la iraua torungu kidi. Iyei ne, “Awete pang a kalongo koote. E nga gelei a lomu bet kalongo mulu nga? Ang nga o lomu bet kayei ben di galiunu lapau, too?” ");
INSERT INTO apr_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Tool tani in iwete nen, le nga di Paresi tina ngan katedi malmal le tiwete panga nen, “Ong in la kuyei tool tani in galiunu i. Bong am nga Mose di galiunu. ");
INSERT INTO apr_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Inbe am nga lomam galanga nen, betanga yo Mose ikap, ngan Maro iwetekes panga. Bong tool in, lomam galanga ye ni yo ipa ye, in tiap.” ");
INSERT INTO apr_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Motong la tool tani in iraua betanga kidi nen, “Tool ni la iyei matak nga le irere mulu i. E, dookoot nga kawete googoomu a kawete bet lomu galanga ye ni yo ipa ye, in tiap. ");
INSERT INTO apr_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Idi nga lod galanga nen, Maro in ke bet ilongo betanga ke di tooltool yo ke geingi sennene, ngan tiap. Bong ye in ole ilongo betanga ke tool yo isung panga, inbe itoo dada le imot yo Maro lono bet itoo nga. ");
INSERT INTO apr_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Ngan mukot yege ni le se dookoot nga, ngan talongo toko gasanga ke tool sa bet iyeie tool atu yo tinana ipasuiu ngan matan kis in le matan rere, ngan tiap. ");
INSERT INTO apr_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Le kumata bet tool i Maro iwanga la isi ngan tiap nga, ngan matin nga le iyei so yo nen, nga tiap.” ");
INSERT INTO apr_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Iwete nen, motong la di Paresi tiraua betanga ki nen, “Ong in ye kene yo tinam ipasui ong ye in nga, ngan kupa ye sennene la kusi nga. E nga gelei, bet kupatomonai am, too?” Motong la di Paresi tina ngan tigunkala le ke bet ilo rumu kidi Yuda ke gaongo in lono lo iye di tigaua mulu tiap. ");
INSERT INTO apr_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Yesu ilongo betanga ke so tina yo pombe ye tool tani nga, le nga la ipusye, motong la iwete panga nen, “Ai, kutara lom medana pang Tool Moolmool ke Maro, too tiap?” ");
INSERT INTO apr_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Motong la tool tani itoru nen, “Tool mai, atorong, Tool Moolmool ke Maro, in sei? Oo, kuweta pau a nen ngan atara lok medana panga.” ");
INSERT INTO apr_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Tool tani in iwete nen, motong la Yesu iyei ne, “Tool yo dookoot kumata i, in ye tani naii la iwetewete pong i.” ");
INSERT INTO apr_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Motong la tool tani in iyei ne, “Tool Mai, au i atara lok medana pong.” Motong la igun turunu, inbe isung pang Yesu. ");
INSERT INTO apr_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Motong la Yesu iwete panga nen, “Ye punu yo au i asi tana ye i, in bet si akarata betanga ke di tooltool ye dada le urata kidi yo tiyei nga. Ngan nanga, di tooltool yo matadi kisis nga, ngan ole matadi rere a tikamata ni mulu. E di tooltool yo matadi rere a tikamata ni nga, ngan ole tiyei ben di mata kis.” ");
INSERT INTO apr_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Yesu iwete nen, motong la di Paresi pattu yo tinepe potai ye nga, ngan tilongo tina yo iwete nen nga, le nga titoru. Tiyei ne, “Ai, nga gelei? Kuwete bet am nga matamam nga ikisis lapau, too?” ");
INSERT INTO apr_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Motong la iwete pang di nen, “Kumata bet matamu ngan ikisis nga, ngan matin nga le taukamu busunu yo ke sennene nga. Bong dookoot nga kawete bet matamu ngan irere a kakamata ni, le sennene kiang nangan la ikenen go ngan.” ");
INSERT INTO apr_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Motong la Yesu iseke betanga ki mulu a iwete pang di nen, “Awete pang moolmool nen, tool yo bet ilo pang ye di sipsip, ngan ipa ye dada ke koongoo tiap, bong irookoo sorok ye ni san a ilo pang koongoo lono i, in tool ke pinnau inbe tool ke garungunu so kidi tooltool kapala. ");
INSERT INTO apr_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Bong tool yo ipa ye dada ke koongoo a ilo pang koongoo lono i, in tool yo bet matan kala di sipsip i. ");
INSERT INTO apr_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Ngan nen le tool yo ikodokala dada ke koongoo i, in ole iso dada panga. Lo ngan bet ikiu di sipsip ki tina ngan atu atu edi nga, ngan ole tilongo kalngana le titoo, inbe irara di a tidu pang tana. ");
INSERT INTO apr_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Inbe ye kene yo bet irara di sipsip ki ye taunu tina ngan a tidu tana le imot nga, ngan ole ipa le imugu, inbe titoo, yesoo lodi galanga ye kalngana oo. ");
INSERT INTO apr_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Ngan di sipsip tina ke bet titoo soroko tool san tiap. Kumata bet tool san ikiu di nga, ngan ole tikoo, yesoo di ngan lodi galanga ye kalngana tiap.” ");
INSERT INTO apr_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Yesu iwete le ikatte betanga pang di Paresi nen, bong ngan lodi galanga ye betanga yo iwetewete pang di ye nga, ngan punu tiap. ");
INSERT INTO apr_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Le tina iwete pang di mulu nen, “Awete pang moolmool nen. Au tauk i la dada ke koongoo yo bet di sipsip tipa ye i. ");
INSERT INTO apr_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Ngan di tooltool le imot yo timugu a timan pang ye di sipsip nga, ngan di tooltool ke pinnau, inbe di tooltool ke garungunu so kidi tooltool kapala, bong di sipsip tina tilongo kalngadi tiap. ");
INSERT INTO apr_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Ngan au tauk i la dada ke koongoo i. Ngan nen le kumata sei tool bet iman yau a bet nen ngan ilo pang koongoo lono nga, ngan ole apamule ye so dook tiap yo bet igarungu i. Inbe ole ipa a ilo be isi, a bet nen ngan ikap kaningi yo bet ikan a itoka i. ");
INSERT INTO apr_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Ngan tool yo ke pinnau i, in iman bet man ipinau di sipsip, inbe iraumata di a bet igarung di leu. Bong au i asi nga, ngan bet si akaua nepongo yo dook mata le dook mata ki taunu i, in pang di. ");
INSERT INTO apr_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Au i la tool dook mata ke bet matak kala di sipsip i. Ngan tool dook mata ke bet matan kala di sipsip i, in ole ye taunu iraia tinini bet ilon di sipsip ki ye. ");
INSERT INTO apr_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Bong kumata le tikaua tool atu a titaru bet matan kala di sipsip tina, a bet nen ngan ikap pat ye urata kootoonoo ki leu nga, ngan ye in dawa ben di sipsip tina ngan taudi moolmool, in tiap. Le ye kene yo bet ikamata gaunu gok bet iman pang ye di nga, ngan ole igege di sipsip tina sila tikino, inbe ikoo belebele a ila. Lo ngan bet gaunu gok tani in ole iman a man ikan di, inbe inin di a timayiriyiri a tikoo. ");
INSERT INTO apr_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Ngan tool tani in ole ikoo a ila, yesoo ye in iyei urata bet ikap pat ye leu, le lon rru mata ye di sipsip tina, ngan tiap. ");
INSERT INTO apr_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","“Au i la tool dook mata ke bet matak kala di sipsip i. Le lok galanga ye di sipsip kiau, inbe di lodi galanga yau, ");
INSERT INTO apr_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","dawa ben yo Tamak lon galanga yau, inbe au lok galanga ye nga. Inbe ole araia tinik bet alon di sipsip tina ngan ye nga. ");
INSERT INTO apr_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Ngan au i di sipsip kiau kapala lapau, bong di ngan tinepe ye koongoo i tiap. Le ole akap di a timan lapau, a nen ngan ole tilongo kook, inbe man agaua di tiye di sipsip kiau kapala nga le tinepe ye budanga atu, inbe tool ataleu la bet matan kala di i. ");
INSERT INTO apr_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Le ye punu i la le Tamak in lono pau mai san ye i, yesoo au i ole araia tinik a amata, lo ngan bet amadit le se amagur mulu. ");
INSERT INTO apr_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Ngan tool sa ke bet iraumatau a amata le apa so, nga tiap, bong atoo au tauk lok la le ayei nen nga. Ngan au i gurana kiau ke bet araia tinik a amata, inbe gurana kiau ke bet amadit mulu le se amagur, yesoo atoo betanga yo Tamak ikap pau nga.” ");
INSERT INTO apr_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Yesu iwete nen a di Yuda tina ngan tilongo, le nga tiparpoto mulu. ");
INSERT INTO apr_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Ngan nen le di alunu la tiyei ne, “Ai, nga gelei a kalongo tool in koonoo nga? Ye in so sidi idiwidiwoo le ngan iyei kapakapa.” ");
INSERT INTO apr_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Bong ngan di diedi kapala tiyei ne, “Ngan betanga nga ke bet tool yo so sidi idiwidiwoo i, in iwetewete ye, ngan tiap. Ngan lomu balai, so sidi in ke bet iyeie tool yo matan kis in le matan rere, too?” ");
INSERT INTO apr_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Ngan gaongo maiyoko ke sungunu yo bet di Yuda lodi tut ye kene yo di sasa kidi tiso dada ke bareme ke sungunu ye i, in pombe Yerusalem. Ngan lal tani in pombe ngan igoro mou lapau. ");
INSERT INTO apr_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Le nga Yesu ilo bareme mai ke sungunu lono, lo ipa ye ni yo tiwete ene ye Kakawa ke Solomon i. ");
INSERT INTO apr_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Inbe di Yuda timan le man tigaua a tigaliu, inbe tiwete panga nen, “Ai, tanepe kaiye mata oo, ole nge lo kupapos pam a nen ngan lomam galanga yong? Kumata bet ong i Kirisi nga, ngan kuwete pobe pam.” ");
INSERT INTO apr_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Motong la Yesu iraua betanga kidi nen, “Au i awete pang oo, bong ngan katara lomu medana pau tiap. Ngan mos yo ayei ye Tamak ene nga, ngan bet ipaposau pang a kakamata. ");
INSERT INTO apr_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Bong ngan katara lomu medana pau tiap, yesoo ang nga di sipsip kiau tiap. ");
INSERT INTO apr_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Di sipsip kiau nga tilongo kalngak a titoo au. Au i lok galanga ye di, ");
INSERT INTO apr_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","inbe ole akaua nepongo dook mata yo taukan motingi i, in pang di. Ngan nen le ke bet timmata a tilledi, ngan tiap. Inbe tool sa o ke bet man ipasnak di ye bek tiap lapau. ");
INSERT INTO apr_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Yesoo, Tamak la ikap di pau i. Ye in gurana ki mai san le illos so nga le imot, le tool sa ke bet man ipasnak di sipsip nga ye Tamak bene, ngan tiap. ");
INSERT INTO apr_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Ngan au i aye Tamak nga ataleu.” ");
INSERT INTO apr_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Di Yuda tilongo tina yo Yesu iwete nen nga, le nga katedi malmal a tikap pat bet tikatmate ye a imata, ");
INSERT INTO apr_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","bong ngan iwete pang di nen. Iyei ne, “Au i apitnai mos maimai alunu ke Tamak a kakamata oo. E nga mos nangai kakamata ngan lomu dook tiap ye a le kakap pat bet kakatmatau ye i?” ");
INSERT INTO apr_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Motong la di Yuda tina ngan tiwete panga nen, “Am nga bet amkatmatong ye urata dook mata yo kuyei nga, ngan tiap. Bong kon paseme Maro, yesoo ong i tool sorok, bong kuwete bet ong taum in Maro. Le ye punu in la le amkap pat bet amkatmatong ye i.” ");
INSERT INTO apr_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Motong la Yesu iraua betanga kidi nen, “Betanga yo tiwodo lo ye wer kiang, ngan iwete nen, ‘Au i awete nen, ang nga maro.’ ");
INSERT INTO apr_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Mugu ngan Maro iwete betanga ki pang di tooltool, ngan le iwete bet di ngan maro. Le betanga tina ngan tiwodo lo ye rau ki oo, le ke bet tagege sa a idu tana, nga tiap. ");
INSERT INTO apr_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Ngan au i, Tamak ye taunu la ipootau, inbe iwangau a le asi tana i. Bong ngan gelei a awete bet Au i Maro Natunu nga, ngan kawete bet akan paseme Maro nga? ");
INSERT INTO apr_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Kumata le bet ayei urata ke Tamak tiap nga, ngan ken katara lomu medana ye betanga kiau be. ");
INSERT INTO apr_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Bong au i ayei urata ke Tamak. Ngan nen le kumata bet katara lomu medana ye betanga kiau tiap nga, ngan katara lomu medana ye urata yo ayei nga, a nen ngan lomu galanga nen, au i Tamak inepe yau, inbe au i anepe ye Tamak.” ");
INSERT INTO apr_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Yesu iwete nen, le nga di Yuda tina ngan tikapge bet tikauu mulu a tiparama, bong ngan ilungmai di, inbe ikoo a ila. ");
INSERT INTO apr_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Motong la Yesu imulu a ila ngan le la ikessautu ran Yodan le ila pombe ye ni yo mugu ngan Yowan irriu di tooltool ye i. Le nga sila inepe ye ni tani, ");
INSERT INTO apr_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","inbe di tooltool alunu la timan pang ye nga. Ngan timan, motong la di tapdi tiwetewete nen, “Ai, Yowan in iyei toko mos sa bet iyei tarkilanga panga, ngan tiap, bong betanga le imot yo Yowan iwetewete ye tool i nga, ngan moolmool sa.” ");
INSERT INTO apr_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Le ye kene tani in di tooltool yo tinepe ye ni tani nga, ngan alunu la titara lodi medana pang Yesu nga. ");
INSERT INTO apr_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","2","Ngan tool atu yo ene Lasarus i, in matamatenge mai ikauu. Ye in iye di lini ru nga Mata iye Madia, ngan tinepe ye malala yo ene Betani i. Ngan Lasarus lini yo Madia i, in garup tani yo bet iti so ke saliningi yo kini ki dook mata i, in ilo Tool Mai kene pono, inbe imusmus ye ye taunu kutono raunu i. ");
INSERT INTO apr_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Le nga di lini tina ngan tiwanga pang Yesu nen, “Tool Mai, tool tani yo lom panga mai san i, in la matamatenge mai ikauu i.” ");
INSERT INTO apr_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Ye kene yo Yesu ilongo bangana kidi ye in nga, ngan le iwete nen, “Matamatenge ni ke bet iyeie tool ni a imata le ipa so, ngan tiap. Bong bet nen a nen ngan di tooltool tikamata gurana mai ke Maro. Le in dada yo bet iyeie Maro Natunu ene le ilo ete ke bet di tooltool tipayiti ye i.” ");
INSERT INTO apr_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Ngan Yesu in lono pang Mata iye toonoo inbe Lasarus mai san, ");
INSERT INTO apr_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","bong ye kene yo ilongo betanga bet Lasarus in matamatenge mai ikauu nga, ngan le ila tarrai tiap. Inepe ye ke ru mulu ye malala tani yo inepe ye i. ");
INSERT INTO apr_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Le nga ke ru tina ngan imot, motong la iwete pang di galiunu nen, “Ai, nga ole tamulu a tala pang tana mai Yudia mulu.” ");
INSERT INTO apr_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Bong ngan di galiunu tina ngan tiwete panga nen, “Pannoongoo, dookoot sa airi ngan di Yuda tikap malmal pong a tikapge bet tikatmatong ye pat nga. E nga gelei a bet kumulu a kula pang ni nga?” ");
INSERT INTO apr_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Motong la Yesu iyei ne, “Nga gelei, manga yo ke bet ipa ye muntu le du rrai, ngan sangaul be ru, too? Ngan nen le kumata tool bet ipa kemai nga, ngan o ke bet itutu tiap, yesoo ke isini le ikamata ni ye. ");
INSERT INTO apr_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Bong kumata tool bet ipa bong nga, ngan ole itutu, yesoo taukan sul yo bet ikamata ni ye i.” ");
INSERT INTO apr_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Yesu iwete pang di nen a imot, motong la iwete pang di mulu nen, “Tool kiidi Lasarus ni ngo iken mata. Bong ole ala, a la apoongoo a imadit.” ");
INSERT INTO apr_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Motong la di galiunu tiwete nen, “Tool Mai, kumata le bet iken mata nga, ngan ole matamatenge ki imot, le tinini dook mata mulu.” ");
INSERT INTO apr_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Ngan Yesu in iwetewete ye matenge ke Lasarus, bong di galiunu ngan lodi galanga tiap. Tiyeisa o Yesu iwete bet Lasarus nga o iken mata moolmool. ");
INSERT INTO apr_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Motong la Yesu iwete pobe pang di nen, “Lasarus imata oo, ");
INSERT INTO apr_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","bong au i lok ponana yo ala nango tarrai tiap nga, a bet nen ngan kakamata soo so yo bet ayeii panga in nga, ngan ole katara lomu medana pau ye. Oo, kamadit a tala pang ye la takamata.” ");
INSERT INTO apr_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Yesu iwete nen a imot, motong la Tomas yo tiwete ene san ye Didimus i, in iwete pang Yesu di galiunu kapala ngan nen. Iyei ne, “Ai, bet nen ngan idi lapau tamadit a taye Yesu tala, a nen ngan la tiraumatidi taye a tammata.” ");
INSERT INTO apr_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Ye kene yo Yesu iye di galiunu tina ngan tipa le la pombe potai pang ye malala Betani ye in nga, ngan Yesu ilongo betanga ben Lasarus bobono in titaru lo agoro lono ke di matenge a iken ye ke pai oo. ");
INSERT INTO apr_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Ngan Betani tani in iken potai pang Yerusalem le manga mooloo tiap. ");
INSERT INTO apr_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Le nga di Yuda alunu la timan pang ye Mata iye Madia bet man tilon di a bet nen ngan lodi madoko ye lidi yo imata i, in be. ");
INSERT INTO apr_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Ngan ye kene tani yo Mata ilongo betanga ben Yesu la ipa dada i, motong la igege Madia sila inepe rumu, inbe ipakala a ila le la itauaraii dada. ");
INSERT INTO apr_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Motong la iwete panga nen, “Tool Mai, nga yo bet kunepe ni nga, ngan matin nga le lik imata tiap. ");
INSERT INTO apr_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Bong dookoot nga lapau, au i lok galanga nen, kumata bet kutoro Maro ye so sa nga, ngan ole ikauu pong.” ");
INSERT INTO apr_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Mata iwete nen, le nga Yesu iyei ne, “Lim ni ole imadit mulu le imagur.” ");
INSERT INTO apr_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Motong la Mata iwete panga nen, “Au i lok galanga nen, ole imadit mulu ye lal yo Maro itaru bet ikarata betanga kidi tooltool ye i. Yesoo, ye lal tani ngan ole Maro ipamadit di tooltool matedi a timadit mulu le imot.” ");
INSERT INTO apr_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Mata iwete nen, le nga Yesu iwete panga. Iyei ne, “Au tauk i la apamadit di tooltool mulu ye ni ke matenge i, inbe akaua nepongo dook mata pang di i. Ngan nen le sei tool bet itara lono medana pau inbe imata nga, ngan ole imata le ipa so tiap, bong ole imadit mulu a inepe ye nepongo dook mata tani in. ");
INSERT INTO apr_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Inbe di sima tooltool yo timagurgur go, inbe titara lodi medana pau nga, ngan o ke bet timmata le tipa so tiap. Ngan ong i kutara lom medana ye betanga kiau nga, too tiap?” ");
INSERT INTO apr_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Motong la Mata iwete panga nen, “E, Tool Mai, au i atara lok medana yong ben ong i Kirisi. Ong i Maro Natunu yo bet iwanga a isi tana i.” ");
INSERT INTO apr_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Mata iwete nen a imot, motong la imulu a ila koonoo pang toonoo Madia a man imangunngun panga. Iyei ne, “Pannoongoo tani in iman oo, le nga itor yong.” ");
INSERT INTO apr_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Ye kene yo Madia ilongo betanga nen nga, ngan le palbe leu be imadit a ila pang ye Yesu. ");
INSERT INTO apr_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Ngan Yesu ilo pombe malala tiao, bong inepe ye ni tani yo Mata la itauaraii ye i. ");
INSERT INTO apr_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Le nga di Yuda yo tiye Madia tinepe rumu lono a bet tiloni a lono iken dook nga, ngan tikamata tina yo palbe leu be imadit a idu pang tana nga, le nga titoo a tidu. Ngan tiyeisa bet idu a ila pang ye agoro ke di matenge yo titara Lasarus bobono ye i, a nen ngan la itang ye nango. ");
INSERT INTO apr_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Madia imale a ila pombe ye ni tani yo Yesu inepe ye i, le nga ikamata, motong la igun turunu du Yesu kene punu ke dama, inbe iwete panga. Iyei ne, “Tool Mai, nga yo bet kunepe ni nga, ngan matin nga le lik imata tiap.” ");
INSERT INTO apr_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Ngan Yesu ikamata tina yo itang, inbe di Yuda yo titoo a tiye timan nga, ngan titang lapau nga, le nga Yesu lon sakarungu inbe katen pas. ");
INSERT INTO apr_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Motong la itor di nen, “Ni nangai kataru ye i?” Motong la tiwete panga nen, “Tool Mai, kuman man kumata.” ");
INSERT INTO apr_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Yesu la ikamata le nga itang. ");
INSERT INTO apr_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Ngan di Yuda tikamata tina yo itang nga, le nga tiyei ne, “Kakamata nga, ye ni lono pang tool ni mai san.” ");
INSERT INTO apr_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Bong ngan di diedi kapala tiyei ne, “Ye ni ikarata tool yo matan kis in le matan rere mulu, e nga gelei a lono bet ilono tool ni a nen ngan imata be, tiap nga?” ");
INSERT INTO apr_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Yesu ipa le la pombe ye agoro tani yo titara Lasarus bobono ye i, le nga lono dook tiap, inbe katen pas mulu. Ngan agoro tani in iken ke kawal madini. Inbe pat somai atu la titapulu la tikatkala agoro koonoo ye i. ");
INSERT INTO apr_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Motong la iwete pang di nen, “Oo, kapulu pat in a ikoo.” Ngan tool tani imata in lini yo Mata i, in iwete panga nen, “Tool Mai, dookoot nga o ikini a dook tiap oo, yesoo imata a iken ye ke pai oo.” ");
INSERT INTO apr_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Motong la Yesu iwete panga nen, “Mugu ngan awete pong bet kutara lom medana pau, ngan ole kumata gurana mai ke Maro.” ");
INSERT INTO apr_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Yesu iwete nen, le nga tipulu pat tani yo tikatkala agoro koonoo ye i. Motong la itada pang ete, inbe iyei ne, “Tamak, au i lok ponana pong yo kulongo pataraungu kiau nga. ");
INSERT INTO apr_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Au i lok galanga, ong in kanakana ngan kulongo kook. Bong lok ye di tooltool yo tikododo ni nga, ngan la le awete nen, a bet nen ngan titara lodi medana nen, bet ong in la kuwangau a asi i.” ");
INSERT INTO apr_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Yesu iwete nen a imot, motong la koonoo le mai nen, “Lasarus, kupas a kusi tana!” ");
INSERT INTO apr_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Yesu koonoo nen, motong la Lasarus tani in imadit a ipas a isi pang tana. Ngan le ipa ye mala tina yo tipiu kene le bene le damono ye nga. Motong la Yesu iyei ne, “Kagoolook mala ngan ye, inbe kawete panga a ila.” ");
INSERT INTO apr_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Di Yuda tina yo timan bet man matadi so Madia nga, ngan tikamata so yo Yesu iyeii i, le nga di alunu la titara lodi medana panga nga. ");
INSERT INTO apr_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Bong di kapala ngan tila pang ye di Paresi la tiwete pang di ye so tani yo Yesu iyeii i. ");
INSERT INTO apr_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Motong la di tooltool maimai ke paroranga so pang Maro tiye di Paresi tikiu di tooltool kuto maimai kidi Yuda yo matadi kala di ye momo le nepongo kidi nga, ngan man tigaua, inbe tiwete pang di. Tiyei ne, “Ai, nga ole tayei balai? Tool ni iyei gogo mos matana matana alunu san a iyei ben tarkilanga panga oo. ");
INSERT INTO apr_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Kumata le tapatauu bet iyei nen nga, ngan ole di tooltool le imot titara lodi medana panga. Lo ngan bet di Rom ole timan man tigarung di tooltool kiidi le tipa ye bareme mai kiidi yo ke sungunu i.” ");
INSERT INTO apr_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Motong la edi atu yo ene Kepas i, in iyei tool mai ke paroranga so pang Maro ye rai tani in, in iwete pang di nen, “Ang nga lomu galanga ye so siap yege! ");
INSERT INTO apr_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Ang nga lomu galanga ye dada atu yo bet ilonang, in lapau? Dada dook mata in nen: Kumata bet tool atu ikol di tooltool kiidi a imata nga, ngan ole di tooltool kiidi le imot sa tilledi tiap.” ");
INSERT INTO apr_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Kepas iwete betanga nen ye ye taunu lono tiap, bong iyei tool kuto mai ke paroranga so pang Maro ye rai tani in, ngan la le iwete betanga ben di Maro koonoo ye Yesu yo bet imata a nen ngan ilon di Yuda i. ");
INSERT INTO apr_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Ngan imata nga, ngan bet ilon di Yuda leu tiap, bong bet igaua Maro di natunu le imot yo timayiriyiri a tinepe nin la nin nga, a bet nen ngan man tigaua ye budanga atu. ");
INSERT INTO apr_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Le nga ye ke tani in a ilo nga, ngan di tooltool maimai kidi Yuda tigaua a tirau betanga, inbe tisere dada yo bet tiraua Yesu ye a imata i. ");
INSERT INTO apr_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Ngan nen le Yesu ipa mallangana mulu la di Yuda matadi tiap, bong igege ni tani in, inbe ila inepe ye ni atu yo iken potai pang ye ni soorookoonoo i. Ila pombe, motong la iye di galiunu sila tinepe ye malala atu ke ni tani yo ene Epraim i. ");
INSERT INTO apr_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Ye kene tani in lal maiyoko kidi Yuda yo bet lodi tut ye Paskimoolooningi ke Maro i, in potai bet pombe. Le nga di Yuda yo tinepe ye malala kapala nga, ngan alunu tilo pang Yerusalem bet lo titoo momo kidi Yuda a di tapdi tiyei di le tinidi galanga ye Maro matana mugu ngan, lo ngan bet lal ke Paskimoolooningi tani in pombe. ");
INSERT INTO apr_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Tilo, motong la matadi saraia Yesu, ngan tikamata tiap. Le nga tilo tikodo koongoo lono ke bareme mai ke sungunu, inbe di tapdi tipartortor. Tiyei ne, “Ai, nga lomu tar balai? Ole ise ye lal maiyoko ke sungunu i lapau, too tiap?” ");
INSERT INTO apr_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Bong ngan di tooltool maimai ke paroranga so pang Maro tiye di Paresi tikap betanga pang di tooltool nen, kumata le sei tool lon galanga ye Yesu bet inepe ngai nga, ngan bet iwete pang di a bet nen ngan tikauu a tiparama. ");
INSERT INTO apr_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Ke limi be atu mulu la iken go pang dama nga, lo ngan bet lal ke Paskimoolooningi Ke Maro, in pombe. Ye kene tani in Yesu ipa le la pombe Betani, ye malala ke Lasarus, tool tani yo ipamaditi mulu ye ni ke matenge i. ");
INSERT INTO apr_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Motong la di tooltool ke malala tani in tiyeie kanningi atu a bet nen ngan tikanen ye Yesu, inbe lodi ponana ye. Le nga Mata iso kaningi a bet imalimi di ye, inbe Lasarus la iye di tooltool yo tiye Yesu tikan so nga, ngan tiwur ye kakawa ke kaningi so. ");
INSERT INTO apr_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Motong la Madia lo ikaua so ke saliningi yo tikarata ye kai nad le pat ki mai san i, in a isi le si itioo lo Yesu kene pono, inbe imusmus kene ye ye taunu kutono raunu. Ngan so ke saliningi tani in kini ki dook mata san le ingaua rumu lono mai in le imot. ");
INSERT INTO apr_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Bong Yesu di galiunu tina ngan atu, yo ene Yuta Iskariot, tool tani yo bet pang dama ni ngan ole itara Yesu la di koi ki bedi i, in iwete nen, ");
INSERT INTO apr_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Ona tiap! Nga gelei takaua so ke saliningi ni a tayawari tiap nga? Nga yo bet tayawari nga, ngan matin nga le takap pat silba ben 300, lo ngan bet takap pat tina ngan pang di tooltool yo ballingadi tiap nga.” ");
INSERT INTO apr_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Ngan Yuta tani in lono ye di tooltool yo ballingadi tiap nga, ngan la le iwete nen, ngan tiap. Bong iwete nen nga, yesoo ye in tool pinnauene. Ngan ye in urata ki ke bet matan kala depe ke pat kidi, bong kanakana ngan ye taunu ipinau pat tina yo titartar lo ye depe tani nga. ");
INSERT INTO apr_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Yesu ilongo tina yo iwete nen nga, le nga iyei ne, “Ai, kagege sila inepe! Ye in itarmosaia so in pang lal yo bet amata ngan tikaratau a tikelmai au ye i. ");
INSERT INTO apr_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Di tooltool yo ballingadi tiap nga, ngan kanakana ngan ole kaye di kanepe, bong au i o ke bet ayang tanepe ye ke yo kanakana, ngan tiap.” ");
INSERT INTO apr_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Ye kene tani in, di Yuda malala mai la lodi galanga ye Yesu yo inepe Betani nga, le nga tila bet la tikamata. Ngan lodi bet la tikamata Yesu leu tiap, bong bet la tikamata Lasarus yo Yesu ipamaditi mulu ye ni ke matenge, in lapau. ");
INSERT INTO apr_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Le nga di tooltool maimai ke paroranga so pang Maro ngan tikarata betanga bet ole tiraumata Lasarus a imata lapau. ");
INSERT INTO apr_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Yesoo, di Yuda alunu la tikamata so yo Yesu iyeii ye Lasarus i, le nga tigege di kuto maimai tina, inbe tila le la titara lodi medana pang Yesu nga. ");
INSERT INTO apr_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Tinepe a mongmongini ki, le nga di tooltool malala mai tina yo tilo Yerusalem bet lo tikamata lal maiyoko ke sungunu tani nga, ngan tilongo bingi ben Yesu la ipa dada i nga bet se pombe Yerusalem. ");
INSERT INTO apr_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Motong la di tooltool tina ngan tikap so dawa ben kautuku raunu a tipakala a tidu pang diki bet du tikamata. Le nga du tikamata, motong la koodi le mai nen. “Tayitmaka Maro ene! Maro ole iyei urata dook mata pang tool yo isi ye Tool Mai ene i. Maro ole iyei urata dook mata pang tool yo iyei kuto mai a bet matan kala tana kidi Isrel le imot i.” ");
INSERT INTO apr_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Ngan Yesu ikaua asara ke solanga di tooltool yo ene donki i, in kase paunu atu man iwur pono, inbe ipa ye a ilo pang Yerusalem. Ngan iyei nen le iyei betanga tina yo tiwodo lo ye Rau ke Maro nga, ngan iwete nen, ");
INSERT INTO apr_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Ang di tooltool ke malala mai Yerusalem yo iken ye kawal Saion i, ken katattadai be! Kakamata, tool kuto mai kiang yo bet matan kala tana mai kiang le imot i, in ye la iwur ye donki kase paunu atu in pono, a ise i.” ");
INSERT INTO apr_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Ngan kulkulunu yege nga, ngan di galiunu lodi galanga ye betanga tina ngan punu tiap. Bong ye kene yo Yesu imadit mulu a Maro iyeie ene le ilo ete ke bet di tooltool tipayiti nga, motong la lodi tut betanga yo mugu ngan tiwodo a ilo ye Rau ke Maro ye nga, ngan iwete ye Yesu. Inbe ye kene tani in lodi tut ye so le imot yo di tooltool tiyei panga ngan lapau. ");
INSERT INTO apr_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Ngan ye kene yo Yesu koonoo pang Lasarus a imadit mulu ye ni ke matenge nga, ngan di tooltool malala mai la tiye Yesu tinepe nga. Ngan la le di tooltool tina ngan timadit a tikaua bingi ye so tani yo Yesu iyeii i, in pang di tooltool. ");
INSERT INTO apr_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Ngan nen le di tooltool alunu la tilongo betanga ke mos tani yo Yesu iyeii a bet iyei ben tarkilanga panga i, le nga timadit a tipakala a tidu pang diki le du titauaraii dada. ");
INSERT INTO apr_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Di Paresi tikamata di tooltool tina yo tiyei nen nga, le nga di tapdi tiwetewete nen, “Kakamata nga, dookoot nga idi nga o tayeie so siap, yesoo di tooltool le imot la titoo nga.” ");
INSERT INTO apr_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Di tooltool malala mai tina yo tilo pang Yerusalem bet lo tisung ye lal maiyoko ke sungunu tani nga, ngan di tooltool kapala ngan di Girik. ");
INSERT INTO apr_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Le nga di Girik tina ngan tila pang ye Pilip, tool ke malala Betsaida yo iken ye tana mai Galili i. Tila ye, motong la tiwete panga nen, “Tool mai, am nga lomam bet amkamata Yesu pa.” ");
INSERT INTO apr_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Le nga Pilip la iwete pang Antares, motong la yeru timadit a tila la tiwete pang Yesu nga. ");
INSERT INTO apr_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Motong la Yesu iraua betanga kidi yeru nen, “Lal yo Maro bet iyeie Tool Moolmool ke Maro ene le ilo ete ke bet di tooltool tipayiti ye i, in dookoot nga la pombe nga. ");
INSERT INTO apr_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Awete pang moolmool nen, kumata bet tool atu ipe dingding patunu du tana lono tiap nga, ngan ole isup tiap le kanono tani yo ataleu in la bet iken i. Bong kumata bet ipe du tana lono le kulini ibi nga, ngan ole isup a ipu le itar kanono alunu belebele. ");
INSERT INTO apr_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Ngan nen le kumata tool atu bet lono pang nepongo ki ke tana i mai san nga, ngan ole ilene. Bong kumata tool atu bet iwala murini pang nepongo ki ke tana i nga, ngan ole ikaua nepongo dook mata yo taukan motingi i. ");
INSERT INTO apr_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Le kumata sei tool bet ilonau a iyei urata dawa ben kapraingi kiau nga, ngan ole itoo au. Ngan nen le ni nangai yo bet anepe ye i, in ole ye inepe ye lapau. Inbe Tamak ole iyitmaka tool tani yo bet iyei urata kiau i, in ene.” ");
INSERT INTO apr_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Motong la Yesu iwete mulu nen, “Dookoot nga au i lok sakarungu san, le nga ole awete balai? Ole bet ayei ne, ‘Tamak, kulonau a kukutaka so yo bet pombe pang yau dookoot i’? Tiap! Au i ke bet awete nen tiap, yesoo ye punu in la le asi tana ye i, a bet lal ke so moonoo nen nga, ngan pombe pang yau. ");
INSERT INTO apr_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Le Tamak, ong taum kuyeie em le ilo ete ke bet di tooltool tipayitong ye!” Yesu iwete nen, motong la tool atu kalngana iwetewete ke malala ke Maro a isi nen, “Au i ayeie ek le ilo ete ke bet di tooltool tipayitau ye oo, inbe ole ayei nen mulu.” ");
INSERT INTO apr_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Ngan di tooltool malala mai tina yo tikododo potai ye Yesu nga, ngan tilongo, le nga tiyei ne, “Ai, looloo la itara i.” Bong ngan di tooltool kapala tiyei ne, “Tiap! Bangabangana ke Maro atu la iwetewete panga i.” ");
INSERT INTO apr_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Tiwete nen, motong la Yesu iyei ne, “Betanga yo dookoot si kalongo nga, ngan isi bet si ilonau tiap, bong bet ilonang. ");
INSERT INTO apr_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Dookoot nga i lal yo Maro bet ikarata betanga kidi tooltool ke tana i ye dada dook tiap kidi yo tiyei nga. Inbe ye in ole inganga tool yo iyei kuto mai a bet matan kala tana mai i le imot i, in a ikoo. ");
INSERT INTO apr_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Ngan au i dookoot nga anepe ye tana i, bong pang dama ni bet tiyitmakau le lo atuku kai palasingi kaini nga, ngan ole agaua di tooltool le imot a timan pang yau.” ");
INSERT INTO apr_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Yesu iwete nen ngan bet nen a ye taunu ipaposi ye dada yo bet imata ye i. ");
INSERT INTO apr_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Le nga di tooltool malala mai tina ngan tilongo, le tiyei ne, “Am nga lomam galanga bet wer ke Maro iwete nen, bet Kirisi in ole inepe nen a tala. E nga gelei a kuwete bet ole tiyitmaka Tool Moolmool ke Maro nga? Ngan Tool Moolmool ke Maro in sei?” ");
INSERT INTO apr_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Motong la Yesu iwete nen, “Awete pang nen, lal mooloo tiap la bet sul iken kataunu yang nga. Le sul bet ikenen yang nen go nga, ngan kapa ye lulngana, a bet nen ngan todo idukang be. Yesoo, kumata le tool bet ipa todo lono nga, ngan ole lon galanga ye ni nangai yo bet ipa pang ye i, in tiap. ");
INSERT INTO apr_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Le dookoot nga ye kene yo sul tani in ikenen yang go nga, ngan katara lomu medana pang sul tani a bet nen ngan kayei ben sul di natunu.” Yesu iwetewete pang di tooltool tina nen a imot, motong la igege di sila tinepe, inbe itarkoolene ye di a ipa a ila. ");
INSERT INTO apr_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Yesu iyei kaiye mos alunu a iyei ben tarkilanga panga bet di tooltool tikamata, bong titara lodi medana panga pitiap yege. ");
INSERT INTO apr_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Ngan iyei nen nga, ngan le lo iyei betanga ke Maro koonoo yo Esai in iwodo nga, le itar kanono moolmool. Ngan Esai tani in iwete nen, “Tool Mai, sei bet itara lono medana ye betanga kiam i, inbe sei bet ikamata gurana kiong yo kupapos ye urata yo kuyei nga? Tool siap yege.” ");
INSERT INTO apr_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Ngan ye punu yo titara lodi medana pang Yesu ye tiap in nen, yesoo Esai iwodo betanga san mulu in iwete nen, ");
INSERT INTO apr_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Maro iyei matadi le tikamata ni tiap, inbe ipammata lodi le lodi galanga ye so siap. Ole nen ngan matadi nga tikamata so ye, inbe lodi galanga ye betanga punu, ngan ole tiportak lodi a timulu pang yau a bet nen ngan akarata di le dook mata.” ");
INSERT INTO apr_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Esai in iwete nen, yesoo ikamata bet pang dama ni ngan gurana mai ke Yesu ole iyeie ene le ilo ete ke bet di tooltool tipayiti ye, ngan la le iwete betanga nen ye nga. ");
INSERT INTO apr_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Ye kene tani in di tooltool yo titara lodi medana pang Yesu nga, ngan kapala ngan di kuto maimai lapau. Bong titattadai di Paresi, le lodi bet tipapos lo medana kidi tina ngan ila mallangana tiap, yesoo ole nen ngan di Paresi tigunkala di le ke bet tilo rumu kidi Yuda ke gaongo in lono lo tiye di tigaua mulu tiap. ");
INSERT INTO apr_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Ngan di Paresi tina ngan lodi pang dada yo bet di tooltool tiyitmak edi ye, in mai san, bong lodi pang dada yo Maro bet iyitmak edi ye, in tiap. ");
INSERT INTO apr_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Motong la Yesu iwete le maimai nen, “Sei tool bet itara lono medana pau nga, ngan ye in itara lono medana pau leu tiap, bong itara lono medana pang Tamak yo iwangau a asi i, in lapau. ");
INSERT INTO apr_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Inbe sei tool yo ikamatau i, in ikamata Tamak yo iwangau a asi i. ");
INSERT INTO apr_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Ngan au i asi ye tana i nga, ngan dawa ben sul, a bet nen ngan di sima tooltool bet titara lodi medana pau nga, ngan o ke bet tinepe ye ni todo lono mulu tiap. ");
INSERT INTO apr_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Le kumata sei bet ilongo betanga kiau le itoo tiap nga, ngan au tauk i o ke bet apaposi ye urata dook tiap ki yo iyeii i, a bet nen ngan Maro iyemenaii ye, ngan tiap. Yesoo, au i asi nga bet si apapos di tooltool ke tana i ye urata dook tiap kidi yo tiyei nga tiap, bong asi nga bet si akap di a apamulu di ye so dook tiap yo bet igarung di i. ");
INSERT INTO apr_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Bong sei tool bet ikap betanga kiau a iparama tiap, inbe iwala murini pau nga, ngan betanga kiau tina yo awete nga, ngan ole ipaposi ye urata dook tiap ki yo iyeii i, a bet nen ngan Maro iyemenai ye lal yo itaru bet ikarata betanga kidi tooltool ye i. ");
INSERT INTO apr_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Ngan au i awete sorok betanga nga ye au tauk lok tiap, bong Tamak yo iwangau a asi i, in ye la ikap betanga nga pau bet awete, inbe iwete nin dada yo bet awetewete ye i. ");
INSERT INTO apr_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Le lok galanga nen, betanga ke Tamak nga, ngan ke bet ikaua nepongo dook mata yo taukan motingi i, in pang di tooltool. Ngan nen le betanga tina le imot yo awete nga, ngan atoo Tamak koonoo ye betanga yo iwete pau bet awete nga.” ");
INSERT INTO apr_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Ngan ke ataleu iken go pang dama, lo ngan bet lal maiyoko kidi Yuda yo bet lodi tut ye Paskimoolooningi ke Maro i, in pombe. Le nga Yesu lon galanga nen, lal ki yo bet igege tana i inbe imulu a ilo pang ye Tamana i, in iman potai oo. Ngan kulkulunu yege le ise ye kene tani in nga, ngan Yesu lono mai san pang di tooltool ki ye taunu yo tinepe ye tana i. Inbe ye kene yo bet lo imata ye i, in ipitnaia dada yo bet lono pang di mai le mai san moolmool ye i. ");
INSERT INTO apr_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Le nga rrai a Yesu iye di galiunu tigaua bet tikan so. Ngan tool kuto mai kidi so sidi in idiwidiwi Yuta Iskariot, yo Simon natunu i, in lono a bet nen ngan itara Yesu la di koi ki bedi i. ");
INSERT INTO apr_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Ngan Yesu in lon galanga nen, ye in Tamana itar so tina nga le imot la bene bet iyei tool kuto mai a matan kala. Inbe lon galanga nen, ye in Maro iwanga la isi nga, le ole imulu a ilo pang ye Maro. ");
INSERT INTO apr_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Le nga Yesu iwulai kaningi so, inbe imadit tina le idudu sousoungu mooloo ki in du tana, inbe ikap manmaningi pattu a iwitkala lo galini. ");
INSERT INTO apr_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Motong la iti ran du ye omai atu, inbe imadit ye ngasingi di galiunu tina ngan kedi a imanman ye manmaningi yo iwitkala lo galini i. ");
INSERT INTO apr_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Ngan iyei nen le la pombe ye Simon Pita, le nga Pita imadit tina le itoru nen, “Tool Mai, ngan lom balai, ole kungas kek, too?” ");
INSERT INTO apr_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Motong la Yesu iraua betanga ki nen, “So yo ayei nga, dookoot nga ong i lom galanga ye tiap, bong pang dama ni nga, ngan ole lom galanga ye.” ");
INSERT INTO apr_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Le nga Pita iwete panga nen, “Atoo, au i o ke bet amalum pong bet kungas kek pitiap yege.” Pita iwete nen, motong la Yesu iyei ne, “Kumata le bet angas kem tiap nga, ngan ong i o ke bet kunepe yau tiap.” ");
INSERT INTO apr_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Le nga Simon Pita iyei ne, “Tool Mai, bet nen nga, ngan kungas kek leu be, bong kungas bek inbe kutok lapau.” ");
INSERT INTO apr_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Motong la Yesu iwete panga nen, “Tool bet irriu koot nga, ngan ke bet irriu mulu tiap, bong ole ingas kene leu, inbe tinini mai i igalanga le imot. Ngan ang nga tinimu igalanga oo, bong ang nga le imot tiap.” ");
INSERT INTO apr_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Ngan Yesu in lon galanga ye tool yo bet itaru la di koi ki bedi in oo. Ngan ye punu in la le iwete bet di le imot ngan tinidi igalanga tiap nga. ");
INSERT INTO apr_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Yesu ingas di galiunu tina ngan kedi a imot, motong la isousou mulu ye sousoungu mooloo ki tani, inbe imulu la iwur ye nene. Motong la itor di nen, “Ai, ang nga lomu galanga ye soo so yo ayeii pang in lapau, too? ");
INSERT INTO apr_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Ang nga kakiu au ye ‘Pannoongoo’ inbe ‘Tool Mai’ nga, ngan kawete gorrau le dook mata, yesoo au i urata kiau tina nangan. ");
INSERT INTO apr_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Le kumata bet au i Tool Mai inbe Pannoongoo kiang la angas kemu nga, ngan ole ang lapau, kayei nen a kangas di diemu kapala kedi. ");
INSERT INTO apr_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Ngan au i ayei dada nen pang nga, ngan bet nen a matamu too, inbe ang lapau ole kayei dada dawa ben yo ayei pang nga. ");
INSERT INTO apr_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Awete pang moolmool nen, tool yo iyei urata ben kapraingi i, in ene mai le illoso tool mai ki, in tiap. Inbe tool yo tool san iwanga ye urata i, in ene mai le illoso tool yo iwanga i, in tiap lapau. ");
INSERT INTO apr_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Ngan dookoot nga ang ngan lomu galanga ye dada yo ayeii pang, in punu oo. Le kumata bet katoo dook nga, ngan Maro ole iyei urata dook mata pang. ");
INSERT INTO apr_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Betanga yo au i awete nga, ngan pang ang le imot tiap, yesoo au tauk i lok galanga ye di tooltool yo apootoo di pau nga. Bong dookoot bet nen a betanga yo iken ye Rau ke Maro i, in ole kanono pombe moolmool. Ngan betanga tani in iwete nen, ‘Tool yo amru amkan porong i, in ole iyitmaka kene bet iyirtoo au ye.’ ");
INSERT INTO apr_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","“Ngan so yo dookoot awete pang ye nga, ngan kanono pombe moolmool tiao. Bong au i lok bet aso talngamu ye, a bet nen ngan pang dama ni bet pombe nga, ngan ole katara lomu medana nen bet Au I Tool Tani Yo Inepe Nen I. ");
INSERT INTO apr_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Le awete pang moolmool nen, kumata sei tool bet ikaua tool yo awanga a ila, in a iyei dada dook mata panga nga, ngan tool in ben iyei dada dook mata nen pau lapau. Inbe sei tool bet iyei au dook mata nga, ngan tool in iyei dada yo nen ngan pang Tamak yo iwangau a asi i, in lapau.” ");
INSERT INTO apr_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Yesu iwete pang di galiunu nen a imot, inbe ikanamaii ngan lon sakarungu san. Motong la iwete pobe pang di nen, “Awete pang moolmool nen, ang tina nga atu la bet itarau la di koi kiau bedi i.” ");
INSERT INTO apr_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Iwete nen, le nga di galiunu tina ngan lodi sarrara le matadi ikenen ye di diedi, inbe lodi kaua urata nen, ngan iwete nen ye sei. ");
INSERT INTO apr_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Ngan di galiunu tina ngan atu yo Yesu lono panga mai san i, in iwur potai pang ye lapau. ");
INSERT INTO apr_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Le nga Simon Pita iyei tomonai ye kutono pang ene tani bet itoru, ngan sei iwete nen ye i. ");
INSERT INTO apr_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Motong la galiunu tani, in irusu le la itadana Yesu, inbe itoru mos leu nen, “Tool Mai, ngan sei kuwete nen ye i?” ");
INSERT INTO apr_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Le nga Yesu iyei ne, “Nga ole atepala porong kasin, inbe aroro ye sur yo iken omai lono i, lo ngan bet akap pang ang tina nga atu. Ngan ye in tool tani yo awete nen ye i.” Motong la ikap porong kasin a iroro ye sur, inbe ikap pang Yuta Iskariot yo Simon natunu i. ");
INSERT INTO apr_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Ye kene yo Yuta tani in ikap porong tina ngan ye in nga, ngan le Satan idewe a ilo lono. Motong la Yesu iwete panga nen, “Soo so yo lom bet kuyeii i, in kuyei tarraii.” ");
INSERT INTO apr_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Yesu iwete panga nen, le nga di diede kapala yo tiye tiwur ye kakawa ke kaningi so nga, ngan tilongo, bong ngan lodi galanga ye betanga yo Yesu iwete ngan punu tiap. ");
INSERT INTO apr_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Ngan Yuta tani in matan kala depe kidi yo ke pat i, le nga di tooltool kapala tiyeisa o Yesu iwete panga bet la iyimi kaningi man tikan ye lal maiyoko ke sungunu tani, too bet la ikap so pang di tooltool yo ballingadi tiap nga. ");
INSERT INTO apr_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Ngan Yuta ikap porong kasin tina ngan a ikan, le tina palbe leu inbe ipas a idu pang tana. Ngan bong oo. ");
INSERT INTO apr_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Yuta ipas a idu tana a ila, motong la Yesu iwete nen, “So yo dookoot nga bet pombe pang ye Tool Moolmool ke Maro i, in ole iyeie ene le ilo ete ke bet di tooltool tipayiti ye. Inbe urata ki yo bet iyeii i, in ole iyeie Maro ene le ilo ete ke bet di tooltool tipayiti ye lapau. ");
INSERT INTO apr_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Ngan kumata bet iyeie Maro ene le ilo ete nga, ngan Maro ye taunu ole iyeie Natunu tani in ene le ilo ete nen lapau. Le mooloo tiap Maro ole iyeie ene le ilo ete ke bet di tooltool tipayiti ye.” ");
INSERT INTO apr_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Motong la iwete mulu nen, “Di natuk nga, ole ayang tanepe kasin, lo ngan bet kaserau. Ngan betanga i mugu ngan aweta pang di Yuda oo, ngan nanga dookoot nga aweta pang nga. Le malala yo bet alo pang ye i, in ang nga o ke bet kalo ye tiap. ");
INSERT INTO apr_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Le dookoot nga bet awete wer paunu pang nen: Lomu pang di diemu mai san. Ngan au i lok pang mai san, le katoo dada gaongo leu a lomu pang di diemu mai san nen lapau. ");
INSERT INTO apr_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Kumata bet lomu pang di diemu mai san nen nga, ngan ole di tooltool le imot lodi galanga ben ang nga di galiuk moolmool.” ");
INSERT INTO apr_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Yesu iwete nen, le nga Simon Pita itoru. Iyei ne, “Tool Mai, nga bet kulo pang ngai?” Motong la Yesu iraua betanga ki nen, “Malala yo bet alo pang ye i, in dookoot nga ong i o ke bet kutoo au a aru talo ye tiap. Bong pang dama ni nga, ngan ole kutoo au le kuse ye.” ");
INSERT INTO apr_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Motong la Pita itoru mulu nen, “Tool Mai, nga gelei a dookoot nga ke bet atoo ong tiap nga? Au i ole araia tinik bet alonong a amata.” ");
INSERT INTO apr_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Pita iwete nen, motong la Yesu iyei ne, “Ong i lom tar bet ole kuraia tinim moolmool bet kulonau a kumata, too? Ngan awete pong moolmool nen, bong katai nga, ngan ole tareke itang tiao, inbe kupataukala a kuwete le patol bet ong i lom galanga yau tiap.” ");
INSERT INTO apr_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Motong la Yesu iwete pang di galiunu mulu nen, “Ai, lomu sakarungu be. Bong katara lomu le imede pang Maro, inbe katara lomu le imede pau lapau. ");
INSERT INTO apr_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Rumu ke Tamak ni, lono sokalanga alunu san. Le nga amugu a alo nga, ngan bet lo akarata ni pang. Ngan yo bet betanga i moolmool tiap nga, ngan matin nga le awete nen pang tiap. ");
INSERT INTO apr_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Kumata le bet alo akarata ni pang le imot nga, ngan ole amulu a asi bet si akau ang, a bet nen ngan ang lapau ayang talo le lo tanepe ye ni yo bet anepe ye i ");
INSERT INTO apr_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Ngan ang nga lomu galanga ye dada ke malala yo bet alo pang ye i.” ");
INSERT INTO apr_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Yesu iwete nen, motong la Tomas itoru. Iyei ne, “Tool Mai, am nga lomam galanga ye ni yo bet kulo pang ye, in tiap. Le nga ole amyei balai bet lomam galanga ye dada ki nga?” ");
INSERT INTO apr_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Motong la Yesu iraua betanga ki nen, “Au tauk i dada, inbe betanga moolmool ke Maro, inbe nepongo dook mata yo taukan motingi i. Le tool atu sa ke bet ilo pang ye Tamak ye dada san tiap, bong ye autaleu. ");
INSERT INTO apr_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Kumata bet lomu galanga yau moolmool nga, ngan matin nga le lomu galanga dook ye Tamak lapau. Le dookoot katai a ilo nga, ngan la bet lomu galanga ye, inbe kakamata nga.” ");
INSERT INTO apr_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Motong la Pilip iwete panga nen, “Tool Mai, bet kupitnaia Tamam pam nga, ngan ole ige lomam.” ");
INSERT INTO apr_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Le nga Yesu iyei ne, “Ona tiap! Pilip, au i ayang tanepe kaiye san, e nga lom galanga yau tiao, too? Kumata sei tool bet ikamatau koot nga, ngan ye in ikamata Tamak oo. E nga gelei a kuwete bet apitnaia Tamak pang nga? ");
INSERT INTO apr_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Nga gelei, o kutara lom medana ye betanga kiau yo awete bet au i anepe ye Tamak, inbe Tamak inepe yau, ngan tiap, too? Ngan betanga yo awete pang nga, ngan au tauk i akap ye lok la awete, ngan tiap, bong Tamak yo inepe yau i, in ye taunu la iyei urata ki i. ");
INSERT INTO apr_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Le katara lomu medana ye betanga yo awete bet au i anepe ye Tamak, inbe Tamak inepe yau i. Bong kumata le bet kayei nen tiap nga, ngan lomu tut ye mos yo ayei ngan leu, a bet nen ngan ipamadit lomu ngan katara lomu medana ye. ");
INSERT INTO apr_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Awete pang moolmool nen, kumata sei tool bet itara lono medana pau nga, ngan ole iyei urata yo dawa ben ayei nga. Inbe ole iyei urata maimai le illos yo ayei nga, yesoo au i nga bet alo pang ye Tamak. ");
INSERT INTO apr_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Inbe soo so yo kator ye, ye au ek nga, ngan ole ayei, a bet nen ngan ayeie Tamak ene le ilo ete ke bet di tooltool tipayiti ye. ");
INSERT INTO apr_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Ngan nanga, soo so bet ang nga kator ye, ye au ek nga, ngan ole ayei.” ");
INSERT INTO apr_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Motong la Yesu iwete mulu nen, “Kumata le bet ang nga lomu pau mai san nga, ngan ole katoo betanga kiau yo akap pang nga. ");
INSERT INTO apr_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Inbe au i ole atoro Tamak, a nen ngan iyawara Loningi san mulu pang bet inepe yang ye ke tina yo kanakana nga le imot. ");
INSERT INTO apr_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Ngan Loningi tani in Maro Amunu yo bet si ipapos betanga moolmool ke Maro pang i. Le di tooltool ke tana i nga, ngan o ke bet tikauu tiap, yesoo di ngan tikamata tiap, inbe lodi galanga ye tiap lapau. Bong ang nga lomu galanga ye, yesoo inepe yang, inbe ole inepe lomu lapau. ");
INSERT INTO apr_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Au i ke bet agegang le si kanepe sorok dawa ben kase madunu, ngan tiap, bong ole amulu a asi pang yang. ");
INSERT INTO apr_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Ngan nanga, ole tanepe le mooloo tiap, inbe di tooltool ke tana i tikamatau mulu tiap, bong ang nga ole kakamatau, yesoo, au i ole amadit mulu le anepe ye nepongo yo dook mata i. Ngan nen le ang lapau ole kanepe ye nepongo dook mata tani. ");
INSERT INTO apr_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Ye kene tani in ang nga ole lomu galanga nen, au i anepe ye Tamak, inbe ang ngan kanepe yau, inbe au anepe yang. ");
INSERT INTO apr_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Ngan nen le sei tool bet ikap betanga kiau nga a iparama, inbe itoo nga, ngan ye in tool tani yo lono pau mai san i. Inbe tool tani yo lono pau mai san i, in Tamak ole lono panga mai san. Inbe au lapau ole lok panga mai san, le ole au tauk apitnai au panga.” ");
INSERT INTO apr_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Yesu iwete nen, motong la Yuta Iskariot tiap, bong Yuta san in itoro Yesu nen, “Tool Mai, nga gelei a ong taum kupitnai ong pam, bong lom bet kupitnai ong pang di tooltool ke tana i tiap nga?” ");
INSERT INTO apr_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Motong la Yesu iraua betanga ki nen, “Kumata sei tool bet lono pau mai san nga, ngan ole itoo betanga kiau yo apatomonai ang ye nga. Ngan nen le Tamak ole lono panga mai san, inbe ole amru amsi a si amnepe ye tool in. ");
INSERT INTO apr_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Bong sei tool bet lono pau mai san tiap nga, ngan ke bet itoo betanga kiau yo apatomonai ang ye, ngan tiap. Ngan betanga yo awete pang a kalongo nga, ngan au tauk betanga kiau tiap, bong ke Tamak yo iwangau a asi i. ");
INSERT INTO apr_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Ngan ye kene yo ayang tanepe ye i, ngan awete pang ye so tina ngan le imot oo. ");
INSERT INTO apr_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Bong Loningi tani yo bet Tamak iwanga le ipa ye ek a isi i, in Maro Amunu Silene. Ye in ole ipatomonai ang ye so nga le imot, inbe ole ipamadit lomu a nen ngan lomu tut ye so le imot yo awete pang ye nga. ");
INSERT INTO apr_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Ngan au i nga bet agegang a alo, le kanepe ye lo silene yo kiau i. Ngan lo silene kiau yo bet akauu pang i, in dawa ben ke di tooltool ke tana i yo tiyei pang di diedi, nga tiap. Le ken katattadai a lomu sakarungu be. ");
INSERT INTO apr_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","“Ang nga kalongo yo awete pang nen, ‘Au i ole agegang a alo, bong ole amulu pang yang a asi.’ Kumata le bet lomu pau mai san nga, ngan ole lomu ponana yo bet alo pang ye Tamak nga, yesoo Tamak in ene mai san le illosau. ");
INSERT INTO apr_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Ngan lok bet awete pang mugu ngan, lo ngan bet so tani in pombe, a bet nen ngan ye kene yo bet pombe ye in nga, ngan ole katara lomu medana pau. ");
INSERT INTO apr_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Le au i o ke bet ayolo betanga mata tiap, yesoo tool kuto mai yo matan kala tana i, in ye la iman i. Ngan ye in taukan gurana yo bet iyeie so sa pau nga. ");
INSERT INTO apr_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Bong au i bet ayei nen a bet nen ngan di tooltool ke tana i lodi galanga nen, au i lok pang Tamak mai san, ngan la le atoo koonoo bet ayei soo so yo iwete pau ye bet ayei nga.” Yesu iwete pang di nen a imot, motong la iyei ne, “Oo, kamadit. Tagege ni a tala.” ");
INSERT INTO apr_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Yesu iwete nen a imot, motong la iwete pang di galiunu mulu nen, “Au i ooroo yo ene wain i, in kaini moolmool, inbe Tamak in kumu taunu. ");
INSERT INTO apr_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Ngan wain bene le imot yo ipu tiap nga, ngan Tamak ole ingedekat du tana. Inbe bene le imot yo ipu nga, ngan ole isolai le imallanga, a bet nen ngan isudud paunu mulu nga, ngan ipu le kanono alunu belebele. ");
INSERT INTO apr_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Ngan ang nga ben ooroo wain bene yo kumu tamana isolai le imallanga nga, yesoo ang ngan katara lomu medana ye betanga yo awete pang nga. ");
INSERT INTO apr_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Le ang nga kanepe yau nga, ngan au i ole anepe yang nen lapau. Ngan kumata le wain bene atu bet iso ye wain kaini le imede tiap nga, ngan o ke bet ye taunu ipu a itar kanono, ngan tiap. Ngan gaongo leu, kumata le ang ngan kanepe yau le kamede tiap nga, ngan o ke bet kayeie so siap lapau. ");
INSERT INTO apr_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Au i ooroo wain kaini, inbe ang ngan dawa ben wain bene. Ngan kumata tool bet inepe yau le imede inbe au anepe ye nga, ngan ole urata ki yo iyei, ngan itar kanono dook mata. Bong kumata bet inepe yau tiap nga, ngan o ke bet iyeie so siap lapau. ");
INSERT INTO apr_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Kumata le tool atu bet inepe yau le imede tiap nga, ngan ole dawa ben kai bene yo tingedekati a tikatte le iwod i. Ngan kai bene yo nen nga, ngan ole di tooltool tiwinnoko, inbe tikatte lo ei lono a ei ikan. ");
INSERT INTO apr_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Bong kumata bet kanepe yau le kamede, inbe kaparama betanga kiau a katoo dook nga, ngan soo so yo lomu bet katorau ye nga, ngan ole akap pang le imot. ");
INSERT INTO apr_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Inbe ye kene yo bet kayei so nen le itar kanono nga, ngan ole ipaposang ben ang ngan di galiuk moolmool. Le ye dada in la bet kayeie Tamak ene le ilo ete ke bet di tooltool tipayiti ye i. ");
INSERT INTO apr_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","10","“Au i lok pang mai san, dawa ben Tamak yo lono pau mai san i. Ngan kumata le bet katoo betanga kiau yo akap pang nga, ngan ole lok pang mai san, dawa ben yo atoo betanga ke Tamak nga, ngan le Tamak lono pau mai san nga. Ngan nen le kaparama dada tani yo bet lok pang mai san ye i, in le imede. ");
INSERT INTO apr_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","“Ngan au i awete pang ye so nga le imot, a bet nen ngan ayeie ang le lomu ponana dawa ben au i. Le moolmool, lo ponana kiang tani in ole mai le mai san. ");
INSERT INTO apr_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Le betanga kiau yo bet katoo ngan nen: Lomu pang di diemu mai san, dawa ben yo au i lok pang mai san nga. ");
INSERT INTO apr_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Kumata tool atu bet lono pang di tooltool ki mai san, le ye taunu iraia tinini bet imata a ilon di ye nga, ngan ye in ipitnaii ben dada ki yo bet lono pang di tooltool ki ye mai san i, in illos dada yo kapala nga. ");
INSERT INTO apr_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","“Kumata bet katoo betanga kiau yo akap pang ngan dook nga, ngan ang nga ben di tooltool kiau. ");
INSERT INTO apr_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Ngan nen le au i ke bet akiu ang ye kapraingi mulu tiap, yesoo tool yo iyei kapraingi i, in lon galanga ye so yo tool mai ki iyei, ngan tiap. Ngan nanga, ole akiu ang ye di tooltool kiau, yesoo betanga le imot yo Tamak iwete pau ye nga, ngan la awete pang ye koot nga. ");
INSERT INTO apr_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Ang ngan kapootau tiap, bong au i la apootang, inbe akap gurana pang bet la kayei urata, a bet nen ngan urata kiang tina ngan itar kanono, ngan kanono ole iken nen a tala. Le kumata bet kapatarau pang Tamak ye au ek, inbe katoru ye so sa bet ikauu pang nga, ngan ole ikauu pang. ");
INSERT INTO apr_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Le betanga kiau yo akap pang nga, ngan nen: Lomu pang di diemu mai san.” ");
INSERT INTO apr_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Motong la Yesu iwete pang di galiunu tina ngan mulu nen, “Kumata le di tooltool ke tana i bet tikadonang nga, ngan lomu tut nen, mugu ngan tikadonau nen lapau. ");
INSERT INTO apr_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Kumata le bet ang ngan kanepe ben di tooltool ke tana i nga, ngan ole lodi pang mai san ben ang ngan di tooltool kidi tapdi nga. Ngan ye punu yo tikadonang ye i, in nen, ang nga ke tana i tiap, yesoo apootang bet ole kagege dada le momo yo ke tana i nga. ");
INSERT INTO apr_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Le lomu tut betanga yo awete pang koot nga: ‘Tool yo iyei urata ben kapraingi i, in ene mai le illoso tool mai ki, in tiap.’ Ngan nanga, kumata bet di tooltool tiyei dada dook tiap bet tigarungau ye nga, ngan ole tigarungang nen lapau. Inbe kumata le titoo betanga kiau yo bet apatomonai di ye nga, ngan ole titoo betanga kiang nen lapau. ");
INSERT INTO apr_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Ang ngan man katoo au le ole tiyei dada dook tiap yo nen ngan pang, yesoo di ngan lodi galanga ye Tool yo iwangau a asi i, in tiap. ");
INSERT INTO apr_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Le au i yo bet asi a si awete betanga nga pang di tiap nga, ngan matin nga le taukadi sennene yo bet tisolo nga. Bong dookoot nga, taukadi dada yo bet tiyei ne, ‘Am nga lomam galanga bet so yo amyei, ngan amkapsap ye sennene, nga tiap.’ ");
INSERT INTO apr_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Ngan nen le sei tool yo bet ikadonau i, in ikadono Tamak nen lapau. ");
INSERT INTO apr_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Ngan yo bet amye di amnepe inbe ayei urata medana yo tool sa ke bet iyei tiap, ngan tiap nga, ngan matin nga le taukadi sennene yo bet tisolo nga. Bong dookoot nga mos yo ayei ngan tikamata oo, bong tina la tikadonau le tipoorootau pa ye Tamak nga. ");
INSERT INTO apr_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Le dada yo tiyeii i, in bet nen a iyeie betanga atu yo tiwode lo ye wer kidi in le itar kanono moolmool. Ngan betanga tani in iwete nen, ‘Taukadi punu yo bet tikadonau ye i.’ ");
INSERT INTO apr_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Bong Loningi kiang yo bet awanga a isi pang yang i, in iye Tamak tinepe. Ye in Maro Amunu, inbe au i ole awanga a isi bet si ipapos betanga moolmool ke Maro, inbe iwetewete pang di tooltool ye urata yo kiau nga. ");
INSERT INTO apr_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Le ang lapau kawetewete pang di tooltool ye urata kiau, yesoo kulkulunu yege ye kene yo apamaditi urata kiau ye in nga, ngan la ayang tanepe tanepe le se dookoot katai nga.” ");
INSERT INTO apr_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Motong la Yesu iyei ne, “Au i awete pang nen nga, ngan bet nen a lomu medana yo kataru pau i, in katte be. ");
INSERT INTO apr_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Ngan ole tingangang a kakoo ye rumu kidi Yuda ke gaongo. Inbe pang dama ni bet lal pombe nga, ngan ole di tooltool yo tiraumatamatang a kammata nga, ngan ole lodi tar nen bet nga tiyei urata dook mata pang Maro. ");
INSERT INTO apr_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Di ngan ole tiyei dada yo nen ngan pang, yesoo di ngan lodi galanga ye Tamak tiap, inbe lodi galanga yau tiap lapau. ");
INSERT INTO apr_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Ngan au i bet awete betanga nga pang, a bet nen ngan ye kene yo bet tiyei dada nen pang nga, ngan ole lomu tut ye so yo awete pang ye nga. Kulkulunu ngan awete pang ye so yo nga tiap, yesoo au i ayang tanepe.” ");
INSERT INTO apr_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Motong la Yesu iwete mulu nen, “Dookoot nga au i bet amulu a alo pang ye tool tani yo iwangau a asi i, bong ang nga sa itorau bet alo pang ngai, ngan tiap. ");
INSERT INTO apr_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Ang nga lomu madoko mai san ye betanga yo awete pang nga. ");
INSERT INTO apr_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Bong awete pang moolmool nen, ngan dook mata bet agegang a alo, a nen ngan alonang. Yesoo, kumata le bet alo tiap nga, ngan Loningi kiang tani in o isi tiap. Bong kumata le alo nga, ngan la bet ayawari a isi pang yang nga. ");
INSERT INTO apr_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Le ye kene yo bet isi ye in nga, ngan ole ipagalanga di tooltool ke tana i lodi, le lodi galanga ye sennene yo kidi nga, inbe ye dada dook mata noonoonoo yo ke Maro nga, inbe ye lal yo Maro itaru bet iyemenai di tooltool ye i. ");
INSERT INTO apr_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Ngan nen le ole ipagalanga lodi a bet nen ngan lodi galanga bet di ngan tiyei sennene, yesoo di tooltool yo nen ngan titara lodi medana pau tiap. ");
INSERT INTO apr_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Inbe ole ipagalanga lodi ye dada dook mata noonoonoo ke Maro, yesoo au i atoo dada noonoonoo ki le nga bet alo pang ye Tamak, ngan ole ke bet kakamatau mulu tiap. ");
INSERT INTO apr_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Inbe ole ipagalanga lodi lapau ye lal yo Maro itaru bet iyemenai di tooltool ye i, yesoo tool kuto mai yo matan kala tana i, in Maro ipaposi ye urata dook tiap ki yo iyeii i, in oo, le ole iyemenaii ye. ");
INSERT INTO apr_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Au i betanga kiau alunu san la lok bet awete pang ye nga, bong dookoot nga ole imoo pang bet lomu galanga ye nga. ");
INSERT INTO apr_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Bong ye kene yo bet Maro Amunu bet isi a si ipapos betanga moolmool ke Maro nga, ngan ole ipasongosongang ye betanga tina yo moolmool nga. Le betanga yo bet iwete pang ye nga, ngan iwete sorok sa ye ye taunu lono tiap, bong ole iwete pang ye betanga yo ilongo ye Tamak nga, inbe ole iwete pang ye soo so yo bet pang dama ni ngan pombe nga. ");
INSERT INTO apr_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Ye in ole ikap betanga yau, lo ngan bet iwete pang, a nen ngan ye dada yo iyeii nen i, in ole iyeie ek le ilo ete ke bet di tooltool tipayitau ye. ");
INSERT INTO apr_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Ngan so le imot yo ke Tamak nga, ngan kiau. Ngan la le awete pang bet Maro Amunu ole ikap betanga yau, lo ngan bet iwete pang nga.” ");
INSERT INTO apr_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Motong la Yesu iwete pang di mulu nen, “Ole tanepe le mooloo tiap, ngan ole kakamatau mulu tiap. Lo ngan bet kanepe kasin, ngan ole kakamatau mulu.” ");
INSERT INTO apr_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Ngan tina Yesu iwete nen a di galiunu tilongo nga, le nga di tapdi tipartortor. Tiyei ne, “Ai, betanga yo iweta paidi i, in punu balai? Iyei ne, ‘Ole tanepe le mooloo tiap, ngan ole kakamatau mulu tiap. Lo ngan bet kanepe kasin, ngan ole kakamatau mulu.’ Inbe iwete mulu nen, ‘Ngan nen, yesoo nga bet alo pang ye Tamak.’ Ngan yo iwete nen nga, ngan betanga ki in punu balai?” ");
INSERT INTO apr_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Le nga di galiunu tina ngan tipartortor mulu nen, “Ai, betanga yo iwete bet ole tanepe le mooloo tiap i, in punu balai? Idi nga lod sarrara ye soo so yo iwetewete ye i.” ");
INSERT INTO apr_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Yesu di galiunu tina ngan di tapdi tiwetewete nen nga, ngan ikamata di le lon galanga ben ole titoru ye betanga tina. Le nga iwete pang di nen, “Ang ngan kator panin di diemu ye betanga yo awete pang nen, ‘Ole tanepe le mooloo tiap, ngan o ke bet kakamatau mulu tiap. Lo ngan bet kanepe kasin, ngan ole kakamatau mulu.’ ");
INSERT INTO apr_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Awete pang moolmool nen, ang nga ole lomu madoko, inbe katang, bong di tooltool ke tana i nga, ngan ole lodi ponana. Moolmool, ang nga ole lomu madoko, bong lo madoko kiang tani in ole palbe leu be iportak le iyei ben lo ponana. ");
INSERT INTO apr_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Le dawa ben garup yo lal ki ke pasuiungu ngan kapon massingi ye kase a bet ipasuiu i. Bong ye kene yo bet ipasuiu kase tani in koot nga, ngan ole lon kalli masngana, inbe lon ponana, yesoo ipasuiu kase tani in a isi tana oo. ");
INSERT INTO apr_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Ngan gaongo leu ye ang nga lapau. Dookoot nga lal kiang bet ole lomu madoko, bong ye kene yo bet akamatang mulu ye in nga, ngan ole lomu ponana. Ngan lo ponana kiang tani in tool sa o ke bet ilelang ye, ngan tiap. ");
INSERT INTO apr_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Ye kene tani in nga, ngan ang nga o ke bet museremu bet katorau ye so sa, ngan tiap. Le awete pang moolmool nen, kumata le bet kapatarau pang Tamak, inbe katoru ye soo so ye au ek nga, ngan ole ikauu pang. ");
INSERT INTO apr_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Mukot a ise nga, ngan katoru ye so sa ye au ek, ngan pitiap. Le kator ngan ole kakap so, a nen ngan ole lomu ponana le lomu ponana kaiye.” ");
INSERT INTO apr_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Yesu iwete nen a imot, motong la iyei ne, “Betanga yo awete pang nga, ngan akatte betanga ye leu. Bong pang dama ni bet tagoro lal yo bet pombe in nga, ngan ole awete pang nen mulu tiap, bong ole awete betanga mallangana pang ye Tamak. ");
INSERT INTO apr_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Ye kene tani in nga, ngan au i ole akaua koomu, inbe apatarau pang Tamak a atoru bet ilonang, ngan tiap, bong ang tapmu ole kapatarau panga ye au ek. ");
INSERT INTO apr_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Ngan Tamak ye taunu in lono pang mai san, yesoo ang ngan lomu pau mai san le katara lomu medana pau bet au i aye Maro amnepe, motong la asi nga. ");
INSERT INTO apr_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Moolmool, au i apa ye Tamak la le asi tana i nga, le dookoot nga ole agege tana i, inbe amulu a alo pang ye Tamak.” ");
INSERT INTO apr_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Yesu iwete nen, motong la di galiunu tiyei ne, “Dookoot nga la kotte betanga tiap, bong kuwete betanga mallangana pam nga. ");
INSERT INTO apr_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Le dookoot nga am nga lomam galanga nen, ong in lom galanga ye so nga le imot. Le ke bet kunama tool sa bet itorong ye torungu ki mugu, lo ngan bet kuraua torungu ki, ngan tiap. Ngan amkamata dada kiong yo nen i, le am nga amtara lomam medana nen, bet ong in kuye Maro kanepe, motong la kusi nga.” ");
INSERT INTO apr_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Tiwete nen, motong la Yesu iyei ne, “Dookoot nga la o katara lomu medana nga, too? ");
INSERT INTO apr_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Bong kapalongo, lal tani yo awete pang ye bet pombe i, in dookoot nga pombe oo. Le mooloo tiap ngan ole kamayiriyiri a ang atu atu kakoo pang ye malala kiang. Inbe ole kawulai yau le autaleu la bet si anepe i. Bong autaleu tiap, yesoo Tamak la bet inepe yau i. ");
INSERT INTO apr_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Ngan au i awete betanga yo nga pang, a bet nen ngan kaman yau man kanepe ye lo silene yo kiau i. Ye kene yo bet kanepe ye tana i nga, ngan ole urata moonoo dook tiap la bet pompombe pang yang nga. Bong kakodo le kamede, yesoo gurana yo ke tana i, in allosi oo.” ");
INSERT INTO apr_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Yesu iwete nen a imot, motong la itada pang ete, inbe ipatarau nen, “Tamak, lal tani in pombe oo. Le kuyeie Natum ene le ilo ete ke bet di tooltool tipayiti ye, a bet nen ngan Natum iyeie em le ilo ete nen lapau. ");
INSERT INTO apr_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Ngan ye i, kouo gurana mai panga bet iyei mai pang di tooltool nga le imot, a bet nen ngan ikaua nepongo dook mata yo taukan motingi i, in pang di tooltool yo kop di panga nga. ");
INSERT INTO apr_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Ngan dada yo bet di tooltool titoo ngan ole tikaua nepongo dook mata yo taukan motingi i, in nen. Di ngan ole lodi galanga yong ben ongtaleu in la Maro moolmool i, inbe lodi galanga lapau ye Yesu Kirisi yo kuwanga a isi i. ");
INSERT INTO apr_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Ngan urata yo kop pau bet ayei nga, ngan ayei porai a imot oo. Le ye dada yo ayei nen nga, ngan la le ayeie em le ilo ete ke bet di tooltool ke tana i tipayitong ye nga. ");
INSERT INTO apr_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Le dookoot nga Tamak, kuyeie ek le ilo ete ke bet di tooltool tipayiti, dawa ben yo mugu ngan tana i pombe tiao inbe ayong tanepe ngan kuyei ek le ilo ete nen nga.” ");
INSERT INTO apr_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Motong la Yesu ipatarau mulu nen, “Au i apaposong pang di tooltool ke tana i yo kop di pau nga, ngan oo. Di ngan di tooltool kiong, motong la kop di pau nga. Inbe di ngan titoo betanga yo kiong ngan dook mata. ");
INSERT INTO apr_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Le dookoot nga lodi galanga nen, so le imot yo kop pau nga, ngan ipa yong. ");
INSERT INTO apr_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Inbe betanga le imot yo kuwete pau ye nga, ngan awetekes pang di a tilongo oo. Le dookoot nga lodi galanga nen, au i apa yong la asi nga, le titara lodi medana bet ong la kuwangau a asi i. ");
INSERT INTO apr_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“Ngan nen le au i apatarau bet alon di. Bong apatarau nga bet alon di tooltool yo ke tana i, nga tiap. Au i apatarau nga bet alon di tooltool yo kop di pau nga, yesoo di ngan di tooltool kiong. ");
INSERT INTO apr_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Le di tooltool le imot yo kiau nga, ngan kiong, inbe di tooltool le imot yo kiong nga, ngan kiau. Di ngan la tiyeie ek le ilo ete ke bet di tooltool tipayitau ye nga. ");
INSERT INTO apr_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Ngan au i o ke bet anepe le mos mata ye tana i tiap, dookoot nga bet asila pang yong. Bong di nga ole si tinepe nanga la tana pono nga. Tamak, ongtaleu in la em mison i, le matam kala di dook ye gurana kiong yo dookoot ngan kusuketi pau koot i, a bet nen ngan tigaua le atu, dawa ben yo aru tagaua le atu nga. ");
INSERT INTO apr_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Ye kene yo aye di amnepe ye in nga, ngan matak kala di ye gurana kiong yo kusuketi pau i, le tinepe dook mata. Ngan nen le di atu sa ilene tiap, bong atu kidi yo ilene le ipa so i, in ilene a bet nen ngan iyeie betanga yo iken ye Rau kiong in le itar kanono moolmool. ");
INSERT INTO apr_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","“Dookoot nga bet agege di a asila pang yong, bong ye kene yo bet aye di amnepe ye tana i go nga, ngan lok bet awete pang di ye betanga yo nga, a bet nen ngan ayei di le lodi ponana dawa ben au i. Le moolmool, lo ponana kidi tani in ole mai le mai san. ");
INSERT INTO apr_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Betanga yo kiong nga, ngan awete pang di oo. Ngan la le di tooltool ke tana i tikap malmal pang di ye nga, yesoo di ngan ke tana i mulu tiap, ben au tauk i, au i ke tana i tiap lapau. ");
INSERT INTO apr_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Le apatarau pong nga bet kop di a tikoo ye tana i, nga tiap, bong bet matam kala di dook ye tool dook tiap Satan, ole nen ngan igarung di. ");
INSERT INTO apr_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Di ngan di tooltool ke tana i mulu tiap, dawa ben au tauk i, au i ke tana i tiap lapau. ");
INSERT INTO apr_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Ngan betanga kiong ngan moolmool le imot, le lok bet betanga kiong tina ngan iyei di le tirai lodi le imot pong bet tinepe yong dawa ben di tooltool kiong yo kupootoo di pong ong taum nga. ");
INSERT INTO apr_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Ong in la kuwangau a le asi tana i. Ngan nanga, dookoot nga ole awanga di tooltool tina yo kop di pau nga, ngan a tila ye di tooltool kapala yo tinepe ye tana i nga. ");
INSERT INTO apr_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Ngan au i araia lok le imot pong bet anepe yong dawa ben tool kiong yo kupootoo pong ong taum i, a bet nen ngan alon di ngan ole di lapau tirai lodi le imot moolmool pong bet tinepe yong dawa ben di tooltool kiong yo kupootoo pong ong taum, ngan lapau.” ");
INSERT INTO apr_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Motong la Yesu ipatarau mulu nen, “Pataraungu kiau i, in bet alon di galiuk leu ye tiap, bong apatarau nga bet alon di tooltool yo tilongo betanga kidi galiuk yo tiwete nga, ngan le titara lodi medana pau, ngan lapau. ");
INSERT INTO apr_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Le Tamak lok bet kugaua di tooltool tina le imot, le tinepe ye budanga atu, dawa ben yo ong in kunepe yau, inbe au i anepe yong nga. Inbe di le imot tinepe yidi aru lapau, a bet nen ngan di tooltool yo ke tana i nga, ngan ole titara lodi medana nen, ong in la kuwangau a le asi i. ");
INSERT INTO apr_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Ngan dada yo kuyeie ek le ilo ete ke bet di tooltool tipayitau ye i, in dookoot nga ayeii pang di lapau, a bet nen ngan tigaua le atu, dawa ben yo aru tagaua le atu nga. ");
INSERT INTO apr_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Ngan au i anepe ye di, inbe ong in kunepe yau. Le ye dada yo i, au i lok bet nen a tigaua lodi le atu moolmool, a bet nen ngan di tooltool ke tana nga lodi galanga nen, ong in la kuwangau a le asi i, inbe ong in lom pang di mai san dawa ben yo lom pau mai san nga. ");
INSERT INTO apr_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Tamak, au i lok bet di tooltool le imot yo kop di pau nga, ngan tise yau se aye di amnepe ye malala yo bet anepe ye i, a bet nen ngan tikamatau yo kuyeie ek le ilo ete ke bet di tooltool tipayiti nga. Ngan mukot ye kene yo kutar lang le tana tiao nga, ngan lom pau mai san le kuyeie ek le ilo ete nen. ");
INSERT INTO apr_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","“Tamak, ong in tool noonoonoo. Di tooltool ke tana nga, ngan lodi galanga yong tiap. Bong au i lok galanga yong, inbe di galiuk nga lodi galanga nen, ong la kuwangau a le asi i. ");
INSERT INTO apr_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Le au i la apaposong pang di a le lodi galanga yong i, le ole ayei nen pang di le ikenen leu. Ole ayei nen a bet nen ngan lodi pang di tooltool mai san dawa ben yo ong in lom pau mai san nga. Inbe ole ayei nen a bet nen ngan au tauk i lapau, anepe ye di.” ");
INSERT INTO apr_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Ye kene tani in Yesu ipatarau nen a imot, motong la iye di galiunu tipa le tikessautu ran yo ene Kitron i. Ngan ran tani ke koonoo kapala in kumu atu yo tipe kai olip ye i, le nga Yesu iye di galiunu tina ngan tipa so le tilo kumu tani in lono. ");
INSERT INTO apr_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Ngan Yuta, tool tani yo bet itara Yesu la di koi ki bedi i, in lon galanga ye kumu tani, yesoo kene kapala, ngan Yesu iye di galiunu lo tigaua nango. ");
INSERT INTO apr_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Le nga Yuta irara di tooltool ke patokongo budanga atu ke Rom tiye di gaunu yo di tooltool maimai ke paroranga so le di Paresi tiwanga di nga, ngan a tila pang ye kumu ke olip tani. Di ngan tila ngan kapala tilanga sul a titoko, inbe di kapala ngan tikap so yo tikarata le ilolo dawa ben sul nga, inbe kapala ngan tikap dawa ke patokongo. ");
INSERT INTO apr_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Ngan Yesu in lon galanga ye so le imot yo bet pombe panga, ngan oo. Le nga ipa le ila potai ye di, motong la itor di nen, “Ai, ang nga kasere sei?” ");
INSERT INTO apr_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Motong la tiraua betanga ki nen, “Am nga amsere Yesu ke Nasaret.” Le nga Yesu iwete pang di nen, “I au tani naii.” Ngan Yuta, tool tani yo bet itara Yesu la di koi ki bedi i, in iye di tooltool tina ngan tikodede. ");
INSERT INTO apr_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Ye kene tani in yeiso bet Yesu iyei ne, “I au tani naii,” ngan le tidikmai pang mur inbe timolol du tana. ");
INSERT INTO apr_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Motong la Yesu itor di mulu nen, “Ang nga kasere sei?” Ngan se tiyei ne, “Yesu ke Nasaret.” ");
INSERT INTO apr_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Le nga Yesu iwete pang di nen, “Awete pang mugu oo, i au tani naii. Le au i la kaman bet man kaserau i, a kakau au, inbe kayei di tooltool kiau nga be, a tila.” ");
INSERT INTO apr_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Yesu iyei nen, ngan le iyei betanga tina yo iwete mugu nga le itar kanono moolmool. Ngan betanga tina ngan iwete nen, “Au i matak kala di tooltool yo kop di pau nga, ngan nen le di atu sa ilene tiap.” ");
INSERT INTO apr_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Ngan Simon Pita, in pul ki atu ke patokongo lapau. Le nga iposi tina le itarakede kapraingi ke tool kuto mai ke paroranga so pang Maro, in talngana oonoo, le imakede. (Ngan kapraingi tani in ene la Malkas i.) ");
INSERT INTO apr_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Motong la Yesu iwete pang Pita nen, “Ai, kupariri pul kiong in a ilo ye nene mulu! Nga gelei, lom bet ayin ye ruku ke masngana yo bet Tamak ikauu pau i, in tiap, too?” ");
INSERT INTO apr_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Motong la di tooltool ke patokongo tina ngan tiye kuto mai kidi yo matan kala di i, inbe di gaunu yo tikodokala bareme mai ke sungunu nga, ngan tiparama Yesu a tipauu ye ooroo medana. ");
INSERT INTO apr_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Motong la tikauu a tila pang ye Anas yo Kepas roonoo i, in mugu. Ngan Kepas tani, in iyei tool kuto mai ke paroranga so pang Maro ye rai tani in. ");
INSERT INTO apr_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Inbe ye in la mugu ngan iwete pang di Yuda nen, “Dada dook mata in nen: Kumata bet tool atu ikol di tooltool kiidi a imata nga, ngan ole di tooltool kiidi le imot nga sa tilledi tiap.” ");
INSERT INTO apr_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Ye kene tani yo tikaua Yesu a tila pang ye Anas nga, ngan le Simon Pita iye Yesu galiunu san, in yeru titoo lapau a tila. Ngan tina tool kuto mai ke paroranga so pang Maro, in lon galanga ye Yesu galiunu san tani, ngan la le timalum panga bet itoo Yesu a ilo pang koongoo lono nga. ");
INSERT INTO apr_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Bong Pita in inepe ke diki potai pang ye dada, inbe inam. Le nga Yesu galiunu tani yo tool kuto mai ke paroranga so pang Maro, in lon galanga ye i, in imulu du iwete pang garup yo matan kala dada i, motong la ikaua Pita a yeru tilo pang koongoo lono. ");
INSERT INTO apr_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Tilo, motong la garup tani yo matan kala dada i, in itoro Pita nen, “Ong i o tool tani ni galiunu atu, too?” Bong ngan Pita ipataukala a iyei ne, “Tiap! Au i tiap.” ");
INSERT INTO apr_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Ngan ni sil dook tiap, le nga di kapraingi ke tool kuto mai ke paroranga so pang Maro, ngan tiye di gaunu tikodo le tiwakaia ei yo tipata i, inbe iloo di. Le nga Pita lapau ila iye di tikodo, inbe ei tani in iloo. ");
INSERT INTO apr_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Ye kene tani in tool kuto mai ke paroranga so pang Maro, in itor panini Yesu ye di galiunu, inbe ye betanga yo ipatomonai di tooltool ye nga. ");
INSERT INTO apr_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Motong la Yesu iwete panga nen, “Au i betanga yo awete pang di tooltool nga, ngan atarkoolek inbe awete sa sollono, ngan tiap, bong awete mallangana le imot. Le kanakana ngan apatomonai di tooltool ye ni nangai yo di Yuda timan tigaua ye i. Le apatomonai di ye rumu kidi Yuda ke gaongo, inbe ye bareme mai ke sungunu. ");
INSERT INTO apr_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","E nga gelei bet kutorau nen nga? Bet nen ngan kutor di tooltool la tilongo betanga kiau nga. Di ngan ole lodi galanga ye betanga yo awete nga.” ");
INSERT INTO apr_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Ye kene tani yo Yesu iwete nen ye in nga, ngan le gaunu atu yo ikododo potai ye i, in ipodo damono, inbe iyei ne, “Ai, kuwete bet in dada dook mata la kuraua betanga ke tool kuto mai ke paroranga so pang Maro ye i, too?” ");
INSERT INTO apr_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Motong la Yesu iwete panga nen, “Kumata bet awete betanga sa dook tiap nga, ngan kupaposi la mallangana. Bong bet awete betanga dook mata nga, ngan nga gelei a le kurau sorok au nga?” ");
INSERT INTO apr_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Motong la Anas iwete le ooroo tina yo tipaua Yesu ye i, in iken ye nen, inbe tikauu a tila pang ye Kepas yo iyei tool kuto mai san ke paroranga so pang Maro i. ");
INSERT INTO apr_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Ngan Simon Pita tani in ikododo a ei iloo. Le nga di tooltool tina yo tiye tikododo nga, ngan titoru mulu. Tiyei ne, “Ong i o tool tani ni galiunu atu, too?” Bong ngan Pita ipataukala a iyei ne, “Tiap! Au i tiap.” ");
INSERT INTO apr_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Motong la kapraingi atu ke tool kuto mai ke paroranga so pang Maro, in rara ke tool tani yo Pita itarakede talngana i, in iyei ne, “Ai, ong i ben akamatong kuye Yesu kanepe nango la kumu lono ke olip ngo, kuwete?” ");
INSERT INTO apr_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Bong ngan Pita ipataukala mulu. Tina yo ngan ye kene tani in palbe leu inbe tareke itang. ");
INSERT INTO apr_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Motong la di Yuda tikaua Yesu a tigege rumu ke Kepas, inbe tikauu a tila pang ye rumu ke tool kuto mai kidi Rom yo matan kala tana mai Yudia i. Ngan ye kene tani in muntu yege, ngan di Yuda tina lodi kaua urata nen bet di tapdi nga o tilo rumu lono ke tool kuto mai kidi Rom, in tiap. Yesoo, ye wer kidi in igunkala di ke bet tilo ye rumu ke di tooltool rara san tiap. Di Yuda tina ngan tiyei bet nen ngan ole di tapdi tigarung di ye Maro matana ngan o ke bet tikan asara ke lal yo bet lodi tut ye Paskimoolooningi Ke Maro, in tiap. ");
INSERT INTO apr_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Le nga tinam a tinepe ke diki, inbe Pailot isi pang ye di si itor di nen, “Ang nga kakaua tool in se kapatokode a ikodo matak ye soo so?” ");
INSERT INTO apr_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Pailot itor nen, motong la tiyei ne, “Kumata tool i bet tool ke geingi dada dook tiap kidi talnga dikidiki tiap nga, ngan matin nga le amkauu a amman pang yong tiap.” ");
INSERT INTO apr_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Le nga Pailot iyei ne, “Bet nen ngan kakauu a kala, lo ngan bet la kakarata betanga ki ye wer yo kiang ang tapmu nga.” Bong ngan di Yuda tina ngan tiyei ne, “Am nga, timalum pam ye raumatenge di tooltool tiap.” ");
INSERT INTO apr_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Ngan so yo nen ngan bet pombe, a bet nen ngan iyei betanga tina yo mugu ngan Yesu iwete ye dada yo bet imata ye i, in le kanono pombe moolmool. ");
INSERT INTO apr_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Le nga Pailot imulu a ilo pang rumu lono, motong la ikiui Yesu a ilo le lo itoru nen. Iyei ne, “Oo kuwete, ong i la tool kuto mai yo matam kala di Yuda le imot i, too?” ");
INSERT INTO apr_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Pailot itor nen, motong la Yesu iraua betanga ki. Iyei ne, “Ngan in torungu kiong ong taum, too tool sa la iwete pong yau la le kutor nen nga?” ");
INSERT INTO apr_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Le nga Pailot iwete panga nen, “Nga gelei, kuwete bet au i di Yuda atu, too? Ngan di tooltool kiong ong taum, tiye di tooltool maimai ke paroranga so pang Maro la tikau ong a kuse pang yau nga. Ngan ong i kuyeie soo so?” ");
INSERT INTO apr_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Motong la Yesu iraua betanga ki nen, “Dada kiau yo bet matak kala di tooltool ye i, in dawa ben dada ke di tooltool yo ke tana i, nga tiap. Ngan yo bet atoo dada ben kidi tooltool ke tana i nga, ngan matin nga le di kapraingi kiau timadit a tirau di kuto maimai kidi Yuda yo timan bet man tikau au a tiparamau nga. Bong dada yo ayei tool kuto mai a matak kala di tooltool kiau ye i, in dawa ben di tooltool kuto maimai yo ke tana i, nga 