﻿USE sofia;
DROP TABLE IF EXISTS sofia.apnNT_vpl;
CREATE TABLE apnNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES apnNT_vpl WRITE;
INSERT INTO apnNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Amnepêm Jejus Kris kormã pika hwỳr wrỳk kêt ri hkukamã higêtjê nhĩxi na jajaja. Wỳj ri higêtjê hõ nhĩxi na pre kêp Tawi. Nẽ Tawi xwỳj ri higêt nhĩxi pê na pre Apraãw. ");
INSERT INTO apnNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Nẽ Apraãw kra na pre kêp Ijak. Nẽ Ijak kra na pre kêp Jako. Nẽ Jako hkra na pre kêp Juta mẽ htõjaja. ");
INSERT INTO apnNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Nẽ Juta hkra na pre wa kêp Pere nẽ Jera. Nẽ Pere mẽ Jera wa katorxà na pre kêp Tama. Nẽ Pere hkra na pre kêp Erõ. Nẽ Erõ hkra na pre kêp Ari. ");
INSERT INTO apnNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Nẽ Ari hkra na pre kêp Amĩnatap. Nẽ Amĩnatap kra na pre kêp Nasõ. Nẽ Nasõ hkra na pre kêp Samõ. ");
INSERT INTO apnNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Nẽ Samõ hkra na pre kêp Poas. Nẽ Poas katorxà na pre kêp Raap. Nẽ Poas kra na pre kêp Opex. Nẽ Opex katorxà na pre kêp Rutre. Nẽ Opex kra na pre kêp Jese. ");
INSERT INTO apnNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Nẽ Jese hkra na pre kêp Pahihti Tawija. Nẽ Tawi hkra na pre kêp Sarumãw. Sarumãw katorxàja Uristi hprõ na pre. Tã nhũm pre Uristi ty nhũm Tawija hãmri mỳrpê Uristi hprõ ho hprõ nẽ kamã hkra. Nhũm wa hkraja kêp Sarumãw. ");
INSERT INTO apnNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Nẽ Sarumãw kra na pre kêp Ropã. Nẽ Ropã hkra na pre kêp Apiasti. Nẽ Apiasti kra na pre kêp Asti. ");
INSERT INTO apnNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Nẽ Asti hkra na pre kêp Josapa. Nẽ Josapa hkra na pre kêp Jorã. Nẽ Jorã hkra na pre kêp Ojis. ");
INSERT INTO apnNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Nẽ Ojis kra na pre kêp Jotã. Nẽ Jotã hkra na pre kêp Akaj. Nẽ Akaj kra na pre kêp Ejekis. ");
INSERT INTO apnNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Nẽ Ejekis kra na pre kêp Manase. Nẽ Manase hkra na pre kêp Amõ. Nẽ Amõ hkra na pre kêp Josis. ");
INSERT INTO apnNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","12","Nẽ Josis kra na pre kêp Jekonĩs mẽ htõjaja. Kormã mẽ htĩr ri na pre Papirõn nhõ xwỳnhjaja kot mẽ hkurê kaxàr kaxyw mẽ hwỳr hprõt nẽ mẽ unê. Ijaew piitã unênh pa nẽ ma akupỹm mẽ õ pyka hwỳr mẽ ho hapêx nhũm mẽ hpãnhã Papirõn kamã pa ho pa. Jakamã nhũm Josis mẽ hkra Jekonĩs mẽ htõjaja mẽ hipêêxà pyrà nẽ Papirõn kamã pa ho pa. Nẽ Jekonĩs kra na pre kêp Saraxi. Nẽ Saraxi hkra na pre kêp Joropape. ");
INSERT INTO apnNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Nẽ Joropape hkra na pre kêp Apiux. Nẽ Apiux kra na pre kêp Eriakĩ. Nẽ Eriakĩ hkra na pre kêp Ajo. ");
INSERT INTO apnNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Nẽ Ajo hkra na pre kêp Satok. Nẽ Satok kra na pre kêp Akĩ. Nẽ Akĩ hkra na pre kêp Eriux. ");
INSERT INTO apnNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Nẽ Eriux kra na pre kêp Eresa. Nẽ Eresa hkra na pre kêp Matã. Nẽ Matã hkra na pre kêp Jako. ");
INSERT INTO apnNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Nẽ Jako hkra na pre kêp Juje. Nẽ Juje hprõ na pre kêp Marir. Nẽ Marir Kra na pre kêp Jejus. Mẽ kot kãm: “Tĩrtũm kot mẽ pakaxyw ãm xwỳnh” anhỹr xwỳnhta na pre. ");
INSERT INTO apnNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Nhũm Apraãw kanrẽhã axte axpẽn kanrẽhã mẽ àptàr nywjaja Tawija wỳr kêp 14. Nẽ Tawi nhĩrô pê Papirõn hwỳr mẽ hapêx kêt ri axpẽn kanrẽhã mẽ àptàr nywjaja mããnẽn kêp 14. Nẽ ra Papirõn kamã mẽ pa nhĩrô pê axpẽn kanrẽhã Jejus pê Tĩrtũm kot mẽ pakaxyw ãm xwỳnhta wỳr mããnẽn kêp 14. Ã na pre Jejus Kris xwỳj ri higêtjê nhĩxi anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Tã ã mẽ hixi jarẽnh kot anhỹr kanrẽhã na pre ã Jejus Kris kator anẽ. Nhũm pre kormã Jujeja Marir o hprõ kaxyw. Nom kormã ho hprõ hkêt ri nhũm htujarô. Kormã hkukrit tã nhũm Tĩrtũm Karõ tanhmã ho nhũm htujarô. ");
INSERT INTO apnNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Hãmri nhũm Jujeja harẽnh ma nẽ tee ri hamaxpẽr nẽ htỳx nhãm mẽhõ kot kêp htu hã hkamnhĩx. Juje kot tãm amnhĩ nhĩpêx nẽ tãm hamaxpẽr jakamã tee ri kot ho hprõ hkukamã hamaxpẽr. Nẽ hamaxpẽr o: —Nà pa mãn ixte hture hã. Nhãm mẽhõ ra kot ã hipêx anhỹr kênã. Nà kot paj ho ixprõ hkêt nẽ. Nom kot paj ixkwỳjê mã ã kot amnhĩ nhĩpêx anhỹr o amnhĩrĩt kêt nẽ. Kot paj anẽ nhũm mẽ kuma nẽ ho kapẽr punuj nhũm amnhĩ kamã hpijaàm tỳx nẽ. Ja pymaj kot paj ixkatàt kôt hkaga kurê kumrẽx. Nom ixkwỳjê hkàx ã hkaga. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Nẽ ã hamaxpẽr anhỹrja o ra gõr nẽ nõ. Nhũm Tĩrtũm kapẽr o mẽ wrỳk xwỳnhjê hõ hwỳr wrỳ nẽ hwỳr axàn kuri xa. Hãmri nẽ kãm: —Pa Juje? E ot pa awỳr tẽ. Kwa tee ri Marir o aprõ hkukamã ajamaxpẽr punuj kêt nẽ. Mãmrĩ ho aprõ. Mẽhõ kot apê tanhmã ho hkêt. Tĩrtũm Karõ na pre ã hipêx anẽ. Jakamã kwa tee ri ajamaxpẽr kêt nẽ mãmrĩ ho aprõ nẽ war apa. ");
INSERT INTO apnNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Koja hkrare kato nẽ myre nẽ hprêk. Hãmri nẽ mẽ kot hkôt amnhĩ xunhwỳr xwỳnhjaja mẽ kot amnhĩ tomnuj piitã pê mẽ utàr pa. Jakamã koja kato ka wa hã hixi mẽ nhũm kêp Jejus. Anẽ. Nhũm pre ã Tĩrtũm kapẽr o mẽ wrỳk xwỳnhja kãm kapẽr anẽ. Ijaew kapẽr kãm Jejus jarẽnhja te kêp “Tĩrtũm kêp mẽ papytàr xwỳnh” anhỹr pyràk. Jakamã nhũm Tĩrtũm kapẽr o mẽ wrỳk xwỳnhja Juje õt kãm ã kãm Marir jarẽnh anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","23","Nom kormã ã kãm kapẽr anhỹr xwỳj ri na pre ra Tĩrtũm nhỹ hã kapẽr xwỳnhjê hõja kukamã tanhmã harẽnh to nẽ hã kagà. Nẽ hã kagà ho: E mẽ inhma nẽ inhmar tỳx nẽ ho apa. Koja nhỹrmã pyka já kamã mẽhõ kormã hkukrit tã htujarô. Nẽ hkra kato nẽ myre. Nhũm mẽ omu nẽ hã hixi mẽ nhũm kêp Emanuew. Anẽ. Ijaew kapẽr kãm “Emanuew” jarẽnhja te kêp “Ota ra Tĩrtũm mẽ pahkôt pa ho pa” anhỹr jarẽnhta pyràk. Jakamã nhũm pre Tĩrtũm nhỹ hã kapẽr xwỳnhja Jejus kukamã ã harẽnh anẽ nẽ hã kagà. ");
INSERT INTO apnNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Jakamã nhũm Tĩrtũm kapẽr o mẽ wrỳk xwỳnhja Juje mã kapẽr par mẽ nhũm hkrãkato. Hãmri nẽ kot kãm ujarẽnh xá hkôt Marir o hprõ. ");
INSERT INTO apnNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Nom kormã tanhmã ho hkêt nẽ ri o pa rãhã nhũm hkrareja kato. Hãmri nhũm wa hã hixi mẽ nhũm kêp Jejus nẽ mããnẽn kêp Emanuew. ");
INSERT INTO apnNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Nhũm pre Jejus Perẽj kamã kato. Pika pê Jutej kamã. Pahi Erox kormã kot Jutej nhõ xwỳnhjê ho amnhĩptàr o pa ri nhũm õ pika kamã kato. Hãmri nhũm Tĩrtũmja kaxkwa kamã Kra kator jarẽnh xà hã kanhêti raxta õ nhô nhũm pika hõ kamã kanhêti ho studa xwỳnhjaja omu. Kanhêtija pumu nẽ hkĩnh nẽ axpẽn mã: —Kwa ga mẽ kanhêti raxti mũj pumu. Mãn ra Ijaew nhõ pahi nywta kato nhũm kanhêti mũj kêp ho amnhĩrĩt xà hã ajêt. Kwa pu mẽ ma hapêr o mõ nẽ nhỹri tokyx omu nà. Anẽ hãmri nẽ amnhĩ to pikuprõnh pa nẽ ma hapêr o pa. Ma myt gjêx xà hwỳr hapêr o pa hã apkati xohtô nẽ. Hãmri nẽ ra Ijaew nhõ pika hwỳr pôj nẽ krĩ pê Jerujarẽ hwỳr hapêr o mõ. Pahi Erox nhõ krĩja wỳr nhũm mẽ hapêr o mõ hãmri nẽ kamã pôj nẽ mẽ hkrare nywta ã krĩ nhõ xwỳnhjê kukjêr o mõ ");
INSERT INTO apnNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","nẽ mẽ kãm: —Pa? Ot pa mẽ apê Ijaew nhõ pahi nywreta pumunh kaxyw mõ. Ham kator xwỳnhta. Mẽ inhõ pika kamã na pa prem kaxkwa hkrax rũm kot ho amnhĩrĩt xà hã kanhêti raxta pumu. Hãmri nẽ nhỹri pahi nywre pumunh nẽ kutã mẽ ixkõn krã ho ixtẽm nẽ ixkrĩ nẽ kãm mex o mex ã harẽnh kaxyw nẽtãnh mẽ inhõ krĩ rũm hapêr o mõ. Kwa mẽ inhmã harẽ. Nhỹri na? Na pa mẽ inhmã omunh prãm tỳx kumrẽx. Anhỹr o hã mẽ hkukjêr o mõr jakamã nhũm mẽ piitã pahi nywja jarẽnh ma nẽ axpẽn mã harẽnh o hprõt. ");
INSERT INTO apnNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Nhũm pahi Eroxja harẽnh ma nẽ tee ri amnhĩ kukamã hamaxpẽr. Pahi nyw kot mẽ ho amnhĩptàr ã hkamnhĩx nhũm já kêp omnuj tỳx nẽ. Nhũm krĩ nhõ xwỳnhjaja ã hamaxpẽr anhỹr ã omu nẽ tee ri amnhĩ kukamã hamaxpẽr o ra kãm ma nẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Hãmri nhũm pahi Eroxja amnhĩ wỳr hkwỳjê hã karõ. Mẽ õ patre krãhtũmjaja nẽ Tĩrtũm kapẽr tũm o mẽ ahkre ho mẽ pa xwỳnhjaja nhũm amnhĩ wỳr mẽ hã karõ nẽ Tĩrtũm kot nhỹrmã mẽ hwỳr mẽnh mã xwỳnhta ã mẽ hkukjêr kaxyw. Nẽ mẽ kãm: —E Tĩrtũm kot nhỹrmã mẽ pahwỳr mẽnh mã xwỳnhta ã na pa mẽ akukjêr kaxyw mẽ ato akuprõ. Kwa mẽ atõ inhmã harẽ. Koja nhỹrmã kator kaxyw nẽ nhỹri koja we kato? Xà jar mẽ panhõ krĩ kamã nà? Xà nhỹri krĩ hõ kamã? Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Hãmri nhũm mẽ kuma nẽ kãm: —Nà mẽ panhõ pika pê Jutej kamã koja xep kato. Krĩ pê Perẽj kamãã. Na pre Tĩrtũm nhỹ hã kapẽr o mẽ pa xwỳnhja ra hkukamã mẽ panhĩgêtjê mã tanhmã harẽnh to nẽ hã kagà. Nẽ hã kagà ho: ");
INSERT INTO apnNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Pa Perẽj nhõ xwỳnhjaja? E mẽ anhõ krĩ grire htã kamã koja nhỹrmã mẽ panhõ Pahi Maatija kato. Koja mẽ pahpê Ijaewjê piitã mẽ pahto amnhĩptàr mex o pa. Jakamã mẽ anhõ krĩ grire htã koja Ijaew piitã axpẽn mã mex ã harẽnh o pa. Ã na pre Tĩrtũm kot mẽ pahwỳr mẽnh mã xwỳnhta kukamã mẽ kãm harẽ nẽ hã kagà anẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Hãmri nhũm pahi Erox tee ri ã harẽnh anhỹrja ma hãmri nẽ amnhĩ wỳr mẽ kot hã àhkukjêr o mõr xwỳnhjê hã karõ. Nom nhỹri Ijaew kàx ã. Hãmri nhũm mẽ ma hwỳr mra nẽ agjê nhũm mẽ omu nẽ pahi nywta ã mẽ hkukja nẽ mẽ kãm: —E mẽ aprĩ hã inhmã pahi kator nywta jarẽ. Tanhmã na pre ra mẽ ate kanhêti pumunh ã mytwrỳ kute? Xà ham na ka prem omu nà amnepê mã? E mẽ aprĩ hã tanhmã inhmã harẽnh to. Anẽ. Hãmri nhũm mẽ ihõja kãm: —Nà na ra hã amgrà axkrut kaxyw. Na pa prem omu hãmri nẽ inhnojarêt nẽ man ixpa ho ixpa ry rax nẽ mẽ awỳr pôj. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Nhũm mẽ kuma nẽ mẽ kãm: —Tỳ. Nom jar amrakati. Perẽj kamã na xep kato. E mẽ mãmrĩ ma hwỳr mõ nẽ kamã hapêr. Hãmri nẽ nhỹri omu nẽ akupỹn ixwỳr mõ nẽ inhmã harẽ. Pa ijaxwỳja ma hwỳr mõ nẽ omu nẽ mẽ apyrà nẽ kãm mex o mex ã harẽ. Ijaxwỳja inhmã omunh prãm tỳx kumrẽx. Anẽ. Nom hêx rom ã ri mẽ kãm kapẽr anẽ. Kot nhỹri harẽnh mar nẽ hã àmnênh nhũm mẽ kot hpĩr kaxyw nhũm hêx rom ã kãm omunh prãm tỳx ã amnhĩ jarẽnh anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","10","Jakamã nhũm mẽ kuma hãmri nẽ kato nẽ ma Perẽj wỳr mõr kurê kumrẽx. Hãmri nẽ kormã mẽ õ pika kamã mẽ pa ri kanhêti ho studa xwỳnhta nhũm mẽ axte amnhĩ kukamã omu nẽ hkĩnh nẽ. Nhũm ma Perẽj wỳr mẽ hkukamã mõ nhũm mẽ omunh pê ma hkôt pa rãhã hwỳr pôj. Nhũm kanhêtija pahi nywre nhõrkwỹ mỳri ajêt. ");
INSERT INTO apnNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Jakamã nhũm mẽ ma hkôt mra nẽ ixkreja wỳr pôj nẽ kapem xa. Hãmri nẽ mẽ kãm kapẽr nẽ mẽ hwỳr agjê nẽ Jejus mẽ katorxàja wa omu. Hãmri nẽ Jejus kutã hkõn krã ho hkrĩ hpa nẽ kãm kapẽr nẽ kãm: —Pa Xugitre. Hêxta waa nẽ. Nà amex o amex. Kot kaj nhỹrmã axàptàr hãmri nẽ apê mẽ inhõ Pahi Maati. Nà ãm hãmri na pa mẽ apumu nẽ ixkĩnh nẽ. Anẽ. Hãmri nẽ ahpỹnhã kãm hkĩnh xà gõ. Kãm ôr kwỳ gõ nẽ kãm mẽhkuxwa xà hkwỳ gõ nẽ kãm te kot ràmre kuxware pyràk pê mĩraja nhũm mẽ kãm hkwỳ gõ. Mẽ hkĩnh xà hã kàxpore xohtô nhũm prem kãm õr pa. ");
INSERT INTO apnNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Hãmri nẽ ra akupỹm Jerujarẽ kamã pahi Erox wỳr nojarêt. Nhũm kamàt nhũm mẽ gõr nẽ hikwỹ hãmri nẽ ra amỹti. Nhũm Tĩrtũm mẽ hpimtir kãm mẽ kãm kapẽr nẽ mẽ kãm: —Pa? E mẽ inhma. Kêr ka mẽ akupỹm pahi Erox wỳr amrar nẽ kãm mẽ hkrata jarẽnh kêt nẽ. Ãm kwarĩ ho kwarĩ. Nẽ kêr ka mẽ pry hõ hã mãn ma mẽ anhõ pika hwỳr akupỹm apa ho apa. Anhỹr o mẽ kãm kapẽr jakamã nhũm apkati nhũm mẽ kànhmã hkrĩ hãmri nẽ Tĩrtũm kot mẽ kãm hã karõ xà hkôt ma akupỹm mẽ õ pika hwỳr pa kurê kumrẽx nẽ akupỹm pahi Erox wỳr mrar kêt nẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Tã nhũm kanhêti ho studa xwỳnhjaja ma akupỹm hapêx hãmri nhũm Tĩrtũm axte Marir mjên Juje hwỳr kapẽr o mẽ wrỳk xwỳnhjê hõ mẽ. Nhũm kê axte hpimtir kãm hwỳr wrỳ nẽ kãm kapẽr nẽ kãm: —Pa Juje. E kwa kànhmã nhỹ. Na ra pahi Eroxja aprõ pê hkrata ã amỹnê. Koja tokyx pôristi hkwỳjaja mẽ anhõ krĩ hwỳr pôj nẽ war apê hpĩr kaxyw ri hapêr. Jakamã kwa wa tokyx akato nẽ ma pika pê Ejit wỳr amõr kurê kumrẽx. Nẽ Ejit kamã apa rãhã pa nhỹrmã akupỹn amnẽ war amẽ. E kwa tokyx. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Hãmri nhũm kuma nẽ kànhmã nhỹ nẽ Marir mra nẽ war amnhĩ to akuprõ nẽ ra nojarêt. Hãmri nẽ krĩja pê Jejus o kato nẽ ma o mõr kurê kumrẽx. Wa mõr ryy nẽ hãmri nẽ Ejit wỳr pôj nẽ kamã pa ho pa. ");
INSERT INTO apnNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","20","Rôm nhũm pahi Erox tee ri amnhĩ wỳr kanhêti ho studa xwỳnhjê kamã hamak o pa nom nhũm mẽ akupỹm hwỳr mrar kêt nẽ. Jakamã nhũm mẽ kamã gryk nẽ hamaxpẽr o: —Tk. Kwa nà. Na mẽ ãm inhmã hêx nẽ akupỹn ixwỳr mrar nẽ nhỹri inhmã pahi nywta jarẽnh kêt nẽ. Nà kwãr mẽ mãmrĩ ã inhĩpêx anẽ. Mẽ kot ixpê ho hpimxuure kaxyw ã. Nà kot paj mẽ kêp kupĩ nhũm mẽ rĩ amnhĩ pumu. Na xep prem kanhêti kot harẽnh xàja pumunh ã ra hã amgrà pyxi nẽ hkôt mytwrỳ kêp 6. Jakamã mãn mẽ hkrata ra hã amgrà axkrut kaxyw. Nà na pa ra ijamaxpẽr. Kot paj Perẽj kamã mẽ hkra myjaja ra mẽ hã amgrà axkrut xwỳnhjaja nẽ kormã mẽ hã amgrà axkrut kêt xwỳnh piitã mẽ himex pa. Jao ra mẽ kamã pahi nywta pĩ. Nà ixte hpĩr mã kênã. Koja hprêk nẽ ixpãnhã Ijaew o amnhĩptàr kêt nẽ. Anhỹr o hamaxpẽr hãmri nẽ amnhĩ wỳr õ pôristi hkwỳjê hã karõ nẽ mẽ kãm mẽ hkrajê hã amỹnê nẽ mẽ kãm: —E kêr ka mẽ ma Perẽj wỳr mra nẽ kamã mẽ kêp mẽ hkra myrejaja ra mẽ hã amgrà axkrut xwỳnhjê nhĩmex pa. Nẽ kormã mẽ hã amgrà axkrut kêt xwỳnhjaja mããnẽn mẽ himex par kumrẽx. Nẽ Perẽj pu hã ri krĩ hkryre hkôt mããnẽn ri ajapôj nẽ ã mẽ himex par anẽ. Anẽ. Hãmri nhũm mẽ kuma nẽ ma mẽ hwỳr mrar kurê kumrẽx. Hãmri nẽ Perẽj wỳr pôj nẽ mẽ kêp mẽ hkra myre piitã mẽ himex pa. Jakamã nhũm mẽ katorxà nẽ mẽ hipêêxàjaja tee ri mẽ hkra htyk xwỳnhjê pumu nẽ hkaprĩ htỳx nẽ mỳr rũnh nẽ. Nom na pre Tĩrtũm nhỹ hã kapẽr jarẽnh o mẽ pa xwỳnh finat Jeremĩstija ra amnepêm ã mẽ kot amnhĩ nhĩpêx anhỹrja kukamã mẽ panhĩgêtjê mã mẽ harẽ nẽ hã kagà. Na pre mẽ kãm Ijaew kurê xwỳnhjê pynênh nẽ ma mẽ õ pika hwỳr mẽ ho hapêx par kaxyw. Hãmri nhũm mẽ panã Rrakewja te ra kot tee ri ja hã mẽ omunh nẽ tanhmã amnhĩ nhĩpêx to pyràk nhũm Jeremĩstija tanhmã Ijaewjê jarẽnh to nẽ hã kagà. Nẽ hã kagà ho: Amnepêm Perẽj kamã na pre mẽ panã Rrakewja hpijagri ho nõrja ã ra htyk kaxyw nẽ tee ri hkra kator mã xwỳnhta kukamã hamaxpẽr nẽ mỳr o nõ. Nhũm hkwỳjaja tee ri akupỹm tam hamaxpẽr kaxyw kãm kapẽr. Tã jarãhã Rrakew kanrẽhã hkra nẽ htàmnhwỳ nijaja ra uràk nẽ tee ri mẽ hkrare ho hamak xàj mỳr o pa. Mẽ kot mẽ kêp utàr nẽ mẽ himex par jakamã nhũm mẽ tee ri mẽ ho hamak xàj mỳr o pa. Anẽ. Nhũm pre finat Jeremĩsja mẽ hkukamã ã mẽ harẽ nẽ mẽ hã kagà anẽ. Tã ra jarãhã mẽni piitã Rrakew pyrà nẽ hkrajê o hamak xàj mỳr o pa. Tã nhũm mytwrỳ grêre nẽ hapêx nhũm pahi Erox ty. Jakamã nhũm kamàt nhũm Jujeja gõr nẽ nõ. Nẽ kê õt kãm axte amỹti. Nhũm Tĩrtũm kapẽr o mẽ wrỳk xwỳnhja axte hwỳr wrỳ nẽ kãm: —Pa Juje? E na ra Marir pê hkra pĩr mã xwỳnhta ty. Jakamã kwa wa mãmrĩ ma akupỹm mõ. Ma akupỹm mẽ apê Ijaewjê nhõ pika hwỳr axàmnhĩx aprõ mẽ hkrata wa o mõ. Anhỹr o kãm kapẽr. Na pre ra amnepêm Tĩrtũm nhỹ hã kapẽr o mẽ pa xwỳnhjê hõja ja kukamã mẽ panhĩgêtjê mã ja jarẽ nẽ hã kagà. Nẽ hã kagà kot: “Ixpê Tĩrtũm kot paj nhỹrmã Ejit rũm ma akupỹm õ pika hwỳr ixkrata wa mẽ kumẽ.” Anhỹr o kot hkukamã harẽnh nẽ hã kagà. ");
INSERT INTO apnNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Jakamã nhũm Tĩrtũm kapẽr o mẽ wrỳk xwỳnhja ã Juje mã karõ anẽ hãmri nhũm kuma nẽ ma akupỹm wa o mõ. Ma akupỹm mẽ õ pika hwỳr wa o mõ. ");
INSERT INTO apnNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Tã ra akupỹm hpôx kaxyw htêp o mõ. Hãmri nẽ pahi Erox kra Akêrawja ra hipêêxà mỳr pê kot Jutej kamã mẽ ho amnhĩptàr hã harẽnh ma. Hãmri nẽ tee ri mẽ amnhĩ kukamã hamaxpẽr nẽ kãm mẽ hwỳr wa o mõr pyma nẽ. Tã nhũm kamàt nhũm Juje ra gõr nẽ nõ nẽ kê axte amỹti. Nhũm kê axte Tĩrtũm kapẽr o mẽ wrỳk xwỳnhja hwỳr wrỳ nẽ akupỹm õ pika hkwỳ pê Jutej wỳr mõr nê wa mẽ hkurê nẽ kãm: —Pa Juje? E kêr ka Jutej wỳr wa mẽ amõr kêt nẽ. Pãnhã nhãm mẽ anhõ pika hõ hwỳr mãn mõ nẽ kamã ri apa. Anẽ nhũm kuma nẽ hpãnhã wa mẽ ma mẽ õ pika hkwỳ pê Garirej wỳr wa mẽ juk nẽ ma mõ. ");
INSERT INTO apnNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Nẽ kamã pôj nẽ krĩ pê Najare hwỳr mõ nẽ kamã amnhĩm õrkwỹ nhĩpêx nẽ kamã wa mẽ pa ho pa. Nhũm pre ra amnepêm Tĩrtũm nhỹ hã kapẽr o mẽ pa xwỳnhjê hõja ra ã mẽ kot amnhĩ nhĩpêx anhỹrja kukamã mẽ panhĩgêtjê mã mẽ harẽ nẽ hã kagà. Nẽ hã kagà kot: Tĩrtũm kot mẽ pahwỳr mẽnh mã xwỳnhta koja kêp Najare nhõ xwỳnh. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Nhũm pre Juãw Paxisja ã amnhĩ nhĩpêx anẽ. Nẽ pika pê Jutej kamã mẽ kãm Tĩrtũm kapẽr jarẽnh o pa. No ãm krĩm pa hkêt nẽ. Ãm mẽ hpu hã krĩ pê amỳm ri kapôt ã ri mẽ kãm Tĩrtũm kapẽr jarẽnh o pa. ");
INSERT INTO apnNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","3","Tĩrtũm nhỹ hã kapẽr o pa xwỳnh finat Ijais ra kot Juãw kukamã mẽ panhĩgêtjê mã tanhmã harẽnh to nẽ hã kagà xá hkôt. Na pre hkukamã hã kagà ho: Koja nhỹrmã mẽhõ mõn pôj. Kapôt ã mõn pôj nẽ mẽ kãm tanhmã mẽmoj tã karõ hto ho ri pa. Nẽ mẽ kãm: “Koja Tĩrtũm tokyx mẽ pahwỳr mẽ panhõ Pahihtija mẽ nhũm wrỳ nhũm mẽ piitã omu. Jakamã kwa mẽ tokyx kutêp tãm amnhĩ nhĩpêx o ri apa. Te mẽ kot mẽhõ kutêp pry ho mexta pyrà nẽ amnhĩ nhĩ ho tãm amnhĩ nhĩpêx nẽ tãm ajamaxpẽr mex o ri apa. Kêr ka mẽ Pahihti kutêp ã amnhĩ nhĩpêx anhỹr o ri apa.” Anhỹr o koja mẽ kãm ujarẽnh o pa. Anẽ. Na pre finat Ijaisja Juãw Paxis kukamã ã mẽ kãm harẽnh anẽ nẽ hã kagà. Tã nhũm hã kagà xàja kôt nhũm Juãw Paxisja mõn pôj. Hãmri nẽ Ijais kot hkukamã harẽnh xà hkôt kapôt ã ri mẽ kãm ujarẽnh o pa nhũm mẽ kãm mar prãm xwỳnhjaja ma hwỳr mra. Nhũm mẽ kãm kapẽr nẽ mẽ kãm: —E koja Tĩrtũm tokyx kot mẽ pakaxyw ãm xwỳnhja o amnhĩrĩt. Jakamã kwa mẽ tokyx kutêp amã amnhĩ tomnuj kaga hprãm xàj tãm amnhĩ nhĩpêx o apa. Anhỹr o Jejus kutêp mẽ kãm kapẽr o pa. ");
INSERT INTO apnNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Juãw Paxisja hikàxpore hkêt jakamã na pre ê mex kêt nẽ pa. Ãm mẽmo mry pê kamer kĩ ho amnhĩm ê nhĩpêx nẽ hagjê nẽ hã pa. Nẽ mẽmo mry hkà ho amnhĩ pre nẽ ri pa. Nẽ mẽõ mex kur kêt nẽ ãm krit ku nẽ menh ôr o ri pa. ");
INSERT INTO apnNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Jakamã nhũm kapôt ã ri mẽ kãm Tĩrtũm kapẽr jarẽnh o pa nhũm mẽ kot mar kaxyw ma hwỳr mra. Pika pê Jutej kamã ri mẽ pa xwỳnhjaja. Nẽ Jutej kamã krĩ pê Jerujarẽ nhõ xwỳnhjaja. Nẽ pyhti pê Jotãw mỳri mẽ pa xwỳnhjaja. Nhũm prem piitã harẽnh ma nẽ kot mar kaxyw ma hwỳr mra. ");
INSERT INTO apnNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Hãmri nẽ kapẽr ma nẽ Tĩrtũm noo mã mẽ kot amnhĩ tomnuj xwỳnh ã kãm amnhĩ jarẽ. Mẽ kot amnhĩ tomnuj kaga nẽ tam amnhĩ nhĩpêx o pa hprãm xàj ã kãm amnhĩ jarẽnh anẽ. Nhũm Tĩrtũm kaxkwa kamã hkrĩ htã mẽ kuma nẽ amnhĩ katut kôt mẽ kot amnhĩ tomnuj rẽnh pa nẽ axte kãm hamaxpẽr kêt nẽ. Jakamã nhũm pre Juãw Paxisja Tĩrtũm mã gôx kãm mẽ hkrã kumrãr pa. Pyhti pê Jotãw kamã mẽ hkrã kumrã. ");
INSERT INTO apnNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Tã nhũm Parijew mẽ Satusew nhõ xwỳnhjaja mããnẽn mẽ hkôt ma Juãw Paxis wỳr mra. Mẽ uràk nẽ mẽ kêp Ijaew jakamã haxwỳja Juãw Paxis kot mẽ hkrã kumrãr kaxyw ma hwỳr mra. No ãm hkwỳjê hkĩnhã mẽ kot amnhĩ tomnuj kaga hprãm xàj kãm amnhĩ jarẽnh kêt nẽ. Ãm amnhĩ krã hkôt hkwỳjê hkôt hwỳr mra nẽ amnhĩ to kuma. Nom nhũm Juãw Paxisja ra hprĩ hã ã mẽ hamaxpẽr anhỹrja kôt mẽ omunh mex nẽ. Jakamã mẽ kãm: —Tk kwa nà. Kormã mẽ ate amnhĩ tomnuj pix o ri apa kênã. Xà kot paj mẽ ate amnhĩ tomnuj o apa rãhã mẽ akrã kumrã nhũm Tĩrtũm ja hã mẽ apumu nhũm ja kãm mex nẽ? Nà koja já kãm mex kêt nẽ. Koja ja mỳrapê nhỹrmã tanhmã mẽ atomnuj tỳx to ka mẽ tee ri umaj apimxur prãm kaprỳ. ");
INSERT INTO apnNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Na htem amnhĩ tomnuj kaga nẽ tãm amnhĩ nhĩpêx nẽ tam axpẽn nhĩpêx. Jakamã e kwa mẽ ã amnhĩ nhĩpêx o apa anẽ pa rĩ kormã mẽ akrã kumrã. ");
INSERT INTO apnNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Na ka htem atỳx ri ajamaxpẽr o: “Mẽ ixpê finat Apraãw kanrẽhã htàmnhwỳ hkwỳ na pa mẽ. Jakamã koja Tĩrtũm ja hã mẽ ixpumu hãmri nẽ mẽ ixte amnhĩ tomnuj o ixpa tã nhũm ja hã tanhmã mẽ ixto hkêt nẽ. Koja mẽ ixto mex nẽ.” Anhỹr o atỳx ri amnhĩ kukamã ajamaxpẽr. Nom ja kot anhỹr kêt. Mẽ apê Apraãw kanrẽhã htàmnhwỳ htã mẽ ate uràk nẽ tãm amnhĩ nhĩpêxre hã. Kot kaj mẽ apê htàmnhwỳ htã amnhĩ tomnuj o ri apa hãmri nẽ Tĩrtũm noo mã te mẽ apê pikap kẽnre nhĩkwỹ pix pyràk. ");
INSERT INTO apnNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Na ra Tĩrtũm mẽ ate amnhĩ tomnuj mỳrapê tanhmã mẽ ato kaxyw. Te ho mẽhõ nhõ mẽmo hpàr ô hkêt nhũm kot tee ri omunh nẽ krãhyr nẽ kuwy kamã mẽnh nẽ ho kaxàr par pyràk o koja mẽ anhĩpêx. Jao amnhĩ nê kuwy hwỳr mẽ arẽ ka mẽ kamã amnhĩ xà htỳx kamã ajamak rãhã ho ri apa. Anẽ. Nhũm pre ã Juãw Paxisja Parijew mẽ Satusew nhõ xwỳnhjê mã kapẽr anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Hãmri nẽ hpãnhã axte mẽ kot mar kaxyw hwỳr mẽ mrar xwỳnhjê mã kapẽr nẽ mẽ kãm: —E ra mẽ ate amnhĩ tomnuj kaga xwỳnhjaja. Na pa Tĩrtũm mã mẽ akrã kumrãr kaxyw gô pix o mẽ akrã kumrã. Nom koja tokyx ixpãnhã Tĩrtũm kot mẽ pakaxyw ãm mã xwỳnhta tãm mẽ pahwỳr pôj. àhpumunh tỳx o kot ijakrenh par jakamã na pa hte ãm kukwak ri ixpa nẽ amnhĩ tã hã ixpijaàm o ri ixpa. Koja mẽ awỳr Tĩrtũm Karõ rẽ nhũm mẽ akarõ mã agjê. Ka mẽ ỹ hã tam amnhĩ nhĩpêx o ri apa. Nom kormã mẽ kot tãm amnhĩ nhĩpêx kêt xwỳnhjaja koja Tĩrtũm kot mẽ pahwỳr mẽnh xwỳnhja ja hã mẽ omu nẽ mẽ hipêx o te kuwy kot mẽmoj to kaxàr par pyràk o mẽ hipêx. ");
INSERT INTO apnNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","—Na htem pur kãm harôj nhĩkẽ nẽ ho grà nẽ hpãnhã kahtwỳ. Nẽ kahuk pa hãmri nẽ hkapĩ nhũm kôk apê nẽ prỳhkà ho htor pa. Nhũm mẽ hpãnhã hy ho pa nẽ ixkre kamã gôj kãm unhwỳ. Ja pyrà nẽ koja tokyx Tĩrtũmja mẽ piitã mẽ kot tanhmã amnhĩ nhĩpêx to ho pa hã mẽ omunh xà hkôt mẽ ho axkjê. Jakamã mẽ kot tãm amnhĩ nhĩpêx o mẽ pa xwỳnhjaja koja ma amnhĩ wỳr mẽ ho api nhũm mẽ kuri mex rãhã nẽ pa ho pa. No mẽ kot amnhĩ tomnuj rãhã ho mẽ pa xwỳnhjaja koja jajê hkĩnhã tanhmã mẽ homnuj to. Nhũm mẽ ma kuwy raxja wỳr pa nẽ kamã amnhĩ xà htỳx kamã hamak rãhã nẽ pa ho pa. Anhỹr o mẽ kãm kapẽr. ");
INSERT INTO apnNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Tã nhũm Jejus pika pê Garirej rũm kato nẽ ma Juãw Paxis wỳr mõ. Juãw kot pyhti pê Jotãw kamã hkrã kumrãr kaxyw ma hwỳr mõ. Hãmri nẽ omu nẽ kãm: —Pa. E ot pa awỳr amnhĩ to tẽ. Ate mẽ kuxwar ixkrã kumrãr kaxyw. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Hãmri nhũm tee ri kuma nẽ kãm: —Kwa nà. Aa ate amnhĩ tomnure hã kot pa kêt ri akrã kumrã. Nà ka kot kaj ixkrã kumrã. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Hãmri nhũm kãm: —Kwa nà. Mãmrĩ ixkrã kumrã Juãw Paxis. Tĩrtũm kãm ja prãm kênã kot ka kêt ri axtem nẽ ixkaga. Kot puj mẽ Tĩrtũm kãm hprãm xà hkôt tanhmã amnhĩ nhĩpêx to ho ri papa. Anẽ. Hãmri nhũm kuma nẽ kãm: —Tôe. Nà kot paj akrã kumrã. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Hãmri nẽ pyhti hwỳr o wrỳ nẽ kamã hkrã kumrã. Hãmri nẽ wa akupỹm api nẽ gô mỳ ri ãm rãhã nhũm kaxkwa axkjê. Hãmri nhũm kurũm Tĩrtũm Karõja Jejus wỳr te tuuti pyrà nẽ ahpar mã hwỳr wrỳk o tẽ nẽ ĩkre hã xa. Nhũm Jejus arĩ amnhĩ wỳr wrỳk o htẽm kãm omunh o xa. ");
INSERT INTO apnNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Hãmri nhũm Tĩrtũm kaxkwa rũm kãm kapẽr nẽ kãm: Pa? E apê ixkra mex na ka. Ãm hãmri na ka hte ixkanrẽhã ã amnhĩ nhĩpêx mex anẽ. Inhmã ajapê kamã na ka ri apa ho apa. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Tã nhũm Jejus Tĩrtũm Karõ nhỹ hã ma kapôt ã ri pa. Satanasti kot amnhĩ tã kamã hamak kaxyw nhũm ma kapôt ã ri pa. ");
INSERT INTO apnNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Ri pa hã apkati xohtô nẽ. Ra hã arĩgro pê 40. Nẽ kormã apkur kêt jakamã ra kãm prãm tỳx kumrẽx nẽ ri pa. ");
INSERT INTO apnNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Hãmri nhũm Satanastija nhỹhỹnh hwỳr tẽ nẽ hêx rom kãm kapẽr nẽ kãm: —Pa. E kwa mãn ka ra amã prãm tỳx nẽ nà? Nom xep apê Tĩrtũm Kra jakamã apê mẽmoj hihtỳx kêt. Tĩrtũm pyrà nẽ axàhpumunh o axàhpumunh kênã. Jakamã kwa kẽn nhĩkwỹ mũj mã anẽ kê amã pãwti hã amnhĩ jahkre ka aku nẽ tokyx ho amnhĩ xihtỳx. E kwa tokyx kãm akapẽr. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Hãmri nhũm kuma nẽ kãm: —Tk. Nà kot paj amar xà hkôt ã ri amnhĩ nhĩpêx anhỹr kêt nẽ. Koja Tĩrtũm kãm inhmã mẽmoj nhõr prãm nẽ inhmã mẽmoj gõ pa rĩ kormã kukrẽ. Kapẽr ã kagà htũm kot ja jarẽnh kot: Na htem mẽ apkur xà pix kukwak ri htĩr nẽ pa hkêt nẽ. Na htem mããnẽn Tĩrtũm kapẽr ma nẽ hkôt amnhĩ nhĩpêx nẽ htĩr nẽ pa. Anẽ. —Ã kapẽr ã kagà kamã kot harẽnh kot anhỹr jakamã kot paj akapẽr kôt ri ã amnhĩ nhĩpêx anhỹr kêt nẽ. Ãm kwarĩ ho kwarĩ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Hãmri nhũm Satanastija tee ri kuma hãmri nẽ hpãnhã ma Jerujarẽ hwỳr o mõ. Nẽ Tĩrtũm mã amnhĩ jarẽnh xà hã ixkre hprêk nhĩmõk wỳr ho api nẽ kỳxpê hatur xà hã ãm nhũm xa. Hãmri nẽ amnhĩ parpê kẽn rũnh nhĩkwỹ xwỳnhja pumunh o xa nhũm Satanasti kãm: ");
INSERT INTO apnNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","—E apê Tĩrtũm Kra jakamã kwa ja rũm ahpar mã ajarĩ nẽ ma tẽ nẽ pikap tẽm. Koja Anhĩpêêxàja apumunh mex nẽ ka tanhmã amnhĩ to hkêt nẽ. Kapẽr ã kagà htũm kot harẽnh kot: Tĩrtũm koja kapẽr o wrỳk xwỳnh kwỳjê mã ajarẽ ka ajarĩ nẽ ahpar mã tẽ nhũm mẽ kỳx pê amỳ nhũm mẽmoj akà hyr kêt nẽ. Anẽ. —Ã kapẽr ã kagà htũm kot ajarẽnh anhỹr jakamã e tokyx ajarĩ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Hãmri nhũm Jejus kuma nẽ kãm: —Tk kot paj ri ate inhmã karõ xàja kôt ã amnhĩ nhĩpêx anhỹr kêt nẽ. Koja Tĩrtũm tãm inhmã ijarĩ hã karõ pa rĩ mar xà hkôt ijarĩ. No kot pa ri amar xà hkôt ijarĩ hkêt nẽ. Tĩrtũm kapẽr ã kagà htũm kot ja jarẽnh kot: Kêr ka mẽ amnhĩ krã hkôt amnhĩ tã ixkamã ajamak kaxyw inhĩxi jarẽnh kôt tanhmã amnhĩ nhĩpêx to hkêt nẽ. Anẽ. —Ã kot ja nê kapẽr kot anhỹr jakamã kwarĩ ho kwarĩ. Kot paj ri amar xà hkôt ijarĩ hkêt kumrẽx. Tĩrtũm tãm kot inhmã ã ixte amnhĩ nhĩpêx anhỹr ã karõre hã. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Hãmri nhũm Satanasti tee ri kuma nẽ hpãnhã ma nhỹri kẽn prêêti hwỳr o tẽ nẽ himõk ã axte o xa. Hãmri nẽ kãm pika piitã ahkre hpa. Nẽ mẽ hikukrêx piitã nhũm kãm ahkre ho xa. Kàxpore nẽ mẽmoj mex piitã nhũm kãm ahkre nhũm Jejus piitã omunh o xa. ");
INSERT INTO apnNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Hãmri nhũm kê Satanasti axte kãm: —E mãn ka kam ri mẽmoj mex mũj piitã omunh pa. Piitã inhõ na. Nom kot kaj ixkutã tẽm nẽ inhmã inhmex o inhmex ã ijarẽ pa ama nẽ amã piitã õr pa. Ka kam mẽmoj piitã ho anhõ nẽ ho amnhĩptàr o apa. Jakamã e kwa tokyx. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Hãmri nhũm kuma nẽ axte kãm kapẽr nẽ kãm: —Tk kwa ma nhỹhỹm tẽ Satanasti. Kot paj ri amã amex o amex ã ajarẽnh kêt kumrẽx. Tĩrtũm kapẽr ã kagà htũm kot ja nê kapẽr kãm hihtỳx kênã. Kapẽr kot: Kêr ka mẽ ixkapẽr pix ma nẽ ixkutã pix mã akõnkrã ho akrĩ nẽ inhmã inhmex o inhmex ã ijarẽ. Kêr ka mẽ ã amnhĩ nhĩpêx anhỹr o ri apa. —Anhỹr o kot hã karõ jakamã kot paj amã amex o amex ã ajarẽnh kêt kumrẽx. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Hãmri nhũm tee ri amnhĩ tã kuma hãmri nẽ ma tẽ. Tee ri kãm kapẽr kaprỳja ã amnhĩ pumu hãmri nẽ hkaga nẽ ma tẽ. Hãmri nhũm Tĩrtũm kapẽr o mẽ wrỳk xwỳnhjaja Jejus wỳr wrỳ nẽ tanhmã ho mex to nẽ kãm õ nhũm kukrẽ nẽ akupỹm hihtỳx. ");
INSERT INTO apnNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Tã nhũm Juãw Paxisja mẽmoj tã pahi Erox mã akir nhũm amnhĩ tã kuma nẽ gryk xàj haxà nhũm hkrĩ ho hkrĩ. Hãmri nhũm Jejusja harẽnh ma nẽ ma akupỹm Garirej kamã krĩ pê Najare hwỳr ma akupỹm tẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Hãmri nẽ ra pôj nom kamã ri pa hkêt nẽ. Nẽ hpãnhã kurũm kato nẽ ma krĩ pê Kapanaũ hwỳr tẽ. Gô rax pê Garirej mỳri na pre. Pika hkwỳ pê Jepurõ mẽ Natari wa mẽ kamã na pre nhũm Jejus ma hwỳr tẽ. Hãmri nẽ kamã pa. ");
INSERT INTO apnNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Nhũm ra amnepêm Tĩrtũm nhỹ hã kapẽr jarẽnh o mẽ pa xwỳnh finat Ijaisja Jejus kukamã ra mẽ panhĩgêtjê mã ã kot amnhĩ nhĩpêx anhỹr ã harẽ nẽ hã kagà. Jejus kot ã mẽ hwỳr mõr anhỹrja kukamã nhũm pre harẽ nẽ hã kagà. ");
INSERT INTO apnNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Pika hkwỳ kamã mẽ pa xwỳnhjaja nhũm pre mẽ hkukamã mẽ harẽnh mex nẽ. Nẽ pika pê Garirej kamã mẽ pa xwỳnhjaja nhũm pre mããnẽn mẽ hkukamã mẽ harẽ. Nẽ pyhti pê Jotãw mẽ gô xujanãr wa hkaêx kãm pika piitã kamã mẽ pa xwỳnhjaja. Nẽ krĩ pê Garirej kamã mẽ kêp Ijaew kêt xwỳnhjaja nhũm pre mããnẽn mẽ harẽ. Ã na pre finat Ijaisja mẽ hkukamã Tĩrtũm nhỹ hã mẽ piitã mẽ harẽ nẽ hã kagà anẽ. Jejus kot ma mẽ hwỳr mõrja kukamã nhũm ra hprĩ hã harẽ nẽ hã kagà. Nẽ hã kagàja o: ");
INSERT INTO apnNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","E. Kot paj mẽ amã mẽmoj mex jarẽ ka mẽ inhma. Mẽ ate Tĩrtũm pumunh kêt jakamã te mẽ ate kamàt kô kamã ri apa pyràk. Tã koja Tĩrtũm mẽ amã amnhĩ to amnhĩrĩt ka mẽ hpãnhã te mẽ ate hirã kamã ri apa pyràk o amnhĩ nhĩpêx nẽ ra hkôt amnhĩ xunhwỳ. Anhỹr o mẽ hkukamã mẽ harẽ nẽ hã kagà. ");
INSERT INTO apnNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Tã nhũm ra kot hkukamã mẽ kãm ujarẽnh xà hkôt nhũm Jejusja mẽ hwỳr mõ nẽ mẽ kãm Tĩrtũm kapẽr jarẽnh o ri mẽ hkôt pa. Nẽ mẽ kãm tanhmã amnhĩ jarẽnh to ho pa. Nom kormã hprĩ hã mẽ kãm amnhĩ jarẽnh kêt nẽ. Te ho nhãm mẽhõ jarẽnh pyràk o mẽ kãm amnhĩ jarẽ nẽ mẽ kãm: —E na ra Tĩrtũmja kot mẽ akaxyw ãm xwỳnhta mẽ nhũm mẽ awỳr wrỳ. Jakamã kwa mẽ tokyx tee ri ate amnhĩ tomnuj ã amnhĩ pumu nẽ ã ate amnhĩ nhĩpêx anhỹr kaga nẽ hpãnhã Tĩrtũm kôt mãn amnhĩ nhĩpêx o ri apa. Anhỹr o mẽ kãm kapẽr o pa pê mẽ ahkre ho ri mẽ hkôt pa. ");
INSERT INTO apnNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Tã nhũm Jejus ma gô rax pê Garirej mỳ ri pa nẽ gôx kãm ja wa omu. Simãw Pêtre mẽ htõ Andreja nhũm wa gôx kãm kryhti rẽnh o wa xa. Hãmri nhũm Jejus wa hwỳr tẽ nẽ wa omu nẽ amnhĩ kôt wa kuwỳ nẽ wa kãm: ");
INSERT INTO apnNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","—Pa. E kwa ma ixkôt mãn war apa. Kot paj tanhmã war ajahkre hto ka wa ma mẽ kãm ijarẽnh o ri apa. Mẽ kot war amar nẽ ra ixkôt amnhĩ xunhwỳr kaxyw. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Hãmri nhũm wa kuma nẽ kryhti re nẽ wa ma hkôt htẽm kurê kumrẽx. ");
INSERT INTO apnNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Hãmri nhũm mẽ ma nhãm axte mõ nẽ ra jajê hwỳr kato. Jepetew mẽ hkra Xiakre mẽ Juãwja nhũm wa mẽ hwỳr kato. Nhũm mẽ õ pàr kãm kryhti ho mex o wa mẽ nhỹ. Hãmri nhũm mẽ hwỳr mra nhũm Jejus amnhĩ kôt ja wa kuwỳ nẽ wa kãm: —Pa Xiakre mẽ Juãw. E wa ma ixkôt mãn wa apa. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Hãmri nhũm wa kuma nẽ hipêêxà mã amnhĩ jarẽ nẽ ma hkôt pa ho pa kurê kumrẽx. ");
INSERT INTO apnNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Tã nhũm Jejus Garirej kamã Ijaew mã Tĩrtũm kapẽr jarẽnh o pa. Na pre hte Tĩrtũm kapẽr o mẽ ahkre xà hã ixkre hwỳr agjê nẽ kamã mẽ kãm Tĩrtũm kapẽr jarẽnh o hkrĩ nẽ mẽ kãm: —E mẽ tee ri ate amnhĩ tomnuj ã amnhĩ pumu nẽ hpãnhã Tĩrtũm kôt mãn amnhĩ nhĩpêx o ri apa. Kot kaj mẽ ã amnhĩ nhĩpêx anẽ nhũm ja hã mẽ apumu nẽ mẽ ato hkra kurê kumrẽx. Anẽ. Hãmri nẽ akupỹm mẽ kãm mẽ à xwỳnhjê ho mex. Ahpỹnhã tanhmã mẽ à kute xwỳnhjaja nhũm akupỹm mẽ ho mex o pa. ");
INSERT INTO apnNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Jakamã nhũm mẽ piitã pikaja kamã ri axpẽn mã harẽnh o hprõt. Nẽ pika pê Sir kôt mããnẽn ma ri axpẽn mã harẽnh o hprõt. Nhũm mẽ piitã harẽnh ma nẽ ma hwỳr mẽ à xwỳnhjê ho mra. Ahpỹnhã ri tanhmã mẽ à kute xwỳnhjaja. Mẽ à htỳx xwỳnhjaja. Nẽ mẽ ĩ kamã mẽ htyk xwỳnhjaja. Nẽ mẽ hkrã pipãnh xwỳnhjaja. Nẽ mẽkarõmnuti kot Satanasti nhỹ hã tanhmã ri mẽ ho xwỳnhjaja. Nhũm prem mẽ hamỳ nẽ ma Jejus wỳr mẽ o mra nhũm mẽ omu nẽ akupỹm mẽ ho mex pa. ");
INSERT INTO apnNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Jakamã nhũm mẽ ohtô nẽ ma hkôt pa. Krĩ pê Garirej rũm nẽ Tekap rũm nẽ Jerujarẽ rũm nẽ pika pê Jutej rũm. Nẽ pyhti pê Jotãw nhĩkjê rũm mẽ pa xwỳnhjaja. Nhũm mẽ ã ohtô nẽ ma Jejus kôt omunh o pa anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Nhũm Jejus amnhĩ kôt ri mẽ kot omunh o mẽ pa xwỳnhjê pumu hãmri nẽ mẽ ahkre kaxyw ma tẽ nẽ hixêt ã api nẽ himõk ã nhỹ. Hãmri nhũm mẽ ma hkôt mra nẽ pu hã hkrĩ pa. ");
INSERT INTO apnNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Hãmri nhũm mẽ ahkre nẽ mẽ kãm: ");
INSERT INTO apnNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","E mẽ inhma. Kot kaj mẽ atõ amnhĩ kaxyw tanhmã Tĩrtũm mẽ wa inhmã ajamaxpẽr to nẽ ajamaxpẽr o: “Koja Tĩrtũm inhĩhkô hã pa hkêt pa ixtỳx ri tanhmã amnhĩ tomnuj to ho ri ixpa rãhã ho ri ixpa.” Anhỹr o ajamaxpẽr. Hãmri nhũm Tĩrtũm ã ajamaxpẽr anhỹr ã apumu nhũm ja kãm mex nẽ. Hãmri nhũm apê hkra hã ato mex nẽ atãnopxar o akôt pa ho pa ka ajamakêtkati nẽ axàmnhĩx akĩnh nẽ ri apa. ");
INSERT INTO apnNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Nẽ kot ka mẽ atõ tanhmã amnhĩ tomnuj to. Hãmri nẽ tee ri ja hã amnhĩ pumu nẽ apijaàm nẽ akaprĩ nẽ. Nẽ akaprĩ xàj amỳr o nhỹ. Amỳr rax nẽ. Hãmri nhũm Tĩrtũm ja hã apumu nhũm ja kãm mex nẽ. Jakamã nhũm anê akaprĩ hta nẽ ato mex nẽ ka ajamakêtkati nẽ axàmnhĩx akĩnh nẽ ri apa. ");
INSERT INTO apnNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Nẽ kot ka mẽ atõ agryk tokyx anhỹr kêt nẽ. Nẽ kritpêm amnhĩ tã amã mẽ hkaprĩ ho ri apa. Hãmri nhũm Tĩrtũm ja hã apumu nhũm ja kãm mex nẽ. Hãmri nhũm ato mex nẽ ka ajamakêtkati nẽ axàmnhĩx akĩnh nẽ ri apa. ");
INSERT INTO apnNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Nẽ kot ka mẽ atõ amã Tĩrtũm kãm hprãm xà hkôt amnhĩ nhĩpêx o ri apa hprãm nẽ. Nhũm amnhĩ tã apumu nhũm ja kãm mex nẽ. Hãmri nhũm ato mex nẽ tanhmã akrã hto ka hkôt pix mã amnhĩ nhĩpêx o ri apa. Jao ajamakêtkati nẽ axàmnhĩx akĩnh nẽ ri apa. ");
INSERT INTO apnNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Nẽ mẽ kamã mẽ axukaprĩ ho ri apa xwỳnhjaja na hte Tĩrtũm ja hã mẽ apumu nhũm ja kãm mex nẽ. Jakamã na hte mẽ hã mẽ apyrà nẽ mẽ akamã ukaprĩ ho pa. Jao mẽ ato mex nẽ ka mẽ ajamakêtkati nẽ axàmnhĩx akĩnh nẽ ri apa. ");
INSERT INTO apnNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Nẽ kot ka mẽ atõ ã ajamaxpẽr anẽ nẽ ajamaxpẽr o: “Nà kot paj ãm Tĩrtũm kapẽr kôt pix mã ri amnhĩ nhĩpêx o ri ixpa. Ãm ja pix na inhmã hprãm.” Anhỹr o ajamaxpẽr. Hãmri nhũm Tĩrtũm amnhĩ tã mẽ apumu nẽ mẽ ato mex nẽ. Ka mẽ ajamakêtkati nẽ axàmnhĩx akĩnh nẽ ri apa. Nẽ nhỹrmã Tĩrtũm wỳr api nẽ kuri amex rãhã apa ho apa. ");
INSERT INTO apnNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Nẽ kot ka mẽ atõ mẽhõ wa kot axpẽn kutã amnhĩ xãm xwỳnhta axpẽn tã wa omu nẽ wa kot tanhmã axpẽn nhĩpêx tota nê tanhmã wa kãm akapẽr to nẽ akupỹm tãm wa ãm. Hãmri nhũm Tĩrtũm ja hã apumu nhũm ja kãm mex nẽ. Nẽ apê hkra hã ajarẽ ka ajamakêtkati nẽ axàmnhĩx akĩnh nẽ ri apa. ");
INSERT INTO apnNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Nẽ koja mẽhõ mẽ ate Tĩrtũm kapẽr mar xà hkôt amnhĩ nhĩpêx o apa hã mẽ apumu nẽ hã tanhmã mẽ anhĩpêx kati hto. Tã nom koja Tĩrtũm arĩ mẽ ato mex nẽ. Mẽ apê hkra jakamã mẽ kot tanhmã mẽ anhĩpêx hto htã ka mẽ ajamakêtkati nẽ axàmnhĩx akĩnh nẽ ri apa. ");
INSERT INTO apnNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","12","—Kwãr mẽ mãmrĩ ixtã mẽ ato kapẽr rỳ mẽ ato hêx rỳ tanhmã ri mẽ atomnuj to. Kwãr mẽ mãmrĩ ã mẽ anhĩpêx anẽ. Nom kêr ka mẽ arĩ amnhĩ kaxyw inhmã ajamaxpẽr tỳx rãhã pê ajamakêtkati nẽ axàmnhĩx akĩnh nẽ ri apa. Kwãr mẽ mãmrĩ ixtã ã mẽ anhĩpêx anẽ nẽ mẽ amex kêt ã mẽ ajarẽ. Amnepêm na prem ã Tĩrtũm nhỹ hã kapẽr jarẽnh xwỳnhjê nhĩpêx anẽ. Jakamã koja mẽ uràk nẽ ã mẽ anhĩpêx anẽ. Hãmri nhũm Tĩrtũm ja hã mẽ apumu nẽ amnhĩm mẽ amex ã mẽ ajarẽ. Hãmri nẽ nhỹrmã kaxkwa kamã wa inhõ krĩ kamã mẽ ato mex nẽ. Jakamã kêr ka mẽ ã amnhĩ kukamã ajamaxpẽr anhỹr pê mãmrĩ akĩnh nẽ ajamakêtkati nẽ axàmnhĩx ri apa. Kwãr mẽ mãmrĩ ã wa ixtã mẽ anhĩpêx anẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Nhũm Jejus arĩ mẽ kãm kapẽr nẽ mẽ kãm: —Nẽ mẽ ate ixkôt amnhĩ xunhwỳr xwỳnhjaja te mẽ ate kaxwa pyràk. Kaxwaja mẽ apkur xà ho ành mã mex. No koja mẽhõ tẽn kamã pika hkwỳ mẽ nẽ ho ahkà. Hãmri tanhmã kot wem ho nẽ akupỹm ho mex? Nà koja akupỹm mex kêt nẽ. Ãm mẽ kot hkapĩr pix kaxyw koja mex. Ja pyrà nẽ kot ka mẽ atõ ate inhmã tanhmã amnhĩ nhĩpêx to ho apa hã amnhĩ jarẽnh tã gaa nẽ rĩ amã ixkôt amnhĩ nhĩpêx prãm kêt nẽ. Hãmri nẽ ra te apê kaxwa mẽ pika pihkàrta pyràk. Kwa mẽ ixujarẽnh ma nẽ kãm ajamaxpẽr tỳx rãhã ho ri apa. ");
INSERT INTO apnNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","16","—Nẽ te mẽ ate kanê hpôk pyràk. Nẽ te mẽ ate hixêt prêk nhĩmõk ã krĩ xãm pyràk. Koja krĩja hixêt prêêti nhĩmõk ã xa nhũm mẽ piitã omu. Nẽ kanêja. Xà na htem kanê hpôk nẽ poti ho hpro? Nà na htem hpôk nẽ kỳx pê mẽmoj nhĩmõk ã unhwỳ nhũm mẽ piitã mẽ kãm hirã nhũm mẽ hirã kamã mẽmoj pumunh mex nẽ. Ja pyrà nẽ kot kaj mẽ tãm amnhĩ nhĩpêx o ri apa nhũm mẽ piitã ja hã mẽ apumunh kôt ra kaxkwa kamã Tĩrtũm mex ã harẽnh o pa. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Nhũm Jejus arĩ mẽ kãm kapẽr nẽ mẽ kãm: —Nẽ amnepêm Mojes kot Tĩrtũm nhỹ hã Ijaewjê mã tanhmã mẽ kot amnhĩ nhĩpêx to hã mẽ kãm karõja. Nẽ amnepêm Tĩrtũm nhỹ hã kapẽr jarẽnh o mẽ pa xwỳnhjê kapẽrja. Ixte mẽ kapẽr o ijapêx kaxyw na pa pre mẽ awỳr ixwrỳk kêt nẽ. Jakamã kwa mẽ ri ã axpẽn mã ijarẽnh anhỹr kêt nẽ. Kêt ixprĩ hã ixte mẽ amã mẽ kapẽr jarẽnh nhũm mẽ ate mar mex kaxyw na pa pre kaxkwa rũm mẽ awỳr wrỳ. ");
INSERT INTO apnNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","—Tĩrtũm kapẽr ã kagà htũm kot mẽmoj jarẽnhja. Koja ujarẽnh xà hkôt mẽmoj tanhmã amnhĩ to hpar mẽ nhũm rĩ kormã kaxkwa mẽ pika wa hapêx pa nhũm kapẽr ã kagàja mããnẽn hapêx. Nom nhũm Tĩrtũm kapẽr koja mẽmojja pyrà nẽ aa hapêx kêt nẽ. Koja rãhã ho rãhã nẽ aa ihkjê ho tanhmã mẽnh to hkêt nẽ. Ãm hãmri na pa ã mẽ amã harẽnh anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","—Nẽ kot ka mẽ atõ Tĩrtũm kapẽr o pixire nẽ hirôp xa. Hãmri nẽ ra amnhĩ pyrà nẽ anhĩõ mã ja hã amỹnê. Apyrà nẽ kot hirôp ãm kaxyw ka kãm hã amỹnê. Kot kaj ã amnhĩ nhĩpêx anẽ hãmri nẽ apê Tĩrtũm kra hkêt ã amnhĩ to amnhĩrĩt. Nom kot ka kêt mẽ tãm amnhĩ nhĩpêx o ri apa. Nẽ amnhĩ pyrà nẽ tãm mẽ kot amnhĩ nhĩpêx kaxyw mẽ kãm akapẽr o ri apa hãmri nhũm Tĩrtũm ja hã apumu nẽ ato hkra nẽ ato mex nẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","—No Parijew nhõ xwỳnhjaja nẽ Tĩrtũm kapẽr tũm o mẽ ahkre ho mẽ pa xwỳnhjaja. Mẽ kot Tĩrtũm kapẽr kôt amnhĩ nhĩpêx mex ã amnhĩ jarẽnh tã no ãm hkôt ã amnhĩ nhĩpêx anhỹr kêt nẽ. Jakamã kot kaj mẽ hkôt amnhĩ nhĩpêx o ri apa hãmri nẽ mẽ uràk nẽ nhỹrmã Tĩrtũm mẽ wa inhõ krĩ kamã apa hkêt nẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Nhũm Jejus arĩ mẽ kãm kapẽr nẽ mẽ kãm: —Nẽ amnepêm na prem mẽ panhĩgêtjê mã Tĩrtũm kapẽr kwỳ jarẽnh o pa nẽ mẽ kãm: Kêr ka mẽ axpẽn par kêt nẽ. Kot kaj mẽ mẽhõx pĩ nhũm mẽ ja mỳrapê atomnuj nẽ. Nẽ ma mẽ anhõ pahihti hwỳr ato tẽ nhũm mỳrapê tanhmã ato rỳ hkôt apĩ. Anẽ. Ãm hãmri na prem mẽ kãm ja jarẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Tã kot paj ixprĩ hã mẽ amã tanhmã harẽnh to ka mẽ inhma. Kot kaj mẽ mẽmoj tã anhĩõ kamã agryk. Hãmri nhũm Tĩrtũm tee ri ja hã apumu nhũm ja kãm mex kêt nẽ. Jakamã koja mẽ anhõ pahihti tanhmã ja hã mẽ ato japêr hã koja ja mex nẽ. Rỳ kot kaj mẽ tanhmã mẽhõ japrỳ hto. Ho hagrô rỳ ho rop. Mỳrapê kop apu akwỳ kot apynênh nẽ anhõ pahihti hwỳr ato htẽm nẽ ĩhkram ajaxàr ronhỹx ja inhmã mex nẽ. Rỳ kot kaj mẽ tanhmã anhĩõ mã akapẽr punuj to nẽ kãm: “Tk. Ate ho warêhti hã. Te apê hagrô pyràk kênã.” Anhỹr o kãm akapẽr. Tã kop apu Tĩrtũm ra ã akapẽr anhỹrja mỳrapê mẽ kot amnhĩ xà htỳx kamã hamak tũm xàta wỳr amẽnh ronhỹx ja inhmã mex nẽ. Ja pumaj kwa kêr ka mẽ ã axpẽn mã akapẽr anhỹr kêt nẽ. Kêt mẽ axpẽn mã tãm akapẽr pix o ri axpẽn kôt apa. ");
INSERT INTO apnNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","—Nẽ kêr ka mẽ tanhmã ate anhĩõ nhĩpêx hto kamã Tĩrtũm mã mex o mex ã harẽnh kêt nẽ. Kêr ka mẽ kãm amnhĩ jarẽnh o akrĩ hãmri nẽ ra mẽhõ kot mẽmoj tã akamã gryk xwỳnh mã ajamaxpẽr japêr. ");
INSERT INTO apnNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","Hãmri nẽ akato nẽ ma hwỳr atẽm kurê kumrẽx nẽ wa tãm axpẽn mã akapẽr nẽ tãm akupỹm axpẽn xãm. Hãmri nẽ rĩ kormã ma akupỹm tẽ nẽ Tĩrtũm mã amnhĩ jarẽnh jatur xàm amẽ nẽ kãm mex o mex ã harẽ. Kêr ka mẽ ã amnhĩ nhĩpêx anhỹr o ri apa. ");
INSERT INTO apnNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","26","—Na htem tanhmã axpẽn nhĩpêx to hãmri nẽ kot tanhmã war axpẽn to xwỳnhjê hõja ma õ pahi hwỳr tẽ nẽ kãm tanhmã kot ho xwỳnhta jarẽnh kaxyw nojarêt. Hãmri nhũm ra kamã gryk xwỳnhta kot pahi mã harẽnh kaxyw nojarêt ã harẽnh ma nẽ tee ri amnhĩ kukamã hamaxpẽr nẽ ma hwỳr tẽ nẽ wa akupỹm tãm axpẽn xãm. Na htem ã amnhĩ nhĩpêx anẽ. Pahi kot wa harẽnh mar nẽ tanhmã axpẽn tã wa ho pymaj na htem ã amnhĩ nhĩpêx anẽ nẽ tokyx tãm akupỹm axpẽn xunhwỳ. No koja mẽ anhỹr kêt nhũm pahija wa harẽnh ma nẽ wa kot tanhmã axpẽn to xwỳnhta õ jaxà nhũm tee ri kãm kator prãm. Hãmri nẽ tanhmã amnhĩ to nẽ ra amnhĩ pãnhã kãm amnhĩrer pa nhũm pahihtija rĩ kormã pôristi mã anẽ nhũm kãm ure nhũm kato. Ja pyrà nẽ kêr ka mẽ Tĩrtũm tanhmã kot mẽ anhĩpêx to pymaj tokyx mẽ ate amnhĩ tomnuj kaga nẽ hkôt amnhĩ nhĩpêx rãhã ho ri apa. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Nhũm Jejus arĩ mẽ kãm kapẽr nẽ mẽ kãm: —Nẽ na pre finat Mojesja mẽ panhĩgêtjê mã Tĩrtũm kapẽr tũm kwỳ jarẽ nẽ mẽ kãm: “Kêr ka mẽ amnhĩ prõ pix tãnopxar o ri apa. No mẽ kuhpa hã nhãm mẽhõ ho amnhĩkati ho ri apa hkêt nẽ.” Anẽ. Ãm hãmri na pre mẽ kãm ja hã karõ. ");
INSERT INTO apnNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Tã kot paj ixprĩ hã mẽ amã tanhmã harẽnh to ka mẽ inhma. Kot kaj mẽ nhãm mẽhõ pumu nẽ amã ho amnhĩkati hprãm mã ajamaxpẽr. Jao te ra ate ho amnhĩkati pyràk o amnhĩ nhĩpêx. Kormã ate ho amnhĩkati hkêt tã ra hkukamã ajamaxpẽr jakamã te ra ate ho amnhĩkati pyràk o amnhĩ nhĩpêx. ");
INSERT INTO apnNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","ã mẽ hamaxpẽr punuj anhỹr xwỳnhjaja koja mẽ nhỹrmã ma mẽ kot amnhĩ xà htỳx kamã hamak tũm xàta wỳr ma mra nẽ kamã pa rãhã ho pa. Jakamã kêr ka mẽ nhãm mẽhõ pumu nẽ amã hkĩnh japêr hãmri nẽ te ate ano kaxàr nẽ mẽnh nẽ axte ate omunh kêt pyràk o amnhĩ nhĩpêx. Jao hkàx ã rĩt nẽ ma nhỹhỹm atẽm kurê kumrẽx. ");
INSERT INTO apnNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","—Nẽ kot kaj mẽ anhĩhkra ho tanhmã amnhĩ tomnuj to kaxyw. Hãmri nẽ tee ri ja hã amnhĩ pumu nẽ te ate amnhĩ nhĩhkra krãhyr nẽ mẽnh pyràk o amnhĩ nhĩpêx nẽ tanhmã amnhĩ tomnuj to hkêt nẽ. Mẽ ĩhkra ho mẽ kot tanhmã amnhĩ tomnuj to ho mẽ pa xwỳnhjaja koja mẽ nhỹrmã ma mẽ kot amnhĩ xà htỳx kamã hamak tũm xàta wỳr ma mra nẽ kamã pa rãhã ho pa. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Nhũm Jejus arĩ mẽ kãm kapẽr nẽ mẽ kãm: —Nẽ na pre finat Mojes mẽ panhĩgêtjê mã Tĩrtũm kapẽr tũm kwỳ jarẽ nẽ mẽ kãm: “Kot kaj mẽ atõ aprõ kaga kaxyw hãmri nẽ ate hkaga hã amnhĩ jarẽnh ã kagà nhĩpêx nẽ kãm agõ nẽ rĩ kormã hkaga.” Anẽ. Ãm hãmri na pre ã mẽ kãm Tĩrtũm kapẽr tũm jarẽnh anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Tã kot paj ixprĩ hã mẽ amã tanhmã harẽnh to ka mẽ inhma. Kêr ka mẽ atỳx ri amã hprãm xà hkôt aprõ kaga hkêt nẽ. Nom koja aprõ akuhpa hã nhãm mẽhõ ho amnhĩkati ka harẽnh ma hãmri nẽ amã ja hã hkaga hprãm nẽ mãmrĩ kam nẽ hkaga. Ja tanhmã kute hkêt. Nom koja ã amnhĩ nhĩpêx anhỹr kêt tã ka amnhĩ krã hkôt hkaga. Hãmri nhũm mẽhõ apãnhã ho hprõ nẽ o pa. Hãmri nẽ ra kot apê aprõ ho amnhĩkati ho pa pyràk o hipêx. Nẽ nija haxwỳja. Te arĩ kêp aprõ htã akuhpa hã nhãm myja o amnhĩkati o pa pyràk o amnhĩ nhĩpêx. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Nhũm Jejus arĩ mẽ kãm kapẽr nẽ mẽ kãm: —Nẽ na pre finat Mojes mẽ panhĩgêt nẽ pahpãmjê mã Tĩrtũm kapẽr tũm jarẽnh o: “Kêr ka mẽ Tĩrtũm mã mẽmoj to anhỹr ã amnhĩ jarẽ hãmri nẽ amnhĩ jarẽnh xà hkôt kãm tanhmã amnhĩ nhĩpêx to. Nom kêr ka mẽ atỳx ri kãm tanhmã amnhĩ jarẽnh to ho amnhĩ to axêx kêt nẽ. Ãm akatàt kôt mẽ ate amnhĩ jarẽnh to xà hkôt kãm tanhmã mẽmoj to.” Anẽ. Ãm hãmri na pre mẽ kãm ja jarẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Tã kot paj ixprĩ hã mẽ amã tanhmã harẽnh to ka mẽ inhma. Kêr ka mẽhõ mã tanhmã amnhĩ jarẽnh to. Tĩrtũm mã pix mã amnhĩ jarẽnh kêt nhãm mẽhõ mã mããnẽn tanhmã amnhĩ jarẽnh to. Nẽ akatàt kôt kãm amnhĩ jarẽ. Na ka htem mẽ kot mẽ axêx kêt kôt mẽ apumunh kaxyw mẽmoj nhĩxi jarẽnh kôt amnhĩ jarẽ. Nom kêr ka mẽ axte ã mẽmo nhĩxi hã amnhĩ jarẽnh anhỹr kêt nẽ. Mẽmoj tã amnhĩ jarẽ nẽ akatàt kôt amnhĩ jarẽnh kurê kumrẽx. No mẽ kot axêx kêt kôt apumunh kaxyw mẽmoj nhĩxi hkôt amnhĩ jarẽnh kêt nẽ. Tanhmãn kaxkwa nhĩxi jarẽnh kôt mẽmoj tã amnhĩ jarẽnh kêt nẽ. Kaxkwa kêp Tĩrtũm krĩ xà maati kênã kot ka kêt mẽ axtem nẽ atỳx ri amnhĩ kaxyw hixi jarẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Rỳ mẽ kot axêx kêt kôt apumunh kaxyw pika nhĩxi jarẽnh kêt nẽ. Pika kêp Tĩrtũm par xãm xà kênã kot ka kêt mẽ atỳx ri amnhĩ kaxyw tanhmã hixi jarẽnh to. Nẽ krĩ pê Jerujarẽja mããnẽn kêr ka mẽ ri amnhĩ kaxyw tanhmã hixi jarẽnh to hkêt nẽ. Koja nhỹrmã Tĩrtũm mẽ awỳr Jerujarẽ hwỳr ixpê pahi maati hã inhmẽ pa kamã mẽ ato amnhĩptàr o ixkrĩ. Jakamã kêr ka mẽ ri atỳx amnhĩ kaxyw tanhmã hixi jarẽnh to ho ri apa hkêt nẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","—Nẽ kêr ka mẽ kot axêx kêt kôt apumunh kaxyw mẽ ri tanhmã amnhĩ krã hkĩ jarẽnh to hkêt nẽ. Kot kaj mẽ anẽ nẽ ãm tanhmã hã harẽnh to kaprỳ. Xà kot kaj mẽ ajamaxpẽr pix o tanhmã amnhĩ krã hkĩ hto? Nà kot kaj mẽ ho anhỹr kêt nẽ. Jakamã mẽ ri atỳx tanhmã harẽnh to hkêt nẽ. Nẽ mẽ atỳx ri mẽmo nhĩxi jarẽnh kôt mẽmoj tã amnhĩ jarẽnh o apa hkêt nẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","ãm akatàt kôt tãm amnhĩ jarẽnh kurê kumrẽx. Jao mẽ kãm: “Tỳ. Nà kot paj ho anẽ.” Anhỹr o mẽmoj tanhmã ho. Rỳ mẽ kãm: “Nà kot paj ho anhỹr kêt nẽ.” Anhỹr o mẽmoj tanhmã ho hkêt nẽ. Ãm akatàt kôt tanhmã mẽmoj tã amnhĩ jarẽnh to xà hkôt ho anhỹr kurê kumrẽx. Mẽ kot Satanasti hkôt amnhĩ nhĩpêx o mẽ pa xwỳnh pixjaja na htem hêx rom mẽmoj nhĩxi jarẽnh kôt tanhmã amnhĩ jarẽnh to ho pa. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Nhũm Jejusja arĩ mẽ kãm kapẽr nẽ mẽ kãm: —Na prem amnepêm mẽ panhĩgêtjê mã Tĩrtũm kapẽr tũm jarẽnh o: “Koja mẽhõ apê ano katõk nẽ hkapa hã koja mẽ anhõ pahija atã mã ho anẽ nẽ kêp no kapa. Rỳ koja mẽhõ apê axwa hõ hkwỹr hã koja atã mã ho anẽ nẽ atã kêp wa hõ hkwỹr.” Anhỹr o mẽ kãm hã karõ. Ãm hãmri na prem ã ja jarẽnh anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Tã kot paj ixprĩ hã mẽ amã tanhmã ja jarẽnh to ka mẽ inhma. Koja mẽhõ tanhmã mẽ anhĩpêx to ka mẽ ãm amnhĩ tã omu nẽ tanhmã amnhĩ tã ho hkêt nẽ. Koja anhĩnep akura ka ãm omu nẽ tanhmã amnhĩ tã ho hkêt nẽ. Te ate kãm ihkjê hpẽr nhũm kot ihkjê kamã hkuranh pyràk o amnhĩ nhĩpêx nhũm ja amã mex nẽ. No amnhĩ tã tanhmã ho hkêt nẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","—Nẽ koja mẽhõ anhĩnôhkà hã awỳ nhũm mẽ anhõ pahija amã anẽ ka mãmrĩ kãm agõ nẽ tanhmã hã kãm nẽ hkêt nẽ. Te ate hkôt kry pê kãm anhĩnôhkà hpakà ry jagjênh xwỳnhta nhõr pyràk o amnhĩ nhĩpêx. Nom kêr ka mẽ kamã agryk kamã kãm õr kêt nẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","—Nẽ koja mẽhõ ate kãm jênh tur nẽ hkôt ho amõr ryy kaxyw amã kapẽr ka mãmrĩ kãm ho anẽ. Nẽ kot amã nhỹri hã karõ xàja wỳr o pôj nom kamã kãm õr kêt nẽ. Kãm ho hakrenh ryy nẽ rĩ kormã akupỹm kãm agõ. ");
INSERT INTO apnNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","—Nẽ koja mẽhõ õ mẽmoj kêt nẽ awỳr tẽ nẽ mẽmoj tã awỳ ka mãmrĩ kãm agõ. Rỳ nhũm awỳr tẽ nẽ apê mẽmoj to ĩpresta kaxyw ka mãmrĩ kãm ho ĩpresta. Kêr ka mẽ ã axpẽn nhĩpêx anhỹr o ri apa. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Nhũm Jejus arĩ mẽ kãm kapẽr nẽ mẽ kãm: —Nẽ na prem amnhĩ krã hkôt axtem nẽ tanhmã mẽ panhĩgêtjê mã mẽmoj jarẽnh to nẽ mẽ kãm: “Kêr ka mẽ amã mẽ akràmnhwỳjê pix kĩnh nẽ tanhmã mẽ ho mex to. No kêt mẽ kot tanhmã mẽ ato xwỳnhjaja kêr ka mẽ mãmrĩ mẽ kamã axàhkurê ho ri apa.” Anhỹr o mẽ kãm karõ. ");
INSERT INTO apnNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Nom pa kot paj mẽ amã Tĩrtũm kot tanhmã ja hã karõ hto hã harẽ ka mẽ inhma. Kêr ka mẽ kot tanhmã ri mẽ atomnuj to xwỳnhjaja amnhĩ tã tanhmã mẽ ho hkêt nẽ. Ãm tanhmã mẽ ho mex to pix hkukamã mãn ajamaxpẽr. Nẽ mẽ ho Tĩrtũm wỳr pix kukamã mãn ajamaxpẽr. ");
INSERT INTO apnNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Na hte ã kaxkwa kamã Mẽpahpãm Tĩrtũmja amnhĩ nhĩpêx anhỹr o pa. Mẽ kot amnhĩ tomnuj xwỳnhjaja nẽ mẽ kot amnhĩ to mex xwỳnhjaja nhũm hte mẽ ho hpimrààtã mẽ ho mex o axpẽn pyràk. Jao hamẽ wa hwỳr na rẽ nẽ hamẽ wa hwỳr myyti rẽ nhũm hamẽ wa kãm hirã ho pa. Jakamã kêr ka mẽ uràk nẽ mẽ piitã tãm mẽ hipêx o axpẽn pyràk. Mẽ kot amnhĩ tomnuj xwỳnhjê mẽ mẽ kot amnhĩ to mex xwỳnhjê mẽ ho apimrààtã mẽ ho mex o axpẽn pyràk. ");
INSERT INTO apnNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","—Nẽ xàt kaj mẽ amã mẽ piitã mẽ ho mex prãm kêt nẽ ãm mẽ kot mẽ ato mex xwỳnh pixjaja ka mẽ amã mẽ ho mex prãm nhũm Tĩrtũm ja hã mẽ apumu nhũm ja kãm mex nẽ nà? Nà koja kãm mex kêt nẽ. Koja mẽhõ ato mex kêt tã kêr ka ãm amnhĩ rom ho mex nẽ. Nhũm Tĩrtũm ja hã apumu nẽ amnhĩm amex ã ajarẽ. Mẽ kot amnhĩ tomnuj xwỳnhjaja na htem ãm mẽ kot mẽ ho mex xwỳnh pixjaja nhũm mẽ amnhĩ xwar mẽ ho mex. No tãm mẽ kot amnhĩ nhĩpêx xwỳnhjaja na htem mẽ piitã mẽ ho mex o axpẽn pyràk. Mẽ kot tãm amnhĩ nhĩpêx xwỳnhjaja nẽ mẽ kot amnhĩ tomnuj xwỳnhjaja nhũm mẽ ho hpimrààtã mẽ ho mex o axpẽn pyràk. ");
INSERT INTO apnNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","—Nẽ na hte mẽ hkwỳjaja ãm amnhĩ kwỳjê pix mã kapẽr mex o pa. Nom mẽ piitã tãm mẽ hipêx kêt nẽ. Nom kêr ka mẽ ã amnhĩ nhĩpêx anhỹr kêt nẽ. Kêr ka mẽ kurom mẽ piitã tãm mẽ hipêx o axpẽn pyràk. Mẽ akwỳjê mẽ mẽ akwỳ hkêt xwỳnhjaja ka mẽ hipêx o axpẽn pyràk. Nẽ tãm mẽ kãm akapẽr o axpẽn pyràk. ");
INSERT INTO apnNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Kaxkwa kamã Mẽpahpãm Tĩrtũm pyrà nẽ mẽ kot amnhĩ tomnuj xwỳnhjê mẽ mẽ kot amnhĩ to mex xwỳnhjaja mẽ ho apimrààtã mẽ ho mex o axpẽn pyràk. Na hte ã Tĩrtũmja mẽ panhĩpêx anẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","2","Nhũm Jejus arĩ mẽ kãm kapẽr nẽ mẽ kãm: —Nẽ na htem mẽ piitã hkwỳjê noo mã tanhmã mẽ kêp amrakati xwỳnhjê ho mex to. Nom kãm mẽ hkaprĩ kamã tanhmã mẽ ho mex to hkêt nẽ. Ãm hkwỳjaja kot ja hã mẽ omunh nẽ mẽ mex ã mẽ harẽnh pix kaxyw na htem krĩ hkôt ri mẽ kêp amrakati xwỳnh piitã mẽ ho mex o pa. Nẽ mẽ pikuprõnh xà hã ixkre kamã kuhê nẽ tanhmã mẽ ho mex to. Mẽ hkwỳjaja kot ja hã mẽ omunh nẽ amnhĩm mẽ mex ã mẽ ho jarkrar kaxyw. Jakamã koja nhỹrmã Tĩrtũmja axte ja hã mẽ kãm mẽmoj mex nhõr kêt nẽ. Ra jar mẽ hkwỳjaja kot ja hã mẽ omunh nẽ amnhĩm mẽ mex ã mẽ harẽnh kênã. Jakamã kwa kêr ka mẽ ho mẽ uràk kêt nẽ. Nẽ tanhmã mẽhõ ho mex to kaxyw nẽ akwỳjê no kuhpa hã mẽ hkàx ã tanhmã mẽ ho mex to. No kot kaj mẽ noo mã tanhmã mẽ ho mex to. Mẽ kot hã apumunh nẽ ato jarkrar kaxyw tanhmã mẽ ho mex to nhũm kaxkwa kamã Mẽpahpãmja ja hã apumu nẽ mẽ hã tanhmã ato mex to hkêt nẽ. Koja ãm hã apumu. ");
INSERT INTO apnNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","—Ja pymaj kêr ka mẽ mẽ kêp amrakati xwỳnhjê mã mẽmoj nhõr kaxyw hãmri nẽ mẽ piitã mẽ no hkàx ã tanhmã mẽ ho mex to. Hãmri nẽ nhãm ri ja hã mẽ kãm amnhĩ to jarkrar kêt nẽ. Aprõ mã rỳ akrajê mã rỳ akràmnhwỳ mã hã amnhĩ jarẽnh kêt nẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Kot kaj mẽ no hkàx ã tanhmã ho mex to no nhũm Tĩrtũm tapxipix apumunh o nhỹ. Hãmri nẽ ja hã ato mex rax nẽ ka amex nẽ apa. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Nhũm Jejus arĩ mẽ kãm kapẽr nẽ mẽ kãm: —Nẽ mããnẽn ja. Na htem hakwa pix o amnhĩ mex ã amnhĩ jarẽnh xwỳnhjaja Tĩrtũm mã amnhĩ jarẽnh kaxyw nẽ mẽ kot Tĩrtũm kapẽr o mẽ ahkre xà hã ixkreja wỳr agjê. Nẽ mẽ piitã mẽ noo mã kãm tanhmã amnhĩ jarẽnh to. Rỳ gàp kuhê nẽ mẽ piitã mẽ noo mã kãm amnhĩ jarẽ. Tã mẽmo kaxyw na htem mẽ noo mã Tĩrtũm mã amnhĩ jarẽ? Nà ãm mẽ kot ja hã mẽ omunh nẽ mẽ mex ã mẽ ho jarkrar pix kaxyw. Nẽ mẽ harẽnh o: “E mũjti pumu. Na hte apkati mẽ ã Tĩrtũm mã amnhĩ jarẽnh anẽ. Kot amnhĩ to mex xwỳnh mãn.” Anhỹr ã harẽnh kaxyw. Tã ra mẽ piitã mẽ kot ja hã omunh nẽ amnhĩm mex ã ho jarkrar jakamã koja Tĩrtũm axte ja hã tanhmã ho mex to hkêt nẽ. Ra pika ja kamã mẽ kot mẽ omunh nẽ mẽ mex ã mẽ harẽnh kênã. ");
INSERT INTO apnNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","No mẽ kajaja. Kêr ka mẽ uràk nẽ ã amnhĩ nhĩpêx anhỹr kêt nẽ. Ãm Tĩrtũm mã amnhĩ jarẽnh kaxyw nẽ akwỳjê no hkàx ã hitom wỳr agjê nẽ hitom kãm ahte kãm amnhĩ jarẽ. Hãmri nhũm Tĩrtũm tapxipix ja hã mẽ apumu. Mẽ amã amnhĩ to amnhĩrĩt kêt tã mẽ apumu. Hãmri nẽ mẽ ato mex nẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","—Nẽ mẽ kêp Tĩrtũm kra hkêt xwỳnhjaja na htem sãnti mã amnhĩ jarẽnh kaxyw nẽ xatã kãm amnhĩ jarẽ. Nẽ xatã kàx pêê kãm amnhĩ jarẽ. Nẽ hamaxpẽr o: “Kot paj xatã sãnti mã amnhĩ jarẽ nhũm inhmar japêr.” Anhỹr o hamaxpẽr jakamã xatã kãm amnhĩ jarẽ. No ãm htỳx ã hamaxpẽr anhỹr kaprỳ. ");
INSERT INTO apnNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Jakamã kwa kêr ka mẽ ho mẽ uràk kêt nẽ. Tĩrtũm ra kot mẽ ate mẽmoj tã hwỳr xàta ra ja kukamã kot omunh mex kênã kot ka kêt mẽ xatã hã hwỳr o akuhê. ");
INSERT INTO apnNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","—Nẽ kêr ka mẽ kãm amnhĩ jarẽnh kaxyw nẽ amnhĩ krã hkôt tanhmã kãm amnhĩ jarẽnh to rỳ kãm amnhĩ jarẽnh o: Pa Mẽinhĩpêêxà maati pê kaxkwa kamã ri apa xwỳnh? Amex o amex Tĩrtũm. ");
INSERT INTO apnNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Apê mẽ ijamãr mex xwỳnh maati na ka. Na hte kaxkwa kamã mẽ kot ri amã tanhmã amnhĩ nhĩpêx to ho mẽ pa xwỳnhjaja akôt pix mã amnhĩ nhĩpêx o ri pa. Tã ijaxwỳja inhmã mẽ uràk nẽ akôt pix mã amnhĩ nhĩpêx o ri ixpa hprãm. ");
INSERT INTO apnNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Nẽ kwa jarãhã mẽ inhmã mẽmoj gõ pa mẽ akukwak ri ho apku. ");
INSERT INTO apnNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Na pa hte tõhã amnhĩ tomnuj nẽ Tĩrtũm. Nom mẽ kot tanhmã ixtomnuj to xwỳnhjaja na pa hte ãm mẽ omu nẽ amnhĩ tã tanhmã mẽ ho hkêt nẽ. Nẽ ja ho ijamakêtkati nẽ axte kãm ijamaxpẽr kêt nẽ. Ã ixte amnhĩ nhĩpêx anhỹr jakamã kwa ja hã ixpumu nẽ ixpyrà nẽ ixte tanhmã amnhĩ tomnuj to hã ixpumu nẽ hã tanhmã ixto hkêt nẽ. Ãm ho ajamakêtkati kurê kumrẽx nẽ axte kãm ajamaxpẽr kêt nẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Nẽ kot paj nhỹrmã tanhmã amnhĩ tomnuj to kaxyw ka ja hã ixpumu nẽ ixte ã amnhĩ nhĩpêx anhỹrja nê ixto htỳx nẽ pa tanhmã amnhĩ tomnuj to hkêt nẽ. Ãm mẽmoj punuj pê ixpytàr rãhã ho apa Tĩrtũm. Tã ãm ja pix na hapêx. Anẽ. —E kêr ka mẽ ã Tĩrtũm mã amnhĩ jarẽnh anẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","—Nẽ koja mẽhõ tanhmã anhĩpêx to htã ka ho ajamakêtkati nẽ axte kãm ajamaxpẽr pix o ri apa hkêt nẽ. Hã koja kaxkwa kamã Mẽpahpãm maatija ja hã apumu nẽ apyrà nẽ tanhmã ate amnhĩ tomnuj to ho hamakêtkati nẽ axte kãm hamaxpẽr kêt nẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Nom kot kaj mẽ ã amnhĩ nhĩpêx anhỹr kêt nẽ. Nẽ tanhmã mẽ kot mẽ atota ã anohtỳx rãhã ho apa hãmri nhũm Mẽpahpãm maatija mẽ apyrà nẽ mẽ ate tanhmã amnhĩ tomnuj to ho hamakêtkati hkêt nẽ. Ãm hã nohtỳx rãhã ho pa ho pa. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Nhũm Jejus arĩ mẽ kãm kapẽr nẽ mẽ kãm: —Nẽ mẽ kot amnhĩ to jarkrar xwỳnhjaja na htem Tĩrtũm mã amnhĩ jarẽnh kaxyw hãmri nẽ tõhã ho apkur kêt rãhã kãm amnhĩ jarẽnh jakamã hkuk kaprĩ nẽ hkwỳjê hkôt pa. Tã mo kaxyw na htem ã mẽ noo mã amnhĩ nhĩpêx anẽ? ãm mẽ apkur kêt rãhã Tĩrtũm mã amnhĩ jarẽnh ã mẽ omunh pix kaxyw. Tã ra jar pika ja kamã mẽ kot ja hã mẽ omunh jakamã koja Tĩrtũm nhỹrmã ja hã tanhmã mẽ ho mex to hkêt nẽ. Jakamã kwa kêr ka mẽ ho mẽ uràk kêt nẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Kêr ka mẽ tõhã Tĩrtũm mã amnhĩ jarẽnh ryy kaxyw axàpkur kaga hãmri nẽ amnhĩ krã kahõ nẽ amnhĩ jaxwỳr mux nẽ akuk kĩnh nẽ ri akwỳjê hkôt apa. ");
INSERT INTO apnNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Hãmri nẽ nhỹri mẽ hkàx ã ahte kãm amnhĩ jarẽ nẽ kãm mex o mex ã harẽ. Kot kaj mẽ ã mẽ hkàx ã amnhĩ nhĩpêx anẽ nhũm mẽ akwỳjaja mẽ axàpkur kaga hã mẽ apumunh kêt nẽ. Nhũm Tĩrtũm pix ja hã mẽ apumu. Hãmri nẽ nhỹrmã ja hã mẽ ato mex nẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Nhũm Jejus arĩ mẽ kãm kapẽr nẽ mẽ kãm: —Nẽ mããnẽn ja. Kêr ka mẽ jar pika ja kamã akukrêx rũnh o apa hkêt nẽ. Kêt jar mẽ hikukrêx koja kritpêm mex kêt nẽ. Kot kaj mẽ ho akuprõ nhũm amnhôre apê homnu rỳ paratre apê homnu. Nẽ kàx o mẽ akukrêx nhũm haxwỳja apê omnu rỳ nhũm mẽhõ apê hkwỳ ho ahkĩ. ");
INSERT INTO apnNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Jakamã kêr ka mẽ akukrêx rũnh o apa hkêt nẽ. Kaxkwa kamã Tĩrtũm kot mẽ akutêp mẽ akukrêx o pikuprõnhja na kêt mex kumrẽx o jar mẽ hikukrêx jakrenh par. Jakamã kêr ka mẽ amã nhỹrmã kaxkwa kamã akukrêx mex prãm xàj tãm mẽ piitã tãm mẽ hipêx nẽ mẽ ho mex o ri apa. Nẽ mẽ kamã axukaprĩ nẽ. Nẽ Tĩrtũm kôt ri amnhĩ nhĩpêx mex nẽ. Hãmri nhũm ã mẽ ate amnhĩ nhĩpêx anhỹr ã mẽ apumu nẽ mẽ akutêp mẽ amã mẽmoj mex kwỳ jaxwỳ. Kaxkwa kamã mo amnhôre nẽ mo paratre? Nẽ kamã mo mẽ ahkĩnh xwỳnh? ãm kamã amrakati kumrẽx. ");
INSERT INTO apnNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Kot kaj mẽ jar akukrêx rũnh hãmri nẽ ãm tanhmã apê homnu hto pix kukamã ajamaxpẽr. Nom kot kaj mẽ apê Tĩrtũm kra hã kaxkwa kamã akukrêx mã ajamaxpẽr rãhã ho ra akĩnh nẽ ri apa. ");
INSERT INTO apnNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","—Nẽ kot kaj mẽ ixkapẽr ma nẽ ixkôt amnhĩ nhĩpêx hãmri nẽ tãm amnhĩ nhĩpêx. Nẽ tãm axpẽn hipêx. Jao te hirã kamã arĩt mex pyràk o amnhĩ nhĩpêx. ");
INSERT INTO apnNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","No koja mẽhõ ixkapẽr ma nẽ ãm kuma nẽ ixkwỳm ri amnhĩ nhĩpêx o pa. Hãmri nẽ te kamàt kô kamã mẽhõ rĩt mex kêt kot amnhĩ nhĩpêx pyràk o amnhĩ nhĩpêx. E kêr ka mẽ ã amnhĩ nhĩpêx anhỹr pymaj ixkapẽr ma nẽ kãm ajamaxpẽr tỳx rãhã ho ri apa. ");
INSERT INTO apnNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","—Nẽ kot kaj apyxi nẽ anhõ patrãw hamẽxkrut hãmri nẽ arĩgro pyxi hã hamẽ wa kãm axàpênh o amỹkry hkêt nẽ. Kot kaj anẽ nẽ hõ gryk ã ihõ kaga. Ja pyrà nẽ kot kaj mẽ jar akàxpore nẽ akukrêx pix mã ajamaxpẽr nẽ amã hapê ho akwỳjê pê ho anhõxỳ ho ri apa. Nẽ gryk ã Tĩrtũm kãm hprãm xà hkôt tanhmã ho mẽ ho mex to hkêt nẽ. Jakamã kwa kêr ka mẽ Tĩrtũm pix mã mãn ajamaxpẽr rãhã nẽ. Jao akàxpore nẽ akukrêx pix kukamã ajamaxpẽr o ri apa hkêt nẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Nhũm Jejus arĩ mẽ kãm kapẽr nẽ mẽ kãm: —E. Kwa kêr ka mẽ tee ri mẽmoj tã amnhĩ kukamã ajamaxpẽr kêt nẽ. Tanhmãn axàpkur xà rỳ axê ka mẽ tee ri hkukamã ajamaxpẽr kêt nẽ. Mẽmoj piitã hkukamã tee ri ajamaxpẽr o ri apa hkêt nẽ. Tĩrtũmja àhpumunh tỳx o àhpumunh tỳx xwỳnh na. Na pre àhpumunh tỳx o mẽ anhĩpêx ka mẽ kukwak ri atĩr nẽ apa. Jakamã xà kot mẽ amã mẽ anhõ ho pa kaxyw àhpumunh kêt? Nà ja kaxyw àhpumunh tỳx kênã. Kêp mẽ anhĩpêx xwỳnh jakamã mããnẽn kêp mẽ amã mẽ anhõ xwỳnh. Nẽ kêp mẽ amã mẽ axê nhõr xwỳnh. ");
INSERT INTO apnNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","—Mãn ka htem kuwênhre pumu. Na hte tee ri amnhĩ xàpkur xà hkukamã hamaxpẽr o hkaprĩ nẽ ri pa hkêt nẽ. Mẽ anhĩpêêxà maati tãm na hte kãm õ ho pa. Tã kãm mẽ ajapê htỳx o kot kuwênhre jakrenh jakamã koja uràk nẽ mẽ amã mẽ anhõ rãhã ho pa. ");
INSERT INTO apnNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","—Nẽ xà kot kaj mẽ kritpêm atĩr prãm xàj ja pix kukamã ajamaxpẽr rãhã nẽ ra ajamaxpẽr kôt kritpêm atĩr nẽ apa? Nà kot kaj mẽ anhỹr kêt nẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","—Mãn ka htem akunĩ kamã pixôrã pumu. Na hte tee ri tanhmã kute hkukamã hamaxpẽr o ra hkaprĩ nẽ harir kêt nẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Tã nom muxre nẽ harir ka mẽ omu. Te ho amnepêm pahihti Sarumãw xê mex pyràk nom mex o hakre. ");
INSERT INTO apnNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Pixôrãreja koja mẽmo arĩgro hã htĩr nẽ mux nẽ harir tã mẽmo arĩgro hã ra grà pa nẽ hapêx. Kêp pixôrã pix nẽ hapêx tokyx anhỹr tã nhũm Tĩrtũm ho mex nẽ nhũm mux nẽ harir. No mẽ kajaja na hte mẽ ato mex o pixôrã ho mexta jakre. Jakamã kwa mẽmo kaxyw kot ka kêt mẽ tee ri amnhĩ xê hkukamã ajamaxpẽr o ri akaprĩ nẽ apa? Kot kaj mẽ ã ajamaxpẽr anhỹr jao kormã amnhĩ kaxyw Tĩrtũm mã ajamaxpẽr tỳx kêt nẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","—Kwa mẽ tee ri axàpkur xà hkukamã ajamaxpẽr o ri akaprĩ hkêt nẽ. Nẽ tee ri amnhĩ kukamã tanhmã ajamaxpẽr to ho ri akaprĩ hkêt nẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Mẽ kot Tĩrtũm kôt amnhĩ xunhwỳr kêt xwỳnhjaja na htem ã ri hamaxpẽr anhỹr o pa. Tã nom kêr ka mẽ ho mẽ uràk kêt nẽ. Tĩrtũm ra kot mẽ panhõ mẽmoj kêt kôt mẽ pahpumunh mex kênã. ");
INSERT INTO apnNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Jakamã kêr ka mẽ hkôt ri tanhmã amnhĩ nhĩpêx to rãhã ho ri apa. Nẽ amã ja pix tãnopxar prãm. Hãmri nhũm Tĩrtũm amnhĩ tã mẽ apumu nẽ apkati mẽ mẽ amã mẽmoj nhõr o pa. ");
INSERT INTO apnNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","—Jakamã kwa kêr ka mẽ tee ri amnhĩ kukamã ajamaxpẽr o akaprĩ nẽ apa hkêt nẽ. Tĩrtũm kot apkati mẽ mẽ pajamãr mex jakamã kêr ka mẽ jarãhã amnhĩ kukamã apkati mẽ ajamaxpẽr kêt nẽ. Kê apkati mãn. Ãm jarãhã pix mã mãn mẽ ate tanhmã amnhĩ nhĩpêx tota kukamã ajamaxpẽr. Tĩrtũm kot mẽ pahpumunh mex o pa rãhã kênã. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Nhũm Jejus arĩ mẽ kãm kapẽr nẽ mẽ kãm: —Nẽ kêr ka mẽ atỳx ri amnhĩ krã hkôt tanhmã akwỳjê hõ kot amnhĩ tomnuj to hã harẽnh kêt nẽ. Kot kaj mẽ ã harẽnh anẽ nhũm Tĩrtũm ja hã mẽ apumu nẽ mẽ kajaja ã mẽ ajarẽnh anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Na hte tanhmã mẽ pahte axpẽn nhĩpêx to hã mẽ pahpumunh kôt tanhmã mẽ panhĩpêx to. ");
INSERT INTO apnNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","5","Jakamã kwa kêr ka mẽ mẽhõ kot tanhmã amnhĩ tomnuj to hã omu hãmri nẽ hã kãm kapẽr tokyx anhỹr kêt nẽ. Akumrẽx ate tanhmã amnhĩ tomnuj to hã amnhĩ pumu nẽ hkaga hãmri nẽ rĩ kormã ate mẽmoj tã omunh xwỳnhta wỳr tẽ nẽ hã tanhmã kãm akapẽr to. Kêr ka mẽ ã amnhĩ nhĩpêx anhỹr o ri apa. —Nẽ xà koja mẽ akwỳjê hõ tanhmã amnhĩ tomnuj to grire. Ka ate amnhĩ tomnuj tỳx o hakrenh tã ã kot amnhĩ nhĩpêx anhỹr ã omu nẽ hã kãm akir nhũm amã ja mex nẽ nà? Nà koja amã ja mex kêt nẽ. Kot ka akumrẽx ate tanhmã amnhĩ tomnuj tota kaga hãmri nẽ rĩ kormã anhĩõ tanhmã kot amnhĩ tomnuj to grireta nê kãm akapẽr nhũm ja amã mex nẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","—Nẽ xà na htem mẽ apkur xà mex jamỳ nẽ rop mã kurẽ? Nà na htem anhỹr kêt nẽ. Ja pyrà nẽ kêr ka mẽ kot Tĩrtũm kaga xwỳnhjê mã kapẽr jarẽnh o ri apa hkêt nẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","11","Nhũm Jejus arĩ mẽ kãm kapẽr nẽ mẽ kãm: —Nẽ xà kot we akraja kãm prãm nẽ tep ã awỳ ka axtem nẽ kagã hõ py nẽ kãm agõ? Rỳ nhũm krãhyre gre hã awỳ ka axtem nẽ makre hõ py nẽ kãm agõ? Nà na ka htem ã mẽ hipêx anhỹr kêt. Na ka htem kot mẽmoj tã mẽ awỳr xà hkôt kãm mẽmoj gõ. Mẽ ate amnhĩ tomnuj tã na ka htem akrajê ho mex o ri apa. Tã kaxkwa kamã Tĩrtũmja na hte mẽ ato mex o mẽ ate mẽ akrajê ho mex jakrenh. Kãm mẽ ajapê htỳx kôt na hte mẽ amã mẽmoj mex nhõr o pa. Jakamã kot ka mẽ mẽmoj tã awỳ nhũm mẽ ama nẽ mẽ ate mẽmoj tã hwỳr xàta kôt amã kugõ. Ãm xatã mẽ ate hã axàhwỳr o ri apaja nhũm mẽ amã hprãm xwỳnhta gõ. Ãm mẽmoj tã hwỳr rãhã ho ri apa nhũm mẽ ama nẽ mẽ amã mẽmoj tanhmã hipêx to. Te ho mẽhõ kãm tep xành nẽ teprẽnhxà hpyr nẽ xatã gôx kãm rẽnh o ãm pyrà nẽ xatã mẽmoj tã awỳ. Hãmri nhũm mẽ ama nẽ mẽ amã hprãm xwỳnhta gõ. Te tep kanhêr xwỳnhta jatã kot tep kanhêr pyràk. Jao mẽ amã mẽmoj prãm xwỳnhta gõ. ");
INSERT INTO apnNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","—Nẽ mẽ piitã mẽ kot tãm mẽ anhĩpêxja na mẽ amã hprãm. Tã kêr ka mẽ amnhĩ pyrà nẽ tãm mẽ piitã mẽ hipêx o ri apa. Mẽ kot tãm mẽ anhĩpêx kêt tã kêr ka mẽ axàmnhĩx mẽ kêp anhõxỳ hkêt nẽ tãm mẽ hipêx. Kot kaj mẽ ã axpẽn nhĩpêx anẽ nẽ finat Mojes mẽ Tĩrtũm nhỹ hã mẽ kapẽr o mẽ pa xwỳnhjê xujarẽnh xà hkôt axpẽn nhĩpêx mex o ri apa. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","14","Nhũm Jejus arĩ mẽ kãm kapẽr nẽ mẽ kãm: —Tĩrtũm kapẽrja mẽ kêp hihtỳx jakamã na htem ohtô nẽ hkôt amnhĩ xunhwỳr kêt nẽ. Na htem ãm hpỹnhre nẽ hkôt amnhĩ xunhwỳ nẽ hkôt amnhĩ nhĩpêx. Jakamã te Tĩrtũm nhõ krĩ hwỳr pry grireta ã hpỹnhre nẽ pa pyràk. No nhũm Satanasti hkôt mẽ kot amnhĩ xunhwỳr xwỳnhjaja na htem Satanasti kôt pix mã tanhmã amnhĩ tomnuj to hprãm. Mẽ kãm mex jakamã nhũm mẽ amnhĩ nhĩpêx o te pry krepak rax ã axpẽn kôt mẽ ohtô nẽ pa pyràk o amnhĩ nhĩpêx. Axtem kuwy hwỳr pry krepakja nõr tã nhũm mẽ htỳx kuwyja wỳr amnhĩ to pa. Jakamã Tĩrtũm kapẽrja mẽ apê hihtỳx tã kêr ka mẽ mãmrĩ hkôt amnhĩ xunhwỳ. Jao Tĩrtũm nhõ krĩ hwỳr pry grireta ã mãn apa. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Nhũm Jejus arĩ mẽ kãm kapẽr nẽ mẽ kãm: —E kwa mẽ o kora. Mẽ akwỳjaja kot kêp Tĩrtũm nhỹ hã kapẽr jarẽnh xwỳnh ã amnhĩ jarẽnh tã na htem ja hã amnhĩ to hêx. Nhũm htem kãm mẽ kapẽr mar prãm nẽ. Te mẽ kapẽr mex pyràk tã no nhũm htem ãm mẽ kãm amnhĩ to hêx pix o ri mẽ hkôt pa. Mẽ kot mar nẽ axtem nẽ Tĩrtũm kapẽr kwỳm tanhmã amnhĩ nhĩpêx to kaxyw nhũm htem hêx rom tanhmã mẽ kãm kapẽr to. Jakamã kwa mẽ o kora. Mẽ axkãm ajamak rom nẽ amnhĩ nê mẽ omunh mex nẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Kêr ka aprĩ hã mẽ piitã mẽ kot tanhmã amnhĩ nhĩpêx to hã mẽ omu nẽ rĩ kormã tanhmã mẽ harẽnh to. Mẽ hamaxpẽr punuj xwỳnhjaja kêp Tĩrtũm nhỹ hã kapẽr jarẽnh xwỳnh kêt. No koja mẽ tãm hamaxpẽr nẽ tãm amnhĩ nhĩpêx ka ja hã mẽ omu nẽ mẽ kêp Tĩrtũm nhỹ hã kapẽr jarẽnh xwỳnh ã mẽ omunh kurê kumrẽx. Na htem hprĩ hã mẽ kot tanhmã amnhĩ nhĩpêx to ho pa hã mẽ omu nẽ rĩ kormã tanhmã mẽ harẽnh to. ");
INSERT INTO apnNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Na htem hamaxpẽr punuj hãmri nẽ hkôt tanhmã amnhĩ tomnuj to. Nom koja mẽhõ hamaxpẽr mex nẽ hãmri nẽ hkôt tãm amnhĩ nhĩpêx mex o pa. ");
INSERT INTO apnNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Na htem tanhmã hamaxpẽr to xà hkôt tanhmã amnhĩ nhĩpêx to ho pa. ");
INSERT INTO apnNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","—Nẽ koja mẽhõ õ pĩ hpàr ô hkêt japêr nhũm tee ri omu hãmri nẽ krãhta nẽ kuwym kumẽ. Ja pyrà nẽ koja mẽhõ tanhmã amnhĩ tomnuj to ho pa nhũm Tĩrtũm tee ri ja hã omu hãmri nẽ ã kot amnhĩ nhĩpêx anhỹr o paja mỳrapê kuwy hwỳr kumẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Jakamã kot kaj mẽ tanhmã mẽ kot amnhĩ nhĩpêx to ho pa hã akwỳjê pumu nẽ ra aprĩ hã tanhmã mẽ kute hã mẽ omunh kurê kumrẽx. Mẽ kêp Tĩrtũm nhỹ hã kapẽr xwỳnh ã mẽ omu rỳ mẽ kêp hkwỳm ri kapẽr xwỳnh ã mẽ omu. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","23","Nhũm Jejus arĩ mẽ kãm kapẽr nẽ mẽ kãm: —Nẽ Inhĩpêêxà Tĩrtũm mẽ wa inhõ krĩja wỳr koja mẽ piitã gjêx kêt nẽ. Ãm mẽ kot kapẽr kôt amnhĩ nhĩpêx o mẽ pa xwỳnh pixjaja koja mẽ nhỹrmã ma hwỳr agjê. Na hte mẽ hkwỳjaja ixto “Pahihti” anhỹr ã ijarẽnh tã no ãm ixkôt ri amnhĩ nhĩpêx kêt nẽ. Jakamã koja mẽ nhỹrmã wa inhõ krĩ hwỳr àpir kêt nẽ. Kot paj nhỹrmã mẽ piitã mẽ htĩr ri tanhmã mẽ kot amnhĩ nhĩpêx to ho pa hã mẽ omunh xà hkôt tanhmã mẽ harẽnh to. Mẽ mex ã mẽ hkwỳjê jarẽ nẽ mẽ kot amnhĩ tomnuj ã mẽ hkwỳjê jarẽ. Hãmri nhũm mẽ hkwỳ kot ixkôt amnhĩ nhĩpêx o pa hkêt xwỳnhjaja kuwyta wỳr ma pa pymaj tee ri amnhĩ kukamã hamaxpẽr hãmri nẽ tanhmã inhmã amnhĩ jarẽnh to nẽ inhmã: “Kwa Jejus. Xà ate ixpumunh kêt? Na pa pre amnepêm ixtĩr ri pikap ixpare ri anhỹ hã aa mẽ kot mẽmoj pumunh kêt kwỳ ho anhỹr rax nẽ. Nẽ ixkwỳjê nê mẽkarõmnuti jano nẽ mẽ kãm akapẽr jarẽnh o ri ixpa. Kwa xà ate ja hã ixpumunh kêt?” Anhỹr o inhmã amnhĩ jarẽ. —Nom mẽ htĩr ri ã mẽ kot amnhĩ nhĩpêx anhỹr o pa htã ixkapẽr kôt amnhĩ nhĩpêx kêt jakamã kot paj mẽ kuma nẽ ãm mẽ kuma nẽ amnhĩ nê mẽ hano nẽ mẽ kãm: “Tk kwa mẽ ma mra. Mẽ apê ixkwỳ hkêt. Mẽ ate ixkôt amnhĩ nhĩpêx o apare hã. Ãm mẽ ate amnhĩ tomnuj xwỳnh na ka mẽ. E mẽ ma kuwy hwỳr amrar kurê kumrẽx.” Anhỹr o kot paj amnhĩ nê mẽ hano. Hãmri nhũm mẽ kot ixkôt amnhĩ nhĩpêx o mẽ pa xwỳnh pixjaja ma Tĩrtũm mẽ wa inhõ krĩ hwỳr gjêx pa. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Nhũm Jejus arĩ mẽ kãm kapẽr nẽ mẽ kãm: —E kot paj mẽ amã awjarẽ ka mẽ ixujarẽnh ma. Nà mẽ kot ixkapẽr mar nẽ hkôt amnhĩ nhĩpêx o mẽ pa xwỳnhjaja te mẽ kot ixujarẽnh ja pyràk. Mẽ kot amnhĩ nhĩpêx o te mẽhõ kot amnhĩ kukamã hamaxpẽr mex nẽ aptỳx kãm amnhĩm õrkwỹ nhĩpêxja pyràk. ");
INSERT INTO apnNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Koja mẽhõ aptỳx kãm amnhĩm hipêx nhũm mẽmo arĩgro hã na wrỳk rax nẽ gô htàm rax nẽ hanhi no nhũm arĩ ãm tỳx nẽ xa. Tã kot kaj mẽ ixkôt amnhĩ nhĩpêx o ri apa hã kot kaj mẽ te ixkre ja pyràk. Jao amex nẽ ajamakêtkati nẽ ri apa. Te ho gô htàm kot ixkre janhir nhũm arĩ ãm tỳxta pyràk. ");
INSERT INTO apnNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","27","—No mẽ kot ixkapẽr mar nẽ ãm mar xwỳnhjaja. Te mẽ kot mẽhõ kot amnhĩ kukamã hamaxpẽr mex kêt nẽ htỳx mõr nẽ gô mỳri gyw rerek kãm amnhĩm õrkwỹ nhĩpêx pyràk. Koja mẽmo arĩgro hã õrkwỹ hã kôk xàpêr tỳx nẽ na wrỳk rax nẽ. Nẽ gô htàm nẽ hanhi nẽ kêp grành pa. Jakamã koja mẽhõ ixkôt amnhĩ nhĩpêx kêt nẽ te kot ã kot amnhĩ nhĩpêx anhỹr xwỳnhta pyràk. Jakamã kwa mẽ ixkapẽr mar tỳx nẽ hkôt amnhĩ nhĩpêx rãhã ho ri apa. Te mẽhõ aptỳx kãm õrkwỹ xãm xwỳnhta pyràk. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Nhũm pre Jejusja ã mẽ kãm ujarẽnh ry anẽ nhũm mẽ amnhĩ jaêr pê kot tanhmã mẽ ahkre htoja mar o hkrĩ. ");
INSERT INTO apnNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Hãmri nẽ axpẽn mã harẽnh o: —Hêxta waa nẽ. Ãm hãmri na ã mẽ pamã kapẽr anẽ. àhpumunh tỳx kôt na hte ãm hãmri tanhmã mẽ pamã ujarẽnh to. Pẽr ãm Tĩrtũm kapẽr tũm o mẽ ahkre xwỳnhjê kurom àhpumunh tỳx kumrẽx. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Tã nhũm Jejus mẽ kãm kapẽr pa hãmri nẽ hixêt prêêta rũm akupỹn wrỳ nẽ ma tẽ nhũm mẽ ohtô nẽ ma hkôt mra. ");
INSERT INTO apnNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Hãmri nhũm mẽhõ my hkà nhy hkro xàpêr o pa xwỳnhja omu nẽ hwỳr tẽ. Hãmri nẽ kutã hkõnkrã ho tẽm nẽ hipô nẽ nhỹ nẽ amnhĩ to kuwỳ nẽ kãm: —Pa Pahihti. E ot pa awỳr amnhĩ to tẽ. Akupỹm ate mẽ ixto mex kaxyw axàhpumunh tỳx jakamã kot ka amã akupỹm ixto mex prãm nẽ mãmrĩ ixto mex. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Hãmri nhũm Jejus kuma nẽ hkà punuti hã ĩhkra xi. Amnhĩ kamã kahak kêt nẽ hã ĩhkra xi nẽ kãm: —Nà kot paj ato mex. E akupỹm akà mex. Anẽ. Hãmri nhũm hkà akupỹm mex kurê kumrẽx. ");
INSERT INTO apnNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Hãmri nhũm Jejus kãm: —E kêr ka amnhĩ tã mẽ kãm tanhmã ijarẽnh to hkêt rãhã ma patre hwỳr tẽ kê akupỹm akà mex ã apumu. Hãmri ka hpãnhã amnepêm finat Mojes kot mẽ ate akupỹm amex ã Tĩrtũm mã tanhmã amnhĩ nhĩpêx to hã karõta ka kãm ho anẽ. Kê mẽ piitã akupỹm akà mex ã apumu. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Tã nhũm Jejus ma krĩ pê Kapanaũ hwỳr mõ. Hãmri nẽ hwỳr pôj nhũm Rõm nhõ xwỳnh pê pôristi krãhtũmja omu nẽ hwỳr tẽ. Kêp Ijaew kêt tã hwỳr tẽ. Na pre kãm àpênh xwỳnh kêp à htỳx nẽ nõ nhũm omu nẽ tee ri hkukamã hamaxpẽr. Hãmri nẽ Jejus ra õ krĩ hwỳr hpôx ã omu nẽ hwỳr tẽ nẽ kãm harẽ nẽ kãm: ");
INSERT INTO apnNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","—Pa Jejus? E ot pa awỳr tẽ. Inhmã àpênh xwỳnhja na ixpê à htỳx nẽ. Ra ĩ kamã htyk pa nẽ nõ. O mũj inhõrkwỹ kamã nõ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Nhũm Jejus kuma nẽ kãm: —Tỳ? Tôe. Nà pa ma akôt tẽ nẽ akupỹm amã ho mex. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","9","Hãmri nhũm tee ri kuma nẽ kãm: —Kwa akĩnhã ixpê Ijaew kêt jakamã ixte amnhĩ kuk ã ixpijaàm. Ãm ja rũm mãn akapẽr pix o akupỹm inhmã ho mex nà? Ixpê mẽ hkrãhtũm na pa hte inhõ pôristi mã mẽmoj tã karõ nhũm mẽ inhmar xà hkôt inhmã mẽmoj tanhmã ho. Na pa hte mẽ kãm: “E mẽ ma mra nẽ ã amnhĩ nhĩpêx anẽ.” Anẽ nhũm htem inhma nẽ ma mrar kurê kumrẽx. Rỳ pa mẽ kãm: “E mẽ amnẽ ixwỳr mra nẽ ã amnhĩ nhĩpêx anẽ.” Anẽ nhũm mẽ inhma nẽ ixwỳr mra. No kêt ixrom axàhpumunh tỳx kôt na ka hte mẽ àja mã akapẽr nhũm ama nẽ mẽ kêp hapôx nẽ ma mrar kurê kumrẽx. Jakamã kwa ãm ja rũm akapẽr pix o akupỹm inhmã ho mex nà? Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Hãmri nhũm Jejus amnhĩ jaêr pê kot kãm ã kapẽr anhỹrta ma nẽ hkĩnh nẽ. Hãmri nẽ hã hkôt ri mẽ mõr xwỳnhjê mã kãm: —Kwa xà na ka mẽmyja kapẽr ma? Mẽ pahkĩnh ã kêp Ijaew kêt tã mẽ arom amnhĩ kaxyw inhmã hamaxpẽr tỳx nẽ. Aa mẽ atõ uràk nẽ ã amnhĩ kaxyw inhmã ajamaxpẽr tỳx anhỹr kêt tã nhũm mẽ arom kãm àpênh xwỳnh kaxyw ã inhmã hamaxpẽr tỳx anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Nà koja nhỹrmã mẽ hkwỳjaja kêp Ijaew kêt tã ohtô nẽ pika piitã kurũm ma Tĩrtũm mẽ wa inhõ krĩ hwỳr api nẽ hwỳr agjê. Nẽ wa ixkuri wa inhõ krĩ kamã Ijaew pàr krax pê Apraãw nẽ Ijak nẽ Jako mẽ pimrààtã pa ho pa. Mẽ kêp Ijaew kêt tã mẽ ĩhkô hã apkur mex o hkrĩ nhũm Tĩrtũm mẽ ho mex rax o pa. ");
INSERT INTO apnNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","No pẽr mẽ apê Ijaew kwỳjaja kot kaj mẽ hkôt hwỳr agjêx kêt nẽ. Tĩrtũm kãm hwỳr mẽ agjêx prãm tã ka mẽ axtem nẽ hkaga. Jakamã kot kaj mẽ ma kamàt kô xihtỳx rax wỳr ajapêx nẽ mẽ kêp awry rax nẽ mẽ kot amnhĩ xà htỳx kamã hamak tũm xàta kamã apa ho apa. Hãmri nẽ tee ri mẽ ixwỳr agjêx prãm kaprỳ nẽ akaprĩ xàj mur nẽ amnhĩ kamã agryk tỳx nẽ. No ãm tee ri amnhĩ kamã agryk kaprỳ. Mẽ ate Tĩrtũm kapẽr kaga nẽ hkôt amnhĩ xunhwỳr kêt jakamã kot kaj mẽ nhỹrmã ã amnhĩ nhĩpêx anẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Nhũm pre ã Jejusja mẽ kãm kapẽr anẽ. Hãmri nẽ pôristi krãhtũmta mã kãm: —E mãmrĩ ma akupỹm tẽ nẽ amã àpênh xwỳnhta pumu. Ra ate kaxyw inhmã ajamaxpẽr tỳx jakamã na pa ra akupỹm amã ho mex. E akupỹm tẽ nẽ omu. Anhỹr o kãm kapẽr rôm nhũm ra akupỹm kãm mex kurê kumrẽx. ");
INSERT INTO apnNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Tã nhũm Jejus ma Simãw Pêtre nhõrkwỹ hwỳr tẽ nẽ hwỳr axà. Nhũm Simãw Pêtre xupãnhgêx ra à nẽ hkà kagro htỳx nẽ nõ. ");
INSERT INTO apnNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Hãmri nhũm Jejus hwỳr axà nẽ omu nẽ ĩhkra hã kupy nhũm hkà hakry nẽ akupỹm hihtỳx kurê kumrẽx. Jakamã kànhmã nhỹ nẽ mẽ kãm mẽõ hã àpênh o ri mra. ");
INSERT INTO apnNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Tã nhũm ra awjakry. Ra kamàtre ho mõ nhũm mẽ piitã Jejus wỳr mẽ à xwỳnhjê ho mra. Nẽ mẽkarõmnuti kot mẽ hwỳr gjêx xwỳnhjaja nhũm mẽ hwỳr mẽ o mra. Hãmri nhũm mẽ omu nẽ akupỹm mẽ piitã mẽ ho mex. Mẽ à xwỳnhjê ho mex nẽ mẽ hkwỳjê nê mẽkarõmnuti jano. Ãm kapẽr pix o mẽ nê mẽ hano nhũm mẽ kêp hapôj nẽ ma hapêx. ");
INSERT INTO apnNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Na pre ra Tĩrtũm nhỹ hã kapẽr xwỳnh finat Ijaisja ã amnhĩ nhĩpêx anhỹrja kukamã amnepêm mẽ kãm harẽnh o: Tĩrtũm kot mẽ pahwỳr mẽnh mã xwỳnhja koja nhỹrmã wrỳ nẽ mẽ panê mẽ paxà piitã rênh pa nẽ akupỹm mẽ pahto mex pa. Anẽ. Na pre ã finat Ijaisja Jejus kukamã harẽnh anẽ. Tã nhũm wrỳ nẽ kot harẽnh xà hkôt ã amnhĩ nhĩpêx anhỹr o pa. ");
INSERT INTO apnNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Tã nhũm Jejus amnhĩ pu hã rĩt nẽ tee ri hwỳr mẽ mrar xwỳnhjê pumu hãmri nẽ hkôt mẽ pa ho mẽ pa xwỳnhjê mã kãm: —E ma pu mẽ pàr mã agjê nẽ ma xarmã mõ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Hãmri nhũm mẽ nojarêt rôm nhũm Tĩrtũm kapẽr tũm o mẽ ahkre xwỳnhjê hõ Jejus wỳr tẽ nẽ kãm: —Pa mẽ ijahkre xwỳnh? E pa ma akôt ri ixpa ho ixpa nà. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Hãmri nhũm kuma nẽ kãm: —Ko ka mã. Kam nẽ rĩ ma ixkôt ri apa. Nom kêr ka inhmar kumrẽx. Xore na hte pika hkre kamã hikwỹ. Nẽ kuwênhre pĩ nhĩmõk ã hikwỹ. No pa ixpê Tĩrtũm kot mẽ awỳr inhmẽnh xwỳnh tã mry hkĩnhã inhõrkwỹ hkêt. Na pa hte amarĩ nhãm krĩ hwỳr ixpa nẽ nhãm hõ hwỳr ixpa. Tã xà kot ka ixpyrà nẽ ã amnhĩ nhĩpêx anhỹr o ri apa nà? Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Hãmri nhũm pãnhã hõja hwỳr tẽ. Ra mẽ kot hkôt amnhĩ xunhwỳr xwỳnhjê hõja hwỳr tẽ nẽ kãm: —Pa Pahihti. E pa amã amnhĩ jarẽ ka inhma. Kot paj ma akôt ixpa ho ixpa no ãm kormã. Koja nhỹrmã inhĩpêêxà tanhmã amnhĩ to nẽ ty mãn. Pa haxà hãmri nẽ rĩ kormã ma akôt ixpa ho ixpa. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Hãmri nhũm kuma nẽ kãm: —Kwa nà ri ã ajamaxpẽr anhỹr kêt nẽ. Ma ixkôt apa ho apa kurê kumrẽx. Kê mẽmoj inhnê ano kupyr rỳ apê àmnàr kêt nẽ. Kwãr mẽ htĩr tũm nẽ mẽ pa hkêt mã xwỳnhjaja mãn axwakre kamã amã anhĩpêêxà jamãr o pa nẽ haxà. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Tã nhũm mẽ ra xarmã nojarêt nhũm Jejus mẽ hkôt mẽ pa ho mẽ pa xwỳnhjaja pàr wỳr agjê hãmri nẽ himô raxja ã ma xarmã mõ. ");
INSERT INTO apnNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Hãmri nhũm Jejus ra õtxwa nẽ ra gõr nẽ nõ. Puh nhũm naja hkoko ho mõ nẽ kôk xàpêr tỳx kumrẽx. Nhũm gô kànhmã harĩ nẽ axpẽn tak tỳx nẽ. Xatã axpẽn tak nẽ pàr kre kamã axkapĩ nhũm ra àr o mõ. Hãmri nhũm mẽ tee ri omu nẽ kãm ma htỳx kumrẽx. Nẽ tee ri amnhĩ nhĩpêx. No nhũm Jejusja htỳx gõr nẽ nõ. ");
INSERT INTO apnNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Hãmri nhũm mẽ hwỳr hprõt nẽ kumra nẽ kãm: —Kwa Pahihti. Kot puj mẽ jarãhã pahtyk pa. Kwa tokyx kànhmã nhỹ nẽ ri tanhmã amnhĩ nhĩpêx to wehe. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Hãmri nhũm hkrãkato nẽ kànhmã nhỹ nẽ kôk mã kapẽr nẽ kãm: —E kwa hãmri anhĩkrê. Anẽ. Puh nhũm hpinhkrênh pa nhũm gôja tãm nõr kurê kumrẽx. Hãmri nhũm Jejusja hkôt mẽ pa ho mẽ pa xwỳnhjê hwỳr apkjê nẽ mẽ kãm: —Hêxta waa nẽ. Kwa pẽr ãm kormã te mẽ ate amnhĩ kaxyw Tĩrtũm mẽ wa inhmã ajamaxpẽr tỳx kêt pyràk. Hã na ka mẽ amã ma xàj tee ri amnhĩ kukamã ajamaxpẽr. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Hãmri nhũm mẽ amnhĩ jaêr pê ã kot amnhĩ nhĩpêx anhỹrja ã omu nẽ tee ri hamaxpẽr nẽ axpẽn pumunh pê omunh o kuhê. Hãmri nẽ axpẽn mã: —Kokỹỹ. Pẽr Jejus kêp mẽ panhĩõ hkêt. Mẽ pahtõ kot pu we te kot amnhĩ nhĩpêx pyrà nẽ kôk mã pakapẽr nhũm hpinhkrênh kurê kumrẽx? Nà Jejusja mẽ pakurom àhpumunh tỳx o àhpumunh tỳx. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Tã nhũm mẽ ra himô rax pê Garirejja ã rê nẽ pika pê Geras wỳr pôj nẽ kamã mõ. Hãmri nhũm ra mẽhõ myja wa hamẽxkrut nẽ mẽ kutã tẽ. Ra mẽkarõmnuti kot hamẽ wa hwỳr gjêx xwỳnhja wa. Mẽkarõmnuti xohtô kot tanhmã wa ho jakamã nhũm wa oprê htỳx nẽ hihtỳx rax nẽ wa pa. Jakamã nhũm mẽ piitã kãm wa uma nẽ amnhĩ nê mẽ htykjê jagjênh xà hã kẽn kre kaêx kãm wa kumẽ nhũm wa kamã pa ho pa. Jakamã nhũm wa Jejus kutã tẽ nẽ amnhĩ wỳr omu hãmri nẽ amnhĩ nê tanhmã kãm kapẽr to. Nom mẽkarõmnuti nhỹ hã àmra kamã kãm kapẽr nẽ kãm: ");
INSERT INTO apnNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","—Pa Tĩrtũm Kra Jejus? Mo kaxyw na ka mẽ ixwỳr tẽ? Kwa tanhmã mẽ ixto hkêt nẽ. Ate tanhmã mẽ ixtomnu hto hã arĩgrota kormã katoore hã. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Nhũm ra krĩ nhõ xwỳnhjê hkrit hagrô ohtô nẽ ri mẽ hpum pa. ");
INSERT INTO apnNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Nhũm mẽkarõmnuti mẽ omu hãmri nẽ amnhĩ to Jejus wỳ nẽ kãm: —Kwa kot ka jahti wa nê mẽ ijapôx japêr nẽ mẽ kot amnhĩ xà htỳx kamã hamak tũm xàta wỳr mẽ ixrẽnh kêt nẽ. Hagrô hkwỳ mũj wỳr mãn mẽ ixrẽ pa mẽ hpãnhã hwỳr mãn hagjê nà? Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Hãmri nhũm mẽ kuma nẽ mẽ kãm: —Tôe mẽ tãm mẽ hwỳr mãn mra. Anẽ. Hãmri nhũm mẽ kuma nẽ myta wa kêp hapôj nẽ hagrô hwỳr mrar kurê kumrẽx nẽ hpãnhã kãm gjêx pa. Hãmri nhũm hagrôta mẽkarõmnuti pymaj amỹra nẽ ma hprõt nẽ himô hã hixêt prêk ã axpum rôrôk nẽ gôx kãm mrõ nẽ pikaprãr pa. ");
INSERT INTO apnNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Hãmri nhũm hagrô jamãr o ri mẽ pa xwỳnhjaja tee ri omu hãmri nẽ ma akupỹm krĩm hprõt nẽ mẽ kãm awjarẽ. Nẽ myta wa akupỹm tãm hkrã hã harẽnh o hprõt. ");
INSERT INTO apnNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Hãmri nhũm krĩ nhõ xwỳnhjaja tee ri mẽ hkrit jarẽnh ma nẽ ma piitã Jejus wỳr mra nẽ hkaxpa. Hãmri nẽ amnhĩ nê kãm: —E kwa mẽ ma amrar kurê kumrẽx. Anẽ. Hãmri nhũm mẽ kuma nẽ awjanã nẽ ma akupỹm pan rê. ");
INSERT INTO apnNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Nhũm Jejus mẽ hkôt mẽ pa ho mẽ pa xwỳnhjaja awjanã nẽ ma akupỹm pàr wỳr mra nẽ gjêx pa nẽ akupỹm xarmã rê nẽ akupỹm Jejus nhõ krĩ hwỳr mõ. ");
INSERT INTO apnNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Hãmri nẽ hwỳr pôj nhũm krĩ nhõ xwỳnh kwỳjaja mẽ omu nẽ ĩ kamã htyk xwỳnhja mỳ nẽ Jejus wỳr o tẽ. Nõr xà kamã nõr rãhã nhũm mẽ hã hije nẽ kumỳ nẽ hwỳr o tẽ. Hãmri nhũm amnhĩ tã mẽ omu. Ra mẽ kot hkràmnhwỳta kaxyw kãm hamaxpẽr tỳx ã mẽ omu nẽ ĩ kamã htyk xwỳnhta mã kapẽr nẽ kãm: —Pa? Kwa tee ri amnhĩ kukamã ajamaxpẽr kêt nẽ. Na pa ra apê tanhmã ate amnhĩ tomnuj to ho ijapêx pa. Kot paj axte kãm ijamaxpẽr kêt nẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Hãmri nhũm Tĩrtũm kapẽr tũm o mẽ ahkre xwỳnhjaja tee ri ã kot kãm kapẽr anhỹrja ã kuma nẽ axpẽn mã: —Tk. Kwa mẽhõ myti mũj kêp Tĩrtũm kêt tã te ri kot amnhĩ nhĩpêx pyràk ã amnhĩ nhĩpêx. Tĩrtũm pix na kot mẽ nê mẽ kot amnhĩ tomnuj o hapêx xwỳnh. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Hãmri nhũm Jejus amnhĩ tã mẽ kuma nẽ mẽ kãm: —Kwa mẽ ã ajamaxpẽr anhỹr kêt nẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Ixte mẽ nê mẽ kot amnhĩ tomnuj o ijapêx par ã amnhĩ jarẽnh tã mẽ ate ja kôt ixpumunh kêt jakamã na ka mẽ ja kaxyw ixkôt ajamaxpẽr kêt nẽ. Nom kot paj mẽ anoo mã akupỹm ĩ kamã htyk xwỳnhta o mex ka mẽ apiitã hã ixpumu hãmri nẽ ixkôt ajamaxpẽr kurê kumrẽx. Ixpê Tĩrtũm kot mẽ awỳr inhmẽnh xwỳnhta na pa. Ixte mẽ anê mẽ ate amnhĩ tomnuj rênh kaxyw na pre mẽ awỳr inhmẽ pa mẽ awỳr wrỳ. ");
INSERT INTO apnNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Tã mẽ ate ja hã ixpumunh kaxyw kot paj mẽ anoo mã ja ho mex. Anhỹr o mẽ kãm amnhĩ jarẽ hãmri nẽ ĩ kamã htyk xwỳnhta mã kãm: —E kànhmã xa nẽ anõr xàta py nẽ ma akupỹm anhõrkwỹ hwỳr tẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Puh nhũm kànhmã ãm kurê kumrẽx nẽ nõr xà py nẽ mẽ noo mã kato nẽ ma akupỹm õrkwỹ hwỳr tẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Hãmri nhũm mẽ piitã no hapôx rũnh nẽ omunh o kuhê nẽ kamã no pyma htỳx nẽ. Nẽ tee ri omu nẽ axpẽn mã: —Kokỹỹ. Kwa aa mẽ pahte ã mẽhõ kot amnhĩ nhĩpêx anhỹr ã omunh kêt tã jarãhã ja pumu. Anhỹr o Jejus jarẽ hãmri nẽ ỹ hã Tĩrtũm mã mex o mex ã harẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Tã nhũm Jejus mẽ kêp kato nẽ hkôt mẽ pa xwỳnhjê mẽ nhũm mẽ ma mõ. Hãmri nẽ pa ixpê Matêwre ixpumu. Ixte Rõm kãm mẽ ho amnhĩptàr xwỳnh mã krĩ nhõ xwỳnhjê pê kàxpore hkwỳ jamỳnh xwỳnh na pa pre. Nom mẽ kot ho tewẽn kryre htã ixte amnhĩm hkwỳ ho ixàrĩk prãm xàj na pa pre hte mẽ kãm ho rũnh nẽ harẽ. Jakamã nhũm mẽ piitã kãm ixkĩnh kêt nẽ. Tã pa pre mẽ kêp kàxpore jamỳnh xà hã ixkre kamã mẽ kêp hamỳnh o nhỹ nhũm Jejus mẽ hkwỳjaja ijãnh mra nẽ ixpumu nẽ amnhĩ kôt ixwỳ nẽ inhmã: —Pa? E axàpênhta kaga nẽ hpãnhã amnẽ mẽ ixkôt mãn tẽ nẽ ixkôt mãn ri apa ho apa. Anẽ. Hãmri pa kuma nẽ ixàpênh kaga nẽ ma hkôt tẽ. Nẽ hpãnhã hkôt ixpa ho ixpa. ");
INSERT INTO apnNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Hãmri nẽ mẽmo arĩgro hã amnhĩ nhõrkwỹ hwỳr Jejus nẽ hkôt mẽ pa ho pa xwỳnhjaja mẽ ixkràmnhwỳ hkwỳjê hwỳ. Nhũm mẽ piitã mra nẽ inhõrkwỹ hwỳr agjê nẽ ixkutã apkur o hkrĩ. Nẽ ixpyrà nẽ Rõm nhõ pahi mã mẽ kêp kàxpore hkwỳ jamỳnh xwỳnh kwỳ haxwỳja ixwỳr mra nẽ mẽ ixkutã apkur o hkrĩ. ");
INSERT INTO apnNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Hãmri nhũm Parijew nhõ xwỳnhjaja mra nẽ inhõrkwỹ kapem mẽ ixàpkur ã mẽ ixpumu. Nẽ tee ri mẽ ixkaêx ã Jejus pumu hãmri nẽ hkôt mẽ pa ho mẽ pa xwỳnhjê hwỳr agjê nẽ mẽ ixtã mẽ kãm akir nẽ mẽ kãm: —Kwa mẽ kot jajê kutã apkur kêt tã mẽ akrãhtũmja axtem nẽ mẽ kutã apkur o nhỹ. Kwa nà mẽ kot amnhĩ tomnuj xwỳnh kênã. Jejus kot amnhĩ to mex ronhỹx mẽ kutã apkur kêt nẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Hãmri nhũm Jejus amnhĩ tã ã mẽ kapẽr anhỹrja ma nẽ mẽ kãm: —Tk. Nà ixte tãm mẽ unhwỳr kaxyw na pa mẽ kutã ixàpkur o nhỹ. Xà na hte tôtôja mẽ mex xwỳnhjê hwỳr mra nẽ mẽ hkane? Nà ãm mẽ à xwỳnhjê pix wỳr na hte mra nẽ tanhmã mẽ hkane hto. Ra mẽ ate ja pumunh mex. Tã ja pyrà nẽ na pa pre mẽ kot amnhĩ to mex xwỳnhjê hwỳr ixwrỳk kêt nẽ. Mẽ kot amnhĩ tomnuj xwỳnhjê pix wỳr na pa pre wrỳ. Ixte tãm mẽ unhwỳr kaxyw mẽ hwỳr wrỳ nẽ ã jajê kutã ixàpkur o inhỹr anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Ga mẽ ma mra nẽ Tĩrtũm kapẽr ã kagà htũm kot ja jarẽnhja kamã harẽ nẽ ama. Harẽnh kot: Na ka htem inhmã tanhmã amnhĩ jarẽnh to kaxyw hãmri nẽ inhmã mẽmoj gõ nẽ tanhmã ixto mex to. Nom kêr ka mẽ ãm ja pix ho anhỹr kêt nẽ. Mẽ mããnẽn mẽ piitã tanhmã mẽ ho mex to ho ri apa. Anẽ. —Ã Tĩrtũm kapẽr ã kagà htũm kot ja jarẽnh kot anhỹr. Tã ja pyrà nẽ na pa pre mẽ kot amnhĩ tomnuj xwỳnhjê hwỳr wrỳ nẽ mẽ kamã ixukaprĩ ho ixpa. Mẽ kot amnhĩ tomnuj kaga nẽ hpãnhã tãm amnhĩ nhĩpêx kaxyw na pa pre ã mẽ hwỳr ixwrỳk anẽ. Tã ka mẽ ri atỳx amnhĩ krã hkôt ã ixto akapẽr anẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Tã nhũm Juãw Paxis kôt mẽ pa xwỳnhjaja Jejus wỳr mra nẽ mẽmoj tã hkukja nẽ kãm: —Pa? E ot pa mẽ awỳr mra. Kwa mẽ inhmã mẽmoj jarẽ. Na pa htem tõhã Parijew nhõ xwỳnhjê pyrà nẽ ixàpkur kêt kãm Tĩrtũm mã amnhĩ jarẽ. Tã nom akôt mẽ pa ho mẽ pa xwỳnhjaja na htem àmnhĩx apkur o pa kamã kãm amnhĩ jarẽnh o pa. Kwa mo na htem mẽ ixpyrà nẽ tõhã apkur kêt kamã kãm amnhĩ jarẽnh kêt nẽ? Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Hãmri nhũm mẽ kuma nẽ mẽ kãm: —Nà mo kaxyw kot kêt mẽ apkur kêt rãhã kãm amnhĩ jarẽ? Mẽ hkaprĩre hã. Mẽ kot ixkôt pa ho pa hã amnhĩ pumunh jakamã na htem hkĩnh nẽ ixkôt pa. Kormã ixte mẽ kamã ixpa kênã kot kêt mẽ apkur kêt rãhã Tĩrtũm mã tanhmã amnhĩ jarẽnh to. Xà na htem hkràmnhwỳ hã hkĩnh kaxyw hã akuprõ nẽ hkaprĩ nẽ apkur kêt o kamàt nẽ mỳr o hkrĩ? Nà na htem anhỹr kêt nẽ. Na htem hã akuprõ nẽ hkĩnh nẽ hã apkur rũnh nẽ. Ja pyrà nẽ na hte ixkôt mẽ pa ho mẽ pa xwỳnhjaja ixkôt kormã àmnhĩx hkĩnh nẽ apkati mẽ apkur o pa. Nom koja mẽ kãm ixkurê xwỳnhjaja nhỹrmã tanhmã ixto hãmri nhũm mẽ hkaprĩ htỳx nẽ rĩ kormã tõhã apkur kêt rãhã Tĩrtũm mã amnhĩ jarẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Nhũm Jejus mẽ piitã mẽ kãm kapẽr nẽ mẽ kãm: —Mẽ kot amnhĩ tomnuj xwỳnhjaja ra mẽ kot amnhĩ nhĩpêx tũm o amnhĩ pyràk jakamã na htem tanhmã mẽ kot amnhĩ nhĩpêx nyw tota kaga. ");
INSERT INTO apnNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Tã ixte amnhĩ nhĩpêx nywja te kot mẽ ate amnhĩ nhĩpêx tũm pyràk kêt jakamã na ka htem ixkapẽr ma nẽ ãm ama. Kwa mẽ inhma nẽ mẽ ate amnhĩ nhĩpêx tũmja gryk ã ixkaga hkêt nẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Nhũm pre ã Jejus mẽ kãm kapẽr anhỹr o xa. Rôm nhũm mẽõ pahihtija tẽ nẽ mar o xa. Hãmri nẽ hamaxpẽr o: —Kokỹỹ. Jejusja ãm hãmri kêp pahi maati kumrẽx. Hã na ri ã kapẽr mex anẽ. E pa hwỳr tẽ nẽ ixkrare ho kuwỳ. Anẽ. Hãmri nẽ hwỳr tẽ nẽ kutã hkõnkrã ho nhỹ nẽ kãm: —Pa akupỹm mẽ ixto mex xwỳnh? E ot pa awỳr tẽ. Kwa ma ixkôt tẽ nẽ inhmã ixkra nire pumu nẽ tanhmã inhmã ho kê akupỹm inhmã htĩr. Na ham ixpê ty pa kaxyw amã ijamaxpẽr nẽ man awỳr tẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Hãmri nhũm kuma nẽ kãm: —Tôe. Nà kot paj ma akôt tẽ. Anẽ. Hãmri nẽ ma hkôt tẽ. Mẽ ixpê hkôt ixpa ho ixpa xwỳnhjê mẽ pa mẽ ma hkôt mõ. ");
INSERT INTO apnNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","21","Nhũm mẽhõ ni kamrô rãhã ho pa xwỳnhja ma mẽ ixkôt tẽ. Na pre hte hkamrô hkryre rãhã ho pa hã amgrà pê 12 nẽ tee ri kãm amnhĩ mex prãm o pa. Jakamã Jejus jarẽnh ma nẽ amnhĩ kaxyw kãm hamaxpẽr kurê kumrẽx nẽ hamaxpẽr o: —Ma pa kop ma hwỳr tẽ nẽ kêp ê nhĩrê pix kupênh tã akupỹm inhmex japêr. Anẽ. Hãmri nẽ ma mẽ ohtôjê kaêx kôt hwỳr tẽ. Nẽ katut kôt tẽ nẽ kêp ê nhĩrê kupê. ");
INSERT INTO apnNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Hãmri nhũm Jejus ho hakẽx nẽ amnhĩ tã omu nẽ kãm: —Pa? Kwa tee ri amnhĩ kukamã ajamaxpẽr kêt nẽ. Ate amnhĩ kaxyw inhmã ajamaxpẽr tỳx jakamã na ka ra akupỹm amex. E mãmrĩ ajamakêtkati nẽ ri apa. Anẽ. Hãmri nhũm akupỹm mex nẽ hkĩnh tỳx nẽ ma akupỹm tẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Hãmri pa mẽ ma htyk xwỳnh nhĩpêêxà hkôt mra nẽ õrkwỹ hwỳr agjê nẽ mẽ pikuprõnh xwỳnhjê pumu. Nhũm mẽ ra mẽ hã htu rax nẽ. Nẽ omũj ri kaprĩ xàj pifti kakôr o hkrĩ nẽ omũj ri mur. Kàx pê mur nẽ amnhĩ tak o hkrĩ. ");
INSERT INTO apnNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Hãmri nhũm Jejus mẽ hwỳr axà nẽ mẽ omu. Nẽ ra kot my hkrata htyk ã omunh tã kuri mẽ mỳr o mẽ hkrĩ xwỳnhjê mã kapẽr nẽ mẽ kãm ãm õt nẽ nõr ã harẽ nẽ mẽ kãm: —Pa? Kwa mon ka mẽ ri akaprĩ nẽ amỳr o akrĩ? E mẽ ma mra. Na wa hkrata wa kêp htyk kêt nẽ. Na ãm gõr nẽ nõ. Anẽ. Hãmri nhũm mẽ kot ra htyk ã omunh mex jakamã kuma nẽ ãm kuma. Nhũm mẽ hkwỳja axtem nẽ ri axpẽn mã hã hpẽr o pikẽnh o hkrĩ. ");
INSERT INTO apnNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Hãmri nhũm kapôt mã mẽ hano nhũm mẽ hapôj nẽ kapôt ã kuhê. Hãmri nhũm Jejusja htyk xwỳnhta wỳr axà nẽ hpa hã kupy nẽ kànhmã ãm nhũm akupỹm htĩr nẽ kànhmã ãm kurê kumrẽx. ");
INSERT INTO apnNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Hãmri nhũm mẽ piitã akupỹm htĩr kãm omu nẽ ma ri krĩ piitã hkôt ri mẽ kãm harẽnh o hprõt. ");
INSERT INTO apnNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Tã nhũm Jejus kato nẽ ma tẽ. Pa mẽ hkôt ixpa ho ixpa xwỳnhjaja ma hkôt mõ. Hãmri nhũm wa myja wa hamẽxkrut. Hamẽ wa nohkre xwỳnh wa Jejus jarẽnh ma nẽ hã ajêt nẽ hkôt rôrôk o mõ. Nẽ xatã amnhĩ to hwỳr o hkôt rôrôk o mõ nẽ kãm: —Pa Jejus? E Tĩrtũm kot mẽ ixkaxyw axãm jakamã kwa wa ixpumu nẽ wa ixkamã axukaprĩ kêt wehe. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Hãmri nhũm wa kuma nẽ wa hkukamã nhỹri ixkrem axà nhũm wa hkôt axà nẽ xa nhũm wa omu nẽ wa kãm: —Pa? E xàn ka wa ra amnhĩ kaxyw inhmã ajamaxpẽr tỳx nẽ nà? Anẽ. Hãmri nhũm wa kãm: —Tỳ. Wa ixte amnhĩ kaxyw amã ijamaxpẽr tỳx kênã. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Hãmri nhũm wa kuma nẽ hamẽ wa no hã ĩhkra xi nẽ wa kãm: —Tôe. Nà war ate tanhmã amnhĩ kaxyw inhmã ajamaxpẽr to xà hkôt kot paj war anhĩpêx. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Hãmri nhũm wa akupỹm rĩt mex kurê kumrẽx. Hãmri nẽ akupỹm kato nẽ ma htẽm kaxyw nhũm wa kãm: —E kêr ka wa nhãm mẽ kãm ixte war ato mex ã ijarẽnh kêt nẽ. Ãm kwarĩ ho kwarĩ. ");
INSERT INTO apnNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Anhỹr tã no nhũm wa kuma nẽ ãm kuma nẽ wa ma tẽ nẽ krĩ pu hã mẽ piitã mẽ kãm ri war amnhĩ tã harẽnh o mra. ");
INSERT INTO apnNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Tã nhũm Jejus ma axte nhỹhỹm mẽ ixto mõ. Hãmri nhũm mẽhõ my mẽkarõmnuti kot hwỳr àr nẽ tanhmã ho nhũm kapẽr kêt nẽ pa xwỳnhja nhũm mẽ Jejus wỳr o tẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Hãmri nhũm omu nẽ nê mẽkarõmnuti jano nẽ kãm: —E kêp akato nẽ ma tẽ. Anẽ. Hãmri nhũm kuma nẽ kurũm kato nhũm akupỹm kapẽr mex kurê kumrẽx. Hãmri nhũm mẽ kot hã omunh xwỳnhjaja tee ri kot mẽkarõmnuti janor ã omu nẽ kamã no pyma nẽ. Nẽ axpẽn mã: —Kokỹỹ. Aa mẽ pahte ã mẽhõ kot anhỹr pumunh kêt kumrẽx tã na pu mẽ jarãhã ja pumu. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Nom nhũm mẽ hkwỳ pê Parijew nhõ xwỳnhjaja axtem nẽ hã mẽ kãm kapẽr o: —Tk. Kot amnhĩ krã hkôt mẽ hanor kêt kênã. Mẽkarõmnuti nhõ pahi nhỹ hã kot mẽ nê mẽ hanor kênã. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Tã nhũm Jejusja krĩ ho ohtô nẽ hkôt ri mẽ kãm Tĩrtũm kapẽr jarẽnh o pa. Pa mẽ hkôt ixpa. Na pre hte nhỹri krĩ hwỳr pôj nẽ mẽ kot Tĩrtũm kapẽr o mẽ ahkre xà hã ixkre hwỳr mra nẽ hwỳr agjê nẽ mẽ pikuprõnh xwỳnhjê jahkre. Nẽ mẽ kãm: —E mẽ inhma. Tĩrtũm kãm mẽ apiitã mẽ ato hkra hprãm. Jakamã kwa mẽ ate amnhĩ tomnuj kaga hprãm xàj hkôt amnhĩ xunhwỳ nẽ kapẽr kôt amnhĩ nhĩpêx. Jao amnhĩ nhĩpêx nyw o amnhĩ nhĩpêx o ri apa. Anhỹr o mẽ kãm kapẽr. Hãmri nẽ ahpỹnhã ri tanhmã mẽ à kute xwỳnhjê ho mex. Nhũm mẽ ohtô nẽ hkôt mar o pa. ");
INSERT INTO apnNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Hãmri nhũm mẽ omu nẽ kãm mẽ hkaprĩ nẽ. Na prem tee ri amnhĩ kukamã hamaxpẽr o pa jao ra hkaprĩ nẽ. Nhũm Jejus ja hã mẽ omu nẽ hamaxpẽr o: —Hêxta waa nẽ. Na mẽ mex kêt nẽ pa. Te mẽ kêp ôwêhti jamãr xwỳnh kêt kot amnhĩ nhĩpêx pyràk o htỳx ri pa. Mẽhõ koja kãm mẽ hkaprĩ nẽ tanhmã mẽ ho mex to ho pa? Anẽ. Hãmri nẽ mẽ kamã ukaprĩ nẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Hãmri nẽ mẽ hã mẽ ixpê hkôt ixpa ho ixpa xwỳnhjê mã kapẽr nẽ mẽ inhmã: —Nà na mẽ kormã ohtô rax nẽ Tĩrtũm kapẽr mar kêt nẽ. No ãm kormã mẽ ate mẽ kãm kapẽr jarẽnh o apa kaxyw mẽ agrêre. Te pur rax kãm ra harôj kamrêk par nẽ ãm tã no ãm kaxyw hikẽnh xwỳnhjaja grêre pyràk. ");
INSERT INTO apnNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Jakamã kwa mẽ ho Tĩrtũm wỳ kê axte mẽ kaxyw mẽ akwỳjê rê kê mẽ apyrà nẽ ma mẽ hkôt ri mẽ kãm kapẽr jarẽnh o pa. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","4","Tã nhũm Jejusja hkôt mẽ ixpa ho mẽ ixpa xwỳnhjê ho 12 nẽ mẽ ixrê. Mẽ ixte ma krĩ piitã hwỳr inhmrar nẽ ỹ hã mẽ ahkre nẽ tanhmã mẽ à kute xwỳnhjê ho mex o ixpa kaxyw. Nẽ ỹ hã mẽ nê mẽkarõmnuti janor o ixpa kaxyw nhũm mẽ ixrê. Na pre mẽ ixto 12 nẽ mẽ ixrê. Ã mẽ inhĩxi kot anhỹr. Pêtre kumrẽx na pre kuta. Hixi hõ pê Simãw. Nẽ hkôt htõ Andreja ta. Nẽ hkôt Jepetew kra Xiakreja ta. Nẽ hkôt Xiakre htõ Juãwja ta. Nẽ hkôt Firiptija ta. Nẽ hkôt Patoromewja ta. Nẽ hkôt Tomasja ta. Nẽ hkôt pa ixpê Matêwre nhũm pre mẽ hkôt ixta. Ixpê pahi nhỹ hã kãm mẽ kêp ixujamỳnh xwỳnh tã nhũm pre jajê hkôt ixta. Nẽ ixkôt Apew kra Xiakre hõja ta. Nẽ hkôt Tatewja ta. Nẽ hkôt Simãw Jeroxja ta. Nẽ hkôt Jut Kariotja ta. Kormã kot mẽ kãm Jejus kurê xwỳnhjê nhĩhkram õr mã nhũm Jejus kot amnhĩ kukamã omunh mex tã mẽ hkôt amnhĩ kaxyw kuta. Ã mẽ ixte ỹ hã mẽ ahkre o ixpa kaxyw mẽ ixrênh xwỳnhjê nhĩxi kot anhỹr. ");
INSERT INTO apnNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Hãmri nhũm Jejus mẽ ixrênh pa nẽ ma mẽ hwỳr mẽ ixrẽnh kaxyw tanhmã mẽ inhmã kapẽr to nẽ mẽ inhmã: —E. Kêr ka mẽ ma mẽ piitã mẽ kãm ri ijarẽnh o apa. No ãm kormã mẽ kêp Ijaew kêt xwỳnhjê nhõ pika hwỳr apa hkêt nẽ. Rỳ mẽ kêp Samar nhõ krĩ hwỳr ka mẽ apa hkêt nẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Ãm mẽ pahpê Ijaew nhõ krĩ kôt pix mã mãn ri apa. Mẽ kot tee ri amnhĩ kukamã hamaxpẽr o pa jakamã te mẽ kêp ôwêhti pikunor nẽ htỳx ri mex kêt nẽ pa pyràk. ");
INSERT INTO apnNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Jakamã kêr ka mẽ ma mẽ hwỳr apa nẽ ã mẽ hkôt ri mẽ kãm akapẽr o apa anẽ nẽ mẽ kãm: “E kot kaj mẽ ate amnhĩ tomnuj kaga nẽ Tĩrtũm kôt amnhĩ xunhwỳ hãmri nhũm amnhĩ tã mẽ apumu nẽ mẽ ato hkra. Jakamã e kwa mẽ tokyx hkôt amnhĩ xunhwỳ.” Anẽ. Kêr ka mẽ ã mẽ kãm akapẽr anhỹr o ri mẽ hkôt apa. ");
INSERT INTO apnNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Hãmri nẽ akupỹm mẽ à xwỳnhjê ho mex o ri apa. Nẽ mẽ htyk xwỳnhjaja ka mẽ akupỹm mẽ ho htĩr o ri apa. Nẽ mẽ hkànhy rũnh xwỳnhjaja ka mẽ akupỹm mẽ ho mex o ri apa. Nẽ mẽ kamã mẽkarõmnuti xwỳnhjaja ka mẽ nê mẽ hano. E kêr ka mẽ ã inhỹ hã mẽ ho mex o ri apa anẽ. Na pa amarĩ tanhmã mẽ ato ka mẽ inhmã amnhĩrer kêt tã ra mẽ ate tanhmã mẽ ho mex to mã tãm. Tã kêr ka mẽ amnhĩ xwar amarĩ ri mẽ ho mex o ri mẽ hkôt apa. No ri mẽ ho mex pãnhã kàxpore hã axàhwỳr kêt nẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","10","—Nẽ kêr ka mẽ ma mẽ hwỳr apa kaxyw anojarêt hãmri nẽ amnhĩ kôt akukrêx rũnh o apa hkêt nẽ. Ãm anhỹ kamã mẽ hwỳr apa. Nẽ akàxpore ho rax nẽ ho apa hkêt nẽ. Rỳ akawà kamã axê hkwỳ rỳ aparkà hõ xàr nẽ ho amõr kêt nẽ. Rỳ kô hõ py nẽ ri ho apa hkêt nẽ. Ãm anhõ mrykà pix jamỳ nẽ ma ho apa. Kêr kê mẽ ate Tĩrtũm kapẽr o mẽ ahkre nẽ mẽ ho mex xwỳnhjaja mãn amnhĩ pãnhã mẽ amã mẽ axàpkur xà gõ ka mẽ kutã axàpkur o ri mẽ hkôt apa. ");
INSERT INTO apnNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","—Nẽ kêr ka mẽ nhỹri krĩ hwỳr ajapôj nẽ kamã mẽhõ kot amnhĩ to mex xwỳnh japêr. Nẽ ra omu hãmri nẽ kuri mãn pôj nẽ hkôt apikamẽnh tãmtã kurũm akupỹm ajapôj nẽ ma nhãm krĩ hõ hwỳr mra. ");
INSERT INTO apnNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","—Nẽ kêr ka mẽ mẽhõ nhõrkwỹ hwỳr pôj nẽ mẽ kãm: “E ot pa mẽ awỳr mõ. Nà koja Tĩrtũmja mẽ ato mex nẽ.” Anhỹr o mẽ kãm akapẽr. ");
INSERT INTO apnNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Koja mẽ ama nẽ amnhĩ wỳr awỳ ka mẽ amnhĩ tã mẽ omu nẽ mẽ kãm: “E koja Tĩrtũm mẽ ato mex nẽ ka mẽ ajamakêtkati nẽ ri axàmnhĩx apa.” Anhỹr o mẽ kãm akapẽr. No koja mẽ amnhĩ nhõrkwỹ nê mẽ akurê nhũm Tĩrtũm ja hã mẽ omu nẽ mẽ ho mex kêt nẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","—Nẽ koja nhỹri krĩ hõ kamã mẽ akaga nẽ akapẽr mar kêt japêr. Ka mẽ tee ri amnhĩ tã mẽ kamã ama hãmri nẽ tokyx mẽ kurũm ajapôj nẽ ma akupỹm apa. Nẽ akupỹm anojarêt nẽ mẽ noo mã akuhê nẽ amnhĩ par ã awjagrô kapĩ nẽ ma apa. Mẽ kot Tĩrtũm kaga hã amnhĩ pumunh kaxyw ka mẽ ã mẽ noo mã amnhĩ nhĩpêx anẽ. Hãmri nẽ ma nhỹhỹm hpãnhã apa. ");
INSERT INTO apnNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Koja nhỹrmã Tĩrtũm mẽ kot amnhĩ tomnuj mỳrapê tanhmã mẽ ho. Na pre ã Sotõ mẽ Komo nhõ xwỳnhjê nhĩpêx anẽ. Na prem amnhĩ tomnuj tỳx nẽ nhũm Tĩrtũm tee ri ja hã mẽ omu nẽ tanhmã hã mẽ homnuj tỳx to. Tã jar mẽ kãm ixkapẽr mar prãm kêt nẽ mẽ kot ixkaga xwỳnhjaja koja ja hã mẽ omu nẽ kot Sotõ mẽ Komo nhõ xwỳnhjê nhĩpêx o mẽ hipêx. No ãm tanhmã mẽ ho htỳx o mẽ hakre. Anẽ. Nhũm pre Jejus ã mẽ inhmã mẽ ixàpênh ã karõ anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Nhũm Jejus arĩ kot mẽ ixrênh xwỳnhjê mã kapẽr nẽ mẽ inhmã: —E kot paj ma mẽ hwỳr mẽ arẽ. Ma mẽ ate Tĩrtũm kapẽr o mẽ ahkre ho ri mẽ hkôt apa kaxyw. Jakamã kot kaj mẽ te ôwêhti kot mry xoprê hwỳr amnhĩ to mrar nhũm kot hkwỳ hpar pyràk o amnhĩ nhĩpêx. Koja mẽ hkwỳjaja mẽ ate mẽ ahkre ma nhũm ja mẽ kêp omnuj nẽ nhũm mẽ hã tanhmã mẽ anhĩpêx to. Tã nom kêr ka mẽ tee ri amnhĩ kukamã ajamaxpẽr nẽ amã mẽ uma hkêt nẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","—E kwa mẽ o kora. Kêr ka mẽ ma mẽ hwỳr mra nẽ amnhĩ nê mẽ htãnopxar o ri apa. Koja mẽ hkwỳjaja mẽ akapẽr ma nẽ kêp mẽ aprãm nõkati. Nẽ mẽ apynê nẽ ma mẽ utàr xwỳnhjê hwỳr mẽ ato mra nẽ mẽ kãm tanhmã mẽ ato hêx to. Hãmri nhũm mẽ mar xà hkôt mẽ atak. Tĩrtũm kapẽr o mẽ ahkre xà hã ixkre kamã koja mẽ ã mẽ anhĩpêx anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","—Nẽ koja mẽ ixtã tanhmã mẽ ato kaxyw mẽ apynê nẽ ma mẽ õ pahi hwỳr mẽ ato mra nẽ tanhmã kãm mẽ ato hêx to. Nom kwãr mẽ mamrĩ ã mẽ anhĩpêx anẽ. Koja mẽ ato anẽ ka mẽ kutã akrĩ nẽ mẽ kãm Tĩrtũm kapẽr jarẽ. Ijaewjê mã nẽ mẽ kêp Ijaew kêt xwỳnhjê mã. ");
INSERT INTO apnNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","—Nẽ koja mẽ ma mẽ õ pahi hwỳr mẽ ato mra nẽ ã mẽ anhĩpêx anẽ nom kêr ka mẽ tee ri tanhmã mẽ kãm amnhĩ jarẽnh to hkukamã ajamaxpẽr kêt nẽ. Koja Tĩrtũm Karõ tãm tanhmã mẽ akrã hto ka mẽ ô ri mẽ kãm akapẽr mex nẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Nẽ kot kaj mẽ amnhĩ krã hkôt ri mẽ kãm akapẽr kêt nẽ. Tĩrtũm Karõ nhỹ hã kot kaj mẽ ô ri mẽ kãm tanhmã axujarẽnh to. ");
INSERT INTO apnNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","22","—Nẽ koja mẽ hkwỳjaja ixtã mẽ akamã gryk nẽ. Nẽ mẽ atã àmnênh pix o pa. Nẽ mẽ kot mẽ apar kaxyw mẽ akwỳjê hã amỹnê. Koja mẽ anhĩpêêxà hkwỳjaja mẽ apê mẽ hkra hã amỹnê. Nhũm mẽ akra hkwỳjaja mẽ apê mẽ hipêêxà hã amỹnê. Nhũm mẽ atõ hkwỳjaja mẽ apê mẽ htõ hã amỹnê. Nhũm mẽ akatorxàjaja mẽ atã amỹnê. Hãmri nhũm mẽ apa. No ãm kwãr mẽ mãmrĩ ã mẽ anhĩpêx anẽ. Ã mẽ kot mẽ anhĩpêx anhỹr tã kêr ka mẽ tee ri amnhĩ kukamã ajamaxpẽr pê ixkaga hkêt nẽ. Mẽ ãm amnhĩ to htỳx rãhã ty. Hãmri nẽ akaxwỳnhja ma Tĩrtũm mẽ wa inhõ krĩ hwỳr axàpir kurê kumrẽx nẽ wa ixkuri akupỹm amex nẽ atĩr tũm nẽ apa ho apa. ");
INSERT INTO apnNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","—Nẽ koja mẽ nhỹri krĩ hkwỳ kamã ixtã tanhmã mẽ anhĩpêx hto ka mẽ mãmrĩ mẽ kurũm ajapôj nẽ ma nhỹhỹm krĩ hõ hwỳr apa. Nẽ hpãnhã kamã mẽ kãm ri ijarẽnh o mẽ hkôt apa. Kot kaj mẽ kormã Ijaewjê nhõ krĩ piitã hwỳr apa hkêt ri pa akupỹn mẽ awỳr wrỳ. Kwa kêr ka mẽ ixkapẽr mã ajamaxpẽr tỳx rãhã ri apa. ");
INSERT INTO apnNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","25","—Mẽ ate ixkôt apa ho apa xwỳnh na ka mẽ. No pa na ixpê mẽ ajahkre xwỳnh. Jakamã koja mẽ kot tanhmã inhĩpêx to ho mããnẽn mẽ anhĩpêx. Koja mẽ nhỹrmã tanhmã inhĩpêx to nẽ mã ixkôt mẽ ato anẽ nẽ. Mẽ pahte amnhĩ nhĩpêxja kot axpẽn pyràk. Jakamã koja mẽ ixpê Satanasti hã ijarẽ nẽ mããnẽn tanhmã mẽ ajarẽnh punuj to ho pa. Mẽ pahte amnhĩ nhĩpêxja kot axpẽn pyràk jakamã koja mẽ panhĩpêx o axpẽn pyràk. ");
INSERT INTO apnNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","—Tã nom kêr ka mẽ tee ri amnhĩ kukamã ajamaxpẽr pê amã mẽ uma ho apa hkêt nẽ. Na htem piitã axpẽn pê tanhmã hamaxpẽr punuj to ho hpimxur o pa nom tee ri ho pimxur prãm kaprỳ. Koja nhỹrmã mẽ hamaxpẽr piitã amnhĩrĩt pa. Nẽ mẽmoj piitã ra hpimxur mex tã koja nhỹrmã amnhĩrĩt par kumrẽx. ");
INSERT INTO apnNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","—Nẽ koja nhỹrmã mẽ piitã ixte amnhĩ nhĩpêx kôt ixpumu. Na pa ra mẽ hkàx ã mẽ amã ixujarẽnh rax nẽ. Tã kêr ka mẽ ma mẽ piitã mẽ kãm harẽnh o ri apa. Nẽ ra ixte mẽ hkàx ã ahte ixte mẽ amã mẽmoj jarẽnhta ka mẽ hpãnhã ma mẽ kãm harẽnh o ri apa kê mẽ apyrà nẽ harẽnh ma. ");
INSERT INTO apnNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","—E kêr ka mẽ amã mẽ kot tanhmã mẽ ato mã xwỳnhjê pyma ho apa hkêt nẽ. Mẽ kot mẽ apar mã tã koja mẽ ãm mẽ akrãhkà pix pa nom tanhmã mẽ akaxwỳnh to hkêt nẽ. Tĩrtũmja tapxipix na hte mẽ hkrãhkà nẽ mẽ hkaxwỳnh mẽ ho pimrààtã kot amnhĩ xà htỳx kamã hamak tũm xàta wỳr mẽ rẽnh pumunh. Tã kot hwỳr mẽ arẽnh pymaj kêr ka mẽ amã kapẽr kwỳm ri tanhmã amnhĩ nhĩpêx to pyma ho ri apa. ");
INSERT INTO apnNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","31","—Nẽ Tĩrtũm kot mẽ pahto hapêx par pumunh tã mããnẽn kot mẽ pajamãr mex. Mãn ka htem kuwênhre pumu. Na hte Tĩrtũm kuwênhre jamãr mex o pa. Mẽ piitã mẽ kot ãm omunh tã nom nhũm Tĩrtũm mẽ kurom hamãr mex pê mẽ htãnopxar rãhã ho pa. Tã kãm mẽ pajapê htỳx o kot kuwênhre jakrenh jakamã kwa mẽ tee ri amnhĩ kukamã ajamaxpẽr o ri akaprĩ nẽ apa hkêt nẽ. Koja Tĩrtũm mẽ pahtãnopxar rãhã ho pa. Kot mẽ panhĩ piitã omunh par. Nẽ ahpỹnhã tanhmã mẽ pahkrã hkĩ kute hkôt mẽ pahpumunh par. Tã kot mẽ pahtãnopxar rãhã jakamã mo kaxyw kot kaj kêt mẽ ri amã mẽ uma ho apa? Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Nhũm Jejus arĩ kot mẽ hwỳr mẽ ixrẽnh xwỳnhjê mã kapẽr nẽ mẽ inhmã: —E kwa mẽ mãmrĩ akwỳjê mã mẽ apê ixkwỳ hã amnhĩ jarẽnh o ri apa nẽ amã mẽ uma xàj tee ri amnhĩ nhĩpêx kêt nẽ. Kot kaj mẽ kãm ra ate ixkôt amnhĩ xunhwỳr ã amnhĩ jarẽ. Pa ja hã mẽ apumu hãmri nẽ mẽ apyrà nẽ kaxkwa kamã Inhĩpêêxà mã ra ate ixkôt amnhĩ xunhwỳr ã mẽ ajarẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Nom kot kaj mẽ kot ixtã tanhmã mẽ ato pymaj apê ixkwỳ hã amnhĩ jarẽnh kêt nẽ. Pa ja hã mẽ apumu hãmri nẽ nhỹrmã amnhĩ xwar Inhĩpêêxà mã mẽ apê ixkwỳ hkêt ã mẽ ajarẽ. Jakamã kwa mẽ mãmrĩ mẽ kãm apê ixkwỳ hã amnhĩ jarẽnh o ri mẽ hkôt apa kê mẽ ama nẽ amnhĩ kaxyw inhmã hamaxpẽr japêr. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Nhũm Jejus arĩ kot mẽ hwỳr mẽ ixrẽnh xwỳnhjê mã kapẽr nẽ mẽ inhmã: —Ra mẽ awỳr ixwrỳk tã koja mẽ piitã ixkukwak ri hamakêtkati nẽ àmnhĩx ri pa hkêt nẽ. Kormã. Koja mẽ akwỳjaja ixkapẽr ma nẽ mẽ apyrà nẽ amnhĩ kaxyw ixkôt hamaxpẽr. Nhũm mẽ akwỳjaja axtem nẽ kuma nẽ ãm kuma. Hãmri nẽ ixtã tanhmã mẽ atomnuj to ho pa ka mẽ amnhĩ xà htỳx kamã ajamak o ri apa. ");
INSERT INTO apnNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","—Koja mẽ akrajaja ixtã mẽ apê mẽ hipêêxà nẽ mẽ katorxà kutã amnhĩ xunhwỳ. Nhũm mẽ wỳjjaja ixtã mẽ umregêxjê kutã amnhĩ xunhwỳ. ");
INSERT INTO apnNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","—Koja mẽ ã mẽ akwỳjaja ixtã mẽ akutã amnhĩ xunhwỳr anẽ. Mẽ anhõrkwỹ kamã mẽ akukwak ri pa htã ixtã mẽ akutã amnhĩ xunhwỳ. ");
INSERT INTO apnNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","—Nẽ mẽ amã mẽ anhĩpêêxà nẽ mẽ akatorxà japêê. Nẽ mẽ amã mẽ akrajê japêê. Tã nom kot kaj mẽ gryk ã ixkôt amnhĩ nhĩpêx mex o ri apa hkêt hãmri nẽ apê ixkwỳ mã tãm kêt. ");
INSERT INTO apnNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Rỳ nhũm mẽ nhỹrmã ixtã mẽ apar kaxyw ka mẽ tee ri amnhĩ kukamã ajamaxpẽr nẽ mẽ kot mẽ apar pymaj ixkaga hã kot kaj apê ixkwỳ mã tãm kêt nẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Koja mẽ nhỹrmã ixpĩ pa mẽ anê ty. Tã mẽ ate ixkôt amnhĩ nhĩpêx o apa xwỳnhjaja. Koja mẽ ixpyrà nẽ ixtã mẽ apar mã tã kwa kêr ka mẽ amã atyk pymaj ixkaga hkêt nẽ. Kwãr mẽ mãmrĩ tanhmã ixtã mẽ ato. Kot kaj mẽ nhỹrmã Tĩrtũm mẽ wa ixri axte amnhĩ xà kamã ajamak kêt nẽ atĩr tũm nẽ amex rãhã apa ho apa. Nom kot kaj mẽ jar amã amex nẽ apa hprãm xàj ixkaga hãmri nẽ nhỹrmã wa ixri atĩr tũm nẽ apa ho apa hkêt nẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Nhũm Jejus arĩ kot mẽ hwỳr mẽ ixrẽnh xwỳnhjê mã kapẽr nẽ mẽ inhmã: —E koja mẽhõ nhỹri mẽ apumu nẽ mẽ apê ixkra hã tanhmã mẽ ato mex to nẽ te pa kot ixto mex pyràk. Nẽ kot kaj mẽ tanhmã pa ixto mex to nẽ te Tĩrtũm o mex pyràk. ");
INSERT INTO apnNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","—Nẽ kot ka mẽ nhỹri Tĩrtũm nhỹ hã mẽ kãm kapẽr jarẽnh xwỳnhjê hõ tanhmã ho mex to nhũm Tĩrtũm hã apumu nẽ nhỹrmã hã ato mex nẽ. Rỳ ka mẽ mẽhõ kot Tĩrtũm kôt amnhĩ nhĩpêx xwỳnhjê hõ pumu nẽ tanhmã ho mex to. Nhũm Tĩrtũm hã apumu nẽ mããnẽn hã ato mex nẽ. Te ate mẽhõ ho mexta pyrà nẽ mããnẽn ato mex nẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Nhũm mẽhõ nhỹri mẽ kot ixkôt kormã amnhĩ xãm nyw nẽ kormã àhpumunh tohtuj anhỹr xwỳnhjê hõ pumu. Nẽ kãm kôr ã omu nẽ hamaxpẽr o: “Kwa Jejus kôt ri pa xwỳnh mũj kãm kôr. Kormã kot Jejus kôt amnhĩ xãm tỳx kêt tã kêp hkwỳỳ. E kot paj kãm gô hkwỳ kê ho ixkõ.” Anẽ hãmri nẽ kãm hkwỳ nhũm ho ixkõ. Hãmri nhũm Tĩrtũm hã omu nhũm kot kãm gô pix nhõr nhũm kot ho hkõm tã nhũm ja hã ho mex rax nẽ. Anẽ. Nhũm pre ã Jejus kot mẽ hwỳr mẽ ixrẽnh xwỳnhjê mã kapẽr ry rax anẽ. Mẽ ixpê 12jê mã ã kapẽr anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Tã nhũm Jejus ra kot mẽ hwỳr mẽ ixrẽnh xwỳnhjê mã kapẽr pa hãmri nẽ kato nẽ ma krĩ pu hã krĩ hkwỳjê hkôt ri pa. Nẽ mẽ kãm Tĩrtũm kapẽr jarẽnh o ri mẽ hkôt pa. ");
INSERT INTO apnNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Nhũm Juãw Paxisja arĩ kêp prês nẽ mẽ hagjênh xà kamã hkrĩ. Nhũm pre hte hkôt mẽ pa ho mẽ pa xwỳnhjaja hwỳr mra nẽ kãm Jejus kot tanhmã amnhĩ nhĩpêx to ho pa hã harẽ. Hãmri nhũm harẽnh ma nẽ tee ri hkukamã hamaxpẽr. Hãmri nẽ hkôt mẽ pa xwỳnh wa ho axkrut nẽ wa kuta ");
INSERT INTO apnNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","nẽ hwỳr wa kumẽ nẽ wa kãm: —Kwa wa ma Jejus wỳr tẽ nẽ hkukja nẽ kãm: “Xà ka na pre Tĩrtũm mẽ ixwỳr amẽ nà? Xà kormã axtem mẽhõ na pa mẽ ri hamãr o ri ixpa?” Anhỹr o hkukja hãmri nẽ tanhmã kot amnhĩ jarẽnh to hã ama nẽ man akupỹn ixwỳr tẽ nẽ inhmã harẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Hãmri nhũm wa kuma nẽ ma hwỳr tẽ. Nhũm Jejus kormã tanhmã mẽ à kute xwỳnhjê ho mex o xa. Mẽ nohkre xwỳnhjaja nhũm akupỹm mẽ ho mex. Nẽ mẽkarõmnuti kot mẽ hwỳr gjêx xwỳnhjaja nhũm mẽ nê mẽ hanor o ãm rãhã nhũm Juãw kôt wa pa xwỳnhta wa hwỳr tẽn pôj. Nẽ kormã mẽ hã omunh o wa xa. Hãmri nẽ kãm Juãw Paxis kapẽr jarẽ nhũm wa kuma nẽ wa kãm: —Tỳ. Nà ãm hãmri na ja hã ijarẽ. Ixpê mẽ ate ixkamã ajamak o apa xwỳnhta na pa. Na ka wa kam ã ixte amnhĩ nhĩpêx anhỹr ã ixpumu. Jakamã wa ma akupỹm tẽ nẽ aprĩ hã kãm ijarẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Na pa hte akupỹm mẽ nohkre xwỳnhjê ho mex. Nẽ mẽ hkànhy xwỳnhjaja pa akupỹm mẽ hkà ho mex. Nẽ mẽ hyk o mẽ pa xwỳnhjaja pa akupỹm mẽ hte ho mex. Nẽ mẽ htyk xwỳnhjaja pa akupỹm mẽ ho mẽ htĩr. Nẽ mẽ kêp amrakati nẽ ri mẽ pa xwỳnhjaja pa mẽ kãm mẽmoj mex jarẽnh o ri mẽ hkôt ixpa. Ã na pa hte mẽ hipêx anhỹr o ri ixpa. Jakamã e wa ma akupỹm Juãw wỳr tẽ nẽ ã kãm ijarẽnh anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Kê ijarẽnh ma nẽ ixkôt hamaxpẽr tỳx nẽ tee ri ixkukamã hamaxpẽr kêt nẽ. Koja ã amnhĩ nhĩpêx anẽ nẽ hamakêtkati nẽ ri pa. E wa tokyx ma akupỹm tẽ nẽ kãm ã ijarẽnh anẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","9","Nhũm pre ã Jejus Juãw Paxis kôt wa pa ho wa pa xwỳnhja wa kãm amnhĩ jarẽnh anẽ nẽ akupỹm hwỳr wa kumẽ nhũm wa ma akupỹm hwỳr tẽ. Hãmri nhũm Jejus mẽ kot mar o kuhê xwỳnhjê mã tanhmã Juãw Paxisja jarẽnh to nẽ mẽ kãm: —Na ka pre htem kapôt ã Juãw Paxis mar kaxyw ma hwỳr mra. Nom ê mex ã omunh kaxyw rỳ hpijaàm kãm tanhmã kapẽr to hã mar kaxyw na ka prem hwỳr amrar kêt nẽ. Tĩrtũm nhỹ hã kapẽr o pa jakamã na ka prem ate mar kaxyw ma hwỳr mra. Tĩrtũm nhỹ hã ixkukamã ijarẽnh o pa xwỳnh na. Ixpê Tĩrtũm kot mẽ akaxyw ixãm xwỳnh ã na hte ijarẽnh o pa. Nẽ hprĩ hã tanhmã mẽ amã ijarẽnh to. Jakamã kapẽrja mex o kot wam Tĩrtũm nhỹ hã kapẽr jarẽnh xwỳnhjê kapẽr piitã hakrenh par. ");
INSERT INTO apnNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Tĩrtũm kapẽr ã kagà htũm kot Juãw kukamã tanhmã harẽnh to nẽ harẽnh kot: Kot paj Ixkra hkukamã ma mẽ hwỳr harẽnh xwỳnhja mẽ nhũm ma ri kutêp mẽ kãm harẽnh o pa. Mẽ kot mar nẽ kutêp tãm amnhĩ nhĩpêx o pa kaxyw. —Anhỹr o Tĩrtũm Juãw Paxis kukamã harẽ nhũm prem hã kagà. Tã nhũm ixkukamã mẽ awỳr kumẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Juãw Paxisja na mex kumrẽx. Na pre hprĩ hã ixkukamã tanhmã ijarẽnh to ho pa. Tã nom ixkôt mẽ pa ho mẽ pa xwỳnhjê hkĩnhã na pre ixkôt pa ho pa hkêt nẽ. Jakamã ixkôt mẽ pa ho mẽ pa xwỳnhjaja kot ixkôt hprĩ hã ixkapẽr mar o pa jakamã na mẽ mex o mẽ kot Juãw Paxisja jakrenh. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","13","—Na pre finat Mojes kumrẽx mẽ kãm Tĩrtũm kapẽr kwỳ hã kagà. Tã nhũm hpãnhã Tĩrtũm nhỹ hã kapẽr jarẽnh xwỳnhjaja Mojes mỳr pê hkwỳ hã kagà. Nhũm prem kamã harẽ nẽ kuma nẽ hkôt amnhĩ nhĩpêx o pa. Hãmri nhũm Juãw Paxisja mẽ mỳrpê kato nẽ tãm Tĩrtũm kapẽr o mẽ ahkre ho ri pa. Tã pa hpãnhã ho mẽ ajahkre ho ri mẽ akôt ixpa nhũm mẽ ohtô nẽ inhma nẽ ixkôt amnhĩ xunhwỳ nẽ kãm ixkapẽr kôt pix mã amnhĩ nhĩpêx o ri pa hprãm nẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","—Amnepêm na pre Tĩrtũm nhỹ hã kapẽr jarẽnh xwỳnhjaja mẽhõja kukamã tanhmã harẽnh to ho pa. Nẽ mẽ kãm harẽnh o: “Koja nhỹrmã mẽhõ te Eris kot amnhĩ nhĩpêx pyràk o amnhĩ nhĩpêx nẽ mẽ awỳr mõ. Nẽ mẽ amã Tĩrtũm kot mẽ awỳr mẽnh mã xwỳnhja jarẽnh o pa ka mẽ ama.” Anhỹr o mẽ kãm mẽhõ jarẽ. Tã kot paj mẽ amã kot hkukamã harẽnh xwỳnhta nhĩxi jarẽ ka mẽ inhma. Nà Juãw Paxisja kukamã na prem ã harẽnh anhỹr o pa. ");
INSERT INTO apnNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","—E kot pa mẽ amã mẽ piitã htỳx ri tanhmã mẽ hamaxpẽr to ho mẽ pa hã mẽ amã mẽ harẽ ka mẽ harẽnh ma. ");
INSERT INTO apnNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Te mẽhprĩre kot amnhĩ nhĩpêx pyràk o na htem amnhĩ nhĩpêx. Mẽhprĩrejaja na htem mẽ õrkwỹ kapem mẽmoj to amnhĩkati nẽ tee ri hkwỳjê kot amnhĩ nhĩpêx pumu nẽ mẽ kãm: ");
INSERT INTO apnNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","Kwa na pa mẽ amã gre htã ka mẽ ixkutã anhõkrepôx kêt nẽ. Pa mẽ ja hã mẽ apumu nẽ hpãnhã mẽ amã mẽ htyk jarẽ htã ka mẽ akaprĩ nẽ amỳr kêt nẽ. Kwa mẽ ri ã amnhĩ nhĩpêx anhỹr kêt nẽ. Anẽ. —Mẽhprĩjaja na htem ã axpẽn mã kapẽr anẽ. Tã te mẽ ate mẽ uràk. Tĩrtũm kot mẽ awỳr ỹ hã kapẽr jarẽnh xwỳnhjê rẽnh tã ka mẽ te mẽhprĩre kot amnhĩ nhĩpêx pyrà nẽ mẽ ama nẽ ãm mẽ ama nẽ mẽ hkôt amnhĩ nhĩpêx kêt nẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","—Juãw Paxis na pre mẽ awỳr mõ nẽ ixkĩnhã apkur mex o ri pa hkêt nẽ. Nẽ ixkĩnh ã wĩhti ho hkõm kêt nẽ. Ka mẽ ja hã omu nẽ hkaga nẽ atỳx ri Satanasti nhỹ hã tanhmã kot amnhĩ nhĩpêx to hã hkamnhĩx. Hãmri nẽ mẽhprĩre kot amnhĩ nhĩpêxta pyrà nẽ hkôt amnhĩ nhĩpêx kêt nẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Tã hãmri pa hpãnhã mẽ awỳr mõ nẽ Juãw Paxis rom apkati mẽ ixàpkur mex o ri mẽ akôt ixpa. Nẽ kurom mẽ akutã wĩhti hkwỳ ho ixkõm o ri ixpa. Tã ka mẽ ja hã ixpumu nẽ atỳx ri ixàpkur rũnh nẽ ixpipãnh o ri ixpa hã ixkamnhĩx nẽ ã axpẽn mã ixto akapẽr anẽ. Nẽ mẽ kot amnhĩ tomnuj xwỳnhjê hkôt ri ixpa xwỳnh ã axpẽn mã ijarẽ. Ã na ka htem axpẽn mã ijarẽnh anẽ. Jao te mẽ ate Juãw Paxis nhĩpêx pyrà nẽ ixkaga nẽ ixkôt amnhĩ nhĩpêx kêt nẽ. Na hte ã htỳx ri tanhmã mẽ hamaxpẽr to ho mẽ pa xwỳnhjaja amnhĩ nhĩpêx anẽ. No tãm ri mẽ hamaxpẽr xwỳnhjaja na htem ahpỹnhã wa ixte amnhĩ nhĩpêx ã wa ixpumu nẽ axpẽn mã wa ijarẽnh o: “Nà ahpỹnhã wa kot amnhĩ nhĩpêx tã no ãm hamẽ Tĩrtũm nhỹ hã kapẽr mex o pa. E pu mẽ wa uràk nẽ Tĩrtũm kôt amnhĩ xunhwỳ.” Anhỹr o axpẽn mã wa ijarẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Na pre hte Jejus krĩ piitã hkôt pa nẽ krĩ nhõ xwỳnhjê mã kapẽr nẽ mẽ kot amnhĩ tomnuj ã mẽ kãm kapẽr. Korajĩ mẽ Pese nhõ xwỳnhjê kumrẽx mã kapẽr nẽ mẽ kãm: ");
INSERT INTO apnNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","22","—E mẽ inhma. Amnepêm krĩ pê Sitõ mẽ Xir wa kamã mẽ pa xwỳnhjaja na prem tanhmã amnhĩ tomnuj tỳx to ho pa nhũm Tĩrtũm tee ri ja hã mẽ omu nẽ mẽ kot amnhĩ tomnujta ã tanhmã mẽ ho. Tã kwa mẽ o kora Korajĩ mẽ Pesêj nhõ xwỳnhjaja. Ra ixte mẽ amã aa mẽ ate mẽmoj pumunh kêt kwỳ ho anhỹr rax tã ka mẽ omu nẽ ãm omu nẽ amnhĩ tomnuj kaga hkêt nẽ. Arĩ tanhmã amnhĩ tomnuj to ho ri apa. Mỳrapê kot kaj mẽ amex kêt nẽ. Kop apu Sitõ rỳ Xir kamã mãn ixte mẽ kãm aa mẽ kot mẽmoj pumunh kêt kwỳ ho anhỹr o ri ixpa ronhỹx mẽ omu nẽ mẽ arom amnhĩ kaxyw ixkôt hamaxpẽr tỳx kurê kumrẽx. Nẽ tee ri kot tanhmã kot amnhĩ tomnuj to hã amnhĩ pumu nẽ hkaprĩ nẽ hkaga hpa. No mẽ kajaja na pa hte tee ri mẽ amã aa mẽ ate mẽmoj punuj kêt kwỳ ho anhỹr o ixpa kaprỳ. Ka mẽ ja hã ixpumu nẽ ãm ixpumu nẽ amnhĩ tomnuj kaga hkêt nẽ. Jakamã koja nhỹrmã Tĩrtũm tanhmã mẽ atomnuj tỳx to. Nẽ tanhmã Sitõ mẽ Xir wa kamã mẽ pa xwỳnhjê jarẽnh to nhũm mẽ kot amnhĩ tomnuj mỳrapê amnhĩ xà htỳx kamã hamak rãhã ho pa. No mẽ kajaja mẽ ate amnhĩ tomnuj tỳx o mẽ hakrenh jakamã koja Tĩrtũm mẽ hkĩnhã mẽ atomnuj tỳx kumrẽx. Ka mẽ amnhĩ xà htỳx kamã ajamak rãhã ho ri apa kãm ga. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","24","Nhũm pre ã Jejus mẽ kãm kapẽr anẽ. Nẽ hpãnhã Kapanaũ nhõ xwỳnhjê mã kapẽr nẽ mẽ kãm: —No mẽ apê Kapanaũ nhõ xwỳnhjaja. Kot kaj mẽ ajaxwỳja mẽ uràk nẽ amex kêt nẽ. Ra ixte mẽ amã aa mẽ ate mẽmoj pumunh kêt kwỳ ho anhỹr rax nhũm mẽ ate hã ixpumunh tã amnhĩ tomnuj kaga hkêt tã Tĩrtũm mẽ wa inhõ krĩ hwỳr akrà. No ãm hwỳr akrà kaprỳ. Kot kaj mẽ atõ hwỳr axàpir kêt nẽ. Kop apu Sotõ nhõ xwỳnhjaja mãn kot ã ixte amnhĩ nhĩpêx anhỹr ã ixpumunh ronhỹx mẽ ra kot amnhĩ tomnuj kaga nẽ ixkôt amnhĩ xunhwỳr kurê kumrẽx. No mẽ kajaja na ka mẽ ã amnhĩ nhĩpêx anhỹr kêt nẽ. Jakamã kot kaj mẽ nhỹrmã ma kuwy maatita wỳr ajapêx pa kãm ga. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","26","Tã nhũm Jejus Tĩrtũm mã amnhĩ jarẽ nẽ kãm: —Pa Papaj? Nà apê mẽ inhõ Pahi Maati na ka. Pikap ri mẽ pa xwỳnhjaja nẽ kaxkwa kamã mẽ pa xwỳnhjaja apê mẽ ixpiitã mẽ inhõ Pahi Maati na ka. Ãm hãmri na ka hte amnhĩ nhĩpêx mex o ri apa. Na ka hte mẽ àhpumunh tỳx ã mẽ kot amnhĩ to jarkrar xwỳnhjê mã axàhpumunh tỳx o amnhĩrĩt kêt nẽ. Ãm mẽ àhpumunh kêt ã mẽ kot amnhĩ jarẽnh xwỳnhjê pix mã na ka hte axàhpumunh tỳx o amnhĩrĩt nhũm mẽ tapxipixjaja ja hã apumu. Nà ãm hãmri. Ãm hãmri na ka hte amã hprãm xà hkôt ã mẽ piitã mẽ hipêx anhỹr o ri apa Papaj. Jakamã mẽ kot amnhĩ to hkryre xwỳnh pixjaja na htem hprĩ hã ate amnhĩ nhĩpêx kôt apumunh o pa. Anẽ. Nhũm pre ã Jejus Tĩrtũm mã amnhĩ jarẽnh anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Hãmri nẽ hpãnhã mẽ kot mar o kuhê xwỳnhjê mã kapẽr nẽ mẽ kãm: —Nà na pre ra Inhĩpêêxàja inhĩhkra kamã mẽmoj piitã hagjênh pa. Ixte kãm ho amnhĩptàr o ixpa kaxyw. Jakamã tapxipix na kot ixpê Kra hã ixpumunh par. No jar pika ja kamã mẽ pa xwỳnhjaja na mẽ kot ja hã ixpumunh kêt. Nẽ papxipix na ixte Inhĩpêêxà kot tanhmã amnhĩ nhĩpêx to hã omunh par. Jakamã na pa hte ã amnhĩ nhĩpêx o ri ixpa anẽ nẽ inhmã hprãm xà hkôt mẽ hkwỳjê mã ho amnhĩrĩt o ri ixpa. Jakamã nhũm mẽ ixpyrà nẽ Inhĩpêêxà kot tanhmã amnhĩ nhĩpêx to ho pa hkôt omu. ");
INSERT INTO apnNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","30","—Nẽ tee ri amnhĩ kukamã mẽ ajamaxpẽr o ri apa xwỳnhjaja te mẽ ate mẽmoj pytĩ rax tur nẽ ahte ho apa pyràk. Kwa mẽ ixkôt amnhĩ xunhwỳ nẽ ixte amnhĩ nhĩpêx ã ixpumu. Ixte mẽ akamã ixukaprĩ xwỳnh na pa. Na pa hte mẽ akutã inhnojarêt rãhã ho ixpa. Jakamã kot kaj mẽ ixkôt amnhĩ xunhwỳ pa te ixte mẽ anê mẽmoj pytĩ ho ixwrỳk pyràk o mẽ anhĩpêx nẽ tãm mẽ axunhwỳ ka mẽ tãm ajamaxpẽr nẽ tãm amnhĩ nhĩpêx o ri apa. Mo kaxyw koja ixkôt mẽ kot amnhĩ nhĩpêx o pa xwỳnhjaja tee ri amnhĩ kukamã hamaxpẽr o pa? Nà na htem ixkamnàr rom hamakêtkati nẽ àmnhĩx ri pa ho pa. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Tã nhũm Ijaew nhõ arĩgromnu pê sapja kato. Hãmri nhũm Jejus mẽ hkôt ri mẽ ixpa ho mẽ ixpa xwỳnhjê mẽ pa mẽ ma mẽ hpur kôt ri nhỹhỹm ri ixpa. Hãmri nẽ ra mẽ inhmã prãm nẽ mẽmo hy te kot harôj pyràk xwỳnhja kwỳ rê nẽ kugrà nẽ ma Jejus kôt hkanhar o mõ. Mẽ ixpê Ijaew na pa htem axpẽn pur kãm ã amnhĩ nhĩpêx anhỹr o ixpa. ");
INSERT INTO apnNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Hãmri nhũm mẽ ixkwỳ pê Parijew nhõ xwỳnhjaja kãm mẽmoj tã Jejus o kapẽr prãm jakamã ã mẽ ixte amnhĩ nhĩpêx anhỹr ã mẽ ixpumu nẽ mẽ ixtã Jejus kukjêr kurê kumrẽx nẽ kãm: —Kwa Tĩrtũm kapẽr tũm kot mẽ panhõ arĩgromnu hã mẽ pahte mẽ hpur kãm mẽmoj nhĩkẽnh nê mẽ pahkurê htã nhũm ri akôt mẽ pa ho mẽ pa xwỳnhjaja axtem nẽ ã amnhĩ nhĩpêx anhỹr o ri akôt pa. Mẽmo hyta rê nẽ akôt hkanhar o pa. Kwa mẽ kãm anẽ kê mẽ ã amnhĩ nhĩpêx anhỹr kêt nẽ. Na htem arĩgromnu hã mẽmoj tã àpênh kêt kênã. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","4","Hãmri nhũm mẽ kuma nẽ hprĩ hã mẽ kãm Tĩrtũm kapẽr jarẽ nẽ mẽ kãm: —Tk. Xàn ka htem Tĩrtũm kapẽr ã kagà htũm kot pahi Tawi kot tanhmã amnhĩ nhĩpêx tota kamã harẽnh nẽ mar kêt nẽ? Na pre hkôt ri mẽ pa xwỳnhjê mẽ nhũm mẽ prãm xàj Tĩrtũm mã amnhĩ jarẽnh xà hã ixkre hwỳr agjê. Hãmri nhũm mẽ õ patre maatija mẽ kãm prãm tỳx ã mẽ omu nẽ kãm mẽ hkaprĩ nẽ mẽ kãm mẽmoj gõ. Mẽ kot Tĩrtũm noo mã pãwti jaxwỳr xwỳnhta gõ nhũm mẽ kuku. Tĩrtũm kapẽr ã kagà htũm kot ja nê mẽ hkurê htã nhũm mẽ kãm prãm tỳx ã mẽ omu nẽ mẽ kamã ukaprĩ xàj mẽ kãm kugõ. Ãm mẽ õ patre pix kot ja hkur kaxyw tã nhũm mẽ kãm kugõ nhũm mẽ kuku. Tã nom nhũm Tĩrtũm ja hã mẽ omu nhũm ja kêp omnuj kêt nẽ. Kot mẽ kamã ukaprĩ nẽ mẽ kãm õr ã omu nhũm ja kãm mex nẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","—Mẽ panhõ arĩgromnu htã na hte patrejaja arĩ hã Tĩrtũm mã amnhĩ jarẽnh xà hã ixkre kamã àpênh o pa. Tĩrtũm kapẽr ã kagà htũm kôt na htem arĩgromnu htã nhũm mẽ arĩ hã apê nhũm Tĩrtũm pê jamnuj kêt nẽ. Kumã mẽ àpênh xwỳnh kênã. ");
INSERT INTO apnNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","ãm hãmri na pa mẽ amã ja jarẽ. Tĩrtũm mã amnhĩ jarẽnh xà hã ixkreta mex tã nom ixpê Tĩrtũm Kra jakamã inhmex o ixte ixkreta jakrenh. ");
INSERT INTO apnNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Tĩrtũm kapẽr ã kagà htũm kot ja harẽnh kot: Kêr ka mẽ inhmã amnhĩ jarẽnh kaxyw nẽ ãm inhmã mẽmoj nhõr pix pê inhmã amnhĩ jarẽnh kêt nẽ. Mẽ mããnẽn mẽ kamã axukaprĩ o ri apa pê inhmã amnhĩ jarẽ. Ja na kêt inhmã hprãm. —Ã harẽnh kot anhỹr. Tã mẽ ate aprĩ hã ja mar ronhỹx ka mẽ ixkôt mẽ pa xwỳnhjê kot mẽmo hy rênh nẽ hkanhar o mõr ã mẽ omu nẽ ri tanhmã mẽ ho akapẽr to hkêt nẽ. Ãm mẽ kãm prãm ã mẽ omu nẽ mẽ kamã axukaprĩ nẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","—Kêt pa na pre Tĩrtũm mẽ akaxyw ixãm nẽ mẽ awỳr inhmẽ. Jakamã papxipix na pa hte arĩgromnu hã tanhmã mẽ kot amnhĩ nhĩpêx to hã mẽ kãm karõ. Kwa mẽ jajê pumu nẽ mẽ kamã axukaprĩ kêt wehe. Kwãr mẽ mãmrĩ mẽmo hyta rê nẽ hkanhar o ixkôt mõ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Nhũm pre ã Jejus Parijew nhõ xwỳnhjê mã kapẽr anẽ hãmri nẽ Tĩrtũm kapẽr o mẽ ahkre xà hã ixkre hwỳr tẽ nẽ axà. ");
INSERT INTO apnNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Nhũm Parijew nhõ xwỳnhjaja tanhmã ho kapẽr to kaxyw htãnopxar o kuhê. Jakamã nhũm ixkre kamã mẽhõ my ĩhkra grà xwỳnhja mẽ pikuprõnh xwỳnhjê nhĩhkô hã nhỹ nhũm Parijew nhõ xwỳnhjaja omu nẽ axpẽn mã: —Kwa pu mẽ jar pakuhê nẽ Jejus kot tanhmã amnhĩ nhĩpêx to hã omu. Xà koja arĩgromnu hã mũjti ho mex nà? Koja ho anẽ nẽ Tĩrtũm kapẽr tũm kuhpa hã amnhĩ nhĩpêx. E pu mẽ kop xa nẽ hã omu. Anẽ. Hãmri nẽ hã Jejus kukja nẽ kãm: —E mẽ inhmã mẽmoj jarẽ. Xà na htem arĩgromnu hã akupỹm mẽ ho mex nhũm Tĩrtũm kãm ja mex nẽ nà? Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Hãmri nhũm mẽ hamaxpẽr kôt mẽ omunh mex nẽ mẽ kãm: —Kwa tanhmã na htem arĩgromnu hã amnhĩ nhĩpêx to ho pa wehe? Xà koja we mẽ akrit ôwêhti ahkrehti kamã tẽm ka omu nẽ ãm omu nẽ arĩgro mex jamãr pê ho axàpir kêt nẽ? Nà kot kaj mẽ tee ri omu nẽ ho axàpir kurê kumrẽx. ");
INSERT INTO apnNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Arĩgromnu hã mẽ ho mexja ja mex kênã. Tĩrtũm mã mẽ pahpê panhĩja na mẽ pamex o mẽ hkrit jakrenh jakamã kêr pu mẽ tee arĩgromnu htã pu mẽ hã tanhmã axpẽn to mex to ho papa. Ja na Tĩrtũm kãm hprãm. Anhỹr o mẽ kãm kapẽr. ");
INSERT INTO apnNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Hãmri nẽ hpãnhã myta mã: —E anhĩhkra katàt. Anẽ. Hãmri nhũm ĩhkra katàt nẽ mex kurê kumrẽx. ");
INSERT INTO apnNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Hãmri nhũm Parijew nhõ xwỳnhjaja tee ri ja hã omu nẽ Jejus kamã gryk nẽ. Arĩgromnu pê sap ã kot ho mex jakamã nhũm mẽ kamã gryk tỳx nẽ. Hãmri nẽ ma mra nẽ hapôj nẽ hã axpẽn kukjêr o kuhê nẽ axpẽn mã: —Kwa ã kot amnhĩ nhĩpêx anhỹrja mỳrapê tanhmã kot puj wem ho? ã kapẽr anhỹrja o te mẽ papamjaja mẽ pahte hkĩnhã mẽ kamã paxukaprĩ kêt pyràk ã mẽ pajarẽ. Koja mẽ pahkwỳjaja kuma hãmri nẽ mẽ pahte amnhĩ nhĩpêx kaga nẽ amnhĩ kaxyw hkôt pix mã hamaxpẽr. Kwa tanhmã kot puj wem ja nê ho? Anhỹr o axpẽn kukjêr o kuhê. ");
INSERT INTO apnNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Hãmri nhũm Jejus amnhĩ tã Parijew nhõ xwỳnhjê jamaxpẽr kôt mẽ omu hãmri nẽ mẽ kêp kato nẽ hpãnhã ma nhỹhỹm krĩ hõ hwỳr ma tẽ. Nhũm mẽ ohtô nẽ omu nẽ ma hkôt mra nhũm mẽ omu nẽ akupỹm mẽ kãm mẽ à xwỳnh piitã ho mex. ");
INSERT INTO apnNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Hãmri nẽ mẽ kãm: —E na pa akupỹm mẽ ato mex. Nom kêr ka mẽ amnhĩ tã ixto axàmra ho ri apa hkêt nẽ. Ixpê Tĩrtũm Kra hã mẽ kãm ijarẽnh kêt nẽ. Ãm kwarĩ kumrẽx. Anhỹr o mẽ kãm kapẽr. ");
INSERT INTO apnNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Na pre ra amnepêm Tĩrtũm nhỹ hã kapẽr xwỳnh finat Ijaisja Jejus kukamã mẽ kãm tanhmã harẽnh to nẽ hã kagà. Te Tĩrtũm tãm kapẽr pyràk o harẽ nẽ hã kagà. Nẽ hã kagà ho: ");
INSERT INTO apnNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Ota ixkôt amnhĩ nhĩpêx o pa xwỳnhta xa. Pa na pa amnhĩ kaxyw ãm. Inhmã hapêê. Na pa hte tanhmã kot amnhĩ nhĩpêx to ho pa hã omu nẽ ixkĩnh tỳx nẽ. Kot paj hwỳr amnhĩ karõ mẽ nhũm hwỳr axà nhũm ma ỹ hã pika piitã hkôt mẽ piitã mẽ kãm ijarẽnh o ri mẽ hkôt pa. Mẽ kot hprĩ hã ixte tanhmã amnhĩ nhĩpêx to nẽ tanhmã ijamaxpẽr to hã ixpumunh kaxyw. ");
INSERT INTO apnNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Nom koja ri amnhĩ to àmra o pa hkêt nẽ. Rỳ kãm amnhĩ to rax prãm o mẽ kãm tanhmã amnhĩ nhĩpêx to ho pa hkêt nẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","ãm kapẽr xukaprĩ pix o koja mẽ hirerek xwỳnhjê mã kapẽr o pa. Nẽ mẽ kot tee ri amnhĩ nhĩpêx ã amnhĩ pumunh xwỳnhjê kamã ukaprĩ o pa. Nẽ mẽ kot htỳx ri amnhĩ nhĩpêx o mẽ pa xwỳnhjê kutã nojarêt rãhã ho pa jakamã nhũm mẽ hpãnhã tãm amnhĩ nhĩpêx o pa. Koja ã amnhĩ nhĩpêx anhỹr o ri mẽ hkôt pa rãhã ra akupỹm mẽmoj piitã tãm haxwỳr pa. ");
INSERT INTO apnNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","ã kot amnhĩ nhĩpêx anhỹr o pa jakamã koja pika piitã hkôt mẽ pa xwỳnh kwỳjaja kukwak ri amnhĩ kaxyw Tĩrtũm kôt hamaxpẽr nẽ hkôt amnhĩ xunhwỳ. Anẽ. Na pre ã finat Ijaisja Tĩrtũm nhỹ hã kormã Jejus wrỳk nẽ kator kêt ri tanhmã kot amnhĩ nhĩpêx to ho pa hkukamã harẽnh nẽ hã kagà anẽ. Tã nhũm mẽ hwỳr wrỳ nẽ ã mẽ hkôt amnhĩ nhĩpêx anhỹr o pa. ");
INSERT INTO apnNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Tã nhũm prem Jejus wỳr mẽhõ myja o mõ. Mẽkarõmnuti kot hwỳr àr nẽ ho nohkre nẽ ho kapẽr kêt xwỳnhta nhũm mẽ hwỳr o mõ. Hãmri nhũm omu nẽ nê mẽkarõmnuti jano nẽ akupỹm ho mex kurê kumrẽx nhũm akupỹm rĩt mex nẽ akupỹm kapẽr mex nẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Hãmri nhũm mẽ amnhĩ jaêr pê omu nẽ kamã no pyma nẽ hã axpẽn kukjêr o: —Kokỹỹ. Jejus na hte ãm mẽ ho mex o mẽ ho mex o pa. Mãn kêp Tĩrtũm kot mẽ pahwỳr mẽnh mã xwỳnhta na nà? ã na hte ã amnhĩ nhĩpêx anhỹr o pa. Mãn kêp pahi finat Tawi kanrẽhã tàmnhwỳta na nà? Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Nom nhũm Parijew nhõ xwỳnhjaja ã Jejus kot amnhĩ nhĩpêx anhỹr ã omu nẽ kêp mẽkarõmnuti hkwỳ hã hkamnhĩx. Jakamã mẽ kot hã axpẽr kukjêr ã mẽ kuma nẽ mẽ kãm: —Tk pẽr hinhu nhĩkôôti nhỹ hã na hte mẽ nê amnhĩ kwỳjê japôx o pa. Anẽ. Hinhu nhĩkôôti nhĩxi hõ pê Satanasti nhũm prem ã Satanasti nhỹ hã Jejus kot amnhĩ nhĩpêx ã hkamnhĩx anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Nhũm ra mẽ hamaxpẽr kôt mẽ omunh mex jakamã mẽ kãm: —Kwa mẽ inhma mẽ ate ixpê Satanasti hkwỳ hã ixkamnhĩx xwỳnhjaja. Koja pika nhõ xwỳnhjaja axpẽn kutã amnhĩ xunhwỳ nẽ axpu hãmri nẽ anhgrà nẽ ma ahpỹnhã ri pa. Hãmri nẽ amnhĩ krã hkôt ri tanhmã amnhĩ nhĩpêx to ho pa. Jakamã nhũm mẽ õ pahija mẽ hamãr kêt nẽ. Nẽ koja krĩ nhõ xwỳnhjaja. Rỳ mẽ kot axpẽn to hkwỳ xwỳnhjaja mẽmoj tã axpẽn kãm gryk nẽ axpẽn kutã amnhĩ xunhwỳ. Hãmri nẽ ahpỹnhã awry hã pa nhũm mẽ õ pahija tee ri kãm mẽ hamãr prãm kaprỳ. Mo mẽ hkwỳjaja kot ri mẽ hamãr o pa? No koja pahija tãm amnhĩ nê amnhĩ kwỳjê janor kêt nẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Tã ja pyrà nẽ ixte Satanasti nhỹ hã tanhmã amnhĩ nhĩpêx to ho ri ixpa ronhỹx pa ri mẽ nê amnhĩ kwỳjê janor kêt nẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","—No mẽ akwỳjaja? Xà Satanasti nhỹ hã na htem mẽ nê mẽkarõmnuti japôx o pa? Kêp apu pa ixte ỹ hã mẽ nê amnhĩ kwỳjê japôx ronhỹx mẽ akwỳjaja ixpyrà nẽ ỹ hã mẽ nê amnhĩ kwỳjê japôx o pa. Nà Tĩrtũm nhỹ hã mẽ ixte mẽ nê mẽ hapôx o ixpa kênã. Jakamã mẽ ate ã ijarẽnh anhỹrja mex kêt. ");
INSERT INTO apnNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Tĩrtũm Karõ nhỹ hã ixte mẽ nê mẽ hapôx jakamã kwa mẽ ja hã ixpumu nẽ ixte mẽ ato amnhĩptàr kaxyw Tĩrtũm kot mẽ awỳr inhmẽnh kôt ixpumu kêt wehe. Pa na ka htem ijamãr o apa. ");
INSERT INTO apnNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","—Satanastija àhpumunh tỳx jakamã na htem tee ri kêp hkôt mẽ kot amnhĩ xunhwỳr xwỳnhjê pytàr kaxyw nhũm mẽ nê mẽ omunh mex nẽ. Tã nom ixàhpumunh tỳx o ixte Satanasti jakrenh par jakamã na pa hte kêp mẽ utà nhũm mẽ hpãnhã ixkôt ri amnhĩ nhĩpêx. ");
INSERT INTO apnNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","—Ra mẽ amã ixkapẽr mar prãm tã nom kormã ixkôt amnhĩ xunhwỳr kêt nẽ. Kwa wem ma amnhĩ to amõr gri nẽ tokyx ixkôt amnhĩ xunhwỳ kêt wehe. Kot kaj mẽ anhỹr kêt hãmri nẽ mẽ apê ixkutã amnhĩ xunhwỳr xwỳnh pyràk o amnhĩ nhĩpêx. ");
INSERT INTO apnNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","32","—Nẽ koja mẽhõ ixkapẽr ma nẽ kãm ixprãm kêt nhũm Tĩrtũm ixtã omu nom tokyx tanhmã ixtã ho hkêt nẽ. Koja kormã amnhĩ tã hamã. Karõ kot axte kãm ijarẽnh o amnhĩrĩt nhũm jatã kot mar nẽ kãm ixprãm nẽ ixkôt amnhĩ xãm prãm xàj nhũm kormã amnhĩ tã hamã. Nom koja Karõ xatã mẽ kãm tanhmã ixto amnhĩrĩt to htã nhũm mẽ kuma nẽ ãm kuma nẽ te mẽ kêp amnhĩ jamak pro pyràk. Jao ra Karõ hã hpijaàm kêt o amnhĩ nhĩpêx. Mỳrapê koja Tĩrtũm nhỹrmã amnhĩ xwar te kêp amnhĩ jamak pro pyràk o mẽ hipêx nhũm mẽ tee kãm amnhĩ kaprĩ kaprỳ. Hãmri nẽ amnhĩ xà htỳx kamã hamak o pa xàta wỳr ma pa nẽ kamã pa rãhã nẽ pa ho pa. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Nhũm Jejus arĩ Parijew nhõ xwỳnhjê mã kapẽr nẽ mẽ kãm: —Nẽ kot kaj mẽ atõ anhõ mẽmo pàr nhũm amã ô mex nẽ. Ô rax nẽ. Ka omu nẽ akĩnh nẽ amnhĩm mex ã harẽ. No koja apê ô hkêt ka tee ri omu nẽ mex kêt ã harẽ. Na htem ã amnhĩm mẽmo xô hpàr pumunh kôt tanhmã kute hã harẽnh anẽ. Ja pyrà nẽ na htem tanhmã mẽ kot amnhĩ nhĩpêx to hã mẽ omunh kôt tanhmã mẽ harẽnh to. Mẽ kot amnhĩ tomnuj xwỳnh ã mẽ harẽ rỳ mẽ kot amnhĩ to mex xwỳnh ã mẽ harẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","35","—Nẽ koja mẽhõ hamaxpẽr mex nẽ hãmri nẽ kapẽr mex o pa. Nom koja hamaxpẽr punuj nẽ kapẽr punuj pix o pa. Nẽ htỳx ri tanhmã amnhĩ tomnuj to ho pa. Na htem ahpỹnhã amnhĩ jamaxpẽr xà hkôt tanhmã kapẽr to ho pa. No mẽ kajaja na ka htem kagã xoprê jamaxpẽr pyràk o ajamaxpẽr punuj pix o ri apa. Jao akapẽr punuj nẽ. No tãm ajamaxpẽr o tãm akapẽr o ri apa hkêt nẽ. Na htem tanhmã hamaxpẽr to xà hkôt tanhmã ri kapẽr to ho pa. ");
INSERT INTO apnNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","37","Koja nhỹrmã Tĩrtũm mẽ piitã tanhmã mẽ kapẽr to hã mẽ mar xà hkôt tanhmã mẽ harẽnh to. Jakamã mẽ akapẽr mex o mẽ apa xwỳnhjaja koja mẽ amex ã mẽ ajarẽ. Nom mẽ atỳx ri akapẽr punuj o mẽ apa xwỳnhjaja koja mẽ amex kêt ã mẽ ajarẽ. Hãmri nẽ mẽ akapẽr punuj o apaja mỳrapê mẽ atomnuj tỳx nẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Hãmri nhũm Tĩrtũm kapẽr tũm o mẽ ahkre xwỳnh mẽ Parijew nhõ xwỳnh kwỳjaja mẽmoj tã Jejus wỳ nẽ kãm: —Kwa Pahihti. Mẽ inhmã aa mẽ ixte mẽmoj pumunh kêt õ ho anẽ. Kot paj mẽ omu hãmri nẽ Tĩrtũm kot mẽ ixwỳr amẽnh ã apumunh kurê kumrẽx. Jakamã e mẽ inhmã mẽmoj to anẽ nà. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Hãmri nhũm mẽ kuma nẽ mẽ kãm: —Tk. Pẽr ãm mẽ ajamaxpẽr punuj pix o na ka htem apa. Ixpê Tĩrtũm kot mẽ awỳr inhmẽnh xwỳnh tã mẽ ate ja hã ixpumunh kêt. Nẽ mẽ ate ja hã axpẽn mã ijarẽnh kêt tã ixte mẽ amã aa mẽmoj pumunh kêt õ ho anhỹr kaxyw hã ixwỳ. Nà pa mẽ amã ho anhỹr kêt nẽ. Kormã. Ãm amnepêm Jõhti kot tanhmã amnhĩ nhĩpêx toja pix kot paj mẽ amã harẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","—Tĩrtũm nhỹ hã kapẽr xwỳnh Jõhtija amnepêm na pre tep rax kumrẽxja htĩr rãhã kukrẽ. Nhũm õxàhkre kamã htĩr nẽ hkrĩ hã apkati axkrunẽpxi hãmri nẽ htĩr rãhã õxàhkre rũm kato. Tã ixpê Tĩrtũm kot mẽ awỳr inhmẽnh xwỳnh kot paj nhỹrmã kẽn kre kamã ixtyk nẽ inhnõr ã apkati axkrunẽpxi. Jõhti hkĩnhã ixtyk kumrẽx nẽ inhnõr ã apkati axkrunẽpxi hãmri nhũm Tĩrtũm akupỹm ixto ixtĩr. ");
INSERT INTO apnNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","—Nẽ koja nhỹrmã Tĩrtũm akupỹm mẽ htyk nẽ mẽ hikwỹ xwỳnh piitã akupỹm mẽ ho htĩr hãmri nhũm mẽ piitã Inhĩpêêxà mẽ wa ixkutã hkrĩ pa wa tanhmã mẽ harẽnh to. Tĩrtũm mẽ wa ixkuri mẽ htĩr tũm nẽ mẽ pa ho mẽ pa mã xwỳnhjê hã mẽ hkwỳjê jarẽ nẽ wa ixkuri mẽ pa ho mẽ pa hkêt xwỳnhjê jarẽ. Mẽ piitã ã ahpỹnhã mẽ harẽnh anẽ. Amarĩ mẽ pa xwỳnhjaja nẽ mẽ õ pahijaja. Jakamã nhũm Nĩnĩwe nhõ xwỳnhjaja tanhmã wa inhmã mẽ ajarẽnh to. Jõhti kot mẽ hwỳr mõr nẽ mẽ kãm Tĩrtũm kapẽr jarẽnh o pa xwỳnhjaja nhũm mẽ tanhmã wa inhmã mẽ ajarẽnh to nẽ wa inhmã: “Na pre Jõhtija man mẽ inhõ krĩ hwỳr mõ nẽ mẽ inhmã akapẽr jarẽnh o ri mẽ ixkôt pa. Pa prem kuma nẽ mẽ ixte amnhĩ tomnuj kaga nẽ akôt amnhĩ xunhwỳr kurê kumrẽx Tĩrtũm. No or war akutã mẽ hkrĩ xwỳnh kwỳ ata mẽ na pre Akra Jejus tãm mẽ hwỳr mõ nẽ mẽ kãm kapẽr o ri mẽ hkôt pa nhũm prem mar tã mẽ ixkĩnhã mẽ kot amnhĩ tomnuj kaga nẽ hkôt amnhĩ xunhwỳr kêt nẽ. Mẽ ixkurom mẽ kot Akra mar tã amnhĩ kaxyw kãm hamaxpẽr kêt nẽ.” Anhỹr o koja mẽ wa inhmã mẽ ajarẽ ka mẽ tee ri mẽ ama nẽ ra mẽ amã ma nẽ. Nom ãm mẽ amã ma kaprỳ. ");
INSERT INTO apnNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","—Nẽ sur kãm mẽ õ pahi nitita koja mẽ hpãnhã tanhmã wa inhmã mẽ ajarẽnh to nẽ wa inhmã: “Na pa pre inhmã pahi Sarumãw kot war anhỹ hã àhpumunh tỳx ã harẽnh ma hãmri nẽ inhmã mar prãm xàj ma awry hã õ pika hwỳr mõ nẽ omu nẽ kapẽr ma. Hãmri nẽ ma akupỹm inhõ pika hwỳr mõ nẽ ixkwỳjê mã àhpumunh tỳx ã harẽnh o ri ixpa. Tã Akra Jejus na kot àhpumunh tỳx o pahi Sarumãw jakrenh tã or war akutã mẽ hkrĩ xwỳnh kwỳ ata mẽ. Mẽ kot kapẽr mar tã ixkĩnhã kãm mar prãm kêt. Na prem kuma nẽ ãm kuma.” Anhỹr o koja wa inhmã mẽ ajarẽ. Hãmri nẽ ja hã mẽ amã akir ka mẽ tee ri mar o akrĩ nẽ amnhĩ kamã agryk o akrĩ. Nom ãm amnhĩ kamã agryk kaprỳ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Nhũm Jejus arĩ Parijew nhõ xwỳnhjê mẽ Tĩrtũm kapẽr tũm o mẽ ahkre xwỳnhjê mã kapẽr nẽ mẽ kãm: —Te mẽ ate ixte mẽhõ nê mẽkarõmnuti japôx xwỳnhta pyràk. Nhũm te kêp kator nẽ ma htẽm pyràk. Nẽ nhỹri amgrà kamã ri pa pyràk. Koja ja kêp omnuj nhũm tee ri kamã nhỹri hkôt xà japêr o pa. Nom tee ri hapêr o pa kaprỳ. ");
INSERT INTO apnNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Hãmri nẽ tanhmã amnhĩ kukamã hamaxpẽr to nẽ hamaxpẽr o: “E kot paj ma akupỹm mẽ kot nê ixkator xwỳnhta wỳr tẽ nẽ axà nẽ kamã mãn ri ixpa.” ");
INSERT INTO apnNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Anhỹr o hamaxpẽr hãmri nẽ ma akupỹm hwỳr tẽ. Nom kormã akupỹm hwỳr àr kêt ri nhũm kamã amrakati nẽ ri pa. Jakamã nhũm akupỹm hwỳr axà. Nom ahte hwỳr àr kêt nẽ. Amnhĩ kôt hkwỳjê ho 7 nẽ hwỳr mẽ ho gjêx pa. Mẽ kêp 7jaja nẽ wamta mẽ nhũm mẽ piitã hwỳr gjêx pa. No mẽ kêp 7jaja na omnuj tỳx o kot wamta jakrenh jakamã nhũm mẽ kot hwỳr gjêx xwỳnhta mẽ ỹ hã ra amnhĩ tomnuj tỳx nẽ oprê htỳx o pa. Wam pyxire kot hwỳr àrta nhỹ hã nhũm amnhĩ tomnuj o ri pa nom kawax pê oprê. Tã nhũm ra axte hwỳr mẽ ohtô nẽ gjêxta nhỹ hã hãmri oprê htỳx kumrẽx. Ja pyrà nẽ kot kaj mẽ tokyx ixkôt amnhĩ xunhwỳr kêt nẽ hãmri nẽ amnhĩ tomnuj tỳx pix o ri apa. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Nhũm Jejus arĩ mẽ ahkre ho nhỹ. Rôm nhũm katorxà nẽ htõjaja nhỹhỹnh hwỳr mõn pôj. Nom kormã hwỳr gjêx kêt nẽ. Mẽ kot hã htu rax jakamã nhũm mẽ tee ri hwỳr gjêx kaxyw kormã kapôt ã hã mẽ omunh o kuhê. ");
INSERT INTO apnNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Hãmri nhũm mẽhõja kapôt ã mẽ omu nẽ Jejus mã mẽ harẽ nẽ kãm: —Kwa Pahihti. Ota akatorxà mẽ atõjaja awỳr mõn pôj nẽ tee àr kaxyw. O mũj mẽ kapôt ã kuhê. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","50","Hãmri nhũm kuma nẽ kãm: —Tôe. Nà kot pa ixkato nẽ mẽ omu. Inhmã mẽ hapêê. Nom kot kaj mẽ atõ Tĩrtũm kapẽr ma nẽ hkôt amnhĩ xãm nẽ hkôt amnhĩ nhĩpêx. Hã kot kaj te apê ixtõ rỳ ixkatorxà pyràk o pu mẽ axpẽn nhĩpêx o ri papa. Pa inhmã ixkatorxà nẽ ixtõjê japê pyrà nẽ mããnẽn inhmã mẽ ajapê nẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Hãmri nhũm Jejus mẽ kãm kapẽr pa nẽ ixkre rũm kato nẽ ma himô rax wỳr tẽ nẽ gô mỳri mẽ kãm ujarẽnh kaxyw nhỹ. Pa mẽ ixpê hkôt mẽ ixpa ho ixpa xwỳnhjaja ma hkôt mra. ");
INSERT INTO apnNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","3","Hãmri nẽ gôta wỳr pôj nẽ mỳri ixkrĩ. Nhũm mẽ Jejus ã htu rax nẽ nhũm tee ri mẽ omunh o nhỹ. Hãmri nẽ hamaxpẽr nẽ kànhmã xa nẽ tẽ nẽ pàr krem axà nẽ pàr kre kamã mũtũm awry rũm mẽ ahkre ho nhỹ nhũm mẽ piitã omunh nẽ mar mex o hkrĩ. Nhũm mẽ kãm ujarẽnh o mẽ ahkre ho nhỹ. Nom mẽ kãm tãm ujarẽnh kêt nẽ. Mẽ kot Tĩrtũm kapẽr mar nẽ tanhmã hkôt amnhĩ nhĩpêx to ho paja nhũm hã kuxi nẽ mẽ kãm harẽnh o nhỹ nhũm mẽ amgrà kamã kỳx pê mar o hkrĩ. Nhũm mẽ kãm: ");
INSERT INTO apnNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","—E mẽ inhma. Koja mẽhõ ma pur mã mõ nẽ pur kãm mẽmo hy ho ukapêr o ri pa. Nom nhũm hy piitã amex kãm rôrôk kêt nẽ. Koja hkwỳja ahpỹnhã nhỹri rôrôk. Kwỳ aptỳx kãm rôrôk nhũm kuwênhre omu nẽ hwỳr mra nẽ hkrẽr pa. ");
INSERT INTO apnNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","—Nẽ koja kẽn kãm hkwỳ rôrôk nẽ ra higrõt kutã nojarêt nẽ higrõt pa. Nom nhũm kamã aptỳx nẽ kêp pika hkryre. ");
INSERT INTO apnNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Jakamã nhũm higrõt nhũm hã myt ahpa nẽ arĩgro htỳx mẽ nhũm grà pa. Harê hkryre jakamã grà pa. ");
INSERT INTO apnNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","—Nẽ koja mrônhĩ kamã hkwỳ rôrôk nẽ higrõt tã no nhũm utĩja kêp amỹtà nhũm ô hkêt nẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","—No kêt hirã kamã pika mex kãm rôrôk xwỳnhja hirã kamã rôrôk jakamã higrõt mex nẽ piitã ô rũnh nẽ. Kamã ô hkwỳ kêp 30 nẽ kamã hkwỳ kêp 60 nẽ kamã hkwỳ kêp 100. Ã mẽ ujarẽnh kot anhỹr. ");
INSERT INTO apnNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Kwa kêr ka mẽ ixujarẽnhja ma nẽ kãm ajamaxpẽr tỳx rãhã ho apa. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Hãmri pa mẽ ixpê Jejus kôt mẽ ixpa ho ixpa xwỳnhjaja Jejus kot mẽ kãm ã ujarẽnh anhỹrja ã kuma nẽ tee ri hkukamã ijamaxpẽr. Hãmri nẽ hã hkukja nẽ kãm: —Kwa axujarẽnhta na pa mẽ ixprĩ hã hkôt mẽmoj pumunh kêt nẽ. Mon ka hte ãm mẽ ujarẽnh pix o mẽ ahkre? Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Hãmri nhũm mẽ inhmã: —Tôe. Nà kot paj mẽ amã harẽ. Tĩrtũm kãm mẽ ate aprĩ hã mar prãm jakamã kot paj ixprĩ hã mẽ amã harẽ. Mẽ kot amnhĩ tomnuj kaga nhũm Tĩrtũm kot ja hã mẽ omunh nẽ mẽ ho hkra. Ja na pa harẽ. No mũjjaja mẽ akĩnhã kãm ja mar prãm kêt jakamã na htem ixujarẽnhja ma nẽ ãm kuma nẽ htỳx ri pa. ");
INSERT INTO apnNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","—No kêt mẽ kajaja na ka mẽ ixkôt ri apa ho apa. Nẽ xatã ixkapẽr mar o apa jakamã na ka mẽ aprĩ hã ixkapẽr ma. Tã mẽ ate ixkôt amnhĩ nhĩpêx o apa jakamã na pa tanhmã mẽ akrã hto ka mẽ aprĩ hã mar mex o mõ. No mẽ kot ixkapẽr mar nẽ ãm mar xwỳnhjaja na mẽ akĩnhã inhmar tỳx kêt nẽ. Jakamã nhũm Tĩrtũm tanhmã mẽ hkrã hto nhũm mẽ hã no hkêt tokyx anẽ htỳx ri pa. ");
INSERT INTO apnNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","“Ixte mẽ kãm aa mẽ kot mẽmoj pumunh kêt kwỳ ho anhỹr rax tã nhũm mẽ omu nẽ ãm omu. Nẽ ixte amnhĩ nhĩpêxja nhũm mẽ kãm hkĩnh kêt nẽ. Nẽ mẽ kot ixkapẽr mar tã ãm inhma nẽ kãm hprĩ hã inhmar prãm kêt nẽ.” —Jakamã na pa hte ã mẽ kãm mẽmoj te ho tãm pyrà nẽ harẽ no ãm hã haxwỳ nẽ mẽ kãm ixujarẽnh anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","15","—Na pre ra Tĩrtũm nhỹ hã kapẽr o pa xwỳnh Ijaisja amnepêm mẽ hkukamã tanhmã mẽ harẽnh to nẽ hã kagà. Mẽ kot inhmar nẽ ãm inhmar xwỳnhjê jarẽ nẽ tanhmã mẽ hkukamã mẽ harẽnh to nẽ mẽ harẽnh o: Koja mẽ ujarẽnh mex mar pymaj amnhĩ jamak pro nẽ amnhĩ no hpro nẽ hkôt hamaxpẽr kêt nẽ. Jakamã koja mẽ kãm mẽ kot amnhĩ nhĩpêx mex prãm kêt nẽ harẽnhja ma nẽ ãm kuma. Nẽ omu nẽ ãm omu. Mẽ kãm hprãm kêt jakamã koja mẽ ã amnhĩ nhĩpêx anẽ. Ã mẽ kot amnhĩ nhĩpêx anhỹr kêt ronhỹx mẽ ra Tĩrtũm kapẽr ma nẽ hkôt amnhĩ xunhwỳ. Hãmri nhũm amnhĩ tã mẽ omu nẽ mẽ nê mẽ kot amnhĩ tomnuj rênh pa. Hãmri nhũm mẽ hkôt amnhĩ nhĩpêx mex nẽ kapẽr mar mex o pa. Tã no nhũm mẽ Ã amnhĩ nhĩpêx anhỹr kêt nẽ. Anẽ. —Ã Ijaisja mẽ hkukamã mẽ harẽ nẽ mẽ hã kagà anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","—No kêt mẽ kajaja na ka htem ano ho ixte tanhmã amnhĩ nhĩpêx to ho ixpa hã ixpumunh o ixkôt apa. Nẽ mẽ ajamak o ixkapẽr mar o ri ixkôt apa. ");
INSERT INTO apnNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Amnepêm mẽ akukamã pahijaja nẽ Tĩrtũm nhỹ hã mẽ kãm kapẽr o ri mẽ pa xwỳnhjaja na prem kãm ixpumunh prãm tỳx o pa. Nẽ mẽ kãm ixkapẽr mar prãm tỳx o pa. No ãm mẽ akĩnhã ixpumunh nẽ ixkapẽr mar kêt rãhã htyk pa. Kormã ixwrỳk nẽ jar ixkator kêt jakamã na prem arĩ htĩr nẽ pa ri ixpumunh kêt rãhã ra htyk pa. Ãm mẽ kapxipixjaja na ka mẽ mỳr pê ixte amnhĩ nhĩpêx ã ixpumunh nẽ ixkapẽr mar o ixkôt apa. Tã mẽ kurom mẽ ate ano ho ixpumunh nẽ ajamak o ixkapẽr mar o ixkôt apa jakamã kwa mẽ ja hã amnhĩ pumu nẽ tãm amnhĩ nhĩpêx o ri apa pê akĩnh nẽ ri apa. Anẽ. Nhũm pre ã Jejus mẽ ixpê hkôt ixpa ho ixpa xwỳnhjê mã kapẽr anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Hãmri nhũm Jejus mẽ ixpê hkôt ixpa ho ixpa xwỳnhjê mã hprĩ hã mẽ ujarẽnhta jarẽ nẽ mẽ inhmã: —E kot paj ixprĩ hã mẽ amã mẽmo hy ho ukapêr xwỳnh ã ixujarẽnhta jarẽ ka mẽ inhma. Nà mẽmo hyta te kêp Tĩrtũm kapẽr pyràk. Nẽ ahpỹnhã mẽmo hy rôrôk ã pikata te kêp mẽ apê panhĩ ahpỹnhã mẽ ate Tĩrtũm kapẽr mar nẽ ahpỹnhã hkôt tanhmã amnhĩ nhĩpêx tota pyràk. ");
INSERT INTO apnNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Jakamã mẽ kot mar xwỳnh kwỳjaja te mẽ kot aptỳx kãm hy rôrôk nhũm kuwênh kot hwỳr mrar nẽ hkrẽr par xwỳnhta pyràk. Jao Tĩrtũm kapẽr ma no nhũm Satanasti te kuwênh kot hy krẽr parta pyrà nẽ mẽ kot mar nẽ amnhĩ kaxyw hkôt hamaxpẽr nẽ hkôt amnhĩ xunhwỳr pymaj hãmri ra tanhmã kapẽrja nê mẽ hkrã hto. Jakamã nhũm mẽ kuma nom ho hamakêtkati tokyx anẽ nẽ axte kãm hamaxpẽr kêt nẽ pa. ");
INSERT INTO apnNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","—Nẽ mẽ kot mar xwỳnh kwỳjaja te mẽ kot kẽnre kamã hy hkwỳ rôrôk nẽ higrõt nẽ grà par tokyx anhỹr xwỳnhta pyràk. Jao Tĩrtũm kapẽr ma nẽ hkĩnh nẽ. Nẽ kãm mar prãm nẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Tã nhũm mẽhõ Tĩrtũm nê tanhmã mẽ kãm kapẽr to nhũm mẽ kuma nẽ Tĩrtũm kaga. Te mẽmo hy higrõt nom ra grà par tokyx anhỹrta pyràk. ");
INSERT INTO apnNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","—Nẽ mẽ kot mar xwỳnh kwỳjaja te mrônhĩ kamã hy hkwỳ rôrôk nẽ higrõt nhũm mrônhĩ kot kêp àmnàr xwỳnhta pyràk. Jao mẽ kãm Tĩrtũm kapẽr mar prãm tã mããnẽn kãm mẽ hikukrêx rũnh nẽ mẽ hikàxpore rũnh prãm. Hãmri nẽ ãm ja pix kukamã hamaxpẽr o pa. Nẽ ja gryk ã axte Tĩrtũm kapẽr mã hamaxpẽr nẽ hkôt amnhĩ nhĩpêx kêt nẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","—Nẽ mẽ kot mar xwỳnh kwỳjaja te hirã kamã pika mex kãm hy hkwỳ rôrôk nẽ higrõt nẽ ô rũnhta pyràk. Jao ixkapẽr ma nẽ amnhĩ krã him hagjênh tỳx nẽ. Nẽ ixkôt ri amnhĩ nhĩpêx mex rãhã ho pa. Jakamã te mẽmo hy ô rũnh nẽ ô mex pyràk o amnhĩ nhĩpêx. E ã ixujarẽnhja kot anhỹr. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Nhũm Jejus axte mẽ kot mar o hkrĩ xwỳnhjê mã awjarẽ nom hprĩ hã mẽ kãm ujarẽnh kêt nẽ. Axte mẽ kãm mẽmoj tã kuxi nẽ awjarẽ nẽ mẽ kãm: —Nà nhỹrmã Tĩrtũm mẽ kot kormã htĩr ri tanhmã amnhĩ nhĩpêx to ho pa hã mẽ omunh xà hkôt ahpỹnhã tanhmã mẽ harẽnh toja te mẽ ujarẽnh ja pyràk. Koja mẽhõ harôj y mex o ukapêr kaxyw ma hpur mã mõ. Hãmri nẽ hkre hpa nẽ ma akupỹm mõ. ");
INSERT INTO apnNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Tã nhũm kamàt nhũm ra gõr nẽ nõ. Hãmri nhũm kãm hkurê xwỳnhja ma kêp ihpur wỳr tẽ nẽ harôj mexta nhĩpy axtem nẽ kêp harôj kaàkre hkre. Harôj kaàkreja te kot harôj mex pyràk nom mẽ kot hkur kêt. Tã nhũm kêp harôj y mex nhĩpy hkre hpa hãmri nẽ ma akupỹm tẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","—Tã nhũm hamẽ higrõt nẽ anhĩpê ô. ");
INSERT INTO apnNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Nhũm kãm mẽ àpênh xwỳnhjaja tee ri harôj mex kaêx ã harôj kaàkreta pumu nẽ hpur nhõ dõn wỳr tẽ nẽ kãm harẽ nẽ kãm: “Kwa ate harôj mex pix kre htã pẽr hkaêx ã harôj kaàkre mããnẽn kato. Kwa tanhmã na pre amnhĩ to nẽ hkaêx ã kato?” Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Hãmri nhũm tee ri mẽ kuma nẽ mẽ kãm: “Nà mẽhõ kãm ixkurê xwỳnh na pre ã inhĩpêx anẽ.” Anẽ hãmri nhũm kãm mẽ àpênh xwỳnhta kãm: “Kwa xà kot paj mẽ tokyx ma hwỳr mra nẽ nê harênh pa nẽ kurẽ nà?” Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Nhũm mẽ kãm: “Nà kot kaj mẽ anẽ nẽ harôj mexta mẽ ho apimrààtã ixpê harênh pa. ");
INSERT INTO apnNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Kwãr mãmrĩ harôj mex mẽ hpimrààtã ô hpa mãn. Ka mẽ rĩ ma hwỳr mra nẽ harôj kaàkre kumrẽx jarênh pa nẽ axpẽn tã harê ho ê nẽ ma o mra nẽ hpôk. Hãmri nẽ rĩ kormã hpãnhã harôj mex jakà nẽ ho akuprõ nẽ ô ho mra nẽ ixkre kamã haxwỳ.” Anẽ. Ã mẽ ujarẽnh kot anhỹr. Anhỹr o mẽ kãm kapẽr. ");
INSERT INTO apnNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","32","Hãmri nhũm Jejus arĩ mẽ kãm amnhĩ tã kuxi nẽ ujarẽnh o nhỹ. Nẽ tanhmã mẽ kãm amnhĩ tã ujarẽnh to nẽ mẽ kãm: —Nà Tĩrtũm kot mẽ awỳr ixte mẽ ato amnhĩptàr kaxyw inhmẽnh ã ijarẽnhja. Te ixte mẽmo hy pixire nhũm mẽ kot hkre nhũm higrõt pyràk. Koja gaa nẽ hprêk. Hãmri nẽ hpa anhgrà nhũm kuwênhre hwỳr mra nẽ hôptĩ kamã amnhĩm haê nhĩpêx nẽ kamã hikwỹ. Tã kot paj nhỹrmã mẽmo hy jarẽnhta pyrà nẽ ixpyxi htã pika piitã hkôt mẽ ho amnhĩptà nẽ mẽ omunh mex rãhã ho ixpa. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Nhũm Jejus arĩ mẽ kãm amnhĩ tã kuxi nẽ ujarẽnh o nhỹ nẽ mẽ kãm: —E kot pa hpãnhã mẽ amã tanhmã pãwti kaxkrit xà jarẽnh to ka mẽ inhma. Na hte mẽnijaja pãwti nhĩpêx kaxyw hãmri nẽ kaxkrit xà hkwỳ ho grire nẽ kupy nẽ trik xôm mẽ ho ahkà. Hãmri nẽ ho pãwti nhĩpêx. Kaxkrit xàja grire htã pãwti piitã ho kaxkrit mex nẽ. Tã ja pyrà nẽ ixpyxi htã koja mẽ nhỹrmã pika piitã hkôt ixkôt amnhĩ nhĩpêx mex o pa. Anhỹr o mẽ kãm amnhĩ jarẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Na pre ã Jejusja mẽ ujarẽnh o mẽ ahkre ho pa anẽ. Ãm mẽ ujarẽnh pix o mẽ ahkre ho pa. Te tãm ujarẽnh pyràk no ãm mẽmoj tã haxwỳ rỳ amnhĩ tã haxwỳ nẽ mẽ kãm tanhmã amnhĩ jarẽnh to. ");
INSERT INTO apnNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","ã kot mẽ ahkre ho pa anhỹr kukamã na pre ra amnepêm Tĩrtũm nhỹ hã kapẽr o mẽ pa xwỳnhjê hõja harẽ nẽ hã kagà. Te Jejus tãm tanhmã amnhĩ jarẽnh to pyràk o hkukamã harẽ nẽ hã kagà nẽ hã hkagà ho: Kot paj mẽ kãm ixujarẽnh pix kãm mẽ ahkre ho ri ixpa. Mẽmoj te ho tãm pyrà nẽ harẽ nom mẽmoj tã haxwỳ nẽ tanhmã mẽ kãm ixujarẽnh to. Nẽ aa mẽ kot mẽmoj mar kêt xwỳnh kwỳ kot paj mẽ kãm harẽ kê mẽ kuma. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Tã nhũm Jejus mẽ kãm ujarẽnh pa nẽ mẽ kure nẽ ma tẽn ixkrem axà. Hãmri pa mẽ ixpê hkôt ixpa ho ixpa xwỳnhjaja ma hkôt mra nẽ ixkrem agjê. Hãmri nẽ harôj kaàkre hã ujarẽnhta ã hkukja nẽ kãm: —Kwa aprĩ hã mẽ inhmã harôj kaàkre jarẽnhta jarẽ nà. Na pa mẽ kormã ixprĩ hã mar mex kêt nẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Hãmri nhũm mẽ inhmã: —Tôe pa ixprĩ hã mẽ amã harẽ. Ãm paa. Ixpê Tĩrtũm kot mẽ awỳr inhmẽnh xwỳnh te ixte mẽmo hy mex o ukapêr xwỳnhta pyràk. ");
INSERT INTO apnNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Nẽ purta te kêp pika piitã pyràk. Nẽ harôj mexta te ra mẽ ate ixkôt amnhĩ xunhwỳr nẽ ixkôt amnhĩ nhĩpêx o apa xwỳnhjê pyràk. Nẽ harôj kaàkreta te mẽ kot Satanasti hkôt amnhĩ nhĩpêx o mẽ pa xwỳnhjê pyràk. ");
INSERT INTO apnNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Nẽ kot harôj kaàkre hkre xwỳnhta te Satanasti pyràk. Nẽ harôj jakàr xà hã arĩgrota te Tĩrtũm kot ahpỹnhã tanhmã mẽ harẽnh to xà hã arĩgrota pyràk. Nẽ mẽ kot harôj jakàr xwỳnhjaja te Tĩrtũm kapẽr o wrỳk xwỳnhjê pyràk. ");
INSERT INTO apnNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Mẽ ujarẽnhja kamã na prem harôj kaàkre kumrẽx jarê nẽ hã hpôk jarẽ. Ja pyrà nẽ koja nhỹrmã Tĩrtũm kot ahpỹnhã tanhmã mẽ harẽnh to xà hã arĩgrota ã hãmri ã mẽ kot amnhĩ tomnuj o mẽ pa xwỳnhjê nhĩpêx anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","—Kot paj nhỹrmã kãm mẽ piitã mẽ ho amnhĩptàr kaxyw hãmri nẽ kapẽr o mẽ wrỳk xwỳnhjê mã anẽ nhũm mẽ ma mran wrỳ nẽ mẽ kot amnhĩ tomnuj xwỳnhjê pix o akuprõ. Nẽ mẽ kot nhãm mẽ hkwỳjê kot mẽ uràk nẽ tanhmã amnhĩ tomnuj to ho pa kaxyw mẽ kãm anhỹr xwỳnhjaja nhũm mẽ mããnẽn mẽ ho akuprõ. ");
INSERT INTO apnNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Hãmri nẽ mẽ ho pikuprõnh pa nẽ te mẽ kot harôj kaàkreta nhĩpêx pyrà nẽ kuwy kamã mẽ rẽnh pa. Hãmri nhũm mẽ kamã amnhĩ xà htỳx kamã hamak rãhã nẽ pa ho pa. Nẽ amnhĩ xà htỳx ã maj tee ri mỳr rãhã ho pa. Nẽ tee ri amnhĩ xà hã maj amnhĩ nham o axpẽn kamnhar tỳx kaprỳ. ");
INSERT INTO apnNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","—No ixkôt mẽ kot amnhĩ nhĩpêx xwỳnhjaja koja mẽ mẽ kurom mex kumrẽx nẽ pa. Kot paj mẽ ho mex rax nẽ nhũm mẽ mex rãhã nẽ pa ho pa. Tĩrtũm kot kormã pika nyw nhĩpêx mã xwỳnhta kamã nhũm mẽ mex kumrẽx nẽ pa ho pa. E kêr ka mẽ ixujarẽnhja ma nẽ kãm ajamaxpẽr tỳx rãhã ho apa. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Nhũm Jejus arĩ mẽ ixpiitã mẽ inhmã tanhmã ujarẽnh to. Nom hprĩ hã ujarẽnh kêt nẽ. Kê axte mẽmoj tã kuxi nẽ mẽ inhmã tanhmã ujarẽnh to nẽ mẽ inhmã: —Mẽ ate ixkôt amnhĩ xunhwỳr xwỳnhjaja te mẽ apê mẽ hikukrêx mex ã pika japrôr xwỳnhta pyràk. Koja mẽhõ mẽ hikukrêx mex jamỳ nẽ o tẽ nẽ nhỹri amnhĩm ho amũxu. Kaxyw kakwỳ nẽ kamã hagjê nẽ hity hpa nẽ ma akupỹm tẽ. Hãmri nhũm jãã nhũm mẽhõ tẽn kãm kato. Hã pikata kakwỳ nẽ kãm kato nẽ omu nẽ hkĩnh nẽ. Nẽ hamaxpẽr o: “E pa ma tẽ nẽ inhõrkwỹ kamã ixkukrêx piitã ho wẽnê hpa nẽ hpãnhã kàxpore jamỳ nẽ ho amnhĩm mẽ hikukrêx mex ã pika japrô nẽ amnhĩm mẽmoj mexta o ixàrĩk pa.” Anhỹr o hamaxpẽr nẽ akupỹm hity hpa nẽ ma akupỹm tẽ. Hãmri nẽ mẽmoj mexta gryk ã õ mẽmoj piitã ho wẽnê hpa. Hikukrêx nẽ õrkwỹ nhũm piitã ho wẽnê hpa. Hãmri nẽ hpãnhã kàxpore jamỳ nẽ ma o tẽ nẽ amnhĩm pikata japrô. Hãmri nẽ ma akupỹm hwỳr tẽ nẽ kamã mẽ hikukrêx mexta kwrỳnh pa nẽ ho õ kumrẽx. —Tã te mẽ ate mẽhõ kot ã amnhĩ nhĩpêx anhỹr xwỳnhta pyràk. Na ka mẽ uràk nẽ inhgryk ã amnhĩ tomnuj kaga hpa nẽ hpãnhã ixkôt amnhĩ nhĩpêx. Te mẽhõ kot mẽmo mẽ hikukrêx mex gryk ã hikukrêx tũm piitã kaga hpar nẽ mẽ hikukrêx mex o hpimxur xà hã pikata japrôr pyràk. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Nhũm Jejus arĩ mẽ inhmã awjarẽ nẽ mẽ inhmã: —Nẽ ja. Na htem kãm hkĩnh nẽ hamakêtkati nẽ ri hpa hprãm xàj Tĩrtũm kôt amnhĩ xunhwỳ nẽ hkôt ri amnhĩ nhĩpêx rãhã ho pa. Te mẽhõ my kãm kẽn jaxênh mex prãm nẽ ma ri hapêr o pa xwỳnhta pyràk. ");
INSERT INTO apnNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Nẽ ra nhỹri omu nẽ ma tẽ nẽ prês ã mẽ hkukja. Nhũm mẽ kãm hã ho ohtô nẽ harẽ nhũm ma akupỹm tẽ nẽ kãm ho õ hprãm xàj hikukrêx piitã ho wẽnê hpa. Hãmri nẽ kàxpore jamỳ nẽ o tẽ nẽ amnhĩm ho haprô. Kẽn jaxênh mexta pix gryk ã hikukrêx piitã ho wẽnê hpa nẽ hpãnhã ho amnhĩm haprô. —Tã ja pyrà nẽ na ka htem amex nẽ ajamakêtkati nẽ axàmnhĩx ri apa hprãm xàj ixkôt amnhĩ xunhwỳ nẽ ixkôt pix mã amnhĩ nhĩpêx o apa. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","48","Nhũm Jejus arĩ mẽ inhmã awjarẽ nẽ mẽ inhmã: —E Tĩrtũm kot nhỹrmã tanhmã mẽ harẽnh to xà hã arĩgro kot paj ixprĩ hã tanhmã mẽ amã harẽnh to. Te ho mẽmyjaja kot himô kamã kryhti rẽnh pyràk. Koja mẽ gôx kãm kumẽ nẽ akupỹm ho api nhũm kamã tep ohtô nẽ. Nhũm omu nẽ kỳx pê amgrà kamã hkapĩ nẽ ahpỹnhã ri tanhmã kamã kute kawrà. Nẽ kamã mex kawrà nẽ kawà kamã kugjê nẽ mẽ kot hkur kêtja nhũm nhãm kurẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Ja pyrà nẽ Tĩrtũm kot ahpỹnhã ri tanhmã mẽ kot amnhĩ nhĩpêx to hã mẽ omunh xà hkôt tanhmã mẽ hipêx to kaxyw arĩgrota ã ã mẽ hipêx anẽ. Koja kapẽr o mẽ wrỳk xwỳnhjaja mẽ kot hkôt amnhĩ xunhwỳr xwỳnhjê nê mẽ kot amnhĩ tomnuj o mẽ pa xwỳnhjê kawrà hpa. ");
INSERT INTO apnNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Nẽ te mẽ kot tep mex nê tep punu kawrà nẽ nhãm rẽnhta pyràk o mẽ hipêx nẽ ma kuwy hwỳr mẽ o mra nẽ kamã mẽ kurẽ. Nhũm mẽ tee ri amnhĩ xà htỳx ã maj amỹra nẽ tee ri amnhĩ nhĩpêx kaprỳ. Anẽ. Nhũm pre ã Jejusja axte mẽ ixpê hkôt mẽ ixpa ho mẽ ixpa xwỳnhjê mã ujarẽnh anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Hãmri nẽ mẽ inhmã: —E xàn ka mẽ atã aprĩ hã ixujarẽnhta ma nà? Anẽ pa mẽ kãm: —Tỳ. Nà na pa mẽ atã ixprĩ hã mar mex nẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Hãmri nhũm mẽ inhmã: —Tôe. Nà ãm hãmri. Na ka xep mẽ ra ixte mẽ ahkre nywta mar mex nẽ. Nẽ mẽ akwỳjaja mããnẽn Tĩrtũm kapẽr tũm mar mex nẽ. Te mẽ apê mẽhõ apkur xà rax pyrà nẽ ma ho mẽ piitã mẽ hipêx o ri mẽ hkôt paja pyràk. Ja pyrà nẽ kêr ka mẽ ma mẽ piitã mẽ hkôt Tĩrtũm mẽ wa ixkapẽr o mẽ ahkre ho ri mẽ hkôt apa. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","ã Jejus mẽ inhmã ujarẽnh par anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Hãmri nẽ ma akupỹm Najare hwỳr mõ nẽ Tĩrtũm kapẽr o mẽ ahkre xà hã ixkre hwỳr tẽ nẽ axà nẽ mẽ ahkre ho nhỹ. Nhũm mẽ amnhĩ jaêr pê tanhmã kot mẽ ahkre hto hã kuma nẽ tee ri hkukamã hamaxpẽr nẽ axpẽn mã: —Tk. Kwa kêp mẽ panhĩõ htã tanhmã kot we amnhĩ to nẽ ã àhpumunh tỳx kôt mẽ pamã kapẽr anẽ nẽ ri mẽ kãm aa mẽ kot mẽmoj pumunh kêt kwỳ ho anhỹr o pa? ");
INSERT INTO apnNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","56","Na pre mẽ panoo mã hprêk nhũm mẽ pahte pahprĩ hã hkwỳjê pumunh. Kêp pĩ kuprãr xwỳnh Juje mẽ hprõ Marir wa hkraa. Nẽ kêp Xiakre nẽ Juje nẽ Simãw nẽ Jut mẽ htõõ. Nẽ htõxjaja jar mẽ pakamã pa nhũm mẽ pahte mẽ piitã mẽ omunh mex kênã kot kêt we mẽ kurom ã àhpumunh tỳx anẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Hãmri nẽ kamã gryk nẽ hkaga. Hãmri nhũm tee ri amnhĩ tã mẽ omu nẽ mẽ kãm: —Nà Tĩrtũm nhỹ hã kapẽr jarẽnh o mẽ pa xwỳnhjaja na htem krĩ hkwỳ kamã kãm mẽ mar prãm nẽ. Nom õ krĩ kamã mẽ kot karàre rũm hprêk kãm omunh xwỳnhjaja na htem kuma nẽ ãm kuma. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Tã mẽ kot amnhĩ kaxyw hkôt hamaxpẽr kêt jakamã nhũm tee ri mẽ kãm aa mẽ kot mẽmoj pumunh kêt kwỳ ho anhỹr rax prãm. No ãm mẽ kãm mẽmoj to grêre nẽ ho anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Tã nhũm pika pê Garirej kamã mẽõ pahihti Erox Jejus jarẽnh ma ");
INSERT INTO apnNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","nẽ tee ri hkukamã hamaxpẽr nẽ hã õ pôristi mã kapẽr nẽ mẽ kãm: —Kwa pẽr Juãw Paxis na nà? Ra ixte hã ixàmnênh nhũm mẽ kot hpĩr tã mãn tanhmã amnhĩ to nẽ akupỹm htĩr. Nà pẽr tãm kênã. Jakamã na hte aa mẽ kot mẽmoj pumunh kêt kwỳ ho anhỹr o pa. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","5","Na pre ra Erox htõ pê hprõptàn ho hprõ. Tõ arĩ htĩr tã nhũm axtem nẽ kêp utà nẽ ho hprõ. Hãmri nhũm Juãw Paxisja harẽnh ma nẽ hã kãm akir nẽ kãm: —Kwa Eroxis kêp atõ hprõ kênã na ka kêt axtem nẽ kêp utà nẽ ho aprõ. Kwa ja omnuj tỳx o omnuj tỳx. Anẽ. Hãmri nhũm amnhĩ tã kuma nẽ kamã gryk nẽ kot hpĩr kaxyw. Tã nom nhũm Ijaew kot axpẽn mã kêp Tĩrtũm nhỹ hã kapẽr jarẽnh xwỳnh ã harẽnh jakamã nhũm mẽ umaj hpĩr kêt nẽ. Ãm ho prês nẽ haxà nhũm hkrĩ ho hkrĩ. ");
INSERT INTO apnNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Tã nhũm jãã nhũm Erox kator ã arĩgro kato nhũm mẽ hã akuprõ nẽ hã hkĩnh. Hãmri nhũm hprõ nyw kra niti mẽ hwỳr axà nẽ ahte mẽ hipôk ri mẽ kãm gre. Mẽ kot omunh nẽ kamã hkurẽ kaxyw nhũm mẽ noo mã hpijaàm kêt nẽ mẽ kãm grer o xa. Hãmri nhũm pahi Erox omu nhũm ja kãm mex nẽ nhũm hkĩnh nẽ kamã nopyma nẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Hãmri nẽ kãm: —Nà ãm hãmri na ka ã mẽ inhmã amnhĩ nhĩpêx anẽ. Jakamã kwa mãmrĩ mẽmoj tã ixwỳ. Amã mẽmoj prãm xà hkôt hã ixwỳ kot paj amã kugõ. Ãm hãmri na pa amã anẽ. E mẽmoj na amã hprãm? Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Hãmri nhũm kuma nẽ kãm: —Ma Juãw Paxis krã na pa inhmã hprãm. Inhmã hkrã krãhta nẽ pasiiti kamã axà nẽ ixwỳr o tẽ nẽ inhmã agõ. Anẽ. Ra katorxà kot kaxyw kãm karõ jakamã nhũm ã hã hwỳr anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Hãmri nhũm Eroxja tee ri kuma nhũm ja kêp omnuj nẽ. Nom ra mẽ pikuprõnh rax xwỳnhjê nhĩpôk ri mẽ noo mã kot kãm: “E mãmrĩ amã mẽmoj prãm xà hkôt hã ixwỳ pa amã kugõ.” Anhỹr jakamã kãm kot kêp nê hprãm kêt nẽ. Hãmri nẽ Juãw Paxis wỳr õ pôristi hkwỳ rẽ ");
INSERT INTO apnNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","nhũm mẽ ma mẽ hagjênh xàta wỳr mra nẽ unê nẽ mut krãhta. ");
INSERT INTO apnNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Hãmri nẽ hkrã mỳ nẽ pasiiti kamã kuxà nẽ ma akupỹm nita wỳr o tẽ nẽ kãm kugõ nhũm kumỳ nẽ ma katorxà hwỳr o tẽ nẽ kãm kugõ. ");
INSERT INTO apnNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Hãmri nhũm Juãw Paxis kôt mẽ pa xwỳnhjaja tee ri mẽ kot hpĩr ã harẽnh ma nẽ ma hwỳr mra nẽ kumỳ nẽ ma o mõn haxà. Hãmri nẽ ma Jejus wỳr mra nẽ kãm harẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Hãmri nhũm Jejus Juãw Paxis jarẽnh ma nẽ hkaprĩ nẽ. Nẽ ma himô nhĩkjê hwỳr kapôt ã mõr kaxyw pàr krem axà nẽ ma mõ. Pa mẽ hkôt ixpa ho ixpa xwỳnhjaja ma hkôt mra. Hãmri nhũm krĩ hkwỳ kamã mẽ pa xwỳnhjaja harẽnh ma nẽ ohtô nẽ ma mẽ inhĩhkrep pikap mra. Nẽ ra amnhĩ to wa nẽ mẽ inhmõr xàja wỳr pôj nẽ mẽ ixkutêp hkrĩ. ");
INSERT INTO apnNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Jakamã pa mẽ mõ nẽ mẽ hwỳr pôj nẽ mẽ omu. Hãmri nhũm Jejus mẽ omu nẽ kãm mẽ hkaprĩ nẽ mẽ kãm mẽ à xwỳnhjê ho mex pa. ");
INSERT INTO apnNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Tã nhũm ra myt àr kaxyw pa mẽ hkôt ixpa ho ixpa xwỳnhjaja tee ri mẽ omu nẽ Jejus wỳr mra nẽ kãm: —Kwa na ra amỹkry htỳx nẽ. Amnhĩ nê mẽ hano kê mẽ ma nhỹri krĩ hkwỳ hwỳr mra nẽ tokyx amnhĩm mẽmoj japrô nẽ kuku. Mo jar mẽ apkur xà hã mẽõ? Jar akunĩ pix kênã. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Hãmri nhũm mẽ inhma nẽ mẽ inhmã: —Nà kot paj mẽ hanor kêt nẽ. Mẽ kajaja kot kaj mẽ kãm õ nhũm mẽ apku. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","21","No nhũm mẽ ohtô rax kumrẽx. Mẽmyjaja kêp 5.000. Nẽ kaxyw mẽ hprõ nẽ mẽ hkrajaja. Jakamã nhũm Jejus ã mẽ inhmã kapẽr anẽ pa mẽ tee ri mẽ hkukamã ijamaxpẽr nẽ kãm: —Kwa nà mẽ panhõja raxti hã. Mẽ panhõ pãwti kêp sĩk pix. Nẽ kaxyw tep gràja pijakrutre kênã kot kêt mẽ piitã mẽ hipêx. Nà xà kot paj mẽ ma mra nẽ nhỹri mẽ kãm mẽ mẽmoj japrô nhũm mẽ kuku? Anẽ. Hãmri nhũm mẽ inhmã: —Nà pu mẽ kãm mẽmoj japrôr kêt nẽ. Kot puj mẽ kãm mẽ panhõta o anhgrà. E mẽ kãm anẽ kê mẽ ahpỹnhã ri hije nẽ hkrĩ hpa. Anẽ. Hãmri pa mẽ kuma nẽ mẽ kãm anẽ nhũm mẽ piitã hkrĩ hpa. Hãmri nhũm Jejus pãwti mẽ tepja jamỳ nẽ kaxkwa hwỳr rĩt nẽ ho Tĩrtũm wỳ nẽ kãm: —Pa Papaj? Nà apê mẽ inhmã mẽ inhõ ho apa xwỳnh jakamã amex o amex. Anẽ. Hãmri nẽ mẽ kãm ho hkry hpa nẽ hkôt mẽ ixpa ho mẽ ixpa xwỳnhjê mã kugõ pa mẽ ô ri ho mẽ hipêx pa. Nhũm mẽ piitã apkur o hkrĩ. Mẽõja grire htã nhũm Jejus tanhmã mẽ kãm ho rax to nhũm mẽ ohtô rax kumrẽx tã piitã kuku nẽ ho õhy htu hpa nhũm arĩ mẽõ jakrêx prã. Hãmri pa mẽ akupỹm hakrêx o akuprõ nẽ ho kawà ho 12 nẽ ho nỳt pa. ");
INSERT INTO apnNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","23","Tã nhũm Jejus mẽ ixpê hkôt ixpa ho ixpa xwỳnhjê mã anẽ pa mẽ akupỹm pàr mã agjê nẽ ma xarmã hkukamã mõ. Hãmri nhũm mẽ kot mar o kuhê xwỳnhjê jano nhũm mẽ ma akupỹm hapêx. Hãmri nhũm Jejus kot Tĩrtũm mã amnhĩ jarẽnh kaxyw ahte tẽ nẽ hixêt ã api nẽ himõk ã kãm amnhĩ jarẽnh o nhỹ. Gaa nhũm ra kamàt nhũm arĩ ahte hixêt nhĩmõk ã nhỹ. ");
INSERT INTO apnNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Rôm pa mẽ pàr kãm mẽ inhmõr xwỳnhjaja kormã himô nhĩpôk ri mõ. Pu nhũm kôk xàpêr tỳx mẽ ixkaxpa. Nẽ gô axpẽn tak tỳx nẽ pa mẽ tee ri rrẽmti ho gô rẽnh nhĩpêx nẽ tee ri axpẽn pumu. ");
INSERT INTO apnNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Tã nhũm krãhyre kà nhũm Jejus man mẽ ixkôt gô krãhkà hã xan tẽ ");
INSERT INTO apnNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","pa mẽ amnhĩ wỳr omu. No nhũm kormã hirã mex kêt jakamã pa mẽ ixprĩ hã omunh mex kêt nẽ. Hãmri nẽ tee ri omu nẽ mẽkarõ hã hkamnhĩx nẽ umaj ixàmra rax nẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Hãmri nhũm mẽ inhmã kapẽr nẽ mẽ inhmã: —Tk. Kwa mẽ amã ma hkêt nẽ. Pa na pa mẽ akôt tẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Hãmri nhũm Simãw Pêtre kuma nẽ kãm: —Kwa xà ka na ka tẽ? Tôe apê mẽ inhõ Pahihti jakamã kwa amnhĩ wỳr ixwỳ pa apyrà nẽ gô krãhkà hã xa nẽ awỳr tẽ nà? Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Hãmri nhũm kãm: —Tôe mamrĩ amnẽ ixwỳr tẽ. Anẽ. Hãmri nhũm kuma nẽ pàr rũm kato nẽ hwỳr tẽ. Uràk nẽ gô krãhkà hã hwỳr tẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Hãmri nẽ kormã htêp o htẽm mẽ kôk xàpêrta kamã ama nẽ tee ri amnhĩ kukamã hamaxpẽr pê ra àr o mõ. Hãmri nẽ àmra kamã Jejus mã amnhĩ to akir nẽ kãm: —Kwa tokyx ixto api Pahihti. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Hãmri nhũm hpa hã kupy nẽ ho àpir kurê kumrẽx nẽ kãm: —Kwa pẽr ãm kormã ate amnhĩ kaxyw inhmã ajamaxpẽr tỳx kêt. Mon ka we ixkamnàr rom mãmrĩ man ixwỳr atẽmre hkêt nẽ? Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Hãmri nhũm wa akupỹn mẽ ixwỳr tẽ nẽ wa axà. Hãmri nhũm kôk katàt kôt pinhkrênh pa nhũm gô tãm nõr kurê kumrẽx. ");
INSERT INTO apnNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Hãmri pa mẽ Jejus kot ã amnhĩ nhĩpêx anhỹrja ã omu hãmri nẽ kãm mex o mex ã harẽ nẽ kãm: —Kwa ãm hãmri na hte amnhĩ pê Tĩrtũm Kra hã amnhĩ jarẽ. Nà apê Kra kênã. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Tã pa mẽ ra himô hã rê nẽ Jenẽjare hwỳr pôj. ");
INSERT INTO apnNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Hãmri nẽ ma kapê hã ri ixpa. Hãmri nhũm pika nhõ xwỳnh kwỳjaja Jejus pumu nẽ mẽ piitã mẽ kãm harẽnh o hprõt nẽ ahpỹnhã hwỳr nhỹhỹnh mẽ à xwỳnhjê hã karõ. Nhũm mẽ man mẽ ixwỳr mẽ o mra ");
INSERT INTO apnNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","nẽ mẽ ho Jejus wỳ nẽ kãm: —Pa? Kwa kê mẽ à xwỳnhjaja akupỹm mex kaxyw apê axê kupê nà? Anẽ. Hãmri nhũm mẽ kãm: —Tôe. Kwãr mẽ mãmrĩ mran hkupê. Anẽ. Hãmri nhũm mẽ kuma nẽ axpẽn pãnhã hwỳr mra nẽ kêp ê pix kupênh tã ra akupỹm mex nẽ ma akupỹm mra. ");
INSERT INTO apnNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Tã nhũm Parijew nhõ xwỳnh mẽ Tĩrtũm kapẽr tũm o mẽ ahkre ho mẽ pa xwỳnhjaja Jerujarẽ rũm ma Jejus wỳr mra. Na htem mẽ ixkukamã mẽ inhĩgêtjê pyrà nẽ apkur kaxyw nẽ amnhĩ nhĩhkra kuhõnh ryy nẽ. Amnhĩ nhĩhkra htyk pix kuhõnh nẽ hkrĩ hkêt nẽ ãm amnhĩ nhĩhkra kuhõnh japjêê nẽ. Nẽ õ prat kuhõnh japjêê nẽ kormã apkur kaxyw hkrĩ. Tĩrtũm kot ja hã mẽ omunh nẽ mẽ mex ã mẽ harẽnh ã amnhĩ kamnhĩx jakamã na pre ã amnhĩ nhĩpêx anhỹr o pa. Jakamã nhũm mẽ ma Jejus wỳr mra. ");
INSERT INTO apnNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","Hãmri nẽ omu nẽ kãm: —Pa Jejus? E kwa mẽ inhmã mẽmoj jarẽ. Amnepêm mẽ panhĩgêtjaja na prem apkur kaxyw nẽ amnhĩ nhĩhkra kuhõnh japjê nẽ rĩ kormã apku. Tã pa htem arĩ ijaxwỳja ã amnhĩ nhĩpêx anẽ. No akôt mẽ pa ho mẽ pa xwỳnhjaja na htem mẽ ixpyrà nẽ ã amnhĩ nhĩpêx anhỹr kêt nẽ. Kwa mo na htem amnhĩ nhĩhkra tyk kuhõnh tokyx anẽ nẽ hkrĩ nẽ apku? Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Hãmri nhũm mẽ kuma nẽ mẽ kãm: —Tk. Na ka htem ãm mẽ panhĩgêtjê hkôt pix mã amnhĩ nhĩpêx o apa no Tĩrtũm kapẽr kôt amnhĩ nhĩpêx kêt nẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Tĩrtũm na pre mẽmoj tã mẽ pamã karõ ho: Kêr ka mẽ anhĩpêêxà nẽ mẽ akatorxà wa hã apijaàm nẽ mẽ ho ajuta rãhã ho ri apa. Kot kaj mẽ ã amnhĩ nhĩpêx anhỹr kêt nẽ tanhmã mẽ kãm akapẽr punuj to ho ri apa. Hã koja mẽ akwỳjaja ja mỳrapê mẽ apa. Anẽ. —Na pre ã Tĩrtũmja mẽ pamã karõ anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","No mẽ kajaja na ka htem ã akwỳjê mã karõ anhỹr kêt nẽ. Ãm kapẽrja kwỳm na ka htem mẽ kãm karõ nẽ mẽ kãm: Kot kaj mẽ mẽmo arĩgro hã akàxpore japêr nom kêr ka mẽ ho tanhmã akatorxà rỳ anhĩpêêxà ho ajuta hto kaxyw wa kãm hkwỳ nhõr kêt nẽ. Ãm ho ate wa ho ajuta hkêt ã wa kãm amnhĩ jarẽ hãmri nẽ Tĩrtũm mã amnhĩ jarẽnh xà hã ixkre hwỳr o tẽ nẽ mẽ ixte tanhmã ixkreta ho mex to kaxyw mẽ inhmã agõ. Kot kaj mẽ ã amnhĩ nhĩpêx anẽ nhũm Tĩrtũm ja hã mẽ apumu nhũm ja kãm mex nẽ. Kêr ka mẽ ã amnhĩ nhĩpêx anhỹr o ri apa. —Anhỹr o na ka htem mẽ kãm karõ ho ri apa. ");
INSERT INTO apnNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Nom Tĩrtũm kapẽr tũm kot ã ja jarẽnh anhỹr kêt. Ãm amnhĩ krã hkôt na ka htem ã mẽ kãm karõ punuj o ri apa anẽ. Te mẽ akapẽrja mex o kot Tĩrtũm kapẽr jakrenh pyràk. ");
INSERT INTO apnNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Mẽ ate Tĩrtũm kôt amnhĩ nhĩpêx ã amnhĩ jarẽnh tã ãm amnhĩ to axêx nẽ hkôt amnhĩ nhĩpêx kêt nẽ. Na pre Tĩrtũm amnepêm mẽ akukamã tanhmã mẽ ajarẽnh to. Nhũm ỹ hã mẽ kãm kapẽr jarẽnh xwỳnh Ijaisja ô ri mẽ kãm mẽ ajarẽ nẽ hã kagà. Te Tĩrtũm tãm kot mẽ ajarẽnh pyràk. ");
INSERT INTO apnNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Na pre mẽ akukamã mẽ ajarẽnh o: Mẽ kãm ixkĩnh ã mẽ kot amnhĩ jarẽnh tã mẽ kãm ixkĩnh kêt. Na htem kãm ixprãm ã amnhĩ jarẽnh kaprỳ. ");
INSERT INTO apnNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Mẽ kot ixkuhpa hã amnhĩ krã hkôt mẽmoj tã hkwỳjê mã karõ ho pa jakamã na htem kot ixkôt amnhĩ nhĩpêx o pa hã amnhĩ jarẽnh kaprỳ. Anẽ. —Na pre ã Ijaisja Tĩrtũm nhỹ hã mẽ akukamã mẽ ajarẽ nẽ mẽ atã kagà anẽ. Anẽ. Nhũm pre ã Jejus Parijew nhõ xwỳnhjê mẽ Tĩrtũm kapẽr tũm o mẽ ahkre xwỳnhjê mã kapẽr anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Tã nhũm Jejus amnhĩ wỳr mẽ kot mar o kuhê xwỳnhjê hwỳ nẽ axte mẽ kãm kapẽr nẽ mẽ kãm: —E mẽ inhma nẽ inhmar tỳx nẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Na hte Tĩrtũm kapẽr tũm o mẽ ahkre xwỳnhjaja amnhĩ krã hkôt mẽ ate amnhĩ nhĩhkra kuhõnh japjê hã mẽ amã karõ ho pa. Nẽ amnhĩ krã hkôt mẽ axàpkur xà hã tanhmã mẽ amã karõ hto ho pa. Tĩrtũm kot ja hã mẽ apumunh kôt mẽ amex ã mẽ ajarẽnh kaxyw ã mẽmoj tã mẽ amã karõ anẽ. Nom na hte Tĩrtũm tanhmã mẽ kot amnhĩ nhĩhkra kuhõnh to hã mẽ omunh xà hkôt tanhmã mẽ harẽnh to hkêt nẽ. Rỳ mẽ axàpkur xà pumunh kôt mẽ mex ã mẽ ajarẽnh kêt nẽ. Ja tanhmã kãm kute hkêt. Na hte ã mẽ kot amnhĩ nhĩpêx anhỹr ã mẽ omunh xà hkôt mẽ mex ã mẽ harẽnh rỳ mẽ mex kêt ã mẽ harẽnh kêt nẽ. Na hte mẽmoj kur ã mẽ omu nẽ ãm mẽ omu nẽ hã tanhmã mẽ harẽnh to hkêt nẽ. Ãm mẽ kapẽr punuj rỳ mẽ kapẽr mex ã mẽ mar kôt pix mã na hte tanhmã mẽ harẽnh to. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Nhũm pre ã Jejus mẽ kãm kapẽr anẽ pa mẽ hkôt mẽ ixpa ho mẽ ixpa xwỳnhjaja kuma hãmri nẽ hwỳr mra nẽ kãm: —Kwa na ka ã mẽ kãm akapẽr anẽ nhũm Parijew nhõ xwỳnhjaja tee ri ama nhũm ja mẽ kêp omnuj nẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","14","Hãmri nhũm mẽ inhma nẽ tanhmã mẽ inhmã Parijew nhõ xwỳnhjê jarẽnh to nẽ hprĩ hã mẽ hkukamã mẽ harẽnh o: —Tk. Kwãr mãmrĩ mẽ kêp omnuj. Mẽ kot Tĩrtũm kapẽr tũm o mẽ ahkre ho pa htã na htem hkôt amnhĩ nhĩpêx kêt. Jakamã te mẽ nohkre xwỳnh kot amnhĩ nhĩpêx pyràk. Koja mẽhõ nohkre htã amnhĩ kôt nhỹhỹm nohkre hõ ho mõ hãmri nẽ wa hamẽ pry pumunh kêt nẽ htỳx mõ hãmri nẽ nhỹri ahkrehti kamã tẽm. Tã Parijew nhõ xwỳnhjaja te kot wam htẽm xwỳnhta pyràk nhũm mẽ kot mẽ mar xwỳnhjaja te kot wam htẽm xwỳnh kôt hõ htẽmta pyràk. Jakamã Parijew nhõ xwỳnhjaja mẽ kot mẽ mar o pa xwỳnhjê mẽ koja mẽ hpimrààtã nhỹrmã te ahkrehti kamã rôrôk par pyràk o amnhĩ nhĩpêx nẽ mex kêt nẽ pa ho pa. Koja kaxkwa kamã inhõ Papaj nhỹrmã amnhĩ nê mẽ hanor pa. —Inhõ Papaj te kêp mẽmo hy hkre ho pa xwỳnhta pyràk. Na htem mẽmo hy hkre nhũm higrõt hapôj nẽ higrõt mex nẽ. Hãmri nhũm mẽ hwỳr mra nẽ omu nẽ nê mẽmoj nhĩgrõt punuj jarê nẽ kurẽ. Ja pyrà nẽ koja nhỹrmã inhõ Papaj amnhĩ nê Parijew nhõ xwỳnhjê janor pa nhũm mẽ mex kêt nẽ pa ho pa. Jakamã kwa kêr ka mẽ hkôt ri amnhĩ nhĩpêx kêt nẽ. Anẽ. Nhũm pre ã Jejus mẽ ixte hkôt ixpa ho ixpa xwỳnhjê mã hprĩ hã Parijew nhõ xwỳnhjê hkukamã ã mẽ harẽnh anẽ pa mẽ mar o ixkrĩ. ");
INSERT INTO apnNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Hãmri nhũm Simãw Pêtre tee ri Tĩrtũm kot mẽ apkur xà hã mẽ omunh xà hkôt tanhmã mẽ harẽnh to hkêt ã harẽnh ma. Nẽ ãm tanhmã mẽ kapẽr to pix ã mẽ mar kôt tanhmã mẽ harẽnh toja ma hãmri nẽ hã Jejus kukja nẽ kãm: —Kwa mon ka ri ã ja jarẽnh anẽ Pahihti? Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Hãmri nhũm kuma nẽ hprĩ hã mẽ inhmã awjarẽ nẽ mẽ inhmã: —Kwa xàn ka mẽ kormã aprĩ hã ja mar kêt nẽ? ");
INSERT INTO apnNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","E pa ixprĩ hã mẽ amã harẽ ka mẽ inhma. Nà na htem mẽmoj ku nhũm hte mẽ hkrã hi hwỳr gjêx kêt nẽ. Na hte mẽ õhy pix wỳr agjê nẽ gaa nẽ nhãm hapôj nẽ hapêx. Na htem mẽ apkur xàja ku nẽ ỹ hã tanhmã amnhĩ tomnu hto hkêt nẽ. Jakamã na hte Tĩrtũm ja hã mẽ omunh xà hkôt tanhmã mẽ harẽnh to hkêt nẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","ãm mẽ hkrã kamã mẽ hamaxpẽr punuj pix nhỹ hã mẽ kot tanhmã amnhĩ tomnuj to jakamã na hte Tĩrtũm mẽ hamaxpẽr ã mẽ omunh xà hkôt tanhmã mẽ harẽnh to. ");
INSERT INTO apnNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Koja mẽhõ tanhmã hamaxpẽr punuj to nẽ ra hkôt amnhĩ tomnuj pix o pa. Na htem nhãm mẽ hpar o pa nẽ mẽ kêp ahkĩ nẽ amnhĩ to hêx nẽ mẽ hakwa kamã nhãm axpẽn mã mẽ hixi jarẽnh o pa. Nẽ nhãm mẽ kêp mẽ hprõ ho amnhĩkati nẽ mẽ hkuprỳ hwỳr mra nẽ mẽ ho amnhĩkati. Nẽ tanhmã ri axpẽn tomnuj to ho pa. ");
INSERT INTO apnNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Mẽ hamaxpẽr punuj nhỹ hã na htem ã amnhĩ nhĩpêx anhỹr o pa. No na hte Tĩrtũm mẽ kot amnhĩ nhĩhkra kuhõnh japjê hkêt ã mẽ omunh xà hkôt mẽ kot amnhĩ to mex xwỳnh ã mẽ harẽnh kêt nẽ. Ja tanhmã kãm kute hkêt. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Tã nhũm Jejus mẽ inhmã kapẽr pa hãmri nẽ mẽ inhmã anẽ pa mẽ ma hkôt mõ. Ma Xir mẽ Sitõja wa pu hã ri ixpa. ");
INSERT INTO apnNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Nhũm mẽhõ nija omu nẽ hwỳr tẽ. Mẽ ixkĩnhã kêp Ijaew kêt tã hwỳr tẽ. Kanaã nhõ xwỳnh na pre. Tã Jejus wỳr tẽ nẽ kãm: —Ka Pahihti Jejus? Apê Tĩrtũm kot mẽ ixwỳr amẽnh xwỳnh jakamã xê ixujarẽnh ma nẽ ixkamã axukaprĩ hkêt wehe. Na mẽkarõmnutija tanhmã ixpê ixkra ho nhũm ixpê omnuj tỳx kumrẽx. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Hãmri nhũm Jejus kuma nẽ ãm kuma nẽ kãm tanhmã nẽ hkêt nẽ. Jakamã pa mẽ ixpê hkôt ixpa ho ixpa xwỳnhjaja kãm: —Kwa hano kê ma akupỹm tẽẽ ri. Na ãm ri mẽ pahkôt xatã hkrata jarẽnh pix o ri pa. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Nom nhũm kot amnhĩ tã kamã hamak kaxyw tanhmã mẽ inhmã hã kapẽr to nẽ mẽ inhmã: —Nà ãm Ijaewjê pix wỳr na pre Tĩrtũm inhmẽ. Te mẽ kêp ôwêhti pikunor pyràk o na htem htỳx ri amnhĩ nhĩpêx o pa. Jakamã ãm mẽ hwỳr pix mã na pre inhmẽ. Na kormã inhmã tanhmã nhãm mẽ hkwỳjê jarẽnh to hkêt nẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Hãmri nhũm nitita tee ri amnhĩ tã kuma nẽ hwỳr tẽ nẽ kutã hkõnkrã ho htẽm nẽ nhỹ nẽ kãm: —Xê ma we ixkamã axukaprĩ hkêt wehe. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Hãmri nhũm kãm: —Nà kormã. Na pre Tĩrtũm mẽ kêp Ijaewjê pix wỳr inhmẽ. Jakamã na pa kormã nhãm tanhmã mẽ akwỳjê ho mex to hkêt nẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Hãmri nhũm kãm: —Ma ãm hãmri na ka akapẽr. Nom ixpê Ijaew kêt tã mẽ kuxwar ãm ixto mex grire kêt wehe. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Hãmri nhũm kuma nẽ kãm: —Nà ãm hãmri na ka ã akra kaxyw inhmã ajamaxpẽr tỳx anẽ. Jakamã kot paj nê mẽkarõmnutita jano. Koja axte tanhmã apê ho hkêt kumrẽx. Anhỹr o kãm kapẽrja rôm nhũm hkraja akupỹm mex kurê kumrẽx. ");
INSERT INTO apnNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Tã nhũm Jejus mẽ inhmã anẽ pa mẽ ixrohã krĩja pê ixkato nẽ ma himô rax pê Garirej wỳr mõ. Nẽ nhỹri gô mỳri hixêt wỳr mõ nẽ hã api nẽ ixkrĩ. ");
INSERT INTO apnNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Hãmri nhũm mẽ ohtô nẽ ma mẽ ixkôt mra. Nẽ mẽ à xwỳnhjaja nhũm mẽ hamỳ nẽ Jejus wỳr mẽ o mra. Na prem ohtô rax kumrẽx. Ra ri mẽ pa hkêt xwỳnhjaja nẽ mẽ nohkre xwỳnhjaja nẽ mẽ hyk o mẽ pa xwỳnhjaja. Nẽ mẽ kapẽr kêt xwỳnhjaja nẽ ahpỹnhã ri tanhmã mẽ à kute xwỳnhjaja nhũm mẽ hamỳ nẽ ma Jejus wỳr mẽ o mra nẽ kutã mẽ haxwỳ. Hãmri nhũm mẽ omu nẽ ahpỹnhã akupỹm mẽ ho mex pa. ");
INSERT INTO apnNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Jakamã na pre mẽ kapẽr kêt xwỳnhjaja akupỹm kapẽr mex nẽ. Nẽ ri mẽ pa hkêt xwỳnhjaja akupỹm mrar mex nẽ. Nẽ mẽ hyk o mẽ pa xwỳnhjaja akupỹm tãm ri mra. Nẽ mẽ nohkre xwỳnhjaja akupỹm rĩt mex nẽ. Ã ahpỹnhã akupỹm mex par anẽ. Hãmri nhũm mẽ kot hwỳr mẽ hamỳnh nẽ Jejus wỳr mẽ o mrar xwỳnhjaja amnhĩ jaêr pê akupỹm mẽ mex ã mẽ omu nẽ mẽ kamã no pyma nẽ hkĩnh nẽ. Hãmri nẽ Tĩrtũm mã mex o mex ã harẽ nẽ axpẽn mã harẽnh o: —Nà ãm hãmri mẽ panhõ Tĩrtũmja ãm mex o mex. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Tã nhũm Jejus mẽ ixte hkôt ixpa ho ixpa xwỳnhjaja amnhĩ wỳr mẽ ixwỳ nẽ mẽ ixkôt mẽ mrar xwỳnhjê jahkre nẽ mẽ inhmã: —E. Ka mẽ rĩ kam jajê pumu. Na pa ra inhmã mẽ hkaprĩ nẽ. Na mẽ pahkôt ri pa hã apkati axkrunẽpxi nhũm ra mẽ kêp mẽõja hapêx pa. Koja mẽ apkur kêt rãhã ma akupỹm mẽ õ krĩ hwỳr pa hãmri nẽ pry hã hirot nẽ rôrôk o pa. Mẽ õ krĩ hwỳr awryy. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Nhũm pre ã mẽ inhmã mẽ harẽnh anẽ pa mẽ tee ri kuma hãmri nẽ kãm: —Kwa nom nhỹri kot pu mẽ kãm mẽmoj japrô nhũm mẽ tokyx kuku? Ja kapôt pix kênã. Nẽ mẽ ohtô griiã. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Hãmri nhũm mẽ inhmã: —No mẽ panhõ pãwtita? Tanhmã na arĩ kute nẽ hikwỹ? Anẽ. Hãmri pa mẽ kãm: —Nà ãm kêp 7 pix. Nẽ kaxyw tep kwỳ no ãm grêre. Kot mẽ ho dare kaxyw ã. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Hãmri nhũm mẽ inhma nẽ mẽ ixkôt mẽ mrar xwỳnhjê mã anẽ nhũm mẽ hkrĩ pa. ");
INSERT INTO apnNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Hãmri nhũm pãwti mẽ tep grêreta jamỳ nẽ ho Tĩrtũm wỳ nẽ kãm: —Pa Papaj. Nà apê mẽ inhmã mẽ inhõ ho apa xwỳnh jakamã amex o amex. Ãm amex kumrẽx. Anẽ. Hãmri nẽ mẽ kãm mẽmojta o hkry hpa nẽ mẽ inhmã kugõ pa mẽ ô ri ho xa nẽ ho mẽ hipêx pa. ");
INSERT INTO apnNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","38","Hãmri nhũm mẽ piitã apku nẽ õhy htu hpa. Nhũm prem mẽmyjaja kêp 4.000 nẽ kaxyw mẽnijaja nẽ mẽhprĩjaja. Mẽ ohtô rax kumrẽx tã nhũm Jejus mẽõ ho mẽ hipêx pa. Hãmri pa mẽ hakrêx o akuprõ nẽ ho kawà ho 7 nẽ ho nỳt. ");
INSERT INTO apnNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Hãmri nhũm Jejus ma akupỹm mẽ õ krĩ hwỳr mẽ hano pa mẽ pàr krem agjê hãmri nẽ ma ijaxwỳja mõ. Ma pika pê Makatã hwỳr mõ. ");
INSERT INTO apnNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Tã pa mẽ ra hwỳr pôj nhũm Parijew mẽ Satusew nhõ xwỳnhjaja Jejus pumu nẽ hwỳr mra. Nẽ hêx rom kot kamã hamak kaxyw hwỳr mra nẽ kãm: —Pa Jejus? E kwa mẽ inhmã aa mẽ ixte mẽmoj pumunh kêt õ ho anẽ nà? Pa mẽ ate ho anhỹr ã apumu nẽ Tĩrtũm kot mẽ ixwỳr amẽnh ã akôt ijamaxpẽr kurê kumrẽx. E kwa tokyx. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","3","Hãmri nhũm mẽ kuma nẽ mẽ kãm: —Tk. Nà kot paj mẽ amã ho anhỹr kêt nẽ. Mẽ ate hã ixpumunh nẽ ixkôt ajamaxpẽẽre kaxyw ã. Na ka htem kaxkwa kamã kakrã pumu nẽ axpẽn mã na wrỳk ã harẽ. Nẽ kaxkwa mex pumu nẽ axpẽn mã amgrà hã harẽ. Tã ixte tanhmã mẽ amã mẽmoj nhĩpêx to hã ixpumu nom Tĩrtũm kot mẽ awỳr inhmẽnh xwỳnh ã ixkôt ajamaxpẽr kêt nẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","ãm mẽ ajamaxpẽr punuj pix o na ka htem ri ajamaxpẽr o apa. Ixpê Tĩrtũm kot mẽ awỳr inhmẽnh xwỳnh tã ka mẽ ja hã ixkôt ajamaxpẽr kêt nẽ. Tã mẽ ate aa mẽmoj pumunh kêt kwỳ ixte mẽ amã ho anhỹr kaxyw ka mẽ inhmã hã karõ. Nà kot paj mẽ amã ho anhỹr kêt nẽ. Kormã. Kot paj ãm nhỹrmã te amnepêm Jõhti kot amnhĩ nhĩpêx pyràk o amnhĩ nhĩpêx. E ja pix kot paj mẽ amã harẽ. Nom kot paj mẽ amã aa mẽ ate mẽmoj pumunh kêt õ ho anhỹr kêt nẽ. Anẽ. Nhũm pre ã Jejus mẽ kãm kapẽr anẽ hãmri pa mẽ ixrohã mẽ kêp ixkato nẽ ma ixpa. ");
INSERT INTO apnNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Tã pa mẽ Jejus mẽ ixrohã ma mõ nẽ pàr mã agjê nẽ ma xarmã akupỹm rê nẽ hikjê hã mõ. Hãmri nẽ tee ri mẽ ixàpkur xà japêr nẽ axpẽn mã: —Kwa na pu mẽ panhõ pãwti ho pajamakêtkati nẽ kure. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Hãmri nhũm Jejus mẽ inhma nẽ tanhmã mẽ inhmã Parijew mẽ Satusew nhõ xwỳnhjê jarẽnh to. Nom pãwti hã kuxi nẽ mẽ inhmã mẽ harẽ nẽ mẽ inhmã: —Kwa mẽ o kora. Kêr ka mẽ Parijew mẽ Satusew nhõ xwỳnhjê mẽ kêp pãw kaxkrit xà hkwỳ hpyr kêt nẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Hãmri pa mẽ tee ri kuma nẽ ixprĩ hã mar mex kêt nẽ. Nẽ arĩ kapẽrta ã axpẽn kukjêr o hkôt mõ nẽ axpẽn mã: —Kwa mẽ pahte mẽ panhõ pãwti rer jakamã mãn mẽ pahte mẽ õ pãw kaxkrit xà kwỳ hpyr nê mẽ pahkurê nà? Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Hãmri nhũm mẽ inhma nẽ mẽ inhmã: —Hêxta waa nẽ. Mon ka mẽ ãm axpẽn mã mẽ panhõ pãwti hkêt pix jarẽnh o mõ? Pẽr kormã mẽ ate amnhĩ kaxyw inhmã ajamaxpẽr tỳx kêt. ");
INSERT INTO apnNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Jãã ixte mẽ anoo mã pãwti kêp 5 pix tã nhũm ixte ho mẽ kêp 5.000tajê nhĩpêx par. Nhũm mẽ kot hkur nẽ ho õhy htu hpar nhũm mẽ ate mẽõ jakrêx o apikuprõnh par nẽ ho kawà ho 12 nẽ ho hipu. ");
INSERT INTO apnNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Nẽ ham pãwti kêp 7 o mẽ kêp 4.000 nhĩpêx par nhũm mẽ kot hkur nẽ ho õhy htu hpar nhũm mẽ ate mẽõ jakrêx o apikuprõnh raxja. ");
INSERT INTO apnNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Ra ixte mẽ anoo mã ja ho anhỹr o axkrut tã ka mẽ ra hã ano hkêt nẽ arĩ axpẽn mã mẽ paxàpkur xà pix jarẽnh o ixkôt mõ. Nà mẽ paxàpkur xàja na pa harẽnh kêt nẽ. Parijew mẽ Satusew nhõ xwỳnhjê nhõ pãwti kaxkrit xà pix na pa hã kuxi nẽ mẽ amã tanhmã harẽnh to. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Nhũm pre ã mẽ inhmã kapẽr anẽ hãmri pa mẽ atã kuma nẽ kãm: —Nà na pa xep mẽ hãmri tã ama. Xep mẽ ixte Parijew mẽ Satusew nhõ xwỳnhjê kapẽr kôt amnhĩ nhĩpêx nê na ka mẽ ixkurê nẽ ã mẽ harẽnh anẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Tã pa mẽ axte Jejus kôt mõ nẽ pika pê Sejarej Piripos kamã kormã mõ nhũm Jejus amnhĩ tã mẽ ixkukja nẽ mẽ inhmã: —E mẽ inhmã mẽmoj jarẽ. Tanhmã na hte mẽ akwỳjaja axpẽn mã ijarẽnh to wehe? Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Hãmri pa mẽ kãm: —Nà na htem ahpỹnhã tanhmã ajarẽnh to. Na hte kamã mẽ hkwỳjaja ajarẽnh o finat Juãw Paxis ã ajarẽ. Nhũm kamã mẽ hkwỳjaja ato finat Eris ã ajarẽ nhũm mẽ hkwỳjaja tõhã apê Tĩrtũm nhỹ hã akapẽr o apa xwỳnhjê hõ akupỹm atĩr ã ajarẽ. Nẽ tõhã finat Jeremĩstija rỳ axtem hõ hã ajarẽ. Ã na htem ahpỹnhã axpẽn mã ajarẽnh anẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Hãmri nhũm mẽ inhma nẽ mẽ inhmã: —No mẽ kajaja? Ixpê mẽhõ hã na ka htem axpẽn mã ijarẽ? Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Hãmri nhũm Simãw Pêtre kãm: —Nà apê Tĩrtũm kot mẽ ixkaxyw axãm nẽ mẽ ixwỳr amẽnh xwỳnh na ka. Nẽ apê mẽ ixpiitã mẽ inhõ Pahi Maati na ka. Ã na pa htem axpẽn mã ajarẽnh anẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Hãmri nhũm kuma nẽ kãm: —Nà ãm hãmri na ka ã ijarẽnh anẽ Simãw Pêtre. Nom amnhĩ krã hkôt na ka ã ijarẽnh anhỹr kêt nẽ. Tĩrtũm tãm kot amã ixto amnhĩrĩt xà hkôt na ka ã ijarẽnh anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Nà akumrẽx na ka ã ijarẽnh anẽ. Tã koja mẽ apyrà nẽ nhỹrmã mẽ kot ixkôt amnhĩ xunhwỳr xwỳnhjaja ma hkwỳjê mã ja hã ijarẽnh o ri krĩ piitã hkôt pa. Hãmri nhũm mẽ hkwỳjaja mẽ kuma nẽ mẽ apyrà nẽ ixkôt amnhĩ xunhwỳ. Hãmri nhũm mẽ kêp ixprãm nõkati xwỳnhjaja tee ri tanhmã mẽ kot ijarẽnh toja ma nẽ ã ijarẽnh anhỹrja nê mẽ kãm kapẽr tã nom ho hkaprỳ. Ã koja ixkôt mẽ kot amnhĩ xunhwỳr xwỳnhjaja mẽ kãm ijarẽnh o pa anẽ. Jao te mẽ apê kẽn nhũm ixte mẽ ato amnhĩm inhõrkwỹ nhĩpêx pyràk. Tã akumrẽx ate ã ijarẽnh kot anhỹr jakamã kot paj te ixte akumrẽx amỳnh nẽ ato ixtẽm nẽ inhõrkwỹ nhĩpêx kaxyw amnhĩm akumrẽx axãm pyràk o anhĩpêx Simãw Pêtre. ");
INSERT INTO apnNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","—E kêr ka ma inhỹ hã tanhmã mẽ piitã mẽ kãm ijarẽnh to ho ri apa. Mẽ kot hprĩ hã amar kaxyw. Koja mẽ hkwỳjaja ama nẽ amnhĩ kaxyw ixkôt hamaxpẽr nẽ ixkôt amnhĩ xunhwỳ. Ka ja hã mẽ omu nẽ mẽ kãm: “E ra mẽ ate Jejus kôt amnhĩ xunhwỳr jakamã kot ka mẽ nhỹrmã ty nẽ ma kaxkwa hwỳr api nẽ Tĩrtũm mẽ wa kuri amex kumrẽx nẽ atĩr tũm nẽ apa ho apa.” Anhỹr o mẽ kãm ijarẽnh o apa. No mẽ kot akapẽr mar nẽ ãm mar nẽ ixkôt amnhĩ xunhwỳr kêt xwỳnhjaja ka mẽ kãm: “No mẽ kajaja mẽ ate Jejus kôt amnhĩ xunhwỳr kêt jakamã kot kaj mẽ nhỹrmã Tĩrtũm mẽ Krata wa kuri atĩr tũm nẽ apa ho apa hkêt nẽ.” Anhỹr o ã inhỹ hã mẽ kãm akapẽr anhỹr o ri mẽ hkôt apa. Jao te ate kaxkwa hwỳr saf pyr nẽ Tĩrtũm krajê mã kahê xà rẽnh nẽ Tĩrtũm kra hkêt xwỳnhjê pê kahê pyràk o amnhĩ nhĩpêx o apa. Anẽ. Nhũm pre ã Jejus Simãw Pêtre mã kapẽr anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Hãmri nẽ hpãnhã mẽ ixpiitã mẽ inhmã kapẽr nẽ mẽ inhmã: —E. Kwa kêr ka mẽ kormã mẽ piitã mẽ kãm Tĩrtũm kot mẽ awỳr inhmẽnh ã mẽ kãm ijarẽnh o ri apa hkêt nẽ. Kormã. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Hãmri nhũm Jejus hprĩ hã amnhĩ kukamã tanhmã mẽ inhmã amnhĩ jarẽnh to nẽ mẽ inhmã: —Nà mẽ kajaja mẽ ate aprĩ hã ixpumunh mex. No mẽ pahkwỳjaja kãm hprĩ hã ijarẽnh mar nẽ ixpumunh prãm kêt. Ijaew krãhtũmjaja nẽ Tĩrtũm kapẽr tũm o mẽ ahkre xwỳnhjaja nẽ patre krãhtũmjaja. Mẽ kãm hprĩ hã ixpumunh nẽ kãm ixkapẽr mar prãm kêt jakamã kot paj tokyx ma Jerujarẽ hwỳr mõ nhũm mẽ kamã ixpynê nẽ ixtak rax nẽ ixpĩ. Nom kot paj ixtyk ã apkati axkrunẽpxi nhũm Tĩrtũm akupỹm ixto ixtĩr. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Hãmri nhũm Simãw Pêtre tee ri kot ã mẽ kãm amnhĩ jarẽnh anhỹrja ã kuma nẽ hwỳr tẽ nẽ hpa hã kupy nẽ mẽ ixpê ho kato nẽ mẽ ixkàx ã o xa. Nẽ ã kot amnhĩ jarẽnh anhỹrja nê kãm kapẽr nẽ kãm: —Kwa nà Pahihti. Ri ã amnhĩ jarẽnh anhỹr kêt nẽ. Mo kot kêt mẽ ri axtem nẽ ã anhĩpêx anẽ? Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Hãmri nhũm kuma nẽ hwỳr apkjê nẽ omu nẽ kãm: —Tk. Te apê Satanasti kapẽr pyràk o na ka ã inhmã akapẽr anẽ. Kot kaj ã akapẽr anẽ hãmri nẽ ixkôt apa hkêt nẽ. Tĩrtũm kãm hprãm xà hkôt na ã mẽ kot inhĩpêx anhỹr kaxyw kênã. Tã ka Tĩrtũm jamaxpẽr o ajamaxpẽr kêt nẽ amnhĩ jamaxpẽr o ã inhmã akapẽr anẽ. Te apê ixpê axàmnàr xwỳnh pyràk o amnhĩ nhĩpêx. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Nhũm pre ã Jejus Simãw Pêtre mã kapẽr anẽ hãmri nẽ hpãnhã mẽ ixpê hkôt ixpa ho ixpa xwỳnh piitã mẽ inhmã kapẽr nẽ mẽ inhmã: —E kot kaj mẽ ixkôt amnhĩ xunhwỳr ã amnhĩ jarẽ hãmri nẽ mããnẽn amnhĩ jarẽnh o: “Jejus kêp inhõ Pahihti jakamã kot paj kapẽr kôt pix mã amnhĩ nhĩpêx rãhã ho ri ixpa. Kwãr ixkwỳjaja tanhmã hã inhĩpêx hto.” Anhỹr o amnhĩ jarẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","—Koja mẽ ixtã mẽ atõx pĩ rỳ tanhmã mẽ atõ hto ka ty. Tã nom koja akaxwỳnh ma ixwỳr àpir kurê kumrẽx. Hãmri ka ixkuri atĩr tũm nẽ amex rãhã nẽ apa ho apa. Nom kot kaj mẽ jar atĩr prãm xàj ixkaga hãmri nẽ inhõ krĩ hwỳr axàpir kêt nẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","—Nẽ koja mẽhõ hikukrêx rax gryk ã Tĩrtũm kaga. Tã nhỹrmã ty hãmri nẽ amnhĩ kôt hikukrêx õ hpyr nẽ o mõr kêt nẽ. Koja tee ri kuwy hwỳr mõr pymaj amnhĩ nê hikukrêx rax o amnhĩ pãnhã amnhĩrer prãm kaprỳ. Tanhmã koja amnhĩ to nẽ Tĩrtũm mã amnhĩre nẽ ma õ krĩ hwỳr api? Koja ã amnhĩ nhĩpêx anhỹr kêt nẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","—Nẽ ixpê Tĩrtũm kot mẽ awỳr inhmẽnh xwỳnh kot paj nhỹrmã kaxkwa rũm akupỹn mẽ awỳr wrỳ nhũm Tĩrtũm kapẽr o mẽ wrỳk xwỳnhjaja man ixkôt wrỳ. Hãmri pa inhõ Papaj nhỹ hã ixte mẽ piitã tanhmã mẽ kot amnhĩ nhĩpêx to hã mẽ omunh xà hkôt ahpỹnhã tanhmã mẽ harẽnh to. ");
INSERT INTO apnNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","ãm hãmri na pa ã mẽ amã amnhĩ jarẽnh anẽ. Kot paj nhỹrmã akupỹn ixte mẽ ato amnhĩptàr kaxyw man mẽ awỳr wrỳ. Tã kot kaj mẽ akwỳjaja akupỹn ixwrỳỳta kukamã tokyx ixte tanhmã ixte amnhĩ nhĩpêx to hã ixpumu. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Tã nhũm semãnja hapêx nhũm Jejus ma nhỹri hixêt prêk wỳr mõ. Nẽ kaxyw Simãw Pêtre nẽ Xiakre nẽ Xiakre htõ Juãwja nhũm ma amnhĩ kôt wa mẽ o mõ. Nhũm wa mẽ mõ nẽ hixêt prêk ã api nẽ himõk ã kuhê. ");
INSERT INTO apnNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Hãmri nhũm Jejus xep ra axtem nẽ xa. Axtem hkuk nhĩrã htỳx nẽ xa. Te myyti nhĩrã htỳx pyràk. Nẽ ê haka htỳx kumrẽx. ");
INSERT INTO apnNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Hãmri nhũm xep ja wa kaxkwa rũm hwỳr wrỳ nẽ kuri kãm kapẽr o xa. Mojes mẽ Erisja wa nhũm hwỳr wrỳ nẽ kuri xa. Tĩrtũm amnepêm amnhĩ wỳr wa ho àpir tã wa akupỹn wrỳ nẽ Jejus mã kapẽr o xa. ");
INSERT INTO apnNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Hãmri nhũm Jejus kôt mẽ mõr xwỳnhjaja wa mẽ omu nhũm Simãw Pêtre tanhmã hamaxpẽr to nẽ Jejus wỳr tẽ nẽ kãm: —Kwa Pahihti. Nà ãm hãmri na pu mẽ amnẽ mõ. Kwa pu mẽ kritpêm jar axkamẽ nẽ tokyx panojarêt kêt nẽ. Pa mẽ amã pô nhĩrõnh o axkrunẽpxi nẽ hipêx. Amã hõ nhĩpêx nẽ Mojes mã hõ nhĩpêx nẽ Eris mã hõ nhĩpêx ka mẽ kamã akrĩ. E kwa pa mẽ amã ho anẽ nà? Anhỹr o kãm kapẽr. Nom amnhĩ krã hkôt ã kapẽr anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Hãmri nẽ kormã ã kãm kapẽr anhỹr rôm nhũm ra kakrã jaka htỳxja wrỳ nẽ wa mẽ hkunor pa nhũm wa mẽ kamã kuhê. Nhũm kakrã kamã Tĩrtũm mẽ kãm kapẽr nẽ mẽ kãm: —E ota Ixkra xa. Inhmã hapê ho inhmã hapê. E kêr ka mẽ kapẽr mar tỳx rãhã ho ri apa. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Hãmri nhũm mẽ tee ri kuma nẽ kãm ma htỳx nẽ umaj pikap rôrôk nẽ htu mỳrpê hikwỹ. ");
INSERT INTO apnNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Hãmri nhũm Jejus mẽ hwỳr tẽ nẽ mẽ hã ĩhkra jaxwỳ nẽ mẽ kãm: —E mẽ kànhmã akuhê nẽ amã ma hkêt nẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Hãmri nhũm mẽ kuma nẽ kànhmã rĩt nẽ Jejus pix pumu nhũm ahte xa nhũm kuri wa ãm xwỳnhta wa ra ma akupỹm api. ");
INSERT INTO apnNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Hãmri nhũm mẽ kormã akupỹm hixêt nhĩmõk rũm mẽ ixwỳr wrỳk o mõ nhũm Jejus mẽ kãm: —E kêr ka mẽ ham ate mẽmoj pumunh xwỳnhta kormã nhãm mẽ kãm harẽnh kêt nẽ. Kot paj nhỹrmã ty nẽ akupỹm ixtĩr ka mẽ rĩ kormã mẽ kãm ja hã ijarẽnh o ri apa. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Hãmri nhũm mẽ kormã akupỹn mẽ ixwỳr wrỳk o mõ nhũm mẽ Jejus mã: —Kwa mẽ inhmã mẽmoj jarẽ. Na htem Tĩrtũm kapẽr tũm o mẽ ijahkre xwỳnhjaja mẽ inhmã: “Eris kumrẽx koja Tĩrtũm mẽ pahwỳr kumẽ nhũm Krisja kormã hapu hã wrỳ.” Anẽ. Na htem ã mẽ inhmã war ajarẽnh anẽ. Tã ka ra wrỳ nom kormã akukamã Erisja wrỳk kêt. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Hãmri nhũm mẽ kãm: —Nà ãm hãmri na prem ã wa ijarẽnh anẽ. Na pre ra ixkukamã te Eris kot amnhĩ nhĩpêx pyràk xwỳnhta tẽ nẽ ixkutêp mẽ kãm ijarẽnh o pa. ");
INSERT INTO apnNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Tã nom nhũm mẽ ja hã omunh kêt nẽ. Na prem axtem nẽ kãm hprãm xà hkôt tanhmã hipêx to nẽ kupĩ. Tã koja mẽ nhỹrmã ã hipêx anhỹr pyràk o inhĩpêx. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Hãmri nhũm mẽ ra hprĩ hã kuma nẽ axpẽn mã: —Kwa Juãw Paxis pimrààta na ã mẽ pamã harẽnh anẽ. Tapxipix na pre te Eris kot amnhĩ nhĩpêx pyràk o amnhĩ nhĩpêx o pa. Tã tãm na mẽ pamã harẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Tã nhũm mẽ ra akupỹm ahpar mã man mẽ ixwỳr hpôx o mõ nhũm mẽ ohtô rax nẽ Jejus kutêp kuhê. Hãmri nhũm mẽhõ myja mẽ omu nẽ mẽ kutã tẽ nẽ mẽ hkaxpa nẽ Jejus kutã hkõn krã ho tẽm nẽ nhỹ nẽ hkra ho kuwỳ nẽ kãm: ");
INSERT INTO apnNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","—Pa Jejus. Kwa inhmã ixkra kamã axukaprĩ nẽ. Na hte mẽkarõmnutija xatã tanhmã ixpê ho nhũm hte ỹ hã mra nẽ rôrôk nẽ tõhã kuwy kamã rôrôk nẽ tõhã gôx kãm mran mrõ nẽ ixpê homnuj tỳx nẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Tã pa akôt mẽ pa ho mẽ pa xwỳnhjê hwỳr o tẽ nom nhũm mẽ kot inhmã ho mex kaxyw tee ri tanhmã ho hkaprỳ. Kwa xà kot kaj akupỹm inhmã ho mex nà? Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Hãmri nhũm kuma nẽ mẽ ixte hkôt ixpa ho ixpa xwỳnhjê mã kapẽr nẽ mẽ inhmã: —Hêxta waa nẽ. Ra mẽ ate ixte Tĩrtũm nhỹ hã mẽ ho mex ã ixpumunh o ixkôt apa ryy htã kormã ixpyrà nẽ ã mẽ hipêx anhỹr kêt nẽ. Nà kormã mẽ kaxyw Tĩrtũm kôt mẽ ajamaxpẽr tỳx kêt jakamã na ka mẽ tee mẽ ho mex kaxyw. Anẽ. Hãmri nẽ myta mã kãm: —E amnẽ ixwỳr akrata o tẽ pa omu. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Hãmri nhũm kuma nẽ hwỳr o tẽ nhũm omu nẽ nê mẽkarõmnutija kator nhũm akupỹm mex kurê kumrẽx. ");
INSERT INTO apnNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Hãmri pa mẽ ixte Jejus kôt ixpa ho ixpa xwỳnhjaja ja hã omu mẽ hkàx ã amnhĩ tã hkukja nẽ kãm: —Kwa na pa mẽ axwakre kamã tee ri nê hanor prãm kaprỳ. Kwa mon pa mẽ apyrà nẽ nê hanor nhũm kator nẽ ma htẽm kêt nẽ? Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","21","Hãmri nhũm mẽ inhmã: —Nà kormã mẽ ate mẽ kaxyw Tĩrtũm kôt ajamaxpẽr tỳx kêt. Nom kot ka mẽ kaxyw hkôt ajamaxpẽr tỳx hãmri nẽ hkôt amnhĩ nhĩpêx kukwak ri mẽmoj tã awỳ nhũm mẽ ama nẽ mẽ ate mẽmoj tã axàhwỳr xà hkôt mẽ amã tanhmã mẽmoj nhĩpêx to. Te mẽ ate pĩ hpàr mũj mã akapẽr nẽ kãm: “Kwa amnhĩ jarê nẽ ma tẽ nẽ gô xujanãr kãm mãn mrõ.” Anhỹr nhũm kot amar nẽ amar xà hkôt ã amnhĩ nhĩpêx anhỹr kurê kumrẽx pyràk. Ja pyrà nẽ kot kaj mẽ amnhĩ kaxyw Tĩrtũm kôt ajamaxpẽr tỳx kukwak ri mẽmoj tã awỳ nhũm mẽ ama nẽ mẽ amã mẽmoj tanhmã ho rỳ mẽ amã mẽmoj gõ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","23","Tã hãmri pa mẽ Jejus kôt ma mõ nẽ nhỹri pika pê Garirej kamã kormã ixpa. Hãmri nhũm Jejus axte amnhĩ kukamã mẽ inhmã tanhmã htyk ã amnhĩ jarẽnh to nẽ mẽ inhmã: —Nà koja mẽ tokyx mẽ kãm ixtã amỹnê nhũm mẽ ixpĩ. Mẽ kot ixpĩr tã kot paj ixtyk ã apkati axkrunẽpxi nhũm Tĩrtũm akupỹm ixto ixtĩr. Anẽ. Hãmri pa mẽ tee ri ã kot amnhĩ jarẽnh anhỹrja ã kuma nẽ ixkaprĩ htỳx kumrẽx. ");
INSERT INTO apnNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Tã pa mẽ Jejus kôt ma mõ nẽ ra Kapanaũ hwỳr pôj. Hãmri nhũm mẽ kot Tĩrtũm mã amnhĩ jarẽnh xà hã ixkre ho mex kaxyw mẽ kêp kàxpore hkwỳ jamỳnh xwỳnhjaja mẽ ixpumu nẽ mẽ ixwỳr mra nẽ Simãw Pêtre mã kãm: —Pa. Kwa xà na hte mẽ ajahkre xwỳnhja mẽ pahpê hkwỳjê pyrà nẽ Tĩrtũm mã amnhĩ jarẽnh xà hã ixkre ho mex kaxyw kàxpore hkwỳ nhõr kêt nẽ nà? Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Hãmri nhũm mẽ kuma nẽ mẽ kãm: —Tỳ kot mẽ kãm õr o pa kênã. Anẽ. Hãmri nẽ ma mẽ ixkôt tẽ nẽ mẽ ixkôt mẽhõ nhõrkwỹ hwỳr axà. Hãmri nẽ kot Jejus mã mẽ harẽnh mã tã nhũm ra hamaxpẽr ã omu nẽ kumrẽx kãm kapẽr nẽ kãm: —Kwa inhmã mẽmoj jarẽ Simãw Pêtre. Xà na hte pahi hkrajaja õ papaj mã kàxpore hkwỳ nhõr o pa nà? Xà na hte ãm hkra hkêt xwỳnh pixjaja kãm hkwỳ nhõr o pa? Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Hãmri nhũm kuma nẽ kãm: —Nà mẽ kêp hkra hkêt xwỳnh pixjaja na hte kãm õr o pa. Anẽ. Hãmri nhũm Jejus kãm: —Tỳ. Nà ãm hãmri na ka ja jarẽ. Na hte pahi hkrajaja õ papaj mã kàxpore nhõr kêt nẽ. Mẽ kêp hkra kênã. Tã ixpê Tĩrtũm Kra jakamã mo kaxyw kot pa kêt õrkwỹ hwỳr inhgjêx kaxyw kãm kàxpore hkwỳ gõ? ");
INSERT INTO apnNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Tã nom kot paj õr kêt nhũm kàxpore hkwỳ jamỳnh xwỳnhjaja tee ri ja hã ixpumu nẽ axpẽn mã ixte amnhĩ tomnuj xwỳnh ã ijarẽ. Jakamã e ma gônhmã tẽ nẽ tep õ kanhê. Hãmri nẽ ho api nẽ apy nẽ hakwa jakjê nẽ kamã kàxpore htỳxre pumu. Nẽ apy nẽ man o tẽ nẽ pahpãnhã kàxpore jamỳnh xwỳnhta mã agõ. Anẽ. Nhũm pre ã Jejus Simãw Pêtre mã karõ anẽ nhũm kuma nẽ ma hwỳr tẽ nẽ kot kãm karõ xà hkôt ã amnhĩ nhĩpêx anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Tã mẽ ixte Jejus kôt ixpa ho ixpa xwỳnhjaja amnhĩ kukamã ijamaxpẽr nẽ amnhĩ tã Jejus kukja nẽ kãm: —Kwa mẽ inhmã mẽmoj jarẽ Pahihti. Nhỹrmã mẽ ixpê pahi nẽ anhĩhkô hã mẽ ho amnhĩptàr o ri ixpata ã mẽ ixtõ kot paj we mẽ ho amnhĩptàr rax o ixkwỳjê jakre? Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Hãmri nhũm mẽ inhma nẽ amnhĩ wỳr mẽhprĩre hõ mã hpa ho apê nhũm hwỳr tẽ nẽ mẽ ixkuri xa. ");
INSERT INTO apnNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Hãmri nhũm Jejus omu nẽ hã mẽ inhmã: —E mẽ inhma. Kêr ka mẽ apê pahi pyràk o tanhmã amnhĩ jarẽnh to ho ri apa hkêt nẽ. Ãm te amarĩ ri mẽ apa pyràk o amnhĩ nhĩpêx. Te mẽhprĩre kot amnhĩ nhĩpêx pyràk. Kot kaj mẽ ã amnhĩ nhĩpêx anhỹr o apa hkêt hãmri nẽ nhỹrmã inhĩhkô hã mẽ ho amnhĩptàr kêt nẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Jakamã kot kaj mẽ amã nhỹrmã inhĩhkô hã mẽ ho amnhĩptàr o apa hprãm. Hã kot kaj mẽ te mẽhprĩre kot amnhĩ nhĩpêx pyrà nẽ amã amnhĩ to rũnh prãm kêt nẽ apa. ");
INSERT INTO apnNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","—Nẽ kêr ka mẽ apê pahi kot amnhĩ nhĩpêx pyràk o tanhmã amnhĩ jarẽnh to ho apa hkêt nẽ. Ãm te amarĩ ri mẽ apa pyràk o amnhĩ nhĩpêx. Jao nhỹri mẽhprĩjê hõ pumu nẽ kamã axukaprĩ nẽ kãm mẽmoj tanhmã ho rỳ kãm mẽmoj gõ. Hãmri nẽ te pa ate tanhmã ixto mex to pyràk o amnhĩ nhĩpêx. Kot kaj mẽ ã amnhĩ nhĩpêx anhỹr o apa hãmri nhũm Tĩrtũm ja hã mẽ apumu nẽ mẽ ate amnhĩ to rũnh kêt tã mẽ ate amnhĩ to rũnh xwỳnh ã mẽ ajarẽ. E kot kaj mẽ amã amnhĩ to rũnh prãm hã kot kaj mẽ ã amnhĩ nhĩpêx anhỹr o ri apa. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Nhũm Jejus arĩ mẽ inhmã mẽhprĩ jarẽ nẽ mẽ inhmã: —Nẽ mẽhprĩre na htem amnhĩ kaxyw ixkôt hamaxpẽr o pa. Tã koja mẽhõ inhnê tanhmã mẽ kãm kapẽr to. Mẽ kot tanhmã amnhĩ tomnuj to hprãm xàj tanhmã mẽ kãm kapẽr to ho pa. Hãmri nhũm mẽ kuma nẽ mẽ kapẽr xà hkôt tanhmã amnhĩ tomnuj to. Hã koja Tĩrtũm ja hã omu hãmri nẽ kot inhnê tanhmã kãm kapẽr to xwỳnhta pumu nẽ homnuj tỳx nẽ. Te mẽ kot mẽhõ pynênh nẽ mut ã kẽn pytĩ hõ nhôr nẽ ma o htẽm nẽ gô xupỳm kãm mẽnh pyràk o hipêx. Te ho ja pyràk no ãm homnuj tỳx o hakre. ");
INSERT INTO apnNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","—Nẽ koja mẽhõ inhnê tanhmã mẽ kot ixkôt amnhĩ xunhwỳr xwỳnhjê hõ mã kapẽr to. Kot tanhmã amnhĩ tomnuj to hprãm xàj tanhmã kãm kapẽr to. Rỳ kot ixkaga hprãm xàj tanhmã kãm kapẽr to. Hãmri nhũm kuma nẽ mar xà hkôt ixkapẽr kwỳm tanhmã amnhĩ tomnuj to. Tã koja Tĩrtũmja ja hã omu nẽ mããnẽn kot inhnê kêp àmnàr xwỳnhta pumu nẽ ã inhnê kãm kapẽr anhỹrja mỳrapê homnuj tỳx kumrẽx. ");
INSERT INTO apnNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","9","—E kwa mẽ okora. Kot kaj mẽ anhĩhkra ho tanhmã amnhĩ tomnuj to rỳ apar o tanhmã amnhĩ tomnuj to. Hã kêr ka mẽ axte ã amnhĩ nhĩpêx anhỹr pymaj te mẽ ate amnhĩ pê krãhyr nẽ mẽnh pyràk o amnhĩ nhĩpêx nẽ axte ã amnhĩ tomnuj anhỹr kêt nẽ. Rỳ ka mẽ ano ho mẽmoj punuj pumu. Hã kêr ka kãm ajamaxpẽr pix o apa pymaj te mẽ ate amnhĩ pê ano katõk nẽ kaxàr nẽ mẽnh pyràk o amnhĩ nhĩpêx nẽ nhãm arĩt kurê kumrẽx. Kêr ka mẽ ã amnhĩ nhĩpêx anhỹr o ri apa. Hãmri nẽ nhỹrmã ty nẽ ma Tĩrtũm nhõ krĩ hwỳr api. No kot ka mẽ arĩ akutã ano nẽ arĩ akutã apar nẽ arĩ akutã anhĩhkra rãhã ri apa htã ho amnhĩ tomnuj o apa. Hãmri nẽ nhỹrmã ty nẽ ate amnhĩ tomnuj mỳrapê ma mẽ kot amnhĩ xà htỳx kamã hamak tũm xà hwỳr ma mõ. ");
INSERT INTO apnNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","11","—Nẽ kêr ka mẽ mẽhprĩrejê kamã axukaprĩ rãhã ho apa. Na hte kaxkwa kamã Tĩrtũm kapẽr o mẽ wrỳk xwỳnh kwỳjaja Tĩrtũm mã mẽ hamãr mex o pa. Tã koja mẽhõ tanhmã kêp hõ hto nhũm mẽ hã omu nẽ ma tẽ nẽ Tĩrtũm mã harẽnh kurê kumrẽx. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Nhũm Jejus arĩ mẽ inhmã kapẽr nẽ mẽ inhmã: —E pa mẽ amã awjarẽ ka mẽ ixujarẽnh ma. Nà koja mẽhõ my hkrit ôwêhti xohtô nẽ. Nẽ apkati mẽ ma hamãr o pa. Hãmri nhũm pyxire nẽ tanhmã amnhĩ to nẽ kêp akunok. Kwỳ kaga nẽ ma nhỹhỹm ahte tẽ nẽ kêp akunok. Hãmri nhũm mytita ma akupỹm o mõr kaxyw hkwỳ ho pikuprõnh pa hãmri nẽ tee ri hkwỳ kaêx ã pikunor xwỳnhta japêr nom nhỹri omunh kêt nẽ. Hãmri nẽ tee ri hkukamã hamaxpẽr nẽ ma hkwỳ ho mõ nẽ nhỹri kure. Kutêp apkur kaxyw nhỹri kure hãmri nẽ ma akupỹm pikunor xwỳnhta japêr o tẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Hãmri nẽ hapêr ryy nẽ nhỹri hwỳr kato nẽ omu nẽ hkĩnh nẽ. Hãmri nẽ kutu nẽ ma akupỹm o tẽ. Na hte pikunor kêt xwỳnhjê nhỹ hã hkĩnh tã pikunor xwỳnhta mã kato nẽ hkĩnh tỳx nẽ. Krit xohtô htã nom ãm kãm ho pixi nẽ ho hpikunor prãm kêt. Ã mẽ ujarẽnh kot anhỹr. ");
INSERT INTO apnNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Ja pyrà nẽ Tĩrtũm kãm mẽhõ pyxi nẽ nhỹrmã ma kuwy wỳr mõr prãm kêt kumrẽx. Mẽ piitã mẽ kot hkôt amnhĩ xunhwỳrja na kãm hprãm. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Nhũm Jejus arĩ mẽ inhmã kapẽr nẽ mẽ inhmã: —Nẽ ja. Koja ixkôt mẽ atõ rỳ mẽ atõx tanhmã atomnuj to. Hã kêr ka ma hwỳr tẽ nẽ kot tanhmã anhĩpêx to hã amnhĩ tã kãm akapẽr. Nom kêr ka mẽ nhãm mẽhõ mã harẽnh kêt nẽ. Ãm tanhmã kot ato xwỳnhta pix wỳr tẽ nẽ kumẽ war axpẽn mã akapẽr nẽ war axpẽn ma. Nhũm ama nẽ akupỹm tãm anhĩpêx hã kêr ka akupỹm te ixkôt kêp atõ rỳ atõx pyràk o ka wa axpẽn nhĩpêx nẽ axte jam ajamaxpẽr kêt nẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Nom koja ama nẽ ãm ama rỳ tanhmã ato hkêt ã amnhĩ jarẽnh japêr. Hã kêr ka ma akupỹm tẽ nẽ akupỹm amnhĩ kôt Kris kôt atõ rỳ atõx o axkrut rỳ mẽ ho axkrunẽpxi nẽ amnhĩ kôt hwỳr mẽ o mra kê mẽ axpẽn tã war ama. Amnepêm Tĩrtũm kapẽr ã kagà htũm kot ja jarẽnh o: Kêr ka mẽ atõ tanhmã axpẽn nhĩpêx to. Hãmri nẽ hã axpẽn mã akapẽr kaxyw nẽ amnhĩ kôt akwỳjê ho axkrut rỳ ho axkrunẽpxi nẽ akupỹm hwỳr mẽ o mra kê mẽ axpẽn tã war ama. Anẽ. —Ã Tĩrtũm kapẽr ã kagà htũm kot ja jarẽnh kot anhỹr. ");
INSERT INTO apnNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Jakamã kêr ka mẽ amnhĩ kôt akupỹm kot tanhmã ato xwỳnhta wỳr mẽ o mra kê mẽ atã kuma. Hãmri nhũm arĩ mẽ kãm kot tanhmã ato hkêt ã amnhĩ jarẽ ka tee ri amnhĩ tã omu nẽ ikrêsti hwỳr tẽ nẽ Kris kwỳ hã mẽ pikuprõnh xwỳnhjê mã harẽ. Kê mẽ ama hãmri nẽ ja hã axte kot tanhmã ato xwỳnhta mã kapẽr. Nhũm mẽ mar kêt nẽ arĩ kot tanhmã ato hkêt ã amnhĩ jarẽ ka mẽ amnhĩ nê hanor kurê kumrẽx. Hãmri nẽ te kêp Kris kôt mẽ atõ rỳ mẽ atõx kêt pyràk o hipêx. ");
INSERT INTO apnNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","—Nẽ koja mẽhõ ixkôt amnhĩ xãm nẽ Inhĩpêêxà Tĩrtũm kôt ri amnhĩ nhĩpêx o pa. Ka mẽ ja hã omu nẽ inhỹ hã tanhmã kãm akapẽr to nẽ kãm: “E ra ate Jejus kôt amnhĩ xãm jakamã kot kaj nhỹrmã Tĩrtũm mẽ wa kuri amex kumrẽx nẽ atĩr tũm nẽ apa ho apa.” Anhỹr o kãm akapẽr. Nom mẽ kot ixkôt amnhĩ xunhwỳr kêt xwỳnhjaja ka mẽ ã mẽ kãm akapẽr anhỹr kêt nẽ. Ãm inhỹ hã mẽ kãm: “No mẽ kajaja mẽ ate Jejus kôt amnhĩ xunhwỳr kêt jakamã kot kaj mẽ Tĩrtũm mẽ Krata wa kuri atĩr tũm nẽ amex nẽ apa hkêt nẽ.” Anẽ. Kêr ka mẽ inhỹ hã ã ahpỹnhã tanhmã mẽ kãm akapẽr to ho apa anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","20","—Nẽ kot kaj mẽ Tĩrtũm mã amnhĩ jarẽnh kaxyw te axkrutre rỳ axkrunẽpxire htã axpẽn wỳr akuprõ nom mẽ kapxipixjaja apikuprõnh kêt nẽ. Kot paj mẽ akaêx ã mẽ anhĩhkô hã mẽ amar o xa. Mẽ ate ano ho ixpumunh kêt tã pa wa mẽ anhĩhkô hã mẽ amar o xa. Jakamã kot kaj mẽ axpẽn wỳr akuprõ nẽ mẽmoj tã Tĩrtũm wỳ nhũm kaxkwa kamã ja hã mẽ ama. Nẽ mẽ ate hã axàhwỳr xwỳnhta nhũm mẽ amã tanhmã ho. Kêr ka mẽ ã ixkamnàr rom axàmnhĩx amnhĩ to Inhĩpêêxà hwỳr anẽ. Anẽ. Nhũm pre ã Jejus mẽ inhmã kapẽr anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Tã nhũm Simãw Pêtre Jejus wỳr tẽ nẽ mẽmoj tã hkukja nẽ kãm: —Kwa inhmã mẽmoj jarẽ Pahihti. Xà koja akôt ixtõ rỳ ixtõx tanhmã inhĩpêx to pa amnhĩ tã omu nẽ ãm omu nẽ amnhĩ tã tanhmã ho hkêt nẽ. Nhũm axte tanhmã ixto nẽ axte tanhmã ixto ho 6 tã pa ãm amnhĩ tã omu nẽ amnhĩ tã tanhmã ho hkêt nẽ. Ãm ho ijamakêtkati nẽ axte kãm ijamaxpẽr kêt nẽ. Ã amnhĩ tã hipêx anhỹr o 7 nhũm ja amã mex nẽ nà? Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Hãmri nhũm kãm: —Nà kot kaj ã amnhĩ tã hipêx anhỹr o 7 pix kêt nẽ. Koja mẽhõ xatã tanhmã ato rãhã nẽ ka amnhĩ tã omu nẽ ajaxwỳja amnhĩ tã xatã tanhmã ho hkêt nẽ. Ãm amnhĩ tã omu nẽ ãm omu nẽ tãm hipêx rãhã ho ri apa. Mãmrĩ ho anhỹr o apa rãhã nẽ aa jam anhũrer kêt nẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","—E kot paj ixprĩ hã mẽ amã tanhmã ja jarẽnh to ka mẽ inhma. Tĩrtũm na hte xatã mẽ ate tanhmã amnhĩ tomnuj to hã mẽ apumu nẽ mẽ anê rênh o pa. Te kot pahi kot ã hkwỳjê nhĩpêx anhỹr pyràk. Koja mẽ õ pahija kãm mẽ àpênh xwỳnhjaja kot kêp kàxpore ho ĩpresta hã mẽ omunh kaxyw nhỹ. ");
INSERT INTO apnNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Hãmri nhũm mẽ hwỳr ja ho tẽ nẽ kutã ãm. Ra kot kêp hikàxpore ho ĩpresta rax xwỳnhja. ");
INSERT INTO apnNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Tã no ãm aa akupỹm kãm õr kêt nẽ ra kêp ho hapêx pa. Hãmri nhũm pahija tee ri amnhĩ tã omu nẽ hkwỳjê mã hã amỹnê nẽ mẽ kãm: “E. Mẽ ma o tẽ nẽ hprõ nẽ hkrajaja nẽ õrkwỹ nẽ hikukrêx mẽrohã ho wẽnê hpa nẽ hpãnhã kàxpore py nẽ man inhmã o tẽ. Kot ixpê ixkàxpore ho ĩpresta nẽ akupỹm inhmã õr kêt mỳrapê.” Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","—Hãmri nhũm kot ho ĩpresta xwỳnhta tee ri amnhĩ tã kuma nẽ kutã hkõnkrã ho nhỹ nẽ amnhĩ to hwỳr kãm hihtỳx nẽ kãm: “Kwa nà ri ixto anhỹr kêt nẽ pahihti. Ixkamã axukaprĩ nẽ hkêt wehe. Nà kot paj akupỹm amã kugõ kãm ga.” Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","—Hãmri nhũm amnhĩ tã kuma nẽ kãm hkaprĩ nẽ. Hãmri nẽ kãm: “Tôe. Nà kot paj ã anhĩpêx anhỹr kêt nẽ. Kot paj anhõ kõt kaxônh pa nẽ kumẽ ka mãmrĩ ma ajamakêtkati nẽ axàmnhĩx apa.” Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Nhũm ã kãm kapẽr anẽ nhũm kuma nẽ hkĩnh nẽ. Hãmri nẽ ma tẽ nẽ kato nẽ ixkre kapem pôristi hõ pumu. Na pre ra kêp kàxpore hkwỳ ho grire nẽ ho ĩpresta nhũm kato nẽ omu. Hãmri nẽ hwỳr tẽ nẽ amnhĩ kĩnhã õkre hã kumỳ nẽ kãm: “Kwa tokyx akupỹm ate ixpê kàxpore ho ĩpresta pãnhã inhmã agõ.” Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Hãmri nhũm tee ri amnhĩ tã omu nẽ ra ham kot pahi kutã amnhĩ nhĩpêxta pyrà nẽ kutã hkõnkrã ho nhỹ nẽ kãm: “Kwa nà. Kwa ri ixto anhỹr kêt nẽ. Nà kot paj hpãnhã amã kugõ. Kwa ixkamã axukaprĩ nẽ hkêt wehe.” ");
INSERT INTO apnNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Anhỹr tã nom nhũm kuma nẽ ãm kuma nẽ hã amỹnê. Hã hkwỳjê mã amỹnê nẽ mẽ kãm: “E mẽ ma jahti ho tẽ nẽ haxà. Koja kot ixpê kàxpore ho ĩpresta pãnhã inhmã kugõ nẽ rĩ kormã kato nẽ rĩ amnhĩ pumu.” Anẽ. Hãmri nhũm mẽ kuma nẽ ma o tẽ nẽ haxà. ");
INSERT INTO apnNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","—Hãmri nhũm hkwỳjaja tee ri mar o kuhê nhũm mẽ kêp ja omnuj nẽ nhũm mẽ pahi hwỳr agjê nẽ kãm harẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Hãmri nhũm tee ri harẽnh ma nẽ kamã gryk tỳx nẽ akupỹm amnhĩ wỳr hã karõ nhũm akupỹm hwỳr axà nhũm kãm: “Tk. Kwa na ka pre amnhĩ tomnuj tỳx nẽ. Ate amnhĩ to ixwỳr nhũm inhmã akaprĩ nẽ ixte anhõ kõt kaxônh nẽ mẽnh tã ");
INSERT INTO apnNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","ka amnhĩ kĩnhã anhĩõta kamã axukaprĩ hkêt nẽ ri ã hipêx anẽ.” Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Hãmri nẽ kamã gryk nẽ hã õ pôristi mã amỹnê nhũm mẽ ma o tẽ nẽ haxà. Mẽ kot mẽ hagjênh xà hã ixkre kamã apkati mẽ tanhmã mẽ kot hipêx to kaxyw nhũm mẽ kãm hã amỹnê. Tanhmã mẽ kot hipêx to rãhã nhũm kot akupỹm kàxpore raxta nhõr par nẽ rĩ kormã kator kaxyw nhũm mẽ ma o tẽn haxà. Ã mẽ ujarẽnh kot anhỹr. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Nhũm pre ã Jejus mẽ ixte hkôt ixpa ho ixpa xwỳnhjê mã kapẽr anẽ. Hãmri nẽ mẽ inhmã: —Ja pyrà nẽ koja ixkôt mẽ atõ rỳ mẽ atõx tanhmã mẽ atomnuj to ka mẽ amnhĩ tã omu nẽ ãm omu nẽ ho ajamakêtkati kurê kumrẽx nẽ axte kãm ajamaxpẽr kêt nẽ. Te pahi kot mẽhõ nhõ kõt kaxônh par nẽ axte kãm hamaxpẽr kêêta pyràk. No kot kaj mẽ ã amnhĩ nhĩpêx anhỹr kêt nhũm kaxkwa kamã inhõ Papaj ja hã mẽ apumu nẽ te ho pahi tee ri kot amnhĩ tomnuj xwỳnhta kot amnhĩ nhĩpêx ã omunh nẽ hã àmnênh nhũm mẽ kot apkati mẽ tanhmã omnuj tota pyràk o mẽ anhĩpêx. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Tã nhũm Jejus mẽ inhmã kapẽr pa nẽ mẽ inhmã anẽ pa mẽ ixrohã Garirej rũm ixkato nẽ pyhti pê Jotãw hã rê nẽ hpãnhã ihkjê hã ri ixpa. Pika pê Jutej kamã. ");
INSERT INTO apnNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Hãmri nhũm mẽ ohtô nẽ Jejus pumu nẽ man mẽ ixwỳr mra nhũm mẽ omu nẽ mẽ kãm akupỹm mẽ à xwỳnhjê ho mex. ");
INSERT INTO apnNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Hãmri nhũm Parijew nhõ xwỳnh kwỳjaja hwỳr mra. Hêx rom kot kamã hamak nẽ tanhmã ho kapẽr punuj to kaxyw hwỳr mra nẽ kãm: —Pa? Kwa mẽ inhmã mẽmoj jarẽ. Tanhmã na pre amnepêm finat Mojesja mẽ pahte mẽ pahprõ kaga hã mẽ panhĩgêtjê mã karõ hto? Xà kot mẽ pahprõ pahkwỳm ri tanhmã amnhĩ nhĩpêx to pu mẽ hkaga nhũm ja Tĩrtũm mã mex nẽ nà? Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Hãmri nhũm mẽ kãm: —Nà na ka mẽ aprĩ hã Mojes kot tanhmã ja jarẽnh to mar mex kêt nẽ. Ja kot anhỹr kêt. Amnepêm mẽmoj piitã hkrax kãm na pre Tĩrtũm my nẽ nija wa hipêx. Axpẽn kaxyw wa hipêx. ");
INSERT INTO apnNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Hãmri nẽ wa hkukamã tanhmã wa kot amnhĩ nhĩpêx to hã wa harẽ nẽ wa harẽnh o: Koja mẽmyjaja hprõ kaxyw hãmri nẽ gryk ã katorxà mẽ hipêêxà wa hkaga nẽ ãm hprõ kôt pix mã pa ho pa. Te wa tipxi nẽ ri wa pa pyràk o amnhĩ nhĩpêx. Anẽ. —Na pre ã Mojes Tĩrtũm nhỹ hã mẽ kãm ja jarẽnh anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Jakamã koja te wa tipxi nẽ ri wa pa pyràk o axpẽn nhĩpêx o pa. Tĩrtũm tãm kot axpẽn mã wa õr kênã kot kêt wa axtem nẽ ri htỳx ri hamaxpẽr nẽ axpẽn kaga. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Hãmri nhũm mẽ kuma nẽ kãm: —Tỳ. Nom finat Mojes na pre mẽ pakukamã mẽ panhĩgêtjê mã ã ja hã karõ anẽ nẽ mẽ kãm: Kot kaj mẽ aprõ kaga kaxyw hãmri nẽ ra kêp aprõ hkêt ã hã kagà nhĩpêx nẽ kãm agõ nẽ amnhĩ nê hano kê ma tẽ. —Anhỹr o na pre mẽ kãm hã karõ. Tã ka na ka mẽ ixte axpẽn kaga hkêt ã mẽ inhmã karõ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Hãmri nhũm mẽ kuma nẽ mẽ kãm: —Tỳ no ãm mẽ kãm Tĩrtũm kapẽr kôt amnhĩ nhĩpêx prãm kêt jakamã na pre ã mẽ kãm ja jarẽnh anẽ. No amnepêm mẽmoj piitã hkrax kãm na prem ã amnhĩ nhĩpêx anhỹr o pa hkêt nẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Jakamã kêr ka mẽ aprõ kaga hkêt nẽ apa. Kot kaj mẽ hkaga nẽ hpãnhã nhãm mẽhõ ho aprõ nhũm Tĩrtũm noo mã te ate wam aprõ kamã nhãm aprõ nyw o amnhĩkati pyràk. Tĩrtũm pê ja omnuj tỳx nẽ. Rỳ koja mẽhõ hprõ kaga ka hpãnhã ho aprõ nhũm Tĩrtũm noo mã te ate wam mjên pê ho amnhĩkati pyràk. Ja mããnẽn Tĩrtũm pê omnuj tỳx nẽ. Anẽ. Nhũm pre ã Parijew nhõ xwỳnhjê mã kapẽr anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Hãmri pa mẽ ixte hkôt ixpa ho ixpa xwỳnhjaja ã kapẽr anhỹrja ã kuma nẽ kãm: —Xà na hte mẽ mjên ra kãm mẽ hprõ hkĩnh kêt tã hkaga hkêt nẽ arĩ hkôt pa ho pa nhũm hte Tĩrtũm mã ja mex nẽ nà? Jakamã kwa xà kot paj mẽ nhỹrmã ixprõ kaga pymaj ixprõ hkêt kumrẽx nẽ ixpa ho ixpa nhũm ja mẽ inhmã mex nẽ nà? Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Hãmri nhũm mẽ inhmã: —Nà ãm hãmri na ka mẽ ja jarẽ. No mẽ ate harẽnhja na mẽ piitã mẽ kãm mex kêt. Koja Tĩrtũm tãm amã aprõ hkêt ã ajarẽ ka rĩ aprõ hkêt nẽ ahte ajamakêtkati nẽ ri apa. ");
INSERT INTO apnNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Na htem piitã hprõ nẽ pa hkêt nẽ. Na hte kamã tanhmã mẽ kute xwỳnhjaja kormã hprĩre ri tanhmã kute mỳrapê kãm hprõ hprãm kêt nẽ pa. Nẽ kamã tanhmã mẽ ho mỳrapê nhũm mẽ hkurẽ hkêt nẽ hprõ hkêt nẽ pa. Nẽ kamã mẽ kãm Tĩrtũm mã tanhmã amnhĩ to ho pa pix prãm xàj kãm hprõ hprãm kêt nẽ pa. Tã kot kaj mẽ jajê pyrà nẽ ã amnhĩ nhĩpêx anhỹr prãm nẽ rĩ kam nẽ aprõ hkêt nẽ apa. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Tã nhũm Ijaew kwỳjaja Jejus pumu nẽ hwỳr mẽ hkrarejê jamỳ nẽ mẽ o mra. Kot mẽ hã ĩhkra jaxwỳr nẽ mẽ ho Tĩrtũm wỳr kaxyw hwỳr mẽ o mra. Hãmri pa mẽ ixte hkôt ixpa ho ixpa xwỳnhjaja tee ri mẽ omu nẽ tanhmã nê mẽ kãm ixkapẽr to nẽ mẽ kãm: —Tk. Mo kaxyw na ka mẽ Jejus wỳr mẽ o mra? Kormã mẽ ràxre kênã. Kwa mẽ ma akupỹm mẽ o mra nà? Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Hãmri nhũm Jejus mẽ inhma nẽ mẽ inhmã: —Kwa nà mẽ ri inhnê mẽhprĩjê kurê hkêt nẽ. Kwãr mẽ mãmrĩ ixwỳr mẽ o mra. Anẽ. Hãmri nẽ amnhĩ wỳr mẽ mẽ kãm hpa ho apê nhũm mẽ hwỳr mẽ o mra nhũm mẽ kuri kuhê nhũm mẽ omu nẽ mẽ hã mẽ inhmã: —E mẽ jarejê pumu. Na htem hamakêtkati nẽ hkĩnh nẽ ri pa. Nẽ mẽ kãm amnhĩ to rũnh prãm kêt nẽ. Tã Tĩrtũm kôt mẽ kot amnhĩ nhĩpêx o mẽ pa xwỳnhjaja te mẽ kot jajê pyràà nẽ kãm amnhĩ to rũnh prãm kêt nẽ pa. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Hãmri nẽ mẽ hã ĩhkra jaxwỳ nẽ mẽ ho Tĩrtũm wỳ hãmri nẽ mẽ inhmã anẽ pa mẽ ma axte mẽ kurũm mõ. ");
INSERT INTO apnNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Tã nhũm Ijaew õja Jejus wỳr tẽ nẽ kãm: —Pa mẽ ijahkre xwỳnh? Kwa inhmã mẽmoj jarẽ. Tanhmã kot pa nhỹrmã Tĩrtũm ri ixtĩr tũm nẽ ixpa ho ixpa kaxyw amnhĩ nhĩpêx to wehe? Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Hãmri nhũm kãm: —Tk. Ra Tĩrtũm kot nhỹrmã mẽ atĩr tũm nẽ apa kaxyw mẽmoj tã mẽ amã karõ nhũm ate mar mex kênã kot ka kêt ri axte ja hã ixkukja. Nà Tĩrtũmja mex o mex jakamã kot kaj amã kuri atĩr tũm nẽ apa hprãm hã kot kaj kapẽr kôt amnhĩ nhĩpêx no ri apa. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Hãmri nhũm kãm: —No nhỹ kapẽr kôt kot paj amnhĩ nhĩpêx o ri ixpa wehe? Anẽ. Hãmri nhũm kãm: —Na pre mẽ amã mẽmoj tã karõ ho: Kêr ka mẽ axpẽn par kêt nẽ. Nẽ nhãm mẽ hprõ ho amnhĩkati hkêt nẽ. Nẽ mẽ kêp axàhkĩnh kêt nẽ. Nẽ tanhmã mẽ ho axêx to hkêt nẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Nẽ anhĩpêêxà mẽ akatorxà wa hã apijaàm nẽ wa ho mex pê wa kutã anojarêt o ri apa. Nẽ amã akwỳjê hã ma ho te ka amã amnhĩ tã ma pyràk o mẽ hipêx. Jao tãm mẽ hipêx o ri apa. E kot kaj amã nhỹrmã Tĩrtũm kuri atĩr tũm nẽ apa hprãm hã kêr ka ã amnhĩ nhĩpêx anhỹr o ri apa. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Hãmri nhũm kuma nẽ kãm: —Ku nhũm. Ra ã ixte amnhĩ nhĩpêx anhỹr o ri ixpa kênã. Nom te kormã ixtĩr tũm nẽ ixpa kaxyw ixte tãm kêt pyràk. Kwa axte inhmã mẽmoj jarẽ nà? Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Hãmri nhũm kãm: —Nà kormã mẽmoj pyxi nẽ arĩk. Na ka amã akukrêx rax prãm tỳx o amã Tĩrtũm prãm jakre. Jakamã ma akupỹm tẽ nẽ akukrêx rax o wẽnê hpa nẽ hpãnhã kàxpore jamỳ nẽ ma mẽ kêp amrakati xwỳnhjê mã õr pa. Hãmri nẽ rĩ akupỹn ixwỳr tẽ nẽ rĩ ixkôt apa ho apa. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Hãmri nhũm kuma nẽ tee ri amnhĩ kukamã hamaxpẽr. Kãm hikukrêx rax japê nẽ kãm kamã ĩhkra karo hprãm kêt nẽ. Hãmri nẽ tee ri Jejus kot ã kãm hã karõ anhỹrja ma nhũm ja kêp omnuj nẽ nhũm ma akupỹm htẽm kurê kumrẽx. ");
INSERT INTO apnNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Hãmri nhũm Jejus tee ri omu nẽ mẽ inhmã: —Hêxta waa nẽ. Koja mẽ hikukrêx rũnh xwỳnhjaja ohtô nẽ kãm mẽ hikukrêx japê xàj Tĩrtũm mẽ wa ixri htĩr tũm nẽ pa ho pa hkêt nẽ. Wa ixte amnhĩ nhĩpêxja mẽ kêp hihtỳx. ");
INSERT INTO apnNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Mẽ kãm hikukrêx rũnh mã ĩhkra karo hprãm kêt rãhã tee ri kãm Tĩrtũm kôt amnhĩ nhĩpêx prãm kaprỳ. Te ho mẽhõ kot menh kagô hã hkre nẽ kãm kagô katõk prãm kêt rãhã kãm guhkrax kãm àr prãm kaprỳta pyràk. Anẽ. Nhũm pre ã Jejus mẽ inhmã kapẽr anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Hãmri pa mẽ kuma nẽ tee ri amnhĩ kukamã ijamaxpẽr nẽ kãm: —Kwa mẽ ixpiitã mẽ inhmã mẽ ixkukrêx japê kênã. Jakamã xà kot paj mẽ ixpiitã nhỹrmã war ari ixtĩr tũm nẽ ixpa ho ixpa hkêt nẽ nà? Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Hãmri nhũm mẽ inhmã: —Nà kot kaj mẽ amnhĩ krã hkôt mẽ amã mẽ akukrêx japêja mã anhũrer kêt nẽ. Ãm Tĩrtũm pix na hte ja kaxyw tanhmã mẽ akrã hto ka mẽ amã akukrêx japê hkêt nẽ. Jao ra mẽ apê Tĩrtũm mẽ wa ixri atĩr tũm nẽ mẽ apa ho mẽ apa mã xwỳnh. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Hãmri nhũm Simãw Pêtre kãm: —Kwa no we mẽ pajaja Pahihti? Na pa prem agryk ã mẽmoj piitã hkaga hpa nẽ akôt ixpa ho ixpa. Jakamã kot paj mẽ nhỹrmã war ari ixtĩr tũm nẽ ixpa ho ixpa nà? Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Hãmri nhũm kuma nẽ mẽ ixpiitã mẽ inhmã: —Tỳ. Kot paj nhỹrmã mẽmoj piitã ho nyw pa hãmri nẽ ixte mẽ ho amnhĩptàr o ixkrĩ xà maati kamã nhỹ nẽ mẽ piitã mẽ kot tanhmã amnhĩ nhĩpêx to hã mẽ omunh xà hkôt tanhmã mẽ harẽnh to. Tã mẽ kajaja mẽ ate ixkôt apa ho apa xwỳnhjaja kot kaj mẽ inhmã Ijaew kot amnhĩ nhĩpêx ã mẽ omunh xà hkôt ahpỹnhã tanhmã inhmã mẽ harẽnh to. Mẽ mex ã mẽ harẽ rỳ mẽ mex kêt ã mẽ harẽ. Kot kaj mẽ ã inhmã mẽ harẽnh anẽ. Ãm hãmri na pa mẽ amã ixkapẽr anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","—Nẽ ka mẽ atõ inhmã tanhmã amnhĩ nhĩpêx to ho apa kaxyw akwỳjê re nẽ ma inhmã mẽmoj to anhỹr o ri apa. Tanhmãn anhõrkwỹ rỳ atõ rỳ atõx re. Rỳ aprõ nẽ akrajê re. Rỳ akatorxà mẽ anhĩpêêxà war are. Rỳ akukrêx piitã rer pa hãmri nẽ ma mẽ piitã mẽ kãm ixkapẽr o mẽ ahkre ho ri mẽ hkôt apa. Hã kot paj mẽ apumu nẽ mẽ ato mex rax nẽ. Hãmri ka mẽ ma mẽ hkôt apa nẽ mẽ kãm ixkapẽr jarẽnh o apa nhũm mẽ kot mẽ amar xwỳnh kwỳjaja mẽ ama nẽ kãm mẽ akĩnh nẽ. Nẽ ra mẽ ate akwỳjê rer par tã mẽ tãmjaja te mẽ apê mẽ hkra rỳ mẽ htõ rỳ mẽ htõx pyràk o mẽ anhĩpêx nẽ mẽ ato mex o pa. Hãmri ka mẽ nhỹrmã ty nẽ ma Tĩrtũm mẽ wa inhõ krĩ hwỳr api nẽ wa ixkuri amex kumrẽx nẽ atĩr tũm nẽ apa ho apa. ");
INSERT INTO apnNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Nom kwa kêr ka mẽ amnhĩ tã ja ma nẽ amnhĩ to rũnh xwỳnh ã amnhĩ kamnhĩx kêt nẽ. Jar mẽ kot amnhĩ to rũnh ã amnhĩ to jarkrar xwỳnhjaja koja mẽ nhỹrmã amnhĩ to hkryre hã amnhĩ pumu. No jar mẽ kot amnhĩ to hkryre xwỳnh ã amnhĩ jarẽnh xwỳnhjaja koja mẽ nhỹrmã amnhĩ to rũnh ã amnhĩ pumu. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Nhũm Jejus arĩ mẽ ixte hkôt ixpa ho ixpa xwỳnhjê mã awjarẽ nẽ mẽ inhmã: —Nẽ kot paj nhỹrmã tanhmã mẽ ato mex to. Te ixpê hpur nhõ dõn kot amnhĩ nhĩpêx pyràk o mẽ anhĩpêx. Koja pur nhõ dõnja ihpur kãm mẽmo xô ra hkà hpa nhũm omu hãmri nẽ kaxyw mẽ àpênh xwỳnhjê japêr kaxyw ma gàm tẽ. Nẽ gàp xa nẽ mẽ kãm akir nhũm mẽ hã akuprõ. ");
INSERT INTO apnNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Hãmri nhũm mẽ kãm: “E. Kot kaj mẽ jarãhã inhmã ixpur kãm apê. Kot kaj mẽ inhmã axàpênh o amỹkry pa hpãnhã mẽ kot apkati pixi hã mẽ àpênh pãnhã mẽ kãm amnhĩrer xàja kôt mẽ amã amnhĩre.” Anẽ hãmri nhũm mẽ kuma nẽ kãm: “Tôe. Nà kot paj mẽ amã apê.” Anẽ nhũm pur wỳr mẽ kurẽ nhũm mẽ ma kãm àpênh mã mra. ");
INSERT INTO apnNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","—Tã nhũm arĩ kỳx mã myt tẽ nhũm pur nhõ dõn akupỹm gàm tẽ nhũm mẽ hkwỳja arĩ kuhê. ");
INSERT INTO apnNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Nhũm tee ri mẽ omu nẽ mẽ kãm: “Kwa mon ka mẽ axàpênh kêt nẽ arĩ akuhê? E. Mẽ ma wamtajê hkôt mra nẽ inhmã apê pa hpãnhã mẽ amã amnhĩrer mex nẽ.” Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Hãmri nhũm mẽ kuma nẽ ma mẽ hkôt mra. Tã nhũm ra myt kaxkwa nhĩpôk ri ajêt nhũm hpur nhõ dõnja mã hkwỳjê ho anẽ nẽ. Kê axte mẽ hkôt jajê jano nhũm mẽ ma mẽ hkôt mra. Tã nhũm ra myt ahpanh grire nhũm ma akupỹm kêwe gàm tẽ nẽ mã mẽ ho anẽ nẽ axte mẽ hkôt jajê rẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","—Tã nhũm ra myt grire nhũm ma akupỹm kêwe gàm tẽ nẽ jajê pumu nhũm kê wem arĩ gàp kuhê. Hãmri nhũm tee ri mẽ omu nẽ mẽ kãm: “Kwa mon ka mẽ axàpênh kêt nẽ atỳx gàp akuhê ho akuhê?” Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Hãmri nhũm mẽ kãm: “Nà mẽhõ kot mẽ inhmã mẽ ixàpênh ã karõre hã.” Anẽ. Hãmri nhũm mẽ kãm: “Tôe. Mẽ ma mẽ hkôt ixpur wỳr mra nẽ inhmã mãn apê.” Anẽ hãmri nhũm mẽ kuma nẽ ma hkwỳjê hkôt mra. ");
INSERT INTO apnNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","—Tã nhũm ra kamàt. Hãmri nhũm hpur nhõ dõnja kãm àpênh xwỳnhjê krãhtũm wỳr tẽ nẽ kãm: “E. Ma mẽ hwỳr tẽ nẽ mẽ kãm anẽ kê mẽ àpênh kaga nẽ man akôt mra ka inhmã mẽ kãm amnhĩre. Nom kêr ka hapu hã mẽ mõr xwỳnhjê kumrẽx mã amnhĩre nẽ wam mẽ mõr xwỳnhjê ho hapu nẽ mẽ kãm amnhĩre.” Anẽ. Hãmri nhũm kãm: “Tôe. Nà kot paj mẽ ho anẽ.” Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Hãmri nẽ ã mẽ kãm amnhĩrer anẽ. Hapu hã mẽ mrar xwỳnhjê kumrẽx mã amnhĩre. Te mẽ kot kwỳhtã àpênh o amỹkry pyràk o nhũm hpãnhã mẽ kãm amnhĩre. ");
INSERT INTO apnNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Hãmri nhũm wam mẽ mrar xwỳnhjaja ja hã mẽ omu nẽ hkĩnh nẽ. Hãmri nẽ htỳx hamaxpẽr o: “Nà kot paj xep kàxpore jamỳnh rax o mẽ hakre. Ixàpênh rax o ixte mẽ hakrenh kênã.” Anhỹr tã no nhũm mẽ piitã mẽ kãm amnhĩrer o axpẽn pyràk. Ra pur nhõ dõn kot kãm hã karõ xà hkôt. ");
INSERT INTO apnNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Hãmri nhũm mẽ hamỳ nẽ tee ri hkre kamã omu nẽ we ra hpur nhõ dõnja kamã gryk nẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Hãmri nẽ hwỳr mra nẽ kãm: “Kwa jajaja na mẽ amã àpênh o ore pyxi nẽ. No kêt mẽ pajaja na pa mẽ kwỳhtã ixàpênh rax o kamàt. Arĩgro htỳx kãm ixàpênh o ixãm o ixtã kamàt tã ka pẽr ãm mẽ inhmã amnhĩrer o axpẽn pyràk. Kwa na ka mẽ ixtomnuj nẽ.” Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Hãmri nhũm mẽ kuma nẽ mẽ kãm: “Tk. Nà na pa mẽ atomnuj kêt nẽ. Na pa kwỳhtã tanhmã mẽ amã amnhĩrer to xà jarẽ ka mẽ inhma nhũm ja mẽ amã mex nẽ ka mẽ ma hwỳr axàpênh mã mra. ");
INSERT INTO apnNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Kwa mẽ akàxpore jamỳ nẽ ma mra. Ãm pa inhmã hprãm xà hkôt na pa ã mẽ amã amnhĩrer anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Ixkàxpore jakamã kot paj nhãm inhmã mẽhõ mã õr prãm xà hkôt kãm kugõ. Tã ka mẽ ã mẽ hã ixkamã agryk anẽ. E mẽ akàxporeja mỳ nẽ ma mra.” Anẽ. Nhũm ã hpur nhõ dõn mẽ kãm kapẽr anẽ. Ã mẽ ujarẽnh kot anhỹr. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Nhũm pre ã Jejus mẽ inhmã ujarẽnh anẽ nẽ mẽ inhmã: —Ja pyrà nẽ wam mẽ ate ixkôt amnhĩ xunhwỳr xwỳnhjaja nẽ hapu hã mẽ kot kormã ixkôt amnhĩ xunhwỳr mã xwỳnhjaja kot paj nhỹrmã mẽ apiitã mẽ ato mex kumrẽx o axpẽn pyràk. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Tã nhũm Jejus mẽ inhmã anẽ pa mẽ ixrohã ma Jerujarẽ hwỳr mõ. Mẽ ohtôjê hkôt mõ. Hãmri nhũm Jejus mẽ ixpê 12jê mã anẽ nẽ mẽ ixkwỳjê hkàx ã mẽ inhmã kapẽr kaxyw ahte hapu hã mẽ ixto mõ. ");
INSERT INTO apnNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","Hãmri nẽ mẽ inhmã amnhĩ kukamã tanhmã amnhĩ jarẽnh to nẽ mẽ inhmã: —E na pu mẽ ra Jerujarẽ hwỳr mõ. Kamã koja mẽ pahkwỳjaja inhĩpêx kati nẽ. Koja mẽ patre krãhtũmjê mẽ Mojes kapẽr o mẽ ahkre xwỳnhjê nhĩhkram ijaxà nhũm mẽ kot ixpĩr kaxyw ixtã amỹnê. ");
INSERT INTO apnNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Koja mẽ kãm ixkurê xwỳnhjaja ixpynê nẽ Rõm nhõ xwỳnhjê nhõ pôristijê hwỳr ixto tẽ nẽ mẽ kãm tanhmã ixto hêx to. Hãmri nhũm mẽ kuma nẽ mẽ mar xà hkôt tanhmã inhĩpêx to. Nhũm mẽ hkwỳjaja ixtã hpẽr o axkẽ nẽ ixtã akunha nhũm mẽ hkwỳjaja ixto kapẽr punuj nẽ tanhmã ijaprỳ hto nẽ ixtak. Hãmri nẽ ma ixto tẽ nẽ pĩ kahpa hã inhô nẽ ixpĩ. Ã koja mẽ inhĩpêx anẽ. Nom kot paj ixtyk ã ixtã apkati axkrunẽpxi nhũm Tĩrtũm akupỹm ixto ixtĩr. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Tã nhũm Jepetew prõja amnhĩ kôt Jejus wỳr hkra Xiakre mẽ Juãwja wa o tẽ. Kot wa ho Jejus wỳr kaxyw hwỳr wa o tẽ. Mẽ ixpyrà nẽ wa kot Jejus kôt pa ho pa xwỳnhjê hõ na pre wa nhũm wa katorxàja Jejus wỳr wa o tẽ. Hãmri nẽ kutã hkõnkrã ho tẽm nẽ nhỹ ");
INSERT INTO apnNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","nhũm kãm: —Pa mo na? Anẽ. Hãmri nhũm kãm: —Ma ixkrata na pa ixte wa ho awỳr kaxyw awỳr wa o tẽ. Xê kot kaj nhỹrmã ate mẽ piitã mẽ ho amnhĩptàr kaxyw nhỹ nhũm ixkrata wa akutã anhĩjê nẽ wa kêp anhõ kôwenatô nẽ akutã anhĩjê nẽ wa ato nhỹ. Ja prãm xàj na pa ã wa ho awỳr anẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Hãmri nhũm kuma nẽ Xiakre mẽ Juãw wa omu nẽ wa kãm: —Nà na war akatorxàja htỳx ã war ato ixwỳr anẽ. Koja mẽ tokyx ixpĩ kot paj amnhĩ xà htỳx kãm ijamak kãm ty. Tã xà koja mẽ ixpyrà nẽ ã war anhĩpêx anẽ ka wa ixpyrà nẽ amnhĩ xà htỳx kamã ajamak rax kãm ty nà? Anẽ. Hãmri nhũm wa kãm: —Tỳ. Nà kot pa wa ijaxwỳja anẽ nẽ apyrà nẽ amnhĩ xà htỳx kãm ijamak kãm ty. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Hãmri nhũm wa kãm: —Nà ãm hãmri na ka wa amnhĩ jarẽ. War ate ixpyrà nẽ ixkôt amnhĩ xà htỳx kãm ajamak kãm atyk mã kênã. Tã nom war akatorxà kot war ato ixwỳrta ã kot paj tanhmã war amã nẽ hkêt nẽ. Kêt inhõ Papaj tãm koja ixkaxyw mẽhõ japêr nhũm inhĩhkô hã nhỹ. No pa kot paj amnhĩ kaxyw mẽhõ jarẽnh kêt nẽ. Anhỹr o wa kãm kapẽr. ");
INSERT INTO apnNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Hãmri pa mẽ ixte wa uràk nẽ Jejus kôt ixpa ho ixpa xwỳnhjaja wa katorxà kot ã wa ho Jejus wỳr anhỹrja ã kuma nẽ wa kamã inhgryk nẽ. Hãmri nẽ axpẽn mã ixkapẽr o: —Tk. Nà koja Juãw mẽ Xiakre wa nhỹrmã kêp õ kôwenatô nẽ mẽ pahto amnhĩptàr kêt kumrẽx. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Nhũm Jejus mẽ inhma nẽ amnhĩ wỳr mẽ ixpiitã mẽ inhmã hpa ho apê nẽ mẽ inhmã: —E mẽ amnẽ ixwỳr axkamẽ pa mẽ amã awjarẽ mãn. Anẽ. Hãmri pa mẽ hwỳr axkamẽ nhũm mẽ inhmã: —E mẽ inhma. Na hte Ijaew kêt xwỳnhjê nhõ pahijaja ã amnhĩ nhĩpêx anhỹr o ri pa nẽ amarĩ hkrĩ xà kamã hkrĩ ho hkrĩ. àhpumunh tỳx jakamã amarĩ ixkre hkre jakry kamã hkrĩ ho hkrĩ nẽ kãm mẽ àpênh xwỳnhjê pix mã mẽmo mẽ àpênh ã karõ. Na htem ã amnhĩ nhĩpêx anhỹr o hkrĩ. Nẽ mẽ kot mex ã harẽnh kaxyw tanhmã mẽ ho mex to ho pa. ");
INSERT INTO apnNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","27","Tã no mẽ kajaja. Kêr ka mẽ ho mẽ uràk kêt nẽ. Ãm te amarĩ ri mẽ apa pyràk o axpẽn nhĩpêx o ri apa. Nẽ te mẽ apê mẽ kãm axàpênh xwỳnh pyràk o amnhĩ nhĩpêx o ri mẽ hkôt apa. No kêr ka mẽ ho amnhĩptàr mã ajamaxpẽr o ri apa hkêt nẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Mẽ ate mẽmoj tã pa ixkutã anojarêt ho apa kaxyw na pa pre mẽ awỳr ixwrỳk kêt nẽ. Ixte amarĩ mẽmoj to mẽ kamjaja mẽ akutã inhnojarêt o ixpa kaxyw na pa pre mẽ awỳr wrỳ. Nẽ mẽ ate ixkôt amnhĩ xunhwỳr xwỳnhjê nê ixtyk kaxyw na pa pre wrỳ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Tã pa mẽ Jejus kôt kormã Jerujarẽ hwỳr ra Jeriko htêp o mõ. Hãmri nẽ kurũm ixkaton mõ nhũm mẽ ohtô nẽ mẽ ixkôt mra. ");
INSERT INTO apnNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Nhũm pry nhĩhkjê hã no hkre xwỳnh wa àhwỳr o hkrĩ xwỳnhja wa amnhĩ wỳr mẽ inhmrar mar o nhỹ. Mẽ ohtôô nẽ Jejus kôt mẽ mrar xwỳnhjê mrar ma nẽ mẽ kãm: —Kwa mo na? Mẽmoj wỳr na ka mẽ axohtô nẽ mra? Anẽ. Hãmri nhũm mẽ wa kãm: —Nà Jejus pê Najare nhõ xwỳnhta kôt na pa mẽ mra. Anẽ. Hãmri nhũm wa mẽ kuma hãmri nẽ kàx pê Jejus mã kapẽr nẽ kãm: —Pa Pahihti? E apê mẽ inhõ Pahihti mex na ka. Te apê amnepêm anhĩgêt pahihti Tawita pyràk. Jakamã kwa wa ixkamã axukaprĩ nẽ akupỹm wa ixto mex. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Hãmri nhũm Jejus kôt mẽ mõr xwỳnhjaja wa kuma nẽ wa kãm: —Tk. Kwa war akapẽr kêt nẽ nhỹ nà. Anẽ. Tã no nhũm wa ãm mẽ kuma nẽ xatã amnhĩ to kuwỳ. Kàx pê amnhĩ to kuwỳ. ");
INSERT INTO apnNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Hãmri nhũm Jejus wa kuma nẽ xa nẽ wa omu nẽ wa kãm: —Pa mo na? Tanhmã kot pa wa ato? Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Hãmri nhũm wa kãm: —Nà akupỹm wa inhmã wa ixrĩt mex prãm. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Hãmri nhũm kãm wa hkaprĩ nẽ wa no htok nhũm wa akupỹm rĩt mex kurê kumrẽx. Hãmri nẽ rĩt mex ã amnhĩ pumu nẽ hkĩnh tỳx nẽ ma Jejus kôt hkwỳjê hkôt mõ. ");
INSERT INTO apnNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Tã nhũm Jejus kormã Jerujarẽ hwỳr kormã mõ. Pa mẽ hkôt mõ nẽ ra Petake hwỳr ixàhtêp o mõ. Hixêt pê Oriwêhti kahti ri na pre krĩja xa. Jakamã pa mẽ wa hwỳr ixàhtêp o mõ nhũm Jejus mẽ ixte hkôt ixpa ho ixpa xwỳnhjê wa ho axkrut nẽ amnhĩ kukamã wa kumẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Nẽ wa kãm: —E wa ma krĩ mũj wỳr mẽ ixkukamã wa tẽ. Nẽ wa hwỳr axà nẽ nhỹri jumẽnre mẽ hkra wa kãm ê nẽ wa ãm xwỳnh wa omu hãmri nẽ kãm ê xà hpôt nẽ man akupỹn amnẽ hamẽ wa o tẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Koja mẽhõ ja hã war apumu nẽ hã tanhmã war amã kapẽr to ka wa kãm ã ijarẽnh anẽ nẽ kãm: “Nà mẽ panhõ Pahihti na hã karõ pa wa hwỳr tẽ.” Anhỹr o wa kãm ijarẽ. Hãmri nhũm war ama nẽ war amã õr kurê kumrẽx. E wa ma hwỳr tẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Tĩrtũm kapẽr ã kagà htũm ra kot ja kukamã harẽnh. Na pre ra Tĩrtũm nhỹ hã kapẽr xwỳnhjê hõ ja jarẽ nẽ hã kagà ho: ");
INSERT INTO apnNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Pa Jerujarẽ nhõ xwỳnhjaja. Kwa mẽ tee ri amnhĩ kukamã ajamaxpẽr ho amã ma hkêt nẽ. Ota mẽ anhõ pahi nywta ra jumẽnre hã nhỹ nẽ mẽ awỳr hpôx o tẽ. Te kot amnhĩ to grire xwỳnh pyràk o amnhĩ nhĩpêx nẽ tẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Anhỹr o kot hkukamã harẽnh jakamã nhũm Jejus amnhĩ kukamã ja wa kumẽ hãmri nhũm wa ma hwỳr htẽm kurê kumrẽx. ");
INSERT INTO apnNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Nẽ krĩta wỳr pôj nhũm Jejus kot wa kãm harẽnh xà hkôt nhũm wa jumẽnreta pumu. Hãmri nẽ hamẽ wa kãm ê xà hpôt nẽ ma Jejus wỳr wa o tẽ. Hãmri nẽ kaxyw amnhĩ xê hkwỳ hkwrỳ nẽ kãm ho jumẽnre nywta kô kahty. Nẽ kãm ho htỳx nẽ o xa nhũm Jejus hã nhỹ nẽ hã mõ. ");
INSERT INTO apnNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Kormã Jerujarẽ hwỳr hixêt ã àpir o mõ. Nhũm mẽ kot omunh o kuhê xwỳnhjaja hkĩnh nẽ ma hkukamã pry ho mex kaxyw amnhĩ xê hkwỳptyr ho mõ. Nẽ pô hkwỳ jakà nẽ utyr o mõ. ");
INSERT INTO apnNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Nhũm mẽ hkwỳjaja Jejus kukamã mra nhũm mẽ hkwỳjaja hapu hã hkôt mra. Nẽ piitã kàx pê Tĩrtũm mex o mex ã harẽnh o hkôt mõ nẽ harẽnh o: Ota Tĩrtũm kot mẽ pahwỳr mẽnh xwỳnhta ra pôj. Ãm hãmri na mẽ pahwỳr wrỳ. Ja na mex kumrẽx. Kêp mẽ panhõ Pahihti mex na. Ãm hãmri na pre Tĩrtũm mẽ pahwỳr kumẽ. Tĩrtũm mex kumrẽx. Ãm mex o mex. Anhỹr o Jejus kôt Jerujarẽ hwỳr harẽnh o mõ. Kot mẽ ho amnhĩptàr kurê kumrẽx ã hkamnhĩx jakamã hkĩnh nẽ hkôt ã harẽnh anhỹr o mõ. ");
INSERT INTO apnNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Hãmri nhũm krĩ nhõ xwỳnhjaja tee ri mẽ kuma nẽ axpẽn mã: —Kwa mẽhõ na we hpôx o mõ nhũm mẽ ã hkôt harẽnh anhỹr o mõ? Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Hãmri nhũm Jejus kôt mẽ mrar xwỳnhjaja mẽ kuma nẽ mẽ kãm: —Nà Tĩrtũm nhỹ hã kapẽr jarẽnh xwỳnh pê Jejus na. Kêp Garirej kamã krĩ pê Najare nhõ xwỳnhta na. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","13","Tã hãmri nhũm Jejus Jerujarẽ wỳr axà nẽ jumẽnre rũm wrỳ nẽ ma Tĩrtũm mã amnhĩ jarẽnh xà hã ixkre hwỳr tẽ nẽ axà. Hãmri nẽ tee ri mẽ kot tanhmã ixkre kamã amnhĩ nhĩpêx to hã mẽ omunh o xa. Nhũm mẽ axtem nẽ môx nẽ ôwêhti nẽ tuuti ho wẽnê ho kuhê. Mẽ kot haprôr nẽ Tĩrtũm mã amnhĩ jarẽnh kaxyw kãm hpar nẽ õr kaxyw mẽ kãm ho wẽnê ho kuhê. Nom axtem nẽ mẽ kãm hã ohtô rax kãm mẽ kãm ho wẽnê. Hãmri nhũm Jejus mẽ hwỳr axà nẽ tee ri mẽ omu nhũm ja kêp omnuj tỳx kumrẽx. Hãmri nhũm mẽ hwỳr tẽ nẽ mẽ kot kàxpore ho pinhpanh xwỳnhjê pê mẽ õ mêsti rẽnh pa. Nẽ mẽ kot tuuti ho wẽnê xwỳnhjê pê hkrĩ xà hkujate nẽ rẽnh pa. Hãmri nẽ mẽ kãm: —Tk. Kwa Tĩrtũm kapẽr ã kagà htũm kot ixkreja jarẽnh kot: Inhõrkwỹja ãm mẽ ate inhmã amnhĩ jarẽnh xà hã ixkre pix kaxyw na. Anhỹr o kot harẽnh tã ka mẽ axtem nẽ kamã ã amnhĩ nhĩpêx anẽ. E kwa mẽ ajapôx tokyx anẽ. Anẽ. Hãmri nẽ mẽ kator pa nhũm mẽ ma hapêx. ");
INSERT INTO apnNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Hãmri nhũm mẽ no hkre xwỳnhjaja nẽ mẽ hyk o mẽ pa xwỳnhjaja mra nẽ agjê nẽ Jejus kutã kuhê nhũm mẽ omu nẽ akupỹm mẽ ho mex. ");
INSERT INTO apnNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","16","Hãmri nhũm mẽhprĩ hkwỳjaja hwỳr mra nẽ kuri kãm mex o mex ã gre nẽ kãm grer o: Amex kumrẽx Pahihti. Tĩrtũm na pre mẽ ixwỳr amẽ. Kot kaj te anhĩgêt Tawi pyrà nẽ mẽ ixto amnhĩptàr o apa. Anhỹr o kãm grer o kuhê. Hãmri nhũm patre krãhtũm mẽ Tĩrtũm kapẽr tũm o mẽ ahkre ho mẽ pa xwỳnhjaja tee ri ã mẽ grer anhỹr ã mẽ kuma. Nẽ tee ri Jejus kot mẽ no hkre xwỳnhjê mẽ mẽ hyk o mẽ pa xwỳnhjê ho mex ã omunh o kuhê nẽ gryk nẽ Jejus wỳr tẽ nẽ kãm: —Kwa na mẽhprĩjaja mẽ grer kãm ã ajarẽnh anẽ ka mẽ mar kêt nẽ? Mẽ grerja mexti hã. Anẽ. Hãmri nhũm mẽ kãm: —Tỳ ixte mẽ mar kênã. Tĩrtũm kãm hprãm xà hkôt na mẽ ã inhmã inhmex o inhmex ã ixtã grer anẽ. Tĩrtũm kapẽr ã kagà htũm kot ã mẽ hkukamã harẽnh kot anhỹr. Mẽ harẽnh kot: Koja mẽhprĩjaja Pahihti mã mex o mex ã grer o kuhê. Anhỹr o kot mẽ hkukamã harẽnh kênã. Tã mãn ka mẽ kormã kamã harẽnh kêt jakamã na ka mẽ ja jarẽnh mar kêt nẽ. Kwãr mẽ mãmrĩ ã inhmex ã grer anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Anhỹr o mẽ kãm kapẽr hãmri nẽ mẽ inhmã anẽ pa mẽ ixkreta rũm ijapôj nẽ ma akupỹm Petãn wỳr mra nẽ kamã amnhĩm hikra. ");
INSERT INTO apnNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Tã nhũm kwỳhtã nhũm Jejus kànhmã nhỹ nẽ mẽ inhmã anẽ pa mẽ ixrohã ma akupỹm Jerujarẽ hwỳr mra. Hãmri nẽ kormã mõ nhũm Jejus pry kahti ri ra kãm prãm nẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Hãmri nẽ mẽmo pĩ pê fikêhti jarẽnhja pumu nẽ kot ô hkwỳ rênh nẽ hkrẽr kaxyw hwỳr màt. Hãmri nẽ tee ri ô japêr nhũm ô hkêt nẽ ãm hô hpix harir. Hãmri nhũm tee ri omu nẽ kãm: —E kot kaj axte axô hkêt kumrẽx. Anhỹrja o nhũm grà par kurê kumrẽx. ");
INSERT INTO apnNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Hãmri pa mẽ ixte hkôt ixpa ho ixpa xwỳnhjaja omu nẽ Jejus mã: —Kokỹỹ. Kwa tanhmã na we amnhĩ nhĩpêx to nẽ grà kurê kumrẽx? Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Nhũm mẽ inhmã: —Nà kot kaj mẽ ixpyrà nẽ fikêhti kot tanhmã amnhĩ nhĩpêx to kaxyw Tĩrtũm mã ajamaxpẽr tỳx nẽ nhũm amã hprãm xà hkôt amã tanhmã hipêx to. Nom kêr ka mẽ ajamaxpẽr kati ho tee ri hkukamã ajamaxpẽr kêt nẽ. Ãm kaxyw Tĩrtũm kôt ajamaxpẽr tỳx nẽ nhũm mẽ amã tanhmã mẽmoj nhĩpêx to. Ãm hãmri na pa mẽ amã ja jarẽ. No ãm ja pix kêt. Kot kaj mẽ mããnẽn hixêt mũj mã akapẽr nẽ kãm: “E anhỹr xàta rũm akato nẽ ma tẽ nẽ gô rax kãm mrõ.” Anẽ nhũm amar xà hkôt ã amnhĩ nhĩpêx anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","—Nẽ kot kaj mẽ mẽmoj tã Tĩrtũm wỳ nẽ kaxyw kãm ajamaxpẽr tỳx kãm hã awỳ nhũm amã mẽmoj prãm xwỳnhta gõ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Nhũm arĩgro hõ hã nhũm Jejus kêwe axte Tĩrtũm mã amnhĩ jarẽnh xà hã ixkreja wỳr axà nẽ kamã mẽ ahkre ho nhỹ. Mẽ kãm tanhmã mẽ kot amnhĩ nhĩpêx to nẽ nhỹrmã Tĩrtũm mẽ wa kuri htĩr tũm nẽ pa kaxyw tanhmã mẽ kãm kapẽr to ho nhỹ. Hãmri nhũm Ijaew krãhtũmjê mẽ mẽ õ patre krãhtũmjaja hãmri hwỳr mra nẽ hêx rom mẽmoj tã hkukja nẽ kãm: —Kwa mẽ inhmã amnhĩ jarẽ. Mẽhõ nhỹ hã na ka hte ã amnhĩ nhĩpêx anhỹr o apa? Na ka hte akupỹm mẽ ho mex o apa nẽ tanhmã mẽ ahkre hto ho apa. Xà amnhĩ krã hkôt na ka hte ã amnhĩ nhĩpêx anẽ nà? Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Hãmri nhũm mẽ kãm: —Nà kot pa ixkumrẽx mẽmoj tã mẽ akukja. Ka mẽ inhma nẽ tanhmã inhmã harẽnh to pa rĩ kormã mẽ amã amnhĩ jarẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","26","Finat Juãw Paxis ã kot paj mẽ akukja. Mẽhõ nhỹ hã na pre hte mẽ hkrã kumrãr o pa? Xà amnhĩ krã hkôt nà? Xà Tĩrtũm nhỹ hã? E mẽ atõ inhmã ja jarẽ. Anẽ. Hãmri nhũm mẽ kuma nẽ tee ri kot tanhmã kutã kãm harẽnh to hkukamã hamaxpẽr pê axpẽn pumunh o kuhê nẽ axpẽn mã: —Kwa tanhmã kot puj wem kãm ja jarẽnh to? Or mẽ kot mar o kuhê xwỳnhjaja na htem kêp Tĩrtũm nhỹ hã kapẽr jarẽnh xwỳnh ã harẽ. Tã kot puj mẽ kãm kot amnhĩ krã hkôt kot mẽ hkrã kumrãr ã harẽ nhũm mẽ tee ri mẽ pama nẽ mẽ pakamã gryk tỳx nẽ. Nẽ mẽ paxêx rom ã mẽ pahte kãm pakapẽr anhỹr ã mẽ pahpumu nẽ kẽn o mẽ pahtak o mẽ panhĩmex. No kot puj mẽ kãm Tĩrtũm nhỹ hã kot mẽ hkrã kumrãr ã harẽ hãmri nhũm mẽ pamã: “Kwa ã kot anhỹr kênã na ka prem kapẽr ma nẽ hkôt ajamaxpẽr kêt nẽ?” Anẽ. Jakamã kot puj mẽ ja pymaj tanhmã kãm harẽnh to hkêt nẽ. Kot puj mẽ ãm kãm aa te mẽ pahte ja jarẽnh mar kêt pyràk o harẽ. Anẽ. Mẽ kot tanhmã Jejus mã nẽ nhũm kot ta pãnhã tanhmã mẽ kãm nẽ pymaj nhũm mẽ tee ri kãm tanhmã nẽ hprãm kaprỳ o kuhê. ");
INSERT INTO apnNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Hãmri nẽ kãm: —Konẽn. Mẽ ixte mẽhõ nhỹ hã kapẽr o pa hã omunhre hã. Anẽ. Hãmri nhũm mẽ kuma nẽ mẽ kãm: —Tk. Tôe kot pa xep ijaxwỳja mẽ amã tanhmã amnhĩ jarẽnh to hkêt nẽ. Ijaxwỳja ixte mẽhõ nhỹ hã ã ixte amnhĩ nhĩpêx anhỹr o ri ixpa hã amnhĩ pumunhre hã. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Hãmri nhũm Jejus axte Ijaew krãhtũmjê mẽ mẽ õ patre krãhtũmjê mã kapẽr nẽ mẽmoj tã kuxi nẽ tanhmã mẽ kãm ujarẽnh to nẽ mẽ kãm: —E pa mẽ amã awjarẽ ka mẽ inhma. Koja mẽhõ hkra my hamẽxkrut. Hãmri nẽ hkra kot waja mã tanhmã kapẽr to nẽ kãm: “E kêr ka jarãhã ma tẽ nẽ inhmã pur kãm apê.” Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Hãmri nhũm kuma nẽ pur mã htẽm kaga nẽ hitõt nẽ. Tãã no ãm hã ahtũmre nẽ tanhmã hamaxpẽr to hãmri nẽ ma hwỳr tẽ nẽ kamã àpênh o xa. ");
INSERT INTO apnNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Hãmri nhũm wa hipêêxàja hpãnhã hkra kot hapu hwỳr tẽ nẽ mã kãm kapẽr anẽ nẽ kãm: “E kêr ka ajaxwỳja atõ hkôt tẽ nẽ wa inhmã apê.” Anẽ nhũm kuma nẽ kãm: “Tôe. Nà kot paj ma tẽ.” Anhỹr tã no ãm hõta kĩnhã htẽm kêt nẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","—Jakamã e. Nhỹ hkra na pre hipêêxà kapẽr ma nẽ hkôt amnhĩ nhĩpêx nẽ kapẽr nhĩrôp ãm kêt nẽ? Xà kot waja nà? Xà kot haputa? E mẽ atõ tanhmã inhmã wa harẽnh to. Anẽ. Hãmri nhũm mẽ kuma nẽ kãm: —Nà kot wata. Kot wata na hitõt tã tanhmã hamaxpẽr to nẽ ma tẽ nẽ kãm apê. Anẽ. Hãmri nhũm mẽ kãm: —Tỳ ãm hãmri na ka harẽ. No mẽ kajaja te mẽ ate hkra kot haputa kot amnhĩ nhĩpêx pyràk. Mẽ ate Tĩrtũm kapẽr kôt amnhĩ nhĩpêx o apa hã amnhĩ jarẽnh tã hkwỳm ri amnhĩ nhĩpêx o apa. Te mẽ ate kot hapu kot hipêêxà mã àpênh ã amnhĩ jarẽnh tã kãm àpênh kêêta pyràk. No kêt mẽ kot amnhĩ tomnuj o mẽ pa xwỳnh kwỳjaja na mẽ arom Tĩrtũm kapẽr ma nẽ hkôt amnhĩ nhĩpêx. Jao ra tãm amnhĩ nhĩpêx o pa. Jakamã mẽ arom ma kaxkwa hwỳr pa kaxyw ra tãm nẽ. Ãm hãmri na pa mẽ amã ixkapẽr. ");
INSERT INTO apnNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Na ka mẽ finat Juãw Paxis ã ixkukja. Juãw Paxisja na pre hte mẽ ate tãm amnhĩ nhĩpêx ã mẽ amã karõ ho pa. Tã no ka mẽ ãm ama nẽ ãm ama nẽ aa kapẽr kôt amnhĩ nhĩpêx kêt nẽ. Nom mẽ kot amnhĩ tomnuj o mẽ pa xwỳnh kwỳjaja mẽ arom kuma nẽ Tĩrtũm kôt amnhĩ nhĩpêx. Ka mẽ ja hã mẽ omu nẽ ãm mẽ omu nẽ mẽ uràk nẽ ã amnhĩ nhĩpêx anhỹr kêt nẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Nhũm Jejus arĩ Ijaew krãhtũmjê mẽ mẽ õ patre krãhtũmjê mã kapẽr. Nẽ mẽ kot tanhmã hipêx to hkukamã mẽ kãm tanhmã amnhĩ jarẽnh to. No ãm amnhĩ tã kuxi nẽ mẽ kãm awjarẽ nẽ mẽ kãm: —Koja mẽhõ mẽ kot kãm pur kãm àpênh kaxyw hkwỳjê mã karõ nhũm mẽ ma hwỳr mra nẽ kamã mẽmo hy hkre nẽ hkre pa. Hãmri nhũm hpur nhõ dõn nhỹhỹm nojarêt nẽ kãm mẽ àpênh xwỳnhjê mã tanhmã hpur jarẽnh to nẽ mẽ kãm: “E or ixpur nõ. Kê kamã mẽmoj kà hpa ka mẽ mãmrĩ kamã axujamỳnh pa nẽ ho axkjê. Nẽ ixkutêp inhmã inhõ jaxwỳ nẽ mãmrĩ anhõ tanhmã ho hprãm xà hkôt tanhmã ho.” —Anhỹr o mẽ kãm kapẽr hãmri nẽ ma nhỹhỹm mõ. ");
INSERT INTO apnNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Tã nhũm ra pur kãm mẽmoj hkà pa nom nhũm hpur nhõ dõn arĩ krĩ hõ kamã hã ujahkre ho ri pa htã kuri kãm àpênh xwỳnhjê ho axkrunẽpxi nẽ akupỹm mẽ hwỳr mẽ kurẽ. Mẽ kot mẽ kãm hkwỳ nhõr nhũm mẽ ma kot kãm o mõr kaxyw nhũm ma mẽ hwỳr mẽ kurẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Nhũm mẽ ma hwỳr mõ. Mõõ nẽ ra hwỳr pôj nhũm mẽ amnhĩ wỳr mẽ omu nẽ axtem nẽ mẽ homnuj nẽ. Nẽ mẽ unê nẽ ja tak nẽ ja pĩ nẽ hõja nhũm mẽ kẽn o htak hãmri nẽ amnhĩ nê wa hano nhũm wa ma akupỹm ỹ kamã mõ. ");
INSERT INTO apnNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Hãmri nhũm mẽ õ patrãwja tee ri wa omu nẽ hamaxpẽr o: “Kwa nà na mẽ ixpê inhmã mẽ àpênh xwỳnhjê homnuj tỳx nẽ. Nà kot paj axte mẽ hwỳr mẽ hkwỳjê rẽ. Nom hpãnhã mẽ ho ohtô nẽ mẽ kurẽ. Kê mẽ ohtô nẽ mẽ hwỳr mõ nẽ tã inhmã inhõ hkwỳ jamỳ nẽ man ixwỳr o mõ.” —Anhỹr o hamaxpẽr hãmri nẽ mẽ hwỳr jajê rẽ nhũm mẽ ma akupỹm mẽ hwỳr mõ. Nhũm mẽ amnhĩ wỳr mẽ ohtô hã nẽ mã mẽ ho anẽ nẽ mẽ hipêx kati nẽ nhũm mẽ ỹ kamã ma õ patrãwja wỳr akupỹm mõ. ");
INSERT INTO apnNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Hãmri nhũm tee ri mẽ omu nẽ hamaxpẽr o: “Hêxta waa nẽ. Tanhmã kot paj amnhĩ nhĩpêx to? Nà kot paj pẽr mẽ hwỳr ixkraja mãn mẽ. Inhmã hapê htỳx tã kot paj mẽ hwỳr kumẽ kê ma mẽ hwỳr mõ. Hãmri nhũm mẽ kêp ixkra hã omu nẽ tanhmã ixpê ho hkêt nẽ. Nẽ tã inhmã kãm inhõja kwỳ gõ.” Anẽ. —Hãmri nẽ mẽ hwỳr kumẽ nhũm ma mõ. ");
INSERT INTO apnNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Tã hãmri ra mẽ hwỳr hpôx o mõ nhũm mẽ amỳm amnhĩ wỳr omu nẽ kêp hkra hã omu nẽ axtem nẽ hã axpẽn mã amỹnê nẽ axpẽn mã: “E onẽj hpur nhõ dõn krata tẽ. Koja nhỹrmã õ papaj mỳr pê amnhĩm hpur ã pykata pytà nẽ ho õ. Jakamã kwa pu mẽ hpĩr kurê kumrẽx nẽ kêp hpur ho arĩk nẽ ho panhõ. E tokyj pu mẽ kupĩ ri.” Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","—Hãmri nhũm ra tẽ nẽ mẽ hwỳr pôj nhũm mẽ unê nẽ hpur nê ho kato nẽ mã ho anẽ nẽ kupĩ. Ã mẽ ujarẽnh kot anhỹr. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Nhũm pre ã Jejus mẽ kãm ujarẽnh anẽ. Hãmri nẽ hã mẽ hkukja nẽ mẽ kãm: —E koja pur nhõ dõnja hkra jarẽnh ma hãmri nẽ tãm mẽ hwỳr mõ hãmri nẽ tanhmã mẽ hipêx to wehe? Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Hãmri nhũm mẽ kãm: —Nà koja ma akupỹm mẽ hwỳr mõ hãmri nẽ mẽ homnuj tỳx nẽ mẽ himex pa. Hãmri nẽ hpãnhã nhãm hpur ã mẽmojjê rẽ nhũm mẽ tã katàt kôt kãm àpênh o pa. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Hãmri nhũm Jejus mẽ kãm: —Tỳ ãm hãmri na ka ã mẽ harẽnh anẽ. Kot mẽ ho anhỹr mã tãm kênã. Mãn ka prem ra Tĩrtũm kapẽr ã kagà htũm kot tanhmã ja jarẽnh toja ma? Harẽnh kot: Mẽ kot kẽn o amnhĩm õrkwỹ nhĩpêx kaxyw nẽ kẽn maati pumu nẽ htỳx omnuj ã hkamnhĩx nẽ hkagata. Mẽ kot hkaga htã nhũm Tĩrtũm mẽ kurom mex o kot kẽn piitã hakrenh par ã omunh kurê kumrẽx. Tĩrtũm kot kẽn maati mex ã harẽnh xwỳnhta mẽ pamã mex o mex. Ã Tĩrtũm kapẽr ã kagà htũm kot ja jarẽnh kot anhỹr. ");
INSERT INTO apnNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Ja pyrà nẽ na pre ra Tĩrtũm amnhĩ kaxyw mẽ apê Ijaew xunhwỳ. Mẽ apê hkra nẽ hkôt mẽ ate amnhĩ nhĩpêx kaxyw amnhĩ kaxyw mẽ axunhwỳ. Tã ka mẽ axtem nẽ hkaga. Te mẽ kot kẽn maati pumunh nẽ mex kêt ã hkamnhĩx nẽ hkagata pyràk. Jakamã koja mẽ apãnhã Ijaew kêt xwỳnh kwỳjê xunhwỳ nhũm mẽ arom hkôt amnhĩ nhĩpêx mex o pa. Jao ra mẽ kêp hkra nẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Nhũm pre ã Jejus mẽ kãm te kêp kẽn maati pyràk o mẽ kãm amnhĩ jarẽnh anẽ. Hãmri nẽ axte amnhĩ tã kuxi nẽ mẽ kãm axte kẽn jarẽnh pyràk ã amnhĩ jarẽ nẽ mẽ kãm: —Nà kot kaj mẽ atõ ixkaga hãmri nẽ te mẽhõ htỳx htẽm nẽ kẽn pumunh kêt nẽ hã htêk nẽ tẽm pyràk o amnhĩ nhĩpêx. Jao ixkutã amnhĩ xãm. Rỳ ka tanhmã ajamaxpẽr to nẽ ixkaga nhũm te kẽn maati kot anhĩpy tẽm nẽ axôm par pyràk o anhĩpêx ka mẽ amex kêt kumrẽx. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Nhũm pre ã mẽ kãm ujarẽnh kãm mẽ harẽnh anẽ. Hãmri nhũm patre krãhtũmjê mẽ Parijew nhõ xwỳnhjaja tee ri amnhĩ tã kuma ");
INSERT INTO apnNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","nhũm ja mẽ kêp omnuj tỳx jakamã nhũm mẽ kãm unênh nẽ haxàr prãm nẽ. No mẽ ãm amnhĩ tã kãm mẽ kot mar o kuhê xwỳnhjê puma nẽ. Mẽ kurom Jejus kêp Tĩrtũm nhỹ hã kapẽr xwỳnh ã hkamnhĩx jakamã nhũm mẽ kãm mẽ uma nẽ. Hãmri nẽ kormã tanhmã ho hkêt nẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","2","Tã nhũm Jejus axte mẽ kãm awjarẽ. Ijaew kot Tĩrtũm kaga hã mẽ kãm hã kuxi nẽ awjarẽ nẽ mẽ kãm: —E pa mẽ amã ahpỹnhã mẽ kot Tĩrtũm kapẽr mar nẽ tanhmã amnhĩ nhĩpêx to xwỳnhjê jarẽ ka mẽ inhma. Te mẽ kot pahihti kot hkra hprõ kaxyw nhũm kot amnhĩ wỳr hkwỳjê hwỳr nhũm mẽ kot harẽnh mar nẽ ahpỹnhã tanhmã amnhĩ nhĩpêx to xwỳnhjaja kot amnhĩ nhĩpêx pyràk. Koja pahihtija hkra hã hkĩnh nẽ hã apkur mex kaxyw amnhĩ wỳr hkwỳjê hã karõ. ");
INSERT INTO apnNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Hãmri nhũm kãm mẽ àpênh xwỳnhjaja ra kot amnhĩ wỳr mẽ hã karõ xwỳnhjê hwỳr mra nẽ mẽ kãm nojarêt nhũm mẽ kuma nẽ ãm mẽ kuma nẽ axtem nẽ mẽ kêp hitõt nẽ. Hãmri nhũm mẽ tee ri mẽ kuma nẽ akupỹm tẽ nẽ pahihti mã mẽ harẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","—Hãmri nhũm tee ri amnhĩ tã mẽ harẽnh ma nẽ hpãnhã mẽ hwỳr axtem kãm àpênh xwỳnh kwỳjê rẽ nhũm mẽ ma mẽ hwỳr mra nẽ mẽ kãm: “Pa. E kwa mẽ tokyx. Na ra pahihti mẽ akutêp mẽõ nhĩpêx pa. Na mẽ môx kwỳ hpa nẽ ho àr mex nẽ. Nẽ mẽ akutêp mẽmoj nhĩpêx par jakamã e kwa mẽ tokyx nà.” Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","ã mẽ kãm kapẽr anhỹr tã nhũm mẽ kuma nẽ ãm mẽ kuma nẽ ma ahpỹnhã nhỹhỹm mra. Nhũm ja ma àpênh mã mra nhũm ja ma ihpur kãm àpênh mã ma tẽ nhũm ja ma nhỹhỹm mẽmo to wẽnê ho tẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Nhũm mẽ hkwỳjaja mẽ kãm ujarẽnh xwỳnhjê pynê nẽ mẽ htak o mẽ kupa. ");
INSERT INTO apnNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","—Hãmri nhũm pahihtija mẽ harẽnh ma nẽ àhkurê nẽ. Hãmri nẽ mẽ hwỳr pôristi hkwỳ rẽ nhũm mẽ ma mẽ hwỳr mra nẽ mẽ unê nẽ mẽ kupa nẽ mẽ õ krĩ hã hpôk pa. ");
INSERT INTO apnNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Hãmri nhũm pahihti kãm mẽ àpênh xwỳnh kwỳjê mã kãm: “Kwa ra ixte mẽ kutêp mẽõ mex kwỳ xunhwỳr tã nhũm mẽ ixwỳr mrar kêt nẽ. Ixtỳx ho mẽ mex ã mẽ hkamnhĩx nẽ amnhĩ wỳr mẽ hã karõ no mẽ mex kêt. Mẽ kot mẽ ixkutã apkur mã tãm kêt. ");
INSERT INTO apnNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","E kwa mẽ ma krĩ hkôt axtem mẽ hkwỳjê japêr o mra. Nẽ nhỹri mẽhõ pumu nẽ kãm awjarẽ kê man ixwỳr tẽ nẽ ixkra hã hkĩnh nẽ mẽ ixkutã apku. Mẽ ã mẽ kãm axujarẽnh o amrar anẽ.” Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","—Hãmri nhũm mẽ kuma nẽ ma mẽ hapêr o mra nẽ mẽ piitã mẽ kãm anhỹr o mra. Nhũm mẽ kuma nẽ wam tajê rom ma mẽ hkôt mrar kurê kumrẽx. Mẽ kot amnhĩ to mex xwỳnhjaja nẽ mẽ kot amnhĩ tomnuj xwỳnhjaja hãmri piitã ma mẽ hkôt mra. Hãmri nẽ ixkreja wỳr mra nẽ hwỳr gjêx kaxyw nhũm mẽ kãm mẽ ê mex gõ nhũm mẽ hagjê hãmri nẽ kormã mẽ apkur xà hã ixkre hwỳr agjê nẽ ho nỳt pa. ");
INSERT INTO apnNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Hãmri nhũm pahihtija mẽ hwỳr axà nẽ mẽ piitã mẽ omu. Nhũm ja pixi nẽ axtem nẽ hkwỳjê hkĩnhã mẽ kot kãm ê mex nhõrja jaxàr kêt rãhã axà nẽ apkur o nhỹ. ");
INSERT INTO apnNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Hãmri nhũm tee ri ja hã omu nẽ hwỳr tẽ nẽ kãm: “Pa. Tk. Kwa na htem ixkrem gjêx kaxyw nẽ mẽ kot mẽ kãm mẽ ê mex nhõr jagjê nẽ rĩ kormã hwỳr agjê nẽ apku. Tã mon ka akwỳjê hkĩnhã haxàr kaga? Kwa na htem ã amnhĩ nhĩpêx anhỹr kêt nẽ.” Anhỹr o kãm kapẽr nom nhũm kuma nẽ ãm kuma nẽ tanhmã kutã kãm nẽ hkêt nẽ. Ãm htỳx apkur o nhỹ. ");
INSERT INTO apnNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Jakamã nhũm tee ri omu hãmri nẽ hã mẽ kot kãm àpênh xwỳnhjê mã amỹnê nẽ mẽ kãm: “E mẽ hwỳr tẽ nẽ unê nẽ hpa nẽ hte hpre nẽ ma o tẽ nẽ kamàt kô kamã amẽ. Kê tee ri mur nẽ amnhĩ xà htỳx kamã hamak o amnhĩ nham o axpẽn kamnhar tỳx kaprỳ ho nõ nẽ rĩ amnhĩ pumu.” Anẽ. Hãmri nhũm mẽ kuma nẽ kãm ho anẽ. Ã mẽ ujarẽnh kot anhỹr. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Nhũm pre Jejus ã mẽ kãm ujarẽnh anẽ hãmri nẽ mẽ kãm: —Nà Tĩrtũm kot pahihtita pyrà nẽ amnhĩ wỳr mẽ ho ohtô nẽ mẽ hwỳr tã na hte mẽ piitã hkôt amnhĩ xunhwỳr kêt nẽ. Jakamã na hte ãm mẽ ho grêre nẽ amnhĩ wỳr mẽ ho api. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","16","Tã nhũm Parijew nhõ xwỳnhjaja ã Jejus kot mẽ kãm ujarẽnh anhỹrja ma hãmri nẽ kurũm kato nẽ tanhmã hkukamã axpẽn mã hã àmnênh to. Hãmri nẽ hwỳr mẽ hkwỳjê mẽ Erox kôt mẽ pa xwỳnh kwỳjê rẽ. Hêx rom mẽ kot mẽmoj tã hkukjêr kaxyw hwỳr mẽ kurẽ nhũm mẽ ma hwỳr mra nẽ omu nẽ kãm: —Kwa Jejus. Nà ãm hãmri na ka hte Tĩrtũm kapẽr o mẽ ahkre mex o ri apa nẽ mẽ kamã akahak o apa hkêt nẽ. Mẽ kot tanhmã ato kapẽr punuj to htã ka aprĩ hã mẽ ahkre mex o ri apa. ");
INSERT INTO apnNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","E kwa mẽ inhmã mẽmoj jarẽ. Rõm nhõ pahihti kot mẽ pahpê Ijaew mẽ pahte kãm kàxpore hkwỳ nhõr ã mẽ pamã karõta. Kwa xà ja amã mex nà? Xà kot pu mẽ kãm hkwỳ gõ? Nà xà kot pu mẽ kãm õr kêt nẽ? E kwa mẽ inhmã tanhmã ja jarẽnh to. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Nhũm prem ã hêx rom àhkukjêr anhỹr tã no nhũm ra mẽ hamaxpẽr ã mẽ omu nẽ mẽ kãm: —Tk. Kwa mon ka mẽ ã axêx rom ja hã ixkukjêr anẽ? ");
INSERT INTO apnNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","20","E mẽ atõ inhmã kàxpore htỳxre hõ gõ pa omu. Anẽ. Hãmri nhũm mẽ kãm ja gõ nhũm kupy nẽ kànhmã mẽ kãm kupẽ nẽ mẽ kãm: —E mẽhõ nhĩxi nẽ mẽhõ karõ na ja hã? Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Hãmri nhũm mẽ kãm: —Pahi Sesti karõ nẽ hixi na hã. Anẽ. Hãmri nhũm mẽ kuma nẽ mẽ kãm: —Tỳ. Tô kêr ka mẽ mãmrĩ kãm hkwỳ nhõr o apa. Hã hkarõ nẽ hã hixi. Tãm kot hipêx xwỳnh jakamã õ na. No mẽ kajaja na pre Tĩrtũm mẽ anhĩpêx nhũm mẽ apê õ jakamã kwa kêr ka mẽ kapẽr kôt pix mã ri amnhĩ nhĩpêx o ri apa. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Hãmri nhũm mẽ amnhĩ jaêr pê ã kot kàxpore jarẽnh anhỹrja ma nẽ axte kãm tanhmã nẽ hkêt nẽ. Hãmri nẽ akryk omu hãmri nẽ ma akupỹm mra. ");
INSERT INTO apnNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Tã nhũm Satusew nhõ xwỳnh kwỳjaja mẽ kot akupỹm mẽ htĩr kêt ã mẽ hkamnhĩx kêt xwỳnhjaja na pre mẽ. Na pre htem mẽ htyk nẽ mẽ hapêx kumrẽx ã mẽ hkamnhĩx jakamã axpẽn mã tanhmã Jejus jarẽnh to nẽ axpẽn mã: —E kwa pu mẽ hwỳr mra nẽ mẽmoj xihtỳx ã hkukja. Kê mẽ pama nẽ tee ri tanhmã mẽ pamã kapẽr to hkukamã hamaxpẽr kaprỳ. Kê mẽ piitã ja hã omu nẽ àhpumunh kêt ã omunh kurê kumrẽx. E tokyx pu mẽ hwỳr. Anhỹr jakamã Parijew nhõ xwỳnhjê pyrà nẽ hêx rom ma hwỳr mra nẽ hkukja nẽ kãm: ");
INSERT INTO apnNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","—Pa Jejus? Kwa mẽ inhmã mẽmoj jarẽ. Na pre finat Mojesja Tĩrtũm nhỹ hã ã mẽ panhĩgêtjê mã karõ anẽ. Mẽ hkra hkêt rãhã mẽ pa nẽ mẽ htyk xwỳnhjaja nhũm mẽ harẽnh o: Koja mẽhõ hprõ nẽ kamã hkra hkêt rãhã pan ty. Hã koja hkôt htõja hpãnhã hprõ ho hprõ nẽ kamã hkra. Hãmri nhũm kato nẽ te kêp htõ htyk xwỳnhta hkra pyràk. Anẽ. Ã na pre Mojesja Tĩrtũm nhỹ hã mẽ kãm karõ anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Jakamã kwa ga mẽ ixujarẽnh ma. Koja mẽ kot axpẽn to htõ xwỳnhjaja kêp 7. Nhũm kot waja hãmri hprõ nẽ wa pa nhũm kamã hkra hkêt rãhã ty. Nhũm hkôt htõja hpãnhã ho hprõ ");
INSERT INTO apnNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","nẽ wa axpẽn to pa. Nhũm mããnẽn kamã hkra hkêt rãhã ty. Nhũm htõ hõta haxwỳja hpãnhã tãm o hprõ nẽ we wa axpẽn to pa grire nhũm haxwỳja kamã hkra hkêt rãhã ty. Hãmri nhũm htõ hkwỳjaja ni pyxi nẽ axpẽn pãnhã ho hprõ hpa no mẽhõ kamã hkra hkêt rãhã htyk pa. ");
INSERT INTO apnNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Hãmri nhũm mẽ hprõta mẽ hkôt amnhĩ to hitep nẽ ty. ");
INSERT INTO apnNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Tã Tĩrtũm kot akupỹm nhỹrmã mẽ ho htĩr ronhỹx nhỹ nhỹx kêp nija mjên kumrẽx? Ra piitã kot ho hprõ kênã. E mẽ inhmã ja jarẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","30","Hãmri nhũm Jejus mẽ kuma nẽ mẽ kãm: —Nà kaxkwa kamã mẽ kot amnhĩ nhĩpêxja axtem na. Mẽ htĩr ri mẽ kot Tĩrtũm kôt amnhĩ xunhwỳr xwỳnhjaja na htem ty hãmri nẽ Tĩrtũm nhõ krĩ kamã axte kãm hprõ hprãm kêt nẽ pa. Jakamã hprõ hkêt nẽ pa. Rỳ ni japêr nẽ mjên kêt nẽ pa. Nom ri kãm mjên rỳ hprõ hprãm kêt nẽ pa. Hãmri nẽ Tĩrtũm kapẽr o mẽ wrỳk xwỳnhjê pyrà nẽ axte htyk kêt nẽ. Ãm htĩr tũm rãhã nẽ pa ho pa. Pẽr mẽ ate Tĩrtũm kapẽr ã kagà htũm mar mex kêt jakamã na ka mẽ ã ja hã ixkukjêr anẽ. Tĩrtũm àhpumunh tỳx o àhpumunh tỳx jakamã kumã mẽ ate mẽmoj tã ixkukjêr xwỳnhta na tanhmã kêp kute hkêt. Ra ja kukamã àhpumunh tỳx kênã. ");
INSERT INTO apnNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","32","—Nom mẽ ate akupỹm mẽ htĩr kêt ã mẽ hkamnhĩxja kot paj ixprĩ hã mẽ amã harẽ. Amnepêm na pre Tĩrtũm pĩ hpôkja kamã tanhmã Mojes mã kapẽr to. Mãn ra mẽ ate mar. Na pre kãm: Ixpê Apraãw nhõ Tĩrtũm na pa. Nẽ mããnẽn ixpê Apraãw kra Ijak mẽ htàmnhwỳ Jako wa õ Tĩrtũm na pa. Anhỹr o Mojes mã amnhĩ jarẽ nhũm kuma nẽ hã kagà. Kêp apu arĩ mẽ htyk rãhã nhỹx pre ã mẽ harẽnh anhỹr kêt nẽ. Nhỹx pre mẽ harẽnh o: “Amnepêm Apraãw nẽ hkra nẽ htàmnhwỳ mẽ htĩr ri ixpê mẽ õ Tĩrtũm na pa pre.” Anhỹr o nhỹx pre mẽ harẽ. Nom na pre ã amnhĩ jarẽnh anhỹr kêt nẽ. Mẽ pamã te Apraãwja mẽ htyk nẽ mẽ hapêx pyràk. Nom nhũm prem ra Tĩrtũm ri ra akupỹm htĩr nẽ mex nẽ pa ho pa. Tã ka htem Tĩrtũm kapẽr kwỳm ri akupỹm mẽ htĩr kêt ã mẽ harẽnh o apa. Anhỹr o Satusew nhõ xwỳnhjê mã kapẽr. ");
INSERT INTO apnNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Hãmri nhũm mẽ kot mar o kuhê xwỳnhjaja amnhĩ jaêr pê kot mẽ ahkreja ma. ");
INSERT INTO apnNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Tã nhũm Parijew nhõ xwỳnhjaja Satusew nhõ xwỳnhjê jarẽnh ma. Mẽ kot tee ri kãm hamaxpẽr o Jejus jakrenh prãm kaprỳ hã mẽ harẽnhja ma hãmri nẽ axpẽn wỳr akuprõ nẽ Jejus wỳr mra. Kot mẽ uràk nẽ hêx rom àhkukjêr nẽ hamaxpẽr o hakrenh kaxyw hwỳr mra. ");
INSERT INTO apnNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Hõja kêp Tĩrtũm kapẽr tũm o mẽ ahkre o mẽ pa xwỳnh jakamã hêx rom kamã hamak kaxyw kãm kapẽr nẽ kãm: ");
INSERT INTO apnNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","—Kwa Jejus. Ot pa mẽ awỳr mra. Kwa mẽ inhmã mẽmoj jarẽ. Na pre Tĩrtũm ahpỹnhã mẽmoj to 10 nẽ hã mẽ pamã karõ. Mẽ pahte hkôt amnhĩ nhĩpêx kaxyw hã mẽ pamã karõ. Tã nhỹ kapẽr na mex o kot hkwỳ jakrenh wehe? Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Hãmri nhũm kuma nẽ mẽ kãm: —Nà kot mẽ pamã hã karõ kot: Kêr ka mẽ anhĩ piitã ho amã Tĩrtũm kĩnh tỳx o apa. Mẽ amã hkĩnh tỳx o mẽmoj piitã hakrenh par o apa. ");
INSERT INTO apnNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","E Tĩrtũm kot mẽ pamã hã karõ ja na mex o piitã hakrenh par. ");
INSERT INTO apnNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Nẽ hkôt ja: Kêr ka mẽ amã akwỳjê hã ma ho te ka amã amnhĩ tã ma pyràk. Jao ra tãm mẽ hipêx. ");
INSERT INTO apnNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","ã Tĩrtũm kapẽr ã kagà htũm kot mẽ pamã hã karõ kot anhỹr. Ã mẽ pahte amnhĩ nhĩpêx anhỹr o papaja na Tĩrtũm kãm hprãm tỳx kumrẽx. Kot kaj mẽ ja wa hkôt amnhĩ nhĩpêx rãhã ho ri apa nẽ mããnẽn ra Tĩrtũm kot mẽ pamã mẽmoj tã karõ xwỳnh piitã hkôt amnhĩ nhĩpêx. Ja na pre Mojes mẽ Tĩrtũm nhỹ hã kapẽr xwỳnhjaja amnepêm Tĩrtũm nhỹ hã mẽ panhĩgêtjê mã hã karõ ho pa. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Nhũm Parijew nhõ xwỳnhjaja arĩ Jejus mar o kuhê nhũm amnhĩ tã tanhmã mẽ hkukjêr to. Nom te nhãm mẽhõ hã mẽ hkukjêr pyràk o mẽ hkukja nẽ mẽ kãm: ");
INSERT INTO apnNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","—E mẽ inhmã mẽmoj jarẽ. Tanhmã na ka htem axpẽn mã Tĩrtũm kot mẽ akaxyw ãm mã xwỳnhta jarẽnh to? Kêp mẽhõ kanrẽhã htàmnhwỳ koja wehe? Anẽ. Hãmri nhũm mẽ kãm: —Nà koja kato nẽ kêp pahi finat Tawi kanrẽhã htàmnhwỳ koja. ");
INSERT INTO apnNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Anẽ nhũm Jejus mẽ kuma nẽ mẽ kãm: —Tỳ. Ãm hãmri na ka mẽ harẽ. No mo na htem axpẽn mã kêp pahi Tawi hkanrẽhã htàmnhwỳ pix ã harẽ nẽ mããnẽn kêp õ pahihti hã harẽnh kêt nẽ? Tawi na pre Tĩrtũm Karõ nhỹ hã tanhmã harẽnh to nẽ harẽnh o: ");
INSERT INTO apnNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Na pre Tĩrtũm inhõ Pahihti mã ã kapẽr anẽ nẽ kãm: “E amnẽ ixwỳr tẽ nẽ inhĩhkô hã nhỹ nẽ inhmã mẽ ho amnhĩptàr o akrĩ. Kot paj mẽ kot kãm akurê xwỳnh piitã mẽ unênh pa nẽ awỳr mẽ o mra nẽ anhĩhkram mẽ haxàr pa.” Anhỹr o pre kãm kapẽr. ");
INSERT INTO apnNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","ã Tawija Tĩrtũm kot Kris mã kapẽr jarẽnh nẽ kêp õ pahi hã kagà anẽ. Mẽ kajaja na ka htem ãm kêp Tawi tàmnhwỳ pix ã axpẽn mã harẽnh o ri apa. No kêt Tawija na pre kêp õ Pahihti hã harẽnh o pa. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Hãmri nhũm mẽ kuma nẽ tee ri kot tanhmã kutã kãm kapẽr to hkukamã hamaxpẽr nẽ axte mẽmoj tã hkukjêr kêt nẽ. Tanhmã kot mẽ amnhĩ to nẽ hamaxpẽr o hakre? Na prem tee ri kãm hamaxpẽr o hakrenh prãm kaprỳ. Jejus mẽmoj piitã hkukamã àhpumunh tỳx o àhpumunh tỳx. ");
INSERT INTO apnNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Tã nhũm Jejus mẽ ixte hkôt ixpa ho ixpa xwỳnhjê mẽ mẽ kot mar o kuhê xwỳnhjê mã kapẽr nẽ mẽ inhmã tanhmã Parijew nhõ xwỳnh mẽ Mojes kapẽr o mẽ ahkre xwỳnhjê jarẽnh to nẽ mẽ inhmã: ");
INSERT INTO apnNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","—Nà Parijew nhõ xwỳnh mẽ Tĩrtũm kapẽr tũm o mẽ ahkre xwỳnhjaja na htem hprĩ hã Tĩrtũm kapẽr ã kagà htũm mar mex nẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Jakamã kêr ka mẽ mar tỳx nẽ mẽ kot ho mẽ ajahkre kôt amnhĩ nhĩpêx. No mẽ kot amnhĩ nhĩpêxja kêr ka mẽ hkôt amnhĩ nhĩpêx kêt nẽ. Mẽ kot Tĩrtũm kapẽr tũm o mẽ ajahkre htã hkôt amnhĩ nhĩpêx kêt nẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Te mẽ kot mẽhõ kot mẽ katut ã mẽ kãm mẽ jênh pytĩ janhôr tã no ãm mẽ kuxwar hkwỳ htur kêt kot amnhĩ nhĩpêx pyràk o na htem amnhĩ nhĩpêx o pa. Jao mẽ amã mẽmoj tã karõ nẽ mẽ amã: “E kêr ka mẽ ã amnhĩ nhĩpêx anẽ nẽ ã amnhĩ nhĩpêx anẽ.” Anhỹr pix o mẽ amã kapẽr o pa. Nom mẽ tãmjaja amnhĩ kapẽr kôt amnhĩ nhĩpêx kêt nẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","—Na htem hkwỳjê kot mẽ omunh nẽ mẽ kot amnhĩ to mex ã mẽ harẽnh kaxyw mẽ noo mã tanhmã amnhĩ nhĩpêx to. Nẽ mẽ mẽ noo mã mẽ ê mex pix kãm pa. Nẽ amnhĩm Tĩrtũm kapẽr ã kagà htũm kwỳ hã kagà nẽ amnhĩ nhõkrã hã hanhô nẽ amnhĩ pa hã hanhô nẽ hã pa. Mẽ kot hã nohtỳx rãhã hã mẽ hkamnhĩx kaxyw nhũm htem ã amnhĩ nhĩpêx anhỹr o pa. Nẽ mẽ kãm mẽ piitã mẽ kot amnhĩm mẽ rũnh ã mẽ harẽnh o paja nhũm htem kãm hprãm. ");
INSERT INTO apnNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","—Nẽ mẽ pahpê Ijaewjê nhõ Tĩrtũm kapẽr o mẽ ahkre xà hã ixkre kamã mẽ kot amnhĩ to rũnh xwỳnhjê hkrĩ xà mex pix kamã kãm hkrĩ hprãm. Nẽ mẽmoj tã mẽ apkur xà mex ã arĩgro hã nhũm htem ma mẽ apkur xà hã ixkre hwỳr akuprõ nhũm mẽ kot amnhĩ to rũnh xwỳnhjê hkrĩ xà mex pix kamã kãm hkrĩ hprãm. ");
INSERT INTO apnNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Nẽ nhỹri pry hã mra nhũm mẽ kot mẽ omunh nẽ mẽ kêp mẽ ahkre xwỳnh maati hã mẽ hã hpijaàm kãm tanhmã mẽ kãm kapẽr mex toja nhũm htem kãm hprãm. Ã na hte Parijew nhõ xwỳnh mẽ Tĩrtũm kapẽr tũm o mẽ ajahkre xwỳnhjaja hêx rom mẽ anoo mã amnhĩ nhĩpêx anhỹr o pa. ");
INSERT INTO apnNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","10","—No mẽ kajaja. Kêr ka mẽ ho mẽ uràk kêt nẽ. Kê mẽ axpẽn mã mẽ ajarẽnh o: “Pahi Maati” anhỹr o mẽ ajarẽnh kêt nẽ. Rỳ mẽ ajarẽnh o: “mẽ ijahkre xwỳnh maati” anhỹr o axpẽn mã mẽ ajarẽnh hkêt nẽ. Kêt paxipix na pre Tĩrtũm mẽ akaxyw ixãm jakamã paxipix na ixpê mẽ anhõ Pahi Maati. Nẽ paxipix na ixpê mẽ ajahkre xwỳnh maati. No mẽ kajaja ixkôt mẽ apê axpẽn to atõx nẽ atõ na ka mẽ. —Nẽ kêr ka mẽ ri axpẽn jarẽnh o: “Mẽpahpãm” anhỹr kêt nẽ. Kêt kaxkwa kamã na Mẽpahpãmja. ");
INSERT INTO apnNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","12","—Nẽ kot ka mẽ amnhĩ to rax prãm xàj tanhmã amnhĩ to jarkrar to ho apa htã no nhũm akwỳjaja ama nẽ ãm ama nẽ akôt hamaxpẽr kêt nẽ. No kot kaj mẽ piitã mẽ kutã tanhmã anojarêt to ho apa nhũm mẽ amnhĩ tã mẽ apumu nẽ axpẽn mã mẽ amex ã mẽ ajarẽ. Jakamã kot kaj mẽ amã mẽ piitã mẽ kot mẽ amex ã mẽ ajarẽnh prãm hãmri nẽ ri mẽ piitã mẽ kãm tanhmã amnhĩ nhĩpêx to pê mẽ kutã anojarêt rãhã ho ri apa. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","14","Tã nhũm Jejus hpãnhã Parijew nhõ xwỳnh mẽ Tĩrtũm kapẽr tũm o mẽ ahkre ho mẽ pa xwỳnhjê mã kapẽr. Nẽ mẽ kãm kapẽr kãm hihtỳx nẽ mẽ kãm: —E mẽ apê Parijew nhõ xwỳnh mẽ Tĩrtũm kapẽr tũm o mẽ ahkre xwỳnhjaja. E mẽ inhma. Kot kaj mẽ amex kêt nẽ. Mẽ apê mẽ no kupyr xwỳnh na ka mẽ. Nẽ mẽ amã Tĩrtũm kôt amnhĩ nhĩpêx prãm kêt. Nẽ nhỹrmã atyk nẽ mẽ amã õ krĩ hwỳr axàpir prãm kêt. Nẽ akwỳjaja kot hwỳr àpir pymaj na ka htem akwỳjê nê tanhmã mẽ kãm axêx to ho apa. Mẽ kot mẽ apyrà nẽ Tĩrtũm kapẽr kwỳm amnhĩ nhĩpêx prãm xàj na ka htem amnhĩ mẽ tanhmã mẽ kãm axêx to ho ri apa. Jao te mẽ ate mẽ kêp Tĩrtũm nhõ krĩ hwỳr kahêxà kahê htỳx pyràk o apa. ");
INSERT INTO apnNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","—Nẽ mẽ akwỳjaja kot mẽ akôt amnhĩ xunhwỳr nẽ mẽ akôt amnhĩ nhĩpêx prãm xàj na ka htem ma awry hã nhỹhỹm tanhmã mẽ kãm ri axujarẽnh to ho ri apa. Jakamã nhũm mẽhõ mẽ ama nẽ mẽ akôt amnhĩ xãm hãmri nẽ ra amnhĩ tomnuj tỳx o mẽ ajakre. Jakamã koja mẽ nhỹrmã mẽ apyrà nẽ ma mẽ kot amnhĩ xà htỳx kamã hamak tũm xàta wỳr pa. Jakamã kwa mẽ o kora. Kot kaj mẽ amex kêt nẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","—Hêxta waa nẽ. Mẽ apê Parijew nhõ xwỳnhjê mẽ mẽ apê Tĩrtũm kapẽr tũm o mẽ ahkre xwỳnhjaja kot kaj mẽ amex kêt kumrẽx. Na ka htem mẽ kêp mẽ hikàxpore jamỳnh prãm xàj atỳx ri tanhmã mẽ ahkre hto ho apa nẽ mẽ kãm: “Kot kaj mẽ ãm hãmri mẽmoj tã amnhĩ jarẽnh kaxyw hãmri nẽ Tĩrtũm mã amnhĩ jarẽnh xà hã ixkre nhĩxi jarẽnh kôt mẽhõ mã amnhĩ jarẽ nhũm ama nẽ hamaxpẽr o: ‘Ko. Apu ãm hãmri na inhmã amnhĩ jarẽ rỳ ko na apu ãm amnhĩ to hêx.’ Anhỹr o hamaxpẽr. Nom kot kaj mẽ ixkreta ho mex kaxyw mẽ kãm kàxpore hkwỳ gõ hãmri nẽ ate mẽ kãm õr xàta jarẽnh kôt ãm hãmri mẽmoj tã mẽhõ mã amnhĩ jarẽ. Hãmri nhũm ama nẽ hamaxpẽr o: ‘Nà ãm hãmri na ã inhmã amnhĩ jarẽnh anẽ. Kot ixkre ho mex kaxyw kàxpore hkwỳ nhõr kôt ã amnhĩ jarẽnh anẽ. Jakamã na amnhĩ to hêx kêt nẽ.’” Anhỹr o hamaxpẽr. Na ka htem ã mẽ ahkre ho apa anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Nom mẽ ate mẽ ahkreta mex kêt. Pẽr mẽ ajamaxpẽr mexti hã. Tĩrtũm mã amnhĩ jarẽnh xà hã ixkreta mex o ixkre ho mex kaxyw kàxpore nhõrta jakrenh. Tã ka htem axtem nẽ mẽ kot kãm kàxpore nhõrta mex o ixkre jakrenh ã harẽ. No mẽ pahte ãm hãmri mẽmoj tã amnhĩ jarẽnh nẽ aa paxêx kêt rãhã ho papaja na Tĩrtũm kãm hprãm. ");
INSERT INTO apnNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","—Nẽ na ka htem mẽ kêp mẽ hikukrêx jamỳnh prãm xàj ã atỳx ri mẽ ahkre anẽ nẽ mẽ kãm: “Kot kaj mẽ ãm hãmri mẽmoj tã amnhĩ jarẽnh kaxyw nẽ Tĩrtũm mã mẽmoj nhõr xà hã mêstija jarẽnh kôt mẽhõ mã tanhmã amnhĩ jarẽnh to. Hãmri nhũm mẽ ama nẽ hamaxpẽr o: ‘Nà ãm hãmri na inhmã amnhĩ jarẽ rỳ ko na apu ãm inhmã amnhĩ to hêx.’ Anhỹr o hamaxpẽr. Nom kot kaj mẽ Tĩrtũm mã mẽmoj nhõr xà hã mêstija ã kãm mẽmoj xi. Hãmri nẽ ra mẽ ate kãm õr xàta jarẽnh kôt ãm hãmri mẽmoj tã mẽhõ mã amnhĩ jarẽ. Hãmri nhũm ama nẽ hamaxpẽr o: ‘Nà ãm hãmri na ã inhmã amnhĩ jarẽnh anẽ. Kot Tĩrtũm mã mẽmoj nhõr ã amnhĩ jarẽnh kôt kot amnhĩ jarẽnh anhỹr jakamã na amnhĩ to hêx kêt nẽ.’ Anhỹr o hamaxpẽr.” Anẽ. Na ka htem ã mẽ ahkre anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Mẽ ajamaxpẽr kêt xwỳnh na ka mẽ. Tĩrtũm mã mẽmoj nhõr xà hã mêstija na mex o mẽ kot hã kãm mẽmoj nhõrta jakrenh. Tã na ka htem axtem nẽ mẽ kot hã kãm mẽmoj nhõrta mex o mêsti jakrenh ã harẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Nom Tĩrtũm mã mêsti mẽ mẽ kot hã kãm mẽmoj nhõrta te kot axpẽn pyràk jakamã kot kaj mẽ mêstija jarẽnh kôt mẽmoj tã amnhĩ jarẽ nẽ mããnẽn mẽ ate hã Tĩrtũm mã mẽmoj xirja jarẽnh kôt amnhĩ jarẽ. Hamẽ wa kot axpẽn pyràk jakamã hamẽ wa harẽnh pê amnhĩ to axêx kêt nẽ. Jakamã kêr ka mẽ mẽmoj tã amnhĩ jarẽnh kaxyw nẽ hamẽ wa harẽnh kôt ãm hãmri mẽmoj tã amnhĩ jarẽ nẽ ho axêx kêt nẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Tã kot kaj mẽ ãm hãmri amnhĩ jarẽnh ã mẽmoj tã amnhĩ jarẽnh kaxyw nẽ Tĩrtũm mã amnhĩ jarẽnh xà hã ixkre hkôt hã amnhĩ jarẽ nẽ mããnẽn Tĩrtũm kêp ixkre hpãm kôt hã amnhĩ jarẽ. Jakamã kêr ka mẽ hamẽ wa harẽnh pê amnhĩ to axêx kêt nẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","—Nẽ kot kaj mẽ ãm hãmri amnhĩ jarẽnh ã mẽmoj tã amnhĩ jarẽnh kaxyw nẽ kaxkwa jarẽnh kôt amnhĩ jarẽnhja o mããnẽn kaxyw kaxkwa kamã Tĩrtũm krĩ xà maati hkôt amnhĩ jarẽ. Nẽ mããnẽn Tĩrtũm kôt amnhĩ jarẽ. Jakamã kwa hamẽ wa harẽnh pê amnhĩ to axêx kêt nẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","—Hêxta waa nẽ. Mẽ apê Parijew nhõ xwỳnh mẽ mẽ apê Tĩrtũm kapẽr tũm o mẽ ahkre xwỳnhjaja kot kaj mẽ amex kêt nẽ. Mẽ ate mẽ no kupyr xwỳnh na ka mẽ. Na ka htem Tĩrtũm kapẽr piitã hkôt amnhĩ nhĩpêx kêt nẽ ãm hkwỳ kôt pix mã amnhĩ nhĩpêx o ri apa. Na ka htem ãm kapẽr o hpỹnhre nẽ hkôt amnhĩ nhĩpêx ã amnhĩ pumu nẽ ate amnhĩ to mex xwỳnh ã amnhĩ jarẽnh o apa. No Tĩrtũm kãm hprãm xà piitã hkôt amnhĩ nhĩpêx kêt nẽ. Mẽ ate tãm mẽ hipêx nẽ mẽ ho mex nẽ mẽ kamã axukaprĩ hã kot mẽ amã karõja. Nẽ mẽ amã Tĩrtũm kĩnh ã kapẽr kôt amnhĩ nhĩpêx hã karõja ra mẽ ate mar tã hkôt amnhĩ nhĩpêx kêt nẽ. Mẽ ate kapẽr piitã hkôt amnhĩ nhĩpêx ronhỹx ja mẽ amã mex o mex. ");
INSERT INTO apnNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Mẽ ate ãm kapẽr o hpỹnh nẽ hkôt amnhĩ nhĩpêx jakamã te mẽ ate atỳx ri tanhmã axàpkur to ho mẽ akrĩ pyràk. Jao te mẽ axàpkur xà hã mẽõ kamã pure pumunh nẽ nê hanhir nẽ rẽnh tã mããnẽn kamã kẽn rax pumunh tã nê hanhir nẽ rẽnh kêt rãhã hkur pyràk. Jao Tĩrtũm kapẽr o hpỹnhre nẽ hkôt amnhĩ nhĩpêx no piitã hkôt amnhĩ nhĩpêx kêt nẽ. Pẽr mẽ ajamaxpẽr kêt tã na ka htem atỳx mẽ ahkre ho ri apa. ");
INSERT INTO apnNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","—Hêxta waa nẽ. Mẽ apê Parijew nhõ xwỳnh mẽ mẽ apê Tĩrtũm kapẽr tũm o mẽ ahkre xwỳnhjaja kot kaj mẽ amex kêt nẽ. Mẽ ate mẽ no kupyr xwỳnh na ka mẽ. Nà mẽ apê Parijew nhõ xwỳnhjaja te mẽ ate mẽ kot apkur kaxyw prat kre kuhõnh punuj tã mex ã harẽnh nẽ kamã apkur pyràk o na ka mẽ. Jao ãm mẽ akrãhkà rũm pix mã mẽ amex. Nẽ mẽ noo mã te mẽ amex pyràk no mẽ anhõxàhkre kaxwỳnh kãm mẽ ajamaxpẽrja mex kêt. Mẽ akapẽr prãm nẽ mẽ axàhkurê nẽ mẽ anhõxỳỳ. ");
INSERT INTO apnNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Mẽ ajamaxpẽr mex kêt kênã. Kwa kêr ka mẽ tãm ajamaxpẽr o tãm akwỳjê nhĩpêx o ri apa. Nẽ axàmnhĩx ri mẽ kêp amrakati xwỳnhjê mã mẽmoj nhõr o ri apa. Kot kaj mẽ ã amnhĩ nhĩpêx anẽ nhũm Tĩrtũm ja hã mẽ apumu nẽ amnhĩm mẽ amex ã mẽ ajarẽ. No na ka htem amã mẽ amnhĩ to mex prãm xàj ãm tee ri amnhĩ kuhõnh japjê kaprỳ. ");
INSERT INTO apnNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","—Hêxta waa nẽ. Mẽ apê Parijew nhõ xwỳnhjê mẽ mẽ apê Tĩrtũm kapẽr tũm o mẽ ahkre ho mẽ apa xwỳnhjaja kot kaj mẽ amex kêt nẽ. Te mẽ ate mẽ htykjê jagjênh xà pyràk. Na htem mẽ hagjênh xà ho mex o pa nom kamã mẽ hi nẽ ahpunuj pix. ");
INSERT INTO apnNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Ja pyrà nẽ ã mẽ ate amnhĩ nhĩpêx anhỹr. Kapôt rũm mẽ anhĩja na mex. Te mẽ ate mẽ ho mex o apa pyràk o na ka htem amnhĩ nhĩpêx nhũm mẽ ãm akrãhkà pix pumu nom ãm mẽ akrã hi kaxwỳnh kãm mẽ ajamaxpẽr punuj rãhã hã mẽ apumunh kêt nẽ. Mẽ ate tanhmã mẽ no kupyr to pix kukamã ajamaxpẽr jakamã te mẽ ate mẽ htykjê jagjênh xà pyràk. ");
INSERT INTO apnNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","30","—Hêxta waa nẽ. Mẽ apê Parijew nhõ xwỳnh mẽ mẽ apê Tĩrtũm kapẽr tũm o mẽ ahkre xwỳnhjaja kot kaj mẽ amex kêt nẽ. Mẽ ate mẽ no kupyr xwỳnh na ka mẽ. Na ka htem ma mẽ hã pika hwỳr apa nẽ Tĩrtũm nhỹ hã kapẽr o mẽ pa xwỳnhjê hã pika ho mex. Nẽ mẽ kot amnhĩ to mex xwỳnhjê hã pika ho mex. Nẽ axpẽn mã mẽ harẽnh o: “Hêxta waa nẽ. Na pre amnepêm mẽ pakukamã mẽ panhĩgêtjaja Tĩrtũm nhỹ hã mẽ kãm kapẽr xwỳnhjê homnuj nẽ mẽ kupa. No kêt mẽ papajaja mẽ kamã ri papa ronhỹx pu prem mẽ uràk nẽ ã mẽ hipêx anhỹr kêt nẽ.” Anhỹr o axpẽn mã mẽ hkaprĩ ho ri apa. ");
INSERT INTO apnNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","32","Nom ãm amnhĩ to axêx. Mẽ ate ã amnhĩ nhĩpêx anhỹr o apa kênã. Ã mẽ ate amnhĩ nhĩpêx anhỹr jao ra apê mẽ hkanrẽhã mẽ hkra kumrẽx ã amnhĩ to amnhĩrĩt mex o apa. ");
INSERT INTO apnNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Te mẽ ate kagã xoprê kot mẽ hkamnhar nẽ mẽ homnuj tỳx pyràk jakamã koja Tĩrtũm nhỹrmã ma mẽ kot amnhĩ xà htỳx kamã hamak tũm xàta wỳr mẽ ajano ka mẽ ma hwỳr ajapêx. Hãmri nẽ tee ri amã ajapôx prãm kaprỳ nẽ rĩ amnhĩ pumu. ");
INSERT INTO apnNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","—Kot paj nhỹrmã ma mẽ awỳr inhỹ hã ixkapẽr jarẽnh o mẽ pa xwỳnh kwỳ rẽ. Nẽ inhỹ hã mẽ àhpumunh xwỳnh kwỳ rẽ. Nẽ ixkapẽr o mẽ ahkre xwỳnh kwỳ rẽ. Nom kot kaj mẽ ãm mẽ kapẽr ma nẽ apê mẽ hprãm nõkati nẽ tanhmã mẽ homnuj tỳx to ho apa. Nẽ ixpê mẽ hkwỳjê hpar o apa. Jao pĩ kahpa hã mẽ hanhôr o mẽ hkwỳjê hpa. Nhũm mẽ hkwỳjaja Tĩrtũm kapẽr o mẽ ahkre xà hã ixkre kamã mẽ ahkre ho hkrĩ ka mẽ omu nẽ mẽ unê nẽ ixkreja kamã mẽ htak. Hãmri nhũm mẽ apymaj nhãm ahpỹnhã krĩ hkwỳ hwỳr hprõt nẽ mra. Ã kot kaj mẽ inhỹ hã ixkapẽr jarẽnh xwỳnhjê nhĩpêx anhỹr o apa. ");
INSERT INTO apnNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","36","Na prem ra mẽ himex rax nẽ. Amnepêm panhĩ kator krax rũm Atãw kra Apewta na pre Tĩrtũm nhỹ hã kapẽr o pa nhũm htõja kãm mar prãm kêt nẽ kupĩ. Tã nhũm Tĩrtũm axte mẽ hwỳr ỹ hã kapẽr o mẽ pa xwỳnh kwỳjê rẽ nhũm prem mã mẽ ho anẽ nẽ mẽ hkwỳjê nhĩmex. Nhũm pre xatã mẽ hwỳr mẽ hkwỳjê rẽ nhũm mẽ xatã mẽ kupa. Apew rũm Parakis kra Jakaris wỳr na prem mẽ himex rũnh nẽ. Hãmri nhũm prem Tĩrtũm mã amnhĩ jarẽnh xà hã ixkre kamã Jakarisja pĩ. Tã mẽ kajaja mẽ ate mẽ uràk nẽ mẽ amã Tĩrtũm kapẽr mar prãm kêt nẽ mẽ uràk nẽ amã Tĩrtũm nhỹ hã kapẽr xwỳnhjê nhĩmex prãm nẽ. Ã mẽ ate mẽ anhĩgêtjê pyrà nẽ mẽ hipêx anhỹr mỳrapê koja Tĩrtũm mẽ apê mẽ hkanrẽhã mẽ hkra nẽ mẽ htàmnhwỳjaja mẽ ato hpimrààtã tanhmã mẽ ato htỳx to ka mẽ amnhĩ xà htỳx kamã ajamak rãhã ho ri apa. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Hãmri nhũm Jejus te ra kot Jerujarẽ nhõ xwỳnhjê pumunh nẽ mẽ kãm kapẽr pyràk o tanhmã kapẽr to ho xa. Nẽ mẽ kãm: —Hêxta waa nẽ Jerujarẽ nhõ xwỳnhjaja. Tĩrtũm kot xatã mẽ awỳr ỹ hã kapẽr jarẽnh xwỳnhjê rẽnh nhũm mẽ kot mẽ akôt mẽ amã kapẽr jarẽnh o pa htã ka mẽ kapẽr mar kêt kumrẽx. Nẽ axtem nẽ kẽn o mẽ htak o mẽ himex o apa. Ã na ka htem amnhĩ tomnuj o apa anẽ. Tã nom arĩ inhmã mẽ ajamãr o ri ixpa hprãm. Te ho krãhyre kot nore hpro nẽ ho hikwỹ pyràk o na pa inhmã mẽ anhĩpêx prãm nẽ. Nom mẽ amã ixprãm nõkati nẽ mẽ ate ixkaga kumrẽx. ");
INSERT INTO apnNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Mỳrapê koja Tĩrtũm mẽ anhõ krĩ jamãr kêt nẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Kot paj tokyx ty nẽ mẽ apiitã mẽ are nẽ ma akupỹm api ka mẽ axte ixpumunh kêt nẽ. Ãm akupỹn ixwrỳk xà hã arĩgrota pix ã koja mẽ akwỳjaja mẽ amỳrpê krĩ ja kamã ixpôx ã ixpumu. Hãmri nẽ mẽ akurom ixpumu nẽ hkĩnh tỳx nẽ. Nẽ tã ixkôt amnhĩ xunhwỳr kurê kumrẽx. Hãmri nẽ axpẽn mã ijarẽnh o: Ota Tĩrtũm kot mẽ pahwỳr mẽnh xwỳnhta wrỳ. Nà ãm hãmri na mẽ pahwỳr wrỳ. Ja mex o mex. Koja mẽ ã axpẽn mã ijarẽnh anẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Tã nhũm Jejus Tĩrtũm mã amnhĩ jarẽnh xà hã ixkre rũm kato nẽ ma tẽ. Pa mẽ ixte hkôt ixpa ho ixpa xwỳnhjaja kormã ixkreja pumunh o ixkuhê nẽ kãm harẽ nẽ kãm: —Kwa Pahihti. Hêxta waa nẽ. Ixkreja ãm mex kumrẽx. Anẽ. Hãmri nhũm mẽ inhmã: ");
INSERT INTO apnNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","—Tỳ mex nom koja nhỹrmã mẽ kãm Tĩrtũm kurê xwỳnhjaja grành pa. Koja arĩ kẽn õ axkrutre nẽ axpẽn mỳnh nẽ nõr kêt nẽ. Koja piitã anhgrà nẽ ahpỹnhã ri hikwỹ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Hãmri pa mẽ kuma nẽ tee ri hkukamã ijamaxpẽr. Hãmri nhũm Jejus ma tẽ nẽ hixêt pê Oriwêhti hã api nẽ hã nhỹ pa mẽ ma hkôt mra nẽ mẽ kot ã ixkre nhĩpêx anhỹrta ã hkukja nẽ kãm: —Kwa xà ãm hãmri koja mẽ ã ixkreta nhĩpêx anẽ? Kwa mẽ inhmã aprĩ hã harẽ. Xà koja mẽ nhỹrmã ho anẽ nà? Xà koja mẽ tokyx ho anẽ? Nẽ akupỹn mẽ ixwỳr awrỳk nhũm mẽmoj piitã hapêxja. Kwa mẽmo koja we wỳj ri tanhmã amnhĩ nhĩpêx to wehe? Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Hãmri nhũm mẽ inhmã hprĩ hã tanhmã mẽmoj kot amnhĩ nhĩpêx to hkukamã ujarẽnh o nhỹ nẽ mẽ inhmã: —Nà nhỹrmã mẽmoj piitã hapêx kaxyw tanhmã amnhĩ nhĩpêx toja kumrẽx kot paj mẽ amã harẽ ka mẽ inhma. Nà koja mẽ ohtô nẽ mẽ awỳr mra nẽ hêx rom te pa ixte amnhĩ nhĩpêx pyràk o amnhĩ nhĩpêx o mẽ akôt pa. ");
INSERT INTO apnNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Nẽ mẽ amã amnhĩ jarẽnh o: “E Tĩrtũm na pre mẽ awỳr inhmẽ. Ixpê kaxkwa rũm ixwrỳk xwỳnhta na pa.” Anhỹr o mẽ akôt mẽ amã amnhĩ to hêx o pa. Jao ohtô nẽ mẽ nokupyr o pa. ");
INSERT INTO apnNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","—Nẽ koja mẽ nhỹri awry hã axpẽn par o pa nẽ mẽ atã axpẽn par o pa. Nom kêr ka mẽ harẽnh ma nẽ ri tokyx mẽmoj piitã hapêx ã hkamnhĩx kêt nẽ. Kormã mẽmoj piitã hapêx xà hã arĩgroja kormã. ");
INSERT INTO apnNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Koja mẽmoj piitã hapêx kaxyw nhũm ahpỹnhã ri pika piitã hkôt mẽ pa xwỳnhjaja pika hõ nhõ xwỳnhjê kutã kuhê nẽ pijapu ho kuhê. Jao ra axpẽn par o pa. Hãmri nhũm nhỹri pika hkwỳ htertet tỳx kumrẽx. Nẽ mẽ hpur kãm mẽõja hapêx nhũm mẽ kãm prãm tỳx nẽ pa. Jakamã nhũm mẽ ohtô nẽ prãm xàj axkaprã. ");
INSERT INTO apnNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Nom ja kormã mẽmoj hapêx kaxyw krax pix na. Te ho mẽnijê hõ hpijagri kaxyw nẽ kormã kawax pê õhy xà pyràk. ");
INSERT INTO apnNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","—Nẽ koja mẽ piitã ixkôt mẽ akamã gryk nẽ kãm mẽ akurê htỳx o pa. Nẽ mẽ awỳr mra nẽ ixtã mẽ apynê nẽ mẽ atomnuj tỳx nẽ mẽ apa. ");
INSERT INTO apnNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Jakamã koja mẽ kot ixkôt amnhĩ xunhwỳr xwỳnh kwỳjaja mẽ umaj tee ri amnhĩ kukamã hamaxpẽr hãmri nẽ ixkaga. Nẽ ixkôt mẽ kãm axpẽn tã amỹnê nẽ axpẽn kãm gryk o pa. ");
INSERT INTO apnNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Nhũm nhỹri mẽ hkwỳjaja Tĩrtũm nhỹ hã kapẽr jarẽnh xwỳnh ã amnhĩ to hêx o pa. Jao mẽ ohtô nẽ mẽ nokupyr o pa. ");
INSERT INTO apnNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Koja mẽ ã amnhĩ nhĩpêx anhỹrja o ra piitã kãm axpẽn kamã ukaprĩ hkêt o pa. ");
INSERT INTO apnNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Koja mẽ ã ixtã mẽ atomnuj o pa anẽ. Tã nom kêr ka mẽ amnhĩ to htỳx nẽ ixkaga hkêt nẽ. Mẽ kot mẽ apar tã ka mẽ kaxkwa kamã akupỹm atĩr kurê kumrẽx. ");
INSERT INTO apnNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","—Nẽ kot kaj mẽ apê ixkwỳjaja ma krĩ piitã hkôt Tĩrtũm kapẽr o mẽ ahkre ho apa. Mẽ kot amnhĩ tomnuj kaga nẽ ixkôt amnhĩ xunhwỳr nhũm Tĩrtũm kot ja hã mẽ omunh nẽ mẽ ho hkra hã mẽ kãm harẽnh o ri mẽ piitã mẽ hkôt apa. Kot kaj mẽ piitã mẽ kãm ijarẽnh pa pa rĩ kormã akupỹn mẽ awỳr wrỳ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Nhũm Jejus arĩ mẽmoj kukamã mẽ inhmã kapẽr nẽ mẽ inhmã: —Amnepêm Tĩrtũm nhỹ hã kapẽr xwỳnh finat Tãnĩewja na pre tanhmã mẽ atomnuj tỳx xwỳnh maatija jarẽnh to. Tã koja nhỹrmã ra kot harẽnh xà hkôt axtem nẽ Tĩrtũm mã amnhĩ jarẽnh xà hã ixkre hwỳr axà nẽ Tĩrtũm xãm xà kamã xa. Ka mẽ ja hã omu hãmri nẽ mẽ kot krĩ grành par ã hkamnhĩx kurê kumrẽx. ");
INSERT INTO apnNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Koja ã amnhĩ nhĩpêx anẽ ka mẽ amỳm amnhĩ wỳr mẽ omu hãmri nẽ ajapôj nẽ ma aprõt nẽ amrar kurê kumrẽx. Mẽ apê jar pika pê Jutej kamã mẽ apa xwỳnhjaja kaj mẽ omu hãmri nẽ mẽ kot mẽ apar pymaj aprõt nẽ ma amrar kurê kumrẽx. ");
INSERT INTO apnNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Rỳ ka mẽ anhõrkwỹ hkrãmnênh o akrĩ japêr nẽ amỳm amnhĩ wỳr mẽ omu nẽ akukrêx wỳr axàr nẽ hõ hpyr mã ajamaxpẽr kêt nẽ. Ãm wrỳ nẽ aprõt nẽ ma atẽm kurê kumrẽx. ");
INSERT INTO apnNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Rỳ ka mẽ apur kãm axàpênh o apa japêr nẽ amỳm mẽ omu hãmri nẽ akupỹm anhõrkwỹ hwỳr axê jamỳnh kaxyw atẽm kêt nẽ. Ãm mẽ umaj aprõt nẽ ma atẽm kurê kumrẽx. ");
INSERT INTO apnNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","—No mẽ htujarô nẽ mẽ hkra karàre xwỳnhjaja koja mẽ kêp mẽmoj omnuj tỳx nẽ. Tanhmã kot mẽ amnhĩ to nẽ mẽ umaj hprõt tỳx? Nà pika ja kamã koja mẽ mex kêt o mex kêt. Mẽ kot amnhĩ tomnuj mỳrapê koja Tĩrtũm tanhmã mẽ homnuj tỳx to. ");
INSERT INTO apnNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","—Nẽ kwa kêr ka mẽ amnhĩ to Tĩrtũm wỳ kê ã mẽ kot amnhĩ nhĩpêx anhỹr xà hã arĩgroja na wrỳk pê ã amnhĩ nhĩpêx anhỹr kêt nẽ. Rỳ mẽ hkôt xà hã arĩgro pê sap ã ã amnhĩ nhĩpêx anhỹr kêt nẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","—Nẽ ã mẽ kot amnhĩ nhĩpêx anhỹr ã arĩgroja ã koja mẽ piitã amnhĩ xà htỳx kãm hamak tỳx kumrẽx. Amnepêm Tĩrtũm kot pika ho kator krax rũm amnẽ mẽ pa xwỳnhjaja kormã aa kot ã amnhĩ xà htỳx kamã hamak anhỹr kêt tã arĩgroja ã koja mẽ amnhĩ xà htỳx kumrẽx kamã ama. Hãmri nẽ axte pika ja kamã ã amnhĩ xà htỳx kumrẽx kamã hamak anhỹr kêt nẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Kop apu Tĩrtũm kot mẽ kot amnhĩ xà htỳx kamã hamak xà hã arĩgro hkwỳ ho gri hkêt ronhỹx ka mẽ apiitã apikaprãr pa. Ja pymaj koja mẽ amã ho gri. Kot ra amnhĩ kaxyw mẽ arênh xwỳnhjê japê xàj mẽ amã ho gri. ");
INSERT INTO apnNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","24","—Tã ã mẽmoj kot amnhĩ nhĩpêx anhỹr jakamã koja mẽmojaja tanhmã mẽ amã ixto hêx to nẽ mẽ amã: “Ota ra Kris akupỹn wrỳ. Kwa mẽ hwỳr mra nẽ omu.” Anẽ. Rỳ mẽ amã: “Krisja krĩ mũj kamã na raa. Kwa mẽ ma hwỳr mra nẽ omu.” Anhỹr o mẽ amã ixto hêx o pa. Rỳ mẽ awỳr mra nẽ mẽ amã amnhĩ to hêx nẽ mẽ amã: “E. Ot pa ixpê Kris ã mẽ awỳr wrỳ. Tĩrtũm na mẽ awỳr inhmẽ pa wrỳ.” Anẽ. Rỳ mẽ amã: “E ixpê Tĩrtũm nhỹ hã ixkapẽr xwỳnh na pa mẽ awỳr mõn pôj.” Anhỹr o mẽ amã amnhĩ to hêx. Hãmri nẽ mẽ anokupyr kaxyw mẽ amã aa mẽ kot mẽmoj pumunh kêt kwỳ ho anhỹr o pa. Tĩrtũm kot amnhĩ kôt mẽ arênh xwỳnhjaja kãm mẽ ate ja hã mẽ omunh nẽ mẽ gryk ã ixkaga hprãm xàj koja mẽ ã mẽ anoo mã amnhĩ nhĩpêx anhỹr o pa. Nom ãm ã amnhĩ nhĩpêx anhỹr kaprỳ ka mẽ ixkaga hkêt nẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","—E kwa mẽ inhmar tỳx nẽ. Na pa ra ixprĩ hã ã mẽ kot amnhĩ nhĩpêx anhỹrja kukamã ã mẽ amã mẽmoj jarẽnh anẽ. Tã kêr ka mẽ amnhĩ nê ã mẽ kot amnhĩ to hêx anhỹr o mẽ pa xwỳnhjê pumunh mex o apa nẽ axkãm ajamak rom. ");
INSERT INTO apnNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Rỳ koja mẽ tanhmã mẽ amã ixto hêx to nẽ mẽ amã: “Ota Tĩrtũm kot mẽ pahwỳr mẽnh xwỳnhta kapôt ã mõn pôj. E mẽ tokyx ma hwỳr mra nẽ omu.” Anhỹr o mẽ amã ijarẽ ka mẽ ama nẽ ãm mẽ ama nẽ hwỳr amrar kêt nẽ. Rỳ nhũm mẽ amã: “Ota hitom kãm xa. E mẽ mamrĩ hwỳr agjê nẽ omu.” Anẽ no ka mẽ ãm mẽ ama nẽ ãm mẽ ama nẽ hwỳr agjêx kêt nẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Kot paj nhỹrmã akupỹn mẽ awỳr ixwrỳk kaxyw hãmri nẽ ixpimxur kãm ixwrỳk kêt nẽ. Koja pika piitã hkôt mẽ pa xwỳnhjaja anhĩpê ixwrỳk kãm ixpumu. Te mẽ piitã anhĩpê mẽ kot na haxênh pumunh pyràk o kot kaj mẽ anhĩpê apiitã ixpumu. ");
INSERT INTO apnNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Te nhỹri mẽmoj kro nẽ nõr nhũm nhônhti kot omunh nẽ hã htor nẽ hpinhpanh nhũm mẽ piitã hã omunh pyràk o kot paj amnhĩ nhĩpêx. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Nhũm Jejus arĩ mẽ ixte hkôt ixpa ho ixpa xwỳnhjê mã kapẽr nẽ mẽ inhmã: —Nẽ kot paj akupỹn mẽ awỳr inhnojarêt nhũm rĩ Tĩrtũm kaxkwa kamã tanhmã mẽmoj nhĩpêx to. Kapẽr ã kagà htũm kot tanhmã ja kukamã harẽnh to nẽ harẽnh kot: Koja Tĩrtũm kaxkwa ho àk nhũm kanhêti piitã rôrôk pa nhũm myyti ahtyk nhũm mytwrỳre uràk nẽ axte hpôk kêt nẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Koja ã mẽmoj amnhĩ nhĩpêx anhỹr pa hãmri pa kaxkwa hã mẽ amã mẽmoj nhô. Hãmri nhũm pika piitã hkôt ri mẽ pa xwỳnhjaja piitã omu nẽ tee ri amnhĩ kukamã hamaxpẽr o hkaprĩ nẽ mỳr rax kumrẽx. No mẽ kajaja kot kaj mẽ omu hãmri nẽ akupỹn mẽ awỳr ixwrỳk nẽ mẽ ato amnhĩptàr mã ajamaxpẽr kurê kumrẽx. Kot paj kakrã kamã hirã htỳx kãm akupỹn ixihtỳx kãm mẽ awỳr wrỳ. ");
INSERT INTO apnNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Hãmri nẽ Tĩrtũm kapẽr o mẽ wrỳk xwỳnh maati mã anẽ nhũm pifti kakô hãmri nhũm hkwỳjaja kuma nẽ ma mẽ awỳr pika piitã hkôt anhgrà nẽ ma mra nẽ inhmã mẽ ato akuprõ. Ixte amnhĩ kaxyw mẽ axunhwỳr xwỳnhjê o akuprõ nẽ man akupỹn ixwỳr mẽ ato hapêx. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Nhũm Jejus arĩ mẽ inhmã kapẽr nẽ mẽ inhmã: —E ka mẽ pĩ hpàr mũj pumu. Na hte mẽmo mytwrỳ hã rã nhũm mẽ omu nẽ ô hkukamã hamaxpẽr kurê kumrẽx. ");
INSERT INTO apnNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Ja pyrà nẽ koja ã ixte mẽmoj jarẽnh anhỹr xwỳnhja amnhĩ nhĩpêx par mẽ ka mẽ omu nẽ akupỹn mẽ awỳr ixwrỳk mã ajamaxpẽr kurê kumrẽx. Kot paj te ra mẽ anhõrkwỹ kapem ixãm pyràk o amnhĩ nhĩpêx. ");
INSERT INTO apnNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Nom akupỹn ixwrỳk kêt ri koja ã mẽ kot mẽmoj kot amnhĩ nhĩpêx anhỹr pumunh xwỳnhjaja kormã piitã htyk kêt ri pa akupỹn wrỳ. ");
INSERT INTO apnNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","—Nẽ koja nhỹrmã pika nẽ kaxkwa wa hapêx pa. Tã no ãm ixkapẽrja koja wa uràk nẽ aa hapêx kêt nẽ. Koja ãm rãhã ho rãhã. Kot paj aa ihkjê ho tanhmã mẽnh to hkêt nẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Nhũm Jejus arĩ mẽ inhmã kapẽr nẽ mẽ inhmã: —Nẽ ixte akupỹn mẽ awỳr ixwrỳk xà hã arĩgroja mẽ ate omunh kêt. Nẽ kaxkwa kamã Tĩrtũm kapẽr o mẽ wrỳk xwỳnhjaja haxwỳja kot ja pumunh kêt. Nẽ ijaxwỳja ixpê Tĩrtũm Kra htã ixte ja hã amnhĩ pumunh kêt. Ãm inhõ Papaj pix na kot ja pumunh. ");
INSERT INTO apnNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","—Nẽ kot paj nhỹrmã man akupỹn mẽ awỳr wrỳ. Akupỹn mẽ awỳr ixwrỳk xà hã arĩgrota ã koja mẽ htỳx ri amnhĩ tomnuj o pa. Te amnepêm Noehti kormã htĩr ri mẽ pa xwỳnhjaja kot htỳx ri amnhĩ tomnuj o pata pyràk. ");
INSERT INTO apnNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Na pre htem amnhĩ kaxyw Tĩrtũm mã hamaxpẽr kêt nẽ. Ãm jar mẽ kot amnhĩ nhĩpêx pix kukamã hamaxpẽr kôt pix mã amnhĩ nhĩpêx o pa. Rôm nhũm Noehtija gô htàm pymaj pàr rax nhĩpêxta mã axà. ");
INSERT INTO apnNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Nhũm mẽ ja hã omu nẽ ãm omu nẽ tanhmã ri amnhĩ kukamã hamaxpẽr to hkêt nẽ. Hãmri nhũm naja mẽ haêr pê wrỳ nẽ wrỳk rax o mẽ hanhir pa. Tã akupỹn ixwrỳk xà hã arĩgroja ã koja mẽ htỳx ri ã amnhĩ nhĩpêx anhỹr o paja o pa mẽ haêr pê naja pyrà nẽ akupỹn wrỳ. ");
INSERT INTO apnNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","—E kot paj mẽ amã nhỹrmã akupỹn ixwrỳk nẽ tanhmã mẽ anhĩpêx to hã amnhĩ jarẽ. Te kot ja pyràk. Koja mẽmyjê hõ wa hamẽxkrut nẽ hpur kãm àpênh o xa. Nhũm hõja ra ixkôt amnhĩ xãm nhũm hõja ixkôt amnhĩ xãm kêt japêr. Hãmri pa amnhĩ wỳr ra kot ixkôt amnhĩ xãm xwỳnhta o api nhũm kot ixkôt amnhĩ xãm kêt xwỳnhta hpur kãm ahte arĩ xa. Hãmri nẽ tee ri hkràmnhwỳ japêr rĩt o xa. ");
INSERT INTO apnNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Rỳ nhũm mẽnijê wa hamẽxkrut nẽ harôj kahuk o xa. Nhũm hõja ra ixkôt amnhĩ xãm nhũm hõja ixkôt amnhĩ xãm kêt japêr. Hãmri pa amnhĩ wỳr kot ixkôt amnhĩ xãm xwỳnhta ho api nhũm kot ixkôt amnhĩ xãm kêt xwỳnhja tee ri hkràmnhwỳ japêr rĩt o xa hãmri nẽ hamaxpẽr rax kumrẽx. Kot paj nhỹrmã akupỹn wrỳ nẽ ã mẽ anhĩpêx anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Tã mẽ ate akupỹn ixpôx xà hã arĩgro pumunh kêt jakamã kwa kêr ka mẽ ijamãr rãhã ho ri apa. ");
INSERT INTO apnNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Na htem htỳx ri nhỹri tanhmã amnhĩ nhĩpêx to ho pa nhũm mẽ kêp àhkĩnh xwỳnh mẽ õrkwỹ hwỳr agjê nẽ mẽ kêp ahkĩ. ");
INSERT INTO apnNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Tã mẽ ate akupỹn ixwrỳk xà hã arĩgro pumunh kêt jakamã kwa kêr ka mẽ ixwakre kamã te mẽ apê mẽ õrkwỹ nhõ dõn kot amnhĩ nhĩpêx pyrà nẽ atỳx ri tanhmã amnhĩ tomnuj to ho apa hkêt nẽ. Ixkutêp axkãm ajamak rom nẽ ri apa. Jao tãm ixkutêp amnhĩ nhĩpêx rãhã ho ri apa. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Nhũm Jejus arĩ mẽ inhmã kapẽr nẽ mẽ inhmã: —E koja mẽ kãm àpênh xwỳnhjê hõ àpênh mex o pa hãmri nhũm õ patrãw àpênh ã omu hãmri nẽ ma nhỹhỹm mõr kaxyw nẽ ĩhkram mẽmoj piitã haxàr pa nẽ kãm: “E kêr ka ixwakre kamã inhmã inhõrkwỹ tãnopxar mex nẽ. Nẽ inhmã mẽ àpênh xwỳnhjê mã mẽ apkur xà nhõr o apa.” Anhỹr o kãm mẽmoj tã karõ hãmri nẽ kato nẽ ma nhỹhỹm mõ. ");
INSERT INTO apnNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Hãmri nhũm kot kãm àpênh mex xwỳnhja wakre kamã kãm àpênh mex o pa. Jakamã nhũm õ patrãw akupỹn hpôx o mõ nhũm amnhĩ wỳr harẽnh ma nẽ hkĩnh nẽ. Nẽ tee ri amnhĩ kukamã hamaxpẽr o kãm uma hkêt nẽ. Kot wakre kamã kutêp kãm àpênh mex jakamã tee ri tanhmã amnhĩ kukamã hamaxpẽr to hkêt nẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Jakamã nhũm õ patrãwja akupỹn pôj nẽ kot kãm àpênh mex ã omu nẽ hkĩnh nẽ. Hãmri nẽ kot kãm õ mẽmoj piitã hamãr o pa kaxyw ĩhkram haxàr pa. ");
INSERT INTO apnNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","No koja axtem nẽ wakre kamã kãm àpênh mex kêt japêr. Nẽ hamaxpẽr o: “Tk. Nà koja tokyx akupỹn mõr kêt nẽ.” Anhỹr o hkamnhĩx. ");
INSERT INTO apnNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Hãmri nẽ wakre kamã kãm mẽ àpênh xwỳnhjê htak nẽ pipãnh pix o pa. Nẽ kãm kagôxỳhti xành xwỳnhjê kôt pix mã pa. ");
INSERT INTO apnNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Hãmri nhũm õ patrãwja haêr pê akupỹn pôj nẽ tee ri ja hã omu. ");
INSERT INTO apnNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Hãmri nẽ kamã gryk tỳx nẽ tanhmã homnuj htỳx to nẽ kãm mẽ àpênh punuj xwỳnhjê mẽ mẽ ho hpimrààtã amnhĩ nê mẽ kator pa. Hãmri nẽ mẽ kot kapẽr kwỳm amnhĩ nhĩpêx xwỳnhjê mẽ mẽ ho hpimrààtã tanhmã mẽ homnuj to nẽ amnhĩ nê mẽ kator. Hãmri nhũm mẽ tee ri amnhĩ kukamã hamaxpẽr nẽ mur nẽ tee ri amnhĩ nhĩpêx. Tã kêr ka mẽ ixwakre kamã ho mẽ uràk kêt nẽ. Mẽ kurom ixwakre kamã ixkapẽr kôt amnhĩ nhĩpêx mex rãhã ho ri apa. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Nhũm Jejus arĩ mẽ inhmã kapẽr nẽ mẽ inhmã: —Nẽ mẽ ate Tĩrtũm kôt amnhĩ nhĩpêx o mẽ apa xwỳnhjaja kêr ka mẽ akupỹn amnhĩ wỳr ixkãm ajamak rom nẽ ri apa. Nom mẽ kêp Tĩrtũm prãm nõkati xwỳnhjaja koja mẽ akĩnhã ãm htỳx tanhmã amnhĩ to pix kukamã hamaxpẽr o pa. Te kormã mẽ mjên kêt xwỳnhjaja kot amnhĩ nhĩpêxta pyràk. E pa mẽ amã tanhmã mẽ harẽnh to ka mẽ inhma. Koja kormã mẽ mjên kêt xwỳnh kêp 10jaja ma hkràmnhwỳ mjên mã xwỳnh kutã pry hã mra. Amnhĩ kôt kanê jamỳ nẽ o mra nẽ kutêp pry nhĩkrep hkrĩ. ");
INSERT INTO apnNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","4","Nhũm mẽ kêp 5jaja hkwỳjê rom amnhĩ kukamã hamaxpẽr mex nẽ kanê kaxyw amnhĩ kôt orti hkwỳ ho mõ. No nhũm mẽ kêp 5 nẽ mẽ hkĩnhã ãm htỳx kanê pix jamỳ nẽ o mra. ");
INSERT INTO apnNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Hãmri nẽ mẽ mjên mã xwỳnhja kutêp axpẽn mã kapẽr o hkrĩ. Nhũm tokyx htẽm kêt nhũm mẽ kutêp hkrĩ nẽ gaa nẽ ra õtxwa nẽ gaa nẽ hikwỹ nẽ ra õt pa. ");
INSERT INTO apnNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","—Tã nhũm kôt ã kamàt hãmri nhũm mjên mã xwỳnhta hpôx o tẽ. Hãmri nhũm kot hkukamã harẽnh xwỳnhja mẽ õt o mẽ hikwỹ xwỳnhjê mã amỹra nẽ mẽ kãm: “Kwa mẽ hãmri. Ota mjên mã xwỳnhta tẽ. Mẽ tokyx kànhmã akrĩ pu mẽ kutã mra.” Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Hãmri nhũm mẽ hkrã hapôj nẽ kanê hpôk. ");
INSERT INTO apnNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Nom nhũm mẽ hkwỳjê hkĩnhã õ kanê kaxyw orti ho pa hkêt xwỳnhjaja ra mẽ kêp mẽ kanêja hkaprỳ hpa nhũm mẽ tee ri kot hpôk kaxyw. Hãmri nẽ orti hkwỳ hã hkwỳjê hwỳ nẽ mẽ kãm: “Xê mẽ inhmã orti ho inhõ kanê go.” Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Nom nhũm mẽ kêp nê nẽ mẽ kãm: “Ma mẽ inhõ kanê kamã orti grire kênã kot pa kêt mẽ amã ho go. Xê mẽ tokyx ma mra nẽ nhỹri amnhĩm hkwỳ japrô mê.” Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Hãmri nhũm mẽ tee ri mẽ kuma nẽ ma amnhĩm hkwỳ japrôr mã ma mra. —Rôm nhũm mjên mã xwỳnhta mẽ hãnh tẽ nhũm kanê kamã arĩ mẽ orti xwỳnhjaja omu nẽ hã jêt kurê kumrẽx. Hãmri nẽ ma hkôt mõn mẽ pikuprõnh xà hã ixkreja wỳr wa hã hkĩnh nẽ apkur kaxyw gjêx pa nhũm mẽ hã kahê. Mẽ gjêx xà hã oreja ra hwỳr hpôx jakamã nhũm mẽ hã kahê. ");
INSERT INTO apnNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","—Tã nhũm ma mẽ kot orti japrôr mã mrar xwỳnhjaja hãmri amnhĩ to hapu nẽ mra nẽ tee ri mẽ hã hakwakre kupê nẽ htatak nẽ tee ri mẽ kãm akir nẽ mẽ kãm: “Xê mẽ inhmã kahê xà mẽ pa mẽ awỳr agjê.” Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Hãmri nhũm hprõ mã xwỳnhta mẽ kuma nẽ mẽ kãm: “Tk. Nà ixte mẽ apumunhre hã kot pa kêt mẽ amã kahê xà mẽ. Kwa mẽ ma akupỹm mra.” Anẽ. Ã mẽ ujarẽnh kot anhỹr. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Nhũm pre ã Jejus mẽ inhmã ujarẽnh anẽ. Hãmri nẽ mẽ inhmã: —E kêr ka mẽ te kot amnhĩ kôt orti hkwỳ ho mõr xwỳnhjaja kot amnhĩ nhĩpêx pyràk. Mẽ ate akupỹn ixwrỳk xà hã arĩgro pumunh kêt jakamã kêr ka mẽ apkati mẽ ixkamã ajamak rãhã ho apa. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Nhũm Jejus arĩ mẽ inhmã kapẽr nẽ mẽ inhmã: —E kêr ka mẽ ixwakre kamã inhmã tanhmã amnhĩ nhĩpêx mex to ho ri apa pa hpãnhã mẽ amã amnhĩrer mex nẽ. Mẽ ate tanhmã inhmã amnhĩ nhĩpêx to ho apa xà hkôt kot paj mẽ amã amnhĩre. Te mẽhõ my kot kãm mẽ àpênh xwỳnhjê nhĩpêx pyràk. Koja nhỹhỹm nojarêt nẽ kãm mẽ àpênh xwỳnhjê mã hikukrêx piitã hkaga hpa. Õrkwỹ nẽ hpur nẽ hkrit. Ãm mẽmoj piitã mẽ kot wakre kamã kãm hamãr o pa kaxyw mẽ kãm hkaga hpa. ");
INSERT INTO apnNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Hãmri nẽ ahpỹnhã mẽ kãm kàxpore hkwỳ gõ. Mẽ kot kutêp kãm tanhmã ho rũnh to kaxyw ahpỹnhã mẽ kãm õr pa. Kot kàxpore pumunh mex xwỳnhja mã nhũm ho 5.000 nẽ kugõ. Nẽ kot hkôt kax pê omunh xwỳnhja mã nhũm ho 2.000 nẽ kugõ. Nẽ kormã kot omunh tỳx kêt xwỳnhja mã nhũm ãm ho 1.000 pix nẽ kugõ. Hãmri nẽ mẽ kãm amnhĩ jarẽ nẽ ma nhỹhỹm mõ. ");
INSERT INTO apnNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Hãmri nhũm kot ho 5.000 nẽ hamỳnh xwỳnhja kàxporeta py nẽ ma o mõr kurê kumrẽx nẽ tanhmã ho àpênh to ho mõr kãm ra hipy axte ho 5.000 nẽ kumẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Nhũm kot ho 2.000 nẽ hamỳnh xwỳnhja mããnẽn tanhmã ho àpênh to ho mõr kamã ra hipy axte ho 2.000 nẽ kumẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Nom nhũm kot ho 1.000 pix nẽ hpyr xwỳnhja wa hkĩnh ã axtem nẽ ma o tẽ nẽ kãm kakwỳ nẽ kamã haxà nẽ hity hpa nẽ ma akupỹm tẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","—Tã nhũm mẽ õ patrãwja akupỹn mõn pôj nẽ mẽ kãm: “E mẽ amnẽ ixwỳr mra nẽ ixte mẽ amã kàxpore ho ixpigrành xwỳnhta jarẽ. Tanhmã na ka prem ixkutêp inhmã hipêx to?” Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Hãmri nhũm kot ho 5.000 nẽ hpyr xwỳnhta kumrẽx hwỳr tẽ nẽ kãm: “E ota akàxporeta. Ate inhmã ho 5.000 pix nẽ õr tã pa amã ho rax nẽ amã hipy axte ho 5.000 nẽ kumẽ nhũm ho axkamur nẽ ra ho 10.000. Tã ota.” Anhỹr o kãm kapẽr hãmri nẽ kãm kugõ ");
INSERT INTO apnNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","nhũm amnhĩm hamỳ nẽ omu nẽ hkĩnh nẽ. Hãmri nẽ kãm: “Nà ãm hãmri na ka inhmã ho anẽ. Ixte amã ho 5.000 pix nẽ õr tã ka ra inhmã ho rax jakamã kot kaj apê inhmã mẽ àpênh xwỳnhjê hkrãhtũm. E amnẽ ixwỳr axà pu mẽ apku nẽ pahkĩnh.” Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","—Hãmri nhũm hpãnhã kot ho 2.000 nẽ hpyr xwỳnhta hwỳr tẽ nẽ õ patrãwta mã kãm: “E ota akàxporeta. Ate inhmã ho 2.000 pix nẽ õr tã pa amã ho rax nẽ amã hipy axte ho 2.000 nẽ kumẽ. Tã ota.” Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Hãmri nhũm kuma nẽ amnhĩm hamỳ nẽ omu nẽ hkĩnh nẽ. Hãmri nẽ kãm: “Nà ãm hãmri na ka ã inhmã ho rax anẽ. Ixte amã ho 2.000 pix nẽ õr tã ka inhmã ho rax jakamã kot kaj apê inhmã mẽ àpênh xwỳnhjê hkrãhtũm. E amnẽ ajaxwỳja ixwỳr axà pu mẽ apku nẽ pahkĩnh.” Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","—Tã nhũm kot ho 1.000 pix nẽ hpyr xwỳnhta hapu hã wa hkôt tẽ. Hãmri nẽ õ patrãw mã tanhmã kapẽr to nẽ kãm: “Nà ra ixte apumunh tũm. Pẽr axàhkurê pix kãm na ka hte apa. Nẽ amã akàxpore ho rax nẽ anhõ ho rax pix kukamã ajamaxpẽr o ri apa. Nom mẽ pajaja mẽ ixàpênh rax pix kukwak ri na ka hte akàxpore rax nẽ apa. ");
INSERT INTO apnNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Jakamã na pa inhmã apyma nẽ. Nẽ akàxporeta py nẽ ma o tẽ nẽ kaxyw kre nẽ kamã haxà. Tã ka akupỹn mõn pôj pa ajarẽnh ma hãmri nẽ hkapa nẽ man akupỹn amã o tẽ. Tã ota anhõ 1.000ta.” Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","27","Hãmri nhũm tee ri kuma nẽ kãm: “Tk. Kwa amã ixpyma nẽ ate ixpumunh mex anhỹr tã na ka ixte amã kàxpore nhõrta pyr nẽ ma ho atẽm. Nẽ mẽ kot mẽ kêp kàxpore jamỳnh o kuhê xà kamã mẽ kãm õr nhũm mẽ ixkutêp tanhmã inhmã ho rax to hkêt nẽ? Pẽr ãm amã kaga nẽ ate amnhĩ tomnu pix o ri apa xwỳnh.” Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","30","Hãmri nẽ kêp kàxporeta py nẽ nhãm jam kugõ nẽ kãm: “E amỳ nẽ o tẽ nẽ kot inhmã ho 10.000 nẽ õr xwỳnhta mã agõ. Hãmri nẽ jahti pynê nẽ ma o tẽ nẽ kamàt kô kamã amẽ. Apênh mexti hã. Koja tee amỹra nẽ amnhĩ xà htỳx kamã hamak xàj tee ri amnhĩ nham o axpẽn kamnhar tỳx kaprỳ nẽ rĩ amnhĩ pumu.” Anhỹr o kãm kapẽr nhũm kuma nẽ hpa hã kupy nẽ ma o tẽ. Hãmri nhũm mẽ õ patrãwja mẽ àpênh xwỳnhjê mã kãm: “E mẽ ate ixwakre kamã mẽ axàpênh mex xwỳnhjaja kot paj ã mẽ ato mex rax anẽ ka mẽ akĩnh nẽ. Nom mẽ kot inhmã mẽ àpênh mex kêt xwỳnhjaja kot paj mẽ kêp mẽõ mẽmojta jamỳ nẽ nhãm mẽhõm kugõ nhũm hkaprĩ nẽ.” Anẽ. Ã mẽ ujarẽnh kot anhỹr. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Nhũm Jejus arĩ mẽ inhmã kapẽr nẽ mẽ inhmã: —Nẽ kot paj nhỹrmã akupỹn mẽ awỳr wrỳ nhũm Tĩrtũm kapẽr o mẽ wrỳk xwỳnh piitã man ixkôt wrỳ. Kot paj wrỳ nẽ ixpê pahi maati hã ixkrĩ xà maati kamã inhmex nẽ nhỹ. ");
INSERT INTO apnNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","33","Hãmri nẽ Tĩrtũm kapẽr o mẽ wrỳk xwỳnhjê mã anẽ nhũm mẽ ma krĩ piitã hkôt mẽ apiitã mẽ ato pikuprõnh pa nẽ akupỹn ixwỳr mẽ ato hapêx. Pa mẽ apumu nẽ tanhmã mẽ axunhwỳr to. Te ôwêhti jamãr o pa xwỳnh kot ôwêhti kaêx ã motre pumunh nẽ nhãm nê motre xunhwỳr parta pyràk. ");
INSERT INTO apnNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Hãmri nẽ ixupôk rũm mẽ ate ixkôt amnhĩ xunhwỳr xwỳnhjê mã ixkapẽr nẽ mẽ amã: “E mẽ kajaja kot kaj mẽ amex kumrẽx nẽ ri apa ho apa. Amnepêm kormã mẽmoj piitã hkêt ri na pa pre Inhĩpêêxà mẽ wa mẽ akukamã tanhmã ijamaxpẽr to nẽ mẽ amã mẽmoj mex xunhwỳr rũnh nẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Tã ka prem ajapôj hãmri nẽ ixkôt amnhĩ xunhwỳ nẽ tanhmã ixto mex to ho ri apa. Na pa pre inhmã prãm nẽ ixpa ka prem ixpumu nẽ ixkamã axukaprĩ nẽ inhmã mẽmoj gõ pa kuku. Nẽ na pa pre inhmã kôr nẽ ixpa ka prem ja hã ixpumu nẽ inhmã gô pa ho ixkõ nẽ akupỹm ixihtỳx. Nẽ aa mẽ ate ixpumunh kêt tã ka prem nhỹri ixpumu nẽ amnhĩ nhõrkwỹ hwỳr ixwỳ. ");
INSERT INTO apnNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Nẽ na pa pre ixê pynajti nẽ ri ixpa ka prem ja hã ixpumu nẽ inhmã axê gõ pa haxà nẽ ri hã ixpa. Nẽ na pa pre ixà nẽ inhĩkwỹ ka prem ixwỳr mra nẽ ixkane nẽ tanhmã ixto mex to pa akupỹm inhmex. Nhũm prem ijaxà pa mẽ hagjênh xà kamã ixkrĩ ka prem ixwỳr mra nẽ tanhmã ixto mex to. Ã mẽ ate ixto mex anhỹr o ri apa jakamã nhũm inhõ Papajja ixtã mẽ apumu. Tã koja ixtã mẽ ato mex rax nẽ.” Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","—Kot paj ã mẽ ate tãm amnhĩ nhĩpêx xwỳnhjê mã ixkapẽr anẽ. Hãmri ka mẽ tee ri inhma nẽ amnhĩ tã ixkukja nẽ inhmã: “Kwa xà mẽ pajaja na pa prem ã ato mex anẽ? Nà mẽ ixte ã anhĩpêx anhỹr kãm amnhĩ pumunh kêt tã na ka ã mẽ ijarẽnh anẽ. Kwa nhỹri na ka pre amã prãm nẽ apa pa prem apumu nẽ amã mẽmoj gõ ka aku? Nẽ nhỹri na ka pre amã kôr nẽ apa pa prem amã gô hkwỳ ka ho ixkõ? ");
INSERT INTO apnNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Nẽ nhỹri na pa prem apumu nẽ amnhĩ nhõrkwỹ hwỳr awỳ? Rỳ ka pre axê pynajti nẽ apa pa prem amã inhĩnôhkà gõ ka hagjê? ");
INSERT INTO apnNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Nẽ nhỹri na ka pre axà nẽ anhĩkwỹ pa prem apumu nẽ akane? Nẽ nhỹri na prem ajaxà pa mẽ hagjênh xàja wỳr mra nẽ kamã tanhmã ato mex to? Nà mẽ pa hkêt.” Anhỹr o amnhĩ tã ixkukja. ");
INSERT INTO apnNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Hãmri pa mẽ amã: “Nà mẽ kêp amrakati xwỳnhjaja na pre htem pa pyràk. Tã ka prem mẽ kamã axukaprĩ hã tanhmã mẽ kutã anojarêt to ho ri apa jao te pa tanhmã ixto mex to ho apa pyràk. Ãm hãmri na ka prem ã mẽ ho mex anhỹr o ri apa.” Anẽ. Kot paj ã mẽ ate amnhĩ to mex xwỳnhjê mã ixkapẽr anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","—Hãmri nẽ hpãnhã apke rũm mẽ kot ixkôt amnhĩ xunhwỳr kêt xwỳnhjê mã tanhmã ixkapẽr to nẽ mẽ kãm: “No mẽ kajaja kot paj ixupôk rũm mẽ unhwỳr xwỳnhtajê hkĩnhã mẽ ato mex kêt nẽ. Amnepêm na pre Tĩrtũmja Satanasti mẽ mẽ kot tanhmã kãm amnhĩ nhĩpêx to ho mẽ pa xwỳnhjê mẽ mẽ ho hpimrààtã mẽ kaxyw kuwy rax kumrẽxja nhĩpêx. Mẽ kot amnhĩ tomnuj tỳx mỳrapê nhỹrmã kamã amnhĩ xà htỳx kamã hamak rãhã nẽ pa ho pa kaxyw. Tã kot kaj mẽ ajaxwỳja ma mẽ hkôt hwỳr ajapêx. Mẽ apê Satanasti hkôt mẽ ate amnhĩ nhĩpêx o apa xwỳnh jakamã kot kaj mẽ uràn ma hwỳr ajapêx pa. ");
INSERT INTO apnNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Aa mẽ ate tanhmã ixto mex to hkêt. Na ka pre htem inhmã prãm nẽ ixpa hã ixpumu nom inhmã mẽmoj nhõr kêt nẽ. Nẽ inhmã kôr nẽ ixpa hã ixpumu nom inhmã gô hkwỳ hkêt nẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Nẽ nhỹri ahte ixpa hã ixpumu nom amnhĩ nhõrkwỹ hwỳr ixwỳr kêt nẽ. Nẽ ixê pynajre nẽ ixpa hã ixpumu nom inhmã axê nhõr kêt nẽ. Nẽ ixà nẽ inhĩkwỹ hã ixpumu nom ixkane hkêt nẽ. Nẽ mẽ kot ijaxàr nhũm arĩ ixkrĩ hã ixpumu nom ixwỳr amrar nẽ tanhmã ixto mex to hkêt nẽ. Ã mẽ ate inhĩpêx anhỹr o apa jakamã e mẽ ma kuwy hwỳr apa kurê kumrẽx.” Anẽ. Kot paj ã mẽ kãm ixkapẽr anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Hãmri nhũm mẽ tee ri inhma nẽ amnhĩ tã ixkukja nẽ inhmã: “Kwa nà ã mẽ ijarẽnh anhỹr kêt nẽ. Aa mẽ ixte ã anhĩpêx anhỹỹre hã. Nhỹri na pa prem tanhmã akute hã apumu? Nà aa mẽ ixte nhỹri ã ate amnhĩ nhĩpêx anhỹr ã apumunhre hã.” Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","—Koja mẽ ã inhmã amnhĩ tã aprãr anhỹr kaprỳ. Kot paj mẽ kãm: “Nà na ka pre htem mẽ kêp amrakati xwỳnhjê pumu nẽ ãm mẽ omunh o ri apa nẽ mẽ kamã axukaprĩ hkêt nẽ. Ã mẽ hipêx anhỹr jao te pa ã inhĩpêx anhỹr pyràk. Jakamã kwa mẽ tokyx ma kuwy hwỳr ajapêx kurê kumrẽx.” Anẽ. Kot paj ã kuwy hwỳr mẽ hanor anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Hãmri nẽ hwỳr mẽ rẽnh pa nhũm mẽ ma hwỳr hapêx nẽ kamã amnhĩ xà htỳx kãm hamak rãhã nẽ pa ho pa nẽ aa kator kêt kumrẽx. No kêt mẽ ate tãm amnhĩ nhĩpêx o mẽ apa xwỳnhjaja kot kaj mẽ kurom ma Tĩrtũm mẽ wa inhõ krĩ hwỳr api nẽ kamã amex nẽ atĩr tũm nẽ apa ho pa. Kot paj ã ahpỹnhã mẽ apiitã mẽ anhĩpêx anẽ. Anẽ. Nhũm pre ã Jejus akupỹn wrỳk ã amnhĩ kukamã mẽ inhmã ujarẽnh anẽ. Hãmri nẽ mẽ inhmã ujarẽnh pa. ");
INSERT INTO apnNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Tã nhũm Jejus mẽ ixte hkôt ixpa ho ixpa xwỳnhjê mã ujarẽnh pa nẽ mẽ inhmã: ");
INSERT INTO apnNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","—E kot puj mẽ axte pahtã apkati axkrut hãmri nhũm arĩgro pê Pas kato. Jakamã koja mẽ piitã amnepêm Tĩrtũm kot Ejit nhõ xwỳnhjê pê mẽ pakukamã mẽ panhĩgêtjê kator mã hamaxpẽr nẽ hã hkĩnh kaxyw Jerujarẽ hwỳr akuprõ. Kamã koja mẽ ixpynê nẽ pĩ kahpa hã inhô nẽ ixpĩ. Koja mẽ tokyx ã inhĩpêx anẽ. Anẽ. Nhũm pre ã amnhĩ kukamã mẽ inhmã amnhĩ jarẽnh anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Rôm nhũm Jerujarẽ kamã patre krãhtũmjê mẽ Ijaew pigêtjaja patre maati Kajpasja nhõrkwỹ kamã axpẽn wỳr akuprõ. ");
INSERT INTO apnNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","5","Ra mẽ kãm Jejus pĩr prãm tã mẽ kãm mẽ kot hkôt kapẽr mar o pa xwỳnhjê pyma nẽ. Hãmri nẽ tee ri hamaxpẽr nẽ axpẽn mã: —Hêxta waa nẽ. Tanhmã kot puj wem ho nẽ kupĩĩ? Kot puj mẽ pahkĩnh kãm tanhmã ho nhũm mẽ hkĩnh xwỳnhjaja hã mẽ pakamã gryk tỳx nẽ. Pu mẽ hã axpu nẽ hã tanhmã axpẽn to. Jakamã kwa pu mẽ kormã tanhmã ho hkêt nẽ. Anhỹr o axpẽn ma. ");
INSERT INTO apnNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Tã nhũm Jejus kormã krĩ pê Petãn kamã Simãw nhõrkwỹ kamã apkur o nhỹ. Simãwja na pre hkà kro xàpêr tỳx o pa nhũm Jejus ra arĩgro hõ hã akupỹm hkà ho mex. Hãmri nẽ akupỹm õ krĩ hwỳr pôj nẽ õrkwỹ hwỳr tẽ nẽ kuri apkur o nhỹ. ");
INSERT INTO apnNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Hãmri nhũm mẽhõ nija hpôx ã omu nẽ hamaxpẽr o: —Ma koja pẽr Jejusja pa hã apkati grêre hãmri nẽ ty. An pa ma hwỳr tẽ nẽ mẽhkuxwa xà ho hkuxwa. Anẽ hãmri nẽ kẽn jaka ho kàx kãm mẽhkuxwa xàja nhũm kumỳ nẽ ma hwỳr o tẽ. Hãmri nẽ ho hkrã gregrer nẽ hã hkapĩr pa nẽ ho hkuxwa hpa. Mẽhkuxwa xà hã kàxpore xohtô rax tã nhũm ã hã hkapĩr par anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Hãmri pa mẽ ixte Jejus kôt ixpa ho ixpa xwỳnhjaja tee ri ã kot hipêx anhỹr ã omu nẽ axpẽn mã: —Tk. Kwa na hã mẽhkuxwa xàta kapĩr pa. ");
INSERT INTO apnNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Kop apu ma kot o htẽm nẽ ho wẽnê nẽ hpãnhã kàxpore ho rax kumrẽx nẽ hamỳnh nẽ ho mẽ kêp amrakati xwỳnhjê nhĩpêx par o nhỹx ja kãm mex nẽ. Kwa mo na we ã amnhĩ nhĩpêx anhỹr kêt nẽ? Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Hãmri nhũm Jejus amnhĩ tã mẽ inhma nẽ mẽ inhmã: —Kwa kot ixto mex kaxyw kênã na ka mẽ axtem nẽ ixtã kãm akir. ");
INSERT INTO apnNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Mẽ kêp amrakati xwỳnhjaja koja mẽ arĩ mẽ akôt pa rãhã nẽ. Ka mẽ amã mẽmo arĩgro hã tanhmã mẽ ho ajuta hto hprãm nẽ tanhmã mẽ ho ajuta hto nẽ mẽ kãm mẽmoj gõ. No pa kot paj ri mẽ akôt ixpa ka mẽ ixto mex ry ho apa hkêt nẽ. Kot paj tokyx mẽ apiitã mẽ are. ");
INSERT INTO apnNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Ixtyk nhũm mẽ kot ijaxàr kukamã na ã ixkuxwa anẽ. Ãm hãmri na ã inhĩpêx anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","ãm hãmri na pa mẽ amã kot ã inhĩpêx anhỹrja jarẽ. Koja mẽ krĩ piitã hkôt axpẽn mã ijarẽnh ã kagà kamã ijarẽnh o pa nẽ kamã nija kot ã inhĩpêx anhỹr kamã harẽ nẽ kuma. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Tã nhũm Jut Kariotja. Kêp mẽ ixpê Jejus kôt ixpa ho ixpa xwỳnh pê 12 hõ htã ra tanhmã hamaxpẽr to nẽ axtem nẽ Satanasti nhỹ hã ma patre krãhtũmjê hwỳr tẽ nẽ tanhmã Jejus o mẽ mar to nẽ mẽ kãm: ");
INSERT INTO apnNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","—E ot pa mẽ amã Jejus jarẽnh o tẽ. Xà kot paj mẽ amã hã amỹnê ka mẽ hpãnhã inhmã amnhĩre nà? Anẽ. Hãmri nhũm mẽ kuma nẽ hkĩnh nẽ. Hãmri nẽ kãm: —Nà kot paj mẽ amã amnhĩre. Anẽ hãmri nẽ kãm kàxpore ho 30 nẽ õr kurê kumrẽx nhũm hamỳ nẽ hkĩnh nẽ kato nẽ ma tẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Hãmri nẽ mẽ kãm Jejus pynênh kaxyw tãnopxar o ri hkôt ri pa. Mẽ kot mar o ri pa xwỳnhjê hkàx ã unênh nẽ ma mẽ hwỳr o htẽm kaxyw. ");
INSERT INTO apnNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Tã nhũm mẽ hkĩnh pê Pasja kato. Amnepêm kormã Ejit kãm mẽ pa ri na pre mẽ inhĩgêtjaja ôwêhti hkrare hkwỳ hpa nẽ ho anẽ nẽ kuku. Tĩrtũm kot ja hã mẽ omunh nẽ Ejit nhõ xwỳnhjê nê mẽ kator kaxyw nhũm prem ã amnhĩ nhĩpêx anẽ. Tã mẽ ixpê mẽ hkanrẽhã mẽ htàmnhwỳjaja na pa htem arĩ amgrà mẽ arĩgro pê Pasja ã axpẽn wỳr akuprõ nẽ jam ijamaxpẽr pê mẽ uràk nẽ ôwêhti hkrare hkwỳ pa nẽ pãwti kaxkrit kêt kãm kuku. Jakamã pa mẽ ixte Jejus kôt ixpa ho ixpa xwỳnhja wa axkrut nẽ Jejus wỳr tẽ nẽ amnhĩ tã hkukja nẽ kãm: —Kwa nhỹri kot paj we wa tẽ nẽ mẽ akutêp Pas ã mẽ panhõ hã apê? Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Hãmri nhũm wa kãm: —Nà wa mãmrĩ ma Jerujarẽja wỳr wa tẽ. Nẽ krĩm axà nẽ mẽhõ myti pumunh kurê kumrẽx nẽ kãm: “E Jejus na wa inhmẽ pa wa awỳr tẽ. Na awỳr hpẽr mẽnh o: ‘E na pa ra inhnojarêt. Jakamã nhỹri kot paj we ixkôt ri mẽ pa ho mẽ pa xwỳnhjê mẽ Pas ã axpẽn kutã apku?’ Anhỹr o awỳr hpẽr mẽ.” Anẽ. E wa ã kãm akapẽr anẽ kê war ama nẽ war amã õrkwỹ nhĩmõk ã ixkre rax õ jahkre. Kamã ra kaxyw mẽ paxàpkur xà hã mẽmoj piitãã. Ka wa omu hãmri nẽ mãmrĩ mẽ ixkutêp kamã mẽmoj tã apê. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Hãmri nhũm wa kuma nẽ ma Jerujarẽ hwỳr tẽ. Nẽ hwỳr axà hãmri nẽ ra kot wa kãm mẽmoj jarẽnh xà hkôt mẽmoj piitã omu hãmri nẽ mẽ ixkutêp mẽõ hã àpênh o wa xa. ");
INSERT INTO apnNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Tã nhũm kamàt pa mẽ Jejusja kôt ixkreta wỳr ixpôx pa nẽ hwỳr agjê nẽ ixàpkur kaxyw ixkrĩ. Mẽ ixte Jejus kôt ixpa ho ixpa xwỳnhjê pê 12jaja pa mẽ ixpiitã Jejus kutã ixàpkur o ixkrĩ. ");
INSERT INTO apnNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Hãmri nhũm Jejus tanhmã mẽ inhĩõ jarẽnh to nẽ mẽ inhmã: —E pa mẽ amã mẽmoj jarẽ ka mẽ inhma. Kot kaj mẽ atõ mẽ kãm ixkurê xwỳnhjê nhĩhkram ijaxà. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Hãmri pa mẽ tee ri kuma nẽ ixkaprĩ htỳx nẽ. Hãmri nẽ axpẽn pãnhã amnhĩ tã hkukja nẽ kãm: —Kwa xà pa? Nà pa hkêt. Kot paj ã anhĩpêx anhỹr kêt kumrẽx Pahihti. Anhỹr o axpẽn pãnhã kãm amnhĩ tã aprã. ");
INSERT INTO apnNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Hãmri nhũm mẽ inhmã: —Nà ãm hãmri na pa mẽ amã ixkapẽr. Mẽ ate ixkutã guhkrax kãm anhõ pãwti ho mry kagô nhek o akrĩ xwỳnhjê hõ kot kaj mẽ kãm ixtã amỹnê. ");
INSERT INTO apnNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Tĩrtũm kapẽr ã kagà htũm ra kot ixkukamã harẽnh xà hkôt koja mẽ tanhmã ixto rax nẽ ixpĩ. Nom kot mẽ kãm ixtã àmnênh mã xwỳnhta hêxta waa nẽ. Ã kot amnhĩ nhĩpêx anhỹrja mỳrapê koja amnhĩ xà htỳx kãm hamak rax kumrẽx. Kop apu aa õ mãmãj nhõxà hkre rũm kator kêt ronhỹx ja kãm mex nẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Hãmri nhũm Jut Kariot kot mẽ kãm hã àmnênh mã xwỳnhta hãmri amnhĩ tã kuma nẽ kãm: —Kwa xà we pa Jejus? Xà pa kot paj ã anhĩpêx anẽ? Kwa nà pa hkêt. Anẽ. Hãmri nhũm kãm: —Tỳ. Ka ã ate inhĩpêx anhỹr mã kênã. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Tã nhũm Jejus pãwti hõ py nẽ Tĩrtũm mã harẽ nẽ mẽ inhmã ho hkry nẽ ho mẽ inhĩpêx pa nẽ mẽ inhmã: —E na pa ã mẽ amã pãwti ho hkry nẽ mẽ amã õr anẽ. Ja pyrà nẽ koja mẽ ã inhĩpêx anẽ nẽ te ixto hkry hpar pyràk o inhĩpêx pa amnhĩ xà htỳx kamã ijamak kãm ty. Nom mẽ anê kot paj ty. E mẽ mãmrĩ aku. Anhỹr o mẽ inhmã amnhĩ jarẽ pa mẽ kuma nẽ kot mẽ inhmã ho hkry xwỳnhja ku. ");
INSERT INTO apnNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","28","Hãmri nhũm hpãnhã kop py nẽ mã ho anẽ nẽ Tĩrtũm mã harẽ nẽ mẽ inhmã kugõ nẽ mẽ inhmã: —Mẽ kot ixpĩr xà hã arĩgroja ã koja ixkamrô axkapĩ. Nom koja mẽ amarĩ ixpĩr nhũm amarĩ ixkamrô hpikapĩr kêt nẽ. Ãm paa. Pa kot paj mẽ anê mẽ ĩhkram amnhĩ jaxà nhũm mẽ ã inhĩpêx anẽ nẽ ixpĩ. Koja ixkamrô axkapĩ nhũm Tĩrtũm omu nẽ ixkukwak ri mẽ ate ixkôt amnhĩ xunhwỳr xwỳnhjê nê mẽ ate amnhĩ tomnuj piitã te amnhĩ katut kôt rẽnh par pyràk o hipêx nẽ mẽ ato hkra. Ra amnepêm kot ã amnhĩ jarẽnh anhỹr xà hkôt. Jakamã e mẽ ixkamrô pikapĩr mã ajamaxpẽr pê wĩhti ho akõm o axpẽn nhĩpêx. ");
INSERT INTO apnNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","ãm hãmri na pa ã mẽ amã amnhĩ jarẽnh anẽ. Kot paj axte wĩhti ho ixkõm kêt rãhã nhũm nhỹrmã inhõ Papaj akupỹn mẽ awỳr inhmẽ. Hãmri pu mẽ akupỹn ixwrỳk xà hã arĩgrota ã pahkĩnh rax kumrẽx. No ãm axtem tanhmã hã pahkĩnh to. Anẽ. Nhũm pre ã Jejus mẽ inhmã amnhĩ jarẽnh anẽ. Pa mẽ axpẽn pãnhã kopta py nẽ wĩta kwỳ ho ixkõ. ");
INSERT INTO apnNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Hãmri nẽ mẽ ixpiitã ho ixkõm pa nẽ Tĩrtũm mã mex ã gre. Hãmri nẽ ijapôj nẽ hixêt prêk pê Oriwêhti hwỳr ma mra. ");
INSERT INTO apnNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Tã nhũm Jejus tanhmã mẽ ixte hkôt ixpa ho ixpa xwỳnhjê jarẽnh to nẽ mẽ inhmã: —E Tĩrtũm kapẽr ã kagà htũmta kot tanhmã mẽ akukamã mẽ ajarẽnh to nẽ mẽ ajarẽnh kot: Kot paj ôwêhti jamãr o pa xwỳnhja pĩ hãmri nhũm ôwêhti hpigrành pa nẽ ma anhgrà nẽ ri mra. Anhỹr o kot mẽ ajarẽnh. Te ho mẽ apê ôwêhti pyrà nẽ ã mẽ ajarẽnh anẽ. Tã kamàt ja kamã koja mẽ tanhmã inhĩpêx to ka mẽ ixtã mẽ omu nẽ mẽ umaj ôwêhti pyrà nẽ apiitã ixkaga hpa nẽ ma aprõt nẽ mra. ");
INSERT INTO apnNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Nẽ mẽ kot ixpĩr tã kot paj akupỹm ixtĩr. Hãmri nẽ ma akupỹm mẽ akukamã pika pê Garirej wỳr mõ. Kamã kot puj mẽ axte axpẽn pumu. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Hãmri nhũm Simãw Pêtre tee ri tanhmã mẽ kot amnhĩ nhĩpêx to hkukamã amnhĩ jarẽnhja ma nẽ hkaprĩ nẽ kãm: —Tk. Nà kot paj ã amnhĩ nhĩpêx anhỹr kêt nẽ Pahihti. Koja pahkwỳja akaga japêr no pa kot paj aa akaga hkêt nẽ. Kot paj akôt ixpa rãhã nẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Hãmri nhũm Jejus kãm: —Nà ra ixte akukamã ixàhpumunh mex. Koja apkati hkôt krãhyre hkàr kêt ri ka ra mẽ umaj ate ixkôt apa hkêt ã mẽ kãm amnhĩ tã axàprãr o axkrunẽpxi kãm ga. Kwa jam ajamaxpẽr tỳx nẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Hãmri nhũm tee ri kuma nẽ axte kãm: —Kwa nà. Mẽ kot ajaxàr nẽ apĩr tã kot paj arĩ akôt ri ixpa nhũm mẽ pahto amỹrà nẽ tanhmã panhĩpêx to. Nà kot paj aa akaga hkêt nẽ. Anhỹr o kãm amnhĩ jarẽ. Pa mẽ ijaxwỳja ã kãm amnhĩ jarẽnh anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Tã nhũm Jejus mẽ inhmã anẽ pa mẽ ma nhỹri mẽ kot kãm “Gesẽm” anhỹr xwỳnhja wỳr mra. Hãmri nhũm mẽ inhmã: —E mẽ jar ixkutêp akrĩ. Pa ma mũtũm tẽ nẽ Tĩrtũm mã amnhĩ jarẽ mãn. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Hãmri nẽ mẽ ixkwỳjê ho axkrunẽpxi nẽ amnhĩ kôt mẽ kuwỳ. Simãw Pêtre nẽ Jepetew kra pijakrut pê Xiakre nẽ Juãwja wa nhũm amnhĩ kôt mẽ kuwỳ nhũm mẽ ma hkôt mra. Hãmri nhũm Jejus tee ri mẽ kot tanhmã hipêx tota kukamã hamaxpẽr o hkaprĩ nẽ amnhĩ kamã kahak tỳx nẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Hãmri nẽ mẽ kãm: —Hêxta waa nẽ. Na pa tee ri amnhĩ xà htỳx kamã ijamakja kukamã ijamaxpẽr nẽ amnhĩ kamã ixkahak tỳx o ra ixkaprĩ nẽ. Te ixkaprĩ kot ixpĩr o mõr pyràk. Jakamã e mẽ jar anohtỳx nẽ ixto Tĩrtũm wỳr o akrĩ kê tanhmã ixto pa mẽ kot tanhmã ixtoja kutã ixihtỳx nẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Hãmri nẽ mẽ kurũm htẽm grire nẽ Tĩrtũm mã amnhĩ jarẽnh kaxyw htu mỳr pê tẽm nẽ pikap nõ nẽ kãm: —Kwa Papaj. Hêxta waa nẽ. Inhmã amnhĩ xà htỳx kãm ijamak prãm kêt kumrẽx. Na pa tee ri amnhĩ kukamã ijamaxpẽr nẽ amnhĩ kamã ixkahak tỳx nẽ. Jakamã kot kaj amã inhnê ja ho ajapêx prãm nẽ mãmrĩ inhnê ho ajapêx nhũm mẽ kãm ixkurê xwỳnhjaja tanhmã ixto hkêt nẽ. Rỳ ko. Kot kaj amã mẽ kot tanhmã ixto hprãm kê mẽ mãmrĩ tanhmã inhĩpêx to. Nom pam inhmã hprãm xà hkôt kêt. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Hãmri nẽ kànhmã xa nẽ akupỹm Simãw Pêtreja mẽ hwỳr tẽ nẽ tee ri mẽ omu nhũm mẽ ra õt pa nẽ hikwỹ. Nhũm mẽ omu nẽ Simãw Pêtre mã kãm: —Kwa Simãw Pêtre. E mẽ hãmri akrã hapôj. Kwa wem anohtỳx grire ");
INSERT INTO apnNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","nẽ ixkutêp amnhĩ to Inhõ Papaj wỳr o akrĩ kê mẽ ixkôt tanhmã mẽ ato htã ka mẽ amã mẽ uma xàj ixkaga hkêt nẽ arĩ mẽ kutã amnhĩ to htỳx nẽ akuhê. Ã mẽ amã mẽ ate amnhĩ nhĩpêx anhỹr prãm nom kormã mẽ amã maa. ");
INSERT INTO apnNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Anhỹr o mẽ kãm kapẽr hãmri nẽ akupỹm tẽ nẽ axte Tĩrtũm mã amnhĩ jarẽ nẽ kãm: —Kwa Papaj. Nà inhmã amnhĩ xà htỳx kãm ijamak prãm kêt. Na pa amnhĩ kukamã ijamaxpẽr nẽ amnhĩ kamã ixkahak tỳx kumrẽx. Jakamã kot kaj amã inhnê ja ho ajapêx prãm nẽ mãmrĩ inhnê ho ajapêx kê mẽ kãm ixkurê xwỳnhjaja tanhmã ixto hkêt nẽ. Nom ko. Kot kaj amã mẽ kot tanhmã ixto hprãm kê mẽ mãmrĩ tanhmã inhĩpêx to. Nom pam inhmã ja prãm xà hkôt kêt. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Hãmri nẽ kànhmã xa nẽ Simãw Pêtreja mẽ hwỳr akupỹm tẽ. Nẽ mẽ omu nhũm kê mẽ axte gõr nẽ hikwỹ. Ra mẽ õtxwa htỳx nẽ axte gõr nẽ hikwỹ. Nhũm Jejus tẽ nẽ tee ri mẽ omunh o xa ");
INSERT INTO apnNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","nom axte tanhmã mẽ kãm nẽ hkêt nẽ. Ãm awjanã nẽ akupỹm tẽ nẽ kê wam kot Tĩrtũm mã amnhĩ jarẽnh xà hkôt axte kãm amnhĩ jarẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","46","Hãmri nẽ akupỹm mẽ hwỳr tẽ nẽ mẽ kãm: —Kwa xàn ka mẽ arĩ gõr nẽ anhĩkwỹ? E mẽ tokyx akrã hapôj. Na mẽ ra mẽ kot ixwỳr mrar nẽ ixpynênh mã. Koja mẽ tokyx ixkutã mẽ kot amnhĩ xunhwỳr xwỳnhjaja mẽ kãm ixtã amỹnê. Ota ra kot ixtã mẽ kãm àmnênh xwỳnhta tẽ. E mẽ tokyx kànhmã akrĩ pu mẽ kutã mra. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Nhũm Jejus mẽ kãm kapẽr o ãm rãhã nhũm Jut Kariot pê mẽ inhĩõja hwỳr tẽ. Nẽ amnhĩ kôt mẽ ohtô nẽ hwỳr mẽ o tẽ nhũm mẽ wapohti nẽ kô jamỳ nẽ hkôt o mra. Patre krãhtũm mẽ Ijaew krãhtũmjaja kot Jejus wỳr mẽ rẽnh xwỳnhjaja nhũm mẽ man hkôt Jejus wỳr mra. ");
INSERT INTO apnNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Na pre ra Jut Kariot amnhĩ kukamã mẽ kãm amnhĩ jarẽnh o: —Kot paj ixkumrẽx hwỳr tẽ ka mẽ ixkôt hapu hã mra. Kot paj hwỳr tẽ nẽ kãm ixkapẽr nẽ kahti hkôt kumỳ. Ka mẽ hã ixpumu nẽ hwỳr mra nẽ unênh kurê kumrẽx. Ixte kahti hkôt mỳnh xwỳnhta kot kaj mẽ unê. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Hãmri nẽ Jejus wỳr tẽ nẽ kãm: —Pa Jejus? Xàn ka kormã anhõt kêt nẽ xa? Anẽ nẽ kahti hkôt kumỳ. ");
INSERT INTO apnNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Hãmri nhũm amnhĩ tã omu nẽ kãm: —Kwa Jut. Ate tanhmã ixto kaxyw mã xwỳnh jakamã e kam nẽ mãmrĩ tanhmã ixto. Anẽ. Hãmri nhũm Jut kôt mẽ mrar xwỳnhjaja Jut kot kahti hkôt mỳnh ã omu nẽ hwỳr mra nẽ unênh kurê kumrẽx. ");
INSERT INTO apnNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Hãmri nhũm mẽ inhĩõja tee ri ja hã mẽ omu nẽ õ wapo kapa nẽ patre maati mã àpênh xwỳnh kot mẽ hkôt htẽm xwỳnhta mã ho apê. Nẽ kot ho hkrã nhĩpônh mã tã kuhpaw nẽ upôk rũm hamak nhĩkjê pix krãhta. ");
INSERT INTO apnNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Hãmri nhũm Jejus omu nẽ nê kãm kapẽr nẽ kãm: —Kwa akupỹm awapota hkàm haxà nẽ amarĩ xa. Na htem wapo ho mẽ oprê ho pa nhũm mẽ amnhĩ xwar wapo ho mẽ kupa. ");
INSERT INTO apnNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Xà kot paj amnhĩ to Tĩrtũm wỳ nhũm ãm inhma nẽ tanhmã jajê pê ixpytàr to hkêt nẽ? Nà kot paj amnhĩ to kuwỳ nhũm ixwỳr kapẽr o mẽ wrỳk xwỳnhjê rẽnh kurê kumrẽx nhũm mẽ ohtô rax kumrẽx nẽ wrỳ nẽ mẽ kêp ixpytà. ");
INSERT INTO apnNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Nom kot paj ã amnhĩ to hwỳr anhỹr kêt nẽ. Tĩrtũm kapẽr ã kagà htũm kot amnepêm ixkukamã ã mẽ kot inhĩpêx anhỹr ã mẽ harẽnh jakamã kwãr mẽ mãmrĩ Tĩrtũm kãm hprãm xà hkôt ã inhĩpêx anẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Hãmri nẽ hpãnhã mẽ kot unênh xwỳnhjê mã kapẽr nẽ mẽ kãm: —Kwa na pa pre apkati mẽ Tĩrtũm mã amnhĩ jarẽnh xà hã ixkre kamã mẽ kãm ixujarẽnh o ixpa. Ka prem tokyx ixpynênh kêt tã jarãhã te ixte amnhĩ tomnuj xwỳnh pyràk o inhĩpêx nẽ ixwỳr wapohti nẽ kô hã akapẽn nẽ ixwỳr tẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Tã nom ra Tĩrtũm kapẽr ã kagà htũm kamã Tĩrtũm nhỹ hã mẽ kapẽr xwỳnh kot mẽ akukamã mẽ ajarẽnh nẽ mẽ atã kagà xà hkôt na ka mẽ ri ã inhĩpêx anẽ. Anẽ. Nhũm pre ã Jejusja amnhĩ tã mẽ kãm kapẽr anẽ. Hãmri pa mẽ ixte hkôt ixpa ho ixpa xwỳnhjaja mẽ omu nẽ tee ri amnhĩ kukamã ijamaxpẽr nẽ mẽ umaj ixprõt nẽ anhgrà nẽ ma inhmrar kurê kumrẽx. ");
INSERT INTO apnNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Nhũm pre Ijaew krãhtũmjê mẽ Tĩrtũm kapẽr tũm o mẽ ahkre xwỳnhjaja ra patre maati Kajpas nhõrkwỹ hwỳr akuprõ nẽ Jejus kutêp hkrĩ. Hãmri nhũm mẽ kot unênh xwỳnhjaja ma mẽ hwỳr o tẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Hãmri nẽ mẽ hwỳr ho axà nẽ hkôt gjêx pa. Nhũm Simãw Pêtre mẽ hkôt hapu hã mẽ htãnopxar o tẽ nẽ kĩtare hwỳr axà nẽ pôristi nhĩhkô hã nhỹ. Hãmri nẽ tee ri Jejus kukamã hamaxpẽr o nhỹ nẽ hamaxpẽr o: —Kwa tanhmã koja mẽ ixpê mẽ inhõ Pahihti nhĩpêx to? E pa jar amỳm tanhmã mẽ kot hipêx to hã mẽ omunh o nhỹ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Hãmri nhũm patre krãhtũmjê mẽ juistijaja kãm Jejus pĩr prãm tỳx nẽ. Jakamã na prem Ijaew wa ho hamẽxkrut nẽ axpẽn kôt tanhmã mẽ kãm ho hêx to nhũm mẽ kot hã wa mar nẽ ra hpĩr kaxyw mẽ pikuprõnh xwỳnhjê kapi. ");
INSERT INTO apnNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Jakamã nhũm prem axpẽn pãnhã mẽ hwỳr mra nẽ tanhmã ho hêx to. Nom axpẽn kôt harẽnh kêt nẽ. Ãm ahpỹnhã tanhmã ri harẽnh to nom wahõ wa axkrut nẽ axpẽn kôt harẽnh kêt nẽ. Jakamã nhũm mẽ tee ri hã mẽ kuma. Tã nhũm ja wa mẽ hwỳr tẽ nẽ axpẽn kôt harẽ nẽ mẽ kãm: ");
INSERT INTO apnNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","—Nà na pre tanhmã Tĩrtũm mã amnhĩ jarẽnh xà hã ixkre jarẽnh to nẽ harẽnh o: “Kot paj nhỹrmã inhmã ixkreja grành par prãm nẽ kugrà hãmri nẽ ãm ixtã apkati axkrunẽpxi pix nẽ akupỹm hipêx pa. Ja kaxyw ixàhpumunh tỳx.” Anhỹr o na amnhĩ jarẽ pa wa kuma. ");
INSERT INTO apnNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Anhỹr o mẽ kãm ho hêx. Hãmri nhũm patre maatija wa kuma nẽ kànhmã xa nẽ Jejus mã kapẽr nẽ kãm: —Kwa xà ãm hãmri na wa ã ajarẽnh anẽ nà? Xàn ka pre ã amnhĩ jarẽnh anẽ? E mẽ inhmã tanhmã amnhĩ jarẽnh to. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Nom nhũm amarĩ mẽ kãm xa nẽ mẽ kãm tanhmã nẽ hkêt nẽ. Hãmri nhũm patre maatija tee ri omu nẽ axte kãm kapẽr nẽ kãm: —Kwa aprĩ hã mẽ inhmã tanhmã amnhĩ jarẽnh to. Tĩrtũm noo mã amã ixkapẽr jakamã kêr ka akatàt kôt mẽ inhmã amnhĩ jarẽ nẽ amnhĩ to axêx kêt nẽ. Xà apê Tĩrtũm Kra? Xà ka na pre Tĩrtũm mẽ ixkaxyw axãm? Kwa akatàt kôt mẽ inhmã amnhĩ jarẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Hãmri nhũm tã hprĩ hã mẽ kãm amnhĩ jarẽ nẽ mẽ kãm: —Tỳ. Nà ãm hãmri na ka ã ijarẽnh anẽ. Ixpê Tĩrtũm kot mẽ akaxyw ixãm xwỳnhta na pa. Na pre mẽ awỳr inhmẽ pa mẽ awỳr wrỳ. Tã kot paj nhỹrmã axte kaxkwa rũm amnẽ akupỹn kakrã kamã mẽ awỳr wrỳ. Hãmri nẽ Tĩrtũm xàhpumunh o àhpumunh xwỳnhta nhĩhkô hã nhỹ hãmri nẽ pam tanhmã mẽ ajarẽnh to ka mẽ amnhĩ tã ixpumu nẽ inhma. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Hãmri nhũm patre maatija tee ri ã kot amnhĩ jarẽnh anhỹr ã kuma nẽ kamã gryk tỳx nẽ. Hãmri nẽ gryk xàj kêp patre maati hã ê kapa nẽ hkaxônh pa nẽ kumẽ nẽ hkwỳjê mã kãm: —Tk. Kwa mo kaxyw kot puj mẽ axte ri tanhmã kot amnhĩ tomnuj to hã harẽnh xwỳnh õ japêr? Tãm kot amnhĩ pê Tĩrtũm Kra hã amnhĩ jarẽnh ã amnhĩ to hêx nhũm mẽ pahte mar kênã. ");
INSERT INTO apnNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Jakamã e kwa tanhmã kot puj mẽ hipêx to? Anẽ. Hãmri nhũm mẽ kãm: —Nà ã kot amnhĩ jarẽnh anhỹr mỳrapê koja ty. Ra htyk mã tãm kênã. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Hãmri nẽ tanhmã hipêx kati hto. Mẽ hkwỳjaja hkuk kuhtô nẽ ĩhkra ho htak nhũm mẽ hkwỳjaja ĩhkra hpo ho htak nẽ hã hpẽr o axkẽ nẽ kãm: ");
INSERT INTO apnNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","—E apê Tĩrtũm Kra hã ate amnhĩ jarẽnh jakamã mãn uràk nẽ axàhpumunh tỳx. Jakamã e mẽ kot atak xwỳnhta nhĩxi jarẽ pa mẽ ama. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Rôm nhũm Simãw Pêtre arĩ kĩtare kamã nhỹ. Hãmri nhũm mẽ kãm àpênh xwỳnh nitita omu nẽ hprĩ hã omunh kurê kumrẽx. Hãmri nẽ kãm: —Xê pẽr apê Jejus kôt mẽ pa xwỳnhjê hõ na ka. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Hãmri nhũm tee ri amnhĩ tã kuma nẽ kãm mẽ uma xàj mẽ kãm amnhĩ tã aprã nẽ kãm: —Tk. Kokỹ. Ixte mẽhõ my ata pumunhre hã. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Hãmri nẽ mẽ umaj kànhmã xa nẽ tẽ nẽ kĩtare hwỳr hakwakrem ahte mẽ hkàx ã xa. Tã nhũm hpãnhã hõja omu nẽ hã mẽ kãm: —Xê ma pẽr ãm hãmri na mẽ harẽ. Kêp Jejus kôt ri mẽ pa xwỳnhjê hõ na pẽr. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Hãmri nhũm amnhĩ tã kuma nẽ kãm: —Tk. Nà mẽ ri ã amnhĩ krã hkôt ri ixto axêx anhỹr kêt nẽ. Ixte aa mẽhõta pumunh kêt kumrẽx. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Tã nhũm mẽ hkwỳjaja hwỳr mra nẽ kãm kapẽr nhũm tanhmã mẽ kãm kapẽr to nhũm mẽ kuma nẽ kãm: —Kwa pẽr ãm hãmri na mẽ ajarẽ. Apê Jejus kwỳ na ka. War akapẽr kot axpẽn pyràk kênã. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Hãmri nhũm tee ri mẽ kuma mẽ kãm amnhĩ tã àprãr kãm hihtỳx nẽ mẽ kãm: —Kwa nà. Na pa Tĩrtũm noo mã mẽ amã amnhĩ jarẽ. Kot paj amnhĩ to ixêx japêr nhũm inhma nẽ hã tanhmã ixto. Nà uràk ixpê Garirej nhõ xwỳnhre hã. Ixte mẽhõ mũj pumunh kêt kumrẽx tã ka mẽ xatã axpẽn kôt ixte hkôt ixpa ho ixpa xwỳnh ã ixkamnhĩx o xa. Anhỹrja o ra mẽ kãm amnhĩ tã aprãr o axkrunẽpxi nhũm krãhyre hkàr kurê kumrẽx. ");
INSERT INTO apnNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Hãmri nhũm Simãw Pêtre kuma nẽ ra Jejus kot hkukamã krãhyre hkàr kêt ri kot hã amnhĩ aprãr o axkrunẽpxi hã harẽnhta mã hamaxpẽr kurê kumrẽx. Hãmri nẽ kànhmã hakry hpar o tẽ nẽ hkaprĩ htỳx kumrẽx nẽ kĩtare pê kato nẽ tẽ nẽ awry hã xa nẽ mỳr rax nẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Tã nhũm ra myt kator o mõr mẽ nhũm mẽ hkrãhtũmjê mẽ patre krãhtũmjaja axpẽn wỳr pikuprõnh pa. Hãmri nẽ Jejus ã axpẽn mar o hkrĩ nẽ axpẽn mã: —Nà kot puj mẽ hã amỹnê kê mẽ kupĩ. Kêp Tĩrtũm Kra hã kot amnhĩ jarẽnh o amnhĩ to hêx kênã. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Hãmri nẽ mẽõ pôristijê mã anẽ nhũm mẽ hpa hpre hpa nẽ ma pahihti Pirat wỳr o tẽ. Pirat kêp Rõm nhõ pahihti nhỹ hã mẽ ixpê Ijaewjê ho amnhĩptàr jakamã nhũm mẽ ma hwỳr o tẽ nẽ ĩhkram haxà. ");
INSERT INTO apnNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Rôm nhũm Jut Kariot tee ri mẽ kot Jejus pĩr kaxyw mẽ harẽnh ma nẽ hkaprĩ nẽ. Ra kot mẽ kãm hã àmnênh tã mẽ kot hpĩr kaxyw ã mẽ harẽnh ma nẽ tee ri amnhĩ kukamã hamaxpẽr o hkaprĩ htỳx nẽ. Hãmri nẽ hamaxpẽr o: —Hêxta waa nẽ. Mo na pa pre ri axtem nẽ ã amnhĩ nhĩpêx anẽ? Nà na pa pre amnhĩ tomnuj tỳx kumrẽx. Anẽ. Hãmri nẽ ra mẽ kot kãm kàxpore ho 30 nẽ õrta jamỳ nẽ ma akupỹm patre krãhtũmjê mẽ Ijaew pigêtjê hwỳr o tẽ. Hãmri nẽ mẽ kot Tĩrtũm mã amnhĩ jarẽnh xà hã ixkreja wỳr mẽ hwỳr axà ");
INSERT INTO apnNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","nẽ nhỹri mẽ omu nẽ mẽ hwỳr tẽ nẽ mẽ kãm: —E ota mẽ akàxporeta. Na pa ã mẽ amã Jejus ã ixàmnênh anhỹrja o amnhĩ tomnuj tỳx nẽ. Kot tãm amnhĩ nhĩpêx o pa htã pa axtem nẽ ã mẽ amã hã ixàmnênh anẽ. Jakamã e mĩ. Mẽ akupỹm akàxporeta jamỳ. Kot paj amnhĩm hamỳnh kêt nẽ. Anẽ. Hãmri nhũm mẽ tee ri kuma nẽ kãm: —Kokỹ. Nom ka na ka pre mẽ ixwỳr tẽ nẽ ho mẽ inhmar kênã. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","7","Hãmri nhũm tee ri mẽ kuma hãmri nẽ pikap kàxpore rẽnh pa nẽ ma tẽ nẽ kato. Hãmri nẽ hkaprĩ htỳx kumrẽx nẽ hamaxpẽr o: —Kwa tanhmã kot pa we amnhĩ to? Nà kot paj amnhĩ pĩ. Anẽ. Hãmri nẽ krĩ pê kato nẽ ma mẽ kot pika kakwỳnh nẽ ho amnhĩm poti nhĩpêx xà hã pika hwỳr tẽ hãmri nẽ amnhĩ mut mã ê nẽ ho amnhĩ pĩ. Hãmri nhũm patre krãhtũmjaja harẽnh ma nẽ tee ri kot kàxpore rẽnhta kawrà nẽ hã axpẽn kukja nẽ axpẽn mã: —Kwa tanhmã kot puj wem ja ho? Jut kot mẽ pamã Jejus ã àmnênh nhũm mẽ pahte hpĩr xà hã kàxpore na. Jakamã kot puj mẽ ho Tĩrtũm mã amnhĩ jarẽnh xà hã ixkre ho mex kêt nẽ. Finat Mojes kot ja nê mẽ panhĩgêtjê kurê jakamã na htem mẽ hpar xà hã kàxpore ho ixkreta ho mex kêt nẽ. Jakamã kwa tanhmã kot puj mẽ ho? Anẽ. Hãmri nhũm ja mẽ kãm: —E na pa ra ijamaxpẽr. Pu mẽ ho Jut kot amnhĩ pĩr xà hã pikata japrô hãmri nẽ kamã jar mẽ kêp mẽ pahkwỳ hkêt htyk xwỳnhjê jagjênh o papa. Anẽ. Hãmri nhũm mẽ kuma nhũm ja mẽ kãm mex nẽ. Jakamã nhũm arĩgro hõ hã nhũm mẽ ma hwỳr mra nẽ haprô. ");
INSERT INTO apnNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Hãmri nẽ hã hixi mẽ nhũm kêp “mẽ hkamrô pikapĩr xà kamã pika”. Mẽ kot Jejus pĩr xà hã kàxpore ho haprôr jakamã nhũm prem ã hã hixi mẽnh anẽ. Nhũm htem arĩ axpẽn mã ã hixi jarẽnh anhỹr o pa. ");
INSERT INTO apnNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","10","Nhũm pre ra amnepêm Tĩrtũm nhỹ hã kapẽr o pa xwỳnh finat Jeremĩsti mẽ hkukamã hprĩ hã ja jarẽ nẽ hã kagà. Nẽ hã kagà o: Koja Ijaew nhõ patrejaja mẽhõ kot mẽ kãm mẽhõ my hã àmnênh pãnhã kãm kàxpore ho 30 nẽ õr xwỳnhja jamỳ. Hãmri nẽ ma o tẽ nẽ nhỹri mẽ kot amnhĩm pika kakwỳnh nẽ ho poti nhĩpêx o pa xà hã pika hkwỳ japrô. Ra Tĩrtũm kot inhmã mẽ harẽnh xà hkôt koja mẽ ã amnhĩ nhĩpêx anẽ. Anẽ. ã finat Jeremĩsti kot Tĩrtũm nhỹ hã mẽ hkukamã mẽ harẽnh nẽ hã kagà anhỹr xàja kôt nhũm prem ã amnhĩ nhĩpêx anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Rôm nhũm mẽ pahihti Pirat wỳr Jejus o tẽ nẽ hwỳr ho axà nẽ kutã ãm nhũm xa nhũm Piratja omu nẽ kãm: —E. Kwa inhmã amnhĩ jarẽ. Xà apê Ijaew nhõ pahi na ka nà? Xà ka na htem amnhĩ wỳr ajamãr o pa? Anẽ. Hãmri nhũm kãm: —Tỳ. Nà ãm hãmri na ka ijarẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Hãmri nhũm mẽ hkrãhtũmjê mẽ patre krãhtũmjaja pahihti Pirat mã tanhmã ho kapẽr punuj to. Nhũm amnhĩ tã mẽ kuma nom tanhmã kãm amnhĩ tã àprãr to hkêt nẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Jakamã nhũm pahihti Pirat tee ri ja hã omu nẽ kãm: —Kwa xà na ka ã mẽ kot ato kapẽr anhỹrja mar kêt nẽ nà? ");
INSERT INTO apnNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Anhỹr tã nom nhũm Jejus akryk xa nẽ axte tanhmã kãm nẽ hkêt nẽ. Hãmri nhũm Pirat tee ri kot ã amnhĩ nhĩpêx anhỹr ã omu nẽ hamaxpẽr o: —Kokỹỹ. Mẽ kot ho kapẽr punuj tã nhũm ãm mẽ kuma nẽ te kãm mẽ uma hkêt pyrà nẽ tanhmã inhmã amnhĩ tã àprãr to hkêt nẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","21","Tã nhũm Pirat kormã mẽ kot axpẽn mar xà hã ixkre kamã ỹr rãhã nhũm hprõja hwỳr hpẽr mẽ nẽ kãm: —Xê tanhmã mẽ kãm Jejusja ã axàmnênh to hkêt nẽ. Na pa kamàt ja kamã hkôt amỹti nẽ tee ri hkukamã ijamaxpẽr. Kot amnhĩ to mex xwỳnh na. Aa tanhmã kot amnhĩ tomnuj to hkêt jakamã xê tanhmã mẽ kãm hã axàmnênh to hkêt nẽ. Kwarĩ. Anẽ. Hãmri nhũm Piratja kuma nẽ hamaxpẽr o: —Nà ixte Ijaew krãhtũmjê pumunh tũm. Ijaew kwỳjaja kãm Jejus kĩnh nhũm mẽ hkrãhtũmjaja kot mẽ hã Jejus kamã gryk nẽ. Jakamã ixte tanhmã mẽ kãm hã ixàmnênh to kaxyw na mẽ ã ixwỳr o htẽm anẽ. Anẽ. Na htem Pas nhõ arĩgrota hapôx mẽ nhũm pre htem Ijaew o amnhĩptàr xwỳnhja mẽ kãm mẽ hagjênh xà kamã hkrĩ xwỳnhjê ho hpỹnh nẽ mẽ hapôj. Mẽ kãm hprãm xà hkôt nhũm mẽ kãm mẽ hapôj nhũm mẽ akupỹm kapôt ã hamakêtkati nẽ amnhĩx pa. Jakamã nhũm ra mẽ hagjênh xà kamã mẽhõ my pê Parapasja hkrĩ. Na pre tanhmã amnhĩ tomnuj to nhũm mẽ mỳrapê unê nẽ haxà. Jakamã nhũm Ijaewjaja mẽ ho amnhĩptàr xwỳnh Pirat wỳr akuprõ nẽ kuhê nhũm mẽ kãm: —E kot paj jarãhã mẽ amã mẽ hagjênh xà kamã mẽ hkrĩ xwỳnhjê hõ mã inhũre kê àmnhĩx kato nẽ ri pa. Nhỹ kot paj mẽ amã kãm inhũre? Xà Parapas nà? Xà mẽ akwỳ kot amnhĩm ho mẽ anhõ pahihti Jejus pê Tĩrtũm kot mẽ akaxyw ãm xwỳnhta kot paj mẽ amã kãm inhũre? Nhỹ wehe? E mẽ inhmã nhỹ jarẽ. Anẽ. Pirat na pre mẽ inhõ patre krãhtũmjê pumunh mex nẽ. Ijaew kãm Jejus kapẽr mar prãm tỳx ã nhũm mẽ hã kamã gryk tỳx nẽ hwỳr o mrarja kôt nhũm mẽ omunh mex nẽ. Jakamã ã hã mẽ hkukjêr anẽ. Hãmri nhũm mẽhpigêt mẽ patre krãhtũmjaja kuma hãmri nẽ mẽ pikuprõnh nẽ mẽ kuhê xwỳnhjê mã kãm: —Kwa mẽ kãm anẽ kê mẽ pamã Parapas mã mãn ure nẽ mãmrĩ Jejus Kris pĩ. E kwa mẽ tokyx kãm anẽ kê Parapas mã ure. Anẽ. Hãmri nhũm mẽ mẽ kuma nẽ pahihti Pirat mã kãm: —Nà mẽ inhmã Parapas mã mãn anhũre. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Hãmri nhũm tee ri mẽ kuma nẽ mẽ kãm: —Kwa no mẽ ate Jejus pê Tĩrtũm kot mẽ akaxyw ãm xwỳnh ã harẽnh xwỳnhta? Tanhmã kot paj hipêx to? Anẽ. Hãmri nhũm mẽ kãm: —Apĩ ri. Tokyx pĩ kahpa hã anhô kê ty. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Hãmri nhũm tee ri mẽ kuma nẽ mẽ kãm: —Tk. Kwa nà. Tanhmã kot amnhĩ tomnuj tore hã kot pa kêt ri pĩ kahpa kunhô nhũm ty. Anẽ. Hãmri nhũm mẽ xatã àmra kamã kãm: —Kwa pĩ kahpa hã mãn anhô kê ty. Kwa tokyx ã mẽ inhmã hipêx anẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Hãmri nhũm tee ri ja nê tanhmã mẽ kãm kapẽr to no nhũm mẽ mar kêt nẽ. Nhũm tee ri mẽ àmra mar o xa. Hãmri nẽ kãm Jejus pĩr prãm kêt jakamã amnhĩm gô hkwỳ janhi nẽ mẽ piitã mẽ noo mã amnhĩ nhĩhkra kuhõnh o xa. Mẽ kot hã omunh xà hkôt kãm hpĩr prãm kêt ã omunh kaxyw. Hãmri nẽ mẽ kãm: —E na pa mẽ anoo mã ã amnhĩ nhĩhkra kuhõnh anẽ ka mẽ ja hã ixpumu. Nà inhmã hpĩr prãm kêt. Tanhmã kot amnhĩ tomnuj tore hã. Mẽ kaxipixjaja mẽ amã hpĩr hprãm jakamã mẽ kam nẽ tanhmã ho. No pa kot paj tanhmã ho hkêt nẽ. Ãm kwarĩ ho kwarĩ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Hãmri nhũm mẽ kuma nẽ kãm: —Tôe. Nà ãm hãmri. Kot paj mẽ pamjaja amnhĩ tã htykja nhô. Nẽ mẽ ixkra nẽ mẽ ixtàmnhwỳjê mẽ amnhĩ to ixpimrààtã amnhĩ tã kunhô. Kê Tĩrtũm kãm tanhmã hã mẽ ixtõ hto hprãm nẽ mamrĩ tanhmã hã mẽ ixtõ hto. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Hãmri nhũm mẽ kuma nẽ mẽ kãm hprãm xà hkôt mẽ kãm Jejus ã amỹnê nẽ mẽ kãm Parapas mã ure. Ra Parapas kot pahi Pirat pê õ pôristi kutã amnhĩ xãm nẽ kêp hõxpĩrja mỳrapê nhũm mẽ kot unênh nẽ haxàr tã Ijaew kãm hprãm xà hkôt akupỹm kãm ure. Hãmri nẽ õ pôristijê mã anẽ nhũm mẽ Jejus tak. Nẽ htak rax nẽ hãmri nhũm Pirat mẽ kãm hã amỹnê nhũm mẽ kot pĩ kahpa hã nhôr o hpĩr kaxyw ma o tẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Tã nhũm pôristijaja mẽ kot pĩ kahpa hã Jejus nhôr kaxyw ma o tẽ nẽ pahihti Pirat nhõrkwỹ kamã ixkre hõ hwỳr ho axà. Nhũm pôristi ohtô nẽ hwỳr akuprõ nẽ hã pẽr o pikẽnh kaxyw axpẽn mã: —E kwa tokyj pu mẽ kãm pahi xê jaxà ri. Kêp pahi hã kot amnhĩ jarẽnh kênã. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Hãmri nẽ kêp ê kapa nẽ hpãnhã kêp pahi hã mẽ ê kamrêk mexja py nẽ kãm haxà. ");
INSERT INTO apnNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Nẽ kãm pahi hã mẽ ahkà nhĩpêx nẽ hkrãm haxà. Nom axtem akunĩ kamã mẽmo mrô nhĩ te kot ronh kanêre pyràk xwỳnhja nhũm mẽ hikãx nẽ hkrãm haxà. Nẽ kãm pahi hã kô gõ nhũm kupy nẽ o xa. Hãmri nhũm mẽ ho anhỹr pa nẽ kutã hkõn krã ho rôrôk nẽ hkrĩ hpa nẽ hã pẽr o pikẽnh kamã kãm: —E ãm hãmri. Apê Ijaew nhõ pahi punuti na ka. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Hãmri nẽ kànhmã kuhê nẽ hkuk kuhtô nẽ kêp kô pytà nẽ xatã ho hkrãx pê htak. Nhũm prem ã pẽr o pikẽnh kãm hipêx anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Hãmri nẽ kêp pahi hã ê kapa nẽ akupỹm kãm ê jaxà nẽ mẽ kot pĩ kahpa hã nhôr kaxyw ho kato nẽ ma o tẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Nhũm pôristijaja Jejus o kato nẽ ma kapôt mã o tẽ. Nẽ kãm pĩ kahpa pytĩja gõ nhũm kumỳ nẽ mẽ hkôt o hkwỳ. Nom ra hirot tỳx nẽ nhũm mẽ tee ri ja hã omu nẽ mẽhõ kot ho ajuta kaxyw mẽ kot omunh xwỳnhjê kapi ho xa. Hãmri nẽ Sirẽn nhõ xwỳnh Simãw kà htyk pumu nẽ unê nẽ kãm kot Jejus o ajuta kaxyw hã karõ nhũm hwỳr tẽ nẽ kêp pĩ kahpata mỳ nẽ hkôt kãm kumỳ nẽ o tẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Hãmri nhũm mẽ kẽn nhĩxêt te kot mẽ hkrã hi pyràk xwỳnhta wỳr mẽ o pôj. Mẽ kapẽr kãm na prem hixêtja jarẽnh o: “Korkot.” No mẽ pakapẽr kãm Korkot jarẽnhja kêp “mẽ hkrã hi xà” nhũm mẽ ma hwỳr Jejus o pôj. ");
INSERT INTO apnNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Hãmri nẽ mẽ kot pĩ kahpa hã nhôr kaxyw nhũm à htỳx kumrẽx kamã hamak pymaj kãm mẽmo mẽ hkanexàja gõ. Wĩhti mẽ mẽmo mry ma xà ho pihkàr nhũm mẽ kãm hkwỳ gõ. Nom nhũm hkaki nẽ mẽ kot amnhĩ xà htỳx kamã hamak kêt xà hã omunh kurê kumrẽx nẽ hkaga. Nhũm mẽ tee ri ja hã omu hãmri nẽ kêp ê kapa nẽ kumẽ nẽ pĩ kahpa hã kuxi nẽ prek o ĩhkra nẽ hpar o htỳx pa. Hãmri nẽ kànhmã pĩ jarĩ nẽ ahkre kamã ãm nẽ ho htỳx nhũm kỳxpê ajêt. ");
INSERT INTO apnNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Hãmri nhũm pôristi hkwỳjaja axpẽn mã ê hkwỳ ho pigrành kaxyw hã kẽnre ho jôka. ");
INSERT INTO apnNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Hãmri nẽ ho anhỹr pa nẽ pikap Jejus jamãr o hkrĩ. ");
INSERT INTO apnNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Na htem mẽ hpar kaxyw nẽ tanhmã mẽ kot amnhĩ tomnuj to hã kagà nẽ mẽ mỳri pĩ kahpa hã hanhô. Jakamã na prem tapti hõ py nẽ tanhmã Jejus ã kagà hto nẽ hã kagà ho: IJAEW NHÕ PAHI NA JA HIXI PÊ JEJUS Hãmri nẽ hwỳr ho api nẽ mỳri kunhô. Ã Jejus kot amnhĩ jarẽnh anhỹrja mỳrapê na prem kupĩ. ");
INSERT INTO apnNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Hãmri nhũm mẽ hpãnhã wa àhkĩnh xwỳnh wa ho axkrut nẽ mããnẽn pĩ kahpa hã wa kunhô. Nẽ akutã ho Jejus nhĩjê nhũm war ajêt. ");
INSERT INTO apnNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Tã nhũm pry hã mẽ mrar xwỳnhjaja Jejus pumu nẽ hã hpẽr o pikẽnh o mra nẽ kãm: ");
INSERT INTO apnNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","—Kwa ka na ka pre ate Tĩrtũm mã amnhĩ jarẽnh xà hã ixkre grành par nẽ atã apkati axkrunẽpxi nẽ akupỹm hipêx par ã amnhĩ jarẽ. Nẽ apê Tĩrtũm Kra hã amnhĩ jarẽ. Nẽ axàhpumunh o axàhpumunh jakamã e kwa amnhĩ kapa nẽ wrỳ pa mẽ ja hã apumu. Kwa tokyx. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Nẽ patre krãhtũmjê mẽ Tĩrtũm kapẽr tũm o mẽ ahkre o mẽ pa xwỳnh mẽ mẽ hkrãhtũmjaja piitã hwỳr mra nẽ hã hpẽr o axkẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Nẽ axpẽn mã harẽnh o: —E jahti na xep pre mẽ kamã ukaprĩ ho pa nẽ tanhmã mẽ ho ajuta hto ho pa. Tã nom tãm tanhmã amnhĩ to nẽ wrỳk kêt nẽ. Kwa pu mẽ arĩ pakuhê nẽ kot amnhĩ kaxàr nẽ wrỳk kãm omu. Koja wrỳ pu mẽ omu nẽ kêp mẽ panhõ pahihti hã hkôt pajamaxpẽr kurê kumrẽx. E tokyx wrỳ Jejus. Pa mẽ awrỳk kãm apumu. Nà kot kaj awrỳk rax nẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Na hte amnhĩ kaxyw Tĩrtũm mã hamaxpẽr o pa. Nẽ kêp Kra hã amnhĩ jarẽnh o pa. Jakamã e. Kê Tĩrtũm tãm hwỳr tẽ nẽ kêp Kra hã akupỹm mẽ pahpê utà. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Hãmri nhũm wa kot akutã hijê nẽ jêt xwỳnhta wa haxwỳja mẽ mar xà hkôt mã ho kapẽr anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Tã nhũm kaxkwa nhĩpôk ri myt ỹr mẽ nhũm te kamàt pyràk nhũm kamàt kô rax kumrẽx. Jao hã awry mẽ nhũm ra akupỹm myt katêr o mõ. ");
INSERT INTO apnNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Hãmri nhũm Jejus kapẽr kãm hihtỳx nẽ àmra htỳx kãm Tĩrtũm mã kapẽr nẽ kãm: —Inhõ Tĩrtũm inhõ Tĩrtũm. Kwa mon ka ixkaga? Anẽ. Nom kapẽr kamã kãm kapẽr o: —Eri Eri. Rãmã sapatanĩ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Hãmri nhũm mẽ kot mar xwỳnhjaja kot Eri jarẽnh ã kuma nẽ htỳx ho finat Eris mã kapẽr ã hkamnhĩx. ");
INSERT INTO apnNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Nhũm Jejus par pê guhkrax kãm wĩhti punure xa. Jakamã nhũm mẽ ã kapẽr anhỹr ã kuma nhũm mẽhõ kãm hkaprĩ nẽ. Hãmri nẽ mẽmo rerek py nẽ o tẽ nẽ kaxyw pĩ rytija py nẽ ho hkanhwỳ. Nẽ akupỹn o tẽ nẽ ho wĩhti nhek nẽ Jejus kot hkaôr kaxyw kãm kupẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Hãmri nhũm hkwỳjaja tee ri ja hã omu nẽ nê kãm kapẽr nẽ kãm: —Tk. Kwa nhãm xa. Pu mẽ kop Eris jamã mãn. Koja hwỳr tẽ nẽ ho wrỳk japêr. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Hãmri nhũm kamàt kô mẽ nhũm Jejus ra htyk kaxyw nẽ axte àmra htỳx nẽ hãmri nẽ ty. ");
INSERT INTO apnNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Tykja kôt nhũm Tĩrtũm mã amnhĩ jarẽnh xà hã ixkre kamã hakwakre hã kupẽxêja kỳj rũm ahpar mã axkjê nẽ amnhĩ kahê xà mẽnh kurê kumrẽx. Utĩ rax tã axkjê nẽ amnhĩ kahê xà mẽ. Te Jejus htyk o te kot mẽ pahte hkôt amnhĩ xunhwỳr xwỳnhjê mã Tĩrtũm wỳr pry jakwa kre kahê xà mẽnh pyràk o ã amnhĩ nhĩpêx anẽ. Nhũm pika htertet tỳx kumrẽx o kẽn rũnh kwỳ ohtô nẽ hkrakrak pa. ");
INSERT INTO apnNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Hãmri nhũm mẽ htyk ã pika kamã mẽ htykjê nhõrkwỹ ho ohtô nẽ mẽ hã axkjê nhũm mẽ hikwỹ xwỳnhjaja akupỹm htĩr nẽ hapôj nẽ kuhê. Na prem kormã htyk kêt ri amnhĩ kaxyw Tĩrtũm kôt hamaxpẽr. Tã nhũm Jejus ty nhũm mẽ ohtô nẽ akupỹm htĩr nẽ hapôj nẽ kuhê. ");
INSERT INTO apnNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Nom kormã nhỹhỹm mrar kêt nẽ. Arĩ mẽ hã pika nhĩpy Jejus akupỹm htĩr ã hamãr o kuhê. Tã nhũm Jejus apkati hõ hã akupỹm htĩr ã arĩgrota ã nhũm mẽ rĩ kormã ma Jerujarẽ hwỳr mra nẽ hwỳr agjê nhũm mẽ ohtô nẽ akupỹm mẽ htĩr ã mẽ omu. ");
INSERT INTO apnNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Nhũm kormã Jejus htyk o mõrta ã nhũm pôristi krãhtũm mẽ pôristi hkwỳjaja hãmri hparpê hamãr o kuhê nẽ htyk kãm omu. Nẽ pika htertet kamã ama nẽ mẽmoj kot tanhmã amnhĩ nhĩpêx toja pumu nẽ tee ri hamaxpẽr nẽ kãm ma htỳx kumrẽx. Hãmri nẽ axpẽn mã: —Hêxta waa nẽ. Pẽr ãm hãmri na pre htyk xwỳnhta amnhĩ jarẽ. Kêp Tĩrtũm Kra kênã. Tã pu mẽ amarĩ pahtỳx kupĩ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","56","Nhũm pre mẽnijaja ohtô nẽ amỳm Jejus tyk kãm omunh o kuhê. Marir Matarẽn nẽ Xiakre mẽ Juje wa katorxà Marir nẽ Xiakre hõ mẽ Juãw wa katorxàja nhũm mẽ kormã htyk kãm omunh o kuhê. Na prem Garirej rũm hkôt tanhmã ho ajuta hto ho hkôt Jerujarẽ wỳr mõ. ");
INSERT INTO apnNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Tã nhũm ra myt grire nhũm krĩ pê Arimatej rũm hikàxpore rax xwỳnh pê Jujeja tẽ. Nom axtem Juje hõ na pre. Ra kot Jejus kôt amnhĩ xãm jakamã kãm ho wrỳk nẽ haxàr prãm nẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Hãmri nẽ ma pahi Pirat wỳr tẽ nẽ ĩ hã kuwỳ nẽ kãm: —E ot pa awỳr tẽ. Kwa inhmã htyk xwỳnhta gõ pa ma o tẽ nẽ haxà nà? Anẽ. Hãmri nhũm kuma nẽ kãm harẽ nhũm ma o tẽ nẽ haxà. ");
INSERT INTO apnNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Kaxyw kupẽxê mex õ py nẽ ho hkupu pa ");
INSERT INTO apnNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","nẽ ma o tẽ nẽ õ kẽn kre kamã haxà. Na pre htyk kukamã kẽn kre kakwỳ nhũm mẽ kot kormã kamã mẽhõ jaxàr kêt tã kamã na pre Jejus jaxà. Hãmri nẽ hã kẽn rax õ xãm nẽ ho hitom nẽ ma akupỹm tẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Nhũm Marir Matarẽn mẽ Marir õja wa kẽn kreta kapem omunh o wa nhỹ. ");
INSERT INTO apnNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Tã nhũm apkati nhũm mẽ inhõ arĩgromnu pê sap kato. Hãmri nhũm Parijew nhõ xwỳnhjê mẽ patre krãhtũmjaja ma pahi Pirat wỳr mra nẽ kãm: ");
INSERT INTO apnNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","—Kwa pahihti. Nà amnhĩ to hêx o pa xwỳnhta na pre kormã htĩr nẽ pa ri tanhmã amnhĩ jarẽnh to ho pa. Nẽ nhỹrmã ty nẽ htyk ã apkati axkrunẽpxi pix nẽ akupỹm htĩr ã amnhĩ jarẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Jakamã kwa hwỳr anhõ pôristi hkwỳ rẽ kê mẽ ma hwỳr mra nẽ hamãr mex o apkati axkrunẽpxi. Kot ka anhỹr kêt nhũm hkôt mẽ pa ho mẽ pa xwỳnhjaja ma hwỳr mra nẽ ho ahkĩ nẽ ma o mra nẽ nhỹri haxà nẽ mẽ piitã mẽ kãm ra akupỹm htĩr ã harẽnh o hêx o pa. Te tãm kot amnhĩ kukamã amnhĩ jarẽnh pyràk. Nom mẽ kot axte ã harẽnh anhỹrja koja omnuj tỳx o tãm kot ã amnhĩ jarẽnh anhỹrja jakre. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Hãmri nhũm mẽ kuma nẽ mẽ kãm: —Tôe. Nà koja mẽ ho anẽ. E mẽ ma hwỳr amnhĩ kôt pôristi hkwỳ ho mra kê mẽ hakwakre kahê xà jamãr mex o kuhê. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Hãmri nhũm mẽ kuma nẽ ma hwỳr mra nẽ hakwakre hã kẽn raxta o htỳx pa. Nẽ mẽhõ kot omunh nẽ kahê mẽnh pymaj menh ê ho hkukõ. Hãmri nẽ ho anhỹr pa nẽ pôristi mã kãm: —E Kêr ka mẽ jar kuri hamãr mex o akuhê. Kê mẽhõ tẽ nẽ tanhmã ho hkêt nẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Tã nhũm apkati nhũm tômĩk. Hãmri nhũm Marir Matarẽn mẽ Marir õja kwỳhtã kànhmã nhỹ nẽ ma akupỹm kẽn kreta wỳr wa tẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Puh nhũm pika htertet tỳx nẽ nhũm Tĩrtũm kapẽr o mẽ wrỳk xwỳnhja kẽn kre wỳr wrỳ nẽ nhãm hakwakre nê kẽn raxta mẽ nẽ hã nhỹ. ");
INSERT INTO apnNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Hirã htỳx kãm nhỹ. Te na jaxênh pyràk. Nẽ ê haka htỳx kumrẽx. ");
INSERT INTO apnNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Nhũm pôristijaja tee ri omu nẽ kãm ma htỳx nẽ htertet nẽ umaj pikap rôrôk pa nẽ te htyk pyrà nẽ hikwỹ. ");
INSERT INTO apnNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Hãmri nhũm wa nita kẽn kre hwỳr pôj nẽ tee ri Tĩrtũm kapẽr o mẽ wrỳk xwỳnhta pumu. Nhũm wa kãm: —Kwa wa amã ma hkêt nẽ. War ate Jejus pumunh kaxyw na ka wa tẽ. Mẽ kot pĩ kahpa hã nhôr xwỳnhta. ");
INSERT INTO apnNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Nom jar amrakati. Na ra akupỹm htĩr nẽ kato nẽ ma tẽ. E wa kam nẽ amnẽ axà nẽ nõr xà kaprỳ pumu. Anẽ. Hãmri nhũm wa kuma nẽ tee ri kẽn kre kamã Jejus japêr nhũm kamã amrakati. ");
INSERT INTO apnNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Hãmri nhũm Tĩrtũm kapẽr o wrỳk xwỳnh wa kãm: —E wa tokyx ma akupỹm tẽ nẽ hkôt mẽ pa ho mẽ pa xwỳnhjê mã harẽ. Koja ma Jejus mẽ akukamã akupỹm Garirej wỳr mõ. Garirej kamã kot kaj mẽ axte axpẽn pumu. Ra kot mẽ amã amnhĩ jarẽnh xà hkôt. E kwa wa tokyx ma akupỹm mẽ hwỳr tẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Hãmri nhũm wa kuma nẽ ma akupỹm hprõt nẽ htẽm kurê kumrẽx. Kãm ma htã hkĩnh nẽ. Nẽ ma Jejus kôt mẽ pa ho mẽ pa xwỳnhjê mã ujarẽnh kaxyw ma mẽ hwỳr hprõt nẽ wa tẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Pu nhũm ra Jejus tãm wa kutã tẽ nẽ wa hkaxpa. Hãmri nẽ wa haêr pê wa kãm kapẽr nẽ wa kãm: —Pa? Nhỹhỹm na ka wa tẽ? Anẽ. Hãmri nhũm wa omu nẽ hkĩnh tỳx kumrẽx nẽ hwỳr hprõt nẽ hpar pê hkõn krã ho tẽm nẽ akutã hpar ã kumỳ nẽ kãm mex o mex ã harẽ nẽ kãm: —Hêxta gàà nẽ. Ma amex kumrẽx. Amex o amex. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Hãmri nhũm wa kãm: —E war amã ma hkêt nẽ. Mamrĩ ma tẽ nẽ ixkôt mẽ pa ho mẽ pa xwỳnhjê mã ijarẽ kê mẽ ma Garirej wỳr mra. Kamã kot paj mẽ axte axpẽn pumu. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Rôm nhũm pôristi hkwỳjaja akupỹm tãm hkrã hãmri nẽ ma kẽn kreta rũm akupỹm krĩm mra. Hãmri nẽ patre krãhtũmjê hwỳr mra nẽ mẽ kãm ujarẽnh pa. ");
INSERT INTO apnNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Hãmri nhũm mẽ tee ri mẽ kuma nẽ mẽhpigêtjê ho akuprõ nẽ mẽ hã axpẽn mar o hkrĩ. Hãmri nẽ axpẽn mar pa nẽ pôristi mã amnhĩrer rax nẽ mẽ kãm: ");
INSERT INTO apnNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","—E mẽ amnhĩm kàxpore jamỳ nẽ ma ri ã mẽ kãm amnhĩ jarẽnh anhỹr o apa. Nom kêr ka mẽ kãm amnhĩ to axêx nẽ mẽ kãm: “Na pa prem kẽn kre kapem ixtỳx gõr nẽ inhĩkwỹ nhũm Jejus kôt mẽ pa ho mẽ pa xwỳnhjaja mra nẽ mẽ ixpê ĩ ho ahkĩ nẽ ma o mra.” Anhỹr o mẽ kãm amnhĩ to axêx o apa. Mẽ ixte kàxpore ho mẽ amã amnhĩrerta pãnhã. ");
INSERT INTO apnNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Koja pahihti Piratja mẽ anhõt ã mẽ ajarẽnh ma nẽ hã tanhmã mẽ ato kaxyw hã kot paj mẽ axy pê tanhmã kãm ixkapẽr to nhũm tanhmã mẽ ato hkêt nẽ. Jakamã e. Mẽ tee ri amnhĩ kukamã ajamaxpẽr kêt nẽ. Mẽ mãmrĩ ma mra nẽ ã mẽ kãm axujarẽnh anhỹr o ri apa. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Hãmri nhũm mẽ kuma nẽ mẽ kot amnhĩ to hêxta pãnhã kàxpore jamỳ nẽ ma mẽ mar xà hkôt mẽ piitã mẽ kãm Jejus kôt mẽ pa xwỳnhjê ho hêx o pa. Tã na htem arĩ jarãhã Ijaewjaja ã axpẽn mã mẽ harẽnh anhỹr rãhã ho pa. ");
INSERT INTO apnNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Tã pa mẽ ixte Jejus kôt ixpa ho ixpa xwỳnh pê 11jaja hãmri akupỹm Jejus htĩr ã harẽnh ma hãmri nẽ ma Garirej wỳr mra. Nhỹri Jejus kot mẽ inhmã mẽmo hixêt prêk jarẽnhja wỳr. ");
INSERT INTO apnNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Nẽ ra hwỳr ixpôx o mrar mẽ Jejus pumu. Tã nom nhũm mẽ ixkwỳjaja tee ri omu nẽ htỳx ho nhãm mẽhõ hã hkamnhĩx. No kêt mẽ pajaja na pa prem ixprĩ hã omunh kurê kumrẽx nẽ ixkĩnh tỳx nẽ. Nẽ ixkĩnh nẽ hwỳr ixprõt nẽ kãm: —Pa Jejus? Hêxta waa nẽ. Amex o amex. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Hãmri nhũm mẽ inhmã: —E na pre Tĩrtũm ã inhmã kapẽr anẽ nẽ inhmã: “E kêr ka amnhĩ nhỹ hã mẽmoj piitã tanhmã ho ho apa. Kaxkwa kamã nẽ pika kamã. Mamrĩ nhỹhỹm amnhĩ krã hkôt amã tanhmã amnhĩ to hprãm xà hkôt tanhmã amnhĩ nhĩpêx to ho ri apa.” Anẽ. Na pre mẽ akaxyw ã inhmã kapẽr anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","—Jakamã e. Kêr ka mẽ ma pika piitã hkôt ri mẽ kãm ijarẽnh o ri apa. Kê mẽ ixte mẽ nê tanhmã amnhĩ nhĩpêx to hã ijarẽnh ma hãmri nẽ ixkôt amnhĩ xunhwỳ nẽ ixkôt ri amnhĩ nhĩpêx o pa. Nẽ kêr ka mẽ ja hã mẽ omu nẽ Tĩrtũm mẽ wa inhmã mẽ hkrã kumrã. Wa ixkarõ nhỹ hã mẽ hkrã kumrã. Mẽ kot wa inhỹ hã pix mã tanhmã amnhĩ nhĩpêx to ho pa kaxyw. ");
INSERT INTO apnNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","—Nẽ mẽ kãm anẽ kê mẽ ixkapẽr piitã hkôt amnhĩ nhĩpêx rãhã ho pa. E kêr ka mẽ ma mẽ kãm ã ijarẽnh anhỹr o ri mẽ hkôt apa. Kot paj mẽ anhĩhkô hã ri ixpa rãhã nhũm nhỹrmã pikaja hapêx o hapêx. Anẽ. Na pre ã Jejus mẽ inhmã mẽ ixàpênh ã karõ anẽ. Matêwre kot Jejus jarẽnh nẽ hã kagàja ja kôt na hapêx.");
INSERT INTO apnNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Pa Kris kôt ixkràmnhwỳjaja. E kot paj mẽ amã tanhmã Jejus kot amnhĩ nhĩpêx to ho pa hã kagà ka mẽ kamã harẽ nẽ ama. Kêp Tĩrtũm Kra na. Tãm na pre mẽ pakaxyw ãm nẽ mẽ pahwỳr kumẽ. Tã tãm kot mẽ pahwỳr wrỳk nẽ tanhmã amnhĩ nhĩpêx to ho paja kot paj mẽ amã ixprĩ hã harẽ nẽ hã kagà ka mẽ kamã harẽ nẽ ama. ");
INSERT INTO apnNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Kormã Jejus mẽ pahwỳr wrỳk xwỳj ri na pre Tĩrtũm nhỹ hã kapẽr o pa xwỳnhjê hõ pê Ijaisja kukamã tanhmã harẽnh to nẽ hã kagà. Nẽ Jejus kukamã harẽnh o mõr xwỳnh Juãw Paxisja nhũm pre mããnẽn hkukamã tanhmã harẽnh to nẽ hã kagà. Te Tĩrtũm tãm hamaxpẽr pyràk o harẽ nẽ harẽnh o: E kot paj Ixkra hkukamã ma mẽ hwỳr kot harẽnh xwỳnhjê hõmẽ kê ma kutêp mẽ kãm harẽnh o ri pa. Kê mẽ kuma nẽ kutêp tãm amnhĩ nhĩpêx mex o pa. ");
INSERT INTO apnNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Koja kukamã harẽnh xwỳnhja ma kapôt ã ri hwỳr mẽ mrar xwỳnhjê mã harẽnh o ri pa. Nẽ kỳx pê mẽ kãm kapẽr nẽ mẽ kãm: “E mẽ inhma. Koja Tĩrtũm tokyx mẽ pahwỳr mẽ panhõ Pahihti mẽ nhũm wrỳ pu mẽ pahpiitã omu. Jakamã kwa mẽ tokyx kutêp tãm amnhĩ nhĩpêx. Te ho mẽ kot mẽhõ kutêp pry ho mex pyràk o amnhĩ nhĩpêx. Nom pry kumrẽx o mex kêt nẽ. Ãm amnhĩ nhĩ ho tãm amnhĩ nhĩpêx nẽ tãm axpẽn nhĩpêx. Pahihtita kutêp. Mẽ pahte amnhĩ nhĩpêx tũmja te kot pry nhĩnur nẽ krã hakỳx nẽ pry juk nhũm mẽ tee ri kot kãm hã mrar mex prãm kaprỳ pyràk. Jakamã kot kaj mẽ Pahihti nyw kutêp ate amnhĩ tomnuj kaga nẽ tãm amnhĩ nhĩpêx nẽ tãm axpẽn nhĩpêx. Hãmri nẽ te mẽ kot pry nhĩnur o mex nẽ ho katàt nhũm ra katàt mux nẽ nõr pyràk o amnhĩ nhĩpêx. E kwa kêr ka mẽ ã kutêp amnhĩ nhĩpêx anẽ.” Anhỹr o koja mẽ kãm harẽnh o pa. Anẽ. Na pre ã Tĩrtũm Juãw Paxis kukamã harẽnh anẽ nhũm ỹ hã kapẽr xwỳnh pê Ijaisja mẽ pamã hã kagà. ");
INSERT INTO apnNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Tã ra kot harẽnh xà hkôt nhũm Juãw Paxisja tẽ. Hãmri nẽ kapôt ã ri mẽ kãm Tĩrtũm kapẽr jarẽnh o pa nẽ mẽ kãm: —Kwa mẽ tokyx amnhĩ tomnuj kaga nẽ tãm ri amnhĩ nhĩpêx. Kê Tĩrtũm ja hã mẽ apumu nẽ mẽ anê mẽ ate amnhĩ tomnuj rênh pa nẽ mẽ ato hkra. Pa mẽ piitã mẽ kot ra mẽ apê hkra hã mẽ apumunh kaxyw mẽ akrã kumrã. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Hãmri nhũm mẽ ohtô nẽ kot kapẽr mar kaxyw ma nhỹhỹnh hwỳr kapôt mã mra. Pyka pê Jutej rũm nẽ Jutej kamã krĩ pê Jerujarẽ rũm nhũm mẽ ohtô nẽ hwỳr mra. Hãmri nẽ nhỹri omu nẽ kãm: —E ixte amnhĩ tomnuj kaga hprãm xàj na pa awỳr amnhĩ to tẽ. Na pa hte amnhĩ tomnuj pix o ri ixpa. Tã tee ri ja hã amnhĩ pumu nẽ ixkaprĩ nẽ. Hãmri nẽ ra inhmã amnhĩ tomnuj kaga nẽ tãm amnhĩ nhĩpêx prãm nẽ. Anhỹr ã amnhĩ jarẽ. Hãmri nhũm Tĩrtũmja kaxkwa kamã hkrĩ htã mẽ kuma nẽ amnhĩ katut kôt mẽ kot amnhĩ tomnuj piitã rẽnh pa nẽ axte kãm hamaxpẽr kêt nẽ. Jakamã nhũm Juãw Paxis gôx kãm mẽ hkrã kumrã. Pyhti pê Jotãw kamã. ");
INSERT INTO apnNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Juãw Paxisja hikàxpore hkêt jakamã na pre ê mex kêt nẽ pa. Ãm mẽmo mry pê kamer kĩ ho amnhĩm ê nhĩpêx nẽ hagjê nẽ hã pa. Nẽ mẽmo mry hkà ho amnhĩ pre nẽ ri pa. Nẽ mẽõ mex kur kêt nẽ ãm krit ku nẽ menh ôr o ri pa. ");
INSERT INTO apnNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Hãmri nẽ mẽ kãm tanhmã Jejus jarẽnh to ho pa nẽ mẽ kãm: —E mẽ inhma. Koja tokyx Tĩrtũm kot mẽ pakaxyw ãm xwỳnhta mẽ pahwỳr wrỳ. Ahpumunh tỳx o kot ijakrenh jakamã na pa hte ãm kukwak ri ixpa nẽ amnhĩ tã hã ixpijaàm rãhã ho ri ixpa. Te ixkràm ã ixpijaàm o amnhĩ nhĩpêx pyràk. ");
INSERT INTO apnNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Na pa hte gô pix o Tĩrtũm mã mẽ akrã kumrãr o ri ixpa. Nom mẽ pahwỳr wrỳk mã xwỳnhja koja mẽ awỳr Tĩrtũm Karõ rẽ nhũm mẽ akaxwỳnh mã agjê. Ka mẽ ỹ hã tãm ri amnhĩ nhĩpêx rãhã ho ri apa. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Tã nhũm Jejusja tãm Juãw Paxis wỳr tẽ. Garirej kamã krĩ pê Najare rũm ma hwỳr tẽn pôj. Hãmri nhũm Juãwja hkrã hkumrã. Pyhti pê Jotãw kamã hkrã kumrã. ");
INSERT INTO apnNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Hãmri nẽ wa gôj rũm api nẽ mỳr ri kaxkwa pumunh o xa. Nhũm kaxkwa axkjê nhũm kurũm Tĩrtũm Karõ te tuuti pyrà nẽ Jejus wỳr wrỳk o tẽ nẽ ĩkre hã xa nhũm amnhĩ tã omunh o xa. ");
INSERT INTO apnNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Hãmri nhũm Tĩrtũm kaxkwa rũm kãm kapẽr nẽ kãm: E apê Ixkra mex na ka. Ãm hãmri na ka hte ixkanrẽhã amnhĩ nhĩpêx mex o apa. Inhmã ajapê kamã na ka ri apa ho apa. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Tã nhũm Tĩrtũm Karõja ma kapôt mã Jejus o mõ ");
INSERT INTO apnNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","nhũm kapôt ã mry xoprê kaêx ã ri mrar o hã arĩgro pê 40. Hãmri nhũm Satanasti omu nẽ ma hwỳr tẽ nẽ ri hkôt pa. Kapôt ã ri hkôt hêx rom tanhmã kãm kapẽr to nhũm kot mar nẽ hkôt amnhĩ xãm prãm xàj ma hkôt pa. Nom nhũm Jejus hkaga kumrẽx nhũm tee ri ho anhỹr kaprỳ nẽ ma akupỹm tẽ. Hãmri nhũm Tĩrtũm kapẽr o mẽ wrỳk xwỳnhjaja Jejus wỳr wrỳ nẽ tanhmã ho mex to. ");
INSERT INTO apnNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Nhũm pre ra mẽ ixpê Ijaew o amnhĩptàr xwỳnh pê Eroxja Juãw Paxis kot mẽmoj tã kãm àkjêr mỳrapê nhũm pre ra unê nẽ haxà. Tã kot haxàr jakành pê nhũm Jejus ma akupỹm pyka pê Garirej wỳr mõ nẽ kamã mẽ kãm Tĩrtũm kapẽr jarẽnh o pa. Nẽ Tĩrtũm kot mẽ hwỳr mẽnh ã amnhĩ jarẽnh o pa. Nom te nhãm mẽhõ jarẽnh pyràk o amnhĩ jarẽ ");
INSERT INTO apnNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","nẽ mẽ kãm: —E na Tĩrtũm kãm mẽ ato hkra hprãm nẽ. Jakamã na ra kot mẽ awỳr ãm xwỳnhta mẽ nhũm mẽ awỳr wrỳ. Kwa mẽ tokyx kapẽrja ma nẽ amnhĩ kaxyw hkôt ajamaxpẽr. Hãmri nẽ ate amnhĩ tomnuj kaga nẽ Tĩrtũm kôt mãn amnhĩ nhĩpêx o ri apa. Kot kaj mẽ ã amnhĩ nhĩpêx anẽ nhũm Tĩrtũm amnhĩ tã mẽ apumu nẽ mẽ ato hkra. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Tã nhũm Jejus ma Garirej kamã gô rax pê Garirej mỳri mõ. Hãmri nẽ Simãw mẽ htõ Andreja wa hwỳr kato nẽ wa omu. Wa kot tep pynênh xwỳnh jakamã na pre wa gôx kãm kryhti rẽnh o xa nhũm Jejus wa hãnh tẽ nẽ wa omu. ");
INSERT INTO apnNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Hãmri nẽ amnhĩ kôt wa kuwỳ nẽ wa kãm: —E war amnẽ ixkôt tẽ nẽ ixkôt mãn apa. War apê tep kanhêr rax o ri apa xwỳnh tã kêr ka war axàpênhta kaga nẽ hpãnhã ixkôt apa ho apa. Kot paj tanhmã war akrã hto ka wa tep pynênh pãnhã ma ri mẽ hkôt mẽ kãm ixkapẽr jarẽnh o ri apa. Mẽ ohtô nẽ mẽ kot war amar nẽ Tĩrtũm kôt amnhĩ xunhwỳr kaxyw. Jao kot kaj te war ate tep kanhêr rax nẽ Tĩrtũm mã õr pyràk o amnhĩ nhĩpêx. Anhỹr o wa kãm kapẽr. ");
INSERT INTO apnNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Hãmri nhũm wa kuma nẽ kryhti kaga nẽ ma hkôt pa ho pa kurê kumrẽx. ");
INSERT INTO apnNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Hãmri nẽ mẽ gô mỳri mõ nẽ Jepetew kra Xiakre mẽ htõ Juãw wa hwỳr kato nẽ wa omu. Nhũm wa kormã hipêêxà nhĩhkô hã pàr kãm kryhti ho mex o wa nhỹ nhũm Jejus wa mẽ hwỳr kato nẽ wa omu nẽ amnhĩ kôt wa kuwỳ. ");
INSERT INTO apnNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Hãmri nhũm wa kuma nẽ ma hkôt pa ho pa. Pàr kre kamã mẽ kãm àpênh xwỳnhjê ri hipêêxà re nẽ ma Jejus kôt pa ho pa. ");
INSERT INTO apnNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Hãmri nhũm Jejus mẽ hkôt mẽ pa ho mẽ pa xwỳnhjaja ma krĩ pê Kapanaũ hwỳr mõ hãmri nẽ hwỳr pôj. Hãmri nhũm mẽ ixpê Ijaewjê nhõ arĩgromnu pê sap kato nhũm Jejus ma Tĩrtũm kapẽr o mẽ ahkre xà hã ixkre hwỳr tẽ nẽ hwỳr axà. Hãmri nẽ kamã mẽ kot Tĩrtũm kapẽr mar kaxyw axpẽn wỳr mẽ pikuprõnh xwỳnhjê jahkre ho nhỹ. ");
INSERT INTO apnNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Nẽ mẽ ahkre mex nhũm mẽ kuma nẽ tee ri hamaxpẽr nẽ axpẽn mã: —Hêxta waa nẽ. Pẽr ãm hãmri na ã mẽ pamã mẽmoj jarẽnh anẽ. Tĩrtũm kapẽr tũm o mẽ ahkre xwỳnhjê rom àhpumunh tỳx kôt na hprĩ hã mẽ pajahkre mex nẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Hãmri nhũm mẽhõ myja mẽ hwỳr axà. Na pre ra mẽkarõmnuti hwỳr axà nhũm ỹ hã amnhĩ tomnuj o pa. Hãmri nẽ mẽ hwỳr axà nẽ Jejus pumu nẽ kãm kapẽr. Nom tãm kapẽr kêt nẽ. Mẽkarõmnuti nhỹ hã kãm kapẽr. Kàx pê kãm kapẽr nẽ kãm: ");
INSERT INTO apnNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","—Pa Jejus? Kwa tanhmã mẽ ixto hkêt nẽ. Ixte apumunh mex. Apê Najare nhõ xwỳnh tã mããnẽn apê Tĩrtũm kot mẽ ixwỳr amẽnh xwỳnh maati na ka. Tĩrtũm rũm na ka pre mẽ ixwỳr wrỳ. Kwa xà kot kaj mẽ ixto ajapêx nà? Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Hãmri nhũm kãm: —Tk. Kwa anhĩkrê nẽ myta kurũm akator kurê kumrẽx. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Hãmri nhũm kuma nẽ àmra htỳx kãm myja o àk tỳx nẽ kêp kato nẽ ma tẽ nhũm akupỹm mex. ");
INSERT INTO apnNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Hãmri nhũm mẽ piitã omu nẽ kamã no pyma nẽ. Hãmri nẽ xatã axpẽn mã harẽnh o pa nẽ axpẽn mã: —Kokỹỹ. Jejus na pre àhpumunh tỳx kôt mẽkarõmnuti jano nhũm kuma nẽ mẽ kurũm hapôx kurê kumrẽx. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Hãmri nhũm Garirej kamã mẽ piitã ri axpẽn mã harẽnh o pa. ");
INSERT INTO apnNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Tã nhũm Jejus Xiakre mẽ Juãw mẽrohã Tĩrtũm kapẽr o mẽ ahkre xà hã ixkre rũm kato nẽ ma Simãw mẽ Andre wa õrkwỹ hwỳr mõ. ");
INSERT INTO apnNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Hãmri nẽ mẽ hwỳr agjê. Nhũm Simãw xupãnhgêxja ra à nẽ hkà kagro htỳx nẽ nõ nhũm Jejus mẽ hwỳr axà nhũm mẽ kãm harẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Hãmri nhũm mẽ kuma nẽ hwỳr axà nẽ omu nẽ hpa hã kupy nẽ kànhmã ỹr nhũm hkà hakry nẽ akupỹm mex kurê kumrẽx. Hãmri nẽ kànhmã xa nẽ tẽ nẽ mẽ kãm mẽmoj nhĩpêx nhũm mẽ hkur o hkrĩ. ");
INSERT INTO apnNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","33","Tã nhũm myt axà nhũm mẽ ohtô nẽ Simãw mẽ Andre wa õrkwỹ hwỳr mra nẽ hakwakrem Jejus ã akuprõ. Nẽ amnhĩ kôt mẽ à xwỳnhjê ho mra. Nẽ mẽkarõmnuti kot mẽ hwỳr gjêx xwỳnhjaja nhũm mẽ hwỳr mẽ o mra. ");
INSERT INTO apnNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Hãmri nhũm Jejus mẽ omu nẽ akupỹm ahpỹnhã mẽ piitã mẽ ho mex pa. Nẽ mẽkarõmnutija nhũm mẽ kurũm mẽ hapôj. Mẽkarõmnuti kot kêp Tĩrtũm Kra hã omunh tã no nhũm kapẽr nê mẽ hkurê nẽ mẽ hano nhũm mẽ kapẽr kêt rãhã mẽ kurũm hapôj nẽ ma mra. ");
INSERT INTO apnNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Tã nhũm apkati nhũm kormã myt kator kêt ri nhũm Jejus kànhmã nhỹ nẽ tẽ nẽ kato. Hãmri nẽ ma kapôt ã ahte nhỹhỹm tẽ nẽ nhỹri Tĩrtũm mã amnhĩ jarẽnh o nhỹ. ");
INSERT INTO apnNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Hãmri nhũm Simãw Pêtre mẽ hkwỳjaja hkrã hapôj nẽ tee ri ixkre kamã hapêr. Hãmri nẽ hapôj nẽ ma hpry jakop o mõ. ");
INSERT INTO apnNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Hãmri nẽ hwỳr kato nẽ omu nẽ kãm: —Pa. Kwa na mẽ piitã tee ri ajapêr. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Hãmri nhũm mẽ kãm: —Tô ma pu mẽ mõ. Nom kot puj mẽ akupỹm mẽ hwỳr pamõr kêt nẽ. Kot puj mẽ hpãnhã nhãm krĩ hkwỳ hkôt mãn ri pajapôj. Pa kamã mẽ kãm Tĩrtũm kapẽr jarẽ mãn. Ja kaxyw na pre mẽ awỳr inhmẽ. Krĩ piitã hkôt mẽ pa xwỳnhjaja kot kapẽr mar kaxyw. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Hãmri nẽ mẽ ma axte Garirej kamã krĩ hkwỳ hkôt pa. Nẽ krĩ piitã hkôt Tĩrtũm kapẽr o mẽ ahkre xà hã ixkre kamã mẽ kãm Tĩrtũm kapẽr jarẽnh o pa. Nẽ mẽ kurũm mẽkarõmnuti japôx o pa. ");
INSERT INTO apnNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Tã nhũm mẽhõ hkà hkro xàpêr tỳx xwỳnhja Jejus wỳr tẽ. Hãmri nẽ hã hpijaàm kaxyw kutã hkõnkrã ho tẽm nẽ nhỹ nẽ kãm: —Pa Pahihti. E ot pa awỳr amnhĩ to tẽ. Akupỹm ate mẽ ixto mex kaxyw axàhpumunh tỳx jakamã kot ka akupỹm amã ixto mex prãm nẽ mãmrĩ akupỹm ixto mex. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Hãmri nhũm kuma nẽ kamã ukaprĩ nẽ hã ĩhkra xi nẽ kãm: —Nà kot paj ato mex. E akupỹm akà mex. ");
INSERT INTO apnNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Anhỹrja kôt nhũm akupỹm hkà mex kurê kumrẽx. ");
INSERT INTO apnNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","Hãmri nhũm Jejus kãm kapẽr kãm hihtỳx nẽ hano nẽ kãm: —E kêr ka amnhĩ tã akwỳjê mã tanhmã ijarẽnh to hkêt rãhã ma patre hwỳr tẽ kê akupỹm akà mex ã apumu. Hãmri ka amnepêm Mojes kot mẽ ate akupỹm mẽ amex ã Tĩrtũm mã tanhmã amnhĩ nhĩpêx to hã karõ xwỳnhta ka kãm ho anẽ. Kê mẽ piitã akupỹm akà mex ã apumu. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Hãmri nhũm kuma nẽ ma tẽ. Nom axtem nẽ ma mẽ piitã mẽ kãm amnhĩ jarẽnh o ri mra. Jejus kot kãm karõ xà kuhpa hã ma mẽ kãm amnhĩ jarẽnh o ri mra. Jakamã nhũm mẽ kuma nẽ piitã nhỹhỹnh Jejus wỳr mra. Mẽ ohtô rax kumrẽx nẽ hwỳr mra nhũm tee ri mẽ noo mã nhỹri krĩm pa mã. Hãmri nẽ ãm krĩ pu hã ri pa htã nom nhũm mẽ arĩ ohtô nẽ hwỳr mra. ");
INSERT INTO apnNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Tã nhũm Jejus hã apkati grêre nẽ hkôt mẽ pa ho mẽ pa xwỳnhjê mẽrohã ma akupỹm Kapanaũ wỳr mõ. Hãmri nẽ hwỳr pôj nhũm mẽ piitã nhỹri mẽhõ nhõrkwỹ kamã hpôx kôt harẽnh ma nẽ hã akuprõ. ");
INSERT INTO apnNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Ra hã pikuprõnh rax nẽ ixkre nhĩtom pa. Nhũm mẽ hkwỳjaja kapôt ã kuhê nhũm Jejus Tĩrtũm kapẽr o mẽ ahkre ho nhỹ. ");
INSERT INTO apnNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Hãmri nhũm mẽmyjaja kêp kwat nẽ ĩ kamã htyk xwỳnhja mỳ nẽ Jejus kot ho mex kaxyw hwỳr o tẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Hãmri nẽ tee ri hã mẽ pikuprõnh rax xwỳnhjê pumu nẽ nhỹhỹnh kot hwỳr o àr kaxyw tee ri amnhĩ kukamã ho ukapi ho pa. Hãmri nẽ hamaxpẽr nẽ ixkre nhĩmõk po hwỳr ho api nẽ himõk kwỳ grà nẽ hkôt ĩ kamã htyk xwỳnhta nõr xà mẽrohã hkôt Jejus wỳr haxà. ");
INSERT INTO apnNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Hãmri nhũm mẽ kot kaxyw kãm hamaxpẽr tỳx ã mẽ omu nẽ ĩ kamã htyk xwỳnhta mã kapẽr nẽ kãm: —Pa? Kwa tee ri amnhĩ kukamã ajamaxpẽr kêt nẽ. Na pa ra anê ate amnhĩ tomnuj piitã ho ijapêx. Kot paj axte kãm ijamaxpẽr kêt nẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Hãmri nhũm Tĩrtũm kapẽr tũm o mẽ ahkre xwỳnhjaja tee ri ã kapẽr anhỹrja ã kuma nẽ hamaxpẽr o: ");
INSERT INTO apnNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","—Tk. Kwa pẽr mẽhõ myti mũj kêp Tĩrtũm kêt tã te kapẽr pyràk o amnhĩ nhĩpêx nẽ mẽ nê mẽ kot amnhĩ tomnuj o hapêx ã amnhĩ jarẽ. Tĩrtũm pix kot mẽ nê mẽ kot amnhĩ tomnuj o hapêx kênã. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Nom nhũm Jejus mẽ hamaxpẽr kôt mẽ omunh mex nẽ. Mẽ kot Tĩrtũm pix kot mẽ nê mẽ kot amnhĩ tomnuj rênh nẽ akupỹm mẽ à xwỳnhjê ho mex kôt mẽ hamaxpẽrja nhũm mẽ omunh mex nẽ mẽ kãm: —Kwa mẽ ã ajamaxpẽr anhỹr kêt nẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Ixte mẽ nê mẽ kot amnhĩ tomnuj o ijapêx par ã amnhĩ jarẽnh tã mẽ ate mẽ ano ho ja kôt ixpumunh kêt jakamã na ka htem ja hã ixkôt ajamaxpẽr kêt nẽ. Nom kot paj mẽ anoo mã akupỹm myja o mex. Ka mẽ ja hã ixpumu hãmri nẽ ixkôt ajamaxpẽr kurê kumrẽx. ");
INSERT INTO apnNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Ixpê Tĩrtũm kot mẽ awỳr inhmẽnh xwỳnh na pa. Ixte mẽ anê mẽ ate amnhĩ tomnuj rênh kaxyw na pre mẽ awỳr inhmẽ pa wrỳ. Tã mẽ ate ja kôt ixpumunh kaxyw kot paj mẽ anoo mã mytija ho mex. ");
INSERT INTO apnNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","Anhỹr o mẽ kãm kapẽr hãmri nẽ ĩ kamã htyk xwỳnhta mã kapẽr nẽ kãm: —E kànhmã xa nẽ anõr xà mỳ nẽ ma akupỹm anhõrkwỹ hwỳr tẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Hãmri nhũm kuma nẽ kànhmã ãm kurê kumrẽx. Hãmri nẽ akupỹm mex ã amnhĩ pumu nẽ hkĩnh tỳx nẽ nõr xà mỳ nẽ mẽ noo mã kato nẽ ma akupỹm õrkwỹ hwỳr tẽ. Hãmri nhũm mẽ kot omunh xwỳnhjaja amnhĩ jaêr pê omu nẽ no hapôx kaxyw nẽ hkôt omunh o kuhê nẽ kamã no pyma htỳx nẽ. Nẽ tee ri omu nẽ axpẽn mã: —Hêxta waa nẽ. Aa mẽ pahte ã mẽhõ kot amnhĩ nhĩpêx anhỹr ã omunh kêt kumrẽx tã jarãhã ja pumu. Nà Tĩrtũmja ãm mex o mex. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Hãmri nhũm Jejus mẽ ma mra nẽ akupỹm gô rax pê Garirej wỳr mra nẽ gô mỳ ri pa. Hãmri nhũm mẽ piitã omu nẽ hwỳr mra nẽ hã akuprõ nhũm Tĩrtũm kapẽr o mẽ ahkre ho nhỹ. ");
INSERT INTO apnNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Hãmri nẽ mẽ kure nẽ axte hkôt mẽ pa ho mẽ pa xwỳnhjê mẽrohã ma axte mra nẽ nhỹri Apew kra Rewija pumu. Rõm kãm mẽ õ pahihti mã amnhĩ kwỳjê pê kàxpore hkwỳ jamỳnh xwỳnh na pre. Jakamã nhũm àpênh o nhỹ nhũm Jejus hãnh tẽ nẽ omu nẽ amnhĩ kôt kuwỳ nẽ kãm: —Pa? E kwa axàpênhta kaga nẽ hpãnhã amnẽ mẽ ixkôt mãn ri apa ho apa. Anẽ. Hãmri nhũm kuma nẽ àpênh kaga nẽ ma hkôt mõ nẽ hkôt pa ho pa. ");
INSERT INTO apnNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Hãmri nhũm mẽmo arĩgro hã nhũm Rewi nhõ mẽ apkur xà hã mẽõ rax nẽ. Jakamã nhũm amnhĩ nhõrkwỹ hwỳr hkràmnhwỳjaja nẽ Jejus mẽ hkôt mẽ pa ho mẽ pa xwỳnhjê hwỳ. Hãmri nhũm mẽ ma hkôt mra nẽ õrkwỹ hwỳr agjê nẽ kuri apkur o hkrĩ. Nẽ mããnẽn mẽ kêp Rõm nhõ pahi mã mẽ kêp kàxpore hkwỳ jamỳnh xwỳnh kwỳ nẽ mẽ ohtô nẽ mẽ kutã apkur o hkrĩ. ");
INSERT INTO apnNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Hãmri nhũm Tĩrtũm kapẽr tũm o mẽ ahkre xwỳnh kwỳ pê Parijew nhõ xwỳnhjaja mra nẽ mẽ apkur ã mẽ omu. Nẽ tee ri mẽ hkaêx ã Jejus pumu nẽ hkôt mẽ pa ho mẽ pa xwỳnhjê hwỳr agjê nẽ hã mẽ kãm akir nẽ mẽ kãm: —Kwa na htem mẽ kot amnhĩ tomnuj xwỳnhjê kutã apkur kêt tã ka mẽ Jejus mẽ apimrààtã axtem nẽ mẽ kutã axàpkur o akrĩ. Mẽ ate amnhĩ to mex ronhỹx ka mẽ kutã axàpkur kêt nẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Hãmri nhũm Jejus amnhĩ tã mẽ kapẽr ma nẽ mẽ kãm: —Tk. Ixte tãm mẽ unhwỳr kaxyw ixte mẽ kutã ixàpkur o inhỹr kênã. Xà na hte tôtô mẽ mex xwỳnhjê hwỳr mra nẽ mẽ hkane? Nà na hte ãm mẽ à xwỳnhjê pix kane ho pa. Ra mẽ ate ja pumunh mex. Ja pyrà nẽ na pa pre mẽ kot amnhĩ to mex xwỳnhjê hwỳr ixwrỳk kêt nẽ. Ãm mẽ kot amnhĩ tomnuj xwỳnhjê pix wỳr na pa pre wrỳ. Ixte tãm mẽ unhwỳr kaxyw mẽ hwỳr wrỳ nẽ jajê kutã ixàpkur o nhỹ. Mẽ ate amnhĩ tomnuj mã anhũrer nẽ hpãnhã tãm amnhĩ nhĩpêx o apa kaxyw na pa pre mẽ awỳr wrỳ nẽ mẽ akamã ixukaprĩ ho ri mẽ akôt ixpa. Tã ka mẽ atỳx ã ixte mẽ kutã ixàpkur anhỹrja ã ixto akapẽr anẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Juãw Paxis kôt mẽ pa xwỳnhjê mẽ Parijew nhõ xwỳnhjaja na prem tõhã Tĩrtũm mã amnhĩ jarẽnh kaxyw nẽ apkur kêt rãhã kamã kãm amnhĩ jarẽ. Nom nhũm Jejus kôt mẽ pa ho mẽ pa xwỳnhjaja na prem kãm amnhĩ jarẽnh prãm nẽ apkur kãm amnhĩx kãm amnhĩ jarẽnh o pa. Jakamã nhũm Ijaew kwỳjaja tee ri ja hã mẽ omu nẽ Jejus wỳr mra nẽ mẽ hã hkukja nẽ kãm: —Pa? Kwa aprĩ hã mẽ inhmã mẽmoj jarẽ. Na hte Parijew nhõ xwỳnhjê mẽ Juãw Paxis kôt mẽ pa xwỳnhjaja tõhã Tĩrtũm mã amnhĩ jarẽnh kaxyw nẽ apkur kêt rãhã kãm amnhĩ jarẽ. No akôt mẽ pa ho mẽ pa xwỳnhjaja na htem àmnhĩx apkur o pa kamã kãm amnhĩ jarẽnh o pa. Kwa mo na htem mẽ uràk nẽ tõhã apkur kêt rãhã kãm amnhĩ jarẽnh kêt nẽ? Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Hãmri nhũm Jejus mẽ kãm: —Tk. Mo kaxyw kot mẽ ã amnhĩ nhĩpêx anẽ? Mẽ hkaprĩ hkêt kênã. Mẽ kot ixkôt pa ho pa hã amnhĩ pumunh jakamã na htem hkĩnh nẽ pa. Kormã ixte mẽ hkôt ixpa kênã kot kêt mẽ Tĩrtũm mã kapẽr kaxyw nẽ ho apkur kêt kamã kãm amnhĩ jarẽ. Xà na htem hkràmnhwỳ hã hkĩnh kaxyw hã akuprõ nẽ hkaprĩ nẽ apkur kêt nẽ mỳr o hkrĩ? Nà na htem hã akuprõ nẽ hkĩnh nẽ apkur rũnh nẽ. Ja pyrà nẽ na hte ixkôt mẽ pa ho mẽ pa xwỳnhjaja ixkôt kormã àmnhĩx hkĩnh nẽ apkati mẽ apkur kãm kãm amnhĩ jarẽnh o pa. ");
INSERT INTO apnNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Nom koja mẽ kãm ixkurê xwỳnhjaja nhỹrmã tanhmã ixto hãmri nhũm mẽ rĩ kormã hkaprĩ htỳx kãm ho apkur kêt rãhã Tĩrtũm mã amnhĩ jarẽ. Anẽ. Nhũm pre ã Jejus mẽ kãm hkôt ri mẽ pa ho mẽ pa xwỳnhjê jarẽnh anẽ hãmri nẽ axte mẽ kãm kapẽr nẽ mẽ kãm: ");
INSERT INTO apnNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","22","—Mẽ kot amnhĩ tomnuj xwỳnhjaja mẽ kot amnhĩ nhĩpêx tũm o amnhĩ pyràk jakamã na htem mẽ kot amnhĩ nhĩpêx nyw kaga. Tã ixte amnhĩ nhĩpêx nywja te kot mẽ ate amnhĩ nhĩpêx tũm pyràk kêt jakamã na ka htem inhma nẽ ãm inhma. Kwa mẽ inhma nẽ mẽ ate amnhĩ nhĩpêx tũm gryk ã ixkaga hkêt nẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Tã nhũm mẽ ixpê Ijaew nhõ arĩgromnu pê sap kato nhũm Jejus mẽ hkôt mẽ pa ho mẽ pa xwỳnhjaja ma nhỹhỹm mõ. Ma mẽ hpur kahti hkôt nhỹhỹm mõ nhũm hkôt mẽ pa ho mẽ pa xwỳnhjaja ra kãm prãm nẽ. Hãmri nẽ prãm xàj purta kamã amnhĩm mẽmo hy te kot harôj pyràk xwỳnhta kwỳ rê nẽ ma Jejus kôt hkanhar o mõ. Mẽ ixpê Ijaewjaja na pa htem axpẽn pur kãm ixpa nẽ ã amnhĩ nhĩpêx anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Hãmri nhũm Parijew nhõ xwỳnhjaja mẽ hkôt mra nẽ tee ri ja hã mẽ omu nẽ Jejus wỳr mra nẽ mẽ hã kãm akir nẽ kãm: —Kwa jarãhã sap tã akôt mẽ pa ho mẽ pa xwỳnhjaja mẽmo hy hkwỳ rê nẽ akôt hkanhar o pa. Tĩrtũm kapẽr ã kagà htũm kot mẽ panhõ arĩgromnu hã mẽ pahte mẽmoj nhĩkẽnh nê mẽ pahkurê kênã. Kwa mẽ kãm anẽ kê mẽ ã amnhĩ nhĩpêx anhỹr kêt nẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","26","Hãmri nhũm Jejus mẽ kuma nẽ hprĩ hã mẽ kãm Tĩrtũm kapẽr tũm jarẽ nẽ mẽ kãm: —Kwa xàn ka mẽ kormã Tĩrtũm kapẽr ã kagà htũm kamã pahi Tawi kot tanhmã amnhĩ nhĩpêx to kamã harẽnh nẽ mar kêt nẽ? Kormã Apiatar kêp patre maati ri na pre Tawi hkôt ri mẽ pa xwỳnhjê mẽ prãm xàj Tĩrtũm mã amnhĩ jarẽnh xà hã ixkre hwỳr agjê. Hãmri nhũm Apiatar mẽ kãm prãm tỳx ã mẽ omu nẽ mẽ kamã ukaprĩ nẽ mẽ kãm mẽmoj gõ. Mẽ kot Tĩrtũm noo mã pãwti jaxwỳr xwỳnhta nhũm mẽ kãm kugõ nhũm mẽ kuku. Tĩrtũm kapẽr ã kagà htũm kot ja nê mẽ kurê htã nhũm mẽ kãm prãm tỳx ã mẽ omu nẽ mẽ kamã ukaprĩ xàj mẽ kãm kugõ. Patre pix kot ja hkur kaxyw tã nhũm mẽ kãm kugõ nhũm mẽ kuku. Tã nom nhũm Tĩrtũm ja hã mẽ omu nhũm ja kêp omnuj kêt nẽ. Patre kot mẽ kamã ukaprĩ nẽ mẽ kãm õr nhũm ja hã omu nhũm ja kãm mex nẽ. Anẽ. Hãmri nẽ mẽ kãm: ");
INSERT INTO apnNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","—Na pre Tĩrtũm panhĩ kumrẽx o kato nẽ kormã mẽ hkôkôt nẽ Tĩrtũm mã hamaxpẽr o hkrĩ kaxyw arĩgromnu ho kato. No na pre arĩgromnu kumrẽx o kato nẽ hpãnhã kaxyw panhĩ ho kator kêt nẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Tã pa na pre Tĩrtũm mẽ akaxyw ixãm nẽ mẽ awỳr inhmẽ. Jakamã papxipix na pa hte arĩgromnu hã tanhmã mẽ kot amnhĩ nhĩpêx to hã mẽ kãm karõ ho ri ixpa. Jakamã kwãr mẽ mãmrĩ mẽmojta rê nẽ ixkôt hkanhar o mõ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Tã nhũm mẽ ixpê Ijaewjê nhõ arĩgromnu pê sapja axte kato. Hãmri nhũm Jejus Tĩrtũm kapẽr o mẽ ahkre xà hã ixkreja wỳr tẽ nẽ axà nẽ kamã Tĩrtũm kapẽr o mẽ ahkre ho nhỹ. Nhũm mẽhõ my ĩhkra grà xwỳnhja mẽ ĩhkô hã mar o nhỹ. ");
INSERT INTO apnNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Nhũm Parijew nhõ xwỳnhjaja kãm mẽ hkrãhtũmjê mã Jejus o kapẽr prãm jakamã htãnopxar o kuhê nẽ axpẽn mã: —E kwa pu mẽ jar pakuhê nẽ kot tanhmã amnhĩ nhĩpêx to hã omu. Xà koja jarãhã ĩhkra grà xwỳnh mũj o mex nà? Jarãhã arĩgromnu kênã kot kêt kãm ĩhkra ho mex. Koja ho anẽ nẽ ra Tĩrtũm kapẽr tũm nhĩrôp xa. E pu mẽ xa nẽ hã omu. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Hãmri nhũm Jejus ĩhkra grà xwỳnhta pumu nẽ kãm: —Pa? E kànhmã xa nẽ amnẽ ixwỳr tẽ. Anẽ. Hãmri nhũm kànhmã xa nẽ hwỳr tẽ nẽ mẽ piitã mẽ noo mã xa. ");
INSERT INTO apnNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Hãmri nhũm Jejus mẽ kot omunh o hkrĩ xwỳnhjê hwỳr rĩt nẽ arĩgromnu hã tanhmã mẽ kot amnhĩ nhĩpêx to hã mẽ hkukja nẽ mẽ kãm: —E mẽ inhma. Tanhmã na htem arĩgromnu hã axpẽn nhĩpêx to wehe? Xà kot ka mẽ arĩgromnu hã axà htỳx nẽ amex prãm xàj ma mẽhõ hwỳr amnhĩ to tẽ nhũm apumu nẽ apkatim arĩgro mex jamãr pê akane hkêt ka ty nhũm ja amã mex nẽ? Rỳ nhũm apumu nẽ tanhmã atomnuj to nẽ akupỹm amnhĩ nê ajano nhũm ja amã mex nẽ? Nà koja ã anhĩpêx anẽ nhũm ja amã mex kêt nẽ. E mẽ inhmã mẽmoj jarẽ. Tanhmã na pre finat Mojesja Tĩrtũm nhỹ hã arĩgromnu hã mẽ pahte axpẽn nhĩpêx ã mẽ pamã karõ hto? Xà kot puj mẽ hã axpẽn kãm paxukaprĩ rỳ hã mẽ pamã axpẽn kurê ho papa? Xà kot puj mẽ hã mẽmoj punuj pê mẽ utà rỳ kot puj mẽ ãm arĩgro mex pix ã mẽ utàr kaxyw arĩgro mex jamã? E mẽ atõ inhmã ja jarẽ. Anẽ. Ra kot hprĩ hã mẽ hamaxpẽr ã mẽ omunh mex nẽ ã hêx rom mẽ hkukjêr anẽ. Nom nhũm mẽhõ tanhmã kutã kãm nẽ hkêt nẽ. Mẽ ãm piitã akryk mar pê omunh o hkrĩ. Mẽ kot tanhmã kãm nẽ nhũm ta pãnhã tanhmã mẽ kãm nẽ pymaj nhũm mẽ tee ri kãm tanhmã nẽ hprãm nom akryk mar o hkrĩ. ");
INSERT INTO apnNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Hãmri nhũm Jejus tee ri mẽ ukaprĩ hkêt ã mẽ omu nẽ hkaprĩ nẽ mẽ kamã gryk nẽ. Hãmri nẽ ĩhkra grà xwỳnhja mã kãm: —Tk. Mẽ kot tanhmã inhmã ujarẽnh tore hã. E anhĩhkra katàt. Anẽ. Hãmri nhũm ĩhkra katàt nẽ akupỹm mex kurê kumrẽx. ");
INSERT INTO apnNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Hãmri nhũm Parijew nhõ xwỳnhjaja tee ri ã Jejus kapẽr anhỹrja ã kuma nẽ kot sap ã akupỹm myta o mex ã omu nẽ kamã gryk tỳx nẽ. Nẽ hapôj nẽ ma pahi Erox kôt mẽ pa xwỳnhjê hwỳr mra nẽ mẽ kãm harẽ nẽ tanhmã hã axpẽn kukjêr to nẽ axpẽn mã: —Kwa tanhmã kot puj mẽ ho? Na ã kapẽr anhỹrja o mẽ pahto kapẽr punuj nẽ. Te hkĩnhã mẽ papamjaja mẽ kamã paxukaprĩ hkêt pyràk ã mẽ pajarẽ. Koja mẽ pahkwỳjaja kuma hãmri nẽ mẽ pahte amnhĩ nhĩpêx kaga nẽ amnhĩ kaxyw hkôt pix mã hamaxpẽr o pa. Ja pymaj kwa tanhmã kot puj mẽ ho? Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","8","Tã nhũm Jejus mẽ hkôt mẽ pa ho mẽ pa xwỳnhjê mẽrohã ma akupỹm gô rax wỳr mõ nhũm mẽ ohtô nẽ omu nẽ ma hkôt mra. Pyka pê Garirej mẽ Jutej wa kurũm nẽ krĩ pê Jerujarẽ rũm nẽ pyka pê Itumêj rũm nẽ pyhti pê Jotãw nhĩkjê hã krĩ hkwỳ rũm nẽ krĩ hkwỳ pê Xir mẽ Sitõ wa pu hã krĩ hkwỳ rũm ohtô nẽ ma hwỳr mra. Na prem ra harẽnh ma nẽ nhỹhỹm mõr ã omu nẽ axpẽn mã harẽnh o: —E kwa tokyj pu mẽ ma hwỳr mẽ à xwỳnhjê o mõ kê akupỹm mẽ ho mex. Anẽ. Hãmri nẽ hwỳr mẽ o mra nẽ hã pikuprõnh rax nẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","10","Hãmri nhũm Jejus akupỹm mẽ à xwỳnhjê ho mex. Gô mỳri xa nẽ tanhmã mẽ ho mex to. Jakamã nhũm mẽ axte ohtô nẽ hwỳr mra nẽ piitã kot htok nẽ akupỹm mex kaxyw hwỳr axpẽn nhĩgã. Hãmri nhũm tee ri amnhĩ wỳr mẽ omu nẽ hkôt mẽ pa ho mẽ pa xwỳnhjê mã: —Kwa mẽ ma mra nẽ amnẽ kanôre jêt mũj kjênh o tẽ nẽ jar inhmã anhô. Kê mẽ ixtã axpẽn nhĩgãnh o ijanênh japêr pa hwỳr axà nẽ amỳm mẽ ho hpỹnh nẽ akupỹm mẽ ho mex. Anẽ. Hãmri nhũm mẽ kuma nẽ ma mra nẽ kãm ja o tẽ nẽ kunhô. ");
INSERT INTO apnNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Na pre mẽkarõmnuti hkwỳja mẽ hkwỳjê hwỳr agjê. Jakamã nhũm mẽ Jejus pumu nẽ mẽkarõmnuti nhỹ hã kêp Tĩrtũm Kra hã omunh kurê kumrẽx. Hãmri nẽ hã hpijaàm kaxyw kutã hkõnkrã ho hkrĩ nẽ mẽkarõmnuti nhỹ hã kãm kapẽr nẽ kãm: —Kwa apê Tĩrtũm Kra na ka. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Hãmri nhũm tee ri amnhĩ tã mẽ kuma. Kãm mẽkarõmnuti ã kot harẽnh anhỹr prãm kêt nẽ. Ãm mẽ piitã mẽ kot kapẽr mar nẽ kot amnhĩ nhĩpêx ã omunh pê kêp Tĩrtũm Kra hã omunhja na kãm hprãm. Jakamã nhũm mẽkarõmnuti ã harẽnh anẽ nhũm ja nê mẽ kãm kapẽr nẽ mẽ kãm: —Tk kwa nà kêr ka mẽ tanhmã ijarẽnh to hkêt nẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Tã nhũm Jejus hkôt mẽ pa ho mẽ pa xwỳnh kwỳjê mã kãm: —E pu mẽ ma mõ nẽ krãhakỳx mũj ã api. Anẽ. Hãmri nẽ mẽ ma hwỳr mõ nẽ hã api ");
INSERT INTO apnNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","nhũm Jejus amnhĩ kaxyw mẽ ho 12 nẽ mẽ kurê. Mẽ kot ma ỹ hã Tĩrtũm kapẽr o mẽ ahkre ");
INSERT INTO apnNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","nẽ ỹ hã mẽ nê mẽkarõmnuti janor o pa kaxyw. ");
INSERT INTO apnNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","ã mẽ hixi kot anhỹr. Na pre ja kêp Simãw no nhũm Jejus hpãnhã hã hixi hõ mẽ nhũm hpãnhã mããnẽn kêp Pêtre. ");
INSERT INTO apnNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Nẽ hkôt Jepetew kra Xiakre mẽ htõ Juãwja wa kuta. Hãmri nẽ kot Simãw nhĩpêx pyrà nẽ wa hã hixi hõ mẽ nhũm wa hpãnhã mããnẽn kêp Poanes. Wa kot amnhĩ prêprêk jakamã nhũm ã wa hã hixi mẽnh anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Nẽ hõ pê Andreja ta. Nẽ hkôt Andre htõ Firiptija ta. Nẽ hkôt Patoromewja ta. Nẽ hkôt Matêwreja ta. Nẽ hkôt Tomasja ta. Nẽ hkôt Arpêw kra Xiakreja ta. Nẽ hkôt Tatewja ta. Nẽ hkôt Simãw õja ta. Simãwja na pre kãm mẽ ixpê Ijaewjê nhõ pika pê Ijaew kĩnh tỳx nẽ. Jakamã na pre kãm nhãm pika hõ nhõ pahi kot mẽ ho amnhĩptàr prãm kêt nẽ pa. ");
INSERT INTO apnNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Nẽ hkôt Jut Kariotja ta. Kormã kot mẽ kãm Jejus kurê xwỳnhjê nhĩhkram õr mã nhũm Jejus kot amnhĩ kukamã omunh mex tã mẽ hkôt amnhĩ kaxyw kuta. Ã mẽ kot ỹ hã mẽ ahkre o pa kaxyw mẽ rênh xwỳnhjê nhĩxi kot anhỹr. ");
INSERT INTO apnNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Hãmri nhũm Jejus hkôt mẽ pa ho mẽ pa xwỳnh kwỳjê rênh pa nẽ ma amnhĩ kôt mẽhõ nhõrkwỹ hwỳr mẽ o mõ. Na prem apkur kêt ry rax nẽ ra kãm prãm tỳx nẽ nhũm ma mẽ apkur kaxyw amnhĩ kôt mẽ o mõ. Hãmri nhũm axte mẽ à xwỳnhjaja mẽ omu nẽ Jejus wỳr pikuprõnh rax nhũm mẽ tokyx apkur kêt nẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Hãmri nhũm Jejus katorxà nẽ htõjaja tee ri mẽ apkur kêt ã mẽ harẽnh ma nẽ axpẽn mã: —Kwa mãn ãm ra tanhmã hkrã amnhĩ to nà? Hã na mẽ kot omunh kaxyw hã hpikuprõnh rax jakamã nhũm kormã apkur kêt nẽ. E tokyx pu mẽ ma hwỳr mra nẽ omu nẽ mẽ kêp utà nẽ akupỹn amnhĩ kôt o mõ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Rôm nhũm Tĩrtũm kapẽr tũm o mẽ ahkre xwỳnhjaja Jerujarẽ rũm Jejus wỳr mõn pôj. Hãmri nẽ tanhmã ho kapẽr punuj to. Kêp mẽkarõmnuti hkwỳ hã hkamnhĩx jakamã harẽnh o: —Tk pẽr hinhu nhĩkôôti nhỹ hã na hte mẽ nê amnhĩ kwỳjê japôx o pa. Anẽ. Hinhu nhĩkôôti nhĩxi hõ pê Satanasti nhũm prem ỹ hã Jejus kot amnhĩ nhĩpêx o pa hã hkamnhĩx. ");
INSERT INTO apnNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Hãmri nhũm amnhĩ tã mẽ omu nẽ amnhĩ wỳr mẽ kãm hpa ho apê nẽ mẽ kãm amnhĩ jarẽ. Nom amnhĩ tã kuxi nẽ mẽ kãm mẽmoj jarẽ nẽ mẽ kãm: —Kwa mẽ inhma mẽ ate ixpê Satanasti hkwỳ hã ixkamnhĩx xwỳnhjaja. Xà na hte Satanasti mẽ nê amnhĩ kwỳjê janor o pa? Nà na hte ã amnhĩ nhĩpêx anhỹr kêt nẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Na hte pika nhõ xwỳnhjaja axpẽn kutã amnhĩ xunhwỳ nẽ axpu hãmri nẽ anhgrà nẽ ma ahpỹnhã ri pa nẽ amnhĩ krã hkôt ri tanhmã amnhĩ to ho ri pa. Jakamã nhũm mẽ õ pahija mẽ hamãr o pa hkêt nẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Nẽ krĩ nhõ xwỳnhjaja haxwỳja. Mẽ kot axpẽn to hkwỳ xwỳnhjaja koja mẽmoj tã axpẽn kãm gryk nẽ axpẽn kutã amnhĩ xunhwỳ hãmri nẽ anhgrà nẽ ahpỹnhã pa hãmri nhũm mẽ õ pahi tee ri kãm mẽ hamãr o pa hprãm. Mo hkwỳjaja kot kêt ri mẽ hamãr o pa? Nom tãm kot amnhĩ nê mẽ hanoore hã. Mẽ tãmjaja na prem axpẽn kãm gryk nẽ anhgrà nẽ ahpỹnhã pa. ");
INSERT INTO apnNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Tã ja pyrà nẽ ixte Satanasti nhỹ hã tanhmã amnhĩ nhĩpêx to ho ixpa ronhỹx pa ri mẽ kurũm amnhĩ kwỳjê japôx o ri ixpa hkêt nẽ. Mẽkarõmnutijaja kêp Satanasti hkwỳ kênã. Koja Satanasti ixte mẽ kurũm mẽ hapôx kaxyw tanhmã inhmã nẽ hkêt nẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","àhpumunh tỳx jakamã na hte mẽ kot hkôt amnhĩ xunhwỳr xwỳnhjê pumunh tỳx o pa nhũm mẽhõ tee ri kêp mẽ utàr kaxyw. Tã ixàhpumunh tỳx o ixte hakrenh jakamã ixte kêp mẽ utàrja inhmã tanhmã kute hkêt. Na pa hte kêp mẽ utà nhũm mẽ hpãnhã ixkôt amnhĩ nhĩpêx o pa nhũm Satanasti tee ri mẽ hã ixpumunh o pa kaprỳ. ");
INSERT INTO apnNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","—Ãm hãmri na pa mẽ amã ixkapẽr. Kot kaj mẽ tanhmã amnhĩ tomnuj to ho apa. Nẽ amnhĩ tomnuj tỳx kumrẽx rãhã ho apa. Rỳ tanhmã akapẽr punuj to ho apa. Rỳ tanhmã Tĩrtũm o akapẽr punuj to ho apa. Tã tee ri ja hã amnhĩ pumu nẽ akaprĩ nẽ ã ate amnhĩ nhĩpêx anhỹrja kaga nẽ Tĩrtũm kôt amnhĩ xunhwỳ. Hãmri nhũm amnhĩ tã mẽ apumu nẽ amnhĩ katut kôt mẽ ate amnhĩ tomnuj nẽ mẽ akapẽr punuj rẽnh pa nẽ axte kãm hamaxpẽr kêt nẽ. Koja ho hapêx par kumrẽx. ");
INSERT INTO apnNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Nom koja Tĩrtũm Karõ xatã mẽ amã ixto amnhĩrĩt tã ka mẽ ama nẽ ãm ama nẽ te kêp amnhĩ jamak pro pyràk o amnhĩ nhĩpêx. Jao Tĩrtũm Karõ hã apijaàm kêt ã amnhĩ to amnhĩrĩt. Ja mỳrapê koja Tĩrtũm nhỹrmã amnhĩ xwar te mẽ apê amnhĩ jamak pro pyràk o mẽ anhĩpêx ka mẽ tee ri kãm amnhĩ kaprĩ kaprỳ. Hãmri nẽ mẽ kot amnhĩ xà htỳx kamã hamak o pa htũm xà wỳr ma apa nẽ kamã apa rãhã apa ho apa. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Mẽ kot Satanasti nhỹ hã mẽ nê mẽkarõmnuti janor o pa hã hkamnhĩx jakamã nhũm pre Jejus ã mẽ kãm kapẽr anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Rôm nhũm Jejus katorxà mẽ htõjaja hwỳr mra no ãm kormã hwỳr gjêx kêt nẽ. Mẽ kot hã htu rax jakamã nhũm mẽ tee ri hwỳr gjêx kaxyw kormã kapôt ã kuhê. Hãmri nẽ mẽ kot mar o kuhê xwỳnhjê hõ mã kapẽr nẽ kãm: —Kwa ma tẽn Jejus mã mẽ ijarẽ kê mẽ ixwỳr kato. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Rôm nhũm ixkre kamã mẽ hkrĩ xwỳnhjaja mẽ omu nẽ Jejus mã mẽ harẽ nẽ kãm: —Kwa Pahihti. Ota akatorxà mẽ atõjaja awỳr mra nẽ pôj nẽ tee ri awỳr gjêx mã nẽ kormã kapôt ã kuhê nẽ atã karõ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","35","Hãmri nhũm mẽ kuma nẽ mẽ kãm: —Tôe pa ixkato nẽ mẽ omu. Inhmã mẽ hapêê. Nom kot kaj mẽ atõ Tĩrtũm kapẽr ma nẽ hkôt amnhĩ xãm nẽ hkôt amnhĩ nhĩpêx. Hã kot kaj te apê ixtõ rỳ ixkatorxà kot amnhĩ nhĩpêx pyràk o pu mẽ axpẽn nhĩpêx. Pa te inhmã mẽ hapê pyrà nẽ inhmã mẽ ajapê nẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Tã nhũm Jejus axte gô jakàx ã mẽ ahkre ho nhỹ. Hãmri nhũm mẽ axte hã htu rax jakamã nhũm tee ri mẽ omu hãmri nẽ pàr krem axà nẽ gôx kãm amỳm mẽ ahkre ho nhỹ. Nhũm mẽ piitã kỳxpê omunh nẽ mar mex o kuhê. ");
INSERT INTO apnNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Hãmri nhũm mẽ ahkre ho nhỹ. Nom mẽ ujarẽnh pix kãm mẽ ahkre. Mẽ kot Tĩrtũm kapẽr mar nẽ tanhmã hkôt amnhĩ nhĩpêx to ho paja nhũm hã kuxi nẽ mẽ kãm hã ujarẽnh o nhỹ nẽ mẽ kãm: ");
INSERT INTO apnNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","—E mẽ inhma. Koja mẽhõ ma pur mã mõ nẽ pur kãm mẽmo hy ho ukapêr o pa nom nhũm hy piitã amex kãm rôrôk kêt nẽ. Koja ahpỹnhã rôrôk. ");
INSERT INTO apnNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Koja hkwỳ aptỳx kãm rôrôk nhũm kuwênhre omu nẽ hwỳr mra nẽ hkrẽr pa. ");
INSERT INTO apnNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","6","Nẽ koja kẽn kãm hkwỳ rôrôk hãmri nẽ higrõt kutã nojarêt nẽ higrõt pa. Nom nhũm kamã aptỳx nẽ kamã kêp pika hkryre jakamã nhũm higrõt nhũm hã myt ahpa nẽ arĩgro htỳx mẽ nhũm grà pa. Harê hkryre jakamã grà pa. ");
INSERT INTO apnNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Nẽ koja hkwỳ mrônhĩ kamã rôrôk nẽ higrõt tã no nhũm utĩja kêp amỹtà nhũm ô hkêt nẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","—No koja hirã kamã pika mex kãm hkwỳ rôrôk. Hãmri nẽ hirã kamã rôrôk jakamã higrõt mex nẽ piitã ô rax nẽ. Kamã ô hkwỳ kêp 30 nẽ kamã hkwỳ kêp 60 nẽ kamã hkwỳ kêp 100. Ã mẽ ujarẽnh kot anhỹr. ");
INSERT INTO apnNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Kwa mẽ ama nẽ kãm ajamaxpẽr tỳx rãhã ho ri apa. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Hãmri nhũm mẽ Jejus xujarẽnh mar pa nẽ anhgrà nẽ ma akupỹm mra nhũm hkôt mẽ pa ho pa xwỳnh pê 12 mẽ hkwỳjaja pix Jejus ri arĩk. Hãmri nẽ ujarẽnhta ã hkukja nẽ kãm: —Kwa mon ka hte ã mẽ kãm axujarẽnh anẽ Pahihti? Na pa mẽ ixprĩ hã amar mex kêt nẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","12","Hãmri nhũm mẽ kãm: —Nà kot paj ixprĩ hã mẽ amã harẽ. Tĩrtũm kãm mẽ ate aprĩ hã mar prãm jakamã kot paj ixprĩ hã tanhmã mẽ amã harẽnh to. Nà mẽ kot amnhĩ tomnu kaga nhũm Tĩrtũm kot ja hã mẽ omunh xà hkôt mẽ ho hkra hã harẽnhja na pa hte mẽ kãm harẽ. No mũjjaja mẽ akĩnhã mẽ kãm mar prãm kêt jakamã na pa hte mẽ kãm mẽmoj tã haxwỳ nẽ awjarẽ nhũm mẽ ãm ixujarẽnh pix ma. Na htem kuma nẽ ãm kuma nẽ htỳx ri hã pa. No kêp apu mẽ kãm hprĩ hã mar prãm ronhỹx mẽ ra hprĩ hã kuma nẽ Tĩrtũm kôt amnhĩ xunhwỳ nhũm amnhĩ tã mẽ omu nẽ mẽ kot amnhĩ tomnuj o hapêx. Nom mẽ kãm mar prãm kêt. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Tã mẽ ate aprĩ hã ixujarẽnhja mar mex kêt jakamã tanhmã kot kaj mẽ amnhĩ to nẽ ixujarẽnh piitã ama? E kot paj ixprĩ hã mẽ amã mẽmo hyta jarẽ ka mẽ inhma. ");
INSERT INTO apnNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","—Nà mẽmo hyta te kêp Tĩrtũm kapẽr pyràk. Nẽ ahpỹnhã rôrôk xà hã pikata te kêp ahpỹnhã mẽ kot Tĩrtũm kapẽr mar xwỳnhjê kot mar nẽ ahpỹnhã tanhmã amnhĩ nhĩpêx to pyràk. ");
INSERT INTO apnNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Jakamã mẽ kot mar xwỳnh kwỳjaja hte kot aptỳx kãm hkwỳ rôrôk nhũm kuwênh kot hwỳr mrar nẽ hkrẽr par xwỳnhta pyràk. Jakamã na htem Tĩrtũm kapẽr ma nom nhũm Satanasti te kuwênh kot hy hkrẽr parta pyràk o mẽ hipêx. Nẽ mẽ kot amnhĩ kaxyw hkôt hamaxpẽr nẽ hkôt amnhĩ xunhwỳr pymaj tanhmã nê mẽ hkrã hto. Jakamã nhũm mẽ Tĩrtũm kapẽr ma nom ho hamakêtkati tokyx anẽ nẽ axte kãm hamaxpẽr kêt nẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","—Nẽ mẽ kot mar xwỳnh kwỳjaja te kot kẽnre kamã hkwỳ rôrôk nẽ higrõt nhũm te hã myt ahpa nhũm grà par tokyx anhỹr xwỳnhta pyràk. Na htem Tĩrtũm kapẽr ma nẽ hkĩnh nẽ. Nẽ kãm mar prãm nẽ. Te hy higrõt tokyx anhỹrta pyràk. ");
INSERT INTO apnNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Tã nhũm mẽhõ tẽ nẽ Tĩrtũm nê tanhmã mẽ kãm kapẽr to nhũm mẽ kuma nẽ hkaga. Rỳ nhũm mẽ Tĩrtũm ã tanhmã mẽ homnuj to nhũm mẽ tee ri amnhĩ tã mẽ omu nẽ hkaga. Te mẽmo hy higrõt nẽ grà par tokyx anhỹrta pyràk. ");
INSERT INTO apnNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","—Nẽ mẽ kot mar xwỳnh kwỳjaja te kot mrônhĩ kamã hkwỳ rôrôk nẽ higrõt nhũm mrônhĩ kot kêp àmnàr xwỳnhta pyràk. Nẽ mẽ kãm Tĩrtũm kapẽr mar prãm nẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Nom mããnẽn kãm hikukrêx rax nẽ hikàxpore rax prãm jakamã ãm ja pix kukamã hamaxpẽr o ri pa. Jao ra gryk ã axte Tĩrtũm kapẽr mã hamaxpẽr nẽ hkôt amnhĩ nhĩpêx kêt nẽ. Te mrônhĩ kot higrõt pê àmnàr nhũm ô hkêêta pyràk. ");
INSERT INTO apnNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","—No mẽ kot mar xwỳnh kwỳjaja te hirã kamã pika mex kãm hy hkwỳ rôrôk nẽ higrõt nẽ ô raxta pyràk. Na htem ixkapẽr ma nẽ amnhĩ krã him hagjênh tỳx nẽ. Nẽ ixkôt ri amnhĩ nhĩpêx mex rãhã ho ri pa. Te mẽmo hy hkre kamã ô hkwỳja kêp 30 nẽ kamã kêp 60 nẽ kamã kêp 100ta pyrà nẽ Tĩrtũm kapẽr kôt amnhĩ nhĩpêx mex rãhã ho pa. E ã ixujarẽnhja kot anhỹr. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Nhũm Jejus arĩ hkôt mẽ pa ho pa xwỳnhjê jahkre nẽ mẽ kãm: —Xà na htem kanê hpôk nẽ poti ho hpro rỳ hitom kãm par krak ri unhwỳ? Nà na htem hpôk hãmri nẽ kỳx pê mẽmoj nhĩmõk ã unhwỳ. ");
INSERT INTO apnNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Ja pyrà nẽ mẽ piitã kot hkwỳjê pê tanhmã hamaxpẽr punuj to ho hpimxur prãm tã tee ri kot ho hpimxur prãm kaprỳ. Koja nhỹrmã mẽ hamaxpẽr piitã amnhĩ to amnhĩrĩt pa. Nẽ mẽmoj piitã ra hpimxur mex tã koja nhỹrmã amnhĩ to amnhĩrĩt pa. Te mẽ kot kanê hpôk nẽ kỳx pê unhwỳr nhũm amnhĩrĩt mex pyràk. Ja pyrà nẽ na pa hte Tĩrtũm kapẽr o ri ixpimxur o ixpa hkêt nẽ. Na pa hte ixprĩ hã mẽ amã harẽnh mex o ixpa. ");
INSERT INTO apnNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Kwa mẽ ixujarẽnhja ma nẽ kãm ajamaxpẽr tỳx rãhã ho ri apa. Anẽ. Nhũm pre ã Jejus mẽ kãm kapẽr anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Hãmri nẽ mẽ kãm: —Nẽ kêr ka mẽ axpẽn kãm axukaprĩ ho ri tanhmã axpẽn to mex to ho ri apa. Kêr kê Tĩrtũm ja hã mẽ apumu nẽ mẽ apyrà nẽ mẽ akamã ukaprĩ pê mẽ ato mex o pa. ");
INSERT INTO apnNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Koja mẽhõ inhmã tanhmã amnhĩ nhĩpêx mex to pa ja hã omu nẽ kot inhmã àpênh mexta pãnhã ho mex nẽ. No koja inhmã àpênh mex kêt pa ja hã omu nẽ hã ho mex kêt nẽ. —Nẽ koja mẽhõ kãm ixkapẽr mar prãm nom kormã hprĩ hã mar mex kêt tã arĩ mar o pa nẽ gaa nẽ mar tỳx o mõ. No koja kuma nẽ ãm kuma hãmri nẽ gaa nẽ hã no hkêt. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Nhũm Jejus arĩ hkôt mẽ pa ho mẽ pa xwỳnhjê jahkre ho nhỹ nẽ mẽ kãm: —E pa mẽ amã tanhmã mẽ kot ixkapẽr mar tỳx xwỳnhjê jarẽnh to ka mẽ inhma. Koja mẽhõ ixkapẽr mar tỳx nẽ ra hkôt ri amnhĩ nhĩpêx o pa. Hãmri nẽ hamaxpẽr nyw o hamaxpẽr o pa nẽ amnhĩ nhĩpêx nyw o amnhĩ nhĩpêx o pa. Te mẽ hpur kãm mẽhõ kot mẽmo hy hkre xwỳnh kot amnhĩ nhĩpêx pyràk. Na hte hyja kre ho pa. ");
INSERT INTO apnNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Hãmri nẽ hkre hpa nẽ kamàt mẽ õt o hikwỹ nẽ arĩgro mẽ mẽmoj tã àpênh o pa. Rãhã nhũm mẽmo hyja arĩ hikwỹ ho hikwỹ hkêt nẽ. Koja amnhĩ nhĩpêx õ ho amnhĩ nhĩpêx nẽ higrõt kato nẽ hprêk. Kre xwỳnh kot tanhmã kot amnhĩ nhĩpêx to hã omunh kêt tã nhũm kãm hprêk. ");
INSERT INTO apnNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","—Na hte hpõm hapôx o pa nẽ higrõt o pyka kahte. Hãmri nẽ hprêk nẽ hô axpôt nẽ gaa nẽ hpãnhã ô. Hãmri nẽ hkamrêk pa nẽ xa. ");
INSERT INTO apnNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Hãmri nẽ mẽ kot hikẽnh mã mex nẽ nhũm kot hkre xwỳnhta omu nẽ amnhĩm hamỳnh pa. Tã mẽ kot ixkapẽr mar mex xwỳnhjaja te mẽmo hy ra higrõt kator nẽ hprêk nẽ hô pipôt nẽ ô xwỳnhta pyràk. Nẽ uràk nẽ amnhĩ nhĩpêx õ ho amnhĩ nhĩpêx o pa. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","32","Nhũm Jejus arĩ mẽ ahkre ho nhỹ nẽ mẽ kãm: —Tĩrtũm kot mẽ awỳr ixte mẽ ato amnhĩptàr kaxyw inhmẽnh ã ijarẽnhja. Te ixte mẽmo hy pixire pyràk. Koja mẽhõ mẽmo hy hõ pixire nẽ hkre nhũm ra higrõt. Nẽ gaa nẽ hprêk. Hãmri nẽ hpa anhgrà nhũm kuwênhre hwỳr mra nẽ hôptĩ kamã amnhĩm haê nhĩpêx. Mẽmo hyta grire htã nhũm hkre nhũm higrõt nẽ ã amnhĩ nhĩpêx anẽ. Tã kot paj nhỹrmã urà nẽ ixpyxi htã kot paj pika piitã hkôt mẽ ho amnhĩptà nẽ mẽ omunh mex rãhã ho ri ixpa. Anẽ. Ã na pre Jejusja hkôt mẽ pa ho mẽ pa xwỳnhjê mã amnhĩ tã kuxi nẽ ujarẽnh anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Mẽ kãm ujarẽnh kãm mẽ ahkre ho pa. Te nhãm mẽmoj jarẽnh pyrà nẽ amnhĩ tã haxwỳ nẽ harẽ. Mẽ kot tanhmã mar to hã mẽ omunh xà hkôt tanhmã mẽ kãm ujarẽnh to. ");
INSERT INTO apnNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Na pre ãm ujarẽnh pix kãm mẽ kãm kapẽr mar prãm kêt xwỳnhjê mã amnhĩ jarẽnh rãhã ho pa. No mẽ kot hkôt pa ho pa xwỳnhjê mã nhũm hprĩ hã ujarẽnh jarẽ nhũm mẽhprĩ hã mar mex nẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Tã nhũm amỹkry nhũm Jejus arĩ pàr kre kamã nhỹ. Hãmri nẽ hkôt mẽ pa ho mẽ pa xwỳnhjê mã kãm: “E pu mẽ ma xarmã mõ.” ");
INSERT INTO apnNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Anẽ hãmri nẽ mẽ kot mar o hkrĩ xwỳnhjê re nẽ pàr mã agjê nẽ ma xarmã mõ. Garirej rũm kato nẽ ma xarmã pika hõ hwỳr mõ. Nhũm pàr kwỳja ma mẽ hkôt mõ. ");
INSERT INTO apnNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","38","Nhũm Jejus ra õtxwa nẽ tẽ nẽ pàr kre kamã hkrã japar xà hã hkrã xi nẽ ra õt tỳx nẽ nõ. Nhũm kôk àpêr tỳx nẽ nhũm gô kànhmã harĩ nẽ axpẽn tak. Ra ri xatã axpẽn tak nẽ pàr kre kamã axkapĩ nhũm ra mẽ kêp àr o mõ. Hãmri nhũm mẽ tee ri amnhĩ nhĩpêx nẽ tee ri amnhĩ kukamã hamaxpẽr nẽ Jejus wỳr hprõt nẽ kumra nẽ kãm: —Kwa kànhmã nhỹ Pahihti. Kot puj mẽ jarãhã pahtyk pa. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Hãmri nhũm hkrãkato nẽ kànhmã nhỹ nẽ kôk mẽ gôta pumu nẽ wa kãm kapẽr o: —E kwa wa anhĩkrê. Anẽ. Hãmri nhũm gô mẽ kôk hpinhkrênh kurê kumrẽx. ");
INSERT INTO apnNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Hãmri nhũm Jejus hkôt mẽ pa ho mẽ pa xwỳnhjê mã kãm: —Hêxta waa nẽ. Kormã mẽ ate amnhĩ kaxyw Tĩrtũm mẽ wa inhmã ajamaxpẽr tỳx kêt. Hã na ka mẽ ri amã ma nẽ tee ri amnhĩ kukamã ajamaxpẽr. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Hãmri nhũm mẽ amnhĩ jaêr pê ã kot amnhĩ nhĩpêx anhỹr ã omu nẽ tee ri axpẽn pumunh pê omunh o kuhê. Hãmri nẽ axpẽn mã: —Kokỹỹ. Jejus kêp mẽ panhĩõ hkêt. Mẽ pahtõ kot pu te kot amnhĩ nhĩpêx pyrà nẽ kôk mã pakapẽr nhũm anhĩkrê? Nà mẽ pakurom àhpumunh tỳx o àhpumunh tỳx. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Tã nhũm Jejus mẽ hkôt mẽ pa ho mẽ pa xwỳnhjê mẽrohã mõ nẽ xarmã Geras wỳr pôj. ");
INSERT INTO apnNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","4","Hãmri nẽ pàr rũm hapôj nhũm mẽhõ myja Jejus pumu nẽ hwỳr tẽ. Mẽkarõmnuti kot hwỳr àr nhũm ỹ hã oprê htỳx kumrẽx. Hãmri nẽ hkwỳjê hkàx ã kapôt ã mẽ hã pika kamã ri hkênh nẽ pa ho pa. Nhũm mẽ xatã kàx o hte hpre nẽ hpa hpre htã no nhũm kurê. ");
INSERT INTO apnNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Nẽ kamàt kãm nẽ arĩgro hã àmra htỳx o mrar pê kẽn o amnhĩ tak o mra. Mẽ hã pyka kamã nẽ kapôt ã hixêt ã amnhĩ tak tỳx rãhã ho mra. ");
INSERT INTO apnNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Tã amỳm Jejus pumu nẽ hwỳr hprõt nẽ hã hpijaàm kaxyw kutã hkõn krã ho tẽm nẽ hparpê nhỹ. ");
INSERT INTO apnNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Hãmri nhũm omu nẽ nê mẽkarõmnuti mã kapẽr nẽ kãm: —Kwa kurũm akato nẽ ma tẽ. Anẽ. Hãmri nhũm kuma nẽ tanhmã myta o nhũm tãm mẽkarõmnuti nhỹ hã Jejus mã kapẽr nẽ àmra kamã kãm: —Pa Tĩrtũm Kra Jejus? Mo kaxyw na ka ixwỳr tẽ? Kwa tanhmã ixto hkêt nẽ nà? ");
INSERT INTO apnNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","10","Anẽ nhũm kãm: —Tanhmã na anhĩxi te? Anẽ. Nhũm kãm: —Nà ixpê Mẽohtôhti. Mẽkarõmnuti ohtô nẽ kot ixwỳr gjêx jakamã na htem ã inhĩxi jarẽnh anẽ. Kwa nê mẽ ijanor kêt nẽ nà? Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","12","Hãmri nhũm mẽkarõmnuti tãm amnhĩ to kuwỳ nẽ kãm: —Kwa kêr ka jahti nê mẽ ijapôx japêr nẽ mẽ kot amnhĩ xà htỳx kamã hamak o mẽ pa htũm xàta wỳr mẽ ixrẽnh kêt nẽ. Hagrô hkwỳ mũj wỳr mãn mẽ ixrẽ pa mẽ hpãnhã hwỳr mãn hagjê? Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Hãmri nhũm mẽ kãm: —Tôe. Mẽ tãm hwỳr mra. Anẽ. Hãmri nhũm mẽmyta pê hapôx pa nẽ ma hagrô hwỳr mrar kurê kumrẽx nẽ mẽ kãm gjêx pa nhũm myja akupỹm tãm hkrã. No nhũm hagrôja mẽkarõmnuti pymaj amỹra nẽ axkahkũm nẽ hprõt nẽ himô hã krã hixêt ã axpum rôrôk nẽ gôx kãm mrõ nẽ hpikaprãr pa. Ohtô rax kumrẽx. Kêp 2.000 tã hpikaprãr pa. ");
INSERT INTO apnNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Hãmri nhũm hagrô jamãr o ri mẽ pa xwỳnhjaja tee ri ja hã omu nẽ ma mẽ õ patrãw wỳr akupỹm mẽ piitã mẽ kãm harẽnh o hprõt nẽ mra. Hãmri nẽ mẽ kãm ujarẽnh pa. ");
INSERT INTO apnNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","16","Nhũm mẽ tee ri mẽ kuma nẽ ma Jejus wỳr mra nẽ hkaxpa nẽ kuri myta pumu. Nhũm ra akupỹm tãm hkrã nẽ ê kamã tãm amnhĩ nhĩpêx nẽ nhỹ. Nhũm mẽ kot hã omunh xwỳnhjaja mẽ kãm ujarẽnh pa nhũm mẽ kuma nẽ myta pumu hãmri nẽ tee ri amnhĩ kukamã hamaxpẽr o kãm Jejus puma nẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Hãmri nẽ amnhĩ nê kãm kapẽr nẽ kãm: —Kwa mẽmo kaxyw na ka mẽ ixwỳr rê? Mẽ ma akupỹm amrar tokyx anẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Hãmri nhũm mẽ kuma nẽ akupỹm pàr wỳr agjê nhũm akupỹm mex xwỳnhta tee ri ja hã mẽ omu nẽ mẽ hkôt hkrà. ");
INSERT INTO apnNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","No nhũm Jejus kãm: —Nà kot kaj mẽ ixkôt amõr kêt nẽ. Ma akupỹm anhõ krĩ hwỳr mãn tẽ nẽ mẽ kãm Tĩrtũm kot akupỹm ato mex ã amnhĩ jarẽnh o ri mẽ hkôt apa. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Hãmri nhũm kuma nẽ ma akupỹm tẽ. Hãmri nẽ õ pyka pê Tekap kãm mẽ kãm Jejus kot tanhmã ho mex to hã harẽnh ri mẽ hkôt pa nhũm mẽ amnhĩ jaêr pê kuma nẽ tee ri hkukamã hamaxpẽr. ");
INSERT INTO apnNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Tã nhũm Jejus mẽ hkôt mẽ pa ho pa xwỳnhjê mẽrohã akupỹm xarmã mõ nẽ rê. Hãmri nẽ pàr nhô nẽ api nẽ gô mỳri kuhê nhũm pika nhõ xwỳnhjaja Jejus pumu nẽ hã pikuprõnh rax nẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","23","Hãmri nhũm mẽhõ my pê Jajtija hwỳr tẽ nẽ kutã hkõnkrã ho htẽm nẽ nhỹ. Kêp Tĩrtũm kapẽr o mẽ ahkre xà hã ixkre jamãr xwỳnh maati na pre. Nhũm hkra nija kêp à htỳx nẽ htyk kaxyw nẽ nõ. Kormã nyw. Kormã hã amgrà pê 12 pix tã ra kêp htyk kaxyw. Hãmri nhũm Jajtija tee ri hkukamã hamaxpẽr nẽ ma Jejus wỳr tẽ nẽ hpar pê hkõn krã ho tẽm nẽ ho hwỳr kãm hihtỳx nẽ kãm: —Pa akupỹm mẽ ixto mex xwỳnh maati. E awỳr na pa tẽ. Na ra ixkra ixpê htyk kaxyw. Pa tee ri omu nẽ kaxyw amã ijamaxpẽr nẽ awỳr tẽ. Jakamã kwa ma ixkôt inhõrkwỹ hwỳr tẽ nẽ inhmã omu nẽ hã anhĩhkra xi nẽ akupỹm inhmã ho mex. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Hãmri nhũm kuma nẽ ma hkôt tẽ. Nhũm mẽ ohtô nẽ axpẽn nhĩgãnh nẽ axpẽn kujahêk o wa hkôt mra. ");
INSERT INTO apnNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Nhũm mẽhõ nija haxwỳja wa hkôt tẽ. Na pre hte hkamrô hkryre rãhã ho pa hã ra hã amgrà kêp 12. ");
INSERT INTO apnNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Nẽ tôtô mã amnhĩrer rax nẽ nhũm mẽ tee ri kot ho mex kaxyw nom xatã hkane kaprỳ. Hãmri nhũm ra hikàxpore kêp hapêx nhũm arĩ ãm rãhã nẽ pa. ");
INSERT INTO apnNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","28","Hãmri nẽ tee ri amnhĩ kukamã hamaxpẽr nẽ Jejus jarẽnh ma nẽ hamaxpẽr o: —Ma kot paj ma hwỳr tẽ nẽ kêp ê pix kupênh tã akupỹm inhmex japêr. Ma kot paj ho anẽ. Anhỹr o hamaxpẽr hãmri nẽ ma mẽ hkôt hwỳr htẽm kurê kumrẽx. Nhũm mẽ ohtô raxja kaêx ã mẽ hkôt hwỳr tẽ. Hãmri nẽ katut kôt kêp ê nhĩrê kupê. ");
INSERT INTO apnNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","ãm ê pix kupênh tã akupỹm mex ã amnhĩ pumunh kurê kumrẽx. ");
INSERT INTO apnNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Hãmri nhũm Jejus kot kêp ê kupênh ã amnhĩ tã omu nẽ hêx rom xa nẽ mẽ ho hakẽx nẽ amnhĩ tã mẽ kãm kapẽr nẽ mẽ kãm: —Kwa mẽ atõ na ka ri amnhĩ kaxyw inhmã ajamaxpẽr tỳx pê ixpê ixê kupê? Anẽ. Hãmri nhũm mẽ piitã kuma nẽ tee ri axpẽn pumu nẽ kãm amnhĩ tã aprã. ");
INSERT INTO apnNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Hãmri nhũm hkôt mẽ pa ho pa xwỳnhjaja kãm: —Mẽ kot apê amnàr griã kot ka kêt ri mẽhõ kot apê hkupênh xwỳnh ã ri mẽ hkukja. Kwa mãn ãm mẽhõ amarĩ apê hkupê. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Hãmri nhũm mẽ kãm: —Nà na amarĩ ixpê hkupênh kêt nẽ. Na amnhĩ kaxyw inhmã hamaxpẽr tỳx pê ixpê hkupê. Tã na ixàhpumunh tỳx xà ho akupỹm mex. Nom ra ixte mẽhõ kot ixpê hkupênh xwỳnhta pumunh jakamã na pa ixêx rom ã amnhĩ tã ri mẽ hkukjêr anẽ. E kwa mẽ atõ inhmã amnhĩ jarẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Hãmri nhũm nija kuma nẽ tee ri kêp kot amnhĩ to hpimxur prãm. Hãmri nẽ hpijaàm nẽ hwỳr htertet o tẽ nẽ kutã hkõn krã ho tẽm nẽ nhỹ nẽ kãm amnhĩ jarẽ nẽ kãm: —Ma pa na pa inhmã inhmex prãm xàj apê axê kupê. Tã na pa akupỹm inhmex. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Hãmri nhũm kuma nẽ kãm: —Tỳ. Nà ate amnhĩ kaxyw inhmã ajamaxpẽr tỳx kôt ã ate amnhĩ nhĩpêx anhỹr jakamã na ka akupỹm amex. Kot kaj axte akamrô rãhã ho ri apa hkêt nẽ. E mãmrĩ ajamakêtkati nẽ ma akupỹm anhõrkwỹ hwỳr tẽ. Anẽ. Hãmri nhũm kuma nẽ hkĩnh nẽ ma akupỹm tẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Rôm nhũm Jajti mã mẽ àpênh xwỳnhjaja õrkwỹ rũm ma õ patrãw kutã mra nẽ wa hkaxpa nẽ Jajti mã kãm: —Kwa na ra akra apê ty. Mo kaxyw kot ka kêt amnhĩ kôt Jejus o mõ? Kwãr mãmrĩ ma akupỹm awjanã nẽ tẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Hãmri nhũm Jejus mẽ kuma nẽ Jajti mã kãm: —Kwa tee ri akra hkukamã ajamaxpẽr kêt nẽ. Ãm kaxyw inhmã mãn ajamaxpẽr tỳx rãhã nẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","40","Hãmri nhũm mẽ axte mõ nẽ mẽ õrkwỹ hwỳr pôj nẽ mẽ omu. Nhũm mẽ ra hã htu rax nẽ mỳr o hkrĩ. Hãmri nhũm Jejus mẽ hwỳr axà nẽ mẽ omu nẽ kot mẽ hkra htyk kumrẽx ã omunh tã mẽ kãm: —Kwa mẽ hãmri amỳr kêt nẽ. Na nireta htyk kêt nẽ. Na ãm gõr nẽ nõ. Anẽ. Hãmri nhũm mẽ kot ra htyk ã omunh mex jakamã kuma nẽ ãm kuma nẽ axtem nẽ ri axpẽn mã hã hpẽr o axkẽ. Hãmri nhũm Jejus mẽ hanor pa nẽ hitom kãm htyk xwỳnh wỳr àr kaxyw nẽ amnhĩ kôt Juãw nẽ Xiakre nẽ Simãw Pêtre nẽ kaxyw htyk xwỳnh katorxà nẽ hipêêxà pix amnhĩ kôt mẽ ho axà. ");
INSERT INTO apnNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Hãmri nẽ htyk xwỳnhta wỳr tẽ nẽ hpa hã kupy nẽ kãm kapẽr nẽ kãm: —Pa? E kwa kànhmã nhỹ. Anẽ. Nom amnhĩ kapẽr kãm harẽ nẽ kãm: —Tarit kũm. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Hãmri nhũm kànhmã ỹr kurê kumrẽx nẽ kànhmã xa nẽ ri mra. Na pre ra hprêk nẽ ty. Na ra hã amgrà kêp 12 tã ty nhũm Jejus akupỹm ho htĩr nẽ kànhmã ỹr nhũm kànhmã xa nẽ ri mra. ");
INSERT INTO apnNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Hãmri nhũm kuri omunh xwỳnhjaja amnhĩ jaêr pê omu nẽ kamã no pyma nẽ hkĩnh tỳx kumrẽx. Hãmri nhũm Jejus katorxà mẽ hipêêxàja wa kãm: —E mãn ra kãm prãm nẽ. Wa tokyx kãm mẽmoj japêr kê kukrẽ. Nom kêr ka wa inhmar kumrẽx. Kêr ka wa akupỹm ixte ho htĩr ã ri mẽ kãm ijarẽnh o ri apa hkêt nẽ. Ãm kwarĩ ho kwarĩ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Tã nhũm Jejus ma õ krĩ pê Najare hwỳr ma akupỹm mõ nhũm hkôt mẽ pa ho mẽ pa xwỳnhjaja ma hkôt mõ. ");
INSERT INTO apnNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Hãmri nẽ hwỳr pôj. Nhũm mẽ õ arĩgromnu pê sap kator jakamã nhũm Jejus ma Tĩrtũm kapẽr o mẽ ahkre xà hã ixkre hwỳr tẽ. Hãmri nẽ kamã mẽ ahkre ho nhỹ nhũm mẽ amnhĩ jaêr pê kapẽr mex ã kuma nẽ tee ri axpẽn pumunh pê hamaxpẽr o hkrĩ. Jejus kêp mẽ hkwỳ hã hkamnhĩx nom nhũm mẽ kurom àhpumunh tỳx nẽ kapẽr mex jakamã nhũm mẽ kuma nẽ tee ri hamaxpẽr o hkrĩ. Hãmri nẽ axpẽn mã: ");
INSERT INTO apnNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","—Kwa kêp mẽ panhĩõ htã tanhmã kot we amnhĩ to nẽ ã àhpumunh tỳx kôt mẽ pamã kapẽr anẽ nẽ ri mẽ kãm aa mẽ kot mẽmoj pumunh kêt kwỳ ho anhỹr o pa? Mẽ panoo mã na pre hprêk. Kêp pĩ kuprãr xwỳnh Juje mẽ hprõ Marir wa hkra na. Nẽ htõ Xiakre nẽ Juje nẽ Simãw nẽ Jutja ra mẽ pahte mẽ kêp htõ hã omunh mex. Nẽ htõxjaja jar mẽ pakamã pa nhũm mẽ pahte mẽ omunh mex kênã kot kêt we mẽ kurom ã àhpumunh tỳx anẽ. Anẽ. Anhỹr o axpẽn mã harẽ. Hãmri nẽ kamã gryk nẽ hkaga ");
INSERT INTO apnNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","6","nhũm tee ri amnhĩ tã mẽ omu nẽ hamaxpẽr o: —Hêxta waa nẽ. Mẽ kãm amnhĩ kaxyw ixkôt hamaxpẽr prãm kêt kumrẽx. Anẽ. Hãmri nẽ mẽ kãm: —Nà Tĩrtũm nhỹ hã kapẽr jarẽnh o mẽ pa xwỳnhjaja na htem krĩ hkwỳ kamã kãm mẽ mar prãm nẽ. Nom õ krĩ kamã mẽ kot karàre rũm hprêk o mõr kãm omunh xwỳnhjaja na htem kuma nẽ ãm kuma. Anẽ. Hãmri nhũm mẽ kot amnhĩ kaxyw hkôt hamaxpẽr kêt jakamã nhũm tee ri mẽ kãm aa mẽ kot mẽmoj pumunh kêt kwỳ ho anhỹr rax prãm kaprỳ. Nẽ ãm mẽ à xwỳnhjê ho grêre nẽ mẽ hã ĩhkra jaxwỳ nẽ akupỹm mẽ ho mex. Hãmri nẽ mẽ kurũm kato nẽ ma krĩ hkwỳ hkôt ri Tĩrtũm kapẽr o mẽ ahkre ho pa. ");
INSERT INTO apnNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Tã nhũm Jejus amnhĩ wỳr mẽ kot ỹ hã mẽ ahkre ho pa xwỳnh pê 12jê hwỳ. Ra kot amnhĩ kaxyw mẽ rênh xwỳnhtaja nhũm amnhĩ wỳr mẽ kuwỳ. Hãmri nẽ axpẽn kaxyw mẽ ho axkrut nẽ mẽ kurê nẽ mẽ kãm mẽ àpênh ã karõ nẽ ma mẽ hkwỳjê hwỳr mẽ kurẽ. Nẽ mẽ kãm: —E kêr ka mẽ ma mẽ pahkwỳjê hwỳr mra nẽ inhỹ hã Tĩrtũm kapẽr jarẽnh o ri mẽ hkôt apa. Nẽ mẽ kurũm mẽkarõmnuti japôx o ri mẽ hkôt apa. ");
INSERT INTO apnNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","9","Nom kêr ka mẽ amnhĩ kôt akukrêx rax nẽ ri apa hkêt nẽ. Nẽ kawà htu nẽ ho ri apa hkêt nẽ. Nẽ amnhĩ kôt axàpkur xà ho ri apa hkêt nẽ. Rỳ akàxpore rax nẽ ri ho apa hkêt nẽ. Ãm mẽ anhõ kamis nẽ mẽ apar kà ho pixire nẽ agjê nẽ ri hã apa. Nẽ mẽ amnhĩ kaxpar xà hã mẽ anhõ kô pix o apa. Mẽ ã anhỹ kamã mẽ hkôt ri apa anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","—Nẽ kêr ka mẽ nhỹri krĩ hõ hwỳr pôj. Nẽ apôx xà kamã mẽhõ nhõrkwỹ kamã hkôt ri apikamẽnh tãmtã kurũm akupỹm ajapôj nẽ ma hpãnhã nhãm krĩ hõ hwỳr apa. Nom atỳx ri nhãm mẽ hwỳr amrar nẽ nhãm mẽ hwỳr amrar kêt nẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","—Nẽ koja mẽ nhỹri mẽ akapẽr kaga ka mẽ tee ri amnhĩ tã mẽ kamã ama hãmri nẽ tokyx mẽ kurũm ajapôj nẽ ma apa. Nẽ anojarêt nẽ mẽ noo mã akuhê nẽ amnhĩ par ã awjagrô kapĩ. Mẽ kot Tĩrtũm kaga hã amnhĩ pumunh nhũm kot amnhĩ pyrà nẽ mẽ hkaga hã omunh kaxyw ka mẽ ã mẽ noo mã amnhĩ nhĩpêx anẽ. Hãmri nẽ hpãnhã ma nhỹhỹm apa. ");
INSERT INTO apnNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Anhỹr o mẽ kãm mẽ àpênh ã karõ. Nhũm mẽ kuma nẽ hapôj nẽ ma mẽ hkwỳjê hkôt pa. Ma krĩ piitã hkôt Tĩrtũm kapẽr o mẽ ahkre ho ri mẽ hkôt pa nẽ mẽ kãm: —E kwa mẽ tokyx amã ate amnhĩ tomnuj kaga hprãm xàj Tĩrtũm kôt mãn amnhĩ xunhwỳ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Hãmri nẽ mẽ nê mẽkarõmnuti jano. Nẽ akupỹm mẽ à xwỳnhjê ho mex kaxyw mẽmo htwỳm o mẽ hkrã gregrer nẽ Jejus nhỹ hã akupỹm mẽ ho mex. ");
INSERT INTO apnNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Tã nhũm mẽ piitã Jejus jarẽnh ma nẽ axpẽn mã tanhmã harẽnh to ho pa. Nom ahpỹnhã tanhmã harẽnh to. Na prem kamã harẽnh o: —Nà Juãw Paxis pimrààta na. Pẽr akupỹm htĩr jakamã na hte ã mẽ kot aa mẽmoj pumunh kêt kwỳ ho anhỹr o pa. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Nẽ kamã axtem harẽnh o: —Nà tãm kêt. Pẽr finat Eris na. Anẽ. Nẽ kamã axtem harẽnh o: —Nà tãm kêt. Pẽr Tĩrtũm nhỹ hã kapẽr jarẽnh xwỳnhjê hõ na. Te kot amnepê mã mẽ kot Tĩrtũm nhỹ hã tanhmã amnhĩ nhĩpêx to xwỳnhjê kot amnhĩ nhĩpêx pyràk o kot amnhĩ nhĩpêx kênã. Anhỹr o ahpỹnhã harẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Hãmri nhũm Ijaew o amnhĩptàr xwỳnh pê Erox ãxipasja mẽ kot ã harẽnh anhỹr ã mẽ kuma nẽ Juãw Paxis mã hamaxpẽr kurê kumrẽx. Hãmri nẽ mẽ kãm: —Nà pẽr Juãw Paxista na. Ixte mẽ kãm hã ixàmnênh nhũm mẽ kot inhmã mut krãhyr xwỳnhta mãn ra tanhmã amnhĩ to nẽ akupỹm htĩr. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","20","Na pre ra pahi Erox ãxipasja htõ Pirip pê hprõ Eroxis pytà nẽ ho hprõ nhũm hkra niti mẽ wa hwỳr ahpa. Hãmri nhũm Juãw Paxisja tee ri ja hã pahihti Erox ãxipasja pumu nẽ hã kãm akir nẽ kãm: —Tk. Kwa Tĩrtũm kêp ja omnuj. Ra kot ja nê mẽ pahkurê htã ka axtem nẽ ã amnhĩ nhĩpêx anẽ. Anhỹr jakamã nhũm hprõ Eroxisja amnhĩ tã kuma nẽ kamã gryk tỳx nẽ. Nẽ kãm hpĩr prãm nẽ. No nhũm pahi Erox ãxipas kãm hpĩr prãm kêt nẽ. Juãw Paxis kot Tĩrtũm kôt amnhĩ nhĩpêx nhũm kot hã omunh mex jakamã kãm hpĩr prãm kêt nẽ. Juãw na pre hte xatã kãm Tĩrtũm kapẽr jarẽnh o pa. Nhũm pahihti Erox ãxipasja kormã hprĩ hã mar mex kêt tã hã hpijaàm nẽ kãm mar prãm nẽ. Nom nhũm hprõ kãm hpĩr prãm jakamã nhũm kêp mẽ kãm hã amỹnê nhũm mẽ ma o tẽ nẽ haxà nhũm mex nẽ mẽ hagjênh xà kamã hkrĩ ho krĩ. ");
INSERT INTO apnNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","24","Tã nhũm jãã nhũm pahi Erox ãxipas kator ã arĩgro kato nhũm mẽ piitã hwỳr mra nẽ hã akuprõ nẽ hã hkĩnh nẽ hã apkur o hkrĩ. Õ kôwenatôjaja nẽ hkràmnhwỳjaja nẽ krĩ hkwỳ kamã mẽõ pahijaja nhũm mẽ ohtô nẽ hã akuprõ nẽ hã hkĩnh. Hãmri nhũm hprõ Eroxis kra nitija mẽ hwỳr axà nẽ mẽ kãm gre. Mẽ kot omunh nẽ kamã hkurẽ pix kaxyw mẽ noo mã hpijaàm kêt nẽ ã mẽ kãm grer anẽ. Hãmri nhũm pahi Erox omu nhũm ja kãm mex nẽ nhũm mẽ piitã hkĩnh nẽ kamã nopyma nẽ. Nẽ grer kãm hpijaàm kêt nẽ tanhmã mẽ kãm grer to nhũm mẽ omu nẽ kamã no pyma nẽ. Hãmri nhũm pahi Erox ãxipasja kãm: —Nà ãm hãmri. Na ka mẽ inhmã agrer mex nẽ. Jakamã kwa mãmrĩ mẽmoj tã ixwỳ. Amã mẽmoj prãm xà hkôt inhmã mẽmoj jarẽ pa amã kugõ. Ãm hãmri na pa amã amnhĩ jarẽ. Na pa Tĩrtũm noo mã ã amã amnhĩ jarẽnh anẽ. Ka mamrĩ ixkukrêx mex kwỳ hã ixwỳ pu axpẽn mã ho axkjê. E mẽmo na amã hprãm? Anẽ. Hãmri nhũm kuma nẽ ma katorxà hwỳr tẽ nẽ kãm harẽ nẽ kãm: —Xê mẽmoj tã kot paj we kuwỳ? Anẽ. Hãmri nhũm kuma nẽ hamaxpẽr o: —Ma ãm hãmri koja mẽ tã jarãhã inhmã Juãw Paxis pĩ. Anẽ. Hãmri nẽ hkrata mã kãm: —Ma Juãw Paxis krã hã kot kaj awỳ kê mẽ amã kugõ ka man ixwỳr o tẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Hãmri nhũm kuma nẽ akupỹm pahi hwỳr axà nẽ kãm: —Ma Juãw Paxis krã kot kaj inhmã agõ. Pasiiti kamã axà nẽ inhmã agõ pa ma amnhĩm o ixtẽm kurê kumrẽx. Ãm ja pix na inhmã hprãm. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Hãmri nhũm tee ri kuma nẽ hkaprĩ nẽ. Nẽ hamaxpẽr o: —Hêxta waa nẽ. Inhmã hpĩr prãm kêt. Nom ra ixte ixkutã mẽ hkrĩ xwỳnhjê noo mã inhmã kãm mẽmoj prãm xwỳnh nhõr ã amnhĩ jarẽnh nhũm ixte kãm õr ã amnhĩ jarẽnh nhũm mẽ piitã mẽ kot inhmar jakamã tanhmã kot pa we amnhĩ to nẽ kêp nê? Nà pa nê hkêt nẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Hãmri nẽ õ pôristijê mã kãm: —E mẽ ma Juãw Paxis wỳr mra nẽ mut krãhta nẽ pasiiti kamã hkrã xà nẽ akupỹn o tẽ nẽ kãm agõ. Anẽ. Hãmri nhũm mẽ kuma nẽ ma mẽ hagjênh xà hwỳr mra nẽ Juãw wỳr axà hãmri nẽ mut krãhta. ");
INSERT INTO apnNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Hãmri nẽ pasiiti kamã hkrã xà nẽ akupỹm o tẽ nẽ kot hã hwỳr xwỳnh mã kugõ nhũm kumỳ nẽ ma katorxà hwỳr o tẽ nẽ kãm kugõ. ");
INSERT INTO apnNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Hãmri nhũm Juãw Paxis kôt mẽ pa ho mẽ pa xwỳnhjaja tee ri harẽnh ma nẽ hkaprĩ htỳx nẽ. Hãmri nẽ pahi Erox ãxipas wỳr mra nẽ ĩ hã kuwỳ nhũm mẽ kãm kugõ nhũm mẽ kumỳ nẽ ma o mra nẽ kẽn kre kamã haxà. ");
INSERT INTO apnNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Tã hãmri nhũm mẽ kot Jejus nhỹ hã mẽ ahkre ho mẽ pa xwỳnhjaja akupỹn Jejus wỳr mõn pôj nẽ kãm amnhĩ jarẽ. Tanhmã mẽ kot mẽ ahkre hto ho pa nẽ tanhmã mẽ ho mex to ho pa hã kãm amnhĩ jarẽnh pa. ");
INSERT INTO apnNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Tã nhũm mẽ piitã axpẽn pãnhã kot Jejus mar kaxyw mẽ hwỳr mra nhũm mẽ kormã apkur kêt nẽ. Jakamã nhũm Jejus hkôt mẽ pa ho mẽ pa xwỳnhjê mã: —E ma pu mẽ awrã kaprỳ hwỳr mõ nẽ nhỹri pahkrĩ nẽ pakôkôt nẽ apku. ");
INSERT INTO apnNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Anẽ hãmri nhũm mẽ gôx kãm kanôre wỳr agjê nẽ ma ahte xarmã awrã kaprỳ hwỳr mõ. ");
INSERT INTO apnNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Nhũm krĩ hkwỳ nhõ xwỳnhjaja mẽ omu hãmri nẽ nhỹhỹm mẽ mõr xà hã mẽ omunh kurê kumrẽx. Hãmri nẽ krĩ hkwỳ rũm ma mẽ ĩhkrep mra nẽ mẽ kãm amnhĩ to wa nẽ pôj nẽ mẽ kutêp hkrĩ. ");
INSERT INTO apnNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Hãmri nhũm mẽ mõ nẽ mẽ hwỳr pôj nẽ kre kura nẽ kanôre nhô. Hãmri nhũm Jejus mẽ hwỳr api nẽ mẽ omu nẽ hamaxpẽr o: —Hêxta waa nẽ. Na mẽ omnu nẽ pa. Te mẽ kêp ôwêhti jamãr xwỳnh kêt nẽ htỳx ri pa xwỳnh kot amnhĩ nhĩpêx pyràk. Mẽhõ kot mẽ kamã ukaprĩ nẽ tanhmã mẽ ho mex to ho pa? Anẽ. Hãmri nẽ mẽ kamã ukaprĩ nẽ xa nẽ Tĩrtũm kapẽr o mẽ ahkre rax nẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","36","Tã nhũm myt àr kaxyw nhũm hkôt mẽ kot pa ho pa xwỳnhjaja hwỳr mra nẽ kãm: —Kwa hãmri na ra amỹkry htỳx nẽ. Mẽ hano kê mẽ ma nhỹri krĩ hkwỳ hwỳr mra nẽ tokyx amnhĩm mẽmoj japrô nẽ kuku nẽ hikwỹ nẽ gõr. Mo jar kapôt ã mẽ apkur xà? Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Hãmri nhũm mẽ kuma nẽ mẽ kãm: —Kwa nà mẽ kamjaja mẽ kãm mẽmoj gõ kê mẽ kuku. Anẽ. Hãmri nhũm mẽ kuma nẽ tee ri hamaxpẽr nẽ kãm: —Kwa mo mẽ kaxyw mẽ pakàxpore rax? Kot pu mẽ pakàxpore ho 200 nẽ ho mẽ kãm mẽmoj japrôr tã nom nhũm mẽ ãm ho hkryre nẽ kuku nẽ ho õhy htu hkêt nẽ. Mẽ ohtô rax kumrẽx kênã. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Hãmri nhũm mẽ kãm: —Nà kot puj mẽ kãm mẽmoj japrôr kêt nẽ. No mẽ panhõ pãwtita? Tanhmã na arĩ kute? E mẽ atõ tẽ nẽ omu nẽ akupỹn tẽ nẽ inhmã harẽ. Anẽ. Hãmri nhũm ja ma tẽ nẽ omu nẽ akupỹn tẽ nẽ kãm: —Nà pãwti ãm kêp 5 pix. Nẽ kaxyw tep ãm pijakrutre. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Hãmri nhũm Jejus kuma nẽ mẽ kãm: —Tôe. Mẽ kãm anẽ kê mẽ ahpỹnhã ri hije nẽ hkrĩ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Hãmri nhũm mẽ piitã ahpỹnhã kêp 50 nẽ hije nẽ hkrĩ hpa. ");
INSERT INTO apnNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Nhũm Jejus pãwti mẽ tepta jamỳ nẽ kànhmã kaxkwa hwỳr rĩt nẽ Tĩrtũm mã kupẽ nẽ kãm harẽ nẽ kãm: —Pa Papaj? Nà ka na apê mẽ inhmã mẽ inhõ ho apa xwỳnh jakamã amex o amex. Anẽ. Hãmri nẽ mẽ kãm ho hkry hpa nẽ hkôt mẽ pa ho mẽ pa xwỳnhjê mã kugõ nhũm mẽ ô ri ho mra nẽ ho mẽ hipêx pa. Pãwti mẽ tepta nhũm mẽ ho mẽ hipêx pa. ");
INSERT INTO apnNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","44","Nhũm mẽ piitã apkur mex nẽ. Mẽõja mẽ kêp grire htã nhũm Jejus tanhmã mẽ kãm ho rax to nhũm mẽ ohtô rax tã piitã kuku nẽ ho õhy htu hpa. Mẽmyjaja kêp 5.000 nẽ kaxyw mẽ hprõ nẽ mẽ hkrajaja nhũm mẽõja ho mẽ hipêx pa nhũm arĩ hakrêx prã. Jakamã nhũm Jejus kôt mẽ pa ho mẽ pa xwỳnhjaja akupỹm hakrêx o pikuprõnh pa nẽ ho kawà o 12 nẽ ho nỳt. ");
INSERT INTO apnNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","46","Tã nhũm Jejus hkôt mẽ pa ho mẽ pa xwỳnhjê mã kãm: —E mẽ kanôre mã axà nẽ ma akupỹm ixkukamã krĩ pê Petsêj wỳr rê. Pa jajê jano hãmri nẽ ma tẽ nẽ nhỹri Tĩrtũm mã amnhĩ jarẽ nẽ rĩ ma mẽ akôt tẽ. Anẽ. Hãmri nhũm mẽ kuma nẽ kanôre mã gjêx pa nẽ ma mõ nhũm Jejus mẽ kot mar xwỳnhjê janor pa nẽ ma hixêt prêk ã api nẽ Tĩrtũm mã amnhĩ jarẽnh o nhỹ. ");
INSERT INTO apnNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Tã nhũm kamàt nhũm arĩ ahte kỳxpê nhỹ. Nhũm hkôt mẽ pa ho mẽ pa xwỳnhjaja kormã kanôre kamã mõ. ");
INSERT INTO apnNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Hãmri nhũm Jejus amỳm mẽ omu nhũm kôk ra mẽ kutã àpêr tỳx kumrẽx nhũm mẽ tee ri amnhĩ nhĩpêx nẽ tee ri rrẽmti ho gô rẽnh nhĩpêx o hkrĩ. Tã nhũm ra krãhyre kà nhũm Jejus Tĩrtũm mã amnhĩ jarẽnh pa nẽ kànhmã xa nẽ ma mẽ hkôt tẽ. Nom kanôre kamã htẽm kêt nẽ gô krãhkà hã xa nẽ mẽ hwỳr hpar o tẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","50","Hãmri nẽ mẽ hwỳr kato nẽ mẽ kamã hamak kaxyw hêx rom kot mẽ hakrenh mã. Nhũm mẽ amnhĩ wỳr omu nẽ mẽkarõ hã hkamnhĩx nẽ tee ri amnhĩ kukamã hamaxpẽr nẽ umaj htertet nẽ àmra rax nẽ. Hãmri nhũm mẽ kãm: —Tk. Kwa mẽ amã ma hkêt nẽ. Pa na pa mẽ akôt tẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Hãmri nẽ mẽ hwỳr kanôre hkrem axà nhũm kôk xàpêr tỳxta hapêx. Hãmri nhũm mẽ Jejus kamã no pyma nẽ tee ri hamaxpẽr nẽ axpẽn mã: —Kokỹỹ. Tanhmã na we amnhĩ to nẽ gô krãhkà hã hpar o man mẽ pahkôt tẽ mẽ pahwỳr àr mẽ nhũm kôk hapêx par kurê kumrẽx. Anẽ. Hãmri nẽ tee ri kot ã amnhĩ nhĩpêx anhỹrja kukamã hamaxpẽr o hkrĩ. ");
INSERT INTO apnNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Kormã mẽ kot hprĩ hã Jejus tanhmã kute hã omunh kêt jakamã. Tĩrtũm pyrà nẽ àhpumunh o àhpumunh ã omunh mex kêt jakamã tee ri pãwti grêre ho mẽ hipêx par nẽ gô krãhkà hã htẽm nẽ kôk o pinhkrênh ã omu nẽ tee ri ã kot amnhĩ nhĩpêx anhỹrja kukamã hamaxpẽr. ");
INSERT INTO apnNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Tã nhũm mẽ xarmã rê nẽ krĩ pê Jenẽjare hwỳr pôj. Hãmri nẽ kanôre nhô ");
INSERT INTO apnNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","nẽ api nẽ kuhê nhũm krĩ nhõ xwỳnhjaja Jejus pumunh kurê kumrẽx nẽ axpẽn mã: —Kwa pẽr Jejusta na mõ. Nà tãm kênã. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Hãmri nẽ hkĩnh nẽ ma kape hã mẽ à xwỳnhjê hkôt mrar kurê kumrẽx nẽ mẽ harir xà rãhã mẽ hamỳ nẽ akupỹm Jejus wỳr mẽ o mra. Nhỹri hpôx xà kamã omu nẽ hwỳr mẽ o mra. ");
INSERT INTO apnNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Na pre htem ã Jejus nhĩpêx anẽ. Jakamã nhũm hte ma nhỹhỹm mra. Krĩ rũnh kôt mra nẽ krĩ hkryre hkôt mra nhũm mẽ omu nẽ hwỳr mẽ à xwỳnhjê ho mra nẽ mẽ ho kuwỳ nẽ kãm: —Pa? Kwa kê jajaja akupỹm mex kaxyw apê axê pix kupê nà? Anẽ. Hãmri nhũm mẽ kãm: —Tôe. Nà kwãr mẽ mãmrĩ hkupê. Anẽ. Hãmri nẽ mẽ kot kêp ê kupênh xwỳnh piitã akupỹm mex pa. ");
INSERT INTO apnNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","4","Tã nhũm Mojes kapẽr o mẽ ahkre o mẽ pa xwỳnh kwỳjaja Jerujarẽ rũm Jejus wỳr mõ. Hãmri nẽ hã akuprõ nẽ hkôt mẽ pa ho mẽ pa xwỳnhjê kot amnhĩ nhĩpêx ã mẽ omunh o kuhê. Ijaew na prem mẽ hkukamã mẽ higêtjê kapẽr kôt ri tanhmã amnhĩ nhĩpêx to ho pa. Jakamã mẽ uràk nẽ apkur kaxyw nẽ xatã amnhĩ nhĩhkra kuhõnh japjê nẽ rĩ kormã apku. No mẽ amnhĩ nhĩhkra grã pix kuhõnh nẽ hkrĩ nẽ apkur kêt nẽ. Kuhõnh japjê nẽ kormã hkrĩ nẽ apku. Tĩrtũm kot ja hã mẽ omunh nẽ amnhĩm mẽ mex ã mẽ harẽnh ã amnhĩ kamnhĩx jakamã na prem ã amnhĩ nhĩpêx anhỹr o pa. Nẽ nhỹri amnhĩm mẽõ hkwỳ japrô nẽ akupỹm õrkwỹ hwỳr o mra nẽ haxwỳ nẽ mẽ higêt pyrà nẽ wỳr japjê rũnh kumrẽx nẽ rĩ kormã apku. Nẽ mẽ uràk nẽ poti nẽ gôj nẽ papêre hkre kahõnh japjê rũnh nẽ rĩ kormã kamã õ nhĩpêx. Mẽ higêt pyrà nẽ ã amnhĩ nhĩpêx anhỹr o pa. Tĩrtũm kot ja hã mẽ omunh nẽ amnhĩm mẽ mex ã mẽ harẽnh prãm xàj. Nom nhũm Jejus kôt mẽ pa xwỳnhjaja na prem ã amnhĩ nhĩpêx anhỹr kêt nẽ. Na prem apkur kaxyw nẽ katàt kôt amnhĩ nhĩhkra kuhõ nẽ àmnhĩx apkur o hkrĩ. Jakamã nhũm Parijew nhõ xwỳnh mẽ Tĩrtũm kapẽr tũm o mẽ ahkre xwỳnhjaja tee ri ã mẽ kot amnhĩ nhĩpêx anhỹr ã mẽ omu nẽ mẽ hã Jejus kukja nẽ kãm: ");
INSERT INTO apnNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","—Pa Jejus? Kwa mẽ inhmã mẽmoj jarẽ. Amnepêm mẽ panhĩgêtjaja na pre htem apkur kaxyw nẽ amnhĩ nhĩhkra kuhõnh japjê rũnh kumrẽx nẽ arĩ kormã hkrĩn apku. Jakamã na pa htem mẽ uràk nẽ ã amnhĩ nhĩpêx anẽ. No akôt mẽ pa ho mẽ pa xwỳnhjaja na htem ho mẽ ixpyrà kêt nẽ. Kwa mo na htem ã amnhĩ nhĩpêx anhỹr kêt nẽ? Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Hãmri nhũm mẽ kuma nẽ mẽ kãm amnepêm Tĩrtũm nhỹ hã kapẽr xwỳnh pê Ijais kapẽr jarẽ nẽ mẽ kãm: —Nà ãm hãmri na pre finat Ijaisja amnepêm tanhmã mẽ ajarẽnh to. Te Tĩrtũm tãm kapẽr pyràk o mẽ ajarẽ nẽ mẽ ajarẽnh o: Mẽ kãm ixkĩnh ã amnhĩ jarẽnh tã mẽ kãm ixkĩnh kêt. Na htem ãm kãm ixprãm ã amnhĩ jarẽnh kaprỳ. ");
INSERT INTO apnNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Mẽ kot ixkapẽr kuhpa hã amnhĩ krã hkôt mẽmoj tã hkwỳjê mã karõ ho pa jakamã na htem ãm kot ixkôt amnhĩ nhĩpêx ã amnhĩ jarẽnh kaprỳ. Anẽ. Ã na pre mẽ ajarẽnh anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","9","ãm hãmri na pre mẽ ajarẽ. Na ka htem mẽ panhĩgêt kapẽr kôt pix mã amnhĩ nhĩpêx o apaja gryk ã ra Tĩrtũm kapẽr kaga hpa. Te mẽ akapẽr mex o kot Tĩrtũm kapẽr jakrenh pyràk. ");
INSERT INTO apnNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Na pre finat Mojes Tĩrtũm nhỹ hã mẽmoj tã mẽ pamã karõ ho: Ker ka mẽ anhĩpêêxà nẽ mẽ akatorxà wa hã apijaàm o ri apa. Jao wa kutã anojarêt rãhã nẽ. Nom kot kaj mẽ ho mex hkêt nẽ tanhmã mẽ kãm akapẽr punuj to hãmri nhũm mẽ akwỳjaja ja mỳrapê mẽ apa. Anẽ. Na pre ã finat Mojesja Tĩrtũm nhỹ hã mẽ pamã karõ anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","No mẽ kajaja na ka mẽ axtem nẽ tanhmã akwỳjê mã ja hã karõ hto nẽ mẽ kãm: “Kot kaj mẽ mẽmo arĩgro hã akàxpore hkwỳ nom anhĩpêêxà ho ajuta kaxyw kãm hkwỳ nhõr kêt nẽ. Ãm wa kãm ate ho ajuta kêt ã amnhĩ jarẽ hãmri nẽ Tĩrtũm mã amnhĩ jarẽnh xà hã ixkre hwỳr mãn o tẽ nẽ mẽ ixte ixkre ho mex kaxyw mẽ inhmã agõ. Kot kaj mẽ ã amnhĩ nhĩpêx anẽ nhũm Tĩrtũm ja hã mẽ apumu nhũm ja kãm mex nẽ. E kêr ka mẽ ã amnhĩ nhĩpêx anhỹr o ri apa.” Anhỹr o na ka htem akwỳjê mã karõ. ");
INSERT INTO apnNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Jao mẽ kot mẽ hipêêxà nẽ mẽ katorxà ho ajuta nê mẽ hkurê. ");
INSERT INTO apnNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Te mẽ amã mẽ panhĩgêt kapẽr mex o kot Tĩrtũm kapẽr jakrenh pyràk o na ka htem amnhĩ nhĩpêx. Jao te Tĩrtũm kapẽr mex kêt pyràk o hipêx nẽ mar kêt nẽ apa. Ã na ka htem Tĩrtũm kapẽr kuhpa hã amnhĩ nhĩpêx anhỹr o ri apa. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Tã nhũm Jejus Parijew nhõ xwỳnhjê mẽ hkwỳjê mã kapẽr pa hãmri nẽ amnhĩ wỳr ra mẽ kot mar o kuhê xwỳnhjê mã hpa ho apê nẽ mẽ kãm: —E pa mẽ amã mẽmoj jarẽ ka mẽ inhma nẽ inhmar mex nẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","16","Na hte Tĩrtũm kapẽr tũm o mẽ ahkre xwỳnhjaja amnhĩ krã hkôt mẽ ate amnhĩ nhĩhkra kuhõnh japjê hã mẽ amã karõ ho pa. Nẽ amnhĩ krã hkôt mẽ axàpkur xà hã tanhmã mẽ amã karõ hto ho pa. Mẽ ate ã amnhĩ nhĩpêx anhỹr nhũm Tĩrtũm kot ja hã mẽ apumunh kôt amnhĩm mẽ amex ã mẽ ajarẽnh kaxyw nhũm htem ã mẽmoj tã mẽ amã karõ anẽ. Nom na hte Tĩrtũm tanhmã mẽ panhĩhkra kuhõnh to hã mẽ pahpumu nẽ ãm hã mẽ pa hpumu. Nẽ mẽmo mẽ paxàpkur xà hã mẽ pahpumu nẽ ãm hã mẽ pahpumu. Ja kãm tanhmã kute hkêt. Na hte ja hã mẽ omunh xà hkôt amnhĩm mẽ mex ã mẽ harẽnh rỳ mẽ mex kêt ã mẽ harẽnh kêt nẽ. Rỳ mẽ hakwa ho mẽmoj kur ã mẽ omunh xà hkôt tanhmã mẽ harẽnh to hkêt nẽ. Ãm mẽ hakwa ho tanhmã kapẽr to pix ã mẽ mar kôt na hte tanhmã mẽ harẽnh to. Anhỹr o mẽ kãm kapẽr. ");
INSERT INTO apnNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Hãmri nẽ mẽ kot mar o kuhê xwỳnhjê re nẽ hkôt mẽ pa ho mẽ pa xwỳnhjê mẽ mẽ amnhĩm hikranh xà hã ixkre hwỳr agjê. Hãmri nhũm hkôt mẽ pa ho mẽ pa xwỳnhjaja tee ri Jejus kot tanhmã mẽ hakwa jarẽnh to hã kuma nẽ hã hkukja nẽ kãm: —Kwa mon ka ri mẽ inhmã ã ja jarẽnh anẽ? Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Hãmri nhũm mẽ kãm: —Kwa xàn ka mẽ kormã aprĩ hã ja mar mex kêt nẽ? E pa ixprĩ hã mẽ amã harẽ ka mẽ inhma. Nà mẽ apkur xà na hte mẽ hkrã hi kamã mẽ hamaxpẽr wỳr gjêx kêt nẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Na hte ãm mẽ õhy pix wỳr agjê nẽ gaa nẽ nhãm hapôj nẽ hapêx. Na htem mẽ apkur xà nhỹ hã tanhmã amnhĩ tomnu to hkêt nẽ. Jakamã na hte Tĩrtũm mẽ apkur xà hã mẽ omunh xà hkôt tanhmã mẽ harẽnh to hkêt nẽ. Anẽ. Nhũm pre ã mẽ kãm kapẽr anhỹr o mẽ paxàpkur xà piitã mex ã harẽ. Jakamã na hte Tĩrtũm krajaja àmnhĩx mẽmoj piitã hkur o pa nẽ kãm mẽmoj kur pyma hkêt nẽ. Jakamã nhũm Jejus ã mẽ kãm kapẽr anẽ nẽ mẽ kãm: ");
INSERT INTO apnNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","—Mẽ hkrã hi kamã mẽ hamaxpẽr punuj pix nhỹ hã na htem tanhmã amnhĩ tomnuj to. Jakamã na hte Tĩrtũm tanhmã mẽ hamaxpẽr to ho pa hã mẽ omunh xà hkôt tanhmã mẽ harẽnh to. Nom mẽ kot mẽmoj kur ã mẽ omunh xà hkôt rỳ mẽ ĩhkra kuhõnh japjê hã mẽ omunh xà hkôt tanhmã mẽ harẽnh to hkêt nẽ. Ja tanhmã kêp kute hkêt. ");
INSERT INTO apnNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","22","Nom koja mẽhõ hamaxpẽr punuj nẽ ra hkôt tanhmã amnhĩ tomnuj to. Jao axpẽn kamã hpijaàm kêt nẽ. Rỳ mẽhõx pĩ rỳ mẽ kêp ahkĩ. Rỳ mẽ kêp mẽ hprõ rỳ mẽhkuprỳ ho amnhĩkati. Rỳ ri axpẽn pê õxỳ. Rỳ tanhmã hkwỳjê homnuj to. Rỳ tanhmã mẽ ho kapẽr punuj to. Rỳ hêx rom mẽ no kupyr o ri pa. Rỳ mẽmoj tã amnhĩ to jarkrar o pa. Rỳ axpẽn kukrêx pumu nẽ kãm ho õ hprãm xàj hã õ xwỳnhta kamã gryk. Rỳ htỳx ri tanhmã amnhĩ nhĩpêx to. Mẽ hamaxpẽr punuj jakamã na htem ã ri amnhĩ nhĩpêx anhỹr o pa. ");
INSERT INTO apnNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Tã ã mẽ kot amnhĩ nhĩpêx anhỹr ã mẽ omunh xà hkôt na hte Tĩrtũm mẽ kot amnhĩ tomnuj xwỳnh hã mẽ harẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Tã nhũm Jejus mẽ hkôt mẽ pa ho mẽ pa xwỳnhjaja nhỹhỹm nojarêt hãmri nẽ krĩ rũm hapôj nẽ ma krĩ pê Xir pu hã ri pa. Hãmri nhũm Jejus hkwỳjê mã: —E kwa pu mẽ tokyx ixkre mũj wỳr mõ mẽ kuri pôj nẽ kamã amnhĩm hikra. Pu mẽ pahpôx tokyx anẽ kê krĩ nhõ xwỳnhjaja mẽ pahpôx ã mẽ pahpumunh kêt nẽ. Anhỹr tã nom nhũm mẽ piitã mẽ harẽnh ma nẽ mẽ hã akuprõ. ");
INSERT INTO apnNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","Nhũm mẽhõ ni haxwỳja Jejus hpôx ã harẽnh ma nẽ ma hwỳr tẽ. Nom kêp Ijaew kêt axtem Gres nhõ xwỳnh na pre. Pika pê Sir kamã krĩ mẽ kot kãm “Wẽnĩs” anhỹr xwỳnh kamã na pre kato. Nhũm pre mẽkarõmnuti kêp hkra ni mã axà. Hãmri nhũm õ mãmãj tee ri omu nẽ ra Jejus hpôx ã harẽnh ma nẽ ma hwỳr tẽ. Hãmri nẽ hwỳr axà nẽ hparpê hkõnkrã ho htẽm nẽ nhỹ nẽ kãm: —Xê Pahihti. Inhmã ixkra nê mẽkarõmnuti jano kê ma tẽ kê akupỹm inhmã mex. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Hãmri nhũm kãm: —Nà kormã. Na pre Tĩrtũm taxy kormã Ijaewjê pix wỳr inhmẽ. Jakamã na pa kormã nhãm mẽ akwỳjê hõ tanhmã mẽ ato mex to hkêt nẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Hãmri nhũm tee ri amnhĩ tã kuma nẽ kãm: —Ma ãm hãmri na ka ja jarẽ. Ixpê Ijaew kêt tã nom mẽ kuxwar we ixto mex grire kêt wehe. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Hãmri nhũm kãm: —Nà ãm hãmri na ka ã akra kaxyw inhmã ajamaxpẽr tỳx anẽ. Jakamã kot paj nê mẽkarõmnutita jano. Koja axte tanhmã apê ho hkêt nẽ. E ma akupỹm hwỳr tẽ nẽ omu. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Hãmri nhũm kuma nẽ ma akupỹm õrkwỹ hwỳr tẽ nẽ omu. Nhũm ra mẽkarõmnutija kêp kato nẽ ma tẽ nhũm akupỹm tãm hkrã nẽ hkĩnh nẽ par kãm hkôkôt o nõ. ");
INSERT INTO apnNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Tã nhũm Jejus mẽ hkôt mẽ pa ho mẽ pa xwỳnhjaja krĩ pê Xir rũm hapôj nẽ akupỹm gô rax pê Garirej wỳr ma mra. Pyka pê Sitõ jakre nẽ mõ nẽ pyka pê Tekap jakre. ");
INSERT INTO apnNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Hãmri nẽ kormã hpôx o mõr rôm nhũm mẽ amnhĩ wỳr Jejus pumu nẽ hwỳr mẽhõ myja o tẽ. Kapẽr krok nẽ umar kêt xwỳnhta nhũm mẽ wỳr o tẽ nẽ kãm: —Pa? Ot pa mẽ awỳr ixkràmnhwỳta o tẽ. Kwa hã anhĩhkra xi kê akupỹm mẽ inhmã mex. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Hãmri nhũm omu nẽ hpa hã kupy nẽ mẽ kêp o kato nẽ nhỹri mẽ hkàx ã o xa. Nẽ akutã hamak kre kupê nẽ argôx mẽ nẽ ho õhto htok. ");
INSERT INTO apnNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Hãmri nẽ kaxkwa hwỳr rĩt nẽ htyk xà mẽnh tỳx nẽ kãm kapẽr. Mẽ pakapẽr kãm kãm: “E ajamak katêr nẽ anhõhto kaxkrit.” Anẽ. Nom kapẽr kãm kãm: “Epata.” Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Hãmri nhũm hamak katêr nẽ õhto kaxkrit kurê kumrẽx nẽ tãm kapẽr nẽ tãm ama. ");
INSERT INTO apnNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","37","Hãmri nhũm mẽ kot omunh xwỳnhjaja amnhĩ jaêr pê Jejus kot ho mex ã omu nẽ kamã no pyma nẽ. Hãmri nhũm mẽ kãm: —Kwa kêr ka mẽ akwỳjê mã ja hã ijarẽnh kêt nẽ. Anhỹr tã no nhũm mẽ kuma nẽ ãm kuma nẽ ma mẽ piitã mẽ kãm harẽnh o ri hprõt nẽ mẽ kãm: —Kwa Jejus na mex o mex. Na hte mẽ ho mex o pa nhũm mẽ umar kêt xwỳnhjaja akupỹm tãm ama nhũm mẽ kapẽr kêt xwỳnhjaja akupỹm tãm kapẽr. Ãm hãmri na hte ã mẽ hipêx anhỹr o pa. Nà ãm mex o mex. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","2","Tã nhũm arĩgro hõ hã nhũm mẽ ohtô nẽ nhỹri kapôt ã Jejus ã htu rax nẽ kot mẽ ahkre mar o kuhê hã apkati axkrunẽpxi. Nhũm mẽ apkur xà hã mẽõja ra mẽ kêp hapêx. Hãmri nhũm Jejus ja hã mẽ omu hãmri nẽ hkôt mẽ pa ho mẽ pa xwỳnhjê mã akir nẽ mẽ kãm hpa ho apê nẽ mẽ kãm: —E mẽ amnẽ ixwỳr mra nẽ ixkapẽr ma. Anẽ. Nhũm mẽ hwỳr mra nẽ kuhê nhũm mẽ kãm: —Kwa na pa inhmã mẽ kot inhmar o kuhê xwỳnhjê kaprĩ nẽ. Na mẽ ra mẽ pahkôt ri pa hã apkati axkrunẽpxi nhũm mẽ apkur xà hã mẽõja mẽ kêp hapêx. ");
INSERT INTO apnNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Mẽ õ krĩ hwỳr awry jakamã koja mẽ mẽmoj kur kêt rãhã ma akupỹm pa hãmri nẽ pry hã hirot nẽ rôrôk o pa. Hãmri pa inhmã mẽ hkaprĩ nẽ. Anẽ ");
INSERT INTO apnNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Hãmri nhũm mẽ kuma nẽ axte tee ri hamaxpẽr nẽ kãm: —Kwa nà nhỹhỹnh kot puj kêt mẽ kãm mẽmoj to mra? Jar ãm kapôt pix kênã. Anẽ. Hãmri nhũm mẽ kãm: ");
INSERT INTO apnNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","—Nà tanhmã na mẽ anhõ pãwtija kute? Anẽ. Nhũm mẽ kãm: —Ãm kêp 7 pix. Nẽ kaxyw tep kwỳ no ãm grêre. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Hãmri nhũm mẽ kuma nẽ mẽ kot mar o kuhê xwỳnhjê mã anẽ nhũm mẽ kuma nẽ hkrĩ pa. Hãmri nhũm pãwti jamỳ nẽ ho Tĩrtũm wỳ nẽ kãm: —Pa Papaj. Nà ka na apê mẽ inhmã mẽ inhõ ho apa xwỳnh. Jakamã amex o amex. Ãm amex kumrẽx. Anẽ. Hãmri nẽ mẽ kãm ho hkry pa nẽ hkôt mẽ pa ho mẽ pa xwỳnhjê mã kugõ nhũm mẽ ho mẽ hipêx pa. ");
INSERT INTO apnNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Nhũm hpãnhã tepta py nẽ mã ho anẽ nẽ ho Tĩrtũm wỳ. Hãmri nẽ hkôt mẽ pa ho mẽ pa xwỳnhjê mã kugõ nhũm mẽ mã ho anẽ nẽ hamỳ nẽ ho mẽ hipêx pa. ");
INSERT INTO apnNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","9","Hãmri nhũm mẽ ohtô rax kumrẽx tã piitã apku nẽ õhy htu pa. Mẽmyjaja kêp 4.000 nẽ kaxyw mẽ hprõjaja nẽ mẽ hkrajaja. Tã nhũm Jejus mẽ apkur xàja o mẽ hipêx pa. Nhũm hkôt mẽ pa ho mẽ pa xwỳnhjaja hakrêx o akuprõ nẽ ho kawà ho 7 nẽ ho nỳt. Hãmri nhũm Jejus ma akupỹm mẽ õ krĩ hwỳr mẽ kot mar xwỳnhjê jano nhũm mẽ ma akupỹm hapêx. ");
INSERT INTO apnNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Hãmri nhũm Jejus hkôt mẽ pa ho mẽ pa xwỳnhjê mẽ ro hã kanôre hkrem agjê nẽ mẽ hkwỳm ma Tamanut wỳr mõ. ");
INSERT INTO apnNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Tã nhũm mẽ Tamanut wỳr pôj nhũm Parijew nhõ xwỳnh kwỳjaja Jejus pumu nẽ ma hwỳr mra nẽ mẽmoj tã kuwỳ nẽ kãm: —Pa. Ot pa mẽ awỳr mra. Kwa mẽ inhmã aa mẽ ixte mẽmoj pumunh kêt õ ho anẽ. Pa mẽ ja hã apumu nẽ Tĩrtũm kot mẽ ixwỳr amẽnh ã akôt ijamaxpẽr kurê kumrẽx. E tokyx. Anẽ. Kot tee ri mẽ kãm mẽmoj to anhỹr kaxyw nẽ ho anhỹr kêt nhũm mẽ kot hã omunh nẽ ma hkwỳjê mã ho kapẽr punuj kaxyw nhũm mẽ ã hêx rom kãm kapẽr anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Nhũm ra kãm mẽ kot amnhĩ kaxyw hkôt hamaxpẽr kêt kãm ã kapẽr anhỹr mar kaga nẽ. Hãmri nẽ tee ri amnhĩ tã mẽ hamaxpẽr ã mẽ omu nẽ htyk xà mẽnh tỳx nẽ mẽ kãm: —Hêxta waa nẽ. Mẽ ajamaxpẽr punuj pix o na ka htem ri ajamaxpẽr o apa. Ixpê Tĩrtũm kot mẽ awỳr inhmẽnh xwỳnh tã ka mẽ ja hã ixkôt ajamaxpẽr kêt nẽ. Nà mo kaxyw kot pa kêt mẽ amã mẽmoj to anẽ? Kot paj ho anẽ ka mẽ omu nẽ ãm omu nẽ ixkôt ajamaxpẽr kêt nẽ. Nà kot paj mẽ amã mẽmoj to anhỹr kêt nẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Hãmri nẽ mẽ kure nẽ hkôt mẽ pa ho mẽ pa xwỳnhjê mẽrohã ma mra nẽ akupỹm kanôre hkrem agjê nẽ ma xarmã mõ. ");
INSERT INTO apnNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Tã nhũm mẽ kormã kanôre kamã xarmã mõr rôm nhũm Jejus kôt mẽ pa ho mẽ pa xwỳnhjaja tee ri mẽ apkur xà japêr nẽ axpẽn mã: —Kwa hêxta waa nẽ. Na pu mẽ panhõ pãwti re nẽ amnhĩ kôt o pamõr kêt nẽ. Nẽ ãm pixire nẽ o mõ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Hãmri nhũm Jejus tee ri mẽ kuma nẽ tanhmã hã mẽ kãm kapẽr to. Nom mẽmoj tã kuxi nẽ mẽ kãm awjarẽ nẽ mẽ kãm: —Kwa oko kêr ka mẽ amnhĩ nê Parijew nhõ xwỳnh mẽ Pahi Erox nhõ pãw kaxkrit xà pumunh mex nẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Hãmri nhũm mẽ kuma nẽ tee ri kapẽrja kukamã hamaxpẽr pê hã axpẽn kukjêr o hkrĩ nẽ axpẽn mã: —Kwa mo na ri ã mẽ pamã pãw kaxkrit xà jarẽnh anẽ? Mãn mẽ panhõ pãwti hkêt ã mẽ pahpumu hã na ri ã harẽnh anẽ nà? Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Hãmri nhũm Jejus mẽ kapẽr ã mẽ kuma nẽ mẽ kãm: —Kwa mon ka wem ãm xatã axpẽn mã mẽ panhõ pãwti hkêt jarẽnh pix o mõ? Xàn pa hte mẽ apyrà nẽ tee ri mẽ paxàpkur xà hkêt kukamã ijamaxpẽr o ixpa? Nà inhmã ja tanhmã kute hkêt. ");
INSERT INTO apnNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Ra mẽ ano ho mẽ ate ixpumunh mex tã kormã aprĩ hã tanhmã ixkute hã ixpumunh mex kêt. Nẽ mẽ ajamak o ixkapẽr mar mex tã aprĩ hã mar tỳx kêt. Kwa wem ixte amnhĩ nhĩpêx mã ajamaxpẽr tỳx nẽ. E mẽ inhmã mẽmoj jarẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Jãã ixte mẽ kêp 5.000 mã pãwti kêp 5 nhĩrênhta. Tanhmã na ka prem hakrêx o akuprõ nẽ ho kawà ho nỳt to? E mẽ atõ inhmã harẽ. Anẽ Hãmri nhũm ja kãm: “Na pa prem ho kawà ho 12 nẽ ho nỳt.” Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Nhũm kuma nẽ mẽ kãm: —Tỳ na pre hakrêx ã kawà kêp 12. Tã ham ixte mẽ kêp 4.000 mã pãwti kêp 7 nhĩrênhta. Tanhmã na ka prem hakrêx ho akuprõ nẽ ho kawà ho nỳt to? Anẽ. Nhũm ja kãm: “Na pa prem ho 7.” Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Hãmri nhũm kuma nẽ mẽ kãm: —Tỳ ra ixte mẽ anoo mã ã ja ho anhỹr o axkrut tã ka mẽ ra hã ano hkêt nẽ arĩ axpẽn mã mẽ panhõ pãwti hkêt pix jarẽnh o ixkôt mõ. Kormã mẽ ate ixàhpumunh tỳx ã ixpumunh kêt. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Tã nhũm mẽ ma krĩ pê Pesêj wỳr mõ nẽ ra hwỳr pôj. Hãmri nhũm krĩ nhõ xwỳnh kwỳjaja mẽ omu nẽ Jejus wỳr mẽhõ myja o tẽ. Ra nohkre nẽ rĩt kêt nẽ pa xwỳnhja nhũm mẽ hpa hã kupyn hwỳr o tẽ. Hãmri nẽ ho kuwỳ nẽ kãm: —Pa Pahihti? Ot pa mẽ awỳr ja ho tẽ. Kwa hã anhĩhkra xi nẽ akupỹm mẽ inhmã no ho mex. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Hãmri nhũm mẽ kuma nẽ nohkre xwỳnhta pumu nẽ hpa hã kupy nẽ o tẽ nẽ krĩ pê ho kato nẽ nhỹri mẽ hkàx ã o xa. Hãmri nẽ no hã argôx mẽ nẽ hã ĩhkra xi nẽ kãm: —E mãn ka mẽmoj pumu nà? Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Hãmri nhũm kuma nẽ hkrãkato nẽ ri rĩt hãmri nẽ kãm: —Tỳ na pa mẽmoj pumu. Nom ixprĩ hã omunh mex kêt nẽ. Te mẽmo pĩ hpàr kwỳ ri mrar pyràk. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Hãmri nhũm axte no hã ĩhkra xi nhũm tã rĩt mex nẽ. Ri hprĩ hã mẽmoj piitã omunh mex nẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Hãmri nhũm Jejus akupỹm õrkwỹ hwỳr kumẽ nẽ kãm: —E kêr ka kape hã ri amrar kêt nẽ. Ãm ma ma akupỹm anhõrkwỹ hwỳr atẽm kurê kumrẽx. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Tã hãmri nhũm Jejus ma hkôt mẽ pa ho mẽ pa xwỳnhjê mẽ mẽ ma mõ. Ma krĩ pê Sejarej Piripos pu hã krĩ hkwỳ hkôt mõ. Nẽ kormã pry hã mõ nhũm Jejus amnhĩ tã hkôt mẽ pa ho mẽ pa xwỳnhjê kukja nẽ mẽ kãm: —Kwa mẽ inhmã mẽmoj jarẽ. Tanhmã na htem ahpỹnhã ri axpẽn mã ijarẽnh to wehe? Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Hãmri nhũm mẽ kãm: —Nà na htem ahpỹnhã tanhmã ajarẽnh to. Na hte kamã mẽ hkwỳjaja axpẽn mã ato finat Juãw Paxis ã ajarẽ. Nẽ kamã mẽ hkwỳjaja ato finat Eris ã ajarẽ nẽ mẽ hkwỳjaja apê Tĩrtũm nhỹ hã kapẽr o pa xwỳnh ra htyk xwỳnhjê hõ hã ajarẽ. Ã na htem ahpỹnhã axpẽn mã ajarẽnh anhỹr o pa. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Hãmri nhũm mẽ kuma nẽ mẽ kãm: —No we mẽ kajaja? Ixpê mẽhõ hã na ka htem axpẽn mã ijarẽ? Anẽ. Hãmri nhũm Simãw Pêtre kãm: —Nà mẽ pajaja na pa htem apê Tĩrtũm kot mẽ ixkaxyw axãm nẽ mẽ ixwỳr amẽnh xwỳnh ã ajarẽ. Nẽ apê mẽ ixpiitã mẽ inhõ Pahi Maati hã ajarẽ. Ã na pa htem axpẽn mã ajarẽnh anẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Hãmri nhũm kuma nẽ mẽ kãm: —Nà ãm hãmri na ka htem ã ijarẽnh anẽ. Ã ixte anhỹr. Kwa nom kwa kêr ka mẽ inhma. Kêr ka mẽ kormã ã akwỳjê mã ijarẽnh anhỹr kêt nẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Tã nhũm Jejus amnhĩ kukamã hkôt mẽ pa ho mẽ pa xwỳnhjê mã tanhmã amnhĩ jarẽnh to nẽ mẽ kãm: —Nà ra mẽ ate Tĩrtũm kot mẽ akaxyw ixãm ã ixpumunh mex. No mẽ pahkwỳjaja kãm ja hã ijarẽnh mar nẽ ixpumunh prãm kêt. Ijaew krãhtũmjê mẽ Tĩrtũm kapẽr tũm o mẽ ahkre o mẽ pa xwỳnhjê mẽ patre krãhtũmjaja na mẽ kãm ja hã ixpumunh prãm kêt. Jakamã koja mẽ nhỹrmã ixpynê nẽ ixtak rax nẽ ixpĩ. Nom kot paj ixtyk ã ixtã apkati axkrunẽpxi hãmri nhũm Tĩrtũm akupỹm ixto ixtĩr. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Hãmri nhũm mẽ kot hpĩr ã amnhĩ jarẽnh ma nẽ tee ri hkukamã hamaxpẽr. Hãmri nhũm Simãw Pêtreja hwỳr tẽ nẽ hkwỳjê pê ho kato nẽ mẽ hkàx ã o xa nẽ kãm: —Kwa nà Pahihti. Koja Tĩrtũm anê mẽ omunh mex nẽ nhũm mẽ ã anhĩpêx anhỹr kêt nẽ. Kwa ri ã kapẽr anhỹr kêt nẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Hãmri nhũm kuma nẽ hwỳr apkjê nẽ pu hã hkôt mẽ pa ho mẽ pa xwỳnh piitã omu. Hãmri nẽ mẽ hamak mã Simãw Pêtre mã kapẽr nẽ kãm: —Tk. Kwa na ka ã inhmã akapẽr anhỹrja o te Satanasti nhỹ hã akapẽr pyràk. Tĩrtũm nhỹ hã na ka ã inhmã akapẽr anhỹr kêt nẽ. Ãm jar mẽ kãm Tĩrtũm kapẽr mar prãm kêt xwỳnhjê jamaxpẽr o na ka ajamaxpẽr nẽ ã inhmã akapẽr anẽ. No Tĩrtũm jamaxpẽr o ajamaxpẽr kêt nẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Tã nhũm Jejus amnhĩ wỳr mẽ kot mar o kuhê xwỳnhjê mẽ hkôt mẽ pa ho mẽ pa xwỳnhjê mã anẽ nhũm mẽ hwỳr axkamẽ nẽ kuhê. Hãmri nhũm tanhmã mẽ ahkre hto nẽ mẽ kãm: —E mẽ inhma. Kot kaj mẽ ixkôt amnhĩ xunhwỳr ã amnhĩ jarẽ hã kot kaj mẽ mããnẽn amnhĩ jarẽnh o: “Jejus kêp inhõ Pahihti jakamã kot paj ãm kapẽr kôt pix mã amnhĩ nhĩpêx rãhã ho ri ixpa. Kwãr ixkwỳjaja tanhmã hã inhĩpêx to pa arĩ hkôt amnhĩ nhĩpêx rãhã ho ixpa.” Anhỹr o amnhĩ jarẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","—Koja mẽ ixtã mẽ atõx pĩ rỳ ixtã tanhmã mẽ ato ka ty. Ate tanhmã ijarẽnh to ho apa hã nhũm mẽ apĩ. Tã nom koja akaxwỳnh ma inhõ krĩ hwỳr àpir kurê kumrẽx nẽ kamã atĩr tũm nẽ amex rãhã nẽ apa ho apa. Nom kot kaj mẽ jar atĩr prãm xàj ixkaga hãmri nẽ hwỳr axàpir kêt nẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","37","—Nẽ koja mẽhõ hikukrêx gryk ã Tĩrtũm kaga. Hãmri nẽ nhỹrmã ty nẽ ỹ kamã kuwy hwỳr ma mõ nẽ amnhĩ kôt kukrêx õ hpyr nẽ o mõr kêt nẽ. Koja tee ri kuwy hwỳr mõr pymaj amnhĩ nê hikukrêx rax o amnhĩ pãnhã amnhĩrer prãm kaprỳ. Tanhmã koja amnhĩ to nẽ Tĩrtũm mã amnhĩre nẽ ma õ krĩ hwỳr api? Koja ã amnhĩ nhĩpêx anhỹr kêt nẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","—Nẽ koja mẽhõ ixte mẽ ahkre hã inhma nhũm ja kêp omnuj japêr. Nhũm kot mẽ kãm ixprãm nõkati xwỳnhjê hkôt pa gryk ã ixkaga. Hã kot paj nhỹrmã mẽ ato amnhĩptàr kaxyw akupỹn wrỳ nẽ amnhĩ xwar kot ixkaga xwỳnhta kaga. Ãm hãmri na pa mẽ amã ja hã amnhĩ jarẽ. Kot paj nhỹrmã inhõ Papaj nhỹ hã ixte mẽ ho amnhĩptàr kaxyw akupỹn wrỳ nhũm kapẽr o mẽ wrỳk xwỳnhjaja man ixkôt wrỳ. Pa mẽ wrỳ hãmri nẽ ra mẽ kot ixkaga xwỳnhjaja pa amnhĩ pyrà nẽ amnhĩ xwar mẽ hkaga hpa. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Nhũm Jejus arĩ mẽ kãm kapẽr nẽ mẽ kãm: —Ãm hãmri na pa mẽ amã amnhĩ jarẽ. Kot paj nhỹrmã akupỹn ixte mẽ ato amnhĩptàr kaxyw mẽ awỳr wrỳ kãm ga. Tã kot kaj mẽ akwỳjaja kormã atĩr ri ja kukamã tanhmã ixte amnhĩ nhĩpêx to hã ixpumu. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Tã nhũm arĩgro kêp 6 nẽ hapêx nhũm Jejus ma nhỹri hixêt prêk wỳr tẽ. Nẽ Simãw Pêtre nẽ Xiakre nẽ Juãwja nhũm ma amnhĩ kôt wa mẽ o mõ. Nhũm wa mẽ ahte mõ nẽ hixêt prêk ã api nẽ himõk ã kuhê. Hãmri nhũm Jejus axtem nẽ xa. ");
INSERT INTO apnNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Ra ê haka htỳx kumrẽx nẽ xa. ");
INSERT INTO apnNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Hãmri nhũm ja wa kaxkwa rũm hwỳr wrỳ nẽ kuri kãm kapẽr. Finat Mojes mẽ finat Erisja wa wrỳ nẽ kuri kãm kapẽr o xa. Tĩrtũm amnepêm amnhĩ wỳr wa ho àpir tã nhũm wa akupỹn wrỳ nẽ kãm kapẽr. ");
INSERT INTO apnNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","6","Nhũm wa mẽ mex kumrẽx nẽ hirã htỳx kãm kuhê nhũm Jejus kôt mẽ mõr xwỳnhjaja wa mẽ omu nẽ mẽ kamã no pyma nẽ. Nẽ tee ri mẽ kãm tanhmã kapẽr to hkukamã hamaxpẽr. Hãmri nhũm Simãw Pêtre hamaxpẽr nẽ Jejus mã kãm: —Kwa Pahihti. Nà ãm hãmri na pu mẽ amnẽ mõ. Kwa pu mẽ kritpêm jar axkamẽ nẽ tokyx panojarêt kêt nẽ. Pa mẽ amã pô nhĩrõnh o axkrunẽpxi nẽ hipêx. Amã nẽ Mojes mã nẽ Eris mã hõ nhĩpêx ka mẽ kamã akrĩ. Kwa xàt pa mẽ amã ho anẽ nà? Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Hãmri nhũm kakrã jaka htỳx wrỳ nẽ wa mẽ hkunor pa nhũm wa mẽ kamã kuhê. Hãmri nhũm kakrã kamã Tĩrtũm mẽ kãm kapẽr nẽ mẽ kãm: —Ota Ixkra xa. Inhmã hapê ho inhmã hapê. Kêr ka mẽ kapẽr mar tỳx rãhã ho ri apa. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Hãmri nhũm mẽ kuma nẽ amnhĩ pu hã rĩt nhũm ãm Jejus pix mẽ kuri xa nhũm Mojes mẽ Erisja wa ra ma akupỹm api nhũm mẽ ãm Jejus pix pumu. ");
INSERT INTO apnNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Hãmri nhũm mẽ ma akupỹm hkwỳjê hwỳr wrỳk o mõ nhũm Jejus mẽ kãm: —Kwa kêr ka mẽ ham mẽ ate mẽmoj pumunh xwỳnhta kormã nhãm mẽ kãm harẽnh kêt nẽ. Koja mẽ mẽmo arĩgro hã ixpĩ hãmri nhũm Tĩrtũm akupỹm ixto ixtĩr ka mẽ rĩ kormã mẽ kãm ja hã ijarẽnh o ri apa. ");
INSERT INTO apnNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Anẽ hãmri nhũm mẽ kuma nẽ mẽ kãm harẽnh kêt nẽ. Ãm axpẽn mã pix mã harẽ nẽ kot akupỹm htĩr ã amnhĩ jarẽnhja ã axpẽn kukjêr o pa nẽ axpẽn mã: —Kwa mo na ri ã akupỹm htĩr ã amnhĩ jarẽnh anẽ? Tanhmã kot we amnhĩ to nẽ htyk tã akupỹm htĩr? Anẽ. Hãmri nẽ tee ri hkukamã hamaxpẽr o hkôt pa. ");
INSERT INTO apnNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Hãmri nhũm mẽ kormã ahpar mã wrỳk o mõr mẽ nhũm Jejus kôt mẽ mõr xwỳnhjaja mẽmoj tã hkukja nẽ kãm: —Kwa mẽ inhmã mẽmoj jarẽ. Na hte Tĩrtũm kapẽr tũm o mẽ ahkre xwỳnhjaja mẽ inhmã: “Eris kumrẽx koja Tĩrtũm mẽ pahwỳr kumẽ nhũm Krisja hapu hã wrỳ.” Anẽ. Na htem ã mẽ inhmã war ajarẽnh anẽ. Tã ka na ka ra wrỳ nom nhũm kormã Erisja akukamã wrỳk kêt nẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","13","Hãmri nhũm mẽ kãm: —Nà ãm hãmri na htem mẽ amã ã ja jarẽnh anẽ. Na pre ra ixkukamã te kot Eris kot amnhĩ nhĩpêx pyràk xwỳnhta tẽ nẽ ixkutêp mẽ kãm ijarẽnh o pa. Nom mẽ kot ixkukamã ijarẽnh xwỳnh ã omunh kêt jakamã na prem axtem nẽ kãm tanhmã hipêx to hprãm xà hkôt tanhmã hipêx kati hton kupĩ. Tã koja mẽ ã hipêx anhỹr pyrà nẽ mã ixto anẽ nẽ inhĩpêx kati nẽ tokyx mẽ kãm ixprãm kêt xwỳnhjaja ixpynê nẽ ixpĩ pa amnhĩ xà htỳx kamã ijamak kãm ty. Tĩrtũm kapẽr ã kagà htũm kot wa ijamẽ wa ixkukamã wa ijarẽnh xà hkôt. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Hãmri nhũm Jejus nẽ Simãw Pêtre nẽ Xiakre nẽ Juãwja mẽ akupỹm hkwỳjê hwỳr hpôx o mra nẽ amnhĩ kukamã hkwỳjê pumu nhũm mẽ ohtô nẽ mẽ hã akuprõ nẽ mẽ kãm kapẽr. Nhũm Tĩrtũm kapẽr tũm o mẽ ahkre ho mẽ pa xwỳnhjaja mẽmoj tã mẽ hkukjêr o kuhê. ");
INSERT INTO apnNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Jakamã nhũm Jejus mẽ hwỳr hpôx o tẽ nhũm mẽ pikuprõnh xwỳnhjaja amnhĩ wỳr omu nẽ hkĩnh nẽ. Hãmri nẽ kutã hprõt nẽ kãm: —Pa. Nà ãm hãmri na ka akupỹn mẽ ixwỳr tẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Hãmri nhũm mẽ kãm: —Kwa mẽmoj tã na ka mẽ axpẽn mã axàkjêr o akuhê? Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","18","Hãmri nhũm mẽhõ myja kãm: —Nà ixkra hã na pa mẽ axpẽn mã ixkapẽr. Na pre mẽkarõmnuti ixpê hwỳr axà nẽ tanhmã ixpê ho nhũm kapẽr kêt nẽ pa. Nhũm hte xatã tanhmã ixpê ho nhũm pykap amnhĩ rẽ nẽ hakwa jamrô ho hikwỹ. Hãmri nẽ à htỳx kamã ama nẽ amnhĩ nham o axpẽn kamnhar tỳx kumrẽx pê htỳx pa nẽ hikwỹ nẽ ixpê omnuj tỳx nẽ. Na hte ã mẽkarõmnuti nhỹ hã amnhĩ nhĩpêx anhỹr o pa. Jakamã na pa ate inhmã ho mex kaxyw man o tẽ nẽ tee ri ajapêr. Hãmri nẽ ho akôt mẽ pa ho mẽ pa xwỳnhjê hwỳ nhũm mẽ kot inhmã ho mex kaxyw tee ri tanhmã ho hkaprỳ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Hãmri nhũm Jejus kuma nẽ hkôt mẽ pa ho mẽ pa xwỳnhjê mã kãm: —Hêxta waa nẽ. Ra mẽ ate Tĩrtũm nhỹ hã ixte mẽ ho mex ã ixpumunh ryy htã ixpyrà nẽ ã amnhĩ nhĩpêx anhỹr kêt nẽ. Mãn ka mẽ kormã kaxyw Tĩrtũm kôt ajamaxpẽr tỳx kêt nẽ. E amnẽ ixwỳr akra ho tẽ pa omu. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Hãmri nhũm mẽ hwỳr o tẽ nhũm mẽkarõmnuti Jejus pumu nẽ tanhmã hkrata o htỳx to nhũm pykap tẽm nẽ hakwa jamrô nẽ amnhĩ rẽnh o nõ. ");
INSERT INTO apnNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Nhũm Jejus omu nẽ hipêêxà mã: —Kwa tanhmã na ra kot amnhĩ nhĩpêx ã mytwrỳ kute? Anẽ. Nhũm kãm: —Nà hprĩre rũm na hte ã amnhĩ nhĩpêx anhỹr o pa. ");
INSERT INTO apnNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Na hte mẽkarõmnuti xatã ixpê hpĩr kaxyw kuwy kamã kurẽ nẽ gôx kãm kurẽ. Kwa kot ka ate ho mex kukamã axàhpumunh japêr nẽ wa ixkamã axukaprĩ nẽ akupỹm inhmã ho mex. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Hãmri nhũm Jejus kãm: —Xàn ka tee ri ixte ho mex kaxyw ixkukamã ajamaxpẽr? Nà ixte mẽmoj piitã ho anhỹr kaxyw ixàhpumunh tỳx kênã. Kot ka mẽ atõ mẽmoj tã amnhĩ kaxyw ixkôt ajamaxpẽr tỳx hã kot paj amã ho anẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Hãmri nhũm kuma nẽ kãm hkra mex prãm tỳx xàj kapẽr tỳx nẽ kãm: —Nà na pa amnhĩ kaxyw akôt ijamaxpẽr. Nom kot kaj tanhmã ixkrã hto pa akôt ijamaxpẽr tỳx rãhã ho ri ixpa Pahihti. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Rôm nhũm mẽ ohtô rax nẽ hwỳr kormã mra nhũm Jejus amnhĩ wỳr mẽ omu hãmri nẽ mẽkarõmnutija mã kapẽr kurê kumrẽx. Nẽ kãm kapẽr kãm hihtỳx nẽ kãm: —Pa mẽkarõmnuti. E apê mẽ ho mẽ kapẽr kêt nẽ mẽ umar kêt o apa xwỳnh ã pa amã ixkapẽr ka inhma. Kêr ka mẽ hkrata pê akato nẽ ma amõr o mõ nẽ axte tanhmã ho hkêt nẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Hãmri nhũm tee ri kot kãm karõja ma nẽ gryk xàj xatã amỹra nẽ mẽ hkrata o htỳx kumrẽx nhũm htertet tỳx o nõ. Hãmri nhũm kêp kato nẽ ma tẽ nhũm te htyk pyrà nẽ nõ nhũm mẽ tee ri omu nẽ ra htyk ã hkamnhĩx. ");
INSERT INTO apnNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Hãmri nhũm Jejus hpa hã kupy nẽ kànhmã ãm nhũm akupỹm mex nẽ kànhmã xa nẽ ri mra. Nẽ tãm kapẽr o mra nẽ umar mex nẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Tã nhũm Jejus hkôt mẽ pa ho mẽ pa xwỳnhjê mẽrohã ma akupỹm amnhĩm hikranh xà hã ixkreja wỳr mra nẽ hwỳr agjê nẽ hkrĩ. Hãmri nhũm Jejus kôt mẽ pa ho mẽ pa xwỳnhjaja amnhĩ tã hkukja nẽ kãm: —Kwa mẽ inhmã mẽmoj jarẽ Pahihti. Na pa mẽ tee ri axwakre kamã mẽ hkrata nê mẽkarõmnuti janor kaprỳ. Kwa mon pa mẽ apyrà nẽ ja ho anhỹr mex kêt nẽ? Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Hãmri nhũm mẽ kãm: —Nà axtem na mẽkarõmnuti ja. Na htem mẽ nê hanor tokyx anhỹr kêt nẽ. Na htem ho Tĩrtũm wỳr tỳx nẽ rĩ kormã hano. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","31","Tã nhũm Jejus mẽ hkôt ri mẽ pa ho pa xwỳnhjê mẽ krĩja rũm hapôj nẽ ma nhãm mõ. Nẽ ma pyka pê Garirej kahti hkôt mõ. Nom mẽ piitã mẽ hkàx ã mõ. Jejus kormã kot amnhĩ tã tanhmã hkôt mẽ pa ho mẽ pa xwỳnhjê jahkre hto ho pa jakamã kãm mẽ hkàx ã mẽ o pa hprãm nẽ. Hãmri nẽ amnhĩ kukamã mẽ kãm tanhmã amnhĩ jarẽnh to nẽ mẽ kãm: —E kot paj mẽ amã tanhmã amnhĩ jarẽnh to ka mẽ inhma nẽ inhmar tỳx nẽ. Koja mẽ kãm ixprãm kêt xwỳnhjaja tokyx mẽ kãm ixtã amỹnê nhũm mẽ ixpĩ. Kot paj ixtyk ã ixtã apkati axkrunẽpxi hãmri nhũm Tĩrtũm akupỹm ixto ixtĩr. Kwa kêr ka mẽ ja ma nẽ hã anohtỳx nẽ ho apa. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Hãmri nhũm mẽ tee ri ã kot amnhĩ jarẽnh anhỹrja ma nẽ axpẽn mã: —Kwa mo na ri ã mẽ pamã amnhĩ jarẽnh anẽ? Nà kêp mẽ panhõ Pahi Maati hã kot amnhĩ jarẽnh kênã kot kêt mẽhõ kupĩ. Anhỹr o axpẽn mã harẽnh o hkôt mõ. Hãmri nẽ ã kot amnhĩ jarẽnh anhỹr mar prãm kêt jakamã hprĩ hã tanhmã hkukjêr to hkêt nẽ. Ãm akryk hkôt mar o mõ. ");
INSERT INTO apnNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","34","Tã nhũm Jejus mẽ hkôt mẽ pa ho pa xwỳnhjaja kormã ma krĩ pê Kapanaũ hwỳr mõ nhũm hkôt mẽ pa ho mẽ pa xwỳnh pê 12jaja tanhmã amnhĩ kukamã hamaxpẽr to hãmri nẽ axpẽn mã: —Kwa mẽ pahtõ kot puj we nhỹrmã pahpê pahi nẽ mẽ ho amnhĩptàr rax o ri pahkwỳjê jakre? Anhỹr o axpẽn kukjêr o Jejus kôt mõ. Nẽ axpẽn mã: “Nà pa.” Nhũm mẽ hkwỳjaja: “Nà kêt pa.” Anhỹr o hkôt mõ. Hãmri nhũm Jejus mẽ mar o mõ. Hãmri nhũm mẽ mõ nẽ nhỹri amnhĩm hikranh xà hã ixkre hwỳr pôj nẽ hwỳr agjê nhũm mẽ kãm: —Kwa mẽmoj tã na ka mẽ pry hã amnhĩ jarẽnh o mõ? Anẽ. Hãmri nhũm mẽ tee ri kuma nẽ hpijaàm nẽ. Nẽ kãm tanhmã amnhĩ jarẽnh to hkêt nẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Jakamã nhũm Jejus nhỹ nẽ mẽ kãm anẽ nhũm mẽ kuri hkrĩ pa nhũm mẽ kot mẽ kãm mẽ ho amnhĩptàr rax prãmta ã mẽ kãm kapẽr nẽ mẽ kãm: —E mẽ inhma. Ka mẽ atõ amã mẽ ho amnhĩptàr rax prãm. Hã kêr ka te apê mẽ piitã mẽ kãm amarĩ axàpênh xwỳnh pyràk o amnhĩ nhĩpêx o mẽ hkôt apa. Jao mẽmoj to mẽ kutã anojarêt rãhã nẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Hãmri nẽ amnhĩ wỳr mẽhprĩre hõ mã hpa ho apê nhũm hwỳr tẽ nhũm kumỳ nẽ o nhỹ nẽ hã mẽ kãm kapẽr nẽ mẽ kãm: ");
INSERT INTO apnNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","—E mẽ inhma. Kêr ka mẽ apê pahi pyràk o tanhmã amnhĩ jarẽnh to ho ri apa hkêt nẽ. Ãm te amarĩ ri mẽ apa pyràk o amnhĩ nhĩpêx o ri apa. Jao nhỹri mẽhprĩre hõ pumu nẽ kamã axukaprĩ nẽ kãm mẽmoj tanhmã ho rỳ kãm mẽmoj gõ. Hãmri nẽ ã amnhĩ nhĩpêx anhỹr o te pa ate tanhmã ixto mex to pyràk o amnhĩ nhĩpêx. Nẽ kot ka mẽ atõ pa tanhmã ixto mex to nẽ te ate Tĩrtũm o mex pyràk o amnhĩ nhĩpêx. E kêr ka mẽ amã amnhĩ to rũnh prãm nẽ ã amnhĩ nhĩpêx anhỹr o ri apa. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Hãmri nhũm Juãw nhỹhỹnh tẽn mẽ hwỳr axà nẽ Jejus mã: —Kwa Pahihti. O mũj mẽhõ kêp mẽ pahkwỳ hkêt tã anhỹ hã mẽ nê mẽkarõmnuti janor o pa. Pa mẽ tee ri ja hã omu nẽ kêp mẽ pahkwỳ hkêt jakamã pa mẽ ã kot amnhĩ nhĩpêx anhỹrja nê kãm ixkapẽr. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","40","Hãmri nhũm kuma nẽ kãm: —Kwa nà nê tanhmã kãm nẽ hkêt nẽ. Koja mẽhõ inhỹ hã aa mẽ kot mẽmoj pumunh kêt kwỳ ho anẽ hãmri nẽ kêp mẽ panhĩõ nẽ ri mẽ pahkwỳm tanhmã mẽ ahkre hto ho pa hkêt nẽ. Ra mẽ pahkôt kot amnhĩ nhĩpêx mã kênã. Jakamã kwa mẽ ja nê tanhmã kãm nẽ hkêt nẽ. Kwãr mãmrĩ ã amnhĩ nhĩpêx anẽ. Ja mex kênã. ");
INSERT INTO apnNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","—Koja mẽhõ nhỹri mẽ atõ amã kôr ã apumu nẽ hamaxpẽr o: “Kwa Jejus kôt ri pa xwỳnh mũj kãm kôr. E pa kãm gô hkwỳ kê ho ixkõ.” Anhỹr o hamaxpẽr nẽ apê ixkwỳ hã amã gô hkwỳ ka ho ixkõ. Nhũm ãm kot amã gô pix nhõr nhũm ate ho akõm tã nhũm Tĩrtũm atã omu nẽ ho mex rax nẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Nhũm Jejus arĩ hkôt mẽ pa ho mẽ pa xwỳnhjê mã kapẽr nẽ mẽ kãm: —Nẽ mẽ kot ixkôt amnhĩ xunhwỳr tohtuj anhỹr xwỳnhjaja. Koja mẽhõ ma mẽ hwỳr tẽ nẽ inhnê mẽ kãm kapẽr. Mẽ kot mẽ mar nẽ tanhmã amnhĩ tomnuj to hprãm xàj hêx rom mẽ kãm kapẽr nhũm mẽ mar xà hkôt tanhmã amnhĩ tomnuj to. Hã koja Tĩrtũm ja hã omu nẽ kot inhnê tanhmã kãm nẽ xwỳnhta pumu nẽ homnuj tỳx nẽ. Te mẽ kot mẽhõ pynênh nẽ mut ã kẽn pytĩĩ hõ nhôr nẽ ma o htẽm nẽ gô xupỳm rax kãm mẽnh pyràk o hipêx. Te ho ja pyràk no ãm homnuj tỳx o hakre. ");
INSERT INTO apnNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","47","—E kwa mẽ o kora. Kot kaj mẽ anhĩhkra rỳ apar o tanhmã amnhĩ tomnuj to. Hã kêr ka mẽ axte ã amnhĩ nhĩpêx anhỹr pymaj te ate amnhĩ pê anhĩhkra rỳ apar krãhyr nẽ mẽnh pyràk o amnhĩ nhĩpêx nẽ axte ã amnhĩ tomnuj anhỹr kêt nẽ. Rỳ ka mẽ ano ho mẽmoj punuj pumu. Hãmri nẽ kãm ajamaxpẽr pix o apa pymaj te ate amnhĩ pê ano katõk nẽ mẽnh pyràk o amnhĩ nhĩpêx nẽ nhãm arĩt kurê kumrẽx. Kêr ka mẽ ã amnhĩ nhĩpêx o apa rãhã nẽ. Hãmri nẽ nhỹrmã ty nẽ ma Tĩrtũm mẽ wa inhõ krĩ hwỳr api. No kot ka mẽ arĩ akutã ano nẽ arĩ akutã apar nẽ arĩ akutã anhĩhkra rãhã ri mrar tã tõhã tanhmã ho amnhĩ tomnuj to. Hãmri nẽ nhỹrmã ty nẽ ma mẽ kot amnhĩ xà htỳx kamã hamak tũm xà pê kuwy maatita wỳr ma apa. ");
INSERT INTO apnNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Kuwyja kamã na htem mẽ kot amnhĩ tomnuj mỳrapê amnhĩ xà htỳx kamã hamak rãhã ho pa ho pa hãmri nẽ aa hapôx kêt nẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","ã koja mẽ kot amnhĩ tomnuj o mẽ pa xwỳnh piitã amnhĩ nhĩpêx anhỹr rãhã nẽ pa ho pa. ");
INSERT INTO apnNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Jakamã kwa kêr ka mẽ axpẽn to mex rãhã ho ri apa. Nom axpẽn kãm agryk nẽ tanhmã axpẽn nhĩpêx to ho ri apa hkêt nẽ. Anẽ. Nhũm pre ã Jejus hkôt ri mẽ pa ho mẽ pa xwỳnhjê jahkre anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Tã nhũm Jejus mẽ hkôt mẽ pa ho pa xwỳnh mẽrohã ma pyka pê Jutej wỳr mõ. Hãmri nẽ pyhti pê Jotãw ã rê nẽ hpãnhã ma xarmã mõ. Nhũm mẽ axte mẽ hã akuprõ nhũm kê Jejus axte mẽ ahkre ho xa. ");
INSERT INTO apnNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Hãmri nhũm Parijew nhõ xwỳnh kwỳjaja hwỳr mra. Mẽ kot hêx rom kamã hamak nẽ mar nẽ tanhmã ho kapẽr punuj to kaxyw hwỳr mra nẽ kãm: —Pa. Ot pa mẽ mẽmoj tã akukjêr kaxyw awỳr mra. Kwa tanhmã na pre amnepêm finat Mojesja mẽ pahte mẽ pahprõ kaga hã mẽ panhĩgêtjê mã karõ hto? Xà koja mẽ pahprõ mẽ pakapẽr hkwỳm tanhmã amnhĩ nhĩpêx to pu mẽ mỳrapê hkaga nhũm Tĩrtũm ja hã mẽ pahpumu nhũm ja kãm mex nẽ nà? Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Hãmri nhũm mẽ kãm: —Tanhmã na pre Mojes Tĩrtũm nhỹ hã ja hã mẽ amã karõ hto? Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Nhũm mẽ kãm: —Nà na pre harẽnh o: Kêr ka mẽ aprõ kaga kaxyw hãmri nẽ ate hkaga hã amnhĩ jarẽnh ã kagà nẽ kãm agõ nẽ rĩ kormã hkaga. Anẽ. Na pre ã mẽ inhmã ja hã karõ anẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Hãmri nhũm mẽ kãm: —Tỳ nom mẽ kãm Tĩrtũm kapẽr kôt amnhĩ nhĩpêx prãm kêt jakamã na pre ã mẽ kãm ja jarẽnh anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Amnepêm mẽmoj piitã hkrax kãm na prem axpẽn kaga hkêt nẽ. Na pre Tĩrtũm wam myja nhĩpêx nẽ hpãnhã kãm hprõ nhĩpêx. Axpẽn kaxyw wa hipêx. ");
INSERT INTO apnNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Jakamã na hte mẽmyjaja hprõ kaxyw nẽ gryk ã katorxà nẽ hipêêxà wa hkaga nẽ ãm hprõ kôt pix mã pa ho pa. ");
INSERT INTO apnNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Te wa tipxi nẽ ri wa pa pyràk o axpẽn nhĩpêx o pa. ");
INSERT INTO apnNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Tĩrtũm tãm kot axpẽn mã wa õr kênã kot kêt mẽhõ wa kot axpẽn kaga kaxyw tanhmã wa hipêx to rỳ tanhmã wa kãm kapẽr to. Anẽ. Nhũm pre ã Jejus mẽ kãm kapẽr anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Hãmri nẽ hkôt mẽ pa ho mẽ pa xwỳnhjê mẽ akupỹm ixkrem agjê nhũm mẽ kãm: —Kwa aprĩ hã mẽ inhmã mẽ kot axpẽn kaga hã mẽ harẽnhta jarẽ pa mẽ ixprĩ hã kuma nà. Anẽ. Hãmri nhũm mẽ kãm: ");
INSERT INTO apnNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","—Nà kot kaj mẽ aprõ kaga nẽ hpãnhã nhãm mẽhõ ho aprõ nhũm Tĩrtũm noo mã te ate wam aprõ kamã nhãm aprõ nyw o amnhĩkati pyràk. Tĩrtũm pê ja omnuj tỳx nẽ. Rỳ koja mẽhõ hprõ kaga ka hpãnhã ho aprõ nhũm Tĩrtũm noo mã te ate wam mjên pê ho amnhĩkati pyràk. Ja mããnẽn Tĩrtũm pê omnuj tỳx nẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","—Nẽ mẽnijaja. Koja mẽhõ ni ra mjên kaga nẽ hpãnhã nhãm mẽhõ ho mjên. Ja mex kêt. Mjên krax kêp mjên kumrẽx kênã kot kêt hkaga nẽ hpãnhã nhãm hõ ho mjên. Koja anẽ nhũm Tĩrtũm noo mã te kot wam mjên kamã nhãm hõ ho amnhĩkati pyràk nhũm Tĩrtũm pê ja omnuj tỳx nẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Tã nhũm Ijaew kwỳjaja Jejus wỳr mẽ hkrarejê jamỳ nẽ mẽ o mra. Kot mẽ hã ĩhkra jaxwỳr nẽ mẽ ho Tĩrtũm wỳr kaxyw hwỳr mẽ o mra. Hãmri nhũm hkôt mẽ pa ho pa xwỳnhjaja tee ri ja hã mẽ omu nẽ mẽ kãm: —Kwa mo kaxyw na ka mẽ Jejus wỳr mẽ o mra? Kormã mẽ ràxre kênã. Mẽ ma akupỹm mẽ o mra nà? Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Hãmri nhũm Jejus ja hã mẽ kuma nẽ mẽ kãm: —Kwa nà kwãr mẽ mãmrĩ ixwỳr mẽ o mra. Mẽ ri inhnê mẽhprĩjê kurê hkêt nẽ. Anẽ. Hãmri nẽ mẽ kãm hpa ho apê nhũm mẽ hwỳr mẽ o mra nhũm mẽ kuri kuhê. Hãmri nhũm mẽ hã hkôt mẽ pa ho mẽ pa xwỳnhjê mã kãm: —E mẽ jarejê pumu. Na htem hamakêtkati nẽ hkĩnh nẽ ri pare. Mẽ kãm amnhĩ to rũnh prãm kêt nẽ ri pare. Tã Tĩrtũm kôt mẽ kot amnhĩ nhĩpêx o ri mẽ pa xwỳnhjaja na htem mẽ uràk nẽ kãm amnhĩ to rũnh prãm kêt nẽ ri pa. ");
INSERT INTO apnNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","—Na hte jarejaja hipêêxà nẽ katorxà wa kapẽr ma nẽ wa hkôt ri amnhĩ nhĩpêx o ri pare. Tã ixpê Tĩrtũm kot mẽ awỳr inhmẽnh xwỳnh na pa. Kot ka mẽ amã ixkôt amnhĩ xunhwỳr prãm hã kot kaj mẽ jarejê kot amnhĩ nhĩpêx pyràk o amnhĩ nhĩpêx. Jao ixkapẽr ma nẽ ixkôt ri amnhĩ nhĩpêx mex o ri apa. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Hãmri nẽ mẽhprĩrejê jamỳ nẽ mẽ hã ĩhkra jaxwỳ nẽ mẽ ho Tĩrtũm wỳ nẽ kãm: —Pa Papaj. E kêr ka jarejê ho mex rãhã nẽ kê mẽ mex nẽ pa. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Tã nhũm Jejus mẽ hkôt mẽ pa ho pa xwỳnhjaja nhỹri pry hã mõ nhũm Ijaew krãhtũmja omu nẽ hwỳr tẽ nẽ mẽmoj tã hkukja nẽ kãm: —Pa mẽ ijahkre xwỳnh maati? E kwa inhmã mẽmoj jarẽ. Nhỹrmã Tĩrtũm ri ixtĩr tũm nẽ ixpa hprãm xàj mẽmo kot pa we ho anhỹr o ri ixpa? Ate amnhĩ to mex pix o ri apa xwỳnh jakamã kwa inhmã tanhmã ja jarẽnh to. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Hãmri nhũm kãm: —Xà ate ixpê Tĩrtũm kwỳ hã ixpumunh kôt na ka ixte uràk nẽ amnhĩ to mex xwỳnh ã ijarẽ? Tĩrtũm pix na kot amnhĩ to mex rãhã xwỳnh jakamã kot kaj ã ijarẽnh anẽ nẽ ixpê Tĩrtũm Kra hã ijarẽ. Jao uràk nẽ ixte amnhĩ to mex xwỳnh ã ijarẽ. Nà xàn ka ãm atỳx ri amnhĩ krã hkôt ã ijarẽnh anẽ? ");
INSERT INTO apnNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","—Tĩrtũm mex o mex jakamã kot kaj amã nhỹrmã kuri atĩr tũm nẽ apa hprãm hãmri nẽ ra kot mẽmoj tã mẽ amã karõ xà hkôt amnhĩ nhĩpêx o ri apa. Ra ate mar mex kênã. Na pre mẽ amã: Kêr ka mẽ axàhkĩnh o ri apa hkêt nẽ. Nẽ mẽ hpar kêt nẽ. Nẽ tanhmã axêx kêt nẽ. Nẽ axêx rom tanhmã mẽ nokupyr to hkêt nẽ. Nẽ mẽ kêp mẽ hprõ ho amnhĩkati hkêt nẽ. Nẽ anhĩpêêxà mẽ akatorxà wa hã apijaàm nẽ wa ho mex pê wa kutã anojarêt rãhã ho ri apa. E kot kaj amã nhỹrmã Tĩrtũm kuri atĩr tũm nẽ apa hprãm hã kot kaj ã amnhĩ nhĩpêx anhỹr o ri apa. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Hãmri nhũm kuma nẽ kãm: —Kwa ixprĩre ri ra ã ixte amnhĩ nhĩpêx anhỹr o ri ixpa kênã. Nom te ixtĩr tũm nẽ ixpa kaxyw ixte kormã tãm kêt pyràk. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Hãmri nhũm kuma nẽ hprĩ hã omu nẽ kãm hapê nẽ. Hãmri nẽ kãm: —Nà kormã mẽmoj pyxire nẽ arĩk. Na ka amã akukrêx rax kĩnh tỳx o Tĩrtũm jakre. Jakamã kêr ka ma akupỹm anhõrkwỹ hwỳr tẽ nẽ akukrêx rax o wẽnê hpa. Nẽ kàxpore jamỳ hãmri nẽ ma mẽ kêp amrakati xwỳnhjê mã õr o ri apa. Hãmri nẽ akupỹn tẽ nẽ arĩ ri ixkôt apa ho apa. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Hãmri nhũm kuma nẽ tee ri hikukrêx rax kukamã hamaxpẽr. Kãm hapê jakamã kãm kãm ĩhkra karo hprãm kêt nẽ. Hãmri nẽ tee ri Jejus kot ã kãm hã karõ anhỹrja ma nhũm ja kãm mex kêt nhũm awjanã nẽ hkaprĩ nẽ ma akupỹm tẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Hãmri nhũm Jejus tee ri omu nẽ hkôt mẽ pa ho mẽ pa xwỳnhjê mã kãm: —Hêxta waa nẽ. Koja mẽ hikukrêx rũnh xwỳnhjaja ohtô nẽ kãm mẽ hikukrêx japê xàj Tĩrtũm mẽ wa ixri htĩr tũm nẽ pa ho pa hkêt nẽ. Wa ixte amnhĩ nhĩpêxja mẽ kêp hihtỳx. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Hãmri nhũm mẽ tee ri kapẽrja ma nhũm Jejus mẽ hamaxpẽr kôt mẽ omunh mex jakamã axte tanhmã mẽ kãm harẽnh to nẽ mẽ kãm: —Nà Tĩrtũm mẽ wa ixte amnhĩ nhĩpêxja na mẽ hikàxpore rũnh xwỳnhjaja pê ja hihtỳx. ");
INSERT INTO apnNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Mẽ kãm hikukrêx rax mã ĩhkra karo hprãm kêt rãhã tee kãm Tĩrtũm kôt amnhĩ nhĩpêx prãm kaprỳ. Te ho mẽhõ kot menh kagô hã hkre nẽ kãm kagô katõk prãm kêt rãhã kãm guhkrax kãm àr prãm kaprỳta pyràk. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Hãmri nhũm mẽ kuma nẽ tee ri amnhĩ kukamã hamaxpẽr nẽ kãm: —Kwa no mẽ ixpiitã mẽ inhmã mẽ ixkukrêx japê kênã. Jakamã xà kot paj mẽ ixpiitã nhỹrmã war ari ixtĩr tũm nẽ ixpa ho ixpa hkêt nẽ? Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Hãmri nhũm mẽ kãm: —Nà kot kaj mẽ amnhĩ krã hkôt mẽ amã mẽ akukrêx japê mã anhũrer kêt nẽ. Ãm Tĩrtũm pix na hte ja kaxyw tanhmã mẽ akrã hto ka mẽ amã akukrêx japê hkêt nẽ. Jao ra mẽ apê Tĩrtũm mẽ wa ixri atĩr tũm nẽ mẽ apa ho mẽ apa mã xwỳnh. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Hãmri nhũm Simãw Pêtre kãm: —Kwa Pahihti na pa prem agryk ã mẽmoj piitã hkaga hpa nẽ akôt ixpa ho ixpa. Jakamã xà kot paj mẽ nhỹrmã war ari ixtĩr tũm nẽ ixpa ho ixpa kêt nẽ nà? Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Hãmri nhũm kuma nẽ hkôt mẽ pa ho pa xwỳnh piitã mẽ kãm: —Nà ka mẽ atõ inhmã tanhmã amnhĩ to ho apa kaxyw akwỳjê re nẽ ma inhmã tanhmã amnhĩ nhĩpêx to ho ri apa. Anhõrkwỹ re rỳ atõ rỳ atõx rỳ aprõ nẽ akrajê re. Rỳ akatorxà nẽ anhĩpêêxà wa are. Rỳ akukrêx piitã rer pa hãmri nẽ ma ixkapẽr o mẽ piitã mẽ ahkre ho ri mẽ hkôt apa. ");
INSERT INTO apnNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","Hã kot paj amnhĩ tã mẽ apumu nẽ mẽ ato mex rax nẽ. Hãmri ka mẽ ma mẽ kãm ixkapẽr jarẽnh o mẽ hkôt apa nhũm mẽ kot mẽ amar xwỳnh kwỳjaja mẽ ama nẽ kãm mẽ akĩnh nẽ. Nẽ ra mẽ ate akwỳjê rer par tã mẽ tãmjaja te mẽ apê mẽ hkra rỳ mẽ htõ rỳ mẽ htõx pyràk o mẽ anhĩpêx. Jao tanhmã mẽ ato mex to ho pa. —Nẽ koja mẽ kãm ixprãm kêt xwỳnhjaja ixtã tanhmã mẽ atomnuj to hã ka mẽ nhỹrmã ma Tĩrtũm mẽ wa inhõ krĩ hwỳr api nẽ wa ixkuri amex nẽ atĩr tũm nẽ apa ho apa. ");
INSERT INTO apnNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Nom kêr ka mẽ ja hã amnhĩ pumunh kôt amnhĩ to rax xwỳnh ã amnhĩ to jarkrar kêt nẽ. Mẽ kot amnhĩ to rũnh xwỳnh ã amnhĩ jarẽnh xwỳnhjaja koja mẽ nhỹrmã amnhĩ to rũnh kêt ã amnhĩ pumu. Nẽ mẽ kot amnhĩ to hkryre xwỳnhjaja koja mẽ nhỹrmã amnhĩ to rũnh ã amnhĩ pumu. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Tã nhũm Jejus hkôt ri mẽ pa ho mẽ pa xwỳnhjê mã kapẽr pa hãmri nẽ ma Jerujarẽ hwỳr mẽ o mõ. Ra kamã kãm hkurê xwỳnhjaja kot hpĩr ã amnhĩ jarẽnh tã ma hwỳr mẽ o mõ. Jakamã nhũm mẽ tee ri hkukamã hamaxpẽr o hkôt mõ. Nhũm mẽ amarĩ mẽ hkôt mrar xwỳnhjaja haxwỳja kãm ma nẽ. Hãmri nhũm Jejus mẽ kêp 12ta o mõ nẽ hkwỳjê hkàx ã amnhĩ kukamã tanhmã mẽ kãm amnhĩ jarẽnh to ho mõ nẽ mẽ kãm: ");
INSERT INTO apnNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","—E na pu mẽ ra Jerujarẽ hwỳr mõ. Kot puj mẽ hwỳr pôj nhũm mẽ kãm ixkurê xwỳnhjaja patre krãhtũmjê mẽ Tĩrtũm kapẽr tũm o mẽ ahkre xwỳnhjê nhĩhkram ijaxà. Hãmri nhũm mẽ kãm Tĩrtũm kapẽr kôt amnhĩ nhĩpêx prãm kêt xwỳnhjaja ixpĩr kaxyw mẽ kãm ixtã amỹnê ");
INSERT INTO apnNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","nhũm mẽ mar xà hkôt tanhmã inhĩpêx kati hto. Nẽ mẽ hkwỳjaja ixtã hpẽr o axkẽ nẽ ixtã akunha. Nẽ mẽ hkwỳjaja tanhmã ijaprỳ hto nẽ ixtã argôx rẽ nẽ ixtak hãmri nẽ ixpĩ. Koja mẽ ã inhĩpêx anẽ. Nom kot paj ixtyk ã ixtã apkati axkrunẽpxi nhũm Tĩrtũm akupỹm ixto ixtĩr. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Tã nhũm Jepetew kra Xiakre mẽ Juãw wa tanhmã hamaxpẽr to nẽ Jejus mã kãm: —Kwa mẽ ijahkre xwỳnh. Pa wa amã mẽmoj jarẽ ka wa inhmã “ỳ” anẽ nà? Anẽ. Hãmri nhũm wa kãm: ");
INSERT INTO apnNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","—Ko wa mamrĩ inhmã mẽmoj jarẽ pa wa ama mãn. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Hãmri nhũm wa kãm: —Nà kot kaj nhỹrmã ate mẽ piitã mẽ ho amnhĩptàr kaxyw nhỹ pa wa akutã anhĩjê. Nẽ wa papxipix ixpê anhõ kôwenatô nẽ akutã anhĩjê nẽ ato nhỹ. Ja na pa wa inhmã hprãm. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Hãmri nhũm wa kãm: —Nà na ka wa ãm atỳx ri ã amnhĩ to ixwỳr anẽ. Koja mẽ tokyx ixpĩ pa amnhĩ xà htỳx kamã ijamak rax nẽ ty. Tã xà koja mẽ ixpyrà nẽ ã war anhĩpêx anẽ ka wa ixpyrà nẽ amnhĩ xà htỳx kamã ajamak rax kãm ty nà? Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Hãmri nhũm wa kãm: —Tỳ. Nà kot pa wa ijaxwỳja anẽ nẽ apyrà nẽ amnhĩ xà htỳx kamã ijamak kãm ty. Anẽ. Hãmri nhũm wa kãm: —Nà ãm hãmri na ka wa ja hã amnhĩ jarẽ. War ate ixpyrà nẽ ixkôt amnhĩ xà htỳx kãm ajamak kãm atyk mã kênã. ");
INSERT INTO apnNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Tã nom war ate amnhĩ to ixwỳrta ã kot paj tanhmã war amã nẽ hkêt nẽ. Inhõ Papaj tãm koja ja kaxyw mẽhõ japêr nhũm inhĩhkô hã nhỹ. No pa kot paj ri ja kaxyw mẽ atõ rênh kêt nẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Hãmri nhũm wa uràk nẽ Jejus kôt mẽ pa ho mẽ pa xwỳnh kwỳjaja ã wa kot amnhĩ to hwỳr anhỹr ã wa kuma nẽ wa kamã gryk nẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Jakamã nhũm Jejus mẽ piitã mẽ ho akuprõ nẽ mẽ kãm: —E mẽ inhma. Na hte Ijaew kêt xwỳnhjê nhõ pahihtijaja ã amnhĩ nhĩpêx anhỹr o ri pa nẽ amarĩ hkrĩ xà kamã hkrĩ ho hkrĩ. àhpumunh jakamã amarĩ ixkre kre jakry kamã hkrĩ ho hkrĩ nẽ kãm mẽ àpênh xwỳnhjê pix mã mẽmo mẽ àpênh ã karõ ho hkrĩ. Na htem ã amnhĩ nhĩpêx anẽ. Nẽ mẽ kot amnhĩm mex ã harẽnh prãm xàj tanhmã mẽ ho mex to ho pa. ");
INSERT INTO apnNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","45","Tã no mẽ kajaja kêr ka mẽ atõ amã amnhĩ to rax prãm hãmri nẽ ho mẽ kot amnhĩ nhĩpêx pyràk kêt nẽ. Mẽ piitã mẽ kutã anojarêt rãhã ho ri apa. Kêt paa. Mẽ ate inhmã axàpênh o apa kaxyw na pa pre mẽ awỳr ixwrỳk kêt nẽ. Ãm pa ixte tanhmã mẽ amã amnhĩ nhĩpêx to ho ixpa kaxyw na pa pre mẽ awỳr wrỳ. Mẽ ate nhỹrmã kuwy wỳr apa pymaj mẽ anê ixtyk kaxyw na pa pre mẽ awỳr wrỳ. Jakamã kot kaj mẽ atõ amã amnhĩ to rax prãm hã kêr ka ixpyrà nẽ akwỳjê kutã anojarêt rãhã ho ri apa. Hãmri nẽ inhmã te ate amnhĩ to rax o amnhĩ nhĩpêx pyràk o amnhĩ nhĩpêx. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Tã nhũm Jejus mẽ hkôt mẽ pa ho mẽ pa xwỳnhjaja kormã Jerujarẽ hwỳr mõr ri ra krĩ pê Jeriko hkôt mõ. Hãmri nhũm mẽ ohtô nẽ mẽ hã ajêt nẽ mẽ hkôt mõ. Nhũm mẽhõ myja pry nhĩhkrep nhỹ. Ximew kra Paximew nohkre xwỳnhja pry kamã ahwỳr o hkrĩ. ");
INSERT INTO apnNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Hãmri nhũm Jejus mẽ hkwỳjaja hwỳr htêp o mõ nhũm amnhĩ wỳr mẽ kuma nẽ mẽ kot Jejus nhĩxi jarẽnh o mõr ã kuma hãmri nẽ kàx pê kãm kapẽr nẽ amnhĩ to kuwỳ nẽ kãm: —Pa Jejus? Nà apê mẽ inhõ Pahihti mex kumrẽx na ka. Te apê amnepêm anhĩgêt pahihti Tawi kot amnhĩ nhĩpêx pyràk. Jakamã kwa we ixkamã axukaprĩ nẽ akupỹm ixto mex kêt wehe. Ixte amnhĩ kaxyw akôt ijamaxpẽr xwỳnh na pa. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Hãmri nhũm Jejus kukamã mẽ mrar xwỳnhjaja kuma nẽ kãm: —Tk. Kwa akapẽr kêt nẽ nhỹ nà. Anẽ. Tã nom nhũm ãm mẽ kuma nẽ xatã amnhĩ to kuwỳ. Kỳx pê amnhĩ to kuwỳ nẽ axte kãm: —Kwa ixkamã axukaprĩ nẽ akupỹm ixto mex Pahihti. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Hãmri nhũm Jejus kuma nẽ xa nẽ hkôt mẽ pa ho mẽ pa xwỳnhjê mã kãm: —E mẽ atõ hwỳr tẽ nẽ hpa hã apy nẽ amnẽ ixwỳr o tẽ. Anẽ. Hãmri nhũm mẽ kuma nẽ nohkre xwỳnhta mã kapẽr nẽ kãm: —E tee ri amnhĩ kukamã ajamaxpẽr kêt nẽ. Na atã karõ. E tokyx kànhmã xa. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Hãmri nhũm mẽ kuma nẽ hkĩnh tỳx nẽ. Nẽ kànhmã harĩ nẽ amnhĩ nê õ kajaati mẽ nẽ hwỳr htẽm kurê kumrẽx. ");
INSERT INTO apnNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Hãmri nhũm Jejus kãm: —Pa mo na? Tanhmã kot pa ato? Anẽ. Hãmri nhũm kãm: —Nà akupỹm inhmã ixrĩt mex prãm Pahihti. ");
INSERT INTO apnNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Anẽ nhũm kãm: —Tôe. Nà ra ate amnhĩ kaxyw inhmã ajamaxpẽr tỳx jakamã kot kaj akupỹm arĩt mex kurê kumrẽx. E mãmrĩ ma akupỹm tẽ. Anẽ. Nhũm akupỹm rĩt mex ã amnhĩ pumu nẽ hkĩnh o hkĩnh. Hãmri nẽ Jejus ã ajêt nẽ ma hkôt hkĩnh nẽ tẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Tã nhũm Jejus mẽ hkôt mẽ pa ho mẽ pa xwỳnhjê mẽ kormã Jerujarẽ hwỳr mõ. Hãmri nẽ krĩ pê Petake mẽ hõ pê Petãn wỳr ahtêp o mõ. Hixêt pê Oriwêhti kahti ri na pre krĩja wa xa. Jakamã nhũm Jejus hkôt mẽ pa ho mẽ pa xwỳnh wa ho axkrut nẽ mẽ amnhĩ kukamã wa kumẽ ");
INSERT INTO apnNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","nẽ wa kãm: —E wa ma krĩ mũj wỳr mẽ ixkukamã wa tẽ. Hãmri nẽ hwỳr pôj nẽ nhỹri jumẽnre nyw mã ê nẽ ãm xwỳnhta pumu. Kormã mẽ kot hã hkrĩ hkêt kumrẽx xwỳnhta. ");
INSERT INTO apnNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Ka wa omu nẽ kãm ê xà hpôt nẽ man akupỹn ixwỳr o tẽ. Koja mẽhõ war apumu nẽ hã tanhmã war amã kapẽr to ka wa ã kãm ijarẽnh anẽ nẽ kãm: “Nà mẽ panhõ Pahihti na hã karõ pa wa hwỳr tẽ.” Anhỹr o kãm ijarẽ. E wa ma hwỳr tẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Hãmri nhũm wa kuma nẽ ma hwỳr htẽm kurê kumrẽx nẽ hwỳr pôj. Nhũm Jejus kot wa kãm hã karõ xà hkôt jumẽnre nywreta pumu. ");
INSERT INTO apnNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Hãmri nẽ kãm ê xà hpôt o xa nhũm kuri mẽ kuhê xwỳnhjaja tee ri hã wa omu nẽ wa kãm: —Kwa mo kaxyw na ka wa kãm ê xà hpôt o xa? Kwa kot ka wa mẽ ixpê ho ahkĩ nà? Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Hãmri nhũm wa mẽ kãm: —Nà mẽ panhõ Pahihti na wa inhmã hã karõ pa wa hwỳr tẽ. Wa ixte ma hwỳr o ixtẽm kaxyw. Anẽ. Hãmri nhũm mẽ wa kãm: —Tỳ? Tôe wa mãmrĩ ma kãm o tẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Hãmri nhũm wa ma akupỹm Jejus wỳr o tẽ. Hãmri nẽ kaxyw amnhĩ xê hkwỳ hkwrỳ nẽ kãm ho hkô kahty hpa nẽ kãm ho htỳx nẽ o xa nhũm Jejus hã nhỹ nẽ mõ. ");
INSERT INTO apnNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Nẽ kormã Jerujarẽ hwỳr hixêt ã àpir o mõ. Nhũm mẽ kot omunh o kuhê xwỳnhjaja hkĩnh nẽ ma hkukamã pry ho mex kaxyw amnhĩ xê hkwỳ hkwrỳ nẽ ho kãm uty. Nhũm mẽ hkwỳjaja nhỹri pô hkwỳ jakà nẽ o mra nẽ hkukamã kãm uty. ");
INSERT INTO apnNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","10","Nhũm mẽ hixêt ã api nẽ ahpar mã wrỳk o mõ nhũm mẽ piitã kàx pê Tĩrtũm mex o mex ã harẽnh o hkôt mõ. Nhũm mẽ hkwỳjaja kukamã mra nhũm mẽ hkwỳjaja hapu hã mra nhũm prem piitã hkôt Tĩrtũm mex o mex ã harẽnh o mõ. Nẽ harẽnh o: E ota Tĩrtũm kot mẽ pahwỳr mẽnh xwỳnhta ra pôj. Nà ãm hãmri na mẽ pahwỳr wrỳ. Ja mex kumrẽx. Kêp mẽ panhõ Pahihti mex na. Koja mẽ panhĩgêt pahi Tawi pyrà nẽ mẽ pahto amnhĩptà nẽ mẽ pahto mex o pa. Ãm hãmri na Tĩrtũm mẽ pahwỳr kumẽ. Tĩrtũm mex kumrẽx. Ãm mex o mex. Kukwak ri pix mã na pu htem pajamakêtkati nẽ paxàmnhĩx papa rãhã ho papa. Anhỹr o Jejus kôt harẽnh o mõ. Kot mẽ ho amnhĩptàr kurê kumrẽx ã hkamnhĩx nẽ hkĩnh nẽ ã hkôt kapẽr anhỹr o mõ. ");
INSERT INTO apnNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Jao ra Jerujarẽ hwỳr pôj nhũm Jejus Tĩrtũm mã amnhĩ jarẽnh xà hã ixkre hwỳr tẽn axà. Nom nhũm ra amỹkry htỳx jakamã nhũm hwỳr axà nẽ ãm hkre pumunh o xa hãmri nẽ akupỹm kato nẽ hkôt mẽ pa ho mẽ pa xwỳnh pê 12jê mẽ nhũm mẽ ma akupỹm Petãn wỳr mra. ");
INSERT INTO apnNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Tã nhũm apkati nhũm Jejus mẽ hkôt mẽ pa ho pa xwỳnhjê mẽrohã Petãn rũm hapôj nẽ ma akupỹm Jerujarẽ hwỳr mra. Nhũm Jejus ra kãm prãm nẽ mõ. ");
INSERT INTO apnNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Hãmri nẽ amỳm mẽmo pĩ hpàr hôptĩ rax pê fikêhti pumu nẽ hamaxpẽr o: —E pa hwỳr tẽ nẽ ô hkwỳ rê nẽ kuwô mãn. Anẽ. Hãmri nẽ hwỳr tẽ. Nhũm kormã ô kaxyw õ mytwrỳ kator kêt jakamã nhũm ô hkêt nẽ ãm hô pix nẽ xa. ");
INSERT INTO apnNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Hãmri nhũm hwỳr tẽ nẽ tee ri ô japêr nẽ ãm hô pix pumu. Hãmri nẽ tee ri omu nẽ kãm: —E kot kaj axte axô hkêt kumrẽx. Anhỹr o kãm kapẽr nhũm hkôt mẽ pa ho mẽ pa xwỳnhjaja hã kuma. ");
INSERT INTO apnNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","17","Tã nhũm Jejus mẽ hkôt mẽ pa ho mẽ pa xwỳnhjaja Jerujarẽ hwỳr agjê nẽ Tĩrtũm mã amnhĩ jarẽnh xà hã ixkre hwỳr agjê. Nhũm Jejus tee ri kamã mẽ kuhê xwỳnhjê pumu. Nhũm mẽ ra ixkre kamã axtem nẽ môx nẽ ôwêhti nẽ tuuti ho wẽnê ho kuhê. Ixkre hwỳr mrar xwỳnhjaja kot haprôr nẽ Tĩrtũm mã amnhĩ jarẽnh kaxyw kãm hpar nẽ õr kaxyw mẽ kãm ho wẽnê. Nom axtem nẽ hã ohtô rax kãm mẽ kãm ho wẽnê nhũm mẽ hkwỳjaja mẽ kãm mẽ hikàxpore ho anhĩpa. Hãmri nhũm Jejus mẽ hwỳr axà nẽ tee ri mẽ kot ã amnhĩ nhĩpêx anhỹr ã mẽ omu nẽ mẽ kãm akir nẽ mẽ kãm: —Tk. Kwa Tĩrtũm kapẽr ã kagà htũm kot õrkwỹ jarẽnh kot: Inhõrkwỹja ãm pika piitã hkôt mẽ piitã kot inhmã amnhĩ jarẽnh xà hã ixkre pix kaxyw na. Anhỹr o kot harẽnh tã ka mẽ axtem nẽ kamã ã amnhĩ nhĩpêx anhỹr o akuhê. E kwa mẽ ma mra nẽ ajapôx tokyx anẽ. Anẽ. Nhũm pre ã mẽ kãm kapẽr anhỹr pê mẽ ahkre hãmri nẽ ixkreja nê mẽ kator pa. ");
INSERT INTO apnNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Hãmri nhũm patre krãhtũmjê mẽ Tĩrtũm kapẽr tũm o mẽ ahkre xwỳnhjaja tee ri ã mẽ hipêx anhỹr ã omu nẽ kapẽr ma nẽ kamã gryk tỳx nẽ. Hãmri nẽ mẽ kot hã àmnênh kaxyw tanhmã axpẽn mar to nẽ axpẽn mã: —Tk. Kwa na mẽ ohtô nẽ kãm mar prãm nẽ. Koja mẽ anẽ nẽ gryk ã mẽ pahkaga nẽ axte mẽ pakapẽr mar kêt nẽ. Kwa pu mẽ kupĩ ri. E tanhmã kot puj mẽ ho nẽ kupĩ? Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Tã nhũm myt axà nhũm Jejus mẽ hkôt mẽ pa ho pa xwỳnhjaja Jerujarẽ rũm hapôj nẽ ma nhỹri amnhĩm hikranh kaxyw mra. ");
INSERT INTO apnNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Tã nhũm apkati nhũm Jejus mẽ hkôt mẽ pa ho mẽ pa xwỳnhjaja Jerujarẽ hwỳr akupỹm mra. Hãmri nẽ axte pĩ hpàr pê fikêhtita pumu. Jejus ra kot kãm kapẽr xwỳnhta pumu nhũm ra grà pa nẽ xa. ");
INSERT INTO apnNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Hãmri nhũm Simãw Pêtre Jejus kot tanhmã pĩ mã kapẽr toja mã hamaxpẽr nẽ hã kãm: —Kwa mẽ ijahkre xwỳnh. Ga mẽmoj mũj pumu. Jãã ate fikêhti mã akapẽr xwỳnhta na grà par kumrẽx nẽ xa. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","23","Hãmri nhũm kuma nẽ mẽ piitã mẽ kãm: —Tỳ nà ãm hãmri na pa mẽ amã ixkapẽr. Kot kaj mẽ mẽmo kaxyw Tĩrtũm mã ajamaxpẽr tỳx pê mẽmoj tã awỳ nhũm ama nẽ amã hprãm xà hkôt tanhmã amã hipêx to. Ka mẽ amnhĩ kaxyw Tĩrtũm mã ajamaxpẽr tỳx pê hixêt mũj mã akapẽr nẽ kãm: “E xa nẽ ma tẽ nẽ gô xujanãr kãm mrõ.” Anhỹr o kãm akapẽr nhũm amar xà hkôt ã amnhĩ nhĩpêx anẽ nẽ tẽn kamã mrõ. ");
INSERT INTO apnNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Kot kaj mẽ mẽmoj tã Tĩrtũm wỳ nẽ kaxyw ãm pix mã ajamaxpẽr tỳx nẽ nhũm amã ho anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","26","—Nẽ kot kaj mẽ Tĩrtũm mã amnhĩ jarẽnh kaxyw nẽ ra mẽhõ kot tanhmã ato mã ajamaxpẽr. Hãmri nẽ ja ho ajamakêtkati kurê kumrẽx nẽ axte kãm ajamaxpẽr kêt nẽ. Ãm mẽmoj nyw pix mã ajamaxpẽr o tãm amnhĩ nhĩpêx o apa. Hãmri nhũm Tĩrtũm kaxkwa rũm ja hã apumu nẽ apyrà nẽ ate tanhmã amnhĩ tomnuj to ho hamakêtkati nẽ axte kãm hamaxpẽr kêt nẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Nhũm mẽ akupỹm Jerujarẽ hwỳr agjê nhũm Jejus kê axte Tĩrtũm mã amnhĩ jarẽnh xà hã ixkre hwỳr axà. Nhũm hkôt mẽ pa ho mẽ pa xwỳnhjaja hkôt hwỳr mra nẽ hkôt agjê nẽ kormã kamã kuhê. Hãmri nhũm Ijaew krãhtũmjê mẽ mẽ kot Tĩrtũm kapẽr tũm o mẽ ahkre xwỳnh mẽ mẽ õ patre krãhtũmjaja Jejus pumu nẽ hwỳr mra nẽ hêx rom tanhmã kãm kapẽr to. Na pre ra Jejus ixkreja nê mẽmoj to wẽnê xwỳnh mẽ kàxpore o mẽ hpinhpanh xwỳnhjê jano nhũm mẽ tee ri ja hã omu nẽ kamã gryk tỳx nẽ. Jakamã nhũm akupỹn mẽ hwỳr axà nhũm mẽ axte omu nẽ hwỳr mrar kurê kumrẽx ");
INSERT INTO apnNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","nẽ kãm: —Kwa mẽ inhmã amnhĩ jarẽ. Mẽhõ nhỹ hã na ka hte ã amnhĩ nhĩpêx anhỹr o ri apa? Mẽhõ na pre mẽ ixwỳr amẽ ka pre mõ? Nà xà amnhĩ krã hkôt na ka hte ã amnhĩ nhĩpêx anhỹr o ri apahti? E kwa mẽ inhmã amnhĩ jarẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Nhũm Jejus kot tanhmã mẽ hamaxpẽr to hkôt mẽ omunh mex jakamã mẽ kãm: —Nà kot pa ixkumrẽx mẽmoj tã mẽ akukja. Ka mẽ inhmã harẽ pa rĩ kormã mẽ amã tanhmã amnhĩ jarẽnh to. ");
INSERT INTO apnNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Finat Juãw Paxisja ã kot paj mẽ akukja. Mẽhõ nhỹ hã na pre hte mẽ hkrã kumrãr o pa? Xà amnhĩ krã hkôt nà xà Tĩrtũm nhỹ hã? E mẽ atõ inhmã harẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","32","Hãmri nhũm mẽ kuma nẽ tee ri kot tanhmã kutã kãm harẽnh to hkukamã hamaxpẽr nẽ axpẽn mã: —Kwa tanhmã kot puj mẽ kãm ja jarẽnh to? Mẽ kot mar o kuhê xwỳnhjaja na htem Juãw Paxis kêp Tĩrtũm nhỹ hã kapẽr jarẽnh xwỳnh ã axpẽn mã harẽnh o pa. Jakamã kot puj mẽ kãm kot amnhĩ krã hkôt mẽ hkrã kumrãr o pa hã harẽ nhũm mẽ tee ri mẽ pama nẽ mẽ pakamã gryk nẽ. Nẽ mẽ paxêx rom ã kãm mẽ pakapẽr anhỹr ã mẽ pahpumu nẽ kẽn o mẽ pahtak o mẽ panhĩmex. No kot puj mẽ kãm Tĩrtũm nhỹ hã mẽ hkrã kumrãr ã harẽ nhũm mẽ pama nẽ mẽ pamã: “Kwa ã kot anhỹr kênã na ka prem kapẽr mar tã ixkôt amnhĩ xunhwỳr kêt nẽ?” Anẽ. Nà kot puj pẽr mẽ kãm tanhmã harẽnh to hkêt nẽ. Kot puj mẽ ãm kãm aa te mẽ pahte ja jarẽnh mar kêt pyràk o harẽ. Anẽ. Mẽ kot tanhmã kãm nẽ nhũm kot ta pãnhã tanhmã mẽ kãm nẽ pymaj nhũm mẽ tee ri tanhmã kãm nẽ hprãm kaprỳ ho kuhê. ");
INSERT INTO apnNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Hãmri nẽ Jejus mã kãm: —Konẽn. Mẽ ixte mẽhõ nhỹ hã kapẽr o pa hã omunhre hã. Anẽ. Hãmri nhũm mẽ kuma nẽ mẽ kãm: —Tk. Tôe kot pa xep ijaxwỳja mẽ amã tanhmã amnhĩ jarẽnh to hkêt nẽ. Ijaxwỳja ixte mẽhõ nhỹ hã ã ixte amnhĩ nhĩpêx anhỹr o ri ixpa hã amnhĩ pumunhre hã. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Nhũm Jejus arĩ Ijaew krãhtũm mẽ mẽõ patre krãhtũm mẽ Tĩrtũm kapẽr tũm o mẽ ahkre xwỳnhjê mã kapẽr o xa. Nẽ mẽ kãm mẽ kot tanhmã hipêx to hkukamã mẽ kãm tanhmã amnhĩ jarẽnh to. No ãm hã kuxi nẽ mẽ kãm awjarẽ nẽ mẽ kãm: —Koja mẽhõ hpur ã hkwỳjê mã karõ. Mẽ kot kamã kãm àpênh kaxyw mẽ kãm karõ. Hãmri nhũm mẽ ma hwỳr mra nẽ kamã mẽmo hy hkre nẽ hkre pa. Hãmri nẽ pu hã kahê hpa nẽ pur kaêx kãm ixkre hprêk nhĩpêx. Mẽ kot himõk ã mẽ kot kêp àhkĩnh pymaj mẽ hapêr o hkrĩ kaxyw. Hãmri nẽ hipêx pa nhũm mẽõ patrãwja awry hã krĩ hõ hwỳr nojarêt nẽ mẽ kãm tanhmã hpur jarẽnh to nẽ mẽ kãm: “E or ixpurta nõ. Kê kamã mẽmoj kà hpa ka mẽ mãmrĩ kamã awjamỳ nẽ ho axkjê. Hãmri nẽ ixkutêp inhõ jaxwỳ nẽ mãmrĩ anhõ tanhmã ho hprãm xà hkôt tanhmã ho.” —Anhỹr o mẽ kãm kapẽr hãmri nẽ ma mõ. ");
INSERT INTO apnNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Tã nhũm ra pur kãm mẽmoj hkà pa. Nhũm hpur nhõ dõn arĩ krĩ hõ kamã hã ujahkre ho pa htã kuri kãm àpênh xwỳnhjê hõja nhũm akupỹm mẽ hwỳr kumẽ. Mẽ kot kãm õ hkwỳ nhõr nhũm ma kot kãm o mõr kaxyw ma mẽ hwỳr kumẽ nhũm ma akupỹm mẽ hwỳr mõ. Mõõ nẽ ra mẽ hwỳr pôj. ");
INSERT INTO apnNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Hãmri nhũm mẽ omu nẽ axtem nẽ homnuj nẽ. Nẽ unê nẽ htak nẽ akupỹm hano nhũm ỹ kamã ma akupỹm mõ. ");
INSERT INTO apnNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Hãmri nhũm õ patrãwja tee ri omu nẽ hpãnhã ja mẽ nhũm ma mẽ hwỳr mõ. Mõõ nẽ mẽ hwỳr pôj. Hãmri nhũm kê wem omu nẽ mã ho anẽ nẽ. Unê nẽ htak nẽ hkrãx pê htak nẽ akupỹm hano nhũm wamta pyrà nẽ ma akupỹm ỹ kamã mõ. ");
INSERT INTO apnNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Hãmri nhũm axpẽn pãnhã kãm mẽ àpênh xwỳnh kwỳjê rẽ nhũm mẽ axpẽn pãnhã ma mẽ hwỳr pa. Ma mẽ hwỳr pa nẽ pôj nhũm mẽ te ho wamtajê mẽ hipêx pyrà nẽ mẽ hkwỳjê pynê nẽ htak rax nẽ mẽ hano nẽ mẽ hkwỳjê pa. ");
INSERT INTO apnNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Nhũm mẽ õ patrãw mẽ harẽnh ma nẽ tee ri amnhĩ kukamã hamaxpẽr nẽ hamaxpẽr o: “Hêxta waa nẽ. Tanhmã kot paj we amnhĩ nhĩpêx to nẽ inhõta kwỳ jamỳ? Nà kot paj mẽ hwỳr ixkraja mẽ. Inhmã hapê htã kot paj mẽ hwỳr kumẽ kê ma mẽ hwỳr mõ. Hãmri nhũm mẽ kêp ixkra hã omu nẽ tanhmã ixpê ho hkêt nẽ. Nẽ jatã inhmã kãm inhõja kwỳ gõ nhũm man ixwỳr o tẽ. Nà kot paj anẽ.” —Anhỹr o hamaxpẽr hãmri nẽ ma mẽ hwỳr hkraja mẽ nhũm ma mẽ hwỳr mõ. ");
INSERT INTO apnNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","—Tã mẽ hwỳr hpôx o mõ nhũm mẽ amỳm amnhĩ wỳr omu nẽ kêp hkra hã omunh kurê kumrẽx nẽ hã axpẽn mã amỹnê nẽ axpẽn mã: “E. Nà onẽj hpur nhõ dõn krata tẽ. Koja nhỹrmã õ papaj mỳrpê amnhĩm pur ã pyka pytà nẽ ho õ. Jakamã e pu mẽ kupĩ nẽ kêp hpur ho arĩk nẽ ho panhõ. E kwa tokyj pu mẽ kupĩ ri.” Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","—Rôm nhũm ra mẽ hwỳr hpôx o tẽ nẽ ra pôj nhũm mẽ unê nẽ pur nê ho kato nẽ ahkà kamã kupĩ. Ã mẽ ujarẽnh kot anhỹr. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Nhũm pre ã Jejus Ijaew krãhtũmjê mã ujarẽnh anẽ. Hãmri nẽ hã tanhmã mẽ hkukjêr to nẽ mẽ kãm: —E mẽ inhmã mẽmoj jarẽ. Koja pur nhõ dõnja tee ri mẽ kot hkra hpĩr ã harẽnh ma hãmri nẽ tãm mẽ hwỳr mõ hãmri nẽ tanhmã mẽ hipêx to wehe? Nà koja ma mẽ hwỳr mõ nẽ mẽ himex pa hãmri nẽ hpãnhã nhãm hpurta ã mẽmojjê rẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Mãn ka prem ra Tĩrtũm kapẽr ã kagà htũm kot ja jarẽnh ma nà? Harẽnh kot: Na prem kẽn o amnhĩm õrkwỹ nhĩpêx kaxyw hãmri nẽ kẽn maati pumu nẽ htỳx omnuj ã hkamnhĩx nẽ hkaga. Mẽ kot hkaga htã nom nhũm Tĩrtũm mẽ kurom mex o kot kẽn piitã hakrenh par ã omunh kurê kumrẽx. ");
INSERT INTO apnNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","ãm hãmri na pre ã mex ã omunh anẽ. Anẽ. Ã Tĩrtũm kapẽr ã kagà htũm kot harẽnh kot anhỹr. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Nhũm pre ã Jejus mẽ kãm ujarẽnh kãm mẽ harẽnh anẽ nhũm mẽ amnhĩ tã kuma. Tĩrtũm kapẽr tũm o mẽ ahkre xwỳnh mẽ mẽ õ patre krãhtũm mẽ Ijaew krãhtũmjaja nhũm mẽ kot mẽ kãm kẽn maati kaga xwỳnhjê jarẽnh o te mẽ tãm harẽnh pyràkja ma nhũm ja mẽ kêp omnuj nẽ. Jakamã nhũm mẽ kãm unênh nẽ haxàr prãm nẽ. Nom amnhĩ tã kãm mẽ kot mar o kuhê xwỳnhjê puma nẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Jakamã na prem ma mra nẽ hapôj hãmri nẽ Jejus wỳr Parijew nhõ xwỳnh mẽ pahi Erox kôt mẽ pa xwỳnh kwỳjê rẽ. Mẽ kot hêx rom mẽmoj tã hkukjêr nhũm kot mẽ mar nẽ tanhmã Rõm nhõ xwỳnhjê nhõ pahi Sesti kapẽr kuhpa hã ri tanhmã mẽ kãm nẽ nhũm mẽ kot mar kaxyw. ");
INSERT INTO apnNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Jakamã nhũm mẽ ma hwỳr mra nẽ hêx rom kãm kapẽr nẽ kãm: —Kwa Jejus? Nà ãm hãmri na ka hte Tĩrtũm kapẽr o mẽ ahkre mex nẽ. Na ka hte mẽ kamã akahak o apa hkêt nẽ. Nẽ mẽ kot tee ri mẽ kot tanhmã ato kapẽr punuj to htã ka hte arĩ aprĩ hã mẽ ahkre mex o ri apa. E kwa mẽ inhmã mẽmoj jarẽ. Rõm nhõ pahihti kot mẽ pahpê Ijaew mẽ pahte kãm kàxpore hkwỳ nhõr ã mẽ pamã karõta. Kwa xà ja amã mex nà? Xà kot pu mẽ kãm kugõ? Xà kot pu mẽ kãm õr kêt nẽ? E kwa mẽ inhmã harẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Nhũm prem ã hêx rom ja hã hkukjêr anhỹr tã no nhũm Jejus mẽ hamaxpẽr ã mẽ omunh mex mẽ mẽ kãm: —Tk. Kwa mon ka mẽ axêx rom ja hã ixkukja? E mẽ atõ inhmã kàxpore htỳxre hõ gõ pa omu. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Hãmri nhũm ja kãm ja gõ nhũm kupy nẽ kànhmã kupẽ nẽ mẽ kãm: —E mẽhõ nhĩxi nẽ mẽhõ karõ na hã? Anẽ. Anẽ nhũm mẽ kãm: —Pahi Sesti karõ nẽ hixi na hã. ");
INSERT INTO apnNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Anẽ nhũm mẽ kãm: —Tỳ. Tô kêr ka mẽ mãmrĩ kãm hkwỳ nhõr o apa. Hã hkarõ nẽ hã hixi. Tãm kot hipêx xwỳnh jakamã õ na. No mẽ kajaja na pre Tĩrtũm mẽ anhĩpêx nhũm mẽ apê õ jakamã kwa kêr ka mẽ kapẽr kôt pix mã ri amnhĩ nhĩpêx o ri apa. Anẽ. Nhũm pre ã mẽ kãm kapẽr anẽ nhũm mẽ piitã mar o kuhê. Nhũm mẽ kot hêx rom hkukjêr xwỳnhjaja amnhĩ jaêr pê ã kàxpore jarẽnh anhỹrja ã kuma nẽ axpẽn mã: —Kwa mẽ paxêx rom mẽ pahte hã hkukjêr tã nhũm ãm hãmri mẽ pakutã mẽ pamã harẽ. Kwa tanhmã kot puj wem hkukjêr to nhũm pahi Sesti kapẽr kwỳm ri mẽ pamã mẽmoj jarẽ? Anẽ. Hãmri nẽ tee ri tanhmã hkukjêr to hkukamã hamaxpẽr o kuhê. ");
INSERT INTO apnNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Tã nhũm Satusew nhõ xwỳnh kwỳjaja. Mẽ kot akupỹm mẽ htĩr mã hamaxpẽr kêt xwỳnhjaja na pre mẽ. Tã mẽ kot mẽ htyk nẽ mẽ hapêx ã mẽ hkamnhĩx jakamã na prem axpẽn mã Jejus jarẽnh o: —E kwa pu mẽ ma hwỳr mra nẽ mẽmoj xihtỳx ã hkukja kê mẽ pama nẽ tee ri tanhmã mẽ pamã kapẽr to hkukamã hamaxpẽr. Hãmri nhũm mẽ piitã ja hã omu nẽ àhpumunh kêt ã omunh kurê kumrẽx. E tokyx ma pu mẽ hwỳr. Anẽ. Hãmri nẽ ma hwỳr mra nẽ Parijew nhõ xwỳnhjê pyrà nẽ hêx rom kãm: ");
INSERT INTO apnNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","—Pa Jejus? Kwa mẽ inhmã mẽmoj jarẽ. Na pre finat Mojesja Tĩrtũm nhỹ hã ã mẽ panhĩgêtjê mã karõ anẽ. Mẽ hkra hkêt rãhã mẽ pa nẽ mẽ htyk xwỳnhjaja nhũm mẽ harẽnh o: Koja mẽhõ hprõ hãmri nẽ kamã hkra hkêt rãhã pa nẽ ty. Hã koja hkôt htõja hpãnhã hprõ o hprõ nẽ kamã hkra. Hãmri nhũm kato nẽ te kêp htõ htyk xwỳnhta hkra pyràk. Anẽ. Na pre ã Mojes Tĩrtũm nhỹ hã ja hã mẽ kãm karõ anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Jakamã kwa ga mẽ ixujarẽnh ma. Koja mẽmojjaja mẽ kot axpẽn to htõ xwỳnhjaja kêp 7. Nhũm kot waja hprõ. Nẽ wa pa nhũm myja kormã hprõ kamã hkra hkêt rãhã ty. ");
INSERT INTO apnNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Nhũm hkôt htõ hõta hpãnhã hprõ ho hprõ nẽ wa axpẽn to pa. Nhũm haxwỳja kamã hkra hkêt rãhã ty. Nhũm hkôt htõ hõta haxwỳja ho hprõ nẽ wa axpẽn to pa grire nhũm wamta wa uràk nẽ kamã hkra hkêt rãhã ty. ");
INSERT INTO apnNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Hãmri nhũm htõ hkwỳjaja piitã nija pyxi nẽ axpẽn pãnhã ho hprõ nom mẽhõ kamã hkra hkêt rãhã htyk pa. Hãmri nhũm mẽ hprõta mẽ hkôt amnhĩ to hitep nẽ ty. ");
INSERT INTO apnNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Tã Tĩrtũm kot akupỹm nhỹrmã mẽ ho htĩr ronhỹx nhỹ nhỹx kêp nija mjên kumrẽx? Ra piitã kot ho hprõ kênã. E kwa mẽ inhmã ja jarẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Hãmri nhũm Jejus ã mẽ ujarẽnh anhỹrja ma nẽ mẽ kãm: —Tk. Nà mẽ ate Tĩrtũm kapẽr ã kagà htũm mar mex kêt. Nẽ mẽ aprĩ hã tanhmã Tĩrtũm kute hã omunh kêt jakamã na ka mẽ ã atỳx ja hã ixkukjêr anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Kormã mẽ htĩr ri mẽ kot Tĩrtũm kôt amnhĩ xunhwỳr xwỳnhjaja na htem ty hãmri nẽ Tĩrtũm nhõ krĩ kamã axte kãm hprõ hprãm kêt pa. Rỳ ni japêr nẽ kãm mjên prãm kêt nẽ pa. Hãmri nẽ Tĩrtũm kapẽr o mẽ wrỳk xwỳnhjê pyrà nẽ axte htyk kêt nẽ. Ãm htĩr tũm rãhã nẽ pa ho pa. ");
INSERT INTO apnNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","—Nom mẽ ate akupỹm mẽ htĩr kêt ã mẽ hkamnhĩxja kot paj ixprĩ hã mẽ amã harẽ. Amnepêm na pre Tĩrtũm pĩ hpôk kamã tanhmã Mojes mã kapẽr to. Mãn ra mẽ ate mar. Na pre kãm: Ixpê Apraãw nhõ Tĩrtũm na pa. Nẽ mããnẽn ixpê Apraãw kra Ijak mẽ htàmnhwỳ Jako wa õ Tĩrtũm na pa. Anhỹr o Mojes mã amnhĩ jarẽ nhũm kuma nẽ hã kagà. ");
INSERT INTO apnNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Kêp apu arĩ mẽ htyk rãhã nhỹx pre ã mẽ harẽnh anhỹr kêt nẽ. Nhỹx pre mẽ harẽnh o: “Amnepêm Apraãw nẽ hkra nẽ htàmnhwỳ mẽ htĩr ri ixpê mẽ õ Tĩrtũm na pa pre.” Anhỹr o nhỹx pre mẽ harẽ. Nom na pre ã amnhĩ jarẽnh anhỹr kêt nẽ. Mẽ pamã te Apraãwja mẽ htyk nẽ mẽ hapêx pyràk. Nom nhũm prem ra Tĩrtũm ri akupỹm htĩr nẽ mex nẽ pa ho pa. Tã ka htem Tĩrtũm kapẽr kwỳm ri akupỹm mẽ htĩr kêt ã mẽ harẽnh o apa. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Tã nhũm Tĩrtũm kapẽr tũm o mẽ ahkre xwỳnhjê hõ mẽ hwỳr tẽ nẽ mẽ kot axpẽn mã kapẽr ã mẽ omunh o xa. Hãmri nẽ Jejus kot tanhmã Satusew nhõ xwỳnhjê mã kapẽr mex toja ma nẽ kãm: —Nà ãm hãmri na ka ã mẽ kãm ja jarẽnh anẽ Pahihti. Kwa inhmã mẽmoj jarẽ. Na pre Tĩrtũm ahpỹnhã mẽmoj to 10 nẽ mẽ pamã hã karõ. Mẽ pahte hkôt amnhĩ nhĩpêx o ri papa kaxyw hã mẽ pamã karõ. Tã nhỹ kapẽr na mex o kot hkwỳjê jahkrenh wehe? Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Hãmri nhũm kãm: —Nà Tĩrtũm kapẽr xohtôô. Kapẽr piitã hkôt mẽ pahte amnhĩ nhĩpêx o papaja na kãm hprãm. No pixi na mẽ pahte hkôt amnhĩ nhĩpêx o papaja nhũm kãm hprãm tỳx o kot hkwỳ jakrenh. Kapẽr mex maati na ja. Na pre kapẽr o: E mẽ apê Ijaew nhõ xwỳnhjaja. Ixpê mẽ anhõ Tĩrtũm ã ixpixi mex na pa. ");
INSERT INTO apnNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Jakamã kêr ka mẽ amã ixkĩnh tỳx o mẽmoj piitã hakrenh pa. Jao mẽ anhĩ piitã ho amã ixkĩnh tỳx kumrẽx o ri apa. ");
INSERT INTO apnNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Anhỹr o na pre mẽ pamã karõ. Nẽ hkôt ja: Kêr ka mẽ nhãm mẽ hipêx o te ka amã amnhĩ tã ma pyràk o mẽ hipêx o ri apa. Jao tãm mẽ hipêx rãhã ho ri apa. Anẽ. E ja wa kumrẽx na Tĩrtũm kãm mẽ pahte hkôt amnhĩ nhĩpêx o ri papa hprãm tỳx nẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Hãmri nhũm kuma nẽ kãm: —Nà ãm hãmri na ka ja jarẽ Mẽijahkre xwỳnh. Tĩrtũm pyxi mex kênã. ");
INSERT INTO apnNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Amnepêm na pre htem kãm amnhĩ jarẽnh kaxyw nẽ kãm mẽmoj gõ nẽ rĩ kormã tanhmã kãm amnhĩ jarẽnh to. Tã nom kot puj mẽ ã ate harẽnhta kôt amnhĩ nhĩpêx anhỹr o papa jao mẽ panhĩ piitã pamã Tĩrtũm kĩnh. Nẽ mẽ pamã hkĩnh o mẽmoj piitã hakrenh pa. Nẽ nhãm mẽ hipêx o te mẽ papamjaja pamã amnhĩ tã ma pyràk o mẽ hipêx. Jao tãm mẽ hipêx rãhã ho ri papa. Kot puj mẽ ã amnhĩ nhĩpêx anẽ nhũm Tĩrtũm kãm ja mex o mẽ pahte kãm mẽmoj nhõrta jakre. Anhỹr o kãm kapẽr. ");
INSERT INTO apnNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Hamaxpẽr mex pê ã Jejus mã kapẽr anẽ nhũm kuma nẽ kãm: —Nà ãm hãmri na ka ja jarẽ. Na ka ra mẽ kot Tĩrtũm kôt amnhĩ nhĩpêx o amnhĩ nhĩpêx nyw pumunh mex o mõ. Nà te ate tokyx hkôt amnhĩ xãm kaxyw pyràk. Anẽ. Hãmri nhũm mẽ kãm hkurê xwỳnhjaja tee ri wa kot axpẽn mã kapẽr mar o kuhê nẽ axte kãm mẽmoj tã hkukjêr pyma nẽ. Ra tee ri mẽ kot hêx rom mẽmoj tã hkukjêr kaprỳ jakamã axte tanhmã hkukjêr to hkêt nẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Hãmri nhũm Jejus arĩ Tĩrtũm mã amnhĩ jarẽnh xà hã ixkre kamã amnhĩ tã mẽ ahkre. Nom te nhãm mẽhõ hã mẽ hkukjêr pyràk amnhĩ tã mẽ hkukja nẽ mẽ kãm: —E mẽ inhmã mẽmoj jarẽ. Tĩrtũm kapẽr tũm o mẽ ajakre xwỳnhjaja na htem tanhmã mẽ amã Tĩrtũm kot mẽ akaxyw ãm mã xwỳnh jarẽnh to nẽ mẽ amã harẽnh o: “Koja kêp pahi finat Tawi kanrẽhã htàmnhwỳ koja.” Anhỹr o kot mẽ amã harẽ. Ãm kêp kanrẽhã htàmnhwỳ pix ã mẽ amã harẽnh o pa. No na pre pahi Tawija kêp kanrẽhã htàmnhwỳ hã harẽ nẽ mããnẽn kêp õ pahihti hã harẽ. Tã nom nhũm Tĩrtũm kapẽr tũm o mẽ ajahkre xwỳnhjaja na htem urà nẽ kêp pahihti hã mẽ amã harẽnh kêt nẽ. Ãm kêp kanrẽhã htàmnhwỳ pix ã harẽ. Kwa mo na htem Tawi pyrà nẽ kêp õ pahi hã harẽnh kêt nẽ? ");
INSERT INTO apnNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Na pre Tawi tãm Tĩrtũm kapẽr tũm kwỳ hã kagà nẽ tanhmã Tĩrtũm kot mẽ akaxyw ãm mã xwỳnhta jarẽnh to. Tĩrtũm Karõ nhỹ hã tanhmã harẽnh to. Tĩrtũm mex ã mẽ grer xàja kwỳ hã kagà nẽ hã kagà ho: Tĩrtũm na pre inhõ Pahihti mã ã kapẽr anẽ nẽ kãm: “E amnẽ ixwỳr tẽ nẽ inhĩhkô hã nhỹ nẽ inhmã mẽ ho amnhĩptàr o akrĩ. Kot paj mẽ kot kãm akurê xwỳnh piitã mẽ unênh pa nẽ awỳr mẽ o mra nẽ anhĩhkram mẽ haxàr pa.” Anhỹr o pre kãm kapẽr. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","—Na pre ã Tawi Tĩrtũm kot Kris mã kapẽr jarẽnh nẽ kêp õ pahi hã kagà anẽ. Tã nom Tĩrtũm kapẽr tũm o mẽ ajahkre xwỳnhjaja na htem kêp Tawi htàmnhwỳ pix ã ri axpẽn mã harẽnh o ri pa. No kêt Tawija na pre kêp õ Pahihti hã harẽnh o pa. Anẽ. Nhũm pre ã Jejus mẽ kãm amnhĩ jarẽnh anẽ nhũm mẽ mar o kuhê xwỳnhjaja kuma nẽ hkĩnh nẽ. Nẽ kãm axte mar prãm nẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Hãmri nhũm arĩ mẽ ahkre ho nhỹ nẽ mẽ kãm: —Kwa mẽ o kora. Kêr ka mẽ Tĩrtũm kapẽr tũm o mẽ ahkre ho mẽ pa xwỳnhjê kot amnhĩ nhĩpêx o amnhĩ nhĩpêx kêt nẽ. Mẽ omu nẽ ãm mẽ omu nẽ mẽ kot amnhĩ nhĩpêx kôt amnhĩ nhĩpêx kêt nẽ. Na htem piitã mẽ hã hpijaàm kaxyw ê mex pix kãm ri pa. Nẽ mẽ kot amnhĩm mẽ rũnh ã mẽ harẽnh nhũm mẽ kot amnhĩ jarẽnh marja na htem kãm hprãm. ");
INSERT INTO apnNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Nẽ Tĩrtũm kapẽr o mẽ ahkre xà hã ixkre kamã mẽ kãm amnhĩ to rũnh xwỳnhjê hkrĩ xà mex pix kamã na mẽ kãm hkrĩ hprãm. Nẽ mẽmoj tã mẽ apkur xà hã arĩgro hã ma hkwỳjê hkôt mẽ apkur xà hã ixkre hwỳr akuprõ nẽ kãm mẽ kot amnhĩ to rũnh xwỳnhjê hkrĩ xà mex pix kamã hkrĩ hprãm. ");
INSERT INTO apnNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","—Nẽ mẽ kot mẽ mjên htyk xwỳnhjê ho mex o pa hã amnhĩ jarẽnh tã amnhĩ to hêx. Nẽ na htem axtem nẽ mẽ nokupyr kaxyw mẽ hwỳr mra nẽ mẽ kãm: “E ot pa awỳr ato ajuta kaxyw tẽ. Ra amjên apê htyk jakamã kot paj pam amã akukrêx jamãr o ixpa.” Anẽ hãmri nẽ mẽ kêp mẽ õrkwỹ pytà nẽ amnhĩm mẽ kêp mẽ hikukrêx piitã ho hapêx. Te tãm kot mẽ hipêx o pa pyràk nom tãm mẽ hipêx kêt nẽ. Nẽ te tãm amnhĩ nhĩpêx pyrà nẽ Tĩrtũm mã amnhĩ jarẽnh japjêê ho kuhê. Te mẽ kot Tĩrtũm mã ãm hãmri amnhĩ jarẽnh pyràk tã hkwỳjaja kot ja hã mẽ omunh pix kaxyw nhũm mẽ ã kãm amnhĩ jarẽnh anẽ. Mỳrapê koja mẽ mex kêt nẽ. Koja Tĩrtũm tanhmã mẽ hipêx kati hto. Jakamã kwa kêr ka mẽ ã mẽ kot amnhĩ nhĩpêx anhỹr o mẽ pa xwỳnhjê kôt amnhĩ nhĩpêx o ri apa hkêt nẽ. Ãm kwarĩ ho kwarĩ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Nhũm Jejus arĩ Tĩrtũm mã amnhĩ jarẽnh xà hã ixkre kamã mẽ omunh o xa. Na pre hte Ijaew ixkreja o mex kaxyw ixkre jamãr xwỳnhjê mã hikàxpore hkwỳ nhõr o pa. Nhũm mẽ hikàxpore rũnh xwỳnhjaja hwỳr agjê nẽ kàxpore gjênh xà kamã hkwỳ ho rax nẽ hagjê nẽ ma akupỹm mra. ");
INSERT INTO apnNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Tã nhũm mẽhõ ni pê mjên htyk xwỳnhja haxwỳja hwỳr axà. Kêp amrakati kumrẽx. Nẽ hikàxpore tỳxre ãm pijakrutre htã kàxpore rũnh xwỳnhjê hpãnhã ixkreta wỳr tẽ. Nẽ kãm Tĩrtũm kĩnh xàj kàxpore gjênh xà kamã hamẽ kumẽ hãmri nẽ kato nẽ ma akupỹm tẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Hãmri nhũm Jejus amỳm ã kot amnhĩ nhĩpêx anhỹr ã omunh o xa nhũm ja kãm mex nẽ. Hãmri nẽ hkôt mẽ pa ho mẽ pa xwỳnhjê mã harẽ nẽ mẽ kãm: —E mãn ka mẽnire htẽm mũj pumu. Na pre mjên kêp ty nhũm kêp amrakati nẽ hikàxpore grire htã amnhĩ pê õr pa. Kwỳjê rom kãm Tĩrtũm kĩnh xàj amnhĩ pê õr pa. Apkur xà hã hikàxpore na. ");
INSERT INTO apnNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Kêt mẽ hkwỳjaja na hte hikàxpore hkwỳ pix o mra nẽ gjênh xà kamã hagjê nom arĩ mẽ hikàxpore rũnh. No nija na mẽ uràk nẽ kãm hikàxpore japê hkêt nẽ. Nẽ ho õxỳ hkêt nẽ àmnhĩx piitã o tẽ nẽ õr pa. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Tã hãmri nhũm Jejus kôt mẽ pa ho mẽ pa xwỳnhjaja arĩ Tĩrtũm mã amnhĩ jarẽnh xà hã ixkre kaxwỳnh pumunh o kuhê nẽ hã Jejus mã: —Hêxta waa nẽ. Ixkreja mex kumrẽx Pahihti. Kẽn rũnh o mẽ kot hipêx jakamã mex o mex. Nẽ mẽ kot ri Tĩrtũm mã hkĩnh xà nhõr nẽj haxwỳja piitã mex kumrẽx. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Hãmri nhũm mẽ kãm: —Nà mex tã koja nhỹrmã mẽ kãm Tĩrtũm kurê xwỳnhjaja grành pa. Koja arĩ kẽn axkrutre axpẽn mỳnh nẽ nõr kêt kumrẽx. Koja piitã anhgrà nẽ ahpỹnhã ri hikwỹ. Anhỹr o mẽ kãm kapẽr. ");
INSERT INTO apnNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Hãmri nẽ ixkreja rũm kato nẽ ma tẽ nẽ hixêt pê Oriwêhti hã api nẽ hã nhỹ. Tĩrtũm nhõrkwỹ kutã hixêtja nhũm hã api nẽ hã nhỹ. Hãmri nhũm Simãw Pêtre mẽ Xiakre mẽ Juãw mẽ Andreja ma hkôt mra. Ahte hkôt mra nẽ mẽ kot Tĩrtũm mã amnhĩ jarẽnh xà hã ixkre grành par ã hkukja nẽ kãm: ");
INSERT INTO apnNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","—Kwa xà ãm hãmri koja mẽ ã ixkreja nhĩpêx anẽ? E aprĩ hã mẽ inhmã harẽ. Xà koja mẽ nhỹrmã kugrà nà xà koja mẽ tokyx ho anẽ? Kwa mẽmo koja we wỳj ri tanhmã amnhĩ nhĩpêx to? Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","6","Hãmri nhũm mẽ kãm: —Nà kot paj mẽ amã harẽ. Nom nhỹrmã mẽmoj piitã hapêx kaxyw tanhmã amnhĩ nhĩpêx to kumrẽx kot paj mẽ amã harẽ ka mẽ inhma. Koja mẽ ohtô nẽ mẽ apê ixkwỳjê hwỳr mra nẽ hêx rom te pa ixte amnhĩ nhĩpêx pyràk o amnhĩ nhĩpêx o pa. Nẽ tanhmã mẽ amã amnhĩ jarẽnh to nẽ mẽ amã: “E pa na pre Tĩrtũm mẽ awỳr inhmẽ. Ixpê kaxkwa rũm ixwrỳk xwỳnhta na pa.” Anhỹr o mẽ akôt mẽ amã amnhĩ to hêx o pa. Nẽ mẽ amã: “E na pa mẽ ato amnhĩptàr kaxyw mẽ awỳr wrỳ.” Anhỹr o mẽ amã amnhĩ jarẽ. Nom kêr ka mẽ ama nẽ ãm mẽ ama. Mẽ kot amnhĩ to hêx xwỳnh na mẽ. Kormã akupỹn ixpôx xà hã arĩgroja kormã. ");
INSERT INTO apnNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","—Nẽ koja mẽ nhỹri awry hã axpẽn par o pa. Nẽ mẽ atãã axpẽn par o pa. Nom kêr ka mẽ harẽnh ma nẽ ri tee ri tokyx mẽmoj piitã hapêx ã hkamnhĩx kêt nẽ. Mẽmoj piitã hapêx xà hã arĩgroja kormã. ");
INSERT INTO apnNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","—Nẽ koja mẽmoj piitã hapêx kaxyw nhũm ahpỹnhã ri pika piitã hkôt mẽ pa xwỳnh piitã pika hõ nhõ xwỳnhjê kutã amnhĩ xunhwỳ nẽ axpu nẽ axpẽn pa. —Nẽ koja pika piitã hkôt tanhmã mẽ à kuteja mẽ hamỳ nhũm mẽ amnhĩ xà htỳx kãm hamak o pa. Nhũm nhỹri pika htertet tỳx nẽ. Nẽ nhỹhỹnh pika hkwỳ kamã mẽ pa xwỳnhjaja prãm xàj pikaprãr pa. Tã nom kormã mẽ kot amnhĩ xà htỳx kãm hamak xà hkrax pix na ja. Te mẽnijaja pijagri kaxyw nẽ kormã õhy xà hpỹnh pyràk. Koja mẽmoj piitã hapêx kaxyw nẽ ã amnhĩ nhĩpêx anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","—E pa hpãnhã mẽ kot Tĩrtũm mã amnhĩ jarẽnh xà hã ixkre grành par xwỳj ri mẽmoj tanhmã kot hkukamã amnhĩ nhĩpêx to hã hã harẽ. Mẽ ate hã ixkukjêr xwỳnhta kot paj mẽ amã harẽ. Nà koja mẽ kãm ixkurê xwỳnhjaja mẽ awỳr mra nẽ ixtã mẽ apynê nẽ mẽ atomnuj nẽ. Nẽ ma mẽ pikuprõnh xà hã ixkre hwỳr mẽ ato mra nẽ kamã mẽ kãm mẽ ato kapẽr punuj nẽ nhũm mẽ kuma nẽ ma mẽ ato mra nẽ mẽ ajagjê. Mẽ ate ixkôt apa ho apa xwỳnh ã ã mẽ anhĩpêx anẽ. Nẽ mẽ õ pahihti hwỳr mẽ ato mra nẽ mẽ kãm tanhmã mẽ ato kapẽr punuj to. ");
INSERT INTO apnNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Tã nom kwa kêr ka mẽ kutã akuhê nẽ mãmrĩ tãm mẽ kãm ijarẽnh o akuhê. ");
INSERT INTO apnNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Nom kêr ka mẽ kãm amnhĩ jarẽnh kukamã tee ri ajamaxpẽr o ri amã mẽ uma hkêt nẽ akuhê. Rỳ mẽ ajamaxpẽr o: “Hêxta waa nẽ. Mẽ kot ixkukjêr ã arĩgrota ã tanhmã kot pa we ri mẽ kãm amnhĩ jarẽnh to?” Anhỹr o tee ri amnhĩ kukamã ajamaxpẽr kêt nẽ. Koja Tĩrtũm Karõ tanhmã mẽ akrã hto ka mẽ ỹ hã akatàt kôt tanhmã mẽ kãm amnhĩ jarẽnh to. ");
INSERT INTO apnNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","—Nẽ mẽ atõ nẽ mẽ anhĩpêêxà nẽ mẽ akrajaja koja mẽ ixtã mẽ atã amỹnê nẽ ma pahi hwỳr mẽ ato mra nẽ kãm mẽ ajarẽ nhũm mẽ kuma nẽ mẽ ajagjê nẽ mẽ akwỳjê pa. ");
INSERT INTO apnNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Koja mẽ piitã ixkôt mẽ akamã gryk nẽ ã kãm mẽ akurê ho pa anẽ. Nom mẽ kot ã mẽ anhĩpêx anhỹr mã tã kêr ka mẽ amnhĩ to htỳx nẽ ixkaga hkêt nẽ. Mẽ kot mẽ apar tã ka mẽ kaxkwa kamã akupỹm atĩr kurê kumrẽx. Hãmri nẽ mẽ kurom Tĩrtũm mẽ wa ixri atĩr tũm nẽ amex rãhã nẽ apa ho apa. Mẽ kot tanhmã mẽ ato htã mẽ apê akupỹm kaxkwa kamã atĩr tũm nẽ apa mã xwỳnh jakamã kwa tee ri amnhĩ kukamã ajamaxpẽr o ri apa hkêt nẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","16","Nhũm Jejus arĩ mẽ kãm kapẽr nẽ mẽ kãm: —Nẽ koja nhỹrmã kot mẽ atomnuj tỳx kumrẽx xwỳnh maatija axtem nẽ Tĩrtũm mã amnhĩ jarẽnh xà hã ixkreja kamã amnhĩ xãm. Hãmri ka mẽ ja hã omu nẽ mẽ kot krĩ grành par mã ajamaxpẽr kurê kumrẽx. Koja ã amnhĩ nhĩpêx anẽ ka mẽ amỳm amnhĩ wỳr mẽ omu hãmri nẽ ajapôj nẽ ma aprõt nẽ amrar kurê kumrẽx. Mẽ apê jar pika pê Jutej kamã mẽ apa xwỳnhjaja mẽ omu hãmri nẽ mẽ kot mẽ apar pymaj ma aprõt nẽ amrar kurê kumrẽx. Hixêt prêk wỳr ajapôj nẽ aprõt nẽ ma mra. Nẽ jar Jerujarẽ nhõ xwỳnhjaja kê mẽ umaj haxwỳja hapôj nẽ ma hprõt nẽ ma mrar o mra. Nẽ kapôt ã ri mẽ pa xwỳnhjaja kê mẽ ê jamỳnh kaxyw akupỹm krĩ hwỳr gjêx kêt nẽ. Ãm ma mẽ umaj hprõt nẽ mrar o mrar kurê kumrẽx. ");
INSERT INTO apnNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","—Nẽ mẽ htujarô xwỳnhjaja nẽ mẽ hkra karàre xwỳnhjaja. Jajê pê koja mẽmoj omnuj tỳx nẽ. Tanhmã kot wem amnhĩ to nẽ hprõt tỳx? Nà pika ja kamã koja mẽ mex kêt nẽ. Mẽ kot amnhĩ tomnuj mỳrapê koja Tĩrtũm tanhmã mẽ homnuj tỳx to. ");
INSERT INTO apnNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","19","—Koja ã mẽmoj amnhĩ nhĩpêx anẽ hãmri nhũm mẽ piitã amnhĩ xà htỳx kãm hamak rũnh o pa. Tĩrtũm kot mẽ piitã mẽ ho kator krax rũm amnẽ mẽ pa xwỳnhjaja na mẽ kormã à htỳx kamã hamak rũnh kêt nẽ. Kormã amnhĩ xà kamã hamak kryre. No nhỹrmã mẽ hprõt xà hã arĩgrota ã koja mẽ amnhĩ xà htỳx kamã hamak rax kumrẽx. —Tã akupỹn ixte mẽ awỳr ixwrỳk xà hã arĩgrota ã kot pa mẽmoj punuj o ijapêx pa ka mẽ axte ã mẽmoj kot anhỹr pumunh kêt nẽ. Nom kormã akupỹn ixwrỳk xwỳj ri kot kaj mẽ amnhĩ xà htỳx kamã ajamak o apa. Jakamã kêr ka mẽ ã amnhĩ nhĩpêx anhỹrja kukamã amnhĩ to Tĩrtũm wỳ nẽ kãm: “Pa Tĩrtũm. Kwa kê mẽmoj ã amnhĩ nhĩpêx anhỹr kaxyw hãmri kê amgrà pê ã amnhĩ nhĩpêx anẽ. Koja na pê ã amnhĩ nhĩpêx anẽ nhũm omnuj tỳx nẽ.” Anhỹr o amnhĩ to awỳ. ");
INSERT INTO apnNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","—Mẽ hprõt xà hã arĩgrota ã koja Tĩrtũm kãm mẽ apê hkrajaja mẽ atyk par pymaj mẽ anê mẽmo punuta ã arĩgro hkwỳ grà nẽ mẽ akukamã mẽ amã ho grêre. Koja mẽ akamã ukaprĩ xàj ã mẽ anê hipêx anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","—Nẽ koja ã mẽmoj amnhĩ nhĩpêx anhỹr kaxyw hãmri nhũm mẽ hêx o mẽ pa xwỳnhjaja ma mẽ awỳr mra nẽ hêx rom tanhmã mẽ amã kapẽr to nẽ mẽ amã: “E ota ra Tĩrtũm kot mẽ pakaxyw ãm xwỳnhta pôj. Kwa mẽ tokyx hwỳr mra nẽ omu nẽ hkôt ri apa.” Anhỹr o mẽ amã hêx. Hãmri nhũm mẽ hkwỳjaja tee ri mẽ kuma nẽ mẽ amã: “Nà tãm kêt. Jar mẽ ixkamã na. E mẽ tokyx amnẽ hwỳr mãn mra nẽ omu.” Anhỹr o mẽ amã hêx o pa. Nom kêr ka mẽ ama nẽ ãm mẽ ama nẽ mẽ hkôt amrar kêt nẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","23","—E kwa mẽ inhma. Na pa ra ixprĩ hã mẽmoj kot ã amnhĩ nhĩpêx anhỹrja kukamã mẽ amã tanhmã harẽnh to. Tã kêr ka mẽ axkãm ajamak rom nẽ ri apa. Koja mẽ kot amnhĩ to hêx xwỳnhjaja axpẽn pãnhã mẽ awỳr mra nẽ mẽ amã kêp Tĩrtũm kot mẽ akaxyw ãm xwỳnh ã amnhĩ to hêx. Nẽ mẽ hkwỳjaja kêp Tĩrtũm nhỹ hã kapẽr jarẽnh xwỳnh ã amnhĩ to hêx. Hãmri nẽ aa mẽ kot mẽmoj pumunh kêt kwỳ ho anhỹr o pa. Te Tĩrtũm nhỹ hã kot ho anhỹr pyràk nom hêx rom mẽ apê Tĩrtũm kot amnhĩm mẽ arênh xwỳnhjê nokupyr kaxyw ã amnhĩ nhĩpêx anhỹr o pa. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","25","Nhũm Jejus arĩ mẽ kãm kapẽr nẽ mẽ kãm: —Tã koja mẽ kot amnhĩ xà htỳx kamã hamak xà hã arĩgrota hapêx nhũm Tĩrtũm ã mẽmoj nhĩpêx anẽ. Koja kaxkwa ho àk tỳx nẽ nhũm myyti ahtyk. Nhũm mytwrỳre axte hirã hkêt nẽ. Nhũm kanhêti piitã axrê nẽ rôrôk pa. ");
INSERT INTO apnNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Hãmri pa man akupỹn pika hwỳr wrỳ nhũm mẽ piitã ixwrỳk kãm ixpumu. Kakrã kamã kot paj ixihtỳx o inhĩrã rax kãm akupỹn mẽ awỳr wrỳ. ");
INSERT INTO apnNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Hãmri nẽ ma krĩ piitã hwỳr Tĩrtũm kapẽr o mẽ wrỳk xwỳnhjê rẽ nhũm mẽ ma mra nẽ amnepêm ixte amnhĩ kaxyw mẽ axunhwỳr xwỳnh piitã ho akuprõ nẽ akupỹn ixwỳr mẽ ho mra. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Nhũm Jejus arĩ mẽ kãm kapẽr nẽ mẽ kãm: —E ka mẽ pĩ hpàr mũj pumu. Na hte mẽmo mytwrỳ hã rã nhũm mẽ omu nẽ ô hkukamã hamaxpẽr kurê kumrẽx. ");
INSERT INTO apnNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Ja pyrà nẽ koja mẽmoj ã amnhĩ nhĩpêx anhỹr mẽ ka mẽ akupỹn mẽ awỳr ixwrỳk mã ajamaxpẽr kurê kumrẽx. ");
INSERT INTO apnNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Koja akupỹn ixpôx kêt ri ã mẽ kot mẽmoj kot amnhĩ nhĩpêx anhỹr pumunh xwỳnhjaja kormã piitã htyk par kêt ri pa akupỹn mẽ awỳr wrỳ. ");
INSERT INTO apnNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","—Nẽ koja nhỹrmã pika nẽ kaxkwa wa hapêx pa. Tã no ãm ixkapẽr koja wa uràk nẽ aa hapêx kêt nẽ. Koja ãm rãhã ho rãhã. Kot paj aa ihkjê ho tanhmã mẽnh to hkêt nẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Nhũm Jejus arĩ mẽ kãm kapẽr nẽ mẽ kãm: —Nom akupỹn ixwrỳk xà hã arĩgroja mẽ ate omunh kêt. Nẽ kaxkwa kamã Tĩrtũm kapẽr o mẽ wrỳk xwỳnhjaja kot ja pumunh kêt. Nẽ pa ixpê Tĩrtũm Kra htã ijaxwỳja ixte ja hã amnhĩ pumunh kêt. Ãm Mẽpahpãm maatija tapxipix kot ja pumunh. ");
INSERT INTO apnNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","—Tã mẽ ate akupỹn ixwrỳk xà hã arĩgro pumunh kêt jakamã kwa kêr ka mẽ axkãm ajamak rom nẽ ri apa. Nẽ apkati mẽ amnhĩ wỳr ijapêr arĩt rãhã ho ri apa. ");
INSERT INTO apnNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","35","—E pa tanhmã mẽ amã akupỹn ixwrỳk xà hã arĩgro jarẽnh to ka mẽ inhma. Koja mẽhõ nhỹhỹm nojarêt hãmri nẽ kãm mẽ àpênh xwỳnhjê mã mẽ àpênh ã karõ nẽ õrkwỹ jamãr xwỳnh mã tanhmã kãm karõ hto. Hãmri nẽ õrkwỹ kahê xà jamãr xwỳnh mã kãm: “E kêr ka ixwakre kamã ijapêr arĩt rãhã ho ri apa.” Anẽ hãmri nẽ ma nhỹhỹm mõ. Tã mẽ kot ijapêr rĩt rãhã ho mẽ pa xwỳnhjaja te kot ixkre kahê xà jamãr xwỳnh kot amnhĩ nhĩpêx pyràk. Õ patrãwja akupỹn hpôx xà hã arĩgro hã omunh kêt jakamã na hte kahê xà jamãr rãhã ho pa. Koja apu axpẽr kamàt nhũm akupỹn hpôx japêr. Rỳ kôt ã kamàt rỳ krãhyre kà nhũm akupỹn hpôx japêr. Rỳ kwỳhtyk nhũm akupỹn hpôx japêr. Tã uràk nẽ mẽ ate akupỹn ixwrỳk xà hã arĩgro pumunh kêt jakamã kêr ka mẽ ijamãr rãhã ho ri apa. Jao ixkutêp inhmã tanhmã amnhĩ nhĩpêx to rãhã nẽ. Ra ixte mẽ amã hã karõ xà hkôt. ");
INSERT INTO apnNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Kop ixkre kahê xà jamãr xwỳnhja tee ri õ patrãw kamã ama hãmri nẽ ra õtxwa nẽ htỳx õt o ỹr rôm nhũm haêr pê hwỳr hpôx ronhỹx ja kêp mex kêt nẽ. Ja pyrà nẽ kêr ka mẽ ixkutêp ixkôt amnhĩ nhĩpêx rãhã ho ri apa. Nom tee ri amnhĩ wỳr ixkãm ama hãmri nẽ axte inhmã ajamaxpẽr kêt pê atỳx ri tanhmã amnhĩ tomnuj to ho apa hkêt nẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","—E ixte mẽ amã mẽmoj jarẽnhja na pa hte ixkwỳjê piitã mẽ kãm harẽ. Jakamã kwa kêr ka mẽ akupỹn ixwrỳk ã ijapêr arĩt rãhã ho ri apa. Anẽ. Nhũm pre ã Jejus amnhĩ kukamã mẽ kãm ujarẽnh anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Tã nhũm Ijaew hkĩnhã ã arĩgro pê Pas wỳr apkati axkrut. Pas ã na hte mẽ ixpê Ijaewjaja amnepêm Tĩrtũm kot pika pê Ejit pê mẽ inhĩgêt nẽ mẽ ixpãmjê kator mã ijamaxpẽr kaxyw axpẽn wỳr akuprõ nẽ hã ixkĩnh. Na pa htem arĩgroja mã: “Pas” anẽ. Nẽ harẽnh o: “Mẽ pahte pãw kaxkrit kêt kur ã arĩgro” anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Jakamã nhũm mẽ inhõ patre krãhtũmjê mẽ Tĩrtũm kapẽr tũm o mẽ ahkre xwỳnhjaja kãm Jejus pĩr prãm nẽ. Nom mẽ kãm hkôt kapẽr mar o mẽ pa xwỳnhjê pyma nẽ. Nẽ tee ri hã amnhĩ jahkre nẽ axpẽn mã: —Hêxta waa nẽ. Tanhmã kot puj wem ho nẽ kupĩĩ? Kot puj mẽ pahkĩnh kãm tanhmã ho nhũm mẽ hkĩnh xwỳnhjaja hã mẽ pahpumu nẽ mẽ pakamã gryk tỳx nẽ. Pu mẽ hã axpu nẽ hã tanhmã axpẽn to. Jakamã kwa pu mẽ kormã tanhmã ho hkêt nẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Rôm nhũm Jejus Simãw nhõrkwỹ kamã kormã apkur o nhỹ. Krĩ pê Petãn kamã. Simãwja na pre hkà kro xàpêr tỳx o pa nhũm Jejus akupỹn ho mex. Jakamã akupỹm õ krĩ hwỳr pôj nẽ kutã apkur o nhỹ. Hãmri nhũm mẽhõ nija harẽnh ma nẽ mẽ hkuxwa xà hã kàx õ py nẽ ma hwỳr o tẽ. Nẽ mẽ hwỳr axà nẽ nhỹhỹnh kàx kahte nẽ mẽ hkuxwa xà ho hkrã gregrer pa. ");
INSERT INTO apnNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Hãmri nhũm mẽ apkur o hkrĩ xwỳnhjaja tee ri ã kot amnhĩ nhĩpêx anhỹr ã omu nẽ kamã gryk nẽ. Nẽ axpẽn mã: —Tk. Kwa nà na hã mẽ hkuxwa xàta kapĩr par kumrẽx. ");
INSERT INTO apnNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Kop apu ma o htẽm nẽ ho wẽnê nẽ hpãnhã kàxpore ho rax kumrẽx nẽ hamỳnh nẽ ho mẽ kêp amrakati xwỳnhjê nhĩpêx par nhỹx ja kãm mex nẽ. Mo na ri ã amnhĩ nhĩpêx anhỹr kêt nẽ? Anẽ nẽ hã kãm akir. ");
INSERT INTO apnNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Hãmri nhũm Jejus mẽ kuma nẽ mẽ kãm: —Tk. Kwa mẽ kãm axàkjêr kêt nẽ. Ãm hãmri na ã inhĩpêx anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Mẽ kêp amrakati xwỳnhjaja koja mẽ arĩ mẽ akôt pa rãhã nẽ. Ka mẽ amã mẽmo arĩgro hã mẽ ho ajuta hprãm nẽ tanhmã mẽ ho ajuta hto nẽ mẽ kãm mẽmoj gõ. No pa kot paj ri mẽ akôt ixpa ka mẽ ixto mex ry ho apa hkêt nẽ. Kot paj tokyx mẽ are. ");
INSERT INTO apnNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Ixtyk nhũm mẽ kot ijaxàr kukamã na ã ixkrã gregrer anẽ. Ãm hãmri na ã inhĩpêx anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","ãm hãmri na pa mẽ amã ja jarẽ. Koja mẽ krĩ piitã hkôt axpẽn mã ixte tanhmã mẽ anê amnhĩ nhĩpêx to hã ijarẽnh o pa nẽ mããnẽn kot ã inhĩpêx anhỹrja mããnẽn harẽnh o pa. Nhũm mẽ piitã kot tanhmã ixto mex to hã harẽnh ma. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Tã nhũm Jut Kariotja. Jejus kôt mẽ pa ho mẽ pa xwỳnh pê 12 hõ na pre. Tã axtem nẽ Satanasti nhỹ hã ma patre krãhtũmjê hwỳr tẽ nẽ axtem nẽ tanhmã Jejus o mẽ mar to nẽ mẽ kãm: —E ot pa mẽ amã Jejus jarẽnh o tẽ. Xà kot paj mẽ amã hã amỹnê ka mẽ hpãnhã inhmã amnhĩre nà? Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Hãmri nhũm mẽ kuma nẽ hkĩnh nẽ. Hãmri nẽ kãm: —Nà kot paj mẽ amã amnhĩre. Anẽ. Hãmri nhũm mẽ kuma nẽ kato nẽ ma tẽ nẽ Jejus pynênh kaxyw htãnopxar o hkôt ri pa. ");
INSERT INTO apnNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Tã nhũm arĩgro pê Pas kato. Amnepêm mẽ inhĩgêtjaja na prem ôwêhti hkrare hkwỳ pa. Tĩrtũm kot ja hã mẽ omunh nẽ Ejit kãm mẽ kãm mẽ hkurê xwỳnhjê nhĩhkra nê mẽ kator kaxyw na prem ã amnhĩ nhĩpêx anẽ. Jakamã na pa htem arĩ mẽ ixpê mẽ hkanrẽhã mẽ htàmnhwỳjaja Pas ã axpẽn wỳr akuprõ nẽ jam ijamaxpẽr pê mẽ uràk nẽ ôwêhti hkrare hkwỳ hpa nẽ pãwti kaxkrit kêt kãm kuku. Jakamã nhũm Jejus kôt mẽ pa ho pa xwỳnh pê 12jaja Pas ã mẽ apkur xà hã Jejus kukja nẽ kãm: —Kwa nhỹri kot paj mẽ akutêp Pas ã mẽ panhõ hã apê? Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Hãmri nhũm mẽ kuma nẽ ja wa ho axkrut nẽ mẽ amnhĩ kukamã wa kumẽ nẽ wa kãm: —E wa ma Jerujarẽ hwỳr wa tẽ. Nẽ hwỳr axà nẽ mẽhõ myja pumunh kurê kumrẽx. Nhũm amnhĩm gô ru nẽ amnhĩ kre hã poti xãm nẽ o tẽ ka wa omu nẽ hã ajêt nẽ ma õrkwỹ hwỳr hkôt tẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Hãmri nẽ ixkre nhõ dõn pumu nẽ kãm: “E Jejus na wa inhmẽ pa wa awỳr tẽ. Na awỳr pẽr mẽnh o: ‘Nhỹri kot paj we ixkôt ri mẽ pa ho pa xwỳnhjê mẽ Pas ã axpẽn kutã apku?’ Anhỹr o na awỳr pẽr mẽ.” ");
INSERT INTO apnNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","—Wa ã kãm akapẽr anẽ kê war ama nẽ war amã õrkwỹ nhĩmõk ã ixkre rax õ jahkre. Ra kamã kaxyw mẽ paxàpkur xà hã mẽmoj piitãã. Ka wa omu nẽ mãmrĩ kamã mẽ ixkutêp mẽ panhõ hã apê. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Hãmri nhũm wa kuma nẽ ma hwỳr tẽ. Nẽ krĩm axà nẽ ra kot wa kãm mẽmoj jarẽnh xà hkôt mẽmoj piitã omu nẽ mẽ kutêp mẽ kãm mẽõ hã àpênh o wa xa. ");
INSERT INTO apnNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Tã nhũm kamàtre nhũm Jejus mẽ hkôt mẽ pa ho pa xwỳnhjaja wa hkôt mõ. ");
INSERT INTO apnNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Hãmri nẽ kỳxpê ixkreja wỳr api nẽ hwỳr agjê nẽ apkur kaxyw hkrĩ hpa nẽ kormã apkur o hkrĩ nhũm Jejus mẽ kãm: —E pa mẽ amã mẽmoj jarẽ ka mẽ inhma nẽ amnhĩ krãm haxàr tỳx nẽ. Kot kaj mẽ ixkutã axàpkur o akrĩ xwỳnhjê hõ mẽ kãm ixkurê xwỳnhjê mã ixtã amỹnê. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Hãmri nhũm mẽ tee ri kuma nẽ hkaprĩ htỳx nẽ. Nẽ axpẽn pãnhã amnhĩ tã hkukja nẽ kãm: —Kwa xà pa kot paj ã anhĩpêx anẽ? Nà pa hkêt. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Hãmri nhũm mẽ kãm: —Nà mẽ apê 12jê hõ kot kaj ã inhĩpêx anẽ. Mẽ ate ixkutã guhkrax kãm anhõ pãwti ho mry kagô nhek o akrĩ xwỳnhjê hõ kot kaj ixtã amỹnê. ");
INSERT INTO apnNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Tĩrtũm kapẽr ã kagà htũm kot ixkukamã harẽnh xà hkôt koja mẽ tanhmã ixto rax nẽ ixpĩ. Nom kot mẽ kãm ixtã àmnênh mã xwỳnhta hêxta waa nẽ. Ã kot amnhĩ nhĩpêx anhỹrja mỳrapê koja amnhĩ xà htỳx kãm hamak rax kumrẽx. Kop apu aa õ mãmãj nhõxà hkre rũm kator kêt ronhỹx ja kãm mex nẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Anẽ nẽ kormã mẽ apkur o hkrĩ rôm nhũm pãwti hõ py nẽ ho Tĩrtũm wỳ. Hãmri nẽ mẽ kãm ho hkry nẽ mẽ piitã mẽ kãm õr pa nẽ mẽ kãm: —E na pa mẽ amã pãwti ho hkry nẽ mẽ amã kugõ. Ja pyrà nẽ koja mẽ ã inhĩpêx anẽ nẽ te ixto hkry hpar pyràk o inhĩpêx pa amnhĩ xà htỳx kamã ijamak kãm ty. Nom mẽ anê kot paj ty. E mẽ mãmrĩ aku. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","24","Nẽ hpãnhã wĩhti hã kop py nẽ mã ho anẽ nẽ Tĩrtũm mã harẽ. Hãmri nẽ mẽ kãm kugõ nẽ mẽ kãm: —E mẽ kot ixpĩr xà hã arĩgrota ã koja ixkamrô axkapĩ. Nom koja mẽ amarĩ ixpĩr nhũm amarĩ hpikapĩr kêt nẽ. Ãm paa. Pa kot paj mẽ anê mẽ ĩhkram amnhĩ jaxà nhũm mẽ ã inhĩpêx anẽ. Koja ixkamrô axkapĩ nhũm Tĩrtũm omu nẽ ixkukwak ri mẽ anê mẽ ate amnhĩ tomnuj piitã amnhĩ katut kôt rẽnh pa nẽ mẽ ato hkra. Ra amnepêm kot ja hã amnhĩ jarẽnh xà hkôt. Jakamã e. Mẽ axpẽn pãnhã ixkamrô pikapĩr mã ajamaxpẽr pê ixte mẽ amã kop kãm wĩhti nhõrta o akõm o axpẽn nhĩpêx. Anẽ. Nhũm pre ã mẽ kãm amnhĩ jarẽnh anẽ nhũm mẽ piitã ho hkõm o axpẽn nhĩpêx. ");
INSERT INTO apnNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Hãmri nhũm mẽ kãm: —Ãm hãmri na pa mẽ amã amnhĩ jarẽ. Kot paj axte wĩhti ho ixkõm kêt rãhã nhỹrmã Inhõ Papaj akupỹn mẽ awỳr inhmẽ. Hãmri pu mẽ rĩ kormã akupỹn ixpôx xà hã arĩgrota ã pahkĩnh nẽ. Nom axtem tanhmã hã pahkĩnh to. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Nhũm pre ã mẽ kãm kapẽr anẽ hãmri nhũm mẽ Tĩrtũm mã mex o mex ã gre hãmri nẽ hapôx pa nẽ ma hixêt pê Oriwêhti hwỳr mra. ");
INSERT INTO apnNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Tã nhũm Jejus hkôt mẽ pa ho pa xwỳnhjê hkukamã tanhmã mẽ kãm ujarẽnh to nẽ mẽ kãm: —E mẽ inhmã. Tĩrtũm kapẽr ã kagà htũm kot ã mẽ pajarẽnh kot anhỹr. Kot paj ôwêhti jamãr o pa xwỳnhja pĩ hãmri nhũm ôwêhti hpigrành pa nẽ ma anhgrà nẽ ri mra. Anhỹr o te ixpê ôwêhti jamãr xwỳnh nhũm mẽ apê ôwêhti pyràk ã mẽ pajarẽnh. Tã kot puj mẽ ã amnhĩ nhĩpêx anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Mẽ kot ixpĩr tã koja Tĩrtũm akupỹm ixto ixtĩr. Pa akupỹm ixtĩr nẽ ma mẽ akukamã pika pê Garirej wỳr mõ. Kamã kot puj mẽ axte axpẽn pumu. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Hãmri nhũm Simãw Pêtre tee ri mẽ amnhĩ tã kuma nẽ kãm: —Kwa nà. Ri ã mẽ ijarẽnh anhỹr kêt nẽ Pahihti. Kot paj akaga hkêt nẽ. Jajaja koja anhgrà nẽ hprõt nẽ ma mrar japêr no pa kot paj anhỹr kêt nẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Hãmri nhũm kãm: —Nà kot kaj anẽ Simãw Pêtre. Koja apkati hkôt krãhyre hkàr kêt ri ka ra mẽ umaj ate ixkôt apa hkêt ã mẽ kãm amnhĩ tã axàprãr o axkrunẽpxi kãm ga. Kwa jam ajamaxpẽr tỳx nẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Hãmri nhũm tee ri amnhĩ tã kuma kãm amnhĩ tã àprãr kãm hihtỳx nẽ kãm: —Tk. Kwa nà. Kot paj ã amnhĩ nhĩpêx anhỹr kêt nẽ. Koja mẽ tee akôt ixpĩr mã tã no pa ãm aa akaga hkêt kumrẽx. Kot paj akôt ixpa ho ixpa rãhã nẽ. Anẽ. Hãmri nhũm hkôt mẽ pa ho mẽ pa xwỳnh kwỳjê piitã ã kãm amnhĩ jarẽnh anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Tã nhũm Jejus ma nhỹri mẽ kot kãm “Gesẽm” anhỹr xwỳnhja wỳr hkôt mẽ pa ho pa xwỳnhjê ho mõ. Hãmri nẽ mẽ kãm: —E mẽ jar ixkutêp akrĩ. Pa ma mũtũm tẽ nẽ Tĩrtũm mã amnhĩ jarẽ mãn. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Hãmri nẽ amnhĩ kôt mẽ ho axkrunẽpxi nẽ mẽ o mõ. Simãw Pêtre mẽ Jepetew kra pijakrut pê Xiakre nẽ Juãwja nhũm amnhĩ kôt mẽ o mõ. ");
INSERT INTO apnNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Hãmri nẽ amnhĩ kukamã mẽ kãm hkurê xwỳnhjaja kot tanhmã hipêx tota kukamã hamaxpẽr o ra amnhĩ kamã kahak tỳx o ra hkaprĩ nẽ. Hãmri nẽ hkôt mẽ mrar xwỳnhjê mã kãm: —Hêxta waa nẽ. Na pa tee ri amnhĩ xà htỳx kamã ijamakja kukamã ijamaxpẽr nẽ amnhĩ kamã ixkahak tỳx o ixkaprĩ nẽ. Te ra ixkaprĩja kot ixpĩr o mõr pyràk. Jakamã e mẽ jar anohtỳx nẽ ixto Tĩrtũm wỳr o akrĩ kê tanhmã ixto pa mẽ kot tanhmã ixtoja kutã ixihtỳx nẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Hãmri nẽ mẽ kurũm htẽm grire nẽ amnhĩ kamã kahak o Tĩrtũm mã amnhĩ jarẽnh kaxyw htu mỳr pê htẽm nẽ pikap nõ nẽ kãm: ");
INSERT INTO apnNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","—Kwa Papaj. Hêxta waa nẽ. Inhmã amnhĩ xà htỳx kãm ijamak prãm kêt kumrẽx. Na pa tee ri amnhĩ kukamã ijamaxpẽr nẽ amnhĩ kamã ixkahak tỳx nẽ. Jakamã kot kaj amã inhnê ja ho ajapêx prãm nẽ mãmrĩ ho ajapêx nhũm mẽ kãm ixkurê xwỳnhjaja tanhmã ixto hkêt nẽ. Rỳ ko. Kot kaj amã mẽ kot tanhmã ixto hprãm kê mẽ mãmrĩ tanhmã inhĩpêx to. Nom pam inhmã hprãm xà hkôt kêt. ");
INSERT INTO apnNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Anhỹr o Tĩrtũm mã amnhĩ jarẽ hãmri nẽ kànhmã xa nẽ akupỹm Simãw Pêtreja mẽ hwỳr tẽ nẽ mẽ omu nhũm mẽ ra htỳx gõr nẽ hikwỹ. Hãmri nhũm tee ri mẽ omu nẽ Simãw Pêtre mã kãm: —Kwa Simãw Pêtre. E mẽ hãmri akrã hapôj. Kwa wem anohtỳx grire nẽ ixkutêp amnhĩ to Inhõ Papaj wỳr o akrĩ ");
INSERT INTO apnNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","kê mẽ ixkôt tanhmã mẽ ato htã ka mẽ amã mẽ uma xàj ixkaga hkêt nẽ arĩ mẽ kutã amnhĩ to htỳx nẽ akuhê. Ã mẽ amã mẽ ate amnhĩ nhĩpêx anhỹr prãm nom kormã mẽ amã maa. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Hãmri nẽ akupỹm tẽ nẽ axte Tĩrtũm mã tanhmã amnhĩ jarẽnh to. ");
INSERT INTO apnNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Nẽ akupỹm mẽ hwỳr tẽ nẽ mẽ omu nhũm mẽ axte õt pa nẽ hikwỹ. Nhũm tẽ nẽ tee ri mẽ omu hãmri nẽ tanhmã mẽ kãm nẽ hkêt nẽ. Ãm awjanã nẽ ma akupỹm tẽ nẽ axte Tĩrtũm mã amnhĩ jarẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","42","Hãmri nẽ akupỹm mẽ hwỳr tẽ nẽ mẽ kãm: —Kwa xàn ka mẽ arĩ gõr nẽ anhĩkwỹ? E mẽ tokyx akrã hapôj. Na mẽ ra ixwỳr mrar nẽ kot ixpynênh mã. Koja mẽ tokyx ixkutã mẽ kot amnhĩ xunhwỳr xwỳnhjaja mẽ kãm ixtã amỹnê. Ota ra kot ixtã mẽ kãm àmnênh xwỳnhta tẽ. E mẽ tokyx kànhmã akrĩ pu mẽ kutã mra. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Nhũm Jejus kormã mẽ kãm kapẽr o ãm rãhã nhũm Jut Kariotja tẽ. Mẽ hkôt mẽ pa ho mẽ pa xwỳnhjê hõ htã nhũm ra amnhĩ kôt mẽ ohtô nẽ Jejus wỳr mẽ o tẽ nhũm mẽ wapohti nẽ kô jamỳ nẽ hkôt o mra. Patre krãhtũm mẽ Ijaew krãhtũmjê mẽ Tĩrtũm kapẽr tũm o mẽ ahkre xwỳnhjaja ra Jut kôt mẽ kurẽ nhũm mẽ man hkôt Jejusja wỳr mra. ");
INSERT INTO apnNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Na pre ra Jut Kariotja mẽ kãm tanhmã amnhĩ jarẽnh to nẽ mẽ kãm: —E kot paj nhỹri mẽ pahte unênh mã xwỳnhta pumu nẽ hwỳr tẽ nẽ kahti hkôt kumỳ nẽ tanhmã kãm ixkapẽr to. Ka mẽ ixpumu nẽ hwỳr tẽ nẽ unê nẽ ma akupỹm o tẽ. Anẽ hãmri nẽ ma hwỳr mẽ o tẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Nẽ Jejusja pumu nẽ hwỳr tẽ nẽ kãm: “Pa mẽ ijahkre xwỳnh.” Anẽ hãmri nẽ kahti hkôt kumỳ. ");
INSERT INTO apnNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Hãmri nhũm hkôt mẽ mrar xwỳnhjaja omu nẽ Jejus wỳr mra nẽ unênh kurê kumrẽx. ");
INSERT INTO apnNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Hãmri nhũm Jejus kôt mẽ pa ho mẽ pa xwỳnhjaja tee ri ja hã mẽ omu nhũm hõja õ wapo kapa nẽ patre maati mã àpênh xwỳnh kot mẽ hkôt htẽm xwỳnhta mã wapo ho apê. Nẽ kot ho hkrã nhĩpônh mã tã kuhpaw nẽ upôk rũm hamak nhĩkjê krãhta. ");
INSERT INTO apnNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","49","Hãmri nhũm Jejus amnhĩ tã mẽ kot unênh xwỳnhjê mã kãm: —Kwa na pa pre apkati mẽ Tĩrtũm mã amnhĩ jarẽnh xà hã ixkre kamã mẽ kãm ixujarẽnh o ixpa ka prem tokyx ixpynênh kêt nẽ. Tã jarãhã te ixte amnhĩ tomnuj xwỳnh pyrà nẽ ixwỳr wapohti nẽ kô hã akapẽn nẽ ixwỳr atẽm rax nẽ. Nom ra mẽ ate tanhmã ixto kaxyw arĩgro kator jakamã mẽ mãmrĩ tanhmã amã ixto hprãm xà hkôt tanhmã ixto. Tĩrtũm kapẽr ã kagà htũm kot mẽ akukamã ã mẽ ate inhĩpêx anhỹr ã mẽ ajarẽnh xà hkôt. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Hãmri nhũm hkôt mẽ pa ho mẽ pa xwỳnhjaja tee ri mẽ kot unênh ã mẽ omu hãmri nẽ mẽ umaj Jejus kaga nẽ ma hprõt pa nhũm ahte mẽ kuri xa. ");
INSERT INTO apnNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","52","Hãmri nhũm mẽ ma o tẽ. Nhũm kormã mẽhõ nyw xwỳnhja tee ri ja hã mẽ omu nẽ ma Jejus kôt tẽ. Nhũm mẽ amnhĩ kôt omu nẽ kot unênh kaxyw kahty xà hã kupy nhũm mẽ umaj mẽ ĩhkra kamã kahty xàja re nẽ ma hkênh nẽ hprõt nẽ tẽn akunok. ");
INSERT INTO apnNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Tã nhũm mẽ ma mẽ õ patre maati nhõrkwỹ hwỳr Jejus o tẽ. Hãmri nhũm patre krãhtũmjê mẽ Ijaew krãhtũmjê mẽ Tĩrtũm kapẽr tũm o mẽ ahkre xwỳnhjaja õrkwỹ hwỳr Jejus ã akuprõ. ");
INSERT INTO apnNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Hãmri nhũm Simãw Pêtre mẽ hkôt tẽ nẽ mẽ hkôt patre maati nhõ kĩtare hwỳr axà nẽ amỳm hã mẽ omunh o xa. Nhũm ra pôristijaja kĩtare kamã amnhĩm kuto nẽ hã ànhunh o hkrĩ nhũm mẽ hwỳr tẽ nẽ mẽ ĩhkô hã ànhunh o nhỹ. ");
INSERT INTO apnNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","56","Rôm nhũm ixkre kamã mẽ pikuprõnh xwỳnhjaja tee ri Jejus ã krĩ nhõ xwỳnhjê kukja nẽ mẽ kãm: —E mẽ atõ na ka pre Jejus kot tanhmã amnhĩ tomnuj to hã omu? Mẽ atõ mẽ inhmã harẽ pa mẽ ama nẽ Rõm nhõ xwỳnhjê nhĩhkram haxà kê mẽ pamã kupĩ. Anẽ. Hãmri nhũm mẽ axpẽn pãnhã tanhmã harẽnh to. Tanhmã kot amnhĩ tomnuj to hã harẽnh to htã nom ri ho hêx jakamã axpẽn kwỳm ri tanhmã ri harẽnh to nhũm mẽ tee ri mẽ kuma nẽ mẽ kãm: —Tk. Kwa mẽ axpẽn kwỳm ri tanhmã harẽnh to hkêt nẽ. Axpẽn kôt mãn ri tanhmã mẽ inhmã harẽnh to. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Hãmri nhũm mẽ hkwỳjaja kànhmã kuhê nẽ axpẽn kôt tanhmã ho hêx to nẽ mẽ kãm: ");
INSERT INTO apnNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","—Nà kot paj mẽ amã tanhmã kot amnhĩ nhĩpêx to hã harẽ. Na pa prem ã kapẽr anhỹr ã kuma. Na pre tanhmã Tĩrtũm mã amnhĩ jarẽnh xà hã ixkreta jarẽnh to nẽ harẽnh o: “Kot paj ixkreja grành pa hãmri nẽ ixtã apkati axkrunẽpxi nẽ akupỹm hipêx. Nom kot paj amnhĩ nhĩhkra ho hipêx kêt nẽ.” Anhỹr ã ã amnhĩ jarẽnh anẽ pa mẽ kuma. ");
INSERT INTO apnNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Anhỹr o harẽnh tã nom axpẽn kôt harẽnh kêt nẽ. Arĩ axpẽn kwỳm ri harẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Hãmri nhũm mẽõ patre maati tee ri mẽ kot tanhmã ho kapẽr toja ma nẽ mẽ aptàr tũmjê noo mã kànhmã xa nẽ Jejus mã kãm: —E na ka ra mẽ kot ã ajarẽnh anhỹrja ma. Xà kot kaj tanhmã mẽ inhmã amnhĩ tã axàprãr to hkêt nẽ? Xà ãm hãmri na mẽ ajarẽ? E kwa mẽ inhmã tanhmã amnhĩ jarẽnh to. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","No nhũm akryk xa nẽ tanhmã kãm nẽ hkêt nẽ. Hãmri nhũm tee ri ã kot amnhĩ nhĩpêx anhỹr ã omu nẽ axte kãm: —Kwa mẽ inhmã amnhĩ jarẽ. Xà apê Tĩrtũm Kra na ka? Xà ka na apê Tĩrtũm kot mẽ ixwỳr amẽnh xwỳnh na ka? Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Hãmri nhũm tã kãm amnhĩ jarẽ nẽ kãm: —Tỳ. Ixpê tãmta na pa. Ra mẽ ate jarãhã tanhmã ijarẽnh to kaxyw apikuprõnh tã nom kot paj nhỹrmã mẽ kamjaja tanhmã mẽ ajarẽnh to ka mẽ amnhĩ tã ixpumu. Kot kaj mẽ Tĩrtũm kot mẽ ato amnhĩptàr xà kutã akrĩ hãmri pa hwỳr tẽ nẽ ĩhkô hã nhỹ. Kakrã kamã kot paj hwỳr tẽ nẽ ĩhkô hã nhỹ hãmri nẽ ỹ hã tanhmã mẽ ajarẽnh to ka mẽ amnhĩ tã ixpumu. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","64","Hãmri nhũm tee ri ã kot amnhĩ jarẽnh anhỹrja ã kuma nẽ gryk xàj amnhĩ xê kaxô nẽ mẽ àptàr tũmjê mã kãm: —Kwa mo kaxyw kot puj mẽ axte ri ho tanhmã kot amnhĩ tomnuj to hã harẽnh xwỳnhjê hõ japêr? Ra tãm kot amnhĩ pê Tĩrtũm Kra hã amnhĩ to hêx nhũm mẽ pahte pajamak o mar kênã. E tanhmã kot puj mẽ ho? Anẽ. Hãmri nhũm mẽ kãm: —Nà kot puj mẽ kupĩ. Ra htyk mã tãm kênã. E kwa tokyx pu mẽ ma Rõm nhõ pahihti hwỳr o tẽ kê mẽ pamã hã amỹnê kê mẽ kupĩ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Hãmri nhũm mẽ hipêx kati rax nẽ. Nẽ hkuk kuhtô nẽ hpãnhã no hpro nẽ htak nẽ kãm: —E mẽ kot atak xwỳnhjê nhĩxi jarẽ. Apê Tĩrtũm Kra hã ate amnhĩ jarẽnh jakamã mãn uràk nẽ axàhpumunh tỳx. Jakamã e mẽ hixi jarẽ. Anẽ. Nhũm prem ã hipêx anẽ hãmri nẽ pôristijê nhĩhkram haxà nhũm mẽ htak rax o kuhê. ");
INSERT INTO apnNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","67","Rôm nhũm Simãw Pêtre arĩ kĩtare kamã mẽ ĩhkô hã ànhunh o nhỹ. Hãmri nhũm mẽõ patre maati mã àpênh xwỳnh nitita mẽ hwỳr kato nẽ xa. Hãmri nẽ hirã kamã hprĩ hã Simãw Pêtre pumu nẽ omunh mex kurê kumrẽx nẽ kãm: —Xê pẽr apê Najare nhõ xwỳnh Jejus kôt mẽ pa ho mẽ pa xwỳnhjê hõ na ka. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Hãmri nhũm tee ri kuma nẽ ra kãm ma nẽ. Nẽ kãm amnhĩ tã aprã nẽ kãm: —Tk. Kokỹ. Ixte mẽhõ my ata pumunhre hã. Anẽ. Hãmri nẽ kànhmã xa nẽ ma tẽ nẽ kĩtare hwỳr kahê hkôt ã mẽ hkàx ã ahte xa nhũm krãhyre kà. ");
INSERT INTO apnNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Nẽ gaa nhũm hpãnhã mẽ kãm àpênh xwỳnhjê hõja omu nẽ hã mẽ kãm: —Xê ma ãm hãmri na harẽ. Kôt ri mẽ pa xwỳnhjê hõ na pẽr. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Hãmri nhũm amnhĩ tã kuma nẽ kãm: —Tk. Kwa nà. Mẽ ri ã amnhĩ krã hkôt ri ixto axêx anhỹr kêt nẽ. Aa ixte mẽhõ ata pumunh kêt kumrẽx. Anẽ. Hãmri nhũm mẽ hkwỳja gaa nẽ kê axte hprĩ hã omu nẽ kãm: —Kwa ãm hãmri na mẽ ajarẽ. Apê Jejus hkwỳ na ka. Ajaxwỳja apê Garirej nhõ xwỳnh kênã. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Hãmri nhũm tee ri mẽ kuma nẽ kãm ma htỳx nẽ. Hãmri nẽ mẽ kãm: —Kwa nà. Na pa Tĩrtũm noo mã mẽ amã amnhĩ jarẽ. Kot paj amnhĩ to ixêx japêr nhũm inhma nẽ hã tanhmã ixto. Nà uràn ixpê Garirej nhõ xwỳnhre hã. Ixte mẽhõ mũj pumunh kêt kumrẽx tã ka mẽ xatã axpẽn kôt ixte hkôt ixpa ho ixpa xwỳnh ã ixkamnhĩx o xa. Anhỹr o ra mẽ kãm amnhĩ tã aprãr o axkrunẽpxi. ");
INSERT INTO apnNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Hãmri nhũm axte krãhyre kà. Jao ra hkàr o axkrut. Hãmri nhũm Simãw Pêtre kuma nẽ Jejus kot ra hkukamã ã amnhĩ nhĩpêx anhỹr ã harẽnhja mã hamaxpẽr kurê kumrẽx. Krãhyre kormã hkàr o axkrut kêt ri kot mẽ kãm amnhĩ tã àprãr o axkrunẽpxi hã harẽnhja mã hamaxpẽr. Hãmri nẽ ra kànhmã hakry hpar o tẽ nẽ hkaprĩ htỳx kumrẽx. Hãmri nẽ tee ri amnhĩ kukamã hamaxpẽr nẽ amnhĩ mã: —Hêxta waa nẽ. Ãm hãmri na pre Jejus ijarẽ. Tã pa kot ijarẽnh xà hkôt ã amnhĩ nhĩpêx anẽ. Kwa mo na pa axtem nẽ ã mẽ kãm amnhĩ to ixêx anẽ? Anẽ hãmri nẽ hkaprĩ xàj mỳr rax nẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Tã nhũm myt kato nhũm mẽ axte Jejus ã axpẽn wỳr akuprõ. Patre krãhtũmjê mẽ Ijaew krãhtũmjê mẽ Tĩrtũm kapẽr tũm o mẽ ahkre xwỳnhjê mẽ Ijaew nhõ juistijaja nhũm mẽ piitã hã akuprõ. Hãmri nẽ pôristi mã anẽ nhũm mẽ Jejus pa hpre nhũm mẽ ma Rõm nhõ xwỳnhjê nhõ pahi Pirat wỳr o tẽ. Piratja na pre hte Rõm nhõ xwỳnhjê nhõ pahi Sesti nhỹ hã Ijaew o amnhĩptàr o pa nhũm prem ma hwỳr o tẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Hãmri nẽ kutã ãm nẽ tanhmã kãm harẽnh to nẽ kãm: —E ot pa mẽ awỳr jahti ho tẽ. Na hte mẽ inhmã hêx rũnh o pa. Mẽ ixte Pahihti Sesti kapẽr kwỳm ri amnhĩ nhĩpêx prãm xàj tanhmã mẽ inhmã hêx to. Nẽ axtem nẽ mẽ ixte Sesti mã kàxpore hkwỳ nhõr kêt ã mẽ inhmã karõ. Nẽ Tĩrtũm kot mẽ ixkaxyw kêp mẽ inhõ pahi hã ãm ã amnhĩ jarẽnh o pa. Na hte ã mẽ inhmã amnhĩ to hêx anhỹr o pa. Anẽ. Hãmri nhũm Pirat mẽ kuma nẽ Jejus pumu nẽ tanhmã hkukjêr to nẽ kãm: —E inhmã amnhĩ jarẽ. Xà ãm hãmri na mẽ ã ajarẽnh anẽ nà? Xà apê Ijaew nhõ pahi na ka? Xà ka na htem amnhĩ wỳr akãm hamak o pa? Anẽ. Hãmri nhũm kãm: —Tỳ. Nà ãm hãmri na ka ã ijarẽnh anẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Hãmri nhũm patre krãhtũmjaja tanhmã kãm ho kapẽr to. ");
INSERT INTO apnNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Nhũm mẽ kuma nẽ axte hkukja nẽ kãm: —Kwa na mẽ ã ajarẽnh anẽ ka mẽ ama nẽ ãm mẽ ama nẽ inhmã tanhmã amnhĩ tã axàprãr to hkêt nẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Nom nhũm Jejus ãm akryk xa nẽ tanhmã axte kãm nẽ hkêt nẽ. Jakamã nhũm Pirat tee ri omunh pê hamaxpẽr o nhỹ. ");
INSERT INTO apnNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Na pre hte pahi Pirat arĩgro pê Pasja ã Ijaewjaja kãm hprãm xà hkôt mẽ hagjênh xwỳnhjê ho hpỹnh nẽ mẽ kãm ure. ");
INSERT INTO apnNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","10","Jakamã nhũm Ijaew kwỳjaja hwỳr mra nẽ kãm: —Pa. Kwa xà kot kaj jarãhã mẽ inhmã mẽ hagjênh xwỳnhjê hõ mã anhũre nà? Anẽ. Hãmri nhũm mẽ kuma nẽ hamaxpẽr o: —E paj Jejus ã mẽ kuma nẽ kãm inhũre. Mẽ piitã mẽ kãm kapẽr mar prãm nhũm mẽõ patre krãhtũmjaja pix kot mẽ hkôt kamã gryk nẽ ã ixwỳr o mrar anhỹr kênã. Anẽ. Hãmri nẽ mẽ kãm: —Tỳ. Nà kot paj mẽ amã hõm inhũre. Kwa xà kot pa mẽ amã mẽ anhõ “pahihti” jarẽnhja mã inhũre nà? Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Hãmri nhũm patre krãhtũmjaja tee ri kuma nẽ mẽ kãm: —Kwa mẽ kãm anẽ kê Parapas mã mãn ure. Anẽ. Hãmri nhũm mẽ kuma nẽ Pirat mã kãm: —Nà Jejus mã anhũrer kêt nẽ. Parapas mã mãn anhũre. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Hãmri nhũm mẽ kãm: —No mẽ ate mẽ anhõ pahi hã harẽnh xwỳnhta? Tanhmã kot paj ho? Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Hãmri nhũm mẽ àmra kamã kãm hã amỹnê nẽ kãm: —Kwa pĩ kahpa hã anhô kê ty. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Hãmri nhũm tee ri mẽ kuma nẽ mẽ kãm: —Tk. Kwa nà. Tanhmã kot amnhĩ tomnuj tore hã kot pa ã hipêx anẽ. Anhỹr tã nhũm mẽ xatã anhĩpê kãm kapẽr kãm hihtỳx nẽ kãm: —Kwa pĩ kahpa hã mãn anhô kê ty. Tokyx ã mẽ inhmã hipêx anẽ. Anhỹr o kuhê. Kàx pê kãm anhỹr o kuhê. ");
INSERT INTO apnNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Nhũm tee ri mẽ kuma hãmri nẽ mẽ kãm hprãm xà hkôt mẽ kãm Parapas mã ure. Nẽ pôristi hkwỳjê mã Jejus ã amỹnê nẽ mẽ kãm: —Tôe. Mẽ mamrĩ hwỳr tẽ nẽ htak hãmri nẽ kapôt ã mẽ hpar xà hã pika hwỳr o tẽ nẽ pĩ kahpa hã anhô. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Tã nhũm pôristijaja akupỹm ixkreja wỳr Jejus o axà nẽ amnhĩ wỳr hkwỳjê hã karõ nhũm mẽ hwỳr agjê nẽ Jejus ã akuprõ. ");
INSERT INTO apnNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Hãmri nẽ kêp pahi hã hpẽr o pikẽnh kaxyw kãm pahi hã mẽ ahkà nhĩpêx nẽ hkrãm haxà. Nom axtem nẽ akunĩ kamã mẽmo mrô nhĩ te kot ronh kanêre pyràk xwỳnhja nhũm mẽ kãm hikãx nẽ hkrãm haxà. Hãmri nẽ kêp ê kapa nẽ pahi hã mẽ ê kamrêk õ py nẽ kãm haxà. ");
INSERT INTO apnNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Hãmri nẽ kãm: —E apê Ijaewjê nhõ pahi na ka. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Hãmri nẽ xatã axpẽn pãnhã hwỳr mra nẽ pĩ ho hkrãx pê htak nẽ hkuk kuhtô nẽ hã hpẽr o pikẽnh pê hã hpijaàm pyrà nẽ kutã hkõn krã ho hkrĩ. ");
INSERT INTO apnNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Hãmri nẽ kêp pahi xê kapa nẽ akupỹm kãm ê jaxà nẽ pĩ kahpa hã nhôr kaxyw ma o kato nẽ o tẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Nom nhũm ra hirot tỳx nẽ nhũm mẽ tee ri omu hãmri nẽ mẽhõ kot ho ajuta kaxyw mẽ kot hkôt omunh o mõr xwỳnhjê kapi ho xa. Hãmri nẽ Sirẽn nhõ xwỳnh Simãw hkà htykreja pumu. Aresãn mẽ Rupti wa hipêêxà na pre. Nhũm htỳx hamakêtkati nẽ mẽ kutã krĩm tẽ. Hãmri nhũm mẽ haê nẽ unê nẽ kãm Jejus o ajuta kaxyw hã karõ nhũm kãm pĩ kahpaja mỳ nẽ mẽ hkôt o tẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Nhũm mẽ ra kẽn nhĩxêt te kot mẽ hkrã hi pyràk xwỳnhja wỳr Jejus o pôj. Mẽ kot kãm “Korkot” anhỹr xwỳnhja wỳr. Mẽ pakapẽr kãm na htem Korkotja jarẽnh o: “Mẽ hkrã hi xà” anẽ. Jakamã nhũm mẽ ra hwỳr o pôj. ");
INSERT INTO apnNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Hãmri nẽ kot pĩ kahpa hã nhôr kaxyw wĩhti hkwỳ ho mẽ mẽmo mẽhkanexà pê mĩra ho ahkà. Kot ho kõm nẽ amnhĩ xà htỳx kãm hamak kêt kaxyw hipêx nẽ kãm kugõ nom nhũm hkaga nẽ ho hkõm kêt nẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","26","Hãmri nhũm myt kaxkwa nhĩpôk wỳr tẽ nhũm mẽ pĩ kahpata ã Jejus xi nẽ prek o ĩhkra ho htỳx nẽ hpar o htỳx. Nẽ hpãnhã kaxyw kakwỳ nẽ kànhmã pĩ kahpa jarĩ nẽ kre kamã ãm nẽ hity hpa. Nhũm Jejus kỳx pê amnhĩ xà htỳx kumrẽx kamã hamak o ajêt. Nhũm pôristi hõja tẽ nẽ tapti hõ py nẽ hã kagà ho: IJAEWJÊ NHÕ PAHI NA JA Hãmri nẽ Jejus wỳr ho api nẽ mỳ ri kunhô. Hãmri nhũm hparpê pôristi hkwỳja axpẽn mã ê hkwỳ ho hpigrành kaxyw hã kẽnre ho jôka ho hkrĩ. ");
INSERT INTO apnNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","28","Tã nhũm mẽ wa kot amnhĩ tomnuj xwỳnh wa ho axkrut nẽ mã wa ho anẽ nẽ. Nẽ pĩ kahpa hã prek o wa ĩhkra ho htỳx nẽ wa hpar o htỳx hãmri nẽ akutã ho Jejus nhĩjê nhũm wa ajêt. ");
INSERT INTO apnNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Hãmri nhũm mẽ kot omunh mã mrar xwỳnhjaja Jejus pumu nẽ hã hpẽr o pikẽnh punuj nẽ hkrã ho apê nẽ kãm: —Kwa na ka pre ate Tĩrtũm mã amnhĩ jarẽnh xà hã ixkre grành par nẽ atã apkati axkrunẽpxi nẽ akupỹm hipêx par ã amnhĩ jarẽnh o apa. Nẽ axàhpumunh o axàhpumunh ã amnhĩ jarẽnh o apa. ");
INSERT INTO apnNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Jakamã e kwa amnhĩ kapa nẽ wrỳ pa mẽ ja hã apumu. E kwa tokyx. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Nẽ patre krãhtũmjê mẽ Tĩrtũm kapẽr tũm o mẽ ahkre xwỳnhjaja piitã hwỳr mra nẽ hã hpẽr o pikẽnh o kuhê. Nẽ axpẽn mã kapẽr o: —E jahti na xep pre mẽ kamã ukaprĩ ho pa nẽ tanhmã mẽ ho ajuta hto ho pa. Tã tãm tanhmã amnhĩ to nẽ wrỳk kêt nẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Kwa pu mẽ arĩ pakuhê nẽ kot amnhĩ kaxàr nẽ wrỳk kãm omu. Koja wrỳ pu mẽ omu nẽ kêp mẽ panhõ pahihti hã hkôt pajamaxpẽr kurê kumrẽx. E tokyx wrỳ Jejus pa mẽ awrỳk kãm apumu. Nà kot kaj awrỳk rax nẽ. Anẽ. Hãmri nhũm akutã wa kot hijê nẽ jêt xwỳnh wa haxwỳja kãm kapẽr punuj o ajêt. ");
INSERT INTO apnNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Tã nhũm ra kaxkwa nhĩpôk ri myt nhỹr mẽ nhũm te kamàt pyràk. Nhũm kamàt kô rax kumrẽx o ra hã awry mẽ nhũm akupỹm myt katêr o mõ. ");
INSERT INTO apnNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Hãmri nhũm Jejus àmra kamã Tĩrtũm mã kapẽr nẽ kãm: —Inhõ Tĩrtũm inhõ Tĩrtũm. Kwa mon ka ixkaga? Anẽ. Nom kapẽr kãm kapẽr o: —Eri Eri rãmã sapatanĩ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Hãmri nhũm mẽ kot mar o kuhê xwỳnhjaja kot Eri hã harẽnh ma nẽ htỳx ho finat Eris mã kapẽr ã hkamnhĩx. ");
INSERT INTO apnNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Hãmri nhũm ja hprõt nẽ mẽmo rereeti py nẽ pĩ ho hkanhwỳ nẽ o tẽ nẽ ho wĩhti nhek nẽ Jejus wỳr o tẽ nẽ kot hkaôr kaxyw kãm kupẽ. Hãmri nẽ hkwỳjê mã kãm: —E hãmri pu mẽ jar hkàx ã pakuhê nẽ Eris jamã mãn. Koja kuma nẽ hwỳr tẽ nẽ o wrỳ nà? Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Nom nhũm Jejus ra htyk kaxyw nẽ àmra htỳx nẽ ty. ");
INSERT INTO apnNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Hãmri nhũm Tĩrtũm mã amnhĩ jarẽnh xà hã ixkre kamã hakwakre hã kupẽxêja axkjê nẽ amnhĩ kahê xà mẽnh kurê kumrẽx. Utĩ rax tã kỳj rũm ahpar mã axkjê nẽ amnhĩ kahê xà mẽ. Te Jejus htyk o mẽ pahte hkôt amnhĩ xunhwỳr xwỳnhjê mã Tĩrtũm wỳr pry jakwa kre kahê xà mẽnh pyràk o ã amnhĩ kaxônh anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Nhũm pôristi krãhtũmjê hõja Jejus parpê kutã htyk kãm omunh o xa. Hãmri nẽ tee ri omu nẽ hamaxpẽr o: —Hêxta waa nẽ. Ãm hãmri na pre hte kêp Tĩrtũm Kra hã amnhĩ jarẽnh o pa. Tã pa mẽ amarĩ kupĩ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","41","Rôm nhũm mẽni kwỳjaja amỳm htyk kãm omunh o kuhê. Na pre htem Garirej kamã Jejus mẽ hkôt mẽ pa ho mẽ pa xwỳnhjê mã mẽ apkur xà hã àpênh o mẽ hkôt pa nẽ mẽ hkôt Jerujarẽ hwỳr mõ. Marir Matarẽn nẽ Xiakre mẽ Jojes wa katorxà Marirja. Nẽ Sarome. Nẽ mããnẽn mẽni hkwỳjaja nhũm mẽ amỳm Jejus htyk kãm omunh o kuhê. ");
INSERT INTO apnNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Nhũm prem arĩgro pê sêsta hã Jejus pĩ nhũm ra amỹkry htỳx nẽ. Sap kukamã na pre htem Ijaewjaja amnhĩm apkur xà hã mẽõ nhĩpêx pa nhũm sap kato nhũm mẽmoj to anhỹr kêt nẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Jakamã nhũm Juje hõ pê Arimatej nhõ xwỳnhja. Kêp Ijaewjê nhõ juisti hõ na pre. Nhũm mẽ piitã kãm hkĩnh nẽ axpẽn mã mex o mex ã harẽnh o pa. Na pre Tĩrtũm kot mẽ pahwỳr Jejus mẽnh kôt hamaxpẽr o pa. Tã Jejus htyk ã omu hãmri nẽ hamaxpẽr o: —E pa ma pahi Pirat wỳr tẽ nẽ Jejus nhĩ hã kuwỳ. Inhmã uma htã kot paj ma hwỳr tẽ nẽ hã kuwỳ kê inhmã kugõ pa ma o tẽ nẽ tokyx haxà. Kot paj ho anhỹr tokyx anhỹr kêt nhũm mẽ panhõ arĩgromnu pê sapja wỳr ra myt axà hãmri pa haxàr kêt nẽ. Anhỹr o hamaxpẽr nẽ ma Pirat wỳr tẽ nẽ hã kuwỳ. ");
INSERT INTO apnNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Hãmri nhũm amnhĩ jaêr pê ra htyk ã harẽnh ma nẽ amnhĩ wỳr pôristi krãhtũmjê hõ hã karõ nẽ hã hkukja nẽ kãm: —Kwa xà na ra Jejus ty? Anẽ. Hãmri nhũm kãm: —Tỳ na ra ty. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Hãmri nhũm kuma nẽ Juje mã kãm: —Tôe. Mamrĩ ma o tẽ nẽ haxà. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Hãmri nhũm kuma nẽ akupỹm Jejus wỳr tẽ nẽ pôristi mã anẽ nhũm mẽ kãm ho wrỳ. Nhũm kumỳ nẽ kupẽxê ho hkupu hpa nẽ o tẽ nẽ kẽn kre kakwỳnh kãm haxà. Hãmri nẽ kẽn rax o hitom mex nẽ ma akupỹm krĩm tẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Nhũm Marir Matarẽn mẽ Juje katorxà Marir õja wa ma hkôt tẽ nẽ kot haxàr kãm omunh o xa. Kot mẽ hkuxwa xà ho gregrer kêt rãhã haxàr kãm omu. ");
INSERT INTO apnNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","2","Tã nhũm apkati. Nom nhũm ra mẽ inhõ arĩgromnu pê sap kator jakamã nhũm mẽ kormã akupỹm kẽnkreta wỳr mrar kêt nẽ. Hãmri arĩgro mex jamãr pê kôkôt o hkrĩ. Hãmri nhũm axte apkati nhũm tômĩk nhũm ra mẽ inhõ arĩgromnu hapêx nhũm Marir Matarẽn mẽ Sarome mẽ Xiakre katorxà Marirja mẽ ma akupỹm kẽnkreta wỳr mra. Kormã kwỳhtãã. Kormã myt kator o mõr mẽ nhũm mẽ kànhmã hkrĩ hãmri nẽ mẽ kot Jejus gregrer kaxyw mẽ hkuxwa xà hkwỳ jamỳ nẽ ma hwỳr o mra. ");
INSERT INTO apnNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Hãmri nẽ kormã mõr ri tee ri amnhĩ kukamã hamaxpẽr nẽ axpẽn mã: —Xê gàà nẽ. Mẽhõ koja mẽ pamã nhãm kẽnkre nê hitom raxta xãm pu mẽ Jejus wỳr agjê nẽ gregrer? Utĩ rax kumrẽx kênã. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Hãmri nẽ hwỳr pôj nẽ omu nhũm ra hitom xàja kàx ã nõ nhũm mẽ tee ri omu. Utĩ rax tã ra kàx ã nõ. ");
INSERT INTO apnNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Hãmri nhũm mẽ kẽnkre hwỳr agjê nẽ upôk rũm mẽhõ nyw pumu. Nhũm ê jakajre kamã nhỹ nhũm mẽ amnhĩ jaêr pê omu nẽ tee ri hamaxpẽr. ");
INSERT INTO apnNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Hãmri nhũm mẽ kãm: —Kwa mẽ amã ma hkêt nẽ. Mẽ ate Najare nhõ xwỳnh pê Jejus pumunh kaxyw na ka mẽ mra. Mẽ kot pĩ kahpa hã nhôr xwỳnhta. Nom jar amrakati. Na ra Tĩrtũm akupỹm ho htĩr. E mẽ kam nẽ amnẽ agjê nẽ ano ho nõr xà kaprỳ pumu ");
INSERT INTO apnNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","nẽ tokyx ma akupỹm mra nẽ hkôt mẽ pa ho pa xwỳnhjê mã harẽ. Koja ma Jejus mẽ akukamã akupỹm Garirej wỳr mõ. Garirej kamã kot kaj mẽ axte axpẽn pumu. Ra kot mẽ amã amnhĩ jarẽnh xà hkôt. Kwa mẽ tokyx ma akupỹm mẽ hwỳr mra. Nẽ kwa kê Simãw Pêtreja harẽnh mar mex nẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Hãmri nhũm mẽ kuma nẽ awjanã nẽ ma akupỹm hprõt. Nẽ tee ri hamaxpẽr nẽ kãm ma xàj htertet tỳx jakamã kormã nhãm mẽhõ mã harẽnh kêt nẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Nhũm semãn nyw mã àr xà hã arĩgro pê tômĩkja ã nhũm Jejus akupỹm htĩr. Hãmri nẽ Marir Matarẽn kumrẽx wỳr kato. Kot nê mẽkarõmnuti ho 7 nẽ nê hanor xwỳnhta kumrẽx wỳr kato. ");
INSERT INTO apnNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Hãmri nhũm akupỹm htĩr kãm omu nẽ hkĩnh tỳx kumrẽx. Nẽ ma akupỹm tẽ nẽ Jejus kràmnhwỳjê mã harẽ. Nhũm mẽ hkaprĩ nẽ mỳr o hkrĩ nhũm mẽ hwỳr axà nẽ mẽ omu nẽ mẽ kãm: ");
INSERT INTO apnNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","—Xê mẽ amỳr kêt nẽ. Na ra Jejus akupỹm htĩr nẽ ham ixwỳr kato pa inhno ho omu. Xê mẽ hãmri axte amỳr kêt nẽ. Anhỹr tã nom nhũm mẽ htỳx ho amnhĩ krã hkôt kot ri ã harẽnh anhỹr ã hkamnhĩx jakamã kuma nẽ ãm kuma. ");
INSERT INTO apnNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Tã nhũm Jejus axte ja wa hwỳr kato. Kôt mẽ pa ho pa xwỳnh wa ho axkrut nẽ wa hwỳr kato. Na pre wa Jerujarẽ rũm kato nẽ akupỹm wa õ krĩ hwỳr mõr mẽ nhũm wa hwỳr kato. Nom axtem tanhmã amnhĩ nhĩpêx to nẽ wa hwỳr kator jakamã nhũm wa tokyx hprĩ hã kêp Jejus ã omunh kêt nẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Tã kêp Jejus ã omu hãmri nẽ akupỹm Jerujarẽ hwỳr mõ nẽ hkwỳjê mã harẽnh kurê kumrẽx. Nom nhũm mẽ wa kuma nẽ ãm wa kuma nẽ akupỹm htĩr kôt hamaxpẽr kêt nẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Tã nhũm Jejus tã hkôt mẽ pa ho mẽ pa xwỳnh pê 11 wỳr kato nhũm mẽ kamã no pyma nẽ hkĩnh tỳx nẽ omunh o kuhê. Hãmri nhũm mẽ kãm: —Kwa hêxta waa nẽ. Marir Matarẽn mẽ akwỳta mẽ kot akupỹm ixtĩr kãm ixpumunh nẽ mẽ amã ijarẽnh tã ka mẽ ama nẽ ãm mẽ ama. Pẽr ãm mẽ akrã hihtỳx jakamã na ka mẽ ama nẽ mẽ hkôt ajamaxpẽr kêt nẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Hãmri nẽ mẽ kot tanhmã kãm amnhĩ nhĩpêx to ho pa hã mẽ kãm karõ nẽ mẽ kãm: —E kêr ka mẽ ma krĩ piitã hkôt mẽ kãm ijarẽnh o ri mẽ hkôt apa. Ixte tanhmã mẽ nê amnhĩ nhĩpêx toja ka mẽ aprĩ hã mẽ kãm ijarẽnh o ri mẽ hkôt apa. ");
INSERT INTO apnNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Nẽ mẽ kot mẽ akapẽr mar nẽ amnhĩ kaxyw ixkôt hamaxpẽr xwỳnhjaja kêr ka mẽ hkrã kumrã nhũm mẽ nhỹrmã Tĩrtũm mẽ wa ixri htĩr tũm nẽ mex rãhã nẽ pa ho pa. No mẽ kot amnhĩ kaxyw ixkôt hamaxpẽr kêt xwỳnhjaja koja Tĩrtũm nhỹrmã amnhĩ nê mẽ hano nhũm mẽ ma kuwy hwỳr pa. ");
INSERT INTO apnNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","—Nẽ amnhĩ kaxyw ixkôt mẽ ajamaxpẽr xwỳnhjaja kot kaj mẽ inhỹ hã tanhmã amnhĩ nhĩpêx to ho ri apa. Aa mẽ kot mẽmoj pumunh kêt kwỳ ho anẽ nẽ inhỹ hã inhĩxi jarẽnh kôt mẽ nê mẽkarõmnuti janor o ri mẽ hkôt apa. Nẽ mẽ ate nhãm mẽ kapẽr mar kêt tã inhỹ hã ho akapẽr mex o apa. Mẽ ate mar kêt tã ra ho akapẽr nhũm mẽ kot mẽ kapẽrta mar xwỳnhjaja hprĩ hã mẽ amar mex nẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Nẽ kot kaj mẽ nhỹri atỳx kagã xoprê hõ hpyr tã no nhũm tanhmã mẽ ato hkêt nẽ. Rỳ atỳx mẽmoj to mẽ hpar xà hkwỳ ho akõm tã no nhũm tanhmã mẽ ato hkêt nẽ. Nẽ inhỹ hã mẽ à xwỳnhjê hã mẽ anhĩhkra jaxwỳ nhũm mẽ akupỹm mex. Kot kaj mẽ amnhĩ kaxyw ixkôt mẽ ajamaxpẽr xwỳnhjaja ã inhỹ hã amnhĩ nhĩpêx anhỹr o ri apa. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Tã nhũm mẽ panhõ Pahihti Jejusja hkôt mẽ pa ho mẽ pa xwỳnhjê mã kapẽr pa hãmri nhũm Tĩrtũm ma akupỹm amnhĩ wỳr kaxkwa hwỳr ho api. Hãmri nhũm kaxkwa kamã Tĩrtũm nhĩhkô hã upôk rũm nhỹ. Kot ĩhkô hã mẽmoj piitã ho amnhĩptàr kaxyw hkrĩ ho hkrĩ. ");
INSERT INTO apnNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Hãmri nhũm hkôt mẽ pa ho pa xwỳnhjaja ma akupỹm àpir kãm omu hãmri nẽ anhgrà nẽ ma krĩ piitã hkôt mẽ kãm Tĩrtũm kapẽr jarẽnh o pa nhũm Pahihti Jejus mẽ ĩhkô hã pa ho pa. Nhũm mẽ ma ỹ hã hkwỳjê mã aa mẽ kot mẽmoj pumunh kêt kwỳ ho anhỹr o ri mẽ hkôt pa nhũm mẽ ja hã mẽ omu nẽ axpẽn mã mẽ harẽnh o: —Nà ãm hãmri na mẽ pamã Tĩrtũm kapẽr jarẽnh o pa nẽ ho hêx kêt nẽ. ỹ hã mẽ kot aa mẽ pahte mẽmoj pumunh kêt kwỳ ho anhỹr o pa kênã. Nà ãm hãmri na ã mẽ pamã kapẽr jarẽnh anhỹr o pa. Anẽ. Ja kôt na Makre kot Jejus jarẽnhja hapêx.");
INSERT INTO apnNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Pa pahi Teopre. Xà amex? E ot pa awỳr kagà nhĩpêx nẽ awỳr kumẽ. Ixte amã Jejus jarẽnh kaxyw. Na prem ra ohtô nẽ jar mẽ pahkôt Jejus kot amnhĩ nhĩpêx o pa hã kagà rax nẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Jejus nhỹ hã Tĩrtũm kapẽr jahkre ho mẽ pa xwỳnhjaja na prem Jejus kot tanhmã amnhĩ nhĩpêx to hkrax kãm kot amnhĩ nhĩpêx o pa hã omunh o hkôt pa. Hãmri nẽ hprĩ hã mẽ inhmã harẽ nẽ hã kagà nhũm mẽ ohtô nẽ mẽ mar xà hkôt mẽ urà nẽ kot tanhmã amnhĩ nhĩpêx to ho pa hã kagà. ");
INSERT INTO apnNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Tã pa mẽ harẽnh ma nẽ ijamaxpẽr o: —E kot paj ijaxwỳja Jejus kot amnhĩ nhĩpêx kwỳ hã kagà. Nà kot paj ho anẽ. Anhỹr o ijamaxpẽr jakamã ot pa ra ixte amã hã kagà kaxyw. ");
INSERT INTO apnNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Tã kêr ka kamã harẽ nẽ ixpyrà nẽ ama nẽ aprĩ hã harẽnh mar tỳx nẽ mẽ kot amã harẽnh xwỳnhjê hkôt ajamaxpẽr tỳx o apa. Ãm hãmri na prem mẽ amã harẽ. E kot paj amã hkwỳ hã kagà. Ixpê akràmnhwỳ Rukre kot paj ixprĩ hã amã harẽ nẽ hã kagà. ");
INSERT INTO apnNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Juãw Paxis nhĩpêêxà finat Jakarisja kumrẽx kot paj amã harẽ. Kêp finat Apiasti kanrẽhã htàmnhwỳ jakamã uràk nẽ kêp mẽ apê Ijaew nhõ patre na pre. Pahihti Eroxja kormã kot mẽ anhõ pika kamã mẽ ho amnhĩptàr ri nhũm Jakaris kêp patre nẽ pa. Nẽ hprõ Ijapew mẽ wa kêp Parãw kanrẽhã htàmnhwỳ. ");
INSERT INTO apnNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Nẽ wa hamẽ na pre Tĩrtũm kôt tãm amnhĩ nhĩpêx o wa pa. Ãm Tĩrtũm kapẽr kôt pix mã ri amnhĩ nhĩpêx rãhã ho wa pa. ");
INSERT INTO apnNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Nom Ijapewja tanhmã hkra xà kute jakamã nhũm wa hkra hkêt nẽ wa pa rãhã wa ra hpigêx tỳx nẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Jakamã nhũm Jakaris ma mẽ kot Tĩrtũm mã amnhĩ jarẽnh xà hã ixkre hwỳr tẽ. Kwỳjê pyrà nẽ kot Tĩrtũm mã tanhmã amnhĩ nhĩpêx to kaxyw ma mẽ hpãnhã hwỳr tẽ nẽ axà. ");
INSERT INTO apnNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","10","Hãmri nẽ kamã Tĩrtũm mã amnhĩ jarẽnh pê kãm mẽ hkuxwaxà ho xêt o xa. Nhũm Ijaew kwỳjaja ixkreta wỳr akuprõ nẽ kapem kutêp Tĩrtũm mã amnhĩ jarẽnh o kuhê. ");
INSERT INTO apnNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Pu nhũm kaxkwa rũm Tĩrtũm kapẽr o mẽ wrỳk xwỳnhja wrỳ nẽ Jakaris kutã xa. Mẽ hkuxwa xà ho xêt xà hã mês kunĩhti xupôk rũm xa. ");
INSERT INTO apnNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Hãmri nhũm amnhĩ jaêr pê amnhĩ kutã omu nẽ akryk omunh o xa. ");
INSERT INTO apnNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Hãmri nhũm kãm: —Pa Jakaris? Kwa tee ri ajamaxpẽr o amã ma hkêt nẽ. Na pre Tĩrtũm ate akra hã hwỳr o apa hã ama nẽ hã apumu. Jakamã koja tanhmã aprõ hkra xà ho ka kamã akra. Nhũm nõ nẽ rax nẽ kato nẽ myre. Ka wa hã hixi mẽ nhũm kêp Juãw. ");
INSERT INTO apnNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Koja kato ka wa omu nẽ akĩnh tỳx kumrẽx. Nhũm akwỳjaja haxwỳja ohtô nẽ war akra jarẽnh ma nẽ war anhỹ hã hkĩnh nẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Koja kormã akra kator kêt ri nhũm Tĩrtũm Karõja hkarõ hwỳr axà. Hãmri nhũm kato nẽ gaa nẽ hprêk nẽ Tĩrtũm mã tanhmã amnhĩ nhĩpêx to ho pa. Tĩrtũm kãm hprãm xà hkôt pix mã tanhmã amnhĩ nhĩpêx to ho pa. Nom kêr ka inhmar kumrẽx. Kê mẽmoj to wĩhti ho hkõm kêt nẽ pa. Nẽ kagôxỳhti ho hkõm kêt nẽ pa. Ãm kwarĩ ho kwarĩ. ");
INSERT INTO apnNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Koja hprêk hãmri nẽ mẽ apê Ijaew mã Tĩrtũm kapẽr jarẽnh o mẽ hkôt pa. Nhũm mẽ ohtô nẽ kuma nẽ kot amnhĩ tomnuj kaga nẽ Tĩrtũm kôt amnhĩ xunhwỳ nẽ hkôt amnhĩ nhĩpêx mex o pa. ");
INSERT INTO apnNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","—Tĩrtũm kot mẽ awỳr mẽ apytàr xwỳnh maati mẽnh mã xwỳnh kukamã koja mẽ kãm harẽnh o pa. Te Tĩrtũm nhỹ hã kapẽr jarẽnh xwỳnh finat Eris kot amnhĩ nhĩpêx pyràk o koja amnhĩ nhĩpêx. Nẽ uràk nẽ Tĩrtũm Karõ nhỹ hã mẽ amã Tĩrtũm kapẽr jarẽnh o mẽ akôt pa. Jakamã nhũm mẽ akwỳjaja kuma hãmri nẽ amnhĩ tomnuj kaga hpa nẽ Tĩrtũm kôt pix mã amnhĩ nhĩpêx o pa. Nẽ tãm mẽ hkrajê nhĩpêx o pa. Koja mẽ ã akra Juãwja kôt amnhĩ nhĩpêx anẽ. Jao Tĩrtũm kot mẽ awỳr mẽnh mã xwỳnhta kutêp tãm amnhĩ nhĩpêx o pa. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Nhũm pre ã Tĩrtũm kapẽr o wrỳk xwỳnh Jakaris mã hkrata jarẽnh anẽ. Hãmri nhũm tee ri kuma nẽ kãm: —Kwa xà we ãm hãmri na ka ã inhmã ixkra jarẽnh anẽ nà? Ra ixprõ mẽ wa ijamẽ wa ixpigêx tỳx kênã kot pa kêt wa ixkra. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Hãmri nhũm kãm: —Nà ãm hãmri na pa ã amã harẽnh anẽ. Ixpê Gapriew na pa ã awỳr ixwrỳk nẽ Tĩrtũm nhỹ hã amã harẽnh anẽ. Ixte Tĩrtũm nhĩhkô hã ixkuhê xwỳnhjê hõ na pa. Tãm na awỳr inhmẽ pa awỳr wrỳ nẽ ã amã akra jarẽnh anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Tã ate ixkôt ajamaxpẽr kêt jakamã kot kaj axte axumar kêt nẽ akapẽr kêt rãhã nhũm akra kato. Koja kato ka rĩ kormã akupỹm akapẽr nẽ akupỹm ama. Ate ixkôt ajamaxpẽr kêt jakamã kot kaj ã amnhĩ nhĩpêx anẽ nẽ rĩ amnhĩ pumu. Ãm hãmri na pa ã amã ixkapẽr anẽ. Anẽ. Nhũm pre ã Tĩrtũm kapẽr o wrỳk xwỳnhja Jakaris mã kapẽr anẽ. Jakamã nhũm tokyx ixkre rũm kator kêt nẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Hãmri nhũm ixkre kapem mẽ kuhê xwỳnhjaja tee ri kamã ama nẽ axpẽn mã: —Tk. Kwa mo na we ri hitom kãm ho anhỹr kãm unê nẽ tokyx kator kêt? Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Tã nhũm akupỹn mẽ hwỳr kato. Nẽ tee ri kot mẽ kãm kapẽr kaxyw no ãm ĩhkra pix o ri mẽ kãm tanhmã ujahkre hto. Hãmri nhũm mẽ amnhĩ jaêr pê kot ã amnhĩ nhĩpêx anhỹr ã omu nẽ tee ri hkukamã hamaxpẽr nẽ axpẽn mã: —Kwa tanhmã na we amnhĩ to? Mãn hitom kãm mẽmoj tanhmã kute hã omu hã na ri ã amnhĩ nhĩpêx anẽ nà? Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Hãmri nhũm Jakaris ixkre kamã mẽmoj tã àpênh pa hãmri nẽ ma akupỹm õrkwỹ hwỳr tẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","25","Tã nhũm hprõ Ijapewja htujarô. Hãmri nẽ amnhĩ tujarô hã amnhĩ pumu nẽ hkĩnh tỳx nẽ. Nẽ hamaxpẽr o: —Hêxta gàà nẽ. Ma ãm hãmri na pa pre ixkra hkêt nẽ amnhĩ kamã ixpijaàm o ri ixpa. Tã ra ixtujarô. Kot paj wa axte ri amnhĩ kamã ixpijaàm kêt nẽ. Ma ãm hãmri na Tĩrtũm ã wa inhĩpêx anẽ. Na pa wa ixkĩnh tỳx kumrẽx. Anẽ. Nhũm pre ã hamaxpẽr anẽ hãmri nẽ arĩ õrkwỹ kamã hkrĩ ho hkrĩ. Aa nhỹhỹm kator nẽ mõr kêt rãhã hã mytwrỳ kêp 5. ");
INSERT INTO apnNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Tã nhũm Ijapew ra htujarô hã mytwrỳ kêp 6 nhũm Tĩrtũm axte kapẽr o wrỳk xwỳnh pê Gapriewja mẽ. Nhỹri Garirej kamã krĩ pê Najare hwỳr kumẽ nhũm ma hwỳr wrỳ. ");
INSERT INTO apnNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Mẽhõ pê Marir wỳr wrỳ. Nhũm ra Juje ho mjên kaxyw. No ãm kormã hkukrit rãhã ho mjên kaxyw. Jujeja Marir pyrà nẽ kêp pahi finat Tawi kanrẽhã htàmnhwỳ na pre. ");
INSERT INTO apnNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Jakamã nhũm Gapriew Marir wỳr wrỳ nẽ kãm: —Pa Marir? E ot pa amã Tĩrtũm kapẽr jarẽnh kaxyw awỳr wrỳ. Kot akôt pa ho pa jakamã koja ato mex rax kumrẽx. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Hãmri nhũm amnhĩ tã kuma nẽ tee ri hamaxpẽr nẽ hamaxpẽr o: —Xê mẽmo na we ri ã inhmã kapẽr anẽ? Tanhmã koja we Tĩrtũmja ixto mex rax to? Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Hãmri nhũm Gapriew kãm: —Kwa tee ri amnhĩ kukamã ajamaxpẽr kêt nẽ. Tĩrtũm kãm ajapêê. ");
INSERT INTO apnNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Kot kaj atujarô nhũm akra kato nẽ myre. Ka hã hixi mẽ nhũm kêp Jejus. ");
INSERT INTO apnNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","33","Koja Tĩrtũm amã ho mex rax nẽ. Nẽ koja mẽ piitã mẽ kãm kêp amnhĩ Kra hã ho amnhĩrĩt. Nẽ mẽ apê Ijaew o amnhĩptàr kaxyw koja mẽ akaxyw ãm nhũm higêt pahi Tawi pyrà nẽ mẽ ato amnhĩptàr o pa. Mẽ ate amnhĩ wỳr kamã ajamak o apa xwỳnhta koja. Tĩrtũm kãm hprãm xà hkôt koja mẽ ato amnhĩptàr rãhã ho pa. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Nhũm pre ã kãm kapẽr anẽ nhũm amnhĩ tã kuma nẽ tee ri amnhĩ kukamã hamaxpẽr hãmri nẽ kãm: —Xê gàà nẽ. Tanhmã kot pa kêt we amnhĩ to nẽ ixtujarô? Kormã ixkukrit nẽ mo kormã inhmjên? Mê. Xà Juje kot ixkamã hkra hkukamã na ka ã ri inhmã axujarẽnh anẽ? Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Hãmri nhũm kãm: —Nà koja Tĩrtũm Karõ tãm tanhmã ato ka ỹ hã tanhmã amnhĩ to hkêt tã atujarô. Jakamã koja akra kêp Tĩrtũm Kraa. ");
INSERT INTO apnNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","37","Na ra haxwỳja anã Ijapewja htujarô. Ra hpigêx tỳx nẽ aa hkra hkêt nhũm hkwỳjaja kot axpẽn mã õhy kamã hkra hkêt kumrẽx ã harẽnh o pa htã ra htujarô. Tĩrtũm kot tanhmã mẽ ho nhũm mẽ htujarô tanhmã kêp kute hkêt. Jakamã nhũm tanhmã ho nhũm mjên tãm htu nhũm ra htujarô hã mytwrỳ kêp 6. Tĩrtũm tãm kot mẽmoj piitã tanhmã ho kaxyw àhpumunh xihtỳx. Jakamã koja uràk nẽ mã ato anẽ nẽ ka kormã akukrit tã atujarô. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Nhũm pre ã Gapriew Marir mã kapẽr anẽ nhũm amnhĩ tã kuma nẽ kãm: —Ko. Kê mãmrĩ kãm tanhmã ixto hprãm xà hkôt mãmrĩ tanhmã inhĩpêx to. Inhmã Tĩrtũm kapẽr kôt amnhĩ nhĩpêx prãm. Kê mãmrĩ kãm tanhmã ixto hprãm xà hkôt tanhmã inhĩpêx to. Anẽ nhũm kuma nẽ ma akupỹm api. ");
INSERT INTO apnNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","40","Tã nhũm Marir amnhĩ tujarô hã amnhĩ pumu nẽ nã Ijapew wỳr hkrà kurê kumrẽx. Hãmri nẽ nojarêt nẽ õ krĩ rũm kato nẽ ma hwỳr mõ. Ma Ijapew papxà hwỳr mõ. Ijapew nhõ krĩja pika pê Jutej kamã nhỹri hixêt kamã na pre. Nhũm ma hwỳr mõ hãmri nẽ hwỳr pôj nẽ Ijapew wỳr axà nẽ omu nẽ kãm: —Ka? Xà wa amex? Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Hãmri nhũm kuma nẽ kãm: —Ỳ ma wa inhmex na pa wa ixpa. Anhỹrja kôt nhũm õhy kamã hkraja haxwỳja te kot Marir kapẽr mar nẽ amnhĩ nhĩpêx pyràk o htu kamã àxônh tỳx o nõ. Hãmri nhũm Ijapew Tĩrtũm Karõ nhỹ hã tanhmã Marir mã kapẽr to. ");
INSERT INTO apnNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Kàx pê kãm kapẽr nẽ kãm: —Xê gàà nẽ. Ra Tĩrtũm kot ato mex jakamã na ka akĩnh rax o mẽ inhni hkwỳjê jakrenh pa. Anhõhy kamã akraja koja Tĩrtũm amã ho mex rax nẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Xê mon ka ã ixto mex nẽ ixwỳr amõr anẽ? Apê inhõ Pahihti katorxà htã ixto mex nẽ ã ixwỳr amõr anẽ. Hêxta gàà nẽ. Ãm hãmri na ka ixwỳr mõ Marir. ");
INSERT INTO apnNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Na ka ixwỳr mõn pôj nẽ inhmã akapẽr hãmri nhũm ixtu kamã ixkrare akapẽr ma nẽ hkĩnh xàj ixtu kamã ixkamnãr tỳx o nõ. ");
INSERT INTO apnNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Na ka pre Tĩrtũm kapẽr o wrỳk xwỳnh kot amã kapẽrja ma nẽ hkôt ajamaxpẽr tỳx nẽ. Jakamã kot kaj Tĩrtũm nhỹ hã akĩnh nẽ ajamakêtkati nẽ amex nẽ ri apa. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Hãmri nhũm Marir Ijapew kot ã kãm kapẽr anhỹrja ma nẽ kãm Tĩrtũm mex o mex ã gre nẽ grer o: Tĩrtũm na mex o mex. ");
INSERT INTO apnNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Kêp ixkaprĩ xwỳnh na. Kêp ixkaprĩ xwỳnh jakamã na pa inhmex nẽ ixkĩnh nẽ ri ixpa. ");
INSERT INTO apnNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","49","Ixte amnhĩ to grire nhũm ja hã ixpumu nẽ ixkamã ukaprĩ nẽ ixto mex rax kumrẽx. Jakamã koja mẽ piitã axpẽn kanrẽhã axpẽn mã ijarẽnh rãhã ho pa. Tĩrtũm kot tanhmã ixto mex to hã ijarẽnh rãhã ho pa. Tĩrtũm na mex o mex nẽ hihtỳx o hihtỳx. Tã na ã inhĩpêx anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Ma na hte ã amnhĩ nhĩpêx anẽ nẽ axpẽn kanrẽhã mẽ kot hã hpijaàm xwỳnhjê pumu nẽ mẽ kutã nojarêt rãhã ho pa. Nẽ mẽ kamã ukaprĩ rãhã ho pa. ã na hte mẽ hipêx mex anhỹr o pa. ");
INSERT INTO apnNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Nẽ hihtỳx o hihtỳx jakamã na hte mẽ kot amnhĩ to jarkrar o ri mẽ pa xwỳnhjaja tanhmã mẽ ho nhũm mẽ axkaprã. ");
INSERT INTO apnNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Nẽ pahihti hkwỳ kot kapẽr mar nẽ ãm mar xwỳnhjaja. Na hte amnhĩ tã mẽ omu nẽ mẽ àpênh nê mẽ hapôj nẽ mẽ hpãnhã mẽ kot amnhĩ to hkryre xwỳnh kwỳ jagjê. ");
INSERT INTO apnNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Na hte mẽ kãm kapẽr kôt amnhĩ nhĩpêx prãm xwỳnhjê ho mex o pa nhũm mẽ mex nẽ pa. No mẽ kãm hprãm kêt xwỳnhjaja nhũm tanhmã mẽ ho mex to hkêt nẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","ãm hãmri na pre amnepê mã mẽ panhĩgêt mã amnhĩ jarẽnh xà hkôt mẽ pahpê Apraãw rũm axpẽn kanrẽhã hkrajaja mẽ pahto mex o pa. Mẽ pahpê Ijaew mẽ pahte kãm tanhmã amnhĩ nhĩpêx to ho papa nhũm kãm mẽ pajapê xàj mẽ pahto mex rãhã ho pa. Nẽ mẽ pakamã ukaprĩ rãhã ho pa. Anẽ. Nhũm pre ã Marir Ijapew mã Tĩrtũm mex o mex ã grer anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Hãmri nẽ ri hkôt pa hã mytwrỳ axkrunẽpxi nẽ ma akupỹm õ krĩ hwỳr mõ. ");
INSERT INTO apnNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Tã nhũm Ijapew hpijagri kaxyw õhy xà nhũm hkrare kato nẽ myre. ");
INSERT INTO apnNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Hãmri nhũm omu nẽ hkĩnh tỳx nẽ. Hãmri nhũm hkwỳjaja Tĩrtũm kot wa kamã ukaprĩ hã wa kãm wa hkra myre nhõr ã harẽnh ma nẽ wa ỹ hã hkĩnh nẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Tã nhũm wa hkraja ra hã arĩgro pê 8 nhũm mẽ hkwỳjaja kot my kwrỳt kà krãhyr kaxyw hwỳr akuprõ. Tĩrtũm kot mẽ kãm hã karõ xà hkôt nhũm mẽ kot kãm õr ã amnhĩ to amnhĩrĩt kaxyw ã hipêx anhỹr kaxyw. Na htem ã mẽ kêp Ijaew krajê piitã mẽ hipêx anẽ. Jakamã nhũm prem ã hipêx anẽ hãmri nẽ hpãnhã tanhmã kot hã hixi mẽnh to kaxyw ri hã axpẽn kukja. Hãmri nẽ hipêêxà hkôt kot hã Jakaris mẽnh kaxyw. ");
INSERT INTO apnNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Hãmri nhũm katorxà tee ri axpẽn tã mẽ kuma nẽ mẽ kãm: —Ma koja kêp Jakaris kêt nẽ. Koja kêp Juãw. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Hãmri nhũm mẽ tee ri kuma nẽ kãm: —Kokỹ. Mo jar mẽ pahtõ pê Juãw kot kêt ri kêp Juãw? Jar amrakati kênã kot ka kêt wa ri ã hã hixi rẽnh anẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Hãmri nẽ hixi hã hipêêxà kukja. Nom nhũm arĩ umar kêt nẽ kapẽr kêt jakamã nhũm mẽ tanhmã ri kãm mẽ ĩhkra nhĩpêx to. ");
INSERT INTO apnNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Hãmri nhũm ĩhkra ho kagà hã ahwỳ nhũm mẽ kãm ja gõ nhũm kupy nẽ hã mẽ kãm hixi nhĩpêx. Nhũm mẽ kupy nẽ omu hãmri nẽ hixi pê Juãw kôt omu. Hãmri nẽ tee ri hixija kukamã hamaxpẽr. ");
INSERT INTO apnNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Rôm nhũm Jakaris akupỹm ama nẽ kapẽr mex kurê kumrẽx nẽ Tĩrtũm mã mex o mex ã harẽnh o xa. ");
INSERT INTO apnNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","66","Hãmri nhũm mẽ omu nẽ ma mẽ piitã mẽ kãm wa hkra jarẽnh o ri axpẽn kôt hprõt. Pika pê Jutej kamã hixêt kape hã krĩ hkôt nhũm mẽ ri mẽ piitã mẽ kãm harẽnh o hprõt. Tĩrtũm kot wa hkra kôt tãnopxar o pa nẽ ho mex ã harẽnh o hprõt. Hãmri nhũm mẽ kuma nẽ tee ri hkukamã hamaxpẽr nẽ axpẽn mã: —Hêxta waa nẽ. Tĩrtũm tãm na xep hte jare hkôt ri pa ho pa. Jakamã koja nhỹrmã hprêk hãmri nẽ tanhmã koja we amnhĩ nhĩpêx to ho pa wehee? Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Hãmri nhũm Jakaris Tĩrtũm Karõ nhỹ hã Tĩrtũm mex o mex ã harẽnh o xa. Tĩrtũm kot mẽ kêp Ijaew o mex ã harẽ nẽ mẽ kãm: ");
INSERT INTO apnNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Hêxta waa nẽ. Nà Tĩrtũmja mex o mex. Na pre hte mẽ pahpãmjaja ãm hkôt pix mã amnhĩ nhĩpêx o pa. Jakamã nhũm hte Tĩrtũm mẽ pahpê hkrajê kamã ukaprĩ nẽ mẽ pahto mex o pa. E kwa pu mẽ kãm mex o mex ã harẽnh rãhã nẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Ra kot mẽ pahwỳr mẽ pahkaprĩ xwỳnh pê mẽ panhõ pahihti mẽnh mã. Ja kaxyw àhpumunh xihtỳx o hihtỳx jakamã na pre ra mẽ pahwỳr mẽnh ã amnhĩ jarẽ. Koja kêp amnepêm Tĩrtũm mã tanhmã amnhĩ nhĩpêx to ho pa xwỳnh Tawija hkanrẽhã htàmnhwỳ. ");
INSERT INTO apnNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Amnepêm Tĩrtũm nhỹ hã kapẽr xwỳnhjaja na prem mẽ kãm Tĩrtũm kapẽr jarẽnh o pa nẽ mẽ kãm: ");
INSERT INTO apnNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","“Koja Tĩrtũm mẽ panê mẽ kãm mẽ pahkurê xwỳnhjê pumunh mex o pa.” Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Tĩrtũm ra kot mẽ pahpãmjê mã amnhĩ jarẽnh xà hkôt kãm mẽ pakamã ukaprĩ rãhã ho pa hprãm. Koja aa ja ho anhỹr o hamakêtkati hkêt nẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","75","Na pre ra mẽ pahpãm Apraãw mã mẽ pakukamã ã mẽ pahtã amnhĩ jarẽnh anẽ nẽ kãm: “Kot paj mẽ anê mẽ kãm mẽ akurê xwỳnhjê pumunh mex nẽ mẽ ĩhkra nê mẽ ato ixkato. Jakamã kot kaj mẽ amnhĩ kamã amã mẽ uma hkêt nẽ axàmnhĩx ri ajamakêtkati nẽ mẽ kamã apa. Nẽ kot kaj mẽ mãmrĩ axàmnhĩx ri inhmã tanhmã amnhĩ nhĩpêx to ho ri apa rãhã nẽ. Nẽ ixkôt amnhĩ nhĩpêx o ri apa rãhã ty.” Anhỹr o na pre Tĩrtũm mẽ pakukamã mẽ pahtã amnhĩ jarẽ. Anẽ. Nhũm pre ã Jakaris mẽ kãm Tĩrtũm kapẽr jarẽnh anẽ. Hãmri nẽ hkrareja mỳ nẽ o xa nẽ kãm: ");
INSERT INTO apnNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","—No ka Xugitre. Kot kaj aprêk hãmri nẽ apê Tĩrtũm maati nhỹ hã kapẽr jarẽnh o apa xwỳnh. Jakamã kot kaj Pahihti hkukamã mẽ piitã mẽ kãm harẽnh o ri mẽ hkôt apa. Mẽ kot amar nẽ kutêp tãm amnhĩ nhĩpêx kaxyw. ");
INSERT INTO apnNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","—Tĩrtũm kot mẽ nê mẽ kot amnhĩ tomnuj rênh nẽ mẽ ho hkra hã harẽnhja kot kaj mẽ hkôt mẽ kãm harẽnh o ri apa. ");
INSERT INTO apnNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","—Na hte Tĩrtũm mẽ pakamã ukaprĩ ho pa nẽ mẽ pakamã gryk tokyx anhỹr kêt nẽ. Jakamã koja mẽ pahwỳr mẽ pahkaprĩ xwỳnhja mẽ. Kormã mẽ pahwỳr wrỳk kêt jakamã te mẽ pahte kamàt kô kamã tee ri mẽ paxàhkupênh o ri papa xwỳnh pyràk. —Nom koja mẽ pahwỳr wrỳkja o te ra myt kator nẽ mẽ pamã hirã nẽ mẽmoj to amnhĩrĩt mex pyràk o mẽ panhĩpêx. Ja kaxyw koja Tĩrtũm mẽ pahwỳr mẽ pahkaprĩ xwỳnhta mẽ nhũm man mẽ pahwỳr wrỳ nẽ mẽ pamã mẽ pahtyk pyma xwỳnhjê mã Tĩrtũm kapẽr o amnhĩrĩt o pa. Mẽ pahte mar nẽ ra pajamakêtkati nẽ paxàmnhĩx ri papa nẽ pahtyk kaxyw. ");
INSERT INTO apnNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","—Mẽ kãm mẽ htyk pyma xwỳnhjaja te kamàt kô kamã ri pa pyràk. Tã koja mẽ pahkaprĩ xwỳnhja wrỳ hãmri nẽ tanhmã mẽ hkrã hto nhũm mẽ te arĩgro hã ri mẽ pa xwỳnh kot amnhĩ nhĩpêx pyràk o amnhĩ nhĩpêx. Jao hamakêtkati nẽ axte kãm htyk pyma hkêt nẽ ri pa. Anẽ. Nhũm pre ã Jakaris Tĩrtũm Karõ nhỹ hã hkrare mã kapẽr anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Tã nhũm Juãwja gaa nẽ aptàr. Nẽ Tĩrtũm kôt amnhĩ nhĩpêx o pa. Nom kormã kot Ijaew jahkre ho pa hkêt ri kapôt ã ri mẽ puhã pa. Ã na pre Juãw kator nẽ amnhĩ nhĩpêx anhỹr o pa anẽ. Na pre kato nẽ hã mytwrỳ grêre hãmri nhũm Jejusja hkôt kato. ");
INSERT INTO apnNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","2","Na pre ã Jejus kator anẽ. Nhũm pre Rõm nhõ xwỳnhjê nhõ pahi Sesti Akusja õ pika piitã hkôt mẽ ho kõta kaxyw. Aa kot mẽ ho kõta hkêt tã ra kot mẽ ho kõta kaxyw. Kormã pahi Sirẽn haxwỳja kot pika pê Sir kamã mẽ ho amnhĩptàr ri nhũm pahi Sesti Akus kot mẽ ho kõta kaxyw. Jakamã kãm àpênh xwỳnhjê mã kapẽr nẽ mẽ kãm: —E kêr ka mẽ ho kõta kaxyw nẽ mẽ piitã mẽ hixi hã kagà hpa. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Hãmri nhũm mẽ piitã ã kot mẽ hipêx anhỹr ã amnhĩ tã harẽnh ma hãmri nẽ mẽ kot mẽ hixi hã kagà kaxyw piitã akupỹm papxà hwỳr ma hapêx. ");
INSERT INTO apnNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Nhũm pre Marir mjên Juje haxwỳja ma krĩ pê Perẽj wỳr mõ. Garirej kamã õ krĩ pê Najare rũm kato nẽ ma hwỳr mõ. Pika pê Jutej kamã na Perẽjja. Kamã na pre Juje nhĩgêt Tawija kato. ");
INSERT INTO apnNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Nhũm Juje kêp kanrẽhã htàmnhwỳ jakamã na pre ma akupỹm hwỳr mẽ hkwỳjê hkôt mõ. Nẽ ma amnhĩ kôt kot ho hprõ mã xwỳnh Marir o mõ. Arĩ htujarô rax rãhã nhũm ma amnhĩ kôt o mõ. ");
INSERT INTO apnNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Nhũm wa mõõ hãmri nẽ hwỳr pôj. Nhũm Marir hpijagri xà hã mytwrỳ mã àr jakamã nhũm kamàt nhũm õhy xà. ");
INSERT INTO apnNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Nom nhũm Perẽj wỳr mẽ hpôx nyw xwỳnhjaja ra ixkre piitã ho nỳt pa nhũm wa tee ri hpijagri kaxyw amnhĩ to ukapi ho pa. Hãmri nẽ nhỹri môx nhõrkwỹ punajre hwỳr axà nhũm Marir kamã hpijagri. Nhũm hkra kato nẽ myre. Kra kot wa na pre. Hãmri nhũm kumỳ nẽ kupẽxê ho hkupu hpa nẽ môx xàpkur xà hã kôsti kaprỳ kamã kuxi nhũm hamakêtkati nẽ gõr nẽ nõ. ");
INSERT INTO apnNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Rôm nhũm ôwêhti jamãr o mẽ pa xwỳnhjaja kapôt ã ri hkrit ôwêhti jamãr o pa. Nhũm ra kamàt nhũm mẽ hamãr o hkrĩ. ");
INSERT INTO apnNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Pu nhũm kaxkwa rũm Tĩrtũm kapẽr o wrỳk xwỳnhja wrỳ nẽ mẽ mỳri ajêt. Hãmri nẽ tanhmã amnhĩ to nẽ mẽ hpuhã ho hirã rax kumrẽx. Nom nhũm Tĩrtũm tãm ã mẽ hipêx anẽ. Hãmri nhũm mẽ tee ri jawỳ Tĩrtũm kapẽr o wrỳk xwỳnhja pumu nẽ kãm ma htỳx nẽ akryk omunh o hkrĩ. ");
INSERT INTO apnNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Hãmri nhũm mẽ kãm: —Pa? Kwa mẽ amã ixpyma hkêt nẽ. Ixte mẽ amã mẽmoj mex jarẽnh kaxyw na pa mẽ awỳr wrỳ. Kot kaj mẽ harẽnh ma nẽ akĩnh nẽ. Nom mẽ kapxipixjaja kaj mẽ akĩnh kêt nẽ. Koja mẽ piitã ja jarẽnh ma nẽ mẽ apyrà nẽ hkĩnh nẽ pa. ");
INSERT INTO apnNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Na ra ham mẽ akamã ukaprĩ xwỳnhta kato. Pahi Tawi nhõ krĩ mẽ mẽ anhõ krĩ pê Perẽj kamã. Kêp mẽ apiitã mẽ anhõ pahihti na. Mẽ ate amnhĩ wỳr kamã ajamak o apa xwỳnh pê Kris na. Tãm na ham kato. ");
INSERT INTO apnNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","E pa ixprĩ hã mẽ amã tanhmã harẽnh to ka mẽ inhma. Na kato nhũm katorxà kupẽxê ho kupu hpa nẽ kôsti kamã kuxi nhũm nõ. Kwa mẽ tokyx ma hwỳr mra nẽ kêp mẽ anhõ pahihti hã omu. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Nhũm pre ã mẽ kãm ujarẽnh anẽ. Hãmri nhũm hkwỳjaja wamta kôt ohtôô nẽ mẽ hwỳr wrỳ nẽ puhã harir. Hãmri nẽ Tĩrtũm mã mex o mex ã grer o harir. ");
INSERT INTO apnNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","Nẽ hã grer o: Tĩrtũm maati na mex o mex. Jakamã mẽ kãm hprãm xà kôt pix mã amnhĩ nhĩpêx o mẽ pa xwỳnhjaja koja amnhĩ tã mẽ omu nẽ tanhmã mẽ ho nhũm mẽ hamakêtkati nẽ àmnhĩx hkĩnh nẽ pa ho pa. ");
INSERT INTO apnNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Anhỹr o grer o harir hãmri nẽ ma akupỹm kaxkwa hwỳr àpir pa nẽ akunok. Hãmri nhũm ôwêhti jamãr xwỳnhjaja mẽ kapẽr ma nẽ ma akupỹm àpir ã mẽ omu nẽ axpẽn mã: —E tokyx pu mẽ krĩm nẽ Tĩrtũm kot mẽ pamã ho amnhĩrĩt xwỳnhta japêr nẽ tokyx nhỹri omu. Kwa ma pu mẽ tokyx hwỳr nẽ omu. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Hãmri nhũm mẽ ma hwỳr mra. Hãmri nẽ krĩm agjê nẽ môx nhõrkwỹ wỳr agjê nẽ mẽ hkrareta pumu. Nhũm kôsti kamã nõ nhũm mẽ omu nẽ kuri Marir mẽ Juje wa omu. ");
INSERT INTO apnNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Hãmri nẽ akupỹm hapôj nẽ ma mẽ piitã mẽ hkôt ri mẽ kãm harẽnh o pa. Ra Tĩrtũm kapẽr o wrỳk xwỳnh kot mẽ kãm harẽnh xàja kôt nhũm mẽ ma mẽ kãm harẽnh o ri mẽ hkôt pa. ");
INSERT INTO apnNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Nhũm mẽ amnhĩ jaêr pê mẽ kot harẽnh ma nẽ tee ri hkukamã hamaxpẽr. ");
INSERT INTO apnNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Nom nhũm Marir mẽ kot kãm hkrax rũm tanhmã hkra jarẽnh to xàta kukamã pix mã hamaxpẽr rãhã ho pa. ");
INSERT INTO apnNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Jakamã nhũm ôwêhti jamãr xwỳnhjaja ma akupỹm hkrit wỳr mra. Tĩrtũm kapẽr o wrỳk xwỳnh ra kot mẽ kãm ujarẽnh xà hkôt nhũm mẽ kot Jejus pumunh jakamã ma akupỹm hkĩnh nẽ Tĩrtũm mã mex o mex ã harẽnh pê hã grer o akupỹm mra. ");
INSERT INTO apnNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Tã nhũm wa hkrareta ra hã arĩgro pê 8 nhũm mẽ hwỳr akuprõ nẽ kãm my kwrỳt kà krãhta. Na hte Ijaew mẽ hkra myre piitã ã mẽ hipêx anẽ. Mẽ piitã mẽ kot Tĩrtũm mã õr ã mẽ omunh kaxyw. Jakamã nhũm mẽ kãm ho anẽ nẽ hpãnhã hã hixi mẽ. Marir kormã kot ho htujarô hkêt ri Tĩrtũm kapẽr o wrỳk xwỳnh kot hkukamã kãm hixi jarẽnh xàja kôt nhũm mẽ hã hixi mẽ nhũm hixi kêp Jejus. ");
INSERT INTO apnNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","24","Tã nhũm Marir hpijagri ho hapêx. Jakamã nhũm Juje ma krĩ pê Jerujarẽ hwỳr mẽ kot Tĩrtũm mã amnhĩ jarẽnh xà hã ixkre hwỳr amnhĩ kôt o mõ. Na pre ra finat Mojes amnepêm Tĩrtũm nhỹ hã mẽ hkukamã mẽ hpãmjê mã ja hã karõ. Nẽ mẽ kãm hã karõ ho: Koja mẽ aprõ hpijagri. Hãmri nẽ hpijagri ho hapêx ka mẽ ma Tĩrtũm mã amnhĩ jarẽnh xà hã ixkre hwỳr o mra nẽ hpãnhã Tĩrtũm mã mẽmoj gõ. Kãm tutre ho gõ rỳ kãm tuuti hõ ho axkrut nẽ agõ kê patre hamỳ nẽ kãm kupa. Kot ja hã omunh nẽ hpijagri xwỳnhta akupỹm mex ã harẽnh kaxyw. Anhỹr o kot mẽ kãm ja hã karõ jakamã nhũm wa ma ã amnhĩ nhĩpêx anhỹr kaxyw hwỳr mõ. Nẽ amnhĩ kôt Jejus mỳ nẽ o mõ. Tĩrtũm kot mẽ kãm ja hã karõ nhũm mẽ kot hã kagà xà hkôt. Na pre ra finat Mojes mẽ kãm ja jarẽ nẽ mẽ kãm: Kot kaj mẽ akra my kot wa hãmri nẽ te mẽ ate Tĩrtũm mã õr kaxyw hipêx pyràk o hipêx. Kê tãm amnhĩ nhĩpêx o pa nẽ ỹ hã tanhmã kãm amnhĩ nhĩpêx to ho pa. Anhỹr jakamã nhũm wa ra Jerujarẽ hwỳr nojarêt nẽ amnhĩ kôt Jejus mỳ nẽ ma amnhĩ kôt o mõ. ");
INSERT INTO apnNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","26","Rôm nhũm Jerujarẽ kamã Simeãwja. Tĩrtũm Karõ nhỹ hã kot tanhmã amnhĩ to mex to ho pa xwỳnh na pre. Na pre hte Tĩrtũm kapẽr kôt pix mã tãm amnhĩ nhĩpêx o pa. Jakamã nhũm pre ra Tĩrtũm Karõ ã kãm kapẽr anẽ nẽ kãm: —E inhma Simeãw. Kot kaj atĩr rãhã nhỹrmã Tĩrtũm kot mẽ akaxyw ãm mã xwỳnhja ka ano ho omu nẽ rĩ kormã ty. Anhỹr o kãm kapẽr jakamã nhũm kuma nẽ hkĩnh nẽ ãm pix kamã hamak o pa. Mẽ kêp Ijaew wỳr wrỳk nẽ mẽ ho mex mã xwỳnhta pix kamã hamak rãhã ho pa. ");
INSERT INTO apnNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Jakamã nhũm Jejus katorxà mẽ hipêêxà purota wa Tĩrtũm mã amnhĩ jarẽnh xà hã ixkreja wỳr Jejus o axà nẽ kormã o xa. Finat Mojes kot mẽ kãm hã karõ xà hkôt. Hãmri nhũm Tĩrtũm Karõ mẽ hwỳr Simeãwja mẽ nhũm ma mẽ hwỳr tẽ nẽ axà. ");
INSERT INTO apnNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Hãmri nẽ wa hkrata pumu nẽ hkĩnh tỳx nẽ. Hãmri nẽ wa kêp kumỳ nẽ o xa nẽ hã Tĩrtũm mã mex o mex ã harẽ nẽ kãm: ");
INSERT INTO apnNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","32","Pa Pahi Maati. E ot pa ixte amã tanhmã amnhĩ nhĩpêx to ho ixpa xwỳnh ã amnhĩ jarẽ. Nà ãm hãmri na ka pre ã inhmã jare hkukamã harẽnh anẽ. Tã ate inhmã harẽnh xà hkôt pa ra inhno ho omu. Kêp mẽ ixkamã ukaprĩ xwỳnh ã omu. Nẽ kêp ate mẽ ixwỳr mẽnh xwỳnh ã omu. Nà koja te arĩgro hã myt hirã nẽ mẽmoj piitã ho amnhĩrĩt mex pyràk o koja mẽ inhĩpêx o pa. Jakamã koja hprêk hãmri nẽ ma Ijaew kêt xwỳnhjê mã apê Tĩrtũm ã akapẽr o amnhĩrĩt o pa nhũm mẽhprĩ hã ajarẽnh ma. Nẽ mẽ ixpê Ijaew kot paj mẽ ijaxwỳja kuma nẽ hã ixpijaàm o ri ixpa. Jakamã kot paj ixàmnhĩx ri tanhmã amnhĩ nhĩpêx to ho ri ixpa nẽ ixàmnhĩx ty. Ra ixte inhno ho ate inhmã harẽnh xwỳnhta pumunh kênã. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Nhũm pre ã Simeãw Jejus jarẽnh anẽ. Nhũm katorxà mẽ hipêêxà purota wa amnhĩ jaêr pê kot ã harẽnh anhỹrja mar o xa. ");
INSERT INTO apnNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","35","Hãmri nhũm Simeãw wa ho Tĩrtũm wỳ nẽ kãm: —E Tĩrtũm. Kêr ka ja wa ho mex nẽ. Wa ho mex o wa ho mex rãhã ho apa. Anẽ. Hãmri nẽ Marir mã kapẽr nẽ kãm: —Nà ãm hãmri na pre Tĩrtũm mẽ pakaxyw akrata xãm. Mẽ pahpê Ijaew kaxyw ãm. Jakamã koja hprêk nẽ ma Tĩrtũm kapẽr o mẽ piitã mẽ ahkre ho ri mẽ hkôt pa. Nhũm mẽ kuma hãmri nẽ ahpỹnhã tanhmã hamaxpẽr to xà hkôt tanhmã hipêx to. Jakamã nhũm mẽ hkwỳjaja kuma nẽ hkôt amnhĩ xunhwỳ nẽ hkôt amnhĩ nhĩpêx o pa. Jao tãm hipêx o pa. No nhũm mẽ hkwỳjaja kuma nẽ axtem nẽ kãm hkĩnh kêt nẽ. Hãmri nẽ tanhmã hipêx to. Jakamã kot kaj tee ri ja hã mẽ omu nẽ akaprĩ htỳx nẽ. Te mẽ kot wapo ho akanhwỳr nẽ akamã ho kaxkep nhũm apê omnuj tỳx pyràk o kot kaj amnhĩ kamã ama nẽ mẽ omu. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","38","Rôm nhũm mẽhõ ni pê ãntija mẽ hwỳr axà nẽ Jejus pumu. Ãntija Panuew kra na pre. Nẽ Ase hkwỳ na pre. Ni htã kêp Tĩrtũm nhỹ hã kapẽr jarẽnh o pa xwỳnh. Na pre ra mjên no ãm kormã mjên nẽ pa hã amgrà pê 7 pix nhũm pre kêp ty. Hãmri nhũm axte mjên kêt nẽ pa rãhã ra hpigêx tỳx nẽ. Ra hã amgrà pê 84. Na pre hte Tĩrtũm mã amnhĩ jarẽnh xà hã ixkre hwỳr pa nẽ kãm amnhĩ jarẽnh rãhã ho pa. Nẽ kot kãm amnhĩ jarẽnh kaxyw nẽ apkur kêt rãhã kãm amnhĩ jarẽ. Nẽ arĩgro hã hwỳr pa nẽ kamàt kãm hwỳr pa. Ã na pre hte amnhĩ nhĩpêx anhỹr rãhã ho pa anẽ. Jakamã mẽ hwỳr axà nẽ Jejus pumu nẽ hkĩnh nẽ. Hãmri nẽ hã Tĩrtũm mã mex o mex ã harẽ nẽ kãm: —Hêxta gàà nẽ Tĩrtũm. Ãm hãmri na ka mẽ ixwỳr Jejus mẽ. Ma amex o amex. Anẽ. Hãmri nẽ Ijaew kot amnhĩ wỳr mẽ kamã ukaprĩ xwỳnh kamã hamak xwỳnhjê mã ra Jejus kator ã harẽnh o ri mẽ hkôt pa. ");
INSERT INTO apnNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Tã nhũm Marir mẽ Juje wa Tĩrtũm kapẽr ã kagà htũm kôt Tĩrtũm mã amnhĩ jarẽnh xà hã ixkre kamã tanhmã amnhĩ nhĩpêx to hpa hãmri nẽ kato nẽ ma akupỹm mõ. Ma Garirej kamã õ krĩ pê Najare hwỳr wa ma akupỹm mõ. ");
INSERT INTO apnNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Tã nhũm wa hkrata ra wa kãm hprêkre ho mõ. Nẽ mex nẽ àhpumunh tỳx nẽ. Tĩrtũm kot tãnopxar nẽ mẽmoj to kutã nojarêt rãhã ho pa jakamã nhũm mex nẽ hkĩnh nẽ pa. ");
INSERT INTO apnNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Nhũm pre hte Marir mẽ Juje wa amgrà mẽ hkwỳjê hkôt ma Jerujarẽ hwỳr pa. Mẽ kot arĩgro pê Pas ã hkĩnh kaxyw. Pas ã na hte mẽ kêp Ijaew amnepêm Tĩrtũm kot pika pê Ejit rũm mẽ hpãmjê katorja mã hamaxpẽr kaxyw axpẽn wỳr akuprõ nẽ hã hkĩnh. Jakamã nhũm wa ma mẽ hkôt hã hkĩnh kaxyw Jerujarẽ hwỳr hkwỳjê hkôt mõ. ");
INSERT INTO apnNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Nhũm ra Jejus hprêk o mõ. Ra hã amgrà pê 12 jakamã nhũm wa ma amnhĩ kôt o mõ. ");
INSERT INTO apnNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","44","Tã nhũm mẽ hkĩnh pa hãmri nẽ akupỹm nojarêt nhũm Marir mẽ Juje wa ma hkwỳjê hkôt akupỹm mõ. Nhũm Jejus Jerujarẽ kamã ahte arĩk nẽ akupỹm wa hkôt mõr kêt nẽ. Nhũm wa htỳx wam ma hkwỳjê hkôt htẽm ã hkamnhĩx jakamã wa hapêr kêt nẽ. Hãmri nẽ wa hapu hã hamakêtkati nẽ mẽ hkôt mõr o mõr ã ra hã kamàt. Hãmri nẽ mẽ kot amnhĩm hikranh xàja wỳr mẽ hkôt pôj nẽ tee ri mẽ hkaêx ã hkra japêr o ri mra nom omunh kêt nẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Jakamã nhũm apkati nhũm wa awjanã nẽ ma akupỹm Jerujarẽ hwỳr mõ nẽ kamã hapêr o ri pa. ");
INSERT INTO apnNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Nom tokyx kãm kator kêt nẽ. Mẽ hkaêx ã tee ri hapêr o pa hã apkati axkrut. Nẽ nõ nhũm apkati nhũm wa tã Tĩrtũm mã amnhĩ jarẽnh xà hã ixkreja wỳr hapêr o mõ nẽ hwỳr axà. Hãmri nẽ omunh kurê kumrẽx. Nhũm arĩ mẽ kot Tĩrtũm kapẽr tũm o mẽ ahkre xwỳnhjê mar o mẽ kutã nhỹ. Nẽ mẽmoj tã ri mẽ hkukja nẽ tanhmã mẽ kãm ujarẽnh to. ");
INSERT INTO apnNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Nhũm mẽ kot mar xwỳnhjaja tee ri kapẽr ã kuma nẽ àhpumunh tỳx ã omu hãmri nẽ akryk mar o hkrĩ. ");
INSERT INTO apnNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Hãmri nhũm Marir mẽ Juje mẽ hwỳr axà nẽ mẽ kuri wa hkraja pumunh kurê kumrẽx. Hãmri nhũm katorxàja hwỳr tẽ nẽ kãm: —Xê Jejus. Mon ka axtem nẽ ã ri amnhĩ nhĩpêx anẽ nẽ akupỹm wa ixkôt amõr kêt nẽ? Na pa wa mõ nẽ mẽ pahkwỳjê hkôt pôj nẽ tee ri mẽ hkaêx ã ajapêr nẽ tee ri akukamã ijamaxpẽr. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Hãmri nhũm amnhĩ tã wa kuma nẽ wa kãm: —Tỳ. Nom Inhĩpêêxà nhõrkwỹ kamã ixàrĩk kênã na ka wa tee ri ixkukamã ajamaxpẽr nẽ ijapêr o ri apa. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Hãmri nhũm wa kuma nẽ ã kot amnhĩ jarẽnh anhỹrja kukamã tee ri hamaxpẽr. ");
INSERT INTO apnNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Hãmri nẽ mẽ ma akupỹm mõ nẽ Najare hwỳr pôj nẽ kamã pa. Nhũm pre Jejus wa kapẽr kôt ri amnhĩ nhĩpêx rãhã ho pa. Hãmri nhũm katorxàja hkrax rũm mẽ kot kãm tanhmã hkra kot amnhĩ nhĩpêx to hkukamã harẽnhja pix kukamã hamaxpẽr rãhã ho pa. ");
INSERT INTO apnNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Gaa nhũm Jejus ra àptàr o mõ. Nẽ àhpumunh tỳx nẽ. Nhũm mẽ piitã ã kot amnhĩ nhĩpêx anhỹr ã omu nẽ kãm hkĩnh nẽ. Nhũm Tĩrtũm haxwỳja kãm hapê nẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","2","Tã nhũm kormã pahihti Tipeja mẽ ho amnhĩptàr o pa. Na pre ra mẽ ho amnhĩptàr ã amgrà pê 15. Nhũm Põn Piratja pahihti Xipe mã pika pê Ijaew nhõ xwỳnhjê ho amnhĩptà. Nhũm Eroxja kãm pika pê Garirej nhõ xwỳnhjê ho amnhĩptà. Nhũm Erox tõ Firipja kãm pika pê Iturej nẽ hõ pê Takonĩt wa kamã mẽ pa xwỳnhjê ho amnhĩptà. Nhũm Risãnja kãm pika pê Apirẽn kamã mẽ ho amnhĩptà. Nhũm Anas mẽ Kajpasja wa kêp Ijaew nhõ patre maati. Rôm nhũm Jejus mẽ Jakaris kra Juãwja wa ra hamẽ anhĩpê àptàr. Jakamã nhũm Tĩrtũm tanhmã Juãw mã kapẽr to. Kormã kapôt ã ri pa ri nhũm kãm kapẽr nẽ kãm tanhmã kot amnhĩ nhĩpêx to ho pa hã kãm karõ nẽ kãm: —Pa Juãw. E inhma. Kêr ka ma mẽ kãm ixkapẽr jarẽnh rãhã ho ri apa. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Hãmri nhũm kuma nẽ ma ri mẽ kãm kapẽr jarẽnh o pa. Pyhti pê Jotãw mỳri mẽ piitã mẽ kãm harẽnh o ri pa nẽ hpãnhã ihkjê hã ri mẽ pa xwỳnhjê mã harẽnh o ri pa. Nẽ mẽ kãm: —E kwa mẽ tokyx amã amnhĩ tomnuj kaga hprãm xàj tãm ri amnhĩ nhĩpêx. Kê Tĩrtũm ja hã mẽ apumu nẽ mẽ anê mẽ ate amnhĩ tomnuj o hapêx pa. Pa mẽ piitã mẽ kot mẽ apê Tĩrtũm kra hã mẽ apumunh kaxyw mẽ akrã kumrã. Anhỹr o mẽ kãm kapẽr o ri pa. ");
INSERT INTO apnNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","5","Na pre ra amnepêm mẽ hkukamã Tĩrtũm nhỹ hã kapẽr o pa xwỳnh Ijais ra Juãw kukamã kot tanhmã amnhĩ nhĩpêx to hã harẽ nẽ hã kagà. Nẽ hã kagà ho: Koja nhỹrmã mẽhõ mõn pôj. Kapôt ã mõn pôj nẽ mẽ kãm ujarẽnh o ri pa. Nẽ mẽ kãm ujarẽnh o: “E mẽ inhma. Koja Tĩrtũm tokyx mẽ pahwỳr mẽ panhõ pahihti mẽ nhũm wrỳ nhũm mẽ piitã omu. Jakamã kwa mẽ tokyx kutêp tãm amnhĩ nhĩpêx o apa. Te ho mẽ kot mẽhõ kutêp pry ho mex pyràk o amnhĩ nhĩpêx. Jao tãm amnhĩ nhĩpêx. Nẽ tãm axpẽn nhĩpêx. Pahihtita kutêp. Mẽ pahte amnhĩ nhĩpêx te kot pry nhĩnur pyràk nhũm mẽ tee ri kot kãm hã mrar mex prãm kaprỳ pyràk. Hinur nẽ krã hakỳx nẽ pry juk pyràk o na mẽ pahte amnhĩ nhĩpêxja. Jakamã kot kaj mẽ ate amnhĩ tomnuj kaga nẽ tãm amnhĩ nhĩpêx. Nẽ tãm axpẽn nhĩpêx. Hãmri nẽ te mẽ kot pry nhĩnur o mex nẽ ho katàt nhũm katàt muux nẽ nõr pyràk o kot kaj mẽ amnhĩ nhĩpêx. Pahihti nywta kutêp. Kwa kêr ka mẽ ã amnhĩ nhĩpêx anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Kot kaj mẽ anẽ nhũm mẽ ohtô nẽ ja hã mẽ apumu hãmri nẽ mẽ apyrà Tĩrtũm kot mẽ ho hkra kaxyw amnhĩ to kuwỳ.” Anhỹr o mẽ kãm ujarẽnh o pa. Anẽ. Nhũm pre ã finat Ijaisja Juãw Paxis kukamã mẽ kãm ujarẽnh anhỹr o pa. ");
INSERT INTO apnNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Jakamã nhũm àptàr nẽ Ijais kot ra hkukamã harẽnh xà hkôt ma Tĩrtũm kapẽr o mẽ ahkre ho pa. Nhũm prem kuma hãmri nẽ kot mẽ hkrã kumrãr kaxyw hwỳr amnhĩ to mra. Nhũm mẽ omu nẽ tanhmã mẽ ahkre hto. Nẽ mẽ kãm kapẽr kãm hihtỳx nẽ mẽ kãm: —Tk. Kwa kormã. Mẽ ate amnhĩ tomnuj pix o ri apa xwỳnh kênã. Xà kot paj mẽ ate amnhĩ tomnuj rãhã mẽ akrã kumrã nhũm Tĩrtũm ja hã mẽ apumu nhũm ja kãm mex nà? Nà koja ja kãm mex kêt nẽ. Koja ja mỳrapê nhỹrmã tanhmã mẽ anhĩpêx to ka mẽ tee ri umaj apimxur prãm kaprỳ. ");
INSERT INTO apnNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","—Na htem amnhĩ tomnuj kaga nẽ hpãnhã tãm amnhĩ nhĩpêx. Nẽ tãm ri axpẽn nhĩpêx. Jakamã e kwa mẽ ã amnhĩ nhĩpêx anhỹr o apa. No na ka htem atỳx ri ajamaxpẽr o: “Mẽ ixpê finat Apraãw kanrẽhã htàmnhwỳ jakamã koja Tĩrtũm ja hã mẽ ixpumu hãmri nẽ mẽ ixte amnhĩ tomnuj mỳrapê tanhmã mẽ ixto hkêt nẽ. Koja ãm mẽ ixto mex rãhã nẽ.” Anhỹr o atỳx ri amnhĩ kukamã ajamaxpẽr o apa. Nom ja kot anhỹr kêt. Mẽ apê Apraãw kanrẽhã htàmnhwỳ htã uràk nẽ tãm amnhĩ nhĩpêx o apare hã. Kot ka mẽ apê kanrẽhã htàmnhwỳ htã amnhĩ tomnuj o ri apa hãmri nẽ Tĩrtũm noo mã te mẽ apê pikap kẽnre nhĩkwỹ pix pyràk. ");
INSERT INTO apnNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","—Na ra Tĩrtũm kot mẽ ate amnhĩ tomnuj mỳrapê tanhmã mẽ ato kaxyw. Koja mẽ anhĩpêx o te mẽhõ nhõ mẽmoj pàr ô hkêt nhũm kot tee ri omunh hãmri nẽ krãhyr nẽ kuwy kamã mẽnh nẽ ho xêt par pyràk o mẽ anhĩpêx. Jao amnhĩ nê kuwy hwỳr mẽ arẽnh pa ka mẽ kamã amnhĩ xà htỳx kamã ajamak rãhã ho ri apa. Anẽ. Nhũm pre ã Juãw Paxisja mẽ kãm kapẽr anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Hãmri nhũm mẽ kuma nẽ tee ri amnhĩ kukamã hamaxpẽr nẽ kãm: —Kwa xô wehe? Xà koja ã mẽ inhĩpêx anẽ? Kwa tanhmã kot paj mẽ kot ã mẽ inhĩpêx anhỹr pymaj amnhĩ nhĩpêx to wehe? Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Hãmri nhũm mẽ kãm: —Nà kêr ka mẽ axpẽn kãm axukaprĩ ho ri apa. Nẽ mẽ kêp amrakati xwỳnhjê mã amnhĩ kutã mẽmoj nhõr o ri apa. Nẽ mẽ anhĩnôhkà axkrut nẽ mẽhõ hinôkà hkêt xwỳnhjê mã ho pyxi nẽ agõ nẽ pyxi nẽ ho arĩk. Nẽ mẽ axàpkur xà ho anhõxỳ ho apa hkêt nẽ. Ãm axàmnhĩx ri mẽ kêp amrakati xwỳnhjê mã amnhĩ kutã mẽ kãm mẽmoj to hkryre nẽ agõ. E kêr ka mẽ ã axpẽn nhĩpêx anhỹr o ri apa. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Hãmri nhũm Rõm kãm mẽ õ pahihti mã mẽ piitã mẽ kêp kàxpore hkwỳ jamỳnh xwỳnhjaja mẽ uràk nẽ hwỳr mra. Kot mẽ uràk nẽ mẽ hkrã kumrãr kaxyw hwỳr mra nẽ kãm: —No we mẽ pajaja? Tanhmã kot paj wem amnhĩ nhĩpêx to? Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Hãmri nhũm mẽ kãm: —Nà mẽ kajaja kêr ka mẽ Rõm nhõ pahi kot mẽ amã mẽ ate mẽ kêp kàxpore hkwỳ jamỳnh jarẽnh xà hkôt pix mã hamỳnh o ri apa. No mẽ atỳx ri amnhĩ krã hkôt amnhĩm hkwỳ jamỳnh prãm xàj mẽ kãm hkre kamã ho rũnh nẽ mẽ kãm harẽnh o ri apa hkêt nẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Hãmri nhũm hpãnhã pôristi hkwỳjaja hwỳr mra nẽ kãm: —Kwa no we mẽ pajaja? Tanhmã kot paj wem ri amnhĩ nhĩpêx to ho ixpa? Anẽ. Hãmri nhũm mẽ kãm: —Nà kêr ka mẽ anhõ pahihti kot mẽ axàpênh pãnhã mẽ amã kàxpore nhõrta pix jamỳ nẽ ajamakêtkati nẽ axàmnhĩx ri ho amnhĩm axujaprôr o ri apa. No mẽ akwỳjaja kãm apyma nẽ mẽ amã kàxpore nhõr prãm xàj ri mẽ kãm tanhmã amnhĩ pyma hto ho ri apa hkêt nẽ. E kêr ka mẽ ã amnhĩ nhĩpêx anhỹr o ri apa. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Nhũm pre ã Juãw Paxisja mẽ kãm kapẽr anẽ. Nhũm mẽ kuma nẽ htỳx kêp Tĩrtũm kot mẽ pakaxyw ãm mã xwỳnhta ã hkamnhĩx. ");
INSERT INTO apnNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Hãmri nhũm amnhĩ tã ã mẽ hamaxpẽr anhỹr ã mẽ omu hãmri nẽ mẽ kãm amnhĩ tã aprã nẽ mẽ kãm: —Nà pa hkêt. Na pa hte ãm Tĩrtũm mã gô pix o mẽ hkrã kumrãr o ri ixpa. No koja tokyx ixpãnhã Tĩrtũm kot mẽ pakaxyw ãm xwỳnhta tãm mẽ pahwỳr pôj. àhpumunh tỳx o kot ijakrenh jakamã na pa hte ãm kukwak ri ixpa nẽ hã ixpijaàm o ri ixpa. Tĩrtũm kot mẽ pakaxyw ãm xwỳnhta koja mẽ awỳr Karõ rẽ nhũm mẽ akaxwỳnh mã agjê ka mẽ ỹ hã tãm ri amnhĩ nhĩpêx rãhã ho ri apa. Nom kormã mẽ kot tãm amnhĩ nhĩpêx hkêt xwỳnhjaja koja ja hã mẽ omu hãmri nẽ mẽ hipêx o te kuwy kot mẽmoj to kaxàr par pyràk o mẽ hipêx. ");
INSERT INTO apnNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","—Na htem pur kãm harôj nhĩkẽ nẽ ho grà nẽ hpãnhã kahtwỳ. Nẽ kahuk pa hãmri nẽ hkapĩ nhũm kôk apê nẽ prỳhkà ho htor nẽ ho hapêx pa. Nhũm mẽ hy ho pa nẽ ixkre kamã gôj kãm unhwỳ. Ja pyrà nẽ koja tokyx Tĩrtũm mẽ piitã mẽ kot tanhmã amnhĩ nhĩpêx to ho pa hã mẽ omunh xà hkôt mẽ ho axkjê. Mẽ kot tãm amnhĩ nhĩpêx o mẽ pa xwỳnhjaja koja ma amnhĩ wỳr mẽ ho api nhũm mẽ kuri mex nẽ hkĩnh rãhã nẽ pa ho pa. No mẽ kot amnhĩ tomnuj xwỳnhjaja koja mẽ hkĩnhã tanhmã mẽ hipêx to nhũm mẽ ma kuwy raxja wỳr pa nẽ kamã amnhĩ xà htỳx kamã hamak rãhã nẽ pa ho pa. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Nhũm pre ã Juãw Paxis Tĩrtũm kapẽr o mẽ ahkre anhỹr o pa. ");
INSERT INTO apnNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Tã nhũm Ijaew nhõ pahi Erox ra htõ hprõ pê Eroxis pytà nẽ ho hprõ nhũm Juãw Paxisja harẽnh ma nẽ ma hwỳr tẽ nẽ hã kãm akir. No ãm ja pix ã kãm àkjêr kêt nẽ. Mããnẽn tanhmã kot amnhĩ tomnuj tỳx to ho pa hã kãm akir. ");
INSERT INTO apnNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Nhũm amnhĩ tã kuma nẽ kamã gryk tỳx nẽ amnhĩ tã mẽ kãm hã amỹnê nhũm prem unê nẽ haxà. Jao amnhĩ tomnuj tỳx nẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Nom kormã mẽ kot haxàr kêt ri nhũm Juãw Paxis Ijaew kwỳjê krã kumrãr o xa. Rôm nhũm Jejusja hãmri tãm nhỹhỹnh hwỳr tẽ nẽ kot hkrã kumrãr kaxyw kãm anẽ nhũm kuma nẽ hkrã kumrã. Hãmri nhũm Jejus gôj rũm api nẽ kormã gô mỳ ri Tĩrtũm mã amnhĩ jarẽnh o xa. ");
INSERT INTO apnNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Pu nhũm kaxkwa axkjê nhũm kurũm Tĩrtũm Karõ te tuuti pyrà nẽ hwỳr wrỳk o tẽ nẽ ĩkre hã xa. Hãmri nhũm kaxkwa rũm Tĩrtũm kãm kapẽr nẽ kãm: Pa? E apê Ixkra mex na ka. Ãm hãmri na ka hte ixkanrẽhã amnhĩ nhĩpêx o apa. Inhmã ajapê kamã na ka ri apa ho apa. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Tã nhũm Jejus Tĩrtũm mã kapẽr o mẽ ahkre ho pa hkrax. Na pre ra hã amgrà pê 30 hãmri nẽ kãm ho hkrax. E kot paj hpãnhã amã Jejus kukamã hpãmjê nhĩxi jarẽ Teopre. Ijaewjaja na prem htỳx ho Juje kêp Jejus nhĩpêêxà kumrẽx ã hkamnhĩx nom kêp hipêêxà kumrẽx kêt ãm kêp hipêêxà puro na pre. Jejus kêp Eri htàmnhwỳ na pre. ");
INSERT INTO apnNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Nẽ Eri kêp Matat kra na pre. Nẽ Matat kêp Rewi hkra na pre. Nẽ Rewi kêp Mewki hkra na pre. Nẽ Mewki kêp Jãnaj kra na pre. Nẽ Jãnaj kêp axtem Juje hõ hkra na pre. ");
INSERT INTO apnNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Nẽ Juje kêp Matatis kra na pre. Nẽ Matatis kêp Amõs kra na pre. Nẽ Amõs kêp Naũ hkra na pre. Nẽ Naũ kêp Eri hkra na pre. Nẽ Eri kêp Nakai hkra na pre. ");
INSERT INTO apnNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nẽ Nakai kêp Mate hkra na pre. Nẽ Mate kêp axtem Matatis õ hkra na pre. Nẽ Matatis kêp Semeĩ hkra na pre. Nẽ Semeĩ kêp Juje hõ hkra na pre. Nẽ Juje kêp Jotre hkra na pre. ");
INSERT INTO apnNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Nẽ Jotre kêp Joanãn kra na pre. Nẽ Joanãn kêp Rej kra na pre. Nẽ Rej kêp Joropape hkra na pre. Nẽ Joropape kêp Saraxi kra na pre. Nẽ Saraxi kêp Neri hkra na pre. ");
INSERT INTO apnNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Nẽ Neri kêp axtem Mewki hõ hkra na pre. Nẽ Mewki kêp Axi hkra na pre. Nẽ Axi kêp Kojã hkra na pre. Nẽ Kojã kêp Ematã hkra na pre. Nẽ Ematã kêp Erti hkra na pre. ");
INSERT INTO apnNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Nẽ Erti kêp Jojue hkra na pre. Nẽ Jojue kêp Eries kra na pre. Nẽ Eries kêp Jorĩ hkra na pre. Nẽ Jorĩ kêp Matat hkra na pre. Nẽ Matat kêp axtem Rewi hõ hkra na pre. ");
INSERT INTO apnNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Nẽ Rewi kêp Simeãw kra na pre. Nẽ Simeãw kêp Juta hkra na pre. Nẽ Juta kêp axtem Juje hõ hkra na pre. Nẽ Juje kêp Janã hkra na pre. Nẽ Janã kêp Eriakĩ hkra na pre. ");
INSERT INTO apnNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Nẽ Eriakĩ kêp Merea hkra na pre. Nẽ Merea kêp Mena hkra na pre. Nẽ Mena kêp Matata hkra na pre. Nẽ Matata kêp Natã hkra na pre. Nẽ Natã kêp Tawi hkra na pre. ");
INSERT INTO apnNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Nẽ Tawi kêp Jese hkra na pre. Nẽ Jese kêp Opex kra na pre. Nẽ Opex kêp Poas kra na pre. Nẽ Poas kêp Sarã hkra na pre. Nẽ Sarã kêp Nasõ hkra na pre. ");
INSERT INTO apnNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nẽ Nasõ kêp Amĩnatap kra na pre. Nẽ Amĩnatap kêp Amĩ hkra na pre. Nẽ Amĩ kêp Ari hkra na pre. Nẽ Ari kêp Erõ hkra na pre. Nẽ Erõ kêp Pere hkra na pre. Nẽ Pere kêp Juta hkra na pre. ");
INSERT INTO apnNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Nẽ Juta kêp Jako hkra na pre. Nẽ Jako kêp Ijak kra na pre. Nẽ Ijak kêp Apraãw kra na pre. Nẽ Apraãw kêp Tera hkra na pre. Nẽ Tera kêp Nako hkra na pre. ");
INSERT INTO apnNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nẽ Nako kêp Jeruk kra na pre. Nẽ Jeruk kêp Rakau hkra na pre. Nẽ Rakau kêp Parek kra na pre. Nẽ Parek kêp Epti hkra na pre. Nẽ Epti kêp axtem Sara hõ hkra na pre. ");
INSERT INTO apnNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Nẽ Sara kêp Kajnã hkra na pre. Nẽ Kajnã kêp Apaxat kra na pre. Nẽ Apaxat kêp Sẽre hkra na pre. Nẽ Sẽre kêp Noehti hkra na pre. Nẽ Noehti kêp Ramek kra na pre. ");
INSERT INTO apnNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Nẽ Ramek kêp Metujarẽ hkra na pre. Nẽ Metujarẽ kêp Enok kra na pre. Nẽ Enok kêp Jarate hkra na pre. Nẽ Jarate kêp Marerer kra na pre. Nẽ Marerer kêp axtem Kajnã hõ hkra na pre. Nẽ Kajnã kêp Enos kra na pre. ");
INSERT INTO apnNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Nẽ Enos kêp Set kra na pre. Nẽ Set kêp Atãw kra na pre. Nẽ Atãw kêp Tĩrtũm kra na pre. Tĩrtũm kot wam my pê Atãwja pika ho hipêx jakamã te kêp hkra pyràk. Ã Jejus kukamã hpãmjê nhĩxi kot anhỹr. ");
INSERT INTO apnNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Tã nhũm Jejus pyhti pê Jotãw rũm akupỹm ma mõ. Hãmri nẽ Tĩrtũm Karõ nhỹ hã mẽmoj kutã amnhĩ to htỳx nẽ. Jakamã nhũm nhỹhỹm ma kapôt wỳr o mõ ");
INSERT INTO apnNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","nhũm Satanasti omu nẽ ma hwỳr tẽ nẽ ri hkôt pa. Kapôt ã ri hkôt hêx rom tanhmã kãm nẽ ho pa. Kot mar nẽ Tĩrtũm kapẽr nhĩrôp ãm prãm xàj ma hkôt tanhmã kãm kapẽr to ho pa. Hãmri nẽ hkôt pa o hã arĩgro pê 40 nhũm Jejus kormã apkur kêt o hã arĩgro pê 40 nẽ hapêx nhũm ra kãm prãm tỳx nẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Hãmri nhũm Satanasti kãm: —Kwa mãn ka ra amã prãm tỳx kumrẽx nà? Nom xep apê Tĩrtũm Kra jakamã mẽmoj tanhmã apê kute hkêt. Kwa kẽn nhĩkwỹ mũj mã anẽ kê amã pãwti hã amnhĩ jahkre ka aku nẽ tokyx ho amnhĩ xihtỳx. E kwa tokyx kãm anẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Hãmri nhũm kuma nẽ kãm: —Tk. Nà kot paj akapẽr mar xà hkôt tanhmã amnhĩ nhĩpêx to hkêt nẽ. Koja Tĩrtũm kãm inhmã mẽmoj nhõr prãm nẽ inhmã mẽmoj gõ pa arĩ kormã kukrẽ. Kapẽr ã kagà htũm kot ja jarẽnh kot: Na htem mẽ apkur xà pix kukwak ri htĩr nẽ pa hkêt nẽ. Na htem mããnẽn Tĩrtũm kapẽr mar xà hkôt tanhmã ri amnhĩ nhĩpêx to ho pa ho htĩr nẽ mex nẽ pa. Anẽ. Ã kapẽr ã kagà kot ja jarẽnh kot anhỹr jakamã kot paj amar xà hkôt ã ri amnhĩ nhĩpêx anhỹr kêt nẽ. Ãm kwarĩ ho kwarĩ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Nhũm pre ã Jejus Satanasti mã kapẽr anẽ nhũm tee ri kuma hãmri nẽ hpãnhã ma nhỹhỹm o mõ nẽ nhỹri kỳx pê mẽmoj prêêti nhĩmõk ã o xa. Hãmri nẽ kãm pika piitã ahkre ho xa. Nẽ kãm mẽ hikukrêx piitã ahkre. Kàxpore nẽ mẽmoj piitã nhũm kãm ahkre hpa nhũm anhĩpê omunh o xa. ");
INSERT INTO apnNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Hãmri nhũm Satanasti kãm: —E mãn ka kam ri mẽmoj mũj piitã omu. Piitã inhõ na. Inhmã na pre Tĩrtũm piitã õr pa. Kot paj inhmã mẽhõ mã õr prãm nẽ kãm kugõ. ");
INSERT INTO apnNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Tã amã kot paj kugõ. Jakamã e. Kwa tokyx ixkutã tẽm nẽ inhmã inhmex o inhmex ã ijarẽ pa ama nẽ rĩ amã piitã õr pa. E tokyx. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Hãmri nhũm kuma nẽ kãm: —Tk. Kot paj amã amex o amex ã ajarẽnh kêt kumrẽx. Ãm kwarĩ ho kwarĩ. Amexti hã. Tĩrtũm kapẽr ã kagà htũm kot ja nê kapẽr kãm hihtỳx kênã. Kapẽr kot: Kêr ka mẽ ixkapẽr pix ma. Nẽ ixkutã pix mã mãn akõnkrã ho akrĩ nẽ inhmã inhmex o inhmex ã ijarẽnh o ri apa. Kêr ka mẽ ã amnhĩ nhĩpêx anhỹr o ri apa. Anhỹr o kot harẽnh jakamã kot paj ri amã amex o amex ã ajarẽnh kêt nẽ Satanasti. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Nhũm pre ã Jejus amnhĩ nê kãm kapẽr anẽ. Hãmri nhũm tee ri kuma nẽ hpãnhã ma krĩ pê Jerujarẽ hwỳr o mõ. Nẽ mẽ kot Tĩrtũm mã amnhĩ jarẽnh xà hã ixkre hprêk nhĩmõk wỳr ho api nẽ kỳxpê hatur xà hã ãm nhũm xa. Nhũm amnhĩ parpê kẽn rũnh nhĩkwỹ pumunh o xa. Hãmri nhũm Satanasti kãm: —E apê Tĩrtũm Kra jakamã kwa ja rũm ahpar mã ajarĩ nẽ ma tẽ nẽ pikap tẽm. Koja Anhĩpêêxà apumunh mex nẽ ka tanhmã amnhĩ to hkêt nẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","11","Kapẽr ã kagà htũm kot ja jarẽnh kot: Tĩrtũm koja kapẽr o wrỳk xwỳnh mã ajarẽ ka ajarĩ nẽ ahpar mã tẽ nhũm mẽ kỳx pê amỳ nhũm mẽmoj akà hyr kêt nẽ. Ã kapẽr ã kagà kamã ajarẽnh kot anhỹr jakamã e tokyx ajarĩ nẽ ma tẽn pikap ahto. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Hãmri nhũm kuma nẽ kê axte amnhĩ tã kãm kapẽr nẽ kãm: —Tk. Kwa nà. Kot pa ri amar xà hkôt ã amnhĩ nhĩpêx anhỹr kêt nẽ. Koja Tĩrtũm tãm inhmã ijarĩ hã karõ pa rĩ mar xà hkôt ijarĩ no kot pa ri amar xà hkôt ijarĩ hkêt nẽ. Tĩrtũm kapẽr ã kagà htũm kot ja jarẽnh kot: Kêr ka mẽ amnhĩ krã hkôt amnhĩ tã ixkamã ajamak kaxyw inhĩxi jarẽnh kôt tanhmã amnhĩ nhĩpêx to hkêt nẽ. Ã ja nê kapẽr kot anhỹr jakamã ãm kwarĩ ho kwarĩ. Kot paj ri amar xà hkôt ã amnhĩ nhĩpêx anhỹr kêt nẽ. Tãm kot inhmã ijarĩ hã karõre hã. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Nhũm pre ã Jejus Satanasti mã kapẽr anẽ hãmri nhũm tee ri mẽmoj piitã ho mar kaprỳ hãmri nẽ hkaga nẽ ma nhỹhỹm tẽ. Hãmri nẽ kot nhỹrmã axte hwỳr htẽm nẽ kot mẽmoj punuj o mar kaxyw kormã amnhĩm hamãr o ri pa. ");
INSERT INTO apnNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Tã nhũm Jejus ma akupỹm Garirej wỳr mõ. Nẽ Tĩrtũm Karõ nhỹ hã àhpumunh tỳx nẽ hkwỳjê mã kapẽr jarẽnh o ri pa. Nhũm mẽ kuma nẽ piitã pikaja kamã axpẽn mã tanhmã harẽnh to. ");
INSERT INTO apnNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Na pre hte mẽ kot Tĩrtũm kapẽr o mẽ ahkre xà hã ixkre hwỳr agjê nẽ kamã mẽ ahkre ho hkrĩ. Nhũm mẽ piitã kuma nẽ kãm mar prãm nẽ. Hãmri nẽ axpẽn mã mex ã harẽnh o ri pa. ");
INSERT INTO apnNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Tã nhũm Jejus ma akupỹm krĩ kamã àptàr xàja wỳr ma mõ. Najare hwỳr. Hãmri nẽ kamã pôj. Nhũm Ijaew nhõ arĩgromnu pê sap kato nhũm Jejus ma mẽ hkôt Tĩrtũm kapẽr o mẽ ahkre xà hã ixkre hwỳr tẽ. Hãmri nẽ hwỳr axà nẽ mẽ kuri nhỹ. Hãmri nẽ kamã mẽ kãm Tĩrtũm kapẽr ã kagà htũm kamã harẽnh kaxyw kànhmã xa ");
INSERT INTO apnNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","nhũm mẽ omu nẽ kãm ja gõ. Finat Ijais pê Tĩrtũm nhỹ hã kapẽr xwỳnh kot Tĩrtũm kapẽr kwỳ hã kagàja nhũm mẽ kãm kugõ. Hãmri nhũm kupy nẽ kamã kormã Tĩrtũm kot tanhmã mẽmoj jarẽnh to hõ japêr o xa. Nẽ kãm kato hãmri nẽ mẽ kãm kamã harẽ. Nom amnhĩ tã kamã mẽ kãm harẽnh o xa nẽ mẽ kãm: ");
INSERT INTO apnNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Na pre ra Tĩrtũm Karõja ixto ixàhpumunh tỳx nẽ mẽ kêp amrakati xwỳnhjê hwỳr inhmẽ pa ra mõ. Ixte mẽ kãm mẽmoj mex jarẽnh o ixpa kaxyw. Nẽ Satanasti kot amnhĩ kôt mẽ unhwỳr xwỳnhjê hwỳr nhũm pre mããnẽn inhmẽ. Ixte mẽ nê Satanasti japôx o ixpa kaxyw. Nẽ mẽ kot hprĩ hã Tĩrtũm kapẽr mar kêt xwỳnhjê hwỳr nhũm pre mããnẽn inhmẽ. Ixprĩ hã ixte mẽ kãm kapẽr jarẽnh o ri mẽ hkôt ixpa kaxyw. Nẽ mẽ kot amnhĩ tomnuj o mẽ pa xwỳnhjê hwỳr nhũm pre mããnẽn inhmẽ. Ixte mẽ nê mẽ kot amnhĩ tomnuj rênh pa nhũm mẽ hamakêtkati nẽ àmnhĩx ri pa kaxyw. Ã na pre Tĩrtũm jajê piitã hwỳr inhmẽnh anẽ pa ra man mõn pôj. ");
INSERT INTO apnNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Nẽ amgrà ja kêp Tĩrtũm kot mẽ ato mex xà hã amgràja nhũm ixte mẽ amã harẽnh o ixpa kaxyw na pre inhmẽ pa mõn pôj. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Nhũm pre ã Jejus Tĩrtũm kapẽr ã kagà htũm kamã mẽ kãm amnhĩ jarẽnh anẽ. Hãmri nẽ akupỹm mẽ kãm kagàja gõ nẽ ho mẽ ahkre kaxyw akupỹm nhỹ nhũm mẽ piitã omunh pê mar o hkrĩ. ");
INSERT INTO apnNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Hãmri nhũm mẽ kãm tanhmã amnhĩ jarẽnh to nẽ mẽ kãm: —E ra Ijais kot ã ixkukamã ijarẽnh anhỹr xà hkôt na pa mẽ awỳr wrỳ nẽ mẽ anoo mã ã amnhĩ nhĩpêx anhỹr o hkrax. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Hãmri nhũm mẽ amnhĩ jaêr pê ã kot amnhĩ jarẽnh anhỹr ã kuma. Nẽ tee ri kuma nẽ axpẽn pumunh pê hamaxpẽr o hkrĩ. Jejus mẽ kurom àhpumunh tỳx nẽ kapẽr mex tã nhũm mẽ ãm kêp amnhĩ kwỳ pix ã hkamnhĩx kãm hihtỳx nẽ. Hãmri nẽ axpẽn mã: —Tk. Kwa kêp Juje hkra pix kênã koja we ri ã amnhĩ jarẽnh anẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Hãmri nhũm amnhĩ tã mẽ kuma nẽ mẽ kãm: —Nà na ka mẽ ixte amnhĩ jarẽnh ma nom ixkôt ajamaxpẽr kêt nẽ. Jakamã axpẽn mã ijarẽnh o: “Tk. Kêp mẽ pahkaprĩ xwỳnh ro nhỹx jar mẽ panhõ krĩ kamã aa mẽ pahte mẽmoj pumunh kêt kwỳ tanhmã mẽ pamã hipêx to pu mẽ hã omu. Te ra kot krĩ pê Kapanaũ kamã mẽ kãm mẽmoj kwỳ ho anhỹrta pyràk. Pu mẽ omu nẽ hkôt pajamaxpẽr kurê kumrẽx.” Anhỹr o ri axpẽn mã ijarẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Koja nhãm krĩ hõ kamã mẽhõ kêp Tĩrtũm kapẽr jarẽnh xwỳnh ã amnhĩ jarẽ ka mẽ harẽnh ma nẽ amã ma hwỳr amrar nẽ mar prãm nẽ. No kêt jar mẽ panhõ krĩ kamã ixpê mẽ anhĩõ hã ã amnhĩ jarẽnh anẽ ka mẽ amã inhmar prãm kêt nẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","—Kwa mẽ inhma. Amnepêm kormã finat Eris htĩr ri na pre mẽ hã na wrỳk kêt ry rax nẽ. Jao hã amgrà axkrunẽpxi nẽ hkôt mytwrỳ pê 6. Nhũm mẽ õ hkêt nẽ pa. Ra mẽ kêp mẽmoj grà pa nẽ hapêx nhũm mẽ kãm prãm tỳx kumrẽx nẽ pa. Nhũm mẽ kêp mẽ mjên tyk xwỳnhjaja kãm prãm xàj hirot o pa. ");
INSERT INTO apnNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Tã nom Tĩrtũm mẽ ho mex kaxyw mẽ hwỳr Eris mẽnh kêt nẽ. Erisja mẽ uràk nẽ kêp Ijaew tã nhũm Tĩrtũm kot mẽ ho ajuta kaxyw mẽ hwỳr mẽnh kêt nẽ. Mẽ kot amnhĩ kaxyw Tĩrtũm kôt hamaxpẽr kêt jakamã nhũm mẽ hwỳr mẽnh kêt nẽ. Axtem Ijaew kêt xwỳnhjê hõ hwỳr na pre kumẽ. Nhãm Sitõ kamã krĩ pê Sarep kamã mjên htyk xwỳnhta wỳr. Tokyx kot tanhmã ho mex to kaxyw. Jakamã nhũm ma hwỳr mõ nẽ tanhmã kãm kapẽr to nhũm kuma nẽ amnhĩ kaxyw Tĩrtũm kôt hamaxpẽr kurê kumrẽx. ");
INSERT INTO apnNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","—Nẽ finat Eriasti haxwỳja. Eris pyrà nẽ kêp Tĩrtũm nhỹ hã kapẽr o pa xwỳnh tã amnhĩ kwỳ pê Ijaew tanhmã mẽ ho ajuta hto hkêt nẽ. Na prem ohtô nẽ hkà nhy nẽ hkro xàpêr o pa. Jao ra omnuj tỳx nẽ. Tã nhũm Tĩrtũm kot akupỹm mẽ ho mex kaxyw mẽ hwỳr Eriasti mẽnh kêt nẽ. Amnhĩ kaxyw mẽ kot hkôt hamaxpẽẽre hã. Ãm Sir nhõ xwỳnh Namãja pix na pre Tĩrtũm Eriasti mã anẽ nhũm akupỹm ho mex. Kêp Ijaew kêt tã nhũm akupỹm ho mex. Tã ja pyrà nẽ na pa ãm mẽ kot amnhĩ kaxyw ixkôt hamaxpẽr pix xwỳnhjê mã tanhmã amnhĩ nhĩpêx to ho ri ixpa. No mẽ ate amnhĩ kaxyw ixkôt ajamaxpẽr kêt xwỳnhjê mã tanhmã ri amnhĩ nhĩpêx to hkêt nẽ. Anẽ. Nhũm pre ã Jejus mẽ kãm amnhĩ jarẽnh anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Hãmri nhũm mẽ kuma nẽ kamã gryk tỳx nẽ axpẽn mã hã amỹnê nẽ axpẽn mã: —Tk. Kwa pu mẽ ixkre nê kator nẽ ma o tẽ nẽ kupĩ ri. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Hãmri nẽ kaxyw kànhmã kuhê hpa nẽ hwỳr hprõt nẽ unê. Mẽ kot ma o htẽm nẽ hixêt prêk jatur xà hã hkujaêk nhũm ahpar mã tẽn htẽm nẽ htyk kaxyw. Mẽ õ krĩja hixêt prêk nhĩmõk ã na pre. Jakamã nhũm prem unê nẽ hatur xàta wỳr o tẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Tã nom nhũm tanhmã amnhĩ nhĩpêx to nẽ mẽ kêp akunok nẽ hpãnhã nhãm ma tẽ nhũm mẽ tee ri hapêr nom nhỹri omunh kêt nẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Tã nhũm Jejus ma akupỹm Garirej kamã krĩ pê Kapanaũ hwỳr mõ. Nhũm mẽ õ arĩgromnu pê sap kato nhũm ma mẽ kot Tĩrtũm kapẽr o mẽ ahkre xà hã ixkre hwỳr tẽ nẽ mẽ ahkre ho nhỹ. ");
INSERT INTO apnNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Hãmri nhũm mẽ kot mar o hkrĩ xwỳnhjaja kuma nẽ kãm mar prãm nẽ. Nẽ axpẽn mã: —Hêxta waa nẽ. Ãm hãmri na ã mẽ pamã kapẽr anẽ. Àhpumunh tỳx xà hkôt na hte ãm hãmri mẽ pamã awjarẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Nhũm mẽhõ myja mẽ ĩhkô hã haxwỳja mar o nhỹ. Mẽkarõmnuti na pre ra hwỳr axà nhũm ỹ hã tanhmã amnhĩ tomnuj to ho pa. Hãmri nẽ mẽ ĩhkô hã Jejus mar o nhỹ nẽ ra àmra kamã tanhmã kãm kapẽr to. Nom nhũm tãm kãm kapẽr kêt ãm kamã mẽkarõmnutija kãm kapẽr. ");
INSERT INTO apnNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","Nẽ kãm: —Pa? Jejus pê Najare nhõ xwỳnh? Nà ate mẽ ixto ajapêx par kaxyw na ka mẽ ixwỳr mõ. Ra ixte apumunh mex kênã. Apê Tĩrtũm kot mẽ ixwỳr amẽnh xwỳnh maatita na ka. Jakamã kwa tanhmã kot kaj mẽ ixto? Mo kaxyw na ka pre mẽ ixwỳr mõ? Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Hãmri nhũm kuma nẽ mẽkarõmnuti kot kãm ã kapẽr anhỹr ã omunh kurê kumrẽx. Jakamã kutã kãm kapẽr nẽ kãm: —Tk. Kwa anhĩkrê nẽ kêp akato. Anẽ. Hãmri nhũm kuma nẽ myta o pika kura nẽ kêp kato nẽ ma tẽ. Ãm ho pika kuranh pix nhũm nõ. Hãmri nẽ akupỹm kànhmã nhỹ nẽ akupỹm mex. ");
INSERT INTO apnNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Hãmri nhũm mẽ piitã omu nẽ kamã no pyma nẽ. Hãmri nẽ axpẽn mã: —Kokỹỹ. Na hte Jejus amnhĩ krã hkôt àhpumunh tỳx xà hkôt mẽkarõmnuti mã kapẽr nẽ mẽ hano nhũm htem kuma nẽ mẽ kêp hapôx kurê kumrẽx. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Hãmri nhũm mẽ mẽõ pika kamã piitã ri axpẽn mã harẽnh o pa. ");
INSERT INTO apnNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Tã nhũm Jejus Tĩrtũm kapẽr o mẽ ahkre xàja rũm kato nẽ ma Simãw Pêtre nhõrkwỹ hwỳr tẽ. Nẽ mẽ hwỳr axà nhũm Simãw Pêtre omu nẽ kãm upãnhgêx tanhmã kute hã harẽ nẽ kãm: —Kwa Pahihti. Tẽ nẽ inhmã ixupãnhgêx pumu. Na hkà kagro htỳx nẽ amnhĩ to àpêr o nõ. Kwa tẽn inhmã omu. Anẽ. Hãmri nhũm kãm: —Tôe. Nà kot paj amã omu. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Hãmri nẽ hwỳr tẽn kuri xa nẽ kãm: —Pa? E kwa akà hakry. Anẽ. Hãmri nhũm kuma nẽ hkà hakry nẽ akupỹm hihtỳx kurê kumrẽx. Hãmri nẽ kànhmã nhỹ nẽ mẽ kãm mẽõ hã àpênh o ri mra. ");
INSERT INTO apnNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Tã nhũm ra amỹkry htỳx mẽ nhũm mẽ Jejus wỳr ahpỹnhã ri mẽ à xwỳnhjê ho mra. Nhũm amnhĩ wỳr mẽ omu hãmri nẽ mẽ piitã ri mẽ hã ĩhkra jaxwỳ nẽ akupỹm mẽ ho mex pa. ");
INSERT INTO apnNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Nhũm ra mẽkarõmnuti mẽ hkwỳjê hwỳr agjê nhũm mẽ kurũm mẽ hano nhũm mẽ tee ri amnhĩ tã omu nẽ mẽ kêp hapôx kurê kumrẽx. Hãmri nẽ mẽ kêp hapôx kaxyw nẽ àmra kamã kãm kapẽr nẽ kãm: —Kwa tanhmã kot pa wem amnhĩ nê ato? Hêxta waa nẽ. Apê Tĩrtũm Kra hã axàhpumunh tỳx kênã. Anhỹr o kãm kapẽr. Ãm hãmri na prem ã harẽnh anẽ. Kêp Tĩrtũm kot mẽ pakaxyw ãm xwỳnh kênã. No nhũm Ijaew nhõ pahijaja kot mẽ kapẽr mar nẽ kêp mẽkarõmnuti hkwỳ hã hkamnhĩx pymaj nhũm Jejus amnhĩ nê mẽ kãm kapẽr nẽ mẽ kãm: —Kwa mẽ ri ã ijarẽnh anhỹr kêt nẽ. Anhỹr o mẽ kãm kapẽr hãmri nẽ mẽ hano nhũm mẽ hapôj nẽ ma mra. ");
INSERT INTO apnNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Tã nhũm apkati nẽ myt kator grire nhũm Jejus kot Tĩrtũm mã amnhĩ jarẽnh kaxyw kànhmã nhỹ nẽ kato nẽ ma nhỹhỹm kapôt mã tẽ. Hãmri nhũm krĩ nhõ xwỳnhjaja hkrã hapôj nẽ tee ri hapêr nẽ ma hkôt hpry jakop o mõ. Nẽ nhỹri hwỳr kato nẽ omu hãmri nẽ ma nhỹhỹm mõr nê kurê nẽ kãm: —Kwa Jejus. Kêr ka tokyx ma nhỹhỹm amõr kêt nẽ. Kritpêm mẽ ixkôt axkamẽ mãn. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Hãmri nhũm mẽ kuma nẽ amnhĩ tã mẽ kãm: —Nà kot paj kritpêm mẽ akôt ixpikamẽnh kêt nẽ. Kot paj ma krĩ piitã hkôt ri Tĩrtũm kapẽr o mẽ ahkre ho ri mẽ hkôt ixpa. Tĩrtũm kot tanhmã mẽ ho hkra hto hã harẽnhja kot paj mẽ hkôt ri mẽ kãm harẽnh o ri ixpa. Ja kaxyw na pre Tĩrtũm mẽ awỳr inhmẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Nhũm pre ã mẽ kãm amnhĩ jarẽnh anẽ. Hãmri nẽ mẽ kêp kato nẽ ma Ijaew nhõ pika piitã hkôt Tĩrtũm kapẽr o mẽ ahkre ho ri pa. Ijaew nhõ Tĩrtũm kapẽr o mẽ ahkre xà hã ixkre kamã mẽ piitã ho mẽ ahkre ho ri pa. ");
INSERT INTO apnNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Tã nhũm Jejus ma gô rax pê Jenẽjare hwỳr mõ. Hãmri nẽ hwỳr pôj nẽ gô mỳri Tĩrtũm kapẽr o mẽ ahkre ho xa nhũm mẽ ohtô nẽ pu hã mar o kuhê. Nẽ kot hprĩ hã mar nẽ hkôt omunh kaxyw hã axpẽn nhĩgãnh o kuhê. ");
INSERT INTO apnNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Hãmri nhũm tee ri amnhĩ tã mẽ omu nẽ amnhĩ pu hã hakẽx nẽ rĩt nẽ gôx kãm pàr kaprỳ hamẽxkrut nẽ jêtja wa omu. Nhũm õ dõn wa gôx kãm kryhti kuhõnh o xa. Nhũm pàr hamẽ hkaprỳ nẽ ajêt nhũm Jejus omu. ");
INSERT INTO apnNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Hãmri nẽ hwỳr tẽ nẽ hõm axà nẽ õ dõn pê Simãwja mã anẽ nhũm hkôt axà nẽ kii mẽ kêp pàrja amỳm kunhô nhũm ajêt. Hãmri nhũm pàr kre rũm amỳm mẽ ahkre ho nhỹ nhũm mẽ piitã omu nẽ mar mex o kuhê. ");
INSERT INTO apnNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Tã nhũm mẽ ahkre hpa nẽ Simãw mã kãm: —E gô xupỳm wỳr anhõ pàr o axkamẽ nẽ axte anhõ kryhti mẽ nẽ ho amnhĩm tep kwỳmnê. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Hãmri nhũm tee ri kuma nẽ kãm: —Kwa na pa mẽ ra kamàt kãm tee rẽnh o apkati nẽ ho hõmnênh kêt tã ka ri inhmã anẽ. Nom kot paj amar xà hkôt kop kumẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Hãmri nẽ upỳm wỳr pàr o axkamẽ nẽ htõ Andre mẽ wa axte kryhti mẽ. Nẽ ãm mẽnh tipxi htã ho tep pynênh rax kumrẽx. Jakamã nhũm kryhtija ra pikaxônh kaxyw. ");
INSERT INTO apnNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Hãmri nhũm wa tee ri ho anẽ nẽ amnhĩ wỳr pàr õ ho mrar xwỳnhta wa kãm akir. Jepetew kra Juãw mẽ Xiakreja wa nhũm wa amnhĩ wỳr wa kãm akir nhũm wa hwỳr pàr õ ho tẽ hãmri nẽ mẽ kryhti hã hije nẽ pàr wỳr ho api. Hãmri nẽ pàrta hamẽ tep o ho nỳt pa nẽ hamẽ ho hipu mex nẽ. Jao nhỹx gônh mã wa axà. ");
INSERT INTO apnNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","10","Hãmri nhũm mẽ amnhĩ jaêr pê tep xohtô raxta pumu nẽ kamã no pyma nẽ. Hãmri nhũm Simãwja Jejus kutã hkõn krã ho tẽm nẽ hipô nẽ nhỹ nẽ hã hpijaàm kamã kãm kapẽr nẽ kãm: —Kwa Pahihti. Kii tamũ axkamẽ. Akĩnhã ixte amnhĩ tomnuj tỳx xwỳnh na pa. Anẽ. Hãmri nhũm kuma nẽ ãm kuma nẽ kãm: —Kwa nà tee ri amnhĩ kukamã ajamaxpẽr kêt nẽ. Kot kaj jarãhã hpãnhã tãm amnhĩ nhĩpêx o apa. Na ka ra tep pynênh rũnh o apa. Tã kot kaj ja kaga nẽ hpãnhã ma ri mẽ hkôt Tĩrtũm kapẽr o mẽ ahkre ho ri apa. Koja mẽ ohtô nẽ ama nẽ Tĩrtũm kôt amnhĩ xunhwỳ nẽ hkôt amnhĩ nhĩpêx o pa. Jakamã kot kaj te ate tep pynênh rũnh nẽ Tĩrtũm mã õr pyràk o amnhĩ nhĩpêx o apa. Anẽ. Nhũm pre ã Jejus Simãw mã kapẽr anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Hãmri nhũm mẽ gô jakàx ã pàr janhôr tỳx nẽ kamã hikukrêx piitã hkaga hpa nẽ ma Jejus kôt pa ho pa. ");
INSERT INTO apnNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Tã nhũm Jejus ma krĩ hõ hwỳr mõ. Hãmri nhũm mẽhõ my hkà nhy hkro htỳx xwỳnhja omu nẽ hwỳr tẽ nẽ hã hpijaàm kaxyw kutã hkõnkrã ho nhỹ nẽ kãm: —Pa Pahihti. E ot pa awỳr amnhĩ to tẽ. Kwa akupỹm ate mẽ ixto mex kaxyw axàhpumunh tỳx jakamã kot ka akupỹm amã ixto mex prãm nẽ mãmrĩ akupỹm ixto mex. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Hãmri nhũm kuma nẽ hkà punuti hã ĩhkra xi. Amnhĩ kamã kahak kêt nẽ hã ĩhkra xi nẽ kãm: —Nà kot paj ato mex. E akupỹm akà mex kurê kumrẽx. Anhỹrja kôt hãmri nhũm hkàja akupỹm mex pa. ");
INSERT INTO apnNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Hãmri nhũm Jejus kãm: —E kêr ka amnhĩ tã akwỳjê mã tanhmã ijarẽnh to hkêt rãhã ma patre hwỳr tẽ kê akupỹm akà mex ã apumu. Hãmri ka amnepêm Mojes kot mẽ ate akupỹm amex ã Tĩrtũm mã tanhmã amnhĩ nhĩpêx to hã karõta ka kãm ho anẽ. Kê mẽ mẽ piitã akupỹm akà mex ã apumu. Anẽ. Hãmri nhũm kuma nẽ kãm: —Tôe. Nà kot paj anẽ. Anẽ. Hãmri nẽ ma hwỳr htẽm kurê kumrẽx. ");
INSERT INTO apnNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Hãmri nhũm mẽ piitã axpẽn mã Jejus jarẽnh o ri hprõt nhũm mẽ kot kapẽr mar kaxyw ma hwỳr mra. Nẽ mẽ à xwỳnhjaja nhũm kot mẽ ho mex kaxyw nhũm mẽ hwỳr amnhĩ to mra. ");
INSERT INTO apnNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Jakamã nhũm pre hte Jejus tõhã mẽ kêp hapôj nẽ ahte ma kapôt ã Tĩrtũm mã amnhĩ jarẽnh kaxyw mra. Nẽ kãm amnhĩ jarẽnh pa hãmri nẽ ma akupỹm mẽ hwỳr mra. ");
INSERT INTO apnNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Tã nhũm Jejus ma Tĩrtũm kapẽr o Ijaew jahkre ho pa. Jakamã nhỹri mẽhõ nhõrkwỹ kamã ho mẽ ahkre ho xa nhũm Parijew nhõ xwỳnhjê mẽ Tĩrtũm kapẽr tũm o mẽ ahkre ho mẽ pa xwỳnhjaja kot mar kaxyw ma hwỳr mra. Na pre ra Garirej rũm mẽ hkwỳjaja ma hwỳr mra. Nẽ pika pê Jutej rũm mẽ hkwỳ haxwỳja ma hwỳr mra. Nẽ krĩ pê Jerujarẽ rũm. Ã na prem ohtô nẽ krĩ piitã kurũm kot mar kaxyw hwỳr akuprõ nhũm mẽ ahkre anẽ. Nẽ Tĩrtũm kot ho àhpumunh tỳx jakamã nhũm ỹ hã akupỹm mẽ à xwỳnhjê ho mex. ");
INSERT INTO apnNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Hãmri nhũm hkwỳjaja ĩ kamã htyk xwỳnh mỳ nẽ Jejus wỳr o tẽ. Nõr xà kamã nõr rãhã nhũm mẽ hã hije nẽ hwỳr o tẽ. Hãmri nẽ tee ri kot hwỳr ho àr kaxyw ri mẽ hkupu ho pa. ");
INSERT INTO apnNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Nom nhũm mẽ ra ixkre ho nỳt rax jakamã nhũm mẽ tee ri amnhĩ kukamã ho ukapi ho ri pa. Hãmri nẽ ra hamaxpẽr nẽ ixkre nhĩmõk po hwỳr ho api nẽ ixkre nhĩmõk kwỳ grà nẽ hkôt ĩ kamã htyk xwỳnhta jaxà. Nõr xà kamã nõr rãhã Jejus wỳr haxà nẽ mẽ hipôk ri ho wrỳ nẽ kutã kuxi nhũm nõ. ");
INSERT INTO apnNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Hãmri nhũm Jejus amnhĩ tã mẽ kot kaxyw kãm hamaxpẽr tỳx ã mẽ omunh mex nẽ. Hãmri nẽ ĩ kamã htyk xwỳnhta mã kapẽr nẽ kãm: —Pa? E na pa ra anê tanhmã ate amnhĩ tomnuj to ho apaja o ijapêx pa. Kot paj axte kãm ijamaxpẽr kêt nẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Hãmri nhũm Parijew nhõ xwỳnhjê mẽ Tĩrtũm kapẽr tũm o mẽ ahkre ho mẽ pa xwỳnhjaja tee ri kot ã kãm kapẽr anhỹrja ã kuma nẽ axpẽn mã: —Tk. Kwa kêp Tĩrtũm kêt tã te ri kot amnhĩ nhĩpêx pyràk o ri mẽ nê mẽ kot amnhĩ tomnuj o hapêx ã amnhĩ jarẽnh o kuhê. Tĩrtũm pix na kot mẽ nê mẽ kot amnhĩ tomnuj o hapêx xwỳnh kênã. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Nhũm mẽ ã axpẽn mã Jejus jarẽnh anẽ nhũm amnhĩ tã mẽ kuma nẽ mẽ hamaxpẽr kôt mẽ omunh mex nẽ. Jakamã mẽ kãm: —Kwa mẽ ã ajamaxpẽr anhỹr kêt nẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Ixte mẽ nê mẽ kot amnhĩ tomnuj o ijapêx par ã amnhĩ jarẽnh tã mẽ ate ja kôt ixpumunh kêt jakamã na ka mẽ ixkôt ajamaxpẽr kêt nẽ. Nom kot paj mẽ anoo mã akupỹm ĩ kamã htyk xwỳnhta o mex ka mẽ apiitã ja hã ixpumu hãmri nẽ ixkôt ajamaxpẽr kurê kumrẽx. ");
INSERT INTO apnNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Ixpê Tĩrtũm kot mẽ awỳr inhmẽnh xwỳnhta na pa. Ixte mẽ anê mẽ ate amnhĩ tomnuj rênh kaxyw na pre mẽ awỳr inhmẽ pa mẽ awỳr wrỳ. Tã mẽ ate ja kôt ixpumunh kaxyw kot paj mẽ anoo mã myja o mex. Anẽ. Hãmri nẽ hpãnhã ĩ kamã htyk xwỳnhja mã kapẽr nẽ kãm: —E kànhmã xa nẽ anõr xà py nẽ ma akupỹm anhõrkwỹ hwỳr tẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Nhũm kànhmã ãm kurê kumrẽx. Hãmri nẽ amnhĩ pumu nẽ hkĩnh tỳx nẽ nõr xà py nẽ mẽ noo mã kato nẽ akupỹm õrkwỹ hwỳr ma Tĩrtũm mã mex o mex ã harẽnh o tẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Hãmri nhũm mẽ amnhĩ jaêr pê omu. Nẽ no hapôx kaxyw hkôt omunh o kuhê nẽ kamã no pyma nẽ. Nẽ tee ri omu hãmri nẽ axpẽn mã: —Kokỹỹ. Aa mẽ pahte ã mẽhõ kot amnhĩ nhĩpêx anhỹr ã omunh kêt tã na pu mẽ jarãhã ja pumu. Anẽ. Hãmri nẽ Tĩrtũm mã mex o mex ã harẽnh o kuhê. ");
INSERT INTO apnNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Tã nhũm Jejus ma hkôt mẽ pa ho mẽ pa xwỳnhjê mẽrohã ma nhỹhỹm mõ. Hãmri nẽ nhỹri Rewi pumu. Rewi nhĩxi hõ pê na Matêwre. Rõm kãm mẽ õ pahihti mã amnhĩ kwỳjê pê kàxpore hkwỳ jamỳnh xwỳnh na pre. Jakamã nhũm ujamỳnh xà hã ixkre kamã mẽ kêp hkwỳ jamỳnh o nhỹ nhũm Jejus mẽ hkôt mẽ pa o mẽ pa xwỳnhjaja hãnh mra. Hãmri nhũm Jejus àpênh ã omu nẽ amnhĩ kôt kuwỳ nẽ kãm: —Pa? E kwa axàpênhta kaga nẽ hpãnhã amnẽ mẽ ixkôt mãn tẽ. Nẽ ixkôt mãn ri apa ho apa. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Hãmri nhũm kuma nẽ àpênh kaga hpa nẽ ma hkôt mõ nẽ hkôt pa ho pa. ");
INSERT INTO apnNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Hãmri nhũm mẽmo arĩgro hã nhũm Rewi nhõ mẽ apkur xà hã mẽõ rax nẽ. Jakamã nhũm amnhĩ nhõrkwỹ hwỳr hkràmnhwỳjaja nẽ Jejus mẽ hkôt mẽ pa ho mẽ pa xwỳnhjê hwỳ. Mẽ kot kutã apkur kaxyw nhũm amnhĩ kôt mẽ kuwỳ nhũm mẽ ma hkôt mra nẽ õrkwỹ hwỳr agjê nẽ apkur o hkrĩ. Nẽ mẽ kêp Rõm nhõ pahi mã mẽ kêp kàxpore hkwỳ jamỳnh xwỳnh kwỳjaja nẽ mẽ ohtô nẽ hwỳr akuprõ nẽ axpẽn kutã apkur o hkrĩ. ");
INSERT INTO apnNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Hãmri nhũm Parijew nhõ xwỳnhjê mẽ Tĩrtũm kapẽr tũm o mẽ ahkre ho mẽ pa xwỳnh kwỳjaja mra nẽ mẽ apkur ã mẽ omu nẽ tee ri mẽ hkaêx ã Jejus pumu hãmri nẽ Jejus kôt mẽ pa ho mẽ pa xwỳnhjê hwỳr agjê nẽ hã mẽ kãm akir nẽ mẽ kãm: —Kwa mẽ kot amnhĩ tomnuj ho mẽ pa xwỳnhjê kutã mẽ apkur kêt tã ka mẽ apytàr xwỳnhja mẽ apimrààtã axtem nẽ mẽ kutã axàpkur o akrĩ. Kwa mẽ ate amnhĩ to mex ronhỹx ka mẽ kutã axàpkur kêt nẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Hãmri nhũm Jejus amnhĩ tã mẽ kapẽr ã mẽ kuma nẽ mẽ kãm: —Tk. Nà ixte tãm mẽ unhwỳr kaxyw na pa mẽ kutã ixàpkur o nhỹ. Xà na hte tôtôja mẽ mex xwỳnhjê hwỳr mra nẽ mẽ hkane? Nà ãm mẽ à xwỳnhjê pix wỳr na htem mra. Ra mẽ ate ja pumunh mex kênã. Ja pyrà nẽ na pa pre mẽ kot amnhĩ to mex xwỳnhjê hwỳr ixwrỳk kêt nẽ. Mẽ kot amnhĩ tomnuj xwỳnhjê pix wỳr na pa pre wrỳ. Ixte tãm mẽ unhwỳr kaxyw na pa pre mẽ hwỳr wrỳ nẽ ã jajê kutã ixàpkur o inhỹr anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","ãm mẽ kot amnhĩ tomnuj xwỳnhjê hwỳr na pa pre wrỳ nẽ mẽ kamã ixukaprĩ ho ri ixpa. Mẽ kot amnhĩ tomnuj mã urer nẽ hpãnhã tãm amnhĩ nhĩpêx o pa kaxyw na pa pre mẽ hwỳr wrỳ. Tã ka mẽ atỳx ã ri mẽ ixto akapẽr anẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Tã nhũm Ijaew kwỳjaja Jejus wỳr mra nẽ kãm: —Pa? E ot pa mẽ awỳr mra. Kwa aprĩ hã mẽ inhmã mẽmoj jarẽ. Na hte Parijew nhõ xwỳnhjê mẽ Juãw kôt mẽ pa xwỳnhjaja tõhã Tĩrtũm mã amnhĩ jarẽnh kaxyw nẽ apkur kêt rãhã kãm amnhĩ jarẽ. No akôt mẽ pa ho mẽ pa xwỳnhjaja na htem àmnhĩx apkur o pa kamã kãm amnhĩ jarẽ. Kwa mo na htem mẽ uràk nẽ tõhã apkur kêt ri kãm amnhĩ jarẽnh hkêt nẽ? Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Hãmri nhũm mẽ kuma nẽ mẽ kãm: —Tk. Nà mo kaxyw koja mẽ apkur kêt rãhã kãm amnhĩ jarẽ? Mẽ hkaprĩ hkêt kênã. Mẽ kot ixkôt pa ho pa hã amnhĩ pumunh jakamã hkĩnh nẽ pa. Kormã ixte mẽ kamã ixpa kênã kot kêt mẽ Tĩrtũm mã amnhĩ jarẽnh kaxyw nẽ apkur kêt rãhã kãm amnhĩ jarẽ. Xà na htem hkràmnhwỳ hã hkĩnh kaxyw hã akuprõ nẽ hkaprĩ nẽ apkur kêt nẽ mỳr o hkrĩ? Na htem hã akuprõ nẽ hkĩnh nẽ hã apkur rũnh nẽ. Ja pyrà nẽ na hte ixkôt mẽ pa ho mẽ pa xwỳnhjaja ixkôt kormã àmnhĩx ri hkĩnh nẽ apkati mẽ apkur o pa. ");
INSERT INTO apnNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Nom koja mẽ kãm ixkurê xwỳnhjaja nhỹrmã tanhmã ixto hãmri nhũm mẽ rĩ kormã ixtã hkaprĩ htỳx kãm apkur kêt ri tanhmã amnhĩ nhĩpêx to. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Nhũm pre ã Jejus mẽ kãm hkôt ri mẽ pa ho mẽ pa xwỳnhjê jarẽnh anẽ hãmri nẽ mẽ kãm: —Nà mẽ kot amnhĩ tomnuj xwỳnhjaja mẽ kot amnhĩ nhĩpêx tũm o amnhĩ pyràk jakamã na htem mẽ kot amnhĩ nhĩpêx nyw kaga. ");
INSERT INTO apnNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","39","Ixte amnhĩ nhĩpêx nywja te kot mẽ ate amnhĩ nhĩpêx tũm pyràk kêt jakamã ka htem inhma nẽ ãm inhma. Kwa mẽ ixkapẽr ma nẽ mẽ ate amnhĩ nhĩpêx tũm gryk ã ixkaga hkêt nẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Tã nhũm Ijaew nhõ arĩgromnu pê sapja axte kato. Hãmri nhũm Jejus mẽ hkôt ri mẽ pa ho mẽ pa xwỳnhjê mẽ ma mẽ hpur kôt ri nhỹhỹm ri pa. Hãmri nhũm hkôt mẽ pa ho mẽ pa xwỳnhjaja ra kãm prãm nẽ mra hãmri nẽ prãm xàj mẽmo hy te kot harôj pyràk xwỳnhta kwỳ rê nẽ kugrà nẽ ma Jejus kôt hkanhar o mõ. Ijaew kot amnhĩ nhĩpêx xà hkôt. ");
INSERT INTO apnNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Hãmri nhũm Parijew nhõ xwỳnhjaja kãm mẽmoj tã Jejus o kapẽr prãm jakamã ã mẽ kot amnhĩ nhĩpêx anhỹr ã mẽ omu nẽ mẽ hã Jejus kukjêr kurê kumrẽx nẽ kãm: —Kwa Tĩrtũm kapẽr tũm kot mẽ panhõ arĩgromnu hã mẽ pahte mẽ pahpur kãm mẽmoj nhĩkẽnh nê mẽ pahkurê htã nhũm ri akôt mẽ pa ho mẽ pa xwỳnhjaja axtem nẽ mẽmo hyta kwỳ rê nẽ akôt hkanhar o mõ. Kwa mẽ kãm anẽ kê mẽ ã amnhĩ nhĩpêx anhỹr kêt nẽ. Na htem arĩgromnu hã ã amnhĩ nhĩpêx anhỹr kêt nẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","4","Hãmri nhũm Jejus mẽ kuma nẽ hprĩ hã mẽ kãm Tĩrtũm kapẽr tũm jarẽ nẽ mẽ kãm: —Kwa xà na ka mẽ Tĩrtũm kapẽr ã kagà htũm kamã pahi Tawi kot tanhmã amnhĩ nhĩpêx tota kamã harẽnh nẽ mar kêt nẽ? Na pre Tawija hkôt ri mẽ pa xwỳnhjê mẽ nhũm mẽ prãm xàj Tĩrtũm mã amnhĩ jarẽnh xà hã ixkre wỳr agjê nhũm patre maatija mẽ kãm prãm tỳx ã mẽ omu nẽ mẽ kãm mẽmoj gõ. Mẽ kot Tĩrtũm noo mã pãwti jaxwỳr xwỳnhta nhũm mẽ kãm kugõ nhũm mẽ kuku. Tĩrtũm kapẽr ã kagà htũm kot ja nê mẽ kurê htã nhũm mẽ kãm prãm tỳx ã mẽ omu nẽ mẽ kamã ukaprĩ xàj mẽ kãm kugõ. Patre pix kot ja kur kaxyw tã nhũm mẽ kãm kugõ nhũm mẽ kuku. Tã nhũm Tĩrtũm ja hã mẽ omu nhũm ja kêp omnuj kêt nẽ. Kot mẽ kamã ukaprĩ nẽ mẽ kãm õr nhũm mẽ hã omu nhũm ja kãm mex nẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Tã pa na pre Tĩrtũm mẽ akaxyw ixãm nẽ mẽ awỳr inhmẽnh jakamã papxipix na pa hte arĩgromnu hã tanhmã mẽ kot amnhĩ nhĩpêx to hã mẽ kãm karõ ho ri ixpa. Ixpê arĩgromnu hpãm na pa. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Tã nhũm Ijaew nhõ arĩgromnu pê sapja axte kato. Hãmri nhũm Jejus Tĩrtũm kapẽr o mẽ ahkre xà hã ixkre hwỳr tẽ nẽ axà nẽ Tĩrtũm kapẽr o mẽ ahkre ho nhỹ. Nhũm mẽhõ myja upôk rũm ĩhkra grà xwỳnhja mẽ ĩhkô hã mar o nhỹ. ");
INSERT INTO apnNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Nhũm Parijew nhõ xwỳnhjê mẽ Tĩrtũm kapẽr tũm o mẽ ahkre ho mẽ pa xwỳnhjaja mẽ kãm mẽ hkrãhtũmjê mã Jejus o kapẽr prãm xàj htãnopxar o kuhê. Nẽ ĩhkra grà xwỳnhta pumu nẽ hã axpẽn mã: —Kwa pu mẽ jar pakuhê nẽ Jejus tanhmã kot amnhĩ nhĩpêx to hã omu. Xà koja jarãhã mũjti ho mex nà? Jarãhã arĩgromnu kênã kot kêt kãm ĩhkra ho mex. Koja anẽ nẽ Tĩrtũm kapẽr kwỳm ri amnhĩ nhĩpêx. E pu mẽ kop pakuhê nẽ hã omu. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Nhũm Jejus ra kot mẽ hamaxpẽr kôt mẽ omunh mex jakamã amnhĩ wỳr myta mã hpa ho apê nẽ kãm: —Pa? E kànhmã xa nẽ amnẽ ixwỳr tẽ. Anẽ. Hãmri nhũm kuma nẽ kànhmã xa nẽ hwỳr tẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Hãmri nhũm Jejus amnhĩ pu hã ri mẽ ho hakẽx nẽ mẽ kot mar o hkrĩ xwỳnhjê pumu nẽ mẽ kãm: —E mẽ inhmã mẽmoj jarẽ. Tanhmã na htem arĩgromnu hã axpẽn nhĩpêx to ho pa wehe? Xà kot ka arĩgromnu hã axà htỳx nẽ nõ hãmri nẽ amnhĩ mex prãm xàj ma mẽhõ hwỳr amnhĩ to tẽ. Hãmri nhũm ãm apumu nẽ apkatim arĩgro mex jamãr pê akane hkêt ka ty nhũm ja amã mex nẽ nà? Rỳ nhũm tanhmã atomnuj to nẽ akupỹm amnhĩ nê ajano nhũm ja amã mex nẽ nà? Nà koja ã anhĩpêx anẽ nhũm ja amã mex kêt nẽ. Na ka htem ã amnhĩ nhĩpêx anhỹr o apa hkêt nẽ. E mẽ inhmã mẽmoj jarẽ. Tanhmã na pre finat Mojesja Tĩrtũm nhỹ hã mẽ pamã arĩgromnu hã mẽ pahte axpẽn nhĩpêx ã karõ hto? Xà kot puj mẽ axpẽn kãm paxukaprĩ ho papa nà? Kot puj mẽ pamã axpẽn kurê ho papa? Xà kot puj mẽ hã mẽmoj punuj pê axpẽn pytà nà? Xà kot puj mẽ hã axpẽn pytàr pymaj arĩgro mex jamã? E mẽ atõ inhmã ja jarẽ. Anẽ. Nhũm pre ã mẽ hkukjêr anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Mẽ hamaxpẽr ã mẽ omunh mex pê ã mẽ hkukjêr anhỹr o xa. Nom nhũm arĩ mẽhõ tanhmã kutã kãm nẽ hkêt nẽ. Ãm akryk mar pê omunh o hkrĩ. Mẽ kot tanhmã kãm nẽ nhũm ta pãnhã tanhmã kot mẽ kãm nẽ pymaj nhũm mẽ tee ri kãm tanhmã nẽ hprãm nom akryk mar o hkrĩ. Hãmri nhũm Jejus tee ri mẽ omu hãmri nẽ myta mã kãm: —Tk. Mẽ kot tanhmã inhmã kapẽr tore hã. E anhĩhkra katàt. Anẽ. Hãmri nhũm ĩhkra katàt nẽ akupỹm mex kurê kumrẽx. ");
INSERT INTO apnNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Hãmri nhũm mẽ kãm Jejus kurê xwỳnhjaja tee ri ja hã omu nẽ kamã gryk tỳx nẽ. Arĩgromnu hã kot ho mex jakamã nhũm mẽ kamã gryk tỳx nẽ. Nẽ hã axpẽn kukjêr o kuhê nẽ axpẽn mã: —Kwa ã kot amnhĩ nhĩpêx anhỹr mỳrapê tanhmã kot puj wem ho? Na ã kapẽr anhỹrja o tanhmã mẽ pahto kapẽr punuj to. Te mẽ papamjaja mẽ pahte hkĩnhã pahkwỳjê kamã paxukaprĩ hkêt pyràk ã mẽ pajarẽ. Koja mẽ pahkwỳjaja kuma hãmri nẽ mẽ pahte amnhĩ nhĩpêx kaga nẽ amnhĩ kaxyw ãm hkôt pix mã hamaxpẽr o pa. Jakamã kwa tanhmã kot puj mẽ ja nê ho? Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Tã nhũm arĩgro hõ hã nhũm Jejus ma kot Tĩrtũm mã amnhĩ jarẽnh kaxyw ma hixêt prêk wỳr tẽ nẽ hã api. Hãmri nẽ kãm amnhĩ jarẽnh o apkati. ");
INSERT INTO apnNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Tã nhũm kwỳhtã nhũm amnhĩ kôt kot ri mẽ o pa xwỳnhjê hwỳ nẽ amnhĩ kaxyw mẽ ho 12 nẽ mẽ kurê. Nẽ mẽ kãm: —E mẽ kajaja kot paj ma mẽ pahkwỳjê hwỳr mẽ arẽ ka mẽ ma inhỹ hã Tĩrtũm kapẽr o mẽ ahkre ho ri mẽ hkôt apa. Kot kaj mẽ apê inhỹ hã mẽ ahkre ho apa xwỳnh. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Kot amnhĩ kaxyw mẽ rênh xwỳnhjê nhĩxi na jajaja: Simãw kumrẽx na pre kuta nẽ axte hã hixi mẽ nhũm kêp Pêtre. Nẽ Simãw Pêtre hkôt htõ Andreja ta. Nẽ hkôt Xiakre hta. Nẽ hkôt Juãw ta. Nẽ hkôt Firiptija ta. Nẽ hkôt Patoromew ta. ");
INSERT INTO apnNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Nẽ hkôt Matêwreja ta. Nẽ hkôt Tomasja ta. Nẽ hkôt Apew kra axtem Xiakre hõja ta. Nẽ hkôt Simãw Jeroxja ta. ");
INSERT INTO apnNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Nẽ hkôt Xiakre hõ hkra Jutja ta. Nẽ hkôt Jut Kariot ta. Jut Kariotja na pre kormã kot mẽ kãm Jejus kurê xwỳnhjê nhĩhkram õr mã. Nhũm kot amnhĩ kukamã omunh mex tã mẽ hkôt amnhĩ kaxyw kuta. Ã mẽ kot Jejus nhỹ hã mẽ ahkre o pa kaxyw mẽ rênh xwỳnhjê nhĩxi kot anhỹr. ");
INSERT INTO apnNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Tã nhũm Jejus akupỹm ỹ hã mẽ ahkre ho pa xwỳnhjê mẽ hãmri hixêt prêêta kurũm wrỳ nẽ nhỹri hinur kãm kuhê. Hãmri nhũm nhỹhỹnh mẽ kot mar mã xwỳnhjaja hã akuprõ. Kôt mẽ pa ho mẽ pa xwỳnh kwỳjaja nẽ nhỹhỹnh krĩ hkwỳ rũm mẽ hkwỳjaja. Pika pê Jutej kurũm mẽ hkwỳjaja. Nẽ krĩ pê Jerujarẽ kurũm mẽ hkwỳjaja. Nẽ gô mỳ ri Xir mẽ Sitõja wa kamã mẽ pa xwỳnh kwỳjaja. Ãm ahpỹnhã ri nhỹhỹnh krĩ hkwỳ rũm mẽ kot mar mã xwỳnhjaja hã pikuprõnh rax nẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","19","Mẽ kot kapẽr mar nhũm kot akupỹm mẽ ho mex kaxyw nhũm prem ma hwỳr amnhĩ to pa. Mẽ hkwỳjaja tanhmã ri à kute. Nhũm mẽ hkwỳjaja mẽkarõmnuti kot mẽ hwỳr gjêx xwỳnhjaja nhũm mẽ piitã ma hwỳr amnhĩ to pa. Na prem ra amnhĩ kaxyw kãm hamaxpẽr o: —E pa ma hwỳr tẽ nẽ ãm hkupênh pix tã akupỹm inhmex japêr. Anẽ. Hãmri nẽ ma hwỳr mra nhũm mẽ omu nẽ Tĩrtũm xàhpumunh tỳx o akupỹm mẽ ho mex pa. ");
INSERT INTO apnNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Tã nhũm Jejus hkôt mẽ pa ho mẽ pa xwỳnhjê jahkre nẽ mẽ kãm: E kot kaj mẽ atõ amnhĩ kaxyw tanhmã inhmã ajamaxpẽr to nẽ ajamaxpẽr o: “Nà ixkukrêx rax kêt tã na hte Tĩrtũm ixkôt pa ho pa. Koja ixkôt pa hkêt pa ixtỳx ri tanhmã amnhĩ nhĩpêx to ho ri ixpa rãhã nẽ. Tĩrtũmja mex kumrẽx o kot mẽ hikukrêx raxta jakrenh par.” Anhỹr o ajamaxpẽr. Hãmri nhũm Tĩrtũm ã ajamaxpẽr anhỹr ã apumu nhũm ja kãm mex nẽ. Hãmri nhũm apê hkra hã ato mex nẽ atãnopxar o akôt pa ka ajamakêtkati nẽ akĩnh nẽ axàmnhĩx ri apa. ");
INSERT INTO apnNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Nẽ kot kaj mẽ atõ amã Tĩrtũm kãm hprãm xà hkôt tanhmã amnhĩ nhĩpêx to ho ri apa hprãm tỳx nẽ. Nhũm amnhĩ tã apumu nhũm ja kãm mex nẽ nhũm ato mex nẽ. Nẽ tanhmã ato ka hkôt pix mã amnhĩ to mex o ri apa nẽ ajamakêtkati nẽ akĩnh nẽ axàmnhĩx ri apa. Nẽ kot kaj mẽ tanhmã amnhĩ tomnuj to. Hãmri nẽ tee ri ja hã amnhĩ pumu nẽ ajamaxpẽr. Nẽ apijaàm nẽ akaprĩ xàj amỳr o nhỹ. Amỳr rax nẽ. Hãmri nhũm Tĩrtũm ja hã apumu nhũm ja kãm mex nẽ. Jakamã nhũm anê akaprĩ hta nẽ ato mex nẽ. Ka ajamakêtkati nẽ akĩnh nẽ axàmnhĩx ri apa. ");
INSERT INTO apnNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","23","Nẽ kwãr mẽ mãmrĩ ixtã tanhmã mẽ ato kapẽr punuj to nẽ tanhmã mẽ ato hêx to nẽ tanhmã ri mẽ atomnuj to ho pa. Kwãr mẽ mãmrĩ ã mẽ anhĩpêx anhỹr o pa. Ka mẽ ãm inhmã pix mã ajamaxpẽr rãhã ho apa pê ajamakêtkati nẽ axàmnhĩx ri apa. Kwãr mẽ mãmrĩ ã mẽ anhĩpêx anẽ nẽ mẽ amex kêt ã mẽ ajarẽnh o pa. Amnepêm na pre Tĩrtũm nhỹ hã kapẽr xwỳnhjaja nhũm prem ã mẽ hipêx anẽ. Jakamã koja mẽ uràk nẽ ã mẽ anhĩpêx anhỹr o pa. Nhũm Tĩrtũm ja hã mẽ apumu nẽ amnhĩm mẽ amex ã mẽ ajarẽ. Hãmri nẽ nhỹrmã kaxkwa kamã wa inhõ krĩ kamã mẽ ato mex rax nẽ. Ka mẽ akĩnh nẽ ajamakêtkati nẽ axàmnhĩx ri apa. Jakamã kwãr mẽ mãmrĩ pika jakamã ã ixtã mẽ anhĩpêx anẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Nhũm Jejus nhãm hkôt mẽ pa ho mẽ pa xwỳnhjê nhĩhkô hã mẽ kot Tĩrtũm kôt amnhĩ nhĩpêx o pa hkêt xwỳnhjê hwỳr apkjê. Nẽ mẽ omu nẽ tanhmã mẽ kãm kapẽr to. Mẽ hikukrêx rũnh xwỳnhjê kumrẽx mã kapẽr nẽ mẽ kãm: E kwa mẽ o kora mẽ akukrêx rũnh xwỳnhjaja. Na ka htem ãm akukrêx rũnh pix mã ajamaxpẽr o ri apa nẽ gryk ã Tĩrtũm mã ajamaxpẽr o apa hkêt nẽ. Jao mẽ amã kapẽr mar prãm kêt nẽ. Nẽ ãm akukrêx rũnh mã ajamaxpẽr pê akĩnh nẽ ri apikunhar o ri apa. Tã kot ka mẽ nhỹrmã ty hãmri nhũm akĩnh xàja apê hapêx. ");
INSERT INTO apnNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Nẽ mẽ amã Tĩrtũm kôt ri amnhĩ nhĩpêx prãm kêt xwỳnhjaja. Kot kaj mẽ nhỹrmã akaprĩ htỳx kãm tee ri amnhĩ to hwỳr kaprỳ kãm ga. Koja mẽ amar kêt nẽ. Nẽ mẽ atỳx ri mẽ ate tanhmã amnhĩ tomnuj to hkukamã ajamaxpẽr nẽ apikunhar pê amnhĩ tomnuj o apa xwỳnhjaja. Kot kaj mẽ nhỹrmã ã mẽ ate amnhĩ nhĩpêx anhỹrja mỳrapê mẽ kot amnhĩ xà htỳx kamã hamak o pa htũm xà hwỳr ma apa. Hãmri nẽ kamã akaprĩ xàj amỳr rãhã ho ri apa. Jakamã kwa mẽ o kora mẽ amã Tĩrtũm prãm kêt xwỳnhjaja. Kêr ka mẽ ixkapẽr ma nẽ axkãm ajamak rom nẽ ri apa. ");
INSERT INTO apnNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Amnepêm mẽ pakukamã mẽ pa xwỳnhjaja na prem Tĩrtũm kapẽr o hkwỳjê jahkre ho pa. Nom axtem nẽ hkwỳm ri tanhmã mẽ kãm ho hêx to nhũm mẽ kuma nhũm ja mẽ kãm mex nẽ nhũm mẽ amnhĩm mẽ mex ã mẽ harẽ. No ãm mẽ mex kêt. Tã mẽ kajaja. Mẽ kot mẽ uràk nẽ axpẽn mã mẽ amex ã mẽ ajarẽnh tã Tĩrtũm mã mẽ amex kêt. Jakamã kot kaj mẽ amex kêt nẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Hãmri nhũm Jejus hpãnhã mẽ piitã mẽ ahkre nẽ mẽ kãm: —E mẽ ate inhmar xwỳnhjaja. Kêr ka mẽ kot mẽ atomnuj xwỳnhjaja amnhĩ tã tanhmã mẽ ho hkêt nẽ. Ãm mẽ ho mex pix o ri apa hkukamã mãn ajamaxpẽr. ");
INSERT INTO apnNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","—Nẽ mẽ kot mẽ ato kapẽr punuj xwỳnhjaja. Kêr ka mẽ amnhĩ xwar amnhĩ tã tanhmã mẽ ho akapẽr punuj to hkêt nẽ. Ãm tãm mẽ kãm akapẽr pê mẽ kãm akapẽr mex o ri apa. Nẽ mẽ kot tanhmã ri mẽ ato ho pa xwỳnhjaja ka mẽ ho mex pix o ri apa. Nẽ mẽ ho Tĩrtũm wỳr pix kukamã mãn ajamaxpẽr. ");
INSERT INTO apnNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","—Nẽ koja mẽhõ anhĩnep akura ka ãm omu nẽ tanhmã amnhĩ tã ho hkêt nẽ. Te ate kãm ihkjê pẽr nhũm kot ihkjê kamã akuranh pyràk o amnhĩ nhĩpêx nhũm ja amã mex nẽ. No kêr ka mẽ amnhĩ tã tanhmã mẽ ho hkêt nẽ. —Nẽ koja mẽhõ apê anhĩnôhkà py ka tanhmã hã kãm nẽ hkêt nẽ. Kwãr mãmrĩ apê kupy. Ka mããnẽn te ate kry pê anhĩnôhkà hpakà ry jagjênh xwỳnhta anhĩnôhkà hkôt kãm õr pyràk o hipêx. Nom kamã agryk kãm kãm õr kêt nẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","—Nẽ koja mẽhõ kêp amrakati kumrẽx nẽ awỳr tẽ nẽ mẽmoj tã awỳ. Ka anhõ mẽmoj japêr nẽ mãmrĩ kãm mẽmoj gõ. Kêp anhõxỳ hkêt kamã kãm mẽmoj gõ. Rỳ koja mẽhõ apê mẽmoj to ahkĩ ka axàhkurê hkêt nẽ. Nẽ tanhmã hã ho hkêt nẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Mẽ piitã mẽ kot tãm mẽ anhĩpêxja na mẽ amã hprãm. Tã kêr ka mẽ amnhĩ pyrà nẽ tãm mẽ piitã mẽ hipêx o ri apa. Mẽ kot tãm mẽ anhĩpêx kêt tã kêr ka mẽ axàmnhĩx ri anhõxỳ hkêt nẽ tãm mẽ hipêx o ri apa. ");
INSERT INTO apnNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","—Nom kot kaj mẽ amã mẽ piitã mẽ ho mex o apa hprãm kêt japêr. Nẽ ãm mẽ kot mẽ ato mex xwỳnhjê pix ka mẽ amã mẽ ho mex prãm. Xà koja Tĩrtũm ja hã mẽ apumu nhũm ja kãm mex nẽ? Nà koja kãm mex kêt nẽ. Koja mẽhõ mẽ ato mex kêt tã ka mẽ amnhĩ rom ho mex nẽ nhũm Tĩrtũm ja hã mẽ apumu hãmri nẽ mẽ amex ã mẽ ajarẽ. Mẽ kot amnhĩ tomnuj o mẽ pa xwỳnhjaja na htem ãm mẽ kot mẽ ho mex xwỳnhjê pixjaja nhũm htem amnhĩ xwar mẽ ho mex o pa. No tãm mẽ kot amnhĩ nhĩpêx o mẽ pa xwỳnhjaja na htem mẽ piitã mẽ ho mex o pa. Mẽ kot tãm amnhĩ nhĩpêx xwỳnhjaja nẽ mẽ kot amnhĩ tomnuj xwỳnhjaja nhũm mẽ ho hpimrààtã mẽ ho mex o axpẽn pyràk o pa. ");
INSERT INTO apnNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","36","—Nẽ mẽ kot amnhĩ tomnuj xwỳnhjaja na htem ãm mẽ kot mẽ ho mex xwỳnh pixjaja nhũm htem amnhĩ xwar mẽ ho mex o pa. No mẽ kajaja. Kêr ka mẽ mãmrĩ mẽ piitã mẽ kamã axukaprĩ pix nẽ. Jao axàmnhĩx ri mẽ piitã mẽ kãm mẽmoj nhõr o ri apa. Nhũm Tĩrtũm ja hã mẽ apumu nẽ ja hã mẽ ato mex nẽ. —Jakamã kêr ka mẽ amarĩ mẽ kãm akurê xwỳnhjê ho mex nẽ. Nẽ mẽ kamã axukaprĩ nẽ. Nẽ mẽ piitã mẽ kãm mẽmoj nhõr o ri apa. Kê nhỹrmã Tĩrtũm maati mẽ hã mẽ amã mẽmoj nhõr rax nẽ. Nẽ mẽ ate kot amnhĩ nhĩpêx kôt amnhĩ nhĩpêx xwỳnh ã mẽ ajarẽ. Tĩrtũm na hte mẽ kot amnhĩ tomnuj xwỳnhjê kamã ukaprĩ ho pa. Jakamã kêr ka mẽ uràk nẽ ã mẽ hipêx anhỹr o ri apa. E kêr ka mẽ ã axpẽn nhĩpêx anhỹr rãhã nẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Nhũm Jejus arĩ mẽ ahkre nẽ mẽ kãm: —Nẽ kêr ka mẽ atỳx ri amnhĩ krã hkôt tanhmã mẽ kot amnhĩ tomnuj to hã tanhmã axpẽn jarẽnh to ho ri apa hkêt nẽ. Kêr kê Tĩrtũm mẽ apyrà nẽ ã mẽ ajarẽnh anhỹr kêt nẽ. —Nẽ kêr ka mẽ tanhmã mẽhõ kot ra atomnuj tota mã ajamaxpẽr rãhã hkêt nẽ. Ãm ho ajamakêtkati tokyx anẽ nẽ axte kãm ajamaxpẽr kêt nẽ. Kêr kê Tĩrtũm ja hã mẽ apumu nẽ mẽ apyrà nẽ axte tanhmã mẽ ate amnhĩ tomnuj to mã hamaxpẽr kêt nẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","—Nẽ kêr ka mẽ axpẽn kamã axukaprĩ pê tanhmã axpẽn to mex to ho ri apa. Kêr kê Tĩrtũm ja hã mẽ apumu nẽ mẽ apyrà nẽ mẽ akamã ukaprĩ pê tanhmã mẽ ato mex to ho pa. Na hte mẽ pahte axpẽn kamã paxukaprĩ hã mẽ pahpumunh xà hkôt tanhmã mẽ pakamã ukaprĩ to. ");
INSERT INTO apnNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","—Nom kêr ka mẽ atỳx ri tanhmã axpẽn to akapẽr to hkêt nẽ. Mẽ ate aprĩ hã axpẽn jamaxpẽr kôt axpẽn pumunhre hã. Jakamã kot kaj mẽ atỳx ri mẽhõ ho akapẽr punuj hãmri nẽ te mẽ nohkre xwỳnhjê hõ kot mẽmoj pumunh kêt tãã te kot no ho omunh nẽ tanhmã harẽnh to pyràk o amnhĩ nhĩpêx. ");
INSERT INTO apnNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Tĩrtũmja tapxipix na kot mẽ pajamaxpẽr kôt mẽ pahpumunh par. Mẽ axàhpumunh tỳx o mẽ pahte hakrenh kêt jakamã kwa kêr ka mẽ ãm hkôt pix mã amnhĩ nhĩpêx o ri apa. Kot kaj mẽ ã amnhĩ nhĩpêx anẽ hãmri nẽ gaa nẽ uràk nẽ mẽ piitã mẽ kamã axukaprĩ pix o ri apa. ");
INSERT INTO apnNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","42","Jao mẽhõ kot tanhmã amnhĩ tomnuj to hã omu hãmri nẽ tanhmã hã kãm nẽ tokyx anhỹr kêt nẽ. Akumrẽx ate tanhmã amnhĩ tomnuj to hã amnhĩ pumu nẽ hkaga hãmri nẽ rĩ kormã mẽhõta hwỳr tẽ nẽ kot tanhmã amnhĩ tomnuj to hã kãm akapẽr to. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","45","Nhũm Jejus arĩ mẽ ahkre nẽ mẽ kãm: —Nẽ koja mẽmo pĩ hpàr mex nẽ ô mex nẽ. Nom koja pàr punuj hãmri nẽ ômnuj nẽ. —Nẽ na htem mẽmo xô pumu nẽ hkôt tanhmã pàr kute hã omu. No na htem rãrãj pumu nẽ kêp akunĩ kamã mrônhĩ xô hã hkamnhĩx kêt nẽ. Na htem mẽmo xỳ hpàr pumu nẽ ô xànhre hã hkamnhĩx kêt nẽ. Ja pyrà nẽ koja mẽhõ hamaxpẽr punuj nẽ mããnẽn hakwa ho kapẽr punuj pix nẽ. Nẽ htỳx tanhmã amnhĩ tomnuj to ho ri pa. Nom koja hamaxpẽr mex nẽ hãmri nẽ mããnẽn hakwa ho kapẽr mex o pa. Na htem ahpỹnhã amnhĩ jamaxpẽr xà hkôt tanhmã hakwa ho kapẽr to ho ri pa. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Nhũm Jejus arĩ mẽ hkôt mẽ pa ho pa xwỳnhjê jahkre ho nhỹ nẽ mẽ kãm: —Nẽ kot kaj mẽ ixpê mẽ anhõ pahihti hã ijarẽ hã kot kaj mẽ ixkapẽr kôt amnhĩ nhĩpêx rãhã ho ri apa. ");
INSERT INTO apnNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","—E pa mẽ amã ixprĩ hã mẽ kot ixkôt amnhĩ nhĩpêx xwỳnhjê kot amnhĩ nhĩpêx jarẽ ka mẽ aprĩ hã inhma. ");
INSERT INTO apnNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Mẽ kot amnhĩ nhĩpêxja te mẽhõ hamaxpẽr mex pê aptỳx kãm amnhĩm õrkwỹ nhĩpêx pyràk. Koja aptỳx kãm õrkwỹ nhĩpêx nhũm mẽmo arĩgro hã na wrỳk rax nẽ. Nẽ gô htàm rax nẽ hanhi nom nhũm arĩ ãm tỳx nẽ xa. Tã kot kaj mẽ ixkôt amnhĩ nhĩpêx ã kot kaj mẽ te ixkre jarẽnhja pyràk. Jao amex nẽ ajamakêtkati nẽ ri apa. Te gô htàm kot ixkre janhir tã nhũm ãm tỳxta pyràk. ");
INSERT INTO apnNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Nom koja mẽhõ hamaxpẽr mex kêt nẽ htỳx mõ nẽ gô mỳri gyw rerek kãm amnhĩm õrkwỹ nhĩpêx. Hãmri nhũm mẽmo arĩgro hã na wrỳk rax nẽ. Nẽ hã gô htàm rax nẽ õrkwỹ janhi nẽ kêp grành pa. Tã koja mẽhõ ixkôt amnhĩ nhĩpêx kêt nẽ te ho mẽhõ kot gô mỳri gyw rerek kãm ixkre nhĩpêxta pyràk. Jao mex kêt nẽ pa. Jakamã kwa mẽ ixkapẽr mar tỳx nẽ te gô htàm kot ixkre janhir nẽ grành parta pyràk o amnhĩ nhĩpêx o apa hkêt nẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Tã nhũm Jejus mẽ kãm ujarẽnh pa hãmri nẽ ma akupỹm Kapanaũ hwỳr mõ. ");
INSERT INTO apnNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Nẽ mõõ nẽ ra hwỳr pôj. Nhũm krĩ kamã pôristi krãhtũm mã àpênh xwỳnhja à htỳx nẽ nõ. Ra htyk kaxyw nẽ nõ nhũm õ patrãw tee ri omu nẽ kãm hapê jakamã tee ri hkukamã hamaxpẽr o hkaprĩ nẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Hãmri nẽ Jejus pôx ã harẽnh ma nẽ hwỳr Ijaew pigêt kwỳjê rẽ nẽ mẽ kãm: —Kwa mẽ ma Jejus wỳr mra nẽ kãm ijarẽ kê tokyx man ixwỳr tẽ nẽ inhmã àpênh xwỳnhta o mex. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","5","Hãmri nhũm mẽ kuma nẽ ma hwỳr mra nẽ omu nẽ kãm: —Pa. Na pôristi krãhtũm na awỳr mẽ inhmẽ pa mẽ mra. Mẽ pahkĩnhã kêp Ijaew kêt tã kãm mẽ pahkĩnh nẽ. Tãm na pre mẽ inhõ krĩ kamã mẽ inhmã Tĩrtũm kapẽr o mẽ ahkre xà hã ixkreja nhĩpêx. Tã na kãm àpênh xwỳnhta kêp à htỳx nẽ nõ nhũm apôx hã ajarẽnh ma nẽ man awỳr mẽ inhmẽ. Kwa ma hwỳr tẽ nẽ kãm ho mex nà? Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Hãmri nhũm mẽ kuma nẽ mẽ kãm: —Tôe. Ma pu mẽ hwỳr. Anẽ. Hãmri nẽ ma mẽ hkôt tẽ. Hãmri nẽ kormã õrkwỹ htêp o htẽm mẽ nhũm axte kutã hkràmnhwỳ hkwỳ rẽ nhũm mẽ ma kutã mra. Hãmri nẽ mra nẽ mẽ hkaxpa nẽ Jejus pumu nẽ kãm: —Pa? Kwa na pôristi krãhtũmta ã awỳr karõ anẽ. Na mẽ inhmã: “E kêr ka mẽ mra nẽ nhỹri Jejus kaxpa nẽ kãm awjarẽ kê ãm ata rũm kapẽr pix o inhmã à xwỳnhta o mex. Kĩnh ã ixpê Ijaew kêt jakamã ixte amnhĩ kuk ã ixpijaàm tỳx. Jakamã kot paj pam hwỳr ixtẽm kêt nẽ. Kwa kãm anẽ kê ata rũm kapẽr pix o inhmã akupỹm ho mex. ");
INSERT INTO apnNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","8","Ixpê mẽ hkrãhtũm jakamã na pa hte inhõ pôristi mã mẽmoj tã karõ nhũm mẽ inhmar xà hkôt inhmã mẽmoj tanhmã hipêx to. Na pa hte mẽ kãm: ‘E mẽ ma mra nẽ ã amnhĩ nhĩpêx anẽ.’ Anẽ nhũm mẽ inhma nẽ ma mrar kurê kumrẽx. Rỳ pa mẽ kãm: ‘E mẽ amnẽ ixwỳr mra nẽ ã amnhĩ nhĩpêx anẽ.’ Anẽ nhũm mẽ inhma nẽ ixwỳr mra. No kêt Jejus na hte ixrom tanhmã mẽ à kuteja mã kapẽr nhũm kuma nẽ mẽ kêp hapôj nẽ ma mrar kurê kumrẽx. Jakamã koja ata rũm kapẽr pix o inhmã ho mex.” Anhỹr o awỳr karõ. Jakamã na pa mẽ akutã mra nẽ akaxpa nẽ ã amã kapẽr jarẽnh anẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Hãmri nhũm Jejus amnhĩ jaêr pê mẽ kapẽr ma nẽ hkĩnh nẽ. Hãmri nẽ hkôt mẽ kot mar o pa xwỳnhjê mã kãm: —Kwa xà na ka mẽ ã kot ixwỳr karõ xwỳnh jamaxpẽr anhỹrta ã ama? Mẽ pahkĩnhã kêp Ijaew kêt tã mẽ arom amnhĩ kaxyw inhmã hamaxpẽr tỳx nẽ. Aa mẽ atõ uràk nẽ ate amnhĩ kaxyw ã inhmã ajamaxpẽr tỳx anhỹr kêt tã nhũm mẽ arom kãm àpênh xwỳnh kaxyw inhmã hamaxpẽr tỳx nẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Nhũm pre ã mẽ kãm kapẽr anẽ hãmri nhũm pôristi krãhtũm kràmnhwỳjaja kuma nẽ awjanã nẽ ma akupỹm hkrãhtũm nhõrkwỹja wỳr mra. Nhũm ra Jejus kãm àpênh xwỳnhta akupỹm ho mex nhũm mex nẽ ri mra. Hãmri nhũm mẽ akupỹm pôj nẽ akupỹm mex ã omu. ");
INSERT INTO apnNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Tã nhũm Jejus ma krĩ pê Naĩ hwỳr hkôt mẽ pa ho mẽ pa xwỳnhjê mẽrohã mõ nhũm mẽ ohtô nẽ mẽ hkôt mra. ");
INSERT INTO apnNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Nhũm mẽ ra Naĩ hwỳr hpôx o mõ. Nẽ hwỳr agjê. Axpẽr kãm agjê nẽ mõ nhũm kêp mjên htyk xwỳnhja mẽ kutã tẽ. Nhũm hkra myja ham kêp ty. Kra pyxi htã kêp ty nhũm mẽ kasãw kamã kuxà nẽ kumỳ nẽ kot haxàr kaxyw o mõ nhũm katorxà mẽ hkôt mỳr o mõ. Nhũm krĩ nhõ xwỳnh kwỳjaja ma hkôt mõ. Piitã hkaprĩ nẽ hkôt mỳr o mõ. ");
INSERT INTO apnNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Tã nhũm Jejus mẽ hkwỳja mẽ mõ nẽ mẽ hkaxpa nẽ katorxà mỳr ã omu nhũm Jejus kãm hkaprĩ nẽ. Hãmri nẽ xa nẽ kãm: —Pa? Kwa amỳr kêt nẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Hãmri nẽ kasãwta wỳr tẽ nẽ hã ĩhkra xi nhũm mẽ kot mỳnh xwỳnhjaja omu nẽ amarĩ kãm o xa. Hãmri nhũm htyk xwỳnhta mã kapẽr nẽ kãm: —E kwa kànhmã nhỹ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Pu nhũm kànhmã ỹr kurê kumrẽx. Nẽ kapẽr o nhỹ. Hãmri nhũm Jejus nita mã kãm: —E ota akrata. Na akupỹm amã htĩr. Anẽ. Hãmri nhũm akupỹm htĩr ã omu nẽ hkĩnh tỳx kumrẽx. ");
INSERT INTO apnNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Hãmri nhũm mẽ kot omunh xwỳnhjaja amnhĩ jaêr pê akupỹm hkra htĩr kãm omu nẽ ỹ hã haxwỳja hkĩnh nẽ. Nẽ Tĩrtũm mã mex o mex ã harẽ nẽ axpẽn mã: —Kwa ãm hãmri na Tĩrtũm ã mẽ panhĩpêx anẽ nẽ mẽ pahwỳr ỹ hã kapẽr jarẽnh xwỳnhta mẽ nhũm mẽ pahwỳr mõ. Tĩrtũm mẽ pakamã ukaprĩ jakamã na ã mẽ panhĩpêx anẽ. Nà ãm hãmri na ã mẽ panhĩpêx anẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Hãmri nẽ piitã ma pikaja rũm mẽ kãm harẽnh o hprõt nhũm mẽ piitã harẽnh ma. ");
INSERT INTO apnNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Rôm nhũm Juãw Paxisja kêp prês nẽ hkrĩ nhũm hte hkôt mẽ pa xwỳnhjaja hwỳr mra nẽ kãm Jejus kot tanhmã amnhĩ nhĩpêx to ho pa hã harẽ. Hãmri nhũm harẽnh ma nẽ tee ri hkukamã hamaxpẽr. Hãmri nẽ hkôt mẽ pa xwỳnh wa ho axkrut nẽ wa kuta ");
INSERT INTO apnNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","nẽ Jejus wỳr wa kumẽ nẽ wa kãm: —Kwa wa ma hwỳr tẽ nẽ hkukja. Nẽ kãm: “Xà ka na pre Tĩrtũm mẽ ixwỳr amẽ nà? Nà xà kormã axtem hõ na pa mẽ kormã amnhĩ wỳr hamãr o ri ixpa?” Anẽ. E wa ma hwỳr tẽ nẽ ã hkukjêr anẽ nẽ tanhmã kot amnhĩ jarẽnh to hã ama hãmri nẽ man akupỹn tẽ nẽ inhmã harẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","21","Hãmri nhũm wa kuma nẽ ma hwỳr tẽ. Nhũm Jejus kormã mẽ ho mex o xa. Mẽ nohkre xwỳnhjaja nhũm akupỹm mẽ no ho mex. Nẽ mẽkarõmnuti kot mẽ hwỳr gjêx xwỳnhjaja nhũm mẽ nê mẽ hapôx o ãm rãhã nhũm wa ra hwỳr tẽ nẽ kormã hã mẽ omunh o xa. Hãmri nẽ kãm Juãw Paxis kapẽr jarẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Hãmri nhũm wa kuma nẽ wa kãm: —Tỳ. Nà ãm hãmri na ja hã ijarẽ. Ixpê mẽ ate ixkamã ajamak o apa xwỳnhta na pa. Jakamã e. Wa kam nẽ tanhmã ixte amnhĩ nhĩpêx to hã ixpumu hãmri nẽ ma akupỹm hwỳr tẽ nẽ aprĩ hã kãm ijarẽ. Mẽ nohkre xwỳnhjaja na pa akupỹm mẽ no ho mex. Nẽ mẽ hkànhy xwỳnhjaja pa akupỹm mẽ hkà ho mex. Nẽ mẽ hyk o mẽ pa xwỳnhjaja pa akupỹm mẽ ho mex. Nẽ mẽ htyk xwỳnhjaja pa akupỹm mẽ ho htĩr. Nẽ mẽ kêp amrakati nẽ ri mẽ pa xwỳnhjê mã mẽmoj mex jarẽnh o ri ixpa. Na pa hte ã mẽ ho mex o ri mẽ hkôt ixpa anẽ. Jakamã e kwa wa ma akupỹm hwỳr tẽ nẽ ã kãm ijarẽnh anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Kê ijarẽnh ma nẽ arĩ amnhĩ kaxyw ixkôt hamaxpẽr tỳx rãhã nẽ. Koja ã amnhĩ nhĩpêx anẽ nẽ hamakêtkati nẽ ri pa. Nẽ tee ri ijarẽnh kukamã hamaxpẽr kêt nẽ. E wa tokyx ma akupỹm hwỳr tẽ nẽ ã kãm ijarẽnh anẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","25","Nhũm pre ã Jejus wa kãm amnhĩ jarẽnh anẽ nhũm wa kuma nẽ ma akupỹm Juãw Paxis wỳr tẽ. Hãmri nhũm Jejus mẽ kot mar o kuhê xwỳnhjê mã tanhmã Juãw Paxis jarẽnh to nẽ mẽ kãm: —Na ka prem kapôt ã mar kaxyw ma hwỳr mra. Nom ê mex ã omunh kaxyw rỳ hpijaàm kãm tanhmã kapẽr to hã mar kaxyw hwỳr amrar kêt nẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Kêp Tĩrtũm nhỹ hã kapẽr xwỳnh jakamã na ka prem mar kaxyw ma hwỳr mra. Tĩrtũm nhỹ hã kot ixkukamã ijarẽnh o pa xwỳnh na. Ixpê Tĩrtũm kot mẽ akaxyw ixãm xwỳnh ã na pre mẽ amã ijarẽnh o pa. Nẽ hprĩ hã tanhmã mẽ amã ijarẽnh to. Jakamã na kapẽr mex o kot wam Tĩrtũm nhỹ hã kapẽr jarẽnh o mẽ pa xwỳnhjê kapẽr jakrenh. ");
INSERT INTO apnNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Tĩrtũm kapẽr ã kagà htũm kot Juãw kukamã tanhmã harẽnh to nẽ harẽnh kot: Kot paj Ixkra hkukamã ma mẽ hwỳr harẽnh o pa xwỳnh mẽ kê ma ri hkukamã mẽ kãm harẽnh o ri pa. Kê mẽ kuma nẽ kutêp tãm amnhĩ nhĩpêx. Anhỹr o Tĩrtũm Juãw Paxis kukamã harẽ nhũm mẽ hã kagà. Tã nhũm mẽ awỳr kumẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Juãwja mex kumrẽx. Na pre hprĩ hã ixkukamã tanhmã ijarẽnh to ho pa. Nom ixkôt mẽ pa ho mẽ pa xwỳnhjê hkĩnhã ixkôt pa ho pa hkêt ãm ixkukamã ijarẽnh o pa. Jakamã ixkôt mẽ pa ho mẽ pa xwỳnhjaja na mex o kot Juãw Paxisja jakrenh. Mẽ kot ixkôt hprĩ hã inhmar o pa jakamã mẽ mex o kot hakrenh. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Nhũm pre ã Jejus mẽ kãm Juãw Paxis jarẽnh anẽ. Mẽ kot Juãw mar o kuhê xwỳnh kwỳjaja na pre htem tanhmã amnhĩ tomnuj to ho pa. Tã Juãw kot mẽ kãm Tĩrtũm kapẽr jarẽnh ma nẽ axpẽn mã Tĩrtũm mex ã harẽ. Nẽ axpẽn mã: —Nà ãm hãmri. Tĩrtũm kapẽr na mex kumrẽx. Anẽ. Hãmri nẽ amnhĩ tomnuj kaga nẽ Tĩrtũm kôt amnhĩ xunhwỳ. Jakamã nhũm Juãw Paxis Tĩrtũm mã mẽ hkrã kumrã. ");
INSERT INTO apnNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","No nhũm Parijew nhõ xwỳnhjê mẽ Tĩrtũm kapẽr tũm o mẽ ahkre ho mẽ pa xwỳnhjaja jajê hkĩnhã Juãw Paxis kaga kumrẽx. Jakamã nhũm mẽ hkrã kumrãr kêt nẽ. Mẽ kot Tĩrtũm kapẽr kaga jakamã na pre htem Jejus kapẽr ma nẽ ãm kuma. ");
INSERT INTO apnNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Hãmri nhũm Jejus mẽ kãm: —E pa mẽ amã mẽ piitã htỳx ri hamaxpẽr ã tanhmã mẽ harẽnh to ka mẽ kot amnhĩ nhĩpêx ã mẽ harẽnh ma. ");
INSERT INTO apnNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Te mẽ kot mẽhprĩre kot amnhĩ nhĩpêx pyràk. Mẽhprĩrejaja na htem õrkwỹ kapem hije nẽ mẽmoj to amnhĩkati ho hkrĩ. Nẽ tee ri hkwỳjê kot amnhĩ nhĩpêx pumu nẽ mẽ kãm: Kwa na pa mẽ amã gre htã ka mẽ ixkutã anhõkrepôx kêt nẽ. Pa mẽ ja hã mẽ apumu nẽ hpãnhã mẽ amã mẽ htyk jarẽ htã ka mẽ akaprĩ nẽ amỳr kêt nẽ. Kwa mẽ ri ã amnhĩ nhĩpêx anhỹr kêt nẽ. Anhỹr o axpẽn mã kapẽr. Tã te mẽ ate mẽ uràk. Tĩrtũm kot mẽ awỳr ỹ hã kapẽr xwỳnhjê rẽnh tã ka mẽ te mẽhprĩre kot amnhĩ nhĩpêxta pyrà nẽ mẽ ama ãm mẽ ama nẽ mẽ hkôt amnhĩ nhĩpêx kêt nẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","—Juãw Paxis na pre mẽ awỳr mõ nẽ ixpyrà nẽ apkur mex o ri pa hkêt nẽ. Nẽ ixpyrà nẽ wĩhti ho hkõm kêt nẽ pa. Tã ka mẽ ja hã omu nẽ hkaga nẽ atỳx ri Satanasti nhỹ hã kot tanhmã amnhĩ nhĩpêx to ho pa hã hkamnhĩx nẽ ri harẽnh o ri apa. Hãmri nẽ mẽhprĩre kot amnhĩ nhĩpêx pyrà nẽ hkôt amnhĩ nhĩpêx kêt nẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Tã pa Juãw pãnhã mẽ awỳr mõ. Nẽ kurom apkati mẽ ixàpkur mex o ri ixpa. Nẽ kurom wĩhti hkwỳ ho ixkõm o ri ixpa. Ka mẽ ja hã ixpumu nẽ atỳx ri ixàpkur rũnh nẽ ixpipãnh o ri ixpa hã ixkamnhĩx nẽ ã axpẽn mã ixto akapẽr anhỹr o ri apa. Nẽ mẽ kot amnhĩ tomnuj xwỳnhjê hkôt ri ixpa hã axpẽn mã ijarẽnh o ri apa. Ã na ka htem axpẽn mã ijarẽnh anẽ. Jao te mẽ ate Juãw Paxis nhĩpêx pyrà nẽ ixkaga nẽ ixkôt amnhĩ nhĩpêx kêt nẽ. Na hte ã htỳx ri tanhmã mẽ hamaxpẽr to ho mẽ pa xwỳnhjaja amnhĩ nhĩpêx anhỹr o ri pa. ");
INSERT INTO apnNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","—No tãm ri mẽ hamaxpẽr o mẽ pa xwỳnhjaja na htem ahpỹnhã Juãw mẽ wa ixte amnhĩ nhĩpêx ã wa ixpumu nẽ axpẽn mã wa ijarẽnh o: “Nà ahpỹnhã wa kot amnhĩ nhĩpêx tã wa hamẽ ãm hãmri Tĩrtũm nhỹ hã kapẽr jarẽnh mex o pa. E pu mẽ wa uràk nẽ Tĩrtũm kôt amnhĩ xunhwỳ.” Anhỹr o axpẽn mã wa ijarẽnh o pa. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Tã nhũm Parijew nhõ xwỳnh pê Simãwreja amnhĩ nhõrkwỹ hwỳr Jejus mẽ hkôt mẽ pa ho pa xwỳnhjê mẽ kuwỳ. Mẽ kot kutã apkur kaxyw amnhĩ wỳr mẽ kuwỳ nhũm mẽ õrkwỹ hwỳr mra nẽ mẽ hwỳr agjê nẽ apkur kaxyw hkrĩ. ");
INSERT INTO apnNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Hãmri nhũm mẽhõ nija mẽ hwỳr axà. Na pre hte amnhĩ tomnuj pix o pa. Hãmri nẽ Jejus õ krĩ hwỳr hpôx nẽ Simãwre nhõrkwỹ kamã apkur ã harẽnh ma nẽ ma hwỳr tẽ. Mẽ hkuxwaxà hã à py nẽ ma hwỳr o tẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Hãmri nẽ hwỳr axà nẽ Jejus pumu nẽ hwỳr tẽ nẽ pum xa. Nẽ tee ri tanhmã kot amnhĩ tomnuj to ho paja mã hamaxpẽr nẽ hpijaàm nẽ hkaprĩ nẽ mỳr o xa. Hãmri nẽ Jejus kutã hkõn krã ho tẽm nẽ nhỹ nẽ no kagô ho hpar go. Hãmri nẽ amnhĩ krã kĩ ho hpar grà nẽ kupã hãmri nẽ hpãnhã mẽ hkuxwa xà ho kuxwa. Kãm hkĩnh xàj ã hipêx anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Hãmri nhũm Simãwre tee ri ja hã omu nẽ hamaxpẽr o: —Tk. Kwa jahti kot amnhĩ tomnuj pix o pa xwỳnh tã mẽ ixwỳr axà nẽ ã Jejus nhĩpêx anẽ nhũm amnhĩ nê hanor kêt nẽ. Kêp ãm hãmri Tĩrtũm nhỹ hã kapẽr jarẽnh o pa xwỳnh ronhỹx ja hã omu nẽ amnhĩ nê hanor kurê kumrẽx. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Hãmri nhũm Jejus amnhĩ tã hamaxpẽr ã omu nẽ hêx rom kãm kapẽr nẽ kãm: —E Simãwre. Pa amã awjarẽ ka inhma. Anẽ. Hãmri nhũm kãm: —Tôe. Mex. Mãmrĩ inhmã awjarẽ pa ama. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Hãmri nhũm kãm: —Nà koja mẽhõ my wa hamẽxkrut. Nhũm hõja mẽhõ pê kàxpore ho rax kumrẽx nẽ ho ĩpresta. Nhũm hõja ãm kêp ho grire nẽ ho ĩpresta. Hãmri nẽ wa hamẽ kàxpore ho hapêx pa. ");
INSERT INTO apnNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Hãmri nẽ akupỹm kot kêp ho ĩpresta xwỳnhta mã hpãnhã õr kaxyw tee ri amnhĩ kukamã hamaxpẽr. Ra kot ho hapêx par jakamã tee ri amnhĩ kukamã hamaxpẽr. Tã nhũm kot wa kãm ho ĩpresta xwỳnhta wa hwỳr tẽ nẽ wa kãm: “Kwa wa tee ri amnhĩ kukamã ajamaxpẽr kêt nẽ. Na pa ra war ate ixto tewẽn ã kagàta kaxônh pa nhũm ja hapêx. Kot paj axte kãm ijamaxpẽr kêt nẽ. Jakamã wa mãmrĩ ajamakêtkati nẽ axàmnhĩx ri apa.” Anhỹr o wa kãm kapẽr. Ã mẽ ujarẽnh kot anhỹr. Anẽ. Nhũm pre ã Jejus Simãwre mã ujarẽnh anẽ. Hãmri nẽ hã hkukja nẽ kãm: —E nhỹ myja koja we kãm ho tewẽn xwỳnhta kĩnh tỳx nẽ wehe? Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Hãmri nhũm kãm: —Nà kot kêp ho rax nẽ ho ĩpresta xwỳnhta koja kãm hkĩnh tỳx o hõta jakre. Anẽ. Hãmri nhũm kãm: —Tỳ. Nà ãm hãmri na ka ã harẽnh anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Tã mãn ka ni kot ã inhĩpêx anhỹr xwỳnhta pumu. Na ka amnhĩ nhõrkwỹ hwỳr ixwỳ pa axà nom ka inhmã gô hkwỳ pa ho amnhĩ par kuhõnh kêt nẽ. Tã nhũm nija arom ã inhĩpêx anẽ nẽ no kagô ho ixpar kuhõ nẽ amnhĩ krã kĩ ho grà ho nhỹ. ");
INSERT INTO apnNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","—Nẽ anhõrkwỹ hwỳr ixàrta ã ka ixkahti hkôt inhmỳnh nẽ ixpãr kêt nẽ. Tã kêt nija arom xatã ixpar pãr o nhỹ. ");
INSERT INTO apnNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Nẽ ate orti ho ixkrã gregrer kêt tã nhũm arom mẽ hkuxwaxà ho ixpar kuxwa ho nhỹ. Mẽhkukwaxà hã kàxpore xohtô htã nhũm àmnhĩx ho ixpar kuxwa ho nhỹ. ");
INSERT INTO apnNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","ãm hãmri na pa amã ja jarẽ. Nija kot amnhĩ tomnuj tỳx tã pa ra nê kot amnhĩ tomnuj o ijapêx pa. Ra kot amnhĩ tomnuj tỳx xwỳnh ã amnhĩ pumunh jakamã na amnhĩ kaxyw inhmã hamaxpẽr pê kãm ixkĩnh nẽ ã inhĩpêx anẽ. No ka na ka hte uràk nẽ amnhĩ tomnuj tỳx o apa htã uràk nẽ tee ri ja hã amnhĩ pumunh kêt nẽ. Tã nita kĩnhã ate amnhĩ tomnuj kaga hkêt jakamã na ka ãm amã ixkĩnh grire. Anẽ. Nhũm pre ã Jejus Simãwre mã kapẽr anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","50","Hãmri nẽ nija mã kapẽr nẽ kãm: —E kànhmã xa. Ra ate amnhĩ kaxyw inhmã ajamaxpẽr jakamã na pa ra ate amnhĩ tomnuj piitã amnhĩ katut kôt rẽnh pa. Kot paj axte kãm ijamaxpẽr kêt nẽ. Jakamã mãmrĩ ma ajamakêtkati nẽ axàmnhĩx anhõrkwỹ hwỳr tẽ. Anẽ. Hãmri nhũm mẽ kot axpẽn kutã apkur xwỳnhjaja tee ri kot kãm kapẽr anhỹrja ã kuma nhũm ja mẽ kãm mex kêt nẽ. Jakamã nhũm mẽ ri axpẽn mã harẽnh o: —Tk. Kwa mẽhõ na hte ri kot Tĩrtũm kot amnhĩ nhĩpêx pyràk o amnhĩ nhĩpêx nẽ mẽ kot amnhĩ tomnuj o hapêx ã amnhĩ jarẽnh o we ri pahti? Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Tã nhũm Jejus ma mẽ piitã mẽ kãm Tĩrtũm kapẽr o mẽ ahkre ho ri mẽ hkôt pa. Krĩ rũnh kamã nẽ krĩ hkryre kamã. Mẽ kot amnhĩ tomnuj kaga nẽ Tĩrtũm kôt amnhĩ xunhwỳr nhũm kot amnhĩ tã mẽ omunh nẽ mẽ ho hkra kaxyw nhũm ri mẽ hkôt mẽ kãm harẽnh o pa. Nhũm ỹ hã mẽ ahkre ho mẽ pa xwỳnh pê 12jaja ma hkôt ri pa. ");
INSERT INTO apnNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Nẽ mẽni hkwỳjaja. Na pre ra Jejus mẽ hkwỳjê nê mẽkarõmnuti japôj. Nẽ mẽ hkwỳjaja tanhmã mẽ à kute xwỳnhjaja nhũm akupỹm mẽ ho mex. Xwỳnhjaja nhũm prem haxwỳja ma hkôt ri pa. Hõ pê na pre Marir Matarẽn nhũm pre ra Jejus nê mẽkarõmnuti ho 7 nẽ hapôj. ");
INSERT INTO apnNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Nẽ Joanã. Joanã mjên Kujahti na pre kêp pahihti Erox mã mẽ àpênh xwỳnhjê krãhtũm. Nẽ Sujãnre. Nẽ kaxyw mẽnijê ohtô nẽ Jejus kôt tanhmã mẽ ho ajuta hto ho mẽ hkôt pa. Jao mẽ hikàxpore ho mẽmoj japrô nẽ ho mẽ kãm mẽ õ nhĩpêx o ri mẽ hkôt pa. ");
INSERT INTO apnNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Tã nhũm mẽ ra krĩ piitã rũm Jejus wỳr akuprõ. Jakamã nhũm mẽ ohtô rax kumrẽx nhũm Jejus mẽ kãm ujarẽnh o nhỹ. No ãm hprĩ hã ujarẽnh kêt nẽ. Mẽ kot Tĩrtũm kapẽr mar nẽ tanhmã hkôt amnhĩ nhĩpêx to nhũm hã kuxi nẽ mẽ kãm hã ujarẽnh o nhỹ. ");
INSERT INTO apnNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","Nẽ mẽ kãm: —E mẽ inhma. Koja mẽhõ ma pur mã mõ nẽ pur kãm mẽmo hy ho ukapêr o ri pa. Nom nhũm piitã amex kãm rôrôk kêt nẽ. Kwỳ ahpỹnhã nhỹri rôrôk. Hãmri nhũm hkwỳ aptỳx kãm rôrôk nhũm kuwênhre omu nẽ hwỳr mra nẽ hkrẽr pa. ");
INSERT INTO apnNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","—Nẽ kẽn kãm hy hkwỳ rôrôk nẽ higrõt kutã nojarêt nẽ higrõt pa. No nhũm kamã aptỳx nẽ kamã kêp pika hkryre jakamã nhũm higrõt nhũm hã myt ahpa nẽ arĩgro htỳx mẽ nhũm grà pa. Kamã kẽn nhũm amgo mex kêt jakamã nhũm grà pa. ");
INSERT INTO apnNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","—Nẽ mrônhĩ kamã rôrôk xwỳnhja haxwỳja higrõt tã no nhũm utĩ kêp amỹtà nhũm ô hkêt nẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","—No hirã kamã pika mex kãm rôrôk xwỳnhja. Hãmri hirã kamã rôrôk nẽ higrõt mex nẽ piitã ô rax nẽ. Piitã kamã ô kêp 100. Ã mẽ ujarẽnh kot anhỹr. E kwa mẽ ixujarẽnh ma nẽ kãm ajamaxpẽr tỳx rãhã ho ri apa. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Nhũm pre ã Jejus mẽ kãm ujarẽnh anẽ. Hãmri nhũm hkôt mẽ pa ho mẽ pa xwỳnhjaja kuma nẽ tee ri hkukamã hamaxpẽr nẽ kãm: —Kwa na pa mẽ ixprĩ hã axujarẽnh kôt mẽmoj pumunh kêt nẽ. Aprĩ hã mẽ inhmã tanhmã harẽnh to pa mẽ ixprĩ hã kuma nà? Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Hãmri nhũm mẽ kãm: —Tôe. Nà kot paj mẽ amã harẽ. Tĩrtũm kãm mẽ ate aprĩ hã mar prãm jakamã kot paj ixprĩ hã mẽ amã harẽ. Mẽ kot amnhĩ tomnuj kaga nhũm Tĩrtũm kot ja hã mẽ omunh nẽ mẽ ho hkra. Ja na pa harẽ. —No mũjjaja na mẽ akĩnhã kãm mar prãm nõkati. Jakamã na htem ixujarẽnh ma nẽ ãm kuma nẽ htỳx ri pa. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Hãmri nhũm Jejus hkôt mẽ pa ho mẽ pa xwỳnhjê mã: —E kot paj ixprĩ hã mẽ amã mẽmo hy ho ukapêr ã mẽ ujarẽnhta jarẽ ka mẽ inhma. —Nà mẽmo hyta te kêp Tĩrtũm kapẽr pyràk. Nẽ ahpỹnhã hy rôrôk ã pikata te kêp ahpỹnhã mẽ kot Tĩrtũm kapẽr mar xwỳnhjê kot amnhĩ nhĩpêx pyràk. ");
INSERT INTO apnNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Mẽ kot mar xwỳnh kwỳjaja te kot aptỳx kãm hy rôrôk nhũm kuwênh kot hwỳr mrar nẽ hkrẽr par xwỳnhta pyràk. Jao Tĩrtũm kapẽr ma nhũm Satanasti te kuwênh kot hy hkrẽr parta pyrà nẽ mẽ kot amnhĩ kaxyw Tĩrtũm kapẽr kôt hamaxpẽr nẽ hkôt amnhĩ xunhwỳr pymaj tanhmã nê mẽ hkrã hto. Jakamã nhũm mẽ kapẽr ma nom ho hamakêtkati tokyx anẽ nẽ axte kãm hamaxpẽr nẽ hkôt amnhĩ nhĩpêx kêt nẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","—Nẽ mẽ kot mar xwỳnh kwỳjaja te kot kẽnre kamã hkwỳ rôrôk nẽ higrõt nẽ grà par tokyx anhỹr xwỳnhta pyràk. Jao Tĩrtũm kapẽr ma nẽ hkĩnh nẽ. Nẽ kãm mar prãm nẽ. Tã nhũm mẽhõ tẽ nẽ Tĩrtũm nê tanhmã kãm kapẽr to nhũm mẽ kuma nẽ Tĩrtũm kaga. Te mẽmo hy higrõt nẽ grà par tokyx anhỹrta pyràk. ");
INSERT INTO apnNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","—Nẽ mẽ kot mar xwỳnh kwỳjaja te kot mrônhĩ kamã hkwỳ rôrôk nẽ higrõt nhũm mrônhĩ kot kêp àmnàr xwỳnhta pyràk. Jao kãm Tĩrtũm kapẽr mar prãm nẽ. No ãm mããnẽn kãm hikukrêx rax nẽ hikàxpore rax prãm xàj ãm ja pix mã hamaxpẽr o pa. Nẽ gaa nẽ ra gryk ã axte Tĩrtũm kapẽr mã hamaxpẽr nẽ hkôt amnhĩ nhĩpêx kêt nẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","—Nẽ mẽ kot mar xwỳnh kwỳjaja te hirã kamã pika mex kãm hy hkwỳ rôrôk nẽ higrõt nẽ ô raxta pyràk. Nẽ ixkapẽr ma nẽ amnhĩ krã him hagjênh tỳx nẽ ixkôt ri amnhĩ nhĩpêx mex rãhã ho ri pa. Jakamã te ra mẽmo hy hkreta ô rax mex pyràk. E. Ã ixujarẽnh kot anhỹr. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Nhũm Jejus arĩ mẽ kãm ujarẽnh o nhỹ nẽ mẽ kãm: —E mẽ inhma. Xà na htem kanê hpôk hãmri nẽ guhkrax o hpro rỳ par krak ri unhwỳ? Nà na htem ã hipêx anhỹr kêt nẽ. Na htem hpôk nẽ kỳxpê kuhê xà kamã unhwỳ nhũm hirã mex o kuhê. Nhũm htem ixkrem agjê nẽ hirã kamã mẽmoj pumunh mex nẽ. Ja pyrà nẽ na pa hte mẽ ate inhmar tỳx kaxyw ixprĩ hã mẽ amã awjarẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Kormã mẽ ate mẽmoj pumunh nẽ aprĩ hã mar kêt tã kot kaj mẽ tokyx aprĩ hã omu nẽ ama. Te mẽmoj kot mẽ apê hpimxur pyràk tã koja tokyx mẽ amã amnhĩ to amnhĩrĩt ka mẽ aprĩ hã omunh pa. Te mẽ ate kanê hpôk kãm aprĩ hã mẽmoj pumunh mexta pyràk. ");
INSERT INTO apnNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Jakamã kêr ka mẽ ixkapẽr mar tỳx nẽ hkôt ajamaxpẽr rãhã ho ri apa. Jao ixkapẽr piitã mar tỳx nẽ. Nom kot ka mẽ mar tỳx kêt nẽ hã ano hkêt pa nẽ axte kãm ajamaxpẽr o apa hkêt nẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Nhũm Jejus arĩ mẽ ahkre ho nhỹ. Rôm nhũm katorxà nẽ htõjaja nhỹhỹnh hwỳr mõn pôj. No nhũm mẽ kot mẽ hã htu rax jakamã nhũm mẽ tee ri hwỳr gjêx kaxyw nẽ kormã kapôt ã kuhê. ");
INSERT INTO apnNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Hãmri nhũm mẽhõja mẽ omu nẽ Jejus mã mẽ harẽ nẽ kãm: —Kwa Pahihti. Ota ra akatorxà mẽ atõjaja awỳr pôj nẽ tee ri awỳr gjêx mã. O mũj mẽ kormã kapôt ã kuhê. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Hãmri nhũm mẽ kuma nẽ mẽ kãm: —Tôe pa ixkato nẽ mẽ omu. Inhmã mẽ hapêê. Nom kot kaj mẽ atõ Tĩrtũm kapẽr ma nẽ hkôt amnhĩ xãm nẽ hkôt amnhĩ nhĩpêx. Hã kot kaj te apê ixtõ rỳ ixkatorxà kot amnhĩ nhĩpêx pyràk o pu mẽ axpẽn nhĩpêx. Pa te inhmã mẽ hapê pyrà nẽ inhmã mẽ ajapê nẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Tã nhũm apkati hõ hã nhũm Jejus himô rax ã rêr kaxyw nojarêt nẽ hkôt mẽ pa ho mẽ pa xwỳnhjê mã kãm: —E kot puj mẽ jarãhã ma xarmã mõ. Anẽ. Hãmri nẽ mẽ pàr mã gjêx pa nẽ ma xarmã mõ. Garirej rũm kato nẽ ma xarmã pika hõ hwỳr kormã mõ. ");
INSERT INTO apnNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Nhũm ra Jejus õtxwa nẽ pàr kre kamã gõr nẽ nõ. Pu nhũm kôk àpêr tỳx nẽ nhũm gô axpẽn tak tỳx nẽ kànhmã harĩ. Nẽ pàr kre kamã pikapĩr rax nhũm pàrta mẽ kãm àr o mõ nhũm mẽ tee ri amnhĩ nhĩpêx. No nhũm Jejus arĩ htỳx gõr nẽ nõ. ");
INSERT INTO apnNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Hãmri nhũm mẽ tee ri amnhĩ kukamã hamaxpẽr nẽ kumra nẽ kãm: —Kwa Pahihti kànhmã nhỹ. Kot puj mẽ jarãhã pahtyk pa. Anẽ. Hãmri nhũm kànhmã nhỹ nẽ kôk mã kapẽr nẽ kãm: —E. Kwa hãmri anhĩkrê. Anẽ. Hãmri nhũm hpinhkrênh par mẽ nhũm gô tãm nõr kurê kumrẽx. ");
INSERT INTO apnNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Hãmri nhũm Jejus hkwỳjê hwỳr apkjê nẽ mẽ kãm: —Kwa kormã te mẽ ate amnhĩ kaxyw Tĩrtũm mẽ wa inhmã ajamaxpẽr tỳx kêt pyràk. Anẽ. Hãmri nhũm mẽ amnhĩ jaêr pê kot ã amnhĩ nhĩpêx anhỹr ã omu nẽ no hawênh rũnh nẽ tee ri axpẽn pumunh pê hamaxpẽr o kuhê nẽ axpẽn mã: —Kokỹỹ. Jejus kêp mẽ panhĩõ hkêt. Mẽ pahtõ kot pu we te kot amnhĩ nhĩpêx pyrà nẽ we kôk mã pakapẽr nhũm we pama anhĩkrê? Nà Jejus mẽ parom àhpumunh tỳx o àhpumunh tỳx. Jakamã na ã anẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Tã nhũm mẽ ra himô nhĩhkjê hã krĩ pê Geras wỳr rê. Himô nhĩkjê hã na pre pika pê Garirej. Nẽ Garirej nhĩkjê hã na Gerasja. Jakamã nhũm mẽ ra hwỳr rê. ");
INSERT INTO apnNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","29","Hãmri nẽ pàr kre rũm hapôj nẽ api nẽ mra nhũm mẽhõ myja mẽ kutã tẽ. Na pre ra hwỳr mẽkarõmnuti hkwỳ agjê nhũm mẽ ỹ hã oprê htỳx nẽ hkênh nẽ ri mra. Nẽ õrkwỹ kamã hkrĩ hkêt nẽ. Ãm ri kapôt ã pa ho pa. Mẽ htykjê hã pika kamã kẽn kre kaêx kôt ri pa. Na pre ra krĩ nhõ xwỳnhjaja xatã tee ri unê nẽ hkaxpre. Tee ri kàx o ri hkaxpre htã no nhũm amnhĩ nê rênh pa. Nhũm mẽkarõmnutija tanhmã hkrã hto nhũm kapôt pix ã ri mra. Jakamã nhũm Jejus mẽ pàr rũm hapôj nẽ api nhũm mẽ omu nẽ mẽ kutã tẽ nẽ Jejus kaxpa. Nhũm amnhĩ wỳr omu nẽ nê tanhmã mẽkarõmnuti mã kapẽr to. Hãmri nhũm my xoprêja hwỳr tẽ nẽ kutã hkõn krã ho tẽm nẽ nhỹ. Hãmri nẽ kàxpêê amnhĩ tã kãm kapẽr. Nom tãm kapẽr kêt nẽ. Mẽkarõmnuti nhỹ hã kãm kapẽr nẽ kãm: —Pa Tĩrtũm Kra Jejus? Kwa mo kaxyw na ka mẽ ixwỳr tẽ? Kwa tanhmã mẽ ixto hkêt nẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Hãmri nhũm mẽ kãm: —Kwa tanhmã na mẽ anhĩxi kute? Anẽ. Nhũm mẽ kãm: —Nà mẽ ixpê Mẽohtôhti. Anẽ. Mẽkarõmnuti ra kot hwỳr ohtô nẽ gjêx jakamã na prem ã kãm amnhĩ nhĩxi jarẽnh anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","32","Hãmri nẽ Jejus mã: —Kwa jahti nê mẽ ijapôj nẽ mẽ kot amnhĩ xà htỳx kamã hamak tũm xà hwỳr mẽ ixrẽnh kêt nẽ. Hagrô hkwỳ mũj wỳr mãn mẽ ixrẽ pa mẽ hpãnhã hwỳr mãn hagjê nà? Anẽ. Hagrôja kii mẽ kêp amỳm hixêt ã ri apkur o pa nhũm mẽ ã Jejus mã mẽ hwỳr amnhĩ to hwỳr anẽ. Hãmri nhũm mẽ kãm: —Tôe. Tô mẽ tãm hwỳr mãn mra. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Hãmri nhũm mẽ kuma nẽ myta pê hapôj nẽ ma hagrôja wỳr mrar kurê kumrẽx nẽ mẽ kãm gjêx pa. Hãmri nhũm myja akupỹm tãm hkrã. No nhũm hagrôja mẽkarõmnuti pymaj amỹra nẽ axkahkũm nẽ hprõt nẽ himô hã krã hixêt ã axpum rôrôk nẽ gôx kãm mrõ nẽ pikaprãr pa. ");
INSERT INTO apnNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Hãmri nhũm hagrô jamãr xwỳnhjaja tee ri omu hãmri nẽ ma mẽ õ patrãw wỳr akupỹm mẽ piitã mẽ kãm harẽnh o hprõt nẽ mra. ");
INSERT INTO apnNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","36","Nhũm mẽ tee ri mẽ kuma hãmri nẽ ma kot Jejus pumunh mã hwỳr mra nẽ hkaxpa. Nẽ kuri myta pumu nhũm ra akupỹm tãm hkrã nẽ tãm amnhĩ nhĩpêx nẽ ê kamã mex nẽ nhỹ. Nhũm mẽ kot hã omunh xwỳnhjaja mẽ kãm ujarẽnh pa. Nhũm mẽ kuma nẽ tee ri amnhĩ kukamã hamaxpẽr o ra kãm ma nẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","39","Hãmri nẽ amnhĩ nê Jejus mã kapẽr nẽ kãm: —E kwa mẽ tokyj ma akupỹm amrar kurê kumrẽx. Anẽ. Hãmri nhũm mẽ kuma nẽ awjanã nẽ ma akupỹm pàr wỳr mra nẽ agjê. Nhũm akupỹm mex xwỳnhta mẽ hkôt hkrà nom nhũm Jejus kãm: —Nà kot kaj mẽ ixkôt amõr kêt nẽ. Ma akupỹm anhõ krĩ hwỳr mãn tẽ nẽ Tĩrtũm kot tanhmã akupỹm ato mex to hã mẽ kãm amnhĩ jarẽnh o ri mẽ hkôt apa. Anẽ. Hãmri nhũm kuma nẽ ma akupỹm krĩm tẽ nẽ ri mẽ kãm Jejus kot tanhmã ho mex to hã harẽnh ri mẽ hkôt pa. ");
INSERT INTO apnNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Tã nhũm Jejus mẽ ma akupỹm xarmã mõ nẽ rê nẽ mẽ kutêp mẽ pikuprõnh xwỳnhjê pumu. Nhũm mẽ ra amnhĩ wỳr mẽ omu nẽ mẽ kutêp gô jakàx ã pikuprõnh rax nẽ. Jakamã nhũm mẽ mẽ hwỳr pôj nhũm mẽ amnhĩ wỳr Jejus pumu nẽ hkĩnh nẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","42","Hãmri nhũm Jajti ma hwỳr tẽ. Ijaew nhõ Tĩrtũm kapẽr o mẽ ahkre xà hã ixkre jamãr xwỳnh na pre. Nhũm pre hkra ni pyxire. Hã amgrà pê 12. Tã ra kêp à htỳx nẽ htyk kaxyw nẽ nõ. Hãmri nhũm hipêêxàja tee ri omu hãmri nẽ Jejus wỳr tẽ nẽ kutã hkõnkrã ho tẽm nẽ nhỹ nẽ ho kuwỳ nẽ kãm: —Pa akupỹm mẽ ixto mex xwỳnh maati. E awỳr na pa tẽ. Na ra ixkra ixpê htyk kaxyw. Pa tee ri omu nẽ kaxyw amã ijamaxpẽr nẽ awỳr tẽ. Kwa ma ixkôt inhõrkwỹ hwỳr tẽ nẽ inhmã omu nẽ tokyx inhmã ho mex nà? Anẽ. Hãmri nhũm kuma nẽ ma hkôt tẽ. Nhũm mẽ ohtô nẽ wa hkôt pry hã mra nẽ axpẽn nhĩgã nẽ axpẽn kujahêk o hkôt mra. ");
INSERT INTO apnNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Hãmri nhũm mẽhõ nija haxwỳja wa hkôt tẽ. Na pre hte hkamrô hkryre rãhã ho pa hã ra amgrà kêp 12. Nhũm tôtô tee ri kot ho mex kaxyw hkane kaprỳ ho pa. ");
INSERT INTO apnNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Jakamã nhũm tee ri amnhĩ kukamã hamaxpẽr hãmri nẽ Jejus jarẽnh ma nẽ ma mẽ hkôt hwỳr htẽm kurê kumrẽx. Nom nhũm mẽ ohtô rax nẽ hkôt mõr jakamã nhũm mẽ hkaêx kôt hwỳr tẽ nẽ hkatut kôt kêp ê nhĩrê kupê. Hãmri nẽ ãm kêp ê pix kupênh tã akupỹm mex. ");
INSERT INTO apnNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Hãmri nhũm Jejus kot kêp ê kupênh ã amnhĩ tã omunh tã hêx rom mẽ ho hakẽx nẽ mẽ omu nẽ mẽ kãm: —Kwa mẽ atõ na ka ri amnhĩ kaxyw inhmã ajamaxpẽr tỳx pê ixpê ixê kupê? Anẽ. Hãmri nhũm mẽ piitã tee ri axpẽn pumu nẽ kãm amnhĩ tã aprã. Hãmri nhũm Simãw Pêtre kãm: —Mẽ kot apê amnàr griã kot ka kêt ri mẽhõ kot apê hkupênh xwỳnh ã ri mẽ hkukja. Kwa mãn ãm mẽhõ amarĩ apê hkupê. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Hãmri nhũm kãm: —Nà mẽhõja amarĩ hkupênh kêt nẽ. Na amnhĩ kaxyw inhmã hamaxpẽr tỳx pê ixpê hkupê. Tã ixàhpumunh tỳx xàja kôt na akupỹm mex. Nom ixte mẽhõ kot ixpê hkupênh xwỳnhja pumunh jakamã na pa ixêx rom ã amnhĩ tã ri mẽ hkukjêr anẽ. Kwa mẽ atõ inhmã amnhĩ jarẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Hãmri nhũm mẽhõ nita kuma nẽ tee ri kêp kot amnhĩ to hpimxur prãm kaprỳ. Hãmri nẽ hpijaàm kãm hwỳr htertet o tẽ nẽ kutã hkõn krã ho tẽm nẽ nhỹ nẽ kãm amnhĩ jarẽ nẽ kãm: —Ma pa na pa inhmã inhmex prãm xàj apê axê kupê. Tã na pa akupỹm inhmex. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Hãmri nhũm Jejus kuma nẽ kãm: —Tôe. Nà ra ate amnhĩ kaxyw inhmã ajamaxpẽr tỳx kôt ate ã amnhĩ nhĩpêx anhỹr jakamã na ka akupỹm amex. E mãmrĩ ajamakêtkati nẽ ma akupỹm tẽ. Anẽ. Hãmri nhũm kuma nẽ hkĩnh nẽ ma akupỹm tẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Rôm nhũm Jajti mã àpênh xwỳnhjê hõ õrkwỹ rũm ma õ patrãw kutã tẽ nẽ wa hkaxpa nẽ Jajti mã kãm: —Kwa na ra apê akra ty. Jakamã mo kaxyw kot ka kêt amnhĩ kôt hwỳr Jejus o mõ? Kwãr mãmrĩ ma akupỹm tẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Hãmri nhũm Jejus kuma nẽ Jajti mã kãm: —Kwa tee ri akra hkukamã ajamaxpẽr kêt nẽ. Kaxyw inhmã mãn ajamaxpẽr tỳx nẽ. Koja te ra apê htyk tã koja akupỹm amã htĩr. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","53","Hãmri nhũm mẽ mõ nẽ õrkwỹ hwỳr pôj nẽ hwỳr axà nẽ mẽ omu nhũm mẽ ra htyk xwỳnhta ã htu rax nẽ. Nẽ omũj ri mur. Hãmri nhũm Jejus mẽ hwỳr axà nẽ mẽ mỳr ã mẽ omu nẽ mẽ kãm: —Kwa mẽ hãmri amỳr kêt nẽ. Na nireta mẽ apê htyk kêt na ãm gõr nẽ nõ. Anẽ. Hãmri nhũm ra mẽ kot htyk ã omunh mex jakamã kuma nẽ ãm kuma nẽ axtem nẽ ri axpẽn mã hã hpẽr o axkẽ. Hãmri nhũm Jejus htyk xwỳnhta wỳr hitom wỳr àr kaxyw nẽ amnhĩ kôt Juãw nẽ Xiakre nẽ Pêtre nẽ kaxyw htyk xwỳnh katorxà nẽ hipêêxàja. Jajê pix na pre amnhĩ kôt mẽ ho agjê. ");
INSERT INTO apnNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Hãmri nẽ htyk xwỳnhta wỳr tẽ nẽ hpa hã kupy nẽ kãm: —Pa? Kwa tokyx kànhmã nhỹ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Hãmri nhũm akupỹm htĩr nẽ kànhmã ỹr kurê kumrẽx. Hãmri nhũm Jejus mẽ kãm: —E kwa mẽ tokyx kãm mẽmoj japêr kê kukrẽ. Mãn ra kãm prãm nẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Hãmri nhũm katorxà mẽ hipêêxà wa amnhĩ jaêr pê akupỹm htĩr kãm omu nẽ kamã no pyma ho hkĩnh tỳx nẽ. Hãmri nhũm Jejus wa kãm: —E wa inhma. Kêr ka wa akupỹm ixte war amã ho htĩr ã ri mẽ kãm ijarẽnh o ri apa hkêt nẽ. Ãm kwarĩ ho kwarĩ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","2","Tã nhũm Jejus hkôt mẽ pa ho mẽ pa xwỳnh pê 12jê mã kapẽr nẽ mẽ kãm: —E mẽ amnẽ ixwỳr mra nẽ ixkapẽr ma. Na pa ra mẽ amã ixàhpumunh tỳx xà hkwỳ gõ. Jakamã kêr ka mẽ inhỹ hã ma ri akwỳjê hkôt tanhmã mẽ ho mex to ho ri mẽ hkôt apa. Mẽ à xwỳnhjê ho mex o ri mẽ hkôt apa. Nẽ mẽ hkwỳjê nê mẽkarõmnuti japôj. Nẽ mẽ piitã mẽ kãm anẽ kê mẽ tokyx Tĩrtũm kôt amnhĩ xunhwỳ kê mẽ ho hkra. ");
INSERT INTO apnNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Nom kêr ka mẽ amnhĩ kôt akukrêx ho ohtô nẽ ri ho apa hkêt nẽ. Nẽ amnhĩ kaxpar xà hã kô ho apa hkêt nẽ. Nẽ kawà htur nẽ ho apa hkêt nẽ. Nẽ amnhĩ kôt axàpkur xà hã anhõ ho apa hkêt nẽ. Rỳ akàxpore rax nẽ ho apa hkêt nẽ. Ãm mẽ anhõ kamĩs ho pixi nẽ haxà nẽ ri hã apa. Nẽ anhỹ kamã ã ri mẽ hkôt apa anẽ. Kê mẽ kot mẽ akapẽr mar xwỳnhjaja tãm mãn mẽ amã mẽ anhõ ho pa. ");
INSERT INTO apnNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","—Nẽ kêr ka mẽ nhỹri krĩ hõ hwỳr pôj nẽ apôx xà kamã mẽhõ nhõrkwỹ kamã hkôt ri apikamẽnh tãmtã kurũm akupỹm ajapôj nẽ ma hpãnhã nhãm krĩ hõ hwỳr apa. Nom atỳx ri nhãm mẽ hwỳr amrar nẽ nhãm mẽ hwỳr amrar kêt nẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","—Nẽ koja mẽ nhỹri mẽ akapẽr kaga ka mẽ amnhĩ tã mẽ kamã ama nẽ tokyx mẽ kurũm ajapôj nẽ ma nhãm apa. Nẽ anojarêt nẽ mẽ noo mã akuhê nẽ amnhĩ par ã awjagrô kapĩ. Mẽ kot Tĩrtũm kaga hã amnhĩ pumunh nhũm Tĩrtũm kot amnhĩ pyrà nẽ mẽ hkaga hã mẽ kot omunh kaxyw ka mẽ ã mẽ noo mã amnhĩ nhĩpêx anẽ. Hãmri nẽ ma hpãnhã krĩ hõ hwỳr apa. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Nhũm pre ã Jejus mẽ kãm mẽ àpênh ã karõ anẽ. Nhũm mẽ kuma hãmri nẽ hapôj nẽ ma mẽ hkôt pa. Ma krĩ piitã hkôt akupỹm mẽ à xwỳnhjê ho mex nẽ Tĩrtũm kapẽr o tanhmã mẽ ahkre hto ho ri mẽ hkôt pa. ");
INSERT INTO apnNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","8","Hãmri nhũm pika pê Garirej kamã mẽ piitã Jejus jarẽnh ma nẽ ahpỹnhã ri tanhmã axpẽn mã harẽnh to. Mẽ hkwỳjaja kêp finat Juãw Paxis akupỹm htĩr ã ri harẽ. Nhũm mẽ hkwỳjaja amnepêm mẽ hkukamã Tĩrtũm nhỹ hã kapẽr jarẽnh xwỳnhjê hõ ra akupỹm htĩr ã harẽ. Nhũm mẽ hkwỳjaja kêp finat Eris ã axpẽn mã harẽ. Jakamã nhũm pahihti Eroxja mẽ kot ahpỹnhã tanhmã ri harẽnh toja ma nẽ tee ri hkukamã hamaxpẽr. ");
INSERT INTO apnNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Nẽ hamaxpẽr o: —Kwa mẽhõ na hte we ri ã amnhĩ nhĩpêx anhỹr o pa wehe? Nà finat Juãw Paxis kêt. Ra ixte amnepêm hã ixàmnênh nhũm mẽ kot inhmã mut krãhyr nẽ hpĩr kênã. Kwa mẽhõ na hte we ri ã amnhĩ nhĩpêx anẽ? Anhỹr o hamaxpẽr hãmri nẽ kãm omunh prãm nẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Tã nhũm Jejus nhỹ hã kapẽr o mẽ pa xwỳnhjaja akupỹn hwỳr mran pôj nẽ mẽ kot ri tanhmã amnhĩ nhĩpêx to ho pa hã kãm amnhĩ jarẽ. Hãmri nhũm mẽ kuma nẽ ma krĩ pê Pesêj wỳr kormã mẽ o mõ. ");
INSERT INTO apnNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Hãmri nhũm krĩ hkwỳ nhõ xwỳnhjaja ra ma mẽ mõr ã mẽ harẽnh ma nẽ ohtô nẽ ma mẽ hkôt mra nẽ nhỹri mẽ hkôt pôj. Nhũm Jejus amnhĩ kôt mẽ omu hãmri nẽ tanhmã mẽ ho mex to ho xa. Kôt mẽ à nẽ mẽ pa xwỳnhjaja nhũm akupỹm mẽ ho mex. Hãmri nẽ Tĩrtũm kapẽr o mẽ ahkre nẽ mẽ kãm: —E kot kaj mẽ atõ amã amnhĩ tomnuj kaga hprãm xàj Tĩrtũm kôt amnhĩ xãm nhũm amnhĩ tã apumu nẽ ato hkra. Hãmri ka ajamakêtkati nẽ amex nẽ axàmnhĩx ri apa. Anhỹr o mẽ kãm kapẽr pê mẽ ahkre ho xa. ");
INSERT INTO apnNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Tã nhũm myt àr kaxyw nhũm Jejus nhỹ hã mẽ ahkre ho mẽ pa xwỳnh pê 12jaja hwỳr mra nẽ kãm: —Kwa na ra kamàt o mõ. Mẽ hano kê mẽ amnhĩ to krĩ hõ japêr nẽ tokyx amnhĩm mẽmoj japrô nẽ kuku nẽ hikwỹ nẽ gõr. Mo mẽ panhõ? ãm jar kapôt pix kênã. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","14","Hãmri nhũm mẽ kuma nẽ mẽ kãm: —Kwa ka mẽ kamjaja mẽ kãm mẽmoj gõ kê mẽ kuku. Anẽ. Nhũm mẽ ohtô rax nẽ mẽ hkôt mra. Mẽmyjaja kêp 5.000 nẽ kaxyw mẽ hprõ nẽ mẽ hkrajaja. Jakamã nhũm mẽ kêp 12jaja Jejus kot ã mẽ kãm kapẽr anhỹrja ma nẽ tee ri mẽ hkukamã hamaxpẽr nẽ kãm: —Kwa nà mo mẽ panhõ rax? Mẽ panhõ pãwti kêp sĩk nẽ kaxyw tep grà axkrutre kênã kot kêt we mẽ piitã mẽ hipêx pa. Xà kot paj mẽ ma mra nẽ nhỹri mẽ kãm mẽ apkur xà japrô nhũm mẽ kuku? Anẽ. Hãmri nhũm mẽ kãm: —Nà pu mẽ kãm mẽmoj japrôr kêt nẽ. Mẽ panhõta kot puj mẽ kãm ho anhgrà. E mẽ kãm anẽ kê mẽ ahpỹnhã ri hije nẽ hkrĩ nẽ apku. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Hãmri nhũm mẽ kuma nẽ mẽ kãm anẽ nhũm mẽ piitã hkrĩ pa. ");
INSERT INTO apnNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Hãmri nhũm Jejus pãwti mẽ tepta jamỳ nẽ kànhmã kaxkwa hwỳr rĩt nẽ kànhmã kupẽ nẽ Tĩrtũm mã harẽ nẽ kãm: —Pa Papaj? Apê mẽ inhmã mẽ inhõ xwỳnh jakamã amex o amex. Anẽ. Hãmri nẽ mẽ kãm ho hkry hpa nẽ hkôt mẽ pa ho mẽ pa xwỳnhjê mã kugõ nhũm mẽ ô ri ho xa nẽ ho mẽ hipêx par kumrẽx. ");
INSERT INTO apnNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Nhũm mẽ piitã apkur mex o hkrĩ. Mẽõja mẽ kêp grire htã nhũm Jejus tanhmã mẽ kãm ho rax to nhũm mẽ ohtô rax tã piitã kuku nẽ ho õhy htu hpa. Nhũm arĩ mẽõ jakrêx prã nhũm Jejus kôt mẽ pa ho mẽ pa xwỳnhjaja akupỹm hakrêx o pikuprõnh pa nẽ ho kawà ho 12 nẽ ho nỳt pa. ");
INSERT INTO apnNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Tã nhũm arĩgro hõ hã nhũm Jejus nhỹri ahte Tĩrtũm mã amnhĩ jarẽnh o nhỹ nhũm hkôt ri mẽ pa ho mẽ pa xwỳnhjaja ma hwỳr mra. Hãmri nhũm amnhĩ wỳr mẽ omu nẽ amnhĩ tã tanhmã mẽ hkukjêr to nẽ mẽ kãm: —Kwa mẽ inhmã mẽmoj jarẽ. Tanhmã na htem ahpỹnhã axpẽn mã ijarẽnh to wehe? Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Hãmri nhũm mẽ kãm: —Nà na htem ahpỹnhã tanhmã ajarẽnh to. Na hte kamã mẽ hkwỳjaja ato finat Juãw Paxis ã ajarẽ. Nhũm kamã mẽ hkwỳjaja ato finat Eris ã ajarẽ nhũm mẽ hkwỳjaja tõhã apê Tĩrtũm nhỹ hã kapẽr jarẽnh xwỳnhjê hõ ra akupỹm htĩr ã ajarẽ. Ã na htem ahpỹnhã ajarẽnh anẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Hãmri nhũm mẽ kuma nẽ mẽ kãm: —No mẽ kajaja? Ixpê mẽhõ hã na ka htem ixkamnhĩx? Anẽ. Hãmri nhũm Simãw Pêtre kãm: —Nà mẽ pajaja na pa htem apê Tĩrtũm kot mẽ ixkaxyw axãm nẽ mẽ ixwỳr amẽnh xwỳnh ã ajarẽ. Nẽ apê mẽ ixpiitã mẽ inhõ Pahi Maati hã ajarẽ. Ã na pa htem ajarẽnh anẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Hãmri nhũm kuma nẽ mẽ kãm: —Tỳ. Nà ãm hãmri na ka htem ã ijarẽnh anẽ. Ã ixte anhỹr kênã. Nom kêr ka mẽ inhmar kumrẽx. Kêr ka mẽ kormã ã akwỳjê mã ijarẽnh anhỹr o ri apa hkêt nẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Nhũm Jejus arĩ hkôt mẽ pa ho pa xwỳnhjê mã kapẽr nẽ hprĩ hã tanhmã mẽ kãm amnhĩ jarẽnh to nẽ mẽ kãm: —Nà ãm hãmri na Simãw Pêtre ijarẽ. Mẽ kajaja ra mẽ ate ja hã ixpumunh mex. No mẽ pahkwỳjaja na mẽ akĩnhã mẽ kãm ja hã ijarẽnh mar nẽ ja hã ixpumunh prãm kêt. Ijaew pigêtjaja nẽ Tĩrtũm kapẽr tũm o mẽ ahkre o mẽ pa xwỳnhjaja nẽ patre krãhtũmjaja mẽ kãm ja hã ixpumunh prãm kêt. Jakamã koja mẽ nhỹrmã ixpynê nẽ ixtak rax nẽ. Hãmri nẽ ixpĩ. Nom kot paj ixtyk ã apkati axkrunẽpxi nhũm Tĩrtũm akupỹm ixto ixtĩr. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Nhũm pre ã Jejus amnhĩ kukamã hkôt mẽ pa ho mẽ pa xwỳnhjê mã amnhĩ jarẽnh anẽ hãmri nẽ hpãnhã mẽ kot mar o kuhê xwỳnh piitã mẽ kãm kapẽr nẽ mẽ kãm: —E kot ka mẽ atõ ate ixkôt amnhĩ xãm ã amnhĩ jarẽ hãmri nẽ mããnẽn ã amnhĩ jarẽnh anẽ nẽ amnhĩ jarẽnh o: “Jejus kêp inhõ Pahihti jakamã kot paj kapẽr kôt pix mã amnhĩ nhĩpêx rãhã ho ri ixpa. Kwãr ixkwỳjaja tanhmã hã inhĩpêx to.” Anhỹr o apkati mẽ ã amnhĩ jarẽnh anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","—Koja mẽ ixtã mẽ atõx pĩ rỳ tanhmã mẽ atõ hto ka ty. Tã koja akaxwỳnh ma inhõ krĩ mex wỳr àpir kurê kumrẽx. Hãmri nẽ kamã atĩr tũm nẽ amex rãhã apa ho apa. Nom kot kaj mẽ jar atĩr prãm xàj ixkaga hãmri nẽ hwỳr axàpir kêt nẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","—Nẽ koja mẽhõ hikukrêx rax gryk ã Tĩrtũm kaga. Hã koja nhỹrmã ty nẽ ỹ kamã kuwy hwỳr ma mõ nẽ amnhĩ kôt hikukrêx õ hpyr nẽ o mõr kêt nẽ. Koja tee ri kuwy hwỳr mõr pymaj amnhĩ nê hikukrêx rax o amnhĩ pãnhã amnhĩrer prãm kaprỳ. ");
INSERT INTO apnNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","—Nẽ koja mẽhõ ixte mẽ ahkre hã inhma nhũm ja kêp omnuj nhũm ixkaga japêr. Hã kot paj nhỹrmã akupỹn mẽ ato amnhĩptàr kaxyw akupỹn wrỳ nẽ amnhĩ xwar kot ixkaga xwỳnhta kaga. Ãm hãmri na pa ã mẽ amã amnhĩ jarẽnh anẽ. Kot paj nhỹrmã man akupỹn inhõ Papaj nhỹ hã ixte mẽ ho amnhĩptàr kaxyw akupỹn wrỳ. Nhũm kapẽr o mẽ wrỳk xwỳnhjaja man ixkôt wrỳ. Pa mẽ wrỳ hãmri nẽ mẽ kot ixkaga xwỳnhjaja pa amnhĩ pyrà nẽ mẽ hkaga. ");
INSERT INTO apnNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","ãm hãmri na pa ã mẽ amã amnhĩ jarẽnh anẽ. Kot paj nhỹrmã akupỹn ixte mẽ ato amnhĩptàr kaxyw mẽ awỳr wrỳ. Tã kot kaj mẽ akwỳjaja kormã atĩr ri ja kukamã tanhmã ixte amnhĩ nhĩpêx to hã ixpumu. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Tã nhũm semãnja hapêx nhũm Jejus Simãw Pêtre nẽ Xiakre nẽ Juãw wa mẽ kãm kapẽr nẽ mẽ kãm: —E pu mẽ ma hixêt prêk mũj wỳr mõ nẽ hwỳr api nẽ himõk ã Tĩrtũm mã amnhĩ jarẽ. Anẽ. Hãmri nẽ ma amnhĩ kôt hwỳr mẽ o mõ nẽ hwỳr mẽ ho api. ");
INSERT INTO apnNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","32","Hãmri nhũm Jejus Tĩrtũm mã amnhĩ jarẽnh o xa. Nom nhũm hkôt hixêt wỳr mẽ mõr xwỳnhjaja õtxwa htỳx nẽ ra gõr nẽ hikwỹ. Pu nhũm Jejus axtem hkuk nẽ xa. Nẽ ê haka htỳx nẽ xa. Hãmri nhũm ja wa kaxkwa rũm wrỳ nẽ kuri kãm kapẽr o xa. Finat Mojes mẽ finat Erisja wa kuri kãm kapẽr o xa. Na pre ra amnepêm Tĩrtũm amnhĩ wỳr wa ho api. Tã nhũm wa ra akupỹn wrỳ nẽ Jejus mã kapẽr o xa. Mẽ hpimrààtã hirã htỳx kãm axpẽn mã kapẽr o kuhê. Jejus kormã krĩ pê Jerujarẽ kapem mẽ kot hpĩr kêt ri nhũm wa mẽ axpẽn mã htyk kukamã harẽnh o kuhê. Nhũm wa kãm: —Nà Tĩrtũm jamaxpẽr xà hkôt kot kaj ã amnhĩ nhĩpêx anẽ. Anhỹr o Jejus tyk kukamã kãm hamaxpẽr o hihtỳx o wa xa. Rôm nhũm mẽ õt xwỳnhjaja hkrã hapôj nẽ tee ri Jejus pumu. Nhũm mex kumrẽx nẽ hirã htỳx kãm xa nhũm mẽ omu nẽ kuri wa ãm xwỳnhta wa omu. ");
INSERT INTO apnNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Hãmri nhũm Mojes mẽ Eris wa ra akupỹm nojarêt nhũm Simãw Pêtre tee ri ja hã wa omu nẽ Jejus mã kãm: —Kwa Pahihti. Nà ãm hãmri na pu mẽ amnẽ mõ. Kwa pu mẽ kritpêm jar axkamẽ nẽ tokyx panojarêt kêt nẽ. Pa mẽ amã pô nhĩrõnh o axkrunẽpxi nẽ hipêx. Amã hõ nhĩpêx nẽ Mojes mã hõ nhĩpêx nẽ Eris mã hõ nhĩpêx ka mẽ kamã akrĩ. E kwa pa mẽ amã ho anẽ nà? Anẽ. Nhũm amnhĩ krã hkôt ã kãm kapẽr anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Hãmri nẽ kormã kãm kapẽr rôm nhũm kakrã jaka tỳxja wrỳ nẽ mẽ hkunor nhũm wa mẽ kamã kuhê. Hãmri nhũm Simãw Pêtre mẽ Juãw mẽ Xiakreja mẽ tee ri kakrã kot amnhĩ nhĩpêx ã omu nẽ kãm ma nẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Hãmri nhũm kakrã kamã Tĩrtũm mẽ kãm kapẽr nẽ mẽ kãm: —E ota Ixkra xa. Mẽ ate kamã ajamak o apa xwỳnhta na. Inhmã hapêê. Kêr ka mẽ ãm tapxipix kapẽr mar tỳx o ri apa. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Hãmri nhũm mẽ kuma nẽ kànhmã rĩt nẽ ãm Jejus pix pumu nhũm ahte xa. Nhũm kuri wa ãm xwỳnhta wa ra ma akupỹm api nhũm mẽ Jejus pix pumu. Mẽ tapxipixjaja na prem ã Jejus kot amnhĩ nhĩpêx anhỹr ã omu nom taxy kormã nhãm hkwỳjê mã harẽnh kêt nẽ. Ãm axpẽn pix mã harẽnh pê hkukamã hamaxpẽr o ri Jejus kôt pa. ");
INSERT INTO apnNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Tã nhũm apkati nhũm mẽ ma akupỹm ahparmã hkwỳjê hwỳr wrỳk o mõ. Nẽ mẽ hwỳr hpôx o mõ nhũm mẽ ra mẽ kutêp pikuprõnh rax nẽ kuhê. ");
INSERT INTO apnNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Hãmri nhũm mẽhõ myja amnhĩ wỳr mẽ omu nẽ mẽ kutã tẽ nẽ mẽ hkaxpa nẽ Jejus pumu nẽ kãm: —Pa Jejus. Kwa ixkamã axukaprĩ nẽ inhmã ixkra ho mex. Ãm ixpê pyxire. ");
INSERT INTO apnNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Na hte mẽkarõmnuti xatã ixpê tanhmã ho nhũm ỹ hã amỹra nẽ mra nẽ rôrôk nẽ hakwa jamrô ho hikwỹ nhũm tokyx kãm urer kêt nẽ. Nhũm ra ixpê homnuj tỳx nẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Hãmri pa akôt mẽ pa ho mẽ pa xwỳnhjê hwỳr o tẽ nhũm mẽ kot inhmã ho mex kaxyw tee ri tanhmã ho hkaprỳ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Hãmri nhũm kuma nẽ hkôt mẽ pa ho pa xwỳnhjê mã kãm: —Hêxta waa nẽ. Na ka mẽ ra ixte Tĩrtũm nhỹ hã mẽ ho mex ã ixpumunh o ixkôt apa ryy tã kormã ixpyrà nẽ ã mẽ hipêx anhỹr kêt nẽ. Mãn ka mẽ kormã mẽ kaxyw Tĩrtũm kôt ajamaxpẽr tỳx kêt nẽ. Anẽ. Hãmri nẽ myta mã kãm: —E amnẽ ixwỳr akra ho tẽ pa inhno ho omu. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Hãmri nhũm hwỳr o tẽ nhũm mẽkarõmnuti axte kêp ho pika kura nhũm amỹra nẽ tẽm nẽ nõ. Hãmri nhũm Jejus omu nẽ nê mẽkarõmnuti kator nhũm akupỹm mex nẽ kànhmã nhỹ. Hãmri nhũm akupỹm hipêêxà mã kugõ. ");
INSERT INTO apnNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Hãmri nhũm mẽ amnhĩ jaêr pê Jejus kot ã hipêx anhỹrja ã omu nẽ ri axpẽn mã harẽnh o: —Kokỹỹ. Hêxta waa nẽ. Pẽr ãm Tĩrtũmja ãm àhpumunh o àhpumunh. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","Hãmri nhũm Jejus hkôt mẽ pa ho mẽ pa xwỳnhjê mã kãm: —E kot paj mẽ amã tanhmã amnhĩ jarẽnh to ka mẽ inhmar tỳx nẽ. Na pa pre mẽ ate aa mẽmoj pumunh kêt kwỳ ho anhỹr o ixpa pix kaxyw mẽ awỳr ixwrỳk kêt nẽ. Koja mẽ tokyx mẽ kãm ixtã amỹnê nhũm mẽ ixpĩ. E kwa kêr ka mẽ ja ma nẽ hã anohtỳx nẽ ho apa. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Hãmri nhũm mẽ tee ri kot ã amnhĩ jarẽnh anhỹrja ma nẽ axpẽn mã: —Kwa mo na pẽr ri ã amnhĩ jarẽnh anẽ? Kêp mẽ panhõ Pahi Maati hã kot amnhĩ jarẽnh kênã kot kêt mẽhõ kupĩ. Anhỹr o axpẽn mã ri harẽnh o kuhê. Hãmri nẽ mẽ kãm ã kot amnhĩ jarẽnh anhỹrja mar prãm kêt jakamã hprĩ hã tanhmã hã hkukjêr to hkêt nẽ. Ãm akryk mar o kuhê. ");
INSERT INTO apnNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Tã nhũm Jejus kôt mẽ pa ho mẽ pa xwỳnhjaja tanhmã amnhĩ kukamã hamaxpẽr to hãmri nẽ axpẽn mã: —Kwa mẽ pahtõ kot puj we nhỹrmã pahpê pahi nẽ mẽ ho amnhĩptàr rax o pahkwỳ jakre? Anẽ. Hãmri nẽ ja hã axpẽn kukjêr o Jejus kôt mõ nẽ axpẽn mã: “Nà pa.” Nhũm mẽ hkwỳja: “Nà kêt pa.” Anhỹr o hkôt mõ. ");
INSERT INTO apnNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Hãmri nhũm Jejus mẽ kuma nẽ mẽ hamaxpẽr kôt mẽ omu. Hãmri nẽ xa nẽ amnhĩ wỳr mẽhprĩjê mã hpa ho apê nhũm hwỳr tẽ nẽ kuri xa. ");
INSERT INTO apnNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Hãmri nhũm Jejus hkôt mẽ pa ho pa xwỳnhjê mã tanhmã harẽnh to nẽ mẽ kãm: —E mẽ inhma. Kêr ka mẽ apê pahi pyràk o tanhmã amnhĩ jarẽnh to ho ri apa hkêt nẽ. Ãm te amarĩ ri mẽ apa pyràk o amnhĩ nhĩpêx o ri apa. Jao nhỹri mẽhprĩre hõ pumu nẽ kamã axukaprĩ ho kãm mẽmoj tanhmã ho rỳ kãm mẽmoj gõ. Hãmri nẽ te pa ate tanhmã ixto mex to pyràk o amnhĩ nhĩpêx. Nẽ kot ka mẽ atõ pa tanhmã ixto mex to nẽ te ate Tĩrtũm tanhmã ho mex to pyràk o amnhĩ nhĩpêx. Kot kaj mẽ ã amnhĩ nhĩpêx anhỹr o ri apa nhũm Tĩrtũm ja hã mẽ apumu nẽ mẽ ate amnhĩ to rũnh kêt tã nhũm tãm mẽ ate amnhĩ to rũnh xwỳnh ã mẽ ajarẽ. E kot kaj mẽ amã amnhĩ to rũnh prãm nẽ ã amnhĩ nhĩpêx anhỹr o ri apa. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Hãmri nhũm Jejus kôt mẽ pa ho pa xwỳnhjê hõ pê Juãwja nhỹhỹnh hwỳr hpôx o tẽ nẽ kãm: —Kwa Pahihti. O mũj mẽhõ kêp mẽ pahkwỳ hkêt tã anhĩxi jarẽnh kôt mẽ nê mẽkarõmnuti janor o pa. Pa mẽ tee ri kot ã amnhĩ nhĩpêx anhỹr ã omu nẽ nê kãm ixkapẽr. Kêp mẽ pahkwỳ hkêt kênã kot kêt ã mẽ hanor anhỹr o pa. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Hãmri nhũm kuma nẽ kãm: —Kwa nà ja nê tanhmã kãm nẽ hkêt nẽ. Koja mẽhõ mẽ pahkwỳm ri tanhmã mẽ ahkre hto hkêt nẽ hãmri nẽ kêp mẽ panhĩõõ. Ra mẽ pahkôt kot amnhĩ nhĩpêx o pa mã kênã. Jakamã kwa mẽ ja nê tanhmã kãm akapẽr to hkêt nẽ. Kwãr mãmrĩ ã amnhĩ nhĩpêx anhỹr o ri pa. Ja mex kênã. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Hãmri nhũm Jejus akupỹm kaxkwa hwỳr àpir kaxyw ra hwỳr apkati grêre ho mõr jakamã nhũm hamaxpẽr o: —E pa ma akupỹm Jerujarẽ hwỳr mõ. Nà kot paj anẽ. Mẽ kot kamã tanhmã ixto mã tã kot paj ma akupỹm mẽ hwỳr mõ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Hãmri nẽ amnhĩ kukamã mẽ hkwỳjê rẽ nhũm mẽ ma mẽ hkukamã Samar nhõ krĩ kamã nhỹri mẽ kot amnhĩm hikranh xà japêr o mõ. ");
INSERT INTO apnNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Nom nhũm Samar nhõ xwỳnhjaja kêp Jerujarẽ nhõ xwỳnhjê hprãm nõkati jakamã Jerujarẽ hwỳr mõr ã mẽ harẽnh ma nẽ amnhĩ nê mẽ hkurê. ");
INSERT INTO apnNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Hãmri nhũm mẽ tee ri amnhĩ tã mẽ kuma nẽ awjanã nẽ akupỹm Jejus wỳr mra nẽ kãm mẽ harẽ. Hãmri nhũm Juãw mẽ Xiakre wa mẽ harẽnh ma nẽ mẽ kamã gryk nẽ nẽ Jejus mã: —Kwa Pahihti. Nà na mẽ axtem nẽ amnhĩ nê mẽ pahkurê. Jakamã e kwa pu mẽ kaxkwa rũm mẽ hipy kuwy hpôk kwỳ rẽ kê mẽ hkaxàr pa nà? Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Hãmri nhũm wa kuma nẽ wa kãm: —Tk. Kwa nà wa ajamaxpẽrja mex kêt. Pu mẽ ã ri mẽ hipêx anhỹr kêt nẽ. Koja Tĩrtũm kãm ja ho anhỹr prãm nẽ rĩ tãm tanhmã mẽ ho. No mẽ papajaja pu mẽ ri mẽ kamã pagryk xàj tanhmã mẽ hipêx to hkêt nẽ. Pu mẽ ã mẽ hipêx anẽ nẽ ra amnhĩ tomnuj tỳx nẽ. Kwa wa ri ã ajamaxpẽr anhỹr kêt nẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Hãmri nẽ mẽ ma Samar rũm hapôj nẽ hpãnhã nhãm krĩ hõ hwỳr pa. ");
INSERT INTO apnNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Tã nhũm Jejus mẽ kormã mõr ri nhũm mẽhõja hwỳr tẽ nẽ kãm: —Pa Jejus? E kot paj ma akôt ixpa ho ixpa. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Hãmri nhũm kuma nẽ kãm: —Ko ka mã. Kam nẽ rĩ ma ixkôt ri apa ho apa. Nom kêr ka inhmar kumrẽx nẽ rĩ kormã ixkôt apa. Na hte xore pika hkre kamã hikwỹ xà. Nẽ kuwênhre pĩ nhĩmõk ã hikwỹ xà. No pa na Tĩrtũm kot mẽ awỳr inhmẽnh xwỳnh tã jajê hkĩnhã inhõrkwỹ hkêt. Na pa hte ãm nhãm krĩ hõ hwỳr ixpa nẽ nhãm ixpa. Tã xà kot kaj ixpyrà nẽ ã amnhĩ nhĩpêx anhỹr o ri apa nà? Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Nhũm pre ã kãm kapẽr anẽ hãmri nẽ nhãm mẽhõja wỳr apkjê nẽ kãm: —Pa? No ka? Xà kot ka ma ixkôt apa ho apa nà? Anẽ. Hãmri nhũm kãm: —Tỳ no ãm kormã. Koja nhỹrmã inhĩpêêxàja tanhmã amnhĩ to nẽ ty mãn. Pa haxà hãmri nẽ rĩ kormã ma akôt ixpa ho ixpa. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Hãmri nhũm Jejus kuma nẽ kãm: —Kwa nà ri ã ajamaxpẽr anhỹr kêt nẽ. Ma ixkôt apa ho apa kurê kumrẽx. Kê mẽmoj ano kupyr rỳ inhnê apê amnàr kêt nẽ. Kwãr mẽ htĩr tũm nẽ mẽ pa hkêt mã xwỳnhjaja mãn axwakre kamã amã anhĩpêêxà jamãr o pa nhũm nhỹrmã ty kê mẽ amã haxà. Ka mãmrĩ ma Tĩrtũm kapẽr o mẽ ahkre ho ri mẽ hkôt apa. Kê mẽ ama nẽ mẽ hkwỳjaja hkôt amnhĩ xunhwỳ nhũm mẽ ho hkra. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Nhũm pre ã kãm kapẽr anẽ hãmri nhũm nhãm mẽhõ myja haxwỳja hwỳr tẽ nẽ kãm: —E. Pa kot pa ma akôt ri ixpa ho ixpa. Nom kormã. Pa ma akupỹm tẽ nẽ ixkwỳjê mã amnhĩ jarẽ nẽ tanhmã amnhĩ to hpa mãn. Hãmri nẽ mẽmo arĩgro hã rĩ kormã ma akôt ixpa ho ixpa. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Hãmri nhũm tee ri kuma nẽ kãm: —Kwa nà. Kot kaj ã ajamaxpẽr anẽ hãmri nẽ ixkôt apa htã te amnhĩ katut kôt arĩt rãhã ho ri apa pyràk o amnhĩ nhĩpêx. Kwa ã ajamaxpẽr anhỹr kêt nẽ ma ixkôt apa kurê kumrẽx. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Tã nhũm Jejus axte amnhĩ kaxyw mẽ ho 72 nẽ mẽ kurê. Hãmri nẽ mẽ ho axkrut kapẽn nẽ ma nhỹhỹm krĩ hkwỳ hkôt amnhĩ kukamã mẽ kurẽ. Mẽ kot mẽ hkôt ri Tĩrtũm kapẽr o mẽ ahkre ho pa kaxyw. ");
INSERT INTO apnNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Hãmri nẽ mẽ kãm: —Na mẽ ohtô rax nẽ kormã Tĩrtũm kapẽr mar kêt nẽ. No ãm kormã mẽ ate mẽ kãm harẽnh o apa kaxyw mẽ agrêre. Te pur kãm harôj kamrêk pa nẽ ãm tã no ãm kaxyw hikẽnh xwỳnh grêre pyràk. Jakamã kwa mẽ ho Tĩrtũm wỳ kê axte mẽ kaxyw mẽ hkwỳjê rê. ");
INSERT INTO apnNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","—E kot paj ma mẽ hwỳr mẽ arẽ. Ma mẽ hkôt mẽ ate Tĩrtũm kapẽr o mẽ ahkre ho ri apa kaxyw. Jakamã kot kaj mẽ te ate ôwêhti kot mry xoprê hwỳr amnhĩ to mrar nhũm kot hkwỳ hpar pyràk o amnhĩ nhĩpêx. Koja mẽ hkwỳjaja mẽ ate mẽ ahkre ma nhũm ja mẽ kêp omnuj nẽ nhũm mẽ hã tanhmã mẽ anhĩpêx to. Tã kêr ka mẽ tee ri amnhĩ kukamã ajamaxpẽr nẽ amã mẽ uma hkêt nẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","—Nẽ kêr ka mẽ hwỳr anojarêt nẽ amnhĩ kôt amrykà rỳ akawà rỳ aparkà hõ ho apa hkêt nẽ. Ãm anhỹ kamã ma mẽ hwỳr apa. Nẽ mẽ hwỳr mra nhũm mẽ nhỹri pry hã mẽ atõ kaxpa nẽ amã kapẽr o xa ka wa axpẽn mã akapẽr ry hkêt nẽ. Anojarêt kãm kãm akapẽr krãnre nẽ mẽ hakre nẽ ma krĩm apa. ");
INSERT INTO apnNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","—Nẽ kêr ka mẽ hwỳr pôj nẽ nhỹri mẽ õrkwỹ hwỳr agjê nẽ mẽ kãm: “Xà kot paj mẽ ato Tĩrtũm wỳ kê mẽ ato mex nẽ ka mẽ ajamakêtkati nẽ ri apa?” Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Hãmri nhũm mẽ ama nhũm ja mẽ kãm mex japêr nhũm mẽ hkĩnh nẽ amã: “ỳ kam nẽ mãmrĩ mẽ ixto awỳ.” Anẽ. Hãmri ka mẽ ama nẽ tanhmã mẽ ho Tĩrtũm wỳr to. No koja mẽ apê ja kaga ka mẽ ho hwỳr kêt nẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","—Nẽ kêr ka mẽ nhỹri mẽ õrkwỹ kamã mẽ hwỳr pôj hãmri nẽ mẽ hkôt ri apikamẽnh tãmtã nẽ akupỹm mẽ kurũm ajapôj nẽ ma hpãnhã krĩ hõ hwỳr apa. Nẽ mẽ axàmnhĩx mẽ kuri axàpkur o ri apa. Mẽmoj to akõm o ri apa. Ra mẽ ate mẽ ho mex pê mẽ kãm Tĩrtũm kapẽr o mẽ ahkre ho apa kênã. Jakamã kwãr mẽ mãmrĩ amnhĩ pãnhã mẽ amã mẽ axàpkur xà gõ ka mẽ kuri mẽ apku. ");
INSERT INTO apnNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","—Nẽ kêr ka mẽ nhỹri mẽ hwỳr pôj nhũm mẽ ato mex nẽ. Nẽ mẽ amã mẽmo mẽ apkur xà gõ ka mẽ mãmrĩ axàmnhĩx aku. Aa kormã mẽ ate mẽmojta kur kêt tã mãmrĩ ajamakêtkati nẽ aku. No tee ri amnhĩ kukamã tanhmã ajamaxpẽr to hkêt nẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","—Nẽ kêr ka mẽ ã mẽ kãm akapẽr anẽ nẽ mẽ kãm: “Tĩrtũm kãm mẽ ato hkra hprãm. Na hte amnhĩ wỳr mẽ awỳ.” Anẽ hãmri nẽ akupỹm mẽ kãm mẽ à xwỳnhjê ho mex. Ã kot kaj mẽ mẽ kãm amnhĩ nhĩpêx anhỹr o ri mẽ hkôt apa. ");
INSERT INTO apnNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","—Nẽ kêr ka mẽ nhỹri mẽ hwỳr pôj nhũm mẽ ãm mẽ apumu nẽ amnhĩ nhõrkwỹ hwỳr mẽ awỳr kêt japêr. Hãmri ka mẽ tee ri amnhĩ tã mẽ omu hãmri nẽ ra ma nhãm apa kaxyw. ");
INSERT INTO apnNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","Hãmri nẽ anojarêt nẽ mẽ kãm: “E mẽ inhma. Tĩrtũm kot mẽ pahwỳr mẽnh xwỳnhta na mẽ awỳr wa inhmẽ pa wa mẽ awỳr mõ. Wa ixte Tĩrtũm kapẽr o mẽ ajahkre kaxyw. Kãm mẽ ato hkra hprãm nhũm wa ixte mẽ amã harẽnh kaxyw na pa pre wa ã mẽ awỳr inhmõr anẽ. Tã ka mẽ harẽnh ma nẽ wa ixkaga. Jakamã kot paj wa jar mẽ anhõ krĩ kamã amnhĩ par kà hã awjagrô kapĩ. Mẽ ate Tĩrtũm kaga hã amnhĩ pumunh nhũm Tĩrtũm kot amnhĩ pyrà nẽ mẽ akaga hã mẽ ate omunh kaxyw kot paj wa mẽ anoo mã ã amnhĩ par kà hã awjagrô kapĩr anẽ. Kot kaj mẽ nhỹrmã tee ri ã amnhĩ nhĩpêx anhỹrja mã ajamaxpẽr nẽ akaprĩ htỳx kumrẽx kãm ga. Ãm hãmri na pa wa mẽ amã ja jarẽ.” Anhỹr o mẽ kãm akapẽr nẽ mẽ kêp ajapôj nẽ ma hpãnhã nhãm krĩ hõ hwỳr apa kurê kumrẽx. ");
INSERT INTO apnNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","—Koja nhỹrmã Tĩrtũm mẽ kot amnhĩ tomnuj mỳrapê tanhmã mẽ ho. Na pre ra ã krĩ pê Sotõ nhõ xwỳnhjê nhĩpêx anẽ. Na prem amnhĩ tomnuj tỳx o pa nhũm Tĩrtũm tanhmã mẽ kot amnhĩ tomnuj tỳx ã tanhmã mẽ ho. Tã jar mẽ kot kãm ixkapẽr mar prãm kêt nẽ mẽ kot ixkaga xwỳnhjaja. Koja Tĩrtũm ixtã mẽ omu nẽ kot Sotõ nhõ xwỳnhjê nhĩpêx pyràk o mẽ hipêx nom tanhmã mẽ ho htỳx o mẽ hakre. —E kêr ka mẽ ma krĩ hkwỳ hkôt apa nẽ ã mẽ kãm akapẽr anhỹr o ri apa. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","14","Tã nhũm Jejus krĩ hkwỳ nhõ xwỳnhjê mã kapẽr o xa nẽ mẽ kot amnhĩ tomnuj ã mẽ kãm akir. Krĩ pê Korajĩ mẽ Pesêj nhõ xwỳnhjê kumrẽx mã kapẽr nẽ mẽ kãm: —E mẽ inhma. Amnepêm krĩ pê Sitõ mẽ Xir wa kamã mẽ pa xwỳnhjaja na prem tanhmã amnhĩ tomnuj tỳx to ho pa nhũm Tĩrtũm mẽ omu nẽ hã mẽ homnuj tỳx nẽ. Tã kwa mẽ o kora Korajĩ mẽ Pesêj wa kamã mẽ apa xwỳnhjaja. Ra ixte mẽ amã mẽ ate mẽmoj pumunh kêt o anhỹr rax o ixpa htã ka mẽ omu nẽ arĩ amnhĩ tomnuj o ri apa nẽ tokyx amnhĩ tomnuj kaga hkêt nẽ. Jakamã kot kaj mẽ amex kêt nẽ. Kop apu Sitõ rỳ Xir kamã mãn ixte mẽ kãm aa mẽ kot mẽmoj pumunh kêt kwỳ ho anhỹr o ri ixpa ronhỹx mẽ omu nẽ mẽ arom amnhĩ kaxyw ixkôt hamaxpẽr kurê kumrẽx. Nẽ tee ri tanhmã amnhĩ tomnuj to ho pa hã amnhĩ pumu nẽ hkaprĩ nẽ ã amnhĩ nhĩpêx anhỹr kaga hpa. No mẽ kajaja na pa tee ri mẽ amã tanhmã amnhĩ nhĩpêx to ho ri ixpa kaprỳ. Ka mẽ ja hã ixpumu nẽ ãm ixpumu nẽ amnhĩ tomnuj kaga hkêt nẽ. Tã koja nhỹrmã Tĩrtũm mẽ piitã mẽ kot amnhĩ tomnuj mỳrapê tanhmã mẽ hipêx to. Hãmri nẽ tanhmã Sitõ mẽ Xir wa kamã mẽ pa xwỳnhjê jarẽnh to nhũm mẽ kot amnhĩ tomnuj mỳrapê amnhĩ xà htỳx kamã hamak o ri pa. No mẽ kajaja mẽ ate amnhĩ tomnuj tỳx o mẽ hakrenh jakamã koja Tĩrtũm mẽ hkĩnhã mẽ atomnuj tỳx o mẽ atomnuj tỳx. Ka mẽ amnhĩ xà htỳx kamã ajamak rãhã ho ri apa ho apa. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Nhũm pre ã Jejus mẽ kãm kapẽr anẽ. Hãmri nẽ hpãnhã Kapanaũ nhõ xwỳnhjê mã kapẽr nẽ mẽ kãm: —No mẽ apê Kapanaũ nhõ xwỳnhjaja. Kot kaj mẽ ajaxwỳja mẽ amex kêt nẽ. Mẽ ate amnhĩ tomnuj kagare pyrà nẽ Tĩrtũm nhõ krĩ hwỳr akrà ho apa. Nom kot kaj mẽ atõ hwỳr axàpir kêt nẽ. Kot kaj mẽ ma kuwy maati hwỳr ajapêx pa kãm ga. ");
INSERT INTO apnNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Anhỹr o mẽ kãm kapẽr hãmri nẽ hpãnhã hkôt mẽ pa ho mẽ pa xwỳnhjê mã kapẽr nẽ mẽ kãm: —Kot kaj mẽ Tĩrtũm kapẽr o mẽ ahkre ho ri apa nhũm mẽhõ ama nẽ akapẽr kôt amnhĩ nhĩpêx. Hã koja te pa kot ixkôt amnhĩ nhĩpêx pyràk o amnhĩ nhĩpêx. No koja amar kêt nẽ akaga hãmri nẽ te pa kot inhmar kêt nẽ ixkaga pyràk o amnhĩ nhĩpêx. Jao mããnẽn Tĩrtũm kaga. Anẽ hãmri nhũm mẽ kuma hãmri nẽ anhgrà nẽ axkrut kapẽn nẽ ma ahpỹnhã krĩ hkôt anhgrà. ");
INSERT INTO apnNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Tã nhũm mẽ kêp 72jaja krĩ hkwỳ rũm akupỹn Jejus wỳr pôj. Piitã hkĩnh nẽ hpôx pa. Hãmri nẽ kãm: —Kwa Pahihti. Na pa prem anhỹ hã mẽ nê mẽkarõmnuti japôx rax nẽ. Na pa prem mẽ nê mẽ hano nhũm mẽ ãm mẽ kurũm hapôx kurê kumrẽx. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Hãmri nhũm mẽ kuma nẽ mẽ kãm: —Tôe. Ixàhpumunh tỳx o ixte Satanasti jakrenh jakamã na ka htem inhỹ hã mẽ hano nhũm mẽ tee ri mẽ akutã hihtỳx prãm. Hãmri nẽ te na haxênh prêprêk pyràk o amnhĩ nhĩpêx nẽ mẽ kurũm hapôx kurê kumrẽx pa ja hã mẽ omu. ");
INSERT INTO apnNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","20","Mẽkarõmnuti te kot kagã xoprê rỳ te kot makre pyràk. Tã ra ixte mẽ amã ixàhpumunh tỳx xà hkwỳ nhõr jakamã na ka prem mẽ kãm akapẽr nhũm mẽ tee ri akutã tanhmã amnhĩ tỳx to hprãm. Tã koja Satanasti tee ri mẽ ate nhỹrmã Tĩrtũm mẽ wa ixri atĩr tũm nẽ apa pymaj tanhmã mẽ ano kupyr to kaprỳ. Ra Tĩrtũm kot õ kagà kamã mẽ atĩr tũm nẽ mẽ apa kaxyw mẽ anhĩxi hã kagà kênã. Jakamã kwa mẽ jam ajamaxpẽr o akĩnh nẽ ajamakêtkati nẽ ri apa. No kêt mẽkarõmnuti kot mẽ akapẽr mar nẽ mẽ kurũm hapôxta ã mẽ omunh xà hkôt pix mã akĩnh nẽ ri apa hkêt nẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Tã nhũm Tĩrtũm Karõ tanhmã Jejus to nhũm ỹ hã hkĩnh nẽ xa. Hãmri nẽ Tĩrtũm mã kapẽr nẽ kãm: —Pa Papaj? Nà apê mẽ ixpiitã mẽ inhõ Pahi Maati na ka. Pikap ri mẽ pa xwỳnhjaja nẽ kaxkwa kamã mẽ pa xwỳnhjaja apê mẽ ixpiitã mẽ inhõ Pahi Maati na ka. Ãm hãmri na ka hte amnhĩ nhĩpêx mex o ri apa. Na ka hte mẽ àhpumunh tỳx ã mẽ kot amnhĩ jarẽnh xwỳnhjê mã axàhpumunh tỳx o amnhĩrĩt kêt nẽ. Ãm mẽ àhpumunh kêt ã mẽ kot amnhĩ jarẽnh xwỳnhjê pix mã na ka hte ja ho amnhĩrĩt nhũm mẽ tapxipixjaja ja hã apumu. Ãm hãmri na ka hte amã hprãm xà hkôt ã mẽ piitã mẽ hipêx anhỹr o ri apa. Jakamã mẽ kot amnhĩ to hkryre xwỳnh pixjaja na htem ate amnhĩ nhĩpêx ã apumunh o pa. ");
INSERT INTO apnNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","—Na ka pre inhĩhkra kamã mẽmoj piitã haxàr pa. Ixte ho amnhĩptàr o ri ixpa kaxyw. Jakamã kapxipix na ka hte ixpê akra hã ixpumunh par. No jar ri mẽ pa xwỳnhjaja na mẽ kot ja hã ixpumunh kêt. Nẽ mããnẽn papxipix na ixte ate tanhmã amnhĩ nhĩpêx to hã apumunh par. Jakamã na pa hte ã amnhĩ nhĩpêx anẽ nẽ inhmã hprãm xà hkôt mẽ hkwỳjê mã ato amnhĩrĩt o ri ixpa nhũm mẽ ixpyrà nẽ ate tanhmã amnhĩ nhĩpêx to ho apa hkôt apumu. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","24","Nhũm pre Jejus ã Tĩrtũm mã amnhĩ jarẽnh anẽ hãmri nẽ hpãnhã hkôt mẽ pa ho mẽ pa xwỳnhjê mã kapẽr nẽ mẽ kãm: —E na ka htem ixkôt mẽ ano ho ixte tanhmã amnhĩ nhĩpêx to hã ixpumunh o ri apa. Nẽ mẽ ajamak o ixkapẽr mar o ri ixkôt apa. No amnepêm mẽ akukamã pahijaja nẽ Tĩrtũm nhỹ hã kapẽr jarẽnh o ri mẽ pa xwỳnhjaja kãm ixpumunh prãm tỳx o pa htã mẽ akĩnhã ixpumunh kêt rãhã htyk pa. Kormã ixwrỳk nẽ jar ixkator kêt jakamã na prem ixpumunh kêt rãhã ty. Nẽ mẽ kãm ixkapẽr mar prãm tã mẽ akĩnhã ixkapẽr mar kêt nẽ. Ãm mẽ kapxipixjaja na ka mẽ mỳr pê ixte amnhĩ nhĩpêx ã ixpumunh nẽ ixkapẽr mar o ixkôt apa. Tã mẽ kurom mẽ ate ano ho ixpumunh nẽ ajamak o ixkapẽr mar jakamã kwa mẽ ja hã amnhĩ pumu nẽ tãm amnhĩ nhĩpêx o akĩnh nẽ ri apa. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Tã nhũm Tĩrtũm kapẽr tũm o mẽ ahkre o mẽ pa xwỳnhja Jejus wỳr tẽ nẽ hêx rom kot kamã hamak kaxyw kãm: —Pa? E kwa inhmã mẽmoj jarẽ. Tanhmã kot paj we nhỹrmã Tĩrtũm ri ixtĩr tũm nẽ ixpa kaxyw amnhĩ nhĩpêx to wehe? Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Hãmri nhũm kãm: —Tanhmã na ka hte Tĩrtũm kapẽr ã kagà htũm kot mẽ htĩr tũm nẽ pa hã kagà kamã harẽnh nẽ mar to? Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Hãmri nhũm kãm: —Nà harẽnh kot: Kêr ka mẽ anhĩ piitã ho amã Tĩrtũm kĩnh o ri apa. Mẽ amã hkĩnh tỳx o mẽmoj piitã hakrenh par o ri apa. Nẽ kêr ka mẽ amã mẽ piitã hã ma ho te ka amã amnhĩ tã ma pyràk o mẽ hipêx o ri apa. Jao tãm mẽ hipêx o ri apa. Anẽ. Ã Tĩrtũm kapẽr ã kagà htũm kamã ja jarẽnh kot anhỹr. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Hãmri nhũm Jejus kuma nẽ kãm: —Tỳ. Nà ãm hãmri na ka harẽ. Kot kaj ã mẽ hipêx anhỹr o ri apa nẽ nhỹrmã Tĩrtũm mẽ wa ixri atĩr tũm nẽ apa ho apa. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Hãmri nhũm kuma nom kãm mẽ piitã mẽ ho mex prãm kêt nẽ. Ãm amnhĩ kwỳ pixjaja nhũm kãm mẽ ho mex o pa hprãm. Jakamã hêx rom kãm: —Kwa no mẽmojaja kot pa we ri ã mẽ hipêx anhỹr o ri ixpa? Xà mẽ pahkwỳ pê Ijaew pixjaja nà? Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Hãmri nhũm kuma nẽ tanhmã kãm ujarẽnh to. Nom hã kuxi nẽ kãm awjarẽ nẽ kãm: —E pa amã awjarẽ ka inhma. Koja Ijaew nhõ xwỳnhja ma Jerujarẽ rũm Jeriko hwỳr ahpar mã ma mõ. Mõõ nhũm ra mẽ ahkĩnh xwỳnhjaja kutã mra. Hãmri nẽ pry kahti ri hwỳr kato nẽ unê nẽ htak rax nẽ. Nẽ kêp ê hkwrỳnh pa nẽ ma kurũm hprõt nẽ mra nẽ akunok nhũm mẽ kot htak o hkà rênh rãhã ra htyk kaxyw nẽ nõ. ");
INSERT INTO apnNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Hãmri nhũm patreja tẽ nẽ omu. No ãm omunh o hãnh tẽ nẽ hkupu nẽ ma tẽ. Uràk nẽ kêp Ijaew tã ãm omu nẽ tanhmã ho ajuta hto hkêt nẽ hãnh omunh o tẽ nẽ hkupu nẽ ma tẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Hãmri nhũm patre ho ajuta xwỳnhja mããnẽn tẽ. Nẽ patre pyrà nẽ omu nẽ ãm omu nẽ hkupu nẽ ma tẽ. Uràk nẽ kêp Ijaew tã omu nẽ ãm omu nẽ hkupu nẽ ma tẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","—Tã nhũm Samar nhõ xwỳnhja mããnẽn mõ. Samar nhõ xwỳnhjê mẽ Ijaew na prem kãm axpẽn kĩnh kêt tã nhũm mõ nẽ omu nẽ kamã ukaprĩ nẽ. Kêp Ijaew ã omunh tã tee ri omu nẽ kamã ukaprĩ nẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Hãmri nẽ hwỳr tẽ nẽ omu nẽ kãm mẽ kot htak o hkà rênh xà kane nẽ kãm hkupu pa. Hãmri nẽ kànhmã ãm nẽ hkrit jumẽnre hã kumẽ nẽ ma nhỹri mẽ kot amnhĩm hikranh xà hã ixkre hwỳr o mõ nẽ hwỳr o pôj. Hãmri nẽ omunh mex o apkati. ");
INSERT INTO apnNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Hãmri nẽ akupỹm nojarêt nẽ kàxpore hkwỳ jamỳ nẽ o tẽ nẽ kot mẽ kãm õ xwỳnhja mã kugõ nẽ kãm: “E kot paj hãmri ma mõ. Ota ixkàxporeta. Kêr ka inhmã à xwỳnhta tãnopxar mex nẽ. Nẽ inhmã omunh mex kê akupỹm mex. Koja kàxporeja apê grire hã kot paj nhỹrmã akupỹn mõ nẽ axte hkôt amã hkwỳ gõ.” Anhỹr o kãm kapẽr nẽ ma akupỹm mõ. Ã mẽ ujarẽnh kot anhỹr. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Nhũm pre ã Jejus kãm ujarẽnh anẽ. Hãmri nẽ kãm: —E nhỹ na pre kãm mẽ kot htak xwỳnhta kaprĩ ho te tãm kãm amnhĩ tã ma pyràk wehe? Anẽ. Hãmri nhũm Tĩrtũm kapẽr tũm o mẽ ahkre xwỳnhta kãm: —Nà kot kamã ukaprĩ xwỳnhta na pre omu nẽ kamã ukaprĩ nẽ ho mex o te tãm kãm amnhĩ tã ma pyràk o hipêx. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Hãmri nhũm Jejus kãm: —Tỳ. Nà ãm hãmri na ka harẽ. Uràk nẽ kêp Ijaew kêt tã kamã ukaprĩ nẽ ho mex nẽ. Tã kêr ka uràk nẽ ã mẽ piitã mẽ hipêx anhỹr o ri apa. Uràk nẽ mẽ kêp akwỳ hkêt tã mẽ kamã axukaprĩ ho ri apa. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Tã nhũm Jejus krĩ rũm kato hãmri nẽ hkôt mẽ pa ho mẽ pa xwỳnhjê mẽ mẽ ma nhãm krĩ hõ hwỳr mõ. Mõõ nẽ hwỳr pôj. Hãmri nhũm Matre mẽ omu nẽ amnhĩ nhõrkwỹ hwỳr mẽ kuwỳ nhũm mẽ ma hwỳr mõ nẽ õrkwỹ hwỳr pôj. ");
INSERT INTO apnNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Hãmri nhũm Jejus mẽ ahkre ho nhỹ nhũm Matre htõx Marirja arĩ hpar pê mar o nhỹ. ");
INSERT INTO apnNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Hãmri nhũm Matre mẽ hwỳr axà nẽ omu. Nẽ tee ri àpênh rax kukamã hamaxpẽr nẽ Jejus wỳr tẽ nẽ kãm: —Xê ma Pahihti. Kormã ixàpênh rax tã nhũm Marir ixto ajuta hkêt nẽ. Ãm akapẽr pix mar gryk ã ixkôt htẽm nẽ ixto ajuta hkêt nẽ. Pa ahte mẽ panhõ hã ixàpênh o xa. Xà amã ja mex? Xê kãm anẽ kê tokyx ixkôt tẽ pa wa hã axkrut nẽ mẽ panhõ hã ixàpênh tokyx anẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Hãmri nhũm tee ri kuma nẽ kãm: —Kwa Matre. Na ka ãm mẽ panhõ pix kukamã ri ajamaxpẽr nẽ gryk ã tee ri amnhĩ nhĩpêx. ");
INSERT INTO apnNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","ãm hãmri na Marir kãm ixkapẽr mar prãm nẽ. Jakamã kot paj ri amnhĩ nê akôt hanor kêt nẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Tã nhũm apkati hõ hã nhũm Jejus nhỹri Tĩrtũm mã amnhĩ jarẽnh o nhỹ. Nẽ kãm amnhĩ jarẽnh pa nhũm hkôt mẽ pa ho mẽ pa xwỳnhjaja kot kãm amnhĩ jarẽnh ã omu nẽ hwỳr mra nẽ kãm: —Kwa Pahihti. Amnhĩ pyrà nẽ mẽ ixte Tĩrtũm mã amnhĩ jarẽnh kaxyw tanhmã mẽ ijahkre hto. Kêr pa mẽ apyrà nẽ tanhmã kãm amnhĩ jarẽnh to ho ri ixpa. Na pre finat Juãw Paxisja hkôt mẽ pa ho mẽ pa xwỳnhjê mã ja jahkre nhũm mẽ kuma nẽ tãm kãm amnhĩ jarẽ. E kwa mẽ inhmã tanhmã ja jahkre hto nà? Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Hãmri nhũm mẽ kãm: —Tôe. Nà kêr ka mẽ kãm amnhĩ jarẽnh kaxyw nẽ mãmrĩ amnhĩ krã hkôt tanhmã kãm amnhĩ jarẽnh to. Rỳ kãm amnhĩ jarẽnh o: Pa Mẽinhĩpêêxà maati? Nà amex o amex Tĩrtũm. Apê mẽ ijamãr mex xwỳnh maati na ka. ");
INSERT INTO apnNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Nẽ kwa kêr ka apkati mẽ mẽ inhmã mẽmo gõ pa mẽ akukwak ri ho ixàpkur o ri ixpa. ");
INSERT INTO apnNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Nẽ na pa hte tõhã amnhĩ tomnuj nẽ Tĩrtũm. Nom mẽ kot tanhmã ixtomnuj to xwỳnhjaja na pa hte ãm mẽ omu nẽ amnhĩ tã tanhmã mẽ ho hkêt nẽ. Nẽ ja ho ijamakêtkati kurê kumrẽx. Ã na pa hte amnhĩ nhĩpêx anhỹr o ri ixpa. Jakamã kwa kêr ka ja hã ixpumu nẽ ixpyrà nẽ ixte tanhmã amnhĩ tomnuj to hã ixpumu nẽ hã tanhmã ixto hkêt nẽ. Ãm ho ajamakêtkati kurê kumrẽx nẽ axte kãm ajamaxpẽr kêt nẽ. Nẽ kot paj tanhmã amnhĩ tomnuj to kaxyw japêr ka ja hã ixpumu nẽ ixte ã amnhĩ nhĩpêx anhỹrja nê ixto htỳx nẽ pa ja ho anhỹr kêt nẽ. E ãm ja pix na hapêx. Anẽ. E kêr ka mẽ ã Tĩrtũm mã amnhĩ jarẽnh anhỹr o ri apa. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","6","Nhũm Jejus arĩ hkôt mẽ pa ho pa xwỳnhjê jahkre ho nhỹ nẽ mẽ kãm: —Nẽ ja. Koja mẽ akràmnhwỳjê hõ. Nhũm kôt ã kamàt nhũm nhỹhỹnh awỳr mõn pôj. Ka anhõ mẽmoj kêt hãmri nẽ anhĩjuk ri akràmnhwỳ hwỳr tẽ. Hãmri nhũm ra amnhĩ tã kahê nẽ nõ. Ka tee ri omu hãmri nẽ hakwa krem xa nẽ kãm akapẽr nẽ kãm: “Pa ixkràmnhwỳ. Na ka mẽ ra gõr? Kwa kànhmã nhỹ nẽ inhmã anhõ mẽmoj japêr. Na ra ham ixkràmnhwỳta mõn pôj. Nẽ kãm prãm tỳx nẽ mõ nom kaxyw inhõ hkêt. Kwa kànhmã nhỹ nẽ inhmã anhõ mẽmoj japêr nẽ inhmã hkwỳ pa ma o tẽ kê kukrẽ. Ãm inhõ hkêt kumrẽx. Ãm hãmri na pa amã amnhĩ jarẽ. Kwa tokyj kànhmã nhỹ nẽ inhmã mẽmoj japêr nà?” Anhỹr o kãm akapẽr. ");
INSERT INTO apnNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Hãmri nhũm ama nom kãm kànhmã ỹr prãm kêt nẽ. Nẽ amã: “Tk. Nà ra mẽ ixte amnhĩ tã kahê hpar nẽ inhĩkwỹ kênã kot pa kêt kànhmã nhỹ nẽ amã mẽmoj japêr.” Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Ka tee ri ama nẽ xatã kãm: “Kwa ã inhĩpêx anhỹr kêt nẽ ixkràmnhwỳ. Kwa tokyx.” Anhỹr o xa. Nẽ xatã kãm anojarêt o xa. Hãmri nhũm ra kãm amar kaga hãmri nẽ tã kànhmã nhỹ nẽ amã ate ho presija xwỳnhta gõ. No ãm kêp akràmnhwỳ hã ate hã axàhwỳr tipxi hã amã õr kêt nẽ. Ãm xatã ate ho presija htỳx xwỳnhja mã hamaxpẽr nẽ tã kànhmã nhỹ nẽ amã kugõ. Ã mẽ ujarẽnh kot anhỹr. ");
INSERT INTO apnNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","10","—Tã kêr ka mẽ ja pyrà nẽ amnhĩ to Tĩrtũm wỳr rãhã ho ri apa nhũm ama nẽ ate mẽmoj tã hwỳrta amã kugõ. Ãm xatã ate hã axàhwỳr o ri apa nhũm amã kugõ. Ãm mẽmoj to hwỳr rãhã ho ri apa nhũm ama hãmri nẽ amã mẽmoj tanhmã hipêx to. Te ho mẽhõ kãm tep xành nẽ gôx kãm xatã tep rẽnh xà rẽnh o ãm pyrà nẽ xatã mẽmoj tã hwỳr o ri apa. Hãmri nhũm ama nẽ amã hprãm xwỳnhta gõ. Te ho tep kanhêr xwỳnhta tã kot tep õ kanhêr pyràk o anhĩpêx nẽ amã mẽmoj prãm xwỳnhta gõ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Nhũm Jejus arĩ hkôt mẽ pa ho mẽ pa xwỳnhjê jahkre nẽ mẽ kãm: —Nẽ xà koja akra kãm tep xành nẽ hã awỳ ka ama nẽ axtem nẽ kãm kagã xoprê hõ py nẽ agõ? ");
INSERT INTO apnNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Rỳ nhũm krãhyre gre hã awỳ ka axtem nẽ kãm makre hõ py nẽ agõ? Nà na ka htem ã akrajê nhĩpêx anhỹr kêt nẽ. Na ka htem mẽ kot mẽmoj tã àhwỳr xà hkôt kãm mẽmoj gõ. ");
INSERT INTO apnNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Mẽ kamjaja mẽ ate amnhĩ tomnuj o ri apa htã ka htem akrajê ho mex o ri apa. Tã kaxkwa kamã Tĩrtũmja na hte mẽ pahto mex o mẽ ate mẽ akrajê ho mexta jakrenh. Kãm mẽ pajapê htỳx kôt na hte mẽ pamã mẽmoj mex nhõr o pa. Nẽ mããnẽn amnhĩ Karõja na hte mẽ pamã kugõ. Jakamã kot kaj mẽ atõ Karõ hã awỳ nhũm ama nẽ awỳr kumẽ nhũm wrỳ nẽ akarõ mã axà. Ã na hte Tĩrtũm kãm mẽ pajapê xàj mẽ pamã mẽmoj mex nhõr o pa anẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Tã nhũm Jejus nhỹri axte mẽhõ nê mẽkarõmnuti kator. Na pre ra mẽkarõmnuti tanhmã ho nhũm kapẽr kêt nẽ pa. Hãmri nhũm Jejus omu nẽ nê kator nhũm akupỹm kapẽr mex nẽ. Nhũm mẽ piitã amnhĩ jaêr pê omu nẽ no hawênh rũnh nẽ omunh o kuhê. ");
INSERT INTO apnNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Nom nhũm mẽ hkwỳjaja Jejus kot ã hipêx anhỹr ã omu nẽ htỳx ho kêp mẽkarõmnuti hkwỳ hã hkamnhĩx nẽ axpẽn mã harẽnh o: —Tk pẽr hinhu nhĩkôôti nhỹ hã na hte mẽ nê amnhĩ kwỳjê japôx o pa. Anẽ. Hinhu nhĩkôôti nhĩxi hõ pê Satanasti nhũm prem Satanasti nhỹ hã Jejus kot ã amnhĩ nhĩpêx anhỹr o pa hã hkamnhĩx. ");
INSERT INTO apnNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Jakamã nhũm mẽ hkwỳjaja hwỳr mra nẽ kãm: —Kwa mẽ inhmã aa mẽ ixte mẽmoj pumunh kêt õ ho anẽ. Pa mẽ omu nẽ ate Tĩrtũm nhỹ hã tanhmã amnhĩ nhĩpêx to ho apa hã apumunh kurê kumrẽx. Anẽ. Nom hêx rom mẽ kot kamã hamak kaxyw ã kãm kapẽr anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Nhũm ra Jejus mẽ hamaxpẽr kôt mẽ omunh mex jakamã mẽ kapẽr ma nẽ mẽ kãm: —Kwa mẽ inhma mẽ ate ixpê Satanasti hkwỳ hã ixkamnhĩx xwỳnhjaja. Koja pika nhõ xwỳnhjaja axpẽn kutã amnhĩ xunhwỳ nẽ axpu hãmri nẽ anhgrà nẽ ma ahpỹnhã ri pa. Hãmri nẽ amnhĩ krã hkôt ri tanhmã amnhĩ to ho ri pa. Jakamã nhũm mẽ õ pahi mẽ hamãr o pa hkêt nẽ. Rỳ koja krĩ nhõ xwỳnhjaja. Mẽ kot axpẽn to hkwỳ xwỳnhjaja mẽmoj tã axpẽn kãm gryk nẽ axpẽn kutã amnhĩ xunhwỳ hãmri nẽ axpẽn pê anhgrà nẽ ahpỹnhã pa hãmri nhũm mẽ õ pahi tee ri kãm mẽ hamãr o pa hprãm. Mo õ krĩ kamã mẽ hkwỳ kot ri mẽ hamãr o pa? No na pre mẽ õ pahi tãm amnhĩ nê mẽ hanor kêt nẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","—Tã ja pyrà nẽ ixte Satanasti nhỹ hã tanhmã amnhĩ nhĩpêx to ho ixpa ronhỹx pa mẽ nê amnhĩ kwỳjê janor o ri ixpa hkêt nẽ. Nhỹx Satanasti ixte mẽ nê mẽ hanor kaxyw tanhmã inhmã nẽ hkêt nẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","—No kêt mẽ akwỳjaja? Xà Satanasti nhỹ hã na htem mẽ nê mẽ hapôx o pa nà? Kêp apu pa ixte ỹ hã mẽ nê mẽ hapôx ronhỹx mẽ akwỳjaja ixpyrà nẽ ỹ hã mẽ nê mẽ hapôx o pa. Nà Tĩrtũm nhỹ hã mẽ ixte mẽ nê mẽ hapôx o mẽ ixpa kênã. Jakamã ã mẽ ate ijarẽnh anhỹr o apaja mex kêt. ");
INSERT INTO apnNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Tĩrtũm Karõ nhỹ hã ixte mẽ nê mẽ hapôx o ri ixpa kênã. Jakamã kwa mẽ ja hã ixpumu nẽ Tĩrtũm kot ixte mẽ ato amnhĩptàr kaxyw mẽ awỳr inhmẽnh kôt ixpumunh kurê kumrẽx kêt wehe. Pa na ka htem ixkamã ajamak o apa. ");
INSERT INTO apnNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","22","—Satanastija àhpumunh tỳx jakamã na htem tee ri kêp mẽ kot hkôt amnhĩ xunhwỳr xwỳnhjê pytàr kaxyw nhũm mẽ nê mẽ omunh mex nẽ. Nom ixàhpumunh tỳx o ixte Satanasti jakrenh jakamã pa na pa hte kêp mẽ utà nhũm mẽ hpãnhã ixkôt ri amnhĩ nhĩpêx. ");
INSERT INTO apnNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","—Mẽ amã ixkapẽr mar prãm tã na ka mẽ kormã ixkôt amnhĩ xunhwỳr kêt nẽ. Kwa wem ma amnhĩ to amõr gri nẽ tokyx ixkôt amnhĩ xunhwỳ kêt wehe. Kot kaj mẽ anhỹr kêt nẽ hãmri nẽ te mẽ ate ixkutã amnhĩ xunhwỳr xwỳnh pyràk o amnhĩ nhĩpêx. ");
INSERT INTO apnNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Mẽ ate ixkôt amnhĩ xunhwỳr kêt xwỳnhjaja te mẽ ate mẽhõ nê mẽkarõmnuti japôx xwỳnh pyràk. Nhũm te kêp kator nẽ ma mõ nẽ nhỹri amgrà kamã ri pa. Nhũm ja kêp omnuj nhũm tee ri kamã nhỹri hkôkôt xà japêr o pa. Nom tee ri hapêr o pa nẽ hamaxpẽr o: “E kot paj ma akupỹm mẽ kot nê ixkator xwỳnhta wỳr tẽ nẽ hwỳr axà nẽ hkôt mãn ixpa.” Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Hãmri nẽ ma akupỹm hwỳr tẽ. Nom kormã akupỹm hwỳr àr kêt ri nhũm kamã amrakati nẽ pa. ");
INSERT INTO apnNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Jakamã nhũm ma akupỹm hwỳr tẽn axà. Nom ahte àr kêt nẽ. Ra amnhĩ kôt amnhĩ kwỳjê ho 7 nẽ hwỳr mẽ ho agjê. Nẽ hwỳr gjêx pa. Mẽ kêp 7jaja nẽ wamta mẽ nhũm mẽ piitã hwỳr gjêx pa. No mẽ kêp 7jaja omnuj tỳx o kot wamta jakrenh jakamã nhũm mẽ kot hwỳr gjêx xwỳnhta mẽ ỹ hã amnhĩ tomnuj tỳx o pa. Oprê htỳx nẽ. Wam pyxire nẽ kot hwỳr àr nhỹ hã amnhĩ tomnuj o ri pa nom ãm kawax pê oprê. Tã axte hwỳr mẽ ohtô nẽ gjêxta nhỹ hã oprê htỳx kumrẽx. Ja pyrà nẽ kot kaj mẽ tokyx ixkôt amnhĩ xunhwỳr kêt nẽ hãmri nẽ ãm amnhĩ tomnuj tỳx pix o ri apa. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Nhũm pre ã Jejus mẽ ahkre anẽ nhũm mẽhõ nija kuma nẽ kãm: —Hêxta gàà nẽ. Mãn akatorxà ã ate amnhĩ nhĩpêx anhỹr o apa hã apumu nẽ hkĩnh nẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Hãmri nhũm kãm: —Tỳ. Nà kot anhỹr kênã. Nom kot ka mẽ atõ Tĩrtũm kapẽr ma nẽ hkôt amnhĩ nhĩpêx hãmri nẽ akĩnh rax o ixkatorxà kot ixpumunh nẽ hkĩnhta jakre. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Tã nhũm mẽ ohtô nẽ Jejus ã akuprõ nẽ mẽmoj tã kuwỳ nẽ kãm: —Pa. Kwa mẽ inhmã aa mẽ ixte mẽmoj pumunh kêt õ ho anẽ pa mẽ omu. Anẽ. Hãmri nhũm mẽ kuma nẽ mẽ kãm: —Tk. Kwa mẽ ajamaxpẽr punuj pix o na ka htem ri ajamaxpẽr o apa. Ixpê Tĩrtũm kot mẽ awỳr inhmẽnh xwỳnh tã ka mẽ ja hã ixkôt ajamaxpẽr kêt nẽ. Tã mẽ ate aa mẽmoj pumunh kêt kwỳ ixte mẽ amã ho anhỹr kaxyw hã inhmã karõ. Nà kot paj kormã mẽ amã ho anhỹr kêt nẽ. Kot paj nhỹrmã te amnepêm finat Jõhti kot amnhĩ nhĩpêx pyràk o amnhĩ nhĩpêx ka mẽ hã ijarẽnh ma nẽ kormã ja hã ixpumu. ");
INSERT INTO apnNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Tĩrtũm nhỹ hã kapẽr xwỳnh pê Jõhtija amnepêm na pre tep rax kukrẽ. Tã nom nhũm htĩr rãhã õxàhkre rũm kato nhũm mẽ omu nẽ Tĩrtũm kot mẽ hwỳr mẽnh ã omu. Tã kot paj nhỹrmã Jõhti pyrà nẽ tanhmã amnhĩ nhĩpêx to nhũm mẽ ja hã ixpumu nẽ Tĩrtũm kot mẽ awỳr inhmẽnh xwỳnh ã ixpumunh kurê kumrẽx. ");
INSERT INTO apnNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","—Nẽ koja nhỹrmã Tĩrtũm akupỹm mẽ htyk nẽ mẽ hikwỹ xwỳnh piitã akupỹm mẽ ho htĩr hãmri nhũm mẽ piitã Inhĩpêêxà mẽ wa ixkutã hkrĩ. Pa wa mẽ piitã tanhmã mẽ harẽnh to. Tĩrtũm mẽ wa ixkuri mẽ htĩr tũm nẽ mẽ pa ho mẽ pa mã xwỳnh ã mẽ hkwỳjê jarẽ. Nẽ wa ixkuri mẽ pa ho mẽ pa hkêt xwỳnhjê jarẽ. Mẽ piitã ã mẽ harẽnh anẽ. Amarĩ mẽ pa xwỳnhjaja nẽ mẽ õ pahijaja. Hãmri nhũm sur kãm mẽ õ pahi niti Tĩrtũm mã tanhmã amnhĩ jarẽnh to hãmri nẽ hpãnhã tanhmã mẽ ajarẽnh to nẽ kãm mẽ ajarẽnh o: “Na pa pre inhmã pahi Sarumãw kot anhỹ hã àhpumunh tỳx ã harẽnh ma hãmri nẽ inhmã mar prãm xàj ma awry hã õ pika hwỳr ixpa nẽ omu nẽ kapẽr ma. Hãmri nẽ ma akupỹm inhõ pika hwỳr ixpa nẽ ixkwỳjê mã àhpumunh tỳx ã harẽnh o ixpa. Tã Akra Jejus na àhpumunh tỳx o pahi Sarumãw jakrenh tã or war akutã mẽ hkrĩ xwỳnh kwỳ mũj na prem kapẽr ma no ãm ixkĩnhã kãm mar prãm kêt nẽ. Na prem kuma nẽ ãm kuma.” Anhỹr o wa inhmã mẽ ajarẽ. Hãmri nẽ ja hã mẽ amã akir ka mẽ tee ri mar o akrĩ nẽ amnhĩ kamã agryk o akrĩ. ");
INSERT INTO apnNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","—Hãmri nhũm hpãnhã Nĩnĩwe nhõ xwỳnhjaja wa inhmã tanhmã amnhĩ jarẽnh to. Jõhti kot mẽ hwỳr mõr nẽ mẽ kãm Tĩrtũm kapẽr jarẽnh o pa xwỳnhjaja nhũm mẽ tanhmã wa inhmã amnhĩ jarẽnh to. Hãmri nẽ pahi nita pyrà nẽ wa inhmã tanhmã mẽ ajarẽnh to nẽ wa inhmã: “Na pre Jõhti man mẽ inhõ krĩ hwỳr mõ nẽ mẽ inhmã akapẽr jarẽnh o ri mẽ ixkôt pa. Pa prem kuma nẽ mẽ ixte amnhĩ tomnuj kaga nẽ akôt amnhĩ xunhwỳr kurê kumrẽx Tĩrtũm. Nom or war akutã mẽ hkrĩ xwỳnh kwỳ mũj na pre Akra Jejus tãm mẽ hwỳr mõ nẽ mẽ kãm kapẽr o ri mẽ hkôt pa nhũm prem kuma no ãm mẽ ixkĩnhã amnhĩ tomnuj kaga nẽ hkôt amnhĩ xunhwỳr kêt nẽ. Mẽ kot Akra mar tã amnhĩ kaxyw kãm hamaxpẽr kêt nẽ.” Anhỹr o koja mẽ wa inhmã mẽ ajarẽ ka mẽ tee ri mẽ ama nẽ amnhĩ kamã agryk tỳx nẽ. Jakamã e kwa ixte mẽ amã ã ixkapẽr anhỹrja ma nẽ kãm ajamaxpẽr tỳx rãhã ho ri apa. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Nhũm Jejus arĩ mẽ ahkre ho nhỹ nẽ mẽ kãm: —Xà na htem kanê hpôk nẽ poti ho hpro? Nà na htem ho anhỹr kêt nẽ. Na htem hpôk nẽ kỳx pê mẽmoj nhĩmõk ã unhwỳ nhũm mẽ piitã mẽ kãm hirã mex nhũm htem ixkrem agjê nẽ hirã kamã mẽmoj pumunh mex o mra. ");
INSERT INTO apnNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Ja pyrà nẽ kot ka mẽ atõ ixkapẽr ma nẽ ixkôt amnhĩ nhĩpêx nẽ tãm amnhĩ nhĩpêx o ri apa. Nẽ tãm mẽ hipêx o ri apa. Jao te hirã kamã mẽ rĩt mex xwỳnhjaja kot amnhĩ nhĩpêx pyràk. Nom koja mẽhõ inhma nẽ ãm inhma nẽ ixkwỳm ri tanhmã amnhĩ nhĩpêx to ho pa. Jao te kamàt kô kamã mẽ rĩt mex kêt xwỳnhjaja kot htỳx amnhĩ nhĩpêx o pa pyràk o amnhĩ nhĩpêx. ");
INSERT INTO apnNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","—E kêr ka mẽ ã amnhĩ nhĩpêx anhỹr pymaj ixkapẽr ma nẽ kãm ajamaxpẽr tỳx rãhã ho ri apa. ");
INSERT INTO apnNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Kot kaj mẽ ixkapẽr ma nẽ ixkôt amnhĩ nhĩpêx. Hãmri nẽ te mẽ ate kanê hpôk mex nhĩrã kamã ri apa pyràk o amnhĩ nhĩpêx. Jao aprĩ hã ixkapẽr ma nẽ aprĩ hã ixte tanhmã amnhĩ nhĩpêx to hã ixpumunh mex nẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Tã nhũm Jejus ra mẽ ahkre pa. Hãmri nhũm Parijew nhõ xwỳnhja hwỳr tẽ nẽ kãm: —Pa. E kwa ma ixkôt tẽ nẽ mẽ ixkutã apku. Anẽ. Hãmri nhũm kuma nẽ kãm: —Tôe. Nà kot paj ma akôt tẽ. Anẽ Hãmri nẽ ma hkôt tẽ nẽ õrkwỹ hwỳr axà nẽ apkur kaxyw mẽ ĩhkô hã nhỹ. ");
INSERT INTO apnNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","No ãm mẽ hkukamã mẽ hpãmjê pyrà nẽ amnhĩ nhĩhkra kuhõnh ryy hkêt nẽ. Ãm amnhĩ nhĩhkra htyk pix kuhõnh tokyx anẽ nẽ nhỹ. Nẽ õ prat kuhõnh ryy hkêt rãhã apkur kaxyw nhỹ. Jakamã nhũm kot amnhĩ kôt hwỳr xwỳnhta tee ri ja hã omu nẽ hamaxpẽr o: —Tk. Kwa na hte mẽ ixte amnhĩ nhĩpêx kôt amnhĩ nhĩpêx mex kêt nẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Anẽ nhũm Jejus amnhĩ tã hamaxpẽr ã omu nẽ kãm: —Nà mẽ apê Parijew nhõ xwỳnhjaja te mẽ ate mẽ kot apkur kaxyw prat kre kuhõnh punuj tã mex ã harẽnh pyràk o amnhĩ nhĩpêx. Nẽ ãm mẽ akrã hkà rũm pix mã na mẽ amex. Nẽ mẽ noo mã te mẽ amex pyràk no ãm mẽ anhõxàhkre kaxwỳnh kãm mẽ ajamaxpẽr mex kêt. Ãm mẽ akapẽr prãm. Nẽ mẽ axàhkurêê. Nẽ mẽ anhõxỳỳ. ");
INSERT INTO apnNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Mẽ ate atỳx ri amnhĩ nhĩpêx o ri mẽ apa xwỳnh kênã. Kwa kêr ka mẽ ãm akrãhkà pix rũm amex nẽ ri apa hkêt nẽ. Mẽ mããnẽn anhõxàhkre kaxwỳnh kãm ajamaxpẽr mex o ri apa. Nẽ tãm mẽ piitã mẽ hipêx o ri apa. ");
INSERT INTO apnNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Kêr ka mẽ tãm ajamaxpẽr o tãm mẽ hipêx o ri apa. Nẽ axàmnhĩx ri mẽ kêp amrakati xwỳnhjê mã mẽmoj nhõr o ri apa. Kot kaj mẽ ã amnhĩ nhĩpêx anẽ hãmri nhũm Tĩrtũm ja hã mẽ apumu nẽ amnhĩm mẽ amex ã mẽ ajarẽ. No na ka htem mẽ amã mẽ amnhĩ to mex prãm xàj tee ri amnhĩ kuhõnh japjê kaprỳ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Nhũm Jejus arĩ Parijew nhõ xwỳnhjê jahkre nẽ mẽ kãm: —Kwa mẽ okora Parijew nhõ xwỳnhjaja. Kot kaj mẽ amex kêt nẽ. Na ka htem Tĩrtũm kapẽr piitã hkôt amnhĩ nhĩpêx o apa hkêt nẽ ãm hkwỳ kôt pix mã amnhĩ nhĩpêx o ri apa. Nẽ ãm kapẽr o hpỹnhre nẽ hkôt amnhĩ nhĩpêx hãmri nẽ hã amnhĩ pumu nẽ ate amnhĩ to mex xwỳnh ã amnhĩ to jarkrar o ri apa. Nom Tĩrtũm kãm hprãm xà piitã hkôt amnhĩ nhĩpêx hkêt nẽ. Mẽ ate tãm mẽ piitã mẽ hipêx o ri apa hã kot mẽ amã karõja. Nẽ mẽ amã Tĩrtũm kĩnh ã kapẽr kôt amnhĩ nhĩpêx o ri apa hã karõja mẽ ate mar mex tã hkôt amnhĩ nhĩpêx kêt nẽ. Mẽ ate kapẽr piitã hkôt amnhĩ nhĩpêx ronhỹx ja mẽ amã mex kumrẽx. ");
INSERT INTO apnNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","—Kwa mẽ o kora. Mẽ piitã mẽ kot amnhĩm mẽ ate amnhĩ to rũnh xwỳnh ã amnhĩm mẽ ajarẽnhja na mẽ amã hprãm. Nẽ mẽ piitã mẽ kot amnhĩm mẽ apê mẽ ahkre mex xwỳnh maati hã mẽ ajarẽnhja na mẽ amã hprãm. ");
INSERT INTO apnNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","—Kwa mẽ o kora. Kot ka mẽ amex kêt nẽ. Mẽ kot mẽ akapẽr mar nẽ mẽ akôt amnhĩ nhĩpêx xwỳnhjaja te mẽ kot htỳx ri mẽ hã pika nhĩmõk ã ri mẽ pa xwỳnh kot amnhĩ nhĩpêx pyràk. Jao mẽ ate amnhĩ to mex ã amnhĩ kamnhĩx nom mẽ ate amnhĩ to mex kêt. Te mẽ kot pika mex ã hkamnhĩx nẽ htỳx ri mẽ hã pika nhĩmõk ã ri mẽ pata pyràk o na htem amnhĩ nhĩpêx. Anẽ. Nhũm pre ã Jejus Parijew nhõ xwỳnhjê mã mẽ kot amnhĩ nhĩpêx jarẽnh anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Hãmri nhũm Tĩrtũm kapẽr tũm o mẽ ahkre ho pa xwỳnhja kuma nẽ kànhmã xa nẽ kãm: —Kwa na ka ã Parijew nhõ xwỳnhjê jarẽnh punuj anhỹr jao mããnẽn ã mẽ paja jarẽnh anẽ nà? Mẽ ixte amnhĩ nhĩpêxja ãm tipxi kênã. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Hãmri nhũm kãm: —Tỳ. Mããnẽn mẽ kajaja. Kwa o kora mẽ apê Tĩrtũm kapẽr tũm o mẽ ahkre xwỳnhjaja. Kot kaj mẽ uràk nẽ amex kêt nẽ. Na ka htem mẽ kãm mẽmoj tã karõ ho ri apa nẽ mẽ kãm: “E kêr ka mẽ ã amnhĩ nhĩpêx anẽ nẽ ã amnhĩ nhĩpêx anẽ.” Anhỹr tã no ãm mẽ kajaja amnhĩ kapẽrja kôt amnhĩ nhĩpêx kêt nẽ. Te mẽ ate mẽhõ kot mẽ katut ã mẽ kãm mẽ jênh pytĩ janhôr tã mẽ ho ajuta nẽ hkwỳ htur kêêta pyràk o na ka htem amnhĩ nhĩpêx o ri apa. ");
INSERT INTO apnNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","49","—Na pre Tĩrtũm amnepêm mẽ pahpãmjê hkukamã tanhmã mẽ harẽnh to. àhpumunh tỳx xà hkôt tanhmã mẽ hkukamã mẽ harẽnh to nẽ mẽ harẽnh o: “Kot paj ma mẽ hwỳr inhỹ hã ixkapẽr jarẽnh xwỳnhjê rẽ. Nom koja mẽ omu nẽ ãm mẽ omu nẽ kêp mẽ hprãm nõkati nẽ tanhmã mẽ hipêx to ho pa. Nẽ ixpê mẽ hkwỳjê hpar o pa. Ã koja mẽ inhỹ hã ixkapẽr jarẽnh xwỳnhjê nhĩpêx anẽ.” Anhỹr o mẽ hkukamã mẽ harẽ. Tã ã mẽ harẽnh anhỹr xà hkôt nhũm prem ã mẽ hipêx anẽ nẽ mẽ hkwỳjê hpa nẽ mẽ hkwỳjê pynê nẽ mẽ hagjê. —Amnepêm mẽ akukamã mẽ kot ã mẽ hipêx anhỹr nhũm mẽ ate mẽ ano ho ja hã mẽ omunh kêt tã ka htem arĩ mẽ hã pika ho mex o ri apa. Te mẽ amã mẽ hapê nẽ mẽ ho ajamak pyrà nẽ mẽ hã pika ho mex o ri apa. Nom mẽ amã mẽ hapê hã ho mex hkêt nẽ. Ãm ra mẽ htyk nẽ hapêx nẽ mẽ amã Tĩrtũm kapẽr jarẽnh o pa hkêtja ã na ka htem akĩnh nẽ ã axêx rom mẽ hã pika ho mex anhỹr o ri apa. ");
INSERT INTO apnNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","51","—Na prem Tĩrtũm nhỹ hã kapẽr jarẽnh o mẽ pa xwỳnhjê nhĩmex rax nẽ. Amnepêm panhĩ kator krax rũm finat Atãw kra finat Apewja na pre Tĩrtũm nhỹ hã kapẽr o pa nhũm htõ kãm mar prãm kêt nẽ kupĩ. Tã nhũm Tĩrtũm axte mẽ hwỳr ỹ hã kapẽr jarẽnh o mẽ pa xwỳnh kwỳjê rẽ nhũm prem mã mẽ ho anẽ nẽ mẽ hkwỳjê nhĩmex. Nhũm pre xatã mẽ hwỳr mẽ hkwỳjê rẽ nhũm mẽ xatã mẽ kupa. Ã Apew rũm finat Jakaris wỳr na prem mẽ himex rax anẽ. Nẽ hpãnhã Jakarisja nhũm prem Tĩrtũm mã amnhĩ jarẽnh xà hã ixkre kamã kupĩ. Tã ka mẽ ajaxwỳja amã Tĩrtũm kapẽr mar prãm kêt nẽ mẽ uràk nẽ amã ỹ hã kapẽr jarẽnh o mẽ pa xwỳnhjê nhĩmex prãm. Tã ã mẽ pahpãmjê mẽ ato hpimrààtã mẽ ate mẽ hipêx anhỹrja mỳrapê koja Tĩrtũm ja hã mẽ apê mẽ hkanrẽhã mẽ htàmnhwỳjaja tanhmã mẽ ato htỳx to ka mẽ amnhĩ xà htỳx kamã ajamak o ri apa rãhã nẽ kãm ga. ");
INSERT INTO apnNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","—Jakamã kwa mẽ o kora mẽ apê Tĩrtũm kapẽr tũm o mẽ ahkre xwỳnhjaja. Mẽ ajaxwỳja na ka htem Parijew nhõ xwỳnhjê pyrà nẽ Tĩrtũm kapẽr o mẽ ahkre ho apa. Nẽ aprĩ hã mar mex tã no ãm amnhĩ kaxyw hkôt ajamaxpẽr nẽ hkôt amnhĩ nhĩpêx kêt nẽ. Hãmri nẽ mẽ kot mẽ amar o pa xwỳnhjê mã atỳx ri tanhmã mẽ ahkre hto nhũm htem mẽ ama nẽ mẽ apyrà nẽ amnhĩ kaxyw Tĩrtũm kôt hamaxpẽr nẽ hkôt amnhĩ nhĩpêx kêt nẽ. Mẽ kãm hprĩ hã kapẽr mar mex prãm tã mẽ amar xà hkôt mẽ ate amnhĩ nhĩpêx pyràk o amnhĩ nhĩpêx o pa. Nom mẽ kajaja na ka htem mẽ kãm mẽ hamaxpẽr mex nhõr kêtja mỳrapê nhũm htem ã amnhĩ nhĩpêx anhỹr o pa. Jakamã kwa mẽ o kora kot kaj mẽ amex kêt nẽ. Anẽ. Nhũm pre ã Jejus mẽ kãm kapẽr anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","54","Hãmri nẽ kato nẽ ma tẽ. Nhũm Tĩrtũm kapẽr tũm o mẽ ahkre ho mẽ pa xwỳnhjê mẽ Parijew nhõ xwỳnhjaja hãmri kot tanhmã mẽ kãm kapẽr toja ma nẽ kamã gryk tỳx nẽ. Jakamã ma hkôt mra. Hêx rom mẽmoj tã hkukjêr o hkôt mra. Nẽ hã hkukjêr kãm hihtỳx o hkôt mra. Kot tanhmã mẽ kãm ujarẽnh to nhũm mẽ kot mar nẽ ra hã àmnênh kaxyw ma hkôt àhkukjêr o mra. ");
INSERT INTO apnNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","3","Tã nhũm mẽ Jejus ã htu rax kumrẽx nẽ hã axpẽn nhĩgãnh o kuhê. No nhũm kormã mẽ kãm tanhmã kapẽr to hkêt nẽ. Ãm kormã hkôt mẽ pa ho mẽ pa xwỳnhjê kumrẽx mã kapẽr nẽ mẽ kãm: —Mẽ piitã kãm amnhĩ kwỳjê pê hamaxpẽr punuj o hpimxur hprãm tã koja nhỹrmã mẽ hamaxpẽr piitã amnhĩrĩt pa. Nẽ mẽmoj piitã ra hpimxur mex tã koja nhỹrmã piitã amnhĩrĩt pa. Nẽ mẽ kot kamàt kô kamã hpimxur pê mẽmoj jarẽnh tã koja mẽ piitã nhỹrmã kot mẽmoj jarẽnhta ma. Nẽ mẽ kot hitom kãm kawax pê axpẽn mã mẽmoj punuj jarẽnh tã koja nhỹrmã mẽ piitã mẽmoj jarẽnhta ma. Jakamã kwa kêr ka mẽ tanhmã Parijew nhõ xwỳnhjaja kot amnhĩ nhĩpêx to ho pa hã mẽ omu nẽ ãm mẽ omu nẽ mẽ hkôt amnhĩ nhĩpêx kêt nẽ. Te mẽ kot tãm amnhĩ nhĩpêx pyràk o amnhĩ nhĩpêx tã no ãm tãm amnhĩ nhĩpêx o pa hkêt. Na htem ãm htỳx ri tanhmã amnhĩ to hêx to ho pa. Tã kêr ka mẽ uràk nẽ ã amnhĩ nhĩpêx anhỹr kêt nẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Nhũm Jejus arĩ hkôt mẽ pa ho mẽ pa xwỳnhjê mã kapẽr nẽ mẽ kãm: —E ixkràmnhwỳjaja. Kêr ka mẽ amã akwỳjê puma rỳ nhãm mẽ hkwỳjê puma ho ri apa hkêt nẽ. Koja mẽ apar tã ãm mẽ anhĩ pix pa nom tanhmã mẽ akarõ hto hkêt nẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Tĩrtũmja tapxipix na hte mẽ ĩ nẽ mẽ hkarõ ho hpimrààtã mẽ kot amnhĩ xà htỳx kamã hamak tũm xà hwỳr mẽ kurẽ. Tã kêr ka mẽ ja pumaj Tĩrtũm kapẽr kwỳm tanhmã ri amnhĩ nhĩpêx to ho apa hkêt nẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","7","—Nẽ Tĩrtũm kot mẽ pahto hapêx par pumunh tã mããnẽn kot mẽ pajamãr pumunh mex. Mãn ka htem kuwênhre pumu. Na hte Tĩrtũm hamãr mex o pa. Mẽ piitã mẽ kot ãm kuwênhre pumunh o pa htã nhũm Tĩrtũm mẽ kurom hamãr mex o pa. Nẽ htãnopxar rãhã ho pa. Nom kãm mẽ pajapê htỳx o kuwênhre jakrenh jakamã kwa mẽ tee ri amnhĩ kukamã ajamaxpẽr o ri akaprĩ nẽ apa hkêt nẽ. Koja Tĩrtũm mẽ pahtãnopxar rãhã ho pa. Ra kot tanhmã mẽ pakute hã mẽ pahpumunh par. Nẽ ahpỹnhã tanhmã mẽ pahkrã hkĩ kute hkôt mẽ pahpumunh par. Tã kot mẽ pahtãnopxar rãhã jakamã mo kaxyw kot kaj kêt mẽ ri amã mẽhõ puma ho ri apa? ");
INSERT INTO apnNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","—Jakamã kwa mẽ mãmrĩ mẽ kãm mẽ apê ixkra hã amnhĩ jarẽnh o ri apa nẽ amã mẽ uma xàj tee ri amnhĩ nhĩpêx o ri apa hkêt nẽ. Kot ka mẽ kãm ra mẽ ate ixkôt amnhĩ xunhwỳr ã amnhĩ jarẽ. Pa ja hã mẽ apumu hãmri nẽ mẽ apyrà nẽ kaxkwa kamã Tĩrtũm kapẽr o mẽ wrỳk xwỳnhjê mã ra mẽ ate ixkôt amnhĩ xunhwỳr ã mẽ ajarẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Nom kot ka mẽ kot ixtã tanhmã mẽ ato pymaj apê ixkwỳ hã amnhĩ jarẽnh kêt japêr. Pa ja hã mẽ apumu hãmri nẽ nhỹrmã amnhĩ xwar mẽ kãm mẽ apê ixkwỳ hkêt ã mẽ ajarẽ. Jakamã kwa mẽ mãmrĩ mẽ kãm apê ixkwỳ hã amnhĩ jarẽnh o ri mẽ hkôt apa kê mẽ ama nẽ tanhmã inhmã hamaxpẽr to. ");
INSERT INTO apnNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Koja mẽ ama nẽ ãm ama nẽ kãm ixprãm kêt japêr. Hãmri nhũm Tĩrtũm ixtã mẽ omu nom tokyx ixtã tanhmã mẽ ho hkêt nẽ. Koja kormã amnhĩ tã mẽ hamãr o pa. Karõ kot axte mẽ kãm ijarẽnh o amnhĩrĩt nhũm mẽ hkwỳjaja kot mar nẽ kãm ixprãm nẽ ixkôt amnhĩ xunhwỳr kaxyw nhũm kormã amnhĩ tã mẽ hamãr o pa. Nom koja Karõ xatã mẽ kãm ixto amnhĩrĩt tã nhũm mẽ kuma nẽ ãm kuma nẽ te mẽ kot kêp amnhĩ jamak pro pyràk o amnhĩ nhĩpêx o pa. Jao Karõ hã hpijaàm kêt mỳrapê koja Tĩrtũm nhỹrmã amnhĩ xwar te kot mẽ kêp amnhĩ jamak pro pyràk o mẽ hipêx nhũm mẽ tee kãm amnhĩ kaprĩ kaprỳ. Hãmri nẽ amnhĩ xà htỳx kamã hamak tũm xàta wỳr ma pa nẽ kamã pa ho pa. Jakamã kwa mẽ mãmrĩ mẽ kãm mẽ apê ixkra hã amnhĩ jarẽnh o ri mẽ hkôt apa nẽ tanhmã mẽ kãm ijarẽnh to ho ri apa. ");
INSERT INTO apnNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Koja mẽ ama nẽ kãm mẽ amar prãm kêt japêr hãmri nẽ ixtã mẽ apynê nẽ tanhmã mẽ anhĩpêx to kaxyw. Nẽ Ijaew nhõ Tĩrtũm kapẽr o mẽ ahkre xà hã ixkre hwỳr mẽ ato mrar japêr. Rỳ mẽ õ pahi hwỳr mẽ ato mrar nẽ tanhmã kãm mẽ ato hêx to. Nom kêr ka mẽ mẽ kãm amnhĩ jarẽnh kaxyw nẽ tee ri amnhĩ kukamã ajamaxpẽr o amã mẽ uma kêt nẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Koja Tĩrtũm Karõ ja kaxyw mẽ amã mẽ ajamaxpẽr mex gõ hãmri ka mẽ ô ri mẽ kãm amnhĩ jarẽ. Jakamã kwa mẽ tee ri mẽ kãm amnhĩ jarẽnh kukamã ajamaxpẽr o ri mẽ amã mẽ uma ho apa hkêt nẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Nhũm Jejus arĩ mẽ ahkre o xa nhũm mẽ mar o kuhê. Rôm nhũm mẽhõ myja hwỳr tẽ nẽ kãm kapẽr nẽ kãm: —Pa? Kwa ot pa awỳr amã mẽmoj jarẽnh mã tẽ. Na pre inhĩpêêxà ty nhũm ixtõ ixrom amnhĩm õ mẽmoj piitã ho àrĩk pa. Õ pika nẽ hkrit nẽ hikukrêx nẽ ãm mẽmoj piitã ho àrĩk par kumrẽx. Kwa ma ixkôt tẽ nẽ kãm anẽ pa wa amnhĩm ho axkjê nà? Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Hãmri nhũm kuma nẽ kãm: —Tk. Kokỹ. Na pa pre mẽ amã mẽ mẽmoj to ixpikjêr kaxyw mẽ awỳr ixwrỳk kêt nẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Hãmri nẽ mẽ kot mar o kuhê xwỳnh piitã mẽ kãm kapẽr nẽ mẽ kãm: —Kwa kêr ka mẽ amã anhõ mẽmoj rũnh prãm o ri apa hkêt nẽ. Na htem mẽmoj rũnh kukwak ri Tĩrtũm wỳr apir kêt nẽ. Mẽmojta kêp pika pix nhõ xwỳnh na. ");
INSERT INTO apnNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Anhỹr o mẽ kãm kapẽr hãmri nẽ mẽ kãm awjarẽ. Mẽ hkukrêx rax ã kuxi nẽ mẽ kãm awjarẽ nẽ mẽ kãm: —Nà koja mẽhõ õ mẽmoj rax nẽ. Nẽ hpur kãm õ rax nẽ. No ãm õ jaxwỳr xà hã ixkre kêp grire. ");
INSERT INTO apnNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Hãmri nhũm tee ri hpur kãm õ rax kukamã hamaxpẽr nẽ hamaxpẽr o: “Kwa tanhmã kot pa amnhĩ to nẽ ja piitã nhỹri haxwỳ wehe? Inhmã amarĩ mẽ kêp amrakati xwỳnhjê mã hkwỳ nhõr prãm kêt. Kot paj ãm amnhĩm piitã ir pa nẽ kritpêm hkur o ixpa. Nom ixpê haxwỳr xà hã ixkreja ixpê grire.” Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","—Hãmri nẽ hamaxpẽr o: “Nà na pa ra ijamaxpẽr. Kot paj ixkre grireta grà nẽ hpãnhã rax õ nhĩpêx. Hãmri nẽ ixpur kãm inhõta jamỳ nẽ kamã ir pa. Nẽ ixàpênh xà hã ixkukrêx piitã kamã haxwỳr pa. Nà kot paj ho anẽ.” Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","—Hãmri nẽ ra ixkreja grành pa nẽ hpãnhã rax õ nhĩpêx. Nẽ hipêx pa hãmri nẽ kamã hpur kãm õta xir pa. Nẽ àpênh xà hã hikukrêx piitã kamã unhwỳ. Hãmri nẽ omu nẽ hkĩnh nẽ. Nẽ hamaxpẽr o: “Nà hãmri. Kot paj tokyx axte mẽmoj tã ixàpênh kêt nẽ. Ra inhõ rax kumrẽx kênã. Kot paj kritpêm ho ixàpkur mex o ixpa. Nà ãm hãmri na pa amnhĩ kukamã ijamaxpẽr mex pê ixkre rax nhĩpêx.” Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Tã nhũm Tĩrtũm tee ri ã kot amnhĩ nhĩpêx anhỹr ã omu nhũm ja kãm mex kêt nẽ. Hãmri nhũm hã kãm kapẽr nẽ kãm: “Nà na ka atỳx ri anhõ rax mẽ akukrêx rax o apikuprõnh kaprỳ. Na ka ãm amnhĩ pix kukamã ajamaxpẽr o apa pê ã amnhĩ nhĩpêx anẽ. Nom kot kaj kamàt ja kamã ty nẽ anhỹ kamã ma mõ nẽ amnhĩ kôt anhõ mẽmoj rax õ ho amõr kêt nẽ. Koja hpãnhã mẽhõ amỳr pê ho amnhĩptàr pa ka rĩ amnhĩ pumu.” Anẽ. Nhũm ã Tĩrtũm kãm kapẽr anẽ. Ã mẽ ujarẽnh kot anhỹr. ");
INSERT INTO apnNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","—Mẽ kot amnhĩ nhõ nẽ amnhĩ kukamã pix mã hamaxpẽr o mẽ pa xwỳnhjaja na htem myja pyrà nẽ Tĩrtũm mã hamaxpẽr o pa hkêt nẽ. Jakamã koja mẽ nhỹrmã ty hãmri nẽ hkukrêx pix kukamã hamaxpẽr nẽ amnhĩ mã pix mã hamaxpẽr o paja mỳrapê Tĩrtũm mẽ wa ixri htĩr tũm nẽ mex nẽ pa ho pa hkêt nẽ. Mẽ kot amnhĩ nhõ pix kukamã hamaxpẽr xwỳnhjaja nẽ amnhĩ kukamã pix mã mẽ hamaxpẽr xwỳnhjaja nẽ mẽ kamã ukaprĩ hkêt xwỳnhjaja mẽ õ mẽmoj rũnh tã koja mẽ nhỹrmã ty hãmri nẽ amnhĩ kôt hõ ho pixi nẽ o mõr kêt nẽ. Koja mẽ mẽmoj piitã rer pa nẽ ma ỹ kamã ma mõ. Jakamã kwa kêr ka mẽ jajê pyrà nẽ anhõ mẽmoj to anhõxỳ ho ri apa hkêt nẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Tã nhũm Jejus hpãnhã tanhmã hkôt mẽ pa ho mẽ pa xwỳnhjê jahkre hto nẽ mẽ kãm: —Kwa kêr ka mẽ tee ri amnhĩ kukamã ajamaxpẽr o ri apa hkêt nẽ. Amnhĩ xàpkur xà rỳ axê ka mẽ tee ri hkukamã ajamaxpẽr kêt nẽ. Nẽ mẽ ãm mẽmoj piitã hkukamã tee ri ajamaxpẽr kêt nẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Tĩrtũm àhpumunh tỳx o àhpumunh tỳx xwỳnh na. Na pre àhpumunh tỳx o mẽ anhĩpêx ka mẽ kukwak ri atĩr nẽ apa. Tã xà kot mẽ amã mẽ anhõ ho pa hkukamã àhpumunh kêt? Nà ja kukamã àhpumunh xihtỳx kênã. Kêp mẽ anhĩpêx xwỳnh jakamã mããnẽn kêp mẽ amã mẽ anhõ ho pa xwỳnh. Nẽ kêp mẽ amã mẽ axê nhõr o pa xwỳnh. ");
INSERT INTO apnNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","—Mãn ka htem kuwênhre pumu. Na hte tee ri amnhĩ xàpkur xà hkukamã hamaxpẽr o hkaprĩ nẽ ri pa hkêt nẽ. Na hte Tĩrtũm tãm kot kãm õ ho pa. Tã kãm mẽ pajapê htỳx o kuwênhre jakrenh jakamã koja uràk nẽ mẽ pamã mẽ panhõ mex o pa rãhã nẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","26","Jakamã kwa kêr ka mẽ mẽmo arĩgro hã axàpkur xà hkryre pumu nẽ ate amnhĩ pê hkrẽr par nẽ amã prãm o akaprĩ nẽ apa hkukamã tee ri ajamaxpẽr kêt nẽ. Ãm Tĩrtũm kamnàr rom axàmnhĩx anhõ hkryreta ku nẽ akĩnh kãm tanhmã amnhĩ nhĩpêx to ho ri apa. Xà kot ka anhõ mry grire pumu nẽ akaprĩre nhũm ra tanhmã amã amnhĩ to rax to? Na htem ãm tee ri mẽmo hkukamã hamaxpẽr o hkaprĩ nẽ pa kaprỳ. Jakamã kêr ka mẽ ã ri ajamaxpẽr anhỹr o akaprĩ nẽ apa hkêt nẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","—Mãn ka htem akunĩ kamã pixôrãre pumu. Na hte tee ri tanhmã amnhĩ kute hkukamã hamaxpẽr o hkaprĩ nẽ harir kêt tã muxre nẽ harir ka mẽ omu. Te ho amnepêm finat pahihti Sarumãw xê mex pyràk nom ãm mex o kot hakrenh. ");
INSERT INTO apnNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","—Pixôrãreja arĩgro ja hã htĩr nẽ muxre nẽ harir tã koja mẽmo arĩgro hã grà pa nẽ hapêx. Kêp pixôrã pix nẽ hapêx tokyx anhỹr tã na hte Tĩrtũm ho mex nẽ nhũm mux nẽ harir. Nom mẽ pajaja na hte mẽ pahto mex o pixôrãre ho mexja jakrenh. Jakamã kwa mẽmo kaxyw kot ka mẽ tee ri amnhĩ xê hkukamã ajamaxpẽr o akaprĩ nẽ apa? Nà kot kaj mẽ anẽ nẽ amnhĩ kaxyw Tĩrtũm mã ajamaxpẽr tỳx kêt nẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","—Kwa mẽ tee ri amnhĩ xàpkur xà hkukamã ajamaxpẽr rãhã o ri akaprĩ nẽ apa hkêt nẽ. Nẽ mẽ tee ri amnhĩ kukamã tanhmã ajamaxpẽr to ho ri akaprĩ nẽ apa hkêt nẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Mẽ kot Tĩrtũm kôt amnhĩ xunhwỳr kêt xwỳnhjaja na htem ã ri hamaxpẽr anhỹr o hkaprĩ nẽ pa. Tã kêr ka mẽ ho mẽ uràk kêt nẽ. Tĩrtũm kot mẽ panhõ mẽmoj kêt kôt mẽ pahpumunh mex kênã. ");
INSERT INTO apnNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Jakamã kêr ka mẽ ãm hkôt ri amnhĩ nhĩpêx rãhã nẽ. Nẽ amã ja pix kukamã ajamaxpẽr o ri apa hprãm. Hãmri nhũm amnhĩ tã mẽ apumu hãmri nẽ apkati mẽ tãm mẽ amã mẽmoj nhõr o pa. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Nhũm Jejus arĩ mẽ kãm kapẽr nẽ mẽ kãm: —E mẽ ate ixkôt amnhĩ xunhwỳr xwỳnhjaja. Ra Tĩrtũm kot mẽ ato hkra jakamã kwa mẽ axàmnhĩx hkamnàr rom ri tanhmã amnhĩ nhĩpêx to ho ri apa. Na hte mẽ apê hkra hã mẽ apumu nẽ hkĩnh nẽ. Koja nhỹrmã kaxkwa kamã õ krĩ hwỳr mẽ ato api ka mẽ kamã wa ixkuri amex nẽ atĩr tũm nẽ apa ho apa. Ja na mex o kot jar pika ja kôt mẽ õ mẽmoj rũnh nẽ pa xwỳnhta jakrenh. ");
INSERT INTO apnNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Jakamã kêr ka mẽ axàmnhĩx ri akukrêx kwỳ ho wẽnê nẽ hpãnhã kàxpore jamỳ nẽ mẽ kêp amrakati xwỳnhjê mã ho apigrành o ri mẽ hkôt apa. Kot kaj mẽ ã amnhĩ nhĩpêx anẽ hãmri nẽ kaxkwa kamã akukrêx rax nẽ. Mo kaxkwa kamã mẽ àhkĩnh xwỳnh koja mẽ apê ho ahkĩ? Nẽ kamã mo amnhôre kot mẽ apê homnu? Kaxkwa kamã ja amrakati kumrẽx. Jakamã Tĩrtũm kot mẽ amã mẽ akukrêx nhõr mã xwỳnhta koja aa apê omnuj nẽ hapêx kêt kumrẽx. ");
INSERT INTO apnNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Kot kaj mẽ jar pika ja kamã akukrêx rax hãmri nẽ tanhmã apê omnu hto pix kukamã ajamaxpẽr rãhã ho ri apa. Nom kot kaj mẽ apê Tĩrtũm kra hã kot kaj mẽ jar akukrêx rax kêt tã kaxkwa kamã akukrêx pix kukamã ajamaxpẽr rãhã ho ra akĩnh nẽ ri apa. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Nhũm pre Jejus arĩ mẽ ahkre nẽ mẽ kãm: —E na pa pre ra mẽ apê ixkôt mẽ apa ho apa xwỳnhjê mã tanhmã amnhĩ kukamã amnhĩ jarẽnh to. Ixtyk nẽ akupỹm ixtĩr nẽ ma akupỹm ixàpir hãmri nẽ mẽmo arĩgro hã akupỹn mẽ awỳr ixwrỳkja na pa pre ra mẽ amã ja hã amnhĩ jarẽ. Tã kwa kêr ka mẽ ixwakre kamã ixte mẽ amã ã amnhĩ jarẽnh anhỹrja mã ajamaxpẽr tỳx pê ixkôt amnhĩ nhĩpêx rãhã ho ri apa. ");
INSERT INTO apnNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","38","—Te mẽ õ patrãw mã mẽ àpênh mex xwỳnhjaja kot amnhĩ nhĩpêx pyràk o amnhĩ nhĩpêx o ri apa. Koja mẽ õ patrãw ma mẽ kot axpẽn mã wa rer mã xwỳnh pumunh mã ma nhỹhỹm tẽ. Hãmri nhũm kãm mẽ àpênh xwỳnhjaja arĩ kutêp õrkwỹ kamã hkrĩ. Axkãm hamak rom nẽ kutêp hkrĩ. Akupỹn htẽm nhũm mẽ kot amnhĩ wỳr mar nẽ kãm kahê xà mẽnh tokyx anhỹr kaxyw arĩ kutêp õt kêt nẽ hkrĩ. Kôt ã kamàt nhũm akupỹn hpôx o htẽm rỳ arĩgro hwỳr hpôx o htẽm nhũm mẽ kot amnhĩ wỳr mar nẽ kãm kahê xà mẽnh tokyx anhỹr kaxyw kutêp õt kêt nẽ hkrĩ. Akupỹn hpôx ã omunh hãmri nẽ tokyx apkur kaxyw kãm õ nhĩpêx kaxyw. Kêr kê akupỹn pôj nẽ ã mẽ kot amnhĩ nhĩpêx anhỹr ã mẽ omu nẽ hkĩnh nẽ. Tã kêr ka mẽ àpênh xwỳnhtajê pyrà nẽ ixwakre kamã inhmã ajamaxpẽr rãhã ho ri apa. Jao ixkamã ajamak o apa ho ixkôt amnhĩ nhĩpêx mex rãhã nẽ. No kot paj akupỹn mẽ awỳr wrỳ hãmri ka mẽ àpênh xwỳnhjê pyrà nẽ inhmã mẽmoj nhõr kêt nẽ. Kêt pa kot paj mẽ õ patrãwta kurom mẽ amã mẽmoj mex gõ. ");
INSERT INTO apnNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","—Na htem mẽ kêp àhkĩnh pymaj amnhĩ nhõrkwỹ jamãr rãhã ho pa. ");
INSERT INTO apnNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Ja pyrà nẽ mẽ ate akupỹn ixwrỳk xà hã arĩgro pumunh kêt jakamã kêr ka mẽ õrkwỹ nhõ dõnta pyrà nẽ ixkutêp axkãm ajamak rom rãhã nẽ ri apa. Jao tãm amnhĩ nhĩpêx rãhã nẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Nhũm pre ã Jejus hkôt mẽ pa ho pa xwỳnhjê jahkre anẽ. Hãmri nhũm Simãw Pêtre kuma nẽ kãm: —Kwa Pahihti. Xàn ka mẽ piitã mẽ kãm ã akapẽr anẽ nà? Xà ãm mẽ papxipixjê mã? Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Hãmri nhũm kãm: —Nà ãm ixwakre kamã mẽ ate ixkôt tanhmã inhmã amnhĩ nhĩpêx to ho mẽ apa xwỳnh piitã mẽ amã na pa ã ixkapẽr anẽ. Koja mẽ àpênh xwỳnhjê hõ õ patrãw mã àpênh mex o pa nhũm amnhĩ tã omu nẽ ma nhỹhỹm mõr kaxyw nẽ ĩhkram mẽmoj piitã haxàr pa. Hãmri nẽ kãm: “E kêr ka ixwakre kamã inhmã inhõrkwỹ htãnopxa. Nẽ mẽ àpênh xwỳnhjê mã õ mex kê mẽ apkur mex o pa.” Anẽ. Koja ã kãm mẽmoj tã karõ anẽ hãmri nẽ kato nẽ ma nhỹhỹm mõ. ");
INSERT INTO apnNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Hãmri nhũm kãm àpênh mex xwỳnhta wakre kamã kãm àpênh mex o pa. Jakamã nhũm õ patrãw akupỹn hpôx o mõ nhũm amnhĩ wỳr harẽnh ma nẽ hkĩnh nẽ. Nẽ mẽmoj tã amnhĩ tã kamã kahak kêt nẽ. Rỳ tee ri wakre kamã kãm àpênh punuj ã amnhĩ pumu nẽ tee amnhĩ kukamã hamaxpẽr kêt nẽ. Kot wakre kamã kutêp àpênh mex jakamã akupỹn hpôx ã harẽnh ma nẽ hkĩnh nẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","—Jakamã nhũm õ patrãwja akupỹn pôj nẽ kot kãm àpênh mex ã omu nẽ haxwỳja hkĩnh nẽ. Hãmri nẽ kot kãm hamãr o pa kaxyw kãm mẽmoj piitã ĩhkram haxàr pa. ");
INSERT INTO apnNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Nom koja kãm àpênh xwỳnhta axtem nẽ wakre kamã kãm àpênh mex kêt nẽ. Nẽ tokyx akupỹn mõr kêt ã hkamnhĩx nẽ wakre kamã kãm mẽ àpênh xwỳnhjê htak nẽ pipãnh pix nẽ mẽ kãm gô xành xwỳnhjê kôt pix mã pa japêr. ");
INSERT INTO apnNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Hãmri nhũm õ patrãw haêr pê akupỹn pôj nẽ tee ri ã amnhĩ nhĩpêx anhỹr ã omu. Hãmri nẽ gryk tỳx nẽ tanhmã homnuj to. Hãmri nẽ kãm mẽ àpênh punuj xwỳnhjê mẽ mẽ ho pimrààtã amnhĩ nê mẽ hanor pa. Tã kêr ka mẽ ixwakre kamã ho mẽ uràk kêt nẽ. Mẽ kurom ixkapẽr kôt tãm amnhĩ nhĩpêx mex rãhã ho ri apa. ");
INSERT INTO apnNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","48","—Nẽ koja mẽhõ kormã Tĩrtũm kapẽr mar kêt nẽ htỳx ri tanhmã amnhĩ tomnuj to ho pa. Hã koja Tĩrtũm ja hã omu nẽ nhỹrmã kot amnhĩ tomnuj o pata mỳrapê tanhmã ho nhũm amnhĩ xà htỳx kamã hamak tũm xà kamã pa. Nom akrànhmã amnhĩ xà kamã hamak o pa. Aa kot Tĩrtũm kapẽr mar kêt jakamã koja ãm akrànhmã amnhĩ xà kamã hamak o pa. Nom koja mẽhõ kapẽr mar mex tã ãm kuma nẽ hkôt amnhĩ nhĩpêx kêt nẽ. Nẽ xatã hirôp kuhê nẽ tanhmã amnhĩ tomnuj to. Hã koja Tĩrtũm tee ri ja hã omu nẽ nhỹrmã tanhmã homnuj tỳx to. Hãmri nhũm wamtajê pyrà nẽ amnhĩ xà htỳx kamã hamak tũm xàta kamã pa ho pa nom mẽ kĩnhã amnhĩ xà htỳx kamã hamak rãhã ho pa. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Nhũm Jejus arĩ hkôt mẽ pa ho mẽ pa xwỳnhjê jahkre nẽ mẽ kãm: —Nà ixte mẽ omnu xà piitã ho ijapêx par nẽ mẽ kot tanhmã amnhĩ tomnuj to piitã ho ijapêx par kaxyw na pa pre wrỳ. Tã ra ixte piitã ho ijapêx par o inhmõr ronhỹx ja inhmã mex kumrẽx. Nom kormã. ");
INSERT INTO apnNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Kot paj amnhĩ xà htỳx kãm ijamak rax o mẽ kot amnhĩ tomnuj o ijapêx o hkrax. Hãmri nẽ nhỹrmã ho ijapêx pa. Na pa ra ixtyk kaxyw ixte amnhĩ kà xà kamã ijamak kukamã ijamaxpẽr o ra amnhĩ kamã ixkahak nẽ ri ixpa. Tã kot paj ja ho ijapêx pa nẽ ixkĩnh tỳx kumrẽx. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Nhũm Jejus arĩ mẽ ahkre nẽ mẽ kãm: —Nẽ ra mẽ awỳr ixwrỳk tã koja mẽ piitã ixkukwak ri hamakêtkati nẽ àmnhĩx ri pa hkêt nẽ. Kormã. Koja mẽ akwỳjaja ixkapẽr ma nẽ mẽ apyrà nẽ amnhĩ kaxyw ixkôt hamaxpẽr. No nhũm mẽ akwỳjaja mẽ akĩnhã kuma nẽ ãm kuma. Hãmri nẽ ixtã tanhmã mẽ anhĩpêx to ka mẽ ixpyrà nẽ amnhĩ xà htỳx kamã ajamak o ri apa. ");
INSERT INTO apnNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","—Nẽ koja tanhmãn ixkre pyxi kamã mẽmojaja ohtôn pa. Nhũm war axkrutre nẽ ixkôt amnhĩ xunhwỳ nhũm mẽ axkrunẽpxi nẽ ixkwỳm ri amnhĩ nhĩpêx nẽ ixkutã amnhĩ xunhwỳ. ");
INSERT INTO apnNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Nhũm mẽ hipêêxà hkra my mẽ wa ixtã axpẽn kutã amnhĩ xunhwỳ. Nhũm mẽ katorxà hkra ni mẽ wa ixtã axpẽn kutã amnhĩ xunhwỳ. Nhũm mẽ wỳj umregêx mẽ wa haxwỳja ixtã axpẽn kutã amnhĩ xunhwỳ. Koja mẽ ã ixtã axpẽn nhĩpêx anhỹr o pa. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Nhũm Jejus hpãnhã mẽ kot hkôt amnhĩ xunhwỳr kêt xwỳnhjê mã kapẽr nẽ mẽ kãm: —Kwa mẽ inhma mẽ ate ixkôt amnhĩ xunhwỳr kêt xwỳnhjaja. Na htem kaxkwa kamã na htyk rax pumu nẽ na wrỳk mã hamaxpẽr kurê kumrẽx. Hãmri nhũm na wrỳ. ");
INSERT INTO apnNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Nẽ amgrà pê kôk krihkritja nhũm htem kuma nẽ arĩgro htỳx mã hamaxpẽr kurê kumrẽx. Hãmri nhũm arĩgro htỳx nẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","57","ã na ka htem aprĩ hã mẽmoj pumunh kôt mẽmoj kukamã ajamaxpẽr mex o ri apa anẽ. Nom nhũm Tĩrtũmja mẽ ate tanhmã amnhĩ tomnuj to mỳrapê tanhmã mẽ ato kaxyw nhũm mẽ ate ja hã amnhĩ pumunh tã tokyx amnhĩ tomnuj kaga hkêt nẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","59","—Na htem tanhmã axpẽn tomnuj to. Hãmri nhũm kot tanhmã war axpẽn to xwỳnhta pahi hwỳr htẽm nẽ kãm tanhmã kot ho xwỳnhta jarẽnh kaxyw. Hãmri nhũm kamã gryk xwỳnhta kot pahi mã harẽnh kaxyw ã harẽnh ma nẽ hãmri tokyx hwỳr tẽ nẽ wa tãm akupỹm axpẽn xãm. Na htem ã amnhĩ nhĩpêx anẽ. Pahi kot ja mar nẽ tanhmã mẽ ho pymaj na htem ã amnhĩ nhĩpêx anẽ nẽ tokyx akupỹm tãm axpẽn xunhwỳ. No koja mẽ ã amnhĩ nhĩpêx anhỹr kêt nẽ nhũm pahija mẽ harẽnh ma hãmri nẽ tanhmã kot hõ ho xwỳnhta pynê nẽ haxà nhũm tee kãm kator prãm o hkrĩ kaprỳ. Hãmri nẽ tanhmã amnhĩ to nẽ amnhĩ pãnhã kãm amnhĩ rer pa nhũm pahihtija kormã mẽ kãm anẽ nhũm mẽ kãm ure nhũm kato. Ja pyrà nẽ kêr ka mẽ Tĩrtũm tanhmã kot mẽ anhĩpêx to pymaj tokyx mẽ ate amnhĩ tomnuj kaga nẽ hkôt amnhĩ nhĩpêx rãhã ho ri apa. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Tã nhũm axtem mẽ hkwỳjaja Jejus wỳr mra nẽ kãm: —Pa? Kwa xàn ka ra Garirej nhõ xwỳnh kwỳjê jarẽnh ma nà? Na xep prem Jerujarẽ hwỳr mra nẽ ham mẽ kot Tĩrtũm mã amnhĩ jarẽnh xà hã ixkre kamã kãm amnhĩ jarẽnh kaxyw kormã kãm mry hpar o kuhê nhũm xep pahihti Piratja mẽ harẽnh ma nẽ mẽ hã amỹnê nhũm mẽ ma mẽ hwỳr mra nẽ mẽ himex pa. Kwa mãn mẽ kot amnhĩ tomnuj tỳx o mẽ pajakrenh ã na prem mẽ himex nà? Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","3","Hãmri nhũm mẽ kãm: —Nà mẽ kot amnhĩ tomnuj tỳx mỳrapê mẽ kot mẽ himex kêt. Mẽ apiitã mẽ ate amnhĩ tomnuj o axpẽn pyràk kênã. Tã kot ka mẽ amnhĩ tomnuj kaga nẽ Tĩrtũm kôt amnhĩ xunhwỳr kêt hã kot ka mẽ nhỹrmã ty hãmri nẽ õ krĩ hwỳr axàpir kêt nẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","No Jerujarẽ kamã ixkre prêkja mẽ kot kãm “Siroe” anhỹr xwỳnhta mẽ ho 18 nẽ mẽ hipy htem nẽ mẽ himex par xwỳnhjaja. Xà mẽ kot amnhĩ tomnuj tỳx mỳrapê na prem ty? Xà mẽ kot amnhĩ tomnuj tỳx o Jerujarẽ kamã arĩ mẽ htĩr xwỳnhjê jakrenh? ");
INSERT INTO apnNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Nà kot anhỹr kêt. Mẽ apiitã mẽ ate amnhĩ tomnuj o axpẽn pyràk. Jakamã kot kaj mẽ ã amnhĩ nhĩpêx anhỹr kaga nẽ Tĩrtũm kôt amnhĩ nhĩpêx kêt nẽ hãmri nẽ mẽ uràk nẽ nhỹrmã ty hãmri nẽ Tĩrtũm nhõ krĩ hwỳr axàpir kêt nẽ. Jakamã kwa mẽ ixkapẽr ma nẽ kãm ajamaxpẽr tỳx rãhã ho ri apa. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Tã nhũm Jejus kê axte tanhmã mẽ ahkre hto. Nẽ Tĩrtũm kot tanhmã mẽ panhĩpêx to hã kuxi nẽ mẽ kãm awjarẽ nẽ mẽ kãm: —Koja hpur nhõ dõn mẽmo pàr kre nhũm ra hprêk mex nẽ ô mã tãm nẽ. Tã aa ô hkêt ã ra hã amgrà axkrunẽpxi. ");
INSERT INTO apnNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Hãmri nhũm kot hkre xwỳnhja tee ri omu nẽ kãm àpênh xwỳnh wỳr tẽ nẽ kãm: “E kwa ma tẽ nẽ mẽmo pàr mũj krãhta nẽ amẽ. Mexti hã. Ra ô hkêt ã amgrà axkrunẽpxi kênã. Koja pẽr aa ô hkêt nẽ. Mo kaxyw kot kêt ô hkêt tã ô mex xwỳnh kaêx ã mẽ kêp àmnàr o kuhê? E hwỳr tẽ nẽ krãhta nẽ amẽ.” Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","9","Hãmri nhũm tee ri kot kãm hã karõja ma nẽ kãm: “Kwa nà kormã. Pa kop ixàmnhĩx pàr krax ã mẽmo japôk kwỳ kapĩ nẽ kop hamã mãn. Kê axte hã amgrà pyxi nẽ hapêx nẽ ô hkêt pa kormã krãhta nẽ kumẽ. Koja amgrà ja kamã amã ô japêr ka omu nẽ akĩnh nẽ.” Anẽ. Ã mẽ ujarẽnh kot anhỹr. Anẽ. Nhũm Jejus ã mẽ kãm ujarẽnh anẽ. Mẽ kot amnhĩ tomnuj tỳx o pa htã nhũm Tĩrtũm kot pur nhõ dõn mã àpênh xwỳnhta pyrà nẽ mẽ kamã gryk tokyx anhỹr kêt ã nhũm ã hã kuxi nẽ mẽ kãm ujarẽnh anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Tã nhũm mẽ õ arĩgromnu pê sap kato nhũm Jejus Ijaew pikuprõnh xà hã ixkre hwỳr axà nẽ kamã Tĩrtũm kapẽr o mẽ ahkre ho nhỹ. ");
INSERT INTO apnNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Nhũm kamã mẽhõ ni hikôt rãhã nẽ pa xwỳnhja nhỹ. Na pre ra amnepêm mẽkarõmnuti tanhmã ho nhũm katàt nẽ ri mrar kêt kumrẽx. Ãm hikôt rãhã nẽ ri pa hã ra hã amgrà pê 18. ");
INSERT INTO apnNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","13","Hãmri nhũm Jejus omu nẽ amnhĩ wỳr kãm hpa ho apê nhũm hwỳr tẽ nhũm hã ĩhkra xi nẽ kãm: —E na ka ra akupỹm amex. Anẽ nhũm akupỹm katàt nẽ mex kurê kumrẽx. Hãmri nẽ amnhĩ pumu nẽ hkĩnh tỳx nẽ Tĩrtũm mã mex o mex ã harẽnh o xa. ");
INSERT INTO apnNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Nom nhũm mẽ pikuprõnh xà hã ixkre jamãr xwỳnh maatija tee ri ja hã omu hãmri nẽ Jejus kamã gryk tỳx nẽ. Mẽ õ arĩgromnu hã akupỹm kot ho mex jakamã nhũm kamã gryk tỳx nẽ. Hãmri nẽ mẽ pikuprõnh xwỳnhjê mã kãm: —Tk. Kwa semãn ã mẽ àpênh xà hã arĩgro xohtôô. Kêp 6. Kot kaj mẽ mãmrĩ tômĩk nẽ sikũn nẽ tês nẽ kwata nẽ kĩta nẽ sêsta ja ã ka mẽ apê rỳ mãmrĩ Jejus wỳr amnhĩ to mra kê akupỹm tanhmã mẽ ato mex to. No sap ã kwarĩ. Sap kêp mẽ pahpê Ijaew nhõ arĩgromnu kênã. Na pu htem hã paxàpênh kêt nẽ. Jakamã arĩgro ja hã kot akupỹm mẽ ato mexja mex kêt. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Hãmri nhũm Jejus kuma nẽ kãm: —Kwa xà mẽ kajaja na ka htem sap ã axàpênh kêt nẽ apa? Nà mẽ ate hã axàpênh kênã. Xàn ka htem sap ã akrit kawar nẽ akrit môx ma mẽ ho apa nẽ mẽ hkõm kêt nẽ? Nà na ka htem ma mẽ ho apa nhũm htem ixkõ. Mot ka kêt mẽ ri axtem nẽ mẽ kot sap ã tanhmã amnhĩ toja nê mẽ kãm akapẽr? ");
INSERT INTO apnNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Ixte ni ho mex xwỳnhta mẽ pahpyrà nẽ kêp finat Apraãw kagrõt nyw õ na. Nhũm pre Satanasti te kot kãm ê nẽ ri o pa pyràk o hipêx jakamã nhũm ỹ hã hikôt nẽ ri paja ã ra hã amgrà kêp 18. Tã pa nê te ixte Satanasti ho ixkrihkrit nẽ ixte kêp utàr pyràk o hipêx nẽ akupỹm ho mex. Mo kot pa kêt ri omu nẽ ãm omu nẽ arĩgromnu hã ho mex kêt nẽ? Nà ixte arĩgro piitã hã akupỹm mẽ ho mex o ixpa xwỳnh kênã. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Hãmri nhũm mẽ kot kãm kapẽr mar prãm kêt xwỳnhjaja kuma nẽ kamã gryk nẽ. Te ho mẽhprĩjê mã mẽ hamaxpẽr nhõr pyràk o mẽ hipêx pyràk jakamã nhũm mẽ amnhĩ tã kuma nẽ kamã gryk nẽ. No nhũm mẽ kot ra ã amnhĩ nhĩpêx anhỹr o pa hã omunh xwỳnhjaja ja hã omu nẽ kãm hkĩnh nẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","19","Nhũm Jejus arĩ mẽ ahkre nẽ tanhmã mẽ kãm amnhĩ tã ujarẽnh to nẽ mẽ kãm: —Nẽ Tĩrtũm kot mẽ awỳr ixte mẽ ato amnhĩptàr kaxyw inhmẽnh ã ijarẽnhja. Te ixte mẽmo hy pixire pyràk. Na htem hkre nhũm higrõt. Nẽ gaa nẽ rĩ hprêk. Hãmri nẽ pa anhgrà nhũm kuwênhre hwỳr mra nẽ hô pytĩ kamã amnhĩm haê nhĩpêx. Tã kot paj nhỹrmã mẽmo hy jarẽnhta pyrà nẽ ixpixi htã kot paj pika piitã hkôt mẽ ho amnhĩptà nẽ mẽ omunh mex rãhã ho ri ixpa. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","21","Nhũm Jejus arĩ mẽ ahkre ho xa. Nom hprĩ hã amnhĩ jarẽnh kêt nẽ. Ãm amnhĩ tã kuxi nẽ mẽ kãm awjarẽ nẽ mẽ kãm: —E kot pa hpãnhã tanhmã mẽ amã pãwti kaxkrit xà jarẽnh to. Koja mẽnijê hõ ãm hkwỳ ho grire nẽ kupy nẽ kaxyw mẽmo xôm kãm kumẽ nẽ ho pihkàr pa nẽ ho pãwti nhĩpêx. Nhũm kaxkrit xàja grire htã pãwti piitã ho kaxkrit mex nẽ. Ja pyrà nẽ kot paj ixpyxi htã koja mẽ nhỹrmã pika piitã hkôt ixkôt amnhĩ nhĩpêx mex o pa. Anẽ. Nhũm pre ã Jejus mẽ kãm amnhĩ tã pãw kaxkrit xàja xi nẽ harẽnh anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Tã nhũm Jejus arĩ krĩ pê Jerujarẽ hwỳr krĩ hkôt ri mẽ ahkre ho mẽ hkôt ri pa. ");
INSERT INTO apnNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Hãmri nhũm mẽhõ myja hwỳr tẽ nẽ mẽmoj tã hkukja nẽ kãm: —Pa. Kwa inhmã mẽmoj jarẽ. Xà koja mẽ ohtô nẽ nhỹrmã Tĩrtũm ri htĩr tũm nẽ papa ho nà koja mẽ grêre? Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Hãmri nhũm kuma nẽ mẽ kot mar o kuhê xwỳnh piitã kãm: —Nà mẽ kot Tĩrtũm kôt amnhĩ xunhwỳr xwỳnhjê pix koja mẽ õ krĩ hwỳr agjê. Wỳr mẽ gjêx xàja ãm pixii nom koja mẽ ohtô nẽ kãm hkôt wỳr gjêx prãm kêt nẽ. Na htem te hwỳr mẽ gjêx xà hõ japêr o pa pyràk. Nom pa na te ixpê hwỳr mẽ gjêx xà pixita pyràk. Jakamã kwa kêr ka mẽ tokyx ixkôt amnhĩ xunhwỳr tỳx nẽ ixkôt ri amnhĩ nhĩpêx o ri apa. Na htem ohtô nẽ kãm ixkôt amnhĩ xunhwỳr prãm kêt nẽ. Ixte amnhĩ nhĩpêxja mẽ kêp hihtỳx jakamã nhũm htem ixkaga. ");
INSERT INTO apnNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","—Tã koja mẽ nhỹrmã ty nẽ tee ri kãm Tĩrtũm wỳr gjêx prãm kaprỳ. Kot paj te mẽ kêp kahê pyràk o mẽ hipêx nhũm mẽ kapôt ã kuhê nẽ tee ri amnhĩ tã ixpumu nẽ inhmã: “Kwa mẽ inhmã kahê xà mẽ pa mẽ awỳr agjê Pahihti.” Anẽ. Hãmri pa mẽ kãm: “Nà ixte mẽ apumunhre hã kot pa kêt ri mẽ amã kurẽ.” Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","—Hãmri nhũm mẽ tee ri inhma nẽ inhmã: “Kwa nà ra ate mẽ ixpumunh mex kênã. Na ka pre mẽ inhõ krĩ kamã mẽ ijahkre ho ri apa nẽ mẽ ixkutã axàpkur o ri apa.” Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Hãmri pa mẽ kãm: “Tk. Ixte mẽ akutã ixàpkur tã mẽ ate ixkôt amnhĩ xunhwỳỳre hã. Jakamã e mẽ ma mra. Mẽ ate amnhĩ tomnuj pix o mẽ apa xwỳnh jakamã kot kaj mẽ ixwỳr agjêx kêt nẽ.” Anẽ. Kot paj ã mẽ kãm ixkapẽr anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","—Hãmri nhũm mẽ amỳm ri mẽ inhmex ã mẽ ixpumunh o kuhê. Kaxkwa kamã mẽ ixkĩnh nẽ ri mẽ inhmex nẽ ixpa hã amỳm mẽ ixpumunh o kuhê. Apraãw nẽ Ijak nẽ Jako nẽ Tĩrtũm kapẽr jarẽnh o mẽ pa xwỳnh piitã nhũm mẽ amỳm mẽ ixkĩnh nẽ mẽ ixàpkur mex ã mẽ ixpumunh o kuhê. Hãmri nẽ tee ri mẽ ixwỳr kãm gjêx prãm kaprỳ nẽ hkaprĩ nẽ mur nẽ amnhĩ krã hkĩ jarê nẽ amnhĩ kà nhê nẽ amnhĩ kamã gryk tỳx nẽ. No ãm tee ri amnhĩ kamã gryk kaprỳ. Ã koja mẽ amnhĩ nhĩpêx anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Nom Tĩrtũm kôt mẽ kot amnhĩ xunhwỳr xwỳnhjaja koja mẽ kurom pika piitã kurũm axpẽn wỳr akuprõ nẽ Tĩrtũm wỳr agjê nẽ kuri hkĩnh nẽ apkur mex o hkrĩ. Mẽ akwỳjaja nẽ pika piitã kurũm hohtô rax nẽ axpẽn wỳr akuprõ nẽ hwỳr agjê nẽ kuri apkur mex nẽ hkĩnh nẽ pa ho pa. ");
INSERT INTO apnNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","—Mẽ apê Ijaewjaja mẽ amã Ijaew kêt xwỳnhjê hprãm nõkati htã koja mẽ hkwỳjaja mẽ akwỳjê rom Tĩrtũm ri axpẽn wỳr akuprõ nẽ hkĩnh nẽ axpẽn kutã apkur mex o hkrĩ. Jakamã kwa kot kaj mẽ uràk nẽ amã Tĩrtũm mẽ wa ixwỳr agjêx prãm hã kot kaj mẽ ixkôt amnhĩ xunhwỳ nẽ ixkapẽr kôt amnhĩ nhĩpêx mex o ri apa. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Hãmri nhũm Parijew nhõ xwỳnh kwỳjaja Jejus wỳr mra nẽ kãm: —Pa. E ot pa mẽ awỳr mra. Kwa kêr ka ma Jerujarẽ hwỳr amõr kêt nẽ. Na ra mẽ hkĩnh wỳr pahi Eroxja pôj nẽ kot tanhmã ato kaxyw atã amnhĩ jarẽ pa mẽ kuma. Jakamã kwa mẽ hwỳr amõr kêt nẽ. Nhãm krĩ hõ hwỳr mãn mõ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Hãmri nhũm mẽ kuma nẽ mẽ kãm: —Tk. Nà kot pa umaj nhãm krĩ hõ hwỳr inhmõr kêt nẽ. Kot paj ma mẽ hkwỳjê nê mẽkarõmnuti japôx pê mẽ hkwỳjê ho mex o ma hwỳr mõ. Pahi Erox kãm mẽ hpar pix prãm. E mẽ mãmrĩ ma akupỹm hwỳr mra nẽ ã kãm ixkapẽr jarẽnh anẽ. No kot paj umaj nhỹhỹm ixprõt nẽ ixtẽm nẽ kêp ixpimxur kêt nẽ. Ra ixte õ krĩ hwỳr inhnojarêt kênã. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Hãmri nẽ mẽ kot mar xwỳnhjê mã amnhĩ jarẽ nẽ mẽ kãm: —Kot paj tanhmã amnhĩ nhĩpêx to ho ri ixpa rãhã Jerujarẽ hwỳr mõn pôj nẽ kamã ty. Kamã na htem mẽ kot Tĩrtũm nhỹ hã kapẽr jarẽnh xwỳnhjê nhĩmex. Tã hwỳr kot paj mõ. Anẽ. Nhũm pre ã Jejus mẽ kãm amnhĩ jarẽnh anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Hãmri nẽ te ra kot Jerujarẽ nhõ xwỳnhjê pumunh o ãm nẽ mẽ kãm kapẽr pyràk o kapẽr nẽ mẽ kãm: —Hêxta waa nẽ mẽ apê Jerujarẽ nhõ xwỳnhjaja. Tĩrtũmja xatã mẽ awỳr ỹ hã kapẽr jarẽnh o mẽ pa xwỳnhjê rẽnh tã ka mẽ kapẽr mar kêt nẽ. Nẽ axtem nẽ kẽn o mẽ htak o mẽ himex o apa. Na ka htem ã amnhĩ tomnuj o apa anẽ. Tã arĩ inhmã mẽ ajamãr o ri ixpa hprãm. Te ho krãhyre kot nore hpro nẽ ho hikwỹ pyràk o na pa inhmã mẽ anhĩpêx prãm tã ka mẽ apê ixprãm nõkati nẽ ixkaga. ");
INSERT INTO apnNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Mỳrapê koja Tĩrtũm mẽ anhõ krĩ jamãr kêt nẽ. Kot paj tokyx ty nẽ mẽ apiitã mẽ are nẽ ma akupỹm api ka mẽ axte ixpumunh kêt nẽ. Ãm akupỹn ixwrỳk xà hã arĩgrota pix ã koja mẽ akwỳjaja mẽ amỳr pê krĩ ja hwỳr ixwrỳk kãm ixpumu. Hãmri nẽ mẽ akurom ixpumu nẽ hkĩnh tỳx nẽ. Nẽ tã ixkôt amnhĩ xunhwỳ nẽ axpẽn mã ijarẽnh o: E ota Tĩrtũm kot mẽ pahwỳr mẽnh xwỳnhta pôj. Nà ãm hãmri na mẽ pahwỳr wrỳ. Na mex kumrẽx. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Tã nhũm sap nhũm Jejus ma Parijew nhõ xwỳnhjê krãhtũm kutã apkur kaxyw õrkwỹ hwỳr tẽ. Hãmri nhũm mẽ wa hã htu rax nẽ Jejus apkur ã tãnopxar o kuhê. Mẽ kot amnhĩ nhĩpêx kwỳm ri tanhmã amnhĩ nhĩpêx to nhũm mẽ kot hã omunh nẽ ra hã àmnênh kaxyw nhũm mẽ kuri htãnopxar o kuhê. ");
INSERT INTO apnNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Nhũm ixkreja kamã mẽhõ my hte hikot xwỳnh mẽ kuri xa. ");
INSERT INTO apnNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Hãmri nhũm Jejus omu nẽ hã Parijew nhõ xwỳnhjê mẽ Tĩrtũm kapẽr tũm o mẽ ahkre xwỳnhjê kukja nẽ mẽ kãm: —Kwa mẽ inhmã mẽmoj jarẽ. Jarãhã na mẽ panhõ arĩgromnu pê sap. Tanhmã na pre finat Mojesja Tĩrtũm nhỹ hã mẽ pahte sap ã tanhmã amnhĩ nhĩpêx to hã mẽ pamã karõ hto? Xà kot puj mẽ akupỹm mẽ ho mex nà? Kot puj mẽ ãm mẽ omu nẽ akupỹm mẽ ho mex kêt nẽ? E mẽ atõ inhmã ja jarẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Hãmri nhũm mẽ kuma nẽ tanhmã kutã kãm nẽ hkêt nẽ. Ãm akryk mar o kuhê. Mẽ kot tanhmã kãm nẽ nhũm kot ta pãnhã mẽ kãm tanhmã nẽ pymaj nhũm mẽ akryk mar o kuhê nẽ tanhmã kutã kãm nẽ hkêt nẽ. Hãmri nhũm tee ri mẽ omu hãmri nẽ myja ã ĩhkra xi nẽ akupỹm ho mex. Hãmri nẽ hano nhũm ma akupỹm mex nẽ hkĩnh nẽ ma tẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Hãmri nhũm Jejus mẽ kãm: —E mẽ inhma. Xà koja mẽ akra sap ã mẽ apê ahkrehti xupỳm kãm tẽm ka mẽ ãm omu nẽ arĩgro mex jamãr pê tokyx ho axàpir kêt nẽ? Nà kot kaj mẽ ho axàpir kurê kumrẽx. Rỳ koja akrit môx gyw mã axà xàt ka mẽ omu nẽ ãm omu nẽ arĩgro mex jamãr pê tokyx hkaxàr kêt nẽ? Nà kot kaj mẽ hkaxàr kurê kumrẽx. Na htem sap ã tanhmã mẽ ho mex to ho pa. Mẽ panhõ arĩgromnu htã pu htem hã tanhmã mẽ ho mex to. Jakamã na pa ã hã myta ho mex kurê kumrẽx anẽ nẽ ri arĩgro mex jamãr kêt nẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Nhũm pre ã Jejus mẽ kãm amnhĩ jarẽnh anẽ nhũm mẽ kuma nom kutã kãm mẽmoj jarẽnh kêt nẽ. Ra kot akupỹm ho mex jakamã nhũm mẽ tanhmã hã kãm nẽ hkêt nẽ kuhê. ");
INSERT INTO apnNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Hãmri nhũm mẽ apkur kaxyw mẽ hkrĩ xà hã hkrĩ hpa. Nhũm mẽ hkwỳjaja hkwỳjê pê amnhĩ to wa nẽ mẽ hkrĩ xà mex kãm hkrĩ hpa. Hãmri nhũm Jejus ja hã mẽ omunh o xa nẽ axte mẽ kãm mẽmoj jarẽ. No ãm mẽmoj tã kuxi nẽ mẽ kãm awjarẽ nẽ mẽ kãm: ");
INSERT INTO apnNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","—Nà koja mẽ axpẽn mã mẽhõ rer kaxyw nẽ amnhĩ wỳr mẽ atã karõ. Mẽ ate kutã axàpkur kaxyw. Hãmri kêr ka mẽ hwỳr mra nẽ axàpkur kaxyw nẽ kupĩp kãm akrĩ kurê kumrẽx. No kot kaj mẽ kêp amnhĩ to wa nẽ mẽ hkrĩ xà mex pytà nẽ hã akrĩ nhũm ra kot amnhĩ to rax xwỳnhjê hõja hapu hã mẽ akôt tẽn axà. ");
INSERT INTO apnNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Hãmri nhũm ixkre nhõ dõn kot amnhĩ wỳr mẽ awỳr xwỳnhta mẽ hkrĩ xà mexta ã mẽ awỳ nẽ mẽ amã: “Kwa mẽ atõ kànhmã xa nẽ kãm mẽ hkrĩ xà kaprã.” Anẽ. Hãmri ka nhãm xa nẽ kãm anhỹr xàta gõ. Hãmri nẽ apijaàm kãm hpãnhã kupĩp kãm nhỹ. ");
INSERT INTO apnNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Ja pymaj kêr ka mẽ kupĩp kãm akrĩ kurê kumrẽx. Kê ixkre nhõ dõnja tee ri ja hã mẽ apumu nẽ mẽ amã: “Tk. Kwa ixkràmnhwỳjaja. Mẽ kupĩp kãm akrĩ hkêt nẽ. Kwa mẽ mra nẽ jar mẽ hkrĩ xà mex ã mãn akrĩ.” Anẽ hãmri nhũm ja mẽ amã mex nẽ. Nhũm mẽ piitã kot mẽ ato mex ã mẽ atã omu ka mẽ ajaxwỳja amnhĩ tã omu nẽ akĩnh nẽ ajamakêtkati nẽ akrĩ. ");
INSERT INTO apnNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","—Nẽ koja mẽhõ te amnhĩ to rax o hkwỳjê jakrenh pyràk o amnhĩ nhĩpêx o ri pa hãmri nhũm Tĩrtũm ja hã omu nẽ tanhmã hã ho. Hãmri nhũm ra amnhĩ to grire hã amnhĩ pumunh o ri pa nẽ rĩ amnhĩ pumu. Nom koja mẽhõ amnhĩ to rax o hkwỳjê jakrenh pyràk o amnhĩ nhĩpêx o ri pa hkêt nhũm Tĩrtũm ja hã omu hãmri nẽ tãm amnhĩm kot amnhĩ to rax xwỳnh ã harẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Nhũm pre ã Jejus mẽ ahkre anẽ hãmri nẽ hpãnhã mẽ apkur xà hã ixkre nhõ dõnja mã kapẽr nẽ kãm: —Nà na ka hte amnhĩ wỳr akwỳjê pix wỳ. Atõjê hwỳ nẽ akràmnhwỳjê hwỳ. Nẽ mẽ hikàxpore rũnh xwỳnhjê hwỳ. Nom nhỹrmã mẽ kot amnhĩ xwar amnhĩ nhõrkwỹ hwỳr awỳr pix kaxyw na ka hte ã amnhĩ wỳr mẽ hwỳr anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","No kêt amnhĩ wỳr mẽ no kre xwỳnhjê mãn wỳ. Nẽ mẽ hyk o mẽ pa xwỳnhjê mãn wỳ. Nẽ mẽ hkrã pipãnh puro xwỳnhjê mãn wỳ. Nẽ mẽ hpigêx tỳx xwỳnhjê mãn wỳ. Nẽ mẽ hirot nẽ àpênh kêt xwỳnhjê mãn wỳ. Kêr ka amnhĩ wỳr jajê mãn wỳ kê mẽ awỳr mra nẽ akutã apku. ");
INSERT INTO apnNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Mo mẽ kot amnhĩ xwar awỳr kaxyw mẽ õ mẽmoj? Mẽ kêp amrakati. Tã kot kaj mãmrĩ amnhĩ wỳr mẽ awỳ nhũm Tĩrtũm mẽ hã apumu hãmri nẽ nhỹrmã kot akupỹm mẽ ho htĩr xà hã arĩgrota ã mẽ hã amã mẽmoj mex gõ nẽ ato mex nẽ. Hãmri ka akĩnh nẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Hãmri nhũm mẽ apkur kaxyw hkrĩ pa nhũm Jejus nhĩhkô hã mẽ apkur o mẽ krĩ xwỳnhjê hõja tanhmã Jejus mã kapẽr to nẽ kãm: —Hêxta waa nẽ. Kot puj mẽ nhỹrmã Tĩrtũm nhõ krĩ hwỳr api nẽ kutã paxàpkur o pahkrĩ nẽ pahkĩnh tỳx kumrẽx. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Hãmri nhũm kuma nẽ kê axte mẽ ahkre. Mẽ kot Tĩrtũm kutã apkur kaxyw kot amnhĩ wỳr mẽ hwỳrta ã nhũm mẽ ahkre. No ãm hã kuxi nẽ tanhmã mẽ kãm ujarẽnh to nẽ mẽ kãm: —Koja mẽhõ amnhĩ wỳr mẽ ho ohtô nẽ mẽ kot kutã mẽ apkur mex kaxyw mẽ kuwỳ. ");
INSERT INTO apnNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Hãmri nẽ mẽ hwỳr kãm àpênh xwỳnh mẽ nẽ kãm: “E ma tẽ nẽ mẽ kãm awjarẽ kê mẽ tokyx mra pa mẽ apku.” Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Hãmri nhũm kuma nẽ ma mẽ hwỳr mẽ kãm ujarẽnh o tẽ. Hãmri nẽ wamta mã anẽ nhũm kuma hãmri nẽ hitõt nẽ kãm: “Nà kot paj hwỳr ixtẽm kêt nẽ. Na pa ham amnhĩm pika hkwỳ japrô. Jakamã kot paj ma hwỳr tẽ nẽ ixprĩ hã omu mãn. Kwa kêr ka kãm ijarẽ kê ixte tanhmã hã nẽ xà hkôt ã ixte amnhĩ nhĩpêx anhỹrja mã hamaxpẽr kêt nẽ.” Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","—Hãmri nhũm kuma nẽ hpãnhã nhãm ja wỳr tẽ nẽ kãm awjarẽ nhũm kuma nẽ haxwỳja hitõt nẽ kãm: “Nà kot paj hwỳr ixtẽm kêt nẽ. Na pa ham amnhĩm môx o 10 nẽ haprô. Jakamã kot paj ma hwỳr tẽ nẽ ixprĩ hã ri omu mãn. Kwa kêr ka kãm ijarẽ kê tee ri tanhmã hamaxpẽr to hkêt nẽ. Ixte tanhmã hã nẽ xà hkôt ã ixte amnhĩ nhĩpêx anhỹr kêt.” Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","—Hãmri nhũm kuma nẽ hpãnhã ma ihõta wỳr tẽ nẽ kãm awjarẽ nhũm kuma nẽ haxwỳja hitõt nẽ kãm: “Nà kot pa hwỳr ixtẽm kêt nẽ. Na pa kormã ham ixprõ. Kormã ixprõ nyw nẽ inhmã rer prãm kêt jakamã kot paj ma hwỳr ixtẽm kêt nẽ.” Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","—Hãmri nhũm kãm àpênh xwỳnhta tee ri mẽ kuma nẽ awjanã nẽ ma akupỹm tẽ. Kot ma mẽ hwỳr mẽnh xwỳnhta wỳr ma akupỹm tẽ nẽ kãm mẽ harẽ. Hãmri nhũm tee ri mẽ harẽnh ma nẽ mẽ kamã gryk nẽ. Hãmri nẽ hpãnhã mẽ kêp amrakati xwỳnhjê hwỳr kãm àpênh xwỳnhta mẽ. Mẽ hkrã pipãnh puro xwỳnhjê hwỳr kumẽ. Nẽ mẽ hpigêx tỳx xwỳnhjê hwỳr kumẽ. Nẽ mẽ hirot nẽ àpênh hkêt xwỳnhjê hwỳr kumẽ nhũm ma mẽ kãm ujarẽnh o tẽ. Hãmri nẽ amnhĩ kôt mẽ kuwỳ nhũm mẽ kuma nẽ wamtajê rom hkôt mrar kurê kumrẽx. Hãmri nẽ agjê nẽ apkur kaxyw mẽ hkrĩ xà kamã hkrĩ hpa. ");
INSERT INTO apnNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Hãmri nhũm kãm àpênh xwỳnhja õ patrãw wỳr tẽ nẽ kãm mẽ harẽ nẽ kãm: “E ate mẽ hã karõ xàta kôt na mẽ ra hkrĩ hpa htã arĩ mẽ hkrĩ xà hkwỳ hkaprỳ.” Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","—Hãmri nhũm kuma nẽ kãm: “Hêxta waa nẽ. Kêt ãm mẽ hkrĩ xàta hipu mex ronhỹx pa omu nẽ ixkĩnh nẽ. No ãm kormã piitã hipu hkêt. Kwa ma krĩ pu hã ri mẽ hapêr o mra. Nẽ nhỹri mẽ hkwỳjê pumu nẽ mẽ haprô nẽ man amnhĩ kôt mẽ o mra kê mẽ hkrĩxà ho hipu hpa. ");
INSERT INTO apnNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","No kêt wam ixte amnhĩ wỳr mẽ hwỳr xwỳnhtaja. Mẽ hitõt xwỳnhjaja kot paj axte amnhĩ wỳr mẽ hwỳr kêt nẽ.” Anẽ. Ã mẽ ujarẽnh kot anhỹr. Na hte ã Tĩrtũm amnhĩ wỳr mẽ piitã mẽ hwỳr anẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Tã nhũm Jejus mẽ õrkwỹ rũm kato nẽ kormã Jerujarẽ hwỳr mõ nhũm mẽ hohtô rax nẽ hkôt mõ. Hãmri nhũm Jejus xa nẽ mẽ ho hakẽx nẽ mẽ omu nẽ mẽ kãm: ");
INSERT INTO apnNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","—E kot ka mẽ atõ amã ixkôt amnhĩ xãm prãm nẽ ã amnhĩ nhĩpêx anẽ. Nẽ amã atõ nẽ atõx nẽ anhĩpêêxà nẽ akatorxà japê htỳx tã kêr ka amã ixkĩnh tỳx o wa mẽ hakrenh pa. Nẽ amã aprõ nẽ akrajê japê htỳx tã kêr ka amã ixkĩnh tỳx o wa mẽ piitã mẽ hakrenh pa. Nẽ amã ixkĩnh tỳx o amã amnhĩ japê jakre. Kêr ka mẽ atõ ixkôt amnhĩ xãm kaxyw nẽ ã amnhĩ nhĩpêx anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","—Koja mẽ ixpĩ pa mẽ anê ty. Tã mẽ ate ixkôt amnhĩ nhĩpêx o mẽ apa xwỳnhjaja. Koja mẽ ixtã mẽ apar mã tã kêr ka mẽ amã ixkĩnh tỳx o mẽ umaj ixkaga hkêt nẽ. Kwãr mẽ mãmrĩ tanhmã ixtã mẽ ato. Kot kaj mẽ nhỹrmã Tĩrtũm mẽ wa ixri axte amnhĩ xà kamã ajamak kêt nẽ atĩr tũm nẽ amex rãhã apa ho apa. Nom kot kaj mẽ ixkĩnhã jar pika ja kamã amã amex nẽ apa hprãm xàj ixkaga hãmri nẽ nhỹrmã wa ixri atĩr tũm nẽ apa hkêt nẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Nhũm Jejus arĩ mẽ kãm kapẽr nẽ mẽ kãm: —Kwa kêr ka mẽ ixkôt amnhĩ xunhwỳr kaxyw nẽ amnhĩ kukamã ajamaxpẽr mex nẽ. Na htem amnhĩm õrkwỹ rũnh nhĩpêx kaxyw hãmri nẽ hkukamã hamaxpẽr mex nẽ. Nẽ kaxyw krax mã kuhê xà hkukamã hamaxpẽr. Nẽ kaxyw kỳx pê kãm hikwỹ xàja kukamã hamaxpẽr. Nẽ õkwaêja kukamã hamaxpẽr. Nẽ hã pôja kukamã hamaxpẽr. Ã na htem amnhĩm õrkwỹ rũnh nhĩpêx kaxyw hkukamã hamaxpẽr mex anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Nom kot kaj mẽ hkukamã ajamaxpẽr mex kêt nẽ ãm kaxyw pĩ ho grêre nẽ hakà. Rỳ ra hã axàpênh rax kurê ra amã ho anhỹr kaga nẽ hkaga hpa nẽ hatur xàm mẽnh kêt nẽ. Hãmri nhũm mẽ hkwỳjaja hãnh mra nẽ omu nẽ atã hpẽr o axkẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Nẽ axpẽn mã ri ajarẽnh o: “E ga mẽ ixkre mũj pumu. Na pre hipêx xwỳnhja hkurê kãm kaga nẽ hipêx par kêt nẽ.” Anhỹr o axpẽn mã ajarẽ. Ja pyrà nẽ kêr ka mẽ ixkôt amnhĩ xunhwỳr kaxyw nẽ amnhĩ kukamã ajamaxpẽr mex nẽ. Nẽ ajamaxpẽr o: “Nà mẽ kot Jejus ã tanhmã ixto htỳx tã kot paj hkaga hkêt nẽ. Kot paj hkôt amnhĩ nhĩpêx rãhã ho ri ixpa.” Anhỹr o amnhĩ kukamã ajamaxpẽr. Hãmri nẽ rĩ kormã ixkôt amnhĩ xãm. No kot ka mẽ umaj ixkaga hkukamã ajamaxpẽr hãmri nẽ ixkôt amnhĩ xãm kêt kurê kumrẽx. ");
INSERT INTO apnNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","—Nẽ koja krĩ hõ kamã pahihti nhõ pôristi xohtô nẽ. Nẽ kutã nhãm krĩ hõ kamã pahihti nhõ pôristija grêre. Tã nhũm wa hpijapu kaxyw nhũm krĩ hõ rũm pahihti nhõ pôristi xohtôja mẽ grêreta wỳr mra. Hãmri nhũm kutã krĩ hõ kamã mẽ õ pôristi grêre nhõ pahi nhỹ nẽ tee ri mẽ amnhĩ kukamã hamaxpẽr nẽ hamaxpẽr o: “Kwa koja apu krĩ hõ rũm pôristi xohtô raxja nhũm inhõ pôristi grêreja mẽ axpẽn kutã kuhê nẽ axpu nhũm mẽ inhnê mẽ himex. Nà inhõ pôristi grêre kênã.” Anhỹr o hamaxpẽr. ");
INSERT INTO apnNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","—Hãmri nẽ pahi hõta wỳr õ kôwenatô mẽ. Kormã krĩ hõ rũm mẽ hohtôtaja mẽ htêp kêt nhũm mẽ kutã kumẽ nhũm ma mẽ kutã tẽ. Hãmri nẽ awry hã mẽ hkaxpa nẽ mẽ õ pahihti mã kãm: “E na mẽ inhõ pahihti akutã inhmẽ pa tẽ. Na inhmã: ‘Ma tẽ nẽ mẽ kãm awjarẽ. Kot puj pẽr mẽ papijapu hkêt nẽ. Kwarĩ. Kot puj mẽ tãm axpẽn xunhwỳ.’ Anhỹr o kapẽr nẽ mẽ akutã inhmẽ pa tẽ.” ã mẽ ujarẽnh kot anhỹr. Ja pyrà nẽ na htem mẽmoj kukamã hamaxpẽr mex nẽ rĩ kormã tanhmã amnhĩ nhĩpêx to. ");
INSERT INTO apnNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","—Tã kêr ka mẽ atõ amã ixkôt amnhĩ xãm prãm hãmri nẽ pahita pyrà nẽ amnhĩ kukamã ajamaxpẽr tỳx nẽ rĩ kormã tanhmã amnhĩ nhĩpêx to. Kêr ka ate inhmã tanhmã amnhĩ nhĩpêx to ho apa kaxyw hãmri nẽ inhgryk ã te ate amã amnhĩ japê hkêt pyràk o mẽmoj piitã mã anhĩhkra karo pyràk o amnhĩ nhĩpêx. Hãmri nẽ rĩ kormã ixkôt amnhĩ xãm. ");
INSERT INTO apnNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","35","No kot kaj mẽ amnhĩ kukamã ajamaxpẽr kêt nẽ atỳx ri ixkôt amnhĩ xunhwỳr japêr. Hãmri nẽ mẽmo arĩgro hã mẽ kot ixtã tanhmã mẽ ato xwỳnhjê pymaj ra ixkaga mã. Hã kot kaj mẽ te mẽ ate kaxwa punu pyràk o amnhĩ nhĩpêx. Kaxwaja mẽ apkur xà kamã mex. Na htem amnhĩm ho õ xành nẽ kuku. Nom koja mẽhõ kamã pika hkwỳ mẽ nẽ ho ahkà hãmri tanhmã kot mẽ ho nẽ akupỹm ho mex? ãm mẽ kot hkapĩr pix kaxyw koja mex. Ja pyrà nẽ kot ka mẽ atõ ate inhmã tanhmã amnhĩ nhĩpêx to ho apa hã amnhĩ jarẽnh tã gaa nẽ amã ixkôt amnhĩ nhĩpêx prãm nõkati. Hãmri nẽ ra te ate kaxwa punu kapĩr mã tãmta pyràk. E kwa mẽ mẽmoj tã ixujarẽnhja ma nẽ mẽ uràk nẽ amnhĩ kukamã ajamaxpẽr mex nẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Tã nhũm mẽ kot pahihti mã hkwỳjê pê kàxpore hkwỳ jamỳnh xwỳnhjê mẽ mẽ kot amnhĩ tomnuj xwỳnhjaja Jejus kapẽr mar kaxyw hwỳr mra. ");
INSERT INTO apnNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Hãmri nhũm Parijew nhõ xwỳnhjê mẽ mẽ kot Tĩrtũm kapẽr tũm o mẽ ahkre xwỳnhjaja mẽ hã Jejus pumu. Hãmri nẽ kê wem axte axpẽn mã tanhmã ho kapẽr punuj to nẽ axpẽn mã: —Tk. Kwa na hte mũjti axtem nẽ mẽ kot amnhĩ tomnuj xwỳnhjaja amnhĩ wỳr mẽ kuwỳ nẽ tõhã mẽ kutã apku. Kwa mẽ kot amnhĩ tomnuj xwỳnh kênã kot kêt mẽ kutã apkur o pa. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Hãmri nhũm Jejus amnhĩ tã mẽ kuma nẽ tanhmã mẽ kãm kapẽr to. Nom hprĩ hã mẽ kãm kapẽr kêt nẽ. Kê ãm amnhĩ tã kuxi nẽ mẽ kãm ôwêhti pikunor jarẽ nẽ mẽ kãm: ");
INSERT INTO apnNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","—Koja mẽhõ õ ôwêhti xohtô nẽ. Nẽ ma nhỹri hamãr o pa. Hãmri nhũm pyxire nẽ hkwỳ kaga nẽ ma nhỹhỹm ahte tẽ nẽ akunok. Hãmri nhũm õ dõnja ma kot akupỹm piitã o mõr kaxyw hkwỳ ho pikuprõnh pa hãmri nẽ tee ri hkwỳ kaêx ã pikunor xwỳnhta japêr. Hãmri nẽ ma hkwỳ ho mõ nẽ nhỹri kure. Kot nhỹri kutêp apkur o ri pa kaxyw kure hãmri nẽ ma akupỹm pikunor xwỳnhta japêr o tẽ. Hãmri nẽ hapêr ryy nẽ nhỹri hwỳr kato. ");
INSERT INTO apnNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Nẽ omu nẽ hkĩnh tỳx nẽ. Hãmri nẽ amnhĩ kre hã kumẽ nẽ ma akupỹm hkwỳ hwỳr o tẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Hãmri nẽ mẽ ĩhkô hã kumẽ nẽ hkĩnh nẽ hkràmnhwỳjê ho akuprõ nẽ õrkwỹ htã mẽ õrkwỹ xwỳnhjê ho akuprõ nẽ mẽ kãm: “Kwa na pre ixpê ixkriita õ akunok. Pa pre hapêr kãm ixihtỳx nẽ kãm ixkato nẽ omu nẽ ixkĩnh nẽ. Jakamã kwa wem mããnẽn inhỹ hã akĩnh.” Anẽ. —Ã mẽ ujarẽnh kot anhỹr. ");
INSERT INTO apnNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Ja pyrà nẽ koja mẽ kot amnhĩ tomnuj tỳx xwỳnhjê hõ tee ri amnhĩ pumu nẽ kot amnhĩ tomnuj kaga nẽ Tĩrtũm kôt amnhĩ xãm. Hãmri nhũm kaxkwa kamã mẽ piitã ja hã omu nẽ hkĩnh tỳx nẽ. Te ho my kot ôwêhti hpikunor xwỳnh mã kator nẽ hkĩnh tỳxta pyràk. Na hte Tĩrtũm tãm mẽ kot amnhĩ nhĩpêx o mẽ pa xwỳnhjê pumu nẽ hkĩnh nẽ. Tã koja mẽhõ kot amnhĩ tomnuj tỳx tã ã amnhĩ nhĩpêx anhỹrja kaga nẽ Tĩrtũm kôt amnhĩ xãm hãmri nhũm amnhĩ tã omu nẽ hkĩnh tỳx nẽ. Jakamã na pa hte mẽ akurom ã mẽ kot amnhĩ tomnuj xwỳnhjê hkôt Tĩrtũm kapẽr o mẽ ahkre rãhã ho ri ixpa. Anẽ. Nhũm pre ã Jejus mẽ kot tanhmã ho kapẽr punuj to xwỳnhjê mã amnhĩ jarẽnh anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Nhũm Jejus arĩ mẽ kãm awjarẽ nẽ mẽ kãm: —Nẽ ja. Koja mẽhõ ni hikàxpore kêp 10. àpênh o arĩgro pê 10 pãnhã kàxpore kêp 10. Tã ho pyxi nẽ ho akunok. Hãmri nẽ tee ri hapêr nẽ hkaprĩ nẽ. Hãmri nẽ kanê hpôk nẽ hitom kapõnh pê hprĩ hã hapêr o ri pa nẽ kãm kato. ");
INSERT INTO apnNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Hãmri nẽ kupy nẽ hkĩnh nẽ hkràmnhwỳjê ho akuprõ nẽ õrkwỹ htã mẽ õrkwỹ xwỳnhjê ho akuprõ nẽ mẽ kãm amnhĩ jarẽ nẽ mẽ kãm: “Xê na pre ixpê ixkàxpore hõta akunok pa tee ri hapêr tã akupỹm kãm ixkato nẽ kupy nẽ ixkĩnh nẽ. Jakamã xê wem inhỹ hã mããnẽn akĩnh.” ã mẽ ujarẽnh kot anhỹr. ");
INSERT INTO apnNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","—Ja pyrà nẽ koja mẽ kot amnhĩ tomnuj xwỳnhjê hõ pyxire nẽ amnhĩ tomnuj kaga nẽ ixkôt amnhĩ xãm. Hãmri nhũm kaxkwa kamã mẽ piitã ja hã omu nẽ hkĩnh nẽ. Te mẽhõ ni kot kàxpore pikunor xwỳnh mã kator nẽ hkĩnhta pyràk. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Nhũm Jejus arĩ mẽ ahkre ho xa. Tĩrtũm kãm mẽ piitã mẽ hapê htỳx ã mẽ ahkre ho xa. No kê ãm hã kuxi nẽ kê we tanhmã mẽ kãm ujarẽnh to nẽ mẽ kãm: —Nẽ koja mẽhõ hkra my wa axkrut. ");
INSERT INTO apnNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Hãmri nhũm kot hapu õ papaj wỳr tẽ nẽ kãm: “E papaj. Ot pa awỳr tẽ. Kot kaj nhỹrmã ty pa wa amỳr pê akukrêx o ixàrĩk. Jakamã e kwa tokyx atĩr ri amnhĩ kamã wa inhmã ho axkjê pa inhõ ho amnhĩptàr kurê kumrẽx nà?” Anẽ. Hãmri nhũm kuma nẽ wa kãm hikukrêx o axkjê. Kot wa mã hkwỳ gõ nẽ kot hapu mã hkwỳ gõ. ");
INSERT INTO apnNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Hãmri nhũm kot haputa ãm ri hipêêxà hkôt pa hkrãnre hãmri nẽ kot kãm hikukrêx nhõr jamỳnh pa nẽ ma nhỹhỹm o mõ nẽ ho wẽnê hpa. Hãmri nẽ hpãnhã kàxpore jamỳ nẽ ma nhỹhỹm mõ. Nhỹhỹm awry hã pika hõ hwỳr ma mõ. Mõõ hãmri nẽ krĩ hõ kamã htỳx ri tanhmã amnhĩ tomnuj to ho ri pa. Hãmri nẽ gaa nẽ ra mẽ hkuprỳjê hã kàxpore ho hapêx pa. Nẽ kagôxỳhti hã ho hapêx pa. Nẽ gaa hãmri nẽ hikàxpore hkêt nẽ ri pa. ");
INSERT INTO apnNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","—Rôm nhũm pikaja kamã mẽ hã na wrỳk kêt ry rax nẽ. Nẽ gaa nhũm mẽ hpur kãm mẽ kêp mẽ apkur xà hã mẽõja hapêx pa. Jakamã nhũm mẽ hkra kot haputa kêp amrakati nẽ kãm prãm tỳx nẽ ri pa. Hãmri nẽ tee ri amnhĩ kukamã hamaxpẽr. ");
INSERT INTO apnNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Hãmri nẽ amnhĩ to krĩ nhõ xwỳnhjê mar o ri pa. Kot mẽ kãm tanhmã àpênh to nẽ hpãnhã apkur kaxyw. Hãmri nhũm mẽhõ kot kãm hkrit hagrô jamãr kaxyw hã kumẽ nhũm ma hwỳr tẽ nẽ kãm hamãr o pa. Nom kot kãm hamãr o pata pãnhã ãm kãm mẽmoj nhõr kryre nhũm arĩ kãm prãm tỳx kumrẽx. ");
INSERT INTO apnNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Nẽ tee ri kot hagrô kutã õta kur prãm nẽ tee ri omunh o pa. ");
INSERT INTO apnNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","—Nẽ gaa hãmri nẽ tanhmã hamaxpẽr to. Nẽ tee ri kot tanhmã amnhĩ tomnuj toja ã amnhĩ pumu nẽ hamaxpẽr o: “Hêxta waa nẽ. Mãn mũtar inhõ krĩ kamã inhõ papaj mã mẽ àpênh xwỳnhjaja ixrom apkur mex o pa. àpkur mex nẽ nhũm mẽõ jakrêx prãr rũnh tã pa jar mẽ hkĩnhã prãm xàj ra ixtyk o mõ. ");
INSERT INTO apnNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Nà kot paj ma akupỹm mõ. Hãmri nẽ inhõ papaj pumu nẽ ã kãm amnhĩ jarẽnh anẽ nẽ kãm: ‘Kwa Papaj. Na pa pre ixpê akra hã amnhĩ tomnuj tỳx kumrẽx nhũm ja apê omnuj nẽ. Nhũm Tĩrtũm pê ja omnuj nẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Jakamã na pa ixpê akra hã amã amnhĩ jarẽnh ã ixpijaàm nẽ. Ixte tãm kêt kumrẽx. Jakamã kwa xà kot pa amã mẽmoj tã ixàpênh o ri ixpa ka hpãnhã inhmã inhõ pa apku nà?’ Anhỹr o kot pa kãm amnhĩ jarẽ. Nà kot paj anẽ.” ");
INSERT INTO apnNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","—Anhỹr o amnhĩ kukamã hamaxpẽr hãmri nẽ ma akupỹm mõ. Mõõ nẽ ra hpôx o mõ. Nẽ kormã amỳm mõr ri nhũm õ papaj hwỳr rĩt nẽ omu nẽ amnhĩ kra hã omunh kurê kumrẽx nẽ hkĩnh nẽ ma kutã hprõt nẽ tẽ. Omu nẽ kãm hkaprĩ nẽ. Nẽ hwỳr hprõt nẽ hkaxpa nẽ kahti hkôt kumỳ. ");
INSERT INTO apnNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Hãmri nhũm kãm amnhĩ jarẽ nẽ kãm: “Kwa papaj. Na pa pre amnhĩ tomnuj nẽ nhũm ja apê omnuj nẽ. Nẽ Tĩrtũm pê ja omnuj nẽ. Jakamã ixte ixpê akra hã amã amnhĩ jarẽnh ã ixpijaàm. Ixte tãm kêt kumrẽx.” Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Nom kormã kãm amnhĩ jarẽnh par kêt ri nhũm hipêêxà kãm mẽ àpênh xwỳnhjê mã akir nẽ mẽ kãm: “E kwa mẽ atõ ma tẽ nẽ kãm ê mex õ py nẽ akupỹn ixkrata wỳr ho aprõt nẽ kãm haxà. Nẽ hpar kà nẽ ĩhkra kamã kàx nẽ amnẽ kãm hamỳ nẽ ho aprõt. ");
INSERT INTO apnNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Nẽ akupỹm aprõt nẽ môx kra htwỳm mexta õ pumu nẽ unê nẽ apĩ. Nẽ mẽ ho anẽ pu mẽ ixkra hã pahkĩnh nẽ apku. E mẽ amnhĩ prêprêk nẽ tokyx ã amnhĩ nhĩpêx anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Na pre ma ixpê mõr o te ixpê htyk pyràk. Tã akupỹn mõ nẽ ixwỳr pôj nẽ te akupỹm inhmã htĩr pyràk. Jakamã e mẽ tokyj.” Anhỹr jakamã nhũm mẽ hã môx kra pĩ nẽ ho anẽ nẽ hkĩnh nẽ hã apkur o hkrĩ. ");
INSERT INTO apnNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","—Rôm nhũm hkra kot wata kormã pur kãm htỳx àpênh o xa. àpênh o ãm tã akupỹn hpôx o tẽ. Hãmri nẽ amnhĩ kukamã mẽ kot ri mẽmoj tatak nẽ mẽ grer ma. ");
INSERT INTO apnNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Hãmri nẽ tee ri hamaxpẽr o tẽ nẽ õrkwỹ hwỳr pôj nẽ kormã kapem xa nẽ mẽ hã mẽ àpênh xwỳnhjê hõ kukja nẽ kãm: “Kwa mẽmoj tã na ka wem ã akĩnh rax anẽ?” ");
INSERT INTO apnNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Anẽ nhũm kãm: “Nà mẽhõ hkêt. Atõ na akupỹn pôj nhũm anhĩpêêxà omu nẽ hkĩnh tỳx nẽ. Nẽ mẽ inhmã anẽ pa mẽ hã môx kra htwỳm mexja pĩ nẽ hã ho anẽ nẽ hã ixkĩnh nẽ hkur o ixkrĩ.” Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Hãmri nhũm tee ri htõ jarẽnh ma nẽ gryk tỳx nẽ. Hãmri nẽ gryk xàj kapem hkuk punuj o mẽ omunh o xa nẽ mẽ hwỳr àr kêt nẽ. Hãmri nhũm hipêêxàja tee ri omu nẽ hwỳr kato nẽ tee ri kot mẽ hwỳr ho àr kaxyw ho anhỹr kaprỳ. ");
INSERT INTO apnNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Hãmri nhũm kãm: “Tk. Kwa na pa hte amã ixàpênh rũnh rãhã ho ri ixpa hã ra ixtã amgrà xohtô nẽ. Nẽ aa akapẽr nhĩrôp tanhmã ixãm to hkêt. Tã ka hte ixpumunh nẽ akĩnh nẽ ixtã mẽmoj tõx pĩr kêt nẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Tã nhũm akra kot haputa apê akukrêx kwỳ jamỳnh pa nẽ ma o mõ nẽ axtem nẽ mẽ hkuprỳjê mã õr par tã akupỹn mõ nẽ pôj. Ka omu nẽ akĩnh nẽ hã môx kra twỳmta pĩ. Nà kot paj mẽ awỳr ixàr kêt nẽ.” Anẽ. —Hãmri nẽ gryk tỳx nẽ xa. ");
INSERT INTO apnNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Hãmri nhũm õ papaj tee ri kuma nẽ kãm: “Kwa nà ri ã akapẽr anhỹr kêt nẽ. Inhmã ajapê kênã. Na ka hte ixkôt apa ho apa rãhã nẽ. Nẽ ixkukrêx piitã kêp anhõõ. ");
INSERT INTO apnNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","No atõja na pre te ixpê htyk pyràk tã arĩ htĩr. Nẽ te pikunor pyràk tã te ra akupỹm kator pyràk jakamã na pa omu nẽ ixkĩnh nẽ. Nẽ inhmã hapê ho te mããnẽn inhmã ajapê pyràk.” Anẽ. —Ã mẽ ujarẽnh kot anhỹr. Ja pyrà nẽ koja mẽhõ te kot amnhĩ tomnuj tỳx o ri pa htã amnhĩ kaxyw Tĩrtũm mã hamaxpẽr nẽ amnhĩ to kuwỳ nẽ hkôt amnhĩ xãm. Hãmri nhũm amnhĩ tã omu nẽ hkĩnh nẽ. Nẽ kãm hprãm nẽ. No mẽ kajaja. Mẽ apê Parijew nhõ xwỳnhjê mẽ Tĩrtũm kapẽr tũm o mẽ ahkre xwỳnhjaja. Na ka htem mẽ kot amnhĩ tomnuj xwỳnhjaja kot Tĩrtũm kapẽr mar o kuhê hã mẽ omu nẽ Tĩrtũm kĩnhã akĩnh kêt nẽ. Nẽ te hkra kot wata jamaxpẽr pyràk o ajamaxpẽr nẽ tee ri ja hã mẽ omu nẽ mẽ kamã agryk nẽ. Nẽ mẽ amã mẽ hprãm nõkati. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Tã nhũm kê Jejus axte hkôt ri mẽ pa ho mẽ pa xwỳnhjê jahkre. No ãm mẽmoj tã kuxi nẽ mẽ kãm tanhmã ujarẽnh to nẽ mẽ kãm: —Nà koja mẽhõ hikàxpore rax xwỳnhja kãm àpênh xwỳnh mã mẽmoj to wẽnê ho pa kaxyw ãm. No nhũm kãm ho mex kêt nẽ. Axtem nẽ kêp amarĩ mẽ kãm mẽmoj to fiat par o mõ. Hãmri nhũm ra mẽhõ kot ã amnhĩ nhĩpêx anhỹr ã omu nẽ ma õ patrãw wỳr tẽ nẽ kãm harẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Hãmri nhũm tee ri harẽnh ma nẽ amnhĩ wỳr hã karõ. Hãmri nhũm hwỳr tẽ nẽ axà nhũm kãm: “Pa. Kwa xà ãm hãmri na mẽ inhmã ajarẽ? Kwa nà mon ka ri axtem nẽ ã ixpê inhõ mẽmoj nhĩpêx anẽ? E inhmã ate mẽ kãm ho fiat par xwỳnhjê nhĩxi hã kagà nẽ inhmã agõ hãmri nẽ ma tẽ. Kot ka axte inhmã axàpênh kêt nẽ rĩ amnhĩ pumu.” Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","—Hãmri nhũm kuma nẽ tee ri amnhĩ kukamã hamaxpẽr nẽ hamaxpẽr o: “Hêxta waa nẽ. Tanhmã kot paj amnhĩ to? Ixihtỳxre hã kot pa mẽhõ mã pur ã apê. Nom inhmã amarĩ ri ixàhwỳr o ri ixpa hprãm kêt. Ixte amnhĩ kuk ã ixpijaàm.” Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Hãmri nẽ tanhmã amnhĩ kukamã hamaxpẽr to nẽ hamaxpẽr o: “Nà kot paj amnhĩ wỳr ixte mẽ kãm ho fiat xwỳnhjê hã karõ. Nẽ mẽ kãm mẽ õ kõõta ahpar mã hkamẽ kê mẽ ãm inhõ patrãw mã hkwỳ pix gõ. Kêr kê mẽ amnhĩ tã ixpumu nẽ kãm ixkĩnh nẽ. Hãmri nẽ inhõ patrãw kot ixkaga hã ixtã harẽnh ma nẽ ixkamã ukaprĩ japêr. Hãmri nẽ amnhĩ wỳr ixwỳ pa ahpỹnhã mẽ kutã ixàpkur o ri ixpa nhũm prãm ixpĩr kêt nẽ. Nà kot paj anẽ.” Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Hãmri nẽ amnhĩ wỳr mẽ hã karõ nhũm mẽ hwỳr mra. Nhũm mẽ omu nẽ ja mã kãm: “E tanhmã na ka pre inhõ patrãw pê mẽmoj to fiat to? E inhmã harẽ.” Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Hãmri nhũm kãm: “Na pa pre kêp orti hã à ho 100 nẽ ho fiat. Ota hã kagàta. Tã pa kormã kãm amnhĩrer kêt nẽ.” Anẽ nhũm kuma nẽ kãm: “Tôe ka inhma. Kot paj amã anhõ kõt o gri ka ãm kãm ho 50 pix nẽ agõ pa ixte anhõ kõt ho ijapêx par pyràk o anhĩpêx.” Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Hãmri nẽ hpãnhã nhãm ja mã kãm: “No ka. Tanhmã na ka pre kêp mẽmoj to fiat to?” Anẽ nhũm kãm: “Na pa pre kêp pãy hã xak o 1.000 nẽ ho fiat. Tã pa kormã hpãnhã kãm amnhĩrer kêt nẽ.” Anẽ nhũm kãm: “Tôe. Kot paj hãmri amã anhõ kõt o gri ka ãm kãm ho 800 pix nẽ agõ pa ixte anhõ kõt ho ijapêx par pyràk o anhĩpêx.” Anẽ. Nhũm ã mẽ hipêx anẽ. Hãmri nẽ hamaxpẽr o: “E. Na pa mẽ kãm mẽ õ kõt o hkry pa. Koja mẽ amnhĩ tã kãm ixkĩnh japêr.” Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","—Hãmri nhũm õ patrãwja ã kot mẽ hipêx anhỹr ã harẽnh ma nẽ kãm: “Tk. Kwa ate pa ixkukamã ajamaxpẽr nẽ inhmã mẽmoj to anhỹr mex kêt tã ka amnhĩ kukamã ajamaxpẽr mex pê ã mẽ hipêx mex anẽ.” Anẽ. Ã mẽ ujarẽnh kot anhỹr. Anẽ. Nhũm pre ã Jejus mẽ kãm ujarẽnh anẽ. Hãmri nẽ mẽ kãm: —Tã ja pyrà nẽ na hte mẽ kot Tĩrtũm kôt amnhĩ xunhwỳr kêt xwỳnhjaja ãm amnhĩ pix kukamã hamaxpẽr mex o pa. Jao amnhĩ kaxyw pix mã mẽ piitã tanhmã mẽ ho mex to ho pa. Mẽ kot amnhĩ tã mẽ omunh nẽ mẽ kãm mẽ hkĩnh nẽ amnhĩ xwar tanhmã mẽ ho mex to kaxyw nhũm htem ã amnhĩ nhĩpêx anhỹr o pa. Tã mẽ ate ixkôt amnhĩ xunhwỳr xwỳnhjaja. Tĩrtũm kot tanhmã mẽ ate amnhĩ kwỳjê ho mex to hã amnhĩm mẽ ajarẽnh kaxyw kêr ka mẽ amnhĩ mẽ mẽ piitã mẽ hkukamã ajamaxpẽr mex nẽ. Pê tanhmã mẽ ho mex to ho ri apa. Ã mẽ ate amnhĩ nhĩpêx anhỹrja na mex. Nom kormã mẽ ate ã amnhĩ nhĩpêx anhỹr kêt. ");
INSERT INTO apnNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","—Hêxta waa nẽ. Mon ka htem mẽ uràk nẽ ã axpẽn to mex anhỹr kêt nẽ? Kwa mẽ àpênh xwỳnhta kot amnhĩ nhĩpêx pyrà nẽ tanhmã axpẽn to mex to o ri apa hkêt wehe. Jao akukrêx nẽ akàxpore ho anhõxỳ hkêt nẽ. Kêr ka nhỹrmã ty nẽ Tĩrtũm wỳr api nhũm ja hã mẽ ato mex rax nẽ. Te ho kot õ patrãw mã àpênh xwỳnhta kot tanhmã mẽ ho mex to xwỳnhjê hwỳr mrar nhũm mẽ kot amnhĩ xwar tanhmã ho mex tota pyràk. ");
INSERT INTO apnNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","11","—Na hte Tĩrtũm tanhmã mẽ pakute hã mẽ pahpumunh mex nẽ. Koja mẽ amã mẽmoj gõ ka mẽ kãm hprãm xà hkôt ho anhõxỳ hkêt nhũm ja hã mẽ apumu nẽ axte mẽ amã mẽmoj gõ. Nom hpãnhã mẽ amã õr rax o wamta jakre nẽ kugõ. Nom kot ka mẽ ri mẽmojta o anhõxỳ ho ri apa nhũm tee ri ja hã mẽ apumu nẽ axte mẽ amã mẽmoj nhõr kêt nẽ. Koja mẽ amã mẽmoj gõ ka mẽ ho anhõxỳ ho ri apa nhũm ja kêp homnuj nẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","—Nẽ kot kaj mẽ jar Tĩrtũm kot mẽ amã mẽmoj nhõr xwỳnhja ho anhõxỳ ho ri apa. Hã koja nhỹrmã kaxkwa kamã mẽ amã mẽmoj mex nhõr kêt nẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","—Nẽ kot kaj apyxi nẽ anhõ patrãw hamẽxkrut nẽ arĩgro pyxi hã hamẽ wa kãm axàpênh o amỹkry hkêt nẽ. Kot kaj anẽ nẽ hõ gryk ã hõ kaga. Ja pyrà nẽ kot kaj mẽ jar pika ja kamã akàxpore nẽ akukrêx pix kukamã ajamaxpẽr o ri apa hã kot kaj mẽ amã hapê htỳx nẽ mẽ kêp ho anhõxỳ ho ri apa. Nẽ akukrêx rax gryk ã Tĩrtũm kãm hprãm xà hkôt akukrêx o tanhmã axpẽn to ajuta hto ho ri apa hkêt nẽ. Ja pymaj kwa kêr ka mẽ ãm Tĩrtũm pix mã mãn ajamaxpẽr rãhã ho ri apa. Jao te akukrêx nẽ akàxpore mã axàmnhĩx ri anhĩhkra karo ho ri apa pyràk. Anẽ. Nhũm pre ã Jejus mẽ ahkre anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Hãmri nhũm Parijew nhõ xwỳnhjaja mar o kuhê. Na prem ra mẽ hikàxpore rax gryk ã Jejus kaga. Jakamã ã kot mẽ kãm kàxpore jarẽnh anhỹrja ma nhũm ja mẽ kêp omnuj nẽ nhũm mẽ hã hpẽr o pikẽnh o kuhê. ");
INSERT INTO apnNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Hãmri nhũm amnhĩ tã mẽ kuma nẽ mẽ kãm: —Nà na ka htem te mẽ ate tãm mẽ kot amnhĩ nhĩpêx xwỳnh pyràk o amnhĩ nhĩpêx nom ri mẽ kãm amnhĩ to axêx o ri apa. No nhũm Tĩrtũmja kot tanhmã mẽ ate amnhĩ nhĩpêx to nẽ tanhmã mẽ ajamaxpẽr to hkôt mẽ apumunh par. Nẽ hprĩ hã mẽ anhõxỳ hã mẽ apumu. Te mẽ ate tãm amnhĩ nhĩpêx pyràk nom mẽ anhõxỳ kamã na ka htem apa. Mẽmoj te mex pyràk nhũm htem omu nẽ mex ã hkamnhĩx. No nhũm Tĩrtũm àhpumunh tỳx xà hkôt hprĩ hã mẽmojta pumu nhũm kêp omnuj nẽ. Mẽ akurom omnuj ã omunh kurê kumrẽx. Na hte hprĩ hã mẽ ate amnhĩ nhĩpêx ã mẽ apumu. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Nhũm Jejus arĩ mẽ ahkre nẽ mẽ kãm: —Nẽ na pre finat Mojesja kumrẽx mẽ kãm Tĩrtũm kapẽr kwỳ hã kagà. Tã nhũm hpãnhã Tĩrtũm nhỹ hã kapẽr jarẽnh xwỳnh kwỳjaja mããnẽn mẽ kãm hkwỳ hã kagà. Nhũm prem kuma nẽ mẽ hkôt amnhĩ nhĩpêx o ri pa. Tã nhũm finat Juãw Paxisja mẽ hpãnhã kato nẽ Tĩrtũm kapẽr o mẽ ahkre ho ri pa. Tã pa hpãnhã ho mẽ ajahkre ho ri ixpa nhũm mẽ ohtô nẽ ixkôt amnhĩ xunhwỳ nẽ kãm ixkapẽr kôt pix mã amnhĩ nhĩpêx o ri pa hprãm nẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","—Tĩrtũm kapẽr tũmja mex o mex. Koja aa hapêx kêt nẽ. Koja nhỹrmã kaxkwa nẽ pika wa hapêx pa no nhũm Tĩrtũm kapẽr tũmja aa hapêx kêt nẽ. Koja rãhã ho rãhã nẽ aa ihkjê ho mẽnh kêt nẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Nhũm Jejus arĩ mẽ ahkre nẽ mẽ kãm: —Nẽ kêr ka mẽ aprõ kaga hkêt nẽ apa. Kot kaj mẽ hkaga nẽ hpãnhã nhãm hõ ho aprõ nhũm Tĩrtũm noo mã te ate wam aprõ kamã nhãm ho amnhĩkati pyràk. Nhũm ja kêp omnuj nẽ. Rỳ ka ra mẽhõ kot hprõ kaga xwỳnhta ka hpãnhã ho aprõ. Nhũm Tĩrtũm noo mã te ate wam mjên pê ho amnhĩkati pyràk. Nhũm Tĩrtũm pê ja omnuj nẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Nhũm Jejus arĩ mẽ ahkre kamã mẽ kãm awjarẽ nẽ mẽ kãm: —Koja mẽhõ kàxpore rax xwỳnh ê mex pix kãm ri pa. Nẽ apkati mẽ apkur mex o pa. ");
INSERT INTO apnNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Nhũm amrakati xwỳnh pê Rajareja hkà nhyre nẽ arĩ pry kamã àhwỳr o hkrĩ. Nhũm htem hamỳ nẽ ma o pa nẽ hikàxpore rax xwỳnh nhõrkwỹ jakwakrem haxwỳ. ");
INSERT INTO apnNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Nhũm õ jakrêx kwỳ hkrẽr prãm xàj hakwa krem àhwỳr o hkrĩ. Nhũm rop hwỳr mra nẽ hkà nhy kunhnwỳnh o kuhê. ");
INSERT INTO apnNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","—Tã nhũm Rajare ty nhũm Tĩrtũm kapẽr o mẽ wrỳk xwỳnhjaja hwỳr wrỳ nẽ ma akupỹm kaxkwa hwỳr hkarõ ho mõ nẽ ho api. Hãmri nhũm kaxkwa kamã mẽ pahpãm Apraãw nhĩhkô hã hkĩnh nẽ apkur mex o hkrĩ. —Tã nhũm hikàxpore rax xwỳnhta mããnẽn hkôt ty. Nhũm hkwỳjaja hã akuprõ nẽ hã mur nẽ ma o tẽ nẽ haxà. ");
INSERT INTO apnNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Hãmri nhũm hkarõ ma mẽ kot amnhĩ xà htỳx kamã hamak tũm xà pê kuwy maatita wỳr ma mõ. Nẽ kamã amnhĩ xà htỳx kãm hamak rãhã ho pa. Hãmri nẽ amnhĩ xà hã maj kànhmã rĩt nẽ kaxkwa kamã Apraãw pumu. Nhũm Rajare ra kuri mex nẽ nhỹ. ");
INSERT INTO apnNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Hãmri nhũm tee ri wa omu nẽ Apraãw mã akapẽr nẽ kãm: “Kwa Apraãw. Kwa we ixkamã axukaprĩ nẽ ixwỳr Rajare mẽ kê ixwỳr tẽ nẽ ĩhkrakrã ho gô htok nẽ ho inhõhto jakry. Na pa kuwy kamã amnhĩ xà htỳx kãm ijamak tỳx kumrẽx.” Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Hãmri nhũm kuma nẽ kãm: “Tk. Nà kot pa awỳr mẽnh kêt nẽ. Na ka pre atĩr ri amex nẽ akĩnh nẽ ri apa. No nhũm Rajare akĩnhã hkà nhy rax nẽ amnhĩ xà htỳx kãm hamak rãhã ho ri pa. Tã ra jar inhĩhkô hã hkĩnh nẽ pa. Ka pre kurom amex nẽ apa htã kot kaj hpãnhã amnhĩ xà htỳx kãm ajamak rãhã ho ri apa. ");
INSERT INTO apnNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Nẽ pahkaêx kãm ahkaprỳ griã. Jakamã nhỹhỹnh kot kêt awỳr rê? Ka ajaxwỳja nhỹhỹnh kot ka kêt mẽ ixwỳr rê?” Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","—Nhũm ã kãm kapẽr anẽ nhũm tee ri kuma nẽ kãm: “Kwa tô ma inhõ krĩ hwỳr mãn amẽ kê ma ixkwỳjê hwỳr wrỳ. ");
INSERT INTO apnNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","O mũj arĩ inhõ krĩ kamã ixtõ kêp 5 nẽ arĩ htĩr nẽ pa. Kê wa mẽ kãm awjarẽ kê mẽ amnẽ kuwy hwỳr pa pymaj tokyx amnhĩ tomnuj kaga nẽ Tĩrtũm kôt mãn amnhĩ xunhwỳ nẽ hkôt ri amnhĩ nhĩpêx o pa.” Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","—Hãmri nhũm Apraãw kãm: “Nà pa mẽ hwỳr mẽnh kêt nẽ. Ra mẽ kuri Tĩrtũm kapẽr jarẽnh xwỳnhjê mẽ Mojes kot Tĩrtũm kapẽr ã kagà kênã. Kê mẽ kamã harẽ nẽ ja ma nẽ rĩ tãm tanhmã amnhĩ nhĩpêx to.” Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Hãmri nhũm tee ri kuma nẽ kãm: “Kwa nà. Koja mẽ kagàja mar kêt nẽ. No kêt Rajare na pre ra htyk tã akupỹm htĩr jakamã koja mẽ hwỳr wrỳ nẽ mẽ kãm awjarẽ nhũm mẽ akupỹm htĩr ã omu nẽ kapẽr ma hãmri nẽ amnhĩ tomnuj kaga kurê kumrẽx. Kwa nà ã ri anhỹr kêt nẽ mẽ hwỳr amẽ hêxta waa nẽ.” Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","—No nhũm kãm: “Nà koja mẽ Tĩrtũm kapẽr ã kagà mar kêt ã koja mẽ mããnẽn Rajare tyk nẽ akupỹm htĩr nẽ mẽ hwỳr wrỳk nẽ kot mẽ kãm tanhmã ujarẽnh to hã mar kêt nẽ. Jakamã kwarĩ pa mẽ hwỳr mẽnh kêt nẽ. Kot paj ho anẽ nẽ ãm ixte mẽ hwỳr mẽnh kaprỳ pyràk o amnhĩ nhĩpêx.” Anẽ. Ã mẽ ujarẽnh kot anhỹr. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","2","Tã nhũm Jejus hkôt mẽ pa ho mẽ pa xwỳnhjê jahkre ho nhỹ nẽ mẽ kãm: —E kot paj mẽ kot ixkôt amnhĩ xunhwỳr tohtuj anhỹr xwỳnhjê jarẽ ka mẽ inhma. Nà koja mẽhõ mẽ hwỳr tẽ nẽ inhnê mẽ kãm kapẽr. Mẽ kot mẽ mar nẽ amnhĩ tomnuj prãm xàj tanhmã mẽ kãm kapẽr to. Hãmri nhũm mẽ mar xà hkôt tanhmã amnhĩ tomnuj to. Hã koja Tĩrtũm ja hã omu nẽ kot inhnê tanhmã kãm nẽ xwỳnhta pumu nẽ ja hã homnuj tỳx nẽ. Te mẽ kot mẽhõ pynênh nẽ mut ã kẽn pytĩ hõ nhôr nẽ ma o htẽm nẽ gô rax kãm mẽnh pyràk o koja hipêx. Te ho ja pyràk no ãm homnuj tỳx o ja jakre. Jakamã kwa mẽ ixkapẽr ma nẽ kãm ajamaxpẽr tỳx rãhã ho ri apa. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Nhũm Jejus arĩ mẽ ahkre nẽ mẽ kãm: —Nẽ koja ixkôt atõjê hõ tanhmã atomnuj to. Ka amnhĩ tã omu hãmri nẽ ma hwỳr tẽ nẽ ja hã kãm akapẽr nẽ kãm: “Kwa mon ka axtem nẽ ri ã inhĩpêx anẽ ixtõ? Kwa nà ri ã inhĩpêx anhỹr kêt nẽ.” Anẽ hãmri nhũm amnhĩ tã ama nẽ amã: “Nà na pa tee ri ixte tanhmã atota ã amnhĩ pumu nẽ ixkaprĩ nẽ. Nà kot paj axte ã ri anhĩpêx anhỹr kêt nẽ. Kwa kêr ka axte tanhmã ja mã ajamaxpẽr to hkêt nẽ. Te ate amnhĩ katut kôt mẽnh pyràk o hipêx pu akupỹm tãm axpẽn nhĩpêx o papa.” Anẽ. Koja ã amã kapẽr anẽ ka amnhĩ tã ama hãmri nẽ axte tanhmã kot atoja mã ajamaxpẽr kêt nẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","—Koja arĩgro pyxi hã xatã tanhmã atomnuj to japêr. Hãmri nẽ xatã tee ri ja hã amnhĩ pumu nẽ awỳr mra nẽ xatã amnhĩ tã amã kapẽr nẽ amã: “Pa ot pa awỳr tẽ. Na pa ra ixkaprĩ nẽ. Kwa ixte ã anhĩpêx anhỹrja pumu nẽ ãm omu. Kot paj axte hkêt nẽ.” Anhỹr o xatã amã kapẽr. Nẽ ra axte tanhmã atomnuj to nẽ kê axte awỳr tẽ nẽ ã amnhĩ tã amã kapẽr anẽ. Nom kêr ka ama nẽ kamã agryk kêt nẽ. Ãm xatã kãm: “Nà kot puj anẽ nẽ akupỹm tãm axpẽn nhĩpêx. Kot paj axte tanhmã ate ixtota mã ijamaxpẽr kêt nẽ. Kot puj ja ho pajapêx nẽ tãm axpẽn nhĩpêx o akupỹm papa.” Anhỹr o kêr ka mẽ xatã axpẽn nhĩpêx anhỹr rãhã ho ri apa nẽ aa jam anhũrer kêt nẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Tã nhũm Jejus nhỹ hã mẽ ahkre ho mẽ pa xwỳnhjaja hãmri kãm: —Kwa Pahihti. Tanhmã mẽ ixto pa mẽ amnhĩ kaxyw Tĩrtũm kôt ijamaxpẽr tỳx rãhã ho ri ixpa. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Hãmri nhũm mẽ kãm: —Nà ra mẽ ate amnhĩ kaxyw hkôt ajamaxpẽr jakamã na ra amnhĩ tã mẽ apumu. Jakamã mẽ ate hkôt amnhĩ nhĩpêx kukwak ri na ka htem mẽmoj tã awỳ nhũm mẽ ate mẽmoj tã hwỳr xà hkôt mẽ amã tanhmã mẽmoj nhĩpêx to. Te mẽ ate pĩ hpàr mũj mã akapẽr nẽ kãm: “E amnhĩ jarê nẽ ma tẽ nẽ gô xujanãr kãm mãn mrõ.” Anẽ nhũm kot amar nẽ amar xà hkôt ã kot amnhĩ nhĩpêx anhỹrta pyràk. Ja pyrà nẽ kot kaj mẽ ate Tĩrtũm kôt amnhĩ nhĩpêx o apa kukwak ri mẽmoj tã awỳ nhũm mẽ ama nẽ mẽ amã mẽmoj tanhmã ho. Rỳ mẽ amã mẽmoj gõ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Nhũm Jejus arĩ mẽ ahkre nẽ mẽ kãm: —Nẽ ja. Kot kaj mẽ amã mẽ àpênh xwỳnh kwỳjaja nhũm hõ amã mẽmoj tã àpênh o pa ẽ ho anhỹr pa. Hãmri tanhmã kot kaj kãm akapẽr to wehe? Xà kot kaj kãm: “E hãmri axàpênhta kaga nẽ tẽ nẽ nhỹ nẽ apku.” Anhỹr o kãm akapẽr? ");
INSERT INTO apnNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Nà kot kaj kãm anhỹr kêt nẽ. Kot kaj kãm: “E kwa tokyx tẽ nẽ hpãnhã inhmã inhõ hã apê. Kot pa ixàpkur pa ka ixpãnhã nhỹ nẽ apku.” Anhỹr kãm akapẽr. Kêp amã àpênh xwỳnh jakamã ka ã kãm akapẽr anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Ja pyrà nẽ kot puj mẽ Tĩrtũm kot mẽ pamã mẽmoj tã karõ xà hkôt tanhmã kãm amnhĩ nhĩpêx to ho ri papa. Mẽ õ patrãwta pyrà nẽ kot tanhmã mẽ pamã karõ hto xà hkôt pu mẽ amnhĩ nhĩpêx. —Xà na htem mẽ õ patrãw mã mẽmoj tã àpênh pa hãmri nẽ hkwỳjê mã amnhĩ to jarkrar o ri pa nẽ mẽ kãm: “E ka mẽ ixpumu. Na pa hte inhõ patrãw mã ixàpênh mex o mẽ hakre ka mẽ ja hã ixpumu. Hêxta waa nẽ. Mon pa hte ri axtem ã amnhĩ nhĩpêx anẽ?” Anhỹr o xà kot kaj mẽ kãm amnhĩ to jarkrar o ri apa? Nà na ka htem ã amnhĩ nhĩpêx anhỹr kêt nẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","—Tã pa hte mẽ õ patrãwta pyrà nẽ tanhmã mẽ amã mẽmoj tã karõ hto ho ixpa. Jakamã kêr ka mẽ inhma nẽ ixte mẽ amã mẽmoj tã karõ xà hkôt tanhmã inhmã amnhĩ nhĩpêx to ho ri apa. Hãmri nẽ hã amnhĩ to jarkrar pê amnhĩ jarẽnh o: “Ãm hãmri na pa ã Jejus mã amnhĩ nhĩpêx anẽ. Hêxta waa nẽ. Ixpê Jejus mã tanhmã ixte amnhĩ nhĩpêx to mex xwỳnh na pa.” Anhỹr o amnhĩ to jarkrar kêt nẽ. Kêt ãm amnhĩ jarẽnh o: “Nà ixte kãm tanhmã amnhĩ nhĩpêx to ho ixpa xwỳnh pix na pa. Na hte mẽmoj tã inhmã karõ pa kuma nẽ ỹ hã tanhmã kãm amnhĩ nhĩpêx to.” Anhỹr o amnhĩ jarẽnh o ri apa. No ri amnhĩ krã hkôt atỳx tanhmã amnhĩ to jarkrar to ho ri apa hkêt nẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Tã nhũm Jejus arĩ Garirej rũm pika pê Samar hkàx ã Jerujarẽ hwỳr kormã mõ. ");
INSERT INTO apnNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Nẽ nhỹri krĩ hõ htêp o mõr mẽ nhũm krĩ pu hã ri mẽ pa xwỳnhjaja kêp 10 nẽ kutã mra. Mẽ hkànhy hkro htỳx xwỳnhjaja kutã mra nẽ hkaxpa nẽ amỳm kuhê nẽ omu. ");
INSERT INTO apnNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Hãmri nẽ kãm: —Pa Pahihti. Kwa mẽ ixpumu nẽ mẽ ixkamã axukaprĩ nẽ tanhmã mẽ ixto mex to. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Hãmri nhũm mẽ kãm: —Tôe. Nà kot paj mẽ ato mex. E mẽ mãmrĩ awjanã nẽ ma akupỹm mẽ anhõ patrejê hwỳr mra kê mẽ akupỹm mẽ akà mex ã mẽ apumu. Anẽ. Hãmri nhũm mẽ kuma nẽ kapẽr mar xà hkôt awjanã. Kà nhy rãhã awjanã nẽ ma akupỹm patre hwỳr mra. Nẽ kormã akupỹm hwỳr pry hã mrar rãhã piitã hkà mex pa. ");
INSERT INTO apnNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Hãmri nhũm ãm pyxi nẽ hkwỳjê rom awjanã nẽ akupỹm Jejus wỳr Tĩrtũm mã mex o mex ã harẽnh o hwỳr tẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Hãmri nẽ Jejus kaxpa nẽ kutã hkõnkrã ho tẽm nẽ nhỹ nẽ amnhĩ tã kãm kot ho mex ã kãm amnhĩ jarẽ. Kwỳjê hkĩnhã kêp Ijaew kêt axtem kêp Samar nhõ xwỳnh tã mẽ kurom akupỹn hwỳr tẽ nẽ kãm mex o mex ã harẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","19","Hãmri nhũm amnhĩ tã kuma nẽ kãm: —No mẽ akwỳjaja? Ixte mẽ ato 10 nẽ mẽ ato mex tã ka ãm kapxipix awjanã nẽ akupỹn ixwỳr tẽ. Akwỳjê hkĩnhã apê Ijaew kêt tã akupỹm amnhĩ mex ã amnhĩ pumu hãmri nẽ mẽ kurom awjanã nẽ Tĩrtũm mã mex o mex ã harẽnh o ixwỳr tẽ. Hêxta waa nẽ. Mo na hte ixkwỳjaja apyrà nẽ amnhĩ kaxyw ixkôt hamaxpẽr kêt nẽ? E kànhmã xa nẽ mãmrĩ ma ajamakêtkati nẽ akĩnh nẽ ma akupỹm tẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","21","Tã nhũm Parijew nhõ xwỳnh kwỳjaja Jejus wỳr mra nẽ omu nẽ kãm: —Kwa mẽ inhmã mẽmoj jarẽ. Xà koja apu Tĩrtũm tokyx kot mẽ pahwỳr mẽnh mã xwỳnhta mẽ nhũm mẽ pahwỳr wrỳ nẽ mẽ pahto amnhĩptàr kurê kumrẽx nà kormã? Anẽ. Hãmri nhũm mẽ kuma nẽ mẽ kãm amnhĩ jarẽ. Te ho nhãm mẽhõ jarẽnh pyrà nẽ mẽ kãm: —Nà ra kot mẽ ho amnhĩptàr o pa kênã. Nom nhỹri hkrĩ xà kamã mẽ ho amnhĩptàr o hkrĩ hkêt nẽ. Na htem amnhĩ kaxyw hkôt hamaxpẽr nẽ hkôt amnhĩ xunhwỳ hãmri nhũm kêp mẽ õ pahihti hã mẽ ho amnhĩptàr o pa. Nẽ mẽ kãm mẽ hamaxpẽr mex gõ nhũm htem hkôt ri hamaxpẽr mex o pa. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Hãmri nẽ hpãnhã hkôt mẽ pa ho mẽ pa xwỳnhjê mã kapẽr. Mẽ kot nhỹrmã tee ri kamã hamak o pa hã mẽ kãm kapẽr nẽ mẽ kãm: —Kot kaj mẽ nhỹrmã tee ri amã tokyx akupỹn ixwrỳk nẽ ixte mẽ ato amnhĩptàr prãm xàj tee ri inhmã anojarêt kaprỳ ho ri apa. Nẽ axpẽn mã ri ijarẽnh o: “Hêxta waa nẽ. Mo na we Pahihti tokyx akupỹn mẽ pahwỳr wrỳk kêt nẽ?” Anhỹr o inhmã anojarêt o ri apa pê ixkamã ajamak rãhã ho apa. ");
INSERT INTO apnNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","—Nẽ koja mẽ ra akupỹn ixwrỳk ã tanhmã mẽ amã ixto hêx to ho pa. Nhỹri ixkuhê nhũm mẽ kot ixpumunh ã mẽ amã ixto hêx o pa. Nom kêr ka mẽ ama nẽ ãm mẽ ama. ");
INSERT INTO apnNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Kot paj nhỹrmã akupỹn mẽ awỳr ixwrỳk kaxyw nhũm mẽ pika piitã hkôt akupỹn ixwrỳk kãm anhĩpê ixpumu. Te mẽ piitã mẽ kot anhĩpê na jaxênh pumunh pyràk o kot kaj mẽ apiitã ixpumu. ");
INSERT INTO apnNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Nom kormã jar pika ja kamã ixpa ri koja mẽ ohtô nẽ ixkaga pa amnhĩ xà htỳx kamã ijamak kãm ty. Hãmri nẽ mẽmo arĩgro hã ma akupỹm kaxkwa hwỳr api. Hãmri nẽ nhỹrmã akupỹn mẽ awỳr wrỳ. ");
INSERT INTO apnNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","—Nà kot paj nhỹrmã man akupỹn mẽ awỳr wrỳ. Akupỹn ixwrỳk xà hã arĩgrota ã koja jar pika ja kamã mẽ pa xwỳnhjaja htỳx ri tanhmã amnhĩ tomnuj to ho pa. Te amnepêm finat Noehti htĩr ri mẽ kot htỳx ri tanhmã amnhĩ tomnuj to ho pa pyràk o koja mẽ amnhĩ nhĩpêx o pa. ");
INSERT INTO apnNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Na prem amnhĩ kaxyw Tĩrtũm mã hamaxpẽr o pa hkêt nẽ. Nẽ ãm jar pika ja kamã mẽ kot amnhĩ nhĩpêx pix kukamã hamaxpẽr o ri paja o ãm kôt pix mã tanhmã ri amnhĩ nhĩpêx to ho pa. Rôm nhũm Noehti gô htàm pymaj pàr raxja nhĩpêx nẽ kãm axà. Nhũm prem hã omu nẽ ãm omunh o pa nẽ tanhmã ri amnhĩ kukamã hamaxpẽr to hkêt nẽ. Tã nhũm nata mẽ haêr pê wrỳ. Hãmri nẽ wrỳk rax o ra pika piitã hanhi nhũm mẽ piitã pikaprãr pa. ");
INSERT INTO apnNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","—Akupỹn ixwrỳk xà hã arĩgrota ã koja mẽ mããnẽn te amnepêm Sotõ nhõ xwỳnhjaja kot htỳx ri tanhmã amnhĩ tomnuj to pyràk o amnhĩ nhĩpêx. Finat Rohti kormã htĩr ri mẽ kot htỳx ri tanhmã amnhĩ tomnuj to ho pata pyràk o koja mẽ amnhĩ nhĩpêx. Na pre hte Sotõ nhõ xwỳnhjaja ãm pika ja kamã mẽ kot amnhĩ nhĩpêx pix kukamã hamaxpẽr o ri pa. Nẽ ãm kôt pix mã ri amnhĩ nhĩpêx o pa. Nẽ htỳx ri amnhĩ xàpkur xà pix kukamã hamaxpẽr. Nẽ mẽ hpur kãm ri àpênh pix kukamã hamaxpẽr. Nẽ ri amnhĩ xujaprôr pix kukamã hamaxpẽr nẽ axpẽn mã mẽmoj to wẽnê pix kukamã hamaxpẽr. Nẽ amnhĩm õrkwỹ nhĩpêx pix kukamã hamaxpẽr. Ã na prem pika ja kamã mẽ kot amnhĩ nhĩpêx pix kukamã hamaxpẽr o ri pa anhỹrja o amnhĩ kaxyw Tĩrtũm mã hamaxpẽr o pa hkêt nẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","—Tã nhũm Rohti mẽ õ krĩ rũm kator mẽ nhũm Tĩrtũm krĩ nhõ xwỳnhjaja kot amnhĩ tomnuj tỳx o paja mỳrapê mẽ himex pa. Jao kaxkwa rũm mẽ hipy mẽmo hpôk kwỳ rẽ nhũm mẽ hkaxàr pa. ");
INSERT INTO apnNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Tã akupỹn mẽ awỳr ixwrỳkja mẽ koja mẽ te Rohti nhõ krĩ kamã mẽ kot amnhĩ nhĩpêx pyrà nẽ htỳx ri amnhĩ tomnuj pix o pa. ");
INSERT INTO apnNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","—Nẽ akupỹn ixwrỳỳta ã ka mẽ anhõrkwỹ nhĩmõk ã hkrãmnênh o akrĩ japêr nẽ akupỹn ixwrỳk kãm ixpumu. Hãmri nẽ akukrêx wỳr axàr nẽ hõ hpyr mã ajamaxpẽr kêt nẽ. Rỳ ka mẽ apur kãm axàpênh o akuhê japêr nẽ akupỹn ixwrỳk kãm ixpumu. Hãmri nẽ akupỹm anhõrkwỹ hwỳr atẽm mã ajamaxpẽr kêt nẽ. Mo kaxyw kot ka kêt hwỳr tẽ? Kêt ãm inhmã mẽ ajapê hã akupỹn mẽ awỳr ixwrỳk mã ajamaxpẽr o akĩnh nẽ ixpumunh o akuhê. ");
INSERT INTO apnNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","—Nẽ kêr ka mẽ Rohti prõ kot tanhmã amnhĩ nhĩpêx toja mã ajamaxpẽr rãhã ho ri apa. Na pre Tĩrtũm kapẽr nhĩrôp xa nẽ amnhĩ katut kôt Sotõta wỳr rĩt hãmri nẽ ã amnhĩ nhĩpêx anhỹrja mỳrapê htyk kurê kumrẽx. Tã kêr ka mẽ ho uràk nẽ amã akukrêx rax japê xàj ixkôt amõr kaxyw anhĩtõt kêt nẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","—Nẽ kwa kêr ka mẽ jar pika ja kamã tanhmã mẽ ate amnhĩ nhĩpêx to pix kukamã ajamaxpẽr o ri apa hkêt nẽ. Nẽ mẽ akukrêx rax pix kukamã ajamaxpẽr kêt nẽ. Koja nhỹrmã ja piitã mẽ apê hapêx pa. Mẽ ate kãm anhĩhkra karo hpar pyràk o piitã hipêx hãmri nhũm Tĩrtũm ja hã mẽ apumu nẽ hpãnhã nhỹrmã mẽ amã mẽmoj mex nhõr rax nẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","—Nẽ kot paj kamàt kãm akupỹn ixwrỳk japêr nhũm nhỹri mẽhõ ra ixkôt amnhĩ xàm xwỳnh mẽ mẽhõ kot ixkôt amnhĩ xãm kêt xwỳnh wa par kãm nõr japêr. Hãmri pa amnhĩ wỳr ra ixkôt kot amnhĩ xãm xwỳnhta o api nhũm kot ixkôt amnhĩ xãm kêt xwỳnhta arĩ gõr nẽ nõ. ");
INSERT INTO apnNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Rỳ pa arĩgro hã akupỹn ixwrỳk japêr nhũm mẽnijê hõ wa hamẽxkrut nẽ harôj kahuk o ãm japêr. Hãmri pa ra kot ixkôt amnhĩ xãm xwỳnhja ho api nhũm kot ixkôt amnhĩ xãm kêt xwỳnhja ahte arĩ harôj kahuk o xa. Hãmri nẽ hamaxpẽr mex kêt kumrẽx o xa. ");
INSERT INTO apnNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Rỳ koja mẽmyjê hõ wa axkrut nẽ hpur kãm àpênh o ãm japêr. Pu pa amnhĩ wỳr kot ixkôt amnhĩ xãm xwỳnhta o api nhũm kot ixkôt amnhĩ xãm kêt xwỳnhta pur kãm ahte arĩ apênh o xa. Hãmri nẽ tee ri hkràmnhwỳ hkukamã hamaxpẽr o xa. Anẽ. Nhũm pre ã Jejus hkôt mẽ pa ho mẽ pa xwỳnhjê mã amnhĩ jarẽnh anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Hãmri nhũm mẽ kuma nẽ kãm: —Kwa nhỹri koja mẽmoj ã amnhĩ nhĩpêx anẽ? Anẽ. Hãmri nhũm mẽ kãm: —Nà koja nhỹri mẽmojja ã amnhĩ nhĩpêx anẽ ka mẽ omunh kurê kumrẽx. Te nhỹri mẽmoj kro nẽ nõr nhũm nhônhti kot omunh nẽ hã htor nẽ hpinhĩpanh nhũm mẽ kot hã omunh kurê kumrẽxta pyràk. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Tã nhũm Jejus hkôt mẽ pa ho mẽ pa xwỳnhjê mã mẽmoj tã karõ. Mẽ kot tanhmã Tĩrtũm mã amnhĩ jarẽnh to hã mẽ kãm karõ. Mẽ kot xatã kãm amnhĩ jarẽnh o pa nẽ amnhĩ kaxyw kãm hamaxpẽr rãhã ho pa kaxyw. No ãm hã kuxi nẽ tanhmã mẽ kãm hã ujarẽnh to nẽ mẽ kãm: ");
INSERT INTO apnNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","—Koja nhỹri krĩ hõ kamã juistija kãm Tĩrtũm prãm nõkati. Nẽ mããnẽn kãm amnhĩ kwỳjê hprãm nõkati htã kêp juisti nẽ tanhmã mẽ kãm kapẽr to ho hkrĩ. ");
INSERT INTO apnNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Jakamã nhũm mẽhõ ni pê mjên htyk xwỳnh. Nhũm hte mẽhõ xatã tanhmã kêp õ mẽmoj to ho pa. Hãmri nhũm tee ri amnhĩ tã omu nẽ xatã juistita wỳr mra nẽ kãm harẽ nẽ kãm: “Xê gàà nẽ. Na hte pahkwỳjê hõja ixtomnuj rãhã ho pa. Xê ixtã tanhmã kãm akapẽr to kê tãm inhĩpêx.” Anẽ. Nẽ xatã hwỳr mra nẽ amnhĩ to kuwỳ nẽ xatã hwỳr mra nẽ amnhĩ to kuwỳ. ");
INSERT INTO apnNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","5","No nhũm kuma nẽ ãm kuma. Kãm hkwỳjê ho ajuta hprãm kêt jakamã ãm kuma. Tã nhũm xatã hwỳr mra. Gaa nhũm rĩ kãm mar kaga nẽ. Hãmri nẽ hamaxpẽr o: “Tk. Hêxta waa nẽ. Jahti na hte xatã ixwỳr mra nẽ tanhmã inhmã amnhĩ jarẽnh to. Nẽ ãm xatã ixwỳr mra. Nà na pa ra inhmã mar kagyk nẽ. E pa tokyx tanhmã nê kot tanhmã ho xwỳnhta mã ixkapẽr to. Inhmã Tĩrtũm pyma kamã rỳ inhmã ixkwỳjê kaprĩ kamã pa tanhmã nê kãm nẽ hkêt tã kot pa anhỹr kêt nhũm amnhĩ tã inhmã harẽnh pix nẽ pa ra mar kurê ixkrã tãtãk nẽ.” Anhỹr o hamaxpẽr. Ã mẽ ujarẽnh kot anhỹr. ");
INSERT INTO apnNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","—Juisti tãm hamaxpẽr kêt tã nhũm nija xatã hwỳr mrar nẽ amnhĩ to hwỳr jakamã nhũm jatã tanhmã ho ajuta hto. ");
INSERT INTO apnNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","8","No kêt Tĩrtũmja. Xàn ka htem mẽmoj tã awỳ nhũm juisti punutita pyrà nẽ mẽ ama nẽ ãm mẽ ama? Nà koja ã amnhĩ nhĩpêx anhỹr kêt nẽ. Kot ka mẽmoj tã kãm amnhĩ jarẽ nhũm ama nẽ tanhmã amã mẽmoj to rỳ tanhmã amã amnhĩ nhĩpêx to. Juistita rom mẽ pakamã ukaprĩ xwỳnh na. Tã kot paj nhỹrmã akupỹn wrỳ nẽ mẽ apumu ka mẽ arĩ amnhĩ kaxyw hkôt ajamaxpẽr mex pê kãm amnhĩ jarẽnh rãhã ho ri apa pa ja hã mẽ apumu nẽ ixkĩnh tỳx nẽ. Ja na inhmã hprãm. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Tã nhũm Jejus mẽ kot amnhĩ to mex o hkwỳjê jakrenh ã amnhĩ to jarkrar o ri mẽ pa xwỳnhjê pumu nẽ tanhmã mẽ kãm kapẽr to. Nom mẽ kot amnhĩ to jarkrarta ã kuxi nẽ mẽ kãm awjarẽ nẽ mẽ kãm: ");
INSERT INTO apnNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","—Koja mẽhõ wa hamẽxkrut nẽ Tĩrtũm mã amnhĩ jarẽnh kaxyw wa tẽ. Ja kêp Parijew nhõ xwỳnh nhũm hõja kêp mẽ õ pahi mã hkwỳjê pê kàxpore hkwỳ jamỳnh xwỳnh. Nhũm wa Tĩrtũm mã amnhĩ jarẽnh xà hã ixkre hwỳr wa tẽn axà. ");
INSERT INTO apnNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","12","Hãmri nhũm Parijew nhõ xwỳnhta kumrẽx tẽ nẽ nhỹri mẽ piitã mẽ noo mã Tĩrtũm mã amnhĩ jarẽ. Nẽ amnhĩ to jarkrar pê kãm amnhĩ jarẽnh o: “Pa Tĩrtũm. E ra ate ixpumunh mex. Na pa hte amnhĩ to mex pix o ri ixpa. Ra ate ja hã ixpumunh mex. Na pa hte kàxpore hkwỳ jamỳnh xwỳnh nẽj rom tãm amnhĩ nhĩpêx. Nẽ semãn piitã hã ixàpkur kêt rãhã amã amnhĩ jarẽnh rãhã ho ixtã apkati axkrut. Nom ja pix kêt. Na pa hte mããnẽn ixàpênh pãnhã kàxpore jamỳ nẽ mẽ kot amã tanhmã amnhĩ nhĩpêx to ho pa xwỳnhjê mã hkwỳ nhõr o ixpa. Nẽ na pa hte ri ixàhkĩnh o ri ixpa hkêt nẽ. Nẽ nhãm mẽ kêp mẽ hprõ ho amnhĩkati ho ri ixpa hkêt nẽ. Na pa hte mẽ piitã mẽ kurom tãm amnhĩ nhĩpêx ã amnhĩ pumu nẽ ixkĩnh tỳx kumrẽx. Hêxta waa nẽ. Mon pa hte ri ã amnhĩ to mex o ixpa anẽ?” Anhỹr o Tĩrtũm mã amnhĩ to jarkrar pê kãm amnhĩ jarẽnh o xa. ");
INSERT INTO apnNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","—Hãmri nhũm hpãnhã mẽ kêp kàxpore hkwỳ jamỳnh xwỳnhta haxwỳja Tĩrtũm mã amnhĩ jarẽ. No ãm Parijew nhõ xwỳnhta rom ki hkwỳjê pê awry nẽ ahte hipô nẽ kãm amnhĩ jarẽ. Nẽ kãm amnhĩ jarẽnh pê amnhĩ tak nẽ mur nẽ kãm: “Kwa Tĩrtũm. Na pa hte amnhĩ tomnuj tỳx o ri ixpa. Nẽ ixtỳx ri amã prãm xà kuhpa hã tanhmã amnhĩ nhĩpêx to. Na pa tee ri ja hã amnhĩ pumu nẽ ixkaprĩ htỳx nẽ. Ã inhmã amnhĩ nhĩpêx anhỹr o ri ixpa hprãm kêt tã pa hte ã amnhĩ nhĩpêx anhỹr o ri ixpa. Kwa xà kot ka ixkamã axukaprĩ nẽ amnhĩ katut kôt ixte amnhĩ tomnuj rẽnh pa Tĩrtũm?” Anhỹr o kãm amnhĩ jarẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","—Hãmri nhũm Tĩrtũm hamẽ wa kot kãm amnhĩ jarẽnh ma no ãm wamta ma nẽ ãm kuma. No kêt hkôt hõja ma hãmri nẽ kot kãm amnhĩ tã àhwỳr xà hkôt amnhĩ katut kôt kot amnhĩ tomnuj rẽnh pa nẽ ho hkra. Jakamã nhũm mex nẽ hkĩnh nẽ pa. Ra tãm hkrã hãmri nẽ hkĩnh nẽ ma htẽm kurê kumrẽx. Ã mẽ ujarẽnh kot anhỹr. Ãm hãmri na pa mẽ amã ja jarẽ. Koja mẽhõ Parijew nhõ xwỳnhta pyrà nẽ kot amnhĩ to mex xwỳnh ã amnhĩ kamnhĩx hãmri nẽ Tĩrtũm kot amnhĩ katut kôt kot amnhĩ tomnuj rẽnh kaxyw amnhĩ to hwỳr kêt nẽ. Koja ãm kãm amnhĩ to jarkrar pix nẽ. Jakamã koja Tĩrtũm te kot mar nẽ ãm mar pyràk o hipêx. No koja mẽhõ kot kàxpore hkwỳ jamỳnh xwỳnhta pyrà nẽ tee ri tanhmã amnhĩ tomnuj to hã amnhĩ pumu nẽ hkaprĩ nẽ. Hãmri nẽ amnhĩ to Tĩrtũm wỳ nhũm kuma nẽ tanhmã ho mex to. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Tã nhũm Jejus mẽ hkôt mẽ pa ho mẽ pa xwỳnhjaja arĩ pry hã Jerujarẽ hwỳr mõ nhũm Ijaew kwỳjaja mẽ omu nẽ mẽ hkrare jamỳ nẽ Jejus wỳr mẽ o mra. Kot mẽ hã ĩhkra jaxwỳr nẽ mẽ ho Tĩrtũm wỳr kaxyw. Hãmri nhũm hkôt mẽ pa ho mẽ pa xwỳnhjaja tee ri ja hã mẽ omu nẽ nê mẽ kãm kapẽr nẽ mẽ kãm: —Tk. Kwa mẽ ma akupỹm mẽ akrata o mra nà? Mo kaxyw na ka mẽ Jejus wỳr mẽ o mra? Kormã mẽ ràxre kênã. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Hãmri nhũm amnhĩ tã mẽ kuma nẽ mẽ kãm: —Tk. Kwa nà mẽ ri inhnê mẽhprĩjê kurê hkêt nẽ. Kwãr mẽ mãmrĩ ixwỳr mẽ o mra. Anẽ. Hãmri nẽ amnhĩ wỳr mẽ kãm hpa ho apê nhũm mẽ hwỳr mẽ o mra nhũm mẽ kuri kuhê. Hãmri nhũm hkôt mẽ pa ho mẽ pa xwỳnhjê mã kãm: —E mẽ jareja mẽ omu. Na htem hamakêtkati nẽ hkĩnh nẽ ri pare. Nẽ kãm amnhĩ to rũnh prãm kêt nẽ ri pa. Tã Tĩrtũm kôt mẽ kot amnhĩ nhĩpêx xwỳnhjaja na htem mẽ uràk nẽ kãm amnhĩ to rũnh prãm kêt nẽ ri pa. ");
INSERT INTO apnNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","—Jarejaja na htem hipêêxà nẽ katorxà wa kapẽr ma nẽ wa hkôt ri amnhĩ nhĩpêx mex o ri pa. Tã ixpê Tĩrtũm kot mẽ awỳr inhmẽnh xwỳnh kot ka mẽ amã ixkôt amnhĩ xunhwỳr prãm. Hã kot kaj mẽ te ho jarejê kot amnhĩ nhĩpêx pyràk o amnhĩ nhĩpêx. Jao ixkapẽr ma nẽ ixkôt ri tanhmã amnhĩ nhĩpêx mex to ho ri apa. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Tã nhũm Ijaew nhõ pahihti hõja Jejus wỳr tẽ nẽ kãm kapẽr nẽ kãm: —Pa? Mẽ ijahkre xwỳnh maati? Kwa inhmã mẽmoj jarẽ. Tanhmã kot pa we nhỹrmã Tĩrtũm ri ixtĩr tũm nẽ ixpa kaxyw amnhĩ nhĩpêx mex to ho ri ixpa wehe? Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Hãmri nhũm kãm: —Xà ate ixpê Tĩrtũm kwỳ hã ixpumunh kôt na ka ixte uràk nẽ amnhĩ to mex xwỳnh ã ijarẽ? Tĩrtũm pix na kot amnhĩ to mex rãhã xwỳnh jakamã kot kaj ã ijarẽnh anhỹr jao ixpê Kra hã ijarẽ. Nẽ uràk nẽ ixte amnhĩ to mex xwỳnh ã ijarẽ. Nà xàn ka ãm atỳx ri amnhĩ krã hkôt ã ijarẽnh anẽ? ");
INSERT INTO apnNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","—Tĩrtũmja mex o mex xwỳnh jakamã kot kaj amã nhỹrmã kuri atĩr tũm nẽ apa hprãm hãmri nẽ ra kot mẽmoj tã mẽ amã karõ xà hkôt amnhĩ nhĩpêx o ri apa. Ra ate mar mex kênã. Na pre mẽ amã: Kêr ka mẽ axpẽn pê axàhkĩnh hkêt nẽ. Nẽ mẽ axpẽn par kêt nẽ. Nẽ mẽ axpẽn to axêx o ri apa hkêt nẽ. Nẽ mẽ axpẽn pê aprõ ho amnhĩkati hkêt nẽ. Nẽ mẽ anhĩpêêxà mẽ akatorxà wa hã apijaàm pê wa kutã anojarêt pix o ri apa. E kot kaj amã nhỹrmã Tĩrtũm kuri atĩr tũm nẽ apa hprãm hã kêr ka ã amnhĩ nhĩpêx anhỹr o ri apa. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Nhũm pre ã Jejus kãm kapẽr anẽ nhũm kuma nẽ kãm: —Kwa ixprĩre ri ra ã ixte amnhĩ nhĩpêx anhỹr o ri ixpa kênã. Nom ixte ixtĩr tũm nẽ ixpa kaxyw kormã ixte tãm kêt pyràk. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Hãmri nhũm Jejus kãm: —Nà kormã mẽmoj pyxire nẽ arĩk. Na ka amã akukrêx rax japê htỳx o Tĩrtũm jakre. Jakamã kêr ka ma akupỹm tẽ nẽ akukrêx o wẽnê hpa nẽ hpãnhã kàxpore jamỳ hãmri nẽ ma mẽ kêp amrakati xwỳnhjê mã õr pa. Hãmri nẽ rĩ akupỹn ixwỳr tẽ nẽ ixkôt apa ho apa. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Hãmri nhũm kuma nẽ tee ri amnhĩ kukamã hamaxpẽr. Kãm kukrêx rax japê nẽ kãm ĩhkra karo hprãm kêt nẽ. Jakamã tee ri Jejus kot ã kãm hã karõ anhỹrja ma nẽ awjanã nẽ ma akupỹm tẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Hãmri nhũm tee ri ja hã omu nẽ hã mẽ kot mar xwỳnhjê mã kapẽr nẽ mẽ kãm: —Hêxta waa nẽ. Koja mẽ hikukrêx rũnh xwỳnhjaja ohtô nẽ kãm mẽ hikukrêx japê xàj Tĩrtũm mẽ wa ixri htĩr tũm nẽ pa ho papa hkêt nẽ. Wa ixte amnhĩ nhĩpêxja mẽ kêp hihtỳx. ");
INSERT INTO apnNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Na htem kãm hikukrêx rax mã ĩhkra karo hprãm kêt rãhã tee ri kãm Tĩrtũm kôt amnhĩ nhĩpêx prãm kaprỳ. Te ho mẽhõ kot menh kagô hã hkre nẽ kãm kagô katõk prãm kêt rãhã kãm guhkrax kãm àr prãm kaprỳta pyràk. Anẽ. Nhũm pre ã Jejus mẽ kãm kapẽr anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Hãmri nhũm mẽ kuma nẽ tee ri amnhĩ kukamã hamaxpẽr nẽ kãm: —Kwa nom mẽ ixpiitã mẽ inhmã mẽ ixkukrêx japê kênã. Jakamã xà kot paj mẽ ixpiitã nhỹrmã war ari ixtĩr tũm nẽ ixpa ho ixpa hkêt nẽ nà? Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Hãmri nhũm mẽ kãm: —Nà kot kaj mẽ amnhĩ krã hkôt mẽ amã mẽ akukrêx japêja mã anhũrer kêt nẽ. Tĩrtũm pix na hte ã mẽ kot amnhĩ nhĩpêx anhỹr kaxyw tanhmã mẽ hkrã hto nhũm mẽ kãm mẽ hikukrêx japê htỳx kêt nẽ. Jao mẽ kêp Tĩrtũm mẽ wa ixri htĩr tũm nẽ mẽ pa ho pa mã xwỳnh. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Hãmri nhũm Simãw Pêtre kãm: —Kwa Pahihti no mẽ pajaja? Na pa prem agryk ã mẽmoj piitã hkaga hpa nẽ akôt ixpa ho ixpa. Jakamã kot paj mẽ nhỹrmã war ari ixtĩr tũm nẽ ixpa ho ixpa nà? Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Hãmri nhũm kãm: —Tỳ. Nà ka mẽ atõ inhmã tanhmã amnhĩ nhĩpêx to ho apa kaxyw akwỳjê re nẽ ma inhmã tanhmã amnhĩ nhĩpêx to ho ri apa. Anhõrkwỹ re rỳ atõ rỳ atõx rỳ aprõ nẽ akrajê re. Rỳ akatorxà nẽ anhĩpêêxà war are. Rỳ akukrêx piitã rer pa hãmri nẽ ma ixkapẽr o mẽ piitã mẽ ahkre ho ri mẽ hkôt apa. ");
INSERT INTO apnNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","Hã kot paj ja hã mẽ apumu nẽ mẽ ato mex rax nẽ. Hãmri ka mẽ ma nhỹhỹm apa nẽ nhỹri mẽ kãm ixkapẽr jarẽnh o ri mẽ hkôt apa nhũm mẽ kot mẽ amar xwỳnh kwỳjaja mẽ ama nẽ ra kãm mẽ akĩnh nẽ. Nẽ ra mẽ ate akwỳjê rer par tã nhũm mẽ tãmjaja te mẽ apê mẽ hkra rỳ mẽ htõ rỳ mẽ htõx pyràk o mẽ anhĩpêx nẽ tanhmã mẽ ato mex to ho pa. Hãmri ka mẽ nhỹrmã ty nẽ ma Tĩrtũm mẽ wa inhõ krĩ hwỳr api hãmri nẽ wa ixkuri amex kumrẽx nẽ atĩr tũm nẽ apa ho apa. Anẽ. Nhũm pre ã Jejus Simãw Pêtre mẽ hkwỳjê mã kapẽr anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Tã nhũm Jejus mẽ kot ỹ hã kapẽr jarẽnh o mẽ pa xwỳnh pê 12jaja mẽ hkwỳjê pê mẽ ho kato. Nẽ nhỹri mẽ hkàx ã mẽ o xa nẽ tanhmã mẽ kãm amnhĩ jarẽnh to nẽ mẽ kãm: —Amnepêm Tĩrtũm nhỹ hã kapẽr jarẽnh xwỳnhjaja na prem ixkukamã tanhmã mẽ kot inhĩpêx to hã ijarẽ nẽ ixtã kagà. Tã pu mẽ ra Jerujarẽ hwỳr mõ. Kamã koja mẽ tanhmã ixto rax nẽ. Ra mẽ kot ixkukamã ijarẽnh nẽ ixtã kagà xà hkôt koja mẽ ixto anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","33","Koja mẽ kãm ixkurê xwỳnhjaja ixpynê nẽ Rõm nhõ xwỳnhjê nhõ pôristi hwỳr ixto tẽ nẽ mẽ kãm ixto hêx nhũm mẽ kuma nẽ mẽ mar xà hkôt tanhmã inhĩpêx to. Nẽ mẽ hkwỳjaja ixtã hpẽr o axkẽ nẽ akunha. Nẽ mẽ hkwỳjaja ixto kapẽr punuj nẽ ijaprỳ nẽ ixtã argôx rẽ nẽ ixtak. Hãmri nẽ ixpĩ. Ã koja mẽ inhĩpêx anẽ. Nom kot paj ãm ixtyk ã apkati axkrunẽpxi nhũm Tĩrtũmja akupỹm ixto ixtĩr. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Hãmri nhũm mẽ kuma nẽ tee ri htyk nẽ akupỹm htĩrja kukamã hamaxpẽr no ãm hprĩ hã hkôt hamaxpẽr kêt nẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Tã nhũm Jejus mẽ kormã Jerujarẽ hwỳr Jerikoja têp o mõ. Hãmri nhũm pry nhĩhkjê hã no hkre xwỳnhja àhwỳr o nhỹ. ");
INSERT INTO apnNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Hãmri nẽ amnhĩ wỳr mẽ mrar ma. Mẽ ohtôô nẽ Jejus kôt mẽ mrar xwỳnhjê mrar ma nẽ mẽ kãm: —Kwa mẽmo ri? Mẽmoj wỳr na ka mẽ axohtô nẽ mra? Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Hãmri nhũm mẽ kãm: —Nà Jejus pê Najare nhõ xwỳnh kôt na pa mẽ mõ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Hãmri nhũm mẽ kuma nẽ kàx pê Jejus mã kapẽr nẽ kãm: —Pa Jejus? Apê mẽ inhõ Pahihti mex na ka. Te apê amnepêm anhĩgêt pahihti Tawi kot amnhĩ nhĩpêx pyràk. Jakamã kwa ixkamã axukaprĩ nẽ akupỹm ixto mex kêt wehe. Ixte amnhĩ kaxyw akôt ijamaxpẽr xwỳnhjê hõ na pa. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Hãmri nhũm Jejus kukamã mẽ mrar xwỳnhjaja tee ri kuma nẽ kãm: —Tk. Kwa akapẽr kêt nẽ nhỹ nà. Anẽ. Tã no nhũm ãm mẽ kuma nẽ xatã amnhĩ to hwỳr o nhỹ. Kàx pê kãm kapẽr o nhỹ. ");
INSERT INTO apnNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Hãmri nhũm Jejus kuma nẽ xa nẽ amnhĩ wỳr hã karõ nhũm mẽ hpa hã kupy nẽ hwỳr o tẽ nhũm kãm: ");
INSERT INTO apnNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","—Pa mo na? Tanhmã kot pa ato? Anẽ. Nhũm kãm: —Nà akupỹm inhmã ixrĩt mex prãm. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Hãmri nhũm kãm: —Tôe. Nà ra ate amnhĩ kaxyw inhmã ajamaxpẽr tỳx jakamã kot kaj akupỹm ri rĩt. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Hãmri nhũm akupỹm rĩt mex kurê kumrẽx nẽ ja hã amnhĩ pumu nẽ hkĩnh tỳx nẽ. Hãmri nẽ ma Jejus kôt Tĩrtũm mã mex o mex ã harẽnh o mẽ hkôt tẽ. Hãmri nhũm mẽ kot hã omunh xwỳnhjaja haxwỳja Tĩrtũm mã mex o mex ã harẽnh o Jejus kôt mõ. ");
INSERT INTO apnNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Tã nhũm Jejus arĩ Jerujarẽ hwỳr mõ nẽ Jeriko hwỳr pôj. Hãmri nẽ krĩ kahti hkôt pry hã mõ. ");
INSERT INTO apnNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Nhũm mẽ ra hkôt htu rax nẽ hkôt omunh o mõ. Jakamã nhũm Jakew pê Rõm nhõ pahi mã kwỳjê pê kàxpore hkwỳ jamỳnh xwỳnhjê krãhtũm xwỳnhja. Na pre hikàxpore rax nẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Tã haxwỳja kãm Jejus pumunh prãm nẽ. Nom ãm hakooti nẽ hprĩhti jakamã tee ri kot omunh kaxyw amnhĩ nhĩpêx nhũm mẽ kêp àmnàr rax nẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Hãmri nhũm ra hamaxpẽr nẽ ma kukamã hprõt nẽ tẽ nẽ nhỹri pry mỳri pĩ xãm pumu nẽ hã api nẽ kutêp ajêt. Hãmri nhũm Jejus mõ nẽ hapa. ");
INSERT INTO apnNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Nẽ kànhmã rĩt nẽ omu nẽ kãm: —Pa Jakew. E kwa tokyx tẽn wrỳ pa ma akôt anhõrkwỹ hwỳr tẽ nẽ ari amnhĩm hikra. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Hãmri nhũm kuma nẽ hkĩnh nẽ. Nẽ wrỳk kurê kumrẽx nẽ ma amnhĩ kôt nẽ o tẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Hãmri nhũm mẽ kot omunh o kuhê xwỳnhjaja tee ri ja hã omu nhũm ja mẽ kêp omnuj nẽ nhũm mẽ axpẽn mã harẽnh o: —Tk. Kwa nà. Jakew kot amnhĩ tomnuj xwỳnh tã nhũm Jejus ma hkôt tẽ nẽ kuri pôj. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Hãmri nhũm wa õrkwỹ hwỳr axà nẽ nhỹ nhũm Jakew Jejus mã amnhĩ jarẽnh o: —E. Nà ra ixte pahihti mã kàxpore jamỳnh xwỳnhta na pa pre hte ho prês jakre nẽ amnhĩm hamỳnh rax nẽ. Tã kot paj akupỹm mẽ kãm õr pa. Na pa pre hte mẽ hkwỳjê pê ho 10 nẽ hamỳ. Tã kot paj hipy ho 40 nẽ kurẽ nẽ akupỹm mẽ kãm ho ixpigrành pa. Ã kot paj mẽ hipêx anẽ. Nẽ ixkàxpore jakrêx kot paj ho axkjê nẽ mẽ kêp amrakati xwỳnhjê mã ho ixpigrành pa. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Hãmri nhũm kuma nhũm ja kãm mex nẽ. Jakamã nhũm kãm: —Nà ãm hãmri. Ate pahkukamã panhĩgêt Apraãw pyrà nẽ jarãhã ate amnhĩ tomnuj kaga jakamã na ra jarãhã anhõrkwỹ hwỳr mẽ mex xà axà. Koja Tĩrtũm jarãhã amnhĩ katut kôt ate amnhĩ tomnuj rẽnh pa nẽ axte kãm hamaxpẽr kêt nẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","11","Mẽ ate amnhĩ tomnuj xwỳnhjê hwỳr na pre Tĩrtũm inhmẽ pa wrỳ. Te nhỹri mẽ apikunor nhũm ixte mẽ ajapêr o ixpa kaxyw Tĩrtũm kot mẽ awỳr inhmẽnh nhũm ixwrỳk nẽ nhỹri ixte mẽ ajapêr o ixpa nẽ mẽ amã ixkator nẽ ixkĩnh nẽ ma akupỹm hwỳr mẽ ato inhmõrta pyràk. Anẽ. Hãmri nhũm mẽ ohtô nẽ Jejus mar o hkôt Jerujarẽ hwỳr mra. Na prem htỳx tanhmã kot amnhĩ nhĩpêx to hã hkamnhĩx o hkôt mõ nẽ axpẽn mã: —E ma pu mẽ hkôt. Koja Jerujarẽ hwỳr pôj hãmri nẽ kêp mẽ pahpê Ijaew nhõ pahi nẽ mẽ pahto amnhĩptàr kurê kumrẽx. E kwa ma pu mẽ hkôt. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Nhũm Jejus mẽ hamaxpẽr kôt mẽ omunh mex nẽ. Jakamã kot mẽ piitã mẽ ho amnhĩptàr xà hã arĩgro hã mẽ kãm amnhĩ jarẽnh kaxyw. Kormã Jerujarẽ hwỳr ahtêp kêt ri mẽ kãm amnhĩ jarẽnh kaxyw. Nom hprĩ hã mẽ kãm hã amnhĩ jarẽnh kêt nẽ. Ãm amnhĩ tã kuxi nẽ mẽ kãm awjarẽ nẽ mẽ kãm: —Koja nhỹri krĩ hõ kamã mẽhõ myja. Kot amnhĩ to rax o hkwỳjê jakrenh xwỳnhja. Nẽ krĩ hõ kamã krĩ piitã hkôt pahi nhõ pahihtija hãmri harẽnh ma nẽ amnhĩ wỳr kuwỳ. Kot ma hwỳr mõr nhũm õ krĩ kamã nẽ mããnẽn krĩ hkwỳ kamã kêp mẽ õ pahi kaxyw kot ãm kaxyw nhũm hwỳr nojarêt. ");
INSERT INTO apnNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Hãmri nẽ amnhĩ wỳr kãm mẽ àpênh xwỳnhjê ho 10 nẽ tanhmã mẽ hã karõ hto. Nhũm mẽ hwỳr mra nhũm mẽ kãm amnhĩ jarẽ nẽ mẽ piitã mẽ kãm kàxpore hkwỳ gõ. Ahpỹnhã mẽ kãm hpỹnh nẽ kugõ nẽ mẽ kãm: “E ota ixkàxpore hkwỳta. Kot kaj mẽ ixkutêp tanhmã ri inhmã ho rax to. Kêr pa mẽmo arĩgro hã akupỹn mõ kê ra ixahã inhmã ho ohtô nẽ pa hamỳ.” Anhỹr o mẽ kãm kapẽr hãmri nẽ ma mõ. ");
INSERT INTO apnNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Hãmri nhũm õ krĩ nhõ xwỳnhjaja ra kêp mẽ õ pahi kaxyw harẽnh ma nhũm ja mẽ kêp omnuj nẽ. Nẽ mẽ kãm hkĩnh kêt jakamã ma krĩ hõ kamã kot mẽ kaxyw ãm xwỳnhta wỳr hkwỳ rẽ nhũm mẽ ma hwỳr mra nẽ hwỳr pôj. Hãmri nẽ kot mẽ kaxyw ãm mã xwỳnhta pumu nẽ kãm: “Pa. E ot pa mẽ awỳr mra. Kwa na ka xep ra mẽ ixkaxyw mẽ inhĩõja xãm kaxyw. Kwa nà mẽ inhmã jahti hkĩnhti hã. Kwa mẽ ixkaxyw ãm kêt nẽ nà?” Anhỹr o kãm kapẽr. ");
INSERT INTO apnNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","—Tã no nhũm ãm mẽ kuma nẽ ãm mẽ kuma nhũm mẽ awjanã nẽ mã akupỹm mra. Hãmri nhũm pahija mẽ kaxyw mẽ kãm hkĩnh kêt xwỳnhta xãm nhũm ma akupỹm õ krĩ hwỳr mõ. Mõõ nẽ ra pôj hãmri nẽ amnhĩ wỳr kãm mẽ àpênh xwỳnhjê hã karõ nẽ mẽ kãm: “E no ixte mẽ amã kàxpore nhõr xwỳnhta? Tanhmã na ka prem ixkutêp inhmã ho rax to? E mẽ inhmã agõ pa omu.” Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","—Hãmri nhũm wamta kãm: “Ota akàxpore ate inhmã õr xwỳnhta. Na ka pre inhmã ho pyxi nẽ agõ pa kupy nẽ ho mẽmo hy hkwỳ japrô nẽ hkre. Nhũm ô pa mẽ kãm ho wẽnê ho ri ixpa nẽ hpãnhã kàxpore jamỳ nẽ hipy amã kurẽ nhũm ra kêp 10. Ota. E amỳ.” Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","—Hãmri nhũm kuma nẽ hkĩnh nẽ. Hãmri nẽ kãm: “Nà ãm hãmri na ka ã inhmã ho rax anẽ. Ixte amã ho pyxi nẽ õr tã ka pre inhmã hamãr mex nẽ nhũm kànhmã axkamẽ nẽ ra kêp 10. Tã ra ixpê krĩ hkwỳ kamã mẽ õ pahi jakamã kot ka inhmã krĩ ho 10 nẽ inhmã hamãr o ri apa. Jakamã kwa mãmrĩ amnhĩm kàxporeta o arĩk.” Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","—Hãmri nhũm hpãnhã hõja hwỳr tẽ nẽ kãm: “E ota akàxporeta. Na pa pre ho mẽmo hy hkwỳ japrô nẽ hkre nhũm ô pa mẽ kãm ho wẽnê nẽ hpãnhã kàxpore jamỳ nẽ hipy amã kurẽ nhũm ra kêp 5. Tã ota. E amỳ.” Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Hãmri nhũm kuma nẽ kãm: “Nà ãm hãmri. Hãmri na ka ã inhmã ho rax anẽ. Jakamã kot kaj hpãnhã inhmã krĩ ho 5 nẽ ho amnhĩptàr o apa. E mãmrĩ amnhĩm kàxporeta o arĩk.” Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","21","—Hãmri nhũm hpãnhã hkôt hõta tẽ. Nom hkwỳjê hkĩnhã õ patrãw mã tanhmã kàxpore ho rax to hkêt nẽ. Ãm tanhmã hamaxpẽr punuj to nẽ htỳx ri kot kêp ho õxỳ nẽ amnhĩm piitã hamỳnh par nẽ akupỹm kãm hkwỳ nhõr kêt ã hkamnhĩx. Jakamã tanhmã kãm ho rax to hkêt nẽ. Ãm hkupu nẽ o tẽ nẽ nhỹri kutêp kuxi. Hãmri nhũm õ patrãw amnhĩ wỳr hã karõ nhũm hwỳr tẽ nẽ amnhĩ nê kãm kapẽr punuj nẽ kãm: “Tk. Ota akàxporeta. Ixte amã tanhmã ho rax tore hã. Ixte amã ho rax ronhỹx ka amnhĩm piitã hamỳnh pa nẽ akupỹn inhmã hkwỳ nhõr kêt nẽ. Rỳ ixte tanhmã apê homnuj to ronhỹx ka hã inhmã akir. Jakamã na pa tanhmã amã ho rax to hkêt nẽ. Ãm hkupu nẽ o tẽ nẽ ho amũxu nhũm arĩ akutêp hikwỹ. Tã ota.” Anhỹr o amnhĩ nê õ patrãw mã kapẽr punuj nẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","23","Hãmri nhũm tee ri amnhĩ tã kuma. Kot amnhĩ to mex xwỳnh nẽ kãm mẽ àpênh xwỳnhjê ho mex o pa xwỳnh tã ã kãm àpênh xwỳnh kot kãm kapẽr anhỹrja ma nẽ amnhĩ tã kamã gryk nẽ. Hãmri nẽ kãm: “Tk. Kwa xà ã ixte amnhĩ nhĩpêx anhỹr? Nà ixte ã amnhĩ nhĩpêx anhỹr kêt. Ã ixte amnhĩ nhĩpêx anhỹr nhũm amã ixpuma ronhỹx ka pre amã ixpuma xàj ixkàxporeta py nẽ ixwakre kamã amnhĩ krã hkôt tanhmã inhmã ho rax to. Tã nhỹx pa pre ra akupỹn awỳr tẽ nẽ hamỳ. Nà na ka ã ijarẽnh anhỹr o axêx nẽ amnhĩ krã hkôt tanhmã inhmã ho rax to hkêt nẽ. Mỳrapê kot paj atomnuj tỳx nẽ ka rĩ amnhĩ pumu. Pẽr ãm ajamaxpẽr punuj.” ");
INSERT INTO apnNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","—Nhũm pre ã kãm kapẽr anẽ hãmri nẽ mẽ kot mar o kuhê xwỳnhjê mã kãm: “E mẽ atõ kêp kàxpore py nẽ wam kot ho 10 nẽ hamỳnh xwỳnhta mã agõ.” Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Hãmri nhũm mẽ tee ri kuma nhũm ja mẽ kêp omnuj nhũm mẽ kãm: “Kwa nà ra hikàxpore rax kênã. Ra ate kãm ho 10 nẽ õr kênã.” Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Hãmri nhũm mẽ kãm: “ỹỹ nom tãã. Mãmrĩ kãm agõ. Koja mẽhõ inhmã àpênh mex pa amnhĩ tã omu nẽ kot inhmã àpênh mexta pãnhã ho mex nẽ. No koja inhmã àpênh mex kêt nẽ pa tee ri ja hã omu nẽ ho mex kêt nẽ. E mãmrĩ kãm agõ.” Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Hãmri nẽ hpãnhã mẽ kãm: “E hpãnhã mẽ kãm ixprãm nõkati xwỳnhjaja. Ixte mẽ ho amnhĩptàr mã tã mẽ kãm ixprãm nõkati xwỳnhjaja. Mẽ ma mẽ hwỳr mra nẽ mẽ ho akuprõ nẽ akupỹn amnẽ ixwỳr mẽ o mra nẽ inhnoo mã mẽ himex pa.” Anẽ. Ã mẽ ujarẽnh kot anhỹr. Anẽ. Nhũm pre Jejus ã mẽ kãm ujarẽnh anẽ. Te tãm kêp patrãwta pyrà nẽ ã amnhĩ jarẽnh anẽ. Mẽ kot tanhmã amnhĩ nhĩpêx to ho pa hã mẽ omunh xà hkôt tanhmã mẽ hipêx to hã amnhĩ jarẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Nhũm Jejus kormã Jerujarẽ hwỳr mõ. ");
INSERT INTO apnNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Hãmri nẽ ra Petake mẽ Petãn wa htêp o mõ. Hixêt pê Oriwêhti kahti ri na krĩ wa xa. Jakamã nhũm Jejus hkôt mẽ pa ho mẽ pa xwỳnh wa ho axkrut nẽ amnhĩ kukamã wa kumẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Nẽ wa kãm: —E. Wa ma krĩ mũj wỳr mẽ ixkukamã wa tẽ. Nẽ wa hwỳr pôj nẽ nhỹri jumẽnre nyw mã ê nẽ ãm ata pumu. Kormã mẽ kot hã hkrĩ hkêt xwỳnhta. Ka wa omu nẽ kãm ê xà hpôt nẽ man akupỹn ixwỳr o tẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Nhũm mẽhõ ja hã war apumu nẽ hã tanhmã war amã kapẽr to ka wa kãm ã ijarẽnh anẽ nẽ kãm: “Mẽ panhõ Pahihti na hã karõ pa wa hwỳr tẽ.” Anhỹr o wa kãm ijarẽ. E wa ma hwỳr tẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Hãmri nhũm wa kuma nẽ ma hwỳr htẽm kurê kumrẽx. Nẽ wa krĩm pôj nhũm Jejus kot wa kãm harẽnh xà hkôt jumẽnreta pumu. ");
INSERT INTO apnNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Hãmri nẽ kãm ê xà hpôt o xa nhũm õ dõnjaja mra nẽ hã wa omu nẽ wa kãm: —Tk. Kwa mo kaxyw na ka wa ri mẽ ixpê mẽ ixkrit mã ê xà pôt o wa xa? Kwa xà kot kaj wa mẽ ixpê ho ahkĩ nà? Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Hãmri nhũm wa mẽ kãm: —Nà mẽ panhõ Pahihti na wa inhmã anẽ pa wa tẽ. Wa ixte ma akupỹm kutã ho inhmõr kaxyw. Anẽ. Hãmri nhũm mẽ wa kuma nẽ wa kãm: —Tôe. Nà wa mãmrĩ ma kãm o tẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Hãmri nhũm wa ma akupỹm Jejus wỳr o tẽ. Hãmri nẽ kaxyw amnhĩ xê hkwỳ hopôj nẽ kãm ho hkô kahty nẽ kãm ho htỳx nẽ o xa nhũm hã nhỹ nẽ mõ. ");
INSERT INTO apnNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Kormã Jerujarẽ hwỳr hixêt ã àpir o mõ. Nhũm mẽ kot omunh o mrar xwỳnhjaja hkĩnh nẽ ma hkukamã kot pry ho mex kaxyw amnhĩ xê hkwỳptyr o mõ. ");
INSERT INTO apnNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Hãmri nhũm mẽ hixêt ã api nẽ kormã ahpar mã wrỳk o mõ. Hãmri nhũm Jejus kôt mẽ pa ho pa xwỳnhjaja kàx pê Tĩrtũm mex o mex ã harẽnh o hkôt mõ. Ra mẽ kot hkôt pikamẽnh ry nẽ kot mẽ kãm aa mẽmoj pumunh kêt kwỳ ho anhỹr rax ã omunh jakamã hkĩnh nẽ nẽ Tĩrtũm mex o mex ã harẽnh o hkôt mõ. ");
INSERT INTO apnNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Nẽ harẽnh o: E ota Tĩrtũm kot mẽ pahwỳr mẽnh xwỳnhta na ra pôj. ãm hãmri na mẽ pahwỳr wrỳ. Na mex kumrẽx. Kêp mẽ panhõ Pahihti mex na. Ãm hãmri na pre Tĩrtũm mẽ pahwỳr kumẽ. Tĩrtũmja mex kumrẽx. Mex o mex. Kukwak ri pix mã na pu htem pajamakêtkati nẽ paxàmnhĩx ri papa rãhã ho papa. Anhỹr o Jejus kôt harẽnh o mõ. Ra kot mẽ ho amnhĩptàr kurê kumrẽx ã hkamnhĩx jakamã hkĩnh nẽ hkôt ã kapẽr o mõr anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Hãmri nhũm Parijew nhõ xwỳnh kwỳjaja mẽ hkôt mra nẽ tee ri mẽ kuma hãmri nẽ Jejus mã kãm: —Kwa Jejus. Mẽ kãm anẽ kê mẽ anhĩkrê nà? Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Hãmri nhũm mẽ kãm: —Tk. Nà kot paj mẽ kãm anhỹr kêt nẽ. Ã mẽ kapẽr anhỹrja na inhmã mar hprãm. Kwãr mẽ mãmrĩ Tĩrtũm mã mex o mex ã harẽnh o ixkôt mõ. Kot mẽ anhỹr kêt nhũm ra pikap kẽn nhĩkwỹ xwỳnhja tee ri ja hã mẽ omu hãmri nẽ tãm tanhmã amnhĩ nhĩpêx to nẽ mẽ hpãnhã tãm Tĩrtũm mã mex o mex ã harẽnh o hikwỹ. Jakamã kwãr mẽ mãmrĩ kapẽr anẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Nhũm mẽ kormã Jerujarẽ hwỳr hpôx o mõ. Kormã hixêt rũm ahpar mã hwỳr wrỳk o mõ. Hãmri nhũm Jejus amỳm amnhĩ hkukamã Jerujarẽ nhõ xwỳnhjê pumunh o mõ nẽ mẽ hkukamã hamaxpẽr o hkaprĩ nẽ. Hãmri nẽ hkaprĩ xàj mỳr o mõ. ");
INSERT INTO apnNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Hãmri nẽ te kot mẽ kuri mẽ omunh o ri pa pê mẽ kãm kapẽr pyràk o mẽ kãm kapẽr nẽ mẽ kãm: —Hêxta waa nẽ Jerujarẽ nhõ xwỳnhjaja. Kot kaj mẽ amex kêt nẽ. Mẽ ate amnhĩ kukamã axàhpumunh mex ronhỹx ka mẽ ra mẽ kãm mẽ akurê xwỳnhjê pumaj ixkôt amnhĩ xunhwỳr kurê kumrẽx nhũm mẽ tee ri tanhmã mẽ ato mã. Ka mẽ ra ixkukwak ri amex nẽ ajamakêtkati nẽ akĩnh nẽ ri apa ho apa. ");
INSERT INTO apnNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","44","Tĩrtũm tãm kot mẽ awỳr inhmẽnh tã ka mẽ amã ixprãm kêt nẽ. Jakamã koja nhỹrmã mẽ kãm mẽ akurê xwỳnhjaja mẽ awỳr mra nẽ mẽ anhõ krĩm hipôk pa. Hãmri ka mẽ amnhĩ wỳr mẽ omu nẽ tee ri ajapôx kaxyw nhũm mẽ awỳr agjê nẽ mẽ anhĩmex pa nẽ mẽ anhõ krĩja grành pa. Nẽ ahpỹnhã ri mẽ anhõrkwỹ grành pa. Ã koja mẽ mẽmoj piitã grành par anẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","46","Tã nhũm Jejus Jerujarẽ hwỳr axà nẽ jumẽnre rũm wrỳ hãmri nẽ ma Tĩrtũm mã amnhĩ jarẽnh xà hã ixkreja wỳr tẽ. Hãmri nẽ hwỳr axà nẽ tee ri kamã mẽ pa xwỳnhjê pumunh o xa. Nhũm mẽ ra axtem nẽ môx nẽ ôwêhti nẽ tuuti ho wẽnê ho kuhê. Mẽ kot haprôr nẽ Tĩrtũm mã hpar nẽ kãm õr pê kãm amnhĩ jarẽnh kaxyw mẽ kãm ho wẽnê ho kuhê. Nẽ axtem nẽ mẽ kãm hã ohtô rax kãm mẽ kãm ho wẽnê. Hãmri nhũm Jejus mẽ hwỳr axà nẽ tee ri mẽ omu mẽ kãm akir nẽ mẽ kãm: —Tk. Kwa nà. Tĩrtũm kapẽr ã kagà htũm kot õrkwỹ jarẽnh kot: Inhõrkwỹja ãm mẽ ate inhmã amnhĩ jarẽnh xà hã ixkre pix kaxyw na. Anhỹr o kot harẽnh tã ka mẽ axtem nẽ kamã ã amnhĩ nhĩpêx anhỹr o apa. E mẽ ajapôj nẽ ma ajapêx tokyx anẽ. Anhỹr o mẽ kãm kapẽr hãmri nẽ ixkre nê mẽ kator nhũm mẽ ma hapêx pa. ");
INSERT INTO apnNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Tã nhũm Jejus apkati mẽ Tĩrtũm mã amnhĩ jarẽnh xà hã ixkreja wỳr mra nẽ kamã mẽ ahkre ho hkrĩ. Hãmri nhũm mẽ õ patre krãhtũm mẽ Tĩrtũm kapẽr tũm o mẽ ahkre xwỳnhjê mẽ mẽ kot amnhĩ to rũnh xwỳnhjaja kot mẽ ahkre ma nhũm ja mẽ kêp omnuj nẽ nhũm mẽ kãm hpĩr prãm nẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Nom nhũm amarĩ mẽ pa xwỳnhjaja mẽ kurom kãm mar prãm nẽ akryk mar o kuhê. Jakamã nhũm mẽ tee ri ja hã mẽ omu nẽ tanhmã mẽ kot hpĩr to hkukamã hã axpẽn ma. ");
INSERT INTO apnNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Nhũm arĩgro hõ hã nhũm Jejus kê axte Tĩrtũm mã amnhĩ jarẽnh xà hã ixkreja wỳr axà nẽ mẽ ahkre ho nhỹ. Tanhmã mẽ kot amnhĩ nhĩpêx to nẽ nhỹrmã Tĩrtũm mẽ wa kuri htĩr tũm nẽ pa hã mẽ kãm kapẽr o nhỹ. Hãmri nhũm Ijaew nhõ pahijê mẽ mẽ kot Tĩrtũm kapẽr tũm o mẽ ahkre xwỳnhjê mẽ mẽ õ patre krãhtũmjaja hêx rom mar o kuhê. ");
INSERT INTO apnNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Hãmri nẽ kãm: —Kwa mẽ inhmã amnhĩ jarẽ. Mẽhõ nhỹ hã na ka hte ã amnhĩ nhĩpêx anhỹr o ri apa? Na ka hte akupỹm mẽ ho mex o apa nẽ tanhmã mẽ ahkre hto ho apa. Xà amnhĩ krã hkôt na ka hte ã amnhĩ nhĩpêx anẽ nà? Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Hãmri nhũm mẽ kãm: —Nà ixkumrẽx kot paj mẽmoj tã mẽ akukja. Ka mẽ inhma nẽ inhmã harẽ pa rĩ kormã tanhmã mẽ amã amnhĩ jarẽnh to. ");
INSERT INTO apnNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Finat Juãw Paxisja ã kot paj mẽ akukja. Mẽhõ nhỹ hã na pre mẽ hkrã kumrãr o pa? Xà amnhĩ krã hkôt nà xà Tĩrtũm nhỹ hã? E mẽ atõ inhmã harẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","6","Hãmri nhũm mẽ kuma nẽ tee ri kot tanhmã kutã kãm harẽnh to hkukamã hamaxpẽr nẽ axpẽn mã: —Kwa tanhmã kot puj mẽ kãm harẽnh to? Jar mẽ kot mar xwỳnhjaja na htem kêp Tĩrtũm nhỹ hã kapẽr jarẽnh o pa xwỳnh ã harẽnh o pa. Tã kot puj mẽ kãm kot amnhĩ krã hkôt mẽ hkrã kumrãr o pa hã harẽ nhũm mẽ tee ri mẽ pama nẽ mẽ pakamã gryk tỳx nẽ. Nẽ mẽ paxêx rom mẽ pahte kãm pakapẽr ã mẽ pahpumunh kurê kumrẽx nẽ kẽn o mẽ pahtak o mẽ panhĩmex. Nom kot puj mẽ kãm Tĩrtũm nhỹ hã mẽ hkrã kumrãr ã harẽ nhũm mẽ pamã kapẽr o: “ã kot anhỹr kênã na ka prem kapẽr ma nẽ ra ixkôt amnhĩ xunhwỳr kêt nẽ?” Anẽ. Nà kot puj mẽ kãm tanhmã harẽnh to hkêt nẽ. Kot puj mẽ ãm kãm aa te mẽ pahte ja jarẽnh mar kêt pyràk o harẽ. Anẽ. Mẽ kot tanhmã kãm nẽ nhũm kot ta pãnhã tanhmã mẽ kãm nẽ pymaj nhũm mẽ ãm tee ri kãm tanhmã nẽ hprãm kaprỳ o kuhê. ");
INSERT INTO apnNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Hãmri nẽ kãm: —Konẽn. Mẽ ixte mẽhõ nhỹ hã kapẽr o pa hã omunhre hã. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Hãmri nhũm mẽ kuma nẽ mẽ kãm: —Tk. Tôe kot pa xep ijaxwỳja mẽ amã tanhmã amnhĩ jarẽnh to hkêt nẽ. Ijaxwỳja ixte mẽhõ nhỹ hã ã ixte amnhĩ nhĩpêx anhỹr o ri ixpa hã amnhĩ pumunhre hã. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Nhũm Jejus arĩ Ijaew nhõ pahijê mã kapẽr. Nẽ mẽ kot tanhmã hipêx to hkukamã mẽ kãm tanhmã amnhĩ jarẽnh to. No ãm amnhĩ tã kuxi nẽ mẽ kãm awjarẽ nẽ mẽ kãm: —Koja mẽhõ hpur ã hkwỳjê kot kamã kãm àpênh kaxyw mẽ kãm karõ. Hãmri nhũm mẽ ma hwỳr mra nẽ kamã mẽmo hy hkre nẽ hkre pa. Hãmri nhũm ra hpur nhõ dõnja nhỹhỹm nojarêt nẽ kãm mẽ àpênh xwỳnhjê mã tanhmã hpur jarẽnh to nẽ mẽ kãm: “E or ixpur nõ. Kê kamã mẽmoj hkà hpa ka mẽ mãmrĩ kamã axujamỳnh pa nẽ ho axkjê. Nẽ ixkutêp inhõ jaxwỳ nẽ mãmrĩ mẽ anhõ tanhmã ho hprãm xà hkôt tanhmã ho.” Anẽ. —Nhũm ã mẽ kãm kapẽr anẽ hãmri nẽ ma nhỹhỹm mõ. ");
INSERT INTO apnNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","—Tã nhũm ra hkà hpa. Nom nhũm hpur nhõ dõnja kormã krĩ hõ kamã ri hã ujahkre ho ri pa. Tã kuri kãm àpênh xwỳnhjê hõja nhũm akupỹm mẽ hwỳr kumẽ. Mẽ kot kãm kwỳ nhõr nhũm ma kot kãm o mõr kaxyw ma mẽ hwỳr kumẽ nhũm ma mẽ hwỳr mõ. Mõõ nẽ mẽ hwỳr pôj nhũm mẽ omu nẽ axtem nẽ unê nẽ htak nẽ akupỹm hano nhũm ma akupỹm ỹ kamã mõ. ");
INSERT INTO apnNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Hãmri nẽ pôj nhũm õ patrãwja tee ri omu nẽ hpãnhã ja mẽ nhũm ma mẽ hwỳr mõ. Mõõ nẽ mẽ hwỳr pôj nhũm kê wem mã ho anẽ nẽ unê nẽ htak nẽ akupỹm hano nhũm wamta pyrà nẽ ma akupỹm ỹ kamã mõ. ");
INSERT INTO apnNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","—Hãmri nhũm kê axte hkôt ja mẽ nhũm ma mẽ hwỳr mããnẽn mõ. Ma mẽ hwỳr mõ nẽ pôj nhũm mẽ te ho wamta wa hipêx pyràk o hipêx nẽ unê nẽ htak rax nẽ amnhĩ nê hano nẽ pur nê kapôt ã kumẽ. Hãmri nhũm ma akupỹm mããnẽn ỹ kamã mõ. ");
INSERT INTO apnNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Nhũm mẽ õ patrãw tee ri mẽ omu nẽ hamaxpẽr o: “Hêxta waa nẽ. Tanhmã kot paj amnhĩ nhĩpêx to? Nà kot paj mẽ hwỳr ixkra mãn mẽ. Inhmã hapê htã kot paj mẽ hwỳr kumẽ kê ma mẽ hwỳr mõ. Hãmri nhũm mẽ kêp ixkra hã omu nẽ tanhmã ixpê ho hkêt nẽ. Nẽ tã inhmã kãm inhõja kwỳ gõ.” Anhỹr o hamaxpẽr hãmri nẽ ma mẽ hwỳr kumẽ nhũm ma mẽ hwỳr mõ. ");
INSERT INTO apnNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","—Tã ra mẽ hwỳr hpôx o mõ nhũm mẽ amỳm amnhĩ wỳr omu nẽ kêp hkra hã omu nẽ hã axpẽn mã amỹnê nẽ axpẽn mã: “E onẽj hpur nhõ dõn krata tẽ. Koja nhỹrmã õ papaj mỳr pê amnhĩm pur ã pyka pytà nẽ ho õ. Kwa pu mẽ hpĩr kurê kumrẽx nẽ kêp hpurja o panhõ. E tokyj pu mẽ kupĩ ri.” Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","—Hãmri nhũm tẽ nẽ mẽ hwỳr pôj nhũm mẽ unê nẽ pur nê ho kato nẽ ma o tẽ nẽ kupĩ. Ã mẽ ujarẽnh kot anhỹr. Anẽ. Nhũm pre ã Jejus mẽ kãm ujarẽnh anẽ nẽ hã tanhmã mẽ hkukjêr to nẽ mẽ kãm: —E koja hpur nhõ dõnja hkra jarẽnh ma hãmri nẽ tãm mẽ hwỳr mõ nẽ tanhmã mẽ hipêx to wehe? ");
INSERT INTO apnNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Koja ma mẽ hwỳr mõ hãmri nẽ mẽ himex pa. Hãmri nẽ hpãnhã hpur ã nhãm mẽmojjê rẽ nhũm mẽ tã kãm hamãr mex o pa. Anẽ. Nhũm pre ã Jejus mẽ kãm ujarẽnh anẽ hãmri nhũm mẽ kot mar xwỳnhtaja ujarẽnh kamã amnhĩ jarẽnh mar kurê kumrẽx. Mẽ kot Tĩrtũm kot mẽ hwỳr rẽnh xwỳnhjê kapẽr mar kêt nhũm mỳrapê mẽ kãm mẽ hkurê xwỳnhjaja kot mẽ kêp mẽ õ pika pytàr nẽ mẽ himex par ã amnhĩ jarẽnh ma nhũm ja mẽ kêp omnuj tỳx nẽ. Hãmri nẽ hêx rom Jejus mã kãm: —Tk. Kwa nà nhỹx pre kêt pur nhõ dõnja ã mẽ hipêx anhỹr kêt nẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Hãmri nhũm mẽ kuma nẽ mẽ omunh o xa. Nẽ mẽ omunh pê mẽ no kagàr mã mẽ kãm kapẽr nẽ mẽ kãm: —Nà ã mẽ hipêx anhỹr mã mẽ tãm kênã. Mãn ka prem ra Tĩrtũm kapẽr ã kagà htũm kot ja jarẽnh ma. Harẽnh kot: Mẽ kot kẽn o amnhĩm õrkwỹ nhĩpêx kaxyw nẽ kẽn maati pumu nẽ htỳx omnuj ã hkamnhĩx nẽ hkaga. Mẽ kot hkaga htã Tĩrtũm mẽ kurom mex o kot kẽn piitã hakrenh par ã omunh kurê kumrẽx. Anẽ. Ã Tĩrtũm kapẽr ã kagà htũm kot mẽ ajarẽnh te mẽ kot kẽn maati punuj ã hkamnhĩx nẽ hkaga xwỳnhjê jarẽnh pyràk o ã mẽ ajarẽnh kot anhỹr. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Nhũm pre ã Jejus mẽ kãm te kêp kẽn maati pyràk o mẽ kãm amnhĩ jarẽnh anẽ. Hãmri nẽ axte amnhĩ tã kuxi nẽ mẽ kãm axte kẽn jarẽnhta pyrà nẽ mẽ kãm: —Nà kot kaj mẽ atõ ixkaga hãmri nẽ te mẽhõ htỳx htẽm nẽ kẽn pumunh kêt nẽ hã htêk nẽ tẽm pyràk o amnhĩ nhĩpêx. Jao ixkutã amnhĩ xãm. Rỳ ka tanhmã amnhĩ to nẽ ixkaga nhũm te kẽn maati hõ htẽm nẽ kot anhĩpy htẽm nẽ axôm par pyràk o anhĩpêx ka amex kêt nẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Nhũm pre ã Jejus mẽ kãm ujarẽnh kãm mẽ harẽnh anẽ. Hãmri nhũm Tĩrtũm kapẽr tũm o mẽ ahkre xwỳnhjê mẽ mẽ õ patre krãhtũmjaja kot mẽ kãm kẽn jarẽnh o te mẽ tãm harẽnh pyràkja ma nhũm ja mẽ kêp omnuj tỳx nẽ. Jakamã nhũm mẽ kãm Jejus pynênh nẽ haxàr prãm nẽ. Nom amnhĩ tã kãm mẽ kot mar o kuhê xwỳnhjê puma nẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Hãmri nhũm Tĩrtũm kapẽr tũm o mẽ ahkre xwỳnhjê mẽ mẽ õ patre krãhtũmjaja Jejus tãnopxar o kuhê. Hãmri nẽ ra amnhĩ wỳr mẽmy hkwỳ hã karõ nẽ mẽ kãm: —E. Mẽ ma Jejus wỳr mra nẽ te mẽ ate hkôt amnhĩ xunhwỳr kaxyw pyràk o amnhĩ nhĩpêx nẽ mẽmoj tã ri hkukja. Mẽmoj tã hkukjêr rax nẽ. Kêr kê Rõm nhõ pahi Sesti kapẽr kwỳm ri tanhmã mẽ amã kapẽr to ka mẽ ama nẽ man akupỹn mra nẽ mẽ inhmã harẽnh kurê kumrẽx. Pa mẽ ama nẽ ma hwỳr mra nẽ hã unê nẽ ma Sesti nhỹ hã mẽ pahto amnhĩptàr xwỳnhta wỳr o tẽ nẽ ĩhkram haxà. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Hãmri nhũm mẽ kuma nẽ mẽ kãm: —Tôe. Nà kot paj mẽ anẽ. Anẽ. Hãmri nẽ ma hwỳr mra nẽ hêx rom kãm kapẽr nẽ kãm: —Pa Jejus? Nà ãm hãmri na ka hte Tĩrtũm kapẽr o mẽ ahkre mex o ri apa. Na ka hte mẽ kamã akahak kêt nẽ. Nẽ mẽ kot tee ri tanhmã ato kapẽr punuj to htã ka aprĩ hã mẽ ahkre mex o ri apa. ");
INSERT INTO apnNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Kwa mẽ inhmã mẽmoj jarẽ. Rõm nhõ pahihti kot mẽ pahte kãm kàxpore hkwỳ nhõr ã mẽ pahpê Ijaew mã karõta. Kwa xà we ja amã mex nà? Xà kot pu mẽ kãm kugõ nà xà kot pu mẽ kãm õr kêt nẽ? E kwa mẽ inhmã tanhmã harẽnh to. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Nhũm prem ã hêx rom kãm kapẽr anhỹr tã nhũm ra mẽ hamaxpẽr ã mẽ omu nẽ mẽ kãm: ");
INSERT INTO apnNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","—E mẽ atõ anhõ kàxpore htỳxre japêr nẽ inhmã hõ gõ pa omu. Anẽ. Hãmri nhũm mẽ kãm ja gõ nhũm kupy nẽ omu nẽ kànhmã mẽ kãm kupẽ nẽ mẽ kãm: —E mẽhõ nhĩxi nẽ mẽhõ karõ na ja hã? Anẽ. Hãmri nhũm mẽ kãm: —Pahi Sesti karõ nẽ hixi na hã kênã. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Hãmri nhũm mẽ kuma nẽ mẽ kãm: —Tỳ. Tô kêr ka mẽ mãmrĩ kãm hkwỳ nhõr o apa. Hã hkarõ nẽ hã hixi. Tãm kot hipêx xwỳnh jakamã õ na. No mẽ kajaja na pre Tĩrtũm mẽ anhĩpêx nhũm mẽ apê õ jakamã kwa kêr ka mẽ kapẽr kôt pix mã ri amnhĩ nhĩpêx o ri apa. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Nhũm pre ã Jejus mẽ kãm kapẽr anẽ nhũm mẽ piitã mar o kuhê. Nhũm mẽ kot hêx rom kãm kapẽr mã xwỳnhjaja amnhĩ jaêr pê ã kot kàxpore jarẽnh anhỹrja ma. Hãmri nẽ tee ri axte mẽmoj tã hkukjêr nhũm kot pahi Sesti kwỳm ri kot tanhmã harẽnh to kaxyw ãm tee ri tanhmã hkukjêr to kaprỳ. Hãmri nẽ axte tanhmã kãm nẽ hkêt nẽ ãm akryk omunh pê mar o kuhê. ");
INSERT INTO apnNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Tã nhũm Satusew nhõ xwỳnh kwỳjaja. Mẽ kot akupỹm mẽ htĩr mã hamaxpẽr kêt jakamã mẽ htyk nẽ mẽ hapêx ã mẽ hkamnhĩx. Jakamã na prem tanhmã axpẽn mã Jejus jarẽnh to nẽ axpẽn mã: —E kwa pu mẽ ma hwỳr mra nẽ mẽmoj xihtỳx ã hkukja kê mẽ pama nẽ tee ri tanhmã mẽ pamã harẽnh to hkukamã hamaxpẽr. Hãmri nhũm mẽ piitã ja hã omu nẽ àhpumunh tỳx kêt ã omunh kurê kumrẽx. E ma pu mẽ hwỳr. Anẽ nẽ ma hwỳr mra nẽ Parijew nhõ xwỳnhjê pyrà nẽ hêx rom ahkukja nẽ kãm: ");
INSERT INTO apnNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","—Pa Jejus? Kwa mẽ inhmã mẽmoj jarẽ. Na pre finat Mojesja Tĩrtũm nhỹ hã mẽ panhĩgêt mã ã karõ anẽ. Mẽ hkra hkêt rãhã mẽ pa nẽ mẽ htyk xwỳnhjaja nhũm mẽ harẽnh o: Koja mẽhõ hprõ nẽ kormã kamã hkra hkêt rãhã pa nẽ ty. Hã koja hkôt htõja hpãnhã hprõta o hprõ nẽ kamã hkra. Hãmri nhũm kato nẽ te kêp htõ htyk xwỳnhta hkra pyràk. Anẽ. Na pre ã Mojes mẽ kãm karõ anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Jakamã kwa ga mẽ ixujarẽnh ma. Koja mẽ kot axpẽn to htõ xwỳnhjaja kêp 7. Nhũm kot waja mẽhõ ho hprõ nẽ wa pa nhũm kamã hkra hkêt rãhã ty. Nhũm hkôt htõ hõta hpãnhã hprõ ho hprõ ");
INSERT INTO apnNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","nẽ wa axpẽn to pa. Nhũm mããnẽn ty. Kamã hkra hkêt rãhã ty. ");
INSERT INTO apnNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","—Nhũm htõ hõta. Haxwỳja hpãnhã tãm o hprõ nẽ wa axpẽn to pa grire nhũm haxwỳja kamã hkra hkêt rãhã ty. Hãmri nhũm htõ hkwỳjaja piitã nija pyxi nẽ axpẽn pãnhã ho hprõ hpa. No ãm mẽhõ kamã hkra hkêt rãhã ra htyk pa. ");
INSERT INTO apnNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Hãmri nhũm mẽ hprõta mẽ hkôt amnhĩ to hapu nẽ ty. ");
INSERT INTO apnNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Tã Tĩrtũm kot akupỹm nhỹrmã mẽ ho htĩr ronhỹx nhỹ nhỹx kêp nija mjên kumrẽx? Ra piitã kot ho hprõ kênã. E mẽ inhmã ja jarẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Hãmri nhũm Jejus mẽ kãm: —Nà kaxkwa kamã mẽ kot amnhĩ nhĩpêxja axtem na. Pika ja kamã na htem pa nẽ àptàr nhũm mẽ axpẽn mã mẽ kure. Ja mex. ");
INSERT INTO apnNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","No mẽ kot Tĩrtũm kôt amnhĩ xunhwỳr xwỳnhjaja na htem ty hãmri nẽ Tĩrtũm nhõ krĩ kamã kuri axte kãm hprõ hprãm kêt nẽ ri pa. Rỳ ni japêr nẽ kãm mjên prãm kêt nẽ ri pa. ");
INSERT INTO apnNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Hãmri nẽ Tĩrtũm kapẽr o mẽ wrỳk xwỳnhjê pyrà nẽ axte htyk kêt nẽ. Ãm htĩr tũm rãhã nẽ pa ho pa. Tĩrtũm ra akupỹm kot mẽ ho htĩr jakamã koja mẽ kêp hkra nẽ kuri htĩr tũm nẽ mex nẽ pa ho pa nẽ axte kãm hprõ rỳ mjên prãm kêt nẽ ri pa. ");
INSERT INTO apnNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","—Nom mẽ ate akupỹm mẽ htĩr mã ajamaxpẽr kêt ã harẽnhja kot paj mẽ amã harẽ. Amnepêm na pre Tĩrtũmja pĩ hpôk kamã Mojes mã kapẽr nẽ kãm: Ixpê Apraãw nhõ Tĩrtũm na pa. Nẽ mããnẽn ixpê Apraãw kra Ijak mẽ htàmnhwỳ Jako wa õ Tĩrtũm na pa. Anhỹr o Mojes mã amnhĩ jarẽ nhũm kuma nẽ hã kagà. ");
INSERT INTO apnNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Kêp apu arĩ mẽ htyk rãhã nhỹx pre ã mẽ harẽnh anhỹr kêt nẽ. Nhỹx pre mẽ harẽnh o: “Amnepêm Apraãw nẽ hkra nẽ htàmnhwỳ mẽ htĩr ri ixpê mẽ õ Tĩrtũm na pa pre.” Anhỹr o nhỹx pre mẽ harẽ. Nom na pre ã amnhĩ jarẽnh anhỹr kêt nẽ. Mẽ pamã te Apraãwja mẽ htyk nẽ mẽ hapêx pyràk. Nom nhũm prem ra Tĩrtũm ri akupỹm htĩr nẽ mex nẽ pa ho pa. Tã ka htem Tĩrtũm kapẽr kwỳm ri akupỹm mẽ htĩr kêt ã mẽ harẽnh o apa. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Nhũm pre ã Jejus mẽ kãm kapẽr anẽ. Hãmri nhũm Tĩrtũm kapẽr tũm o mẽ ahkre ho mẽ pa xwỳnh kwỳjaja kuma nẽ tee ri axte tanhmã kãm nẽ hprãm kaprỳ nẽ kãm: —Tỳ. Nà ãm hãmri na ka ã ja jarẽnh anẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Hãmri nhũm mẽ axte mẽmoj tã hkukjêr kêt nẽ. Tanhmã kot wem amnhĩ to nẽ hamaxpẽr o hakre? Na prem ãm tee ri kãm hamaxpẽr o hakrenh prãm kaprỳ ho kuhê. Jejus kot mẽmoj piitã hkukamã àhpumunh tỳx o àhpumunh tỳx. ");
INSERT INTO apnNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Tã nhũm Jejus kànhmã xa nẽ amnhĩ tã tanhmã mẽ kot mar o kuhê xwỳnhjê hkukjêr to. Nom te nhãm mẽhõ hã mẽ hkukjêr pyrà nẽ mẽ kãm: —E kwa mẽ inhmã mẽmoj jarẽ. Tĩrtũm kot mẽ akaxyw ãm mã xwỳnhta ã na pa mẽ akukja. Mo na htem axpẽn mã kêp finat pahi Tawi kanrẽhã htàmnhwỳ pix ã harẽ nẽ mããnẽn kêp õ pahihti hã harẽnh kêt nẽ? ");
INSERT INTO apnNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Na pre Tawi Tĩrtũm kapẽr kwỳ hã kagà nẽ tanhmã harẽnh to. Tĩrtũm mex ã mẽ grer xàja kwỳ kamã harẽ nẽ hã kagà nẽ hã kagà ho: Na pre Tĩrtũm inhõ Pahihti mã ã kapẽr anẽ nẽ kãm: “E amnẽ ixwỳr tẽ nẽ inhĩhkô hã nhỹ nẽ inhmã mẽ ho amnhĩptàr o akrĩ. ");
INSERT INTO apnNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Kot paj mẽ kot kãm akurê xwỳnh piitã mẽ unênh pa nẽ awỳr mẽ o mra nẽ anhĩhkram mẽ haxàr pa.” Anhỹr o pre kãm kapẽr. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Na pre ã Tawija Tĩrtũm kot Kris mã kapẽr jarẽnh anẽ. Mẽ kajaja na ka htem ãm kêp Tawi kanrẽhã tàmnhwỳ pix ã ri axpẽn mã harẽnh o ri apa. No kêt Tawi na pre kêp õ Pahihti hã harẽnh o pa. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Nhũm pre ã Jejus mẽ kãm kapẽr anẽ nhũm mẽ piitã mar o kuhê. Hãmri nhũm hpãnhã hkôt mẽ pa ho mẽ pa xwỳnhjê mã kapẽr nẽ mẽ kãm: —Kwa mẽ o kora. Kêr ka mẽ Tĩrtũm kapẽr tũm o mẽ ahkre xwỳnhjê kot amnhĩ nhĩpêx o amnhĩ nhĩpêx kêt nẽ. Ãm mẽ omu nẽ ãm mẽ omu nẽ mẽ kot amnhĩ nhĩpêx kôt amnhĩ nhĩpêx o ri apa hkêt nẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","Na htem mẽ piitã mẽ kot mẽ hã hpijaàm kaxyw mẽ ê mex pix kãm ri pa. Nẽ mẽ kãm mẽ piitã mẽ kot amnhĩm mẽ rũnh xwỳnh ã mẽ harẽnh o mẽ paja na mẽ kãm hprãm. Nẽ mẽ panhõ Tĩrtũm kapẽr o mẽ ahkre xà hã ixkre kamã mẽ kãm amnhĩ to rũnh xwỳnhjê hkrĩ xà mex pix ã na mẽ kãm mẽ hkrĩ hprãm. Nẽ mẽmoj tã mẽ hkĩnh ã arĩgro hã nhũm htem mẽ apkur xà hã ixkre hwỳr akuprõ nẽ mẽ kãm mẽ kot amnhĩ to rũnh xwỳnhjê hkrĩ xà mex pix ã mẽ kãm mẽ hkrĩ hprãm. Ã na htem amnhĩ nhĩpêx anhỹr o pa. ");
INSERT INTO apnNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","—Nẽ mẽ kêp mẽ mjên htyk xwỳnhjê ho ajuta ho pa hã amnhĩ jarẽnh tã ãm amnhĩ to hêx nẽ axtem nẽ mẽ nokupyr pê mẽ kêp mẽ hikukrêx piitã ho hapêx par o pa. Nẽ mẽ kêp mẽ õrkwỹ pytà. Nẽ mẽ hêx rom te tãm mẽ kot amnhĩ nhĩpêx pyrà nẽ Tĩrtũm mã amnhĩ jarẽnh japjêê ho kuhê. Mỳrapê koja mẽ mex kêt nẽ. Koja Tĩrtũm tanhmã ja hã mẽ hipêx to rax nẽ. Jakamã kwa kêr ka mẽ ã mẽ kot amnhĩ nhĩpêx anhỹr xwỳnhjê hkôt amnhĩ nhĩpêx o apa hkêt nẽ. Ãm kwarĩ ho kwarĩ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Nhũm Jejus kormã Tĩrtũm mã amnhĩ jarẽnh xà hã ixkre kamã mẽ omunh o xa. Na pre hte Ijaew piitã ixkreta ho mex kaxyw kãm mẽ hikàxpore hkwỳ nhõr o pa. Jakamã nhũm mẽ hikàxpore rũnh xwỳnhjaja hwỳr agjê nẽ kamã kàxpore gjênh xà kamã hkwỳ gjê nẽ ma akupỹm mra. ");
INSERT INTO apnNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Jakamã nhũm mẽhõ ni pê mjên htyk xwỳnh haxwỳja hwỳr axà. Kêp amrakati kumrẽx nẽ hikàxpore tỳxre ãm axkrutre htã mẽ hpãnhã hwỳr axà. Nẽ kãm Tĩrtũm kĩnh xàj hamẽ kamã kuxà hãmri nẽ kato nẽ ma akupỹm tẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","4","Hãmri nhũm Jejus arĩ omunh o xa. Kot ã amnhĩ nhĩpêx anhỹr ã omunh o xa nhũm ja kãm mex nẽ. Hãmri nẽ hkôt mẽ pa ho pa xwỳnhjê mã harẽ nẽ mẽ kãm: —E mãn ka mẽnire htẽm mũj pumu. Kêp amrakati nẽ hikàxpore ãm kêp grire htã amnhĩ pê õr pa. Kwỳjê rom kãm Tĩrtũm kĩnh xàj amnhĩ pê õr par kumrẽx. Apkur xà hã hikàxpore na. Mẽ hkwỳjaja na htem hikàxpore hkwỳ ho mra nẽ kugjê nom arĩ mẽ hikàxpore rax. No nhũm nire nẽj mẽ kurom kãm hikàxpore japê hkêt nẽ. Nẽ ho õxỳ hkêt nẽ àmnhĩx piitã Tĩrtũm mã õr pa. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Tã hãmri nhũm Jejus kôt mẽ pa ho mẽ pa xwỳnhjaja kormã Tĩrtũm mã amnhĩ jarẽnh xà hã ixkre kaxwỳnh pumunh o kuhê nẽ axpẽn mã harẽ nẽ axpẽn mã harẽnh o: —Hêxta waa nẽ. Ixkreja mex kumrẽx. Kẽn rũnh o mẽ kot hipêx jakamã mex o mex. Nẽ mẽ kot ri Tĩrtũm mã hkĩnh xà nhõr nẽj haxwỳja piitã mex. Anẽ. Hãmri nhũm Jejus mẽ kuma nẽ mẽ kãm: ");
INSERT INTO apnNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","—Nà mex tã koja nhỹrmã mẽ kãm Tĩrtũm kurê xwỳnhjaja grành pa. Koja arĩ kẽn õ axkrutre nẽ axpẽn mỳnh nẽ nõr kêt nẽ. Koja piitã anhgrà nẽ ahpỹnhã ri hikwỹ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Nhũm pre ã mẽ kot hipêx anhỹrja kukamã mẽ kãm mẽ harẽnh anẽ nhũm mẽ tee ri hkukamã hamaxpẽr nẽ kãm: —Kwa xà koja mẽ ã hipêx anẽ? Kwa mẽ inhmã aprĩ hã mẽ kot ixkre grành parta jarẽ. Xà koja mẽ tokyx ho anẽ nà xà kormã? Kwa mẽmo koja wỳj ri tanhmã amnhĩ nhĩpêx to? Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Hãmri nhũm mẽ kãm: —Nà nhỹrmã mẽmoj piitã hapêx kaxyw tanhmã amnhĩ nhĩpêx to kumrẽx kot paj mẽ amã harẽ ka mẽ inhma. Koja mẽ ohtô nẽ mẽ apê ixkrajê hwỳr mra nẽ hêx rom te pa ixte amnhĩ nhĩpêx pyràk o amnhĩ nhĩpêx o pa. Nẽ tanhmã mẽ amã amnhĩ jarẽnh to nẽ amnhĩ jarẽnh o: “E mẽ ixpumu. Pa na pre Tĩrtũm mẽ awỳr inhmẽ. Ixpê kaxkwa rũm ixwrỳk xwỳnh na pa.” Anhỹr o mẽ akôt mẽ amã amnhĩ to hêx o pa. Hãmri nẽ mẽ amã: “E ot pa ra mẽ ato amnhĩptàr kaxyw mẽ awỳr wrỳ.” Anhỹr o amnhĩ jarẽnh o mẽ akôt pa. Nom kêr ka mẽ ãm mẽ ama nẽ ãm mẽ ama. Ãm mẽ kot mẽ amã amnhĩ to hêx o pa kênã. Kormã akupỹn ixpôx xà hã arĩgrota kormã. ");
INSERT INTO apnNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","—Nẽ koja mẽ nhỹri awry hã axpẽn par o pa. Nẽ mẽ atãã axpẽn par o pa. Nom kêr ka mẽ harẽnh ma nẽ ri tee ri tokyx mẽmoj piitã hapêx kukamã ajamaxpẽr kêt nẽ. Mẽmoj piitã hapêx xà hã arĩgrota kormã. ");
INSERT INTO apnNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Koja mẽmoj piitã hapêx kaxyw nhũm ahpỹnhã ri pika piitã hkôt mẽ pa xwỳnhjaja axpẽn kutã amnhĩ xunhwỳ nẽ pijapu nẽ axpẽn pa. ");
INSERT INTO apnNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Nẽ koja pika piitã hkôt tanhmã ahpỹnhã mẽ à kute mẽ hamỳ nhũm mẽ amnhĩ xà htỳx kamã hamak o pa. Nẽ koja pikaja tertet tỳx nẽ. Nẽ koja mẽ nhỹri pika hkwỳ kamã prãm xàj hpikaprãr pa. Nẽ koja kaxkwa kamã mẽmoj tanhmã amnhĩ anhĩpêx to nhũm pika nhõ xwỳnhjaja tee ri omu nẽ kãm ma htỳx kumrẽx nẽ htertet o kuhê. Koja mẽmoj ã amnhĩ nhĩpêx anẽ pa rĩ kormã akupỹn mẽ awỳr wrỳ nhũm mẽmoj piitã hapêx pa. Koja mẽmoj ã amnhĩ nhĩpêx anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","—E Tĩrtũm mã amnhĩ jarẽnh xà hã ixkre grành par xwỳj ri mẽmoj tanhmã hkukamã kot amnhĩ nhĩpêx to hã mẽ ate ixkukjêr xwỳnhta kot paj hpãnhã mẽ amã harẽ ka mẽ inhma. Koja mẽ kãm ixkurê xwỳnhjaja mẽ awỳr mra nẽ ixtã mẽ apynê nẽ tanhmã ixtã mẽ anhĩpêx to. Nẽ ma mẽ pikuprõnh xà hã ixkreja wỳr mẽ ato mra nẽ kamã mẽ kãm tanhmã mẽ ato kapẽr punuj to. Nhũm mẽ kuma hãmri nẽ ma mẽ ato mra nẽ mẽ ajagjê. Mẽ ate ixkôt apa ho apa jakamã koja mẽ ã mẽ anhĩpêx anẽ. Nẽ mẽ õ pahihti hwỳr mẽ ato mra nẽ mẽ kãm tanhmã mẽ ato kapẽr punuj to. ");
INSERT INTO apnNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Tã kêr ka mẽ kutã akrĩ nẽ axàmnhĩx mãmrĩ tanhmã mẽ kãm ijarẽnh to ho akrĩ. ");
INSERT INTO apnNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","—Nom kwa kêr ka mẽ kãm tanhmã amnhĩ jarẽnh to hkukamã tee ri ajamaxpẽr o ri mẽ amã mẽ uma hkêt nẽ. Rỳ mẽ ajamaxpẽr o: “Hêxta waa nẽ. Tanhmã koja we mẽ kot ixkukjêr ã arĩgrota ã pa we ri mẽ kãm ixkapẽr to?” Anhỹr o tee ri amnhĩ kukamã ajamaxpẽr kêt nẽ. Ãm amnhĩ kaxyw inhmã pix mã ajamaxpẽr tỳx rãhã nẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Tanhmã mẽ kot mẽ anhĩpêx to hã arĩgrota ã kot paj tanhmã mẽ akrã hto ka mẽ inhỹ hã tanhmã mẽ kãm amnhĩ jarẽnh to. Hãmri nhũm mẽ amnhĩ tã mẽ ama nẽ axte tanhmã mẽ ato kapẽr to hkukamã tee ri hamaxpẽr o kuhê. ");
INSERT INTO apnNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","—Nẽ koja mẽ anhĩpêêxà nẽ mẽ akatorxà nẽ mẽ atõ nẽ mẽ akràmnhwỳjaja. Nẽ kaxyw krĩ hkôt mẽ akwỳjaja ixtã mẽ atã amỹnê nẽ ma mẽ õ pahi hwỳr mẽ ato mra nhũm mẽ ajagjê nẽ mẽ akwỳjê pa. ");
INSERT INTO apnNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Koja mẽ piitã ixtã mẽ akamã gryk nẽ kãm mẽ akurê nẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","19","Nom mẽ kot ã mẽ anhĩpêx anhỹr mã tã kêr ka mẽ amnhĩ to htỳx nẽ ixkaga hkêt nẽ. Mẽ kot mẽ apar tã ka mẽ kaxkwa kamã akupỹm atĩr kurê kumrẽx. Hãmri nẽ ã mẽ kot mẽ anhĩpêx anhỹr xwỳnhjê rom Tĩrtũm mẽ wa ixri atĩr tũm nẽ amex rãhã apa ho apa. Mẽ kot tanhmã mẽ ato htã mẽ ate kaxkwa kamã atĩr tũm nẽ apa mã xwỳnh jakamã kwa kêr ka mẽ tee ri amnhĩ kukamã ajamaxpẽr o ri apa hkêt nẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","—Koja nhỹrmã nhỹhỹnh pôristi ohtô nẽ mra nẽ Jerujarẽ hwỳr pôj hãmri nẽ mẽ kãm hipôk pa nẽ kuhê. Ka mẽ ja hã mẽ omu nẽ mẽ kot krĩja grành par mã ajamaxpẽr kurê kumrẽx. ");
INSERT INTO apnNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Koja mẽ ã amnhĩ nhĩpêx anẽ ka mẽ amỳm amnhĩ wỳr mẽ omu hãmri nẽ ajapôj nẽ ma aprõt nẽ amrar kurê kumrẽx. Mẽ apê jar pika pê Jutej kamã mẽ apa xwỳnhjaja ka mẽ omu nẽ mẽ kot mẽ apar pymaj ma aprõt nẽ amrar kurê kumrẽx. Hixêt prêk wỳr ajapôj nẽ aprõt nẽ ma mra. —Nẽ kê Jerujarẽ nhõ xwỳnhjaja mẽ umaj haxwỳja hapôj nẽ ma hprõt nẽ ma mrar o mra. —Nẽ jar kapôt ã ri mẽ pa xwỳnhjaja kê mẽ akupỹm krĩ hwỳr gjêx kêt nẽ. Ãm ma mẽ umaj hprõt nẽ mrar kurê kumrẽx. ");
INSERT INTO apnNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","—Mẽ kot amnhĩ tomnuj mỳrapê koja Tĩrtũm ã mẽ hwỳr mẽ kãm mẽ hkurê xwỳnhjê rẽnh anẽ. Kapẽr ã kagà htũm ra kot mẽ hkukamã ja jarẽnh kot anhỹr. Jakamã koja mẽ nhỹrmã mẽ hkukamã mẽ harẽnh xàja kôt ã mẽ hipêx anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","—No mẽ htujarô xwỳnhjaja nẽ mẽ hkra karàre xwỳnhjaja koja mẽ kêp mẽmoj omnuj tỳx nẽ. Tanhmã kot mẽ amnhĩ to nẽ hprõt tỳx? Nà pika ja kamã koja mẽ piitã mex kêt nẽ. Mẽ kot amnhĩ tomnuj mỳrapê koja Tĩrtũm ã mẽ hipêx anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Koja mẽ nhỹhỹnh krĩ hõ rũm mẽ hwỳr mra nẽ mẽ unê nẽ mẽ hkamnhwỳr o mẽ kupa. Nẽ mẽ hkwỳjê pynê nẽ ma nhỹhỹm ahpỹnhã mẽ õ pika hwỳr amnhĩ kôt mẽ o pa nhũm mẽ kamã mẽ hkôt pa ho pa. Koja mẽ kêp Ijaew kêt xwỳnhjaja Jerujarẽ o amnhĩptà nẽ ã mẽ hipêx anẽ. Nẽ kamã pa ho pa rãhã nhũm Tĩrtũm nhỹrmã akupỹm nê mẽ kator pa. Tã koja mẽ nê mẽ kator parja o pa ra akupỹn mẽ awỳr inhnojarêt. Anẽ. Nhũm pre ã Jejus mẽ kãm mẽ kot Jerujarẽ grành par xwỳnhjê hkukamã harẽnh anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Nhũm Jejus arĩ hkôt mẽ pa ho pa xwỳnhjê mã kapẽr nẽ mẽ kãm: —Nẽ kot paj nhỹrmã akupỹn mẽ awỳr inhnojarêt nhũm kaxkwa kamã kanhêti nẽ myyti nẽ mytwrỳre axtem tanhmã ri amnhĩ nhĩpêx to. Nhũm gô xujanãr haxwỳja hkoko htỳx jao axpẽn tak tỳx nẽ. Hãmri nhũm pika piitã hkôt mẽ pa xwỳnhjaja kuma nẽ omu nẽ nẽ kãm ma htỳx nẽ mur nẽ htertet nẽ tee ri amnhĩ kukamã hamaxpẽr. ");
INSERT INTO apnNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","—Nẽ koja Tĩrtũm tanhmã kaxkwa ho àk to nhũm kanhêti piitã pikarêr pa. Hãmri nhũm pika hkôt ri mẽ pa xwỳnhjaja omu nẽ tee ri amnhĩ kukamã hamaxpẽr o amnhĩ japrãr pa nẽ hikwỹ. ");
INSERT INTO apnNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","28","Koja ã mẽmoj amnhĩ nhĩpêx anẽ ka mẽ ja hã omu nẽ akupỹn mẽ awỳr inhnojarêt mã ajamaxpẽr kurê kumrẽx. Hãmri nẽ mẽ kot ixkôt amnhĩ xunhwỳr kêt xwỳnhjê rom akĩnh kãm ijapêr arĩt o akuhê. —Nà kot paj akupỹn mẽ awỳr wrỳ. Kakrã kamã hirã htỳx kãm akupỹn ixihtỳx kãm mẽ awỳr wrỳ. Hãmri ka mẽ apiitã pika piitã hkôt ano ho ixpumu. Kot paj ã ixwrỳk anẽ hãmri nẽ mẽmoj punuj piitã pê mẽ apytàr pa. Jakamã ka mẽ ã mẽmoj kot amnhĩ nhĩpêx anhỹrja ã omu hãmri nẽ tokyx ixkôt axàpirta mã ajamaxpẽr nẽ akĩnh tỳx nẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","—E ga mẽ pĩ hpàr mũj pumu. ");
INSERT INTO apnNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Na hte mẽmo mytwrỳ hã rã nhũm mẽ omu nẽ ô hkukamã hamaxpẽr. ");
INSERT INTO apnNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Ja pyrà nẽ koja ã mẽmoj amnhĩ nhĩpêx par anhỹr mẽ ka mẽ omu nẽ akupỹn mẽ awỳr ixwrỳkja mã ajamaxpẽr kurê kumrẽx. ");
INSERT INTO apnNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Koja akupỹn ixpôx kêt ri mẽ kot ã mẽmoj kot amnhĩ nhĩpêx anhỹr pumunh xwỳnhjaja kormã piitã htyk kêt ri pa ra akupỹn wrỳ. ");
INSERT INTO apnNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","—Nẽ koja nhỹrmã pika nẽ kaxkwa wa hapêx pa. Tã no ãm ixkapẽr koja wa uràk nẽ aa hapêx kêt nẽ. Koja ãm rãhã ho rãhã. Kot paj aa ihkjê ho tanhmã mẽnh to hkêt nẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","35","—Nẽ kwa mẽ o kora. Mẽ axkãm ajamak rom. Mẽ kot ixkôt amnhĩ xunhwỳr kêt xwỳnhjaja na htem kãm tanhmã amnhĩ nhĩpêx to hprãm xà hkôt pix mã tanhmã amnhĩ nhĩpêx to ho ri pa. Jao ãm amnhĩ xàpkur xà nẽ amnhĩ to mex xà nẽ kàxpore pix kukamã hamaxpẽr o pa. Nẽ htỳx ri tanhmã amnhĩ tomnuj to ho pa. Nẽ pipãnh kãm tanhmã amnhĩ to ho pa. Tã koja mẽ ã amnhĩ nhĩpêx anhỹr o pa rãhã pa ra mẽ haêr pê akupỹn wrỳ nhũm mẽ tee ri ixpumu nẽ kãm ma htỳx kumrẽx. Te tutre htỳx ri harôj kajyr o pa nẽ rapuuti hwỳr àr nhũm kot haê nẽ unênh nhũm tee kãm kator prãm pyràk. Koja mẽ ã amnhĩ nhĩpêx anẽ. Nom kêr ka mẽ ho mẽ uràk kêt nẽ. Ãm pa inhmã hprãm xà hkôt pix mã tanhmã inhmã amnhĩ nhĩpêx to rãhã ho ri apa. ");
INSERT INTO apnNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","—Tã kêr ka mẽ ã mẽ kot amnhĩ tomnuj o pa anhỹrja kôt amnhĩ nhĩpêx o apa pymaj amnhĩ to Tĩrtũm wỳr rãhã ho apa. Kê tanhmã mẽ ato hihtỳx to ka mẽ ỹ hã ho mẽ uràk kêt nẽ. Kêr pa nhỹrmã akupỹn wrỳ ka mẽ ixpumu nẽ mẽ kurom amnhĩ kamã akahak kêt nẽ akĩnh tỳx nẽ man ixwỳr mra. Anẽ. Nhũm pre ã Jejus hkôt mẽ pa ho mẽ pa xwỳnhjê jahkre anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Hãmri nẽ apkati mẽ Tĩrtũm mã amnhĩ jarẽnh xà hã ixkre kamã mẽ pikuprõnh xwỳnhjê jahkre ho hkrĩ. Nhũm kamàt nhũm hkôt mẽ pa ho mẽ pa xwỳnhjê mẽ mẽ krĩ rũm hapôj nẽ ma hixêt prêk pê Oriwêhti hwỳr mra nẽ kamã amnhĩm hikra nẽ hikwỹ. ");
INSERT INTO apnNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Nhũm kwỳhtã nhũm mẽ kànhmã hkrĩ nẽ ma akupỹm krĩm mra nẽ ixkreja wỳr agjê. Hãmri nhũm mẽ piitã hã akuprõ nẽ kot mẽ ahkre hã mar o hkrĩ. ");
INSERT INTO apnNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Tã nhũm Ijaew kĩnhã arĩgro pê Pasja àhtêp o mõ. Pas ã na htem amnepêm Tĩrtũm kot pika pê Ejit pê mẽ hpãmjê kator mã hamaxpẽr kaxyw axpẽn wỳr akuprõ nẽ hã hkĩnh. Na htem arĩgroja jarẽnh o: “Pas” anhỹr ã harẽ. Nẽ mããnẽn harẽnh o: “Mẽ pahte pãw kaxkrit kêt kur ã arĩgro.” Anhỹr o harẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Jakamã nhũm mẽ õ patre krãhtũmjê mẽ Tĩrtũm kapẽr tũm o mẽ ahkre xwỳnhjaja ra kãm Jejus pĩr prãm nẽ. No mẽ kãm hkôt mẽ kot kapẽr mar xwỳnhjê pyma nẽ. Nẽ tee ri kot tanhmã ho hkukamã hamaxpẽr nẽ axpẽn mã: —Hêxta waa nẽ. Kwa tanhmã kot puj wem ho nẽ mẽ kêp kupĩ? Kot puj mẽ noo mã tanhmã ho nhũm mẽ hã mẽ pakamã gryk tỳx kumrẽx. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","4","Tã nhũm Jut Kariotja. Jejus nhỹ hã mẽ ahkre ho pa xwỳnh pê 12 hõ na pre. Tã axtem nẽ tanhmã hamaxpẽr to nẽ Satanasti nhỹ hã ma mẽ õ patre krãhtũm mẽ Tĩrtũm mã amnhĩ jarẽnh xà hã ixkre jamãr xwỳnh krãhtũmjê hwỳr tẽ. Hãmri nẽ tanhmã Jejus o mẽ mar to nẽ mẽ kãm: —E ot pa mẽ amã Jejus jarẽnh o tẽ. Xà kot paj mẽ amã hã amỹnê ka mẽ hpãnhã inhmã amnhĩre nà? Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Hãmri nhũm mẽ kuma nẽ hkĩnh nẽ. Hãmri nẽ kãm: —Nà kot paj mẽ amã amnhĩre. ");
INSERT INTO apnNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Hãmri nhũm mẽ kot kãm amnhĩrer ã harẽnh ma nẽ hkĩnh nẽ mẽ kãm: —Tôe. Nà kot paj mẽ amã ho anẽ. Anẽ. Hãmri nẽ ma tẽ nẽ kato. Nẽ Jejus pynênh kaxyw htãnopxar o ri hkôt pa. Mẽ kot mar o pa xwỳnhjê hkàx ã nhỹri unênh nẽ ma mẽ hwỳr o htẽm kaxyw. ");
INSERT INTO apnNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Tã nhũm Pasja kato. Amnepêm Ijaewjê nhĩgêtjaja na prem ôwêhti hkrare hkwỳ hpar o pa. Tĩrtũm kot ja hã mẽ omunh nẽ Ejit kãm mẽ kãm mẽ hkurê xwỳnhjê nhĩhkra nê mẽ kator kaxyw nhũm prem ã amnhĩ nhĩpêx anẽ. Jakamã na htem arĩ mẽ kêp mẽ hkanrẽhã mẽ htàmnhwỳjaja arĩgro pê Pas ã axpẽn wỳr akuprõ nẽ mẽ kãm hamaxpẽr pê mẽ uràk nẽ ôwêhti hkrare hkwỳ hpa. Hãmri nẽ pãwti kaxkrit kêt kãm kuku. ");
INSERT INTO apnNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Jakamã nhũm Jejus ỹ hã mẽ ahkre ho mẽ pa xwỳnhjê wa ho axkrut nẽ mẽ amnhĩ kukamã wa kumẽ. Simãw Pêtre mẽ Juãwja nhũm wa mẽ amnhĩ kukamã wa kumẽ nẽ wa kãm: —E wa ma mẽ ixkukamã tẽ nẽ mẽ ixkutêp Pas ã mẽ panhõ hã apê. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Hãmri nhũm wa kuma hãmri nẽ kãm: —Tôe. Nhỹri kot paj we wa tẽ nẽ mẽ akutêp hã apê? Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Hãmri nhũm wa kãm: —Nà wa mãmrĩ ma Jerujarẽ hwỳr wa tẽ. Nẽ hwỳr axà nẽ mẽhõ mytita pumunh kurê kumrẽx. Nhũm amnhĩm gô ru nẽ amnhĩ kre hã poti xãm nẽ o tẽ. Ka wa omu nẽ hã ajêt nẽ ma hkôt õrkwỹ hwỳr tẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Hãmri nẽ ixkre nhõ dõn pumu nẽ kãm: “E jar na pa wa awỳr tẽ. Jejus na wa inhmẽ pa wa awỳr tẽ. Na awỳr pẽr mẽnh o: ‘Nhỹri kot paj ixkôt ri mẽ pa ho mẽ pa xwỳnhjê mẽ axpẽn kutã Pas ã apku?’ Anẽ. Na ã awỳr hpẽr mẽnh anẽ.” Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","—E ã kãm akapẽr anẽ kê war ama nẽ ra war amã õrkwỹ nhĩmõk ã ixkre rax õ jahkre. Kamã ra kaxyw mẽ paxàpkur xà hã mẽmoj piitãã. Ka wa omu hãmri nẽ mãmrĩ mẽ ixkutêp kamã mẽmoj tã apê. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Hãmri nhũm wa kuma nẽ ma krĩm tẽ. Ma tẽ nẽ hwỳr axà hãmri nẽ ra kot wa kãm mẽmoj jarẽnh xà hkôt mẽmoj piitã omu hãmri nẽ mẽ kutêp mẽõ hã àpênh o wa xa. ");
INSERT INTO apnNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Tã nhũm myt axà nhũm mẽ wa hkôt mõ nẽ ixkreta wỳr àpir pa. Hãmri nẽ apkur kaxyw hkrĩ hpa nhũm Jejus mẽ ĩhkô hã nhỹ. ");
INSERT INTO apnNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Hãmri nẽ mẽ kãm tanhmã amnhĩ jarẽnh to nẽ mẽ kãm: —E na pa inhmã Pas ã mẽ anhĩhkô hã ixàpkur prãm nẽ. Kormã ixte amnhĩ xà htỳx kãm ijamak xwỳj ri. ");
INSERT INTO apnNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Kwa mẽ inhma. Kot paj axte mẽ akutã Pas ã ixàpkur kêt ry rax nẽ. Nom koja nhỹrmã Tĩrtũm akupỹn ixte mẽ ato amnhĩptàr kaxyw inhmẽ hãmri pu mẽ rĩ kormã axte arĩgro mex maatija ã pahkĩnh kãm axpẽn kutã paxàpkur rax nẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Nhũm ã mẽ kãm amnhĩ jarẽnh anẽ nẽ hpãnhã wĩhti py nẽ o xa nẽ Tĩrtũm mã harẽ nẽ kãm: —Pa Papaj. Nà ãm hãmri na ka hte mẽ inhnê mẽ kãm mẽ ixkurê xwỳnhjê pumunh mex nẽ mẽ ĩhkra pê mẽ ijapôj. Amex o amex. Anẽ. Hãmri nẽ hpãnhã hkôt mẽ pa ho mẽ pa xwỳnhjê hõ mã kugõ nẽ kãm: —E mĩ. Apy nẽ mẽ axpẽn pãnhã hkwỳ ho ixkõ. ");
INSERT INTO apnNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","ãm hãmri na pa mẽ amã amnhĩ jarẽ. Kot paj axte wĩhti ho ixkõm kêt rãhã nhũm nhỹrmã Inhõ Papaj akupỹn mẽ awỳr inhmẽ. Hãmri pu mẽ rĩ kormã akupỹn ixpôx xà hã arĩgrota ã pahkĩnh rax nẽ. No ãm ra axtem tanhmã hã mẽ pahkĩnh to. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Hãmri nẽ hpãnhã pãwti py nẽ mã ho anẽ nẽ Tĩrtũm mã harẽ. Hãmri nẽ ho hkry hpa nẽ mẽ piitã mẽ kãm õr pa nẽ mẽ kãm: —E na pa ã pãwti ho hkry nẽ mẽ amã õr anẽ. Koja mẽ ã inhĩpêx anẽ nẽ te mẽ kot ixto hkry hpar pyràk o inhĩpêx pa amnhĩ xà htỳx kamã ijamak kãm ty. Nom mẽ anê kot paj ty. Jakamã kêr ka mẽ ixwakre kamã tõhã axpẽn wỳr akuprõ nẽ ixte mẽ ate amnhĩ tomnuj pãnhã amnhĩrer kaxyw mẽ anê ixtykja mã ajamaxpẽr pê akĩnh nẽ pãwti hkur o akrĩ. E mẽ mãmrĩ axàmnhĩx aku. Anẽ. Nhũm pre ã mẽ kãm amnhĩ jarẽnh anẽ nhũm mẽ mar pê pãwtita hkur o hkrĩ. ");
INSERT INTO apnNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Hãmri nẽ ra hkur pa. Hãmri nhũm Jejus axte kopta py nẽ mẽ kãm: —Mẽ kot ixpĩr xà hã arĩgro hã koja ixkamrô axkapĩ. Nom koja mẽ amarĩ ixpĩr nhũm ixkamrô amarĩ hpikapĩr kêt nẽ. Ãm paa. Pa kot paj mẽ anê mẽ ĩhkram amnhĩ jaxà nhũm mẽ ã inhĩpêx anẽ. Koja ixkamrô axkapĩ nhũm Tĩrtũm omu nẽ ixkukwak ri mẽ anê mẽ ate amnhĩ tomnuj piitã te amnhĩ katut kôt rẽnh par pyràk o hipêx nẽ mẽ ato hkra. Amnepêm kot ja hã amnhĩ jarẽnh xà hkôt. Jakamã e mẽ ixkamrô pikapĩrta mã ajamaxpẽr pê wĩhti hkwỳ ho ixkõ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Nhũm Jejus arĩ mẽ kãm kapẽr nẽ mẽ kãm: —Nẽ kot mẽ kãm ixtã àmnênh mã xwỳnhta na jar mẽ pahkaêx ã mẽ pakutã apkur o nhỹ. ");
INSERT INTO apnNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Tĩrtũm kãm hprãm xà hkôt koja mẽ tanhmã ixto rax nẽ ixpĩ. Nom kot mẽ kãm ixtã àmnênh mã xwỳnhta hêxta waa nẽ. Ã kot inhĩpêx anhỹrja mỳrapê koja amnhĩ xà htỳx kãm hamak rax kumrẽx. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Nhũm pre ã Jejus mẽ kãm amnhĩ jarẽnh anẽ. Nhũm mẽ kuma nẽ tee ri axpẽn pumunh o hkrĩ. Hãmri nẽ ri axpẽn kukja nẽ axpẽn mã: —Kwa nà mẽ pahtõ kot pu we ã ri hipêx anẽ? Nà pa hkêt. Anhỹr o tee ri axpẽn kukjêr o hkrĩ. ");
INSERT INTO apnNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Tã nhũm Jejus nhỹ hã mẽ ahkre ho mẽ pa xwỳnhjaja axpẽn mã tanhmã kapẽr to ho hkrĩ nẽ axpẽn mã: —Kwa mẽ pahtõ kot puj wem nhỹrmã pahpê pahi nẽ mẽ ho amnhĩptàr rax o ri papa? Anẽ. Hãmri nẽ mẽ axpẽn mã: “Nà pa.” Anẽ nẽ nhãnh axpẽn mã: “Nà kêt paa.” Anẽ. Hãmri nhũm mẽ nẽtãnh axpẽn mã: “Nà kêt pa kênã.” ");
INSERT INTO apnNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Anhỹr o axpẽn mã kapẽr o hkrĩ. Hãmri nhũm Jejus tee ri axpẽn tã mẽ kuma nhũm mẽ ã hamaxpẽr anhỹrja kêp omnuj nẽ nhũm mẽ kãm tanhmã hã kapẽr to nẽ mẽ kãm: —E mẽ inhma. Na hte Ijaew kêt xwỳnhjê nhõ pahijaja ã amnhĩ nhĩpêx anhỹr o ri pa nẽ amarĩ hkrĩ xà kamã hkrĩ ho hkrĩ. àhpumunh tỳx jakamã na htem amarĩ ixkre hkre jakry kamã kãm mẽ àpênh xwỳnhjê mã mẽmo mẽ àpênh ã karõ ho hkrĩ. Na htem ã amnhĩ nhĩpêx anhỹr o pa. Nẽ mẽ kot amnhĩm mex ã harẽnh kaxyw tanhmã mẽ ho mex to ho pa. ");
INSERT INTO apnNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","27","Tã kêr ka mẽ ho mẽ uràk kêt nẽ. Kêt ãm te amarĩ ri mẽ apa xwỳnh pyràk o axpẽn nhĩpêx. Ixpyrà nẽ amarĩ mẽmoj to mẽ kutã anojarêt rãhã ho ri apa. No mẽ ate mẽ ho amnhĩptàr rax kukamã ajamaxpẽr kêt nẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Na prem axpẽn mã ixto hêx nẽ tanhmã ixto kapẽr punuj to htã ka mẽ ama nẽ ãm mẽ ama nẽ arĩ ixkôt ri apa rãhã nẽ. Ãm hãmri na ka htem arĩ ixkôt ri apa anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","30","Kot paj amnhĩ tã mẽ ato mex rax nẽ. Na pre ra Tĩrtũm nhỹrmã ixte mẽ ato amnhĩptàr o ixkrĩ kaxyw ixãm. Tã ot pa amnhĩ pyrà nẽ mẽ pahkwỳ Ijaew kaxyw mẽ axunhwỳ ka mẽ nhỹrmã mẽ piitã mẽ ho amnhĩptàr o apa. Nẽ mẽ apê ixkràmnhwỳ hã nhỹrmã ixkutã axàpkur o apa. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Tã nhũm Jejus Simãw Pêtre mã kapẽr nẽ kãm: —Kwa Simãw. Na Satanasti kãm hprĩ hã ixtã mẽ apiitã mẽ kamã hamak prãm nẽ. Tanhmã kot mẽ akrã hto nhũm mẽ ate mẽ kãm ixkurê xwỳnhjê pumaj ixkaga hã kãm mẽ akamã hamak prãm tỳx nẽ. Jakamã ã kot mẽ anhĩpêx anhỹr kaxyw na pre ra amnhĩ to Inhõ Papaj ma nhũm kãm: “Tôe. Kam nẽ mãmrĩ tanhmã mẽ kamã ajamak to.” Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","—Tã ate mẽ umaj ixkaga nẽ axte ate amnhĩ kaxyw inhmã ajamaxpẽr kêt pymaj na pa ra ato Inhõ Papaj wỳr kãm ixihtỳx nẽ Simãw Pêtre. Jakamã kêr ka mẽmo arĩgro hã tee ri ixkaga hã amnhĩ pumu hãmri nẽ tokyx tãm akupỹm ixkôt amnhĩ xãm tỳx nẽ. Kêr kê nhỹrmã akwỳjê hõ tanhmã amnhĩ tomnuj to nẽ tee ri amnhĩ kukamã hamaxpẽr ka ja hã omu hãmri nẽ kãm ate tanhmã amnhĩ tomnuj tota jarẽ. Kê mẽ ã ate amnhĩ nhĩpêx anhỹr ã ajarẽnh ma nẽ apyrà nẽ tokyx akupỹm tãm ixkôt amnhĩ xãm tỳx kurê kumrẽx. E kêr ka ã akupỹm ixkôt mẽ piitã mẽ hipêx anhỹr o ri apa Simãw Pêtre. Anẽ. Nhũm pre ã Simãw Pêtre kot tanhmã amnhĩ nhĩpêx to hkukamã kãm ujarẽnh anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Hãmri nhũm tee ri amnhĩ tã kuma nẽ kãm: —Kwa nà Pahihti. Kot paj ri akwỳm tanhmã amnhĩ tomnuj to hkêt nẽ. Koja mẽ te ajaxà nẽ apĩ htã kot paj arĩ akôt ri ixpa ho ixpa nhũm mẽ pahto amỹrà nẽ tanhmã pahto. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Hãmri nhũm kuma nẽ kãm: —Nà koja apkati hkôt krãhyre hkàr kêt ri ka ra mẽ umaj ate ixkôt apa hkêt ã mẽ kãm amnhĩ tã axàprãr o axkrunẽpxi kãm ga. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Hãmri nhũm Jejus arĩ hkôt mẽ pa ho pa xwỳnhjê mã kapẽr nẽ mẽ kãm: —E wam ixte mẽ hwỳr mẽ arẽnhta ã na ka prem amnhĩ kôt aparkà hkwỳ ho apa hkêt nẽ. Nẽ kawà jamành nẽ ho apa hkêt nẽ. Nẽ mrykà jamành nẽ amnhĩ kôt ho apa hkêt nẽ. Ãm mẽ anhỹ kamã mẽ hwỳr apa hã na pa pre mẽ amã karõ. Tã xàn ka prem ã mẽ hwỳr apa anẽ nhũm mẽ amnhĩ wỳr awỳr kêt nẽ? Nà xà na prem amnhĩ wỳr mẽ awỳ? Anẽ. Hãmri nhũm mẽ kãm: —Tỳ na prem amnhĩ wỳr mẽ ixwỳ. Mẽ ixte amnhĩ kôt mẽmoj to ixpa hkêt tã na pa prem amarĩ mẽ kutã ixàpkur mex o ri mẽ hkôt ixpa. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","37","Hãmri nhũm mẽ kãm: —Tôe. Nà mẽ kot mẽ ato mex tã nom koja mẽ hpãnhã axtem hõ ho mẽ anhĩpêx. Jakamã kêr ka mẽ akupỹm mẽ kãm ijarẽnh o apa kaxyw anojarêt hãmri nẽ anhõ mrykà rỳ akawà htu nẽ ma amnhĩ kôt ho apa. Nẽ awapo. Kot kaj mẽ awapo hkêt japêr hãmri nẽ apipro xà ho wẽnê nẽ amnhĩm hõ japrô nẽ ma amnhĩ kôt ho apa. E kêr ka mẽ ã amnhĩ nhĩpêx anẽ. —Nẽ Tĩrtũm kapẽr ã kagà htũm kot ra ixkukamã tanhmã ijarẽnh to nẽ kot ijarẽnh kot: Koja mẽ hipêx o te mẽ kot amnhĩ tomnuj tỳx xwỳnh nhĩpêx pyràk. Anẽ. Ã mẽ kot inhĩpêx anhỹr kukamã ijarẽnh kot anhỹr. Tã na mẽ ra ã inhĩpêx anhỹr kaxyw. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Nhũm pre ã Jejus mẽ kãm kapẽr anẽ nhũm mẽ kuma nẽ kãm: —Ota mẽ panhõ wapohti hamẽxkrut Pahihti. Anẽ. Hãmri nhũm mẽ kãm: —Tôe. Nà hãmri. Mẽ amnhĩm axi nẽ ho amnhĩm mẽmoj to anẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Tã nhũm Jejus kê axte krĩja rũm kato nẽ hixêt pê Oriwêhti hwỳr tẽ nẽ api nhũm hkôt mẽ pa ho mẽ pa xwỳnhjaja ma hkôt mra. ");
INSERT INTO apnNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Hãmri nẽ nhỹri hixêt kahti ri hkrĩ nhũm Jejus mẽ kãm: —E kwa kêr ka mẽ ixkutêp amnhĩ to Inhõ Papaj wỳr o akrĩ. Kê mẽ ixkôt tanhmã mẽ ato htã ka mẽ amã mẽ uma xàj ixkaga hkêt nẽ. Arĩ mẽ kutã amnhĩ to htỳx nẽ akuhê. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Hãmri nẽ mẽ kurũm htẽm grire nẽ Tĩrtũm mã amnhĩ jarẽnh kaxyw hkõn krã ho tẽm nẽ nhỹ. ");
INSERT INTO apnNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Hãmri nẽ kãm: —Kwa Papaj. Nà na pa ra amnhĩ xà htỳx kukamã ijamaxpẽr nẽ amnhĩ kamã ixkahak tỳx kumrẽx. Inhmã amnhĩ xà kamã ijamak prãm kêt o ijamak prãm kêt. Jakamã kot kaj amã inhnê ho ajapêx prãm nẽ mãmrĩ inhnê ho ajapêx nhũm mẽ kãm ixkurê xwỳnhjaja tanhmã ixto hkêt nẽ. Rỳ ko. Kot kaj amã mẽ kot tanhmã ixto hprãm hã kê mẽ mãmrĩ tanhmã inhĩpêx to. Nom pam inhmã hprãm xà hkôt kêt. Anẽ. Nhũm pre ã Jejus amnhĩ to Hipêêxà Tĩrtũm wỳr anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Hãmri nhũm kuma nẽ hwỳr kapẽr o wrỳk xwỳnhja mẽ nhũm hwỳr wrỳ nẽ kuri xa. Hãmri nẽ õxàhkre kaxwỳnh kãm tanhmã ho hihtỳx to. ");
INSERT INTO apnNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Nhũm kê axte amnhĩ to Hipêêxà hwỳr kãm hihtỳx nẽ. Tee ri amnhĩ kukamã hamaxpẽr pê amnhĩ kamã kahak tỳx kumrẽx. Jao hã gô rax nẽ te hkamrô xàhàr pyràk o pikap ahà. ");
INSERT INTO apnNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Hãmri nẽ kànhmã xa nẽ akupỹm hkôt mẽ pa ho mẽ pa xwỳnhjê hwỳr tẽ nẽ mẽ omu nhũm mẽ ra õt pa nẽ hikwỹ. Mẽ kot tee ri Jejus kot mẽ kãm amnhĩ jarẽnhja kukamã hamaxpẽr o hkaprĩ nẽ õt pa nẽ hikwỹ. ");
INSERT INTO apnNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Hãmri nhũm Jejus tẽ nẽ tee ri mẽ omu nẽ mẽ kumra nẽ mẽ kãm: —Kwa nà. Mẽ ri ã amnhĩ nhĩpêx anhỹr kêt nẽ. Kwa mẽ kànhmã akrĩ nẽ amnhĩ to Inhõ Papaj wỳ kê mẽ ato mẽ axihtỳx. Hãmri nhũm mẽ tanhmã ixkôt mẽ ato ka mẽ inhỹ hã mẽ kutã amnhĩ to htỳx nẽ akuhê. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Nhũm pre ã Jejus mẽ kãm kapẽr anhỹr rôm nhũm hkôt pa ho pa xwỳnh pê Jut Kariotja amnhĩ kôt mẽ kot Jejus pynênh xwỳnhjê ho tẽ. Mẽ ho htẽm rax nẽ. Hãmri nẽ kot Jejus kahti hkôt mỳnh kaxyw hwỳr tẽ ");
INSERT INTO apnNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","nhũm amnhĩ tã omu nẽ kãm: —Kwa Jut. Xà mẽ kahti hkôt mẽ hamỳnh nẽ mẽ hpãr o na htem mẽ kãm mẽ hã amỹnê? Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Hãmri nhũm hkôt mẽ pa ho mẽ pa xwỳnhjê hõja tee ri mẽ kot amnhĩ nhĩpêx ã mẽ omu hãmri mẽ õ wapota mã hamaxpẽr kurê kumrẽx nẽ Jejus mã: —Kwa Pahihti. Xà kot paj mẽ panhõ wapohti py nẽ ho mẽ panê mẽ hkwỳ hpa? Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Hãmri nhũm hõta kuma nẽ mẽ kaxyw ja kapa. Nhũm mẽ õ patre maati mã àpênh xwỳnhja mẽ hkôt tẽ nhũm omu nẽ kãm wapo ho apê. Nẽ kot ho hkrã nhĩpônh mã tã kuhpaw nẽ ho upôk rũm hamak nhĩkjê pix krãhta. ");
INSERT INTO apnNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Hãmri nhũm Jejus omu nẽ nê kãm kapẽr nẽ kãm: —Kwa nà ri ã amnhĩ nhĩpêx anhỹr kêt nẽ. Amarĩ xa. Anẽ. Hãmri nẽ hamakja py nẽ akupỹm kãm hamak ã kuxi nẽ ho mex. ");
INSERT INTO apnNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","53","Hãmri nẽ mẽ kot unênh mã xwỳnhjê mã tanhmã kapẽr to. Mẽ õ patre krãhtũmjê mẽ Tĩrtũm mã amnhĩ jarẽnh xà hã ixkre jamãr xwỳnhjê krãhtũm mẽ Ijaew nhõ pahijê mẽ nhũm mẽ ho pimrààtã mẽ kãm kapẽr nẽ mẽ kãm: —Kwa na pa pre apkati mẽ Tĩrtũm nhõrkwỹ kamã mẽ kãm ixkapẽr o ixpa ka prem tokyx ixpynênh kêt tã jarãhã te ixte amnhĩ tomnuj xwỳnh pyràk o inhĩpêx nẽ ixwỳr wapo nẽ kô hã akapẽn nẽ ixwỳr ã atẽm rax anẽ. No ãm ra mẽ ate tanhmã ixto kaxyw arĩgro kator kênã. Jakamã kot kaj mẽ mãmrĩ tanhmã amã ixto hprãm xà hkôt mãmrĩ tanhmã ixto. Satanasti nhỹ hã ã mẽ ate inhĩpêx anhỹr mã kênã. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Tã nhũm mẽ Jejus pynê nẽ ma o tẽ. Ma mẽ õ patre maati nhõrkwỹ hwỳr o tẽ. Nhũm Simãw Pêtre ma hapu hã mẽ hkôt hã mẽ omunh o tẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Nhũm mẽ patre maati nhõrkwỹ hwỳr Jejus o axà nẽ hkôt gjêx pa hãmri nhũm Simãw Pêtre kĩtare hwỳr axà nẽ mẽ kuri xa. Nhũm mẽ kĩtare kamã amnhĩm kuto nẽ hã ànhunh o hkrĩ nhũm ");
INSERT INTO apnNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","mẽ ĩhkô hã ànhunh o nhỹ. Hãmri nhũm mẽ kãm àpênh xwỳnh niti hirã kamã hprĩ hã omunh kurê kumrẽx nẽ mẽ kãm: —Xê pẽr myti ja kêp Jejus kôt mẽ pa ho mẽ pa xwỳnhjê hõ na. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Hãmri nhũm tee ri amnhĩ tã kuma nẽ kãm mẽ uma nẽ mẽ kãm amnhĩ tã aprã nẽ kãm: —Tk. Kokỹ. Ixte mẽhõ my ata pumunhre hã. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Tã nhũm hpãnhã mẽhõ myja kãm: —Kwa nà. Ãm hãmri na ajarẽ. Apê Jejus kôt ri mẽ pa xwỳnhjê hõ na ka. Anẽ nhũm kuma nẽ kê axte kãm: —Kwa mẽ ri ã amnhĩ krã hkôt ri ixto axêx anhỹr kêt nẽ. Ãm ixte aa mẽhõta pumunh kêt kumrẽx. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Tã nhũm ja haxwỳja axte omu nẽ kãm: —Kwa ãm hãmri na mẽ ajarẽ. Apê Jejus kwỳ hõ na ka. Uràk nẽ te apê Garirej nhõ xwỳnh pyràk kênã. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Hãmri nhũm tee ri kuma nẽ mẽ kãm amnhĩ tã àprãr kãm hihtỳx nẽ mẽ kãm: —Tk. Ixpê Garirej nhõ xwỳnh kêt. Ãm ixte mẽhõ mũj pumunh kêt kumrẽx tã ka mẽ ãm xatã hkôt ixpa ho ixpa xwỳnh ã ixkamnhĩx o akuhê. Anhỹrja o ra mẽ kãm amnhĩ tã aprãr o axkrunẽpxi mẽ nhũm krãhyre kà. ");
INSERT INTO apnNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Hãmri nhũm Jejus arĩ ixkre kamã ãm tã Simãw Pêtre ho hakẽx nẽ omu. Hãmri nhũm amnhĩ tã no pumu nẽ kot hkukamã kãm ã amnhĩ nhĩpêx anhỹr jarẽnhja mã hamaxpẽr kurê kumrẽx. Krãhyre hkàr kêt ri kot mẽ kãm amnhĩ tã àprãr o axkrunẽpxi hã harẽnhja mã hamaxpẽr nẽ kànhmã hakry hpar o tẽ nẽ hkaprĩ htỳx nẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Hãmri nẽ hkaprĩ xàj kĩtare pê kato nẽ tẽ nẽ awry hã xa nẽ mỳr rax kumrẽx. ");
INSERT INTO apnNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Hãmri nhũm mẽ kot Jejus pumunh o kuhê xwỳnhjaja hã hpẽr o axkẽ nẽ htak o kuhê. ");
INSERT INTO apnNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Nẽ no hpro nẽ htak nẽ kãm: —E atak xwỳnh nhĩxi jarẽ. Apê Tĩrtũm Kra hã ate amnhĩ jarẽnh jakamã mãn uràk nẽ axàhpumunh tỳx. Jakamã e hixi jarẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Hãmri nẽ xatã haprỳ nẽ kãm kapẽr punuj nẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Tã nhũm myt kator o mõr mẽ nhũm Ijaew nhõ pahijê mẽ patre krãhtũmjê mẽ Tĩrtũm kapẽr tũm o mẽ ahkre xwỳnhjaja axpẽn wỳr pikuprõnh pa. Hãmri nhũm mẽ ma mẽ hwỳr Jejus o tẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","68","Nhũm mẽ omu nẽ tanhmã kot amnhĩ jarẽnh to hã hkukja nẽ kãm: —Kwa mẽ inhmã amnhĩ jarẽ. Xà ka na apê Tĩrtũm kot mẽ ixkaxyw axãm xwỳnhta? Xà ka kot kaj Rõm nhõ xwỳnhjê pê mẽ ixpytà nẽ mẽ ixto amnhĩptàr o apa? Anẽ. Hãmri nhũm mẽ kãm: —Nà kot paj tanhmã mẽ amã amnhĩ jarẽnh to ka mẽ ixkôt ajamaxpẽr kêt nẽ. Ixte ãm hãmri mẽ amã amnhĩ jarẽnh tã ka mẽ inhma nẽ ãm inhma. Nẽ kot pa amnhĩ xwar mẽmoj tã mẽ akukja ka mẽ amnhĩ xwar inhmã tanhmã harẽnh to hkêt nẽ. Ãm mẽ axêx rom mẽ ate ã ixkukjêr anhỹr kênã. ");
INSERT INTO apnNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Tã nom kot paj tokyx ma akupỹm Inhĩpêêxà Tĩrtũm wỳr api. Hihtỳx o hihtỳx rãhã nẽ pa ho pa xwỳnh na. Jakamã kot paj hwỳr api nhũm amnhĩ nhĩhkô hã inhỹr pa upôk rũm mẽ apiitã mẽ ato amnhĩptàr o ixkrĩ. Hãmri nẽ nhỹrmã paa tanhmã mẽ ajarẽnh to. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Hãmri nhũm mẽ tee ri kot ã amnhĩ jarẽnh anhỹrja ma nẽ kãm: —Tk. Kwa akatàt kôt mẽ inhmã amnhĩ jarẽ nà. Xà apê Tĩrtũm Kra na ka? Anẽ. Hãmri nhũm mẽ kãm: —Tỳ ixpê Kra na pa. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Hãmri nhũm mẽ tee ri ã amnhĩ jarẽnh anhỹrja ã kuma nẽ axpẽn mã: —Kwa mo kaxyw kot puj mẽ axte mẽ hkwỳjê japêr nhũm mẽ tanhmã kot amnhĩ tomnuj to hã harẽ? Tãm kêp Tĩrtũm Kra hã amnhĩ to hêx nhũm mẽ pahte pahpiitã mar kênã. E kwa tokyx pu mẽ ma Rõm nhõ pahihti hwỳr o tẽ kê mẽ pamã hã amỹnê nẽ mẽ pamã kupĩ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Tã nhũm mẽ Jejus o kato nẽ nhãm Pahihti Pirat wỳr o tẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Hãmri nẽ kutã ãm nẽ tanhmã kãm ho hêx to nẽ kãm: —E ot pa mẽ awỳr jahti ho tẽ. Na hte mẽ inhmã hêx rũnh o pa. Mẽ ixte Pahihti Sesti kapẽr kwỳm ri amnhĩ nhĩpêx prãm xàj tanhmã mẽ inhmã mẽmoj tã karõ hto ho pa. Nẽ axtem nẽ mẽ ixte Sesti mã kàxpore hkwỳ nhõr kêt ã mẽ inhmã karõ. Nẽ Tĩrtũm kot mẽ pakaxyw kêp mẽ panhõ pahi hã ãm xwỳnh ã amnhĩ jarẽ. Ã na hte mẽ inhmã amnhĩ to hêx anhỹr o pa. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Hãmri nhũm Pirat mẽ kuma nẽ Jejus pumu nẽ kãm: —E kwa inhmã amnhĩ jarẽ. Xà apê Ijaew nhõ pahi na ka? Xà ka na htem amnhĩ wỳr akãm hamak o pa? Anẽ. Hãmri nhũm kãm: —Nà ãm hãmri na ka ã ijarẽnh anẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Hãmri nhũm Pirat tanhmã hkukjêr to nẽ tee ri kot amnhĩ jarẽnh ã kuma hãmri nẽ patre krãhtũmjê mã kãm: —Kwa mẽmo mỳrapê kot pa tanhmã mẽ amã hã ixàmnênh to? Kot tanhmã amnhĩ tomnuj tore hã. Nà kot pa kãm inhũre. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Hãmri nhũm mẽ tee ri kuma nẽ kot mẽ kãm hã àmnênh prãm xàj hã kãm kapẽr kãm hihtỳx nẽ. Nẽ kãm: —Kwa nà. Na pre hte pika pê Jutej kamã tanhmã mẽ kãm hêx to ho pa. Hãmri nhũm mẽ ra hã axpẽn kutã amnhĩ xunhwỳ nẽ hã pijapu rũnh o pa. Tã mããnẽn Garirej kamã ã amnhĩ nhĩpêx anhỹr o hkrax nẽ hpãnhã amnẽ mẽ pahwỳr ã amnhĩ nhĩpêx anhỹr kaxyw mõr anẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Hãmri nhũm Pahi Pirat mẽ kuma nẽ mẽ kãm: —Kwa xà kêp Garirej nhõ xwỳnh na? Anẽ. Hãmri nhũm mẽ kãm: —Tỳ. Kêp Garirej nhõ xwỳnh kênã. ");
INSERT INTO apnNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Anẽ nhũm mẽ kãm: —Tô mẽ ma pahihti Erox ãxipas wỳr mãn o tẽ. Kêp Garirej nhõ xwỳnhjê nhõ pahi na. Tã ra jar Jerujarẽ kamã ham pôj. No axtem ixpê Jutej kamã mẽ pa xwỳnhjê nhõ pahi jakamã kwa mẽ ma õ pahita wỳr mãn o tẽ kê tãm tanhmã mẽ amã ho. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Hãmri nhũm mẽ kuma nẽ ma pahi Erox ãxipas wỳr o tẽ. Na pre ra Erox ãxipasja xatã Jejus jarẽnh ma nẽ kãm omunh prãm nẽ. Kãm aa kot mẽmoj pumunh kêt õ ho anhỹr ã omunh prãm tỳx jakamã nhũm mẽ ma hwỳr o tẽ nhũm omu nẽ hkĩnh nẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Hãmri nẽ tee ri mẽmoj tã hkukja no nhũm akryk xa nẽ tanhmã kãm nẽ hkêt nẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Hãmri nhũm mẽ õ patre krãhtũmjê mẽ Tĩrtũm kapẽr tũm o mẽ ahkre xwỳnhjaja kãm ho kapẽr punuj nẽ ho hêx kãm hihtỳx nẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Hãmri nhũm pahi Erox ãxipas mẽ kuma hãmri nẽ õ pôristi mẽ wa kãm kapẽr punuj nẽ hã hpẽr o axkẽ nẽ tanhmã ri haprỳ to. Hãmri nẽ hã hpẽr o pikẽnh kãm kêp pahi hã mẽ ê mexja py nẽ kãm haxà nẽ akupỹm pahi Pirat wỳr kumẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Na pre Pahi Pirat mẽ Pahi Erox ãxipasja wa kãm axpẽn kĩnh kêt nẽ. Tã hãmri nhũm Erox ãxipasja tee ri Jejus kot kãm tanhmã amnhĩ jarẽnh to hã mar prãm xàj tee ri hkukamã hamaxpẽr hãmri nẽ Pirat ã hpijaàm kaxyw akupỹm hwỳr kumẽ. Hãmri nhũm amnhĩ tã omu hãmri nẽ wa ra akupỹm kãm axpẽn kĩnh nẽ. Nẽ akupỹm axpẽn mã hpẽr o axkẽ nẽ pikunhar o pa pê akupỹm axpẽn to hkràmnhwỳ. ");
INSERT INTO apnNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Tã nhũm Pirat akupỹm amnhĩ wỳr mẽ hã karõ. Ijaew kwỳjaja nẽ mẽ õ pahijaja nẽ mẽ õ patre krãhtũmjaja nhũm akupỹm amnhĩ wỳr mẽ piitã mẽ hã karõ. ");
INSERT INTO apnNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Hãmri nhũm mẽ akupỹm hwỳr gjêx pa nẽ kuhê nhũm mẽ kãm: —E na ka mẽ ixwỳr mytita o tẽ nẽ tanhmã inhmã harẽnh to. Kot mẽ akwỳjê mã tanhmã hêx to ho pa hã harẽ. Tã pa ra jar mẽ anoo mã tanhmã hkukjêr to nẽ tee ri kot inhmã tanhmã amnhĩ jarẽnh to hã kuma. Te kot amnhĩ to mex xwỳnh pyràk. Mẽ ate tanhmã ho akapẽr to htã nom kot anhỹr kêt. Kot amnhĩ to mex xwỳnh na. ");
INSERT INTO apnNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Pahi Eroxja ra ixpyrà nẽ tee ri tanhmã hkukjêr to nom nhũm tanhmã kãm nẽ hkêt nẽ. Nhũm tee ri ja hã omu nẽ akupỹn ixwỳr kumẽ. Jakamã kwa mẽmo mỳrapê kot paj mẽ amã hã amỹnê nhũm mẽ amã kupĩ? Tanhmã kot amnhĩ tomnuj tore hã. ");
INSERT INTO apnNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Kot paj ãm mẽ kãm anẽ kê mẽ htak nẽ kãm ure kê mãmrĩ ma tẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Arĩgro pê Pas ã na pre hte mẽ õ pahi mẽ kot mẽ ho prês nhũm mẽ hkrĩ xwỳnhjaja nhũm pre htem mẽ ho hpỹnh nẽ mẽ kãm ure. Jakamã na pre ã mẽ kãm kapẽr anẽ nẽ kot Jejus tak nẽ kãm urer mã. ");
INSERT INTO apnNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","19","Nom nhũm mẽ kuma nhũm ja mẽ kêp omnuj nẽ nhũm mẽ kãm: —Kwa nà. Apĩ ri. Apĩ nẽ mẽ inhmã Parapas mã mãn anhũre. Anẽ. Parapas na pre mẽ õ krĩ kamã õ pôristi mẽ pahi Piratja mẽ kutã amnhĩ xãm nẽ kêp õ pôristi hõxpĩ. Mỳrapê na prem ra haxà nhũm hkrĩ ho hkrĩ. Jakamã nhũm mẽ Pirat kot kãm urer kaxyw ã kãm kapẽr anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Nom nhũm kãm Jejus mã urer prãm jakamã axte hã mẽ hkukja nẽ mẽ kãm: —Kwa nom mẽmoj mỳrapê kot paj mẽ kãm hã amỹnê nhũm mẽ amã kupĩ? ");
INSERT INTO apnNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Anhỹr tã nhũm mẽ kuma nẽ ãm kuma. Nẽ xatã kãm: —Kwa tokyx pĩ kahpa hã anhô kê ty. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Hãmri nhũm tee ri mẽ kuma nẽ mẽ kãm: —Tk. Kwa nà. Tanhmã kot amnhĩ tomnuj tore hã kot pa kêt hã kunhô nhũm ty. Nà kot paj ãm mẽ kãm anẽ kê mẽ htak nẽ kãm ure kê ma tẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Hãmri nhũm mẽ xatã hã kãm kapẽr kãm hihtỳx nẽ kãm: —Kwa nà. Pĩ kahpa hã mãn anhô kê ty. Anhỹr o ãm xatã kàx pê àmra kamã kãm hã amỹnê. ");
INSERT INTO apnNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Hãmri nhũm Pirat tee ri mẽ kuma hãmri nẽ tã mẽ kãm hprãm xà hkôt mẽ kãm ã amỹnê. ");
INSERT INTO apnNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Hãmri nẽ mẽ kãm Parapas mã ure. Ra kot pahi Pirat pê õ pôristi kutã amnhĩ xãm nẽ kêp hõx pĩr tã nhũm mẽ kãm hprãm xà hkôt akupỹm kãm ure. Hãmri nẽ mẽ ĩhkram Jejus jaxà. Mẽ kãm hprãm xà hkôt ri mẽ kot tanhmã hipêx to kaxyw. ");
INSERT INTO apnNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Tã nhũm pôristijaja Jejus o kato nẽ ma kapôt mã o tẽ. Nẽ kãm õ pĩ kahpa gõ nhũm amnhĩ kaxyw kumỳ nẽ o tẽ. Nom mẽ kot htak rax kurê nhũm hirot tỳx nẽ nhũm mẽ ja hã omu nẽ mẽhõ kot ho ajuta kaxyw mẽ hkapi ho xa. Hãmri nẽ Sirẽn nhõ xwỳnh Simãw hkà htyk pumu. Nhũm pre htỳx hamakêtkati nẽ mẽ kutã krĩm tẽ. Hãmri nhũm mẽ haêr pê unê nẽ kãm Jejus o ajuta kaxyw hã karõ nhũm kãm õ pĩ kahpaja mỳ nẽ mẽ hkôt o tẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Hãmri nhũm mẽ ohtô nẽ Jerujarẽ rũm Jejus kôt mõ. Nhũm mẽni hkwỳjaja omu nẽ kãm hkaprĩ xàj mỳr o hkôt mõ. ");
INSERT INTO apnNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Hãmri nhũm mẽ mỳr ã mẽ kuma nẽ mẽ ho hakẽx nẽ mẽ omu nẽ mẽ kãm: —Kwa nà Jerujarẽ nhõ xwỳnhjaja. Mẽ amã ixkaprĩ xàj amỳr kêt nẽ. Kêt mẽ kamjaja amã amnhĩ kaprĩ xàj mãn mur. Nẽ mẽ akrajê kamã axukaprĩ xàj mãn mur. ");
INSERT INTO apnNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Koja mẽ nhỹrmã mẽ apê mẽ anhõ krĩ grành pa ka mẽ apunuj nẽ amnhĩ xà htỳx kamã ajamak o ri apa. Nẽ tee ri mẽ akrajê hkukamã tanhmã ajamaxpẽr to nẽ ajamaxpẽr o: “Hêxta gàà nẽ. Na ixkrajaja ixpê amnhĩ xà htỳx kãm hamak o pa. Kêp apu mẽ hkra hkêt xwỳnhjê pyrà nẽ ixkra hkêt nẽ ixpa ro nhỹx inhmã mex nẽ. Nhỹx pa ixkĩnh nẽ.” Anhỹr o kot kaj mẽ nhỹrmã ajamaxpẽr nom ã ajamaxpẽr anhỹr kaprỳ. ");
INSERT INTO apnNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","—Nẽ kot kaj mẽ apiitã mẽmo punujta pymaj tee ri amã tokyx atyk nẽ ajapêx par prãm kaprỳ nẽ axpẽn mã akapẽr o: “Hêxta gàà nẽ. Kot kẽn prêk mũj mẽ panhĩpy rôrôk nẽ tokyx mẽ panhĩmex par ronhỹx mẽ pamã ja mex.” Anhỹr tã no ãm tee ri ã ajamaxpẽr anhỹr kaprỳ. ");
INSERT INTO apnNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Nom kêt pa. Aa ixte tanhmã amnhĩ tomnuj to hkêt tã nhũm mẽ ã inhĩpêx anẽ. Nom mẽ ate amnhĩ tomnuj mỳrapê koja mẽ nhỹrmã tanhmã mẽ ato rax o ã mẽ kot inhĩpêx anhỹrja jakrenh pa. Hêxta waa nẽ. Na pa mẽ akukamã ijamaxpẽr nẽ ixkaprĩ htỳx nẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Tã nhũm mẽ ja wa ho hamẽxkrut nẽ tanhmã wa kot amnhĩ tomnuj toja mỳrapê Jejus kôt wa hpĩr kaxyw hkôt mããnẽn wa o tẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Jakamã nhũm mẽ ra kẽn nhĩxêt te kot mẽ hkrã hi pyràk xwỳnhta wỳr mẽ o pôj. Mẽ kot kãm “mẽ hkrã hi xà” anhỹr jarẽnhja wỳr mẽ o pôj. Hãmri nẽ Jejus pê ê kapa nẽ pĩ kahpa hã kuxi nẽ prek o ĩhkra nẽ hpar o htỳx pa. Hãmri nẽ kànhmã pĩ kahpa xãm nẽ ho htỳx nhũm xa. Hãmri nhũm mẽ hpãnhã wa kot amnhĩ tomnuj xwỳnhta mã wa ho anẽ nẽ. Nẽ prek o wa ĩhkra nẽ wa hpar o htỳx pa hãmri nẽ akutã ho Jejus nhĩjê nẽ wa ãm nhũm wa ajêt. ");
INSERT INTO apnNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Hãmri nhũm Jejus kỳx pê amnhĩ xà htỳx kumrẽx kamã hamak o jêt rãhã mẽ ho Tĩrtũm wỳ nẽ kãm: —Kwa Papaj. Ãm ixtã jajê pumu. Mẽ kot mẽmoj mex pumunh kêt jakamã na mẽ ã inhĩpêx anẽ. Jakamã ãm ixtã mẽ omu nẽ mẽ kamã axukaprĩ nẽ. Anẽ. Hãmri nhũm hparpê pôristi hkwỳjaja axpẽn mã ê hkwỳ ho pigrành kaxyw hã kẽnre ho jôka ho hkrĩ. ");
INSERT INTO apnNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Nhũm mẽ ohtô rax nẽ Jejus parpê omunh o kuhê. Nhũm mẽ õ pahijaja mẽ noo mã hã hpẽr o axkẽ nẽ mẽ kãm: —E jahti na pre te kêp mẽ pakaprĩ xwỳnh ã amnhĩ jarẽnh o ri pa. Nẽ Tĩrtũm kot mẽ pakaxyw ãm xwỳnh ã amnhĩ jarẽnh o ri pa. Jakamã e kwa pu mẽ xa nẽ kot amnhĩ kaxàr nẽ wrỳk kãm omu. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Nhũm pôristi mããnẽn tanhmã hã hpẽr o pikẽnh to. Nẽ hparpê kãm wĩhti punuti jahkre nẽ kãm: —Kwa wrỳ nẽ mẽ ixkutã ja hkwỳ ho ixkõ nà. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Hãmri nẽ kãm: —E apê Ijaew nhõ pahi hã kot kaj amnhĩ kapa nẽ akupỹn wrỳ. Kwa tokyx pa mẽ ja hã apumu. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Nhũm pôristija tapti hõ py nẽ tanhmã hã kagà hto. Nẽ hã kagà ho: IJAEW NHÕ PAHI NA JA Anhỹr o hã kagà hãmri nẽ Jejus wỳr api nẽ mỳ ri kunhô. ");
INSERT INTO apnNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Hãmri nhũm wa kot ĩhkô hã jêt xwỳnhta õ haxwỳja kãm kapẽr punuj nẽ kãm: —Kwa kot kaj apê Tĩrtũm kot mẽ ixkaxyw axãm xwỳnh hã kot kaj amnhĩ kapa nẽ wrỳ. Nẽ mããnẽn amnhĩ kôt wa ixto wrỳ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","41","Hãmri nhũm ihõta kuma nẽ hã kãm akir nẽ kãm: —Tk. Kwa amarĩ ajêt. Xà amã Tĩrtũm pyma hkêt ã na ka ã kêp Krata mã akapẽr anẽ? Nà koja kãm wrỳk prãm nẽ kot wrỳ. No pajamẽ pahte amnhĩ tomnuj mỳrapê koja mẽ pahpĩ. No tãm kot tanhmã amnhĩ tomnuj to hkêt tã nhũm mẽ amarĩ ã hipêx anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Anhỹr o kãm kapẽr hãmri nẽ Jejus mã kãm: —Kwa Jejus. Kêr ka nhỹrmã mẽ ixto amnhĩptà hãmri nẽ inhmã ajamaxpẽr nẽ ixkamã axukaprĩ nẽ ixto mex nẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Hãmri nhũm kãm: —Nà kot kaj jarãhã ma ixkôt kaxkwa hwỳr api nẽ hpãnhã ixkuri amex nẽ atĩr tũm nẽ apa ho apa. Ãm hãmri na pa ã amã ixkapẽr anẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Tã nhũm kaxkwa nhĩpôk ri myt nhỹr mẽ nhũm te ra kamàt pyràk nhũm kamàt kô rax kumrẽx. Nẽ kamàt kô ho ra hã awry nẽ. Ja mẽ nhũm akupỹm myt katêr o mõ. ");
INSERT INTO apnNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","46","Nom nhũm kormã kamàt kôta ã nhũm Jejus ra htyk kaxyw nẽ àmra kamã Tĩrtũm mã kapẽr nẽ kãm: —E Papaj. Mãmrĩ ixkarõ ho amnhĩptà. Anhỹrja kôt hãmri ty. Pu nhũm Tĩrtũm mã amnhĩ jarẽnh xà hã ixkre kamã hakwakre hã kupẽxêja axkjê nẽ amnhĩ kahê xà mẽnh kurê kumrẽx. Utĩ rax tã kôt ã axkjê nẽ amnhĩ kahê xà mẽ. Te Jejus htyk o kot mẽ pahte hkôt amnhĩ xunhwỳr xwỳnhjê mã Tĩrtũm wỳr pry jakwa kre kahê xà mẽnh pyràk o ã amnhĩ nhĩpêx anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","49","Hãmri nhũm mẽ piitã mẽmoj ã kot amnhĩ nhĩpêx anhỹr ã omunh o kuhê xwỳnhjaja. Nẽ kaxyw Jejus kràmnhwỳjaja nhũm mẽ amỳm omunh o kuhê. Nẽ Garirej rũm mẽni kot Jejus kôt mẽ pa ho mẽ pa xwỳnhjaja mããnẽn mẽ kuri amỳm hkaprĩ nẽ omunh o kuhê. Nhũm pôristi krãhtũmjê hõja ã mẽmoj kot amnhĩ nhĩpêx anhỹr ã omu nẽ tee ri hamaxpẽr o: —Hêxta waa nẽ. Pẽr ãm hãmri na pre hte tãm amnhĩ nhĩpêx o pa. Tã pa mẽ amarĩ mẽ mar xà hkôt ixtỳx kupĩ. Anẽ. Nhũm ã hamaxpẽr anhỹrja kôt Tĩrtũm mã mex o mex ã harẽnh o xa. Nhũm amarĩ mẽ kuhê xwỳnhjaja mããnẽn mẽmoj ã kot amnhĩ nhĩpêx anhỹrta pumu nẽ tee ri hkukamã hamaxpẽr o ra kãm ma htỳx nẽ. Hãmri nẽ awjanã nẽ ma akupỹm krĩm mrar kurê kumrẽx. ");
INSERT INTO apnNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Tã nhũm axtem Juje pê Arimatej nhõ xwỳnhja. Arimatejja pika pê Ijaew kamã na. Nhũm Jujeja kot amnhĩ to mex jakamã Tĩrtũm kôt amnhĩ nhĩpêx o pa. Jakamã na pre hkwỳjê rom Tĩrtũm kot mẽ pahwỳr Jejus mẽnh xwỳnh ã omu nẽ hkôt hamaxpẽr. Kêp Ijaew nhõ pahi hõ htã hkwỳjê hkôt hamaxpẽr kêt nẽ. Jakamã nhũm prem kot Jejus pĩr ã amỹnê nhũm tee ri harẽnh ma nhũm ja kêp omnuj nẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Jakamã nhũm Jejus ty nhũm Juje ma pahi Pirat wỳr tẽ nẽ ĩ hã kuwỳ nẽ kãm: —Pa? E ot pa awỳr tẽ. Kwa inhmã htyk xwỳnhta gõ pa ma o tẽ nẽ haxà. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Hãmri nhũm kuma nẽ kãm kugõ nhũm ma o tẽ nẽ haxà. Kaxyw kupẽxê hõ py nẽ ho hkupu nẽ ma o tẽ nẽ kẽn kre kaprỳ kamã haxà. Mẽ kot kormã kamã mẽhõ jaxàr kêt nhũm mẽ kamã Jejus jaxà. ");
INSERT INTO apnNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Arĩgro pê sêsta hã nhũm prem kupĩ nhũm myt xàr o mõr mẽ nhũm Juje ma o tẽ nẽ haxà. Ijaew kôt xà hã arĩgromnuja wỳr haxà. ");
INSERT INTO apnNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Nhũm Garirej rũm mẽni hkwỳ kot Jejus kôt pa xwỳnhjaja ma hkôt mra nẽ kot haxàr kãm omu. Mẽ hkuxwaxà ho gregrer kêt rãhã haxàr kãm omu. ");
INSERT INTO apnNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Hãmri nẽ ma akupỹm krĩm mra nẽ kaxyw mẽ hkuxwaxà hkwỳ ho anẽ. Tã nhũm apkati nhũm mẽ õ arĩgromnu pê sap kator jakamã nhũm mẽ kormã akupỹm hwỳr mrar kêt nẽ. Hãmri arĩgro mex jamãr pê arĩ hkôkôt o hkrĩ. ");
INSERT INTO apnNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Tã nhũm apkati nhũm tômĩk. Hãmri nhũm mẽnijaja kwỳhtã kànhmã hkrĩ nẽ ma akupỹm kẽn kreta wỳr mẽ hkuxwaxà ho mra. ");
INSERT INTO apnNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Hãmri nẽ hwỳr àhtêp o mra nhũm ra hakwakre kahê xà raxta kahê xà hkàx ã xa nhũm mẽ tee ri omu. ");
INSERT INTO apnNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Hãmri nẽ kẽn kre wỳr agjê nẽ kamã tee ri Jejus japêr no nhũm kamã amrakati. ");
INSERT INTO apnNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Nhũm mẽ tee ri axpẽn pumunh pê hkukamã hamaxpẽr. Hãmri nhũm Tĩrtũm kapẽr o wrỳk xwỳnh wa axkrut nẽ mẽ haêr pê mẽ hwỳr kato nẽ wa xa. Wa ê jaka nẽ hirã htỳx kãm wa xa. ");
INSERT INTO apnNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Nhũm mẽ tee ri wa omu nẽ kãm wa uma htỳx nẽ. Nẽ wa umaj hkõn krã ho rôrôk nẽ hkrĩ hpa. Nhũm wa mẽ omu nẽ mẽ kãm: —Kwa mon ka mẽ ri mẽ htykjê kamã ra akupỹm htĩr xwỳnhta japêr o ri apa? ");
INSERT INTO apnNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Jar amrakati. Na ra akupỹm htĩr. Kormã Garirej kamã pa ri kot mẽ amã amnhĩ jarẽnh xà hkôt na ra akupỹm htĩr. Mãn ka mẽ arĩ kot ã mẽ amã amnhĩ jarẽnh anhỹrja ã anohtỳx japêr. ");
INSERT INTO apnNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Mẽ kot unênh nẽ pĩ kahpa hã nhôr nhũm htyk nẽ htyk ã apkati axkrunẽpxi hãmri nẽ akupỹm htĩr ã kot mẽ amã amnhĩ jarẽnhta mãn ka mẽ arĩ hã anohtỳx japêr. ");
INSERT INTO apnNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Anhỹr o mẽ kãm kapẽr nhũm mẽ kuma hãmri nẽ ra Jejus kot mẽ kãm ã amnhĩ jarẽnh anhỹrja mã hamaxpẽr kurê kumrẽx. ");
INSERT INTO apnNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Hãmri nẽ awjanã nẽ ma akupỹm krĩm hkĩnh nẽ mra. Nẽ hwỳr pôj nẽ mẽ kot Jejus nhỹ hã mẽ ahkre ho mẽ pa xwỳnhjê mã awjarẽ. Mẽ kêp 11 xwỳnhtajê mẽ kaxyw hkwỳjê mã awjarẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Mẽni kot mẽ kãm ujarẽnh xwỳnhtajê nhĩxi na pre Marir Matarẽn nhũm ja kêp Joanã. Nẽ Xiakre katorxà Marir õta. Nẽ kaxyw mẽni hõja. Jakamã nhũm mẽ ma akupỹm Jejus nhỹ hã mẽ ahkre ho mẽ pa xwỳnhjê hwỳr mra nẽ mẽ kãm awjarẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Nom nhũm mẽ kuma nẽ ãm mẽ kuma nẽ htỳx ho amnhĩ krã hkôt mẽ kot ri ã harẽnh anhỹr ã mẽ hkamnhĩx nẽ ãm mẽ kuma. ");
INSERT INTO apnNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Nhũm Simãw Pêtre hamaxpẽr hãmri nẽ kànhmã xa nẽ ma kẽn kreta wỳr hprõt nẽ htẽm kurê kumrẽx. Hãmri nẽ tee ri kẽn kre kaprỳ kamunh o xa nẽ kamã Jejus kupu xà pix pumu nẽ tee ri hkukamã hamaxpẽr hãmri nẽ ma akupỹm tẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Tã nhũm ra amỹkry ho mõ nhũm Jejus kwỳjê hõ wa hamẽxkrut nẽ Jerujarẽ rũm kato nẽ ma akupỹm wa õ krĩ pê Emau hwỳr wa mõ. Jerujarẽ rũm Emau hwỳr ahkrãnre. ");
INSERT INTO apnNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Jakamã nhũm wa hwỳr pry hã axpẽn mã tanhmã Jejus jarẽnh to ho mõ. Kẽn kre kamã mẽ kot haxàr nhũm ra ĩ pikunorja nhũm wa axpẽn mã harẽnh o wa mõ. Nẽ tee ri hkukamã hamaxpẽr o wa mõ. ");
INSERT INTO apnNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Hãmri nhũm Jejus tãm tẽ nẽ wa hã ajêt nẽ wa hkôt tẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Nom nhũm wa hprĩ hã omunh kêt nẽ. Tỳx ho nhãm mẽhõ hã hkamnhĩx nẽ wa arĩ axpẽn mã harẽnh o wa mõ. ");
INSERT INTO apnNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Hãmri nhũm Jejus hêx rom wa kãm: —Kwa mẽmon ka wa axpẽn mã harẽnh o wa mõ? Anẽ. Hãmri nhũm wa hkaprĩ kamã kãm harẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Ihõ pê Kroptija kãm: —Kwa xà na ka Jerujarẽ kamã ri apa htã kamã mẽ kot tanhmã amnhĩ nhĩpêx toja jarẽnh mar kêt nẽ? Kurũm amõr kênã na ka ri mẽmoj mar kêt nẽ ri apa. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Hãmri nhũm wa kãm: —Nà amrakati ixte mẽmoj maare hã. Kwa mo na wehe? Kwa war aprĩ hã inhmã harẽ pa kuma. Anẽ. Hãmri nhũm wa kãm: —Nà mẽ kot mẽ ixpê tanhmã Jejus pê Najare nhõ xwỳnhta to kênã. Kêp Tĩrtũm nhỹ hã kapẽr jarẽnh o pa xwỳnh na pre. Nẽ Tĩrtũm nhỹ hã tanhmã amnhĩ nhĩpêx to ho pa nhũm prem piitã amnhĩm mex ã harẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Tã nhũm mẽ panhõ patre krãhtũmjê mẽ mẽ panhõ pahijaja axtem nẽ mẽ kãm hã amỹnê. Mẽ kot pĩ kahpa hã nhôr nhũm htyk kaxyw mẽ kãm hã amỹnê. ");
INSERT INTO apnNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Pa prem ixtỳx ho kêp Tĩrtũm kot mẽ pahwỳr mẽnh xwỳnh ã hkamnhĩx nẽ kot Rõm nhõ xwỳnhjê pê mẽ ixpytàr ã hkamnhĩx tã nhũm prem mẽ ixpê kupĩ. Jãã na prem ã hipêx anẽ nẽ kupĩ. Na ra htyk ã apkati axkrunẽpxi. ");
INSERT INTO apnNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","23","—Nẽ jarãhã kwỳhtã mẽni hkwỳjaja ma haxàr xà hã kẽn kre hwỳr mra nẽ xep tee kamã hapêr nẽ omunh kêt nẽ. Xep ãm Tĩrtũm kapẽr o wrỳk xwỳnhja wa ho axkrut nẽ wa omu nhũm wa xa. Nhũm mẽ kãm ra akupỹm htĩr ã harẽ nhũm mẽ akupỹn mẽ ixwỳr mra nẽ mẽ ijaêr pê mẽ inhmã harẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Hãmri nhũm mẽ ixkwỳjaja ma mẽ hpãnhã kẽn kreta wỳr mra nhũm ra mẽ kot harẽnh xà hkôt tee ri kamã hapêr nom nhũm kamã amrakati kumrẽx. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Hãmri nhũm Jejus amnhĩ tã wa kuma nẽ wa kãm tanhmã amnhĩ jarẽnh to nẽ wa kãm: —Hêxta waa nẽ. Pẽr ãm mẽ ate mẽmoj mã ajamaxpẽr tỳx mex kêt kumrẽx. Na pre ra Tĩrtũm nhỹ hã kapẽr jarẽnh xwỳnhjaja Tĩrtũm kapẽr ã kagà htũm kamã ã kot amnhĩ nhĩpêx anhỹrja kukamã hprĩ hã harẽ nẽ hã kagà. Mẽ akukamã mẽ anhĩgêtjê mã harẽ nẽ hã kagà. Tã ka mẽ kormã aprĩ hã mar tỳx kêt nẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Kêt mẽ anê na Tĩrtũm kot ãm xwỳnhta ty. Tã ra akupỹm htĩr nẽ akupỹm kaxkwa hwỳr àpir kaxyw. Kot mẽ ato amnhĩptàr kaxyw ra akupỹm hwỳr àpir mã. ");
INSERT INTO apnNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Amnepêm na pre finat Mojesja tanhmã hkukamã mẽ anhĩgêtjê mã harẽnh to nẽ hã kagà. Nẽ hprĩ hã harẽnh o pa. Nhũm hpãnhã Tĩrtũm nhỹ hã kapẽr jarẽnh o mẽ pa xwỳnhjaja ma anẽ nẽ mẽ kãm harẽnh o pa. Anẽ. Nhũm pre ã Jejus wa hkôt hprĩ hã wa kãm amnhĩ jarẽnh anhỹr o tẽ. Te ho nhãm mẽhõ jarẽnh pyràk nom tãm wa kãm amnhĩ jarẽnh o wa hkôt tẽ. No nhũm kormã wa hprĩ hã kêp Jejus ã omunh kêt nẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","29","Nhũm ã wa kãm amnhĩ jarẽnh anhỹr o mõr rãhã nhũm mẽ ra wa õ krĩ hwỳr hpôx o mõ. Nhũm ra kamàtre nhũm Jejus te kot wa rer nẽ nhỹhỹm ma htẽm kaxyw pyràk o amnhĩ nhĩpêx nhũm wa tee ri omu nẽ kãm: —Kwa xà kot kaj wa ixre nẽ ma tẽ? Ra kamàt o mõr kênã. Kwa ma wa ixkôt tẽ nẽ wa inhõrkwỹ kamã mãn wa ixri pôj. Anẽ. Hãmri nhũm wa kuma nẽ ma wa hkôt tẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Nẽ mẽ wa õrkwỹ hwỳr pôj nẽ hwỳr agjê. Hãmri nẽ apkur kaxyw hkrĩ nhũm Jejus tãm pãwti py nẽ Tĩrtũm mã harẽ nẽ hpãnhã ho axkjê nẽ wa kãm kugõ. ");
INSERT INTO apnNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Hãmri nhũm wa atã kêp Jejus ã omunh kurê kumrẽx. Jao nhũm wa kêp akunok nhũm wa tee ỹr xà kamã hapêr nhũm hkaprỳ mex nẽ xa. ");
INSERT INTO apnNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Hãmri nhũm wa tee ri axpẽn pumu nẽ ri hkukamã hamaxpẽr nẽ axpẽn mã: —Hêxta waa nẽ. Xep tãm na. Tãm na pahkôt mõ nẽ pry hã hprĩ hã pamã Tĩrtũm kapẽr ã kagà jarẽ pu hkôt pahkĩnh nẽ mar o mõ. Hêxta waa nẽ. Xep tãm na. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","35","Hãmri nẽ wa kànhmã xa nẽ kato nẽ ujanãr kurê kumrẽx. Hãmri nẽ ma akupỹm Jerujarẽ hwỳr wa hkwỳjê hwỳr tẽ. Nẽ mẽ hwỳr pôj nẽ axà. Nhũm Jejus nhỹ hã mẽ ahkre ho mẽ pa xwỳnh pê 11jaja ra axpẽn wỳr akuprõ nẽ hkrĩ. Mẽ hkwỳjê mẽ axpẽn wỳr akuprõ nẽ axpẽn mã tanhmã Jejus jarẽnh to ho hkrĩ. Hãmri nhũm wa mẽ hwỳr axà nhũm mẽ wa omu nẽ wa kãm: —Kwa na xep ra Jejus akupỹm htĩr nẽ Simãw Pêtre hwỳr kato. Anẽ. Hãmri nhũm wa mẽ kuma nẽ mẽ kãm: —Tỳ na akupỹm htĩr kênã. Na pa wa ijaxwỳja ham omu. Na pry hã wa ixtã ajêt nẽ ma wa ixkôt mõ nẽ wa inhõrkwỹ kamã pôj. Hãmri pa mẽ ixàpkur kaxyw ixkrĩ nhũm pãwti py nẽ Tĩrtũm mã harẽ nẽ ho axkjê nẽ wa inhmã kugõ pa wa ixprĩ hã kêp Jejus ã omunh kurê kumrẽx. Ixprĩ hã omunh jao nhũm wa ixpê hapêx. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Nhũm mẽ kormã axpẽn mã Jejus jarẽnh o hkrĩ rôm nhũm tãm nhỹhỹnh mẽ hwỳr axà nẽ xa. Mẽ haêr pê mẽ hwỳr nhỹhỹnh axà nẽ mẽ kãm: —Pa? Xàn ka mẽ arĩ akrĩ? Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Hãmri nhũm mẽ amnhĩ jaêr pê omunh jao kànhmã hakry hpar o mra. Jao hakryk kãm ma htỳx kãm omunh o hkrĩ. ");
INSERT INTO apnNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Hãmri nhũm mẽ kãm: —Kwa mon ka mẽ amã ixpyma kamã tee ri ixpumunh o akrĩ? Kwa mẽ ixkarõ hã ixkamnhĩx nẽ amã ixpyma hkêt nẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Na pa akupỹn inhĩ ho mẽ awỳr ixkato nẽ xa. Ga mẽ inhĩhkra kamã prek tatak xàja pumu. Nẽ ixpar kãm omu. Kwa mẽ amã ixpyma hkêt nẽ. E mẽ mãmrĩ mra nẽ anhĩhkra ho ixkupê. Kêp apu ixkarõ hpix ronhỹx ka mẽ inhĩ kupênh kêt nẽ. Mo mẽhkarõja ĩ? Nà na pa akupỹm ixtĩr nẽ inhĩ ho mẽ awỳr ixkato. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Hãmri nẽ mẽ kãm amnhĩ nhĩhkra hpẽ nẽ mẽ kãm amnhĩ par pẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Tã nom nhũm mẽ arĩ akryk omunh o hkrĩ. Mẽ kot omunh nẽ hkĩnh tã tee ri omunh o hkrĩ. Hãmri nhũm tee ri ja hã mẽ omu nẽ mẽ kãm: —E kwa mẽ inhmã mẽmoj japêr pa kukrẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Hãmri nhũm mẽ kãm tep gôj kãm ãmta gõ ");
INSERT INTO apnNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","nhũm kupy nẽ hkur o nhỹ nhũm mẽ arĩ hã omunh o hkrĩ. Jao ra akupỹm htĩr ã omunh kurê kumrẽx. ");
INSERT INTO apnNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","45","Hãmri nhũm Jejus hprĩ hã mẽ kãm Tĩrtũm kapẽr ã kagà htũm kot hkukamã harẽnh ã amnhĩ jarẽ nẽ mẽ kãm: —Nà kormã ixtyk kêt ri na pa pre ixprĩ hã mẽ amã amnhĩ kukamã amnhĩ jarẽ. Tĩrtũm kapẽr ã kagà htũm kot tanhmã mẽ kot inhĩpêx to hkukamã ijarẽnhja. Na pre finat Mojes Tĩrtũm nhỹ hã ixkukamã tanhmã ijarẽnh to. Nẽ Tĩrtũm nhỹ hã kapẽr jarẽnh o mẽ pa xwỳnhjaja Mojes mỳr pê haxwỳja ixkukamã tanhmã ijarẽnh to. Nẽ Tĩrtũm mex o mex ã mẽ grer ã kagà xwỳnhjaja haxwỳja ixkukamã tanhmã ijarẽnh to. Jajê piitã na prem Tĩrtũm kapẽr ã kagà htũm kamã ixkukamã ijarẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Nẽ ijarẽnh o: Tĩrtũm kot mẽ pakaxyw ãm xwỳnh pê Krisja koja nhỹrmã ty. Nẽ htyk o apkati axkrunẽpxi nẽ akupỹm htĩr. Anhỹr o mẽ kot ijarẽnh. Tã pa ra mẽ kot ixkukamã ijarẽnh xà hkôt ã mẽ anê amnhĩ nhĩpêx anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","—No ãm Tĩrtũm kapẽr ã kagà htũm kot papxipix ixkukamã ijarẽnh kêt. Kamã mããnẽn mẽ kajaja tanhmã mẽ akukamã mẽ ajarẽnh kute. Mẽ apê ixkôt amnhĩ xunhwỳr xwỳnhjaja ixwakre kamã tanhmã mẽ ate inhmã amnhĩ nhĩpêx to ho apa hkukamã tanhmã mẽ ajarẽnh kute. Nẽ mẽ ajarẽnh kot: E mẽ ate ixkôt amnhĩ xunhwỳr xwỳnhjaja. Kêr ka mẽ ma pika piitã hkôt mẽ kãm Tĩrtũm kot mẽ awỳr mẽnh xwỳnhta jarẽnh o ri mẽ hkôt apa. Mẽ kot mẽ amar nẽ amnhĩ tomnuj kaga nẽ Tĩrtũm kôt amnhĩ xunhwỳr kaxyw. Kêr kê Tĩrtũm ja hã mẽ omu nẽ amnhĩ katut kôt mẽ kot amnhĩ tomnuj rẽnh pa. E kêr ka mẽ ma krĩ piitã hkôt mẽ kãm ã ja jarẽnh anhỹr o ri mẽ hkôt apa. Krĩ pê Jerujarẽ kumrẽx kãm hãmri nẽ rĩ kormã pu hã krĩ kuhê xwỳnh piitã hkôt ajapôj nẽ mẽ kãm harẽnh o ri apa. Anẽ. Ã Tĩrtũm kapẽr ã kagà htũm kot mẽ akukamã mẽ ajarẽnh kot anhỹr. ");
INSERT INTO apnNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Tã kêr ka mẽ ã mẽ kãm tanhmã ijarẽnh to ho ri apa anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","No ãm kormã. Kêr paj ma akupỹm kaxkwa hwỳr api hãmri nẽ amnhĩ pãnhã mẽ awỳr Tĩrtũm Karõ rẽ mãn. Tĩrtũm kot ixte amnhĩ nhĩpêx ã ijarẽnh xà hkôt kot paj amnhĩ pãnhã mẽ awỳr kurẽ. Tã kêr ka mẽ kormã krĩ ja kamã kutêp apa. Kêr kê mẽ awỳr wrỳ nẽ mẽ amã agjê ka mẽ rĩ kormã anhgrà nẽ ma ỹ hã mẽ kãm ijarẽnh o ri mẽ hkôt apa. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Tã nhũm Jejus Jerujarẽ rũm hkôt mẽ pa ho pa xwỳnhjê kator nẽ ma krĩ pê Petãn wỳr mẽ o mõ. Nẽ kormã hwỳr mẽ o mõr ri nhỹri mẽ o xa nẽ kànhmã ĩhkra pẽ nẽ mẽ ho Tĩrtũm wỳ. ");
INSERT INTO apnNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","ã mẽ ho hwỳr anhỹrja rôm nhũm Tĩrtũm amnhĩ wỳr ho àpir o mõ nhũm mẽ noo mã ma akupỹm tẽn api. ");
INSERT INTO apnNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Hãmri nhũm mẽ kãm mex o mex ã harẽnh pê ma akupỹm àpir kãm omunh o kuhê. Nhũm ma tẽ nẽ mẽ kêp kakrãm axà nẽ mẽ kêp akunok. Hãmri nhũm mẽ awjanã nẽ ma akupỹm Jerujarẽ hwỳr hkĩnh nẽ pa. ");
INSERT INTO apnNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Hãmri nẽ apkati mẽ Tĩrtũm mã amnhĩ jarẽnh xà hã ixkre hwỳr agjê nẽ kamã Tĩrtũm mã mex o mex ã harẽnh o hkrĩ rãhã nẽ. Tã ãm ja pix ixkràmnhwỳ Teopre. Ixpê Rukre na pa awỳr kagàja nhĩpêx nẽ kamã Jejus kot tanhmã amnhĩ nhĩpêx to hã harẽ nẽ hã kagà nẽ awỳr kumẽ.");
INSERT INTO apnNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Amnepê mã kormã mẽmoj kêt ri nhũm kot Tĩrtũm kapẽr o amnhĩrĩt xwỳnhja Tĩrtũm kôt pa ho pa. Te kêp uràk nẽ pa. Wa kot amnhĩ nhĩpêxja ãm tipxi. Nẽ wa àhpumunh ãm tipxi. Nẽ wa hkarõ mããnẽn ãm tipxi. Ãm wa tipxi rãhã nẽ pa ho pa. ");
INSERT INTO apnNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Kormã mẽmoj kêt ri na pre Tĩrtũm kapẽr o amnhĩrĩt xwỳnhta Tĩrtũm kôt ri pa ho pa. ");
INSERT INTO apnNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Nẽ Tĩrtũm nhỹ hã na pre mẽmoj piitã hã apê nẽ ho kato. Jao pyka ho kato nẽ kaxkwa ho kato nẽ gô xujanãr o kato. Nẽ kamã mẽmoj piitã Tĩrtũm nhỹ hã ho kator pa. Kop apu mẽmoj to kator kêt ronhỹx mẽmoj amrakati kumrẽx. ");
INSERT INTO apnNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Nẽ Tĩrtũm o amnhĩrĩt xwỳnhta pix kukwak ri na hte mẽmoj piitã htĩr nẽ pa. Nẽ ãm pix kukwak ri na htem Tĩrtũm ri htĩr tũm nẽ pa ho pa. Nẽ te myyti kot mẽ pamã mẽmoj piitã hirã ho pa pu mẽ kukwak ri mẽmoj piitã omunh mexja pyrà nẽ na pre hte mẽ pahpiitã mẽ pamã mẽ pahte amnhĩ nhĩpêx nyw nẽ mẽ pajamaxpẽr nyw o amnhĩrĩt pu mẽ pahprĩ hã mar mex nẽ. ");
INSERT INTO apnNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Ja kaxyw na pre wrỳ nẽ ri mẽ kãm Tĩrtũm kapẽr jarẽnh o ri mẽ hkôt pa. Jao mẽ kot amnhĩ nhĩpêx nyw jarẽ nhũm mẽ kot amnhĩ tomnuj xwỳnhjaja tee ri kuma nẽ kãm mar prãm kêt nẽ. Nẽ tee ri kãm kapẽr o hapêx prãm kaprỳ. ");
INSERT INTO apnNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Tã nhũm kormã Jejus mẽ kãm kapẽr o pa hkêt ri nhũm Juãw Paxis kumrẽx mõ nẽ hkukamã Tĩrtũm nhỹ hã mẽ kãm tanhmã harẽnh to ho pa. ");
INSERT INTO apnNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Mẽ kãm mẽ kot amnhĩ nhĩpêx nyw nhõr xwỳnh pê Jejus Kris kukamã mẽ kãm harẽnh o ri mẽ hkôt pa. Mẽ kot mar nẽ amnhĩ kaxyw Jejus kôt hamaxpẽr kaxyw. ");
INSERT INTO apnNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","No Juãw Paxisja na pre hte mẽ kãm mẽ kot amnhĩ nhĩpêx nyw nhõr o pa hkêt nẽ. Na pre ãm kot mẽ kãm õr xwỳnhta kukamã mẽ kãm harẽnh o pa. ");
INSERT INTO apnNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Jakamã na pre hte mẽ kãm harẽnh o ri pa nẽ mẽ kãm harẽnh o: —E ot pa mẽ amã mẽhõ jarẽnh o ri ixpa. Kot mẽ pamã mẽ pahte amnhĩ nhĩpêx nyw nhõr xwỳnhta. Koja tokyx mẽ pakamã pôj pu mẽ omu. Koja pôj nẽ mẽ piitã mẽ kãm Tĩrtũm kapẽr jarẽnh o ri pa. Mẽ pahte pahprĩ hã mar mex kaxyw. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Tã nhũm Jejus man kot mẽmoj piitã ho kator xwỳnhta wỳr wrỳ nẽ mẽ hkôt ri pa. No nhũm mẽ kot kêp mẽmoj piitã ho kator xwỳnh ã omunh kêt jakamã na prem kapẽr ma nẽ ãm kuma nẽ amnhĩ kaxyw hkôt hamaxpẽr kêt nẽ. ");
INSERT INTO apnNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Na pre wrỳ nẽ mẽ pakamã ĩ ho kato. Kêp mẽ pahpiitã mẽ pahto kator xwỳnh tã nhũm mẽ ohtô nẽ omu nẽ ãm omu nẽ hkôt amnhĩ nhĩpêx kêt nẽ. ");
INSERT INTO apnNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Na prem ãm grêre nẽ kuma nẽ amnhĩ kaxyw hkôt hamaxpẽr nẽ hkôt amnhĩ xunhwỳ. Hãmri nhũm amnhĩ tã mẽ omu nẽ mẽ kãm: —E nà ãm hãmri. Ra mẽ ate amnhĩ kaxyw ixkôt ajamaxpẽr nẽ ixkôt amnhĩ xunhwỳr jakamã na ka mẽ ixkukwak ri apê Tĩrtũm kraa. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Na htem ã kêp Tĩrtũm kra hprãm xàj Jejus kôt amnhĩ xunhwỳr anẽ. No na htem mẽ katorxà nhõxà hkre rũm hapôx kôt kêp Tĩrtũm kra hkêt nẽ. Rỳ amnhĩ krã hkôt tanhmã amnhĩ nhĩpêx to kukwak ri kêp hkra hkêt nẽ. Ãm Tĩrtũm tãm kot mẽ ho hkra pix kukwak ri na htem kêp hkra. ");
INSERT INTO apnNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Jakamã na pre Tĩrtũm o amnhĩrĩt xwỳnhta mẽ pahwỳr wrỳ nẽ mẽ pakamã ĩ ho kato nẽ mẽ pakamã pa. Kêp Tĩrtũm Kra hã pixi mex na pre. Nẽ kot amnhĩ nhĩpêxja te Tĩrtũm kot amnhĩ nhĩpêx pyràk. Uràk nẽ mex o mex. Nẽ uràk nẽ mẽ pakutã nojarêt xwỳnh. Na pre hte katàt kôt Tĩrtũm kapẽr jarẽnh o ri mẽ hkôt pa. Pa prem kuma nẽ mex o mex ã omu. ");
INSERT INTO apnNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Nhũm Juãw Paxis na pre hkukamã mẽ kãm harẽnh o ri pa nẽ mẽ kãm: —E ra ixte mẽ amã harẽnh o ri ixpa xwỳnhta na ra pôj. Te pa ixte wa nẽ ixkator pyràk nom amnepê mã kormã ixkêt ri nhũm htĩr rãhã nẽ pa ho pa. Ham ĩ ho kator tã kêp Tĩrtũm Kra jakamã uràk nẽ rãhã ho rãhã hã pa xwỳnh na. Jakamã kot amnhĩ to rax o kot ijakrenh par. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Nẽ kêp mẽ pakutã nojarêt rãhã nẽ pa ho pa xwỳnh jakamã na hte mẽ pahto mex rãhã pu mẽ kukwak ri pamex nẽ ri papa ho papa. ");
INSERT INTO apnNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Na pre finat Mojesja mẽ panhĩgêtjê mã Tĩrtũm kapẽr jarẽnh o ri mẽ hkôt pa nẽ mẽ kãm: —Na pre Tĩrtũm mẽ pahte tãm amnhĩ nhĩpêx o papa hã mẽ pamã karõ. Jakamã kot puj mẽ kot mẽ pamã mẽmoj tã karõ xà hkôt ã amnhĩ nhĩpêx anhỹr o papa nẽ ra tãm amnhĩ nhĩpêx o papa. Anẽ. Nhũm pre Mojesja ã mẽ kãm kapẽr o pa anẽ. Hãmri nhũm mẽ kuma no ãm tee ri kãm Tĩrtũm kôt tãm amnhĩ nhĩpêx o pa hprãm kaprỳ. Jakamã nhũm hpãnhã Jejus Krisja wrỳ nẽ mẽ pamã kapẽr õ ho kapẽr o pa nẽ mẽ pamã: —E mẽ ate Tĩrtũm kôt amnhĩ nhĩpêx o apa hkêt tã nhũm arĩ kãm mẽ ajapê nẽ. Nẽ kãm mẽ ato mex prãm. Jakamã kot kaj mẽ amnhĩ to awỳ nhũm tanhmã mẽ akrã hto ka mẽ ra tãm ri amnhĩ nhĩpêx o apa. Ãm hãmri na pa ã mẽ amã ja jarẽnh anẽ. Anhỹr o mẽ pamã Tĩrtũm kapẽr jarẽnh o pa. Tĩrtũm kapẽr na mex o mex. ");
INSERT INTO apnNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Nẽ aa mẽ pahtõ mẽ pahte pano ho Tĩrtũm pumunh kêt. Ãm Kraja pix na kot no ho omunh. Kaxkwa kamã kuri ri pa ho pa jakamã kot omunh mex. Nẽ te kot Hipêêxàja pyràk jakamã na pre wrỳ nẽ hprĩ hã tanhmã kute hã mẽ pamã harẽnh o pa. Jakamã na pu mẽ ra pahpiitã Tĩrtũm kot amnhĩ nhĩpêx ã omu nẽ mar mex nẽ. ");
INSERT INTO apnNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","28","Na pre Juãw Paxis ma hkwỳjê hkôt mẽ kãm Jejus jarẽnh o pa nhũm mẽ hkwỳjaja kuma nẽ amnhĩ kaxyw Jejus kôt hamaxpẽr nẽ hkôt amnhĩ xunhwỳ. Hãmri nhũm Juãw Paxis ja hã mẽ omu nẽ Tĩrtũm mã mẽ hkrã kumrã. Pyhti pê Jotãw nhĩkjê hã krĩ pê Petãn tã ri mẽ hkrã kumrãr o pa. Hãmri nhũm krĩ pê Jerujarẽ kamã Ijaew krãhtũmjaja harẽnh ma nẽ ma hwỳr hkwỳjê rẽ. Mẽ kot tanhmã hkukjêr to nhũm kot mẽ kãm tanhmã amnhĩ jarẽnh to kaxyw. Jakamã nhũm mẽõ patre hkwỳjê mẽ Tĩrtũm mã amnhĩ jarẽnh xà hã ixkre kamã mẽ ho ajuta xwỳnh kwỳjê mẽ Parijew nhõ xwỳnh kwỳjê mẽ nhũm mẽ ma hwỳr mra. Juãw Paxis wỳr mra nẽ omu nẽ kãm: —Pa. E ot pa mẽ awỳr mra. Kwa mẽ inhmã amnhĩ jarẽ. Apê mẽ atõ na ka we? Xà ka na apê Tĩrtũm kot mẽ ixkaxyw axãm mã xwỳnhta na ka nà? Xà ka na pa htem amnhĩ wỳr akamã ijamak o ixpa? Anẽ. Hãmri nhũm mẽ kuma nẽ mẽ kãm: “Nà pa hkêt.” Anẽ hãmri nhũm mẽ kãm: —Tô mãn xep apê amnepê mã Tĩrtũm nhỹ hã kapẽr jarẽnh xwỳnh pê finat Erisja. Hã na ka tanhmã amnhĩ to nẽ akupỹm atĩr nẽ mẽ ixkôt apa nà? Anẽ. Hãmri nhũm mẽ kãm: —Nà ixpê Eris kêt. Anẽ. Hãmri nhũm mẽ kãm: —Tô mãn xep apê finat Mojes kot mẽ kãm harẽnh o pa xwỳnhta na ka nà? Anẽ. Hãmri nhũm mẽ kuma nẽ kê axte mẽ kãm: —Nà ixpê tãm kêt. Anẽ. Hãmri nhũm mẽ tee ri kot ã amnhĩ tã aprãr anhỹrja ma nẽ kãm: —Kwa apê jajê hõ hkêt tã na ka hte mẽ hkrã kumrãr o ri apa. Kwa nà akatàt kôt mẽ inhmã amnhĩ jarẽ. Pa mẽ ama nẽ ma akupỹm mra nẽ mẽ kot awỳr mẽ ixrẽnh xwỳnhjê mã tanhmã ajarẽnh to. Tanhmã na ka hte mẽ kãm amnhĩ jarẽnh to ho ri apa? E kwa mẽ inhmã amnhĩ jarẽ pa mẽ ama. Anẽ. Hãmri nhũm tã hprĩ hã mẽ kãm amnhĩ jarẽ. Amnepê mã mẽ hkukamã Tĩrtũm nhỹ hã kapẽr jarẽnh xwỳnh pê finat Ijais kot hkukamã tanhmã harẽnh to nẽ hã kagà xà hkôt nhũm mẽ kãm amnhĩ jarẽ nẽ mẽ kãm: —Tôe. Nà kot paj ixprĩ hã mẽ amã amnhĩ jarẽ ka mẽ inhma. Amnepêm Tĩrtũm kapẽr jarẽnh xwỳnhjê hõ pê finat Ijaisja na pre hte mẽ kãm mẽhõ hkukamã harẽnh o ri pa. Mẽhõ kot mẽ panhõ Pahihti hkukamã htẽm nẽ kapôt ã kutêp mẽ kãm harẽnh o pa xwỳnhta nhũm pre hkukamã harẽnh o ri pa. Nẽ mẽ kãm harẽnh o: Koja nhỹrmã mẽhõja kapôt ã mõn pôj nẽ mẽ kãm tanhmã ujarẽnh to ho ri pa. Nẽ mẽ kãm ujarẽnh o: “E mẽ inhma. Koja Tĩrtũm tokyx mẽ pahwỳr mẽ panhõ Pahihti mẽ nhũm wrỳ nhũm mẽ piitã omu. Jakamã kwa mẽ tokyx kutêp tãm amnhĩ nhĩpêx o ri apa. Te ho mẽ kot mẽhõ kutêp pry ho mex pyràk o amnhĩ nhĩpêx o ri pa. Jao amnhĩ nhĩ ho tãm amnhĩ nhĩpêx nẽ tãm axpẽn nhĩpêx o ri apa. Pahihtita kutêp.” —Anhỹr o na pre hte finat Ijaisja kot Pahihti hkukamã harẽnh o ri pa xwỳnhta kukamã harẽnh anẽ. Tã paa. Pa na pre Ijaisja ã ixkukamã ijarẽnh anhỹr o pa. Pa na pa hte ã Pahihti kutêp mẽ kãm harẽnh o ri ixpa anẽ. Tã ã ixte harẽnh anhỹr xwỳnhta na ra mẽ pakamã pa ka mẽ kormã ja hã omunh kêt nẽ. Kukamã na pa hte mẽ piitã mẽ kot hkôt amnhĩ xunhwỳr ã mẽ omunh kaxyw gô pix o mẽ hkrã kumrãr o ri mẽ hkôt ixpa. Nom na pre ra mẽ pahwỳr Tĩrtũm kot mẽ pakaxyw ãm xwỳnhta tãm mẽ pahwỳr wrỳ. Àhpumunh tỳx o kot ijakrenh jakamã na pa hte ãm kukwak ri ixpa nẽ amnhĩ tã hã ixpijaàm o ri ixpa. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Tã nhũm apkati nhũm Juãw Paxis amnhĩ wỳr Jejus pumu nẽ mẽ kot mar o kuhê xwỳnhjê mã ĩhkra ho ahkre nẽ mẽ kãm: —E. Onẽj Tĩrtũm kot mẽ pakaxyw ãm xwỳnhta tẽ. Mẽ pahpê Ijaew na pu htem xatã pahte amnhĩ tomnuj pãnhã amnhĩrer kaxyw Tĩrtũm mã pahkrit ôwêhti hkra nyw kwỳ hpa nẽ ho amnhĩ pãnhã kãm amnhĩrer o papa. No kêt htẽm nẽj koja nhỹrmã kãm mẽ pahpiitã mẽ pahte amnhĩ tomnuj pãnhã amnhĩrer pa. ");
INSERT INTO apnNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Na pa pre ra mẽ amã harẽnh o: “Te pa ixte wa nẽ ixkator nẽ ixtĩr nẽ ixpa pyràk. Nom amnepêm kormã ixkêt ri na pre htĩr rãhã nẽ pa ho pa. Nẽ ĩ ho wrỳk nẽ jar kator tã kêp Tĩrtũm Kra jakamã uràk nẽ rãhã nẽ pa ho pa xwỳnh na. Jakamã kot amnhĩ to rax o kot ijakrenh par.” Anhỹr o pa pre mẽ amã harẽnh o ri ixpa ka prem inhma. ");
INSERT INTO apnNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","—Ixte mẽ amã ã harẽnh anhỹr tã ijaxwỳja kormã ixte kêp Tĩrtũm Kra hã omunh kêt nẽ ãm hkukamã Tĩrtũm nhỹ hã mẽ amã ã harẽnh anhỹr o ri ixpa. Nẽ hkukamã Tĩrtũm mã mẽ akrã kumrãr o ri ixpa. Tã na pa kêp Tĩrtũm Kra hã omu nẽ ã mẽ amã ahkre anẽ ka mẽ omu. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","33","Nhũm pre ã Juãw Paxis mẽ kãm Jejus jahkre anẽ nẽ mẽ kãm: —Nà Tĩrtũm na pre ixte mẽ akrã kumrãr o ixpa kaxyw inhmã hã karõ. Tã na inhmã kot mẽ pakaxyw ãm xwỳnhta o amnhĩrĩt nẽ inhmã harẽnh o: “Koja nhỹrmã Ixkarõja mẽhõ hwỳr wrỳ nẽ kuri arĩk. Ka ja hã omu nẽ kêp Ixkra hã omunh kurê kumrẽx. Koja amnhĩ xô ri amnhĩ pyrà nẽ mẽ kãm Ixkarõ nhõr o pa nhũm mẽ hkarõ mã agjê.” Anhỹr o inhmã harẽ. Tã na pa ra omu. Na pre Tĩrtũm Karõ kaxkwa rũm te tuuti pyrà nẽ hwỳr wrỳk o tẽ nẽ ĩkre hã xa. ");
INSERT INTO apnNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Pa ã kot hipêx anhỹr ã omu nẽ kêp Tĩrtũm Kra hã omunh kurê kumrẽx. Jakamã na pa ã mẽ amã ahkre nẽ mẽ amã harẽnh anẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Tã nhũm apkati nhũm Juãw Paxis axte Jejus pumu. Kot hkôt ri pa ho pa xwỳnh mẽ wa nhỹri xa nẽ omunh o xa. ");
INSERT INTO apnNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Nhũm ra mẽ hãnh tẽ nhũm Juãw Paxis omu nẽ hkôt ri pa xwỳnh wa kãm: —E onẽj Tĩrtũm kot mẽ pakaxyw ãm xwỳnhta tẽ. Nẽj koja mẽ pahte amnhĩ tomnuj pãnhã amnhĩre. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Hãmri nhũm wa kuma nẽ omu nẽ ma hkôt tẽ nẽ hã ajêt. ");
INSERT INTO apnNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Nhũm wa omu nẽ wa kãm: “Pa mo na?” Anẽ nhũm wa kot kêp mẽ ahkre xwỳnh ã omunh jakamã kãm: —Nà wa ixte ma akôt ixtẽm nẽ nhỹri anhõrkwỹ pumunh mã na pa wa akôt tẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Hãmri nhũm wa kãm: —Tôe. Nà wa kam nẽ rĩ ma ixkôt tẽ. Anẽ. Hãmri nhũm wa kuma nẽ ma hkôt wa tẽ nẽ õrkwỹ hwỳr pôj nhũm ra amỹkry nhũm wa hkôt axà nẽ kuri ỹr o kamàt hãmri nẽ kato nẽ ma akupỹm tẽ. ");
INSERT INTO apnNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Kôt htẽm xwỳnhjê hõta na pre kêp Andre. Simãw Pêtre htõ na pre. Nẽ kaxyw hõja. Wa kumã na pre Juãw Paxis Jejus jahkre nẽ harẽ nhũm wa ma hkôt tẽ. Tã wa ra akupỹm wa tẽ. ");
INSERT INTO apnNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Hãmri nhũm Andreja htõ Simãw wỳr tẽ nẽ kãm: —Kwa na pa wa jarãhã Tĩrtũm kot mẽ pakaxyw ãm xwỳnhta pumu. Ma pu hwỳr ka wa ixwar ano ho omu nà. Anẽ. Ijaew kapẽr kãm “Tĩrtũm kot mẽ pakaxyw ãm xwỳnh” anhỹrja te kot Gres kapẽr kãm “Kris” anhỹr jarẽnh pyràk. Ijaew na prem ã Jejus jarẽnh anẽ nẽ harẽnh o: “Tĩrtũm kot mẽ pakaxyw ãm xwỳnh.” Anhỹr o harẽ. ");
INSERT INTO apnNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Jakamã nhũm ã Andreja htõ mã harẽnh anẽ nẽ ma akupỹm hwỳr o tẽ. Nẽ wa hwỳr pôj nhũm wa omu. Wa kêp Juãw kra hã wa omu hãmri nẽ Simãw mã kapẽr nẽ kãm: —Pa Simãw. Nà apê Simãw tã kot paj axte atã anhĩxi hõ mẽ. Kot kaj mããnẽn apê Septi. Anẽ. Mẽ pakapẽr kãm Septija te kêp “kẽn” jarẽnh pyràk. No Gres kapẽr kãm te kêp “Pêtre” jarẽnh pyràk. No Ijaew kapẽr kãm kêp “Septi.” Jakamã nhũm pre Jejus ã Simãw Pêtre hã hixi mẽnh anẽ. ");
INSERT INTO apnNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","44","Tã nhũm apkati nhũm ra Jejus pyka pê Garirej wỳr nojarêt nẽ nhỹri Firipti pumu. Firiptija Andre mẽ Simãw Pêtre wa uràk nẽ krĩ pê Pesêj nhõ xwỳnh na pre. Jakamã nhũm Jejus nhỹri omu nẽ amnhĩ kôt kuwỳ nẽ kãm: —E kwa ma ri ixkôt apa ho apa. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Hãmri nhũm kuma nẽ ma tẽ nẽ nhỹri Natãnaew pumu nhũm nhỹri pĩ hpàr parpê nhỹ nhũm omu nẽ kãm: —Kwa na pa jarãhã finat Mojes kot amnepêm mẽhõ hã kagà xwỳnhta pumu. Tĩrtũm kot mẽ pakaxyw ãm xwỳnhta na. Tĩrtũm nhỹ hã kapẽr jarẽnh o mẽ pa xwỳnhjaja kot hkukamã harẽnh nẽ hã kagà xwỳnhta. Kêp Najare nhõ xwỳnh nẽ mããnẽn kêp finat Juje hkra. E kwa tokyx pu hwỳr ka ixkuxwar ano ho omu. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Hãmri nhũm tee ri kot tanhmã harẽnh toja ma nẽ kãm: —Tk. Kokỹ. Najare nhõ xwỳnh piitã kot amnhĩ to mexti hã kot kêt we hõ kêp Tĩrtũm kot mẽ pakaxyw ãm xwỳnh. Anẽ. Hãmri nhũm kãm: —Kwa nà ã akapẽr anhỹr kêt nẽ. Ma ixkôt tẽ nẽ ixpyrà nẽ ano ho omu mãn. Nẽ rĩ ã ri akapẽr anẽ. Anẽ. Hãmri nhũm kuma nẽ ma hkôt tẽ. ");
INSERT INTO apnNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Hãmri nhũm Jejus amnhĩ wỳr wa omu nẽ kuri mẽ kuhê xwỳnhjê mã Natãnaew jarẽnh kurê kumrẽx nẽ harẽnh o: —E onẽj Ijaew õja mẽ pahwỳr hpôx o tẽ. Ãm hãmri na hte tãm amnhĩ nhĩpêx o pa. Na hte higêt finat Jako kurom hêx rom ri tanhmã mẽ kãm amnhĩ to hêx to ho pa hkêt nẽ. Na hte ãm kapẽr mex pix o ri kapẽr o pa. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Hãmri nhũm tee ri amnhĩ tã kuma nẽ kãm: —Kwa mẽhõ na pre ã amã ijarẽnh anẽ? Aa ixte nhỹri apumunh kêt kumrẽx tã ka ri ãm hãmri ã ijarẽnh anẽ. Anẽ. Hãmri nhũm kãm: —Nà mẽhõ kot tanhmã inhmã ajarẽnh to hkêt. Ãm pa na pa hte inhno ho apumunh o ixpa. Kormã Firipti kot awỳr htẽm nẽ amã ijarẽnh kêt ri pa ra ixprĩ hã inhno ho apumu. Na ka kormã pĩta parpê nhỹ pa apumu. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Hãmri nhũm tee ri kot hprĩ hã harẽnh ã amnhĩ tã kuma nẽ kãm: —Kwa mẽ ijahkre xwỳnh. Pẽr ãm hãmri apê Tĩrtũm Kra kumrẽx jakamã na ka ã ijarẽnh anẽ. Xep ka na mẽ ixte amnhĩ wỳr akãm ijamak o ixpa xwỳnhta na ka. Nà ka na apê mẽ ixpê Ijaew nhõ Pahihti. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Hãmri nhũm Jejus kuma nẽ kãm: —Nà ãm hãmri na ka ixte pĩ hpar pê apumunh ã ajarẽnhja ma nẽ hkôt pix mã ixpê Tĩrtũm Kra hã ixpumu. Tã kot kaj ja nhĩrô pê axte mẽmoj mex o kot ja jakrenh pumu. ");
INSERT INTO apnNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Koja nhỹrmã kaxkwa axkjê nhũm Tĩrtũm kapẽr o mẽ wrỳk xwỳnhjaja kurũm axpẽn japa ka mẽ omu. Finat Jako pyrà nẽ mẽ omu. Ixte Tĩrtũm kot mẽ akaxyw ixãm xwỳnh wỳr koja mẽ ã wrỳk nẽ amnhĩ nhĩpêx anẽ ka ja hã mẽ omu. Kwa jam ajamaxpẽr tỳx rãhã ho apa. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Tã nhũm apkati axkrut nẽ hapêx nhũm Jejus arĩ Garirej kamã pa. Nhũm krĩ pê Kanã kamã axpẽn mã wahõj wa rer kaxyw nhũm Jejus katorxà ma mẽ hwỳr mõ. ");
INSERT INTO apnNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Hãmri nhũm mẽ amnhĩ wỳr Jejus mẽ hkôt ri mẽ ixpa xwỳnhjê wỳ pa mẽ ijaxwỳja ma mẽ hwỳr mõ nẽ ra mẽ hwỳr pôj. ");
INSERT INTO apnNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Hãmri nẽ mẽ hkôt wa hã ixkĩnh nẽ apku nẽ wĩhti hkwỳ ho ixkõm o ixkrĩ. Tã nhũm ra wĩhti mẽ kêp hapêx nhũm Jejus katorxàja harẽnh ma nẽ Jejus mã harẽ nẽ kãm: —Xê Jejus. Na xep ra mẽ kêp wĩhti hapêx pa. Xàt ka tanhmã mẽ ho ajuta hto mê? Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Hãmri nhũm kãm: —Tôe. Kwa tee ri ajamaxpẽr kêt nẽ. Kot paj tanhmã mẽ kãm ho. Nom kot paj kormã ixpê Tĩrtũm kot mẽ akaxyw ixãm xwỳnh ã pa kormã amnhĩ to amnhĩrĩt kêt nẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Hãmri nhũm katorxà kuma nẽ mẽ kãm mẽ àpênh xwỳnhjê hwỳr tẽ nẽ mẽ kãm: —An koja Jejus mẽ awỳr tẽ nẽ tanhmã mẽ amã mẽmoj tã karõ hto ka mẽ ama nẽ kãm ho anhỹr kurê kumrẽx. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Nhũm mẽ kuri kẽn o poti kêp 6 nẽ kuhê. Piitã umpỳm rũnh kumrẽx. Koja hõ pyxi nẽ nỳt nẽ kamã gô kêp 80 rit nẽ hkwỳ kamã kêp 100 rit. Ijaew na htem apkur kaxyw nẽ amnhĩ nhĩhkra kuhõnh japjê rũnh nẽ kormã apku. Nẽ apkur pa nẽ axte amnhĩ nhĩhkra kuhõ. Ã mẽ kot xatã amnhĩ nhĩhkra kuhõnh jakamã nhũm pre htem amnhĩ ri ã poti rũnh kwỳ xunhwỳr anẽ. No nhũm ra hkaprỳ nẽ kuhê. ");
INSERT INTO apnNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Hãmri nhũm Jejus tẽ nẽ omu mẽ àpênh xwỳnhjê mã kãm: —E mẽ ma mra nẽ gô ru nẽ ho poti kuhê mũj piitã ho nỳt pa. Anẽ. Nhũm mẽ kuma nẽ ma mra nẽ ho nỳt pa. ");
INSERT INTO apnNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Hãmri nhũm mẽ kãm: —Nà hãmri. Pãnhã hõ kamã gô hkwỳ janhi nẽ o tẽ nẽ mẽ anhõ patrãw mã agõ kê hkwỳ ho ixkõ nẽ kamã ama. Anẽ. Hãmri nhũm mẽ mar xà hkôt kãm hkwỳ janhi nẽ hwỳr o tẽ nẽ kãm kugõ. ");
INSERT INTO apnNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","10","Nom nhũm gôja arĩ kêp gô kumrẽx kêt nẽ. Jejus kot tanhmã ho jakamã nhũm ra hpãnhã kêp wĩhti. Jakamã nhũm mẽõ patrãw wỳr hkwỳ ho tẽ nẽ kãm kugõ nhũm hkaki nẽ kamã ama. Nom Jejus kot gô ho hipêx ã omunh kêt nẽ. Ãm htỳx ho wĩhti kumrẽx ã hkamnhĩx nẽ mex kumrẽx ã hkaki. Hãmri nẽ amnhĩ wỳr mjên nyw xwỳnh mã hpa ho apê nhũm hwỳr tẽ nhũm kãm: —Kwa na htem wĩhti mex o wa nẽ mẽ kãm kugõ hãmri nhũm mẽ hpenh pa nhũm mẽ rĩ kormã hkôt omnu ho hapu nẽ mẽ kãm kugõ. Tã ka pẽr mẽ axtem nẽ wam mẽ kãm omnu nhõr pa hãmri nẽ kormã mex kumrẽxja o hapu nẽ mẽ kãm agõ. Kêt wĩhti ja na mex kumrẽx. Ãm mex o mex. Anẽ. Jejus kot gô ho hipêx ã omunh kêt jakamã nhũm ã kãm kapẽr anẽ. Ãm mẽ àpênh xwỳnh pixjaja na prem ja hã omu. ");
INSERT INTO apnNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Nhũm Jejus kormã mẽ kãm aa mẽ kot mẽmoj pumunh kêt õ ho anhỹr kêt tã krĩ pê Kanã kamã ã mẽ kãm amnhĩ nhĩpêx anhỹr o hkrax. Jao amnhĩ to rax o amnhĩ to rax ã mẽ inhmã amnhĩ to amnhĩrĩt. Pa mẽ ixpê hkôt ri ixpa xwỳnhjaja ã kot amnhĩ nhĩpêx anhỹr ã omu hãmri nẽ kêp Tĩrtũm kot mẽ pakaxyw ãm xwỳnh ã omunh kurê kumrẽx. ");
INSERT INTO apnNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Tã nhũm Jejus hpãnhã ma krĩ pê Kapanaũ hwỳr mõ. Pa mẽ hkôt ri ixpa xwỳnhjaja nẽ katorxà nẽ htõjaja pa mẽ ma ixpiitã hkôt mõ. Hãmri nẽ hwỳr pôj nẽ kamã mẽ hkôt ixpa hã ixtã apkati grêre nẽ ma hpãnhã krĩ hõ hwỳr ixpa. ");
INSERT INTO apnNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Tã nhũm ra arĩgro pê Pas ahtêp o mõ. Pasja ã mẽ ixpê Ijaew na pa htem amnepêm Tĩrtũm kot pika pê Ejit rũm mẽ inhĩgêtjê kator mã ijamaxpẽr kaxyw axpẽn wỳr akuprõ nẽ hã ixkĩnh. Jakamã nhũm Jejus ma hkwỳjê hkôt krĩ pê Jerujarẽ hwỳr mõ. Pa mẽ ixpê hkôt ri ixpa xwỳnhjaja pa mẽ ma hkôt ixpa. Hãmri nẽ hwỳr pôj ");
INSERT INTO apnNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","nẽ Tĩrtũm mã amnhĩ jarẽnh xà hã ixkre hwỳr mra nẽ ixkre puhã kahêja wỳr agjê. Nhũm mẽ kamã axtem nẽ mẽmoj to wẽnê ho kuhê. Môx o wẽnê nẽ ôwêhti ho wẽnê nẽ tutre ho wẽnê ho kuhê. Mẽ kot haprôr nẽ ho Tĩrtũm mã hkĩnh xà kaxyw mẽ kãm ho wẽnê. Nẽ kàxpore ho pinhpanh xwỳnhjaja haxwỳja mẽ kuri hkrĩ. ");
INSERT INTO apnNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Hãmri pa mẽ Jejus kôt mẽ hwỳr agjê nẽ ja hã mẽ omu hãmri nhũm Jejus pê ja omnuj tỳx nẽ. Jakamã nhũm tee ri mẽ omu hãmri nẽ amnhĩm mry hkà ho mẽ htak xà nhĩpêx nẽ ho ixkreja nê mẽ piitã mẽ kator pa. Nẽ môx nẽ ôwêhti nẽ mẽmoj piitã kator pa. Nẽ kàxpore ho pinhĩpanh xwỳnhjaja nhũm mẽ kêp mẽ õ mêsti rẽnh pa nhũm mẽ hikàxpore pykap rôrôk pa nẽ anhgrà nẽ hikwỹ. ");
INSERT INTO apnNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Hãmri nhũm Jejus tutre ho wẽnê xwỳnhjê mã kãm: —Kwa mẽ anhõ tutre jamỳ nẽ tokyx ma mra. Na htem Inhĩpêêxà nhõrkwỹ kamã mẽmoj to wẽnê hkêt nẽ. Kêp mẽ ujaprôr xà hã ixkre hkêt. E kwa mẽ tokyx ma mra. Anẽ. Nhũm pre ã mẽ kãm kapẽr anẽ nhũm mẽ tee ri kuma hãmri nẽ ma mrar kurê kumrẽx. ");
INSERT INTO apnNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Pa mẽ hkôt mẽ ixpa ho ixpa xwỳnhjaja ã kot mẽ hipêx anhỹr ã omu hãmri nẽ ra Tĩrtũm kapẽr ã kagà htũm kot ã amnhĩ nhĩpêx anhỹrja kukamã hã kagàta mã ijamaxpẽr kurê kumrẽx. Kagà kot amnepêm Jejus kukamã te ra ã kapẽr anhỹr pyràk o harẽnh. Nẽ harẽnh kot: Na pa hte Tĩrtũm nhõrkwỹ ho mex rãhã ho ixpa. Nhũm mẽmoj punuj hwỳr axà pa omu nhũm ja inhmã mex kêt nẽ. Anhỹr o kot hkukamã harẽnh jakamã na pa mẽ ã Jejus kot mẽ hipêx anhỹrja ã omu hãmri nẽ ra hkukamã hã kagàta mã ijamaxpẽr kurê kumrẽx. ");
INSERT INTO apnNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Tã nhũm Ijaew krãhtũmjaja tee ri Jejus kot ixkreja nê mẽ kator ã omu hãmri nẽ hwỳr mra nẽ kãm: —Pa. Kwa mon ka ri ã Tĩrtũm mã amnhĩ jarẽnh xà hã ixkreja nê mẽ kator anẽ? Mẽhõ na we mẽ ixwỳr amẽ ka ỹ hã ã mẽ hipêx anẽhti? Nà xà Tĩrtũm na mẽ ixwỳr amẽ? E mẽ inhmã aa mẽ ixte mẽmoj pumunh kêt õ ho anẽ. Pa mẽ ja hã apumu hãmri nẽ Tĩrtũm kot mẽ ixwỳr amẽnh xwỳnh ã apumunh kurê kumrẽx. E kwa tokyx mẽ inhmã ho anẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Hãmri nhũm mẽ kuma nẽ mẽ kãm amnhĩ jarẽ. Nom amnhĩ tã kuxi nẽ mẽ kãm awjarẽ nẽ mẽ kãm: —Nà kot paj aa mẽ ate mẽmoj pumunh kêt õ ho pixi nẽ mẽ amã ho anẽ ka mẽ omu. Tĩrtũm nhõrkwỹ jaa. Kot kaj mẽ agrà pa ixtã apkati axkrunẽpxi nẽ akupỹm hipêx ka mẽ ja hã ixpumu. ");
INSERT INTO apnNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","22","Anhỹr o mẽ kãm kapẽr. No ãm ixkreja jarẽnh kêt nẽ. Na pre ãm amnhĩ tã kuxi nẽ ã mẽ kãm kapẽr anẽ. Mẽ kot hpĩr nhũm htyk ã apkati axkrunẽpxi nẽ akupỹm htĩr ã mẽ kãm ã amnhĩ jarẽnh anẽ. Te mẽ kot Tĩrtũm mã amnhĩ jarẽnh xà hã ixkreta grành nhũm hã apkati axkrunẽpxi nẽ akupỹm kot hipêx parta pyràk ã hã kuxi nẽ ã mẽ kãm amnhĩ jarẽnh anẽ. Jakamã nhũm mẽhprĩ hã mar mex kêt nẽ. Ãm tee ri kuma nẽ kãm: —Tk. Kwa ixkre ja na prem hipêx kaxyw nẽ hã amgrà xohtô rax nẽ hipêx. Hã amgrà pê 46 nẽ hipêx par kênã kot ka kêt atã apkati axkrunẽpxi pix nẽ akupỹm hipêx. Anẽ. Mẽ kot hprĩ hã mar kêt jakamã na prem ã kãm kapẽr anẽ. Pa mẽ hkôt mẽ ixpa ho ixpa xwỳnhjaja ã mẽ kãm kapẽr anhỹrja ã kuma nẽ hã inhnohtỳx rãhã ho ri ixpa. Tã nhũm mẽ kot Jejus pĩr nhũm hã apkati axkrunẽpxi nẽ akupỹm htĩr nhõ arĩgrota ã pa mẽ kot ã amnhĩ jarẽnh anhỹrja mã ijamaxpẽr kurê kumrẽx. Nẽ axpẽn mã: —Hêxta waa nẽ. Xep ãm hãmri na pre Pahihti amnhĩ kukamã ã amnhĩ jarẽnh anẽ. Mẽ kot hpĩr nhũm htyk ã apkati axkrunẽpxi nẽ akupỹm htĩr ã amnhĩ kukamã amnhĩ jarẽnh mex nẽ. Te mẽ kot Tĩrtũm nhõrkwỹ grành par nhũm hã apkati axkrunẽpxi nẽ akupỹm hipêx ã amnhĩ jarẽnh pyràk. Ãm hãmri na pre amnhĩ kukamã ã amnhĩ jarẽnh anẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Tã nhũm Jejus mẽ hkôt mẽ ixpa ho ixpa xwỳnhjaja arĩ Jerujarẽ kamã ri ixpa ho ixpa. Nhũm ra arĩgro pê Pasja kato nhũm mẽ piitã hkĩnh kaxyw axpẽn wỳr akuprõ. Nhũm Jejus mẽ kãm aa mẽ kot mẽmoj pumunh kêt kwỳ ho anhỹr o ri mẽ hkôt pa. Nhũm mẽ omu nhũm mẽ hkwỳjaja Tĩrtũm kot mẽ pakaxyw ãm xwỳnh ã hkôt hamaxpẽr tã no ãm hkôt hamaxpẽr tỳx kêt nẽ. ");
INSERT INTO apnNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Jakamã nhũm Jejus amnhĩ tã mẽ hamaxpẽr ã mẽ omu nẽ hamaxpẽr o: —Nà mẽ kot ixkôt hamaxpẽr kryre xwỳnhjaja koja mẽ hã apkati grêre nẽ ixto hamakêtkati nẽ htỳx ri pa. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Jejus kot mẽ pahte pahtỳx ri amnhĩ tomnuj o papa hã mẽ pahpumunh par. Nẽ pahtỳx ri pajamaxpẽr punuj o papa hã mẽ pahpumunh par. Jakamã na pre ã mẽ harẽnh anẽ. ");
INSERT INTO apnNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Tã nhũm Parijew nhõ xwỳnhjê õ pê Nĩkotẽ. Mããnẽn kêp Ijaew krãhtũmjê hõ. ");
INSERT INTO apnNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Jakamã na pre Jejus jarẽnh ma nẽ kãm omunh prãm nẽ. Hãmri nẽ hkwỳ pymaj kamàt kãm hwỳr tẽ nẽ omu nẽ kãm: —Pa mẽ ijahkre xwỳnh. E ot pa awỳr tẽ. Ra mẽ ixte apumunh mex. Tĩrtũm na pre ate mẽ ijahkre ho apa kaxyw mẽ ixwỳr amẽ ka mẽ ixwỳr wrỳ. Mẽhõ koja apyrà nẽ aa mẽ inhmã mẽ kot mẽmoj pumunh kêt kwỳ ho anhỹr o pa? Nà amrakati kumrẽx. Kop apu Tĩrtũm kot mẽ ixwỳr amẽnh kêt ronhỹx ka ã amnhĩ nhĩpêx anhỹr kêt nẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Hãmri nhũm kuma nẽ tanhmã kãm kapẽr to. No ãm amnhĩ tã kuxi nẽ kãm awjarẽ nẽ kãm: —Na htem piitã mẽ katorxà nhõxà hkre rũm hapôj. Tã Tĩrtũm kãm mẽ piitã axte mẽ hapôx prãm. Jakamã kot kaj mẽ akator o axkrut kêt nẽ hãmri nẽ nhỹrmã Tĩrtũm ri atĩr tũm nẽ apa ho apa hkêt nẽ. Ãm hkrajê pix na htem kuri htĩr tũm nẽ pa ho pa. Jakamã kwa jam ajamaxpẽr tỳx nẽ ri ho apa. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Hãmri nhũm Nĩkotẽja kuma nẽ tee ri ã kot kãm kapẽr anhỹrja kukamã hamaxpẽr nẽ kãm: —Kwa ra ixàptàr kênã kot pa kêt tanhmã amnhĩ to nẽ akupỹm ixkatorxà nhõxà hkre hwỳr axà nẽ axte kurũm ixkato. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","7","Hãmri nhũm Jejus kãm: —Nà na hte mẽ hkrarejaja mẽ katorxà nhõxà hkre rũm kagô hkôt hapôj hãmri nẽ kêp katorxà mẽ hipêêxà wa hkwỳỳ. Jao wa kot amnhĩ nhĩpêx kôt amnhĩ nhĩpêx o pa. Ja pyrà nẽ ka mẽ atõ amã apê Tĩrtũm kra hprãm hã kot kaj amnhĩ to awỳ nhũm wa Ixkarõja akarõ mã axà hãmri ka ra apê hkraa. Te ra axte akator pyràk o amnhĩ nhĩpêx. Nẽ te mẽ hkra kot katorxà nẽ hipêêxà wa kot amnhĩ nhĩpêx kôt amnhĩ nhĩpêx o pata pyrà nẽ apãm Tĩrtũm kot amnhĩ nhĩpêx kôt amnhĩ nhĩpêx o ri apa. Nom koja Tĩrtũm mẽ wa Ixkarõja akarõ mã àr kêt nẽ ka apê hkra hkêt nẽ. Jao te axte akator kêt pyràk o amnhĩ nhĩpêx. Jakamã na pa amã te ate akator pijakrut o amnhĩ nhĩpêx pyràk o amã ã ja jarẽnh anẽ. Kwa jam ajamaxpẽr tỳx rãhã ho ri apa. No ama nẽ tee ri amnhĩ kukamã ajamaxpẽr kêt nẽ. ");
INSERT INTO apnNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","—E pa ixprĩ hã amã ja jarẽ ka inhma. Na hte kôk kãm nhỹhỹm àpêr prãm xà hkôt àpêr o pa. Pu mẽ kamã ama no ãm pano ho nhỹhỹnh mõr xà hkôt omunh kêt nẽ. Nẽ nhỹhỹm ma mõr xà hkôt omunh kêt nẽ. Ja pyrà nẽ na hte Tĩrtũm mẽ wa Ixkarõja mẽ hkaxwỳnh mã agjê nẽ mẽ ho Tĩrtũm kra nom nhũm mẽhprĩ hã kot tanhmã mẽ ho hã amnhĩ tã omunh kêt nẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Hãmri nhũm Nĩkotẽ ã Jejus kot kãm kapẽr anhỹr ã kuma nẽ tee ri hamaxpẽr nẽ kãm: —Kwa na pa ixprĩ hã amar kêt nẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Hãmri nhũm kãm: —Kwa mon ka hte Tĩrtũm kapẽr tũm o Ijaew jahkre ho apa tã aprĩ hã ixkapẽr mar kêt nẽ? ");
INSERT INTO apnNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Ixte mẽmoj pumunh xà hkôt ixte mẽ amã harẽnh o ixpa htã ka mẽ apê Ijaew krãhtũmjaja mẽ amã ixkapẽr mar prãm kêt nẽ. Ã mẽ ate anhỹr kumrẽx. Kwa jam ajamaxpẽr tỳx nẽ. ");
INSERT INTO apnNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Na pa ra Tĩrtũm kot jar tanhmã amnhĩ nhĩpêx to hã harẽnh o ixpa htã ka mẽ ãm ama nẽ ixkôt ajamaxpẽr kêt nẽ. Jakamã xà kot pa hpãnhã mẽ amã kaxkwa kamã tanhmã kot amnhĩ nhĩpêx to hã harẽ ka mẽ ama nẽ mar tỳx nẽ? Nà kot ka mẽ ama nẽ ãm ama nẽ hkôt ajamaxpẽr kêt nẽ. ");
INSERT INTO apnNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Mẽhõ na we ra ma kaxkwa hwỳr api nẽ kamã mẽmoj mex pumu nẽ man akupỹn mẽ awỳr wrỳ nẽ mẽ amã tanhmã harẽnh to? Nà amrakati kumrẽx. Ãm paxipix ixpê Tĩrtũm kot mẽ akaxyw ixãm xwỳnh na pa pre amnẽ kurũm mẽ awỳr wrỳ hãmri nẽ ixprĩ hã mẽ amã tanhmã harẽnh to ho ri ixpa. ");
INSERT INTO apnNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","—Amnepêm finat Mojesja kormã kapôt ã mẽ o pa ri na pre mẽ kãm kàx o kagã karõja nhĩpêx nẽ kỳxpê mẽ kãm kunhô. Kagã kot mẽ hkamnhar xwỳnhjaja kot hwỳr rĩt nẽ omunh nẽ akupỹm mex kaxyw mẽ kãm kunhô. Tã ixpê Tĩrtũm kot mẽ akaxyw ixãm xwỳnh kot paj nhỹrmã kagã karõta pyrà nẽ kỳx pê pĩ kahpa hã ajêt. ");
INSERT INTO apnNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Ka mẽ te mẽ kot kagã karõ pumunh nẽ akupỹm mexta pyrà nẽ amnhĩ kaxyw inhmã ajamaxpẽr nẽ ixkôt amnhĩ xunhwỳ hãmri nẽ nhỹrmã Tĩrtũm mẽ wa ixri atĩr tũm nẽ amex rãhã nẽ apa ho apa. ");
INSERT INTO apnNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","—Tĩrtũm kãm pika piitã hkôt mẽ apiitã mẽ ajapê htỳx. Nẽ mẽ ajapê xàj na pre ixpê Kra hã ixpyxi hã mẽ awỳr inhmẽ. Ka mẽ atõ amnhĩ kaxyw ixkôt ajamaxpẽr nẽ ixkôt amnhĩ xãm. Hãmri nẽ nhỹrmã atyk tã nhũm Tĩrtũm akupỹm ato atĩr ka wa ixkuri atĩr tũm nẽ amex rãhã nẽ apa ho apa. Hãmri nhũm Tĩrtũm aa amnhĩ nê nhỹhỹm amẽnh kêt kumrẽx. ");
INSERT INTO apnNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","No mẽ ate amnhĩ tomnuj mỳrapê tanhmã ixte mẽ anhĩpêx to kaxyw na pre mẽ awỳr inhmẽnh kêt nẽ. Ãm ixkukwak ri mẽ atĩr tũm nẽ mẽ amex rãhã apa ho apa hprãm xàj na pre mẽ awỳr inhmẽ pa mẽ awỳr wrỳ. ");
INSERT INTO apnNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Jakamã kot ka mẽ atõ amnhĩ kaxyw ixpê Tĩrtũm Kra hã ixkôt ajamaxpẽr nẽ ixkôt amnhĩ xãm nhũm Tĩrtũm ixtã apumu nẽ ate amnhĩ tomnuj mỳrapê tanhmã anhĩpêx to hkêt nẽ. No kêt mẽ kot ixkôt amnhĩ xunhwỳr kêt xwỳnhjaja na Tĩrtũm ma mẽ kot amnhĩ xà htỳx kamã hamak tũm xà hwỳr mẽ pa mã xwỳnhjê hã mẽ harẽ. Mẽ kot ixkôt amnhĩ xunhwỳr kêt mỳrapê. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Nhũm Jejus arĩ Nĩkotẽ mã kapẽr nẽ kãm: —Na pre Tĩrtũm amnẽ pika hwỳr mẽ awỳr inhmẽ. Mẽ ate amnhĩ tomnuj xwỳnh ã amnhĩ pumunh kaxyw mẽ awỳr inhmẽ. Tã nhũm mẽ ohtô nẽ amnhĩ tomnuj gryk ã kãm kapẽr mar prãm kêt nẽ. Jao ixkaga nẽ kãm ixkapẽr mar prãm kêt nẽ. ");
INSERT INTO apnNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Ra ixprĩ hã ixte mẽ kot tanhmã amnhĩ tomnuj to ho pa hã mẽ omunh mex jakamã mẽ kãm ixkapẽr mar prãm kêt. Nẽ ixte mẽ kot tanhmã amnhĩ tomnuj to ho pa hã mẽ harẽnh pymaj ixkôt kãm pa hprãm hkêt nẽ. ");
INSERT INTO apnNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","No kêt mẽ kot ixkôt amnhĩ xunhwỳr xwỳnhjaja na mẽ kot amnhĩ nhĩpêx o pa hã hpijaàm kêt. Na htem àmnhĩx ixkôt amnhĩ nhĩpêx o pa. Jakamã koja mẽ piitã ja hã mẽ omu nẽ Tĩrtũm kot tanhmã mẽ hkrã hto nhũm mẽ ra kãm hkôt pix mã amnhĩ nhĩpêx ho pa hprãm ã mẽ omunh kurê kumrẽx. Anẽ. Nhũm pre ã Jejus Nĩkotẽja mã kapẽr anẽ. ");
INSERT INTO apnNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Tã pa mẽ ixpê Jejus kôt ri ixpa ho ixpa xwỳnhjaja Jejus kôt Jerujarẽ rũm ijapôj nẽ pika pê Jutej kwỳ kamã ixpa. Jejus nhỹ hã Tĩrtũm mã mẽ hkrã kumrãr o ri mẽ hkôt ixpa. ");
INSERT INTO apnNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Nhũm finat Juãw Paxis haxwỳja mẽ ixpyrà nẽ mẽ hkrã kumrãr o pa. Krĩ pê Sarĩ htã krĩ pê Enõ mỳri pyhti rax jakamã nhũm pre htem hwỳr mra nhũm kamã mẽ hkrã kumrã. ");
INSERT INTO apnNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Kormã mẽ kot haxàr kêt ri nhũm kamã mẽ hkrã kumrãr o pa. ");
INSERT INTO apnNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Rôm nhũm Ijaew hõja Juãw Paxis kôt mẽ pa ho mẽ pa xwỳnhjê hwỳr tẽ nẽ Juãw Paxis kot mẽ hkrã kumrãr ã tanhmã mẽ hkukjêr to nhũm mẽ kuma nẽ tee ri hã axpẽn kukjêr o kuhê. ");
INSERT INTO apnNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Hãmri nẽ akupỹm Juãw Paxis wỳr tẽ nẽ kãm: —Kwa mẽ ijahkre xwỳnh. Pyhti pê Jotãw nhĩkjê hã ate mẽhõ pumunh nẽ tanhmã mẽ inhmã harẽnh to xwỳnhta kôt mẽ pa ho mẽ pa xwỳnhjaja na xep htem apyrà nẽ mẽ hkrã kumrãr o pa nhũm xep mẽ ra ohtô nẽ mẽ pahkaga nẽ mẽ hkôt pa. Kwa xà ja amã mex nà? Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Hãmri nhũm mẽ kuma nẽ mẽ kãm: —Tỳ ja mex kênã. Tĩrtũm kãm hprãm xà hkôt na htem mẽ hwỳr mra nhũm mẽ ixpãnhã mẽ hkrã kumrã. Nà ja mex. ");
INSERT INTO apnNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Ixpê Tĩrtũm kot mẽ pakaxyw ãm xwỳnh kêt. Na pa pre ra mẽ amã ja hã amnhĩ jarẽ ka prem inhma. Ãm hkukamã na pre Tĩrtũm amnẽ inhmẽ pa mõ nẽ ã jar ri ixpa anẽ. ");
INSERT INTO apnNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","—Te ixte mẽ umre kot amnhĩ nhĩpêx pyràk. Na htem axpẽn mã mẽ rer kaxyw nhũm mẽ umreja myta wỳr tẽ nẽ hpa hã kupy nẽ ma ni hwỳr o tẽ nẽ axpẽn mã wa kure. Hãmri nhũm hpãnhã mẽhõja axpẽn tã wa hakre. Nhũm umreja wa kuri hkĩnh nẽ mar o xa. Tã te ixte mẽ umre kot amnhĩ nhĩpêx pyràk jakamã koja mẽ ma Tĩrtũm kot mẽ pakaxyw ãm xwỳnhta wỳr mra nẽ kapẽr ma pa mẽ harẽnh ma nẽ ixkĩnh nẽ. ");
INSERT INTO apnNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Na htem mẽ umre hã hkĩnh kêt nẽ. Mjên nyw xwỳnhja ã na htem hkĩnh. Tã ja pyrà nẽ koja mẽ axte ixte mẽ kãm Jejus jarẽnh mar kaxyw ixwỳr mrar kêt nẽ. Ãm hwỳr koja mẽ hpãnhã mra nẽ tãm mar o kuhê. Ja mex kumrẽx. ");
INSERT INTO apnNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Jejus kêp kaxkwa rũm amnẽ mẽ pahwỳr wrỳk xwỳnh jakamã kot amnhĩ to rax o kot mẽ pahpiitã mẽ pajakrenh par. Mẽ papajaja mẽ pahpê pika nhõ xwỳnh jakamã Jejus kĩnhã mẽ pahte mẽmoj piitã omunh tohtuj anhỹr. Nẽ pika nhõ xwỳnhjê jamaxpẽr pix o pajamaxpẽr o ri papa. ");
INSERT INTO apnNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","—Na hte Jejus mẽ kãm kaxkwa kamã kot mẽmoj pumunh xwỳnh kwỳjê jarẽnh o pa. Nẽ kamã kot mẽmoj mar xwỳnh kwỳ jarẽnh tã nhũm mẽ ohtô nẽ kuma nẽ ãm kuma. ");
INSERT INTO apnNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","No mẽ kot mar nẽ amnhĩ kaxyw hkôt hamaxpẽr xwỳnhjaja na htem kuma nẽ axpẽn mã harẽnh o: “Nà ãm hãmri na ã Tĩrtũm kapẽr jarẽnh anẽ. Nà Tĩrtũm kapẽr mex kumrẽx.” Anhỹr o axpẽn mã harẽ. ");
INSERT INTO apnNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","—Tĩrtũm na pre mẽ pahwỳr Jejus mẽ nhũm amnẽ mẽ pahwỳr wrỳ nẽ Tĩrtũm Karõ nhỹ hã mẽ pamã kapẽr jarẽnh o ri mẽ pahkôt pa. ");
INSERT INTO apnNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Tĩrtũm kãm Krata japê htỳx kumrẽx jakamã na pre ĩhkram mẽmoj piitã haxàr pa nhũm uràk nẽ hihtỳx o hihtỳx nẽ mẽmoj piitã ho amnhĩptàr o pa. ");
INSERT INTO apnNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Jakamã mẽ kot amnhĩ kaxyw hkôt hamaxpẽr nẽ hkôt amnhĩ xunhwỳr xwỳnhjaja koja mẽ nhỹrmã wa kuri htĩr tũm nẽ mex rãhã nẽ pa ho pa. No mẽ kot hkaga xwỳnhjaja koja mẽ ã amnhĩ nhĩpêx anhỹr kêt nẽ. Koja Tĩrtũm mẽ kot amnhĩ xà htỳx kamã hamak tũm xàta wỳr mẽ rẽnh pa. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Tã nhũm Parijew nhõ xwỳnhjaja Jejus jarẽnh ma. Nẽ hkôt mẽ pa xwỳnhjaja ohtô rax o Juãw Paxis kôt mẽ pa xwỳnhjê jakrenh ã mẽ harẽnh ma. Nẽ Jejus kot mẽ hkrã kumrãr rax o Juãw Paxis jakrenh ã harẽnh ma. ");
INSERT INTO apnNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Nom Jejus na pre mẽ hkrã kumrãr kêt nẽ. Ãm mẽ ixte hkôt ri mẽ ixpa ho mẽ ixpa xwỳnhjaja na pa prem kãm mẽ hkrã kumrãr o ri ixpa. ");
INSERT INTO apnNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Jakamã nhũm Jejus amnhĩ tã Parijew nhõ xwỳnhjê jarẽnh ma hãmri nẽ mẽ kêp kato nẽ hpãnhã ma akupỹm Garirej wỳr mõ pa mẽ ma hkôt ixpa. ");
INSERT INTO apnNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Tã pa mẽ mõ nẽ kormã pyka pê Samar mã axà nẽ hkôt ixpa. ");
INSERT INTO apnNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Hãmri nẽ krĩ pê Sika hwỳr ixpôx o mõ. Amnepêm finat Jako kot hkra Juje mã pyka nhõr xwỳnh tã krĩja xa pa mẽ ra hwỳr ixpôx o mõ. ");
INSERT INTO apnNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Nẽ amnepêm Jako kot gôm kakwỳnhta wỳr pôj. Nhũm ra kaxkwa nhĩpôk ri myt nhỹr mẽ nhũm Jejus ra mrar ryy kurê hkẽngrà nẽ. Hãmri nẽ gôm kakwỳnh mỳ ri tẽm nẽ hkôkôt o nhỹ. ");
INSERT INTO apnNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Hãmri pa mẽ kure nẽ mẽ ixàpkur xà japrôr kaxyw ma krĩm ijapêx. Rôm nhũm Samar nhõ xwỳnh nija amnhĩm gô runh mã tẽ nhũm Jejus omu nẽ kãm: —Kwa inhmã anhõ gôta kwỳ pa ho ixkõ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Nhũm amnhĩ jaêr pê amnhĩ tã kuma. Ijaew na pre htem Samar nhõ xwỳnhjê kutã apkur rỳ mẽ hkôt ri pa rỳ mẽ ho mjên kêt nẽ. Rỳ mẽ kutã hkõm kêt nẽ. Tã nhũm Jejus ã gô hã nija wỳr anẽ nhũm tee ri amnhĩ tã kuma nẽ kãm: —Xê pẽr apê Ijaew tã axtem nẽ ri gô hã ixwỳ. Xà ate ixpê Samar nhõ xwỳnh ã ixpumunh kêt? Hãn ka ri hã ixwỳ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Hãmri nhũm kuma nẽ kãm amnhĩ jarẽ. No ãm amnhĩ tã kuxi nẽ kãm kapẽr nẽ kãm: —Nà aprĩ hã ate ixpumunh ro nhỹx ka kam gô hã ixwỳ pa amã hkwỳ. Inhõ gô na axte mã. Tĩrtũm kãm amarĩ mẽ amã õr prãm. Na htem ho ixkõ hãmri nẽ mex nẽ htĩr tũm nẽ pa ho pa. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Hãmri nhũm tee ri kot ã õ gô jarẽnh anhỹrja ã kuma nẽ htỳx ho gôm kakwỳnh kamã gô hã hkamnhĩx nẽ tee ri hkukamã hamaxpẽr nẽ kãm: —Xê tanhmã kot ka kêt amnhĩ to nẽ inhmã gôta kwỳ janhi? Mo kaxyw anhõ gô janhir xà? Gôm kakwỳnhta upỳm rax kênã kot ka kêt tanhmã amnhĩ to nẽ hkwỳ janhi. Nhỹhỹnh kot ka anhõ gô jarẽnh xwỳnhta kwỳ janhi pa ho ixkõ hãmri nẽ ixtĩr tũm nẽ ixpa ho ixpa? ");
INSERT INTO apnNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Mẽ inhõ gôm kakwỳnhja amnepê mã mẽ panhĩgêt finat Jako nhõ gôm kakwỳnh na pre. Jako hkwỳjaja na prem hkakwỳ nhũm kamã gô kato nhũm pre htem hanhi nẽ ho hkõm o pa. Nẽ hkrajaja nẽ hkrit piitã ho hkõm o pa. Jakamã na pre mẽ ixpê hkanrẽhã htàmnhwỳjê mã hkaga. Tã xep axtem anhõ gô. Mẽ kot ho hkõm nẽ htĩr tũm kaxyw na xep. Jakamã xê xà ate amnhĩ to rax o mẽ panhĩgêt Jako jakrenh mê? Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Hãmri nhũm Jejus kãm: —Nà mẽ anhõ gôta na htem ho ixkõ nẽ arĩ kãm kôr o pa. ");
INSERT INTO apnNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","No ixte amã gô jarẽnh xwỳnhta kot ka hkwỳ ho ixkõ hãmri nẽ axte amã kôr kêt kumrẽx nẽ apa. Nhũm te akaxwỳnh kãm hinore hprõt pyràk o ka amnhĩ nhĩpêx. Hãmri nẽ te hinore kamã gôja aa grà hkêt pyrà nẽ aa ajapêx kêt kumrẽx. Nhỹrmã atyk tã akupỹm atĩr nẽ atĩr tũm nẽ amex rãhã apa ho apa. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Nhũm nija kuma hãmri nẽ kãm: —Xôwehe? Xê tô tokyx inhmã anhõ gôta kwỳ. Pa ho ixkõ nẽ axte inhmã kôr kêt nẽ ixpa. Nẽ axte amnẽ amnhĩm gô janhir mã inhmrar kêt nẽ. Xê tokyx inhmã hkwỳ mê? Anẽ. Tỳx gô kumrẽx ã hkamnhĩx nẽ ã hã àhwỳr anẽ. ");
INSERT INTO apnNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Hãmri nhũm kãm: —Tô ma akupỹm krĩm tẽ nẽ amjên japrô nẽ man akupỹn ixwỳr wa tẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Hãmri nhũm tee ri kuma nẽ kãm: —Ma mo inhmjên? Inhmjên kêt na pa hte ri ixpa. Anẽ. Hãmri nhũm kãm: —Tỳ. Nà ãm hãmri na ka ã amnhĩ jarẽnh anẽ. ");
INSERT INTO apnNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Na ka pre ra amjên kêp 5. Nẽ my mẽ ri war apa xwỳnh ata te kêp amjên pyràk nom kêp amjên kumrẽx kêt. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Hãmri nhũm amnhĩ jaêr pê kot ã kãm kapẽr anhỹrja ma hãmri nẽ kãm: —Xê pẽr aprĩ hã ate ixpumunh par pyràk. Mãn apê Tĩrtũm nhỹ hã kapẽr jarẽnh o mẽ pa xwỳnhjê hõ mãn ka mê? ");
INSERT INTO apnNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Xê inhmã mẽmoj jarẽ. Nhỹhỹm kot paj wem axpẽn kôt mra nẽ Tĩrtũm mã mex o mex ã harẽ? Amnepê mã mẽ panhĩgêtjaja na prem hixêt mũj nhĩmõk ã api nẽ hã kãm amnhĩ jarẽ nẽ kãm mex o mex ã harẽ. No mẽ apê Ijaew na ka htem krĩ pê Jerujarẽ pix kãm mẽ ixte axpẽn kôt mrar nẽ ã amnhĩ nhĩpêx anhỹr ã mẽ inhmã karõ. Xà hixêt nhĩmõk ã mẽ ixte kãm amnhĩ jarẽnhja xà apê omnuj mê? Ma xà apê omnuj kêt? Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Hãmri nhũm Jejus kãm: —Nà kot kaj mẽ nhỹrmã ãm Jerujarẽ pix kãm rỳ hixêt mũj nhĩmõk pix ã axpẽn wỳr akuprõ nẽ Tĩrtũm mã amnhĩ jarẽnh kêt nẽ. ");
INSERT INTO apnNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Mẽ apê Samar nhõ xwỳnhjaja mẽ ate Tĩrtũm mã mex o mex ã harẽnh o apa htã aprĩ hã kot amnhĩ nhĩpêx ã omunh kêt. Nẽ tanhmã hamaxpẽr to ho pa hã omunh kêt. No mẽ ixpê Ijaew na pa mẽ arom kot tanhmã amnhĩ nhĩpêx to nẽ tanhmã hamaxpẽr to hã omunh mex. Mẽ inhĩõ kukwak ri koja Tĩrtũm mẽ kot hkôt amnhĩ xunhwỳr xwỳnh piitã nê mẽ kot amnhĩ tomnuj rênh pa. ");
INSERT INTO apnNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Tã koja mẽ piitã Mẽpahpãm Tĩrtũm mã mex o mex ã harẽnh kaxyw nhỹhỹm pa hkêt nẽ. Koja mẽ nhỹri pa xà kamã mẽ õpinh xà kaxwỳnh kãm ã kãm amnhĩ jarẽnh anhỹr o pa. Ja na Tĩrtũm kãm hprãm. No nhỹhỹm mrar nẽ nhỹri kuhê xà pix kamã kãm amnhĩ jarẽnhja nhũm kãm hprãm kêt nẽ. ");
INSERT INTO apnNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","—Nẽ Tĩrtũmja mẽ pahpyrà nẽ ĩ hkêt jakamã na te kaxkwa nẽ pika piitã hkôt pa ho pa. Jakamã na htem nhỹri pa nẽ õpinh xà kaxwỳnh kãm amnhĩ kaxyw kãm hamaxpẽr nẽ kãm mex o mex ã harẽ nhũm ra amnhĩ tã mẽ kuma. Ã mẽ kot amnhĩ nhĩpêx anhỹrja na kãm hprãm. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Nhũm pre ã Jejus nija mã kapẽr anẽ nhũm kuma nẽ kãm: —Ma koja xep nhỹrmã Tĩrtũm kot mẽ pakaxyw ãm mã xwỳnh pê Krisja mẽ pahwỳr wrỳ hãmri nẽ hprĩ hã mẽ pamã mẽmoj piitã ho amnhĩrĩt pu mẽ kuma. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Hãmri nhũm kãm: —Kwa nhũm paa. Ixte amã ixkapẽr xwỳnhja ixpê Kris na pa. Jakamã na pa ixprĩ hã amã ã ixkapẽr anẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Nhũm pre ã kãm amnhĩ jarẽnh anhỹrja rôm pa mẽ ixte hkôt ri mẽ ixpa ho ixpa xwỳnhjaja ra ixujaprôr pa nẽ akupỹn hwỳr ixpôx o mra. Hãmri nẽ amnhĩ jaêr pê kot Samar nhõ xwỳnh nita mã kapẽr ã omu nẽ tee ri hkukamã ijamaxpẽr nom tanhmã hã hkukjêr to hkêt nẽ. Nija kêp Samar nhõ xwỳnh tã nhũm àmnhĩx kãm kapẽr o nhỹ. Pa mẽ omu nẽ ãm omu nẽ tanhmã hã kãm nẽ hkêt nẽ. ");
INSERT INTO apnNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Hãmri nhũm nita gôm kakwỳnh mỳr ri õ poti re nẽ ma akupỹm krĩm tẽ nẽ hkwỳjê mã awjarẽ. ");
INSERT INTO apnNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","Nẽ mẽ kãm: —Xê mẽ tokyx ma ixkôt gôm kakwỳnh wỳr mra nẽ mỳ ri mẽhõ my mũj pumu. Tĩrtũm kot mẽ pahwỳr mẽnh mã xwỳnhta na. Aa kot nhỹri ixpumunh kêt tã kot hprĩ hã ixpumunh par. Ixte tanhmã amnhĩ nhĩpêx to hã ixpumunh par. Xê mẽ ma ixkôt mra nẽ ixpyrà nẽ kapẽr ã ama. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Hãmri nhũm mẽ kuma nẽ ma hkôt Jejus wỳr mrar kurê kumrẽx. ");
INSERT INTO apnNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Rôm pa mẽ ixte Jejus kôt ri ixpa ho ixpa xwỳnhjaja tee ri mẽ ixàpkur xà ho Jejus ma nẽ kãm: —E ota mẽ panhõta. Kwa mẽmoj py nẽ aku mãn. ");
INSERT INTO apnNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Anhỹr tã nhũm mẽ inhma nẽ tanhmã mẽ inhmã amnhĩ jarẽnh to. Nom amnhĩ tã kuxi nẽ amnhĩ jarẽ nẽ mẽ inhmã: —Nà kormã. Inhõja axtem na. Mẽ ate inhõja pumunh kêt. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Hãmri pa mẽ kuma nẽ tee ri hã axpẽn kukja nẽ axpẽn mã: —Kwa mãn ra mẽhõ mẽ paxwakre kamã kãm mẽmoj to tẽ nhũm kukrẽ nà? Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Hãmri nhũm mẽ inhma nẽ mẽ inhmã: —Nà mẽhõ kot kêt ri inhmã mẽmoj to mra pa kuku? Kot paj kot mẽ awỳr inhmẽnh xwỳnhta mã tanhmã amnhĩ nhĩpêx to hãmri nẽ te ra ixàpkur mex nẽ hã ixihtỳx mex pyràk o amnhĩ nhĩpêx. Tã kot paj ã kãm amnhĩ nhĩpêx anhỹr o ri ixpa rãhã ho ijapêx pa. Jao te ixàpkur rax pyràk. ");
INSERT INTO apnNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Anhỹr o mẽ inhmã amnhĩ jarẽ. Hãmri nẽ ra Samar nhõ xwỳnhjaja mẽ ixwỳr mrar ã mẽ omu nẽ mẽ inhmã tanhmã mẽ harẽnh to nom mẽ hã kuxi nẽ mẽ harẽ nẽ mẽ harẽnh o: —Kot kaj mẽ axte mẽ atã mytwrỳ kêp 4 hãmri nhũm ra mẽ apur kãm mẽ anhõja hamỳnh mã tãm nẽ. Nom kormã. E ka mẽ pahwỳr mẽ mrar xwỳnh nẽj pumu. Ra mẽ kot amnhĩ kaxyw ixkôt hamaxpẽr nẽ ixkôt amnhĩ xunhwỳr mã tãm jakamã te mẽ apur kãm ra mẽ anhõ jamỳnh mã tãm pyràk. Jakamã ka mẽ atõ ma mẽ hwỳr mõ nẽ mẽ kot amnhĩ kaxyw ixkôt hamaxpẽr nẽ ixkôt amnhĩ xunhwỳr kaxyw mẽ kãm ijarẽ. Hãmri nẽ te ate ixpur kãm inhmã inhõ jamỳnh xwỳnh pyràk o amnhĩ nhĩpêx. ");
INSERT INTO apnNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","—Jakamã koja mẽhõ kumrẽx mẽ hwỳr tẽ nẽ mẽ kãm Tĩrtũm kapẽr jarẽ hãmri nẽ te kêp õ pahi mã hpur kãm ahkre ho pa pyràk. Nhũm mẽ kot mar xwỳnhjaja kuma nom kormã hprĩ hã mar tỳx kêt nẽ. Tã kot kaj mẽ atõ wamta kôt mẽ hwỳr tẽ nẽ mẽ kot ixkôt amnhĩ xunhwỳr kaxyw aprĩ hã mẽ kãm ijarẽnh o mẽ hkôt apa hãmri nẽ te apê mẽ anhõ pahi mã hpur kãm axujamỳnh xwỳnh pyràk. Hãmri nhũm mẽ hkwỳjaja mẽ ama nẽ ixkôt amnhĩ xunhwỳ nẽ ixkôt ri amnhĩ nhĩpêx o pa. Hã koja nhỹrmã mẽ apyrà nẽ Tĩrtũm mẽ wa ixri mex rãhã nẽ htĩr tũm nẽ pa ho pa. Ka mẽ amnhĩ tã mẽ omu nẽ akĩnh nẽ apa. Te mẽ kot mẽ hpur kãm ahkre xwỳnhjaja nẽ mẽ kot hamỳnh xwỳnhjaja mẽõ rũnh pumunh nẽ hkĩnhta pyràk. ");
INSERT INTO apnNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","—Na htem tõhã ã mẽ pur kãm mẽ àpênh xwỳnhjê jarẽnh anẽ nẽ mẽ harẽnh o: “Axtem mẽ ahkre xwỳnhjaja nẽ axtem mẽ kot hamỳnh xwỳnhjaja.” Anẽ. Tã te mẽ ate mẽ ujarẽnh ja pyràk. ");
INSERT INTO apnNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Na pa pre ra ma mẽ hwỳr mẽ arẽ. Mẽ ate aprĩ hã mẽ kãm ijarẽnh nhũm mẽ kot mẽ amar nẽ amnhĩ kaxyw ixkôt hamaxpẽr nẽ ixkôt amnhĩ xunhwỳr kaxyw. Nom mẽ kajaja na ka prem akumrẽx mẽ hwỳr amrar nẽ mẽ kãm ijarẽnh kêt nẽ. Tĩrtũm kapẽr jarẽnh o mẽ pa xwỳnhjaja na prem kumrẽx mẽ hwỳr mra nẽ ixkukamã mẽ kãm ijarẽnh o ri mẽ hkôt pa. Te mẽ kot hpur kãm ahkre ho pata pyràk. Tã kot kaj mẽ hpãnhã mẽ kot amnhĩ kaxyw ixkôt amnhĩ xunhwỳr kaxyw aprĩ hã mẽ kãm ijarẽnh o apa. Jakamã te mẽ ate mẽ hpur kãm mẽõ jamỳnh xwỳnh kot amnhĩ nhĩpêxta pyràk. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Rôm nhũm Samar nhõ xwỳnh kwỳjaja nija kot mẽ kãm amnhĩ jarẽnh ma hãmri nẽ uràk nẽ amnhĩ kaxyw Jejus kôt hamaxpẽr. Na pre ra amnhĩ tã tanhmã mẽ kãm Jejus jarẽnh to nẽ mẽ kãm harẽnh o: —Ma aa kot nhỹri ixpumunh kêt tã ra kot hprĩ hã ixpumunh par. Ixte tanhmã amnhĩ nhĩpêx to hã ixpumunh par. Anhỹr jakamã nhũm mẽ kuma nẽ uràk nẽ amnhĩ kaxyw hkôt hamaxpẽr kurê kumrẽx. ");
INSERT INTO apnNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Hãmri nẽ man mẽ ixwỳr mra nẽ Jejus pumu nẽ amnhĩ wỳr kuwỳ nẽ kãm: —Pa. E kwa mẽ tokyx anojarêt kêt nẽ. Mẽ ma mẽ ixkôt mẽ inhõ krĩ hwỳr mõ nẽ mẽ ixkôt ri apa grire nẽ arĩ ma mõ. Anẽ. Hãmri nhũm mẽ kuma nẽ mẽ kãm: —Tôe. Nà kot paj mẽ anẽ. Anẽ. Hãmri pa mẽ ma mẽ hkôt mõ nẽ mẽ õ krĩ kamã mẽ hkôt ri ixpa hã apkati axkrut. ");
INSERT INTO apnNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Nhũm Jejus mẽ kãm Tĩrtũm kapẽr jarẽnh o ri mẽ hkôt pa nhũm mẽ axte ohtô nẽ kuma nẽ nita pyrà nẽ hkôt amnhĩ xunhwỳ. ");
INSERT INTO apnNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Hãmri nẽ nita wỳr mra nẽ kãm: —E nà ãm hãmri. Akumrẽx na ka mẽ inhmã Jejus o amnhĩrĩt. Pa mẽ akôt ma hwỳr mra nẽ mẽ pam omu nẽ kapẽr ã kuma. Jao apyrà nẽ amnhĩ kaxyw hkôt ijamaxpẽr nẽ hkôt amnhĩ xunhwỳ. Pẽr ãm hãmri kêp pyka piitã hkôt mẽ pahte amnhĩ tomnuj pãnhã amnhĩrer mã xwỳnhta na. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Tã pa mẽ Jejus kôt Samar rũm ixkato nẽ ma pika pê Garirej wỳr mõ. Kamã Jejus nhõ krĩ pê Najare htã pa mẽ hwỳr inhmõr kêt nẽ. ");
INSERT INTO apnNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Na pre ra Jejus mẽ inhmã tanhmã õ krĩ nhõ xwỳnhjê jarẽnh to nẽ mẽ harẽnh o: —Tĩrtũm nhỹ hã kapẽr jarẽnh o mẽ pa xwỳnhjaja na htem amnhĩ nhõ krĩ kamã mẽ kãm Tĩrtũm kapẽr jarẽnh o pa nhũm mẽ kuma nẽ ãm kuma. Jakamã kot paj Najare hwỳr inhmõr kêt nẽ. Mẽ kãm ixkapẽr mar prãmre hã. ");
INSERT INTO apnNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Anhỹr jakamã na pa prem hwỳr inhmõr kêt nẽ. Pãnhã nhãm krĩ hõ hwỳr mõ nẽ hwỳr pôj hãmri nhũm mẽ amnhĩ wỳr Jejus pumu nẽ hkĩnh nẽ. Na prem ra krĩ pê Jerujarẽ kamã arĩgro pê Pas ã mẽ hkĩnh kãm tanhmã kot amnhĩ nhĩpêx to ho pa hã omu. Jakamã amnhĩ wỳr omu nẽ hkĩnh nẽ. ");
INSERT INTO apnNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Tã pa mẽ kormã Garirej kamã ixpa nẽ akupỹm krĩ pê Kanã hwỳr mõ. Kamã na pre Jejus mẽ kãm gô ho wĩhti nhĩpêx. Jakamã pa mẽ akupỹm mẽ hwỳr mõ. Nhũm mẽõ pahi nhõ kôwenatôjê hõ hkra myja kêp à htỳx nẽ nõ. Nom Kanã kamã hkêt axtem krĩ hõ pê Kapanaũ kamã. ");
INSERT INTO apnNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Jakamã nhũm hipêêxàja tee ri hkra pumu hãmri nẽ ra Jejus kot Jutej rũm Kanã hwỳr hpôx ã harẽnh ma nẽ hkra kaxyw kãm hamaxpẽr nẽ ma hwỳr mõr kurê kumrẽx. Hãmri nẽ nhỹri omu nẽ hwỳr tẽ nẽ kãm kapẽr kãm hihtỳx nẽ kãm: —Pa. E ot pa awỳr tẽ. Na ra ixkra ixpê htyk kaxyw. Kwa ixkamã axukaprĩ nẽ ma ixkôt mõ nẽ akupỹm inhmã ho mex. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Hãmri nhũm kuma nẽ kãm: —Kwa pẽr ãm ixte mẽ amã aa mẽ ate mẽmoj pumunh kêt kwỳ ho anhỹr ã ixpumunh kôt pix mã na ka htem amnhĩ kaxyw ixkôt ajamaxpẽr. Nom amarĩ amnhĩ kaxyw ixkôt ajamaxpẽr kêt nẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Hãmri nhũm tee ri kuma nẽ kãm: —Kwa tokyx. Kot kaj tokyx ixkôt amõr kêt koja ixpê ty. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Hãmri nhũm kãm: —Nà koja apê htyk kêt nẽ. Ra ixte akupỹm amã ho mex kênã. Mãmrĩ ma akupỹm mõ nẽ tokyx omu. Na ra akupỹm amã mex. Anẽ. Hãmri nhũm kuma nẽ kaxyw hkôt hamaxpẽr kurê kumrẽx nẽ ma akupỹm hwỳr mõ. Nẽ mõr o apkati. ");
INSERT INTO apnNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Nẽ kormã õ krĩ hwỳr hpôx o mõr ri nhũm ra kãm mẽ àpênh xwỳnhjaja kutã mra nẽ nhỹri pry hã hkaxpa nẽ kãm: —Pa. Kwa na ra akra hkà hakry nẽ akupỹm amã mex. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Hãmri nhũm mẽ kuma nẽ hkĩnh tỳx nẽ. Nẽ mẽ kãm: —Kwa xô wehe? Mẽmo ore hã na pre we ra hkà hakry? Anẽ. Nhũm mẽ kãm: —Nà jãã na pre kaxkwa nhĩpôk ri myt nhỹ nhũm hkà hakry nẽ akupỹm amã mex kurê kumrẽx. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Hãmri nhũm mẽ kuma nẽ mẽ kãm: —Hêxta waa nẽ. Kwa pẽr ãm hãmri Jejus kot inhmã akupỹm mex ã harẽnh xà hã ore kamã na pre akupỹm inhmã mex. Nà ãm hãmri. Anẽ. Hãmri nẽ amnhĩ kaxyw Jejus kôt hamaxpẽr kurê kumrẽx. Nhũm õrkwỹ kamã ri mẽ pa xwỳnhjaja uràk nẽ amnhĩ kaxyw hkôt hamaxpẽr. ");
INSERT INTO apnNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Nhũm Jejus ã kãm hkra ho mex anẽ. Na pre ra pika pê Garirej kamã mẽ kot mẽmoj pumunh kêt õ ho anhỹr o tipxi nẽ mẽ kãm gô pix o wĩhti nhĩpêx. Tã ra pyka pê Jutej rũm akupỹm mẽ hwỳr mõ nẽ ã akupỹm mẽ hkrata o mex anẽ. ");
INSERT INTO apnNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Tã mẽ ixpê Ijaew mẽ ixte Tĩrtũm ã ixkĩnh kaxyw Jerujarẽ hwỳr akuprõ nhũm Jejus haxwỳja ma hwỳr mõ. Pa mẽ hkôt mẽ ixpa ho mẽ ixpa xwỳnhjaja ma hkôt mõ. ");
INSERT INTO apnNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Jerujarẽ kamã na himôja hikwỹ. Nhỹhỹnh mẽ kot krĩ hwỳr ôwêhti ho gjêx xà htã hikwỹ. Himôja nhĩxi pê na Petes. Nẽ pu hã mẽ à xwỳnhjê nhĩkwỹ xà hã ixkre kêp 5. ");
INSERT INTO apnNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Piitã kamã na pre hte tanhmã mẽ à kute xwỳnhjaja hikwỹ. Mẽ nohkre xwỳnhjaja nẽ mẽ hyk o mẽ pa xwỳnhjaja nẽ mẽ ĩ kamã mẽ htyk xwỳnhjaja. Ãm ahpỹnhã tanhmã mẽ à kute xwỳnhjaja ixkre hkwỳja kamã akupỹm mex prãm xàj hikwỹ. ");
INSERT INTO apnNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Na pre hte Tĩrtũm kapẽr o mẽ wrỳk xwỳnhja tõhã himô hwỳr wrỳ nẽ gô xok. Hãmri nhũm mẽ à xwỳnhjê hõ kot amnhĩ to wa nẽ kumrẽx hwỳr wrỳk nẽ kamã mrõr xwỳnhja akupỹm mex. Kwỳjê rom akupỹm mex kurê kumrẽx. Jakamã nhũm pre hte mẽ à xwỳnhjaja akupỹm mex prãm xàj gô xok jamãr o hikwỹ. ");
INSERT INTO apnNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Jakamã nhũm mẽhõ myja ixkre hõ kamã hikwỹ. Te omnuj nẽ arĩ hikwỹ hã amgrà xohtô rax nẽ. Ra hã amgrà kêp 38. ");
INSERT INTO apnNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Jakamã nhũm Jejus mẽ hwỳr tẽ nẽ omu. Nẽ hprĩ hã omu nẽ hamaxpẽr o: —Kwa mũj na hte omnuj nẽ ri pa hkêt ã amgrà xohtô rax nẽ. E pa akupỹm ho mex. Anhỹr o hamaxpẽr hãmri nẽ kãm: —Pa. E kwa inhmã amnhĩ jarẽ. Xà amã akupỹm amex prãm? Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Hãmri nhũm kuma nẽ kãm: —Ku nhũm. Inhmã tokyx akupỹm inhmex prãm tỳx kumrẽx kênã. No mẽhõ kot tokyx inhmỳ nẽ mẽ kêp ixto wa nẽ ixkumrẽx gô xok kamã inhmrõr? Na pa tee ri ixkumrẽx hwỳr ixtẽm nẽ inhmã inhmrõr prãm nhũm mẽ xatã ixpê amnhĩ to wa nẽ mra nẽ kamã mrõ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Hãmri nhũm Jejus kãm: —Tỳ? Tôe. E na ka akupỹm amex. E kànhmã xa nẽ akupĩp py nẽ ma akupỹm anhõrkwỹ hwỳr tẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Hãmri nhũm kuma nẽ ra akupỹm mex nẽ kànhmã xa nẽ ri mra. Nẽ hkĩnh tỳx nẽ hikupĩp py nẽ ma akupỹm õrkwỹ hwỳr tẽ. Ijaew nhõ arĩgromnu pê sap ã nhũm Jejus kot akupỹm ho mex ");
INSERT INTO apnNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","nhũm ma akupỹm pry hã hikupĩp py nẽ o tẽ. Nhũm Ijaew nhõ pahi hkwỳja nhỹhỹnh mra nẽ tee ri kot sap ã hpyr nẽ o htẽm ã omu nẽ kãm: —Tk. Kwa mẽ pahpê Ijaew na pu htem mẽ panhõ arĩgromnu hã paxàpênh kêt nẽ. Finat Mojes kot ja nê mẽ pahkurê htã ka axtem nẽ akupĩpta py nẽ nhỹhỹm o tẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Hãmri nhũm mẽ kuma nẽ mẽ kãm: —Tỳ. Kot anhỹr tã kot ixto mex xwỳnhta na ã inhmã kapẽr anẽ pa mar xà hkôt kupy nẽ akupỹm inhõrkwỹ hwỳr tẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Hãmri nhũm mẽ tee ri kuma nẽ kãm: —Kwa mẽhõ na we ã ri amã karõ anẽ? Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Nhũm kormã kot Jejus nhĩxi mar kêt jakamã kot mẽ kãm ahkre kaxyw hakẽx nẽ tee ri hkwỳjê kaêx ã hapêr rĩt o xa. Nom nhũm mẽ ohtô nẽ pry hã mrar jakamã nhũm tee ri hapêr nhũm Jejus ra ma nhỹhỹm tẽ. ");
INSERT INTO apnNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Tã nhũm hã ahtũmre nhũm Jejus Tĩrtũm mã amnhĩ jarẽnh xà hã ixkre hwỳr tẽ nẽ axà nẽ kot ho mex xwỳnhta pumu nẽ kãm: —Pa. E na ka ra akupỹm amex. Nom kwa kêr ka axte tanhmã amnhĩ tomnuj to ho ri apa hkêt nẽ. Kot kaj axte ã amnhĩ nhĩpêx anẽ hãmri nẽ apunuj tỳx o wam ate apunujta jakre kãm ga. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Hãmri nhũm kuma nẽ ma tẽ nẽ kato. Nẽ ma mẽ õ pahijê hwỳr tẽ nẽ mẽ kãm: —E na pa ra kot ixto mex xwỳnhta nhĩxi ma. Xep kêp Jejus. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Hãmri nhũm mẽ hixi ma nẽ hã tanhmã axpẽn mã ho kapẽr punuj to. Mẽ õ arĩgromnu hã kot mẽ ho mex o pa jakamã nhũm mẽ axpẽn jakwa kamã ri hixi ho rê nẽ nhỹri omu nẽ tanhmã hã kãm àkjêr to. ");
INSERT INTO apnNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Hãmri nhũm amnhĩ tã mẽ kuma nẽ mẽ kãm: —Ku nhũm. Inhĩpêêxà Tĩrtũm na hte apkati mẽ tanhmã mẽ pahto mex to ho pa. Jakamã pa hte uràk nẽ ã mẽ ho mex rãhã ho ri ixpa anẽ nẽ aa mẽmo arĩgro hã ja ho anhỹr kaga hkêt nẽ. ");
INSERT INTO apnNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Anhỹr o mẽ kãm amnhĩ jarẽ nhũm mẽ kuma nẽ kamã gryk tỳx nẽ. Nom mẽ õ arĩgromnu hã kot mẽ ho mexja pix mỳrapê kamã gryk kêt. Mããnẽn Tĩrtũm kêp hipêêxà hã harẽnhja mỳrapê nhũm prem kamã gryk tỳx kumrẽx nẽ axpẽn mã: —Tk. Kwa na ã amnhĩ jarẽnh anhỹr jao te kêp Tĩrtũm pyràk ã amnhĩ jarẽ. E kwa pu mẽ kupĩ ri. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Hãmri nhũm Jejus axte mẽ kêp Ijaew nhõ pahijê mã kapẽr nẽ mẽ kãm: —Na pa hte amnhĩ krã hkôt tanhmã amnhĩ nhĩpêx to ho ri ixpa hkêt nẽ. Na pa hte Inhĩpêêxà kot tanhmã amnhĩ nhĩpêx to hã omunh xà hkôt uràk nẽ mẽ ho mex o ri ixpa. Kwa mẽ amnhĩ krã him ja jaxà nẽ kãm ajamaxpẽr tỳx nẽ ho apa. ");
INSERT INTO apnNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","—Inhĩpêêxàja kãm ijapêê. Na hte inhmã kot tanhmã mẽ ho mex to piitã ho amnhĩrĩt. Ixte omunh nẽ uràk nẽ ỹ hã tanhmã mẽ ho mex to ho ri ixpa kaxyw. Jakamã kot paj ãm akupỹm mẽ à xwỳnhjê ho mex pix o ri ixpa hkêt nẽ. Kot paj mããnẽn mẽ kãm mẽmoj mex o ja jakrenh o anhỹr o ri ixpa ka mẽ hã ixpumu nẽ ixkamã ano puma ho apa. ");
INSERT INTO apnNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","—Nẽ Inhĩpêêxà kot akupỹm mẽ htyk xwỳnhjê ho htĩr jakamã kot paj uràk nẽ akupỹm mẽ htyk xwỳnhjê ho htĩr o ri ixpa. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Nhũm Jejus arĩ mẽ kêp Ijaew nhõ pahijê mã kapẽr nẽ mẽ kãm: —Koja nhỹrmã Inhĩpêêxàja mẽ htĩr tũm nẽ mẽ pa ho mẽ pa mã xwỳnhjê jarẽnh kêt nẽ. Ja kaxyw na pre pa ixãm. ");
INSERT INTO apnNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Tã mẽ piitã mẽ kot ja hã ixpumunh nẽ ixtã hpijaàm o ri pa kaxyw na pre mẽ kaxyw ixãm. Te mẽ kot Inhĩpêêxà hã hpijaàmta pyrà nẽ pa ixtã hpijaàm o pa kaxyw. Jakamã koja mẽhõ ixtã hpijaàm kêt nẽ hãmri nẽ mããnẽn Inhĩpêêxà hã hpijaàm kêt ã amnhĩ to amnhĩrĩt. Tãm kot mẽ awỳr inhmẽnh kênã. ");
INSERT INTO apnNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Jakamã koja mẽhõ ixkapẽr ma nẽ amnhĩ kaxyw kot mẽ awỳr inhmẽnh xwỳnhta kôt hamaxpẽr nẽ ixkôt amnhĩ xãm. Hã koja nhỹrmã htyk tã ma mẽ kot amnhĩ xà htỳx kamã hamak o pa htũm xàta wỳr mõr kêt nẽ. Koja Inhĩpêêxà akupỹm ho htĩr nhũm wa ixri htĩr tũm nẽ mex kumrẽx nẽ pa ho pa. Jakamã koja mẽhõ ixkôt amnhĩ xãm hãmri nẽ ra kêp wa ixri htĩr tũm nẽ pa ho pa mã xwỳnh. Kwa mẽ jam ajamaxpẽr tỳx rãhã ho apa. ");
INSERT INTO apnNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","—No mẽ kãm ixkapẽr mar prãm kêt xwỳnhjaja kêp Inhĩpêêxà mẽ wa ixri mẽ htĩr tũm nẽ mẽ pa mã xwỳnh kêt. Tã ixpê Tĩrtũm Kra jakamã koja mẽ ixkapẽr ma nẽ ixkôt amnhĩ xunhwỳ. Hã kot paj amnhĩ tã mẽ omu nẽ mẽ htĩr tũm nẽ mẽ pa mã xwỳnh ã mẽ harẽ nhũm mẽ àmnhĩx ri hkĩnh nẽ pa ho pa. Kwa mẽ jam ajamaxpẽr tỳx rãhã ho apa. ");
INSERT INTO apnNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","—Nẽ Inhĩpêêxà tãm kêp mẽ ho mẽ htĩr xwỳnh. Tã ixpê Kra jakamã na pre amnhĩ pyrà nẽ ja kaxyw ixãm. ");
INSERT INTO apnNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","—Ra kot mẽ akaxyw ixãm jakamã na pre mããnẽn ixte tanhmã mẽ ajarẽnh to kaxyw ixãm. Wa ixri mẽ atĩr tũm nẽ apa ho apa mã xwỳnhjê hã mẽ ajarẽnh rỳ wa ixri mẽ atĩr tũm nẽ apa hkêt mã xwỳnhjê hã mẽ ajarẽnh kaxyw. ");
INSERT INTO apnNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","30","Jakamã kot paj nhỹrmã ra mẽ htyk nẽ mẽ hikwỹ xwỳnh piitã mẽ kãm ixkapẽr nhũm mẽ inhma. Koja mẽ ixkapẽr ma hãmri nẽ akupỹm htĩr nẽ pika rũm hapôx pa. Hãmri nhũm mẽ kot kormã htĩr ri Tĩrtũm kapẽr kôt amnhĩ nhĩpêx hkêt xwỳnhjaja mẽ kot amnhĩ tomnuj mỳrapê ma mẽ kot amnhĩ xà htỳx kamã hamak tũm xàta wỳr ma hapêx pa. Nom nhũm mẽ kot amnhĩ to mex xwỳnhjaja. Ra mẽ kot Tĩrtũm kôt amnhĩ nhĩpêx jakamã koja mẽ ma Tĩrtũm mẽ wa ixwỳr api nẽ wa ixri mex nẽ hkĩnh rãhã htĩr tũm nẽ pa ho pa. —Kot paj ja kaxyw tanhmã mẽ apiitã mẽ ajarẽnh to. Nom kot paj amnhĩ krã hkôt inhmã hprãm xà hkôt tanhmã mẽ ajarẽnh to hkêt nẽ. Kot paj Inhĩpêêxà kot mẽ awỳr inhmẽnh xwỳnhta nhỹ hã àhpumunh tỳx xà hkôt tanhmã mẽ ajarẽnh to. Jao ãm hãmri mẽ ajarẽ. Kwa mẽ jam ajamaxpẽr tỳx nẽ. No ã ixte mẽ amã amnhĩ jarẽnh anhỹrja ma nẽ tee ri ajamaxpẽr kêt nẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Nhũm Jejus arĩ mẽ kêp Ijaew nhõ pahijê mã kapẽr nẽ mẽ kãm: —E na pa ra tanhmã mẽ amã amnhĩ jarẽnh to. Nom kop ãm papxipix ixte ã amnhĩ jarẽnh anhỹr ronhỹx ka mẽ inhma nẽ ajamaxpẽr o: “Ko. Na apu ãm hãmri ã mẽ inhmã amnhĩ jarẽnh anẽ rỳ apu ãm amnhĩ to hêx.” Anhỹr o ajamaxpẽr. ");
INSERT INTO apnNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Nom papxipix na pa hte ã amnhĩ jarẽnh anhỹr kêt nẽ. Inhĩpêêxà haxwỳja na hte ã ijarẽnh anẽ. Nẽ ãm hãmri na hte tanhmã ijarẽnh to ho pa. Tĩrtũmja hêx kêt. ");
INSERT INTO apnNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","No mẽ amã pika nhõ xwỳnhjê pix kapẽr mar prãm jakamã na ka prem finat Juãw Paxisja wỳr akwỳjê rẽ nhũm mẽ ma hwỳr mra nẽ ixtã hkukja nhũm mẽ kãm tanhmã ijarẽnh to. Nẽ hprĩ hã mẽ kãm ijarẽ. ");
INSERT INTO apnNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","No mẽ apê pika nhõ xwỳnhjaja mẽ ate axpẽn mã tanhmã ijarẽnh toja na ixpê tanhmã kute hkêt. Koja mẽhõ tanhmã ixto kapẽr punuj to rỳ tanhmã ijarẽnh mex to pa amnhĩ jarẽnh ma nẽ tee ri amnhĩ kukamã ijamaxpẽr o ixkaprĩ hkêt nẽ. Tã nom Juãw Paxis kapẽrja mẽ amã mex jakamã na pa ã mẽ amã harẽnh anẽ. Ka mẽ ra kot tanhmã ijarẽnh toja ma nẽ amnhĩ kaxyw ixkôt ajamaxpẽr nẽ ixkôt amnhĩ xunhwỳ nẽ nhỹrmã ty nẽ ma mẽ kot amnhĩ xà htỳx kamã hamak tũm xàta wỳr apa hkêt nẽ. ");
INSERT INTO apnNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","—Juãw Paxis na pre te kanê hpôk mex nẽ mẽmoj to amnhĩrĩt mex pyrà nẽ mẽ amã Tĩrtũm kapẽr o amnhĩrĩt mex o pa. Ka prem te maripôtre kot kanê hã htu pyrà nẽ hwỳr akuprõ nẽ mar o akuhê. Nom hkôt ajamaxpẽr tỳx kêt nẽ. ");
INSERT INTO apnNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Na pre hprĩ hã mẽ amã ijarẽnh o ri pa. —Tã pa pam mẽ awỳr wrỳ nẽ Inhĩpêêxà nhỹ hã mẽ akamã aa mẽ ate mẽmoj pumunh kêt kwỳ ho anhỹr o ri ixpa. Mẽ ate ja hã ixpumunh nẽ Inhĩpêêxà tãm kot mẽ awỳr inhmẽnh kôt ixpumunh kaxyw. ");
INSERT INTO apnNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","—Nẽ Inhĩpêêxàja mããnẽn ixpê Kra hã mẽ amã ixto amnhĩrĩt. Ra mẽ anhõpinh xà kaxwỳnh kãm kot mẽ amã ixto amnhĩrĩt tã ka mẽ ama nẽ ãm ama nẽ ixkôt ajamaxpẽr kêt nẽ. ");
INSERT INTO apnNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Mẽ amã mẽ ate hkôt amnhĩ nhĩpêx o apa hprãm kêt. Mẽ ate kapẽr mar tỳx ronhỹx ka mẽ ixkapẽr ma nẽ amnhĩ kaxyw ixkôt ajamaxpẽr kurê kumrẽx. Ixpê Tĩrtũm kot mẽ awỳr inhmẽnh xwỳnh kênã. ");
INSERT INTO apnNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","—Nẽ Tĩrtũm kapẽr ã kagà htũm haxwỳja kot tanhmã ijarẽnh to. Ka htem wa ixri atĩr tũm nẽ apa ho apa hprãm xàj kamã harẽnh rãhã ho ri apa. Nẽ kot tanhmã pa ijarẽnh to htã ka mẽ ixkapẽr ma nẽ amnhĩ kaxyw ixkôt ajamaxpẽr kêt nẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Nhũm Jejus arĩ mẽ kêp Ijaew nhõ pahijê mã kapẽr nẽ mẽ kãm: —Nẽ pa na ixte Inhĩpêêxà mẽ wa ixri ixte mẽ ho mẽ htĩr tũm nẽ mẽ pa mã xwỳnh ã mẽ harẽnh tã ka mẽ amnhĩ kaxyw ixkôt ajamaxpẽr kêt nẽ. ");
INSERT INTO apnNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Nom mẽ ate inhmex ã ijarẽnh kêt tã ja ixpê tanhmã kute hkêt. Ãm Inhĩpêêxà pix kot inhmex ã ijarẽnhja na inhmã hprãm. ");
INSERT INTO apnNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Ra ixte mẽ apumunh mex. Mẽ amã Tĩrtũm kĩnh kêt. ");
INSERT INTO apnNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Tãm kot mẽ awỳr inhmẽnh tã ka mẽ ixpumu nẽ ixkaga nẽ ixkôt amnhĩ nhĩpêx kêt nẽ. Nom koja mẽhõ amnhĩ krã hkôt mẽ awỳr tẽ nẽ tanhmã mẽ ajahkre hto ka mẽ ama nẽ hkôt amnhĩ nhĩpêx kurê kumrẽx. ");
INSERT INTO apnNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","—Ãm pika nhõ xwỳnh pixjaja kot mẽ amex ã mẽ ajarẽnhja na mẽ amã hprãm. No Tĩrtũm kot amnhĩm mẽ amex ã mẽ ajarẽnhja mẽ amã hprãm ã mẽ ate amnhĩ jarẽnh tã mẽ amã ja prãm kêt. Jakamã na ka htem ixkaga kumrẽx. ");
INSERT INTO apnNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","46","Tã nom kot paj pam nhỹrmã Tĩrtũm mã mẽ apê ixkwỳ hkêt ã mẽ ajarẽnh kêt nẽ. Mo kaxyw kot pa kêt ri ã kãm mẽ ajarẽnh anẽ? Finat Mojes tãm koja ja hã kãm mẽ ajarẽ. Na ka htem tanhmã ajamaxpẽr to nẽ ajamaxpẽr o: “Kot paj finat Mojes kot mẽ inhmã tanhmã kapẽr to hkôt amnhĩ nhĩpêx o ri ixpa hãmri nẽ nhỹrmã Tĩrtũm ri ixtĩr tũm nẽ inhmex nẽ ixpa ho ixpa.” Anhỹr o ajamaxpẽr nom hkôt amnhĩ nhĩpêx kêt nẽ. Mojes na pre hte pa ijarẽnh o pa. Tã mẽ ate kapẽr kôt amnhĩ nhĩpêx ronhỹx ka mẽ amnhĩ kaxyw ixkôt ajamaxpẽr nẽ ixkôt amnhĩ xunhwỳ. No mẽ ate ixkaga jakamã koja Mojes tãm Tĩrtũm mã mẽ apê ixkwỳ hkêt ã mẽ ajarẽ. ");
INSERT INTO apnNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Mẽ ate Mojes kapẽr kôt amnhĩ nhĩpêx kêt jakamã kot kaj mẽ mããnẽn ixkôt amnhĩ nhĩpêx hkêt nẽ. Anẽ. Nhũm pre ã Jejus Ijaew nhõ pahijê mã kapẽr anẽ. ");
INSERT INTO apnNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","4","Tã nhũm ra arĩgro pê Pas ahtêp o mõ. Pasja ã mẽ ixpê Ijaewjaja na pa htem axpẽn wỳr akuprõ nẽ hã ôwêhti hkra nyw kwỳ pa nẽ ĩ hkur o ixkrĩ. Amnepêm Tĩrtũm kot pika pê Ejit rũm mẽ inhĩgêtjê kator kaxyw nhũm prem nojarêt nẽ ã hkwỳ hpar nẽ ĩ hkur anẽ. Tã arĩ mẽ ixpê mẽ hkanrẽhã mẽ htàmnhwỳjaja jam ijamaxpẽr pê ixkĩnh kaxyw ã amnhĩ nhĩpêx anẽ. Jakamã nhũm Jejus pàr krem axà nẽ ma himô pê Garirej ã rêr kaxyw ma xarmã mõ nẽ rê. Himôja nhĩxi hõ pê na Tipe nhũm hã xarmã mõ nẽ rê. Pa mẽ hkôt ixpa ho ixpa xwỳnhjaja ma hkôt ixpa. Hãmri nhũm pika nhõ xwỳnh kwỳjaja Jejus ma mõr kãm omu hãmri nẽ ma gô kape hã pikap mẽ inhĩhkrep mra. Na pre ra Jejus mẽ kamã mẽ à xwỳnhjê ohtô nẽ akupỹm mẽ ho mex nhũm mẽ axte omu hãmri nẽ ma mẽ inhĩhkrep gô mỳ ri hpar o pa. Tã pa mẽ xarmã rê nẽ pàr rũm ijapôj nẽ gô mỳ ri kỳxpê ixkrĩ hpa. ");
INSERT INTO apnNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Hãmri nhũm mẽ inhĩhkrep mẽ mrar xwỳnhjaja mẽ ixwỳr hpôx o mra nhũm Jejus amnhĩ wỳr mẽ omu nẽ mẽ inhĩõ pê Firipti mã kapẽr nẽ kãm: —Kwa Firip. Mẽmoj kot puj mẽ pahwỳr mẽ mõr nẽjjê mã ho anẽ nhũm mẽ kuku? Tanhmã kot puj mẽ amnhĩ to nẽ nhỹri mẽ kãm mẽmoj japrô nhũm mẽ kuku? Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Ra tãm kot tanhmã mẽ kãm õ hto hã amnhĩ pumunh mex tã ã mẽ hã Firipti kamã hamak kaxyw mẽ hã hkukjêr anẽ. ");
INSERT INTO apnNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Hãmri nhũm kuma nẽ tee ri mẽ hkukamã hamaxpẽr nẽ kãm: —Konẽn. Mẽ ohtô rax kumrẽx kênã. Mo mẽ kaxyw mẽ pakàxpore rax? Kot pu mẽ pakàxpore ho 200 nẽ ho mẽ kãm mẽmoj japrôr tã nhũm mẽ ãm ho hkryre nẽ kuku nẽ ho õhy htu hkêt nẽ. Mẽ ohtô rax o mẽ ohtô rax kênã. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","9","Hãmri nhũm mẽ inhĩõja kuma nẽ Jejus wỳr tẽ nẽ kãm kapẽr. Simãw Pêtre htõ Andreja hwỳr tẽ nẽ kãm: —E ota mẽhõ hkrata amnhĩ kôt õ hkwỳ ho mõ. No ãm grire. Na pãwti kêp 5 nẽ kaxyw õ tep axkrutre. No mẽ ohtô gri ã kot kêt mẽ hipêx pa. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Hãmri nhũm kuma nẽ hkôt mẽ ixpa ho mẽ ixpa xwỳnhjê mã kapẽr nẽ mẽ inhmã: —Tôe. Nà hãmri. E mẽ kãm anẽ kê mẽ hkrĩ pa. Anẽ. Hãmri pa mẽ kãm anẽ nhũm mẽ põ kamã hkrĩ hpa. Na prem ohtô kumrẽx. Mẽmyjê pixjaja kêp 5.000. Nẽ kaxyw mẽ hprõ nẽ mẽ hkrajaja. Na prem ohtô ho ohtô. Tã piitã hkrĩ pa. ");
INSERT INTO apnNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","12","Hãmri nhũm Jejus mẽhõ hkrata pê õ pãwti jamỳ nẽ o xa nẽ Tĩrtũm mã harẽ nẽ kãm: —Pa Papaj. Na ka hte mẽ inhmã mẽ inhõ ho apa. Ãm kapxipix amex o amex. Anẽ. Hãmri nẽ mẽ inhmã pãwtija gõ pa mẽ ô ri mẽ hkrĩ xwỳnhjê mã õr o mra nẽ ho mẽ piitã mẽ hipêx pa. Pãwtija ãm hkryre htã nhũm Jejus tanhmã ho nhũm ra ohtô rax kumrẽx. Jakamã pa mẽ ô ri mẽ kãm õr o mra nẽ ho mẽ piitã mẽ hipêx pa. Nhũm Jejus hpãnhã tep axkrutreta py nẽ mã ho anẽ nẽ Tĩrtũm mã harẽ hãmri nẽ amnhĩ xô ri mẽ inhmã kugõ pa mẽ mã ho anẽ nẽ. Te ho pãwti nhĩpêx pyrà nẽ ho mẽ piitã mẽ hipêx. Hãmri pa mẽ ixpiitã apku nẽ inhõhy htu nhũm arĩ mẽõ jakrêx kwỳ hprã. Hãmri nhũm Jejus mẽ inhmã: —E kwa mẽ hkôt mra nẽ mẽõ jakrêx o akuprõ kê omnu hkêt nẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Hãmri pa mẽ kuma nẽ ho akuprõ nẽ kawà o 12 nẽ ho nỳt. Pãwti hkryreja ãm kêp 5 pix tã nhũm Jejus tanhmã ho nhũm rũnh kumrẽx. Jakamã pa mẽ hakrêx prãr o kawà ho 12 nẽ ho nỳt pa. ");
INSERT INTO apnNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Hãmri nhũm mẽ inhĩhkrep mẽ mõr xwỳnhjaja amnhĩ jaêr pê Jejus kot mẽ kãm mẽõ ho rax ã omu nẽ ri axpẽn mã harẽnh o: —Kokỹỹ. Tãm mãn pre finat Mojesja amnepêm mẽ panhĩgêtjê mã harẽnh o ri pa. Tã ra mẽ pahwỳr wrỳ nà? ");
INSERT INTO apnNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Kwa pu mẽ kãm pakapẽr kãm paxihtỳx nẽ ma akupỹm amnhĩ kôt o mõ nẽ amnhĩ kaxyw ãm kê mẽ pahto amnhĩptàr o pa. Anẽ. Hãmri nhũm Jejus amnhĩ tã mẽ kapẽr ma nhũm ja kêp omnuj nẽ. Jakamã nhũm mẽ kêp kato nẽ ma hpãnhã ahte nhỹri hixêt õ hwỳr tẽ. ");
INSERT INTO apnNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Tã nhũm ra kamàtre pa mẽ Jejus kôt ri ixpa ho ixpa xwỳnhjaja ma akupỹm himô hwỳr mra. ");
INSERT INTO apnNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Nhũm kormã Jejus mẽ ixwỳr akupỹn htẽm kêt jakamã pa mẽ tee ri kamã ama hãmri nẽ akupỹm pàr mã axà nẽ ma akupỹm Kapanaũ hwỳr xarmã ixrêr o mõ. ");
INSERT INTO apnNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Pu nhũm ra kôk àpêr tỳx nhũm gô xatã kànhmã harĩ nẽ axpẽn wỳr mra nẽ axpẽn tak tỳx nẽ. ");
INSERT INTO apnNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Pa mẽ kormã gô nhĩpôk ri mõ. Nẽ tee ri rrẽmti ho gô rẽnh nhĩpêx kaprỳ nom kormã ixrêr kêt nẽ. Nẽ kormã inhmõr o ixtã 5 kirõm pix nẽ. Hãmri nhũm ra Jejus gô krãhkà hã hpar o mẽ ixkôt tẽ. Pa mẽ ixprĩ hã amnhĩ wỳr omunh mex kêt nẽ ixtỳx mẽkarõ hã hkamnhĩx nẽ mẽ inhmã uma htỳx kumrẽx. ");
INSERT INTO apnNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Tã nhũm mẽ inhmã ixkapẽr nẽ mẽ inhmã: —Tk. Kwa mẽ amã ma hkêt nẽ. Pa na pa mẽ akôt tẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Hãmri pa mẽ kapẽr ma nẽ ixkĩnh nẽ. Nẽ amnhĩ wỳr pàr kre hwỳr ho api nhũm axà pa mẽ xarmã ixrêr kurê kumrẽx nẽ pàr kre rũm ijapôx pa. ");
INSERT INTO apnNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Tã nhũm apkati nhũm xarpê mẽ kot Jejus wỳr mrar nhũm kot mẽ kãm õ xwỳnhjaja tee ri hapêr o pa nẽ axpẽn mã: —Kwa nhỹhỹm mãn pre we tẽẽ? Na pre hkôt ri mẽ pa xwỳnhjaja pix mẽ õ pàr kãm ma akupỹm xarmã mõ nom nhũm Jejusja mẽ hkôt htẽm kêt nẽ. Nà mãn kormã jar nhỹhỹm ri mrar jakamã pu mẽ kormã omunh kêt nẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Rôm nhũm Tipe rũm pàr kwỳja mẽ hwỳr pôj. Jejus kot mẽ apkur xà ho Tĩrtũm wỳr nẽ mẽ kãm ho rax xà hã pikata wỳr nhũm mõn pôj. ");
INSERT INTO apnNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Hãmri nhũm mẽ amnhĩ wỳr omu nẽ tee ri pàr kãm Jejus mẽ hkôt mẽ ixpa ho mẽ ixpa xwỳnhjê japêr hãmri nẽ axpẽn mã: —E kwa pu mẽ ma mẽ hkôt xarmã mõ nẽ Kapanaũ kamã mẽ hapêr. Anẽ. Hãmri nẽ mẽ kãm amnhĩ jarẽ nẽ mẽ õ pàr kwỳ hwỳr agjê nẽ ma mẽ hkôt xarmã mõn rê. ");
INSERT INTO apnNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Hãmri nẽ ra mẽ ixwỳr rê nẽ mẽ ixkôt pôj nẽ mẽ ixkaêx ã Jejus pumu nẽ hwỳr mra nẽ kãm: —Pa mẽ ijahkre xwỳnh. Kwa na pa prem tee ri xarpê ajapêr hãmri nẽ man akôt mõn rê. Kwa tanhmã na ka pre we amnhĩ to nẽ man tẽn rê? Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Hãmri nhũm mẽ kãm: —Nà mẽmo kaxyw na ka wem ri ijapêr o ri ixkôt apa? Ãm jãã mẽ ate ixkutã axàpkur nẽ anhõhy htu jakamã na ka mẽ axte ixkutã axàpkur pix kaxyw ijapêr o ri apa. No ixte ã mẽ amã amnhĩ nhĩpêx anhỹr ã ixpumu nẽ ixpê Tĩrtũm Kra hã ixkôt ajamaxpẽr kêt nẽ. Kwa mẽ ixpê Kra hã inhmã ajamaxpẽr tỳx nẽ kêt wehe. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Nhũm Jejus arĩ hwỳr mẽ mrar xwỳnhjê mã kapẽr nẽ mẽ kãm: —Kwa kêr ka mẽ ri axàpkur xà pix kukamã ajamaxpẽr o ri apa hkêt nẽ. Na htem mẽ apkur xà kukwak ri Tĩrtũm mẽ wa ixri htĩr tũm nẽ pa ho pa hkêt nẽ. No kot kaj mẽ amnhĩ kaxyw pa ixkôt ajamaxpẽr nẽ ixkôt amnhĩ xunhwỳ. Hã kot kaj mẽ ixkukwak ri nhỹrmã atĩr tũm nẽ wa ixri amex nẽ apa ho apa. Te ixpê mẽ kot mẽ apkur xà hkur nẽ ỹ hã htĩr tũm nẽ pa ho pa xwỳnh pyràk. Ja kaxyw na pre Inhĩpêêxà Tĩrtũm mẽ awỳr papxipix inhmẽ pa mẽ awỳr wrỳ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Hãmri nhũm mẽ kuma nẽ kãm: —Kwa tanhmã kot paj wem amnhĩ nhĩpêx to nhũm Tĩrtũm hã mẽ ixpumu nẽ mẽ ixto mex nẽ? Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Hãmri nhũm mẽ kuma nẽ axte mẽ kãm amnhĩ jarẽ nẽ mẽ kãm: —Nà kot kaj mẽ amnhĩ kaxyw pa Tĩrtũm kot mẽ awỳr inhmẽnh xwỳnh kôt ajamaxpẽr hãmri nhũm ixtã mẽ apumu nẽ tanhmã mẽ akrã hto ka mẽ ajamakêtkati nẽ axàmnhĩx akĩnh nẽ tanhmã amnhĩ nhĩpêx to ho ri apa. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Hãmri nhũm mẽ kuma nẽ kãm: —Tôe. Kwa axte mẽ inhmã aa mẽ ixte mẽmoj pumunh kêt õ ho anẽ. Pa mẽ ja hã apumu nẽ amnhĩ kaxyw akôt ijamaxpẽr kurê kumrẽx. E mẽmo kot ka mẽ inhmã ho anẽ? Kwa tokyx mẽ inhmã axte mẽmoj tanhmã ho pa mẽ omu. ");
INSERT INTO apnNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Amnepêm finat Mojes pyrà kot kapôt ã mẽ panhĩgêtjê ho pa ri na pre hte apkati mẽ mẽ kãm mẽõ mẽ kot kãm “manã” anhỹr xwỳnhta gõ nhũm pre htem hkur o pa. Tĩrtũm kapẽr ã kagà htũm kot ja jarẽnh kot: Na pre kaxkwa rũm mẽ hwỳr mẽ apkur xà rẽ nhũm mẽ hkur o pa. Anhỹr o kot harẽnh. Tã kot kaj Mojes nẽ apkati mẽ mẽ inhmã mẽ inhõ ho ri apa pa mẽ ja hã apumu nẽ rĩ kormã amnhĩ kaxyw akôt ijamaxpẽr japêr. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Hãmri nhũm mẽ kãm: —Xà Mojes na pre hte mẽ kãm kaxkwa rũm mẽ apkur xà rẽnh o pa? Nà tãm kêt. Inhĩpêêxà na pre hte mẽ hwỳr kurẽ nhũm mẽ hkawrà nẽ kuku nẽ kukwak ri hihtỳx nẽ htĩr nẽ pa. Tã nhũm ra mẽ awỳr hpãnhã pa ixpê Kra hã inhmẽ. Kwa mẽ ixkapẽr ma nẽ amnhĩ krãm haxàr tỳx nẽ. ");
INSERT INTO apnNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Na pre Tĩrtũm inhĩpêx o te amnepêm kot mẽ hwỳr kaxkwa rũm mẽ apkur xà rẽnhta pyrà nẽ amnẽ pika hwỳr inhmẽ. Jakamã te ixpê kaxkwa rũm mẽ apkur xà maati wrỳk xwỳnhta pyràk. Mẽ ate amnhĩ kaxyw ixkôt ajamaxpẽr nẽ ixkôt amnhĩ xunhwỳr hãmri nẽ ixkukwak ri wa ixri atĩr tũm nẽ apa ho apa kaxyw. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Nhũm pre ã Jejus mẽ kãm amnhĩ jarẽnh anẽ nhũm mẽ kuma nom hprĩ hã mar mex kêt nẽ. Ãm htỳx ho axtem mẽ apkur xà mex pix ã harẽnh ã hkamnhĩx nẽ kãm: —Kwa tô mẽ inhmã mẽ apkur xà maatita kwỳ gõ pa mẽ apkati mẽ hkur o ri ixpa. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Hãmri nhũm mẽ kuma nẽ amnhĩ tã mẽ kãm: —Nà mẽ apkur xà kumrẽxja ãm paa. Te ixpê mẽ apkur xà maati pyràk. Jakamã kot kaj mẽ atõ amnhĩ kaxyw ixkôt ajamaxpẽr nẽ ixkôt amnhĩ nhĩpêx o apa hã kot kaj mẽ akĩnh nẽ apa. Te ra axàpkur nẽ anhõhy htu nẽ akĩnh o ri apa pyràk. Jao amnhĩ tã ixpumu nẽ akĩnh nẽ ajamakêtkati nẽ ri apa. ");
INSERT INTO apnNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","—Ra mẽ ate ixpumunh mex tã kormã amnhĩ kaxyw ixkôt ajamaxpẽr kêt nẽ. Kwa mẽ ixkapẽr ma nẽ amnhĩ krãm haxàr tỳx nẽ. ");
INSERT INTO apnNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Tĩrtũm kot inhmã mẽ õr mã xwỳnhjaja koja mẽ ixpumu nẽ amnhĩ kaxyw ixkôt hamaxpẽr mex kurê kumrẽx. Ã mẽ kot amnhĩ nhĩpêx anhỹr xwỳnhjaja kot paj aa amnhĩ nê mẽ hanor kêt nẽ. ");
INSERT INTO apnNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","—Nẽ ixte amnhĩ krã hkôt kaxkwa rũm ixwrỳk nẽ inhmã hprãm xà hkôt tanhmã amnhĩ nhĩpêx to ho ixpa kaxyw na pa pre ixwrỳk kêt nẽ. Inhĩpêêxà kot mẽ awỳr inhmẽnh jakamã kãm hprãm xà hkôt pix mã na pa hte tanhmã amnhĩ nhĩpêx to ho ri ixpa. ");
INSERT INTO apnNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","—Tã mo na hte Inhĩpêêxà kãm hprãm? Nà kot inhmã mẽ õr mã xwỳnh piitã nhỹrmã wa ixkuri htĩr tũm nẽ mex nẽ pa ho paja na kãm hprãm. Jakamã nhỹrmã akupỹm mẽ htĩr ã arĩgrota ã ixte akupỹm mẽ ho htĩr nhũm ixte ãm pixire nẽ ho ixpikunor kêtja na kãm hprãm. ");
INSERT INTO apnNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","—Tã kot ka mẽ atõ ixpê Tĩrtũm Kra hã ixpumu nẽ amnhĩ kaxyw ixkôt ajamaxpẽr nẽ ixkôt amnhĩ xãm. Hã kot kaj nhỹrmã atyk tã pa akupỹm mẽ atĩr xà hã arĩgrota ã akupỹm ato atĩr ka wa ixkuri atĩr tũm nẽ amex nẽ apa ho apa. Ja na Inhĩpêêxàja kãm hprãm. Anẽ. Nhũm pre ã Jejus mẽ kãm amnhĩ jarẽnh anẽ. ");
INSERT INTO apnNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Hãmri nhũm Ijaew nhõ pahijaja mẽ kuri mar o kuhê nẽ tee ri kêp kaxkwa rũm mẽ apkur xà maati pyràk ã amnhĩ jarẽnh ma nhũm ja mẽ kãm mex kêt nhũm mẽ kamã gryk nẽ. ");
INSERT INTO apnNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Jakamã axpẽn mã ri harẽnh o: —Tk. Kwa mo na ri ã amnhĩ jarẽnh anẽ? Kêp mẽ panhĩõ kênã kot kêt ri kêp kaxkwa nhõ xwỳnh ã amnhĩ jarẽ. Kêp Juje mẽ Marir wa hkra na. Mẽ pahte katorxà mẽ hipêêxà wa omunh mex kênã kot kêt axtem nẽ kêp kaxkwa nhõ xwỳnh ã amnhĩ jarẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Hãmri nhũm amnhĩ tã mẽ kuma nẽ mẽ kãm: —Kwa mẽ ã ijarẽnh anhỹr kêt nẽ. ");
INSERT INTO apnNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Koja Inhĩpêêxà kot mẽ awỳr inhmẽnh xwỳnhta tanhmã mẽ hkrã hto nhũm mẽ rĩ kormã amnhĩ tã ja hã ixpumu nẽ amnhĩ kaxyw ixkôt hamaxpẽr. Tã ã mẽ kot amnhĩ nhĩpêx anhỹr xwỳnhjaja koja mẽ nhỹrmã htyk tã pa akupỹm mẽ ho mẽ htĩr nhũm mẽ wa ixri htĩr tũm nẽ mex kumrẽx nẽ pa ho pa. ");
INSERT INTO apnNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","—Amnepêm Tĩrtũm kapẽr jarẽnh o mẽ pa xwỳnhjaja na prem ã ja jarẽnh anhỹr o: Koja Tĩrtũm mẽ hkrã kaxwỳnh kãm tanhmã mẽ kãm kapẽr o amnhĩrĩt to ho pa. Anhỹr o harẽnh. Jakamã mẽ kot Tĩrtũm kapẽr mar nẽ hkôt amnhĩ nhĩpêx xwỳnhjaja koja mẽ mããnẽn amnhĩ kaxyw pa ixkôt hamaxpẽr nẽ ixkôt ri amnhĩ nhĩpêx o pa. ");
INSERT INTO apnNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","—Nẽ mẽ apê pika nhõ xwỳnhjê hõ aa mẽ ate ixkĩnhã ano ho Inhĩpêêxà pumunh kêt. Ãm papxipix na ixte omunh. Kurũm na pa pre mẽ awỳr wrỳ. ");
INSERT INTO apnNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Tã kot ka mẽ atõ amnhĩ kaxyw ixkôt ajamaxpẽr. Hã kot kaj nhỹrmã wa ixkuri atĩr tũm nẽ amex nẽ apa ho apa. Kwa mẽ jam ajamaxpẽr tỳx nẽ. ");
INSERT INTO apnNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","—Nẽ ixpê mẽ axàpkurxà maati jakamã pa na ixpê akupỹm mẽ ho mẽ htĩr xwỳnh. ");
INSERT INTO apnNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Amnepêm mẽ panhĩgêtjaja kormã kapôt ã mẽ pa ri mẽ kot “manã” anhỹr xwỳnhta kur o ri pata ã na prem kukwak ri htĩr tũm nẽ pa ho pa hkêt nẽ. Na prem ri pa nẽ gaa nẽ rĩ hpigêt nẽ htyk pa. ");
INSERT INTO apnNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Axtem kaxkwa rũm mẽ apkur xà maati jarẽnh xwỳnhta pix kukwak ri na htem nhỹrmã htyk tã akupỹm htĩr nẽ wa ixri htĩr tũm nẽ mex nẽ pa ho pa. ");
INSERT INTO apnNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Ãm paa. Pa na htem inhĩ hkwỳ hkrẽ hãmri nẽ wa ixri htĩr tũm nẽ mex nẽ pa ho pa. Na pa pre ra amnhĩ grônh kôt mẽ awỳr wrỳ. Jakamã ka mẽ atõ inhĩ hkwỳ hkrẽ hãmri nẽ nhỹrmã atyk tã pa akupỹm ato atĩr ka Tĩrtũm mẽ wa ixri atĩr tũm nẽ amex nẽ apa ho apa. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Nhũm pre ã Jejus Ijaew mã amnhĩ jarẽnh anẽ. No ãm mẽ kãm amnhĩ tã kuxi nẽ amnhĩ jarẽ. Jakamã nhũm mẽ tee ri kuma hãmri nẽ tanhmã hã axpẽn mã kapẽr to. Mẽ kot hprĩ hã mar kêt nẽ ãm mẽ kot ĩ hkwỳ hkrẽrja pix jarẽnh mar jakamã tee ri hamaxpẽr nẽ axpẽn mã: —Kwa tanhmã kot kêt we amnhĩ to nẽ mẽ pamã amnhĩ nhĩ hkwỳ gõ pu mẽ kuku? Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","54","Hãmri nhũm amnhĩ tã mẽ kuma nẽ mẽ kãm: —Nà mẽ kot inhĩ hkwỳ hkrẽr nẽ ixkamrô hkwỳ ho hkõm xwỳnh pixjaja koja mẽ nhỹrmã Tĩrtũm mẽ wa ixri htĩr tũm nẽ pa ho pa. Ixte akupỹm mẽ ho mẽ htĩr xà hã arĩgrota ã kot paj mẽ ho mẽ htĩr nhũm mẽ wa ixri htĩr tũm nẽ mex nẽ pa ho pa. No kot kaj mẽ inhĩ hkwỳ hkrẽr kêt nẽ ixkamrô hkwỳ ho akõm kêt hãmri nẽ wa ixri atĩr tũm nẽ amex nẽ apa ho apa hkêt nẽ. Kwa mẽ jam ajamaxpẽr tỳx rãhã nẽ. ");
INSERT INTO apnNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Kêt inhĩja kêp mẽ apkur xà maati na. Nẽ ixkamrôja kêp mẽ hkõm xà maati na. Jakamã na htem inhĩ hkwỳ hkrẽ nẽ ixkamrô hkwỳ ho ixkõ nẽ ra kêp wa ixri mẽ htĩr tũm nẽ mẽ pa ho mẽ pa mã xwỳnh. ");
INSERT INTO apnNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Jakamã kot ka mẽ atõ inhĩ hkwỳ hkrẽ nẽ ixkamrô hkwỳ ho ixkõ. Hãmri pa amnhĩ tã apumu nẽ akarõ mã axà ka te apê pa pyràk o amnhĩ nhĩpêx o apa. ");
INSERT INTO apnNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Inhĩpêêxà kot mẽ awỳr inhmẽnh xwỳnhta kukwak ri na pa hte ixtĩr tũm nẽ ixpa ho ixpa. Tã ja pyrà nẽ kot kaj mẽ inhĩ hkwỳ hkrẽ hãmri nẽ ixkukwak ri wa ixri atĩr tũm nẽ apa ho apa mã xwỳnh. ");
INSERT INTO apnNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","—Jakamã na pa ã mẽ amã ixpê kaxkwa rũm mẽ axàpkur xà maati hã amnhĩ jarẽnh anẽ. Amnepêm mẽ panhĩgêtjaja na pre htem kapôt ã mẽõta kur o pa hãmri nẽ gaa nẽ hpigêt nẽ htyk pa. No kêt pa koja mẽ inhĩ hkwỳ hkrẽ hãmri nẽ mẽ kurom wa ixri htĩr tũm nẽ mex nẽ pa ho pa. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Nhũm pre ã Jejus mẽ kãm amnhĩ jarẽnh anẽ. Kormã Kapanaũ kamã Tĩrtũm kapẽr o mẽ ahkre xà hã ixkre kamã ã mẽ ahkre anhỹr o xa. ");
INSERT INTO apnNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Hãmri nhũm mẽ kot Jejus kôt mar o mẽ pa xwỳnhjaja ohtô nẽ ã kapẽr anhỹrja ma nẽ tee ri amnhĩ kukamã hamaxpẽr nẽ hã axpẽn mã: —Tk. Kwa pẽr kapẽrja ãm ri katii. Mẽhõ koja we kuma nẽ hkôt hamaxpẽr nẽ hkamrô nẽ ĩ kur o ri hkôt pa? Nà mẽ piitã mẽ kãm ja mexti hã. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Hãmri nhũm amnhĩ tã mẽ kuma nẽ mẽ kãm: —Kwa xà ixkapẽrja mẽ apê omnuj? ");
INSERT INTO apnNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Nà kot paj nhỹrmã ma akupỹm kaxkwa hwỳr api. Ixpê Tĩrtũm kot mẽ akaxyw ixãm xwỳnh ã ma akupỹm hwỳr api. Hãmri ka mẽ ã ixte amnhĩ nhĩpêx anhỹr ã ixpumu nẽ rĩ kormã ixkôt amnhĩ xunhwỳr japêr. ");
INSERT INTO apnNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Na htem mẽmoj kur kukwak ri kêp Tĩrtũm mẽ wa ixri htĩr tũm nẽ pa ho pa xwỳnh kêt nẽ. Rỳ amnhĩ krã hkôt tanhmã amnhĩ nhĩpêx to ho kêp wa ixri htĩr tũm nẽ pa ho pa mã xwỳnh kêt nẽ. Tĩrtũm mẽ wa Ixkarõ tãm na hte mẽ hkarõ mã agjê nẽ mẽ ho Tĩrtũm wa ixkuri mẽ htĩr tũm nẽ mẽ pa ho mẽ pa mã xwỳnh. Tã ỹ hã na pa ã mẽ amã ixkapẽr anẽ. Nom mẽ amã amnhĩ tã kuxi nẽ amnhĩ jarẽ. Tã kot kaj mẽ ixkapẽr ma nẽ ixkôt amnhĩ nhĩpêx. Hã kot kaj mẽ nhỹrmã wa ixri atĩr tũm nẽ amex nẽ apa ho apa. ");
INSERT INTO apnNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","65","No mẽ akwỳjaja na ka mẽ ixkapẽr ma nẽ ãm ama nẽ ixkôt ajamaxpẽr kêt nẽ. Jakamã na pa ã mẽ amã ixkapẽr anẽ nẽ mẽ amã: “Koja Inhĩpêêxàja tanhmã mẽ akrã hto ka mẽ rĩ kormã amnhĩ tã ixpumu nẽ amnhĩ kaxyw ixkôt ajamaxpẽr.” Anhỹr o mẽ amã ixkapẽr. Anẽ. Nhũm ã Jejus mẽ kãm kapẽr anẽ. Ra kot mẽ hkukamã mẽ omunh mex. Ra kot amnhĩ kaxyw mẽ kot hkôt hamaxpẽr mã xwỳnhjê pumunh nẽ mããnẽn mẽ kamã kot mẽõ pahi nhĩhkram haxàr mã xwỳnhja nhũm mããnẽn ra kot amnhĩ kukamã omunh mex. Jakamã nhũm ã mẽ kãm kapẽr anẽ. ");
INSERT INTO apnNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Hãmri nhũm mẽ kot hkôt kapẽr mar o mẽ pa xwỳnh kwỳjaja tee ri kuma hãmri nẽ hkaga nẽ axte hkôt pa hkêt nẽ. ");
INSERT INTO apnNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Hãmri nhũm tee ri mẽ kot hkaga nẽ ma mẽ mrar ã mẽ omu nẽ mẽ ixpê hkôt ixpa ho ixpa xwỳnh pê 12jê mã kapẽr nẽ mẽ inhmã: —Pa? No mẽ kajaja. Xà kot kaj mẽ uràk nẽ ixkaga nẽ ma akupỹm mra nà? Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Hãmri nhũm Simãw Pêtre kãm: —Nà kot paj mẽ akaga hkêt nẽ. Kapxipix na htem amnhĩ kaxyw akôt hamaxpẽr jao kêp Tĩrtũm mẽ war akuri htĩr tũm nẽ pa ho pa mã xwỳnh. ");
INSERT INTO apnNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Ka na pre Tĩrtũm mẽ ixwỳr amẽ. Jakamã na pa mẽ amnhĩ kaxyw akôt ijamaxpẽr o ri ixpa. Nà kot paj mẽ aa akaga hkêt nẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Hãmri nhũm kuma nẽ kãm: —Nà ixte amnhĩ kaxyw mẽ apê 12jê rênh tã na ka mẽ atõ akwỳjê hkĩnhã axtem nẽ Satanasti hkôt amnhĩ xãm. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Nhũm pre ã finat Jut Kariot kot mẽ inhõ pahijê nhĩhkram haxàrja kukamã mẽ inhmã harẽnh anẽ. Mẽ inhĩ õ na pre. Nẽ kêp Simãw Kariot kra na pre. Tã ra kot mẽ ĩhkram haxàr kaxyw nhũm Jejus kot amnhĩ kukamã omunh jakamã ã mẽ inhmã harẽnh anẽ. ");
INSERT INTO apnNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Tã nhũm Jejus arĩ Garirej kamã ri pa nẽ kormã akupỹm Jutej wỳr mõr kêt nẽ. Jutej kamã Ijaew nhõ pahijaja ra kot hã àmnênh nhũm mẽ kot hpĩr ã harẽnh jakamã nhũm mẽ umaj kormã hwỳr mõr kêt nẽ. ");
INSERT INTO apnNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Tã mẽ ixpê Ijaew mẽ ixte ixkre hkryre nhĩpêx nẽ hã ixkĩnh ã arĩgroja ra ahtêp o mõ. Mẽ ixkĩnhta ã na pa pre htem ixpiitã Jutej wỳr axpẽn wỳr akuprõ nẽ ahpỹnhã ri amnhĩm ixkre hkryre nhĩpêx nẽ kamã ixkrĩ. ");
INSERT INTO apnNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Jakamã nhũm Jejus tõjaja hwỳr mra nẽ kãm nojarêt nẽ amnhĩ kôt kuwỳ nẽ kãm: —E kwa tokyx pu mẽ pahkwỳjê hkôt. Ka mẽ kãm aa mẽ kot mẽmoj pumunh kêt kwỳ ho anhỹr o ri mẽ hkôt apa kê mẽ kãm akapẽr mar prãm xwỳnhjaja ja hã apumu. ");
INSERT INTO apnNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Na ka hte jar te apimxur pyràk o amnhĩ nhĩpêx. E kwa tokyx ma pu mẽ hkôt. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Katorxà hkôt mẽ kêp Jejus tõ htã kormã amnhĩ kaxyw hkôt hamaxpẽr kêt jakamã na prem ã kãm kapẽr anẽ. ");
INSERT INTO apnNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Hãmri nhũm mẽ kãm: —Nà kormã. Kormã ixte mẽ kãm amnhĩ to amnhĩrĩt xà hã arĩgro kormã kator kêt. Jakamã kot ka mẽ amã mẽ hkôt amrar prãm nẽ mãmrĩ ma mẽ hkôt mra. ");
INSERT INTO apnNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Koja mẽ apumu nẽ kãm mẽ akurê hkêt nẽ. Nẽ mẽ akamã gryk kêt ka mẽ ri tanhmã amnhĩ nhĩpêx to ho mẽ hkôt apa. No pa kot paj mẽ hwỳr mõ nẽ mẽ kãm mẽ kot amnhĩ tomnuj o pa hã mẽ harẽnh o ri mẽ hkôt ixpa nhũm mẽ tee ri amnhĩ tã inhma nẽ ixkamã gryk nẽ. ");
INSERT INTO apnNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Jakamã mẽ mãmrĩ ma mẽ hkôt mõ. Kot paj kormã. Kormã ixte mẽ kãm amnhĩ to amnhĩrĩt xà hã arĩgroja kormã kator kêt. ");
INSERT INTO apnNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Anẽ nhũm mẽ tee ri kuma hãmri nẽ kure nẽ ma mẽ hkwỳjê hkôt Jutej wỳr mõ. Nhũm Jejus kormã Garirej kamã ri pa hã apkati grêre. ");
INSERT INTO apnNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Hãmri nẽ kormã ma hapu hã mẽ hkôt mõ. Pa mẽ hkôt ri ixpa ho ixpa xwỳnhjaja ma hkôt ixpa. ");
INSERT INTO apnNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Rôm nhũm ra mẽ ixpê Ijaew nhõ pahijaja mẽ hkĩnhja kamã mẽ pikuprõnh xwỳnhjê kaêx ã Jejus japêr o ri mra. Nẽ hã axpẽn kukjêr o mra nẽ axpẽn mã: —Kwa nok? Nhỹri mãn we? Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Nhũm Ijaew piitã tanhmã axpẽn mã Jejus jarẽnh to ho pa. Nẽ kamã mẽ hkwỳjaja harẽnh o: —Nà kot amnhĩ to mex o pa xwỳnh na. Anhỹr o harẽnh o pa. Nẽ kamã mẽ hkwỳjaja axtem nẽ harẽ nẽ harẽnh o: —Tk. Kot mẽ no kupyr o pa xwỳnh kênã. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Nom mẽ õ pahi pymaj mẽ piitã mẽ nom tanhmã harẽnh to hkêt nẽ. Ãm axpẽn mã pix mã tanhmã harẽnh to ho pa. ");
INSERT INTO apnNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Tã pa mẽ mẽ hwỳr pôj. Jejus mẽ pa mẽ hkôt ixpa ho ixpa xwỳnhjaja mẽ hwỳr pôj. Kormã mẽ hkĩnhja hapêx kêt ri. Hãmri pa mẽ Jejus kôt Tĩrtũm mã amnhĩ jarẽnh xà hã ixkreja wỳr mra nẽ agjê nhũm Jejus mẽ ahkre ho nhỹ. ");
INSERT INTO apnNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Hãmri nhũm mẽ inhõ pahijaja tee ri kot tanhmã mẽ ahkre hto hã kuma nẽ hã axpẽn kukja nẽ axpẽn mã: —Kwa mẽ pahkĩnhã kot Tĩrtũm kapẽr o istuda hkêt tã ã mẽ ahkre anẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Hãmri nhũm amnhĩ tã mẽ kuma nẽ mẽ kãm: —Nà na pa hte amnhĩ krã hkôt tanhmã ri mẽ ajahkre hto hkêt nẽ. Ãm kot mẽ awỳr inhmẽnh xwỳnhta nhỹ hã na pa hte ã mẽ ajahkre anhỹr o ri mẽ akôt ixpa. ");
INSERT INTO apnNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Tã kot kaj mẽ amã Tĩrtũm kãm hprãm xà hkôt amnhĩ nhĩpêx prãm hã kot kaj mẽ ixte ỹ hã ixkapẽr ã ixpumunh kurê kumrẽx. ");
INSERT INTO apnNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Amnhĩ krã hkôt mẽ kãm kapẽr o ri mẽ pa xwỳnhjaja na htem mẽ kot mẽ mar nẽ mẽ hã hpijaàm pix kaxyw tanhmã mẽ kãm kapẽr to ho ri pa. No kêt pa na mẽ ate ixkapẽr mar nẽ kot mẽ awỳr inhmẽnh xwỳnhta ã apijaàm pix kaxyw na pa hte tanhmã mẽ amã ixkapẽr to ho ri ixpa. Jakamã ãm hãmri na pa hte mẽ amã ixkapẽr o ri ixpa. ");
INSERT INTO apnNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","—Finat Mojes na pre mẽ panhĩgêtjaja kot tanhmã amnhĩ nhĩpêx to ho pa nhũm Tĩrtũm kot mẽ kãm hã karõ jarẽnh o ri mẽ hkôt pa htã ka mẽ hkôt amnhĩ nhĩpêx kêt nẽ. Tã ixte hkôt amnhĩ nhĩpêx kêt ã ixto axêx nẽ mẽ ate ixpĩr kaxyw ixtã amnhĩ jarẽnh ri apa. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Hãmri nhũm mẽ ã Jejus kot mẽ kãm kapẽr anhỹrja ma nẽ hêx rom kãm: —Kwa mẽ ixtõ na pa apĩr mã ka ri ã mẽ ijarẽnh anẽ? Amrakati kênã. Kwa mãn ka akrã axpã nà? Hã na ka ã ri akapẽr anẽ. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Hãmri nhũm mẽ kãm: —Nà ixte mẽ pahkôt xà hã arĩgro hã akupỹm mẽhõ myta ho mex jakamã na ka prem ja hã ixpumu nhũm ja mẽ apê omnuj nẽ. Nẽ te ixte mẽ pahkôt xà hã arĩgro hã ixpijaàm kêt xwỳnh pyràk ã ijarẽ. ");
INSERT INTO apnNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Nom na ka htem ixpyrà nẽ mẽ panhõ arĩgromnu hã mẽmoj tã axàpênh o ri apa. E pa mẽ amã mẽmoj jarẽ ka mẽ inhma. Na pre finat Mojes mẽ pamã mẽ pahte mẽ pahkra myre pê my kwrỳt kà jakàr ã mẽ pamã karõ. Kukamã higêtjaja kot kãm ja hã karõ xà hkôt. Jakamã na htem mẽ hkra myre hapôj nẽ hã semãn pyxi nẽ hapêx nhũm mẽ kêp mẽmy hkwrỳt kà jakà. ");
INSERT INTO apnNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Mẽ pahkôt xà hã arĩgro hã hõ kator tãã nhũm mẽ hã semãn pyxi nẽ mẽ panhõ arĩgromnu hõ hã kêp my kwrỳt kà hkwỳ krãhta. Mojes kot Tĩrtũm nhỹ hã ja hã mẽ pamã karõ xà hkôt. Jao mẽ panhõ arĩgromnu hã apê. Tã pa pre mẽ apyrà nẽ arĩgromnu hã ixàpênh pê akupỹm mẽhõ myta ho mex ka mẽ ja hã ixpumu nẽ axtem nẽ ixtỳx ri ixte amnhĩ nhĩpêx o ixpa xwỳnh ã ijarẽ nẽ mẽ ate ixpĩr kaxyw ã amnhĩ jarẽ. ");
INSERT INTO apnNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Kwa mẽ amnhĩ krã hkôt tanhmã mẽ harẽnh to ho ri apa hkêt nẽ. Ãm mẽ kot tanhmã amnhĩ nhĩpêx to ho pa hã mẽ omu nẽ ajamaxpẽr o: “Kwa xà we Tĩrtũm kãm ja mex nà?” Anhỹr o mãn kêt mẽ ajamaxpẽr nẽ rĩ kormã tanhmã mẽ harẽnh to. Anẽ. ");
INSERT INTO apnNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Hãmri nhũm Jerujarẽ nhõ xwỳnh kwỳjaja ja hã kuma nẽ tee ri hkukamã hamaxpẽr. Hãmri nẽ hã axpẽn kukja nẽ axpẽn mã: —Kwa xà tãm na mẽ panhõ pahijaja mẽ kot hpĩr kaxyw hã amỹnê? ");
INSERT INTO apnNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","