﻿USE sofia;
DROP TABLE IF EXISTS sofia.apec_vpl;
CREATE TABLE apec_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES apec_vpl WRITE;
INSERT INTO apec_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Jisas Krais ananish popehesh yamehesh esheshish nyeiguhw douk eshudok. Jisas ananin yamenen Devit. Devit ananin yamenen Abraham. ");
INSERT INTO apec_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham ananin nuganin Aisak. Aisak ananin nuganin Jakob. Aria Jakob nabuki Juda nani ananim owarhim. ");
INSERT INTO apec_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Juda nabuki Peres nani Sera. Amamik amakek douk Tamar. Peres ananin nuganin Hesron. Hesron ananin nuganin Ram. ");
INSERT INTO apec_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ram ananin nuganin Aminadap. Aminadap ananin nuganin Nason. Nason ananin nuganin Salmon. ");
INSERT INTO apec_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmon ananin nuganin Boas. Boas ananik amakek douk Rehap. Boas ananin nuganin Obet. Obet ananik amakek Rut. Obet ananin nuganin Jesi. ");
INSERT INTO apec_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Jesi ananin nuganin douk king Devit. Devit ananin nuganin douk Solomon. Solomon ananik amakek seiwok Uria ananik irohukwik. ");
INSERT INTO apec_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomon ananin nuganin Rehoboam. Rehoboam ananin nuganin Abiya. Abiya ananin nuganin Asa. ");
INSERT INTO apec_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa ananin nuganin Jehosapat. Jehosapat ananin nuganin Joram. Joram ananin nuganin Usia. ");
INSERT INTO apec_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Usia ananin nuganin Jotam. Jotam ananin nuganin Ahas. Ahas ananin nuganin Hesekia. ");
INSERT INTO apec_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hesekia ananin nuganin Manase. Manase ananin nuganin Emon. Emon ananin nuganin Josaia. ");
INSERT INTO apec_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josaia ananim nugamim douk Jehoiakin nani ananim owarhim. Abudok nyutob eshesh Israel shanak shonoweshik shape gani Babilon. ");
INSERT INTO apec_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Shanak shonoweshik shape Babilon aria Jehoiakin nabuki Sealtiel. Sealtiel ananin nuganin douk Serubabel. ");
INSERT INTO apec_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Serubabel ananin nuganin Abiut. Abiut ananin nuganin Eliakim. Eliakim ananin nuganin Asor. ");
INSERT INTO apec_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Asor ananin nuganin Sadok. Sadok ananin nuganin Akim. Akim ananin nuganin Eliut. ");
INSERT INTO apec_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliut ananin nuganin Eleasar. Eleasar ananin nuganin Matan. Matan ananin nuganin Jakob. ");
INSERT INTO apec_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jakob ananin nuganin Josep. Aria Josep narao Maria aria kwobuki Jisas douk shuhwaran um Krais, douk Iruhin nakriyan neshopokan nanaki iri. ");
INSERT INTO apec_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Namudok aria shadarehi awiros arpesh douk shape iri Abraham napeyobi nyutob arigaha shanaki shatogrumori Devit natogur obi nyutob asudok awiros sanak satogrum 14-poreis. Aria ta shadareh Devit napenyobi nyutob arigaha shanak shatogrumori abudok nyutob eshesh Babilon shanaki sharao eshesh Israel shanak showeshikesh shape Babilon obi douk shopuk shadarehas sanak satogur um 14-poreis awiros. Aria shopunek shadarehi abudok nyutob shabi shape Babilon obi arigaha shanak shatogur um Krais natogur nape obi nyutob um douk shopuk namudok atin, shadarehas sanak satogur 14-poreis. ");
INSERT INTO apec_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Jisas Krais nonokwarum ahi aih douk namudok. Ananik amakek Maria douk shagraehok um kurao Josep. Eshesh biyesh ta shunoraum aria madae shishuh atugun uwe, uwok aria okwok kwanodukem um okwok kwonorahaen Iruhin ananin Mishin nyanaki nyawishok aria shatik um okwok douk kwunarahaen. ");
INSERT INTO apec_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Josep yopini arman, madae nunek inahos uwe, uwok. Anan abraen nyan aria nanaiwos nukok abraen Maria uwe, uwok. Aria anan nabo baraen shokubur atin um anan kanak ta nunoiwos irohukwik, Maria. ");
INSERT INTO apec_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Anan nape nonek urkum um enyudok baraen obi nyutob, enen Iruhin ananin ensel nyatogruman anas yomnis aria nyakripan, “Josep, Devit barhonin, mare nyunotitik um nyurao Maria um nyakik irohukwik. Okwok kwonorahaen um Iruhin ananin Mishin. Madae anan arman nonukok uwe, uwok. ");
INSERT INTO apec_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Okwok ko kwubanuh kubuki anan nuganin. Aria nyak ta nyuhwaran nyeigur Jisas, um maresh anan ko nugamoh arpesh shukutukuk yoweishi inahos aria shutanamori shupe wosik atin.” ");
INSERT INTO apec_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Eshudok eneshenesh shenenek shagipesh baraen seiwok anan profet noko Iruhinin baraen iri anan nakri namudok, ");
INSERT INTO apec_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Onok madae kuti armam iri ta kweyetueguk, kwubanuh aria kubuki anan nuganin, aria shuhwaran Emanuel. Enyudok baraen nyakri namudok, Iruhin nani apak nape.” ");
INSERT INTO apec_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Aria Josep neshuh nakitak aria narao Maria um ananik irohukwik, kabi da Iruhin nakripan um. ");
INSERT INTO apec_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Aria Josep madae nini Maria shishuh atugun uwe, uwok. Aria Maria kwobanuh kwobuki anan nuganin. Aria nodowon nyeigur Jisas. ");
INSERT INTO apec_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Maria kwobuki Jisas abrudok wabur Betlehem. Ababur douk bape agudok shokugi nahobig Judia. Aria abudok nyutob, Herot douk nenek king nape Debeini um Judia. Maria kwobuki Jisas ba iyoh aria anam hadukem eneshenesh iri hape iri gani aun nakihumori hanaki hatograri Jerusalem. ");
INSERT INTO apec_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Hanaki aria harigesh hakri, “Anudok batowinyin nonokwarum um nunek king um eshesh Juda iri nape agunum? Apak douk matik ananik unuk gani aun nakihumori aria douk manakumori munek lotuman.” ");
INSERT INTO apec_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","King Herot nemnek enyudok baraen, ba akas sanun. Ihish arpesh shape Jerusalem iri shopunek arugoguhwiar waesh. ");
INSERT INTO apec_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Aria nenekumam baraen amam pris amamim debeimi hani amudok anam henek skulumesh um lo iri hanaki hatrun. Hanaki aria narigam nakri, “Anudok arman Krais douk Iruhin nakriyan neshopokan nunaki iri ko nunukwarumori meiburi wabur?” ");
INSERT INTO apec_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Aria hakripan hakri, “Gani Betlehem douk bape agudok shokugi nahobig Judia iri. Seiwok anan profet nowemaguk baraen aria nakri namudok, ");
INSERT INTO apec_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Seiwok Iruhin nakri, ‘Ipak pape abrudok wabur Betlehem douk bape agudok shokugi nahobig Judia iri, ipak pumnek. Ipak madae pupe pigigi um amam debeimi douk hasuhw merik um Judia iri uwe, uwok. Aria amu wouwokuk. Umum maresh, um nyak atin kweipon anan debeini arman nutogur ipak arpesh pape Betlehem iri. Aria anan kweipon nupe debeini um ipak eikish arpesh Israel.’” ");
INSERT INTO apec_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Herot nemnek namudok aria nanabeshuk nenekumam baraen amudok douk hape iri aun nakihumori hanaki iri. Nenekumam baraen aria hanak hatrun. Aria anan narigam um da marab nyutob okwudok unuk da kwatogur. ");
INSERT INTO apec_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Aria anan neshopokam hunak Betlehem, aria nakri namudok, “Punak aria shokubur atin gamo pupe purim anudok nuganin. Ipak puriman ba puparugon aria ta putanamori ba pukrip eik. Umum maresh, eik shopunek yakana inak inek lotuman.” ");
INSERT INTO apec_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Douk hemnek king ananin baraen aria amam hanak. Amam hanak yah aria ta hatik okwudok apunik unuk douk harik hatrukwi gani aun nakihumori iri. Okwok kwarig atin aria amam hagipeshok arigaha kwanak kwotem iruhw anudok nuganin neshuh atari urupat. ");
INSERT INTO apec_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Amam hatik okwudok unuk aria amam hanadudareh hanaboum mishish. ");
INSERT INTO apec_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Aria amam hunak hawish atudok urupat aria hatik nuganin nani amakek Maria shape. Aria habuh hoduk ohrubus hatao atap henek lotuman. Aria hapuk amamigas banagas hatuki eshudok hatorishi debeibori utabor iri aria hukanesh. Hakon gol rani paura nyeisig yopuri unar iri shohwaren um frankinsens aria sani enen yopunyi sanda nyeigurinyum mir. ");
INSERT INTO apec_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Hakon eshudok aria heshuh nagundok Betlehem. Heshuh habo anas yomnis aria Iruhin nakripam dodogowinyi baraen um maresh hutanam hutiguk Herot uwe, uwok. Namudok aria amam hagipesh kupaihi yah hatanam hanam amamig nahobig. ");
INSERT INTO apec_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Douk amudok biom atun hanakuk aria Josep neshuh nonabek anas yomnis. Aria enen Debeini ananin ensel nyatogruman aria nyakripan nyakri, “Nyikitak nyurao nuganin nini amakek aria arigah punam agudok nahobig Isip. Punak pupe ganudok arigaha eik ta ikripep aria ta putanamori. Umum maresh, Herot douk nakana nupe nurim nuganin um ta non nugok.” ");
INSERT INTO apec_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Namudok aria Josep nakitak nurao nuganin nani amakek aria abudok atub wab shapa shanam Isip. ");
INSERT INTO apec_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Josep nani Maria shabuh shape nagundok arigaha Herot nagok. Enyudok douk nyatogrum enen baraen seiwok Debeini nohur anan profet neyagwrehenyuk iri nyatogur adurin atin. Baraen enyudok. Iruhin nakri, “Eik yohwar eikin Nuganin nakutukuk Isip nanaki.” ");
INSERT INTO apec_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Herot nape aria nadukemeshum amudok hape iri aun nakihumori hanaki iri douk hagiyagiman hanak kupaihi yah. Namudok aria ananibur nyibur akasibur atubur. Aria noguwak anam soldia hanam Betlehem bani warub bape hurukatin um Betlehem iri um hubo ihim shokumi batowishim hugok. Hubo amudok douk biyesh aka atin atin kwarahos shadiyom iri atum. Umum maresh, anan nadukemeshum douk hakripan hakri abudok nyutob hatik unuk um. ");
INSERT INTO apec_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Enyudok douk nyatogur um enen baraen seiwok Iruhin nohur profet Jeremaia neyagwrehenyuk iri nyutogur adurin atin. Baraen enyudok. Iruhin nakriyenyi. ");
INSERT INTO apec_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Shemnek anah mah abrudok wabur Rama. Shemnek onok armatok kworeh kwabo sawiyeguh kunak. Resel kwape kworep okwokwim nugamim. Kworeh aria madae enen arpen ko wosik nyugapeshumok okwokwish urkum apahw.” ");
INSERT INTO apec_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Arigaha douk Herot nagokuk aria Josep nonabek anas yomnis gani Isip. Enen Debeini ananin ensel douk nyonohur aria nyakripan namudok. ");
INSERT INTO apec_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Nyakri, “Nyikitak nyurao nuganin nini ananik amakek aria ta putanam punam Israel. Amudok douk hakrium hubo nuganin nugok iri douk hagok.” ");
INSERT INTO apec_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Namudok aria Josep nakitak nurao nuganin nani ananik amakek aria ta shatanam shanam Israel. ");
INSERT INTO apec_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Shanak aria Josep nemnek baraen um shakri Akeleas narao ananin yaken Herot ananik outuk natogur king nape Debeini um agudok shokugi nahobig Judia. Namudok aria Josep ta nanogugur um nunam Judia. Arigaha douk ta nonabek anas yomnis aria Iruhin nakripan enen baraen. Namudok aria shanam agudok shokugi nahobig nyeigurigum Galili. ");
INSERT INTO apec_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Shunak aria shabuh shape anabur wabur shohwarabur um Nasaret iri. Namudok aria enen baraen seiwok amam profet henyemaguk iri nyatogur adurin atin. Baraen enyudok. “Anan douk ko shuhwaran shakana anan Nasaret-epimin.” ");
INSERT INTO apec_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Abudok nyutob Jon nenek baptaisumesh iri douk nanaki nape apa nakripesh Iruhin ananin yopinyi baraen. Arpesh shanaki aria apa nape nakripeshen agudok shokugi nahobig Judia agundok wehigunum arpesh wokagunum. ");
INSERT INTO apec_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Nakripesh namudok. Nakri, “Ipak pubukuk yoweishi inahos aria putanam pukon aparuh Iruhin aria putogur ananish arpesh. Umum maresh, abudok nyutob um arpesh shuwish um agundok Iruhin nape Debeini um ananish arpesh shapeum heven douk hurukatin um ko butogur.” ");
INSERT INTO apec_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Jon anan douk anudok arman seiwok Iruhin nohur profet Aisaia neyagwrehuk enen baraen nakri namudok, “Enen arpen nyape nyohwar gani wehigunum arpesh wokagunum. Nyohwar nyakri, ‘Gapeshuman yah Debeini. Pugapeshah ba greg atin hatem um anan nugimah nunaki um!’” ");
INSERT INTO apec_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Jon nenekah iri rupah douk shenekah enen mahin shohwaren um kamel iri enyenyirub ehirub. Aria let nuwashot iri douk shenekat anap mahinyip yegenyihwip. Worigun nagnoh iri douk napeum nawok gormish aria akehinyi lele da nyor numun marubusigas aragas iri. ");
INSERT INTO apec_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Aria abudok nyutob arpesh shape iri Jerusalem iri, shape iri ihirub warub agudok shokugi nahobig Judia iri, shape iri ihirub warub bape hurukatin um worub Jodan iri, worobaishi shanaki um shumnek Jon. ");
INSERT INTO apec_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Shanaki showereh shenekeshi yoweishi inahos aria nenek baptaisumesh abudok worub Jodan. ");
INSERT INTO apec_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Jon natik worobaimi Farisi hani Sadyusi hanamori hutrun um nunek baptaisumam aria nakripam namudok, “Ipak ogwuhwudok yoweiguhwi yuguhwim nugamim, Iruhin da akasin atun um ipak. Amiapen nyakripep um ta puruwok um eshudok yoweishi douk nakri nenekesh shutogurum ipak iri? ");
INSERT INTO apec_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Ipak douk pubodig nyirub aria ko punek yopishi eneshenesh um ta wosik piyabigesh namudok adur atin ipak da punek gihaum ipakish yoweishi inahos aria putanam pukon aparuh Iruhin aria putogur ananish arpesh. ");
INSERT INTO apec_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Ipak pur urkwip ipakiruh aparuh namudok, ‘Abraham anan douk apakin yaken. Eik yakri ikrip ipak namudok, Iruhin anan douk adur atin ko nuhur abrudok utabor aria nubranam um butogur Abraham ananish batowish.’ ");
INSERT INTO apec_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Arubar iganigadae banowatak bakus um buburow rowogig baug. Ihigosum rowos madae subuki yopipi shurkwip ba piragos iri, agusudoki rowos ko shuburo-ogos aria shuwashogos um nyih hunugos. ");
INSERT INTO apec_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“Eik douk yenek baptaisumep um abar kabi da enen kak um ipak douk pubukuk eshudok yoweishi inahos ipak da penekeshi iri aria pubodig nyirub aria patanam pakon aparuh Iruhin aria putogur ananish arpesh. Aria anudok ko nugimori eik iri, anan ko nunek baptaisumep nukwu Iruhin ananin Mishin. Anudok ananin dodog nyenek uhwin um eikin dodog eik madae yopue ipe wosik um ta isuhwuman ananiyu su uwe, uwok. Anan ko nunek baptaisumep nukwu Iruhin ananin Mishin nyini nyih. ");
INSERT INTO apec_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Anan ko nunaki kabi da anan arman nasuhwi anap neitip ananis wis um aria nunaki nudum ihish witish nyubuhas nushubuk sik. Aria yaputi shuruwepit wit anan ko nutubuk gani ananit urupat nobuk wit ati. Aria ihish witish nyubuhas anan ko nushaisheh nukwu ehudok yoweihi nyih douk hanu hape namudok atin iri madae ta hugoki uwe, uwok.” ");
INSERT INTO apec_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Abudok nyutob Jon nape apa nenek baptaisumesh abar, aria Jisas nakitak nakutukuk agudok shokugi nahobig Galili aria nanam worub Jodan. Anan nanam Jon um nakana Jon anan kanak ta nenek baptaisuman. ");
INSERT INTO apec_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Aria Jon nakri uwok um ta nunek baptaisuman aria nakripan nakri namudok, “Eik yakri wosik um nyak ta nyunek baptaisum eik. Umum maresh, ba nyak ta nyunakmori eik?” ");
INSERT INTO apec_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Aria Jisas ta nasuhman baraen nakripan namudok, “Meyoh um enyudoki baraen, douk nyak nyenekesh kabi da eik yakri um. Namudok wosik um apak munekesh namudok um miyabig ihishmorim um ihinyumorim yopiyopinyi baraen um Iruhin nakriyenyi um enyudok yopinyi poe.” Aria Jon nemnek Jisas aria nunekesh kabi da anan nakri um nunek baptaisuman. ");
INSERT INTO apec_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Douk Jon nenek baptaisuman jurug, aria Jisas nakutukuk worub nanatu natowi neyotu iruhw hurus. Aria atub nyutob anan nanig natik utag ganupok um heven ibur wabur, aria anan natik Iruhin ananin Mishin nyabuhi kabi da anar armir runahwaram manyun um rabuhi retem Jisas. ");
INSERT INTO apec_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Aria anah mah heyagwrehi gani iruhw heven namudok, “Anudok eik kanak eikin nuganin. Eik yanawash abom iri. Eikish urkum apahw shakri shanadudareh shanawashaman abom iri.” ");
INSERT INTO apec_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Douk Jisas nenek baptaisum jurug aria Iruhin ananin Mishin nyaran nyunak gani wehigunum arpesh uwok um, aria Satan ko nukwiraehan um nunek yoweishi inahos. ");
INSERT INTO apec_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Aria Jisas nanak nape nubatib tenabih nyumnegwih weibus nape meyoh um madae nuwok worigun uwe, uwok. Arigaha takweirubi nyurub ban. ");
INSERT INTO apec_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Aria Satan nanaki nakripan namudok, “Nyak da Iruhin in nuganin um aria nyak krip abrudok utabor ba butogur bret.” ");
INSERT INTO apec_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Aria Jisas nakripan namudok, “Baraen nyetem Baibel iri nyakri namudok, ‘Arpesh madae shuwok bret atut ba ta shupe wosik atin uwe, uwok. Arpesh ta shupe wosik atin um shumnek Iruhin ananin ihin baraen niyagwrehenyi.’” ");
INSERT INTO apec_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Jisas nakri namudok aria Satan ta naranum yopuburi wabur Jerusalem. Aria nakih nowem Jisas neyotu gani iruhw iruhuguk um atudok Iruhin ananit debeiti urupat. ");
INSERT INTO apec_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Aria Satan nakripan namudok, “Nyak douk Iruhin ananin Nuganin um, aria nyak sapurak buh gani atap. Umum maresh, baraen nyetem Iruhin ananik buk iri nyakri namudok, ‘Iruhin ko nukripesh dodogowinyi baraen ananish enselahos um shunaki shegemenyukuk aria shusuwenyukuk iruhw esheshis wis. Namudok aria nyakiruh yeriweruh ko mare hunubo anam atum utom uwe, uwok.’” ");
INSERT INTO apec_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Aria Jisas nakrip Satan namudok, “Baraen nyetem Iruhin ananik buk iri shopunek nyakri namudok, ‘Nyak ta mare nyukwiraeh nyakin Debeini um nenek yoweishi inahos, anan da nyakin Iruhin.’” ");
INSERT INTO apec_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Aria ta shopunek Satan ta naran nato onohw hwato abom iri yoduhw. Hakih aria Satan neyabigan ihigosmorim nahobigos sape abudok amnab iri sani ihishmorim yopishi eneshenesh shape agudok nahobig iri. ");
INSERT INTO apec_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Aria anan nakrip Jisas namudok, “Nyak douk atin nyuduk ohrubus aria nyuhwido barag gubuh atap aria nyenek beten um eik, aria eik ko iken eshudok ihish eneshenesh um nyak.” ");
INSERT INTO apec_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Aria Jisas nakripan namudok, “Satan nyak karuwok-mokuk um eik! Baraen nyetem Iruhin ananik buk iri douk nyakri namudok, ‘Nyak ta ko nyunek beten um Debeini atun anan da nyakin Iruhin aria nyunek anan atun ananin atin mour.’” ");
INSERT INTO apec_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Jisas nakripan namudok aria Satan nakutunukuk aria nanak. Aria enesh enselahos shanaki shatauruman. ");
INSERT INTO apec_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Abudok nyutob Jisas nemnek Jon da nonoweshik nape shunuweshik-ati urupat, aria anan nakitak natanam nanak agudok nahobig Galili. ");
INSERT INTO apec_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Aria anan madae nanak nupe ananibur wabur Nasaret aria amu nenek atin nanak nape kupaiburi wabur Kaperneam. Abrudok wabur douk bape anagas um debeigi Galilieg waiyag hurukatin um abudok biyab amnab nyeiguribum Sebulun aria Naptali. ");
INSERT INTO apec_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Jisas nenekesh namudok um enen baraen seiwok Iruhin nohur profet Aisaia neyagwrehenyuk iri nyatogur adurin atin. ");
INSERT INTO apec_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Baraen enyudok. Nyakri, “Debeibi amnab Sebulun aria debeibi amnab Naptali, abudok amnab douk bape hurukatin um debeihi yah hanam youg gwani amnab douk bape gani wobrab worub Jodan iri um agudok nahobig douk Galili. Agundok worobaishi arpesh douk eshesh madae Judaishi aria eshesh shopunek da shanaki shape agundok. ");
INSERT INTO apec_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Eshudok arpesh shapeum arukwut iri, eshesh douk shatik bogaragun um! Eshudok arpesh shapeum arukwut-igunum atugun iri, douk shape bogaragun um atin!” ");
INSERT INTO apec_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Aria abudok nyutob Jisas nape nakripesh baraen nakri, “Ipak pubukuk apa punegeshi yoweishi inahos aria putanam pukon aparuh Iruhin aria putogur ananish arpesh. Umum maresh, abudok nyutob um arpesh shuwish um agundok Iruhin nape Debeini um ananish arpesh shapeum heven douk hurukatin um ko butogur.” ");
INSERT INTO apec_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Anah nyumnah Jisas nape nanarahaen nanak anagas um debeigi Galilieg waiyag aria natik biom armam ashuken nani wanin. Anan douk Saimon. Ananin kupainyi nyeigur da shohwaran um Pita. Anan nani ananin wanin Andru, amam douk hape howashak umbenab agudok Galilieg waiyag. Amam biom hatuk eiguhw um ta shutoruguh shukam utabor. ");
INSERT INTO apec_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Douk natrum aria nakripam nakana, “Ipak biom yowi pugipesh eik, aria eik ta iyabigep um ta purao arpesh shunaki shugipesh eik.” ");
INSERT INTO apec_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Douk amam hemnek atin aria hakutukuk amamib umbenab bakuk aria hagipesh Jisas hanak. ");
INSERT INTO apec_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Anan nagim waiyag nanaku shopunek, aria ta natigu kupaimi biom armam ashuken nani wanin, Jems, Sebedi ananin nuganin, nani ananin waninuman Jon. Amam biom hani amamin yaken, Sebedi da hatem bot, aria apa hagabe amamib umbenab. Jisas natrumugu aria nahwaram um hugipesh anan. ");
INSERT INTO apec_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Nohwaromugu aria atub nyutob ahudok atuh nyumnah hakutukuk bot tani amamin yaken napeik, aria hakitak hanaman hanak. ");
INSERT INTO apec_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Jisas narahaen nanak ihirub warub agudok nahobig Galili. Nanak nawish agundok eshesh Juda shantorum shape sheneyagwreh-ogwi urusag aria nape nakripesh Iruhin ananin yopinyi baraen. Nakripesh um agundok eshesh ko shuwish um agundok Iruhin nape debeinium ananish arpesh um. Nakripesh baraen aria nagapesh ihishmorim da yowe yoweihi arugeh henekesh iri aria yopish. ");
INSERT INTO apec_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Aria baraen nyanak ihigunum agudok nahobig Siria um enyudok Jisas neneken iri mour. Namudok aria shrauri ihishmorim douk yoweshum yomo yomogihi arugeh henekeshi kabi da debeiri eriger rapeyeshi, yoweishi sagabehos shapeyeshi, eshudok shatu ba krukruk shakuh iri aria eshudok roguhw aiyas shagokesh iri. Aria Jisas nugabe ihishmorim ba yopish. ");
INSERT INTO apec_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Aria sabaishi shemnek baraen ba shunaki, eshesh da shanaki arbudok warub bani nahobigos. Eshesh shanaki Galili, Jerusalem aria Judia. Enesh douk shape iri gani wobrab worub Jodan shanaki. Aria enesh douk shanaki anab amnab douk 10 poreirub warub bapeim shahwarogun um Dekapolis, eshudok ihishmorim eshesh shape arbudok warub iri shanaki aria shagipesh Jisas. ");
INSERT INTO apec_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Jisas natik eshudok worobaishi arpesh shantorum shanaki aria nanak nato anag mihig. Aria nakih nape atap. Aria ananish disaipel shanaki shanaman shape. ");
INSERT INTO apec_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Aria Jisas neyagwreh nakesh yopinyi baraen namudok, ");
INSERT INTO apec_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Eshudoki arpesh douk shadukemesh um esheshish mishish madae shupe hurukum Iruhin iri, aria shakri Iruhin um ko numnekesh iri, eshesh wosik ta shanadudareh. Umum maresh, eshesh ko shuwish agundok Iruhin nape Debeini um ananish arpesh shapeum heven aria shupe wosik atin gani iruhw heven.” ");
INSERT INTO apec_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","“Eshudok arpesh douk esheshiruh aparuh yoweruh ba shureh atinyi aria madae shunududareh um, yoweishi inahos eshesh shenekeshi iri aria shukri um maresh ta shenek yoweishi inahos um, eshesh wosik ta shanadudareh. Umum maresh, Iruhin ko nugamohesh um esheshiruh aparuh.” ");
INSERT INTO apec_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","“Eshudok samokwiyaishi arpesh madae shubo mishish ba shutuk esheshish nyeiguhw shuto iruhw aria shenek kupaishi yoweishi inahos iri eshesh wosik ta shanadudareh. Umum maresh, Iruhin ko nokesh abudok amnabish ihish eneshenesh aria shunogremesh.” ");
INSERT INTO apec_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","“Eshudoki arpesh douk shanawasham abom um shigipesh Iruhih ananin baraen ba shupe yopunyi poe, kabi da nyurub baesh um worigun nani abar um, eshesh wosik ta shanadudareh. Umum maresh, Iruhin ko gamo nugamohesh nenekesh shupe duguresh atin shupe.” ");
INSERT INTO apec_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","“Eshudok douk shenek gihaum kupaishi arpesh iri aria shutaurumesh um eneshenesh iri, eshesh wosik ta shanadudareh. Umum maresh, Iruhin shopunek ko nenek gihaum eshesh.” ");
INSERT INTO apec_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","“Eshudok douk esheshish apahw urkum shape yopiyopishi madae shur um shenek yoweishi inahos iri, eshesh wosik ta shanadudareh. Umum maresh, eshesh ta shutik Iruhin.” ");
INSERT INTO apec_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","“Eshudok douk shapeum shiyatak rupanitak iri, eshesh wosik ta shanadudareh. Umum maresh, Iruhin ta nuhwaresh ananish nugashish.” ");
INSERT INTO apec_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","“Eshudok douk shenek Iruhin nakriyenyi yopinyi mour aria namudok ba kupaishi shaesh, shahiyahesh aria shuweshikesh um, eshesh wosik ta shanadudareh. Eshesh douk ta ko shuwish agundok Iruhin nape Debeini um ananish arpesh shapeum heven.” ");
INSERT INTO apec_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Ipak douk shutrip pigipesh eik, ba shuhep shurukwep nubug, shuhiyahep aria shugiyagim ipak shudukumep nyau nyatograri baraen, aria wosik ipak ta panadudareh. ");
INSERT INTO apec_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Ipakish urkum apahw ko shupe wosik atin aria ipak ko gamo punadudareh. Umum maresh, ipak ko purao yopishi eneshenesh gani iruhw heven. Eshesh ta shenekesh um ipak kabi da seiwok shehiyah anam profet harigum ipak iri.” ");
INSERT INTO apec_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Ipak douk pape kabi da sol um abudok amnab. Aria sol kwehig miyair ba mare ta akehir aka nubutir, aria ta menekar mumam ba ta akehir aka nubutir? Arudoki sol arar mour wokar. Aria ta arpesh shuwashar-uguk, aria shishar shukwu esheshiruh yeriweruh. ");
INSERT INTO apec_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Ipak douk pape kabi da lait um abudok amnab. Anabur wabur da betem gani iruhw onohw yoduhw iri ta mare bunubeshuk. ");
INSERT INTO apec_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Arpesh ta mare shutik eneh nyih aria shushapumeh shukwu anap marup uwe, uwok. Eshesh ko shutik nyih hukus wehiwehigunum, um ta hukesh arpesh lait um ihishmorim arpesh numun urupat. ");
INSERT INTO apec_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Aria douk ipak ta pupe namudok atin kabi da nyih hanu hakus um. Pupe um punek yopishiyen aria ta arpesh shutrip aria ko shuhur ipakin Yaken ananin nyeigur nyuto gani iruhw douk nape heven iri.” ");
INSERT INTO apec_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Aria Jisas ta nakri namudok, “Mare pure urkwip namudok eik douk yanaki um iyatakuk Iruhin ananin lo seiwok nakrip Moses ba nenyem iri nyani enyudok baraen seiwok amam profet hakripeshuk-enyi, uwok. Eik douk yanamori inek enyudok baraen douk lo nyani amam profet amamin baraen nyakrium aria nyutograri adurin atin. ");
INSERT INTO apec_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Douk ipak gamo pumnek enyudok baraen eik adur atin yakripepum! Kweipon heven aria agudok nahobig guniyatak ahi nyumnah, enyudok ihin Iruhin ananin lo kweipon nyupe atin nyupe aria ta mare nyuniyatokuk uwe, Uwok. Enyudok mehimainyi baraen shenyem shus iri aria ihin baraen sheneken nyape lo iri ihinyumorim baraen kweipon nyupe atin nyupe. Enyudok lo kweipon nyupe atin nyupe namudok atin arigaha ihish kupaishi eneshenesh shiniyatokuk agudok nahobig. ");
INSERT INTO apec_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Namudok aria douk meinyiah arpen nyutik anabikum enyudok shokwinyium ihin Iruhin ananin lo aria nyubrigen nyenek skulum kupaishi arpesh um nyigiyagimeshum shenekesh namudok, enyudok arpen nyenekesh namudok iri enyen kweipon nyeigur shokwin um nyuwish abrudok wabur Iruhin nape Debeini um ananish arpesh shapeum gani iruhw heven. Aria namudok atin um meinyiah arpen douk nyigipesh ihinymorim lo, aria shopunek nyenek skulum kupaishi um enyudok lo, enyenyin nyeigur ko nyutogur debeinyi um ganik Iruhin nape Debeini um ananish arpesh shapeum iruhw heven. ");
INSERT INTO apec_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Aria douk adur atin eik yakripep namudok, ipak douk pupeum aria ta mare pugipesh Iruhin ananin lo ba baraenyum, aria ipakih yopihi aih douk ta mare henek uhwin um douk amam Farisi hani amudok anam henek skulumesh um lo iri henekehi um ba mare punekesh kabi da Iruhin nakri um, aria ipak ta mare puwish aburdok wabur Iruhin ananish arpesh shapeum heven iri uwe, uwok.” ");
INSERT INTO apec_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Aria Jisas ta nakri namudok, “Ipak douk pumnek seiwok shakrip ipakish popehesh yamehesh um. ‘Mare pubo arpesh shugok. Pubirok namudok um aria ko piyotu um debeigwi kwotog.’ ");
INSERT INTO apec_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Douk eik yakripep namudok. Ipak amiapen nyukri akas um ananin anokwinen, aria ko shuran shunak um kwot. Aria ipak amiapen pukrip anokwinen namudok, ‘Nyak yoweini!’ anan shopunek ko shuran shunak um kwot. Aria amiapen nyuho anokwinen, ba nyukana nyak yoweigunum, anan nape huruhuruk um yoweihi nyih hanugunum gani hel. ");
INSERT INTO apec_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Aria ipak ko pakana pugabe mishish um Iruhin iri. Ipak pure urkwip pani enesh kupaishi panitok um, aria ipak pubukuk eneshenesh pakana pugabe Iruhin eshi. ");
INSERT INTO apec_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","Ipak purik punak, ba pugabe baraen puni ipakishi aria ko putanam punak pugabe Iruhinin Mishin. Douk akas wata sapenyep obi nyutob mare punam Iruhin. ");
INSERT INTO apec_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Ipak douk enesh arpesh shakana shuraep shunak um kwotog um, aria pugabe baraen adukum kwot, da nyutob wata bape adai. Kadak pukuna piyotu abom um ta shuraep shunak um kwot aria shuko jasep aria jas ko noko ipakum polis. Aria polis ko haraep hunam shunuweshik-ati urupat aria punuweshik. ");
INSERT INTO apec_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Aria nagundok ipak ko pupe abom piyatak ipakibor utabor um putor yoweiti shunuweshik-ati urupat.” ");
INSERT INTO apec_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Aria Jisas ta nakri namudok, “Ipak seiwok pemnek shakrip arpesh enyudok baraen namudok, ‘Ipak arman armatok punoraum iri mare puni kupaishi arman armatok punek wehrur.’ ");
INSERT INTO apec_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Aria douk eik yakrip ipak namudok, douk anan arman nushakam onok armatok aria douk anudok arman iganigadae nenek wehrur numun um ananish urkum apahw um okwudok armatok. ");
INSERT INTO apec_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Aria douk nyakip nabep pape yopunyi rogur ehahi ponuk nyak um nyunek yoweishi inahos, namudok aria douk atin nyutuk apudok nabep ba nyuwashopuk. Namudok wosik um anabik um nyak kanak yowegun ba nyuwashagunuk aria douk madae nyenek yoweishi inahos uwe, uwok, aria ta mare shuwashokuk ihinyum nyak kanak nyubuh gani yoweihi nyih hanu um hel iri. ");
INSERT INTO apec_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Aria douk nyakin yopunyi rogur nyubirok nyak ba nyuguruki um nyenek yoweishi inahos, namudok aria douk atin nyutupok enyudok rogur ba nyuwashenyuk. Namudok wosik um anabik um nyak kanak yowegun ba nyuwashagunuk aria douk madae nyenek yoweishi inahos uwe, uwok, aria ta mare shuwashokuk ihinyum nyak kanak nyubuh gani yoweihi nyih hanu um hel iri.” ");
INSERT INTO apec_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Aria Jisas ta nakri namudok, “Seiwok eshesh shakri namudok, ‘Douk anan arman niyatokuk ananik irohukwik, aria anan ta nukok irohukwik anap shup um ta shubrig eshesh kanak eshesh shunoraum um.’ ");
INSERT INTO apec_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Aria douk eik yakana ikrip ipak namudok, aria douk anudok arman niyatok ananik irohukwik aria douk abudok nyutob ananik irohukwik madae kwonek wehrur kuni anan arman, namudok aria douk anudok arman nenek armatok um kwabrig enyudok shunoraum enyi lo. Umum maresh, ta okwudok armatok kurao kupaini arman, aria okwudok armatok kwonek wehrur um kwani anudok anan arman sheshuh um. Aria ta anan arman nurao onok armatok, seiwok okwokwin raminen niyatokuk iri, anan shopunek nabrig enyudok shunoraum enyi lo aria anan shopunek nenek wehrur um nani okwudok armatok sheshuhum.” ");
INSERT INTO apec_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Aria Jisas ta nakripesh namudok, “Ipak pumnek enen baraen seiwok shakrip ipakish popehesh yamehesh shemnek aria ipak shopunek douk pemnek, enyudok baraen nyape namudok, ‘Nyak mare ta nyigiyagig um agundok ta nyukri adur iruhw um. Aria agundok nyukri adur iruhw um nyakana nyenek enen mugu um, aria ta adur atin nyigipesh enyudok baraen aria nyenekesh shutogur adur atin um Debeini ananis nabes.’ ");
INSERT INTO apec_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Aria douk eik yakrip ipak, douk ipak mare ta piyagwreh pukri adur iruhw. Amu wouwokuk. Ipak mare ta piyagwreh pukri heven um punek enen baraen nyutogur dodogeshin. Umum maresh, Iruhin napeyenyi debeinyi wagitur da nyape heven. ");
INSERT INTO apec_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Aria ipak mare ta piyagwreh pukri agudok nahobig um punek enen baraen nyutogur dodogeshin. Umum maresh agudok nahobig douk kabi da wabur um Iruhin noduk ananiruh yeriweruh heyotu agudok nahobig. Aria shopunek ipak mare ta piyagwreh pukri wabur Jerusalem shopunek um punek enen baraen nyutogur dodogeshin. Umum maresh, abrudok wabur douk anudok atun Debeini King ananibur wabur. ");
INSERT INTO apec_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Aria ipak mare ta piyagwreh pukri ipakigos baragos um punek enen baraen nyutogur dodogeshin. Umum maresh, nyak madae nyukana wosik atin um ta nyenek anap nyakip baragitep nyakig barag um ta putogur shigorihwipi aka behrabipi, uwok. ");
INSERT INTO apec_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Aria ipak ta pukri pukuna ‘Adur’ aria ‘Uwok’ atin. Enyudok atin ipak ta pukriyen aria meyoh. Ihin kupainyi baraen da shiyagwrehen ba shagiyagig aria shaduronen um enyudok baraen iri enyudok baraen da nyatograri enyudok yoweinyi sagab Satan da neyagwrehen ba nyatogur.” ");
INSERT INTO apec_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Aria Jisas ta nakri namudok, “Ipak seiwok pemnek shakri namudok, ‘Douk anan arman nununu kupaini arman ananip nabep, aria anan ko shopunek nutanam nununu nanudok ananip nabep. Aria douk anan arman nudar kupaini arman ananihw nahw, aria anan ko shopunek nutanam nudar nanudok ananihw nahw.’ ");
INSERT INTO apec_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Aria douk eik yakrip ipak namudok, Ipak mare ta putanam pubeiri nigwanoh, baraen um douk kupaishi shenekesh yowiyokuk um ipak iri, uwok. Aria douk anan arman nubo enesh nyakish popaeshohos, aria nyak nyukonugu wobresh popaeshohos shopunek ba nesh. ");
INSERT INTO apec_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Aria douk anan arman nakana nenemen kwot aria nutrin nyakit siot, aria nyak shopunek ta nyukonugu nyakit saket shopunek um anan. ");
INSERT INTO apec_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Aria douk anan arman dodogeshin um nyak ta nyusahumon ananih jah ba nyigim yah nyunak 1 kilomita, namudok aria nyak nyusah jah nyigim yah nyinak 2 kilomita. ");
INSERT INTO apec_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Aria douk anan arman norig nyak um nyukon enesh muguhwos um anan, aria nyak wosik shukon eshudok muguhwos anan da narigen-meishi. Aria douk anan arman nakana nyukon enesh muguhwos meyoh ba kweipon aria anan ta nutanam nukenyeshi um nyak, aria nyak mare nyukon agab um ananin baraen uwe, uwok.” ");
INSERT INTO apec_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Jisas ta nakri namudok, “Ipak seiwok pemnek shakri namudok, ‘Ipak ko gamo pukri punawasham ipakishi arpesh atish, aria ipakish urkum apahw ko yoweshum ipakish horin horik.’ ");
INSERT INTO apec_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Aria douk eik yakripep namudok, ipak douk aria ta putanam pukesh ipakish urkum apahw aria pukri punawasham ipakish horin horik, aria ipak punek beten um eshesh aria Iruhin ta gamo nugabe eshesh douk shenekesh yowiyokuk um ipak iri. ");
INSERT INTO apec_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Namudok aria ipak ta pupe kabi da Iruhin ananish nugashish um ipakin Yaken douk nape heven iri. Anan douk nenek wah hutao um yoweishi arpesh aria shopunek um yopishi arpesh. Aria anan shopunek nenek eshah hormorim um yopishi arpesh aria shopunek um eshudok arpesh da shanahwaram um yoweishi arpesh shopunek. ");
INSERT INTO apec_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Douk ipak pukuna pukri eshudok arpesh douk shakri ipak atip iri, aria ipak ta purao maresh yopishi? Douk harao takis iri, amam shopunek douk henek apunih aih. ");
INSERT INTO apec_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Aria douk ipak punek ruwahep wabigep um ipakish wanaruh atish, aria ipak ta punek uhwin um kupaishi arpesh esheshish urkum apahw mumam? Eshesh madae shudukemesh um Iruhin ananin baraen iri douk shenekesh namudok atin. ");
INSERT INTO apec_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Aria ipak douk ta putogur yopip abom um punek yopishi eneshenesh atin aria pupe kabi da ipakin Yaken nape heven iri douk nape yopuyopuni abom.” ");
INSERT INTO apec_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Aria Jisas nakri namudok, “Ipak ko gamo pudukemesh. Ipak mare pusuhw ipakihw yopuhwi ruwohw yopugunum um ihish arpesh ta shutik uwok. Douk punekesh namudok, aria ipak ta mare purao yopishi eneshenesh um ipakin Yaken douk nape heven iri, uwok. ");
INSERT INTO apec_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Aria douk ipak pakana pukesh eneshenesh um eshudok douk eneshenesh wokeshi, aria shopunek mare pukrip arpesh shurik shunak ba shuhwar shukripesh um nyak nyenekesh namudok kabi da enesh arpesh shabirak um gani numun lotuig urusag aria gani debeihi yeh. Eshudoki arpesh shakana shigiyagim ihish arman armatok, aria eshesh kupaikwi kupainari ta shukana eshudoki arpesh da yopishi aria shuhur esheshish nyeiguhw shuto gani iruhw. Eik yakripep adurin baraen, eshudoki arpesh douk sharao esheshishi yopishi eneshenesh aria jurug. ");
INSERT INTO apec_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Douk nyakana nyutaurum eshudok jah eneshenesh wokeshi, aria douk ruwohw nyasuohwi nyakin yoweinyi rogur mare nyudukemesh um marohw ruwohw douk nyakin yopunyi rogur nyasuohwi. ");
INSERT INTO apec_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Namudok aria enyudok mour um shutaurum jah um eneshenesh wokeshi douk nyubeshuken nyeneken iri ta nyupe nyunubeshuk-igunum. Aria ta nyakin Yaken nutik eneshenesh shape nyunubeshuk-igunum iri, aria anan ko nuken yopishi eneshenesh um nyak.” ");
INSERT INTO apec_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Aria Jisas nakri namudok, “Ipak pakana punek beten um, aria ipak mare punekesh kabi da amudok hagiyagigi henekeshum. Amam hakana hiyotu henek beten numun um lotuig urusag aka hiyotu agundok worobaishi arpesh sharahaen um debeihi yeh um kupaishi arpesh shutrum. Eik yakripep adurin baraen um ipak, amudok iganigadae harao amamibor utabor jurug. ");
INSERT INTO apec_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Aria douk pakana punek beten um, aria puwish ipakig urusag aria puwaru witog aria punek beten um ipakin Yaken douk nape nonobeshuk-igunum. Aria ipakin Yaken douk apa natik eshudoki, anan ta gamo nugabe ipak nukep ipakish yopishi eneshenesh. ");
INSERT INTO apec_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Aria abudok nyutob ipak pakana punek beten obi nyutob, aria mare punek beten piyagwreh sabain atin baraen meyoh, namudok eshudok madae shudukumesh um Iruhin iri shabirak um. Esheship urkwip por namudok eshesh ta shiyagwreh sabainyi baraen aria Iruhin ta numnek eshesh. ");
INSERT INTO apec_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Ipak mare pugipesh eshesh da shenekeshum, uwok. Douk ipak madae pupuk ipakig nukwatog obi nyutob um porig ipakin Yaken um enesh eneshenesh, aria anan iganigadae nadukemesh um ihish eneshenesh ipak douk wokeshi. ");
INSERT INTO apec_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","“Ipak pakana punek betenum, aria punek beten namudok. ‘Apakin Yain, nyape iruhw heven iri, apak makri ihishmorim arpesh shutuk nyakin yopunyi nyeigur nyape holi iri nyuto gani iruhw. ");
INSERT INTO apec_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Apak makri nyak nyupe debeini um sabaishi arpesh. Apak mape atap iri makri mugipesh nyakin baraen atin, kabi da eshesh shape iruhw heven iri shenekesh um. ");
INSERT INTO apec_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Douk nyukop doukigun worigun ahudok atuh nyumnah. ");
INSERT INTO apec_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Aria nyukweshih-umap ihish yoweishi inahos apak monekesh iri, kabi da apak shopunek menekesh um kupaishi shenekeshomap iri. ");
INSERT INTO apec_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Aria nyak mare ta nyukrip yoweinyi sagab Satan um nukwiraeh apak ba munek yoweishi inahos uwe, uwok. Aria nyak nyutaurum apak nyukrip Satan um ta mare nunamori apak aria nyukweshihuk yoweishi inahos um apak. Nyak atin nyape nyohwar arpesh um shuwish agundok nyak nyape Debeinarium nyakish arpesh um, aria nyak dodogowinyi abom aria sabaishi arpesh shatuk nyakin yopunyi nyeigur nyape holi iri nyuto gani iruhw ihih nyumneh. Adur atin.’ ");
INSERT INTO apec_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Pumnek. Douk ipak puwaromesh kupaishi shenekeshi yoweishi inahos, aria ipakin Yaken nape heven anan ta nukweshih ipakish yoweishi inahos shopunek. ");
INSERT INTO apec_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Aria douk ipak mare pukweshih yoweishi inahos um eshesh kupaishi arman armatok, aria ipakin Yaken shopunek ta mare nukweshih ipakish yoweishi inahos.” ");
INSERT INTO apec_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Jisas nakri namudok, “Douk pakana pushakur um worigun eneh nyumneh, aria ipakigos yomogos mare yowegos kabi da arpesh shagiyagigi shenekesh um. Esesh shenek esheshigos yomogos yowegos, aria ihish arpesh shutrish aria shudukemesh namudok eshesh da shushakur um worigun. Eik yakripep um adurin baraen ipak, eshesh iganigadae sharao yopishi eneshenesh aria jurug. ");
INSERT INTO apec_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Aria ipak douk pakana pushakur um worigun, aria pukrup yomogos ba puwem yopuri wel ipakigos baragos. ");
INSERT INTO apec_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Namudok aria ihish arpesh ko mare shudukemesh namudok ipak da pushakur um worigun. Aria ipakin Yaken da nape nunubeshuk-igunum iri, anan atun ko nudukemesh. Aria ipakin Yaken apa natik eneshenesh shunubeshuk iri, anan ko nukep yopishi eneshenesh um ipak.” ");
INSERT INTO apec_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Jisas nakri namudok, “Ipak mare putorum yopiyopishi eneshenesh ipakish aria pushubuk atugun agundok um agudok nahobig, uwok. Puneshubuk agundok um yomiyamish aria ros ko shununish, aria eshudok shakwaruhi ko shubrig narub urusag ba shukwumesh aruh. ");
INSERT INTO apec_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Namudok aria ipak ko putorum yopiyopishi eneshenesh aria pushubuk atugun gani iruhw heven. Umum maresh, gani iruhw heven yomiyamish aria ros ko mare shununish aria eshudok shakwuaruhi ko mare shubrig narub urusag ba shukwumesh aruh uwe, uwok. ");
INSERT INTO apec_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Aria abrudok wabur eshudok yopiyopishi eneshenesh ipakish shakus aburi, aria douk abrudok wabur atubur ko ipakish urkum apahw ko shunuwasham-agun abom um ta shupe.” ");
INSERT INTO apec_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Aria Jisas ta nakri namudok, “Nabes sape kabi da lam um ipakiruh yegeshiweruh. Aria douk ipakis nabes yopusium, ta lait shunukit ihigunum ipakiruh yegeshiweruh. ");
INSERT INTO apec_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Aria douk ipakis nabes yowes, aria ihigun um ipakiruh yegeshiweruh ta hupeim arukwut. Namudok aria douk atudok lait tupe numuninyum douk kabi da arukwut um, aria ta atudok arukwut ko tutogur debeiti abom.” ");
INSERT INTO apec_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Jisas nakri namudok, “Madae anan arman douk ta wosik um nupe shukam um biom takwiyem atugun uwe, uwok. Aria ta ananish urkum apahw shukri anan aria yowesh um naniganan. Aria ta numnek baraen um anan aria nukon agab um naniganan. Aria ipak douk shopunek ta mare pupe shukam um Iruhin aria utabor shopunek uwe, uwok.” ");
INSERT INTO apec_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Aria Jisas nakri namudok, “Namudok aria eik yakripep, ipak mare urkwip aparuh yowesh um ipak kanak aria pakri, ‘Douk ta apak muwok maresh muguhwos? Aria ta muwok marabar abar?’ Aria mare urkwip aparuh yowesh um ipakiruh yegeshiweruh aria pakana, ‘Douk ta muwah mareh rupeh?’ Enyudokmori ipak mare ta piyagwrehen atin uwe, uwok. Ipak douk ta mare pupe dodogowip um rupeh hani worigun atish aria pupe roubi nyutob agundok atap uwe, uwok. Ipak purik gamo pupe yopip abom ba iyoh aria eshudok ko pugiguk pure urukumomesh. ");
INSERT INTO apec_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Ipak douk putik armiguhw hwohwebur iruhw iri. Ogwoguh madae hwu worigun uwe, uwok. Aria ogwoguh madae hutorumogun ba hugunubuk shawok worigun ati urupat uwe, uwok. Ogwoguh douk ipakin Yaken nape heven iri nukoguh worigun. Aria ipak douk peshagrakuk armiguhw, aka uwok? ");
INSERT INTO apec_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Aria douk enen um ipak enyenyish urkum apahw shor shunak yoweshum ta nyupe anagun shopunek banogun nyutobigun nyupe agundok atap nyishagrakuk abudok nyutob douk ko nyugok obi? Namudok ta uwok. ");
INSERT INTO apec_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Aria umum maresh ba ipakish urkum apahw yowesh um rupeh? Ipak ko putik kabi da eshudok wanorish aruruhish shatogur um. Eshesh douk shatogur mumam? Eshesh madae shunek enen debeinyi mour uwe, uwok. Eshesh madae shenek rupeh uwe, uwok. ");
INSERT INTO apec_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Aria douk eik yakrip ipak, seiwok King Solomon nere sabaihwi yopuyopuhwi ananihw suruhw ba uwok, eshudok aruruhish shenek uhwin um Solomon ananihw suruhw. ");
INSERT INTO apec_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Aria douk aruhudok utoruh hape ihigunmorim, aria nuhut atin arpesh ta shutuporuh aria shuwashoruh um nyih hunuruh. Aria aruhudok utoruh douk Iruhin naginohwaruh. Namudok aria ipak armam armago papeum shokwinyi bilip meyoh, ipak douk gamo pudukemesh namudok, Iruhin ta gamo nuginohw ipak shopunek. ");
INSERT INTO apec_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Namudok aria ipak mare ipakish urkum apahw shor shunak yowesh aria pukana, ‘Ta apak muwok maresh? Ta apak muwok marabar abar? Ta apak mure mareh rupeh? Uwok.’ ");
INSERT INTO apec_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Eshesh eshudok madae shudukemesh um Iruhin iri eshesh ko esheshish urkum apahw ta yowesh um shurim eshudok ihish eneshenesh. Douk ipakin Yaken nape iruhw heven iri anan iganigadae nadukemesh jurug um eshudok ihish eneshenesh ipak wokeshi. ");
INSERT INTO apec_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Aria douk nyarik iri mugu ipak ta ko gamo punekenyi douk nyakri namudok. Ipak pupe dodogowip atip um puwish agundok Iruhin nape Debeini um ananish arpesh um aria punek yopihi atih aih. Ipak purik punek enyudok aria ihishmorim eneshenesh eshudok ta anan nukepesh shopunek um ipak. ");
INSERT INTO apec_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Namudok aria ipak mare urkwip aparuh yowesh um maresh ta shutogur nuhut, uwok. Umum maresh, eneshenesh ko shutogur nuhut iri nyunekesh wokish shutogur nuhut. Aria maremaresh eneshenesh shakana shutogur doukih nyumnah iri nyunekesh wokish shutogur douk.” ");
INSERT INTO apec_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Aria Jisas nakri namudok, “Ipak mare pusuhw wis ba puduk heh aria baraen um kupaishi ba pakana eshesh da yoweishi, uwok. Ipak penekesh namudok aria Iruhin ko ta nenekesh namudok atin um ipak shopunek. ");
INSERT INTO apec_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Iruhin ko nusuhw wis aria nuduk hah aria baraen um ipak kabi da ipak penekeshum kupaishi arpesh um. Aria ahudoki atatahih aih, baraen atish ipak da penekesh um kupaishi arpesh iri, ahudok atatahih aih, baraen atish ko Iruhin nutanam nenekesh um ipak namudok atin shopunek. ");
INSERT INTO apec_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","“Umum maresh, ba ipak patik mehimainyi nyubuhasin nyor ipakin anokwinen ananip nabep iri, aria ipak da madae urkwip purum debeipi rowogip aidap da por ipakis nabes iri? ");
INSERT INTO apec_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Aria douk aidap por ipakis nabes, aria umum maresh ba ipak ta pukrip ipakin anokwinen, ‘Anokwin, eik yakana itukuk nyubuhas da shor nyakip nabep iri?’ ");
INSERT INTO apec_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Ipak douk penek rohw iri aria pagiyagigi. Riguk ipak ta putukuk debeipi rowogip aidap por ipak kanak ipakis nabes iri ba jurug. Aria kwehig ba gamo putik aria ko putukuk shokushi nyubuhas da shor ipakin anokwinen ananip nabep iri. ");
INSERT INTO apec_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Ipak mare puhur yopiyopishi eneshenesh shugraeheshum Iruhin iri, aria puko nubagwesh. Umum maresh, nubag ta gutanom aria gunatuk ipak. Aria ipak mare puwashok yopiyopibi ipakib weiyoub bunam burguhw. Um maresh, ogwogwuhw ta hwusish weiyoub hurukutunab hwukwu ohwip.” ");
INSERT INTO apec_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Aria Jisas nakri namudok, “Ipak penek beten aria porig Iruhin um ta nukep eneshenesh, aria anan ta nekepesh. Ipak penek mour dodog um purim eneshenesh aria ta putrish. Ipak pubo wit, aria Iruhin ta nujik wit um ipak. ");
INSERT INTO apec_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Ihish arpesh shenek beten um Iruhin iri, eshesh ta shurao eneshenesh. Arpesh shenek mour dodog um shurim eneshenesh iri, eshesh ta shutrish. Arpesh ko shubo wit iri, Iruhin ta nujikomesh wit. ");
INSERT INTO apec_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","“Aria ko enen batowin um enen arpen um ipak ko nyorig enyenyin yaken um nuken bret, aria ko yakenomen nuken utomum batowin aka? Namudok ta uwok. ");
INSERT INTO apec_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Aria ko batowin nyorig yaken um nuken anar eyur, aria ko yakenomen nuken anar yoweiri yur aka? Namudok shopunek ta uwok. ");
INSERT INTO apec_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Ipak yakenyim penek sabaishi yoweishi eneshenesh iri agudok nahobig, aria ipak madae pigiyagim batowish uwe, uwok. Aria ipak padukemesh um pukesh yopishi eneshenesh um ipakish nugashish. Namudok aria ipak ta gamo pudukemesh namudok, ipakin Yaken da nape heven iri anan ta nunadudareh um nukep yopiyopishi eneshenesh um arpesh shenek beten um anan iri. ");
INSERT INTO apec_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Namudok aria ihih yopihi aih ipak pakana ta kupaishi arpesh shenekeh um ipak, aria ehudoki atih yopihi aih ipak ta punekeh um kupaishi arpesh shopunek. Enyudok douk baugenyum baraen um lo, aria enyudok douk shopunek baugenyum baraen um seiwok profet hakriyenyi.” ");
INSERT INTO apec_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Jisas nakri namudok, “Ipak punak puwish atudok shokwuti wit. Aria wit douk tunam yoweihi yah ta punak puwishukuk ahi ahudok debeihi yah, douk sabaishi arpesh shatik shokubur um shakana shigimoh. ");
INSERT INTO apec_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Aria wit tunam abrudok yopuburi wabur iri um arpesh shunak shupe wosik yopinyi poe iri, atudok wit shokukutet abom iri, aria yah hunam abrudok wabur iri shopunek sabaishi arpesh madae shigimoh uwe, uwok. Aria douk atin atin arman armatok wosik shatik shadukemesh aria shagim ahudok yah.” ");
INSERT INTO apec_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Aria Jisas ta nakri namudok “Ipak ta gamo pudukemesh um amudok hagiyagigi profet. Amam ko hiyagwreh yopinyi baraen um honuk ipak. Amam hakana ta hiyagwreh higiyagig um ipak aria honunip. Amam kabi da wanarig nubag um gwure sipsipihw yegenyihw, aria ta gwunak huruhuruk um eshesh sipsipahos aria ta gwusuwesh. ");
INSERT INTO apec_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Ipak ta ko putik kabi da hiyagwreh henek eneshenesh um aria ta pudukemesh, amudok da hagiyagigi profet, aka uwok? Aria ko pudukemesh. Arpesh ta shunam segego watogur-aruhi madururuh aria ta shudi wainip shuruwep, aka? Aria arpesh ta shakana shudi shuruwep peir rowog da nyunuhwarom fik iri, aka ta shunam nyugwugwus-iruhi yoweiruhi utoruh? Namudok uwok. ");
INSERT INTO apec_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Namudok atin ihigosum yopugosi rowos sobuki yopipi shuruwep. Aria yoweigosi rowos sobuki yoweipi shuruwep. ");
INSERT INTO apec_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Yopugosi rowos ko mare subuki yoweipi shuruwep. Aria yoweigosi rowos ko mare subuki yopipi shuruwep. ");
INSERT INTO apec_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Ihigos rowos da madae subuki yopipi shuruwep iri, eshesh ta shubro-ogos aria shuwashogos sunam nyih ko hunugos. ");
INSERT INTO apec_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Namudok aria ipak ta gamo putik amam da henek eneshenesh um aria hiyagwreh um aria ta pudukemesh um amudok henek rohw ba hagiyagigi profet.” ");
INSERT INTO apec_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Ipak mare pur urkum apahw namudok. Ihish arpesh da shuhware, ‘Debeini, Debeini,’ aria eshesh ta shunak shuwish agundok Iruhin nape Debeini um ananish arpesh shapeum heven, uwok. Arpesh shagipesh eikin Yain ananin baraen iri aria ananish urkum apahw shakri um gani heven, eshesh atish ko shuwish agundok Iruhin nape Debeini um ananish arpesh um. ");
INSERT INTO apec_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Nohudok nyumnah Iruhin ananih kwotogwih nyumnah, sabaishi arpesh ko shukrip eik namudok, ‘Debeini, Debeini,’ apak seiwok masuhw nyakin mour profet um nyakin nyeigur. Umum nyakin nyeigur apak mohiah yoweishi sagabehos. Umum nyakin nyeigur apak menek Iruhin atun neneken iri mour. ");
INSERT INTO apec_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Aria um abudok nyutob eik ko ikripesh namudok, ‘Eik madae idukem ipak uwe, uwok. Ipak eshudok arpesh da apa pape penek yoweishi inahos atish iri, ipak karuwokuk um eik!’” ");
INSERT INTO apec_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Jisas nakri namudok, “Ipak amiapen pumnek enyudok eikin baraen iri aria pigipeshen, enyen kabi da enen arpen yopugi barag gorenyi, nyarok enyenyit urupat totem utaborigunum. ");
INSERT INTO apec_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Aria eshah harari, dodogowinyi uhwin nyahur, aria uhwin eshah shabo atudok urupat. Aria atudok urupat madae tutu uwe, uwok. Umum maresh? Arpen nyarok urupat utabor bor amnab iri buwapom urupat aria dodogeshit atut. ");
INSERT INTO apec_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Aria arpen da nyemnek enyudok eikin baraen aria madae nyigipeshen, enyen kabi da enen nyogugaki arpen nyarok enyenyit urupat totem arukot atut takusum. ");
INSERT INTO apec_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Aria debeishi uhwin eshah shatogur aria debeibusi worubus sawori, aria shadigur atudok urupat. Aria atudok urupat tanadigur tabuh takus atap aria tutukarot yowiyokuk.” ");
INSERT INTO apec_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Aria Jisas neyatok ihin baraen um eshudok eneshenesh, aria ihish armam armago esheshish urkwip aparuh shakitak yowiyokuk um ananin baraen. ");
INSERT INTO apec_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Umum maresh? Anan madae niyagwreh nukesh skul kabi da amudok henek skulumesh um Iruhin ananin lo iri uwe, uwok. Aria anan da neyagwreh kabi da anan debeini morim. ");
INSERT INTO apec_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Aria Jisas nakitak nabuhi mihig, aria sabaishi arpesh shagipeshan shanak. ");
INSERT INTO apec_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Aria anan ehudok arugeh lepra hapenyan iri nanaki um Jisas aria nabuh noduk ohrubus huruk um Jisas aria nakri namudok, “Debeini, nyak nyukri wosik um, aria nyak ko nyugapeshe aria ta eik yopuwe.” ");
INSERT INTO apec_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Aria Jisas nuwem ananis wis anudok arman aria nakripan namudok, “Eik yakri wosik um nyak nyutogur yopunyi arpen.” Aria atub nyutob ehudok arugeh lepra haniyatokuk um anan, aria natogur yopuni arman. ");
INSERT INTO apec_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Aria Jisas nakripan namudok, “Nyak ko gamo nyudukemesh. Aria mare nyukrip enen arpen um eshudok eneshenesh da shatogur um nyak iri, uwok. Nyak kare ba nyiyabig nyakihw yegenyihw um anan pris aria nyenek ofa kabi da seiwok Moses nakri um. Nyunekesh namudok um aria arpesh ko shudukemesh namudok nyakih arugeh iganigadae hatuh.” ");
INSERT INTO apec_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Jisas nanak nawish wabur Kaperneam aria anan debeini soldia um amam 100-poreim soldia iri um Rom esheshin ami anan nanaki aria narik Jisas debeg namudok, ");
INSERT INTO apec_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Debeini, anudok neneme mour um eik iri, arugeh hapeyan aria neshuh nakus urupat. Aria anan nemnek ananihw yegenyihw erigerishihw atuhw.” ");
INSERT INTO apec_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Aria Jisas nakri namudok, “Wosik eik ko inak ba igabeyan aria yopun.” ");
INSERT INTO apec_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Aria anudok debeini soldia nakrip Jisas namudok, “Debeini, eik madae yopuwe iri uwe um nyak nyunaku nyuwish eikit urupat uwe, uwok. Nyak nyukri baraen atin aria anudok arugehin neneme mour iri ko ta yopun. ");
INSERT INTO apec_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Umum maresh? Eik shopunek yenek mour um ami aria anam debeimi heyotu harig um eik. Aria eik shopunek eik kanak debeini um anam kupaimi soldia. Aria eik ikrip anan, ‘Nyak kare,’ aria anan ta nunak. Aria eik ikrip kupainari, ‘Nyak yowi,’ aria anan ta nanaki. Aria eik ikrip anudok neneme mour eik iri, ‘Nyak nyenek enyudok mour,’ aria anan ta neneken.” ");
INSERT INTO apec_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Jisas nemnek enyudok baraen aria nakitak yowiyokuk. Aria nakrip eshudok arpesh shagipeshan iri namudok, “Eik yakripep adurin baraen, eik nubo madae itik enen arpen orokohun um eshesh Israel um nyenek bilip dodog kabi da anudok arman um uwe, uwok. ");
INSERT INTO apec_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Aria eik yakrip ipak, sabaishi arpesh shape nahobigos gani aun nakih-morim aria gani aun nabuhum ta shanaki, aria eshesh ta shunaki shupe shuwok worigun shuni Abraham nini Aisak aria Jekop abrudok wabur Iruhin nape Debeini um ananish arpesh shapeum heven. ");
INSERT INTO apec_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Aria ipak Juda pakana puwish pupe agundok Iruhin ananish arpesh shupe um. Aria enep um ipak Iruhin ko nipuhur nuwashep putogur aduk um arukwutibur wabur. Aria nabrudok wabur eshesh ko shureh yowiyokuk aria shurpak naruh shuwegoruh.” ");
INSERT INTO apec_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Aria Jisas nakrip anudok debeini soldia namudok, “Nyak douk kare. Aria ihish eneshenesh ta shutogurum nyak kabi da nyenek bilip um.” Aria douk abudok atub nyutob anudok arman nenek mour um debeini soldia iri arugeh hatuh aria natogur yopunyi arpen. ");
INSERT INTO apec_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Aria Jisas nanak nawish Pita ananit urupat, aria natik Pita ananik nakwrikwik kweshuhw kwotem aras, okwok da arugeh hapeyok aria okwokwihw yegenyihw juwehosihw atuhw. ");
INSERT INTO apec_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Aria Jisas nasuhw okwokwis wis aria okwokwih arugeh hatuh. Aria okwok kwakitak kwape kwonekuman Jisas worigun. ");
INSERT INTO apec_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Douk wabigep hurukatin um wab aria shape sharauri sabaishi yoweishi sagabehos shapenyeshi arpesh shanamari Jisas. Sharaeshi aria nakripesh atin baraen meyoh aria eshudok yoweishi sagabehos shatogur sharuwok. Aria anan nagabe ihishmorim arugeh da hapeyeshi. ");
INSERT INTO apec_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Anan douk nenek enyudok um enen baraen seiwok profet Aisaia neyagwrehenyuk aria nyatogur adurin atin. Baraen enyudok, Iruhin nakri namudok, “Anan meyoh nahiyahuk yomo yomogih apakih arugeh nagabeyap um yopup.” ");
INSERT INTO apec_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Jisas natik sabaishi arpesh shanaki sheyatu shersharihan aria nakrip ananim disaipel um hunam gani wobrag Galilieg waiyag. ");
INSERT INTO apec_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Aria anan nenek skulumesh um lo iri nanaki nakrip Jisas namudok, “Tisa, ihigun nyak nyunak um, eik shopunek ta inamen unak atin.” ");
INSERT INTO apec_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Aria Jisas nakri namudok, “Wanarig nubag gweshuh nuwagos-igunum. Aria armiguhw huhwebur iruhw aria shopuk hweshuh was. Aria Eik Anudok Arman douk yatogur adurinyi arpen iri, eik douk urupat uwok um inak ishuh ipeum, uwok.” ");
INSERT INTO apec_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Aria kupaini arman apa nagipesh Jisas iri ta nakripan namudok, “Debeini, eikin yain watak nape. Nyak yotum eik ba inak ba itrun anan nugok ba iroman ba iyoh aria inaki inamen unak.” ");
INSERT INTO apec_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Aria Jisas nakripan namudok, “Nyak bukeshuk. Eshesh shagok iri, eshesh ko shurom eshesh kanak. Nyak yowi douk ba nyigipesh eik.” ");
INSERT INTO apec_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Aria Jisas naprok nato anat bot, aria ananim disaipel shopunek hato bot aria heiran hanak. ");
INSERT INTO apec_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Hanak orokohun um waiyag, aria atub nyutob enesh uhwin eshah shakitak shohur waiyag aria debeibi morub jirigarab bawish bot aria bot hurukatinyum tubuhuk waiyag. Aria Jisas anan douk neshuh notem bot. ");
INSERT INTO apec_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Ananim disaipel hanak henyubarun aria hakripan hakana, “Debeini, kwakitak ba nyutaurumap. Apak hurukatinyum ko mugok.” ");
INSERT INTO apec_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Aria Jisas nakripam namudok, “Ipak panogugur um maresh? Ipak douk madae punek bilip um eik uwe, uwok.” Nakripam namudok aria ta nakitak naho eshudok debeishi uhwin eshah shani morub. Namudok aria uhwin eshah shagok shabuh. Aria waiyag ta gabuh gor shemshem. ");
INSERT INTO apec_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Aria amam disaipel hakitak yowiyokuk ba minih ham meyoh. “Anudok meini arman aria uhwin eshah ba waiyagib morub shopunek shomnek ananin baraen!” ");
INSERT INTO apec_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Aria Jisas nanak natogur gani wobur ehahum Galilieg waiyag gani Gadara esheshig nahobig aria biom armam hape wonugwegwiruh um iri hatogur hanaki hatik Jisas. Amudok biom, yoweishi sagabehos shawisham ba dodogeshim atum. Arpesh shanogugur aria madae shugim nohudok yah uwe, uwok. ");
INSERT INTO apec_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Amam hatik Jisas aria huhwar debeg, “Nyak Iruhin ananin Nuganin nyak nyakana nyenekap mumam apak? Abudok nyutob nyak nyanaki um nyop nyihiyahap obi nyutob da madae butogur uwe, uwok.” ");
INSERT INTO apec_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Huruk um nagundok anogwuh burguhw hwetu apa hwashohagun. ");
INSERT INTO apec_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Aria eshudok yoweishi sagabehos shunokrep Jisas, “Nyak nyakana nyihiyah apak mutogur munak um, aria nyak shopukap munak muwish gwagwuhwudok burguhw.” ");
INSERT INTO apec_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Aria Jisas nakripesh namudok, “Ipak togur kare.” Aria eshudok yoweishi sagabehos shakutukuk amudok biom armam, aria shatogur shawish burguhw. Aria agwuhwudok ihigwuhw um burguhw hwahur debeg abom hwanak hwaporok hwabuh enen natogur gani yowegunum. Aria hwabuh Galilieg waiyag hwabarahuk aria hwagok. ");
INSERT INTO apec_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Amudok hape hako burguhw iri hatik namudok aria haruwok. Amam hanak hatogur wabur aria hakrip armam armago um eneshenesh da shatogur iri. Hakripesh um maresh da shatogur um amudok biom yoweishi sagabehos shapeyomi shopunek. ");
INSERT INTO apec_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Aria ihish arpesh shape abrudok wabur iri shanamori Jisas. Eshesh shatrun aria shakripan um nukutukuk esheshig nahobig ba nanak kupaigunum. ");
INSERT INTO apec_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Aria Jisas ta naprok anat bot, aria nutanam nabinawish gani wobrag Galilieg waiyag aria nanak natogur abrudok wabur da napeyabur iri. ");
INSERT INTO apec_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Aria anam armam husahi anan roguhw aiyas shagokan iri notemi anas aras. Aria Jisas natik amudok da adur atin henek bilip aria nakrip anudok arugeh hapeyoni namudok, “Nuganin, nyakish urkum apahw ko shupe wosik atin. Nyakish yoweishi inahos eik douk yokweshihesh yeyatesh iyoh.” ");
INSERT INTO apec_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Aria anam douk henek skulumesh um lo iri hemnek Jisas ananin baraen, aria hiyagwreh um amam kanak namudok, “Anudok arman douk nabubunim Iruhin.” ");
INSERT INTO apec_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Aria Jisas nadukemesh um amudok amamish urkum apahw shor ahi aih aria nakri namudok, “Umum maresh? Ba ipakish urkwip aparuh yowesh um enyudok eikin baraen? ");
INSERT INTO apec_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Maren baraen enyen wosik shokubur um eik ta ikriyen? Wosik um eik ta ikana, ‘Eik yokweshih nyakish yoweishi inahos,’ aka douk wosik shokubur um eik ta ikana, ‘Nyak kitak ba nyurahaen?’ ");
INSERT INTO apec_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Aria eik yakana ipak ta pudukemesh namudok, Eik Anudok Arman douk yatogur adurinyi arpen iri yasuhw dodogum agudok nahobig aria eik ta wosik um ikweshih yoweishi inahos.” Aria Jisas nashakom anudok roguhw aiyas shagokan iri aria nakripan namudok, “Nyak kitak aria nyuhur nyakish shuhish, aria kare nyunam nyakit urupat!” ");
INSERT INTO apec_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Aria anudok arman nakitak nanak wabur. ");
INSERT INTO apec_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Eshudok ihish arpesh shatik namudok aria shanogugur. Aria eshesh shohur Iruhin ananin nyeigur nyato gani iruhw. Umum maresh? Anan da nukesh enyudoki dodog um arpesh shenek enyudoki mour. ");
INSERT INTO apec_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Jisas nakutukuk nagundok aria nagim yah nanak aria natik anan narao takis iri arman, nyeigurinum Matyu, nape apa shurao takis ati urupat. Aria Jisas nakripan namudok, “Nyak yowi ba nyigipesh eik.” Aria Matyu nakitak nanak nagipesh Jisas. ");
INSERT INTO apec_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Hanak aria abudok nyutob Jisas nani ananim hantorum hape Matyu ananit urupat hape hawok worigun. Worobaimi harao takis iri hani eshudok shenek yoweishi inahos iri shanak shanamam shape shawok worigun. ");
INSERT INTO apec_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Aria anam Farisi hatik namudok aria harig ananim disaipel namudok, “Yaipo, ipakin Tisa douk nani amam harao takis iri hani eshudok shenek yoweishi inahos iri shape atugun aria shawok worigun. Anan nenekesh namudok um maresh?” ");
INSERT INTO apec_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Jisas nemnek enyudok baraen aria nakri namudok, “Arpesh arugeh wokeshi, eshesh madae shunam dokta uwe, uwok. Eshudok arugeh hapeyeshi atish eshesh ko shunak um shutik dokta. ");
INSERT INTO apec_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Ipak kare ba putik baraen nyape Iruhin ananik buk, ‘Eik yanaiwos um ipakin wehinyi ofa ipak apa penekenyi. Eik yakri abom um ipak penek giha aria pusuhw yopuhwi ruwohw um ihish arpesh.’” Aria Jisas ta nakri namudok, “Eik madae inamorim ihwar yopishi arpesh atish uwe, uwok. Eik yanamorim ihwar eshudok arpesh shenek yoweishi inahos iri um shutanam shukon aparuh Iruhin aria shutogur ananish arpesh.” ");
INSERT INTO apec_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Aria abudok nyutob Jon nenek Baptaisumesh iri ananim disaipel hanamori Jisas aria harigan namudok, “Umum maresh? Ba apak mani Farisi apak mushakur um worigun, aria nyakim disaipel madae hushakur uwe, uwok?” ");
INSERT INTO apec_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Aria Jisas nakripam wobuwobren baraen namudok, “Abudok nyutob anan arman narao onok armatok obi aria ta ananish wanaruh ta urkwip aparuh yoweshum anan douk wata nani eshesh shapeum aka uwok? Namudok ta uwok. Aria anob nyutob, enesh arpesh shunaki shurao anudok arman shunakuk aria anan madae ta nini ananish wanaruh shupe, aria eshesh ta shushakur um worigun. ");
INSERT INTO apec_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Madae enen arpen ko nyuhur anap namupi rupahip aria nyutapeyop um onohw umunihw um jugwaitori saket. Enyudok arpen nyibirak namudok akure, aria ko nyukrup saket aria apudok rupahip ko punokunish aria pubrig saket aria umunihw ko hwutogur dedebehw atuhw. ");
INSERT INTO apec_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Aria madae enen arpen nyushar namuni wain um jugwaipi memeip munuhwip uwok. Enyudok arpen nyenekesh namudok, aria apudok munuhwip ta purop aria wain ta nutaurakuk nubuh amnab aria apudok memeip munuhwip ta yowep shopunek. Namudok aria enyudok arpen ko nyushar namuni wain nubuh namupi memeip munuhwip aria ta biyebiyesh shupe wosik atin.” ");
INSERT INTO apec_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Jisas wata apa niyagwreh nani Jon ananim disaipel aria anan debeini douk debeini um atudok eshesh Juda shantorum ati urupat iri nanaki natu nabuh noduk ohrubus hurukatin um Jisas ananigas aiyas. Aria nakri, “Eikik nugawik douk atin kwagok. Eik yakri wosik um nyak nyunaku nyuwem nyakis wis iruhwik um aria ta kwukitak.” ");
INSERT INTO apec_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Aria Jisas nakitak nunaman hunak aria ananish disaipel shopunek sheiran shunak. ");
INSERT INTO apec_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Aria onok armatok okwok seiwok arugeh hapeyok 12-poreish kwarahos um owishibor banakok. Aria okwok kwanaki agabinum Jisas aria kwasusuhw anagas um ahudok rouhi rupah anan nenekah iri. ");
INSERT INTO apec_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Okwok da apa kwaneyagwreh kwakri, “Ikri isusuhw ananih rupah atuh um, aria eik ta yopuwe.” ");
INSERT INTO apec_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Aria Jisas natanam natruk aria nakripok nakri, “Nugawik, nyakihw apahw mare yowehw, uwok. Nyak nyenek bilip um eik, aria nyak ta yopin.” Aria abudok atub nyutob okwok owishibor tukaruboruk aria okwok ta yopuk. ");
INSERT INTO apec_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Aria Jisas nanak natogur anudok debeini ananit urupat aria natik eshesh armam armago shape apa shereh. Amam apa hohapur buwaen aria apa shereh shanoruwor shabo sawiyeguh. ");
INSERT INTO apec_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Aria Jisas nakripesh namudok, “Ipak ihipmorim kita togur aduk ba punak. Okwudok batowinyik madae kwugok uwe, uwok. Okwok da kweshuhw meyoh.” Aria eshesh shagokoruh anan shabo brakahas. ");
INSERT INTO apec_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Aria nakrip ihishmorim um shutogur shupe aduk aria Jisas nawish nasuhw okwokwis wis aria nakwuhur kwakitak kwape yopuk. ");
INSERT INTO apec_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Namudok aria baraen nyanak ihirub warub bape abudok amnab iri um agundok Jisas da nohur okwudok kwagok iri kwakitak kwape wosik atin um. ");
INSERT INTO apec_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Jisas nakutukuk nagundok aria nagim yah nanak. Aria biom nabes seshuhomi hagipeshan aria hohwar namudok, “Nyak Devit Ananin Barhonin, nyak ko nyenek gihaum ohwak biohw.” ");
INSERT INTO apec_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Anan nanak nawish urupat aria amudok biom nabes seshuhomi hanamori anan. Aria Jisas narigam namudok, “Ipak biom penek bilip namudok eik ko wosik inek enyudok mugu nyutogur adur atin, aka uwok?” Aria amam biom hakripan namudok, “Adur atin Debeini. Ohwak biohw wonek bilip um nyakin dodogum nyugabeyohw.” ");
INSERT INTO apec_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Namudok aria anan nuwem ananis wis um amamis nabes aria nakri namudok, “Ipak biom penek bilip um eik. Namudok aria yakri ipak ta putrugun.” ");
INSERT INTO apec_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Aria amamis nabes ta yopus sanapok. Aria Jisas nakripam dodogeshinyi baraen um amam biom namudok, “Ipak biom mare ta pukrip enen arpen nyudukemesh um eik yagabe ipakis nabes yopus um uwe, uwok.” ");
INSERT INTO apec_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Aria amam hanak hakrip ihishmorim armam armago um ihirub warub bape abudok amnab iri um ihin yopinyi mour Jisas apa nenekenyi. ");
INSERT INTO apec_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Amudok biom hakutukuk Jisas apa hanaku aria enesh arpesh sharauri anan arman um Jisas. Anan douk enen yoweinyi sagab nyapeyan aria madae niyagwreh uwe, uwok. ");
INSERT INTO apec_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Aria Jisas nahiyahuk enyudok yoweinyi sagab aria anudok madae niyagwreh iri ta niyagwreh. Aria ihish armam armago shanosorim esheshish urkwip aparuh aria shakri, “Seiwok madae enen namudokinyi mugu nyutogur agudok nahobig Israel uwe, uwok.” ");
INSERT INTO apec_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Aria amam Farisi hakri namudok, “Anan douk nahiyah yoweishi sagabehos um anan da narao dodog um enyudok debeinyi nyarik iri yoweinyi sagab um ihishmorim yoweishi sagabehos.” ");
INSERT INTO apec_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Aria Jisas narahaen nanak ihirub warub debeirubi aria shokurubi. Aria anan nenek skulum ihish armam armago numun urusag eshesh Juda shantorum ba sheneyagwreh baraen-ogwi. Anan nakripesh um yopinyi baraen um arpesh shuwish um agundok Iruhin nape Debeini um ananish arpesh um aria anan nagabe ihihmorim arugeh da hape esheshiruh yegeshiweruh iri. ");
INSERT INTO apec_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Anan natik sabaishi armam armago aria anan nenek debeinyi gihaum eshesh. Umum maresh? Esheshish urkwip aparuh madae shupe wosik uwe, uwok. Eshesh shape kabi da sipsipahos douk arman madae nupe ba niyohesh iri uwe, uwok. ");
INSERT INTO apec_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Namudok aria nakrip ananim disaipel, “Sabaiguni worigun jurugigun nape nubarig aria arpesh ta shenek mourum shurimi agundok worigun iri madae sabaishi uwe, uwok. ");
INSERT INTO apec_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Aria ipak ko penek beten um agudok nubarigin Debeini Yaken aria porigan ta neshopoki eshudok ko shunaki shenek mour um shutorumori ananigun worigun shugunubuk atugun.” ");
INSERT INTO apec_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Aria Jisas nahwar ananim 12-poreim disaipel hanaki heyotu atugun aria nakom ananin dodog um huhiyah yoweishi sagabehos shape arpesh iri aria hugabe ihih arugeh. ");
INSERT INTO apec_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Amudok Jisas ananim 12 poreim disaipel douk nahwaram aposel iri amamish nyeiguhw eshudok.Narik iri anudok Saimon douk shahwaran Pita; anokwinen Andru; Jems nani anokwinen Jon, Sebedi ananim nagamim. ");
INSERT INTO apec_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Aria Pilip nani Bartolomyu aria Tomas aria Matyu, anan da nurao takis iri. Aria Jems Alfius ananin naganin, aria Tadius ");
INSERT INTO apec_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","aria Saimon anan da natogur Selotipawirop iri, aria Judas Iskariot, anan da kweipon nuwereh Jisas um ananim horim iri. ");
INSERT INTO apec_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Jisas neshopok amudok aposel hanak aria nakom enyudok baraen, “Mare punam eshudok madae shudukemesh um Iruhin iri esheshigos nahobigos aria Samaria esheshirub warub, uwok. ");
INSERT INTO apec_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Ipak ta punam nahobig Israel ba putik eshudok arpesh da shape kabi da shanatukuki sipsipahos um. ");
INSERT INTO apec_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Ipak punak aria pukripesh namudok, ‘Abudok nyutob um arpesh shuwish um agundok Iruhin nape Debeini um ananish arpesh shapeum heven douk hurukum butogur!’ ");
INSERT INTO apec_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Ipak punak pugabe arugeh hapeyeshi aria ta puhuri arpesh shagok iri aria piyatak ehudok arugeh lepra hapeyeshi shutogur yopish aria puhiyah yoweishi sagabehos da shape arpesh iri. Eshudok eneshenesh ipak paraesh iri, douk puraesh meyoh aria madae putorish pukwu utabor uwe, uwok. Namudok aria ipak ta pukesh meyoh um arpesh. Ipak ta mare puhwar arpesh um shukep utabor um eshudok eneshenesh uwe, uwok. ");
INSERT INTO apec_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","“Aria ipak ta mare puruk gol, utabor, siliwa aka kapaibor utabor banagos uwe, uwok. ");
INSERT INTO apec_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Ipak ta purahaen um mare pusuhw banagos uwe, uwok. Aria mare pusuhw biobiog siotog, su aka butip, uwok. Arman nenek mour iri, eshesh ko shubiroman um worigun nini enesh eneshenesh. ");
INSERT INTO apec_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Aria punak puwish anabur debeiburi wabur aka anabur shokuburi wabur, aria putrugun ba gamo pudukemesh, meimeishi da shape abrudok wabur iri da yopishi arpesh. Aria ipak puni enyudok arpen atin pupe arigaha nyumnah ipak pakana ta punak ahi. ");
INSERT INTO apec_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Ipak punak puwish anat urupat, aria ipak ta pukrip arpesh shape atudok urupat iri namudok, ‘Iruhin ko gamo nutaurum ipak.’ ");
INSERT INTO apec_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Aria eshudok shape atudok urupat iri eshesh shukep aparuh shukri wosik shunadudareh um ipak pupe puni eshesh, aria enyudok ipakin yopinyi baraen ko nyupe um eshesh. Aria eshesh ko mare shunadudareh um ipak uwe, aria ipak ko ta putanam purawi ipakin yopinyi baraen. ");
INSERT INTO apec_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Aria ta anan arman ko nunoiwos um ipak punam ananit urupat, aria nonoiwos um numnek ipakin baraen, aria nyutob ipak pukuna pukitakuk atudok urupat aka wabur obi nyutob aria ipak pugudukuk nypruk kwape ipakiruh yeriweruh iri. Punekesh namudok um eshesh shutrip aria shudukemesh shukri eshesh douk shenek yoweishi inahos iri. ");
INSERT INTO apec_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Eik yakripep adurin baraen, nahudok nyumnah Iruhin nakri um ko nenek kwotog um armam armago um, debeinyi amain ko ta nyutogur um eshesh shape abrudok wabur iri ko nyenek uhwin um amain seiwok nyatogur um eshesh shape narbudok warub Sodom bani Gomora iri.” ");
INSERT INTO apec_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Aria Jisas nakri namudok, “Ipak pumnek. Eik ko yeshopokep panak kabi da sipsipahos shunak orokohun um wanarig nubag. Aria ipak ta penekesh kabi da yuguhw um, aria ipak ta gamo pudukemesh um eneshenesh ipak pakana penekeshi. Aria ipak ta pugipesh ogwuhwudok maishubiguhw armiguhw hwenekahi aih aria ipak ta mare urkwip aparuh shur um penek enen yoweinyi mugu uwe, uwok. ");
INSERT INTO apec_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Ipak ko pudukemesh um arpesh. Eshesh ta shenemep kwotog, aria eshesh ta shupruk ipak gani numun eshesh Juda shantorum-ogwi urusag. ");
INSERT INTO apec_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Eshesh ko urkwip aparuh shur um shenek eikin nyeigur nyubuh atap, aria shurao ipak shunam gavman aria amam king-omi. Namudok aria ta ipak ko pukrip amudok debeimi um eikin yopinyi baraen, aria um eshudok madae shudukemesh um Iruhin iri shopunek. ");
INSERT INTO apec_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Aria nyutob eshesh shurao ipak shunam um kwotog, ipak mare punogugur aria urkwip aparuh shur yowiyokuk namudok, ‘Apak ta miyagwreh maren baraen? Uwok.’ Douk abudok nyutob bakana butogur aria Iruhin ko niyabigep um maren baraen ipak ta piyagwrehen iri. ");
INSERT INTO apec_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Umum maresh? Ipak kanak ta mare piyagwreh, uwok. Ipakin Yakenin Mishin ko nyukwu ipakig nukwatog aria nyiyagwreh. ");
INSERT INTO apec_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Arpesh ko shenek kwotog um esheshim anokwihem aria shukripesh um shubo amudok anokwihem hugok. Aria amam yakenyim ta henek apunih aih um amamish nugashish. Aria eshesh nugashish ta shutogur horin horik um esheshish amakek yaken aria shukrip kupaishi arpesh um shesh shugok. ");
INSERT INTO apec_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Aria ihish arpesh ko urkwip aparuh amu yowesh um ipak. Umum maresh? Eikin nyeigur nyape um ipak. Aria armam armago ko shiyotu dodog um bilip arigaha ko hahi hagiguki nyumnah hutogur obi nyutob, Iruhin ta ko nutanam nurao eshesh. ");
INSERT INTO apec_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Aria um eshesh armam armago um anabur wabur da shenekesh yowiyokuk um ipak um, aria ipak ko puruwok punam kupaiburi wabur. Eik yakripep adurin baraen, ipak ta ko mare piyatak mour um Israelirub ihirub warub aria Eik Anudok Arman yatogur adurinyi arpen iri ko ta itanamori. ");
INSERT INTO apec_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Eshudok batowish shenek skul iri madae shenek uhwin um esheshin tisa uwe, uwok. Aria eshudok shenek mour um kupaishi iri madae shupe iruhw shenek uhwin um esheshin debeini uwe. ");
INSERT INTO apec_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Eshudok batowish shenek skul iri ta shutogur kabi da esheshin tisa um, aria wosik. Aria ta eshudok shenek mour um kupaishi iri shutogur kabi da esheshin debeini um, aria namudok shopunek wosik. Eshesh nubo shakon nyeigur Belsebul um urupatin yaken,namudok aria apak madukemesh, eshesh ko shukri sabaishi yoweishi nyeiguhw um eshudok ananishi shape urupat iri.” ");
INSERT INTO apec_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Aria Jisas nakri namudok, “Ipak mare punogugur um arpesh da shakana shununu ipak iri. Ihish eneshenesh da shunushapom shakus iri ko shutogur yopugunum. Aria ihin baraen da nyunabeshuk iri ko arpesh shudukemen. ");
INSERT INTO apec_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Baraen eik yakrip ipaken wab iri, ipak ko piyagwrehen nyumnah. Aria baraen ipak ta shokubur pumneken iri, aria ipak pukih putem iruhw modukwigum urusag aria pukrip ihish armam armago. ");
INSERT INTO apec_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Aria ipak mare punogugur um arpesh da shabo abudok amnabihw yegenyihw hwagok iri, aria eshesh ta mare shubo enyudok mishin nyor numun ipak iri. Uwok. Ipak ta punogugur Iruhin atun. Anan atun ko nununu abudok amnabihw yegenyihw aria mishin shopunek gani ehudok yoweihi nyihiburi wabur hel. ");
INSERT INTO apec_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","“Ipak padukemesh, arpesh da shator bioguhw shokuguhwi armiguhw um 10-poreibor utabor. Aria ipakin Yaken da gamo apa neyoh ipak um agwuhwudok armiguhw. Aria da anan nunoiwos akure, aria ta mare anar um agwuhwdok armiguhw ta rugruki rubuh amnab uwe, uwok. ");
INSERT INTO apec_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Aria shopunek, Iruhin da iganigadae nadareh ihirub ehirub betem ipakigos baragos iri, aria anan gamo nadukemesh um ipak. ");
INSERT INTO apec_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Namudok aria ipak mare punogugur. Ipak penek uhwin um sabaigwuhwi shokwugwuhwi armiguhw.” ");
INSERT INTO apec_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Aria Jisas nakri namudok, “Ihish arpesh douk shuwereh shukrip kupaishi um shape shani eik iri, eik shopunek ko iwereh eshesh um ikrip eikin Yaken nape heven namudok eshudok douk eikish arpesh. ");
INSERT INTO apec_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Aria ihish arpesh douk shuwereh baraen shukrip kupaishi namudok eshesh douk madae shupe shuni eik iri, eik shopunek ta ko ikrip eikin Yaken nape heven namudok eshudok madae eikish arpesh uwe, uwok.” ");
INSERT INTO apec_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","35","Aria Jisas nakri namudok, “Ipak mare pure urkwip aparuh namudok eik douk yanaki um iyatak wanogwiruh agudok nahobig, uwok. Eik madae inamori um iyatak wanohw, uwok. Eik douk yanamori inek ihishmorim arpesh shukitak shurpak. ‘Arman ko nuhwar ananin yaken horin, aria nagawik ko kuhwar okwokwik amakek horik, aria armatok kurao arman iri ko kuhwar okwokwik nakwurikwik horik, ");
INSERT INTO apec_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","aria raminen ananish wanaruh ko shutogur ananish horik horin.’ ");
INSERT INTO apec_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Meishi arpesh da esheshish urkum apahw shakri shunawasham esheshish amakek yaken abom iri, aria madae shukri shunawasham eik abom iri, eshesh ko mare shupe kabi da eikish arpesh um uwe, uwok. Aria meini arman da nakri nunawasham ananin naganin aria ananik nugawik abom iri, aria anan da madae nukri nunawasham eik abom iri, anan ko mare nupe kabi da eikin arpenyin um uwe, uwok. ");
INSERT INTO apec_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Aria meinyi arpen da madae nyusah enyenyin rowogin kruse aria nyigipesh eik iri, aria nyanaiwos um kupaishi shen nyugok um agundok nyagipesh eik um, enyudok arpen ko mare nyupe kabi da eikin arpen um uwe, uwok. ");
INSERT INTO apec_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Aria meishi arpesh ko esheshish urkum apahw ta shukri um shuhogom eshesh kanak atin um esheshin yopinyi poe atin iri, aria eshesh ko shunak yowegunum shuwishuk. Aria meishi arpesh ko esheshish urkum apahw shukri shunawasham eik aria kupaishi shesh shugok um agundok shakana shugipesh eik um, eshesh ko shurao yopinyi poe.” ");
INSERT INTO apec_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Aria Jisas nakri namudok, “Meishi arpesh ko shuhwar ipak aria shenek yopihi aih um ipak, eshesh da shuhwar eik aria shenek yopihi aih um eik. Aria meishi arpesh shenek yopihi aih um eik, eshesh shenek yopihi aih um Iruhin. Umum maresh, anan da neshopok eik ba yanaki. ");
INSERT INTO apec_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Aria meishi arpesh da shutik anan profet aria shukri, ‘Eik yakri um itaurum profet’, anan douk yopuni arman narahaen nenek Iruhin ananin mour iri aria eshesh sharauri anan profet um urupat aria sheyehan shatauruman, aria Iruhin ko noko eshudok arpesh eshudok atatahish yopishi eneshenesh kabi da amam profet haraesh iri um. Aria meishi arpesh shutik anan yopuni arman aria shukri, ‘Anudok arman douk yopuni arman, aria eshesh sharawi anan nanaki urupat aria sheyehan shatauruman,’ aria eshesh ko shurao yopishi eneshenesh kabi da anudok yopuni arman nuraesh iri um. ");
INSERT INTO apec_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Aria meishi arpesh shutik enesh eshudok nyeiguhw wokeshi arpesh aria shukri, ‘Eshudok arpesh Jisas ananish disaipel,’ aria shuken eneh abarih um enen arpen nyape nyagiguki um ihish disaipel douk eikishi, aria eik yakripep adurin atin baraen, eshudok arpesh esheshish yopishi eneshenesh ko mare shunatukuk uwe, uwok.” ");
INSERT INTO apec_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Aria Jisas nakrip ananim 12-poreim disaipel um enyudok baraen da nenek skulumam-enyi jurug, aria nakutukuk abrudok wabur aria nunam debeirubi warub bape agundok iri aria nenek skulum arpesh nakripeshum Iruhin ananin baraen. ");
INSERT INTO apec_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Jon nape shunuweshik-ati urupat, aria nemnek baraenyum ihin mour da Krais nenekenyi, aria neshopok ananim disaipel um hunak hutik Jisas. Aria Jon nakrip ananim disaipel um ");
INSERT INTO apec_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","horig Jisas namudok, “Nyak kripap. Nyak da enyudok arpen Jon nakripap um ko nyunaki iri, aka apak mupe ba mubeim enen kupainyi?” ");
INSERT INTO apec_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Aria Jisas nakripam namudok, “Ipak kare pukrip Jon um ihish eneshenesh ipak pemnek baraenyumeshi aria patrishi. Eshudok douk namudok. ");
INSERT INTO apec_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Eshesh nabes seshuheshi ta shatrugun, aria eshesh aiyas yowegaseshi sharahaen. Eshudok yoweihi arugeh lepra hapeyeshi yopish, aria arigos seshukeshi ta shemnek. Eshudok shagok iri ta shakitak, aria eshudok eneshenesh wokesh iri shemnek Iruhin ananin yopinyi baraen. ");
INSERT INTO apec_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Aria arpesh shutik eik aria shusuhw eikin baraen dodog shigipeshen aria eshesh ko gamo shunadudareh.” ");
INSERT INTO apec_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Abudok nyutob Jon ananim disaipel hape hanak obi, aria Jisas nakitak nakrip sabaishi arpesh um Jon namudok, “Nabudok nyutob ipak panak patik Jon agundok wehigunum douk arpesh wokagunum, ipak douk panak um putik maresh? Panak um putik anah aruh da uhwin nyasusuoh ba nyaunihoh iri aka? Namudok ta uwok. ");
INSERT INTO apec_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Ipak da panak um pakana putik maresh? Douk ipak panak um putik anan arman nore yopiyopihi rupeh iri aka? Namudok ta uwok. Armam hore yopiyopihi rupeh iri, amam da hape king-omi amamig urusag. ");
INSERT INTO apec_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Aria umum maresh ba ipak punak? Punak um putik anan profet aka? Namudok um enyudok douk adur atin. Aria eik yakrip ipak, douk anudok profet Jon anan nenek uhwin um ihim kupaimi profet-omi. ");
INSERT INTO apec_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Umum anudok arman atun ba da anan profet nenyem baraen nyetem Iruhin ananik buk iri kwakri namudok, ‘Eik ko ta ishopokugu eikin arman um ta nukripep eikin baraen, aria anan ko nirikum nyak. Aria anan ta nugapeshumen nyakih yah.’ ");
INSERT INTO apec_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Eik yakri adurin baraenyum ipak. Jon nenek baptaisumesh iri anan nenek uhwin um ihim-morim kupaimi armam hatogur agudok nahobig iri. Aria meinyi arpen douk nyape shokwinyi um arpesh shuwish aburdok wabur Iruhin nape Debeini um ananish arpesh shapeum heven iri, enyudok arpen douk nyenek uhwinyum Jon. ");
INSERT INTO apec_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","“Riguk abudok nyutob Jon nenek baptaisumesh iri nape nakripesh Iruhin ananin baraen obi nyutob arigaha douk, enesh dodogowishi wanohwish arpesh shape dodogeshish atish shape shabirak um shuwish heven aburdok wabur Iruhin nape Debeini um ananish arpesh shapeum. ");
INSERT INTO apec_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Aria ihim profet aria enyudok lo Iruhin seiwok nako Moses enyi, eshesh shakri enyudok Iruhin ananin baraen um heven agundok Iruhin nape debeini um ananish arpesh um arigaha douk Jon natogur nape obi nyutob. ");
INSERT INTO apec_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","“Aria douk ipak pakana pumnek um enyudok yopinyi baraen um, aria ko pumnek. Iruhin ananik buk kwakri namudok aria enyudok baraen da nyakri anudok Jon atun. Profet Elija douk seiwok Iruhin ananin baraen nyakri anan ko ta nanaki. ");
INSERT INTO apec_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Aria douk ipak arigos sapeyepi aria ko pumnek enyudok baraen. ");
INSERT INTO apec_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Aria eik douk ikrium ba iwereh doukish arpesh shapeyohi aih, aria eik ko ikri maren wobuwobrenyi baraenyum eshesh? Eshesh da kabi batowish shape agegwiruh aria shahwarum kupaishi batowish namudok, ");
INSERT INTO apec_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Apak mahwapur buwaen um ipak piyarub, aria ipak da panoiwos um piyarub. Aria apak manoruwor ba meayrub, aria ipak panoiwos um punoruwor ba pureh.’” ");
INSERT INTO apec_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Aria Jisas ta nakri namudok, “Jon nanaki aria madae nuwok sabaiguni worigun aria madae nuwok wain. Aria eshesh shakri namudok, ‘Yoweinyi sagab da nyapeyan.’ ");
INSERT INTO apec_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Aria Eik Anudok Arman yatogur adurinyi arpen iri yanaki, aria yawok worigun nani abar aria shakri, ‘Putik, anan nawok sabaiguni worigun abom, aria anan nawok sabaini wain abom. Anan nenek arpeshim nani amam harao takis iri hani eshudok shenek yoweishi inahos iri.’ Aria eik yakripep namudok, Ipak putik eshudok arpesh sharao Iruhin ananin saki shagipeshen aria shenek yopihi aih iri aria ipak ko pudukemesh pukri, esheshih aih douk yopihi.” ");
INSERT INTO apec_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Anarub warub da Jisas nenek sabainyi Iruhin atun neneken iri mour, aria eshudok arpesh madae shumnek ba shubodig nyirub shubukuk yoweishi inahos apa shenekeshi. Namudok aria Jisas nahao eshudok arpesh shape arbudok warub iri nukesh dodogowinyi baraen eshesh. ");
INSERT INTO apec_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Aria nakri namudok, “Eik yenek gihaum ipak arpesh pape wabur Korasin iri. Aria eik yenek giha abom um ipak pape wabur Betsaida iri. Aria nubo enen arpen nyunak wabur Tair aria Saidon aria nyunek enen Iruhin atun neneken iri mour kabi da eik yeneken orokohun um ipak iri akure, seiwokdai eshesh Tair aria Saidon eshesh ko shubodig nyirub aria shure shagoki shohwurari suruhw aria shuwish weshigabus um shuniyabig namudok eshesh da amu shabukuk yoweishi inahos eshesh shenekeshi. ");
INSERT INTO apec_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Namudok aria eik yakrip ipak um ahudok nyumnah Iruhin nakriyohi um nunek kwotog um ihish arpesh, enyudok amain ko nyutogur um ipak iri ta nyenek uhwin abom um amain ko nyutogur um eshudok arpesh shape warub Tair aria Saidon iri. ");
INSERT INTO apec_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Aria ipak pape Kaperneam iri, ko shutukep puto gani iruhw heven aka uwok? Namudok ta amu uwok. Ipak ta pubuh gani atap atap uguk um gani shagoki esheshibur wabur. Aria nubo enen arpen nyunam wabur Saidon aria nyunek enen Iruhin atun neneken iri mour kabi da eik yeneken orokohun um ipak iri akure, wabur Sodom da wata bupe. ");
INSERT INTO apec_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Namudok aria eik yakrip ipak, um ahudok nyumnah Iruhin nakriyohi um nenek kwotog um ihish arpesh, amain ko nyutogur um ipak iri ta nyunek uhwin abom um nubo rig nyatogur um Sodom iri.” ");
INSERT INTO apec_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Abudok nyutob Jisas nakri namudok, “Yain, nyak Debeini um heven aria agudok nahobig, eik yakri yanadudareh um nyak. Umum maresh? Nyak da nyebeshuk eshudok eneshenesh um arpesh shadukem eneshenesh aria worobainyi saki iri, aria nyeyabig eshudok arpesh shape kabi da shokushi batowish um. ");
INSERT INTO apec_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Aria eik yakri wosik, Yain, nyak nyagipesh nyakish urkum apahw shakri um aria douk nyabirak namudok.” ");
INSERT INTO apec_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Aria Jisas ta nakri namudok, “Eikin yaken anan iganigadae nobuk ihish eneshenesh um eikis wis. Aria madae enen arpen da nyudukemesh um Nuganin, Yaken atun douk nadukemesh um eik. Aria madae enen arpen da nyudukemesh um Yaken uwe, uwok. Nuganin atun nani eshudok arpesh douk Nuganin atun niyabig Yaken um eshesh iri, eshesh atish da shadukemesh um Yaken. ");
INSERT INTO apec_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Ipak arpesh douk penek debeinyi mour abom iri aria purao debeinyi amain, ipak ihipmorim punamori um eik aria eik ta ikep uhwin um ipak. ");
INSERT INTO apec_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Ipak ko purao saki um eik aria pupe shakamum eikin baraen. Namudok aria puhur aidap da shopemum um bulmakauin aruhwigur iri um da shanuk eneshenesh enyi. Ipak purao eikin saki. Umum maresh? Eik da samokwiyain arpen aria eik yenekesh shokubur um ipak arpesh. Aria eik yape shokubur atin kabi da enen batowin um. Aria ta eneshenesh mare shukep amaenyibi bagab ipak aria ipak ta purao uhwin um ipakish urkum apahw. ");
INSERT INTO apec_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Apudok aidap eik douk yopemum ipakish aruhwiguhw iri apap douk horihorip aria ipak ta wosik pupusah. Aria eneshenesh eik yako ipakeshi um pushusah eshesh da madae amaenyish atish uwe, uwok.” ");
INSERT INTO apec_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Anob nyutob banak banakuk aria anah nyumnah douk eshesh Juda mour uwok shape meyoh ahi hanak hatograri, aria Jisas nani ananim disaipel hawish hanak anag nubarig douk shau witagari. Aria ananim disaipel nyurub bam, aria amam hadi anat shuruwepit wit ba apa hatoh hanak. ");
INSERT INTO apec_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Aria amam Farisi hatik, aria hakrip Jisas namudok, “Nyak nyutik ahudoki aih da nyakim disaipel henekohi, apakin lo nyakri uwok um menek enen mour ahudok nyumnah Sabat, uwok.” ");
INSERT INTO apec_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Jisas nemnek namudok aria ta nakripam namudok, “Ipak da madae putik ba pudukemesh um seiwok Devit nenekeshi eneshenesh? Eik yakri nabudok nyutob Devit nani ananimi da nyurub bam ");
INSERT INTO apec_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","aria Devit nawish Iruhin ananit debeiti urupat aria nohur atudok bret amam pris da hatubuk um Iruhin iri aria nani ananimi hatoh. Atudok bret da shakri uwok um kupaishi ta shutoh iri. Amam pris atum da shakri wosik um hutoh. ");
INSERT INTO apec_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Aria ipak shopunek madae putik ba pudukemesh namudok enyudok baraen nyape numun Iruhin ananin lo nyetem buk iri, nyakri namudok. Amudok pris henek mour numun Iruhin ananit debeiti urupat iri amam ta henek mour ahudok nyumnah Sabat? Amam pris da habrig enyudok lo da nyakri Sabat iri, aria amam pris da madae enen baraen nyupeyam uwe, uwok. ");
INSERT INTO apec_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Aria eik douk yakana ikripep, douk eik yape agundok iri, eik debeini yenek uhwinyum Iruhin ananit debeiti urupat. ");
INSERT INTO apec_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Aria baraen douk nyape Iruhin ananik Buk iri douk nyape namudok, ‘Eik yanoiwos um ipakin ofa ipak peneken meyoh iri. Eik yakri yanawasham yopihi aih um ipak pusuhw yopuhwi ruwohw aria penek gihaum kupaishi.’ Aria nubo ipak gamo pudukemesh um enyudok baugosin um enyudok baraen, aria ipak ta mare puwem amaenyibi bugob um kupaishi da madae shenek enesh yoweishi inahos iri. ");
INSERT INTO apec_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Umum maresh? Eik Anudok Arman yatogur adurinyi arpen iri douk eik kanak yape debeiwe iri um ikrip arpesh shunek maren mour ahudok nyumnah Sabat.” ");
INSERT INTO apec_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Aria Jisas nakutukuk amam Farisi nagundok aria nanak nawish anat eshesh Juda shape sheyagwreh baraenyati urupat. ");
INSERT INTO apec_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Nawish aria natik anan arman rogur nyagokan iri nape. Anam armam hape hakana heneman baraen Jisas, namudok aria harigan hakri, “Jisas nyak nyukri, Iruhin ananin lo da nyakri wosik um mugabe arugeh henekeshi arpesh ahudok nyumnah Sabat aka, uwok?” ");
INSERT INTO apec_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Aria Jisas nakripam namudok, “Douk anan arman orokohun um ipak aria anan da nagrem enen atin sipsip aria enyudok sipsip nyunak ba nyugrukuk anag nuwag douk ahudok nyumnah Sabat aria ipak da padukemesh jurug, anudok arman ta nunak nusuhw enyudok sipsip aria ta nutukenyi agudok nuwag. ");
INSERT INTO apec_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Aria anan arman douk amu nenek uhwin abom um enen sipsip aka, uwok? Namudok aria douk yopunyi um apak monek yopunyi mugu nyutogur douk ahudok nyumnah Sabatih.” ");
INSERT INTO apec_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Aria Jisas nakrip anudok rogur nyagokanari namudok, “Nyak nyunu nyakin rogur.” Aria anudok arman nonu ananin rogur, aria ananin rogur ta nyatogur yopin kabi da enyudok enen ananin yopunyi rogur da nyape meyoh iri. ");
INSERT INTO apec_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Aria amam Farisi hatik namudok aria hakitak hatogur hanak ba hape habo baraen haurim yah um ko hubo Jisas nugok. ");
INSERT INTO apec_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Aria Jisas nadukemeshum enyudok amam Farisi hakri um ta hunekenyum anan iri, aria nakitak nakutukuk abrudok wabur aria nanak. Nanak aria worobaishi arpesh shagipeshan. Shagipeshan aria nagabe eshudok ihishmorim da arugeh hapeyeshi arpesh shatogur yopish meyoh. ");
INSERT INTO apec_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Aria nakripesh dodogowinyi baraen um mare ta shunak shukrip kupaishi um anan uwe, uwok. ");
INSERT INTO apec_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Umum ahudok aih atuh, Jisas nenek enen baraen seiwok Iruhin nohur profet Aisaia ba neyagwrehenyuk iri baraen nyatogur adur atin. Aria baraen enyudok, ");
INSERT INTO apec_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Anudok eikin arman nenek mour um eik iri. Eik kanak yagraeh anan. Eik yakri anan abom, aria eikish urkum apahw shanawasham shanadudareh um anan abom iri. Eik ko ikan eikin yopunyi Mishin nyuwish um nyupe anan, aria anan ko niyagwreh nuwereh baraen um yopinyi poe aria yopihi aih ko hutogrum ihishmorim arpesh madae shudukemesh um eikin baraen shape agudok nahobig iri. ");
INSERT INTO apec_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Anan ta mare niyagwreh rupanitakin baraen aria nuhwar debeg uwe, uwok. Aria eshesh arpesh ta mare shumnek anan niyagwreh debeihi yeh shopunek uwe, uwok. ");
INSERT INTO apec_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Aria aruh hanounih iri ta mare nutugwaruh. Aria anan ta mare nubuweh lam da madae gamo hininyi. Anan ta nupe nenek mour arigaha ko enyudok yopinyi poe aria yopihi aih shutogur ba shenek uhwinyum ihishmorim yoweishi inahos shutuhuk. ");
INSERT INTO apec_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Aria ihish madae shudukemesh um eikin baraen iri arpesh eshesh ko shenek bilipum anan.” ");
INSERT INTO apec_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Nabudok nyutob enesh arpesh sharauri anan arman da yoweinyi sagab nyapeyan iri. Aria da madae niyagwreh nukwat teshukan ba nabes shopunek seshukan aria madae nutrugun uwe, uwok. Aria sharan shanamorim Jisas. Aria Jisas nagabeyan yopun, aria ta neyagwreh ba natrugun shopunek. ");
INSERT INTO apec_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Aria ihish arpesh shakitak yowiyokuk aria shakri namudok, “Anudok arman da Devit ananin barhonin,aka?” ");
INSERT INTO apec_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Aria amam Farisi hemnek enyudok baraen, aria hakri namudok, “Anudok arman da nahiyah yoweishi sagabehos um nakwu enyudok yoweinyi sagab Belsebul enyenyin dodog, enyudok yoweinyi sagab da debeinyi um ihish yoweishi sagabehos.” ");
INSERT INTO apec_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Aria Jisas da nadukemesh um amamigos baragos urkwip da shorum, aria nakripam namudok, “Douk enesh arpesh shupe anag nahobig aria shunorupok ba shupe tukwotukwan, aria arpesh shape agudok nahobig iri ko shunanunukuk. Aria enesh arpesh shape anabur wabur aka anat urupat iri shunarupok ba shupe tukwotukwan, aria arpesh shape abrudok wabur urupat iri ko mare shupe dodogeshish uwe, uwok. ");
INSERT INTO apec_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Namudok aria douk Satan nukuna nupotik anan kanak um, aria apak ta mudukemesh namudok. Satan ananishi iganigadae shanabrig shape tukwotukwan. Namudok aria anan ta nurao dodog agunum um ta niyoh ananishi arpesh shuni eneshenesh? Aria namudok ta uwok. ");
INSERT INTO apec_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Aria douk adur atin um Belsebul nutaurum eik um aria yehiyah eshudok yoweishi sagabehos um, namudok aria amiapen douk nyataurum ipak aria pohiyah yoweishi sagabehos? Ipakishi arpesh douk shahiyah yoweishi sagabehos iri ta shiyabig ipak namudok enyudok baraen ipakin madae adurinyi baraen uwe, uwok. ");
INSERT INTO apec_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Aria douk eik yadukemesh namudok Iruhin ananin yopunyi Mishin nyataurum eik nyeke dodog aria eik yahiyah eshudok yoweishi sagabehos aria ipak ta pudukemesh namudok, abudok nyutob um ipak puwish agundok Iruhin nape Debeini um ananish arpesh um douk batogur. ");
INSERT INTO apec_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Enen baraen shopunek nyakri namudok. Anan arman ta wosik um nunak nuwish anan dodogowini arman ananit urupat aria nukwuaruh um ananish eneshenesh aka uwok? Namudok ta uwok. Anudok arman ko nuweshik anudok dodogowini arman nukwu dodogowihwi maduhw ba iyoh, aria ta nenekesh namudok, aria ta ko nuwish ba nuhur eneshenesh shakuh anudok dodogowini arman ananit urupat iri. ");
INSERT INTO apec_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Meishi arpesh madae shunahwaram eikish arpesh iri, eshudok arpesh ko shunahwaram eikish horik horin. Aria meishi arpesh madae shutaurum eik ba murauri ihish arpesh iri, eshesh ko shuhiyahesh shuruwok shushutogur. ");
INSERT INTO apec_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","“Namudok aria eik yakrip ipak, Iruhin ko nukweshih ihish yoweishi inahos aria ihin yoweinyi baraen arpesh sheneken iri. Aria arpesh sheneyagwreh shabubunim Iruhin ananin Mishin iri, Iruhin ta mare nukweshih enyudok yoweinyi ina uwe um eshudok arpesh. ");
INSERT INTO apec_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Meishi arpesh sheneyagwreh shabubunim Eik Anudok Arman yatogur adurinyi arpen iri, Iruhin ta nukweshih enyudok yoweinyi ina um eshudok arpesh. Aria meishi arpesh da sheneyagwreh shabubunim Iruhin ananin Mishin iri, Iruhin ta mare nukweshih enyudok yoweinyi ina um eshudok arpesh uwe, uwok. Douk aria kweipon babi bagiguki nyutob shopunek amu uwok.” ");
INSERT INTO apec_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Aria Jisas nakri namudok, “Douk enen yopunyi rowog aria ta nyubuki yopipi shuruwep ba pir. Aria yoweinyi rowog, aria ta nyubuki yoweipi shuruwep ba pir. Arpesh ko shutik shuruwepigun worigun ba iyoh, aria ta shudukemesh enyudok rowog da yopunyi aka yoweinyi. ");
INSERT INTO apec_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Ipak yoweishi arpesh, ipak kabi da yoweiguhwi yuguhw um. Umum maresh ba ipak da madae piyagwreh yopinyi baraen uwe? Arpesh shadukemesh um shuwereh baraen da shunukin nyor esheshish urkum apahw iri. ");
INSERT INTO apec_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Yopishi arpesh shor yopinyi baraen esheshish urkum apahw. Namudok aria eshesh shadukemesh um ta shunek yopihi aih aria shupe yopinyi poe. Aria yoweishi arpesh shor yoweinyi baraen esheshish urkum apahw. Namudok aria eshesh shadukemesh um ta shunek yoweihi aih aria shupe yoweinyi poe. ");
INSERT INTO apec_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","“Aria douk eik yakrip ipak, um ahudok nyumnah Iruhin nugraehahi um nunek kwotog um ihish arpesh um, anan ko urkum mur um ihin nyaunyatograri aria ihin yoweinyi baraen ihish arpesh sheyagwrehen iri aria anan ko nunemesh kwotog. ");
INSERT INTO apec_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Um ipak kanak ipakin baraen Iruhin nemneken aria ta nuhwarep um yopishi arpesh aka yoweishi arpesh.” ");
INSERT INTO apec_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Aria anob nyutob, anam henek skulumesh um lo iri hani anam Farisi hakrip Jisas namudok, “Tisa, apak makri nyak nyunek enen Iruhin atun neneken iri mour ba mutrin aria ta ko mudukemesh um nyak da adur atin nyenek Iruhin ananin mour iri.” ");
INSERT INTO apec_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Aria anan nakripam namudok, “Ipak doukipari um abudok nyutob, ipak da yoweipari aria ipak madae gamo pukon urkwip aparuh um Iruhin uwe, uwok. Ihib nyutob ipak pakri puhwar eik um putik enen kak um Iruhin atun neneken iri mour. Aria ipak ta mare putik enen enyudoki kak uwe, uwok. Atin arag kak ipak ko putrin iri, enyudok seiwok Iruhin neneken um profet Jona iri. ");
INSERT INTO apec_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Jona nubo nor 3-poreih nyumneh aria 3-poreibus weibus numun um debeiri eiyur araribur nyibur, aria namudok atin Eik Anudok Arman yatogur adurinyi arpen iri ta iyur 3-poreih nyumneh aria 3-poreibus weibus numun um amnab. ");
INSERT INTO apec_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Ahudok nyumnah Iruhin nakriyohi um ta nunemesh kwotog ihish arpesh, Niniveish arpesh ko shiyotu um baraen aria shenekumesh baraenyum doukish arpesh shape obi doukib nyutob um yoweishi inahos eshesh shenekesh iri. Umum maresh, eshesh Ninive shemnek baraen profet Jona nakripesh-enyi aria eshesh shabadig nyirub shabukuk yoweishi inahos shekesh agab. Aria eik douk anan arman yape orokohun um ipak iri, eik douk yenek uhwin abom um Jona. Aria ipak douk madae pubukuk yoweishi inahos pigipesh eik uwe, uwok. ");
INSERT INTO apec_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Nabudok nyutob Iruhin nakriyobi um nunemesh kwotog ihish arpesh, kwin kwape saut iri ta ko kwiyotu um kwot kwereh yoweishi inahos um doukish arpesh shapeyobi doukib nyutob. Umum maresh? Okwudok kwin kwape gani nagiguk um agudok nahobig, aria okwok kwanaki um kwomnek Solomon nuwereh ananin yopinyi saki. Aria eik douk yape agundok iri, eik douk yenek uhwin abom um Solomon.” ");
INSERT INTO apec_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Aria Jisas anan kanak nakri namudok, “Aria enen yoweinyi sagab da nyukutukuk enen arpen obi nyutob, aria enyen ko nyunak nyurahe nyunak anagun abar wokagun um nyunak nyupe nyurao uhwin. Aria enyen ta mare nyuparug anabik yapugunum um ta nyurao uhwin. ");
INSERT INTO apec_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Aria enyen ta nyukri namudok, ‘Eik ko itanam inam eikit urupat nubo rig yapenyat iri.’ “Namudok aria enyen ko ta nyutanam nyunak um atudok urupat ba nyutik atudok urupat tape meyoh. ");
INSERT INTO apec_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Namudok aria enyen ta nyunak nyurauri 7-poreish kupaishi sagabehos eshesh da shenek uhwin um enyudok nyarik iri sagab um apa shenek yowoyoweishi inahos iri. Aria eshesh ta shuwish shupe atudok urupat. Nubo rig enyudok arpen madae yowen abom uwe, uwok. Aria douk enyen amu nyabo sisih abom. Aria atatahih yoweihi aih ko hutogur um ipak eshudok yoweishi arpesh douk pape abudok doukib nyutob iri.” ");
INSERT INTO apec_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Aria Jisas ta apa neyagwreh nakrip eshudok sabaishi arpesh um baraen, aria ananik amakek kwani ananim owarhim shanaki sheyotu aduk. Eshesh shakana shiyagwreh shuni anan. ");
INSERT INTO apec_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Aria anan arman nakrip Jisas, “Nyak nyumnek. Nyakik amakek kwani nyakim owarhim shanaki sheyotu aduk, aria shakana shuni nyak shiyagwreh.” ");
INSERT INTO apec_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Aria Jisas nakrip anudok arman namudok, “Meikwiyah da eikik amakek? Aria meimiyah da eikim owarhim?” ");
INSERT INTO apec_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Aria anan naduk wis um ananish disaipel aria nakri namudok, “Nyutik eikiyu amakenyiyu wani eikim owarhim. ");
INSERT INTO apec_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Umum maresh? Meishi arpesh da apa shagipesh eikin yaken da nape iruhw heven iri um ananim yopumi urkum aria baraen, eshesh douk ta ihwaresh eikin wanin, eikik mohwukwik aria eikik amakek.” ");
INSERT INTO apec_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Ahudok atuh nyumnah Jisas nakutukuk urupat aria natogur aduk. Aria nanak nape anagasigum Galilieg waiyag. ");
INSERT INTO apec_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Aria sabaishi arpesh shanamori anan. Namudok aria anan naprok nato nakih natem anat bot aria ihishmorim arpesh sheyotu anagasigum waiyag gani jakahasigunum. ");
INSERT INTO apec_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Aria Jisas nakripesh sabainyi wobuwobrenyi baraen um eshesh. Aria anan nakri namudok, “Pumnek. Anan arman nanak nawashak shuruwepit wit gani nubarig. ");
INSERT INTO apec_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Anan apa nawashat nanak aria anat tabuh takus yah aria armiguhw hwanaki hwatoh. ");
INSERT INTO apec_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Aria anat shuruwepit wit tabuh takus utaborigunum, madae sabaibi amnab bukusagunum. Amnab madae budi bubuh atap uwe, uwok, namudok aria atudok wit tatogur arigas atin. ");
INSERT INTO apec_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Aria aun nakihi wah hatao aria wah habo atudok wit ba tagok. Umum maresh, nukwaruh madae hunu hubuh utaborigunum aria wit amu yarit ba tagok. ");
INSERT INTO apec_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Aria anat shuruwepit wit tabuh orokohun um segego wape aruhi madururuh. Aria aruhudok segegoiruh madururuh hakitak ba heyawiamukuk wit. ");
INSERT INTO apec_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Aria anat shuruwepit wit tabuh yapubi amnab, Aria tobuki worigun. Anat tabuki 100-poreit, aria anat tabuki 60-poreit, aria anat tabuki 30-poreit atut. ");
INSERT INTO apec_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Arpesh arigos sapeyeshi eshesh ko gamo shumnek enyudok baraen.” ");
INSERT INTO apec_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Jisas nakripesh enyudok baraen ba jurug, aria ananim disaipel hanamori anan aria harigan namudok, “Umum maresh ba nyak nyeyagwreh wobuwobrenyi baraen um eshudok arpesh?” ");
INSERT INTO apec_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Aria Jisas nakri namudok, “Iruhin neyabik ipak ba padukemesh jurug um baugosinyum um enyudok nyanabeshuk iri baraen um arpesh shuwish aburdok wabur Iruhin nape Debeini um ananish arpesh shapeum heven. Aria anan da madae niyabik enyudok nyanabeshuk iri baraen um eshudok arpesh uwe, uwok. ");
INSERT INTO apec_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Aria douk meishi arpesh sharao Iruhin ananin baraen shadukemen aria Iruhin ta nukesh enen yopinyi baraen shopunek um eshesh aria eshesh ta shugrem sabainyi yopinyi baraen shopunek. Aria douk meishi arpesh madae shugrem enen yopinyi baraen, aria Iruhin ta neyatakuk aria nutrish ihin banenyi aria shokwinyi baraen eshesh da shagremen iri. ");
INSERT INTO apec_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Um enyudok baugenyum baraen atin eik da yeyagwreh yakripesh um wobuwobrenyi baraen atin. Esheshis nabes satrugun, aria madae shutik enesh muguhwos. Eshesh shabuk arigos aria eshesh madae shumnek baraen ba shunyur baragos uwe, uwok. ");
INSERT INTO apec_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Um eshudok arpesh, aria enen baraen seiwok profet Aisaia neyagwrehenyuk iri douk nyatogur adur atin. Aria baraen enyudok, ‘Ipak ta pumnek baraen sabaibi nyutob, aria ipak ta mare pudukemesh um baugenyum baraen. Ipak ta putrugun um sabaibi nyutob, aria ipak ta mare pudukemesh um enen mugu. ");
INSERT INTO apec_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Umum maresh? Ipak arpesh ipakish urkum apahw nubo sheshuk, aria ipakigos arigos sanoiwos sumnek baraen, aria ipakis nabes nubo seshuk um ta putik enen mugu. Uwok um, ipakigos arigos ta sumnek baraen, aria ipakish urkum apahw ta shudukemesh um enyudok baugenyum baraen aria ipak pubukuk yoweishi inahos aria putanam panaki um eik aria eik ta gamo igabeyep ba putogur yopishi arpesh.’ ");
INSERT INTO apec_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“Aria ipak panadudareh. Ipakis nabes douk satik eneshenesh. Aria ipakigos arigos semnek baraen. ");
INSERT INTO apec_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Eik yakripep adurin baraen, seiwok sabaimi profet aria sabaishi yopishi arpesh madae shenek yoweishi inahos iri eshesh shakri um shutik eshudok eneshenesh douk ipak patrishi aria eshesh madae shutrish uwe, uwok. Aria eshesh shakri um shumnek enyudok baraen ipak douk pemnekenyi aria eshesh madae shumneken uwe, uwok.” ");
INSERT INTO apec_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Aria Jisas nakri namudok, “Douk ipak pumnek baugenyum baraen um anudok arman nawashak shuruwepit wit nubarig iri. ");
INSERT INTO apec_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Eshudok arpesh shemnek yopinyi baraen um arpesh shuwish agundok Iruhin nape Debeini um ananish arpesh um. Aria madae shudukemesh um baugenyum enyudok baraen, eshesh kabi da atudok shuruwepit wit tabuh takus yah iri, aria Satan nunamori eshesh aria atub nyutob natrish enyudok baraen Iruhin nawen numun esheshish urkum apahw iri. ");
INSERT INTO apec_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Aria atudok shuruwepit wit tabuh takus utabor igunum, atudok wit kabi da arpesh da shemnek baraen aria atub nyutob aria shanadudareh umen. ");
INSERT INTO apec_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Aria nukwaruh uwoken, aria shasuhw baraen banabi nyutob meyoh. Aria kupaishi shukripesh nyagiyagigi enenyenen baraen um Iruhin ananin baraen aria shukesh bugob um eshudok arpesh aria shanunu eshudok arpesh, aria shopunek shanunu enyudok bilip atub nyutob. ");
INSERT INTO apec_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Aria shuruwepit wit da tabuh orokohun um segego wapeyoruhi mandururuh iri, kabi da arpesh shemnek baraen, aria esheshish urkum apahw aria barag shakri abudok amnabish eneshenesh abom, aria shakana shutorumori sabaibori utabor. Eshudoki eneshenesh shiyawim Iruhin ananin baraen, aria madae yapuguni worigun nutogur uwe, uwok. ");
INSERT INTO apec_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Aria atudok shuruwepit wit tabuh yopubi amnab iri, atudok kabi da arpesh shemnek baraen aria gamo shadukemesh um baugenyum baraen iri. Eshesh ko shubuki yopuguni worigun kabi da atudok yaputi wit um, anat 100-poreit teir, anat 60-poreit teir, aria anat 30-poreit teir.” ");
INSERT INTO apec_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Aria Jisas nakripesh kupainyi wobuwobren baraen namudok, “Arpesh shuwish agundok Iruhin nape Debeini um ananish arpesh shapeum heven, douk kabi da anan arman nawashak yoputi shuruwepit wit um ananig nubarig. ");
INSERT INTO apec_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Aria eshesh arpesh sheshuh obi nyutob, anudok arman ananin horin nanaki aria nawashak yoweiruhi utoruhip shuruwep orokohun um wit aria nanak. ");
INSERT INTO apec_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Arigaha atudok wit tatogur takih tereh tape ba teir, aria shatik aruhudok yoweiruhi utoruh shopunek hatogur. ");
INSERT INTO apec_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","“Aria amudok henek mour um anan iri hanaki hakripan namudok, ‘Debeini, apak makana nyak nyuwashak yoputi shuruwepit wit atut um nyakig nubarig. Aria yoweiruhi utoruh hatogur mumam nubarig?’ ");
INSERT INTO apec_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","“Aria anan nakripam namudok, ‘Anan horin nanaki aria nenekesh namudok.’ “Aria amam heneman mour iri harigan, ‘Nyak nyakana apak munak muburak aruhudok utoruh mugitaruh aria mubuk aruhudok yoweiruhi utoruh atugun aka?’ ");
INSERT INTO apec_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","“Aria anan nakripam namudok, ‘Namudok uwok. Ta puburak yoweiruhi utoruh aria puburakuk wit shopunek.’ ");
INSERT INTO apec_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Aria eik yakri wosik um wit aria yoweiruhi utoruh shutogur aragarag, arigaha nabudok nyutob ko mudar wit obi nyutob. Aria eik ta ko ikrip amudok henek enyudok mour iri namudok, ‘Ipak putorum yoweiruhi utoruh iyoh aria punotugoruh um unug um pushairuheh nyih. Aria ipak putorum wit ba putubuk gani eikit worigunit urupat.’” ");
INSERT INTO apec_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Aria Jisas nakripesh kupainyi wobuwobrenyi baraen namudok, “Arpesh shuwish agundok Iruhin nape Debeini um ananish arpesh shapeum heven douk kabi da anan arman nohur anam mastetim shurkum aria nawom gani ananig nubarigum. ");
INSERT INTO apec_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Mastetip shuruwep da shokushokwip abom um kupaigosi rowosip shuruwep, shurkum makih amnab mato iruhw, aria munahwaram enen debeinyi rowog nyenek uhwinyum kupaigosi rowos. Aria armiguhw hwanaki hwawish enyudok rowog ba hwenek was sotem rowogish nyeiguhw.” ");
INSERT INTO apec_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Aria Jisas nakri namudok, “Arpesh shuwish agundok Iruhin nape Debeini um ananish arpesh shapeum heven douk kabi da yis um. Onok armatok kwohur asudok yis aria kwabadigas um sene ushiwish um plaua numun anap debeipi marup. Aria enyudok plaua nyakitak nyanagok nyato nyatogur debeinyi.” ");
INSERT INTO apec_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Jisas neyagwreh nakwu wobuwobrenyi baraen um nakrip ihish arpesh. Anan madae niyagwreh meyoh nukwu kupainyi baraen uwe, uwok. Anan nakwu wobuwobrenyi baraen atin. ");
INSERT INTO apec_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Anan douk nakripesh wobuwobrenyi atin um enen baraen seiwok anan profet nenyemokuk iri nyatogur adur atin da nyakri namudok, “Eik ko iyagwreh nukwat ikri wobuwobren baraen. Aria ikripesh baraen um nyunabeshuki enenyenen baraen seiwok Iruhin nakwarum agudok nahobig um ba nakriyen nyape arigaha douk atin nyatogur.” ");
INSERT INTO apec_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Aria Jisas nakitak nakutukuk eshudok worobaishi arpesh shapeik aria nanak nawish urupat. Aria ananim disaipel hanaki hatrun aria hakripan namudok, “Apak makri nyak nyukripap baugenyum baraen um enyudok wobuwobrenyi baraen um yoweiruhi utoruh hatogur nubarig iri.” ");
INSERT INTO apec_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Aria Jisas nakri namudok, “Arman nawashak yoputi wit iri, anudok eik atuwe Eik douk Anudok Arman yatogur adurinyi arpen iri. ");
INSERT INTO apec_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Aria nubarig douk agudok nahobig. Aria yaputi shuruwepit wit, douk eshudok arpesh da shape shawish agundok Iruhin nape debeini um ananish arpesh um. Aria yoweiruhi utoruh, douk eshudok arpesh shanawasham Satan iri. ");
INSERT INTO apec_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Aria anudok horin da nawashak yoweiruhi utoruhip shuruwep, anan da Satan. Aria shurim worigun obi nyutob, abudok nyutob kweipon agudok nahobig gunonukuk obi nyutob. Aria hunek mour iri eshudok da enselahos. ");
INSERT INTO apec_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Aria amudok douk hagit yoweiruhi utoruh ba heshairuheh nyih iri, amudok kweipon henekesh namudok atin um hahi hagiguki nyumnah um agudok nahobig. ");
INSERT INTO apec_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Eik douk Anudok Arman yatogur adurinyi arpen iri ta ishopok eikish enselahos eshesh ko shunak shutorum ihish arpesh shuni ihish eneshenesh da shanunu bilip um arpesh iri, shuni ihishmorim arpesh shenek yoweishi inahos iri. Eshudok arpesh ta mare shuwish shupe abrudok wabur Iruhin nape Debeini um ananish arpesh um, uwok. ");
INSERT INTO apec_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Aria ta enselahos shuwashak eshudok yoweishi arpesh shuwish debeihi nyih. Aria ko shupe numun ehudok nyih ba shereh yowiyokuk shurpak naruh shuwegoruh. ");
INSERT INTO apec_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Um abudok nyutob atub aria eshudok shape yopinyi poe ba madae shenek yoweishi inahos iri ta shutogur anahaeh kabi da nyumnohin aunit lait morim gani numun esheshin Yaken Iruhin napeum douk agundok anan nape Debeini um ananish arpesh um. Ipak arpesh da arigos sapeyepi aria ko pumnek enyudok baraen.” ");
INSERT INTO apec_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Aria Jisas nakri namudok, “Arpesh shuwish agundok Iruhin nape Debeini um ananish arpesh shapeum heven douk kabi da enen yopunyi mugu shatorin debeibori utabor iri um da enesh shebeshuken nyor anag amnabig nubarig. Anan arman natrin aria ta natuken nabeshuken kupaigunum. Aria anan nanadudareh abom aria nanak nekesh ihishmorim ananish eneshenesh um kupaishi arpesh ba shatorish shakon utabor aria anan nasuhw utabor nanak nator agudok nubarig.” ");
INSERT INTO apec_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Aria Jisas ta nakri namudok, “Aria enen kupainyi wobuwobrenyi baraen nyunak namudok. Aria arpesh shuwish agundok Iruhin nape Debeini um ananish arpesh shapeum heven douk kabi anan nenek bisnis iri arman nape naurim anab yopiyopibi weiyoub um. ");
INSERT INTO apec_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Naurimab nanak arigaha nanak naparug anab yopiyopibi weiyoub douk shatorub debeibori utabor iri. Aria nanak nekesh ihishmorim ananish eneshenesh um kupaishi arpesh ba shatorish shakon utabor, aria anan nasuhw utabor nanak ba nator abudok yopiyibi weiyoub.” ");
INSERT INTO apec_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Aria Jisas ta nakri namudok, “Aria shopuk kupainyi wobuwobrenyi baraen nyanak namudok. Shopunek arpesh shuwish agundok Iruhin nape Debeini um ananish arpesh shapeum heven, douk kabi anan umben um eshesh shuwashon nabuh waiyag aria sabaiguhwi yomoyomogiguhw eiguhw hwawish hwatuk anudok umben. ");
INSERT INTO apec_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Anudok umben shunukin, aria eshesh shanukan nanaki anagasigum waiyag. Aria shape sheagom yopugwuhwi eiguhw shoguhwur yaureruhw. Aria yoweiguhwi ta showashoguhuk. ");
INSERT INTO apec_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Kweipon hahi hagiguki nyumnah hutogur agudok nahobigum ta shubirak namudok atin. Eshesh enselahos ko shunaki shurao yoweishi arpesh da shape orokohun um yopishi arpesh shapeum, ");
INSERT INTO apec_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","aria eshesh ta shuwashak eshudok yoweishi arpesh shuwish ehudok debeihi nyih. Gani numun um ehudok nyih eshesh ko shureh yowiyokuk aria shurpak naruh shuwatoruh.” ");
INSERT INTO apec_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Aria Jisas narik ananim disaipel namudok, “Ipak douk padukemesh um enyudok baugenyum ihin baraen?” Aria amam hakripan namudok, “Wosik apak madukemesh.” ");
INSERT INTO apec_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Aria anan nakripam namudok, “Namudok aria amudok ihim henek skulumesh um lo iri douk atin ta hanaki hagipesh eik henek skulumesh um shuwish agundok Iruhin nape Debeini um ananish arpesh shapeum heven, amam hape kabi da anan yaken douk nagrem anat debeiti urupat. Aria nanak nawish numun atudok urupat um anam rum um da sabaishi yomoyomogish yopiyopishi ananish eneshenesh shunukigun ba shakuh omi rum, aria anan nohuri ihishmorim namushi aria jugwaishi eneshenesh aria naraesh natograri aduk.” ");
INSERT INTO apec_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Jisas nakripesh enyudok ihinyumorim wobuwobrenyi baraen ba jurug, aria nakitakuk abrudok wabur ba nanak. ");
INSERT INTO apec_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Aria anan nanak anan kanak ananibur wabur. Aria anan nanak nawish gani numun esheshit urupat douk eshesh Juda shape sheneyagwreh baraen-ati aria apa nenek skulumesh nakripesh Iruhin ananin yopinyi baraen um ihishmorim arpesh. Eshesh shemnek enyudok baraen aria shakitak yowiyokuk aria shakri namudok, “Anudok arman nanak narawi enyudok yopunyi saki agunum? Aria anan da wosik nenek enyudok Iruhin atun neneken iri mour ko neneken nyatogur mumam? ");
INSERT INTO apec_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Apak madukemesh anudok arman anan da kamdain nuganin aria Maria da ananik amakek. Aria Jems, Josep, Saimon aria Judas da ananim owarhim. ");
INSERT INTO apec_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Aria ananiyu ihiyumorim mohwiyariyu, owo da wani apak wape. Namudok mumam aria anan ta wosik nenek eshudok eneshenesh?” ");
INSERT INTO apec_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Eshesh shakri namudok aria esheshish urkum apahw yoweshum anan aria shakanukuk agab Jisas. Aria Jisas nakripesh namudok, “Profet ananin nyeigur ko nyupe ihirub warub. Aria um anan kanak ananibur wabur aria anan kanak ananip awiropish ko mare shunadudareh um ananin nyeigur uwe, uwok.” ");
INSERT INTO apec_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Aria anan ta mare nenek sabainyi enyudoki Iruhin atun neneken iri mour abrudok wabur uwe, uwok. Umum maresh? Eshesh da madae shenek bilip um anan uwe, uwok. ");
INSERT INTO apec_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Aria abudok nyutob, Herot douk nape debeini um gavman um agudok shokugi nahobig Galili. Aria anan nemnek baraen um Jisas nape nenekeshi eneshenesh. ");
INSERT INTO apec_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Aria Herot nakrip amudok henek mour um anan iri namudok, “Anudok arman douk Jon nenek baptaisumesh iri atun. Anan atun ta nakitak wonugwehw. Namudok aria anan douk dodogeshin atun um nenek enyudok Iruhin atun nenekenyi mour.” ");
INSERT INTO apec_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Seiwok Herot narao Herodias, okwok da Filip ananik irohukwik, aria Filip douk watak nape. Filip da Herot ananin wanin. Aria Jon nubo nakrip Herot namudok, “Nyak nyabrig Iruhin ananin lo um nyatrun ananik armatok. Namudok ta mare nyenekesh uwe, uwok.” Namudok aria Herot nasuhw Jon aria napiyakan nakwu senab aria nanur nape shunuweshik-ati urupat. ");
INSERT INTO apec_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Aria Herot nakana nubo Jon nugok, aria ta nanogugur um eshesh shakana Jon da anan profet. ");
INSERT INTO apec_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Anah nyumnah enesh arpesh shanaki shani Herot shape shawok worigun um urkwip purum ahudok nyumnah seiwok nanakwaram ahi. Aria abudok nyutob Herodias okwokwik nugawik kwanaki kwape kweyorub kwatukobur kwanaki kwanak agundok da shantorum shapeum. Aria okwok kwonekesh namudok aria Herot nanadudareh abom um okwok. ");
INSERT INTO apec_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Namudok aria Herot nakripok adurin atinyi baraen um okwok namudok, “Adur iruhw nyak ta nyukri nyurik eik um maresh muguhwos aria eik ta ko ikenyesh atish.” ");
INSERT INTO apec_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Aria okwokwik amakek Herodias kwakrip nugawik aria nugawik kwonak kwakrip Herot namudok, “Eik yakri nyak nyuwemi Jon nenek baptaisumesh iri ananig barag iruhw um anohw yaurehw aria nyugusah nyunaki nyukeyog.” ");
INSERT INTO apec_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Aria King Herot nemnek enyudok baraen aria ananish urkum apahw amamaenyish atish. Aria anan urkum morum dodogowinyi adurinyi baraen da nenekenyi aria anan nanoiwos um ta baraen nyonum eshudok shape shawok worigun shani anan iri um esheshis nabes. Namudok aria nakrip amam soldia um henekesh kabi da armatok kwakri um. ");
INSERT INTO apec_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Aria anan neshopok anan arman nanak gani shunuweshik-ati urupat um nukrip amam soldia um hurupogesh Jon ananin aruhwigur. ");
INSERT INTO apec_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Aria eshesh shurawi ananig barag getemi anohw yaurehw aria shako okwudok weroroikwi armatok aria okwok kurao barag konak um okwokwik amakek. ");
INSERT INTO apec_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Aria Jon ananim disaipel hanaki harao ananit mukut hotusah hanak harumot. Amam harom Jonit mukut jurug, aria hanak hakrip Jisas. ");
INSERT INTO apec_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Jisas nemnek baraen um douk eshesh shabo Jon nagok um, aria anan nakutukuk abrudok wabur aria narao anat bot aria nanak anabik da arpesh wokagunum. Douk anan nani ananish disaipel atin shanak. Aria sabaishi arpesh da shemnek baraen um Jisas da nanak um, aria eshesh shakutukuk esheshirub warub aria eshesh shagim yah shanak shaurim anan. ");
INSERT INTO apec_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Nabudok nyutob Jisas nanak natogur anagas-igum waiyag aria natik sabaishi arpesh apa shebeiman. Aria anan nenemesh giha abom um eshesh aria anan nataurumesh nagabe ihishmorim da arugeh hapeyesh iri. ");
INSERT INTO apec_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Aria wabigep amam disaipel hanamorim anan aria hakripan namudok, “Agnudok da arpesh wokagunum, aria hurukum ta aun nubuh. Nyak wosik ko nyushopok arpesh shunak esheshirub warub aria shutor worigun.” ");
INSERT INTO apec_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Aria Jisas nakrip ananim disaipel namudok, “Umum maresh ba eshesh ta shunak? Ipak kanak ta pukesh worigun ba shugnoh.” ");
INSERT INTO apec_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Aria amam disaipel hakrip anan namudok, “Apak da madae mubuk sabaiguni worigun agundok uwe, uwok. Apak da mobuk 5-poreig bretog aria biyoguhw eiguhw atish shakuh.” ");
INSERT INTO apec_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Aria Jisas nakri namudok, “Haraki agwudok bretog gwani eiguhw um eik.” ");
INSERT INTO apec_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Aria Jisas nakrip ihishmorim arpesh um shubuh shupe atap utoruh. Aria anan nohur agwudok 5-poreig bretog gwani agwuhwudok biyoguhw eiguhw aria anan nanig natik gani iruhw heven aria nenek beten aria nani Iruhin heyagwreh. Aria anan nawor agwudok bretog aria nakom disaipel. Aria amam disaipel hasia agwudok bretog um eshudok arpesh. ");
INSERT INTO apec_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Aria ihishmorim shawok worigun ba duguresh. Aria ihigun morim tutukwanigun worigun douk nakuhuk iri, amam disaipel ta hatorumogun haraguni aria hognuruk 12-poreiruh sararuh. ");
INSERT INTO apec_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Amudok armam douk hawok worigun iri shadareham hatogur 5,000-poreim. Aria armago wani batowish madae shudarehesh uwe, uwok. ");
INSERT INTO apec_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Aria arigas atin Jisas nakrip ananim disaipel um haprok huto bot aria hurik hunak gani wobrag waiyag. Aria anan kanak ta nupe ba neshopok eshudok arpesh shunak ba iyoh. ");
INSERT INTO apec_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Anan neshopokesh shanak shatuh aria anan atun nato gani iruhw anohw yoduhw um nikih nenek beten. Aria abudok nyutob aun da nabuh um da anan atun nape gani iruhw yoduhw. ");
INSERT INTO apec_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Atudok bot iganigadae tanak rougun abom aria uhwin nyaboi gani tarigum bot, aria abar beshiwok bot tanak tanaki. ");
INSERT INTO apec_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Aria huruhuruk um gugrukibus aria Jisas narahaen nanaki iruhigum waiyag aria nanaki natogurum amam disaipel. ");
INSERT INTO apec_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Aria amam hatik anan narahaen nanaki iruhigum waiyag aria amam hanogugur abom aria arugoguhwiar wam yowiyokuk. Aria amam hakri namudok, “Anudok douk enen sagab.” Aria amam hanogugur abom ba hohwar debeg. ");
INSERT INTO apec_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Aria arigas atin Jisas nakripam namudok, “Ipak pupe dodog. Enyudok douk eik atuwe. Ipak mare punogugur.” ");
INSERT INTO apec_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Aria Pita ta nakripan namudok, “Debeini, enyudok douk nyak atin um, aria nyak nyukrip eik aria eik ta irahaen inakugu iruhigum waiyag aria inamagu nyak nagundok.” ");
INSERT INTO apec_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Aria Jisas nakripan namudok, “Wosik nyak yowi.” Aria Pita nakitak nakutukuk bot aria narahaen iruhigum waiyag nanam Jisas. ");
INSERT INTO apec_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Aria anan natik enen uhwin dodogowin abom aria nanogugur aria pususuwaran nabuh youg. Namudok aria anan nahwar namudok, “Debeini, nyak nyutaurum eik.” ");
INSERT INTO apec_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Aria arigas atin Jisas nasuhw Pita ananis wis natukani. Aria Jisas nakrip anan namudok, “Nyak madae gamo nyenek bilip um eik uwe, uwok. Umum maresh ba nyak nyor biyep urkwip?” ");
INSERT INTO apec_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Aria amam haprok hato bot, aria uhwin nyagok nyabuh. ");
INSERT INTO apec_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Aria armam hape bot iri, amam henek lotu um Jisas aria hakri namudok, “Adur atin, nyak douk Iruhin Ananin Nuganin.” ");
INSERT INTO apec_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Aria Jisas nani ananim disaipel habrig waiyag hanak hatogur gani wabrehah anagas um Genesaret. ");
INSERT INTO apec_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Arpesh shape nagundok iri shatik Jisas aria shadukeman, aria shenek baraen nyunam ihirub warub bape huruhuruk iri, aria eshesh sharawi ihishmorim arugeh henekeshi um anan. ");
INSERT INTO apec_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Aria eshesh sharig Jisas debeg um ta nukri wosik aria eshudok arugeh henekeshi ta shususuhw anagas um ananih rupah. Aria ihishmorim shenekesh namudok iri ta shatogur yopish. ");
INSERT INTO apec_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Aria abudok nyutob anam Farisi hani amudok anam henek skulumesh um lo iri hape iri Jerusalem aria hanaki hatik Jisas. Aria harigan namudok, ");
INSERT INTO apec_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Umum maresh? Aria nyakim disaipel apa habrig lo seiwok apakim yamehem hakapenyi? Hawok worigun um, madae hukrup wis uwe aria ko huwok worigun.” ");
INSERT INTO apec_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Aria Jisas nakripam namudok, “Umum maresh aria ipak da apa pagipesh ipak kanak ipakin lo aria ipak pabrig Iruhin ananin lo? ");
INSERT INTO apec_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Umum maresh, Iruhin nakri namudok, ‘Ipak ta pupe shakamum ipakish amakek yaken aria pigipesh esheshin baraen’ aria ‘arpen da nyabubunim enyenyish amakek yaken iri enyen ta shen nyugok.’ ");
INSERT INTO apec_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Aria ipak da apa pakri namudok, ‘Douk enen arpen nyobuk anabor utobor um nyutaurum enyenyish amakek yaken, aria enyen nyukrip eshesh biyesh namudok, “Eik yagraeh eshudok um iko Iruhin,” ");
INSERT INTO apec_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","aria enyudok arpen ta mare nyere urkum um enyenyin yaken ba gamo nyutauruman uwe, uwok.’ Um ahudoki aih ipak da pabrig Iruhin ananin baraen aria pohur ipakim yamehem henekeshahi aih hato iruhw. ");
INSERT INTO apec_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Ipak da apa pape biyaruh aparuh iri! Profet Aisaia seiwok neyagwreh Iruhin ananin baraen, aria nenyemaguk adurinyi um ipak iri enyudok, ");
INSERT INTO apec_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Eshudok arpesh eshesh da apa shohur eikin nyeigur nyato gani iruhw um esheshig nukwatog atug um shunek lotu um eik aria esheshish urkum apahw shape rougunum um eik. ");
INSERT INTO apec_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Amam hadukemesh um henek skulumesh um arpeshin lo atin aria hakri namudok, “Enyudok Iruhin ananin baraen.” Namudok aria amam da henek lotu um eik meyoh.’” ");
INSERT INTO apec_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Aria Jisas nahwar ihish arpesh shanamorim anan aria nakripesh namudok, “Ipak pumnek aria gamo pudukemesh. ");
INSERT INTO apec_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Eneshenesh shawish enen arpen enyenyit nukwat iri, eshudok madae shenek enyudok arpen ba yowen nyubo sisih uwe, uwok. Aria eneshenesh da nukwat takriyeshi, eshudok atish da shenekesh aria enyudok arpen yowen nyabo sisih.” ");
INSERT INTO apec_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Aria anob nyutob banakuk aria amam disaipel hanaki hakrip Jisas namudok, “Nyak da nyadukemesh aka uwok? Amam Farisi hemnek enyudok nyakin baraen aria amamish urkum apahw yowesh.” ");
INSERT INTO apec_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Aria Jisas ta nakripam namudok, “Eikin Yaken nape heven iri, anan da nagrem anag nubarig. Aria ihish eneshenesh anan kanak madae nuwesh uwe, aria anan ko ta nurim ba nutukeshum aria ta nutuk nukwaruh hunuhapumesh. ");
INSERT INTO apec_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Ipak mare urkwip aparuh shur um amudok armamin baraen. Amam kabi da nabes seshuhomi um hakana hiyabig yah um kupaishi arpesh. Aria ta nabes seshuhomi hukana hiyabig yah um kupaishi nabes seshuheshi aria ta biobiom hunak hugurukuk nuwag.” ");
INSERT INTO apec_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Aria Pita narik Jisas namudok, “Eik yakri wosik um nyak ta nyuwereh baugenyum enyudok wobuwobrenyi baraen um eshudok shenek arpesh ba shabo sisih aria apak ta mumnek?” ");
INSERT INTO apec_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Aria Jisas nakri namudok, “Namudok ta mumam? Ipak shopunek madae pudukemesh uwe, aka? ");
INSERT INTO apec_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Aria ipak da madae pudukemesh uwe, uwok. Ihish eneshenesh shawish nukwat iri, eshudok shanak um numun nyibur wautem aria sharukegeshuk gani deiwog. ");
INSERT INTO apec_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Aria enenyenen baraen nyatogur apakig nukwatog enyi, enyudok baraen da nyatogur apakish urkum apahw aria peyagwrehen nyatograri. Aria enyudok baraen atin da nyenek apak arpesh amu yowep ba mabo sisih abom. Aria Iruhin natik apak nahwarap yoweishi arpesh. ");
INSERT INTO apec_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Eik yakripep, eshudoki eneshenesh da shatogur arpeshish urkum apahw um shapeyahi aih, eshudok eneshenesh douk eshudok. Yoweishi urkum apahw aria urkum shorum, shabo arpesh shagok um, shenek wehrur um, shabrig shanaraum um, shakwuaruh um, shegiyagigum kwotog um, shoruk nubug kupaishi um. ");
INSERT INTO apec_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Eshudoki yoweishi eneshenesh da shenek apak arpesh aria yowep ba amu mabo sisih abom um Iruhin ananis nabes. Aria arpesh da shawok worigun ba madae shukrup wis iri ahudoki aih da madae hunek arpesh ba amu yowesh shubo sisih abom uwe, uwok.” ");
INSERT INTO apec_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Aria Jisas nakutukuk abrudok wabur aria nanak gani warub Tair bani Saidon. ");
INSERT INTO apec_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Aria onok Kenanik armatok kwape nagundok iri, aria okwok kwanaki kwohwar namudok, “Debeini, nyak Devit Ananin Barhonin,nyak ko nyenek gihaum eik. Enen yoweinyi sagab nyanunu eikik nagawik ba amu kwabo sisih abom.” ");
INSERT INTO apec_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Aria Jisas madae ta nuwanamok baraen ba nukripok enen baraen uwe, uwok. Aria ananim disaipel hanamori anan aria hakripan namudok, “Okwudok armatok da apa kwohwar, kwohwar aria kwagipeshi apak kwanaki. Aria nyak kitak ba ta nyushopokok ba kunak.” ");
INSERT INTO apec_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Aria Jisas natanam nakripok namudok, “Iruhin neshopoki eik yanaki um eshesh Israel atish douk shape kabi da sipsipahos da shanotukuk iri.” ");
INSERT INTO apec_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Aria okwudok armatok kwanaki hurukum Jisas kwabuh kwoduk ohrubus aria kwohwido barag gabuh atap amnab aria kwakri namudok, “Debeini, eik yakri nyak nyutaurum eik.” ");
INSERT INTO apec_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Aria Jisas natanam nakripok namudok, “Namudok uwok um ta muhur batowishigun worigun aria muwashagun um nubag.” ");
INSERT INTO apec_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Aria okwudok armatok kwakri namudok, “Debeini, nyak nyakri adurin baraen. Aria nubag shopunek da gwohur tutukwaniguni worigun nagruki shukam um tebol um ogwogwin debeini iri.” ");
INSERT INTO apec_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Jisas nemnek enyudok baraen aria nakri namudok, “Nya, nyak douk nyenek bilip abom um eik. Namudok aria enyudok mugu nyak nyakri eik ta ineken um nyak iri aria douk eik yakri ta nyutogur um nyak.” Aria banabi abudok nyutob atub okwokwik nagawik ta kwatogur yopuk. ");
INSERT INTO apec_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Aria Jisas nakutukuk abrudok wabur aria anan douk nagim anagasigum Galilieg waiyag nanak. Aria nanak nato onohw yoduhw aria nape. ");
INSERT INTO apec_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Aria sabaishi arpesh shanamori anan. Aria eshesh sharauri eshudok yoweigasi aiyas sapeyeshi, nabes seshuheshi, bishiguh shakokutom eshi, nokwatog gweshukeshi aria sabaishi arpesh da arugeh hapeyeshi shopunek, aria sheshubuk hurukum Jisas ananigas aiyas. Aria anan nagabeyesh shatogur yopish. ");
INSERT INTO apec_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Aria eshudok arpesh shatik nokwatog gweshukeshi sheneyagwreh, bishiguh shakokutomeshi shatogur yopish, yoweigasi aiyas sapeyeshi sharahaen, nabes seshuheshi ta shatrugun, aria esheshish urkum apahw shakitak yowiyokuk. Aria eshesh shohur Iruhin douk eshesh Israel shenek lotuman iri ananin nyeigur nyato gani iruhw. ");
INSERT INTO apec_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Jisas nahwari ananim disaipel hanaki um anan, aria nakripam namudok, “Eik yenek gihaum eshudok arpesh. Eshesh shani eik mape bihotih nyumnegwih jurug aria eshesh worigun wokesh. Eik yanoiwos um eshesh ta nyurub besh ba ishopokesh shunak. Esheshis nabes ta sonatiyanih aria marubigos sesh ba ta shututu gani yah.” ");
INSERT INTO apec_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Aria amam disaipel hakripan namudok, “Agundok arpesh wokagunum. Apak ta murao sabaiti bret agunum ba ta mukesh atudok bret namudokishi sabaishi arpesh?” ");
INSERT INTO apec_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Aria Jisas nakri namudok, “Ipak douk pobuk makunig bretog gwakus?” Aria amam hakripan namudok, “Apak mabuk 7-poreig bretog gwakus aria atur atur shokuguhwi eiguhw shopunek.” ");
INSERT INTO apec_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Aria Jisas nakrip eshudok ihish arpesh um shupe atap amnab. ");
INSERT INTO apec_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Aria anan nohur agwudok 7-poreig bretog aria eiguhw, aria nenek beten aria nani Iruhin heyagwreh, aria anan nawor agwudok bretog aria nako ananim disaipel aria amam hasiagum eshudok arpesh. ");
INSERT INTO apec_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Aria ihishmorim shawok worigun ba dugaresh. Ihish tutukwanishi worigun shakuk iri douk amam ta hatorumesh ba heshuruk 7-poreiruh suraruh. ");
INSERT INTO apec_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Amudok armam douk hawok worigun iri shadareham hatogur 4,000-poreim. Aria armago wani batowish madae shudarehesh uwe, uwok. ");
INSERT INTO apec_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Jisas neshopok ihish arpesh shanak iyoh, aria anan naprok nato anat bot aria nanak gani anagum nahobig shahwaragum Magadan. ");
INSERT INTO apec_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Amam Farisi hani Sadyusi hanamorim Jisas aria amam hakana hukwiraeh anan. Aria amam hakrip anan um nenek enen Iruhin atun neneken iri mour. Umum maresh? Amam hakana hutik aria ta hukri adur atin anan douk Iruhin naganin da nanaki. ");
INSERT INTO apec_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Aria Jisas nakri namudok, “Wabigegwis ipak pakri, ‘Utag owishiborig atug. Yopubi nyutob ko butogur.’ ");
INSERT INTO apec_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Aria ruwahegwis ipak pakri, ‘Eshah ta harari. Umum maresh, utag iganigadae gatogur owishiborigi aria behrabigi. Namudok aria douk ta uhwin nyahur aria eshah harari.’ Adur atin, ipak patik enyudok kak um utag genekesh ahi aih aria gamo padukemesh um yoweibi aka yopubi nyutob ta butogur. Aria ipak douk madae gamo putik enen kak um pudukemesh um eneshenesh shatogur douk abudok nyutob iri. ");
INSERT INTO apec_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Eshesh arpesh um doukib nyutob ipak da yoweishi arpesh aria ipak madae pukon ipakish urkum apahw adur atin um Iruhin uwe, uwok. Ihib nyutob eshesh shahwar um shakana shutik enen Iruhin atun neneken iri mour. Aria eshesh ta mare shutik enyudok kak uwe, uwok. Aria atin enen kak Iruhin atun neneken iri mour ipak ko putrin iri, enyudok profet Jona ananin.” Aria Jisas nakutukuk eshesh aria nanak. ");
INSERT INTO apec_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Jisas nani ananim disaipel hanak hatogur gani wobrag waiyag, aria amam disaipel urkwip peshukomuk um hurauri anog bretog shopunek. ");
INSERT INTO apec_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Aria Jisas nakripam namudok, “Ipak ko gamo putrugun aria gamo pudukemesh um amam Farisi hani amam Sadyusi amamih yoweihi aih kabi douk yis um.” ");
INSERT INTO apec_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Aria amam disaipel apa heneyagwreh orokohun um amam kanak namudok, “Anan da neyagwreh enyudok baraen umum maresh? Apak da madae murauri anog bretog uwe, uwok.” ");
INSERT INTO apec_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Jisas nadukemesh um enyudok baraen amam hakriyenyi aria anan nakripam namudok, “Ipak madae punek bilip wosik um eik uwe, uwok. Umum maresh ba ipak apa pakri namudok, ‘Apak da bretog uwok?’ ");
INSERT INTO apec_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Ipak da madae gamo pudukemesh aka? Aria ipak da madae pudukemesh um agwudok 5-poreig bretog da 5,000-poreish arpesh shagwahi, aria makuriruh sararuh da ipak poruk tutukwaniguni worigunaruhi? ");
INSERT INTO apec_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Aria ipak da madae pudukemesh um agwudok 7-poreig bretog da 4,000-poreish arpesh shagwahi aria makuriruh sararuh da ipak poruk tutukwaniguni worigun aruhi? ");
INSERT INTO apec_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Umum maresh ba ipak madae pudukemesh namudok, eik madae urkum murum bret aria eik yekep baraen ipak? Eik yakri, ipak ta gamo pudukemesh um amudok Farisi hani Sadyusi amamis yis.” ");
INSERT INTO apec_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Amam hemnek enyudok baraen aria amam hadukemesh namudok, anan madae niyagwreh um amam ta gamo hudukemesh um yis shenek bretasi uwe, uwok. Anan da neyagwreh um amam ta gamo hudukemesh um Farisi hani Sadyusi amamih yoweihi aih aria amamin baraen. ");
INSERT INTO apec_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Jisas nanak um wabur gani Sisaria Filipai aria um abudok nyutob aria anan narik ananim disaipel namudok, “Eshesh ihish arpesh eshesh da apa shakriyen shakana Anudok Arman natogur adurinyi arpen iri douk amiapen?” ");
INSERT INTO apec_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Aria amam hakri namudok, “Enesh shakana, nyak da Jon nenek baptaisumesh iri. Aria enesh shakana, nyak da Elaija. Aria enesh shakana, nyak da Jeremaia aka, anan profet.” ");
INSERT INTO apec_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Aria Jisas narik amam namudok, “Aria ipak kanak pakana eik da amiapen?” ");
INSERT INTO apec_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Aria Saimon Pita nawanam baraen namudok, “Nyak douk anudok arman Iruhin nubokadae nagraehenyum nyunaki ta nyurao ihishmorim ananish arpesh shutanamori. Nyak douk anudok arman Iruhin douk madae nugok iri uwe ananin naganin.” ");
INSERT INTO apec_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Aria Jisas nakrip anan namudok, “Saimon Jon ananin naganin, nyak ko nyunadudareh. Umum maresh? Madae enen abudok amnabin arpen da nyeyabigen enyudok baraen um nyak uwe, uwok. Eikin Yaken douk nape heven iri anan atun neyabigen enyudok um nyak. ");
INSERT INTO apec_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Aria eik yakrip nyak namudok. Nyak douk Pita, aria eik ta irok eikit arpesh shenek lotuati urupattiyotu dodog iruhw um amudok utom. Aria enyudok gokin dodog ta mare nyununut uwe, uwok. ");
INSERT INTO apec_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Aria eik ta douk iken eshudok kihas um nyak um arpesh shuwish aburdok wabur heven Iruhin nape Debeini um ananish arpesh um. Aria maresh nyak nyutapesh um abudok amnab, aria anan Iruhin ta nutapesh gani iruhw heven shopunek. Aria maresh nyak nyukweshihesh abudok amnab, aria anan Iruhin ta nukweshihesh gani iruhw heven shopunek.” ");
INSERT INTO apec_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Aria Jisas namumup ananim disaipel dodog abom um amam mare hukrip enen arpen um anan kanak douk anudok arman Iruhin nagraehan aria neshopokan nanaki iri. ");
INSERT INTO apec_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Aria abudok nyutob Jisas apa nakrip amam disaipel namudok anan ta nunam Jerusalem aria anan ta nurao sabairi eriger um amam Juda esheshim debeimi huni amam douk henek skulumesh um lo iri aria debeimi pris. Aria ta shon nugok, aria bihotih nyumneh hunak hunakuk aria anan ko ta nukitak nupe. ");
INSERT INTO apec_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Aria Pita nemnek enyudok baraen aria narao Jisas nanak anagas aria apa nahan nakri namudok, “Debeini, namudok ta uwok. Eshudok eneshenesh ta mare shutogurum nyak.” ");
INSERT INTO apec_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Aria Jisas natanam nakrip Pita namudok, “Satan, nyak yowi kareiguk eikib agab. Nyak nyakana nyutapok eikih yah. Nyak madae nyigipesh Iruhin ananim urkum apahw uwe, uwok. Nyak douk nyagipesh arpesh esheshish urkum apahw atish iri.” ");
INSERT INTO apec_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Aria Jisas nakrip ananim disaipel namudok, “Meishi arpesh douk shakana shigipesh eik um, aria eshesh ta shubukuk ihishmorim eneshenesh esheshish urkum apahw shakriyeshi aria shusah esheshin rowogin kruse aria ta shugipesh eik. ");
INSERT INTO apec_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Umum maresh? Douk meishi arpesh shakana shagabe eshesh kanak aria eshesh ta shunanunu shuwishuk. Aria ta meishi arpesh esheshish urkum apahw shurum eik iri aria eshesh ta mare shugok uwe, uwok. Eshesh ta shupe. ");
INSERT INTO apec_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Aria douk enesh arpesh shurao ihish abudok amnabish eneshenesh aria eshesh kanak ta shunanunu shuwishuk, aria eshudok ihish eneshenesh ta shutaurum eshesh mumam? Namudok ta uwok. Aria eshudok arpesh ta shuko maresh eshudok ba ta shutor eshesh kanak esheshiruh yegeshiweruh? ");
INSERT INTO apec_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Aria Eik Anudok Arman yatogur adurinyi arpen iri ko ipeum eikin Yaken ananit debeiti lait tuni ananin dodog aria eik ta inaki ini eikish enselahos. Aria um abudok nyutob eik ta ikesh yopishi eneshenesh ihishmorim atin atin arpesh um kabi da shapeum maresh yoweishi aria yopishi eneshenesh da shenekesh abudok amnab iri. ");
INSERT INTO apec_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Eik yakri adurin baraen um ipak, enesh arpesh shetu agundok iri ko mare shugok aria ta shutik Eik Anudok Arman yatogur adurinyi arpen iri inaki kabi da anan king um.” ");
INSERT INTO apec_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Aria 6-poreih nyumneh hanak hunakuk, aria Jisas narao Pita, Jems nani waninuman Jon, aria naram hato onohw rouhwi hwato abom iri yoduhw. Aria amam atum hape nagundok. ");
INSERT INTO apec_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Aria amam hape apa hatik aria Jisas ananihw yegenyihw hwakabadig ba natogur anahaeh. Aria ananig yomag gatogur kabi da nyumnahin aun morim, aria ananih rupeh hatogur mamokihw shigorihw abom kabi da anat debeiti lait morim. ");
INSERT INTO apec_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Aria Moses nani Elaija amam hatogur aria amam disaipel hatik Jisas nani amam biom apa heyagwreh. ");
INSERT INTO apec_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Pita natik enyudok mugu aria nakrip Jisas namudok, “Debeini, enyudok wosik um apak douk mupe agnudok. Nyak nyukri um, aria eik ko irok bisotup ourogwis. Anap nyakip, anap Moses ananip aria anap Elaija ananip.” ");
INSERT INTO apec_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Pita wata apa neyagwreh aria anat utogit arut tenek lait abom iri tabuhi teyawiyam. Aria anah mah hatograri atudok arut hakri namudok, “Anudok Eik kanak Eikin Nuganin. Eik yakri yanawasham anan aria yanadudareh um anan abom. Aria ipak ta ko pumnek ananin baraen.” ");
INSERT INTO apec_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Amam disaipel hemnek enyudok baraen, aria amam habuh atap amnab hoduk ohrubus aria hawido baragos sabuh amnab, aria amam hanogugur abom. ");
INSERT INTO apec_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Aria Jisas nanak hurukum amam aria nasusuom aria nakri namudok, “Ipak kitak aria ipak mare punogugur.” ");
INSERT INTO apec_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Aria amam hanig hatik iruhw, aria amam madae hutik enen kupainyi arpen uwe, uwok. Aria amam hatik Jisas atun. ");
INSERT INTO apec_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Aria amam hakutukuk ahwudok yoduhw aria amam apa habuh yah, aria Jisas nakripam dodog namudok, “Eshudok muguhwos ipak da patrishi, ipak ta mare pukrip enen arpen uwe, uwok, arigaha kweipon nohumu nyumnah Eik Anudok Arman douk yatogur adurin arman iri ko ikutukuk wonugwehw ba ta ikitak ipeum agundok shagok um.” ");
INSERT INTO apec_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Aria amam disaipel harigan namudok, “Umum maresh ba amudok henek skulumesh um lo iri apa hakri namudok um Elaija ta nurik nunaki?” ");
INSERT INTO apec_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Aria Jisas nakri namudok, “Enyudok baraen douk adurin. Elaija ta natanamori ba nagabe ihishmorim eneshenesh. ");
INSERT INTO apec_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Aria eik yakrip ipak namudok, Elaija nubokadae nanaki, aria armam armago madae shudukeman uwe, uwok. Eshesh shagipesh eshesh kanak esheship urkwip aria shenekesh yowiyokuk um anan. Aria um ahudok atuh aih eshesh ta shenekesh yowiyokuk um Eik Anudok Arman douk yatogur adurinyi arpen iri.” ");
INSERT INTO apec_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Jisas nakri namudok, aria amam disaipel hadukemesh namudok, anan douk nakri Jon nenek baptaisumesh iri. ");
INSERT INTO apec_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Jisas nani bimatun disaipel hanak hatogrum sabaishi arpesh, aria anan arman nanamorim Jisas aria noduk ohrubus um anan. ");
INSERT INTO apec_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","Aria nakripan namudok, “Debeini, eik yakri nyak nyenek gihaum eikin armanin batowin. Anan nagugak um aria ananihw yegenyihw hwanak hwatogur hwape yowiyokuk abom. Aria sabaihi anan natu nawish nyih, aria sabaihi anan natu nawish abar. ");
INSERT INTO apec_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Aria eik yaran morim nyakim disaipel, aria amam madae hugabeyan ba nutogur yopun uwe, uwok.” ");
INSERT INTO apec_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Aria Jisas nakripan namudok, “Ipak douk eshudok arpesh da madae penek bilip iri, ipakish urkum aparuh baragos aria ipak penekahi aih douk madae wosik uwe, uwok. Aria makurib nyutob shopunek eik ta ini ipak mupe? Aria makurib nyutob shopunek eik ta isah ipakin amain? Haraki enyudok armanin batowin agnudok um eik.” ");
INSERT INTO apec_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Aria Jisas naho enyudok yoweinyi sagab, aria enyudok yoweinyi sagab nyakutukuk anudok batowinyin aria atub nyutob ananih arugeh hatuh. ");
INSERT INTO apec_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Aria bagiguki nyutob disaipel atum hanamori Jisas aria harigan namudok, “Umum maresh ba apak douk madae muhiyahuk enyudok yoweinyi sagab?” ");
INSERT INTO apec_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Aria anan nakripam namudok, “Ipakin bilip douk shokwin abom, namudok aria ipak ta mare penekesh namudok uwe, uwok. Eik yakripep adurin baraen, ipak douk pene bilip kabi da anam shokumi rowogim mastetim shurkum, aria ipak ta wosik pukrip ahwudok yoduhw, ‘Nyak kitak ba kare ganudok, aria ohwohw ta hwukitak hwunak. Aria adur atin eshudok ihish ipak ta penekesh.’  ");
INSERT INTO apec_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Ipak pukuna penekesh namudok um, aria ipak ta penek beten pushakur um worigun aria ipak ta wosik ko puhiyah eshudoki eneshenesh.” ");
INSERT INTO apec_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","23","Abudok nyutob Jisas nani ananim disaipel hantorum gani anab debeibi amnab Galili aria Jisas nakripam namudok, “Eshesh ko shuko Eik Anudok Arman douk yatogur adurinyi arpen iri um anam armam amamis wis. Aria amam ko he igok. Aria bihatuh nyumneh hutuh aria eik ta ikitak.” Amam disaipel hemnek enyudok baraen aria amamish urkum apahw yowesh abom. ");
INSERT INTO apec_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Jisas nani ananim disaipel hanak hatogur wabur Kaperneam, aria armam harao takis um Iruhin ananit debeiti urupat iri hanamori Pita aria harigan namudok, “Ipakin tisa nobuk utabor um Iruhin ananit debeiti urupat aka, uwok?” ");
INSERT INTO apec_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Aria Pita nakri namudok, “Wosik anan shopunek nenek takis nabuk utabor.” Aria Pita nawish urupat, aria Pita watak niyagwreh uwe, aria Jisas narigan namudok, “Saimon, nyakim urkum mor mumam? Anam king um agudok nahobig amam da hurao utabor um kupakupaisi takis um amiapen? Amam da harao takis um amam kanak amamish wanaruh, aka um kupaishi armam armago?” ");
INSERT INTO apec_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Aria Pita nakri namudok, “Um eshesh kupakupaishi arpesh.” Aria Jisas nakripan namudok, “Namudok aria amam kanak amamish wanaruh ta mare shenek takis. ");
INSERT INTO apec_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Aria apak mare menek amamirub nyirub yowerub um apak. Nyak kare gani waiyag ba nyuwashak nyumabur. Aria rarig iri eyur nyak nyanukor iri, nyak nyusuar ba nyupok nukwatirum eyur aria nyak ta nyutik anam utom mur numun nukwat. Nyak nyutuk amudok utom aria nyunak nyuko amudok armam um nyutor ohwak biohw ohwakis takis.” ");
INSERT INTO apec_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Abudok nyutob amam disaipel hanamorim Jisas aria harigan namudok, “Amiapen ta nyurao debeinyi nyeigur um agundok Iruhin nape Debeini um ananish arpesh shapeum heven?” ");
INSERT INTO apec_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Aria Jisas nahwari enen batowin nyanaki aria nyetu orokohun um amam. ");
INSERT INTO apec_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Aria nakripam namudok, “Eik yakripep adurin baraen, ipak nubo douk mare pubukuk eshudok ipakish yoweishi urkum apahw shape ba shorahi aih, aria ipak ta mare putogur kabi da enyudok shokwinyi batowin um, aria ipak ta mare puwish agundok Iruhin nape Debeini um ananish arpesh shapeum heven uwe, uwok. ");
INSERT INTO apec_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Meishi arpesh douk shupe kabi da enyudok batowin um, aria shubukuk esheshish yoweishi urkum apahw shape ba shorahi aih, sheshagrakuk enesh arpesh aria eshesh douk ta shurao debeinyi nyeigur abom um agundok Iruhin nape Debeini um ananish arpesh shapeum heven. ");
INSERT INTO apec_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Aria douk meishi arpesh urkwip purum eik aria shataurum enen shokwinyi batowin kabi da enyudok batowin um, aria eshesh da shataurum eik.” ");
INSERT INTO apec_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Aria Jisas ta nakri namudok, “Douk meinyi arpen nyenekesh ba enen um eshudok shokwishi batowish da nyenek bilip um eik iri nyugrukmori nyenek yoweishi inahos aria enyudok arpen nyenekesh namudok iri douk enesh arpesh ko shuweshik anam debeimi utom um enyudok arpen enyenyin aruhwigur aria shuwashen nyubuh gani atapigum youg aria nyugok. ");
INSERT INTO apec_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Eik yakri debeinyi gihaum agudok nahobigish arpesh, eshesh apa shenekesh um kupaishi arpesh ba shagruk-morim shenek yoweishi inahos. Adur um eshudok yoweishi inahos ta shutogur. Aria eik yenek giha abom um eshudok douk shenek eshudok yoweishi inahos ba shutogur iri. ");
INSERT INTO apec_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Namudok aria nubo ipakish roguhw aiyas shonukep um penek yoweishi inahos um, aria ipak putupesh ba puwasheshuk. Namudok wosik um ipak da atin rogur aria atug aiyag shupeumep aria puwishum yopinyi poe aria pupe wosik ihih nyumneh. Aria ta ipak ko biobiyesh roguhw aiyas shupeyep aria ta shuwashep puwish um ehudok yoweihi nyih madae hugok iri uwe, uwok. ");
INSERT INTO apec_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Aria douk ipakis nabes seneken um penek yoweishi inahos aria ipak tuk anap nabep ba puwashopuk. Namudok wosik um ipak da atup nabep pupeyep aria puwish um yopinyi poe aria pupe wosik ihih nyumneh. Aria ta ipak ko biyos nabes supeyep aria ta shuwashep puwish um yoweiburi wabur hel ehudok yoweihi nyih madae hugok iri uwe, uwok. ");
INSERT INTO apec_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Ipak ko gamo pudukemesh namudok. Ipak ta mare pukuna enen batowin orokohun um eshudok batowish da yoweishigom uwe, uwok. Eik yakrip ipak um gani heven esheshish enselahos, ihib nyutob ta sheyatu um eikin Yaken ananig yomag da nape gani heven iri.  ");
INSERT INTO apec_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Umum maresh? Eik douk Anudok Arman yatogur adurinyi arpen iri yanamori yataurum eshudok arpesh douk shanak shawishukuk iri.” ");
INSERT INTO apec_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Aria Jisas ta nakri namudok, “Douk ta anan arman nagrem 100-poreish sipsipahos aria atin enen nyunak nyuwishuk, aria ipak pakri anan ta nenekesh mumam? Anan ta nunak nurimen aka, uwok? Adur atin eik yakripep, anan ta nukutukuk eshudok enesh 99-poreish shiyatukuk anag mihig aria anan ta nutanam nanak nurim enyudok atin da nyanak nyawishuk iri. ");
INSERT INTO apec_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Eik yakripep adurin baraen, anan ta nanak ba nuparug enyudok sipsip ba jurug, aria anan ta nunadudareh abom. Anan nanadudareh um eshudok 99-poreish sipsipahos madae shunatukuk iri, aria anan ta naparug enyudok atin arag da nyawishuk iri, aria anan ta amu nunadudareh abom. ");
INSERT INTO apec_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Aria douk namudok atin um ipakin Yaken nape heven iri anan da nanoiwos um enen um eshudok shokwishi batowish ko shuwishuk uwe, uwok.” ");
INSERT INTO apec_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Aria Jisas nakri namudok, “Aria douk anan nyakin wanin nenek yoweishi inahos um nyak, aria nyak nyunak ba nyutik anan, aria ta ipak atip pupeum, aria nyak nyukwiraeh um nyugabe baraen nyuni anan. Aria anan ta nemnek nyakin baraen um, aria nyak douk nyagabeyan nyaran natanamori um nyak. ");
INSERT INTO apec_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Aria anan da madae nemnek nyakin baraen um, aria nyak nyurao enen aka biyesh arpesh shiren shunak. Namudok aria ta biyesh aka bishatin arpesh um ta shenek enyudok baraen nyutogur dodogeshin.” ");
INSERT INTO apec_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Aria anan ta mare nukana nemnek esheshin baraen um, aria nyak nyunak nyukrip eshesh Iruhin ananish arpesh. Aria anan ta nukuna nunoiwos um nemnek esheshin baraen shopunek, aria nyak ta nyutik anan da kabi eshudok madae shumnek Iruhin ananin baraen iri aria kabi da amudok yoweimi armam harao takis iri. ");
INSERT INTO apec_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Aria eik yakripep adurin baraen, ihishmorim eneshenesh ipak pakri ta patapesh um abudok amnab iri, eshudoki ta Iruhin shopunek natapesh um gani iruhw heven. Aria ihishmorim eneshenesh ipak pakri pukweshihesh um abudok amnab iri, eshudok ta Iruhin shopunek ta nukweshihesh um gani iruhw heven. ");
INSERT INTO apec_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Aria eik yakri dodog um ipak namudok. Douk ipak biyep abudok amnabip putogur atish urkum apahw um enesh muguhwos aria penek beten um eshudok muguhwos, aria eikin Yaken nape gani iruhw heven iri anan ta nokep enyudok mugu um ipak. ");
INSERT INTO apec_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Aria douk biyesh aka bishatin shuntorum um eikin nyeigur, aria eik kanak ta ipe orokohun um eshesh.” ");
INSERT INTO apec_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Um abudok nyutob Pita nanamorim Jisas aria narigan namudok, “Debeini, nubokadae eikin wanin ta nenek yoweishi inahos um eik makurib nyutob, aria eik ta ikweshihuk ananish yoweishi inahos makurib nyutob? Eik ta ikweshihesh-ukuk 7-poreib nyutob, aka?” ");
INSERT INTO apec_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Aria Jisas nakripan namudok, “Eik douk madae ikrip nyak um ta nyukweshihuk yoweishi inahos 7-poreib nyutob uwe, uwok. Eik yakri nyak ta nyukweshihuk eshudok yoweishi inahos sabaihi um hutogur 490-poreib nyutob. ");
INSERT INTO apec_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“Nyak nyumnek. Arpesh shuwish agundok Iruhin nape Debeini um ananish arpesh shapeum heven douk kabi anan king nenekesh um. Anan nakri um ananim heneman mour iri ta hanaki aria hubeiman tukwanibor utabor huni anan. ");
INSERT INTO apec_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Aria anan douk napeum nenek mour um norig amudok, aria amam harawi anan arman nanaki um king, anan nubokadae rig nurao sabaibori utabor um king batogur um 10 milionibor utabor. ");
INSERT INTO apec_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Aria anudok arman utabor uwok um ta noko king. Namudok aria king nakripesh um ta shunak shukrip kupaishi um shutor anudok nini ananish armatok batowish aria ta shutogur kabi da shenek mour meyoh um kupaimi armam. Aria ihish ananish eneshenesh eshesh ko shutorish aria utabor ta bunam king. ");
INSERT INTO apec_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Aria anudok nenek mour meyoh um king iri nemnek enyudok baraen aria nabuh noduk ohrubus hurukum king ananiruh yeriweruh aria nakripan namudok, ‘Nyak ko nyenek gihaum eik ba nyiyatume. Eik ta ko itanam ibeimen ihibormorim utabor nubo nyekeyebor iri.’ ");
INSERT INTO apec_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Aria anudok arman ananin debeini nenek gihaum anan aria nokweshihuk anan aria nakana utabor bugokuk. ");
INSERT INTO apec_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Aria anudok arman nenek mour meyoh um king iri natogur nanak aria natik anan da henek mour atugun iri. Anudok anan da 10-porein kina atin ta nyape madae nuwanaman abrudok utabor uwe, uwok. Aria anan nasuhw ananin aruhwigur dodog, aria nakripan namudok, ‘Nyak ta nyutanam nyubeime iri ihibor utabor nyak nyarabor um eik iri.’ ");
INSERT INTO apec_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","“Anudok nenek mour atugun iri nemnek enyudok baraen aria nabuh noduk ohrubus aria nakrip anudok arman namudok, ‘Nyak ko ta nyenek gihaum eik aria nyiyatume. Aria eik ta ko itanam ikenyugu ihibor um eik nubo yatrin ba nyukeyobor iri.’ ");
INSERT INTO apec_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","“Aria anudok arman madae numnek baraen uwe, uwok. Amu nanoiwos abom. Aria nanak noweshik anudok nenek mour atugun iri um nupe arigaha nuwanaman utabor aria ta jurug. ");
INSERT INTO apec_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","“Amam kupaimi da hani anudok henek mour atugun iri hatik anudok nenekesh namudok aria amamish urkum apahw yowesh abom. Aria amam hanak hakrip amamin debeini um ihihmorim ahudok yoweihi aih anudok nenek mourum debeini da nenekeshum. ");
INSERT INTO apec_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Namudok aria anudok debeini nohwari anudok neneman mour iri aria nakripan namudok, ‘Nyak douk yowenyari nyenek mour um eik iri. Iganigadae riguk nyanaki nyereh um eik, aria eik yakweshihuk ihin baraen um eikibor utabor nubo bakus um nyak iri eik yakana ta bugokuk namudok. ");
INSERT INTO apec_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Eik yenek gihaum nyak. Namudok aria umum maresh ba nyak madae nyunek giha shopunek um anudok nani nyak penek mour atugun iri?’ ");
INSERT INTO apec_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Aria anudok ananin debeini ananish urkum apahw juwehosish abom aria nakrip amudok soldia hanaki huran hunak gani shunuweshik-ati urupat um nurao debeiri eriger arigaha nutanam nukon ihibor utabor nubo king nukonabor iri arigaha niyatabor aria jurug. ");
INSERT INTO apec_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","“Namudok atin eikin yaken da nape iruhw heven iri, anan ta nenekesh apunih aih um ipak da madae adur atin pukweshihuk yoweishi inahos um anam owarhim da henekesh um ipak iri uwe, uwok.” ");
INSERT INTO apec_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Jisas nakripesh enyudok ihin baraen ba nyatuh, aria anan nakutukuk agudok shokugi nahobig Galili aria nani ananim disaipel hanak gani gagadok anag shokugi nahobig Judia um gani wobrab worub Jordan. ");
INSERT INTO apec_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Aria sabaishi arpesh shagipesh anan. Aria um nagundok anan nagabe esheshih ihih arugeh da hapeyeshi. ");
INSERT INTO apec_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Aria anam Farisi hanamori Jisas aria hakana hukwiraeh anan um nukri enen baraen madae yopin uwe iri. Aria amam harigan namudok, “Apakin lo da wosik nyakrium anan arman ta wosik neyatakuk ananik irohukwik um enen hwarohwin baraen meyoh aka, uwok?” ");
INSERT INTO apec_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Aria Jisas nabeimam baraen namudok, “Ipak nubo patik baraen nyetem Iruhin ananik buk aka, uwok? Enyudok baraen nyakri namudok, ‘Seiwok seiwok Iruhin nokwarum ihish eneshenesh um aria nenek arpesh shopunek aria nenekesh shatogur arman armatok.’ ");
INSERT INTO apec_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Aria Iruhin nakri namudok, ‘Namudok aria douk arman ta nukutukuk ananish amakenyish aria nunak nunakurop nini ananik armatok shupe aria eshesh biyesh ta shutogur atuhw yegenyihw. ");
INSERT INTO apec_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Iruhin nakri namudok aria eshesh biyesh da madae shupe tukwotukwan uwe, uwok. Eshesh douk shatogur atuhw yegenyihw. Namudok aria eneshenesh Iruhin nadruneshi, eshudoki douk anan arman ko mare nubrigesh uwe. Amu wouwokuk abom.’” ");
INSERT INTO apec_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Aria amam Farisi hakripan namudok, “Namudok aria umum maresh, ba Moses nakop enen lo apak aria nakri namudok, anan arman ta wosik nenek anap shup um nubrig agundok da arman armatok shanaraum um aria niyatok ananik irohukwik ba kunakuk?” ");
INSERT INTO apec_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Aria Jisas nakripam nabeimam baraen namudok, “Ipak baragos seshukep aria madae pumnek baraen iri. Namudok aria Moses nakri wosik um ipak piyatakuk ipakiyu irorihiyeu. Aria seiwok seiwok Iruhin nakwaram eneshenesh obi, namudok madae shenekesh uwe, uwok. ");
INSERT INTO apec_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Eik yakripep namudok. Douk meini arman ananik irohukwik madae kuni anan kupainari arman shenek wehrur uwe, aria anudok arman neyatokuk aria nurao kupaikwi armatok, aria douk anudok arman anan kanak nenek yoweishi inahos um nani okwudok armatok shenek wehrur.” ");
INSERT INTO apec_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Amam disaipel hemnek enyudok baraen aria hakrip Jisas namudok, “Aria douk armam hugipesh ahudoki aih aria ba huni amamiyu irorihiyeu shupe atugun akure, aria enyudok meyoh um amudok armam mare ta hurao armago uwe aka, uwok.” ");
INSERT INTO apec_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Aria Jisas nakrip ananim disaipel namudok, “Enyudok baraen ihishmorim ta mare shigipeshen uwe, uwok. Iruhin nukesh dodog um enesh arpesh atish um, ta shugipeshen. ");
INSERT INTO apec_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Aria ipak gamo pumnek. Sabaimi armam da hape ba madae hurao armago uwe, uwok. Anam, nubo hanakwarum um amamiruh yegeshiweruh yoweruh aria ta mare hubuki batowish uwe, uwok. Aria anam nubo shatupok amamiruh yegeshiweruh aria ta mare hubuki batowish uwe, uwok. Aria anam amamip urkwip aparuh shor um hunek enyudok Iruhin ananin mour um hukrip arpesh shuwish agundok Iruhin nape Debeini um ananish arpesh shapeum heven. Namudok aria amam hakri uwok um hurao armago, hape meyoh. Aria meini arman douk wosik um nukuna numnek enyudok baraen, aria anan ta wosik gamo numnek.” ");
INSERT INTO apec_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Um abudok nyutob eshesh arpesh sharawi enesh shokwishi batowish shanamori Jisas. Eshesh shakana ta anan nuwem ananis wis iruhwishum ba nenemesh beten. Aria amam disaipel hahao eshudok arpesh. ");
INSERT INTO apec_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Aria Jisas nakrip ananim disaipel namudok, “Ipak kutishuk batowish ba shanamorim eik. Umum maresh? Meishi arpesh douk shutogur kabi da eshudok shokwishi batowishum, aria shigipesh eikin baraen shenek yopihi aih iri, eshesh wosik ta shuwish agundok Iruhin nape Debeini um ananish arpesh shapeum heven.” ");
INSERT INTO apec_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Aria anan nowem ananis wis iruhwishum batowish aria nakutukuk agundok ba nanak. ");
INSERT INTO apec_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Aria anan worogwiruhin arman nanamori Jisas aria nakri namudok, “Tisa, eik ta inek maresh yopishi eneshenesh aria yopihi aih aria ta iwish um yopinyi poe aria ipe wosik ihih nyumneh?” ");
INSERT INTO apec_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Aria Jisas nakripan namudok, “Umum maresh ba nyak nyarige um yopishi eneshenesh shani yopihi aih? Iruhin atun douk anan yopuni. Nyak nyakana nyuwish um yopinyi poe nyupe wosik ihih nyumneh, aria nyak douk nyigipesh Iruhin ananin lo da nyetem ananik buk iri.” ");
INSERT INTO apec_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Aria anudok arman narik Jisas namudok, “Nyak douk nyakri meinyi lo?” Aria Jisas nakri namudok, “Baraen nyetem um enyudok lo namudok, ‘Ipak mare pubo kupaishi arpesh shugok. Ipak punaraum iri, ipak mare punak puni kupaiwari armago penek wehrur. Ipak mare pukwaruh. Ipak mare pugiyagig ba penek kwot meyoh um kupaishi armam armatok. ");
INSERT INTO apec_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Ipak pumnek ipakish amakenyish esheshin baraen pigipeshen. Aria ipak pukri punuwasham ihish arpesh kabi da pakri panawasham ipak kanak morim.’” ");
INSERT INTO apec_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Aria anudok worogwiruhin arman nakrip Jisas namudok, “Eik douk yagipesh enyudok ihinyumorim lo yeyaten. Aria douk maresh yopishi eneshenesh maroh yopihi aih da ta shape douk eik watak inekesh uwe?” ");
INSERT INTO apec_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Aria Jisas nakripan namudok, “Douk nyak nyakana nyutogur yopuyopunyi arpen um, aria nyak kare ba nyuhur nyakih sabaihi jah aria nyuko kupaishi shutoruh. Shutoruh jurug shuken utabor aria nyunak nyisiyabor um arpesh douk eneshenesh wokeshi. Nyak nyenekesh namudok, aria nyak ta nyurao yopiyopishi eneshenesh gani iruhw heven. Aria nyak nyunaki ba nyigipesh eik.” ");
INSERT INTO apec_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Aria anudok worogwiruhin arman nemnek enyudok baraen aria ananish urkum apahw yowesh abom aria nanak. Umum maresh, anan douk nagrem sabaishi eneshenesh. ");
INSERT INTO apec_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Aria Jisas nakrip ananim disaipel namudok, “Eik yakripep adurin baraen amudok douk hagrem sabaibori utabor buni jah iri ta henek debeinyi mour um huwish aburdok wabur Iruhin nape Debeini um ananish arpesh shapeum heven. ");
INSERT INTO apec_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Aria eik ta ikripep shopunek, enen takweinyi mahin shahwaren um kamel iri nyukuna nyuwish nyilihw umunihw douk shanuk shokuburi nyumabur ba shutape jah ohwi umunihw, enyudok mare debeinyi mour abom uwe, uwok. Aria nubo meishi arpesh shogrem sabaibori utabor bani jah iri shukri shukuna shuwish heven agundok Iruhin nape Debeini um ananish arpesh shapeum, enyudok debeinyi mour abom.” ");
INSERT INTO apec_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Aria amam disaipel hemnek enyudok baraen aria hakitak yowiyokuk abom. Aria hakri namudok, “Um namudok, aria meishi ta shurao enyudok yopiyopinyi poe aria shupe wosik ihih nyumneh?” ");
INSERT INTO apec_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Aria Jisas ananis nabes duk atin natrum dodog aria nakri namudok, “Abudok amnabish arpesh shakwiraeh ba shatik uwok. Aria Iruhin ta wosik dodogowin um nenek ihish eneshenesh.” ");
INSERT INTO apec_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Jisas nakri namudok, aria Pita nawanam baraen aria nakripan namudok, “Nyak nyutik. Apak mabukuk ihish apakish eneshenesh aria magipesh nyak. Aria apak ta murao maresh eneshenesh?” ");
INSERT INTO apec_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Aria Jisas nakripam namudok, “Eik yakripep adurin baraen, um abudok nyutob ko ihish eneshenesh ta shutogur namushi atish shupe wosik um, aria Eik Anudok Arman yatogur adurin arpen iri ta itogur dodogoiwe irao debeinyi nyeigur um heven aria eik ikih ipe eikin kingin wagitur. Abudok nyutob ipak douk pagipesh eik iri ipak shopunek ta pupe iruhw 12-poreish yopishi wagiturahos aria pusuhw merik panuhwaram takwiyem um Israelis 12-poreis awiros. ");
INSERT INTO apec_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Aria ihishmorim arpesh nubo urkwip aparuh shor um eikin nyeigur iri aria shakutukuk esheshig urusag, owarhim, mohwiyariyu, amakek, yaken, nugashish aria nubarig eshesh ta shurao 100-poreish eneshenesh shuni arpesh shopunek um mour eshesh sheneken iri, aria eshesh ta shurao enyudok yopiyopinyi poe aria shupe wosik ihih nyumneh. ");
INSERT INTO apec_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Aria sabaishi douk shape sharigiri debeishi nyeiguhw shapeyeshi eshesh ko shunak shupe shigiguk. Aria sabaishi douk shape shagiguk iri, eshesh ko shunak shupe shurik.” ");
INSERT INTO apec_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Aria Jisas ta nakri namudok, “Arpesh shuwish agundok Iruhin nape debeinari um ananish arpesh shapeum heven douk kabi anan arman da nagrem anag nubarig aria nau wain agari. Aria ruwahep wehip anan nanak narawi amudok ta heneman mour um ananig wainig nubarig iri. ");
INSERT INTO apec_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Amudok ta henek mour iri hakri wosik um hurao atin atin kina um ahudok atuh nyumnah aria anudok debeini neshopokam hanak henek mour ananig wainig nubarig. ");
INSERT INTO apec_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Aria ahudok atuh nyumnah ruwahep 9-kilok anudok debeini nanak agundok arpesh apa shantorum um aria natik anam armam heyotu atugun nagundok aria mour uwok. ");
INSERT INTO apec_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Aria anudok debeini nakripam namudok, ‘Ipak shopunek kare penek mour eikig wainig nubarig aria eik ta ikep utabor bigipesh mour kabi da penekenyi um.’ ");
INSERT INTO apec_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","“Aria amam shopunek hanak henek mour. Aria abudok nyutob um aruh aria wabigep 3-kilok, anudok debeini nanak ba ta nenek apunih aih kabi da iganigadae rig nenekesh um. ");
INSERT INTO apec_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","“Aria um 5-kilok wabigep anan ta nanak aria natik anam kupaimi armam shopunek heyotu meyoh. Aria narigam namudok, ‘Umum maresh ba ipak da peyotu meyoh agundok um ahudok rouhi nyumnah?’ ");
INSERT INTO apec_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","“Aria amam hakripan namudok, ‘Douk madae anan arman nukop mour apak uwe, uwok.’ “Aria anudok debeini nakripam namudok, ‘Ipak shopunek kare ba penek mour eikig wainig nubarig.’ ");
INSERT INTO apec_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Aria wabigep mour nyatuhobi nyutob, anudok debeini nanaki nakrip ananin nasuhw merik um mour iri namudok, ‘Nyak hwari amudok henek mour iri ba nyutorum nyukam utabor. Sagomatin nyak nyurig nyukam utabor amudok da hagiguk hatogur um mour iri, aria nyukam utabor atun atun arigaha nyutogur um amudok da harig hanaki hatogur um mour iri.’ ");
INSERT INTO apec_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","“Aria amudok da hanak henek mour 5-kilok wabigep iri hanaki hurao atin atin kina. ");
INSERT INTO apec_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Aria nyutob batogur um amudok da harik hatogur um mour iri hanaki um hurao amamibor utabor, aria amamip urkwip por namudok amam ta hurao sabaibori utabor. Aria uwok, amam shopunek harao atin atin kina shopunek. ");
INSERT INTO apec_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Amam hatik utabor amam harabori, aria amam hanitok hani anudok debeini nagrem nubarig iri namudok, ");
INSERT INTO apec_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‘Amudok armam hagiguk hatograri um mour, amam henek mour um atin arag aua, aria nyak nyokom atatahibor utabor um apak. Aria apak da marik menek debeinyi mour abom ruwahep arigaha douk, aria wah iganigadae hap abom.’ ");
INSERT INTO apec_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“Anudok debeini nagrem nubarig iri nemnek enyudok baraen aria anan ta nakrip anan um amudok henek mour iri namudok, ‘Arpenyin, eik madae igiyagimen ba inek enen yoweinyi ina um nyak uwe, uwok. Iganigadae ohwak wabo baraen nyakus atugun aria nyakri wosik um nyenek mour shuknih nyumnah aria ta itorin atin arag kina. ");
INSERT INTO apec_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Nyak nyurao nyakibor utabor aria kare nyunak. Amudok yagiguk yarawam iri douk eik kanak yakri wosik meyoh um yokam atatahibor utabor kabi da yako ipak um. ");
INSERT INTO apec_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Eshudok eikish muguhwos. Aria eik ta mare igipesh eikim urkum aria isiya eikibor utabor, aka? Aria eik ta ikana inekesh yopuhi aih, aria umum maresh ba nyakish urkum apahw shenek nyigiya um eikih yopuhi aih?’” ");
INSERT INTO apec_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Aria Jisas nakri namudok, “Eshudok douk nyeiguhw wokeshi shape shagiguk iri, eshesh ko shutogur debeishi shupe shurik. Aria eshudok douk shatogur debeishi shape sharik iri, eshesh ko shupe shugiguk.” ");
INSERT INTO apec_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Aria Jisas nani ananim 12-poreim disaipel hagim yah hatoum Jerusalem. Aria anan nakripam um heyotum huni anan atun hunak aria amam apa hagim yah hanak aria Jisas nakripam namudok, ");
INSERT INTO apec_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Ipak pumnek. Douk apak munak Jerusalem. Aria eshesh ko shuko Eik Anudok Arman yatogur adurinyi arpen iri um amam debeimi pris huni amudok anam henek skulumesh um lo iri. Aria amam ko heneme kwot eik aria hubo baraen um ko he igok. ");
INSERT INTO apec_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Aria amam ko huko eik um eshesh kupaishi da madae shunahwaram Juda iri, aria eshudok arpesh ko shububunim eik shugukoruhe aria shupruke aria ko she igok rowogin kruse. Aria bihotuh-ahi nyumnah eik ko ta ikitak um shagok iri um aria ipe.” ");
INSERT INTO apec_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Aria Sebedi ananik irohukwik kwanamori Jisas kwani okwokwim biom nagamim. Aria okwok kwabuh kwoduk ohrubus agundok Jisas napeum aria kwarigan um numnek okwokwin baraen. ");
INSERT INTO apec_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Aria Jisas Narigok namudok, “Nyak nyakri maren baraen?” Aria okwok kwakrip Jisas namudok, “Nyak ta nyukripe adurin atin baraen namudok. Amudok eikim biom nagamim ta hupe hurukum nyak, anan ta nupe wobrehah um nyakin yopunyi rogur aria anan ta nupe wobrehah um nyakin anagagrin rogur, um agundok Iruhin nape debeini um ananish arpesh um.” ");
INSERT INTO apec_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Jisas nemnek enyudok baraen aria nakripok namudok, “Ipak douk madae gamo pudukemesh um maresh muguhwos ipak da parig eik-umesh iri. Aria ipak ta wosik um ta putaurume pusah eikin debeinyi amain aria pubroh enyudok koutukwi eik ta ibroh enyi aka, uwok?” Aria Sebedi nagamim hakri namudok, “Ohwak biohw wosik ko utaurumen um usah enyudok amain aria ubroh enyudok koutukwi.” ");
INSERT INTO apec_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Aria Jisas nakripam namudok, “Adur atin ipak biom wosik ta ko pubroh enyudok eikin koutukwi um pusah eikin debeinyi amain. Aria enyudok um amiapen ta nyupe wabrehah um eikin yopunyi rogur aria wabrehah um eikin anagagrin rogur, enyudok douk madae eikish muguhwos um ta iyagwreh ba igraeh ipak um outumeb ba ikripep uwe, uwok. Eshudok shapeyeshi wagiturahos eikin Yaken nubokadae nagraehesh um armam ta hupeyeshi.” ");
INSERT INTO apec_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Aria amudok amam 10-poreim disaipel hemnek baraen um Jon nani Jems da henekeshum aria amamirub nyirub juwehosirub aturub um amam biom. ");
INSERT INTO apec_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Aria Jisas nahwari ihim-morim hanaki um anan aria nakripam namudok, “Ipak padukemesh, eshudok madae shudukemesh um Iruhin iri uwe um esheshih aih apa shenekoh um esheshim debeimi. Aria amudok esheshim debeimi dodogowim atum um ihish arpesh um ta shigipesh amamin atin baraen um shenek debeinyi mour. ");
INSERT INTO apec_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Aria douk ahudoki aih ta mare hupe orokohunum ipak uwe, uwok. Meini arman nakana nupe debeini orokohun um ipak, aria anan ta nupe kabi da anan nenek mour um ipak iri. ");
INSERT INTO apec_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Aria meini arman nakana niyotu nirik ba nurao debeinyi nyeigur um ipak iri, anan ko nupe nubuh atap ba nenek mour meyoh um ipak. ");
INSERT INTO apec_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Namudok atin kabi da Eik Anudok Arman yatogur adurinyi arpen iri douk madae inaki um arpesh ta shenek mour um shutaurum eik uwe, uwok. Eik yanamori yataurum eshesh, aria ikesh eikihw yegenyihw um ta igok aria itor sabaishi arpesh ikweshihesh um esheshish yoweishi inahos shenekesh iri.” ");
INSERT INTO apec_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Aria Jisas nani ananim disaipel hakutukuk wabur Jeriko ba hunak. Aria sabaishi arpesh shagipeshan shanak. ");
INSERT INTO apec_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Aria biom nabes seshuhomi hape anagasihum yah. Aria amam hemnek baraen um Jisas douk nagimori yah nanaki aria amam hahwar debeg namudok, “Nyak, Devit ananin barhonin, nyak ko nyenek gihaum ohwak biohw.” ");
INSERT INTO apec_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Eshesh arpesh shemnek amam biom hahwar aria eshesh shakripam debeg um mare hiyagwreh huhwar aria amudok biom amu hahwar debeg abom namudok, “Debeini, nyak Devit Ananin barhonin, nyak ko nyenek gihaum ohwak biohw.” ");
INSERT INTO apec_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Aria Jisas neyotu ba nahwari amudok biom aria nakri namudok, “Ipak biom pakana eik ta inek maresh um ipak?” ");
INSERT INTO apec_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Aria amam biom hakripan namudok, “Debeini, ohwak biohw wakana nyak ta nyupok ohwakis nabes.” ");
INSERT INTO apec_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Aria Jisas nenek gihaum amam biom aria nuwem wis amamis nabes arigas atin aria ta sanapok yopus aria ta hatrugun. Aria amam biom hagipesh Jisas hanak. ");
INSERT INTO apec_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Jisas nani ananim disaipel hanak huruhuruk um Jerusalem aria amam hanak hatogur wabur Betfage hurukum gani Olivig mihig. Nagundok aria Jisas neshopok biom disaipel harik hanak. ");
INSERT INTO apec_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Anan nakripam namudok, “Punak nabrudok wabur bape barigiri. Aria nagundok ipak biom ta ko putik enen mahin donki shanatogen nyeir maduhw nyani enen nugaen aria pukweshihesh madururuh aria puraesh punam-morim eik. ");
INSERT INTO apec_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Enen arpen nyerigep um enen baraen um, aria pukripen namudok, ‘Apakin Debeini nakriyesh,’ aria anan ko nukweshihesh shanaki arigas atin.” ");
INSERT INTO apec_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Eshudok eneshenesh shenenek um shuwereh profet ananin baraen nyatogur adurin atin. Aria baraen enyudok. ");
INSERT INTO apec_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Krip Saionibur debeiburi wabur, ‘Tik, ipakin king nanaki um ipak! Anan samokwiyain arpen nanaki netemori enen mahin donki aria enen nugaen donki nyaran nyanaku.’” ");
INSERT INTO apec_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Aria disaipel hanak henekesh kabi douk Jisas nakripam um. ");
INSERT INTO apec_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Aria amam harawi donki nyani nugaen. Aria amam hawashak amamih rupeh donkiyeb agab, aria Jisas naprok nato nakih notem agabinyum donki. ");
INSERT INTO apec_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Sabaishi arpesh shobuk esheshih rupeh gani yah. Aria kupaishi shatupoki shus sapeyeshi rowogosish nyeiguhw aria sheshubuk yah. ");
INSERT INTO apec_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Arpesh sharahaen sharik iri aria shagiguk um Jisas iri, amu apa sheyorub shahwar debeg namudok, “Apak manadudareh um Devit ananin barhonin aria matuk ananin nyeigur nyato iruhw. Makri Iruhin wosik ta nunekuman yopunyi anudok arman douk nanamori Debeini ananin nyeigur iri. Apak makri eshesh shape iruhw heven iri shopunek shunadudareh-uman aria shutuk Iruhin ananin nyeigur nyuto gani iruhw.” ");
INSERT INTO apec_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Jisas nawish Jerusalem aria ihish arpeshish mishish shakitak yowiyokuk aria shape shanasasorim, “Anan amiapen?” ");
INSERT INTO apec_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Aria eshudok sabaishi arpesh shantorum shagipeshan iri shape shahwar, “Anudok douk profet Jisas Nasaretepumin, nape gani shokugi nahobig Galili iri.” ");
INSERT INTO apec_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Jisas nanak nawish narub um Iruhin ananit debeiti urupat aria nehiyah eshudok arpesh douk apa shator eneshenesh aria shanakam eneshenesh shakwu utabor iri nagundok. Aria anan nabadiguk tebolhos douk shape shadareh utaboreshi aria wagiturahos shapeyeshi shopunek um eshudok douk shanakam utabor um armiguhw iri. ");
INSERT INTO apec_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Aria anan nakrip eshesh namudok, “Iruhin ananik buk douk baraen nyakri namudok, ‘Eikit urupat douk ko shuhwarat um shenek beten-ati urupat.’ Aria ipak douk penekat tatogur kabi douk amudok hakwuaruh iri hanabeshuk-ati urupat.” ");
INSERT INTO apec_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Aria Jisas ta nape numun narub um atudok Iruhin ananit debeiti urupat aria enesh nabes seshukeshi shani aiyas yowegas iri shanaki. Eshesh shanaki aria nagabeyesh yopish. ");
INSERT INTO apec_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Aria amam debeimi pris hani amudok anam henek skulumesh um Iruhin ananin lo iri hatik enyudok aria amam henek nyigiya um ananin mour aria urkum apahw juwehosish atish. Umum maresh, amam hatik Jisas douk nenek enyudok Iruhin atun neneken iri mour nyani agundok batowish douk shahwar debeg shakri namudok, “Apak manadudareh um Devit ananin barhonin aria mohur ananin nyeigur nyato gani iruhw” ");
INSERT INTO apec_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Namudok aria amam hakrip Jisas namudok, “Nyak nyemnek enyudok baraen shokwishi shape shahwarumen iri aka, uwok?” Aria Jisas nakripam namudok, “Eik douk yemnek. Enyudok Iruhin ananin baraen ipak patarihen aka, uwok? Baraen nyakri namudok, ‘Nyak Iruhin douk nyohur batowish shani eshudok shawok nyumeb iri aria shatuk nyakin nyeigur nyato iruhw.’” ");
INSERT INTO apec_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Jisas nakripam enyudok baraen jurug aria nakutukuk amam aria natogurum adukiburum wabur, aria nanak nape nagundok um wabur Betani um nishuh abudok wab. ");
INSERT INTO apec_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Aria ruwahep wehip Jisas nakitak aria ta natanam um Jerusalem. Napa nanak yah aria nemnek nyurub ban. ");
INSERT INTO apec_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Aria natik enen rowog fik nyeyatu anagas um yah aria nanak huruhuruk-umen. Aria natik madae enep shuruwep pir uwe, uwok. Natik shus atus seir. Anan natik namudok aria nakrip enyudok rowog namudok, “Nyak kweipon mare ta enep shuruwep piren uwe, uwok.” Aria ahudok atuh nyumnah enyudok rowog yarin. ");
INSERT INTO apec_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Aria amam disaipel hatik namudok aria hakitak yowiyokuk hanaboum roguhw aria amam hanasorigum namudok, “Kakuri umum maresh aria enyudok rowog fik douk yarin arigas atin?” ");
INSERT INTO apec_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Aria Jisas nakripam namudok, “Eik yakripep adurin baraen, ipak douk gamo penek bilip um eik, aria ipak mare pur biyep urkwip aria ipak ko wosik penekesh namudok douk eik yenekesh um enyudok rowog fik um. Aria ipak ta mare penek enyudok atin uwe, uwok. Ipak ta pukrip agudok mihig, ‘Nyak kitak ba kare nyaprok nyubuh gani youg,’ aria enyudok mugu ko nyutogur kabi da ipak pukri um. ");
INSERT INTO apec_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Aria ipak ta penek bilip um eik ba penek beten aria ihish eneshenesh ipak penek beten um puraesh iri, eshesh ipak wosik ta ko puraesh.” ");
INSERT INTO apec_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Aria Jisas natanamori nawish narub um Iruhin ananit debeiti urupat aria apa nenek skulum eshesh arpesh um Iruhin ananin baraen. Aria amam debeimi pris hani eshesh Juda esheshim debeimi hanaki agundok anan napeum aria harigan namudok, “Nyak amiapen nyakripen aria nyuken enyudok big um nyenek eshudok eneshenesh? Aria douk amiapen nyakripen um wosik aria nyuken enyudok dodog?” ");
INSERT INTO apec_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Aria Jisas nakripam namudok, “Eik shopunek eik yakana iyarig ipak um enesh muguhwos. Aria ipak ko puwanamume yopinyi baraen um eik aria eik shopunek ta ikripep um douk amiapen nyakripe ba nyeke big um inek enyudok mour. ");
INSERT INTO apec_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Nubo Jon nenek baptaisumesh iri nenek baptaisumesh um, anan nubo amiapen nyakripan nyukon big ba nenek enyudok mour? Enyudok mour nyatogur iruhw heven aka, nyatogur abudok amnabish arpesh?” Amam hemnek namudok aria amam kanak hanitok um baraen hakri namudok, “Apak ta mukana, ‘Enyudok mour nyatogur iruhw heven,’ aria anan ta norigap namudok, ‘Aria umum maresh ba ipak madae penek bilip um anan?’ ");
INSERT INTO apec_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Aria apak ta mukri namudok, ‘Enyudok mour nyatogur abudok amnabish arpesh esheshin mour,’ aria apak ta munogugur um ihish arpesh. Umum maresh? Ihishmorim douk shadukemesh namudok Jon nenek baptaisumesh iri anan douk nanahwaram profet.” ");
INSERT INTO apec_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Aria amudok debeimi pris hani eshesh Juda esheshim debeimi hakrip Jisas namudok, “Apak madae mudukemesh uwe, uwok.” Aria Jisas nakripam namudok, “Eik shopunek eik ta mare ikripep um douk amiapen nyakripe nyuke big ba yenek enyudoki mour uwe, uwok.” ");
INSERT INTO apec_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Aria Jisas ta nakri namudok, “Aria ipak douk urkwip por mumam um enyudok baraen? Anan arman nabuki biom nugamim. Aria anan nanam ashuken aria nakripan namudok. ‘Nya, kare douk ba nyenek mour wainig nubarig.’ ");
INSERT INTO apec_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Aria san nuganin nakri namudok, ‘Eik yanoiwos’. Aria nape ba uwok, aria nabo urkum um nakitak nanak nubarig. ");
INSERT INTO apec_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Aria yaken nanam anudok anan naganin aria nakripan apunin baraen. Aria shokuni nuganin nakri namudok, ‘Wosik eik ta ko inak’. Aria anudok shokuni naganin madae nanak uwe, uwok. ");
INSERT INTO apec_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Aria um amudok biom nugamim, amiapen da nyagipesh yaken-umam ananin baraen?” Aria amudok debeimi pris hani eshesh Juda esheshim debeimi hakri namudok, “San nuganin.” Aria Jisas nakripam namudok, “Eik yakripep adurin baraen, amudok harao takis iri aria oudok weyotu yeh iri armago eshesh ko shurik shuwish um agundok Iruhin nape Debeini um ananish arpesh um. ");
INSERT INTO apec_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Umum maresh? Jon nenek baptaisumesh iri natogurum ipak aria neyabigep yopihi aih um ipak, aria ipak madae penek bilip um anan. Aria amudok harao takis iri aria oudok weyotu yeh iri armago eshesh shenek bilip um anan. Enyudok ipak patrin, aria ipak madae penek bilip ba pubukuk yoweishi inahos aria putanam pukon aparuh Iruhin uwe, uwok.” ");
INSERT INTO apec_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Aria Jisas ta nakri namudok, “Ipak ta shopunek pumnek enen wobuwobrenyi baraen. Anan arman nau wain anag nubarig aria naruk narub-umog. Aria numun nubarig anan narok anag bariyaigi nuwag um ko sharauri wainip shuruwep. Aria shurakep pubuh agudok nuwag aria shishishep shumawiyep, um shukwunish wainit ihat tutogur. Aria anan narok anap pato potem iruhw iri aurop numun nubarig um arpesh shupeyep um shiyoh nubarig. Aria anan nakrip anam armam um hurao kontrak aria hupe hiyohuman agudok ananig nubarig. Aria anan nanak napeik anabur rougunibur wabur. ");
INSERT INTO apec_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Aria huruhurukum wainip shuruwep burep, aria neshopok amudok heneman mour iri hunam amudok harao kontrak iri gani wainig nubarig um hudiman wainip shuruwep. ");
INSERT INTO apec_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Aria amudok armam harao kontrak um henek mour nubarig iri hasuhw amudok henek mour um debeini iri, aria habo anan hakwu wis aria anan han nagok aria anan hakwuman utabor ba nagok. ");
INSERT INTO apec_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Aria anudok debeini nagrem nubarig iri ta neshopok kupaimi heneman mour iri hanam amudok harao kontrak ba heyoh nubarig iri. Ahudok nyumnah anan neshopok sabaimi henek uhwinyum nubokadae rig neshopokam hanak iri. Aria amudok armam harao kontrak aria hape heyohoman ananig nubarig iri hakitak henekesh apunih aih um kabi douk nubokadae rig henekeshum. ");
INSERT INTO apec_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Nape ba uwok aria ta nagiguk neshopok ananin naganin nanam agudok nubarig. Aria ananim urkum mor namudok, ‘Eik ishopok eikin naganin nunak um aria ta wosik amam ta humnekan.’ ");
INSERT INTO apec_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","“Aria amudok henek mour nubarig iri hatigu nuganin nanaki aria hanakripam hakri namudok, ‘Nagrem wainig nubarig iri ananin nuganin anudok kweipon nugrem ihish eneshenesh ananin yaken ananish iri. Ipak yowi mon nugok um agudok ananig nubarig aria apak murag.’ ");
INSERT INTO apec_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","“Namudok aria hanak hasuwan huwashan natogur adukigum nubarig aria han nagok. ");
INSERT INTO apec_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Aria Jisas narik amudok debeimi Pris hani eshesh Juda esheshim debeimi aria nakri namudok, ‘Aria douk abudok nyutob anudok nagrem nubarig iri nanaki obi nyutob aria ta nenekam mumam amudok henek mour nubarig iri?’” ");
INSERT INTO apec_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Aria amudok debeimi hawanam baraen hakri namudok, “Anan ko nubo Amudok yoweimi armam nom nukom debeiri eriger aria hugok. Aria agudok wainig nubarig anan ko noko kupaimi heyohog. Um abudok nyutob wainip shuruwep burep, aria shudiyep shuko ananep.” ");
INSERT INTO apec_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Aria Jisas narigam namudok, “Ipak patrin enyudok baraen nyetem Iruhin ananik buk iri aka, uwok? Baraen enyudok nyakri namudok, ‘Amudok utom douk harok urupat iri hakana yoweimi aria huwasham-ukuk iri, douk matogur yopumi marik iri utom dodogeshim um shurok urupat um, um mushubonim anagasitum urupat. Enyudok douk Debeini atun neneken nyatogur. Neneken apak matrin aria makitak yowiyokuk manadudareh makri enyen douk Debeini atun neneken iri mour.’ ");
INSERT INTO apec_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“Namudok aria eik yakrip ipak, Iruhin ko ta nupotik ipak aria mare puwish um agundok Iruhin nape Debeini um ananish arpesh shapeum aria ta nurao ananish arpesh douk shasuhw ananin baraen dodog aria shenekesh um yopihi aih iri aria eshesh shunak shuwish um agundok Iruhin nape Debeini um ananish arpesh shupeim.  ");
INSERT INTO apec_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Aria douk meishi arpesh shugrukuk ba shubuh shetem amudok utom, um ko tukuresh um biyeh aria purukureshuk shokugun shokugun. Aria meishi arpesh douk amudok utom mugruki ba mubi mutemesh iri, aria ko mushorig eshudok arpesh ba shutogur shenenem kabi douk munyabeg um.” ");
INSERT INTO apec_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Aria amam debeimi pris hani Farisi hemnek Jisas ananin wobuwobrenyi baraen aria hadukemesh hakri anan douk nakriyen nenyum amam atum. ");
INSERT INTO apec_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Namudok aria hakri abom um husuhw Jisas um heneman baraen aria ta hanogugur um arpesh. Umum maresh? Eshesh shakri Jisas douk anan profet. ");
INSERT INTO apec_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Aria Jisas ta nakri enen kupainyi wobuwobren baraen shopunek um amudok debeimi namudok, ");
INSERT INTO apec_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Arpesh shuwish agundok Iruhin nape Debeini um ananish arpesh shapeum heven, douk kabi anan king nenekeshahi aih um. Ananin naganin nakana nurao armatok aria king nenek debeiguni worigun. ");
INSERT INTO apec_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Atin anan nakrip arpesh um shunaki um agundok shanaraum-oguni worigun. Douk ahudok nyumnah hatogur um shuwok worigun-ahi aria anan neshopok heneman mour iri um hanak hukripesh shanaki. Aria hanak hakripesh ba shanoiwos um shanaki. ");
INSERT INTO apec_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Aria anan ta neshopok kupaimi heneman mour iri um hunak aria nakripam namudok, ‘Punak pukrip eshudok nobokuhi yenemesh baraen iri ba shunaki. Pukripesh namudok, “Pumnek. Eik yenek eikigun worigun aria yagunubuk ba nakus. Eikish ababish kauhos shani shanagoki shokushi kupaishi kauhos apak iganigadae maesh. Ihish eneshenesh iganigadae shenenek ba shakus. Ipak yowi munam agundok shanaraum-oguni debeiguni worigun.” ’ ");
INSERT INTO apec_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","“Hanak hakripesh ba madae shumnekam uwe, uwok. Eshesh shakitak shanam esheshin mour. Anan nanam nubarig. Anan nanak nenek mourum ananis bisnis. ");
INSERT INTO apec_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Aria eshudok enesh shakitak shasuhw amudok heneman mour king iri sham irihwairoh shenekam abraenyim atum aria hagok. ");
INSERT INTO apec_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Namudok ba king ananibur nyibur juwehosibur atubur, aria neshopok ananim soldia hanak habo eshudok douk shabo ananim hagok iri. Haesh shagok aria howehumesh esheshibur wabur hanubur heyatabur. ");
INSERT INTO apec_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","“Aria king nahwar amudok anam heneman mour iri hanaki ba nakripam namudok, ‘Agundok eikigun worigun yenekagun um eikin nuganin nurao armatok um douk nenenek nakus. Aria arpesh yenemesh baraen um shunaki iri, eshesh yoweishi arpesh aria madae shunaki uwe, uwok. ");
INSERT INTO apec_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Namudok aria douk atin ipak punam sabaihi debeihi yeh aria putorumori ihish arpesh ipak putrishi. Aria ipak pukripesh aria puraesh punaki um agundok worigun.’ ");
INSERT INTO apec_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Anan nakri namudok, aria amudok heneman nour iri hakitak hagim yeh hanak. Amam hanak aria hakrip sabaishi ba haraesh hanaki. Enesh yopishi enesh yoweishi. Haraeshi aria atudok debeiti urupat douk shenek worigun um eshudok biyesh shanaraum iri amu shunukit. ");
INSERT INTO apec_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Douk shape aria king nanak nawishum nutrish. Nawish aria natik anan arman douk madae nurei yopuhi rupah douk shanoginohw-ahi um agnudok douk arpesh shanaraum um uwe, uwok. ");
INSERT INTO apec_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Aria king narigan namudok, ‘Arpen, umum maresh? Aria nyak madae nyerei yopuhi rupah ba nyanak nyawishi agundok? Anan douk baraen wokan mumukin aria nape.’ ");
INSERT INTO apec_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","“Aria king nakrip amudok heneman mour iri namudok, ‘Ipak puweshik anudok ananish roguhw aiyas aria puwashan nutogur aduk ba nupe arukwutigunum. Nutogur nupe um arukwutigun-ibur wabur arpesh shape shureh ba sharpogur esheshiruh naruh shuwegoruh ba shemnek debeiri eriger um.’” ");
INSERT INTO apec_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Aria Jisas nakripam, “Ipak pumnek. Iruhin nadukemesh um nuhwari sabaishi arpesh aria nagraeh atin atin meyoh shupe shuni anan.” ");
INSERT INTO apec_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Amam Farisi hanak anabik aria heyagwreh habo baraen um hakri hunek rohw husarigan enen baraen, ba hurim yeh um heneman kwot Jisas. Amam hakana hukwiraeh hugiyagim Jisas um niyagwreh enen nyaunyatograri baraen um aria amam Farisi ta heneman baraen Jisas um anan kanak ananin baraen. ");
INSERT INTO apec_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Amam heshopok amamim disaipel hani Herot ananim armam hanam Jisas aria hakripan namudok, “Tisa, apak madukemesh, nyak nyeyagwreh adurin baraen iri. Um enyudok adurin baraen atin nyak douk apa nyenek skulum arpesh um Iruhin ananih yopihi aih. Nyak madae nyunogugur enen arpen uwe, uwok. Nyak nyeyagwreh apunin baraen um ihish arpesh, eshudok debeishi nyeiguhw shapeyeshi aria nyeiguhw wokeshi shopunek. ");
INSERT INTO apec_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Namudok aria nyak kripap. Nyak douk ta nyukri mumam? Enyudok douk wosik um apak ta mukon takis um debeini gavman Sisar aka, uwok?” ");
INSERT INTO apec_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Jisas nadukemeshum amamip yoweipi urkwip por ehi aih aria nakri namudok, “Ipak pagiyagigi armam, ipak pakana pugiyagim eik um maresh? ");
INSERT INTO apec_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Ipak ta puyabige anam utom ipak pator takis omi.” Aria amam harawi anam utom um anan. ");
INSERT INTO apec_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Aria Jisas narigam namudok, “Arudok aborir aria enyudok nyeigur omiapenyish?” ");
INSERT INTO apec_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Aria amam hakana, “Debeini gavman Sisar ananish.” Aria Jisas nakripam namudok, “Eneshenesh Sisar ananish ipak puko ananesh, aria eneshenesh Iruhin ananish ipak puko Iruhinesh.” ");
INSERT INTO apec_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Amam hemnek enyudok baraen, hakitak yowiyokuk aria hakutukuk anan ba hanak. ");
INSERT INTO apec_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Ahudok atuh nyumnah amam Sadyusi douk apa hakri um shagokiri kweipon mare ta shukitak uwe iri, hanaki agundok Jisas napeum. Aria harig Jisas namudok, ");
INSERT INTO apec_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Tisa, Iruhin ananin lo seiwok nako Moses iri nyakri namudok, ‘Douk anan arman batowish uwok ba nugok, aria ananin wanin nuwaur ananik irohukwik ba kubuki batowish, um ashuken ananip awirop um ta mare diwarihuk iyoh.’ ");
INSERT INTO apec_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Seiwok anap awirop amakek yaken shabuki 7-poreim nagamim hape orokohun um apak. Ashuken nurao onok armatok um ananik irohukwik ba madae nubuki enesh batowish uwe, uwok, aria nagok. Namudok aria wanin ta nuwaur ashukekuman. ");
INSERT INTO apec_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Aria wanin shopunek madae nubuki enesh batowish uwe aria anan shopunek nagok. Aria rabinari um ashukenyim biom shopunek nagok, okwudok ashukek kwaur ihim-morim owarhim arigaha kwaur nagiguki shopunek. ");
INSERT INTO apec_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Ihim-morim amudok 7-poreim nugamim hagok aria bagiguki nyutob okwok shopunek kwagok. ");
INSERT INTO apec_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Aria nyak kripap. Kweiponib nyutob arpesh shagok iri ko ta shukitak um, okwudok armatok kweipon kupeim kurao meinari arman um okwokwin raminen um amudok 7-poreim armam? Nyak nyadukemesh, ihim-morim seiwok haraokum amamik irohukwik.” ");
INSERT INTO apec_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Aria Jisas nakripam namudok, “Ipak madae pudukemesh um Iruhin ananin baraen douk nyetem ananik buk iri uwe, uwok. Aria ipak shopunek madae pudukemesh um enyudok dodogowinyi dodog Iruhin ananinyi uwe, uwok. Namudok aria ipak peyagwreh nyau-nyatograri yoweinyi baraen. ");
INSERT INTO apec_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Kweipon eshudok arpesh shagok iri ta shukitakum, eshudok arpesh kweipon mare ta shanaraum uwe, uwok. Eshesh kweipon shupe kabi da enselahos shape iruhibur wabur heven. ");
INSERT INTO apec_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Aria um enyudok baraen douk arpesh shagok ba shakitak um, eik yakana iyorik ipak. Ipak seiwok madae putarih Iruhin nakripep-enyi baraen um ipak aka, uwok? Anan nakri namudok, ");
INSERT INTO apec_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Eik Abraham nani Aisak nani Jakob henek lotu um eik iri, eik amamin Iruhin.’ Enyudok baraen nyakri Iruhin anan douk madae shagok iri esheshin Iruhin uwe, uwok. Anan douk arpesh shape iri eshesh shenek lotuman iri.” ");
INSERT INTO apec_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Eshesh arpesh shemnek enyudok baraen, aria shakitak yowiyokuk um ananin baraen. ");
INSERT INTO apec_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Douk amam Farisi hemnek um Jisas nabeyomuk baraen amam Sadyusi aria amam hantorum hanamori anan. ");
INSERT INTO apec_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Anan nadukemesh um Iruhin ananin lo nape orokohun um amudok. Anan nakana nukwiraeh nugiyagim Jisas um niyagwreh enen baraen madae yopunyi uwe aria narigan namudok. ");
INSERT INTO apec_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Tisa, meinyi lo douk nyarik iri um ihin Iruhin ananin lo aria nyenek uhwin um ihin kupainyi lo?” ");
INSERT INTO apec_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Aria Jisas nakripan namudok, “‘Ipak ko pukri punuwasham Iruhin, apakin Debeini. Ipak ko gamo pukri punuwasham anan adur atin um ipakim shunukim urkum aria ipakin shunukin mishin aria um ipakinyum shunukinyum tinytin um punasuhw dodog pukri anan atun.’ ");
INSERT INTO apec_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Enyudok lo enyen debeinyi aria dodogowin nyarikum ihin lo. ");
INSERT INTO apec_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Aria enen lo nyagipesh enyudok lo enyen douk atatahin um enyudok nyarik iri lo. Enyudok lo nyakri namudok, ‘Ipak ko pukri punuwasham meishi arpesh douk shape huruk um ipak iri kabi da ipak pakri punuwasham ipak kanak morim um.’ ");
INSERT INTO apec_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Enyudok biyen lo douk mamokin aria baugenyum ihin kupainyi baraenyum Iruhin ananin lo aria shopunek ihin baraen um amam profet henyemaguk iri.” ");
INSERT INTO apec_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Amam Farisi hantorum hape atugun, aria Jisas narigam namudok, ");
INSERT INTO apec_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Ipakip urkwip por mumam um anudok arman Krais Iruhin nagraehan neshopokan nanaki iri? Anan douk amiapenyin barhonin?” Aria amam Farisi hakripan, “Anan douk Devit ananin barhonin.” ");
INSERT INTO apec_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Aria Jisas narigam namudok, “Namudok aria umum maresh aria Iruhin ananin Mishin seiwok nyakon urkum Devit aria anan nahwar anudok arman ‘Debeini?’ Umum maresh? Devit seiwok nakri, ");
INSERT INTO apec_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Debeini nakrip eikin Debeini namudok, “Nyak hagipe agundok ehahum eikin yopunyi rogur arigaha eik ko ta ibo nyakim horim hubuh atap um nyak ba iyoh.” ’ ");
INSERT INTO apec_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Ipak putik. Devit douk nahwar anudok arman Krais nakri, eikin Debeini. Namudok aria umum maresh ba Krais anan da Devit ananin barhonin?” ");
INSERT INTO apec_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Aria madae ananum amudok armam ta wosik nuwanam baraen ba nukrip Jisas uwe, uwok. Aria um ahudok nyumnah aria hagiguki nyumneh, amam hanogugurum horik Jisas um enesh muguhwos shopunek uwe, uwok. ");
INSERT INTO apec_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Aria Jisas nape nakrip eshudok worobaishi arpesh shani ananim disaipel. ");
INSERT INTO apec_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","Anan nakri namudok, “Amam Farisi hani amudok henek skulumesh um Iruhin ananin lo iri, hape debeimi henek skulumesh kabi seiwok Moses nape Debeini aria nenekesh um. ");
INSERT INTO apec_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Namudok aria ihin baraen amam hakripepenyi, ipak ko pumnek aria pigipeshen. Aria ehudok yoweihi aih amam apa henekehi, ehudoki aih ipak mare pigipesheh uwe, uwok. Amam hakripesh um Iruhin ananin lo aria amam madae ta hugipeshen uwe, uwok. ");
INSERT INTO apec_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Amam hakrip ipak um pigipesh dodogowinyi lo kabi da amaenyigwi unug hagwem ipakibus agabus, aria ipak penek debeinyi mour um apa pusah agwudok unug. Aria amam madae ta hutaurum ipak ba pusah enyudok dodogowinyi lo uwe, uwok. ");
INSERT INTO apec_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","“Ihish eneshenesh amam henekeshi, amam henekesh um arpesh ta shutrum aria shukam big. Amam douk henek shaginohw-oguni bokisigunaria haweshikogun nape amamigos yomogos aria roguhw. Aria amamih rupeh henekehi apubusih um rouhi hatogur heiruk. ");
INSERT INTO apec_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Shenek debeiguni worigun um amam hakana hunak hupe wagiturahos shutao yopugunum um gani debeimi atum hapeim. Eshesh Juda shape sheneyagwreh baraeny-ogwi urusag shopuk amam hakana hunak hupe yopishi wagiturahos shape sharik iri. ");
INSERT INTO apec_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Amam hakri abom um arpesh shukripam shenekumam yopihi nyumnegwih, wabigegwis aria ruwahegwis gani shantorum um agegwiruhum, aria amam hakri abom um arpesh shuhwaram ‘Debeini Tisa.’ ");
INSERT INTO apec_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Aria arpesh douk mare ta shuhwarep ‘Debeini Tisa’ uwe, uwok. Atun arag arman anan douk ipakin Debeini Tisa aria ipak ihipmorim douk pape ashuken anin. ");
INSERT INTO apec_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Aria douk atap agudok nahobig ipak ta mare puhwar anan arman ipakin yaken uwe, uwok. Atun arag arman nanahwaram ipakin yaken iri douk nape heven iri. ");
INSERT INTO apec_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Aria douk mare ta shuhwarep ‘Debeimi’ uwe, uwok. Ipak douk puhwar atun arag Debeini, eik douk Krais anudok arman Iruhin nagraehe aria neshopoke um yanaki iri. ");
INSERT INTO apec_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Meishi arpesh douk shukri shupe ipakish debeishi, eshesh ta shupe shunek mourum ipak meyoh. ");
INSERT INTO apec_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Meishi arpesh shakana shuto debeishi abom iri eshesh shubuh atap iri. Meishi arpesh madae shuhur esheshish nyeiguhw shuto iruhw iri, eshesh ta shunahwaram debeishi arpesh.” ");
INSERT INTO apec_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","14","Aria Jisas ta shopunek nakri namudok, “Eik yakri giha abom um ipak penek skulumesh um lo iri aria ipak Farisi. Aria ipak ko pupe yoweihi aihum. Umum maresh, ipak peyagwreh biyog nukwatog iri. Umum maresh? Ipak padukemesh um putapok witogum arpesh shakana shuwish aburdok wabur um Iruhin nape Debeini um ananish arpesh shapeum heven. Umum maresh? Ipak kanak shopunek ta mare puwish uwe, uwok. Aria kadak ba arpesh shakana shuwishum aria ipak punak putapumesh yah eshesh kabi da putapok witog um esheshis nabes yomogos um. ");
INSERT INTO apec_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Eik yakri giha abom um ipak penek skulumesh um lo iri aria ipak Farisi. Aria ipak ko pupe yoweihi aihum. Umum maresh? Ipak peyagwreh biyog nukwatog iri. Ipak panak parahaen ihigunum youg aria amnab umum pakana penek atun arman um nutogur ipakin disaipel. Aria abudok nyutob anan ko nutogur disaipel ba jurug, aria ipak kanak pabirak namudok aria anan nenek uhwin um ipak um nenek yoweyoweihi aih. Aria ipak penekan aria pushopokan um ta nunam yoweiburi wabur hel kabi da ipak kanakmorim. ");
INSERT INTO apec_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Eik yakri giha abom um ipak Farisi nabes seshuhep iri pakana piyabik yehum kupaishi, aria ipak ko pupe yoweihi aih um. Umum maresh? Ipak pakri namudok, ‘Enen arpen nyukri um Iruhin ananit urupat aria nyukana adur iruhw um nyunek enesh muguhwos, aria ta mare nyunekesh um da enyen nyakrium. Aria douk enen arpen nyukri um gol rakus Iruhin ananit urupat aria nyukri adur iruhw, aria enyudok arpen ta nyenekesh kabi da nyakrium.’ ");
INSERT INTO apec_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Ipak pagugaki aria nabes seshuhepi, maresh eneshenesh douk yopishi sharikiri um Iruhin ananis nabes? Gol douk yopuri aria rarik iri aka? Iruhin ananit urupat douk yoputi ba tarik iri? Ipak padukemesh, Iruhin ananit urupat atut douk tenek gol ratogur Iruhin ananish muguhwos. ");
INSERT INTO apec_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Aria shopunek ipak pakri namudok, ‘Douk meinyi arpen nyukri alta aria nyukri adur iruhw um nyunek enesh muguhwos, enyudok douk baraen meyoh. Aria douk nyukri ofa nyutem iruhw alta iri aria nyukri adur iruhw, aria enyen ta nyenekesh kabi douk nyakrium.’ ");
INSERT INTO apec_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Ipak nabes seshuhep iri, maresh muguhwos douk yopishi ba sharik iri um Iruhin? Ofa douk yopunyi nyarik iri um Iruhin aka? Alta douk yopunyi nyarik iri um Iruhin ananis nabes aka? Enyudok alta douk nyenek enyudok ofa nyatogur Iruhin ananish muguhwos. Aria enyudok alta nyeshagrakuk ofa. ");
INSERT INTO apec_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Namudok aria meinyi arpen nyukri alta aria nyakana adur iruhw, enyen dodogeshinyum enyenyin baraenyum alta nyani ihishmorim eneshenesh shetem iruhinyum iri. ");
INSERT INTO apec_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Aria meinyi arpen nyakri Iruhin ananit urupat iri aria nyukri adur iruhw um nyunek enesh muguhwos, enyen dodogeshinyum enyenyin baraenyum Iruhin ananit urupat aria Iruhin anan kanak shopunek, nape atudok urupat iri. ");
INSERT INTO apec_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Aria meinyi arpen nyukri heven iri aria nyukri adur iruhw um enyen dodogeshinyum enyenyin baraenyum Iruhin ananin yopunyi wagitur aria anan kanak napeyenyi enyudok wagitur iri. ");
INSERT INTO apec_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Eik yakri gihaum ipak douk penek skulumesh um Iruhin ananin lo iri aria ipak Farisi. Aria Ipak ko pupe yoweihi aihum. Umum maresh? Ipak peyagwreh biyog nukwatog iri. Ihig shokugi apig eneshenesh nubarigish ipak pasiyaeshum 10-poreigunum aria pukon anabikum Iruhin. Aria douk urkum moshukep-ukukum ihin debeinyi baraenyum Iruhin ananin lo, kabi da yopuhi aih um, urkwip purum arpesh aria punek gihaum arpesh um aria punek bilipum Iruhin ananin baraen aria pigipeshen. Douk ipak ta dodogeshipum pigipesh enyudok baraenyum debeinyi lo, aria ipak mare ta urkwip pukepukuk um nyanyudok enen um shokugi apig enesheneshin lo shopunek uwe, uwok. ");
INSERT INTO apec_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Ipak nabes seshuhep iri pakana piyabik arpesh um yah, ipak kabi da arpen nyushakam shokuri eshur ror enyenyik yabik, aria enyen nyatukor nyawashorukuk. Aria enyen madae nyutik debeinyi mahin Iruhin nakri um mare shunyoh iri kamel douk nyor yabikum, aria enyen nyahurig yabik nyakutuguk. ");
INSERT INTO apec_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Eik yakri giha abom um ipak douk penek skulumeshum Iruhin ananin lo iri aria ipak Farisi. Ipak ko pupe yoweihi aihum. Um maresh? Ipak peyagwreh biyog nukwatog iri. Ipak gamo pakrup adukisum kas sani yaureruh, aria ipakih yoweihi aih hape numuniruhum. Ahudok aih douk namudok, ipak penek nyigiya um kupaishi esheshish muguhwos aria ipak pakwuaruh-umesh. Umum maresh? Ipakip urkwip douk porum ipak kanak atin. ");
INSERT INTO apec_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Ipak Farisi da nabes seshuhep iri. Sagomatin ipak pukrup numunipum kap, aria ta adukipum shopunek ta bogrop. ");
INSERT INTO apec_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Eik yakri giha abom um ipak douk penek skulumeshum Iruhin ananin lo iri aria ipak Farisi. Ipak ko pupe yoweihi aihum. Umum maresh? Ipak peyagwreh biyog nukwatog iri. Ipak douk kabi wonugwegwiruh eshesh showatomoruh shakwu shigorihwiti beit. Adukihwum wonugwehw yopuhwum shutruh, aria numun shagoki esheshish bishiguh aria ihishmorim goutukwishi eneshenesh shor. ");
INSERT INTO apec_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Ipak shopunek pape namudok atin. Arpesh shatik ipakiruh yegeshiweruh, aria shakana ipak douk yopishi arpesh. Aria amu uwok. Numunum ipak douk shunikipum agundok peyagwreh biyog nukwatog um aria agundok pabrig Iruhin ananin lo um.” ");
INSERT INTO apec_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Aria Jisas ta nakri namudok, “Eik yakri giha abom um ipak douk penek skulumeshum lo iri aria ipak Farisi. Ipak ko ta pupe yoweihi aihum. Umum maresh? Ipak peyagwreh biyog nukwatog iri. Ipak penek yopuruhi wonugwegwiruh um amam profet, aria ipak paginohw-oruh um eshesh yopishi shagok iri arpesh. ");
INSERT INTO apec_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Aria ipak pakri namudok, ‘Nubo seiwokum babenomi hapeyobi nyutob um, aria apak ta mare mutaurum esheshum shubo amam profet hugok uwe, uwok.’ ");
INSERT INTO apec_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Um enyudok ipakin baraen ipak kanak powereh agundok ipak patoguromi yamehem seiwok habo amam profet hagok iri um. ");
INSERT INTO apec_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Ipak mare pigiyagig penekesh namudok ipak douk yopishi arpesh uwe, uwok. Ipak kare, ba punekesh ahudoki yoweihi aih kabi da ipakim yamehem seiwok henekeshum aria piyatak ipakim yamehem amamih yoweihi aih! ");
INSERT INTO apec_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Ipak kabi da yoweiguhwi yuguhw um. Iruhin ko nenemep baraen ipak aria ipak ko punam hel, ehudok yoweihi nyih ta ipak puruwok um yah wokumep. ");
INSERT INTO apec_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","“Namudok aria ipak pemnek! Eik ko ishopokugu amam profet aria yopumi urkum morom iri anam here yopumi urkum iri aria amam hadukemesh um Iruhin ananin lo iri hunamagu ipak. Namudok aria ipak ta pubo anam hugok, pupruk anam aria penek nyilim anam hir rowogin kruse aria pupruk anam numun ipak Juda pape peyagwreh-ogwi urusag. Aria ipak ta apa puhiyahamum ipakirub warub aria amam ta huruwok hanam kupairubi warub. ");
INSERT INTO apec_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Namudok aria Iruhin ko ta nunekep pusah debeinyi amain um agundok pabo ihim-morim yopumi armam hagok um. Amam seiwok hape abudok amnab iri, enyudok debeinyi amain kweipon nyupe ipak atin. Enesh arpesh seiwok shabo sabaishi yopishi arpesh shagok iri douk parik pabo Abel nagok arigaha shabo Sakaraia, Berekia ananin batowin, anan douk anudok arman ipak seiwok pan nagok orokohunum Iruhin ananit urupat aria um alta. ");
INSERT INTO apec_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Eik yakripep adurin baraen ipak, enyudok yoweinyi poe ta nyutogurum ehudok yoweihi aih, ahudok ko hutogrum eshudok arpesh douk shape agudok nahobig abudok nyutob iri.” ");
INSERT INTO apec_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Jisas natik wabur Jerusalem aria nakri namudok, “O ipak arpesh pape Jerusalem iri, seiwok ipak apa pabo amam profet hagok. Armam Iruhin neshopokam haraumepari ananin baraen iri, ipak douk shopunek pakwu-umam utabor pam hagok. Worobaihi atih nyumneh eik yakri iraepari aria ishigorip kabi anat mamokit owot tarauri nugag gwanaki atugun aria teshigorug atatish kapraigiyohos um. Aria ipak pakri amu uwok um eik. ");
INSERT INTO apec_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Aria douk pumnek! Douk ipakibur wabur ko bunanukuk buniyatakuk aria mare ta enesh arpesh shupe abrudok wabur uwe, uwok. ");
INSERT INTO apec_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Eik yakrip ipak adurin baraen namudok, ipak ko mare ta putik eik shopunek, arigaha kweipon abudok nyutob butogurum ba ipak ko pukri, ‘Apak makri Iruhin nunekuman yopishium anudok arman douk nanakmorim Iruhin ananin nyeigur iri.’” ");
INSERT INTO apec_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Jisas nakutukuk Iruhin ananit debeiti urupat natogur nanak, aria ananim disaipel hanamori anan. Amam hakana hiyabiganum Iruhin ananit debeiti urupat tuni yopugwi urusag gweyotu huruhuruk iri. ");
INSERT INTO apec_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Aria anan nakripam enyudok baraen. “Ipak patik agwudok yopugwi urusag? Eik yakripep adurin atinyi baraen, horim ko hanaki hubrigat aria hununut aria ta mare hukuna huhur anam utom ba humem anam kupaimi utom ba ta utabor butao uwe, uwok. Ihibor utabor ko shruworubor bututu biniyatak tupri tupro bunak atum atum bubuh bukus bunak amnab.” ");
INSERT INTO apec_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Jisas nakih nape ahwudok yoduhw Oliv, aria amam disaipel atum hanamori anan aria harigan namudok, “Nyak kripap, meibi nyutob eshudok eneshenesh iganigadae nyakripapeshi ko shutogur? Maren kak ko nyurik nyutogur aria apak ta mudukemesh, nyak ko nyutanamori aria abudok amnab ko butuhukuk?” ");
INSERT INTO apec_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Aria Jisas nutanam nakripam namudok, “Ipak ko pudukemesh atin. Ta enesh arpesh shunaki shugiyagimep. ");
INSERT INTO apec_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Umum maresh? Sabaishi kweipon shunaki shukri eikin nyeigur aria shukana, ‘Eik kanak Eik Krais Anudok Arman Iruhin seiwok nagraehe neshopoke yanaki iri.’ Aria shugiyagim sabaishi arpesh ba shunak shuwishuk. ");
INSERT INTO apec_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Ipak ko pumnek debeihwi wanohwin gaha huruk atin aria ipak ta pumnek baraenyum debeihwi wanohw ko hwutogur rougunum. Aria ipak ko pudukemesh. Aria ipak mare pukitak yowiyokuk uwe, uwok. Eshudok eneshenesh ko shutogur, aria abudok bagiguki nyutobum amnab ko butuhuk um ta mare butogur arigas uwe, uwok. ");
INSERT INTO apec_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Aria eshesh anag nahobig ko shukitak shini enesh kupaigi nahobig shurpak. Anan king nini ananishi ko shukitak shuni kupaini king nini ananishi shupe shurpak. Aria anarub warub ko debeirubi nyurub besh aria enyik ko kwutuk. ");
INSERT INTO apec_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Enyudok ihinyumorim nyarik iri amain kwo nyutogurum kabi da onok armatok kwonomnek rarig iri erigerum kwubanuh ba kubuki batowin um. ");
INSERT INTO apec_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Abudok nyutob eshesh ko shurao ipakum shukep eriger aria shukep amaenyibi aria shep pugok. Aria ihish arpesh esheshish nyirub aparuh ko yowesh um ipak. Umum maresh? Ipak douk eikipari aria eikin nyeigur nyapeum ipak. ");
INSERT INTO apec_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Aria um abudok nyutob sabaishi arpesh shenek bilipum eik iri ko shunahuhao eik aria shubukuk esheshin bilip um eik. Aria eshesh ko shunahwaram horik horinum eshesh kanak aria shunarao eshesh kanak um horik horin um shenenem baraen aria shesh shugok. ");
INSERT INTO apec_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Worobaimi henek rohw aria hagiyagig iri profet ko hutogur henek rohw hugiyagim worobaishi arpesh aria ko shigipesham. ");
INSERT INTO apec_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Yoweihi aihish inahos ko shutogur dedebesh atish. Namudok aria sabaishi arpesh ko shukutukuk ahudoki aih um shukri shunuwasham kupaishi arpesh kabi da eshesh shakri shunuwasham eshesh kanakmorim. ");
INSERT INTO apec_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Umum maresh? Eshudok douk shugipesh eik atish arigaha shugok iri, eshesh Iruhin ko ta nuraesh shutanamori shupe wosik atin. ");
INSERT INTO apec_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Aria eshesh ta shukripesh Iruhin ananin yopinyi baraenyum arpesh shuwish agundok anan nape Debeini um ananish arpesh um douk ko shanak shukripesh enyudok baraenyum ihirub warub abudok amnab um, ihish arpesh um shemnek ba shutuh iyoh, aria ahudok yoweihi hugiguki nyumnah ta ko hutogur.” ");
INSERT INTO apec_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Aria Jisas ta nakri namudok, “Ipak ko putik enyudok yoweinyi mugu abom iri, seiwok profet Daniel nakriyenyi, enyudok mugu ta nyutogur numun Iruhin ananit debeiti urupat. Aria nyununut ba arpesh mare ta shuntorum shanaki shuwish uwe, uwok. Eshesh ta shukuna yoweishi inahos shapeyoti urupat. Meishi arpesh shutarih enyudok baraen iri, eshesh ko gamo shudukemesh atin.” ");
INSERT INTO apec_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Aria Jisas nakripam namudok, “Abudok nyutob arpesh shape agudok Judiaig shokugi nahobig eshesh ko shuruwok shunak gani yodururuh-igunum. ");
INSERT INTO apec_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Meinyi arpen nyetem iruhw urupat iri, ta nyubuh atap um, enyen ko mare urkum murum nyuhur enyenyish eneshenesh shakus numunum urupat iri uwe, uwok. ");
INSERT INTO apec_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Aria meinyi arpen nyetu nubarig iri, enyen ko mare nyutanam urupatum nyuhur enyenyih rouhi rupah uwe, uwok. ");
INSERT INTO apec_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Debeinyi gihaum wanarahaenyi armago aria armago apa wokesh nyumeb shokwishi batowish iri um abudok yoweibi nyutob. ");
INSERT INTO apec_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Ipak ko penek beten ba ta mare puruwok um nyumanugasibi nyutob aka, um ahudok nyumnah Sabat uwe, uwok. Anah kupaihi akure, ta wosik. ");
INSERT INTO apec_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Eik yakripepum ta puruwok. Umum maresh, abudok nyutob debeinyi amain abom ko nyutogur. Sagomatin Iruhin nakwaram agudok nahobig um arigaha douk, namudokinyi amain madae nyutogur uwe, uwok. Aria kweipon babi bagiguki nyutob shopunek ko mare enyudoki amain ko ta nyutogur shopunek uwe, uwok. ");
INSERT INTO apec_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Seiwok Iruhin mare nukri ba nurupok nyutob banob um enyudok debeinyi amain nyutogur akure, ihish arpesh ko shugok shutuh. Aria ba uwok, ananim urkum morum ananishi ihish arpesh anan kanak nagraeheshi. Namudok aria anan ta narupoki abudok yoweibi amaenyib nyutob babuhi banab atub. ");
INSERT INTO apec_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Um abudok nyutob, meishi arpesh ko shukrip ipak, ‘Ipak putik. Anudok arman Krais,’ douk Iruhin nagraehan aria neshopokan nanaki iri douk anudok aka, shukripep shukri, ‘Nani nape ganik,’ aria ipak mare penek bilipumesh uwe, uwok. ");
INSERT INTO apec_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Umum maresh? Aria anam henek rohw hagiyagigi iri armam ko hunaki hukri namudok, ‘Eik anudok arman Iruhin nagraehe iri aria neshopoke yanakium iri’ aka, ‘Eik shopunek douk anan profet.’ Aria amam ko henek debeinyi Iruhin atun neneken iri mour aria henek enen kak nyutogur. Eshesh shakana shenek rohw shigiyagim ihish arpesh, aria eshesh ta wosik um aria eshesh shakana shenek rohw shigiyagimum arpesh Iruhin douk nagraeheshum ananish iri. Aria namudok ta uwok. ");
INSERT INTO apec_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Ipak pumnek. Eik riguk yakripep jurugum eshudok eneshenesh ko shutogur. ");
INSERT INTO apec_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Namudok aria meishi arpesh ko shukripep, ‘Ipak putik, Krais nani nape gani wehigunum arpesh uwok um,’ aria ipak mare pumnekesh ba punak uwe, uwok. Aka meishi arpesh shunaki ba shukri, ‘Anudok nanabeshuk nape numun atudok urupat,’ aria ipak mare punek bilipumesh uwe, uwok. ");
INSERT INTO apec_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Umum maresh? Ipak padukemesh um utag brereyarogum, aria atudok lait tatogurum aun nakihmorim aria brereyarat tanak gani aun nabuhum. Namudok aria Eik Anudok Arman douk yatogur adurinyi arpen iri ta inekesh namudok atinyum abudok nyutob eik ko inamorim aria ihish arpesh ko shutiwe atin. ");
INSERT INTO apec_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Agundok arpesh shagok shakusum, kumub ko bunaki bunahweh enyudok arpen nyagoki.” ");
INSERT INTO apec_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Aria shopunek Jisas ta nakri namudok, “Abudok yoweibi nyutobum enyudok amain um arpesh shemnek debeiri eriger um nyunak nyutuhuk, aria arigas atin ‘Nyumnahin aun nutogur wabin, aria wabin aun ta mare wanyukehin ta arukwutihin aria unib weir utagi ta utotobure ugruki, aria ihish dodogeshishi eneshenesh sheir utag iri ko mare shir atugun uwe, uwok. Eshesh ko shunonug shunak shunaki.’ ");
INSERT INTO apec_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","“Um abudok nyutob Eik Anudok Arman yatogur adurinyi arpen iri ko itogur gani iruhw utag aria ihismorim awirosish arpesh shape abudok amnab iri ko shureh. Aria eshesh ko shutik Eik Anudok Arman yatogur adurinyi arpen iri ta item iruhigum hevenig utag aria ibuhi ini eikin dodog aria eikit dodogowiti lait. ");
INSERT INTO apec_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Aria oruhw ko hwunahwapur debeg abom aria eik ko ishopok eikish enselahos shunak um shutorumori ihish arpesh eik seiwok yagrahaeshum eik kanak iri. Eshesh enselahos ko shutormori arpesh ihigunmori um agudok nahobig aria anagasum agudok nahobig aria sharaesh shanaki um eik.” ");
INSERT INTO apec_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Aria Jisas ta nakri shopunek namudok, “Ipak ko purao yopinyi saki um enyudok rowog fik aria pudukemeshum. Abudok nyutob butogurum aria rowogish nyeiguhw ko shunareh shurpaki namusi shus, aria ipak pudukemeshum yopubi wahib nyutob bakana ko butogur. ");
INSERT INTO apec_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Namudok atin, abudok nyutob ipak putik eshudok ihish eneshenesh riguk yakripep-umeshi shutogur ba jurug aria ipak ko pudukemesh um, Eik Anudok Arman yatogur adurinyi arpen iri eikib nyutob banaki huruhuruk jurug aria bapeimori wit. ");
INSERT INTO apec_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Eik yakripep adurin baraen, eshudok arpesh douk shape abudok nyutob iri, enesh ta mare shurik shugok uwe, aria eshudok ihish eneshenesh ta shutogur. ");
INSERT INTO apec_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Utag gani agudok nahobig ko ta shutuh, aria eikin baraen ta mare nyutuh uwe, uwok.” ");
INSERT INTO apec_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Aria Jisas ta nakri shopunek namudok, “Madae enesh arpesh shudukem ahudok nyumnah eik ko ta inaki aria eshudok eneshenesh ko shutogurum uwe, uwok. Eshesh enselahos shape heven iri madae shudukemesh uwe, uwok. Aria Eik Iruhin Nuganin shopunek madae idukemesh uwe, uwok. Eikin Yaken atun arag nadukemesh. ");
INSERT INTO apec_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Namudokehi aih eshesh seiwok shenekehi um Noa ananib nyutobum, eshesh ko shenek ahudok atatahih aih atih shupe abudok nyutob aria Eik Anudok Arman yatogur adurinyi arpen iri ko itanamori. ");
INSERT INTO apec_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Seiwok abudok nyutob douk debeibusi worubus madae sutogurum uwe, eshesh apa shenek irugis worigun shashoh, shawok abar, aria arpesh apa shanaraum, arigaha ahudok nyumnah Noa nawish korohukahi hatogur. ");
INSERT INTO apec_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Eshesh madae shudukemesh um enyudok amain ko nyutogur-umeshum uwe, uwok. Aria eshesh shape namudok atin arigaha abusdok debeibusi worubus satogur sabo ihishmorim arpesh shagok shatuh. Aria douk ko atatahih atih aih ko hutogrum abudok nyutob Eik Anudok Arman yatogur adurinyi arpen iri ko itanamorium. ");
INSERT INTO apec_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Abudok nyutob biom armam ko hiyotu nubarig aria Iruhin ko nurao anan, aria nukutukuk anan nupeiguk. ");
INSERT INTO apec_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Bio armago ko apa unek plauain rehinyum unek bret upe, aria Iruhin ko nurao onok aria nukutukuk onok kupeiguk. ");
INSERT INTO apec_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“Namudok aria ipak ko pudukemesh atin aria putrugun pupe. Ipak madae pudukemesh um marah nyumnah ipakin Debeini ko nutanamori um. ");
INSERT INTO apec_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Ipak ko gamo pudukemesh um enyudok baraen namudok. Douk nubo anan urupatinari nudukemesh um marab nyutobum wab nakwuaruhi arman ko nunaki, aria urupatinari anan ko niyoh urupat nupe aria ta mare nukutukuk urupat aria nakwuaruh iri ta nanaki nubrig urupat aria nuwish numunitum uwe, uwok. ");
INSERT INTO apec_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Aria ipak namudok atin ko pudukemesh atin ba pupe pubeime. Umum maresh, Eik Anudok Arman yatogur adurinyi arpen iri ko inaki anob nyutob ipakip urkwip madae purum eik ta inakiyobi nyutob, aria eik ta inaki.” ");
INSERT INTO apec_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Aria Jisas ta shopunek nakripesh wobuwobren baraen namudok, “Meinyi arpen nyenek mour iri ba nyor yopunyi saki aria wosik madae nyigiyagig aria nyenek yopunyi mour iri? Debeini ta nugraeh anudoki nenek mouri arman um ta nusuhw merik um amam kupaimi ananim henek mour iri, aria nusiyaumam worigunum nyutob amamin debeini nakriyobi. ");
INSERT INTO apec_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Anudoki arman nenek mour iri anan ko gamo nunadudareh um abudok nyutob ananin debeini ko nutanamori aria nutik anan apa nenek ananin mour. ");
INSERT INTO apec_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Eik yakripep adurin baraen, debeini ko nugraeh anudoki arman um nusuhw merik aria neyotu nurik um debeini ananish ihish eneshenesh. ");
INSERT INTO apec_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Aria um anudok nenek mouri arman ta nutogur yoweini arman aria anan urkum murum anan kanak namudok, ‘Eikin Debeini ta mare nunaki arigah uwe, uwok.’ ");
INSERT INTO apec_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Aria anan nikitak um nubo amudok hani anan henek mour atugun iri, aria anan nape apa nawok worigun aria nawok abar nani hawok abar ba hagugak iri. ");
INSERT INTO apec_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Aria debeini ko nutanamori anah nyumnah anudok nenek mour iri arman madae nudukemesh uwe um ananin debeini ko nanaki uwe, uwok. ");
INSERT INTO apec_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Aria debeini ko nanaki anah nyumnah aria nenekesh yoweishigom um anudok nenek mour iri, aria ta neshopokan nanak nini eshudok sheneyagwreh biyog nukwatog iri shupe atugun. Um nabrudok wabur eshesh ko shureh yowiyokuk aria shurupogesh esheshiruh naruh shumnek debeiri eriger.” ");
INSERT INTO apec_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Aria Jisas ta shopunek nakri namudok, “Um abudok nyutob arpesh shuwishum aburdok wabur Iruhin nape Debeini um ananish arpesh shapeum heven douk kabi enyudok wobuwobren baraenyum 10-poreiyu weroroiwi armago. Anan arman douk atin nurao onok armatok iri, anan nakana ko nunaki. Aria oudok weroroiwi armago wohur owowish lamhos, aria wanak um uparugan yah aria uran unaki. ");
INSERT INTO apec_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Anas wisiyu um oudok wagugaki armago, aria anas wisiyu wosik wadukemesh iri. ");
INSERT INTO apec_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Oudok wagugaki warauri owowish lamhos wanaki aria madae usuwi wel unaki shopunek uwe, uwok. ");
INSERT INTO apec_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Aria oudok wadukemesh iri, woshar kupairi wel owowish atin atin koutukwihos aria waraesh wanaki shopunek shani owowish lamhos. ");
INSERT INTO apec_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Anudok arman nakana nurao armatok douk atin iri madae nanaki arigas uwe, uwok. Namudok aria ihiyu-morim armago nabes seshuho aria weshuh wakuh. ");
INSERT INTO apec_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Arigaha orokohunib um wab aria enen arpen nyuhwar nyakri, ‘Anudok nurao armatok iri anudok nanaki. Ipak arigah yowi ba munak muranari gani yah.’ ");
INSERT INTO apec_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","“Aria oudok ihiyumorim weroroiwori wakitak wasusuhw owowish lamhos weshopohesh. ");
INSERT INTO apec_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Oudok wagugaki wakrip oudok wadukemesh iri namudok, ‘Ipak shukop anar ipakir wel. Apakish lamhos ko shakana hugokesh.’ ");
INSERT INTO apec_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","“Oudok wadukemesh iri wakrip oudok wagugaki namudok, ‘Namudok ta uwok. Arudok wel ta mare musiar uwe, uwok. Wel madae sabairum ipak ta pushar anar ipakish lamhos aria apak ta mushar anar apakish lamhos uwe, uwok. Ipak kare punak gani stua ba putor ipak kanak ipakir wel.’ ");
INSERT INTO apec_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Aria oudok anas wisiyu wagugaki wanak um unatori anar wel aria anudok nurao armatok iri nanaki natograri. Aria oudok anas wisiyu wadukemesh iri douk wape apa wobeim anudok arman iri wanaman wawish wani anan atudok urupatum shuwok agundok shunaraum-oguni debeiguni worigun. Aria arpesh shawaru wit. ");
INSERT INTO apec_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Aria oudok ono wagugaki shopuk wanak watograri, aria warig namudok, ‘Debeini, Debeini, jikumap wit apak shopunek.’ ");
INSERT INTO apec_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","“Aria anan nakripowi namudok, ‘Eik yakripep adurin baraen, eik madae idukemeshum ipak uwe, uwok.’” ");
INSERT INTO apec_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Aria Jisas nakri namudok, “Ipak gamo pupe apa putrugun. Umum maresh abudok nyutob douk eik ko ta itanamori obi nyutob, ipak madae pudukemesh uwe uwok.” ");
INSERT INTO apec_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Aria Jisas ta nakri namudok, “Arpesh shuwish um abrudok wabur Iruhin nape Debeini um ananish arpesh shapeum heven douk kabi enyudok wobuwobrenyi baraenyum anan arman nakana nanak anagun rougunum aria nahwari henek ananin mour iri hanaki. Amam hanaki aria nakom ananibor utabor amamis wisum henek mour. ");
INSERT INTO apec_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Anan douk nadukemeshum amamin saki nyani agundok amam douk dodogowim um henek mourum aria nakomuk utabor. Anan nakonukuk 5,000 kina.Anan 2,000 kina aria anan 1,000 kina. Douk nakomuk utabor aria anan nanakuk ananih yah. ");
INSERT INTO apec_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Nanakuk atin aria anudok narao 5,000 kina iri nanak nakwu abrudok utabor nenek bisnis. Nenekas arigaha ta nenek uhwinyum 5,000 kina winmoni shopunek. ");
INSERT INTO apec_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Aria anudok anan narao 2,000 kina iri shopunek namudok atin. Anan nanak nakwu abrudok utabor nenek bisnis aria nenek uhwinyum 2,000 kina winmoni shopunek. ");
INSERT INTO apec_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Aria anudok anan narao 1,000 kina iri, anan nanak narok anag nuwag aria nabeshuk ananin debeini ananibor utabor bor agudok nuwag. ");
INSERT INTO apec_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Douk arigaha roubi nyutob banak badiguk aria amudok heneman mour iri debeini ta natanamori. Aria narigamum hukripanum utabor riguk nakomabor-ukuk um douk henek mourum-abor iri douk batogrum makwunibor? ");
INSERT INTO apec_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Anudok sagomatin narao 5,000 kina iri nasuhwi 5,000 kina winmoni aria nenek ananibor utabor batogur um 10,000 kina aria nanaki nako ananin debeini. Aria nakripan nakri namudok, ‘Debeini, nyak seiwok nyekeik 5,000 kina. Nyak nyutik, eik yaraen yanak yenek bisnis aria ta yenek uhwinyum 5,000 kina winmoni shopunek!’ ");
INSERT INTO apec_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","“Aria ananin Debeini nakri namudok, ‘O wosik. Nyak wosik yopunyi arpen nyenek mourum eik iri. Nyak douk gamo nyagabe nyeyoh nyakin mour iri. Nyak wosik gamo nyagabe nyeyoh shokushi eneshenesh, namudok aria douk eik yakri nyak nyusuhw merik um sabaishi eneshenesh. Aria douk nyak yowi ba nyuni eik unadudareh.’ ");
INSERT INTO apec_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Anudok narao 2,000 kina iri anan shopunek nanaki nakri namudok, ‘Debeini, nyak seiwok nyekeik 2,000 kina. Aria nyak nyutik, eik yaraen yanak yenek bisnis aria ta yenek uhwinyum kupainyi 2,000 kina winmoni shopunek.’ ");
INSERT INTO apec_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","“Aria ananin debeini nakri namudok, ‘O wosik. Nyak wosik yopunyi arpen nyenek mourum eik iri. Nyak douk gamo nyagabe nyeyoh nyakin mour iri. Nyak wosik gamo nyagabe nyeyoh shokushi eneshenesh. Namudok aria douk eik yakri nyak nyusuhw merik um minihishi eneshenesh. Aria douk nyak yowi ba nyuni eik unadudareh.’ ");
INSERT INTO apec_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Amudok hanakuk aria anudok anan narao 1,000 kina iri shopunek nanaki nakri namudok, ‘Debeini, eik yadukemesh jurugum nyak, nyak juwehosinyi arpen. Nyak nyaurim aria nyatuk worigun kupaishi esheshigos nubarigos. Aria um amnab kupaikwi kupainari shuwashak shuruwepigun worigunobi amnab, nyak ihib nyutob nyaurim nyatuk worigun abudok amnab. ");
INSERT INTO apec_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Namudok aria eik yanogugur ba yanak yobeshuk enyudok 1,000 kina numun amnab. Aria nyakibor utabor abrudok ta suwoborugu.’ ");
INSERT INTO apec_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“Aria ananin debeini nakripan namudok, ‘Nyak yoweini arman arigeh haenyari. Nyak gamo nyadukemesh namudok, eik yaurim aria yatuk worigun kupaishi esheshigos nubarigos shaweshogosi aria eik shopunek yatuk worigun shuruwepigun amnab kupaishi shawashak shuruwep ba natogur iri. ");
INSERT INTO apec_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Aria umum maresh ba nyak madae nyubuk eikibor utabor gani benk? Namudok aria eik ta itanamori-obi nyutob eik ko wosik irao eikibor utabor buni enen winmoni shopunek. ");
INSERT INTO apec_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Namudok aria ipak ta putrun enyudok 1,000 kina anudok aria ta puko anudok arman douk nenek uhwinyum 10,000 kina iri. ");
INSERT INTO apec_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Umum maresh? Meishi arpesh douk shagrem enesh eneshenesh iri, eik ta ko ikesh enesh sabaishi eneshenesh shopunekum eshesh. Aria meishi arpesh douk eneshenesh wokesh iri aria shokushi eneshenesh eshesh douk shagremesh iri eik ko ta itrishesh-ukukum eshesh. ");
INSERT INTO apec_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Aria anudok yoweini nenek mourum eik iri, ipak ko puhiyahan nutogur arukwutigun um. Aria um abrudok wabur eshesh ko shureh yowiyokuk aria shunarupok esheshiruh naruh shuwegoruh.’” ");
INSERT INTO apec_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Aria Jisas ta shopunek nakri namudok, “Kweipon nabudok nyutob Eik Anudok Arman yatogur adurinyi arpen iri ko itogur gani iruhw utag aria inaginohw itanamori kabi anan kingum ini ihishmorim enselahos, aria eik ta itemori eikin debeinyi wagitur aria ibuhi ini eikin dodog aria eikit dodogowiti lait. ");
INSERT INTO apec_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Aria ihishmorim arpesh ko shuntorum shunaki shiyotu um eikig yomag. Aria eik ko isiyaesh aria shiyotu um biyob lainab, kabi douk anudok neyoh sipsipahos iri nosiya sipsipahos shanak wobrehahum anan lain aria memehos shunak wobrehahum anan lain. ");
INSERT INTO apec_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Eik ko isop sipsipahos um eikin yopunyi rogurehah aria memehos um eikin angagrin rogur. ");
INSERT INTO apec_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Namudok aria eik king ko ikrip ihishmorim arpesh sheyotu um eikin yopunyi rogurehah iri namudok, ‘Ipak douk eikin Yaken nenekumep yopihi aih iri. Anan nakana nenek yopishi eneshenesh um ipak. Ipak yowi ba puwish agundok pupe abrudok wabur Iruhin nape Debeini um ananish arpesh shupeum. Seiwok eikin yaken nagraeh-aburum ipak iri um seiwok sagomatin anan nenek agudok nahobig gatogurum. ");
INSERT INTO apec_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Umum maresh? Seiwok eik yape nyurub bae, aria ipak poke worigun. Eik abar bae, aria ipak poke abar. Eik yanaki kupaigunum iri, aria ipak parao eik panak ipakit urupat. ");
INSERT INTO apec_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Eik rupah uwok, aria ipak poke rupah eik. Eik arugeh hapeye aria ipak pugabe eik. Eik yape shunuweshik-ati urupat, aria ipak panaki patik eik.’ ");
INSERT INTO apec_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Aria eshudok shenek yopihi atih aih iri aria shape yopinyi poe iri ko shukripan namudok, ‘Debeini um meibi nyutob apak matik nyak nyurub baen, aria apak meken worigun nyak? Aria um meibi nyutob nyak abar baen aria apak meken abar nyak? ");
INSERT INTO apec_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Umum meibi nyutob apak matik nyak nyanaki kupaiburi wabur, aria apak marao nyak manak apakit urupat? Aria um meibi nyutob nyak rupah uwok, aria apak meken rupah nyak? ");
INSERT INTO apec_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Umum meibi nyutob apak matik nyak arugeh hape nyak aka, nyak nyape shunuweshik-ati urupat, aria apak manaku matrin?’ ");
INSERT INTO apec_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","“Aria eik ko ikripesh namudok, ‘Eik anudok king yakripep adurin baraen, ihishmorim eneshenesh ipak penekeshum enen enyudok arpenyum amudok eikim owarhim nyeiguhw wokam iri, eshudok eneshenesh ipak penekeshum eik.’ ");
INSERT INTO apec_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Aria eik king ko ikrip eshudok sheyotu um eikin anagagrin um rogurehah iri namudok, ‘Ipak yoweipari ko punak puwishukuk iri, ipak pruwokukum eik aria ipak kare panak um ehudok yoweihi nyih madae hugok iri uwe, uwok. Ehudok yoweihi nyih seiwok shenekeh shagraeheh um Satan nani ananish yoweishi enselahos iri. ");
INSERT INTO apec_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Umum maresh? Seiwok eik yape nyurub bae, aria ipak madae puke worigun uwe, uwok. Eik abar bae, aria ipak madae puke abar uwe, uwok. ");
INSERT INTO apec_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Eik yanaki kupaiburi wabur iri, aria ipak madae purae punak ipakit urupat uwe, uwok. Eik rupah uwok, aria ipak madae puke rupah uwe, uwok. Eik arugeh hapeye, aria eik yape shunuweshik-ati urupat aria ipak madae punaki putik eik uwe, uwok.’ ");
INSERT INTO apec_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Aria eshesh shopunek ko shukripan namudok, ‘Debeini, um meibi nyutob apak matik nyak nyurub baen aka, nyak abar baen aka, nyak nyanaki kupaiburi wabur iri aka, nyak rupah woken aka, nyak arugeh hapeyen aka, nyak nyape shunuweshik-ati urupat, aria apak madae gamo mugabeyen uwe, uwok?’ ");
INSERT INTO apec_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","“Aria eik ko ikripesh namudok, ‘Eik yakripep adurin baraen, eneshenesh ipak madae punekeshum enenyum enen enyudok arpenyum amudok eikim owarhim nyeiguhw wokam iri, eshesh eshudoki eneshenesh ipak madae punekeshum eik shopunek uwe, uwok.’ ");
INSERT INTO apec_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","“Aria eshudok arpesh ko shunak shurao yoweinyi poe, ko shurao debeiri eriger madae rutuh uwe iri uwe, uwok. Aria yopishi arpesh eshesh ko shuwish um yopinyi poe aria shupe wosik ihih nyumneh.” ");
INSERT INTO apec_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Jisas nakripesh enyudok ihinyumorim baraen nyatuh aria nakrip ananim disaipel namudok, ");
INSERT INTO apec_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Ipak padukemesh, nyumneh douk watak hape biyehum ahudok nyumnah agundok debeguni Pasovaigun worigun nenenekum ko hutogur. Aria eshesh ko shere Eik Anudok Arman yatogur adurinyi arpen iri um horim amamis wis aria hanak henek nyilime rowogin kruse aria igok.” ");
INSERT INTO apec_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Umum abudok nyutob amam debeimi pris hani eshesh Juda esheshim debeimi hanak hatik esheshin debeini pris Kaiafas aria hantorum hape ananit urupat. ");
INSERT INTO apec_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Aria hantorum hape heyagwreh habo baraen hakri huparug anah yah aria hugiyagik husuhw Jisas aria hunak hon nugok. ");
INSERT INTO apec_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Aria hakri namudok, “Apak ta mare mukana munek eshudok enesheneshum abudok nyutobum agudok debeigi nig uwe, uwok. Umum maresh, ta arpesh shutik aria shukri shukitakum debeihwi wanohw.” ");
INSERT INTO apec_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Jisas douk nape wabur Betani. Nape anan arman shahwaran um Saimon iri ananit urupat. Nubo riguk anudok Saimon yoweihi arugeh lepra hapeyan. ");
INSERT INTO apec_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Abudok nyutob Jisas nape huruk atinyum tebol aria nape nawok worigun, aria onok armatok kwasuhwi enen yopunyi sanda douk shatorin debeibori utabor iri. Nyorori anar yopuri botol douk shenekor anam utom iri aria kwanaki kwouraken nyabuh iruhum Jisas ananig barag. ");
INSERT INTO apec_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Amudok Jisas ananim disaipel hatik namudok aria akas sanum. Aria hakri namudok, “Umum maresh ba okwok kweyatak enyudok sanda meyoh? ");
INSERT INTO apec_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Enyudok sanda apak mukri ba munek salimen akure, ta musuhw debeibori utabor aria manak musiyaborum eshudok eneshenesh wokeshi arpesh.” ");
INSERT INTO apec_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Jisas nadukemeshum amamin baraen aria nakripam namudok, “Umum maresh ba ipak peyagwreh ponawarukok um okwudok armatok? Okwok douk kwonegesh yopuhi aih um eik. ");
INSERT INTO apec_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Ihib nyutob eshudok eneshenesh wokeshi arpesh ko shuni ipak pupe. Aria eik ko mare ini ipak mupe roubi nyutob uwe, uwok. ");
INSERT INTO apec_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Okwudok armatok kwourak sanda eikihw yegenyihw, okwok kwonegesh namudokum kugabe eikihw yegenyihw um nuhut biyen shurme wonugwehw um. ");
INSERT INTO apec_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Eik yakripep adurin baraenyum ihigunum um agudok nahobig kweipon shunak ba shukripesh enyudok Iruhin ananin yopinyi baraenyum. Eshesh ko shiyagwrehum eshudok eneshenesh douk okwudok armatok kwonegeshi shopunek, aria esheship urkwip ko purum okwok.” ");
INSERT INTO apec_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Aria abudok nyutob, ananum amudok Jisas ananimum 12-poreim disaipel douk shahwaranum Judas Iskariot iri nanaki natik amam debeimi pris. ");
INSERT INTO apec_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Nanak aria narigam namudok, “Douk eik irigumep um yah inak iwerehemep Jisas um, ipak douk ko putoruwe puke maresh?” Hemnek namudok aria hatorun hakon 30-poreibor siliwaibor utabor. ");
INSERT INTO apec_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Namudok aria Judas nape nabo urkum naurim yahum nuwereh aria niyabigam aria nukom Jisas um amudok amamis wis. ");
INSERT INTO apec_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Aria um ahudok harik iri nyumnah um eshesh Juda shenek agundok debeiguni Pasovaigun worigun aria shawok bret douk shoteh ba madae tikitak tunugok tutogur debeiti uwe, uwok. Amam disaipel hanakium anan Jisas aria harigan namudok, “Nya, nyak nyakri apak monak munek agnudok Pasovaigunworigun agnumum nyak nyanak nyugnoh nyini apak?” ");
INSERT INTO apec_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Aria nakripam namudok, “Ipak panak puwish debeiburi wabur Jerusalem aria punam anudok arman douk yakripep-uman iri. Punak aria pukripan pukri namudok, ‘Nya, apakin Tisa nakri ananib nyutobdouk ko huruk atinyum butogur. Aria nakri anan nini ananim disaipel ko hunaki huwok agundok Pasovaigun worigun nyakit urupat.’” ");
INSERT INTO apec_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Namudok aria amam hanak henek eshudok kabi douk Jisas nakripamum. Hanak aria henek agundok Pasovaigun worigun. ");
INSERT INTO apec_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Douk arigaha wabigep hurukatinyum wab aria Jisas nani ananim 12-poreim disaipel hanaki hape herharih tebol. ");
INSERT INTO apec_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Amam hape apa hawok worigun, aria nakripam namudok, “Eik yakripep adurin baraen ipak, anan um ipak ko noko eik um eikim horim.” ");
INSERT INTO apec_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Aria amam disaipel hemnek namudok aria amamish urkum apahw yowesh, aria amam atun atun harig Jisas namudok, “Debeini nyak nyakri eik aka?” ");
INSERT INTO apec_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Aria Jisas nakripam namudok, “Anudok arman douk nakana noko eikum eikim horim iri, anan douk ananum ipak kanak douk nani eik ta aragarag ukutu ohwakis wis sani bret shubuh yaurehw iri. ");
INSERT INTO apec_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Eik Anudok Arman yatogur adurinyi arpen iri ko igok, namudok Iruhin ananik buk kwakri jurugum eik ko igok. Aria ko debeinyi gihaum anudok arman noko Eik Anudok Arman yatogur adurinyi arpen iri um horim amamis wis iri. Namudok aria seiwok wosik ba amakek mare kwunabuki uwe, uwok.” ");
INSERT INTO apec_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Judas anan douk anudok arman nakana noko Jisas um horim amamis wis iri anan narik Jisas namudok, “Debeini Tisa nyak douk nyakri eik aka?” Aria Jisas nakripan namudok, “Namudok nyak nyakrium.” ");
INSERT INTO apec_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Amam apa hawok worigun aria Jisas nohur anabik bretigun, nenek tenkyu um Iruhin aria nawor bret, aria noko ananim disaipel. Aria nakri namudok, “Ipak suwot bret aria putoh. Atudok bret douk eikihw yegenyihw.” ");
INSERT INTO apec_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Aria nohur anap wainip kap, aria nenek tenkyu um Iruhin aria nako ananim disaipel aria nakri namudok, “Ipak suwop kap aria ipak ihipmorim pubroh apudok kap. Anudok wain douk eikibor owishibor. ");
INSERT INTO apec_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Anudok wain douk eikibor owishibor douk ko benek enyudok Iruhin ananin adurin atinyi baraen kontrak nyutogur dodogowin abom. Umum maresh? Eik yourak eikibor owishibor um bukweshihuk yoweishi inahos um sabaishi arpesh iri. ");
INSERT INTO apec_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Eik douk yakrip ipak, eik ko mare ta iwok wain arigaha kweipon eik ta iwok namuni wain ini ipak gani numunum agundok arpesh shuwishum eikin Yaken nape debeinarium ananish arpesh um.” ");
INSERT INTO apec_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Aria amam heyorub anohw awehw aria hanam Olivihw yoduhw. ");
INSERT INTO apec_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Hanak hakih ahwodok Olivihw yoduhw aria Jisas nakripam namudok, “Kwehigib wab, ipak ihipmorim ko puruwokuk um eik punak atun atunuk. Umum maresh? Baraen nyetem Iruhin ananik buk iri douk nyakri namudok, ‘Eik ko ibo neyoh sipsipahos iri, aria ihishmorim sipsipahos ko shuruwok shunak atin atinyuk.’ ");
INSERT INTO apec_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","“Aria eik ta ko ta ikitakum eshudok shagokum, aria eik ko irik inak um ipak gani shokugi nahobig Galili.” ");
INSERT INTO apec_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Aria Pita nakrip Jisas namudok, “Amam kupaimi disaipel ko hutik eneshenesh shutogurum nyak ba ta hukutukuk amamip bilip um nyak aria huruwok aria amam wokim ko huruwok, aria eik ta mare iruwok ba inyukwreny-ukuk uwe, uwok. Aria upe biohw.” ");
INSERT INTO apec_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Aria Jisas nakripan namudok, “Eik yakripen adurin baraenyum douk abudok wab. Nyak ko nyukri nyigiyagig-umesh biyeh atih namudok, Nyak madae nyudukem eik uwe, uwok. Aria owot ko tukitak tiyagwreh.” ");
INSERT INTO apec_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Aria Pita nakripan namudok, “Eik ko mare igiyagig aria ikri eik douk madae idukem nyak uwe, uwok. Eshesh ko shukana shubo nyak nyugokum, aria eik shopunek ko ini nyak ugok ahudok atuh nyumnah.” Aria amudok ihim-morim ananim disaipel douk hakripan enyudok atin baraen. ");
INSERT INTO apec_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Jisas nani ananim disaipel hanam anabik shuhwar-agunum Getsemani. Aria nakripam namudok, “Ipak hagipe agundok, aria eik ko inak ganudok ba inek beten.” ");
INSERT INTO apec_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Aria anan narao Pita nani Sebedi ananim biom nagamim heiran hanak. Aria ananish urkum apahw amaenyish atish aria amu nemnek yowiyokuk abom. ");
INSERT INTO apec_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Aria nakrip amam namudok, “Eikish urkum apahw amaenyish atish aria hurukum eik yakana igok. Ipak pupe agundok puni eik aria pupe piyohe.” ");
INSERT INTO apec_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Aria anan nanaku rourougunugu shopunek. Aria natu nabuh atap nobuk ananig yomag iruhw amnab aria nenek beten namudok, “Eikin Yain, nyak nyukri wosik um aria nyitiweiguk enyudok debeinyi amain nyakana nyutogurum eik iri. Eik yakri nyak mare nyigipesh eikish urkum apahw shakri um uwe, uwok. Eik yakri nyak wosik ko nyigipesh nyakish urkum apahw shakri um aria ta wosik.” ");
INSERT INTO apec_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Aria Jisas ta natanamum amudok bimatun disaipel, aria natik amam heshuh hakuh. Aria narik Pita namudok, “Namudok penekesh mumam? Ipak mare ta dodogeship aria puname pupe piyoh eik um enen aua aka, uwok? ");
INSERT INTO apec_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Ipak douk puname pupe piyoh eik aria penek beten ba pupe. Uwok um enesh yoweishi shanaki aria ipak ta pugrukium ipakin bilip. Adur atin, apakish urkum apahw shakana shenek eneshenesh, aria apakihw yegenyihw atuhw douk arigeh hwahw aria dodog uwok um hwonek enesh muguhwos.” ");
INSERT INTO apec_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Anan ta natanam biyeh aria nenek beten namudok, “Eikin Yain, douk enyudok amain nyakana nyutogurum eik iri ko mare nyushagrakuk eikum, ba eik ko isah enyudok amain, aria nyak wosik ko nyigipesh nyakish urkum apahw shakri um aria ta wosik”. ");
INSERT INTO apec_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Aria anan ta natanamori um amam disaipel aria natik amam watak heshuh. Umum maresh? Amamis nabes amaenyis atus um hishuh atin. ");
INSERT INTO apec_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Aria anan ta nakutumukuk aria nanak nenek beten bihatuh ahi, aria nenek apunin beten kabi douk nenekan sagomatinyum. ");
INSERT INTO apec_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Aria ta natanamori um amam disaipel aria nakripam namudok, “Ipak watak apa peshuh aria purao uhwin aka? Pemnek. Nyutob iganigadae batogur aria eshesh shakana shoko Eik Anudok Arman yatogur adurinyi arpen iri um amudok armam henek yoweishi inahos iri um amamis wis. ");
INSERT INTO apec_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Ipak kitak, aria apak monak. Putik, arman nakana noko eikum horim amamis wis iri, anudok douk iganigadae nanaki hurukum apak.” ");
INSERT INTO apec_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Jisas watak apa neyagwreh aria Judas, anan douk anan um amudok 12-poreim disaipel nanak natograri. Sabaishi arpesh sheiran aria eshesh sharauri bainatog gwani rowos. Amam debeimi pris hani eshesh Juda esheshim debeimi heshopokesh aria shanaki. ");
INSERT INTO apec_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Anudok arman nakana nokam Jisas um horim amamis wis iri, watak apa shanaki yah aria nakripamum enen kak namudok, “Eik ko inopuprik anan arman. Aria anudok arman douk anan atun Jisas. Aria ipak gamo pusuwan.” ");
INSERT INTO apec_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Aria anan arigas atin nanamori Jisas aria nakri namudok, “Yopubi wab, Tisa.” Aria Judas nanapuprik Jisas. ");
INSERT INTO apec_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Aria Jisas nakripan namudok, “Arpenyin, eneshenesh nyak nyanaki um nyenekesh iri, nyak arigas ba nyenekesh.” Aria anam armam hanaki howeman wis Jisas aria hasuwan hape dodog. ");
INSERT INTO apec_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Aria anan arman neyotu nani Jisas iri, nauruki ananit bainat. Aria anan nabo debeini pris ananin neneman mour meyoh iri aria narpogesh anudok ananih atah takaroh habuhuk atap. ");
INSERT INTO apec_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Aria Jisas nakripan namudok, “Ta rukwot bainat tubuh tutuk agnudok douk torum. Ihish arpesh sharpak bainatog iri, bainatog ko gununu eshesh. ");
INSERT INTO apec_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Aria nyak madae nyudukemesh uwe, aka? Eik ko iyorik eikin Yain um aria anan ko neshopoki sabaishi enselahos, shenek uhwinyum 12-poreib amiyeb lainab, aria eshesh ko shunaki shutaurum eik. ");
INSERT INTO apec_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Aria eik ko ibirak namudok um, aria baraen nyetem Iruhin ananik buk iri ko mare nyutogur adurin baraen uwe um eik, uwok. Iruhin ananik buk kwakri eshudok eneshenesh adur atin ta shutogurum eik.” ");
INSERT INTO apec_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Umum abudok atub nyutob Jisas ko nakrip eshudok ihishmorim arpesh namudok, “Ipak pasuhwi bainatog aria rowos aria ipak panaki um gamo pusuhw eik, kabi da ipak pakana gamo pusuhw anan arman nenek wanohw aria nakwuaruh iri aka? Ihihmorim nyumneh eik yape gani numun narub um Iruhin ananit debeiti urupat tataoum, aria yape yakripesh Iruhin ananin yopinyi baraen um arpesh. Aria umum maresh ba ipak madae pusuhwe nabudok nyutob uwe? ");
INSERT INTO apec_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Aria eshudok ihish eneshenesh douk shatogurum shagim amam profet henyemaguk iri baraen nyatogur adur atin.” Aria amudok ihim disaipel hakutukuk Jisas aria haruwok. ");
INSERT INTO apec_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Eshudok arpesh shasuhw Jisas iri eshesh sharan shanak um debeini pris Kaiafas ananit urupat. Eshesh Juda esheshim debeimi hani amam henek skulumesh um Iruhin ananin lo iri amam douk hantorum hape numun urupat. ");
INSERT INTO apec_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Pita nagipeshuk Jisas nanak, aria madae nanak huruhuruk um anan uwe, uwok. Anan nanak nawish numun narub um anudok debeini pris ananit urupat. Aria nani amam henek mour heyoh Iruhin ananit debeiti urupat iri hape. Anan nakana nutik maresh muguhwos ta shutogurum Jisas. ");
INSERT INTO apec_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Amam debeimi pris hani sabaimi debeimi Juda douk hape hasuhw kwotog iri hahwar anam armam hanaki. Douk hanaki aria hape hakri humnek enen nyunagiyagigi baraenyum Jisas nenekahi aihum amam debeimi humnek. Aria amam hakana huparug enen yoweinyi ina Jisas nenekenyi aria hon nugok. ");
INSERT INTO apec_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Sabaimi armam hanaki henek rohwuman um nyunagiyagigi baraenyum anan. Aria amam madae huwereh enen adurin yoweinyi ina anan nubokadae nenekenyi-umum ta shon nugokumenyi baraen uwe, uwok. Aria biom hanaki ");
INSERT INTO apec_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","hakri namudok, “Anudok arman seiwok nakri namudok, ‘Eik dodogoiwe um ko ibrik Iruhin ananit debeiti urupat aria ta itanam irakotum bihatih nyumneh.’” ");
INSERT INTO apec_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Aria debeini pris nakitak neyotu narig Jisas namudok, “Nyak wosik um ta nyuwanam enen amamin baraen aka, uwok? Nyak nyakri mumamum enyudok baraen douk amudok henekenyum nyak iri?” ");
INSERT INTO apec_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Aria Jisas madae nukri enen baraen uwe, uwok. Aria anudok debeini pris nakripan namudok, “Eik douk yakana iyorik nyakum Iruhin ananin nyeigur anudok Iruhin madae nugok iri aria nape atun nape iri, aria nyak ta nyukripe adurinyi atin baraen. Nyak kripap, nyak douk anudok arman Iruhin nagraehenyum neshopoken nyanaki iri aka, uwok? Nyak douk Iruhin ananin Nuganin aka, uwok?” ");
INSERT INTO apec_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Aria Jisas nakripan namudok, “Nyak kanak douk nyakriyen jurug. Aria eik yakrip ipak, kweipon ipak ko putik Eik Anudok Arman yatogur adurinyi arpen iri ipeum anudok Dodogowini Iruhin ananin yopunyi rogurehah. Aria eik ko ipe iruhum hevenig utag aria inaki.” ");
INSERT INTO apec_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Aria anudok debeini pris nakitak yowiyokuk um enyudok baraen aria nabrig ananih rupah aria nakri namudok, “Anan douk nabubunim Iruhin. Apak mare muhwari anam shopunek armam hukripapum anudok armanih yoweihi aih uwe, uwok. Douk atin ipak pemnek anan nabubunim Iruhin jurug. ");
INSERT INTO apec_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Ipak pakana apak ta munekan mumam anudok arman?” Aria amam hakri namudok, “Anan douk nenek yoweishi inahos aria anan apak mon nugok.” ");
INSERT INTO apec_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Aria eshesh shokuseh Jisas ananig yomag aria shakwu wis shabo anan. Aria enesh shabo ananish popaeshohos ");
INSERT INTO apec_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","aria shakri namudok, “Nyak douk Iruhin nagraehan iri aka, aria nyak douk ta nyukripap kabi da amam profet henekeshum. Eshudok arpesh shabo nyak iri, eshesh douk amiapen?” ");
INSERT INTO apec_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Pita nape aduk, aria numunum urupatirub narub um Kaiafas ananit urupat. Aria onok weroroikwi kwonek mour iri kwanaki kwatrun aria kwakripan namudok, “Nyak douk anabik nyani anudok Jisas douk nanaki shokugi nahobig Galili iri pape.” ");
INSERT INTO apec_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Aria Pita nakri uwok um ihishmorim arpesh esheshis nabes namudok, “Eik madae idukemeshum enyudok baraen nyak nyakriyen iri uwe, uwok” ");
INSERT INTO apec_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Aria anan nanak natogur urupat adukum arbudok narubit wit, aria kupaikwi kwonek mour iri kwatrun aria kwakrip eshudok shape huruhuruki namudok, “Anudok arman nubo rig nape nani Jisas anudok Nasaret-epimin iri.” ");
INSERT INTO apec_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Aria Pita ta nakri uwok namudok, “Adur iruhw, eik madae idukemeshum anudok arman uwe, uwok.” ");
INSERT INTO apec_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Roubi nyutob shopunek aria armam heyotu huruhuruk iri hanaki hakrip Pita namudok, “Adur atin, nyak douk shopunek ananum eshudok arpesh shape shani Jisas iri, nyakip nanup douk powereh nyak.” ");
INSERT INTO apec_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Namudok aria Pita neyagwreh dodog namudok, “Adur iruhw, eik madae idukemeshum anudok arman uwe, uwok. Eik mare iyagwreh adurin baraen, aria Iruhin ko nununu eik ba igok.” Anan nakriyen jurug, aria atub nyutob owot takitak tohwar. ");
INSERT INTO apec_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Aria Pita urkum morum enyudok baraen Jisas iganigadae nakripanum, “Owot mare tuhwar uwe, nyak ko nyukriyen bihatuh namudok nyak madae nyudukem eik uwe, uwok.” Aria Pita natogur aduk ba nereh yowiyokuk abom. ");
INSERT INTO apec_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Gagruk ruwahep wehip, aria ihim-morim debeimi pris hani eshesh Juda esheshim debeimi hape heyagwreh aria habo baraenyum hubo Jisas nugok. ");
INSERT INTO apec_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Aria hakitak haweshikan onohw dodogoihwi maduhw aria haran hanam Pailat douk nape debeini gavman iri. ");
INSERT INTO apec_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Anudok Judas douk nowereh Jisas aria nako horim um amamis wis, anan natik agundok eshesh shagiyagim Jisas um kwot aria shakon debeinyi amaenyum anan. Namudok aria ananish urkum apahw yoweshum ahudok yoweihi aih anan nenekohum Jisas iri. Aria anan ta nenek giha abom numun um ananish urkum apahw. Aria natanam narao abrudok 30-poreibor siliwaibor utabor douk amam debeimi pris hani eshesh Juda esheshim debeimi hakanabor um anan iri. ");
INSERT INTO apec_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Aria nakripam namudok, “Eik douk yenek yoweishi inahos jurug. Aria anudok arman eik yowerehanum ipakis wis iri, anan douk madae nenek enen yoweinyi ina uwe, uwok. Aria ipak kwehig pon nugok meyoh.” Aria amam hakripan namudok, “Nyak nyanaki nyakrip apak um maresh? Enyudok nyakin mour.” ");
INSERT INTO apec_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Aria Judas nawashakuk abrudok siliwaibor utabor numunum Debeini ananit urupatirub narub, aria nanak nanatog onohw maduhw ananin aruhwigur aria naprok ba nataur aria nagok. ");
INSERT INTO apec_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Amam debeimi pris hohur abrudok siliwaibor utabor aria hakri namudok, “Abrudok utabor douk maborubukum arman nagokum. Aria apakin lo douk nyakri abrudok utabor apak mare muborubukum abrudok bakus numun Iruhin ananit debeiti urupat iri uwe, uwok.” ");
INSERT INTO apec_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Aria habo atin baraenyum abrudok utabor amam hator anab amnab um arpesh apa shatuk amnab ba shenek amnabis marus iri. Amam hanak hator abudok amnabum butogur wonugwegwiruh hapeim um arpesh shurom eshudok arpesh shagoki shanaki rougunum iri. ");
INSERT INTO apec_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Namudok aria abudok amnab douk shahwarab um, “Owishiboribi amnab” aria douk arpesh wata apa shohwarab enyudok nyeigur. ");
INSERT INTO apec_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Namudok aria enen baraen seiwok Iruhin nohur profet Jeremaia nenyemaguk iri nyatogur adurin atin. Baraen enyudok nyakri namudok, “Hakitak hohur abrudok 30-poreibor siliwaibor utabor. Abrudok utabor douk eshesh Israel shaborubuk um shutor anudok arman iri. ");
INSERT INTO apec_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Aria haboruhur hanak hatik eshesh apa sharok amnab um amnabis marusum aria hator anab amnab. Iruhin douk nakripe dodogowinyi baraen namudok aria yeyagwrehen.” ");
INSERT INTO apec_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Harao Jisas hanak honusop neyotu natik anudok debeini um gavman iri aria narigan namudok, “Nyak douk eshesh Juda esheshin king aka?” Aria Jisas nakripan namudok, “Adur atin, eik douk kabi nyak nyakrium.” ");
INSERT INTO apec_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Eshesh Juda esheshim debeimi hani debeimi pris hagiyagig haduk sabainyi baraenyum Jisas. Aria anan madae nutanam niyagwreh enen atin baraen uwe, uwok. ");
INSERT INTO apec_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Namudok aria Pailat ta narigan shopunek namudok, “Nyak douk madae nyemnek enyudok ihinyumorim baraen amam henemen kwot-enyi?” ");
INSERT INTO apec_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Aria Jisas madae niyagwreh enen baraenyum Pailat uwe, uwok. Namudok aria Pailat nor urkum manak matuhukuk meyoh. ");
INSERT INTO apec_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Um ihish kwarahos ahudok nyumnah shenek agundok debeiguni Pasovaigun worigun obi nyutob, anudok nape Debeini gavman iri douk ko nokweshih anan nanaweshik iri um shunuweshik-ati urupat. Eshesh arpesh eshesh kanak ko shukri nyeigurum anan arman nape nanaweshik iri, aria Pailat ko nukweshih anudok arman nanam eshudok arpesh. ");
INSERT INTO apec_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Aria um abudok nyutob douk anan yoweini nanaweshik aria nape shunuweshik-ati urupat, ananin nyeigur douk Barabas. ");
INSERT INTO apec_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Eshesh eshudok arpesh iganigadae shantorum shanaki sheyotu, Aria Pailat narigesh namudok, “Ipak pakana eik ta ikweshih amiapen nyunamogu ipak? Eik ta ikweshih Barabas aka, eik ta ikweshih Jisas eshesh douk shakana Iruhin nagraehan aria neshopokan nanaki iri?” ");
INSERT INTO apec_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Aria Pailat nakri namudok. Umum maresh anan nadukemeshum eshesh douk esheshish urkum apahw douk yoweshum Jisas meyoh, aria sharan shanamorim kwotog. ");
INSERT INTO apec_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Aria shopunek douk Pailat nape ananin debeinyi nenemesh kwotog-enyi wagitur, ananik irohukwik kwoneki baraen nyunakmori anan namudok, “Nyak mare nyenek enesh muguhwos um enyudok yopunyi arpen uwe, uwok. Eik yeshuh wab aria yatrun anas yomnis, yemnek debeiri eriger um anan aria madae gamo ishuh wab uwe, uwok. Eik yakri enyudok arpen douk yopunyi.” ");
INSERT INTO apec_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Aria amam debeimi pris hani Juda esheshim debeimi hohur eshudok worobaishi arpesh esheshiruh aparuh um shuhwarum Barabas nutograri aria shubo Jisas nugok. ");
INSERT INTO apec_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Aria Pailat narigesh namudok, “Ipak pakana eik ta ikweshihumep meinari arman um amudok biom armam nunamogu ipak?” Aria eshudok arpesh shuhwar namudok, “Barabas.” ");
INSERT INTO apec_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Aria Pailat narigesh namudok, “Aria ipak pakana eik ta inekesh mumam um anudok Jisas eshesh shakri Iruhin nagraehan ba neshopokan nanaki iri?” Aria ihishmorim shohwar debeg namudok, “Punek nyilimanum rowogin kruse.” ");
INSERT INTO apec_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Aria Pailat ta narigesh namudok, “Umum maresh? Anan douk nenek maren debeinyi ina?” Aria eshesh shuhwar debeg abom, “Punek nyilimanum rowogin kruse.” ");
INSERT INTO apec_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Aria Pailat nadukemesh namudok, eshesh ko mare shumnek ananin baraen uwe, uwok. Aria debeihwi wanohw huruhuruk um hutogur. Aria anan nohur anabar abar aria nakrup ananis wisum ihishmorim arpesh esheshis nabes. Aria anan nakri namudok, “Eik inahos uwok um anudok arman ananin gok uwe, uwok. Ipak kanak pakri ba eshudok eneshenesh shenenek.” ");
INSERT INTO apec_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Aria ihishmorim arpesh shakri namudok, “Eshudok inahos ko shupeum apak aria um apakish batowish.” ");
INSERT INTO apec_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Namudok aria Pailat nakweshih Barabas nanam eshesh. Aria anan nakri ba amam soldia hakwu nyiguhw hweirohi maduhw aria habo Jisas yowiyokuk. Aria nakom Jisas um soldia amamis wis um hunak henek nyilimanum rowogin kruse. ");
INSERT INTO apec_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Aria Pailat ananim soldia harao Jisas hawish debeini gavman esheshit urupat. Hawish aria ihim-morim soldia hanaki heyotu herharihan. ");
INSERT INTO apec_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Aria hatrun howaruk ananih rupah aria hereman anah owishiborihi rupah. ");
INSERT INTO apec_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Aria harauri onohw maduhw kabi da pruwehwihw um aria hadarohw hohwunug kabi anan king ananit hat um aria hahwemuman ananig barag. Aria horuman anag shokugi akodiwok ananis wis aria habuh hoduk ohrubus hape henekan enenyenen habubuniman hakri namudok, “O wosik ruwahep nyak eshesh Juda esheshin king.” ");
INSERT INTO apec_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Aria amam hakusehan, aria hatrunari agudok akodiwok iganigadae hagur ananis wis iri aria amam habo ananig barag worobaihi abom. ");
INSERT INTO apec_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Douk henekan enyudok enenyenen habubuniman ba jurug aria ta hatrun howaruk ahudok owishiborihi rupah aria ta hereman anan kanak ananih rupah. Aria haran hanak um henek nyiliman um rowogin kruse. ");
INSERT INTO apec_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Douk hakutukuk wabur aria hatogur hanak huruk atinyum yah, aria amam soldia hatik anan arman nanaki wabur Sairini ananin nyeigur Saimon. Aria amam hasuwan harani ba grok atin hakripan um nutrun rowog kruse Jisas nutauruman aria nunyusah-uman. ");
INSERT INTO apec_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Aria eshesh shanak shatogur onok outuk nyeigurikum Golgota. Enyudok nyeigur douk shakri agudok mihig gape kabi da arpenyik barag um. ");
INSERT INTO apec_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Aria um okwudok outuk armam hakon Jisas anan yoweini wain douk hasharan nani yoweini marasin aria nanagugwi nor ba nubutin atun iri. Aria Jisas nakwiraeh um nubroh aria uwok, madae nubroh anudok wain uwe, uwok. ");
INSERT INTO apec_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Amam soldia hawaur Jisas jurug iruhum rowogin kruse aria habirak anag baunag kabi da satu um hutik amiapen kadak nyenek uhwinyum aria husia rupah eneshenesh orokohunum amam kanak. ");
INSERT INTO apec_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Aria amam habuh hape atap um okwudok outuk aria apa heyohan. ");
INSERT INTO apec_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Aria iruhum ananig barag douk howem enyudok baraen douk shenyemuman um kwot iri nyape. Aria baraen nyetem iri nyakri namudok, ");
INSERT INTO apec_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Aria huruhuruk um Jisas amam howaur biom armam hakwu-orugwih iri aria habo arpesh iri douk shopunek shenek nyilimam heir wobuwobur um Jisas. Anan neir um yopunyi rogur ehah aria anan neirum anagagrin rogur ehah. ");
INSERT INTO apec_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Aria arpesh sharahaen yah iri shenek yowi kare shatrun aria sheneyagwreh enenyenen shabubunim Jisas. Eshesh shegigiyarig um baragos, ");
INSERT INTO apec_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","aria shakri namudok, “Nyak anudok arman douk nyakana nyubrig Iruhin ananit debeiti urupat aria ta nyurukat nyutuhur tiyotu um bihotih nyumneh atih iri aria nyak maresh sheneken ba mare ta nyutaurum nyak kanak. Aria enyudok douk adurin baraenyum nyak douk Iruhin Ananin Nuganin um, namudok aria nyak kitak buhi ba kutukuk nenyudok kruse.” ");
INSERT INTO apec_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Amam debeimi pris hani amudok henek skulumesh um lo iri aria hani amam eshesh Juda esheshim debeimi, amam douk shopunek henekan enenyenen habubuniman namudok atin. ");
INSERT INTO apec_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Amam hakri namudok, “Anan nataurum kupaishi arpesh, aria anan ko mare nunugabe anan kanak uwe, uwok. Anan douk Israel esheshin king um, aria anan ko nukutukuk rowogin kruse ba nukitak nubuhi, aria apak ko munek bilipum anan. ");
INSERT INTO apec_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Anan nenek bilipum Iruhin aria nakri namudok, ‘Eik Iruhin Ananin Nuganin.’ Aria douk Iruhin nukri nunuwasham anan abom um, aria Iruhin ko nutauruman.” ");
INSERT INTO apec_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Aria amudok biom hakwu-orugwih iri hataur hurukum Jisas iri, amam shopunek heyagwreh atatahin baraen habubunim Jisas-enyi. ");
INSERT INTO apec_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Umum aruh 12 kilok, wab babuh aria beyawiyom ihigunum agudok shokugi Judaig nahobig arigaha 3 kilok. ");
INSERT INTO apec_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Arigaha nyutob batogurum binyatin aua um 3 kilok aria Jisas nahwar debeg namudok, “Eli, Eli, lema sabaktani?” Enyudok baraen nyakri namudok, “Eikin Iruhin, Eikin Iruhin, umum maresh ba nyak nyakutukuk eik?” ");
INSERT INTO apec_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Enesh arpesh sheyotu huruhuruk, shemnek enyudok baraen aria shakri namudok, “Anudok arman nahwarum Elaija.” ");
INSERT INTO apec_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Aria anan arman arigas atin nanak nohuri enen spansnesegwrin anan nubutini wain. Douk spans shuknin, natuken naweshiken anag akodiwok aria nako Jisas um nubroh. ");
INSERT INTO apec_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Aria kupaishi shakri namudok, “Yotu! apak ko apa mutrugun ba iyoh, um Elaija ko nanaki natauruman aka, uwok?” ");
INSERT INTO apec_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Aria Jisas ta shopunek nahwar anah debeg abom aria ananis yapis sakihuk aria nagok. ");
INSERT INTO apec_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Aria um abudok atub nyutob ahudok debeihi rupah heirnumun Iruhin ananit debeiti urupat iri puwaroh um biyeh gani iruhw arigaha habuh atap. Aria enyik kwatukum amnab shopunek aria debeibori utabor pupuwarobor. ");
INSERT INTO apec_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Aria wonugwegwiruh hanupok aria sabaishi Iruhin ananish yopishi arpesh seiwok shagok ba sharomesh iri ta shakitak shape. ");
INSERT INTO apec_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Shakutukuk wonugwegwiruh shakitak shape arigaha douk Jisas shopunek nakitaki aria eshesh shanak shawish abrudok Iruhin ananibur wabur Jerusalem. Shanak shawish aria worobaishi arpesh shatrish. ");
INSERT INTO apec_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Debeini soldia nani amudok douk hani anan hape heyoh Jisas iri hatik enyik kwatuk um, aria hatik ihishmorim eshudok shatogur iri aria hanogugur abom. Aria hakri namudok, “Adur atin, anudok arman douk Iruhin Ananin Nuganin.” ");
INSERT INTO apec_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Sabaiwi armago shopunek weyotu madae rougun abom uwe, uwok. Aria apa watiki eshudok sheyotu hurukum rowog kruse iri. Owo douk wagipesh Jisas gani Galili wanakium unemon garibog um eneshenesh iri. ");
INSERT INTO apec_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Oudok sabaiwi armago, bio owo douk atin nyeigur Maria. Onok douk kwanaki wabur Makdala. Aria onok douk Jems nani Josep amamik amakek. Aria okwudok onok douk Sebedi ananim nugamim amamik amakek. ");
INSERT INTO apec_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Arigaha wabigep aria anan arman douk noruk worobaibori utabor iri nanaki. Ananin nyeigur douk Josep nanaki wabur nyeiguriburum Arimatea. Anan douk nagipesh Jisas iri. ");
INSERT INTO apec_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Anan nanaki nanam Pailat aria narik ananum nubre Jisas ananit mukut aria nunak nuruman. Aria Pailat nakri wosik aria nakrip amam soldia um hubreyanari rowog kruse aria hokonan. ");
INSERT INTO apec_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Aria Josep natrum Jisas aria neshurehan anah namuhi shigorihwihi rupah. ");
INSERT INTO apec_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Aria Josep narao mukut nanak nawish natemukuk anan kanak ananihw wonugwehw. Ahwodok wonugwehw ohohw onohw umunihw riguk Josep nakrip anam armam harukohw hwawish anabik neirumum utaboriyu burbudu wotaum. Aria Josep nabadigi anam debeimi utom manaki mutapok witegurum ahwudok umunihw. Anan nenekesh namudok jurug aria anan nanak. ");
INSERT INTO apec_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Aria Maria douk kwanaki Makdala iri kwani okwudok onok Maria wape wobur ehahum wonugwehw aria apa washakamohw. ");
INSERT INTO apec_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Ahudok nyumnah douk eshesh Juda shaurim worigun, mahish aria enesheneshum shenek worigun aria ko shupe shubeim Sabat ba shishohahi nyumnah ahudok hatuh. Aria amam debeimi pris hani amam Farisi hanak hatik Pailat. ");
INSERT INTO apec_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Hanak aria hakripan namudok, “Debeini, apak urkwip porum enen baraen douk anudok arman napeum nenek rohwumesh aria nape nakripesh nakri namudok, ‘Eik ko igok aria hukri bihatuhahi nyumnah aria eik ta ikitakum shagokum aria ipe adur atin.’ ");
INSERT INTO apec_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Namudok aria makri nyak nyukrip amam soldia hunak hupe heyoh gani wonugwehw hwapeim um bihatuh nyumneh. Umum maresh, douk ko ananim disaipel hunaki hukwuman aruh um ananit mukut aria hunek rohwumesh hukri anan douk ta nokitakum shagokum aria nape adur atin. Aria enyudok douk atin shakrienyi baraen nyanagiyagig iri ta nyenek uhwinyum enyudok narik nagiyagik ba nakriyenyi baraen.” ");
INSERT INTO apec_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Douk Pailat nemnek aria nakripam namudok, “Ipak kare purao anam soldia aria punak piyoh wonugwehw um kabi ipak padukemesh um aria dodogowip um punekenyum.” ");
INSERT INTO apec_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Nakripam namudok aria amam hanak henek eneh agushih agundok sharom Jisas um. Heneguk enyudok aria hasopukuk amam soldia heyotu heyoh wonugwehw. ");
INSERT INTO apec_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Ahudok nyumnah Sabat eshesh Juda douk madae shunek mour shape meyohahi douk hatuh. Aria ruwahep wehip Sandeih nyumnahin aun apa nakihi, aria Maria kwanaki wabur Makdala iri kwani kupaikwi atin nyeigur Maria wanaki ruwahep wehip um utik wonugwehw. ");
INSERT INTO apec_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Aria atub nyutob debeikwi enyik kwatuk. Umum maresh, enen Debeini ananin ensel nyakitaki heven aria nyabuhi nyagreshuk utom matapok witegur iri aria nyahagi nyape iruhimum. ");
INSERT INTO apec_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Enyudok enselig yomag genek lait kabi da utag brereyarog um aria enyenyih rupah douk kabi da armir shigorihw um henek lait abom. ");
INSERT INTO apec_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Amam soldia hanogugur um enyudok ensel aria arugoguhwiar wam aria habuh hakuh amnab kabi douk armam hagokum. ");
INSERT INTO apec_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Aria enyudok ensel nyakrip oudok armago namudok, “Ipak mare punogugur uwe, uwok. Eik yadukemesh, ipak douk panamori purim anudok Jisas douk shan shenek nyiliman neir rowogin kruse iri. ");
INSERT INTO apec_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Anan madae ta nukus agundok uwe, uwok. Anan iganigadae ta nakitak um shagok um aria nape, kabi da riguk nakri um. Ipak yowi ba putik outuk agundok shanubuk um. ");
INSERT INTO apec_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Ipak kare arigas atin punak pukrip ananim disaipel namudok, anan nagok aria iganigadai ta nakitak um shagok um aria nape adur atin. Ipak gamo pumnek. Anan ko nurik um ipak aria nunak um shokugi nahobig Galili aria ipak ko punaku putrun ganudok. Eik douk yanakium ikripep um enyudok baraen.” ");
INSERT INTO apec_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Oudok bio watik enyudok ensel aria wanogugur abom, aria shopunek owo wanadudareh abom, aria arigas atin wakutukuk wonugwehw aria wahur wonak um ukrip ananim disaipel. ");
INSERT INTO apec_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Aria Jisas naparago yah, aria nakri namudok, “Ruwahep bio.” Aria owo bio wanak huruhuruk um anan watu wabuh amnab aria wowem owowis wis ananiruh yeriweruh aria wonek lotu um anan. ");
INSERT INTO apec_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Aria Jisas nakripo namudok, “Ipak bio mare punogugur. Ipak kare ba pukrip eikim owarhim um amam disaipel hunaku arigas um shokugi nahobig Galili. Aria amam ta hutik eik ganudok.” ");
INSERT INTO apec_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Oudok bio armago wata apa wonak yahum utik amam disaipel, aria amam soldia heyoh wonugwehw iri hanak hawish abrudok debeiburi wabur Jerusalem. Hawish aria hakrip amam debeimi pris um ihishmorim eneshenesh amam hatrish shatogur iri. ");
INSERT INTO apec_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Aria amudok pris hemnek namudok aria hanak hani eshesh Juda esheshim debeimi hantorum hape habo enen baraen. Aria hakitak hator amudok soldia hakam debeibori utabor. ");
INSERT INTO apec_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Hakam utabor aria hakripam namudok, “Ipak punak penek rohw pukripesh namudok, ‘Apak meshuh wab aria ananim disaipel hanaki hakwuman-aruh aria haran hanak.’ ");
INSERT INTO apec_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Aria douk Pailat debeini gavman iri numnek enyudok baraen um, aria apak ko muni anan miyagwreh ba miyatok baraen. Namudok aria baraen ta mare nyupe ipak uwe, uwok.” ");
INSERT INTO apec_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Namudok aria amudok soldia horao utabor aria hagipesh debeimi amamin baraen. Aria enyudok baraen soldia henek rohw hagiyagig-enyi nyanak nyanaki orokohun um eshesh Judaish arpesh eshesh kanak arigaha nyanaki um abudok doukib nyutob. ");
INSERT INTO apec_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Aria Jisas ananim 11-poreim disaipel hagim yah hanakum agudok shokugi nahobig Galili. Aria hanak hatogur ahwodok yoduhw kabi da Jisas nakripamuk um. ");
INSERT INTO apec_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Hanak hakih hatik Jisas aria henek lotuman hatuk ananin nyeigur nyato gani iruhw. Aria anam amudok hor biyep urkwip aria hakana anudok douk madae Jisas uwe, uwok. ");
INSERT INTO apec_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Aria Jisas nanaki huruhuruk um amam aria nakripam namudok, “Eikin yaken Iruhin douk nake debeinyi nyeigur eik yatogur dodogoiwe aria yape debeini um ihishmorim eshudok shape iruhw atap iri. ");
INSERT INTO apec_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Namudok aria ipak douk ta punam ihirub warub um ihis awirosish arpesh aria pukripesh eikin baraen. Pukripesh um shumneken shusuhwen aria shugipesh eik shutogur eikish disaipel. Aria punek baptaisumesh um eikin Yaken ananin nyeigur, um eik Nuganin eikin nyeigur aria shopunek um Iruhin ananin Mishin enyenyin nyeigur. ");
INSERT INTO apec_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Aria punek skulumesh um shugipesh ihinyumorim baraen douk eik riguk yape yakripepen iri. Eik yakripep adurin atin baraen, Eik douk ini ipak mupe ihih nyumneh arigaha hugiguk iri nyumnah hutogurum agudok nahobig.” ");
INSERT INTO apec_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Enyudok douk yopinyi baraen um Jisas Krais, Iruhin ananin Nuganin. Nyarik iri enyudok yopinyi baraen nyakitak nyanak um douk namudok. ");
INSERT INTO apec_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Seiwok Iruhin ananin Mishin nyohur anudok profet Aisaia aria nuwem enen Iruhin ananin baraen namudok. Iruhin nakri, “Eik ta ishopok anan arman nurao eikin baraen nyirik nyunak aria nyak ta nyugiman. Anan ta nugabemen yah nirik. ");
INSERT INTO apec_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Anan ta nunak nupe wehigunum arpesh uwok um aria nupe nuhwar debeg nukri, ‘Gabeiman yah Debeini. Pugabeyoh hupe wosik um anan nugimah nunaki um.’” ");
INSERT INTO apec_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Aria Jon douk nenek baptaisumesh iri natogur nape anagun wehigunum arpesh uwok um aria nape nakripesh nakri, “Ipak pukehuk agabus yoweihi aih aria putanam pukon aparuh Iruhin. Ipak punekesh namudok aria eik inek baptaisumep aria Iruhin ta mare nusuhwesh-umep eneshenesh yoweishi inahos ipak pape penekesh iri aria nukweshihesh niyateshuguk.” ");
INSERT INTO apec_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Aria ihishmorim shape sabairubi warub bape shokugi nahobig Judia iri shani ihishmorim shape Jerusalem iri shanak um shumnek Jon ananin baraen. Eshesh shanak aria shawereh esheshish yoweishi inahos shakrip Jon aria anan nenek baptaisumesh worub Jordan. ");
INSERT INTO apec_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Aria Jon nenekah iri rupah douk shenekah enen mahin shohwaren um kamel iri enyenyirub ehirub.Aria nawashot iri let douk shenekat anap mahinyip yegenyihwip. Aria worigun anan nagnoh iri douk napeum nawok gormish shani wanarin hani. ");
INSERT INTO apec_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Aria anan nakripesh nakri, “Eik yarig yanaki, aria anan ta nigimeiri. Anudok nugigi iri douk dodogowin atun neshagrakuk eik. Aria shopunek, eik douk madae yopuweiri um ikweshihuman madururuh ananiyu su uwe. ");
INSERT INTO apec_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Aria eik douk yenek baptaisumep abar meyoh, aria anan ta nunek baptaisumep um Iruhin ananin Mishin ta nukepen nyuwish nyupenyep numun.” ");
INSERT INTO apec_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Aria Jisas nakutukuk wabur Nasaret douk bape shokugi nahobig Galili iri nanaki aria Jon nenek baptaisuman worub Jordan. ");
INSERT INTO apec_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Douk nenek baptaisuman aria ahudok atuh Jisas nakutukuk worub natowi nakih neyotu anagas aria natik iruhw utag ganupok. Aria natik Iruhin ananin Mishin nyabuhi kabi arudok armir manyun um rabuhi ratem Jisas. ");
INSERT INTO apec_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Aria anah mah hanaki iruhw heven. Aria enyudok arpen nyeyagwrehi nyakri, “Nyak douk eikin Nuganin. Eik douk urkum manawashamen aria yanadudareh abom.” ");
INSERT INTO apec_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Aria arigas Iruhin ananin Mishin nyohur Jisas aria nakitak nanak anagun wehigunum arpesh uwok um. ");
INSERT INTO apec_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Anan nanak nape anan aun shuknin aria 10-poreih nyumneh shopunek. Aria Satan nape nakwiraehan um nunek yoweishi inahos. Aria shopunek, Jisas nanak hurukatinyum urahish mahish shapeum. Aria Iruhin ananish enselahos shanaki shatauruman. ");
INSERT INTO apec_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Douk Jon nonoweshik napeik, aria Jisas nanam shokugi nahobig Galili aria nape nakripesh Iruhin ananin yopinyi baraen. ");
INSERT INTO apec_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Anan nakripesh nakri, “Ahudok nyumnah douk Iruhin nakriyoh iri douk ahudok hatogur. Aria abudok nyutob um arpesh shuwish um agundok Iruhin nupe Debeini um ipak um douk banaki hurukatin. Douk namudok aria ipak pukeshuk agabus yoweishi inahos aria putanam pukon aparuh Iruhin aria pusuhw ananin baraen pugipeshen!” ");
INSERT INTO apec_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Douk Jisas nape nanarahaen nanak anagas um debeigi waiyag Galili, aria natik Saimon nani ananin wanin Andru douk hape henek bisnis um hatuk eiguhw iri. Amam hawashak anan umben agudok debeigi waiyag aria hape hatuk eiguhw. ");
INSERT INTO apec_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Douk anan natrum aria nakripam nakri, “Ipak yowi pugipesh eik aria ikiripep um purao arpesh shunaki shugipesh eik.” ");
INSERT INTO apec_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Douk anan nakripam namudok aria ahudok atuh amam hakutukuk amamib umbenab bakusuk aria hagipesh Jisas hanak. ");
INSERT INTO apec_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Douk amam hanaku aria Jisas natigu biom hatem bot hape hagabe umbenab. Amam douk Sebedi ananim nugamim, Jems nani ananin wanin Jon. ");
INSERT INTO apec_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Aria douk Jisas natrum aria ahudok atuh nahwaram um hunaki hugipeshan. Aria amam biom hakutukuk amamin yaken Sebedi nani amudok henekuman mour iri hatemaguk bot aria amam habuhi hani Jisas hanak. ");
INSERT INTO apec_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Aria amam hanam anabur wabur shohwarabur um Kaperneam iri. Aria ahudok nyumnah Sabat eshesh Juda mour uwok shape meyoh ahi, amam hanak hawish eshesh Juda shape sheyagwreh baraen-atari urupat aria Jisas nape nenek skulumesh um Iruhin ananin baraen eshesh armam armago. ");
INSERT INTO apec_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Aria eshesh shemnek ananin baraen aria shakitak yowiyokuk abom. Um maresh? Anan douk narao debeinyi big aria nenek skulumesh nakripesh dodogowin atin baraen. Aria amam henek skulumesh um lo iri douk madae hunek skulumesh namudok uwe, uwok. ");
INSERT INTO apec_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","24","Aria douk Jisas nape nenek skulumesh aria anan yoweishi sagabehos shapenyan iri nanak nawish atudok urupat aria nahwar debeg nakri, “Jisas, nyanaki wabur Nasaret iri. Nyak nyanamori nyunekap mumam apak sagabehos? Nyak nyanamori nyop mugok aka? Apak madukemen abom nyak. Nyak douk Iruhin ananin abom nuganin.” ");
INSERT INTO apec_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Aria Jisas naho eshudok sagabehos nakri, “Ipak mokureg aria pukutukuk anudok arman aria putogur punak.” ");
INSERT INTO apec_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Aria douk Jisas nahesh aria eshesh shour anudok arman debeg. Aria anan krukruk nape aria eshesh shohwar debeg aria shakutukuk anudok shatogur sharuwok. ");
INSERT INTO apec_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Aria eshudok sabaishi arpesh shape iri shatik namudok aria eshesh shakitak yowiyokuk abom. Aria shape sheneyagwreh shakri, “Enyudok douk apak memneken iri douk maren baraen? Seiwok apak madae mumneken iri enyudokmori baraen! Anudok arman douk dodogowinari aria eshudok sagabehos shemnek ananin baraen!” ");
INSERT INTO apec_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Aria enyudok baraen um enyudok Jisas neneken iri nyowe nyanak shubairubi warub douk bape agudok shokugi nahobig Galili iri. ");
INSERT INTO apec_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Aria amam hakutukuk eshesh Juda shape sheyagwreh baraen-ati urupat aria amam ihim-morim, Jisas nani Saimon aria Andru, hani Jems aria Jon, hanam Saimon aria Andru amamit urupat. ");
INSERT INTO apec_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Aria agundok, Saimon ananik nakwurikwik kwaraubor aria kweshuhw aras. Aria arigas enesh shanak shakrip Jisas um agundok okwok kwaraubor um. ");
INSERT INTO apec_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Aria Jisas nanak nasuhw okwokwin rogur nakuhur kwakitak kwape aria okwok yopuk. Aria okwok kwakitak kwape kwonek worigun um eshesh shishoh. ");
INSERT INTO apec_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Douk arigaha wabigep wah hagok aria eshesh armam armago sharauri arugeh hapeyeshi shani yoweishi sagabehos shapeyesh iri shanaki agundok Jisas napeum. ");
INSERT INTO apec_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Aria ihishmorim arpesh shape abrudok wabur iri shanaki shantorum shape aduk hurukatin um dua. ");
INSERT INTO apec_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Aria Jisas nagabe sabaishi arpesh anahaehih arugeh henekesh abrudok wabur iri. Aria shopunek, nahiyahuk sabaishi sagabehos shatogur sharuwok. Aria sagabehos douk shadukeman Jisas. Aria anan nakripesh um eshesh mare shukurip kupaishi arpesh um anan douk Iruhin ananin nuganin um. ");
INSERT INTO apec_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Wata wab Jisas nakitak nanak anagun arpesh uwok um aria nanak nape nenek beten. ");
INSERT INTO apec_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Nenek beten aria Saimon nani amudok anam disaipel hape hauriman hanak. ");
INSERT INTO apec_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Douk hauriman hanak arigaha hanak hatrun aria hakripan hakri, “Nya, ihishmorim arpesh shape shaurimen.” ");
INSERT INTO apec_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Aria Jisas nakripam nakri, “Nyunekesh, apak munam kupairubi warub bape hurukatin iri aria eik ikripesh yopinyi baraen eshesh shopunek. Um maresh, Eik douk yanakmori ikripesh yopinyi baraen sabaishi arpesh.” ");
INSERT INTO apec_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Aria anan nanak ihirub warub agudok shokugi nahobig Galili aria nape nakripesh Iruhin ananin yopinyi baraen numun eshesh Juda shape sheyagwreh baraen-ogwi urusag. Aria shopunek, nahiyahuk sagabehos douk shape arpesh iri shatogur sharuwok. ");
INSERT INTO apec_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Aria anan ehudok lepra hapenyanari nanak um Jisas aria nabuh noduk ohrubus. Aria nakrip Jisas nakri, “Douk nyak nyukri wosik um, nyak ta nyugabeye.” ");
INSERT INTO apec_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Aria Jisas natrun aria nenek gihauman. Aria nohur rogur nuwem ananis wis anudok arman aria nakripan nakri, “Eik yakri wosik um. Nyak yopin.” ");
INSERT INTO apec_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Aria ahudok atuh anan yopun. ");
INSERT INTO apec_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","Aria Jisas nakripan dodogowinyi baraen nakri, “Nyak nyunak aria mare nyukrip enesh arpesh um agundok eik yagabeyen um, uwok. Nyak nyunek atin nyunam pris nutrin, aria nyunak nyunek enyudok ofa um agundok nyak yopinyum um maresh douk Iruhin ananin lo douk nakoguk Moses enyi nyakrium. Nyak nyunekesh namudok aria sabaishi arpesh ta shutrin aria shudukemesh shukri nyak douk iga yopin.” ");
INSERT INTO apec_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Aria anan nanak aria nape nakrip sabaishi arpesh um agundok Jisas nagabeyanum. Aria baraen nyowe nyanak sabairubi warub. Douk namudok aria Jisas madae nunak nuwish anarub warub uwe, uwok. Anan napeik aduk abrudok warub agundok wehigunum douk arpesh uwok um. Aria sabaishi arpesh shanaki worobaigunum iri shanak agundok anan nanak napeum. ");
INSERT INTO apec_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Douk ehudok nyumneh hanak hadiguk, aria Jisas wata shopunek natanam nanam Kaperneam. Aria abudok nyutob eshesh armam armago shopunek shemnek baraen um anan nanak nape urupat um. ");
INSERT INTO apec_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Douk namudok aria sabaishi arpesh shanak shape numun ananit urupat shuknit aria enesh shape aduk hurukatin um wit. Eshesh shape aria madae onok outuk kwupeik meyoh uwe, uwok. Eshesh shape ba shuknigun aria Jisas nape nakripesh yopinyi baraen. ");
INSERT INTO apec_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Douk nape nakripesh baraen aria 4-poreim armam howemori anan roguhw aiyas shagokanari anas aras aria haran hanaki um Jisas. ");
INSERT INTO apec_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Amam haran hanak aria sabaishi arpesh shape aria amam yah uwok um huran hunak agundok Jisas napeum uwe, uwok. Douk namudok aria amam hato hakih modukwitam urupat aria hadar agundok Jisas napeum. Aria anudok roguhw aiyas shagokanari nor aras aria honahur hereyan kwojarahos aria shokubur hakutunuk nabuh nakus Jisas napeum. ");
INSERT INTO apec_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Aria douk Jisas natik amudok 4-poreim um henek bilip um anan ta nugabeyan aria anan nakrip anudok roguhw aiyas shagokanari nakri, “O nuganin, eik ta ko igabeyen um nyakish yoweishi inahos aria eshudok ta iyateshuk.” ");
INSERT INTO apec_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","7","Aria douk Jisas nakri namudok aria anam henek skulumesh um lo iri, douk hani eshesh hape agundok iri amamiruh aparuh aturuh heneyagwreh hakri, “Anudok arman neyagwreh namudok um maresh? Anan douk nape nabubunim um Iruhin. Apak madukemesh um Iruhin atun ta wosik nukweshih-esh um arpeshish yoweishi inahos.” ");
INSERT INTO apec_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Aria Jisas nadukem amamip urkwip aria nakripam nakri, “Ipak urkwip mare pur namudok, uwok. ");
INSERT INTO apec_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Um maresh? Enyudok mour douk shopunek atin um eik ikrip anudok roguhw aiyas shagokanari ikri, ‘Eik ta ko ikweshihuk nyakish yoweishi inahos aria iyateshuk’ aka, ikripan ikri, ‘Kitak hur nyakis aras nyusuwos aria nyunak’ aria anan ta nikitak nunak? ");
INSERT INTO apec_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Douk namudok aria Eik Anudok Arman douk yatogur adurinyi arpen iri ta iyabigep um pudukemesh um eik douk dodogoiwe iri aria Iruhin neke big ko ikweshihuk um eshudok atapish arpesh esheshish yoweishi inahos aria iyateshuk.” Aria Jisas nakrip anudok roguhw aiyas shagokanari nakri, ");
INSERT INTO apec_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Eik yakripen, nyak kitak hur nyakis aras nyusuwos aria nyunam urupat!” ");
INSERT INTO apec_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Aria ahudok atuh eshudok ihishmorim arpesh douk shape agundok iri shatrunum nakitak nohur ananis aras nasuwos aria nanak. Aria eshesh shatrun namudok aria ihishmorim shakitak yowiyokuk aria shape shatuk Iruhin ananin nyeigur nyato iruhw. Aria shakri, “Seiwok apak madae mutik enen enyudokmori nyutogur uwe, uwok!” ");
INSERT INTO apec_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Aria Jisas nakitak natanam narahaen nanak anagas um debeigi waiyag Galili aria sabaishi arpesh shanaki shatogruman. Aria anan nape nenek skulumesh nakripesh yopinyi baraen. ");
INSERT INTO apec_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Anan nakripesh baraen jurug aria anan nanaku aria natik Alfius ananin nuganin Livai douk apa narao takis iri. Jisas natrun nape urupat douk nape narao takis um. Aria anan nakripan nakri, “Nyak yowi nyugipesh eik ba unak.” Aria Livai nakitak nanaman hanak. ");
INSERT INTO apec_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Aria kupaihi nyumnah Jisas nape nawok worigun Livai ananit urupat. Aria sabaimi harao takis iri hani sabaimi kupaimi shopunek henek eneshenesh yoweishi inahos iri hani Jisas nani ananim disaipel hape hawok worigun. Um maresh? Worobaimi amudokmori armam ihih nyumneh apa hagipesh Jisas. ");
INSERT INTO apec_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Aria anam henek skulumesh um lo iri, amam douk Farisi omi. Amam hatik um Jisas nani shenek eneshenesh yoweishi inahos iri shani harao takis iri shape shawok worigun atugun um aria amam harig ananim disaipel hakri, “Anan nani eshudok shenek eneshenesh yoweishi inahos iri shawok worigun?” ");
INSERT INTO apec_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Aria Jisas nemnekam namudok aria nakripam nakri, “Arpesh douk madae eneh arugeh henekesh iri ta mare shunam dokta um nugabeyesh, uwok. Eshudok douk arugeh henekesh iri atish ta shunak um dokta nugabeyesh. Aria eik shopunek douk namudok atin, kabi dokta um. Eik douk madae inakumori ihwar yopishi arpesh um shatanam shukon aparuh Iruhin uwe, uwok. Eik douk yanakmori ihwar eshudok douk shenek yoweishi inahos iri um shukeshuk agabus yoweishi inahos aria shatanam shukon aparuh Iruhin.” ");
INSERT INTO apec_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Anah nyumnah Jon douk nenek baptaisumesh iri ananim disaipel hani amam Farisi amamim disaipel hashakur um worigun aria hape henek beten atin. Douk namudok aria enesh arpesh shanak gani Jisas napeum aria sharigan shakri, “Jon ananim disaipel hani amam Farisi amamim hashakur um worigun aria hape henek beten atin. Aria nyakim madae henekesh namudok uwe, um maresh?” ");
INSERT INTO apec_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Aria Jisas nakripesh enen wobuwobren baraen nakri, “Ipak pakri abudok nyutob anudok douk kadak narao armatok iri wata nini ananishi nupe um, eshesh ta shushakur um worigun aria shupe meyoh aka? Adur atin ta uwok. Eshesh ta shuwok worigun aria ta shupe! ");
INSERT INTO apec_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Aria nyutob ta bunaki um kupaishi shuran shunak kupaigunum um. Aria ahudok nyumnah, ananishi ta urkwip purum anan aria ta shushakur um worigun shupe meyoh.” ");
INSERT INTO apec_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","22","“Aria ta mare enen arpen nyukwuhwaesh anap rupahip um anah namuhi rupah aria nyutapeyop um anohw umunihw um anah jugwaihi rupah, uwok. Enyen nyibirak namudok akure, enyen ta nyunek anohw umunihw ahudok namuhi rupah. Aria shopunek ta nyutapeyop aria ta mare pupe wosik um ahudok jugwaihi rupah uwe, uwok. O ta mare enen arpen nyurak anabar namubari wainibar abar bubuh anap jugwaipi memeip munuhwip douk shape sharuk wainibar abar um uwe, uwok. Enyen nyunekesh namudok akure, abrudok namubari wainibar abar ta buprukeshop aria wain ta nutourakuk atap atin. Aria apudok memeip munuhwip ta yowep. Aria namudok uwok, eshesh ta shisharabar namusi munuhwis atus. Aria asas ta mare tutukaras aria wain ta nur wosik!” ");
INSERT INTO apec_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Anah nyumnah Sabat, eshesh Juda mour uwok shape meyoh ahi, Jisas nani ananim disaipel hakitak hawish hanak anag debeigi nubarig douk shau wit um. Aria agundok ananim disaipel hadi anat urubit wit aria hape haworishat hatoh. ");
INSERT INTO apec_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Aria amam Farisi hatrum namudok aria hakrip Jisas hakri, “Tik, nyakim disaipel henekesh mumam namudok? Apakin lo douk nyakri apak mare munek enen mour ahudok nyumnah Sabat!” ");
INSERT INTO apec_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","26","Aria Jisas nakripam nakri, “Ipak patarihen baraen seiwok Devit nenyemaguk iri um abudok nyutob anan nani ananim nyurub bam um aka, uwok? Amam nyurub bam aria Devit nawish Iruhin ananit debeiti urupat nohur bret douk shenek ofamat shako Iruhin iri aria nani ananim hatoh. Enyudok douk nyatogur abudok nyutob Abiatar nape debeini pris obi nyutob. Abiatar nakri wosik aria Devit nani ananim armam hawish hohur bret hatoh. Aria shopunek, apakin lo douk nyakri mare enesh shape meyoh iri arpesh shuwok atudok bret, uwok. Amam pris atum wosik. Aria Devit nani ananim hotuhur hatoh.” ");
INSERT INTO apec_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Aria Jisas wata shopunek nakrip amam Farisi nakri, “Iruhin douk madae nunek ahudok nyumnah Sabat um nukri ipak aparuh yoweruh aria mare panadudareh uwe, uwok. Anan nenekah um nakri ipak aparuh ta yopuruh aria panadudareh. ");
INSERT INTO apec_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Aria Eik Anudok Arman douk yatogur adurinyi arpen iri douk Debeiwe um ihishmorim eneshenesh um abudok amnab, aria Debeiwe um ikrip arpesh shunek mour ahudok nyumnah Sabat shopunek.” ");
INSERT INTO apec_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Kupaihi nyumnah Sabat, Jisas nanak nawish eshesh Juda shape sheneyagwreh baraen-ati urupat. Aria anan rogur yowenyan iri arman nanaki nawish nanamesh nape. ");
INSERT INTO apec_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Aria arpesh shape atudok urupat iri shakri shukon baugos um enen baraen Jisas shakri shutik anan ta nubrig enen lo aka, uwok. Douk namudok aria eshesh shape shatrun duk um shakri kadak anan nukri nugabe anudok rogur yowenyan iri ahudok nyumnah Sabat um, aria eshesh shuneman baraen. ");
INSERT INTO apec_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Aria Jisas nakrip anudok rogur yowenyan iri nakri, “Kitaki nyeyotu agundok orokohun um sabaishi arpesh shutrin.” ");
INSERT INTO apec_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Aria anan nakitak nanak neyotu aria Jisas narigesh nakri, “Apakin lo douk Iruhin nakoguk Moses enyi nyakri munek maren mour ahudok nyumnah Sabat? Mugamoh arpesh mugabeyesh aka, mukri uwok umesh? Mugamohesh shupe wosik aka, ba mesh shugok?” Aria eshesh madae shiyagwreh shukripan enen baraen uwe. ");
INSERT INTO apec_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Aria anan neyotu natrish aria nyibur juwehosibur. Um maresh? Anan natrish um eshesh showeshik esheshiruh aparuh dodog aria shakri uwok um shumnek Iruhin ananin baraen shugipeshen. Aria anan nakrip anudok rogur yowenyan iri nakri, “Kwanu nyakin rogur.” Aria anan nonu rogur aria enyen yopin abom. ");
INSERT INTO apec_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Aria amam Farisi hakitak hatogur hanak hani anam Herot ananim armam hape habo baraen um hakri hurim anah yah um hubo Jisas nugok. ");
INSERT INTO apec_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Aria Jisas nani ananim disaipel hakutukuk abrudok wabur hakitak hanam debeigi waiyag Galili. Amam hanak aria sabaishi arpesh shagipesham shanak. ");
INSERT INTO apec_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Eshudok arpesh enesh shanaki shokugi nahobig Galili iri. Aria enesh shanaki shokugi nahobig Judia iri. Aria enesh shanaki debeigi nahobig Idumia, aria enesh shanaki Jerusalem iri. Aria enesh shapeiri gani wobrehah um worub Jordan iri shanaki, aria enesh shape iri hurukatinyum arbudok biarub warub Taia bani Saidon iri shanaki. Eshesh ihishmorim shemnek um Jisas nape nagabe ehudok arugeh hapeyeshi aria eshesh shanaki um nugabeyesh. ");
INSERT INTO apec_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Aria agundok sabaishi arpesh shanaki shape shuknigun. Douk namudok aria Jisas nakrip ananim disaipel um harauri anat shokwuti bot tunaki tukusuman hurukatin um kadak sabaishi arpesh shukri shunaki hurukatin um anan um aria anan ta nuto nutemaguk bot. Ta neyotu atap um, eshesh ta shishiwokan. ");
INSERT INTO apec_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Um maresh, nubokuhieb nyutob anan nagabe sabaishi ehudok arugeh hapeyeshi. Douk namudok aria eshudok arugeh hapeyeshi shape shatatigas um shunak shususuhw Jisas meyoh aria eshesh ta yopish. ");
INSERT INTO apec_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Aria abudok nyutob douk yoweishi sagabehos shapenyesh iri shanaki shatik Jisas aria shabuh shatu shakus hurukatin um anan aria shohwar debeg shakri, “Nyak douk Iruhin ananin Nuganin.” ");
INSERT INTO apec_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Aria Jisas nakripesh dodogowinyi baraen nakri eshesh mare shukripesh um anan douk Iruhin ananin Nuganin. ");
INSERT INTO apec_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Aria Jisas nato anag mihig aria nahwar sabaimi armam douk anan nakriyam iri hanaki. ");
INSERT INTO apec_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Aria anan nagraeh 12-poreim armam aria nakom enyudok nyeigur aposel. Aria nakripam um huni anan hupe hurahaen aria neshopokam um hunak hukripesh ananin baraen sabaishi arpesh. ");
INSERT INTO apec_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Aria shopunek um nukom dodog um huhiyahuk yoweishi sagabehos shutogur shuruwokuk. ");
INSERT INTO apec_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","17","Amudok 12-poreim aposel Jisas nograeham iri douk amudok. Saimon, douk Jisas nodowon kupainyi nyeigur Pita iri, nani Sebedi ananim nugamim, Jems nani ananin wanin Jon, douk Jisas nodowon kupainyi nyeigur Boanerges iri. Baugenyum enyudok nyeigur douk shakri, “Utag Pogarog.” ");
INSERT INTO apec_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Amam hani Andru, Filip, Bartolomyu, Matyu iri Tomas. Hani Alfius nuganin Jems iri Tadius iri Saimon douk natogur anap awirop shohwaresh um Selotiri. ");
INSERT INTO apec_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Amam hani Judas Iskariot. Anan douk nowereh Jisas um ananim horim iri. ");
INSERT INTO apec_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Aria Jisas natanam nanam urupat aria sabaishi arpesh shanaki shape anan napeum. Aria Jisas nani ananim disaipel hatrish namudok aria amam nyutob uwok um hupe meyoh ba hunek anagun worigun hugnoh uwe, uwok. ");
INSERT INTO apec_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Aria ananishi, eshesh atup awirop shemnek um agundok anan madae nupe meyoh um nuwok worigun um, aria eshesh shanak um shuran shunak. Um maresh? Eshesh shakri anan douk nagugak. ");
INSERT INTO apec_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Anam henek skulumesh um lo iri douk hape iri Jerusalem hanaki henek rohw. Amam hakripesh hakri Jisas douk enyudok Bielsebul douk debeinyi um sabaishi sagabehos iri nyenekan dodogowin aria anan douk nohiyahuk eshudok enesh sagabehos shatogur sharuwok. ");
INSERT INTO apec_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Douk namudok aria Jisas nahwar sabaishi shanaki um anan aria nakripesh enyudok wobuwobren baraen nakri, “Satan anan kanak ta mare nuhiyahuk ananishi sagabehos shutogur shuruwok uwe, uwok. ");
INSERT INTO apec_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Aria douk arpesh shape atug nahobig iri shunadiyogurum shunak shupe sisiguk, aria shunenem horin horik aria shupe shurpak akure, eshesh ta mare dodogowish uwe, uwok. ");
INSERT INTO apec_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Aria shopunek douk anap awirop shunadiyogur um, aria eshesh kanak shunenem horin horik aria shupe shurpak atin shup akure, eshesh shopunek ta mare dodogowish uwe, uwok. ");
INSERT INTO apec_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Aria douk Satan nini ananish shunadiyogur um shunak shupe sisiguk, aria eshesh kanak shunenem horim horik ba shupe shurpak atin shupe aria eshesh shopunek ta mare dodogowish uwe, uwok.” ");
INSERT INTO apec_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“Aria ta mare anan arman nunak nuwish anan dodogowinari arman ananit urupat aria nutrun nukwumeshi aruh ananish eneshenesh uwe, uwok. Sagomatin anan ta nuweshikuk anudok arman nupeik ba iyoh, aria anan ta kadak nunak nutrun ba nukwuaruh um eneshenesh.” ");
INSERT INTO apec_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","30","Aria douk amam henek skulumesh um lo iri hakri enen sagab nyataurum Jisas um nenek mour um. Douk namudok aria Jisas nakripam nakri, “Adurigom atin eik yakripep, Iruhin ta ko nukweshihuk um eneshenesh yoweishi inahos arpesh shenekesh iri shuni enyudok ihinyumorim yoweinyi baraen douk eshesh shakriyen um anan iri, aria nukweshiheshuk. Aria enyudok enenyenen douk shububunim um Iruhin ananin Mishin iri, Iruhin ta nusuhw enyudok esheshin yoweinyi douk eshesh shakriyen iri aria ta mare nukweshiheshukuk uwe, uwok. Esheshish yoweishi inahos ta shupe um douk arigaha kweipon amnab butuh ahi nyumneh.” ");
INSERT INTO apec_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Aria abudok nyutob Jisas ananik amakek kwani ananim aruhim shanak shatogur. Aria shanak sheyotu aduk urupat aria shenek baraen nyanaman um nutograri aduk. ");
INSERT INTO apec_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Aria agundok sabaishi arpesh shape shersharih um anan aria eshesh shakripan shakri, “Nya, nyakik amakek kwani aruhim sharimen.” ");
INSERT INTO apec_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Aria Jisas nakripesh nakri, “Meishi eikish amakek aruhim?” ");
INSERT INTO apec_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Aria anan nushakam eshudok nernarih douk shape iri aria nakripesh nakri, “Eikish amakek aruhim douk eshudok! ");
INSERT INTO apec_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Meishi douk shape shagipesh Iruhin ananin baraen iri douk Eikish aruhim, mohwuhiyu aria amakenyiyu.” ");
INSERT INTO apec_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","2","Aria Jisas wata shopunek nanak nape nenek skulumesh nakripesh yopinyi baraen gani anagas um debeigi waiyag Galili. Aria sabaishi arpesh abom shanaki shape Jisas napeum. Douk namudok aria anan nakitak nato netem anat bot douk tor waiyag iri. Aria eshesh sheyotu anagas aria anan netemori bot nape nenek skulumesh nakripesh sabainyi yopinyi baraen nakripesh wobuwobren atin. ");
INSERT INTO apec_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","Nakri, “Ipak pumnek! Anan arman nawashak wit ananig nubarig. ");
INSERT INTO apec_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Anan nawashat aria anat tabuh takus yah, aria armiguhw hwabuhi hwatuhur hwatoh. ");
INSERT INTO apec_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Aria anat tabuh takus utabor um. Aria douk amnab madae sabaibi uwe aria atat pupuwarat takih arigas. ");
INSERT INTO apec_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Aria nukwaruh madae hubuh atap uwe. Namudok aria araruh habuh hetemaguk utabor aria wah hatao hat aria yarit. ");
INSERT INTO apec_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Aria anat tagrukuk segego-iruh madururuh hakih um aria pupuwarat takih. Douk takih, aria aruhudok madururuh heshigarut aria atat madae tukih debet um shurkwip pir uwe. ");
INSERT INTO apec_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Aria anat tagrukuk yopubi amnab aria pupuwarat takih debet aria sabaiti teir. Anat, 30-poreit teir atin atin apakiwogin. Aria anat 60-poreit, aria anat 100-poreit.” ");
INSERT INTO apec_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Douk Jisas nakriyuk namudok aria anan nakripesh nakri, “Aria douk ipak arigos sapenyep iri aria gamo pumnek eikin baraen aria pugipeshen.” ");
INSERT INTO apec_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Douk sabaishi arpesh shakutunukuk shanak, aria Jisas atun nani ananim 12-poreim disaipel hani eshudok enesh shagipesh Jisas iri atish shape. Aria eshesh sharigan um nukripesh um baugenyum um enyudok wobuwobren baraen anan nape nakripesh-enyi. ");
INSERT INTO apec_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Aria anan nakripesh nakri, “Iruhin douk nakripep baugenyum um baraen um enyudok wobuwobren baraen um ipak atip um ta puwish agundok Iruhin nape Debeini um ananish arpesh um. Aria ihishmorim adukishi ta uwok. Eshesh ta shumnek wobuwobren atin. ");
INSERT INTO apec_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Douk namudok aria, ‘Eshesh ta shutrugun aria ta mare shutik enesh eshudok eneshenesh. Aria shopunek ta shumnek baraen, aria ta mare shudukem baugenyum um, uwok. Um maresh, ta shudukem baugenyum um aria wata shutanam shukon aparuh Iruhin aria anan madae nunawasham um esheshish yoweishi inahos aria nukwreyeshuk.’” ");
INSERT INTO apec_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Aria Jisas narigesh nakri, “Ipak madae pudukem baugenyum enyudok wobuwobren baraen iganigadae yakripepen iri uwe? Douk namudok aria ipak ta pudukem ihinyumorim wobuwobren baraen douk ta eik ikripepen iri mumam? ");
INSERT INTO apec_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Anudok arman nawashak wit iri douk kabi anan nakripesh Iruhin ananin yopinyi baraen iri. ");
INSERT INTO apec_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Aria atudok douk tabuh takus yah iri douk kabi eshudok arpesh douk shemnek Iruhin ananin baraen aria Satan nanaki natrish narauguk enyudok yopinyi baraen douk nyape esheshiruh aparuh iri. ");
INSERT INTO apec_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Aria atudok douk tabuh takus utabor bakus um iri douk kabi eshudok arpesh douk shemnek Iruhin ananin baraen atin aria shanadudareh-umen abom shasuhwen shakri wosik iri. ");
INSERT INTO apec_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Aria eshesh sharaen aria eshesh madae shusuhwen dodog uwe. Eshesh shasuhwen shagipeshen banab nyutob meyoh. Aria douk arigaha enen amaen nyatogrumesh o shenekesh enenyenen um agundok shasuhw enyudok Iruhin ananin baraen um, aria arigas atin shakutukuk esheshin bilip. ");
INSERT INTO apec_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","19","Aria atudok douk tabuh tagrukuk segegoiruh madururuh hakih um, douk kabi eshudok arpesh douk shemnek Iruhin ananin baraen, aria eshesh shenek wari um shakri shupe wosik agundok atap iri. Eshesh mishish shakitak um shugrem sabaishi eneshenesh eshudok aria shanadudareh um agundok atapishi eneshenesh atish. Douk namudok aria eshudok eneshenesh showeshik esheship urkwip aria eshesh madae shusuhw Iruhin ananin baraen dodog uwe. Eshesh urkwip pekeshuk abom um enyudok Iruhin ananin yopinyi baraen eshesh shemneken iri. Aria eshesh shakwutinyukuk aria madae shunek ehudok yopihi aih douk Iruhin nakri eshesh shunekeh iri uwe. ");
INSERT INTO apec_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Aria atudok douk tabuh takusuk yopubi amnab iri douk kabi eshudok arpesh douk shemnek Iruhin ananin baraen aria shasuhwen dodog shagipeshen iri. Aria eshesh shenek sabaihi yopihi aih. Aria eshesh shape kabi douk apakiwogin witin um. Anat, 30-poreit teir atin atin, anat 60-poreit, aria anat 100-poreit.” ");
INSERT INTO apec_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Aria Jisas wata shopunek nakripesh nakri, “Ta mare enen arpen nyihem enen lam aria nyukitak nyushapamen anat baket o nyunyigren shakamum anat bet, uwok. Enyen ta nyihemen aria nyunyem iruhinyum tebol um enyen ta nyutrugun-umesh. ");
INSERT INTO apec_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Aria eneshenesh douk shanabeshuk shakus iri ta wata shutogur yopugunum. Aria eneshenesh douk arpesh shoshigarish shakus iri ta wata shishrekesh shukus yopugunum. ");
INSERT INTO apec_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Aria douk ipak arigos sapenyepi aria pumnek eikin baraen aria pusuwen dodog pugipeshen.” ");
INSERT INTO apec_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Aria anan nakripesh enen baraen shopunek nakri, “Ipak urkwip gamo purum enyudok baraen douk ipak pamneken iri aria pugipeshen! Um maresh? Ta ipak gamo pumneken pugipeshen um, Iruhin ta nutaurumep pudukem enen yopinyi baraen shopunek. ");
INSERT INTO apec_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Aria eshudok douk shurao Iruhin ananin baraen shudukemesh wosik iri, Iruhin ta wata gamo nukripesh enen shopunek. Aria eshudok douk madae shudukem ananin baraen iri uwe, enyudok karowinyi eshesh shasuhwen iri ta wata nutrishenyuguk.” ");
INSERT INTO apec_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Aria Jisas nakripesh enyudok baraen shopunek nakri, “Arpesh shawish um agundok Iruhin nape Debeini um ananish arpesh shapeum ta kabi enyudok wobuwobren baraen um. Baraen enyudok. Anan arman nanak nawashak shurukwip-igun worigun ananig nubarig. ");
INSERT INTO apec_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Anan nawashep jurug aria nanak. Aria ihibus weibus anan neshuh, aria nyumneh nakitak narahaen. Aria abudok nyutob epudok shurkwip pape pupuwarep pakih. Aria anan douk madae nudukemesh um agundok epep pupuwarep pakih um uwe. ");
INSERT INTO apec_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Abab amnab kanak benekep pupuwarep pakih debeipi aria shurkwip peir. Aria sagomatin pupuwarep pakih aria parik penek shus, aria pakih rowipi penek urub aria sabaipi shurkwip peir. ");
INSERT INTO apec_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Douk peir arigaha pauh, aria anudok arman nasuhw ananip ponodaresh iri nogwotep nanak natupok epudok shurkwip. Um maresh? Epep douk pauh aria abudok nyutob um shurim worigun obi nyutob douk batogur.” ");
INSERT INTO apec_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Aria Jisas nakripesh nakri, “Arpesh shawish um agundok Iruhin nape Debeini um ananish arpesh um ta kabi maresh um? Eik ta ikripep maren wobuwobren baraen um pudukemesh? ");
INSERT INTO apec_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Agundok Iruhin nape Debeini um ananish arpesh um ta kabi anam shokumi mastetim shurkum um. Amam douk shokumi abom meshagrakuk sabaipi shuruwep arpesh douk shawep nubarigos iri. ");
INSERT INTO apec_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Anan arman nau anam mastetim shurkum ananig nubarig. Aria amam puwarom makih munek debeinyi rowog nyeshagrakuk kupaigosi shokugosi rowos seyotu nubarig iri aria nyenek debeishi nyeiguhw. Aria armiguhw hwanak hwem was aria hwetem hwanabeshuk um wah.” ");
INSERT INTO apec_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Aria Jisas nape nakripesh ananin yopinyi baraen aria nakripesh sabainyi wobuwobren baraen kabi douk iganigadae nakripeshen iri. Anan nakripesh sabainyi wobuwobren baraen douk ta wosik shudukemesh um esheshin saki iri. ");
INSERT INTO apec_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Aria ihinyumorim baraen anan nakripeshen iri, anan nakripesh wobuwobren atin. Aria abudok nyutob anan atun nani ananim disaipel atum hapeum, anan nape nakripam baugenyum ihinyumorim baraen. ");
INSERT INTO apec_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Douk wabigun ahudok atuh nyumnah, Jisas nakrip ananim disaipel nakri, “Yaipo, apak munak gani wobrehahig um waiyag.” ");
INSERT INTO apec_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Aria amam hakutukuk eshudok sabaishi armam armago shapeik, aria amam hato atudok bot douk Jisas iganigadae narik nakih netemoti aria haran nanamam hanak. Aria anog botog shopunek gwagipesh amamit bot gwanak. ");
INSERT INTO apec_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Aria douk amam hanak aria debeinyi uhwin abom nyahur aria nyenek debeibi morub bakitak. Aria abar bakih baprok bot aria atat hurukatin um shuknitum abar. ");
INSERT INTO apec_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Aria abudok nyutob Jisas nanak nanahem korukwu aria neshuh gani tagigukum bot. Aria douk ananim disaipel hatik namudok aria hanak henyubarun hakri, “Debeini Tisa, apak hurukatin um mugok wo. Nyak madae urkum murum agundok douk ta apak mugok um uwe?” ");
INSERT INTO apec_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Douk amam hakripan namudok aria nakitak naho enyudok uhwin iri morub nakri, “Ipak punak putuhuk abom!” Aria eshesh shanak shatuhuk abom. Uhwin madae nyahur uwe aria morub shopunek madae bukitak uwe. ");
INSERT INTO apec_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Aria Jisas natanam nakripam nakri, “Ipak panogugur um maresh? Ipak madae punek bilip uwe um maresh?” ");
INSERT INTO apec_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Aria amam hanogugur abom aria amam kanak hanakripam hakri, “Anudok manan arman? Uhwin iri abar shopunek douk shemnekan.” ");
INSERT INTO apec_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Douk uhwin aria eshah shanak shatuhuk, aria Jisas nani ananim disaipel hanak. Amam hanak arigaha hatogur eshesh Gerasa eshesh-mokum um, gani wobrehahig um debeigi waiyag Galili. ");
INSERT INTO apec_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","3","Aria douk Jisas nanatu nabuhi bot atin, aria anan arman urupat wokanari nanaki natogruman. Anan douk nape neshuh wonugwe-gwiruh hapeum nanaki. Anan douk enen yoweinyi sagab nyapenyan aria nanak nape neshuh gani wonugwe-gwiruh um. Aria anan douk madae anan arman dodogowin um nusuwan nuweshikan uwe, uwok. Senab shopunek douk madae dodogowib uwe. Anudok nagugak iri douk dodogowin atun abom aria naprukeshab. ");
INSERT INTO apec_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Aria sabaihi nyumneh eshesh shasuan shakwu senab showeshik ananish roguhw aiyas aria anan naprukeshab. Anan douk dodogowin atun abom aria arman madae anan dodogowin um nusuwan nuweshikan um nupe wosik uwe. ");
INSERT INTO apec_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Aria ihih, nyumneh weibus, anan napeum narahaen atin. Anan nanak nape wonugwe-gwiruh um, aria nawish nanak yodururuh um. Aria agundok anan napeum nahwar atin nape. Aria shopunek anan nasuhw eresibori utabor kabi douk nugugwes um aria nape natah ananihw yegenyihw. ");
INSERT INTO apec_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Aria anan douk nakutukuk wonugwe-gwiruh hapeum aria wata nape nanaki rougun, aria anan natigi Jisas. Aria anan nanogugur aria nahur nanaki nabuh noduk ohrubus hurukatinyum Jisas. ");
INSERT INTO apec_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Aria nahwar debeg nakri, “Jisas, Debeini Iruhin abom ananin Nuganin! Nyak nyakri nyuneke mumam eik? Nyak nyukri adurin baraen um gani iruhw um nyak mare nye nyuneke imnek debeiri eriger!” ");
INSERT INTO apec_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Anan nakri namudok um maresh, Jisas nakrip enyudok yoweinyi sagab douk nyapenyan iri nakri, “Yoweinyi sagab, nyak nyukutukuk anudok arman aria nyutogur nyunak!” ");
INSERT INTO apec_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Aria Jisas narig anudok nagugak iri nakri, “Nyak nyanahwar mumam?” Aria anan nakri, “Apak sabaipari yoweishi sagabehos mawish mapenyan. Douk namudok aria apak manahwar sagabehos!” ");
INSERT INTO apec_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Aria anan nape nahwaran debeg Jisas um nakri Jisas mare nishopok eshudok sagabehos shunak rougun. ");
INSERT INTO apec_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Aria agundok hurukatin, sabaiguhwi burguhw hweyatu hwape hwawok worigun gani wobrehah um anag shokugi mihig. ");
INSERT INTO apec_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Douk namudok aria eshudok yoweishi sagabehos shakrip Jisas shakri, “Nyak nyishopokap munak muwish gwaguhwi burguhw.” ");
INSERT INTO apec_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Aria Jisas nakri wosik aria eshesh shakutukuk anudok arman shatograri shanak shawish ogwuhwudok burguhw. Aria ogwuhwudok sabaiguhwi burguhw douk shadarehoguh hwatogur 2,000-poreiguh iri hwahur hwanak hwagrukuk enen natogur. Aria ogwoguh hwabuh hwagrukuk anag waiyag aria ihiguhmorim hwabarahukuk aria hwagok hwatuh. ");
INSERT INTO apec_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Aria amudok armam douk hape hako ogwuhwudok burguhw iri hatik namudok aria hakitak haruwok. Amam hanak aria hakrip eshudok arpesh douk shape warub iri shani eshudok douk shape hurukatinyum nahobigos iri um enyudok mugu douk nyatogur iri. Aria eshesh shakitak shanak um shakri shutrun. ");
INSERT INTO apec_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Aria eshesh shanak agundok Jisas napeum aria shatik anudok arman riguk sagabehos shapenyani. Douk anan madae nugugak uwe. Anan wata narao yopumi urkum aria nakitak nananek rupeh aria nape. Aria douk eshesh shatrun namudok aria eshesh shanogugur abom. ");
INSERT INTO apec_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Aria shopunek, eshesh shanak shatogurum eshudok arpesh douk shape shatik enyudok Jisas neneken iri aria shakripesh um agundok sagabehos shakutukuk anudok arman shatograri shanak shawish burguhw aria shaguhw hwagok um. ");
INSERT INTO apec_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Douk namudok aria eshesh shape sheshopok Jisas um nukutukuk eshesh um nunak um kupaigunum. ");
INSERT INTO apec_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Aria douk eshesh shakripan namudok aria Jisas nato bot um nakri nunak aria anudok arman douk riguk sagabehos shapenyani narigan nakri, “Jisas, eik yakri inamen unak!” ");
INSERT INTO apec_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Aria Jisas nakripan nakri, “Uwok, nyak wata nyutanam nyunak um nyakibur wabur aria nyukrip nyakish, ipak atup awirop um agundok Debeini nakri gihaum nyak um. Aria shopunek nyukripesh um enenyenen anan neneken um nyak iri.” ");
INSERT INTO apec_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Aria douk Jisas nakripan namudok aria anan nanak nawish agudok shokugi nahobig douk 10-poreirub warub bape um aria nakripesh um agundok Jisas nagabeyan um. Aria eshesh shakitak yowiyokuk abom. ");
INSERT INTO apec_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Douk Jisas nani ananim harao bot hatanam hanak hatogur gani wobrehahig um waiyag, aria habuh heyotu anagas. Douk amam heyotu aria sabaishi arpesh shanaki shatrum. ");
INSERT INTO apec_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Aria Jairus, douk debeini um eshesh Juda shape sheneyagwreh baraen-atari urupat iri shopunek nanaki. Anan nanaki natik Jisas aria nanak nabuh nakus atap hurukatinyum Jisas ananiruh yeriweruh. ");
INSERT INTO apec_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Aria neyagwreh debeg nakri, “Nya, eikik shokukwi nugawik arugeh hapeyok aria okwok hurukatinyum kugok. Douk namudok aria yakri nyak nyunaku nyuwemok wis meyoh um okwok wata yopuk aria kwukitak kwupe.” ");
INSERT INTO apec_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Douk Jairus nakripan namudok aria Jisas nanaman hanak. Douk amam hanak aria sabaishi arpesh shopunek shanamam shanak. Eshesh shanak wobuwobur aria Jisas naraguk orokohun. Aria shopunek agundok yah eshesh shanak um, eshesh shantoruh um shanak. ");
INSERT INTO apec_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Aria onok armatok douk owishibor banakok kwape 12-poreish kwarahos iri shopunek kwanamesh shanak. ");
INSERT INTO apec_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Okwok sabaimi dokta habirak um hakri hugabeyok aria habirak hatik uwok. Okwok kwomnek debeiri eriger um amam dokta hakri hugabeyok um. Aria shopunek, okwokwibor utabor douk kwashabor batuhmaguk um kwator dokta omi um hugabeyok um. Aria okwok madae yopuk uwe. Owishibor banakok bape namudok aria beshagrakuk riguk barik banakok um. ");
INSERT INTO apec_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Aria douk okwok kwomnek um agundok Jisas nagabe sabaishi ehudok arugeh henekesh um, aria okwok kwani eshudok sabaishi arpesh shanaki. Aria okwok kwanaki agabehah-inum Jisas aria kwasuhw ananih rupah. ");
INSERT INTO apec_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Umum maresh, okwok kwaneyagwreh kwakri, “Douk eik isusuhw ananih rupeh meyoh um, anan ta wata nugabeye.” ");
INSERT INTO apec_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Douk namudok aria okwok kwanak kwasuhw ananih rupah aria ahudok atuh owishibor tukaruboruk. Aria shopunek, okwok kwomnek um numun okwokwihw yegenyihw owishibor madae anabor bunaki uwe. Aria okwok kwadukemesh um okwok douk yopuk. ");
INSERT INTO apec_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Aria ahudok atuh Jisas nadukemesh um enen ananin dodog nyakutukuk anan nyatogur nyanak. Aria anan narigesh nakri, “Douk omi nyanaki nyasusuhw eikih rupeh?” ");
INSERT INTO apec_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Aria ananim disaipel hakripan hakri, “Nyak nyatrish, sabaishi sheyotu shersharih um nyak aria nyak wata nyarigesh um?” ");
INSERT INTO apec_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Aria Jisas neyotu natrish um nakri nutik enyudok arpen douk nyasusuhw ananih rupeh iri. ");
INSERT INTO apec_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Aria okwudok armatok kwadukemesh um agundok Jisas nagabeyok um. Aria okwok kwanogugur abom, aria krukruk kwanak kwabuh kwakus hurukatinyum Jisas ananiruh yeriweruh, aria kwape kwakripan um agundok anan nagabeyok um. ");
INSERT INTO apec_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Aria anan nakripok nakri, “Nugawik, nyak nyenek bilip nyakri eik dodogoiwe iri aria nyak douk yopin. Aria douk nyakih arugeh douk hatuh abom. Aria nyak nyunak aria nyakihw apahw hwurumen wosik.” ");
INSERT INTO apec_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Aria douk Jisas wata nape neyagwreh atin, aria amam hapei Jairus douk debeini um eshesh Juda shape sheneyagwreh baraen-atari urupat iri um ananit urupat aria harauri baraen hanaki hakrip Jairus hakri, “Nyakik nugawik adur kwagok. Namudok aria nyak mare nyukon amaen apakin debeini tisa um nunaku nyakit urupat um.” ");
INSERT INTO apec_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Aria Jisas madae numnek amamin baraen uwe, uwok. Aria anan nakrip Jairus nakri, “Nyak mare nyunogugur. Nyak nyunek bilip atin.” ");
INSERT INTO apec_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Aria anan nakri uwok um ihishmorim arpesh shapeik aria Jems nani ananin wanin Jon iri Pita amam hanaman hanak. ");
INSERT INTO apec_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Amam hanak hatogur Jairus ananit urupat aria Jisas nemnek um eshesh shape shoreh shanaruwor debeg. ");
INSERT INTO apec_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Aria anan nanak nawish aria narigesh nakri, “Ipak pape peyagwreh pariguk um maresh? Okwudok madae kwugok uwe. Okwok douk kweshuhw meyoh!” ");
INSERT INTO apec_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Douk anan nakripesh namudok aria eshesh shape shenekan enenyenen aria shape shagukoruhan. Aria anan neshopok ihishmorim shakitak shatograkuk aria anan nani ananim biom atun disaipel hani okwokwin yaken amakek atish shawish numun urupat okwok kwakus um. ");
INSERT INTO apec_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Eshesh shawish aria Jisas nasuhw okwokwin rogur aria nakripok esheshin baraen nakri, “Talita kum!” Talita kum douk shakri, “Shokukwi armatok, kitak!” ");
INSERT INTO apec_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Aria ahudok atuh okwok adur kwakitak kwape kwarahaen. Okwudok nugawik okwokwish kwarahos douk 12-poreish. Aria douk eshesh shatruk namudok aria shakitak yowiyokuk abom! ");
INSERT INTO apec_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Aria Jisas nakripesh dodogowinyi baraen um eshesh mare shunak shukrip enesh arpesh um agundok anan nakwuhur kwakitak kwape um. Aria anan nakripesh shukok anagun worigun um kwishoh iri. ");
INSERT INTO apec_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Aria Jisas wata nakutukuk abrudok wabur nakitak natanam nanak um ananibur wabur. Aria ananim disaipel shopunek hanaman hanak. ");
INSERT INTO apec_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Aria ahudok nyumnah Sabat eshesh Juda mour uwok shape meyohahi iri, Jisas nanak nawish eshesh Juda shape sheneyagwreh baraen-atari urupat aria nape nenek skulumesh nakripesh yopinyi baraen. Aria sabaishi arpesh shape shemnek ananin baraen iri shemnekan aria shakitak yowiyokuk abom shakri, “Enyudok baraen nanak naraenyi meiguni? Omi nyutauruman aria anan douk nadukem enyudokmori yopinyi baraen? Aria shopunek, omi nyutauruman nyenekan dodogowin aria nape nenek enyudok Iruhin atun neneken iri mour? ");
INSERT INTO apec_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Anan douk nenek mour um narak urusag iri. Aria anan douk Maria okwokwin nuganin. Aria ananiyu mohwiyariyu wani ananim warhim Jems iri Josis, hani Judas iri Saimon douk eshudok shani apak mape agundok.” Eshesh shakri namudok aria shakonuguk agabus. ");
INSERT INTO apec_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Aria Jisas nakripesh nakri, “Anan profet ta nunak ihirubmorim warub aria ta shutuk ananin nyeigur nyuto iruhw. Aria ihishmorim shape ananibur wabur iri, shuni ananishi eshesh atup awirop um shuni eshesh anabur wabur ta uwok.” ");
INSERT INTO apec_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Douk namudok aria Jisas madae nunek enen Iruhin atun neneken iri mour ananibur wabur uwe, uwok. Aria anan nawemesh wis karowish arugeh henekeshi aria nagabeyesh yopish. ");
INSERT INTO apec_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Aria shopunek, Jisas natik um agundok eshesh madae shunek bilip um uwe aria anan nakitak yowiyokuk abom. Aria Jisas nanak anarub warub douk bape hurukatinyum ananibur wabur iri aria nape nenek skulumesh nakripesh yopinyi baraen. ");
INSERT INTO apec_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Aria anan nahwar ananim 12-poreim disaipel hanaki heyotu atugun, aria nakom gobi um huhiyahuk yoweishi sagabehos. ");
INSERT INTO apec_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Aria nakripam nakri, “Aria ta punak ahudok yah um, ipak mare punasuhw anagun worigun nini esharuh. Aria mare punaruk anabor utabor, uwok. Ipak punak meyoh, punasuhw butip atip um punakusim um. ");
INSERT INTO apec_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Aria ipak punare sandelahos, aria mare punasuhw anah rupah, uwok. ");
INSERT INTO apec_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Aria ta punak putogur anabur wabur aria abrudok waburish arpesh shukri wosik um shukep anat urupat um pishuh um, ipak punak pupe atudok atut urupat. Ipak pupe arigaha meihi nyumnah pakri pukutukuk aburdok wabur punak ahi, aria ipak kadak pukutuburuk punak. ");
INSERT INTO apec_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Aria ta punak anabur wabur, aria arpesh shape aburdok wabur iri mare shunadudareh-umep, aria mare shumnek ipakin baraen um, ipak pukutukuk abrudok wabur aria pugudupeshuk nyupruk ipakiruh yeriweruh kwukusuk aria punak. Ipak punekesh namudok um eshesh shutrip aria ta shudukemesh shukri eshesh douk shenek yoweishi inahos.” ");
INSERT INTO apec_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Aria amam hanak biom biom hanak hakripesh Iruhin ananin yopinyi baraen hakri, “Ipak pukeshuk agabus yoweishi inahos aria putanam pukon aparuh Iruhin.” ");
INSERT INTO apec_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Amam hakripesh Iruhin ananin baraen aria hahiyahuk sabaishi yoweishi sagabehos shopunek douk shape arpesh iri shatogur sharuwok. Aria howayakumesh yopuri wel sabaishi arugeh hapeyesh iri aria hagabeyesh. ");
INSERT INTO apec_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Aria abudok nyutob, King Herot douk nape debeini um gavman iri nemnek baraen um enenyenen douk nyape nyatograri. Um maresh? Jisas ananin nyeigur douk nyarahaen sabairubi warub. Aria enesh shakri, “Jon douk nenek baptaisumesh iri wata nakitaki nape. Aria anan douk dodogowin aria nape nenek enyudokmori mour.” ");
INSERT INTO apec_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Aria enesh shakri, “Anan douk profet Ilaija.” Aria enesh shakri, “Anan douk anan profet kabi douk seiwokimi profet um.” ");
INSERT INTO apec_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Douk namudok aria anudok debeini um gavman iri Herot nemnek baraen um enyudok mour Jisas ananim disaipel heneken iri aria nakri, “Jon douk nenek baptaisumesh iri douk seiwok yatupok ananin aruhwigur! Aria douk anan wata nakitak nape aria nape nenek enyudok mour!” ");
INSERT INTO apec_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Herot nakri namudok um maresh, seiwok anan nanatrun armatok ananin wanin Filip aria Jon nape nakrip Herot sabaih atih nakri, “Nyak nyabrig Iruhin ananin lo um nyanatrun armatok Herodias nyakin wanin!” Jon nape nakripan namudok aria Herot neshopok ananim soldia hasuwan haran hanak howeshikan. ");
INSERT INTO apec_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Aria Herodias okwokwih apahw juwehosihw abom um kwakri kwubo Jon nugok aria okwok kwabirak kwatik uwok. ");
INSERT INTO apec_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Um maresh, Herot nanogugur um Jon aria nape natauruman. Anan nadukemesh um Jon douk yopuyopuni aria ananih apahw douk yopuhw aria hwanawasham Iruhin. Aria shopunek Herot nakri wosik um numnek Jon ananin baraen aria anan urkum morum sabaishi eshudok eneshenesh aria anan nenek wari abom. ");
INSERT INTO apec_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Douk arigaha aria Herodias kwaparug anah yah um kwubo Jon nugok um. Aria douk Jon wata nonoweshik nape, aria ahudok nyumnah douk amakek kwabuki Herot ahi iri hatogur. Aria Herot nenek debeiguni worigun um urkum murum ahudok nyumnah amakek kwanabuki um. Anan nenek worigun aria nahwar debeimi douk hatauruman henek gavmanin mour iri, hani amam debeimi um ami iri, hani ihim-morim debeimi um shokugi nahobig Galili iri um hunak huni anan huwok worigun. ");
INSERT INTO apec_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Douk amam hape hawok worigun aria Herodias nugawik kwanaki kwawish kwenek danis. Aria Herot nani amudok douk nahwaram hanaki hani anan hawok worigun iri hatruk aria hanadudareh um okwok abom. Aria Herot narigok nakri, “Nyak nyakri eik iken maresh? Eshudok nyak nyukriyesh iri, eik ta ikenyesh.” ");
INSERT INTO apec_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Aria Herot nakri um iruhw nakripok nakri, “Eik yakripen adurin atin baraen um eik ta iken ihishmorim eshudok nyak nyorigeimesh iri. Aria nyukri isiyamohw eikib amnab buni ihishmorim eikih jah huni utabor, aria iken enesh nyak, aria ohwak unasuwesh shopunek atin um, eik ta ikenyesh!” ");
INSERT INTO apec_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Douk anan nakripok namudok aria okwok kwanak kwarig okwokwik amakek kwakri, “Eik ta ikripan um nuke maresh?” Aria amakek kwakripok kwakri, “Nyukripan nuken Jon douk nenek baptaisumesh iri um ananig barag.” ");
INSERT INTO apec_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Aria okwok kwanak arigas kwahur kwanak kwawish aria kwakrip Herot kwakri, “Eik yakri douk atin, nyureme Jon douk nenek baptaisumesh iri ananig barag onohw yaurehw aria nyukeyog!” ");
INSERT INTO apec_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Douk okwok kwakripan namudok aria anan nenek wari um Jon. Aria anan ta mare wata nukri uwok. Um maresh? Iganigadae anan nakripok um anan ta nukok ihishmorim eshudok eneshenesh okwok ta kworiganumesh iri. Aria shopunek, amudok douk nahwaram hanaki hani anan hawok worigun iri douk hemnek. ");
INSERT INTO apec_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Douk namudok aria arigas anan neshopok anan soldia aria nakripan nakri, “Nyak nyunak shunuweshik-ati urupat nyutupok Jon ananin aruhwigur aria nyiraouri ananig barag.” Aria anudok soldia nemnek namudok aria nanak natupok Jon ananin aruhwigur. ");
INSERT INTO apec_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Anan natupenyuk aria nereiri barag onohw yaurehw aria nanaki nako Herodias okwokwik nugawik aria okwok wata kwanak kwako amakek. ");
INSERT INTO apec_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Aria Jon ananim disaipel hemnek namudok aria hanaki hohur tukwanin atun hanak haruman. ");
INSERT INTO apec_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Douk amam aposel wata hatanamori hani Jisas hape aria hakripan um enyudok mour amam heneken iri nyani baraen amam hakripesh-enyi. ");
INSERT INTO apec_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Aria agundok sabaishi arpesh sharahaen shenek yawi kare aria Jisas nani ananim madae anob nyutob hupe um hurao uhwin aria huwok worigun um uwe. Douk namudok aria Jisas nakripam nakri, “Yaipo! Kitak apak atup munak anagun wehigunum arpesh uwok um aria munak mupe murao uhwin.” ");
INSERT INTO apec_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Aria amam hakitak hato bot aria amam atum hanak anagun wehigun um arpesh uwok um. ");
INSERT INTO apec_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Aria sabaishi arpesh shatrum hanakum aria eshesh shadukemam. Douk namudok aria arpesh shape ihirub warub iri shakitak shakutukuk esheshirub warub aria shahur sharik shanak shatogur sheyotu agundok douk ta Jisas nini ananim hunak hubuh um. Aria amam douk hagiguk hanak hatogur. ");
INSERT INTO apec_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Douk hanak hatogur anagas aria amam hetem bot iri hanatu habuh atap, aria hatik eshudok sabaishi armam armago aria Jisas nenek gihaumesh abom. Um maresh, arman madae anan uwe um nutaurumesh nukripesh baraen iri. Eshesh shape kabi douk sipsip arman madae anan uwe um niyohesh iri uwe. Douk namudok aria anan nape nenek skulumesh abom nakripesh sabainyi Iruhin ananin baraen. ");
INSERT INTO apec_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Douk nenek skulumesh arigaha wabigep aun nabuh, aria ananim disaipel hanaki hakripan hakri, “Nya, aun nabuh aria shopunek, agundok apak douk mapeik wehigunum arpesh wakagun um. ");
INSERT INTO apec_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Douk namudok aria nyak nyishopokesh shunak anarub warub bape hurukatin iri um shunak shunator anagun worigun.” ");
INSERT INTO apec_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Aria Jisas nakripam nakri, “Ipak kanak pukesh anagun worigun.” Aria amam wata harigan hakri, “Nyak nyakri apak munak mutor bret douk ta wosik mutorut um 200 kina iri aria munaki mubiromesh aka?” ");
INSERT INTO apec_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Aria anan narigam nakri, “Ipak pudareh bret ipak pasuhwot iri. Ipak pasuhwi makwunit? Kare putik” Aria amam hadarehat jurug aria hanaki hakripan hakri, “Apak masuhwi 5-poreit bret tani bias arbus meyoh.” ");
INSERT INTO apec_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Aria Jisas nakrip ananim disaipel um hukrip ihishmorim armam armago shunosiaum um karowish atish aria shunak shupe yopuruhi utoruh hatogrum. ");
INSERT INTO apec_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Aria amam hakripesh shanasiam um. Aria 50-poreish shanak shape sik, aria 100-poreish shape sik, aria eshesh shape namudok atin shanak. ");
INSERT INTO apec_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Eshesh shape aria Jisas nohur atudok 5-poreit bret tani asudok biyos arbus nasuwesh nanig natik iruhw heven aria nenek beten nenek tenkyu um Iruhin. Anan nenek tenkyuman jurug, aria nawor atudok bret tani arbus nako ananim disaipel aria hape hasiyaesh hanak. ");
INSERT INTO apec_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Aria amam hasiyaesh aria ihishmorim shashoh aria dugaresh. ");
INSERT INTO apec_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Aria atudok bret tani eiguhw douk shashoh dugaresh shakusuk iri, amam disaipel hatrishesh heshuruk 12-poreruh sararuh shishukniruh aria heshubuk shakus. ");
INSERT INTO apec_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Aria eshudok arpesh douk shawok agundok worigun iri, armam atum douk sabaimi um 5,000-poreim. ");
INSERT INTO apec_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Douk enyudok nyanakuk, aria Jisas neshopok ananim disaipel hanak arigas hato bot aria harik hanakum wabur Betsaida douk bape gani wobrehahig um waiyag iri. Aria anan napeik um arigaha neshopok eshudok armam armago shanakuk aria anan douk nagimam nanak. ");
INSERT INTO apec_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Anan neshopokesh shanak shatuh, aria anan nato onohw yoduhw um nukih nunek beten. ");
INSERT INTO apec_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Aria wab amam disaipel hetem bot hanak hatogur orokohunig um waiyag. Aria abudok nyutob Jisas atun wata nape nenek beten atin gani iruhw yoduhw. ");
INSERT INTO apec_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","49","Anan nape nenek beten, aria natigu ananim disaipel hetem bot. Aria debeinyi uhwin nyahuri nyawanam tarigum bot aria amam hape henek debeinyi mour, henek mour debeg abom. Aria douk natrum aria hurukatinyum gugruk, anan nakitak nagimam nanak. Anan nabrig agudok waiyag narahaen nanaki iruhw igum. Anan nanak aria nakri nishagrakuk amam nunak, aria amam hatrun um narahaen nanaki iruhw um. Aria amam hakri anan da sagaben. Douk namudok aria amam hanogugur abom aria hahwar henyugwreh debeg atin. ");
INSERT INTO apec_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Um maresh? Amam hatrun aria hanogugur abom. Aria Jisas arigas nakripam nakri, “Ipak mare punogugur, uwok! Ipak ta dodogowip. Enyudok douk eik.” ");
INSERT INTO apec_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Aria debeinyi uhwin wata nyahur atin. Aria anan nanak natoum nakih nanamam hape bot aria enyudok uhwin nyahur iri nyagok nyabuhuk. Aria ananim disaipel hakitak yowiyokuk. ");
INSERT INTO apec_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Um maresh? Ruwahepih anan nawor 5-poreit bret tani biyos arbus nako sabaishi arpesh aria amam madae hudukemesh hukri anan douk dodogowini uwe! Amam urkwip pokomuk abom. ");
INSERT INTO apec_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Aria habrig waiyag hanak arigaha hanak hatogur anagas gani wobrehahig um waiyag, um agudok shokugi nahobig Genesaret, aria amam habuh hanuk bot hanak haweshikot. ");
INSERT INTO apec_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Douk amam howeshiguk bot hanak aria arpesh iganigadae shatik Jisas shadukeman. ");
INSERT INTO apec_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Douk namudok aria eshesh shahur shanak ihirub warub bape shokugi nahobig Genesaret iri. Eshesh shanak aria shakripesh sharauri arugeh hapeyeshi shetemi betog aria sharaesh shanaki um Jisas um agundok eshesh shemnek um anan nanak napeum. ");
INSERT INTO apec_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Aria ihirub debeirubi bani shokurubi warub douk Jisas nanak um, arpesh sharao esheshish arugeh hapeyeshi shanak sheshubuk agundok douk eshesh apa shapeum. Aria eshesh sharig Jisas dodogowish atish um arugeh hapeyeshi shususuhw anagasih um ananih rupah. Aria ihishmorim douk shasusuhw anagasihum ananih rupah iri, wata yopish. ");
INSERT INTO apec_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Anah nyumnah amam Farisi hani anam henek skulumesh um lo iri, douk hape iri Jerusalem iri hanaki aria hanak hape agundok Jisas napeum. ");
INSERT INTO apec_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Amam hape aria hatik um Jisas ananim disaipel madae hukwurupuguk wis kabi douk amam Farisi hakri um ba iyoh, aria kadak hunosuhw worigun hugnoh uwe. Douk namudok aria amam Farisi douk hakri Jisas ananim disaipel amamis wis goutukis atus iri. ");
INSERT INTO apec_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Amam Farisi hani ihishmorim Juda esheshin lo douk shagipesh seiwok esheshim babenomi henekenyuguk iri. Aria enen esheshin lo douk namudok. Eshesh madae shukwurupuguk wis ba iyoh um, eshesh ta mare shuwok anagun worigun uwe, uwok. ");
INSERT INTO apec_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Aria worigun shatorugun maket iri shopunek, douk shanaki shakwurupeshuk ba iyoh aria kadak shugnoh. Eshesh mare shukwurupesh um, eshesh ta mare shishoh. Aria eshesh shagipesh sabainyi lo shopunek douk seiwok esheshim babenomi heneken henyemaguk iri. Aria enen douk enyudok um shukwurup kas suni marus iri yaureruh hani betog um. ");
INSERT INTO apec_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Douk namudok aria amam Farisi hani amam henek skulumesh um lo iri harig Jisas hakri, “Um maresh? Aria nyakim disaipel douk madae hugipesh enyudok apakim babenomi amamin lo um hukwurupuguk wis ba iyoh aria kadak huwok worigun um uwe?” ");
INSERT INTO apec_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Aria Jisas nakripam nakri, “Ipak penek rohw iri. Seiwok profet Aisaia douk neyagwreh Iruhin ananin baraen aria nenyemaguk adurin baraen nyetemaguk Iruhin ananik Buk nakri um ipak! Ipak douk penek rohw kabi douk baraen nyetem Iruhin ananik buk iri nyakrium ipak um! Iruhin nakri, ‘Eshudok arpesh esheshig nukwatog otug shatuk eikin nyeigur nyato iruhw. Aria esheship urkwip douk madae purum eik uwe. ");
INSERT INTO apec_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Eshesh apa shakrip kupaishi arpesh meyoh sheneken iri lo, aria shenek rohwumesh shakri eshesh shakripesh eikin. Douk namudok aria eshesh shenek lotume meyoh.’” ");
INSERT INTO apec_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Aria Jisas wata nakripam nakri, “Ipak douk pakutukuk Iruhin ananin yopunyi lo aria pasuhw ipakish popehesh yamehesh sheneken iri lo pagipeshen. ");
INSERT INTO apec_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Aria ipak douk penek yoweishi inahos abom. Um maresh? Ipak pagipesh ipakih aih abom pekenyuk agabus Iruhin ananin yopunyi lo aria paen nyabuhuk. Aria ipak pasuhwen dodog ipakim babukenyim amamin lo pagipeshen. ");
INSERT INTO apec_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Um maresh? Seiwok Moses nakripep enyudok Iruhin ananin baraen lo um ipak pumnek ipakish amakenyish esheshin baraen aria putaurumesh. Aria ta enen arpen nyukri nyuho enyenyish amakenyish nyukripesh enen yoweinyi baraen um, enyudok arpen kupaishi arpesh ta shusuhwen shunak shen nyugok. ");
INSERT INTO apec_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Aria ipak Farisi pani ipak penek skulumesh um lo iri pakripesh enen sikin baraen. Ipak pakri, ta enen arpen nyunobuk enesh eshudok eneshenesh, o anabor utabor douk ta nyuko enyenyin yaken o amakek um nyutaurumesh um, aria enyen nyukripesh nyukri, ‘Eikibor utabor aria eshudok eneshenesh douk mare ta iko ipak um itaurumep um aria douk yagraehesh um iko Iruhin. Eik yakri eshudok korban.’ Baugenyum um enyudok baraen korban douk shakri, ‘Eshudok douk shagraehesh um shuko Iruhin iri.’ ");
INSERT INTO apec_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Douk namudok aria enyen madae nyutaurumesh nyukesh eshudok enyenyish amakenyish uwe. Aria ipak pakri, ‘Enyudok arpen nyunekesh namudok um, enyen wosik douk nyenek yopuhi aih.’ ");
INSERT INTO apec_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Douk namudok aria ipak pasuhw ipakim babukenyim amamin lo dodog pagipeshen. Aria Iruhin ananin lo douk nyakri apak mumnek apakish amakenyish esheshin baraen mutaurumesh um, ipak paen nyabuhuk. Aria shopunek, ipak penek sabainyi shopunek kabi enyudok douk eik yakripepen iri um.” ");
INSERT INTO apec_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Aria Jisas wata shopunek nahwar eshudok sabaishi armam armago shopunek shanaki anan napeum aria nakripesh nakri, “Ipak ihishmorim ta pumnek eikin baraen aria pudukemen wosik abom. ");
INSERT INTO apec_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Shape aduk iri eshudok shuni worigun douk arpen nyishoh shuwish numun enyenyihw apahw iri ta mare shuneken nyubosusih uwe, uwok. Eshudok douk shape numun enyudok arpen enyenyihw apahw aria shutograri aduk iri, douk ta eshudok shuneken nyubosusih. ");
INSERT INTO apec_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Aria douk ipak arigos sapenyepi ta pumnek enyudok baraen aria pusuwen dodog pugipeshen.” ");
INSERT INTO apec_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Anan nakripeshuk namudok aria nakutishukuk nanak nawish nani ananim disaipel hape urupat. Aria amam hariganum enyudok wobuwobren baraen iganigadae anan nakripesh-enyi. ");
INSERT INTO apec_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Aria anan nakripam nakri, “Ipak shopunek douk madae pudukemesh uwe? Worigun nani ihishmorim eshudok shape aduk, aria arpesh shashoh shabuh esheshiruh aparuh iri ta mare shubuh shunekesh shubosusih uwe, uwok. ");
INSERT INTO apec_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Um maresh? Worigun eshudok douk shashoh aria madae shunak shubuh shur esheship urkwip uwe. Eshesh douk shabuh shor aparuh aria wata shanak sharkegeshuk.” Jisas douk nakri namudok um nakri ihishmorim mahish aria worigun douk yopishi atish iri. ");
INSERT INTO apec_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Aria Jisas wata shopunek nakripam nakri, “Eneshenesh yoweishi inahos esheship urkwip porumesh aria eshesh mishish shakitakumesh shenekesh iri atish ta shunekesh shubosusih. ");
INSERT INTO apec_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","22","Um maresh? Eshudok douk gani numun esheship urkwip parik porum eshudok eneshenesh yoweishi inahos aria eshesh douk shenekesh. Eshesh shakwuaruh, urkwip porum yoweishi inahos, shabo arpesh shagok, shenek wehrur aria dodogeshish madae shukesh atin uwe arpesh. Aria shenek rohw um kupaishi, aria shopunek madae shusuhw merikwum eshesh kanak uwe. Aria eshesh shabrig enyudok lo um shanaraum um aria shenek nyigiya um kupaishi esheshish eshudok eneshenesh. Aria shaho kupaishi shakri eshesh atish debeishi, aria shenek rohw um kupaishi shakri eshesh shenek yoweishi inahos. Aria eshesh shakri shutuk esheshish atish nyeiguhw shuto iruhw aria shenek eneshenesh yoweishi inahos. ");
INSERT INTO apec_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Ihishmorim eshudok eneshenesh yoweishi inahos douk esheship urkwip porumesh aria shenekesh iri douk shenekesh shabosusih.” ");
INSERT INTO apec_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Aria Jisas nakutukuk abrudok wabur nakitak nanak um kupaigunum um, arbudok biarub warub Taia iri Saidon bape um. Anan nanak natogur aria nanak nawish nape anat urupat. Aria anan nakri uwok um enesh arpesh shudukemesh um anan nanak nape agundok um. Aria anan nabirak um nakri nunabeshuk nupe agundok aria uwok. ");
INSERT INTO apec_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Aria onok armatok douk okwokwik shokukwi nugawik enen yoweinyi sagab nyapenyok iri kwomnek um Jisas nanak napeum, aria okwok kwanak kwatrun. Okwok kwanak aria kwabuh kwoduk ohrubus kwakus hurukatin um Jisas ananiruh yeriweruh. ");
INSERT INTO apec_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Okwudok armatok okwok douk kupaiburi waburik, okwok madae Juda uwe. Okwok kwanaki abrudok wabur Fonisia, douk bape shokugi nahobig Siria iri. Aria okwok douk kweyagwreh Grikin baraen. Douk okwok kwanak aria kwakrip Jisas abom um nihiyahuk enyudok yoweinyi sagab douk nyape okwokwik nugawik iri nyutogur nyuruwok. ");
INSERT INTO apec_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Aria Jisas nakripok enyudok wobuwobren baraen nakri, “Eik ikesh worigun batowish iyoh. Um maresh, enyen douk madae wosik um apak muhur batowish-igun worigun muwashagun um nubag gwugnoh uwe, uwok.” ");
INSERT INTO apec_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Aria okwok kwakripan kwakri, “Debeini! Nyak nyakriyen iri baraen douk adurin abom. Aria nubag douk gwawish gweyatu shakamenyum tebol aria gwape gwawok tutukwanigun worigun douk batowish shashoh shenekesh shanatukuk iri.” ");
INSERT INTO apec_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Aria Jisas nakripok nakri, “Nyak nyabeime adurin eikin baraen. Douk namudok aria nyak wata nyutanam nyunak. Yoweinyi sagab douk iganigadae nyakutukuk nyakik nugawik nyatogur nyaruwok.” ");
INSERT INTO apec_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Aria okwok wata kwatanam kwanak um urupat aria kwatik um sagab nyakutukuk okwokwik nugawik nyatogur nyaruwok aria okwok kweshuhw wosik okwokwis aras. ");
INSERT INTO apec_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Aria Jisas nakutukuk abrudok wabur douk bape hurukatin um Tair um iri, aria nanak neshagrakuk Saidon aria nawish nanak agudok shokugi nahobig 10-poreirub warub bape um. Aria nanak nabuhuk debeigi waiyag Galili. ");
INSERT INTO apec_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Douk anan nanak natogur aria enesh arpesh sharauri anan arigos seshukani, aria shopunek madae niyagwreh atin iri uwe shanaki um Jisas. Aria eshesh sharigan abom um nuweman wis aria nugabeyan. ");
INSERT INTO apec_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Aria douk Jisas nemnekesh namudok aria naruman hakutukuk eshudok sabaishi armam armago shapeik aria amam atum hanak heyotuk sik. Aria nenyigur ananih heh hawish wobuwobur um arigos. Aria nokuseh arpigas sape ananih hah aria nagasayak anudok arman ananim yaham. ");
INSERT INTO apec_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Aria douk Jisas nenekesh namudok jurug, aria anan nanig natik iruhw heven aria hwosaran. Aria nakripan eshesh Juda esheshin baraen nakri, “Efata.” Baugenyum um enyudok baraen Efata douk shakri, “Nyak arigos togaragos nyumnek wosik aria wata nyiyagwreh.” ");
INSERT INTO apec_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Aria ahudok atuh ananigos arigos tagaragos sonukuk aria anan nemnek baraen wosik abom. Aria ananim yaham mumukem abom um ta manupok aria nape neyagwreh. ");
INSERT INTO apec_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Aria Jisas nakripesh nakri, “Ipak punak aria mare pukrip enesh arpesh um agundok yagabe anudok arman um.” Aria douk anan nakripesh namudok aria eshesh shanak shape shakripesh shanak um agundok Jisas nagabe anudok arigos seshukanari abom um. ");
INSERT INTO apec_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Eshesh shakripesh shanak, aria eshudok douk shemnek um enyudok iri shakitak yowiyokuk abom aria shakri, “Anan wosik nenek ihinyumorim yopinyi mour abom. Anan nagabe arigos seshukeshi shemnek, aria shopunek nagabe madae shiyagwreh atin iri uwe aria eshesh wata sheneyagwreh.” ");
INSERT INTO apec_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","2","Anah nyumnah, kupaishi sabaishi armam armago shantorum shanak shape Jisas napeum. Eshesh shape arigaha 3-poreih nyumneh aria worigun natuh. Aria Jisas nahwar ananim disaipel hanaki aria nakripam nakri, “Eik yakri gihaum eshudok arpesh. Um maresh? Eshesh shanaki shani apak mape 3-poreih nyumneh agundok aria eshesh worigun wokesh aria nyurub baesh. ");
INSERT INTO apec_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Aria eik mare ikesh anagun worigun shishoh ba iyoh, aria kadak shatanam shunak um esheshirub warub um, eshesh ta shunak yah aria marubigos sesh aria shutu shubuh. Um maresh? Enesh douk shanaki rougunum.” ");
INSERT INTO apec_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Aria ananim disaipel harigan hakri, “Agundok mapeik wehigunum arpesh uwok um. Douk namudok aria apak ta munak muparug anagun worigun agunum aria douk ta mubirom eshudok ihishmorim sabaishi arpesh?” ");
INSERT INTO apec_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Aria anan narigam nakri, “Aria ipak pasuhwi makwunit bret?” Aria amam hakripan hakri, “Apak masuhwi 7-poreit atin.” ");
INSERT INTO apec_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Aria Jisas nakrip eshudok sabaishi arpesh shabuh shape atap. Aria anan nohuri atudok 7-poreit bret nasuhwot aria nenek beten nenek tenkyu um Iruhin aria nawarut nako ananim disaipel um hisiyat hubiromesh. Aria amam hatrunat, aria hape habiromesh hanak. ");
INSERT INTO apec_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Aria amam hasuhwi anas karowis shokusi arbus shopunek. Aria Jisas nasuwos nenek beten nenek tenkyu um Iruhin aria neshopok ananim um hunak husiyasumesh shopunek. ");
INSERT INTO apec_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","9","Aria eshesh shashoh dugaresh aria shakusuk iri, ananim disaipel hatrishesh aria heshurukwi 7-poreiruh sararuh shishukniruh. Aria armam armago shawok eshudok worigun iri douk sabaishi abom um 4,000-poreish. Aria eshesh dugaresh aria Jisas neshopokesh shanak um esheshirub warub. ");
INSERT INTO apec_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Aria douk anan neshopokesh shanakuk atin, aria ahudok atuh anan nani ananim disaipel hato bot aria hanakum anarub warub douk bape shokugi nahobig Dalmanuta iri. ");
INSERT INTO apec_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Aria douk anam Farisi hanak Jisas napeum aria hani anan hape hanatutukem. Amam hakri hukwiraehan, douk namudok aria amam hariganum nunek enen Iruhin atun neneken iri mour um hudukemesh um anan douk adur Iruhin neshopokan nanaki iri. ");
INSERT INTO apec_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Aria Jisas hwosaranaguk abomaria nakri, “Ipak doukipari pakri eik inek enen Iruhin atun neneken iri mour aria ipak putrin um maresh? Adur atin eik yakripep, eik ta mare inek enen enyudokmori mour ipak putrin uwe, uwok.” ");
INSERT INTO apec_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Anan nakrip amam Farisi namudok aria wata nakutumuk ba hapeik aria nani ananim disaipel hakitak hato bot aria hanak gani wobrehahig um debeigi waiyag Galili. ");
INSERT INTO apec_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Amam hanak aria Jisas ananim disaipel urkwip pokomuguk um husuhw anat bret shopunek. Amam douk hasuhw atut bret meyoh tetemumam bot. ");
INSERT INTO apec_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Aria Jisas nakripam nakri, “Ipak gamo pudukemesh um amam Farisi huni Herot amamis yis.” ");
INSERT INTO apec_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Aria douk anan nakripam namudok aria amam kanak hape haneyagwreh hakri, “Anan nakripap enyudok baraen um yis um maresh, apak douk madae musuhwi anat bret uwe.” ");
INSERT INTO apec_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Aria Jisas iganig nadukemesh um amam hape haneyagwreh namudok um. Aria anan nakripam nakri, “Eik yakri uwok um ipak piyagwreh um agundok ipak bret wokep um. Ipak douk padukem baugenyum eikin baraen aka, uwok? ");
INSERT INTO apec_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","19","Ipak douk nabes sapenyep, aria ipak madae putik eshudok uwe? Aria ipak douk arigos sapenyep, aria ipak madae gamo pumnek uwe? Ipak douk urkwip wokepuguk um agundok nubokuhi yawor 5-poreit bret yabirom sabaishi 5,000-poreish arpesh abom um? Eik yabiromesh shashoh dugaresh aria shakusuk iri ipak patrishesh peshurukwi makwuniruh suraruh shishukniruh aria poruhubuk hakus?” Aria amam hakripan hakri, “Apak meshurukwi 12-poreiruh sararuh.” ");
INSERT INTO apec_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Aria Jisas wata shopunek narigam nakri, “Aria abudok nyutob eik yawor 7-poreit bret yabirom sabaishi 4,000-poreish abom armam armago, eshesh shashoh dugaresh aria shakusuk iri ipak patrishesh peshurukwi makwuniruh sararuh shishukniruh poruhubuk hakus?” Aria amam hakripan hakri, “Apak meshurukwi 7-poreiruh.” ");
INSERT INTO apec_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Aria anan naham aria narigam nakri, “Aria ipak douk madae pudukem enyudok baraen uwe um maresh? Eik douk madae ikripep um asudok aduris yis douk senek bret takitak debeiti iri uwe, uwok.” ");
INSERT INTO apec_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Aria Jisas nani ananim hanak arigaha hanak hatogur wabur Betsaida. Aria agundok enesh arpesh sharauri anan nabes seshukanari shanakumori Jisas aria shariganum nuweman wis aria nugabeyan. ");
INSERT INTO apec_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Aria douk eshesh shakripan namudok aria anan narum anudok nabes seshukanari hanakumaguk adukum wabur aria Jisas nakuseh arpigas sape anudok ananis nabes. Douk nakusehas jurug aria nowem wis nabes aria narigan nakri, “Nyak nyatik enesh eshudok aka, uwok?” ");
INSERT INTO apec_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Aria anudok nabes seshukanari natrugun aria nakri, “Eik yatik arpesh sharahaen aria eik madae gamo itrish wosik uwe. Eik yatrish ruhur atin kabi douk yatik rowos um.” ");
INSERT INTO apec_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Aria Jisas wata shopunek nowem wis ananis nabes aria douk anan natrugun duk abom. Ananis nabes yopus abom aria anan gamo natrugun aria natik ihishmorim eshudok eneshenesh wosik. ");
INSERT INTO apec_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Aria Jisas neshopokan nanak um ananit urupat aria nakripan nakri, “Nyak kare um nyakit urupat. Nyak mare nyutanam nyunak um wabur uwok.” ");
INSERT INTO apec_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Aria Jisas nani ananim disaipel hakutukuk Galili aria hakitak hanakum anarub warub douk bape shokugi nahobig Sisaria Filipai iri. Douk amam hanak yah aria Jisas narigam nakri, “Ipak pemnek arpesh shakri eik amiapen?” ");
INSERT INTO apec_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Aria amam hakripan hakri, “Enesh shakri nyak douk Jon douk nenek baptaisumesh iri, aria enesh shakri nyak Ilaija, aria enesh shakri nyak anan profet.” ");
INSERT INTO apec_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Aria anan narigam nakri, “Douk eshesh shakri namudok aria ipak kanak pakri eik amiapen?” Aria Pita nakripan nakri, “Nyak Krais douk Iruhin nagraehen neshopoken nyanamori nyunarao arpesh iri.” ");
INSERT INTO apec_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Aria Jisas nakripam dodogowinyi baraen nakri, “Douk ipak padukemesh aria ipak mare punak pukrip enesh arpesh um eik douk Krais douk Iruhin nagraehe aria neshopoke yanaki iri um.” ");
INSERT INTO apec_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Aria Jisas apa nakrip ananim disaipel nakri, “Eik Anudok Arman douk yatogur adurinyi arpen iri ta imnek debeiri eriger. Aria eshesh Juda esheshim debeimi huni debeimi pris huni amam henek skulumesh um lo iri, ta huke agabus aria huneke enenyenen. Aria ta she igok shurume wonugwehw biyeh nyumneh, aria hukri um biyeh atih nyumneh um, eik ta wata ikitak ipe.” ");
INSERT INTO apec_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Enyudok baraen anan douk madae nukripam wobuwobren uwe, uwok. Anan nawerehen abom nakripam. Douk namudok aria Pita naran hanak heyotuguk anagas aria nape nahan nakri, “Nyak mare nyukri enyudok baraen.” ");
INSERT INTO apec_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Aria Jisas natanam natik ananim disaipel aria naho Pita nakri, “Satan, kareik. Nyak douk madae nyugipesh Iruhin ananim urkum uwe. Nyak nyagipesh arpeship urkwip meyoh!” ");
INSERT INTO apec_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Aria Jisas nahwar eshudok sabaishi arpesh shani ananim disaipel shanak agundok anan napeum aria nakripesh nakri, “Arpen douk nyukri nyugipesh eik iri, sagomatin enyen ta nyukri uwok abom um enyen mare nyugipesh enyenyim urkum. Aria enyen mare nyunogugur um shen nyugok um aria nyusah enyenyin rowog kruse um, aria enyen wosik ta nyugipeshe. ");
INSERT INTO apec_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Aria ta enen arpen enyenyim urkum murum nyukri enyen mare nyugok aria nyupe namudok atin iri, enyen ta nyugok. Aria enyudok arpen douk nyunek eikin mour aria nyusuhw Iruhin ananin yopinyi baraen dodog iri kupaishi ta shen nyugok. Aria enyen ta wata nyupe wosik ihih nyumneh. ");
INSERT INTO apec_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Aria eshudok arpesh douk shunogrem sabaishi eneshenesh eshudok, aria eshesh shukri eshesh douk shape wosik aria ta mare shugok iri, eshesh ta shugok abom. ");
INSERT INTO apec_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Ta mare enen arpen nyukwu enyenyish eshudok eneshenesh um nyutor agundok um nyupe wosik ihih nyumneh um, uwok. ");
INSERT INTO apec_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Aria shopunek douk, sabaishi arpesh shape agundok atap iri shape shenek eneshenesh yoweishi inahos. Eshesh shakenyuk agabus Iruhin ananin baraen shakri enyen madae adurin uwe. Aria ahudok nyumnah Eik Anudok Arman douk yatogur adurinyi arpen iri itanamori iniri Iruhin ananish yopiyopishi enselahos inakmori, Iruhin ta nutaurume itogur dodogoiwe atuwe abom itrugun abom aria inaki. Aria abudok nyutob eik inaki obi nyutob, eshudok arpesh douk shenenek abraen um eik, aria shakenyuk agabus eikin baraen iri, eik shopunek ta inekumesh abraen aria ikeshuk agab namudok atin.” ");
INSERT INTO apec_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Aria anan wata shopunek nakripesh nakri, “Adur atin eik yakripep! Enep douk peyotu agundok iri ta mare arigas pugok, uwok. Ipak ta wata pupe aria putik agundok Iruhin dodogowin atun nupe Debeini um ananish arpesh shapeum.” ");
INSERT INTO apec_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Douk 6-poreih nyumneh hanak hadiguk, aria Jisas narao Pita nani Jems aria Jon atum hanaman hato hakih hape onohw rouhwi yoduhw. Amam hakih hape aria amam hatik um Jisas nenek senis natrugun nape anahaeh. ");
INSERT INTO apec_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Aria ananih rupeh shopunek hatrugun hatogur shigorihwih abom. Arpesh shape agundok atap iri douk madae enesh shukwrup esheshih rupeh hutrugun abom hutogur shigorihwih namudok uwe. ");
INSERT INTO apec_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Aria agundok Pita nani Jems aria Jon hatik Ilaija aria Moses hatogur hani Jisas heyotu hape heyagwreh. ");
INSERT INTO apec_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Aria Pita nakrip Jisas nakri, “Tisa, enyen douk wosik um apak mape agundok um. Aria apak muwem 3-poreiyu shomeguhwiyu. Nyak onok aria bio um Moses nini Ilaija.” ");
INSERT INTO apec_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Pita douk nakripan namudok Jisas um maresh, amam hanogugur abom aria Pita madae nudukemesh um maren baraen anan ta nukriyen iri uwe. ");
INSERT INTO apec_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Aria douk Pita nape nakripan namudok aria onog orug gwanaki iruhw aria goma nyeshigorum aria amam hemnek anah mah hanaki agwudok orug. Aria enyudok arpen nyeyagwrehi iri nyakri, “Anudok douk eikin nuganin douk eik urkum manawashaman iri abom. Ipak pumnek ananin baraen!” ");
INSERT INTO apec_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Aria douk amam hemnek namudok aria ahudok atuh amam hatanam hatrugun aria madae hutik enesh arpesh shopunek shuni amam shiyotuguk uwe. Amam hatik Jisas atun nani amam neyotuguk. ");
INSERT INTO apec_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Aria douk amam wata hakutukuk yoduhw hape habuhi aria Jisas nakripam nakri, “Ipak punak aria mare pukrip enesh arpesh um enyudok iganigadae patrin iri, uwok. Ipak pupe arigaha shubo Eik Anudok Arman douk yatogur adurinyi arpen iri igok aria wata ikitak ipe aria ipak douk ko pukripesh-umen.” ");
INSERT INTO apec_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Aria douk anan nakripam namudok aria amam hemnek ananin baraen hagipeshen. Aria amam kanak hape heneyagwreh hanakripam hakri, “Douk baugenyum baraen um anan nakri, ‘Eik Anudok Arman douk yatogur adurinyi arpen iri wata ikitaki wonugwehw’, anan douk nakri um maresh?” ");
INSERT INTO apec_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Aria amam harigan hakri, “Amudok douk henek skulumesh um lo iri douk hakripesh hakri ta Ilaija nurik nunaki aria Krais, douk Iruhin nagraehan neshopokan nanaki iri ta nugiki um maresh?” ");
INSERT INTO apec_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Aria Jisas nakripam nakri, “O enyen adur! Ilaija douk narik nanaki um nugabe eneshenesh eshudok. Aria ipak urkwip purum enyudok baraen douk nyetem Iruhin ananik Buk iri. Baraen douk nyakri, ‘Eik Anudok Arman douk yatogur adurinyi arpen iri ta imnek debeiri eriger aria arpesh ta shukri uwok aria shuke agabus.’ Aria enyen douk nyetem namudok um maresh? ");
INSERT INTO apec_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Aria adur atin eik yakripep! Kupaini Ilaijadouk nanaki aria arpesh shagipesh esheship urkwip aria shenek eneshenesh yoweishi inahos um anan. Eshesh shenekesh-uman kabi douk baraen nyetem Iruhin ananik Buk iri nyakrium.” ");
INSERT INTO apec_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Aria Jisas nani ananim 3-poreim disaipel hatanam habuhi hanak haparug amudok anam disaipel agundok douk amam hapeum. Aria amam hatik um sabaishi arpesh shanak sheyotu shersharih amudok anam disaipel. Aria agundok, anam henek skulumesh um lo iri hani amam Jisas ananim disaipel hape hanatutukem. ");
INSERT INTO apec_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Aria douk ihishmorim shatigu Jisas aria eshesh shakitak yowiyokuk. Aria eshesh shahur shanak shatogurum anan napeum aria shanadudareh-uman shakri, “O yopuhi nyumnah nyak!” ");
INSERT INTO apec_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Aria Jisas narig ananim disaipel nakri, “Ipak pani amam panatutukem um maresh?” ");
INSERT INTO apec_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Aria anan arman douk nani eshudok sabaishi sheyotu iri nakrip Jisas nakri, “Debeini Tisa, eik yarauri eikin nuganin um nyak. Um maresh? Enen yoweinyi sagab nyapeyan nyanaur um aria madae niyagwreh atin uwe. ");
INSERT INTO apec_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Aria sabaihi nyumneh yoweinyi sagab nyanaur nyatukan nabuh nakus atap aria arpigas satograri ananit nokwat. Aria shopunek, anan nanatukwesh naruh nenek kruti krutek aria ananish roguhw aiyas shanadudaresh aria dudugeshish abom. Aria eik yarig nyakim disaipel um huhiyahuk enyudok sagab nyutogur nyuruwok aria amam habirak hatik uwok.” ");
INSERT INTO apec_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Aria Jisas nemnek namudok aria nakrip eshudok armam armago nakri, “Ipak doukipari, eik yani ipak mape roubum nyutob ipakibur wabur aria ipak madae punek bilip uwe. Aria ipak pakri eik ta wata ipeum itaurumep namudok atin um isah ipakin enenyenen amaen um, aka? Nyarauri anudok shokuni!” ");
INSERT INTO apec_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Aria eshesh sharanari shanak um Jisas. Douk anan nanak aria enyudok sagab nyatigu Jisas aria nyanaur nyatukan nabuh nakus atap aria ohwas sanakan nokwat. ");
INSERT INTO apec_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Aria Jisas narig anudok sagab nyanaur iri ananin yaken nakri, “Sagab nyanaur nape makwunih nyumneh?” Aria anan nakripan nakri, “Seiwok anan wata shokuni um, sagab nyape namudok arigaha douk. ");
INSERT INTO apec_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Aria shopunek, sabaihi nyumneh enyudok sagab nyakri nyon nugok. Enyen nyanaur nyatukan nabuh argab um nyih hunun nugok. Aria anabik um, nyanaur nyatukan nabuh worub um nubuh sukutan aria nuraguk worub. Aria ta nyak dodogowinyum nyugabeyan, nyak nyukri giha aria nyutaurumohw!” ");
INSERT INTO apec_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Aria Jisas nakripan nakri, “Adur, ta nyak nyukri um! Um maresh? Eshudok arpesh douk shunek bilip um eik iri, eshesh ta dodogowish um shunek ihinyumorim enenyenen mour.” ");
INSERT INTO apec_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Aria ahudok atuh, anudok sagab nyanaur iri ananin yaken nakrip Jisas nakri, “Eik yenek bilip um nyak aria eikin bilip madae dodogowin abom uwe. Aria eik yakri nyak nyutaurume aria eikin bilip nyutogur dodogowin abom.” ");
INSERT INTO apec_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Aria douk Jisas natik um eshudok sabaishi shahur shanaki hurukatinyum anan, aria anan naho enyudok sagab nakri, “Nyak yoweinyi sagab douk nyenek anudok nuganin nagugak aria madae niyagwreh atin iri uwe. Eik yakripenyum nyukutunukuk nyutogur nyunak aria mare wata nyutanamori nyuwishan!” ");
INSERT INTO apec_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Aria enyudok sagab nyahwar debeg aria nyatuk anudok shokuni arman nyanaur atap aria nyakutunuguk nyatogur nyaruwok. Aria anan krukruk nakus kabi douk shagok iri shakus um. Aria sabaishi arpesh shopunek shatrun aria shakri anan nagok. ");
INSERT INTO apec_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Aria Jisas nasuhw ananin rogur aria nonohur nakitak neyotu iruhw. ");
INSERT INTO apec_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Aria douk Jisas nani ananim disaipel atum hawish hape urupat aria amam harigan hakri, “Apak douk mabirak aria madae dodogowipam muhiyahuk enyudok sagab uwe, um maresh?” ");
INSERT INTO apec_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Aria anan nakripam nakri, “Douk ipak pushakur um worigun aria punek beten porik Iruhin nutaurumep akure, ipak ta puhiyahen. Aria douk ipak atip madae dodogowip uwe.” ");
INSERT INTO apec_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Aria amam hakutukuk abrudok wabur aria hawish hanak shokugi nahobig Galili aria hanak. Douk hanak aria Jisas nakri uwok um enesh arpesh shudukemesh um agundok amam hanak hapeum. ");
INSERT INTO apec_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Um maresh? Anan nape nakripam sabainyi ananin yopinyi baraen ananim disaipel. Anan nakripam nakri, “Arpesh ta shiyabig eikim horim um Eik Anudok Arman douk yatogur adurinyi arpen iri aria ta husuwe hunak he igok. Aria wata hukri um biyeh atih nyumneh um, eik ta wata ikitak ipe.” ");
INSERT INTO apec_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Aria amam madae hudukem baugenyum enyudok baraen uwe. Aria shopunek, amam hanogugur aria madae horigan uwe. ");
INSERT INTO apec_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Douk amam hanak hatogur Kaperneam, aria hanak hawish hape anat urupat aria Jisas narig ananim disaipel nakri, “Iganigadae manaki yah um, ipak pape peyagwreh pakri maresh?” ");
INSERT INTO apec_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Aria amam madae hukripan enen baraen uwe. Um maresh? Iganigadae amam hanak yah um, amam kanak hape hanatutukem um meini ta nupe debeini um amam ihim-morim. ");
INSERT INTO apec_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Aria Jisas nabuh nape atap, aria nahwar ananim 12-poreim disaipel hanaki aria nakripam nakri, “Eshudok arpesh douk shukri shupe debeishi iri, sagomatin eshesh ta shupe kabi douk shokwishi um. Aria shupe shakamum ihishmorim arpesh shunekumesh mour meyoh aria eshesh ta kadak shupe debeishi.” ");
INSERT INTO apec_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","37","Aria Jisas nahwari enen batowin nyanaki nenyusap nyeyotu amam hapeum hutrin aria anan natuken nasuwen aria nakripam nakri, “Eshudok arpesh douk urkwip purum eik aria shutaurum enen batowin kabi douk enyudok um, eshesh douk shutaurum eik. Aria eshudok douk shutaurum eik iri douk madae shutaurum eik atuwe uwe, uwok. Eshesh douk shutaurum anudok douk neshopok eik yanaki iri shopunek.” ");
INSERT INTO apec_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Aria Jon nakrip Jisas nakri, “Debeini Tisa, apak matik anan arman nape nahiyahuk sagabehos um nyakin nyeigur aria eshesh shatogur sharuwok. Aria apak makripan um anan mare wata nunekesh namudok uwe, uwok. Um maresh? Anan douk madae nugipesh apak iri uwe.” ");
INSERT INTO apec_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Aria Jisas nakripam nakri, “Ipak mare pukripan um nukutukuk enyudok mour anan nape neneken iri. Um maresh? Eshudok douk shenek Iruhin atun neneken iri mour um eikin nyeigur iri ta mare shukri enen yoweinyi baraen um eik. ");
INSERT INTO apec_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Aria eshudok douk shataurumep iri douk shaniguk ipak. ");
INSERT INTO apec_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Adur atin eik yakripep! Eshudok arpesh douk shukri ipak douk eikip aria eshesh douk shukep anabar abar um eikin nyeigur um, Iruhin ta nubukumesh yopishi eshudok eneshenesh shukusumesh.” ");
INSERT INTO apec_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Aria Jisas nakripesh enyudok baraen shopunek nakri, “Aria enen arpen nyunek enen um eshudok shokwishi douk shenek bilip um eik iri nyunek yoweishi inahos um, enyen douk nyenek yoweishi inahos abom. Aria ta shusuhwen shuwaur anam debeimi utom um enyenyin aruhwigur aria shuwashen nyubuhuk youg akure, enyen ta nyupe yoweinyi poe. Aria Iruhin ta neneken nyumnek debeiri eriger abom reshagrakuk agundok nyumnek eriger um shuwashen youg um. ");
INSERT INTO apec_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Douk namudok aria ta enen nyakin rogur nyuneken nyunek yoweishi inahos um, nyak nyutupen nyunakuk aria atin meyoh nyupeik. Douk atin rogur nyupemenyum, nyak ta nyunak nyupe wosik ihih nyumneh. Ta biyesh roguhw shupe aria shuneken nyunak um abrudok yoweiburi wabur hel, douk nyih hanu hape namudok ihih nyumneh aburi. ");
INSERT INTO apec_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Aria abrudok yoweiburi wabur hel douk nyih hanu ihih nyumneh iri hanu um, eheh ta mare hugok atin uwe, uwok. Aria eshudok kabi douk eshuguh um ta shunatuken. Aria shopunek, eshesh ta mare shugok uwe, uwok. Eshesh ta shupe ihih nyumneh. ");
INSERT INTO apec_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Aria ta onohw nyakihw yerihw hwuneken nyunek yoweishi inahos nyukanaguk agab Iruhin um, nyutupohw hwunakuk aria atuhw hwupeik. Douk atuhw yerihw hwupeimenyum, nyak ta nyunak nyupe wosik ihih nyumneh. Ta bioruh yeriweruh hupeimen aria huraen nyunak um abrudok yoweiburi wabur hel, douk nyih hanu hape namudok ihih nyumneh aburi. ");
INSERT INTO apec_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Aria abrudok yoweiburi wabur douk nyih hanu ihih nyumneh iri hanu um, eheh ta mare hugok atin uwe, uwok. Aria eshudok kabi douk eshuguh um ta shunatuken. Aria shopunek, eshesh ta mare shugok atin uwe, uwok. Eshesh ta shupe ihih nyumneh. ");
INSERT INTO apec_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Aria ta anap nabep puneken nyunek yoweishi inahos um, nyak nyutukapuk aria atup meyoh pupeumen. Douk atup pupeumenyum, nyak ta nyunak nyuwish nyupe agundok douk Iruhin nape Debeini um ananish arpesh shapeum. Ta biyos nabes supemen aria suneken nyunak um abrudok yoweiburi wabur hel, douk nyih hanu hape namudok ihih nyumneh aburi. ");
INSERT INTO apec_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Aria abrudok yoweiburi wabur douk ‘nyih hanu ihih nyumneh iri hanu um, eheh ta mare hugok atin uwe, uwok. Aria eshudok kabi douk eshuguh um ta shunatuken. Aria shopunek, eshesh ta mare shugok atin uwe, uwok. Eshesh ta shupe ihih nyumneh.’ ");
INSERT INTO apec_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Ihishmorim arpesh shape agundok atap iri ta nyih hunish aria hunekesh shukutukuk eneshenesh yoweishi inahos. Ehudok nyih ta hunish aria hunekesh shutogur yopish. Eshesh ta shutogur yopish kabi douk showem sol mahish renekesh shatogur yopish. ");
INSERT INTO apec_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Aria sol arar douk yopuri. Aria ta arar wata jemiyair um, arpesh ta mare enen ta wosik wata nyunekar ekehir, uwok. Aria ipak douk pape namudok atin kabi douk ekeh iri sol um. Douk namudok aria ipakiruh aparuh ta hur wosik aria ipak mare purpak punitok uwe, uwok. Ipak ta punagabe um pupe atugun.” ");
INSERT INTO apec_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Aria Jisas nakitak nakutukuk abrudok wabur nanak um shokugi nahobig Judia. Anan nakitak nabrig worub Jordan aria nanak gani wobrehahibam. Aria sabaishi arpesh shanaki shape anan napeum, aria nape nakripesh yopinyi baraen kabi douk ihih nape nakripesh um. ");
INSERT INTO apec_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Aria anam Farisi hanaki anan napeum henek rohwuman aria hakri hukwiraehan um enen baraen. Aria amam harigan hakri, “Nyak kripap, apakin lo douk nyakri wosik um anan arman niyatok ananik irohukwik aka, uwok?” ");
INSERT INTO apec_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Aria Jisas narigam nakri, “Seiwok Moses nakripep maren dodogowinyi lo?” ");
INSERT INTO apec_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Aria amam hakri, “Moses douk nakri wosik um anan arman nukri niyatok ananik irohukwik, anan ta nenekumok anap shup um agundok eshesh sheneyatak um nukok kwunasuop, aria nishopokok kwunak um okwokwumok um.” ");
INSERT INTO apec_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Aria Jisas nakripam nakri, “Moses douk nawemumep-oguk enyudok dodogowinyi lo ipak um maresh? Ipak douk baragos seshukep abom. ");
INSERT INTO apec_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Aria seiwok baugos um Iruhin nenek eneshenesh eshudok um, baraen nyetem Iruhin ananik Buk iri douk nyakri, ‘Iruhin nenekesh arman iri armatok. ");
INSERT INTO apec_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Douk namudok aria arman ta nukutukuk ananish amakenyish aria nunak nini ananik irohukwik shupe sik. ");
INSERT INTO apec_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Aria eshesh biyesh ta shutogur atin arpen.’ Eshesh ta mare wata shupe kabi douk biyesh um uwe, uwok. ");
INSERT INTO apec_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Douk namudok aria arpesh kanak ta mare shubrig enesh eshudok douk Iruhin nuweshikesh nakri shupe atugun iri uwe, uwok.” ");
INSERT INTO apec_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Aria Jisas nani ananim disaipel hanak hawish urupat aria amam hariganum enyudok baraen iganigadae anan nakripesh-enyi. ");
INSERT INTO apec_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Aria anan nakripam nakri, “Aria anan arman niyatok ananik irohukwik aria wata nurao kupaikwi um, anan douk nabrig enyudok lo um shanaraum um. Aria anan nani okwok douk shenek yoweishi inahos um sheshuh atugun um shenek wehrur. ");
INSERT INTO apec_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Aria douk namudok atin. Aria onok armatok kwiyatok okwokwin raminen aria wata kwunak kwurao kupaini um, okwok douk kwabrig enyudok lo um shanaraum um. Aria okwok kwani anan douk shenek yoweishi inahos um sheshuh atugun um shenek wehrur.” ");
INSERT INTO apec_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Aria enesh arpesh sharauri enesh batowish shanaki um Jisas um nuwemesh wis, aria nunekumesh yopunyi. Aria Jisas ananim disaipel hahaesh hakri, “Ipak mare puraesh punaki um Jisas, uwok.” ");
INSERT INTO apec_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Aria Jisas nemnekam namudok aria anan nyibur juwehosibur aria naham nakri, “Ipak kutukuk eshudok batowish shunaki um eik. Um maresh? Eshudok arpesh douk shape kabi eshudok shokwishi batowish ta shuwishi abrudok wabur Iruhin nape Debeini um ananish arpesh um. ");
INSERT INTO apec_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Adur atin eik yakripep! Eshudok arpesh douk shukri shuwishi abrudok wabur Iruhin nape Debeini um ananish arpesh um, aria eshesh mare shukon aparuh Iruhin abom kabi douk batowish shakon aparuh um, eshesh ta mare shuwishi.” ");
INSERT INTO apec_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Aria anan natuk eshudok shokwishi batowish nuwemesh wis atin atin, aria nenekumesh yopinyi. ");
INSERT INTO apec_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Douk Jisas nakutukuk agundok nakitak nape nanak yah, aria anan arman nahur nanak natogruman. Aria nanak nabuh noduk ohrubus natik atap aria narig Jisas nakri, “Yopuni tisa, eik ta inek maresh aria ta douk ipe wosik abom ihih nyumneh?” ");
INSERT INTO apec_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Aria Jisas narigan nakri, “Nyak nyahware yopuweiri um maresh? Iruhin atun douk yopuni. ");
INSERT INTO apec_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Nyak douk nyadukemen enyudok lo douk nyetem Iruhin ananik Buk iri. Enyen douk nyakri, ‘Ipak mare pubo kupaishi arpesh shugok. Mare puni armago punek wehrur um, mare pukwuaruh, aria mare punek rohw um kupaishi pukri eshesh shenek enesh yoweishi inahos. Aria shopunek, mare punek rohw um kupaishi punarukesh esheshish eshudok eneshenesh meyoh, uwok. Aria pumnek ipakish amakenyish esheshin baraen aria putaurumesh.’” ");
INSERT INTO apec_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Aria anudok arman nakrip Jisas nakri, “Tisa, seiwok eik wata shakuwe um yape yanaki arigaha douk, eik yasuhw enyudok ihinyumorim lo yagipeshen.” ");
INSERT INTO apec_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Aria Jisas natrun aria anan urkum manawashaman aria nakripan nakri, “Nyak douk atin meyoh yopunyi mour wata nyape, nyak wata nyuneken uwe. Nyak nyunak nyuhur ihishmorim nyakish eshudok eneshenesh nyuko kupaishi shutorish shuken utabor. Aria nyunak nyisiyabor um eshudok yaruhish arpesh. Nyak nyunekesh namudok aria kweipon nyak ta nyirao yopishi eshudok eneshenesh gani iruhw heven. Aria nyak nyunekesh namudok iyoh, aria douk nyunaki nyugipeshe.” ");
INSERT INTO apec_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Aria douk anudok arman nemnek namudok, aria anan apahw amaenyihw aria ananin domaen nyotohiyahi abom aria nanak. Um maresh, anan douk nagrem sabaishi eshudok eneshenesh. ");
INSERT INTO apec_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Aria Jisas neshakam ananim disaipel nernarih jurug aria nakripam nakri, “Eshudok arpesh douk shanagrem sabaishi eshudok sheneshubuk iri ta shenek debeinyi mour um shuwishi abrudok wabur Iruhin nape Debeini um ananish arpesh um.” ");
INSERT INTO apec_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Aria ananim disaipel hemnek ananin baraen aria hakitak yowiyokuk. Aria Jisas wata shopunek nakri, “O ipak eikish arpesh! Eshudok arpesh douk shakri eneshenesh eshudok ta shutaurumesh um shuwishi abrudok wabur Iruhin nape Debeini um ananish arpesh um ta shunek debeinyi mour ba iyoh aria kadak shuwishi. ");
INSERT INTO apec_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Aria enen debeinyi mahin shahwaren um kamel iri nyukri nyuwishi nyil, agundok nagor um tret tananyigur um rupeh hanatape um, enyen ta nyunek shokwinyi mour meyoh aria nyuwishi. Aria eshudok arpesh douk shanagrem sabaishi eshudok eneshenesh iri ta shunek debeinyi mour abom aria kadak shuwishi.” ");
INSERT INTO apec_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Aria douk ananim disaipel hemnek namudok aria hakitak yowiyokuk abom. Aria amam kanak hape hanarig um hakri, “Anan nakri namudok aria Iruhin ta nunarao meishi shutanamori shupe wosik atin?” ");
INSERT INTO apec_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Aria Jisas neshakumam duk aria nakripam nakri, “Arpesh eshesh kanak ta mare dodogowish um shuwishi agundok Iruhin nape Debeini um ananish arpesh um. Eshesh atish ta shubirak shutik uwok. Aria Iruhin nutaurumesh um, eshesh wosik ta shuwishi. Um maresh? Iruhin douk dodogowin abom aria nunek ihishmorim eshudok eneshenesh.” ");
INSERT INTO apec_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Aria Pita nakripan nakri, “Jisas nyak mnek, apak douk makutukuk ihishmorim apakish eshudok eneshenesh aria manaki memnek nyakin baraen masuhwen aria magipesh nyak.” ");
INSERT INTO apec_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","30","Aria Jisas nakripam nakri, “Adur atin eik yakripep! Eshudok arpesh douk shukutukuk esheshig urusag, gwuni esheshish ashukenyish owashish, shuni esheshiyu mohwiyariyu, uni esheshiyu amakenyiyu, uni esheshim arhim, huni esheshish batowish, shuni esheshigos nubarigos um shugipesh eik aria shukripesh eikin yopinyi baraen iri, abudok nyutob eshesh wata shupe agundok atap um, Iruhin ta nukesh sabaishi eshudok eneshenesh shopunek abom shishagrakuk riguk sharik sharaesh iri. Iruhin ta nukesh urusag gwuni ashukenyish owashish, aria mohwiyariyu uni amakenyiyu, uni batowish aria nubarigos. Aria shopunek, kupaishi ta shukesh agabus aria shunekesh shurao amaen shumnek eriger. Aria eshesh ta wata shunak shupe wosik abom ihih nyumneh. ");
INSERT INTO apec_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Aria eshudok arpesh douk shape debeishi iri ta wata shupe kabi douk shokwishi um. Aria eshudok douk nyeiguhw wokeshi ta wata nyeiguhw shuto iruhw.” ");
INSERT INTO apec_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Aria Jisas nakitak nani ananim disaipel hape hagim yah hanak hato um Jerusalem. Jisas nakitak narik aria ananim disaipel hakitak yowiyokuk aria amamip urkwip por yowep aria hagiman hanak. Aria eshudok arpesh douk shagimam shanak iri shopunek shanogugur. Aria Jisas wata shopunek narao ananim atum hanak aria anan nape nakripam um eshudok eneshenesh douk ta shutogur-uman iri. ");
INSERT INTO apec_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Anan nakripam nakri, “Ipak pumnek! Douk apak munak um Jerusalem. Apak ta munak agundok aria anan arman ta niyabigam Eik Anudok Arman douk yatogur adurin arpen iri um amam debeimi pris huni amam henek skulumesh um lo iri. Aria amam ta husuwe hunak hunek kwotume aria hurae um amam douk madae Juda iri uwe um hunak he igok. ");
INSERT INTO apec_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Aria ta huneke enenyenen hiyokase aria hukwusehe. Aria ta hupuruke madururuh aria he igok. Aria douk hukri um biyeh atih nyumneh iri, eik ta wata ikitak ipe.” ");
INSERT INTO apec_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Aria Sebedi ananim biom nugamim Jems iri Jon hanaki um Jisas aria hakripan hakri, “Debeini tisa, ohwak wakri ukripen enen baraen aria nyak nyumnekohw aria nyunek-umohw um eshudok douk ta ohwak warigen-umesh iri.” ");
INSERT INTO apec_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Aria Jisas narigam nakri, “Ipak pakri inekumep maresh?” ");
INSERT INTO apec_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Aria amam hakripan hakri, “Ohwak wakri abudok nyutob nyak nyurao debeinyi nyeigur, aria dodogowin nyutrugun abom um, ohwak shopunek wakri ohwakish nyeiguhw shuto iruhw aria upe debeihwi. Anan nupe um yopunyi rogur ehah aria anan nupe um anagagrinyum.” ");
INSERT INTO apec_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Aria Jisas nakripam nakri, “Ipak douk madae pudukemesh um enyudok ipak parige-umen iri uwe. Ipak wosik ta dodogowip um pumnek arudok debeiri eriger douk hurukatin um ta eik imnekor iri? Kupaishi ta she imnek debeiri eriger aria ta igok. Aria ipak douk wosik ta pakri um shusuwep shunak shep punomnek debeiri eriger ba iyoh, aria kadak pugok kabi douk eik um?” ");
INSERT INTO apec_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Aria amam hakripan hakri, “Wosik, ohwak wosik ta unekesh namudok.” Aria Jisas nakripam nakri, “Wosik, ipak wosik ta pumnek debeiri eriger douk ta eik imnekor iri. Aria shopunek, ta wosik kupaishi shusuwep shunak shep pumnek debeiri eriger aria ipak anan kweipon nugok um. ");
INSERT INTO apec_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Aria enyudok um ipak anan nupe um yopunyi rogur ehah, aria anan nupe um anagagrinyum aria ipak nyeiguhw shuto iruhw um, enyen douk Iruhin ananin mour. Eshudok arpesh douk seiwok Iruhin anan kanak nanagraehesh iri eshesh atish ta nyeiguhw shuto iruhw aria enesh shupe um yopunyi rogur ehah, aria enesh shupe anagagrinyum.” ");
INSERT INTO apec_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Aria douk amudok anam 10-poreim disaipel hemnek enyudok baraen Jems aria Jon hakriyen iri aria amam nyirub juwehosirub um Jems nani Jon. ");
INSERT INTO apec_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Aria Jisas nahwari ihim-morim hanaki hape atugun um anan napeum aria nakripam nakri, “Ipak douk padukemesh um eshudok douk madae shudukem Iruhin iri uwe um esheshih aih um esheshim debeimi. Amudok douk shahwaram um debeimi iri, douk dodogowim atum abom aria dodogowim um kupaishi arpesh um shunek sabainyi enenyenen debeinyi mour. ");
INSERT INTO apec_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Aria ipak ta mare punekesh namudok uwe, uwok. Aria ipak anan nukri nupe debeini um ipak enep um, sagomatin anan ta nenek-umep mour meyoh ipak ihim-morim ba iyoh, aria anan ta kadak nupe debeini um ipak. ");
INSERT INTO apec_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Aria shopunek, ta ipak anan nukri nyeigur nyuto iruhw iri, sagomatin anan ta nyeigur uwok meyoh um nupe shakamum ipak ihim-morim aria nunek-umep mour meyoh aria anan ta kadak nyeigur nyuto iruh-uman. ");
INSERT INTO apec_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Aria Eik Anudok Arman douk yatogur adurinyi arpen iri douk madae inakumori kupaishi arpesh shunekume mour uwe, uwok. Eik yanakmori itaurum arpesh inekumesh mour. Aria um ikesh eik kanak um she igok um itor sabaishi arpesh ikweshihesh um esheshish yoweishi inahos.” ");
INSERT INTO apec_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Aria Jisas nani ananim disaipel hanak hatogur wabur Jeriko aria Jisas nakutubur-ukuk nape nanak. Aria ananim disaipel hani sabaishi arpesh shopunek shanaman shanak. Aria agundok, Timeus ananin nuganin Bartimeus nape. Anan nabes seshukan aria nape anagas um yah. Aria ihih nyumneh anan nape nahwar arpesh sharahaen yah iri um shukon anabor utabor. ");
INSERT INTO apec_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Aria douk anan nemnek um Jisas douk nanaki wabur Nasaret iri nanaki um, aria anan nahwar debeg nakri, “Jisas, Devit ananin barhonin! Nyak nyukri gihaum eik!” ");
INSERT INTO apec_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Aria sabaishi armam armago shahan shakripan um mokureg. Aria anan madae numnekesh uwe. Anan nahwar debeg abom nakri, “Devit ananin barhonin, nyak nyukri gihaum eik!” ");
INSERT INTO apec_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Aria Jisas nemnekan aria nanaki neyotu. Aria nakripesh nakri, “Ipak hwaran nunaki agundok.” Aria eshesh shahwaran shakri, “Jisas nahwaren, douk namudok aria nyak mare nyunogugur. Kitak yowi agundok.” ");
INSERT INTO apec_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Aria anan nakitak neyotu iruhw nawaruk ananit saket natubukuk aria nakitak nanak gani Jisas neyotu um. ");
INSERT INTO apec_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Douk nanak aria Jisas narigan nakri, “Nyak nyakri inekumen maresh?” Aria anan nakripan nakri, “Debeini Tisa, eik yakri inatrugun.” ");
INSERT INTO apec_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Aria Jisas nakripan nakri, “Nyak kare. Um maresh? Nyak nyenek bilip nyakri eik dodogoiwe iri aria nyakis nabes douk yopus.” Aria ahudok atuh anan natrugun aria nanam Jisas hanak. ");
INSERT INTO apec_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Jisas nani ananim disaipel hanak hatogur hurukatin um Jerusalem. Amam hanak hatogur arbudok biyorub shokurubi warub Betfage iri Betani. Amam hanak agundok hurukatin um ahwudok yoduhw Oliv aria Jisas neshopok biom disaipel um hurik hunak. ");
INSERT INTO apec_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Aria nakripam nakri, “Ipak purik punak babri wabur douk bape iri gani wobrehah iri. Ipak ta punak putogur atin, aria ta putik enen nugaen donki. Enyen douk showeshiken maduhw aria nyeyotu. Riguk enyen douk watak nyuwaru enen arpen nyurahemen uwe, uwok. Ipak punak putogur putrin aria pukweshihen puraen punaki agundok. ");
INSERT INTO apec_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Aria ipak pupe pukweshihen, aria enen arpen nyorigep nyukri, ‘Ipak pakweshihen um, enyudok donki?’ Ipak pukripen pukri, ‘Debeini nakri nuraen banab nyutob meyoh um nunek enen mour aria anan ta wata nuraenyi arigas atin.’” ");
INSERT INTO apec_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","5","Aria amam hanak aria hatik enen nugaen donki showeshiken nyeyotu adukehah um witum anat urupat. Aria amam hanak hape hakweshihen aria enesh arpesh douk sheyotuwi hurukatin iri sharigam shakri, “Ipak pakweshihen um maresh enyudok nugaen donki?” ");
INSERT INTO apec_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Aria amam hakripesh enyudok atin baraen kabi douk iganigadae Jisas nakripam um. Douk namudok aria eshesh shakri wosik aria amam haraen hanak. ");
INSERT INTO apec_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Amam haraen hanakum Jisas aria howem amamig saketog agabinyum um enyudok donki aria Jisas nakih netem iruhinyum aria nanak. ");
INSERT INTO apec_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Aria sabaishi arpesh shawar esheshig saketog aria shape shagadiog shanak yah. Aria enesh shanak shatupoki nyeiguhwigos rowos um nubarigos aria shape shogosubuk yah um shuginohwah. ");
INSERT INTO apec_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Aria ihishmorim arpesh douk sharik iri, shani eshudok douk shagiman iri shahwar shakri, “Apak manadudareh-uman! Iruhin natauruman nunekuman yopinyi aria nupe wosik. Anan douk nanakumori Debeini ananin nyeigur iri. ");
INSERT INTO apec_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Apak mutuk Iruhin ananin nyeigur nyuto iruhw. Um maresh? Abudok nyutob um Iruhin nupe debeini um ananish arpesh um kabi douk seiwok Iruhin nutaurum apakin baben Devit um douk banaki hurukatin!” ");
INSERT INTO apec_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Aria Jisas nani ananim hani sabaishi arpesh shanak arigaha shanak shatogur Jerusalem. Aria Jisas nanak nawish Iruhin ananit debeiti urupat aria natik ihishmorim eneshenesh eshudok shakus numun iri. Anan natrish aria agagun douk iganigadae wabigep aria nani ananim 12-poreim disaipel hanakum Betani. ");
INSERT INTO apec_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Aria ruwahepih amam wata hakutukuk Betani hatanam hape hanaki yah aria Jisas nyurub ban. ");
INSERT INTO apec_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Aria amam wata hape hanaku rougun aria Jisas natigu enen rowog fik nyeyotu. Anan natrin um nyunareh nyenek sabaisi shus aria nakri enep shurkwip ta pir. Douk namudok aria anan nanak um nakri nudi enep nupah. Aria anan madae nutik enep uwe. Shus atus sape. Um maresh? Enyenyib nyutob um shurkwip pir um douk watak. ");
INSERT INTO apec_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Aria Jisas nakrip enyudok rowog fik nakri, “Nyak shurkwip ta mare wata enep pir aria arpesh shudiyep shupah uwe, uwok.” Aria ananim disaipel hemnekan-ukuk. ");
INSERT INTO apec_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Douk amam hanak arigaha hanak hatogur Jerusalem aria Jisas nawish numun narub um Iruhin ananit debeiti urupat tataoum aria nape nahiyah eshudok douk shenek salim um eshudok eneshenesh iri shani eshudok douk shatorish iri shatogur sharuwok. Anan nawish nabadigumam tebolhos amudok douk arpesh shanaki shenek senisimum utabor aria hekesh kupaibori iri. Aria nabadigumam wagiturahos amudok douk hape henek salim um mashubiguhw armiguhw um kupaishi shatruguh um shunak shunek ofa moguh shuko Iruhin iri. ");
INSERT INTO apec_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Aria anan nakripesh um mare watak enesh arpesh shirao enesh eshudok eneshenesh shuwishi numun narub um Iruhin ananit debeiti urupat tataoum kupaishi shutorish uwe, uwok. ");
INSERT INTO apec_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Aria anan nenek skulumesh nakripesh enyudok baraen douk nyape Iruhin ananik Buk iri nakri, “Iruhin nakri, ‘Eikit urupat ta tupe um sabaishi arpesh douk shape ihigmorim debeigi nahobig agundok atap iri um shuwishi shupe shunek beten shorige um.’ Aria ipak penekat kabi douk shakwuaruh iri esheshit um.” ");
INSERT INTO apec_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Aria sabaishi shemnek Jisas ananin baraen aria eshesh shakitak yowiyokuk abom. Namudok aria amam debeimi pris hani amudok henek skulumesh um lo iri hemnek Jisas ananin baraen aria hape hatrugun um anah yah um hakri hon nugok. ");
INSERT INTO apec_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Aria wabigep Jisas nani ananim disaipel hakutukuk Jerusalem hanak. ");
INSERT INTO apec_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Ruwahepih ruhur atin, Jisas nani ananim disaipel hakitak hagim yah hanak aria amam hatigu enyudok rowog fik. Enyen yarin agundok nukwaruh aria nyato nyanak iruhw um nyeiguhw shani shus shopunek. ");
INSERT INTO apec_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Aria Pita urkum mormoguk enyudok baraen nabatik Jisas nakrip enyudok rowog-enyi aria nakrip Jisas nakri, “Debeini Tisa, nabatik nyak nyaho nyanyi rowog fik nyakripen um yarin aria douk nyanyi yarin abom.” ");
INSERT INTO apec_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","23","Aria Jisas nakripam nakri, “Ipak ta punek bilip um Iruhin. Adur atin eik yakripep, aria enen arpen madae nyur biyep urkwip um, aria nyunek bilip abom nyukri adur atinyum eshudok enyen nyakriyesh iri ta shutogur abom, aria nyukrip ahwudok yoduhw um hwunatuk hwugrukuk yous um, enyen ta nyutogur kabi douk enyen nyakrium. ");
INSERT INTO apec_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Douk namudok aria adur atin eik yakripep. Abudok nyutob ipak punek beten um Iruhin um nukep enesh eshudok eneshenesh um, aria ipak punek bilip abom pukri adur atin anan ta nukepesh um, anan ta nukep eshudok ipak parigan-umesh iri. ");
INSERT INTO apec_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Aria abudok nyutob ipak punek beten aria ipak urkwip purum enesh yoweishi inahos kupaishi shenekesh um ipak iri um, ipak mare pusuwesh aria pukwreyeshuguk. Ipak ta punekesh namudok um ipakin Yaken nape iruhw heven iri shopunek ta mare nusuhwesh um ipakish yoweishi inahos aria nukwreyeshuguk. ");
INSERT INTO apec_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Aria ta ipak pusuwesh um yoweishi douk kupaishi shenekesh um ipak iri aria mare pukwreyeshuguk um, ipakin Yaken nape iruhw heven iri shopunek ta nusuhwesh um ipakish yoweishi inahos aria mare nukwreyeshuguk uwe, uwok.” ");
INSERT INTO apec_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Aria Jisas nani ananim disaipel wata hanakum Jerusalem. Amam hanak hatogur aria Jisas nanak nawish numun narub um Iruhin ananit debeiti urupat tataoum. Aria amam debeimi pris hani amudok henek skulumesh um lo iri hani amam debeimi Juda hanaki haparugan. ");
INSERT INTO apec_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Aria harigan hakri, “Nyak nyarao maren big um nyunek enyudok mour? Aria amiapen nyeken enyudok big?” ");
INSERT INTO apec_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Aria Jisas nakripam nakri, “Eik shopunek yakri irikep enen baraen. Aria ta ipak pubeime tukwanin um, eik shopunek ta ikripep um omi nyeke big aria douk yenek enyudok mour. ");
INSERT INTO apec_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Ipak kripe, Jon douk nenek baptaisumesh iri omi nyakon enyudok mour aria douk nenek baptaisumesh? Iruhin nakonen o enesh arpesh meyoh?” ");
INSERT INTO apec_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Aria amam kanak haneyagwreh hakri, “Aria apak mukri Iruhin nakonen um, anan ta wata norigap nukri, ‘Douk namudok aria ipak madae punek bilip um Jon ananin baraen uwe um maresh?’ ");
INSERT INTO apec_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Aria ta apak mukri ‘arpesh meyoh shakonen um aria douk neneken’ um, enyudok baraen shopunek ta mare wosik uwe.” Aria amam hanogugur um eshesh armam armago. Um maresh? Ihishmorim douk shakri Jon anan douk anan adurin profet. ");
INSERT INTO apec_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Aria amam hakrip Jisas hakri amam madae hudukemesh uwe, uwok. Aria Jisas nakripam nakri, “Eik shopunek ta mare ikripep um omi nyeke big aria douk yenek enyudok mour.” ");
INSERT INTO apec_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Aria Jisas nakripam enyudok wobuwobren baraen nakri, “Anan arman nau wain iyoh aria narok narub ananig nubarig. Aria anan narok anag bariyaigi nuwag um ko sharauri wainip orokwipi shurkwip aria shunak shishishep shumakwiyeshep um ihat tutogurep. Aria shopunek, narak anap ourop potem iruhw iri um anan arman nunaki nupe neyoh nubarig ba nupe um. Aria anudok nagrem nubarig iri nakrip kupaimi armam henek kontrak hanaki hape henek mour ananig nubarig aria anan nanak kupaigunum. ");
INSERT INTO apec_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Douk nanak nape arigaha aria abudok nyutob um wainip shurkwip orokwip shudiyep um batogur. Aria anan neshopok anan nenekuman mour meyoh iri nanak um nukrip amudok henek mour ananig nubarig iri hukani ananip um wainip shurkwip. ");
INSERT INTO apec_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Aria anan nanak natogur aria amam han aria heshopokan natanam nanak meyoh. ");
INSERT INTO apec_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Douk anan nanak napeik aria nagrem nubarig iri wata shopunek neshopok kupaini nenekuman mour meyoh iri nanak um nukripam hukani enep shurkwip. Douk nanak natogrumam aria amam wata shopunek haworun barag aria han heneken abraenyin atun aria heshopokan natanam nanak meyoh. ");
INSERT INTO apec_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Aria wata shopunek neshopok kupaini nanak aria amam han nagok. Aria anan neshopok anam shopunek hanak aria amam henekesh-umam namudok atin. Anam ham henekam abraenyim atum heyokasam, aria anam ham hagok. ");
INSERT INTO apec_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","“Douk amudok henek mour um anudok nagrem nubarig iri hatuh, aria ananin nuganin douk anan urkum manawash-uman iri atun napeik. Aria anan naneyagwreh nakri, ‘Eikin nuganin nunak um, amam ta humnekan.’ Aria anan neshopokan nanak. ");
INSERT INTO apec_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Douk nanak natogur aria amam henek mour nubarig iri hatrun aria hanakripam hakri, ‘Anudok nagrem nubarig iri nugokuk um, ananin nuganin ta nugrem ihishmorim ananish eshudok. Douk namudok aria apak mon nugokuk um apak ta murao ananig nubarig!’ ");
INSERT INTO apec_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Douk namudok aria amam hasuwan han nagok aria hawashan natogur nakusuk aduk agudok nubarig.” ");
INSERT INTO apec_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Aria Jisas narig amudok debeimi Juda nakri, “Aria anudok nagrem nubarig iri ta nunek maresh? Anan ta nunaki nubo amudok henek mour iri hugok hutuh aria ta wata nurao kupaimi hunak hunek mour ananig nubarig. ");
INSERT INTO apec_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Aria ipak patrin enyudok baraen nyetem Iruhin ananik Buk iri aka, uwok? Baraen enyudok, ‘Amudok utomdouk harok urupat iri hakri wokumam iri douk matogur sagomim utom masah wobratum urupat iri. ");
INSERT INTO apec_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Amam douk Debeini nenekam matogur namudok aria apak manadudareh-umam makri enyen douk Debeini atun neneken iri mour!’” ");
INSERT INTO apec_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Aria amam debeimi Juda hadukemesh hakri anan nakri enyudok wobuwobren baraen um amam. Douk namudok aria amam juwehosim um anan aria hakri hunek kwotuman aria huweshikan. Aria amam hanogugur um eshesh armam armago aria hakutunukuk ba hanak. ");
INSERT INTO apec_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Aria anah nyumnah, amam debeimi Juda heshopok anam Farisi hani anam Herot ananim hanak henek rohw um hukwiraeh Jisas horigan enen baraen. Amam henekesh namudok um hakri kadak amam humnekan nukri enen yoweinyi baraen um hunek kwotuman-umen iri. ");
INSERT INTO apec_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Aria amam hanak agundok Jisas napeum aria harigan hakri, “Debeini Tisa! Apak madukemeshum nyak douk madae nyunogugur enesh arpesh uwe. Aria nyak douk madae nyukrip nyeiguhw shato iruhw-eshi arpesh kupainyi baraen aria nyeiguhw wokeshi nyukripeshuk kupainyi uwe, uwok. Nyak apa nyakripesh atin baraen ihishmorim arpesh. Aria nyak apa nyagipesh adurin atinyi baraen aria nyenek skulumesh wosik um Iruhin ananih aih. Douk namudok aria nyak kripap. Apakin lo douk nyakri mumam? Enyen douk wosik um munek takis um debeini gavman um Sisar aka, uwok?” ");
INSERT INTO apec_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Aria Jisas nadukemesh um amam douk henek rohw. Douk namudok aria anan narigam nakri, “Ipak pakri pukwiraehe um maresh? Ipak haroki anam utom douk pape penek takis omi ba itrum.” ");
INSERT INTO apec_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Aria amam hanaki hakon anam utom aria Jisas narigam nakri, “Enyudok nyeigur aria aborir shetem amudok utom iri omiyesh?” Aria amam hakri, “Debeini gavman Sisar ananish.” ");
INSERT INTO apec_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Aria Jisas nakripam nakri, “Sisar ananish eshudok eneshenesh ta puko Sisar. Aria Iruhin ananish ta puko Iruhin.” Aria douk anan nakripam namudok aria amam hakitak yowiyokuk abom. ");
INSERT INTO apec_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","19","Aria amam Sadyusi, douk hakri shagok iri ta mare wata shukitaki iri hanaki Jisas napeum aria harigan hakri, “Debeini tisa, seiwok Moses nuwemaguk enyudok Iruhin ananin lo um apak nakri namudok, ‘Aria anan arman ananik irohukwik madae kubuki enesh batowish aria anan nugokuk um, ananin wanin ta nukwaur. Anan ta nukwaur um shubuki batowish um aria ta shubuh ashukenyik nuwag.’” ");
INSERT INTO apec_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Aria amam hakripan shopunek hakri, “Anob nyutob, 7-poreim nugamim douk atish amakenyish shamubuki iri hape. Aria ashuken narao onok irohukwik aria anan nagokuk aria okwok madae kubuki enesh batowish uwe. ");
INSERT INTO apec_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Aria aninuman nakwaur aria anan shopunek nagok aria okwok madae kubuki enesh batowish uwe. Aria douk anan nagokuk aria rabinari iri nakwaur. Douk nakwaur shape aria anan shopunek nagok aria madae kubuki enesh batowish uwe. ");
INSERT INTO apec_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Aria namudok atin, ihim-morim amudok 7-poreim haraok aria amam ihim-morim hagokuk aria okwok madae kubuki enesh batowish uwe. Aria okwok shopunek kwagiguk kwagok. ");
INSERT INTO apec_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Aria abudok nyutob shagok iri wata shukitaki um, okwudok armatok ta kwukitaki aria kwupe um meini? Nyak nyadukemesh, sagomatin ihim-morim amudok 7-poreim haraok iri atum.” ");
INSERT INTO apec_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Aria Jisas nakripam nakri, “Ipak madae pudukemesh uwe. Um maresh? Ipak madae pudukem baraen nyetem Iruhin ananik Buk iri uwe. Aria shopunek, madae pudukemesh um agundok Iruhin dodogowini abom um uwe. ");
INSERT INTO apec_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Abudok nyutob shagok iri wata shukitak-umori, armam armago ta mare shunoraum um atin uwe, uwok. Eshesh ta shupe kabi douk Iruhin ananish enselahos douk shape iruhw heven iri um. ");
INSERT INTO apec_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Aria ipak ta patarihen iri Iruhin nakripepen iri baraen um agundok ta shagok iri wata shukitaki um aka, uwok? Aria shopunek, ipak patarihen enyudok baraen douk nyetem okwudok buk Moses nenyemok iri aka, uwok? Moses douk natik nyih hanu enen shokwinyi rowog aria Iruhin nakripan enyudok baraen nakri, ‘Eik douk Abraham nani Aisak aria Jekop amamin Iruhin.’ ");
INSERT INTO apec_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Namudok aria Iruhin douk madae shagok iri esheshin uwe, uwok. Anan douk shape iri esheshin Iruhin. Aria ipakin baraen madae adurin abom uwe, uwok.” ");
INSERT INTO apec_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Aria anan nenek skulumesh um lo iri shopunek nanaki nape nemnekam um hape hanatutukem um. Aria shopunek, anan nemnek Jisas nakripamen iri baraen douk yopunyi atin abom. Douk namudok aria anan narig Jisas nakri, “Meinyi Iruhin ananin lo douk nyape nyarik abom nyeshagrakuk ihinyumorim lo?” ");
INSERT INTO apec_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Aria Jisas nakripan nakri, “Nyarik iri lo douk enyudok, ‘Ipak Israel ta pumnek! Apakin Debeini Iruhin abom douk anan atun Iruhin. ");
INSERT INTO apec_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Douk namudok aria ipak urkwip ta punawasham abom ipakin Debeini Iruhin. Aria ipakiruh aparuh, huni ipakish mishish shuni ipakip urkwip ta shunawasham abom ihinmorim um ipakin tinytin aria pukwu ipakin dodog um punek ananin mour.’ ");
INSERT INTO apec_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Aria nyagimori enyudok iri douk enyudok, ‘Ipak ta urkwip punawasham kupaishi arpesh douk shape hurukatin um ipak iri kabi ipak urkwip punawasham ipak kanak um.’ Aria enyen douk madae enen kupainyi lo nyishagrakuk enyudok biyen lo uwe, uwok.” ");
INSERT INTO apec_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Aria anudok nenek skulumesh um lo iri nakrip Jisas nakri, “Tisa! Nyakin baraen douk yopunyi atin abom. Nyak nyakri adur! Iruhin douk anan atun Debeini abom aria madae anan shopunek nupe debeini kabi douk anan um uwe. ");
INSERT INTO apec_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Douk namudok aria adur atin, apakip urkwip ta punawasham abom um anan atun. Aria apakiruh aparuh huni apakish mishish shuni apakip urkwip ta shunawasham abom aria muko ihinyumorim um apakin dodog um munek ananin mour. Aria urkwip punawasham kupaishi shape hurukatinyum apak iri kabi douk apak urkwip punawasham apak kanak um. Enyudok biyen lo douk nyarik iri yopunyi lo abom. Aria ta apak mugipesh enyudok biyen lo um, ehudok aih douk hushagrakuk agundok apak munek ofa um eneshenesh eshudok mashaisheh nyih hanish hashahuk ba mako Iruhin um shani ihinyumorim ofa shopunek.” ");
INSERT INTO apec_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Aria Jisas nemnekan um ananin baraen douk yopunyi adurin atin abom aria nakripan nakri, “Abudok nyutob um nyuwishi agundok Iruhin nape Debeini um ananish arpesh um douk banaki hurukatin.” Aria ihishmorim arpesh shanogugur aria madae shorigan um enen shopunek baraen Jisas uwe, uwok. ");
INSERT INTO apec_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Jisas nape nenek skulumesh numun narub Iruhin ananit debeiti urupat tataoum. Aria nakripesh enyudok baraen nakri, “Amudok henek skulumesh um lo iri hakri Devit ananin barhonin ta nutogur Krais douk Iruhin nagraehan neshopokan nanakumori nunarao arpesh iri um maresh? ");
INSERT INTO apec_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Seiwok douk Iruhin ananin Mishin nyohur Devit kanak aria nakri enyudok baraen um Krais nakri, ‘Debeini nakrip eikin Debeini nakri, “Nyak poe agundok um eikin yopunyi rogurehahum arigaha ibo nyakim horim ba hubuhuk.” ’ ");
INSERT INTO apec_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","“Aria tik, Devit kanak douk nahwar anudok arman Krais ananin Debeini. Douk namudok aria Krais ta wata nutogur Devit ananin barhonin mumam?” Aria douk Jisas nakripesh namudok aria sabaishi arpesh shanadudareh abom shakri ananin baraen douk yopinyi adurin atin. ");
INSERT INTO apec_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Aria Jisas nape nakripesh baraen nakri, “Ipak gamo pudukemesh um ipak mare pugipesh amudok henek skulumesh um lo iri um amamih yoweihi aih. Amam hanadudareh abom hore rouhi atih rupeh hurahaen um arpesh shutrum shukri amam da yopumi debeimi armam. Aria shopunek, hakri hurahaen hunak agundok arpesh apa shantorum shapeum, aria shutrum aria shunek-umam yopihi nyumneh. ");
INSERT INTO apec_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Aria hanak um lotu eshesh Juda shape sheneyagwreh baraen-ogwi urusag um, amam hanadudareh um hunak hupe hurik, hutem yopishi wagiturahos um kadak arpesh shutrum. Aria shenek debeiguni worigun obi nyutob, amam apa hanadudareh um hunak hupe yopugunum douk debeimi atum hapeum. ");
INSERT INTO apec_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Aria amam apa hanak hawish armago douk armam hagok howosopukuk iri owoig urusag aria hatru hakwumesh-aruh owowish eshudok eneshenesh. Aria amam hanak hape henek beten um, amam henek rourouni beten meyoh um hakri kupaishi arpesh shutrum. Aria kweipon Iruhin ta nuwanamam amamish yoweishi inahos aria ta nunekam humnek debeiri eriger.” ");
INSERT INTO apec_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Jisas nape hurukatin um asudok bokis douk shape shakwutu utabor babuh um gani numun Iruhin ananit debeiti urupat. Aria anan nape natik arpesh shanaki shape shakwutu utabor babuh asudok bokis um. Sabaishi shogrem sabaibori utabor iri shanaki shakwutu debeibori utabor babuh bokis. ");
INSERT INTO apec_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Aria onok armatok douk anan nagok nakwusopuk iri kwanaki kwakwutu biobor shokwubori utabor babuh. ");
INSERT INTO apec_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Aria Jisas nahwar ananim disaipel hanaki aria nakripam nakri, “Adur atin, eik yakripep, okwudok arman nagok nakwusopuk iri armatok okwokwibor karowibor biobor utabor, douk kwanaki kwakwutubor bokis iri douk sabaibori abom. Ababor douk beshagrakuk abom abrudok sabaibori utabor douk ihishmorim shanaki shakwutubor iri. ");
INSERT INTO apec_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Eshudok ihishmorim shanaki shakwutu tukwanibor um esheshibor utabor babuhuk bokis aria tukwanibor debeibori bakwusumeshuk urusag. Aria okwok kwakwutu sabaibori okwokwibor utabor. Aria okwok douk nyaruk armatok iri, madae anabor utabor bukusamokuk urupat um kwunotor worigun um uwe, uwok.” ");
INSERT INTO apec_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Douk Jisas nape iri numun Iruhin ananit debeiti urupat nakitak nakri nutogur aduk, aria anan ananin disaipel nakripan nakri, “Debeini Tisa! Nyak tik agwudok yopugwi urusag douk sharokog yopubori utabor iri.” ");
INSERT INTO apec_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Aria Jisas nakripan nakri, “Nyak nyatik agwudok urusag aria nyakri yopugwi. Aria anah nyumnah ta kupaishi ta shunaki shununug aria ta mare shukutukuk anam atum utom mutemaguk iruhw um kupaimi utom uwe, uwok. Ihibor-morim ta shuburunik bubuh bukus atap atin.” ");
INSERT INTO apec_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Aria Jisas nato nakih nape agundok iruhw um yoduhw Oliv wobrehah um Iruhin ananit debeiti urupat tataoum. Aria Pita nani Jems aria Jon hani Andru amam atum hanak hatogruman aria harigan hakri, ");
INSERT INTO apec_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Apak makri nyukripap um ahudok nyumnah douk ta eshudok iganigadae nyakripap-umesh iri ta shutogurum. Aria shopunek ta maresh shurik shutogurum apak mutrish aria mudukemesh mukri eshudok douk hurukatin um ta shutogur?” ");
INSERT INTO apec_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Aria Jisas nakripam nakri, “Ipak gamo punodukem um ta mare anam armam hunaki hunek rohwumep aria hunekep pugipesh amamin baraen uwe, uwok! ");
INSERT INTO apec_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Sabaimi armam ta hunaki aria amam atun atun ta hunek rohwumep hukripep um eikin nyeigur hukri, ‘Eik Krais douk Iruhin nagraehe aria neshopoke yanaki iri.’ Aria amam ta hunek rohw um sabaishi arpesh. ");
INSERT INTO apec_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Ipak ta pumnek baraen um wanohw hwutogur kupairubi rougunirub warub um. Aria shopunek ta pumnek shupe shurpak hurukatin um ipak pape um. Aria ipak mare punogugur, uwok. Adur wanohw ta hwutogur, aria hugiguk iri nyumnah ta mare arigas hutogur. ");
INSERT INTO apec_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Aria anag shokugi nahobig ta shukitak shuni kupaigi shokugi nahobig shurpak. Anan king nini ananish ta shukitak shuni kupaini king nini ananish shurpak. Aria anagun agundok atap ta enyik kwutuk, aria anagun ta debeirubi nyurub besh aria sabaishi ta shugok um nyurub. Enyudok ihinyumorim nyurik iri amaen ta nyutogur kabi douk arudok rarik iri eriger douk armatok kwarig kwomnek um aria kadak kwabuki batowin um. ");
INSERT INTO apec_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Douk namudok aria ipak kanak ta gamo punadukem. Eshesh ta shunaki shusuwep shuraepum debeimi douk hape hasuhw kwotog iri. Aria shopunek, ta shuwishi shep gani numun eshesh Juda shape sheneyagwreh baraen-ogwi urusag. Eshesh ta shep um agundok pasuhw eikin baraen pagipesh eik um. Aria eshesh ta shusuwep shuraepum amam debeimi gavman iri huni amam king hapeum pukripam Iruhin ananin yopinyi baraen douk nyakrium eik iri. ");
INSERT INTO apec_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Aria sagomatin eikish arpesh ta shunak ihirubum warub bape agundok atap iri shukripesh Iruhin ananin yopinyi baraen iyoh, aria hugiguk iri nyumnah ta kadak hutogur. ");
INSERT INTO apec_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","“Aria abudok nyutob eshesh shusuwep shuraep shunak shunek kwotumep um, ipak mare punogugur aria pukri ta punak aria piyagwreh mumam, uwok. Ihinyumorim baraen Iruhin ta nukepen abudok atub nyutob ipak pakri piyagwreh um. Douk namudok aria maren baraen ipak urkwip purumen iri, ipak ta pukriyen. Um maresh? Enyen douk madae ipak kanak pukrienyi uwe, uwok. Enyen douk Iruhin ananin Mishin nyepuhur aria douk pakrienyi. ");
INSERT INTO apec_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Aria enesh arpesh ta nyirub juwehos-irub um esheshish ashukenyish owashish aria ta shunekumesh kwot shuweshikesh aria shunak kupaishi shesh shugok. Aria anam aruhim ta nyirub juwehos-irub um amamish batowish aria ta hunekumesh kwot um huweshikesh aria shunak kupaishi shesh shugok. Aria batowish shopunek ta nyirub juwehos-irub um esheshish amakenyish aria ta shunekumesh kwot um shuweshikesh aria shunak kupaishi shesh shugok. ");
INSERT INTO apec_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Aria ihishmorim arpesh ta shukri wokumep aria shukep agabus shukri ipak yoweipi um agundok pagipesh eik um. Aria eshudok douk shugipesh eik dodogowish atish arigaha shugok iri, Iruhin ta nunaraesh shutanamori shupe wosik abom.” ");
INSERT INTO apec_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Aria Jisas ta nakri namudok, “Aria ipak ta putik kupaishi shurauri enyudok yoweinyi mugu abom shunaki shuwishi shunyubuk numun Iruhin ananit debeiti urupat aria ta nyunekat tubosusih. Enyudok yoweinyi mugu Iruhin douk nakri uwok um nyukus numun ananit debeiti urupat iri.” Arpennyutorih enyudok baraen iri ta gamo nyudukemen wosik. “Aria abudok nyutob arpesh shape ihirubmorim warub bape shokugi nahobig Judia iri ta shuruwok shunak um yodururuh-igun um. ");
INSERT INTO apec_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Aria shape aduk hurukatin um esheshig urusag iri, ta mare shukitak shuwishi urusag um shunahuri enesh eshudok eneshenesh uwe, uwok. Eshesh ta shuruwok shunak meyoh abom. ");
INSERT INTO apec_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Aria eshudok douk sheyotu nubarigos iri ta mare wata shatanam shusahur shunak um esheshig urusag um shunahuri esheshig saketog uwe, uwok. ");
INSERT INTO apec_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Aria gihaum oudok aparuhiwari armago uni oudok douk wasuhw batowish douk watak shawok nyumeb iri. Ahudok nyumnah owo ta wanomnek debeiri eriger! ");
INSERT INTO apec_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Aria ipak ta punek beten um enyudok debeinyi amaen um mare ta nyutogur abudok nyumanugos-ibi nyutob ta butogrum uwe, uwok. ");
INSERT INTO apec_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Ahudok nyumneh, enyudok amaen ta nyutogur aria arpesh ta shumnek debeiri eriger. Arudok eriger seiwok Iruhin nenek agundok atap nani eneshenesh shani arpesh shatogur shape shanaki arigaha shatograri douk, aria enyudokmori amaen madae enen nyutogur aria nyunek arpesh shumnek arudokmori eriger uwe. Aria kweipon shopunek, arpesh ta mare wata shumnek anar arudokmori eriger uwe, uwok. ");
INSERT INTO apec_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Aria Debeini nugraeh sabaihi nyumneh um enyudok amaen nyutogur akure, ta mare enesh arpesh shupeik, uwok. Ihishmorim ta shugok shutuh. Aria anan urkum morum ananish arpesh anan nanagraehesh iri aria nagraeh karowih meyoh nyumneh um enyudok amaen nyutogur um. ");
INSERT INTO apec_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Aria ta abudok nyutob enesh arpesh shunaki aria shukripep shukri, ‘Ipak tik, Krais douk Iruhin nagraehan neshopokan nanaki iri anudok nape agundok o nani nape ganik um, ipak mare punek bilipumesh uwe, uwok.’ ");
INSERT INTO apec_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Sabaimi armam atun atun ta hunaki hunek rohwumep hukri, ‘Eik Krais.’ Aria anam ta hunaki hunek rohwumep aria amam atun atun ta hukri, ‘Eik anan profet.’ Aria amam ta hunek enenyenen Iruhin atun neneken iri mour. Amam ta hunekesh namudok um hukri hunek rohw um Iruhin nanagraehesh iri arpesh um shukri adur amam Iruhin nataurumam iri. Aria ta amam dodogowim akure, amam ta hunek rohwumesh. Aria ta uwok. ");
INSERT INTO apec_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Namudok aria ipak gamo pudukemesh um abudok nyutob enyudok debeinyi amaen nyutogur um. Eik douk enyudok yarig yakripepuk um ihishmorim eshudok eneshenesh douk ta shutograri.” ");
INSERT INTO apec_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Aria ahudok nyumneh um enyudok amaen douk ta nyunek arpesh shumnek debeiri eriger iri ta hunak hutuhuk, aria ‘nyumnahin nini wabin aub ta dokotigun-umab. ");
INSERT INTO apec_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Aria eneshenesh shape iruhw utag iri shuni aub iri unib ta grurugwresh aria unib ta unatuk ugruki atap.’ ");
INSERT INTO apec_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","“Aria abudok nyutob, Eik Anudok Arman douk yatogur adurinyi arpen iri ta wata ikutukuk iruhw heven inaki. Eik ta dodogoiwe itrugun abom aria itemori onog orug inaki. ");
INSERT INTO apec_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Aria ta ishopok eikish enselahos shunak ihigunmorim um agundok atap aria shurauri ihishmorim eik yanagraehesh iri arpesh shunaki shupe atugun.” ");
INSERT INTO apec_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Ipak urkwip purum enyudok rowog fik aria pudukemesh. Abudok nyutob enyen nyupe nyunareh obi nyutob, ipak ta putrin aria pudukemesh pukri douk hurukatin um wah atuh hutao. ");
INSERT INTO apec_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Aria douk ta namudok atin. Ipak ta putik enyudok ihinyumorim amaen douk iganigadae yakripep-umen iri nyutogur nyunakuk, aria ipak ta pudukemesh um eik douk hurukatin um itanamori. ");
INSERT INTO apec_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Adur atin eik yakripep! Ipak doukipari, enep ta mare arigas pugok uwe, uwok. Ipak ta wata pupe aria enyudok ihinyumorim amaen douk iganigadae yakripep-umen iri ta nyutogur. ");
INSERT INTO apec_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Ihishmorim eshudok eneshenesh douk shape iruhw utag iri shuni utag atug, shuni ihishmorim shape agundok atap iri shuni atapig nahobig shopunek ta burukworesh shunak shuwishuk. Aria eikin baraen ta nyupe ihih nyumneh.” ");
INSERT INTO apec_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Aria Jisas ta nakri namudok, “Madae enen atin arpen nyudukem ahudok nyumnah o aua uwe. Iruhin ananish enselahos shape iruhw iri shani eik ananin nuganin shopunek madae mudukemah uwe. Yain atun nadukemah. ");
INSERT INTO apec_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Ipak douk madae pudukem ahudok nyumnah douk ta eshudok eneshenesh shutogurum uwe. Douk namudok aria ipak ta gamo pudukemesh aria pupe putrugun-umoh. Ipak mare pupe ba urkwip pushukepuk uwe, uwok. ");
INSERT INTO apec_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Ahudok nyumnah eshudok eneshenesh shutogurum ta kabi enyudok wobuwobren baraen um. Baraen enyudok. Anan arman nakri nukutukuk ananit urupat aria nunak anabur rougunibur wabur. Anan nakri um nunak aria nakitak nagraeh-aguk mour um kupakupaimi amam atun atun douk henekuman mour meyoh iri. Aria nakrip anudok nape neyoh um wit iri um neyoh wit aria nupe nutrugun um anan wata nutanamori um. ");
INSERT INTO apec_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","“Douk namudok aria ipak ta gamo pudukemesh aria pupe putrugun. Um maresh? Ipak madae pudukem abudok nyutob douk ta urupatinari nutanamori obi nyutob uwe. Anan ta nunaki wabigun o orokohunib um wab o nunaki owotog gwakitak um o nunaki ruwahep. Ipak madae pudukemesh uwe, uwok. ");
INSERT INTO apec_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Ta wosik atin anan nunaki ahudok atuh aria nutrip um ipak pishuh. Aria uwok, ipak ta pupe putrugun-uman. ");
INSERT INTO apec_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Aria enyudok baraen eik yakrip ipak enyi, douk eik yakrip ihishmorim arpesh shopunek. Ipak gamo pudukemesh aria pupe putrugun um eshudok eneshenesh douk iganigadae eik yakripep-umesh iri ta shutogurum.” ");
INSERT INTO apec_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Eheh douk biyeh shopunek nyumneh watak hapeum shunek agundok debeiguni Pasovaigun worigun aria shuwok bret douk shushaiteh aria madae tukitak debeiti iri uwe. Aria amam debeimi pris hani amam henek skulumesh um lo iri henek rohw um rihirahaen hanak hape haurim Jisas. Amam hauriman hanakum hakri anan atun nunak nupe anagun um, amam husuwan aria hunak hon nugok. ");
INSERT INTO apec_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Aria amam wata hakri, “Uwok, apak mare muweshikan abudok nyutob shunek worigun obi nyutob. Um maresh? Ta armam armago shutik namudok aria shuhuri wanohw aria shop.” ");
INSERT INTO apec_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Aria Jisas nakitak nanak Betani aria nani Saimon douk riguk ehudok arugeh lepra hapenyan aria hape ananit urupat. Aria douk Jisas nape tebol, nape nawok worigun numun urupat, aria onok armatok kwasuhwi anar yopuri botol douk shenekor anam utom iri kwanak kwawish. Arar douk shukunir um enen yopunyi sanda nyeigrinyum nad iri. Enyen apa shatorin debeibori utabor. Douk kwawish kwanak agundok Jisas napeum aria kwawor botol ba kwourak enyudok sanda nyabuh Jisas ananig barag. ");
INSERT INTO apec_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Aria enesh arpesh shape agundok iri shatik namudok aria eshesh nyirub juwehos-irub aria shakri, “Okwudok kwanunin um enyudok yopunyi sanda? ");
INSERT INTO apec_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Douk apak muraen munak kupaishi shutorin aria shukop 300 siliwa-ibor utabor akure, douk ta wosik. Apak ta musuhw abrudok debeibori utabor munaki aria misiyabor um eshudok yaruhish arpesh um mutaurumesh!” Eshesh sheneyagwreh namudok aria shape shahaok. ");
INSERT INTO apec_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Aria Jisas nakripesh nakri, “Ipak pahaok um maresh? Ipak kutukuk, okwok douk kwonekume yopunyi mour abom. ");
INSERT INTO apec_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Eshudok utabor wokeshi ta shini ipak shupe ihih nyumneh. Aria meihi nyumnah ipak pakri putaurumesh pukesh anabor utabor um, ipak ta pukesh-abor. Aria eik ta mare ini ipak mupe ihih uwe, uwok. ");
INSERT INTO apec_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Aria enyudok mour douk okwok dodogowik um kwuneken iri, douk enyudok kweneken. Okwok kwanaki kwourak sanda kwakwrup eikihw yegenyihw um kwehig nuhut she igok aria shurume um. ");
INSERT INTO apec_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Adur atin eik yakripep. Arpesh shunak ihirubmorim warub agundok atap um shukripesh Iruhin ananin yopinyi baraen um, eshesh ta shukripesh um okwok kweneken iri shopunek aria eshesh ta urkwip purumok.” ");
INSERT INTO apec_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Aria abudok nyutob, anan um amudok Jisas ananim disaipel nyeigur-inam Judas Iskariot iri nanak gani amam debeimi pris hapeum. Aria nakripam um anan nakri wosik um niyabigam um agundok Jisas nanak napeum aria amam hunak husuwan huweshikan. ");
INSERT INTO apec_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Aria amam hemnek Judas ananin baraen aria hanadudareh abom aria habo baraen um amam ta hutorun hukon anabor utabor. Aria Judas nakitak nanak aria nape nenek urkum um anah yah um niyabigom Jisas aria amam hunak husuwan huweshikan um. ");
INSERT INTO apec_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Douk shenek agundok Pasovaigun worigun um, eshesh apa shawok bret douk shushaiteh ba madae tukitak debeiti iri uwe. Aria ahudok sagomih nyumnah, eshesh apa shabo sipsipahos um shunek agundok Pasovaigun worigun um. Aria Jisas ananim disaipel harigan hakri, “Nyak nyakri apak munak munekagun agunum agundok Pasovaigun worigun um nyak nyunak nyugnoh?” ");
INSERT INTO apec_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Aria Jisas neshopok biom ananim disaipel hanak aria nakripam enyudok baraen nakri, “Ipak punak wabur aria ta puparug anan nusahi anap abar baropi marup. Ipak putrun aria pugipeshan punak. ");
INSERT INTO apec_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Aria punak puwish atudok urupat anan nunak nuwishat iri aria pukrip atudok urupatinari pukri, ‘Apakin debeini tisa nakri amudok rum douk arpesh shape sheshuh omi douk ta anan nini apak ananim disaipel mupe munek Pasovaigun worigun mugnoh-ami douk mape agunum?’ ");
INSERT INTO apec_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Ipak porigan aria anan ta niyabigep anam debeimi rum iruhitum urupat. Eshesh douk shagitom aria shagabeyam yopum mape. Aria ipak punak puwish pupe punekumap worigun.” ");
INSERT INTO apec_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Aria amudok biom disaipel hakitak hanak wabur aria haparug ihishmorim eshudok kabi douk iganigadae Jisas nakripam um. Aria amam hanak hape henek worigun um hugnoh um Pasova iri. ");
INSERT INTO apec_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Douk arigaha wabigep hurukatin um wab aria Jisas nani ananim 12-poreim disaipel hanak hawish hape hawok worigun. ");
INSERT INTO apec_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Douk hape hawok worigun tebol aria Jisas nakripam nakri, “Adur atin eik yakripep. Ipak anan douk mape mawok worigun iri ta niyabig eikim horim um eik aria amam ta husuwe huweshike aria hurawe hunak um he igok.” ");
INSERT INTO apec_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Aria ananim disaipel hemnek namudok aria amamiruh aparuh yoweruh aria amam atun atun harigan hakri, “Ta eik ikrip nyakim horim aka, ta omi?” ");
INSERT INTO apec_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Aria Jisas nakripam nakri, “Ipak 12-poreim anan douk ta nini eik ukutu bret tubuh dis aria utoh iri ta nuyabigam um eik. ");
INSERT INTO apec_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Aria Eik Anudok Arman douk yatogur adurinyi arpen iri ta she igok kabi douk baraen nyetem Iruhin ananik Buk iri nyakri ta igok um. Aria anudok douk niyabig eikim horim um eik iri, yoweishi eshudok eneshenesh abom ta shutogur-uman! Douk namudok aria eik yakri gihauman. Douk seiwok amakek madae kwunabuki akure, ta wosik.” ");
INSERT INTO apec_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Douk amam hape hawok worigun aria Jisas nohur anat bret nasuwat aria nenek beten nenek tenkyu um Iruhin aria naworut nako ananim disaipel. Aria nakripam nakri, “Atudok bret douk eikihw yegenyihw. Ipak suwot aria putoh.” ");
INSERT INTO apec_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Nakom bret hatoh jurug aria nohuri anap kap wainibar abar borapi aria nenek beten nenek tenkyu um Iruhin aria nako amam atun atun habaroh. ");
INSERT INTO apec_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Aria anan nakripam nakri, “Abrudok wainibar abar douk eikibor owishibor. Douk butourak um butaurum sabaishi arpesh aria benek enyudok Iruhin ananin adurin atin abom iri baraen kontrak nyutogur dodogowin. ");
INSERT INTO apec_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Aria adur atin eik yakripep. Eik ta mare wata iwok anabar wainibar abar, uwok. Eik ta ipe arigaha wata inak abrudok wabur Iruhin nape Debeini um ananish arpesh shapeum ba iyoh, aria eik ta kadak wata ibaroh.” ");
INSERT INTO apec_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Aria amam heyorub onohw awehw jurug aria hatogur hato um yoduhw Oliv. ");
INSERT INTO apec_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Aria Jisas nakrip ananim disaipel nakri, “Kadak ipak ihipmorim ta pukutukuk eik puruwok punakuk atun atun. Um maresh? Iruhin ananin baraen nyetem ananik Buk iri douk nyakri, ‘Eik ta ibouk anudok neyoh sipsipahos iri aria sipsipahos ta shuruwok shunak atin atinyuk.’ ");
INSERT INTO apec_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Aria eshesh ta she igok aria eik ta wata ikitak aria irik inak um Galili. Aria ipak ta pugime punaku.” ");
INSERT INTO apec_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Aria Pita nakripan nakri, “Ta ihim-morim hukutukuk nyak aria huruwok um, eik ta ini nyak upe biohw!” ");
INSERT INTO apec_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Aria Jisas nakripan nakri, “Adur atin eik yakripen. Kwehigib wab, nyak ta nyunek rohw biyeh otuh nyukri nyak madae nyudukem eik uwe aria owot ta tukitak tiyagwreh biyeh.” ");
INSERT INTO apec_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Aria Pita dodogowin atun abom nakrip Jisas nakri, “Adur atin eik yakripen, eik ta mare inek rohw ikri eik madae idukemen uwe, uwok. Ta eshesh shukri shubo nyak nyugok um, eik shopunek ta ini nyak shohw ugok ahudok atuh!” Aria ihim-morim disaipel shopunek hakripan enyudok atin baraen. ");
INSERT INTO apec_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Aria Jisas nani ananim disaipel hanak hatogur anagun nyeigur-igunum Getsemani aria anan nakrip ananim disaipel nakri, “Ipak pupe agundok aria eik inak inek beten gani.” ");
INSERT INTO apec_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Aria anan narao Pita nani Jems aria Jon atum hanaman hanak. Aria agundok anan nemnek yowiyokuk abom aria ananihw apahw yowehw abom. ");
INSERT INTO apec_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Aria anan nakripam nakri, “Eikin mishin yowen abom aria eik yemnek um yakana igok atin. Douk namudok aria ipak pupe ba piyohe.” ");
INSERT INTO apec_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Aria natanam nanak madae rougun abom uwe aria nabuh nakus ananin domaen nyatik atap aria nenek beten narig Iruhin. Anan narigan um nukri kadak mumam um aria Iruhin wosik nukutukuk enyudok amaen um mare nyutogur-uman. ");
INSERT INTO apec_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Aria Jisas nenek beten nakri, “O Abaeikin Yain nyak douk dodogowini abom iri nyasuhw iruhw atap iri. Eik yakri nyak mare nyukutukuk enyudok amaen ta nyutogrome iri uwe, uwok. Aria nyak mare nyugipesh eikim urkum uwe, uwok. Nyak nyugipesh nyakim atum urkum.” ");
INSERT INTO apec_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Douk nenek beten jurug aria anan wata natanam nanak natrugun um ananim biom atun disaipel. Douk anan nanak aria natrum um amam heshuh hagok. Aria anan narig Pita nakri, “Saimon, ipak peshuh pagok aka? Ipak madae dodogowip um pupe punubur um atin aua piyohe uwe aka? ");
INSERT INTO apec_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Ipak pupe piyohe aria punek beten. Um Satan nunaki nukwiraehep um, ipak ta mare punek yoweinyi ina. Adur ipak mishish shakitak um pugipesh eikin baraen aria ipakiruh yegeshiweruh douk madae dodogowiruh uwe.” ");
INSERT INTO apec_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Anan nakripam namudok jurug aria anan wata natanam nanak anah shopunek nanak nenek beten narig Iruhin. Anan nenek anudok atun beten iganigadae narik nenekan iri. ");
INSERT INTO apec_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Anan nanak nenek beten jurug aria wata natanam nanak narpogun-umam. Aria anan natik um amam yobus sam dodog abom aria amam heshuh hagok. Aria anan nenyubarum hakitak aria amam madae hudukemesh um maren baraen ta amam hukripan um uwe. ");
INSERT INTO apec_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Aria Jisas wata shopunek natanam nanak nenek biyeh atih um nanak nenek beten narig Iruhin. Douk anan nenek beten jurug aria watak natanam nanak natogrumam aria nakripam nakri, “Ipak peshuh pape meyoh um douk jurug! Ipak kitak! Nyutob douk banaki, aria douk anan ta niyabig yowemi douk henek yoweishi inahos atin iri um Eik Anudok Arman douk yatogur adurinyi arpen iri. Aria amam ta hunaki husuwe huweshike. ");
INSERT INTO apec_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Aria kitak munak. Tik anudok douk ta niyabig eikim horim um eik iri anudok nanaki.” ");
INSERT INTO apec_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Douk Jisas wata nape nakripam atin, aria Judas, nanak um amudok ananim disaipel nanaki natogur-umam. Anan naniri sabaimi hanaki. Amam douk debeimi pris hani henek skulumesh um lo iri hani amam debeimi Juda hapeik aria heshopokam hasuhwi bainatog gwani rowos aria hanaki. ");
INSERT INTO apec_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Aria amam hakitak hanak yah aria Judas nakrip Jisas ananim horim nakri, “Anudok douk kadak putik um eik inak isuwan inapuprikan iri, anudok douk Jisas. Aria ipak punak pusuwan puweshikan dodog aria puran punak.” ");
INSERT INTO apec_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Aria Judas nanak natogurum Jisas atin aria nakri, “Debeini tisa!” Aria nanak nanapuprikan. ");
INSERT INTO apec_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Aria amam hanak hasuwan dodog aria howeshikan. ");
INSERT INTO apec_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Douk amam howeshikan aria anan neyotu hurukatin iri natuki ananit bainat aria natupak anan douk nenekuman mour meyoh abom um debeini pris iri ananih atah tukarah. ");
INSERT INTO apec_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Aria Jisas narigam nakri, “Ipak pasuhwi bainatog aria rowos um punaki pusuwe puweshike kabi douk eik yakwuaruh iri, aka? ");
INSERT INTO apec_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Ihih nyumneh eik yani ipak mape atugun aria yape yakripesh baraen numun narub um Iruhin ananit debeiti urupat tataoum aria ipak madae pusuwe puweshike uwe. Aria douk ipak ta punek enyudok baraen douk nyetem Iruhin ananik Buk iri nyutogur adurin.” ");
INSERT INTO apec_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Aria ihim-morim ananim disaipel hakutukuk Jisas haruwok. ");
INSERT INTO apec_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","52","Douk amam howeshik Jisas haran harik hanak aria anan weroroini nanawashok shigorihwihi rupah atuh iri nagim Jisas nanak. Anan nagiman nanak aria amam hakri husuwan huweshikan aria ananih rupah hatukweshih hakusuk aria anan naruwok nanak meyoh. ");
INSERT INTO apec_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Aria amam howeshik Jisas haran hanakum debeini pris ananit urupat. Aria amam ihim-morim debeimi pris hani amudok douk henek skulumesh um lo iri hani amam debeimi Juda shopunek hanak hape atudok urupat. ");
INSERT INTO apec_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Aria Pita nagipesh Jisas nanak aria anan nagiguk atin. Douk nanak natogur aria nawish narub um anudok debeini pris ananit urupat aria natik amudok douk heyoh Iruhin ananit debeiti urupat iri hautig nyih aria hapeimeh. Aria Pita shopunek nanak nanamam napeum nyih um hiyakan. ");
INSERT INTO apec_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Aria amam debeimi pris hani ihim-morim debeimi Juda douk hape hasuhw kwotog iri hahwar anam armam hanaki hape henekuman enen baraen douk madae adurin iri uwe um hakri amam debeimi hon nugokumen iri. Aria amam habirak hatik uwok. ");
INSERT INTO apec_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Aria sabaishi arpesh shanaki shenekuman kwot shenek rohw shakri Jisas nenek eneshenesh yoweishi inahos aria esheshin baraen douk madae adurin uwe. Aria shopunek, eshesh douk madae shukri atin baraen uwe. Enesh shakri enen aria enesh shakriyuk enen. ");
INSERT INTO apec_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","58","Aria anam armam henek rohw um Jisas hakri amam hemnekan nakri anan ta nubrig Iruhin ananit debeiti urupat douk armam kanak harukat iri tubuh tukus atap. Aria um biyeh atih nyumneh meyoh, anan ta wata nurok kupaiti. Aria atat ta mare nurukat ananis wis, uwok. ");
INSERT INTO apec_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Aria amam shopunek douk madae hukri atin baraen uwe. Anam hakri enen aria anam hakriyuk enen. ");
INSERT INTO apec_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Aria amam ihim-morim hape hemnek aria anudok debeini pris nakitak narig Jisas nakri, “Nyak enen baraen um nyukripam um aka, uwok? Nyak nyakri mumam um enyudok baraen amam heneken um nyak iri?” ");
INSERT INTO apec_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Aria Jisas neyotu mumuken. Anan madae nukripan enen baraen uwe. Aria anudok debeini pris abom gamo narigan nakri, “Nyak Krais douk Iruhin nagraehen neshopoken nyanaki iri? Aria nyak douk anudok Iruhin douk apak matuk ananin nyeigur nyato iruhw iri ananin Nuganin?” ");
INSERT INTO apec_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Aria Jisas nakripan nakri, “O adur atin douk eik atuwe. Aria ipak ta putik Eik Anudok Arman douk yatogur adurinyi arpen iri inak ipe yopunyi rogur ehahum Dodogowini Iruhin abom. Aria shopunek ta itemi orug inaki gani iruhw heven.” ");
INSERT INTO apec_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Aria anudok debeini pris abom nemnek namudok aria anan nyibur juwehosibur abom aria nabrig ananih rupeh. Aria nakripam nakri, “Apak mare wata muhwar enesh shopunek arpesh um shunaki shukripap um enesh yoweishi inahos anan nenekesh iri uwe, uwok. ");
INSERT INTO apec_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Apak douk iganigadae memnek ananin baraen. Anan douk nabubunim um Iruhin aria ipak pakri mumam?” Aria amam ihim-morim hakri anan nenek yoweishi inahos aria amam ta hon nugok. ");
INSERT INTO apec_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Aria howeshiguk ananis nabes aria anam hakitak hanak hakusehan. Aria hadar wis aria hape han aria harigan hakri, “Nyak kripap kabi amam profet um, douk omi nyaen.” Aria amam heyoh Iruhin ananit debeiti urupat iri habowan popaeshohos aria haran hanak. ");
INSERT INTO apec_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Aria onok armatok kwonekuman mour anudok debeini pris abom iri kwanaki aria kwatik Pita nape atap narub um anudok debeini pris ananit urupat. ");
INSERT INTO apec_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Okwok kwatrun um napeum nyih. Aria okwok kwatrun duk aria kwarigan kwakri, “Nubokuhi eik yatrin nyani Jisas douk nanaki wabur Nasaret iri pape.” ");
INSERT INTO apec_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Aria Pita nenek rohw nakri, “Uwok, eik madae idukemen uwe enyudok baraen nyak nyakriyen iri.” Aria anan nakitak nanak hurukatin um atudok wit douk shenekot tape tatiguk anagas iri aria anat owot takitak teyagwreh. ");
INSERT INTO apec_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Aria okwok wata kwatanam kwatrun aria kwakrip eshudok sheyotu agundok iri kwakri, “Anudok shopunek douk anan Jisas ananin.” ");
INSERT INTO apec_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Aria Pita wata shopunek nenek rohw nakri, “Eik uwok.” Aria douk madae roubum uwe aria eshesh sheyotu agundok iri wata shakrip Pita shakri, “Adur atin nyak douk enen um Jisas ananin. Um maresh? Nyak douk nyapei shokugi nahobig Galili iri.” ");
INSERT INTO apec_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Aria Pita nenek rohw nakri, “Ta eik inek rohwumep um, eik yakri wosik um Iruhin ta ne igok! Eik madae idukeman uwe, anudok arman ipak pape pakriyan iri.” ");
INSERT INTO apec_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Douk anan nakriyuk namudok aria ahudok atuh owot wata shopunek takitak teyagwreh biyeh. Aria Pita urkum morum enyudok baraen iganig Jisas nakriyen iri. Baraen douk enyudok, “Nyak ta nyunek rohw biyeh otuh nyukri nyak madae nyudukeme uwe, aria owot ta tukitak tiyagwreh biyeh.” Aria anan nereh yowiyokuk. ");
INSERT INTO apec_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Aria ruhur atin, amam debeimi pris hani debeimi Juda hani amudok henek skulumesh um lo iri hani ihim-morim debeimi Juda hasuhw kwotog iri hantorum hape habo baraen. Aria amam hohur onohw maduhw haweshik Jisas ananish roguhw aria haran um Pailat douk nape debeini gavman iri. ");
INSERT INTO apec_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Douk hanak hatogur, aria Pailat narigan nakri, “Nyak douk eshesh Juda esheshin king aka?” Aria Jisas nakripan nakri, “Adur, eik douk kabi nyak nyakrium.” ");
INSERT INTO apec_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Aria amam debeimi pris hape henekuman baraen Jisas hadukuman sabainyi rohwin baraen. ");
INSERT INTO apec_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Douk namudok aria Pailat narigan shopunek nakri, “Tik, amam henekumen sabainyi baraen. Aria nyak ta nyuwanamam enen baraen aka, uwok?” ");
INSERT INTO apec_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Aria Jisas madae nukri enen baraen uwe, aria Pailat nakitak yowiyokuk abom. ");
INSERT INTO apec_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Ihish kwarahos ahudok nyumnah shenek agundok debeigini Pasovaigun worigun obi nyutob, Pailat apa nakweshih anan nonoweshik iri nanak fri. Anan apa nukweshih anudok douk eshesh armam armago shukriyan iri. ");
INSERT INTO apec_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Aria abudok nyutob, anan arman douk nanahwarum Barabas iri nani anam armam hani gavman sharpak aria habo enesh arpesh shagok aria hanaweshik hape. ");
INSERT INTO apec_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Aria sabaishi arpesh shanaki shantorum shape aria shape shakrip Pailat um nukweshih anan nape nonoweshik iri douk eshesh shukriyan iri nunak fri kabi douk ihish kwarahos anan apa nenekesh um. ");
INSERT INTO apec_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Aria douk eshesh sharigan namudok aria Pailat narigesh nakri, “Ipak pakri ikweshih eshesh Juda esheshin king nunak fri o pakri meini?” ");
INSERT INTO apec_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Pailat douk nakri namudok um maresh, anan douk nadukemesh abom um amam pris amamim debeimi douk henek nyigiya um Jisas. Amam hatik sabaishi arpesh shagipesh anan atun aria amam nyirub juwehosirub aturub aria douk harawan hanak henekuman kwot um Pailat. ");
INSERT INTO apec_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Aria amam debeimi pris hohur sabaishi arpesh esheshiruh aparuh aria eshesh nyirub juwehos-irub abom um Jisas. Aria eshesh sharig Pailat um nukweshih Barabas nunak fri. ");
INSERT INTO apec_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Aria Pailat wata shopunek narigesh nakri, “Ipak pakri eik inekan mumam anudok arman douk ipak puhwaran eshesh Juda esheshin king iri?” ");
INSERT INTO apec_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Aria eshesh wata shopunek shahwar debeg shakri, “Nyak nyenek nyiluman rowog kruse!” ");
INSERT INTO apec_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Aria Pailat narigesh nakri, “Anan nenek maresh yoweishi inahos um apak mon nugokumesh?” Aria eshesh madae shumnekan uwe. Eshesh shahwar debeg atin shakri, “Nek nyiluman rowog kruse.” ");
INSERT INTO apec_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Aria Pailat nakri nunekesh shunadudareh. Douk namudok aria anan nemnek esheshin baraen aria nakweshih Barabas nanak fri. Aria nakrip amam soldia um hunak hubo Jisas huprukan onohw maduhw segegoihw aria hunak hunek nyiluman nir rowog kruse. ");
INSERT INTO apec_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Aria amam soldia hasuhw Jisas haran hanak hawish debeini gavmman ananit debeiti urupat aria hahwar ihim-morim amudok anam soldia shopunek hanak. ");
INSERT INTO apec_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Aria amam horuman anat routari owishiboriti saket. Aria harokesh onohw segego hwatogrohw iri maduhw hwahwunug kabi douk king ananit hat um, aria hwahwem-uman um ananig barag. ");
INSERT INTO apec_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Aria amam hape habubuniman hakri, “O ruwahep nyak eshesh Juda esheshin king!” ");
INSERT INTO apec_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Aria hohur anah aruh aria hape habo barag sabaih atuh aria hape hokusehan. Aria amam henekan enenyenen hanak habuh hoduk ohrubus hurukatin um anan um hutuk ananin nyeigur nyuto iruhw kabi douk anan king um. ");
INSERT INTO apec_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Douk amam henekan enenyenen jurug, aria hatrun hawaruk atudok owishiboriti saket. Aria wata hohur ananih rupeh hehuruman aria harawan hanakum hunek nyiluman nir rowog kruse. ");
INSERT INTO apec_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Douk hanak orokohunih um yah aria haparug Saimon douk nanaki wabur Sairini iri. Ananim nugamim douk Aleksander nani Rufus. Anan douk nape iri urah nanaki aria nakri nunak nuwish anabur debeiburi wabur. Aria douk amam haparugan namudok aria amam soldia dodogowim atum hakripan um nosah Jisas ananin rowog kruse. ");
INSERT INTO apec_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Aria amam harao Jisas hanak anagun douk shahwaragun um Golgota iri. Baugenyum um enyudok baraen douk nyakri arpenyig barag. ");
INSERT INTO apec_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Aria agundok amam hakutu anan marasin nyeigurinum mer nabuhum wainibar abar aria hakri huko Jisas nuburoh. Aria anan nakri uwok. ");
INSERT INTO apec_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Aria amam henek nyiluman neiruk rowog kruse aria hohur ananih rupeh hehubuk aria hape habirak kabi douk satuum. Amam habirak um anan nunek uhwin iri nunohur anah rupah. Aria amam henekesh namudok atinyum ihihmorim ananih rupeh. ");
INSERT INTO apec_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Aria douk ruhur, arigaha 9 kilok wah hatao aria amam henek nyiluman neir rowog kruse. ");
INSERT INTO apec_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Aria amudok douk henek-uman baraen Jisas iri howem enyudok baraen douk amam henek kwotuman-umen iri hakri, ESHESH JUDA ESHESHIN KING. aria heshopen iruhw um rowog kruse agundok Jisas neir um. ");
INSERT INTO apec_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Aria agundok amam henek nyilim Jisas neir orokohun aria biom hakwuaruh iri heir wobuwobur hurukatin um anan. ");
INSERT INTO apec_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Amam douk henek nyiluman nani amudok hakwuaruh iri aria henek enyudok baraen nyetem Iruhin ananik Buk iri nyatogur adurin. Baraen douk enyudok, “Eshesh shatrun kabi douk nabrig lo iri um.” ");
INSERT INTO apec_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Aria arpesh shenek yowi kare iri shape shabubuniman aria sharigan shakri, “Nubokuhi nyakri nyak ta nyubrig Iruhin ananit debeiti urupat aria hukri um biyeh atih nyumneh um, nyak ta wata nyurukat! ");
INSERT INTO apec_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Douk namudok aria douk nyak nyukweshih nyak kanak aria nyukutukuk rowog kruse nyubihi atap!” ");
INSERT INTO apec_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Aria amam debeimi pris hani amam douk henek skulumesh um lo iri shopunek hanaki hape hahan henekan enenyenen. Aria amam kanak hanakripam hakri, “Anan nutaurum kupaishi, aria anan douk madae nutaurum anan kanak uwe. ");
INSERT INTO apec_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Aria anan douk Krais eshesh Israel esheshin king douk Iruhin neshopokan nanaki iri akure, douk anan nukutukuk rowog kruse nubihi atap. Aria apak mutrun aria ta munek bilipuman!” Aria amudok biom douk hataur wobuwobur hurukatin um Jisas iri shopunek hahan hakripan enenyenen. ");
INSERT INTO apec_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Douk aun nakihi arigaha 12 kilok aria wab babuhi. Aria ihirub-morim eshesh Juda esheshirub warub betem arukwutigun um atin. Agagun arukwutigun nape namudok arigaha wabigep 3 kilok aria wah wata hatao aria arisigun. ");
INSERT INTO apec_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Aria wabigep 3 kilok, Jisas nahwar debeg um esheshin baraen nakri, “Eloi, Eloi, lama sabaktani?” Baugenyum um enyudok baraen douk nyakri, “Eikin Iruhin, eikin Iruhin, nyak nyakutukuk eik um maresh?” ");
INSERT INTO apec_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Aria enesh arpesh sheyotu agundok iri shemnekan aria shakri, “Ipak pumnek, anan nahwar Ilaija.” ");
INSERT INTO apec_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Aria anan arman nasahur nanak nohur enen spansnosegurin anabar nubutibari abar. Aria nanyaur anah aruh aria natuken nyato um Jisas ananit nokwat um nubarah. Aria anudok arman nakripesh nakri, “Jurug aria apak mupe mutrugun. Ilaija ta nunaki nukweshihan nubuhi rowog kruse aka, uwok?” ");
INSERT INTO apec_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Aria Jisas nahwar debeg aria anan nagok. ");
INSERT INTO apec_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Aria ahudok rupahhataur numun Iruhin ananit debeiti urupat iri tukarah um biyeh. Tukarahi gani iruhw arigaha hanak habuh hatao. ");
INSERT INTO apec_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Aria amam soldia amamin debeini douk neyotu hurukatin um rowog kruse Jisas neir um natik agundok Jisas nagok um aria nakri, “Adur atin anudok arman douk Iruhin ananin nuganin!” ");
INSERT INTO apec_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Aria agundok, ono armago weyotuwi madae rougun abom uwe aria wape watrishi. Onok douk Maria douk kwanaki wabur Makdala iri kwani Salome, wani kupaikwi Maria douk kwabuki shokuni Jems nani Josis iri. ");
INSERT INTO apec_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Oudok armago riguk Jisas nape shokugi nahobig Galili um, owo apa wagipeshan aria wape wenekuman worigun. Aria sabaiwari kupaiwari armago douk waniri Jisas shatowi gani Jerusalem iri shopunek weyotuwi aria wape watrishi. ");
INSERT INTO apec_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Aria ahudok nyumnah shabo Jisas ahi, eshesh shape shenek esheshigun worigun aria mahish um ruwahepih Sabat shishoh iri. Aria ahudok atuh nyumnah arigaha wabigep, aria Josep douk nanaki wabur Arimatea iri nanaki. Anan douk anan um eshesh Juda esheshin debeini kaunsol douk nyeigur nyato-uman iri. Aria anan shopunek apa nape natrugun um abudok nyutob arpesh shuwish um agundok Iruhin nupe Debeini um ananish arpesh um. Aria Josep madae nunogugur uwe, uwok. Anan nanak um Pailat napeum aria narigan um anan nunak nubre Jisas nunak nuruman. ");
INSERT INTO apec_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Aria douk Pailat nemnek namudok aria anan nakitak yowiyokuk abom um agundok Jisas nagok arigas abom um. Aria anan nahwar amam soldia amamin debeini nanaki aria narigan nakri, “Adur, Jisas nagok aka, watak?” ");
INSERT INTO apec_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Aria anan nakrip Pailat um Jisas douk adur nagok. Douk namudok aria Pailat nakrip Josep um nubreyan nunak aria nuruman. ");
INSERT INTO apec_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Aria Josep nanak nator anah yopuhi shigorihwihi rupah nasuah aria nanak nabre iri Jisas rowog kruse nabuhi atap neshurehan aria nanak naruman. Anan nanak nawish nanabuk numun onohw wonugwehw douk sharokohw shawish onok burbuduk iri. Douk nawish nanabukuk aria natogur natotigosi anam debeimi utom manaki neshopam ahwudok wonugwehw. ");
INSERT INTO apec_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Aria Maria douk kwanaki Makdala iri kwani kupaikwi Maria douk kwabuki Josis iri wape watrugun. Aria watiku agundok douk Josep nanak nabukuk Jisas um. ");
INSERT INTO apec_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Douk wabigep hurukatin um wab ahudok nyumnah Sabat, eshesh Juda shape meyoh ahi hatuh, biwotuk armago wanak wator anar wel douk reisik wosik iri um wakri unak urayok Jisas ananihw yegenyihw. Oudok armago owowish nyeiguhw douk eshudok. Maria douk kwanaki Makdala iri kwani kupaikwi Maria douk kwabuki Jems iri, wani Salome. ");
INSERT INTO apec_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Aria ruwahepih sagomatinyih nyumnah um wik,wata ruhur atin, owo wakitak wanak gani wonugwehw hwapeum. Douk owo wanak watogur wonugwehw hwape um aria wah ko hatao. ");
INSERT INTO apec_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Aria owo wata wape wanak yah aria wanayagwreh wakri, “Ta omi nyutotigasuk utom douk magah wonugwehw iri?” ");
INSERT INTO apec_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Aria owo wanak hurukatin aria wakri utrugunu aria watiku amudok takweimi utom douk magah wonugwehw iri douk madae anam mutao uwe. Amam douk matatigos manak makusuk anagas. ");
INSERT INTO apec_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Aria owo wanak wawish numun ahwudok wonugwehw aria watik anan weroroini arman, nenenek rouhi shigorihwihi rupah iri nape. Anan napeum yopunyi rogur ehah numun wonugwehw aria owo wakitak yowiyokuk abom. ");
INSERT INTO apec_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Aria anan nakripo nakri, “Ipak mare pukitak yowiyokuk uwe, uwok. Eik yadukemesh, ipak douk paurim Jisas douk nanaki wabur Nasaret iri. Anan douk shenek nyiluman neir rowog kruse iri. Aria ipak tik, okwudok outuk douk shanabuk um. Agundok madae anan nukus uwe, uwok. Anan douk nakitak nape. ");
INSERT INTO apec_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Aria ipak punak pukrip ananim disaipel huni Pita pukri, ‘Jisas iganigadae narik nanak um Galili. Aria ipak pugiman punak putogruman kabi douk nubokuhi anan nakripep-umaguk um.’” ");
INSERT INTO apec_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Aria douk owo womnek namudok aria wakutukuk wonugwehw watograri aria wosahur wanak. Owo wanogugur abom aria owo arugoguhwiar wao atin wanak. Aria shopunek owo madae ukripaguk enesh arpesh um eshudok owo watrish iri uwe. ");
INSERT INTO apec_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Douk eshesh Juda shape meyoh ahi nyumnah Sabat iganigadae hatuh. Aria ruwahepih sagomatinyih nyumnah um wik,ruhur atin Jisas wata nakitak nape. Aria sagomatin anan natogur um Maria douk kwanaki Makdala iri. Okwok douk riguk 7-poreish yoweishi sagabehos shapenyok aria anan wata nahiyaheshuk sharuwok iri. ");
INSERT INTO apec_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Douk kwatrun-uguk aria okwok kwanak kwatogur um ananim disaipel aria kwatrum um amamiruh aparuh douk yoweruh aria hape hereh. Aria okwok kwakripam um okwok kwatik Jisas wata nakitak napeum. ");
INSERT INTO apec_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Aria amam hemnegok aria madae hunek bilip uwe. Amam hakri okwok kwenek rohw. ");
INSERT INTO apec_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Douk enyudok nyanakuk aria anah nyumnah, biom Jisas ananim disaipel hakitak hakutukuk wabur aria hagim urahih yah hanak. Amam hanak aria Jisas natogur nape anagun sikigun aria nanaki natogur-umam. ");
INSERT INTO apec_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Anan natogur-umam hatrun aria amam wata hatanam hanak hakrip amudok anam disaipel um agundok amam hatrun um. Aria douk amam hakripam aria amam shopunek madae hunek bilipumam uwe. Amam hakri amudok biom douk henek rohw. ");
INSERT INTO apec_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Aria hagiguki, ananim 11-poreim disaipel hape hawok worigun aria Jisas nanak natogur-umam. Aria naham nakri, “Ipakigos baragos douk dodogowigos aria seshukep abom. Nubokuhi enesh arpesh douk shatrue wata yakitak yape aria shanaki shakripep aria ipak madae punek bilip uwe. Ipak pakri eshesh shape shenek rohwumep.” ");
INSERT INTO apec_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Aria anan nakripam nakri, “Ipak punak ihirubmorim warub bape agundok atap iri aria pukripesh Iruhin ananin yopinyi baraen ihishmorim arpesh. ");
INSERT INTO apec_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Ipak pukripesh aria eshudok douk shumnek enyudok baraen shunek bilipumen aria kupaishi shunek baptaisumesh iri, Iruhin ta wata nunarawesh shutanamori shupe wosik abom. Aria eshudok douk shumneken aria mare shunek bilipumen iri, Iruhin ta nunekumesh debeiti kwot um eneshenesh yoweishi inahos eshesh shape shenekesh iri. ");
INSERT INTO apec_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Aria eshudok douk shunek bilip iri, Iruhin ta nutaurumesh nunekesh dodogowish aria ta shunek sabainyi mour kabi douk Iruhin atun neneken iri. Eshesh ta shihiyahuk sagabehos douk shape arpesh iri shukripesh um eikin nyeigur aria ta shutogur shuruwok. Aria shopunek, ta shiyagwreh enen kupainyi baraen. ");
INSERT INTO apec_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Aria ta shuhur yuguhw douk hwabo arpesh shagok iri shusuwoguh esheshis wis um, ogwoguh ta hunatukesh aria ta mare shugok uwe, uwok. Aria ta shuwok anabar abar douk arpesh apa shabroh ba shagok iri um, eshesh ta mare shugok. Aria eshesh ta shuwemesh wis sharao arugeh iri arpesh aria eshesh ta wata yopish.” ");
INSERT INTO apec_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Aria douk Debeini Jisas nakripesh baraen neyaten aria Iruhin naran nato um iruhw heven. Anan nato aria nanak nape yopunyi rogur ehahum Iruhin. ");
INSERT INTO apec_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Aria Jisas ananim disaipel hanak sabairubi warub aria hakripesh Iruhin ananin yopinyi baraen sabaishi arpesh. Aria abudok nyutob amam hape hakripesh yopinyi baraen um, Debeini nataurumam nenekam dodogowim aria henek sabainyi mour Iruhin atun nenekan iri. Aria arpesh shatik enyudok mour amam heneken iri aria shakri adur atin, amam douk Iruhin nataurumam. Aria amamin baraen douk adurin atin abom. ");
INSERT INTO apec_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","O Tiofilus, riguk sabaishi arpesh shakwiraeh showem baraen um ihishmorim eshudok eneshenesh douk Iruhin nohur Jisas nenekesh shatogur orokohun um apak iri. ");
INSERT INTO apec_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Eshesh showem baraen um eshudok eneshenesh douk eshudok arpesh sagomatin shatrish esheshis nabes aria shakripap-umesh iri. Eshudok shakripap iri arpesh douk shenek mour um shakripesh Iruhin ananin baraen iri. ");
INSERT INTO apec_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Aria shokubur atin eik yape yarigesh yenek surisorik yaurim baugenyum baraen um gani baugos enyen nyakitak nyanakumori. Namudok aria eik shopunek yakri wosik um inyem wosik atin enyudok baraen kabi douk sagomatin nyakitak nyanaki um aria ishopoken nyunakumagu nyak yopuyopuni arman Tiofilus. ");
INSERT INTO apec_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Eik yenekesh namudok um nyak ta nyudukemen wosik enyudok baraen douk riguk shenek skulumen-enyi, douk adurin atin abom. ");
INSERT INTO apec_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Abudok nyutob Herot nape king um shokugi nahobig Judia obi nyutob, anan arman shahwaran um Sekaraia iri shopunek nape. Anan douk anan pris. Aria anan douk nanaki apudok awirop um pris douk shahwaram um Abiya iri. Aria ananik irohukwik douk shahwarok um Elisabet. Okwok shopunek douk kwakitak agundok Aron ananip awirop iri. ");
INSERT INTO apec_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Aria Iruhin natrish um, eshudok biyesh shagipesh lo atin abom iri biyesh shape. Eshesh shagipeshen sheyaten um Debeini nakripesh-enyi baraen nyani lo seiwok nakoguk Moses enyi. ");
INSERT INTO apec_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Aria eshesh douk batowish wokesh. Um maresh, Elisabet kupik. Aria eshesh biyesh douk ruwehesh abom. ");
INSERT INTO apec_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","9","Arigaha aria anah nyumnah douk Sekaraia nani ananip awirop amam pris amamih nyumneh um hunek mour numun Iruhin ananit debeiti urupat um hatogur. Aria amam henek enesh eshudok hagipesh ehudok amamih aih um hudukemesh um ta meini pris nurik nuwish nunek ofa um eshudok nuko Iruhin. Aria ahudok nyumnah, Sekaraia nenek uhwin um nuwish Debeini ananit debeiti urupat um nuweh eshudok sheisik wosik iri um nunek ofa nuko Iruhin um enyudok alta. Amam henekesh namudok aria anan nawish numun Debeini ananit debeiti urupat. Aria Sekaraia neyotu numun nape nuweh eshudok nenek ofamesh nako Iruhin aria Iruhin nape natrun. ");
INSERT INTO apec_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Aria abudok nyutob nawish nuweh eshudok obi nyutob, ihishmorim arpesh shenek lotu um Iruhin iri shantorum shape aduk shape shenek beten. ");
INSERT INTO apec_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Aria enen Debeini ananin ensel nyatogruman aria natrin. Enyen nyatogur meyoh nyeyotu um yopunyi rogur ehahum enyudok alta douk amam pris hape howem eshudok sheisik wosik iri henek ofamesh hako Iruhin iri um. ");
INSERT INTO apec_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Douk Sekaraia natrin aria anan nakitak yowiyokuk aria nanogugur abom. ");
INSERT INTO apec_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Aria enyudok ensel nyakripan nyakri, “Sekaraia, nyak mare nyunogugur. Iruhin douk nemnek nyakin beten aria nyakik irohukwik Elisabet ta kwubukumenyi anan nuganin. Aria nyak ta nyuhwaran nyeigur Jon. ");
INSERT INTO apec_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Aria nyakihw apahw ta hur wosik aria ta nyunadudareh nyuriguk. Sabaishi arpesh shopunek ta shunadudareh abudok nyutob okwok kwunabuki obi nyutob. ");
INSERT INTO apec_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Aria agundok Debeini nutrun um, anan ta nupe debeini arman. Anan ta mare nuwok wainibar abar buni anabar dodogowibari, uwok. Anan ta wata nur apahw aria Iruhin ananin Mishin ta nyuwishan aria nyupenyan shuknin abom. ");
INSERT INTO apec_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Anan ta wata nurauri sabaishi arpesh eshesh Israel shukutukuk eneshenesh yoweishi inahos aria wata shutanamori um Iruhin esheshin Debeini. ");
INSERT INTO apec_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Anan ta dodogowin atun kabi douk profet Elaija um. Aria shopunek, anan ta nurao Elaija ananih aih. Aria anan ta nurik aria Debeini ta nugiguk. Anan ta nubadig arhim amamip urkwip aria amam ta wata urkwip punawasham amamish batowish. Aria ta nubadig madae shumnek baraen atin iri esheship urkwip aria ta wata shurao yopishi arpesh esheship urkwip. Aria anan ta nutaurum Debeini ananish arpesh um shukeshuguk agabus yoweishi inahos aria shunek redi shupe shutik um Debeini nunaki nutaurumesh um.” ");
INSERT INTO apec_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Aria Sekaraia nakrip enyudok ensel nakri, “Eik douk ruwogin aria eikik irohukwik shopunek douk ruwogik. Aria eik ta idukemesh mumam aria douk ikri enyudok baraen douk adurin?” ");
INSERT INTO apec_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Aria ensel wata nyakripan nyakri, “Eik Gabriel douk yeyotu Iruhin napemori. Anan douk nashopoke yanakumori ini nyak wiyagwreh aria ikripen enyudok yopinyi baraen. ");
INSERT INTO apec_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Aria nyak douk madae nyunek bilip um eikin baraen uwe. Douk namudok aria nyakit nokwat ta tishuk tupe namudok atin. Nyak ta mare nyiyagwreh atin arigaha ahudok nyumnah Iruhin nakriyahi um enyudok eik yakripenyumen iri baraen nyutogur adurin atin.” ");
INSERT INTO apec_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Aria abudok nyutob ensel nyape nyakripan baraen obi nyutob, eshudok armam armago shape aduk iri shape shabeiman. Eshesh shakri maresh shatogruman aria anan douk nape roubi gani numun urupat. ");
INSERT INTO apec_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Arigaha douk natograri aria nabirak um nakri nunamesh niyagwreh aria nabirak natik uwok. Douk namudok aria eshesh shadukemesh shakri anan natik enesh eshudok eneshenesh gani numun Iruhin ananit debeiti urupat. Aria nakri nukripesh baraen um, anan naurumesh rogur meyoh. ");
INSERT INTO apec_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Arigaha douk ananib nyutob um nenek mour pris numun urupat um batuh aria wata natanamum ananibur wabur. ");
INSERT INTO apec_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Anan nanak nape anob nyutob banak badiguk aria ananik irohukwik Elisabet kwanarahaen. Aria kwanabeshuk kwape urupat atut um 5-poreib aub. ");
INSERT INTO apec_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Aria kwakri, “Arigaha douk Debeini nutaurume namudok. Anan nawarukuk abraen um agundok arpesh shatruweim yape kipiwe um.” ");
INSERT INTO apec_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Douk Elisabet kwanarahaen kwape arigaha douk bakri um 6-poreib aub um, Iruhin neshopok enen ensel nyeigurinyum Gebriel iri nyanak um anabur wabur bape shokugi nahobig Galili iri. Abrudok wabur douk shahwarabur um Nasaret. ");
INSERT INTO apec_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Enyudok ensel nyaraumokwi baraen onok armatok shahwarok um Maria iri. Okwok douk wata kwurao anan arman shupe atugun uwe, uwok. Okwok douk shakriok um anan arman shahwaran um Josep iri. Anan douk nakitak king Devit ananip awirop iri. ");
INSERT INTO apec_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Enyudok ensel nyanaki nyatogrumok aria nyakripok nyakri, “Ruwahep Maria, nyakin mishin nyur wosik aria nyanadudareh. Debeini nani nyak nape hurukatin aria nenekumen yopunyi.” ");
INSERT INTO apec_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Aria Maria kwomnek enyudok baraen aria okwok urkum yowem. Okwok madae kwudukem baugenyum enyudok baraen ensel nyakripoken iri uwe. ");
INSERT INTO apec_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Aria ensel nyakripok nyakri, “Maria, nyak mare nyunogugur uwe, uwok. Iruhin douk nanadudareh-umen aria ta nunekumen yopunyi. ");
INSERT INTO apec_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Mnek! Nyak arman douk wata nyurao anan uwe, aria nyak ta nyonarahaen aria nyubuki anan nuganin. Aria nyak ta nyudowon nyeigur Jisas. ");
INSERT INTO apec_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Aria anan ta nutogur debeini arman. Aria ta shuhwaran Debeini Iruhin abom douk nariguk ihish arpesh shani eneshenesh eshudok shabuhuk iri um ananin Nuganin. Debeini Iruhin ta nunekan nutogur king kabi douk ananin babuken Devit um. ");
INSERT INTO apec_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Aria ihih nyumneh anan ta nupe deben um Jekop ananish popehesh yamehesh. Anan ta nupe Debeini um ananish arpesh namudok atin ihih nyumneh.” ");
INSERT INTO apec_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Aria Maria wata kwakrip enyudok ensel kwakri, “Enyudok ta nyutogur mumam? Eik wata irao anan arman uwe.” ");
INSERT INTO apec_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Aria ensel nyakripok nyakri, “Iruhin ananin Mishin ta nyuwishen aria debeini Iruhin ananin dodog abom ta nyishigorin. Douk namudok aria anudok yopuyopuni nuganin abom nuhut nyunubuk iri ta shuhwaran Iruhin ananin Nuganin. ");
INSERT INTO apec_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Mnek, okwudok armatok Elisabet douk kwani nyak ipak atup awirop iri douk shakri kwape kupik. Okwok douk ruwogik abom aria okwok douk kwanarahaen. Aria douk 6-poreib aub badiyok. ");
INSERT INTO apec_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Aria eshesh douk madae enesh eshudok eneshenesh douk Iruhin ta nubirak um mare nunekesh iri uwe, uwok.” ");
INSERT INTO apec_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Aria Maria kwakripan kwakri, “Eik yenekuman mour meyoh Debeini iri. Aria anan wosik nunekume enyudok nyutogur kabi douk nyak nyakrium.” Aria enyudok ensel nyakutukuk nyanak. ");
INSERT INTO apec_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Enyudok ensel nyanak nyeyagwrehuk um jurug, aria kwape arigaha douk anah nyumneh hanak hadiguk, aria Maria kwanagabe eshudok aria arigas kwaikitak kwatoum yadururuh kwanak. Okwok kwanak um anabur wabur douk bape shokugi nahobig Judia iri. ");
INSERT INTO apec_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Okwok kwanak kwatogur kwawish Sekaraia ananit urupat aria kwonekumok yopuhi nyumnah Elisabet. ");
INSERT INTO apec_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Aria douk Elisabet kwomnek um agundok Maria kwonekumok yopuhi nyumnah um, aria batowin nyor okwokwihw apahw iri nyanagugwanam. Aria Iruhin ananin Mishin nyawish Elisabet abom aria nyapenyok shukunik. ");
INSERT INTO apec_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Douk nyawishok aria nyakuhur kweyagwreh debeihi mah kwakri, “Nyak nyeshagrakuk ihiyumorim armago um agundok Iruhin nenekumen yopunyi um. Aria shopunek, enyudok batowin nyak nyunyubuki iri, Iruhin ta nunekumen yopunyi atin. ");
INSERT INTO apec_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Aria enyudok douk nyatogrume um agundok eikin Debeini ananik amakek kwanaki kwatiwe um? Eik douk madae debeikwi armatok uwe. ");
INSERT INTO apec_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Aria abudok atub nyutob abom eik yemnek agundok nyak nyenekume yopuhi nyumnah obi nyutob, batowin nyor eikihw apahw iri nyanadudareh aria nyanagugwanam. ");
INSERT INTO apec_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Nyak douk nyenek bilip um Debeini ananin baraen aria nyak douk nyanadudareh. Debeini ta nuneken nyutogur kabi douk riguk anan nakripenyum!” ");
INSERT INTO apec_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Aria Maria kwakri, “Eik yanadudareh abom aria yatuk Debeini ananin nyeigur nyato iruhw. ");
INSERT INTO apec_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Eikin mishin douk nyanadudareh um Iruhin douk nutaurume naraowe yatanamori yape wosik atin iri. ");
INSERT INTO apec_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Um maresh? Anan urkum morum eik nyeigur woke iri douk yasuhw ananin mour iri. Douk arigaha kweipon, ihishmorim arpesh ta shukri eik douk Iruhin nutaurume aria neneke yanadudareh atin iri. ");
INSERT INTO apec_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Eshesh ta shukri yanadudareh um enyudok debeinyi yopunyi mour abom douk Debeini Iruhin nenekenyume iri. Aria ananin nyeigur douk nyenek holi abom aria yopuyopunyi. ");
INSERT INTO apec_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Anan douk nenek giha abom um eshudok arpesh douk shape shakamum anan shagipeshan iri. Anan ta nenek gihaumesh arigaha shugokuk aria esheshish batowish shugiguk shukitaki iri shopunek. Anan ta nunekesh namudok atin. ");
INSERT INTO apec_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Aria anan dodogowin nenek mour um, anan apa nabo eshudok arpesh douk shanahur esheshish nyeiguhw shato iruhw aria esheship urkwip porum shunek yoweishi inahos iri nahiyahesh sharuwok shanak atin atinyuk. ");
INSERT INTO apec_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Anan neyatakuk amam king nam habuhuk aria natuk nyeiguhw wokeshi arpesh shato iruhw. ");
INSERT INTO apec_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Aria nekesh sabaishi yopishi eneshenesh eshudok yaruhish arpesh iri. Aria arpesh douk shatik sabaishi eshudok eneshenesh iri neshopokesh shanak wis wohis. ");
INSERT INTO apec_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Ananim urkum douk wata morum enyudok adurin atinyi baraen douk seiwok nakripaguk apakish yamehesh-enyi. Aria nanaki um nutaurum ananish arpesh eshesh Israel douk shasuhw ananin mour iri. ");
INSERT INTO apec_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Aria anan urkum morum nunek yopunyi um Abraham nini ananish batowish iri popehesh yamehesh douk shugiguk shutograri iri aria nenek gihaumesh namudok atin ihih nyumneh.” ");
INSERT INTO apec_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Aria Maria kwani Elisabet wape biyab atun aub batuh aria wata kwatanam kwanak um wabur. ");
INSERT INTO apec_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Aria nyutob um Elisabet kwubanuh obi nyutob banak batograri aria kwabanuh kwabuki armanin batowin. ");
INSERT INTO apec_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Aria okwokwishi shani eshudok douk shape hurukatin iri shemnek um agundok Debeini nenekumok yopunyi um aria eshesh shopunek shanak shanadudareh. ");
INSERT INTO apec_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Aria douk arigaha 8-poreih nyumneh hadiguk anudok nuganin, aria shanakumori shutah ananihw yegenyihw. Aria eshesh shakri shudowan nyeigur Sekaraia douk ananin yain nanahwarom um. ");
INSERT INTO apec_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Aria ananik amakek kwakri, “Uwok. Ananin nyeigur ta muhwaran Jon.” ");
INSERT INTO apec_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Aria eshesh shakripok shakri, “Nya, ipak atup awirop um douk madae anan arman nunahwar enyudok nyeigur uwe.” ");
INSERT INTO apec_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Aria eshesh shauraman wis um ananin yaken shariganum shakri nukripesh um meinyi nyeigur anan nakri shuhwar nuganin-uman. ");
INSERT INTO apec_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Aria anan naurumesh wis um sharauri anat slet aria nowem enyudok baraen nakri, “Ananin nyeigur douk Jon.” Aria eshesh ihishmorim shakitak yowiyokuk abom shape. ");
INSERT INTO apec_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Aria abudok atub nyutob, Sekaraia ananit nokwat tani yaham wata shanupok neyagwreh aria nape natuk Iruhin ananin nyeigur nyato iruhw. ");
INSERT INTO apec_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Aria ihishmorim arpesh shape hurukatinyum eshesh iri shanogugur abom. Aria baraen nyarahaen nyanak ihirub warub douk betem yodururuh agudok shokugi nahobig Judia iri. Aria ihishmorim shadukemesh um enyudok douk nyatogurum Sekaraia nani Elisabet iri. ");
INSERT INTO apec_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Aria ihishmorim arpesh douk shemnek um enyudok iri shape urkwip porumen aria shakri, “Anudok nuganin nukitak yopun um, anan ta nutogur manan arman?” Um maresh? Eshesh shadukemesh um Debeini nani anan nape hurukatin aria ananin dodog douk nyapenyan. ");
INSERT INTO apec_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Aria Iruhin ananin Mishin nyawish Jon ananin yaken Sekaraia nyapenyan shuknin aria neyagwreh Iruhin ananin baraen kabi douk amam profet heyagwrehen um. ");
INSERT INTO apec_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Sekaraia nakri, “Apak mutuk Debeini apak Israel apakin Iruhin ananin nyeigur nyuto iruhw. Anan nanaki nataurum apak ananish arpesh aria wata nanarap mape wosik. ");
INSERT INTO apec_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Anan nagraehumap anan dodogowin atunari arman um nunarap mutanamori mupe wosik abom iri. Anudok arman douk nakitak Devit nasuhw Iruhin ananin mour iri ananip awirop. ");
INSERT INTO apec_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Kabi douk seiwok ananin Mishin nyawish amam yopumi profet aria hakriyenyuguk iri baraen nyakrium. ");
INSERT INTO apec_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Anan nakri adur abom um ta nutaurumap nunarap mukutukuk apakish horim. Aria shopunek ta nutaurumap um nunarap mukutukuk ihishmorim arpesh douk shakapaguk agabus iri. ");
INSERT INTO apec_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Riguk nakripeshuk ananin adurin atinyi baraen kontrak apakish popehesh yamehesh um ta nutaurumesh. Aria anan douk wata urkum morum ananin kontrak douk riguk nakriyen um douk ta nugipeshen aria nutaurum apak um. ");
INSERT INTO apec_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Anan narik nakri iruhw nakripan enen adurin atinyi baraen abom um apakin yamenen Abraham. Aria douk nakri nunekenyumap kabi riguk nakri ta nunekenyumap um. ");
INSERT INTO apec_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Anan nakri nutaurumap nunarap mukutukuk apakish horim um musuhw ananin mour aria mare munogugur uwe, uwok. ");
INSERT INTO apec_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Anan nataurumap um nakri apak mupe agundok atap um, apak mupe ananishi atish mupe holi aria mugipesh lo atin iri arpesh aria anan nupe nutrup munek ananin mour. ");
INSERT INTO apec_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Aria nyak eikin batowin, arpesh ta shuhwaren Debeini abom atunari Iruhin ananin profet. Nyak ta nyurik nyunak nyukrip arpesh um shukutukuk yoweishi inahos shupe wosik atin aria shupe shutik um Debeini um ta nunaki um. ");
INSERT INTO apec_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Nyak ta nyukrip apak ananish arpesh Israel aria mudukemesh um anan ta nukweshihuk eneshenesh yoweishi inahos apak menekesh iri, aria wata nunarap mutanamori mupe wosik atin. ");
INSERT INTO apec_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Apakin Iruhin ta nunek enyudok um maresh, anan douk yopuyopunum apak abom aria nenek gihaumap. Aria anan ta nuneki lait douk tabuhi kabi aun nakihumori gani iruhw heven tubuhi tuwishap. ");
INSERT INTO apec_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Atat ta tubuhmori eshudok arpesh douk shape arukwutigun aria hurukatin um shugok iri aria eshesh ta wata shunatrugun. Anan ta nutaurumap mugipesh ahudok yopuhi yah um mupe wosik aria aparuh hur wosik um.” ");
INSERT INTO apec_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Aria douk arigaha Jon nakitak yopun aria dodogowin abom um agundok ananim urkum manawasham Iruhin um. Aria nanak nape wehigun um arpesh uwok um. Anan nape agundok arigaha ahudok nyumnah natogur yopugunum aria eshesh Israel shatrun aria nape nakripesh Iruhin ananin baraen ahi iri. ");
INSERT INTO apec_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Aria abudok nyutob Maria kwanarahaen obi nyutob, Sisar Ogastas nenek enen lo nyanak um ihirubmorim warub. Anan nakri ihishmorim arpesh shape abudok debeibi amnab Rom esheshib iri ta shunaki shurao esheshish nyeiguhw shushem bumeb. ");
INSERT INTO apec_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Abudok nyutob douk sagomatinyib nyutob um shurao nyeiguhw um. Aria Kwirinius douk nape debeini um gavman um shokugi nahobig Siria. ");
INSERT INTO apec_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Namudok aria ihishmorim arpesh shanak um esheshirub debeirubi warub sisiguk atin um shuwem esheshish nyeiguhw. Eshesh shanak um debeirubi warub douk seiwok esheshish popehesh yamehesh shapenyarubi. ");
INSERT INTO apec_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Aria abudok nyutob, Josep nape wabur Nasaret douk bape shokugi nahobig Galili iri aria nakitak nanak um Betlehem douk bape shokugi nahobig Judia iri. Naburdok douk seiwok shobuki King Devit aburi. Aria Josep douk nanak um Betlehem um maresh? Anan douk nakitak agundok King Devit ananip awirop. ");
INSERT INTO apec_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Anan nani ananik irohukwik Maria shanak um shuwem esheshish nyeiguhw. Aria abudok nyutob, Maria douk kwanarahaen. ");
INSERT INTO apec_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Aria eshesh wata shape Betlehem aria nyutob batogur um okwok kwubanuh um. ");
INSERT INTO apec_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Aria okwok kwabanuh kwabuki sagomin nuganin. Douk kwanabuki aria kweshrehan rupeh kwonor nor anas bokis douk shorumesh worigun bulmakauhos shagnoh um. Um maresh? Urupat arpesh sheshuhati douk shuknit um arpesh aria madae anagun nupeik meyoh um eshesh shishuh um uwe, uwok. ");
INSERT INTO apec_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Aria abudok wab anam heyoh sipsipahos iri harao amamish sipsipahos hatogur aduk abrudok wabur aria hape heyohesh. ");
INSERT INTO apec_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Aria enen Debeini ananin ensel nyatogrumam aria Debeini nenek agundok amam heyotum bogaragun nakusuk. Namudok aria amam hanogugur abom. ");
INSERT INTO apec_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Aria enyudok ensel nyakripam nyakri, “Ipak mare punogugur uwe, uwok. Eik yanakumori ikripep yopinyi baraen douk ta nyunek ihish arpesh shunadudareh abom iri. ");
INSERT INTO apec_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Ahudok nyumnah onok armatok kwabuki anan armanin batowin. Okwok kwanabuki Devit ananibur wabur Betlehem. Anan douk Debeini arman Krais douk Iruhin nagraehan neshopokan nanakumori nunarao arpesh iri. ");
INSERT INTO apec_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Aria ipak ta putrun aria pudukeman namudok. Ipak ta putik enen armanin batowin amakek kweshrehen rupeh aria kwonyor nyor anas bokis douk sheremesh worigun bulmakauhos shagnohasi.” ");
INSERT INTO apec_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","14","Douk enyudok ensel nyakripam namudok aria ahudok atuh sabaishi dodogowishi enselahos abom shape iruhw heven iri shatogur shani enyudok ensel sheyotu. Aria shape shatuk Iruhin ananin nyeigur nyato iruhw. Shakri, “Apak matuk Iruhin ananin nyeigur nyato iruhw. Anan douk nape gani iruhw heven iri. Ipak arpesh pape atap iri douk apa penek Iruhin nanadudareh-umep iri ipakiruh aparuh hur wosik aria punadudareh.” ");
INSERT INTO apec_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Douk enselahos shakutukuk amudok hape heyoh sipsipahos iri shatanam shatomokuk iruhw heven aria amam hanakripam hakri, “Apak munak um Betlehem um mutik enyudok mugu douk nyatogur iri. Enyudok douk Debeini nakripap-umenyuguk iri.” ");
INSERT INTO apec_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Namudok aria arigas amam hakitak hanak aria haparug Maria kwani Josep aria hatik enyudok batowin shopunek nyor bogis kauhos shawok worigunasi. ");
INSERT INTO apec_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Douk amam hatrin jurug aria hakripesh baraen douk enselahos shakripom-enyi um enyudok batowin iri. ");
INSERT INTO apec_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Aria ihishmorim arpesh shemnek enyudok baraen amam hakripeshuk um aria shakri, “O, mumam mumam namudok.” ");
INSERT INTO apec_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Aria Maria madae urkum mukwokuk um enyudok ihinyumorim baraen uwe. Okwok kanak kwape urkum apa morumen. ");
INSERT INTO apec_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Aria amam hape heyoh sipsipahos iri wata hatanam hanak. Aria amam hanadudareh um Iruhin hape hatuk ananin nyeigur nyato um enyudok amam hatrin aria hemneken kabi douk ensel nyakripomuk um. ");
INSERT INTO apec_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Aria douk Maria kwabuki Jisas aria douk hakri um 8-poreih nyumneh um, eshesh shatah ananihw yegenyihw aria shadowan nyeigur Jisas. Enyudok nyeigur douk Maria wata kupeiguk uwe aria ensel nyakripokuk um shudowan enyudok nyeigur. ");
INSERT INTO apec_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Aria Josep nani Maria shape eneh nyumneh. Eshesh shape shagipesh enyudok lo seiwok Iruhin nakoguk Moses enyi nyakrium. Eshesh shenekesh namudok um Iruhin nutrish aria nukri eshesh douk yopishi. Aria douk ehudok nyumneh hatuhuk aria Josep nani Maria sharao Jisas shanak um Jerusalem um shuko Debeinian. ");
INSERT INTO apec_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Eshesh shenekesh namudok kabi douk Debeini ananin lo nyakrium. Lo nyakri, “Ihim-morim sagomim nugamim amakenyiyu womubuki iri ta puko Debeiniam.” ");
INSERT INTO apec_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Aria eshesh shopunek douk shanak um shurao eshudok eneshenesh um shuko amam pris hunek ofamesh huko Debeini kabi ananin lo nyakrium. Aria Lo douk nyakri namudok, “Arpesh ta shirauri bioguhw armiguhw kabi douk debeibi maishub um o bioguhw yanporeiguhwi armiguhw kabi douk shokubi maishub um. Eshesh shuraeshi aria shunek ofamesh shisheh shuko eik.” ");
INSERT INTO apec_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Aria abudok nyutob, anan arman douk shahwaran um Simeon iri nape Jerusalem. Anan nagipesh lo atin iri arman aria apa nenek lotu um Iruhin. Aria anan apa nape natrugun um arman douk Iruhin nagraehan neshopokan nunakumori nunarao eshesh Israel shupe wosik iri. Aria Simeon, Iruhin ananin Mishin douk nyawishan aria nyapenyan. ");
INSERT INTO apec_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Aria enyen nyanohur nyakripan um anan ta mare arigas nugok aria ta nutik anudok arman Krais. Anudok douk Debeini nagraehan neshopokan nanakumori nunarao arpesh iri. ");
INSERT INTO apec_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Namudok aria Iruhin ananin Mishin nyohur Simeon aria nanak nawish numun narub um Iruhin ananit debeiti urupat tataoum. Aria amakenyish sharauri nuganin Jisas um shunekuman enyudok douk Iruhin ananin lo nyakrium eshesh ta shunekenyuman iri. ");
INSERT INTO apec_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","29","Aria Simeon natrishan nasuwan ananis wis aria natuk Iruhin ananin nyeigur nyato iruhw nakri, “Debeini, nyak nyagipesh baraen douk riguk nyakri adurin atin um ta ipe arigaha itrunum. Aria douk nyak nyukri wosik aria eik yasuhw nyakin mour aria eikihw apahw hwur wosik aria igok. ");
INSERT INTO apec_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Um maresh? Eik yatrun eikis nabes anudok nyakin arman douk nyagraehan nanakumori nunek enyudok mour um nunarao arpesh shupe wosik um. ");
INSERT INTO apec_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Nyak douk nyeneken ihishmorim arpesh shapeum aria shatrin. ");
INSERT INTO apec_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Aria anan douk kabi anat lait um tiyabigesh yah eshudok douk madae shudukem Iruhin iri uwe um shugipeshah. Aria ta nunek nyakish arpesh eshesh Israel shurao debeinyi nyeigur.” ");
INSERT INTO apec_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Aria Jisas ananish amakenyish shemnek namudok aria shakitak yowiyokuk um enyudok baraen douk Simeon nakriyen um Jisas iri. ");
INSERT INTO apec_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Aria Simeon narig Iruhin um nunek yopinyi um Jisas nini ananish amakenyish. Aria nakrip Maria nakri, “Mnek, Iruhin nagraeh enyudok batowin um nyunek sabaishi arpesh eshesh Israel um shukutukuk Iruhin shupeik rougun. Aria shopunek, ta nutaurum sabaishi shutanamori um Iruhin aria wata nunaraesh shutanamori shupe wosik. Anan ta nupe kabi douk anan arman douk Iruhin nakutuni um nunek ananin mour iri. Aria sabaishi arpesh ta shutrun aria shiyagwreh-uman enenyenen yoweinyi. ");
INSERT INTO apec_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Anan ta nunekesh namudok um nunek sabaishi arpesh esheship urkwip panabeshuk pape esheshiruh aparuh iri punowereh putogur yopugunum. Aria nyak Maria, nyakin mishin ta yowen abom kabi douk shaduken anat bainat tawish tabreiri nyakim urkum aria nyemnek debeiri eriger um.” ");
INSERT INTO apec_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Aria agundok onok armatok kwenenem profet iri shopunek kwape. Okwokwin nyeigur Ana, aria okwokwin yaken douk shahwaranum Fanuel. Eshesh douk apudok awiropish douk shahwarop um Asa iri. Aria okwok douk ruwogik abom. Okwok douk kwani anan shanaraum shape 7-poreish kwarahos meyoh. ");
INSERT INTO apec_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Aria eshesh shape aria anan nagokuk aria okwok kwape meyoh um, okwok kwape 84-poreish kwarahos. Aria okwok madae kukutukuk atin Iruhin ananit debeiti urupat uwe, uwok. Nyumnah wab kwape um kwenek lotu um Iruhin aria kwenek beten atin. Anabik um, okwok kwoshakwur um worigun aria kwape um kwenek beten atin. ");
INSERT INTO apec_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Aria abudok banab atub nyutob, okwok shopunek kwanaki hurukatin aria kwenek tenkyu um Iruhin. Aria kwape kwakripesh baraen um anudok nuganin Jisas ihishmorim arpesh douk shape shatrugun-uman Iruhin wata nunaki nukweshih arpesh shape Jerusalem iri douk shape shakamum kupaishi iri shutogur wosik atin um. ");
INSERT INTO apec_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Aria douk Josep iri Maria sheneken sheyaten enyudok mour kabi douk Debeini ananin lo nyakrium shuneken iri, aria eshesh wata shatanam shanak um shokugi nahobig Galili. Eshesh shanak um esheshibur wabur Nasaret. ");
INSERT INTO apec_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Aria nuganin yopun nakitak dodogowin aria narao sabainyi yopinyi saki. Aria Iruhin nutauruman meyoh nenekuman yopinyi aria nape wosik abom. ");
INSERT INTO apec_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Aria ihish kwarahos Jisas ananish amakenyish apa shanak um Jerusalem um agundok Pasovaigun worigun. ");
INSERT INTO apec_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Aria douk arigaha Jisas ananish kwarahos shanak shatogur 12-poreish aria eshesh shanak um Jereusalem um agundok Pasovaigun worigun kabi douk seiwok shape shenekesh um. ");
INSERT INTO apec_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Aria douk arigaha nyumneh shenek agundok worigun um hatuh aria eshesh wata shatanam um wabur. Douk eshesh shanak, aria nuganin Jisas napeik Jerusalem. Ananish amakenyish shopunek madae shudukemesh um agundok anan napemaguk uwe, uwok. ");
INSERT INTO apec_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Eshesh shakri anan ta nani eshudok enesh arpesh shanak. Namudok aria eshesh shanak anah nyumnah shuknih aria eshesh wata shape shauriman. Eshesh sharig esheshis wanaruh eshudok douk shape atugunum iri. ");
INSERT INTO apec_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Douk shabirak shatik madae shuparugan uwe aria wata shatanam shanak um Jerusalem um shuriman ganudok. ");
INSERT INTO apec_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Eshesh shape shauriman arigaha hakri um 3-poreih nyumneh um, eshesh shanak shaparagan nape numun narub um Iruhin ananit debeiti urupat tataoum. Anan nani henek skulumesh um lo iri hape aria nape nemnek amamin baraen aria nasorigam um hukripanum nudukemesh. ");
INSERT INTO apec_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Aria amam ihim-morim hemnekan aria hakitak yowiyokuk um ananin saki nyani baraen anan nebeyeny-umom iri. Aria amam hakri anan douk nadukemesh abom iri. ");
INSERT INTO apec_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Aria abudok nyutob ananish amakenyish shaparugan obi nyutob, eshesh shakitak yowiyokuk abom. Aria ananik amakek kwakripan kwakri, “Nuganin, nyak nyenekeshumohw mumam namudok? Nyakin yaken nani eik mishish yowesh abom um nyak aria wape waurimen.” ");
INSERT INTO apec_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Aria Jisas nawanamesh baraen nakri, “Ipak pape paurime um maresh? Ipak padukemesh aka, uwok? Eik ta ipe eikin Yain ananit urupat.” ");
INSERT INTO apec_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Aria eshesh madae shudukem baugenyum baraen anan nakripesh-enyi uwe, uwok. ");
INSERT INTO apec_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Aria anan wata nanamesh shatanam shanak um Nasaret. Aria ihih nyumneh anan nemnek esheshin baraen aria nenek eneshenesh eshesh shakripan um nunekesh iri. Aria ananik amakek kwananyur nyorumok urkum enyudok ihinyumorim baraen douk anan neyagwrehen iri. ");
INSERT INTO apec_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Aria Jisas yopun nakitak um yegenyihw aria shopunek nakitak nadukemum eneheneh yopihi aih hani saki. Aria Iruhin nani arpesh shanadudareh-uman abom. ");
INSERT INTO apec_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Abudok nyutob Taiberias Sisar nape debeini gavman um Rom um 15-poreish kwarahos obi, Pontius Pailat nape debeini gavman um shokugi nahobig Judia. Aria Herot nape debeini um shokugi nahobig Galili, aria ananin wanin Filip nape debeini um shokugi nahobig Ituria iri Trakonitis. Aria Lisanias nape debeini um shokugi nahobig Abilene iri. ");
INSERT INTO apec_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Aria Anas nani Kaiafas hape debeimi pris. Aria douk abudok nyutob, Sekaraia ananin nuganin Jon nanak nape wehigunum arpesh uwok um aria Iruhin nakripan ananin baraen. ");
INSERT INTO apec_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Namudok Jon narahaen neyatarub warub bape hurukatin um abudok worub Jordan iri. Aria anan nape nakripesh um shukeshuguk agabus yoweishi inahos shutanam shukon aparuh Iruhin aria shunek baptais. Aria Iruhin ta nukweshih esheshis yoweishi inahos. ");
INSERT INTO apec_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Enyudok douk nyatogur nyagipesh enen baraen seiwok profet Aisaia nenyemaguk Iruhin ananik Buk iri nyakrium. Baraen nyakri, “Enen arpen nyape nyahwar gani wehigunum arpesh uwok um nyakri, ‘Gabeiman yah Debeini. Pugabeyoh hupe um anan nigimah nunaki um. ");
INSERT INTO apec_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Pushuragun ihigunum nabuhum atap iri. Aria yoduduruh hani mihigas shopunek ta pukorihogas subuh atap sukuh beriyaigas. Aria pugapesh hakukotomi yeh hupe duratin hupe aria pugapesh ihihmorim yeh ba greg atin hetem. ");
INSERT INTO apec_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Aria ihishmorim arpesh ta shutik enyudok mour douk Iruhin nuneken um narap matanamori mupe wosik abom um.’” ");
INSERT INTO apec_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Aria sabaisi awirosish arpesh shanakumori Jon um nunek baptaisumesh. Eshesh shanaki aria anan nakripesh nakri, “Ipak pape kabi wanohwiguhwi yuguhw um. Omi nyakripep um ta puruwok um um namudok um ta Iruhin ananish urkum apahw ta juwehosish um ipak? Um maresh? Anan ko nenek eshudok yoweishi inahos shutogurum ipak adur atin. ");
INSERT INTO apec_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Ipak ko penek yopihi aih um puyabig arpesh shutrip aria shukri adur ipak pekeshukuk agabus yoweishi inahos. Aria mare pupe um puneyagwreh pukri Abraham anan douk ipakin yamenen aria Iruhin ta nutrip nukri wosik aka, uwok. Eik yakripep, Iruhin ta nenek abrudok utabor bakus atap iri butogur kabi Abraham ananish batowish um. ");
INSERT INTO apec_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Arman nabro rowos iri douk nasuhw enen bode nape nawanamen nabro rowos gani atap nukwaruhigos um. Aria ihigos rowos douk yopipi shuruwep madae piragosi uwe ta nubrogos nuwashagos nyih.” ");
INSERT INTO apec_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Aria ihishmorim arpesh sharigan shakri, “Aria apak ta munekesh mumam?” ");
INSERT INTO apec_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Aria anan wata nawanamesh baraen nakri, “Anudok arman douk nanabuk biyog siotog iri ta nukon anat anudok douk siot uwok iri. Aria eshudok arpesh shobuk worigun iri ta shusiyaesh shibiram eshudok worigun wokeshi.” ");
INSERT INTO apec_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Aria amam harao takis iri shopunek hanamori anan um nunek baptaisumam. Aria hanaki harig Jon hakri, “Debeini tisa, apak ta munek maresh?” ");
INSERT INTO apec_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Aria anan nakripam nakri, “Purao takis um, ipak ta putrish utabor kabi da gavman shakri um. Ipak mare putrish anabor utabor meyoh uwe, uwok.” ");
INSERT INTO apec_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Aria amam soldia shopunek hanaki aria harigan hakri, “Apak shopunek ta munek maresh?” Aria anan nakripam nakri, “Mare pusuhw dodog enesh arpesh aria putrish utabor aka penekumesh enen wehinyi baraen enesh arpesh um putrish anabor utabor meyoh uwe, uwok. Punasuhw abrudok douk shukep um mouribor um atin aria mare ta pukri anabor shopunek uwe, uwok.” ");
INSERT INTO apec_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Aria arpesh esheshish mishish shape shor shanak aria shape shere urkum um Jon. Eshesh shakri anan douk Krais douk Iruhin nagraehan ba neshopokan nanaki um nurao arpesh iri. ");
INSERT INTO apec_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Douk namudok aria Jon nakrip sabaishi arpesh nakri, “Eik uwok. Eik douk yenek baptaisumep abar meyoh. Aria anan dodogowin atun neshagrakuk eik iri ta nigigi. Aria eik douk madae yopuwe iri um ta ikweshihuman madururuh um ananin su uwe, uwok. Aria anan ta nenek baptaisumep nekep Iruhin ananin Mishin aria ta nyuwish aria nyupeyep. Aria ta nyugabeyep kabi nyih hanuguk eshudok um. ");
INSERT INTO apec_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Anan ta ko nunaki kabi da anan arman nasuhwi ananip neitip ananis wis um nunaki niyagom nyubuhas shape ananit wit iri ba nushubuk sik. Aria yoputi shuruwepit wit anan ko ta nutubuk sik gani ananit urupat nobuk wit ati. Aria ihish witish nyubuhas anan ko nushaisheh nukwu ehudok yoweihi nyih madae ta hugok iri uwe, uwok.” ");
INSERT INTO apec_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Aria Jon nakripesh Iruhin ananin yopinyi baraen obi nyutob, nakripesh sabainyi enyudokmori baraen shopunek um nuhur esheshiruh aparuh. ");
INSERT INTO apec_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Aria Jon nahao Herot douk debeini gavman um shokugi nahobig um Galili iri. Jon nahan um agundok natrun ananin wanin ananik irohukwik Herodias um. Aria shopunek um agundok nenek sabaishi yoweishi inahos um. ");
INSERT INTO apec_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Aria Herot ta shopunek nenek enesh yoweishi inahos um ta nuweshik Jon um. ");
INSERT INTO apec_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Douk sabaishi arpesh shenek baptais shatuh aria Jisas shopunek nenek baptais. Anan nenek baptais jurug aria neyotu nape nenek beten aria iruhw utag ganupok. ");
INSERT INTO apec_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Aria Iruhin ananin Mishin nyabuhi kabi da arudok armir manyun um nabuhi netem Jisas. Aria shemnek anah mah gani iruhw heven aria enyudok arpen nyeyagwreh iri nyakri, “Nyak douk adur atin Eikin Nuganin. Eik douk urkum manawasham aria yanadudareh abom um nyak.” ");
INSERT INTO apec_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Abudok nyutob Jisas nohur ananin mour nape neneken obi, ananish kwarahos douk shatogur 30-poreish. Aria arpesh shakri Jisas anan douk Josep nanabuki iri nuganin aka, uwok. Josep ananin yain douk Heli. ");
INSERT INTO apec_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Aria Heli ananin yain Matat. Matat ananin yain Livai. Livai ananin yain Melki. Melki ananin yain Janai. Janai ananin yain Josep. ");
INSERT INTO apec_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Aria Josep ananin yain Matatias. Matatias ananin yain Amos. Amos ananin yain Nahum. Nahum ananin yain Esli. Esli ananin yain Nagai. ");
INSERT INTO apec_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Aria Nagai ananin yain Mat. Mat ananin yain Matatias. Matatias ananin yain Semen. Semen ananin yain Josek. Josek ananin yain Joda. ");
INSERT INTO apec_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Aria Joda ananin yain Joanan. Joanan ananin yain Resa. Resa ananin yain Serubabel. Serubabel ananin yain Sealtiel. Sealtiel ananin yain Neri. ");
INSERT INTO apec_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Aria Neri ananin yain Melki. Melki ananin yain Adi. Adi ananin yain Kosam. Kosam ananin yain Elmadam. Elmadam ananin yain Er. ");
INSERT INTO apec_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Aria Er ananin yain Josua. Josua ananin yain Elieser. Elieser ananin yain Jorim. Jorim ananin yain Matat. Matat ananin yain Livai. ");
INSERT INTO apec_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Aria Livai ananin yain Simeon. Simeon ananin yain Juda. Juda ananin yain Josep. Josep ananin yain Jonam. Jonam ananin yain Eliakim. ");
INSERT INTO apec_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Aria Eliakim ananin yain Melea. Melea ananin yain Mena. Mena ananin yain Matata. Matata ananin yain Natan. Natan ananin yain Devit. ");
INSERT INTO apec_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Aria Devit ananin yain Jesi. Jesi ananin yain Obet. Obet ananin yain Boas. Boas ananin yain Salmon. Salmon ananin yain Nason. ");
INSERT INTO apec_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Aria Nason ananin yain Aminadap. Aminadap ananin yain Atmin. Atmin ananin yain Arni. Arni ananin yain Hesron. Hesron ananin yain Peres. Peres ananin yain Juda. ");
INSERT INTO apec_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Aria Juda ananin yain Jekop. Jekop ananin yain Aisak. Aisak ananin yain Abraham. Abraham ananin yain Tera. Tera ananin yain Nahor. ");
INSERT INTO apec_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Aria Nahor ananin yain Seruk. Seruk ananin yain Reu. Reu ananin yain Pelek. Pelek ananin yain Eber. Eber ananin yain Sela. ");
INSERT INTO apec_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Aria Sela ananin yain Kainan. Kainan ananin yain Arpaksat. Arpaksat ananin yain Siem. Siem ananin yain Noa. Noa ananin yain Lamek. ");
INSERT INTO apec_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Aria Lamek ananin yain Metusela. Metusela ananin yain Enok. Enok ananin yain Jaret. Jaret ananin yain Mahalalel. Mahalalel ananin yain Kenan. ");
INSERT INTO apec_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Aria Kenan ananin yain Enos. Enos ananin yain Set. Set ananin yain Adam. Aria Adam douk Iruhin nenekan. ");
INSERT INTO apec_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Aria Iruhin ananin Mishin nyawish Jisas nyapenyan abom aria nagipesh um enyenyim urkum nakutukuk worub Jordan aria nanak. Aria Iruhin ananin Mishin nyaran nyanam wehigunum douk arpesh uwok um. ");
INSERT INTO apec_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Anan nanak nape agundok um 40-poreih nyumneh shopunek. Aria Satan nape nakwiraehan um nunek yoweishi inahos. Aria ehudok nyumneh nanak nape iri, anan madae nuwok anagun worigun uwe, uwok. Aria douk arigaha ehudok nyumneh hanak hatuh aria debeirubi nyurub ban. ");
INSERT INTO apec_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Aria Satan nakripan nakri, “Nyak douk Iruhin ananin Nuganin um, nyak krip amudok utom mutogur bret.” ");
INSERT INTO apec_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Aria Jisas nakripan nakri, “Baraen nyetem Iruhin ananik Buk iri douk nyakri, ‘Worigun atugun ta mare nutaurum arpesh um shupe wosik atin uwe, uwok.’” ");
INSERT INTO apec_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Aria Satan wata narao Jisas natoum anabik aria ahudok atuh neyabigan ihigos nahobigos sape agundok atap iri. ");
INSERT INTO apec_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Aria Satan nakripan nakri, “Eik ta iken agusudok ihigos nahobigos suni enesh yopishi eshudok eneshenesh shuni arpesh shape agudok nahobig iri. Aria nyak ta nyurao big um nyak atin nyeyoh ihishmorim shuni eneshenesh eshudok arpesh shape ihigos nahobigos iri. Aria ihish atin um eshudok. Douk seiwok yaraesh yeyohesh iri. Aria douk eik ikri iko enen arpen um, eik ta ikenyesh. ");
INSERT INTO apec_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Aria ta douk nyak nyuduk ohrubus nyunek lotume um, eik ta iken ihishmorim eshudok eneshenesh.” ");
INSERT INTO apec_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Aria Jisas wata nakripan nakri, “Baraen nyetem Iruhin ananik Buk iri douk nyakri namudok, ‘Nyak nyunek lotu um Debeini atin nyakin Iruhin aria nyusuhw ananin atin mour.’” ");
INSERT INTO apec_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Aria Satan ta naran um Jerusalem. Aria nakih nonem um onok kwato abom iri outuk atudok Iruhin ananit debeiti urupat aria nakripan nakri, “Ta nyak douk Iruhin ananin nuganin um, nyak nyaprok nyubuh atap. ");
INSERT INTO apec_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Um maresh? Baraen nyetem Iruhin ananik Buk iri douk nyakri, ‘Iruhin ta nukripesh dodogowinyi baraen um ananish enselahos um shunaki shutaurumen. ");
INSERT INTO apec_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Aria eshesh ta shejemen shusuwenyukuk iruhw esheshis wis aria ta anam utom mare muwor nyakiruh yeriweruh uwe, uwok.’” ");
INSERT INTO apec_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Aria Jisas nakripan nakri, “Baraen nyetem Iruhin ananik Buk iri nyakri, ‘Nyak mare nyukwiraeh um nyusuwokuk Debeini, nyakin Iruhin uwe, uwok.’” ");
INSERT INTO apec_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Douk Satan nakwiraeh Jisas um sabaihi yeh um nunek yoweishi inahos ba jurug aria nakutunukuk nanak. Anan nakri kupaibi nyutob aria anan ta nukwiraehan. ");
INSERT INTO apec_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Aria Iruhin ananin Mishin nyape Jisas nyenek anan dodogowin aria wata natanam nanak um shokugi nahobig Galili. Aria baraen nyanak sabaigun um agudok shokugi nahobig um enyudok Jisas neneken iri. ");
INSERT INTO apec_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Aria anan nenek skulumesh numun urusag eshesh Juda shape sheneyagwreh baraen-ogwi aria sabaishi shatuk ananin nyeigur nyato iruhw. ");
INSERT INTO apec_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Aria Jisas nanam abrudok wabur Nasaret douk anan wata napenyabur arigah arigah ba yopun um. Aria ahudok nyumnah Sabat eshesh Juda mour uwok shape meyoh ahi hatogur. Aria anan nakitak nanak nawish eshesh Juda shape sheneyagwreh baraen-ati iri urupat douk ihih nyumneh Sabat nape nanak um. Aria nakitak neyotu um nutarih Iruhin ananin baraen. ");
INSERT INTO apec_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","18","Aria habuk onok buk douk shadareshok aria shaweshigok iri. Okwok douk profet Aisaia nenyemok iri. Aria anan napukok aria naparug enen baraen nyakri namudok, “Debeini ananin Mishin nyawishe aria nyapenye. Um maresh? Anan nagraehe neshopoke yanaki um ikripesh yopinyi baraen um yaruhish arpesh iri. Aria douk neshopoke yanamori ikripesh enyudok baraen, ‘Ipak douk horim howeshikep pape shunuweshik-ati urupat iri wata putogur pupe wosik atin. Ipak nabes seshukepi wata putrugun. Aria ikripesh um eshudok arpesh douk kupaishi shekesh amaen iri wata shupe wosik ba shunadudareh. ");
INSERT INTO apec_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Aria shopunek, neshopoke yanamori ikripesh baraen um abudok yopubi nyutob douk Debeini ta wata nutaurum ananish arpesh shupe wosik um.’” ");
INSERT INTO apec_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Aria Jisas natarih enyudok baraen um jurug aria wata nuwapam buk nakanokuk um anudok neyoh lotu iri. Aria anan wata nanak nabuh nape. Aria eshesh ihishmorim shape numun urupat iri shawanam nabes shape shashakam anan atun. ");
INSERT INTO apec_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Aria anan nakripesh nakri, “Douk enyudok Iruhin ananin baraen nyetem okwudok Buk iri douk iganigadae pemneken yatarihen iri nyatogur um adurin atin.” ");
INSERT INTO apec_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Aria eshesh ihishmorim shanadudareh shatuk ananin nyeigur nyato iruhw. Aria eshesh shape urkwip por panak um enyudok yopinyi baraen anan nakriyenyi. Aria eshesh shakri, “Mumam mumam namudok. Aria anudok arman anan douk Josep ananin nuganin aka, uwok?” ");
INSERT INTO apec_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Aria Jisas nakripesh nakri, “Adurigom atin ipak ta pukripe enyudok shadukemen iri baraen pukri, ‘Dokta, nyak nyugabe nyak kanak. Enyudok douk shakripap um nyenekesh shatogur Kaperneam iri shopunek makri nyunekesh shutogur agundok nyakibur wabur.’” ");
INSERT INTO apec_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Aria Jisas ta nakri, “Adurigom atin eik yakripep. Ta anan profet nikripesh baraen ananibur wabur aria shumnek ananin baraen shugipeshen uwe aka, uwok. ");
INSERT INTO apec_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Adur atin eik yakripep. Seiwok abudok nyutob Ilaija nape profet obi, sabaiwari armago douk armam hagok aria howosopuk iri wape Israel. Aria abudok nyutob eshah madae anah hurauri um 3-poreish kwarahos aria 6-poreib aub shopunek. Aria debeirubi nyurub baesh um ihirub warub. ");
INSERT INTO apec_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Aria Iruhin madae neshopok Elaija nunak nutaurum onok Israel douk armam hagok ba hokusapukuk iri uwe, uwok. Iruhin douk neshopok anan nanak nataurum onok armatok douk anan nagok nakusopukuk iri douk kwape kupaiburi wabur shahwarabur um Sarefat iri. Abrudok wabur Sarefat douk bape shokugi nahobig Saidon. ");
INSERT INTO apec_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Aria douk namudok atin. Abudok nyutob profet Elisa nape agudok atapig nahobig obi, sabaimi armam lepraih arugeh hapenyam iri hape Israel. Aria Elisa madae nunak nutaurumam ba nenek anan um yopun uwe, uwok. Aria adur atin anan nataurum Naman atun. Naman douk kupaibi amnabin shahwarab um Siria iri.” ");
INSERT INTO apec_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Aria ihishmorim arpesh shape numun urupat iri shemnek enyudok baraen aria mishish juwehosish abom um Jisas. ");
INSERT INTO apec_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Aria eshesh shakitak sharan shanak shatogur aduk um abrudok wabur. Abrudok esheshibur wabur douk batem iruhw anag mihig. Namudok aria shanak anagasibur um natogur nyape um shakri shuwashan nubuh um nugok. ");
INSERT INTO apec_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Aria eshesh sheyotu aria nawishesh nanak orokohun aria nanak. ");
INSERT INTO apec_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Aria Jisas nanam wabur Kaperneam douk bape shokugi nahobig Galili iri. Anan nanak natogur aria ahudok nyumnah Sabat eshesh Juda mour uwok, shape meyoh ahi, hatogur. Aria anan nape nenek skulumesh um Iruhin ananin baraen. ");
INSERT INTO apec_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Aria eshesh ihishmorim shemnek aria shakitak yowiyokuk. Um maresh? Douk neyagwreh dodogowin atin baraen kabi douk sharao debeinyi big iri sheneyagwreh um. ");
INSERT INTO apec_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","34","Aria numun eshesh Juda shape sheneyagwreh baraen-ati urupat, anan arman enen yoweinyi sagab nyapenyan iri arman nape. Aria anan nakitak nahwar debeg nakri, “A! Jisas douk nyanaki wabur Nasaret iri, nyak nyanamori nyunekap mumam apak? Nyak nyakrium nyop nyununup, aka? Eik douk yadukem nyak. Nyak douk Iruhin ananin yopuyopunari arman nyarauri ananin baraen iri.” ");
INSERT INTO apec_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Aria Jisas naho enyudok sagab nakri, “Mokureg aria nyukutukuk anudok arman aria nyutograri.” Aria enyen nyour anudok arman nabuh nakus atap agundok shapeum aria nyakutunaguk. Aria madae nyenekan eneb ereb anan uwe, uwok. ");
INSERT INTO apec_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Aria douk ihishmorim eshesh shatik namudok aria shanaboum roguhw. Aria eshesh sheneyagwreh shakri, “Enyudok maren baraen? Anudok arman douk anan dodogowin narao debeinyi big um. Anan douk naho yoweishi sagabehos aria shemnek ananin baraen aria shakutukuk arpesh shatogur sharuwok!” ");
INSERT INTO apec_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Namudok aria baraen um enyudok Jisas neneken iri nyanak ihirub warub douk bape hurukatin um Kaperneam iri. ");
INSERT INTO apec_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Aria Jisas nakutukuk atudok eshesh Juda shape sheneyagwreh baraen ati urupat aria nanam Saimon ananit urupat. Aria Saimon ananik nakwurikwik kwaraubor abom krukruk kweshuhw aras. Douk Jisas nanak aria eshesh shakripan um nunak nugabeyok. ");
INSERT INTO apec_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Aria anan nanak neyotu hurukatin um agundok okwok kweshuhw um aria naho ehudok arugeh hanegok iri. Aria okwok yopuk abom aria kwakitak kwape kwonekumam worigun. ");
INSERT INTO apec_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Aria abudok nyutob aun nape nabuh, eneheneh arugeh hapeyesh iri arpesh esheshish worogwiruh sharaesh shanamori Jisas um nugabeyesh. Aria anan nowemesh ananis wis um eshesh atin atin aria ihishmorim shatogur yopish atish. ");
INSERT INTO apec_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Yoweishi sagabehos shopunek shakutukuk sabaishi arpesh. Aria eshudok sagabehos shopunek shahwar debeg shakri, “Nyak douk Iruhin ananin nuganin.” Aria Jisas nahaesh aria nakripesh um mare shiyagwreh enen baraen uwe, uwok. Um maresh, eshesh douk shadukemesh shakri anan douk Krais douk Iruhin nagraehan neshopokan nanamori nurao arpesh iri. ");
INSERT INTO apec_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Arigaha ruwahepih ruhur atur um aria Jisas nakitak nakutukuk Kaperneam nanam anagun wehigunum arpesh uwok um. Aria eshesh arpesh shape shaurim anan. Aria douk arigaha shanak shoparug anan aria shakri shusuhweshan um anan mare nukutishuk ba nunak. ");
INSERT INTO apec_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Aria anan nakripesh nakri, “Eik ta ko inak kupairubi warub shopunek aria ikripesh yopinyi baraen um arpesh shuwish um agundok Iruhin nape Debeini um ananish arpesh um. Um maresh? Iruhin douk neshopoke yanamori inak ikrip kupaishi shopunek.” ");
INSERT INTO apec_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Aria anan nanak nape nakripesh Iruhin ananin yopinyi baraen ihirub warub agudok shokugi nahobig Judia. Anan nape nakripesh Iruhin ananin yopunyi baraen numun urusag um eshesh Juda shape sheneyagwreh baraen-ogwi. ");
INSERT INTO apec_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Anah nyumnah Jisas nanak neyotu anagas um agudok debeigi waiyag Genesaret aria nape nakripesh Iruhin ananin baraen. Aria sabaishi arpesh shape shanaki sharukaruban shanaki hurukatin um anan um shumnek baraen anan nape nakripesh-enyi. ");
INSERT INTO apec_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Aria agundok, anan natik amudok hape hatuk eiguhw iri amamig biyog botog gwakus. Amam hanukog hakih hagubukuk anagas aria hanak hape hakwrup umbenab. ");
INSERT INTO apec_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Aria Jisas nato nakih netem Saimon ananit bot. Aria nakripan um neheshigat tanak tur abar aria nape nenek skulumesh um Iruhin ananin baraen eshesh armam armago. ");
INSERT INTO apec_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Douk nakripesh baraen jurug aria nakrip Saimon nakri, “Nyak nyurao bot tunak orokohunig um debeigi waiyag aria ipak pukutu ipakib umbenab aria putuk anaguh eiguhw.” ");
INSERT INTO apec_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Aria Saimon nakripan nakri, “Debeini, iganigib wab shuknib apak munek debeinyi mour um makutu umbenab aria apak madae mutuk anar atur eyur uwe, uwok. Aria douk nyak nyakri aria eik ta ikutu umbenab bubuh.” ");
INSERT INTO apec_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Aria amam hanak hakutu umbenab aria hatuk sabaiguhwi eiguhw aria amamib umbenab hurukatin um tutukurab atin. ");
INSERT INTO apec_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Aria amudok douk hani Pita hape ananit bot iri hatik namudok aria hawaurum kupaimi douk hape kupaiti bot iri um hunaki hutaurumam. Aria amam hanaki hataurumam hatukoguhw haguhur amamig biyog botog shishuknig aria hurukatin um gubuhuk debeigi waiyag atin. ");
INSERT INTO apec_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","10","Aria Saimon douk kupainyi nyeigur um nanahwar Pita nani anam ananim biom douk Jems aria Jon amudok Sebedi ananim nugamim, hatik ogwuhwudok sabaiguhwi eiguhw amam hatukoguhw iri aria amam hakitak yowiyokuk aria hanogugur. Aria Saimon natik namudok aria nabuh noduk ohrubus hurukatin um Jisas aria nakripan nakri, “Debeini, nyak nyukutukuk eik aria nyunak! Um maresh? Eik yenek eneshenesh yoweishi inahos iri!” Aria Jisas nakripan nakri, “Saimon, nyak mare nyunogugur. Um maresh? Douk arigaha kweipon, nyak ta nyupe nyurao arpesh shunaki shugipesh eik.” ");
INSERT INTO apec_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Aria amam hanuk amamig botog hakih hagubukuk anagas, hakutukuk ihishmorim amamish eshudok eneshenesh aria hani Jisas hanak. ");
INSERT INTO apec_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Anah nyumnah Jisas nanak nape anabur wabur aria anan arugeh lepra hapenyani nanaki natogruman. Ananihw yegenyihw douk shuknihw abom um ereb. Aria anan nanak nabuh noduk ohrubus nakus atap aria narig Jisas nakri, “Debeini, nyak nyukri wosik um, eik yakri nyak nyugabeye.” ");
INSERT INTO apec_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Aria Jisas nonu rogur nowem ananis wis anudok arman aria nakri, “Eik yakri wosik um. Nyak yopin abom.” Aria ahudok atuh anan yopun. ");
INSERT INTO apec_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Aria Jisas nakripan dodogowinyi baraen nakri, “Nyak nyunak aria mare nyukrip enesh arpesh um agundok eik yagabeyen um uwe, uwok. Nyak nyunak arigas um pris nutrin aria nyunak nyenek enyudok ofa um agundok nyak yopin um kabi douk Iruhin ananin lo douk nakoguk Moses iri nyakrium. Nyak nyunekesh namudok aria ihishmorim arpesh ta shutrin aria shudukemesh shukri nyak douk yopin.” ");
INSERT INTO apec_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Aria uwok, enyudok baraen um agundok Jisas nagabe anudok arugeh lepra hapenyan um nyowe nyanak rougun. Aria sabaishi arpesh shanaki um shumnek Jisas ananin baraen. Aria shopunek um nugabemesh esheshih arugeh douk hapenyesh iri. ");
INSERT INTO apec_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Aria ihih anan apa nakitak nanak agundok arpesh uwok um aria nanak nape nenek beten. ");
INSERT INTO apec_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Anah nyumnah Jisas nanak nape nenek skulumesh um Iruhin ananin baraen. Aria agundok, anam Farisi hani anam henek skulumesh um lo iri shopunek hanaki hape. Amam douk hanaki kupakupairubi warub iri. Anam hanaki Jerusalem iri, aria anam hanaki ihirubmorim warub bape agudok shokugi nahobig Galili iri, aria anam hanaki ihirubmorim warub douk bape Judia iri. Aria abudok nyutob Iruhin nani Jisas napeum nunek Jisas dodogowin um nugabe arpesh arugeh hapeyesh iri. ");
INSERT INTO apec_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Aria anam armam hasahi anan roguhw aiyas shagokan iri hanaki. Anan neshuh ananis aras aria amam hanasahumori aras hanaki hakri hunak huwish hunabuk agundok Jisas napeum. ");
INSERT INTO apec_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Aria sabaishi arpesh shape aria amam yah uwok um hishagrakesh huwish um. Aria amam hanasah hato hakih modukwitam urupat aria haniguk enesh eshudok shetem modukwitam iri heshubukuk aria anan norum aras hanotugon hakwu madururuh aria hakutun nabuhukuk um Jisas. Ihishmorim arpesh shani Jisas shape shersharih aria amam hakutun nabuh nakus orokohun hurukatin um Jisas napeum. ");
INSERT INTO apec_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Aria douk Jisas natik namudok um amam hakri abom um anan douk dodogowin um nugabeyan, aria anan nakrip anudok roguhw aiyas shagokan iri nakri, “Arpenyin, Iruhin nakweshih nyakish yoweishi inahos.” ");
INSERT INTO apec_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Aria amam henek skulumesh um lo iri hani amam Farisi hape hansarigum hakri, “Anan douk maran arman aria douk nape nabubunim Iruhin? Apak madukemesh um Iruhin atun ta nukweshih arpeshish yoweishi inahos.” ");
INSERT INTO apec_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Aria Jisas nadukem amamip urkwip aria nakripam, “Ipak urkwip mare pur namudok uwe, uwok. ");
INSERT INTO apec_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Enyudok mour douk shopunek um kabi douk eik ikrip enen arpen um Iruhin ta nukweshih enyenyish yoweishi inahos um o, ikripen um nyukitak nyunak aria enyen ta nyukitak nyunak um. ");
INSERT INTO apec_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Aria douk eik ta iyabigep um eik Anudok Arman douk yatogur adurinyi arpen iri douk dodogoiwe. Aria eik douk nyeigur nyato agundok atap um ikri Iruhin ta nukweshih arpesh shenekesh iri yoweishi inahos.” Aria anan nakrip anudok roguhw aiyas shagokan iri nakri, “Eik yakripen, nyak kakitak hur nyakis aras nyunosuwas aria nyunak um urupat!” ");
INSERT INTO apec_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Aria ahudok atuh eshudok ihishmorim arpesh douk shape shersharih iri shatrun um nakitak nohur ananis aras nasuwas aria nape nanadudareh natuk Iruhin ananin nyeigur nyato aria napa nanak um urupat. ");
INSERT INTO apec_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Aria eshesh ihishmorim shakitak yowiyokuk abom. Aria shopunek, eshesh shanogugur aria shatuk Iruhin ananin nyeigur nyato shakri, “Doukih nyumnah apak matik enesh kupaishi eshudok!” ");
INSERT INTO apec_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Douk enyudok nyanakuk aria Jisas nakitak nanak aria natik anan arman nyeigurinum Livai douk nape narao takis iri nape. Anan nape urupat anan nape narao takis atari iri. Aria douk Jisas natrun aria nakripan, “Nyak yowi nyugipesh eik unak.” ");
INSERT INTO apec_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Aria Livai nakitak nakutukuk eneshenesh ananish eshudok aria nani anan hanak. ");
INSERT INTO apec_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Aria douk arigaha anob nyutob aria Livai nakitak nenek anagun debeguni worigun ananit urupat um Jisas. Aria sabaimi harao takis iri hani enesh hwarohwish arpesh shopunek shanak shapeum shuni Livai nini Jisas shuwok agundok worigun. ");
INSERT INTO apec_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Aria anam Farisi hani anam henek skulumesh um lo iri, douk haniguk amudok Farisi iri hanaki hape. Aria amam hape henekam baraen Jisas ananim disaipel aria harigam hakri, “Ipak pani anam pawok worigun amudok harao takis iri hani eshudok shenek eneshenesh yoweishi inahos iri?” ");
INSERT INTO apec_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Aria Jisas nakri, “Arpesh douk arugeh uwok iri ta mare shunak um dokta um nugabeyesh uwe, uwok. Eshudok douk sharao arugeh iri atish ta shunak um dokta um nugabeyesh. ");
INSERT INTO apec_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Aria eik douk namudok atin kabi douk dokta um. Eik douk madae inakumori ihwar yopishi arpesh shenek yopihi aih iri shatanam um shukon aparuh Iruhin uwe, uwok. Eik yanakumori ihwar eshudok douk shenek yoweishi inahos iri um shukeshuk agabus yoweishi inahos aria shatanam shukon aparuh Iruhin.” ");
INSERT INTO apec_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Aria enesh arpesh shakrip Jisas shakri, “Sabaihi nyumneh Jon ananim disaipel hape henek beten obi nyutob, amam hashakur um amam mare huwok anagun worigun. Aria amam Farisi amamim disaipel shopunek douk henekesh namudok atin. Aria sabaihi nyumneh nyakim madae hunekesh namudok uwe, uwok.” ");
INSERT INTO apec_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Aria Jisas nakripesh enyudok wobuwobren baraen nakri, “Ipak pakri abudok nyutob anudok douk kadak narao armatok iri nini ananishi nupe um, eshesh ta shushakur um worigun aria shupe meyoh aka, uwok? Adur atin ta uwok. ");
INSERT INTO apec_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Douk nyutob ta bunaki um shuran shunak kupaigunum aria abudok nyutob ananishi ta urkwip purum anan aria ta shushakur um worigun shupe meyoh.” ");
INSERT INTO apec_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Aria Jisas nakripesh enyudok wobuwobren baraen shopunek nakri, “Ta mare enen arpen nyutupok anap rupahip anah namuhi rupah aria nyutapeyop um anah jugwaihi uwe, uwok. Enyen nyunekesh namudok akure, enyen ta nyunek umunihw ahudok namuhi rupah. Aria shopunek, ta nyukwropop um aria ta mare pupe wosik ahudok jugwaihi rupah, uwok.” ");
INSERT INTO apec_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Aria Jisas nakripesh enyudok wobuwobren baraen shopunek nakri, “Aria shopunek, ta mare enen arpen nyurak anabar namubari wainibar abar bubuh anap jugwaipi memeip munuhwip douk shape shor wainibar abar um uwe, uwok. Enyen nyunekesh namudok akure, abrudok namubari wainibar ta bubrigesh apudok jugwaipi munuhwip aria wain ta nutourakuk atap atin. Aria apudok munuhwip ta yowep. ");
INSERT INTO apec_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Aria namudok ta uwok. Namubari wainibar abar ta shisharabar namusi atus munuhwis. ");
INSERT INTO apec_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Aria shopunek, ta mare enen arpen nyukri nyuwok rigibar wainibar abar burik aria wata nyukri nyuwok namubari bugiguk uwe, uwok. Um maresh? Enyen nyakri abrudok jugwaibari abar douk yopubari.” ");
INSERT INTO apec_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Anah nyumnah Sabat, Jisas nakitak nawish nanak anag nubarig douk shau wit agari. Aria ananim disaipel hanak hape hopirak anat urubit wit aria hape hamaprut wis um haworishat hatoh. ");
INSERT INTO apec_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Aria amam Farisi harigani hakri, “Ipak peneken um enyudok? Apakin lo douk nyakri apak mare munek enen mour ahudok nyumnah Sabat!” ");
INSERT INTO apec_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Aria Jisas nakripam nakri, “Ipak patarih baraen nyetem Iruhin ananik Buk iri um abudok nyutob Devit nani ananim nyurub bamum aka, uwok? ");
INSERT INTO apec_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Devit douk nawish Iruhin ananit debeiti urupat aria nohuri atudok bret douk henek ofa hako Iruhin iri. Aria anan nawok anat aria nakom anat ananim arman hatoh. Aria shopunek, apakin lo douk nyakri mare enesh meishi arpesh shuwok atudok bret uwe, uwok. Amam pris atum, wosik.” ");
INSERT INTO apec_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Aria Jisas wata shopunek nakripam nakri, “Douk eik Anudok Arman douk yatogur adurinyi arpen iri debeiwe iri aria ikrip arpesh um shunek mour ahudok nyumnah Sabat um. Umum maresh? Eik yeyoh ahudok nyumnah sabatih.” ");
INSERT INTO apec_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Kupaihi nyumnah Sabat, Jisas nanak nawish anat eshesh Juda shape sheneyagwreh baraen-ati urupat aria nape nenek skulumesh um Iruhin ananin baraen. Aria agundok anan arman douk ananin yopunyi rogur douk yowen iri nanaki nanamesh nape. ");
INSERT INTO apec_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Aria anam henek skulumesh um lo iri hani amam Farisi hape duk atin hatik Jisas um hakri kadak nukri nubrig enyudok lo um nugabe anudok rogur yowenyanari ahudok nyumnah Sabat um, aria amam hunek kwotuman. ");
INSERT INTO apec_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Aria Jisas nadukem amamip urkwip aria nakrip anudok rogur yowenyanari nakri, “Kitak nyiyotu agundok um eshudok ihishmorim shutrin.” Aria anan nakitak nanak neyotu orokohun. ");
INSERT INTO apec_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Aria Jisas nakripam nakri, “Eik yakri isorikep, apakin lo nyakri ta apak munek maresh ahudok nyumnah Sabat? Apak munek yopunyi mugu o munek yoweishi inahos? Mutaurum arpesh shupe wosik aka, uwok o mesh shugok?” ");
INSERT INTO apec_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Aria Jisas neyotu natrish atin atin arigaha neyatesh aria nakrip anudok rogur nyenekan iri nakri, “Nu nyakin rogur.” Aria anan nonu rogur aria enyen yopin abom. ");
INSERT INTO apec_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Aria amudok henek skulumesh um lo iri hani amudok Farisi hatik namudok aria amam nyirub juwehosirub abom um Jisas. Aria amam kanak hape haneyagwrah hakri, “Apak ta muneken mumam anudok arman?” ");
INSERT INTO apec_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Aria anah nyumnah Jisas nato anag mihig um nunak nunek beten. Aria agundok anan nanak nape nenek beten um Iruhin anab wab shuknib. ");
INSERT INTO apec_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Douk nenek beten arigaha gagruk aria nahwar ihim-morim ananim disaipel hanak. Aria anan nagraeh 12-poreim atin um nishopokam hunak hukripesh ananin baraen iri aria nodowom nyeigur aposel. ");
INSERT INTO apec_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Anan nagraeh Saimon, douk Jisas nodowon kupainyi nyeigur Pita iri nani ananin wanin Andru, hani Jems iri Jon. Amam hani Filip iri Bartolomyu. ");
INSERT INTO apec_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Hani Matyu nani Tomas iri kupaini Jems, anan douk Alfius ananin nuganin, hani kupaini Saimon douk neir anap awirop shahwaresh um Selotiri. ");
INSERT INTO apec_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Amam hani Judas douk kupaini Jems ananin nuganin nani kupaini Judas douk shahwaran um Judas Iskariot iri. Anudok Judas douk ta niyabig Jisas ananim horim um Jisas iri. ");
INSERT INTO apec_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Douk enyudok nyanakuk aria Jisas nani ananim disaipel habuhi habuh heyotu anabik beriyaigunum aria sabaishi arpesh shanaki. Enesh douk shagipesh anan iri shani enesh shanaki sabairubi shokurubi warub douk bape shokugi nahobig Judia iri. Enesh shanaki Jerusalem, enesh shanaki arbudok shokurubi warub douk bape hurukatin um debeigwi youg iri. Anarub douk bape hurukatin um arbudok debeirubi warub Tair aria Saidon. ");
INSERT INTO apec_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Eshesh shanakumori shumnek ananin baraen aria shopunek um nugabemesh eshudok douk sharao arugeh iri. Enesh douk yoweishi sagabehos shapenyesh iri shopunek shanaki aria Jisas nagabeyesh. ");
INSERT INTO apec_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Aria ihishmorim arpesh shakri anan douk dodogowini. Douk namudok aria eshesh shakri ta eshesh shunak shususuwan meyoh um, eshesh ta wata yopish. Aria eshesh shanak shasusuwan aria eshesh wata yopish. ");
INSERT INTO apec_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Aria Jisas natanam natik ananim disaipel aria nakripam nakri, “Ipak douk yaruhish um eshudok eneshenesh iri douk pawish agundok Iruhin nape Debeini um ananish arpesh um! Douk namudok aria ipak douk panadudareh. ");
INSERT INTO apec_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Aria ipak douk nyurub baep iri douk panadudareh. Um maresh? Iruhin ta nukep worigun pugnoh aria wata dugurep! Aria ipak douk pape poreh iri douk panadudareh. Um maresh? Anah nyumnah ipak ta wata pugukoruh. ");
INSERT INTO apec_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Aria ipak douk arpesh shutripum agundok pagipesh eik Anudok Arman douk adurinyi arpen iri aria shunowisep shutripukuk yoweisi nabes um, ipak douk panadudareh. ");
INSERT INTO apec_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Ipak ta punadudareh pubouk ganiganiguk abom um abudok nyutob eshesh shunekesh-umep namudok um. Um maresh? Ipakish yopishi eshudok douk shakusumep iruhw heven. Seiwok esheshish popehesh yamehesh shopunek douk shenekesh-umam namudok atin amam seiwokimi profet. ");
INSERT INTO apec_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“Aria ipak douk pogrem sabaishi eshudok iri eik yakri gihaumep. Um maresh? Yopishi abudok amnabish eshudok ipak panadudareh-umesh ipak paraesh douk. Kweipon ipak ta pumnek debeiri eriger. ");
INSERT INTO apec_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Eik yakana gihaum ipak douk pawok worigun dugarep iri. Um maresh? Ipak ta wata nyurub bep. Aria kweipon ipak ta pumnek debeiri eriger um debeirubi nyurub bep! Aria eik yakana gihaum ipak douk pape panagukoruh iri. Um maresh? Ipakiruh aparuh ta wata yoweruh aria pureh debeg abom. Aria kweipon ipak ta pumnek debeiri eriger um pureh yowiyokuk. ");
INSERT INTO apec_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Aria eik yakana gihaum ipak douk ihishmorim arpesh shatuk ipakish nyeiguhw shakri ipak yopipari abom iri. Ipak ta pumnek aria gamo pudukem amaen douk ta nyutogrumep iri. Kweipon ipak ta pumnek debeiri eriger. Um maresh? Seiwok esheshish popehesh yamehesh douk shenekesh namudok atin abom um shatuk amudok henek rohwumesh iri profet amamish nyeiguhw shato iruhw.” ");
INSERT INTO apec_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Aria Jisas apa nakripesh baraen nakri, “Aria eik yakrip ipak douk pemnek eikin baraen iri. Ipak urkum apahw ta punawasham abom um ipakim horim aria punek yopihi aih um eshudok douk shutripukuk yoweisi nabes iri. ");
INSERT INTO apec_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Aria punek beten um Iruhin um nunekumesh yopihi aih um eshudok douk shenek yoweihi aih um ipak aria shukri iruhw um shukri enen amaen nyutogrumep iri. Aria punek beten um Iruhin um nutaurum eshudok douk shep shanumugep iri. ");
INSERT INTO apec_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Aria ta enen arpen nyukri nyubo wobresh popaeshohos um, nyak ta nyutanam nyuken wobresh nyesh shopunek. Aria enen arpen nyukri nyunatrin nyakit saket um, nyak nyuken nyakit siot shopunek. ");
INSERT INTO apec_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Aria ta enesh arpesh shusuwep um pukesh enesh eshudok eneshenesh um, ipak ta pukeshesh. Aria shopunek, ta enen arpen nyutrin nyunohur enesh eshudok um, nyak mare wata nyunak nyusuwen aria ta nyutrinyesh uwe, uwok. ");
INSERT INTO apec_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Ehudok aih douk ipak pakri arpesh shunekeh um ipak iri, ipak shopunek ta punek ehudok atih aih um eshesh. ");
INSERT INTO apec_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Aria ipak urkum apahw shunawasham eshudok douk eshesh urkum apahw shunawasham ipak iri atishi um, ipak ta omi nyutuk ipakish nyeiguhw shuto iruhw? Adur atin ta uwok. Shenek eneshenesh yoweishi inahos iri shopunek apa urkum apahw shanawasham eshudok douk eshesh urkum apahw shanawasham eshesh iri atish! ");
INSERT INTO apec_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Aria ta ipak punek yopihi aih um eshudok douk shenek yopihi aih um ipak iri atish um, ipak ta omi nyutuk ipakish nyeiguhw shuto iruhw? Adur atin ta uwok. Shenek eneshenesh yoweishi inahos iri shopunek apa shenekesh namudok atin! ");
INSERT INTO apec_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Aria ta pukesh eshudok arpesh douk padukemesh um ta wata shubeyeshumep iri atish um, ipak ta omi nyutuk ipakish nyeiguhw shuto iruhw? Adur atin ta uwok. Shenek eneshenesh yoweishi inahos iri arpesh shopunek apa shenekesh namudok atin! ");
INSERT INTO apec_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Aria namudok ta uwok! Ipak ta urkum apahw punawasham ipakish horik horin aria punek yopihi aih um eshesh. Aria pukesh eshudok aria mare punek urkum um eshesh wata shukepeshi eshudok uwe, uwok. Ipak punekesh namudok aria anah nyumnah Iruhin ta nunekumep sabaishi abom eshudok yopishi eneshenesh gani iruhw heven. Aria shopunek, ipak ta putogur Debeini Iruhin nape iruhw iri ananish batowish. Um maresh? Anan douk yopunum eshudok douk mare shunek tenkyuman iri uwe, shani eshudok douk shenek yoweishi inahos iri aria nataurumesh. ");
INSERT INTO apec_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Ipakin Yaken apa nenek gihaum eshudok douk shenek yoweishi inahos iri aria nataurumesh. Douk namudok aria ipak shopunek ta punekesh namudok atin.” ");
INSERT INTO apec_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Aria Jisas apa nakripesh baraen shopunek nakri, “Ipak mare punek skelimum kupaishi, aria Iruhin shopunek ta mare nunek skelimep uwe, uwok. Aria ipak mare pukesh enen baraen kupaishi pukri eshesh shenek yoweishi inahos iri, Iruhin shopunek ta mare nukep enen baraen nukri ipak penek yoweishi inahos iri. Aria ipak mare pubeimesh yoweishi inahos kupaishi shenekesh um ipak iri aria pukweshihesh um eshesh, aria Iruhin ta nukweshihumep ipakish yoweishi inahos shopunek. ");
INSERT INTO apec_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Aria ipak pukesh eneshenesh kupaishi um, Iruhin ta wata nukep enesh eshudok ipak. Anan ta nutaurumep nukep sabaishi eshudok aria ta shuknigun abom um ipak. Aria makwunish eshudok ipak pukesh kupaishi um, eshudok Iruhin ta wata nubeyeshumep namudok atin.” ");
INSERT INTO apec_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Aria Jisas nakripesh enyudok wobuwobren baraen nakri, “Anan nabes seshukan iri ta mare niyabig yah um kupaini nabes seshukan iri, uwok. Aria anan ta niyabigan yah um, amam biom ta hunak hutu hugrukuk anag nuwag. ");
INSERT INTO apec_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Aria shopunek, ta mare enen arpen nyanak um skul iri nyukri nyupe debeinyi um enyenyin tisa uwe, uwok. Aria ihishmorim ta sheyatak esheshin skul iyoh aria eshesh ta kadak shutogur kabi douk esheshim tisa ami um.” ");
INSERT INTO apec_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Nyak douk mare nyutik abudok debeibi bagab douk bor nyakip nabep iri uwe. Douk namudok aria nyak ta nyutrugun um agundok shokuguni nyubuhas-igun douk nor nyakin arpen enyenyip nabep iri mumam? ");
INSERT INTO apec_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Nyak douk mare nyutik abudok debeibi bugob douk bor nyakip nabep iri uwe. Douk namudok aria nyak ta mare nyukrip nyakin arpen um nyutukuman agundok shokuguni nyubuhas-igun douk nor enyenyip nabep iri uwe, uwok. Nyak nyenek rohw iri! Sagomatin nyak ta nyurik nyutukuk abudok debeibi bagab douk bor nyakip nabep iri ba iyoh. Aria nyak ta gamo nyunatrugun wosik aria kadak nyutukuman agundok shokuguni nyubuhas-igun douk nor nyakin arpen enyenyip nabep iri.” ");
INSERT INTO apec_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Aria Jisas apa nakripesh baraen shopunek nakri, “Yoweipi shuruwep ta mare pir enen yopunyi rowog. Aria yopipi ta mare pir enen yoweinyi rowog uwe, uwok. ");
INSERT INTO apec_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Arpesh ta shutik shuruwep atip aria ta shudukemesh um enyen douk yopunyi aka, uwok yoweinyi. Arpesh ta mare shudi enep shuruwep nyeigurip um fik iri enen segego watogren iri rowog, uwok. Aria shopunek, ta mare enesh arpesh shudi enep wainip shuruwep enen segego watogren iri rowog, uwok. ");
INSERT INTO apec_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Aria arpesh shopunek douk namudok atin. Yopunyi arpen douk yopumi urkum mape numun iri apa munek yopuhi aih. Aria yoweinyi arpen douk yowemi urkum mape numun enyenyim urkum iri apa munek yoweihi aih. Um maresh? Arpesh apa sheneyagwreh enenyenen nyape numun esheship urkwip iri.” ");
INSERT INTO apec_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Aria Jisas apa nakripesh baraen nakri, “Ipak apa pohware pakri, ‘Debeini’ aria ipak madae pugipesh eikin baraen uwe um maresh? Namudok uwok. ");
INSERT INTO apec_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Eshudok arpesh douk shunakumori eik aria shumnek eikin baraen shugipeshen iri, eshesh ta kabi douk maresh um? ");
INSERT INTO apec_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Eshesh douk kabi anan arman douk nakitak narok nuwagos arigaha nabuh nasuhw burbudu aria nakitak nawu uroruh aria narok ananit urupat iri. Douk narokat wosik aria eshah harari worub bau bat aria babirak ba madae butukat uwe, uwok. ");
INSERT INTO apec_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Aria eshudok douk shumnek eikin baraen aria mare shugipeshen iri douk kabi anudok arman douk narok urupat atap meyoh iri. Anan madae nurok anagos nuwagos ba iyoh, aria nu uroruh aria kadak nurukat uwe, uwok. Aria anan narokat aria eshah harari aria worub bau batukat aria tatu.” ");
INSERT INTO apec_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Douk Jisas nakripesh enyudok baraen neyaten shemneken aria nakitak nanak um Kaperneam. ");
INSERT INTO apec_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Aria agundok anan debeini um amam soldia iri nape. Anan douk nanaki abrudok wabur Rom. Aria anudok douk nenekuman mour iri arugeh hapeyan aria anan hurukatin um nugok. Aria anudok debeini soldia douk urkum makriyan abom. ");
INSERT INTO apec_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Aria anan nemnek um Jisas nanaki nape Kaperneam um, aria neshopok anam eshesh Juda esheshim debeimi um hunak hukripan um nunaki nugabe anudok nenekuman mour iri. ");
INSERT INTO apec_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","5","Douk neshopokam hanak hatogur um Jisas aria harigan debeg abom hakri, “Anudok debeini soldia douk yopuyopuni abom. Douk namudok aria nyak nyunak nyutauruman. Anan douk urkum makri apak ihishmorim Juda abom aria anan kanak nakop utabor aria marok apakit urupat mape meyagwreh baraen-atari.” ");
INSERT INTO apec_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Aria Jisas nakitak neiram hanak. Douk hanak hurukatin um urupat aria anudok soldia nakitak neshopok anam ananim arpeshim hanak hakrip Jisas hakri, “Debeini, anudok soldia nakri nyak mare nyunak ananit urupat. Um maresh? Anan douk madae yopuni um nyak nyunak ananit urupat um uwe. ");
INSERT INTO apec_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Aria shopunek, anan douk madae yopuni um nunaki hurukatin um nyak aria nutrin uwe. Aria anan nakri nyak nyukri baraen atin aria anudok nenekuman mour iri wata yopun. ");
INSERT INTO apec_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Anan nadukemesh um nyak nyukri baraen atin um, anan ta wata yopun. Um maresh? Anan douk nape shakamum ananin debeini soldia. Aria anan shopunek douk nape debeini um kupaimi soldia. Aria ta anan nukrip anan um nunak um, anan ta nunak. Aria nukrip anan um nunakumori, anan ta nunaki. Aria ta nukrip anudok nenekuman mour meyoh iri nukri nenekume enyudok mour, anan ta nuneken.” ");
INSERT INTO apec_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Aria Jisas nemnek namudok aria nakitak yowiyokuk aria natanam nakrip eshudok sabaishi arpesh shagiman iri nakri, “Eik yakripep, apak kanak Israel, eik madae itik enen atin arpen nyunek bilip dodogowin atin namudok uwe!” ");
INSERT INTO apec_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Aria amudok douk neshopokam hanakum hukrip Jisas iri wata hatanam hanak urupat aria hatik um anudok nenek mour um anudok soldia iri wata yopun. ");
INSERT INTO apec_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Douk Jisas napeigu aria nakitak nanak um anabur wabur shahwarabur um Nain iri. Aria ananim disaipel hani sabaishi arpesh shopunek sheiran shanak. ");
INSERT INTO apec_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Douk nanak natogur Nain aria natik um enesh shasahi anan nagok iri arman shanaki. Anudok arman ananik amakek douk kwabuki anan atun. Aria okwokwin raminen douk nagokuk aria sabaishi arpesh sheirok shanaki. ");
INSERT INTO apec_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Aria douk Debeini natik namudok aria anan nakri giha abom aria nakripok nakri, “Nyak mare nyureh.” ");
INSERT INTO apec_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Aria anan nanak nasuhw asudok bokis douk shore iri anudok-asi ba shanasahumori aria eshudok shanasahi iri, shatik namudok aria sheyotu. Aria Jisas nakri, “Shokuni! Kakitak, eik yakripen!” ");
INSERT INTO apec_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Aria anudok nagok abom iri nakitak nape neyagwreh aria Jisas nakrip ananik amakek nakri, “Nyakin nuganin anudok.” ");
INSERT INTO apec_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Aria douk ihishmorim shatik namudok aria eshesh shanogugur abom aria shatuk Iruhin ananin nyeigur nyato iruhw aria shakri, “Anan debeini profet nanaki nape orokohun um apak.” Aria shopunek shakri, “Iruhin nanaki um nutaurum apak ananish arpesh.” ");
INSERT INTO apec_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Aria enyudok baraen nyowe nyanak sabaigunum agudok shokugi nahobig Judia gani kupairubi warub bape hurukatin iri shopunek um enyudok mour Jisas neneken iri. ");
INSERT INTO apec_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","19","Douk Jon ananim disaipel hakrip Jon um enyudok Jisas nape neneken iri aria anan nahwar biom hanaki aria neshopokam hanak. Amam hanakum horik Debeini hukri, “Douk Iruhin ta nishopokan nunaki iri douk nyak aka, uwok. Ta mupe mutrugun um kupaini?” ");
INSERT INTO apec_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Aria amam hanak hatogur um Jisas aria harigan hakri, “Jon douk nenek baptaisumesh iri neshopokohw-ari aria wanaki um usorigen um, ‘Douk Iruhin nakri um nishopokan nunaki iri arman douk nyak aka, uwok. Ta mupe mutrugun um kupaini?’” ");
INSERT INTO apec_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Aria abudok nyutob Jisas nagabe sabaishi arugeh hapeyeshi iri shani sagabehos shapenyesh iri. Aria shopunek nagabe sabaishi nabes seshukeshi aria eshesh wata shatrugun. ");
INSERT INTO apec_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Aria Jisas nakrip amudok Jon ananim disaipel nakri, “Ipak wata punak pukrip Jon um mour douk ipak patrin iri nyuni baraen ipak pemneken iri. Nabes seshukesh iri wata shatrugun, aria eshudok douk shape atap atin iri wata shakitak sharahaen. Aria yagabe arugeh lepra hapenyesh iri wata yopish, aria arigos seshukesh iri wata shemnek. Aria yohur shagok iri wata shakitak shape, aria yakripesh Iruhin ananin yopinyi baraen eshudok douk yaruhish iri arpesh shemneken. ");
INSERT INTO apec_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Aria eshudok arpesh douk urkwip porum eik aria shasuhw eikin baraen iri, eshesh douk shanadudareh!” ");
INSERT INTO apec_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Aria douk Jon ananim hatanam hanak aria Jisas nape nakrip eshudok sabaishi arpesh um Jon nakri, “Riguk ipak panak patik Jon gani wehigunum arpesh uwok um, ipak pakri anan douk maran arman aria ipak douk panak patrun? Pakri anan douk madae dodogowin kabi douk worur douk uhwin nyarar nyanak wobuwobur iri, uwok? ");
INSERT INTO apec_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","O panak um putik maresh? Ipak panak um putik anan arman douk nore yopihi atih rupeh iri? Uwok. Shenek yopihi atih rupeh aria shawok yopishi atish worigunish aria shape wosik atin iri, eshudok douk shape king-omi amamig otug urusag. ");
INSERT INTO apec_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Aria eik yakri ipak pukripe um ipak panak um putik maresh? Ipak panak um putik anan profet, uwok? Adur atin abom anan douk anan profet. Aria shopunek, anan douk neshagrakuk amudok anam profet-omi. ");
INSERT INTO apec_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Baraen douk nyetem Iruhin ananik Buk abom iri douk nyakrium anudok Jon. Aria Iruhin douk nakri, ‘Eik ta ishopok anan nurao eikin baraen iri nurik nunak. Anan ta nurik nunak nugabeimen yah nyak!’” ");
INSERT INTO apec_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Aria Jisas nakri, “Eik yakripep, Jon ananin nyeigur douk nyatouk nyeshagrakuk ihishmorim arpesh douk shape agundok atap iri esheshish nyeiguhw. Aria eshudok arpesh douk eshesh nyeiguhw madae shutowesh uwe, aria shawish agundok Iruhin nape Debeini um ananish arpesh um, esheshish nyeiguhw douk shatouk sheshagrakuk Jon ananin nyeigur.” ");
INSERT INTO apec_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Aria douk ihishmorim arpesh shani amudok harao takis iri shemnek Jisas neyagwrehen iri baraen aria eshesh shape shanadudareh. Eshesh shanadudareh um agundok riguk eshesh shemnek Iruhin ananin baraen shagipeshen shakri wosik yopinyi baraen aria Jon nenek baptaisumesh um. ");
INSERT INTO apec_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Aria riguk amam Farisi hani amudok henek skulumesh um lo iri hemnek Iruhin ananin baraen aria hokomukuk agabus Iruhin ananim urkum aria hakri uwok um Jon nunek baptaisumam um. ");
INSERT INTO apec_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Aria Jisas nakri, “Eik ta iyabigep maresh eshudok doukishi arpesh douk shakonaguk agabus Iruhin iri. Eshesh kabi douk omi um? ");
INSERT INTO apec_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Eshesh kabi douk shokwishi douk shemnek kupaishi esheshin baraen aria madae shugipeshen atin iri uwe. Shokwishi apa shanak shape agundok douk eshesh apa shantorum shapeum aria enesh shape shahwar enesh shakri, ‘Apak manadudareh aria mape mahapur buwaen aria ipak madae putaurumap miyarub uwe! Apak mape mareh meyarub aweruh douk sheyarub-aruh um shagok iri um aria ipak madae pureh uwe.’ ");
INSERT INTO apec_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Um maresh? Douk riguk Jon nenek baptaisumesh iri nanaki aria anan madae nuwok yopishi worigun shuni wainibar abar uwe aria ipak madae pumnek ananin baraen pugipeshen uwe. Aria ipak pakri, ‘Anudok enen yoweinyi sagab nyapenyan aria nagugak!’ ");
INSERT INTO apec_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Aria douk shopunek, eik Anudok Arman douk yatogur adurinyi arpen iri yanaki aria yape yawok worigun nani wainibar abar aria ipak pakri, ‘Tik nani nawok sabaiguni worigun iri. Anan nawok sabaibari wainibar abar aria nagugak. Aria shopunek, nani amudok harao takis iri hani eshudok shenek eneshenesh yoweishi inahos iri shape!’ ");
INSERT INTO apec_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Aria eshudok arpesh douk shagipesh Iruhin iri shenekeh iri aih douk heyabigap um Iruhin ananim urkum douk yopumi atum.” ");
INSERT INTO apec_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Anan Farisi nahwar Jisas um nunak nini anan huwok worigun ananit urupat. Aria Jisas nakitak nanak natogur anudok Farisi ananit urupat aria nani anan hape tebol hape hawok worigun. ");
INSERT INTO apec_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Aria abrudok wabur, onok armatok douk kwonek sabaishi yoweishi inahos iri kwape. Aria okwok kwomnek um Jisas nanak nani anudok Farisi hape hawok worigun um. Aria okwok kwakitak kwohur anar yopuri botol douk shenegor utom iri shukunir um yopunyi sanda iri kwasuwor aria kwanak. ");
INSERT INTO apec_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Okwok kwanak kweyotu agabin um Jisas hurukatin um ananiruh yeriweruh aria kwape kworeh. Okwok kworeh aria abih habuh hetem ananiruh yeriweruh aria okwok wata kwakwu okwokwig barag kwape kwagabe-aruh. Aria okwok kwanapuprik-aruh ba iyoh, aria douk kwagabeuman yeriweruh kwakwu enyudok sanda. ");
INSERT INTO apec_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Aria anudok Farisi douk nahwar Jisas nanaki iri natik namudok aria anan kanak naneyagwreh nakri, “Aria anudok arman douk adurini profet abom akure, anan ta nudukemesh um okwudok armatok douk kwape kwasusuhw ananiruh yeriweruh iri. Aria shopunek, anan ta nudukemesh um okwok douk kwenek yoweishi inahos iri!” ");
INSERT INTO apec_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Aria Jisas nakripan nakri, “Saimon, eik yakri ikripen um enen baraen.” Aria Saimon nakri, “Wosik tisa, kripe.” ");
INSERT INTO apec_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Aria Jisas nakripan nakri, “Anan arman nukom anabor utabor biom armam. Anan nakon 100 kina, aria anan nakon 10 kina atin. ");
INSERT INTO apec_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Aria amudok biom utabor uwok um wata hubeabor-bunaman um aria anan nakri nyunekesh. Aria nyak nyakri meini ta urkum munawasham abom um anudok nakom utabor iri?” ");
INSERT INTO apec_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Aria Saimon nakri, “Eik yakri anudok douk nakon 100 kina iri.” Aria Jisas nakri, “Nyak nyakri adurin baraen.” ");
INSERT INTO apec_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Aria natanam natik okwudok armatok aria nakrip Saimon nakri, “Nyak nyatik okwudok armatok? Eik yanaki nyakit urupat aria nyak madae nyuke anabar abar um inokwrup eikiruh yeriweruh uwe. Aria okwudok kwape kwareh aria okwokwih abih habuh hetem eikiruh yeriweruh aria wata kwakwu okwokwig barag kwape kwagabeume yeriweruh. ");
INSERT INTO apec_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Aria nyak douk madae nyunapuprike uwe. Aria okwudok, abudok nyutob eik yanaki atinyum arigaha douk, okwok kwape kwanapuprik eikiruh yeriweruh. ");
INSERT INTO apec_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Aria nyak douk madae nyuwanume anar yopuri wel barag uwe, aria okwudok kwakwrupame yeriweruh sanda. ");
INSERT INTO apec_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Okwok urkum douk manawasham eik abom. Namudok aria eik yakripen, Iruhin douk madae nusuhwesh um eshudok sabaishi yoweishi inahos riguk okwok kwenekesh iri uwe aria nakwreyeshuguk. Eshudok arpesh douk shenek karowishi yoweishi inahos aria Iruhin madae nusuhwesh-umesh uwe aria nakwreyeshuguk iri, esheship urkwip ta punawasham Iruhin shokubur atin.” ");
INSERT INTO apec_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Aria Jisas nakrip okwudok armatok nakri, “Iruhin madae nusuhwesh nyakish yoweishi inahos uwe aria nakwreyeshuguk.” ");
INSERT INTO apec_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Aria eshudok shani anan shape shawok worigun iri eshesh kanak sheneyagwreh shakri, “Anudok anan douk meini arman aria douk nakri Iruhin madae nunasuhwesh um arpesh shenekesh iri yoweishi inahos aria nakwreyeshuguk um?” ");
INSERT INTO apec_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Aria Jisas nakrip okwudok armatok nakri, “Nyak nyenek bilip um Iruhin aria anan douk nanaraen nyatanamori nyape wosik abom. Namudok aria nyak nyunak aria nyakihw apahw hwur wosik.” ");
INSERT INTO apec_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Douk anob nyutob banakuk aria Jisas nakitak nanak anarub debeirubi warub bani anarub shokurubi. Anan nanak nape nakripesh yopinyi baraen um agundok Iruhin nape Debeini um ananish arpesh um. Aria ananim 12-poreim disaipel shopunek hanaman hanak. ");
INSERT INTO apec_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Amam hani ono armago shopunek douk riguk Jisas nahiyah-umokuk yoweishi sagabehos shani arugeh douk hapenyo iri shanaman shanak. Oudok armago onok douk Maria douk kwanaki wabur Makdala iri. Okwok douk seiwok Jisas nahiyah-umokuk eshudok 7-poresh yoweishi sagabehos shapenyok iri shatogur sharuwokuk iri. ");
INSERT INTO apec_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Aria onok douk Joana douk okwokwin raminen nanahwaram Susa iri. Anan douk nenek mour Herot ananit urupat. Owo wani Susana kwani sabaiwari armago shopunek wagipeshan. Aria owo apa wataurumam nani ananim disaipel um wokam anabor owowibor utabor bani anagun worigun. ");
INSERT INTO apec_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","5","Douk eshesh shanak aria sabaishi arpesh abom shanaki sabairubi warub iri shape shanaki um shakri shutik Jisas. Douk arigaha sabaishi shanaki sheyotu aria Jisas nakripesh enyudok wobuwobren baraen nakri, “Anan arman nanak nawashak wit ananig um nubarig. Anan nawashat aria anat tabuh takus yah, aria arpesh sharahaen shoshishat aria armiguhw hwabuh hwatuhur hwatoh. ");
INSERT INTO apec_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Aria anat tabuh takus utabor um. Aria atat pupuwarat takih aria abar uwok anabar uwe aria yarit. ");
INSERT INTO apec_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Aria anat tabuh tagrukuk anaruh utoruh iri amnab aria pupuwarat takih aria aruhudok segegoiruhi madaruruh hashapamat. ");
INSERT INTO apec_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Aria anat tabuh tagrukuk yopubi amnab aria pupuwarat takih aria sabaiti teir. Atat 100-poreib urub beir atin atin apakiwog.” Aria douk Jisas nakriyuk namudok aria anan nakripesh nakri, “Ipak arigos sapenyepari ta gamo pumnek eikin baraen aria pugipeshen!” ");
INSERT INTO apec_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Douk Jisas nakriyuk enyudok baraen aria ananim disaipel hariganum baugenyum baraen um enyudok wobuwobren baraen anan nakriyen iri. ");
INSERT INTO apec_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Aria Jisas nakripam nakri, “Iruhin douk nakripep baugenyum baraen um enyudok nyanabeshuk iri baraen ipak atip um arpesh shuwish agundok Iruhin nape Debeini um ananish arpesh um. Aria ihishmorim kupaishi ta uwok. Eshesh ta shumnek wobuwobren atin aria ta shutik um baugenyum aria ta mare shudukemen. Eshesh ta shumnek baraen aria ta mare shudukem baugenyum uwe, uwok.” ");
INSERT INTO apec_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Aria Jisas ta nakri namudok, “Enyudok wobuwobren baraen um anudok nawashak wit nubarig iri douk nyanak namudok. Atudok wit douk kabi Iruhin ananin baraen um. ");
INSERT INTO apec_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Aria atudok douk tabuh takus yah iri douk kabi eshudok arpesh douk shemnek Iruhin ananin baraen, aria Satan nanaki natrish narauguk enyudok baraen douk nyape esheshiruh aparuh iri. Anan nenekesh namudok um eshesh mare shusuhw Iruhin ananin baraen dodog shugipeshen aria Iruhin wata nunaraesh shutanamori shupe wosik abom uwe, uwok. ");
INSERT INTO apec_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Aria atudok tabuh takus utabor um iri douk kabi eshudok arpesh douk shemnek Iruhin ananin baraen shanadudareh-umen aria eshesh shemneken meyoh iri. Eshesh madae shusuhwen dodog uwe. Eshesh shenek bilip um enyudok Iruhin ananin baraen shakri adurin banab nyutob meyoh. Aria Satan nokwiraehesh um shunek yoweishi inahos aria eshesh shakutukuk Iruhin ananin baraen aria wata shatanam shanak shenek yoweishi inahos. ");
INSERT INTO apec_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Aria atudok douk tabuh tagrukuk utoruh hatogrohi urah iri douk kabi eshudok arpesh douk shemnek Iruhin ananin baraen, aria eshesh shapeum shakri shunogrem sabaishi eneshenesh eshudok iri. Aria eshesh shanadudareh um eshudok eneshenesh abudok amnabishi atish. Eshesh douk shenek wari um enenyenen amaen douk ta nyutogrumesh iri aria mishish shakitak um shurao sabaishi eneshenesh eshudok aria eshesh shape shagipesh harik hapenyesh iri yoweihi aih. Aria eshesh madae shunek yopihi aih uwe, uwok. ");
INSERT INTO apec_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Aria atudok douk tabuh takus yopubi amnab iri douk kabi eshudok arpesh douk shemnek Iruhin ananin baraen aria shasuhwen dodog shagipeshen iri. Esheshiruh aparuh douk yopuyopuruh abom hape wosik aria sheyotu dodog abom shagipesh Iruhin ananin baraen. Aria eshesh shenek yopihi aih aria shape kabi atudok wit douk sabaiti urubit teir iri.” ");
INSERT INTO apec_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Aria Jisas ta nakri namudok, “Ta mare enen arpen nyahem enen lam aria nyukitak nyushapomen anat baket o nyunyigren shakamum anat bet uwe, uwok. Enyen ta nyuhemen aria nyunyem iruhw um kadak arpesh shuwishamori shutik agundok enyen nyatrugun um. ");
INSERT INTO apec_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Aria ihishmorim eshudok douk shanabeshuk iri ta wata shutogur yopugunum. Aria ihishmorim eshudok douk arpesh sheshigarish shakus iri ta wata shishurekesh shukus yopugunum. ");
INSERT INTO apec_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Aria ipak ko gamo pudukemesh aria gamo pumnek. Um maresh, eshudok arpesh douk shurao Iruhin ananin baraen shudukemen wosik iri, Iruhin ta wata gamo nukripesh enen shopunek. Aria eshudok douk madae shudukem ananin baraen iri uwe, enyudok karowin eshesh shasuhwen iri ta wata nutrish-enyuk.” ");
INSERT INTO apec_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Douk Jisas nape nakripesh Iruhin ananin yopinyi baraen eshudok sabaishi arpesh, aria ananik amakek kwani ananim warhim shanaki um shakri shutrun. Douk shanaki aria sabaishi arpesh sheyotu shersharihan aria anan neyotuwi orokohun. Aria eshesh shabirak aria madae shunak hurukatin um anan uwe. ");
INSERT INTO apec_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Douk namudok aria enesh shakripan shakri, “Nyakik amakek kwani nyakim warhim shashi shanaki sheyotu aduk. Aria eshesh shakri nyak nyunak nyutrish.” ");
INSERT INTO apec_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Aria Jisas nakripesh nakri, “Eshudok douk shemnek Iruhin ananin baraen shasuhwen shagipeshen iri eshesh douk kabi eikik amakek aria eikim warhim um.” ");
INSERT INTO apec_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Anah nyumnah Jisas nakrip ananim disaipel nakri, “Apak munak gani wobrehahig um waiyag.” Aria amam hakitak hato bot aria hanak. ");
INSERT INTO apec_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Douk hanak yah aria Jisas yobusin atun aria nabuh neshuh. Aria debeinyi uhwin nyahur aria abar baprok bawishukuk bot aria atat hurukatin um tubuhukuk atin. ");
INSERT INTO apec_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Aria ananim disaipel hatik namudok aria hanak henyubarun um hakri, “Debeini, apak hurukatin um mugok wo!” Aria anan nakitak naho enyudok uhwin aria morub um shunak shuruk shemshem. Aria uhwin nyanak nyagok nyabuhuk aria morub shopunek madae butuk uwe, uwok. ");
INSERT INTO apec_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Aria anan narig ananim disaipel nakri, “Ipak madae punek bilip um eik uwe um maresh?” Aria amam hanogugur aria hape hanasorik um hakri, “Anudok manan arman? Anan naho uhwin aria abar um shunak shugok shubuhuk aria eshesh shopunek shemnekan aria shanak shagok shabuhuk!” ");
INSERT INTO apec_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Aria Jisas nani ananim disaipel hanak arigaha hanak hatogur eshesh Gerasa eshesh-umok um. Agagun douk nape gani wobrehahig um waiyag Galili. ");
INSERT INTO apec_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","29","Agundok anan abrudok waburin douk yoweishi sagabehos shapenyan aria shenekan nagugak iri nape. Sabaihi nyumneh eshudok sagabehos shasuwan dodog anudok arman. Aria roubum nyutob anan madae nuwah rupeh uwe, uwok aria urupat madae nupeyat uwe. Aria arpesh apa shatrun ihih nyumneh aria shasuwan shape shakwu senab shaweshik ananish roguhw aiyas. Eshesh shaweshikan aria anan naprukesh abudok senab aria eshudok sagabehos sharan sharuwok shanak wehigunum arpesh uwok um. Anan nanak nape ganik wonugwegwiruh-igunum arpesh wokum. Douk amam hanak hatogur aria Jisas nabuh nakih neyotu anagas aria anudok sagabehos shapenyanari nanaki natogruman. Aria natik Jisas aria nohwar debeg aria nanak nabuh nakus atap hurukatin um Jisas ananiruh yeriweruh. Aria nahwar debeg nakri, “Jisas, Debeini Iruhin ananin Nuganin! Nyak nyakri nyuneke mumam eik? Eik dodogoiwe yakripenyum yakri nyak mare nyuneke irao debeiri eriger.” Anan nakripan namudok Jisas um maresh, Jisas douk madae roubi naho eshudok sagabehos um shukutun-ukuk shutogur shuruwok. ");
INSERT INTO apec_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Aria Jisas narigan nakri, “Nyak nyanahwar mumam?” Aria anan nakri, “Apak sabaishi sagabehos.” Anan douk nakri namudok um maresh, sabaishi yoweishi sagabehos shawish shapenyan. ");
INSERT INTO apec_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Aria sabaishi atish eshudok sagabehos dodogowish atish um Jisas shape apa shakri, “Nyak mare nyishopokap munak mugrukuk agudok nuwag douk gor gabuhuk aria madae gubuh giyotu anagun iri uwe.” ");
INSERT INTO apec_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Aria agundok anaguh burguhw hweyotuwi hurukatin um anag mihig. Aria eshudok yoweishi sagabehos shakrip Jisas um nushopokesh shunak shuwish ogwuhwudok burguhw aria anan neshopokesh shanak. ");
INSERT INTO apec_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Aria eshesh shatograri anudok nagugak iri arman shanak shawish ogwuhwudok burguhw. Aria ogwoguh hwatanam hwaruwok hwanak hwagrukuk enen natogur aria hwabuh hwabarahuk agudok waiyag. Aria ogwoguh hwabarahuk aria ihiguhmorim hwagok hwatuh. ");
INSERT INTO apec_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Aria amudok armam douk hape hako ogwuhwudok burguhw iri hatik namudok aria hahur hanak hakrip eshudok douk shape debeiburi wabur iri, shani eshudok douk shape hurukatin um nahobigos iri um enyudok mugu douk nyatogur iri. ");
INSERT INTO apec_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Aria eshudok arpesh shakitak shanak um shutik enyudok mugu douk nyatogur iri. Eshesh shanak shatogur um Jisas aria shatik anudok douk sagabehos shakutunukuk shatogur sharuwok iri nape. Anan wata narao yopumi urkum aria nakitak nanug rupah aria nanak nape hurukatin um Jisas ananigas aiyas. Douk eshesh shatrun namudok aria eshesh shanogugur abom. ");
INSERT INTO apec_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Aria eshudok arpesh douk shatik enyudok mugu Jisas neneken iri um nagabe anudok yoweishi sagabehos shapenyan iri shanakrip eshudok douk shanakumori shutik enyudok mugu douk nyatogur iri. ");
INSERT INTO apec_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Aria ihishmorim arpesh shape Gerasa iri shanogugur abom aria shakrip Jisas um nukutukuk esheshibur wabur ba nunak. Aria anan nakitak nato bot aria natanam nanak gani wobrehahig um waiyag. ");
INSERT INTO apec_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","39","Aria anudok sagabehos shakutunukuk shatogur sharuwok iri nakitak dodogowin um narig Jisas um nakri nunaman hunak. Aria Jisas nakripan nakri, “Uwok, nyak wata nyutanam nyunak nyakibur wabur aria nyukrip nyakishi arpesh um enyudok mour Iruhin neneken um nyak iri.” Aria anudok arman wata natanam nanak um ananibur wabur aria nakrip ihishmorim arpesh um agundok Jisas nagabeyan um. ");
INSERT INTO apec_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Aria Jisas natanam nanak arigaha nanak natogur gani wobrehahig um debeigi waiyag aria sabaishi arpesh shanadudareh-umani. Um maresh? Eshesh douk iganigadae shanaki shape shatrugun-uman. ");
INSERT INTO apec_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Aria Jairus douk nape debeini um eshesh Juda shape sheneyagwreh baraen-ati urupat iri shopunek nanaki. Anan nanaki aria nabuh nakus atap hurukatin um Jisas ananiruh yeriweruh aria narigan dodog atin um niran nunak ananit urupat. ");
INSERT INTO apec_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Um maresh? Ananik otuk arag nugawik douk okwokwish kwarahos amakek kwakwubuki-umeshi douk shatogur 12-poreish aria hurukatin um kugok. Aria Jisas nakitak nape nanak yah aria sabaishi arpesh shopunek shanaman shanak wobuwobur aria anan nor orokohun. ");
INSERT INTO apec_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Aria agundok onok armatok douk owishibor banakok kwape 12-poreish kwarahos iri shopunek kwanaki. Okwokwibor utabor douk kweyatabor batuhuk um kwator dokta omi um agundok hape hagabeyok um. Aria amam shopunek habirak madae hugabeyok uwe. Arpen douk madae enen dodogowin um nyugabeyok uwe, uwok. ");
INSERT INTO apec_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Douk namudok aria okwok kwagimori Jisas kwanaki agabinum aria kwasusuhw apubih um ananih rupah aria owishibor tukarubor-ukuk abom. ");
INSERT INTO apec_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Aria Jisas narigesh nakri, “Omi nyanaki nyasusuhw eik?” Aria eshesh ihishmorim shatanam aria eshesh atin atin shakri eshesh uwok. Aria Pita nakri, “Debeini, sabaishi arpesh sheyotu huruhuruk um nyak aria eshesh shanaki shatatoruh-enyuk meyoh.” ");
INSERT INTO apec_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Aria Jisas nakri, “Uwok, eik yadukemesh, enen arpen nyasusuhw eik. Um maresh? Eik yemnek um Iruhin ananin dodog douk nyogabe enen arpen.” ");
INSERT INTO apec_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Aria okwudok armatok kwadukemesh um anan nadukemesh um agundok anan nagabeyok um. Aria okwok kruk-kruk kwanaki kwabuh kwakus hurukatin um Jisas ananiruh yeriweruh. Aria eshudok ihishmorim arpesh sheyotu aria okwok kwakripan um maresh shenegok aria okwok douk kwanaki kwasusuhw ananih rupah aria ahudok atuh wata yopuk abom um. ");
INSERT INTO apec_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Aria Jisas nakripok nakri, “Nugawik, nyak nyenek bilip nyakri eik dodogoiwe iri aria nyak douk yopin. Douk namudok aria nyak nyunak aria nyakihw apahw hwur wosik.” ");
INSERT INTO apec_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Aria douk Jisas wata nape neyagwreh atin aria anan napei Jairus ananit urupat iri nanaki nakrip Jairus nakri, “Jairus, nyakik nugawik kwagok. Douk namudok aria nyak mare nyukon mour debeini Tisa um nunaku nyakit urupat um.” ");
INSERT INTO apec_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Aria Jisas nemnek namudok aria nakrip Jairus nakri, “Nyak mare nyunogugur uwe, uwok. Nyak nyunek bilip atin aria nyakik nugawik ta wata kwukitak kwupe.” ");
INSERT INTO apec_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Aria Jisas nanak arigaha natogur Jairus ananit urupat aria nakrip Pita nani Jon iri Jems atum hani okwudok kwagok iri okwokwish amakenyish atish shanaman shawish numun. Kupaishi shapeik aduk. ");
INSERT INTO apec_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Aria ihishmorim shape agundok iri shape shorep okwudok kwagok iri armatok. Aria Jisas nakripesh nakri, “Ipak mare pureh, okwudok madae kugok uwe. Okwok kweshuhw meyoh!” ");
INSERT INTO apec_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Douk anan nakripesh namudok aria ihishmorim shadukemesh um okwok douk kwagok. Namudok aria eshesh shanagukoruhan. ");
INSERT INTO apec_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Aria Jisas nani ananim 3-poreim disaipel hani okwokwish amakenyish shanak shawish numun aria anan nasuhw okwokwin rogur nakwuhur aria nakri, “Batowinyik, nyak kakitak!” ");
INSERT INTO apec_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Aria mishin nyakih nyawishok aria ahudok atuh okwok kwakitak kwape. Aria Jisas nakripesh um shukok anagun worigun. ");
INSERT INTO apec_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Aria douk okwok kwakitak kwape aria okwokwish amakenyish shakitak yowiyokuk. Aria Jisas nakripesh dodogowinyi baraen um eshesh mare shunak shukrip enesh arpesh um agundok anan nohur esheshik nugawik kwakitak kwape um. ");
INSERT INTO apec_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Aria Jisas nahwar ananim 12-poreim disaipel hanaki heyotu atugun, aria nakom gobi nyani dodog um huhiyahuguk yoweishi sagabehos. Aria shopunek um hugabe arugeh douk hape arpesh iri. ");
INSERT INTO apec_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Douk anan nakripam jurug aria neshopokam hanakum hukripesh yopinyi baraen um agundok Iruhin nape Debeini um ananish arpesh um aria hugabe eshudok arugeh haesh iri shutogur yopish. ");
INSERT INTO apec_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Aria anan nakripam shopunek nakri, “Ipak punak ahudok yah um, ipak mare pusuhw enep butip o esharuh huni worigun aria utabor o eneh kupaihi rupeh shopunek uwe, uwok. ");
INSERT INTO apec_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Aria punak anabur wabur aria abrudok waburish arpesh shukri wosik um shukep anat urupat um pishuh um, ipak punak pupe atudok atut urupat. Ipak pupe arigaha meihi nyumnah pukri pukutukuk abrudok wabur punak um, aria ipak kadak pukutubur-ukuk. ");
INSERT INTO apec_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Aria douk punak anabur wabur aria madae shumnekep aria madae shukep anat urupat um pishuh um, ipak pukutukuk abrudok wabur aria punak. Ipak pikitak pugudupeshuk nyupruk kwotem ipakiruh yeriweruh iri kwukusuk abrudok wabur aria punak. Ipak punekesh namudok um eshesh shutrip aria ta shudukemesh um eshesh douk shenek yoweihi aih aria Iruhin ta nunekumesh debeiti kwot.” ");
INSERT INTO apec_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Aria amam hakitak hape hakripesh Iruhin ananin yopinyi baraen hanak atubur atubur warub. Aria shopunek, hagabe sabaishi arpesh arugeh hapeyesh iri. ");
INSERT INTO apec_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Aria king Herot douk nape debeini gavman um agudok shokugi nahobig Galili iri nemnek um ihishmorim eshudok douk shape shatogur iri aria anan nornor nape. Um maresh? Anan nemnek um enesh arpesh shakri, “Jisas douk Jon nenek baptaisumesh iri. Anan douk nagok aria wata nakitak nape!” ");
INSERT INTO apec_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Aria enesh shakri Elaija douk seiwok nagok iri anan wata nakitak nape. Aria enesh shakri anan kupaini seiwokin profet wata nakitak nape. ");
INSERT INTO apec_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Eshesh douk shakri namudok, aria Herot nakri, “Eik yatupok Jon ananin aruhwigur aria anan nagok. Aria douk anudok meinari arman douk eik yemnek um anan nape nenek enenyenen dodogowinyi mour iri?” Douk namudok aria anan nape nabirak um nakri nutik Jisas. ");
INSERT INTO apec_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Aria Jisas ananim aposel wata hatanamori aria hakripan um eshudok amam henekesh iri. Aria anan narao amam aria amam atum hakitak hanam wabur Betsaida. ");
INSERT INTO apec_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Aria sabaishi arpesh shemnek um Jisas nanak nape abrudok wabur um, aria eshesh shagipeshan shanak. Eshesh shanak shatogurman aria anan nanadudareh-umesh um agundok eshesh shanaki um. Aria anan nape nakripesh baraen um shuwish um agundok Iruhin nape Debeini um ananish arpesh um. Aria shopunek, nagabe eshudok douk sharao arugeh iri. ");
INSERT INTO apec_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Douk eshesh shape arigaha aun nape nabuh aria Jisas ananim 12-poreim disaipel hanaki hakripan, “Nyak nyishopokesh ba shunam warub douk bape hurukatin um nahobigos iri um shunak shunourim um worigun um shugnoh iri. Aria shopunek um shunourim um urusag um shishuh um. Um maresh? Agundok apak mape wehigunum, arpesh uwok um.” ");
INSERT INTO apec_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Aria Jisas nakripam nakri, “Ipak kanak pukesh anagun worigun.” Aria amam hakripan hakri, “Apak masuhw 5-poreit bret tani bias arbus meyoh. Aria nyak nyakri apak um munak mutorumesh anagun worigun um eshudok sabaishi arpesh aka?” ");
INSERT INTO apec_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Aria armam douk 5,000 poreim. Aria armago iri batowish madae shudarehesh uwe. Aria Jisas nakrip ananim disaipel um hukripesh um hurukatin um 50-poreish shunak shupe anabik aria enesh shopunek hurukatin um 50-poreish shupe anabik. Eshesh shupe namudok atin shunak. ");
INSERT INTO apec_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Aria amam hakripesh aria ihishmorim shabuh shape atap. ");
INSERT INTO apec_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Douk shabuh shape aria Jisas nohur atudok 5-poreit bret tani asudok bias arbus nasuwesh aria nanig natik iruhw heven. Aria nenek beten nenek tenkyu um Iruhin. Douk nenek tenkyuman jurug aria nawor atudok 5-poreit bret aria arbus nako ananim disaipel aria amam hape hekeshesh hanak. ");
INSERT INTO apec_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Douk hekeshesh iyoh aria ihishmorim shashoh arigaha dugaresh aria shakusuk iri, amam hatrishesh heshruk 12-poreiruh sararuh shishikniruh aria harhubuk hakus. ");
INSERT INTO apec_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Anah nyumnah Jisas atun nape nenek beten. Aria ananim disaipel shopunek hani anan hape aria anan narigam, “Ipak pemnek arpesh shakri eik douk amiapen?” ");
INSERT INTO apec_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Aria amam hakripan, “Enesh shakri nyak douk Jon nenek baptaisumesh iri, aria enesh shakri nyak Elaija. Aria enesh shakri nyak anan kupaini seiwokin profet douk seiwok nagok aria douk wata nakitak nape iri.” ");
INSERT INTO apec_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Aria anan narig amam nakri, “Aria ipak kanak pakri mumam? Ipak pakri eik douk amiapen?” Aria Pita nakripan, “Nyak Krais douk Iruhin nagraehen aria neshopoken nyanamori nyurao arpesh iri.” ");
INSERT INTO apec_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Aria Jisas nakripam dodogowinyi baraen ananim disaipel um mare hunak hukrip enesh arpesh um anan douk Krais um uwe, uwok. ");
INSERT INTO apec_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Aria Jisas apa nakripam baraen shopunek nakri, “Eik Anudok Arman douk yatogur adurinyi arpen iri ta irao debeiri eriger. Aria eshesh Juda esheshim debeimi huni amam debeimi pris huni amam henek skulumesh um lo iri ta huke agabus aria huyokuse. Aria ta he igok aria shurume iyur wonugwehw biyeh nyumneh. Aria douk hukri um biyeh atih nyumneh um, Iruhin ta wata niyohur ikitak ipe.” ");
INSERT INTO apec_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Aria nakrip ihim-morim ananim disaipel nakri, “Douk enen arpen nyukri nyugipesh eik um, enyen ta nyukri uwok abom um enyen mare nyugipesh enyen kanak enyenyim urkum. Aria ihih nyumneh enyen ta nyusah enyenyin rowog kruse aria nyugipeshe. ");
INSERT INTO apec_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Um maresh? Eshudok arpesh douk esheship urkwip madae purum eik aria shukri shunagabe esheshiruh aturuh yegeshiweruh aria eshesh shunogugur um shugok um, eshesh ta shugok aria shunak shuwishuk. Aria eshudok douk esheship urkwip purum eik aria mare shunogugur um kupaishi shesh shugok um agundok shagipesh eik um, eshesh ta shupe wosik ihih nyumneh. ");
INSERT INTO apec_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Douk anan arman nunek mour aria nurao ihishmorim agundok atapish eneshenesh um, aria kweipon nanak nugok aria nunak nuwishuk um, aria ihishmorim eshudok eneshenesh ta shutauruman mumam? Adur atin ta uwok! ");
INSERT INTO apec_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Aria douk enen arpen nyunogugur um kupaishi arpesh aria nyukri enyen douk madae eikin disaipel uwe, aria shopunek nyukenyuguk agab eikin baraen um, kweipon eik Anudok Arman douk yatogur adurinyi arpen iri ta ikri enyudok arpen douk madae eikin uwe, uwok. Aria abudok nyutob eik dodogoiwe aria itruguni kabi douk eikin Yain nani ananish yopishi enselahos shatrugun um inaki obi nyutob, eik ta ikripen ikri enyen douk madae eikin uwe, uwok. ");
INSERT INTO apec_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Adur atin eik yakripep, ipak enep douk peyotu agundok iri ta mare arigas pugok aria ta putik abudok nyutob Iruhin nupe Debeini um ananish arpesh um.” ");
INSERT INTO apec_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Douk Jisas nakriyuk enyudok baraen aria 8-poreih nyumneh hanak hadiguk, aria anan nani amam Pita nani Jon aria Jems hanak hato anag mihig um anan nunak nunek beten. ");
INSERT INTO apec_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Aria douk anan nape nenek beten aria ananig yomag gatogur anahaeh abom. Aria ananih rupeh hatogur shigorihwih abom aria hatrugun kabi douk utag brereyarog ba gatrugun um. ");
INSERT INTO apec_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Aria ahudok atuh biom armam hatogur heyotu hani anan hape heyagwreh. Amam douk Moses nani Elaija. ");
INSERT INTO apec_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Amam shopunek douk hatrugun abom aria heyotu hani Jisas hape heyagwreh um agundok ta anan niyatok enyudok mour Iruhin neshopokan nanakumori nuneken iri um nugok Jerusalem um. ");
INSERT INTO apec_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Aria Pita nani amudok anam biom arpeshim hape yobus sam dodog amaenyim atum aria heshuh hagok. Aria amam wata hakitak hatik agundok Jisas dodogowin aria natrugun abom um nani amudok biom douk hani anan heyotu iri. ");
INSERT INTO apec_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Abudok atub nyutob amudok biom hakri hukwutukuk Jisas ba hunak aria Pita nakrip Jisas, “Debeini, namudok douk wosik um apak mupe agundok um. Aria apak muwem bioguh atur shomeguh. Nyak anar aria Moses anar aria Ilaija anar.” Aria agundok Pita douk madae nudukemesh uwe, um ta nukripan maren baraen Jisas. Douk namudok aria anan douk nakripan namudok. ");
INSERT INTO apec_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Aria douk Pita wata nape neyagwreh atin aria onog orug gwanaki iruhw aria goma nyeshigorum. Aria Pita nani amudok biom hanogugur um ogwudok orug gwanaki aria goma nyeshigarum um. ");
INSERT INTO apec_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Aria anah mah hatograri ogwudok orug aria mah heyagwrehi hakri, “Anudok douk eikin adurin Nuganin douk eik yanagraehan iri. Ipak pumnekan!” ");
INSERT INTO apec_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Aria douk enyen nyeyagwrehi jurug aria amam hatik um Jisas atun neyotuguk. Aria amam madae hiyagwreh hukri enen baraen uwe. Aria abudok nyutob shopunek, amam madae hunak hukrip enesh arpesh um eshudok amam hatrish iri uwe, uwok. ");
INSERT INTO apec_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Aria ruwahepih amam hakitak hakutukuk agudok mihig habuhi aria sabaishi arpesh shanaki shaparug Jisas yah. ");
INSERT INTO apec_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Aria anan arman douk nani eshudok arpesh sheyotu iri nahwar nakri, “Tisa tik, eik yarigen dodog um nyunaki nyutik eikin nuganin. Eik douk adur atin anudok atun nuganin! ");
INSERT INTO apec_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Anan enen yoweinyi sagab nyapeyan aria ahudok atuh nahwar debeg. Aria enyen nyatukan nyonaur atap aria ohwas sakih sabuh wobuwobur ananit nokwat. Enyen nyape nyanunun aria madae nyukutunuguk nyutogur nyunakuk uwe, uwok. ");
INSERT INTO apec_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Aria eik yakrip nyakim disaipel um huhiyahen aria amam habirak hatik uwok.” ");
INSERT INTO apec_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Aria Jisas nakri, “Ipak doukish arpesh, eik yani ipak mape roubi nyutob ipakirub warub aria ipak yoweishi arpesh madae punek bilipume uwe. Aria ipak pakri eik ta wata ini ipak mupe eneh shopunek nyumneh um itaurumep namudok atin um isah enenyenen ipakin amaen aria ta uwok?” Aria anan nakrip anudok arman nakri, “Nyak haroki nyakin nuganin!” ");
INSERT INTO apec_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Aria anudok yoweinyi sagab nyapenyan iri wata napa nanaki atin aria enyen nyatukan nyonur atap. Aria Jisas nahaen aria nyakutunuguk nyatogur nyaruwok. Douk Jisas nagabeyan aria wata nakrip ananin yaken nakri, “Nyakin nuganin anudok.” ");
INSERT INTO apec_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Aria ihishmorim arpesh shatik enyudok dodogowinyi mour Iruhin neneken iri aria eshesh shakitak yowiyokuk abom. Aria eshesh urkwip wata pape porum enyudok Jisas neneken iri aria anan nakrip ananim disaipel nakri, ");
INSERT INTO apec_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Ipak gamo pumneken wosik enyudok baraen douk yakri ikripepen iri! Arpesh ta shukrip eikim horim um eik Anudok Arman douk yatogur adurinyi arpen iri aria ta dodogowim atum husuwe hunak huweshike.” ");
INSERT INTO apec_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Aria douk nakripam enyudok baraen aria amam madae hudukem baugenyum uwe. Baugenyum baraen douk nyanabeshuk-umam aria amam hanogugur um horiganumen. ");
INSERT INTO apec_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Aria amam disaipel hape hanogogonim baraen um amam meini ta nupe debeini um amam. ");
INSERT INTO apec_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Aria Jisas douk nadukem amamip urkwip por panak um, aria nasuhwi enen batowin nyanaki nyani anan nyeyotu. ");
INSERT INTO apec_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Aria anan nakripam, “Douk enen arpen urkum mur um eik aria nyutaurum enyudok batowin um, enyen douk nyataurum eik. Aria douk namudok atin, enyudok arpen nyataurum eik iri douk nyataurum anudok douk neshopok eik yanaki iri shopunek. Aria meini orokohun um ipak douk peyotu agundok iri nyeigur wakan iri ta anudok nupe debeini um ipak.” ");
INSERT INTO apec_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Aria Jon nakrip Jisas nakri, “Debeini, apak matik anan arman nape nahiyahuk yoweishi sagabehos um nyakin nyeigur aria eshesh shatogur sharuwok. Aria apak makripanam anan mare wata nunekesh namudok uwe, uwok. Um maresh? Anan douk madae nugipesh apak iri uwe, uwok.” ");
INSERT INTO apec_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Aria Jisas nakripan, “Ipak mare pukripan namudok uwe, uwok. Um maresh? Eshudok douk shataurum apak iri douk shaniguk ipak iri.” ");
INSERT INTO apec_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Aria douk ihih nyumneh hape hanak hurukatin um Iruhin wata nurao Jisas nunam iruhw heven um. Aria Jisas nakri abom um nunam Jerusalem, aria anan nakitak nanak. ");
INSERT INTO apec_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Anan wata nape nagiguk aria neshopok enesh arpesh sharao baraen sharik. Eshesh shanak shawish anabur shokuburi wabur douk bape Samaria iri um shugabeman eshudok um anan nunak nishuh um. ");
INSERT INTO apec_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Aria arpesh shape nagundok iri shadukemesh um anan ta nunak um Jerusalem um nunek lotu um Iruhin. Douk namudok aria eshesh shakri uwok um nunak nini eshesh nishuh um. ");
INSERT INTO apec_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Aria douk ananim disaipel Jems nani Jon hatik namudok aria hakripan, “Debeinyi, nyak nyakri apak muhwar nyih hubuhi iruhw heven hunish aka, uwok nyakri mumam?” ");
INSERT INTO apec_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","56","Aria Jisas natanam naham aria amam wata hanam kupaiburi wabur. ");
INSERT INTO apec_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Douk amam hanak yah aria anan arman nakrip Jisas nakri, “Ihigun nyak nyunak um, eik ta inamen unak.” ");
INSERT INTO apec_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Aria Jisas nakripan, “Wanarig nubag apa gweshuh hurusigun. Aria armiguhw hwehwru iruhw iri apa hweshuh was. Aria eik Anudok Arman douk yatogur adurinyi arpen iri urupat uwok um inak ishuh um.” ");
INSERT INTO apec_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Aria Jisas wata shopunek nakrip kupaini nakri, “Nyak yowi nyugipesh eik.” Douk anan nakripan namudok aria anudok arman nakri, “Debeini, eik yakri nyukripe inak ba itik eikin yaken anan nagok ba iroman iyoh aria ta inaki inamen unak.” ");
INSERT INTO apec_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Aria Jisas nakripan, “Nyak bukeshuk shagok iri, kadak eshudok douk madae shunek bilip um eik iri uwe shunak shurumesh. Aria nyak nyunak nyukripesh yopinyi baraen um agundok Iruhin nape Debeini um ananish arpesh um.” ");
INSERT INTO apec_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Aria anan arman shopunek nanaki nakrip Jisas nakri, “Debeini, eik yakri igipeshen aria eik yakri inak ikeshuk rogur apak atup awirop ba iyoh.” ");
INSERT INTO apec_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Aria Jisas nakripan, “Douk anan arman nukri nuhur eikin mour nuneken aria anan wata urkum mur um eneshenesh eshudok anan nakutishukuk iri um, anan douk madae wosik dodogowin um nuwish agundok Iruhin nape Debeini um ananish arpesh um uwe, uwok.” ");
INSERT INTO apec_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Douk enyudok nyanakuk ba iyoh, aria Debeini wata nagraeh 72-poreim armam shopunek aria neshopokam hanak biom biom. Anan neshopokam harik hanak ihirub warub douk anan nakri nunak-arubi. ");
INSERT INTO apec_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Aria anan nakripam, “Sabaiguni worigun jurugigun nape, aria arpesh shagunmesh iri douk karowish. Douk namudok aria ipak punek beten um Debeini douk nagrem agudok nahobig iri um neshopok sabaishi arpesh um shunak shogunum agundok worigun. ");
INSERT INTO apec_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Ipak ta punak, aria eik ishopokep punak kabi douk sipsipahos douk madae dodogowish iri uwe, punak orokohun um wanarig nubag. ");
INSERT INTO apec_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Aria ipak mare punaruk anas paus douk ipak pape apa panaruk utabor um suni esharuh iri su. Aria ipak punak arigas, ipak mare piyotu puni enesh arpesh douk puparugesh yah iri piyagwreh, uwok. ");
INSERT INTO apec_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","“Aria douk punak puwish anat urupat um, sagomatin ipak ta purik pukri, ‘Apak makri ipak pape atudok urupat iri ipakiruh aparuh hur wosik.’ ");
INSERT INTO apec_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Aria ta anan yopuni arman nupe atudok urupat um, enyudok baraen ipak pakripanen iri ta nyuni anan nyupeik. O uwok um, enyudok yopinyi baraen ta wata nyutanamori nyupe um ipak kanak atin. ");
INSERT INTO apec_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Aria ipak pupe atudok atut urupat aria puwok agundok worigun aria abar eshesh shukepesh iri. Um maresh, ipak penek Iruhin ananin mour aria douk shatorip shekep agundok worigun. Aria ipak mare pupe anat urupat aria wata pukitak punam kupaigwi, uwok. Ipak pupe atudok atut urupat. ");
INSERT INTO apec_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Aria douk punak anabur wabur aria enesh arpesh shuraep punam esheshig urusag aria shunek anagun worigun shukep um, agundok worigun ipak ta pugnoh. ");
INSERT INTO apec_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Aria pugabe eshudok arpesh sharao arugeh iri douk shape abrudok wabur iri. Aria pukrip arpesh shape abrudok iri pukri, ‘Nyutob douk banaki hurukatin um arpesh shuwish agundok Iruhin nupe Debeini um ipak ananish arpesh um.’ ");
INSERT INTO apec_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","11","“Aria ta punak anabur wabur aria arpesh shape abrudok iri shukepaguk agabus um, ipak punak piyotu yah aria pukri, ‘Okwudok nyupruk apak meshishok ipakibur wabur iri okwudok wata magudupeshuk kwakusumep-ukuk. Apak menekesh namudok um ipak putrup aria ipak urkwip purum enyudok. Nyutob douk banaki hurukatin um arpesh shuwish agundok Iruhin nupe Debeini um ananish arpesh shupe um.’ ");
INSERT INTO apec_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Eik yakripep, ahudok nyumnah Iruhin nunaki nunemesh baraen ihishmorim arpesh ahi, arpesh douk seiwok shape Sodom iri ta shumnek debeiri eriger aria ta madae kabi eshudok shekepuk agabus ipak iri. Aria eshudok douk shekepaguk agabus ipak iri ta shunamnek debeiri eriger abom shenek uhwin um shape Sodom iri!” ");
INSERT INTO apec_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Aria Jisas apa nakripesh baraen shopunek nakri, “Eik yakri gihaum ipak arpesh pape Korasin bani Betsaida iri. Ipak ta pumnek debeiri eriger aria ta pupe yowep abom! Um maresh, seiwok um anan arman nunek enen Iruhin atun neneken iri mour gani Tair bani Saidon kabi douk eik yeneken ipakirub warub um akure, eshesh ta seiwok shukutukuk yoweishi inahos aria shutanam shukon aparuh Iruhin. Aria eshesh ta shukitak shuwashak yoweihi rupeh aria shunawatom argabus um shiyabigesh um eshesh douk shekeshuguk agabus yoweishi inahos! ");
INSERT INTO apec_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Aria ahudok nyumnah Iruhin nunaki nunemesh baraen ihishmorim arpesh um, amaen douk ta nyutogur um ipak Korasin puni Betsaida iri ta nyishagrakuk abom enyudok douk ta nyutogur um eshudok douk seiwok shape Tair bani Saidon iri. ");
INSERT INTO apec_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Aria ipak Kaperneam shopunek, ipak pakri ta Iruhin nukri wosik aria nurawep puto iruhw heven, aka? Iruhin ta nuwashep pugrukuk shagok iri shanak shapeum!” ");
INSERT INTO apec_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Aria Jisas nakrip ananim disaipel nakri, “Eshudok douk shumnek ipak iri douk shemnek eik shopunek. Aria eshudok douk shekep agabus ipak iri douk sheke agabus eik shopunek. Aria shuke agabus eik iri douk shakon agabus anudok douk neshopok eik yanaki iri.” ");
INSERT INTO apec_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Douk amudok 72-poreim armam wata hatanamori aria amam hanadudareh abom. Aria amam hakri, “Debeini, apak manak maho yoweishi sagabehos douk shawish shape arpesh iri makripesh um nyakin nyeigur aria eshesh shamnekap shatogur sharuwok.” ");
INSERT INTO apec_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Aria Jisas nakripam, “Adur, eik yatik Satan madae dodogowin uwe aria nakutukuk iruhw heven nagruki kabi douk utag brereyarog um. ");
INSERT INTO apec_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Ipak mnek. Eik douk yakep dodogowinyi big um pishish yugwuhw hwuni pupiyaumeb shuni ihinyumorim dodog apakin horin Satan ananin. Aria ipak ta mare enesh yoweishi eshudok shunekep uwe, uwok. ");
INSERT INTO apec_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Aria ipak mare punadudareh um eshudok sagabehos shemnek ipakin baraen um uwe, uwok. Ipak ta punadudareh um agundok Iruhin nowem ipakish nyeiguhw shetem iruhw heven um.” ");
INSERT INTO apec_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Aria abudok nyutob, Iruhin ananin Mishin nyenek Jisas nanadudareh abom aria nakri, “Eikin Yain, Debeini um iruhw atap iri! Eik yanadudareh aria yatuk nyakin nyeigur nyato iruhw. Um maresh? Nyak nyabeshuk baugeh um nyakih aih aria baraen um eshudok arpesh douk shakri eshesh shadukemesh abom aria sharao sabainyi saki iri. Aria nyak wata nyeyabig eshudok kabi douk shokwishi batowish iri um. Adur Yain, nyak douk nyagipesh nyakim atum urkum aria nyanadudareh um nyenekesh namudok.” ");
INSERT INTO apec_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Aria anan apa nakripam baraen shopunek nakri, “Eikin Yain douk neke ihishmorim eshudok. Aria madae enesh arpesh shudukem eik ananin nuganin uwe, uwok. Yain atun nadukeme. Aria shopunek, madae enesh arpesh shudukem Yain uwe, uwok. Eik ananin nuganin yani eshudok douk eik yakri iyabigesh um anan iri atup madukeman.” ");
INSERT INTO apec_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Aria Jisas natanamori natik um ananim disaipel heyotu aria nakripam nakri, “Ipak douk patik enyudok mour douk eik yeneken patrin iri, ipak douk panadudareh! ");
INSERT INTO apec_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Um maresh? Eik yakripep, sabaimi profet hani sabaimi king hakri hutik enyudok mour ipak patrin iri aria uwok. Amam hakri humnek enyudok baraen ipak pemneken iri aria uwok.” ");
INSERT INTO apec_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Anah nyumnah anan nenek skulumesh um lo douk seiwok Iruhin nakoguk Moses enyi nanak aria nakri nukwiraeh Jisas. Aria narigan nakri, “Debeini tisa, eik ta inek maresh aria ta douk ipe wosik abom ihih nyumneh?” ");
INSERT INTO apec_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Aria Jisas nakripan nakri, “Nyak nyatik Iruhin ananin lo nyakripen mumam? Aria shopunek nyak nyatarihen mumam?” ");
INSERT INTO apec_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Aria anudok nenek skulumesh um lo iri nakri, “‘Ipak ta urkwip gamo punawasham abom um Iruhin. Aria ipakiruh aparuh huni ipakish mishish shuni ipakip urkwip ta shunawasham Debeini ipakin Iruhin anan atun aria pukwu ihinyumorim ipakin dodog um punek ananin mour.’ Aria shopunek, ‘Ipak urkwip ta punawasham abom um eshudok douk shape hurukatin um ipak iri aria putaurumesh kabi douk ipak urkwip panawasham ipak kanak um.’” ");
INSERT INTO apec_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Aria Jisas nakri, “Nyak nyakri wosik. Nyak ta nyunekesh namudok aria nyak ta nyupe wosik ihih nyumneh.” ");
INSERT INTO apec_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Aria anudok nenek skulumesh um lo iri nakri Jisas nutrun nuhwaran yopunyi arpen. Douk namudok aria anan narig Jisas nakri, “Aria eshudok shape hurukatin um eik iri douk meishi?” ");
INSERT INTO apec_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Aria Jisas nakripan enyudok wobuwobren baraen nakri, “Anan arman nape Jerusalem aria nakitak nabuhum Jeriko. Anan nanak yah aria yowemi armam douk hakwuaruh atuh iri hasuwan aria han heneken atuhig aria anan hurukatin um nugok. Aria amam hanabuk nakusuk aria hatrun hanawar ananih rupeh hani eshudok anan nasuwesh iri hanasuwesh aria hanak. ");
INSERT INTO apec_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Aria abudok nyutob anan pris nagim yah nanak. Anan nanak natrun aria neshagrakan nanakuk wobrahum yah aria nanak. ");
INSERT INTO apec_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Douk anan nanakuk aria anan Livai douk nataurum amam pris iri shopunek nanaki nanak neyotu natrun aria nanak wobrahum yah aria neshagrakan nanak. ");
INSERT INTO apec_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Douk anan nanakuk aria anan Samaria nanak natogur agundok anan nakus um. Aria anan natrun aria anan neneman gihaum anudok Juda. ");
INSERT INTO apec_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Douk namudok aria anan nanak hurukatin um anan aria nourak wel rani wain um ebudok ereb ba iyoh aria naweshigeb. Douk naweshikuman ereb jurug aria nonohur nanem ananin donki aria naran nanak. Anan naran um anat arpesh shanak shape sheshuhati urupat aria nanak nape natauruman. ");
INSERT INTO apec_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Douk hanak hape arigaha ruwahepih aria anudok Samaria nakitak neyak anabar utabor nako anudok nagrem atudok urupat iri. Aria nakripan, ‘Nyak nyupe nyutauruman aria ta nyak nyukwu anabor nyakibor utabor nyutauruman um enesh eshudok eneshenesh um, eik ta itanamori aria ibeyaborumen.’” ");
INSERT INTO apec_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Aria Jisas narig anudok nenek skulumesh um lo iri nakri, “Nyak nyakri mumam um amudok biom atun. Meini nagabe anudok douk hakwuaruh atuh iri han hanabukuk iri kabi douk nanagabe eshudok douk shape hurukatin um anan iri um?” ");
INSERT INTO apec_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Aria anan nakri, “Anudok douk natrun nenek gihauman iri.” Aria Jisas nakri, “Nyak nyunak aria nyunekesh namudok atin.” ");
INSERT INTO apec_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Aria Jisas nani ananim disaipel hanak. Douk hanak hatogur anabur wabur aria onok armatok douk kwonohwar um Mata iri kwani amam shanam okwokwit urupat. ");
INSERT INTO apec_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Aria Mata okwokwik owawik douk kwonohwar um Maria iri kwanaki kwape hurukatin um Debeini ananiruh yeriweruh aria kwape kwomnek ananin baraen. ");
INSERT INTO apec_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Aria Mata otuk kwape kwenek worigun. Aria okwokwim urkum mor manak um eshudok douk ta kwunekesh iri aria okwokwibur nyibur juwehosibur. Aria okwok kwanak kwakrip Jisas kwakri, “Debeini, eikik owawik kwakutukuk eik aria eik atuwe yape yenek worigun. Aria nyak madae urkum mur um enyudok aria nyukripok kwunaku kwutaurume uwe? Nyak kripok kwunaki kwutaurume!” ");
INSERT INTO apec_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Aria Debeini nakri, “Mata, nyak urkum morum sabaishi eshudok aria nyakihw apahw yowehw. ");
INSERT INTO apec_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Aria atuh yopuhi aih nyak wata nyunekah uwe. Aria Maria douk kwakri kurao ahudok yopuhi aih. Douk namudok aria ta mare enesh arpesh shuturukwah-uguk uwe, uwok.” ");
INSERT INTO apec_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Anah nyumnah Jisas nanak nape nenek beten anabik. Anan nenek beten jurug, aria anan ananin disaipel nakripan nakri, “Debeini, nyak nyunek skulumap um munek beten um kabi douk Jon nenek baptaisumesh iri nenek skulum ananim disaipel um.” ");
INSERT INTO apec_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Aria Jisas nakri, “Ipak punek beten um, ipak pukri namudok. ‘Apakin Yain, apak makri ihishmorim arpesh shutuk nyakin yopunyi nyeigur nyuto. Aria apak makri nyak nyupe Debeinyi um sabaishi arpesh. ");
INSERT INTO apec_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Aria nyukop doukigun worigun ahudok nyumnah. ");
INSERT INTO apec_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Apak douk mokweshih-umesh um yoweishi inahos kupaishi shenekesh um apak iri. Douk namudok aria nyak nyukweshih-umap um apakish yoweishi inahos aria nyukwreyeshuk. Aria nyak mare nyukutukuk Satan um nukwiraeh apak um munek yoweishi inahos uwe, uwok.’” ");
INSERT INTO apec_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Aria Jisas nakrip ananim disaipel enyudok wobuwobren baraen nakri, “Douk ipak anan nunam ananin arpenyin ananit urupat orokohunib um wab aria nukri, ‘Arpenyin, eik yakri nyuke 3-poreit bret. ");
INSERT INTO apec_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Um maresh? Anan eikin arpenyin douk atin nanaki natogurum eik aria eik worigun uwok um ibiroman!’ ");
INSERT INTO apec_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","“Aria douk nape numun urupat aria nukri, ‘Nyak mare nyuke mour! Wit iganigadae yataru aria eik yani batowish meshuh. Aria eik ta mare ikitak iken enesh eshudok uwe, uwok!’ ");
INSERT INTO apec_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Aria ta mumam? Eik yakripep, anudok urupatinari ta mare nukri anan douk ananin arpenyin nanaki narigan aria ta nukitak nukon bret, uwok. Anan ta nukitak nukon ihishmorim eshudok anan nariganumesh iri. Um maresh? Anan ta nunaiwos abom um numnek ananin arpenyin nupe norigon um eneshenesh. ");
INSERT INTO apec_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Douk namudok aria eik yakripep, ipak ta punek beten purik Iruhin um nukep eshudok aria anan ta nukepesh. Ipak ta pupe purimesh aria ta putrish. Aria ipak ta pupe pubo wit aria Iruhin ta nijikatumep. ");
INSERT INTO apec_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Um maresh? Eshudok ihishmorim douk shenek beten sharig Iruhin iri, eshesh ta sharao eshudok eneshenesh. Aria eshudok ihishmorim douk shape shaurim eshudok eneshenesh iri ta shutrish. Aria eshudok douk shupe shubo wit iri Iruhin ta nijikatumesh. ");
INSERT INTO apec_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","“Douk ipak anan ananin nuganin norigan um nukon anar eiyur akure, anan ta nukitak nukon anar yur, aka? ");
INSERT INTO apec_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","O ta norigan um nukon anab ihwurub aria nukitak nukon onok pupiyak? Adur atin ta uwok. ");
INSERT INTO apec_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Aria ipak douk yoweishi arpesh penek yoweishi inahos abom iri, ipak douk padukemesh um pukesh yopishi eshudok eneshenesh um ipakish batowish um. Aria apakin Yain nape iruhw heven iri douk yopuyopunari aria ta nukesh ananin Mishin eshudok douk shunek beten sharigan iri.” ");
INSERT INTO apec_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Aria Jisas nape apa nahiyahuk enen yoweinyi sagab douk madae nyiyagwreh atin iri uwe. Enyen douk nyape anan arman aria nyenekan madae niyagwreh atin uwe. Douk enyen nyatogur nyaruwokuk aria anudok arman wata nape neyagwreh. Aria sabaishi arpesh shakitak yowiyokuk aria shape shanasarik um. ");
INSERT INTO apec_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Aria enesh shakri, “Enyudok Belsebul douk debeinyi um ihishmorim yoweishi sagabehos iri nyenekan dodogowin aria douk nahiyahuk eshudok enesh yoweishi sagabehos shatogur sharuwokuk.” ");
INSERT INTO apec_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Aria enesh shakri shukwiraehan. Douk namudok aria eshesh shakripan um nunek enen Iruhin atun neneken iri mour um shudukemesh um anan douk adur Iruhin neshopokan nanaki iri. ");
INSERT INTO apec_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Aria Jisas nadukem esheship urkwip por panak um aria nakripesh nakri, “Enesh arpesh shape atug nahobig iri shunadiyogurum shunek bias awiros aria eshesh kanak shupe shurpak akure, eshesh ta mare dodogowish. Aria anap awirop shukri shunadiyogurum aria eshesh kanak shupe shurpak akure, eshesh shopunek ta mare dodogowish. ");
INSERT INTO apec_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Aria douk namudok atin, douk Satan ananish shunadiyogurum aria eshesh kanak shupe shurpak akure, eshesh ta mare dodogowish. Eik douk yakripep enyudok baraen um maresh? Ipak pakri Belsebul nyataurum eik aria eik douk yahiyahuguk eshudok enesh yoweishi sagabehos. ");
INSERT INTO apec_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Douk Belsebul nyutaurume aria douk ihiyahuk yoweishi sagabehos um, ipak pakri mumam um ipakim douk hagipesh ipak iri? Amam ami nyakam dodog aria douk hahiyahuk yoweishi sagabehos? Ipakim douk heyabigep um enyudok baraen ipak pakriyen um Belsebul nyataurume um douk madae adurin uwe. ");
INSERT INTO apec_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Eik douk Iruhin neke dodog aria yahiyahuk yoweishi sagabehos. Douk namudok aria ipak douk patik Iruhin ananin dodog um arpesh shuwish agundok anan nape Debeini um ananish arpesh um. ");
INSERT INTO apec_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Aria douk anan dodogowini arman nusuhw ananigos burawos nupe neyoh ananit urupat um, ananish eshudok eneshenesh ta shukusuman wosik. ");
INSERT INTO apec_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Aria douk anan dodogowini abom nishagrakuk anan iri nunaki nini anan hurpak aria non akure, anan ta nunatrun ananigos burawos douk anan nasuwogos iri. Aria anan ta nutrun nukumesh aruh eshudok ananish eneshenesh aria nunak nisiyaesh um kupaishi arpesh. ");
INSERT INTO apec_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Eshudok arpesh douk madae eikish iri uwe, eshesh douk eikim horim. Aria eshudok douk madae shutaurume um murauri arpesh shunakumori eik iri, eshesh douk shapeum shenek eikish arpesh shukutukuk eik shanakuk atin atinyuk.” ");
INSERT INTO apec_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Aria Jisas apa nakripesh baraen shopunek, “Abudok nyutob enen yoweinyi sagab nyukutukuk enen arpen nyutogur nyunak um, enyen ta nyunak nyutik um anabik abar uwok um nyunak nyupe um nyarao uhwin. Aria douk enyen mare nyuparug anabik um, enyen ta nyukri, ‘Eik wata itanam inam eikit urupat douk riguk yapenyat iri.’ ");
INSERT INTO apec_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Aria enyen wata nyanak aria nyutik um atudok urupat shagitat aria yoput tape. ");
INSERT INTO apec_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Aria enyen nyanak nyurauri eshudok enesh 7-poreish yoweishi sagabehos douk yowesh abom sheshagrakuk enyen iri. Eshesh shanaki aria shuwish shupe atudok urupat aria riguk enyudok arpen nyape wosiwosik atin iri. Aria douk enyen ta nyape yowen abom nyeshagrakuk riguk nyarik nyape um.” ");
INSERT INTO apec_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Douk Jisas nape nakripeshuk enyudok baraen jurug aria onok armatok douk kwani eshudok sabaishi arpesh kweyotu iri kwakripan kwakri, “Okwudok armatok douk kwukwarumori nyak iri aria kweken nyumeb iri okwok douk wosik ta kwunadudareh!” ");
INSERT INTO apec_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Aria Jisas nakri, “Enyen adur, okwok ta kwanadudareh. Aria eshudok arpesh douk shemnek Iruhin ananin baraen shusuhwen shugipeshen iri eshesh douk ta shunadudareh abom.” ");
INSERT INTO apec_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Douk enesh sabaishi arpesh shopunek shanaki shantorum shape aria Jisas nakripesh nakri, “Ipak doukish arpesh douk yoweishi arpesh! Ipak pakri putik enen mour Iruhin atun neneken iri, aria eik ta mare iyabigep enen uwe, uwok. Eik ta iyabigep enyudok Jona ananin atin. ");
INSERT INTO apec_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Seiwok Iruhin neshopok Jona nanak Ninive nakripesh Iruhin ananin baraen aria shape Ninive iri shakeshuk agabus yoweishi inahos aria shatanam shakon aparuh Iruhin. Aria eik shopunek ta ikripep namudok atin. Douk namudok aria eik Anudok Arman douk yatogur adurinyi arpen iri ta ipe kabi douk enen kak um ipak doukipari. ");
INSERT INTO apec_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Aria ahudok nyumnah Iruhin nunekumesh kwot arpesh ahi, kwin douk kwape saut iri ta kwukitak kunekumep kwot ipak doukish arpesh um yoweishi inahos ipak penekesh iri. Um maresh, okwok kwape rougun aria kwanaki kwomnek king Solomon ananin yopinyi saki. Aria douk eik douk yeshagrakuk king Solomon iri douk yape agundok. ");
INSERT INTO apec_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Aria ahudok nyumnah Iruhin nunekumesh baraen arpesh ahi, eshesh shape Ninive iri ta shukitak shunekumep baraen ipak doukipari um eneshenesh yoweishi inahos ipak pape penekesh iri. Um maresh? Eshesh douk shemnek Iruhin ananin baraen Jona nakripeshen iri aria shekeshuk agabus yoweishi inahos aria wata shakon aparuh Iruhin. Aria douk eik douk yeshagrakuk Jona iri douk yape agundok.” ");
INSERT INTO apec_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Aria Jisas apa nakripesh baraen shopunek, “Ta mare enen arpen nyushupeh enen lam aria nyukitak nyubeshuken nyunyigren shakamet um anat baket uwe, uwok. Enyen ta nyushupehen aria nyunyem iruhw um kadak arpesh shuwish um aria shutik agundok enyenyis aris senegogun ba bogaragun um. ");
INSERT INTO apec_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Aria ipakis nabes douk sape kabi lam um ipakiruh yegeshiweruh. Douk ipakis nabes sutik yopishi eshudok aria ipak urkwip purum yopishi um, ipakiruh yegeshiweruh ta henek lait aria hupe wosik. Aria ipakis nabes sutik yoweishi eshudok aria ipak urkwip purum yoweishi um, ipakiruh yegeshiweruh shopunek ta goutukiruh hupe yoweruh. ");
INSERT INTO apec_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Douk namudok aria ipak ta pupe punodukumesh um ipakis nabes douk sape kabi lam douk nyape numun ipakiruh aparuh iri mare sutik yoweishi inahos aria ipak urkwip purum yoweishi uwe, uwok. ");
INSERT INTO apec_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Douk ipakiruh shukniruh yegeshiweruh henek lait um, aria mare anagun goutukigun um, ipak ta penek lait abom kabi douk hanu enyudok lam nyatrugun um.” ");
INSERT INTO apec_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Douk Jisas neyagwreh jurug aria anan Farisi nahwaran um nunak nini anan huwok worigun ananit urupat. Aria Jisas nakitak nanak nape tebol nani anan hapeum huwok worigun. ");
INSERT INTO apec_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Douk amam hape hawok worigun aria anudok Farisi natik Jisas um madae nugipesh esheshin lo um nunokwrupuguk wis ba iyoh aria kadak nusuhw worigun nugnah um uwe. Aria anan nakitak yowiyokuk abom. ");
INSERT INTO apec_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Aria Debeini nakripan nakri, “Ipak Farisi douk pakwrup adukiruh um yaureruh hani kas. Aria ipak numunip um douk pabo susih abom aria ipak shuknip um ahudok yoweihi aih um penek nyigiya um eshudok kupaishi um shani eneheneh yoweihi aih. ");
INSERT INTO apec_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Ipak pagagak iri. Iruhin douk nenek numunish um eshudok shani adukish um shopunek. ");
INSERT INTO apec_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Ipak pukesh eshudok shor numun ipakiruh yaureruh hani kas iri eshudok douk yaruhish iri um putaurumesh. Ipak punekesh namudok aria ipakish ihishmorim eshudok eneshenesh ta yopish aria shupe wosik. ");
INSERT INTO apec_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Eik yakri gihaum ipak Farisi, ipak douk pasia yabro wani lombo shani ihig apig aria pakon anagun um Iruhin. Ehudok aih um pakon anagun um ipakig apigIruhin. Ahudok aih um pakon anagun um ipakig apig Iruhin um douk wosik. Aria ipak madae punek adurih aih um kupaishi uwe. Aria shopunek, ipak urkwip madae punawasham Iruhin uwe. Enyen douk wosik um pakon eshudok Iruhin um. Aria ipak ta punek adurih aih um kupaishi shopunek aria ipak urkwip ta punawasham Iruhin shopunek. ");
INSERT INTO apec_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“O eik yenek giha abom um ipak Farisi, ipak ta pupe yowep abom! Um maresh? Ipak panak apak Juda mape meyagwreh baraen-ogwi urusag um, ipak pakri punak pupe shakus sharik iri wagiturahos. Aria ipak apa pakri punak sabaishi shantorum shapeum eshesh shutrip aria shunemep yopuhi. ");
INSERT INTO apec_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","“O yenek giha abom um ipak. Ipak ta pupe yowep! Um maresh, arpesh madae shudukem ipakip yoweipi urkwip uwe, uwok. Namudok aria ipak pape kabi douk wonugwegwiruh douk hanabeshuk hape shakam amnab iri um. Aria arpesh madae shudukemesh uwe aria shape sharahaen iruhwiruh um.” ");
INSERT INTO apec_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Aria anan nenek skulumesh um lo iri nemnek enyudok baraen aria nakrip Jisas nakri, “Debeini, nyak nyakri namudok aria nyakap baugos aria dodogowinyi baraen apak shopunek!” ");
INSERT INTO apec_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Aria Jisas nakri, “O eik yakri gihaum ipak penek skulumesh um lo iri shopunek! Ipak ta pupe yowep abom! Um maresh, ipak powemesh debeibusi bugabus sabaishi arpesh shabususah aria ipak madae ta putaurumesh pubususah uwe, uwok. ");
INSERT INTO apec_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","O eik yene gihaum ipak! Ipak ta pupe yowep abom! Um maresh, ipakim babukenyim habo amam profet hagok aria ipak douk pape penek wonugwegwiruh um amam um. ");
INSERT INTO apec_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Ipak douk penekesh namudok aria payabig arpesh um ipak pakri wosik um ahudok yoweihi aih ipakim babukenyim henekah iri um habo amam profet hagok um. Aria ipak pape penek wonugwegwiruh um amudok profet. ");
INSERT INTO apec_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Douk namudok aria Iruhin nagipesh ananim yopumi urkum aria saki nakri, ‘Eik ta ishopokugu profet huni aposel hunakumesh aria eshesh ta shubo anam hugok aria anam ta shom aria shunekam enenyenen.’ ");
INSERT INTO apec_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","51","Douk namudok aria ipak doukipari aria douk baraen nyapenyep um eshudok yoweishi inahos seiwok ipakim popehem yamehem hape henekesh hanaki iri. Seiwok baugos um Iruhin nenek agundok atap, amam habo ihim morim profet hanaki arigaha hatograri douk. Enyudok douk seiwok ipakin yamenen Ken neneken um nabo ananin wanin Abel nagok um nyanaki arigaha abudok nyutob amam habo Sekaraia nagiguk um. Sekaraia neyotu orokohun um alta nyani Iruhin ananit debeiti urupat aria amam han. Aria ipak penekeh iri aih douk heyabig arpesh um ipak douk panadudareh um enyudok ipakim popehem yamehem heneken iri. Aria Iruhin nakri ipak ta pusah ihibusmorim abusdok bugabus ipakim popehem yamehem amamibus. ");
INSERT INTO apec_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“O eik yenek gihaum ipak penek skulumesh um lo iri. Ipak ta pupe yowep abom! Um maresh, ipak kanak madae pudukem enyudok adurin baraen uwe. Aria shopunek, ipak madae putaurum eshudok armam armago um shudukem enyudok adurin baraen uwe, uwok. Douk namudok aria ipak kanak madae purao enyudok yopinyi saki uwe aria patapok yah um eshudok douk shape shabirak um shakri shurao yopinyi saki iri!” ");
INSERT INTO apec_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Aria douk Jisas nakutukuk eshesh nanak aria amam henek skulumesh um lo iri hani amam Farisi amamirub nyirub juwehosirub abom aria hape hanumogan yowiyokuk abom. Aria amam henek rohw um hakri husuwan um enen baraen aria hape harigan sabainyi enenyenen baraen um sabaishi eshudok eneshenesh. ");
INSERT INTO apec_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Amam henekesh namudok um hakri humnekan um nukri enen baraen douk madae adurin iri uwe um amam hunek kwotuman-umen iri. ");
INSERT INTO apec_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Douk sabaishi arpesh abom shanaki sheyotu ba shuknigun aria shanokunish um abom. Aria Jisas nakrip ananim disaipel nakri, “Ipak ko gamo pudukemesh um amam Farisi amamis yis. Eik douk yakri um ehudok amamih aih um henek rohw um heyagwreh biyen baraen. ");
INSERT INTO apec_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Eshudok douk sheshigarish shakus iri, Iruhin ta nuwerehesh shukus yopugunum aria ihishmorim ta shutrish aria shudukemesh. ");
INSERT INTO apec_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Aria eshudok douk ipak peyagwrehesh weibus iri, Iruhin ta wata nukrip arpesh shumnekesh aria wata shudukemesh. Aria eshudok douk ipak mirimiri panakripam-umesh numun urusag iri, Iruhin ta wata nuwerehesh. Anan ta nuwerehesh aria arpesh douk sheyotu iruhw urusag iri ta shukripesh um ihishmorim shumnek-umesh.” ");
INSERT INTO apec_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Ipak eikish arpesh, eik yakripep, ipak mare punogugur um eshudok douk ta shubo yegeshiweruh aturuh hugok aria kweipon mare dodogowish um shunek enesh yoweishi inahos eshudok shopunek iri, uwok. ");
INSERT INTO apec_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Aria eik yakri iyabigep anudok arman douk ipak ta punoguguran iri. Ipak ta punogugur um Iruhin atun douk ta nep pugok iyoh aria kweipon shopunek anan douk dodogowinam wata neshopokep punam yoweiburi wabur hel iri. Adur atin eik yakripep, ipak punogugur abom um anan atun! ");
INSERT INTO apec_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“Ipak padukemesh, arpesh apa shator 5-poreiguh shokuguhwi armiguhw um 2 toea atin. Aria Iruhin douk madae urkum mukonaguk um anar arudok shokuri armir uwe. ");
INSERT INTO apec_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Aria ipak Iruhin douk nadareh atubur atubur ehirub douk bakih ipakig barag iri. Aria anan douk nadukemep wosik abom. Douk namudok aria ipak mare punogugur. Iruhin ananim urkum douk morum aguhwudok shokuguhwi karowiguhw armiguhw atin. Aria ipakin Iruhin douk urkum morum ipak um meshagrakuk armiguhw. Douk namudok aria anan ta nutaurumep wosik abom.” ");
INSERT INTO apec_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Eik yakripep, douk enen arpen nyukripesh yopugunum sabaishi arpesh um agundok enyen nyape eikin um eik Anudok Arman douk yatogur adurinyi arpen iri ta ikripesh yopugunum Iruhin ananish enselahos shapeum enyudok arpen enyenyin nyeigur. ");
INSERT INTO apec_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Aria enyudok arpen douk nyukripesh yopugunum nyukri enyen douk madae eikin iri uwe, eik shopunek ta inekumen namudok atin enyudok arpen gani Iruhin ananish enselahos esheshis nabes. ");
INSERT INTO apec_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Douk enen arpen nyukri enen yoweinyi baraen um eik Anudok Arman douk yatogur adurinyi arpen iri, Iruhin wosik ta nukweshih enyudok yoweinyi baraen enyen nyakriyen um eik iri. Aria enyudok arpen douk nyukri enen yoweinyi baraen um Iruhin ananin Mishin iri, Iruhin ta nusuwen aria mare nukweshih enyudok arpen enyenyin baraen enyen nyakriyen um Ananin Mishin Iri. ");
INSERT INTO apec_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Aria abudok nyutob shukri shusuwep shuraep um apak Juda mape meyagwreh baraen-ogwi urusag um, o eshesh gavman shuni amudok nyeiguhw shatoumam iri um agundok ipak pagipesh eik um, ipak mare punogugur-umam. Aria shopunek mare pukri, ‘Kadak munak muwanamesh baraen mumam? O kadak munak aria mukri maren baraen?’ Uwok. ");
INSERT INTO apec_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Um maresh? Abudok atub nyutob ipak pakri piyagwreh um, Iruhin Ananin Mishin ta nyukripep enyudok baraen douk ta ipak pukriyen iri.” ");
INSERT INTO apec_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Anan arman douk nani eshudok sabaishi arpesh sheyotu iri nakrip Jisas nakri, “Debeini tisa, eik yakri nyak nyunak nyukrip eikin ashuken nisiyaumohw eshudok douk ohwakin yaken nagremesh neshubukuk um ohwak iri.” ");
INSERT INTO apec_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Aria Jisas nakripan nakri, “Uwok. Eik douk ami nyakripe um inek jas um ipak aria isiyaumep eshudok um ipak biyep?” ");
INSERT INTO apec_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Aria Jisas wata natanam nakrip ihishmorim arpesh nakri, “Ipak pumnek aria gamo pudukemesh um ipak mare penek nyigiya um eneshenesh eshudok. Um maresh? Eshudok douk shogrem worobaishi eshudok iri, esheshish sabaishi eshudok eshesh shogremesh iri ta mare shutaurumesh um shupe wosik, uwok.” ");
INSERT INTO apec_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Aria Jisas nakripesh enyudok wobuwobren baraen nakri, “Anan debeini ananig nahobig sabaiguni worigun jurugigun nape. ");
INSERT INTO apec_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Aria anan urkum mape mor manak aria anan urkum mor, ‘Eik urupat madae anat uwe um inabuk eikish worigun um. Douk namudok aria eik ta inekesh mumam?’ ");
INSERT INTO apec_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Aria anan naneyagwreh nakri, ‘Eik ta ibrik eikig worigunig urusag aria wata irok debeigwi otug. Aria eik inabuk agundok worigun nini eneshenesh eikish eshudok shopunek. ");
INSERT INTO apec_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Aria eik kanak ta ineyagwreh ikri, “Eik sabaishi eshudok shakusume aria eshesh ta inagremesh um sabaishi kwarahos. Douk namudok aria eik ta ipe meyoh aria inadudareh ipeum ishoh atin.” ’ ");
INSERT INTO apec_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","“Aria Iruhin nakripan namudok, ‘Nyak nyagagak iri! Kadak abudok atub wab nyak ta nyugok aria eshudok nyak nyanagremesh nyeshubukuk iri ta omi nyugremesh?’” ");
INSERT INTO apec_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Aria douk Jisas nakripeshuk enyudok baraen jurug aria wata shopuk nakri, “Eshudok arpesh douk esheship urkwip pur abom um shugrem sabaishi eshudok shuneshubuk, aria eshesh urkwip mare purum Iruhin iri, Iruhin natrish ananis nabes um, eshesh kabi douk yaruhish eshudok eneshenesh wokeshi arpesh um. Eshesh douk shagugak kabi douk anudok nagagak iri arman um.” ");
INSERT INTO apec_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Aria Jisas nakrip ananim disaipel nakri, “Namudok aria eik yakripep, ipak aparuh mare yoweruh um worigun ipak pugnoh iri nini rupeh ipak punekeh iri, uwok. ");
INSERT INTO apec_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Um maresh? Enyudok mupe wosik um douk nyeshagrakuk worigun aria yegeshiweruh douk heshagrakuk rupeh. ");
INSERT INTO apec_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Ipak putik armiguhw. Ogwoguhw douk madae hwunou anagun worigun aria hutormoguni, uwok. Aria ogwoguhw madae hwunarak onog sabaigwi worigunig urusag uwe. Aria Iruhin anan kanak nape nakoguh worigun! Aria ipak douk peshagrakuk armiguhw abom. Douk namudok aria anan ta nutaurumep wosik abom! ");
INSERT INTO apec_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Ipak ta meinyi arpen um ipak apahw yowehw abom um eneshenesh eshudok aria anan wata nunek ananih nyumneh rouhi aria nupe roubi nyutob agundok atap? Uwok. ");
INSERT INTO apec_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Aria douk ipak mare wosik um punek enyudok shokwinyi mour um, ipak douk urkwip porum eneshenesh eshudok um maresh? ");
INSERT INTO apec_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“Ipak putik aruruhish douk shakih urah iri. Eshesh madae shunek enen mour uwe. Madae shunek eneh rupeh um shihur iri uwe, uwok. Aria eik yakripep, seiwok Solomon douk nyeigur nyato abom aria nagrem sabaishi eshudok aria nenenek yopihi atih rupeh. Aria ananih rupeh douk madae eneh yopih abom kabi douk eshudok aruruhish um uwe, uwok. ");
INSERT INTO apec_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Adur atin eshudok aruruhish douk shape aria nuhutih atuh ta shutupesh shunak shishehuk nyih iri douk Iruhin naginohwesh. Aria ipak arpesh douk ipakin bilip madae dodogowin iri uwe, douk peshagrakuk eshudok aruruhish abom. Douk namudok aria ipak ta pudukemesh um Iruhin ta nutaurumep niginohep rupeh. ");
INSERT INTO apec_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Aria shopunek, ipakiruh aparuh mare yoweruh um eshudok ta ipak pishoh iri. ");
INSERT INTO apec_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Um maresh, eshudok douk madae shudukem iruhin iri uwe esheship urkwip douk por abom um sabaishi eshudokmori atish ihih nyumneh. Aria ipakin Yaken douk nadukemesh um eshudok ipak wokesh iri. ");
INSERT INTO apec_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Aria sagomatin ipak ta urkwip purum purik puwish um agundok Iruhin nape Debeini um ananish arpesh um aria anan ta kadak nukep eshudok ipak wokesh iri shopunek.” ");
INSERT INTO apec_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Ipak arpesh kabi douk karowish sipsipahos iri um ipak mare punogugur, uwok. Um maresh, ipakin Yaken nanadudareh um ipak puwish um agundok Iruhin nape Debeini um ananish arpesh shapeum aria pupe debeipari. ");
INSERT INTO apec_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Douk namudok aria ipak pukesh ipakish eshudok eneshenesh kupaishi arpesh shutorish shukep utabor aria pusiyabor um yaruhish eshudok eneshenesh wokeshi um putaurumesh. Aria agundok ipak pataurum yaruhish arpesh um, agagun kabi douk ponaruk ipakish eshudok apudok munuhwip douk ta mare yowep iri um. Um maresh? Gani heven eshudok ta mare shunak shuwishuk atin. Aria amudok hakwuaruh iri ta mare hunak hurukatin um ipakish eshudok eneshenesh. Aria tutubrugos ta mare sutupesh, uwok. ");
INSERT INTO apec_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Ipak ta punabuk ipakish yopishi eshudok gani iruhw heven. Aria ihih nyumneh ipakip urkwip ta purum abrudok wabur douk ipakish eshudok eneshenesh shakus aburi atubur.” ");
INSERT INTO apec_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Ipak punadaresh rupeh pihunug baneh aria punotug letog um pupe punek redi um punek mour. Aria pishir ipakish lamhos aria punek redi pupe putrugun um punek mour. ");
INSERT INTO apec_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Ipak pupe putrugun kabi douk eshudok shenek mour iri shenek gibegabe shape shatrugun um esheshin debeini um. Anan douk nanak natrish um anagun worigun douk shenekagun um biyesh douk ta shanaraum um iri aria anan ta wata nutanamori. Eshesh shape shatrugun um kadak anan nukri nunaki nubo wit, aria ahudok atuh eshesh shikitak shijikagun-uman. ");
INSERT INTO apec_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Aria douk debeini nunaki aria nutik eshudok shenek mouraman iri shupe shunek redi shutrugun-uman um, eshesh ta shunadudareh abom. Aria adur atin eik yakripep, debeini anan kanak ta nudaresh ananih rupah nuhunug nunatugah let aria ta nukripesh shunak shupe aria anan kanak ta nukesh worigun. ");
INSERT INTO apec_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Aria douk nunaki orokohunib um wab um, o nunaki abudok nyutob sagomatin owotog gwakitak um aria nutrish um shunek redi shupe um, eshesh ta shunadudareh abom! ");
INSERT INTO apec_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","“Aria ipak urkwip purum enyudok! Douk nagrem urupat iri nudukemesh um abudok nyutob nakwuaruh atuh iri ta nunaki nubrig ananit urupat nuwish um akure, anudok nagrem urupat iri ta mare nukutukuk urupat um ta nubrigat nuwish, uwok. ");
INSERT INTO apec_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Aria ipak shopunek ta punek redi pupe. Um maresh, eik Anudok Arman douk yatogur adurinyi arpen iri ta wata inaki anob nyutob douk ipak ta pukri eik ta mare inaki obi nyutob.” ");
INSERT INTO apec_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Aria Pita narig Jisas nakri, “Debeini, nyak nyakripap um enyudok wobuwobren baraen apak atup aka, eshudok ihishmorim arpesh shopunek?” ");
INSERT INTO apec_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Aria Debeini Jisas nakri, “Meini nenek mour iri nunek ananin debeini ananin mour wosik iri, anudok ta ananin debeini nugraehan um nusuhw merik um eshudok enesh shenekuman mour iri abudok nyutob anan nunakuk anabik um. Aria anan ta nukesh esheshigun worigun abudok nyutob eshesh shurao worigun obi nyutob. ");
INSERT INTO apec_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Aria douk ananin debeini nutanamori aria nutrun um nuneken wosik kabi douk anan nakripanaguk um, anudok nenekuman mour iri ta nanadudareh! ");
INSERT INTO apec_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Adur atin eik yakripep, ananin debeini ta nutrun namudok aria ta nugraehan um nupe debeini um ihishumori ananish eshudok eneshenesh. ");
INSERT INTO apec_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Aria douk anudok nenekuman mour iri niyagwreh anan kanak nukri, ‘Ah, eikin debeini ta mare nunaki arigas.’ Aria anan nikitak nupe nubo eshudok enesh shenek mour iri. Aria nupe nuwok worigun nini dodogowibari abar aria nugugak. ");
INSERT INTO apec_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Aria ananin debeini ta wata nutanamori anah nyumnah abudok nyutob douk anudok nenekuman mour iri nakri anan ta mare nutanamori ahi. Anan ta nutanamori nutrun namudok aria ta non yowiyokuk nupe yowen abom aria nushopokan nunak nini eshudok douk madae shunek bilip um Iruhin iri uwe shupe. ");
INSERT INTO apec_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Aria anudok nenekuman mour iri nudukemesh um ananin debeini nakripan um nunekesh iri, aria anan mare nunek redi um nunekesh um, ananin debeini ta nunaki aria non debeg abom. ");
INSERT INTO apec_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Aria nanudok douk madae nudukem ananin debeini nakri um anan nunekesh iri uwe, aria anan nunek enen yoweinyi mour aria douk nyeneken um ta non um, debeini ta nunaki aria non shokubur. Aria shashudok arpesh douk Iruhin nukesh sabainyi yopinyi saki nyuni dodog um shunek mour iri, anan ta nukripesh dodogowin atun um shunek yopinyi mour aria ta shuneken wosik atin. Aria eshudok douk ta nukesh sabaishi eneshenesh abom eshudok um shunek mour um, anan ta nukripesh um shunek yopinyi mour aria ta shuneken wosik abom.” ");
INSERT INTO apec_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Eik douk yanakumori iyutik nyih um hunu ihishmorim yoweishi inahos eshudok douk shape agundok atap iri. Aria eik yakri douk ta ehudok nyih hunu akure, douk ta wosik. ");
INSERT INTO apec_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Eik ta imnek debeiri eriger, aria eik douk wata imnekar uwe aria eikihw apahw douk yowehw abom! Um maresh? Eik wata imnekar uwe. ");
INSERT INTO apec_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Aria ipak pakri eik yanakumori inek agundok atapishi arpesh shupe atugun aka uwok? Eik yakripep, eik yanamori ta isiyaesh. ");
INSERT INTO apec_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Douk ahudok nyumnah arigaha kweipon, 5-poreis atus awirosish arpesh ta shikitak shunadiyogur um aria 3-poreis ta shutrishuk yoweisi nabes biyos. Aria asudok biyos ta shutrishuk yoweisi asudok 3-poreis. ");
INSERT INTO apec_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Aria arpesh ta shunadiyogur um. Yakenyim ta hutrum yoweisi nabes nugamim aria nugamim shopunek ta hutrumuk yoweisi nabes yakenyim. Aria amakenyiyu ta utruwaguk yoweisi nabes owoiyu nugariyu aria nugariyu ta utruwaguk yoweisi nabes amakenyiyu. Aria nakwurihiyeu ta utruwaguk yoweisi nabes mehiyariyu aria mehiyariyu ta utruwaguk yoweisi nabes nakwurihiyeu.” ");
INSERT INTO apec_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Aria Jisas nakrip eshudok armam armago nakri, “Douk putik onog orug gwir gwunak gani aun nabuhum, ahudok atuh ipak ta pukri ‘Eshah ta hurauri.’ Aria ta mare roubi nyutob aria ahah ta hurauri, adur. ");
INSERT INTO apec_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Aria ipak patik uhwin nyanaki saut iri nyahuri dodog, Aria ipak apa pakri ‘Wah ta hutao.’ Aria wah hatao. ");
INSERT INTO apec_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Ipak penek rohw iri! Ipak patik amnab bani utag shenekesh shanak um aria padukemesh um shashudok douk ta shutograri. Aria douk ipak patik eshudok douk shatogur shanak abudok nyutob iri aria ipak madae pudukemesh um shashudok douk ta shutograri uwe um maresh?” ");
INSERT INTO apec_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Ipak kanak ta punek skelimum eneheneh aih aria punek yopihi aih. ");
INSERT INTO apec_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Douk nyak nyuni enen arpen douk nyukri nyunekumen kwot iri pukri punam kwot um, ipak wata pupe punak yah aria ipak ta pugabe ipakin baraen nyugokumep-aguk yah. Ipak mare pugabeyen um, enyen ta nyuraen nyunam debeini jas douk nasuhw kwotog iri. Aria jas ta nuraen nyunam shusim aria amam ta huweshigen. ");
INSERT INTO apec_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Aria ganudok eik yakripen, nyak ta mare nyutograri arigas, uwok. Nyak ta nyugabe nyakin dinau nyiyatenyuk namudok aria ta nyutograri.” ");
INSERT INTO apec_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Aria abudok nyutob, enesh arpesh shape agundok iri shakrip Jisas um agundok debeini um gavman iri Pailat nabo enesh Galili shagok um. Anan naesh abudok nyutob eshesh shape shenek ofa um eneshenesh eshudok shuko Iruhin eshi. ");
INSERT INTO apec_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Aria Jisas nakripesh nakri, “Ipak pakri eshesh sheshagrakuk ihishmorim arpesh abom shape Galili iri um shenek eneshenesh yoweishi inahos um aria Pailat douk naesh shagok namudok? ");
INSERT INTO apec_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Uwok! Eik yakripep, aria ipak mare pukeshuguk agabus yoweishi inahos aria putanam pukon aparuh Iruhin um, ipak ihishmorim ta pugok namudok atin. ");
INSERT INTO apec_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Aria ipak pakri mumam um eshudok 18-poreish arpesh douk routi urupat tatao wabur Siloam iri tatu taesh shagok iri? Ipak pakri eshesh sheshagrakuk ihishmorim arpesh abom shape Jerusalem iri um shenek eneshenesh yoweishi inahos um aria eshesh douk shagok? ");
INSERT INTO apec_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Uwok! Eik yakripep, aria ipak mare pukeshuguk agabus yoweishi inahos um, ipak ta pugok namudok atin kabi douk eshesh shape Siloam iri shagok um.” ");
INSERT INTO apec_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Aria Jisas nakripesh enyudok wobuwobren baraen nakri, “Anan arman nawu enen rowog shahwaren um fik iri numun um ananig nubarig douk nawu wain um. Anan nawen nyakih debeinyi aria nanak nape narupamen aria anan madae nutik enep shuruwep pir uwe. ");
INSERT INTO apec_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Douk natrin namudok aria nakrip anudok nenek mour nubarig iri nakri, ‘Mnek, bishatin kwarahos eik yanaki yape yarupamen aria madae itik enep shuruwep pir uwe.’ Douk namudok aria eik yakri, ‘Nyubrowenyuguk! Um maresh? Enyen nyatao aria nyape nyeyatakuk gris meyoh um amnab.’ ");
INSERT INTO apec_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","“Aria anudok nenek mour nubarig iri nakripan nakri, ‘Debeini, nyak kutinyuguk nyutao enyudok atin kwar shopunek. Aria eik ta irak amnab ibur baugenyum aria ibuk bulmakau-ibas ubas baugenyum um enyen nyurao yopusi gris. ");
INSERT INTO apec_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Aria nyanyi nuhutin kwar shuruwep pir um, enyen wosik nyutao. O ta mare enep pir um, nyak wosik kadak nyubrowenyuguk.’” ");
INSERT INTO apec_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Anah nyumnah Sabat, Jisas nanak nawish nape nakripesh Iruhin ananin baraen anat eshesh Juda shape sheneyagwreh baraen-atari urupat. ");
INSERT INTO apec_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Aria agundok onok armatok douk enen sagab nyapenyok 18-poreish kwarahos iri kwani eshesh kwape. Okwok douk enyudok yoweinyi sagab nyapenyok aria nyenegok bukaruk atin. Okwok kwabirak aria madae kwukitak kwiyotu iruhw uwe, uwok. ");
INSERT INTO apec_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Aria Jisas natruk aria nahwarok kwanaki aria nakripok nakri, “Nyak mnek, eik yagabe nyak!” ");
INSERT INTO apec_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Aria anan nawemok ananis wis aria ahudok atuh okwok kwakitak kweyotu iruhw abom. Aria okwok kwanadudareh aria kwape kwatuk Iruhin ananin nyeigur nyato iruhw. ");
INSERT INTO apec_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Aria anudok debeini um atudok urupat iri juwehosin abom um Jisas um agundok nagabe okwudok armatok ahudok nyumnah Sabat um. Douk namudok aria anan nakitak nakrip eshudok arpesh shape iri nakri, “Ihih douk 6-poreih atih nyumneh um apak munek mourum. Aria ta ipak pukri punaki um anudok arman nugabeyep um, ipak punaki anah ahudok mourih nyumnah aria anan nugabeyep. Ipak mare punaki ahudok nyumnah Sabat uwe, uwok!” ");
INSERT INTO apec_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Aria Debeini nakripan nakri, “Ipak penek rohw iri! Ahudok nyumnah Sabat ipak ihipmorim apa pakweshih ipakish bulmakauhos iri donkihos aria paraesh panak shawok abar. ");
INSERT INTO apec_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Aria enyen douk wosik um eik yagabe okwudok Abraham ananik nugawik douk Satan noweshigok kwape 18-poreish kwarahos iri ahudok nyumnah Sabat um.” ");
INSERT INTO apec_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Aria Jisas ananim horim abraen nyam abom. Aria ihishmorim arpesh shanadudareh um enyudok yopunyi mour Jisas neneken iri. ");
INSERT INTO apec_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Aria Jisas narigesh nakri, “Agundok arpesh shuwish um Iruhin nape Debeini um ananish arpesh um ta kabi maresh um? Eik ta ikripep maren wobuwobren baraen um pudukemesh? ");
INSERT INTO apec_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Agagun ta kabi anam shokumi mastetim shurkum douk anan arman nawom ananig nubarig iri um. Anan nawom aria makih munek debeinyi rowog. Aria enyen nyenek nyeiguhw aria armiguhw douk hwehwru iruhw iri hwakih hwuwem was nyeiguhw aria hwotem.” ");
INSERT INTO apec_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Aria Jisas wata shopunek nakripesh nakri, “Agundok arpesh shuwish um Iruhin nape Debeini um ananish arpesh um ta kabi maresh um? ");
INSERT INTO apec_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Agagun ta kabi yis um. Onok armatok kwakitak kwosuhur kwakutus um enen dram plaua aria kwonek budibodigas arigaha yis suwish ihinyumorim um plaua aria seneken nyakitak debeinyi.” ");
INSERT INTO apec_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Aria Jisas nape nanak sabairubi debeirubi bani shokurubi warub. Anan nanak nape nenek skulumesh um Iruhin ananin baraen aria nape nanak um nakri nunak um Jerusalem. ");
INSERT INTO apec_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","24","Aria agundok enen arpen nyarigan nyakri, “Debeini, Iruhin ta nunarao atin atin arpesh shutanamori shupe wosik abom aka, uwok?” Aria Jisas nakripesh nakri, “Ipak ta dodogowip atip aria puwish atudok shokwuti wit. Eik yakripep namudok um maresh, sabaishi arpesh ta shukri shuwish atudok shokwuti wit aria eshesh ta shubirak shutik uwok. ");
INSERT INTO apec_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Aria ahudok nyumnah, anudok yaken um urupat iri ta nukitak nuwarukuk wit aria ipak ta punak piyotu aduk aria ta pupe pubo wit aria pukri namudok. ‘Debeini, jikamapogu wit!’ Aria anan ta nukripepi nukri, ‘Eik madae idukemep uwe, ipak meirubi warubip!’ ");
INSERT INTO apec_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","“Aria ipak ta wata pukripan pukri, ‘Apak douk mani nyak mawok worigun iri abar aria shopunek, nyak nyanaki nyenek skulumap nyakripap nyakin baraen apakirub warub!’ ");
INSERT INTO apec_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","“Aria anan ta wata nukitak aria nukri, ‘Eik madae idukem abrudok wabur ipak panaki-aburi uwe. Karemeik ipak penek eneshenesh yoweishi inahos iri!’ ");
INSERT INTO apec_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Aria ipak ta putik apakin yamenen Abraham nini Aisak iri Jekop huni amudok ihim-morim profet hupe agundok Iruhin nape Debeini um ananish arpesh shapeum. Aria ipak ta neshopokep punak pupeik aduk. Aria ipak ta pureh punokwukri punaruwor aria punatukesh ipakiruh naruh. ");
INSERT INTO apec_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Aria arpesh shape ihigunmorim agundok atap iri ta shunaki shupe shuwok debeiguni worigun agundok Iruhin nape Debeini um ananish arpesh shapeum. ");
INSERT INTO apec_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Aria eshudok arpesh douk nyeiguhw wokeshi ta wata shutogur nyeiguhw shapeyesh iri. Aria eshudok douk nyeiguhw shapeyesh iri ta wata shutogur nyeiguhw wokesh iri.” ");
INSERT INTO apec_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Aria abudok atub nyutob amam Farisi hanaki aria hakrip Jisas hakri, “Nyak nyukutukuk agundok aria nyunakumaguk kupaigunum. Um maresh? Herot nakri nen nyugok.” ");
INSERT INTO apec_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Aria Jisas nakripam nakri, “Ipak punak pukripat namudok atudok wanarit nubat. Pukri, ‘Mnek, doukih iri nuhutih eik ta ihiyahuk yoweishi sagabehos aria shopunek ta igabe arugeh hapeyesh iri arpesh. Aria hukri um biyeh atih nyumneh ahi, eik ta iyatak eikin mour.’ ");
INSERT INTO apec_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Aria doukih huni nuhutih iri biyeh, eik ta inak. Um maresh? Eshesh ta mare shubo anan profet nugok anabur kupaiburi wabur, uwok. Eshesh ta shon nugok Jerusalem atugun. ");
INSERT INTO apec_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“O ipak arpesh pape Jerusalem iri, ipak apa pabo amam profet hagok. Aria shopunek, pakwumam utabor amudok douk Iruhin neshopokam haraomepogu ananin baraen ipak iri! Sabaihi nyumneh eik yakri iraep pupe atugun kabi douk mamokit owot toshigar atatig nugag atatish kapraigiyohos um. Aria ipak pakri uwok abom! ");
INSERT INTO apec_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Aria mnek, Iruhin ta nukutukuk ipakibur wabur. Aria eik yakripep, ipak ta mare wata putiwe arigaha abudok nyutob douk ta pukri, ‘Apak makri Iruhin nunekuman yopunyi anudok arman douk nanaki um Debeini ananin nyeigur iri!’” ");
INSERT INTO apec_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","2","Anah nyumnah Sabat eshesh Juda mour uwok shape meyoh ahi, Jisas nanak um nuwok worigun anan debeini um amam Farisi iri ananit urupat. Aria agundok anan yegenyihw hwanugokan-ari nape hurukatin um Jisas. Douk namudok aria amam hape hatrun duk um hakri kadak nukri nugabe anudok arman um. ");
INSERT INTO apec_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Douk namudok aria Jisas nakitak narig amudok henek skulumesh um lo iri hani amam Farisi nakri, “Apakin lo nyakri apak mugabe arpesh ahudok nyumnah Sabat aka, uwok?” ");
INSERT INTO apec_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Aria amam madae hukri enen baraen. Aria Jisas nasuhwi anudok arman nagabeyan aria neshopokan nanak. ");
INSERT INTO apec_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Aria narig amudok tisa hani amudok Farisi nakri, “Aria ipak anan enen ananin batowin o enen bulmakau nyunak nyugrukuk anag nuwag abar barag iri ahudok nyumnah Sabat um akure, anan ta nunak nutukenyi aka, uwok? Adur, anan ta nutukenyi ahudok atuh nyumnah.” ");
INSERT INTO apec_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Aria amam baraen uwok um hubeyenyuman um. ");
INSERT INTO apec_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","8","Douk Jisas natik amudok armam douk hanakum agundok worigun iri hanaki, aria amam hakri hupe shakus sharik iri atish wagiturahos. Aria anan nakripesh enyudok wobuwobren baraen nakri, “Aria enen arpen nyuhwarenyum nyunak um anagun worigun douk shenekagun um biyesh shanaraum, um nyak nyunak aria mare nyunak nyupe nyurik uwe, uwok. Um maresh? Ta anudok douk nahwarenyum nyunak um agundok worigun iri nuhwari anan douk ananin nyeigur nyatouman-uguk um nyak iri shopunek. ");
INSERT INTO apec_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Aria douk namudok um, anudok douk nahwarep punak um ananigun worigun iri ta nunaki aria nukri, ‘Nyak kakitak aria nani nunaki nupe agundok.’ Aria nyak ta abraen nyen aria nyunak nyupe nyugiguk. ");
INSERT INTO apec_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Aria namudok douk uwok. Aria enen arpen nyuhwarenyum nyunak um enyenyigun worigun um, nyak nyunak aria nyupe nyugiguk. Nyak nyunekesh namudok aria enyudok arpen douk nyahwarenyum nyunak um enyenyigun worigun iri ta nyunaki nyukripenyum nyukri, ‘Arpen, nyak nyunak nyupe nyurik.’ Enyen ta nyukripen namudok aria eshudok enesh arpesh douk shanakumori agundok worigun iri ta shutrinyum aria shutuk nyakin nyeigur nyuto iruhw. ");
INSERT INTO apec_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Um maresh? Ihishmorim arpesh douk shutuk esheshish nyeiguhw shuto iruhw shukri eshesh debeishi iri, Iruhin ta wata nunihesh shubuh atap. Eshudok douk madae shutuk esheshish nyeiguhw iri uwe, Iruhin ta wata nutuk esheshish nyeiguhw shuto iruhw.” ");
INSERT INTO apec_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Aria Jisas nakrip anudok debeini um amam Farisi iri douk nahwaran um nunak um ananigun worigun iri nakri, “Aria nyak ta nyukri nyunek anagun worigun um, nyak mare nyuhwari nyakish arpesh atish shuni nyakish ashukenyish owashish shuni nyakip awirop puni ipak atubur wabur um douk shanabuk sabaishi eshudok eneshenesh iri atish uwe, uwok. Um maresh? Eshesh ta wata shuhwarenyum nyunak nyuwok worigun esheshig urusag. Aria namudok um, eshesh ta shuwanam um nyakish worigun. ");
INSERT INTO apec_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Aria namudok uwok. Aria nyak nyunek debeiguni worigun um, nyak ta nyuhwari eshudok yaruhish douk eneshenesh wokeshi um eshudok iri, shuni yegeshiweruh yoweruh-eshi shuni aiyas senekeshi shuni nabes seshukesh iri. ");
INSERT INTO apec_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Um maresh? Eshudokmori arpesh ta mare shuwanamen agundok worigun nyak nyenekagun-umesh iri. Aria Iruhin ta nunekumen yopuhi aih. Aria abudok nyutob eshudok yopishi arpesh douk riguk shagok sharumesh iri wata shukitaki wonugwegwiruh obi nyutob, Iruhin ta nuwanamen eshudok eneshenesh.” ");
INSERT INTO apec_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Aria anan arman douk nanamam hape hawok worigun iri nemnek namudok aria nakrip Jisas nakri, “Eshudok arpesh douk ta shupe shuwok worigun agundok Iruhin nape Debeini um ananish arpesh shapeum iri, eshesh ta shunadudareh shuriguk.” ");
INSERT INTO apec_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Aria Jisas nakripan enyudok wobuwobren baraen nakri, “Anan arman nakri nunek anagun debeiguni worigun. Aria anan nahwari sabaishi arpesh um shunak um agundok worigun. ");
INSERT INTO apec_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Aria ahudok nyumnah hatogrum nunek agundok worigun um, aria anan neshopok anan nenekuman mour iri um nunak nukripesh shunaki. Aria anan nanak nakripesh nakri, ‘Ipak yowi, worigun monekagun nakus.’ ");
INSERT INTO apec_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","“Aria eshudok ihishmorim atin atin shakitak aria shakri eshesh ta mare shunak. Aria narigiri nakri, ‘Eik yator anag nubarig aria eik yakri inak itrug. Douk namudok aria eik ta mare inaku.’ ");
INSERT INTO apec_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","“Aria anan nakri, ‘Eik douk atin yator 10-poreish bulmakauhos um shunek mour iri, aria eik yakri inak ikwiraehesh um shunek mour. Douk namudok aria eik ta mare inaku.’ ");
INSERT INTO apec_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","“Aria anan nakri, ‘Eik douk atin yarao armatok, douk namudok aria eik ta mare inaku.’ ");
INSERT INTO apec_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Douk amam hakripan namudok aria anan wata natanam nanak nakrip ananin debeini um enyudok baraen amam hakripan um. Aria anudok urupatinari juwehosin abom aria nakrip anudok nenekuman mour iri nakri, ‘Douk nyunak arigas um ehudok ihihmorim debeihi yeh huni shokuhi douk hape abrudok wabur iri. Aria nyurauri nabes seshukesh iri shuni eshudok eneshenesh wokesh iri. Eshesh shuni eshudok douk yegeshiweruh yoweruhesh iri, shuni aiyas senekeshi aria nyuhwaresh shunaki eikit urupat.’ ");
INSERT INTO apec_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","“Aria anudok nenekuman mour iri wata nanaki aria nakri, ‘Debeini, eik yagipesh nyakin baraen aria anabigit um urupat watak tape meyoh.’ ");
INSERT INTO apec_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","“Aria debeini nakripan nakri, ‘Nyak nyunak nyugim debeihi yeh aria shopunek nyugim narub nubarigirub aria nyiraouri arpesh shunaki shuwish eikit urupat. Um maresh? Eik yakri eikit urupat ta shuknit abom. ");
INSERT INTO apec_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Aria eik yakripen, amudok armam douk nubokuhi yahwaram um hunaki um eikigun worigun iri ta mare wata hunaki huwok anagun eikigun worigun uwe, uwok.’” ");
INSERT INTO apec_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","26","Douk sabaishi arpesh shani Jisas shanak aria anan natanam natrish aria nakripesh nakri, “Aria enen arpen nyukri nyunaki nyugipesh eik, aria enyen urkum munawasham abom um enyenyin yaken nini amakek, shuni enyenyik irohukwik kwuni enyenyish batowish, shuni enyenyish ashukenyish owashish shuni enyen kanak, aria eik enyen urkum munawasham karoiwe atuwe um eik iri, enyen ta mare wosik nyugipesh eik uwe, uwok. Enyen nyukri nyugipesh eik um, enyen urkum ta munawashame abom. ");
INSERT INTO apec_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Aria shopunek, enyudok arpen douk nyukri nyugipesh eik, aria enyen mare nyunek redim nyusah enyenyin rowog kruse aria nyugok um, enyen ta mare wosik nyupe eikin disaipel uwe, uwok. ");
INSERT INTO apec_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Aria ta ipak enen nyukri nyurok anat rourouti urupat akure, sagomatin enyen ta nyupe aria urkum mupe murum enyenyibor utabor douk enyen nyanabarubuk iri iyoh. Ababar ta wosik um nyurok atudok urupat nyiyatat aka, uwok? ");
INSERT INTO apec_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Aria douk sagomatin enyen urkum mare mur namudok iyoh aria nyukitak nyunek simen nyishuhurat, aria enyen mare nyurukat nyiyatat um, ihishmorim arpesh ta shutrut aria shiyakasen, shuneken enenyenen. ");
INSERT INTO apec_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Eshesh ta shukri, ‘Enyen nyatuhur nyarukat aria enyen madae nyurukat nyiyatat uwe!’ ");
INSERT INTO apec_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Aria ta anan king nini 10,000 poreim soldia aria nukri nunak nini kupaini king douk narauri 20,000 poreim soldia iri um ta hurpak um, sagomatin anan ta nupe aria urkum murum anan nini ananim soldia ta wosik dodogowim um hubo anudok anan king nini ananim huhiyaham aka, uwok. ");
INSERT INTO apec_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Aria anan nunadukem um anan ta mare dodogowin um, ananish horim shuni esheshin king ta wata shupe shunaki rougun aria anan ta nishopok enen nyurao baraen iri. Enyen ta nyurao baraen nyunak nyukrip anudok anan king um amam hunugabe um hupe atugun aria mare hurpak. ");
INSERT INTO apec_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","“Aria douk namudok atin, ta enen arpen mare nyukeshuk agab ihishmorim enyenyish eshudok eneshenesh um, enyen ta mare wosik nyugipesh eik uwe, uwok.” ");
INSERT INTO apec_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Aria Jisas nakripesh enyudok wobuwobren baraen nakri, “Sol arar douk yopuri. Aria ta arar wata jemiyair um, apak yah douk madae anah uwe um wata munekar ekehir um uwe, uwok. ");
INSERT INTO apec_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Arudokmori sol douk madae yopur um runek enen mour uwe. Apak ta muwasharuk meyoh. Aria ipak arigos sapenyepi ta pumnek enyudok baraen!” ");
INSERT INTO apec_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Anob nyutob amam harao takis iri hani amudok anam henek eneshenesh yoweishi inahos iri hanaki um humnek Jisas ananin baraen. ");
INSERT INTO apec_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Aria amam Farisi hani amam henek skulumesh um lo iri hape heyagwreh shokubur shokubur um Jisas hakri, “Anudok arman nani eshudok shenek eneshenesh yoweishi inahos iri shape. Aria shopunek, anan nanak um shape shawok worigun!” ");
INSERT INTO apec_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","4","Aria Jisas nakripesh enyudok wobuwobren baraen nakri “Aria ipak anan nagrem 100-poreish sipsipahos aria enen nyunak nyuwishuk akure, anan ta nunek maresh? Anan ta nukutukuk eshudok 99-poreish shiyotuguk shupe shuwokuk utoruh anagun aria anan ta nunak nupe nurium enyudok atin sipsip arigaha nunak nuparugen. ");
INSERT INTO apec_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Douk nuparugen aria anan ta nunadudareh abom aria nutuken nunyusah aria wata nutanam nunak. ");
INSERT INTO apec_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Douk nunak arigaha nutogur urupat aria anan ta nuhwari ananish arpesh douk shani anan shape atugun iri nukri, ‘Enen eikin sipsip nyanak nyawishuk aria eik yaurimen arigaha yanak yaparugen aria wata yaraenyi. Douk namudok aria yakri ipak punaki puni eik munadudareh!’” ");
INSERT INTO apec_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Douk Jisas nakriyuk namudok aria wata shopunek nakripesh nakri, “Aria eik yakripep, douk namudok atin shape iruhw heven iri ta shanadudareh um eshudok 99-poreish arpesh douk shakri eshesh shape wosik aria mour wokesh um shukeshuk agabus yoweishi inahos aria wata shukon aparuh Iruhin um. Aria atun arman douk nenek yoweishi inahos iri nukeshuk agab yoweishi inahos aria nutanam nukon apahw Iruhin um, shape iruhw heven iri ta shunadudareh shuriguk abom.” ");
INSERT INTO apec_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“O ta onok armatok kwunoruk 10-poreibor siliwaibor utabor aria okwok kwunak kwutukuk anam akure, okwok ta kwunek maresh? Okwok ta kwukitak kwushupeh lam aria kugit okwokwit urupat. Aria okwok gamo kwupe kwurimam arigaha wata kwuparugom. ");
INSERT INTO apec_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Douk kwuparugom aria okwok ta kwuhwari okwokwish arpesh douk shani okwok shape atugun iri kwukri, ‘Anam eikim utom manak mawishuk aria eik wata yaurimom aria yanak yaparugom. Aria eik wata yanadudareh aria yakri ipak punaki puni eik manadudareh!’ ");
INSERT INTO apec_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","“Aria eik yakripep, douk namudok atin, Iruhin nini ananish enselahos ta shunadudareh shuriguk abom um agundok atin arpen meyoh douk nyenek yoweishi inahos iri wata nyukeshuk agab aria nyutanam nyukon apahw Iruhin um.” ");
INSERT INTO apec_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Aria Jisas ta nakripesh enen wobuwobren baraen shopunek nakri, “Anan arman nabuki biom nugamim. ");
INSERT INTO apec_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Aria shokuni nuganin nakrip yaken nakri, ‘Yain, eik yakri uwok um ipe arigaha nyak nyugokuk aria ohwak douk ta unosia eshudok nyak nyagraehesh um ohwak iri uwe, uwok. Eik yakri nyisiyaesh-umohw douk!’ Aria yaken nakitak nosiyamam ananish eshudok eneshenesh ananim biom nugamim. ");
INSERT INTO apec_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","“Aria douk madae roubi uwe aria shokuni nuganin nohur ananish eshudok eneshenesh nanak nenek salimesh um utabor nasuabor aria nanak nape rougun kupaigi nahobig. Anan nanak aria nape nawashokuk ananibor utabor. Anan nawashabor um ehudok yoweihi aih douk anan nape nenekoh iri. ");
INSERT INTO apec_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Douk nawashak ananibor utabor arigaha neyataboruk, aria debeirubi nyurub baesh agudok nahobig. Aria anan eneshenesh wokan abom nenenem yaruhish. Anan madae nunabukuk anabor karowibor utabor um nunator worigun um uwe, uwok. ");
INSERT INTO apec_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Douk namudok aria anan nanak nape nenek mour um anan abrudok waburin arman. Aria anudok arman neshopokan nanak nape nenekuman mour um neyoh ananiguhw burguhw. ");
INSERT INTO apec_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Aria agundok anan nakri nuwok eshudok worigun douk burguhw hwape hwashoh iri. Aria madae enen arpen nyukri nyukon anagun worigun um nishoh iri uwe, uwok. ");
INSERT INTO apec_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","“Aria douk nape aria anan urkum wata mor um agundok anan nape yoweishigom um aria nakri, ‘Ihishmorim shenek mour um eikin yain iri douk shapeum shawok sabaiguni worigun. Aria eik yape agundok aria yagok um nyurub abom! ");
INSERT INTO apec_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Douk namudok aria nyunekesh, eik wata itanam inak um eikin yain. Aria eik ta ikripan ikri, “Yain, eik yenek yoweishi inahos um Iruhin nani nyak. ");
INSERT INTO apec_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Aria douk eik madae yopuwe iri abom um nyak nyuhware nyakin nuganin um, uwe. Aria nyak nyusap eik ipe shakamum nyak inekumen mour meyoh.” ’ ");
INSERT INTO apec_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Douk anan nakri namudok aria anan nakitak nape nanak um ananin yaken. “Douk anan wata nape nanak rougun aria ananin yaken natrunogu aria neneman giha abom um ananin nuganin. Aria anan nahur nanak nemetegan aria nanapuprikan. ");
INSERT INTO apec_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","“Aria anudok nuganin nakrip yaken nakri, ‘Yain, eik yenek yoweishi inahos um Iruhin nani nyak. Aria eik douk madae yopuwe iri um nyuhware nyakin nuganin uwe, uwok.’ ");
INSERT INTO apec_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","“Aria yaken nahwar eshudok shenek mouruman iri nakri, ‘Ipak purauri eikih sagomatinyih yopuhi rouhi rupah punaki puhuraman aria purman enen ring ananih hah. Aria purman ono su. ");
INSERT INTO apec_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Aria punak pubo nyanyi sagomatinyin yopunyi bulmakau aria apak munek debeiguni worigun muwok enyudok bulmakau aria munadudareh. ");
INSERT INTO apec_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Um maresh, eik yakri anudok eikin nuganin seiwok nagok. Aria uwok, anan wata nape. Eik yakri anan ta nanak nawishuk. Aria uwok, eik wata yaparugan.’ Aria anan nakripesh namudok aria eshesh shape shenek worigun aria shanadudareh abom. ");
INSERT INTO apec_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Douk eshesh shape shenekagun aria anudok sanin nuganin napei nubarig nanaki aria nemnek um agundok eshesh shape sheyarub shatukabur um. ");
INSERT INTO apec_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Aria anan nahwar anan nenek mour iri nanaki aria narigan nakri, ‘Ipak pape penek maresh?’ ");
INSERT INTO apec_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Aria anan nakripan nakri, ‘Nyakin wanin nanaki aria nyakin yaken nabo enyudok sagomatinyin yopunyi bulmakau aria apak munek worigun. Um maresh, ananin shokuni nuganin douk madae nugok uwe. Anan wata natanamori.’ ");
INSERT INTO apec_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","“Aria douk ashuken nemnek namudok aria anan juwehosin abom aria nakri uwok abom um nunak nuwish urupat um. Douk namudok aria ananin yaken nanaki aria nenekuman shokwin shokwin um nunak urupat. ");
INSERT INTO apec_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Aria anan nakrip yaken nakri, ‘Sabaishi kwarahos eik yape yenekumen debeinyi atin mour kabi douk anan nenek mour meyoh um nyak iri um. Aria eik madae iken agab um nyakin baraen atin uwe. Aria nyak madae nyuke enen shokwinyi meme meyoh um eik ini eikish arpesh munenek anagun worigun mugnoh aria munadudareh uwe, uwok! ");
INSERT INTO apec_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Aria anudok nyakin nuganin nanak neyatakuk nyakish eshudok eneshenesh um oudok weyotu yeh iri armago. Aria douk anan wata natanamori aria nyak nyaboman enyudok sagomatinyin yopunyi bulmakau.’ ");
INSERT INTO apec_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","“Aria yaken nakripan nakri, ‘Nya, ihih nyumneh ohwak wape atugun aria eikish eneshenesh eshudok douk nyakish shopunek. ");
INSERT INTO apec_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Aria douk apakiruh aparuh ta yopuruh abom aria munadudareh aria munek worigun. Um maresh, anudok nyakin wanin apak makri anan seiwok nagok, aria uwok. Anan wata nape aria douk anan wata natanamori. Aria apak makri anan ta nanak nawishuk, aria douk apak wata moparugan.’” ");
INSERT INTO apec_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Aria Jisas nakripam enyudok wobuwobren baraen ananim disaipel nakri, “Anan debeini douk nagrem sabaishi eneshenesh eshudok iri nape. Aria anan nenek mour iri shopunek douk natauruman nasuhw merik um eshudok enesh shenek mour iri nape. Aria enesh shanaki shakrip anudok debeini shakri, ‘Anudok nenekumen mour iri douk nyenekan um nasuhw merik iri nape nakwuaruh um nyakish eshudok eneshenesh shani nyakibor utabor.’ ");
INSERT INTO apec_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Aria anudok debeini nahwari anudok nasuhw merik iri aria nakri, ‘Maren enyudok baraen eik yemneken um shakri nyak nyape nyakwuaruh um eikish eshudok eneshenesh um? Douk namudok nyak nyunak nyudareh ihishmorim eshudok douk nyak nyasuesh iri shuni eshudok douk seiwok nyawasheshuk um nyenek mour um. Nyak nyudarehesh aria nyusume anap shup aria nyunaki nyiyabige. Um maresh? Nyak ta mare wata nyupe nyusuhw merik uwe, uwok.’ ");
INSERT INTO apec_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","“Aria anan nenek mour iri naneyagwreh nakri, ‘Eikin debeini nakri niyate um mour. Douk namudok aria eik ta inek maresh? Eik madae dodogoiwe um irok nuwagas um uwe. Aria shopunek, eik douk abraenyiwe um inak ihawar kupaishi arpesh um shuke eshudok eneshenesh um. ");
INSERT INTO apec_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Aria douk eik yadukemesh um eshudok douk ta eik inekesh iri um abudok nyutob eikin debeini niyate um mour um, arpesh ta wata shurae inak um esheshig urusag.’ ");
INSERT INTO apec_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","“Douk namudok aria anan nahwar ihishmorim arpesh douk shenek dinau um ananin debeini iri shanaki shatrun. Aria anan narik sagomatinyin nakri, ‘Nyak nyenek dinau um makwunish eshudok eneshenesh eikin debeini ananish?’ ");
INSERT INTO apec_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","“Aria anan nakripan nakri, ‘Eik yenek dinau um 100-poreish welish drepahos douk shenegor rowos shahwaragas um oliv iri.’ “Aria anudok nasuhw merik iri nakripan nakri, ‘Arigah nyunak nyuhur apudok shup um eshudok eneshenesh nyak nyenek dinaumesh iri shetem um aria wata nyuwem 50-poreish atish.’ ");
INSERT INTO apec_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","“Aria wata shopunek kupaini nanaki natogruman aria narigan nakri, ‘Nyak nyenek makunin dinau?’ “Aria anan nakripan nakri, ‘Eik yenek dinau um 100-poreigas begas um wit douk shenek plaua-agasi.’ “Aria anan nakripan nakri, ‘Nyak nyunak nyuhur apudok shup um eshudok eneshenesh nyak nyenek dinaumesh iri shetem-opi aria wata nyuwem 80-poreigas begas atugas.’ ");
INSERT INTO apec_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Aria anudok debeini natuk anudok nenek rohw nasuhw merik iri ananin nyeigur nyato iruhw. Um maresh? Anan douk gamo nadukemesh aria nenenek anah yopihi yah um nutaurum amudok armam nabouk amamin dinau nyagokuk um nenekam hanadudareh aria kweipon amam ta wata hutauruman. Eshudok arpesh shagipesh agundok atapihi aih aria shukonaguk agabus Iruhin iri, eshesh douk ta gamo shudukemesh um shuni kupaishi shakonaguk agabus Iruhin iri shunek enenyenen mour um. Eshesh douk sheshagrakuk Iruhin ananish arpesh douk sharahaen arisigunum iri um shenek mour um.” ");
INSERT INTO apec_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Aria Jisas ta nakri namudok, “Adur atin eik yakripep, ipak ta pukesh ipakibor utabor kupaishi arpesh um putaurumesh aria punekesh shutogur ipakish arpesh. Ipak punekesh namudok aria kweipon ipakibor utabor butuh um, ipak ta pugok aria punak pupe wosik ihih nyumneh gani iruhw heven. ");
INSERT INTO apec_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“Eshudok arpesh douk shusuhw karowish eshudok eneshenesh aria shunak shiyohesh wosik iri, eshesh ta shunodukem um eshesh kanak um shusuhw sabaishi eshudok eneshenesh shiyohesh. Aria eshudok douk shunek shokwinyi mour aria shunek rohw um, eshesh shunek debeini mour um, eshesh ta shunek rohw namudok atin. ");
INSERT INTO apec_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Aria ta ipak mare gamo piyoh agnudok atapibor utabor wosik um, ipak ta omi nyukep yopishi eshudok eneshenesh douk shakus iruhw heven iri um piyohesh? Adur atin ta uwok. ");
INSERT INTO apec_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Aria ta ipak mare gamo pubuk kupaishi esheshish eshudok eneshenesh um, ipak ta wata omi nyukep ipakish eshudok eneshenesh? Adur atin ta uwok. ");
INSERT INTO apec_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Ta mare enen arpen nyenek mour iri ta nyunek mour um biom debeimi. Douk enyen nyunek mour um biom um, enyen ta nyukri uwok um anan, aria ta urkum munawasham anan. Aria enyen ta nyumnek anan ananin baraen aria anan ta mare nyumnekan. Aria ipak douk gamo punadukemesh um ipak kanak um mare punek mour um Iruhin nini utabor shopunek uwe, uwok.” ");
INSERT INTO apec_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Douk amam Farisi hemnek namudok aria hape henekan enenyenen um Jisas. Um maresh, amamip urkwip douk panakri utabor abom. ");
INSERT INTO apec_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Aria Jisas nakripam nakri, “Ipak pakri punek ipakihi yopihi aih agundok kupaishi arpesh shapeum shutrip aria shuhwarep yopishi arpesh. Aria Iruhin douk nadukem ipakip urkwip por panak um. Eshudok douk arpesh shatrish aria mishish shakitakumesh abom iri, eshudok douk Iruhin natrish aria nakri yoweishi abom. ");
INSERT INTO apec_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Aria enyudok lo seiwok Iruhin nakoguk Moses-enyi nyani amam profet hakripesh-enyi baraen nyape dodogowin arigaha nyanak nyatogurum abudok nyutob Jon douk nenek baptaisumesh iri natogur napeum. Aria abudok nyutob banaki arigaha douk, eshesh shape shakripesh Iruhin ananin yopinyi baraen um arpesh shuwish um agundok Iruhin nape Debeini um ananish arpesh um ihirub warub. Aria ihishmorim arpesh shape shenek debeinyi mour dodogowish atish um shakri shuwish. ");
INSERT INTO apec_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","“Iruhw atap ta shunak shuwishuk. Aria enyudok lo douk seiwok Iruhin nakoguk Moses enyi ta mare anabik shokugun meyoh nunak nuwishuk uwe, uwok.” ");
INSERT INTO apec_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Aria anan arman nubrig shanaraum um ananik armatok aria wata nukri nurao kupaikwi um, anan douk nabrig enyudok lo um shanaraum um. Aria ta anan arman nurao onok armatok douk seiwok okwokwin arman neyatok kwape iri um, anan douk nabrig enyudok lo um shanaraum um.” ");
INSERT INTO apec_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Aria Jisas nakripesh enen baraen nakri, “Anan debeini douk nagrem sabaishi eshudok eneshenesh iri nape. Aria ihih nyumneh anan nenek yopihi atih rupeh douk shatorih debeibori utabor iri. Aria anan nape wosik aria napeum nawok yopuguni atugun worigun. ");
INSERT INTO apec_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Aria agundok anan nanahwaram Lasarus iri douk eneshenesh wokan iri um shopunek nape. Anan sabaibi ereb bapenyan aria sharanum nanak nape adukitum wit um anudok debeini ananirub narub. ");
INSERT INTO apec_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Anan nape agundok um nakri nunatorum tutukwanigun worigun anudok debeini nunekesh shagrukuk iri. Aria shopunek, nubag gwanaki gwape gwabiyak ananib ereb. ");
INSERT INTO apec_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Douk Lasarus nape arigaha anan nagok aria Iruhin ananish enselahos sharanum nanak nani Abraham hape agundok douk Iruhin ananish arpesh shagok shanak shapenyaburi wabur. Aria anudok debeini shopunek nagok aria sharuman. ");
INSERT INTO apec_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Aria anan nanak nape agundok shagok iri shanak shapeum. Aria agundok, anan nanomnek debeiri eriger aria natrugunu aria natik Abraham nani Lasarus hapeiri rougun. ");
INSERT INTO apec_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Douk namudok aria nahwar Abraham nakri, ‘O yamenen Abraham, nyak nyukri gihaum eik aria nyishopok Lasarus nuseguri ananih hah abar aria nunaki nubuwehume yaham. Um maresh, ehudok debeihi nyih hanuwe abom aria yanamnek debeiri eriger!’ ");
INSERT INTO apec_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“Aria Abraham nakripan nakri, ‘O baruhon, douk nyak urkum mormoguk seiwok. Seiwok nyak nyape nyarahaen amnab um, nyak nyarao ihishmorim yopishi eshudok eneshenesh. Aria Lasarus narao ihishmorim yoweishi. Aria douk abrudok wabur ananihw apahw hwape wosik aria nanadudareh. Aria nyak nyape um nyenemnek debeiri eriger. ");
INSERT INTO apec_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Aria shopunek, orokohun um apak mani ipak, Iruhin nenek anat debeiti baret tabuhuk gani atap. Douk namudok aria arpesh shupe agundok iri shukri shubi-shuwis shunaku nagundok ipak pape um, eshesh ta shubirak shutik uwok. Aria arpesh shupe nagundok iri ta mare shubi-shuwishi aria shunaki agundok apak mape um uwe, uwok.’ ");
INSERT INTO apec_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“Aria anudok debeini nakri, ‘Douk namudok aria Abraham, eik yakripen, nyak nyishopok Lasarus nunak um eikin yaken ananit urupat. ");
INSERT INTO apec_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Anan nunak nukripugu eikim 5-poreim owarhim dodogowinyi baraen. Um maresh, ta wosik atin aria amam shopunek mare hunaki abrudok wabur douk shenemnek debeiri eriger um.’ ");
INSERT INTO apec_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","“Aria Abraham nakripan nakri, ‘Amam douk harao okwudok Buk douk seiwok Moses nani amam profet howem Iruhin ananin baraen nyetemok iri. Aria amam ta hutrin hugipeshen aria enyen ta nyutaurumam.’ ");
INSERT INTO apec_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","“Aria anan nakri, ‘Uwok, yamenen Abraham! Enyudok baraen atin ta mare nyutaurumam. Douk enen nyagok iri wata nyukitaki wonugwehw nyunak nyukripam akure, amam ta hukeshuk agabus yoweishi inahos aria hutanam hukon aparuh Iruhin.’ ");
INSERT INTO apec_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","“Aria Abraham nakripan nakri, ‘Douk amam mare humnek Moses nini amam profet amamin baraen husuwen hugipeshen um, enen nyagok iri arpen wata nyukitaki wonugwehw aria nyunak nyukripam-umen iri baraen shopunek ta mare humneken aria hukenyuk agabus yoweinyi uwe, uwok!’” ");
INSERT INTO apec_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Aria Jisas nakrip ananim disaipel nakri, “Eshudok eneshenesh douk ta shunek arpesh shunek yoweishi inahos iri ta shutogur. Aria enyudok arpen douk nyunek kupainyi nyunek yoweishi inahos iri, enyen douk ta gihaumen. ");
INSERT INTO apec_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Aria enen arpen nyunek enen um eshudok shokwishi batowish um nyunek yoweishi inahos um, enyen douk nyenek yoweishi inahos abom. Aria ta shusuhwen shuwaur anam debeimi utom enyenyin aruhwigur aria shuwashen nyubuhuk youg akure, enyen ta nyupe yoweinyi poe. Aria Iruhin ta neneken nyumnek debeiri eriger abom reshagrakuk agundok nyumnek eriger um shuwashen nyubuh youg um. ");
INSERT INTO apec_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Aria ipak gamo pudukemesh. Aria enen Kristen nyukri nyunek enesh yoweishi inahos um, ipak ko puhen. Aria enyen wata nyukeshuguk agab yoweishi inahos aria nyutanam nyukon apahw Iruhin um, pukweshiheshuk eshudok yoweishi inahos enyen nyenekesh iri. ");
INSERT INTO apec_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Aria ta enyen nyunekumen enesh yoweishi inahos arigaha nyudareheh hunak hutogur 7-poreih um anah nyumnah, aria enyen wata nyunaki 7-poreih um nyukripen um nyukri enyen nyakutukuk eshudok yoweishi inahos enyen nyenekesh um nyak iri um, nyak mare nyusuhwesh nyupe eshudok enyenyish yoweishi inahos aria nyutoriheshuk um enyen.” ");
INSERT INTO apec_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Aria amam aposel hakrip Debeini hakri, “Nyak nyunek apakin bilip nyutogur dodogowin.” ");
INSERT INTO apec_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Aria Debeini wata nakripam nakri, “Ipak pugipesh Iruhin wosik aria ipakin bilip ta nyutogur shokwin abom aria kabi douk anam shokumi mastetim shurkum um akure, ipak ta pukrip epudok shuruwep peirenyi rowog pukri, ‘Nyunatuk um nukwaruh nyunak nyubuh youg aria wata nyukih.’ Aria adur atin, enyen ta nyugipesh ipakin baraen.” ");
INSERT INTO apec_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Aria ipak anan nenekumen mour meyoh iri nunak nupe nuwor amnab nubarig o niyoh sipsipahos. Aria douk nuneguk mour jurug aria wata nutanamori atin aria ta wosik nyukripan um arigas nunaki nupe nuwok worigun aka mumam? ");
INSERT INTO apec_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Adur atin ta uwok. Nyak ta nyukripan namudok, ‘Kare nyuwashak yopuhi rupah aria nyunak nyunek redimeim eikigun worigun aria nyunaki nyuke-agun ba ignah. Aria nyak nyupe nyubeime ba iwok eikigun iyatagun aria nyak kadak nyuwok nyakigun.’ ");
INSERT INTO apec_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Aria nyak ta nyunek tenkyu um anudok nenekumen mour meyoh iri um agundok nagipesh nyakin baraen um o ta uwok? Aria ta uwok. ");
INSERT INTO apec_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Douk namudok aria ipak shopunek ta punekesh namudok atin. Aria ipak punek enyudok mour douk Iruhin nakripep um puneken iri piyaten um, ipak ta pukri, ‘Apak douk nyeiguhw wokap mape shakamum Iruhin munek mour meyoh iri. Apak douk menek anan nakripap um muneken iri atin.’” ");
INSERT INTO apec_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Aria Jisas nape nanak um Jerusalem. Anan nagim yah nawish nanak orokohun-igum agudok biyog shokugi nahobig Samaria aria Galili. ");
INSERT INTO apec_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","13","Aria douk nanak arigas um nunak nuwish anabur wabur aria 10-poreim armam arugeh lepra hapenyam iri hanaki haparugan. Aria amam wata heyoturi rougun aria hahwarari debeg hakri, “Jisas, Debeini, nyak nyukri nyenek gihaum apak!” ");
INSERT INTO apec_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Aria douk Jisas natrumori aria nakripam nakri, “Ipak kare punak puyabigom ipakiruh yegeshiweruh amam pris.” Aria amam hatanam hanak atin, aria arugeh lepra hanakuk abom aria amamiruh yegeshiweruh wata yopuruh. ");
INSERT INTO apec_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Aria anan natik um anan wata yopun aria anan wata natanam nanak aria nahawar debeg atin nape natuk Iruhin ananin nyeigur nyato iruhw. ");
INSERT INTO apec_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Aria nanak nabuh noduk yomag nakus atap hurukatin um Jisas neyotu um aria nenek tenkyuman. Anudok arman, anan douk anan um eshesh Samaria. ");
INSERT INTO apec_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Aria Jisas natik namudok aria nakri, “Iganigadae yagabe 10-poreim. Aria amudok anam 9-poreim hapeik agnum? ");
INSERT INTO apec_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Maresh namudok um anudok kupaibi amnabin atun natanamori nanaki nenek tenkyu um Iruhin um?” ");
INSERT INTO apec_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Aria Jisas nakripan nakri, “Kitak kare. Nyak nyenek bilip nyakri eik dodogoiwe iri aria douk yopin.” ");
INSERT INTO apec_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Aria anah nyumnah amam Farisi harig Jisas um ta meibi nyutob um arpesh shuwish agundok Iruhin nape Debeini um ananish arpesh um ta butogur. Aria anan nuwanamam baraen nakri, “Agagun ta mare enesh arpesh shutrugun shudukem-agun kabi douk shatik enesh eshudok shadukemesh um uwe, uwok. ");
INSERT INTO apec_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Ta mare shukri, ‘Tik, natogur agundok o natogur ganik.’ Um maresh? Iruhin nape Debeini um arpesh shuwish agundok anan nape Debeini um ananish arpesh um douk iganigadae nape numunipum.” ");
INSERT INTO apec_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Aria anan nakrip ananim disaipel nakri, “Nyutob butogrum, ipak ta mishish shukitak um pakri putik anah nyumnah eik Anudok Arman douk yatogur adurinyi arpen iri itanamori ipe debeiwe iri aria itrugun abom ahi. Aria ipak ta mare putruh. ");
INSERT INTO apec_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Aria arpesh ta shukripep shukri, ‘Krais natanamori. Wata tiku, nani nape gani.’ O ta shukri, ‘Anudok nape agundok!’ Aria eik yakripep. Ipak mare punak pugipeshesh uwe, uwok. ");
INSERT INTO apec_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Ipak padukemesh um agundok utag gatrugun obi nyutob. Agag gatrugun abom kabi aun nakihumori arigaha ganak gabuh aun nabuhum. Aria eik Anudok Arman douk yatogur adurinyi arpen iri ta inekesh namudok atin abudok nyutob eik ta itanamori um. Ihishmorim arpesh ta shitiwe. ");
INSERT INTO apec_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Aria sagomatin eik ta imnek debeiri eriger aria doukish arpesh ta shukeik agabus iyoh. ");
INSERT INTO apec_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","“Eneheneh aih douk shenekeh abudok nyutob seiwok Noa nape obi nyutob, ehudokmori atin ta shenekeh abudok nyutob hurukatin um eik Anudok Arman douk yatogur adurinyi arpen iri ta itanamori obi nyutob. ");
INSERT INTO apec_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Ihishmorim arpesh shapeum shawok worigun aria abar iri, aria armam armago shanaraum. Eshesh shape shenekesh namudok arigaha ahudok nyumnah Noa nawish korohuk aria abar babo ihishmorim arpesh beyateshuk. ");
INSERT INTO apec_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","“Aria shopunek, abudok nyutob seiwok Lot nape obi nyutob douk shenekesh namudok atin. Shapeum shawok worigun, shawok abar, shator eshudok eneshenesh, shenek salim um eshudok eneshenesh, shau eneshenesh nubarig, aria shanarok urusag. ");
INSERT INTO apec_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Aria douk arigaha ahudok nyumnah Lot nakutukuk wabur Sodom nanakuk aria Iruhin nenek nyih iri juwehosibori utabor salfa shagruk iri iruhw utag. Eshesh shagruki kabi douk eshah hormori aria shabuhi shabo ihishmorim arpesh shagok shatuh. ");
INSERT INTO apec_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","“Aria abudok nyutob eik Anudok Arman douk yatogur adurinyi arpen iri itanamori yopugunum obi nyutob, arpesh shopunek ta shenekesh namudok atin. ");
INSERT INTO apec_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Ahudok nyumnah, arpen nyupe aduk urupat iri ta mare wata nyuwish um nyunohuri enyenyish eshudok eneshenesh. Aria enyudok douk nyeyotu nubarig iri ta mare wata nyutanam nyunak um urupat um nyunohuri eshudok eneshenesh uwe, uwok. ");
INSERT INTO apec_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Ipak urkwip puramaguk Lot ananik irohukwik. ");
INSERT INTO apec_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Eshudok arpesh douk urkwip purum shukri eshesh kanak shupe wosik um, aria mare shusuhw eikin baraen shugipeshen iri ta shunak shuwishuk. Aria eshudok douk madae urkwip purum eshesh kanak uwe aria shugipesh eik iri ta shupe wosik.” ");
INSERT INTO apec_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Aria Jisas nakri, “Eik yakripep, abudok wab, biom armam ta hishuh atus aras. Anan ta inaran aria anan ta nishuhuk. ");
INSERT INTO apec_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Aria bio armago ta upe unek plaua um uweh bret um. Aria onok ta inaraok aria onok ta kwupeik. ");
INSERT INTO apec_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Aria biom armam ta hiyotu nubarig. Aria anan ta inaran, aria anan ta niyotuguk.” ");
INSERT INTO apec_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Aria Jisas ananim disaipel hemnek namudok aria harigan hakri, “Debeini, enyudok ta nyutogur agnum?” Aria Jisas neyagwreh nakripam wobuwobren baraen nakri, “Agnudok douk mahish shagok shakus um, armiguhw ta apa hwanaki hwanatorumori um.” ");
INSERT INTO apec_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Aria Jisas nakrip ananim disaipel enyudok wobuwobren baraen um nunek skulumam um hunek beten ihih nyumneh aria mare hukutunuk atin. ");
INSERT INTO apec_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Aria nakripam nakri, “Anabur wabur, anan jas douk nasuhw kwotog iri nape. Anudok jas madae nunogugur Iruhin atun uwe, uwok. Aria anan madae nukri gihaumesh atin uwe arpesh o nunoguguresh uwe, uwok. ");
INSERT INTO apec_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Aria abrudok atubur wabur onok armatok anan nagok nokusopuk iri kwape. Ihih nyumneh okwok kwape um kwanak um anudok jas aria kwakripan kwakri, ‘Anan eikin horin nenek rohwume aria nenek kwotume meyoh. Aria eik yakri nyak nyutaurume um kwot.’ ");
INSERT INTO apec_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","“Aria roubum nyutob anudok jas nemnek okwokwin baraen aria nakri uwok um nutaurumok. Aria arigaha anan nenek urkum aria nakri, ‘Adur, eik douk madae inogugur Iruhin uwe, o madae inogugur arpesh aria ikri gihaumesh atin uwe. ");
INSERT INTO apec_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Aria okwudok armatok kwanaki kowemume abudok bugob aria nyunekesh. Eik ta itaurumok um kwot. Uwok um, okwok ta kwupe um ta kwunaki atin kwunaki aria eik ta arigeh heimok abom!’” ");
INSERT INTO apec_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Aria Debeini nakripam nakri, “Ipak ta pumnek enyudok baraen anudok yoweini jas nakriyen iri. ");
INSERT INTO apec_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Aria ipak pakri mumam? Eshudok arpesh douk Iruhin nanagraehesh um shupe ananish iri shukri shureh shubeiman nyumnah wab um nutaurumesh um, anan ta mare nutaurumesh arigas uwok? ");
INSERT INTO apec_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Adur atin eik yakripep, anan ta nutaurumesh arigas um enyudok rohwinyi baraen. Aria abudok nyutob eik Anudok Arman douk yatogur adurinyi arpen iri itanamori abudok amnab obi nyutob, ipak pakri eik ta itik um arpesh douk shenek bilip um eik iri o uwok?” ");
INSERT INTO apec_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","10","Enesh arpesh douk shakri eshesh atish douk shugipesh lo atin iri arpesh shapeum shenek yopihi aih atih iri aria shakri ihishmorim kupaishi douk yoweishi. Douk namudok aria Jisas nakripesh enyudok wobuwobren baraen nakri, “Biom armam hato um Iruhin ananit debeiti urupat um hunek beten. Anan Farisi aria anan narao takis iri. ");
INSERT INTO apec_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Aria Farisi nakitak neyotu aria numun ananin urkum atin nenek beten nakri, ‘Iruhin, eik yenek tenkyumen. Um maresh? Eik douk madae kabi ihishmorim kupaishi arpesh douk shenek yoweishi inahos iri uwe. Enesh shakwu orugwih iri. Enesh shenek wehrur iri, aria enesh madae shugipesh lo atin iri uwe. Aria shopunek, eik douk madae kabi nani yoweini arman narao takis iri uwe. ");
INSERT INTO apec_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Ihig wik, biyeh nyumneh eik apa yeshakur um worigun aria yape yenek beten atin. Aria ihishmorim eshudok eik yaparugesh iri, eik apa yosiyaesh aria yeken anabigishum nyak!’ ");
INSERT INTO apec_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“Aria anudok narao takis iri neyotukuk rougun aria madae karowih atin nupuhur nutik iruhw heven uwe, uwok. Anan neyotu aria nape naguduk mishin aria nakri, ‘Iruhin, eik yenek eneshenesh yoweishi inahos iri. Nyak gihaume!’” ");
INSERT INTO apec_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Aria Jisas nakri, “Eik yakripep. Iruhin douk natik anudok narao takis iri aria nahwaran nagipesh lo atun iri arman aria anan wata natanam nanak um ananit urupat. Aria anudok Farisi uwok. Um maresh? Arpesh douk shutuk esheshish nyeiguhw shuto iruhw iri, Iruhin ta nesh shubuhuk. Eshudok douk madae shutuk esheshish nyeiguhw shuto iruhw iri uwe, Iruhin ta nutuk esheshish nyeiguhw shuto iruhw.” ");
INSERT INTO apec_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Aria enesh arpesh sharauri esheshish shokwishi batowish um Jisas um nuwemesh wis aria nunekumesh yopihi aih. Aria douk ananim disaipel hatik namudok aria hahaesh. ");
INSERT INTO apec_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Aria Jisas nahwari eshudok shokwishi batowish shanaki hurukatin um anan aria nakri, “Ipak kutukuk shokwishi batowish shunakumori eik. Um maresh? Eshesh ta shuwish agundok Iruhin nape Debeini um ananish arpesh um. ");
INSERT INTO apec_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Eshudok arpesh douk shakri uwok um Iruhin nupe esheshin debeini kabi douk batowish shakri wosik um, eshesh ta mare shuwish agundok Iruhin nupe Debeini um ananish arpesh shapeum uwe, uwok.” ");
INSERT INTO apec_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Aria anan eshesh Juda esheshin debeini narig Jisas nakri, “Yopuni Tisa! Eik ta inek maresh aria ta douk ipe wosik abom ihih nyumneh?” ");
INSERT INTO apec_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Aria Jisas nakripan nakri, “Nyak nyahware yopuweiri um maresh? Iruhin atun douk yopuni. ");
INSERT INTO apec_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Nyak douk nyadukemen enyudok lo douk nyetem Iruhin ananik Buk iri. Enyen douk nyakri, ‘Ipak mare punek wehrur, mare pubo kupaishi arpesh shugok, mare pukwuaruh, aria mare punek rohw atin. Aria ipak pumnek ipakish amakenyish esheshin baraen aria putaurumesh.’” ");
INSERT INTO apec_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Aria anudok arman wata nakrip Jisas nakri, “Seiwok eik wata shokuwe um, arigaha douk, eik yasuwen dodog enyudok ihinyumorim lo aria yagipeshen.” ");
INSERT INTO apec_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Aria douk Jisas nemnek namudok aria wata nakripan nakri, “Nyak douk atuh aih wata hape, nyak wata nyunekah uwe. Nyak nyunak nyuhur ihishmorim nyakish eshudok eneshenesh nyuko kupaishi shutorish shuken utabor. Aria nyak wata nyisiyabor um yaruhish arpesh. Nyak nyunekesh namudok aria sabaishi yopishi eshudok eneshenesh ta shukusumen iruhw heven. Aria douk nyunekeshuk namudok ba iyoh, aria nyak douk nyunaki nyugipeshe.” ");
INSERT INTO apec_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Aria anudok arman nemnek namudok aria anan apahw amaenyihw abom. Um maresh? Anan douk nanabuk sabaishi eshudok eneshenesh abom. ");
INSERT INTO apec_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Aria Jisas natik um anan apahw yowehw abom um aria nakri, “Eshudok arpesh douk shagrem sabaishi eneshenesh eshudok iri shukri shuwish abrudok wabur Iruhin nape Debeini um ananish arpesh um, eshesh ta shunek debeinyi mour iyoh, aria ta kadak shuwish. Uwok um, ta uwok. ");
INSERT INTO apec_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Aria enen debeinyi mahin nyeigurinyum kamel iri nyukri nyuwish nyil douk umunihw um tret tananyigur um, enyen ta nyunek debeinyi mour aria douk ta nyuwish. Aria eshudok arpesh douk shanabuk sabaishi eshudok eneshenesh iri shukri shuwish abrudok wabur Iruhin nape Debeini um ananish arpesh um, eshesh ta shunek debeinyi mour abom shishagrakuk kamel aria kadak shuwish. Uwok um, ta uwok.” ");
INSERT INTO apec_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Aria eshudok arpesh douk shape shemnekan neyagwreh iri sharigan shakri, “Douk namudok aria Iruhin ta wata nunarao meishi arpesh shutanamori shupe wosik abom?” ");
INSERT INTO apec_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Aria Jisas wata nakripesh nakri, “Eshudok douk arpesh shubirak um shunekesh aria shubirak um shutik uwok iri, Iruhin anan atun ta nunekesh.” ");
INSERT INTO apec_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Aria Pita nakri, “Tik, apak douk makutukuk apakirub warub bani ihishmorim eshudok eneshenesh aria enyudok manaki magipeshen.” ");
INSERT INTO apec_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","30","Aria Jisas nakripam nakri, “Adur atin eik yakripep amudok armam douk amamip urkwip porum hukri Iruhin nupe debeini um amam um abrudok wabur arpesh shuwish um Iruhin nupe Debeini um aria douk hukutukuk amamirub warub o amamiyu armago o ashukenyish owashish o amakenyish o batowish iri, Iruhin ta nunekumam enyudok. Douk abudok amnab Iruhin ta nukom sabaishi eshudok shishagrakuk eshudok douk amam hakutishukuk iri. Aria kweipon shopunek, amam ta hupe wosik abom ihih nyumneh.” ");
INSERT INTO apec_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Aria Jisas narao ananim 12-poreim disaipel hanak anagas aria nakripam nakri, “Mnek! Douk apak ta muto munak um Jerusalem. Aria ihinyumorim baraen douk seiwok amam profet henyemaguk um eik Anudok Arman douk yatogur adurinyi arpen iri ta nyutogur adurin. ");
INSERT INTO apec_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","33","Eshesh ta shukam eik amudok douk madae hudukem Iruhin iri uwe. Aria amam ta hurae hububunime, hukwusehe aria ta huneke enenyenen. Aria amam ta hureye madururuh aria he igok. Aria douk hukri um biyeh atih nyumneh um, eik ta wata ikitaki ipe.” ");
INSERT INTO apec_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Aria douk amam disaipel hemnek ananin baraen aria amam madae hudukemen uwe. Baugenyum baraen nyanabeshuk um amam. Douk namudok aria eshudok douk Jisas nakripam-umesh iri amam madae hudukemesh uwe. ");
INSERT INTO apec_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Aria Jisas nanak natogur hurukatin um wabur Jeriko aria anan nabes seshukanari nape anagasih um yah. Anan apa nape nahwar arpesh um shukon utabor. ");
INSERT INTO apec_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Aria douk nemnek um eshudok sabaishi arpesh shanaki um shishagrakan shunak aria anan narig nakri, “Yaipo shenek maresh?” ");
INSERT INTO apec_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Aria eshesh shakripan shakri, “Jisas napeiri wabur Nasaret iri nanaki.” ");
INSERT INTO apec_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Aria anan nemnek namudok aria nahwar nakri, “Jisas, Devit ananin barhonin! Nyak nyukri nyenek gihaum eik!” ");
INSERT INTO apec_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Aria eshudok sharig iri shahan shakripan um mokureg. Aria anan nuhwar debeg abom nakri, “Devit ananin barhonin! Nyak nyukri nyenek gihaum eik!” ");
INSERT INTO apec_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","41","Aria Jisas nemnek namudok aria neyotu aria nakripesh nakri, “Arigah harokanari punaki agundok.” Aria douk sharani aria Jisas narigan nakri, “Nyak nyakri inekumen maresh?” Aria Anan nakrip Jisas nakri, “Debeini, eik yakri um ta inatrugun.” ");
INSERT INTO apec_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Aria Jisas nakripan nakri, “Trugun, nyak nyenek bilip nyakri eik dodogoiwe iri aria nyakis nabes douk ta yopus.” ");
INSERT INTO apec_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Aria ahudok atuh nabes yopus natrugun aria nani Jisas hanak. Aria anan nape nanadudareh um Iruhin natuk ananin nyeigur nyato iruhw. Aria eshudok sabaishi arpesh shopunek shatik namudok aria eshesh ihishmorim shatuk Iruhin ananin nyeigur nyato iruhw. ");
INSERT INTO apec_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Aria Jisas nawish nanak abrudok wabur Jeriko aria anan nanak um nakri nukutuburuk nugim yah nunak. ");
INSERT INTO apec_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Aria anan arman shahwaran um Sakias iri nape abrudok wabur. Anan douk debeini um amam harao takis iri. Aria anan douk nanabuk sabaibori utabor iri. ");
INSERT INTO apec_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Aria Sakias nakri nutik Jisas um nudukemesh um anan douk meini. Aria sabaishi arpesh shatatapanuguk aria anan madae nutrun uwe. Um maresh? Sakias shopunek douk banani arman abom. Namudok aria anan nabirak um nutik Jisas aria nabirak natik uwok. ");
INSERT INTO apec_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Douk namudok aria anan nahur narik atin nanak nato enen rowog nyeigurinyum fik iri um nakri nutik Jisas. Um maresh? Anan nadukemesh um Jisas ta nunak ahudok yah. ");
INSERT INTO apec_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Aria douk arigaha Jisas nanak natograri okwudok outuk aria napuhur natik iruhw aria nakri, “Sakias, buhi arigas. Doukih nyumnah, eik ta inak ipe nyakit urupat.” ");
INSERT INTO apec_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Aria Sakias arigas atin nabuhi atap aria nanak nanadudareh um Jisas. Aria amam hanakum Sakias ananit urupat. ");
INSERT INTO apec_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Aria douk ihishmorim arpesh shatik namudok aria shape sheneyagwreh shoku shokwin baraen um Jisas shakri, “Anudok arman nanak neshuh anudok nenek yoweishi inahos atish iri ananit urupat.” ");
INSERT INTO apec_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Douk amam hanak urupat aria Sakias nakitak neyotu nakrip Debeini nakri, “Debeini, nyak muneke. Douk eneshenesh eikish eshudok ta isiyaesh um biyeh. Wobresh ta iko yaruhish arpesh iri. Aria nubokuhi ikri inek rohw um enen arpen inaruken enesh enyenyish eshudok eneshenesh meyoh um, douk ta wata ibeyeshamen aria ta wata iken enesh shopunek arigaha idareheh um 4-poreih.” ");
INSERT INTO apec_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Aria Jisas nakripan nakri, “Doukih nyumnah, Iruhin wata nanaraep ipak ihipmorim pape atudok urupat iri patanamori pape wosik. Um maresh? Nyak shopunek douk nyakitak apudok atup awirop Abraham ananip. ");
INSERT INTO apec_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Umum maresh? Eik Anudok Arman douk yatogur adurin arpen iri douk yanakumori itik um eshudok arpesh douk shanak shawishuk iri um itaurumesh inaraesh shutanamori shupe wosik.” ");
INSERT INTO apec_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Aria abudok nyutob eshesh shape shemnek enyudok baraen Jisas nakrip Sakias um, aria Jisas shopunek nakripesh enen wobren baraen. Um maresh? Anan douk nanaki hurukatin um Jerusalem. Aria eshesh shakri ta abudok nyutob um arpesh shuwish agundok Iruhin nupe Debeini um ananish arpesh um ta butogur douk atin aria Jisas ta nupe esheshin debeini. ");
INSERT INTO apec_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Aria anan nakripesh nakri, “Anan debeini arman nakri nunak um anabur rougunibur wabur um shunekan king aria ta wata nutanamori um ananibur wabur. ");
INSERT INTO apec_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Aria hurukatin um nunak obi nyutob, anan nahwari ananim 10-poreim armam douk henekuman mour iri hanaki aria nokomuk 20 kina 20 kina amam atun atun. Aria nakripamuk nakri, ‘Ipak punak punek bisnis kupakupai-gunum atin um abrudok utabor eik yekepabor iri aria punek winmoni-ibor. Ipak punak pupe punekesh namudok arigaha eik wata itanamori.’ ");
INSERT INTO apec_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","“Aria eshudok arpesh douk shani anan shape atub amnab iri shakri uwok um anan. Douk namudok aria anan narik aria eshesh sheshopok anam harao baraen hagipeshan. Amam hanak aria hakri, ‘Apak makri uwok um anan nupe apakin king um.’ ");
INSERT INTO apec_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Aria eshesh madae shumnekam uwe aria shenekan king aria wata natanamori. Anan natanamori atin aria nenekumam baraen amudok henekuman mour iri douk nukomuk utabor iri um hunaki hutrun. Aria nakri norigam um amam atun atun henek makwunibor winmoni-ibor utabor. ");
INSERT INTO apec_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","“Aria narik iri natograri aria nakri, ‘Debeini, eik meyoh enyudok 20 kina nyak nyekeyenyuk iri yenek bisnis aria profetin douk nyatogur 200 kina!’ ");
INSERT INTO apec_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","“Aria anudok king nakri, ‘Nyak yopuni arman nyenekume mour iri. Nyak nyeneken wosik abom. Eshudok eshesh douk karowish meyoh, aria nyak apa nyeyohesh wosik atin. Namudok aria nyak ta ineken um nyupe debeinyi aria nyiyoh 10-poreirub debeirubi warub.’ ");
INSERT INTO apec_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","“Aria douk narik iri nanakuk aria anudok anan nanaki nakri, ‘Debeini, eik meyoh enyudok 20 kina nyak nyekeyenyuk iri yenek bisnis aria profetin douk nyatogur 100 kina.’ ");
INSERT INTO apec_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Aria king nakripan nakri, ‘Nyak ineken um nyupe debeinyi nyiyoh 5-poreirub debeirubi warub.’ ");
INSERT INTO apec_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Aria anudok anan nenekuman mour iri nanaki nakri, ‘Debeini, nyakibor utabor 20 kina abrudok. Eik yetapeyen rupahip aria yenyubuk nyakus. ");
INSERT INTO apec_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Um maresh? Nyak douk juwehosinyi atin iri, aria eik yanogugur abom. Yanogugur abom um eneshenesh kupaishi sheneshubuk iri, nyak apa nyanashuhur. Nyak madae nyorig atin uwe. Aria worigun kupaishi shanuwesh iri, nyak apa nyanaurimesh.’ ");
INSERT INTO apec_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","“Aria king nakripan nakri, ‘Nyak yoweini arman abom nyenekume mour iri. Eik ta ikwu nyak kanak nyakin baraen douk nyak nyakriyen um eik iri aria inekumen kwot. Nyak douk nyadukemesh um agundok eik juwehosiwe atuwe abom um. Aria yatrish yonahur eshudok kupaishi sheshubuk iri um. Aria yatrish yanaurim worigun kupaishi shanuwesh iri um. ");
INSERT INTO apec_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Douk namudok aria nyak madae nyunak nyuborur-ume um benk uwe? Um eik wata itanamori aria inak inaboruhur um, eik irao anabor profetibor shopunek.’ ");
INSERT INTO apec_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","“Douk namudok aria king nakrip eshudok arpesh sheyotu agundok iri nakri, ‘Putrun enyudok 20 kina aria puko anudok anan douk nasuhw 200 kina iri.’ ");
INSERT INTO apec_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","“Aria eshesh shakrip anudok king shakri, ‘Debeini, anan douk wosik nasuhw sabaibori um 200 kina.’ ");
INSERT INTO apec_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","“Aria anan nakri, ‘Eik yakripep, ihish arpesh douk shusuhw sabaishi eshudok iri ta wata shukesh enesh shopunek. Aria eshudok douk eshudok wokeshi, eshudok karowish eshesh sheneshubuk iri, eshesh ta wata shutrishesh aria shupeik meyoh abom. ");
INSERT INTO apec_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Aria douk ipak purauri eshudok eikish horim douk shakri uwok um eik ipe esheshin king iri punaki agundok eik yape um itrish aria pesh shugok.’” ");
INSERT INTO apec_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Aria douk Jisas nakripeshuk enyudok wobuwobren baraen um jurug, aria nakitak narik nape nagim yah nanak um Jerusalem. ");
INSERT INTO apec_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Douk nanak arigaha hurukatin um abrudok biarub warub Betfage aria Betani, douk bape hurukatin um yoduhw Oliv iri aria nakrip biom disaipel harik hanak. ");
INSERT INTO apec_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Aria nakripam enyudok baraen nakri, “Ipak purik punak babri wabur bape gani yah iri. Ipak ta punak puwish atin aria ta putik enen nugaen donki douk shoreyen maduhw aria shenyuseh nyeyotu. Enyudok donki douk watak enen arpen nyuraheyen uwe. Ipak putrin aria pukweshihen puraen punaki. ");
INSERT INTO apec_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Aria ta enen arpen nyukri nyorigep nyukri, ‘Ipak pakweshihen um donki?’ ipak pukripesh pukri, ‘Debeini nakriyen.’” ");
INSERT INTO apec_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Aria amam hanak aria hatik um eshudok anan nakripam-umesh iri shatogur kabi douk anan nakri um. ");
INSERT INTO apec_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Aria douk amam hape hokweshihi enyudok donki aria shagremen iri sharigam shakri, “Ipak pakweshihen um mare enyudok nugaen donki?” ");
INSERT INTO apec_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Aria amam hakripesh hakri, “Debeini nakriyen.” ");
INSERT INTO apec_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Amam hakripeshuk namudok aria haraen hanakum Jisas. Douk hanak hatogur aria howem amamig saketog agabainyum enyudok nugaen donki aria hataurum Jisas nato nakih netem. ");
INSERT INTO apec_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Douk nakih netem aria enyen nyape nyanak. Aria arpesh shape showaruk esheshig saketog shogubuk yah um shakri shuginohwah. ");
INSERT INTO apec_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Aria anan nanak natogur agundok yah hanakum yoduhw Oliv iri, hurukatin um Jerusalem. Aria sabaishi arpesh douk shape shagipeshan shasuhw ananin baraen iri shanadudareh aria shape shenek tenkyu um Iruhin. Aria shahwar debeg atin shape shatuk ananin nyeigur nyato iruhw um ihinyumori Iruhin atun neneken iri mour douk Jisas neneken shatrin iri. ");
INSERT INTO apec_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Eshesh shahwar shakri, “Iruhin nunek yopunyi um anudok King douk nanakumori Debeini ananin nyeigur iri. Iruhin ananihw apahw douk yopuhw abom um apak arpesh! Apak mutuk Iruhin ananin nyeigur nyuto iruhw.” ");
INSERT INTO apec_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Aria anam Farisi douk heir eshudok sabaishi arpesh iri hakrip Jisas hakri, “Tisa, kwakripesh eshudok shasuhw nyakin baraen shagipeshen iri um mare shenekesh namudok uwe, uwok.” ");
INSERT INTO apec_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Aria Jisas nakripam nakri, “Eik yakripep, eshudok shukri mare shenekesh namudok um akure, utabor ababor kanak ta bupe buhwar butuk eikin nyeigur nyuto iruhw.” ");
INSERT INTO apec_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Douk Jisas nanaki hurukatin um Jerusalem natrubur aria nape nerepobur. ");
INSERT INTO apec_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Anan nerepobur aria nakri, “Aria doukih nyumnah ipak arpesh pape Jerusalem iri pakri pudukem ehudok aih douk ta puraeh aria hunekep pupe wosik iri akure, enyen ta wosik. Aria douk ehudok aih hanobeshuk-umep aria ipak madae pudukemesh uwe. ");
INSERT INTO apec_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Aria mnek, nyumneh ta hutogrum ipakish horik horin shunaki shiyotu shiyar shurihep aria shini ipak purpak um. Eshesh ta shurok dodogoiburi nabur abom shiyar shurihep. ");
INSERT INTO apec_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Aria eshesh ta shubrigen shununin abom nyani nyakish batowish douk shape numun narub iri. Aria eshesh ta mare shukutukuk anam utom mutemaguk kupaimi kabi douk sharik sharok narub shabremum uwe, uwok. Um maresh? Abudok nyutob Iruhin nanakumori nakri nutaurumep um, ipak madae puturub pudukemab nyutob uwe.” ");
INSERT INTO apec_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Aria Jisas nanak nawish numun narub Iruhin ananit debeiti urupat tataoum aria nape nehiyah arpesh douk shape shenek salim um eshudok eneshenesh gani numun iri. ");
INSERT INTO apec_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Aria anan nakripesh nakri, “Baraen nyetem Iruhin ananik Buk iri douk nyakri namudok. Iruhin nakri, ‘Eikit urupat douk tape um shunek beten um.’ Aria ipak penekesh-umat kabi douk shakwuaruh iri shanaki shape shanabeshuk um.” ");
INSERT INTO apec_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Aria ihih nyumneh anan nape nenek skulumesh um ananin baraen numun narub Iruhin ananit debeiti urupat tataoum. Aria amam debeimi pris hani amam douk henek skulumesh um Iruhin ananin lo iri hani amudok anam eshesh Juda esheshim debeimi hakri hubo Jisas nugok. ");
INSERT INTO apec_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Aria amam habirak madae huparug anah yah um hon nugok um uwe, uwok. Um maresh, ihishmorim arpesh shakri shumnek ihinyumorim ananin baraen abom aria eshesh shakri uwok um shukut-unaguk. ");
INSERT INTO apec_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Anah nyumnah Jisas nape numun narub Iruhin ananit debeiti urupat tataoum aria nape nenek skulumesh um yopihi aih aria nape nakripesh Iruhin ananin yopinyi baraen. Aria abudok nyutob, amam debeimi pris hani amudok henek skulumesh um lo iri hani amudok anam eshesh Juda esheshim debeimi hanaki hatrun. ");
INSERT INTO apec_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Aria amam harigan hakri, “Nyak nyarao maren big um nyunek enyudok mour? Aria omi nyeken enyudok big?” ");
INSERT INTO apec_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Aria Jisas nawanamam baraen nakri, “Eik shopunek yakri iyorigep um enen baraen. ");
INSERT INTO apec_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Ipak kripe, Jon douk nenek baptaisumesh iri omi nyakon enyudok mour aria anan douk nenek baptaisumesh? Iruhin nakripan aria douk nenek baptaisumesh o, enesh arpesh meyoh?” ");
INSERT INTO apec_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Aria amam hemnek aria amam kanak hape haneyagwreh hakri, “Ta mukripan maren baraen? Ta mukri Iruhin nakonen um, anan ta wata norigap nukri, ‘Douk namudok aria ipak madae punek bilip um Jon ananin baraen uwe um maresh?’ ");
INSERT INTO apec_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Aria shopunek, ta mukri arpesh meyoh shakonen um, eshudok sabaishi arpesh ta shop shukwumap utabor. Um maresh? Eshesh shakri Jon anan douk anan adurin profet abom.” ");
INSERT INTO apec_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Douk namudok aria amam hakripan hakri amam madae hudukemesh uwe. ");
INSERT INTO apec_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Aria Jisas wata nakripam nakri, “Eik shopunek douk namudok atin. Eik ta mare ikripep um omi nyutaurume nyeke big aria eik douk yenek enyudok mour um.” ");
INSERT INTO apec_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Aria Jisas nakripesh enyudok wobuwobren baraen nakri, “Anan arman narib anag nubarig aria nawu wain. Douk nawon neyatagun aria nakrip kupaimi armam hanaki henek kontrak heyohog. Aria shuruwep wainip pukri burep obi nyutob, amam hunadi anabigipum aria anan hudiman anabigipum. Aria anan nakomaguk nubarig aria nanak um anabur rougunibur wabur nanak nape roubum nyutob. ");
INSERT INTO apec_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Douk nape arigaha abudok nyutob um wainip shuruwep burep aria ta shudiyep um butogur. Aria anan neshopok anan arman douk nenekuman mour iri nanak um nukripam hudi iri enep shuruwep huko anan nusuwepamani. Douk nanak natogur aria amudok henek mour nubarig iri hakitak han aria wata heshopokan nanak wis wohis. ");
INSERT INTO apec_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Douk namudok aria anan wata neshopok kupaini nenekuman mour iri nanak. Anan nanak natogur aria namudok atin. Amam han henekuman yoweihi aih aria wata heshopokan nanak wis wohis. ");
INSERT INTO apec_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Aria douk anan natik namudok aria anan wata neshopok anan shopunek nanak. Douk nanak natogur aria namudok atin. Amam han henekan enenyenen aria honahur hawashan natogur adukigam nubarig. ");
INSERT INTO apec_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","“Aria nagrem nubarig iri nakri, ‘Douk, namudok aria eik ta inak inek maresh? Aria ishopok eikin nuganin meyoh douk eik urkum manawashaman abom iri nunak. Aria anan douk wosik, amam ta humnek ananin baraen.’ ");
INSERT INTO apec_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Aria henek mour nubarig iri hatrun nanaki aria amam hanakripam hakri, ‘Anudok arman douk nagrem nubarig iri ananin nuganin. Kweipon anan ta nurao ananish eneshenesh eshudok iri. Douk namudok aria apak mon nugokuk um apak munarao agudok nubarig.’ ");
INSERT INTO apec_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","“Aria amam hanak hasuwan, hawashan natogur aduk um agudok nubarig aria han nagok. “Aria nagrem agudok nubarig iri ta nunaki nunekam mumam amudok henek mour ananig nubarig iri? ");
INSERT INTO apec_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Eik yakripep, anan ta nunaki nom hugok aria nukrip kupaimi hunaki hunek mour ananig nubarig.” Aria douk eshesh arpesh shemnek namudok aria shakri, “Apak makri uwok um nunekesh namudok uwe, uwok.” ");
INSERT INTO apec_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Aria Jisas natrish duk aria narigesh nakri, “Baugenyum um enyudok baraen nyetem Iruhin ananik Buk iri douk nyakri mumam? Baraen douk enyudok. ‘Amudok sagomatinyim utomdouk harok urupat iri hakri uwok-umom aria hakwreyomuk iri, amam douk matogur sagomatinyim yopumi utom abom.’ ");
INSERT INTO apec_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Aria ihishmorim arpesh douk shutu shuto amudok utom iri ta shubuh prurakeresh shunek-umaguk shokugun atugun. Aria ta amam mubuh mubo enen arpen um, enyudok arpen ta misharigen abom nyunenekum minyabeg.” ");
INSERT INTO apec_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Jisas nakripesh enyudok wobuwobren baraen aria amam henek skulumesh um lo iri hani amam debeimi pris hadukemesh hakri enyudok wobuwobren baraen douk nakriyen nenyem amam. Namudok aria abudok nyutob amam hakitak hakri hutik anah yah um husuwan douk aria amam hanogugur um eshesh armam armago. ");
INSERT INTO apec_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Aria amam hape hatrugun um anab yopubi nyutob um amam huparug anagun aria kadak husuwan. Aria amam heshopok anam armam hanaki hape hatrun. Amudok armam douk debeimi heshopokam hanaki iri, amam douk henek rohw hakri amam adur hagipesh lo atin iri armam henek yopinyi atin iri. Amam hanaki hatik Jisas um huni anan hiyagwreh um hakri humnekan nukri niyagwreh enen baraen douk madae yopinyi uwe aria amam husuwan huranam debeini gavman um shokugi nahobig Judia iri aria hunekuman kwot. ");
INSERT INTO apec_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Aria amudok henek rohw iri hanaki aria hakrip Jisas hakri, “Debeini, apak madukemesh um nyak douk madae nyunogugur um enesh arpesh uwe. Aria nyak douk madae nyukrip debeishi nyeiguhw-ishi arpesh kupainyi baraen, aria nyeiguhw wokeshi nyukripeshuk kupainyi uwe, uwok. Nyak apa nyakripesh atin baraen ihishmorim arpesh. Aria nyak apa nyagipesh adurin atin baraen aria nyenek skulumesh wosik um Iruhin ananih aih. ");
INSERT INTO apec_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Douk namudok aria nyak kripap. Apakin lo douk nyakri mumam? Enyen douk wosik um munek takis um debeini gavman Sisar aka, uwok?” ");
INSERT INTO apec_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","24","Aria Jisas douk nadukemesh um agundok amam hakri hunek rohwuman um. Douk namudok aria anan nakripam nakri, “Ipak puyabige anam utom ba itrum. Enyudok nyeigur nyani aborir shetem amudok utom iri douk omiapenyish?” Aria amam hakri, “Sisar ananish wo.” ");
INSERT INTO apec_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Aria anan nakripam nakri, “Douk namudok aria Sisar ananish eshudok eneshenesh ta puko Sisar. Aria Iruhin ananish puko Iruhin.” ");
INSERT INTO apec_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Aria amam habirak um humnekan niyagwreh enen yoweinyi baraen agundok sabaishi arpesh shapeum hakri hunek kwotuman umen iri aria habirak hatik uwok. Namudok aria amam hakitak yowiyokuk um enyudok baraen anan nebeyeny-umam iri. Aria amam mukareg baraen wokam. ");
INSERT INTO apec_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","28","Amam Sadyusi apa hakri shagok iri ta mare wata shukitaki uwok. Aria anam amudok Sadyusi hanaki Jisas napeum aria harigan hakri, “Debeini tisa, seiwok Moses nawem-mopuk enen baraen. Aria baraen douk nyakri namudok, ‘Aria anan arman nurao onok armatok aria okwok mare kwubuki enesh batowish, aria anan nugokuk um, ananin wanin ta nukwaur. Anan nukwaur um wata shubuki batowish um shubuh ashuken-umanig nuwag.’ ");
INSERT INTO apec_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Aria anob nyutob, 7-poreim nugamim douk atish amakenyish shomubuki iri hape. Aria ashuken narao onok armatok aria batowish madae nubuki enesh uwe aria nagok. ");
INSERT INTO apec_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Aria douk ashuken nagokuk aria netemoni agab iri nukwaur. Anan nakwaur aria namudok atin. Batowish madae nubuki enesh uwe aria nagok. ");
INSERT INTO apec_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Douk anan nagokuk aria netemoni agab anudok iri nakwaur. Aria namudok atin. Batowish madae nubuki enesh uwe aria shopunek nagok. Douk namudok aria amudok 7-poreim nugamim ihim-morim harao okwudok armatok aria batowish madae anan nubuki enen uwe. Aria amam shopunek hagok hatuh. ");
INSERT INTO apec_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Aria okwok shopunek kwagok kwagiguk. ");
INSERT INTO apec_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Douk namudok aria abudok nyutob shagok iri wata shukitak um, okwudok armatok ta kwukitaki aria kwupe um meini? Nyak nyadukemesh, sagomatin ihim-morim amudok 7-poreim douk haraok iri atum.” ");
INSERT INTO apec_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Aria Jisas nakripam nakri, “Douk abudok nyutob, armam armago apa shanaraum. ");
INSERT INTO apec_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Aria eshudok arpesh douk Iruhin nakri wosik um wata shukitak iri wonugwegwiruh aria shunak shupe iruhw heven abom iri ta mare shunaraum atin uwe, uwok. ");
INSERT INTO apec_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Eshesh ta shupe kabi douk ananish enselahos um aria ta mare shugok uwe, uwok. Eshesh shape Iruhin ananish batowish. Um maresh? Anan douk wata neshuhur shakitak iri. ");
INSERT INTO apec_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Aria Moses douk neyabigap adur atin um shagok iri ta wata shukitak um. Enyudok baraen seiwok Moses nenyem Iruhin ananik Buk iri um agundok nyih hanuwi enen shokwinyi rowog iri um douk nahwar Debeini nakri, ‘Debeini anan douk Abraham nani Aisak iri Jekop amamin Iruhin.’ ");
INSERT INTO apec_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Douk namudok aria enyudok baraen douk nyakri anudok Iruhin anan douk madae shagok iri esheshin Iruhin uwe, uwok. Anan douk shape iri esheshin Iruhin. Anan natrish um, anan douk nakri eshesh ihishmorim douk shape iri atish.” ");
INSERT INTO apec_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Aria amudok anam douk henek skulumesh um Iruhin ananin lo hawanaman baraen Jisas hakri, “Tisa, nyak nyabeimom baraen wosik abom.” ");
INSERT INTO apec_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Aria amam hanogugur um horigan um enen shopunek baraen. ");
INSERT INTO apec_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Arigaha aria Jisas nakripam nakri, “Aria arpesh apa shakri Devit ananin barhonin ta nutogur Krais, douk Iruhin nagraehan neshopokan nanakumori nunarao arpesh iri um maresh? ");
INSERT INTO apec_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","43","Iruhin ananik Buk douk shahwarok um Sam iri, Devit kanak douk nowem baraen nyetem namudok nakri, ‘Debeini nakrip eikin Debeini nakri, “Nyak nyupe agundok eiken yopunyi rogur ehah arigaha ibo nyakim horim hubuhuk.” ’ ");
INSERT INTO apec_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Aria tik. Devit kanak douk nahwar anudok arman Krais ananin Debeini. Douk namudok aria Krais ta wata nutogur Devit ananin barhonin mumam?” ");
INSERT INTO apec_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Aria ihishmorim arpesh wata shape shemnek Jisas um agundok neyagwreh um. Aria anan nakrip ananim disaipel nakri, ");
INSERT INTO apec_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Ipak gamo pudukemesh um ipak mare pugipesh amudok henek skulumesh um lo iri amamih yoweihi aih. Amam hanadudareh abom um hakri hupe um hure rouhi atih rupeh aria hupe hurahaen um arpesh shutrum aria shukri amam yopumi debeimi armam. Aria shopunek, hakri hurahaen hunak agundok arpesh apa shantorum shapeum, um shutrum aria shunekumam yopihi nyumnah. Aria hanak eshesh Juda shape sheneyagwreh baraen-ogwi urusag um, amam hakri hunak hupe shakus sharik iri wagiturahos abudok nyutob shenek lotu obi nyutob. Aria shenek debeguni worigun um, amam hakri hunak hupe shakus sharik iri wagiturahos. ");
INSERT INTO apec_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Aria amam apa hanak hawish armam hagok hawosopuk iri armago owowig urusag aria hatru honahur owowish eshudok eneshenesh. Aria henek beten harig Iruhin um, amam henek rourouni rohwin beten um arpesh shutrum. Aria kweipon Iruhin ta nuwanamam amamish yoweishi inahos aria ta nunekam humnek debeiri eriger.” ");
INSERT INTO apec_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Douk Jisas napuhur natrish aria natik arpesh douk shanabuk sabaishi eshudok iri shape shenek ofa. Eshesh shakwutu utabor babuh bogis sakus numun Iruhin ananit debeiti urupat iri. ");
INSERT INTO apec_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Aria anan natik onok utabor wokok iri armatok douk anan nagok nakusopuk iri. Okwok um kwanaki aria kwenek ofa kwakwutu biyabor shokubori utabor babuh asudok bokis. ");
INSERT INTO apec_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Aria Jisas natruk namudok aria nakri, “Adur atin, eik yakripep. Okwudok anan nagok nakusopuk iri douk utabor wokok abom. Aria okwok kwanaki kwakwutu sabaibori utabor kweshagrakuk eshudok ihishmorim. ");
INSERT INTO apec_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Eshudok ihishmorim arpesh, douk sabaibori utabor bakusumeshuk aria sharauri karowibor meyoh shanaki shenek ofa. Aria okwudok armatok utabor wokok abom. Aria karowibor okwok kwaborabuk um kunator eshudok um douk kwanaki kwonek ofa kweyatabor kwoko Iruhin.” ");
INSERT INTO apec_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Abudok atub nyutob anam Jisas ananim disaipel hatik Iruhin ananit debeiti urupat aria hape heneyagwreh hakri, “Atudok urupat douk yoputi abom. Atat douk shakwu yopubori atubor utabor sharukat. Aria shopunek, shaginohwat shakwu yopiyopishi eshudok douk arpesh shanaki shape shako Iruhin um.” Aria Jisas nemnekam aria nakri, ");
INSERT INTO apec_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Ihishmorim eshudok douk ipak patrish iri, anob nyutob ta mare wata anam utom mutem dodog kupaimi kabi douk patrubor um, uwok. Ihibormorim ta bututu bubuh bukus amnab atugun.” ");
INSERT INTO apec_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Aria amam harigan hakri, “Tisa, ta meibi nyutob enyudok nyak nyakriyen iri nyutogur? Aria ta maresh shurik shutogurum mutrish aria mudukemesh um enyudok amaen douk ta hurukatin um nyutogur?” ");
INSERT INTO apec_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Aria Jisas nakri, “Ipak gamo pudukemesh um. Mare anam armam hunaki hunek rohwumep aria hunekep pugipesh amamin baraen uwe, uwok. Sabaimi armam ta hunaki kupakupaibi nyutob hukripep um eikin nyeigur hukri namudok. Anan ta nunaki nukripep um eikin nyeigur nukri, ‘Eik Krais douk Iruhin nagraehe aria neshopoke yanaki iri.’ Aria anam ta hukripep hukri nyutob douk hurukatin um butogur. Aria ipak mare pumnek amamin baraen aria punak pugipesham uwe, uwok. ");
INSERT INTO apec_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Ipak ta pumnek baraen um wanohw hwutogur kupairubi rougunirub warub um, o shupe shunotutukam shurpak um agundok shukri uwok um debeimi hupe esheshim debeimi um, ipak pumnek aria mare punogugur uwe, uwok. Eshudok ta shurik shutogur. Aria hugiguk iri nyumnah ta mare arigas hutogur.” ");
INSERT INTO apec_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Aria Jisas apa nakri, “Anag nahobig ta shukitak shuni kupaigi nahobig shurpak. Anan king nini ananish arpesh ta shukitak shuni kupaini king nini ananishi shurpak. ");
INSERT INTO apec_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Debeikwi enyik ta kwutuk. Aria ta eshesh nyurub besh abom. Aria yoweishi eshudok ta shutogur shunek eneshenesh yoweishi eshudok shubo arpesh. Eshesh ta shutogur kupakupairubi warub. Aria ipak ta putik enesh kupaishi abom eshudok shutogur iruhw utag aria ta punogugur. ");
INSERT INTO apec_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Aria abudok nyutob eshudok mare arigas shutogur obi nyutob, kupaishi arpesh ta shurik shunaki shusuwep shunekep enenyenen. Eshesh ta shuraep piyotum kwotog numun eshesh Juda shape sheneyagwreh baraen-ogwi urusag aria ta shuweshikep punak pupe shunuweshik-ati urupat. Aria eshesh ta shishapokep punak piyotu agundok amam king huni debeimi gavman iri hapeum. Eshesh ta shunekep namudok um maresh, ipak douk pagipesh eik aria pakripesh eikin baraen. ");
INSERT INTO apec_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Aria abudok nyutob eshesh shunekep namudok um, abudok douk yopubi nyutob um pukripesh eikin yopinyi baraen um. ");
INSERT INTO apec_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Douk namudok aria ipak mare punogugur pukri ta pubeimesh maren esheshin baraen uwe, uwok. ");
INSERT INTO apec_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Um maresh, eik kanak ta itaurumep ikep baraen douk ta ipak piyagwrehen iri nyuni yopunyi saki. Aria ipakim horim ta shubirak um mare shukenyuk agabus enyudok eikin baraen douk yakripepen iri nyubuhuk uwe, uwok. ");
INSERT INTO apec_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Ipakish amakenyish o ashukenyish iri owashish atus awiros um o enesh ipakishi arpesh ta shiyabig ipakish horik horin um agundok ipak pape um aria ta shunak shusuwep shuraep shunak shunek kwotumep. Aria anep ta shep abom pugok. ");
INSERT INTO apec_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Ihishmorim arpesh ta shukri wokumep abom aria shukepuk agabus. Um maresh, ipak douk eikish abom arpesh douk pagipesh eik iri. ");
INSERT INTO apec_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Aria Iruhin ta nutaurumep pupe wosik aria ta mare anabur atubur ehibur batogur ipakigos baragos iri ta bunak buwishuk uwe, uwok. ");
INSERT INTO apec_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Aria douk ipak pugipesh eikin baraen aria piyotu dodog um, ipak ta pupe wosik ihih nyumneh.” ");
INSERT INTO apec_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Aria Jisas apa nakripam baraen, “Aria abudok nyutob putik amam ami hunaki hiyotu hiyorhurih abrudok wabur Jerusalem obi nyutob, ipak ta pudukemesh pukri nyutob douk hurukatin um butogur. ");
INSERT INTO apec_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Umum maresh? Abudok nyutob arpesh shape shokugi nahobig Judia iri ta shuruwok shunak yadururuh shunak shupeik. Aria eshudok douk shape numun Jerusalem iri ta shukutuburuk. Aria eshudok douk shapeiri kupairubi warub bape hurukatin um Jerusalem iri mare wata shunaki shuwish Jerusalem uwe, uwok. ");
INSERT INTO apec_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Abudok douk Iruhin ananib nyutob um nuwanamesh yoweishi inahos eshudok arpesh douk shapeum shenek eneshenesh yoweishi inahos iri. Enyudok ta nyutogrum nyunek ihinyumorim baraen nyetem Iruhin ananik Buk iri douk nyakrium enyudok ta nyutogur um Jerusalem iri nyutogur adurin atin. ");
INSERT INTO apec_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Aria gihaum wanarahaen iri armago uni oudok douk wasuhw batowish douk watak shawok nyumeb um ehudok nyumneh iri. Debeinyi abom amaen ta nyutogur abudok amnab. Iruhin ta juwehosin abom aria ta nunekumesh debeiti kwot abom eshesh Israel. ");
INSERT INTO apec_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Enesh ta shutupokesh bainatog aria enesh ta shuweshikesh shunak um ihigosmorim nahobigos. Aria eshudok arpesh douk madae Juda iri uwe ta shishishobur shupe debeishi um abrudok wabur Jerusalem. Eshesh ta shupe um arigaha esheshib nyutob Iruhin nagraehab-umesh um shupe debeishi bunak butuh.” ");
INSERT INTO apec_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Aria Jisas apa nakripesh baraen nakri, “Enenyenen ta nyutogur um wabin nini nyumnahin aub aria unib. Ihishmorim arpesh shape abudok amnab iri ta shumnek um agundok youg aria debeibi morub batu um. Aria eshesh ta shunogugur abom aria esheshiruh aparuh ta yoweruh. ");
INSERT INTO apec_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Sabaishi arpesh ta shutik enyudok douk nyakri nyutogur um abudok amnab iri aria eshesh ta shunogugur abom. Aria eshesh ta marubigos sesh aria shutu shubuh shukus atap kabi douk shagok iri shabuh shakus um. Um maresh? Eneshenesh shape iruhw utag iri shuni aub aria unib ta grurugwresh aria shunatuk shubuhi. ");
INSERT INTO apec_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","“Aria abudok nyutob ta douk kadak shutik eik Anudok Arman douk yatogur adurinyi arpen iri irari onog orug inaki. Eik ta itrugun abom aria dodogoiwe atuwe inaki. ");
INSERT INTO apec_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","“Aria eshudok shupe shutogur obi, ipak pikitak piyotu aria pupuhur putrugun. Um maresh? Abudok nyutob Iruhin nakri wata nutrip aria nukwashihepum yoweishi inahos ipak pape penekesh iri aria nuraep putanamori pupe wosik um douk banaki hurukatin.” ");
INSERT INTO apec_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Aria Jisas nakripesh enyudok wobuwobren baraen nakri, “Ipak punek urkum um enyudok rowog nyeigurinyum fik nyuni kupaigosi rowos. ");
INSERT INTO apec_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Abudok nyutob putik um agagas supe sunareh obi, ipak ta pudukemesh pukri wah hutao obi nyutob douk hurukatinyum butogur. ");
INSERT INTO apec_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Aria douk ta namudok atin. Abudok nyutob ipak putik enyudok ihinyumorim amaen douk iganigadae yakripepumen iri nyupe nyutogur um, ipak ta pudukemesh um abudok yopubi nyutob arpesh shuwish agundok Iruhin ta nupe Debeini um ipak ananish arpesh um douk hurukatin um butogur. ");
INSERT INTO apec_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“Aria adur atin eik yakripep. Doukishi arpesh ta mare arigas shugok shutuh aria enyudok ihinyumorim amaen douk eik yakripepumen iri ta nyutogur. ");
INSERT INTO apec_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Ihishmorim eshudok shape iruhw utag iri shuni ihishmorim shape abudok amnab iri shuni amnab shopunek ta brukwuresh shunak shuwishuk abom. Aria eikin baraen ta nyupe abom ihih nyumneh.” ");
INSERT INTO apec_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Aria Jisas apa nakripam baraen nakri, “Ipak ta gamo pudukemesh. Ta wosik atin ipak pupe um puwok sabaiguni atugun worigun o puwok dodogowibari abar pugugak aria pupe um punek nyigiya um eneshenesh agundok atapishi atish um. Aria ipak pupe um punek enyudokmori atin um, ahudok eik itanamori ahi nyumnah ta hutogrumep ahudok atuh kabi enen mahin madae nyudukemesh uwe aria ahudok atuh nyeir maduhw aria roguhw shakitak yowiyokuk um. ");
INSERT INTO apec_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Umum maresh? Ahudok nyumnah ta hutogrum ihishmorim arpesh shape abudok amnab iri. ");
INSERT INTO apec_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Namudok aria ihih ipak ta gamo punatrugun aria pupe. Ipak punek beten porik Iruhin ihih nyumneh um nutaurumep aria abudok yoweibi nyutob bukri butogur um, ipak wosik ta piyotu dodogowip arigaha punak putogur piyotu agundok eik Anudok Arman douk yatogur adurinyi arpen iri itogur ipeum.” ");
INSERT INTO apec_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Aria ehudok nyumneh Jisas nape numun narub Iruhin ananit debeiti urupat tataoum aria nape nenek skulumesh ananin baraen. Aria weibus obi, anan apa natoum Olivihw yaduhw aria nanak neshuh agundok. ");
INSERT INTO apec_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Aria ihishmorim arpesh apa shakitak ruwahegwis atus shanak um Iruhin ananit debeiti urupat tataoum um shumnek ananin baraen. ");
INSERT INTO apec_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Ahudok nyumnah eshesh Juda shenek agundok debeiguni Pasovaigunworigun douk shawok bret shashaiteh madae tukitak debeiti iri uwe douk hanaki hurukatin. ");
INSERT INTO apec_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Aria amam debeimi pris hani amam douk henek skulumesh um lo iri hape haurim anah yah um hakri hubo Jisas nugok um. Um maresh? Amam hanogugur um hakri ta huneken yopugunum aria armam armago ta shom. ");
INSERT INTO apec_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Aria Satan nawish Judas Iskariot. Anan douk anan um amudok Jisas ananim 12-poreim disaipel. ");
INSERT INTO apec_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Douk Satan nawishan aria nanak nani amam debeimi pris hani amam heyoh Iruhin ananit debeiti urupat iri amamim debeimi heyagwreh um huweshik Jisas um. Aria anan nakripam nakri wosik um niyabigam um Jisas nanak napeum aria amam hunak husuwan. ");
INSERT INTO apec_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Aria douk hemnek namudok aria amam hanadudareh hariguk abom. Aria amam habo baraen um hakri ta hukon anabor utabor. ");
INSERT INTO apec_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Aria Judas nakri wosik um hukon anabor utabor um aria anan nape natrugun um anab yopubi nyutob um niyabigam Jisas hunak husuwan um. Anan nape natrugun um nakri nutik mare enesh arpesh shuni anan shupe aria anan nunak nukripam hunaki husuwan huran hunak. ");
INSERT INTO apec_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Arigaha aria ahudok nyumnah hanak hatograri um shuwok bret douk shushaiteh madae tukitak debeiti iri uwe. Aria ahudok nyumnah, eshesh apa shabo nugaesh sipsipahos um shishoh abudok nyutob shunek agundok debeiguni Pasovaigun worigun um. ");
INSERT INTO apec_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Aria Jisas nakrip Pita aria Jon um enyudok baraen aria neshopokam hanak. Nakri, “Ipak punak aria punek redium agundok Pasovaigun worigun um apak mugnoh iri.” ");
INSERT INTO apec_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Aria amam wata harigan hakri, “Nyak nyakri unak unek redimagun agnum?” ");
INSERT INTO apec_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Aria anan nakripam nakri, “Ipak mnek! Ipak ta punak puwish atin wabur aria anan arman nasahi anap abar barop iri marup iri ta nuparugep. Aria pugipeshan punak puwish atudok urupat anan nunak nuwishat iri. ");
INSERT INTO apec_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Ipak puwish aria pukrip atudok urupatin yaken pukri, ‘Apakin Debeini Tisa nakri amudok rum douk arpesh shape shashoh omi douk ta anan nini apak ananim disaipel muwok Pasovaigun worigun um douk agunum?’ ");
INSERT INTO apec_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Aria anan ta niyabigep anam debeimi iruhim rum douk eshudok shape shawok woriguneshi shakusomi. Aria ipak puto pukih pupe punek redimap um worigun.” ");
INSERT INTO apec_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Aria douk hanak aria hatik um enyudok nyatogur kabi douk iganigadae Jisas nakripam um. Aria amam henek redium Pasovaigun worigun. ");
INSERT INTO apec_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Douk arigaha abudok nyutob um huwok worigun obi nyutob batogur, aria Jisas nani ananim aposel hanaki hape heyorharih tebol. ");
INSERT INTO apec_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Amam hape aria anan nakripam nakri, “Eik oub bakitak abom um ini ipak muwok agundok Pasovaigun worigun iyoh, aria kadak irao debeiri eriger. ");
INSERT INTO apec_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Adur atin eik yakripep. Eik ta mare wata iwok anagun agundokmori Pasovaigun worigun, uwok. Eik ta ipe namudok arigaha wata ini ipak muwok adurigun Pasovaigun worigun abrudok wabur Iruhin nape Debeini um ananish arpesh shapeum.” ");
INSERT INTO apec_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Aria Jisas nohuri anap kap wain abar borap iri nenek beten nenek tenkyu um Iruhin aria nakripam nakri, “Suwap kap aria ipak ihipmorim punosiyabor. ");
INSERT INTO apec_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Eik yakripep, douk arigaha kweipon, eik ta mare iwok anabar abrudokmori wainibar abar, uwok. Eik ta ipe namudok arigaha abudok nyutob um arpesh shuwish um agundok Iruhin nupe Debeini um ananish arpesh um butogur.” ");
INSERT INTO apec_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Aria wata nohuri bret nenek beten nenek tenkyu um Iruhin aria naworut nako amam. Aria nakripam nakri, “Atudok bret douk eikihw yegenyihw. Eik yekepohw um itaurumep. Aria ipak pupe punekesh namudok um ipak urkwip wata purum eik.” ");
INSERT INTO apec_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Aria douk amam hawok bret heyatat aria wata nenekesh namudok atin. Anan nohuri kap wainibar abar boropi nako amam aria nakripam nakri, “Abrudok wainibar abar douk eikibor owishibor douk ta butourak butaurum ipak arpesh iri. Abrudok owishibor douk benek enyudok Iruhin ananin namunyi adurin atinyi baraen kontrak nyutogur dodogowin. ");
INSERT INTO apec_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Aria anudok arman douk ta niyabig eikim horim aria shusuhwe shurao eik iri douk anudok nani eik wape wawok worigun enyudok tebol. ");
INSERT INTO apec_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Eik Anudok Arman douk yatogur adurinyi arpen iri ta she igok kabi douk seiwok Iruhin nakri um ta shenekesh um. Aria anudok douk niyabig eikim horim um eik iri, anan douk yakri giha abom um anan. Um maresh? Anan ta debeinyi amaen abom ta nyutogur-uman.” ");
INSERT INTO apec_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Aria douk Jisas nakripam namudok aria amam hape harigan um ta amiapen nyunek enyudok. ");
INSERT INTO apec_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Aria amam disaipel hohur enen baraen aria hape hanagaganim um hakri amam kanak ta meini abom nupe amamin debeini. ");
INSERT INTO apec_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Aria Jisas nakripam nakri, “Amam king hape abudok amnab iri douk dodogowim atum abom hapeum arpesh shunek enesh eshudok eneshenesh aria eshesh apa shemnek amamim baraen aria shenekesh. Aria amudok douk hape esheshim debeimi iri, arpesh apa shahwaram shakri yopumi hataurumesh iri. ");
INSERT INTO apec_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Aria ipak mare punekesh namudok, uwok. Ipak meinari arman nukri niyotu nurikumep iri, anan ta nupe abom kabi douk anan nyeigur wokan iri nenek mour meyoh um kupaishi iri um. ");
INSERT INTO apec_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Ipak pakri meinari arman douk nape debeini um ipak ihipmorim? Anudok douk nape tebol nawok worigun iri o, anudok douk noruhuman worigun iri? Adur, debeini douk anudok nape tebol nawok worigun iri. Aria eik douk yani ipak mape aria yenekesh kabi douk anudok noruhuman worigun iri aria yenek mour um yataurum ipak. ");
INSERT INTO apec_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Aria abudok nyutob amaen nyutogur nyukwiraehe obi, ipak douk pani eik pape aria madae pukutukuk eik uwe. ");
INSERT INTO apec_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Aria eikin Yain douk neke big um ipe debeiwe iri um arpesh. Aria douk namudok atin. Eik douk ikep big um ipak pupe debeipi pusuhw merik um enesh arpesh. ");
INSERT INTO apec_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Eik douk yenekep namudok um puni eik mupe eikin tebol muwok worigun iri abar agundok eikish arpesh shapeum. Aria ipak ta putem yopishi wagiturahos douk amam king atum hapenyesh iri. Aria ipak ta pupe debeipari pusuhw kwotog um asudok 12-poreis awiros um eshesh Israel.” ");
INSERT INTO apec_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Aria Jisas nakri, “Saimon, Saimon! Nyak mnek! Iruhin nakripan wosik Satan um nukwiraeh ipak ihishmorim um punosiam um pukutukuk bilip kabi douk sheyogomuk ouguhit wit um. ");
INSERT INTO apec_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Aria Saimon, eik yenek beten yarig Iruhin um nataurumen um mare nyukutukuk nyakin bilip um eik, uwok. Aria abudok nyutob nyutanam nyugipesh eik obi, nyak wata nyutaurum nyakim ashukenyim owarhim douk hagipesh eik iri um hiyotu dodog.” ");
INSERT INTO apec_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Aria Pita wata nakrip Jisas nakri, “Debeini, eik yenek redi um ini nyak unuweshik aria shopunek yakri um ini nyak ugok atin.” ");
INSERT INTO apec_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Aria Jisas nakripam nakri, “Pita, kwehigib wab, owot ta madae arigas tiyagwreh aria nyak ta nyunekuk rohw biyeh atih nyukri nyak madae nyudukem eik uwe.” ");
INSERT INTO apec_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Aria Jisas wata nakripam nakri, “Riguk eik yeshopokep panak penek mour um, ipak madae punasuhw banagos aria su uni paus panaruk utabor um uwe. Aria abudok nyutob ipak panak meyoh um, ipak eneshenesh wokep aka, uwok?” Aria amam hakripan hakri, “Uwok, apak madae eneshenesh wokap uwe, uwok.” ");
INSERT INTO apec_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Aria anan nakripam nakri, “Aria douk, anudok douk nanoruk anabor utabor anas paus iri o nanabuk anag banag iri ta nunasuwesh. Aria meinyi arpen douk bainat wokeni ta nyenek salim enyenyit saket aria nyutor anat bainat. ");
INSERT INTO apec_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","“Um maresh? Baraen douk shenyem nyakrium eik iri nyetem Iruhin ananik Buk iri ta nyutogur adurin. Baraen enyudok, ‘Anan douk shakwrupan morim yowemi henek yoweishi inahos iri.’ Adur, enyudok baraen douk nyakrium eik um douk nyape nyatogur adurin.” ");
INSERT INTO apec_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Aria amam disaipel hakripan hakri, “Debeini, tik. Apak douk masuhw biyog bainatog.” Aria anan nakripam nakri, “Jurug.” ");
INSERT INTO apec_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Aria Jisas nakutukuk Jerusalem natogur natoum yoduhw Oliv kabi douk ihih nyumneh anan nape nanak um. Aria ananim disaipel hagipeshan hanak. ");
INSERT INTO apec_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Aria douk anan nanak natogur aria nakripam, “Ipak ta punek beten um abudok nyutob kwiraeh nyutogur-umep um, ipak mare punek yoweishi inahos.” ");
INSERT INTO apec_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Douk nakripamuk namudok aria nanaku rougun shopunek. Rougun um douk kabi arpesh shawashak anam utom manak mabuh um. Douk nanak aria nabuh noduk ohrubus nape nenek beten nakri, ");
INSERT INTO apec_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Yain, ta nyukri wosik um, nyak nyukutuk enyudok amaen ta nyutogrome iri. Aria eik yakri uwok um nyugipesh eikim urkum, uwok. Nyak nyugipesh nyakim atum urkum.” ");
INSERT INTO apec_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Aria enen ensel nyape iri iruhw heven nyabuhi nyatogruman aria nyatauruman nyenekan dodogowin. ");
INSERT INTO apec_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Aria ananin mishin yowen abom aria natogur dodogowin nape nenek beten kabi iganigadae narik nenekan um. Aria kihakwuh nyatogur kabi douk owishibor bakih babuh bagruk atap um. ");
INSERT INTO apec_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Douk nenek beten jurug aria nakitak nanak um nutik ananim disaipel. Aria nanaku, aria anan natrum um amam heshuh hagok. Amamish mishish yowesh abom um enyudok douk ta nyutogur iri aria amam madae dodogowim uwe aria heshuh. ");
INSERT INTO apec_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Aria anan nanak narigam nakri, “Ipak peshuh um maresh? Kakitak aria punek beten um abudok nyutob kwiraeh nyutogurumep um, aria ipak mare punek yoweishi inahos.” ");
INSERT INTO apec_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Aria douk Jisas wata nape neyagwreh atin aria Judas anan um amudok 12-poreim disaipel nariki um sabaimi armam hanak hatograri. Aria Judas nanaki hurukatin um Jisas um nakri nunopuprikan. ");
INSERT INTO apec_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Aria Jisas nakripan, “Judas, douk nyak nyiyabigesh eik Anudok Arman douk yatogur adurinyi arpen iri um eikish horim um agundok nyanaki nyanaprike um, aka?” ");
INSERT INTO apec_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Aria Jisas ananim disaipel douk hani anan heyotu iri hatik um enyudok douk Jisas ananim horim hakri hunekenyuman iri aria amam harigan hakri, “Debeini, nyak nyakri maresh? Apak mukwumam apakig bainatog aka?” ");
INSERT INTO apec_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Aria anan um amam disaipel natupak anan nenek mour um debeini pris iri ananih anagagrih atah abom aria tukarah. ");
INSERT INTO apec_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Aria Jisas nakri, “Jurugih ehudokmori aih.” Aria nasuhw anudok arman ananih atah neshopoh hape agundok hatakum aria ahah wata yopuh. ");
INSERT INTO apec_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Aria Jisas narig amam debeimi pris hani amam heyoh Iruhin ananit debeiti urupat iri um amamim debeimi hani eshesh Juda esheshim debeimi douk hanakumori husuwan huran hunak iri. Anan narigam nakri, “Ipak pakri eik anan yoweini arman douk yenek onohw wanohw iri o, yakwuaruh iri um pasuhwi bainatog aria rowos um punaki purae um? ");
INSERT INTO apec_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Ihih nyumneh eik yani ipak mape numun narub Iruhin ananit debeiti urupat tataoum aria ipak madae pukri um puweme ipakis wis ba pusuwe uwe. Aria abudok nyutob douk ipakib nyutob abom um Satan nape arukwutigun atin aria dodogowin atun um nubo eik ibuhuk um.” ");
INSERT INTO apec_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Douk Jisas neyagwreh um jurug aria hasuwan haran hanak hawish debeini abom pris ananit urupat. Aria Pita nagiguk atin nape nagipesham nanak. ");
INSERT INTO apec_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Aria agundok iganigadae armam hautig nyih orokohunirub um narub douk shenekarub sheyorsharih abom debeini pris ananit urupat tataoum. Aria amam hanak hapeum nyih hape atugun aria Pita shopunek nanak napeimeh. ");
INSERT INTO apec_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Aria onok kwenek mour agundok iri kwanaki kwatrun napeum nyih aria kwatrun wosik aria kwakri, “Anudok arman shopunek douk nani Jisas iri.” ");
INSERT INTO apec_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Aria Pita nenek rohw nakri, “Eik madae idukeman uwe Jisas.” ");
INSERT INTO apec_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Aria douk shapeigu madae roubi uwe aria anan arman wata natrun aria nakri, “Nyak shopunek douk nyeir Jisas ananim iri.” Aria Pita nakripan, “Adur, eik uwok!” ");
INSERT INTO apec_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Aria shape arigaha roubi nyutob hurukatin um atin aua nyanakuk, aria kupaini neyagwrehi debeg nakri, “Adur atin. Anudok arman douk nani Jisas iri. Um maresh? Anan shopunek douk nape iri shokugi nahobig Galili iri.” ");
INSERT INTO apec_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Aria Pita nakri, “Nya, baraen nyak nyeyagwrehen iri, eik madae idukemen uwe.” Aria Pita wata nape neyagwreh atin aria owot teyagwreh. ");
INSERT INTO apec_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Aria douk owot teyagwreh aria Debeini natanam natruni wosik Pita. Aria Pita wata urkum morum enyudok baraen nabatik Debeini nakripan-enyi. Baraen enyudok, “Owot ta madae arigas tiyagwreh aria nyak ta nyunek rohw biyeh atih nyukri, nyak madae nyudukem eik uwe.” ");
INSERT INTO apec_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Aria Pita urkum morum enyudok baraen aria natogur aduk aria nareh yowiyokuk abom. ");
INSERT INTO apec_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Aria amudok douk heyotu heyoh Jisas iri henekan enenyenen heyokasan aria han. ");
INSERT INTO apec_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Aria amam howeshik ananis nabes anap rupahip aria harigan hakri, “Nyak kripap kabi amam profet um, douk amiapen nyaen?” ");
INSERT INTO apec_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Aria amam habubuniman aria hape heyokasan um sabainyi enenyenen yoweinyi baraen shopunek. ");
INSERT INTO apec_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Douk gagruk aria eshesh Juda esheshim debeimi hani debeimi pris hani amudok henek skulumesh um lo iri hanaki hape atugun. Aria amam harauri Jisas hanaki agundok amam hapeum. ");
INSERT INTO apec_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Aria amam harigan hakri, “Nyak kripap anudok arman Krais douk. Iruhin nakri um nugraehan neshopokan nunakumori nunarao arpesh iri douk nyak?” Aria anan nakripam, “Aria ta ikripep um, ipak ta mare punek bilip um eikin baraen. ");
INSERT INTO apec_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Aria ta eik iyorigep enen baraen akure, ipak ta mare pubeyenyume. ");
INSERT INTO apec_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Aria douk arigaha kweipon, eik Anudok Arman douk yatogur adurinyi arpen iri ta ipe yopunyi rogur ehahum dodogowin atun abom iri Iruhin” ");
INSERT INTO apec_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Aria ihim-morim harigan hakri, “Namudok aria nyak douk Iruhin ananin adurini Nuganin?” Aria anan nakripam nakri, “Ipak pakri adur. Eik douk kabi ipak pakri um.” ");
INSERT INTO apec_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Aria amam hakri, “Apak mare wata murim enen shopunek baraen. Baraen douk enyudok memneken anan kanak nakriyen.” ");
INSERT INTO apec_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Douk amam hemnek Jisas ananin baraen um jurug aria amam ihim-morim hakitak haran hanakum Pailat douk nape debeini gavman iri. ");
INSERT INTO apec_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Aria hanak hape henek rohw henekuman baraen hakri anan nohur arpesh um shuni gavman shurpak. Aria shopunek hakri, anan nakri eshesh mare shunek takis uwe um debeini gavman iri Sisar. Aria shopunek hakri, anan nakri anan douk Krais, anan king douk Iruhin nagraehan neshopokan nanakumori nunarao arpesh iri. ");
INSERT INTO apec_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Aria Pailat narigan nakri, “Nyak douk eshesh Juda esheshin king?” Aria Jisas nakripan nakri, “Adur, eik douk kabi nyak nyakrium.” ");
INSERT INTO apec_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Aria Pailat wata nakrip amam debeimi pris hani eshudok sabaishi arpesh nakri, “Eik madae iparug enesh yoweishi inahos anan nenekesh iri uwe.” ");
INSERT INTO apec_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Aria amam dodogowim atum hakri, “Anan nenek skulumesh um enen baraen eshesh armam armago aria nohur esheshiruh aparuh um shuni gavman shurpak. Enyudok douk nenyuhuri shokugi nahobig Galili aria nanak ihirub warub apak Israel apakirub. Aria douk enyudok nyanak nyatograri agundok.” ");
INSERT INTO apec_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Aria Pailat nemnek enyudok baraen aria narigesh nakri, “Anudok arman Jisas anan douk anan um eshesh Galili?” ");
INSERT INTO apec_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Aria douk Pailat nemnek um shakri Jisas anan douk nape iri shokugi nahobig Galili douk Herot nape debeini um, aria anan neshopokan nanak um Herot. Abudok nyutob Herot shopunek douk nanak nape Jerusalem. ");
INSERT INTO apec_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Aria Herot douk nanadudareh abom um abudok nyutob anan natik Jisas um. Um maresh? Anan nemnek baraen um agundok shape shakriyan um aria roubum nyutob anan nape natrugun um nakri nutrun. Anan nakri nutrun um nunek enen Iruhin atun neneken iri mour. ");
INSERT INTO apec_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Douk namudok aria Herot narigan sabainyi baraen Jisas. Aria Jisas madae nunogugur um nuwanaman enen baraen uwe, uwok. ");
INSERT INTO apec_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Aria amam debeimi pris hani amam henek skulumesh um lo iri hanak heyotu hurukatin aria dodogowim atum hape henekuman dodogowin atin baraen. ");
INSERT INTO apec_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Aria Herot nani ananim soldia hape henekan enenyenen Jisas. Amam habubuniman aria hanak hohuri anah dudukeh-ahi rupah douk debeimi atum hanawashoh iri aria hanaki haweshigah-uman. Aria wata heshopokan nanak um Pailat. ");
INSERT INTO apec_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Aria riguk Herot nani Pailat apa hananem horim. Aria ahudok nyumnah Pailat neshopok Jisas nanak um Herot ahi, amam wata hanagabe um aria hape atugun. ");
INSERT INTO apec_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Aria Pailat nahwar debeimi pris hani amam debeimi um eshesh Juda iri hani eshudok sabaishi armam armago shanaki. ");
INSERT INTO apec_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Aria anan nakripesh nakri, “Ipak parauri anudok arman um eik aria pakri nohur arpesh um shuni gavman shurpak. Aria douk ipak douk pape aria eik yape yarigan um enyudok baraen. Aria eik douk madae iparug yoweishi inahos anan nenekesh iri uwe. Eik yatik um enyudok ipak penek kwotuman-enyi anan douk madae nuneken uwe. ");
INSERT INTO apec_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Aria Herot shopunek douk madae nuparug enesh yoweishi inahos Jisas nenekesh iri uwe. Aria anan wata neshopokan natanamori um apak. Aria mnek. Anudok arman douk madae nunek enesh yoweishi inahos um ta mon nugokumesh iri uwe, uwok. ");
INSERT INTO apec_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Douk namudok aria eik ta ikripam huprukan hukwu enesh eshudok meyoh aria wata ikweshihan nunak fri.” ");
INSERT INTO apec_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Abudok nyutob eshesh douk shagipesh ahudok aih. Ihish kwarahos ahudok nyumnah hutogrum shunek Pasovaigun worigun um, Pailat ta nukweshih-umesh anan nonoweshik iri nutogrumeshi nupe fri. ");
INSERT INTO apec_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Aria ihishmorim arpesh shani atuh shahwar shakri, “Buwon nugok! Aria nyukweshih-umapari Barabas!” ");
INSERT INTO apec_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Anudok arman Barabas douk nonoweshik napeum agundok nohur onohw wanohw Jerusalem nani gavman aria nabo enesh arpesh shagok um. ");
INSERT INTO apec_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Aria Pailat nakri nukweshih Jisas nunak fri aria anan wata gamo narigesh. ");
INSERT INTO apec_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Aria eshesh shahwar shakri, “Nek nyiliman rowog kruse! Nek nyiliman rowog kruse!” ");
INSERT INTO apec_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Aria Pailat wata shopunek nakripesh anah shopunek henekeh biyeh atih um nakri, “Anan nenek maresh yoweishi inahos um apak mon nugokumeshi? Eik madae iparug enesh yoweishi inahos um ta mon nugokumesh iri uwe. Douk namudok aria eik ta ikripam huprukan enesh eshudok shabo arpesh-eshi meyoh aria ikweshihan nunak.” ");
INSERT INTO apec_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Aria eshesh shape shahwar debeg abom um shakri shunek nyilim Jisas um rowog kruse aria shon nugok. Eshesh shahwar arigaha aria esheshin baraen nyabouk Pailat ananin nyabuhuk. ");
INSERT INTO apec_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Namudok aria Pailat nakri wosik um shubo Jisas nugok kabi douk eshesh shakri um. ");
INSERT INTO apec_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Aria nakweshih-umesh Barabas nanak fri. Anan douk nonoweshik um agundok nani gavman sharpak, aria nabo enesh arpesh shagok um. Aria douk Pailat nakweshih-umesh anudok eshesh shakri-anari nanak aria nekesh Jisas um shenekesh-uman kabi douk eshesh shakri um. ");
INSERT INTO apec_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Douk Pailat nekesh Jisas nor esheshis wis aria amam soldia haran hanak. Amam hanak yah aria haparug Saimon douk nanaki wabur Sairini iri nanakumori nuwish Jerusalem. Aria amam hasuwan howem rowog kruse ananih ereh aria henekan nenyusah nagim Jisas. ");
INSERT INTO apec_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Aria sabaishi arpesh shagipesh Jisas shanak. Ono armago shopunek wanamesh shanak aria owo wape warepan. Owo woreh wanakukuri wanaruwar abom. ");
INSERT INTO apec_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Aria Jisas natanam nakripo nakri, “Ipak armago pape Jerusalem iri, ipak mare purep eik uwe, uwok. Ipak purep ipakish batowish shuni ipak kanak. ");
INSERT INTO apec_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Um maresh, nyutob ta butogur aria abudok nyutob arpesh ta shukri, ‘Kupaiwari armago wani oudok douk wata ubuki enesh batowish iri uwe wani oudok douk madae usuhw enesh batowish wukesh nyumeb iri uwe owo ihiyumorim douk wanadudareh.’ ");
INSERT INTO apec_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","“Aria abudok nyutob, arpesh ta shukrip yodururuh shukri, ‘Kitak putukwarihi putu pushapumap.’ Aria ta shukrip mihig shukri, ‘Putukwarihi pubuhi pushapumap aria pubeshukap.’ ");
INSERT INTO apec_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Eik douk madae inek enesh yoweishi inahos uwe, aria douk eshesh shakri shubo eik douk yape kabi naminyi rowog iri um. Aria ipak douk pape kabi yarinyi rowog iri um agundok penek yoweishi inahos um ta shenekesh-umep mumam mumam? Eshesh ta shunekumep yoweishi inahos abom.” ");
INSERT INTO apec_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Aria amam soldia harao Jisas nani biom henek yoweishi inahos iri hanakum hom hugok. ");
INSERT INTO apec_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Aria eshesh shanak shatogur agundok douk nape kabi arpenyig barag um. Aria agagun douk shahwaragun, “Arpenyig Barag.” Aria agundok, amam henek nyilim Jisas um rowog kruse. Aria amudok biom henek yoweishi inahos iri, anan shenek nyiluman neir wobur ehahum Jisas aria anan neir wobur ehah-uman. ");
INSERT INTO apec_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Aria Jisas nakri, “Yain! Nyak mare nyusuwesh uwe eshudok yoweishi inahos eshesh shenekesh um eik iri aria nyukweshihesh-ukuk. Eshudok shenekesh um eik iri douk madae shudukemesh uwe.” Aria amam soldia habirak satuum hanasia ananih rupeh. ");
INSERT INTO apec_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Aria arpesh sheyotu shape shatrun aria eshesh Juda esheshim debeimi hape habubuniman. Aria hakri, “Anan douk nataurum kupaishi. Aria ta anan douk Krais douk Iruhin nagraehan nanakumori nunarao arpesh iri um, anan wata nutaurum anan kanak.” ");
INSERT INTO apec_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Aria amam soldia shopunek hanak hurukatin aria habubuniman aria hakon anabar nubutibari abar. ");
INSERT INTO apec_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Aria hakripan hakri, “Aria adur nyak douk Juda esheshin king um, douk nyutaurum nyak kanak.” ");
INSERT INTO apec_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Aria amam howem enen baraen aria hakih heshopen iruhw um rowog kruse Jisas neir um. Baraen enyudok, ");
INSERT INTO apec_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Aria anan um amudok biom yoweimi armam douk heir wobuwobur iri, nabubunim Jisas nakri, “Nyak douk Krais, douk Iruhin nagraehen neshopoken nyanakumori nyunarao arpesh iri? Namudok um nyak nyutaurum nyak kanak aria nyutaurum ohwak shopunek!” ");
INSERT INTO apec_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Aria anudok anan neir wobur iri nahan nakri, “Apak ihishmorim douk meir otuhw maduhw. Apak douk shap um ta mugok iri atup. Aria nyak nyanogugur um Iruhin aka, uwok? ");
INSERT INTO apec_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Ohwak douk wosik shaohw um ohwakish yoweishi inahos ohwak wenekesh iri. Aria anudok arman madae nunek enesh yoweishi inahos uwe, uwok.” ");
INSERT INTO apec_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Aria anan nakrip Jisas nakri, “Jisas, nyak urkum mur um eik abudok nyutob nyak nyupe debeini um nyakish arpesh um.” ");
INSERT INTO apec_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Aria Jisas nakripan nakri, “Adur eik yakripen. Doukih nyumnah nyak ta nyuni eik upe yopuburi wabur heven.” ");
INSERT INTO apec_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Douk aun nakihi arigaha 12 kilok wah madae hutao uwe aria wab babuhi. Aria ihigunmorim um eshesh Juda esheshirub warub arukwutigun tituguk. Agagun arukwutigun nape namudok arigaha wabigep 3-kilok aria wah madae hatao aria arisigun. ");
INSERT INTO apec_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Aria rupahdouk shahaur numun Iruhin ananit debeiti urupat iri puwaroh um biyeh. ");
INSERT INTO apec_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Douk enyudok nyanakuk aria Jisas nahwar debeg nakri, “Yain, eik yeken eikin mishin nyor nyakis wis.” Douk nakriyuk namudok aria anan adur nagok. ");
INSERT INTO apec_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Aria anudok debeini soldia douk nasuhw merik um 100-poreim soldia iri natik namudok aria natuk Iruhin ananin nyeigur nyato iruhw. Aria nakri, “Adur atin. Anudok arman douk yopuni.” ");
INSERT INTO apec_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Aria ihishmorim arpesh douk shanaki um shutik enyudok iri shatik namudok aria esheshiruh aparuh yoweruh abom um shabo Jisas nagok um. Aria eshesh shohwido shanak atin atin aria shanak um esheshirub warub. ");
INSERT INTO apec_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Aria sabaishi Jisas ananish um shani ono armago douk wagipeshi Jisas gani shokugi nahobig Galili wanaki iri, sheyotu madae rougun aria shape shatik enyudok douk shape sheneken um Jisas iri. ");
INSERT INTO apec_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Aria anan arman douk shahwaran um Josep iri nape. Anan douk yopini arman. Anan douk nanaki eshesh Juda esheshibur wabur shahwarabur um Arimatea iri. Aria anan douk anan kansol douk neir eshesh Juda esheshim debeimi iri. ");
INSERT INTO apec_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Aria enyudok baraen amudok debeimi heyagwrehen um hakri hubo Jisas nugok um, anan douk madae nini amam nusuwen uwe. Anan nakri uwok. Aria anan apa nape natrugun um abudok nyutob um arpesh shuwish um agundok Iruhin nupe Debeini um ananish arpesh um. ");
INSERT INTO apec_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Aria anudok arman Josep nanak Pailat napeum aria narigan um nunak nubrei Jisas nunak nuruman. ");
INSERT INTO apec_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Aria douk Pailat nakri wosik aria anan nanak nabrei Jisas nabuhi atap aria neshrehan anah yopuhi shigorihwihi rupah. Aria nonohur nanak nawish onohw wonugwehw douk shenekoh onok burbuduk iri aria nawish nanabukuk agundok. Ahwudok wonugwehw douk madae shurom enen nyagok iri arpen uwe, uwok. ");
INSERT INTO apec_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Aria ahudok nyumnah eshesh douk shape shenek gwinygwaen um eshudok. Ahudok nyumnah Sabat hurukatin um hutogur aria eshesh mour ta uwok, shupe meyoh. ");
INSERT INTO apec_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Aria armago douk wani Jisas shape iri Galili shanaki wagipesh Josep wanak aria watiguk ahwudok wonugwehw anan nanak nabukuk Jisas um. Aria shopunek watik agundok Jisas ananig barag aria aiyas shakus um. ");
INSERT INTO apec_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Aria owo watanam wanak um wabur wanak wagabe anan marasin nani yopuri wel reisik yopuri unar iri. Owo wenek redimar um wakri unak urayok Jisas ananihw yegenyihw. Douk wenek redi um eshudok um jurug aria ahudok nyumnah Sabat hatogur. Aria owo warao uhwin kabi douk Iruhin ananin lo nyakrium. ");
INSERT INTO apec_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Aria sagomih nyumnahum wik, madae gamo gugruk uwe, oudok armago wasuhw arudok wel reisik yopuri unar iri douk nubokuhi wenek redimar iri wanak um ahwudok wonugwehw douk Josep narom Jisas um. ");
INSERT INTO apec_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Douk owo wanak watogur aria watik um amudok utom douk shagah wonugwehw Jisas nakus um douk matatigas manak makusuk anagas. ");
INSERT INTO apec_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Douk namudok aria owo wanak wawish. Douk wawish aria owo madae utik Debeini Jisas nukus numun uwe, uwok. ");
INSERT INTO apec_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Aria owo weyotu namudok wape wenek urkwip. Aria ahudok atuh biom armam heneki hatrugun abom iri rupeh iri hanaki heyotu agundok owo weyotu um. ");
INSERT INTO apec_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Aria owo watik namudok aria owo wanogugur abom aria wourem watik atap. Aria amudok biom armam harigo hakri, “Ipak panaki paurim anudok douk wata nakitak nape iri agundok sharom shagok iri um maresh? ");
INSERT INTO apec_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Agundok madae anan nukus uwe. Anan douk nakitak nape. Ipak punek urkwip um enyudok baraen douk nubokuhi wata nape Galili aria nakripep-aguk um. ");
INSERT INTO apec_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Baraen douk enyudok, ‘Eik Anudok Arman douk yatogur adurin arpen iri ta shiyabige um henek yoweishi inahos iri armam husuwe hunek nyilume rowog kruse aria igok. Aria hukri um biyeh atih nyumneh um, eik ta wata ikitaki ipe.’” ");
INSERT INTO apec_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Douk amam hakripo namudok aria owo wata urkwip poramoguk enyudok baraen nubokuhi Jisas nakripeshuk um. ");
INSERT INTO apec_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Aria owo wakutukuk wonugwehw hwape um aria wanak wakripuk ananim 11-poreim disaipel hani ihishmorim shapeik iri um enyudok ihinyumorim owo watrin iri. ");
INSERT INTO apec_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Aria armago douk wanak wakripuk amam aposel um enyudok owo watrin iri douk oudok. Maria, douk kwanaki wabur Makdala iri kwani Joana iri Jems ananik amakek douk shopunek kwonahwaram Maria iri. Oudok biwotuk wani ono armago shopunek. ");
INSERT INTO apec_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Aria amam aposel hemnek aria hakri enyudok owo wakripam-enyi baraen douk rohwin shagugak iri sheyagwrehen iri. Namudok aria amam madae hunek bilipumo uwe. ");
INSERT INTO apec_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Aria Pita nakitak nahur nanak um wonugwehw-igunum agundok wonugwehw hwape um. Anan nanak natogur aria nepebig natigu numun aria natigu ehudok shigorihwihi rupeh hakusuk. Aria anan wata natanam nanak um urupat aria nape nenek urkum nanak um enyudok nyatogur iri mugu. ");
INSERT INTO apec_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Aria ahudok atuh nyumnah, biom hanakum anabur wabur nyeiguriburum Emeus. Rougun um agundok shupe Jerusalem shunak um Emeus um douk hurukatin um 11 kilomita. ");
INSERT INTO apec_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Douk amam hanak aria hape haneyagwreh hanakum enyudok ihinyumorim mugu douk nyatogur iri. ");
INSERT INTO apec_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Amam haneyagwreh aria shopunek henek urkum hape hanarigum hanak. Aria Jisas anan kanak nanaki hurukatin aria nani amam hanak atin. ");
INSERT INTO apec_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Aria amam hatrun aria amam madae hudukeman hukri anan douk Jisas uwe, uwok. ");
INSERT INTO apec_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Aria anan narigam nakri, “Ipak pape panaki aria pape peyagwreh um maresh?” Douk anan narigam namudok aria amam heyotu abom. Aria amamiruh aparuh yoweruh abom aria amamigos yamagos sotohiyahi. ");
INSERT INTO apec_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Aria anan shahwaran um Kliopas iri narigan nakri, “Sabaishi kupairubi warubish douk shanaki shape Jerusalem iri shadukemesh um enyudok douk nubokuhiyeh nyumnah nyatogur Jerusalem iri. Aria douk ta nyak atin nyape Jerusalem iri madae nyudukem enyudok mugu douk nubokuhiyehi nyatogur iri uwe?” ");
INSERT INTO apec_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Aria Jisas narigan nakri, “Maresh shatogur?” Aria amam hakripan hakri, “Enyudok sheneken um Jisas douk nanaki wabur Nasaret iri. Anudok Jisas anan douk anan profet. Aria ihishmorim arpesh shani Iruhin shatrun um, anan douk dodogowin atunari arman abom. Anan apa nenek Iruhin atun neneken iri mour. Aria anan dodogowin atun nakripesh yopinyi atin baraen. ");
INSERT INTO apec_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Aria apakim debeimi pris hani amudok anam apakim debeimi um apakin kansol iri hekeshan nor gavman esheshis wis aria amam debeimi um gavman iri habo baraen um hon nugok. Aria anan douk henek nyiluman rowog kruse aria han nagok. ");
INSERT INTO apec_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Aria apak douk munek bilip makri arman douk Iruhin nagraehan neshopokan nanakumori nukweshih apak Israel um mupe wosik iri douk ta anan. Aria baraen douk madae enyudok atin uwe, uwok. Enyudok douk nyatogur nubokuhiyeh nyumnah. Aria doukih douk henek biyeh atih um. ");
INSERT INTO apec_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","23","Aria iganigadae ono armago douk wani apak masuhw ananin baraen magipeshen iri wenekop makitak yowiyokuk agundok ruhur atin wanak um wonugwehw hwape um aria madae utrun nukus numun wonugwehw um uwe. Aria owo wata watanamori aria wakripap wakri owo adur watik enesh enselahos aria shakripo iri shakri Jisas ta nakitak nape. ");
INSERT INTO apec_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","“Aria anam apakim armam hakitak hanakum wonugwehw hwape um aria hatik um oudok armago wakrienyi baraen douk adurin. Aria namudok atin, amam shopunek madae hutrun nukus uwe, uwok.” ");
INSERT INTO apec_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Aria Jisas nakripam nakri, “Ipak atin urkwip madae enep pupenyep uwe. Ipak baragos seshuk aria ipakip urkwip madae arigas purum enyudok ihinyumorim baraen douk seiwok amam profet hakriyenyuk iri aria punek bilipumen pukri adurin uwe. ");
INSERT INTO apec_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Ipak ta padukemesh aka, uwok? Krais douk Iruhin nagraehan neshopokan nanakumori nunarao arpesh iri ta shon nurao debeiri eriger nugok iyoh aria Iruhin douk ta nutuk ananin nyeigur nyuto iruhw.” ");
INSERT INTO apec_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Aria Jisas nananubur neyagwreh Moses nenyemaguk nyetem Iruhin ananik Buk iri baraen nape nakripam arigaha neyaten aria nakripam um ihim-morim profet henyemaguk iri. Anan nape naworumom baugos um hudukemesh um enyudok ihinyumorim baraen nyetem Iruhin ananik buk iri douk nyakrium anan kanak. ");
INSERT INTO apec_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Aria douk nakripam nanak aria hurukatin um hunak hutogur abrudok wabur douk amam hakri hunakabur iri, aria anan nenek rohw abom aria nagim yah nanak. ");
INSERT INTO apec_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Aria amam dodogowim hasuweshan um nini amam hupe aria hakripan hakri, “Nyak yowi nyuni apak mupe agundok. Aun douk hurukatin um nubuhuk aria hurukatin um wab.” Aria anan nanak nawish nani amam hape. ");
INSERT INTO apec_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Douk hape aria amam hapeum hakri huwok worigun aria anan nakitak nani amam hape herharih tebol. Aria nohur bret nenek beten nenek tenkyu um Iruhin aria naworut nako amam. ");
INSERT INTO apec_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Aria abudok nyutob amam hatrun aria wata hadukeman. Aria anan brukwaranuk aria amam madae hutrun uwe. ");
INSERT INTO apec_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Aria amam hanakripam hakri, “Iganigadae magim yah manakumori anan douk nakripohw iri baraen nyetem Iruhin ananik buk iri. Aria anan douk naworamohw baugenyum baraen abom. Aria abudok nyutob ohwakish mishish douk sheyotuoh abom aria ohwak wanadudareh.” ");
INSERT INTO apec_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Douk amam haneyagwreh namudok abom um jurug aria abudok nyutob amam wata hakitak hatanam hanakum Jerusalem. Amam hanak hatogur aria haparug amudok 11-poreim disaipel hani eshudok enesh shagipesh Jisas iri shantorum shape. ");
INSERT INTO apec_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Aria eshesh shakripam shakri, “Adur atin. Debeini wata nakitak. Anan douk natogurum Saimon aria natrun.” ");
INSERT INTO apec_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Aria amam biom shopunek, hakripesh um enyudok nyatogur-umam yah iri nyani agundok anan nawor bret nakomat aria amam douk hatrun yamag hadukeman um. ");
INSERT INTO apec_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Aria douk amam wata hape hakripesh enyudok baraen atin aria ahudok atuh Jisas anan kanak natogur meyoh aria neyotu agundok eshesh shapeum. Aria nakripesh nakri, “Eik yakri Iruhin nunekep ipakiruh aparuh hur wosik.” ");
INSERT INTO apec_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Aria eshesh shakitak yowiyokuk aria shanogugur abom. Um maresh? Eshesh shenek urkwip shakri eshesh ta shatik anan yoweini sagaben. ");
INSERT INTO apec_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Aria anan narigesh nakri, “Ipak panogugur aria pakitak yowiyokuk um maresh? Aria ipak por biyep urkwip um maresh? ");
INSERT INTO apec_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Tiki eikigas aiyas aria roguhw. Enyudok douk eik kanak Jisas. Ipak punaki pusuwe ipakis wis aria pishakome aria ipak ta pudukemesh. Sagabehos busiguh aria eibug madae enesh shupenyesh uwe. Aria eik douk patrue eibug aria busiguh shapeye.” ");
INSERT INTO apec_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Douk anan nakri enyudok aria neyabig ananis wis aria aiyas. ");
INSERT INTO apec_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Aria eshesh shatrun aria shanadudareh aria shopunek, eshesh shakitak yowiyokuk. Aria eshesh madae shunek bilip abom shukri anan douk Jisas uwe, uwok. Douk namudok aria anan narigesh nakri, “Ipak pabuk anagun worigun agundok aka, uwok?” ");
INSERT INTO apec_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Aria eshesh shohuri anap wobrap iri arbup shakonap. ");
INSERT INTO apec_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Aria anan natrishop aria napoh esheshis nabes. ");
INSERT INTO apec_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Aria anan nakripesh nakri, “Riguk eik wata yani ipak mape aria yakripepuk yakri, ihinyumorim baraen douk henyem Iruhin ananik Buk nyakrium eik iri ta nyutogur adurin atin. Enyudok baraen enen douk nyape Moses nenyemaguk iri Iruhin ananin lo. Aria enen nyape amam profet henyemaguk iri, aria enen nyape buk shahwarok um Sam iri.” ");
INSERT INTO apec_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Aria anan nutaurumesh nohur esheship urkwip um shudukemesh wosik baugenyum baraen nyetem Iruhin ananik Buk iri. ");
INSERT INTO apec_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Aria nakripesh, nakri, “Baraen nyetem Iruhin ananik Buk iri douk nyakri Krais douk Iruhin nagraehan neshopokan nanakumori nunarao arpesh iri ta numnek debeiri eriger aria shon nugok. Aria douk hukri um biyeh atih nyumneh um, anan ta wata nukitak nupe. ");
INSERT INTO apec_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Aria um Jisas ananin nyeigur, eshesh ta shukitak um mour Jerusalem shupe shukripesh yopinyi baraen ihish arpesh arigaha shiyatak ihis awirosish arpesh shape agundok atap iri. Eshesh ta shukripesh um Jisas ananin nyeigur um shukeshuk agabus yoweishi inahos aria shatanam shukon aparuh Iruhin aria anan ta nukweshih esheshish yoweishi inahos. ");
INSERT INTO apec_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Aria ipak ta pukripesh baraen um eshudok douk patrish shatogur iri. ");
INSERT INTO apec_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Aria ipak mnek. Enyudok douk seiwok eikin Yain nakri adurin atin baraen um ta nukepen iri douk enyudok ta douk ishopoken nyubuhi nyuwishep. Aria ipak pupe agundok Jerusalem arigaha purao enyudok dodog nyanaki iruhw heven iri nyubuhi nyuwishep dodogowip iyoh.” ");
INSERT INTO apec_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Aria anan naraesh shakutukuk Jerusalem shanak arigaha shatogur wabur Betani. Douk shanak shatogur aria anan nohur roguhw nakripesh yopinyi baraen um Iruhin nunekumesh yopinyi. ");
INSERT INTO apec_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Aria douk anan wata nape nakripesh atin aria Iruhin wata naran nakutishuk natoum iruhw heven. ");
INSERT INTO apec_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Aria eshesh sheyotu shenek lotuman agundok um jurug aria wata shatanam shanak um Jerusalem. Aria eshesh shanadudareh shariguk. ");
INSERT INTO apec_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Aria shapeum shatuk Iruhin ananin nyeigur nyato iruhw namudok atin gani numun Iruhin ananit debeiti urupat. ");
INSERT INTO apec_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Seiwok Iruhin watak nenek agudok nahobig uwe aria anudok arman shahwaran um Baraen iri douk nape. Nani Iruhin hape. Aria anan douk adur atin Iruhin. ");
INSERT INTO apec_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Seiwok baugos um shanarubur shanakwaram um, anan nani Iruhin hape. ");
INSERT INTO apec_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Iruhin madae nenek enen enyudok anan atun uwe, uwok meyoh. Iruhin nakwu anudok arman Baraen nenek eshudok ihishmorim eneshenesh. ");
INSERT INTO apec_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Anan douk adur atin baugos um agundok arpesh shupe abom aria mare shugok um. Shopunek anan douk kabi anat lait tagruk iri tadukogun aria ihishmorim arpesh shanotrugun um. ");
INSERT INTO apec_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Atudok lait douk tadukemesh um tagruki tudukogun agundok arukwutigun um. Aria arukwutigun ko nubirak um nubuwehat aria ta amu uwok. ");
INSERT INTO apec_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Iruhin neshopok anan narauri ananin baraen iri arman nanaki. Aria ananin nyeigur douk Jon. ");
INSERT INTO apec_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Anan douk nanamori nukrip arpesh um atudok lait. Umum ihishmorim shumnek nakripesh-enyi baraen aria shusuhw anudok arman nape kabi lait morim um ananin baraen dodog aria shugipeshen. ");
INSERT INTO apec_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Anan Jon douk madae atudok lait uwe, uwok. Aria Jon douk nanamori nukripesh baraen um anudok arman nape kabi lait morim um. ");
INSERT INTO apec_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Anudok arman douk nape kabi adur atin tagruk iri lait morim douk nanamorim atap agudok nahobig um nutaurum ihish arpesh ta shudukem Iruhin iri. ");
INSERT INTO apec_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Seiwok Iruhin nakwu anudok arman Baraen nenek atap agudok nahobig aria douk napenyog. Aria eshudok atapishi arpesh um agudok nahobig douk madae shutrun aria shudukem anan uwe, uwok. ");
INSERT INTO apec_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Aria anan adur atin nanamorim ananibur shokuburi wabur. Aria ananish arpesh douk shakonaguk agabus aria shakri uwok um anan. ");
INSERT INTO apec_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Aria enesh douk shemnekan aria shasuhw ananin baraen dodog shagipeshen. Namudok aria eshesh douk nekesh debeishi nyeiguhw um shubuh ananig nuwag aria nagraehesh um shutogur Iruhin ananish batowish. ");
INSERT INTO apec_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Aria eshesh madae shutogur Iruhin ananish batowish meyoh um amakenyish esheshis nyomais uwe, uwok. Aka um eshesh kanak shutogur shupe meyoh aka, enesh shukripesh aria anob nyutob ko shutogur Iruhin ananish batowish uwe, uwok. Iruhin anan kanak nagraehesh aria shatogur ananish batowish. ");
INSERT INTO apec_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Anudok arman shahwaranum Baraen iri douk narao arpenyihw yegenyihw aria nanaki nani apak mape. Apak douk matik um agundok anan dodogowin atun abom um, aria ananin nyeigur nyato gani iruhw um. Iruhin anan douk atun arag nuganin meyoh aria douk natauruman nenekan natogur dodogowin, aria nyeigur nyato iruhw aria neshopokan nanaki. Ahudoki aih um shenek gihaum arpesh shutaurumesh meyoh abom um hani sheyagwreh adurin atin baraen um douk nyape um anan. ");
INSERT INTO apec_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Aria Jon douk nakripesh um anudok arman iri. Nakripesh namudok nakri, “Arman nubo riguk yakripepuman iri douk anudok. Douk yakripep namudok. Yakri, ‘Anudok arman nugimori eik iri anan douk debeini abom um eik. Aria eik shokuwe iri meyoh. Umum maresh? Eik watak shiyubuki uwe aria anan douk seiwok nape.’” ");
INSERT INTO apec_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Anan douk apa nataurum apak meyoh ihih nyumneh abom iri. Aria ihih nyumneh anan douk napeum nenekumop yopihi aih um apak sabaishi arpesh. ");
INSERT INTO apec_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Seiwok Iruhin douk nakonari lo Moses nanaki nakripeshen. Aria Iruhin neshopok Jisas Krais nanaki narauri Iruhin ananin giha aria nataurumap meyoh aria nakripap adurin atinyi baraen. ");
INSERT INTO apec_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Aria seiwok madae enen atin arpen nyutik Iruhin uwe amu uwok meyoh. Aria anudok ananin Nuganin douk adur atin nape huruk um ananin Yaken iri, anan atun douk natik Iruhin. Natrun aria douk nakripapuman. Namudok aria apak madukeman. ");
INSERT INTO apec_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Eshesh Juda esheshim debeimi heshopok anam pris hani anam um apudok awirop Livai hakutukuk Jerusalem aria hanak hatik Jon. Hanak aria harigan hakri, “Nyak amiapen?” ");
INSERT INTO apec_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Jon nemnek aria madae nukrium nubeshuk-umam baraen aria ta mare nukripam uwe, uwok. Aria adur atin nowereh-umam baraen. Aria anan nakripam-enyi baraen douk enyudok. Anan nakri namudok, “Eik madae Krais uwe, uwok, anudok douk Iruhin nakri um ba nagraehan aria neshopokan nanamori nurao arpesh iri uwe, uwok.” ");
INSERT INTO apec_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Aria harigan hakri, “Namudok aria nyak douk meinyari? Nyak Ilaija aka?” Aria nakripam nakri, “Eik douk madae Ilaija uwe, uwok.” Aria ta harigan hakri, “Nyak douk atin anudok profet douk mape matrugun-umen um ta nyutograri iri aka, uwok?” Aria anan nakripam nakri, “Uwok”. ");
INSERT INTO apec_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Namudok aria harigan hakri, “Namudok aria kripap. Nyak douk amiapen? Umum maresh? Apak ta musuhw enen baraen mutanam um mukrip amudok debeimi douk heshopokap ba manamori marigen iri. Kripap, nyak nyakri nyak douk adur atin meinari arman?” ");
INSERT INTO apec_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Aria Jon nakripam nakri, “Eik anudok arman douk seiwok profet Aisaia nenyemaguk iri baraen nakriyanari. Aria baraen enyudok, ‘Enen arpen nyape nyohwar gani wehigunum arpesh uwok um iri nyakri, “Gapesh yah hupe yopuh um Debeini nigimah nanaki um.” ’ ");
INSERT INTO apec_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Amudok armam douk hanaki harig Jon enyudok baraen iri douk amam Farisi heshopokam hanaki harigan. ");
INSERT INTO apec_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Aria harigan hakri, “Nyak douk nyakri nyak madae Krais uwe uwok aka, Ilaija aka, anudok debeini profet uwe, uwok. Namudok aria amiapen nyakripen ba nyenek baptaisum arpesh?” ");
INSERT INTO apec_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Aria Jon ta nakripam nakri, “Eik yenek baptaisumesh abar meyoh. Aria agundok douk atin anan arman douk nani ipak peyotu. Aria ipak madae pudukeman uwe, uwok. ");
INSERT INTO apec_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Anan douk nagimori eik iri. Aria eik douk madae yopuwe iri um ikweshihuman madururuh um ananiyu su uwe, uwok.” ");
INSERT INTO apec_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Jon douk neyagwreh enyudok baraen wabur Betani. Ababur douk bape gani wobrehahibum worub Jodan douk anan nape nenek baptaisumesh um. ");
INSERT INTO apec_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Gagruk ruwahepih aria Jon natik Jisas nanaki um nutrun. Aria Jon nakripesh nakri, “Putik anudok arman. Anan douk kabi Iruhin ananin Nagaen Sipsip um. Anan douk nanamori nukweshih yoweishi inahos um apak ihishmorim mape menekesh agudok atapig nahobig iri aria Iruhin nukweshihesh. ");
INSERT INTO apec_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Arman anudok douk yakripepuman iri. Douk yakripepuman yakri, ‘Anan nagimori eik iri arman douk adur atin debeini. Eik uwok, shokuwe iri meyoh. Umum maresh, eik douk watak shiyobuki uwe aria anan douk seiwok narik nape. ");
INSERT INTO apec_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Eik kanak douk madae idukemesh um anan adur atin douk anudok Iruhin nagraehan iri meinari arman um uwe, uwok. Aria eik douk yanaki yenek baptaisumesh um abar aria natogur yopugunum aria ipak Israel ta ko putrun pudukeman.’” ");
INSERT INTO apec_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Aria Jon nakripesh enyudok baraen um shudukem Jisas um. Nakripesh nakri, “Eik yatik Iruhin ananin Mishin nyabuhi iruhw heven kabi arudok armir manyun um nyabuhi nyape Jisas. ");
INSERT INTO apec_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Eik kanak douk madae idukemesh um arman douk Iruhin nagraehan aria neshopokan nanaki iri douk anan um uwe, uwok. Aria Iruhin douk neshopok eik yanamori inek baptaisumesh aria nakripe nakri, ‘Ko nyutik eikin Mishin nyubuhi nyupe anan arman aria nyuwishan. Aria anudok arman douk ko nekesh eikin Mishin nyuwish sabaishi arpesh aria nyupeyesh.’ ");
INSERT INTO apec_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Eik douk yatik enyudok mugu nyatogur aria douk yakripep. Anan douk adur atin abom um Iruhin ananin nuganin.” ");
INSERT INTO apec_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Gagruk ruwahepih aria Jon nani biom ananim disaipel heyotu worub Jodan. ");
INSERT INTO apec_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Heyotu aria Jon natik um Jisas nanakmorim neshagrakuk amam nanak. Aria nakri, “Ipak putik anudok arman. Anan douk Iruhin ananin Nagaen Sipsip.” ");
INSERT INTO apec_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Douk ananim biom disaipel hemnekan nakri namudok aria heir Jisas hanak. ");
INSERT INTO apec_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Jisas natanam natrum um hagiman hanak aria narigam nakri, “Ipak paurim maresh?” Aria amam harig anan hakri, “Rabai, nyak nyape agnum?” Muwanam enyudok baraen Rabai um, douk nyakri Debeini Tisa. ");
INSERT INTO apec_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Aria nakripam nakri, “Yowi puname munak aria putik agundok eik yapeum.” Aria hanaman hanak hatik agundok napeum. Hatrugun aria hani anan hape agundok ahudok nyumnah. Umum maresh? Nyumnah douk hatogur 4-klok wabigep. ");
INSERT INTO apec_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Amudok biom douk hemnek Jon aria hagipesh Jisas hanak iri, anan douk Andru. Anan douk Saimon Pita ananin wanin. ");
INSERT INTO apec_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Aria Andru nanak arigas atin naurim ananin ashuken Saimon. Nanak naparugan natrun aria nakripan nakri, “Apak iganigadae maparug aria matik Mesaia.” Muwanam enyudok baraen um, douk nyakri Krais anudok douk Iruhin nagraehan aria neshopokan nanamori nunarao arpesh iri. ");
INSERT INTO apec_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Aria Andru narao Saimon um Jisas aria nakri, “Nyak Saimon. Nyak douk Jon ananin nuganin. Kweipon aria douk ko ta shuhwarenyum Sifas.” Baugenyum baraenyum eshudok nyeiguhw Sifas aria Pita douk shakri atin baraen. Shakri utom. ");
INSERT INTO apec_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Aria gagruk ruwahepih Jisas nakri um nanam agudok shokugi nahobig Galili. Nanak aria naparug Filip aria nakripan nakri, “Yowi nyugipesh eik.” ");
INSERT INTO apec_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Filip nani Andru aria Pita douk hanaki atubur wabur Betsaida. ");
INSERT INTO apec_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Douk Filip nanak naparug Nataniel aria nakripan nakri, “Anudok arman douk Moses nowem Iruhin ananin baraen okwudok lo nyetemok iri buk nyani enyudok enen amam profet henyemoguk aria hakriyuk um ko nunaki iri douk maparugon. Anan douk Josep ananin nuganin shahwaran um Jisas iri. Anan douk nanaki wabur Nasaret iri.” ");
INSERT INTO apec_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Aria Nataniel narig Filip nakri, “Nyak douk adur atin nyakri wosik um enesh yopishi eshudok ko shutogur aburdok wabur Nasaret aka uwok?” Aria Filip nakripan nakri, “Namudok aria, yowi unak aria ba nyutrun.” ");
INSERT INTO apec_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Douk Jisas natik Nataniel nanaki um nutrun, aria neyagwreh enen baraen um anan nakri, “Anudok arman nape Israel iri, anan douk anan um yopunari arman. Nyunogiagigi baraen douk madae niyagwrehen iri uwe, uwok.” ");
INSERT INTO apec_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Aria Nataniel narig Jisas nakri, “Nyak nyadukeme mumam?” Aria Jisas nakripan nakri, “Filip watak nunaku nuhwaren uwe, aria eik douk yatrin nyape shukamenyum rowog fik.” ");
INSERT INTO apec_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Aria Nataniel nakri, “Debeini Tisa, nyak douk Iruhin ananin Nuganin. Aria adur atin apak Israel apakin king.” ");
INSERT INTO apec_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Aria Jisas watak apa nakrip Nataniel nakri, “Nyak nyenek bilip um eik, um maresh douk agundok douk yakripenyum yatrin nyape shukamenyum rowog um, aka? Yakripen, eneh nyumneh ta nyutik enenyenen Iruhin atun neneken iri mour. Eik ta ineken nyenek uhwinyum enyudoki iri mour.” ");
INSERT INTO apec_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Aria Jisas ta nakripam nakri, “Adur atin yakripep. Eneh nyumneh ipak ta putik utag tukurog gunak giyotukuk tukwotukwan aria ta putik iruhw heven. Aria ta putik Iruhin ananish enselahos shenek to buh shunamorim Eik douk Anudok Arman yatogur adurinyi arpen iri.” ");
INSERT INTO apec_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Biyeh nyumneh hanak hatuhuk aria hakri biyeh atuh um, aria biyesh arpesh shunaraum abrudok wabur Kana. Abrudok wabur Kana douk bape agudok shokugi nahobig Galili. Aria Jisas ananik amakek douk shopunek kwanak kwatrish. ");
INSERT INTO apec_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Aria Jisas nani apak ananim disaipel douk shopunek shohwarop aria monak matrish um agundok eshudok biyesh arpesh shunaraumoguni worigun. ");
INSERT INTO apec_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Douk arigaha shawok wainibar abar sheyatabar aria Jisas ananik amakek kwakrip Jisas namudok, “Wainibar abar douk shabroh sheyatabar.” ");
INSERT INTO apec_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Aria Jisas nakripok namudok, “Nya, nyak yopukwi armatok mare nyukrip eik um inek enesh eshudok uwe, uwok. Eikib nyutob um inek enyudokmorim mour um douk watak bunaki uwe, uwok.” ");
INSERT INTO apec_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Aria ananik amakek kwakrip eshudok douk shenek mour um worigun iri namudok, “Anan nukripep um penek maresh um, aria ipak ko penekesh.” ");
INSERT INTO apec_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Atudok urupat douk shobuk 6-poreis debeisi utaboris marus sakus. Shosubuk sakus um shereiri abar bor aria eshesh Juda shugipesh eneh esheshih aih aria shishrokuh um. Asudok marus atup atup eshesh ta shushar sabaibari abar um 100 lita bubuh buros. ");
INSERT INTO apec_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Aria Jisas nakrip eshudok douk shenek mour iri namudok, “Pishar abar asudok marus.” Nakripesh aria shereiri abar shourakabar babuh marus arigaha shunukis atus. ");
INSERT INTO apec_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Aria nakripesh namudok, “Arigah pugi anabar purabar punak um debeini um agundok worigun iri.” Namudok aria shagi anabar sharabar shanaman. ");
INSERT INTO apec_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Sharabar aria nokwiraehabar aria abrudok abar douk Jisas nenekabar batogur wainibar jurug. Aria anan douk madae nudukemesh uwe um abrudok wainibar abar banaki meigunum iri uwe, uwok. Aria eshudok douk shenek mour iri sharao anabar shanak shokonabar iri douk shadukemesh. Namudok aria debeini um agundok worigun iri nohwari anudok narao armatok iri nanaki. ");
INSERT INTO apec_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Aria nakripan namudok, “Ihim armam henek worigun um henekesh namudok, sagomatin amam hurik hurauri yopuni wain aria shunoh ba iyoh. Aria anudok anan madae yopuni iri uwe amam ko hugiguk hurani aria shunoh. Aria nyak douk nyobukuk adurini yopuni wain nakusuk arigaha namukadae atin nyonuhuri aria shanoh.” ");
INSERT INTO apec_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Aria enyudok douk dodogowinyi nyarik iri Iruhin atun neneken iri mour douk Jisas neneken iri. Neneken um niyabig Iruhin ananin debeinyi dodogowinyi dodog. Anan neneken abrudok wabur Kana bape um agudok shokugi nahobig Galili iri. Aria apak ananim disaipel matrin menek bilip makri anan douk adur atin Iruhin ananin nuganin. ");
INSERT INTO apec_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Douk shenek enyudok um jurug aria Jisas nabuhum Kaperneam. Nani ananik amakek kwani ananim owarhim aria apak ananim disaipel. Mabuh aria mape eneh nyumneh nagundok. ");
INSERT INTO apec_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Nyutob hurukatin um eshesh Juda ko shenek agundok debeiguni Pasovaigun worigun um nutogur. Aria Jisas natoum Jerusalem. ");
INSERT INTO apec_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Nato aria nanak nawish numun aburdok nabur Iruhin ananit debeiti urupat tataoum aria natik armam hape henek bisnis hanokom um kauhos shani sipsipahos aria armiguhw douk hwape kabi douk maishub um. Aria shopunek natik armam hape herharih tebolhos aria henek bisnis harao kupairubi worubish esheshibor utabor aria hekesh kupaibori utabor. ");
INSERT INTO apec_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Natik namudok aria nohur anaruh madururuh nereharuh hatogur kabi douk anat margit um aria nakwu atudok margit nape nehiyah sabaimi armam hani sipsipahos aria kauhos shatogrukuk aduk um agundok Iruhin ananit debeiti urupat tataoum. Nabadig-umam tebolhos amudok henek bisnis harao kupairubi warubish esheshibor utabor aria hekesh kupaibori utabor iri aria utabor prakarubor banakuk atum atumuk. ");
INSERT INTO apec_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Aria nakrip amudok henek bisnis um armiguhw iri namudok, “Puhur ipakiguh armiguhw ba kare punak! Ipak douk mare penek eikin Yain ananit urupat tutogur um kabi douk anat maketit urupat um uwe, uwok.” ");
INSERT INTO apec_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Aria apak ananim disaipel urkwip ta porum enen baraen nyetem Iruhin ananik Buk iri. Aria baraen douk nyakri namudok, “Eikim urkum adur atin makri munawasham um nyakit urupat, kabi nyih hanuwe um. Namudok aria eik yenek mour dodog yagapesh atudok urupat tupe wosik atin.” ");
INSERT INTO apec_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Eshesh Juda esheshim debeimi hatik enyudok aria hakripan debeg hakri namudok, “Nyak ta nyenek enen maren kak um Iruhin atun neneken iri mour ba apak mutrin aria mudukemesh mukri nyak douk adur atin Iruhin neken big aria nyanaki nyenek enyudok agundok numun ananit urupat.” ");
INSERT INTO apec_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Jisas nemnek aria ta nakripam nakri namudok, “Ipak pudigur atudok Iruhin ananit debeiti urupat tubuh tukus atap, aria um bihatuh nyumneh aria eik ta ituhur tiyotu iruhw.” ");
INSERT INTO apec_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Aria amam ta hakri namudok, “Um 40-poreish kwarahos apakishi sharok atudok Iruhin ananit debeiti urupat, aria nyak nyakana ta nyurukat um bihatuh nyumneh atih aka?” ");
INSERT INTO apec_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Aria douk Iruhin ananit debeiti urupat anan nakriyat iri, anan douk nakri anan kanak ananihw yegenyihw. ");
INSERT INTO apec_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Namudok aria abudok nyutob shan nagok aria Iruhin ta nonuhuri wonugwehw um batogur, aria apak ananim disaipel urkwip ko porum enyudok baraen nubokadae riguk anan nakriyenyuk iri. Aria douk, menek bilip makri Jisas neyagwrehen iri baraen nyani enyudok nyetem Iruhin ananik Buk iri douk adurin atin. ");
INSERT INTO apec_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Ehudok nyumneh douk shenek agundok Pasovaigun worigun ehi, Jisas douk nape Jerusalem. Nape aria nenek sabainyi Iruhin atun neneken iri mour douk arpesh shatrin aria sabaishi shasuhw ananin baraen shagipeshen. ");
INSERT INTO apec_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Douk Jisas natrish namudok um agundok shasuhw ananin baraen dodog um aria madae nubo urkum nenek bilip um eshesh douk shenek bilip aria shasuhw ananin baraen um uwe, uwok. Umum maresh? Anan douk nadukemesh um ihish arpesh esheship urkwip por ahi aih. ");
INSERT INTO apec_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Douk madae enen arpen ta nyukuna nyukrip Jisas um arpesh shape shenek ahi aih uwe, uwok. Anan nadukemesh um ihish arpesh esheshish urkum apahw shape ahi aih. ");
INSERT INTO apec_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Anan arman shahwaran um Nikodemus iri douk nape. Anan douk anan Farisi aria anan debeini um Juda esheshin kaunsol. ");
INSERT INTO apec_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Anab wab, anudok arman Nikodemus nanak natik Jisas aria nakripan nakri namudok, “Debeini Tisa, apak madukemesh um nyak douk anan tisa douk Iruhin nakripen um nyanaki nyenek skulum apak um ananin baraen iri. Aria enyudok Iruhin atun neneken iri mour douk nyak nyape nyeneken iri, apak madae enen arpen ta wosik nyeneken uwe, uwok. Umum maresh? Iruhin douk nini enen arpen shupe um, aria enyudok arpen ko nyenek enyudoki mour.” ");
INSERT INTO apec_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Aria Jisas ta nakripan nakri namudok, “Adur atin yakripen, douk enen arpen mare ta nyutogur namunyi um, enyen ko mare nyuwish abrudok wabur Iruhin nape Debeini um ananish arpesh shapeum uwe, uwok.” ");
INSERT INTO apec_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Aria Nikodemus ta narigan nakri namudok, “Enen ruwehenyi arpen douk ta nyutogur enen moduhwuraen batowin mumam? Aria enyen wosik douk ko ta nyuwish enyenyik amakekwibur nyibur aria ta kunyubuki anah shopunek aria nyutogur kabi douk enen moduhwuraen batowin um, aka uwok?” ");
INSERT INTO apec_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Aria Jisas ta nakri namudok, “Adur atin yakripen. Douk arpesh ta mare shutogur namushi um agundok shenek baptaisum abar iri aria shurao Iruhin ananin Mishin nyunekesh shutogur namushi um, aria eshesh ta mare shuwish abrudok wabur Iruhin nape Debeini um ananish arpesh shapeum uwe, uwok. ");
INSERT INTO apec_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Arpesh douk shabuki batowish iri eshudok douk adur shatogur arpesh. Aria arpesh douk Iruhin ananin Mishin nyawish nyapeyesh iri, eshesh douk adur atin shatogur Iruhin ananish batowish. ");
INSERT INTO apec_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Aria ipak mare pukitak yowiyokuk um enyudok baraen eik yakriyenyi um, ‘Douk ipak ta putogur namushi um.’ ");
INSERT INTO apec_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Aria uhwin nyahur um enyen kanak enyenyih yah aria nyanam kupa-kupaigunum. Nyak nyumnek enyenyin sirisoro nyunak um, aria nyak madae nyudukemesh um enyen nyanaki agunum aria enyen nyunak agunum. Aria ihish arpesh douk Iruhin anin Mishin nyunekesh shatogur namushi iri douk namudok atin.” ");
INSERT INTO apec_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Aria Nikodemus ta narig Jisas namudok, “Enyudok mugu nyak nyakriyenyi ta nyutogur mumam?” ");
INSERT INTO apec_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Aria Jisas nakripan nakri namudok, “Umum maresh ba nyak nyarig eik namudok? Nyak douk anan um eshesh Israel esheshin tisa, aria enyudok eik yakrienyi baraen nyak madae nyudukemen uwe aka? ");
INSERT INTO apec_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Adur atin yakripen. Apak douk meyagwreh um eshudok madukemesh iri aria makripep baraen um eshudok matrish iri. Aria ipak douk pakenyuk agabus enyudok apakin baraen. ");
INSERT INTO apec_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Eik yakripep baraen um eshudok shatogur agudok atapig nahobig iri aria ipak douk madae penek bilip um eikin baraen uwe, uwok. Namudok aria ta ikri um ikripep um iruhw hevenish eshudok akure, ipak douk ta mare pusuhw eikin baraen pukri adurin uwe, uwok. ");
INSERT INTO apec_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Aria douk madae enen arpen nyuto um iruhw heven uwe, uwok. Aria douk Eik Anudok Arman yatogur adurinyi arpen iri eik atuwe yakutukuk iruhw heven aria yabuhi agudok nahobig. ");
INSERT INTO apec_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Seiwok Moses nahao enen rowog agundok wehigunum douk arpesh uwok um. Aria nowaur anar yur douk nenekor brasin ain iri rataur. Aria douk ta namudok atin. Eik Anudok Arman douk yatogur adurin arpen iri ko shutuke shiyaur itaur enen rowog. ");
INSERT INTO apec_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Umum ihishmorim arpesh douk shusuhw eikin baraen shigipeshen iri, eshesh douk ko shupe wosik abom ihih nyumneh. ");
INSERT INTO apec_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Iruhin anan douk atun arag Nuganin meyoh nape. Aria Iruhin nakri nanawasham abom ihish arpesh um agudok nahobig, namudok aria anan neshopoki anudok atun nuganin um eshesh. Aria eshesh shusuhw ananin baraen dodog aria eshesh ta mare shunak shuwishuk uwe, uwok. Aria ko shupe wosik abom ihih nyumneh. ");
INSERT INTO apec_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Iruhin madae neshopok ananin Nuganin nunamori agudok atapig nahobig um nunemesh baraen arpesh kabi douk anan jas um uwe, uwok. Aria anan douk neshopokan nanamori nurao ihish arpesh shutanamori shupe wosik atin. ");
INSERT INTO apec_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Eshudok douk shusuhw ananin baraen shugipeshen iri, Iruhin ko mare nunekumesh baraen aria nukri um eshesh ko shunak um debeihi nyih, uwok. Aria eshudok douk madae shusuhw ananin baraen shugipeshen iri uwe, Iruhin douk nenekumesh baraen aria riguk anan adur nakri eshesh yoweishi ta shunam debeihi nyih. Umum maresh? Eshesh douk madae shunek bilip um anudok Iruhin ananin atun Nuganin uwe, uwok. ");
INSERT INTO apec_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Baugenyum baraen um agundok Iruhin ko nunemesh baraen um douk namudok. Arman nape kabi laitmori douk nanaki nabuhi agudok atapig nahobig, aria arpesh esheship urkwip panasuhw yoweishi inahos pape kabi douk arukwutigun um. Aria lait shanoiwosat. Umum maresh? Eshesh douk shapeum shenek yoweishi inahos atin iri. ");
INSERT INTO apec_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Ihish arpesh douk shapeum shenek yoweishi inahos iri, eshesh douk shenek horin horik um anudok arman douk nape kabi lait um iri. Eshesh douk shakri uwok um esheshish yoweshi inahos shutogur yopugunum aria ihishmorim shanoiwos um shanaki um lait. ");
INSERT INTO apec_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Aria eshudok douk shenek adurih yopihi atih aih iri, eshesh douk shanamori anudok arman kabi douk lait um. Arpesh shanaki um shutik enyudok yopunyi mour douk Iruhin nakri um eshesh shuneken iri douk sheneken um Iruhin ananin dodog.” ");
INSERT INTO apec_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Douk enyudok nyanakuk aria Jisas nani ananim disaipel hanam agudok shokugi nahobig Judia. Hanak hape agundok aria hape henek baptaisumesh. ");
INSERT INTO apec_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Jon douk shopunek nape nenek baptaisumesh aburdok wabur Ainon. Aburdok wabur douk bape hurukatin um Salim aria sabaibari abar bor nagundok. Namudok aria arpesh shanaki aria nape nenek baptaisumesh. ");
INSERT INTO apec_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Aria abudok nyutob, Herot douk watak nuweshik Jon nupe shunuweshik-ati urupat uwe, uwok. ");
INSERT INTO apec_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Aria anam Jon ananim disaipel hani anan arman Juda um eshesh hape hanitok baraen um agundok eshesh Juda shagipesh esheshin lo aria sheshrokuh abar um shakri Iruhin nutrish aria nuhwaresh yopishi um. ");
INSERT INTO apec_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Aria amam disaipel hanamori Jon aria hakripan hakri namudok, “Debeini Tisa, anudok arman nubokuhi riguk nani nyak pape gani wobrehah-ibam worub Jodan aria douk nyakripapaman iri anan douk nape nenek baptaisumesh. Aria ihish arpesh douk shanam anan atun aria shakutukuk apak.” ");
INSERT INTO apec_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Jon nemnek baraen aria nakripam namudok, “Douk Iruhin nape heven iri nukri uwok um nuken mour enen arpen um, enyen meyoh ta mare nyuhur enyudok mour nyuneken uwe, uwok. ");
INSERT INTO apec_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Ipak douk pemneken enyudok baraen riguk yakriyen iri. Douk yakri, ‘Eik douk madae anudok arman douk Iruhin nakri um nagraehan aria neshopokan nanamori nurao arpesh iri uwe, uwok. Aria eik douk Iruhin nagraehe aria neshopoke yarigi. Anudok arman douk ta nigigi.’ ");
INSERT INTO apec_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Aria douk arman nakana nurao onok armatok um, namudok aria okwudok armatok ta kutogur ananik irohukwik. Aria ananin arpenyin ta niyotu apa nubuk arigos nunadudareh um numnek anudok nurao armatok iri ananih mah. Namudok aria douk eik yanadudareh abom um eikish urkum apahw. ");
INSERT INTO apec_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Umum maresh? Ananin nyeigur ta nyuto iruhw aria eikin nyeigur ta nyubuk atap.” ");
INSERT INTO apec_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","“Aria anudok anan nape gani iruhw heven aria nabuhi iri, anan douk debeini um ihishmorim um eshudok eneshenesh. Aria anudok douk natogur agudok nahobig iri, anan douk nadukem agudok nahobigih aih aria neyagwreh agudok nahobigin baraen. Aria anan nape iruhw heven ba nanaki iri, douk debeini neshagrakuk ihish arpesh shubuh atap aria anan nukih netemuk iruhw. ");
INSERT INTO apec_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Anan nakripap um eshudok anan natrishi aria nemenekenyi baraen. Anan nakripap, aria madae enesh arpesh shumnek ananin baraen aria shusuhwen shugipeshen uwe, uwok. ");
INSERT INTO apec_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Eshudok douk shemnek ananin baraen shasuhwen shagipeshen iri, eshesh showerehen shakri Iruhin nakriyen iri baraen douk adurin atin abom. ");
INSERT INTO apec_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Anudok arman Iruhin neshopokan nanaki iri anan douk nakrip arpesh um Iruhin ananin baraen. Umum maresh? Iruhin nakoni ananin Mishin nyawish nyape shuknin um anudok arman aria nyatauruman nenek enyudok mour. ");
INSERT INTO apec_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Aria, Yaken douk urkum manawasham abom um ananin Nuganin aria nakon ihishumori eshudok aria anan nape debeinarimesh. ");
INSERT INTO apec_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Aria eshudok douk shumnek anudok Nuganin ananin baraen shusuhwen shigipeshen iri, eshesh ta shupe wosik abom ihih nyumneh. Aria eshudok douk shukonaguk agabus Nuganin iri aria mare shugipesh ananin baraen iri, eshesh ta mare shupe ihih nyumneh uwe, uwok. Aria Iruhin ananish urkum apahw juwehosish atish um eshesh aria ko shunam debeihi nyih shumnek eriger ihih nyumneh.” ");
INSERT INTO apec_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Arigaha aria amam Farisi hemnek um shakri “Jisas neshagrakuk Jon nenek baptaisum sabaishi arpesh aria nanukesh shagipesh anan.” ");
INSERT INTO apec_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Aria Jisas anan kanak douk madae nunek baptaisum enesh arpesh uwe, uwok. Aria apak ananim disaipel atup menek baptaisumesh. ");
INSERT INTO apec_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Douk Jisas nemnek um amam Farisi hemnek enyudok aria ta shopunek nakutukuk Judia aria natanam nanam agudok anag shokugi nahobig Galili. ");
INSERT INTO apec_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Aria ahudok yah hanam Galili iri douk hawish hanak agudok anag shokugi nahobig Samaria. Aria anan douk nagimah nanak. ");
INSERT INTO apec_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Nanak arigaha nanak natogur anabur wabur shohwarabur um Sikar. Ababur douk bape agudok shokugi nahobig Samaria iri aria bape hurukatin um abudok shokubi amnab seiwok Jekop nako ananin nuganin Josep obi. ");
INSERT INTO apec_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Anag abar bakihogi nuwag seiwok Jekop narukogi, gape noburudok wabur. Jisas nagim rouhi yah nanaki abom aria nakana nupe nurao uhwin. Namudok aria anan nahagi nape anagasum abarig nuwag. ");
INSERT INTO apec_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Nape aria douk onok um eshesh Samaria kwanaki um kwure abar aria nakripok namudok, “Shuke anabar abar ba ibroh.” ");
INSERT INTO apec_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Aria apak ananim disaipel douk manak mawish aburdok wabur Sikar um mutori anagun mugnoh iri worigun. ");
INSERT INTO apec_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Aria okwudok armatok kwakripan kwakri namudok, “Nyak douk Juda-ipimin aria eik douk Samaria-ipiyarik. Nyak ko mare nyorige um iken abar nyubroh uwe, uwok.” Okwok kwakri namudok umum maresh? Eshesh Juda shani eshesh Samaria douk madae shuni kupaishi aka shuwok worigun aturuh yaureruh uwe, uwok. ");
INSERT INTO apec_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Aria Jisas nakripok baraen nakri namudok, “Nyak douk nyudukemesh um yopishi eshudok Iruhin nakri um nukenyesh meyoh iri, namudok aria nyak douk nyudukemesh um amiapen douk nyarigen um nyuken abar, aria douk ko nyerige um iken yopubari abar douk arpesh shabroh aria benekesh shupe wosik abom ihih nyumneh iri.” ");
INSERT INTO apec_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Kwomnek namudok aria kwakripan kwakri namudok, “Debeini, nyak douk baket woken um ta nyereiri abar um. Aria shopunek agudok abarig nuwag douk gabuh abom gani atap. Aria abrudok abar douk arpesh shubroh aria shupe wosik abom ihih nyumneh um ko nyubaruri agunum? ");
INSERT INTO apec_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Apakin yamenen Jekop nenemapukuk agudok abarig nuwag apak. Anan nani ananim nugamim shabrohag. Shabarur um ananish kauhos aria sipsipahos shopunek shabroh. Aria nyak douk nyakri nyak debeini nyenek uhwin um Jekop, aka?” ");
INSERT INTO apec_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Aria Jisas nakripok namudok, “Eshudok arpesh douk shuwok agudok nuwagibar abar iri, eshesh ko ta abar besh. ");
INSERT INTO apec_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Aria meishi eshudok douk shurao abar eik ikeshabar iri, eshesh ko mare ta abar besh shopunek uwe, uwok. Abrudok abar eik ikeshabar iri, ababar ko butogur bukih buwish bupe numun um eshesh aria ko bunekesh shupe wosik abom ihih nyumneh.” ");
INSERT INTO apec_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Okwudok armatok kwomnek aria kwakripan namudok, “Debeini, nyak nyuke abrudok nyakriyabar iri abar. Nyuke um aria abar ko mare ta be aria ipeum ta mare apa inaki agundok ba ire abar uwe, uwok.” ");
INSERT INTO apec_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Aria Jisas nakripok nakri namudok, “Kare ba hwari nyakin raminen aria ta punaki agundok.” ");
INSERT INTO apec_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Kwomnek aria kwakripan, “Eik raminen madae anan uwe, uwok.” Aria Jisas nakripok, “Enyudok douk adur atin, um nyakana nyak raminen uwok um. ");
INSERT INTO apec_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Umum maresh? Nubokadae riguk nyak douk nyurao 5-poreim armam. Aria anudok douk atin nyanaman pape iri, anan douk madae nyakin adurin raminen uwe, uwok. Nyakin baraen douk adurin atin.” ");
INSERT INTO apec_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Aria okwudok armatok kwakripan, “Debeini arman, eik yadukemesh um nyak douk anan profet. ");
INSERT INTO apec_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Apakish popehesh yamehesh eshesh Samaria douk shenek lotu um Iruhin ahwudok yoduhw. Aria ipak Juda douk pakri agundok arpesh ta shunak shunek lotu um Iruhin um douk nape gani Jerusalem atugun.” ");
INSERT INTO apec_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Aria Jisas nakripok namudok, “Nya, nyusuhw eikin baraen aria nyunek bilipumen. Nyutob ta butogur, aria ipak ta mare punek lotu um Yain um ahwodok yoduhw aka, um Jerusalem. Ipak wosik ta punek lotu um ihigun morim. ");
INSERT INTO apec_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Ipak Samaria douk madae pudukem anudok douk penek lotumanari uwe, uwok. Apak Juda douk madukeman anudok monek lotumanari. Umum maresh? Mour douk Iruhin neneken um nurao arpesh shutanamori shupe wosik atin um douk neneken iri nyakitak um apak Juda. ");
INSERT INTO apec_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Aria nyutob ta butogur iri douk abudok batogur jurug um arpesh douk shenek lotu um Yain iri ta shukri adurin atin aria shurao ananin Mishin enyenyin dodog aria shenek lotuman. Eshesh ta shenek lotuman um adurih yopuhi atuh aih kabi douk anan napeum. Aria Yain nakri nunawasham namudokishi arpesh um shenek lotuman. ");
INSERT INTO apec_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Iruhin anan douk yegenyihw uwok. Anan douk Mishin atin. Namudok aria arpesh shukri shunek lotu um anan iri, esheshish mishish ta shurao Iruhin ananin Mishin enyenyin dodog aria shugipesh adurin atinyi baraen aria shenek lotuman.” ");
INSERT INTO apec_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Okwudok armatok kwomnek aria kwakripan kwakri namudok, “Yadukemesh um Mesaia ko nunaki. Anudok arman Krais douk Iruhin nagraehan aria ko neshopokan nunamori nurao arpesh iri. Abudok nyutob anan nutogur um, anan ta nukripap um ihishmorim eshudok.” ");
INSERT INTO apec_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Aria Jisas ta nakripok nakri namudok, “Eik atuwe eik adur atin anudok arman, douk yape yanamen weyagwreh iri.” ");
INSERT INTO apec_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Douk nawerehumok baraen aria apak ananim disaipel watak manak matograri. Aria apak munihap meyoh makitak yowiyokuk um agundok matrun nani onok armatok shape sheneyagwreh baraen um. Matrun, aria madae anan norig okwudok armatok nukri, “Nyanaki agundok um maresh?” aka norig Jisas nukri, “Nyani okwudok armatok pape peyagwreh baraen um maresh?” Madae morigesh uwe, uwok. ");
INSERT INTO apec_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Aria okwudok armatok kwobukuk baket douk kwakri kure abar um aria ta kwatanam um wabur. Kwanak aria kwakrip armam armago kwakri namudok, ");
INSERT INTO apec_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Ipak yowi munak ba putik anudok arman douk nakripe um ihishumori eshudok riguk yape yenekesh iri eshudok. Aria anan douk adur atin Krais aka, meinari?” ");
INSERT INTO apec_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Namudok aria shakutukuk wabur shanak um shutik Jisas. ");
INSERT INTO apec_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Aria nabudok nyutob apak ananim disaipel meyagwreh dodog um Jisas makri namudok, “Debeini Tisa, suh anagun worigun ba kukwesh.” ");
INSERT INTO apec_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Nemnek aria nakripap nakri namudok, “Eik yagnoh iri worigun douk madae pudukem-ogun uwe, uwok.” ");
INSERT INTO apec_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Namudok aria apak ananim disaipel mape manasorim makri namudok, “Iganigadae enen arpen nyaraumanari anagun worigun nagnoh aka, uwok?” ");
INSERT INTO apec_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Aria Jisas nakripap nakri namudok, “Eikish worigun douk eshudok. Igipesh anudok douk neshopoke yanaki iri um ananim urkum aria iyatak enyudok mour douk nekeyen um ineken iri. ");
INSERT INTO apec_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","“Ipak apa panakripam namudok, ‘Nubatib aub bape um, aria mutuk worigun nubarigos.’ Eik yakripep, ipak pupok ipakis nabes ba putik nubarigos! Worigun douk nauhogos um apak mutukagun. ");
INSERT INTO apec_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Armam hatuk worigun iri ko hurao yopibori utabor. Umum maresh? Amam ta hutorumori worigun iri um eshudok shabadig nyirub iri arpeshish mishish shutanamori um shupe wosik abom ihih nyumneh! Anudok nau worigun nubarigos iri aria anudok natuk worigun nubarigos iri biobiom ko hunadudareh abom. ");
INSERT INTO apec_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Enyudok enen baraen apa sheyagwrehen iri douk adurin baraen. Baraen enyudok, ‘Anan arman nau worigun aria kupainari nanaki natukesh! ");
INSERT INTO apec_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Eik yeshopokep panak um purimori worigun nubarig douk riguk ipak madae punek mour um uwe, uwok. Kupaimi heneguk mour aria ipak puwish purimori worigun douk haweshag iri aria harik heneguk debeinyi mour um. Amam henek debeinyi mour aria ipak parao yopuguni worigun.” ");
INSERT INTO apec_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Sabaishi Samaria shape Sikar iri douk shasuhw Jisas ananin baraen aria shagipeshen. Umum maresh? Eshesh douk shemnek okwudok armatok kwakri, “Anan nakripe um ihishmori riguk yape yenekesh iri eshudok.” ");
INSERT INTO apec_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Douk namudok aria eshesh Samaria shanaki agundok Jisas napeum aria dodogowish shakripan um nini eshesh shupe. Namudok aria nani eshesh nape biyeh nyumneh aburdok wabur. ");
INSERT INTO apec_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Sabaishi arpesh shemnek ananin baraen shakri adurin aria shasuhwen shagipeshen. ");
INSERT INTO apec_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Aria shakrip okwudok armatok shakri, “Apak douk madae mumnek nyakin baraen atin aria munek bilipumen uwe, uwok. Apak kanak memnek ananin baraen aria madukemesh makri anan douk anudok arman douk ko nutaurum ihip mape agudok nahobig iri aria ta nurap mutanamori mupe wosik atin.” ");
INSERT INTO apec_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Jisas nape abrudok wabur biyeh nyumneh um jurug aria nakutukuk agundok aria nanam shokugi nahobig Galili. ");
INSERT INTO apec_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Riguk Jisas anan kanak nakri enyudok baraen namudok, “Anan profet, ananibur wabur douk madae shumneken uwe um ananin baraen aria shukri anan douk debeini uwe, uwok.” ");
INSERT INTO apec_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Namudok aria abudok nyutob nanak natogur agudok shokugi nahobig Galili obi nyutob, eshesh Galili shanadudareh abom um agundok anan nanak um. Umum maresh? Abudok nyutob riguk shenek agundok debeiguni worigun Pasova obi nyutob, eshesh douk shanak aria shatik ihinyumori anan neneken iri debeinyi Iruhin atun neneken iri mour. ");
INSERT INTO apec_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Aria nanak natogur natik aburdok wabur Kana. Ababur douk bape agudok shokugi nahobig Galili. Abrudok wabur douk nubokuhi nabadig abar meyoh batogur wainibar abar iri. Aria abudok nyutob anan nenek mour um gavman iri ananin nuganin douk eneh arugeh hapeyan aria anan douk nape wabur Kaperneam. ");
INSERT INTO apec_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Douk anudok arman nemnek um Jisas nakutukuk agudok shokugi nahobig Judia aria nanamori shokugi nahobig Galili aria nanak narigan abom um nanaman hunam Kaperneam aria nugapesh ananin nuganin um yapun. Anan douk ehudok arugeh henekan aria hurukatinyum nakana nugok. ");
INSERT INTO apec_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Aria Jisas nakripan nakri, “Aria ipak putiwe um mare inek enenyenen Iruhin atun neneken iri mour um, ipak ta mare punek bilipume, uwok.” ");
INSERT INTO apec_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Anudok nenek mour um gavman iri nemnek aria nakrip Jisas nakri, “Debeini arman, yowi unak arigah. Ta eikin nuganin nugok.” ");
INSERT INTO apec_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Aria Jisas nakripan nakri, “Kare. Nyakin nuganin ta yopun, ta mare nugok uwe, uwok.” Anudok arman nasuhw Jisas ananin baraen nakri adurin aria nanak. ");
INSERT INTO apec_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Nape nanak yah aria ananim henekuman mour iri hanaki haparugan. Aria hakripan hakri, “Nyakin nuganin iga yopun. Ta mare nugok uwe, uwok.” ");
INSERT INTO apec_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Aria narigam abom um meibi nyutob douk ananin nuganin watak yopun um. Aria hakripan hakri, “Arugeh hatuh nabatik 1 kilok wabigep.” ");
INSERT INTO apec_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Namudok aria yaken watak nadukemesh um nabatik douk abudok hakri obi nyutob abom Jisas nakripan nakri, “Kare, nyakin nuganin ta mare nugok uwe, uwok.” Namudok aria anan nani ihishmorim shape ananit urupat iri shasuhw Jisas ananin baraen shagipeshen. ");
INSERT INTO apec_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Jisas douk nakutukuk shokugi nahobig Judia aria nanaki nape Galili. Aria enyudokmori Iruhin atun neneken iri mour douk nenek enyudok aria nyatogur biyen. ");
INSERT INTO apec_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Enyudok nyanakuk aria anah debeihi nyumnah douk eshesh Juda shape shenek lotu aria shenek debeguni worigun um hutogur. Aria Jisas nakitak nanak um Jerusalem um nutrish um agundok worigun. ");
INSERT INTO apec_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Aria agundok Jerusalem, anat debeiti wit shahwarat um Sipsip Esheshit Debeiti Wit iri douk tape arbudok narub douk shenekarub berbarih Jerusalem iri. Aria hurukatin um atudok wit, anag waiyag gor. Enyudok baraen Hibru shahwarogum douk shakri Betesda. Aria hurukatin um agudok waiyag douk anat debeiti urupat tatao aria sharok 5-poreish womagahos. ");
INSERT INTO apec_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Aria sabaishi arugeh haesh iri arpesh shanaki shape sheshuh eshudok womagahos. Enesh nabes seshukesh iri, enesh aiyas senekesh aria sharahaen yowiyokuk iri shani eshudok douk roguhw aiyas shagokesh iri shanaki shape. Eshesh shape shatrugunum abar bunagwugwi um. ");
INSERT INTO apec_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Um maresh? Anob nyutob Debeini ananin ensel apa nyabuh abar aria nyenek abar banagwugwi. Aria douk abar bunagwugwi aria meinyi arugeh hen iri arpen nyurik nyukitak nyubuh agudok waiyag iri, enyen douk ta yopin. ");
INSERT INTO apec_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Aria agundok, anan aiyas sagokan iri nape namudok um 38-poreish kwarahos iri douk nape enen womaga douk nyatao hurukatin um agudok waiyag iri. ");
INSERT INTO apec_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Douk Jisas natik anudok aiyas sagokan iri neshuh aria nadukemesh um anan douk aiyas sagok nape roubum nyutob. Aria Jisas narigan nakri, “Nyak nyakrium ta yopin aka?” ");
INSERT INTO apec_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Aria anan nakripan nakri, “Debeini, abudok nyutob abar banagwugwi obi nyutob, eik douk arpen woke um nyiyohur nyunak nyukutuwe waiyag iri. Eik kanak yakri inak ibuh aria kupaishi shanak arigas sheshagrak eik sharik shanak shabuh.” ");
INSERT INTO apec_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Aria Jisas nakripan nakri, “Nyak kakitak nyuhur nyakish reish nyunasuwesh aria nyunak.” ");
INSERT INTO apec_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Aria ahudok atuh anudok arman yopun aria nakitak nohur ananish reish nasuwesh aria nanak. Aria ahudok nyumnah Jisas nagabe anudok aiyas sagokanari um douk Sabat. ");
INSERT INTO apec_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Douk namudok aria eshesh Juda esheshim debeimi hakrip anudok douk Jisas nagabeyan iri hakri, “Apakin lo seiwok Iruhin nakoguk Moses um douk nyakri, ahudok nyumnah Sabat douk mare munek enen mour uwok, mupe meyoh. Aria nyak douk mare nyusuhw nyakish reish nyurahaen uwe, uwok.” ");
INSERT INTO apec_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Aria anan nakripam nakri, “Anudok neneke yopuwe iri douk nakripe um ikitak ihur eikish reish inasuwesh aria inak.” ");
INSERT INTO apec_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Aria amam harigan hakri, “Meini arman nakripenyum nyunohur nyakish reish nyunasuwesh aria nyunak?” ");
INSERT INTO apec_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Aria anudok arman douk Jisas nagabeyan yopun iri douk madae nudukem Jisas uwe, uwok. Um maresh? Sabaishi arpesh shape agundok aria Jisas douk nanakuk. ");
INSERT INTO apec_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Arigaha douk anob nyutob banakuk aria Jisas watak naparugan numun narub agundok Iruhin ananit debeiti urupat tataoum aria nakripan nakri, “Tik, nyak douk yopun jurug. Nyunak aria mare watak nyukri nyunek enesh yoweishi inahos shopunek, uwok. Ta enen adur debeinyi amaen nyutogrumen.” ");
INSERT INTO apec_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Aria anudok arman nanak nakrip eshesh Juda esheshim debeimi um anudok nagabeyan iri douk Jisas. ");
INSERT INTO apec_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Douk namudok aria amam hape heyokas Jisas. Um maresh? Anan douk nagabe anudok arman ahudok nyumnah Sabat. ");
INSERT INTO apec_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Aria Jisas nakripam nakri, “Eikin Yain douk nenek ananin mour nape namudok ihihmorim nyumneh. Namudok aria eik shopunek yape yeneken namudok atin.” ");
INSERT INTO apec_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Douk Jisas nakri namudok aria amam debeimi Juda adur hakri hon nugok. Um maresh? Anan douk madae nubrig enyudok lo um mare shunek enen mour ahudok nyumnah Sabat um atin uwe, uwok. Anan nakri Iruhin douk adur ananin Yain. Aria douk namudok um, anan nakri nunek anan kanak adur nutogur atatahin atun um Iruhin. ");
INSERT INTO apec_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Aria Jisas nawanamesh baraen nakri, “Adur atin yakripep. Eik Iruhin ananin Nuganin, eik kanak ta mare inek enesh eshudok, uwok. Eik ta inek eshudok douk eik yatik eikin Yain nenekesh iri atish. Eshudok douk Yain nenekesh iri, eik shopunek ta inekesh. ");
INSERT INTO apec_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Yain ananim urkum douk adur manawasham um eik aria anan neyabige ihishmorim eshudok anan nape nenekesh iri. Anan ta niyabige inek enen douk nyeshagrakuk enyudok douk Yain narik neyabige yeneken iri. Ineken aria ipak ta putrin aria pikitak yowiyokuk. ");
INSERT INTO apec_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Yain apa nohur shagok iri norukesh yapis aria watak shakitak shape. Aria douk namudok atin. Eik ananin nuganin shopunek ta ihur eshudok eik ikri ishuhur iri. Ishuhur irukesh yapis aria watak shukitak shupe. ");
INSERT INTO apec_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Aria Yain anan kanak ta mare nusuhw enen arpen enyenyit kwot, uwok. Enyudok mour um nusuhw kwotog um douk nako eiken. ");
INSERT INTO apec_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Anan douk nenekesh namudok um ihishmorim arpesh ta shutuk eikin nyeigur nyuto iruhw kabi shatuk eikin Yain ananin nyeigur um. Aria enyudok arpen douk madae nyutuk eik ananin nuganin eikin nyeigur iri uwe, enyen douk madae nyutuk eikin Yain ananin nyeigur uwe, douk neshopoki eik yanaki, uwok. ");
INSERT INTO apec_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Adur atin yakripep. Eshudok arpesh douk shumnek eikin baraen aria shugipesh anudok douk neshopoke yanaki iri um, eshesh ta shupe wosik abom ihih nyumneh. Aria eshesh ta shiyotum atudok kwot Iruhin ananit aria ta shenek uhwinyum atudok debeiti kwot. Eshesh douk shakutukuk agundok shagok um aria ta shupe wosik abom ihih nyumneh. ");
INSERT INTO apec_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Adur atin yakripep. Nyutob douk ta butogur, aria douk batogur jurug, um shagok iri ta shumneki eik Iruhin ananin Nuganin eikih mah. Aria eshudok douk shumneke aria shugipeshe iri, eshesh ta shukitak shupe wosik abom aria mare ta shugok uwe, uwok. ");
INSERT INTO apec_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Yain douk adur baugos um agundok arpesh shupe wosik abom aria mare watak shugok um. Aria douk namudok atin. Anan nenek eik yatogur baugos um agundok arpesh shupe wosik abom aria mare watak shugok atin um. ");
INSERT INTO apec_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Aria Iruhin douk nekeyen jurug enyudok big um isuhw arpesh esheshig kwotog um. Um maresh? Eik douk Anudok Arman douk yatogur adurinyi arpen iri. ");
INSERT INTO apec_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","“Aria ipak mare pikitak yowiyokuk um shagok iri ta watak shutanamori. Nyutob douk bape banaki, um arpesh douk seiwok shagok aria sharumesh shor wonugwegwiruh iri ta shumneki eikih mah aria ta watak shukitak esheshiruh wonugwegwiruh um. ");
INSERT INTO apec_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Aria eshudok douk shenek yopuhi aih iri ta shukitak shupe wosik abom aria mare watak shugok, uwok. Eshudok douk shenek eneshenesh yoweishi inahos iri ta shukitaki shunak shiyotum debeiti kwot aria shirao debeiri eriger.” ");
INSERT INTO apec_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Aria Jisas nakri, “Eik kanak ta mare inek enesh eshudok um eikim urkum, uwok. Eik yagipesh eikin Yain nakripeyen iri baraen aria yenek skelum arpesh. Namudok aria yasuhw kwotog um, eik douk adur yenek skelum esheshin baraen um yopihi adurih aih. Um maresh? Eik madae igipesh eikim urkum aria inek enyudok mour uwe, uwok. Eik yagipesh anudok douk neshopoke yanaki ananin baraen aria yenek enyudok mour anan nakri um eik ineken iri. ");
INSERT INTO apec_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“Douk eik kanak ikri ikripesh um eik kanak akure, enyudok eikin yeyagwrehen iri baraen ta mare shusuhwen shukri adurin uwe, uwok. ");
INSERT INTO apec_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Aria douk anan nataurume nape nakripesh um eik. Aria eik yadukemesh um enyudok baraen anan nakriyen um eik iri douk adurin atin. ");
INSERT INTO apec_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","“Seiwok ipak peshopok anam harao baraen iri hanak harig Jon nenek baptaisumesh iri. Aria anan nakripep adurin atinyi baraen um eik. ");
INSERT INTO apec_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Aria eik douk madae ikri um enesh arpesh shukripesh eikin baraen kupaishi um shudukemesh um eik amiapen uwe, uwok. Eik yakri enyudok baraen um yakri Iruhin watak nuraep putanam pupe wosik abom ihih nyumneh. ");
INSERT INTO apec_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Jon anan nape kabi lam douk hanin aria bogaragun um arpesh um. Aria ipakiruh aparuh douk yopuruh aria panadudareh um ananit lait douk tatrugun abudok banobi adurib nyutob iri. ");
INSERT INTO apec_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","“Aria enyudok mour eik yeneken iri douk adur nyeshagrakuk enyudok baraen douk Jon nakriyen um eik iri. Enyudok mour douk Iruhin nekeyen um ineken iyaten aria douk enyudok yape yeneken iri, enyen meyoh ta nyiyabig arpesh aria shudukemesh um eik douk Yain neshopoke iri aria douk yanaki. ");
INSERT INTO apec_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Aria eikin Yain douk neshopoki eik yanaki, anan kanak douk nakripep baugenyum baraen um eik. Ipak douk madae pumnek ananit nokwat tiyagwreh anabik uwe, uwok. Aria shopunek ipak douk madae putrun uwe. ");
INSERT INTO apec_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Ananin baraen shopunek douk madae nyupe ipakiruh aparuh uwe, uwok. Um maresh? Ipak douk madae punek bilip um eik douk anan neshopoke yanaki uwe, uwok. ");
INSERT INTO apec_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","“Ipak pakri enyudok baraen nyetem Iruhin ananik Buk iri ta nyunekep pupe wosik abom ihih nyumneh! Douk namudok aria ipak pape patarih sabainyi baraen nyetem okwudok Buk iri, aria penek urkwip um pakri pudukemen. Enyudok nyetem Buk iri baraen douk nyakrium eik! ");
INSERT INTO apec_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Aria ipak adur pakri uwok um punamori eik um pupe wosik abom ihih nyumneh. ");
INSERT INTO apec_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Aria eik yakri uwok um arpesh shutuk eikin nyeigur, uwok. ");
INSERT INTO apec_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Aria eik yadukemep um ipakip urkwip douk madae punawasham Iruhin uwe, uwok. ");
INSERT INTO apec_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Eik douk yanaki um eikin Yain ananin nyeigur, aria ipak douk madae puke aparuh pukri pumnek eikin baraen uwe, uwok. Aria douk anan arman meyoh nunaki nukripep um anan kanak ananin nyeigur akure, ipakiruh aparuh ta yopuruh aria ta kweipon pumnek ananin baraen. ");
INSERT INTO apec_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Ipak urkwip porum pakri ipak kanak punatuk ipakish nyeiguhw shuto iruhw. Madae karowihi um pukwiraeh punek eneh aih um pukri anudok adur atun iri Iruhin meyoh nutuk ipakish nyeiguhw shuto iruhw uwe, uwok. Douk namudok aria ipak ta pusuhw eikin baraen pugipeshen mumam? Adur atin ta uwok. ");
INSERT INTO apec_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Aria ipak douk mare pure urkum pukri eik ta inekumep kwotog um eikin Yain, uwok. Arman nunekumep kwotog iri douk anudok ipak pakri ta nutaurumep iri. Anan douk Moses. ");
INSERT INTO apec_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Aria douk ipak punek bilip um Moses ananin baraen akure, ipak ta punek bilip um eikin shopunek. Um maresh? Moses nenyemaguk iri baraen douk nyakrium eik. ");
INSERT INTO apec_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Ipak douk madae punek bilip um enyudok baraen seiwok Moses nenyemaguk iri uwe, uwok. Namudok aria ipak ta punek bilip um eikin baraen mumam? Ta uwok.” ");
INSERT INTO apec_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Aria anob nyutob banakuk, aria Jisas nabinawish nanam gani wobrehah um agudok debeigi waiyag Galili. Enyudok enen nyeigur douk shahwarog um Taiberias. ");
INSERT INTO apec_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Aria sabaishi arpesh abom shagipeshan. Um maresh? Eshesh douk shatik enyudok Iruhin atun neneken iri mour douk anan neneken um nagabe eshudok arugeh henekeshi arpesh yopish um. ");
INSERT INTO apec_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Jisas nanak nato anag mihig aria nakih nani ananim disaipel hape nagundok. ");
INSERT INTO apec_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Aria abudok nyutob um eshesh Juda shenek agundok debeiguni worigun Pasova um douk hurukatinyum ta butogur. ");
INSERT INTO apec_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Jisas natrugun neyatagun aria natik um sabaishi arpesh abom shape shanamanari. Aria narig Filip nakri, “Filip, ta munak mutor anat bret agnum, um eshudok sabaishi arpesh ta shutoh iri?” ");
INSERT INTO apec_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Jisas narigan enyudok baraen um nakri nukwiraehan. Anan douk nadukemesh um enyudok mugu douk ta nuneken iri. ");
INSERT INTO apec_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Aria Filip nawanaman baraen nakri, “Douk apak ta muwashak 200-poreibor silwai-bor utabor um aria ta mutor anat bret akure, atudok bret ta mare sabaiti um eshudok sabaishi arpesh um ta shuwok anabik mudukigun meyoh uwe, uwok.” ");
INSERT INTO apec_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Aria anudok anan Jisas ananin disaipel Andru douk Saimon Pita ananin wanin nakri, ");
INSERT INTO apec_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Anan shokuni neyotu agundok iri douk noruk bias shokusi arbus sani 5-poreig shokugwi bretog. Aria eshudok douk shopunek ta shunek maresh um shutaurum eshudok sabaishi arpesh?” ");
INSERT INTO apec_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Aria Jisas nakripap nakri, “Kripesh shupe atap.” Agundok douk sabairuhi utoruh hatogur aria sabaishi arpesh shabuh shape. Sabaishi arpesh aria armam atum sabaimi atum abom hatogur 5,000-poreim. ");
INSERT INTO apec_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Douk shabuh shape jurug, aria Jisas nohur bret nasuwat nenek tenkyu um Iruhin aria nape nasiyat um arpesh. Nasiyatumesh jurug, aria asudok biyos arbus douk nosuhur nenekesh namudok atin. Aria eshesh sabaishi shashoh arigaha dugaresh atish. ");
INSERT INTO apec_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Douk sabaishi dugaresh aria nakrip apak ananim disaipel nakri, “Putrish putorum bret douk shatoh aria takusuk iri. Um maresh? Ta mununu anat aria ta tukusuguk meyoh uwe, uwok.” ");
INSERT INTO apec_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Memnek namudok aria matorumat matruk 12-poreiruh suraruh aria shunukiruh aturuh um tutukwanit um agudok 5-poreig bretog douk eshudok sabaishi arpesh shani batowish shagwoh aria gwakusuk iri. ");
INSERT INTO apec_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Douk eshudok arpesh shatik enyudok Iruhin atun neneken iri mour douk anan Jisas neneken iri aria shakri, “Adur atin, anudok arman douk anudok profet Iruhin nakri um ta neshopokan nanamori agundok atap iri.” ");
INSERT INTO apec_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Jisas natrish aria nadukemesh um eshesh hurukatinyum ta shunaki shusuhwan shupe aria shunegan nutogur esheshin king. Namudok aria nakutukuk eshesh aria anan atun nanak nato yoduhw. ");
INSERT INTO apec_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Douk arigaha wabigep aria apak ananim disaipel makitak mabuh um agudok debeigi waiyag. ");
INSERT INTO apec_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Apak mapeum Jisas aria anan madae nanaki aria mabuh mato anat bot aria mabimawish manak um wabur Kaperneam. Abudok nyutob douk iganigadae wab, aria Jisas douk watak nunaki nutogrumap uwe, watak. ");
INSERT INTO apec_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Aria abudok nyutob, debeinyi uhwin douk nyahur aria nyohur waiyag ba debeibi morub bakitak aria waiyag yoweg. ");
INSERT INTO apec_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Apak ta menek pul manak 5 o 6 kilomita rougun um anagas aria douk Jisas narahaen iruhw um waiyag nanaki hurukatinyum bot. Douk matik namudok aria manogugur abom. ");
INSERT INTO apec_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Aria Jisas nakripapari nakri, “Mare punogugur uwe, uwok. Enyudok douk eik Jisas.” ");
INSERT INTO apec_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Douk memnek aria manadudareh um mutukan nutowi bot. Aria ahudok atuh matik um bot tanak tatogur gani wobrehah um agudok waiyag douk apak mape menek pul manak um. ");
INSERT INTO apec_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Ruwahepih aria eshudok sabaishi arpesh douk watak shape gani wobrehah um agudok waiyag. Shadukemesh um nabatik madae anat atut bot tur nagundok uwe, uwok. Atut meyoh tor aria douk apak ananim disaipel iganigadae mato menek pul manak. Jisas madae nunamap munak uwe, uwok. ");
INSERT INTO apec_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Aria abudok nyutob, onog botog gworari wabur Taiberias iri douk gwanak gwatograri. Gwatograri hurukatin um agundok douk Jisas nenek tenkyu um Iruhin um bret aria nako eshudok arpesh shatoh um. ");
INSERT INTO apec_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Douk eshudok arpesh shatik um Jisas nani apak ananim disaipel madae mupe agundok uwe, aria shabuh shato agwudok botog shanam Kaperneam um shurim Jisas nagundok. ");
INSERT INTO apec_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Douk arigaha shanak shaparugan gani wobrehah um agudok waiyag aria shakripan shakri, “Debeini Tisa, meibi nyutob nyanaki agundok?” ");
INSERT INTO apec_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Aria Jisas nawanamesh baraen nakri, “Adur atin yakripep, ipakip urkwip douk madae purum enyudok yeneken iri debeinyi mour kabi enen kak eik yeyabigepum aria douk panaki paurime uwe, uwok. Ipak douk pawok bret ba dugarep atip namudok aria douk ipak apa paurim eik. ");
INSERT INTO apec_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Mare pupe punek mour um agundokmori worigun douk ta pishoh aria shunak shuwishuk iri uwe, uwok. Aria ipak douk punek mour um purim agundok anagun worigun douk ta puragun aria ta nunekep pupe wosik abom ihih nyumneh iri. Agundok worigun douk Eik Anudok Arman douk yatogur adurinyi arpen iri ta ikepagun. Um maresh? Yain Iruhin douk neke big aria nakripe wosik um inek enyudokmori mour.” ");
INSERT INTO apec_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Namudok aria sharigan shakri, “Aria apak ta munek maresh, um apak ta munek Iruhin ananin yopinyi mour?” ");
INSERT INTO apec_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Aria nakripesh nakri, “Mour douk Iruhin nakri um puneken iri douk enyudok. Anan douk neshopoki eik yanaki, aria nakri ipak ta pusuhw eikin baraen dodog pugipeshen.” ");
INSERT INTO apec_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Namudok aria eshesh watak sharigan shakri, “Ta nyunek maren Iruhin atun neneken iri mour um apak mutrin aria munek bilip um nyakin baraen? ");
INSERT INTO apec_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Apakish yamehesh douk shawok atudok bret mana gani wehigunum arpesh uwok um. Shatoh kabi douk Iruhin ananin baraen nyetem ananik Buk iri nyakrium. Nyakri namudok. ‘Anan nekesh bret tabuhi iruhw heven iri shatoh.’” ");
INSERT INTO apec_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Jisas nemnek aria nakripesh nakri, “Adur atin yakripep, atudok bret tabuhi iruhw heven iri douk madae Moses nukepat iri uwe, uwok. Eikin Yain nekep atudok adurit bret douk tabuhi iruhw heven iri. ");
INSERT INTO apec_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Bret douk Iruhin nekepat iri douk takutukuk iruhw heven aria tabuhumori tutaurum eshudok atapishi arpesh um shupe wosik abom ihih nyumneh.” ");
INSERT INTO apec_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Aria eshesh shakripan shakri, “Debeini, apak makri nyak nyupeum ta nyukop atudok bret ihih nyumneh.” ");
INSERT INTO apec_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Aria Jisas nakripesh nakri, “Eik douk atudok bret douk ta shurat aria shupe wosik abom ihih nyumneh um. Eshudok douk shunakmori eik aria shusuhw eikin baraen shugipeshan iri, eshesh mare ta nyurub besh shopunek uwe, uwok. Aria eshesh mare ta abar besh shopunek uwe, uwok. ");
INSERT INTO apec_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Aria ta douk yakripep, ipak douk patik eik aria madae pusuhw eikin baraen penek dodog pukri adurin uwe, uwok. ");
INSERT INTO apec_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Ihish arpesh douk eikin Yain nagraehesh um shunakmori eik iri ta shunakmori eik. Eshudok douk shunakmori eik iri, eik ta mare inowisesh ikeshuk agab uwe, uwok. ");
INSERT INTO apec_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Eik douk madae ikutukuk iruhw heven aria ibuhmori igipesh eik kanak eikim urkum um inek enenyenen mour um eikim urkum morumen iri uwe, uwok. Aria douk yanamori igipesh eikin Yain douk neshopoke yanaki iri um ananim urkum. ");
INSERT INTO apec_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Aria anan neshopoke yanaki iri nakri um ineken iri douk enyudok. Nakri mare ikutukuk enen um eshudok ihishmorim arpesh douk anan nagraehesh um shunamori eik iri shunak shuwishuk uwe, uwok. Aria nakri eik ta irukesh yapis eshesh aria watak ishuhur shukitak shupe abudok nyutob ko hugiguk iri nyumnah hutogurum. ");
INSERT INTO apec_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Adur, eikin Yain nakriyenyi douk enyudok atin. Nakri ihishmorim arpesh douk shutik eik ananin Nuganin aria shusuhw eikin baraen shugipeshan iri, eshesh douk ta adur shupe wosik abom ihih nyumneh. Aria douk ta watak irukesh yapis ishuhur shukitak shupe ahudok hugiguk iri nyumnah hutogrum.” ");
INSERT INTO apec_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Eshesh Juda shemnek aria urkwip juwehosip abom aria shape sheneyagwreh shokwin atin baraen um enyudok Jisas nakri anan douk atudok bret tabuhi gani iruhw heven iri um. ");
INSERT INTO apec_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Namudok aria shakri, “Anudok arman anan douk Josep ananin nuganin shahwaranum Jisas iri. Ananish amakenyish douk madukemesh. Aria douk mumam namudok, um iganigadae nakri anan douk nape gani iruhw heven aria nabuhi?” ");
INSERT INTO apec_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Jisas nemnek aria nawanamesh baraen nakri, “Ipak um maresh ba urkwip juwehosip aria ipak pape peyagwreh panaboum baraen orokohun um ipak kanak meyoh? ");
INSERT INTO apec_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Madae enen arpen ta nyukana nyunakmori eik uwe, uwok. Aria douk Yain neshopok eik yanaki aria nuhur enyudok arpen akure, enyen wosik ta nyunakmori eik aria nyusuhw eikin baraen nyugipeshen. Aria enyudok arpen, eik douk ta watak inyuhur nyukitaki wanugwehw ahudok hugiguk iri nyumnah hutogurum. ");
INSERT INTO apec_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Baraen douk profet henyem nyetem Iruhin ananik Buk iri douk nyakri, ‘Iruhin ta nunek skulum ihish arpesh um ananih aih.’ Namudok aria sabaishi arpesh douk shumnek eikin Yaken ananin baraen aria shudukemen wosik iri, eshesh ta shunakmori eik. ");
INSERT INTO apec_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Madae enen arpen nyutik Yain uwe, uwok. Eik douk yani Iruhin wape iri aria yakitak yanaki iri atuwe yatrun. ");
INSERT INTO apec_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","“Adur atin yakripep, ihishmorim arpesh douk shusuhw eikin baraen shugipeshen iri, eshesh douk ta shupe wosik abom ihih nyumneh. ");
INSERT INTO apec_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Eik Jisas douk atudok bret douk arpesh ta shurat aria tunekesh shupe wosik abom ihih nyumneh iri. ");
INSERT INTO apec_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Seiwok ipakish popehesh yamehesh douk shawok atudok bret mana gani wehigunum, aria eshesh douk shagok. ");
INSERT INTO apec_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Aria arpesh douk shuwok atudok adurit bret douk takutukuk iruhw heven tabuhi iri, eshesh douk ta mare shugok, uwok. ");
INSERT INTO apec_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Eik kanak douk atudok adurit bret douk tabuhi gani iruhw heven um ta tunek arpesh shupe wosik abom ihih nyumneh iri. Arpesh douk shuwok atudok bret iri ta shupe wosik abom ihih nyumneh. Atudok bret douk eikihw yegenyihw. Ta ikesh eikihw yegenyihw um itaurum ihishmorim eshudok atapishi arpesh um shupe wosik abom ihih nyumneh.” ");
INSERT INTO apec_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Douk eshesh Juda shemnek namudok aria juwehosish abom. Aria eshesh kanak apa shanogogonim shakri, “Anudok arman nakri ta nukop ananihw yegenyihw muhwoh mumam?” ");
INSERT INTO apec_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Aria Jisas nakripesh nakri, “Adur atin yakripep, douk ipak mare puwok Eik Anudok Arman douk yatogur adurinyi arpen iri eikihw yegenyihw o puwok eikibor owishibor um, ipak ta mare pupe wosik abom ihih nyumneh, uwok. ");
INSERT INTO apec_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Aria eshudok arpesh douk shuwok eikihw yegenyihw hwuni eikibor owishibor iri, eshesh ta shupe wosik abom ihih nyumneh. Aria ahudok hugiguk iri nyumnah hukri hutogur obi nyutob, eik douk ta watak ishuhur shukitak shupe. ");
INSERT INTO apec_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Um maresh? Eikihw yegenyihw ohwohw douk kabi adurigun worigun abom um. Eikibor owishibor douk shopunek kobi aduribar abar abom um. ");
INSERT INTO apec_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Eshudok arpesh douk shuwok eikihw yegenyihw hwuni eikibor owishibor iri, eshesh douk shape eik aria eik yape eshesh. ");
INSERT INTO apec_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Eikin Yain douk baugos abom um agundok shupe wosik abom ihih nyumneh iri um douk neshopoki eik yanaki. Aria eik douk yape dodogoiwe um anan aria ta ipe wosik abom ihih nyumneh. Aria douk namudok atin. Eik douk dodogoiwe iri aria eshudok arpesh shuwok eikihw yegenyihw iri, eik douk ta inekesh shupe wosik abom ihih nyumneh abom. ");
INSERT INTO apec_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Eik douk atudok bret douk tabuhi gani iruhw heven iri. Atudok bret douk madae kabi atudok seiwok ipakish yamehesh shatoh aria eshesh ta shagok um uwe, uwok. Arpesh douk shuwok atudok bret iri, eshesh ta shupe wosik abom ihih nyumneh.” ");
INSERT INTO apec_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Jisas nakripesh enyudok baraen aburdok wabur Kaperneam. Nakripeshen abudok nyutob nape nenek skulumesh yopinyi baraen gani numun eshesh Juda shape sheneyagwreh baraen-ati urupat obi nyutob. ");
INSERT INTO apec_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Sabaishi arpesh douk shapeum shemnek ananin baraen aria shagipeshen iri douk shemnek enyudok baraen aria sheneyagwreh shakri, “Enyudok baraen douk juwehosin abom um apak mugipeshen um. Ta omi nyupe nyumneken aria nyugipeshen?” ");
INSERT INTO apec_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Jisas douk madae enesh arpesh shukripan uwe, aria nadukemesh um eshesh douk juwehosish aria shape sheneyagwreh shokubur atin um enyudok baraen douk nakripeshen iri. Namudok aria nakripesh nakri, “Ipak douk pemnek enyudok baraen nyenek ipakip urkwip yowep aria juwehosip, aka? ");
INSERT INTO apec_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Aria douk ta mumam, douk ipak putik Eik Anudok Arman douk yatogur adurin arpen iri ito iruhw douk riguk yapeum? ");
INSERT INTO apec_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Arpesh meyoh ta mare dodogowish um shugok um eshesh kanak um shupe wosik ihih nyumneh, uwok. Iruhin ananin Mishin atin wosik dodogowin atin abom um nyunekesh shupe wosik abom ihih nyumneh. Enyudok eik yakripep enyi baraen douk ta nyutaurum ipakish mishish aria ta nyunekep pupe wosik abom ihih nyumneh. ");
INSERT INTO apec_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Yakripep baraen aria anep madae punek bilipume uwe, uwok.” Jisas anan douk sagomatin riguk nohur ananin mour nape neneken um aria nadukemesh um eshudok arpesh douk ta mare shunek bilipuman iri, shani anudok arman douk ta niyabig ananim horim um anan Jisas aria husuwan hunak hon nugok iri. ");
INSERT INTO apec_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Aria Jisas watak shopunek nakri, “Douk namudok aria yakripep yakri, ‘Douk Iruhin ta mare nuken dodog enen arpen um, enyen meyoh ta mare dodogowin um nyunaki nyunek bilip um eik, uwok.’” ");
INSERT INTO apec_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Jisas nakripesh enyudok baraen um jurug, aria sabaishi arpesh douk shapeum shagipeshen shemnek ananin baraen iri watak shakutunukuk aria shatanam. Madae shukri um shugipeshan uwe, uwok. ");
INSERT INTO apec_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Jisas natik namudok aria narig apak ananim 12-poreim disaipel nakri, “Aria ipak douk shopunek pakri pukutukuk eik punak, aka?” ");
INSERT INTO apec_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Aria Saimon Pita nawanaman baraen nakri, “Debeini, apak mukutukuk nyak aria ta watak manam amiapen? Aria uwok. Baraen douk ta nyutaurumap um mupe wosik abom ihih nyumneh um douk nyape um nyak atin. ");
INSERT INTO apec_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Douk apak menek bilip abom aria madukemesh um, nyak douk yopuyopuni arman douk Iruhin nagraehen aria nashopoken nyanaki iri.” ");
INSERT INTO apec_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Aria Jisas nabeimam baraen nakri, “Eik kanak yagraeh ipak 12-poreim armam. Aria ipak 12-poreim, ipak anan douk Satan ananin nuganin.” ");
INSERT INTO apec_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Enyudok baraen douk nakriyen nenyem Judas, anudok Saimon Iskariot ananin nuganin. Anan douk anan um amudok 12-poreim disaipel, aria anan ta niyabig Jisas um ananim horim aria amam hunaki husuwan hunak hon nugok. ");
INSERT INTO apec_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Enyudok nyanakuk aria Jisas nape agudok shokugi nahobig Galili nape narahaen nanak warub. Amam debeimi Juda hakri hon nugok. Namudok aria madae nunak nurahaen nunak agudok shokugi nahobig Judia uwe, uwok. ");
INSERT INTO apec_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Aria ahudok nyumnah um eshesh Juda shunek lotu um Iruhin aria shurak auros aria shuwish shupe shunek worigun um douk hurukatin um hutogur. ");
INSERT INTO apec_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Aria Jisas ananim warhim hakripan hakri, “Nyukutukuk agundok aria nyunak um Judia. Nyunak um nyakishi arpesh shagipesh nyak iri shutik enyudok Iruhin atun neneken iri mour douk nyak nyape nyeneken iri. ");
INSERT INTO apec_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Aria enen arpen nyukri um ihishmorim shumnek enyen um, enyen douk mare nyunabeshuk nyunek enyenyin mour atin uwe, uwok. Aria douk nyak nyenek enyudok aria ta nyeneken yopugunum, um ihishmorim ta shutrin atin.” ");
INSERT INTO apec_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Ananim baugem warhim heyagwreh enyudok. Um maresh? Amam shopunek madae hunek bilipuman uwe, uwok. ");
INSERT INTO apec_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Jisas nemnek aria nakripam nakri, “Eikib yopubi nyutob um inak um douk watak butogur uwe, uwok. Ihih nyumneh eheh douk ipakih. Ipak pakri punak um, aria ipak douk wosik ta punak meibi nyutob ipak pakri punak um. Eik uwok. ");
INSERT INTO apec_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Eshudok atapishi arpesh ta mare shutripuk yoweisi nabes aria shukepuk agabus ipak uwe, uwok. Eik douk wosik ta shutiwe yoweisi nabes aria ta shukeik agabus. Um maresh? Eik douk yape um yakripesh um eshudok yoweishi inahos douk eshesh shapeum shenekesh iri. ");
INSERT INTO apec_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Ipak atip wosik punam agundok debeiguni worigun. Eik ta mare arigas inaku uwok. Um maresh? Eikib yopubi nyutob um inak um douk watak butogur uwe, uwok.” ");
INSERT INTO apec_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Nakripam namudok aria watak napeik Galili. ");
INSERT INTO apec_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Douk ananim warhim hanam agundok debeiguni worigun aria Jisas shopunek nakitak nagiguk nanak. Nanak aria madae nunak yopugunum uwe, uwok. Nanabeshuk atin nanak. ");
INSERT INTO apec_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Eshesh Juda esheshim debeimi douk hape hauriman agundok shenek worigun um. Hape harigesh hanak hakri, “Patrun anudok arman nape agunum?” ");
INSERT INTO apec_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Sabaishi arpesh douk shanaki shantorum um shunek agundok debeiguni worigun. Aria shape shanaboum shokwin baraen sheneyagwreh shokubur atin um Jisas. Enesh shakri anan yopuni arman. Aria enesh shakri anan yoweini arman douk nenek rohw um arpesh meyoh. ");
INSERT INTO apec_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Aria yopugunum douk madae enesh arpesh shupe shiyagwreh-uman enen baraen uwe, uwok. Um maresh? Eshesh douk shanogugur um Juda esheshim debeimi. ");
INSERT INTO apec_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Shenek agundok debeiguni worigun arigaha shanak sheyotu orokohun aria Jisas nanak nawish narub um Iruhin ananit debeiti urupat tataoum aria nape nenek skulumesh um Iruhin ananin baraen. ");
INSERT INTO apec_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Douk eshesh Juda esheshim debeimi hatrun aria hakitak yowiyokuk. Aria hakri, “Anudok arman douk madae nunek skul enen apakin skul uwe, uwok. Aria mumam namudok um anan nadukemesh abom nariguk um?” ");
INSERT INTO apec_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Namudok aria Jisas nawanamam baraen nakri, “Enyudok baraen eik yenek skulumep-enyi douk madae inek skulumep um eikin baraen uwe, uwok. Yenek skulume-enyi douk Iruhin neshopoke yanaki iri ananin baraen. ");
INSERT INTO apec_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Aria enen arpen nyukri abom um nyugipesh Iruhin ananim urkum um, enyen douk ta nyudukem baugenyum enyudok baraen eik yenek skulumep-enyi. Enyen ta nyudukemesh um enyudok baraen douk Iruhin nakripe iri um inaki ikripepen o eik meyoh yananyuhur yakripepen. ");
INSERT INTO apec_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Arpen douk enyen kanak urkum mur um enen baraen aria nyiyagwrehen iri, enyudok arpen douk nyeyagwreh um nyutuk enyen kanak enyenyin nyeigur nyuto iruhw. Aria eik douk yakri ituk anudok douk neshopoke yanaki iri ananin nyeigur nyuto iruhw. Aria eik, rohwinyi baraen douk madae iyagwrehen atin uwe, uwok. Yeyagwreh adurin atin baraen. ");
INSERT INTO apec_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Seiwok Moses nekep lo douk Iruhin nakonenyuk iri. Aria douk madae karowin um enen arpen nyusuwen nyugipeshen wosik uwe, uwok. Aria douk ipak douk pakri pubo eik igok um maresh?” ");
INSERT INTO apec_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Aria eshudok sabaishi arpesh shawanaman baraen shakri, “Nyak enen yoweinyi sagab nyapenyen. Omi nyakrium nyen nyugok?” ");
INSERT INTO apec_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Aria Jisas nawanamesh baraen nakri, “Eik yenek atin Iruhin atun neneken iri mour um sabatih nyumnah gani abarig waiyag aria ipak ihipmorim patrin pakitak yowiyokuk. ");
INSERT INTO apec_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Aria Moses douk nekepaguk ehudok aih um putah nugamimiruh yegeshiweruh um. Aria ehudok madae punek mour ahi iri uwe nyumnah Sabat, ipak douk shopunek patah nugamimiruh yegeshiweruh. Adur, ehudok aih douk madae Moses nuhuhur nukepehuk uwe, uwok. Ihih douk ipakim popehem yamehem meyoh hehuhur hekepehuk. ");
INSERT INTO apec_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Ipak apa pagipesheh kabi enyudok lo douk Iruhin nakoguk Moses um enyudok patah nugamimiruh yegeshiweruh um. Aria ahudok nyumnah Sabat douk madae punek mour um uwe, ipak ta penek mour um patah nugamimiruh yegeshiweruh. Aria nubokuhi eik yagabe anan arugeh han iri arman yopun abom ahudok nyumnah Sabat um, ipak douk patiwe aria juwehosip abom um maresh? ");
INSERT INTO apec_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Mare putik enenyenen nabes meyoh aria pukri enyudok yopunyi o yoweinyi, namudok uwok. Aria enenyenen ipak ta pudukemen wosik aria douk punek adurih atih aih abom aria punek skelumen.” ");
INSERT INTO apec_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Enesh armam armago shape Jerusalem iri shatik enyudok Jisas neneken iri mour aria sheneyagwreh shakri, “Arman atun ta anudok, douk apakim debeimi hape apa hauriman um hon nugok iri aka? ");
INSERT INTO apec_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Aria douk tik. Anan douk nape neyagwreh agundok sabaishi shantorum shapeum, aria amam douk madae hukri uwok um niyagwreh uwe, uwok. Aria amam douk hadukemesh hakri anan Krais douk Iruhin nagraehan aria neshopokan nanakmori nunarao arpesh iri aka? ");
INSERT INTO apec_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Aria ananibur wabur douk madukemabur. Aria abudok nyutob Krais nutogrum, apak ta mare enen arpen nyudukem um abrudok wabur douk anan nunaki abur iri, uwok.” ");
INSERT INTO apec_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Jisas douk watak nape apa nenek skulumesh baraen gani numun narub atudok Iruhin ananit debeiti urupat tataoum. Aria anan watak neyagwreh debeinyi baraen nakri, “Adur, ipak douk pakri ipak padukem eik wosik. Wabur yanaki abur iri shopunek pakri padukemabur wosik. Aria eik douk madae inakumori eikim urkum uwe, uwok. Anudok neshopok eik yanaki iri douk adurin abom. Aria ipak douk madae pudukem anan uwe, uwok. ");
INSERT INTO apec_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Aria eik douk yadukeman. Um maresh? Eik douk yani anan wape aria neshopoke yanaki.” ");
INSERT INTO apec_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Douk nakri enyudok baraen aria amam debeimi Juda hakri husuwan hunak huweshikan nupe shunuweshik-ati urupat. Aria madae anan atun nuweman wis uwe, uwok. Um maresh? Abudok nyutob douk ta shon nugok um douk watak butogur uwe. ");
INSERT INTO apec_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Aria sabaishi arpesh shenek bilip um Jisas aria shakri, “Abudok nyutob Krais nutogur obi nyutob, aria anan douk ta nutogur nunek sabainyi Iruhin atun neneken iri mour nyishagrakuk enyudok anudok arman neneken iri aka? Aria ta uwok.” ");
INSERT INTO apec_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Arigaha aria amam Farisi hemnek um eshudok sabaishi arpesh shape sheneyagwreh shanak shokubur atin um enyudok Jisas neneken iri. Namudok aria amam hani amam debeimi pris heshopok anam armam heyoh Iruhin ananit debeiti urupat iri um hunak husuhw Jisas hurani. ");
INSERT INTO apec_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Aria Jisas nakripam nakri, “Eik ta ini ipak mupe banab nyutob meyoh. Aria ta watak itanam inak um anudok douk neshopoke yanaki iri. ");
INSERT INTO apec_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Aria ipak douk ta pupe purime, aria ta mare putiwe uwe, uwok. Agundok eik inak ipeum, ipak ta mare punaku.” ");
INSERT INTO apec_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Aria eshesh Juda esheshim debeimi heneyagwreh hakri, “Nakri ta nunak agnum, um apak ta mubirak mare mutrun um? Aria nakri ta nunam eshesh Grik esheshirub debeirubi warub douk enesh apak Juda shanak shapenyarub iri aka? Um nakri nunak nunek skulumesh Iruhin ananin baraen eshesh Grik aka? ");
INSERT INTO apec_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Anan douk nakri, ‘Ipak ta pupe purime, aria ta mare putiwe uwe, uwok.’ Aria shopunek douk nakri, ‘Ipak ta mare punaku agundok douk eik inak ipeum, uwok.’ Baugenyum enyudok baraen douk nyakri mumam?” ");
INSERT INTO apec_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Ahudok hagiguk iri nyumnah um agundok debeiguni worigun nutuh um douk debeihi nyumnah abom. Aria Jisas nakitak neyotu neyagwreh debeg atin aria nakri, “Eshudok arpesh douk abar baesh iri, eshesh douk ta shunakmori eik aria ta ikesh anabar abar shubroh. ");
INSERT INTO apec_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Eshudok arpesh douk shusuhw eikin baraen shugipeshen iri, abar douk ta bunekesh shupe wosik abom ihih nyumneh kabi douk madae bugeru iri worub iri ta bur bupe namudok gani numun esheshiruh aparuh aria butoguri aduk.” Enyudok ta nyutogur kabi baraen nyetem Iruhin ananik Buk iri nyakrium. ");
INSERT INTO apec_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Jisas douk nakri enyudok baraen um Iruhin ananin Mishin. Nakripesh um agundok douk shenek bilip um anan iri anah nyumnah ta shuraen nyupenyesh um. Aria seiwok arigaha douk Iruhin Ananin Mishin douk madae nyunaki nyuwishesh uwe, uwok. Um maresh? Jisas douk watak shon nugok aria nukitaki nuto um iruhw heven nukih nurao debeinyi nyeigur uwe. ");
INSERT INTO apec_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Douk shemnek enyudok baraen aria enesh shakri, “Adur atin anudok arman douk anudok profet douk Iruhin nakri abom um ta neshopokan nunakmori agundok atap iri.” ");
INSERT INTO apec_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Aria enesh shakri, “Uwok. Anan Krais douk Iruhin nagraehan aria neshopokan nanakumori nurao arpesh iri.” Aria enesh shakri, “Krais ta mare nukitak agundok shokugi nahobig Galili, uwok. ");
INSERT INTO apec_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Um maresh? Baraen nyetem Iruhin ananik Buk iri nyakri Krais ta nukitak apudok Devit ananip awirop, aria amakek ta kwunabuki aburdok wabur Betlehem douk seiwok King Devit napeum.” ");
INSERT INTO apec_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Namudok aria shanadi-yogurum. Enesh shakri Jisas anan adur anan Krais. Aria enesh shakri uwok, shenek rohw. ");
INSERT INTO apec_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Anam armam douk hakri husuwan hunak huweshikan nupe, aria madae enen karowin arpen nyukri um nyuweman wis uwe, uwok. ");
INSERT INTO apec_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Namudok aria amudok heyoh Iruhin ananit debeiti urupat iri watak hatanam hanak um amam debeimi pris hani amam Farisi. Hatanam aria amudok debeimi harigam hakri, “Ipak madae pusuwan purani uwe um maresh?” ");
INSERT INTO apec_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Aria amam hawanamam baraen hakri, “Riguk douk madae enen karowin arpen gamo nyiyagwreh kabi douk anudok arman neyagwreh um uwe, uwok.” ");
INSERT INTO apec_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Amam Farisi hemnek aria hawanamam baraen hakri, “Aria ipak douk shopunek nenek rohwumep um ananin baraen aka? ");
INSERT INTO apec_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Ipak douk da patik um apak anan debeini o anan Farisi nenek bilip um Jisas aka? Aria uwok meyoh. ");
INSERT INTO apec_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Aria eshudok sabaishi arpesh douk shenek bilipuman iri, eshesh douk madae shudukem Iruhin ananin lo uwe, uwok. Namudok aria Iruhin ta nunekumesh debeinyi baraen aria ta shupe yowesh abom.” ");
INSERT INTO apec_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Anan arman shahwaran um Nikodemus iri douk anan um amudok debeimi armam Farisi. Anan douk riguk nanak natik Jisas iri. Anan nakitak aria nakrip amudok debeimi nakri, ");
INSERT INTO apec_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Yaipo, kabi douk apakin lo seiwok Iruhin nakoguk Moses enyi nyakrium, apak ta mare arigas mukri enen arpen enyen douk nyenek yoweishi inahos, uwok. Apak ta mumnek enyenyin baraen douk mudukemesh um eshudok enyen nyenekesh iri iyoh, aria ta mukri.” ");
INSERT INTO apec_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Aria hawanaman baraen hakri, “Aria nyak douk shopunek enen um eshesh Galili aka? Nyak gamo nyutarih baraen nyetem Iruhin ananik Buk iri um, ta nyudukemesh um anan profet ta mare anan nukitak shokugi nahobig Galili, uwok.” ");
INSERT INTO apec_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Douk arigaha ihishmorim arpesh shanak sisig-ikuk um esheshig urusag. ");
INSERT INTO apec_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Aria Jisas natoum yoduhw shahwarohwum Oliv iri. ");
INSERT INTO apec_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Ruwahepih ruhur atur wata shopunek nakitak nanak nawish numun um aburdok nabur Iruhin ananit debeiti urupat tataoum. Aria ihishmori arpesh shanaki shantorum aria nabuh nape nenek skulumesh um Iruhin ananin baraen. ");
INSERT INTO apec_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Aria amam douk henek skulumesh um lo iri hani amam Farisi harauri onok armatok douk shaparugok kwonek wehrur kwani kupaini arman iri. Harakwi aria hakripok kweyotu agundok douk ihishmorim shantorum shapeum. ");
INSERT INTO apec_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Aria harig Jisas hakri, “Debeini Tisa, okwudok kworao arman iri armatok douk shaparugok kwonek yoweishi inahos um kwonek wehrur kwani kupaini arman. ");
INSERT INTO apec_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Enen apakin lo seiwok Iruhin nakoguk Moses enyi douk nyakri, armatok kwunek enyudokmori iri douk shukwumok utabor arigaha kwugok. Aria nyak douk nyakri mumam?” ");
INSERT INTO apec_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Harigan namudok um hakri hukwiraehan um ta nukri mare shubo okwudok armatok aria ta hukri anan douk nabrig enyudok lo aria ta hunekuman kwot. Aria baraen douk madae nukripam enen aria nabuh natao meyoh nakwu ananih hah nape nowem enen baraen atap. ");
INSERT INTO apec_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Amam watak heyotu hape harigan aria nakitak neyotu iruhw aria nakripam nakri, “Ipak meini arman douk madae nunek enesh yoweishi inahos iri uwe, anan douk wosik ko nurik nukwumok marik iri utom.” ");
INSERT INTO apec_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Nakripamuk namudok aria watak nabuh natao atap nape nowem enen baraen amnab. ");
INSERT INTO apec_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Douk hemnek enyudok baraen aria ihim-morim atun atun hape hakutukuk agundok aria hanak. Amam takwiyem harik aria eshudok enesh douk shape shakutukuk agundok shanak. Shanak arigaha arigaha aria shakutukuk Jisas atun napeik. Okwudok armatok otuk douk wata kweyotu agundok Jisas nataoum. ");
INSERT INTO apec_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Jisas nakitak neyotu aria narigok nakri, “Nya, amudok armam amum? Douk madae anan niyotuguk um nunekumen baraen um eshudok yoweishi inahos nyak nyenekesh iri aka?” ");
INSERT INTO apec_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Aria kwakripan kwakri, “Debeini, madae anan niyotuguk uwe, uwok.” Aria nakripok nakri, “Eik shopunek namudok atin. Eik ta mare inemen baraen um yoweishi inahos nyak nyenekesh iri, uwok. Nyak wosik kare nyunak aria mare ta nyunek enesh yoweishi inahos shopunek uwe, uwok.” ");
INSERT INTO apec_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Jisas ta nakripesh enyudok baraen shopunek nakri, “Eik kanak kabi douk lait um. Eik douk yanaki yabuhi agundok atap um ihish arpesh wosik shunatrugun. Aria eshudok arpesh douk shusuhw eikin baraen shugipeshen iri, eshesh ta mare shurahaen arukwutigun um eshudok shunek yoweishi inahos iri uwe, uwok. Aria eshesh ta shupe shurahaen lait tabuhi um atugun, um eshudok shunek yopishi atin um. Aria eshesh douk ta shupe wosik abom ihih nyumneh.” ");
INSERT INTO apec_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Douk amam Farisi hemnek namudok aria hakripan hakri, “Nyak nyenek rohw. Nyak douk nyak atin nyape nyakripap baraen um nyak kanak. Namudok aria nyakin baraen ta mare mukri adurin uwe, uwok.” ");
INSERT INTO apec_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Aria Jisas watak nawanamam baraen nakri, “Enyen douk adur um eik atuwe yape yakripep baraen um eik kanak, aria eikin baraen douk adurin atin. Umum maresh? Eik douk yadukem agundok douk yape aria yakitak yanamori gani agundok ta watak ikitak inak um. Aria ipak douk madae pudukem agundok eik yape aria yakitak yanamori gani agundok ta watak inak um uwe, uwok. ");
INSERT INTO apec_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Ipak shopunek pagipesh agundok atapih aih aria penek skelim arpesh. Aria eik madae inek skelim enen arpen enyenyih aih uwe, uwok. ");
INSERT INTO apec_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Aria douk ikri inek skelim enen arpen enyenyih aih akure, eik ta inek skelumen adur atin. Um maresh? Enyen douk madae eik atuwe inek skelumen uwe, uwok. Aria Yain douk neshopoki eik yanaki aria douk shopunek nani eik wonek mour. ");
INSERT INTO apec_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Enen baraen nyetem ipak kanak ipakin lo iri douk nyakri namudok. Nyakri, ‘Douk biom armam hiyagwreh hukri atin baraen um, aria amamin baraen douk adurin.’ ");
INSERT INTO apec_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Eik yani eikin Yain douk wonekesh namudok. Eik douk yeyagwreh yakripepum eik kanak. Aria eikin Yain douk neshopok eik yanaki aria douk shopunek nani eik weyagwreh enyudok atin baraen um eik.” ");
INSERT INTO apec_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Aria harigan hakri, “Nyakin Yaken douk nape agnum?” Aria Jisas nawanamam baraen nakri, “Ipak douk madae pudukem eik o pudukem eikin Yain uwe, uwok. Douk pudukem eik akure, eikin Yain shopunek ta pudukeman.” ");
INSERT INTO apec_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Jisas nakripesh enyudok baraen abudok nyutob nape nenek skulumesh um Iruhin ananin baraen obi nyutob. Nakripeshen numun um aburdok nabur Iruhin ananit debeiti urupat tataoum hurukatinyum amudok rum douk shobuk ofaibor utabor bakus um. Nape nakripesh aria madae anam armam hukitak husuwan hunak hunekuman baraen uwe, uwok. Um maresh? Ananib nyutob um shon nugok um douk watak bunaki uwe, uwok. ");
INSERT INTO apec_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Aria Jisas watak nakripesh nakri, “Eik douk ta inakuk aria ipak ta pupe purime. Ta pupe purime aria ipakish yoweishi inahos ta watak shupe aria shep pugok. Pugok aria ta mare punaku agundok eik inak ipeum uwe, uwok.” ");
INSERT INTO apec_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Namudok aria eshesh Juda esheshim debeimi heneyagwreh hakri, “Namudok mumam, um nakri, ‘Ipak ta mare punaku agundok douk eik inak ipeum?’ Aria nakri um ta anan kanak nunobo nugok aka, uwok?” ");
INSERT INTO apec_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Aria Jisas watak nakripam nakri, “Ipak douk agundokish arpesh aria eik douk yape iri gani iruhw iri. Ipak douk agundok atapishi, aria eik douk madae agundok atapin arman uwe, uwok. ");
INSERT INTO apec_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Douk namudok aria eik douk yakripep yakri ipakish yoweishi inahos ta watak shupe aria ta pugok. Namudok aria douk ipak mare punek bilip pukri Eik Douk Seiwok Yape Namudok Atin Iri Um,namudok aria ipakish yoweishi inahos douk ta watak shupe aria ipak ta pugok.” ");
INSERT INTO apec_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Douk shemnek namudok aria sharigan shakri, “Nyak meinyi arpen?” Aria nawanamesh baraen nakri, “Eik douk anudok arman douk nubokuhi watak sagomatin yakripepum. ");
INSERT INTO apec_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Eik sabainyi baraen douk yakri ikripepum yoweishi inahos ipak penekesh iri aria inemep kwotogum. Aria abudok nyutob douk ta uwok. Douk ta ikrip ipak eshudok atapish arpesh enyudok baraen douk yemnek anudok neshopoke yanaki iri nakriyen iri. Anan douk adurini aria inahos wokan iri arman.” ");
INSERT INTO apec_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Aria eshesh douk madae shudukemesh um anan nape nakripesh um ananin Yaken um uwe, uwok. ");
INSERT INTO apec_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Namudok aria watak nakripesh nakri, “Abudok nyutob putuk Eik Anudok Arman douk yatogur adurin arpen iri piyaur rowog kruse obi, abudok nyutob ta douk pudukeme wosik pukri Eik Douk Seiwok Yape Namudok Atin Iri. Aria abudok nyutob ta douk pudukeme um ihinyumori yeneken iri douk madae iyagwreh eik atuwe ineken uwe, uwok. Aria ta pudukemesh pukri baraen yakripepen iri douk Yain neyabigeyen aria douk yakripepen. ");
INSERT INTO apec_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Anudok neshopok eik yanaki iri douk nani eik wape ihih nyumneh madae nukutukuk eik atuwe ipeik uwe, uwok. Um maresh, ihih nyumneh eik yape um yenek enyudok douk anan nakriyen iri.” ");
INSERT INTO apec_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Jisas watak nape nakripesh enyudok baraen atin, aria sabaishi arpesh adur shasuhwen dodog shagipeshen. ");
INSERT INTO apec_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Namudok aria Jisas watak nakrip eshudok Juda douk shasuhw ananin baraen shakri adurin iri nakri, “Douk ipak pusuhw eikin baraen dodog pugipeshen um, ipak adur ta putogur eikip iri douk pugipesh eik iri. ");
INSERT INTO apec_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Putogur eikipari aria ta pudukem adurinyi baraen. Aria enyudok adurinyi baraen ta nyukweshihep um ipakish yoweishi inahos aria pupe wosik atin.” ");
INSERT INTO apec_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Aria eshesh watak shawanaman baraen shakri, “Apak douk Abraham ananish barheshish. Aria douk madae anesh arpesh shuweshikap mupe munemesh mour meyoh uwe, uwok. Aria namudok nyakri um, um nyakri apak ta mutukweshih mupe wosik atin um ta mumam?” ");
INSERT INTO apec_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Aria Jisas watak nawanamesh baraen nakri, “Adur atin yakripep. Ihishmorim arpesh douk shape shenek yoweishi inahos iri, eshesh douk yoweishi inahos showeshikesh dodog aria shenekesh shape shenemen mour meyoh. ");
INSERT INTO apec_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Arpen douk nyape shakamum kupainyi nyape nyenek mour meyoh anat urupat iri, enyen douk nyenek mour meyoh. Ta mare nyupe opudok awirop uwe, uwok. Awiropinari ananin nuganin wosik ta nupe ihih nyumneh. ");
INSERT INTO apec_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Namudok aria eik Iruhin ananin Nuganin ikweshihep-aguk um yoweishi inahos um, aria ipak adur ta putukweshih pupe wosik abom. ");
INSERT INTO apec_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Eik yadukemesh um ipak douk adur Abraham ananish barheshish. Aria douk pakri pubo eik igok. Um maresh? Eik yakripep-enyi baraen douk madae pusuwen uwe, uwok. ");
INSERT INTO apec_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Eik douk yakripep baraen um eshudok eikin Yain neyabige um. Aria ipak penek ehudok aih douk paraeh um ipakin yaken iri.” ");
INSERT INTO apec_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Aria eshesh watak shabeiman baraen shakri, “Apakin yaken douk Abraham.” Jisas nemnek aria nebeimesh baraen nakri, “Douk ipakin yaken Abraham akure, aria enenyenen peneken iri ta nyudukem enyudok yopinyi seiwok Abraham neneken iri atin. ");
INSERT INTO apec_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Eik douk yakripep sabainyi adurinyi baraen douk yemnek Iruhin nakripe enyi. Aria ipak douk pakri abom um pe igok. Abraham douk madae nunekesh eshudokmori yoweishi inahos uwe, uwok. ");
INSERT INTO apec_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Eneshenesh yoweishi inahos penekesh iri douk penek enyudok ipakin yaken neneken iri.” Aria eshesh watak shakripan shakri, “Apakiyu amakenyiyu madae wiyotu yeh upubuki uwe, uwok. Apak douk atun Yain meyoh. Anan douk Iruhin atun. Apak douk ananish batowish.” ");
INSERT INTO apec_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Aria watak nakripesh nakri, “Aria adur Iruhin ipakin Yaken akure, ipakip urkwip ta punawasham eik. Um maresh? Eik douk yani Iruhin wape iri aria yanaki aria douk enyudok yape. Madae ikitak inamori eikim urkum uwe, uwok. Anan neshopoke aria douk yanaki. ");
INSERT INTO apec_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Ipakip urkwip madae purum eikin baraen wosik aria pudukemen uwe um maresh? Ipak madae pudukemen uwe, ipak douk pakri uwok um pumnek eikin baraen aria pogah ipakigos arigos. ");
INSERT INTO apec_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Ipak douk adur atin ipakin yaken Satan ananish batowish. Aria douk adur dodogowip atip um punek yoweishi inahos douk anan mishin nyakitak-umesh iri. Seiwok sagomatin watak baugos um nabo arpesh shagok arigaha douk. Enenyenen adurinyi baraen douk madae nugipeshen o niyagwrehen uwe, uwok. Um maresh, ehudok adurihi aih douk madae eneh hupenyan uwe, uwok meyoh. Abudok nyutob niyagwreh enen rohwin baraen atin, enyudok douk adur nagipesh ananih aih atih. Um maresh? Anan douk napeum nenek rohw aria adur atin baugos um agundok shagiyagig um. ");
INSERT INTO apec_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Eik douk yakripep adurinyi baraen. Aria douk namudok, aria madae punek bilipume uwe, uwok. ");
INSERT INTO apec_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Ipak ta wosik enen arpen nyukripe um enesh yoweishi inahos douk yenekesh iri aka, uwok? Aria uwok meyoh. Eik douk yakripep adurinyi baraen, aria ipak douk madae pusuhw eikin baraen pukri adurin uwe um maresh? ");
INSERT INTO apec_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Ihish Iruhin ananish arpesh douk shemnek ananin baraen aria shasuhwen dodog shagipeshen. Aria ipak douk adur madae Iruhin ananish arpesh uwe, uwok meyoh. Namudok aria douk madae pumneken atin uwe ananin baraen.” ");
INSERT INTO apec_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Aria eshesh Juda esheshim debeimi hawanaman baraen hakri, “Riguk apak douk makripen adurin baraen. Nyak douk anan yowen meyoh iri arman douk nyanaki Samaria iri. Aria douk enen yoweinyi sagab nyapeyen.” ");
INSERT INTO apec_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Aria nawanamam baraen nakri, “Eik madae enen yoweinyi sagab nyupeye, uwok. Aria eik douk yatuk eikin Yain ananin nyeigur nyato iruhw aria ipak douk pabo eikin nyabuh. ");
INSERT INTO apec_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Eik douk madae ipeum ituk eikin nyeigur nyuto iruhw uwe, uwok. Aria anan douk nohur arpesh aria eshesh shatuk eikin nyeigur nyato iruhw. Aria anan douk ta nunemesh debeinyi baraen eshudok douk sheke agabus eik iri. ");
INSERT INTO apec_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Adur atin yakripep. Eshudok arpesh douk shusuhw eikin baraen dodog shugipeshen iri, eshesh ta mare shugok, uwok. Ta adur shupe ihih nyumneh.” ");
INSERT INTO apec_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Aria eshesh Juda esheshim debeimi watak hakripan hakri, “Douk apak adur madukemesh um nyak adur enen yoweinyi sagab nyapeyen. Abraham nani amam profet douk seiwok hagok. Aria nyak nyakri, ‘Enyudok arpen douk nyusuhw nyakin baraen dodog nyugipeshen iri ta mare nyugok uwe, uwok. Ta adur nyupe ihih nyumneh.’ ");
INSERT INTO apec_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Nyak nyakri nyak anan debeini nyariguk apakin yamenen Abraham aria anan nabuhuk atap, aria uwok? Anan douk seiwok nagok aria amam profet douk shopunek seiwok hagokuk. Aria nyak nyakri nyak douk adur meini arman?” ");
INSERT INTO apec_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Aria Jisas watak nakri, “Douk eik ipeum ituk eikin nyeigur nyuto iruhw akure, eik ta itogur nyeigur wokan iri arman meyoh. Aria anudok natuk eikin nyeigur nyato iruhw iri douk eikin Yain. Aria douk adur anudok douk ipak pakri puhwaran um ipakin Iruhin iri. ");
INSERT INTO apec_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Ipak douk madae pudukeman uwe, uwok. Eik wosik adur yadukeman. Namudok aria douk eik ikri eik madae idukeman uwe, eik douk ta shuhware yenek rohw iri kabi douk ipak um. Aria eik douk adur yadukeman wosik aria yagipesh ananin baraen. ");
INSERT INTO apec_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Ipakin yamenen Abraham douk adur nanadudareh um nakri nutik eikih nyumnah um inaki agundok atap um. Anan douk natik eik agundok yanakumori um aria douk adur nanadudareh.” ");
INSERT INTO apec_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Aria eshesh Juda esheshim debeimi watak hakripan hakri, “Abraham seiwok nagok aria nyak, nyakish kwarahos douk wata sabaishi shunak shutogur 50-poreish uwe, watak. Aria nyak douk nyakri nyatik Abraham aka? Nyak nyenek rohw.” ");
INSERT INTO apec_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Aria Jisas nebeimam baraen nakri, “Adur atin yakripep. Abraham anan douk wata shunabuki uwe aria Eik Douk Seiwok Yape Namudok iri.” ");
INSERT INTO apec_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Douk nakri enyudok baraen aria hohuri utabor um hakri hon nugok. Aria nanabeshuk aria nakutukuk agundok Iruhin ananit debeiti urupat tataoum aria natogur nanak. ");
INSERT INTO apec_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Jisas nape nanak aria natik anan nabes seshukanari arman. Anan douk seiwok amakek kwanabuki atun um nabes seshukan nape namudok atin. ");
INSERT INTO apec_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Aria apak Jisas ananim disaipel marig Jisas makri, “Tisa, omi nyenekan aria yoweishi shenekan aria anan douk nabes seshukan nor ananik amakek okwokwihw apahw aria kwanabuki? Ananish yoweishi inahos meyoh shenekan aka, ananish amakenyish esheshish yoweishi inahos shenekan?” ");
INSERT INTO apec_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Douk amam harigan namudok aria Jisas nakri, “Anan nabes madae sishukan um yoweishi inahos anan nani ananish amakenyish esheshish uwe, uwok. Anan douk nabes seshukan um eik iyabig arpesh um enyudok douk Iruhin ta watak nugabeyan um. ");
INSERT INTO apec_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Aria douk abudok nyutob douk kabi nyumnah um, aria apak ta mupe munek Iruhin douk neshopok eik yanaki iri um ananin mour. Aria anab ta bunaki iri nyutob ta kabi douk wab um. Aria abudok nyutob ta mare enesh arpesh shupe shunek Iruhin ananin mour uwe, uwok. ");
INSERT INTO apec_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Douk abudok nyutob eik yape agundok atap um, eik yape kabi douk lait um. Aria eik yenek sabainyi yopinyi mour yopugunum atugun um sabaishi shutiwe aria ta shugipeshe munek enyudokmori atin yopinyi mour.” ");
INSERT INTO apec_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Douk Jisas nakriyuk namudok aria nokuseh amnab nakwu arpigas nenegab batogur kabi masir um. Aria noruhur naraeyok anudok nabes seshukanari ananis nabes. ");
INSERT INTO apec_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Douk naraeyokuman aria nakripan nakri, “Nyak nyunak waiyag shahwaragum Siloam iri aria nyishrokuh.” Baugenyum enyudok nyeigur Siloam douk shakri “Neshopokan nanak.” Douk nanak neshrokuh aria anan nabes watak satrugun aria natanamori um urupat. ");
INSERT INTO apec_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Aria eshudok douk shani anan shape atugun iri shani eshudok riguk shatik nape nanakrep arpesh um shukon eshudok eneshenesh iri douk shatrun um watak natrugun um aria shakri, “Nani douk nabes seshukan riguk nape nanakrep arpesh um shukon eshudok eneshenesh iri o nani kupaini?” ");
INSERT INTO apec_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Aria enesh shakri, “Douk anan atun.” Aria enesh shakri, “Anan uwok. Anan douk kabi anudok nabes seshukanari um.” Aria anan kanak adur nakri, “Douk eik atuwe, nabes seshuke iri.” ");
INSERT INTO apec_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Nakripesh namudok aria eshesh sharigan shakri, “Nyak nyenekas mumam nyakis nabes um douk watak nyatrugun um?” ");
INSERT INTO apec_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Nemnek aria nebeimesh baraen nakri, “Anan arman shahwaran um Jisas iri nanaki nohur amnab nokusehab nenek masir aria naraeyokume nabes. Anan naraeyokume aria neshopoke yanak yeshrokuh agudok waiyag Siloam. Aria eik yakitak yanak yeshrokuh aria eikis nabes watak satrugun. Aria douk eik yatrugun.” ");
INSERT INTO apec_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Aria eshesh sharigan shakri, “Anudok Jisas douk nape agunum?” Aria anan nakri, “Eik madae idukeman uwe, uwok.” ");
INSERT INTO apec_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Aria eshesh sharao anudok riguk nabes seshukanari shanak um amam Farisi. ");
INSERT INTO apec_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Aria ahudok nyumnah Jisas nokuseh amnab nagabe anudok nabes seshukanari ananis nabes um douk Sabat, ahudok nyumnah douk lo nyakri mare shunek enen mour um uwe, uwok. ");
INSERT INTO apec_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Douk sharan shanak shatogur um gani amam Farisi hapeum aria amam hariganum agundok anan nenekesh mumam aria douk watak natrugun um. Aria anan nakripam nakri, “Anan nokuseh amnab nenekab batogur masir aria naraeyokume eikis nabes. Naraeyokume douk yanak yakruparuk aria watak yatrugun.” ");
INSERT INTO apec_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Nakri namudok aria anam amam Farisi hakri, “Anudok nagabeiman nabes anudok arman iri, anan douk madae Iruhin nishopokan nunaki iri uwe, uwok. Um maresh? Anan douk madae nugipesh enyudok lo um mare enesh shunek enen mour ahudok nyumnah Sabat um uwe, uwok.” Aria anam hakri, “Aria anan douk anan napeum nenek yoweishi inahos iri, anan douk ta mare nunek enyudokmori Iruhin atun neneken iri mour uwe, uwok.” Douk heyagwreh namudok aria anam hore enep urkwip aria anam hasuhw enep. ");
INSERT INTO apec_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Aria amam Farisi watak shopunek gamo harig anudok riguk nabes seshukanari hakri, “Nyak nyakriyan mumam anudok nagabeimen nabes iri? Anan douk anan yopini arman aka, anan yoweini?” Aria anan nawanamam baraen nakri, “Anan douk anan profet.” ");
INSERT INTO apec_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Anan nakri namudok, aria amudok debeimi Juda douk madae hukrium hunek bilip um agundok riguk anan douk nabes seshukan aria douk watak natrugun um uwe, uwok. Aria amam henekumesh baraen ananish amakenyish shanaki. ");
INSERT INTO apec_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Douk shanaki aria harigesh hakri, “Anudok douk ipakin nuganin? Aria shopunek anan douk seiwok amakek kwanabuki aria nabes seshukan nape namudok atin? Aria anan douk nenek maresh, um douk watak natrugun um?” ");
INSERT INTO apec_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Aria ananish amakenyish shakri, “Adur, anudok douk ohwakin nuganin. Aria abudok nyutob amakek kwanabuki atinyum anan madae nutrugun uwe, uwok.” ");
INSERT INTO apec_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","“Aria ohwak douk madae udukemesh uwe um anan nenekesh mumam aria douk watak natrugun um. Shopunek ohwak douk madae udukem anudok nagapesh-uman nabes iri uwe, uwok. Anan douk nubokadae yopun. Porig anan kanak ba nukripep!” ");
INSERT INTO apec_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Eshesh Juda esheshim debeimi douk riguk habo baraen, um hakri meishi arpesh shukri Jisas anan douk Iruhin nagraehan aria neshopokan nanakmori nunarao arpesh um, amam ta mare hukutishuk shuwish atudok eshesh Juda shape sheneyagwreh baraen-ati urupat uwe, uwok. ");
INSERT INTO apec_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Douk namudok aria anudok nabes seshukanari ananish amakenyish shanogugur aria shakri, “Anan douk nubokadae yopun. Porig anan kanak ba nukripep.” ");
INSERT INTO apec_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Aria amam hahwar anudok nabes seshukanari anah shopunek aria harigan hakri, “Nyak nyuhur Iruhin ananin nyeigur um kadak nyak ta nyukri adurin atin baraen! Apak madukemesh um anudok arman nagabeimen nabes iri douk anan nenek eneshenesh yoweishi inahos iri.” ");
INSERT INTO apec_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Aria anan nawanamam baraen nakri, “Eik madae idukemesh uwe. Anan douk anan yopini aka, anan douk nenek yoweishi inahos iri. Aria adur eik yadukemen iri douk anudok. Seiwok nabes seshuke, aria douk watak yatrugun.” ");
INSERT INTO apec_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Aria amam debeimi Juda harigan hakri, “Anan neneken mumam aria douk nagabeimen nabes nyatrugun?” ");
INSERT INTO apec_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Aria anan nawanamam baraen nakri, “Eik douk iganigadae yakripep, aria ipak douk pakri uwok um pumnek. Ipak pakri pumnek sabaih atih um maresh? Aria ipak douk shopunek pakri pugipesh anan putogur ananish disaipel aka?” ");
INSERT INTO apec_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Aria amam heyokasan hakri, “Nyak douk anudok nagabeimen nabes iri ananin disaipel. Apak uwok. Apak douk Moses ananim disaipel. ");
INSERT INTO apec_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Apak madukemesh um seiwok Iruhin douk nani Moses heyagwreh. Aria douk anudok Jisas, apak douk madae mudukemesh um agundok anan nanamori uwe, uwok.” ");
INSERT INTO apec_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Aria anudok seiwok nabes seshukan iri nakri, “Enyudok douk adur enen anahaehin dodogowinyi mour aria eik yakitak yowiyokuk um ipak madae pudukem anan uwe, uwok! Anan nagabeime eikis nabes aria ipak douk madae pudukemesh um anudok anan napeum aria nakitak nanamori uwe aka. ");
INSERT INTO apec_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Apak madukemesh um Iruhin ta mare numnek enyudok douk shenek eneshenesh yoweishi inahos iri sharigan umen iri, uwok. Anan ta numnek eshudok douk shenek lotuman iri aria shagipesh ananih aih aria urkum iri atish. ");
INSERT INTO apec_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Seiwok arigah arigaha douk, apak douk madae mutik mumnek um enen arpen nyagabeimen nabes kupainyi, douk amakek kwenyubuki atinyum seshuken sape namudok aria enyen ta nyutrugun uwe, uwok. ");
INSERT INTO apec_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Aria anudok arman nagabe eikis nabes aria eik yadukemesh namudok arman douk madae nini Iruhin hupe iri aria nushopokan nunaki iri, anan ta mare nunek enen enyudokmori mour, uwok.” ");
INSERT INTO apec_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Aria amam Farisi nyirub juwehosirub aria hakripan hakri, “Riguk watak amakek kwenyubuki atin um nyenek eneshenesh yoweishi inahos arigaha douk aria nyakri nyupe nyunek skulumap um baugenyum baraen um Iruhin ananin baraen apak?” Aria amam hasuwan hawashan natogur aduk atudok eshesh Juda shantorum shape sheneyagwreh baraen-ati urupat. ");
INSERT INTO apec_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Jisas nape aria nemnek um enyudok eshesh Juda esheshim debeimi hasuhw anudok riguk nabes seshukan iri aria hawashan natogur aduk um. Nemnek aria nakitak nauriman nanak. Douk nanak naparugan aria narigan nakri, “Nyak nyenek bilip um Anudok Arman douk natogur adurinyi arpen iri aka, uwok?” ");
INSERT INTO apec_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Aria anan nawanaman baraen nakri, “Debeini, Anudok Arman natogur adurinyi arpen iri douk meini? Yakri nyukripeiman aria eik ta inek bilipuman.” ");
INSERT INTO apec_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Aria Jisas nakripan nakri, “Nyak douk nyatrun. Anudok arman, anan douk nani nyak pape peyagwreh.” ");
INSERT INTO apec_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Douk Jisas nakri namudok aria anudok arman nakri, “Debeini, eik yenek bilip um nyak.” Aria nabuh noduk ohrubus natao hurukatin um Jisas natuk ananin nyeigur nyato iruhw. ");
INSERT INTO apec_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Aria Jisas nakripan nakri, “Eik yanaki agundok atap um inek skelim arpesh aria isiyaesh. Yanakmori eshudok douk nabes seshukesh madae shudukem Iruhin iri uwe um ta shutrugun, aria eshudok douk wosik shakana shutrugun shudukem Iruhin iri watak nabes sishukesh.” ");
INSERT INTO apec_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Jisas nakri namudok aria anam Farisi douk hani anan heyotu agundok iri harigan hakri, “Nyak nyakri apak douk shopunek nabes seshukap aka?” ");
INSERT INTO apec_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Aria Jisas nakripam nakri, “Aria ipak nabes sishukep akure, Iruhin ta watak nugabeyep aria ipak ta mare enesh yoweishi inahos shupenyep, uwok. Aria ipak douk pakri ipak patrugun. Douk namudok aria baraen um ipakish yoweishi inahos douk watak shapenyep.” ");
INSERT INTO apec_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Jisas nakripesh nakri, “Adur atin yakripep, arman douk madae nuwishi wit arbudok sipsipahos sheyotu arub iri narub, aria naproki nubi nuwishi iri douk madae yopini arman uwe, uwok. Anan douk nakwuaruh atuh iri. ");
INSERT INTO apec_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Aria arman douk nuwish wit um arbudok narub meyoh um arbudok sipsipirub narub iri, anan douk adur nape neyoh eshudok sipsipahos iri. ");
INSERT INTO apec_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Abudok nyutob neyoh sipsipahos iri nukri nunaki obi nyutob, aria anan nape neyoh wit um arbudok narub iri ta nukitak nijikuman wit. Nijikuman aria ta nuwish norig eshesh atin atin sipsipahos um esheshish nyeiguhw. Norigesh douk shumnek ananih mah aria ta nurikumesh nuraesh nutogur aduk. ");
INSERT INTO apec_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Douk narao ihishmorim ananish sipsipahos shutogur adukirub um narub iyoh, nurikumesh aria eshesh ta shugiman shanak. Um maresh? Eshesh douk shadukem ananih mah. ");
INSERT INTO apec_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Kupaini arman ta mare shugipeshan uwe, uwok. Um maresh, eshesh douk madae shudukem ananih mah uwe, uwok. Namudok aria douk ta shunogugur aria ta shuruwok-umanuguk.” ");
INSERT INTO apec_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Jisas nakripesh enyudok wobuwobrenyi baraen, aria eshesh douk madae shudukem baugenyum uwe, uwok. ");
INSERT INTO apec_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Eshesh douk madae shudukem baugenyum uwe, enyudok wobuwobren baraen aria Jisas watak nakripesh nakri, “Adur atin yakripep. Eik kanak douk adur atudok wit douk sipsipahos shunak shuwishat aria shuwish shupe numun narub. ");
INSERT INTO apec_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Ihim-morim armam douk riguk harik hanaki aria eik douk atin yanaki iri, amudok armam douk hakwuaruh atuh iri. Aria sipsipahos douk madae shumnek amamin baraen aria shugipesham atin uwe, uwok. ");
INSERT INTO apec_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Eik douk adur atudok wit. Enyudok arpen douk nyuwish atudok wit aria nyuwish numun narub iri, enyen ta nyuwish Iruhin nuraen aria ta watak nyutanamori nyupe wosik atin. Aria ta nyunek witogur arbudok narub nyunak nyurim worigun um nyishoh iri. ");
INSERT INTO apec_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Hakwuaruh iri douk hanakumori hukwumesh aruh, hesh aria hununish. Aria eik douk yanakmori itaurumesh shurao eikin dodog abom shupe wosik aria shunadudareh shupe wosik abom ihih nyumneh. ");
INSERT INTO apec_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Eik douk adur yopunari arman douk yape yeyoh sipsipahos iri. Aria eik douk yakri wosik um igok um itaurum eshudok sipsipahos shupe wosik. ");
INSERT INTO apec_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Arman douk shatorun um nupe niyoh sipsipahos iri, anudok armam douk madae adur nunogrem eshudok sipsipahos iri uwe, uwok. Anan douk nenek mour um nupe niyohesh meyoh. Aria abudok nyutob nukri nutik anat wanarit nubat tunakumori, anan ta nukutish shiyotuguk aria nuruwok. Aria atudok nubat ta tunaki tihiyahesh arigaha tusuh enen aria enesh ta shuruwok shunak atin atinyuk. ");
INSERT INTO apec_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Anudok arman naruwok um maresh? Anan douk nenek mourum utabor atubor iri. Ananim urkum madae adur murum nukri nutaurum eshudok sipsipahos uwe, uwok. ");
INSERT INTO apec_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","“Eik douk adur yopunari arman yeyoh sipsipahos iri. Eik douk yadukemesh wosik um eikishi sipsipahos aria eshesh shopunek shadukem eik. ");
INSERT INTO apec_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Aria kabi douk Yain nadukem eik aria eik yadukem anan um. Aria eik douk yakri wosik um igok um itaurum eikish sipsipahos shupe wosik. ");
INSERT INTO apec_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Eshudok enesh arpesh kabi eikish sipsipahos um douk eikishi. Aria eshesh douk shapeik rougun madae shuni eshudok sipsipahos douk sheyotu arbudok eikirub narub iri shiyotu um uwe, uwok. Aria eik douk shopunek yakri ta iraesh shunaki aria ta shumnek eikin baraen. Aria douk ta shuni eshudok enesh sharik iri shutogur atish shiyotu atubur nabur aria eik atuwe ipe iyohesh. ");
INSERT INTO apec_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Eikin Yain douk adur urkum makri munawasham eik abom. Um maresh? Eik douk yakri wosik um she igok itaurum arpesh aria ta watak shopunek ikitaki ipe. ");
INSERT INTO apec_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Ta mare enen arpen nyubo eik igok um enyenyim urkum uwe, uwok. Eik ta igok um eik kanak eikim urkum. Iruhin neke big um inek enyudok aria douk ta ineken. Neke big um igok um aria shopunek neke big um ta watak nutaurume ikitaki ipeum.” ");
INSERT INTO apec_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Douk Jisas nakripesh enyudok baraen aria eshesh Juda esheshim debeimi watak shopunek hanadiyogur um henek biyab lainab. ");
INSERT INTO apec_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Sabaimi hakri namudok. Hakri, “Enen yoweinyi sagab nyapeyan aria nagugak abom. Ipak pemnek ananin baraen um maresh?” ");
INSERT INTO apec_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Aria anam hakri, “Enen yoweinyi sagab nyapenyanari ta mare niyagwreh namudok uwe, uwok. Aria yoweinyi sagab ta nyuhur anan nabes seshukanari ananis nabes watak nutrugun mumam? Namudok ta uwok.” ");
INSERT INTO apec_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Abudok nyutob um eshesh Juda shantorum shape Jerusalem aria shenek worigun um urkwip purum seiwok esheshish popehesh yamehesh watak shopunek shagabe Iruhin ananit debeiti urupat shawish shenek lotu um Iruhin um douk banak batoguri. Aria abudok nyutob shantorum obi nyutob douk nyumanugos-ibi nyutob. ");
INSERT INTO apec_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Aria Jisas nanak nawish numun narub Iruhin ananit debeiti urupat tataoum aria nape narahaen nanak enyudok debeinyi womaga douk shahwaren um Solomon ananin womaga iri. ");
INSERT INTO apec_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Aria eshesh Juda esheshim debeimi hanaki hantorum herharihan aria harigan hakri, “Banob um meibi nyutob aria nyak ta nyukripap um nyak adur meini arman? Aria nyak Krais douk Iruhin nagraehen aria neshopoken nyanakmori nyurao arpesh um, aria douk apak makri adur nyukripap um apak ta mudukemesh.” ");
INSERT INTO apec_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Aria Jisas nabeimam baraen nakri, “Eik douk yakripep, aria ipak douk madae pusuhw eikin baraen pukri adur uwe, uwok. Ihin mour douk yohur eikin Yain ananin nyeigur aria yeneken nyatogur patrin iri, enyen douk adur nyeyabigep agundok eik douk meini arman um. ");
INSERT INTO apec_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Aria ipak douk madae pusuhw eikin baraen pukri adur uwe, uwok. Um maresh? Ipak douk madae eikish sipsipahos uwe. ");
INSERT INTO apec_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Eikish sipsipahos douk shadukem eikih mah. Eik douk shopunek yadukem eshesh wosik aria douk shagipesh eik. ");
INSERT INTO apec_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Shagipeshe aria ta yataurumesh um mare shunak shuwishuk uwe, uwok. Eik ta itaurumesh um adur shupe wosik abom ihih nyumneh. Aria ta mare enen arpen nyunaki nyutiweyesh eikis wis uwe, uwok meyoh. ");
INSERT INTO apec_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Eikin Yain douk nekeyesh iri, anan douk debeini nenek uhwin um ihishmori arpesh shape shakam. Aria douk ta mare enen arpen nyunaki nyutrunesh ananis wis uwe, uwok meyoh. ");
INSERT INTO apec_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Eik yani Yain douk adur atin watogur atun meyoh.” ");
INSERT INTO apec_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Douk amam Juda hemnek namudok aria watak shopunek hohuri utabor um hakri hon nugok. ");
INSERT INTO apec_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Aria Jisas watak nakripam nakri, “Eikin Yain nakripe um inek sabainyi anan atun neneken iri mour aria douk yeneken nyatogur ipak patrin. Aria ipak urkwip porum meinyi debeinyi mour douk eik yeneken aria ipak douk pakri pukwume utabor?” ");
INSERT INTO apec_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Aria amam watak hawanaman baraen hakri, “Apak douk madae mukri um mukwumen utabor um agundok nyenek enyudok Iruhin atun neneken iri mour nyatogur um uwe, uwok. Aria makri menyum agundok nyenek enenyenen nyabubunim Iruhin um. Nyak douk arpen meyoh, aria nyakri nyak Iruhin.” ");
INSERT INTO apec_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Aria Jisas watak nebeimam baraen nakri, “Enen baraen nyetem ipakin lo iri douk nyakri namudok. Iruhin nakri, ‘Ipak douk god omi.’ ");
INSERT INTO apec_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Eshudok arpesh seiwok Iruhin nekeshi ananin baraen iri, anan douk nahwaresh god omi. Aria apak madukemesh um Iruhin ananin baraen nyetem ananik Buk iri douk adurin atinyi. Madae nyukri kupainyi atin uwe, uwok. ");
INSERT INTO apec_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Aria eik douk Yain meyoh nagraehe yape ananiwe atuwe aria neshopoke yanakmori agundok atap. Eik yabuhi aria yakripep yakri eik douk Iruhin ananin nuganin. Namudok aria ipak pakri eik yape yenek enenyenen yabubunim Iruhin um maresh? Um agundok yakri, ‘Eik douk ananin nuganin’ um aka? ");
INSERT INTO apec_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Aria eik mare inek eikin Yain Iruhin ananin mour um, aria ipak douk wosik mare pusuhw eikin baraen pukri adur uwe, uwok. ");
INSERT INTO apec_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Aria eik douk adur yenek ananin mour. Aria douk ipak pakri uwok um punek bilip um eik um agundok yakri eik douk Iruhin neshopoke yanakmori. Aria ipak douk patiwe yenek sabainyi Iruhin atun neneken iri mour nyatogur aria douk ta punek bilipume. Punekesh namudok um ipak ta adur pudukemesh abom um Yain nape eik aria eik yape anan.” ");
INSERT INTO apec_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Douk nakri namudok aria amam watak hakri husuwan hunak huweshigan nupe shunuweshik-ati urupat. Aria nakutumukuk ba nanak. ");
INSERT INTO apec_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Nakutum-ukuk nanak aria nabinawish worub Jodan nanak um agundok douk riguk Jon nenek baptaisumesh iri nape nenek baptaisumesh um. Nanak aria nape nagundok. ");
INSERT INTO apec_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Aria sabaishi arpesh shanaki agundok anan napeum aria shakri, “Adur atin, Jon anan douk madae nunek enen Iruhin atun neneken iri mour uwe, uwok. Aria ihinyumori baraen anan neyagwrehen abom um anudok arman iri douk nyatogur adurin atin abom.” ");
INSERT INTO apec_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Aria sabaishi arpesh shape agundok iri shenek bilip um Jisas shakri anan douk adur Krais. ");
INSERT INTO apec_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Anan arman shahwaran um Lasarus iri douk arugeh hapeyan. Anan nani ananiyu bio mohwiyariyu, Maria kwani okwokwik awik Mata douk wape abrudok wabur Betani. ");
INSERT INTO apec_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Aria Maria douk okwudok armatok riguk kwourak sanda Jisas ananiruh yeriweruh aria watak kwakwu okwokwig barag kwubatiguman yeriweruh iri. Aria douk okwokwin mohunin Lasarus arugeh hapeyan. ");
INSERT INTO apec_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Aria ananiyu mohwiyariyu wonek baraen nyanak um Jisas wakri, “Debeini, nyakin arpen douk nyak urkum manawashaman iri douk arugeh hapeyan.” ");
INSERT INTO apec_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Douk Jisas nemnek namudok aria nakri, “Baugos um ehudok arugeh han um douk madae hon um adur nugok uwe, uwok. Eheh douk han um arpesh shutik Iruhin ananin dodog aria shutuk anan nini eik ananin Nuganin ohwakish nyeiguhw shuto iruhw.” ");
INSERT INTO apec_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Jisas anan douk adur urkum manawasham Mata kwani okwokwik awik Maria wani Lasarus. ");
INSERT INTO apec_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Anan douk nemnek um agundok Lasarus arugeh hapeyan um, aria nape biyeh nyumneh shopunek nagundok douk anan napeum. ");
INSERT INTO apec_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Douk nape biyeh nyumneh hanak hadiguk aria nakrip apak ananim disaipel nakri, “Apak watak mutanam munak um Judia.” ");
INSERT INTO apec_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Douk apak memnek aria makri, “Debeini Tisa, nubokuhi atin amam Juda hakri hukwumen utabor. Aria douk watak shopunek nyakri nyunak ganudok aka?” ");
INSERT INTO apec_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Aria Jisas nawanamap baraen nakri, “Anah nyumnah douk 12-porein aua um wah hutaoum. Aria douk enen arpen nyukri nyurahaen nyumnah wah hatao obi nyutob um, enyen ta ko nyutrugun wosik aria ta mare nyutu uwe, uwok. ");
INSERT INTO apec_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Aria enyen nyukri nyurahaen wab um, enyen douk ta nyunotutuk aria nyutu nyubuh. Um maresh? Agagun douk arukwutigun aria enyen ta mare nyunatrugun wosik uwe, uwok.” ");
INSERT INTO apec_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Douk Jisas nakriyuk namudok aria nakri, “Apakin arpen Lasarus douk neshuh. Aria eik ta watak inak inyubaran.” ");
INSERT INTO apec_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Aria apak ananim disaipel makri, “Debeini, anan douk eneh arugeh hapeyan ba neshuh um, anan douk ta watak yopun.” ");
INSERT INTO apec_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Jisas douk nakri um agundok Lasarus adur nagok um. Aria apak ananim disaipel memnek aria makri anan nakri um aduribus yobus san aria neshuh. ");
INSERT INTO apec_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Namudok aria Jisas nowerehamap baraen nakri, “Lasarus douk nagok. ");
INSERT INTO apec_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Aria eik urkum morum ipak aria yanadudareh. Um maresh? Anan nagok um, eik douk madae inak itogrumesh uwe, uwok. Yanadudareh um maresh, apak ta munak mutrish aria ipak ta putik enen mour ta eik ineken iri aria ta punek bilip pukri eikin baraen douk adurinyi. Aria douk ipak yowi ba munak.” ");
INSERT INTO apec_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Eshesh Juda douk shakri shubo Jisas nugok. Namudok aria Tomas douk shahwaran um Didimas iri nakrip apak ananim disaipel nakri, “Kitak munam Debeini munak. Munak um kadak shukri shubo anan nugok um, aria eshesh douk shopunek shubo apak muni anan mugok ahudok atuh.” ");
INSERT INTO apec_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Douk Jisas nanak natogur hurukatinyum Betani aria anan nemnek um Lasarus douk sharuman nor wonugwehw 4-poreih nyumneh. ");
INSERT INTO apec_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Abrudok wabur Betani douk madae bupeik rougun um Jerusalem uwe, uwok. Bape iri hurukatin, kabi douk biyen atin kilomita um. ");
INSERT INTO apec_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Aria sabaishi Juda shanaki shani Maria aria Mata shapeum shugabemo owowiruh aparuh um agundok owowin mohunin nagok um. ");
INSERT INTO apec_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Douk Mata kwomnek um agundok Jisas nape nanakumori aria kwakitak kwanak um kuparugan yah. Aria Maria douk kwapeik urupat. ");
INSERT INTO apec_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Douk Mata kwanak aria kwakrip Jisas kwakri, “Debeini, douk nyak nyupe agundok akure, eikin mohunin ta mare nugok uwe, uwok! ");
INSERT INTO apec_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Aria douk shopunek yadukemesh um, maresh eshudok douk nyak nyunek beten nyorig Iruhin um nunekesh iri, anan ta nunekesh.” ");
INSERT INTO apec_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Aria Jisas nakripok nakri, “Nyakin mohunin ta watak nukitaki.” ");
INSERT INTO apec_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Mata kwomnek aria kwakripan kwakri, “Eik yadukemesh, ahudok hugiguk iri nyumnah ihishmorim shagok iri watak shukitakumori shagokum, aria anan douk ta watak nukitaki.” ");
INSERT INTO apec_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Aria Jisas nakripok nakri, “Douk eik atuwe debeiwe iri aria dodogoiwe um ihur shagok iri watak shukitak shupe wosik um. Aria eshudok douk shasuhw eikin baraen shagipeshen aria shagok iri, eshesh douk ta watak shukitak aria adur shupe wosik atin. ");
INSERT INTO apec_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Aria eshudok douk watak shape aria shusuhw eikin baraen shugipeshen iri, eshesh ta mare shugok uwe, uwok.” Aria anan narig nakri, “Nyak nyenek bilip nyakri enyudok baraen douk adur atin aka, uwok?” ");
INSERT INTO apec_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Aria Mata kwakri, “Adur, Debeini. Eik douk yenek bilip yakri nyak douk Iruhin ananin Nuganin. Yakri nyak Krais, douk Iruhin nagraehen aria neshopoken nyanakmori nyurao arpesh iri.” ");
INSERT INTO apec_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Douk Mata kwakriyuk enyudok baraen aria watak kwatanamum kwanak kwahwar okwokwik awik Maria. Douk kwanaki aria kwakripok shokubur kwakri, “Apakin Debeini Tisa douk nanaki aria nakri nyak nyunak nyutrun.” ");
INSERT INTO apec_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Douk Maria kwomnek namudok aria arigas kwaikitak kwanak um kutik Jisas. ");
INSERT INTO apec_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Anan Jisas douk watak nunak nutogur wabur uwe, uwok. Watak neyotu yah agundok douk Mata kwarik kwanak kwaparugan um. ");
INSERT INTO apec_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Enesh Juda douk shani Maria shape okwokwit urupat um shugabeimok apahw. Douk shatik um okwok arigas kwaikitak kwanak um aria shakri okwok ta kwanakum wonugwehw um kwupe kureh. Namudok aria shakitak shagipeshok shanak. ");
INSERT INTO apec_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Douk Maria kwanak kwatogur agundok Jisas natogur napeum aria kwatrun. Kwatrun aria kwanak kwabuh kwoduk ohrubus hurukatinyum anan aria kwakri, “Debeini, douk nyak nyupe agundok akure, eikin mohunin ta mare nugok uwe, uwok.” ");
INSERT INTO apec_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Jisas natruk um kworeh aria eshesh shanamok iri Juda douk shopunek shataurumok shereh. Natik namudok aria ananihw apahw yowehw abom aria nenek giha. Aria anan shopunek nakri nunamesh shureh. ");
INSERT INTO apec_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Aria douk narigesh nakri, “Ipak panak paruman agnum?” Aria eshesh shakri, “Debeini, nyak yowi ba nyutik.” ");
INSERT INTO apec_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Douk shanak aria Jisas nereh. ");
INSERT INTO apec_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Eshudok Juda shatik um agundok Jisas nereh um aria shakri, “Ipak putik, ananim urkum douk yowem abom um manawasham Lasarus.” ");
INSERT INTO apec_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Aria enesh shakri, “Anan douk nagabe anan nabes seshukanari aria anan watak natrugun. Aria namudok mumam, um anan madae nutaurum Lasarus um mare nugok um uwe?” ");
INSERT INTO apec_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Jisas ananihw apahw watak shopunek yoweh abom aria nenek gihaum eshudok arpesh aria nanak arigah nanak natogurum wonugwehw. Ahwudok wonugwehw douk shatukohw shawish onok burbuduk shenek hurupihw. Aria agundok umunihw um douk shabodigi utom shanak shashapomuk wonugwehw. ");
INSERT INTO apec_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Aria Jisas nakri, “Bodiguk amudok utom douk matao umunihw um wonugwehw iri.” Aria anudok nagok iri ananik mohwukwik Mata kwakri, “Debeini, apak maruman noruk nubatih nyumneh aria anan douk ta nisig.” ");
INSERT INTO apec_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Aria Jisas nakripok nakri, “Eik douk iganigadae yakripen. Douk nyak nyusuhw eikin baraen nyukri adurin um, nyak douk ta nyutik agundok Iruhin adur dodogowin atun um.” ");
INSERT INTO apec_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Namudok aria eshesh shanak shabodiguk amudok utom. Aria Jisas nanig natik iruhw aria nakri, “Yain, eik douk yenek tenkyumen. Um maresh? Nyak douk nyemnek eikin beten. ");
INSERT INTO apec_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Eik yadukemesh um ihih nyak wosik nyemneke um agundok yenek beten yahwarenyum. Aria eik urkum morum eshudok sheyotu agundok iri, aria douk yakri namudok. Um yakri eshesh shutik enyudok mour douk eik ta ineken iri aria shunek bilip shukri eik douk nyak nyeshopoke aria douk yanaki.” ");
INSERT INTO apec_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Douk nakriyuk enyudok aria nahwar debeg nakri, “Lasarus, arigah kitak tograri!” ");
INSERT INTO apec_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Aria anudok nagok iri adur nakitak natograri. Ananish roguhw aria aiyas douk sheshrehesh rupeh. Ananig yomag shopunek shesherehog anah rupah. Aria Jisas nakripesh nakri, “Ipak pukweshihuk rupeh aria anan nunak.” ");
INSERT INTO apec_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Sabaishi Juda douk shanaki shani Maria shapeum shugabeimok apahw. Eshesh douk shatik enyudok Jisas neneken iri mour aria adur shenek bilipuman. ");
INSERT INTO apec_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Aria enesh shatanam shanak shakrip amam Farisi um enyudok Jisas neneken iri. ");
INSERT INTO apec_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Shakripam aria amam hani debeimi pris hahwar amudok anam debeimi Juda douk hape hasuhw kwotog iri hanaki. Hanaki hape atugun aria hakri, “Anudok arman douk nenek sabainyi Iruhin atun neneken iri mour. Aria apak douk ta munekan mumam? ");
INSERT INTO apec_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Apak mukri mukutunuguk ba nupe nunek enyudokmori atin um, ihishmorim arpesh ta shunek bilip um anan atun. Namudok aria eshesh Rom esheshim debeimi ta hunaki hununu atudok Iruhin ananit debeiti urupat aria ta hubo eshudok ihishmorim apakishi arpesh shugok.” ");
INSERT INTO apec_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Aria anudok arman shahwaran um Kaiafas iri douk nani amam hape. Anan douk debeini pris um enyudok kwar. Anan nemnek aria nakripam nakri, “Ipak douk madae pudukem enesh eshudok uwe, uwok. ");
INSERT INTO apec_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Ta pudukemesh aka, uwok? Enyen douk wosik um mubo atun arman nugok aria mutaurum eshudok ihishmorim Judaish arpesh um shupe wosik. Aria ta douk uwok um, apak ihipmorim Juda ta mugok mutuh.” ");
INSERT INTO apec_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Enyudok baraen douk madae anan meyoh nukriyen uwe, uwok. Anan douk debeini pris um enyudok kwar. Namudok aria Iruhin nohur anan nakri enyudok baraen kabi amam profet heyagwreh um. Nakriyen um Jisas douk ta nugok um nutaurum ihishmorim eshesh Juda. ");
INSERT INTO apec_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Aria shopunek anan ta mare nugok um nutaurum eshesh Juda atish um shupe wosik, uwok. Anan ta nugok um nurao ihishmorim Iruhin ananishi batowish douk shanak shape kupakupa irubi warub iri um shutogur atish arpesh. ");
INSERT INTO apec_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Aria ahudok nyumnah arigaha douk eshesh Juda esheshim debeimi hape habo baraen um hurim anah yah um hubo Jisas nugok. ");
INSERT INTO apec_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Douk namudok aria agundok eshesh Juda shapeum, Jisas douk madae nurahaen yopugunum atin uwe, uwok. Aria nakitak nakutukuk abrudok wabur nanak um anagun douk nape hurukatinyum wehigunum arpesh uwok um. Nanak um anabur wabur shahwarabur um Efraim iri aria nani apak ananim disaipel mape agundok. ");
INSERT INTO apec_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Aria ahudok nyumnah um eshesh Juda shunek esheshigun debeiguni worigun Pasova um douk hanaki hurukatin. Aria sabaishi arpesh shape sabairubi warub iri shakitak shato um Jerusalem. Shanak um shugipesh esheshin lo shunagapesh eshesh kanak um Iruhin nutrish nukri wosik yopishi aria nuhut biyen shunak shuwok agundok worigun. ");
INSERT INTO apec_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Douk sabaishi arpesh shanaki aria shape shaurim Jisas. Eshesh sheyotu numun narub Iruhin ananit debeiti urupat tataoum aria eshesh kanak shape sheneyagwreh shakri, “Ipak pakri mumam? Anan ta nunaki um agundok worigun aka, uwok?” ");
INSERT INTO apec_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Aria amam debeimi pris hani amam Farisi douk hakripesh um douk enen arpen nyudukemesh um agundok Jisas nanak napeum, aria ta enyen nyunaki nyukripam um amam hunak husuwan huweshikan. ");
INSERT INTO apec_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Douk 6-poreih nyumneh watak hapeum shunek agundok debeiguni worigun Pasova, aria Jisas nakitak nanak um Betani. Betani douk Lasarus ananibur wabur. Anudok douk riguk nagok aria Jisas watak nonohur nakitak nape iri. ");
INSERT INTO apec_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Jisas nanak nape agundok aria eshesh shenekuman anagun worigun. Mata kwape kwowah worigun aria Lasarus iri Jisas douk hani eshudok shanaki um shuni Jisas shuwok worigun iri shape shersharih tebol. ");
INSERT INTO apec_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Aria Maria kwakitak kwohur enen yopinyi sanda nyeigurinyum nad douk shatorin debeibori utabor iri aria kwanak kwouraken kwape kwenyayok Jisas ananiruh yeriweruh. Kwouraken iyoh aria watak kwakwu okwokwig barag kwape kwogabe yeriweruh. Aria arpesh shape numun urupat iri shemnek enyudok sanda nyeisik yopuri unar. ");
INSERT INTO apec_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Aria anan Jisas ananin disaipel shahwaran um Judas Iskariot iri douk nanamesh shape agundok. Aria anan douk ta niyabig Jisas um ananim horim aria amam husuwan hunak hon nugok iri. Douk anudok Judas natik namudok aria nakri, ");
INSERT INTO apec_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Um maresh aria ipak madae pukri um enesh arpesh shutor enyudok sanda aria shukop 300 siliwaibor utabor uwe? Shukop aria misiyabor um eshudok yaruhish arpesh.” ");
INSERT INTO apec_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Anan douk madae urkum murum yaruhish arpesh aria douk nukri namudok uwe, uwok. Anan douk nakwuaruh atin iri. Shopunek asudok amamis bokis douk hape hakutu utabor borasi douk anan neyohos aria apa nakwumobor aruh abrudok utabor. ");
INSERT INTO apec_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Jisas nemnek namudok aria nakri, “Ipak ruwokuk um okwok douk kwonek enyudok aria kwogapesh eik um ahudok nyumnah ta she igok aria shunak shurume um. ");
INSERT INTO apec_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Yaruhish arpesh um eshudok iri ta shini ipak pupe ihih nyumneh. Aria eik ta mare ini ipak mupe roubium uwe, uwok.” ");
INSERT INTO apec_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Sabaishi Juda douk shemnek baraen um Jisas nanak nape Lasarus ananit urupat gani Betani. Namudok aria eshesh shanak um shutrun. Aria eshesh douk madae shunak um shutik Jisas atun uwe, uwok. Eshesh shopunek shanak um shutik Lasarus douk nagok aria Jisas watak nonohur nakitak nape iri. ");
INSERT INTO apec_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Douk namudok aria amam debeimi pris habo baraen um hakri hubo Lasarus nugok shopunek. ");
INSERT INTO apec_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Um maresh? Sabaishi Juda douk shatik um agundok Jisas nonohur nakitak napeum, aria eshesh shakutukuk esheshim debeimi Juda shanak shasuhw Jisas ananin baraen shagipeshen. ");
INSERT INTO apec_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Sabaishi arpesh douk shanaki shape Jerusalem um shunek agundok debeiguni worigun Pasova. Douk ruwahepih aria eshudok sabaishi arpesh shemnek baraen um shakri Jisas douk neyotuwi yah nape nanakmori Jerusalem. ");
INSERT INTO apec_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Douk namudok aria eshesh shanak shatupoki palmenigas aragas shanak arigaha shaparugan aria shahwar shakri, “Apak manadudareh um Iruhin! Apak makri Iruhin nunekuman yopinyi anudok arman douk nanakumori Debeini ananin nyeigur iri. Makri anan nunekuman yopinyi apak Israel apakin King!” ");
INSERT INTO apec_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Jisas naparug enen nugaen donki douk nakih netem aria nanak kabi douk enyudok baraen nyetem Iruhin ananik Buk iri nyakrium. Baraen enyudok ");
INSERT INTO apec_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","nyakri, “O ipak arpesh pape abrudok debeiburi wabur Saion iri, ipak mare punogugur. Tik, ipakin King anudok apa nanaki. Anan netemori enen nugaen donki aria nape nanaki.” ");
INSERT INTO apec_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Aria abudok nyutob, apak ananim disaipel douk madae mudukem baugenyum enyudok baraen uwe, uwok. Aria arigaha douk Jisas watak natanam natoum iruhw heven, aria abudok nyutob apak douk madukemen. Urkum morum aria madukemesh makri enyudok baraen nyetem Iruhin ananik Buk iri douk nyakrium anan. Eshesh douk shopunek urkum morum enyudok douk eshesh kanak shenekesh um anan iri. ");
INSERT INTO apec_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Aria abudok nyutob Jisas nahwar Lasarus nakitak natograri wonugwehw aria watak napeum, sabaishi arpesh douk sheyotu shatrun. Douk namudok aria eshesh shanak shanakripam um enyudok anan neneken iri. ");
INSERT INTO apec_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Aria sabaishi arpesh shemnek um enyudok Jisas neneken iri, um nohur Lasarus um. Douk namudok aria eshesh shanak shaparugan yah. ");
INSERT INTO apec_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Amam Farisi hatik namudok aria hanakripam hakri, “Tik, apak meneken iri mour douk madae dodogowin uwe, uwok. Ihishmorim armam armago douk shashi shanak shagipesh Jisas atun.” ");
INSERT INTO apec_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Enesh eshesh Grik douk shanak um Jerusalem shani eshudok arpesh douk shanak um shunek lotu um Iruhin ahudok debeihi nyumnah douk shenek agundok debeiguni worigun ahi. ");
INSERT INTO apec_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Aria eshudok Grik shanaki shatogurum Filip. Anan douk nanaki abrudok wabur Betsaida douk bape agudok shokugi nahobig Galili iri. Shanaki aria shakripan shakri, “Debeini, apak makri mutik Jisas.” ");
INSERT INTO apec_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Filip nemnek aria nanak nakrip Andru. Aria amam biom hanak hakrip Jisas. ");
INSERT INTO apec_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Hakripan aria anan nawanamam baraen nakri, “Abudok nyutob um Iruhin nunek Eik Anudok Arman douk yatogur adurinyi arpen iri um irao debeinyi nyeigur um douk abudok batogur. ");
INSERT INTO apec_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Adurin atin yakripep. Douk urubit wit tukri mare tugruki tubuh tukus amnab aria yarit um, atat douk ta atudok atut ta tugok jurug. Aria douk atat mamokit tugruki ba tubuh tukus yopubi amnab aria tugok um, atat douk ta watak pupurot arah tukih aria ta sabaiti urubit tir. Kabi ta eik igok aria shurume um. ");
INSERT INTO apec_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Enyudok arpen douk enyen urkum murum enyen atin um nyukri nyupe wosik nyupe roubi nyutob agundok atap iri, enyen ta mare nyupe roubi uwe, uwok ta nyunununukuk. Aria enyudok arpen douk watak nyupe agundok atap aria enyen mare urkum murum enyen atin aria nyunek eikin mour iri, enyen douk ta nyupe wosik abom ihih nyumneh. ");
INSERT INTO apec_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Aria enyudok arpen douk nyunek eikin mour iri, enyen ta adurin nyugipesh eik. Aria agundok eik inak ipeum, enyen shopunek ta nyunaku nyuni eik upe. Aria eikin Yain ta nutuk enyenyin nyeigur nyuto iruhw.” ");
INSERT INTO apec_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Aria Jisas watak shopunek nakri, “Douk eikihw apahw douk adur yowehw abom aria baraen uwok um ta ikri um. Eik ta mare iyorig Yain um nukweshihuk yah um enyudok amaen ta mare nyutogurume um uwe, uwok. Baugos um agundok eik yanakmori agundok atap um, douk yanakmori iwish um enyudok amaen atin. ");
INSERT INTO apec_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Yain, nyak nyunek enyudok ihinyumori mour kabi nyak nyakrium. Nyuneken um nyunatuk nyakin nyeigur nyuto iruhw.” Douk Jisas nakri namudok aria anah mah hanaki gani iruhw heven. Aria ahudok mah hakri, “Eik iga yatuk eikin nyeigur nyato iruhw. Aria douk ta watak shopunek gamo ituken nyuto iruhw um anah shopunek.” ");
INSERT INTO apec_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Aria eshudok sabaishi arpesh douk sheyotu hurukatin iri shemnek ahudok mah aria shakri utag pogarog. Enesh shakri enen ensel nyani Jisas heyagwreh. ");
INSERT INTO apec_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Aria Jisas nakripesh nakri, “Ahudok mah hanaki iruhw utag iri douk madae hunaki um hutaurum eik uwe, uwok. Ahah douk hanakium hutaurum ipak. ");
INSERT INTO apec_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Aria douk, Iruhin ta nunekumesh kwot eshudok douk shukon agabus iri. Aria shopunek anan ta nubo Satan nubuhuk. Anan douk nape debeini um agundok atap iri. ");
INSERT INTO apec_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Aria eik ta shutuke shiyaur iruharia ta iyonuki ihishmorim arpesh shunakmori eik.” ");
INSERT INTO apec_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Anan douk nakri namudok um eshesh shumnek aria shudukem ahudok yah douk ta anan nugok um. ");
INSERT INTO apec_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Douk namudok aria eshudok sabaishi arpesh shakrip Jisas shakri, “Apak madukemesh um, apakin lo nyakri abudok nyutob Krais nutogurum, anan ta mare nugok uwe, uwok. Aria ta nupe adur ihih nyumneh. Aria namudok nyakrium, um nyakri ‘Ta shusuhw Anudok Arman douk natogur adurinyi arpen iri aria shon nugok nir rowog kruse um?’ ‘Anudok Arman natogur adurinyi arpen iri’ douk adur meini?” ");
INSERT INTO apec_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Aria Jisas nakripesh nakri, “Eik douk ta ini ipak mupe banab nyutob meyoh kabi hanu anat lait tabuhumepum. Douk namudok aria ipak pupe punek yopihi atih aih abudok nyutob atudok lait hanut tabuhumepum. Um ipak mare pupe arukwutigunum uwe, uwok. Meinyi arpen nyarahaen arukwutigunum iri, enyen douk ta mare nyudukem agundok enyen nyanak um uwe, uwok. ");
INSERT INTO apec_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Douk abudok nyutob eik atudok lait watak yani ipak mape um, ipak adur pusuhw eikin baraen dodog pugipeshen. Punekesh namudok um, ipak ta putogur arpesh douk sharahaen laitigun um iri.” Douk Jisas nakriyuk namudok aria nakutishukuk nanak nanabeshuk nape anagun. ");
INSERT INTO apec_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Anan watak nanamesh shape obi nyutob, anan douk nenek sabainyi Iruhin atun neneken iri mour shatrin. Shatrin aria eshesh madae shunek bilip um anan uwe, uwok. ");
INSERT INTO apec_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Eshesh shenekesh namudok um enyudok baraen seiwok profet Aisaia neyagwrehen aria nyetem Iruhin ananik Buk iri nyutogur adurin atin. Baraen enyudok. Nyakri, “Debeini, apak douk makripesh nyakin baraen, aria eshesh madae shusuhwen shukri adurin uwe, uwok. Eshesh shatik enyudok dodogowinyi mour nyak Debeini nyeneken iri aria eshesh madae shukri nyak douk Debeini uwe, uwok.” ");
INSERT INTO apec_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Eshesh douk madae shukuna wosik shunek bilip um Jisas uwe, uwok. Um maresh? Enyudok enen Aisaia nenyemori baraen douk nyetem namudok, ");
INSERT INTO apec_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Iruhin nakri, “Eik yatapok esheship urkwip pani esheshis nabes. Namudok aria mare ta shutrugun wosik shutik eshudok urkwip purumesh aria shudukem baugenyum baraen. Namudok aria ta shukri um shatanam shuke aparuh eik um igabeyesh shupe wosik. Aria shakri uwok.” ");
INSERT INTO apec_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Seiwok Aisaia douk natik agundok Jisas adurin dodogowin atun nyeigur nyato-uman um aria nowemaguk enyudok baraen um anan. ");
INSERT INTO apec_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Enyen douk adur. Aria abudok nyutob sabaimi eshesh Juda esheshim debeimi henek bilip um Jisas. Aria amam douk hanogugur um amam Farisi aria madae huwereh amamin bilip yopugunum uwe, uwok. Um maresh? Hakri ta amam Farisi hukri uwok um ta mare huwish hunamesh hunek lotu agudok urusag douk eshesh Juda douk shape sheneyagwreh baraen-ogwi uwe, uwok. ");
INSERT INTO apec_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Umum maresh? Amam henek bilip iri douk mishish shakitak abom um arpesh ta meyoh shutuk amamishi nyeiguhw shuto iruhw. Aria hakri karowin atin um Iruhin kanak ta nutuk amamish nyeiguhw shuto iruhw uwe, uwok. ");
INSERT INTO apec_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Aria Jisas nakripesh debeg nakri, “Eshudok arpesh douk shunek bilip um eik iri, eshesh douk madae shunek bilip um eik atuwe uwe, uwok. Eshesh douk shenek bilip um anudok douk neshopok eik yanaki iri shopunek. ");
INSERT INTO apec_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Aria abudok nyutob eshudok douk shatik eik obi nyutob, eshesh douk shatik anudok douk neshopok eik yanaki iri. ");
INSERT INTO apec_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Eik douk yanaki agundok atap kabi lait um. Yanakmori eshudok douk shusuhw eikin baraen shugipeshen iri ta mare watak shupe arukwutigun atin uwe, uwok. ");
INSERT INTO apec_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","“Aria arpesh douk shemnek eikin baraen aria mare shusuhwen dodog shugipeshen iri, eik douk ta mare inek skelumesh um kwot kabi douk jas um uwe, uwok. Eik douk madae inaki agundok atap um inek skelum arpesh uwe, uwok. Eik douk yanakmori inarao arpesh shutanamori shupe wosik. ");
INSERT INTO apec_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Aria eshudok douk shuke agabus eik shukri uwok um shusuhw eikin baraen iri, esheshin jas douk kweipon ta nunekumesh kwotog iri douk nape. Enyudok atin baraen douk eik yakripeshen aria eshesh madae shigipeshen iri uwe, enyen kanak ta nyunek skelumesh aria nyunekumesh kwotog kabi jas um ahudok hugiguk iri nyumnah hutogrum. ");
INSERT INTO apec_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Um maresh? Enyudok baraen douk madae eik meyoh urkum murumen aria ipe ikripeshen uwe, uwok. Enyen douk eikin Yain nakripeyen abom aria neshopoke yanaki um ikripesh. Aria anan douk neyabige um ikripesh mumam. ");
INSERT INTO apec_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Aria eik yadukemesh um Iruhin ananin baraen ta nyunek arpesh um shusuhwen shugipeshen aria shupe wosik abom ihih nyumneh. Namudok aria ihinyumori enyudok eik yakriyen iri baraen, enyen douk eikin Yain meyoh nakripeyen aria douk yanaki yakripepen.” ");
INSERT INTO apec_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Ahudok nyumnah um shunek agundok debeiguni worigun Pasova um douk hanaki hurukatin. Aria Jisas douk nadukemesh um abudok nyutob ta nukutukuk agundok atap nunak nini Yain hupeum douk banaki. Aria abudok nyutob anan napeum, ananim urkum douk adur manawasham ihishmorim ananishi arpesh douk mape agundok atap iri arigaha ta nugok um. Aria douk shopunek anan watak neyabigap um anan urkum manawasham apak abom um. ");
INSERT INTO apec_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Satan douk iga nawish Saimon ananin nuganin Judas Iskariot. Nawishan aria nako yoweimi urkum um anan ta nuwereh Jisas um ananim horim aria amam husuwan hunak hon nugok. Douk arigaha wabigep aria amam hape hawok worigun. ");
INSERT INTO apec_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Jisas nadukemesh um Iruhin douk nakri wosik aria neshopoki anan um nupe Debeini um ihishmorim eshudok eneshenesh. Aria shopunek nadukemesh um anan douk nani Iruhin hape iri nakitak nanaki aria ta watak nutanam nunak nini anan hupe. ");
INSERT INTO apec_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Aria nakitak nowar ahudok rouhi rupah douk nohunug aduk iri nahubukuk aria nohur enen tawor naweshiken nyape apahwinum. ");
INSERT INTO apec_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Naweshiken nyape aria nohuri abar nourakabar anohw yaurehw aria nape nakwrupumap yeriweruh apak ananim disaipel. Nakwruporuh-umap iyoh aria watak nabatik abar enyudok tawor douk naweshiken nyape apahwinum iri. ");
INSERT INTO apec_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Nakwruporuh-umap nanak natogurum Saimon Pita aria Saimon nakripan nakri, “Nyak douk Debeini. Namudok aria eik douk yakri uwok um nyak nyukwrup eikiruh yeriweruh uwe, uwok.” ");
INSERT INTO apec_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Aria Jisas nakripan nakri, “Douk, nyak madae nyudukem baugenyum uwe, enyudok mour douk eik yeneken iri. Aria nuhut biyen nyak wosik ta nyudukemesh.” ");
INSERT INTO apec_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Aria Pita nakripan nakri, “Uwok, eik yakri uwok abom um nyak nyukwrup eikiruh yeriweruh!” Aria Jisas watak shopunek nakripan nakri, “Douk eik mare ikwrup nyakiruh yeriweruh um, nyak douk ta mare nyupe eikin disaipel uwe, uwok.” ");
INSERT INTO apec_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Saimon Pita nemnek namudok aria nakri, “Debeini, namudok um, nyak douk ta mare nyukwrup eikiruh yeriweruh aturuh uwe, uwok. Yakri nyukwrup roguhw aria barag shopunek.” ");
INSERT INTO apec_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Aria Jisas nakri, “Enyudok arpen douk nyeshrokuh jurug iri, enyen douk yopin aria mare ta nyukri um nyishrokuh shopunek uwe, uwok. Enyen ta nyunokwrup yeriweruh aturuh. Enyenyihw yegenyihw shuknihw wosik yopuhw. Ipak sabaipi douk yopipi. Aria atun meyoh douk madae yopun uwe, uwok.” ");
INSERT INTO apec_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Jisas douk nadukeman anudok disaipel douk ta nuwereh anan um ananim horim aria husuwan hunak hon nugok. Namudok aria anan douk nakri namudok. Nakri, “Ipak ihipmorim douk yopipari, aria atun arman meyoh douk madae yopun uwe, uwok.” ");
INSERT INTO apec_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Douk nakwrupumap yeriweruh iyoh aria watak nohur ahudok rouhi nahunug aduk iri rupah nohahw. Aria nanak nabuh nape agundok iganigadae napeum. Nape aria narigap nakri, “Ipak padukem baugenyum mour um enyudok iganigadae yenekenyumep iri aka, uwok? ");
INSERT INTO apec_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Ipak pani eik meyagwreh um, ipak douk padukemesh pohware Debeini Tisa aria Debeini. Aria pohware namudok um, enyen douk adur. Um maresh? Eik douk ipakin Debeini Tisa aria Debeini. ");
INSERT INTO apec_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Eik douk ipakin Debeini aria ipakin Debeini Tisa shopunek, aria eik douk iga yakwrup ipakiruh yeriweruh. Aria yakri ipak atin atin douk shopunek punak punataurum punakwrup ipakiruh yeriweruh. ");
INSERT INTO apec_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Eik yenek ahudok aih yeyabigep aria ipak shopunek punak punekah namudok atin kabi douk yenekah um ipak um. ");
INSERT INTO apec_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Adur atin yakripep. Enen nyape shukamum anan debeini nyenekuman mour meyoh iri, enyen douk madae debeinyi nyishagrakuk enyenyin debeini uwe, uwok. Aria douk namudok atin. Enen nyarao baraen iri douk madae debeinyi nyishagrakuk enyudok enen douk nyeshopoken nyanak iri uwe, uwok. ");
INSERT INTO apec_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Aria douk ipak douk padukem baugenyum baraen um ahudok aih eik yenekah iri. Aria douk ipak pugipeshah um, Iruhin ta nutaurumep nunekumep yopihi aih aria nunekep punadudareh! ");
INSERT INTO apec_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Aria eik douk madae ikriyen um ipak ihipmorim uwe, uwok. Eik yadukemep ipak douk eik nubokadae yagraehep iri. Aria enyudok Iruhin ananin baraen douk nyetem ananik Buk iri douk ta adurin nyutogur adurin atin abom. Baraen douk enyudok. ‘Anudok arman douk nani eik wape wawok worigun atugunmorim iri watak natanam natogur horin um eik.’ ");
INSERT INTO apec_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Enyudok douk eik yakriyen iri douk watak nyutogur uwe, aria douk yakripep. Yarik yakripep um abudok nyutob nyukri nyutogurum, ipak douk ta punek bilip pukri Eik Douk Seiwok Yape Namudok Iri. ");
INSERT INTO apec_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Adur atin yakripep. Arpen douk nyumnek enyudok arpen douk eik ishopoken nyunak iri enyenyin baraen aria nyuraen iri, enyen douk nyemnek eikin baraen aria nyarao eik shopunek. Aria enyen douk nyemnek eikin baraen nyarao eik iri, enyen douk nyemnek anudok douk neshopoki eik yanaki iri ananin baraen aria nyarao anan shopunek.” ");
INSERT INTO apec_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Douk Jisas nakriyuk namudok iyoh aria ananihw apahw amu yowehw abom. Aria douk amu nawerehen nakripam nakri, “Adur atin yakripep. Ipak sabaipi pape agundok iri, ipak anan douk ta nuwereh eik um horim aria ta husuwe hurae hunak he igok.” ");
INSERT INTO apec_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Douk Jisas nakri namudok aria apak ananim disaipel matanam manashakamum. Makri anan douk nakri meini. ");
INSERT INTO apec_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Aria anudok disaipel douk Jisas anan urkum makri munawashaman iri douk nape hurukatinyum anan Jisas iri. ");
INSERT INTO apec_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Douk namudok aria Saimon Pita nouramanagu barag aria nakri, “Nyak kwasorigan. Anan douk nakri um amiapen?” ");
INSERT INTO apec_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Aria anudok disaipel natotigos nanak harokatinyum Jisas aria narigan nakri, “Debeini, nyak nyakrium amiapen?” ");
INSERT INTO apec_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Aria Jisas nakri, “Anudok douk eik isegur bret abrudok ekehibari abar ikonot iri, arman douk ta anudok atun.” Aria nohuri anagun bretigun naseguragun nako Saimon ananin nuganin Judas Iskariot. ");
INSERT INTO apec_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Douk Judas natrun bret natoh neyatat aria Satan adur nawishan. Aria Jisas nakripan nakri, “Arigah kare neken arigas enyudok douk nyakri nyuneken iri!” ");
INSERT INTO apec_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Nakripan namudok, aria apak ihipmorim mape agnudok mape mawok worigun iri douk madae mudukem baugenyum enyudok baraen uwe, uwok. ");
INSERT INTO apec_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Judas anan douk neyoh apakibor utabor. Douk namudok aria apak ananipari makri Jisas ta neshopokan um nunak nutori anagun worigun um agundok debeiguni worigun Pasova nunenek um, aka neshopokan um nunak nukeshuk anabor utabor eshudok yaruhish iri. ");
INSERT INTO apec_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Douk Judas nawok atudok bret iyoh, nakitak aria natogur nanakuk aria iganigadae wab. ");
INSERT INTO apec_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Douk Judas natogur nanakuk aria Jisas nakripap nakri, “Douk Eik Anudok Arman douk yatogur adurinyi arpen iri, Iruhin douk neke yarao Debeinyi nyeigur. Aria eik ta inek arpesh shutik agundok Iruhin dodogowin atun natrugun abom um aria ta shutuk ananin nyeigur nyuto iruhw. ");
INSERT INTO apec_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Aria douk eik ta ituk Iruhin ananin nyeigur nyuto iruhw um Iruhin anan kanak shopunek ahudok atuh ta nutuk Eik Anudok Arman douk yatogur adurinyi arpen iri eikin nyeigur nyuto iruhw. ");
INSERT INTO apec_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","O ipak douk adurip kabi eikish batowish-umori, eik douk ta ini ipak mupe banab nyutob meyoh aria ta watak ikwutipokuk inak. Inakuk aria ipak douk ta pupe purime. Riguk douk yakrip eshesh Juda esheshim debeimi aria douk shopunek yakrip ipak enyudok atin baraen. Ipak douk ta mare punak agundok eik inak ipeum uwe, uwok. ");
INSERT INTO apec_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Aria eik yakri ikripep enen namunyi lo douk ta pusuwen pugipeshen iri. Enyudok lo douk namudok. Ipak atin atin, ipakip urkwip douk adur pukri punawasham um ipak aria kupaishi arpesh shopunek. Um maresh? Kabi douk eik yarig urkum makri munawasham um ipak morim, aria ipak shopunek douk punekesh namudok atin. ");
INSERT INTO apec_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Aria douk ipak atin atin ipakip urkwip adur pukri punawasham um, ihishmorim arpesh ta shutrip aria ta shudukemesh shukri ipak douk pagipesh eik iri.” ");
INSERT INTO apec_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Douk Jisas nakripap namudok jurug aria Saimon Pita narigan nakri, “Debeini, nyak nyakri nyunak meiguni?” Aria Jisas nakri, “Douk nyak ta mare nyuname unak agundok douk ta eik inak um. Aria anob nyutob nyak wosik ta nyugipeshe nyunaku.” ");
INSERT INTO apec_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Aria Pita narigan nakri, “Debeini, aria nyak nyakri douk eik ta mare inamen unak um maresh? Eik douk madae inogugur um igok um agundok yagipesh nyak um uwe, uwok!” ");
INSERT INTO apec_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Aria Jisas nawanaman baraen nakri, “Pita, douk adur nyakri nyak ta nyugok um agundok nyagipesh eik um, aria ta uwok? Adur atin yakripen. Kwehigib ruwahepib wab, nyak ta nyunek rohwumesh biyeh atuh nyukri nyak madae nyudukem eik uwe, uwok, aria owot ta kadak tukitak tiyagwreh.” ");
INSERT INTO apec_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Aria Jisas nakrip apak ananim disaipel nakri, “Ipakish mishish ta mare yowesh uwe, uwok. Ipak ko punek bilip um Iruhin aria eik shopunek ta punek bilipume. ");
INSERT INTO apec_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Gani numunitum atudok eikin Yain ananit urupat douk sabaipi abom rip pape. Aria eik douk ta inak igabeimep anabik nupeimep. Douk madae anam rum mukus akure, eik ta mare igiyagimep ikripep namudok uwe, uwok. ");
INSERT INTO apec_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Adur ta inak igapeshumep-aguk ipakiyu outumeb upemepaguk aria watak itanamori irumep. Aria abrudok wabur eik inak ipeum, ipak shopunek ta puni eik mupe. ");
INSERT INTO apec_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Aria yah douk hanak um agundok eik yakri inak um, ipak douk wosik padukemah.” ");
INSERT INTO apec_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Aria Tomas nakripan nakri, “Debeini, apak douk madae mudukem agundok nyak nyakri nyunak um uwe, uwok. Yah ta mudukemah mumam, um munamagu?” ");
INSERT INTO apec_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Aria Jisas nawanaman baraen namudok. Nakri, “Eik kanak douk adur ahudok yah um arpesh shunak shutik Iruhin um, adur eik douk baugos um enyudok shiyagwreh adurin atin baraen um, aria douk shopunek adur baugos um enyudok shupe wosik abom ihih nyumneh um. Uwok um enen arpen ta nyugipesh kupaihi yah aria nyunak nyutik eikin Yain uwe, uwok. Yah douk adur eik kanak. ");
INSERT INTO apec_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Douk ipak padukem eik aria ta wosik abom um, eikin Yain douk shopunek ta pudukeman. Aria douk arigaha kweipon ipak wosik pape padukeman aria patrun jurug.” ");
INSERT INTO apec_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Aria Filip nakripan nakri, “Debeini, apak douk madae mukrium enesh eshudok kupaishi uwe, uwok. Aria makri nyiyabigap Yain atun aria jurug.” ");
INSERT INTO apec_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Aria Jisas nebeiman baraen nakri, “Filip, eik douk yani ipak mape roubi nyutob aria nyak douk watak nyudukem eik uwe? Yakripen, eshudok arpesh shatik eik iri douk iga shatik Yain. Aria nyak douk nyarige um watak iyabigep Yain um maresh? ");
INSERT INTO apec_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Nyak douk atin nyunek bilip um enyudok eik yakri Yain nape eik aria eik yape anan aka? Baraen yakripepen iri douk madae eik meyoh urkum murumen aria ipe ikripepen uwe, uwok. Aria Yain douk napenye iri nenek ananin mour aria nohur eik yakripep enyudok baraen. ");
INSERT INTO apec_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Ipak douk punek bilip um eik um enyudok yakri eik yape um Yain aria Yain nape eik um. Uwok um, ipakip urkwip watak purmaguk enyudok Iruhin atun neneken iri mour douk eik yape yeneken iri aria ipak punek bilip um eik. ");
INSERT INTO apec_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Adur atin yakripep. Enyudok arpen douk nyusuhw eikin baraen nyugipeshen iri, ihinyumori mour eik yeneken iri, enyen douk shopunek ta nyuneken. Adur, enyen ta nyunek debeinyi atin abom mour nyishagrakuk enyudok eik yeneken iri. Um maresh? Eik douk ta inak itik eikin Yain. ");
INSERT INTO apec_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Maresh eshudok douk ipak punek betenumesh um eikin nyeigur iri, eik douk ta inekeshumep. Eik ananin nuganin inekesh namudok aria Yain ananin nyeigur ta shutuken nyuto iruhw. ");
INSERT INTO apec_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Aria maresh eshudok douk ipak punek beten porige um eikin nyeigur iri, eik douk ta inekeshumep.” ");
INSERT INTO apec_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Douk ipak urkwip pakri punawasham eik um, eikin baraen douk adur ta pusuwen pugipeshen wosik atin. ");
INSERT INTO apec_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Aria ta inek beten iyorik Yain aria ta watak nukepari Enyudok Enen douk ta Nyutaurumep um Dodogowip iri. Nukepen aria ta nyuni ipak pupe ihih nyumneh. ");
INSERT INTO apec_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Enyudok Nyutaurumep iri douk Iruhin ananin Mishin douk nyape um nyeyagwreh adurin atin baraen iri. Aria arpesh douk shapeum shenek yoweihi amnabih aih iri ta mare shuraen nyupenyesh uwe, uwok. Um maresh? Eshesh douk madae shutrin aria shudukemen uwe, uwok. Aria ipak douk padukemen. Enyen douk nyani ipak pape aria ta nyuwish nyupenyep. ");
INSERT INTO apec_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Eik douk ta ikwutipokuk inak aria ta mare ikutipuk pupeik kabi douk yaruhish batowish um uwe, uwok. Ta wata itanam-umepari. ");
INSERT INTO apec_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Mare roubi um uwe aria arpesh douk shapeum shenek yoweihi amnabih aih atin iri ta mare wata shutik eik uwe, uwok. Aria ipak wosik ta putiwe. Eik douk ta yakitak yape wosik abom ihih nyumneh aria ipak shopunek ta adur pupe ihih nyumneh. ");
INSERT INTO apec_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Aria ahudok nyumnah hutogurum, um she igok aria watak ikitakumori, shagok um, ipak ta pudukemesh pukri eik douk yape eikin Yain, ipak pape eik aria eik yape ipak. ");
INSERT INTO apec_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Eshudok arpesh douk shusuhw eikin dodogowinyi baraen shugipeshen wosik iri, eshudok arpesh douk adur urkwip pakri punawasham eik. Aria eikin Yain ta adur urkum mukri munawasham eshudok arpesh. Aria eik shopunek ta urkum mukri munawasham eshudok arpesh aria ta itogur iyabigesh eik kanak um adur shudukeme.” ");
INSERT INTO apec_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Jisas nakri namudok aria Judas nakri, “Debeini, namudok mumam namudok um nyakri nyutogurum apak atapish arpesh aria shapeum shenek ehudok amnabih yoweihi aih iri nyakri uwok um nyiyabig nyak um eshesh?” Anudok Judas douk madae anudok douk Judas Iskariot uwe, uwok. ");
INSERT INTO apec_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Aria Jisas nawanaman baraen nakri, “Eshudok arpesh douk eshesh urkwip adur pakri punawasham eik iri, eshesh douk ta shusuhw eikin baraen aria shugipeshen wosik. Aria eikin Yain anan douk ta urkum mukri munawasham eshesh. Aria eik ini Yain ta unaki uni eshesh mupe ihih nyumneh. ");
INSERT INTO apec_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Eshudok madae urkwip pakri punawasham eik iri douk madae shusuhw eikin baraen shugipeshen uwe. Aria enyudok baraen douk pemneke yeyagwrehen iri douk madae iyagwreh enen eikin baraen uwe, uwok. Eik douk yeyagwreh eikin Yain douk neshopoke yanaki iri ananin baraen. ");
INSERT INTO apec_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Enyudok ihinyumorim baraen douk watak yani ipak mape aria yakripepen. ");
INSERT INTO apec_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Aria enyudok Iruhin ananin Mishin douk enyudok douk ta nyutaurumep dodogowip iri. Eikin Yain ta nishopoken nyunakmori eikin nyeigur. Enyen nyunaki aria ta nyiyabigep ihinyumorim enenyenen pudukemen. Enyen ta watak nyuhur ipakip urkwip aria ipak ta watak urkwip purum enyudok ihinyumorim baraen douk eik yakripep um. ");
INSERT INTO apec_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Eik ta ikwutipokuk inak, aria ehudok aih um shape wosik aparuh hor wosik um douk ehudok ikepehuk. Ehudok aih adur eikih aria douk ehudok yekepehuk. Eik madae ikep ehudok aih kabi arpesh shapeum shenek amnabih atih aih iri ta shukepeh um uwe, uwok. Namudok aria ipakish mishish douk mare yowesh pukri punogugur uwe, uwok. ");
INSERT INTO apec_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Ipak douk pemneke yakripep yakri, ‘Eik ta ikwutipokuk inak aria ta watak itanam-umepari.’ Douk ipakip urkwip adur pakri punawasham eik akure, ipak ta punadudareh um enyudok eik inak itik Yain. Um maresh? Anan douk debeini neshagrakuk eik. ");
INSERT INTO apec_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Enyudok ihinyumorim baraen watak nyutogur uwe aria douk yakripepumen. Namudok aria nuhut abudok nyutob enyen nyukri nyutogur obi nyutob, ipak douk ta punek bilip um eik pukri eik yakripepuguk adurinyi baraen. ");
INSERT INTO apec_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Eik ta mare watak ini ipak mupe roubi um miyagwreh sabainyi baraen shopunek uwe, uwok. Um maresh? Debeini um agundok atap iri douk hurukatin um nunaki. Anan nunaki, aria ta mare dodogowin um nunek enesh eshudok um eik uwe, uwok. ");
INSERT INTO apec_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Aria eik yakri agundok atapish arpesh ta shudukemesh um agundok eik douk adur urkum manawasham eikin Yain. Aria shopunek yakri shudukemesh um enyudok yeneken iri douk Yain nakripe ananin dodogowinyi baraen aria douk yeneken. Aria ipak douk kitak mukutukuk agundok ba munak.” ");
INSERT INTO apec_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Jisas watak shopunek nakri, “Eik douk enyudok adurinyi rowog wain. Aria eikin Yain douk anudok nenek mour numun agudok wainig nubarig iri. ");
INSERT INTO apec_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Ihish nyeiguhw douk shato iruhw eik enyudok rowog wain aria madae enep shuruwep piresh iri uwe, anan douk natupeshuk. Eshudok douk shuruwep peiresh iri, anan douk nagamohesh nagapeshesh neshuru banesh um wata sabaipi shuruwep pir. ");
INSERT INTO apec_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Aria douk namudok atin. Enyudok baraen eik yakripepen iri douk nyape ipakiruh aparuh aria nyenekep patogur yopipari. ");
INSERT INTO apec_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Ipak ta adur putogur punasusuhw pupe eik aria eik shopunek ta adur itogur inosusuhw ipak. Enen nyeigur enyen kanak ta mare shuruwep pir uwe, uwok. Aria douk enyudok nyeigur nyanasuhw enyudok rowog wain um, aria enyen douk wosik shuruwep ta pir. Aria douk namudok atin. Aria ipak mare putogur punasusuhw eik aria pusuhw eikin baraen dodog pugipeshen um, ipak kanak ta mare dodogowip um punek yopihi aih uwe, uwok. ");
INSERT INTO apec_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Eik douk enyudok rowog wain aria ipak douk nyeiguhw. Namudok aria arpen douk nyutogur nyunasusuhw eik aria eik itogur inasusuhw enyen iri, enyen douk ta nyunek sabaihi yopihi aih aria yopuguni worigun. Aria douk ipak mare putogur punasusuhw eik um, aria ipak douk ta mare dodogowip um punek enen yopunyi mugu uwe, uwok. ");
INSERT INTO apec_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Enyudok arpen douk madae nyutogur nyunasusuhw eik aria madae nyusuhw eikin baraen dodog nyugipeshen iri uwe, eikin Yain ta nenekeshumen kabi douk natupok enen nyeigur enyudok rowog wain aria nunyubukuk ba yarin um. Aria enyudokmori nyeigur douk ta shutorumen shunyubukuk atugun aria shuwashen nyubuhuk nyih hanu um. ");
INSERT INTO apec_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Aria ipak patogur panasusuhw eik aria eikin baraen nyupe ipak um, aria abudok nyutob ipak punek beten porige um eneshenesh eshudok ipak pakripe-umesh iri, aria adur atin, eshudok ta shutogur-umep kabi douk ipak penek beten porige um. ");
INSERT INTO apec_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Aria douk ipak punek sabaihi yopihi aih um, aria namudok arpesh ta shutrip aria ta shutuk eikin Yain ananin nyeigur nyuto iruhw. Punekesh namudok aria arpesh ta shutrip shukri ipak douk adur pagipesh eik iri. ");
INSERT INTO apec_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","“Eik douk urkum makri munawasham ipak kabi douk eikin Yain anan urkum makri eik um. Eikim urkum makri munawasham ipak aria ihih ipak urkwip ta adur purum enyudok. ");
INSERT INTO apec_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Aria douk ipak pugipesh eikin baraen adur atin um, aria eikim urkum ta mukri munawasham ipak. Aria ihih ipak ta urkwip purum enyudok aria ta pupe wosik. Kabi douk eik yagipesh eikin Yain ananin dodogowinyi baraen aria ananim urkum mukri manawasham eik aria eik urkum mukri murum enyudok yape wosik um. ");
INSERT INTO apec_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Eik douk yakripep enyudok baraen. Um maresh? Eik adur yakri ipak ta purao ehudok eikih aih um yanadudareh um hupeyep. Namudok aria ipak ta pupe um punadudareh puriguk. ");
INSERT INTO apec_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Eikin dodogowinyi baraen douk enyudok. Ipak atin atin ipakip urkwip douk pakri punawasham ipak pini kupaishi arpesh kabi douk eik urkum makri munawasham ipak um. ");
INSERT INTO apec_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Ehudok aih um enen arpen urkum adur mukri munawasham enyenyish arpesh aria nyugok um nyutaurumesh um, enyudok douk nyishagrakuk ihihmorim aih um urkwip pakri punawasham kupaishi um. ");
INSERT INTO apec_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Aria douk ipak adur pusuhw eikin baraen dodog pugipeshen um, aria ipak douk eikish arpesh. ");
INSERT INTO apec_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Douk eik ta mare wata ihwarep peneme mour meyoh iri uwe, uwok. Um maresh? Arpen nyenek mour um enyenyin debeini, enyen douk madae nyudukemen atin uwe enenyenen enyenyin debeini nakri um nuneken iri uwe, uwok. Aria douk, eik ta wata ihwarep eik kanak eikish arpeshim meyoh. Um maresh? Ihinyumori eikin Yain nakripe-yenyi baraen douk yakripepen yeyaten. ");
INSERT INTO apec_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Ipak douk madae punagraeh eik uwe, uwok. Eik yanagraeh ipak um adur punek sabaihi yopihi aih aria yopuguni worigun. Aria ehudok yopihi aih ta adur hupe namudok atin. Namudok aria eikin Yain ta nukep ihishmori douk ipak puhur eikin nyeigur nyuto iruhw aria poriganum nukepesh iri. ");
INSERT INTO apec_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Dodogowinyi baraen eik yakripep um pugipeshen iri douk enyudok. Ipak atin atin urkwip douk pakri adur punawasham ipak pini ihish arpesh.” ");
INSERT INTO apec_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Aria arpesh douk shapeum shagipesh ehudok amnabih yoweihi aih iri shukep agabus aria shenenem horik horin um, ipak aria pudukemesh um eshesh douk sharik sheke agabus eik aria shenenem horik horin um eik shopunek. ");
INSERT INTO apec_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Aria ipak pakri pugipesh enyudok douk eshesh shapeum sheneken iri um, aria esheship urkwip douk ta shukri shunawasham shukri ipak douk esheship iri. Aria eik douk yanagraehepum pupe eikish arpesh aria ipak douk mare pugipesh ehudok amnabih aih uwe, uwok. Namudok aria eshesh douk shakri uwok um ipak aria shape shenek horik horin um ipak. ");
INSERT INTO apec_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Ipakip urkwip douk ta purum enyudok baraen douk nubokadae yakripepen iri. Baraen enyudok. ‘Arman nenek mour meyoh um kupaini arman iri, anan douk madae nishagrakuk ananin debeini uwe, uwok.’ Aria douk namudok atin. Eshesh douk shenek enenyenen um eik ipakin Debeini aria ipak shopunek ta shunekep enenyenen. Aria shopunek ta eshesh shumnek eikin baraen akure, ipakin shopunek ta shumneken aria shugipeshen. ");
INSERT INTO apec_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Enyudok yakripep um douk ta shunekenyumep. Um maresh? Ipak douk eikip pagipesh eik aria eshesh douk madae shudukem anudok neshopoki eik yanaki iri uwe, uwok. ");
INSERT INTO apec_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Aria eik douk madae ibuhi agundok atap aria ikripesh Iruhin ananin baraen shumneken akure, Iruhin ta mare nukri baraen nyupenyesh um shenek eneshenesh yoweishi inahos uwe, uwok. Aria eik douk yabuhi yakripeshen shemnek aria yah douk wokesh um shukri shunabeshuk um eneshenesh shenekesh iri yoweishi um. ");
INSERT INTO apec_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Eshudok arpesh douk shakri uwok um eik aria shenek horik horin um eik iri, eshesh douk shopunek shakri uwok um eikin Yain aria shenek horik horin um anan shopunek. ");
INSERT INTO apec_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Eik yenek enenyenen Iruhin atun neneken iri mour douk riguk madae enen arpen nyuneken iri uwe nyatogur aria shatrin. Aria eshesh douk shatik eik yeneken nyatogur aria shakri uwok aria shenenem horik horin um eik yani eikin Yain shopunek. Aria douk adur, um eik mare inek enyudok mour shutrin akure, aria Iruhin ta mare nukri eshesh douk shenek yoweishi inahos aria ta mare adur nunemesh debeinyi baraen uwe, uwok. ");
INSERT INTO apec_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Enyudok douk sheneken nyatogur um enen baraen nyetem Iruhin ananik Buk iri nyatogur adurin atin. Baraen enyudok. ‘Baugenyum baraen uwok enen uwe, aria shakri uwok um eik. Sheneme horik horin eik meyoh.’ ");
INSERT INTO apec_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Aria nuhut biyen enyudok Nyutaurumep um Putogur Dodogowip iri ta nyunaki. Enyen douk Iruhin ananin Mishin douk nyeyagwreh adurin atin baraen iri. Enyen douk nyani Yain shape aria ta nyunaki. Enyen douk nyani Yain nyape aria ta ishopoken nyukutun-uguk nyunaki. Ta nyunaki aria nyukripep sabainyi eikin baraen. ");
INSERT INTO apec_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Aria ipak douk shopunek ta pukripesh eikin baraen. Um maresh? Riguk watak sagomatin yohur enyudok mour obi nyutob arigaha douk, ipak douk pagipesh eik aria patiwe aria padukemesh.” ");
INSERT INTO apec_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Jisas watak apa nakripesh baraen nakri, “Eik douk yakripep enyudok sabainyi baraen um yakri ipak mare pukutukuk eik uwe, uwok. ");
INSERT INTO apec_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Aria ta shukrip ipak um pukutukuk eshesh Juda shanotorum shape sheneyagwreh baraen-ogwi urusag putogrukuk aduk um mare punamesh punek lotu. Aria nyutob ta butogur um enesh arpesh ta shep pugok iri ta shunek urkum shukri eshesh wosik shenek Iruhin ananin yopunyi mour. Aria uwok. ");
INSERT INTO apec_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Ta shunemep enyudok um maresh? Eshesh douk madae shudukem eik aka, shudukem eikin Yain uwe, uwok. ");
INSERT INTO apec_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Eik douk yakripep enyudok um abudok nyutob shukri shunemep enyudok obi nyutob, aria ipak ta urkwip purum pukri eik douk yarik yakripep debeinyi baraen um enyudok. “Riguk watak sagomatin um yakitak um inek mour um douk madae ikripep enyudok baraen uwe, uwok. Um maresh? Eik douk watak yani ipak mape. ");
INSERT INTO apec_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Aria douk, eik ta inak itik anudok douk neshopoki eik yanaki iri. Aria ipak douk madae anan norige um agundok ta eik inak um uwe, uwok. ");
INSERT INTO apec_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Aria eik yakripep enyudok baraen um ta inak um. Namudok aria ipakish mishish douk yowesh abom. ");
INSERT INTO apec_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Aria adur atin yakripep. Eik ikutukuk ipak pupeik inak um, enyudok douk wosik um itaurum ipak. Aria douk eik ikri mare inak um, aria enyudok Nyutaurumep iri ta mare nyunak-umepari uwe, uwok. Aria douk eik inak um, eik douk ta ishopokenyi nyunaki nyuni ipak pupe aria nyutaurumep. ");
INSERT INTO apec_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Aria abudok nyutob Enyen nyunaki obi nyutob, Enyen douk ta nyiyabigesh agundok atapishi arpesh um yoweishi inahos douk eshesh madae shudukemesh uwe aria shape shenekesh um. Shopunek ta nyuwormesh baugos nyiyabigesh yopuhi aih huni agundok Iruhin ta nunekemesh debeinyi baraen um shenek yoweishi inahos um. ");
INSERT INTO apec_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Enyen douk ta nyiyabig arpesh aria shudukemesh um eshesh douk shenek yoweishi inahos. Um maresh? Eshesh madae shunek bilip um eik um uwe. ");
INSERT INTO apec_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Aria Enyen nyuwormesh baugos nyiyabigesh yopihi aih. Umum maresh? Eik ta inak itik eikin Yain aria ipak ta mare watak putiwe uwe, uwok. ");
INSERT INTO apec_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Aria Enyen ta nyunaki nyiyabigesh um agundok Iruhin ta nunekumesh debeinyi baraen um esheshish yoweishi inahos. Aria shudukemesh um eshesh yoweishi arpesh. Um maresh? Iruhin douk nenekuman debeiti kwot Satan douk debeini um enenyenen um ahudok atapih aih iri. ");
INSERT INTO apec_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Eik sabainyi baraen douk yakri ikripepumen iri. Aria douk ta ikripep aria ta mare pudukemen uwe, uwok. Namudok aria ta mare ikripep. ");
INSERT INTO apec_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Aria abudok nyutob enyudok Iruhin ananin Mishin douk nyeyagwreh adurin atin iri nyunaki obi nyutob, Enyen ta nyiyabigep aria pudukem ihinyumori adurinyi baraen. Enyen ta nyunaki aria ta mare nyuwereh enyen atin aria nyiyagwreh enen baraen um enyen kanak uwe, uwok. Aria ta nyukripep enyudok baraen douk nyemnek Iruhin nakriyen iri. Aria ta nyukripep um eshudok ta kweipon shutogur iri. ");
INSERT INTO apec_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Enyen douk ta adur nyutuk eikin nyeigur nyuto iruhw um agundok nyiraouri eikin baraen nyunaki nyukripep um. ");
INSERT INTO apec_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Eneshenesh eikin Yain nagremesh iri douk eikishi atish. Namudok aria douk yakripep yakri Iruhin ananin Mishin ta nyukripep baraen douk nyemnek eik yakripen um. ");
INSERT INTO apec_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“Banab nyutob meyoh aria ipak ta mare watak putrue uwe, uwok. Inakuk aria ta mare roubi um aria ta watak itanamori putiwe.” ");
INSERT INTO apec_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Namudok aria anam ananim um disaipel hatanam hanasorim um hakri, “Baugenyum enyudok baraen um nakri banab nyutob meyoh apak ta mare watak mutrun aria mare roubi um ta watak nutanamori mutrun um douk nyakri maresh? Aria shopunek nakri apak ta mare mutrun. Um maresh? Anan douk ta nunak nutik ananin Yaken.” ");
INSERT INTO apec_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Amam hape hanasorim hakri, “Baugenyum enyudok baraen um nakri banab nyutob meyoh um douk adur nyakri maresh? Apak madae mudukemen uwe, uwok.” ");
INSERT INTO apec_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Jisas natrum aria nadukemesh um amam douk hakri horigan. Namudok aria nakripam nakri, “Eik douk yakri, ‘Banab nyutob meyoh ipak ta mare watak putiwe, uwok. Aria ta mare roubum aria ta watak itanamori putiwe.’ Ipak douk pape panasosorim um pakri pudukem baugenyum enyudok baraen eik yakriyen iri aka, uwok? ");
INSERT INTO apec_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Adur atin yakripep. Ipak ta aparuh yoweruh pureh punokwukri atin um ehudok yoweihi aih shenekeh um eik. Aria arpesh shapeum shagipesh atapih yoweihi aih iri ta shunadudareh. Ipak ta aparuh yoweruh, aria agundok aparuh yoweruh um ta wata hunak huwishuk aria ta watak punadudareh puriguk abom. ");
INSERT INTO apec_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Abudok nyutob onok armatok kwupe kwabirak um kwubanuh kubuki batowin obi nyutob, okwokwihw apahw douk yowehw. Um maresh? Okwokwib nyutob um kumnek eriger um douk batogur. Aria abudok nyutob okwok kwubanuhuk kubuki batowin um jurug, aria okwokwim urkum ta mare watak mur um arudok eriger uwe, uwok. Um maresh? Okwok douk kwabanuh kwobuki batowin nyatogur nyape agundok atap aria kwanadudareh. ");
INSERT INTO apec_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Aria ipak douk namudok atin. Douk abudok nyutob ipakib um ipakish mishish yowesh um. Aria eik ta watak itanamori itrip aria ipakiruh aparuh ta wata adur um hupe wosik aria punadudareh abom. Aria ta mare enesh arpesh shunaki shukri uwok um agundok ipak ta punadudareh puriguk um uwe, uwok. ");
INSERT INTO apec_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Abudok nyutob bukri butogur obi nyutob, ipak ta mare porige enen baraen uwe, uwok. Adur atin yakripep. Eikin Yain ta nukep maresh eneshenesh eshudok ipak porigan um nukepesh um eikin nyeigur iri. ");
INSERT INTO apec_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Riguk arigaha douk, ipak douk madae porig Iruhin um nukep enesh eshudok um eikin nyeigur uwe, watak. Ipak douk porigan um, aria ta nukepesh. Namudok aria ipak ta punadudareh puriguk abom.” ");
INSERT INTO apec_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Douk enyudok sabainyi baraen douk eik yape yakripepen wobuwobren atin. Aria nyutob ta butogur um eik ta mare watak ikripep wobuwobren um uwe, uwok. Aria ta watak adur iwerehenyumep aria ikripep um eikin Yain um pudukeman wosik. ");
INSERT INTO apec_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Aria abudok nyutob bukri butogurum, ipak kanak ta punek beten porig eikin Yain um eikin nyeigur. Eik douk mare ikripep um eik kanak ta iyorik Yain um ta nutaurumep uwe, uwok. ");
INSERT INTO apec_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Um maresh? Eikin Yain anan kanak douk urkum ma