﻿USE sofia;
DROP TABLE IF EXISTS sofia.apeB_vpl;
CREATE TABLE apeB_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES apeB_vpl WRITE;
INSERT INTO apeB_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Jisas Krais ananich popech yamech echechiguh yeguh douk oguhudak: Jisas ananinu yamenu Devit. Devit ananinu yamenu Ebraham. ");
INSERT INTO apeB_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Ebraham ananinu nuganinu Aisak. Aisak ananinu nuganinu Jekop. Ali Jekop douk nololi Juda nanu ananim owahlim. ");
INSERT INTO apeB_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Juda nololi Peres nanu Sira. Amamik mamakik douk Tema. Peres ananinu nuganinu Hesron. Hesron ananinu nuganinu Ram. ");
INSERT INTO apeB_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ram ananinu nuganinu Aminadap. Aminadap ananinu nuganinu Nason. Nason ananinu nuganinu Salmon. ");
INSERT INTO apeB_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmon ananinu nuganinu Boas. Boas ananik mamakik douk Rehap. Boas ananinu nuganinu Obet. Obet ananik mamakik Rut. Obet ananinu nuganinu Jesi. ");
INSERT INTO apeB_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Jesi ananinu nuganinu douk king Devit. Devit ananinu nuganinu douk Solomon. Solomon ananik mamakik douk susubati Yuraia nalik nahwok uli. ");
INSERT INTO apeB_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomon ananinu nuganinu Riaboam. Riaboam ananinu nuganinu Abaisa. Abaisa ananinu nuganinu Esa. ");
INSERT INTO apeB_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Esa ananinu nuganinu Jehosafat. Jehosafat ananinu nuganinu Joram. Joram ananinu nuganinu Asaia. ");
INSERT INTO apeB_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Asaia ananinu nuganinu Jotam. Jotam ananinu nuganinu Ehas. Ehas ananinu nuganinu Hesekaia. ");
INSERT INTO apeB_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hesekaia ananinu nuganinu Manasa. Manasa ananinu nuganinu Emos. Emos ananinu nuganinu Josaia. ");
INSERT INTO apeB_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josaia ananim nugamim douk Jekonaia nanu ananim owahlim. Ababuk nyultab amam haitak abali, echech Babilon douk chanaki chowechik echech Isrel chalawech chanak chenek kalabus chape Babilon. ");
INSERT INTO apeB_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Chanak chonowechik chape Babilon ali Jekonaia nololi Sialtiel. Sialtiel ananinu nuganinu douk Serababel. ");
INSERT INTO apeB_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Serababel ananinu nuganinu Abiut. Abiut ananinu nuganinu Elaiakim. Elaiakim ananinu nuganinu Eso. ");
INSERT INTO apeB_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Eso ananinu nuganinu Sedok. Sedok ananinu nuganinu Ekim. Ekim ananinu nuganinu Elaiat. ");
INSERT INTO apeB_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Elaiat ananinu nuganinu Eleasa. Eleasa ananinu nuganinu Matan. Matan ananinu nuganinu Jekop. ");
INSERT INTO apeB_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jekop ananinu nuganinu Josep. Ali Josep douk nasuh Maria ali kwololi Jisas douk chohwalanamu Krais uli. Anan douk anudak alman douk God natalihanu ali nakaganu nanamali nunolau elpech uli. ");
INSERT INTO apeB_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Namudak ali chadalehi lainab elpech douk chapeli Ebraham napenyubali nyultab aliga chanaki chatoglomali Devit naitak abali nyultab umu douk banak batoglu 14-poleib. Wata chopuk chadalehabi Devit napenyubali nyultab aliga chanak chatoglomali abudak nyultab echech Babilon chanaki chalau echech Isrel chanak chowechikech chape Babilon abali douk chopuk chadalehab banak batoglu 14-poleib. Wata chopuk chadalehabi abudak nyultab chabih chape Babilon abali aliga chanak chatoglolimu Krais naitak abali nyultab umu douk chopuk namudak ati, chadalehab banak batoglu 14-poleib. ");
INSERT INTO apeB_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Jisas Krais naitak umu douk namudak. Ananik mamakik Maria douk chasonukok umu Josep. Echech douk watak chunosupu e ali God ananin Michin nyanaki nyawichok ali chatik umu okwok douk apahwik. ");
INSERT INTO apeB_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Okwokwinu alaminu Josep douk nanubu duldulinali alman. Namudak ali anan douk nakli wak umu nuklipu enech elpech nukli okwok douk kwasonukeh kipainali ali nunekok kulau ablan namudak, wak. Namudak ali ulkum molomu anan atunu umu nakli nukogok kunakuk meyoh. ");
INSERT INTO apeB_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Josep douk watak nape nanabuk ulkum umu enyudak ali nechuh nonobek anas yomnis. Asudak yomnis douk natik enen Diginali ananin ensel nyatoglomanu ali nyaklipanu nyakli, “Josep, Devit ananinu yamenu, nyak kobi elgeinyamu nyulau Maria kutaglu nyakik almatok, wak. Mnek! Diginali ananin Michin nyanaki nyawichok ali okwok dakio apahwik. ");
INSERT INTO apeB_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Okwok douk eke kulali ananu nuganinu ali nyak nyunubu nyubukumanu yeul Jisas. Umu monoken, anan douk eke nugakamu elpech chutukemaguk yowenyi ali chutanamali chupe kalbu.” ");
INSERT INTO apeB_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Enyudak nyanatimaguk douk nyatoglomu enen balan seiwak God nohul ananu profet neyagwlehen uli nyutoglu adulin atin. Balan enyudak. ");
INSERT INTO apeB_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Nakli, “Aipo mnek! Onok yanpoleikwi almatok douk alman wo kwunu ananu chichuh uli e eke apahwik ali eke kulali ananu nuganinu. Ali eke chubukumanu yeul Emanyuel.” Bawogen umu enyudak yeul douk nyakli, “God nanopu mape.” ");
INSERT INTO apeB_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Douk Josep nechuh umu aliga naitak ali nagipech enyudak balan douk Diginali ananin ensel nyaklipanaguk umu. Ali natukulmu Maria chanamu ananigu awagu ali kwatoglu ananik almatok. ");
INSERT INTO apeB_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Wakuli anan douk wo nunok chichuh o chulahe atugun ati e aliga kwatas kwolu nuganinu. Ali nobukumanu yeul Jisas. ");
INSERT INTO apeB_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Maria kwolu Jisas abuldak wabul Betlehem. Ababul douk blape enyudak provins Judia. Ali ababuk nyultab, Herot douk nenek king nape nebenalimu Judia. Maria kwolu Jisas aliga anabu nyultab anam hadukemu enechi enech uli hapeli gani aun nakihumali hanaki hatogloli Jerusalem. ");
INSERT INTO apeB_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Hanaki ali hasalikech hakli, “Anudak nuganinu douk eke nutoglu ipak Juda ipakinu king uli, mamakik douk kwonololi agnumu? Apak douk matiki ananik unuk gani aun nakihumali ali douk manakumali munek lotumanu.” ");
INSERT INTO apeB_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Douk king Herot nemnek namudak ali nanubu elgeinu. Chanatimaguk elpech chape Jerusalem uli chopuk elgeich. ");
INSERT INTO apeB_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Ali nenekumom balan hanatimaguk amam pris amamim nebemi hanu amudak anam henek skulumech umu lo uli hanaki hatulunu. Hanaki ali nasalikam nakli, “Anudak alman Krais douk God eke nutalihanu ali nukaganu nunakumali nunolau elpech uli eke nitak meibuli wabul?” ");
INSERT INTO apeB_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Ali haklipanu hakli, “Mamakik eke kunololi wabul Betlehem douk blape enyudak provins Judia uli. Seiwak ananu profet nowemaguk balan ali nyakli namudak. Nyakli, ");
INSERT INTO apeB_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Ipak pape abuldak wabul Betlehem douk blape enyudak provins Judia uli, ipak pumnek. Ipak douk wo punubu yeul wakepu ali kipailubi walubimi ipak Juda hupe ipakim nebemi hunek bosimepu e, wak. Ananu nebenali alman eke nitak ipak elpech pape Betlehem uli. Ali anan douk eke nupe nebenalimu ipak yekipu elpech Isrel.’” ");
INSERT INTO apeB_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Herot nemnek namudak ali nonobechuk nenekumom balan amudak douk hapeli aun nakihumali hanakili. Nenekumom balan ali hanak hatulunu. Hanaki ali nasalikam umu hugamu huklipanu duldul umu abudak nyultab hatik okudak unuk kwatoglu kwapemu. ");
INSERT INTO apeB_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Douk haklipanu heyaten ali naklipam namudak. Nakli, “Punak ali chokubul ati pupe pulimu anudak nuganinu. Douk aliga pugwatanu ali wata putanamali puklipe. Umu yek chopuk inak inek lotumanu.” ");
INSERT INTO apeB_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Douk hemnek king ananin balan ali hatukemanaguk hanak. Hanak yah ali wata hatik okudak otuk unuk douk halik hatulukwi gani aun nakihumali uli. Okwok kwalik ati ali amam hagipechok aliga kwanak kwotemu chihah anudak nuganinu nechuh atali wilpat. ");
INSERT INTO apeB_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Amam hatik okudak unuk ali hanubu henehilau halikuk. ");
INSERT INTO apeB_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Aliga douk hanak hawich atudak wilpat ali hatik nuganinu nanu mamakik Maria chape. Ali habih hoduk ohlubus hatau atap henek lotumanu. Ali hejik amamis paus hatuki echudak hatalichi nebebali utabal uli hakanu. Hakanu gol lanu paura nyeih yopuli yabil douk chohwaklen umu frankinsens uli chanu enen yopinyi sanda yeulinyumu mer. ");
INSERT INTO apeB_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Hakanu echudak ali hechuh agnabuk Betlehem. Hechuh honobek anas yomnis ali God naklipam dodogowinyi balan umu kobi wata hutanamu hunak hutikuk Herot, wak. Namudak ali hagipech kipaihi yah hatanamu hanamu amamin kantri. ");
INSERT INTO apeB_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Douk amudak biom atunu hanakuk ali Josep nechuh nonobek anas yomnis. Ali enen Diginali ananin ensel nyatoglomanu ali nyaklipanu nyakli, “Nyitak nyutukulmu nuganinu nunu mamakik ali pulhwas punamu enyudak kantri Isip. Punak pupe agnabuk aliga yek wata iklipepu ali dakio wata putanamali. Umu monoken, Herot douk eke nupe nulimu nuganinamu nonu nugak.” ");
INSERT INTO apeB_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Namudak ali Josep naitak natukulmu nuganinu nanu mamakik ali ababuk atub wab chape chanamu Isip. ");
INSERT INTO apeB_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Chabih chape agnabuk aliga Herot nagak. Enyudak douk nyatoglomu enen balan seiwak Diginali nohul ananu profet neyagwlehenyuk uli nyutoglu adulin atin. Balan enyudak. God nakli, “Yek yohwalu yekinu Nuganinu natukemaguk Isip nanaki.” ");
INSERT INTO apeB_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Herot nape ali nadukemech umu amudak hapeli aun nakihumali hanakili douk halaugamanu hanak kipaihi yah. Namudak ali ananihw apahw hwanubu nyihihichihw. Ali nakagas anam soldia hanamu Betlehem blanu walub blapeli halakatimu Betlehem uli umu hubo hunatimaguk chokumi nugamim hugak. Hubo amabuk douk biech o atin ati yohleguh chadiyom uli atum. Umu monoken, amam hadukemech uli douk haklipanu hakli abudak nyultab hatik unuk umu, nameitu douk ati abiech yohleguh chadi. ");
INSERT INTO apeB_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Enyudak douk nyatoglomu enen balan seiwak God nohul profet Jeremaia neyagwlehenyuk uli nyutoglu adulin atin. Balan enyudak. Nakli, ");
INSERT INTO apeB_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Chemnek anagu nigu abuldak wabul Rama. Chemnek onok almatok kwoleh chukeich chak badag ati kwanak. Resel kwape kwolepu okwokwim nugamim. Kwoleh ali eke kobi enen elpen nyunokwnumu nyugabechumok apahw kusak, wak. Umu monoken, okwokwim nugamim douk hagak hatuh.” ");
INSERT INTO apeB_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Aliga douk Herot nagakuk ali Josep nonobek anas yomnis gani Isip. Enen Diginali ananin ensel douk nyonohul ali nyaklipanu namudak. ");
INSERT INTO apeB_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Nyakli, “Nyitak nyutukulmu nuganinu nunu ananik mamakik ali wata putanamu punamu Isrel. Amabuk douk haklimu hubo nuganinu nugak uli douk ahagak.” ");
INSERT INTO apeB_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Namudak ali Josep naitak natukulmu nuganinu nanu ananik mamakik ali wata chatanamu chanamu Isrel. ");
INSERT INTO apeB_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Chanak wakuli Josep nemnek balan umu chakli Akeleas nalau ananinu aninu Herot ananik outuk natoglu king nape nebenalimu enyebuk provins Judia. Namudak ali Josep wata elgeinamu nunamu Judia umu. Aliga douk wata nonobek anas alagun yomnis ali God naklipanu enen balan alagun. Namudak ali chanamu enyudak provins yeulinyumu Galili. ");
INSERT INTO apeB_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Chanak ali chabih chape anabul wabul chohwalabul umu Nasaret uli. Namudak ali enen balan seiwak amam profet henyemaguk uli nyatoglu adulin atin. Balan enyudak. “Anan douk eke chuhwalanu ananu Nasaret.” ");
INSERT INTO apeB_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Abudak nyultab Josep nanu almatok uli nuganinu chanak chape Nasaret abali, anudak Jon nenek baptaisumech uli douk naitak nape naklipech God ananin balan. Elpech chanak ali nape naklipechen enyudak provins Judia agundak wohigunmu elpech wak umu. ");
INSERT INTO apeB_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Naklipech namudak. Nakli, “Ipak apukenyuk agabus yowenyi ali putanamu pukanu apaluh God. Umu monoken, abudak nyultab umu elpech chuwich umu agundak God nupe nebenalimu ananich elpech umu douk ahalakatimu eke butoglu.” ");
INSERT INTO apeB_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Jon anan douk anudak alman seiwak God nohul profet Aisaia neyagwlehuk enen balan nyakliyanali. Balan enyudak. Nakli, “Enen elpen nyape nyohwalu gani wohigunmu elpech wak umu. Nyohwalu nyakli, ‘Gapechumanu yah Diginali. Pugapechah hupe duldul umu anan nugimah nunakimu.’” ");
INSERT INTO apeB_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Jon nenekah uli lupah douk chenekah enen mahin chohwalen umu kamel uli enyenyilub ahilub. Let natasak uli douk chenekatu enen mahinyip benyip. Kakwich nachah uli douk napemu nawak chulpib uli wanalin hani. ");
INSERT INTO apeB_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Ali ababuk nyultab elpech chapeli Jerusalem uli, chapeli blanatimaguk walub enyudak provins Judia uli, chapeli ihalub walub blape halakatimu wolub Jodan uli, wolobaichi chanakimu chumnek Jon. ");
INSERT INTO apeB_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Chanaki chowoleh cheneken uli yowenyi ali nenek baptaisumech abudak wolub Jodan. ");
INSERT INTO apeB_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Jon natik wolobaimi Farisi hanu Sadyusi hanamali hutulunamu nunek baptaisumam ali naklipam nakli, “Iwe oguhudak iguh! God anan douk nanubu nyihihichi-namu ipak. Omuni nyaklipepamu deke wosik pulhwasumaguk enyudak yowenyi douk nakli nuneken nyutoglomu ipak uli? ");
INSERT INTO apeB_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Ipak douk punek yopinyi atin pasin umu kipahechi chutulipu chukli ipak adul apekenyuk agabus yowenyi ali patanomu pokanu apaluh God. ");
INSERT INTO apeB_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Kobi punobuk ulkwip pukli Ebraham anan douk ipakinu yamenu ali God eke kobi nepu. Kobi pukli namobuk, wak. Yaklipepu, God anan deke nuhul abaludak utabal ali nubalanamu blutoglu Ebraham ananich yamech. ");
INSERT INTO apeB_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Tameyok douk akwakus kwatik bawogasigas umu lowas. Sanatimaguk lowas douk wo yopipi chulkwip pil umu e, agagas douk eke sunotaki sunowachak nyih hunugas. ");
INSERT INTO apeB_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Yek douk yenek baptaisumepu abal kobi anagu mak umu agundak apekenyuk agabus yowenyi ali patanomu pokanu apaluh God umu. Wakuli anudak douk eke nugimali yek uli, anan douk eke nunek baptaisumepu nipouh God ananin Michin. Eke nukepeyen nyuwich nyupenyipu ali nyugabeyepu kobi nyih hanuk echudak umu. Ali Anan douk nanubu dodogowinu atunu nechalakuk yek. Yek douk wo yopuwelimu isuhumanu ananiyu su meyoh e, wak. ");
INSERT INTO apeB_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Anan douk nanaki kobi ananu alman nasuhi ananil savol ananis wis umu eke nunaki niyomoguk tanatimaguk aliguhitamu wit douk tolomu ouguhitu wit uli. Ouguhitamu eke nunatalmotu nutobuk wilpat douk nobuk wit atali. Wakuli aliguhitamu eke nutowehuk nyih douk hanu hape namudak ali wo hugak atili e.” ");
INSERT INTO apeB_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Ali ababuk nyultab Jon nape nenek baptaisumech abali, Jisas naitak natukemaguk enyudak provins Galili nanamu Jodan wolub umu nutik Jon nunouh. ");
INSERT INTO apeB_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Wakuli Jon nakli wak umu nunek baptaisumanu ali naklipanu nakli, “Nyak nyenek baptais umu yek ele, deke kalbu. Wakuli enyudak douk wata nyanamali yek umu yek inek baptaisumenyu?” ");
INSERT INTO apeB_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Wakuli Jisas nebemanu balan namudak. Nakli, “Anyenekech. Nameitu nyak wosik nyunek baptaisume kobi yek yaklimu. Nyunek namudak ali ohwak eke wuneken wiyaten ihenyumali God naklienyi yopinyi pasin.” Namudak ali Jon gulogolonamu nunek baptaisumanu. ");
INSERT INTO apeB_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Douk Jon nenek baptaisumanu julug, ali nanubu natukemaguk abal nalto buknap. Nakih ali ahudak atuh natik umu iluh utagu genek op ali natik God ananin Michin nyagluki kobi enyudak almin manyun umu nyabihi nyape Jisas. ");
INSERT INTO apeB_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Ali anagu nigu ganaki iluh heven ali enyudak elpen nyakli, “Anudak douk nanubu yekinu Nuganinu. Yek douk ulkum manahwanu ali yanubu yenehilau-manu.” ");
INSERT INTO apeB_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Douk Jisas nenek baptais umu julug, ali nagipech God ananin Michin nyalawonamu wohigunmu elpech wak umu. Nanak agnabuk umu Satan nichakamanamu nunek yowenyi. ");
INSERT INTO apeB_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Nanak nenek tabumu kakwich nape meyoh umu ananu aun chukninu, 10-poleih nyumneh. Aliga ali takweilubi nyulub blanu. ");
INSERT INTO apeB_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Ali Satan nanaki naklipanu nakli, “Sapos nyak God ananinu Nuganinamu, nyak klipu abaludak utabal blutoglu bret.” ");
INSERT INTO apeB_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Wakuli Jisas nebemanu balan nakli, “Balan nyetemu God ananik buk uli douk nyakli, ‘Kakwich atich deke kobi chugakamu enech elpech umu chupe kalbu, wak. Elpech douk chopuk i save chape kalbamu agundak chasuh nyanatimaguk God neyagwlehenyi balan chagipechen umu.’” ");
INSERT INTO apeB_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Ali Satan wata nalawonamu yopubuli wabul Jerusalem. Ali nakih nonowemu neyotu chihah onok kwanubu kwakihuk uli outuk atudak God Ananitu nebetali wilpat. ");
INSERT INTO apeB_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Ali Satan naklipanu nakli, “Sapos nyak God ananinu Nuganinamu, douk nyunotoblig nyugluk atap. Umu monoken, balan nyetemu God ananik buk uli nyakli, ‘God eke nuklipech dodogowinyi balan ananich enselahas chunaki chugakomenyu ali eke chuhwenyoguk iluh echechis wis. Namudak ali eke kobi anam utam muwolinyu nyakiluh yoliluh, wak.’” ");
INSERT INTO apeB_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Ali Jisas naklipanu nakli, “Balan nyetemu God ananik buk uli douk chopuk nyakli, ‘Nyak kobi nyichakamu Diginali nyakinu God.’” ");
INSERT INTO apeB_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Ali Satan wata nalawanu nalto ananu nanubu nakihuk uli maunten. Hakih ali nagilapanu nyanatimaguk kantri nyape apudak atap uli nyanu enechi enech chanubu yopichi echudak douk chapenyugun uli. ");
INSERT INTO apeB_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Ali naklipanu nakli, “Nameitu sapos nyak nyuduk ohlubus nyunek lotumemu, chanatimaguk echudak eke ikenyeyech nyakich atich.” ");
INSERT INTO apeB_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Ali Jisas nebemanu balan Satan nakli, “Satan, nubu kaleik! Balan nyetemu God ananik buk uli douk nyakli, ‘Nyak nyunek lotumu Diginali nyakinu God ali nyusuh ananin atin moul.’” ");
INSERT INTO apeB_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Naklipanu namudak ali Satan natukemanaguk nanak. Ali enech enselahas chanaki chagakomu Jisas. ");
INSERT INTO apeB_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Abudak nyultab Jisas nemnek umu chowechik Jon nape haus kalabus ali naitak natanomu nanamu enyudak provins Galili. ");
INSERT INTO apeB_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Nanamu ananibul wabul Nasaret ali wata natukemobuluk nanak nape kipaibuli yeulibulmu Kapaneam. Abuldak wabul douk blape algasin umu nebenyi raunwara Galili halakatimu enyudak bien distrik: Sebyulun uli Naptalai. ");
INSERT INTO apeB_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Jisas nenek namudak umu enen balan seiwak God nohul profet Aisaia neyagwlehenyuk uli nyatoglu adulin atin. ");
INSERT INTO apeB_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Balan enyudak. Nakli, “Nebebi amnab Sebyulun uli nebebi amnab Naptalai, abudak amnab douk bape halakatimu nebehi yah hanamu yous gwanu amnab douk bape gani woblabu wolub Jodan uli, abudak amnab douk Galili. Agundak wolobaichi elpech douk echech wo Juda uli e chopuk chanaki chapemu. ");
INSERT INTO apeB_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Elpech chape yomotokweh uli douk achatik anatu nebetali lait taglak. Echebuk douk chape yomotokwehibi amnab uli, atudak lait douk ataglakumech.” ");
INSERT INTO apeB_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Ali ababuk nyultab, Jisas anape naklipech balan nakli, “Ipak pukenyuk agabus yowenyi ali putanamu pukanu apaluh God. Umu monoken, abudak nyultab umu elpech chuwich umu agundak God nape nebenalimu ananich elpech umu douk ahalakatimu eke butoglu.” ");
INSERT INTO apeB_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Anah nyumnah Jisas nape nalahe nanak algasin umu nebenyi raunwara Galili ali natik biom sanyowan. Ananu douk Saimon. Kipainyi yeul chohwalanamu Pita. Anan nanu ananinu owaninu Andru. Amam douk hape howachak umben raunwara henek bisnis umu hatuk yeguh. ");
INSERT INTO apeB_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Douk natulumu ali naklipam nakli, “Ipak yowi pugipech yek ali eke igilapepamu pulau elpech chunaki chugipech yek.” ");
INSERT INTO apeB_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Douk hemnek ati hanubu hatukemaguk amamib umbenab bakusuk ali habihi hagipech Jisas hanak. ");
INSERT INTO apeB_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Natukemaguk agnabuk nanaku wakuli wata natiku kipaimi sanyowan, Jems uli Jon. Amam douk Sebedi ananaim nugamim ali douk hanu amaminu aninu Sebedi hetemu bot hape gibe gabe amamib umbenab. Jisas natulumu ali nahwalom umu hugipechanu. ");
INSERT INTO apeB_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Nohwalomu ali ahudak atuh hatukemaguk bot tanu amaminu aninu napeik, ali haitak hanamanu hanak. ");
INSERT INTO apeB_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Jisas nalahe nanak ihalub walub enyudak provins Galili. Nanak nawich agundak echech Juda chautubal chape cheyagwleh-ogwi wilag ali nape naklipech God ananin yopinyi balan. Naklipech umu agundak eke chuwich umu agundak God nape nebenalimu ananich elpech umu. Naklipech balan ali nagapech chanatimaguk elpech douk ganubu yowegali agudak genekech uli chanu echebuk douk agudak meyoh genekech uli ali yopich. ");
INSERT INTO apeB_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Ali balan nyoweyeh nyanak nyeyatak enyudak provins Siria, umu enyudak Jisas neneken uli moul. Namudak ali chalawali chanatimaguk anagali anagu yowegali agudak genekech uli umu Jisas. Chalawali chalau nebehi nyih uli, sagabehas chapenyich uli, owotog gwechul uli, yegechiweluh hlagak wo kwalowi chulahe atili e. Chalawechumali Jisas ali nagabeyech chanatimaguk yopich. ");
INSERT INTO apeB_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Ali chanubu wolobaichi elpech chagipechanu chanak. Echech douk chanaki albudak walub blanu provins. Chanaki Galili, Jerusalem uli Judia. Enech douk chapeli gani woblahahibamu wolub Jodan chanaki. Ali enech douk chanaki enen distrik douk 10-poleilub walub blapemu. ");
INSERT INTO apeB_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Jisas natik echudak chanubu wolobaichi elpech chanaki ali nanak nalto anatu nukut. Nakih nape ali ananich chagipech anan uli chanaki chananu chape. ");
INSERT INTO apeB_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","3","Ali Jisas anohul yokwatu nape naklipech enyudak balan: Nakli, “Echebuk elpech douk chadukemech umu echechich michich chanahwagagun umu enenyi enen God ananin yopinyi ali chakli God nugakomech uli, echech wosik chunehilau. Umu monoken, echech eke chuwich agundak God nape nebenalimu ananich elpech umu ali chupe kalbu. ");
INSERT INTO apeB_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Echebuk elpech douk echechiluh apaluh yoweluh wo chunehilawamu yowenyi echech cheneken uli ali chukli kobi wata chuneken umu, echech wosik chunehilau. Umu monoken, God eke wata nugabemech apaluh ali eke wata nunekech chunehilau. ");
INSERT INTO apeB_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Echebuk elpech douk chape naleich ali wo chutuk echechich yeguh uli e, echech wosik chunehilau. Umu monoken, God eke nukech enechi enech yopichi echudak chunoglemech. ");
INSERT INTO apeB_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Elpech douk chunubu ulkwip pulomu chunek enenyi enen God naklienyi duldulinyi pasin kobi nyulub blabo elpech ali chanubu chakli chuwak woligun umu o abal blagahegech chakli chuwak abal umu, echech wosik chunehilau. Umu monoken, God eke nugakomech chunubu chunek yopinyi atin. ");
INSERT INTO apeB_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Echebuk douk chunelek kipahechi ali chugakomech uli, echech wosik chunehilau. Umu monoken, God eke wata nunelekech nugakomech namobuk ati. ");
INSERT INTO apeB_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Echebuk douk echechiluh apaluh hlanubu yopu-yopuluh ulkwip wo pulomu enenyi enen yowenyili e, echech wosik chunehilau. Umu monoken, echech eke chutik God. ");
INSERT INTO apeB_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Echebuk douk chapemu chagakomu elpech umu chupe atugun ali kobi chulpak chuhlitak uli, echech wosik chunehilau. Umu monoken, God eke nuhwalech ananich batowich. ");
INSERT INTO apeB_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Echebuk douk chunek God naklienyi yopinyi ali namudak dakio kipahechi chunekech anagu anagamu, echech wosik chunehilau. Echech douk eke chuwich agundak God nape nebenalimu ananich elpech umu. ");
INSERT INTO apeB_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Chukli chutulipamu pugipech yek ali namudak dakio chuhepu chunekepu anagu anagu chichopokepu enenyi enen lohwotuhwin yowenyi balan umu, ipak wosik punehilau. ");
INSERT INTO apeB_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Amam profet seiwak haliki ipak uli douk chenekom anagu anagu namudak ati. Namudak ali ipak wosik punogudupehuk ulkutog punehilau. Ipakich yopichi echudak douk chakusumepu iluh heven. ");
INSERT INTO apeB_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Jisas balan nyeilen nakli, “Ipak douk pape kobi sol umu pugakomu apudak atapichi elpech. Wakuli sapos alal wata jebiyail umu, yah douk wak anah e umu wata chunekal wichusil umu. Alal douk ayowel ali eke chukwleyoluk umu chulahe chichal. ");
INSERT INTO apeB_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Ipak douk kobi lait umu chanatimaguk apudak atapichi elpech chunotulugun umu. Anabul nebebuli wabul douk choblahu iluh anatu nukut uli eke kobi blunobechukuk, wak. ");
INSERT INTO apeB_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Ali douk chopuk, wak enen elpen nyuhemu enen lam ali wata nyitak nyupakwilen anatu baket e, wak. Wakuli enyen douk eke nyuhemen ali nyinyemu nyutemu chihah tebol umu chape numun wilpat uli chunotulugun. ");
INSERT INTO apeB_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Ali ipak douk pape namudak ati kobi hanu enen lam nyaglak umu. Pupemu punek yopinyi elpech chutulin ali eke chutuk ipakinu Aninu nape iluh heven uli ananin yeul nyukih.” ");
INSERT INTO apeB_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Jisas balan nyeilen ali nakli, “Ipak kobi punobuk ulkwip pukli yek douk yanamali ichagi God ananin lo douk seiwak naklipu Moses nenyemoluli nyanu enyudak balan douk amam profet haklipechuk enyi, wak. Wakuli yek douk yanamali inek enyudak balan douk lo nyanu amam profet amamin balan nyaklimu eke nyutogloluli nyutoglu adulin atin. ");
INSERT INTO apeB_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Adul ati yaklipepu. Enyudak balan nyape lo uli eke kobi anagun muduk behlobigun gnunak gnuwichuk, wak. Eke nyunubu nyupe namudak ati aliga utagaluli apudak atap bulkwolech. Eke nyunubu kobi anagun muduk mak meyoh gnape balan uli gnunak gnuwichuk, wak. Eke nyupe namudak ati aliga ihenyumali God naklien uli nyutoglu nyutuh. ");
INSERT INTO apeB_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Namudak ali enyebuk elpen douk nyukli nyublo anagun muduk umu enyudak lo douk gnape gnagikuk uli ali nyunek lain umu kipahechimu chunek namudak atili, enyebuk elpen eke yeul waken kwali nyuwich agundak God ananich elpech chapemu. Wakuli elpen douk nyugipech lo ali nyunek lain umu elpech umu chugipechen uli, enyen douk eke yeul nyukihen kwali enyen nyuwich agundak God ananich elpech chapemu. ");
INSERT INTO apeB_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Ali douk yaklipepu. Sapos ipak pukli puwich agundak God ananich elpech chapemu, ipak imas punubu punek duldulin atin pasin. Puneken pichalakuk enyudak pasin douk amam Farisi hanu amudak anam henek lainumech umu lo uli heneken. ");
INSERT INTO apeB_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Jisas wata nakli, “Ipak douk apemnek umu seiwak chaklipu ipakich popech yamech umu. Balan enyudak. Chakli, ‘Kobi pubo kipahechi chugak, wak. Echebuk douk chubo kipahechi chugak uli imas chiyotumu kwotog.’ ");
INSERT INTO apeB_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Wakuli nameitu douk yaklipepu. Echebuk douk nyihihichich meyoh umu enech echechichi elpech uli, kipaichi imas chunek kwot umu echebuk elpech. Echebuk douk chuhwalu enech echechichi elpech yowechili, echebuk elpech imas chulawech umu amam nebemi almom hape hasuh kwotog uli hapemu ali chunemech kwotog. Ali chopuk, echebuk douk chuhwalu enech echechichi elpech chagugaku uli, echebuk elpech imas chunamu yowebuli wabul hel. ");
INSERT INTO apeB_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Namudak ali sapos ipak punak piyotu huluk umu alta umu pukli puwemu enech echudak punek ofamech puku God, wakuli ababuk nyultab ipak ulkwip pulomoguk enen balan nyapenyipamu punu enech ipakichi pugapechen umu, orait ipak imas punek namudak. ");
INSERT INTO apeB_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","Putukemaguk echebuk pakli punek ofamech puku God uli chukusuk halakatimu enyudak alta, ali susubati putanamu punu enyudak ipakinyi elpen pugabe balan. Pugabeyen nyukus atugun ali adakio putanamu punak punek ofamu echudak puku God. ");
INSERT INTO apeB_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Sapos enech elpech chukli chunekumepu balan umu, ipak imas punek namudak. Watak pupe punak yah ali wisnabul punech pugabe balan. Wakumomu kedeke chunemepu balan umu jas ali jas eke nuklipu chusim hulawepu huwechikepu punowechik pupe haus kalabus. ");
INSERT INTO apeB_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Adul ati yaklipepu. Eke punowechik pupe aliga puwachak utabal punubu piyatabal douk amam jas haklimu putal kwot umu. Ali eke adakio hukwechihepu punak. Wak umu, eke wak. ");
INSERT INTO apeB_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Jisas balan nyeilen ali nakli, “Ipak douk apemnek umu seiwak chakli namudak. Chakli, ‘Ipak apanasupaluli kobi pusonukeh kipahemi o kipahewali, wak.’ ");
INSERT INTO apeB_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Wakuli nameitu douk yaklipepu. Meinali alman douk nutik onok almatok meyoh ali oub bitak umu nusonukehok umu, anabuk alman douk anenek yowenyi numun ananim ulkum. Enyudak douk nanubu nasonukehok okwobuk almatok. ");
INSERT INTO apeB_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Namudak ali sapos ipakis anus nabes sunek enen yowenyi ali ipak putoglu yowepalimu, ipak imas putukas puwachasuk. Sapos atup nabep pupemu, ipak eke pupe sisahw kwalowi ati. Wakuli sapos bios supe ati ali punamu yowebuli wabul umu, ipak eke punubu pupe sisahw. ");
INSERT INTO apeB_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Sapos ipakich anich loguh chunek enen yowenyi ali ipak putoglu yowepalimu, ipak imas putupech puwachechuk. Sapos atin logul nyupemu, ipak eke pupe sisahw kwalowi ati. Wakuli sapos biech chupe ati ali punamu yowebuli wabul umu, ipak eke punubu pupe sisahw. ");
INSERT INTO apeB_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Jisas balan nyeilen nakli, “Seiwak douk i save chakli, ‘Sapos ananu alman nunek julug umu ananik almatok ali nukogok kunak umu, orait anan imas nunek anap chup umu chablo marit umu ali nukokwop kuhwap kunak.’ ");
INSERT INTO apeB_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Wakuli nameitu douk yaklipepu. Sapos onok almatok wo kusonukeh kipainali alman e ali okwokwinu alaminu nukli wakok meyoh nukogok kunak umu, anudak alman douk nenek yowenyi. Nenek yowenyimu nakli wakok ali kwablo marit umu agundak sapos okwok wata kunak kusuh kipainalimu. Ali alman douk nusuh okudak almatok douk anan nakli wakok uli douk chopuk nablo marit. ");
INSERT INTO apeB_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Jisas wata nape naklipech nakli, “Ipak douk chopuk apemneken balan seiwak chaklipu ipakich popech yamech umu. Balan enyudak. Chakli, ‘Ipak kobi pulal abudak nyultab polimu iluh abali, wak. Pukli pulimu iluh umu punek enech echudak umu, ipak imas pugipech enyudak balan ali punubu puneken agundak Diginali nutulipamu.’ ");
INSERT INTO apeB_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Wakuli nameitu douk yaklipepu. Kobi pulimu iluh, wak. Ipak kobi pulimu iluh heven umu punek enen ipakin balan dodogowin, wak. Umu monoken, iluh heven agnabuk douk God ananin nebenyi sia douk nape nebenali ali nape nenek bosumapamu. ");
INSERT INTO apeB_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Ali apudak atap douk chopuk kobi pusolimop umu punek enen ipak balan nyutoglu dodogowin, wak. Umu monoken, apudak atap douk God nasapu ananigas ayas seyotu nape nebenali ali nenek bosumapamu. Chopuk wabul Jerusalem kobi pusolimobul umu punek enen balan dodogowin, wak. Umu monoken, ababul douk Nanubu Nebenali King ananibul wabul. ");
INSERT INTO apeB_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Chopuk ipak kobi pusolimu ipakip begelep umu punek enen balan nyutoglu dodogowin, wak. Umu monoken, ipak douk wo punokwnumu punek anabul ahibul blakih ipakigas balagas uli blutoglu chogolihwibul o behlabibul e, wak. ");
INSERT INTO apeB_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Wakuli ipak imas pukli adulin atin balan ali pukli: ‘Adul’ o ‘wak.’ Enyebuk enen balan puklien nyugimali enyudak uli douk nyanamali yowenali alman uli.” ");
INSERT INTO apeB_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Jisas balan nyeilen ali nakli, “Ipak douk apemnek umu seiwak chakli, ‘Sapos enen elpen nyutuken ihlub kipainyi elpen umu, enyebuk elpen imas nyudalu alab nyutuk enyenyib ihlub chopuk. O sapos enen nyudiyen nahw kipainyi elpen umu, orait enyen chopuk imas chudiyen onoh.’ ");
INSERT INTO apeB_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Wakuli nameitu douk yaklipepu. Ipak kobi wata pudalu eleb umu echebuk douk chenekumepu yowenyili, wak. Sapos enen elpen nyubo anuh nugulihw umu, nyak imas nyutanamu nyuken algahw nyohw chopuk. ");
INSERT INTO apeB_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Ali sapos enech elpech chunemepu balan umu chukli chunotulipu ipakig siyotog umu, ipak imas pukech ipakig lougwi saketog chunahwog chopuk. ");
INSERT INTO apeB_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Sapos anam almom hunolokumepamu pusahumom jah punak kwalowi lougun 1 kilomita umu, ipak douk wata puhusah punak lougun 2 kilomita. ");
INSERT INTO apeB_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Sapos enech elpech chuhwalepamu pukech enech echudak umu, ipak imas pukech. Ali chopuk sapos enech elpech chukli chunek dinaumepamu enech echudak umu, orait ipak imas pukechech.” ");
INSERT INTO apeB_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Jisas balan nyeilen nakli, “Ipak douk apemnek umu seiwak chakli namudak. Chakli, ‘Ipakip ulkwip imas punosuh ipakich bawogeich ali pukechuk agabus ipakich birua.’ ");
INSERT INTO apeB_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Wakuli nameitu douk yaklipepu. Ipakip ulkwip imas punubu punosuh ipakich birua ali imas pusolik God umu nunekumech yopinyi echebuk douk i save chunekepu anagu anagaluli. ");
INSERT INTO apeB_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Pugimah namudak ali ipakinu Aninu nape iluh heven uli eke nuhwalepu ananipu batowich. Anan douk i save nenek ananih wah hatawomu yowechi chanu yopichi elpech alagun ati. Echah douk namudak ati. Nenekah halamoli chenek yopinyi atin uli chanu echebuk douk chenek yowenyili alagun ati. ");
INSERT INTO apeB_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Sapos ipak ulkwip punosuh echebuk douk echech ulkwip panosuh ipak uli atich umu, ipak douk pakli God eke nutalipamu agundak pagimoh namobuk umu? Ati eke wak. Amam yowemi halau tagis uli chopuk hagimoh namobuk ati. ");
INSERT INTO apeB_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Ali sapos ipak punu ipakich atich elpech punenemu gudemu, enyebuk douk pakli penek monoken yopinyi pasin pecholokuk kipahechi elpech, ati wak. Echech wo chudukemu God uli e douk i save chagimoh namobuk ati. ");
INSERT INTO apeB_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Namudak ali ipak imas punubu putoglu duldulipali elpech punek yopinyi atin kobi ipakinu Aninu nape iluh heven uli nanubu nape duldulinamu.” ");
INSERT INTO apeB_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Jisas balan nyeilen ali naklipech nakli, “Ipak punenek yologi. Kobi pukli punek enenyi enen yopinyi pasin agundak elpech chasuh nabes sape umu kadak chutulinyu-mepu, wak. Pukli pugimeh namudak umu, ipakinu Aninu douk nape iluh heven uli eke kobi nubemepu ipakich yopichi echudak, wak. ");
INSERT INTO apeB_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Namudak ali sapos ipak pukli pukech enech echudak echudak wakechimu, ipak kobi yotu hwalu pukech yopugunmomu chunatimaguk tikuk ati, wak. Kobi pugimeh kobi echech chenek loh uli elpech chagimeh gani lotuwig wilag o yegwih umu, wak. Echudakmali elpech douk chakli kadak elpech chutulich ali chutuk echechich yeguh chukih. Aduligu atugu yaklipepu. Echechich yopichi echudak douk achanalawech ali julug. ");
INSERT INTO apeB_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Wakuli sapos ipak pukli pugakomu echudak wakechi elpech pukech echudak umu, ipak imas punobechuk pukech. Ipakichi elpech douk chape halakatimu ipak uli chopuk kobi chudukemech, wak. ");
INSERT INTO apeB_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Punek namudak ali eke kobi enech chudukemech, wak. Namudak ali ipakinu Aninu douk natik enyudak ipak ponobechuk peneken uli, ali eke nukepu yopichi echudak. ");
INSERT INTO apeB_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Jisas balan nyeilen nakli, “Abudak nyultab punek beten pusolik God abali, ipak kobi puneken puduk echudak douk chapemu chene loh uli i save cheneken umu, wak. Echech douk chanubu oub baitak umu chitak chiyotu numun lotuwig wilag o chunak chiyotu agundak wolobaichi elpech chalahemu ali chunek beten umu elpech chutulich. Adul ati yaklipepu. Echechich yopichi echudak douk achanalawech ali julug. ");
INSERT INTO apeB_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Wakuli abudak nyultab ipak pukli punek beten abali, ipak imas puwich ipakip lip, puwaluk duahas ali punek beten pusolik ipakinu Aninu douk wo chutulunatili e. Namudak ali ipakinu Aninu douk nape natik enyudak ipak ponobechuk peneken uli ali eke nukepu yopichi echudak. ");
INSERT INTO apeB_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Ali abudak nyultab punek beten abali, ipak kobi piyagwleh wolobainyi meyoluhin balan. Kobi puduk echech douk wo chudukemu God uli e i save chagimeh umu, wak. Echech i save chakli echechim wo adulim uli e god eke humnekech umu echechin lounyi beten. ");
INSERT INTO apeB_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Ali ipak kobi pugipech echechin pasin, wak. Ipak douk watak pusolik ipakinu Aninu e, ali anan douk anadukemu ihechumali echudak ipak wokepamu. ");
INSERT INTO apeB_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Ali punek beten umu douk puneken namudak. Pukli, ‘Apakinyu Aninu nyape iluh heven uli, apak makli chunatimaguk elpech chutuk nyakin yopinyi yeul nyukih. ");
INSERT INTO apeB_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Makli nyak nyupe nebenyalimu wolobaichi elpech. Makli nyugakamapu mugipech enenyi enen nyak nyaklienyi agundak apudak atap, douk chape iluh heven uli i save chagipechen umu. ");
INSERT INTO apeB_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Nyak nyukapu woligun gnunokwnumu doumeih uli. ");
INSERT INTO apeB_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Apak douk wo munohwen mupemu yowenyi douk kipahechi cheneken umu apak uli e wak, mokleyenyuk. Douk namudak ali nyak kobi wata nyunohwen nyupemu yowenyi apak moneken uli wak, nyukleyenyuk. ");
INSERT INTO apeB_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Nyak kobi nyukutuk Satan nichakomapamu munek yowenyi, wak. Wakuli douk nyihiyaho-noguk umu apak mupe kalbu.’ Nyak atinyu nyape nyohwalu elpech chawich agundak nyak nyape nebenyalimu nyakich elpech umu, nyanubu dodogowinyu atinyu ali wolobaichi elpech chatuk nyakin yeul nyakih eheh nyumneh, adulin. ");
INSERT INTO apeB_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Mnek. Sapos ipak kobi punosuh yowenyi douk kipahechi chenekenyumepu uli pupemu, orait ipakinu Aninu nape iluh heven uli chopuk eke nunekumepu namudak ati. Eke kobi nunosuh yowenyi douk ipak peneken uli nupe, wak. Eke nukwleyenyuk. ");
INSERT INTO apeB_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Wakuli sapos ipak punosuh yowenyi douk kipahechi chenekenyumepu uli pupemu, orait ipakinu Aninu chopuk eke nunosuh ipak peneken uli yowenyi nupe. Eke kobi nukli nukwleyenyuk, wak.” ");
INSERT INTO apeB_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Jisas wata chopuk nakli, “Ali abudak nyultab pukli punek tambumu kakwich eneh nyumneh ali pupe punek beten atin abali, ipakigas yamagas kobi yowegas, wak. Kobi puduk echech douk chapemu chenek loh uli. Echech douk chenek tambumu kakwich ali chenek yamagas yowegas umu kadak elpech chutulich chukli echech douk wo chuwak woligun e. Aduligu atugu yaklipepu. Echechich yopichi echudak douk achanalawech ali ajulug. ");
INSERT INTO apeB_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Wakuli ipak, sapos punek tambumu kakwich umu punek beten eneh nyumneh umu, ipak imas punouh ipakigas yamagas. Puh yamagas ali punek wel umu ipakigas balagas. ");
INSERT INTO apeB_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Punek namudak umu kipahechi kobi chudukemech umu agundak ipak penek tambumu kakwich eneh nyumneh ali pape penek beten atin umu. Ipakinu Aninu douk wo chutulunu atili e anan atunu nudukemech. Ali ipakinu Aninu douk nutik enyudak ipak punobechuk puneken ali eke nukepu yopichi echudak.” ");
INSERT INTO apeB_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Ali Jisas wata nakli, “Ipak kobi punobuk ipakich yopiyopichi echudak chukus atugun apudak atap, wak. Punechubuk agundak umu douk eke echudak chubleyech o chunek ros yowech o chaku olugwih uli chuwol wilag chuwich chukumech aluh. ");
INSERT INTO apeB_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Wakuli ipakich yopichi echudak, ipak imas punechubuk chukusumepu kalbu gani iluh heven. Chukus abuldak wabul douk eke kobi enech echudak chubleyech o chunek ros o chaku olugwih uli kobi chuwich chukumech aluh umu. ");
INSERT INTO apeB_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Ipak punobuk ipakich yopichi echudak gani iluh heven. Punek namudak ali ipak ulkwip eke pupemu pulomu ablabuk wabul atubul douk ipakich echudak chakusumepamu. ");
INSERT INTO apeB_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Ipakis nabes douk sape kobi lam umu ipakiluh yegechiweluh. Sapos ipakis nabes sutik yopichi echudak ali ipakip ulkwip pulomu yopinyimu, ipakiluh yegechiweluh eke hlupe kalbu. ");
INSERT INTO apeB_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Wakuli sapos ipakis nabes yowes sutik yowechi echudak ali ipakip ulkwip pulomu yopinyimu, ipakiluh yegechiweluh chopuk eke hlupe sisahw. Namudak ali sapos ipakip ulkwip pulomu yowenyi atin umu, ipak eke punubu pupe sisahw kobi hagak lam ali pape yomotokweh umu. ");
INSERT INTO apeB_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Deke kobi elpen nyunokwnumu nyunek moulamu biom nebemi almom, wak. Enyen douk eke nyukli wakuk ananu ali ananu eke ulkum munohwanu. Ananu eke nyumnek ananin balan ali ananu eke kobi nyumnekanu. Ipak douk wo punokwnumu pusuh God ananin moul ali punek moulamu mani alagun e, wak. ");
INSERT INTO apeB_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Namudak ali douk yaklipepu. Ipak kobi ulkwip yowep umu ipak yet ali pukli, ‘Iwe, kedeke muhuli kakwich o abal agnumu michah?’ Chopuk ipakip ulkwip kobi yowep umu ipakiluh yegechiweluh ali pukli, ‘Kedeke muneki luseh agnumu munekeh?’ Enyudakmali kobi piyagwlehen ati, wak. Ipak douk eke kobi pupe dodogowipamu luseh uli kakwich atich ali pupe loubamu apudak atap, wak. Susubati, ipak imas pupe kalbu punubu duldulipaguk ali echudak enech kakwich o luseh adakio punobukuk ulkwipumech. ");
INSERT INTO apeB_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Ipak putik hwehilau iluh uli almiguh. Ogwoguh douk wo hwunou kakwich aliga yopich ali wata hwutimech hwunak hwunechubuk onog chubukig wilag e, wak. Ogwoguh douk apakinu Aninu nape iluh heven uli i save nabilomoguh. Wakuli ipak elpech, ipak douk panubu yopipali pechalakuk oguhudak almiguh. ");
INSERT INTO apeB_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Ipak deke omuni ulkum yowem umu nyukli nyupe kalbu ali namudak wosik dodogowin nyugamu nyupegu anagun alagun banogun nyultabigun nyichalakuk abudak douk enyen eke nyugak abali? Ati deke kobi enen, wak. ");
INSERT INTO apeB_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Ipakip ulkwip yowep umu luseh umu monoken? Ipak wata putik polowahas ali ulkwip pulomu agundak chakihumali. Echech douk wo chunek moul o chunoklopu luseh e, wak. ");
INSERT INTO apeB_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Wakuli douk yaklipepu. Seiwak King Solomon douk nenek sanatimaguk ananis yopuyopusi bilas. Wakuli ananis bilas douk wak anas sunubu dudukas kobi enen echudak polowahas umu e, wak. ");
INSERT INTO apeB_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Doumeih wichap pakih pape yawihas. Wakuli kaman eke chublap chuwachop nyih. Apudak wichap douk wak enech yopichi echudak e, wak. Wakuli God douk nagakomop ali nenekap patoglu dudukap meyoh. Ipak douk ati panubu kobi wak punek bilipumanamu e, wak. Tik, ipak elpech douk panubu yopipali pechalakuk apudak wichap. Anan douk eke nukepu yopusi bilas punekas. ");
INSERT INTO apeB_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Namudak ali ipak kobi ulkwip yowep pukli, ‘Iwe, kedeke muhuli abal uli kakwich agnumu michah o omuni nyukapu eneh luseh munekeh?’ Namudak kobi pukli ati, wak. ");
INSERT INTO apeB_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Enyudakmali douk echech wo chudukemu God uli e atich i save ulkwip yowep umu chutimu ihechumali echudak. Wakuli ipak, ipakinu Aninu nape iluh heven uli douk natulipu ali anadukemech umu, ipak imas pulau ihechumali echudak ipak tukwahepomech uli. ");
INSERT INTO apeB_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Wakuli susubati ipak imas dodogowipu atipamu pukli puwich agundak God nape nebenalimu ananich elpech umu ali punek anan naklienyi duldulinyi pasin. Pulik punek enyudak ali ihechumali enechi enech echudak eke adakio nukepeyech alagun. ");
INSERT INTO apeB_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Namudak ali ipakip ulkwip kobi yowep umu enenyi enen douk eke nyutoglu kaman uli, wak. Enenyi enen hevi nyutoglu kaman uli douk nyutoglu ali nyunubu nyukusuk kaman atugun. Enenyi enen nyutoglu anah nyumnah uli douk nyunubu nyukusuk ahabuk atuh nyumnah.” ");
INSERT INTO apeB_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Jisas balan nyeilen nakli, “Ipak kobi punek skel umu kipahechi, wak. Punek namudak ali God eke kobi nunek skel umu ipak. ");
INSERT INTO apeB_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Umu monoken, God eke nunek skel umu ipakin pasin ahudak atuh yah kobi ipak penek skel umu kipahechin pasin umu. Ipak pugimehumech malmu kipahechi elpech, God eke wata nugimohumepu namobuk ati. ");
INSERT INTO apeB_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Ipak douk wo putik abudak nebebi aib bolu ipakis nabes uli e. Douk namudak ali ipak wata patulugun umu chokuguni aibigun douk gnolu ipakich elpech echechis nabes ulimu? ");
INSERT INTO apeB_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Nyak douk wo nyutik abudak nebebi aib douk bolu nyakip nabep uli e. Namudak ali nyak kobi nyuklipu nyakin elpen umu nyupotimenyuk agundak chokuguni aibigun douk gnolu enyenyip nabep uli, wak. ");
INSERT INTO apeB_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Ipak ati douk penek loh uli. Susubati ipak imas pulik pupotiyuk abudak nebebi aib bolu ipakis nabes uli. Ali ipak deke punotulugun kalbu ali adakio pupotiyuk agundak chokuguni aibigun douk gnolu ipakich elpech echechis nabes uli. ");
INSERT INTO apeB_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Enyudak God ananin yopinyi balan, ipak kobi puklipog nubag, wak. Eke gwukli waken ali gutanomu gwepu. Namudak ati ipakib anab sik dudukob weyoub chatalub nebebali utabal uli douk kobi pukoguh bulguh, wak. Kedeke hwulukwob ohwip ali hutanamu hubo ipak chopuk. ");
INSERT INTO apeB_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Ipak imas punek beten pusolik God umu nukepu echudak ali anan eke nukepeyech. Ipak imas pupe putimech ali eke putulich. Ipak imas pupemu pubo dua ali God eke nijikenyumepu. ");
INSERT INTO apeB_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Ihech elpech douk chenek beten chasolik God umu nukech echudak uli, anan i save nekechech. Echebuk douk chapemu chasolikanu chaulimu echudak uli, echech i save chatulich. Ali echebuk douk chupemu chubo dua chusalik God uli, anan eke nijikenyumech. ");
INSERT INTO apeB_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Sapos ipak ananu ananin batowin nyunaki nyusolikenyamu nyuken anatu bret umu, nyak ati eke nyuhul anam utam nyuken, waka? ");
INSERT INTO apeB_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","O sapos enyen nyunaki nyusolikenyamu nyuken anap yelbup ele, nyak ati wosik deke nyuken enen idul, waka? Adul ati wak. ");
INSERT INTO apeB_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Ipak apudak atapipali ahlim douk yowepali penek wolobainyi yowenyili. Wakuli ipak douk panubu padukemech umu pukech yopichi echudak ipakich batowich. Namudak ali ipak eke punubu pudukemech. Ipakinu Aninu nape iluh heven uli douk nanubu yopuyopunali ali eke nunubu nukepu yopichi echudak douk ipak pusolikanamech uli. ");
INSERT INTO apeB_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Ipak imas punek umu kipahechi elpech ihenyumali pasin douk ipak pakli echech chuneken umu ipak uli. Enyudak pasin douk nyanubu bawogos umu lo nyanu enyudak balan seiwak amam profet haklienyuk uli.” ");
INSERT INTO apeB_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Jisas balan nyeilen nakli, “Ipak imas punak puwich enyudak nyanubu chokwinyi dua. Umu monoken, dua douk chuwichen chunamu yowebuli wabul uli douk nebenyi. Ahudak chugimah chunak uli yah douk chopuk nebehi ali wolobaichi elpech chape chagimoh. ");
INSERT INTO apeB_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Wakuli enyudak dua douk elpech chuwichen chunamu wabul douk chape kalbu eheh nyumneh umu, enyen douk nyanubu muduk meyoh. Yah hanamu abuldak wabul uli chopuk hanubu chokuh. Ali gwodich elpech meyoh chogwatah chagimoh.” ");
INSERT INTO apeB_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Jisas balan nyeilen nakli, “Ipak punek yologimu amudak henek lohumech uli profet. Aduk eke putulum hupe duldul kobi yopichi mahich sipsip umu. Amam i save heagwleh yopinyi atin balan umu hunek ipak pumnekom. Wakuli amamin adulin tinytin douk hakli hipohul umu pumnek enen kipainyi balan pugipechen. Amam douk kobi wanalig wanohwigwi nubag umu. ");
INSERT INTO apeB_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Ali ipak douk eke putik amam heneken uli pasin ali pudukemom. Epudak wainip chulkwip douk wo pil ati e ahludak puligwiluh hlatogloluhi nadululuh, wak. Epudak enep chulkwip fik douk wo pil ati e yoweluhi giglagiluhi nadululuh, wak. ");
INSERT INTO apeB_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Ali douk namudak ati. Eke putulum pudukemom kobi patik lowas umu. Sanatimaguk yopugasi lowas douk yopipi chulkwip peil. Yowegasi yowepi peil. ");
INSERT INTO apeB_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Yowepi chulkwip douk wo pil ati e yopugasi lowas, wak. Namudak ati. Yopipi chulkwip douk wo pil ati e yowegasi lowas. ");
INSERT INTO apeB_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Sanatimaguk lowas douk wo yopipi chulkwip pil umu e douk i save chablowogos chogosehuk nyih. ");
INSERT INTO apeB_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Ali douk namudak ati. Henek lohumech uli profet douk eke putik amam heneken uli pasin ali pudukemom. ");
INSERT INTO apeB_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Ipak kobi pukli ihech elpech douk i save chohwale Digiweli, Digiweli uli eke chunak chuwich agundak God nape nebenalimu ananich elpech umu, wak. Elpech douk chugimeh kobi yekinu Aninu nape iluh heven uli naklimoluli atich, douk wosik eke chuwich chupe. ");
INSERT INTO apeB_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Ahudak nyumnah Aninu God nunek ananitu nebetali kwot ahi hutoglomu, wolobaichi elpech eke chunaki chuklipe namudak. Chukli, ‘Diginyali, Diginyali! Apak douk maklipech God ananin balan umu nyakin yeul. Magapech wolobaichi elpech mahiyahuk sagabehas chataglu chalhwasuk. Monek wolobainyi God atunu neneken uli moul!’ ");
INSERT INTO apeB_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Ali yek eke wata iklipech namudak. Ikli, ‘Kalemeik! Ipak douk papemu penek yowenyi atin uli. Yek douk wo kwalowi idukemepu e, wak.’ ");
INSERT INTO apeB_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Namudak ali echebuk elpech douk chumnek enyudak yekin balan chuhwen chugipechen uli, echech douk chape kobi ananu nadukemech uli alman nalak wilpat agundak bulbudibumu uli. ");
INSERT INTO apeB_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Nalatu julug, nebehi echah holu, wolub bau betemati, wihun nalu nebebenu atunu, wakuli echudak douk wo chubo atudak wilpat tutu e, wak. Umu monoken, anan douk nalatu notowemu agundak bulbudib umu. ");
INSERT INTO apeB_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Wakuli ihech elpech douk chumneken meyoh enyudak yekin balan ali kobi chuhwen chugipechen uli, echech douk kobi anudak lahahainali alman douk nalak ananitu wilpat agundak weisan atunamu uli. ");
INSERT INTO apeB_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Nalatu julug, hanubu nebehi echah holu, wolub bau betemati, wihun nalu nebebenu atunu ali chabo atudak wilpat tatu. Tanubu tatu tabih takus sitisatu.” ");
INSERT INTO apeB_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Jisas naklipech enyudak balan umu julug ali echudak chanatimaguk wolobaichi almom almagou loguh hwonechlukech umu enyudak anan nenek skulumech enyi balan. ");
INSERT INTO apeB_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Umu monoken, anan douk nanubu nalau nebenyi namba ali naklipech balan dodogowinu atunu. Amam henek skulumech umu lo uli douk wo hunek skulumech namudak e, wak. ");
INSERT INTO apeB_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Jisas natukemaguk nukut nagluki ali wolobaichi elpech chagipechanu chanak. ");
INSERT INTO apeB_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Ali ananu sik lepra gapenyunali alman nanaki nabih noduk ohlubus halakatimu Jisas ali naklipanu, nakli, “Diginyali, yakli nyak nyukli wosik umu, yakli nyugapeche ali yopuwe.” ");
INSERT INTO apeB_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Jisas nemnek ali nonu logul nowemu ananis wis anudak alman, ali naklipanu nakli, “Yek yakli wosik nyak nyunubu yopinyu!” Ali ahudak atuh anan nanubu yopunu. ");
INSERT INTO apeB_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Ali Jisas naklipanu nakli, “Nyunak ali kobi nyuklipu enech umu agundak yagabeyenyamu, wak. Wakuli douk yakli nyunubu nyunamu pris ali nutulinyu. Ali nyunek ofamu enech echudak nyuku God kobi ananin lo seiwak nokaguk Moses enyi nyaklimu. Nyak nyunek namudak ali chunatimaguk elpech eke chudukemech chukli nyak douk ayopinyu.” ");
INSERT INTO apeB_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Douk aliga Jisas nanak nawich wabul Kapaneam ali ananu nebenalimu amam soldia uli nanaki nanolaku-manamu nugakamanu. Anudak soldia douk nape nebenalimu 100-poleim soldia. ");
INSERT INTO apeB_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Naklipanu namudak. Nakli, “Diginyali, anudak neneme moul uli alman douk agudak genekanu nechuh wilpat. Ananiguh biguh hwanubu hwagak ali nemnek nebehi nyih.” ");
INSERT INTO apeB_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Jisas nemnek namudak ali naklipanu nakli, “Wosik, eke inaku igabeyanu yopunu.” ");
INSERT INTO apeB_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Wakuli anudak nebenali soldia nebemanu balan nakli, “Diginyali, yek wo yopuwelimu nyak nyunaku nyuwichu yekitu wilpat e, wak. Ati yakli nyukli balan atin ali anudak neneme moul uli wata yopunu. ");
INSERT INTO apeB_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Umu monoken, yek yet douk yenek moul ami ali yape chukamomu yekinu nebenali soldia. Ali chopuk yek douk yape nebewelimu kipaimi soldia. Sapos ikli iklipu ananamu nunak umu, anan eke nunak. O ikli iklipu ananomu nunakumali, anan eke nunaki. Ali sapos iklipu anudak neneme moul meyoh uli umu nunek enech echudak umu, anan eke nunekech.” ");
INSERT INTO apeB_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Jisas nemnek namudak ali loguh hwonechlukanu. Ali natanomu naklipu echebuk douk chagipechanu chanak uli, nakli, “Aduligu atugu yaklipepu. Apak Isrel yek douk wo itik enen elpen nyunek bilip dodogowin atin namudak e, wak. ");
INSERT INTO apeB_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Yaklipepu, wolobaichi elpech douk eke chunaki gani aun nakihumali, chunaki nanak nabih umu. Eke chunaki chunak chuwich chupe gani God ananich elpech chapemu. Eke chuwich ali chunu Ebraham nunu Aisak uli Jekop chupe atugun chupe chuwak woligun. ");
INSERT INTO apeB_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Ipak Juda douk pakli ipak eke puwich pupe agundak God ananich elpech chapemu. Wakuli enepu douk eke wata nipohul nuwachepu putoglu aduk umu abuldak yomotokweh-ibuli wabul. Putoglu agnabuk pumnek nebehi nyih ali eke puleh puwih naluh pududalaluh.” ");
INSERT INTO apeB_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Naklipech namudak iyuh ali natanomu naklipu anudak nebenali soldia nakli, “Kalemu wabul. Nyak douk anyenek bilip umu yek ali douk ayagabeyanu yopunu.” Ali banubu ababuk nyultab anan wata yopunu. ");
INSERT INTO apeB_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Jisas nanak aliga nanak nawich Pita ananitu wilpat ali natik Pita ananik nakwlik douk kwagobol ali kwechuh alas. ");
INSERT INTO apeB_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Natik namudak douk nanak nowemu ananis wis okwokwis ali kwanubu yopuk. Yopuk ali kwaitak kwape kwonekumanu kakwich. ");
INSERT INTO apeB_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Douk aliga wabigun halakatimu wab ali chape chalawali wolobaichi sagabehas chapenyichi elpech chanakimu Jisas. Chalawechi ali naklipech atin balan meyoh ali echudak sagabehas chatoglu chalhwas. Chopuk nagabe chanatimaguk agasudak senekechi elpech yopich. ");
INSERT INTO apeB_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Anan douk nenek enyudak umu enen balan seiwak profet Aisaia neyagwlehenyuk uli nyutoglu adulin atin. Balan enyudak. “Anan meyoh nahiyahuk anagali anagu apakigu sik nagabeyopamu yopupu.” ");
INSERT INTO apeB_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Jisas natik wolobaichi almom almagou chanaki cheyotu chalihi chalihonu ali naklipu ananim disaipel umu hunamu gani woblahahinyumu raunwara. ");
INSERT INTO apeB_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Wakuli ananu nenek skulumech umu God ananin lo uli nanaki naklipu Jisas nakli, “Tisa, ihagun nyak nyunak umu, yek eke inamenyu wunak.” ");
INSERT INTO apeB_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Ali Jisas nebemanu balan nakli, “Wanalig nubag i save gwechuh hulusigwiluh. Almiguh hwehilau iluh uli chopuk i save hwechuh was. Wakuli Yek Anudak Alman douk yatoglu aduligeinyi elpen uli, yek douk wilpat wakemu inak ichuh ipe apudak atap umu, wak.” ");
INSERT INTO apeB_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Ali kipainali alman i save nagipech Jisas uli wata naklipanu nakli, “Diginyali, wata nyuklipe inak inugamaguk yekinu aninu iyuh, ali adakio inaki inamenyu wunak.” ");
INSERT INTO apeB_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Wakuli Jisas nebemanu balan nakli, “Nyak bukeyechuk. Kadak echebuk wo chunek bilip uli e chunak chunugomech chagak uli. Nyak yowi nyugipech yek.” ");
INSERT INTO apeB_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Jisas nanak nalto bot ali ananim hagipech anan uli chopuk halto hanamanu hanak. ");
INSERT INTO apeB_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Henek pul hanak ali ahudak atuh ananu nanubu nebenali wihun naitak nohul yous ali nebebi molub batuk abal blawich bot ali bot halakatimu tuglukuk ati. Jisas anan douk nechuh netemu bot. ");
INSERT INTO apeB_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Ananim disaipel hanak habalunu ali haklipanu hakli, “Diginyali, kwaitak gakamapu. Apak halakatimu mugak wo.” ");
INSERT INTO apeB_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Ali Jisas nebemom balan nakli, “Ipak elgeipamu monoken? Ipak ati panubu wo punek bilip umu yek e, wak.” Naklipamuk namudak ali wata naitak nahu anudak nebenali wihun nanu molub. Namudak ali wihun nanubu nanak neiluk. Yous wata kwalowi gubilakuk e. ");
INSERT INTO apeB_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Douk amam hatik namudak ali hanubu loguh hwonechlukam. Ali hakli, “Anudak monokanu alman. Wihun uli yous chopuk chemnekanu.” ");
INSERT INTO apeB_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Jisas nanak aliga nanak natoglu gani woblahah enyudak raunwara Galili. Nanak natoglu echech Gadara echech umu, ali biom sagabehas chapenyumi almom douk hapeli gani hulusigwiluh matmat ali hanaki hogwatanu. Amam douk hanubu wanahwim atum ali elpech wo chulahe ati e ahabuk amam hapenyuhi yah, wak. ");
INSERT INTO apeB_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Ali hohwaloli Jisas nebegun atugun hakli, “Hei, God ananinu Nuganinu! Nyak nyakli nyunekapu malmu apak? Duldulibu nyultab umu nyopu mulau nyih umu douk watak butoglu e, wak. Wakuli nyak douk nyanamali agundak umu nyopu mulau nyih, waka?” ");
INSERT INTO apeB_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Onoguh hwanubu wolobaiguhwi bulguh douk hweyatu anagun kwalowi lougun hwape hwawak woligun. ");
INSERT INTO apeB_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Ali echudak chapenyum uli sagabehas chanubu chape chasolik Jisas chakli, “Sapos nyak nyukli nyuhiyahapu mutukemaguk amudak biom almom mutoglu munak umu, orait apak makli nyukwleyapaguk munak muwich gwaguhwi wolobaiguhwi bulguh.” ");
INSERT INTO apeB_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Ali Jisas naklipech nakli, “Kale.” Namudak ali chatukemomuk chatogloli chanak chawich oguhudak bulguh. Ali oguhudak hwanatimaguk bulguh hwasahul nebegun atugun hwanak hwagoul hwagluk enen natogul. Hwagluk hwabih raunwara ali hwawak abal hwagak hwatuh. ");
INSERT INTO apeB_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Amudak hape hoku ogohudak bulguh uli douk hatik namudak ali halhwas hanak hawich nebebuli wabul. Hawich ali haklipech nyanatimaguk balan umu bulguh hwanu amudak biom almom douk sagabehas chapenyum uli. ");
INSERT INTO apeB_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Namudak ali chanatimaguk ablabuk wabulichi chanak chaulimu Jisas. Douk chogwatanu ali chakaganamu nutukemaguk echechumu nunak kipaigunmu. ");
INSERT INTO apeB_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Echech Gadara chaklipu Jisas namudak ali anan wata nanak nalto bot natanamu nablo raunwara nanak gani woblahah. Nanak aliga nanak natoglu ananibul wabul. ");
INSERT INTO apeB_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Natoglu ali anam almom halali ananu loguh ayas chagagakanali alman anatu bet ali halawana-manali. Jisas natik amudak almom ali nadukemech umu amam douk hanubu henek bilipumanu. Namudak ali naklipu anudak loguh ayas chagakanali nakli, “O nuganinu, nyak kobi ulkum mulu sisahw elgeinyu, wak. Yek eke kobi inohwen ipemu nyakin yowenyi, ali douk enyudak eke ikwleyenyuk.” ");
INSERT INTO apeB_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Ali anam almom douk henek skulumech umu lo uli heneyagwleh chokubul hakli, “Anudak alman douk nenek tok bilas umu God.” ");
INSERT INTO apeB_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Jisas natulum nadukemu amamin tinytin ali naklipam nakli, “Ipak ulkwip kobi pulomu enyebuk yowenyi, wak. ");
INSERT INTO apeB_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Adul ati yaklipepu. Enyudak nameitu yaklipanamu yek awata inohwen ipemu ananin yowenyimu e, enyen douk wo nebenyi moul e, wak. Wakuli sapos yek ikli iklipanamu nitak nulahemu, enyudak douk adul nyanubu nebenyi moul. ");
INSERT INTO apeB_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Douk namudak ali Yek Anudak Alman douk yatoglu aduligeinyi elpen uli eke igilapepu pudukemech umu God neke namba umu kobi inosuh apudak atapichi elpech echechin yowenyi ipe, wak. Ikwleyenyuk.” Douk nakliyuk enyudak balan ali natanomu naklipu anudak douk loguh ayas chagakanali nakli, “Nyak kitak nyunamu wilpat.” ");
INSERT INTO apeB_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Namudak ali anudak alman nanubu naitak nanamu ananitu wilpat. ");
INSERT INTO apeB_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Echudak wolobaichi elpech chatik namudak ali elgeich. Ali chatuk God ananin yeul nyakih umu chakli anan douk nagakamu elpech ali dodogowich chalau namba umu chunek enyudakmali. ");
INSERT INTO apeB_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Jisas natukemaguk agnabuk nanaku wakuli natiku ananu alman douk chohwalanamu Matyu uli. Natulunu nape wilpat douk nape nalau tagis atali. Ali nakliponogu nakli, “Nyak yowi nyugipech yek.” Namudak ali Matyu naitak nanamanu hanak. ");
INSERT INTO apeB_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Hanak ali ababuk nyultab Jisas nanu ananim hanak howachabal hape Matyu ananitu wilpat hape hawok woligun abali, wolobaimi halau tagis uli hanu echudak chenek enenyi enen yowenyili douk chanak chanom chape atugun chape chawak woligun. ");
INSERT INTO apeB_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Douk amam Farisi hatik namudak ali hasalik ananim disaipel hakli, “Aipo, ipakinu Tisa douk nanu amam halau tagis uli hanu echudak chenek yowenyili elpech chape atugun chape chawak woligun. Anan nenek namudak umu monoken?” ");
INSERT INTO apeB_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Jisas nemnekam ali naklipam enyudak balan nakli, “Elpech douk agasudak wak sunekech uli e douk wo chunamu dokta umu nugabeyech, wak. Echebuk douk agasudak senekechi uli atich eke chunamu dokta umu nugabeyech. ");
INSERT INTO apeB_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Ipak punak putalih enyudak balan nyetemu God ananik buk uli ali pudukemu bawogen umu. Balan enyudak. God nakli, ‘Yek yakli wak umu ipak pubo mahich punek ofamech puku yek, wak. Yek douk yanubu yaklimu punelek kipahechi ali pugakamech.’ Ali yek douk wo inakumali ihwalu duldulichi elpech umu chutanomu chukanu apaluh God e, wak. Yek douk yanakumali ihwalu chenek yowenyili umu chukenyuk agabus yowenyi ali chutanomu chukanu apaluh God.” ");
INSERT INTO apeB_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Ali ababuk nyultab, amudak hagipech Jon douk nenek baptaisumech uli hanaki hasalik Jisas namudak. Hakli, “Apak manu amam Farisi douk i save monek tabumu kakwich eneh nyumneh ali mape monek beten atin. Wakuli nyakim disaipel douk wo hugimah namudak e umu monoken?” ");
INSERT INTO apeB_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Jisas nemnek ali nebemom balan naklipam enen woblen balan nakli, “Abudak nyultab ananu alman nasuh okwok abali, ananichi douk eke chunek nebeguni woligun chugnah ali chunehilau chupe. Umu monoken, nasuh okwok uli douk watak nanech nape. Wakuli ababuk nyultab enech chukli chulau anudak nasuh okwok uli nunakuk kipaigunmamu, ananichi douk eke apaluh yoweluhumanu, chuleh ali eke adakio kobi chuwak kakwich ali chupe ulkwip pulomanu. ");
INSERT INTO apeB_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Elpech douk wak enech chugimeh ati e, umu chitak chuhuli anas sanubu namusi lusehis ali chutapu eneh ahalakatimu bluligeleh uli luseh agundak tutukeleh umu e, wak. Kedeke chunek namudak ali kobi loubali agundak chakwlopu namusi lusehis umu eke wata lulalagun. Lulalagun lusehis sutobleik ali ehudak luseh eke gnunubu nebegunmu gnugal. ");
INSERT INTO apeB_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Namunali abalinu wain douk wo chichalanu ati e alisi chaklopos uli memeis bechis, wak. Kedeke chukli chichalanu ali aman nyupe bechis pupuwolos wain nunakuk atap ali bechis chopuk eke sunotiteh. Wakuli namunali wain douk i save chechalanu namusi bechis. Namudak ali bechis eke dodogowis kobi puwolas ali wain chopuk eke kobi nunakuk atap nunotiteh, wak.” ");
INSERT INTO apeB_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Jisas wata nape naklipam balan Jon ananim disaipel ali ananu echech Juda echechinu nebenali alman nanaki nabih noduk ohlubus natau halakatimu Jisas ali nakli, “Yekik nugawik douk nameitati kwagak. Wakuli douk yakli nyunaku nyuwemeyok wis umu wata kwitak.” ");
INSERT INTO apeB_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Jisas nemnek ali naitak nanamanu hanak. Ali ananim disaipel chopuk hanamanu. ");
INSERT INTO apeB_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Hanak ali onok almatok kwanaki agundak agabinamu Jisas ali kwasusuh algasih umu ahudak louhi lupah anan nenekah uli. Okudak almatok douk butog gwanakok wihluwehlu umu 12-poleich yogleguh. ");
INSERT INTO apeB_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Okwok douk kwoneyagwleh kwakli, “Ikli isusuh ananih lupah atuh umu, yek eke yopuwe.” ");
INSERT INTO apeB_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Wakuli Jisas natanomu natuluk ali naklipok nakli, “Nugawik, nyakihw apahw kobi yowehw, wak. Nyak nyenek bilip nyakli yek dodogowiweli ali nyak dakio yopinyu.” Ali banubu ababuk nyultab butog tupokologuk ali wata chopuk yopuk. ");
INSERT INTO apeB_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Douk aliga Jisas nanak natoglu anudak nebenali ananitu wilpat ali natik umu wolobaichi elpech douk chape chelepu ananik nugawik. Enech douk chape chehepich baltog. Namudak ali chanubu chohwoligas chahwagas. ");
INSERT INTO apeB_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Douk natulich namudak ali naklipech nakli, “Ipak taglaguk agundak. Okudak chokukwi douk ati wo kugak e, wak. Okwok douk kwechuh meyoh.” Echech chemnek namudak ali cheyakasunu. ");
INSERT INTO apeB_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Douk nokogech chataglaguk aduk atugun ali nanak nawich nasuh okwokwin logul ali nokuhul kwaitak yopuk. ");
INSERT INTO apeB_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Namudak ali balan nyoweyeh nyanak ihalub walub enyebuk provins Galili umu agundak Jisas nohul okudak kwagak uli kwaitak umu. ");
INSERT INTO apeB_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Jisas natukemaguk ablabuk wabul nape nanak ali biom nabes sechukomi almom hagipechanu hape hohwalu hanak hakli, “Nya Devit ananinu yamenu, nyak nyukli mapilihu ohwak.” ");
INSERT INTO apeB_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Jisas nanak nawich nape wilpat ali amudak biom nabes sechukomi hanaki hatoglomanu. Ali nasalikam nakli, “Ipak penek bilip pakli yek douk wosik dodogowiwemu ihulmepu nabes yopus, waka?” Ali amam haklipanu hakli, “Diginyali, adul wonek bilip wo.” ");
INSERT INTO apeB_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Ali nowemu wis amamis nabes ali naklipam nakli, “Ipak douk penek bilip umu yek ali yakli ipak wata putulugun.” ");
INSERT INTO apeB_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Ali amamis nabes wata yopus hatulugun hwilhwaluk. Ali Jisas naklipam dodogowinyi balan nakli, “Ipak punenek yologi. Eke punak puklipu enech elpech umu agundak yagabe ipakis nabes yopus umu, wak.” ");
INSERT INTO apeB_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Wakuli hatoglu hanak ali haklipech hanak ihalub walub blape ababuk amnab uli. Haklipech umu enyudak douk Jisas neneken uli. ");
INSERT INTO apeB_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Amudak biom almom hatukemaguk Jisas hape hanaku ali enech elpech chalawali ananu alman umu Jisas. Anan douk enen sagabu nyapenyunu ali wo niyagwleh ati e, wak. ");
INSERT INTO apeB_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Douk Jisas nahiyahuk enyudak sagabu nyatoglu nyalhwasuk, wakuli nanubu nape neyagwleh. Namudak ali echech almom almagou loguh hwonechlukech ali chakli, “Seiwak, apak Isrel douk wo kwalowi mutik enen e enyudakmali, wak.” ");
INSERT INTO apeB_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Wakuli amam Farisi douk hakli namudak. Hakli, “Anabuk douk Satan meyoh nenekanu dodogowinu ali dakio dodogowinamu nahiyahuk sagabehas chatukemaguk elpech chatoglu chalhwas.” ");
INSERT INTO apeB_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Jisas nalahe nanak ihalub nebelubi blanu chokulubi walub ali nawich echech Juda chape cheyagwleh balan yogwi wilag nape naklipech God ananin yopinyi balan. Chopuk douk naklipech yopinyi balan umu agundak elpech chuwich agundak God nape nebenalimu ananich elpech umu. Naklipech balan ali nagabe ihagamali anangali anagu agudak gapenyich uli elpech yopich. ");
INSERT INTO apeB_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Nalahe natik chanubu wolobaichi almom almagou namudak ali nanubu nenelekech. Umu monoken, echech douk chanubu wo dodogowich e ali chape sisahw kobi sipsip douk alman nupe niyohech uli wak ananamu e. ");
INSERT INTO apeB_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Jisas natulich namudak ali natanomu naklipu ananich disaipel enyudak woblen balan nakli, “Kakwich chanubu wolobaichi chasu chape nahabigu, wakuli elpech chusogunmech uli douk wo wolobaichi e. ");
INSERT INTO apeB_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Namudak ali ipak imas punek beten pusolik nohobigeinali umu nukagas chenek moulaluli chuwich chusogunmech chichubuk atugun.” ");
INSERT INTO apeB_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Jisas nahwalu ananim 12-poleim disaipel hanaki heyotu atugun ali nokom ananin pawa. Nokom pawa umu huhiyah sagabehas chutukemaguk elpech chutoglu chulhwas. Chopuk umu hugabech ihagamali anagali anagu sik genekech uli elpech yopich. ");
INSERT INTO apeB_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Amam 12-poleim aposel amamich yeguh douk echudak: Susubeinu douk Saimon. Kipainyi yeul nonohwalu Pita. Anan nanu ananinu owaninu Andru, Jems nanu ananinu owaninu Jon. Amam douk Sebedi ananim nugamim. ");
INSERT INTO apeB_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Pilip nanu Batolomyu. Tomas nanu Matyu douk nalau tagis uli. Alfias ananinu nuganinu Jems. Ananu Tadias. ");
INSERT INTO apeB_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Ananu Saimon. Anudak Saimon douk natanuh ananu lain almom chohwalam umu Selot. Amam hanu Judas douk nanaki wabul Kariot ali douk eke nugilapu Jisas ananim birua anan Jisas uli. ");
INSERT INTO apeB_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Jisas naklipu amudak 12-poleim aposel enyudak balan ali nakagam hanak. Balan enyudak. Nakli, “Ipak kobi punak agundak kipahechi douk echech wak Juda uli e chapemu, wak. Chopuk echech Sameria echechilub walub kobi punak puwichalub, wak. ");
INSERT INTO apeB_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Wakuli douk yakli punamu echech Isrel atich. Echech douk wo chudukemu God ananin balan e, wak. Chape kobi chanak chawichuk uli sipsip umu. ");
INSERT INTO apeB_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Punak puklipech namudak. Pukli, ‘Abudak nyultab umu elpech chuwich umu agundak God nape nebenalimu ananich elpech umu douk ahalakatimu eke butoglu.’ ");
INSERT INTO apeB_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Punak pugapech agudak genekech uli yopich. Puhul chagak uli chitak. Pugapech yowegali agudak lepra gapenyich uli elpech ali gutukemechuk yopich. Puhiyah sagabehas chutukemaguk elpech chutoglu chulhwas. Okudak outuk umu punek enyudakmalimu douk yekepeyok meyoh. Wo putaluk e. Namudak ali abudak nyultab ipak punak pugabe enech elpech umu, ipak kobi wata puhwalech umu chutalipu, wak. Pugabeyech meyoh. ");
INSERT INTO apeB_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Punak abali, ipakigas bagos kobi pitak pukli punoluk anal gwol o enen siliwain o enen kapain mani punohwen punak, wak. ");
INSERT INTO apeB_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Punak ahudak yah abali douk yakli kobi punatabak anagas begas, wak. Punak meyoh. Kobi pitak punosuh eneh kipaich luseh o kipaich sandelahas alagun, wak. Punenekech uli atich chupemepu. Butip chopuk kobi punosuh enep. Echebuk douk ipak punak punek moul puklipech God ananin balan uli, echech imas chukepu pichah uli kakwich. ");
INSERT INTO apeB_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Ablabuk chokubuli o nebebuli wabul ipak punak puwichabul uli, ipak imas punak putimu enen yopinyi elpen douk eke nyukli wosik umu ipak punen pupeuli. Pugwatu enen ali punu enyebuk atin pupe aliga putukemaguk ablabuk wabul punak. ");
INSERT INTO apeB_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Susubati pukli punak puwich anatu wilpat umu, susubati ipak imas punemech gude ali puklipech pukli, ‘Apak makli God nunekumepu yopinyi ali ipakiluh apaluh hlulu kalbu.’ ");
INSERT INTO apeB_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Sapos atabuk wilpatichi chuklipepu wosik umu punech pupemu, echech douk eke chupe kalbu kobi ipak paklipech umu. Wakuli sapos echech chukli wak umu ipak punech pupemu, orait enyudak balan douk penemech gude ali paklipech umu chupe kalbamu eke wata nyutanamumali ipak ali ipak pupe kalbu. ");
INSERT INTO apeB_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Ali sapos kobi enech elpech chuklipepu wosik umu punech pupe o chukli wak umu chumnek ipakin balan umu, ipak imas putukemaguk atabuk wilpat o wabul ali punak. Punak abali, ipak imas pugudupechuk ipluk ipakiluh yoliluh kukusuk umu echech chutulipu ali chudukemech chukli echech douk chenek yowenyi. ");
INSERT INTO apeB_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Adul ati yaklipepu. Seiwakichi elpech douk chape Sodom uli Gomora, echech douk chanubu chenek yowenyili elpech. Wakuli ahudak nyumnah God ananitu nebetali kwot tunenek ahi, ablabuk wabul douk chakli wak umu chemnek ipakin balan uli, anan eke nunubu nunekumech yowenyi nyichalakuk enyudak eke nuneken umu echech Sodom chanu Gomora uli.” ");
INSERT INTO apeB_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Ali Jisas wata nagamu naklipu ananim disaipel nakli, “Ipak mnek. Eke inek salimumepu punak kobi echudak wo dodogowich uli e mahich sipsip chanak olokohun umu wanalig nubag umu. Namudak ali ihechumali echudak ipak punak pukli punekech uli, ipak douk pugamu pudukemu dukemu dakio punekech, kobi iguh umu. Chopuk ipak imas pigimah kobi oguhudak machubiguh almiguh umu. Ogwoguh douk wo huklimu hunek enen yowenyi ati e, wak. Ipak douk pugimeh namobuk ati. ");
INSERT INTO apeB_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Ipak punenek yologimu yowemi almom. Amam douk eke hunaki huhwepu hulawepamu nebemi douk hape hasuh kwotog uli. Hulawepu hunemepu kwotog ali eke chusakepu echudak gani numun wilag douk chape cheagwleh balan ogwi. ");
INSERT INTO apeB_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Ipak douk pagipech yek. Namudak ali eke chuhwepu chulawepamu nebemumali gavman uli hunu amam king umu puklipam yekin balan ali hemneken. Punak ali douk kalbamu puklipam yekin balan amabuk nebemi hunu echebuk douk wo chudukemu God uli e. ");
INSERT INTO apeB_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Ababuk nyultab chulawepamu kwot abali, ipak kobi elgeipu pukli kedeke piyagwleh monoken balan o pubeyenyumech malmu, wak. Banubu ababuk atubu nyultab God eke nugilapepu enyudak balan douk ipak eke piyagwlehen uli. ");
INSERT INTO apeB_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Balan piyagwlehen uli eke kobi ipak meyoh piyagwlehen, wak. Enyen douk eke ipakinu aninu God ananin Michin nyuwichepu ali nyipahul umu piyagwlehen.” ");
INSERT INTO apeB_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Ababuk nyultab enenyi enen hevi nyutoglu abali, sanyowan eke hitaki ananu nunemanu balan ananu nuklipu kipahechi chanu nugak. Ahlim eke hugimehumech namudak ati amamich batowich. Batowich chopuk eke chitaki chukechuk agabus echechich mamechich. Eke chunak chunemech kwotog chuklipu kipahechi chech chugak. ");
INSERT INTO apeB_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Chanatimaguk elpech eke apaluh yoweluh umu ipak chukli wakepu. Umu monoken, ipak douk panubu pasuh yekin balan pagipech yek uli. Wakuli echebuk elpech douk chiyotu dodogowich atich umu bilip aliga hugikuk uli nyumnah hutogloluli, echebuk God eke wata nunolawech chutanamali chupe kalbu. ");
INSERT INTO apeB_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Ali abudak nyultab chukli chukli wakepu chunekepu anagu anagu anabul wabul abali, ipak imas putukemaguk ablabuk wabul pulhwas punamu kipaibuli. Aduligu atugu yaklipepu. Ipak eke kobi kebes piyatak ihalub walub blape Isrel uli puklipech God ananin yopinyi balan ali yek Anudak Alman douk yatoglu aduligeinyi elpen uli eke wata itanamali. ");
INSERT INTO apeB_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Enen sumatin douk wo nebenyi nyichalakuk enyenyinu tisa e, wak. Namudak ati. Enen nyape chukamomu ananu nebenali alman nyenemanu moul meyoh uli, enyen douk wo nebenyi chichalakuk enyenyinu nebenali e, wak. ");
INSERT INTO apeB_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Namudak ali sapos enen nyenek skul uli nyukli nyutoglu alagun atimu enyenyinu tisa umu, namudak douk wosik. Nyenek moul umu ananu nebenalili douk chopuk namudak ati. Sapos enyen nyukli nyutoglu alagun atimu enyenyinu nebenalimu, namudak chopuk wosik. Ali ipak panu yek ipakiwe nebeweli douk namudak ati. Yek douk chohwale enyudak nyanubu yowenyi yeul Belsebul. Namudak ali ipak yekipali eke chunubu chuhwalepu yowepali chuklipepu enen enen.” ");
INSERT INTO apeB_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Jisas balan nyeilen nakli, “Ipak kobi elgeipamu elpech douk chukli chunekumepu yowenyili, wak. Ihechumali echudak douk elpech chunobechuk chunekech uli eke wata chutoglu yopugunmu. Nyanatimaguk chonobechuk cheagwlehen uli balan chopuk eke wata chunatimaguk mnekuk ati. ");
INSERT INTO apeB_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Enyudak balan douk apak atupu mape yaklipepeyen uli, ipak imas putoglu puklipechen yopugunmomu wolobaichi chumneken. Chopuk enyudak balan douk yabomepu chokweh umu, ipak imas piyotuwi gani iluh wilag puhwalomenyi umu chunatimaguk chumneken. ");
INSERT INTO apeB_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Ipak kobi elgeipamu elpech douk eke chubo yegechiweluh atuluh hlugak uli, wak. Ipakich michich douk wo chunokwnumu chech chugak e. Wakuli ipak imas elgeipamu God atunu. Anan douk nanubu dodogowinamu nubo ipakich michich chunu ipakiluh yegechiweluh nichagiyechuk abuldak yowebuli wabul hel. ");
INSERT INTO apeB_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Ipak douk padukemech. Biech chokwichi almiguh douk i save chatalich 1 toea. Echudakmali almiguh, ipakinu Aninu God i save nenek lukautumech. Nukli wak umu enen nyugak umu, eke kobi enen nyugak, wak meyoh. ");
INSERT INTO apeB_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Ali ipak, ihalub ahilub blakih ipakigas balagas uli douk daleh daleh neyatalub. Nanubu nadukemepu kalbu. ");
INSERT INTO apeB_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Namudak ali ipak kobi elgeipu, wak. God anan douk i save ulkum molomu ipak pechalakuk wolobaiguhwi oguhudak almiguh.” ");
INSERT INTO apeB_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Jisas balan nyeilen ali nakli, “Echebuk elpech douk chuklipu kipahechi yopugunmu chukli echech douk chape yekich uli, yek chopuk eke inekumech namobuk ati gani iluh heven. Eke iklipu yekinu Aninu ikli echech douk yekich elpech. ");
INSERT INTO apeB_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Wakuli echebuk douk chuklipu kipahechi yopugunmu chukli echech wo yekich uli e, yek chopuk eke inekumech namobuk ati gani iluh heven. Eke iklipu yekinu Aninu ikli echech douk wo yekich elpech e, wak.” ");
INSERT INTO apeB_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Ipak kobi pukli yek douk yanamali inek apudak atapichi elpech umu chupe kalbu ali kobi chulpak chuhlitak, wak. Yek douk yanamali inekech chunatimaguk yowes ali chulpak chuhlitak. ");
INSERT INTO apeB_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Yek douk yanamali idiyogul elpech. Nugamim eke huhu amamim ahlim. Nugaliyu eke wuhu owowiyu mamaliyu. Mehiyaliyu eke wuhu owowiyu nakwluheu. ");
INSERT INTO apeB_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Enen elpen enyenyich birua douk eke echudak echech chanubu atugu nyunugamu. ");
INSERT INTO apeB_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Echebuk elpech douk ulkwip panubu panosuh echechich mamechich chechalakuk agundak echech ulkwip panosuh yek umaluli, echech douk chanubu wo chunokwnumu chupe yekich elpech e, wak. Echebuk elpech douk ulkwip panubu panosuh echechim nugamim o echechiyu nugaliyu chechalakuk agundak echech ulkwip panosuh yek umaluli, echech douk chanubu wo chunokwnumu chupe yekich elpech e, wak. ");
INSERT INTO apeB_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Ali echebuk elpech douk chukli wak umu kipahechi chech chugak umu agundak chagipech yek umaluli, echech douk wo chunokwnumu chupe yekich elpech e, wak. ");
INSERT INTO apeB_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Echebuk elpech douk ulkwip pulomu echechiluh yegechiweluh ali chunotutik umu kipahechi chech chugak uli, echech douk eke chugak ali chunubu chunak chuwichuk. Wakuli echebuk elpech douk chugipech yek ali kipahechi dakio chech chugak uli, echech eke chugak ali chunubu chupe kalbu eheh nyumneh. ");
INSERT INTO apeB_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Echebuk elpech douk chulau ipak chunekumepu yopinyili, enyebuk douk cheneken umu yek. Namudak ali echebuk douk chalau yek chenekume yopinyili, enyebuk douk cheneken umu God douk nakagas yek yanakili. ");
INSERT INTO apeB_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Enyebuk elpen douk nyutik ananu profet ali nyukli anan douk yopunali nalahemali God ananin balan uli, ali nyulawanu nyunekumanu yopinyili, kwali enyen eke nyulau yopichi echudak kobi amam profet hulawech ulimu. Ali enyebuk elpen douk nyutik ananu duldulinali alman ali nyukli anan duldulinali ali nyulawanu nyunekumanu yopinyili, kwali enyebuk chopuk eke nyulau yopichi echudak kobi echudak duldulichi elpech chulawech ulimu. ");
INSERT INTO apeB_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Ali enyebuk elpen douk nyutik enen echudak yeguh wakechi elpech ali nyuken eneh nyumanugasihi abalih nyihah umu agundak enyen nyagipech yek umu, enyebuk adul God eke nubukumen yopichi echudak chukusumen. Eke kobi ulkum mukonoguk, wak.” ");
INSERT INTO apeB_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Jisas naklipu ananim 12-poleim disaipel enyudak balan umu julug, umu nunek skulumom umu, ali naitak natukemaguk agnabuk nanak analub blape halakatili walub. Nanak nape naklipech ali nenek skulumech enyudak God ananin balan. ");
INSERT INTO apeB_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Anudak nenek baptaisumech uli Jon douk alikuk chowechikanu nape haus kalabus. Douk nemnek umu enyudak Krais nape neneken uli moul ali nakagas ananim disaipel hanak umu husalikanu enen balan. ");
INSERT INTO apeB_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Hanak ali hasalikanu hakli, “Douk God naklimu eke nukaganu nunakili douk nyak, waka eke mupe mubeyogunmu kipainali?” ");
INSERT INTO apeB_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Jisas nemnek ali nebemom balan nakli, “Aliga putanamu puklipu Jon umu enyudak balan douk pemneke yeyagwlehen uli nyanu enyudak moul douk yeneken patulin uli. ");
INSERT INTO apeB_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Puklipanu pukli yagabe nabes sechukechi wata chatulugun. Chape atap atup uli wata chalahe. Yagabe sik lepra gapenyich uli wata yopich. Aligas sogugakeyechi wata chemnek. Yohul chagak uli chaitak chape. Yaklipech God ananin yopinyi balan echebuk douk chanahwagagun umu echudak uli ali chemneken. ");
INSERT INTO apeB_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Ali echebuk elpech douk ulkwip polomu yek ali chasuh yekin balan dadag uli, echech wosik iken chunehilau.” ");
INSERT INTO apeB_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Abudak nyultab Jon ananim disaipel hape hanak abali, Jisas douk nape naklipu echudak wolobaichi elpech umu Jon. Nakli, “Abudak nyultab panamu agundak wohigunmu douk elpech wak umu, ipak douk panak umu putik monoken? Panak umu putik anah wo dodogowihi aluh douk wihun nahuhul nahubuk uli? ");
INSERT INTO apeB_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Panak umu putik monoken? Ati douk eke panak umu putik ananu nenek yopihi luseh uli, waka? O wak. Henek yopihi luseh uli douk i save hape gwagwi amam king hapenyugwi wilag. ");
INSERT INTO apeB_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Namudak ali douk panak umu putik monoken? Panak umu putik ananu profet douk God nagilapanu ananin balan ali naklipu elpechen uli, waka? Wo, adul wo. Ipak douk panak umu putik ananu profet. Yaklipepu, anabuk profet douk nanubu nebenali nechalakuk hanatimaguk profet. ");
INSERT INTO apeB_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Jon anan douk anudak alman seiwak howemaguk God ananin balan nyakliyanali. Henyemaguk namudak. God nakli, ‘Yek eke ikagas anudak nulau yekin balan uli nulik ali nyak eke adakio nyugikuk. Anan eke nugabemenyu yah umu nyak nyugimah nyunak umu.’ ");
INSERT INTO apeB_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Aduligu atugu yaklipepu. Jon nenek baptaisumech uli, anan douk nanubu nebenali nechalakuk ihech elpech seiwak chape apudak atap aliga nameitoluli. Wakuli echebuk elpech douk chanubu yeguh wakech ali chuwich agundak God nape nebenalimu ananich elpech umaluli, agundak yeguh chukihech umu douk eke chunubu chichalakuk Jon. ");
INSERT INTO apeB_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Likuk abudak nyultab Jon nenek baptaisumech uli nape naklipech God ananin balan abali aliga nameitu, enech dodogowichi wanohwichi elpech douk chape didigichich atich chape chabilak umu chuwich agundak God nape nebenalimu ananich elpech umu. ");
INSERT INTO apeB_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Lo seiwak God nokaguk Moses umu, enyen douk nyakliyuk umu elpech eke chuwich agundak God nape nebenalimu ananich elpech umu. Hanatimaguk profet chopuk hakli enyudak atin aliga Jon natoglu. ");
INSERT INTO apeB_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Ali sapos ipak pukli enyudak balan adulin puhwen umu, ipak douk puhwen. Balan nyetemu God ananik buk uli douk nyakli profet Ilaija imas nutoglu. Enyen douk nyaklimu anudak Jon. ");
INSERT INTO apeB_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Ipak aligas sapenyipali imas pumnek enyudak balan ali imas pudukemen.” ");
INSERT INTO apeB_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Ikli ineyogamu ipak nameiteipali elpech ipakin pasin umu, yek douk eke ikwu monoken woblen balan? Ipak douk paduk chokwichi douk chowachabal chape onoh omeh ali chohwalogu kipaichi chokwichi. ");
INSERT INTO apeB_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","Chohwalechu chakli, ‘Apak douk mehepichumepu buan umu piyolub, wakuli ipak wo piyolub e. Apak douk meyolub chagak uli, wakuli ipak wo puleh e.’” ");
INSERT INTO apeB_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Jisas balan nyeilen nakli, “Jon douk nanaki ali anabu nyultab kakwich wo nichah ati e. Wainibal abal chopuk nanubu wo nubalah ati e. Ali enech douk chatulunu chakli, ‘Anan douk enen sagabu nyapenyunu.’ ");
INSERT INTO apeB_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Ali yek Anudak Alman douk yatoglu aduligeinyi elpen uli douk yanaki yawak kakwich wihluwehlu, yawak wainibal abal. Ali enech douk chatiwe chakli, ‘Tik, anan douk napemu nawak kakwich uli wainibal abal nalikuk.’ Chopuk echech douk chakli, ‘Anan douk nanahwech umu elpech echudak douk chenek yowenyili chanu amudak halau tagis uli.’ Wakuli douk yaklipepu: Ipak eke putik echebuk elpech chulau God ananin yopinyi save chuhwen dadag chunek yopinyi pasin ali eke pudukemech pukli echechin pasin douk yopinyi.” ");
INSERT INTO apeB_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Jisas nenek wolobainyi God atunu neneken uli moul nyatoglu analub walub. Neneken chatulin wakuli echech wo chukenyuk agabus yowenyi ali chutanomu chukanu apaluh God e, wak. Namudak ali echech albabuk walub douk didigichinu atunu naklipech dodogowinyi balan. ");
INSERT INTO apeB_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Naklipech nakli, “Mapilipu ipak elpech douk pape albudak biolub walub Korasin uli Betsaida. Ipak douk eke pumnek nebehi nyih ali punubu pupe sisahw. Umu monoken, douk seiwak ananu alman nunek enen God atunu neneken uli moul gani Taia uli Saidon kobi enyudak yek yeneken ipakilub ele, echech deke aseiwak chutukemaguk yowenyi. Ali deke chitak chusak yowehi luseh ali chichlokuh algabus umu chugilapech umu echech douk achekenyuk agabus yowenyi. ");
INSERT INTO apeB_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Wakuli douk yaklipepu. Ahabuk nyumnah douk God nunaki nunekumech balan chanatimaguk elpech umu, hevi nuneken nyutoglomu ipak uli eke nyunubu nyichalakuk enyebuk eke nuneken nyutoglomu echech chape Taia blanu Saidon uli. ");
INSERT INTO apeB_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Ali ipak Kapaneam chopuk, ipak pakli God eke nukli wosik ali nulawepu pulto iluh heven, waka? Ati eke wak. God eke nuwachepu pugluk gani chagak uli chabih chapemu. Sapos enyudak nebenyi moul douk yape yeneken ipakibul wabul uli seiwak enech chuneken echech Sodom chutulin ele, nameitu abuldak wabul Sodom deke wata blupe ati. Deke kobi bulkwolobuluk, wak. ");
INSERT INTO apeB_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Wakuli douk yaklipepu. Ahudak nyumnah God natalihah umu nunemech balan chanatimaguk elpech ahi, hevi eke nuku ipak pulau nyih umu douk eke nyunubu nyichalakuk enyudak hevi douk eke nuku echech Sodom umu.” ");
INSERT INTO apeB_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Ali ababuk nyultab, Jisas nakli namudak. Nakli, “O yekinyu Aninu Diginyalimu iluh atap uli, yek douk yenek tenkyumenyu. Umu monoken, nyak douk nyobechuk bawogen umu nyakin balan umu echebuk douk chanubu chadukemech uli chanu chalau wolobainyi save uli, wakuli nyak wata nyagilapu echudak atich douk chape kobi chokwichi batowich ulimu. ");
INSERT INTO apeB_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Adul Aninu, nyak douk nyagipech nyakin atin laik ali nyenehilau nyenek namobuk.” ");
INSERT INTO apeB_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Ali Jisas wata nakli, “Yekinu Aninu douk aneke ihechumali echudak. Ali douk wak enech elpech chudukemu yek ananiwe nuganinu e, wak. Aninu God atunu nadukeme. Yekinu Aninu chopuk wak enech chudukemanu e. Yek ananiwe Nuganinu yanu echebuk douk yek yakli igilapech anan uli atupu madukemanu.” ");
INSERT INTO apeB_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Ipak douk penek nebenyi moul umu pasah enenyi enen nebenyi hevi ali wo dodogowipu uli e, ipak punatimaguk punamali yek. Yek douk eke igakomepu punubu punek malolo. ");
INSERT INTO apeB_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Punaki pulau save yek ali pupe chukamomu yek. Kobi douk pasah anagu palag douk chogolu bulmakauhas umu chusonuk echudak uli. Ipak douk punaki pulau save yek. Umu monoken, yek douk yanubu naleiweli alman ali i save yeyagwleh chokwin balan. Punamali yek igakomepu punek malolo ali ipakiluh apaluh eke hlulu kalbu. ");
INSERT INTO apeB_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Agudak palag yek igowemu ipak uli douk wak nebenyi moul umu ipak pugasah umu e, wak. Ali enyudak hevi yek ikepamu pinyusah uli douk wak amamanyin umu ipak pinyusah e, wak.” ");
INSERT INTO apeB_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Douk aliga anah nyumnah douk echech Juda moul wak chape meyoh ahi hanak hatogloli, ali Jisas nanu ananim disaipel hawich hanak anagu nahabigu douk chau wit-agali. Ananim disaipel nyulub blam ali hape hablomu anagunitamu wit hatowah. ");
INSERT INTO apeB_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Douk amam Farisi hatik namudak ali haklipu Jisas hakli, “Tik nyakim disaipel heneken umu enyudak. Apakin lo nyakli kobi munek enen moul ahudak nyumnah Sabat, wak.” ");
INSERT INTO apeB_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Jisas nemnek ali nebemom balan nakli, “Ipak eke patalihen waka wak balan, umu enyudak douk seiwak Devit nanu ananim nyulub blam ali Devit neneken uli? ");
INSERT INTO apeB_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Anan douk nanak nawich God ananitu nebetali wilpat ali nohuli bret douk chenek ofamatu choku God uli ali nanu ananim hanamonoluli hatowah. Apakin lo douk nyakli kobi enech meyoluhich elpech chuwak atudakmali bret, wak. Amam pris atum hutowoh. ");
INSERT INTO apeB_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Chopuk ipak eke patalihen padukemen waka wak, enyudak balan douk nyetemu lo nyetemeyok uli buk? Enyen douk nyaklimu amam pris douk i save henek moul numun God ananitu wilpat uli imas hunek moul ahudak nyumnah Sabat umu. Amam i save hablo lo henek moul Sabat, wakuli balan douk wak enen nyupenyum e, wak. ");
INSERT INTO apeB_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Ali douk yaklipepu. Yek enyudak nameitu yapeuli douk yanubu nebeweli yechalakuk atudak God ananitu nebetali wilpat. ");
INSERT INTO apeB_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Enen balan nyetemu God ananik buk uli douk nyakli namudak. God nakli, ‘Echudak douk ipak punek ofamech picheh puku yek uli douk yakli wakech. Wakuli enyudak douk yek yaklien uli douk yakli ipak imas punelek kipahechi ali pugakamech punekumech yopinyi.’ Douk sapos ipak pudukemu bawogen umu enyudak balan ele, ipak deke kobi pukli balan wakechi elpech douk chenek yowenyi, wak. ");
INSERT INTO apeB_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Umu monoken, yek Anudak Alman yatoglu aduligeinyi elpen uli douk yanubu Digiwelimu iklipu elpech umu chunek moul ahudak nyumnah Sabat.” ");
INSERT INTO apeB_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Jisas natukemaguk amam Farisi namobuk ali nanak nawich anatu echech Juda chape cheagwleh balan atali wilpat. ");
INSERT INTO apeB_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Nawich ali natik ananu logul nyenek-analuli alman douk nape. Anam almom douk hakli hunemanu balan Jisas. Namudak ali haitak hasalikanu hakli, “Jisas nyak nyakli lo wosik nyakli deke mugabe agasudak senekechi elpech ahudak nyumnah Sabat o wak?” ");
INSERT INTO apeB_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Ali Jisas naklipam nakli, “Sapos ipak ananu nuglemu enen sipsip ali enyudak sipsip nyunak nyugluk anagu bobigu ahudak nyumnah Sabat umu, ipak douk padukemech. Anan eke wata nunak nuhwen nutukenyumali atugun. ");
INSERT INTO apeB_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Ali douk yaklipepu. God anan douk nanubu ulkum molomu elpech checholokuk echudak mahich sipsip. Namudak ali sapos mugapech agudak genekechi elpech ahudak nyumnah Sabat umu, enyudak douk wosik monek yopinyi. Wak mublo lo e.” ");
INSERT INTO apeB_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Naklipamuk namudak ali natanomu naklipu anudak logul yowenyonali nakli, “Nu nyakin logul.” Douk nonu logul ali nyanubu yopin nyape kalbu kobi enyudak enen umu. ");
INSERT INTO apeB_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Amam Farisi hatik namudak ali hanubu haitak hatoglu hanak. Hanak ali heagwleh habo balan umu hakli hulimu anah yah umu hubo Jisas nugak. ");
INSERT INTO apeB_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Douk Jisas nadukemu enyudak amam Farisi hakli hunekenyumanu uli, ali wata natukemaguk ablabuk wabul nanak. Nanak ali wolobaichi elpech chagipechanu. Chagipechanu ali nagapech chanatimaguk agasudak senekechi elpech yopich. ");
INSERT INTO apeB_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Ali naklipech dodogowinyi balan umu kobi wata chunak chuklipu kipahechimu anan, wak. ");
INSERT INTO apeB_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Anan douk naklipech namudak umu enen balan seiwak God nohul profet Aisaia neyagwlehenyuk uli nyutoglu adulin atin. Balan enyudak. ");
INSERT INTO apeB_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","God nakli, “Tik anudak alman. Anan douk yatalihonomu nunek yekin moul uli. Yek douk ulkum manahwanu ali yanubu yenehilau-manu. Eke ikanu yekin Michin nyuwich nyupenyunu ali eke nunak nuklipu echudak elpech douk wo chudukemu yek uli e umu yek yaklienyi duldulinyi pasin. ");
INSERT INTO apeB_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Anan eke kobi nunu kipahechi chune-chichilak o nuhwalu nebegun atugun, eke wak. Yegwih eke kobi chumnek ananigu nigu, wak. ");
INSERT INTO apeB_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Elpech douk wo dodogowich ali chape kobi alih douk wihun nehuhul nehubuk umu bageleh uli, anan eke kobi nech nichagiyechuk, wak. Elpech douk wo dodogowich ali ulkwip yowep uli douk chape kobi eneh nyih douk halakatimu hugak uli. Ali anan eke kobi didigichinu atunu nutulich, wak. Anan eke wata nugakomech dodogowich. Anan eke nunek moul nupe aliga aliga yopinyi pasin nyubo yowenyi pasin nyubihuk. ");
INSERT INTO apeB_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Ali echudak elpech douk wo chudukemu yek uli e eke chusuh ananin balan ali chupe chubeyogun-manu umu nunolawech.” ");
INSERT INTO apeB_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Ali ababuk nyultab, enech elpech chalawali ananu enen sagabu nyapenyunali alman umu Jisas. Anan douk nabes sechukanu ali chopuk wo niyagwleh ati e. Chalawonolimu Jisas douk nagabeyanu neyagwleh ali wata chopuk natulugun. ");
INSERT INTO apeB_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Chanatimaguk elpech chatik namudak loguh hwonechlukech ali chakli, “Aipo, anudak alman douk ati eke Devit ananinu yamenu waka? Anan douk anudak God naklimu eke nutalihanu ali nukaganu nunamali nunolau elpech uli, waka?” ");
INSERT INTO apeB_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Douk amam Farisi hemnek namudak ali heneyagwleh chokubul hakli, “Anudak alman douk nebenalimu sagabehas uli douk chohwalanamu Bielsebul uli nenekanu dodogowinu dakio nehiyah sagabehas chatukemaguk elpech chatoglu chalhwas.” ");
INSERT INTO apeB_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Jisas natulum nadukemu amamin tinytin ali naklipam nakli, “Aipo, sapos elpech chape anab nebebi amnab kantri uli chitak chunodiyagulmu chunek biob lainab ali chupe chulpak umu, enyebuk kantri eke kobi wata dodogowin umu chiyotu dadag chunek enechi enech echudak, wak. Eke chubihuk meyoh. Ali douk namudak ati. Ablabuk wabul o awilop douk chitak chunodiyagulmu chunek biob lainab ali chupe chulpak uli, echech eke kobi wata dodogowich umu chunek enechi enech echudak, wak. Eke chubihuk. ");
INSERT INTO apeB_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Ali douk namudak ati. Sapos Satan nitak nuhiyah enech ananichi sagabehas chutukemaguk elpech chutoglu chulhwos umu, namudak ananip awilop douk chanodiyagulmu chenek biob lainab. Namudak ali ananip awilop eke kobi dodogowich umu chunek enech echudak, wak. Eke chubihuk meyoh. ");
INSERT INTO apeB_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Sapos Bielsebul nagakome ali dakio yohiyah sagabehas umu, orait ipak pakli malmomu amudak ipakimi douk hagipech ipak uli. Omuni nyakam strong ali dakio hohiyah sagabehas? Ipakimi douk hanubu hagilapepamu enyudak ipak paklien umu pakli Bielsebul nagakomemu douk wo adulin e. ");
INSERT INTO apeB_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Ipak douk paulal. Yek douk God ananin Michin nyagakome dodogowiwe ali dakio yohiyah sagabehas chatukemaguk elpech chatoglu chalhwas. Ipak douk apatuliwe yenek enyudakmali ali padukemech umu nyultab ipak puwich agundak God nape nebenalimu ananich elpech umu douk abatoglu. ");
INSERT INTO apeB_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Sapos ananu alman nukli nunak nuwich ananu dodogowinali alman ananitu wilpat ali nukumech aluh ananich echudak umu, susubati anan eke nunek enyudak. Nusuh anudak alman nuwechikanu nunobuk nukus ali adakio nuwich nukumech aluh echudak chakus numun ananitu wilpat uli. ");
INSERT INTO apeB_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Echebuk elpech douk echech wak yekich uli e, echech douk yekich birua. Ali echebuk douk wo chugakomemu mulau elpech chunamali yek uli e, echech douk chapemu chenek yekich elpech chatukemeik chanak atin atiyuk. ");
INSERT INTO apeB_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Namudak ali douk yaklipepu. Ihenyumali douk elpech cheneken uli yowenyi nyanu cheagwlehen uli yowenyi balan, God anan douk eke wata nukwleyenyuk kobi nunohwen nupe, wak. Wakuli elpech douk chiyagwleh yowenyi balan umu enyudak God ananin Michin uli, anan douk eke kobi nukwleyenyuk, wak. Eke nunohwen nupe. ");
INSERT INTO apeB_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Elpech douk chiyagwleh yowenyi balan umu yek Anudak Alman yatoglu aduligeinyi elpen uli, God anan deke kobi wata nunosuh enyebuk echechin yowenyi nupe, wak. Wakuli elpech douk chiyagwleh enen yowenyi balan umu enyudak God ananin Michin uli, God eke kobi nukwleik enyebuk echechin yowenyi, wak. Nameitu douk eke nuhwen nupe aliga kwali.” ");
INSERT INTO apeB_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Jisas wata balan nyeilen ali nakli, “Yopinyi lowag douk eke yopipi chulkwip pil. Yowenyi eke yowepi pil. Elpech douk eke chutik chulkwip atip ali chudukemech umu enyudak lowag yopinyi o yowenyi. ");
INSERT INTO apeB_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Ali ipak douk panubu yowepali elpech pape kobi wanohwichi iguhumali. Ipak pakli deke piyagwleh yopinyi balan malmu? Ati wak. Elpech i save cheagwlehi enenyi enen nyape numun echechip ulkwip uli. ");
INSERT INTO apeB_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Yopichi elpech douk wolobainyi yopinyi tinytin nyape numun echechip ulkwip. Ali echech douk i save chenek yopinyi pasin. Yowechi elpech douk wolobainyi yowenyi tinytin nyape numun echechip ulkwip. Ali echech douk i save chenek yowenyi pasin. ");
INSERT INTO apeB_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Ali douk yaklipepu. Ahudak nyumnah kwotog gunenek ali God nunek skelumu elpech ahi, anan eke nusolik ihech elpech umu ihenyumali digin chokwin echech cheagwlehen uli hwalohwin meyoluhin balan. Ali echech douk eke chuklipanu bawogen umu balan umu agundak cheagwlehen umu. ");
INSERT INTO apeB_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","God eke numnek ipakin balan atin ali nunek skelumepu nukli ipak yopipali o yowepali elpech.” ");
INSERT INTO apeB_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Ali ababuk nyultab, anam henek skulumech umu lo uli hanu anam Farisi haklipu Jisas hakli, “Tisa, apak makli nyak nyunek enen God atunu neneken uli moul mutulin. Mutulin ali eke mudukemech umu nyak douk adul God nokogenyu nyanakili.” ");
INSERT INTO apeB_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Nemnek ali nebemom balan nakli, “Nameiteipali pape apudak atap uli elpech douk panubu yowepu. Panubu pokonoguk agabus God. Ipak douk pasolikemu inek enen God atunu neneken uli moul putulin, wakuli yek eke kobi inek enen, wak. Eke inek atin meyoh kobi enyudak seiwak nyatoglomu Jona uli atin putulin. ");
INSERT INTO apeB_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Seiwak anap takweipi yelbup poluk Jona ali nolu numun apapihw apahw umu bieh atuh nyumnegwih, biobus atub webus. Ali Yek Anudak Alman yatoglu aduligeinyi elpen uli eke inek namobuk ati. Eke ilu iwagu umu bieh atuh nyumneh, biobus atub webus. ");
INSERT INTO apeB_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Ahudak nyumnah God nunekumech kwot elpech ahi, echech abuldak nebebuli wabul Niniva douk eke chitak chunekumepu balan ipak doumeipali umu enenyi enen ipak peneken uli yowenyi. Umu monoken, echech douk chemnek God ananin balan douk Jona naklipechen uli, ali chekenyuk agabus yowenyi. Ali douk yaklipepu. Yek yanubu yechalakuk Jona uli douk yape agundak. ");
INSERT INTO apeB_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Chopuk kwali ahudak nyumnah God nunekumech kwot elpech ahi, okudak nebekwi almatok kwin kwapeli gani saut uli eke kwitak kunekumepu balan ipak doumeipali umu yowenyi ipak peneken uli. Umu monoken, okwok douk kwanubu kwapeli lougun, wakuli kwanakumali kumnek king Solomon ananin yopinyi save. Wakuli nameitu yek yanubu yechalakuk king Solomon uli douk yape agundak.” ");
INSERT INTO apeB_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Jisas wata chopuk nakli, “Abudak nyultab enen sagabu nyutukemaguk enen elpen abali, enyen douk eke nyunak nyulahe nyunak anagun abal wak umu nyunak nyupemali wikap. Enyen eke nyunak wakuli eke kobi nyugwatu anagun, wak. ");
INSERT INTO apeB_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Namudak ali eke wata nyukli, ‘Yek eke itanamu inamu yekitu wilpat douk likuk yapenyutali.’ Namudak ali enyen eke wata nyutanamu nyunak. Nyunakumagu, atudak wilpat eke nyutulutamu chagitatu ali chagabeyatu wohitu tape. ");
INSERT INTO apeB_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Ali eke wata nyutanamu nyunak nyulmali 7-poleich alagun sagabehas douk chanubu chenek yowenyi chechalakuk enyen uli. Douk chunaki ali eke chunen chupe atudak wilpat. Likuk enyudak elpen douk nyape yobelu kwalowi ati. Wakuli nameitu enyen eke nyunubu nyupe yobelu nyichalakuk kobi likuk nyalik nyapemu. Ipak yowepali elpech nameitu pape apudak atap uli douk eke punubu pupe yobelu kobi enyudak elpen umu.” ");
INSERT INTO apeB_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Jisas wata nape numun wilpat nape naklipech balan almom almagou ali ananik mamakik kwanu ananim owahlim chanak chatogloli cheyotu aduk. Ali chasolikech umu chunu anan Jisas chiyagwleh. ");
INSERT INTO apeB_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Ali enen elpen nyaklipanu nyakli, “Nya, nyakik mamakik kwanu nyakim owahlim chachi cheyotu aduk. Echech douk chakli chunenyu piyagwleh.” ");
INSERT INTO apeB_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Jisas nemnek ali nebemen balan nakli, “Yekik mamakik kwanu owahlim douk meichi?” ");
INSERT INTO apeB_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Ali nodukech heh echebuk douk chagipech anan uli ali nakli, “Yekik mamakik uli owahlim douk echudak. ");
INSERT INTO apeB_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Umu monoken, echebuk elpech douk i save chagipech yekinu Aninu nape iluh heven ananin laik uli, echech douk chanubu yekich owahlim o mehwoliyu o yekiyu mamaliyu.” ");
INSERT INTO apeB_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Ahudak atuh nyumnah Jisas natukemaguk wilpat natoglu nanak nape algasinyumu enyudak nebenyi raunwara. ");
INSERT INTO apeB_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Nanak nape ali chanubu wolobaichi elpech chanaki chowachabal chape agundak anan napemu. Natik namudak ali naitak nanak nalto nakih netemu anatu bot ali echech chanatimaguk cheyotu buknap. ");
INSERT INTO apeB_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Ali nape naklipech wolobainyi woblen balan. Nakli, “Ananu alman douk nanak umu nuwachak wit ananumu yawihas. ");
INSERT INTO apeB_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Nape nowachatu nanak ali anatu taglukuk yah ali almiguh hwanaki hwotahul hwatowoh. ");
INSERT INTO apeB_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Anatu tabih takus utabal umu. Amnab wak wolobaibi e, ali atat pupuwolotu takih wisnabul. ");
INSERT INTO apeB_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Wakuli nubaluh wo hlugluk atap e. Ahlaluh hlabih hletemaguk utabal ali wah hatu alitu. ");
INSERT INTO apeB_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Anatu taglukuk agundak naluh hlataglopi wichap ali pupuwolotu takih. Douk takih wakuli apudak wichap popakwilataguk. ");
INSERT INTO apeB_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Ali anatu douk taglukuk yopubi amnab ali pupuwolotu takih nebetali ali wolobaitali teil. Anatu teil 100-poleitu atutu ati biguhitu wit. Anatu teil 60-poleitu. Ali anatu 30-poleitu teil. ");
INSERT INTO apeB_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Ipak aligas sapenyipali imas pugamu pumnek yekin balan ali pugipechen.” ");
INSERT INTO apeB_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Jisas naklipech enyudak woblen balan iyuh ali ananim disaipel hanaki hasalikanu hakli, “Nyak nyeyagwleh woblen balan nyape nyaklipech balan echudak almom almagou umu monoken?” ");
INSERT INTO apeB_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Ali Jisas nebemom balan nakli, “Ipak, God douk anaklipepu bawogen umu enyudak nyonobechuk uli balan umu elpech chuwich agundak God nape nebenalimu ananich elpech umu. Wakuli echudak almom almagou douk wo nuklipech e, wak. ");
INSERT INTO apeB_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Namudak ali echebuk elpech douk chalau God ananin balan chadukemen kalbaluli, God eke wata nugamu nuklipech enen alagun ali eke chulau wolobainyi balan chunubu chudukemech kalbu. Wakuli elpech douk chanubu wo chudukemu God ananin balan uli e, enyebuk gwodin chahwen uli eke wata nunotulichen. ");
INSERT INTO apeB_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Echudak douk chatulich, wakuli chatulich uli echudak douk wo chugamu chudukemech e, wak. Balan chopuk chemneken, wakuli bawogen umu wo chudukemen e. Namudak ali douk yaklipech woblen atin balan umu douk namudak. ");
INSERT INTO apeB_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Echech douk chagimu ehudak ali enen balan seiwak profet Aisaia neyagwlehenyuk uli douk nyatoglu adulin atin. Balan enyudak. ‘Balan ipak eke pupemu pumneken, wakuli bawogen umu eke kobi pudukemen, wak. Putulugun umu eke pupemu putulugun, wakuli echudak eke kobi putik enech. ");
INSERT INTO apeB_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Umu monoken, echudak almom almagou echechigas balagas douk asechuk, achagah echechigas aligas, chowechik echechis nabes. Wakumomu, eke echechis nabes sutulugun ali chutik echudak, aligas tag sunakuk chumnek balan chudukemen, balagas sugal chudukemu bawogen umu balan ali eke wata chutanomumali yek igabeyech chupe kalbu.’ ");
INSERT INTO apeB_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Wakuli ipak douk iken punehilau. Umu monoken, ipak douk wosik patulugun patik echudak padukemech. Pemnek balan padukemen. ");
INSERT INTO apeB_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Aduligu atugu yaklipepu. Seiwak wolobaimi profet hanu wolobaichi duldulichi elpech douk chanubu chakli chutik enyudak moul douk ipak patulin uli. wakuli wak. Chopuk chaklimu chumnek enyudak balan nameitu ipak pemneken uli, wakuli wak.” ");
INSERT INTO apeB_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Ipak mnek. Nameitu eke iwolmepu bawogos umu enyudak woblen balan umu anudak nowachak wit gani yawihas uli. ");
INSERT INTO apeB_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Elpech douk chumnek enyudak balan umu elpech chuwich agundak God nape nebenalimu ananich elpech umu, wakuli echech wo chudukemen uli e, echech douk chape kobi atudak wit douk nowachotu uli nowachotu ali tanak tagluk agundak chalahemu uli. Echech douk chemnek God ananin balan nyape echechip ulkwip, wakuli Satan wata nanaki natulich enyudak balan nalawen nanakuk. ");
INSERT INTO apeB_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Ali wit douk tagluk agundak utabalumu uli, atat douk kobi echudak elpech douk chemnek God ananin balan ati ali chanubu chenehilaumen chalawen chakli wosik uli. ");
INSERT INTO apeB_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Echech douk chalawen, wakuli wo chuhwen dadag e, wak. Chahwen chagipechen banobu nyultab meyoh. Douk aligas umu enenyi enen hevi nyatoglomech o chenekech anagu anagamu agundak chasuh enyudak God ananin balan umu, ali wisnabul chatukemaguk echechin bilip. ");
INSERT INTO apeB_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Ali atudak wit douk nowachatu tanak taglukuk agundak naluh hlatoglopi wichap pakihumaluli, atat douk kobi echebuk elpech douk chemnek balan wakuli echechip ulkwip yowep umu enenyi enen apudak atapinyi nyanu jah uli mani ali chabouk enyudak balan nyabihuk. Ali echudak elpech douk wo chunek enen God ananin yopinyi pasin e, wak. ");
INSERT INTO apeB_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Wakuli atabuk douk nowachatu tagluk yopubi amnab uli, atat douk kobi elpech douk chemnek God ananin balan chadukemu bawogen umu ali chahwen chagipechen uli. Echech douk chenek wolobainyi yopinyi pasin kobi atudak biguhitu wit umu. Anatu douk 100-poleitu teil atutu ati biguhitu wit, anatu 60-poleitu teil, ali anatu douk teil 30-poleitu.” ");
INSERT INTO apeB_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Ali Jisas wata naklipech enen alagun woblen balan. Nakli, “Elpech chuwich agundak God nape nebenalimu ananich elpech umu douk kobi ananu alman nowachak yoputali ulibitu wit gani ananigu nohobigamu. ");
INSERT INTO apeB_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Nowachataguk ali nanak. Aliga wab chanatimaguk chechuh abali, ananu ananinamu birua nanaki nouluk analuh yoweluhi utaluh umu atudak yoputali wit ali nanak. ");
INSERT INTO apeB_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Aliga atudak wit tatoglu takih teleh tape teil, ali achatik ahludak yoweluhi utaluh chopuk hlakih. ");
INSERT INTO apeB_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Amudak henek moulamu noglemu agudak nohobigaluli hatik namudak ali hanaki haklipanu hakli, ‘Nebenyali alman, nyak douk nyowachakuk yoputali wit gani nyakigu nahabigu. Ali ahludak yoweluhi utaluh douk hlanaki malmu hlanaki hlatoglu?’ ");
INSERT INTO apeB_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Nemnek ali naklipam nakli, ‘Ananu yekinu birua nanaki nohluluk.’ Ali henemanu moul uli hasalikanu hakli, ‘Nyakli malmu? Munak mublaluhuk, waka?’ ");
INSERT INTO apeB_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Wakuli anan naklipam nakli, ‘Wak. Kedeke publaluh punak ali pukli wosik ati puwanip-amaguk wit. ");
INSERT INTO apeB_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Pukleyoluhuk hlunogu wit chutoglogu aliga wit tuh tukli tunodalu abali. Ababuk nyultab eke iklipu cheneme enyebuk moul umu chudalu wit uli namudak. Eke ikli, Pulik publak ahludak yoweluhi utaluh punutaluh umu unug umu eke hlunowehuk nyih. Ali wit adakio pudalatu punak putabuk atugun gani numun yekitu chubukitu wilpat.’” ");
INSERT INTO apeB_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Jisas wata naklipech kipainyi woblen balan nakli, “Elpech chuwich agundak God nape nebenalimu ananich elpech umu douk kobi onahw chokuhwi mastetihw nahw douk ananu alman nohwuhul nanak nawohw ananumu yawihas uli. ");
INSERT INTO apeB_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Ohudak nahw ohwohw douk hwanubu chokuhwi meyoh hwechalakuk hlanatimaguk naluh. Wakuli nawoh ali hwakihi hwechalakuk ihech echudak anan nawech yawihas uli. Hwakih hwonek nebenyi lowag ali almiguh hwanaki hwowemu logos yeguhwi-weinyumu.” ");
INSERT INTO apeB_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Jisas wata naklipech kipainyi woblen balan. Nakli, “Elpech chuwich agundak God nape nebenalimu ananich elpech umu douk kobi yis, douk onok almatok kwenyuhul kwautin umu plaua enen nebenyi dram ali kwonek blinu blanu aliga enyudak plaua nyanubu nyaitak nebenyi.” ");
INSERT INTO apeB_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Jisas naklipech enyudak nyanatimaguk balan echudak wolobaichi elpech ali naklipechen woblen atin. Wo nukli nuklipech enen meyoluh e, wak. Naklipechen woblen atin. ");
INSERT INTO apeB_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Anan douk naklipech woblen atin umu enen balan seiwak ananu profet nenyemaguk uli nyutoglu adulin atin. Balan douk enyudak. Nakli, “Yek eke ihul yokwatu iklipepu woblen balan. Eke iklipech balan umu enenyi enen seiwak God nokwalmu agudak nohobigamu nyonobechuk nyape aliga nameitu.” ");
INSERT INTO apeB_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Ali Jisas naitak natukemaguk echudak wolobaichi almom almagou chapeik ali nanak nawich wilpat. Nawich ali ananim disaipel hanaki hatulunu ali haklipanu hakli, “Apak makli nyuklipapu bawogen umu balan umu enyudak woblen balan umu yoweluhi utaluh hlatoglu yawihas uli.” ");
INSERT INTO apeB_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Ali nebemom balan namudak. Nakli, “Alman douk nowachak atudak yoputali wit nohobigaluli douk yek Anudak Alman douk yatoglu aduligeinyi elpen uli. ");
INSERT INTO apeB_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Agudak nahabigu douk apudak atap. Atudak yoputali wit douk echudak elpech douk achape chawich agundak God nape nebenalimu ananich elpech umu. Ahludak yoweluhi utaluh douk Satan ananich elpech. ");
INSERT INTO apeB_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Anudak birua nanaki nowachakuk yoweluhi utaluh uli douk Satan. Abudak nyultab wit tuh ali chupe chudalatu abali douk ahudak hugikuk uli nyumnah hutoglomu. Ali echudak douk chunek moulamu chudalu wit uli douk enselahas. ");
INSERT INTO apeB_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Kobi douk chablak ahludak yoweluhi utaluh chehleh nyih umu, ahudak hagikuk uli nyumnah hutoglomu douk eke chugimah namobuk ati. ");
INSERT INTO apeB_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Yek enyudak Aduligeinyi Elpen eke ikagasi yekich enselahas chunamali apudak atap. Chubihi ali eke chulawaguk ihechumali elpech douk i save chenek kipaichi elpech chapemu chenek yowenyili chunu chunatimaguk chenek yowenyili elpech. Chulawechuk ali kobi chunu God ananich elpech chupe atugun, wak. ");
INSERT INTO apeB_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Eke chulawech chunak atugun ali chuwachech chugluk ehudak nebebeh atihi nyih hunich. Hunich ali eke chuleh chuwih naluh chududalaluh. ");
INSERT INTO apeB_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Ali ababuk nyultab, echech duldulichi elpech eke chunubu chuhiyatik chupe gani echechinu Aninu ananich elpech chupemu. Ipak aligas sapenyipali imas pugamu pudukemen kalbu enyudak balan.” ");
INSERT INTO apeB_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Jisas wata naklipech enen woblen balan nakli, “Elpech chuwich agundak God nape nebenalimu ananich elpech umu douk kobi enen yopinyi enyudak douk chatalin nebebali atabal uli. Enech chobechuken nyolu anagu nahabigu ali ananu nanak nopalogen ali wata nagamu nechukalinyuk. Nanubu nenehilaumu enyudak yopinyi ali nanak nekech ihechumali ananich echudak kipahechi chatalich chokonoli utabal ali nanak natal agudak nahabigu.” ");
INSERT INTO apeB_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Jisas wata chopuk naklipech enen woblen balan nakli, “Chopuk elpech chuwich agundak God nape nebenalimu ananich elpech umu douk kobi ananu nenek bisnis uli alman nape naulimu anab sik banubu dudukab weyoub umu. ");
INSERT INTO apeB_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Naulimab nanak aliga nanak nogwatu ananu nanubu dudukanu chatalunu nebebali utabal uli. Ali nanak nekech chanatimaguk ananich echudak kipahech chatalich chakanu utabal. Chakanu ali nahwobol nanak natal anudak ananu sik dudukonu weyoun.” ");
INSERT INTO apeB_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Jisas balan nyeilen ali nakli, “Chopuk elpech chuwich agundak God nape nebenalimu ananich elpech umu douk kobi ananu umben douk howachanu nagluk raunwara ali ihagamali yomagu yeguh hwanaki hwatuk umu. ");
INSERT INTO apeB_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Hwanaki hwatuk aliga douk chukninu ali hatuk yeguh uli hasonukanu hanak algas. Hanak hatoglu ali ahape heyomoguh. Yopuguhwi hautuguh bagetog ali yoweguhwi howachaguhuk. ");
INSERT INTO apeB_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Ali ahudak hagikuk uli nyumnah hutoglomu douk eke namobuk ati. Enselahas eke chunaki chulawaguk yowechi elpech douk chanu yopichi chape uli. ");
INSERT INTO apeB_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Ali eke chulawech chunak atugun chuwachech chugluk ehudak nebebeh atihi nyih hunich. Hunich ali eke chuleh chuwih naluh chududalaluh.” ");
INSERT INTO apeB_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Ali Jisas nasolik ananim disaipel nakli, “Ipak wosik padukemen enyudak nyanatimaguk balan?” Ali haklipanu hakli, “Wosik madukemen wo.” ");
INSERT INTO apeB_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Ali naklipam nakli, “Hanatimaguk amabuk douk henek skulumech umu lo ali nameitu wata hanaki hagipech yek yenek skulumom umu elpech chuwich agundak God nape nebenalimu ananich elpech umaluli, amam douk hape namudak. Hape kobi ananu alman douk nanak nawich anatu jah hakusatali wilpat ali nohuli ananih namuhi hanu alihi jah. Douk nahuhul nalawah natogloli yopugunmu ali nagilapu elpech chatuluh.” ");
INSERT INTO apeB_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Jisas naklipech enyudak nyanatimaguk woblen balan umu julug, ali natukemaguk ablabuk wabul nanak. ");
INSERT INTO apeB_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Nanamu ananibul wabul. Nanak ali anape nenek skulumech naklipech yopinyi balan gani numun echechitu wilpat douk chape cheyagwleh balan atali. Douk chemnek ananin balan ali loguh hwonechlukech chakli, “Anudak alman nanak nalawali enyudak save agunmu? Enyudak God atunu neneken uli moul eke neneken nyatoglu malmu? ");
INSERT INTO apeB_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Ananinu aninu Josep douk madukemanu. Anan douk nenek moul nalok wilag uli. Ananik mamakik douk kwonohwalu Maria. Jems nanu Josep uli Saimon hanu Judas douk ananim owahlim. ");
INSERT INTO apeB_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Wanatimaguk ananiyu mehwoliyu douk wanu apak mape abuldak wabul. Ali enyudak nyanatimaguk douk nanak nalawenyi agnumu?” ");
INSERT INTO apeB_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Chakli namudak ali chokonoguk agabus. Wakuli anan douk naklipech nakli, “Ananu profet nanak ihalub kipailubi walub umu douk wosik i save chatuk ananin yeul nyakih. Wakuli ananibul wabul chanu ananigu nyulgu douk wak.” ");
INSERT INTO apeB_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Namudak ali douk wo nunek wolobainyi God atunu neneken uli moul ablabuk wabul e, wak. Umu monoken, echech douk wo chusuh ananin balan chukli adulin e. ");
INSERT INTO apeB_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Ali ababuk nyultab, Herot douk nape nebenalimu gavman umu enyudak provins Galili. Ali anan douk anemnek balan umu enyudak Jisas nape neneken uli. ");
INSERT INTO apeB_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Douk nemnek namudak ali naklipu ananim henekumanu moul uli nakli, “Aipo, anudak alman Jon douk nenek baptaisumech uli. Nobowokih yobleyanu lobik nagak chanugomonu ali nameitu douk anudak wata naitaki nape. Naitaki ali anan dakio dodogowinu atunu nenek enyudakmali moul.” ");
INSERT INTO apeB_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Susubati Herot natik ananinu owaninu Filip ananik almatok Herodias nahwok. Jon natik namudak ali naklipu Herot nakli, “Enyebuk douk nyablo lo, umu nyatulunu ananik almatok umu.” ");
INSERT INTO apeB_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Namudak ali Herot nowechikanu nenek kalabus napemu nakli nonu nugak. Wakuli wata elgeinomaguk echech Juda. Umu monoken, echech douk chenek tin chakli Jon anan douk ananu profet. ");
INSERT INTO apeB_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Anah nyumnah ali enech almom chanaki chanu Herot chape chenehilau ali ulkwip polomu ahudak nyumnah mamakik kwololi anan Herot umu. Ali ababuk nyultab, Herodias okwokik nugawik kwanaki kwape kweyolub kwanaki kwanak agundak chowachabal chapemu. Kwonek namudak ali kwonek Herot nanubu nenehilaumok. ");
INSERT INTO apeB_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Namudak ali nalimu iluh naklipok dodogowinyi balan umu monokech echebuk douk okwok kusolikonomech uli, anan douk eke nukokwech umu atugun. ");
INSERT INTO apeB_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Namudak ali kwanak kwanu okwokwik mamakik weyagwleh kwokokwi tinytin ali kwanaki kwaklipanu kwakli, “Yakli nameitu nyubleyanu lobik Jon douk nenek baptaisumech uli ali nyulali ananim boglom anatu plet nyunaki nyuke.” ");
INSERT INTO apeB_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Herot nemnek namudak ali ananihw apahw hwanubu yowehw. Nakli nukli wak, wakuli anan wata ulkum molomaguk agundak echudak nahwalech umu woligun uli blolu chape chemnek ali nalimu iluh naklipok dodogowinyi balan umu. Namudak ali naklipu amam soldia umu hunak huble Jon ali hulali boglom anatu plet hunaki hukok. ");
INSERT INTO apeB_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Namudak ali nenek balan nyanamu haus kalabus ali amam soldia haitak hobleyanu lobik Jon. ");
INSERT INTO apeB_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Hobleyanu ali boglom douk homloli anatu plet hanaki hoku okudak almatok Herodias okwokwik nugawik. Hokwok ali okwok wata kwalawom kwanak kwoku okwokwik mamakik. ");
INSERT INTO apeB_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Douk Jon ananim disaipel hemnek namudak ali hanaki honohul hanak hanugamanu. Hanugomanaguk ali hanak haklipu Jisas umu enyudak. ");
INSERT INTO apeB_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Douk Jisas nemnek balan umu agundak Jon nagak umu, ali wata nalau anatu bot natukemaguk ablabuk wabul nanak. Anan atunu nanak anagun wohigunmu douk elpech wak umu. Douk wolobaichi almom almagou chemnek namudak ali chatukemaguk echechilub walub chagipechanu chanak atapih. ");
INSERT INTO apeB_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Douk hanak hatoglu algas ali amam hetemu bot umu wata hanotu habih atap. Habih wakuli hatik echudak wolobaichi almom almagou. Ali Jisas nanubu nenelekech. Namudak ali nagabe agasudak senekechi elpech yopich. ");
INSERT INTO apeB_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Aliga douk wabigun halakatimu wab, ali ananim disaipel hanaki haklipanu hakli, “Nyumnah ahatuh ali agundak mapemu douk wohigunmu elpech wak umu. Anyuklipu echudak elpech chunamu walub umu chunak chunotol anagun chugnah uli woligun.” ");
INSERT INTO apeB_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Wakuli Jisas nebemom balan namudak. Nakli, “Iklipech chunak umu monoken? Chupe kadak ipak yet pukech kakwich.” ");
INSERT INTO apeB_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Hemnek ali haklipanu hakli, “Apak masuhwi 5-poleitu bret tanu bias yelbus meyoh.” ");
INSERT INTO apeB_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Ali naklipam nakli, “Aliga pulawechi punaki pukeyech agundak” ");
INSERT INTO apeB_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Ali naklipu echudak elpech umu chubih chupe wichap. Chabih chape ali nohul atudak 5-poleitu bret tanu asudak bias yelbus nahwech douk nepuhul natik iluh heven ali nenek tenkyumu God. Ali anape nagwuduk atudak bret noku ananim disaipel ali amam hanak hape hoku echudak elpech chatowah. ");
INSERT INTO apeB_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Halogech chanatimaguk chatowah ali dugolech. Ali amam disaipel hatulich hatalmu echudak chachoh chakus uli ali hechluk 12-poleig basketog chichuknig ati. ");
INSERT INTO apeB_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Ali echudak chawak woligun uli, almom atum douk hanubu hatoglu wolobaimi halakatimu 5,000-poleim. Almagou wanu batowich wo chudalehech e. ");
INSERT INTO apeB_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Douk chawak woligun umu julug, ali Jisas nakagas ananim disaipel henek wisnabul halto bot ali halik hanak woblahahinyumu enyudak raunwara. Anan douk wata neyotuk umu nukagas echudak elpech chunakuk iyuh. ");
INSERT INTO apeB_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Douk nokogech chanak chatuh ali anan atunu nanak nalto ananu maunten umu nukih nunek beten. Ababuk nyultab aun nape nabuh abali douk nanubu anan atunu napeik agnabuk. ");
INSERT INTO apeB_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Ali ababuk nyultab, amam disaipel hanak atali bot douk atanak tatoglu gani olokohun enyudak raunwara. Nebenali wihun naitaki nowanamu talik umu bot ali nohul nebebi molub batuk bape batu. ");
INSERT INTO apeB_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Douk aliga wab halakatimu gugluk ali Jisas nalahe nanaki chihah abal nanak natoglomomi. ");
INSERT INTO apeB_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Douk amam disaipel hatulunamu nolikwech nanaki chihah abal ali hanubu elgeim. Ali hakli, “Nyanyi enen sagabu.” Hanubu elgeim ali hohwalu nebegun atugun. ");
INSERT INTO apeB_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Wakuli wisnabul Jisas naklipamu nakli, “Aipo! Ipak kobi elgeipu, wak. Ipak imas dodogowipu. Enyudak douk yek wo.” ");
INSERT INTO apeB_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Ali Pita nakliponogu nakli, “Diginyali, sapos adul nyak umu, yek douk yakli nyuklipe ali ichogu chihahibol umu abal inakumogu nyak.” ");
INSERT INTO apeB_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Ali Jisas naklipanu nakli, “Yowi.” Pita nemnek douk natukemaguk bot ali nape nechichu chihahibal umu abal nanak umu nutik Jisas. ");
INSERT INTO apeB_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Wakuli natik umu wihun nanubu dodogowinu atunu ali elgeinu. Ali natik umu nape nagluk wakuli nahwalaguk nebegun nakli, “Diginyali, aliga gakome.” ");
INSERT INTO apeB_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Ali ahudak atuh Jisas nechuknu nahwonu ali naklipanu nakli, “Nyak wo nyugamu nyunek bilip umu yek e, wak. Nyak bien tinytin umu monoken?” ");
INSERT INTO apeB_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Douk hanak halto bot ali wihun nanubu nanak neiluk. ");
INSERT INTO apeB_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Amudak anam hetemu bot uli hatik namudak ali habih hoduk ohlubus hatuk ananin yeul nyakih. Ali haklipanu hakli, “Aduligu atugu wo. Nyak douk nyanubu God ananinyu Nuganinu.” ");
INSERT INTO apeB_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Douk hablo hanak enyudak raunwara ali bot tanak tatoglu teil algas gani woblaha-hinyumu raunwara enyudak distrik Genesaret. ");
INSERT INTO apeB_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Elpech chape ablabuk wabul uli chatik Jisas chadukemanu ali chenek balan nyanamu iholob walub blape halakatili. Chenemech balan ali chalawali chanatimaguk agasudak senekechi elpech chanamali Jisas. ");
INSERT INTO apeB_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Chalawechi ali chanalak chapemu Jisas umu nuklipech wosik ali agasudak senekechi chusuh algasih umu ananih lupah umu yopich. Ali chanatimaguk chasuh algasih umu ananih lupah uli douk yopich uli atich. ");
INSERT INTO apeB_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Ali ababuk nyultab anam Farisi hanu amudak anam henek skulumech umu God ananin lo uli hapeli Jerusalem ali hanaki hatik Jisas. Hanaki ali hasalikanu hakli, ");
INSERT INTO apeB_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Umu monoken ali nyakim disaipel hablo enyudak lo seiwak apakim bahlohwim hagipechen hanak ali nameitu douk apak magipechen uli? Amam douk wo huklupu wis ali adakio huwak woligun ati e, wak.” ");
INSERT INTO apeB_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Ali Jisas nebemom balan namudak. Nakli, “Namudak malmu, umu ipak i save pagipech ipakim yamem haklipe-peyenyuk uli pasin ali pablo God ananin lo umu? ");
INSERT INTO apeB_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Enen God ananin lo douk nyakli, ‘Ipak imas pupe chukamomu ipakich mamechich ali pumnek echechin balan pugakamech. Elpech douk chuklipech yowenyi balan echechich mamechich uli douk pech chugak.’ ");
INSERT INTO apeB_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Wakuli ipak i save pakli: ‘Sapos enen elpen nyubuk enech echudak chukus douk deke nyugakomu enyenyich mamechich umu, wakuli enyen nyitak nyuklipech nyukli, “Echudak douk deke iku ipak, wakuli wak. Ayaglahech umu God.” ’ ");
INSERT INTO apeB_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Ipak pakli namudak douk wosik. Pakli enyenyich mamechich, enyen douk kobi nyugakomech nyukech echudak douk anyaglahech umu nyuku God uli, wak. Ali tik. Ipak douk pagimeh namudak ali patukemaguk God ananin balan nyapeik pagipech ipakich yamech echechin. ");
INSERT INTO apeB_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Ipak penek loh uli. Seiwak profet Aisaia douk neyagwleh God ananin balan ali nanubu nenyemaguk duldul umu ipak. Balan enyudak. ");
INSERT INTO apeB_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","God nakli, ‘Echudak elpech echechig yowatog otug chatuk yekin yeul nyakih. Wakuli echechip ulkwip douk wo punubu pulomu yek e, wak. ");
INSERT INTO apeB_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Echech i save chaklipu kipahechi enyudak lo elpech meyoh cheneken uli ali chenek lohumech chakli enyen douk yekin. Douk namudak ali echech douk chenek lotume meyoh meyoh.’” ");
INSERT INTO apeB_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Jisas nahwalu echudak wolobaichi elpech chanaki agundak anan napemu ali naklipech nakli, “Ipak pugamu pumnek enyudak balan kalbu umu pudukemen. ");
INSERT INTO apeB_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Echudak douk elpech chachah yowatog uli, echech douk wo chunek elpech chunobosusih ali God nutulich nuhwalech yowechi e, wak. Wakuli enyudak cheagwlehen uli balan douk adul i save nyenekech chanobosusih.” ");
INSERT INTO apeB_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Ali ananim disaipel hanaki agundak anan napemu ali haklipanu hakli, “Nyak eke nyadukemech waka wak? Amam Farisi douk hemnek enyudak nyak nyeyagwleh-enyi balan ali apaluh yoweluh hakli waken.” ");
INSERT INTO apeB_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Ali Jisas nebemom balan naklipam enyudak woblen balan nakli, “Yekinu Aninu nape iluh heven uli douk nalib anagu nahabigu nau kakwich-agu. Ali ihech kakwich douk anan wo nuwech wakuli chakih meyoh uli douk eke nublachuk. ");
INSERT INTO apeB_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Ipak kwabukeyomuk amabuk Farisi. Amam douk hape kobi nabes sechukomi almom ali hakli hugilapech yah kipahechi elpech. Wakuli sapos ananu nabes sechukanali alman nukli nulik kipainali nabes sechukanalimu, amam biom alagun ati eke hunak hugoul hugluk bobigu.” ");
INSERT INTO apeB_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Ali Pita naklipu Jisas nakli, “Nya, klipapu bawogen umu enyudak woblen balan dokwechuh nyaklien uli.” ");
INSERT INTO apeB_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Ali Jisas naklipam nakli, “Ipak douk chopuk wo pudukemech e? ");
INSERT INTO apeB_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Ipak eke padukemech waka wak? Enechi enech pachah uli douk chagluk apaluh ali wata panak palkeyechuk. ");
INSERT INTO apeB_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Wakuli enenyi enen nyatoglali ipakig yowatog uli, enyen douk nyapeli ipakip ulkwip ali peyagwlehen nyatoglali. Ali nyenek elpech chanobosusih God natulich nahwalech yowechili douk akenyudakmoli. ");
INSERT INTO apeB_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Agagun douk gani numun ipakip ulkwip palik polomu enyudak enenyi enen yowenyi ali ipak dakio peneken. Enyudak. Enenyi enen yowenyi tinytin, chabo elpech chagak umu, chanosonukeh chanak hwaloh umu, chablo marit umu, chaku olugwih umu, chenek loh umu, chenek loh chakli kipahechi chenek yowenyimu. ");
INSERT INTO apeB_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Nyenek elpech chanobosusih ali God natulich nahwalech yowechili douk akenyudakmoli. Wakuli agundak umu kobi pitak puklupu wis ali adakio pusuh kakwich pichah umu eke kobi gnunekepu punobosusih ali God nutulipu nuhwalepu yowepali, wak.” ");
INSERT INTO apeB_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Jisas natukemaguk agnabuk ali nanamu kipaigunmu douk albudak biolub walub Taia uli Saidon blapemu. ");
INSERT INTO apeB_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Ali onok almatok echech Kenan douk kwape agnabuk. Okudak almatok kwanaki halakatimu Jisas ali kwohwalu nebegun kwakli, “O Diginyali, Devit ananinu Yamenu, nyak nyukli mapiliwe yek. Enen sagabu douk nyape yekik nugawik ali nyenekok kwanubu kwape sisahw.” ");
INSERT INTO apeB_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Okudak kwohwalu wakuli Jisas wo nuklipok enen balan e, wak. Ananim disaipel hanaki halakati ali hanalakumanu hakli, “Nyak nyuklipu okudak almatok kunak. Okwok douk kwagipechopoli ali wo kukli kusak umu agundak kwohwalomu e, wak.” ");
INSERT INTO apeB_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Amam haklipanu namudak ali natanomu naklipok nakli, “Aninu God douk nekege yanamali igakamu echech Isrel atich. Enech douk achatukemoguk God ali chape kobi chanak chawichuk uli sipsip umu. Kipahechi eke kobi igakomech, wak.” ");
INSERT INTO apeB_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Wakuli okwok kwanaki kwabih kwoduk ohlubus kwatau kwatik atap agundak anan neyotumu ali kwaklipanu kwakli, “Diginyali, yakli nyugakome wo.” ");
INSERT INTO apeB_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Ali Jisas wata nebemok balan nakli, “Namudak douk wo kalbamu muhul batowichich kakwich ali muwachech umu nubag gwichuhul gwichah e, wak.” ");
INSERT INTO apeB_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Wakuli kwaklipanu kwakli, “Diginyali, enyebuk adul. Wakuli nubag i save gwohul totokonigosich umu kakwich gwachah, douk chachah ali chenekech chaglukuk chukamu ogwogwinu nebenali ananin tebol uli.” ");
INSERT INTO apeB_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Jisas nemnek namudak ali nebemok balan nakli, “Nya, nyak douk nyanubu nyenek bilip umu yek. Namudak ali enyudak nyak nyaklimu inekenyumenyu uli douk yakli nyutoglomenyu.” Ali banubu ababuk nyultab okwokwik nugawik wata yopuk. ");
INSERT INTO apeB_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Jisas natukemaguk agnabuk nape nagimu algasinyumu enyudak raunwara Galili nanak aliga nanak nalto anatu nukut nakih nape. ");
INSERT INTO apeB_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Nakih nape ali wolobaibi lainab elpech chape chanaki agundak anan napemu. Chanaki ali chalawali ayas yowegasichi elpech, nabes sechukechi, loguh o ayasich biguh elketech uli, wo chiyagwleh atili e chanu wolobaichi anagali anagu agudak genekech uli. Chalawech chanaki chechubuk agundak Jisas napemu ali nagabeyech yopich. ");
INSERT INTO apeB_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Nagabeyech ali elpech chatik umu wo chiyagwleh atili e wata cheagwleh, loguh uli ayasich biguh elketech uli wata yopich chape duldul, ayas yowegasichi chalahe, nabes sechukechi chatulugun. Chatik namudak ali kluk chanakuk. Ali chatuk echech Isrel echechinu God ananin yeul nyakih. ");
INSERT INTO apeB_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Jisas nahwalu ananim disaipel hanaki agundak anan napemu ali naklipam nakli, “Chanaki chane mape ali yakli mapilich echudak elpech. Umu monoken, echech douk chane mape bieh atuh nyumneh ali kakwich wakech. Ali douk yakli wak umu nyulub blech ali ikegech chunamu echechilub walub, wak. Kedeke chunak yah yomotog gwilech ali chugoul.” ");
INSERT INTO apeB_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Ali amam disaipel haklipanu hakli, “Agundak mape wohigunmu elpech wak umu. Namudak ali bret eke munak muhuli anatu agnumu, umu munaki muku echudak wolobaichi elpech chutowoh tunokwnumech ulimu?” ");
INSERT INTO apeB_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Jisas nemnek ali nasalikam nakli, “Ipak pasuhi makwnitu bret?” Ali haklipanu hakli, “7-poleitu bret tanu gwodus chokusi yelbus.” ");
INSERT INTO apeB_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Ali Jisas naklipu echudak wolobaichi elpech chabih chape atap. ");
INSERT INTO apeB_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Ali nohuli atudak 7-poleitu bret tanu yelbus nahwech ali nenek tenkyumu God. Ali anape nagwudukech noku amam disaipel ali amam hanak hape habilomu echudak elpech. ");
INSERT INTO apeB_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Chanatimaguk chachah dugolech ali chakusuk uli douk hatulichech hechluk 7-poleig basketog ali chichuknig. ");
INSERT INTO apeB_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Elpech chawak agundak woligun uli, almom atum douk hanubu wolobaimi 4,000-poleim. Almagou wanu batowich wo chudalehech e. ");
INSERT INTO apeB_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Jisas nakagas echudak elpech chanakuk ali nanak nalto bot nanamu enyudak distrik Magadan. ");
INSERT INTO apeB_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Amam Farisi hanu Sadyusi hanaki agundak Jisas napemu ali hakli hichakama-namu nunek enen God atunu neneken uli moul. Umu hakli hutulin ali hukli anan douk adul God nakaganu nanakili. ");
INSERT INTO apeB_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Wakuli nebemom balan namudak. Nakli, “Abudak nyultab nyumnahinu aun nanak nabih abali, ipak i save pakli, ‘Kaman eke gugluk echah wak. Umu monoken, utagu douk gauh.’ ");
INSERT INTO apeB_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Chopuk agliguh abali, ipak i save pakli, ‘Doumeih eke wihun nulu ali echah hulali. Umu monoken, aun douk nakihi ouchibal blataku ali utagu ganubu behlab beil meyoh.’ Ipak i save patik utagu ali padukemech umu agundak wah hutau o echah hulomu. Wakuli moul douk nameitu ehudak nyumneh yek yeneken nyatoglu patulin uli, ipak douk patulin ali wo pudukemen e, wak. ");
INSERT INTO apeB_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Doumeipali pape apudak atap uli elpech douk panubu yowepu. Panubu pokanu agabus God. Ipak douk pasolikemu inek enen God atunu neneken uli moul putulin, wakuli eke kobi inek enen alagun, wak. Eke inek atin meyoh kobi enyudak seiwak nyatoglamu Jona uli atin putulin.” ");
INSERT INTO apeB_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Jisas nanu ananim disaipel halau bot ali hablo hanak gani woblahah enyudak raunwara. Hape hanak ali amam disaipel wata ulkwip pologuk umu dokwechuh haitaki wo husuhwi anatu bret umu e. ");
INSERT INTO apeB_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Ali Jisas naklipam nakli, “Ipak pugamu punenek yologimu amam Farisi hanu Sadyusi amamis yis.” ");
INSERT INTO apeB_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Douk ananim disaipel hemnek ali amam yet hape heneyagwleh hakli, “Anan douk nakli enyudak balan umu yis umu monoken, apak douk maitaki wo nusuhwi anatu bret e, wak.” ");
INSERT INTO apeB_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Jisas natulum nadukemech ali nasolikam nakli, “Ipak pape peyagwleh pakli ipak douk bret wokepamu monoken? Ipak ati panubu wo punek bilip umu yek e, wak. ");
INSERT INTO apeB_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Ipak padukemech waka wak? Nubuwokih douk yekech 5-poleitu chokutali bret chanubu wolobaichi 5,000-poleich almom chatowah. Ali tenek lep takus uli douk eke patolmotu potoluk makwnig basketog? ");
INSERT INTO apeB_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Ahudak anah douk yokam 7-poleitu mudu-madutali bret wolobaimi 4,000-poleim alman hatowah totukle tatau ali douk eke patolmotu potoluk makwnig basketog? Yakli enyudak eke patulin ulkwip polomen waka wak? ");
INSERT INTO apeB_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Monoken nyenekepu, umu wo pudukemu yaklipepu enyi balan umu e? Yek douk wo iklipepamu bret e, wak. Yaklipepamu punek yologimu amam Farisi hanu Sadyusi amamis yis.” ");
INSERT INTO apeB_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Douk amam disaipel hemnek namudak ali ahadukemech umu anan douk wo nuklipam umu hunek yologimu asudak adulis yis douk chautus bret taitak ulimu e, wak. Wakuli anan douk naklipam umu hunek yologimu amam Farisi hanu Sadyusi amamin balan. ");
INSERT INTO apeB_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Jisas nanu ananim disaipel hanak hatoglu halakatimu wabul Sisaria Filipai ali natanomu nasalikam nakli, “Elpech chakli Yek Anudak Alman yatoglu aduligeinyi elpen uli douk meiweli?” ");
INSERT INTO apeB_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Hemnek ali hebemanu balan hakli, “Enech chakli nyak Jon douk nenek baptaisumech uli. Enech chakli nyak Ilaija. Enech chakli anudak profet Jeremaia o ananu amudak anam profet.” ");
INSERT INTO apeB_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Ali Jisas nasolikam nakli, “Ali Ipak pakli yek douk meiweli?” ");
INSERT INTO apeB_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Ali Saimon Pita nebemanu balan nakli, “Nyak douk nape eheh nyumneh uli God ananinyu nuganinu. Nyanubu anudak alman Krais, douk God natalihenyu ali nokogenyu nyanamali nyunalau elpech uli.” ");
INSERT INTO apeB_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Jisas nemnek ali naklipanu nakli, “Saimon, Jon ananinu nuganinu, nyak wosik nyunehilau. Umu monoken, nyak douk wak enech apudak atapichi elpech chuklipenyu enyudak balan e, wak. Yekinu Aninu nape iluh heven uli naklipenyu ali dakio nyadukemech. ");
INSERT INTO apeB_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ali yaklipenyu. Nyak douk Pita. Chanatimaguk yekich elpech douk eke ichemu chihah nyak okudak bulbuduk. Ali enyudak strong umu chagak umu eke kobi dodogowin umu nyubo echudak yekich elpech chubihuk, wak. ");
INSERT INTO apeB_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Yek douk eke ikenyu echudak kihas umu nyulau namba umu nyijik dua douk elpech chuwich agundak God nape nebenalimu ananich elpech umu. Echebuk douk nyak nyukli wosik umu echech chuwich uli, God eke nunekumech namudak ati gani iluh heven. Echebuk nyak nyukli wak umu echech chuwich uli, orait God nape iluh heven uli chopuk eke nugimohumech namobuk ati.” ");
INSERT INTO apeB_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Ali Jisas naklipam dodogowinyi balan ananim disaipel. Naklipam umu kobi hunak huklipu enech elpech umu anan douk anudak alman Krais douk God natalihanu ali nakaganu nanamali nunolau elpech uli, wak. ");
INSERT INTO apeB_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Hanubu ahabuk atuh nyumnah Jisas anape naklipam bagalu ananim disaipel nakli, “Yek imas inamu Jerusalem. Inak ali echech Juda echechim nebemi hunu amam douk henek skulumech umu lo uli hunu nebemi pris eke huneke anagu anagu ilau nebehi nyih. Ali eke he igak. Igak aliga hukli bieh atuh nyumneh umu, yek eke wata itak ipe.” ");
INSERT INTO apeB_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Namudak ali Pita nalmonu hanakuk algas ali nape nahanu nakli, “Diginyali, enyebuk tinytin yakli chokubul nyutukemenyuk meyoh. Yakli wak umu enyebuk nyutoglomenyu, wak.” ");
INSERT INTO apeB_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Jisas nemnek ali natanomoguk. Ali naklipu Pita nakli, “Satan, nubu kaleik. Nyak douk nyakli nyublome yah. Enyebuk douk wo nyugipech God ananin tinytin e, wak. Nyagipech elpechin tinytin meyoh.” ");
INSERT INTO apeB_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Ali Jisas naklipu ananim disaipel namudak. Nakli, “Sapos enen elpen nyukli nyusuh yekin balan dadag nyugipech yek umu, susubati enyen imas ulkum mukenyuk umu enyen yet. Enyen kobi nyugipech enyenyin laik, wak. Ali enyen douk kobi elgein umu kipahechi chen nyugak ali imas nyuhul enyenyin lowag kruse nyinyusah ali nyugipeche. ");
INSERT INTO apeB_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Umu monoken, elpen douk ulkum mulomu enyen yet umu nyukli nyunubu nyupe uli, enyen douk eke nyunak nyuwichuk. Wakuli elpen douk nyunek tin umu nyugipech yek ali ulkum mukenyuk umu nyupe uli, enyebuk elpen eke wata nyunubu nyupe kalbu. ");
INSERT INTO apeB_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Sapos enen elpen nyunokwalmu ihechumali apudak atapichi echudak aliga enyen wata nyugak umu, orait echudak nyokwalmech uli eke wata chugakomen malmu? Echudak douk enyen nyutal enyenyis yapis umu wata nyitak nyupemu douk chanubu wak enech e, wak meyoh. ");
INSERT INTO apeB_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Yek Anudak Alman yatoglu aduligeinyi elpen uli eke inali yekich enselahas munaki. Eke ipe dodogowiwe otuwe inubu ihiyatiki kobi yekinu Aninamu ali inaki. Inaki ali eke ikech pe chanatimaguk elpech nyunokwnumu enenyi enen echech cheneken uli pasin. ");
INSERT INTO apeB_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Adul ati yaklipepu. Enepu peyotu agundak uli eke kobi kebes pugak ali eke putik Yek Anudak Alman yatoglu aduligeinyi elpen uli eke ipeli nebeweli king ali inaki ipe nebewelimu yekich elpech.” ");
INSERT INTO apeB_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","6-poleih nyumneh hanak hadiyuk ali Jisas nalumu Pita nanu Jems hanu Jems ananinu owaninu Jon ali nalikam amam atum hanak halto ananu nanubu lounali maunten. ");
INSERT INTO apeB_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Hanak hakih ali hatik Jisas nanubu nenek senis napeik anagun sik. Ananin domanyu nyanubu nyehiyatik nyape kobi nyumnahinu aun umu. Nehloluli luseh douk hanubu hatoglu chogolihwih kobi anatu lait umu. ");
INSERT INTO apeB_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Hape hatik Jisas, wakuli ahudak atuh hatik Moses nanu Ilaija hatoglu heyotu hape hanu Jisas heagwleh. ");
INSERT INTO apeB_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Douk Pita natik namudak ali naklipu Jisas nakli, “Diginyali, enyen douk kalbu apak mape agundak. Sapos nyak nyukli wosik umu, yek eke iwemumepu biou otuk chomeguhwiyu. Nyak onok ali biou umu Moses uli Ilaija.” ");
INSERT INTO apeB_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Pita watak nape neyagwleh ati ali onog gwanubu gwaglak uli olug gwanaki gweyawiyomuk. Ali anagu nigu ganaki ogudak olug uli gakli, “Anabuk nanubu yekinu Nuganinu. Yek douk ulkum manohwanu ali yenehilau-manu. Ipak douk pumnek ananin balan.” ");
INSERT INTO apeB_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Amam disaipel hemnek enyudak balan ali hanubu elgeim. Elgeim ali habih hogohwebil wahegas satik atap hakus namobuk. ");
INSERT INTO apeB_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Jisas nanaki halakati nowemeyom wis ali naklipam nakli, “Kitak, ipak kobi elgeipu, wak.” ");
INSERT INTO apeB_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Douk haitak hatulugun ali wo hutik anam alagun hiyotu e, wak. Hatik Jisas atunu. ");
INSERT INTO apeB_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Douk hatukemaguk iluh maunten wata hape hagluk ati ali Jisas naklipam dodogowinyi balan nakli, “Kobi punak puklipu enech umu enyudak dokwechuk patulin uli, wak. Nyulomaguk ipak atipu aliga chubo Yek Anudak Alman yatoglu aduligeinyi elpen uli igak wata itak ipe ali ipak adakio puklipech-umen.” ");
INSERT INTO apeB_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Ali amam disaipel hasalikanu hakli, “Ali namudak malmu, umu amam henek skulumech umu lo uli i save haklimu? Hakli Ilaija imas nuliki ali Krais eke adakio nutoglomu?” ");
INSERT INTO apeB_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Ali Jisas nebemom balan nakli, O adul. Ilaija imas nunaki ali wata nugabe ihechumali echudak umu yek inakumali. ");
INSERT INTO apeB_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ali douk yaklipepu. Ilaija douk ananaki, wakuli echech nebemi wo chudukemanu e, wak. Chape chagipech echechin laik ali chenekanu anagu anagu. Ali namudak ati. Yek Anudak Alman douk yatoglu aduligeinyi elpen uli eke chuneke anagu anagu namudak ati imnek nyih.” ");
INSERT INTO apeB_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Amam disaipel hemnek ali hadukemech hakli anan douk naklipam umu Jon douk nenek baptaisumech uli. ");
INSERT INTO apeB_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Jisas nanu amudak biom atunu disaipel hagluki maunten ali hanak hatoglomu wolobaichi elpech. Hatoglu ati, ananu alman nanak nabih noduk ohlubus natau agundak Jisas neyotumu. ");
INSERT INTO apeB_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","Ali naklipu Jisas nakli, “Diginyali, yek yakli nyak nyunelek yekinu nuganinu ali nyugabeyanamu yopunu. Anan douk owotu tonoul ali nanubu nalau nebehi nyih. Wolobaihi i save tonoul nagak nagluk nyih hanu abal. ");
INSERT INTO apeB_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Yalawonamu nyakim disaipel ali wo dodogowim umu hugabeyanu e, wak.” ");
INSERT INTO apeB_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Ali Jisas nebemanu balan nakli, “Ipak doumeipali elpech douk panubu wo punek bilip umu yek e, wak. Ipak douk papemu penek yowenyi ali ipakin tinytin wo nyulu duldul e. Ipak pakli yek eke wata inepu mupe loubomu ipe igakamepu namudak ati isahumepu enenyi enen hevi, waka? Aliga laweyonomeli agundak anabuk nuganinu.” ");
INSERT INTO apeB_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Chalawonoli ali Jisas nahu enyudak nyapenyunali sagabu ali nyatuke-managuk. Ali banubu ababuk atubu nyultab anan nanubu yopunu. ");
INSERT INTO apeB_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Douk nenek enyudak nyanakuk ali amam disaipel atum hanakumali Jisas ali hasalikanu hakli, “Apak douk mabilak wo dodogowipamu muhiyahuk atudak owotu e umu monoken?” ");
INSERT INTO apeB_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Nemnek ali naklipam nakli, “Ipak douk panubu wo pugamu punek bilip umu yek e, wak. Aduligu atugu yaklipepu. Sapos ipakin bilip nyutoglu kwalowi nebenyi kobi onoh chokuhwi mastetih nahw umule, ipak deke puklipu atudak nukut pukli, ‘Aliga kitak kalemu gani,’ ali adul ati atat eke tunubu titak tunak. Adul, enechi enech echudak deke punekech uli atich.  ");
INSERT INTO apeB_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Wakuli echudakmali sagabehas douk yah wak umu muhech chutoglamaguk. Apak douk atuh yah meyoh umu munek tabumu kakwich eneh nyumneh ali mupe munek beten umu atuh. ");
INSERT INTO apeB_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Abudak nyultab hanatimaguk disaipel hanaki atugun enyudak provins Galili abali, Jisas naitak naklipam nakli, “Enech douk eke chugilapu yekim birua Yek Anudak Alman yatoglu aduligeinyi elpen uli ali amam eke huhwe hunak he igak. ");
INSERT INTO apeB_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Amam eke hunak he igak, wakuli hukli bieh atuh nyumneh umu, yek eke wata itak ipe.” Amam disaipel hemnek enyudak balan ali apaluh hlanubu yoweluh. ");
INSERT INTO apeB_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Jisas nanu ananim disaipel hanak hatoglu wabul Kapaneam ali amam halau tagis umu God ananitu nebetali wilpat uli hanakumali Pita ali hasalikanu hakli, “Ipakinu tisa nenek tagis nobuk utabal umu God ananitu nebetali wilpat o wak?” ");
INSERT INTO apeB_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Ali Pita nebemom balan nakli, “O wosik nenek tagis.” Douk aliga Pita nanak nawich wilpat ali Jisas nalik nasolikanu nakli, “Saimon, nyak nyakli malmu? Apudak atapimi nebemimu gavman uli douk meichi elpech i save chatal kastan chokom utabal o chenek tagis chokom? I save halau tagis kipahechi o amamich batowich?” ");
INSERT INTO apeB_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Ali Pita naklipanu nakli, “Kipahechi.” Ali Jisas naklipanu nakli, “Namudak ali amamich batowich douk kobi chunek tagis chukom, wak. ");
INSERT INTO apeB_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Wakuli apak douk makli wak umu munek echudak elpech nyihihichich umu apak, wak. Namudak ali aliga nyunamu nebenyi raunwara nyunek huk. Susubeip nyutukapili yelbup douk nyuhwop nyichiglak yokwatu ali eke nyugwatu anam utam mani douk molu. Amabuk utam douk eke munoknumu ohwak biohu umu wunek tagis umu. Nyumahu ali nyunak nyunek tagis nyukomuk.” ");
INSERT INTO apeB_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Ali ababuk nyultab, amam disaipel hanamali Jisas ali hasalikanu hakli, “Omuni eke nyupe nebenyi agundak God nape nebenalimu ananich elpech umu?” ");
INSERT INTO apeB_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Jisas nemnek ali nahwalu enen batowin nyanaki. Ali nalawen nenyosopu nyeyatu olokohun umu amam. ");
INSERT INTO apeB_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Ali naklipam nakli, “Aduligu atugu yaklipepu. Sapos ipak kobi punek senis putukemaguk enenyi enen yowenyi ali kobi putoglu kobi chokwichimu, ipak eke kobi puwich agundak God nape nebenalimu ananich elpech umu, eke wak. ");
INSERT INTO apeB_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Elpen douk nyunubu nyunek daunim umu enyen yet nyupe kobi enyudak chokwinyi batowin uli, enyen eke nyunubu nyupe nebenyi agundak God nape nebenalimu ananich elpech umu. ");
INSERT INTO apeB_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Ali meichi elpech douk ulkwip pulamu yek ali chugakamu enen batowin kobi enyudak umu, echech douk chagakomu yek.” ");
INSERT INTO apeB_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Jisas balan nyeilen ali nakli, “Sapos enen elpen nyunek enen echudak chokwichi batowich douk nyenek bilip umu yek uli nyunek enen yowenyimu, enyudak douk nyanubu nyenek yowenyi. Ali sapos chuhwen chusoh anam nebemi utam enyenyik lobik ali chuwachen nyugluk lougumu yous ele, enyen deke nyupe sisahw kwalowi ati. Wakuli namudak eke wak. ");
INSERT INTO apeB_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Mapilich apudak atapichi elpech douk chapemu chenek elpech chenek yowenyili. Adul, enenyi enen yowenyi imas nyutoglu, wakuli mapilich echebuk elpech douk chuneken nyutogloluli.” ");
INSERT INTO apeB_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Ali naklipech enen woblen balan. Nakli, “Sapos ipak enen enyenyis wis o yolihw nyunekenyu nyunek enen yowenyimu, orait nyak imas nyubleyech nyuwachechuk meyoh. Enyudak douk kalbamu atus ati wis o yoliluh chupemepu ali pupe kalbu eheh nyumneh. Kedeke pukli biech chupemepu atimu, ipak eke chuwachepu pugluk nyih douk hanu hape eheh nyumneh uli. ");
INSERT INTO apeB_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Ali sapos anap nyakip nabep punekenyu nyunek enen yowenyimu, orait nyak nyunubu nyutukapuk meyoh. Enyudak douk kalbamu atup meyoh pupemenyu ali nyupe kalbu eheh nyumneh. Kedeke nyukli bias supemenyu atimu, nyak eke chuwachenyu nyugluk nyih douk hanu yowebuli wabul hel uli.” ");
INSERT INTO apeB_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Jisas balan nyeilen ali nakli, “Ipak punenek yologi. Eke pukli pichogeik enen echudak chokwichi batowich. Adul ati yaklipepu. Echechich enselahas douk wihluwehlu chanopemu chape agundak yekinu Aninu napemu gani iluh heven.”  ");
INSERT INTO apeB_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Yek Anudak Alman yatoglu aduligeinyi elpen uli douk yanakimu igakamu chanak chawichuk uli elpech umu inalawech chutanomali chupe kalbu. ");
INSERT INTO apeB_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Jisas balan nyeilen nakli, “Sapos ananu alman nunokech 100-poleich sipsip ali enen nyunak nyuwichuk ele, ipak pakli deke nunek malmu? Adul ati, anan deke nutukemaguk echudak enech 99-poleich chiyotuk anatu nukut ali wata nutanamu nunak nulimu enyudak atin douk nyanak nyawichuk uli. ");
INSERT INTO apeB_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Aduligu atugu yaklipepu. Abudak nyultab nunak nugwaten abali, anan eke nunubu nunehilaumen nichalakuk kobi nenehilaumu echudak enech 99-poleich douk wo chunak chuwichuk ulimu e. ");
INSERT INTO apeB_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Ali douk namudak ati. Ipakinu Aninu nape iluh heven uli douk nanubu nakli wak umu enen echudak chokwichi batowich nyunak nyuwichuk, wak.” ");
INSERT INTO apeB_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Jisas balan nyeilen nakli, “Sapos enen ipakinyi elpen nyunek enen yowenyimu enen ipak yekipalimu, orait nyak nyunubu nyunamu enyebuk elpen, ipak atipu pupe ali nyugilapen yowenyi douk enyen nyeneken umu nyak uli. Sapos enyen nyumnek nyakin balan umu, orait nyak douk anyagabeyen nyalawen nyatanomali nyape kalbu. ");
INSERT INTO apeB_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Wakuli sapos enyen kobi nyumnekenyamu, orait nyitak nyutukulmu atin o biech elpech alagun chilenyu umu ipak punatimaguk puklipen umu nyumnek ali nyutukemaguk enyenyin yowenyi. ");
INSERT INTO apeB_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Wakuli sapos enyen nyukli wak umu nyumnekepamu, orait puklipu chanatimaguk God ananich elpech. Puklipech ali enyen chopuk nyukli wak umu nyumnek echech alagun umu, orait ipak iken putulin pukli enyen douk nyaduk echech wo chudukemu God uli e chanu amudak halau tagis uli almom. ");
INSERT INTO apeB_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Adul ati yaklipepu. Ihenyumali yowenyi douk elpech cheneken ali ipak puhwen pupe dadag apudak atap uli, God chopuk eke nuhwen nupe dadag gani iluh heven. Ali ihenyumali yowenyi douk elpech cheneken ali ipak kobi puhwen pupe apudak atap uli, God chopuk eke kobi nuhwen nupe gani iluh heven, wak. ");
INSERT INTO apeB_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Ali douk yakli iklipepu alagun. Sapos biepu pape apudak atap uli punubu atip ulkwip umu pukli pulau enech echudak ali punek beten umu pulawech umu, orait yekinu Aninu nape iluh heven uli eke nukepeyech umu atugun. ");
INSERT INTO apeB_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Sapos biech o biech atin elpech chunak chuwachabal chupe anagun ali ulkwip pulomu yek umu, orait yek douk chopuk yanech mape.” ");
INSERT INTO apeB_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Pita nanakimu Jisas ali nasolikanu nakli, “Diginyali, sapos enen yekinyi nyupemu nyunek enen yowenyimu yek umu, orait yek eke kobi wata isuh enyudak enyen nyenekenyume uli yowenyi ali ikwuleyenyuk makunih? 7-poleih ati, waka?” ");
INSERT INTO apeB_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Ali Jisas naklipanu namudak. Nakli, “Yek douk wo iklipenyamu 7-poleih ati e, wak. Yakli wolobaihi 490-poleih wosik.” ");
INSERT INTO apeB_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“Nyak mnek. Elpech chuwich agundak God nape nebenalimu ananich elpech umu douk kobi enyudak pasin ananu king neneken ulimu. Anan nape ali nakli nuklipu ananim henemanu moul uli umu hubemanu nosog. ");
INSERT INTO apeB_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Anan douk anapemu hunaki hugabe balan ali chalawali ananu douk nenek dinaumanu nebebali utabal 10 milion kina uli. ");
INSERT INTO apeB_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Chalawanali ali anan wo dodogowinamu nube enyudak nebenyi dinau e, wak. Namudak ali ananinu nebenali nakli, ‘Anudak alman nunu okwok kwunu batowich chunu ihechumali echechich echudak eke kipahechi chutalich. Chutalich umu chunemech moul meyoh ali utabal chutalich umu eke blunamu ananin dinau.’ ");
INSERT INTO apeB_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Anudak nenek moulamu king uli nemnek namudak ali nanak nabih noduk ahlubus halakatimu anudak king ali naklipanu nakli, ‘Nya, nyak nyuneleke ali nyupe nyunobuke yalup meyoh. Dinau eke ibeyen iyatenyumenyu.’ ");
INSERT INTO apeB_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Ananinu nebenali natik namudak ali nanubu nenelekanu. Ali naklipanamu dinau anyeneken nyugakuk meyoh. Ali nokleyonoguk nanak. ");
INSERT INTO apeB_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Anudak nenek moulamu king uli natoglu aduk ali nogwatu ananu amam atin moul umu. Anan douk nenekanu dinau gwodubal utabal 10 kina ati. Natoglu nogwatonu ali nanubu nape nasuhwonu lobik ali nakli, ‘Aliga beme utabal likuk nyenek dinaumobol yek uli.’ ");
INSERT INTO apeB_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Anudak amam atin moul umu nemnek ali nanubu nabih noduk ohlubus natau atap ali nasolikanu nakli, ‘Nya, nyak nyuneleke ali yakli nyupe nyunobuke yalup meyoh. Abalabuk utabal eke ibeyabalumenyu.’ ");
INSERT INTO apeB_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Naklipanu namudak wakuli anan nakli wak umu numnekanu. Nanubu nalawanu nanak nowechikanu nape haus kalabus umu nubemanu dinau aliga niyatenyumanu. ");
INSERT INTO apeB_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Douk amudak anam amam atin moul umu hatik enyudak ali amamiluh apaluh hlanubu yoweluh. Ali hanak haklipu amaminu nebenalimu ihenyumali anudak neneken uli. ");
INSERT INTO apeB_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Nemnek ali nahwalu anudak nenemanu moul uli. Douk nanaki ali naklipanu nakli, ‘Nyak nyanubu enenyu yowenyali nyenek yekin moul. Tik, susubati nyak nyanaki nyeleh nyablome ali yakli nyakin nebenyi dinau nyunubu nyugakuk meyoh. ");
INSERT INTO apeB_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Yek douk yenelekenyu. Ali malmu namudak, umu nyak chopuk wo nyunolek anudak ipak atin moul umu e?’ ");
INSERT INTO apeB_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Anudak ananinu nebenali nanubu nyihihichinu ali naklipu amudak henek was umu kalabus uli umu hulawanu hunak huwechikanu nupe numnek nyih aliga nube enyudak nebenyi dinau niyaten iyuh. ");
INSERT INTO apeB_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Namudak ali sapos ipak atunu ati enech ipakichi elpech chunekumepu enen yowenyimu, orait ipakip ulkwip imas pukli adulin atin ali pukleyenyuk kobi punohwen pupe, wak. Sapos wak umu, orait yekinu Aninu nape iluh heven uli eke nugimehumepu namudak ati” ");
INSERT INTO apeB_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Jisas naklipech enyudak balan neyaten ali natukemaguk enyudak provins Galili nanak. Nanamu enyudak enen provins Judia gani woblahahibamu wolub Jodan. ");
INSERT INTO apeB_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Nanak ali chanubu wolobaichi elpech chagipechanu chanak agnabuk. Ali nagabe agasudak senekech uli elpech yopich. ");
INSERT INTO apeB_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Ali anam Farisi hanakumali Jisas umu hichakama-namu enen balan. Hanaki ali hakli, “Apakin lo wosik nyaklimu ananu alman iken nunek julugumu ananik almatok umu enen hwalohwin balan meyoh o wak?” ");
INSERT INTO apeB_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Ali Jisas nebemom balan nakli, “Ati ipak eke patalihen waka wak, balan douk nyetemu God ananik buk uli? Balan enyudak. ‘Seiwak bawogos umu, God douk nenekech alman uli almatok.’ ");
INSERT INTO apeB_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Nenekech ali nakli, ‘Yenekech namudak ali alman eke nutukemaguk mamechich nunak nunek pas ananik almatok. Ali echech biech douk eke chutoglu atin elpen.’ ");
INSERT INTO apeB_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Douk namudak ali echech douk awak chupe kobi biech elpech umu e, wak. Chanubu chatoglu atin elpen meyoh. Namudak ali echebuk douk God anowechikech uli, elpen douk kobi enen nyiyaisech, wak meyoh.” ");
INSERT INTO apeB_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Ali amam Farisi hasalikanu hakli, “Ali namudak malmu, umu Moses nakapaguk enyudak lo umu? Anan douk nakli alman nukli nunek julug umu okwok uli, anan douk nitak nunek anap chup umu chablo marit umu ali nukok kuhwap kutanamomu okwok umu.” ");
INSERT INTO apeB_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Jisas nemnek ali nebemom balan nakli, “Ipak balagas sechukepu. Pechoge balan ali Moses dakio naklipepamu punek julug umu ipakiyu almagou. Wakuli seiwak bawogos umu, enyudakmali douk wo chuneken e, wak. ");
INSERT INTO apeB_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Ali douk yaklipepu. Sapos ananu ananik almatok kobi kusonukeh kipainali ali anan nitak nunek julugumok meyoh nunak nunolau kipaikwimu, anudak alman douk nablo lo umu chanasupamu.” ");
INSERT INTO apeB_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Jisas ananim disaipel hemnek namudak ali haklipanu hakli, “O sapos nyakin balan adulin umu, ati almom douk kalbamu kobi husuh almagou wak, hupe meyoh.” ");
INSERT INTO apeB_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Ali Jisas nebemom balan nakli, “Enyudak balan douk wo hunatimaguk almom deke hunokwnumu hugipechen e, wak. Amabuk douk God nenekom dodogowim umu hupe meyoh uli atum. ");
INSERT INTO apeB_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Mnek, agundak anam almom wo husuh almagowamu e douk namudak. Anam cheyobomom, ali enyebuk pasin nyapenyum umu kobi husuh almagowamu, anam chatukuk ouguh, ali anam douk ulkwip polomu hakli husuh God ananin moul umu hakli hugakamu elpech chuwich agundak God nape nebenalimu ananich elpech umu. Douk namudak ali amam hape meyoh. Orait sapos ipak meinali nunokwnumu nugipech enyudak balan uli, orait anan wosik iken nupe meyoh.” ");
INSERT INTO apeB_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Ali ababuk nyultab, enech elpech chalawali batowich umu chakli Jisas nuwemeyech ananis wis ali nunemech beten. Chalawechi wakuli ananim disaipel hahu echudak elpech. ");
INSERT INTO apeB_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Jisas nemnek ali nakli, “Ipak kutuk batowich chunamali yek. Kobi puwechikechuk. Umu monoken, elpech chutoglu kobi echudak chokwichili, echech douk eke chuwich agundak God nape nebenalimu ananich elpech umu.” ");
INSERT INTO apeB_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Ali echudak batowich chanaki douk nowemeyech wis iyuh ali natukemaguk agnabuk nanak. ");
INSERT INTO apeB_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Anah nyumnah ananu alman nanakimu Jisas ali nasolikanu nakli, “Nebenali Tisa, yek imas inek monoken ali eke dakio inubu ipe kalbu eheh nyumneh?” ");
INSERT INTO apeB_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Douk Jisas nemnek ali naklipanu nakli, “Nyak kobi nyalikemu yopichi echudak, wak. Apak douk God atunu yopunali. Sapos nyak nyukli nyupe kalbu eheh nyumneh umu, nyak imas nyugipech ananin lo douk nyetemu ananik buk uli.” ");
INSERT INTO apeB_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Anudak alman nemnek ali wata nasolik Jisas nakli, “Monoken lo?” Ali Jisas nakli, “Lo enyudak. Kobi pubo kipahechi chugak, kobi pusonukeh kipahemi o kipahewali, kobi puku olugwih, kobi punek loh, ");
INSERT INTO apeB_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","pumnek mamechich echechin balan ali pugakamech, ipakip ulkwip punubu punosuh ipakichi kobi ipak ulkwip panosuh ipak yet umu.” ");
INSERT INTO apeB_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Douk anudak yanpeleinali alman nemnek ali naklipu Jisas nakli, “Nyanatimaguk enyudak lo douk yagipechen yeyaten. Ali meinyi pasin watak nyape douk yek watak ineken uli e?” ");
INSERT INTO apeB_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Jisas naklipanu nakli, “Sapos nyak nyukli nyunubu nyutoglu duldulinyamu, orait nyunak nyukech hanatimaguk nyakih jah kipahechi chutaluh. Chutaluh chukenyu utabal ali nyuhwabal nyunak nyiyaisabal umu echudak wakechi elpech. Namudak ali wolobaichi nyakich yopiyopichi echudak eke chukusumenyu gani iluh heven. Nyunekuk namudak iyuh ali nyunaki nyugipech yek.” ");
INSERT INTO apeB_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Douk anudak yanpeleinali alman nemnek namudak ali ananihw apahw hwanubu aman. Ali nanubu natukemaguk Jisas nanak. Umu monoken, anan douk nanabuk wolobaibali utabal blanu jah. ");
INSERT INTO apeB_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Anudak alman nanakuk ali Jisas naklipu ananim disaipel nakli, “Aduligu atugu yaklipepu. Elpen nyuglemu wolobainyi mani nyunu jah uli, enyen eke nyunek nyanubu nebenyi moul umu nyuwich agundak God nape nebenalimu ananich elpech umu.” ");
INSERT INTO apeB_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Iklipepu chopuk. Enen takweinyi mahin chohwalen umu kamel uli nyukli nyuwich nyil douk chenyigul tretumomu, enyebuk douk wo nyunubu nebenyi moul e, wak. Wakuli sapos ananu noglemu wolobainyi mani nyanu jah uli nukli nuwich agundak God nape nebenalimu ananich elpech umu, enyudak douk nyanubu nebenyi moul. ");
INSERT INTO apeB_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Amam Jisas ananim hemnek namudak ali hanubu loguh hwonechlukam. Ali hasalikanu hakli, “Namudak ali God eke wata nunolau omuni nyutanamali nyupe kalbu?” ");
INSERT INTO apeB_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Jisas natulum duk ali naklipam nakli, “Elpech douk wo chunokwnumu chugakamu enech umu chupe kalbu eheh nyumneh e, wak. God anan atunu nanubu nanoknumu nunek ihechumali echudak.” ");
INSERT INTO apeB_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Ali Pita nebemanu balan nakli, “Tik, apak douk amatukemoguk ihechumali echudak manaki magipech nyak. Ali douk eke mulau monoken?” ");
INSERT INTO apeB_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Ali Jisas naklipam nakli, “Aduligu atugu yaklipepu. Abudak yopubali nyultab ihechumali echudak chutoglu nupoleich chupe kalbu abali, Yek Anudak Alman yatoglu aduligeinyi elpen uli eke inubu itoglu dodogowiwe otuwe ihiyatik ali itemu yekin nebenyi sia king. Ali ababuk nyultab, ipak yekipu 12-poleipu douk pasuh yekin balan pagipechen uli douk chopuk eke putemu 12-poleich siahas. Putemu ali eke punek skelumu asudak 12-poleis awilos echech Isrel umu echechitu kwot. ");
INSERT INTO apeB_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Ali echebuk elpech douk ulkwip pulomu chugipech yek ali chutukemaguk echechich sachich owachich chanu ahlim uli mamaliyu o batowich chanu echech umu yawihas gnanu wilag uli, God eke nukech chanubu wolobaichi yopichi echudak chichalakuk echudak echech chatukemechuk uli ali eke chupe kalbu eheh nyumneh. ");
INSERT INTO apeB_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Wakuli wolobaichi elpech douk nameitu chape nebechili, kwali echech eke chunubu chupe chugikuk. Wolobaichi douk nameitu yeguh wakech chape chagikuk uli eke chunubu chupe nebechi chupe chulik. ");
INSERT INTO apeB_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Jisas wata naklipech enyudak woblen balan nakli, “Elpech chuwich agundak God nape nebenalimu ananich elpech umu douk kobi ananu alman douk neglemu anagu nahabigu nau wain-agali. Anah aglupil atul natoglu nanak naulimu anam almom umu hunak hunek moul agudak nohobigaluli. ");
INSERT INTO apeB_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Douk nanak napalogas anam ali naklipam umu hunak hunekumanu moul ali eke nutalum 1 kina 1 kina umu anah nyumnah chuknih. Amam hakli wosik ali nokagam hanak henek moul nahabigu. ");
INSERT INTO apeB_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Douk aliga 9 kilok ali nanak agundak elpech i save chanaki chowachobol umu ali natik anam alagun heyotu meyoh agnabuk. ");
INSERT INTO apeB_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Natulum ali naklipam nakli, ‘Ipak chopuk punak punek moul yekigu nahabigu. Punek moul ali yek eke italipu ikepu utabal blunoknumu moul puneken uli.’ ");
INSERT INTO apeB_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Ali hanak. Douk aliga nyumnah toul wata chopuk nanak nalawali anam. Hanak henek moul aliga 3 klok wabigun wata chopuk nanak nalawali anam alagun. ");
INSERT INTO apeB_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Aliga 5 klok wata chopuk nanak agundak elpech chawachobol umu ali chopuk napalag anam douk hape meyoh uli. Ali nasalikam nakli, ‘Ipak kwigani nyumnah nameih peneyotu meyoh agnabuk umu monoken?’ ");
INSERT INTO apeB_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Ali haklipanu hakli, ‘Apak mape meyoh moul wak umu monoken, wak ananu alman nunaki nuhwalapamu munak munekumonu moul e, wak.’ Ali naklipam nakli, ‘Orait ipak chopuk wosik punak punek moul yekigu wainigu nahabigu.’ ");
INSERT INTO apeB_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Douk aliga wabigun halakatimu wab ali nohobigeinali nanaki naklipu ananinu nenek bos umu henemanu moul uli namudak. Nakli, ‘Nyuhwalu henek moul uli hunaki ali nyukom utabal. Susubati nyulik nyutal amabuk dokwechuk ati yalawom hagikuk uli aliga nyutolum nyunak ali nyunak nyutoglomu yalik yalawomi aglupil atul uli hugikuk.’ ");
INSERT INTO apeB_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Ali natalum nokom 1 kina 1 kina amam atunu ati douk hagikuk hanaki hape henek moul wabigun 5 kilok uli. ");
INSERT INTO apeB_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Douk aliga ali amudak haitak umu moul aglupil atul uli hanaki heyotu umu hulau utabal. Amam douk honobuk ulkwip hakli amam wosik eke hulau digibali, wakuli wak. Amam chopuk halau 1 kina 1 kina ati. ");
INSERT INTO apeB_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Halawobol julug ali ahape hawolin heyaten umu nohobigeinali. ");
INSERT INTO apeB_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Hakli namudak. Hakli, ‘Amudak dokwechuk ati nyagikuk nyalawam uli douk henek moul atin aua meyoh. Apak douk kwigani malik manaki aglupil atul moneken, takweihi wah hapu aliga nameitu. Wakuli nyak douk nyatalum nyakam alagunibal utabal kobi nyoku apak umu. Malmu namudak?’ ");
INSERT INTO apeB_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Nohobigeinali nemnek ali naklipu ananu amudak henek moul uli nakli, ‘Elpen, mnek. Kwigani ohwak douk wabo balan nyakus atugun ali nyakli wosik umu nyunek moul nyumnah chuknih ali italinyu 1 kina. Ali nameitu douk yanubu yagipech enyebuk balan. ");
INSERT INTO apeB_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Nyak nosuh nyakibal utabal ali nyunak. Amudak yagikuk yalawomili douk yek meyoh yakli ali yokam alagunibal utabal kobi yoku ipak umu. ");
INSERT INTO apeB_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Ikli ineken malmu yekin mani ele, enyudak douk yekin moul. Nyak nyenek hinyigimu monoken? Yek douk yenek yopinyi pasin.’” ");
INSERT INTO apeB_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Ali Jisas nakli, “Echebuk douk chanubu yeguh wakech chape chagikuk uli, echech eke chutoglu nebechi chupe chulik. Echebuk douk chatoglu nebechi chape chalik uli, echech eke chunubu chupe chugikuk.” ");
INSERT INTO apeB_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Jisas nanu ananim 12-poleim disaipel douk haltomu Jerusalem. Hape hanak ali nasonukomuk anagun algas amam atum ali naklipam enen balan. ");
INSERT INTO apeB_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","Nakli, “Ipak mnek. Nameitu douk manamu Jerusalem. Munak mukih ali ananu alman eke nugilapam Yek Anudak Alman yatolgu aduligeinyi elpen uli amam nebemi pris hunu amudak anam henek skulumech umu lo uli. Nugilapam yek ali eke huhwe hunekume kwot umu he igak. ");
INSERT INTO apeB_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Ali eke hulawemu amam douk wo Juda uli e. Hulawe ali amam eke huneke enen enen hiyokosue, huleye nadululuh umu julug ali eke hunek nyilimume lowag kruse ali igak. Wakuli huklimu bieh atuh nyumneh umu, yek eke wata itaki ipe.” ");
INSERT INTO apeB_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Ali Sebedi ananik almatok kwalowoli okwokwim biom nugamim umu Jisas. Chanaki ali okwok kwabih kwoduk ohlubus agundak Jisas napemu ali kwalikanamu numnek okwokwin balan. ");
INSERT INTO apeB_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Ali nasolikok nakli, “Nyakli inekumenyu monoken?” Okwok kwakli, “Yakli nyak nyukli wosik ali abudak nyultab nyak nyupe nebenyalimu ihech elpech chunu enechi enech echudak abali, yek yakli nyak nyukli wasik ali amudak yekim biom nugamim hupe nebemi. Yakli ananu nupe aninyomu ali ananu nupe alganyomu.” ");
INSERT INTO apeB_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Jisas nemnek ali nebemech balan nakli, “Ipak douk wo pudukemu enyudak ipak pasolikemen uli e, wak. Ipak wosik deke dodogowipamu, pumnek ehudak nebehi nyih douk ahalakatimu yek eke imnekeh uli, waka?” Amam hemnek ali hakli, “Ohwak wosik wanokwnu.” ");
INSERT INTO apeB_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Ali Jisas naklipam, “wosik, ipak douk eke pumnek nebehi nyih kobi yek eke imnekeh ulimu. Wakuli yek yet eke kobi iklipu elpech umu enen nyupe onuwemu ali enen algawemu, wak. Oudak outib douk wapemu echebuk elpech douk yekinu Aninu anatalihech uli atich.” ");
INSERT INTO apeB_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Douk amudak anam 10-poleim disaipel hemnek umu enyudak ali hanubu nyihihichim umu Jon nanu Jems. ");
INSERT INTO apeB_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Namudak ali Jisas nahwalu amam hanatimaguk hanakimu anan ali naklipam nakli, “Ipak douk padukemech umu echech wo chudukemu God uli e echechin pasin umu echechim nebemi. Ali echechim chohwalam nebemili douk hanubu dodogowim atum hanalak umu kipahechi elpech umu chunek enenyi enen nebenyi moul. ");
INSERT INTO apeB_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Wakuli ipak, namudak wak. Sapos ipak ananu nukli nupe nebenalimu ipak umu, susubati anan imas nunemepu moul meyoh ipak panatimaguk iyuh ali eke nupe nebenalimu ipak. ");
INSERT INTO apeB_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Ali meinali anabuk douk nukli yeul nyunubu nyukihanu uli, anan imas nunubu yeul wakanu nupe chukamomu ipak nunemepu moul meyoh ipak panatimaguk ali adakio yeul nyukihanu. ");
INSERT INTO apeB_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Pugimeh kobi Yek Anudak Alman douk yatoglu aduligeinyi elpen ulimu. Yek douk wo inamali echech chuneme moul umu chugakamu yek e, wak. Yanamali inek moul umu igakamu echech. Yek yanamali eke ikech yek yet che igak ital wolobaichi elpech ikwechihech umu echechin yowenyi.” ");
INSERT INTO apeB_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Jisas nanu ananim hape hatukemaguk Jeriko hanak ali chanubu wolobaichi elpech chagipech Jisas. ");
INSERT INTO apeB_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Ali biom nabes sechukomi almom douk hape algasih umu yah. Hemnek umu chakli Jisas nanaki ali ahape hohwalu hakli, “Nya Devit ananinu Yamenu, nyak nyukli mapilihu ohwak!” ");
INSERT INTO apeB_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Echudak wolobaichi elpech chahom ali chaklipam umu husak. Wakuli amam wo humnekech e, wak. Hanubu hape hohwalu nebegun atugun ali hakli, “Nya Diginyali, Devit ananinu yamenu, nyak nyukli mapilihu ohwak!” ");
INSERT INTO apeB_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Jisas neyotu ali nahwalomu nakli, “Ipak pakli inekumepu monoken?” ");
INSERT INTO apeB_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Ali hebemanali balan hakli, “O Diginyali, ohwak wakli nyuhulmohu nabes umu wunotulugun.” ");
INSERT INTO apeB_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Jisas nanubu nenelekom ali nowemu wis amamis nabes. Nowemu wis ali ahudak atuh wata hanotulugun hwilhwaluk. Ali hanubu hanamanu hanak. ");
INSERT INTO apeB_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Douk chanak halakatimu Jerusalem ali chanak chatoglamu abuldak wabul yeulibulmu Betfasi. Ababul douk blape halakatimu anudak maunten Oliv. Ali Jisas nakagas biom disaipel umu hulik hunak. ");
INSERT INTO apeB_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Naklipam enyudak balan nakli, “Punamu blabli wabul blapeli woblahah uli ali pukli puwich ati eke punubu pugwatu enen mamakin donki. Chodowen naduh nyeil ali nugan douk nyanen cheyotu atugun. Pukwechihech ali pulawechumeli. ");
INSERT INTO apeB_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Ali sapos enen elpen nyukli nyuklipepu enen balan umu, ipak douk puklipen pukli, ‘Diginali anan enen moul umu echudak donkihas.’ Ali enyebuk elpen eke wisnabul nyuklipepamu pulawechi.” ");
INSERT INTO apeB_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Enyudak douk nyatoglamu enen balan seiwak ananu profet naklienyuk uli nyutoglu adulin. Balan enyudak. ");
INSERT INTO apeB_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Kale klipech enyudak balan echech douk chape nebebuli wabul Saion uli. Nyukli, ‘Tik, ipakinu king anudak nanakumepagu. Anan douk nanubu nenek daunimumu anan yet ali netemogu enen donki. Netemogu enen nugan donki ali nyalawanagu.’” ");
INSERT INTO apeB_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Ali amudak biom disaipel hanak henek enyudak kobi Jisas naklipam umu. ");
INSERT INTO apeB_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Douk halawali echudak mamakin uli nugan donkihas hanaki ali howemu onog amamig umu saketog agabusich umu. Hogwemu ali Jisas nalto netemu enen. ");
INSERT INTO apeB_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Ali chanubu wolobaichi elpech chape chalabik onog echechig saketog ahudak yah. Enech chobleli lowasiyu yeguhwiyu ali chogolikou chaginoh yah. ");
INSERT INTO apeB_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Ali echudak wolobaichi chagipech anan chanakili chanu echudak chalik uli achape chohwalu nebegun chakli, “Apak monehilaumu Devit ananinu Yamenu ali matuk ananin yeul nyakih. Makli God wosik iken nunekumanu yopinyi anudak alman douk nanamali Diginali ananin yeul uli. Apak makli echech chape iluh heven uli chopuk chunehilau-manu ali chutuk God ananin yeul nyukih!” ");
INSERT INTO apeB_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Douk aliga Jisas nanak nawich Jerusalem ali chanatimaguk chape Jerusalem uli chanubu loguh hwonechlukech. Ali chape cheagwleh nebenyi balan chanosusolimu chakli, “Anudak alman douk meinali?” ");
INSERT INTO apeB_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Ali echudak wolobaichi cheili Jisas uli chakli, “Anudak alman douk Jisas. Anan douk ananu profet ali nanaki wabul Nasaret, enyudak provins Galili.” ");
INSERT INTO apeB_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Jisas nanak nawich asudak banis God ananitu nebetali wilpat tatawomu ali nehiyah echebuk douk chape chenek salimumu echudak uli chanu echebuk elpech douk chatalich uli chatoglu chalhwas. Nablonomech tebolahas echebuk douk chape chenek senis umu manili chanu echebuk chenek salimumu almiguh uli. ");
INSERT INTO apeB_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Ali naklipech nakli, “Balan nyetemu God ananik buk uli nyakli namudak. Nyakli, ‘Yekitu wilpat douk eke chuhwalotu chenek beten atali wilpat.’ Wakuli ipak douk pagimehumotu kobi chaku olugwih uli chawich chonobechuk umu.” ");
INSERT INTO apeB_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Jisas wata nape numun banis atudak God ananitu nebetali wilpat tatawomu ali enech nabes sechukechi chanu ayas yowegas uli chanaki. Chanaki ali nagabeyech yopich. ");
INSERT INTO apeB_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Wakuli amam nebemi pris hanu amudak anam henek skulumech umu lo uli hatik enyudak ali nyihihichim. Nyihihichim umu agundak Jisas nenek enyudak God atunu neneken uli moul umu nyanu agundak batowich chohwalu chakli, “Apak monehilaumu Devit ananinu Yamenu ali matuk ananin yeul nyakih.” ");
INSERT INTO apeB_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Namudak ali haklipu Jisas hakli, “Nyak nyemnek enyudak balan chokwichi chape chohwalamen uli?” Ali Jisas naklipam nakli, “Douk yemnek wo. Enyudak God ananin balan eke patalihen waka wak? Balan enyudak. ‘Nyak God douk nyohul chokwichi batowich chanu echudak cheil chabah uli ali chatuk nyakin yeul nyakih.’” ");
INSERT INTO apeB_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Jisas naklipam enyudak balan umu julug ali natukemomuk natoglu Jerusalem nanamu Betani. Nanak ali ababuk wab douk nechuh agnabuk. ");
INSERT INTO apeB_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Aglupil atul Jisas naitak ali wata natanomomu Jerusalem. Nape nanak yah ali nemnek nyulub blanu. ");
INSERT INTO apeB_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Natik enen lowag fik nyeyatu algas yah ali neilmen nanak. Nanak wakuli wo nutik enep chulkwip pil e, wak. Chus atus. Natik namudak ali naklipu enyudak lowag nakli, “Nyak eke kobi wata enep chulkwip pil, wak.” Ali ahudak atuh enyudak lowag nyanubu alin. ");
INSERT INTO apeB_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Amam disaipel hatik namudak ali hanubu loguh hwonechlukam. Ali hakli, “Malmu ali dakio nyanyi lowag fik alin wisnabul?” ");
INSERT INTO apeB_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Ali Jisas nebemom balan nakli, “Aduligu atugu yaklipepu. Sapos ipak kobi biep ulkwip, wakuli punubu punek bilip umu God umu, enyudak yeneken umu enyudak lowag uli douk chopuk puneken. Ali deke kobi punek enyudak atin, wak. Sapos ipak puklipu atudak nukut umu titak tugluk yous, atat eke titak tugluk umu atugun. ");
INSERT INTO apeB_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Sapos ipak punubu punek bilip umu God ali punek beten pusolikanamu enech echudak umu, orait ihechumali ipak pusolikanamech uli echudak eke pulawech umu atugun.” ");
INSERT INTO apeB_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Jisas wata nanak nawich banis God ananitu nebetali wilpat tatawomu ali nape nenek skulumech God ananin balan. Ali amam nebemi pris hanu echech Juda echechim nebemi hanaki anan napemu hasalikanu hakli, “Nyak nyalau monoken namba umu nyenek enyudak moul? Omuni nyekenyu enyudak namba?” ");
INSERT INTO apeB_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Ali Jisas nebemom balan nakli, “Yek chopuk douk yakli isalikepu atin balan. Sapos ipak pubeme tukanin umu, yek eke iklipepamu omuni nyeke namba ali dakio yenek enyudak moul. ");
INSERT INTO apeB_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Ali Jon nenek baptaisumech umu douk omuni nyokanu enyudak moul dakio nenek baptaisumech? God waka elpech?” Hemnek enyudak ali amam yet hape heneyagwleh hakli, “Sapos mukli God nokoneyen umu, anan eke wata nusolikapu nukli, ‘Douk namudak ali Jon ananin balan douk wo punek bilipumen e umu monoken?’ ");
INSERT INTO apeB_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Wakuli sapos apak mukli elpech meyoh chokoneyen ali dakio neneken umu, apak imas elgeipomoguk almom almagou. Umu monoken, echech chanatimaguk chakli Jon anan douk ananu profet.” ");
INSERT INTO apeB_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Namudak ali hebemanu balan Jisas hakli amom wo hudukemech e. Ali anan wata naklipam nakli, “Namudak ali yek chopuk eke kobi iklipepamu omuni nyeke namba ali dakio yenek enyudak.” ");
INSERT INTO apeB_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Ali Jisas wata naklipam nakli, “Ipak douk pakli malmu, umu enyudak woblen balan? Ananu alman douk nololi biom nugamim. Ali nanamu saninu naklipanu nakli, ‘Nuganinu, doumeih yakli nyak nyunak nyunek moul nahabigu yau wain umu.’ ");
INSERT INTO apeB_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Ali nuganinu nakli, ‘Ati yakli wak.’ Douk napegu wakuli wata nenek senis umu tinytin ali nanak nenek moul agudak wainigu nahabigu. ");
INSERT INTO apeB_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Aninu wata nanamu anudak ananu nuganinu ali naklipanu enyudak atin balan. Nuganinu nemnek ali nakli, ‘Aninu, wosik eke inak.’ Wakuli nenek loh wo nunak e. ");
INSERT INTO apeB_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Ali amudak biom nugamim, ipak pakli meinali nagipech aninein balan?” Ali amam hakli, “Saninu wo.” Ali Jisas wata naklipam nakli, “Aduligu atugu yaklipepu. Amudak almom halau tagis uli hanu weyatu yegwih uli almagou, nameitu echech douk achape chagimeh namudak. Echech douk achape chatanamu chakanu apaluh God ali achape chalik chawich agundak God nape nebenalimu ananich elpech umu. Ipak kawepu. Eke pugikuk puwich waka wak? ");
INSERT INTO apeB_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Umu monoken, Jon nenek baptaisumech uli douk ananakumali ipak nagilapepu duldulinyi pasin, wakuli ipak wo punek bilip umu ananin balan e, wak. Amam halau tagis uli hanu weyatu yegwih uli atich chenek bilipumanu. Enyudak douk patulin, wakuli wo puklimu punek senis umu tinytin ali punek bilipumanu e, wak.” ");
INSERT INTO apeB_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Ali Jisas wata naklipam nakli, “Ipak pumnek enyudak kipainyi woblen balan alagun. Ananu noglemu anab amnab uli nalib anagu nahabigu nau wain ali nalokogu nalub. Nawonu iyuh ali nalak bobigu onok bulbuduk. Nalogomu chichichu wainip chulkwip ali wainibal abal blubih blulomu. Nenekuk enyudak ali nowemu anap potemoguk iluh uli oulop umu ananu alman nukih nupe nunek was umu nohobigomu. Moul nyatuh ali nanak naklipaguk anam almom umu hulau kontrak anan ali hupe hunek moul ananigu nahabigu. Naklipamuk ali nanak nape anabul lougunibul wabul. ");
INSERT INTO apeB_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Nanak nape aliga wainip chulkwip kolokwip ali nakagas kipaimi henemanu moul meyoh uli umu hunak hutik henek moul nohobigaluli ali husuhumanali ananip umu chulkwip. ");
INSERT INTO apeB_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Henemanu moul uli hanak hatoglu wakuli amudak henek moul nohobigaluli haitak hahwom, ananu hanu meyoh, ananu hanu nanubu nagak ali ananu hakumanu utabal. ");
INSERT INTO apeB_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Chopuk nohobigeinali nenek salimumu kipaimi henemanu moul uli hanak. Nameitu kwalowi wolobaimi hechalakuk halik hanak uli. Hanak wakuli henek moul nohobigaluli hagimehumom namudak ati kobi halik hanak ulimu. ");
INSERT INTO apeB_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Nape wak ali nagikuk nenek salim umu ananinu nuganinu meyoh nanamu agudak nahabigu. Anan douk nenek tin nakli, ‘Yekinu nuganinu nunak umu wosik eke humnekanu.’ ");
INSERT INTO apeB_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Wakuli henek moul nohobigaluli hatiku nuganinu nanaki ali hanoklipomu hakli, ‘Nuglemu anineich echudak uli douk akonudak. Yowi monu nugakuk umu agudak ananigu nahabigu eke apak munolawagu.’ ");
INSERT INTO apeB_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Ali hanak hahwanu howachanu natoglaguk aduk agudak nahabigu ali hanu nagak.” ");
INSERT INTO apeB_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Ali Jisas nasolik amudak nebemi Juda nakli, “Namudak ali abudak nyultab nohobigeinali nukli nunaki abali, amudak henek moul nohobigaluli eke nunekam malmu?” ");
INSERT INTO apeB_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Ali hebemanu balan hakli, “Amudak yowemi almom douk eke nom hulau nebehi nyih ali hugak. Ali agudak wainigu nahabigu eke nuku kipahemi hunek lukautumagu. Umu abudak nyultab chulkwip kolokwip abali, ananip umu douk eke wata hudiyep hukanu duldul.” ");
INSERT INTO apeB_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Ali Jisas naklipam nakli, “Ipak patulin enyudak balan nyetemu God ananik buk uli e. Balan enyudak. ‘Amudak utam douk halak wilpat uli hakli wakamuk uli, nameitu amam douk manubu matoglu anam susubeim utam umu chulok wilpat umu. Enyudak douk Diginali meyoh neneken nyatoglu. Neneken apak matulin ali monehilau makli enyen douk Diginali atunu neneken uli moul.’ ");
INSERT INTO apeB_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Namudak ali yaklipepu. Ipak, God douk eke nunalakumepu putoglaguk umu agundak God nape nebenalimu ananich elpech umu. Anan eke wata nunolawali echudak enech elpech douk eke chusuh ananin balan ali chunek yopinyi pasin uli chunaki chuwich.  ");
INSERT INTO apeB_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Ali echebuk elpech douk chugoul chulto amudak utam uli eke chubih plulakelech chunakuk chokugun atugun. Ali sapos amam mubih mubo enen elpen umu, enyebuk elpen eke micholiken nyunubu nyunenemu minyagu.” ");
INSERT INTO apeB_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Amam nebemi pris hanu Farisi hemnek Jisas ananin woblen balan ali hadukemech hakli anan douk nakliyen nenyemu amam. ");
INSERT INTO apeB_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Namudak ali hechakamech umu hakli huhwanu hunak hunekumanu balan. Wakuli wak. Amam douk elgeimumaguk echudak wolobaichi elpech. Umu monoken, echech chakli Jisas anan douk ananu profet. ");
INSERT INTO apeB_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Jisas wata naklipech enen woblen balan alagun. ");
INSERT INTO apeB_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","Nakli, “Elpech chawich agundak God nape nebenalimu ananich elpech umu douk kobi ananu king nagimeh umu. Ananinu nuganinu nakli nusuh okwok ali anudak king nenek nebeguni woligun. ");
INSERT INTO apeB_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Nobowokih douk nalik nenekumech balan enech umu chunamali agundak woligun. Douk nyumnah hatalgu ali nakagas henemanu moul uli umu hunak huklipech chunaki. Douk hanak haklipech wakuli chakli wak umu chunaki. ");
INSERT INTO apeB_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Chopuk naklipu kipaimi henemanu moul uli umu hunak ali naklipam nakli, ‘Punak puklipu echebuk nobowokih yenemech balan uli chunaki. Puklipech pukli, “Ananigun woligun anenekogun gnakus. Nabo chuwoluhich kauhas chanu enech nugach monumichichi kauhas natahech. Ihechumali echudak achenek redi chakus, ali ipak yowi munamu agundak nebeguni woligun.” ’ ");
INSERT INTO apeB_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Hanak haklipech wakuli wo chumnekom e, wak. Chanamu echechin moul. Ananu nanamu yawihas. Ananu nanak nenek moulamu ananin bisnis. ");
INSERT INTO apeB_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Ali echudak enech chaitak chasuh amudak henemanu moul king uli chahom chenekom anagu anagu cham hagak. ");
INSERT INTO apeB_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","King nemnek namudak ali nanubu nyihihichinu. Ali nakagas ananim soldia hanak habo echudak chabo ananim hagak uli. Hach chagak ali howehumech echechibul wabul hanubul heyatabul. ");
INSERT INTO apeB_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Ali king nahwalu amudak anam henemanu moul uli hanaki ali naklipam nakli, ‘Agundak yekigun woligun yenekagun umu nuganinu nusuh okwok umu douk agnenek redi gnakus. Wakuli elpech yenemech balan umu chunakili, echech douk wo yopichi elpech e, ali eke kobi chunaki, wak. ");
INSERT INTO apeB_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Namudak ali nameitu ipak punamu hanatimaguk nebehi yegwih ali chunatimaguk pugwatech uli elpech douk puhwalech chunamali agundak woligun.’ ");
INSERT INTO apeB_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Naklipam namudak ali amam haitak hagimu yegwih hanak. Hanak ali chanatimaguk hagwatech uli douk halawech hanaki. Enech yopichi, enech yowechi. Halawechi ali atudak nebetali wilpat douk chenek woligun gnakus atali tanubu chuknitu. ");
INSERT INTO apeB_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Douk chape ali king nanak nawich umu nutulich. Nawichu wakuli natik umu, ananu alman douk wo nunek duldulih luseh umu agundak chanasupamu e, wak. ");
INSERT INTO apeB_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Ali king nasolikanu nakli, ‘Elpen, nyak luseh wo nyuneki duldulih douk chenekeh nyultab chanosupomomu e. Ali agundak nyawichi malmu?’ Wakuli anan douk balan wakanu nape. ");
INSERT INTO apeB_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Namudak ali king naklipu henemanu moul uli nakli, ‘Ipak puwechikanu loguh ayas ali puwachanu nutoglu aduk yomotokweh umu. Nutoglu agundak douk elpech eke chuleh naluh hlunak hlichukuk ali chumnek nebehi nyih umu.’ ");
INSERT INTO apeB_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Mnek, God i save nahwalu wolobaichi elpech, wakuli i save natalih atin ati meyoh umu chupe ananich. Echudak douk chagipech ananin balan uli atich.” ");
INSERT INTO apeB_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Amam Farisi hanak anagun ali heyagwleh habo balan umu hakli hunek loh husalikanu enen balan, umu nukli niyagwleh sisahw ali huhwanu hunemanu kwotog. ");
INSERT INTO apeB_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Namudak ali amam hokogos anam almom douk hagipech amam uli hanu anam king Herot ananim hanak hasalik Jisas hakli, “Tisa, apak madukemech umu, nyak douk nyapemu nyeyagwleh adulin atinyi balan ali nyenek skulumech kalbu umu God ananin pasin. Elpen douk wo nyunotutik enen atin e, wak. Umu monoken, yeguh hwakihechi elpech douk wo nyuklipech kipainyi balan ali yeguh wakechi nyuklipech kipainyi e, wak. ");
INSERT INTO apeB_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Douk namudak ali nameitu makli nyuklipapu. Apakin lo douk nyakli malmu? Enyen douk wosik umu apak munek takis umu nebenalimu gavman uli Sisa, o wak?” ");
INSERT INTO apeB_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Jisas anadukemu amamin yowenyi tinytin ali naklipam nakli, “Ipak ati penek loh uli. Pechakomu yek umu monoken? ");
INSERT INTO apeB_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Aliga lawoli anam chenek tagis umu utam itulum.” Ali halawali anam. ");
INSERT INTO apeB_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Halawomi ali nasalikam nakli, “Enyudak yeul uli aboli douk omuni enech?” ");
INSERT INTO apeB_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Ali haklipanu hakli, “Sisa Nebenalimu gavman uli ananich.” Namudak ali Jisas naklipam nakli, “Sisa ananich echudak imas puku Sisa. God ananich, puku God.” ");
INSERT INTO apeB_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Hemnek namudak ali loguh hwonechlukam. Ali hatukemanaguk hanak. ");
INSERT INTO apeB_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Ahudak atuh nyumnah amam Sadyusi douk i save hakli chagak uli eke kobi wata chitakili hanaki agundak Jisas napemu. ");
INSERT INTO apeB_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Hanaki ali haklipanu hakli, “Tisa, seiwak Moses douk nakli sapos ananu alman kobi nulaguk enech batowich ali nugak umu, orait ananinu owaninu imas nuwaul ananik almatok. Nukwaul umu chuloli batowich ali chutik sanineigu iwagu. ");
INSERT INTO apeB_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Anabu nyultab, 7-poleim nugamim douk atich mamechich chomlolili douk hanopu hape agundak. Nanubu saninu nasuh okwok, wakuli batowich wak ali nagak. Ali nanosuhwanali agab uli nokwaul. ");
INSERT INTO apeB_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Nokwaul namudak ati. Batowich wak nagak. Ali anabuk nanosuhwomi agabus uli chopuk nagimah namudak ati. Aliga ali amam hanatimaguk 7-poleim hahwok batowich wak ali hagak ati. ");
INSERT INTO apeB_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Douk amam hagak hatuh ali okwok chopuk kwagak kwagikuk. ");
INSERT INTO apeB_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Amudak hanatimaguk sanyowan douk hahwok uli atum. Namudak ali ababuk nyultab chagak uli eke wata chitakumali, okudak almatok eke wata kupemu meinali, amudak 7-poleim almom?” ");
INSERT INTO apeB_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Ali Jisas nebemom balan nakli, “Ipak wo pudukemech e. Umu monoken ipak wo pudukemu God ananin balan douk nyetemu ananik buk uli e, wak. Ali chopuk wo pudukemu agundak God nanubu dodogowinu atunamu e. ");
INSERT INTO apeB_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Ababuk nyultab chagak uli wata chitakumali, almom almagou eke kobi wata chunosupu, wak. Eke chupe kobi enselahas douk chape iluh heven ulimu. ");
INSERT INTO apeB_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Ali umu agundak chagak uli eke wata chitakumali, yakli God naklipepamu balan eke patalihen waka wak? Anan douk nakli, ");
INSERT INTO apeB_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Yek douk Ebraham nanu Aisak uli Jekop amamiwe God’ Enyudak balan nyakli anudak God douk chape uli echechinu atunu. Wo chagak uli echechinu e.” ");
INSERT INTO apeB_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Echudak wolobaichi elpech chemnek enyudak naklipech enyi balan ali chanubu loguh hwonechlukech. ");
INSERT INTO apeB_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Douk amam Farisi hemnek umu Jisas nobeyomuk balan amam Sadyusi ali amam hanaki howachabal atugun. ");
INSERT INTO apeB_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Ali amudak almom, ananu douk nanubu nadukemu lo kalbaluli. Anan douk nakli nichakamu Jisas umu hakli kadak humnekanu niyagwleh enen balan wo duldulin uli e ali hunemanu kwot. ");
INSERT INTO apeB_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","Ali nasolik Jisas nakli, “Nebenyali Tisa, meinyi God ananin lo douk nyanubu susubein ali nyechalakuk nyanatimaguk lo?” ");
INSERT INTO apeB_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Ali Jisas nebemanu balan nakli, “God anan douk ipakinu Diginali. Ali ipakip ulkwip punu michich uli tinytin imas chunubu chunosuh anan atunu. ");
INSERT INTO apeB_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Enyudak lo douk nyanubu susubein nebenyi lo. ");
INSERT INTO apeB_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ali nyagimogu enyebuk lo uli douk namudak ati. Nyakli, ‘Ipak imas ulkwip punosuh elpech chape halakatimu ipak kobi ipak ulkwip panosuh ipak yet umu.’ ");
INSERT INTO apeB_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Enyudak bien lo douk nyanubu bawogos umu ihen amam profet henyemaguk uli balan nyanu enyudak lo seiwak God nokaguk Moses umu.” ");
INSERT INTO apeB_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Amam Farisi wata howachabal hape ati ali Jisas nasalikam enen balan. ");
INSERT INTO apeB_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","Nakli, “Ipak pakli malmu, umu anudak alman Krais douk God natalihanu ali eke nukaganu nunamali nunolau elpech uli? Ipak pakli anan douk meinali alman ananinu yamenu?” Ali amam Farisi haklipanu hakli, “Anan douk eke Devit ananinu yamenu.” ");
INSERT INTO apeB_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Ali Jisas nasalikam nakli, “Ali namudak malmu, umu God ananin Michin nyohul Devit ali nahwalu Krais Diginalimu? Nakli namudak. ");
INSERT INTO apeB_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Diginali naklipu yekinu Diginali nakli, “Nyak pe agundak onuwemu aliga yek ibo nyakim birua hubihuk.” ’ ");
INSERT INTO apeB_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Ali tik. Devit douk nahwalu Krais ananinu Diginali. Douk namudak ali Krais eke wata nutoglu Devit ananinu yamenu malmu?” ");
INSERT INTO apeB_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Wak kwalowi ananu nubemanu enen atin balan e, wak meyoh. Hanubu ahabuk nyumnah amam ahape elgeim umu wata husalikanu enen balan alagun umu. ");
INSERT INTO apeB_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Ali Jisas anape naklipech balan wolobaichi elpech chanu ananim disaipel. ");
INSERT INTO apeB_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","Nakli, “Amam Farisi hanu amudak henek skulumech umu lo uli douk i save henek skulumepu enyudak lo kobi seiwak Moses naklipechuk umu. ");
INSERT INTO apeB_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Namudak ali ipak imas pumnekom ali punek ihenyumali amam huklipepamu puneken uli. Wakuli huneken uli pasin, ipak douk kobi pugipechen, wak. Umu monoken, haklienyi balan, amam douk wo hugipechen ati e, wak. ");
INSERT INTO apeB_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Amam douk i save haklipepu wolobainyi dodogowinyi lo ali ipak penek nebenyi moul pabilak umu pugipechen. Hatulipu namudak, wakuli wo hukli hunelekepu ali hiyagwleh hunek lo kobi nyunubu nyunek hat umu ipak pugipechen umu e, wak. ");
INSERT INTO apeB_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Ihenyumali amam heneken uli douk heneken umu kadak elpech chutulin umu. Amam douk henek bokisigun ali howechikagun gnape amamigas wahegas uli loguh. Eke hitak huginohuk agundak owinyih umu amamih lowihi luseh umu kadak elpech chutulum chukli amam yopumi almom. ");
INSERT INTO apeB_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Chenek nebeguni woligun umu douk i save oub baitak umu hunak hupe yopugunmu gani nebemi atum hapemu. Echech Juda chape cheagwleh balan ogwi wilag chopuk i save oub baitak umu huwich hunak hupe hulik yopichi siahas. ");
INSERT INTO apeB_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Agundak elpech i save chanak chowachobol umu, amam i save oub baitak umu hakli elpech chutulum chunemom gude ali chuhwalom nebemi Tisa. ");
INSERT INTO apeB_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Wakuli ipak yekipali douk yakli wak umu chuhwalepu nebepoli tisomi, wak. Punatimaguk pupe sachich owachich meyoh. Umu monoken, nebenali Tisa douk puhwalu yek otuwe. ");
INSERT INTO apeB_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Apudak atap, ipak kobi puhwalu ananu alman ipakinu aninu, wak. Umu monoken, ipak douk atunu Aninu meyoh nape gani iluh heven. ");
INSERT INTO apeB_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Ali chopuk kobi chuhwalepu nebepali, wak. Umu monoken, nebeweli douk yanubu otuwe meyoh douk God natalihe ali nokoge yanamali inalau ipak elpech uli. ");
INSERT INTO apeB_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Anabuk douk nuklimu nupe ipakinu nebenalili, anan imas nupe nunemepu moul meyoh. ");
INSERT INTO apeB_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Elpech douk chunotuk echechich yeguh chukih uli, God eke wata nunekech chubihi yeguh wakech. Wakuli elpech douk chunek daunim umu echech yet uli, echebuk God eke nutukech chupe nebechi.” ");
INSERT INTO apeB_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Jisas wata chopuk nakli namudak. Nakli, “O panubu mapilipu, ipak Farisi panu ipak douk penek skulumech umu lo uli. Ipak eke punubu pupe sisahw. Ipak panubu penek loh atili. Ipak papemu powechikumech yah echudak elpech douk chaklimu chuwich agundak God nape nebenalimu ananich elpech umu uli. Namudak ali ipak yet douk wo puwich e, wak. Elpech chaklimu chuwich uli namudak ipak yet powechikumech yah.  ");
INSERT INTO apeB_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","O panubu mapilipu ipak Farisi panu ipak douk penek skulumech umu lo uli. Ipak eke punubu pupe sisahw. Ipak panubu penek loh atili. Almagou douk alahasim hagak howobukuk uli, ipak i save panak penek lohumou ali patulu ponohul owowich echudak. Penekuk namudak ali panak peyotu wolobaichi chapemu penek lounyi beten umu kadak chutulipamu. Pagimeh namudak ali kwali God eke nubemepu ipakin yowenyi ali nunekepu pulau nebehi nyih. ");
INSERT INTO apeB_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","O panubu mapilipu ipak Farisi panu ipak douk penek skulumech umu lo uli. Ipak eke punubu pupe sisahw. Ipak panubu penek loh atili. Ipak i save palau kolohliyol panak yousih o palahe panak atapih umu puklipech balan umu enen elpen nyumnek ali nyugipech ipak. Douk enen nyumnek nyugipechepu ali peneken nyanubu nyatoglu yowenyi elpen nyechalakuk ipak umu yowenyi enyen nyeneken uli. Ali enyudak elpen nyunu ipak eke punamu yowebuli wabul hel. ");
INSERT INTO apeB_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","O panubu mapilipu ipak. Ipak eke punubu pupe sisahw. Ipak douk wo pudukemech e pape kobi nabes sechukepu ali pakli pugilapech yah kipahechi. Ipak douk i save pakli, ‘Sapos enen elpen nyukli adul nyolimu God ananitu nebetali wilpat umu nyunek enech echudak, wakuli enyen kobi nyunekech umu, ipak pakli enyudak wosik balan wak enen nypenyin e, wak. Wakuli sapos enen nyukli adul nyolimu gol lakus numun God ananitu wilpat uli umu nyunek enech echudak umu, enyebuk elpen adul imas nyunubu nyunek kobi nyaklimu. Kobi nyunek loh, wak. ");
INSERT INTO apeB_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Ipak ati nabes sechukepu ali panubu pogolu pogolu. Ipak pakli monoken nyanubu yeul nyakihen? God ananitu nebetali wilpat waka aludak gol douk lakus numun uli? Ipak douk padukemech. Aludak gol douk lakus numun God ananitu nebetali wilpat, ali wilpat tenekol lanubu latoglu God ananil atul. ");
INSERT INTO apeB_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Chopuk ipak douk i save pakli, ‘Sapos enen elpen nyukli adul nyolimu alta umu nyunek enech echudak, wakuli enyen kobi nyunekech umu, enyudak pakli wosik balan wak. Wakuli sapos enyen nyukli adul nyolimu ofa douk chechemu enyudak alta umu chuku God ulimu, ipak pakli enyebuk elpen imas nyunubu nyunek kobi nyaklimu.’ ");
INSERT INTO apeB_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Ipak douk nabes sechukepu. Pakli malmu? Pakli yeul nyakih ofa douk chakli chuku God umu waka nyakih enyudak alta douk nyenek enyudak ofa nyatoglu God ananin atin uli? ");
INSERT INTO apeB_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Namudak ali elpen douk nyukli adul nyolimu alta umu nyunek enech echudak umu, enyen douk chopuk nyowanipamu ihenyumali ofa nyetemu alta uli chopuk. ");
INSERT INTO apeB_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Ali elpen douk nyukli adul nyolimu God ananitu nebetali wilpat umu nyunek enech echudak umu, enyen douk chopuk nyowanipamu anudak nape numun atudak wilpat uli. ");
INSERT INTO apeB_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Elpen douk nyukli adul nyolimu iluh heven umu nyunek enech echudak umu, enyen douk nyowanipamu God ananin nebenyi sia nyanu anudak netemeyen uli chopuk. ");
INSERT INTO apeB_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","O panubu mapilipu ipak Farisi panu ipak douk penek skulumech umu lo uli. Ipak douk panubu penek loh atili. Agudakmoli apigu douk chohwalogomu min, dil uli kumin, ipak i save panak palogu ali peyaisogomu 10-poleiluh ouluh. Ali otuh ouh douk i save poku God. Enyudakmali chokwinyi lo douk pagipechen. Wakuli nyanubu nebenyi balan nyape lo uli douk apatukemenyuk. Enyudakmali, punekumech duldulinyi pasin kipahechimu, punelek kipahechimu, punubu pusuh God ananin balan dadag umu. Enyudakmali susubein dodogowinyi balan douk deke punubu pugipechen kalbu. Ali enyudak enen lo douk chopuk deke puhwen pugipechen. ");
INSERT INTO apeB_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Ipak douk panubu nabes sechukepu ali pakli pugilapech yah kipahechi. Ipak douk pagimehumu God ananin lo kobi enyudak balan umu. Enyudak; Yamigou waglumepamu yabig umu, ipak douk i save patukou powachowoguk. Wakuli enen takweinyi mahin kemel nyagluk umu, ipak i save pagiyen panyoh umu yabig. ");
INSERT INTO apeB_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","O panubu mapilipu ipak Farisi panu ipak douk penek skulumech umu lo uli. Ipak douk panubu penek loh uli. Panubu pape kobi kas sanu yauleluh umu. Paklupoguk adukohich umu, wakuli numunich umu douk chanubu chanobosusih. Chape kobi ipakigun numun chuknigun umu yowenyi umu agundak wo punek bos umu ipak yet e ali paku oluh umu agundak didigep pape panotulich echudak kipahechimu. ");
INSERT INTO apeB_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Ipak Farisi, ipak panubu pogolu pogolu pape kobi nabes sechukepomu. Susubati ipak douk pulik punogapech ipakigun numun yopugun kobi pakwlupu numunis umu kas yopus umu. Ali aduk douk chopuk eke adakio yopugun. ");
INSERT INTO apeB_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","O panubu mapilipu ipak Farisi panu ipak penek skulumech umu lo uli. Ipak panubu penek loh atili. Ipak douk panubu pape kobi hulusigwiluh douk chaloluh bulbudib umu ali chanugomu elpech. Aduk chechebeyogun chogolih-winali pen gnanubu dudukogun. Wakuli gani numun wak. Chagak uli echechiguh biguh hwanu enechi enech chataloluli echudak chakus. ");
INSERT INTO apeB_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Ipak douk chopuk pape namudak ati. Elpech chutik aduk ipakiluh yegechiweluh chukli duldulipali almom. Wakuli ipakigun numun douk gnanubu chuknigun umu agundak penek loh umu gnanu enenyi enen yowenyi.” ");
INSERT INTO apeB_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Ali Jisas balan nyeilen naklipam nakli, “O panubu mapilipu ipak Farisi panu ipak douk penek skulumech umu lo uli. Ipak panubu penek loh atili. Ipak i save penek hulusigwiluh umu chunugamu amam profet umu. Hulusigwiluh chanugomu duldulichi elpech umu douk chopuk paginahwoluh. ");
INSERT INTO apeB_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Ali ipak i save pakli sapos ipak pupe ababuk nyultab ipakich popech yamech chapenyuboli nyultab ele, ipak pakli ipak deke kobi pugakamech pubo amam profet hugak, wak. ");
INSERT INTO apeB_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Douk peyagwleh enyudak balan ali ipak yet panubu ponowoleh umu ipak douk seiwakichi chabo amam profet hagak uli echechipu yamem. Panubu yowepali almom. ");
INSERT INTO apeB_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Namudak ali ipak imas punubu pigimah kobi echech chagimoh umu ali punubu puneken piyaten enyudak echech cheneken nyapeik uli yowenyi pasin. ");
INSERT INTO apeB_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Ipak douk panubu yowepu pape kobi wanahwiguhwi iguhumali. Chanubu yowechi elpech chape kobi iguhumali echechipu batowich. Namudak ali luhut God eke nunemepu balan ali nuwachepu pugluk yowebuli wabul hel. Pulhwas umu yah douk wakepu. ");
INSERT INTO apeB_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Namudak ali mnek. Yek eke inek salimumali anam profet hunu amam hanubu hadukemu God ananin balan kalbaluli hunakumepali. Hunali anam almam douk henek skulumepamu God ananin lo uli hunaki. Anam douk eke pitak pom punek nyilimumam krusehas hugak. Anam eke pitak pusakom echudak numun ogudak ipak pape peyagwleh balan ogwi wilag ali eke puhiyahom. Puhiyahom hunamu anabul wabul, punak agnabuk puhiyahom hunamu kipaibuli. ");
INSERT INTO apeB_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Seiwak susubati ipakinu yamenu Ken nabo yopunali alman Abel nagak. Ipakim popem yamen hagimehumech namudak ati yopichi elpech aliga aliga chanak chatoglomali Berekaia ananinu nuganinu Sekaraia. Sekaraia douk panu nagak olokohun umu alta nyanu God ananitu nebetali wilpat. Douk pagimu ehudak ali God eke nunekepu pulau nebenyi hevi umu agundak pabo hanatimaguk duldulimi almom hagak umu. ");
INSERT INTO apeB_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Aduligu atugu yaklipepu. God nube yowenyi pe umu ihenyumali enyudak yowenyimu, anan douk eke nuneken nyutoglomu ipak doumeipali elpech.” ");
INSERT INTO apeB_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Jisas natik wabul Jerusalem ali nakli, “O ipak elpech pape Jerusalem uli. Seiwak ipak i save pabo amam profet hagak. Almam God nokagam halaumepali ananin balan uli, ipak douk chopuk pakumom utabal pam hagak. Wolobaih atih yek yakli inalawepu ali igakomepu kobi anatu mamakitu owotu tohwalu nugag gwanaki atugun ali techukolug atatich abusineguh umu. Wakuli ipak douk panubu pakli wak. ");
INSERT INTO apeB_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Ali douk mnek. Nameitu aninu God douk anakli wakepu. Eke nutukemaguk ipakibul wabul ali eke blusitusatu blupeik wohibul. ");
INSERT INTO apeB_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Aduligu atugu yaklipepu. Ipak eke kobi wata putuliwe aliga abudak nyultab butoglu ali adakio pukli, ‘Apak makli God nunekumanu yopinyi anudak alman douk nanakumali Diginali ananin yeul uli.’” ");
INSERT INTO apeB_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Jisas natukemaguk God ananitu nebetali wilpat natoglu nanak ali ananim disaipel hanaki. Hanakimu hakli hugilapanu atudak nebetali wilpat umu agundak chalotu chenek dunuwaku wolobaigwi wilag ali tanubu takweitalimu. ");
INSERT INTO apeB_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Ali naklipam nakli, “Ipak douk patulug ogudak gwanatimaguk dudukogwi wilag? Adul ati yaklipepu. Abaludak utabal douk chalabal wilpat uli eke kobi putikuk anam atum mutemoguk chihah kipaimi, wak. Blunatimaguk eke chubolunik blubih blukus atap atugun.” ");
INSERT INTO apeB_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Jisas nakih nape anudak maunten Oliv ali ananim disaipel atum hanaki hasalikanu hakli, “Apak makli nyuklipapamu ahudak nyumnah echudak dokwechuh nyaklipapomech uli eke chutoglamu. Ali chopuk eke monoken nyulik nyutoglu mutulin ali mudukemech umu abudak nyultab nyak nyutanamali ali apudak atap putuh umu douk ahalakatimu?” ");
INSERT INTO apeB_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Ali Jisas nebemam balan nakli, “Ipak pugamu punenek yologimu kobi anam almam hunaki hunek lohumepu ali pugipech amamin balan, wak. ");
INSERT INTO apeB_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Umu monoken, wolobaimi almam douk hunahuli yekin yeul uli eke hunaki ali amam atunu ati eke hukli, ‘Yek Krais, douk God natalihe ali nokoge yanakili.’ Eke hunek lohumepu huklipepu namudak ali wolobaichi elpech eke chumnek amamin balan. ");
INSERT INTO apeB_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Ipak eke pumnek balan umu wanoh hwatoglu kipailubi lougunilub walub. Ali chopuk eke pumnek chupe chulpak halakatimu ipak papemu. Wakuli mnek. Ipak douk kobi elgeipu, wak. Enyudak imas nyutoglu, wakuli hagikuk uli nyumnah eke kobi kebes hutaglu. ");
INSERT INTO apeB_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Echech enen kantri eke chitak chunu enech kipainyi kantri chulpak. Ananu king nunu ananich eke chitak chunu kipainali king nunu ananich chupe chulpak. Wolobaigunmu eke nyulbiah hech ali enyik eke kutuk. ");
INSERT INTO apeB_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Nyanatimaguk enyudak nyalik uli hevi nyutoglamu douk eke kobi halik uli nyih douk almagou wape wabilak umu wutas uli womnekeh. ");
INSERT INTO apeB_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Ali ababuk nyultab eke chulawepu chunekepu anagu anagu pulau nebehi nyih ali eke chepu pugak. Chanatimaguk elpech chape ihalub walub uli eke chunubu chukli wakepu. Umu monoken, ipak douk yekipali pagipech yek uli. ");
INSERT INTO apeB_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Ali ababuk nyultab, wolobaichi chenek bilip umu yek uli eke chutukemaguk bilip. Chutukemenyuk ali eke chupe chunenemu birua ali chunowolepu chunogilapo-mamu echechich birua. ");
INSERT INTO apeB_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Wolobaimi henek lohumech uli profet eke hutoglu hunek loh umu wolobaichi elpech ali eke chugipechom. ");
INSERT INTO apeB_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Enenyi enen yowenyi eke nyunubu nyutoglu nebeben atin. Namudak ali wolobaichi elpech eke chutukemaguk enyudak pasin umu ulkwip punosuh kipahechimu. ");
INSERT INTO apeB_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Wakuli echebuk douk chugipech yek dodogowich atich aliga chugak uli, echech God eke wata nunolawech chutanamali chupe kalbu. ");
INSERT INTO apeB_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Ali enyudak God ananin yopinyi balan umu elpech chuwich aungak God nape nebenalimu ananich elpech umu douk eke chunak chuklipechen ihalub walub apudak atap. Douk chunatimaguk elpech chumneken chutuh, ali hagikuk uli nyumnah eke adakio hutaglu.” ");
INSERT INTO apeB_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Jisas balan nyeilen nakli, “Ipak eke putik enyudak nyanubu yowenyi nyuwich nyiyotu numun atudak God ananitu nebetali wilpat. Enyudak yowenyi douk seiwak God nohul profet Danyel naklienyuk.” Elpech chutalih enyudak balan uli imas chugamu chudukemen kalbu. ");
INSERT INTO apeB_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","“Ali ababuk nyultab, elpech chape enyudak provins Judia uli imas chulhwas chultomu maudenab. ");
INSERT INTO apeB_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Elpech chutemu aduk echechig wilag uli douk chubih ali kobi wata chukli chuwich chunohul enech echudak echechig wilag, wak. Chulhwas umu atugun. ");
INSERT INTO apeB_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Elpech cheyotu nohobigas uli kobi wata chutanomamu walub umu chunahuli echechih luseh, wak. ");
INSERT INTO apeB_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Ehebuk nyumneh hutoglamu, yek douk yanubu yakli mapiliyu apaluhiwali almagou wanu oudak douk cheil chaboh umu. ");
INSERT INTO apeB_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Ipak imas punek beten ali pusolik God umu abudak nyultab enyudak nyutoglu ali pulhwas abali, enyen douk kobi nyutoglu ali pulhwas anah hanubu nyuglusihi nyumnah o pulhwas anah nyumnah Sabat, douk ipak Juda wo punek moul umu e, wak. Anah kipaihi wosik. ");
INSERT INTO apeB_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Umu monoken, ababuk nyultab eke chunubu chulau nebeben atinyi hevi. Seiwak susubati God nenek agudak nohobigomu aliga nameitu, enyudakmali hevi douk watak enen nyutoglu e, wak. Kwali chopuk eke kobi wata enen alagun nyutoglu. ");
INSERT INTO apeB_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Sapos God nukli kobi nunek ehebuk yowehi nyumneh hutaglu baneh ele, chanatimaguk elpech eke chugak chutuh. Wakuli anan douk wata ulkum molomu echudak anan ananaglahech uli. Namudak ali anan dakio eke wata nunek ehudak yowehi nyumneh hutaglu baneh. ");
INSERT INTO apeB_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Ali ababuk nyultab, sapos enech elpech chunaki chuklipepu chukli, ‘Ipak tik. Anudak alman Krais, douk God natalihanu ali nakaganu nanakili douk anudak’ o chuklipepu chukli, ‘Nani nape gani’, yek yakli ipak kobi punek bilipumech, wak. ");
INSERT INTO apeB_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Umu monoken, anam henek lohumech uli almom eke hunaki ali amam atunu ati eke hukli, ‘Yek Krais.’ Anam eke hunek loh hukli, ‘Yek douk onowe profet.’ Ali eke hunek enenyi enen God atunu neneken uli moul. Amam hunek namudak umu hukli hunek loh umu God nanaglahech uli elpech umu chukli adul amam God nagakomom. Ali sapos dodogowim ele, amam eke hunek lohumech. Wakuli eke wak. ");
INSERT INTO apeB_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Mnek! Chanatimaguk echudak douk watak chutoglu e ali douk ayalik yaklipepamech. ");
INSERT INTO apeB_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Namudak ali sapos enech chunaki chuklipepu chukli, ‘Tik, Krais nani nape gani wohigunmu elpech wak umu’, yek yakli ipak kobi pumnekech punak, wak. O sapos chunaki chukli, ‘Anudak nonobechuk nape atudak wilpat’, yek yakli ipak kobi punek bilipumech, wak. ");
INSERT INTO apeB_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Ipak douk padukemech ati. Utagu gukli bagologu guhiyatik umu, agag douk eke guhiyatiki gani aun nakihumali aliga gunak gabih gani nabuh umu. Ali yek Anudak Alman yatoglu aduligeinyi elpen uli inakumali douk eke namudak ati. Eke chunatimaguk tikuk ati. ");
INSERT INTO apeB_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Ipak douk padukemech. Meiguni agnabuk douk enen enyudak nyugak nyukusuk umu, kumub douk kadoumun umu eke bunaki buneyomu.” ");
INSERT INTO apeB_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Jisas balan nyeilen nakli, “Enyudak nebenyi hevi eke nyutoglu nyunakuk ati ali nyumnahinu nunu wabinu aub eke yomotokwehib. Unib eke unotoli gani iluh utagu uglumali atap. Enechi enech chape iluh utagaluli chunu aub uli unib eke guldugolech chunaku chunaki. ");
INSERT INTO apeB_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Ali banubu ababuk nyultab eke putik anagu yek Anudak Alman yatoglu aduligeinyi elpen uli yekigu mak gutaglu gupe gani iluh utagu. Banatimoguk lainab elpech chape apudak atap uli eke chutik namudak, elgeich ali eke chupe chuleh. Ali eke chutiku Yek itukemaguk heven inubu dodogowiwe otuwe ihiyatiki ali ilali onog olug inaki. ");
INSERT INTO apeB_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Nebehwi oluh eke hwunehepich nebegun ali eke ikagasi yekich enselahas chunamu ihagunmu apudak atap. Chunak nakipu nowalu ali chulawoli echudak elpech douk yek yonoglahech uli chunaki atugun.” ");
INSERT INTO apeB_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Jisas balan nyeilen nakli, “Ipak ulkwip pulomu enyudak lowag fik ali pudukemech. Abudak nyultab enyen nyupe nyunaleh abali, ipak i save padukemech pakli eke wah atuh hutau. ");
INSERT INTO apeB_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Ali douk eke namudak ati. Abudak nyultab putik enyudak nyanatimaguk hevi dokwechuh yaklipepamen uli nyupe nyutoglu abali, ipak douk punubu pudukemech umu yek douk ahuluk umu itanamali. Halakati meyoh. ");
INSERT INTO apeB_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Aduligu atugu yaklipepu. Ipak doumeipali, enepu eke kobi kebes pugak ali ihenyumali hevi dokwechuh yaklipepamu eke nyutoglu nyuneyatak. ");
INSERT INTO apeB_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Utagu gunu enechi enech chapenyugu uli gunu apudak atap punu enechi enech chapenyup uli eke bulkwolech chunak chuwichuk. Wakuli yekin balan eke nyunubu nyupe namudak eheh nyumneh. ");
INSERT INTO apeB_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Wak enen atin elpen nyudukemu ahudak nyumnah o enyudak aua douk yek eke itanamalimu e, wak. God ananich ensel chape iluh heven uli chanu Yek ananiwe nuganinu chopuk wo mudukemech e. Aninu atunu nadukemech. ");
INSERT INTO apeB_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Enenyi enen pasin cheneken seiwak Noa napenyubali nyultab uli chopuk eke wata chuneken abudak nyultab yek Anudak Alman yatoglu aduligeinyi elpen uli ikli itanamali abali. ");
INSERT INTO apeB_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Noa napenyubali nyultab douk namudak. Abudak nyultab abal watak blukih bliyawi apudak atap abali e, elpech douk chanopemu chawak woligun uli abal, chatal almagou ali chanosupu. Chapemu chanogimu ehudakmoli aliga aliga ahudak nyumnah Noa nawich kolohuk umu hatalgu. ");
INSERT INTO apeB_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Echech douk wo chudukemu enyudak eke nyutogloluli e, wak. Chanopemu namudak aliga abal blakih bleyawi apudak atap, blau blabo chanatimaguk elpech chagak chatuh. Yek Anudak Alman yatoglu aduligeinyi elpen uli itanamalimu douk eke namudak ati. ");
INSERT INTO apeB_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Ahabuk nyumnah, biom almom eke hiyotu hunek moul anagu nahabigu. Ananu eke inalawanu ali ananu eke itukemanu niyotuk. ");
INSERT INTO apeB_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Biou almagou namudak eke wupe wumapoh wit umu wunek bret. Onok eke inatukwluk ali onok eke itukemok kunopeik. ");
INSERT INTO apeB_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Namudak ali ipak imas punenek yologi pupe putulugun. Umu monoken, nyumnah yek ipakiwe Digiweli itanamalimu, ipak douk wo pudukemoh e, wak. ");
INSERT INTO apeB_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Ipak ulkwip pulomu enyudak balan: Sapos ananu wilpatinali anudukemech umu meibali nyultab wab ananu naku oluh uli eke nunaki nuwol ananitu wilpat umu, orait anan eke nupe nunek was ali anudak naku oluh uli eke kobi nunaki nuwol ananitu wilpat nuwich, wak. ");
INSERT INTO apeB_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Ali ipak douk namudak ati. Wihluwehlu ipak imas pupe pubeyogunme. Umu monoken, yek Anudak Alman yatoglu aduligeinyi elpen uli eke wata inaki anabu nyultab douk ipak pukli eke kobi inaki abali.” ");
INSERT INTO apeB_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Jisas balan nyeilen nakli, “Meinali nenek moul uli douk yopinyi save nyapenyunu ali i save neneken kalbu ananin moul? Anan douk anudak ananinu nebenali nautunomu nunek bos umu echudak enech chenekumonu moul uli. Nautunomu nunek bosumech ali nukech echechich kakwich abudak nyultab echech chulau kakwich abali. ");
INSERT INTO apeB_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Anudak nenek moul uli wosik iken nwunehilau abudak nyultab ananinu nebenali nutanomoli ali nutulunamu nupe nunek ananin moul kobi anan nakliponoguk umu. ");
INSERT INTO apeB_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Aduligu atugu yaklipepu. Nebenali eke nutulunu namudak ali eke nutunu nupe nebenalimu ihechumali anudak nebenali ananich echudak. ");
INSERT INTO apeB_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Wakuli sapos anudak nenek moul uli ananu yowenalimu, anan eke nuneyagwleh nukli, ‘Yekinu nebenali eke kobi nunaki wisnabul.’ ");
INSERT INTO apeB_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Nukli namudak ali nitaki nupe nubo echudak enech echech atin moul umu. Ali nunak nunu hapemu hawak abal atubal uli huwak woligun ali huwak dodogowibali abal hugugaku. ");
INSERT INTO apeB_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Nunek namudak ali ananinu nebenali eke nunaki anah nyumnah douk anan nakli eke kobi nutanomali ahi. Eke nunaki anabu nyultab douk anan wo nudukemabu uli e. ");
INSERT INTO apeB_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Douk nutanomali nutulunu namudak ali eke nunubu nonu nusaganu nupe sisahw. Ali eke nukaganu nunak nunu chapemu chenek loh atili yowechi elpech chupe. Nunech nupe agnabuk ali eke chuleh sisahw naluh hlunak hlichukuk chumnek nebehi nyih.” ");
INSERT INTO apeB_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“Abudak nyultab yek itanamali abali, agundak God nupe nebenalimu ananich elpech umu douk kobi enyudak woblen balan umu. Ananu alman douk nasuh okwok ali nakli nunaki. Ali 10-poleiyu watak wusuh almom uli e yanpeleiwali almagou wohul owowich lepoguhas silisili ati ali wanak umu wutukulmanali yah. ");
INSERT INTO apeB_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Oudak almagou, 5-poleiyu douk yologiwali ali 5-poleiyu wak lahahaiyu. ");
INSERT INTO apeB_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Lahahaiwoli wasuh lepoguhas wakuli wel wo wunosuh anal alagun e, wak. ");
INSERT INTO apeB_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Yologiwali waitak wechalu anal alagun kipaiguhi botoguh ali wahwoguh umu lepoguhas. ");
INSERT INTO apeB_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Anudak nasuh okwok uli douk wo nunaki wisnabul e. Oudak 10-poleiyu almagou wape yobus satukou ali wabih wechuh wagak. ");
INSERT INTO apeB_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Aliga olokohunib umu wab ali enen nyohwalu nyakli, ‘Nasuh okwok uli akonudak nanaki. Aliga yowi punaki munak mutukulmanali yah.’ ");
INSERT INTO apeB_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Oudak wanatimaguk yanpoleiyu almagou womnek ali waitak wagapech owowich lepoguhas wehemech. ");
INSERT INTO apeB_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Ali oudak lahahaiwoli waklipu yologiwali wakli, ‘Aipo, pukopoli anal ipakumu wel. Apakich lepoguhas chakli hugakech.’ ");
INSERT INTO apeB_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Wakuli oudak yologiwali wobemou balan wakli, ‘Wak, kedeke kobi lunokwnumopu, apak munu ipak alagun umu. Aliga wata punamu stua punatali anal.’ ");
INSERT INTO apeB_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Namudak ali lahahaiwoli wanak umu wunatali anal wel. Owou wanakuk ali anudak nasuh okwok uli nanak natogloli. Ali oudak wonek redi wape uli almagou wanamanu chawich numun wilpat umu agundak nebeguni woligun douk chenekagun umu anan nasuh okwok umu. Chawich iyuh ali chowaluk dua. ");
INSERT INTO apeB_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Aliga ali oudak onou chopuk wanak wataglali. Ali wasalik wakli, ‘Nebenyali, Nebenyali, jikumopogu dua apak.’ ");
INSERT INTO apeB_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Wakuli nebemowoli balan nakli, ‘Aipo, adul yaklipepu. Yek wo kwalowi idukemepu uli e.’” ");
INSERT INTO apeB_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Ali Jisas naklipech nakli, “Namudak ali ipak imas punek was pupe. Umu monoken, ipak douk wo pudukemu ahudak nyumnah o enyudak aua douk yek eke wata itanamalimu.” ");
INSERT INTO apeB_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Jisas wata naklipech nakli, “Namudak ati, agundak God nupe nebenalimu ananich elpech umu douk kobi enyudak woblen balan umu. Ananu alman nakli nunak anagun lougun ali nahwalu henek ananin moul uli hanaki. Hanaki ali nalaguk ananibol utabal amamis wis umu hunek moul. ");
INSERT INTO apeB_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Anan douk nadukemu amamin save nyanu agundak dodogowim umu henek moul umu ali nokomuk utabal. Ananu nakanaguk 5,000 kina. Ananu 2,000 kina ali ananu 1,000 kina. Douk nokomuk utabal ali nanak ananih yah. ");
INSERT INTO apeB_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Nanakuk ati anudak nalau 5,000 kina uli nanak nanubu naku abaludak utabal nenek bisnis. Neneken aliga nohul 5,000 kina winmani chopuk. ");
INSERT INTO apeB_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Anudak ananu nalau 2,000 kina uli chopuk namudak ati. Nanak naku aboludak utabal nenek bisnis ali wata nohul 2,000 kina winmani chopuk. ");
INSERT INTO apeB_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Wakuli anudak nalau 1,000 kina uli nanak nalak anagu bobigu ali nobechuk ananinu nebenali ananibol utabal blolu. ");
INSERT INTO apeB_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Douk aliga loubomu nyultab banak badiyuk ali amudak henemanu moul uli nebenali wata natanomoli. Natanomoli ali nasalikam umu huklipanomu utabal nokomuk umu douk henek moulomobol blatoglu malmu malmu. ");
INSERT INTO apeB_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Anudak susubuati nalau 5,000 kina uli nasuhi 5,000 kina alagun neneken 10,000 kina ali nanaki noku ananinu nebenali. Ali naklipanu nakli, ‘Nebenyali, nyak douk nyokeik 5,000 kina. Wakuli tik, yahwen yanak yenek bisnis ali wata yogwatu 5,000 kina winmani chopuk!’ ");
INSERT INTO apeB_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Ali ananinu nebenali nakli, ‘O kalbu. Nyak nyanubu nyeneme moul kalbaluli. Echudak echech gwodich, wakuli nyanubu nyenek lukautumech kalbu. Namudak ali eke iutinyu nyunek bos umu wolobaichi echudak. Aliga wichi nyunu yek wupe wunehilau!’ ");
INSERT INTO apeB_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Anudak nalau 2,000 kina uli anan chopuk nanaki nakli, ‘Nebenyali, nyak douk nyekeik 2,000 kina. Wakuli tik, yahwen yanak yenek bisnis ali wata yogwatu 2,000 kina winmani chopuk.’ ");
INSERT INTO apeB_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Ali ananinu nebenali nakli, ‘O kalbu. Nyak nyanubu nyeneme moul kalbaluli. Echudak echech gwodich, wakuli nyanubu nyenek lukautumech kalbu. Namudak ali eke iutinyu nyunek bos umu wolobaichi ehudak. Aliga wichi nyunu yek wupe wunehilau!’ ");
INSERT INTO apeB_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Amudak hanakuk ali anudak ananu nalau 1,000 kina uli chopuk nanaki nakli, ‘Nebenyali, yek ayadukemech umu nyak douk nyanubu nyihihichinyu atinyoli alman. Nohobigas kipahechi chawechogos uli douk i save nyanak golomenyoguk nyanosagnumu kakwich. Wit namudak ati. Kipaichi chowachotu takih teleh ali wo nyusolik e nyanak nyonodalatu. ");
INSERT INTO apeB_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Namudak ali yek elgeiwemu nyak. Ali nyakibal nyekemoguk utabal yahwabal yanak yobechukabal blolu atap. Ali douk abaludak.’ ");
INSERT INTO apeB_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Ali ananinu nebenali nebemanu balan nakli, ‘Nyak douk nyanubu yowenyali alman nyeneme moul. Nyapemu alikeh atih hanyu. Nyak douk nyadukemech kalbu. Kakwich yaklipu kipahechi chawech uli douk yek wata yanasagnumech. Wit douk namudak ati. Kipahechi chawotu aliga tauh, yek yanaki yonodalatu. ");
INSERT INTO apeB_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Nyadukemech namudak ali wo nyunak nyubolemume beng e? Umu wata itanamali ali inak inahuli yekibal blunu anabal winmani blutanuhumeli chopuk? ");
INSERT INTO apeB_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Aliga punubu putulunu enyudak 1,000 kina ali puku nani douk nasuh 10,000 kina uli. ");
INSERT INTO apeB_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Umu monoken, ihech elpech douk achasuh enech echudak uli, echech douk eke wata chulau enech alagun ali chunubu chuglemu wolobaichi echudak. Wakuli echebuk douk echudak wakech uli, echebuk gwodich chenechubuk uli eke wata chunotulichech ali chunubu chupeik meyoh. ");
INSERT INTO apeB_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Aliga pusuh anudak yowenali alman douk neneme moul uli ali puwachanu nutoglu gani aduk yomotokweh umu. Puwachanu nutoglu gani douk elpech eke chuleh, naluh hlunak hlichukuk ali chumnek nebehi nyih umu.’” ");
INSERT INTO apeB_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Jisas balan nyeilen nakli, “Kwali yek Anudak Alman yatoglu aduligeinyi elpen uli itanamalimu douk eke itanamali kobi ananu king umu. Chanatimaguk ensel eke chuname munaki. Eke ibihi itemu yekin nyanubu yopinyi nebenyi sia ali eke inubu yeul nyukihe. ");
INSERT INTO apeB_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Ali chanatimaguk elpech chape ihen kantri apudak atap uli eke chunaki agundak yek yapemu. Chunaki ali eke iyaisech umu biob lainab. Iyaisech kobi ananu nenek lukaut umu sipsip uli neyais sipsip sik ali memehas sik umu. ");
INSERT INTO apeB_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Echech sipsip eke iklipech chunamu yekin anin logul ali memehas eke iklipech chunamu algan. ");
INSERT INTO apeB_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Ali yek nebeweli king eke iklipu echudak cheyotu onuwemu uli ikli, ‘Ipak yowi. Yekinu Aninu douk anenekumepu yopinyi. Punaki puwich pupe yopubuli wabul ali pulau yopichi echudak. Echudak douk seiwak agudak nahabigu gatoglu ati natalihech ali nechubuk chakusumepu uli. ");
INSERT INTO apeB_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Umu monoken, likuk nyulub blae ipak peke kakwich yachah. Abal blagahege abali, peke abal yabalah. Yanaki wo pudukemeye, wakuli pohwale yawichu ipakig wilag yanepu mape. ");
INSERT INTO apeB_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Luseh woke, peke luseh yenekeh. Agudak geneke, ipak penek lukautimume. Yenek kalabus yape, panaku patiweik.’ ");
INSERT INTO apeB_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Namudak ali echudak yopichi elpech eke wata chusolike chukli, ‘O Diginyali, meibali nyultab matulinyu nyulub blanyu ali mabilomenyu? Meibali nyultab matulinyu abal blagahogenyu ali mokenyu abal nyabalah? ");
INSERT INTO apeB_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","O meibali nyultab matulinyu wo mudukemenyu e, wakuli mohwalenyu nyawichi apakig wilag nyanapu mape? O luseh wakenyu mokenyu luseh nyenekeh? Meibali nyultab? ");
INSERT INTO apeB_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","O matulinyomu agudak ganyu o nyenek kalabus nyape manaku matulinyoguk?’ ");
INSERT INTO apeB_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Ali yek nebeweli king eke iklipech ikli, ‘Adul ati yaklipepu. Enenyi enen douk peneken umu enen echudak yekich yeguh wakechi owachich ulimu, enyebuk douk panubu peneken umu yek.’ ");
INSERT INTO apeB_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Ali echudak cheyotu yekin algan umu uli, yek eke iklipech ikli, ‘Ipak punak puwichuk uli, ipak kalemeik agundak. Aliga punak pugluk ehudak nyih douk chejigleh hanu hape namudak eheh nyumneh uli. Hanu hape hatimu Satan nanu ananich enselahas umu chunak chugluk umu. ");
INSERT INTO apeB_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Umu monoken, likuk patuliwe nyulub blae, wakuli wo kwalowi pubilomeye. Abal blagahoge, wakuli wo puklimu puke anabal ibalah e, wak. ");
INSERT INTO apeB_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Yanaki wo pudukeme uli e, wakuli wo puklimu puhwale iwichu ipakig wilag inepu mupe e, wak. Patiwe luseh woke, wakuli wo puklimu puke eneh inekeh e. Agudak gae wo punek lukautumeye. Yenek kalabus yape wo punaku putiweik e.’ ");
INSERT INTO apeB_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Echech eke wata chubeme balan chukli, ‘Nya Diginyali, meibali nyultab matulinyu nyulub blanyu o abal blagahegenyu, wo mudukemenyu e, luseh wakenyu, agudak ganyu o nyenek kalabus nyape ali wo mugakomenyu e? Meibali nyultab?’ ");
INSERT INTO apeB_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Yek eke wata iklipech ikli, ‘Adul ati yaklipepu. Enenyi enen douk wo puneken umu enen echudak yekich douk chanubu yeguh wakech uli elpech umu e, enyebuk douk panubu wo puneken umu yek e, wak.’ ");
INSERT INTO apeB_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Ali echudak yowechi elpech eke chunak chulau nebehi nyih chupe namobuk ati eheh nyumneh. Wakuli yopichi eke chunak chunubu chupe kalbu eheh nyumneh.” ");
INSERT INTO apeB_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Jisas naklipech enyudak nyanatimaguk balan nyatuh ali naklipu ananim disaipel nakli, ");
INSERT INTO apeB_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Ipak padukemech, nyumneh douk watak hape bieh, umu ahudak nyumnah agundak nebeguni Pasovaigun woligun gnunenek umu eke huotglu. Ali yek Anudak Alman yatoglu aduligeinyi elpen uli eke chugilapu yekim birua ali huhwe hunak hunek nyilimume lowag kruse ali igak.” ");
INSERT INTO apeB_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Hanubu ahabuk nyumnah, amam nebemi pris hanu echech Juda echechim nebemi hanak hatik Kaiafas ali howachabal hape ananitu nebetali wilpat. Kaiafas anan douk nebenalimu hanatimaguk pris. ");
INSERT INTO apeB_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Howachabal hape heagwleh umu hakli hugwatu anah yah ali hunek trik hunak husuh Jisas honu nugak. ");
INSERT INTO apeB_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Ali hakli, “Abudak nyultab chunek agundak nebeguni woligun abali apak kobi muwechikanu. Kedeke wolobaichi elpech chuhuli wanoh chopu.” ");
INSERT INTO apeB_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Jisas douk nape Betani. Nape ananu alman chohwalanamu Saimon uli ananitu wilpat. Likuk anudak Saimon douk yowegali sig lepra gapenyunu. ");
INSERT INTO apeB_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Ababuk nyultab Jisas nape halakatimu tebol nape nawak woligun abali, onok almatok kwasuhwi enen yopinyi sanda douk chatalin nebebali utabal uli kwanaki. Nyalali anal yopuli botol douk chenekol anam utam uli ali kwanaki kwenyuklen nyagluk Jisas ananim boglom. ");
INSERT INTO apeB_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Amudak Jisas ananim disaipel hatik namudak ali nyihihichim hakli, “Kwatitehen umu enyudak yopinyi sanda. ");
INSERT INTO apeB_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Enyudak sanda deke munek salimumen musuh nebebali utabal. Ali abaludak utabal deke miyaisabal umu echudak wakechi elpech.” ");
INSERT INTO apeB_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Jisas douk anatulum nadukemech ali naklipam nakli, “Aipo, ipak panok wolug atimu okudak almatok? Okwok douk kwonekume nyanubu yopinyi pasin. ");
INSERT INTO apeB_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Echudak wakechi elpech eke chunepu pupe namudak ati pugakamech. Yek wak. Eke kobi inepu mupe namudak ati, wak. ");
INSERT INTO apeB_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Okudak almatok douk kwenyukul sanda yekih yegenyihw ali kwonek redimemu kamanomi eke che igak ali chunugomemu. ");
INSERT INTO apeB_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Adul ati yaklipepu. Ihalub walub apudak atap douk chunak chuklipech enyudak God ananin yopinyi balan umu, enyudak okwok kwoneken uli chopuk eke chuklipechumen. Ali echech douk eke ulkwip pulomok.” ");
INSERT INTO apeB_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Ali ababuk nyultab, ananu umu amudak Jisas ananim umu 12-poleim disaipel douk chohwalanamu Judas uli nanak natik amam nebemi pris. Ananibul wabul douk Kariot. ");
INSERT INTO apeB_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Nanak ali nasalikam nakli, “Sapos yek ilikepu inak igilapepu Jisas umu, ipak douk eke putaluwe puke monoken?” Hemnek namudak ali hatalunu hakanu 30-poleibal siliwaibal utabal. ");
INSERT INTO apeB_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Namudak ali banubu ababuk nyultab, Judas anape nenek tinytin umu anah yopuhi yah umu nunak nugilapam Jisas ali amam huhwanu hunak honu nugak. ");
INSERT INTO apeB_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Aliga ali ahudak susubeih nyumnah hanak hatoglali umu echech Juda chenek agundak nebeguni Pasovaigun woligun ali chawak bret douk chotoweh wo titak nebetalili e. Amam disaipel hanakimu anan Jisas ali hasalikanu hakli, “Nya, nyak nyakli apak munak munekagun agnumu agundak Pasovaigun woligun, umu nyak nyunak nyugnah umu?” ");
INSERT INTO apeB_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Ali naklipam nakli, “Punak puwich nebebuli wabul Jerusalem ali punamu anabuk alman douk yaklipepumanu uli. Punak ali puklipanu pukli, ‘Nya, apakinu Tisa nakli ananibu nyultab umu chonu nugak umu douk ahuluk. Ali nakli anan nunu apak ananipu disaipel eke munaki muwak agundak Pasovaigun woligun nyakitu wilpat.’” ");
INSERT INTO apeB_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Namudak ali amam hanak henek enyudak anan Jisas naklipam umu. Hanak ali henek redimu agundak Pasovaigun woligun. ");
INSERT INTO apeB_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Douk aliga wabigun halakatimu wab ali Jisas nanu ananim 12-poleim ahanaki hape halihi halih tebol. ");
INSERT INTO apeB_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Douk hape hawok woligun ali naklipam nakli, “Aipo, aduligu atugu yaklipepu. Ipak ananu eke nugilapu yekim birua yek ali eke huhwe hunak he igak.” ");
INSERT INTO apeB_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Hemnek namudak ali amamiluh apaluh hlanubu yoweluh. Ali amam atunu ati ahape hasalikanu hakli, “Nya Diginyali, ati eke nyaklimu yek, waka?” ");
INSERT INTO apeB_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Ali Jisas nebemom balan nakli, “Alman douk eke anudak dokwechuh nane wautu wis sagluk dis walupali bret uli. Eke anabuk nugilapu yekim birua yek ali eke huhwe hunak he igak. ");
INSERT INTO apeB_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Yek Anudak Alman yatoglu aduligeinyi elpen uli douk eke che igak kobi balan nyetemu God ananik buk uli nyaklimu. Wakuli alman douk nugilapu yekim birua yek uli, yek douk yanubu yakli mapilinu anan. Mamakik kobi kunololile douk deke kalbumanu.” ");
INSERT INTO apeB_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Ali anudak Judas douk eke nugilapu Jisas ananim birua anan Jisas uli nakli, “Nebenyali Tisa, ati enyebuk douk nyaklien umu yek, waka?” Ali Jisas nebemanu balan nakli, “Douk enyebuk nyanubu nyakli wo.” ");
INSERT INTO apeB_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Douk hape hawok kakwich ali Jisas nohul anatu bret nenek tenkyumu God ali nape nagwudukatu noku ananim disaipel. Ali naklipam nakli, “Atudak bret douk yekih yegenyihw. Ipak suh putowoh.” ");
INSERT INTO apeB_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Ali wata nohuli anap kap wainibal abal. Nanahuli nenek tenkyumu God ali nokom. Ali nakli, “Ipak punatimaguk pubalah apudak kap. ");
INSERT INTO apeB_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Abaludak wainibal abal douk yekig butog. Ogwog douk eke gunek enyudak God ananin adulin atinyi balan kontrak nyutoglu dodogowin. Ogog eke gutukwlemu gugakomu wolobaichi elpech ali God eke kobi nunohwen nupemu yowenyi elpech cheneken uli, wak. Eke nukwleyenyuk. ");
INSERT INTO apeB_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Aduligu atugu yaklipepu. Abaludak wainibal abal eke kobi wata iwok anabal, wak. Eke ipe namudak aliga inu ipak muwak nupoleibal abal agundak yekinu Aninu nape nebenalimu ananich elpech umu.” ");
INSERT INTO apeB_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Naklipam umu julug douk heyolub onahw awehw ali hatoglu haltomu anudak maunten Oliv. ");
INSERT INTO apeB_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Hanak hakih Oliv ali Jisas naklipam nakli, “Kehik wab, ipak punatimaguk eke putukemeik pulhwas punak atunu ati. Umu monoken, balan nyetemu God ananik buk uli douk nyakli, ‘Eke ibouk anudak nenek was umu sipsip uli, ali sipsip eke chulhwas chunak atin atiyuk.’ ");
INSERT INTO apeB_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Eke che igak, wakuli eke wata itaki ali ilik inamu Galili. Ali ipak eke pugime punaku.” ");
INSERT INTO apeB_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Ali Pita nebemanu balan nakli, “Sapos amudak hunatimaguk hukli hutukemenyaguk hulhwas umu, yek eke inenyu wupe biohu.” ");
INSERT INTO apeB_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Ali Jisas naklipanu nakli, “Adul ati yaklipenyu. Kadak abudak wab, nyak eke anyunek lohumechuk bieh atuh nyukli nyak wo nyudukemu yek e, ali owotu eke adakio titak tiyagwleh.” ");
INSERT INTO apeB_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Ali Pita nebemanu balan nakli, “Yek eke kobi inek loh ikli yek wo idukemu nyak e, wak. Sapos chukli chubo nyak nyugak umu, yek chopuk eke inenyu wugak ahudak atuh.” Hanatimaguk ananim disaipel douk haklipanu enyudak atin balan. ");
INSERT INTO apeB_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Ali Jisas nanu ananim disaipel haitak hanamu anagun chohwalogunmu Getsemani uli. Hanak hatoglu ali naklipam nakli, “Ipak pupe agundak ali yek inak gani inek beten.” ");
INSERT INTO apeB_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Naitak natukulmu Pita nanu biom Sebedi ananim nugamim heilanu hanak. Hanaku wakuli Jisas nemnek ananih apahw hwanubu amam ali nemnek sisahw. ");
INSERT INTO apeB_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Ali naklipam nakli, “Yekin michin nyanubu yowen ali ama igak ati. Ipak pupe agundak pune mupe munek was.” ");
INSERT INTO apeB_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Ali natukemomuk nanaku kwalowi ati ali nanubu nabih nogwohebil natik atap ali nenek beten nakli, “O yekinyu Aninu, douk wosik ele, yakli nyak nyuwechikuk yah umu enyudak nebenyi hevi douk eke nyutoglome uli umu enyen kobi nyutoglome, wak. Wakuli yakli wak umu nyak nyugipech yekin laik, wak. Nyugipech nyakin atin laik.” ");
INSERT INTO apeB_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Nenekuk beten natanomogumu, amudak biom atunu disaipel douk natulum umu hechuh hagak. Ali nasolik Pita nakli, “Ipak wosik deke dodogowipamu pune mupe munek was atin aua meyoh o wak? ");
INSERT INTO apeB_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Ipak punek was pupe ali punek beten. Punek namudak umu Satan nunaki nichakomepamu ipak eke kobi punek enen yowenyi. Adul ipak douk oub baitak umu pugipech yekin balan, wakuli ipakiluh yegechiweluh douk wo dodogowiluh e.” ");
INSERT INTO apeB_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Ali wata chopuk nanak anah alagun nenek beten nakli, “O yekinyu Aninu, sapos nyak kobi nyuwechikuk yah umu enyudak nebenyi hevi douk eke nyutoglome ulimu, yek yakli enyen wosik nyutoglome. Nyugipech nyakin atin laik.” ");
INSERT INTO apeB_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Nenekuk beten natanomumogu douk wata chopuk nogwatom hechuh hagak. Umu monoken, yobus sanubu sahwom didigu. ");
INSERT INTO apeB_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Natulum namudak ali natukemom hechuhuk nanak nenek beten anah alagun ali hatoglu beih atuh. Nanak nenek enyudak atin beten. ");
INSERT INTO apeB_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Ali wata natanomumali amam disaipel ali naklipam nakli, “Aipo, ipak wata pechuh penek malolo ati? Wata mnek! Nyultab douk abanaki, umu ananu eke nugilapu henek yowenyili umu yek Anudak Alman douk yatoglu aduligeinyi elpen uli ali eke hunaki huhwe huwechike. ");
INSERT INTO apeB_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Aipo, aliga kitak munak. Wata tik, alman eke nugilapu yekim birua yek uli douk anudak nanaki.” ");
INSERT INTO apeB_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Jisas wata nape neyagwleh ati ali Judas ananu umu amudak 12-poleim disaipel nanubu nanak natogloli. Nanoli hanubu wolobaimi almom douk nebemi pris hanu echech Juda echechim nebemi hokogomi ali hasuhwi beinatog uli lowas hanaki. ");
INSERT INTO apeB_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Judas anudak douk eke nugilapu Jisas ananim birua anan Jisas uli douk anaklipami nakli, “Alman douk putiwemu itoglu ati inoplikanu uli, alman douk akonobuk. Putoglu puhwanu.” ");
INSERT INTO apeB_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Ali ahudak atuh Judas neilmu Jisas nanak ali nakli, “Yopubi wab nebenyali Tisa.” Naklipanu namudak ali nanoplikanu. ");
INSERT INTO apeB_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Ali Jisas naklipanu nakli, “O elpen, nek wisnabul enyebuk douk nyanamali nyuneken uli.” Nakli namudak ali amudak almom hanubu hatoglali Jisas hahwanu dadag ali howechikanu. ");
INSERT INTO apeB_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Hahwanu namudak ali ananu umu amabuk hanu Jisas heyotu agnabuk uli nautu wis umu ananitu bainat. Douk natukotoli ati tagluk ananu douk nape chukamomu nanubu nebenali pris ali nenemanu moul meyoh uli. Nolukonu atah tuk hanakuk. ");
INSERT INTO apeB_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Ali Jisas naklipanu nakli, “Nubu lukuk nyakitu beinat agnabuk tatuk umu. Yaklipenyu, chanatimaguk elpech douk chuku bainatog chubo kipahechili, echech eke kipahechi wata chech bainatog. ");
INSERT INTO apeB_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Nyak eke nyadukemech waka wak? Yek ikli ihwalu yekinu Aninu ele, anan deke wisnabul nukagasi chanubu wolobaichi ensel checholokuk 12-poleib lainab ami chunaki chugakome. ");
INSERT INTO apeB_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Wakuli sapos yek ikli ihwalu anan umu nugakome umu, orait balan nyetemu ananik buk uli eke kobi nyutoglu adulin, wak. Enyudak balan nyakli enyudak imas nyutoglome.” ");
INSERT INTO apeB_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Ali banubu ababuk nyultab Jisas natanomomu amudak wolobaimi almom ali naklipam nakli, “Ipak pakli yek douk onowe yanu gavman malpak uli o onowe yaku olugwih uli, waka? Umu paitaki pasuhi bainatog gwanu lowas umu punaki puhwe puwechike pulawemu? Wihlu wehlu douk yape yaklipech God ananin balan numun banis God ananitu nebetali wilpat tatawomu. Ali ababuk nyultab douk wo punaku puhwe puwechikeye? ");
INSERT INTO apeB_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Wakuli ihenyumali enyudak douk nyatoglamu enyudak balan amam profet henyemaguk uli nyutoglu adulin atin.” Douk Jisas naklipech enyudak balan ali hanatimaguk ananim disaipel hatukemanaguk halhwas hanakuk. ");
INSERT INTO apeB_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Amudak douk hanaki hasuh Jisas uli douk hahwanu ali halawonomu nanubu nebenali pris chohwalanamu Kaiafas uli ananitu wilpat. Echech Juda echechim nebemi hanu amam henek skulumech umu lo uli douk adokwechuh howachabal hape numun. ");
INSERT INTO apeB_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Pita anan douk nagipech Jisas nanak, wakuli wo nunech huluk e, wak. Nagikuk ati aliga nanak nakih nawich numun banis anudak nanubu nebenali pris ananigu awagu. Nawich nanu amam henek was umu God ananitu wilpat uli hape umu nakli kadak nutik chunekanu malmu Jisas umu. ");
INSERT INTO apeB_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Amam nebemi pris hanu hanatimaguk nebemi Juda douk hape hasuh kwotog uli hohwalu anam almom hanaki. Douk hanaki ali hape henekumanu enen wo adulin uli e balan Jisas umu amam nebemi honu nugakumenyi. ");
INSERT INTO apeB_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Wolobaimi hanaki henek loh henekumanu wak adulin uli e balan, wakuli amam habilak wak. Habilak wak aliga biom haitak heyotu hakli, ");
INSERT INTO apeB_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","“Anudak alman nakli namudak. Nakli, ‘Yek deke italkeh God ananitu nebetali wilpat ali wata itahul ilatu iyatotu bieh atuh nyumneh meyoh.’” ");
INSERT INTO apeB_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Ali nebenalimu hanatimaguk pris uli naitak neyotu nasolik Jisas nakli, “Nyak enen balan umu nyubeyenyumom o wak? Nyaklien malmu enyudak balan douk amudak heneken-umenyu uli?” ");
INSERT INTO apeB_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Nasolikanu wakuli Jisas neyotu bleiloguk. Ali anudak pris wata naklipanu nakli, “Nameitu douk yasolikenyamu God douk nanubu nape eheh nyumneh uli ananin yeul, ali yakli nyunubu nyuklipapu adulin atin. Nyak douk anudak alman douk God naklimu eke nutalihanu ali nukaganu nunamali nunolau elpech uli waka? Nyak douk God ananinu Nuganinu o wak?” ");
INSERT INTO apeB_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Ali Jisas naklipanu nakli, “Enyebuk douk nyakli wo. Wakuli douk yaklipepu. Kwali ipak eke putik yek Anudak Alman douk yatoglu aduligeinyi elpen uli eke ipe anunamu nanubu dodogowinu atunoli God ali eke ilali onog inaki gani iluh heven.” ");
INSERT INTO apeB_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Anudak nanubu nebenali pris nemnek namudak nyihihichinu ali nanubu nakawech ananih luseh. Ali nakli, “Anudak alman douk nenek tok bilas umu God. Ali eke wata muhwalu enech alagun chunaki chunemanu monoken meyoluhin balan? Enyudak douk nameitati pemnekonu nenek tok bilas umu God. ");
INSERT INTO apeB_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Ali ipak pakli apak imas munekanu malmu?” Ali hebemanu balan anudak nebenali pris hakli, “Anan douk nenek yowenyi ali eke monu nugak umu atugun.” ");
INSERT INTO apeB_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Ali haitak hokusehanu gani yomogeinamu. Hadalu wis hahwas hanu dilbum. Anam heyonu wis hahwas ali hanu gani yomogeinamu. ");
INSERT INTO apeB_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Haitak hobechukuk ananis nabes ali hasalikanu hakli, “Nya, God natalihenyu ali nokogenyu nyanamali nyunalau elpech uli, aliga wata klipapu kobi amam profet umu. Nameitu douk omuni nyanu?” ");
INSERT INTO apeB_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Pita douk napeik aduk nunumisumu asudak banis douk salihi salih Kaiafas ananitu wilpat uli. Ali onok kwonek moulaluli kwanaki kwatulunu ali kwaklipanu kwakli, “Nyak douk alagun nyanu anudak Jisas douk nanaki Galili uli pape.” ");
INSERT INTO apeB_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Wakuli echech chanatimaguk chape ali nenek loh nakli, “Enyebuk nyak nyaklienyi balan douk wo idukemen e.” ");
INSERT INTO apeB_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Douk nanak umu nutoglaguk aduk asudak banis ali onok alagun kwonek moul uli almatok kwatulunu. Ali kwaklipu echebuk cheyotu agnabuk uli kwakli, “Anudak alman douk nanu Jisas nanaki wabul Nasaret uli hape.” ");
INSERT INTO apeB_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Ali Pita wata nenek loh nalimu iluh nakli, “Anudak alman douk wo idukemanu e.” ");
INSERT INTO apeB_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Douk chapegu wo loubali e, enech cheyotu agnabuk uli cheilmu Pita chanak ali chaklipanu chakli, “Adul, nyak douk enenyu Jisas ananipamu. Nyakigu nigu ganubu gowolehenyu.” ");
INSERT INTO apeB_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Douk Pita nemnek ali wata nenek lohumech nakli, “Adul gani iluh. Anudak alman douk wo idukemanu e. Sapos yek inek lohumepamu, yek douk yakli God ne igak.” Douk nakli enyudak balan neyaten ati owotu tanubu taitak tohwalu. ");
INSERT INTO apeB_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Pita nemnek owotu ali wata ulkum molomaguk balan Jisas nakliponomu. Nakli, “Nyak eke nyunek lohumechuk bieh atuh nyukli nyak wo nyudukemu yek e, ali owotu eke adakio titak tuhwalu.” Douk Pita ulkum molomaguk enyudak balan ali natoglu aduk neleh chukeich chanu. ");
INSERT INTO apeB_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Douk aliga gagluk aglupil atul, ali hanatimaguk nebemi pris hanu echech Juda echechim nebemi hape heagwleh ali howechik balan umu hubo Jisas nugak. ");
INSERT INTO apeB_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Haitak howechikanu onoh dodogowihwi naduh ali halawanu hanamu Pailat. Pailat anan douk nape nebenalimu gavman. ");
INSERT INTO apeB_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Anudak Judas douk nagilapu Jisas ananim birua anan Jisas uli natik umu Jisas douk eke chonu nugak. Namudak ali ananihw apahw hwanubu yowehw umu enyudak anan neneken uli. Ali wata nenek senis umu tinytin nanak nebemamuk abaludak 30-poleibal siliwaibal utabal douk amam nebemi pris hanu echech Juda echechim nebemi hokoneyabal uli. ");
INSERT INTO apeB_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Ali naklipam nakli, “Yek douk ayenek yowenyi. Anabuk alman yagilapepu pahwanu panak umu ponu nugak uli douk yopunali. Wak nunek enen yowenyi e, wak.” Wakuli nebemi hebemanu balan hakli, “Ali nyaklipapamu. Enyebuk nyakin moul.” ");
INSERT INTO apeB_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Judas nemnek namudak, nowachak abaludak utabal blawich numun God ananitu nebetali wilpat ali nanak nenek hangamap nagak. ");
INSERT INTO apeB_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Amam nebemi pris hohul abaludak siliwaibal utabal ali hakli, “Abaludak utabal douk mobolubuk umu alman nugak umu. Ali apakin lo douk nyakli abaludakmoli utabal kobi mubolubuk umu abaludak blakus numun God ananitu nebetali wilpat uli, wak.” ");
INSERT INTO apeB_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Habo balan nyakus atugun ali abaludak utabal habaluhul hanak hatik enech elpech chalok magusis malus uli ali hatal anab echechib amnab. Hatalub umu chunek matmat ali chunugamu lougunich douk chanaki chanu echech Juda chape uli. ");
INSERT INTO apeB_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Namudak ali abudak amnab douk chohwalab, “Butogwibi Amnab.” Nameitu okudak outuk douk wata chohwalok enyudak atin yeul. ");
INSERT INTO apeB_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Namudak ali enen balan seiwak God nohul profet Jeremaia nenyemaguk uli nyatoglu adulin atin. Balan enyudak. Nakli, “Haitak hohul abaludak 30-poleibal siliwaibal utabal. Abaludak utabal douk echech Isrel chabalubuk umu chutal anudak alman uli. ");
INSERT INTO apeB_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Habaluhul ali hanak hatik echech chapemu chalak magusis malus uli ali hatal anab amnab. God douk naklipe dodogowinyi balan ali yeyagwleh enyudak.” ");
INSERT INTO apeB_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Halau Jisas hanak neyotu natik anudak nebenalimu gavman uli ali nasolikanu nakli, “Nyak douk echech Juda echechinyu king?” Ali Jisas nebemanu balan nakli, “Adul, Yek douk kobi nyak nyaklimu.” ");
INSERT INTO apeB_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Echech Juda echechim nebemi hanu nebemi pris hape henekumanu balan abali, anan douk wo nubemam enen e, wak. Neyotu bleiloguk. ");
INSERT INTO apeB_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Namudak ali Pailat wata nasolikanu nakli, “Nya, nyemneken waka wak, enyudak nyanatimaguk balan amam heneken-umenyu uli?” ");
INSERT INTO apeB_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Wakuli Jisas nanubu wo kwalowi nubemanu enen atin balan Pailat e, wak. Namudak ali Pailat nanubu loguh hwonechlukanu. ");
INSERT INTO apeB_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Ihech yohleguh, ahudak nyumnah chenek agundak nebeguni Pasovaigun woligun abali, anabuk nape nebenalimu gavman uli douk i save nokwechih ananu nenek kalabus uli natoglu nanak fri. Wolobaichi elpech chuhwalamu meinali, anan eke nukwechihi anabuk nutoglali. ");
INSERT INTO apeB_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Ali ababuk nyultab, ananu nanubu yowenali alman douk nenek kalabus nape. Ananin yeul douk Barabas. ");
INSERT INTO apeB_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Douk wolobaichi elpech chanaki chowachobol ali Pailat nasolikech nakli, “Ipak pakli ikwechihumepagu meinali? Pakli ikwechihu Barabas waka anudak Jisas douk chakli God natalihanu ali nakaganu nanamali nunolau elpech uli?” ");
INSERT INTO apeB_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Pailat douk nakli namudak umu monoken, anan nanubu nadukemech umu amam douk henek hinyigimu Jisas umu wolobaichi elpech chagipech anan atunu. Douk namudak ali amam nyihihichim ali dakio hahwanu halawonolimu Pailat. ");
INSERT INTO apeB_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Ali ababuk nyultab Pailat wata netemu enyudak sia douk nape nasuh kwotog umu abali, ananik almatok kwanekumanali balan namudak kwakli, “Nyak kobi nyukli nyunekanu malmu anabuk duldulinali alman, wak. Yek douk yonobek anas yomnis yatulunu ali doumeih yekim ulkum douk molu sisahw yanubu elgeiwe. Anan douk yopunali alman.” ");
INSERT INTO apeB_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Wakuli amam nebemi pris hanu Juda echechim nebemi hohul echudak wolobaichi echechiluh apaluh umu chuhwalamu Barabas nutoglali ali Jisas chonu nugak. ");
INSERT INTO apeB_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Ali Pailat nasolikech nakli, “Aipo, amudak biom almom douk pakli ikwechih meinali nutoglamepagu?” Ali chebemanu balan chohwalu chakli, “Nyukwechihi Barabas.” ");
INSERT INTO apeB_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Ali Pailat nasolikech nakli, “Ali anudak Jisas douk chohwalanamu Krais uli eke inekanu malmu?” Echech chanatimaguk chohwalu chakli, “Punek nyilimumanu lowag kruse.” ");
INSERT INTO apeB_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Ali Pailat wata nasolikech nakli, “Anan nenek monoken yowenyi umu monu nugakumenyi?” Wakuli echech chanubu chohwalu nebegun atugun chakli, “Nek nyilimumanu lowag kruse.” ");
INSERT INTO apeB_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Pailat natik umu ananin balan nyanak pluplu nyeiluk ali halakatimu nebehwi wanoh hwitak. Namudak ali nohuli anabal abal chanatimaguk cheyotu chatulunu ali naklipu ananis wis. Ali naklipech nakli, “Pukli pubo anudak alman nugak umu, enyebuk ipakin moul. Yek douk balan woke.” ");
INSERT INTO apeB_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Ali chanatimaguk chebemanu balan chakli, “Wosik, apak makli enyudak yowenyi douk moneken umu anan uli, apak makli enyen wosik iken nyutanamumali apak munu apakich batowich!” ");
INSERT INTO apeB_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Namudak ali Pailat nokwechih Barabas natoglomech ali naklipu amam soldia hasakanu onoh naduh Jisas. Ali naklipam halawanu hanak umu hunek nyilimumanu lowag kruse. ");
INSERT INTO apeB_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Ali Pailat ananim soldia halau Jisas hawich nebetali gavman echechitu wilpat. Hawich ali hanatimaguk soldia hanaki heyotu halihi-halihanu. ");
INSERT INTO apeB_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Ali hatulunu howaluk ananih luseh ali halamanu anatu loutali ouchibalitali saket. ");
INSERT INTO apeB_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Ali halawali onoh puligwiluh hlatoglohwi naduh hadalechoh henekoh kobi ananu king ananitu hat umu ali hohwemumanu boglom. Holu anah oluh ananis anus wis ali habih hoduk ohlubus hape henekanu enen enen hakli, “O luahep nyak echech Juda echechinyu king.” ");
INSERT INTO apeB_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Hokusehanu ali hatulunali oluh hape hapulanu boglom wolobaih atih. ");
INSERT INTO apeB_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Douk henekanu enen enen umu julug, ali wata hatulunu howaluk atudak ouchibalitali saket ali holomonu ananih yet. Ali halawanu hanak umu hunek nyilimumanu lowag kruse. ");
INSERT INTO apeB_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Douk hatukemaguk wabul hatoglu hanak yah ali hogwatu ananu alman chohwalanamu Saimon uli. Anan douk nanaki wabul Sairini. Amam soldia dodogowim atum ali hanalakumanu natulunu kruse Jisas nenyusah-umanu. ");
INSERT INTO apeB_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Hanak aliga hanak hakih anagun chohwalogunmu Golgota. Enyudak yeul Golgota douk chakli gnape kobi elpenyim boglom umu. ");
INSERT INTO apeB_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Hakih agnabuk ali hakanu ananu wain douk haglogul ananu nanubu nubutinali marasin nagluk umu. Nechakomonogu wakuli nakli wak umu nunowoh. ");
INSERT INTO apeB_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Henek nyilimumanu kruse ali heneyais ananih luseh. Heneyaiseh umu douk habilak enen pilai kobi satu umu ali amam atunu ati hanotukeh. ");
INSERT INTO apeB_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Ali ahape agnabuk hape henek wasumanu. ");
INSERT INTO apeB_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Chihah umu ananim boglom douk howemu enyudak balan douk chenemanu kwot umu nyape. Balan enyudak, “Anudak douk Jisas, echech Juda echechinu King.” ");
INSERT INTO apeB_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Biom douk haku olugwih ali habo elpech uli douk chopuk chenek nyilimumam heil wibul wobul umu Jisas. Ananu neil anunamu, ananu alganamu. ");
INSERT INTO apeB_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Ali elpech douk chenek lihilahe yah uli chape chaklipaganu chenekanu enen enen. Chouluk balagas atugas ");
INSERT INTO apeB_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","ali chakli, “Nobowokih douk nyakli deke nyutalkeh God ananitu nebetali wilpat ali bieh atuh nyumneh meyoh eke wata nyutahul nyulatu nyiyatatu. Aliga nameitu douk gakomu nyak yet. Nyak adul God ananinu Nuganinamu, aliga nyutukemaguk kruse nyubihi atap.” ");
INSERT INTO apeB_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Amam nebemi pris hanu amudak henek skulumech umu lo uli hanu amam echech Juda echechim nebemi, amam douk chopuk henekanu enen enen namudak ati. ");
INSERT INTO apeB_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Hakli, “Kipahechimu nagakamech, wakuli nameitu anan yet umu wak. Anan douk apak Isrel apakinu king. Ali douk aliga nutukwechihi nibihi atap, umu apak eke mutulunu ali munek bilipumanu. ");
INSERT INTO apeB_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Anan nakli adul umu God eke nugakamanu, ali nakli anan douk God ananinu Nuganinu. Ali douk sapos God anan ulkum manahwanu ele, aliga nameitu douk nugakamanu.” ");
INSERT INTO apeB_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Amudak biom hakwu olugwih ali henek nyilimumam krusehas heil halakatimu Jisas uli namudak ati. Henekanu enen enen Jisas. ");
INSERT INTO apeB_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Aliga 12 klok nyumnah toul ali wab babih beyawiyuk blanatimaguk walub ali yomotokweh tugtug. Yomotokweh hape namudak aliga 3 klok wabigun ali wata chopuk hwalalagun. ");
INSERT INTO apeB_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Douk aliga hwabigun alakatimu 3 klok ali Jisas nanubu nahwalu nebegun echechim tok ples nakli, “Eli, Eli, lema sabaktani?” Bawogen umu enyudak balan douk nyakli, “Yekinyu God, yekinyu God, nyak nyatukemeik umu monoken?” ");
INSERT INTO apeB_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Ali enech elpech cheyotu agnabuk uli chemnek ali chakli, “Anan nahwalu Ilaija.” ");
INSERT INTO apeB_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Ali ananu wisnabul nasahul nanak nohuli enen spans nautin anabal nubutibali abal. Douk spans chuknin, natuken nowechiken anah oluh ali noku Jisas umu nubalah. ");
INSERT INTO apeB_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Wakuli hanatimaguk amudak anam hakli, “Suh, mupe mutulugun iyuh. Ati Ilaija eke nutoglu nugakamanu o wak?” ");
INSERT INTO apeB_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Jisas wata chopuk nahwalu nebegun anah alagun ali michin nyakihuk nagak. ");
INSERT INTO apeB_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Ali banubu ababuk nyultab, ahudak nebehi lupah douk numun God ananitu nebetali wilpat uli tukoloh umu bieh. Gani iluh tukoloh aliga hanak habih hatau. Atap chopuk guldugolop ali bulbudib gulgwololou. ");
INSERT INTO apeB_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Iwagas chanugomu chagak ulimu gulgwolologos ali wolobaichi God ananich elpech douk likuk chagak uli wata chaitaki. ");
INSERT INTO apeB_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Chatukemaguk iwagas chaitak chape aliga douk Jisas naitaki ali echech chanak chawich abuldak God ananibul wabul Jerusalem. Chanak chawich ali wolobaichi elpech chogwatech. ");
INSERT INTO apeB_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Nebenali soldia nanu amabuk douk hananu nape henek was umu Jisas uli hatik enyik kwatuk umu, hatik ihenyumali enyudak nyatoglu uli ali hanubu elgeim. Ali hakli, “Aduligu atugu, anudak alman douk God ananinu Nuganinu.” ");
INSERT INTO apeB_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Wolobaiwali almagou douk weyatuk kwalowi lougun ali wape watulichu. Owou douk wagipechi Jisas gani Galili wanakimu wugakamanamu kakwich uli. ");
INSERT INTO apeB_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Oudak wolobaiwali almagou, biou owou douk atin yeul Maria. Onok douk kwanaki wabul Makdala. Ali onok douk Jems nanu Josep amamik mamakik. Ali okudak onok douk Sebedi ananim nugamim amamik mamakik. ");
INSERT INTO apeB_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Aliga wabigun, ali ananu alman douk noluk wolobainyi mani uli nanaki. Ananin yeul douk Josep ali nanaki wabul yeulibulmu Arimatia. Anan douk ananu nagipech Jisas uli. ");
INSERT INTO apeB_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Nanaki nanamu Pailat ali nasolikanamu nuble Jisas nunak nunugomonu. Pailat nakli wosik ali naklipu amam soldia umu hubleyanali kruse hukoneyonu. ");
INSERT INTO apeB_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Josep natulum Jisas ali napnugonu anah namuhi chogolihwihi lupah. ");
INSERT INTO apeB_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Ali nanak nawich nonowemaguk numun onoh namuhwi hulupihw. Ohudak hulupihw douk nobowokih ati anan Josep yet nenekah onok bulbuduk. Nanabukuk ali nahinali amam nebemi utam nanaki nagahuk ohudak hulupihw ali nanak. ");
INSERT INTO apeB_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Maria douk kwanaki Makdala uli kwanu okudak onok Maria douk wape wobul halakatimu hulupihwigu iwagu wape watulugun. ");
INSERT INTO apeB_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Nyumnah douk chenek gibe gabe enechi enech echudak umu wehluwih eke moul wak chupe meyoh umu douk hatuh. Douk wehluwih ali amam nebemi pris hanu amam Farisi hanak hatik Pailat. ");
INSERT INTO apeB_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Hanak ali haklipanu hakli, “Nebenyali, apak ulkwip polomu enen balan douk anudak napemu nenek lohumech uli wata nape ali naklienyuk uli. Nakli, ‘Eke igak ali hukli bieh atuh nyumneh umu, eke wata chopuk itaki.’ ");
INSERT INTO apeB_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Namudak ali makli nyak nyuklipu amam soldia hunak hupe hunek was kalbu gani matmat hulupihw umu bieh atuh nyumneh. Kedeke ananim disaipel hunaki hukumanu aluh ali hunek lohumech hukli anan douk wata naitak. Nobowokih nalik nenek lohumech umu douk kwalowi. Wakuli nameitu sapos hukli hunek loh hukli anan douk wata naitak umu, enyudak eke nyunubu nyutoglu nebeben atin ali apak douk manubu makli waken.” ");
INSERT INTO apeB_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pailat nemnek ali naklipam nakli, “Ipak kale pulau anam soldia ali punak punek was umu matmat kalbu kobi ipak padukemech ali dodogowipamu puneken umu.” ");
INSERT INTO apeB_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Naklipam namudak ali hanak henekuk anagu mak henek tabumoguk agundak chanugomu Jisas umu. Henekuk enyudak ali hosopoguk amam soldia heyotu hape henek was. ");
INSERT INTO apeB_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Ahudak nyumnah Sabat, echech Juda douk wo chunek moul e wak, chape meyoh. Aliga wehluwih susubeih nyumnah umu wik halakatimu gugluk, ali Maria douk kwanaki Makdala uli kwanu okudak onok Maria wanak watik agudak hulupihwigu iwagu. ");
INSERT INTO apeB_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Ali ahudak atuh nebekwi enyik kwatuk. Enen Diginali ananin ensel nyatukemaguk iluh heven nyabihi atap ali nyahinaguk utam manakuk algas. Ali nyakih nyetemu chihahim umu. ");
INSERT INTO apeB_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Enyenyin domanyu nyanubu nyehiyatik kobi utagu gehiyatik gnaglak umu. Nyehlaluli luseh namudak hanubu chogolihwih kobi ais umu. ");
INSERT INTO apeB_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Amudak soldia henek was umu matmat uli douk hanubu elgeim umu enyudak ensel. Elgeim ali cheyolbechom habih hagoul hakus atap kobi chagak ulimu. ");
INSERT INTO apeB_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Ali enyudak ensel nyaklipu oudak almagou nyakli, “Kobi elgeipu, wak. Yek yadukemech, ipak douk panamali putimu anudak Jisas douk chanu chenek nyilimumanu neil lowag kruse uli. ");
INSERT INTO apeB_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Agundak wak ananu e. Anan douk anaitak kobi nubowokih naklimoguk. Wata yowi tik agundak chanabuk umu. ");
INSERT INTO apeB_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Aliga wisnabul punak puklipu ananim disaipel. Anan douk nagak wakuli wata naitak ali nalik nanamu Galili. Ipak pugimanu punak ali eke putulunu agnabuk. Yek douk yanakimu iklipepu enyudak balan.” ");
INSERT INTO apeB_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Oudak biou watik enyudak ensel ali wanubu elgeiyu. Adul elgeiyu, wakuli wanubu wonehilau. Ali wonek wisnabul watukemaguk matmat wasahul wanak umu wuklipu ananim disaipel. ");
INSERT INTO apeB_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Wasahul wanak ali ahudak atuh Jisas nanaki nogwatou yah. Ali nakli, “Aipo, luahep.” Watulunogu douk weilmanu wanak wabih wasusuh ananigas ayas ali watuk ananin yeul nyakih. ");
INSERT INTO apeB_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Ali naklipou nakli, “Kobi elgeipu, wak. Aliga punak puklipu yekim owahlim amam disaipel umu hunamagu Galili. Hunaku ali eke hugwate agnabuk.” ");
INSERT INTO apeB_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Oudak biou almagou wata wape wanak ati ali amam soldia henek was umu matmat uli hanak hawich abuldak nebebuli wabul Jerusalem. Hawich ali haklipu amam nebemi pris umu ihenyumali amam hatulin nyatogloluli. ");
INSERT INTO apeB_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Hemnek namudak ali hanak hanu echech Juda echechim nebemi howachabal hape howechik enen balan. Ali haitak hatal amudak soldia hokom nebebali utabal. ");
INSERT INTO apeB_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Hokom ali haklipom hakli, “Ipak imas punek loh pukli, ‘Apak mechuh wab ali ananim disaipel hanaki hakumanu aluh halawanu hanak.’ ");
INSERT INTO apeB_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Sapos Pailat douk nebenalimu gavman uli numnek enyudak balan ali nukli malmu, apak wosik eke munonu mugabe balan. Ipak balan eke kobi enen nyupenyipu, wak.” ");
INSERT INTO apeB_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Namudak ali amudak soldia halau utabal ali hagipech nebemi amamin balan. Ali enyudak henek loh umu balan nyoweyeh nyanak ihagun echech Juda echechumu. Ali chahwen chape dadag aliga aliga doumun. ");
INSERT INTO apeB_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Ali Jisas ananim 11-poleim disaipel hanamu enyudak provins Galili. Hanak ali hanak halto ananu maunten kobi anan naklipamuk umu. ");
INSERT INTO apeB_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Hanak hakih hogwatu Jisas agnabuk ali henek lotumanu hatuk ananin yeul nyakih. Anam wak bien tinytin. Hakli Jisas wak, anudak kipainali. ");
INSERT INTO apeB_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Anan neilmom nanaki halakati ali naklipam nakli, “Yekinu Aninu God douk aneke nebenyi namba yatoglu dodogowiwe ali yape nebewelimu ihechumali echudak chape iluh atap uli. ");
INSERT INTO apeB_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Namudak ali ipak imas punamu ihalub walub umu ihab lainab elpech ali puklipech yekin balan. Puklipech umu chumneken ali chuhwen chugipech yek. Ali punek baptaisumech umu Aninu ananin yeul, umu yek ananiwe Nuganinu yekin yeul ali chopuk umu ananin Michin enyenyin yeul. ");
INSERT INTO apeB_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Ali punek skulumech umu chugipech nyanatimaguk balan douk yek yape yaklipepeyen uli. Ali mnek, Yek douk eke inepu mupe eheh nyumneh aliga hugikuk uli nyumnah hutaglu.”");
INSERT INTO apeB_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Enyudak douk yopinyi balan umu Jisas Krais, God ananinu Nuganinu. Susubati enyudak yopinyi balan nyaitak nyanak umu douk namudak. ");
INSERT INTO apeB_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Seiwak God ananin Michin nyohul anudak profet Aisaia ali nowemu enen God ananin balan namudak. God nakli, “Yek eke ikagas ananu alman nulau yekin balan nulik nunak ali nyak eke nyugimanu. Anan eke nugabemenyu yah nulik. ");
INSERT INTO apeB_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Anan eke nunak nupe wohigunmu elpech wak umu ali nupe nuhwalu nebegun nukli, ‘Gabemonu yah Diginali. Pugabeyoh hunubu hupe duldul umu anan nugimah nunakimu.’” ");
INSERT INTO apeB_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Ali Jon douk nenek baptaisumech uli nanubu natoglu nape anagun wohigunmu elpech wak umu ali nape naklipech nakli, “Ipak pukenyuk agabus yowenyi pasin ali putanamu pukanu apaluh God. Ipak punek namudak ali yek inek baptaisumepu ali God eke kobi nunohwen umu enenyi enen yowenyi ipak pape peneken uli ali nukwleyenyuk.” ");
INSERT INTO apeB_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Ali chanatimaguk chape wolobailubi walub blape Provins Judia uli chanu chanatimaguk chape Jerusalem uli chanak umu chumnek Jon ananin balan. Echech chanak ali chowoleh echechin yowenyi chaklipanu Jon ali anan nenek baptaisumech wolub Jodan. ");
INSERT INTO apeB_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Ali Jon nenekah uli lupah douk chenekah enen mahin chohwalen umu kamel uli enyenyilub ahilub. Ali natasak uli let douk chenekatu anap mahinyip benyip. Ali kakwich anan nachah uli douk napemu nawak chulpib uli wanalin hani. ");
INSERT INTO apeB_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Ali anan naklipech nakli, “Yek yalik yanaki, wakuli ananu eke nigimeli. Anudak nigiki uli douk nanubu dodogowinu atunu nechalakuk yek. Ali chopuk, yek douk wo yopuwelimu ikwachichumonu nadululuh ananinu su e. ");
INSERT INTO apeB_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Ali yek douk yenek baptaisumepu abal meyoh, wakuli anan eke nunek baptaisumepumu God ananin Michin ali eke nukepeyen nyuwich nyupenyipu.” ");
INSERT INTO apeB_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Ali Jisas natukemaguk wabul Nasaret douk blape Provins Galili uli nanaki ali Jon nenek baptaisumanu wolub Jodan. ");
INSERT INTO apeB_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Douk nenek baptaisumanu, wakuli ahudak atuh Jisas natukemaguk wolub naltowi nakih neyotu buknap ali natik umu iluh utagu genek op. Ali natik umu God ananin Michin nyagluki kobi enyudak almin manyun umu nyabihi nyetemu Jisas. ");
INSERT INTO apeB_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Ali anagu nigu ganaki iluh heven. Ali enyudak elpen nyeyagwlehi uli nyakli, “Nyak douk nyanubu yekinu Nuganinu. Yek douk ulkum manubu manahwenyu ali yanubu yenehilau-menyu.” ");
INSERT INTO apeB_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Ali wisnabul God ananin Michin nyohul Jisas ali naitak nanak anagun wohigunmu elpech wak umu. ");
INSERT INTO apeB_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Anan nanak nape ananu aun chukninu ali 10-poleih nyumneh alagun. Ali Satan nape nechakomanamu nunek yowenyi. Ali chopuk, Jisas nanak halakatimu agnabuk wanalich mahich chapemu. Wakuli God ananich enselahas chanaki chagakamanu. ");
INSERT INTO apeB_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Douk Jon nenek kalabus napeik, ali Jisas nanamu provins Galili ali nape naklipech God ananin yopinyi balan. ");
INSERT INTO apeB_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Anan naklipech nakli, “Ahudak nyumnah douk God nakliah uli douk ahudak ahatoglu. Ali abudak nyultab umu God nupe nebenalimu ipak umu douk abanaki halakati! Douk namudak ali ipak pukenyuk agabus yowenyi ali putanamu pukanu apaluh God ali pusuh ananin balan pugipechen!” ");
INSERT INTO apeB_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Douk Jisas nape nanalahe nanak algasin umu nebenyi raunwara Galili, wakuli natik Saimon nanu ananinu owaninu Andru douk hape henek bisnis umu hatuk yeguh uli. Amam howachak ananu umben enyudak nebenyi raunwara ali hape hatuk yeguh. ");
INSERT INTO apeB_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Douk anan natulum ali naklipam nakli, “Ipak yowi pugipech yek ali igilapepamu pulau elpech chunaki chugipech yek umu.” ");
INSERT INTO apeB_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Douk anan naklipam namudak ali ahudak atuh amam hanubu hatukemaguk amamib umbenab bakusuk ali hagipech Jisas hanak. ");
INSERT INTO apeB_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Douk amam hanaku wakuli Jisas natiku biom hetemu bot hape hagabe umbenab. Amam douk Sebedi ananim nugamim, Jems nanu ananinu owaninu Jon. ");
INSERT INTO apeB_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Ali douk Jisas natulumu ali ahudak atuh nahwalom umu hunaki hugipechanu. Ali amam biom hatukemaguk amaminu aninu Sebedi nanu amudak henekumanu moul uli hetemaguk bot ali amam habihi hanu Jisas hanak. ");
INSERT INTO apeB_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Ali amam hanamu anabul wabul chohwalabul umu Kapaneam uli. Ali ahudak nyumnah Sabat echech Juda moul wak chape meyoh ahi, amam hanak hawich echech Juda chape cheyagwleh balan atali wilpat ali Jisas nape nenek skulumech umu God ananin balan echech almam almagou. ");
INSERT INTO apeB_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Ali echech chemnek ananin balan ali chanubu loguh hwonechlukech. Umu moneken, anan douk nanubu nalau nebenyi namba ali nenek skulumech naklipech balan dodogowinu atunu. Wakuli amam henek skulumech umu lo uli douk wo hunek skulumech namudak e. ");
INSERT INTO apeB_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","24","Ali douk Jisas nape nenek skulumech wakuli ananu sagabehas chapenyunali nanak nawich atudak wilpat ali nohwalu nebegun nakli, “Jisas, nyanaki wabul Nasaret uli. Nyak nyanamali nyunekapu malmu apak sagabehas? Nyak nyanamali nyopu mugak waka? Apak manubu madukemenyu nyak. Nyak douk nyanubu God ananinyu nuganinu.” ");
INSERT INTO apeB_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Wakuli Jisas nahu echudak sagabehas nakli, “Ipak sak ali putukemaguk anabuk alman putoglu punak.” ");
INSERT INTO apeB_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Ali douk Jisas nahech wakuli echech choul anudak alman nebegun. Ali anan kluk kluk nape ali echech chohwalu nebegun ali chatukemanaguk chatoglu chalhwas. ");
INSERT INTO apeB_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Wakuli echudak wolobaichi elpech chape uli chatik namudak ali echech chanubu loguh hwonechlukech. Ali chape cheneyagwleh chakli, “Enyudak nameitu apak memneken uli douk moneken balan? Seiwak apak wak mumneken ati e enyudakmali balan! Anudak alman douk nanubu dodogowinali ali echudak sagabehas chemnek ananin balan!” ");
INSERT INTO apeB_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Ali enyudak balan umu enyudak Jisas neneken uli nyoweyeh nyanak blanatimaguk walub douk blape enyudak provins Galili uli. ");
INSERT INTO apeB_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Ali amam hatukemaguk echech Juda chape cheyagwleh balan atali wilpat ali amam hanatimaguk, Jisas nanu Saimon uli Andru, hanu Jems uli Jon, hanamu Saimon uli Andru amamitu wilpat. ");
INSERT INTO apeB_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Ali agnabuk, Saimon ananik nakwlik kwagobol ali kwechuh alas. Ali wisnabul enech chanak chaklipu Jisas umu agundak okwok kwagabal umu. ");
INSERT INTO apeB_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Ali Jisas nanak nasuh okwakin logul nokuhul kwaitak kwape ali okwok kwanubu yopuk. Ali okwok kwaitak kwape kwonek kakwich umu echech chichah uli. ");
INSERT INTO apeB_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Douk aliga wabigun wah hagak ali echech almam almagou chalawali agasudak sachi chanu sagabehas chapenyich uli chanaki agnabuk Jisas napemu. ");
INSERT INTO apeB_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Ali chanatimaguk elpech chape ablabuk wabul uli chanaki chowachabal chape aduk halakatimu dua. ");
INSERT INTO apeB_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Ali Jisas nagabe wolobaichi anagali anagu agudak gach uli. Ali chopuk, nohiyahuk wolobaichi sagabehas chatoglu chalhwas. Ali sagabehas douk achadukemanu Jisas. Wakuli anan naklipech umu echech kobi chuklipu kipaichi elpech umu anan douk God ananinu nuganinamu. ");
INSERT INTO apeB_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Wata wab Jisas naitak nanak anagun elpech wak enech umu e ali nanak nape nenek beten. ");
INSERT INTO apeB_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Anan nape nenek beten wakuli Saimon nanu amudak anam disaipel hape hatimanu hanak. ");
INSERT INTO apeB_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Douk hatimanu hanak aliga hanak hogwatanu ali haklipanu hakli, “Nya, chanatimaguk elpech chape chatimenyu.” ");
INSERT INTO apeB_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Wakuli Jisas naklipam nakli, “Anyunekech, apak munamu kipailubi walub blape halakati uli ali yek iklipech yopinyi balan echech chopuk. Umu moneken, yek douk yanakumali iklipech yopinyi balan chunatimaguk elpech.” ");
INSERT INTO apeB_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Ali anan nanak ihalub walub enyudak provins Galili ali nape naklipech God ananin yopinyi balan numun echech Juda chape cheyagwleh balan ogwi wilag. Ali chopuk, nohiyahuk sagabehas douk chape elpech uli chatoglu chalhwas. ");
INSERT INTO apeB_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Ali ananu agudak lepra gapenyunali nanakimu Jisas ali nabih noduk ohlubus. Ali naklipu Jisas nakli, “Douk nyak nyukli wosik umu, nyak eke nyugabeye.” ");
INSERT INTO apeB_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Wakuli Jisas natulunu ali nanubu nenelekanu. Ali nonu logul nowemu ananis wis anudak alman ali naklipanu nakli, “Yek yakli wosik. Nyak yopinyu.” ");
INSERT INTO apeB_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Ali ahudak atuh anan nanubu yopunu. ");
INSERT INTO apeB_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","Ali Jisas naklipanu dodogowinyi balan nakli, “Nyak nyunak ali kobi nyuklipu enech elpech umu agundak yek yagabeyenyamu, wak. Nyak nyunubu nyunamu pris nutulinyu, ali nyunak nyunek enyebuk ofamu agundak nyak ayopinyomu kobi douk God ananin lo douk nokaguk Moses enyi nyaklimu. Nyak nyunek namudak ali chunatimaguk elpech eke chutulinyu ali chudukemech chukli nyak douk ayopinyu.” ");
INSERT INTO apeB_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Wakuli anan nanak ali nape naklipu wolobaichi elpech umu agundak Jisas nagabeyanamu. Ali balan nyoweyeh nyanak blanatimaguk walub. Douk namudak ali Jisas wo nunak nuwich analub walub e, wak. Anan napeik aduk albudak walub agnabuk wohigunmu douk elpech wak umu. Wakuli wolobaichi elpech chanaki wolobaigun-moluli chanak agnabuk anan nanak napemu. ");
INSERT INTO apeB_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Douk eneh nyumneh hanak hadiyuk, ali Jisas wata chopuk natanamu nanamu Kapaneam. Ali ababuk nyultab echech almam almagou chopuk, chemnek balan umu anan ananak nape wilpat umu. ");
INSERT INTO apeB_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Douk namudak ali wolobaichi elpech chanak chape numun ananitu wilpat chuknitu ali enech chape aduk halakatimu dua. Echech chape ali wak onok otuk kwupeik meyoh e, wak. Echech chape chuknigun ali Jisas nape naklipech yopinyi balan. ");
INSERT INTO apeB_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Douk nape naklipech balan wakuli 4-poleim almam howemali ananu loguh aiyas chagakanali anatu bet ali halawanu hanakimu Jisas. ");
INSERT INTO apeB_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Amam halawanu hanak wakuli wolobaichi elpech chape ali amam yah wak umu hulawanu hunak hunobuk agnabuk Jisas napemu e. Douk namudak ali amam halto hakih modupitomu wilpat ali hadal agundak Jisas napemu. Ali anudak loguh aias chagakanali nalamu bet ali hanahul hautunu nagluk nabih nakus Jisas napemu. ");
INSERT INTO apeB_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Ali douk Jisas natik amudak 4-poleim umu hanubu henek bilip umu anan eke nugabeyanamu ali anan naklipu anudak loguh aias chagakanali nakli, “O nuganinu, yek eke kobi inohwen umu nyakin yowenyi ali enyudak eke aikwleyenyuk.” ");
INSERT INTO apeB_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","7","Ali douk Jisas nakli namudak ali anam henek skulumech umu lo uli, douk hanech hape agnabuk uli amamiluh apaluh atuluh hleneyagwleh hakli, “Anudak alman neyagwleh namudak umu moneken? Anan douk nape nenek tok bilas umu God. Apak madukemech umu God atunu deke kobi nunohwen umu elpechin yowenyi ali nukwleyenyuk.” ");
INSERT INTO apeB_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Wakuli Jisas anadukemu amamim tinytin ali naklipam nakli, “Ipak ulkwip kobi pulu namobuk, wak. ");
INSERT INTO apeB_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Umu moneken, enyudak moul douk nyanubu alagun atimu yek iklipu anudak loguh aias chagakanali ikli, ‘Yek eke kobi inohwen umu nyakin yowenyi ali ikwleyenyuk’ o iklipanu ikli, ‘Kitak hul nyakis alas nyunahwas ali nyunak ali anan eke nitak nunak.’ ");
INSERT INTO apeB_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","11","Douk namudak ali yek Anudak Alman douk yatoglu aduligeinyi elpen uli eke igilapepu umu pudukemech umu yek douk dodogowiweli ali God neke namba umu kobi inohwen umu apudak atapichi elpech echechin yowenyi ali ikwleyenyuk umu.” Ali Jisas naklipu anudak loguh aias chagakanali nakli, “Yek yaklipenyu, nyak kitak hul nyakis alas nyunahwas ali nyunamu wilpat!” ");
INSERT INTO apeB_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Ali ahudak atuh echudak chanatimaguk elpech douk chape lihilih uli chatulunamu naitak nanahul ananis alas nanahwos ali nanak. Ali echech chatulunu namudak ali chanatimaguk loguh hwanubu hwonechlukech ali chape chatuk God ananin yeul nyakih. Ali chakli, “Seiwak apak wata mutik enen enyudakmali nyutoglu e!” ");
INSERT INTO apeB_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Ali Jisas naitak natanamu nanalahe nanak buknapinyumu nebenyi raunwara Galili wakuli wolobaichi elpech chanaki chatoglomanu. Ali anan nape nenek skulumech naklipech yopinyi balan. ");
INSERT INTO apeB_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Anan naklipech balan julug ali anan nanaku wakuli natik Alfias ananinu nuganinu Livai douk isave nalau takis uli. Jisas natulunu nape wilpat douk anan nape nalau takis atali. Ali anan naklipanu nakli, “Nyak yowi nyugipech yek wunak.” Ali Livai nanubu naitak nanamanu hanak. ");
INSERT INTO apeB_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Ali kipaihi nyumnah Jisas nape nawak woligun Livai ananitu wilpat. Ali wolobaimi halau takis uli hanu wolobaimi kipaimi alagun henek enenyi enen yowenyi uli hanu Jisas nanu ananim disaipel hape hawak woligun. Umu moneken, wolobaimi amudakmali almam wihluwehlu isave hagipech Jisas. ");
INSERT INTO apeB_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Wakuli anam henek skulumech umu lo uli, amam douk Farisi omi. Amam hatik umu Jisas nanu chenek enenyi enen yowenyi uli chanu halau takis uli chape chawak kakwich atugun umu ali amam hasalik ananim disaipel hakli, “Anan nanech chachah umu kakwich echudak chenek enenyi enen yowenyi uli?” ");
INSERT INTO apeB_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Ali Jisas nemnekam namudak ali naklipam nakli, “Elpech douk agasudak wak anagas sunekech uli e eke kobi chunamu dokta umu nugabeyech, wak. Echebuk douk agasudak senekech uli atich eke chunak umu dokta nugabeyech. Ali yek chopuk douk namudak ati, kobi dokta umu. Yek douk wo inakumali ihwalu duldulichi elpech umu chutanamu chukanu apaluh God e, wak. Yek douk yanakumali ihwalu echebuk douk chenek yowenyi ulimu chukenyuk agabus yowenyi ali chutanamu chukanu apaluh God.” ");
INSERT INTO apeB_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Anah nyumnah Jon douk nenek baptaisumech uli ananim disaipel hanu amam Farisi amamim disaipel henek tambumu kakwich ali hape henek beten atin. Douk namudak ali enech elpech chanak gani Jisas napemu ali chasalikanu chakli, “Jon ananim disaipel hanu amam Farisi amamim henek tambumu kakwich ali hape henek beten atin. Wakuli nyakim wo hugimah namudak e umu moneken?” ");
INSERT INTO apeB_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Ali Jisas naklipech enen woblen balan nakli, “Ipak pakli ababuk nyultab anudak douk adakio nasuh okwok uli wata nunu ananichi nupemu, echech deke chunek tambumu kakwich ali chupe meyoh, waka? Aduligu atugu deke wak. Echech deke chuwok kakwich ali dakio chupe! ");
INSERT INTO apeB_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Wakuli nyultab eke bunakimu kipaichi chulawanu chunak kipaigunmomu. Ali ehebuk nyumneh, ananichi eke ulkwip pulomu anan ali eke chunek tambumu kakwich chupe meyoh.” ");
INSERT INTO apeB_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","22","“Ali deke kobi enen elpen nyukawech anap lupahip anah namuhi lupah ali nyuklopop anah alihi, wak. Enyen nyunek namudak ele, enyen deke nyunek anagun gnugol ahudak namuhi lupah. Ali chopuk deke nyuklopop ali deke kobi pupe kalbamu ahudak alihi lupah, wak. O deke kobi enen elpen nyinyukul anabal nupoleibal wainibal abal blugluk anap alipi memeip benyip douk chape cholu wainibal abal umu, wak. Enyen nyunek namudak ele, abaludak nupoleibal wainibal abal deke bluplukechop ali wain deke nutukwleik atap atugun. Ali apudak memeip benyip deke yowep. Ali namudak wak, echech eke chichalabal namusi atus. Ali osos eke kobi tutukalas ali wain eke nulu kalbu!” ");
INSERT INTO apeB_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Anah nyumnah Sabat, echech Juda moul wak chape meyoh ahi, Jisas nanu ananim disaipel haitak hawich hanak anagu nebegali nahabigu douk chau wit umu. Ali agnabuk, ananim disaipel hoblanuk anatu ulubitu wit ali hape howolechatu hatowah. ");
INSERT INTO apeB_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Wakuli amam Farisi hatulum namudak ali haklipu Jisas hakli, “Tik, nyakim disaipel heneken umu enyudak? Apakin lo douk nyakli apak kobi munek enen moul ahudak nyumnah Sabat!” ");
INSERT INTO apeB_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","26","Wakuli Jisas naklipam nakli, “Ipak patalihen balan seiwak Devit nenyemaguk ulimu ababuk nyultab anan nanu ananim nyulub blam umu waka wak? Amam nyulub blam ali Devit nawich God ananitu nebetali wilpat nohul bret douk chenek ofamatu choku God uli ali nanu ananim hatowah. Enyudak douk nyatoglu ababuk nyultab Abaiata nape nebenali pris abali. Abaiata nakli wosik ali Devit nanu ananim almam dakio hawich hohul bret hatowah. Ali chopuk, apakin lo douk nyakli kobi enech meyoluhich elpech chuwok atudak bret, wak. Amam pris atum wosik. Wakuli Devit nanu ananim hotohul hatowah.” ");
INSERT INTO apeB_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Ali Jisas wata chopuk naklipu amam Farisi nakli, “God douk wo nunek ahudak nyumnah Sabat umu nukli ipak apaluh yoweluh ali kobi punehilau e, wak. Anan nenekah umu nakli ipak apaluh imas yopuluh ali punehilau. ");
INSERT INTO apeB_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Ali yek Anudak Alman douk yatoglu aduligeinyi elpen uli douk yanubu Digiwelimu chanatimaguk enechi enech echudak, ali Digiwelimu iklipu elpech chunek moul ahudak nyumnah Sabat chopuk.” ");
INSERT INTO apeB_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Kipaihi nyumnah Sabat, Jisas nanak nawich echech Juda chape cheyagwleh balan atali wilpat. Ali ananu logul nyenekanali alman nanaki nawich nanech nape. ");
INSERT INTO apeB_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Ali elpech chape atabuk wilpat uli chakli chichopokanu enen balan Jisas chukli anan nablo enen lo. Douk namudak ali echech chape chatulunu duk umu chakli kadak anan nukli nugabe anudak logul nyenekanali ahudak nyumnah Sabat umu ali echech chunemanu balan. ");
INSERT INTO apeB_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Wakuli Jisas naklipu anudak logul nyenekanali nakli, “Kitaki nayotu agundak olokohun umu chunatimaguk chutulinyu.” ");
INSERT INTO apeB_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Ali anan naitak nanak neyotu ali Jisas nasalikech nakli, “Apakin lo douk God nokaguk Moses enyi nyakli munek moneken ahudak nyumnah Sabat? Mugakomu elpech mugabeyech waka mech? Mugakomech chupe kalbu waka mech chugak?” Wakuli echech wo chiyagwleh chuklipanu enen balan e. ");
INSERT INTO apeB_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Ali anan neyotu natulich ali nanubu nyihihichinu. Umu moneken, anan natulich umu echech chowechik echechiluh apaluh dadag ali chanubu chakli wak umu chumnek God ananin balan chugipechen umu. Ali anan naklipu anudak logul nyenekanali nakli, “Kwanu nyakin logul.” Ali anan nanubu nonu logul ali enyen nyanubu yopin. ");
INSERT INTO apeB_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Ali amam Farisi hanubu haitak hatoglu hanak hanu anam Herot ananim almam hape habo balan umu hakli hulimu anah yah umu hubo Jisas nugak umu. ");
INSERT INTO apeB_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Ali Jisas nanu ananim disaipel hatukemaguk ablabuk wabul haitak hanamu nebenyi raunwara Galili. Amam hanak wakuli wolobaichi elpech chagipechom chanak. ");
INSERT INTO apeB_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Echudak elpech enech chanaki provins Galili uli. Ali enech chanaki provins Judia uli. Ali enech chanaki kantri Idumia, ali enech chanaki Jerusalem uli. Ali enech chapeli gani woblahahibamu wolub Jodan uli chanaki, ali enech chapeli halakatimu albudak biolub walub Taia blanu Saidon uli chanaki. Echech chanatimaguk chemnek umu Jisas nape nagabe agasudak sachimu ali echech chanakimu nugabeyech. ");
INSERT INTO apeB_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Ali agnabuk wolobaichi elpech chanaki chape gnanubu chuknigun. Douk namudak ali Jisas naklipu ananim disaipel umu hulawali anatu bot tunaki tukusumonu halakatimu kadak wolobaichi elpech chukli chunaki halakatimu anan umu, anan nulto nutemoguk bot. Kedeke niyotu atap umu, echech eke chulikwechonu. ");
INSERT INTO apeB_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Umu moneken, nubuwakihibu nyultab anan nagabe wolobaichi agasudak sachi. Douk namudak ali echebuk agasudak sachi chape chenechas umu chanak umu chakli chunak chususuh Jisas meyoh ali echech wata yopich. ");
INSERT INTO apeB_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Ali ababuk nyultab, echebuk douk sagabehas chapenyich uli chanaki chatik Jisas ali chabih chagoul chakus halakatimu anan ali chohwalu nebegun chakli, “Nyak douk God ananinu Nuganinu.” ");
INSERT INTO apeB_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Wakuli Jisas naklipech dodogowinyi balan nakli echech kobi chuklipech umu anan douk God ananinu nuganinamu. ");
INSERT INTO apeB_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Ali Jisas nalto anatu nukut ali nahwalu wolobaimi almam douk anan nakliam uli hanak. ");
INSERT INTO apeB_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Ali anan natalih 12-poleim umu hunubu hunu anan hupe ali nukagam hunak huklipech ananin balan uli, ali nobukamam enyudak yeul aposel. Ali naklipam umu hunu anan hupe hulahe ali nunek salimumom umu hunak huklipech ananin balan wolobaichi elpech. ");
INSERT INTO apeB_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Ali chopuk umu nukom pawa umu huhiyahuk sagabehas chutoglu chulhwas.” ");
INSERT INTO apeB_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","17","Amudak 12-poleim aposel Jisas nanataliham uli douk amudak. Saimon, douk Jisas nobukumanu kipainyi yeul Pita uli, nanu Sebedi ananim nugamim, Jems nanu ananinu owaninu Jon, douk Jisas nobukumom kipainyi yeul Boanesis uli. Bawogen umu enyudak yeul douk chakli, “Utagu bagalogu.” ");
INSERT INTO apeB_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Amam hanu Andru, Filip, Batolomyu, Matyu uli Tomas. Hanu Alfias nuganinu Jems uli Tadias uli Saimon douk natanuh ananu lain chohwalech umu Selot uli. ");
INSERT INTO apeB_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Amam hanu Judas douk nanaki wabul Kariot uli. Anan douk nogilapu Jisas ananim birua umu Jisas uli. ");
INSERT INTO apeB_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Ali Jisas natanamu nanamu wilpat wakuli, wolobaichi elpech chanaki chape anan napemu. Ali Jisas nanu ananim disaipel hatulich namudak ali amam nyultab wak umu hupemu wikap ali hunenek enech kakwich hichah umu. ");
INSERT INTO apeB_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Ali ananichi, echech atugu nyulugamu chemnek umu agundak anan wo nupemu wikap ali nuwak kakwich atimu e, ali echech chanak umu chutukwlunu chulawanu chunak. Umu moneken, echech chemnek elpech chakli anan nogugaku. ");
INSERT INTO apeB_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Anam henek skulumech umu lo uli douk hapeli Jerusalem hanaki uli henek loh. Amam haklipech hakli Jisas douk enyudak Bielsebul douk nebenyumali chanatimaguk sagabehas uli nyenekanu dodogowinu ali anan dakio nohiyahuk echudak enech sagabehas chatoglu chalhwas. ");
INSERT INTO apeB_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Douk namudak ali Jisas nahwalu wolobaichi chanakimu anan ali naklipech enyudak woblen balan nakli, “Satan anan yet deke kobi nuhiyahuk ananichi sagabehas chutoglu chulhwas, wak. ");
INSERT INTO apeB_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Sapos elpech chape atin kantri uli chunadiyagulmu chunak chupe sulisuli, ali chunenemu birua chupe chulpak ele, echech deke kobi dodogowich. ");
INSERT INTO apeB_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Ali chopuk sapos anagu nyulgu chunadiyagulmu, ali echech yet chunenemu birua chupe chulpak ele, echech chopuk deke kobi dodogowich. ");
INSERT INTO apeB_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Ali sapos Satan nunu ananich chunadiyagulmu chunak chupe sulisuli, ali echech yet chunenemu birua chupe chulpak ele, echech chopuk deke kobi dodogowich. ");
INSERT INTO apeB_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Ali deke kobi ananu alman nunak nuwich ananu dodogowinali alman ananitu wilpat ali nutulunu nukumechi aluh ananich echudak, wak. Susubuati anan imas nuwechikuk anudak alman nupeik iyuh, ali anan deke adakio nunak nutulunu nunohul chunatimaguk echudak.” ");
INSERT INTO apeB_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","30","Ali douk amam henek skulumech umu lo uli hakli enen sagabu nyagakamu Jisas umu nenek moul umu. Douk namudak ali Jisas naklipam nakli, “Aduligu atugu yek yaklipepu, God eke kobi nunohwen umu enenyi enen yowenyi elpech cheneken uli nyunu enyebuk yowenyi balan douk echech chaklien umu anan uli, ali nukwleyenyuk. Wakuli echebuk douk chiyagwlehumen enen enen God ananin Michin uli, God eke nusuh enyebuk echechin yowenyi douk echech chaklien uli ali kobi nukwleyenyuk, wak. Echechin yowenyi eke nyupemu nameitu aliga kwali eheh nyumneh.” ");
INSERT INTO apeB_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Ali ababuk nyultab Jisas ananik mamakik kwanu ananim owahlim chanak chatoglu. Ali chanak cheyotu aduk wilpat ali chenek balan nyanamanamu nutoglali aduk. ");
INSERT INTO apeB_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Ali agnabuk wolobaichi elpech chape lihilih umu anan ali echech chaklipanu chakli, “Nya, nyakik mamakik kwanu nyakim owahlim chanaki cheyotu aduk ali chakli nyunak nyutulich.” ");
INSERT INTO apeB_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Wakuli Jisas nasalikech nakli, “Yekik mamakik uli owahlim douk meichi?” ");
INSERT INTO apeB_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Ali anan natulich nalihi nalih echudak douk chape lihilih umu anan uli ali naklipech nakli, “Yekik mamakik uli owahlim douk echudak! ");
INSERT INTO apeB_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Echebuk douk isave chagipech God ananin balan uli douk chanubu yekich owahlim uli mehwoliyu uli mamaliyu.” ");
INSERT INTO apeB_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","2","Ali Jisas wata chopuk nanak nape nenek skulumech naklipech yopinyi balan gani buknapin umu nebenyi raunwara Galili. Ali chanubu wolobaichi elpech chanaki chape Jisas napemu. Douk namudak ali anan naitak nalto netemu anatu bot douk tolu raunwara uli. Ali echech cheyotu buknap ali anan netemali bot nape nenek skulumech naklipech wolobainyi yopinyi balan naklipech woblen atin. ");
INSERT INTO apeB_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","Nakli, “Ipak pumnek! Ananu alman nowachak wit ananumu yawihas. ");
INSERT INTO apeB_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Anan nowachatu ali anatu tabih takus yah, ali almiguh hwanbih hwotohul hwatowoh. ");
INSERT INTO apeB_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Ali anatu tabih takus utabal umu. Ali douk amnab wo wolobaibi e ali atat pupuwolotu takih wisnabul. ");
INSERT INTO apeB_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Wakuli nubaluh wo hlugluk atap e. Ahlaluh hlabih hletemaguk utabal ali wah hatau hatu ali alitu. ");
INSERT INTO apeB_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Ali anatu taglukuk naluh hlatoglop uli wichap ali pupuwolotu takih. Douk takih, wakuli apudak wichap popakwilatu ali atat wo tukih nebetalimu chulkwip pil e. ");
INSERT INTO apeB_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Wakuli anatu taglukuk yopubi amnab ali pupuwolatu takih nebetali ali wolobaitali teil. Anatu, 30-poleitu teil atutu ati biguhitu wit. Ali anatu 60-poleitu, ali anatu 100-poleitu.” ");
INSERT INTO apeB_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Douk Jisas nakliyuk namudak ali anan naklipech nakli, “Ali nameitu ipak aligas sapenyipali imas pugamu pumnek yekin balan ali pugipechen.” ");
INSERT INTO apeB_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Douk wolobaichi elpech chatukemanaguk chanak, ali Jisas atunu nanu ananim 12-poleim disaipel hanu echudak enech chagipech Jisas uli atich chape. Ali echech chasalikanamu nuklipech umu bawogen umu enyudak woblen balan anan nape naklipech enyi. ");
INSERT INTO apeB_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Ali anan naklipech nakli, “God douk anaklipepu bawogen umu balan umu enyudak woblen balan ipak atipamu eke chuwich agundak God nape nebenalimu ananich elpech umu. Wakuli chanatimaguk adukichi eke wak. Echech eke chumnek woblen atin. ");
INSERT INTO apeB_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Douk namudak ali, ‘Echech eke chutulugun wakuli eke kobi chutik enech echudak. Ali chopuk eke chumnek balan, wakuli eke kobi chudukemu bawogen umu, wak. Umu moneken, kedeke chudukemu bawogen umu ali wata chutanamu chukanu apaluh God ali anan kobi nunohwen umu echechin yowenyi ali nukwleyenyuk.’” ");
INSERT INTO apeB_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Ali Jisas nasalikech nakli, “Ipak wo pudukemu bawogen umu enyudak woblen balan dukwechuk yaklipepeyen uli e? Douk namudak ali ipak eke pudukemu nyunatimaguk woblen balan douk eke yek iklipepeyen uli malmu? ");
INSERT INTO apeB_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Anudak alman nowachak wit uli douk kobi ananu naklipech God ananin yopinyi balan uli. ");
INSERT INTO apeB_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Ali atabuk douk tabih takus yah uli douk kobi echebuk elpech douk chemnek God ananin balan wakuli Satan nanaki natulich nalawaguk enyudak yopinyi balan douk nyape echechiluh apaluh uli. ");
INSERT INTO apeB_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Ali atabuk douk tabih takus utabal umaluli douk kobi echebuk elpech douk chemnek God ananin balan ati wakuli chanubu chenehilaumen chahwen chakli wosik uli. ");
INSERT INTO apeB_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Ali echech chalawen wakuli echech wo chuhwen dadag e. Echech chahwen chagipechen banabu nyultab meyoh. Ali douk aligasumu enen hevi nyatoglomech o chenekech anagu anagamu agundak chasuh enyudak God ananin balan umu, ali wisnabul chatukemaguk echechin bilip. ");
INSERT INTO apeB_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","19","Ali atabuk douk tabih taglukuk naluh hlataglapi wichap uli, douk kobi echebuk elpech douk chemnek God ananin balan, wakuli echech chenek warimu chakli chupe kalbu apudak atap uli. Echech oub baitak umu chunokwalmu wolobaichi enechi enech echudak ali chenehilaumu apudak atapichi atich. Douk namudak ali echudak enechi enech chowechik echechip ulkwip ali echech wo chusuh God ananin balan dadag e. Echech chanubu ulkwip pekechuk umu enyudak God ananin yopinyi balan echech chemneken uli. Ali echech chatukemenyuk ali wo chunek enyudak yopinyi pasin douk God nakli echech chuneken uli e. ");
INSERT INTO apeB_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Ali atabuk douk tabih takusuk yopubi amnab uli douk kobi echebuk elpech douk chemnek God ananin balan ali chahwen dadag chagipechen uli. Ali echech chenek wolobainyi yopinyi pasin. Ali echech chape kobi douk biguhitu wit umu. Anatu, 30-poleitu teil atutu ati, anatu 60-poleitu, ali anatu 100-poleitu.” ");
INSERT INTO apeB_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Ali Jisas wata chopuk naklipech nakli, “Deke kobi enen elpen nyuhemu enen lam ali nyitak nyupakwilen anatu baket o nyinyiglen chakamu anatu bet, wak. Enyen deke nyuhemen ali nyinyemu chihah-inyumu tebol umu enyen nyuglakumech. ");
INSERT INTO apeB_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Ali enechi enech douk chonobechuk chakus uli eke wata chutoglu yopugunmu. Ali enechi enech douk elpech chechukalich chakus uli eke wata chichlekech chukus yopugunmu. ");
INSERT INTO apeB_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Ali nameitu ipak aligas sapenyipali imas pumnek yekin balan ali puhwen dadag pugipechen.” ");
INSERT INTO apeB_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Ali anan naklipech enen balan alagun nakli, “Ipak ulkwip pugabe pulomu enyudak balan douk ipak pemneken uli ali pugipechen! Umu moneken, sapos ipak pugabe pumneken pugipechen umu, God eke nugakamepu pudukemu enen yopinyi balan alagun. ");
INSERT INTO apeB_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Ali echebuk douk chulau God ananin balan chudukemen kalbaluli, God eke wata nugamu nuklipech enen alagun. Wakuli echebuk douk wo chudukemu ananin balan uli e, enyebuk gwodin echech chahwen uli eke wata nutulichenyuk.” ");
INSERT INTO apeB_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Ali Jisas naklipech enyudak balan alagun nakli, “Elpech chawich umu agundak God nape nebenalimu ananich elpech umu eke kobi enyudak woblen balan umu. Balan enyudak. Ananu alman nanak nowachak chulkwipech kakwich ananigu nahabigu. ");
INSERT INTO apeB_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Anan nowachepuk julug ali nanak. Ali ihabus webus anan nechuh, ali nyumnegwih naitak nalahe. Ali ababuk nyultab epudak chulkwip pape pupuwolep pakih. Wakuli anan douk wo nudukemech umu agundak epep pupuwolep pakih umu e. ");
INSERT INTO apeB_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Abab amnab yet benekep pupuwolep pakih nebepi ali chulkwip peil. Ali susubuati pupuwolep pakih ali palik penek chus, wakuli pakih lowipi penek ulub ali wolobaipi chulkwip peil. ");
INSERT INTO apeB_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Douk peil aliga pauh, ali anudak alman nasuh ananip ponodalech uli nogwotep nanak noble epudak chulkwip. Umu moneken, epep douk apauh ali ababuk nyultab umu chusagunmu kakwich abali douk abatoglu.” ");
INSERT INTO apeB_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Ali Jisas naklipech nakli, “Elpech chawich umu agundak God nape nebenalimu ananich elpech umu eke kobi moneken umu? Yek eke iklipepu moneken woblen balan umu pudukemech? ");
INSERT INTO apeB_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Agundak God nape nebenalimu ananich elpech umu eke kobi onoh chokuhwi mastetih nahw umu. Ohwoh douk hwanubu chokuhwi hwechalakuk hlanatimaguk naluh elpech isave chawoluh yawihas uli. ");
INSERT INTO apeB_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Ananu alman nau onohw mastetih nahw ananumu yawihas. Ali ohwohw puwoloh hwakih hwonek nebenyi lowag nyechalakuk kipaigosi chokugosi lowas satau yawihas uli ali nyenek nebewali yeguhwiyu. Ali almiguh hwanak hwowemu logos ali hwotemu hwonobechuk umu wah.” ");
INSERT INTO apeB_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Ali Jisas nape naklipech ananin yopinyi balan, ali naklipech wolobainyi woblen balan kobi douk dukwechuk naklipechen uli. Anan naklipech wolobainyi woblen balan douk nyanokwnumu echechin save uli. ");
INSERT INTO apeB_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Ali nyanatimaguk balan anan naklipechen uli, anan naklipech woblen atin. Wakuli ababuk nyultab anan atunu nanu ananim disaipel atum hapemu, anan nape naklipam bawogen umu nyanatimaguk balan. ");
INSERT INTO apeB_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Douk wabigun ahabuk atuh nyumnah, Jisas naklipu ananim disaipel nakli, “Aipo, apak munak gani woblahahin umu raunwara.” ");
INSERT INTO apeB_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Ali amam hatukemaguk echudak wolobaichi almam almagou chapeik, ali amam halto atudak bot douk Jisas adukwechukuk nalik nakih netemomu ali halawanu nanamom hanak. Ali onog botog chopuk gwagipech amamitu bot gwanak. ");
INSERT INTO apeB_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Ali douk amam hanak wakuli nanubu nebenali wihun nalu ali nenek nebebi molub batuk. Ali abal blakih blagluk bot ali atat halakatimu chuknitomu abal. ");
INSERT INTO apeB_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Ali ababuk nyultab Jisas nanak nananibamu pilo ali nechuh gani tagikumoguk bot. Ali douk ananim disaipel hatik namudak ali hanak habalunu hakli, “Nebenyali Tisa, apak ahalakatimu mugak wo. Nyak wo ulkum mulomu agundak douk eke apak mugak umu e?” ");
INSERT INTO apeB_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Douk amam haklipanu namudak ali naitak nahu anudak wihun uli molub nakli, “Ipak punubu punak piluk!” Ali echech chanubu chanak cheiluk. Wihun wak nulu e ali molub chopuk wo butuk e. ");
INSERT INTO apeB_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Ali Jisas natanamu naklipam nakli, “Ipak elgeipamu moneken? Ipak wo punek bilip e umu moneken?” ");
INSERT INTO apeB_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Wakuli amam hanubu elgeim ali amam yet hanaklipamu hakli, “Anudak monokanu alman? Wihun uli yous chopuk douk chemnekanu.” ");
INSERT INTO apeB_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Douk wihun uli abal chanak cheiluk, ali Jisas nanu ananim disaipel hanak. Amam hanak aliga hatoglu echech Gerasa echech umu, gani woblahahin umu nebenyi raunwara Galili. ");
INSERT INTO apeB_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Ali douk Jisas nanatu nabihi bot ati, wakuli ananu alman wilpat wak anali nanaki natoglomonu. Anan douk nape nechuh hulusigwiluh gani matmat nanaki. ");
INSERT INTO apeB_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Anan douk enen sagabu nyapenyunu ali nanak nape nechuh hulusigwiluh gani matmatog. Ali anan douk wak ananu alman dodogowinamu nuhwanu nuwechikanu e, wak. Senab chopuk douk wo dodogowib e. Anudak nagakali douk nanubu dodogowinu atunu naplukechab. ");
INSERT INTO apeB_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Ali wolobaihi nyumneh echech chahwanu chakwu senab chowechik ananich loguh aias wakuli anan naplukechab. Anan douk nanubu dodogowinu atunu ali alman wak ananu dodogowinamu nuhwanuu nuwechikanamu umu nupe kalbu e. ");
INSERT INTO apeB_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Ali wihluwehlu, nyumnegwih webus, anan napemu nalahe ati. Anan nanak nape matmatog umu, ali nawich nanak mauntenab. Ali agnabuk anan napemu nohwalu ati nape. Ali chopuk, anan nasuh wanohibali utabal kobi douk nugogwes umu ali nape natah ananih yegenyihw. ");
INSERT INTO apeB_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Ali anan douk natukemaguk matmatog gwapemu ali wata nape nanaki lougun, wakuli anan natiki Jisas. Ali anan elgeinu ali nasahul nanaki nabih noduk ohlubus halakatimu Jisas. ");
INSERT INTO apeB_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Ali nohwalu nebegun nakli, “Jisas, Nanubu Nebenali God ananinyu Nuganinu! Nyak nyakli nyuneke malmu yek? Nyak nyusalimu iluh umu nyak kobi nye nyuneke imnek nebehi nyih.” ");
INSERT INTO apeB_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Anan nakli namudak umu moneken, Jisas anaklipu enyudak sagabu douk nyapenyunaluli nakli, “Sagabu, nyak nyutukemaguk anabuk alman nyutoglu nyunak!” ");
INSERT INTO apeB_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Ali Jisas nasalik anudak nagakali nakli, “Nyak nyonahwalu malmu?” Ali anan nakli, “Apak wolobaipali sagabehas mawich mapenyunu. Douk namudak ali apak monahwalu sagabehas!” ");
INSERT INTO apeB_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ali anan nape nahwalanu nebegun Jisas umu nakli Jisas kobi nukagas echudak sagabehas chunak lougun. ");
INSERT INTO apeB_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Ali agnabuk halakati, wolobaiguhwi bulguh hweyatu hwape hwawak kakwich gani woblahahitamu anatu chokutali nukut. ");
INSERT INTO apeB_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Douk namudak ali echudak sagabehas chaklipu Jisas chakli, “Nyak nyukagapu munak muwich gwaguhwi bulguh.” ");
INSERT INTO apeB_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Ali Jisas nakli wosik ali echech chatukemaguk anudak alman chataglali chanak chawich oguhudak bulguh. Ali oguhudak wolobaiguhwi bulguh douk chadalehoguh hwataglu 2,000-poleiguh uli hwasahul hwanak hwagluk enen natagul. Ali ogwoguh hwabih hwagluk anagu wayag ali hwanatimaguk hwabalah ali hwagak hwatuh. ");
INSERT INTO apeB_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Ali amubuk almam douk hape hoku oguhudak bulguh uli hatik namudak ali haitak halhwas. Amam hanak ali haklipu echebuk elpech douk chape walub uli chanu echebuk douk chape halakatimu nahabigas ulimu enyudak douk nyatoglaluli. Ali echech chaitak chanak umu chakli chutulin. ");
INSERT INTO apeB_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Ali echech chanak agundak Jisas napemu ali chatik anudak alman likuk sagabehas chapenyunali. Nameitu anan wata nugugaku e. Anan wata nalau yopinyi tinytin ali naitak nenenek luseh ali nape. Ali douk echech chatulunu namudak ali echech chanubu elgeich. ");
INSERT INTO apeB_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Ali chopuk, echech chanak chatoglamu echebuk elpech douk chape chatik enyudak Jisas neneken uli ali chaklipech umu agundak sagabehas chatukemaguk anudak alman chataglali chanak chawich bulguh ali chaguh hwagak umu. ");
INSERT INTO apeB_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Douk namudak ali echech chape chokogos Jisas umu nutukemaguk echech umu nunamu kipaigunmu. ");
INSERT INTO apeB_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Ali douk echech chaklipanu namudak ali Jisas nalto bot umu nakli nunak, wakuli anudak alman douk likuk sagabehas chapenyunali nasalikanu nakli, “Jisas, yek yakli inamenyu wunak!” ");
INSERT INTO apeB_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Wakuli Jisas naklipanu nakli, “Wak, nyak wata nyutanamu nyunamu nyakibul wabul ali nyuklipu nyakich, ipak atugu nyulgomu agundak Diginali nakli mapilinyomu. Ali chopuk, nyuklipech umu enenyi enen anan neneken umu nyak uli.” ");
INSERT INTO apeB_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Ali douk Jisas naklipanu namudak ali anan nanak nawich enyudak distrik douk 10-poleilub walub blapemu ali naklipech umu agundak Jisas nagabeyanamu. Ali echech chanubu loguh hwonechlukech. ");
INSERT INTO apeB_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Douk Jisas nanu ananim halau bot hatanamu hanak hatoglu gani woblahahin umu raunwara, ali habih heyotu buknap. Douk amam heyotu wakuli wolobaichi elpech chanaki chatulum. ");
INSERT INTO apeB_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Ali Jairas, douk nebenalimu echech Juda chape cheyagwleh balan atali wilpat uli chopuk nanaki. Anan nanaki natik Jisas ali nanak nabih nakus atap halakatimu Jisas ananiluh yaliluh. ");
INSERT INTO apeB_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Ali nanalak neilmonu nakli, “Nya, yekik chokukwi nugawik agudak gak ali okwok ahalakatimu kugak. Douk namudak ali yakli nyak nyunaku nyuwemeyok wis meyoh umu okwok wata yopuk ali kwitak kupe.” ");
INSERT INTO apeB_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Douk Jairas naklipanu namudak ali Jisas nanamanu hanak. Douk amam hanak wakuli wolobaichi elpech chopuk chanamam chanak. Echech chanak lihilih ali Jisas nalaguk olokohun. Ali chopuk, agnabuk yah echech chanak umu, echech chanubu chenek pas pas. ");
INSERT INTO apeB_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Ali onok almatok douk butog gwanakok kwape 12-poleich yohwleguh uli chopuk kwanamech chanak. ");
INSERT INTO apeB_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Okwok wolobaimi dokta habilak umu hakli hugabeyok wakuli habilak wak. Ali chopuk, okwokibal utabal douk akwowachabal blatuhumaguk kwatal dokta omimu hugabeyok umu. Wakuli okwok wo yopuk e. Butog gwanak gwape namudak ali gwechalakuk likuk gwalik gwanakok umu. ");
INSERT INTO apeB_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Ali douk okwok kwomnek umu agundak Jisas nagabe wolobaichi agasudak senekechimu, ali okwok kwanali echudak wolobaichi elpech chanaki. Ali okwok kwanaki agabahinomu Jisas. ");
INSERT INTO apeB_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Ali kwoneyagwleh kwakli, “Douk yek isusuh ananih luseh meyoh umu, anan eke wata nugabeye.” ");
INSERT INTO apeB_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Douk namudak ali okwok kwanak kwasuh ananih lupah ali ahudak atuh butog gwanubu tupokologuk. Ali chopuk, okwok kwomnek umu numun okwakihw yegenyihw butog wak onog gwunaki e. Ali okwok kwadukemech umu okwok douk ayopuk. ");
INSERT INTO apeB_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Wakuli ahudak atuh Jisas anadukemech umu enen ananin strong nyatukemanaguk nyatoglu nyanak. Ali anan nasalikech nakli, “Dakio omuni nyanaki nyasusuhehuk yekikh luseh?” ");
INSERT INTO apeB_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Ali ananim disaipel haklipanu hakli, “Nyak nyatulich, wolobaichi cheyotu lihilih umu nyak ali nyak wata nyasalikech umu?” ");
INSERT INTO apeB_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Wakuli Jisas neyotu natulich umu nakli nutik enyebuk elpen douk nyasusuh ananih luseh uli. ");
INSERT INTO apeB_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Ali okudak almatok akwadukemech umu agundak Jisas nagabeyok umu. Ali okwok kwanubu elgeik, ali kluk kluk kwanak kwabih kwakus halakatimu Jisas ananiluh yaliluh, ali kwape kwaklipanamu agundak anan nagabeyok umu. ");
INSERT INTO apeB_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Ali anan naklipok nakli, “Nugawik, nyak nyenek bilip nyakli yek dodogowiweli ali nyak dakio yopinyu. Ali nameitu nyakigu sig douk ganubu gatuh. Ali nyak nyunak ali nyakihw apahw hwulomenyu kalbu.” ");
INSERT INTO apeB_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Ali douk Jisas wata nape neyagwleh ati, wakuli anam hapeli Jairas ananitu wilpat uli halawali balan hanaki haklipu Jairas hakli, “Nyakik nugawik akwanubu kwagak. Namudak ali nyak kobi nyukanu hevi apakinu nebenali tisa umu nunaku nyakitu wilpat umu.” ");
INSERT INTO apeB_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Wakuli Jisas wo numnek amamin balan e, wak. Ali anan naklipu Jairas nakli, “Nyak kobi elgeinyu. Nyak nyunek bilip atin.” ");
INSERT INTO apeB_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Ali anan nahoguk chanatimaguk elpech chapeik ali Jems nanu ananinu owaninu Jon uli Pita atum hanamanu hanak. ");
INSERT INTO apeB_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Amam hanak hatoglu Jairas ananitu wilpat ali Jisas nemnek umu echech chape cheleh dildil. ");
INSERT INTO apeB_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Ali anan nanak nawich ali nasalikech nakli, “Ipak pape peyagwleh palikuk umu moneken? Okwobuk wo kwugak e. Okwok douk kwechuh meyoh!” ");
INSERT INTO apeB_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Douk anan naklipech namudak ali echech chape chenekanu enenyi enen ali chape cheyakasunu. Ali anan nakagas chanatimaguk chaitak chataglaguk ali anan nanu ananim biom atunu disaipel hanu okwokwinu aninaluli mamakik atich chawich numun wilpat okwok kwakus umu. ");
INSERT INTO apeB_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Echech chawich ali Jisas nasuh okwokwin logul ali naklipok echechin tokples nakli, “Talita kum.” Talita kum douk chakli, “Chokukwi almatok, kitak!” ");
INSERT INTO apeB_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Ali ahudak atuh okwok kwanubu kwaitak kwape kwalahe. Okudak nugawik okwakich yohwleguh douk 12-poleich. Ali douk echech chatuluk namudak ali chanubu loguh hwonechlukech! ");
INSERT INTO apeB_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Wakuli Jisas naklipech dodogowinyi balan umu echech kobi chunak chuklipu enech elpech umu agundak anan nokuhul kwaitak kwapemu. Ali anan naklipech chokok enech kakwich umu kwichah uli. ");
INSERT INTO apeB_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Ali Jisas wata natukemaguk abuldak wabul naitak natanamu nanamu ananibul wabul. Ali ananim disaipel alagun hanamanu hanak. ");
INSERT INTO apeB_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Ali ahudak nyumnah Sabat echech Juda moul wak chape meyoh ahi, Jisas nanak nawich echech Juda chape cheyagwleh balan atali wilpat ali nape nenek skulumech naklipech yopinyi balan. Ali wolobaichi elpech chape chemnek ananin balan uli chemnekanu ali chanubu loguh hwonechlukech chakli, “Enyudak balan nanak nalawenyi meiguni? Omuni nyagakamanu ali anan dakio nadukemu enyudakmali yopinyi balan? Ali chopuk, omuni nyagakamanu nyenekanu dodogowinu ali nape nenek enyudak God atunu neneken uli moul?” ");
INSERT INTO apeB_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Anan douk nenek moulamu nalak wilag uli. Ali anan douk Maria okwokwinu nuganinu. Ali ananiyu mehwaliyu wanu ananim owahlim Jems uli Josis, hanu Judas uli Saimon douk echudak chanu apak mape agundak.” Echech chakli namudak ali chokanaguk agabus. ");
INSERT INTO apeB_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Wakuli Jisas naklipech nakli, “Ananu profet eke nunak blunatimaguk walub ali eke chutuk ananin yeul nyukih. Wakuli chunatimaguk chape ananibul wabul uli, chunu ananichi echech atup awilop umu chunu echech anagu nyulgomu eke wak.” ");
INSERT INTO apeB_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Douk namudak ali Jisas wo nunek enen God atunu neneken uli e moul ananibul wabul, wak. Wakuli anan nowemeyech wis gwodich agasudak senekechi ali nagabeyech. ");
INSERT INTO apeB_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Ali chopuk, Jisas natik umu agundak echech wo chunek bilip umu e ali anan nanubu loguh hwonechlukanu. Ali Jisas nanak analub walub douk blape halakatimu ananibul wabul uli ali nape nenek skulumech naklipech yopinyi balan. ");
INSERT INTO apeB_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Ali anan nahwalu ananim 12-poleim disaipel hanaki heyotu atugun, ali nokom pawa umu huhiyahuk sagabehas. ");
INSERT INTO apeB_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Ali naklipam nakli, “Kadak punak ahudak yah umu, ipak kobi punosuh enech kakwich chunu woksagas. Ali kobi punoluk anabal utabal, wak. Ipak punak meyoh, punosuh butip atip umu punokusimomu. ");
INSERT INTO apeB_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Ali ipak punolu sandelahas, wakuli kobi punosuh eneh luseh, wak.” ");
INSERT INTO apeB_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Ali sapos punak putoglu anabul wabul ali ablabuk wabulich elpech chukli wosik umu chukepu anatu wilpat umu pichuh umu, ipak punak pupe atabuk atutu wilpat. Ipak pupe aliga meihi nyumnah pukli putukemaguk ablabuk wabul punak ahi, ali ipak adakio putukemataguk punak. ");
INSERT INTO apeB_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Wakuli sapos punak anabul wabul, ali elpech chape ablabuk wabul uli kobi chwunehilau-mepu, ali kobi chumnek ipakin balan umu, ipak putukemaguk ablabuk wabul ali pugudupechuk ipluk ipakiluh yaliluh kukusuk ali punak. Ipak punek namudak umu echech chutulipu ali eke chudukemech chukli echech douk achenek yowenyi. ");
INSERT INTO apeB_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Ali amam hanak biom biom hanak haklipech God ananin yopinyi balan hakli, “Ipak pukenyuk agabus yowenyi ali putanamu pukanu apaluh God.” ");
INSERT INTO apeB_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Amam haklipech God ananin balan ali hohiyahuk wolobaichi sagabehas chopuk douk chape elpech uli chatoglu chalhwas. Ali howayakumech yopuli wel wolobaichi agasudak sachi ali hagabeyech. ");
INSERT INTO apeB_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Ali ababuk nyultab, King Herot douk nape nebenalimu gavman uli nemnek balan umu enenyi enen douk nyape nyatoglaluli. Umu moneken, Jisas ananin yeul douk anyalahe wolobailubi walub. Ali enech chakli, “Jon douk nenek baptaisumech uli wata naitaki nape. Ali anan dakio dodogowinu ali nape nenek enyudakmali moul.” ");
INSERT INTO apeB_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Ali enech chakli, “Anan douk profet Ilaija.” Wakuli enech chakli, “Anan douk ananu profet kobi douk seiwakimi profet umu.” ");
INSERT INTO apeB_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Douk namudak ali anudak nebenalimu gavman uli Herot nemnek balan umu enyudak moul Jisas ananim disaipel heneken uli ali nakli, “Jon douk nenek baptaisumech uli douk aseiwak yoble ananik lobik! Wakuli nameitu anan wata naitak nape ali nape nenek enyudak moul!” ");
INSERT INTO apeB_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Anan nakli namudak umu moneken, seiwak Herot nanatulunu almatok ananinu owaninu Filip ali Jon nape naklipu Herot wolobaihi atih nakli, “Nyak nyablo God ananin lo umu nyanatulunu almatok nyakinu owaninamu!” Jon nape naklipanu namudak ali Herot nakagas ananim soldia hahwanu halawanu hanak henek kalabusumonu. ");
INSERT INTO apeB_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Ali Herodias okwakih apahw hwanubu nyihihichihw umu kwakli kwubo Jon nugak wakuli okwok kwabilak wak. ");
INSERT INTO apeB_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Umu moneken, Herot elgeinamu Jon ali nape nagakomonu. Anan nadukemech umu Jon douk yopuyopunali ali ananih apahw douk yopuh ali hwanosuh God. Ali chopuk, Herot nakli wosik umu numnek Jon ananin balan ali anan ulkum molomu wolobaichi echudak ali anan nanubu nenek wari. ");
INSERT INTO apeB_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Douk aliga wakuli Herodias kwogwatu anah yah umu kwubo Jon nugak umu. Ali douk Jon wata nenek kalabubs nape, ali ahudak nyumnah douk mamakik kwolali Herot ahi hatoglu. Ali Herot nenek nebeguni woligun umu ulkum mulomu ahudak nyumnah mamakik kwonololimu. Anan nenek woligun ali nohwalu nebemi douk hagakamanu henek gavmanin moul uli, hanu amam nebemumali ami uli, hanu hanatimaguk nebemimu provins Galili ulimu hunak hunanu huwak woligun. ");
INSERT INTO apeB_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Douk amam hape hawak woligun ali Herodias nugawik kwanaki kwawich kwonek danis. Ali Herot nanu amudak douk nohwalom hanaki hananu hawak woligun uli hatuluk ali hanubu henehilaumok. Ali Herot nasalikok nakli, “Nyak nyakli yek ikenyu moneken? Echebuk nyak nyukliech uli, yek eke ikenyeyech.” ");
INSERT INTO apeB_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Ali Herot nalimu iluh naklipok nakli, “Yek yaklipenyu adulin atin balan umu yek eke ikenyu chunatimaguk echudak nyak nyusalikemech uli. Sapos nyukli iyaisumohu yekib amnab bunu hunatimaguk yekikh jah hunu utabal, ali ikenyu enech nyak, ali ohwak wunohwech alagun atimu, yek eke ikenyeyech!” ");
INSERT INTO apeB_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Douk anan naklipok namudak ali okwok kwanak kwasalik okwokwik mamakik kwakli, “Yek eke iklipanamu nuke moneken?” Ali mamakik kwaklipok kwakli, “Nyukliponu nukenyu Jon douk nenek baptaisumech uli ananim boglom.” ");
INSERT INTO apeB_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Ali okwok kwonek wisnabul kwasahul kwanak kwawich ali kwaklipu Herot kwakli, “Yek yakli nameitu ati, nyulome Jon douk nenek baptaisumech uli ananim boglom anatu plet ali nyukeyom!” ");
INSERT INTO apeB_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Douk okwok kwaklipanu namudak ali anan nanubu nenek warimu Jon. Wakuli anan eke kobi wata nukli wak. Umu monken, dukwechuk anan anaklipok umu anan eke nukok chunatimaguk echudak okwok kusalikanamech uli. Ali chopuk, amudak douk nohwalom hanaki hananu hawak woligun uli douk ahemnek. ");
INSERT INTO apeB_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Douk namudak ali wisnabul anan nakagas ananu soldia ali naklipanu nakli, “Nyak nyunak haus kalabus nyuble Jon ananik lobik ali nyulawali ananim boglom.” Ali anudak soldia nemnek namudak ali nanak noble Jon ananik lobik. ");
INSERT INTO apeB_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Anan nobleyok ali nololi boglom anatu plet ali nanaki noku Herodias okwokwik nugawik ali okwok wata kwanak kwoku mamakik. ");
INSERT INTO apeB_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Ali Jon ananim disaipel hemnek namudak ali hanaki hohul tukaninu atunu hanak hanugomonu. ");
INSERT INTO apeB_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Douk amam aposel wata hatanamali hanu Jisas hape ali haklipanamu enyudak moul amam heneken uli nyanu balan amam haklipech-enyi. ");
INSERT INTO apeB_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Ali agnabuk wolobaichi elpech chalahe chenek yowi kale ali Jisas nanu ananim wak anabu nyultab umu hupemu wikap ali huwak woligun umu e. Douk namudak ali Jisas naklipam nakli, “Aipo! Kitak apak atupu munak anagun wohigunmu elpech wak umu ali munak mupemu wikap.” ");
INSERT INTO apeB_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Ali amam haitak halto bot ali amam atum hanak anagun wohigunmu elpech wak umu. ");
INSERT INTO apeB_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Wakuli wolobaichi elpech chatulum hanak umu ali echech chadukemom. Douk namudak ali elpech chape blanatimaguk walub uli chaitak chatukemaguk echechilub walub ali chosahul chalik chanak chatoglu cheyotu agnabuk douk eke Jisas nunu ananim hunak hubih umu. Ali amam adakio hagikuk hanak hatoglu. ");
INSERT INTO apeB_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Douk hanak hatoglu algas ali amam hetemu bot umu hanatu habih atap, wakuli hatik echudak wolobaichi almam almagou ali Jisas nanubu nenelekech. Umu moneken, alman wak ananu e umu nugakomech nuklipech balan uli. Echech chape kobi douk sipsip alman wak ananamu nunek lukautimech uli e. Douk namudak ali anan nanubu nape nenek skulumech naklipech wolobainyi God ananin balan. ");
INSERT INTO apeB_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Douk nenek skulumech aliga wabigun aun nabih, ali ananim disaipel hanaki haklipanu hakli, “Nya, aun anabih ali chopuk, agundak apak douk mapeik wohigunmu elpech wakagunmu. ");
INSERT INTO apeB_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Douk namudak ali nyak nyukogech chunak analub walub blape halakati ulimu chunak chunotol enech kakwich.” ");
INSERT INTO apeB_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Wakuli Jisas naklipam nakli, “Ipak yet pukech enech kakwich.” Ali amam wata hasalikanu hakli, “Nyak nyakli apak munak mutol bret douk tanokwnumu mutolutu 200 kina uli ali munaki mubilomech waka?” ");
INSERT INTO apeB_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Ali anan nasalikam nakli, “Ipak pudaleh bret ipak pahwatali uli. Ipak pasuhwi makwnitu?” Ali amam hadalehatu julug ali hanaki haklipanu hakli, “Apak masuhwi 5-poleitu bret tanu bias yelbus meyoh.” ");
INSERT INTO apeB_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Ali Jisas naklipu ananim disaipel umu huklipu chunatimaguk almam almagou chuneyais umu gwodich atich ali chunak chupe yopupi wichap pataglomu. ");
INSERT INTO apeB_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Ali amam haklipech cheneyais umu. Ali 50-poleich chanak chape sik, ali 100-poleich chape sik, ali echech chape namobuk ati chanak. ");
INSERT INTO apeB_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Echech chape ali Jisas nohul atudak 5-poleitu bret tanu asudak bios yelbus nahwech nanigu natik iluh heven ali nenek beten nenek tenkyumu God. Anan nenek tenkyumonu julug, ali nagwuduk atudak bret tanu yelbus noku ananim disaipel ali hape halagech hanak. ");
INSERT INTO apeB_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Ali amam halagech ali chanatimaguk chachah ali dugolech. ");
INSERT INTO apeB_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Ali atudak bret uli yeguh douk chachah dugolech chakusuk uli, amam disaipel hatulichech hechluk 12-poleig basketog chichuknig ali hechebuk chakus. ");
INSERT INTO apeB_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Ali echudak elpech douk chawak echudak kakwich uli, almam atum douk hanubu wolobaimi 5,000-poleim. ");
INSERT INTO apeB_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Douk enyudak nyanakuk, ali Jisas nakagas ananim disaipel henek wisnabul halto bot ali halik hanamu wabul Betsaida douk blape gani woblahahin umu raunwara uli. Ali anan napeik umu aliga nakagasuk echudak almam almagou chanakuk ali anan adakio nagimom nanak. ");
INSERT INTO apeB_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Anan nokogech chanak chatuh, ali anan nalto ananu maunten umu nukih nunek beten. ");
INSERT INTO apeB_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Ali wabigun amam disaipel hetemu bot hanak hatoglu olokohunin umu raunwara. Wakuli ababuk nyultab Jisas atunu wata nape nenek beten ati gani iluh maunten. ");
INSERT INTO apeB_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","49","Anan nape nenek beten, wakuli natiku ananim disaipel hetemu bot. Ali nebenali wihun nalu nowanamu talik umu bot ali amam hape henek nebenyi moul, henek pul nebegun atugun. Ali douk natulumu ali halakatimu gugluk, anan naitak nagimom nape nanak. Anan nablo enyudak raunwara nalahe nanaki chihah abal. Anan nanak ali nakli nichalakom nunak, wakuli amam hatulunamu nalahe nanaki chihah abal. Ali amam hakli eke enen sagabu. Douk namudak ali amam hanubu elgeim ali hohwalu henyugwleh nebegun atugun. ");
INSERT INTO apeB_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Umu moneken, amam hatulunu ali hanubu elgeim. Wakuli Jisas wisnabul naklipam nakli, “Ipak kobi elgeipu, wak! Ipak imas dodogowipu. Enyudak douk yek wo.” ");
INSERT INTO apeB_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Ali nebenali wihun wata nalu ati. Wakuli anan nanak naltomom nakih nanam hape bot ali anudak wihun nanubu nanak neiluk. Ali ananim disaipel hanubu loguh hwonechlukam. ");
INSERT INTO apeB_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Umu moneken, wehluwih anan nagwuduk 5-poleitu bret tanu bios yelbus noku wolobaichi elpech wakuli amam wo kwalowomi hudukemech hukli anan douk dodogowinali e! Amam hanubu ulkwip pokomuk. ");
INSERT INTO apeB_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Ali hablo hanak aliga hanak hatoglu algas gani woblahahin umu raunwara, enyudak distrik Genesaret, ali amam habih hasonuk bot hanak howechikatu. ");
INSERT INTO apeB_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Douk amam howechikuk bot hanak wakuli elpech adukwechuk chatik Jisas chadukemanu. ");
INSERT INTO apeB_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Douk namudak ali echech chasahul chanak blanatimaguk walub blape distrik Genesaret uli. Echech chanak ali chaklipech chowemali agasudak sachi betog ali chalawech chanakimu Jisas umu agnabuk echech chemnek umu anan nanak napemu. ");
INSERT INTO apeB_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Ali blanatimaguk nebelubi blanu chokulubi walub douk Jisas nanak umu, elpech chalau echechich agasudak sachi chanak chechubuk agnabuk douk echech isave chowachabal chapemu. Ali echech chasalik Jisas dodogowich atich umu agasudak sachi chususuh algasih umu ananih lupah. Ali chanatimaguk douk chasuh algasih umu ananih lupah uli, wata yopich. ");
INSERT INTO apeB_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Anah nyumnah amam Farisi hanu anam henek skulumech umu lo uli, douk hapeli Jerusalem uli hanaki ali hanak hape agnabuk Jisas napemu. ");
INSERT INTO apeB_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Amam hape wakuli hatik umu Jisas ananim disaipel wo hukwlupoguk wis kobi douk amam Farisi haklimu iyuh, ali adakio hunosuh kakwich hichah e. Douk namudak ali amam Farisi dakio hakli Jisas ananim disaipel amamis wis sabosusih. ");
INSERT INTO apeB_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Amam Farisi hanu chanatimaguk Juda echechin lo douk chagipech seiwak echechim bahlohim henekenyuk uli. Ali enen echechin lo douk namudak. Echech kobi chukwlupoguk wis iyuh umu, echech eke kobi chuwok enech kakwich, wak. ");
INSERT INTO apeB_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Ali kakwich chatalich maket uli chopuk, douk chanaki chakwlupechuk iyuh ali adakio chachah. Echech kobi chukwlupech umu, echech eke kobi chichah. Ali echech chagipech wolobainyi lo chopuk douk seiwak echechim bahlohim heneken henyemaguk uli. Ali enen douk enyudak umu chukwlupu kas, sunu malus uli pletog gwunu betog umu. ");
INSERT INTO apeB_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Douk namudak ali amam Farisi hanu amam henek skulumech umu lo uli hasalik Jisas hakli, “Umu moneken, ali nyakim disaipel dakio wo hugipech enyudak apakim bahlohim amamin lo umu hukwlupoguk wis iyuh ali adakio huwak kakwich umu e?” ");
INSERT INTO apeB_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Ali Jisas naklipam nakli, “Ipak penek loh uli. Seiwak profet Aisaia douk neyagwleh God ananin balan ali nanubu nenyemaguk duldul balan nyetemaguk God ananik Buk naklimu ipak! Ipak douk penek loh kobi douk balan nyetemu God ananik buk uli nyaklimu ipak umu! God nakli, ‘Echudak elpech echechig yowatog otug chatuk yekin yeul nyakih. Wakuli echechip ulkwip douk wo punubu pulomu yek e. ");
INSERT INTO apeB_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Echech isave chaklipech kipaichi elpech meyoh cheneken uli lo, ali chenek lohumech chakli echech chaklipech yekin. Douk namudak ali echech chenek lotume meyoh.’” ");
INSERT INTO apeB_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Ali Jisas wata naklipam nakli, “Ipak douk patukemaguk God ananin yopinyi lo ali pasuh ipakich popech yamech cheneken uli lo pagipechen. ");
INSERT INTO apeB_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Ali ipak douk panubu penek yowenyi. Umu moneken, ipak panubu pekenyuk agabus God ananin yopinyi lo ali panubu pan nyabihuk. Ali ipak pahwen dadag ipakim bahlohim amamin lo pagipechen. ");
INSERT INTO apeB_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Umu moneken, seiwak Moses naklipepu enyudak God ananin balan lo umu ipak pumnek ipakich mamechich echechin balan ali pugakamech. Ali sapos enen elpen nyukli nyuhu enyenyich mamechich nyuklipech enen yowenyi balan umu, enyebuk elpen kipaichi elpech imas chuhwen chunak chen nyugak. ");
INSERT INTO apeB_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Wakuli ipak Farisi panu ipak penek skulumech umu lo uli paklipech enen sik balan. Ipak pakli, sapos enen elpen nyunobuk enech echudak, o anabal utabal douk deke nyuku enyenyinu aninu o mamakik umu nyugakomech umu, wakuli enyen nyuklipech nyukli, ‘Yekibal utabal uli echudak kobi douk iku ipak umu igakomepamu douk ayatalihech umu iku God. Yek yakli echudak ‘Koroban.’ Bawogen umu enyudak balan Koroban douk chakli, ‘Echudak douk achatalihech umu chuku God.’ ");
INSERT INTO apeB_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Douk namudak ali enyen wo nyugakomech nyukech echudak enyenyich mamechich e. Wakuli ipak pakli, enyudak elpen nyunek namudak umu, enyen wosik douk nyenek yopinyi. ");
INSERT INTO apeB_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Douk namudak ali ipak pasuh ipakim bahlohim amamin lo dadag pagipechen. Ali God ananin lo douk nyakli apak mumnek apakich mamechich echechin balan mugakomech umu, ipak panubu pan nyabihuk. Ali chopuk, ipak penek wolobainyi alagun kobi enyudak douk nameitu yek yaklipepeyen ulimu.” ");
INSERT INTO apeB_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Ali Jisas wata chopuk nahwalu echudak wolobaichi almam almagou alagun chanaki anan napemu ali naklipech nakli, “Ipak punatimaguk imas pumnek yekin balan ali punubu pudukemen kalbu. ");
INSERT INTO apeB_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Chape aduk uli echudak chunu kakwich douk elpen nyichah chugluh numun enyenyihw apahw uli eke kobi chuneken nyubosusih, wak. Echebuk douk chape numun enyebuk elpen enyenyihw apahw ali chutoglali aduk uli, douk eke echebuk chuneken nyubosusih. ");
INSERT INTO apeB_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Ali nameitu ipak douk aligas sapenyipali imas pumnek enyudak balan ali puhwen dadag pugipechen.” ");
INSERT INTO apeB_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Anan naklipechuk namudak ali natukemechuk nanak nawich nanu ananim disaipel hape wilpat. Ali amam hasalikanamu enyudak woblen balan dukwechuk anan naklipech enyi. ");
INSERT INTO apeB_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Ali anan naklipam nakli, “Ipak chopuk douk wo pudukemech e? Kakwich chanu chanatimaguk echudak chape aduk, ali elpech chachah chagluk echechiluh apaluh uli eke kobi chubih chunekech chubosusih, wak. ");
INSERT INTO apeB_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Umu moneken, kakwich echebuk douk chachah ali wo chunak chubih chulu echechip ulkwip e. Echech douk chabih cholu apaluh ali wata chanak chalkeyechuk.” Jisas douk nakli namudak umu nakli chanatimaguk mahich uli kakwich douk yopich uli atich. ");
INSERT INTO apeB_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Ali Jisas wata chopuk naklipam nakli, “Enenyi enen yowenyi echechip ulkwip polomen ali echech oub baitakumen cheneken uli atin eke nyunekech chubosusih. ");
INSERT INTO apeB_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","22","Umu moneken, agagun douk gani numun echechip ulkwip palik polomu enyudak enenyi enen yowenyi ali echech adakio cheneken. Echech chakwu aluh, ulkwip polomu yowenyi, chabo elpech chagak, chanosonukeh umu chanak hwaloh ali dadagichich wo chukech ati e elpech. Ali chenek loh umu kipaichi, ali chopuk wo chunek bosumu echech yet e. Ali echech chablo enyudak lo umu chanasupomu ali chenek hinyigimu kipaichi echechich echudak. Ali chahu kipaichi chakli echech atich nebechi, ali chenek loh umu kipaichi chakli echech chenek yowenyi. Ali echech chakli chutuk echechich atich yeguh chukih ali chenek enenyi enen yowenyi. ");
INSERT INTO apeB_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Nyanatimaguk enyudak enenyi enen yowenyi douk echechip ulkwip polomenyi ali cheneken uli douk nyenekech chabosusih.” ");
INSERT INTO apeB_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Ali Jisas natukemaguk ablabuk wabul naitak nanamu kipaigunmu, albudak bialub wabul Taia uli Saidon blapemu. Anan nanak natoglu ali nanak nawich nape anatu wilpat. Ali anan nakli wak umu enech elpech chudukemech umu anan nanak nape agnabuk umu. Wakuli anan nabilak umu nakli nunobechuk nupe agnabuk wakuli, wak. ");
INSERT INTO apeB_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Ali onok almatok douk okwokwik nugawik enen sagabu nyapenyuk uli kwomnek umu Jisas nanak napemu, ali okwok kwanak kwatulunu. Okwok kwanak ali kwabih kwoduk ohlubus kwakus halakatimu Jisas ananiluh yaliluh. ");
INSERT INTO apeB_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Okudak almatok okwok douk kipaibuli wabulik, okwok wo Juda e. Okwok kwanaki abuldak wabul Finisia, douk blape provins Siria uli. Ali okwok douk kweyagwleh tokples Grik. Douk okwok kwanak ali kwanubu kwaklipu Jisas umu nuhiyahuk enyudak sagabu douk nyape okwokwik nugawik uli nyutoglu nyulhwas. ");
INSERT INTO apeB_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Ali Jisas naklipok enyudak woblen balan nakli, “Yek ikech kakwich batowich iyuh. Umu moneken, enyen douk wo kalbamu apak muhul batowichich kakwich muwachech umu nubag gwichah e, wak.” ");
INSERT INTO apeB_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Ali okwok kwaklipanu kwakli, “Diginyali! Nyak nyaklien uli balan douk nyanubu adulin. Wakuli nubag douk agwawich gweyatu chakamehah-inyumu tebol ali gwape gwawak yalugwich kakwich douk batowich chachah chenekech chanakuk uli.” ");
INSERT INTO apeB_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Ali Jisas naklipok nakli, “Nyak nyanubu nyobeyenume duldul yekin balan. Douk namudak ali nyak wata nyutanamu nyunak. Sagabu douk adukwechuk nyatukemokuk nyakik nugawik nyatoglu nyalhwos.” ");
INSERT INTO apeB_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Ali okwok wata kwatanamu kwanamu wilpat ali kwatik umu sagabu nyatukemaguk okwokwik nugawik nyatoglu nyalhwasuk ali okwok kwech kalbu okwokwis alas. ");
INSERT INTO apeB_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Ali Jisas natukemaguk ablabuk wabul douk blape halakatimu Taia uli, ali nanak nechalakuk Saidon ali nawich nanak enyudak distrik 10-poleilub walub blapemu. Ali nanak nabihuk nebenyi raunwara Galili. ");
INSERT INTO apeB_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Douk anan nanak natoglu, wakuli enech elpech chalawali ananu aligas sogugakeyonu, ali chopuk wo niyagwleh ati uli e chanakimu Jisas. Ali echech chasalikanamu nuwemeyanu wis ali nugabeyanu. ");
INSERT INTO apeB_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Ali douk Jisas nemnekech namudak ali nalmonu hatukemaguk echudak wolobaichi almam almagou chapeik ali amam atum hanak heyotuk sik. Ali nenigul ananih heh hawich wiblagas woblagas aligas. Ali nokuseh alpigas sataku ananih hah ali nogosayok anudak alman ananim yaham. ");
INSERT INTO apeB_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Ali douk Jisas nenek namudak julug, ali anan nanigu natik iluh heven ali hwosalanagu. Ali naklipanu echech Juda echechin tokples nakli, “Efata.” Bawogen umu enyudak balan Efata douk chakli, “Nyak aligas tiagialagas nyumnek kalbu ali wata nyiyagwleh.” ");
INSERT INTO apeB_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Ali ahudak atuh ananigas aligas sanubu tag sanukuk ali anan nanubu nemnek balan kalbu. Ali ananim yaham manubu muk manakuk ali nape neyagwleh. ");
INSERT INTO apeB_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Ali Jisas naklipech nakli, “Ipak punak ali kobi puklipu enech elpech umu agundak yagabe anudak alman umu.” Ali douk anan naklipech namudak wakuli echech chanubu chanak chape chaklipech chanak umu agundak Jisas nagabe anudak aligas sogugakeya-nalulimu. ");
INSERT INTO apeB_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Echech chaklipech chanak, ali echebuk douk chemnek umu enyudak uli chanubu loguh hwonechlukech ali chakli, “Anan nanubu nenek nyanatimaguk moul nakukwihen kalbu. Anan nagabe aligas sogugakeyechi chemnek, ali chopuk nagabe wo chiyagwleh ati uli e ali echech wata cheyagwleh.” ");
INSERT INTO apeB_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","2","Anah nyumnah, kipaichi wolobaichi almam almagou chanaltomu chanak chape Jisas napemu. Echech chape aliga 3-poleih nyumneh ali kakwich chatuh. Ali Jisas nohwalu ananim disaipel hanaki ali naklipam nakli, “Yek yakli mapilich echudak elpech. Umu moneken, echech chanaki chane mape 3-poleih nyumneh agundak ali echech kakwich wakech ali nyulub blach. ");
INSERT INTO apeB_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Ali yek kobi ikech enech kakwich chichah iyuh, ali adakio chutanamu chunamu echechilub walub umu, echech eke chunak yah ali yomotog gwilech ali chubih chugoul. Umu moneken, enech douk chanaki lougun.” ");
INSERT INTO apeB_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Ali ananim disaipel hasalikanu hakli, “Agundak mapeik wohigunmu elpech wak umu. Douk namudak ali apak eke munak mugwatu enech kakwich agunmu ali dakio mubilomu echudak chunatimaguk wolobaichi elpech?” ");
INSERT INTO apeB_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Ali anan nasalikam nakli, “Ali ipak pasuhwi makwnitu bret?” Ali amam haklipanu hakli, “Apak masuhwi 7-poleitu ati.” ");
INSERT INTO apeB_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Ali Jisas naklipu echudak wolobaichi elpech chabih chape atap. Ali anan nohuli atudak 7-poleitu bret nahwotu ali nenek beten nenek tenkyumu God ali nagwudukatu noku ananim disaipel umu hiyaisatu hubilomech. Ali amam hatuluneyatu, ali hape habilomech hanak. ");
INSERT INTO apeB_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Ali amam hasuhwi anas gwodus chokusi yelbus chopuk. Ali Jisas nahwos nenek beten nenek tenkyumu God ali nakagas ananim umu hunak hiyaisosumech chopuk. ");
INSERT INTO apeB_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","9","Ali echech chachah dugolech ali chakusuk uli, ananim disaipel hatulichech ali hechluk 7-poleig basketog chichuknig. Ali almam almagou chawak echudak kakwich uli douk chanubu wolobaichi 4,000-poleich. Ali echech dugolech ali Jisas nokogech chanamu echechilub walub. ");
INSERT INTO apeB_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Ali douk anan nokogech chanakuk ati, ali ahudak atuh anan nanu ananim disaipel halto bot ali hanamu analub walub douk blape distrik Dalmanuta uli. ");
INSERT INTO apeB_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Ali douk anam Farisi hanak Jisas napemu ali hananu hape henechichilak. Amam hakli hichakamanu, douk namudak ali amam hasalikanamu nunek enen God atunu neneken uli moul umu hudukemech umu anan douk adul God nokoganu nanaki uli. ");
INSERT INTO apeB_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Ali Jisas hwosalanaguk ali nakli, “Ipak doumeipali pakli yek inek enen God atunu neneken uli moul ali ipak putulin umu moneken? Aduligu atugu yek yaklipepu, yek eke kobi inek enen enyudakmali moul ipak putulin, wak.” ");
INSERT INTO apeB_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Anan naklipam namudak ali wata natukemam hapeik ali nanu ananim disaipel haitak halto bot ali hanak gani woblahahin umu nebenyi raunwara Galili. ");
INSERT INTO apeB_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Amam hanak wakuli Jisas ananim disaipel ulkwip pokomumoguk husuh anatu bret alagun umu. Amam douk hasuh atutu meyoh bret tetemumom bot. ");
INSERT INTO apeB_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Ali Jisas naklipam nakli, “Ipak pugabe punenek yologimu amam Farisi hunu Herot amamis yis.” ");
INSERT INTO apeB_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Ali douk anan naklipam namudak ali amam yet hape heneyagwleh hakli, “Anan naklipapu enyudak balan umu yis umu moneken, apak douk wo musuhwi anatu bret e.” ");
INSERT INTO apeB_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Wakuli Jisas adukwechukuk nadukemech umu amam hape heneyagwleh namudak umu. Ali anan naklipam nakli, “Yek yakli wak umu ipak piyagwleh umu agundak ipak bret wakepamu. Ipak douk padukemu bawogenyumu yekin balan waka wak? ");
INSERT INTO apeB_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","19","Ipak douk nabes sapenyipu, wakuli ipak wo putik echudak e? Ali ipak douk aligas sapenyipu, wakuli ipak wo pugamu pumnek e? Ipak douk ulkwip apekepaguk umu agundak nubuwakih yagwuduk 5-poleitu bret yabilamu chanubu wolobaichi 5,000-poleich elpech umu? Yek yabilomech chachah dugolech ali chakusuk uli ipak patulichech pechluk makwnig basketog chichuknig ali pogubuk gwakus? Ali amam haklipanu hakli, “Apak mechluk 12-poleig basketog.” ");
INSERT INTO apeB_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Ali Jisas wata chopuk nasalikam nakli, “Ali ababuk nyultab yek yagwuduk 7-poleitu bret yabilamu chanubu wolobaichi 4,000-poleich almam almagowomu, echech chachah dugolech ali chakusuk uli ipak patulichech pechluk makwnig basketog chichuknig pogubuk gwakus?” Ali amam haklipanu hakli, “Apak mechluk 7-poleig.” ");
INSERT INTO apeB_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Ali anan nahom ali nasalikam nakli, “Ali ipak douk wo pudukemu enyudak balan e umu moneken? Yek douk wo iklipepamu asudak adulis yis douk senek bret taitak nebetali uli e, wak.” ");
INSERT INTO apeB_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Ali Jisas nanu ananim hanak aliga hanak hatoglu wabul Betsaida. Ali agnabuk enech elpech chalawali ananu nabes sechukanali chanakmali Jisas ali chasalikanamu nuwemeyanu wis ali nugabeyanu. ");
INSERT INTO apeB_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Ali douk echech chaklipanu namudak ali anan nalmu anudak nabes sechukanali hanakuk adikop ali Jisas nokuseh alpigas sataku anudak ananis nabes. Douk nokusehas julug ali nowemu wis nabes ali nasalikanu nakli, “Nyak nyatik enech echudak waka wak?” ");
INSERT INTO apeB_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Ali anudak nabes sechukanali natulugun ali nakli, “Yek yatik elpech chalahe wakuli yek wo igabe itulich kalbu e. Yek yatulich luhul luhul kobi douk yatik lowas umu.” ");
INSERT INTO apeB_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Ali Jisas wata chopuk nowemu wis ananis nabes ali nameitu anan nanubu natulugun duk. Ananis nabes sanubu yopus ali anan nanatulugun hwilhwaluk ali natik chanatimaguk echudak kalbu. ");
INSERT INTO apeB_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Ali Jisas nokoganu nanamu ananitu wilpat ali naklipanu nakli, “Nyak nubu kalemu nyakitu wilpat. Nyak kobi nyutanamu nyunak wabul wak.” ");
INSERT INTO apeB_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Ali Jisas nanu ananim disaipel hatukemaguk Galili ali haitak hanamu analub walub douk blape distrik Sisaria Filipai uli. Douk amam hanak yah ali Jisas nasalikam nakli, “Ipak pemnek elpech chakli yek meiweli?” ");
INSERT INTO apeB_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Ali amam haklipanu hakli, “Enech chakli nyak douk Jon douk nenek baptaisumech uli, ali enech chakli nyak Ilaija, ali enech chakli nyak ananu profet.” ");
INSERT INTO apeB_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Ali anan nasalikam nakli, “Douk echech chakli namudak ali ipak yet pakli yek meiweli?” Ali Pita naklipanu nakli, “Nyak Krais douk God natalihenyu nokogenyu nyanamali nyunalau elpech uli.” ");
INSERT INTO apeB_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Ali Jisas naklipam dodogowinyi balan nakli, “Douk ipak padukemech ali ipak kobi punak puklipu enech elpech umu yek douk Krais douk God natalihe ali nokoge yanaki ulimu.” ");
INSERT INTO apeB_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Ali Jisas nape naklipu ananim disaipel nakli, “Yek Anudak Alman douk yataglu aduligeinyi elpen uli eke imnek nebehi nyih. Ali echech Juda echechim nebemi hunu nebemi pris, hunu amam henek skulumech umu lo uli, eke huke agabus ali huneke anagu anagu. Ali eke che igak chunugome ilu iwagu bieh nyumneh, ali huklimu bieh atuh nyumneh umu, yek eke wata itak ipe.” ");
INSERT INTO apeB_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Enyudak balan anan douk wo nuklipam woblen e, wak. Anan nanubu nowolehen naklipam. Douk namudak ali Pita nalmonu hanak heyotuk algas ali nape nahanu nakli, “Nyak kobi nyukli enyudak balan.” ");
INSERT INTO apeB_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Wakuli Jisas natanamu natik ananim disaipel ali nahu Pita nakli, “Satan, nubu kaleik. Nyak douk wo nyugipech God ananin tinytin e. Nyak nyagipech elpechin tinytin meyoh!” ");
INSERT INTO apeB_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Ali Jisas nohwalu echudak wolobaichi elpech chanu ananim disaipel chanak agundak anan napemu ali naklipech nakli, “Elpen douk nyukli nyugipech yek uli, susubuati enyen imas nyunubu nyukli wak umu enyen kobi nyugipech enyenyin laik. Ali enyen kobi elgein umu chen nyugak umu ali nyusah enyenyin lowag krusemu, enyen wosik eke nyugipeche. ");
INSERT INTO apeB_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Ali sapos enen elpen enyenyim ulkum mulomu nyukli enyen kobi nyugak ali nyupe namudak ati uli, enyen eke nyugak. Wakuli enyebuk elpen douk nyunek yekin moul ali nyusuh God ananin yopinyi balan dadag uli kipaichi eke chen nyugak. Wakuli enyen eke wata nyupe kalbu eheh nyumneh. ");
INSERT INTO apeB_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Ali echebuk elpech douk chunokwalmu wolobaichi enechi enech echudak, ali echech chukli echech douk achape kalbu ali eke kobi chugak uli, echech eke chunubu chugak. ");
INSERT INTO apeB_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Eke kobi enen elpen nyukwu enyenyich echudak umu nyutal agundak umu nyupe kalbu eheh nyumneh umu, wak. ");
INSERT INTO apeB_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Ali chopuk nameitu, wolobaichi elpech chape apudak atap uli chape chenek enenyi enen yowenyi. Echech chekenyuk agabus God ananin balan chakli enyen wo adulin e. Ali ahabuk nyumnah yek Anudak Alman douk yataglu aduligeinyi elpen uli itanamali inali God ananich yopiyopichi enselahas inakumali, God eke nugakome itoglu dodogowiwe otuwe inubu ihiyatiki ali inaki. Ali ababuk nyultab yek inaki abali, echebuk elpech douk nameitu chenenek ablan umu yek, ali chekenyuk agabus yekin balan uli, yek chopuk eke inenemech ablan ali ikechuk agab namobuk ati.” ");
INSERT INTO apeB_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Ali anan wata chopuk naklipech nakli, “Aduligu atugu yek yaklipepu! Enepu nameitu peyotu agundak uli eke kobi kebes pugak, wak. Ipak eke wata pupe ali putik agundak God dodogowinu atunu nupe nebenalimu ananich elpech umu.” ");
INSERT INTO apeB_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Douk 6-poleih nyumneh hanak hadiyuk, ali Jisas nalmu Pita nanu Jems uli Jon atum hanamanu halto hakih hape ananu lounali maunten. Amam hakih hape wakuli amam hatik umu Jisas nanubu nenek senis nohiyatik nape anagun sik. ");
INSERT INTO apeB_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Ali ananih luseh chopuk hanubu hohiyatik hatoglu chogalihwih. Elpech chape apudak atap uli douk wak enech chukwlupu echechih luseh hunubu huhiyatik hutaglu chogalihwih namudak e. ");
INSERT INTO apeB_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Ali agnabuk Pita nanu Jems uli Jon hatik Ilaija uli Moses hatoglu hanu Jisas heyotu hape heyagwleh. ");
INSERT INTO apeB_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Ali Pita naklipu Jisas nakli, “Tisa, enyen douk kalbamu apak mape agundak umu. Ali apak muwemu 3-poleiyu chomeguhwiyu. Nyak onok ali biowomu Moses uli Ilaija.” ");
INSERT INTO apeB_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Pita douk naklipanu namudak Jisas umu moneken, amam hanubu elgeim ali Pita wo nudukemech umu moneken balan anan eke nuklien uli e. ");
INSERT INTO apeB_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Ali douk Pita nape naklipanu namudak wakuli onog olug gwanaki iluh ali abalil lechukolum ali amam hemnek anagu nigu ganaki ogudak olug. Ali enyudak elpen nyeyagwlehi uli nyakli, “Anabuk douk nanubu yekinu nuganinu douk yek ulkum manahwanaluli. Ipak pumnek ananin balan!” ");
INSERT INTO apeB_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Ali douk amam hemnek namudak ali ahudak atuh, amam hatanamu hatulugun wakuli wo hutik enech elpech alagun chunom chiyotuk e. Amam hatik Jisas atunu nanam neyotuk. ");
INSERT INTO apeB_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Ali douk amam wata hatukemaguk maunten hape hagluki ali Jisas naklipam nakli, “Ipak punak ali kobi puklipu enech elpech umu enyudak dukwechuk patulin uli, wak. Ipak pupe aliga chubo yek Anudak Alman douk yataglu aduligeinyi elpen uli igak ali wata itak ipe ali ipak adakio puklipech-umen.” ");
INSERT INTO apeB_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Ali douk anan naklipam namudak ali amam hemnek ananin balan hagipechen. Wakuli amam yet hape heneyagwleh hanaklipamu hakli, “Douk bawogen umu balan umu anan nakli, ‘Yek Anudak Alman douk yataglu aduligeinyi elpen uli wata itaki iwagamu’, anan douk naklimu moneken?” ");
INSERT INTO apeB_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Ali amam hasalikanu hakli, “Amudak douk henek skulumumech umu lo uli douk haklipech hakli eke Ilaija nulik nunaki ali Krais, douk God natalihanu nokoganu nanaki uli eke nugiki umu moneken?” ");
INSERT INTO apeB_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Ali Jisas naklipam nakli, “O enyen adul! Ilaija douk nalik nanakimu nugabe enechi enech echudak. Wakuli ipak ulkwip pulomu enyudak balan douk nyetemu God ananik buk uli. Balan douk nyakli, ‘Yek Anudak Alman douk yataglu aduligeinyi elpen uli eke imnek nebehi nyih ali elpech eke chukli wake ali chuke agabus.’ Ali enyen douk nyetemu namudak umu moneken? ");
INSERT INTO apeB_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Wakuli aduligu atugu yek yaklipepu! Kipainali Ilaija douk ananaki ali elpech chagipech echechin laik ali chenek enenyi enen yowenyimu anan. Echech chagimeh-umonu kobi douk balan nyetemu God ananik buk uli nyaklimu.” ");
INSERT INTO apeB_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Ali Jisas nanu ananim 3-poleim disaipel hatanamu hagluk hanak hogwatu amudak anam disaipel agnabuk douk amam hapemu. Wakuli amam hatik umu wolobaichi elpech chanak cheyotu chalihi chalih amudak anam disaipel. Ali agnabuk, anam henek skulumech umu lo uli hanu amam Jisas ananim disaipel hape henechichilak. ");
INSERT INTO apeB_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Wakuli douk chanatimaguk chatiku Jisas ali echech loguh hwanubu hwonechlukech. Ali echech chasahul chanak chatoglomanu anan napemu ali chenehilau-monu chakli, “O yopuhi nyumnah nyak!” ");
INSERT INTO apeB_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Ali Jisas nasalik ananim disaipel nakli, “Ipak panam penechichilak umu moneken?” ");
INSERT INTO apeB_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Ali ananu alman douk nanu echudak wolobaichi cheyotu uli naklipu Jisas nakli, “Nebenyali Tisa, yek yalawali yekinu nuganinamu nyak. Umu moneken, anan owotu tonoul ali wo niyagwleh ati e. ");
INSERT INTO apeB_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Ali wolobaihi nyumneh owotu tonoul tatukanu nabih nakus atap ali alpus sataglali ananitu yokwatu. Ali chopuk, anan nanalkech naluh nenek kulti kultek ali ananich loguh aias chanadalech ali chanubu dudugichich. Ali yek yasalik nyakim disaipel umu huhiyahuk atudak owotu tutoglu tulhwas wakuli amam habilak wak.” ");
INSERT INTO apeB_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Ali Jisas nemnek namudak ali naklipu echudak almam almagou nakli, “Ipak doumeipali, yek yanepu mape loubamu nyultab ipakibul wabul wakuli ipak wo punek bilipume e. Ali ipak pakli yek eke wata ipemu igakomepu namudak atimu isah ipakin enenyi enen hevimu waka? Lawoli anabuk chokunali!” ");
INSERT INTO apeB_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Ali echech chalawanu chanak umu Jisas. Douk anan nanak, wakuli atudak owotu tatiku Jisas ali tonoul tatukonu nabih nakus atap ali natihanu nanak. Ali wolobaisi ahawos satoglali ananitu yokwatu. ");
INSERT INTO apeB_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Ali Jisas nasalik anudak owotu tonoul uli ananinu ananu nakli, “Owotu tonoul nape makwnih nyumneh?” Ali anan naklipanu nakli, “Seiwak anan wata chokunomu, owotu tonoul tape namudak aliga nameitu. ");
INSERT INTO apeB_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Ali chopuk, wolobaihi nyumneh atudak owotu takli tanu nugak. Atat tonoul tatukonu nagluk algab umu nyih hununu nugak. Ali enebik umu, tonoul tatukanu nagluk wolub umu nubih bukihanu nulaguk wolub. Ali sapos nyak dodogowinyamu nyugabeyanamu, nyak nyukli mapilihu ali nyugakomohu!” ");
INSERT INTO apeB_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Ali Jisas naklipanu nakli, “Adul, sapos nyak nyuklimu! Umu moneken, echebuk elpech douk chunek bilip umu yek uli, echech eke dodogowich umu chunek nyunatimaguk enenyi enen moul.” ");
INSERT INTO apeB_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Ali ahudak atuh, anudak owotu tonoul uli ananinu aninu naklipu Jisas nakli, “Yek yenek bilip umu nyak wakuli yekin bilip wo nyunubu dodogowin e. Ali yek yakli nyak nyugakome ali yekin bilip nyunubu nyutoglu dodogowin.” ");
INSERT INTO apeB_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Ali douk Jisas natik umu echudak wolobaichi chasahul chanaki halakatimu anan, ali anan nahu atudak owotu nakli, “Nyak yowenyi sagabu douk nyenek anudak nuganinu nogugaku ali wo niyagwleh ati uli e. Yek yanubu yaklipenyamu nyutukemanaguk nyutoglu nyunak ali kobi wata nyutanamali nyuwichanu!” ");
INSERT INTO apeB_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Ali atudak owotu tohwalu nebegun ali tatuk anudak chokunali alman tonoul atap ali tatukemanaguk tatoglu talhwas. Ali anan kluk kluk nakus kobi douk chagak uli chakus umu. Ali wolobaichi elpech chopuk, chatulunu ali chakli anan anagak. ");
INSERT INTO apeB_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Wakuli Jisas nasuh ananin logul ali nanahul naitak neyotu iluh. ");
INSERT INTO apeB_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Ali douk Jisas nanu ananim disaipel atum hawich hape wilpat ali amam hasalikanu hakli, “Apak douk mabilak wo dodogowipamu muhiyahuk atudak owatau e, umu moneken?” ");
INSERT INTO apeB_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Ali anan naklipam nakli, “Douk ipak punek tambumu kakwich ali punek beten pusalik God nugakamepu ele, ipak deke puhiyahatu. Wakuli douk ipak atipu ali ipak dakio wo dodogowipu e.” ");
INSERT INTO apeB_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Ali amam hatukemaguk ablabuk wabul ali hawich hanak provins Galili ali hanak. Douk hanak wakuli Jisas nakli wak umu enech elpech chudukemech umu agnabuk amam hanak hapemu. ");
INSERT INTO apeB_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Umu moneken, anan nape naklipam wolobainyi ananin yopinyi balan ananim disaipel. Anan naklipam nakli, “Elpech eke chugilapu yekim birua umu yek Anudak Alman douk yataglu aduligeinyi elpen uli ali eke huhwe hunak he igak. Wakuli wata huklimu bieh atuh nyumneh umu, yek eke wata itak ipe.” ");
INSERT INTO apeB_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Wakuli amam wo hudukemu bawogen umu enyudak balan e. Ali chopuk, amam elgeim ali wo husalikanu e. ");
INSERT INTO apeB_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Douk amam hanak hatoglu Kapaneam, ali hanak hawich hape anatu wilpat ali Jisas nasalik ananim disaipel nakli, “Dukwechuk manaki yah umu, ipak pape peyagwleh pakli moneken?” ");
INSERT INTO apeB_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Wakuli amam wak huklipanu enen balan e. Umu moneken, dukwechuk amam hanak yah umu, amam yet hape henechichilak umu meinali eke nupe nebenalimu amam hunatimaguk. ");
INSERT INTO apeB_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Ali Jisas nabih nape atap, ali nahwalu ananim 12-poleim disaipel hanaki ali naklipam nakli, “Echebuk elpech douk chukli chupe nebechi uli, susubuati echech imas chupe kobi douk chokwichi umu. Ali chupe chakamamu chunatimaguk elpech chunekumech moul meyoh ali echech eke adakio chupe nebechi.” ");
INSERT INTO apeB_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","37","Ali Jisas nasuhwi enen batowin nanaki nenyusopu nyeyotu amam hapemu umu hutulin ali anan natuken nahwen ali naklipam nakli, “Echebuk elpech douk ulkwip pulomu yek ali chugakomu enen batowin kobi douk enyudak umu, echech douk chagakomu yek. Ali echebuk douk chagakomu yek uli douk wo chugakomu yek otuwe e, wak. Echech douk chagakomu anudak douk nakagasi yek yanaki uli chopuk.” ");
INSERT INTO apeB_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Ali Jon naklipu Jisas nakli, “Nebenyali Tisa, apak matik ananu alman nape nohiyahuk sagabehas umu nyakin yeul ali echech chatoglu chalhwas. Wakuli apak maklipanamu anan kobi wata nunek namudak, wak. Umu moneken, anan douk wo nugipech apak uli e.” ");
INSERT INTO apeB_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Wakuli Jisas naklipam nakli, “Ipak kobi puklipanamu nutukemaguk enyudak moul anan nape neneken uli. Umu moneken, echebuk douk chenek God atunu neneken uli moul umu yekin yeul uli eke kobi chukli enen yowenyi balan umu yek. ");
INSERT INTO apeB_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Ali echebuk douk chagakomepoluli douk chanaguk ipak. ");
INSERT INTO apeB_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Aduligu atugu yek yaklipepu! Echebuk elpech douk chukli ipak douk yekipu ali echech dakio chukepu anabal abal umu yekin yeul umu, God eke nubukumech yopichi echudak chukusumech.” ");
INSERT INTO apeB_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Ali Jisas naklipech enyudak balan chopuk nakli, “Sapos enen elpen nyunek enen echudak chokwichi douk chenek bilip umu yek uli nyunek yowenyimu, enyen douk nyanubu nyenek yowenyi. Ali sapos chuhwen chusoh anam nebemi utam enyenyik lobik ali chuwachen nyugluk yous ele, enyen deke nyupe sisahw kwalowi ati. Wakuli namudak eke wak. Enyen eke nyunubu nyupe sisahw. ");
INSERT INTO apeB_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Douk namudak ali sapos enen nyakin logul nyunekenyu nyunek yowenyimu, nyak nyunubu nyubleyen nyunakuk ali atin meyoh nyupeik. Douk atin logul nyupemenyomu, nyak eke nyunak nyupe kalbu eheh nyumneh. Kedeke biech loguh chupe ali chunekenyu nyunamu abuldak yowebuli wabul hel, douk nyih hanu hape namudak eheh nyumneh abuli. ");
INSERT INTO apeB_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Ali ablabuk yowebuli wabul hel douk nyih hanu eheh nyumneh uli hanumu, eheh eke kobi hugak ati, wak. Ali echudak kobi douk echuguh umu eke chunatukenyu. Ali chopuk echech eke kobi chugak, wak. Echech eke chupe eheh nyumneh. ");
INSERT INTO apeB_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Ali sapos onohw nyakihw yalihw hwunekenyu nyunek yowenyi nyukanaguk agab God umu, nyak nyunubu nyubleyohw hwunakuk ali otuhw hwupeik. Douk atuhw yalihw hwupemenyamu, nyak eke nyunak nyupe kalbu eheh nyumneh. Kedeke bioluh yaliluh hlupemenyu ali hlunekenyu nyunamu abuldak yowebuli wabul hel, douk nyih hanu hape namudak eheh nyumneh abuli. ");
INSERT INTO apeB_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Ali ablabuk yowebuli wabul douk nyih hanu eheh nyumneh uli hanumu, eheh eke kobi hugak ati, wak. Ali echudak kobi douk echuguh umu eke chunatukenyu. Ali chopuk, echech eke kobi chugak ati, wak. Echech eke chupe eheh nyumneh. ");
INSERT INTO apeB_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Ali sapos anap nyakip nabep punekenyu nyunek yowenyimu, nyak nyunubu nyutukapuk ali atup meyoh pupemenyu. Douk atup pupemenyomu, nyak eke nyunak nyupe agnabuk douk God ananich elpech chapemu. Kedeke bios nabes supemenyu ali sunekenyu nyunamu abuldak yowebuli wabul hel, douk nyih hanu hape namudak eheh nyumneh abuli. ");
INSERT INTO apeB_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Ali ablabuk yowebuli wabul nyih hanu eheh nyumneh uli hanumu, eheh eke kobi hugak ati. Ali echudak kobi douk echuguh umu eke chunatukenyu. Ali chopuk, echech eke kobi chugak ati, wak. Echech eke chupe eheh nyumneh. ");
INSERT INTO apeB_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Chanatimaguk elpech chape apudak atap uli eke nyih hunich ali hunekech chutukemaguk enenyi enen yowenyi. Ehudak nyih eke hunich ali hunekech chutoglu yopich. Echech eke chutoglu yopich kobi douk chowemu sol mahich lenekech chatoglu yopich, ali chenek ofamech choku God natulich nakli wosik uli. ");
INSERT INTO apeB_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Ali sol alal douk yopuli. Wakuli sapos alal wata jebiyail umu, elpech deke kobi enen nyunokwnumu wata nyunekal wichusil, wak. Ali ipak douk pape namudak ati kobi douk wichusili sol umu. Douk namudak ali ipakiluh apaluh imas hlulu kalbu ali ipak kobi pulpak puhlitak, wak. Ipak imas punogabemu pupe atugun.” ");
INSERT INTO apeB_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Ali Jisas naitak natukemaguk ablabuk wabul nanamu Provins Judia. Anan naitak nablo wolub Jodan ali nanak gani woblahahibamu. Ali wolobaichi elpech chanaki chape anan napemu, ali nape naklipech yopinyi balan kobi douk wihluwehlu nape naklipech umu. ");
INSERT INTO apeB_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Ali anam Farisi hanaki anan napemu umu hunek lohumanu ali hakli hichakama-namu enen balan. Ali amam hasalikanu hakli, “Nyak klipapu, apakin lo douk nyakli wosik umu ananu alman nunek julug umu ananik almatok waka wak?” ");
INSERT INTO apeB_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Ali Jisas nasalikam nakli, “Seiwak Moses naklipepu moneken dodogowinyi lo?” ");
INSERT INTO apeB_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Ali amam hakli, “Moses douk nakli wosik umu ananu alman nukli nunek julug umu ananik almatok umu, anan imas nunekumok anap chup umu agundak echech chenenemu julug umu nukok kwunohwop, ali nukogok kunamu okwok umu.” ");
INSERT INTO apeB_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Ali Jisas naklipam nakli, “Moses douk nowemumepaguk enyudak dodogowinyi lo ipak umu moneken, ipak douk balagas sanubu sechukepu. ");
INSERT INTO apeB_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Wakuli seiwak bawogos umu God nenek enechi enech echudak umu, balan nyetemu God ananik buk uli douk anyakli, ‘God nenekech alman uli almatok. ");
INSERT INTO apeB_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Douk namudak ali alman eke nutukemaguk ananich mamechich ali nunak nunu ananik almatok chupe sik. ");
INSERT INTO apeB_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Ali echech biech eke chutoglu atin elpen.’ Echech eke kobi wata chupe kobi douk biech umu, wak. ");
INSERT INTO apeB_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Douk namudak ali elpech yet eke kobi chiyais enech echudak douk God nowechikech, nakli chupe atugun uli, wak.” ");
INSERT INTO apeB_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Ali Jisas nanu ananim disaipel hanak hawich wilpat ali amam hasalikanamu enyudak balan dukwechuk anan naklipech enyi. ");
INSERT INTO apeB_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Ali anan naklipam nakli, “Sapos ananu alman nunek julug umu ananik almatok ali wata nulau kipaikwimu, anan douk nablo enyudak lo umu chanasupamu. Ali anan nanu okwok douk chenek yowenyi chanasonukeh umu chanak hwaloh. ");
INSERT INTO apeB_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Ali douk namudak ati. Sapos onok almatok kwukli kwune julug umu okwokwinu alman ali wata kwunak kwulau kipainalimu, okwok douk kwablo enyudak lo umu chanasupamu. Ali okwok kwanu anan douk chenek yowenyi chanosonukeh umu chanak hwaloh.” ");
INSERT INTO apeB_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Ali enech elpech chalawali enech batowich chanakimu Jisas umu nuwemeyech wis, ali nunekumech yopinyi. Wakuli Jisas ananim disaipel hahech hakli, “Ipak kobi pulawechi punakimu Jisas wak.” ");
INSERT INTO apeB_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Wakuli Jisas nemnekam namudak ali anan nyihihichinu ali nahom nakli, “Ipak kutuk echudak batowich chunakumali yek. Umu moneken, echebuk elpech douk chupe kobi echudak chokwichi batowich eke chuwich agundak God nape nebenalimu ananich elpech umu. ");
INSERT INTO apeB_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Aduligu atugu yek yaklipepu! Echebuk elpech douk chukli chuwich agundak God nape nebenalimu ananich elpech umu, wakuli echech kobi chunubu chukanu apaluh God kobi douk batowich chakanu apaluh umu, echech eke kobi chuwich.” ");
INSERT INTO apeB_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Ali anan natuk echudak chokwichi batowich nowemeyech wis atin ati, ali nenekumech yopinyi. ");
INSERT INTO apeB_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Douk Jisas natukemaguk agnabuk naitak nape nanak yah, wakuli ananu alman nasahul nanak natoglomanu. Ali nanak nabih noduk ohlubus natik atap ali nasalik Jisas nakli, “Yopinyali tisa, yek imas inek moneken ali, eke dakio inubu ipe kalbu eheh nyumneh?” ");
INSERT INTO apeB_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Ali Jisas nasalikanu nakli, “Nyak nyohwale yopuwelimu moneken? God atunu douk yopunali. ");
INSERT INTO apeB_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Nyak douk anyadukemen enyudak lo douk nyetemu God ananik Buk uli. Enyen douk nyakli, ‘Ipak kobi pubo kipaichi elpech chugak. Kobi punosonukeh umu punak hwaloh, Kobi puku aluh, ali kobi punek loh umu kipaichi pukli echech chenek enen yowenyi. Ali chopuk, kobi punek loh umu kipaichi punolukech echechich echudak meyoh, wak. Ali pumnek ipakich mamechich echechin balan ali pugakamech.’” ");
INSERT INTO apeB_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Ali anudak alman naklipu Jisas nakli, “Tisa, seiwak yek wata chokuwemu yape yanaki aliga nameitu, yek yasuh enyudak nyanatimaguk lo yagipechen.” ");
INSERT INTO apeB_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Ali Jisas natulunu ali anan ulkum manubu manohwanu ali naklipanu nakli, “Nyak douk atin meyoh yopinyi moul wata nyape, nyak wata nyuneken e. Nyak nyunak nyuhul chunatimaguk nyakich echudak nyuku kipaichi chutalich chukenyu utabal. Ali nyunak nyiyaisabal umu echudak wakechi elpech. Nyak nyunek namudak ali kwali nyak eke nyulau yopichi echudak gani iluh heven. Ali nyak nyunekuk namudak iyuh ali adakio nyunaki nyugipeche.” ");
INSERT INTO apeB_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Ali douk anudak alman nemnek namudak, ali anan apahw hwanubu aman ali ananin domanyu nyanubu nyotuhiyahi. Umu moneken, anan douk nanubu nanabuk wolobaichi enechi enech echudak. ");
INSERT INTO apeB_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Ali Jisas natik ananim disaipel nalihi nalih julug ali naklipam nakli, “Echebuk elpech douk chonokwalmu wolobaichi echudak chenechubuk uli eke chunek hatpolein moul umu chuwich agundak God nape nebenalimu ananich elpech umu.” ");
INSERT INTO apeB_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Ali ananim disaipel hemnek ananin balan ali hanubu loguh hwonechlukam. Wakuli Jisas wata chopuk nakli, “O ipak yekipu elpech! Echebuk elpech douk chakli enechi enech echechich echudak eke chugakomech umu chuwich agundak God nape nebenalimu ananich elpech umu eke chunek hatpolein moul iyuh ali adakio chuwich. ");
INSERT INTO apeB_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Wakuli enen nebenyi mahin chohwalen umu kamel uli nyukli nyuwich nyil, agundak gnagal umu tret tenenyigul umu luseh hanokwlopomu, enyen eke nyunek chokwinyi moul meyoh ali nyuwich. Wakuli echebuk elpech douk chonokwalmu wolobaichi enechi enech echudak uli eke chunubu chunek nebenyi moul ali adakio chuwich.” ");
INSERT INTO apeB_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Ali douk ananim disaipel hemnek namudak ali hanubu loguh hwonechlukam. Ali amam yet hape hanasalik-agasumu hakli, “Anan nakli namudak ali God eke nunolau meichi chutanamali chupe kalbu?” ");
INSERT INTO apeB_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Ali Jisas natulum duk ali naklipam nakli, “Elpech echech yet eke kobi dodogowich umu chuwich agundak God nape nebenalimu ananich elpech umu. Echech atich eke chubilak wak. Wakuli God nugakomech umu, echech wosik eke chuwich. Umu moneken, God douk nanubu dodogowinali ali nanokwnumu nunek chanatimaguk echudak.” ");
INSERT INTO apeB_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Ali Pita naklipanu nakli, “Jisas nyak mnek, apak douk amatukemaguk chanatimaguk apakich echudak ali manaki memnek nyakin balan mahwen magipechenyu.” ");
INSERT INTO apeB_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","30","Ali Jisas naklipam nakli, “Aduligu atugu yek yaklipepu! Echebuk elpech douk chutukemaguk echechig wilag, gwunu echechich sachich owachich, chunu echechiu mehwaliu, wunu echechiu mamaliyu, wunu echechim ahlim, hunu echechich batowich, chunu echech umu yawihas umu chugipech yek, ali chuklipech yekin yopinyi balan uli, abudak nyultab echech wata chupe apudak atap umu, God eke nukech wolobaichi echudak alagun chunubu chichalakuk likuk chalik chalawech uli. God eke nukech wilag gwunu sachich owachich, uli mehwaliu wunu mamaliyu, wunu batowich uli yawihas. Ali chopuk, kipaichi eke chukech agabus ali chunekech chulau hevi chumnek nyih. Wakuli echech eke wata chunak chupe kalbu eheh nyumneh. ");
INSERT INTO apeB_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Ali echebuk elpech douk nameitu chape nebechi uli eke wata chupe kobi douk chokwichimu. Ali echebuk douk nameitu yeguh wakechi eke wata yeguh hwukihech.” ");
INSERT INTO apeB_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Ali Jisas naitak nanu ananim disaipel hape hagimu yah hanak haltomu Jerusalem. Jisas naitak nalik ali ananim disaipel loguh hwonechlukam ali amamip ulkwip polu sisahw ali hagimanu hanak. Ali echebuk elpech douk chagimom chanak uli chopuk elgeich. Ali Jisas wata chopuk nalau ananim atum hanak ali anan nape naklipam umu echudak douk eke chutoglomana-luli. ");
INSERT INTO apeB_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Anan naklipam nakli, “Ipak pumnek! Nameitu apak munamu Jerusalem. Apak eke munak agnabuk ali ananu alman eke nugilapam Yek Anudak Alman douk yataglu aduligeinyi elpen uli amam nebemi pris hunu amam henek skulumech umu lo uli. Ali amam eke huhwe hunak hunek kwotume ali hulawemu amam douk wo Juda uli e hunak he igak. ");
INSERT INTO apeB_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Ali eke huneke enenyi enen hiyokosuwe ali hukwusehe. Ali eke huleye nadululuh ali he igak. Wakuli douk huklimu bieh atuh nyumneh ahi, yek eke wata itaki ipe.” ");
INSERT INTO apeB_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Ali Sebedi ananim biom nugamim Jems uli Jon hanakimu Jisas ali haklipanu hakli, “Nebenyali tisa, ohwak wakli wuklipenyu enen balan ali nyak nyumnekohu ali nyunekumohu echudak douk eke ohwak wusalik-enyomech uli.” ");
INSERT INTO apeB_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Ali Jisas nasalikam nakli, “Ipak pakli inekumepu moneken?” ");
INSERT INTO apeB_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Ali amam haklipanu hakli, “Ohwak wakli ababuk nyultab nyak nyulau nebenyi yeul, ali nyunubu dodogowinu nyuhiyatik umu, ohwak chopuk wakli ohwakich yeguh chukihohwu ali wupe nebehwali. Ananu nupe aninyomu ali ananu nupe alganyomu.” ");
INSERT INTO apeB_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Ali Jisas naklipam nakli, “Ipak douk wo pudukemech umu enyudak ipak pasalikemen uli e. Ipak wosik eke dodogowipamu pumnek ehudak nebehi nyih douk ahalakatimu eke yek imnekeh uli? Kipaichi eke che imnek nebehi nyih ali eke igak. Ali ipak douk wosik eke punokwnumu chuhwepu chunak chepu punomnek nebehi nyih iyuh, ali adakio pugak kobi douk yek umu?” ");
INSERT INTO apeB_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Ali amam haklipanu hakli, “Wosik, ohwak wanokwnu.” Ali Jisas naklipam nakli, “Wosik, ipak panokwnumu pumnek nebehi nyih douk eke yek imnekeh uli. Ali chopuk, panokwnumu kipaichi chuhwepu chunak chepu pumnek nebehi nyih iyuh ali ipak ananu adakio nugak umu. ");
INSERT INTO apeB_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Wakuli enyudak umu ipak ananu nupe onuwemu, ali ananu nupe algawemu ali ipak yeguh chukihepomu, enyen douk God ananin moul. Echebuk elpech douk seiwak God anan yet nanotalihech uli echech atich eke yeguh hwukihech ali enech chupe onuwemu, ali enech chupe algawemu.” ");
INSERT INTO apeB_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Ali douk amudak anam 10-poleim disaipel hemnek enyudak balan Jems uli Jon haklien uli ali amam nyihihichim umu Jems uli Jon. ");
INSERT INTO apeB_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Ali Jisas nahwalu hanatimaguk hanaki hape atugun anan napemu ali naklipam nakli, “Ipak douk padukemech umu echebuk douk wo chudukemu God uli e echechin pasin umu echechim nebemi. Amabuk douk chohwalam umu nebemi uli, douk hanubu dodogowim atumu ali hanalak umu kipaichi elpech umu chunek wolobainyi enenyi enen nebenyi moul. ");
INSERT INTO apeB_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Wakuli ipak eke kobi punek namudak, wak. Sapos ipak ananu nukli nupe nebenalimu ipak enepamu, susubuati anan imas nunemepu moul meyoh ipak punatimaguk iyuh, ali anan eke adakio nupe nebenalimu ipak. ");
INSERT INTO apeB_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Ali chopuk, sapos ipak ananu nukli nunubu yeul nyukihanoluli, susubuati anan imas yeul wakanu nupe chakamamu ipak punatimaguk ali nunemepu moul meyoh ali anan deke adakio yeul nyukihanu. ");
INSERT INTO apeB_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Ali yek Anudak Alman douk yataglu aduligeinyi elpen uli douk wo inakumali kipaichi elpech chuneme moul e, wak. Yek yanakmali igakamu elpech inekumech moul. Ali umu ikech yek yet umu che igak umu ital wolobaichi elpech ikwechihech umu echechin yowenyi.” ");
INSERT INTO apeB_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Ali Jisas nanu ananim disaipel hanak hatoglu wabul Jeriko ali Jisas natukem-abuluk nape nanak. Ali ananim disaipel hanu wolobaichi elpech chopuk chanamanu chanak. Ali agnabuk, Timias ananinu nuganinu Batimias nape. Anan nabes sechukanu ali nape algasih umu yah. Ali wihluwehlu anan nape nahwalu elpech chalahe yah ulimu chukanu anabal utabal. ");
INSERT INTO apeB_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Ali douk anan nemnek umu Jisas douk nanaki wabul Nasaret uli nanakimu, ali anan nahwalu nebegun nakli, “Jisas, Devit ananinu yamenu! Nyak nyukli mapiliwe yek!” ");
INSERT INTO apeB_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Wakuli wolobaichi almom almagou chahanu chaklipanamu nusak. Wakuli anan wo numnekechuk e. Anan nanubu nahwalu nebegun nakli, “Devit ananinu yamenu, nyak nyukli mapiliwe yek!” ");
INSERT INTO apeB_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Ali Jisas nemnekanu ali nanaki neyotu. Ali naklipech nakli, “Ipak hwalanu nunaki agundak.” Ali echech chohwalanu chakli, “Jisas nahwalenyu, douk namudak ali nyak kobi elgeinyu. Kitak yowi agundak.” ");
INSERT INTO apeB_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Ali anan naitak nowaluk ananitu saket natabukuk ali naitak nanak gani Jisas neyotumu. ");
INSERT INTO apeB_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Douk nanak ali Jisas nasalikanu nakli, “Nyak nyakli inekumenyu moneken?” Ali anan naklipanu nakli, “Nebenyali, yek yakli inatulugun.” ");
INSERT INTO apeB_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Ali Jisas naklipanu nakli, “Nyak kale. Umu moneken, nyak nyenek bilip nyakli yek dodogowiweli ali nyakis nabes dakio yopus.” Ali ahudak atuh anan nanubu natulugun ali nanamu Jisas hanak. ");
INSERT INTO apeB_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Jisas nanu ananim disaipel hanak hatoglu halakatimu Jerusalem. Omom hanak hatoglu albudak biolub chokulubi walub Betfasi uli Betani. Omom hanak agundak ahah halakatimu anudak maunten Oliv ali Jisas nakagas biom disaipel umu hulik hunak. ");
INSERT INTO apeB_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Ali naklipam nakli, “Ipak pulik punak babli wabul douk blapeli gani woblahah uli. Ipak eke punak putoglu ati, ali eke putik enen nugan donki. Enyen douk chowechiken metegas ali nyeyotu. Likuk enyen douk watak nyuwalu enen elpen nyulahemen e, wak. Ipak punak putoglu putulin ali pukwachihen pulawen punaki agundak. ");
INSERT INTO apeB_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Ali ipak pupe pukwachihen, ali sapos enen elpen nyusalikepu nyukli, ‘Ipak pokwachihen umu, enyudak donki?’ Ipak puklipen pukli, ‘Diginali nakli nulawen banabu nyultab meyoh umu nunek enen moul ali anan eke wata nulawenyi wisnabul.’” ");
INSERT INTO apeB_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","5","Ali amam hanak ali hatik enen nugan donki chowechiken nyeyotu adukah duaitamu anatu wilpat. Ali amam hanak hape hokwachihen wakuli enech elpech douk cheyotuwi halakati uli chasalikom chakli, “Ipak pokwachihen umu moneken enyebuk nugan donki?” ");
INSERT INTO apeB_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Ali amam haklipech enyudak atin balan kobi douk dukwechuk Jisas naklipam umu. Douk namudak ali echech chakli wosik ali amam halawen hanak. ");
INSERT INTO apeB_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Omom halawen hanak umu Jisas ali howemu amamigu saketog agabahin umu enyudak donki ali Jisas nakih netemu chihah saketog ali nanak. ");
INSERT INTO apeB_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Ali wolobaichi elpech chowal echechig saketog ali chape chogalikog chanak yah. Ali enech chanak chobleli yeguhwiweigas lowas echech umu yawihas ali chape chogosubuk yah umu chakli chuginahwah. ");
INSERT INTO apeB_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Ali chanatimaguk elpech douk chalik uli, chanu echebuk douk chagimanaluli chohwalu chakli, “Apak monehilaumanu! God nugakomanu nunekumanu yopinyi ali nupe kalbu. Anan douk nanamali Diginali ananin yeul uli. ");
INSERT INTO apeB_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Apak mutuk God ananin yeul nyukih. Umu moneken, abudak nyultab umu God nupe nebenalimu ananich elpech umu kobi douk seiwak God nagakamu apakinu yamenu Devit umu douk abanaki halakati!” ");
INSERT INTO apeB_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Ali Jisas nanu ananim hanu wolobaichi elpech chanak aliga chanak chatoglu Jerusalem. Ali Jisas nanak nawich God ananitu nebetali wilpat ali natik chanatimaguk enechi enech echudak chakus numun uli. Anan natulich wakuli agagun douk ayowabigun ali nanu ananim 12-poleim disaipel hanubu hanamu Betani. ");
INSERT INTO apeB_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Ali wehluwih amam wata hatukemaguk Betani hatanamu hape hanaki yah ali Jisas nyulub blanu. ");
INSERT INTO apeB_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Ali amam wata hape hanaku lougun ali Jisas natiku enen lowag fik nyeyotuwi. Anan natulin umu nyenek wolobaisi chus ali nakli enep chulkwip eke peil. Douk namudak ali anan nanak umu nakli nudi enep nipah. Wakuli anan wo nutik enep e. Chus atus sape. Umu moneken, enyenyibu nyultab umu chulkwip pil umu douk watak. ");
INSERT INTO apeB_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Ali Jisas naklipu enyudak lowag fik nakli, “Nyak chulkwip eke kobi wata enep pil ali elpech chudiep chipah, wak.” Ali ananim disaipel ahemnekanaguk. ");
INSERT INTO apeB_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Douk amam hanak aliga hanak hatoglu Jerusalem ali Jisas nawich numun banis God ananitu nebetali wilpat tatawomu ali nape nehiyah echebuk douk chenek salim umu echudak uli chanu echebuk douk chatalich uli chatoglu chalhwas. Anan nawich nogwalok-ehumom tebolahas amabuk douk elpech chanaki chenek senisim umu utabal ali hekech kipabali uli. Ali nogwalak-ehumom siahas amabuk douk hape henek salim umu machubiguh almiguh umu kipaichi chatluguh umu chunak chunek ofa moguh chuku God uli. ");
INSERT INTO apeB_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Ali anan naklipech umu kobi watak enech elpech chulau enech echudak chuwich numun banis God ananitu nebetali wilpat tatawomu umu kipaichi chutalich, wak. ");
INSERT INTO apeB_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Ali anan nenek skulumech naklipech enyudak balan douk nyape God ananik buk uli nakli, “God nakli, ‘Yekitu wilpat eke tupemu wolobaichi elpech douk chape nyanatimaguk nebenyi kantri apudak atap ulimu chuwich chupe chunek beten chusalikemu.’ Wakuli ipak penekatu kobi douk chakwu olugwih uli echechitomu.” ");
INSERT INTO apeB_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Ali wolobaichi chemnek Jisas ananin balan ali echech chanubu loguh hwonechlukech. Namudak ali amam pris amamim nebemi hanu amudak henek skulumech umu lo uli hemnek Jisas ananin balan ali hape hatulugunmu anah yah umu hakli honu nugak. ");
INSERT INTO apeB_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Ali wabigun Jisas nanu ananim disaipel hatukemaguk Jerusalem hanak. ");
INSERT INTO apeB_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Wehluwih aglupil atul, Jisas nanu ananim disaipel haitak hagimu yah hanak wakuli amam hatiku enyudak lowag fik. Enyen agundak nubaluh alin nyalto nyanak nyakih umu yeguhiyu wanu chus. ");
INSERT INTO apeB_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Ali Pita ulkum molomaguk enyudak balan nabatik Jisas naklipu enyudak lowag enyi ali naklipu Jisas nakli, “Nebenyali Tisa, nabatik nyak nyahu nyanyi lowag fik nyaklipen umu alin ali nameitu nyanyi nyanubu alin.” ");
INSERT INTO apeB_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","23","Ali Jisas naklipam nakli, “Ipak imas punek bilip umu God. Aduligu atugu yek yaklipepu, sapos enen elpen kobi nyusuh bien tinytin, ali nyunubu nyunek bilip nyukli adul atimu echebuk enyen nyakliech uli eke chunubu chutoglu, ali nyuklipu anudak maunten umu nunotuk nyugluk yous umu, enyen eke nyutoglu kobi douk enyen nyaklimu. ");
INSERT INTO apeB_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Douk namudak ali aduligu atugu yek yaklipepu. Ababuk nyultab ipak punek beten umu God umu nukepu enech echudak, ali ipak punubu punek bilip pukli aduligu atugu anan eke nukepeyech umu, anan eke nukepu echebuk ipak pasalik-anamech uli. ");
INSERT INTO apeB_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Ali ababuk nyultab ipak punek beten ali ipak ulkwip pulomu enen yowenyi kipaichi cheneken umu ipak ulimu, ipak kobi punohwen ali pukwleyenyuk. Ipak imas punek namudak umu ipakinu Aninu nape iluh heven uli chopuk eke kobi nunohwen umu ipakin yowenyi ali nukwleyenyuk. ");
INSERT INTO apeB_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Wakuli sapos ipak punohwen umu yowenyi douk kipaichi cheneken umu ipak uli ali kobi pukwleyenyuk umu, ipakinu Aninu nape iluh heven uli chopuk eke nunohwen umu ipakin yowenyi ali kobi nukwleyenyuk, wak. ");
INSERT INTO apeB_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Ali Jisas nanu ananim disaipel wata hanamu Jerusalem. Amam hanak hatoglu ali Jisas nanak nawich numun banis God ananitu nebetali wilpat tatawomu. Ali amam pris amamim nebemi hanu amudak henek skulumech umu lo uli hanu amam nebemi Juda hanaki hogwatanu. ");
INSERT INTO apeB_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Ali hasalikanu hakli, “Nyak nyalau moneken namba umu nyunek enyudak moul? Ali omuni nyekenyu enyudak namba?” ");
INSERT INTO apeB_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Ali Jisas naklipam nakli, “Yek chopuk yakli isalikepu enen balan. Ali sapos ipak pubeme tukanin umu, yek chopuk eke iklipepamu omuni nyeke namba ali dakio yenek enyudak moul. ");
INSERT INTO apeB_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Ipak klipe, Jon douk nenek baptaisumech uli omuni nyokanu enyudak moul ali dakio nenek baptaisumech? God nokoneyen o enech elpech meyoh?” ");
INSERT INTO apeB_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Ali amam yet heneyagwleh hakli, “Sapos apak mukli God nokoneyen umu, anan eke wata nusalikapu nukli, ‘Douk namudak ali ipak wo punek bilip umu Jon ananin balan e umu moneken?’ ");
INSERT INTO apeB_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Wakuli sapos apak mukli elpech meyoh chokoneyen ali dakio neneken umu, enyudak balan chopuk eke kobi nyunokwnu.” Ali amam elgeimumaguk echech almam almagou. Umu moneken, chanatimaguk douk chakli Jon anan douk ananu adulinu profet. ");
INSERT INTO apeB_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Ali amam haklipu Jisas hakli amam wo hudukemech e. Ali Jisas naklipam nakli, “Yek chopuk eke kobi iklipepamu omuni nyeke namba ali dakio yenek enyudak moul.” ");
INSERT INTO apeB_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Ali Jisas naklipam enyudak woblen balan nakli, “Ananu alman nau wain iyuh ali nalak nalub ananigu nahabigu. Ali anan nalagun nenek anagu bobigu onok bulbuduk umu chulkwip olokwip ali chudiep chunak chumakwiechep umu abal blutaglomu. Ali chopuk, nalak anap oulop potemu iluh ulimu ananu alman nunaki nupe nunek was umu nahabigaluli nunaki nupemu. Ali anudak noglemu nahabigaluli naklipu kipaimi almam henek kontrak hanaki hape henek moul ananigu nahabigu ali anan nanak kipaigunmu. ");
INSERT INTO apeB_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Douk nanak nape aliga ali abudak nyultab umu wainip chulkwip olokwip chudiep umu batoglu. Ali anan nakagas ananu nenekumonu moul meyoh uli nanak umu nuklipu amudak henek moul ananigu nahabigalulimu hukanali ananip umu wainip chulkwip. ");
INSERT INTO apeB_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Ali anan nanak natoglu wakuli amam hanu ali hakaganu natanamu nanak meyoh. ");
INSERT INTO apeB_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Douk anan nanak napeik ali nahabigeinali wata chopuk nakagas kipainali nenekumonu moul meyoh uli nanak umu nuklipam hukanali enep chulkwip. Douk nanak nataglamam wakuli amam wata chopuk hawolunu boglom ali hanu hasigusogeanu ali hakaganu natanamu nanak meyoh. ");
INSERT INTO apeB_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Ali wata chopuk nakagas kipainali nanak ali amam hanu nagak. Ali anan nakagas anam alagun hanak ali amam henekom namudak ati. Anam ham hasigusogeyom, ali anam ham hagak. ");
INSERT INTO apeB_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Douk amudak henek moulamu anudak nahabigeinali uli hatuh, ali ananinu nuganinu douk anan ulkum manubu manahwanaluli atunu napeik. Ali anan neneyagwleh nakli, ‘Yekinu nuganinu nunak umu, amam eke humnekanu.’ Ali anan nakaganu nanak. ");
INSERT INTO apeB_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Douk nanak natoglu ali amam henek moul nahabigaluli hatulunu ali hanaklipamu hakli, ‘Anudak neglemu nahabigaluli nugakuk umu, ananinu nuganinu eke nuglemu chunatimaguk anineich echudak. Douk namudak ali apak amanu nugakuk umu apak mulau ananigu nahabigu!’ ");
INSERT INTO apeB_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Douk namudak ali amam hahwanu hanu nagak ali howachanu natoglu nakusuk aduk agudak nahabigu.” ");
INSERT INTO apeB_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Ali Jisas nasalik amudak nebemi Juda nakli, “Ali anudak neglemu nahabigaluli eke nunek moneken? Anan eke nunaki nubo amudak henek moul uli hugak hutuh ali eke wata nulau kipaimi hunak hunek moul ananigu nahabigu. ");
INSERT INTO apeB_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Ali ipak patulin enyudak balan nyetemu God ananik buk uli waka wak? Balan enyudak, ‘Amudak utam douk halak wilpat uli hakli wakamuk uli douk manubu mataglu susubeim utam masah woblatamu wilpat uli. ");
INSERT INTO apeB_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Amam douk Diginali nenekom mataglu namudak ali apak monehilaumom makli enyen douk Diginali atunu neneken uli moul!’” ");
INSERT INTO apeB_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Ali amam nebemi Juda hadukemech hakli anan nakli enyudak woblen balan umu amam. Douk namudak ali amam nyihihichim umu anan ali hakli hunek kotumonu ali huwechikanu. Wakuli amam elgeim umu echech almam almagou ali hatukemanaguk hanak. ");
INSERT INTO apeB_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Ali anah nyumnah, anam nebemi Juda hakagas anam Farisi hanu anam Herot ananim hanak henek loh umu hichakamu Jisas husalikanu enen balan. Amam henek namudak umu hakli kadak amam humnekanu nukli enen yowenyi balan umu hunek katumanamen uli. ");
INSERT INTO apeB_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Ali amam hanak agundak Jisas napemu ali hasalikanu hakli, “Nebenyali Tisa! Apak madukemenyomu nyak douk wak elgeinyamu enech elpech e. Ali nyak douk wo nyuklipu yeguh hwakihech uli elpech kipainyi balan ali yeguh wakechi nyuklipechuk kipainyi e, wak. Nyak isave nyaklipech atin balan chanatimaguk elpech. Ali nyak isave nyagipech adulin atinyi balan ali nyenek skulumech kalbu umu God ananin pasin. Douk namudak ali nyak klipapu. Apakin lo douk nyakli malmu? Enyen douk wosik umu munek takis umu nebenalimu gavman uli Sisa waka wak?” ");
INSERT INTO apeB_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Wakuli Jisas anadukemech umu amam douk henek loh. Douk namudak ali anan nasalikam nakli, “Ipak pakli pichakomemu moneken? Ipak lawoli anam utam douk pape penek takis umu itulum.” ");
INSERT INTO apeB_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Ali amam hanaki hakanu anam utam ali Jisas nasalikam nakli, “Enyudak yeul uli abalil chetemu amudak utam uli omuni enech?” Ali amam hakli, “Nebenalimu gavman uli Sisa ananich.” ");
INSERT INTO apeB_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Ali Jisas naklipam nakli, “Sisa ananich echudak imas puku Sisa. Ali God ananich puku God.” Ali douk anan naklipam namudak ali amam hanubu loguh hwonechlukam. ");
INSERT INTO apeB_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","19","Ali amam Sadyusi, douk hakli chagak uli eke kobi wata chitaki uli hanaki Jisas napemu ali hasalikanu hakli, “Nebenyali tisa, seiwak Moses nowemaguk enyudak God ananin lo umu apak nakli namudak, ‘Sapos ananu alman ananik almatok kobi kulali enech batowich ali anan nugakuk umu, ananinu owaninu imas nukwaul. Anan imas nukwaul umu chulali batowich umu chugluk sanineigu iwagu.’” ");
INSERT INTO apeB_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Ali amam haklipanu chopuk hakli, “Anabu nyultab, 7-poleim nugamim douk atich mamechich chomlali uli hape. Ali saninu nasuh onok almatok wakuli anan nagakuk ali okwok wo kuloguk enech batowich e. ");
INSERT INTO apeB_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Ali nanosuhwanali agab uli nokwaul wakuli anan chopuk nagak ali okwok wo kuloguk enech batowich e. Ali douk anan nagakuk ali anabuk nanosuhwanali agab uli nokwaul. Douk nokwaul chape wakuli anan chopuk nagak ali wo kuloguk enech batowich e. ");
INSERT INTO apeB_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Ali namudak ati, hanatimaguk amudak 7-poleim hahwok wakuli amam hanatimaguk hagakuk ali okwok wo kuloguk enech batowich e. Ali okwok chopuk kwagak. ");
INSERT INTO apeB_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Ali ababuk nyultab chagak uli wata chitakimu, okudak almatok eke kwitaki ali kupemu meinali? Nyak nyadukemech, susubuati hanatimaguk amudak 7-poleim hahwok uli atum.” ");
INSERT INTO apeB_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Ali Jisas naklipam nakli, “Ipak wo pudukemech e. Umu moneken, ipak wo pudukemu balan nyetemu God ananik buk uli e. Ali chopuk, wo pudukemech umu agundak God nanubu dodogowi-nalimu e. ");
INSERT INTO apeB_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Ababuk nyultab chagak uli wata chitakumali, almam almagou eke kobi chunosupu ati, wak. Echech eke chupe kobi douk God ananich enselahas douk chape iluh heven ulimu. ");
INSERT INTO apeB_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Ali ipak eke patalihen God naklipepeyen uli balan umu agundak eke chagak uli wata chitakimu waka wak? Ali chopuk, ipak patalihen enyudak balan douk nyetemu okudak buk Moses nenemeyok uli waka wak? Moses douk natik nyih hanu enen chokwinyi lowag ali God naklipanu enyudak balan nakli, ‘Yek douk Abraham nanu Aisak uli Jekop amamiwe God.’ ");
INSERT INTO apeB_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Namudak ali God douk wo chagak uli echechinu e, wak. Anan douk chape uli elpech echechinu God.” ");
INSERT INTO apeB_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Ali ananu nenek skulumech umu lo uli chopuk nanaki nape nemnekam umu hape henechichilak umu. Ali chopuk, anan nemnek Jisas naklipamenyi balan douk nyanubu yopinyi atin. Douk namudak ali anan nasalik Jisas nakli, “Meinyi God ananin lo douk nyanubu susubein nyape nyalik nyecholokuk nyanatimaguk lo?” ");
INSERT INTO apeB_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Ali Jisas naklipanu nakli, “Susubein lo douk enyudak, ‘Ipak Isrel pumnek! Apakinu Diginali God douk nanubu anan atunu God. ");
INSERT INTO apeB_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Douk namudak ali ipak ulwkip imas punubu punosuh ipakinu Diginali God. Ali ipakiluh apaluh, hlunu ipakich michich chunu ipakin tinytin imas chunubu chunahwanu ali pukwu nyunatimaguk ipakin strong umu punek ananin moul.’ ");
INSERT INTO apeB_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Ali nyagimogu enyudak uli douk enyudak, ‘Ipak imas ulkwip punosuh kipaichi elpech douk chape halakatimu ipak uli kobi ipak ulkwip panosuh ipak yet umu.’” Ali enyen douk wak enen kipainyi lo nyichalakuk enyudak bien lo e, wak. ");
INSERT INTO apeB_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Ali anudak nenek skulumech umu lo uli naklipu Jisas nakli, “Tisa! Nyakin balan douk nyanubu yopinyi atin. Nyak nyakli adul! God douk nanubu anan atunu Diginali ali wak ananu alagun nupe diginali kobi douk anan umu e. ");
INSERT INTO apeB_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Douk namudak ali aduligu atugu, apak ulkwip imas punubu punosuh anan atunu. Ali apakiluh apaluh, hlunu apakich michich, chunu apakin tinytin imas chunubu chunahwonu ali muku nyunatimaguk apakin strong umu munek ananin moul. Ali ulkwip punosuh kipaichi chape halakatimu apak uli kobi douk apak ulkwip panosuh apak yet umu. Enyudak bien lo douk nyanubu susubein yopinyi lo. Ali sapos apak mugipech enyudak bien lo umu, enyudak pasin douk nyanubu nyechalukuk agundak apak monek ofamu enechi enech echudak mechech nyih hanich hachahuk moku God umu chanu nyanatimaguk ofa chopuk.” ");
INSERT INTO apeB_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Ali Jisas nemnekanamu ananin balan douk nyanubu yopinyi adulin atin ali naklipanu nakli, “Abudak nyultab umu nyuwich agundak God nape nebenalimu ananich elpech umu douk abanaki halakati.” Ali chanatimaguk elpech elgeich ali wo chusalikanu enen alagun balan Jisas e, wak. ");
INSERT INTO apeB_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Jisas nape nenek skulumech numun banis God ananitu nebetali wilpat tatawomu. Ali naklipech enyudak balan nakli, “Amudak henek skulumech umu lo uli hakli Devit ananinu yamenu eke nutoglu Krais douk God natalihanu nakaganu nanamali nunolau elpech ulimu moneken? ");
INSERT INTO apeB_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Seiwak douk God ananin Michin nyohul Devit yet ali nakli enyudak balan umu Krais nakli, ‘Diginali naklipu yekinu Diginali nakli, “Nyak pe agundak onuwemu aliga ibo nyakim birua hubihuk.” ’ ");
INSERT INTO apeB_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Ali tik, Devit yet douk nohwalu anudak alman Krais ananinu Diginali. Douk namudak ali Krais eke wata nutoglu Devit ananinu yamenu malmu?” Ali douk Jisas naklipech namudak ali wolobaichi elpech chanubu chenehilau chakli ananin balan douk yopinyi adulin atin. ");
INSERT INTO apeB_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Ali anan nape naklipech balan nakli, “Ipak pugamu punenek yologimu ipak kobi pugipech amudak henek skulumech umu lo uli amamin yowenyi pasin. Amam hanubu henehilumu hulu lowihi atih luseh hulahemu elpech chutulum chukli amam yopumi nebemi almam. Ali chopuk, hakli hulahe hunak agnabuk elpech isave chowachabal chapemu, umu chutulum ali chunemom gude. ");
INSERT INTO apeB_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Ali hanamu lotu echech Juda chape cheyagwleh balan ogwi wilag umu, amam hanubu henehilaumu hunak hupe hulik, hutemu yopichi siahas umu kadak elpech chutulum. Ali chenek nebeguni woligun abali, amam isave henehilaumu hunak hupe yopugunmu douk nebemi atum hapemu. ");
INSERT INTO apeB_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Ali amam isave hanak hawich almagou douk almam hagak howobukuk uli owowig wilag ali hatulu hakwumech aluh owowich echudak. Ali amam hanak hape henek beten umu, amam henek loulounyi meyoluhin beten umu hakli kipaichi elpech chutulum. Wakuli kwali God eke nubemam amamin yowenyi ali eke nunekam humnek nebehi nyih.” ");
INSERT INTO apeB_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Jisas nape halakatimu asudak bokis douk chape chautu utabal blolomu gani numun God ananitu nebetali wilpat. Ali anan nape natik elpech chanaki chape chautu utabal blagluk asudak bokis umu. Wolobaichi chasuhwi wolobaibali utabal uli chanaki chautu digibali utabal blagluk bokis. ");
INSERT INTO apeB_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Wakuli onok almatok douk anan nagak nokubuk uli kwanaki kwautu biobol chokubali utabal meyoh blagluk. ");
INSERT INTO apeB_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Ali Jisas nahwalu ananim disaipel hanaki ali naklipam nakli, “Aduligu atugu, yek yaklipepu, okudak alman wohikwi almatok okwakwibal gwodubal biobol utabal, douk kwanaki kwautubal bokis uli douk blanubu wolobaibali. Ababal douk blanubu becholakuk abaludak wolobaibali utabal douk chanatimaguk chanaki chautubal uli. ");
INSERT INTO apeB_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Echudak chanatimaguk chanaki chautu tukanibal echechibal utabal blagluk bokis ali tukanibal nebebali blakusumechuk wilag. Wakuli okwok kwautu blanatimaguk okwokwibal utabal. Ali okwok kwanubu kwahogagun, wak anabal utabal blukusumokuk wilpat umu kunotol kakwich umu e.” ");
INSERT INTO apeB_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Douk Jisas napeli numun God ananitu nebetali wilpat naitak nakli nutoglu aduk, ali ananu ananinu disaipel naklipanu nakli, “Nebenyali Tisa! Nyak tik ogudak dudukog wilag douk chalog dudukabal atubal utabal uli.” ");
INSERT INTO apeB_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Ali Jisas naklipanu nakli, “Nyak nyatik ogudak wilag ali nyakli dudukog. Wakuli kamanami kipaichi eke chunaki chichichehog ali eke kobi chukutuk anam atum utam mutemaguk chihahim umu kipaimi utam, wak. Blunatimaguk eke chubolunik blubih blukus atap atugun.” ");
INSERT INTO apeB_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Ali Jisas nalto nakih nape agundak woblahahinamu maunten Oliv. Ali Pita nanu Jems uli Jon hanu Andru amam atum hanak hatoglomanu ali hasalikanu hakli, ");
INSERT INTO apeB_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Apak makli nyuklipapamu ahudak nyumnah douk eke echudak dukwechuk nyaklipopomech uli chutoglomu. Ali chopuk eke moneken nyulik nyutoglomu apak mutulin ali mudukemech mukli, echudak douk ahalakatimu chutoglu?” ");
INSERT INTO apeB_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Ali Jisas naklipam nakli, “Ipak pugamu punenek yologimu kobi anam almom hunaki hunek lohumepu hunekepu pugipech amomin balan, wak! ");
INSERT INTO apeB_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Wolobaimi almom eke hunaki ali amom atunu ati eke hunek lohumepu huklipepamu yekin yeul hukli, ‘Yek Krais douk God natalihe ali nokoge yanaki uli.’ Ali amom eke hunek loh umu wolobaichi elpech. ");
INSERT INTO apeB_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Ipak eke pumnek balan umu wanoh hwutaglu kipailubi lougunilub walub umu. Ali chopuk eke pumnek chupe chulpak halakatimu ipak papemu. Wakuli ipak kobi elgeipu, wak. Adul wanoh eke hwutaglu, wakuli hugikuk uli nyumnah eke kobi kebes hutoglu. ");
INSERT INTO apeB_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Ali enen kantri eke chitak chunu kipainyi kantri chulpak. Ananu king nunu ananich eke chitak chunu kipainali king nunu ananich chulpak. Ali anagun apudak atap eke enyik kutuk, ali anagun eke nebehi nyulbiah hech ali wolobaichi eke chugak nyulub. Enyudak nyunatimaguk nyulik uli hevi eke nyutoglu kobi douk ehudak halik uli nyih, douk almatok kwalik kwomnekeh ali adakio kwolali batowin umu. ");
INSERT INTO apeB_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Douk namudak ali ipak yet imas punenek yologi. Echech eke chunaki chuhwepu chulawepamu nebemi douk hape hasuh kwotog uli. Ali chopuk, eke chuwich chuleyepu enech echudak gani numun echech Juda chape cheyagwleh balan ogwi wilag. Echech eke chuleyepu echudak umu agundak pasuh yekin balan pagipech yek umu. Ali echech eke chuhwepu chulawepamu amom nebemumali gavman uli hunu amom king hapemu umu puklipam God ananin yopinyi balan douk nyaklimu yek uli. ");
INSERT INTO apeB_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Ali susubuati, yekich elpech eke chunak blunatimaguk walub blape apudak atap uli chuklipech God ananin yopinyi balan iyuh, ali hugikuk uli nyumnah eke adakio hutoglu. ");
INSERT INTO apeB_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Ali ababuk nyultab echech chuhwepu chulawepu chunak chunek kwotumepamu, ipak kobi elgeipu ali pukli kedeke punak ali piyagwleh malmu? Wak, nyunatimaguk balan God eke nukepeyen ababuk atubu nyultab ipak pukli piyagwleh umu. Douk namudak ali moneken balan ipak ulkwip pulomen uli, ipak imas pukliyen. Umu moneken, enyen douk wo ipak yet puklienyi e, wak. Enyen douk God ananin Michin nyepahul dakio paklienyi. ");
INSERT INTO apeB_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Ali enech elpech eke nyihihichih umu echechich sachich owachich ali eke chunekumech kwot chuwechikech ali chunak kipaichi chech chugak. Ali anam ahlim eke nyihihichim umu amamich batowich ali eke hunekumech kwot umu huwechikech ali chunak kipaichi chech chugak. Ali batowich chopuk eke nyihihichich umu echechich mamechich ali eke chunekumech kwot umu chuwechikech ali chunak kipaichi chech chugak. ");
INSERT INTO apeB_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Ali chunatimaguk elpech eke chukli wakepu chukepu agabus chukli ipak yowepalimu agundak pagipech yek umu. Wakuli echebuk douk chugipech yek dodogowich atich aliga chugak uli, God eke nunolawech chutanamali chupe kalbu.” ");
INSERT INTO apeB_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Ali Jisas balan nyeilen nakli, “Ali ipak eke putik kipaichi chulawali enyudak nyanubu yowenyi chunaki chuwich chinyubuk numun God ananitu nebetali wilpat ali eke nyunekatu tubosusih. Enyudak yowenyi God douk nanubu nakli wak umu nyukus numun ananitu nebetali wilpat uli.” Elpen nyutalih enyudak balan uli imas nyugamu nyudukemen kalbu. Ali ababuk nyultab elpech chape blanatimaguk walub blape provins Judia uli imas chulhwas chunamu mauntenab. ");
INSERT INTO apeB_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Ali chape aduk halakatimu echechig wilag uli, eke kobi chitak chuwich wilag umu chunahuli enech echudak, wak. Echech imas chunubu chulhwas chunak meyoh. ");
INSERT INTO apeB_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Ali echebuk douk cheyotu yawihas uli kobi wata chutanamu chusahul chunamu echechig wilag umu chunahuli echechig saketog, wak. ");
INSERT INTO apeB_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Ali mapiliu owobuk apaluhiwali almagou wunu owobuk douk wasuh batowich douk watak cheil chabah uli. Ahabuk nyumnah owo eke wunomnek nebehi nyih! ");
INSERT INTO apeB_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Ali ipak imas punek beten umu enyudak nebenyi hevi kobi nyutoglu ababuk nyultab nebehi echah hulomali, wak. ");
INSERT INTO apeB_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Ehebuk nyumneh, enyudak hevi eke nyutoglu ali elpech eke chumnek nebehi nyih. Ehudak nyih seiwak God nenek apudak atap panu enechi enech chanu elpech chatoglu chape chanaki aliga chataglali nameitu, wakuli enyudakmali hevi watak enen nyutoglu ali nyunek elpech chumnek ehudakmali nyih e. Ali kwali chopuk, elpech eke kobi wata chumnek eneh ehudakmali nyih, wak. ");
INSERT INTO apeB_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Sapos Diginali nutalih wolobaihi nyumneh umu enyudak hevi nyutoglu ele, deke kobi enech elpech chupeik, wak. Chunatimaguk deke chugak chutuh. Wakuli anan ulkum manubu molomu ananich elpech anan nanaglahech uli ali natalih gwodih meyoh nyumneh umu enyudak hevi nyutoglomu. ");
INSERT INTO apeB_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Ali sapos enech elpech chunaki ali chuklipepu chukli, ‘Ipak tik, Krais douk God natalihanu nokoganu nanaki uli anudak nape agundak o nani nape gani umu, ipak kobi punek bilipumech, wak.’ ");
INSERT INTO apeB_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Wolobaimi almom atunu ati eke hunaki hunek lohumepu hukli, ‘Yek Krais.’ Ali anam eke hunaki hunek lohumepu ali amom atunu ati eke hukli, ‘Yek onowe profet.’ Ali amom eke hunek enenyi enen God atunu neneken uli moul. Omom eke hunek namudak umu hukli hunek loh umu God nanaglahech uli elpech umu chukli adul amom God nagakamom. Ali sapos amom dodogowim ele, amom eke hunek lohumech. Wakuli eke wak. ");
INSERT INTO apeB_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Namudak ali ipak pugamu punenek yologimu ababuk nyultab enyudak nebenyi hevi nyutoglomu. Yek douk enyudak a yalik yaklipepaguk umu chanatimaguk echudak douk eke chutogloluli.” ");
INSERT INTO apeB_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Ali ehudak nyumneh umu enyudak hevi douk eke nyunek elpech chumnek nebehi nyih uli eke hunak hutuhuk, ali nyumnahinu nunu wabinu aub eke yomotokwehib. ");
INSERT INTO apeB_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Ali enechi enech chape iluh utogoluli chunu aub uli unib eke guldugolech ali unib eke unotuk ugluki atap. ");
INSERT INTO apeB_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Ali ababuk nyultab, Yek Anudak Alman douk yatoglu aduligeinyi elpen uli eke wata itukemaguk iluh heven inaki. Yek eke inubu dodogowiwe ihiyatiki ali ilali onog olug inaki. ");
INSERT INTO apeB_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Ali eke ikagas yekich enselahas chunak gnunatimaguk apudak atap ali chulawali chunatimaguk yek yonoglahech uli elpech chunaki chupe atugun. ");
INSERT INTO apeB_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Ipak ulkwip pulomu enyudak lowag fik ali pudukemech. Ababuk nyultab enyen nyupe nyunaleh abali, ipak eke putulin ali pudukemech pukli douk ahalakatimu wah atuh hutau. ");
INSERT INTO apeB_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Ali douk eke namudak ati. Ipak eke putik enyudak nyunatimaguk hevi douk dukwechuk yaklipepamen uli nyutoglu nyunakuk, ali ipak eke pudukemch umu Yek douk ahalakatimu itanamali. ");
INSERT INTO apeB_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Aduligu atugu yek yaklipepu! Ipak doumeipali, enepu eke kobi kebes pugak, wak. Ipak eke wata pupe ali enyudak nyunatimaguk hevi douk dukwechuk yaklipepamen uli eke nyutoglu. ");
INSERT INTO apeB_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Chanatimaguk echudak douk chape iluh utagaluli chunu utagu agag yet, chunu chanatimaguk chape apudak atap uli chunu atap chopuk eke chunubu bulkwolech chunak chuwichuk. Wakuli yekin balan eke nyunubu nyupe eheh nyumneh. ");
INSERT INTO apeB_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Ali Jisas balan nyeilen nakli, Wak enen atin elpen nyudukemu ahudak nyumnah o aua e. God ananich enselahas chanu yek ananiwe nuganinu chopuk wak mudukemah e. Aninu atunu nadukemah. ");
INSERT INTO apeB_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Ipak douk wo pudukemu ahudak nyumnah douk eke echudak chutoglomu e. Douk namudak ali ipak imas punenek yologi ali pupe pubeyogun. Ipak kobi pupe chachip, wak. ");
INSERT INTO apeB_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Ahudak nyumnah echudak chutoglomu eke kobi enyudak woblen balan umu. Balan enyudak. Ananu alman nakli nutukemaguk ananitu wilpat nunak anabul lougunibul wabul. Anan naklimu nunak ali naitak nataliham-umaguk moul sulisuli amam atunu ati douk henekumanu moul meyoh uli. Ali naklipu anudak nape nenek was umu dua ulimu nunek was dua ali nupe nubeyogunmu anan wata nutanamalimu. ");
INSERT INTO apeB_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Douk namudak ali ipak imas punenek yologi ali punek was pupe putulugun. Umu moneken, ipak wak pudukemu ababuk nyultab douk eke wilpatinali nutanamali abali e. Anan eke nunaki wabigun o olokohunib umu wab o nunaki yoweg owotog gwitak umu o nunaki aglupil. Ipak wak pudukemech e, wak. ");
INSERT INTO apeB_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Kedeke wosik ati anan nunaki ahudak atuh ali nutulipamu ipak pichuh. Wakuli wak, ipak imas pupe pubeyogunmanu. ");
INSERT INTO apeB_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Ali enyudak balan yek yaklipu ipak enyi, nameitu yek yaklipu chanatimaguk elpech chopuk. Ipak pugabe punenek yologi ali pupe pubeyogunmu echudak douk dukwechuk yek yaklipepamech uli chutoglomu.” ");
INSERT INTO apeB_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Eheh douk bieh alagun nyumneh watak hapemu chunek agundak nebeguni Pasovaigun woligun ali chuwok bret douk chotoweh wo titak nebetali uli e. Ali amam nebemi pris hanu amam henek skulumech umu lo uli hene loh ilihanu yalihanu hanak hape hatimu Jisas. Amam hatimanu hanak umu hakli anan atunu nunak nupe anagun umu, amam huhwanu ali hunak honu nugak. ");
INSERT INTO apeB_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Wakuli amam wata hakli, “Wak, apak kobi muwechikanu abudak nyultab chunek woligun abali. Umu moneken, kedeke almom almagou chutik namudak ali chuhuli wanoh chopu.” ");
INSERT INTO apeB_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Ali Jisas naitak nanak Betani ali nanu Saimon douk likuk agudak lepra gapenyunali hape ananitu wilpat. Ali douk Jisas nape tebol, nape nawak woligun numun wilpat, ali onok almatok kwasuhwi anal yopuli botol douk chenekol anam utam uli kwanak kwawich. Alal douk chuknil umu enen yopinyi sanda yeulinyumu nad uli. Enyen isave chatalin nebebali utabal. Douk kwawich kwanak agundak Jisas napemu ali kwawolul kwenyukul enyudak sanda nyagluk Jisas ananim boglom. ");
INSERT INTO apeB_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Wakuli enech elpech chape agnabuk uli chatuluk namudak ali echech chanubu nyihihichich ali chakli, “Okudak kwatutehen umu enyudak yopinyi sanda? ");
INSERT INTO apeB_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Douk apak mulawen munak kipaichi chutalin chukapu 300 kina ele, douk deke wosik. Apak deke musuh abaludak nebebali utabal munaki ali miyaisabal umu echudak wakechimu mugakamech!” Echech cheneyagwleh namudak ali chape chahok. ");
INSERT INTO apeB_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Wakuli Jisas naklipech nakli, “Ipak pahok umu moneken? Ipak kutuwakuk, okwok douk kwanubu kwonekume yopinyi moul. ");
INSERT INTO apeB_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Echudak utabal wakechi eke chunepu chupe wihluwehlu. Ali meihi nyumnah ipak pukli pugakamech pukech anabal utabal umu, ipak eke pukech. Wakuli yek eke kobi inepu mupe wihluwehlu, wak. ");
INSERT INTO apeB_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Ali enyudak moul douk okwok dodogowik umu kuneken uli, douk enyudak kwoneken. Okwok kwanaki kwenyukul sanda kwouh yekihw yegenyihw umu kehik kaman che igak ali chunugomemu. ");
INSERT INTO apeB_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Aduligu atugu yek yaklipepu. Elpech chunak blunatimaguk walub apudak atap umu chuklipech God ananin yopinyi balan umu, echech eke chuklipech umu okwok kwoneken uli chopuk ali echech eke ulkwip pulomok.” ");
INSERT INTO apeB_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Ali ababuk nyultab, ananu ananamu amudak Jisas ananim disaipel yeulinamu Judas douk nanaki wabul Kariot uli nanak gani amam nebemi pris hapemu. Ali naklipam umu anan nakli wosik umu nugilapam umu agundak Jisas nanak napemu ali amam hunak huhwanu huwechikanu. ");
INSERT INTO apeB_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Ali amam hemnek Judas ananin balan ali hanubu henehilau ali howechik balan umu amam eke hutalunu hukanu anabal utabal. Ali Judas naitak nanak ali nape nenek tinytin umu anah yah umu nugilapam Jisas ali amam hunak huhwanu huwechikanomu. ");
INSERT INTO apeB_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Douk chenek agundak Pasovaigun woligun umu, echech isave chawak bret douk chotoweh wo titak nebetali uli e. Ali ahudak susubeih nyumnah, echech isave chabo sipsip umu chunek agundak Pasovaigun woligun umu. Ali Jisas ananim disaipel hasalikanu hakli, “Nyak nyakli apak munak munekagun agunmu agundak Pasovaigun woligun umu nyak nyunak nyugnah uli?” ");
INSERT INTO apeB_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Ali Jisas nakagas biom ananim disaipel hanak ali naklipam enyudak balan nakli, “Ipak punak wabul ali eke pupalagas ananu nusahi anap abal bloleyopi malup uli. Ipak putulunu ali pugipechanu punak. ");
INSERT INTO apeB_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Ali punak puwich atabuk wilpat anan nunak nuwich atali ali puklipu atabuk wilpatinali pukli, ‘Apakinu nebenali tisa nakli amudak rum douk elpech chape chechuh omi douk eke anan nunu apak ananipu disaipel mupe munek Pasovaigun woligun mugnah umu douk mape omumu?’ ");
INSERT INTO apeB_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Ipak pusalikanu ali anan eke nugilapepu anam nebemi rum iluhitamu wilpat. Echech douk achagitom ali chagabeyom yopum mape. Ali ipak punak puwich pupe punekumapu woligun.” ");
INSERT INTO apeB_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Ali amudak biom disaipel haitak hanak wabul ali hogwatu chanatimaguk echudak kobi douk dukwechuk Jisas naklipam umu. Ali amam hanak hape henek woligun umu hugnah umu Pasova uli. ");
INSERT INTO apeB_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Douk aliga wabigun halakatimu wab ali Jisas nanu ananim 12-poleim disaipel hanak hawich hape hawak woligun. ");
INSERT INTO apeB_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Douk hape hawak woligun tebol ali Jisas naklipam nakli, “Aduligu atugu yek yaklipepu. Ipak ananu douk nameitu mape mawak woligun uli eke nugilapu yekim biruamu yek ali amam eke huhwe huwechike ali hulawe hunak he igak.” ");
INSERT INTO apeB_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Ali ananim disaipel hemnek namudak ali amamiluh apaluh yoweluh ali amam atunu ati hasalikanu hakli, “Eke yek iklipu nyakim birua waka, eke omuni?” ");
INSERT INTO apeB_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Ali Jisas naklipam nakli, “Ipak 12-poleipu ananu douk eke nunu yek wutu bret tugluk dis ali utowah uli eke nugilapam yek. ");
INSERT INTO apeB_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Ali Yek Anudak Alman douk yataglu aduligeinyi elpen uli eke che igak kobi douk balan nyetemu God ananik buk uli nyakli eke igak umu. Wakuli anabuk douk nugilapu yekim biruamu yek uli, chanubu yowechi echudak eke chutoglamanu! Douk namudak ali yek yakli mapilinu. Douk seiwak mamakik kobi kunalali ele, deke kalbu.” ");
INSERT INTO apeB_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Douk amam hape hawak kakwich ali Jisas nohul anatu bret nahwotu ali nenek beten nenek tenkyumu God ali nagwudukatu noku ananim disaipel. Ali naklipam nakli, “Atudak bret douk yekihw yegenyihw. Ipak suh ali putowoh.” ");
INSERT INTO apeB_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Nokom bret hatowah julug ali nohuli anap kap wainibal abal ali nenek beten nenek tenkyumu God ali nokom amam atunu ati habalah. ");
INSERT INTO apeB_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Ali anan naklipam nakli, “Abludak wainibal abal douk yekig butog. Ogwog douk gwotukwlemu gwugakamu wolobaichi elpech ali gwonek enyudak God ananin nyanubu adulin atinyi balan kontrak nyatoglu dodogowin. ");
INSERT INTO apeB_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Ali aduligu atugu yek yaklipepu. Yek eke kobi wata iwak anabal wainibal abal, wak. Yek eke ipe aliga wata inak agundak God ananich elpech chapemu iyuh, ali yek eke adakio wata ibalah.” ");
INSERT INTO apeB_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Ali amam heyolub onohw awehw julug ali hatoglu haltomu maunten Oliv. ");
INSERT INTO apeB_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Ali Jisas naklipu ananim disaipel nakli, “Kadak ipak punatimaguk eke putukemeik pulhwas punakuk atunu ati. Umu moneken, God ananin balan nyetemu ananik buk uli douk nyakli, ‘Yek eke ibouk anudak nenek was umu sipsip uli ali sipsip eke chulhwas chunakuk atin ati.’ ");
INSERT INTO apeB_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Ali echech eke che igak wakuli yek eke wata itak ali ilik inamu Galili. Ali ipak eke pugime punaku.” ");
INSERT INTO apeB_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Ali Pita naklipanu nakli, “Sapos hunatimaguk hutukemenyaguk hulhwas umu, yek eke inenyu wupe biohu!” ");
INSERT INTO apeB_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Ali Jisas naklipanu nakli, “Aduligu atugu yek yaklipenyu. Kehik wab, nyak eke anyunek loh bieh otuh nyukli nyak wo nyudukemu yek e ali owotu eke titak tiyagwleh bieh.” ");
INSERT INTO apeB_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Wakuli Pita nanubu dodogowinu atunu naklipu Jisas nakli, “Aduligu atugu yek yaklipenyu, yek eke kobi inek loh ikli yek wo idukemenyu e, wak. Sapos echech chukli chubo nyak nyugak umu, yek chopuk eke inu nyak chohu wugak ahudak atuh!” Ali hanatimaguk disaipel chopuk haklipanu enyudak atin balan. ");
INSERT INTO apeB_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Ali Jisas nanu ananim disaipel hanak hatoglu anagun yeuligunmu Getsemani uli ali anan naklipu ananim disaipel nakli, “Ipak pupe agundak ali yek inak inek beten gani.” ");
INSERT INTO apeB_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Ali anan nalmu Pita nanu Jems uli Jon atum hanamanu hanak. Ali agnabuk anan nanubu nemnek sisahw ali ananihw apahw hwanubu yowehw. ");
INSERT INTO apeB_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Ali anan naklipam nakli, “Yekin michin nyanubu yowen ali yek yanadukemamu yek ama igak ati. Douk namudak ali ipak pupe punek was.” ");
INSERT INTO apeB_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Ali natanamu nanak kwalowi lougun ali nabih nakus ananigu wahegu gatik atap ali nenek beten nasalik God. Anan nasalikanamu nakli kadak malmu God kobi nukutuk enyudak hevi nyutoglamanu. ");
INSERT INTO apeB_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Ali Jisas nenek beten nakli, “O Aba yekinu Aninu, nyak douk nyanubu dodogowinali nyasuh iluh atap uli. Yek yakli nyak kobi nyukutuk enyudak hevi nyutoglome, wak. Wakuli nyak kobi nyugipech yekin laik, wak. Nyak nyugipech nyakin atin laik.” ");
INSERT INTO apeB_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Douk nenek beten julug ali anan wata natanamu nanak natulugunmu ananim biom atunu disaipel. Douk anan nanak wakuli natulum umu amam hechuh hagak. Ali anan nasalik Pita nakli, “Saimon, ipak apechuh pagak? Ipak wo dodogowipamu pupe munek was atin aua e? ");
INSERT INTO apeB_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Ipak pupe punek was ali punek beten. Umu Satan nunaki nichakamepu, ipak kobi punek yowenyi. Adul ipak oub baitak umu pugipech yekin balan wakuli ipakiluh yegechiweluh douk wo dodogowiluh e.” ");
INSERT INTO apeB_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Anan naklipam namudak julug ali anan wata natanamu nanak anah alagun nanak nenek beten nasalik God. Anan nenek enyudak atin beten dukwechuk nalik neneken uli. ");
INSERT INTO apeB_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Anan nanak nenek beten julug ali wata natanamu nanak nalpogunmom. Wakuli anan natik umu amam yobus sanubu sahwomuk dudigu ali amam hechuh hagak. Ali anan nabalum haitak wakuli amam wak hudukemech umu moneken balan eke amam huklipanamu e. ");
INSERT INTO apeB_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Ali Jisas wata chopuk natanamu nanak nenek bieh atuh nanak nenek beten nasalik God. Douk anan nenek beten julug ali watak natanamu nanak natoglamam ali naklipam nakli, “Ipak pechuh pape meyoh umu douk ajulug! Ipak kitak! Nyultab douk abanaki, ali nameitu ananu eke nugilapu yowemi douk henek yowenyi atin ulimu Yek Anudak Alman douk yatoglu aduligeinyi elpen uli. Ali amam eke hunaki huhwe huwechike. ");
INSERT INTO apeB_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Ali kitak munak. Tik anudak douk eke nugilapu yekim birua umu yek uli anudak nanaki.” ");
INSERT INTO apeB_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Douk Jisas wata nape naklipam ati, wakuli Judas, ananamu amudak ananim disaipel nanaki natoglomom. Anan nanali wolobaimi hanaki. Amam douk nebemi pris hanu henek skulumech umu lo uli hanu amam nebemi Juda hapeik ali hakagam hasuhwi bainatog uli lowas ali hanaki. ");
INSERT INTO apeB_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Ali amam haitak hanak yah ali Judas naklipu Jisas ananim birua nakli, “Anabuk douk kadak putik umu yek inak ihwanu inaplik-analuli, anabuk douk Jisas. Ali ipak punak puhwanu puwechikanu dadag ali pulawanu punak.” ");
INSERT INTO apeB_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Ali Judas nanak nataglomu Jisas ati ali nanubu nakli, “Nebenyali tisa!” Ali nanak nanoplikanu. ");
INSERT INTO apeB_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Ali amam hanak hahwanu dadag ali howechikanu. ");
INSERT INTO apeB_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Douk amam howechikanu wakuli ananu neyotu halakati uli natuki ananitu bainat ali natupok ananu douk nenekumanu moul meyoh nanubu nebenali pris uli ananih atah tukalah. ");
INSERT INTO apeB_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Ali Jisas nasalikam nakli, “Ipak pasuhwi bainatog uli lowas umu punaki puhwe puwechike kobi douk onowe yaku oluh uli, waka? ");
INSERT INTO apeB_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Wihluwehlu yek yanepu mape atugun ali yape yaklipech balan numun banis God ananitu nebetali wilpat tatawomu wakuli ipak wo puhwe puwechike e. Wakuli nameitu ipak eke punek enyudak balan douk nyetemu God ananik buk uli nyutoglu adulin.” ");
INSERT INTO apeB_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Ali hanatimaguk ananim disaipel hatukemaguk Jisas halhwas. ");
INSERT INTO apeB_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","52","Douk amam howechik Jisas halawanu halik hanak ali ananu yanpoleinali nanasak chogalihwihi lupah atuh uli nagimu Jisas nanak. Anan nagimanu nanak ali amam hakli huhwanu huwechikanu wakuli ananih lupah hatukwachih hakusuk ali anan nalhwas nanak meyoh. ");
INSERT INTO apeB_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Ali amam howechik Jisas halawanu hanamu nanubu nebenali pris ananitu wilpat. Ali amam hanatimaguk nebemi pris hanu amudak douk henek skulumech umu lo uli hanu amam nebemi Juda alagun hanak hape atabuk wilpat. ");
INSERT INTO apeB_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Ali Pita nagipech Jisas nanak wakuli anan nagikuk ati. Douk nanak natoglu ali nawich banis anudak nanubu nebenali pris ananigu awagu ali natik amabuk douk henek was umu God ananitu nebetali wilpat uli hejigul nyih ali hanopemeh. Ali Pita chopuk nanak nanam napemu nyih umu hiyakanu. ");
INSERT INTO apeB_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Ali amam nebemi pris hanu hanatimaguk nebemi Juda douk hape hasuh kwotog uli hohwalu anam almom hanaki hape henekumanu enen balan douk wo adulin uli e umu hakli amam nebemi honu nugakumenyi. Wakuli amam habilak wak. ");
INSERT INTO apeB_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Ali wolobaichi elpech chanaki chenekumanu kwot chenek loh chakli Jisas nenek enenyi enen yowenyi wakuli echechin balan douk wak adulin e. Ali chopuk, echech douk wo chukli atin balan e. Enech chakli enen ali enech chakliyuk enen. ");
INSERT INTO apeB_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","58","Ali anam almam henek loh umu Jisas hakli amam hemnekanu nakli anan eke nutolkeh God ananitu nebetali wilpat douk almam yet halataluli tubih tukus atap. Wakuli umu bieh atuh nyumneh meyoh, anan eke wata nulak kipaitali. Ali atat eke kobi nulotu ananis wis, wak. ");
INSERT INTO apeB_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Ali amam chopuk douk wo hukli atin balan e. Anam hakli enen ali anam hakliuk enen. ");
INSERT INTO apeB_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Ali amam hanatimaguk hape hemnek ali anudak nanubu nebenali pris naitak nasalik Jisas nakli, “Nyak enen balan umu nyuklipam umu waka wak? Nyak nyakli malmamu enyudak balan amam heneken umu nyak uli?” ");
INSERT INTO apeB_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Wakuli Jisas neyotu bleiloguk. Anan wo nuklipanu enen balan e. Ali anudak nanubu nebenali pris nagabe nasalikanu nakli, “Nyak Krais douk God natalihenyu nakagenyu nyanaki uli? Ali nyak douk anudak God douk apak matuk ananin yeul nyakih uli ananinyu nuganinu?” ");
INSERT INTO apeB_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Ali Jisas naklipanu nakli, “O aduligu atugu douk yek wo. Ali ipak eke putik Yek Anudak Alman douk yatoglu aduligeinyi elpen uli inak ipe anunamu Nanubu Dodogowinali God. Ali chopuk eke ilali olug inaki gani iluh heven.” ");
INSERT INTO apeB_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Ali anudak nanubu nebenali pris nemnek namudak ali anan nanubu nyihihichinu ali nakawech ananih luseh. Ali naklipam nakli, “Apak kobi wata muhwalu enech alagun elpech umu chunaki chuklipapamu enen yowenyi anan neneken uli, wak. ");
INSERT INTO apeB_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Apak douk adukwechuk memnek ananin balan. Anan douk nenek tok bilas umu God ali ipak pakli malmu?” Ali amam hanatimaguk hakli anan nenek yowenyi ali amam imas hanu nugak. ");
INSERT INTO apeB_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Ali howechikuk ananis nabes ali anam haitak hanak hokusehanu. Ali hadalu wis ali hape hanu ali hasalikanu hakli, “Nyak klipapu kobi amam profet umu, nameitu douk omuni nyanyu.” Ali amam henek was umu God ananitu nebetali wilpat uli hogoulepanu ali halawanu hanak. ");
INSERT INTO apeB_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Ali onok almatok kwonekumanu moul anudak nanubu nebenali pris uli kwanaki ali kwatik Pita nape anudak nebenali pris ananigu awagu. ");
INSERT INTO apeB_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Okwok kwatulunamu nanopemu nyih. Ali okwok kwatulunu duk ali kwasalikanu kwakli, “Nubuwakih yek yatulinyu nyanu Jisas douk nanaki wabul Nasaret uli pape.” ");
INSERT INTO apeB_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Wakuli Pita nenek loh nakli, “Wak, yek wo idukemen e enyebuk balan nyak nyaklien uli.” Ali anan naitak nanak halakatimu enyudak dua douk cheneken nyape nyatikuk adikap uli ali anatu owotu taitak teyagwleh. ");
INSERT INTO apeB_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Ali okwok wata kwatanamu kwatulunu ali kwaklipu echebuk cheyotu agnabuk uli kwakli, “Anabuk alagun douk ananu Jisas ananinu.” ");
INSERT INTO apeB_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Wakuli Pita wata chopuk nenek loh nakli, “Yek wak.” Ali douk wo loubomu e wakuli echech cheyotu agnabuk uli wata chaklipu Pita chakli, “Aduligu atugu nyak douk enenyu Jisas ananinyu. Umu moneken, nyak douk nyapeli provins Galili uli.” ");
INSERT INTO apeB_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Ali Pita nenek loh nakli, “Sapos yek inek lohumepamu, yek yakli wosik umu God iken ne igak! Yek wo idukemanu e, anabuk alman ipak pape pakliyanaluli.” ");
INSERT INTO apeB_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Douk anan nakliyuk namudak wakuli ahudak atuh owotu wata chopuk taitak teyagwleh bieh. Ali Pita ulkum molomaguk enyudak balan kwigani Jisas naklien uli ali anan neleh sisahw. Balan douk enyudak, “Nyak eke anyunekuk loh bieh otuh nyukli nyak wo nyudukeme e, ali owotu eke titak tiyagwleh bieh.” ");
INSERT INTO apeB_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Ali aglupil atul, amam nebemi pris hanu nebemi Juda, hanu amudak henek skulumech umu lo uli, hanu hanatimaguk nebemi Juda hasuh kwotog uli howachabal hape habo balan. Ali amam hohul onohw naduhw howechik Jisas ananiguh loguh ali halawanamu Pailat douk nape nebenalimu gavman uli. ");
INSERT INTO apeB_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Douk hanak hatoglu, ali Pailat nasalikanu nakli, “Nyak douk echech Juda echechinyu king waka?” Ali Jisas naklipanu nakli, “Adul, yek douk kobi nyak nyaklimu.” ");
INSERT INTO apeB_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Ali amam nebemi pris hape henemanu balan Jisas hechopokanu wolobainyi meyoluhin balan. ");
INSERT INTO apeB_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Douk namudak ali Pailat nasalikanu nakli, “Tik, amam henekumenyu wolobainyi balan. Ali nyak eke nyubemom enen balan waka wak?” ");
INSERT INTO apeB_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Wakuli Jisas wo nukli enen balan e, ali Pailat nanubu loguh hwonechlukanu. ");
INSERT INTO apeB_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Ihech yohwleguh ahudak nyumnah chenek agundak nebeguni Pasovaigun woligun abali, Pailat isave nokwechih ananu nenek kalabus uli nanak fri. Anan isave nokwachih anabuk douk echech almam almagou chukliyanaluli. ");
INSERT INTO apeB_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Ali ababuk nyultab, ananu alman douk nanahwalamu Barabas uli nanu anam almom hanu gavman chalpak ali habo enech elpech chagak uli henek kalabus hape. ");
INSERT INTO apeB_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Ali wolobaichi elpech chanaki chowachabal chape ali chape chaklipu Pailat umu nukwechih ananu nape kalabus uli douk echech chuklianaluli nunak fri kobi douk ihich yohwleguh anan isave neneken umu. ");
INSERT INTO apeB_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Ali douk echech chasalikanu namudak ali Pailat nasalikech nakli, “Ipak pakli ikwechih echech Juda echechinu king nunak fri o pakli meinali?” ");
INSERT INTO apeB_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Pailat douk nakli namudak umu moneken, anan douk nanubu nadukemech umu amam pris amamim nebemi douk henek hinyigimu Jisas. Amam hatik wolobaichi elpech chagipech anan atunu ali amam nyihihichim ali dakio halawanu hanak henemanu kwot umu Pailat. ");
INSERT INTO apeB_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Ali amam pris amamim nebemi hohul wolobaichi elpech echechiluh apaluh ali echech chanubu nyihihichich umu Jisas. Ali echech chasalik Pailat umu nukwachih Barabas nunak fri. ");
INSERT INTO apeB_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Ali Pailat wata chopuk nasalikech nakli, “Ipak pakli yek inekanu malmu anudak alman douk ipak pohwalanu echech Juda echechinu king uli?” ");
INSERT INTO apeB_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Ali echech wata chopuk chohwalu nebegun chakli, “Ne nyilumanu lowag kruse!” ");
INSERT INTO apeB_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Ali Pailat nasalikech nakli, “Anan nenek moneken yowenyimu apak monu nugakumenyi?” Wakuli echech wo chumnekanu e. Echech chanubu chohwalu nebegun atugun chakli, “Ne nyilumanu lowag kruse.” ");
INSERT INTO apeB_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Ali Pailat nakli nunekech chunehilau ali. Douk namudak ali anan nemnek echechin balan ali nakwachih Barabas nanak fri. Ali naklipu amam soldia umu hunak hubo Jisas huleyonu onoh naduhw ali hunak hunek nyilumanu nil lowag kruse. ");
INSERT INTO apeB_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Ali amam soldia hasuh Jisas halawanu hanak hawich gavman echechitu nebetali wilpat ali hohwalu hanatimaguk amudak anam soldia chopuk hanak. ");
INSERT INTO apeB_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Ali amam halamanu anatu loutali owichibal-itali saket. Ali hadalech onohw puligwiluh hlatoglohw uli naduhw henekoh kobi douk king ananitu hat, umu ali hohwemumanu ananim boglom. ");
INSERT INTO apeB_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Ali amam hape henek tok bilasumanu hakli, “O luwahep nyak echech Juda echechinu king!” ");
INSERT INTO apeB_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Ali hohul anah aluh ali hape habo boglominomu wolobaihi atih ali hape hokusehanu. Ali amam henekanu enenyi enen hanak habih hoduk ohlubus halakatimu anan umu hutuk ananin yeul nyukih kobi douk ananu king umu. ");
INSERT INTO apeB_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Douk amam henekanu enenyi enen julug, ali hatulunu howaluk atudak owichibal-itali saket. Ali wata hohul ananih luseh hehlamanu ali halawanu hanak umu hunek nyilumanu nil lowag kruse. ");
INSERT INTO apeB_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Douk hanak olokohunih umu yah ali hogwatu Saimon douk nanaki wabul Sairini uli. Ananim nugamim douk Aleksanda uli Rufas. Anan douk napeli ulah nanaki ali nakli nunak nuwich anabul nebebuli wabul taun. Ali douk amam hogwatanu namudak ali amam soldia dodogowim atum hanalakumanu nasah Jisas ananin lowag kruse. ");
INSERT INTO apeB_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Ali amam halau Jisas hanak anagun douk chohwalogun umu Golgota uli. Bawogen umu enyudak balan douk nyakli elpenyim boglom. ");
INSERT INTO apeB_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Ali agnabuk amam hautu ananu marasin yeulinamu mer uli nagluk umu wainibal abal ali hakli huku Jisas nubalah. Wakuli anan nakli wak. ");
INSERT INTO apeB_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Ali amam henek nyilumanu neiluk lowag kruse ali hohul ananih luseh hehubuk ali hape habilak kobi douk satu umu. Amam habilak umu anabuk nunek win uli nunohul anah lupah. Ali amam henek namobuk atimu hanatimaguk ananih luseh. ");
INSERT INTO apeB_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Ali douk aglupil, aliga 9 kilok wah hatawali ali amam henek nyilumanu neil lowag kruse. ");
INSERT INTO apeB_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Ali amabuk douk henemanu balan Jisas uli howemu enyudak balan douk amam henek kwotumanamen uli hakli, “Echech Juda echechinu king,” ali hechopen chihah lowag kruse Jisas neil umu. ");
INSERT INTO apeB_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Ali agnabuk, amam henek nyilumu Jisas neil olokohun ali biom hakwu aluh uli heil wibul wobul halakatimu anan. ");
INSERT INTO apeB_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Amam douk henek nyilumanu nanu amudak hakwu aluh uli ali henek enyudak balan nyetemu God ananik buk uli nyatoglu adulin. Balan douk enyudak, “Echech chonowanuhuk hablo lo uli.” ");
INSERT INTO apeB_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Ali elpech chenek yowi kale uli chape chenek tok bilasumanu ali chasalikanu chakli, “Nubuwakih nyakli nyak eke nyutalkeh God ananitu nebetali wilpat ali huklimu bieh atuh nyumneh umu, nyak eke wata nyulatu! ");
INSERT INTO apeB_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Douk namudak ali nameitu nyak nyukwachih nyak yet ali nyutukemaguk lowag kruse nyubihi atap!” ");
INSERT INTO apeB_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Ali amam pris amamim nebemi hanu amam douk henek skulumech umu lo uli chopuk hanaki hape hahanu henekanu enenyi enen. Ali amam yet hanaklipamu hakli, “Anan nagakamu kipaichi, wakuli nameitu anan douk wo nugakamu anan yet e. ");
INSERT INTO apeB_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Sapos anan douk Krais echech Isrel echechinu king douk God nakaganu nanaki uli ele, nameitu anan nutukemaguk lowag kruse nubihi atap. Ali apak mutulunu ali eke munek bilipumanu!” Ali amudak biam douk homaul wibul wobul halakatimu Jisas uli chopuk hahanu haklipanu enen enen. ");
INSERT INTO apeB_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Douk aun nakihi aliga 12 kilok ali wab babihi. Ali blanatimaguk echech Juda echechilub walub blanubu yomotokweh tugtuguk. Agagun yomotokweh-igun gnape namobuk aliga wabigun 3 kilok ali wah wata hatau ali hwalalagun. ");
INSERT INTO apeB_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Ali wabigun 3 kilok, Jisas nohwalu nebegun echechin tokples nakli, “Eloi, Eloi, lama sabaktani?” Bawogen umu enyudak balan douk nyakli, “Yekinyu God, yekinyu God, nyak nyatukemeik umu moneken?” ");
INSERT INTO apeB_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Ali enech elpech cheyotu agnabuk uli chemnekanu ali chakli, “Ipak pemnek, anan nohwalu Ilaija.” ");
INSERT INTO apeB_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Ali ananu alman nasahul nanak nohul enen spans nesekwlin anabal nubutibali abal. Ali nenyaku anah aluh ali natuken nyaltomu Jisas ananitu yokwatamu nubalah. Wakuli anudak alman naklipech nakli, “Ajulug ali apak mupe mutulugun. Ilaija eke nunaki nukwachihanu nubihi lowag kruse waka wak?” ");
INSERT INTO apeB_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Ali Jisas nohwalu nebegun ali anan nanubu nagak. ");
INSERT INTO apeB_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Ali ahudak lupah hataul numun God ananitu nebetali wilpat uli tukalah umu bieh. Tukalahi gani iluh aliga hanak habih hatau. ");
INSERT INTO apeB_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Ali amam soldia amaminu nebenali douk neyotu halakatimu lowag kruse Jisas neil umu natik agundak Jisas nagak umu ali nakli, “Aduligu atugu anudak alman douk God ananinu nuganinu!” ");
INSERT INTO apeB_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Ali agnabuk, onou almagou weyotuwi kwalowi lougun ali wape watulichu. Onok douk Maria douk kwanaki wabul Makdala uli kwanu Salome, wanu kipaikwi Maria douk kwalali chokunali Jems nanu Josis uli. ");
INSERT INTO apeB_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Oudak almagou likuk Jisas nape provins Galili umu, owo isave wagipechanu ali wape wonekumanu woligun. Ali wolobaiwali kipaiwali almagou douk wanali Jisas chaltowi gani Jerusalem uli chopuk weyatuwi lougun ali wape watulichu. ");
INSERT INTO apeB_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Ali ahudak nyumnah chabo Jisas ahi, echech chape chenek redimu echechich kakwich uli mahich umu wehluwih Sabat chichah uli. Ali ahudak atuh nyumnah aliga wabigun, ali Josep douk nanaki wabul Arimatia uli nanaki. Anan douk ananu echech Juda echechinu nebenali kaunsol douk yeul nyakih analuli. Ali anan chopuk isave nape nobeyogunmu ababuk nyultab umu agundak God nupe nebenalimu ananich elpech umu. Ali Josep wo elgeinu e wak. Anan nanak Pailat napemu ali nasalikanamu anan nunak nuble Jisas nunak nunugomanu. ");
INSERT INTO apeB_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Ali douk Pailat nemnek namudak ali nanubu loguh hwonechluk-anamu agundak Jisas nanubu nagak wisnabul umu. Ali anan nahwalu amam soldia amaminu nebenali nanaki ali nasalikanu nakli, “Adul, Jisas anagak waka watak?” ");
INSERT INTO apeB_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Ali anan naklipu Pailat umu Jisas douk nanubu nagak. Douk namudak ali Pailat naklipu Josep umu nubleanu nunak nunugomanu. ");
INSERT INTO apeB_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Ali Josep nanak natal anah yopuhi chogalihwihi lupah nahwoh ali nanak nobleli Jisas lowag kruse nabihi atap nechlehanu ali nanak nanugomonu. Anan nanak nawich nanabuk numun onohw hulupihw douk chalagun chenekoh onok bulbuduk uli. Douk nawich nanabukuk ali natoglu nahinali anam nebemi utam nanaki nechopom nagahuk ohwudak hulupihw. ");
INSERT INTO apeB_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Ali Maria douk kwanaki Makdala uli kwanu kipaikwi Maria douk kwolali Josis uli, wape watulugunu. Ali watiku agnabuk douk Josep nanak nobukuk Jisas umu. ");
INSERT INTO apeB_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Douk wabigun halakatimu wab ahudak nyumnah Sabat, echech Juda chape meyoh ahi, 3-poleinyu almagou wanak watal anal wel douk leih kalbalulimu wakli wunak ulayok Jisas ananih yegenyihw. Oudak almagou owowich yeguh douk echudak. Maria douk kwanaki Makdala uli kwanu kipaikwi Maria douk kwolali Jems uli, wanu Salome. ");
INSERT INTO apeB_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Ali wehluwih susubeih nyumnah umu wik, wata aglupil atul, owo waitak wanak gani matmat tapemu. Douk owo wanak wataglu matmat hulupihw hwapemu ali wah adakio hatawali. ");
INSERT INTO apeB_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Ali owo wata wape wanak yah ali woneyagwleh wakli, “Kedeke omuni nyuhinom-umapaguk utam douk magah hulupihw uli?” ");
INSERT INTO apeB_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Ali owo wanak halakati ali wakli wutulugunu wakuli watiku amudak takweimi utam douk magah hulupihw uli douk wak anam mutaku e. Amam douk amatihanu manak makusuk algas. ");
INSERT INTO apeB_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Ali owo wanak wawich numun ohudak hulupihw ali watik ananu yanpeleinali alman, nenenek louhi chogalihwihi lupah uli nape. Anan nape anugulmu numun hulupihw ali owo wanubu loguh hwonechlukou. ");
INSERT INTO apeB_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Wakuli anan naklipou nakli, “Ipak loguh kobi hwunechlukepu, wak. Yek yadukemech, ipak douk patimu Jisas douk nanaki wabul Nasaret uli. Anan douk chenek nyilumanu neil lowag kruse uli. Ali ipak tik, okudak outuk douk chanabuk umu. Agundak wak ananu nukus e, wak. Anan douk anaitak nape. ");
INSERT INTO apeB_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Ali ipak punak puklipu ananim disaipel hunu Pita pukli, ‘Jisas analik nanamu Galili. Ali ipak pugimanu punak putoglomanu kobi douk nubuwakih anan naklipe-pamaguk.’” ");
INSERT INTO apeB_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Ali douk owo womnek namudak ali watukemaguk hulupihw wataglali ali wasahul wanak. Owo wanubu elgeiyu ali owo kluk ati wanak. Ali chopuk owo wo wuklipaguk enech elpech umu echudak owo watulich uli e. ");
INSERT INTO apeB_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Douk echech Juda chape meyoh ahi nyumnah Sabat ahatuh. Ali wehluwih susubeih nyumnah umu wik, aglupil atul Jisas wata naitak nape. Ali susubuati anan natoglomu Maria douk kwanaki Makdala uli. Okwok douk likuk 7-poleich sagabehas chapenyuk ali anan wata nehiyahechuk chatoglu chalhwasuk uli. ");
INSERT INTO apeB_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Douk kwatulunoguk ali okwok kwanak kwatoglomu ananim disaipel wakuli kwatulum umu amamiluh apaluh douk yoweluh ali hape heleh. Ali okwok kwaklipam umu okwok kwatik Jisas wata naitak napemu. ");
INSERT INTO apeB_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Wakuli amam hemnekok wakuli wo hunek bilip e. Amam hakli okwok kwonek loh. ");
INSERT INTO apeB_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Douk enyudak nyanakuk ali anah nyumnah, biom Jisas ananim disaipel haitak hatukemaguk taun ali hagimu ulahih yah hanak. Amam hanak ali Jisas natoglu nape anagun sik ali nanaki natoglomom. ");
INSERT INTO apeB_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Anan natoglomom hatulunu ali amam wata hatanamu hanak haklipu amudak anam disaipel umu agundak amam hatulunamu. Ali douk amam haklipam wakuli amam chopuk wo hunek bilipumom e. Amam hakli amudak biom douk henek loh. ");
INSERT INTO apeB_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Ali hanubu hagikumoguk, ananim 11-poleim disaipel hape hawak kakwich ali Jisas nanak natoglomom. Ali nahom nakli, “Ipakigas balagas douk sanubu dodogowigas ali sechukepu. Nubuwakih enech elpech douk chatiwemu wata yaitak yape uli chanaki chaklipepu wakuli ipak wo punek bilip e. Ipak pakli echech chape chenek lohumepu.” ");
INSERT INTO apeB_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Ali anan naklipam nakli, “Ipak punak blunatimaguk walub blape apudak atap uli ali puklipech God ananin yopinyi balan chunatimaguk elpech. ");
INSERT INTO apeB_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Ipak puklipech ali echebuk douk chumnek enyudak balan chunek bilipumen ali kipaichi chunek baptaisumech uli, God eke wata nunolawech chutanamali chupe kalbu. Ali echebuk douk chumneken ali kobi chunek bilipumen uli, God eke nunekumech nebetali kwot umu enenyi enen yowenyi echech chape cheneken uli. ");
INSERT INTO apeB_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Ali echebuk douk chunek bilip uli, God eke nugakomech nunekech dodogowich ali eke chunek wolobainyi moul kobi douk God atunu neneken uli. Echech eke chuhiyakuk sagabehas douk chape elpech uli chuklipech umu yekin yeul ali eke chutoglu chulhwas. Ali chopuk, eke chiyagwleh enen kipainyi tokples. ");
INSERT INTO apeB_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Ali sapos chuhul idulguh douk hwabo elpech chagak uli chuhwoguh echechis wis umu, ogwoguh eke hunatukech wakuli eke kobi chugak, wak. Ali sapos chuwak anabal abal douk elpech isave chabalah chagak ulimu, echech eke kobi chugak. Ali echech eke chuwemeyech wis agasudak sachi elpech ali echech eke wata yopich.” ");
INSERT INTO apeB_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Ali douk Diginali Jisas naklipech balan neyaten ali God nalawanu naltomu iluh heven. Anan nalto ali nanak nape anunamu God. ");
INSERT INTO apeB_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Ali Jisas ananim disaipel hanak wolobailubi walub ali haklipech God ananin yopinyi balan wolobaichi elpech. Ali ababuk nyultab amam hape haklipech yopinyi balan umu, Diginali nagakamom nenekom dodogowim ali henek wolobainyi moul God atunu neneken uli. Ali elpech chatik enyudak moul amam heneken uli ali chakli aduligu atugu, amam douk God nagakamom. Ali amamin balan douk nyanubu adulin atin.");
INSERT INTO apeB_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","O Tiofilas, likuk wolobaichi elpech chechakomech chowemu balan umu chanatimaguk echudak douk God nohul Jisas nenekech chatoglu olokohun umu apak uli. ");
INSERT INTO apeB_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Echech chowemu balan umu echudak douk echebuk elpech susubati chatulich echechis nabes ali chakli-popomech uli. Echudak chaklipapaluli elpech douk chenek moulamu chaklipech God ananin balan uli. ");
INSERT INTO apeB_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Ali chokubul ati yek yape yasolikech yenek putipatimu bawogenyumu balan umu gani bawagas enyen nyaitak nyanakumali. Namudak ali yek chopuk yakli wosik umu inyemu duldul enyudak balan kobi douk susubuati nyaitak nyanakimu ali inek salimumen nyunamogu nyak yopiyopinyali alman Tiofilas. ");
INSERT INTO apeB_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Yek yenek namudak umu nyak eke nyudukemen kalbu enyudak balan douk likuk chenek skulumenyu enyi, douk nyanubu adulin atin. ");
INSERT INTO apeB_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Ababuk nyultab Herot nape king umu provins Judia abali, ananu alman chohwalanamu Sekaraia uli chopuk nape. Anan douk ananu pris. Ali anan douk nanaki anudak lain pris douk chohwalam umu Abaisa uli. Ali ananik almatok douk chohwalok umu Ilisabet. Okwok chopuk douk kwaitak apudak Eron ananip awilop uli. ");
INSERT INTO apeB_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Ali God natulich umu, echudak biech douk chanubu chape duldul. Echech chanubu chagipechen cheyaten Diginali naklipech enyi balan nyanu lo seiwak nakaguk Moses enyi. ");
INSERT INTO apeB_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Ali echech douk batowich wakech. Umu moneken, Ilisabet kipik. Ali echech biech douk chanubu jugwahech. ");
INSERT INTO apeB_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","9","Aliga ali anah nyumnah douk Sekaraia nanu ananinu lain amam pris amamih nyumneh umu hunek moul numun God ananitu nebetali wilpat umu hatoglu. Ali amam henek enech echudak hagipech enyudak amamin pasin umu hudukemech umu eke meinali pris nulik nuwich nunek ofamu echudak nuku God. Ali ahabuk nyumnah, Sekaraia nenek win umu nuwich Diginali ananitu nebetali wilpat umu nuweh echudak chanubu cheih kalbalulimu nunek ofa nuku God. Amam henek namudak ali anan nawich numun Diginali ananitu nebetali wilpat. Ali Sekaraia neyotu numun nape noweh echudak nenek ofamech noku God ali God nape natulunu. ");
INSERT INTO apeB_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Ali ababuk nyultab nawich noweh echudak abali, chanatimaguk elpech chenek lotumu God uli chowachabal chape aduk chape chenek beten. ");
INSERT INTO apeB_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Ali enen Diginali ananin ensel nyatoglomanu ali natulin. Enyen nyonokwalmu nyeyotu aninyumu enyudak alta douk amam pris hape howemu echudak cheih kalbaluli henek ofamech hoku God ulimu. ");
INSERT INTO apeB_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Douk Sekaraia natulin ali anan loguh hwonechlukanu ali nanubu elgeinu. ");
INSERT INTO apeB_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Wakuli enyudak ensel nyaklipanu nyakli, “Sekaraia, nyak kobi elgeinyu. God douk anemnek nyakin beten ali nyakik almatok Ilisabet eke kulomenyali ananu nuganinu. Ali nyak imas nyubukumanu yeul Jon. ");
INSERT INTO apeB_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Ali nyakihw apahw eke hwulu kalbu ali eke nyunehilau nyulikuk. Wolobaichi elpech chopuk eke chunehilau ababuk nyultab okwok kunalali abali. ");
INSERT INTO apeB_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Ali agundak Diginali nutulunamu, anan eke nunubu nupe nebenali alman. Anan eke kobi nuwak wainibal abal blunu anabal dodogowibali, wak. Anan eke wata nulu apahw ali God ananin Michin eke nyuwichanu ali nyunubu nyupenyunu chukninu. ");
INSERT INTO apeB_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Anan eke wata nulawali wolobaichi elpech echech Isrel chutukemaguk enenyi enen yowenyi ali wata chutanamalimu God echechinu Diginali. ");
INSERT INTO apeB_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Anan eke dodogowinu atunu kobi douk profet Ilaiga umu. Ali chopuk, anan eke nulau Ilaija ananin pasin. Ali anan eke nulik ali Diginali eke nugikuk. Anan eke nublanu ahlim amamip ulkwip ali amam eke wata ulkwip punosuh amamich batowich. Ali eke nublanu chechegeik balan atin uli echechip ulkwip ali eke wata chulau yopichi elpech echechin tinytin. Ali anan eke nugakamu Diginali ananich elpech umu chukenyuk agabus yowenyi ali chunek redi chupe chutimu Diginalimu nunaki nugakomech umu.” ");
INSERT INTO apeB_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Ali Sekaraia naklipu enyudak ensel nakli, “Yek douk ajugwaiwe ali yekik almatok chopuk douk ajugwaik. Ali yek eke idukemech malmu ali dakio ikli enyudak balan douk adulin?” ");
INSERT INTO apeB_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Ali ensel wata nyaklipanu nyakli, “Yek Gabriel douk yeyotuwi God napemali. Anan douk nokoge yanamali inenyu wiyagwleh ali iklipenyu enyudak yopinyi balan. ");
INSERT INTO apeB_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Wakuli nyak douk wo nyunek bilip umu yekin balan e. Douk namudak ali nyakitu yokwatu eke tichuk tupe namudak ati. Nyak eke kobi nyiyagwleh ati aliga ahudak nyumnah God nakliah umu enyudak yek yaklipenyamen uli balan nyutoglu adulin ahi.” ");
INSERT INTO apeB_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Ali ababuk nyultab ensel nyape nyaklipanu balan abali, echudak almam almagou chape aduk uli chape chobeyogunmanu. Echech chakli moneken nyatoglomanu ali anan dakio nape loubomu gani numun wilpat. ");
INSERT INTO apeB_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Aliga douk natogloli ali nabilak umu nakli nunech niyagwleh wakuli nabilak wak. Douk namudak ali echech chadukemech chakli ati anan eke natik enech echudak gani numun God ananitu nebetali wilpat. Ali nakli nuklipech balan umu, anan noulumech lagul meyoh. ");
INSERT INTO apeB_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Aliga douk ananibu nyultab umu nenek moul pris numun wilpat umu batuh ali wata natanamamu ananigu awagu. ");
INSERT INTO apeB_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Anan nanak nape anabu nyultab banak badiyuk ali ananik almatok Ilisabet apahwik. Ali kwonobechuk kwape wilpat atutu umu 5-poleib aub. ");
INSERT INTO apeB_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Ali kwakli, “Aliga nameitu Diginali anagakame namudak. Anan nowaluweik ablan umu agundak elpech chatiwemu yape kipiwemu.” ");
INSERT INTO apeB_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Douk Ilisabet apahwik kwape aliga douk baklimu 6-poleib aub umu, God nakagas enen ensel yeulinyumu Gebriel uli nyanamu anabul wabul blape provins Galili uli. Abuldak wabul douk chohwalobul umu Nasaret. ");
INSERT INTO apeB_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Enyudak ensel nyalaumokwi balan onok almatok chohwalok umu Maria uli. Okwok douk wata kwunu ananu alman chupe atugu e, wak. Okwok douk chanukok umu ananu alman chohwalanamu Josep uli. Anan douk naitak king Devit ananip awilop uli. ");
INSERT INTO apeB_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Enyudak ensel nyanaki nyatoglomok ali nyaklipok nyakli, “Luwahep Maria, nyakin michin anyalu kalbu ali nyenehilau. Diginali nanenyu nape halakati ali nenekumenyu yopinyi.” ");
INSERT INTO apeB_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Ali Maria kwomnek enyudak balan ali okok kwanubu ulkum yowem. Okwok wo kwunubu kudukemu bawogenyumu enyudak balan ensel nyaklipokenyi e. ");
INSERT INTO apeB_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Ali ensel nyaklipok nyakli, “Maria, nyak kobi elgeinyu, wak. God douk ananehilaumenyu ali eke nunekumenyu yopinyi. ");
INSERT INTO apeB_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Mnek! Nyak alman douk wata nyusuh ananu e, wakuli nyak eke apahwinyu ali nyulali ananu nuganinu. Ali nyak imas nyubukumanyu yeul Jisas. ");
INSERT INTO apeB_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Ali anan eke nutoglu Nebenali alman. Ali eke chuhwalanu nanubu Nebenali God douk nabouk ihech elpech chanu enechi enech echudak chabihuk uli ananinu Nuganinu. Diginali God eke nunekanu nutoglu King kobi douk ananinu yamenu Devit umu. ");
INSERT INTO apeB_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Ali eheh nyumneh anan eke nupe nebenalimu Jekop ananich popech yamech. Anan eke nupe nebenalimu ananich elpech namudak ati eheh nyumneh.” ");
INSERT INTO apeB_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Ali Maria wata kwaklipu enyudak ensel kwakli, “Enyudak eke nyutoglu malmu? Yek wata isuhw ananu alman e.” ");
INSERT INTO apeB_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Ali ensel nyaklipok nyakli, “God Ananin Michin eke nyuwichenyu ali nanubu nebenali God ananin pawa eke nyichukolinyu. Douk namudak ali anudak nanubu yopuyopunali nuganinu kamanami nyunalali uli eke chuhwalanu God ananinu Nuganinu. ");
INSERT INTO apeB_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Mnek, okudak almatok Ilisabet douk kwanu nyak ipak atup awilop uli douk chakli kwape kipik. Okwok douk kwanubu jugwaik wakuli nameitu okwok douk apahwik. Ali nameitu douk 6-poleib aub badiyok. ");
INSERT INTO apeB_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Ali echech douk chanubu wak enech echudak douk God deke nubilak kobi nunekech uli e, wak.” ");
INSERT INTO apeB_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Ali Maria kwaklipen kwakli, “Yek yenemanu moul meyoh Diginali uli. Ali anan wasik nunekume enyudak nyutoglu kobi douk nyak nyaklimu.” Ali enyudak ensel nyatukemokuk nyanak. ");
INSERT INTO apeB_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Enyudak ensel nyanok nyeyagwlehuk umu julug, ali kwape aliga douk eneh nyumneh hanak hadiyuk, ali Maria kwanagabe echudak ali wisnabul kwaitak kwaltomu maudenab. Okwok kwanamu anabul wabul douk blape provins Judia uli. ");
INSERT INTO apeB_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Okwok kwanak kwataglu kwawich Sekaraia ananitu wilpat ali kwonemok gude Ilisabet. ");
INSERT INTO apeB_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Ali douk Ilisabet kwomnek umu agundak Maria kwonemok gudemu, ali batowin nyolu okwokihw apahw uli nyonogwanamu. Ali God ananin Michin nyanubu nyawich Ilisabet ali nyapenyuk chuknik. ");
INSERT INTO apeB_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Douk nyawichok ali nyokuhul kweyagwleh nebegali nigu kwakli, “Nyak nyechalakuk wanatimaguk almagou umu agundak God nenekumenyu yopinyimu. Ali chopuk, enyebuk batowin nyak nyinylali uli, God eke nunekumen yopinyi atin. ");
INSERT INTO apeB_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Ali enyudak douk nyatoglomemu agundak yekinu Diginali ananik mamakik kwanaki kwatimemu? Yek douk wo nebeweli almatok e. ");
INSERT INTO apeB_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Ali banubu abudak nyultab yek yemnek agundak nyak nyeneme gude abali, batowin nyolu yekihw apahw uli nyenehilau ali nyonogwanamu. ");
INSERT INTO apeB_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Nyak douk anyenek bilip umu Diginali ananin balan ali nyak douk anyenehilau. Diginali eke nuneken nyutoglu kobi douk likuk anan nakli-penyamaguk!” ");
INSERT INTO apeB_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Ali Maria kwakli, “Yek yanubu yenehilau ali yatuk Diginali ananin yeul nyakih. ");
INSERT INTO apeB_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Yekin michin douk nyenehilaumu God douk nogakome nalawe yatanamali yape kalbaluli. ");
INSERT INTO apeB_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Umu moneken, anan ulkum molome ananiwe yeul wakeli douk yasuh ananin moul uli. Nameitu aliga kwali, chunatimaguk elpech eke chukli yek douk God nagakome ali neneke yenehilau uli. ");
INSERT INTO apeB_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Echech eke chukli yenehilaumu enyudak nebenyi yopinyi moul douk Nanubu Nebenali God nenekenyume uli. Ali ananin yeul douk nyanubu duldulin ali yopiyopinyi. ");
INSERT INTO apeB_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Anan douk nanubu nenelek echebuk elpech douk chape chakamomu anan chagipech-analuli. Anan eke nunelekech aliga chugakuk ali echechich batowich chugikuk chitaki uli chopuk. Anan eke nunek namudak ati. ");
INSERT INTO apeB_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Ali anan dodogowinu nenek moul umu, anan isave nabo echebuk elpech douk chonohlagul ali echechip ulkwip polomu chunek yowenyi uli nahiyahech chalhwas chanak atin atiyuk. ");
INSERT INTO apeB_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Anan nechogeik amam king nam habihuk ali natuk yeguh wakechi elpech chalto. ");
INSERT INTO apeB_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Ali nekech wolobaichi yopichi echudak echebuk elpech douk chanohwagagun umu echudak uli. Ali elpech douk chatik wolobaichi echudak uli nakagech chanak wis wohis. ");
INSERT INTO apeB_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Ananim ulkum douk wata molomu enyudak adulin atinyi balan douk seiwak naklipaguk apakich yamech enyi. Ali nanakimu nugakamu ananich elpech echech Isrel douk chasuh ananin moul uli. ");
INSERT INTO apeB_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Ali anan ulkum molomu nunek yopinyimu Ebraham nunu ananich batowich uli popech yamech douk chugikuk chutogloluli ali nenelekech namudak ati eheh nyumneh.” ");
INSERT INTO apeB_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Ali Maria kwanu Ilisabet wape biob atunu aub batuh ali wata kwatanamu kwanamu wabul. ");
INSERT INTO apeB_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Ali nyultab umu Ilisabet kutas abali banak batogloli ali kwatas kwalali alman. ");
INSERT INTO apeB_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Ali okwokichi chanu echebuk douk chape halakati uli chemnek umu agundak Diginali nanubu nenekumok yopinyimu ali echech chopuk chanok chenehilau. ");
INSERT INTO apeB_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Ali douk aliga 8-poleih nyumneh hadiyanu anudak nuganinu, ali chanamali chutah ananihw yegenyihw. Ali echech chakli chubukumanu yeul Sekaraia douk ananinu aninu nonohwalamu. ");
INSERT INTO apeB_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Wakuli ananik mamakik kwakli, “Wak. Ananin yeul eke muhwalanu Jon.” ");
INSERT INTO apeB_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Ali echech chaklipok chakli, “Nya, ipak atup awilop umu douk wak ananu alman nunohwalu enyebuk yeul e.” ");
INSERT INTO apeB_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Ali echech choulumanu wis ananinu aninu chalikanamu chakli nuklipech umu meinyi yeul anan nakli chuhwalu nuganinamu. ");
INSERT INTO apeB_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Ali anan noulumech wis chohuli anatu slet ali nowemu enyudak balan nakli, “Ananin yeul douk Jon.” Ali echech chanatimaguk loguh hwonechlukech chape. ");
INSERT INTO apeB_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Ali banubu ababuk nyultab, Sekaraia ananitu yokwatu tanu yaham wata mukalech neyagwleh ali nape natuk God ananin yeul nyakih. ");
INSERT INTO apeB_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Ali chanatimaguk elpech chape halakatimu echech uli chanubu elgeich. Ali balan nyalahe nyeyatalub walub douk bletemu maudenab enyebuk provins Judia uli. Ali chanatimaguk chadukemech umu enyudak douk nyatoglamu Sekaraia nanu Ilisabet uli. ");
INSERT INTO apeB_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Ali chanatimaguk elpech douk chemnek umu enyudak uli chape ulkwip polomen ali chakli, “Anudak nuganinu nitak yopunamu, anan eke nutoglu manakanu alman?” Umu moneken, echech chadukemech umu Diginali nanonu nape halakati ali ananin pawa douk nyapenyunu. ");
INSERT INTO apeB_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Ali God ananin Michin nyawich Jon ananinu aninu Sekaraia nyapenynu chukninu ali neyagwleh God ananin balan kobi douk amam profet heyagwlehen umu. ");
INSERT INTO apeB_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Sekaraia nakli, “Apak mutuk Diginali apak Isrel apakinu God ananin yeul nyukih. Anan nanaki nagakamu apak ananipu elpech ali wata nanalawapu mape kalbu. ");
INSERT INTO apeB_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Anan natalihumapu ananu dodogowinu atunali alman umu nunolawapu mutanamali mupe kalbaluli. Anudak alman douk naitak Devit douk nasuh God ananin moul uli ananip awilop. ");
INSERT INTO apeB_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Kobi douk seiwak ananin Michin nyawich amam yopumi profet ali haklienyuk uli balan nyaklimu. ");
INSERT INTO apeB_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Anan nanubu nakli adul umu eke nugakamapu nunolawapu mutukemaguk apakich birua. Ali chopuk eke nugakamapamu nunolawapu mutukemaguk chanatimaguk elpech douk chakapaguk agabus uli. ");
INSERT INTO apeB_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Likuk naklipechuk ananin nyanubu adulin atinyi balan kontrak apakich popech yamech umu eke nugakomech. Ali anan douk wata ulkum molomu ananin kontrak douk likuk naklien umu nameitu eke nugipechen ali nugakamu apak umu. ");
INSERT INTO apeB_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Anan nalimu iluh naklipanu enen nyanubu adulin atinyi balan apakinu yamenu Ebraham. Ali nameitu douk nakli nunekenyumopu kobi likuk nakli eke nuneken-umapamu. ");
INSERT INTO apeB_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Anan nakli nugakamapu nunolawapu mutukemaguk apakich birua umu musuh ananin moul ali kobi elgeipu, wak. ");
INSERT INTO apeB_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Anan nagakamapamu nakli apak mupe apudak atap umu, apak munubu mupe ananipu atupu mupe duldul ali anan nupe nutulupu munek ananin moul. ");
INSERT INTO apeB_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Ali nyak yekinyu batowin, elpech eke chuhwalenyu Nanubu Nebebenu atunali God ananinyu profet. Nyak eke nyulik nyunak nyuklipu elpech umu chutukemaguk yowenyi chupe duldul ali chupe chutimu Diginali umu nunakimu. ");
INSERT INTO apeB_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Nyak eke nyuklipu apak ananipu elpech Isrel ali mudukemech umu anan eke nukwleik enenyi enen yowenyi apak moneken uli, ali wata nunolawapu mutanamali mupe kalbu. ");
INSERT INTO apeB_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Apakinu God eke nunek enyudak umu moneken, anan douk nanubu yopuyopunamu apak ali nenelekapu. Ali anan eke nuneki lait douk taglak kobi aun nakihumali gani iluh heven tubihi tuhwopu. ");
INSERT INTO apeB_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Atat eke tuglakumali echebuk elpech douk chape yomotokweh ali halakatimu chugak uli ali echech eke wata chunatulugun. Anan eke nugakamapu mugipech ahudak yopuhi yah umu mupe kalbu ali apaluh hlulu kalbamu.” ");
INSERT INTO apeB_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Ali douk aliga Jon naitak yopunu ali nanubu dodogowinamu agundak ananim ulkum manosuh God umu. Ali nanak nape wohigunmu elpech wak umu. Anan nape agnabuk aliga ahudak nyumnah natoglu yopugunmu ali echech Isrel chatulunu ali nape naklipech God ananin balan ahi. ");
INSERT INTO apeB_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Ali ababuk nyultab Maria apahwik abali, Sisa Ogastas nenek enen lo nyanamu blanatimaguk walub. Anan nakli chunatimaguk elpech chape ababuk nebebi amnab Rom echechib uli imas chunaki chulau echechiguh yeguh chuguhwemu bumeb. ");
INSERT INTO apeB_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Ababuk nyultab douk susubeibu nyultab umu chulau yeguh umu. Ali Sairinias douk nape nebenalimu gavman umu provins Siria. ");
INSERT INTO apeB_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Namudak ali chanatimaguk elpech chanamu echechilub nebelubi walub sulisuli atimu chuwemu echechiguh yeguh. Echech chanamu nebelubi walub douk seiwak echechich popech yamech chapenyulubi. ");
INSERT INTO apeB_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Ali ababuk nyultab, Josep nape wabul Nasaret douk blape provins Galili uli ali naitak nanamu Betlehem douk blape provins Judia uli. Ababul douk seiwak chalali King Devit abuli. Ali Josep douk nanamu Betlehem umu moneken, anan douk naitak apudak King Devit ananip awilop. ");
INSERT INTO apeB_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Anan nanu ananik chanukok-umanaluli almatok Maria chanak umu chuwemu echechich yeguh. Ali ababuk nyultab, Maria douk akapahwik. ");
INSERT INTO apeB_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Ali echech wata chape Betlehem ali nyultab batoglomu okwok kutas umu. ");
INSERT INTO apeB_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Ali okwok kwatas kwalali susubeinu nuganinu. Douk kwonolu ali kwechlehanu luseh kwonolu nolu anas bokis douk cholomech woligun kauhas chagnah umu. Umu moneken, wilpat elpech chechuhatali douk chuknitamu elpech ali wak anagun gnupeik meyoh umu echech chichuh umu e. ");
INSERT INTO apeB_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Ali ababuk wab anam heyoh sipsip uli halau amamich sipsip hatoglu aduk abuldak wabul ali hape heyohech. ");
INSERT INTO apeB_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Ali enen Diginali ananin ensel nyatoglomom ali Diginali nenek agnabuk amam heyotumu gnanubu gwol gnakusuk. Namudak ali amam hanubu elgeim. ");
INSERT INTO apeB_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Wakuli enyudak ensel nyaklipam nyakli, “Ipak kobi elgeipu, wak. Yek yanakumali iklipepu yopinyi balan douk eke nyunek ihech elpech chunubu chunehilau uli. ");
INSERT INTO apeB_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Ahudak nyumnah onok almatok kwalali ananu alman. Okwok kwonalali Devit ananibul wabul Betlehem. Anan douk Diginali alman Krais douk God natalihanu nakaganu nanamali nunolau elpech uli. ");
INSERT INTO apeB_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Ali ipak eke putulunu ali pudukemanu namudak. Ipak eke putik ananu nuganinu mamakik kwechlehanu luseh ali kwonolu nolu anas bokis douk cholomech woligun kauhas chagnahasi.” ");
INSERT INTO apeB_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","14","Douk enyudak ensel nyaklipam namudak wakuli ahudak atuh chanubu wolobaichi dodogowichi enselahas chapeli iluh heven uli chonokwalmu chanu enyudak ensel cheyotu. Ali chape chatuk God ananin yeul nyakih. Chakli, “Apak matuk God ananin yeul nyakih. Anan douk nape gani iluh heven uli. Ipak elpech pape atap uli douk isave penek God nenehilau-mepaluli ipakiluh apaluh hlulu kalbu ali punehilau.” ");
INSERT INTO apeB_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Douk enselahas chatukemaguk amudak hape heyoh sipsip uli chatanamu chaltomaguk iluh heven ali amam hanaklipamu hakli, “Apak munamu Betlehem umu mutik enyudak douk nyatogloluli. Enyudak douk Diginali naklipapamenyuk uli.” ");
INSERT INTO apeB_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Namudak ali wisnabul amam haitak hanak ali hogwatu Maria kwanu Josep ali hatik enyudak batowin chopuk nyalu bogis kauhas chawak woligun asi. ");
INSERT INTO apeB_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Douk amam hatulin julug ali haklipech balan douk enselahas chaklipomenyimu enyudak batowin uli. ");
INSERT INTO apeB_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Ali chanatimaguk elpech chemnek enyudak balan amam haklipechuk umu ali chakli, “O, malmu malmu namudak.” ");
INSERT INTO apeB_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Ali Maria wo ulkum mukokumaguk enyudak nyanatimaguk balan e. Okwok kwape kwonek tinyumen yet. ");
INSERT INTO apeB_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Ali amam hape heyoh sipsip uli wata hatanamu hanak. Ali amam henehilaumu God hape hatuk ananin yeul nyakih umu enyudak amam hatulin ali hemneken kobi douk enselahas chaklipomuk umu. ");
INSERT INTO apeB_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Ali douk Maria kwalali Jisas ali douk haklimu 8-poleih nyumneh umu, echech chatah ananihw yegenyihw ali chobukumanu yeul Jisas. Enyudak yeul douk Maria wata kwiyotumanu e ali ensel anyaklipokuk umu chinyubuk-umanaluli. ");
INSERT INTO apeB_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Ali Josep nanu Maria chape eneh nyumneh. Echech chape chagipech enyudak lo seiwak God nakaguk Moses enyi nyaklimu. Echech chenek namudak umu God nutulich ali nukli echech douk ayopich. Ali douk ehudak nyumneh hatuhuk ali Josep nanu Maria chalau Jisas chanamu Jerusalem umu chuku Diginalianu. ");
INSERT INTO apeB_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Echech chenek namudak kobi douk Diginali ananin lo nyaklimu. Lo nyakli, “Hunatimaguk susubeim nugamim mamaliyu umlali uli imas puku Diginaliam.” ");
INSERT INTO apeB_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Ali echech chopuk douk chanak umu chulau echudak umu chuku amam pris hunek ofamech huku Diginali kobi ananin lo nyaklimu. Lo douk nyakli namudak, “Elpech imas chulawali biech almiguh kobi douk nebebi machub umu o biech yanpoleichi almiguh kobi douk chokubi machub umu. Echech chulawechi ali chunek ofamech chicheh chuku yek.” ");
INSERT INTO apeB_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Ali ababuk nyultab, ananu alman douk chohwalanamu Simion uli nape Jerusalem. Anan nanubu duldulinali alman ali isave nenek lotumu God. Ali anan isave nape natulugunmu alman douk God natalihanu nakaganu nanamali nunolau echech Isrel chupe kalbaluli. Ali Simion, God ananin Michin douk nyawichanu ali nyapenyunu. ");
INSERT INTO apeB_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Ali enyen anyonohul nyaklipanamu anan eke kobi kebes nugak ali eke nutik anudak alman Krais. Anudak douk Diginali natalihanu nakaganu nanamali nunolau elpech uli. ");
INSERT INTO apeB_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Namudak ali God ananin Michin nyohul Simion ali nanak nawich numun banis God ananitu nebetali wilpat tatawomu. Ali mamechich chawali nuganinu Jisas umu chunekumanu enyudak douk God ananin lo nyaklimu echech imas chuneken-umanaluli. ");
INSERT INTO apeB_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","29","Ali Simion natulichanu nahwonu ananis wis ali natuk God ananin yeul nyakih nakli, “Diginyali, nyak nyagipech balan douk likuk nyakli adulin atin umu eke ipe aliga itulunamu. Ali nameitu nyak nyukli wasik ali yek yasuh nyakin moul uli yekih apahw hwulu kalbu ali igak. ");
INSERT INTO apeB_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Umu moneken, yek yanubu yatulunu yekis nabes anudak nyakinu alman douk nyatalihanu nanamali nunek enyudak moul umu nunolau elpech chupe kalbamu. ");
INSERT INTO apeB_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Anan douk neneken chanatimaguk elpech chapemu ali chatulin. ");
INSERT INTO apeB_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Ali anan douk kobi anatu lait umu nugilapech yah echebuk douk wo chudukemu God uli e umu chugipechah. Ali eke nunek nyakich elpech echech Isrel chulau nebenyi yeul.” ");
INSERT INTO apeB_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Ali Jisas ananich mamechich chemnek namudak ali chanasolikagas umu enyudak balan douk Simion naklien umu Jisas uli. ");
INSERT INTO apeB_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Ali Simion nasolik God umu nunek yopinyimu Jisas nunu ananich mamechich. Ali naklipu Maria nakli, “Mnek, God anatalih enyudak batowin umu nyunek wolobaichi elpech echech Isrel umu chutukemaguk God chupeik lougun. Ali chopuk, eke nyugakamu wolobaichi chutanamalimu God ali wata nunolawech chutanamali chupe kalbu. Anan eke nupe kobi douk ananu alman douk God nautunamu nunek ananin moul uli. Wakuli wolobaichi elpech eke chutulunu ali chiyagwleh-umanu enenyi enen yowenyi. ");
INSERT INTO apeB_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Anan eke nunek namudak umu nunek wolobaichi elpech echechin tinytin douk nyonobechuk nyape echechip ulkwip uli nyunowoleh nyutoglu yopugunmu. Ali nyak Maria, nyakim michin eke nyunubu yowen kobi douk chadukenyu anatu bainat tawich tobleli nyakim ulkum ali nyemnek nebehi nyih umu.” ");
INSERT INTO apeB_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Ali agnabuk onok almatok kwonek profet uli chopuk kwape. Okwokwin yeul Ana, ali okwokwinu aninu douk chohwalanamu Fanyuel. Echech douk apudak awilopich douk chohwalop umu Asa uli. Ali okwok douk kwanubu jugwaik. Okwok douk kwanu anan chanosupu chape 7-poleich yohwleguh meyoh. ");
INSERT INTO apeB_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Ali echech chapegu wakuli anan nagakuk ali okwok kwape meyoh umu, okwok kwape 84-poleich yohwleguh. Ali okwok wo kutukemataguk ati e God ananitu nebetali wilpat. Nyumnah wab kwapemu kwonek lotumu God kwonek beten atin. Enebik umu, okwok kwonek tambumu kakwich ali kwapemu kwonek beten atin. ");
INSERT INTO apeB_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Ali banubu ababuk nyultab, okwok chopuk kwanaki halakati ali kwonek tenkyumu God. Ali kwape kwaklipech balan umu anudak nuganinu Jisas chanatimaguk elpech douk chape chobeyagunmu God wata nunaki nukwechih elpech chape Jerusalem uli douk chape chakamomu kipaichi uli chutoglu fri umu. ");
INSERT INTO apeB_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Ali douk Josep uli Maria cheneken cheyaten enyudak moul kobi douk Diginali ananin lo nyaklimu chuneken uli, ali echech wata chatanamu chanamu provins Galili. Echech chanamu echechibul wabul Nasaret. ");
INSERT INTO apeB_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Ali nuganinu yopunu naitak dodogowinu ali nalau wolobainyi yopinyi save. Ali God nenekumanu yopinyi nanubu nape kalbu. ");
INSERT INTO apeB_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Ali ihech yohwleguh Jisas ananich mamechich isave chanamu Jerusalem umu agundak Pasovaigun woligun. ");
INSERT INTO apeB_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Ali douk aliga Jisas ananich yohwleguh chanak chatoglu 12-poleich ali echech chanamu Jereusalem umu agundak Pasovaigun woligun kobi douk seiwak chape chagimeh umu. ");
INSERT INTO apeB_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Ali douk aliga nyumneh chenek agundak woligun umu hatuh ali echech wata chatanamomu wabul. Douk echech chanak, wakuli nuganinu Jisas napeik Jerusalem. Ananich mamechich chopuk wo chudukemech umu agundak anan napemaguk e. ");
INSERT INTO apeB_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Echech chakli anan eke nanu echudak enech elpech chanak. Namudak ali echech chanak anah nyumnah chuknih ali echech wata chape chaulimanu. Echech chasolik bawogeich chanu echebuk douk chape atugunmaluli. ");
INSERT INTO apeB_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Douk chabilak wak chugwatanu e ali wata chatanamu chanamu Jerusalem umu chulimanu agnabuk. ");
INSERT INTO apeB_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Echech chape chaulimanu aliga haklimu 3-poleih nyumneh umu, echech chanak chogwatanu nape numun banis God ananitu nebetali wilpat tatawomu. Anan nanu henek skulumech umu lo uli hape ali nape nemnek amamin balan ali nasolikam umu huklipanamu nudukemech. ");
INSERT INTO apeB_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Ali amam hanatimaguk hemnekanu ali loguh hwonechlukam umu ananin save nyanu balan anan nebeyenyumom uli. Ali amam hakli anan douk nanubu nadukemech uli. ");
INSERT INTO apeB_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Ali ababuk nyultab ananich mamechich chogwatanu abali, echech chanubu loguh hwonechlukech. Ali ananik mamakik kwaklipanu kwakli, “Nuganinu, nyak nyagimeh-umohwomu namudak? Nyakinu aninu nanu yek wanubu michich yowech umu nyak ali wape waulimenyu.” ");
INSERT INTO apeB_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Ali Jisas nebemech balan nakli, “Ipak pape paulimemu moneken? Ipak eke padukemech waka wak? Yek imas ipe yekinu Aninu ananitu wilpat.” ");
INSERT INTO apeB_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Wakuli echech wo chudukemu bawogen umu balan anan naklipech enyi e, wak. ");
INSERT INTO apeB_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Ali anan wata nanamech chatanamu chanamu Nasaret. Ali eheh nyumneh anan nemnek echechin balan ali nenek enechi enech echech chaklipanamu nunekech uli. Ali ananik mamakik kwonenylu nyolomok boglom enyudak nyanatimaguk balan douk anan neyagwlehen uli. ");
INSERT INTO apeB_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Ali Jisas yopunu naitak umu yegenyihw ali chopuk naitak nadukemu enenyi enen yopinyi pasin nyanu save. Ali God nanu elpech chanubu chenehilau-manu. ");
INSERT INTO apeB_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Ababuk nyultab Taibirias Sisa nape nebenalimu gavman umu Rom umu 15-poleich yohwleguh abali, Pontias Pailat nape nebenalimu gavman umu provins Judia. Ali Herot nape nebenalimu provins Galili, ali ananinu owaninu Filip nape nebenalimu bien provins, Ituria uli Trakonaitas. Ali Laisenias nape nebenalimu provins Abilini. ");
INSERT INTO apeB_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Ali Anas nanu Kaiafas hape hanubu nebemi pris. Ali douk banubu ababuk nyultab, Sekaraia ananinu nuganinu Jon nanak nape wohigunmu elpech wak umu ali God nakanu ananin balan. ");
INSERT INTO apeB_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Namudak ali Jon nalahe neyatalub walub blape halakatimu abudak wolub Jodan uli. Ali anan nape naklipech umu chukenyuk agabus yowenyi chutanamu chukanu apaluh God ali chunek baptais. Ali God eke kobi nunohwen umu echechin yowenyi ali nukwleyenyuk. ");
INSERT INTO apeB_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Enyudak douk nyatoglu nyagipech enen balan seiwak profet Aisaia nenyemaguk God ananik buk uli nyaklimu. Balan nyakli, “Enen elpen nyape nyohwalu gani wohigunmu elpech wak umu nyakli, ‘Gabemanu yah Diginali. Pugabeyah hupe duldul umu anan nugimah nunakimu. ");
INSERT INTO apeB_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Bobigas umu gnunechul gnuneyatak. Ali mauntenab bunu chokugwi nusug imas gnunalak gnubih alagun ati. Henek iwedagwemu yegwih imas hupe duldul. Ali agnabuk douk gnalto gnagluk umu imas gnunalak alagun ati. ");
INSERT INTO apeB_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Ali chunatimaguk elpech eke chutik enyudak moul douk God neneken umu nanalawapu matanamali mape kalbamu.’” ");
INSERT INTO apeB_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Ali wolobaibi lainab elpech chanamali Jon umu nunek baptaisumech. Echech chanaki ali anan naklipech nakli, “Ipak pape kobi wanohwiguhwi iguhw umu. Omuni nyaklipepamu deke pulhwasumaguk agundak douk eke God nyihihichi-namepamu douk eke gnutoglome-paluli? ");
INSERT INTO apeB_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Ipak imas punek yopinyi pasin umu pugilapu elpech chutulipu ali chukli adul ipak apekenyuk agabus yowenyi. Ali kobi pupe puneyagwleh pukli Ebraham anan douk ipakinu yamenu ali God eke nutulipu nukli wasik, wak. Yek yaklipepu, God deke nunek abaludak utabal blakus atap uli blutoglu Ebraham ananich batowich. ");
INSERT INTO apeB_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Alman nublo lowas uli douk anasuh tameyok nape nenek redimu nutakiagasi gani atap nubaluhigas umu. Ali ihagas lowas douk yopipi chulkwip wo pil agasi e eke nublowagas nuwachagas nyih.” ");
INSERT INTO apeB_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Ali chanatimaguk elpech chasolikanu chakli, “Ali apak eke munek malmu?” ");
INSERT INTO apeB_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Ali anan wata nebemech balan nakli, “Anabuk alman douk nanabuk biog siyatog uli imas nukanu anatu anabuk douk siat wakanali. Ali echebuk elpech chatik kakwich uli imas chiyaisech chubilamu echebuk kakwich wakechi.” ");
INSERT INTO apeB_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Ali amam halau takis uli chopuk hanamali nunek baptaisumom. Ali hanaki hasolik Jon hakli, “Nebenyali tisa, apak eke munek moneken?” ");
INSERT INTO apeB_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Ali anan naklipam nakli, “Pulau takis umu, ipak imas putulichabal duldul utabal kobi douk gavman chaklimu. Ipak kobi punatulich anabal meyoh, wak.” ");
INSERT INTO apeB_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Ali amam soldia chopuk hanaki ali hasolikanu hakli, “Apak chopuk eke munek moneken?” Ali anan naklipam nakli, “Kobi puhwech dudigu enech elpech punatulich utabal o punekumech enen meyaluhin balan enech elpech umu punatulich anabal utabal meyoh, wak. Punosuh abalabuk douk chukepamu moul umu atubal ali pukli julugibal-umepu.” ");
INSERT INTO apeB_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Ali elpech echechich michich bul chanakuk ali chape chenek tinytin umu Jon. Echech chakli anan ati eke Krais douk God natalihanu nakaganu nanamali nunalau elpech uli. ");
INSERT INTO apeB_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Douk namudak ali Jon naklipu chanatimaguk elpech nakli, “Yek wak. Yek douk yenek baptaisumepu abal meyoh. Wakuli ananu nanubu dodogowinu atunu nechalakuk yek uli eke nugiki. Ali yek douk wo yopuwelimu ikwekchih-umanu nadululuh ananinu su e, wak. Ali anan eke nunek baptaisumepu nukepu God ananin Michin ali eke nyuwich nyupenyipu. Ali enyen eke nyugabeyepu kobi nyih hanuwuk echudak umu. ");
INSERT INTO apeB_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Anan eke nunaki kobi ananu alman nasuhwi ananil savol ananis wis umu nunaki niyamaguk tanatimaguk aliguhitamu wit douk talamu ouguhitaluli. Ali ouguhitamu eke nunatalmatu nutabuk wilpat douk nape nobuk wit atali. Ali aliguhwitamu eke nutoweh nyih douk hanu hape namudak ali wo hugak atili e.” ");
INSERT INTO apeB_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Ali Jon naklipech God ananin yopinyi balan abali, anan naklipech wolobainyi enyudakmali balan chopuk umu nyuhul echechiluh apaluh. ");
INSERT INTO apeB_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Wakuli Jon nahu Herot douk nebenalimu gavman umu Galili uli. Anan nahanamu agundak nanatulunu ananinu owaninu ananik almatok Herodias umu. Ali chopuk umu agundak nenek wolobainyi yowenyimu. ");
INSERT INTO apeB_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Ali Herot wata chopuk nenek enen nyanubu yowenyimu nenek kalabus umu Jon umu. ");
INSERT INTO apeB_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Douk chanatimaguk elpech chenek baptais chatuh ali Jisas chopuk nenek baptais. Anan nenek baptais julug ali neyotu nape nenek beten ali iluh utagu genek op. ");
INSERT INTO apeB_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Ali God ananin Michin nyagluki kobi enyudak almin manyun umu nyabihi nyetemu Jisas. Ali chemnek anagu nigu gani iluh heven ali enyudak elpen nyeyagwlehi uli nyakli, “Nyak douk nyanubu yekinyu Nuganinu. Yek douk ulkum manohwenyu ali yanubu yenehilau-menyu.” ");
INSERT INTO apeB_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Abudak nyultab Jisas nahul ananin moul nape neneken abali, ananich yohwleguh douk chatoglu 30-poleich. Ali elpech chakli Jisas anan ati eke Josep nanalali uli nuganinu. Wakuli wak. Josep ananinu aninu douk Hilai. ");
INSERT INTO apeB_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Ali Hilai ananinu aninu Matat. Matat ananinu aninu Livai. Livai ananinu aninu Melkai. Melkai ananinu aninu Janai. Janai ananinu aninu Josep. ");
INSERT INTO apeB_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Ali Josep ananinu aninu Matataias. Matataias ananinu aninu Emos. Emos ananinu aninu Neam. Neam ananinu aninu Eslai. Eslai ananinu aninu Nagai. ");
INSERT INTO apeB_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Ali Nagai ananinu aninu Meat. Meat ananinu aninu Matataias. Matataias ananinu aninu Semen. Semen ananinu aninu Josek. Josek ananinu aninu Joda. ");
INSERT INTO apeB_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Ali Joda ananinu aninu Joanan. Joanan ananinu aninu Resa. Resa ananinu aninu Serababel. Serababel ananinu aninu Sialtiel. Sialtiel ananinu aninu Nerai. ");
INSERT INTO apeB_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Ali Nerai ananinu aninu Melkai. Melkai ananinu aninu Edai. Edai ananinu aninu Kosam. Kosam ananinu aninu Elmadam. Elmadam ananinu aninu Er. ");
INSERT INTO apeB_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Ali Er ananinu aninu Josua. Josua ananinu aninu Eliesa. Eliesa ananinu aninu Jorim. Jorim ananinu aninu Matat. Matat ananinu aninu Livai. ");
INSERT INTO apeB_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Ali Livai ananinu aninu Simion. Simion ananinu aninu Juda. Juda ananinu aninu Josep. Josep ananinu aninu Jonam. Jonam ananinu aninu Elaiakim. ");
INSERT INTO apeB_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Ali Elaiakim ananinu aninu Melia. Melia ananinu aninu Mena. Mena ananinu aninu Matata. Matata ananinu aninu Netan. Netan ananinu aninu Devit ");
INSERT INTO apeB_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Ali Devit ananinu aninu Jesi. Jesi ananinu aninu Obet. Obet ananinu aninu Boas. Boas ananinu aninu Salmon. Salmon ananinu aninu Nason. ");
INSERT INTO apeB_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Ali Nason ananinu aninu Aminadap. Aminadap ananinu aninu Atmin. Atmin ananinu aninu Anai. Anai ananinu aninu Hesron. Hesron ananinu aninu Peres. Peres ananinu aninu Juda. ");
INSERT INTO apeB_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Ali Juda ananinu aninu Jekop. Jekop ananinu aninu Aisak. Aisak ananinu aninu Ebraham. Ebraham ananinu aninu Tira. Tira ananinu aninu Neho. ");
INSERT INTO apeB_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Ali Neho ananinu aninu Serak. Serak ananinu aninu Reu. Reu ananinu aninu Pelek. Pelek ananinu aninu Ebe. Ebe ananinu aninu Sela. ");
INSERT INTO apeB_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Ali Sela ananinu aninu Kenan. Kenan ananinu aninu Apaksat. Apaksat ananinu aninu Siem. Siem ananinu aninu Noa. Noa ananinu aninu Lamek. ");
INSERT INTO apeB_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Ali Lamek ananinu aninu Metusela. Metusela ananinu aninu Inok. Inok ananinu aninu Jaret. Jaret ananinu aninu Mahalalel. Mahalalel ananinu aninu Kenan. ");
INSERT INTO apeB_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Ali Kenan ananinu aninu Inos. Inos ananinu aninu Set. Set ananinu aninu Adam. Ali Adam douk God nenekanu. ");
INSERT INTO apeB_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Ali God ananin Michin nyanubu nyawich Jisas nyapenyunu chukninu ali nagipech enyenyin laik natukemaguk wolub Jodan nanak. Ali God ananin Michin nyalawanu nanamu wohigunmu douk elpech wak umu. ");
INSERT INTO apeB_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Anan nanak nape agnabuk ananu aun chukninu 10-poleih nyumneh alagun ali Satan nape nechakamanamu nunek yowenyi. Ali ehebuk nyumneh nanak napemu, anan wo nuwak enech echudak e. Ali douk aliga ehudak nyumneh haklimu hutuh ali takweilubi nyulub blanu. ");
INSERT INTO apeB_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Ali Satan naklipanu nakli, “Sapos nyak douk God ananinu Nuganinamu, nyak klipu amudak utam mutoglu bret.” ");
INSERT INTO apeB_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Ali Jisas naklipanu nakli, “Balan nyetemu God ananik buk uli douk nyakli, ‘Kakwich atich eke kobi chugakamu elpech umu chupe kalbu, wak.’” ");
INSERT INTO apeB_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Ali Satan wata nalau Jisas naltomu anagun gnetemomu ali ahudak atuh nagilapanu nyanatimaguk kantri nyape apudak atap uli. ");
INSERT INTO apeB_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Ali Satan naklipanu nakli, “Yek eke ikenyu enyudak nyunatimaguk kantri nyunu enechi enech yopichi echudak chunu elpech chape enyudak kantri uli. Ali nyak eke nyulau namba umu nyak atinyu nyunek bosumu chunatimaguk enechi enech echudak chunu elpech chape nyanatimaguk enyudak kantri uli. Chanatimaguk echudak echech douk aseiwak yanalawech yenek bosumech. Ali nameitu yek ikli iku enen elpen umu, yek eke iken. ");
INSERT INTO apeB_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Ali sapos nameitu nyak nyuduk ohlubus nyunek lotumemu, yek eke ikenyu chunatimaguk echudak.” ");
INSERT INTO apeB_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Wakuli Jisas wata naklipanu nakli, “Balan nyetemu God ananik buk uli douk nyakli namudak, ‘Nyak nyunek lotumu Diginali nyakinu God ali nyusuh ananin atin moul.’” ");
INSERT INTO apeB_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Ali Satan wata nalawanamu Jerusalem. Ali nakih nonowemu onok kwanubu kwakihuk uli outuk atudak God ananitu nebetali wilpat ali naklipanu nakli, “Sapos nyak douk God ananinu nuganinamu, nyak nyunatablig nyugluk atap. ");
INSERT INTO apeB_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Umu monken, balan nyetemu God ananik buk uli douk nyakli, ‘God eke nuklipech dodogowinyi balan ananich enselahas umu chunaki chugakomenyu. ");
INSERT INTO apeB_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Ali echech eke chuhwenyaguk iluh echechis wis ali eke kobi anam utam muwolinyu nyakiluh yaliluh, wak.’” ");
INSERT INTO apeB_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Wakuli Jisas naklipanu nakli, “Balan nyetemu God ananik buk uli nyakli, ‘Nyak kobi nyichakamu Diginali, nyakinu God.’” ");
INSERT INTO apeB_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Douk Satan nechakamu Jisas umu hanatimaguk yegwih umu nunek yowenyimu julug ali natukemanaguk nanak. Anan nakli kipaibali nyultab anan adakio wata nichakamanu. ");
INSERT INTO apeB_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Ali God ananin Michin nyape Jisas nyenekanu dodogwinu ali anan wata natanamu nanamu provins Galili. Ali balan nyoweyeh nyanak gnanatimaguk enyudak provins umu enyudak Jisas neneken uli. ");
INSERT INTO apeB_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Ali anan nenek skulumech numun echech Juda chape cheyagwleh balan ogwi wilag ali chanatimaguk chatuk ananin yeul nyakih. ");
INSERT INTO apeB_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Ali Jisas nanamu abuldak wabul Nasaret douk anan wata chokunu napenyubul aliga yopunamu. Ali ahudak nyumnah Sabat echech Juda moul wak chape meyoh ahi hatoglu. Ali anan naitak nanak nawich echech Juda chape cheyagwleh balan atali wilpat kobi douk eheh nyumneh Sabat nape nanak umu. Ali anan naitak neyotumu nutalih God ananin balan. ");
INSERT INTO apeB_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","18","Ali amam hakanu onok buk douk chadalechok ali chowechikok uli. Okwok douk profet Aisaia nenemeyok uli. Ali anan nejikok ali nogwatu enen balan nyakli namudak uli nyakli, “Diginali ananin Michin nyawiche ali nyapenyuwe. Umu moneken, anan natalihemu iklipech ananin yopinyi balan elpech douk chanubu chanahwagagun umu echudak uli. Ali douk nokoge yanamali iklipech enyudak balan, ‘Ipak douk birua chowechikepu pape kalabus uli wata putoglu pupe fri. Ipak nabes sechukepali wata punatulugun. Ali iklipech umu echebuk elpech douk kipaichi chekech hevi uli wata chupe hwalhwal chunehilau. ");
INSERT INTO apeB_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Ali chopuk, nekege yanamali iklipech balan umu abudak yopubali nyultab douk Diginali eke wata nugakamu ananich elpech chupe kalbamu.’” ");
INSERT INTO apeB_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Ali Jisas natalih enyudak balan umu julug ali wata nowechik buk nakaguk anudak nenek lukautumu lotu uli. Ali anan wata nanak nabih nape. Ali echech chanatimaguk chape numun wilpat uli chatanamu nabes sataku sape anan atunu. ");
INSERT INTO apeB_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Ali anan naklipech nakli, “Doumeih enyudak God ananin balan nyetemu ananik buk uli douk adukwechuk pemneke yatalihen uli nyatoglu adulin atin.” ");
INSERT INTO apeB_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Ali chanatimaguk chenehilau chatuk ananin yeul. Ali echech chape ulkwip polu panak umu enyudak yopinyi balan anan nakliyenyi. Wakuli echech chakli, “Malmu malmu namudak. Ati anudak alman anan douk wo Josep ananinu nuganinu e?” ");
INSERT INTO apeB_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Ali Jisas naklipech nakli, “Aduligu atugu. Ipak eke puklipe enyudak chadukemech uli chaklipeyen uli balan pukli, ‘Dokta, nyak nyunagabe nyak yet. Enyudak douk chaklipapamu nyeneken nyatoglu Kapaneam uli chopuk makli nyuneken nyutoglu agundak nyakibul wabul.’” ");
INSERT INTO apeB_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Ali Jisas balan nyeilen nakli, “Aduligu atugu yek yaklipepu. Eke kobi ananu profet nuklipech balan ananibul wabul ali chumnek ananin balan chuhwen chugipechen, wak. ");
INSERT INTO apeB_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Aduligu atugu yek yaklipepu. Seiwak ababuk nyultab Ilaija nape profet abali, wolobaiwali almagou douk almam hagak howobukuk uli wape Isrel. Ali ababuk nyultab echah wak anah hulali e umu 3-poleich yohwleguh ali 6-poleib aub alagun. Ali nebehi nyulbiah hach blanatmaguk walub. ");
INSERT INTO apeB_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Wakuli God wak nunek salimumu Ilaija nunak nugakamu onok oudak Isrel douk amam hagak howobukuk uli e, wak. God douk nenek salimumanu nanak nagakamu onok almatok douk anan nagak nokubukuk uli douk kwape kipaibuli wabul chohwalabul umu Sarefat uli otuk. Abuldak wabul Sarefat douk blape provins Saidon. ");
INSERT INTO apeB_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Ali douk namudak ati. Ababuk nyultab profet Ilaisa nape apudak atap abali, wolobaimi almam sik lepra gapenyum uli hape Isrel. Ali Ilaisa wo nugakamu ananu umu yopunu e, wak. Wakuli anan nagakamu Neman atunu. Neman douk kipaibi amnabinu chohwalab umu Siria uli.” ");
INSERT INTO apeB_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Ali chanatimaguk elpech chape numun wilpat uli chemnek enyudak balan ali chanubu nyihihichich umu Jisas. ");
INSERT INTO apeB_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Ali echech chaitak chahwanu chalawonu chatoglu aduk abuldak wabul. Abuldak echechibul wabul douk bletemu iluh anatu nukut. Namudak ali chalawonu chanak algasibulmu natagul nyapemu umu chakli chuwachanu nugluk umu nugak. ");
INSERT INTO apeB_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Wakuli echech cheyotu ali anan nawichech nanak olokohun ali nanak. ");
INSERT INTO apeB_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Ali Jisas nanamu wabul Kapaneam douk blape provins Galili uli. Anan nanak natoglu ali ahudak nyumnah Sabat echech Juda moul wak, chape meyoh ahi hatoglu. Ali anan nape nenek skulumech umu God ananin balan. ");
INSERT INTO apeB_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Ali echech chanatimaguk chemnekanu ali loguh hwonechlukech. Umu moneken, anan douk neyagwleh dodogowinu atunu kobi douk chalau nebenyi namba uli cheyagwleh umu. ");
INSERT INTO apeB_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","34","Ali numun echech Juda chape cheyagwleh balan atali wilpat, ananu enen sagabu nyapenyunali alman nape. Ali anan naitak nohwalu nanakliyati nakli, “A! Jisas douk nyanaki wabul Nasaret uli, nyak nyanamali nyunekapu malmu apak? Nyak nyakli nyopu nyichagiyapu, waka? Yek douk yadukemenyu nyak. Nyak douk God ananinyu yopiyopinali alman nyalawali ananin balan uli.” ");
INSERT INTO apeB_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Wakuli Jisas nahu enyudak sagabu nakli, “Nubu sak ali nyunubu nyutukemaguk anabuk alman nyutogloli.” Ali enyen nyoul anudak alman nabih nakus atap agundak chapemu ali nyatukemanaguk. Ali enyen wo nyunekanaguk eneb eleb e. ");
INSERT INTO apeB_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Ali douk chanatimaguk chatik namudak ali loguh hwonechlukech. Ali echech cheneyagwleh chakli, “Enyudak moneken balan? Anudak alman douk kobi ananu dodogowinali nalau nebenyi namba ulimu. Anan douk nanalak umu sagabehas chemnek ananin balan ali chatukemaguk elpech chatoglu chalhwas!” ");
INSERT INTO apeB_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Namudak ali balan umu enyudak Jisas neneken uli nyoweyeh nyanak blanatimaguk walub douk blape halakatimu Kapaneam uli. ");
INSERT INTO apeB_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Ali Jisas natukemaguk atudak echech Juda chape cheyagwleh balan atali wilpat nanamu Saimon ananitu wilpat. Ali Saimon ananik nakwlik kwanubu kwagabal kluk kluk kwechuk alas. Douk Jisas nanak ali echech chaklipanamu nunak nugabeyok. ");
INSERT INTO apeB_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Ali anan nanak neyotu halakati agundak okwok kwechuh umu ali nahu agudak sig genekok uli. Ali okwok kwanubu yopuk ali kwaitak kwape kwonekumech kakwich. ");
INSERT INTO apeB_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Ali ababuk nyultab aun nape nabih abali, anagali anagu agudak gach uli elpech echechich bawogeich chalawechumali Jisas umu nugabeyech. Ali anan nowemeyech ananis wis echech atin ati ali chanatimaguk yopich uli atich. ");
INSERT INTO apeB_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Sagabehas chopuk chatukemaguk wolobaichi elpech. Ali echudak sagabehas chopuk chohwalaguk nebegun chakli, “Nyak douk God ananinyu nuganinu.” Wakli Jisas nahech ali naklipech umu kobi chiyagwleh enen balan, wak. Umu moneken, echech douk chadukemech chakli anan douk Krais, douk God natalihanu nakaganu nanamali nunolau elpech uli. ");
INSERT INTO apeB_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Aliga wehluwih aglupil atul ali Jisas naitak natukemaguk Kapaneam nanamu anagun wohigunmu elpech wak umu. Ali echech almam almagou achape chaulimanu. Ali douk aliga chanak chogwatanu ali chakli chusuhw-echanamu anan kobi nutukemechuk nunak. ");
INSERT INTO apeB_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Wakuli anan naklipech nakli, “Yek imas inak kipailubi walub chopuk ali iklipech yopinyi balan umu agundak God nape nebenalimu ananich elpech umu. Umu moneken, God douk nokoge yanamali inak iklipu kipaichi chopuk.” ");
INSERT INTO apeB_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Ali anan nanak nape naklipech God ananin yopinyi balan ihalub walub enyudak provins Judia. Anan nape naklipech God ananin yopinyi balan numun wilag echech Juda chape cheyagwleh balan ogwi. ");
INSERT INTO apeB_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Anah nyumnah Jisas nanak neyotu buknap enyudak nebenyi raunwara Genesaret ali nape naklipech God ananin balan. Ali wolobaichi elpech chape chenek chalabukuk chanaki halakatimu anan umu chumnek balan anan nape naklipech enyi. ");
INSERT INTO apeB_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Ali agnabuk, anan natik amudak hape hatuk yeguh uli amamig biog botog gwakus. Amam hasanukog hakih hogubukuk buknap ali hanak hape hakwlupu umbenab. ");
INSERT INTO apeB_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Ali Jisas nalto nakih netemu Saimon ananitu bot. Ali naklipanu nechasatu tanak tolu abal ali nape nenek skulumech God ananin balan echech almam almagou. ");
INSERT INTO apeB_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Douk naklipech balan julug ali naklipu Saimon nakli, “Nyak nyulau bot tunak olokohunin umu raunwara ali ipak putu ipakib umbenab ali putuk onoguhw yeguh.” ");
INSERT INTO apeB_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Ali Saimon naklipanu nakli, “Nebenyali, kwiganikib wab chuknib apak monek nebenyi moul umu mautu umbenab wakuli apak wo kwalowiomi mutuk anap atup yelbup e. Wakuli douk nyak nyakli ali yek eke iyutu umbenab.” ");
INSERT INTO apeB_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Ali amam hanak hautu umbenab ali hatuk wolobaiguhwi yeguh ali amamib umbenab halakatimu tutukalab ati. ");
INSERT INTO apeB_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Ali amabuk douk hanu Pita hape ananitu bot uli hatik namudak ali howaulmu kipaimi amam hanam henechle-paluli douk hape kipaitali bot ulimu hunaki hugakamom. Ali amam hanaki hagakamom hatukoguh hoguhlu amamig biog botog chichuknig ali halakatimu gwuglukuk ati. ");
INSERT INTO apeB_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","10","Ali Saimon douk kipainyi yeul nonohwalu Pita uli nanu Jems uli Jon hanu amudak anam Saimon ananim umu, hatik oguhudak wolobaiguhwi yeguh amam hatukoguh uli ali amam hanubu loguh hwonechlukam ali elgeim. Ali Saimon natik namudak ali nabih noduk ohlubus halakatimu Jisas ali naklipanu nakli, “Diginyali, nyak nyutukemeik ali nyunak! Umu moneken, yek yenek enenyi enen yowenyi uli!” Wakuli Jisas naklipanu nakli, “Saimon, nyak kobi elgeinyu. Umu moneken, douk nameitu aliga kwali, nyak eke nyupe nyulau elpech chunaki chugipech yek.” ");
INSERT INTO apeB_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Ali amam hanubu hasanuk amamig botog hakih hogubukuk buknap, hatukemaguk chanatimaguk amamich echudak ali hanu Jisas hanak. ");
INSERT INTO apeB_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Anah nyumnah Jisas nanak nape anabul wabul ali ananu sik lepra gapenyunali nanaki natoglomonu. Ananihw yegenyihw douk hwanubu chuknihw umu eleb. Ali anan nanak nabih nogwohebil nakus atap ali nasolik Jisas nakli, “Diginyali, nyak nyukli wasik umu, yek yakli nyak nyugabeye.” ");
INSERT INTO apeB_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Ali Jisas nonu logul nowemu ananis wis anudak alman ali nakli, “Yek yakli wosik. Nyak nyunubu yopinyu.” Ali ahudak atuh anan nanubu yopunu. ");
INSERT INTO apeB_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Ali Jisas naklipanu dodogowinyi balan nakli, “Nyak nyunak ali kobi nyuklipu enech elpech umu agundak yek yagabeyenyamu, wak. Nyak nyunubu nyunamu pris nutulinyu ali nyunak nyunek enyebuk ofamu agundak nyak ayopinyomu kobi douk God ananin lo douk nakaguk Moses enyi nyaklimu. Nyak nyunek namudak ali chunatimaguk elpech eke chutulinyu ali chudukemech chukli nyak douk ayopinyu.” ");
INSERT INTO apeB_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Wakuli wak, enyudak balan umu agundak Jisas nagabe anudak sig lepra gapenyunalimu nyoweyeh nyanak lougun. Ali wolobaichi elpech chanakimu chumnek Jisas ananin balan. Ali chopuk umu nugabemech echechigu sig douk gapenyich uli. ");
INSERT INTO apeB_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Wakuli wihluwehlu anan isave naitak nanak agnabuk elpech wak umu ali nanak nape nenek beten. ");
INSERT INTO apeB_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Anah nyumnah Jisas nanak nape nenek skulumech umu God ananin balan. Ali agnabuk, anam Farisi hanu anam henek skulumech umu lo uli chopuk hanech hape. Amam douk hanaki sulisuli ilub walub uli. Anam hanaki Jerusalem uli, ali anam hanaki blanatimaguk walub blape enyudak provins Galili uli, ali anam hanaki blanatimaguk walub douk blape Judia uli. Ali ababuk nyultab God nanu Jisas napemu nunek Jisas dodogowinamu nugabe agasudak sachi elpech. ");
INSERT INTO apeB_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Ali anam almam hasahi ananu loguh aias chagakanali hanaki. Anan nechuh ananis alas ali amam hanasahumali alas hanakimu hakli hunak huwich hunabuk agnabuk Jisas napemu. ");
INSERT INTO apeB_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Wakuli wolobaichi elpech chape ali amam yah wak umu hichalakech huwich umu. Ali amam hanasah halto hakih modupitamu wilpat ali hanikuk enech echudak chetemu modupita-maluli hechebukuk ali anan nalamu alas ali hautunu nagluk. Chanatimaguk elpech chanu Jisas chape lihilih ali amam hautunu nagluk nabih nakus olokohun halakatimu Jisas napemu. ");
INSERT INTO apeB_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Ali douk Jisas natik namudak umu amam hanubu hakli anan douk nanubu dodogowinamu nugabeyanamu, ali anan naklipu anudak loguh aias chagakanali nakli, “Elpeninu, God wo nunohwen umu nyakin yowenyi e ali enyudak anokwleyenyuk.” ");
INSERT INTO apeB_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Wakuli amam henek skulumech umu lo uli hanu amam Farisi hape hanasolikagas umu hakli, “Anan douk monokanu alman ali dakio nape nenek tok bilas umu God? Apak madukemech umu God atunu deke kobi nunohwen umu elpechin yowenyi ali nukwleyenyuk.” ");
INSERT INTO apeB_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Wakuli Jisas anadukemu amamin tinytin ali naklipam nakli, “Ipak ulkwip kobi pulu namudak, wak. ");
INSERT INTO apeB_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Enyudak moul douk nyanubu alagun atimu yek iklipu enen elpen umu God eke kobi nunohwen umu enyenyin yowenyi ali nukwleyenyuk umu o iklipen umu nyitak nyunak ali enyen eke nyitak nyunak umu. ");
INSERT INTO apeB_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Ali nameitu yek eke igilapepamu yek Anudak Alman douk yataglu aduligeinyi elpen uli douk dodogowiwe. Ali yek douk yeul nyakihe apudak atap umu ikli God eke kobi nunohwen umu elpech cheneken uli yowenyi ali nukwleyenyuk umu. Ali anan naklipu anudak loguh aias chagakanali nakli, “Yek yaklipenyu, nyak kitak hul nyakitu bet nyunohwatu ali nyunamu wilpat!” ");
INSERT INTO apeB_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Ali ahudak atuh echudak chanatimaguk elpech douk chape lihilih uli chatulunamu naitak nohul ananitu bet nanohwatu ali nape nenehilau natuk God ananin yeul nyakih ali nape nanamu wilpat. ");
INSERT INTO apeB_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Ali echech chanatimaguk chanubu loguh hwonechlukech. Ali chopuk, echech elgeich ali chatuk God ananin yeul nyakih chakli, “Doumeih nyumnah apak matik enech sik echudak!” ");
INSERT INTO apeB_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Douk enyudak nyanakuk ali Jisas naitak nanak wakuli natik ananu alman yeulinamu Livai douk nape nalau takis uli nape. Anan nape wilpat anan nape nalau takis atali. Ali douk Jisas natulunu ali naklipanu nakli, “Nyak yowi nyugipech yek wunak.” ");
INSERT INTO apeB_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Ali Livai nanubu naitak natukemaguk enechi enech ananich echudak ali nanamanu hanak. ");
INSERT INTO apeB_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Ali douk aliga anabu nyultab ali Livai naitak nenek anagun nebeguni woligun ananitu wilpat umu Jisas. Ali wolobaimi halau takis uli hanu enech meyaluhich elpech chopuk chanak chapemu chunu Livai uli Jisas chuwak agundak woligun. ");
INSERT INTO apeB_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Ali anam Farisi hanu anam henek skulumech umu lo uli, douk hanaguk amudak Farisi uli hanech hape. Ali amam hape henekam balan Jisas ananim disaipel ali hasolikam hakli, “Ipak panam pagnah umu woligun amudak halau takis uli hanu echudak chenek enenyi enen yowenyi uli?” ");
INSERT INTO apeB_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Wakuli Jisas nakli, “Elpech douk agasudak wak anagas sunekech uli e eke kobi chunamu dokta umu nugabeyech, wak. Echebuk douk agasudak sach uli atich eke chunamu dokta umu nugabeyech. ");
INSERT INTO apeB_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Ali yek douk namudak ati kobi douk dokta umu. Yek douk wo inamali ihwalu duldulichi elpech umu chutanamu chukanu apaluh God e, wak. Yek yanamali ihwalu echebuk douk chenek yowenyi ulimu chukenyuk agabus yowenyi ali chutanamu chukanu apaluh God.” ");
INSERT INTO apeB_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Ali enech elpech chaklipu Jisas chakli, “Wolabaihi nyumneh Jon ananim disaipel hape henek beten abali, amam henek tambumu amam kobi huwak enech kakwich. Ali amam Farisi amamim disaipel chopuk douk henek namudak ati. Wakuli wolobaihi nyumneh nyakim wo hunek namudak e.” ");
INSERT INTO apeB_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Ali Jisas naklipech enyudak woblen balan nakli, “Ipak pakli ababuk nyultab anudak douk adakio nasuh okwok uli nunu ananichi nupemu, echech deke chunek tambumu kakwich ali chupe meyoh waka? Aduligu atugu deke wak. ");
INSERT INTO apeB_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Douk nyultab eke bunakimu chulawanu chunak kipaigunmomu. Ali ababuk nyultab ananichi eke ulkwip pulamu anan ali eke chunek tambumu kakwich chupe meyoh.” ");
INSERT INTO apeB_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Ali Jisas naklipech enyudak woblen balan alagun nakli, “Deke kobi enen elpen nyukawech anap lupahip anah namuhi lupah ali nyuklapap anah alihi, wak. Enyen nyunek namudak ele, enyen deke nyunek anagun gnugal ahudak namuhi lupah. Ali chopuk, deke nyuklapap ali deke kobi pupe kalbu ahudak alihi lupah, wak.” ");
INSERT INTO apeB_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Ali Jisas naklipech enyudak woblen balan alagun nakli, “Ali chopuk, deke kobi enen elpen nyinyukul anabal nupoleibal wainibal abal blugluk anap alipi memeip benyip douk chape cholu wainibal abal umu, wak. Enyen nyunek namudak ele, abaludak nupoleibal wainibal abal deke bluplukech apudak alipi benyip ali wain deke nutukwleik atap atugun. Ali apudak benyip deke yowep. ");
INSERT INTO apeB_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Ali namudak deke wak. Nupoleibal wainibal abal imas chichalabal namusi atus bechis. ");
INSERT INTO apeB_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Ali chopuk, deke kobi enen elpen nyukli nyuwak likukibal wainibal abal blulik ali wata nyukli nyuwak nupoleibal blugikuk, wak. Umu moneken, enyen nyakli abaludak likukibal ababal douk yopubali.” ");
INSERT INTO apeB_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Anah nyumnah Sabat, Jisas naitak nawich nanak anagu nahabigu douk chau wit agali. Ali ananim disaipel hanak hape hablanuk anatu ulubitu wit ali hape homapohwatu wis umu howolechatu ali hatowah. ");
INSERT INTO apeB_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Wakuli amam Farisi hasolikam hakli, “Ipak peneken umu enyudak? Apakin lo douk nyakli apak kobi munek enen moul ahudak nyumnah Sabat!” ");
INSERT INTO apeB_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Ali Jisas naklipam nakli, “Ipak patalihen balan nyetemu God ananik buk ulimu ababuk nyultab Devit nanu ananim nyulub blam umu waka wak? ");
INSERT INTO apeB_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Devit douk nawich God ananitu nebetali wilpat ali nahuli atudak bret douk chenek ofamatu choku God uli. Ali anan nawak anatu ali nakam anatu ananim almam hatowah. Ali chopuk, apakin lo douk nyakli kobi enech meyaluhich elpech chuwak atudak bret wak. Amam pris atum wasik.” ");
INSERT INTO apeB_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Ali Jisas wata chopuk naklipam nakli, “Douk yek Anudak Alman douk yataglu aduligeinyi elpen uli douk yanubu Digiwelimu iklipu elpech umu chunek moul ahudak nyumnah Sabat umu.” ");
INSERT INTO apeB_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Kipaihi nyumnah Sabat, Jisas nanak nawich anatu echech Juda chape cheyagwleh balan atali wilpat ali nape nenek skulumech umu God ananin balan. Ali agnabuk ananu alman douk ananin anin logul nyenekanaluli nanaki nanech nape. ");
INSERT INTO apeB_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Ali anam henek skulumech umu lo uli hanu amam Farisi hape hatulunu duk Jisas umu hakli kadak nukli nublo enyudak lo umu nugabe anudak logul nyenekanali ahudah nyumnah Sabat umu ali amam hunek kwotumanu. ");
INSERT INTO apeB_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Wakuli Jisas anadukemu amamin tinytin ali naklipu anudak logul nyenekanali nakli, “Kitak nayotu agundak umu echudak chunatimaguk chutulinyu.” Ali anan naitak nanak neyotu olokohun. ");
INSERT INTO apeB_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Ali Jisas naklipam nakli, “Yek yakli isolikepu, apakin lo nyakli apak munek moneken ahudak nyumnah Sabat? Apak munek yopinyi o munek yowenyi? Mugakamu elpech chupe kalbu, waka mech chugak?” ");
INSERT INTO apeB_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Ali Jisas neyotu natulich atin ati aliga neyatech ali naklipu anudak logul nyenekanali nakli, “Nu nyakin logul.” Ali anan nonu logul ali enyen nyanubu yopin. ");
INSERT INTO apeB_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Wakuli amudak henek skulumech umu lo uli hanu amudak Farisi hatik namudak ali amam hanubu nyihihichim umu Jisas. Ali amam yet hape heneyagwleh hakli, “Apak eke munekanu malmu anudak alman?” ");
INSERT INTO apeB_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Ali anah nyumnah Jisas nalto ananu maunten umu nunak nunek beten. Ali agnabuk anan nanak nape nenek beten anab wab chuknib. ");
INSERT INTO apeB_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Douk nenek beten aliga gagluk ali nohwalu hanatimaguk ananim disaipel hanak. Ali anan natalih 12-poleim atimu nukagam hunak huklipech ananin balan uli ali nabukumom yeul aposel. ");
INSERT INTO apeB_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Anan natalih Saimon, douk Jisas nabukumanu kipainyi yeul Pita uli nanu ananinu owaninu Andru, hanu Jems uli Jon. Amam hanu Filip uli Batolomyu. ");
INSERT INTO apeB_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Hanu Matyu nanu Tomas uli kipainali Jems, anan douk Alfias ananinu nuganinu, hanu kipainali Saimon douk natanuh ananu lain chohwalech umu Selot uli. ");
INSERT INTO apeB_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Amam hanu Judas douk kipainali Jems ananinu nuganinu nanu kipainali Judas douk nanaki wabul Kariot uli. Anudak Judas douk eke nugilapu Jisas ananim birua umu Jisas uli. ");
INSERT INTO apeB_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Douk enyudak nyanakuk ali Jisas nanali ananim disaipel hagluki habih heyotu anagun bukalagunmu ali wolobaichi elpech chanaki. Echech chanaki wolobailubi chokulubi walub douk blape provins Juda uli. Enech chanaki Jerusalem, enech chanaki albudak chokulubi walub douk blape halakatimu yous uli. Albalub douk blape halakatimu albudak biolub nebelubi walub Taia uli Saidon. ");
INSERT INTO apeB_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Echech chanakmali chumnek ananin balan ali chopuk umu nugabemech agasudak douk sapenyich uli. Enech douk sagabehas chapenyich ali chenekech chogugakaluli chopuk chanaki ali Jisas nagabeyech. ");
INSERT INTO apeB_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Ali chanatimaguk elpech chakli anan douk dodogowinali. Douk namudak ali echech chakli sapos echech chunak chususuhwanu meyoh umu, echech eke wata yopich. Ali echech chanak chasusuhwanu ali echech wata yopich. ");
INSERT INTO apeB_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Ali Jisas natanamu natik ananim disaipel ali naklipam nakli, “Ipak douk nameitu panahwogagun umu echudak uli douk apawich agundak God nape nebenalimu ananich elpech umu! Douk namudak ali ipak douk apenehilau. ");
INSERT INTO apeB_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Ali ipak douk nameitu nyulub blaepaluli douk apenehilau. Umu moneken, God eke nukepu kakwich pichah ali wata dugolepu! Ali ipak douk nameitu pape poleh uli douk apenehilau. Umu moneken, anah nyumnah ipak eke wata puneyakas. ");
INSERT INTO apeB_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Ali ipak douk elpech chutulipamu agundak pagipech yek Anudak Alman douk aduligeinyi elpen uli ali chunoguglepu chutulipaguk yowes umu, ipak douk apenehilau. ");
INSERT INTO apeB_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Ipak imas punehilau pubouk gani ababuk nyultab echech chunekepu namudak umu. Umu moneken, ipakich yopichi echudak douk chakusumepu iluh heven. Seiwak echechich popech yamech chopuk douk chagimehumom namudak ati amam seiwakimi profet. ");
INSERT INTO apeB_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Wakuli ipak douk nameitu ponokwalmu wolobaichi echudak uli yek yakli mapilipu. Umu monoken, yopichi abudak amnabich echudak ipak penehilaumech uli douk ipak apanalawech nameitu. ");
INSERT INTO apeB_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Mapilipu ipak douk nameitu pachah dugalepaluli. Umu monoken, ipak eke wata nyulub blepu. Ali kwali ipak eke punomnek nebehi nyih! Ali mapilipu ipak douk nameitu pape peneyakas uli. Umu monoken, ipakiluh apaluh eke wata yoweluh ali punubu puleh nebegun. Ali kwali ipak eke punomnek nebehi nyih. ");
INSERT INTO apeB_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Ali mapilipu ipak douk nameitu chanatimaguk elpech chatuk ipakich yeguh chakli ipak panubu yopipali uli. Ipak imas punenek yologimu hevi douk eke nyutoglo-mepaluli. Kwali ipak eke punomnek nebehi nyih. Umu moneken, seiwak echechich popech yamech douk chanubu chenek namudak ati chatuk amubuk henek lohumech uli profet amamich yeguh chakih.” ");
INSERT INTO apeB_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Ali Jisas balan nyeilen nakli, “Ali yek yaklipu ipak douk pemnek yekin balan uli. Ipak ulkwip imas punubu punosuh ipakich birua ali punek yopinyimu echebuk douk chutulipaguk yowes uli. ");
INSERT INTO apeB_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Ali punek beten umu God umu nunekumech yopinyi echebuk douk chuplahagun-mepamu chukli enen hevi nyutoglome-paluli. Ali punek beten umu God umu nugakamu echebuk douk chepu chuhepaluli. ");
INSERT INTO apeB_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Sapos enen elpen nyukli nyubo woblohw nugulihw umu, nyak imas nyutanamu nyuken woblohw chopuk nyohw. Ali sapos enen elpen nyukli nyunatulinyu nyakitu saket umu, nyak nyuken nyakitu siat alagun. ");
INSERT INTO apeB_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Ali sapos enech elpech chuhwalepamu pukech enech echudak umu, ipak imas pukechech. Ali chopuk, sapos enen elpen nyutulinyu nyunahul enech echudak umu, nyak kobi wata nyunak nyuhwalen nyunalak nyupemen umu nyubeyech-umenyali, wak. ");
INSERT INTO apeB_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Enyebuk pasin douk ipak pakli elpech chuneken umu ipak uli, ipak chopuk imas punek enyebuk atin umu echech. ");
INSERT INTO apeB_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Sapos ipak ulkwip punosuh echebuk douk echech ulkwip panosuh ipak uli atich umu, ipak eke omuni nyutuk ipakich yeguh chukih? Aduligu atugu eke wak. Chenek enenyi enen yowenyi uli chopuk isave ulkwip panosuh echebuk douk echech ulkwip panohwech uli atich! ");
INSERT INTO apeB_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Ali sapos ipak punek yopinyi pasin umu echebuk douk chenek yopinyi pasin umu ipak uli atich umu, ipak eke omuni nyutuk ipakich yeguh chukih? Aduligu atugu eke wak. Chenek enenyi enen yowenyi uli chopuk isave chenek namudak ati! ");
INSERT INTO apeB_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Ali sapos pukech echudak echebuk elpech douk padukemech umu eke wata chubeyech-umepaluli atich umu, ipak eke omuni nyutuk ipakich yeguh chukih? Aduligu atugu eke wak. Chenek enenyi enen yowenyi uli elpech chopuk isave chenek namudak ati! ");
INSERT INTO apeB_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Ali namudak wak! Ipak imas ulkwip punosuh ipakich birua ali punek yopinyi pasin umu echech. Ali pukech echudak ali kobi punek tin umu echech wata chubeyech-umepali wak. Ipak punek namudak ali anah nyumnah God eke nunubu nunekumepu wolobainyi yopinyi gani iluh heven. Ali chopuk, ipak eke putoglu nabouk ihechumali echudak chabihuk uli God ananipu batowich. Umu moneken, anan douk yopunamu echebuk douk wo chunek tenkyuma-naluli uli e, chanu echebuk douk chenek yowenyi uli ali nagakamech. ");
INSERT INTO apeB_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Ipakinu Aninu isave nenelek echebuk douk chenek yowenyi uli ali nagakamech. Douk namudak ali ipak chopuk imas punek namobuk ati.” ");
INSERT INTO apeB_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Ali Jisas balan nyeilen nakli, “Ipak kobi punek skelim umu kipaichimu, God chopuk eke kobi nunek skelimumepu, wak. Ali ipak kobi pukech enen balan kipaichi pukli echech chenek yowenyimu, God chopuk eke kobi nukepu enen balan nukli ipak penek yowenyi. Ali ipak kobi pusuh yowenyi kipaichi cheneken umu ipak uli ali pukwleyenyuk umu, God eke kobi nunohwen umu ipakin yowenyi ali nukwleyenyuk. ");
INSERT INTO apeB_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Ali ipak pukech echudak kipaichimu, God eke wata nukepu enech echudak ipak. Anan eke nugakamepu nukepu chanubu wolobaichi echudak ali eke chunubu chunokwnumepu. Ali makwnich echudak ipak puku kipaichimu, echebuk God eke wata nubeyechumepu namobuk ati.” ");
INSERT INTO apeB_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Ali Jisas naklipech enyudak woblen balan nakli, “Ananu nabes sechukanali deke kobi nugilapanu yah kipainali nabes sechukanali, wak. Sapos anan nugilapanu yah umu, amam biam eke hunak hugoul hugluk anagu bobigu. ");
INSERT INTO apeB_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Ali chopuk, deke kobi enen elpen nyanamu skul uli nyukli nyupe nebenyimu enyenyinu tisa, wak. Chunatimaguk eke chiyatak echechin skul iyuh ali echech deke adakio chutoglu kobi douk echechim tisa amimu.” ");
INSERT INTO apeB_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Nyak douk wo nyutik abudak nebebi aib douk balu nyakip nabep uli e. Douk namudak ali nyak wata nyatulugun umu agundak gnanubu chokuguni aibigun douk gnalu nyakin elpen enyenyip nabep uli? ");
INSERT INTO apeB_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Nyak douk wo nyutik abudak nebebi aib douk balu nyakip nabep uli e. Douk namudak ali nyak eke kobi nyuklipu nyakin elpen umu nyupotimenyuk agundak chokuguni aibigun douk gnalu enyenyip nabep uli, wak. Nyak nyenek loh uli! Susubuati nyak imas nyulik nyupotiyuk abudak nebebi aib douk balu nyakip nabep uli iyuh. Ali nyak deke nyunatulugun kalbu ali adakio nyupotimenyuk agundak chokuguni aibigun douk gnalu nyakin elpen enyenyip nabep uli.” ");
INSERT INTO apeB_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Ali Jisas balan nyeilen nakli, “Yowepi chulkwip eke kobi pil enen yopinyi lowag. Ali yopipi eke kobi pil enen yowenyi, wak. ");
INSERT INTO apeB_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Elpech eke chutik chulkwip atip ali eke chudukemech umu enyen douk yopinyi waka yowenyi. Elpech eke kobi chudi enep chulkwip yeulip umu fik uli enen naluhich chatoglen uli lowag, wak. Ali chopuk, eke kobi enech elpech chudi enep wainip chulkwip enen naluhich chatoglen uli lowag, wak. ");
INSERT INTO apeB_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Ali elpech chopuk douk namudak ati. Yopinyi elpen douk wolobainyi yopinyi tinytin nyape numun uli isave nyenek yopinyi pasin. Ali yowenyi elpen douk wolobainyi yowenyi tinytin nyape numun enyenyim ulkum uli isave nyenek yowenyi pasin. Umu moneken, elpech isave cheyagwlehi enenyi enen nyape numun echechip ulkwip uli.” ");
INSERT INTO apeB_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Ali Jisas balan nyeilen nakli, “Ipak isave pohwale pakli, ‘Digiweli’ wakuli ipak wo pugipech yekin balan e umu moneken? Namudak wak. ");
INSERT INTO apeB_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Echebuk elpech douk chunamali yek ali chumnek yekin balan chugipechen uli, echech eke kobi moneken umu? ");
INSERT INTO apeB_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Echech douk kobi ananu alman douk naitak nabo bobigas nagluk aliga nabih nasuh bulbudib ali naitak nau ulaluh ali nalak ananitu wilpat uli. Douk nalatu kalbu ali echah halali wolub bau batu wakuli babilak wo butukatu e. ");
INSERT INTO apeB_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Wakuli echebuk douk chumnek yekin balan ali kobi chugipechen uli douk kobi anudak alman douk nalak wilpat atap meyoh uli. Anan wo nunu anagas bobigas iyuh ali nu ulaluh ali adakio nulatu e. Ali anan nalatu wakuli echah halali ali wolub bau batukatu ali tatu.” ");
INSERT INTO apeB_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Douk Jisas naklipech enyudak balan neyaten chemneken ali naitak nanamu Kapaneam. ");
INSERT INTO apeB_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Ali agnabuk ananu nebenalimu amam soldia uli nape. Anan douk nanaki abuldak wabul Rom. Ali anabuk douk nenekumanu moul uli agudak ganu ali anan halakatimu nugak. Ali anudak nebenali soldia douk ulkum manubu manohwanu. ");
INSERT INTO apeB_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Ali anan nemnek umu Jisas nanaki nape Kapaneam umu, ali nakagas anam echech Juda echechim nebemi umu hunak huklipanalimu nunaki nugabe anudak nenekumanu moul uli. ");
INSERT INTO apeB_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","5","Douk nakagam hanak hatoglamu Jisas ali hanalak heilmanu hakli, “Anudak nebenali soldia douk nanubu yopuyopunali. Douk namudak ali nyak nyunak nyugakamanu. Anan douk ulkum manubu manosuh apak manatimaguk Juda ali anan yet nakapu utabal ali malak apakitu wilpat mape meyagwleh balan atali.” ");
INSERT INTO apeB_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Ali Jisas naitak nanamom hanak. Douk hanak halakatimu wilpat wakuli anudak soldia naitak nakagas anam ananim elpechim hanak haklipu Jisas hakli, “Diginyali, anudak soldia nakli nyak kobi nyunak ananitu wilpat. Umu moneken, anan douk wo yopunalimu nyak nyunak ananitu wilpat umu e. ");
INSERT INTO apeB_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Ali chopuk, anan douk wo yopunalimu nunaki halakatimu nyak ali nutulinyu e. Wakuli anan nakli nyak nyukli balan atin ali anudak nenekumanu moul uli wata yopunu. ");
INSERT INTO apeB_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Anan nadukemech umu nyak nyukli balan atin umu, anan eke wata yopunu. Umu moneken, anan douk nape chakamomu ananinu nebenali soldia. Ali anan chopuk douk nape nebenalimu kipaimi soldia. Ali sapos anan nuklipu ananamu nunak umu, anan eke nunak. Ali nuklipu ananamu nunakumali, anan eke nunaki. Ali sapos nuklipu anudak nenemanu moul meyoh uli nukli nek dakichimu, anan eke nunekech.” ");
INSERT INTO apeB_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Ali Jisas nemnek namudak ali loguh hwonechlukanu ali natanamu naklipu echudak wolobaichi elpech chagimanaluli nakli, “Yek yaklipepu, apak yet Isrel, yek wo itik enen atin elpen nyunek bilip dodogowin atin namudak e!” ");
INSERT INTO apeB_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Ali amudak douk nakagam hanak umu huklipu Jisas uli wata hatanamu hanak wilpat ali hatik umu anudak nenek moulamu anudak soldia uli wata yopunu. ");
INSERT INTO apeB_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Douk Jisas napegu ali naitak nanamu anabul wabul chohwalabul umu Nen uli. Ali ananim disaipel hanu wolobaichi elpech chopuk chanamanu chanak. ");
INSERT INTO apeB_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Douk nanak natoglu Nen wakuli natik umu enech chasahi ananu nagak uli alman chanaki. Anudak alman ananik mamakik douk kwanubu kwalali anan atunu. Ali okwokwinu alman douk anagakuk ali wolobaichi elpech chanamok chanaki. ");
INSERT INTO apeB_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Ali douk Diginali Jisas natuluk namudak ali anan nanubu nakli mapilik ali naklipok nakli, “Nyak kobi nyuleh.” ");
INSERT INTO apeB_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Ali anan nanak nasuh asudak bokis douk chanalu chanasahumali ali echudak chanasahi uli chatik namudak ali cheyotu. Ali Jisas nakli, “Chokwinali! Kitak, yek yaklipenyu!” ");
INSERT INTO apeB_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Wakuli anudak nagak uli nanubu naitak nape neyagwleh ali Jisas naklipu ananik mamakik nakli, “Nyakinu nuganinu anudak.” ");
INSERT INTO apeB_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Ali douk chanatimaguk chatik namudak ali echech chanubu elgeich ali chatuk God ananin yeul nyakih ali chakli, “Ananu nebenali profet ananaki nape olokohun umu apak.” Ali chopuk chakli, “God ananakimu nugakamu apak ananipu elpech.” ");
INSERT INTO apeB_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Ali enyudak balan nyoweyeh nyanak wolobaigunmu enyudak provins Judia gnanu kipailubi walub blape halakati uli chopuk umu enyudak moul Jisas neneken uli. ");
INSERT INTO apeB_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","19","Douk Jon ananim disaipel haklipu Jon umu enyudak Jisas nape neneken uli ali anan nohwalu biam hanaki ali nakagam hanak. Amam hanak umu husolik Diginali hukli, “Douk God eke nukaganu nunaki uli douk nyak waka, eke mupe mubeyagunmu kipainali?” ");
INSERT INTO apeB_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Ali amam hanak hatoglamu Jisas ali hasolikanu hakli, “Jon douk nenek baptaisumech uli nakagahwali ali wanakimu usolikenyamu, ‘Douk God naklimu nukaganu nunaki uli alman douk nyak waka, eke mupe mubeyagunmu kipainali?’” ");
INSERT INTO apeB_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Ali banubu ababuk nyultab Jisas nagabe wolobaichi agasudak sach uli chanu sagabehas chapenyich uli. Ali chopuk nagabe wolobaichi nabes sechukechi ali echech wata chatulugun. ");
INSERT INTO apeB_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Ali Jisas naklipu amudak Jon ananim disaipel nakli, “Ipak wata punak puklipu Jon umu moul douk ipak patulin uli nyunu balan ipak pemneken uli. Nabes sechukechi wata chatulugun, ali echudak douk chape atap atup uli wata chaitak chalahe. Ali yagabe sig lepra gapenyich uli wata yopich, ali aligas sogugakoyechi wata chemnek. Ali yohul chagak uli wata chaitak chape, ali yaklipech God ananin yopinyi balan echebuk douk chanahwagagun umu echudak uli chemneken. ");
INSERT INTO apeB_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Ali echebuk elpech douk ulkwip palamu yek ali chasuh yekin balan uli, echech douk achenehilau!” ");
INSERT INTO apeB_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Ali douk Jon ananim hatanamu hanak ali Jisas nape naklipu echudak wolobaichi elpech umu Jon nakli, “Likuk ipak panak patik Jon gani wohigunmu elpech wak umu, ipak pakli anan douk manakanu alman ali ipak dakio panak patulunu? Pakli anan douk wo dodogowinu kobi douk wolul douk wihun nolul lanak wobul lanak wobul uli waka? ");
INSERT INTO apeB_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","O panak umu putik moneken? Ipak panak umu putik ananu alman douk nolu dudukeh atih luseh uli? Wak. Chenek dudukeh atih luseh ali chawak yopichi atich kakwich ali chape kalbu ati uli, echebuk douk chape king omi amamig otug wilag. ");
INSERT INTO apeB_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Wakuli yek yakli ipak puklipemu ipak panak umu putik moneken? Ipak panak umu putik ananu profet waka? Aduligu atugu anan douk nanubu ananu profet. Ali chopuk, anan douk nechalakuk amudak anam profet. ");
INSERT INTO apeB_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Balan douk nyetemu God ananik buk uli douk nyanubu nyaklimu anudak Jon. Ali God douk nakli, ‘Yek eke ikagas ananu nulau yekin balan uli nulik nunak. Anan eke nulik nunak nugabemenyu yah nyak!’” ");
INSERT INTO apeB_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Ali Jisas nakli, “Yek yaklipepu, Jon ananin yeul douk nyanubu nyakihuk nyechalakuk chanatimaguk elpech douk chape apudak atap uli echechich yeguh. Wakuli echebuk elpech douk echech yeguh wo chukihech e, wakuli achawich agundak God nape nebenalimu ananich elpech umu, echechich yeguh douk chanubu chakihuk chechalakuk Jon ananin yeul.” ");
INSERT INTO apeB_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Ali douk chanatimaguk elpech chanu amudak halau takis uli chemnek Jisas neyagwlehen uli balan ali echech chape chenehilau. Echech chenehilaumu agundak likuk echech chemnek God ananin balan chagipechen chakli wasik yopinyi balan ali Jon nenek baptaisumech umu. ");
INSERT INTO apeB_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Wakuli likuk amam Farisi hanu amudak henek skulumech umu lo uli hemnek God ananin balan ali hokenyuk agabus God ananin laik ali hakli wak umu Jon nunek baptaisumom umu. ");
INSERT INTO apeB_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Ali Jisas nakli, “Yek eke igilapepeyech malmu echudak nameiteichi elpech douk chakanaguk agabus God uli. Echech kobi douk omunimu? ");
INSERT INTO apeB_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Echech kobi douk chokwichi douk chemnek kipaichi echechin balan ali wo chugipechen ati uli e. Chokwichi isave chanak chape agnabuk douk echech isave chowachabal chapemu ali enech chape chohwalu enech chakli, ‘Apak monehilau ali mape mehepich buan wakuli ipak wo pugakamapu miyalub e! Apak mape madalu daleiluh aweluh douk chadalaluh umu chagak ulimu ali ipak wo puleh e.’ ");
INSERT INTO apeB_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Douk likuk Jon nenek baptaisumech uli nanaki ali anan wo nuwak yopichi kakwich chunu wainibal abal e ali ipak wo pumnek ananin balan pugipechen e. Ali ipak pakli, ‘anabuk enen sagabu nyapenyunu ali nogugaku!’ ");
INSERT INTO apeB_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Ali nameitu chopuk, yek Anudak Alman douk yataglu aduligeinyi elpen uli yanaki ali yape yawak kakwich uli wainibal abal ali ipak pakli, ‘Tik nani nogoluk nalikuk uli. Anan nawak wolobaibali wainibal abal ali nogugaku. Ali chopuk, nanu amudak halau takis uli hanu echudak chenek enenyi enen yowenyi uli chape!’ ");
INSERT INTO apeB_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Wakuli echudak elpech douk chagipech God uli cheneken uli pasin douk nyagilapapamu God ananin tinytin douk yopinyi atin.” ");
INSERT INTO apeB_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Ananu Farisi nohwalu Jisas umu nunak nunanu huwak woligun ananitu wilpat. Ali Jisas naitak nanak natoglu anudak Farisi ananitu wilpat ali nananu hape tebol hape hawak kakwich. ");
INSERT INTO apeB_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Ali ablabuk wabul, onok almatok douk kwonek wolobainyi yowenyi uli kwape. Ali okwok kowmnek umu Jisas nanak nanu anudak Farisi hape hawak kakwich umu. Ali okwok kwaitak kwohul anal yopuli botol douk chenekal utabal uli chuknil umu yopinyi sanda uli kwahwal ali kwanak. ");
INSERT INTO apeB_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Okwok kwanak kweyotu agabahinamu Jisas halakatimu ananiluh yaliluh ali kwape kowleh. Okwok kwoleh ali abih habih hetemu ananiluh yaliluh ali okwok wata kwaku okwokwim boglom kwape kwanublehuk. Ali okwok kwanaplikaluh iyuh ali adakio kwohluhwumanu enyudak sanda. ");
INSERT INTO apeB_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Wakuli anudak Farisi douk nohwalu Jisas nanaki uli natik namudak ali anan yet neneyagwleh nakli, “Sapos amudak alman douk nunubu adulinali profet ele, anan deke nudukemok okudak almatok douk kwape kwasusuh-analuli. Ali chopuk, anan deke anudukemech umu okwok douk kwonek yowenyi uli!” ");
INSERT INTO apeB_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Wakuli Jisas naklipanu nakli, “Saimon, yek yakli iklipenyu enen balan.” Ali Saimon nakli, “Wasik tisa, klipe.” ");
INSERT INTO apeB_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Ali Jisas naklipanu nakli, “Ananu alman nakam anabal utabal biam almam. Ananu nakanu 100 kina, ali ananu nakanu 10 kina atin. ");
INSERT INTO apeB_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Ali amudak biam utabal wak umu wata hubeyabal-umanamu ali anan nakli anyunekabal. Ali nyak nyakli meinali deke ulkum munubu munosuh anudak nakam utabal uli?” ");
INSERT INTO apeB_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Ali Saimon nakli, “Yek yakli anudak douk nakanu 100 kina uli.” Ali Jisas nakli, “Nyak nyakli duldul.” ");
INSERT INTO apeB_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Ali natanamu natik okudak almatok ali naklipu Saimon nakli, “Nyak nyatuluk okudak almatok? Yek yanaki nyakitu wilpat wakuli nyak wo nyuke anabal abal umu inokwlupu yekikluh yaliluh e. Wakuli okudak kwape kwoleh ali okwokwih abih habih hetemu yekikluh yaliluh ali wata kwaku okwokwim boglom kwape kwanublehuk. ");
INSERT INTO apeB_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Ali nyak douk wo nyunaplike e. Wakuli okudak, ababuk nyultab yek yanaki atimu aliga nameitu, okwok kwape kwanaplik yekikluh yaliluh. ");
INSERT INTO apeB_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ali nyak douk wo nyuwayakume anal wel boglom e, wakuli okudak kwakwlupome yaliluh sanda. ");
INSERT INTO apeB_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Ohwok ulkum douk manubu manohwe. Namudak ali yek yaklipenyu, God douk awo nunohwen umu enyudak wolobainyi yowenyi likuk okwok kwoneken uli e ali anokwleyenyuk. Echebuk elpech douk chenek gwodin yowenyi ali God wo nunohwen e ali nokwleyenyuk uli, echechip ulkwip eke punosuh God kwalowi ati.” ");
INSERT INTO apeB_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Ali Jisas naklipu okudak almatok nakli, “God wo nunohwen umu nyakin yowenyi e ali anokwleyenyuk.” ");
INSERT INTO apeB_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Wakuli echudak chananu chape chawak kakwich uli echech yet cheneyagwleh chakli, “Anudak anan douk manakanu alman ali dakio nakli God wo nunohwen umu elpech chenekech uli yowenyi ali nokwleyenyuk umu?” ");
INSERT INTO apeB_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Wakuli Jisas naklipu okudak almatok nakli, “Nyak nyenek bilip umu God ali anan dakio nanalawenyu nyatanamali nyape kalbu. Namudak ali nyak nyunak ali nyakihw apahw hwulu kalbu.” ");
INSERT INTO apeB_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Douk anabu nyultab banakuk ali Jisas naitak nanak analub nebelubi walub blanu analub chokulubi. Anan nanak nape naklipech yopinyi balan umu agundak God nape nebenalimu ananich elpech umu. Ali ananim 12-poleim disaipel chopuk hanamanu hanak. ");
INSERT INTO apeB_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Amam hanu onou almagou chopuk douk likuk Jisas nahiyah-umowoguk sagabehas chanu agudak douk gapenyuwaluli chanamanu chanak. Oudak almagou onok douk Maria douk kwanaki wabul Makdala uli. Okwok douk seiwak Jisas nahiyah-umokuk echudak 7-poleich sagabehas chapenyuk uli chatoglu chalhwasuk uli. ");
INSERT INTO apeB_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Ali onok douk Joana douk okwokwinu alman nanahwalamu Susa uli. Anan douk nenek moul Herot ananitu wilpat. Owo wanu Susana kwanu wolobaiwali almagou chopuk wagipechanu. Ali owo isave wagakamam nanu ananim disaipel umu wakam anabal owowibal utabal blanu enech kakwich. ");
INSERT INTO apeB_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","5","Douk echech chanak wakuli chanubu wolobaichi elpech chanaki wolobailubi walub uli chape chanakimu chakli chutik Jisas. Douk aliga wolobaichi chanaki cheyotu ali Jisas naklipech enyudak woblen balan nakli, “Ananu alman nanak nowachak wit anan umu yawihas. Anan nowachatu ali anatu tabih takus yah, ali elpech chalahe chalikwechatu ali almiguh hwabih hwatahul hwatowah. ");
INSERT INTO apeB_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Ali anatu tabih takus utabal umu. Ali atat pupuwalatu takih wakuli abal wak anabal e ali alitu. ");
INSERT INTO apeB_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Ali anatu tabih taglukuk anap naluh hlataglap uli wichap ali pupuwalatu takih wakuli apudak wichap popakwilatu. ");
INSERT INTO apeB_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Ali anatu tabih taglukuk yopubi amnab ali pupuwalatu takih ali wolobaitali teil. Atat 100-poleib ulub beil atutu ati biguhitu wit.” Ali douk Jisas nakliyuk namudak ali anan naklipech nakli, “Ipak aligas sapenyipali imas pugamu pumnek yekin balan ali pugipechen!” ");
INSERT INTO apeB_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Douk Jisas nakliyuk enyudak balan ali ananim disaipel hasolikanamu bawogen umu balan umu enyudak woblen balan anan naklien uli. ");
INSERT INTO apeB_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Ali Jisas naklipam nakli, “God douk anaklipepu bawogen umu balan umu enyudak nyanabechuk uli balan ipak atipamu elpech chuwich umu agundak God nape nebenalimu ananich elpech umu. Wakuli chunatimaguk kipaichi eke wak. Echech eke chumnek woblen atin ali eke chutimu bawogen umu wakuli eke kobi chudukemen. Echech eke chumnek balan wakuli eke kobi chudukemu bawogen umu, wak.” ");
INSERT INTO apeB_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Ali Jisas balan nyeilen nakli, “Enyudak woblen balan umu anudak nowachak wit yawihas uli douk nyanak namudak. Atudak wit douk kobi God ananin balan umu. ");
INSERT INTO apeB_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Ali atabuk douk tabih takus yah uli douk kobi echebuk elpech douk chemnek God ananin balan, wakuli Satan nanaki natulich nalawoguk enyudak balan douk nyape echechiluh apaluh uli. Anan nenek namudak umu echech kobi chusuh God ananin balan dadag chugipechen ali God wata nunolawech chutanamali chupe kalbu, wak. ");
INSERT INTO apeB_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Ali atabuk tabih takus utabalumaluli douk kobi echebuk elpech douk chemnek God ananin balan chenehilaumen wakuli echech chemneken meyoh uli. Echech wo chuhwen dadag e. Echech chenek bilip umu enyudak God ananin balan chakli adulin banabu nyultab meyoh. Wakuli Satan nechakomech umu chunek yowenyi ali echech chatukemaguk God ananin balan ali wata chatanamu chanak chenek yowenyi. ");
INSERT INTO apeB_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Ali atabuk douk tabih taglukuk naluh hlatoglopi wichap uli douk kobi echebuk elpech douk chemnek God ananin balan, wakuli echech chapemu chakli chunokwalmu wolobaichi enechi enech echudak uli. Ali echech chenehilaumu echudak enechi enech abudak amnabich atich. Echech douk chenek warimu enenyi enen hevi douk eke nyutoglomech uli ali oub baitak umu chulau wolabaichi enechi enech echudak ali echech chape chagipech nyalik nyapenyich uli yowenyi pasin. Ali echudak chowechik echechip ulkwip ali echech wo chusuh God ananin balan dadag e. Echech chanubu ulkwip pekechumaguk enyudak God ananin yopinyi balan douk echech chemneken uli ali chatukemenyuk. Ali echech wo chunek yopinyi pasin e. ");
INSERT INTO apeB_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Ali atabuk douk tabih takus yopubi amnab uli douk kobi echebuk elpech douk chemnek God ananin balan ali chahwen dadag chagipechen uli. Echechiluh apaluh douk hlanubu yopuyopuluh hlape kalbu ali chanubu cheyotu dadag chagipech God ananin balan. Ali echech chenek yopinyi pasin ali chape kobi atudak wit douk wolobaitali ulubitu teil uli.” ");
INSERT INTO apeB_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Ali Jisas balan nyeilen nakli, “Deke kobi enen elpen nyuhemu enen lam ali nyitak nyupakwilen anatu baket o nyinyiglen chakamu anatu bet, wak. Enyen deke nyuhemen ali nyinyemu chihah umu kadak elpech chuwichumali chutik agundak enyen nyuglak umu. ");
INSERT INTO apeB_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Ali chanatimaguk echudak douk nameitu chonobechuk uli eke wata chutoglu yopugunmu. Ali chanatimaguk echudak douk nameitu elpech chechukalich chakus uli eke wata chichlekech chukus yopugunmu. ");
INSERT INTO apeB_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Ali ipak punenek yalagi ali pugabe pumnek. Umu moneken, echebuk elpech douk chulau God ananin balan chudukemen kalbaluli, God eke wata nugamu nuklipech enen alagun. Ali echebuk douk wo chudukemu ananin balan uli e, enyebuk gwodin echech chahwen uli eke wata nutulichenyuk.” ");
INSERT INTO apeB_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Douk Jisas nape naklipech God ananin yopinyi balan echudak wolobaichi elpech, wakuli ananik mamakik kwanu ananim owahlim chanakimu chakli chutulunu. Douk chanaki wakuli wolobaichi elpech cheyotu lihilih ali anan neyotuk olokohun. Ali echech chabilak wo chunak halakatimu anan e. ");
INSERT INTO apeB_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Douk namudak ali enech chaklipanu chakli, “Nyakik mamakik kwanu nyakim owahlim chachi chanaki cheyotu aduk. Ali echech chakli nyak nyunak nyutulich.” ");
INSERT INTO apeB_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Wakuli Jisas naklipech nakli, “Echebuk douk chemnek God ananin balan chahwen chagipechen uli echech douk kobi yekik mamakik uli yekim owahlim umu.” ");
INSERT INTO apeB_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Anah nyumnah Jisas naklipu ananim disaipel nakli, “Apak munak gani woblahah-inyumu raunwara.” Ali amam haitak halto bot ali hanak. ");
INSERT INTO apeB_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Douk hanak yah ali Jisas ulpusinu ali nabih nechuh. Ali nanubu nebenali wihun naluwi ali abal blakih blagluk bot ali atat halakatimu tuglukuk ati. ");
INSERT INTO apeB_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Ali ananim disaipel hatik namudak ali hanak habalunu hakli, “Nebenyali, apak ahalakatimu mugak wo!” Ali anan naitak nahu anudak wihun uli molub umu chunak chiluk. Ali wihun nanak neiluk ali molub chopuk wo butuk e. ");
INSERT INTO apeB_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Ali anan nasolik ananim disaipel nakli, “Ipak wo punek bilip umu yek e umu moneken?” Ali amam elgeim ali hape hanasolik-agas umu hakli, “Anudak manakanu alman? Anan nahu wihun uli abal umu chunak chiluk ali echech chopuk chemnekanu ali chanak cheiluk!” ");
INSERT INTO apeB_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Ali Jisas nanu ananim disaipel hanak aliga hanak hatoglu echech Gegesa echech umu. Agagun douk gnape gani woblahahin umu raunwara Galili. ");
INSERT INTO apeB_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","29","Agnabuk ananu ablabuk wabulinu douk sagabehas chapenyunu ali chenekanu nogugakaluli nape. Wolobaihi nyumneh echudak sagabehas chahwanu dadag anudak alman. Ali loubamu nyultab anan wo nihlu ati e luseh, ali wilpat wo nupe ati e. Ali elpech isave chatulunu wihluwehlu ali chahwanu chape chakwu senab chowechik ananich loguh aias. Echech chowechikanu wakuli anan naplukech abudak senab ali echudak sagabehas chalawonu chanak wohigunmu elpech wak umu. Anan nanak nape hulusigwiluh gani matmat. Douk amam hanak hatoglu ali Jisas nabih nakih neyotu buknap ali anudak sagabehas chapenyunali nanaki natoglomanu. Ali natik Jisas ali nohwalu nebegun ali nanak nabih nakus atap halakatimu Jisas ananiluh yaliluh. Ali nohwalu nebegun nakli, “Jisas, Nanubu Nebenali God ananinyu Nuganinu! Nyak nyakli nyuneke malmu yek? Yek yanalak yeilmenyamu yakli nyak kobi nyuneke ilau nebehi nyih.” Anan naklipanu namudak Jisas umu moneken, Jisas douk adukwechuk nahu echudak sagabehas umu chutuke-managuk chutoglu chulhwas. ");
INSERT INTO apeB_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Ali Jisas nasolikanu nakli, “Nyak nyonohwalu malmu?” Ali anan nakli, “Apak Wolobaipali Sagabehas.” Anan douk nakli namudak umu moneken, wolobaichi sagabehas chawich chapenyunu. ");
INSERT INTO apeB_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Ali wolobaihi atih echudak sagabehas chanalak cheilmu Jisas chakli, “Nyak kobi nyukagapu munak mugluk agudak bobigu douk gagal gagluk ali wo gubih giyotu anagun uli e.” ");
INSERT INTO apeB_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Ali agnabuk anaguh bulguh hweyotuwi halakati anatu nukut. Ali echudak sagabehas chaklipu Jisas umu nukagech chunak chuwich oguhudak bulguh ali anan nakagech chanak. ");
INSERT INTO apeB_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Ali echech chataglali anudak nagakali alman chanak chawich oguhudak bulguh. Ali ogwoguh hwatanamu hwalhwas hwanak hwagluk enen natagul ali hwabih hwagluk enyudak raunwara. Ali ogwoguh hwabalah ali hwanatimaguk hwagak hwatuh. ");
INSERT INTO apeB_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Ali amudak almam douk hape hoku oguhudak bulguh uli hatik namudak ali hasahul hanak haklipu echudak douk chape nebebuli wabul uli, chanu echebuk douk chape halakatimu nahabigas ulimu enyudak douk nyatoglaluli. ");
INSERT INTO apeB_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Ali elpech chaitak chanak umu chutik enyudak douk nyatoglaluli. Echech chanak chatoglomu Jisas ali chatik anudak douk sagabehas chatukemanaguk chatoglu chalhwasuk uli nape. Anan wata nalau yopinyi tinytin ali naitak nenenek luseh ali nanak nape halakatimu Jisas ananigas aias. Douk echech chatulunu namudak ali echech chanubu elgeich. ");
INSERT INTO apeB_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Ali echebuk elpech douk chatik enyudak Jisas neneken ulimu nagabe anudak sagabehas chapenyun-aluli cheneyagamu echebuk douk chanamali chutik enyudak douk nyatoglaluli. ");
INSERT INTO apeB_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Ali chanatimaguk elpech chape Gegesa uli chanubu elgeich ali chaklipu Jisas umu nutukemaguk echechibul wabul nunak. Ali anan naitak nalto bot ali natanamu nanak gani woblahahin umu raunwara. ");
INSERT INTO apeB_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","39","Ali anudak sagabehas chatukemanaguk chatoglu chalhwas uli naitak nasalik Jisas nanalak neilmanamu nakli nunamanu hunak. Wakuli Jisas naklipanu nakli, “Wak, nyak wata nyutanamu nyunak nyakibul wabul ali nyuklipu nyakichi elpech umu enyudak moul God neneken umu nyak uli.” Ali anudak alman wata natanamu nanamu ananibul wabul ali naklipu chanatimaguk elpech umu agundak Jisas nagabeyanamu. ");
INSERT INTO apeB_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Ali Jisas natanamu nanak aliga nanak natoglu gani woblahahin umu raunwara ali wolobaichi elpech chenehilau-manu. Umu monoken, echech douk akwigani chanaki chape chatulugunmanu. ");
INSERT INTO apeB_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Ali Jairas, douk nape nebenalimu echech Juda chape cheyagwleh balan atali wilpat uli chopuk nanaki. Anan nanaki ali nabih nakus atap halakatimu Jisas ananiluh yaliluh ali nasolikanu nanalak neilmanamu nunak ananitu wilpat.” ");
INSERT INTO apeB_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Umu moneken, ananik otuk meyoh nugawik douk okwokich yohwleguh mamakik kwokwlamali chatoglu 12-poleich uli ahalakatimu kugak. Ali Jisas naitak nape nanak yah ali wolobaichi elpech chopuk chanamanu chanak wibul wobul ali anan nolu olokohun. ");
INSERT INTO apeB_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Ali agnabuk onok almatok douk butog gwanakok kwape 12-poleich yohwleguh uli chopuk kwanaki. Okwokwibal utabal douk akwowachabal blatuhuk umu kwatal dokta omimu agundak hape hagabeyok umu. Wakuli amam chopuk habilak wo hugabeyok e. Elpen douk wak enen dodogowin umu nyugabeyok e. ");
INSERT INTO apeB_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Douk namudak ali okwok kwagimali Jisas kwanaki agabahinamu ali kwasusuh apubih umu ananih lupah ali butog gwanubu tupokologuk. ");
INSERT INTO apeB_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Wakuli Jisas nasolikech nakli, “Omuni nyanaki nyasusuhweik?” Wakuli echech chanatimaguk chatanamu ali echech atin ati chakli echech wak. Ali Pita nakli, “Nebenyali wolobaichi elpech cheyotu lihilih umu nyak ali echech chanaku chotohlu-enyaguk meyoh.” ");
INSERT INTO apeB_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Wakuli Jisas nakli, “Wak, yek yadukemech, enen elpen nyasusuhweik. Umu moneken, yek yemnek umu God ananin strong douk anyagabe enen elpen.” ");
INSERT INTO apeB_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Ali okudak almatok akwadukemech umu anan anadukemech umu agundak anan nagabeyok umu. Ali okwok kluk kluk kwanaki kwabih kwakus halakatimu Jisas ananiluh yaliluh. Ali echudak chanatimaguk elpech cheyotu ali okwok kwaklipanu umu moneken nyenekok ali okwok dakio kwanaki kwasusuhw ananih luseh ali ahudak atuh wata kwanubu yopuk umu. ");
INSERT INTO apeB_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Ali Jisas naklipok nakli, “Nugawik, nyak nyenek bilip nyakli yek dodogowiweli ali nyak dakio yopinyu. Douk namudak ali nyak nyunak ali nyakihw apahw hwulu kalbu.” ");
INSERT INTO apeB_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Ali douk Jisas wata nape neyagwleh ati ali ananu napeli Jairas ananitu wilpat uli nanaki naklipu Jairas nakli, “Jairas, nyakik nugawik akwanubu kwagak. Douk namudak ali nyak kobi nyukanu moul Jisas umu nunaku nyakitu wilpat umu.” ");
INSERT INTO apeB_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Wakuli Jisas nemnek namudak ali naklipu Jairas nakli, “Nyak kobi elgeinyu, wak. Nyak nyunek bilip atin ali nyakik nugawik eke wata kwaitak kupe.” ");
INSERT INTO apeB_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Ali Jisas nanak aliga natoglu Jairas ananitu wilpat ali naklipu Pita nanu Jon uli Jems atum hanu okudak kwagak uli okwokich mamechich atich chanamanu chawich numun. Kipaichi chapeik aduk. ");
INSERT INTO apeB_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Ali chanatimaguk chape agnabuk uli chape chelepu okudak kwagak uli almatok. Wakuli Jisas naklipech nakli, “Ipak kobi puleh, okudak wo kugak e. Okwok kwechuhw meyoh!” ");
INSERT INTO apeB_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Douk anan naklipech namudak wakuli chanatimaguk chadukemech umu okwok douk akwanubu kwagak. Namudak ali echech cheyakasunu. ");
INSERT INTO apeB_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Wakuli Jisas nanu ananim 3-poleim disaipel hanu okwokich mamechich chanak chawich numun ali anan nasuh okwokin logul nokuhul ali nakli, “Batowin, nyak kitak!” ");
INSERT INTO apeB_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Wakuli michin nyanubu nyakih nyawichok ali ahudak atuh okwok kwanubu kwaitak kwape. Ali Jisas naklipech umu chukok enech kakwich. ");
INSERT INTO apeB_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Ali douk okwok kwaitak kwape ali okwokich mamechich chanubu loguhw hwonechlukech. Wakuli Jisas naklipech dodogowinyi balan umu echech kobi chunak chuklipu enech elpech umu agundak anan nohul echechik nugawik kwaitak kwapemu. ");
INSERT INTO apeB_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Ali Jisas nohwalu ananim 12-poleim disaipel hanaki heyotu atugun, ali nakam namba uli pawa umu huhiyahuk sagabehas. Ali chopuk, umu hugabe anagali anagu sik douk gape elpech uli. ");
INSERT INTO apeB_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Douk anan naklipam julug ali nakagam hanak umu huklipech yopinyi balan umu agundak God nape nebenalimu ananich elpech umu ali hugabe agasudak sachi. ");
INSERT INTO apeB_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Ali anan naklipam chopuk nakli, “Ipak punak ahudak yah umu, ipak kobi punosuh enep butip o ichaluh sunu kakwich uli utabal o eneh alagun luseh, wak. ");
INSERT INTO apeB_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Ali punak anabul wabul ali ablabuk wabulich elpech chukli wasik umu chukepu anatu wilpat umu pichuh umu, ipak punak pupe atabuk atutu wilpat. Ipak pupe aliga meihi nyumnah pukli putukemaguk ablabuk wabul punak umu, ali ipak adakio putukemataguk. ");
INSERT INTO apeB_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Ali sapos punak anabul wabul ali kobi chumnekepu ali kobi chukepu anatu wilpat umu pichuh umu, ipak putukemaguk ablabuk wabul ali punak. Ipak pitak pugudupechuk ipluk kwataku ipakiluh yaliluh uli kwukusuk ablabuk wabul ali punak. Ipak punek namudak umu echech chutulipu ali eke chudukemech umu echech douk achenek yowenyi ali God eke nunekumech nebetali kwot.” ");
INSERT INTO apeB_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Ali amam haitak hape haklipech God ananin yopinyi balan hanak atubul ati walub. Ali chopuk, hagabe wolobaichi agusudak sachi elpech. ");
INSERT INTO apeB_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Ali king Herot douk nape nebenalimu gavman umu provins Galili uli nemnek umu chanatimaguk echudak douk chape chatogluli ali anan nogolu nogolu nape. Umu moneken, anan nemnek umu enech elpech chakli, “Ati Jisas eke Jon douk Nenek Baptaisumech uli. Anan douk nagak wakuli wata naitak nape!” ");
INSERT INTO apeB_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Ali enech chakli Ilaija douk seiwak nagak uli anan wata naitak nape. Wakuli enech chakli ananu kipainali seiwakinali profet wata naitak nape. ");
INSERT INTO apeB_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Echech douk chakli namudak, wakuli Herot nakli, “Yek ayoble Jon ananik lobik ali anan anagak. Wakuli nameitu anudak meinali douk yek yemnek umu anan nape nenek enenyi enen dodogowinyi moul uli?” Douk namudak ali anan nape nabilak umu nakli nutik Jisas. ");
INSERT INTO apeB_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Ali Jisas ananim aposel wata hatanamali ali haklipanamu echudak amam henekech uli. Ali anan nalmom ali amam atum haitak hanamu wabul Betsaida. ");
INSERT INTO apeB_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Wakuli wolobaichi elpech chemnek umu Jisas nanak nape agnabuk umu, ali echech chagipechanu chanak. Echech chanak chatoglomanu ali anan nenehilaumech umu agundak echech chanak umu. Ali anan nape naklipech balan umu chuwich umu agundak God nape nebenalimu ananich elpech umu. Ali chopuk, nagabe echebuk douk agasudak sachi. ");
INSERT INTO apeB_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Douk echech chape aliga aun nape nabih ali Jisas ananim 12-poleim disaipel hanaki haklipanu hakli, “Nyak anyukagech chunamu walub douk blape halakatimu nahabigas ulimu chunak chunatimu kakwich umu chichah uli. Ali chopuk umu chunatimu wilag umu chichuh umu. Umu moneken, agundak apak mapeik wohigunmu, elpech wak umu.” ");
INSERT INTO apeB_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Wakuli Jisas naklipam nakli, “Ipak yet pukech enech kakwich.” Ali amam haklipanu hakli, “Apak masuhwi 5-poleitu bret tanu bias yelbus meyoh. Wo nyakli apak munak mutalumechi enech kakwich echudak wolobaichi elpech?” ");
INSERT INTO apeB_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Ali almam atum douk 5,000 poleim. Ali almagou uli batowich wo chudalehech e. Ali Jisas naklipu ananim disaipel umu huklipech umu halakatimu 50-poleich chunak chupe sik, ali enech alagun halakatimu 50-poleich chupe sik. Echech chupe namobuk ati chunak.” ");
INSERT INTO apeB_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Ali amam haklipech ali chanatimaguk chabih chape atap. ");
INSERT INTO apeB_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Douk chabih chape ali Jisas nohul atudak 5-poleitu bret tanu asudak bias yelbus nahwech ali nanigu natik iluh heven. Ali nenek beten nenek tenkyumu God. Douk nenek tenkyumanu julug ali nagwuduk atudak 5-poleitu bret uli yelbus noku ananim disaipel ali amam hape halogech hanak. ");
INSERT INTO apeB_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Douk halagech ali chanatimaguk chachah aliga dugolech ali chakusuk uli, amam hatulichech hechluk 12-poleig basketog chichuknig ali hechebuk chakus. ");
INSERT INTO apeB_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Anah nyumnah Jisas atunu nape nenek beten. Ali ananim disaipel chopuk hananu hape ali anan nasolikam nakli, “Ipak pemnek elpech chakli yek meiweli?” ");
INSERT INTO apeB_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Ali amam haklipanu hakli, “Enech chakli nyak douk Jon douk nenek baptaisumech uli, ali enech chakli nyak Ilaija. Ali enech chakli nyak ananu kipainali seiwakinali profet douk seiwak nagak wakuli nameitu wata naitak nape uli.” ");
INSERT INTO apeB_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Ali anan nasolik amam nakli, “Ali ipak yet pakli malmu? Ipak pakli yek meiweli?” Ali Pita naklipanu nakli, “Nyak Krais douk God natalihenyu ali nakagenyu nyanamali nyunalau elpech uli.” ");
INSERT INTO apeB_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Ali Jisas naklipam dodogowinyi balan ananim disaipel umu kobi hunak huklipu enech elpech umu anan douk Krais umu, wak. ");
INSERT INTO apeB_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Ali Jisas balan nyeilen nakli, “Yek Anudak Alman douk yataglu aduligeinyi elpen uli eke imnek nebehi nyih. Ali echech Juda echechim nebemi hunu amam nebemi pris hunu amam henek skulumech umu lo uli eke huke agabus ali huneke anagu anagu. Ali eke che igak ali chunugome ilu iwagu bieh nyumneh. Ali douk huklimu bieh atuh nyumneh umu, God eke wata niyahuli itak ipe.” ");
INSERT INTO apeB_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Ali naklipu hanatimaguk ananim disaipel nakli, “Sapos enen elpen nyukli nyugipech yek umu, enyen imas nyunubu nyukli wak umu enyen kobi nyugipech enyenyin laik. Ali wihluwehlu enyen imas nyusah enyenyin lowag kruse ali nyugipeche. ");
INSERT INTO apeB_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Umu moneken, echebuk elpech douk echechip ulkwip kobi pulomu yek ali chukli chunagabe echechiluh atuluh yegechiweluh ali echech elgeich umu chugak umu, echech eke chunubu chugak chunak chuwichuk. Wakuli echebuk douk echechip ulkwip pulomu yek ali kobi elgeich umu kipaichi chech chugak umu agundak chagipech yek umu, echech eke chupe kalbu eheh nyumneh. ");
INSERT INTO apeB_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Sapos ananu alman nunek moul ali nulau chunatimaguk apudak atapichi echudak, wakuli kwali anan nugak ali nunubu nunak nuwichuk umu, chunatimaguk echudak eke chugakamanu malmu? Aduligu atugu eke wak! ");
INSERT INTO apeB_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Ali sapos nameitu enen elpen elgein umu kipaichi elpech ali nyukli enyen douk wo yekin disaipel e, ali chopuk nyukenyuk agab yekin balan umu, kwali yek Anudak Alman douk yataglu aduligeinyi elpen uli eke ikli enyebuk elpen douk wo yekin e, wak. Ali ababuk nyultab yek dodogowiwe ali ihiyatiki kobi douk yekinu Aninu nanu ananich yopichi enselahas chahiyatik umu inaki abali, yek eke iklipen ikli enyen douk wo yekin e. ");
INSERT INTO apeB_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Aduligu atugu yek yaklipepu, ipak enepu douk nameitu peyotu agundak uli eke kobi kebes pugak ali eke putik abudak nyultab God nupe nebenalimu ananich elpech umu.” ");
INSERT INTO apeB_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Douk Jisas nakliyuk enyudak balan ali 8-poleih nyumneh hanak hadiyuk, ali anan nalmu Pita nanu Jon uli Jems hanak halto ananu maunten umu anan nunak nunek beten. ");
INSERT INTO apeB_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Ali douk anan nape nenek beten wakuli ananin domanyu nyanubu nyenek senis nyatoglu anagun sik. Ali ananih luseh hanubu hatoglu chagalihwih ali hahiyatik kobi douk utagu bagalogu gahiyatik umu. ");
INSERT INTO apeB_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Ali ahudak atuh biam almam hatoglu heyotu hananu hape heyagwleh. Amam douk Moses uli Ilaija. ");
INSERT INTO apeB_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Amam chopuk douk hanubu hahiyatik ali heyotu hanu Jisas hape heyagwleh umu agundak eke anan niyatak enyudak moul God nakaganu nanakumali nuneken ulimu nugak Jerusalem umu. ");
INSERT INTO apeB_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Ali Pita nanu amudak anam biam douk hape henechle-paluli yobus asahwom dudigu ali hechuh hagak. Wakuli amam wata haitaki hatik agundak Jisas dodogowinu ali nahiyatik umu nanu amudak biam douk hananu heyotu uli. ");
INSERT INTO apeB_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Ali douk amudak biam hatukemaguk Jisas hape hanak wakuli Pita naklipu Jisas nakli, “Diginyali, agagun douk kalbamu apak mape agundak umu. Namudak ali apak muwemu biou otuk chomeguhwiyu. Nyak onok ali biowomu Moses uli Ilaija.” Ali agnabuk Pita douk wo nudukemech e, umu eke nuklipanu moneken balan Jisas. Douk namudak ali anan dakio naklipanu namudak Jisas. ");
INSERT INTO apeB_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Ali douk Pita wata nape neyagwleh ati ali onog olug gwanaki iluh ali abalil lechukalum. Ali Pita nanu amudak biam elgeim umu ogudak olug gwanaki ali abalil lechukalum umu. ");
INSERT INTO apeB_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Wakuli anagu nigu gatoglali ogudak olug ali enyudak nyeyagwlehi uli nyakli, “Anabuk douk nanubu yekinu Nuganinu douk yek yanatalih-analuli. Ipak pumnekanu!” ");
INSERT INTO apeB_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Ali douk enyen nyeyagwlehi julug ali amam hatik umu Jisas atunu neyotuk. Ali amam wo hiyagwleh hukli enen balan e. Ali ababuk nyultab chopuk, amam wo hunak huklipu enech elpech umu echudak amam hatulich uli e, wak. ");
INSERT INTO apeB_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Ali wehluwih amam haitak hatukemaguk anudak maunten hagluki ali wolobaichi elpech chanaki chogwatu Jisas yah. ");
INSERT INTO apeB_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Ali ananu alman douk nanu echudak elpech cheyotu uli nohwalu nakli, “Tisa tik, yek yanalak yelimenyamu nyunaki nyutik yekinu nuganinu. Yek douk nanubu anudak atunu nuganinu! ");
INSERT INTO apeB_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Anan owotu tapenyunu ali ahudak atuh nohwalu nebegun. Ali atat tatukanu tonoul atap ali alpus sakih sagluk wibulwobul ananitu yokwatu. Atat tape tasaganu ali wo tutukemanaguk tutoglu tunakuk e, wak. ");
INSERT INTO apeB_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Ali yek yaklipu nyakim disaipel umu huhiyah-ataguk wakuli amam habilak wak.” ");
INSERT INTO apeB_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Ali Jisas nakli, “Ipak doumeipali elpech, yek yanepu mape loubamu nyultab ipakilub walub wakuli ipak wo punek bilipume e. Ali ipak pakli yek eke wata inepu mupe eneh alagun nyumneh umu igakamepu namudak atimu isah enenyi enen ipakin hevi waka?” Ali anan naklipu anudak alman nakli, “Nyak lawali nyakinu nuganinu!” ");
INSERT INTO apeB_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Ali anudak owotu tapenyunali wata nape nanaki ati ali atat tatukanu tonoul atap. Wakuli Jisas nahatu ali tatukemanaguk tatoglu talhwas. Douk Jisas nagabeyanu ali wata naklipu ananinu aninu nakli, “Nyakinu nuganinu anudak.” ");
INSERT INTO apeB_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Ali chanatimaguk elpech chatik enyudak dodogowinyi moul God neneken uli ali echech chanubu loguhw hwonechlukech. Ali echech ulkwip wata pape polomu enyudak Jisas neneken uli ali anan naklipu ananim disaipel nakli, ");
INSERT INTO apeB_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Ipak pugamu pumneken kalbu enyudak balan douk nameitu yakli iklipepeyen uli! Elpech eke chugilapu yekim birua umu yek Anudak Alman douk yataglu aduligeinyi elpen uli ali eke dodogowim atum huhwe hunak huwechike.” ");
INSERT INTO apeB_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Ali douk naklipam enyudak balan wakuli amam wo hudukemu bawogen umu e. Bawogen umu balan douk nyanabechukumom ali amam elgeim umu husolikanamu. ");
INSERT INTO apeB_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Ali amam disaipel hape halpak balan umu amam meinali eke nupe nebenalimu amam. ");
INSERT INTO apeB_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Wakuli Jisas douk anadukemu amamip ulkwip polu panak umu ali nasuhi enen batowin nyanaki nyananu nyeyotu. ");
INSERT INTO apeB_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Ali anan naklipam nakli, “Sapos enen elpen ulkum mulomu yek ali nyugakamu enyudak batowin umu, enyen douk nyagakamu yek. Ali douk namudak ati, enyebuk elpen nyagakamu yek uli douk nyagakamu anudak douk nakagasi yek yanaki uli chopuk. Ali meinali olokohun umu ipak nameitu peyotu agundak uli yeul nyanubu wakanaluli eke anabuk nupe nebenalimu ipak.” ");
INSERT INTO apeB_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Wakuli Jon naklipu Jisas nakli, “Nebenyali, apak matik ananu alman nape nahiyahuk sagabehas umu nyakin yeul ali echech chatoglu chalhwasuk. Wakuli apak maklipanamu anan kobi wata nunek namudak, wak. Umu moneken, anan douk wo nugipech apak uli e. ");
INSERT INTO apeB_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Wakuli Jisas nakli, “Ipak kobi puklipanu namudak, wak. Umu moneken, echebuk douk chagakome-paluli douk chanaguk ipak.” ");
INSERT INTO apeB_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Ali douk eheh nyumneh hape hanak halakatimu God wata nulau Jisas nunamu iluh heven umu. Ali Jisas nanubu nakli nunamu Jerusalem, ali anan naitak nanak. ");
INSERT INTO apeB_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Anan wata nape nagikuk ali nakagas enech elpech chalau balan chalik. Echech chanak chawich anabul chokubuli wabul douk blape Sameria ulimu chugabemanu echudak umu anan nunak nichuh umu. ");
INSERT INTO apeB_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Wakuli elpech chape agnabuk uli chadukemech umu anan eke nunamu Jerusalem umu nunek lotumu God. Douk namudak ali echech chakli wak umu nunak nunech nichuh umu. ");
INSERT INTO apeB_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Ali douk ananim disaipel Jems uli Jon hatik namudak ali haklipanu hakli, “Diginyali, nyak nyakli apak muhwalu nyih hugluki iluh heven hunich waka nyakli malmu?” ");
INSERT INTO apeB_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","56","Wakuli Jisas natanamu naham ali amam wata hanamu kipaibuli wabul. ");
INSERT INTO apeB_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Douk amam hanak yah ali ananu alman naklipu Jisas nakli, “Ihagun nyak nyunak umu, yek eke inamenyu wunak.” ");
INSERT INTO apeB_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Ali Jisas naklipanu nakli, “Wanalig nubag isave gwechuh hulusigwiluh. Ali almiguh hwehilau iluh uli isave hwechuh was. Wakuli yek Anudak Alman douk yataglu aduligeinyi elpen uli wilpat wakemu inak ichuh umu. ");
INSERT INTO apeB_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Ali Jisas wata chopuk naklipu kipainali nakli, “Nyak yowi nyugipech yek.” Douk anan naklipanu namudak ali anudak alman nakli, “Diginyali, yek yakli nyuklipe inak inugamaguk yekinu aninu iyuh ali adakio inaki inamenyu wunak.” ");
INSERT INTO apeB_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Wakuli Jisas naklipanu nakli, “Nyak bukeyechuk chagak uli, kadak echebuk douk wo chunek bilip umu yek uli e chunak chunugomech. Wakuli nyak nyunak nyuklipech yopinyi balan umu agundak God nape nebenalimu ananich elpech umu.” ");
INSERT INTO apeB_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Ali ananu chopuk nanaki naklipu Jisas nakli, “Diginyali, yek yakli igipechenyu wakuli yek yakli inak ikechuk logul apak atup awilop umu iyuh.” ");
INSERT INTO apeB_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Wakuli Jisas naklipam nakli, “Douk ananu alman nukli nuhul yekin moul nuneken wakuli anan wata ulkum mulamaguk enechi enech echudak anan natukemechuk ulimu, anan douk wo nunokwnumu nuwich umu agundak God nape nebenalimu ananich elpech umu e, wak.” ");
INSERT INTO apeB_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Douk enyudak nyanakuk ali Diginali wata natalih 72-poleim almam alagun ali nakagam hanak biam biam. Anan nakagam halik hanak ihalub walub douk anan nakli nunakalubi. ");
INSERT INTO apeB_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Ali anan naklipam nakli, “Wolobaichi kakwich chasu chape, wakuli elpech chusagunmech uli douk gwodich. Douk namudak ali ipak punek beten umu Diginali douk neglemu agudak nahabigalulimu nukagas wolobaichi elpech umu chunak chusagunmu echudak kakwich. ");
INSERT INTO apeB_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Ipak punak, yek eke ikagepu punak kobi douk sipsip douk wo dodogowich uli e, punak olokohun umu wanalig nubag. ");
INSERT INTO apeB_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Ali ipak kobi punoluk anas paus douk ipak pape panaluk utabal umu sunu ichaluh uli su. Ali ipak punak wisnabul, ipak kobi piyotu punu enech elpech douk pugwatech yah uli piyagwleh, wak. ");
INSERT INTO apeB_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Ali douk punak puwich anatu wilpat umu, susubuati ipak imas pulik pukli, ‘Apak makli ipak pape atudak wilpat uli ipakiluh apaluh hlulu kalbu.’ ");
INSERT INTO apeB_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Ali sapos ananu yopunali alman nupe atabuk wilpat umu, enyebuk balan ipak paklipaneyen uli eke nyunanu nyupeik. O wak umu, enyebuk yopinyi balan eke wata nyutanamali nyupemu ipak yet. ");
INSERT INTO apeB_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Ali ipak pupe atabuk atutu wilpat ali puwak echebuk kakwich uli abal echech chukepeyech uli. Umu moneken, ipak penek God ananin moul ali dakio chatalipu chekepu echebuk kakwich. Ali ipak kobi pupe anatu wilpat ali wata pitak punamu kipaigwi, wak. Ipak punubu pupe atabuk atutu. ");
INSERT INTO apeB_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Ali douk punak anabul wabul ali enech elpech chulawepu punamu echechig wilag ali chunek enech kakwich chukepamu, echebuk kakwich ipak imas pichah. ");
INSERT INTO apeB_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Ali pugabe agasudak sachi douk chape ablabuk wabul uli. Ali puklipu elpech chape agnabuk uli pukli, ‘Nyultab douk abanaki halakatimu God nupe nebenalimu ipak ananipu elpech umu.’ ");
INSERT INTO apeB_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","11","Wakuli sapos punak anabul wabul ali elpech chape agnabuk uli chukepaguk agabus umu, ipak punak piyotu yah ali pukli, ‘Okudak ipluk apak malikwechok ipakibul wabul uli okudak wata magudupechok kwakus-umepaguk. Apak monek namudak umu ipak putulupu ali ipak ulkwip pulomu enyudak. Nyultab douk abanaki halakatimu God nupe nebenalimu ananich elpech umu.’ ");
INSERT INTO apeB_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Yek yaklipepu, ahabuk nyumnah God nunaki nunemech balan chunatimaguk elpech ahi, elpech douk seiwak chape Sodom uli eke chumnek nebehi nyih kwalowi ati. Wakuli echebuk douk chokepaguk agabus ipak uli eke chunubu chunamnek nebehi nyih!” ");
INSERT INTO apeB_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Ali Jisas balan nyeilen nakli, “Mapilipu ipak elpech pape Korasin blanu Betsaida uli. Ipak eke pumnek nebehi nyih ali eke punubu pupe sisahw! Umu moneken, seiwak sapos ananu alman anunek enen God atunu neneken uli moul gani Taia uli Saidon kobi douk yek yeneken ipakilub walub umu ele, echech deke aseiwak chutukemaguk yowenyi ali chutanamu chukanu apaluh God. Ali echech deke chitak chusak yowehi luseh ali chichlokuh algabus umu chugilapech umu echech douk achekenyuk agabus yowenyi! ");
INSERT INTO apeB_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Ali ahabuk nyumnah God nunaki nunemech balan chunatimaguk elpech umu, hevi douk eke nyutoglomu ipak Korasin punu Betsaida uli eke nyunubu nyichalakuk enyebuk douk eke nyutoglomu echebuk douk seiwak chape Taia blanu Saidon uli. ");
INSERT INTO apeB_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Ali ipak Kapaneam chopuk, ipak pakli eke God nukli wasik ali nulawepu pulto iluh heven waka? Wak. God eke nuwachepu pugluk chagak uli chanak chapemu!” ");
INSERT INTO apeB_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Ali Jisas naklipu ananim disaipel nakli, “Echebuk douk chumnek ipak uli douk chemnek yek. Ali echebuk douk chekepu agabus ipak uli douk cheke agabus yek. Ali chuke agabus yek uli douk chakanu agabus anudak douk nakagasi yek yanaki uli.” ");
INSERT INTO apeB_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Douk amudak 72-poleim almam wata hatanamali ali amam hanubu henehilau. Ali amam hakli, “Diginyali, apak manak mahu sagabehas douk chawich chape elpech uli maklipech umu nyakin yeul ali echech chanahwo-gamapu chatoglu chalhwas.” ");
INSERT INTO apeB_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Ali Jisas naklipam nakli, “Adul, yek yatik Satan wo dodogowinu e ali natukemaguk iluh heven nagluki kobi douk utagu bagalagamu. ");
INSERT INTO apeB_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Ipak mnek. Yek douk ayekepu namba uli pawa umu pulikwech idulguh uli pupiyagwial chunu nyunatimaguk pawa apakinu birua Satan ananin. Ali ipak eke kobi enech yowechi echudak chunekepu, wak. ");
INSERT INTO apeB_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Ali ipak kobi punehilaumu agundak sagabehas chemnek ipakin balan umu, wak. Ipak imas punehilaumu agundak God anowemu ipakich yeguh chetemu iluh heven umu.” ");
INSERT INTO apeB_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Ali ababuk nyultab God ananin Michin nyenek Jisas nanubu nenehilau ali nakli, “Yekinyu Aninu, Diginyalimu iluh atap uli! Yek yenehilau ali yatuk nyakin yeul nyakih. Umu moneken, nyak nyobechuk bawogen umu nyakin pasin uli balan umu echudak elpech douk chakli echech chanubu chadukemech ali chalau wolobainyi save uli. Wakuli nyak wata nyagilapu echudak kobi douk chokwichi batowich ulimu. Adul Aninu, nyak douk nyagipech nyakin atin laik ali nyenehilau nyenek namudak.” ");
INSERT INTO apeB_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Ali anan balan nyeilen nakli, “Yekinu Aninu douk aneke ihechumali echudak. Ali wak enech elpech chudukemu yek ananiwe nuganinu e, wak. Aninu atunu nadukeme. Ali chopuk, wak enech elpech chudukemu Aninu e, wak. Yek ananiwe nuganinu yanu echebuk douk yek yakli igilapech-analuli atupu madukemanu.” ");
INSERT INTO apeB_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Ali Jisas natanamali natik umu ananim disaipel atum heyotu ali naklipam nakli, “Echebuk elpech douk chatik enyudak moul douk yek yeneken patulin uli, echech douk achenehilau! ");
INSERT INTO apeB_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Umu moneken, yek yaklipepu, wolobaimi profet hanu wolobaimi king hakli hutik enyudak moul ipak patulin uli wakuli wak. Amam hakli humnek enyudak balan ipak pemneken uli wakuli wak.” ");
INSERT INTO apeB_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Anah nyumnah ananu nenek skulumech umu lo douk seiwak God nakaguk Moses enyi nanak ali nakli nichakamu Jisas. Ali nasolikanu nakli, “Nebenyali tisa, yek eke inek moneken ali eke dakio ipe kalbu eheh nyumneh?” ");
INSERT INTO apeB_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Ali Jisas naklipanu nakli, “Nyak nyatik God ananin lo nyaklipenyu malmu? Ali chopuk nyak nyenyanamu malmu?” ");
INSERT INTO apeB_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Ali anudak nenek skulumech umu lo uli nakli, “Ipak imas ulkwip punubu punosuh God. Ali ipakiluh apaluh hlunu ipakich michich chunu ipakin tinytin imas chunubu chunosuh Diginali ipakinu God anan atunu ali pukwu nyunatimaguk ipakin strong umu punek ananin moul. Ali chopuk, ipak ulkwip imas punubu punosuh echebuk douk chape halakatimu ipak uli ali pugakamech kobi douk ipak ulkwip panosuh ipak yet umu.” ");
INSERT INTO apeB_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Ali Jisas nakli, “Nyak nyakli wasik. Nyak eke nyunek namudak ali nyak eke nyupe kalbu eheh nyumneh.” ");
INSERT INTO apeB_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Wakuli anudak nenek skulumech umu lo uli nakli Jisas nutulunu nuhwalanu duldulinali. Douk namudak ali anan nasolik Jisas nakli, “Ali echudak chape halakatimu yek uli douk meichi?” ");
INSERT INTO apeB_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Ali Jisas naklipanu enyudak woblen balan nakli, “Ananu alman nape Jerusalem ali naitak naglumu Jeriko. Anan nanak yah ali yowemi almam douk hakwu aluh atuh uli hogwatanu ali hanu henekanu atuhigu ali anan halakatimu nugak. Ali amam hanabuk nakusuk ali hatulunu honowal ananih luseh hanu echudak anan nanohwech uli hanohwech ali hanak. ");
INSERT INTO apeB_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Ali ababuk nyultab ananu pris nagimu yah nanak. Anan nanak natulunu wakuli nanubu nechalakanu nanakuk woblahahih umu yah ali nanubu nanak. ");
INSERT INTO apeB_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Douk anan nanakuk ali ananu Livai douk nagakamu amam pris uli chopuk nanaki nanak neyotu natulunu ali nanak woblahahih umu yah ali nechalakanu nanak. ");
INSERT INTO apeB_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Douk anan nanakuk wakuli ananu Sameria nanak natoglu agundak anan nakus umu. Ali anan natulunu wakuli anan amatog gwanubu gwagak umu anudak Juda. ");
INSERT INTO apeB_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Douk namudak ali anan nanak halakatimu anan ali nenyukul wel uli wain ebudak eleb iyuh ali nowechikeb. Douk nowechikumanu eleb julug ali nanahul nonowemu ananin donki ali nalawanu nanak. Anan nalawanamu anatu elpech chanak chape chechuhatali wilpat ali nanak nape nenek lukautumanu. ");
INSERT INTO apeB_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Douk hanak hape aliga wehluwih ali anudak Sameria naitak neyak anabal utabal naku anudak neglemu atabuk wilpat uli. Ali naklipanu nakli, ‘Nyak nyupe nyunek lukautumanu. Ali sapos nyak nyukwu anabal nyakibal utabal nyutalumanu enech echudak umu, yek eke itanamali ali ibeyabal-umenyu.’” ");
INSERT INTO apeB_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Ali Jisas nasolik anudak nenek skulumech umu lo uli nakli, “Nyak nyakli malmamu amudak biam atunu. Meinali nagabe anudak douk hakwu aluh atuh uli hanu hanabukuk uli kobi douk nanagabe echebuk douk chape halakatimu anan ulimu?” ");
INSERT INTO apeB_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Ali anan nakli, “Anabuk douk natulunu nenelekanaluli.” Ali Jisas nakli, “Nyak nyunak ali nyunek namobuk ati.” ");
INSERT INTO apeB_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Ali Jisas nanu ananim disaipel hanak. Douk hanak hatoglu anabul wabul ali onok almatok douk kwonohwalamu Mata uli kwalmam chanamu okwokwitu wilpat. ");
INSERT INTO apeB_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Ali Mata okwokwik owawik douk kwonohwalamu Maria uli kwanaki kwape halakatimu Diginali ananiluh yaliluh ali kwape kwomnek ananin balan. ");
INSERT INTO apeB_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Ali Mata otuk kwape kwonek kakwich. Ali okwokwim ulkum molu manak umu echudak douk eke okwok kunekech uli ali okwok nyihihichik. Ali okwok kwanak kwaklipu Jisas kwakli, “Diginyali, yekik owawik kwatukemeik ali yek otuwe yape yenek kakwich. Ali nyak wo ulkum mulomu enyudak ali nyuklipok kunaku kugakome e? Nyak klipok kunaki kugakome!” ");
INSERT INTO apeB_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Wakuli Diginali nakli, “Mata, nyak ulkum molomu wolobaichi echudak ali nyakihw apahw yowehw. ");
INSERT INTO apeB_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Wakuli atin yopinyi pasin nyak wata nyulawen e. Ali Maria douk kwakli kulau enyudak yopinyi pasin. Douk namudak ali eke kobi enech elpech chutulukwenyuk, wak.” ");
INSERT INTO apeB_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Anah nyumnah Jisas nanak nape nenek beten anagun. Anan nenek beten julug, ali ananu ananinu disaipel naklipanu nakli, “Diginyali, nyak nyunek skulumapamu munek beten umu kobi douk Jon douk nenek baptaisumech uli nenek skulumu ananim umu.” ");
INSERT INTO apeB_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Ali Jisas nakli, “Ipak punek beten umu, ipak pukli namudak. ‘Apakinyu Aninu, apak makli chunatimaguk elpech chutuk nyakin yopinyi yeul nyukih, ali wisnabul nyak nyupe Nebenyalimu wolobaichi elpech. ");
INSERT INTO apeB_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Ali nyukapu kakwich umu chunokwnu-mapamu doumeih uli. ");
INSERT INTO apeB_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Apak douk wo munohwen umu yowenyi kipaichi cheneken umu apak uli e. Douk namudak ali nyak kobi nyunohwen umu apakin yowenyi ali nyukwleyenyuk. Ali nyak kobi nyukutuwuk Satan umu nichakamapamu munek yowenyi, wak.’” ");
INSERT INTO apeB_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Ali Jisas naklipu ananim disaipel enyudak woblen balan nakli, “Sapos ipak ananu nunamu ananinu elpenyinu ananitu wilpat olokohunib umu wab ali nukli, ‘Elpenyinu, yek yakli nyuke 3-poleitu bret. ");
INSERT INTO apeB_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Umu moneken, ananu yekinu elpenyinu nameitu ati nanaki nataglome ali yek kakwich wak umu ibilamanamu!’ ");
INSERT INTO apeB_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Wakuli sapos anan nupeli numun wilpat ali nukli, ‘Nyak kobi nyuke moul! Dua amenyalu ali yek yanu batowich amechuh. Ali yek eke kobi itak ikenyu enech echudak, wak!’ ");
INSERT INTO apeB_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Ali deke malmu? Yek yaklipepu, anudak wilpatinali deke kobi nukli anan douk ananinu elpenyinu nanaki nasolikanu ali eke dakio nitak nukanu bret, wak. Anan eke nitak nukanali chunatimaguk echudak anan nasolik-anamech uli. Umu moneken, anan eke ulpusinamu numnek ananinu elpeninyu nupe nusolikanamu. ");
INSERT INTO apeB_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Douk namudak ali yek yaklipepu, ipak imas punek beten pusolik God umu nukepu echudak ali anan eke nukepeyech. Ipak imas pupe putimech ali eke putulich. Ali ipak imas pupe pubo dua ali God eke nijikenyumepu. ");
INSERT INTO apeB_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Umu moneken, echebuk douk chenek beten chasolik God uli, echech isave chalau echudak. Ali echebuk douk chape chatimu echudak uli isave chatulich. Ali echebuk douk chupe chubo dua uli God eke nijikenyumech. ");
INSERT INTO apeB_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Sapos ipak ananu ananinu nuganinu nusolikanamu nukanu anap yelbup ele, anan deke nitak nukanu enen idul waka? ");
INSERT INTO apeB_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","O deke nusolikanamu nukanu anab ihlub ali nitak nukanu onok pupiak? Aduligu atugu deke wak. ");
INSERT INTO apeB_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Ali ipak douk panubu yowepali adulipu, wakuli ipak douk padukemech umu pukech yopichi echudak ipakich batowich umu. Wakuli apakinu Aninu nape iluh heven uli douk nanubu yopuyopunali ali eke nunubu nukech ananin Michin echebuk douk chunek beten chusolik-analuli.” ");
INSERT INTO apeB_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Ali Jisas nahiyahuk enen sagabu douk wo nyiyagwleh ati uli e. Enyen douk nyape ananu alman ali nyenekanu wo niyagwleh ati e. Douk enyen nyatoglu nyalhwasuk ali anudak alman nanubu nape neyagwleh. Ali wolobaichi elpech loguh hwonechlukech ali chape chanasolikagas umu. ");
INSERT INTO apeB_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Wakuli enech chakli, “Anabuk enyudak Bielsebul douk nebenyumali chanatimaguk sagabehas uli nyenekanu dodogowinu ali dakio nahiyahuk echudak enech sagabehas chatoglu chalhwas.” ");
INSERT INTO apeB_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Ali enech chakli chichakamanu. Douk namudak ali echech chaklipanamu nunek enen God atunu neneken uli moul umu chudukemech umu anan douk adul God nakaganu nanaki uli. ");
INSERT INTO apeB_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Wakuli Jisas anadukemu echechip ulkwip polu panak umu ali naklipech nakli, “Enech elpech chape atin kantri uli chunadiyagulmu chunek biab lainab ali echech yet chupe chulpak ele, echech deke kobi dodogowich. Ali anagu nyulgu chukli chunadiyagulmu ali echech yet chupe chulpak ele, echech chopuk deke kobi dodogowich. ");
INSERT INTO apeB_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Ali douk namudak ati, sapos Satan ananich chunadiyagulmu ali echech yet chupe chulpak ele, echech deke kobi dodogowich. Yek douk yaklipepu enyudak balan umu moneken? Ipak pakli Bielsebul nyagakome ali yek dakio yahiyahuk echudak enech sagabehas. ");
INSERT INTO apeB_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Sapos Bielsebul nyagakome ali dakio yahiyahuk sagabehas umu, ipak pakli malmamu ipakim douk hagipech ipak uli? Amam omuni nyakam strong ali dakio hahiyahuk sagabehas? Ipakim douk ahagilapepamu enyudak balan ipak paklien umu Bielsebul nyagakomemu douk wo adulin e. ");
INSERT INTO apeB_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Yek douk God noke strong ali yahiyahuk sagabehas. Douk namudak ali nameitu ipak douk apatik God ananin strong umu agundak anan nape nebenalimu ananich elpech umu. ");
INSERT INTO apeB_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Ali sapos ananu dodogowinali alman nusuh ananigas bulawas nupe nunek was umu ananitu wilpat umu, ananich echudak eke chukusumanu kalbu. ");
INSERT INTO apeB_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Wakuli sapos ananu nunubu dodogowinali nichalakuk anan uli nunaki nunanu hulpak ali nonu ele, anan deke nunatulunu ananigas bulawas douk anan nawogeyagas uli. Ali anan eke nutulunu nukumechi aluh echudak ananich ali nunak niyaisech umu kipaichi elpech. ");
INSERT INTO apeB_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Echebuk elpech douk wo yekich uli e, douk yekich birua. Ali echebuk douk wo chugakomemu mulawali elpech chunakumali yek uli e, echech douk chapemu chenek yekich elpech chatukemeik chanakuk atin atyiuk.” ");
INSERT INTO apeB_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Ali Jisas balan nyeilen nakli, “Ababuk nyultab enen sagabu nyutukemaguk enen elpen nyutoglu nyunak umu, enyen eke nyunak nyutimu anagun abal wak umu nyunak nyupemali wikap. Ali sapos enyen kobi nyugwatu anagun umu, enyen eke nyukli, ‘Yek wata itanamu inamu yekitu wilpat douk likuk yapenyutali.’ ");
INSERT INTO apeB_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Ali enyen wata nyanak ali nyatik umu atudak wilpat achagitatu ali yoputu tape. ");
INSERT INTO apeB_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Ali enyen nyanak nyalmali echudak enech 7-poleich yowechi sagabehas douk chanubu yowechi chechalakuk enyen uli. Echech chanaki ali chawich chape atudak wilpat ali likuk enyebuk elpen nyape yobelu kwalowi ati. Wakuli nameitu enyen eke nyunubu nyupe yobelu nyichalakuk likuk nyalik nyapemu.” ");
INSERT INTO apeB_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Douk Jisas naklipechuk enyudak balan julug ali onok almatok douk kwanu echudak wolobaichi elpech kweyatu uli kwaklipanu kwakli, “Okwobuk almatok douk kwenyalali ali kwokenyu nyumeb uli okwok douk kwonehilau!” ");
INSERT INTO apeB_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Wakuli Jisas nakli, “Enyen adul, Okwok kwonehilau. Wakuli echebuk elpech douk chumnek God ananin balan chuhwen chugipechen uli echech douk chanubu chenehilau.” ");
INSERT INTO apeB_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Douk enech alagun wolobaichi elpech chanaki chowachabal chape ali Jisas naklipech nakli, “Ipak doumepali elpech douk yowepali! Ipak pakli putik enen moul God atunu neneken uli, wakuli yek eke kobi igilapepu enen, wak. Yek eke igilapepu enyudak Jona ananin atin. ");
INSERT INTO apeB_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Seiwak God nakagas Jona nanak Ninive naklipech God ananin balan chape Ninive ulimu chukenyuk agabus yowenyi ali chutanamu chukanu apaluh God. Ali yek chopuk eke iklipepeyen namudak ati. Douk namudak ali yek Anudak Alman douk yataglu aduligeinyi elpen uli eke ipe kobi douk anagu mag umu ipak doumeipali. ");
INSERT INTO apeB_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Ali ahabuk nyumnah God nunekumech kwot elpech ahi, kwin douk kwapeli saut uli eke kwitak kunekumepu kwot ipak doumeipali elpech umu yowenyi ipak peneken uli. Umu moneken, okwok kwapeli lougun ali kwanaki kwomnek king Solomon ananin yopinyi save. Wakuli nameitu yek douk yanubu yechalakuk king Solomon uli douk yape agundak. ");
INSERT INTO apeB_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Ali ahabuk nyumnah God nunekumech balan elpech ahi, echech chape Ninive uli eke chitak chunekumepu balan ipak doumeipalimu enenyi enen yowenyi ipak pape peneken uli. Umu moneken, echech douk chemnek God ananin balan Jona naklipechenyi ali chekenyuk agabus yowenyi ali wata chakanu apaluh God. Wakuli nameitu yek douk yanubu yechalakuk Jona uli douk yape agundak.” ");
INSERT INTO apeB_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Ali Jisas balan nyeilen nakli, “Deke kobi enen elpen nyuhemu enen lam ali nyitak nyubechuken nyinyiglen chakametamu anatu baket, wak. Enyen deke nyuhemen ali nyinyemu chihah umu kadak elpech chuwichumali chutik agundak enyen nyuglak umu. ");
INSERT INTO apeB_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Ali ipakis nabes douk sape kobi lam umu ipakiluh yegechiweluh. Douk ipakis nabes sutik yopichi echudak ali ipak ulkwip pulomu yopichimu, ipakiluh yegechiweluh eke hluglak ali hlupe kalbu. Wakuli ipakis nabes sutik yowechi echudak ali ipak ulkwip pulomu yowenyimu, ipakiluh yegechiweluh chopuk eke yomotokwehiluh hlupe sisahw. ");
INSERT INTO apeB_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Douk namudak ali ipak imas punenek yologimu ipakis nabes douk sape kobi lam douk nyape numun ipakiluh apaluh uli kobi sutik yowechi ali ipak ulkwip pulomu yowenyi, wak. ");
INSERT INTO apeB_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Sapos ipakiluh chukniluh yegechiweluh hluglak, ali kobi anagun yomotokweh-igun umu, ipak eke punubu puglak kobi douk hanu enyudak lam nyohiyati-mepamu.” ");
INSERT INTO apeB_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Douk Jisas neyagwleh julug ali ananu Farisi nohwalanamu nunak nunanu huwak woligun ananitu wilpat. Ali Jisas naitak nanak nape tebol nananu hapemu huwak woligun. ");
INSERT INTO apeB_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Douk amam hape hawak woligun wakuli anudak Farisi natik Jisas umu wo nugipech echechin lo umu nunokwlupaguk wis iyuh ali adakio nunosuhw kakwich nichah umu e. Ali anan nanubu loguh hwonechlukanu. ");
INSERT INTO apeB_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Wakuli Diginali naklipanu nakli, “Ipak Farisi douk pakwlupu adukahich umu pletog uli kas. Wakuli ipak numunipamu douk panubu pabosusih ali chuknipomu enyudak yowenyi pasin umu panalukech echudak kipaichimu nyanu enenyi enen yowenyi pasin. ");
INSERT INTO apeB_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Ipak pagakali. God douk nenek numunahich umu echudak chanu adukahich umu chopuk. ");
INSERT INTO apeB_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Ipak pukech echudak cholu numun ipakig pletog gwanu kas uli echebuk douk chanahwagagun ulimu pugakamech. Ipak punek namudak ali ipakich echudak eke yopich ali chupe kalbu. ");
INSERT INTO apeB_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Yek yakli mapilipu ipak Farisi, ipak douk peyais yablou wanu lombo chanu ihagu apigu ali pakanu anagunigamu God. Enyudak pasin umu pakanu anagunigamu ipakigu apigu God umu douk wosik. Wakuli ipak wo punek duldulin pasin umu kipaichi e. Ali chopuk, ipak ulkwip wo punosuh God e. Enyen douk wasik umu pakanu echudak God umu. Wakuli ipak imas punek duldulin pasin umu kipaichi chopuk ali ipak ulkwip imas punosuh God alagun. ");
INSERT INTO apeB_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","O panubu mapilipu ipak Farisi, ipak eke punubu pupe sisahw! Umu moneken, ipak panak apak Juda mape meyagwleh balan ogwi wilag umu, ipak pakli punak pupe chakus chalik uli siahas. Ali ipak isave pakli punak wolobaichi chowachabal chapemu umu echech chutulipu ali chunemepu gude. ");
INSERT INTO apeB_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","O panubu mapilipu. Ipak eke punubu pupe sisahw! Umu moneken, elpech wo chudukemu ipakin yowenyi tinytin e, wak. Namudak ali ipak pape kobi douk iwagas matmat douk sanabechuk sape chakamu amnab ulimu. Ali elpech wo chudukemech e ali chape chalahe chihahigas umu.” ");
INSERT INTO apeB_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Ali ananu nenek skulumech umu lo uli nemmek enyudak balan ali naklipu Jisas nakli, “Nebenyali, nyak nyakli namudak ali nyanubu nyechapakapu dodogowinyi balan apak alagun!” ");
INSERT INTO apeB_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Wakuli Jisas nakli, “O panubu mapilipu ipak penek skulumech umu lo uli chopuk! Ipak eke punubu pupe sisahw! Umu moneken, ipak powemeyech nebebusi bugabus wolobaichi elpech chabasusah wakuli ipak wo kwalowi omi pugakamech pubosusah e. ");
INSERT INTO apeB_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","O panubu mapilipu! Ipak eke punubu pupe sisahw! Umu monken, ipakich bahlohim chabo amam profet hagak ali ipak douk pape penek hulusigwiluh umu chunugamam umu. ");
INSERT INTO apeB_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Ipak douk penek namudak ali pagilapu elpech umu ipak pakli wasik umu enyudak yowenyi pasin ipakim bahlohim heneken ulimu habo amam profet hagak umu. Ali ipak pape penek hulusigwiluh umu chunugamam umu. ");
INSERT INTO apeB_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Douk namudak ali God nagipech ananin yopinyi tinytin uli save ali nakli, ‘Yek eke ikagasu profet hunu aposel hunakumechu wakuli echech eke chubo anam hugak. Ali anam eke chom ali chunekam anagu anagu.’ ");
INSERT INTO apeB_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","51","Douk namudak ali ipak doumeipali douk balan nyapenyipamu enyudak yowenyi seiwak ipakim popem yamem hape heneken hanaki uli. Seiwak bawogas umu God nenek apudak atap, amam habo hanatimaguk profet hanaki aliga hataglali nameitu. Enyudak douk seiwak ipakinu yamenu Ken neneken umu nabo ananinu owaninu Abel nagak umu nyanaki aliga ababuk nyultab amam habo Sekaraia nagikuk umu. Sekaraia neyotu olokohun umu alta nyanu God ananitu nebetali wilpat ali amam hanu. Ali ipak peneken uli pasin douk anyagilapu elpech umu ipak douk penehilaumu enyudak ipakim popem yamem heneken uli. Ali God nakli ipak eke pusah sunatimaguk abasudak bugabus ipakim popem yamem amamibus. ");
INSERT INTO apeB_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","O panubu mapilipu ipak penek skulumech umu lo uli. Ipak eke punubu pupe sisahw! Umu moneken, ipak yet wo pukukemu enyudak adulin balan e. Ali chopuk, ipak wo pugakamu echudak almam almagowomu chudukemu enyudak adulin balan e, wak. Douk namudak ali ipak pagahumechuk yah echebuk douk chape chabilak umu chakli chulau yopinyi save uli!” ");
INSERT INTO apeB_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Ali douk Jisas natukemechuk nanak ali amam henek skulumech umu lo uli hanu amam Farisi hanubu nyihihichim ali hape honeyogeyanu sisahw. Ali amam henek loh umu hakli huhwanamu enen balan ali hape hasolikanu wolobainyi enenyi enen balan umu wolobaichi echudak. ");
INSERT INTO apeB_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Amam henek namudak umu hakli humnekanamu nukli enen balan douk wo adulin uli e umu amam hunek kwotumanamen uli. ");
INSERT INTO apeB_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Douk chanubu wolobaichi elpech chanaki cheyotu chuknigun ali chanubu chenek paspas. Ali Jisas nalik naklipu ananim disaipel nakli, “Ipak pugabe punenek yologimu amam Farisi amamis yis. Yek douk yaklimu enyudak amamin pasin umu henek loh umu. ");
INSERT INTO apeB_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Echebuk douk nameitu chechukalich chakus uli, God eke nichlekech chukus yopugunmu ali chunatimaguk eke wata chutulich ali chudukemech. ");
INSERT INTO apeB_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Ali echebuk douk ipak peyagwlepech webus uli, God eke wata nuklipu elpech chumnekumech ali wata chudukemech. Ali echebuk douk ipak panowomu aligas panaklipamumech numun wilag uli, God eke wata nuwolehech. Anan eke nuwolehech ali elpech douk cheyotu iluh wilag uli eke chuklipech umu chunatimaguk chumnekumech.” ");
INSERT INTO apeB_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Ipak yekipu elpech, yek yaklipepu, ipak kobi elgeipamu echebuk douk eke chubo yegechiweluh atuluh hlugak ali kwali kobi dodogowich umu chunek enech yowechi echudak alagun uli, wak. ");
INSERT INTO apeB_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Wakuli yek yakli igilapepu anudak alman douk ipak imas elgeipa-manaluli. Ipak imas punubu elgeipamu God atunu douk eke nepu pugak julug ali kwali chopuk anan douk dadagowinamu wata nukogepu punamu yowebuli wabul hel uli. Aduligu atugu yek yaklipepu, ipak punubu elgeipamu anan! ");
INSERT INTO apeB_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Ipak padukemech, elpech isave chatal 5-poleich chokwichi almiguh umu 2 toia atin. Wakuli God douk wo ulkum mukanaguk umu enen enyudak chokwinyi almin e. ");
INSERT INTO apeB_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Ali ipak God douk anadaleh atubul ati ahilub douk blakih ipakip bogolep uli. Ali anan douk nanubu nadukemepu kalbu. Douk namudak ali ipak kobi elgeipu. God ananim ulkum douk molomu echudak chokwichi almiguh kwalowi ati. Wakuli ipak God douk ulkum manubu manohwepu pechalakuk almiguh. Douk namudak ali anan eke nunubu nunek lukautumepu kalbu.” ");
INSERT INTO apeB_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Yek yaklipepu, sapos enen elpen nyuklipech yopugunmu wolobaichi elpech umu agundak enyen nyape yekin umu, yek Anudak Alman douk yataglu aduligeinyi elpen uli eke iklipech yopugunmu God ananich ensel chapemu umu enyebuk elpen enyenyin yeul. ");
INSERT INTO apeB_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Wakuli enyebuk elpen douk nyuklipech yopugunmu nyukli enyen douk wo yekin uli e, yek chopuk eke inekumen namobuk ati enyebuk elpen gani nabesich umu God ananich enselahas. ");
INSERT INTO apeB_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Sapos enen elpen nyukli enen yowenyi balan umu yek Anudak Alman douk yataglu aduligeinyi elpen ulimu, God wasik eke kobi nunohwen umu enyebuk yowenyi balan enyen nyaklien umu yek uli ali nukwleyenyuk. Wakuli enyebuk elpen douk nyukli enen yowenyi balan umu God ananin Michin uli, God eke nunohwen ali kobi nukwleik enyebuk elpen enyenyin balan enyen nyaklien umu ananin Michin uli. ");
INSERT INTO apeB_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Ali ababuk nyultab chukli chuhwepu chulawepamu apak Juda mape meyagwleh balan ogwi wilag umu, o echech gavman chunu amudak yeguh hwakiham ulimu agundak ipak pagipech yek umu, ipak kobi elgeipu. Ali chopuk kobi pukli, ‘Kedeke munak mubemech balan malmu? O kedeke munak ali mukli moneken balan?’ Wak. ");
INSERT INTO apeB_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Umu moneken, ababuk atubu nyultab ipak pukli piyagwleh umu, God ananin Michin eke nyuklipepu enyebuk balan douk eke ipak puklien uli.” ");
INSERT INTO apeB_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Ananu alman douk nanu echudak wolobaichi elpech cheyotu uli naklipu Jisas nakli, “Nebenyali tisa, yek yakli nyak nyunak nyuklipu yekinu saninu niyaisumohu echudak douk ohwakinu aninu nokwalmech nechebuku-mohwoguk uli.” ");
INSERT INTO apeB_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Ali Jisas naklipanu nakli, “Wak. Yek douk omuni nyaklipemu inek jas umu ipak ali iyaisumepu echudak ipak biepamu?” ");
INSERT INTO apeB_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Ali Jisas wata natanamu naklipu chanatimaguk elpech nakli, “Ipak punenek yologimu ipak kobi piyomech bahas enechi enech echudak. Umu moneken, echebuk douk chonokalmu wolobaichi echudak uli, echechich wolobaichi echudak echech chonokwalmech uli eke kobi chugakomech umu chupe kalbu, wak.” ");
INSERT INTO apeB_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Ali Jisas naklipech enyudak woblen balan nakli, “Ananu nebenali ananigu nahabigu wolobaichi kakwich chasu chape. ");
INSERT INTO apeB_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Ali anan ulkum mape molu manak ali anan ulkum makli, ‘Yek wilpat wak anatu e umu inabuk yekich kakwich umu. Douk namudak ali yek eke inek malmu?’ ");
INSERT INTO apeB_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Ali anan neneyagwleh nakli, ‘Yek eke ichicheh yekig chubukig wilag ali wata ilak nebegwi otug. Ali yek inabuk echudak kakwich chunu enechi enech yekich echudak alagun. ");
INSERT INTO apeB_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Ali yek yet eke ineyagwleh ikli, “Yek wolobaichi echudak chakwusume ali echech eke chunokwnumemu wolobaichi yohwleguh. Douk namudak ali yek eke ipe meyoh ali inehilau ipemu ichah ati!” ’ ");
INSERT INTO apeB_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Wakuli God naklipanu namudak, ‘Nyak nyagakali! Kehik abudak atub wab nyak eke nyugak ali echudak nyak nyonokwalmech nyenechubukuk uli eke omuni nyuglemech?’” ");
INSERT INTO apeB_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Ali douk Jisas naklipechuk enyudak balan julug ali wata chopuk nakli, “Echebuk elpech douk echechip ulkwip punubu pulomu chunokwalmu wolobaichi echudak chunechubuk, wakuli echech ulkwip kobi pulomu God uli, God natulich ananis nabes umu, echech kobi douk chanubu meyaluhich echudak wakechi elpech umu. Echech douk chogugaku kobi douk anudak nagakali alman umu.” ");
INSERT INTO apeB_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Ali Jisas naklipu ananim disaipel nakli, “Yek yaklipepu, ipak apaluh kobi yoweluh umu kakwich ipak pichah uli chunu luseh ipak punenekeh uli, wak. ");
INSERT INTO apeB_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Umu moneken, agundak mupe kalbamu douk gnanubu gnechalakuk kakwich ali yegechiweluh douk hlanubu hlechalakuk luseh. ");
INSERT INTO apeB_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Ipak putik almiguh. Ogwoguhw douk wo hwunou enech kakwich ali hwusagunmech e, wak. Ali ogwoguhw wo hwunalak onog chubukig wilag e. Wakuli God anan yet nape nokoguh kakwich! Ali ipak douk panubu pechalakuk almiguh. Douk namudak ali anan eke nunubu nunek lukautumepu kalbu! ");
INSERT INTO apeB_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Ipak deke meinali apahw hwunubu yowehw umu enechi enech echudak ali anan dakio wata nunek ananih nyumneh hunak lowihi ali nupe loubamu apudak atap? Wak. ");
INSERT INTO apeB_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Ali sapos ipak kobi punokwnumu punek enyudak chokwinyi moul umu, ipak douk ulkwip polomu enechi enech echudak umu moneken? ");
INSERT INTO apeB_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Ipak putik plauahas douk chakih ulah uli. Echech wo chunek enen moul e o wo chunenek eneh luseh umu chihlaluli e, wak. Ali yek yaklipepu, seiwak Solomon douk nanubu yeul nyakihanu ali nokwalmu wolobaichi echudak ali nenenek hanubu yopihi atih luseh. Wakuli ananih luseh douk wak eneh hunubu dudukeh kobi douk echudak plauahas umu e, wak. ");
INSERT INTO apeB_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Aduligu atugu, echudak plauahas douk nameitu chape ali kamanih atuh eke chutupech chunak chichehuk nyih uli douk God nawichahlech. Wakuli ipak elpech douk ipakin bilip wo dodogowin uli e douk panubu pechalakuk echudak plauahas. Douk namudak ali ipak imas pudukemech umu God eke nugakamepu nuwichahlepu luseh. ");
INSERT INTO apeB_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Ali chopuk, ipakiluh apaluh kobi yoweluh umu echudak eke ipak pichah uli. ");
INSERT INTO apeB_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Umu moneken, echebuk douk wo chudukemu God uli e echechip ulkwip douk panubu polomu chanatimu echudakmali atich wihluwehlu. Wakuli ipakinu Aninu douk anadukemech umu echudak ipak tukwahepomech uli. ");
INSERT INTO apeB_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Wakuli susubuati ipak imas ulkwip pulomu pulik puwich umu agundak God nape nebenalimu ananich elpech umu ali anan eke adakio nukepu echudak ipak tukwahepomech uli alagun.” ");
INSERT INTO apeB_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Ipak elpech kobi douk gwodich sipsip ulimu ipak kobi elgeipu, wak. Umu moneken, ipakinu Aninu ananehilaumu ipak puwich umu agundak ananich elpech chapemu ali pupe nebepali. ");
INSERT INTO apeB_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Douk namudak ali ipak pukech ipakich echudak kipachi elpech chutalich chukepu utabal ali piyaisabal umu chanahwagagun umu echudak ulimu pugakamech. Ali agundak ipak pagakamu chanahwagagun uli elpech umu, agagun kobi douk panaluk ipakich echudak asudak paus douk eke kobi yowes ulimu. Umu moneken, agnabuk heven echudak eke kobi chunak chuwichuk ati. Ali amudak hakwu aluh atuh uli eke kobi hunak halakatimu ipakich echudak. Ali tutubich eke kobi chutupech, wak. ");
INSERT INTO apeB_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Ipak imas punabuk ipakich yopichi echudak gani iluh heven. Ali wihluwehlu ipakip ulkwip eke pulomu ablabuk wabul douk ipakich echudak chakus abuli atubul.” ");
INSERT INTO apeB_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Ipak punadalech luseh pihusak baneh ali pulpeheh letog umu pupe punek redimu punek moul. Ali puhemu ipakich lepoguhas ali punek redi pupe pubeyagun umu punek moul. ");
INSERT INTO apeB_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Ipak pupe pubeyagun kobi douk echudak chenek moulaluli chenek gibegabe chape chobeyagunmu echechinu nebenalimu. Anan douk nanak natulich umu anagun woligun douk chenekagun umu biech douk adakio chanasupaluli ali anan eke wata nutanamali. Echech chape chobeyagunmu kadak anan nukli nunaki nubo dua, wakuli ahudak atuh echech chitak chijik-agunmanu. ");
INSERT INTO apeB_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Ali douk nebenali nunaki ali nutik echudak chenek moula-manaluli chupe chunek redi chunak was umu, echech eke chunubu chunehilau. Ali aduligu atugu yek yaklipepu, nebenali anan yet eke nudalech ananih lupah nuhusak nulpehah let ali eke nuklipech chunak chupe ali anan yet eke nukech kakwich. ");
INSERT INTO apeB_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Ali sapos nunaki olokohunib umu o nunaki ababuk nyultab susubeig owotog gwitak umu ali nutulich umu chunek redi chupemu, echech eke chunehilau chulikuk! ");
INSERT INTO apeB_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Ali ipak ulkwip pulamu enyudak! Sapos wilpatinali nudukemech umu ababuk nyultab nakwu aluh atuh uli eke nunaki nukawech ananitu wilpat nuwich umu ele, anudak wilpatinali deke kobi nukutuwanaguk nichichehatu nuwich, wak. ");
INSERT INTO apeB_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Ali ipak chopuk imas punek redi pupe. Umu moneken, yek Anudak Alman douk yataglu aduligeinyi elpen uli eke wata inaki anabu nyultab douk ipak eke pukli yek eke kobi inaki abali.” ");
INSERT INTO apeB_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Wakuli Pita nasolik Jisas nakli, “Diginyali, nyak nyaklipapu enyudak woblen balan apak atupu waka echudak chanatimaguk elpech chopuk?” ");
INSERT INTO apeB_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Ali Diginali Jisas nakli, “Meinali nenek moulaluli nunek ananinu nebenali ananin moul kalbaluli, anabuk eke ananinu nebenali nutunamu nune bosumu echudak enech chenekumanu moulaluli ababuk nyultab anan nunakuk anagun umu. Ali anan eke nukech echechich kakwich ababuk nyultab echech chulau kakwich abali. ");
INSERT INTO apeB_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Ali douk ananinu nebenali nutanamali ali nutulunamu nuneken kalbu kobi douk anan naklipanaguk umu, anudak nenemanu moul uli eke nunehilau! ");
INSERT INTO apeB_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Aduligu atugu yek yaklipepu, ananinu nebenali eke nutulunu namudak ali eke nutunu nupe nebenalimu ihechumali ananich echudak. ");
INSERT INTO apeB_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Wakuli sapos anudak nenekumanu moul uli nuneyagwleh nukli, ‘Ah, yekinu nebenali eke kobi nunaki wisnabul.’ Ali anan nitak nupe nubo echudak enech chenek moulaluli. Ali nupe nuwak kakwich uli dodogowibali abal ali nugugaku. ");
INSERT INTO apeB_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Ali ananinu nebenali eke wata nutanamali anah nyumnah ababuk nyultab douk anudak nenekumanu moul uli nakli anan eke kobi nutanamali ahi. Anan eke nutanamali nutulunu namudak ali eke nonu nusaganu nupe sisahw ali nukaganu nunak nunu echebuk douk wo chunek bilip umu God uli e chupe. ");
INSERT INTO apeB_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Ali anabuk nenekumanu moul uli nudukemech umu ananinu nebenali naklipanamu nunekech uli, wakuli anan kobi nunek redimu nunekech umu, ananinu nebenali eke nunaki ali nonu nebegun. ");
INSERT INTO apeB_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Wakuli anabuk douk wo nudukemu ananinu nebenali naklimu anan nunekech uli e, ali anan nunek enen yowenyi moul douk nyanokwnumu nebenali nanamu, nebenali eke nunaki ali nonu chokubul. Ali echebuk elpech douk God nukech wolobainyi yopinyi save uli strong umu chunek moul uli, anan eke nuklipech dodogowinu atunamu chuneken chukukwihen. Ali echebuk douk nukech chunubu wolobaichi echudak umu chunek moul umu, anan eke nuklipech umu chunubu chuneken chukukwihen.” ");
INSERT INTO apeB_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Yek douk yanakumali ijigul nyih umu hunu chunatimaguk yowechi echudak douk chape apudak atap uli. Wakuli yek yakli douk sapos ehudak nyih ahunu ele douk deke kalbu. ");
INSERT INTO apeB_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Yek eke inamnek nebehi nyih, wakuli yek douk wata imnekeh e. Ali yekihw apahw douk hwanubu yowehw! Umu monken, yek wata imnekeh e. ");
INSERT INTO apeB_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Ali ipak pakli yek yanamali inek apudak atapichi elpech chupe atugun waka? Wak. Yek yaklipepu, yek yanamali iyaisech. ");
INSERT INTO apeB_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Douk nameitu aliga kwali, 5-poleich atugu nyulgeich eke chitak chunadiyagulmu ali 3-poleich eke chutulichuk yowes biech. Ali echudak biech eke chutulichuk yowes echudak 3-poleich. ");
INSERT INTO apeB_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Ali elpech eke chunadiyagulmu. Ahlim eke hutulumuk yowes nugamim ali nugamim chopuk eke hutulumuk yowes ahlim. Ali mamaliyu eke wutuluwaguk yowes owoiyu nugaliyu ali nugaliyu eke wutuluwaguk yowes mamaliyu. Ali nakwleheu eke wutuluwaguk yowes mehiyaliyu ali mehiyaliyu eke wutuluwaguk yowes nakwleheu.” ");
INSERT INTO apeB_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Ali Jisas naklipu echudak almam almagou nakli, “Sapos putik onog olug gwil gwunak gani aun nabih umu, ipak eke pukli echah eke hulali ali eke kobi loubali wakuli ahah eke hunubu hulali. ");
INSERT INTO apeB_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Ali ipak patik wihun naluwi saut uli nulumali, ipak isave pakli wah eke hutau ali wah isave hatau. ");
INSERT INTO apeB_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Ipak penek loh uli! Ipak patik amnab uli utagu chagimeh chanak umu ali padukemech umu echebuk douk eke chutoglaluli. Wakuli nameitu ipak patik echudak douk chatoglu chanak abudak nyultab uli ali ipak wo pudukemech umu echebuk douk eke chutoglaluli e umu monoken?” ");
INSERT INTO apeB_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Ipak yet imas punek skelimumu enenyi enen pasin ali punek yopinyi. ");
INSERT INTO apeB_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Sapos nyak nyunu enen elpen douk nyukli nyunekumenyu kwot uli pukli punamu kwot umu, ipak wata pupe punak yah ali ipak imas pugabe ipakin balan nyugak-umepaguk yah. Ipak kobi pugabeyen umu, enyen eke nyulawenyu nyunamu nebenali jas douk nasuh kwotog uli. Ali jas eke nulawenyu nyunamu chusim ali amam eke hunek kalabusumenyu. ");
INSERT INTO apeB_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Ali agnabuk yek yaklipenyu, nyak eke kobi nyutoglali wisnabul, wak. Nyak eke nyubouk nyakig nosog nyiyatogwuk ali eke adakio nyutoglali.” ");
INSERT INTO apeB_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Ali ababuk nyultab, enech elpech chape agnabuk uli chaklipu Jisas umu agundak nebenalimu gavman uli Pailat nabo enech Galili chagak umu. Anan nach ababuk nyultab echech chape chenek ofamu enechi enech echudak choku God abali. ");
INSERT INTO apeB_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Ali Jisas naklipech nakli, “Ipak pakli echech chanubu chechalakuk chanatimaguk elpech chape Galili ulimu chenek enenyi enen yowenyimu ali Pailat dakio nach chagak namudak? ");
INSERT INTO apeB_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Wak! Yek yaklipepu, sapos ipak kobi pukenyuk agabus yowenyi ali putanamu pukanu apaluh God umu, ipak punatimaguk eke pugak namobuk ati. ");
INSERT INTO apeB_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Ali ipak pakli malmamu echudak 18-poleich elpech douk loutali wilpat tatau wabul Siloam uli tatu tach chagak uli? Ipak pakli echech chanubu chechalakuk chanatimaguk elpech chape Jerusalem ulimu chenek enenyi enen yowenyimu ali echech dakio chagak? ");
INSERT INTO apeB_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Wak! Yek yaklipepu, sapos ipak kobi pukenyuk agabus yowenyimu, ipak eke pugak namobuk ati kobi douk echech chape Siloam uli chagak umu.” ");
INSERT INTO apeB_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Ali Jisas naklipech enyudak woblen balan nakli, “Ananu alman nau enen lowag chohwalen umu fik uli ananumu yawihas douk nau wain umu. Anan nawen nyakih nebenyi ali nanak nape nalpomen wakuli anan wo nutik enep chulkwip pil e. ");
INSERT INTO apeB_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Douk natulin namudak ali naklipu anudak nenek moul yawihas uli nakli, ‘Mnek, 3-poleich yohleguhw yek yanaki yape yalpomen wakuli wo itik enep chulkwip pil e. Douk namudak ali yek yakli nyublowenyuk! Umu moneken, enyen nyatau ali nyape nyeyatak gris meyoh.’ ");
INSERT INTO apeB_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Wakuli anudak nenek moul yawihas uli naklipanu nakli, ‘Nebenyali, nyak kutuwuk nyutau enyudak atin yohwlegul chopuk. Ali yek eke ilak amnab bawogen umu ali ibuk bulmakauhasigu dewag bawogenyumomu enyen nyulau yopusi gris. ");
INSERT INTO apeB_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Ali douk kehik kamanin yohwlegul chulkwip pil umu, enyen wosik nyutau. O douk kobi enep pil umu, nyak wosik adakio nyublowenyuk.’” ");
INSERT INTO apeB_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Anah nyumnah Sabat, Jisas nanak nawich nape naklipech God ananin balan anatu echech Juda chape cheyagwleh balan atali wilpat. ");
INSERT INTO apeB_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Ali agnabuk onok almatok douk enen sagabu nyapenyuk 18-poleich yohleguh uli kwanech kwape. Okwok enyudak sagabu nyapenyuk ali nyenekok kwechowi ati. Okwok kwabilak wo kwitak kwiyotu dul e, wak. ");
INSERT INTO apeB_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Ali Jisas natuluk ali nohwalok kwanaki ali naklipok nakli, “Nyak mnek, yek ayagabeyenyu!” ");
INSERT INTO apeB_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Ali anan nowemeyok ananis wis ali ahudak atuh okwok kwanubu kwaitak kweyotu dul. Ali okwok kwonehilau ali kwape kwatuk God ananin yeul nyakih. ");
INSERT INTO apeB_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Wakuli anudak nebenalimu atudak wilpat uli nanubu nyihihichi-namu Jisas umu agundak nagabe okudak almatok ahudak nyumnah Sabat umu. Douk namudak ali anan naitak naklipu echudak elpech chape uli nakli, “Eheh douk 6-poleih ati nyumneh umu apak munek moulamu. Ali sapos ipak pukli punakimu anudak alman nugabeyepamu, ipak punaki anah ahudak mouleih nyumnah ali anan nugabeyepu. Ipak kobi punaki ahudak nyumnah Sabat, wak!” ");
INSERT INTO apeB_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Ali Diginali naklipanu nakli, “Ipak penek loh uli! Ahudak nyumnah Sabat ipak panatimaguk isave pokwechih ipakich bulmakauhas uli donkihas ali palawech panak chawak abal. ");
INSERT INTO apeB_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Ali enyen douk wosik umu yek yagabe okudak Ebraham ananik yamek douk Satan nowechikok kwape 18-poleich yohleguhw uli ahudak nyumnah Sabat umu.” ");
INSERT INTO apeB_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Ali Jisas ananim birua hanubu ablan nyeilam. Wakuli chanatimaguk elpech chanubu chenehilaumu enyudak yopinyi moul Jisas neneken uli. ");
INSERT INTO apeB_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Ali Jisas nasalikech nakli, “Agundak chuwich umu God nape nebenalimu ananich elpech umu eke kobi moneken umu? Yek eke iklipepu moneken woblen balan umu pudukemech? ");
INSERT INTO apeB_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Agagun eke kobi onoh chokuhwi mastetihw nahw douk ananu alman nawohw ananumu yawihas ulimu. Anan nawohw ali hwakih hwonek nebenyi lowag. Ali enyen nyenek yeguhiyu ali almiguh douk hwehilau iluh uli hwakih hwowemu logos yeguhwiyu ali hwotemu.” ");
INSERT INTO apeB_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Ali Jisas wata chopuk naklipech nakli, “Agundak chuwich umu God nape nebenalimu ananich elpech umu eke kobi moneken umu? ");
INSERT INTO apeB_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Agagun eke kobi yis umu. Onok almatok kwaitak kwosuhul kwautus umu enen dram plaua ali kwonek blinu blonu aliga yis sawich nyanatimaguk plaua ali seneken nyaitak nebenyi.” ");
INSERT INTO apeB_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Ali Jisas nape nanak wolobailubi nebelubi blanu chokulubi walub. Anan nanak nape nenek skulumech umu God ananin balan ali nape nanak umu nakli nunamu Jerusalem. ");
INSERT INTO apeB_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","24","Ali agnabuk enen elpen nyasalikanu nyakli, “Diginyali, God eke nunolau atin ati elpech chutanamali chupe kalbu waka?” Ali Jisas naklipech nakli, “Ipak imas punubu dodogowipu atipu ali puwich enyudak chokwinyi dua. Yek yaklipepu namudak umu moneken, wolobaichi elpech eke chukli chuwich enyudak chokwinyi dua wakuli echech eke chubila wak. ");
INSERT INTO apeB_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Ali ahabuk nyumnah, anudak wilpatinali eke nitak nuwaluk dua ali ipak eke punak piyotu aduk ali eke pupe pubo dua ali pukli namudak. ‘Nebenyali, jikumopogu dua!’ Wakuli anan eke nuklipepali nukli, ‘Yek wo idukemepu e, ipak meilubi walubipu!’ ");
INSERT INTO apeB_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Ali ipak eke wata puklipanu pukli, ‘Apak douk manenyu mawak woligun ali chopuk, nyak nyanaki nyenek skulumapu nyaklipapu nyakin balan apakilub walub!’ ");
INSERT INTO apeB_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Wakuli anan eke wata nitak ali nukli, ‘Yek wo idukemu abludak wabul ipak panaki abuli e. Kalemeik ipak penek enenyi enen yowenyi uli!’ ");
INSERT INTO apeB_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Ali ipak eke putik apakim yamem Ebraham nunu Aisak uli Jekop hunu amudak hanatimaguk profet hupe agnabuk God ananich elpech chapemu. Wakuli ipak eke chukogepu punak pupeik aduk. Ali ipak eke puleh punokukli punoluwol ali punalkech ipakiluh naluh. ");
INSERT INTO apeB_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Ali elpech chape gnanatimaguk apudak atap uli eke chunaki chupe chuwak nebeguni woligun agnabuk God ananich elpech chapemu. ");
INSERT INTO apeB_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Ali echebuk elpech douk nameitu yeguh wakechi eke wata yeguh hwukihech. Ali echebuk douk nameitu yeguh hwakihech uli eke wata yeguh wakech.” ");
INSERT INTO apeB_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Ali banubu ababuk atubu nyultab amam Farisi hanaki ali haklipu Jisas hakli, “Nyak nyunubu nyutukemaguk agundak ali nyunakuk kipaigunmu. Umu moneken, Herot nakli nenyu nyugak.” ");
INSERT INTO apeB_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Wakuli Jisas naklipam nakli, “Ipak punak puklipatu namudak atabuk wanalitu nubat. Pukli, ‘Mnek, doumeih uli kamanih yek eke ihiyahuk yowechi sagabehas ali chopuk eke igabe agasudak sachi elpech. Ali huklimu bieh atuh nyumneh ahi, yek eke iyatak yekin moul.’ ");
INSERT INTO apeB_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Wakuli doumeih hunu kamanih uli biebih, yek eke inak. Umu moneken, echech eke kobi chubo ananu profet nugak anabul kipaibuli wabul, wak. Echech eke chonu nugak Jerusalem atugun. ");
INSERT INTO apeB_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","O ipak elpech pape Jerusalem uli, ipak isave pabo amam profet hagak. Ali chopuk, pakumom utabal amabuk douk God nakagam halaumepogu ananin balan ipak uli! Wolobaihi nyumneh yek yakli ilawepu pupe atugun kobi douk mamakitu owotu techukol atatig nugag atatich abusineguh umu. Wakuli ipak panubu pakli wak! ");
INSERT INTO apeB_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Ali mnek, God eke nutukemaguk ipakbul wabul. Ali yek yaklipepu, ipak eke kobi wata putiwe aliga ababuk nyultab douk eke pukli, ‘Apak makli God nunekumanu yopinyi anabuk alman douk nanakimu Diginali ananin yeul uli!’” ");
INSERT INTO apeB_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","2","Anah nyumnah Sabat echech Juda moul wak chape meyoh ahi, Jisas nanak umu nuwak woligun ananu nebenalimu amam Farisi uli ananitu wilpat. Ali agnabuk ananu yegenyih hwaltowanali nape halakatimu Jisas. Douk namudak ali amam hape hatulunu duk umu hakli kadak nukli nugabe anudak alman umu. ");
INSERT INTO apeB_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Douk namudak ali Jisas naitak nasalik amudak henek skulumech umu lo uli hanu amam Farisi nakli, “Apakin lo nyakli apak mugabe elpech ahudak nyumnah Sabat waka wak?” ");
INSERT INTO apeB_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Wakuli amam wo hukli enen balan. Ali Jisas nasuhwi anudak alman nagabeyanu ali nakaganu nanak. ");
INSERT INTO apeB_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Ali nasalik amudak tisa hanu amam Farisi nakli, “Sapos ipak ananu enen ananin batowin o enen bulmakau nyunak nyugluk anagu bobigu abal blolomu ahudak nyumnah Sabat umu ele, anan deke nutuken waka wak? Adul, anan deke nutuken ahudak atuh.” ");
INSERT INTO apeB_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Wakuli amam balan wak umu hubeyeynu-manamu. ");
INSERT INTO apeB_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","8","Douk Jisas natik amudak almam douk hanakimu agundak woligun uli hanaki, wakuli amam hakli hupe chakus chalik uli atich siahas. Ali anan naklipech enyudak woblen balan nakli, “Sapos enen elpen nyuhwalenyamu nyunamu anagun woligun douk chenekagun umu biech chanasupamu, nyak nyunak ali kobi nyunak nyupe nyulik, wak. Umu moneken, kedeke anudak douk nohwalenyamu nyunamu agundak woligun uli nuhwalu ananu douk ananin yeul nyakihumaguk nyak uli alagun. ");
INSERT INTO apeB_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Ali douk namudak umu, anudak douk nohwalepamu punamu ananigun woligun uli eke nunaki ali nukli, ‘Nyak kitak ali nani nunaki nupe agundak.’ Ali nyak eke ablan nyilenyu ali nyunak nyupe nyugikuk. ");
INSERT INTO apeB_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Ali namudak douk wak. Sapos enen elpen nyuhwalenyamu nyunamu enyenyigun woligun umu, nyak nyunak ali nyupe nyugikuk. Nyak nyunek namudak ali enyudak elpen douk nyohwalenyamu nyunamu enyenyigun woligun uli eke nyunaki nyuklipenyu nyukli, ‘Elpen, nyak nyunak nyupe nyulik.’ Enyen eke nyuklipenyu namudak ali echebuk enech elpech douk chanakmali agundak woligun uli eke chutulinyu ali chutuk nyakin yeul nyukih. ");
INSERT INTO apeB_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Umu moneken, chunatimaguk elpech douk chutuk echechich yeguh chukih chukli echech nebechi uli, God eke wata nunihech chubih. Echebuk douk wo chutuk echechich yeguh uli e, God eke wata nutuk echechich yeguh chukih.” ");
INSERT INTO apeB_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Ali Jisas naklipu anudak nebenalimu amam Farisi uli douk nohwalanamu nunamu ananigun woligun uli nakli, “Sapos nyak nyukli nyunek anagun woligun umu, nyak kobi nyuhwalu nyakich elpech atich chunu nyakich sachich owachich chunu nyakip awilop punu ipak atubul wabul umu douk chonokwalmu wolobaichi echudak uli atich, wak. Umu moneken, echech eke wata chuhwalenyamu nyunak nyuwak woligun echechig wilag. Ali namudak umu, echech eke chubemenyu nyakich kakwich. ");
INSERT INTO apeB_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Ali namudak wak. Sapos nyak nyunek nebeguni woligun umu, nyak imas nyuhwalu echebuk douk chanahwagagun umu echudak uli, chunu yegechiweluh yoweluhichi chunu aias senekechi chunu nabes sechukechi. ");
INSERT INTO apeB_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Umu moneken, echudakmali elpech eke kobi chubemenyu agundak woligun nyak nyunek-agunmech uli. Ali God eke nunekumenyu yopinyi. Ali ababuk nyultab echudak yopichi elpech douk likuk chagak chanugomech uli wata chitaki iwagas abalimu, God eke nubemenyu echudak.” ");
INSERT INTO apeB_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Ali ananu alman douk nanam hape hawak woligun uli nemnek namudak ali naklipu Jisas nakli, “Echebuk elpech douk eke chupe chuwak woligun agnabuk God ananich elpech chapemaluli, echech eke chunehilau chulikuk.” ");
INSERT INTO apeB_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Wakuli Jisas naklipanu enyudak woblen balan nakli, “Ananu alman nakli nunek anagun nebeguni woligun. Ali anan anohwalu wolobaichi elpech umu chunamu agundak woligun. ");
INSERT INTO apeB_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Ali ahudak nyumnah hanakimu nunek agundak woligun umu, ali anan nakagas ananu nenemanu moul ulimu nunak nuklipech chunaki. Ali anan nanak naklipech nakli, ‘Ipak yowi, woligun amonekagun gnakus.’ ");
INSERT INTO apeB_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Wakuli echudak chanatimaguk atin ati chaitak ali chakli echech eke kobi chunak. Ali susubeinu nakli, ‘Yek yatal anagun yawihas ali yek yakli inak itulugun. Douk namudak ali yek eke kobi inaku.’ ");
INSERT INTO apeB_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Ali ananu nakli, ‘Yek yatal 10-poleich bulmakauhas umu chunek moulaluli, ali yek yakli inak ichakamech umu chunek moul. Douk namudak ali yek eke kobi inaku.’ ");
INSERT INTO apeB_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Ali ananu nakli, ‘Yek nameitu ati yasuh almatok, douk namudak ali yek eke kobi inaku.’ ");
INSERT INTO apeB_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Douk amam haklipanu namudak ali anan wata natanomu nanak naklipu ananinu nebenali umu enyudak balan amam haklipanamu. Ali anudak wilpatinali nanubu nyihihichinu ali naklipu anudak nenemanu moulaluli nakli, ‘Nameitu nyunak wisnabul ehudak hunatimaguk nebehi yegwih hunu chokwihi douk hape abludak wabul uli. Ali nyulawali nabes sechukechi chunu chanohwagagun umu echudak uli. Echech chunu echebuk douk yegechiweluh yoweluhichi, chunu aias senekechi ali nyulawech nyunaki yekitu wilpat.’ ");
INSERT INTO apeB_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Ali anudak nenemanu moulaluli wata nanaki ali nakli, ‘Nebenyali, yek ayagipechen nyakin balan wakuli anagunitamu wilpat watak tape meyoh.’ ");
INSERT INTO apeB_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Ali nebenali naklipanu nakli, ‘Nyak nyunak nyugimu nebehi yah ali chopuk nyugimu nalub yawihasilub ali nyulawali elpech chunaki chuwich yekitu wilpat. Umu moneken, yek yakli yekitu wilpat tunubu chuknitu. ");
INSERT INTO apeB_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Ali yek yaklipenyu, amabuk almam douk nubuwakih yohwalam umu hunakimu yekigun woligun uli eke kobi wata hunaki huwak anagun yekigun woligun, wak.’” ");
INSERT INTO apeB_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","26","Douk wolobaichi elpech chanu Jisas chanak ali anan natanamu natulich ali naklipech nakli, “Sapos enen elpen nyukli nyunaki nyugipech yek, wakuli enyen ulkum munubu munosuh enyenyinu aninu uli mamakik, chunu enyenyik almatok kwunu enyenyich batowich, chunu enyenyich sachich owachich chunu enyen yet, wakuli yek enyen ulkum munohwe kwalowi atimu, enyen eke kobi nyunokwnumu nyugipech yek, wak. Enyen nyukli nugipech yek umu, enyen ulkum imas munubu munohwe. ");
INSERT INTO apeB_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Ali chopuk, enyebuk elpen douk nyukli nyugipech yek, wakuli enyen kobi nyunek redimu nyusah enyenyin lowag kruse ali nyugak umu, enyen eke kobi nyunokwnumu nyupe yekin disaipel, wak. ");
INSERT INTO apeB_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Ali sapos ipak enen nyukli nyulak anatu louloutali wilpat ele, susubuati enyen deke nyupe ali ulkum mupe mulomu enyenyibal utabal douk enyen nyanabalubuk uli iyuh. Ababal eke blunokwnumu nyulak atudak wilpat nyiyatatu waka wak? ");
INSERT INTO apeB_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Ali douk susubuati enyen ulkum kobi mulu namudak iyuh ali nyitak nyunek simen nyichuhulatu, wakuli enyen kobi nyulatu nyiyatatamu, chunatimaguk elpech eke chutulutu ali chiyakasin, chuneken enenyi enen. ");
INSERT INTO apeB_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Echech eke chukli, ‘Enyen nyatahul nyalatu wakuli enyen wo nyulatu niyatatu e!’ ");
INSERT INTO apeB_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Ali sapos ananu king nunu 10,000 poleim soldia uli nukli nunak nunu kipainali king douk nanali 20,000 poleim soldia uli hulpak umu, susubuati anan eke nupe ali ulkum mulomu anan nunu ananim soldia eke wosik dodogowim umu hubo anudak ananu king nunu ananim huhiyahom waka wak. ");
INSERT INTO apeB_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Sapos anan nunodukemomu anan eke kobi dodogowinamu, ananich birua chunu echechinu king eke wata chupe chunaki lougun ali anan eke nukagas enen nyulau balan uli. Enyen eke nyulau balan nyunak nyuklipu anudak ananu king umu amam hunogabemu hupe atugun ali kobi hulpak. ");
INSERT INTO apeB_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Ali douk namudak ati, sapos enen elpen kobi nyukechuk agab chunatimaguk enyenyich echudak umu, enyen eke kobi nyunokwnumu nyugipech yek, wak.” ");
INSERT INTO apeB_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Ali Jisas naklipech enyudak woblen balan nakli, “Sol alal douk yopuli. Wakuli sapos alal wata jebiyail umu, apak yah douk wak anah e umu wata munekal wichusil umu. ");
INSERT INTO apeB_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Aludakmali sol douk wo yopul umu lunek enen moul e. Apak eke muwacholuk meyoh. Ali ipak aligas sapenyipali imas pumnek enyudak balan!” ");
INSERT INTO apeB_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Anabu nyultab amam halau takis uli hanu amudak anam henek enenyi enen yowenyi uli hanakimu humnek Jisas ananin balan. ");
INSERT INTO apeB_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Ali amam Farisi hanu amam henek skulumech umu lo uli hape howimanu lublub Jisas hakli, “Anudak alman nanu amudak henek enenyi enen yowenyi uli hape. Ali chopuk, anan nanam hape hawak woligun!” ");
INSERT INTO apeB_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","4","Ali Jisas naklipam enyudak woblen balan nakli “Sapos ipak ananu nunekech 100-poleich sipsip ali enen nyunak nyuwich ele, anan deke nunek malmu? Anan deke nutukemaguk echudak 99-poleich chiyotuk chupe chuwakuk wichap anagun ali anan deke nunak nupe nutimu enyudak atin sipsip aliga nunak nugwaten. ");
INSERT INTO apeB_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Douk nugwaten ali anan eke nunubu nunehilau ali nutuken ninyusah ali wata nutanamu nunak. ");
INSERT INTO apeB_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Douk nunak aliga nutoglu wilpat ali anan eke nuhwalu ananich elpech douk chanu anan chape atugunmaluli nukli, ‘Enen yekin sipsip nyanak nyawichuk wakuli yek yatimen aliga yanak yogwaten ali wata yanohwenyi. Douk namudak ali yakli ipak punaki punu yek munehilau!’” ");
INSERT INTO apeB_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Douk Jisas nakliyuk namudak ali wata chopuk naklipech nakli, “Ali douk namudak ati yek yaklipepu, chape iluh heven uli eke chunehilau kwalowi atimu echudak 99-poleich elpech douk chakli echech achape kalbu ali moul wakech umu chukenyuk agabus yowenyi ali wata chukanu apaluh God umu. Wakuli atunu alman douk nenek yowenyi uli nukenyuk agab yowenyi ali nutanamu nukanu apahw God umu, chape iluh heven uli eke chunubu chunehilau chulikuk.” ");
INSERT INTO apeB_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“O sapos onok almatok kwunoluk 10-poleibal silwaibal utabal ali okwok kwunak kuwimaguk anam ele, okwok deke kwunek malmu? Okwok deke kwitak kuhemu lam ali kugitu okwokwitu wilpat. Ali okwok kupe kutimen aliga wata kugwaten. ");
INSERT INTO apeB_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Douk kwugwaten ali okwok eke kuhwalu okwokwich elpech douk chanu okwok chape atugunmaluli kukli, ‘Anam yekim utam manak mawichuk wakuli yek wata yatimom ali yanak yonogatam. Ali yek wata yenehilau ali yakli ipak punaki pune munehilau!’ ");
INSERT INTO apeB_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Ali yek yaklipepu, douk namudak ati, God nunu ananich enselahas eke chunubu chunehilau chulikuk umu agundak atin elpen meyoh douk nyenek yowenyi uli wata nyukenyuk agab ali nyutanamu nyukanu apahw God umu.” ");
INSERT INTO apeB_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Ali Jisas balan nyeilen naklipech enyudak woblen balan nakli, “Ananu alman nomlali biam nugamim. ");
INSERT INTO apeB_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Ali chokunali nuganinu naklipu aninu nakli, ‘Aninu, yek yakli wak umu ipe aliga nyak nyugakuk ali ohwak adakio wuneyais echudak nyak nyokwalmech-umohwaguk ulimu, wak. Yek yakli nyiyais-echumohu nameitu!’ Ali aninu naitak neyaisumom ananich echudak ananim biam nugamim. ");
INSERT INTO apeB_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Ali douk wo loubali e ali chokunali nuganinu nohul ananich echudak nanak nanatal utabal nanohwabal ali nanak nape lougun kipainyi kantri. Anan nanak ali nape nasagu ananibal utabal. Anan nowachabal umu enyebuk yowenyi pasin douk anan nape neneken uli. ");
INSERT INTO apeB_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Douk nowachak ananibal utabal aliga neyatabaluk, wakuli takweihi nyulbiah hach enyebuk kantri. Ali anan nanubu nanohwagagun. Anan wo kwalowi omi nunobukuk anabal gwodubal utabal umu nunatal kakwich umu e, wak. ");
INSERT INTO apeB_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Douk namudak ali anan nanak nape nenek moulamu ananu ablabuk wabulinu alman. Ali anudak alman nakaganu nanak nape nakamanu ananiguhw bulguhw. ");
INSERT INTO apeB_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Ali agnabuk anan nakli nuwak echudak kakwich douk bulguhw hwape hwachah uli. Wakuli wak enen elpen nyukli nyukanu enech kakwich umu nichah uli e, wak. ");
INSERT INTO apeB_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Ali douk nape ali anan ulkum wata molu manak umu agundak anan nape sisahw umu ali nakli, ‘Chanatimaguk chenek moulamu yekinu aninaluli douk chapemu chawak wolobaichi kakwich. Wakuli yek yape agundak ali yanubu yagak nyulub! ");
INSERT INTO apeB_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Douk namudak ali anyunekech, yek wata itanamu inak umu yekin aninu. Ali yek eke iklipanu ikli, “Aninu, yek yenek yowenyimu God nanu nyak. ");
INSERT INTO apeB_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Ali nameitu yek wo inubu yopuwelimu nyak nyuhwale nyakiwe nuganinamu, e. Wakuli nyak nyiyasapu ipe chakamamu nyak inekumenyu moul meyoh.” ’ ");
INSERT INTO apeB_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Douk anan nakli namudak ali anan naitak nape nanamu ananinu aninu. Douk anan wata nape nanaku lougun wakuli ananinu aninu natulunogu ali amatog gwanubu gwagak umu ananinu nuganinu. Ali anan nasahul nanak nesleyanu ali nanoplikanu. ");
INSERT INTO apeB_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Wakuli anudak nuganinu naklipu aninu nakli, ‘Aninu, yek yenek yowenyimu God nanu nyak. Ali yek douk wo yopuwelimu nyuhwale nyakiwe nuganinamu e, wak.’ ");
INSERT INTO apeB_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Wakuli aninu nohwalu echudak chenek moulamanaluli nakli, ‘Ipak pulawali yekih susubeih yopuhi louhi lupah punaki puhlamanu ali pulamanu enen ring ananih hah. Ali pulamanu onou su. ");
INSERT INTO apeB_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Ali punak pubo nyanyi susubein yopinyi bulmakau ali apak munek nebeguni woligun muwak enyudak bulmakau ali munehilau. ");
INSERT INTO apeB_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Umu moneken, yek yakli anudak yekinu nuganinu eke anagak. Wakuli wak, anan wata nape. Yek yakli anan eke ananak nawichuk. Wakuli wak, yek wata yonogwatanu.’ Ali anan naklipech namudak ali echech chanubu chape chenek woligun ali chenehilau. ");
INSERT INTO apeB_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Douk echech chape chenekagun ali anudak yopunali nuganinu napeli yawihas nanaki ali nemnek umu agundak echech chape cheyalub chenek danis umu. ");
INSERT INTO apeB_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Ali anan nohwalu ananu nenek moulaluli nanaki ali nasolikanu nakli, ‘Ipak pape penek moneken?’ ");
INSERT INTO apeB_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Ali anan naklipanu nakli, ‘Nyakinu owaninu nanaki ali nyakinu aninu nabo enyudak susubein yopinyi bulmakau ali apak monek woligun. Umu moneken, ananinu chokunali nuganinu douk wo nugak e. Anan wata natanamali.’ ");
INSERT INTO apeB_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Ali douk saninu nemnek namudak ali anan nanubu nyihihichinu ali nanubu nakli wak umu nunak nuwich wilpat umu. Douk namudak ali ananinu aninu nanaki ali nenemanu chokwin chokwin umu nunak wilpat. ");
INSERT INTO apeB_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Wakuli anan naklipu aninu nakli, ‘Wolobaichi yohleguhw yek yape yenekumenyu nebeben atinyi moul kobi douk ananu nenek moul meyoh umu nyak ulimu. Ali yek wo iganimenyamu nyakin balan ati e. Wakuli nyak wo kwalowi nyuke enen chokwinyi mememu yek inu yekich elpech munenek anagun woligun mugnah ali munehilau e, wak! ");
INSERT INTO apeB_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Wakuli anudak nyakinu nuganinu nanak nasagaguk nyakich echudak neyatechuk umu oudak weyotu yegwih uli almagou. Ali nameitu anan wata natanamali ali nyak nyabomanu enyudak susubein yopinyi bulmakau’ ");
INSERT INTO apeB_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Ali aninu naklipanu nakli, ‘Nya, eheh nyumneh ohwak wape atugun ali yekich echudak douk nyakich. ");
INSERT INTO apeB_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Wakuli nameitu apakiluh apaluh imas hlunubu yopuluh ali munehilau ali munek woligun. Umu moneken, anudak nyakinu owaninu apak makli anan eke anagak, wakuli wak. Anan wata nape ali nameitu anan wata natanamali. Ali apak makli anan eke nanak nawichuk, wakuli nameitu apak wata mogwatanu.’” ");
INSERT INTO apeB_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Ali Jisas naklipam enyudak woblen balan ananim disaipel nakli, “Ananu nebenali douk neglemu wolobaichi enechi enech echudak uli nape. Ali ananu nenek moulaluli chopuk douk nautunomu nunek bos umu echudak enech chenek moulaluli nape. Ali enech chanaki chaklipu anudak nebenali chakli, ‘Anudak nenemenyu moul uli douk nyenekanamu bos uli nape nasogomenyu nyakich echudak chanu nyakibal utabal.’ ");
INSERT INTO apeB_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Ali anudak nebenali nohwalu anudak bos ali nakli, ‘Malmu malmomu enyudak balan yek yemneken umu chakli nyak nyape nyasagome yekich echudak umu? Douk namudak nyak nyunak nyudaleh chunatimaguk echudak nameitu nyak nyahwech uli chunu echebuk douk seiwak nyowachechuk umu nyenek moulamu. Nyak nyudalehech ali nyichemu anap chup ali nyunaki nyugilape. Umu moneken, nyak eke kobi wata nyupe bos, wak.’ ");
INSERT INTO apeB_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Ali anan neneyagwleh nakli, ‘Yekinu nebenali anaklimu nunek julugumemu moul. Douk namudak ali yek eke inek malmu? Yek wo dodogowiwemu ilak bobigas umu e. Ali chopuk, yek douk ablan umu inak ihwalu kipaichi elpech umu chuke echudak umu. ");
INSERT INTO apeB_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Ali nameitu yek yadukemech umu echudak douk eke yek inekech ulimu ababuk nyultab yekinu nebenali nunek julugumemu moul umu, elpech eke wata chulawe inamu echechig wilag.’ ");
INSERT INTO apeB_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Douk namudak ali anan nohwalu chanatimaguk elpech douk chenek dinaumu ananinu nebenali uli chanaki chatulunu. Ali anan nasolik susubeinu nakli, ‘Nyak nyenek dinaumu makwnich echudak yekinu nebenali ananich?’ ");
INSERT INTO apeB_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Ali anan naklipanu nakli, ‘Yek yenek dinaumu 100-poleich drepoguhas wel douk chenekal lowas chohwalagas umu oliv uli.’ Ali anudak bos naklipanu nakli, ‘Wisnabul nyunak nyuhul apabuk chup echudak nyak nyenek dinaumech uli chetemomu ali wata nyuwemu 50-poleich ati.’ ");
INSERT INTO apeB_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Ali wata chopuk kipainali nanaki natoglomanu ali nasolikanu nakli, ‘Nyak nyenek makwin dinau?’ Ali anan naklipanu nakli, ‘Yek yenek dinaumu 100-poleigas begas wit douk chenek plaua umu.’ Ali anan naklipanu nakli, ‘Nyak nyunak nyuhul apabuk chup echudak nyak nyenek dinaumech uli chetemomu ali wata nyuwemu 80-poleigas ati.’ ");
INSERT INTO apeB_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Ali anudak nebenali natuk anudak nenek loh uli bos ananin yeul nyakih. Umu moneken, anan douk nanubu yologinu ali nenenek anah yopuhi yah umu nagakamu amudak almam nabouk amamin dinau nyagakuk umu nenekam henehilau ali kwali amam eke wata hugakamanu. Echudak elpech chagipech apudak atapin pasin ali chakanaguk agabus God uli, echech douk chanubu yologich chadukemech umu chunu kipaichi chakanaguk agabus God uli chunek enenyi enen moul umu. Echech douk chechalakuk God ananich elpech douk chalahe hwolologun-molulimu chenek moul umu.” ");
INSERT INTO apeB_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Ali Jisas balan nyeilen nakli, “Aduligu atugu yek yaklipepu, ipak imas pukech ipakibal utabal kipaichi elpech umu pugakomech ali punekech chutoglu ipakich elpech. Ipak punek namudak ali kwali ipakibal utabal blutuh umu, ipak eke pugak ali punak pupe kalbu eheh nyumneh gani iluh heven. ");
INSERT INTO apeB_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Echebuk elpech douk chusuhw gwodich echudak ali chunek lukautumech kalbaluli, echech eke chunokwnumu chusuh wolobaichi echudak chunek lukautumech. Ali echebuk douk chunek chokwinyi moul ali chunek loh umu, echech chunek nebenyi moul umu, echech eke chunek loh namudak ati. ");
INSERT INTO apeB_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Ali sapos ipak kobi pugabe punek lukautumu apudak atapibal utabal kalbamu, ipak eke omuni nyukepu yopichi echudak douk chakus iluh heven ulimu punek lukautumech? Aduligu atugu eke wak. ");
INSERT INTO apeB_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Ali sapos ipak kobi pugabe pubuk kipaichi echechich echudak umu, ipak eke wata omuni nyukepu ipakich echudak? Aduligu atugu eke wak. ");
INSERT INTO apeB_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Deke kobi enen elpen nyenek moulaluli nyunek moul umu biam nebemi. Douk enyen nyunek moulomom biam umu, enyen eke nyukli wakuk ananu, ali eke ulkum munosuh ananu. Ali enyen eke nyumnek ananu ananin balan ali ananu eke kobi nyumnekanu. Ali ipak douk wo punokwnumu punek moulamu God nunu utabal alagun e, wak.” ");
INSERT INTO apeB_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Douk amam Farisi hemnek namudak ali hape henekanu enenyi enen Jisas. Umu moneken, amamip ulkwip douk panubu panosuh utabal. ");
INSERT INTO apeB_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Ali Jisas naklipam nakli, “Ipak pakli punek ipakin yopinyi pasin agundak kipaichi elpech chapemu umu chutulipu ali chuhwalepu duldulipali elpech. Wakuli God douk anadukemu ipakip ulkwip polu panak umu. Echebuk douk elpech chatulich ali oub banubu baitakumech uli, echebuk douk God natulich nakli chanubu yowechi. ");
INSERT INTO apeB_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Ali enyudak lo seiwak God nokaguk Moses enyi nyanu amam profet haklipech-enyi balan nyape dodogowin aliga nyanak nyatoglomu ababuk nyultab Jon douk nenek baptaisumech uli natoglu napemu. Ali ababuk nyultab banaki aliga nameitu, echech chape chaklipech God ananin yopinyi balan umu agundak God nape nebenali umu ananich elpech umu ihalub walub. Ali chanatimaguk elpech chape chenek nebenyi moul dodogowich atich umu chakli chuwich agundak God nape nebenalimu ananich elpech umu. ");
INSERT INTO apeB_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Iluh atap eke gnunak gnuwichuk. Wakuli enyudak lo douk seiwak God nakaguk Moses enyi eke kobi anagun chokugun meyoh gnunak gnuwichuk, wak.” ");
INSERT INTO apeB_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Sapos ananu alman nunek julug umu ananik almatok ali wata nukli nulau kipaikwimu, anan douk nablo enyudak lo umu chanasupamu. Ali sapos ananu alman nulau onok almatok douk seiwak okwokwinu alman nenek julugumok kwape ulimu, anan douk nablo enyudak lo umu chanasupamu.” ");
INSERT INTO apeB_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Ali Jisas naklipech enyudak woblen balan nakli, “Ananu nebenali douk neglemu wolobaichi echudak uli nape. Ali eheh nyumneh anan nenek yopihi atih luseh douk chatalih nebebali utabal uli. Ali anan nape kalbu ali napemu nawak yopichi atich kakwich. ");
INSERT INTO apeB_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Ali agnabuk ananu nonohwalamu Lasaras uli douk nanohwogagun umu echudak uli chopuk nape. Anan eleb bapenyunu ali chalawonu nanak nape aduk dua anudak nebenali ananis banis. ");
INSERT INTO apeB_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Anan nape agnabuk umu nakli nunatalmu yalugwich kakwich anudak nebenali nunekech chunakuk uli. Ali chopuk, nubag gwanaki gwape gweiluh ananib eleb. ");
INSERT INTO apeB_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Douk Lasaras nape aligasu wakuli anan nagak ali God ananich enselahas chalawonu nanak nanu Ebraham hape agnabuk douk God ananich elpech chagak chanak chapenyubuli wabul. Ali anudak nebenali chopuk nagak ali chanugomanu. ");
INSERT INTO apeB_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Ali anan nanak nape agnabuk chagak uli chanak chapemu. Ali agnabuk, anan nenemnek nebehi nyih ali natulugunu wakuli natik Ebraham nanu Lasaras hapeli lougun. ");
INSERT INTO apeB_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Douk namudak ali nohwalu Ebraham nakli, ‘O yamenome Ebraham, nyak nyukli mapiliwe yek ali nyukagas Lasaras nusekuli ananih hah abal ali nunaki nubuwehume yaham. Umu moneken, ehudak nebehi nyih hanue ali yanubu yenemnek nebehi nyih!’ ");
INSERT INTO apeB_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Wakuli Ebraham naklipanu nakli, ‘O yamenome, nameitu nyak ulkum mulomaguk seiwak. Seiwak nyak nyape nyalahe amnab umu, nyak nyalau chanatimaguk yopichi echudak. Ali Lasaras nalau chanatimaguk yowechi. Ali nameitu abludak wabul ananihw apahw hwolu kalbu ali nenehilau. Wakuli nyak nyapemu nyenemnek nebehi nyih. ");
INSERT INTO apeB_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Ali chopuk, olokohun umu apak manu ipak, God nenek anatu nebetali baret tagluk gani atap. Douk namudak ali elpech chupe agundak uli chukli chublowotu chunaku agnabuk ipak papemu, echech eke chubilak wak. Ali elpech chupeli agnabuk uli eke kobi chublowatali chunaki agundak apak mapemu, wak.’ ");
INSERT INTO apeB_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Wakuli anudak nebenali nakli, ‘Douk namudak ali Ebraham, yek yaklipenyu, nyak nyukagas Lasaras nunamu yekinu aninu ananitu wilpat. ");
INSERT INTO apeB_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Anan nunak nuklipu yekim 5-poleim owahlim dodogowinyi balan. Umu moneken, kedeke wosik ati amam chopuk hunaki abludak wabul douk chenemnek nebehi nyih umu.’ ");
INSERT INTO apeB_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Wakuli Ebraham naklipanu nakli, ‘Amam douk halau okudak buk douk seiwak Moses nanu amam profet howemu God ananin balan nyetemeyokwi. Ali amam eke hutulin hugipechen ali enyen eke nyugakamom.’ ");
INSERT INTO apeB_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Wakuli anan nakli, ‘Wak, yamenome Ebraham! Enyebuk balan atin eke kobi nyugakamom. Douk enen nyagak uli wata nyitaki iwagu nyunak nyuklipam ele, amam deke hukenyuk agabus yowenyi ali hutanamu hukanu apaluh God.’ ");
INSERT INTO apeB_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Ali Ebraham naklipanu nakli, ‘Douk amam kobi humnek Moses nunu amam profet amamin balan huhwen hugipechen umu, enen nyagak uli elpen wata nyitaki iwagu ali nyunak nyuklipamen uli balan chopuk eke kobi humneken ali hukenyuk agabus yowenyi, wak!’” ");
INSERT INTO apeB_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Ali Jisas naklipu ananim disaipel nakli, “Echudak douk eke chunek elpech chunek yowenyi uli eke chutoglu. Wakuli enyebuk elpen douk nyunek kipainyi nyunek yowenyi uli, enyen douk mapilin. ");
INSERT INTO apeB_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Sapos enen elpen nyunek enen echudak chokwichi nyunek yowenyimu, enyen douk nyanubu nyenek yowenyi. Ali sapos chuhwen chusoh anam nebemi utam enyenyik lobik ali chuwachen nyugluk yous ele, enyen deke nyupe sisahw kwalowi ati. Wakuli namudak eke wak. Enyen eke nyunubu nyupe sisahw. ");
INSERT INTO apeB_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Ali ipak pugamu punenek yologi. Sapos enen Kristen nyukli nyunek enen yowenyimu, ipak puhen. Ali enyen wata nyukenyuk agab yowenyi ali nyutanamu nyukanu apahw God umu, ipak kobi punohwen umu yowenyi enyen nyeneken uli ali pukwleyenyuk. ");
INSERT INTO apeB_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Ali sapos enyen nyunekumenyu enen yowenyi aliga nyudaleh hunak hutoglu 7-poleih anah nyumnah, wakuli enyen wata nyunaki 7-poleih nyuklipenyu nyukli enyen anyatukemaguk enyebuk yowenyi enyen nyeneken umu nyak ulimu, nyak kobi nyunohwen umu enyebuk enyenyin yowenyi ali nyukwleyenyuk. ");
INSERT INTO apeB_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Ali amam aposel haklipu Diginali hakli, “Nyak nyunek apakin bilip nyutoglu dodogowin.” ");
INSERT INTO apeB_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Ali Diginali wata naklipam nakli “Ipak pugipech God kalbu ali ipakin bilip nyutoglu kwalowi nebenyi kobi douk onohw chokuhwi mastetihw nahw umu ele, ipak deke puklipu enyudak chulkwip peilenyi lowag pukli, ‘Nyunotuk umu nubaluh nyunak nyutau yous ali wata nyukih.’ Ali adul ati, enyen deke nyugipech ipakin balan. ");
INSERT INTO apeB_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Sapos ipak ananu nenemenyu moul meyoh uli nunak nupe nuwol amnab yawihas o nunek lukautumu sipsip. Ali douk nunekuk moul julug ali wata nutanamali ati ali deke wosik nyuklipanamu wisnabul nunaki nupe nuwak woligun waka malmu? ");
INSERT INTO apeB_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Aduligu atugu deke wak. Nyak deke nyuklipanu namudak, ‘Kale nasak yopuhi lupah ali nyunak nyunek redimemu yekigun woligun ali nyunaki nyuke ignah. Ali nyak nyupe nyubeyagunmu iwak yekigun iyatogun ali nyak adakio nyuwak nyakigun.’ ");
INSERT INTO apeB_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Ali nyak deke nyunek tenkyumu anudak nenemenyu moul meyoh ulimu agundak nagipech nyakin balan umu o deke wak? Ati deke wak. ");
INSERT INTO apeB_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Douk namudak ali ipak chopuk imas punek namudak ati. Sapos ipak punek enyebuk moul douk God naklipepamu puneken uli piyaten umu, ipak imas pukli, ‘Apak douk yeguh wakapu mape chakamamu God monek moul meyoh uli. Apak douk monek anan naklipapamu muneken uli atin.’” ");
INSERT INTO apeB_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Ali Jisas nape nanamu Jerusalem. Anan nagimu yah nawich nanak olokohun-inyumu enyudak bien provins Galili uli Sameria. ");
INSERT INTO apeB_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","13","Ali douk nanak aligas umu nunak nuwich anabul wabul ali 10-poleim almam sik lepra gapenyum uli hanaki hogwatanu. Ali amam wata heyotuwi lougun ali hohwalali nebegun hakli, “Jisas, Nebenyali, nyak nyukli mapilipu apak!” ");
INSERT INTO apeB_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Ali douk Jisas natulumu ali naklipamu nakli, “Ipak kale punak pugilapom ipakiluh yegechiweluh amam pris.” Ali amam hatanamu hanaku ati, wakuli sik lepra ganubu galhwosuk ali amamiluh yegechiweluh wata yopuluh. ");
INSERT INTO apeB_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Ali ananu natik umu anan wata yopunu ali anan wata natanamu nanak ali nohwalu nebegun atugun nape natuk God ananin yeul nyakih. ");
INSERT INTO apeB_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Ali nanak nabih nogwohebil nakus atap halakatimu Jisas neyotumu ali nenek tenkyumanu. Anudak alman, anan douk ananu echech Sameria. ");
INSERT INTO apeB_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Ali Jisas natik namudak ali nakli, “Dukwechuk yagabe 10-poleim. Ali amudak anam 9-poleim hapeik agnumu? ");
INSERT INTO apeB_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Malmu namudak umu anudak kipaibi amnabinu atunu natanamali nanaki nenek tenkyumu God umu?” ");
INSERT INTO apeB_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Ali Jisas naklipanu nakli, “Kitak kale. Nyak nyenek bilip nyakli yek dodogowiweli ali dakio yopinyu.” ");
INSERT INTO apeB_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Ali anah nyumnah amam Farisi hasalik Jisas umu eke meibali nyultab agundak God nape nebenalimu ananich elpech umu gnutoglu. Ali anan nebemom balan nakli, “Anagun eke kobi enech elpech chutulugun chudukemogun kobi douk chatik enech echudak chadukemech umu, wak. ");
INSERT INTO apeB_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Eke kobi chukli, ‘Tik, agundak gnatoglu agundak o gani gnatoglu gani.’ Umu moneken, nameitu God douk anape apakinu Nebenali ali anape nagakomepu.” ");
INSERT INTO apeB_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Ali anan naklipu ananim disaipel nakli, “Nyultab butoglomu, ipak eke punubu oub bitak umu pukli putik anah nyumnah yek Anudak Alman douk yatoglu aduligeinyi elpen uli itanamali ipe nebeweli ali ihiyatik ahi. Wakuli ipak eke kobi putuluh. ");
INSERT INTO apeB_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Ali elpech eke chuklipepu chukli, ‘Krais anatanamali. Wata tiku, nani nape gani.’ O eke chukli, ‘Anudak nape agundak!’ Wakuli yek yaklipepu. Ipak kobi punak pugipechech, wak. ");
INSERT INTO apeB_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Ipak padukemech umu agundak utagu gohiyatik abali. Agag ganubu gohiyatik aun nakihumali aliga ganak gabih aun nabihumu. Ali yek Anudak Alman douk yatoglu aduligeinyi elpen uli eke inek namudak ati ababuk nyultab yek itanamalimu. Chunatimaguk elpech eke tikati. ");
INSERT INTO apeB_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Wakuli susubuati yek imas imnek nebehi nyih ali doumeich elpech imas chukeik agabus iyuh. ");
INSERT INTO apeB_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Enenyi enen pasin douk cheneken ababuk nyultab Noa nape abali, enyebukmali atin eke chuneken ababuk nyultab halakatimu yek Anudak Alman douk yatoglu aduligeinyi elpen uli itanamali abali. ");
INSERT INTO apeB_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Chanatimaguk elpech chapemu chawak kakwich uli abal, ali almam almagou chanosupu. Echech chape chenek namudak aliga ahudak nyumnah Noa nawich kolohuk ali abal blabo chanatimaguk elpech blechagi-yechuk. ");
INSERT INTO apeB_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Ali chopuk, ababuk nyultab Lot nape abali douk chenek namudak ati. Chapemu chawak woligun, chawak abal, chatal echudak, chenek salimumu echudak, chau enechi enech kakwich ali chanalak wilag. ");
INSERT INTO apeB_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Ali douk aliga ahudak nyumnah Lot natukemaguk wabul Sodom nanakuk wakuli God nenek nyih uli nyihihichibali utabal salfa chagluki iluh utagu. Echech chagluki kobi douk echah halamali ali chabihi chabo chanatimaguk elpech chagak chatuh. ");
INSERT INTO apeB_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Ali ababuk nyultab yek Anudak Alman douk yatoglu aduligeinyi elpen uli itanamali yopugunmu abali, elpech chopuk eke chugimah namobuk ati. ");
INSERT INTO apeB_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Ahabuk nyumnah, elpen nyupe aduk wilpat uli eke kobi wata nyuwich umu nyunahuli enyenyich echudak. Ali enyebuk douk nyeyotu yawihas uli eke kobi wata nyutanamu nyunamu wilpat umu nyunahuli echudak, wak. ");
INSERT INTO apeB_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Ipak ulkwip pulomaguk Lot ananik almatok. ");
INSERT INTO apeB_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Echebuk elpech douk ulkwip pulomu chukli echech yet chupe kalbu, ali kobi chusuh yekin balan chugipechen uli eke chunak chuwichuk. Wakuli echebuk douk wo ulkwip pulomu echech yet e ali chagipech yek uli eke chupe kalbu.” ");
INSERT INTO apeB_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Ali Jisas nakli, “Yek yaklipepu, ababuk wab, biam almam eke hichuh atus alas. Ananu eke inalawanu ali ananu eke nichuhuk. ");
INSERT INTO apeB_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Ali biou almagou eke wupe wunek plaua umu wuweh bret umu. Ali onok eke inalawok ali onok eke kupeik.  ");
INSERT INTO apeB_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Ali biam almam eke hiyotu yawihas. Ali ananu eke inalauwanu, ali ananu eke niyotuk.” ");
INSERT INTO apeB_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Ali Jisas ananim disaipel hemnek namudak ali hasalikanu hakli, “Diginyali, enyudak eke nyutoglu agnumu?” Ali Jisas neyagwleh naklipam woblen balan nakli, “Agnabuk douk mahich chagak chakus umu, madiyokou isave wanaki wenyaulikeh-agunuk.” ");
INSERT INTO apeB_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Ali Jisas naklipu ananim disaipel enyudak woblen balan umu nunek skulumom umu hunek beten wihluwehlu ali kobi hutukemenyuk ati. ");
INSERT INTO apeB_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Ali naklipam nakli, “Anabul wabul, ananu jas douk nasuh kwotog uli nape. Anudak jas wo nunatutulunu ati e God. Ali anan wo kwalowi omi nukli mapilich ati e elpech o nunatutulich e. ");
INSERT INTO apeB_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Ali ablabuk atubul wabul onok almatok anan nagak nokubukuk uli kwape. Wihluwehlu okwok kwapemu kwanamu anudak jas ali kwaklipanu kwakli, ‘Ananu yekinu birua nenek lohume ali nenek kwotume meyoh. Ali yek yakli nyak nyugakomemu kwot.’ ");
INSERT INTO apeB_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Ali loubomu nyultab anudak jas nemnek okwokwin balan ali nakli wak umu nugakomok. Wakuli aligasu anan nenek tinytin ali nakli, ‘Aduligu, yek douk wak inatutik God e, o wak kwalowi inatutik elpech ali ikli mapilich ati e. ");
INSERT INTO apeB_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Wakuli okudak almatok kwanaki kwowemeye abudak bugab ali anyunekech. Yek eke igakomok umu kwot. Wakumomu, okwok eke kupemu kunaki kunaki ali yek eke kuneke inubu ineilesumok.’” ");
INSERT INTO apeB_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Ali Diginali naklipam nakli, “Ipak imas pumnek enyudak balan anudak yowenali jas nakliyen uli. ");
INSERT INTO apeB_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Ali ipak pakli malmu? Echebuk elpech douk God anonoglahech umu chupe ananich uli chukli chuleh chublamanu nyumnah wab umu nugakamech umu, anan deke kobi nugakamech wisnabul waka? ");
INSERT INTO apeB_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Aduligu atugu yek yaklipepu, anan eke nugakamech wisnabul umu enyudak meyoluhin balan. Wakuli ababuk nyultab yek Anudak Alman douk yatoglu aduligeinyi elpen uli itanamali abudak amnab abali, ipak pakli yek eke itimu elpech douk chenek bilip umu yek uli o wak?” ");
INSERT INTO apeB_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","10","Enech elpech douk chakli echech atich douk duldulichi chapemu chenek yopinyi atin uli ali chakli chanatimaguk kipaichi douk yowechi. Douk namudak ali Jisas naklipech enyudak woblen balan nakli, “Biam almam haltomu God ananitu nebetali wilpat umu hunek beten. Ananu Farisi ali ananu nalau takis uli. ");
INSERT INTO apeB_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Ali Farisi naitak neyotu ali numun ananin tinytin atin nenek beten nakli, ‘God, yek yanubu yenek tenkyumenyu. Umu moneken, yek douk wo kobi chanatimaguk kipaichi elpech douk chenek yowenyi uli e. Enech chakwu olugwih uli. Enech chanosonukeh umu chanak hwaloh uli, ali enech chenek wo duldulin pasin uli e. Ali chopuk, yek douk wo kobi nani yowenali alman nalau takis uli e. ");
INSERT INTO apeB_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Ihogu wik, bieh nyumneh yek isave yenek tambumu kakwich ali yape yenek beten atin. Ali ihechumali echudak yek yonogwatech uli, yek isave yeyaisech ali yokenyu anagunich umu nyak!’ ");
INSERT INTO apeB_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Wakuli anudak nalau takis uli neyotuk lougun ali wo kwalowi nipuhul nutik iluh heven e, wak. Anan neyotu ali nape naguduk mehekog ali nakli, ‘God, yek yenek enenyi enen yowenyi uli. Nyak nyukli mapiliwe!’” ");
INSERT INTO apeB_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Ali Jisas nakli, “Yek yaklipepu. God douk natik anudak nalau takis uli ali nohwalanu duldulinali alman ali anan wata natanamu nanamu ananitu wilpat. Wakuli anudak Farisi wak. Umu moneken, elpech douk chutuk echechich yeguh chukih uli, God eke nech chubihuk. Echebuk douk wo chutuk echechich yeguh chukih uli e, God eke nutuk echechich yeguh chukih.” ");
INSERT INTO apeB_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Ali enech elpech chalawali echechich chokwichi batowich umu Jisas umu nuwemeyech wis ali nunekumech yopinyi. Ali douk ananim disaipel hatik namudak ali hahech. ");
INSERT INTO apeB_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Wakuli Jisas nohwalu echudak chokwichi chanaki halakatimu anan ali nakli, “Ipak kutuwuk chokwichi chunamali yek. Umu moneken, echech eke chuwich agundak God nape nebenalimu ananich elpech umu. ");
INSERT INTO apeB_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Echebuk elpech douk chakli wak umu God nupe echechinu nebenali kobi douk batowich chakli wosik umu, echech eke kobi chuwich agundak God ananich elpech chapemu, wak.” ");
INSERT INTO apeB_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Ali ananu echech Juda echechinu nebenali nasalik Jisas nakli, “Yopinyali Tisa! Yek eke inek moneken ali eke dakio inubu ipe kalbu eheh nyumneh?” ");
INSERT INTO apeB_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Ali Jisas nasolikanu nakli, “Nyak nyohwale yopuwelimu moneken? God atunu douk yopunali. ");
INSERT INTO apeB_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Nyak douk nyadukemen enyudak lo douk nyetemu God ananik buk uli. Enyen douk nyakli, ‘Ipak kobi pubo kipachi elpech chugak, kobi punasonukeh umu punak hwaloh, kobi pubo kipaichi elpech, kobi puku aluh, ali kobi punek loh ati. Ali ipak pumnek ipakich mamechich echechin balan ali pugakomech.’” ");
INSERT INTO apeB_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Ali anudak alman wata naklipu Jisas nakli, “Seiwak yek wata chokuwemu, aliga nameitu, yek yahwen dadag enyudak nyanatimaguk lo ali yagipechen.” ");
INSERT INTO apeB_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Ali douk Jisas nemnek namudak ali wata naklipanu nakli, “Nyak douk atin pasin wata nyape, nyak wata nyuneken e. Nyak nyunak nyuhul chunatimaguk nyakich echudak nyuku kipaichi chutalich chukenyu utabal. Ali nyak wata nyiyaisabal umu echudak wakechi elpech. Nyak nyunek namudak ali wolobaichi yopichi echudak eke chukusumenyu iluh heven. Ali douk nyunekuk namudak iyuh ali nyak adakio nyunaki nyugipeche.” ");
INSERT INTO apeB_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Wakuli anudak alman nemnek namudak ali anan apahw hwanubu aman. Umu moneken, anan douk nanubu nanabuk wolobaichi echudak. ");
INSERT INTO apeB_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Ali Jisas natik umu anan apahw hwanubu yowehw umu ali nakli, “Echebuk elpech douk cheglemu wolobaichi enechi enech echudak uli chukli chuwich agundak God nape nebenalimu ananich elpech umu, echech eke chunek hatpolein moul iyuh ali eke adakio chuwich. Wakumomu eke wak. ");
INSERT INTO apeB_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Ali enen nebenyi mahin yeulinyumu kamel uli nyukli nyuwich nyil douk lagal umu tret tenenyigul umu, enyen eke nyunek nebenyi moul ali adakio nyuwich. Wakuli echebuk elpech douk chanabuk wolobaichi echudak uli chukli chuwich agundak God nape nebenalimu ananich elpech umu, echech eke chunubu chunek nebenyi moul chichalakuk kamel ali adakio chuwich. Wakumomu eke wak.” ");
INSERT INTO apeB_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Ali echebuk elpech douk chape chemnekanu neyagwleh uli chasalikanu chakli, “Douk namudak ali God eke wata nunolau meichi elpech chutanamali chupe kalbu?” ");
INSERT INTO apeB_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Ali Jisas wata naklipech nakli, “Echebuk douk elpech chubilak umu chunekech wakuli chubilak wak uli, God anan atunu deke nunekech.” ");
INSERT INTO apeB_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Ali Pita nakli, “Tik, apak douk amatukemaguk apakilub walub blanu chanatimaguk echudak ali enyudak manaki magipechenyu.” ");
INSERT INTO apeB_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","30","Ali Jisas naklipam nakli, “Aduligu atugu yek yaklipepu. Amabuk almam douk amamip ulkwip polomu hukli God nupe nebenalimu amam ali dakio hutukemaguk amamilub walub o amamiyu almagou o sachich owachich o mamechich o batowich uli, God eke nunekumom enyudak. Nameitu abudak amnab God eke nukom wolobaichi echudak chichalakuk echebuk douk amam hatukemechuk uli. Ali kwali chopuk, amam eke hupe kalbu eheh nyumneh.” ");
INSERT INTO apeB_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Ali Jisas nalmu ananim 12-poleim disaipel hanak algas ali naklipam nakli, “Mnek! Nameitu apak eke munamu Jerusalem. Ali nyanatimaguk balan douk seiwak amam profet henyemumaguk umu yek Anudak Alman douk yatoglu aduligeinyi elpen uli eke nyutoglu adulin. ");
INSERT INTO apeB_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","33","Echech eke chukom yek amudak douk wo hudukemu God uli e. Ali amam eke hulawe hunak hunek tok bilasume, hukwusehe ali eke huneke anagu anagu. Ali amam eke huleye nadululuh ali he igak. Wakuli douk nuklimu bieh atuh nyumneh umu, yek eke wata itaki ipe.” ");
INSERT INTO apeB_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Ali douk amam disaipel hemnek ananin balan wakuli amam wo hudukemen e. Bawogen umu balan nyobechukumom. Douk namudak ali echudak douk Jisas naklipamumech uli amam wo hudukemech e. ");
INSERT INTO apeB_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Ali Jisas nanak natoglu hakalatimu wabul Jeriko ali ananu nabes sechukanali nape algasih umu yah. Anan isave nape nohwalu elpech umu chukanu utabal. ");
INSERT INTO apeB_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Ali douk nemnek umu echudak wolobaichi elpech chanakimu chichalakanu chunak ali anan nasalik enech nakli, “Aipo chenek moneken?” ");
INSERT INTO apeB_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Ali echech chaklipanu chakli, “Jisas napeli wabul Nasaret uli nanaki.” ");
INSERT INTO apeB_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Ali anan nemnek namudak ali nohwalu nakli, “Jisas, Devit ananinyu yamenu! Nyak nyukli mapiliwe yek!” ");
INSERT INTO apeB_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Ali echudak chaliki uli chahanu chaklipanamu nusak. Wakuli anan nanubu nohwalu nebegun atugun nakli, “Devit ananinyu yamenu! Nyak nyukli mapiliwe yek!” ");
INSERT INTO apeB_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","41","Ali Jisas nemnek namudak ali neyotu ali naklipech nakli, “Aliga laweyanali punaki agundak.” Ali douk chalawanali ali Jisas nasolikanu nakli, “Nyak nyakli inekumenyu moneken?” Ali anan naklipu Jisas nakli, “Diginyali, yek yakli inatulugun.” ");
INSERT INTO apeB_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Ali Jisas naklipanu nakli, “Tulugun, nyak nyenek bilip nyakli yek dadagoweli ali nyakis nabes dakio yopus.” ");
INSERT INTO apeB_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Ali ahudak atuh nabes yopus natulugun ali nanamu Jisas hanak. Ali anan nape nenehilaumu God natuk ananin yeul nyakih. Ali echudak wolobaichi elpech chopuk chatik namudak ali echech chanatimaguk chatuk God ananin yeul nyakih. ");
INSERT INTO apeB_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Ali Jisas nawich nanak abuldak wabul Jeriko ali anan nanak umu nakli nutukem-abuluk nugimu yah nunak. ");
INSERT INTO apeB_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Ali ananu alman chohwalanamu Sakias uli nape ablabuk wabul. Anan douk nebenalimu amam halau takis uli. Ali anan douk nanabuk wolobaibali utabal uli. ");
INSERT INTO apeB_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Ali Sakias nakli nutik Jisas umu nudukemanamu anan douk meinali. Wakuli wolobaichi elpech chasusumanaguk ali anan wo nutulunu e. Umu moneken, Sakias chopuk douk nanubu bananali alman. Namudak ali anan nabilak umu nutik Jisas wakuli nabilak wak. ");
INSERT INTO apeB_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Douk namudak ali anan nasahul nalik ati nanak nalto enen lowag yeulinyumu fik ulimu nakli nutik Jisas. Umu monoken, anan nadukemech umu Jisas eke nunak ahabuk yah. ");
INSERT INTO apeB_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Ali douk aliga Jisas nanak natogloli okwobuk outuk ali nepuhul natik iluh ali nakli, “Sakias, bihi wisnabul. Doumeih, yek imas inak ipe nyakitu wilpat.” ");
INSERT INTO apeB_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Ali Sakias nenek atubu nabihi atap ali nanak nenehilaumu Jisas. Ali amam hanamu Sakias ananitu wilpat. ");
INSERT INTO apeB_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Ali douk chanatimaguk elpech chatik namudak ali chape chowimanu lublub Jisas chakli, “Anudak alman nanak nechuh anudak nenek yowenyi atin uli ananitu wilpat.” ");
INSERT INTO apeB_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Douk amam hanak wilpat ali Sakias naitak neyotu naklipu Diginali nakli, “Diginyali, nyak mneke. Nameitu enechi enech yekich echudak eke iyaisech umu bieh. Woblech eke iku elpech douk chanohwagagun umu enechi enech echudak uli. Ali nubuwakih ikli inek loh umu enen elpen inaluken enech enyenyich echudak meyoh umu, nameitu eke wata ibeyechumen ali eke wata iken enech alagun aliga idaleh umu 4-poleih.” ");
INSERT INTO apeB_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Ali Jisas naklipanu nakli, “Doumeih, God wata nanalawepu ipak panatimaguk pape atudak wilpat uli patanamali pape kalbu. Umu monken, nyak chopuk douk nyaitak apudak atup awilop Ebraham ananip. ");
INSERT INTO apeB_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Ali yek Anudak Alman douk yatoglu aduligeinyi elpen uli douk yanamali itimu echebuk elpech douk chanak chawichuk ulimu igakamech inalawech chutanamali chupe kalbu.” ");
INSERT INTO apeB_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Ali ababuk nyultab echech chape chemnek enyudak balan Jisas naklipu Sakias umu, ali Jisas balan nyeilen naklipech enen woblen balan. Umu moneken, anan douk ananaki halakatimu Jerusalem. Ali echech chakli ati abudak nyultab umu God nupe nebenalimu ananich elpech umu eke abutoglu nameitu ati ali Jisas eke nupe echechinu nebenali. ");
INSERT INTO apeB_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Ali anan naklipech nakli, “Ananu nebenali alman nakli nunamu anabul lougunibul wabul umu chunekanali king ali eke wata nutanamalimu ananibul wabul. ");
INSERT INTO apeB_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Ali halakatimu nunak abali, anan nohwalu ananim 10-poleim almam douk henemanu moul uli hanaki ali nokomuk 20 kina 20 kina amam atunu ati. Ali naklipomuk nakli, ‘Ipak punak punek bisnis sulisuli atimu abaludak utabal yek yekepeyabal uli ali punek profit. Ipak punak pupe punek namudak aliga yek wata itanamali.’ ");
INSERT INTO apeB_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Wakuli echebuk elpech douk chanu anan chape atub amnab uli chakliwakanu. Douk namudak ali anan nalik ali echech chakagas anam halau balan hagipechanu. Amam hanak ali hakli, echech chakli wak umu anan nupe echechinu king umu. ");
INSERT INTO apeB_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Wakuli echech wo chumnekom e ali chenekanu king ali wata natanamali. Anan natanamali ati ali nenekumom balan amabuk henekumanu moul uli douk nokomuk utabal ulimu hunaki hutulunu. Ali nakli nusolikom umu amam atunu ati henek makwnibal profetibal utabal. ");
INSERT INTO apeB_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Ali susubeinu natogloli ali nakli, ‘Nebenyali, yek yaku enyudak 20 kina nyak nyekeyenyuk uli yenek bisnis ali profetin douk nyatoglu 200 kina!’ ");
INSERT INTO apeB_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Ali anudak king nakli, ‘Nyak yopinyali alman nyeneme moul uli. Nyak nyanubu nyeneken kalbu. Echudak echech douk gwodich meyoh, wakuli nyak isave nyenek lukautumech kalbu. Namudak ali nyak eke iutinyu nyupe nebenyali ali nyunek bosumu 10-poleilub walub.’ ");
INSERT INTO apeB_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Ali douk susubeinu nanakuk ali anabuk ananu nanaki nakli, ‘Nebenyali, yek yaku enyudak 20 kina nyak nyekeyenyuk uli yenek bisnis ali profetin douk nyatoglu 100 kina.’ ");
INSERT INTO apeB_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Ali king naklipanu nakli, ‘Nyak yautinyamu nyupe nebenyali nyunek bosumu 5-poleilub nebelubi walub.’ ");
INSERT INTO apeB_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Ali anudak ananu nenemanu moul uli nanaki nakli, ‘Nebenyali, nyakibal utabal 20 kina enyudak. Yek yechlehen lupahip ali yenyubuk nyakus. ");
INSERT INTO apeB_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Umu moneken, nyak douk nyihihichinyu atinyaluli, ali yek yanubu elgeiwemenyu. Enechi enech kipaichi chenechubuk uli, nyak isave nyenechuhul. Nyak wo nyusalik ati e. Ali kakwich kipaichi chanowech uli, nyak isave nyanoulimech.’ ");
INSERT INTO apeB_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Ali king naklipanu nakli, ‘Nyak nyanubu yowenyali alman nyenekume moul uli. Yek eke ikwu nyakin yet balan yet douk nyak nyakliyen umu yek uli ali inemenyu kwot. Nyak douk nyadukemech umu agundak yek yanubu nyihihichiwe atuwemu. Ali yatulich yonohul echudak kipaichi chechubuk ulimu. Ali yatulich yanosagunmu kakwich kipaichi chanowech ulimu. ");
INSERT INTO apeB_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Douk namudak ali nyak wo nyunak nyubalemume ben e? Umu yek wata itanamali ali inak inabaluhul umu, yek ilau anabal profetibal chopuk.’ ");
INSERT INTO apeB_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Douk namudak ali king naklipu echebuk elpech cheyotu agnabuk uli nakli, ‘Putulunu enyebuk 20 kina ali puku anabuk ananu douk nasuh 200 kina uli.’ ");
INSERT INTO apeB_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Ali echech chaklipu anudak king chakli, ‘Nebenyali, anan douk wosik anasuh wolobaibali 200 kina.’ ");
INSERT INTO apeB_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Wakuli anan nakli, ‘Yek yaklipepu, ihech elpech douk chusuh wolobaichi echudak uli eke wata chukech enech alagun. Wakuli echebuk douk echudak wakechi, echebuk gwodich echech chenechubuk uli, echech eke wata chutulichech ali chunubu chupeik meyoh. ");
INSERT INTO apeB_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Ali nameitu ipak pulawali echebuk yekich birua douk chakli wak umu yek ipe echechiwe king uli punaki agundak yek yapemu umu itulich ali pech chugak.’” ");
INSERT INTO apeB_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Ali douk Jisas naklipechuk enyudak woblen balan umu julug, ali naitak nalik nape nagimu yah nanamu Jerusalem. ");
INSERT INTO apeB_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Douk nanak aliga halakatimu albudak biolub walub Betfasi uli Betani, douk blape halakatimu maunten Oliv uli ali naklipu biam disaipel halik hanak. ");
INSERT INTO apeB_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Ali naklipam enyudak balan nakli, “Ipak pulik punak blabli wabul blape gani yah uli. Ipak eke punak puwich ati ali eke putik enen nugan donki douk choleyen naduh ali chenyusah nyeyotu. Enyudak donki douk watak enen elpen nyulaheyen e. Ipak putulin ali pukwechihen pulawen punaki. ");
INSERT INTO apeB_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Ali sapos enen elpen nyukli nyusalikepu nyukli, ‘Ipak pokwechihen umu donki?’, ipak puklipech pukli, ‘Diginali nakliyen.’” ");
INSERT INTO apeB_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Ali amam hanak ali hatik umu echudak anan naklipamumech uli chatoglu kobi douk anan naklimu. ");
INSERT INTO apeB_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Ali douk amam hape hokwechik enyudak donki ali cheglemen uli chasolikam chakli, “Ipak pokwechihen umu moneken enyebuk nugan donki?” ");
INSERT INTO apeB_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Ali amam haklipech hakli, “Diginali naklien.” ");
INSERT INTO apeB_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Amam haklipechuk namudak ali halawen hanamu Jisas. Douk hanak hatoglu ali howemu amamig saketog agabahin umu enyudak nugan donki ali hagakamu Jisas nalto nakih netemu. ");
INSERT INTO apeB_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Douk nakih netemu ali enyen nyape nyanak. Ali elpech chape chogalik echechig saketog yah umu chakli chuginohwah. ");
INSERT INTO apeB_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Ali anan nanak natoglu agundak yah hanamu maunten Oliv uli, halakatimu Jerusalem. Ali wolobaichi elpech douk chape chagipechanu chasuh ananin balan uli chenehilau ali chape chenek tenkyumu God. Ali chohwalu nebegun atugun chape chatuk ananin yeul nyakih umu nyanatimaguk God atunu neneken uli moul douk Jisas neneken chatulin uli. ");
INSERT INTO apeB_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Echech chohwalu chakli, “God nunek yopinyimu anudak King douk nanakumali Diginali ananin yeul uli. God ananihw apahw douk hwanubu yopuhw umu apak elpech! Apak mutuk God ananin yeul nyukih.” ");
INSERT INTO apeB_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Ali anam Farisi douk hatanuh echudak wolobaichi elpech uli haklipu Jisas hakli, “Tisa, kwasuhech echudak chasuh nyakin balan chagipechen ulimu chusak.” ");
INSERT INTO apeB_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Ali Jisas naklipam nakli, “Yek yaklipepu, echudak chukli chusak ele, utabal ababal yet eke blupe bluhwalu blutuk yekin yeul nyukih.” ");
INSERT INTO apeB_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Douk Jisas nanaki halakatimu Jerusalem natulubul ali nape nelepobul. ");
INSERT INTO apeB_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Anan nelepobul ali nakli, “Sapos doumeih ipak elpech pape Jerusalem uli pukli pudukemu enyudak pasin douk deke pulawen ali nyunekepu pupe kalbaluli ele, enyen deke kalbu. Wakuli nameitu enyudak pasin nyanabechuk-umepu ali ipak wo pudukemen e. ");
INSERT INTO apeB_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Ali mnek, nyumneh eke hutoglu umu ipakich birua chunaki chiyotu chilihi chilihepu ali chunepu pulpak umu. Echech eke chunubu chulak dodogowibuli nabul chulihi chulihepu. ");
INSERT INTO apeB_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Ali echech eke chunubu chusitu-soteyepu punu ipakich batowich douk chape numun banis uli. Ali echech eke kobi chukutuk anam utam mutemaguk kipaimi kobi douk chalik chalak banis chabalemomu, wak. Umu moneken, ababuk nyultab God nanamali nakli nugakamepamu, ipak wak putulubu pudukemabu e.” ");
INSERT INTO apeB_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Ali Jisas nanak nawich numun banis God ananitu nebetali wilpat tatawomu ali nape nehiyah elpech douk chape chenek salim umu echudak gani numun uli. ");
INSERT INTO apeB_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Ali anan naklipech nakli, “Balan nyetemu God ananik buk uli douk nyakli namudak. God nakli, ‘Yekitu wilpat douk tapemu chunek beten umu.’ Wakuli ipak pagimehumatu kobi douk chakwu olugwih uli chanaki chape chonobechuk umu.” ");
INSERT INTO apeB_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Ali wihluwehlu anan nape nenek skulumech umu ananin balan numun banis God ananitu nebetali wilpat tatawomu. Ali amam nebemi pris hanu amam douk henek skulumech umu God ananin lo uli hanu amudak anam echech Juda echechim nebemi hakli hubo Jisas nugak. ");
INSERT INTO apeB_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Wakuli amam habilak wo hugwatu anah yah umu honu nugak umu e, wak. Umu moneken, chanatimaguk elpech chanubu chakli chumnek nyunatimaguk ananin balan ali echech chakli wak umu chutukemanaguk. ");
INSERT INTO apeB_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Anah nyumnah, Jisas nape numun banis God ananitu nebetali wilpat tatawomu ali nape nenek skulumech umu yopinyi pasin ali nape naklipech God ananin yopinyi balan. Ali ababuk nyultab, amam nebemi pris hanu amudak henek skulumech umu lo uli hanu amudak anam echech Juda echechim nebemi hanaki hatulunu. ");
INSERT INTO apeB_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Ali amam hasalikanu hakli, “Nyak nyalau moneken namba umu nyunek enyudak moul? Ali omuni nyekenyu enyudak namba?” ");
INSERT INTO apeB_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Ali Jisas nebemom balan nakli, “Yek chopuk yakli isolikepu enen balan. ");
INSERT INTO apeB_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Ipak klipe, Jon douk nenek baptaisumech uli omuni nyakanu enyudak moul ali anan dakio nenek baptaisumech? God naklipanu ali dakio nenek baptaisumech o, enech elpech meyoh?” ");
INSERT INTO apeB_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Ali amam hemnek ali amam yet ahape heneyagwleh hakli, “Eke muklipanu moneken balan? Kedeke mukli God nakaneyen umu, anan eke wata nusalikapu nukli ‘Douk namudak ali ipak wo punek bilip umu Jon ananin balan e umu moneken?’” ");
INSERT INTO apeB_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Ali chopuk, sapos mukli elpech meyoh chakaneyen umu, echudak wolobaichi elpech eke chopu chukumopu utabal. Umu moneken, echech chanubu chakli Jon anan douk ananu adulinu profet.” ");
INSERT INTO apeB_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Douk namudak ali amam haklipanu hakli amam wo hudukemech e. ");
INSERT INTO apeB_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Ali Jisas wata naklipam nakli, “Yek chopuk douk namudak ati. Yek eke kobi iklipepamu omuni nyagakome nyeke namba ali yek dakio yenek enyudak moul umu.” ");
INSERT INTO apeB_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Ali Jisas naklipech enyudak woblen balan nakli, “Ananu alman nalib anagu nahabigu ali nau wain. Douk nawanu neyatogu ali naklipu kipaimi almam hanaki henek kontrak henek lukautumagu. Ali chulkwipinu wain nukli olokunu abali, amam hunodi anaguninamu ali anan hudimanu anaguninamu. Ali anan nokomuk nahabigu ali nanamu anabul lougunibul wabul nanak nape loubomu nyultab. ");
INSERT INTO apeB_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Douk nape aliga abudak nyultab umu wainip chulkwip olokwip ali chudiyep umu batoglu. Ali anan nakagas ananu alman douk nenemanu moulaluli nanak umu nuklipam hudili enep chulkwip hukanu nuhwepumanali. Douk nanak natoglu wakuli amudak henek moul nahabigaluli haitak hanu ali wata hakaganu nanak wis wohis. ");
INSERT INTO apeB_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Douk namudak ali anan wata nakagas kipainali nenemanu moul uli nanak. Anan nanak natoglu ali namudak ati. Amam hanu henekumanu yowenyi ali wata hakaganu nanak wis wohis. ");
INSERT INTO apeB_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Ali douk anan natik namudak ali anan wata nakagas ananu alagun nanak. Douk nanak natoglu ali namudak ati. Amam hanu henekanu anagu anagu ali honohul howachanu natoglu adukahigamu nahabigu. ");
INSERT INTO apeB_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Ali neglemu nahabigaluli nakli, ‘Douk, namudak ali yek eke inek malmu? Ati ikagas yekinu nuganinu meyoh douk yek ulkum manubu manohwanaluli nunak. Ati anan douk wosik, amam eke humnek ananin balan.’ ");
INSERT INTO apeB_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Wakuli henek moul yawihas uli hatulunamu nanaki ali amam hanaklipamu hakli, ‘Anudak alman douk neglemu nahabigaluli ananinu nuganinu. Kwali anan eke nulau anineich enechi enech echudak uli. Douk namudak ali apak amanu nugakuk umu apak munolau agudak nahabigu.” ");
INSERT INTO apeB_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Ali amam hanak hahwanu, howachanu natoglu aduk agudak nahabigu ali hanu nagak. ‘Ali noglemu agudak nohobigaluli eke nunaki nunekam malmu amudak henek moul ananigu nohobigaluli? ");
INSERT INTO apeB_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Yek yaklipepu, anan eke nunaki nom hugak ali nuklipu kipaimi hunaki hunek moul ananigu nahabigu.’ Ali douk echech elpech chemnek namudak ali chakli, ‘Apak makli wak umu nunek namobuk, wak.’” ");
INSERT INTO apeB_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Ali Jisas natulich duk ali nasolikech nakli, “Bawogen umu enyudak balan nyetemu God ananik buk uli douk nyakli malmu? Balan douk enyudak. ‘Amudak susubeim utam. douk halak wilpat uli hakli wakam ali hokwleyomuk uli, amam douk manubu matoglu susubeim dudukam utam.’ ");
INSERT INTO apeB_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Ali chunatimaguk elpech douk chugoul chulto amudak utam uli eke chubih plulakelech chunakuk chokugun atugun. Ali sapos amam mubih mubo enen elpen umu, enyebuk elpen eke michaliken nyunubu nyunenemu minyagu.” ");
INSERT INTO apeB_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Jisas naklipech enyudak woblen balan ali amam henek skulumech umu lo uli hanu amam nebemi pris hadukemech hakli enyudak woblen balan douk naklien nenyemu amam. Namudak ali banubu ababuk nyultab amam haitak hakli husleyanu wakuli amam elgeimumaguk echech almam almagou. ");
INSERT INTO apeB_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Ali amam hape hatulugunmu anabu yopubali nyultab umu amam hugwatanu anagun ali adakio huwanu. Ali amam hakagasi anam almam hanaki hape hatulunu. Amudak almam douk nebemi hakagam hanaki uli, amam douk henek loh hakli amam adul duldulimi henek yopinyi atin uli. Amam hanaki hatik Jisas umu hunanu hiyagwleh umu hakli humnekanu nukli niyagwleh enen balan douk wo duldulinyi e ali amam huhwanu hulawanamu nebenalimu gavman umu provins Judia uli ali hunemanu kwot. ");
INSERT INTO apeB_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Ali amudak henek loh uli hanaki ali haklipu Jisas hakli, “Nebenyali, apak madukemech umu nyak douk wo elgeinyamu enech elpech e. Ali nyak douk wo nyuklipu yeguh hwakihech uli elpech kipainyi balan, ali yeguh wakechi nyuklipechuk kipainyi e, wak. Nyak isave nyaklipech atin balan chanatimaguk elpech. Ali nyak isave nyagipech adulin atin balan ali nyenek skulumech kalbu umu God ananin pasin. ");
INSERT INTO apeB_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Douk namudak ali nyak klipapu. Apakin lo douk nyakli malmu? Enyen douk wosik umu munek takis umu nebenalimu gavman uli Sisa waka wak?” ");
INSERT INTO apeB_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","24","Wakuli Jisas douk anadukemech umu agundak amam hakli hunek lohumanamu. Douk namudak ali anan naklipam nakli, “Ipak pugilape anam utam itulum. Enyudak yeul nyanu abalil chetemu amudak utam uli douk omuni enech?” Ali amam hakli, “Sisa ananich wo.” ");
INSERT INTO apeB_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Ali anan naklipam nakli, “Douk namudak ali Sisa ananich echudak imas puku Sisa. Ali God ananich puku God.” ");
INSERT INTO apeB_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Ali amam habilak umu humnekanu niyagwleh enen yowenyi balan agundak wolobaichi elpech chapemu umu hakli hunek kwotumanamen uli wakuli habilak hati wak. Namudak ali amam loguh hwonechlukam umu enyudak balan anan nebeyenyumom uli. Ali amam balan wakam heyotu bleilu. ");
INSERT INTO apeB_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","28","Amam Sadyusi isave hakli chagak uli eke kobi wata chitaki wak. Ali anam amudak Sadyusi hanaki Jisas napemu ali hasolikanu hakli, “Nebenyali tisa, seiwak Moses nowemumapaguk enen balan. Ali balan douk nyakli namudak, ‘Sapos ananu alman nusuh onok almatok ali Okwok kobi kuloguk enech batowich, ali anan nugakuk umu, ananinu owaninu imas nukwaul. Anan nukwaul umu wata chulali batowich umu chugluk sanineigu iwagu.’ ");
INSERT INTO apeB_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Ali anabu nyultab, 7-poleim nugamim douk atich mamechich chomlali uli hape. Ali saninu nasuh onok almatok ali batowich wo nulaguk enech e ali nagak. ");
INSERT INTO apeB_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Ali douk saninu nagakuk ali nanosuhwanali agab uli nokwaul. Anan nokwaul ali namudak ati. Batowich wak nulaguk enech e ali nagak. ");
INSERT INTO apeB_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Douk anan nagakuk ali nanosuhwanali agab anabuk uli nokwaul. Ali namudak ati. Batowich wo nulaguk enech e ali chopuk nagak. Douk namudak ali amudak 7-poleim nugamim hanatimaguk hasuh okudak almatok ali batowich wak ananu nulaguk enen e. Ali amam chopuk hagak hatuh. ");
INSERT INTO apeB_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Ali okwok chopuk kwagak kwagikuk. ");
INSERT INTO apeB_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Douk namudak ali ababuk nyultab chagak uli wata chitakimu, okudak almatok eke kwitaki ali kupemu meinali? Nyak nyadukemech, susubati hanatimaguk amudak 7-poleim douk nanu hahwak uli atum.” ");
INSERT INTO apeB_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Ali Jisas naklipam nakli, “Nameitu abudak nyultab, almam almagou isave chanosupu. ");
INSERT INTO apeB_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Wakuli echebuk elpech douk God nakli wosik umu wata chitaki iwagas ali chunak chupe iluh heven uli eke kobi chunosupu ati, wak. ");
INSERT INTO apeB_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Echech eke chupe kobi douk ananich ensel umu ali eke kobi chugak, wak. Echech achape God ananich batowich. Umu moneken, anan douk wata nechuhul chaitak uli. ");
INSERT INTO apeB_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Ali Moses douk nanubu nagilapopu duldul umu chagak uli eke wata chitakimu. Enyudak balan seiwak Moses nenyemu God ananik buk ulimu agundak nyih hanui enen chokwinyi lowag ulimu douk nohwalu Diginali nakli, ‘Diginali anan douk Ebraham nanu Aisak uli Jekop amaminu God.’ ");
INSERT INTO apeB_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Douk namudak ali enyudak balan douk nyakli anudak God anan douk wo chagak uli echechinu God e, wak. Anan douk chape uli echechinu God. Anan natulich umu, anan douk nakli echech chanatimaguk douk chape uli atich.” ");
INSERT INTO apeB_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Ali amudak anam douk henek skulumech umu God ananin lo hobemanu balan Jisas hakli, “Tisa, nyak nyanubu nyobemom balan kalbu.” ");
INSERT INTO apeB_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Ali amam elgeim umu husolikanu enen alagun balan umu. ");
INSERT INTO apeB_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Aliga ali Jisas naklipam nakli, “Ali elpech isave chakli Devit ananinu yamenu eke nutoglu Krais, douk God natalihanu nakaganu nanamali nunolau elpech ulimu moneken? ");
INSERT INTO apeB_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","43","God ananik buk douk chohwalok umu Sam uli, Devit yet douk nowemu balan nyetemu namudak nakli, ‘Diginali naklipu yekinu Diginali nakli, “Nyak nyupe agundak onuwemu aliga ibo nyakim birua hubihuk.” ’ ");
INSERT INTO apeB_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Ali tik. Devit yet douk nohwalu anudak alman Krais ananinu Diginali. Douk namudak ali Krais eke wata nutoglu Devit ananinu yamenu malmu?” ");
INSERT INTO apeB_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Ali chanatimaguk elpech wata chape chemnek Jisas umu agundak neyagwleh umu. Ali anan naklipu ananim disaipel nakli, ");
INSERT INTO apeB_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Ipak pugamu punenek yologimu ipak kobi pugipech amudak henek skulumech umu lo uli amamim yowenyi pasin. Amam hanubu henehilaumu hakli hupemu hulu lowihi ati luseh ali hupe hulahemu elpech chutulum ali chukli amam yopumi nebemi almam. Ali chopuk, hakli hulahe hunak agnabuk elpech isave chowachabal chapemu, umu chutulum ali chunemom gude. Ali hanak echech Juda chape cheyagwleh balan ogwi wilag umu, amam hakli hunak hupe chakus chalik uli siahas abudak nyultab chenek lotu abali. Ali chenek nebeguni woligun umu, amam hakli hunak hupe chakus chalik uli siahas. ");
INSERT INTO apeB_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Ali amam isave hanak hawich almam hagak howobukuk uli almagou owowig wilag ali hatulu honohul owowich echudak. Ali henek beten hasalik God umu, amam henek loulounyi meyoluhin beten umu elpech chutulum. Wakuli kwali God eke nubemom amamin yowenyi ali eke nunekam humnek nebehi nyih.” ");
INSERT INTO apeB_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Douk Jisas nepuhul natulich ali natik elpech douk chanabuk wolobaichi echudak uli chape chenek ofa. Echech chautu utabal blagluk bogis sakus numun God ananitu nebetali wilpat uli. ");
INSERT INTO apeB_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Ali anan natik onok utabal wakokwi almatok douk anan nagak nokubukuk uli. Okwok umu kwanaki ali kwonek ofa kwautuk biabal chokubali utabal blagluk asudak bokis. ");
INSERT INTO apeB_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Ali Jisas natuluk namudak ali nakli, “Aduligu atugu yek yaklipepu. Okudak anan nagak nokubukuk uli douk kwanubu utabal wakok. Wakuli okwok kwanaki kwautu wolobaibali utabal kwechalakuk echudak chanatimaguk. ");
INSERT INTO apeB_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Echudak chanatimaguk elpech, douk wolobaibali utabal blakusumechuk ali chasuhwi gwodubal meyoh chanaki chenek ofa. Wakuli okudak almatok kwanubu utabal wakok. Wakuli gwodubal okwok kwanabalubuk umu kunatal echudak umu douk kwanaki kwonek ofa kweyatabal kwoku God.” ");
INSERT INTO apeB_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Anam Jisas ananim disaipel hatik God ananitu nebetali wilpat ali hape heneyagwleh hakli, “Atudak wilpat douk tanubu dudukatu. Atat douk chakwu dudukabal atubal utabal chalatu. Ali chopuk, chaginohwatu chakwu yopiyopichi echudak douk elpech chanaki chape choku God umu.” Ali Jisas nemnekam ali nakli, ");
INSERT INTO apeB_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Chanatimaguk echudak nameitu ipak patulich uli, anabu nyultab eke kobi wata anam utom mutemu dadag kipaimi kobi douk nameitu patulubal umu, wak. Blunatimaguk eke blubih blukus atap atugun.” ");
INSERT INTO apeB_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Ali amam hasalikanu hakli, “Tisa, eke meibali nyultab enyebuk nyak nyaklien uli nyutoglu? Ali eke moneken nyulik nyutoglomu mutulin ali mudukemech umu enyudak hevi douk ahalakatimu nyutoglu?” ");
INSERT INTO apeB_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Ali Jisas nakli, “Ipak pugamu punenek yologimu kobi anam almam hunaki hunek lohumepu ali hunekepu pugipech amamin balan, wak. Wolobaimi almam eke hunaki sulisuli ibu nyultab. Ananu eke nunaki nukli, ‘Yek Krais douk God natalihe ali nakage yanaki uli.’ Ali anam eke huklipepu hukli nyultab douk ahalakatimu butoglu. Wakuli ipak kobi pumnek amamin balan ali punak pugipecham, wak. ");
INSERT INTO apeB_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Ipak eke pumnek balan umu wanohw hwutoglu kipailubi lougunilub walub umu, o chupe chune-chichilak chulpak umu agundak chukli wak nebemimu hupe echechim nebemimu, ipak pumnek ali kobi elgeipu, wak. Echudak eke chulik chutoglu. Wakuli hugikuk uli nyumnah eke kobi kebes hutoglu.” ");
INSERT INTO apeB_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Ali Jisas balan nyeilen nakli, “Enen kantri eke chitak chunu kipainyi kantri chulpak. Ananu king nunu ananinu lain eke chitak chunu kipainali king nunu ananich chulpak. ");
INSERT INTO apeB_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Nebekwi enyik eke kutuk. Ali eke nebehi nyulbiah hech. Ali yowechi echudak eke chutoglu chunek anagali anagu agudak gubo elpech. Echech eke chutoglu sulisuli ilub walub. Ali ipak eke putik enech sik echudak chutoglu iluh utagu ali eke elgeipu. ");
INSERT INTO apeB_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Wakuli ababuk nyultab echudak kobi kebes chutoglu abali, kipaichi elpech eke chulik chunaki chuhwepu chunekepu anagu anagu. Echech eke chulawepu piyotumu kwotog numun echech Juda chape cheyagwleh balan ogwi wilag ali eke chuwechikepu punak punek kalabus pupe. Ali echech eke chukegepu punak piyotu agundak amam king hunu nebemumali gavman uli hapemu. Echech eke chunekepu namudak umu moneken, ipak douk pagipech yek ali paklipech yekin balan. ");
INSERT INTO apeB_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Ali ababuk nyultab echech chunekepu namobuk umu, ababuk douk yopubali nyultab umu puklipech yekin yopinyi balan umu. ");
INSERT INTO apeB_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Douk namudak ali ipak kobi elgeipu pukli kedeke pubeyenyumech malmu echechin balan, wak. ");
INSERT INTO apeB_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Umu moneken, yek yet eke igakomepu ikepu balan douk eke ipak piyagwlehen uli nyunu yopinyi tinytin. Ali ipakich birua eke chubilak kobi chichogeik o chubouk enyudak yekin balan douk yagilapepeyen uli nyubihuk, wak. ");
INSERT INTO apeB_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Ipakich mamechich o sachich uli owachich o atus awilos umu o enech ipakichi elpech eke chugilapu ipakich birua umu agnabuk ipak papemu ali eke chunak chuhwepu chulawepu chunak chunek kwotumepu. Ali enepu eke chunubu chepu pugak. ");
INSERT INTO apeB_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Chunatimaguk elpech eke chunubu chukliwakepu ali chukepaguk agabus. Umu moneken, ipak douk panubu yekipu elpech douk pagipech yek uli. ");
INSERT INTO apeB_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Wakuli God eke nunek lukautumepu pupe kalbu ali eke kobi anabul atubul ahibul blatoglu ipakigas balagas uli blunak bluwichuk, wak. ");
INSERT INTO apeB_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Ali sapos ipak pugipech yekin balan ali piyotu dadag umu, ipak eke pupe kalbu eheh nyumneh.” ");
INSERT INTO apeB_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Ali Jisas balan nyeilen nakli, “Ali ababuk nyultab putik ami chunaki chiyotu chulihi-chulih abuldak wabul Jerusalem abali, ipak eke pudukemech pukli nyultab douk ahalakatimu butoglomu chuwolubul umu. ");
INSERT INTO apeB_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Ali ababuk nyultab, elpech chape provins Judia uli imas chulhwas chultomu mauntenab chunak chupeik. Ali echebuk douk chape numun Jerusalem uli imas chutukemabuluk. Ali echebuk douk chapeli kipailubi walub blapeli halakatimu Jerusalem uli kobi wata chunaki chuwich Jerusalem, wak. ");
INSERT INTO apeB_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Ababuk douk God ananibu nyultab umu nubemech yowenyi echudak elpech douk chapemu chenek enenyi enen yowenyi uli. Enyudak eke nyutoglomu nyunek nyanatimaguk balan nyetemu God ananik Buk uli douk nyaklimu enyudak eke nyutoglomu Jerusalem uli nyutoglu adulin atin. ");
INSERT INTO apeB_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Ali mapiliyu apaluhiwali almagou wunu owobuk douk wusuh cheil chabah uli batowich ehebuk nyumneh uli. Nyanubu nebenyi hevi eke nyutoglu abudak amnab. God eke nunubu nyihihichinu ali eke nunubu nunekumech nebetali kwot echech Isrel. ");
INSERT INTO apeB_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Enech eke chubleyech bainatog, ali enech eke chuwechikech chulawech chunamu nyunatimaguk kantri. Ali echudak elpech douk wo Juda uli e eke chichobul chupe nebechimu abuldak wabul Jerusalem. Echech eke chupemu aliga echechibu nyultab God natalihabomech umu chupe nebechumali bunak butuh.” ");
INSERT INTO apeB_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Ali Jisas balan nyeilen nakli, “Enenyi enen eke nyutoglomu wabinu nunu nyumnahinu aub uli unib. Chanatimaguk elpech chape abudak amnab uli eke chumnek umu agundak yous yoweg ali nebebi molub butuk umu. Ali echech eke elgeich ali echechiluh apaluh eke hlunubu yoweluh. ");
INSERT INTO apeB_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Wolobaichi elpech eke chutik enyudak douk anyaklimu nyutoglu abudak amnab uli ali echech eke chunubu elgeich. Ali echech eke nabes sunonugeyech ali chubih chugoul chukus atap kobi douk chagak ulimu. Umu moneken enechi enech chape iluh utagaluli chunu aub uli unib eke guldugolech ali chunotuki. ");
INSERT INTO apeB_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Ali ababuk nyultab eke adakio chutik yek Anudak Alman douk yatoglu aduligeinyi elpen uli ilali onog olug inaki. Yek eke inubu ihiyatiki ali dodogowiwe otuwe inaki. ");
INSERT INTO apeB_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Ali echudak chupe chutoglu abali, ipak pitak piyotu ali pipuhul putulugun. Umu moneken, ababuk nyultab God nakli wata nutalipu ali nukwachihepamu yowenyi ipak pape peneken uli ali nulawepu putanamali pupe kalbamu douk abanaki halakati.” ");
INSERT INTO apeB_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Ali Jisas naklipech enyudak woblen balan nakli, “Ipak punek tin umu enyudak lowag yeulin umu fik nyanu kipaigasi lowas. ");
INSERT INTO apeB_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Abudak nyultab putik umu agagas asupe sunaleh abali, ipak eke pudukemech pukli wah hutau abali nyultab douk ahalakatimu butoglu. ");
INSERT INTO apeB_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Ali douk eke namudak ati. Ababuk nyultab ipak putik enyudak nyanatimaguk hevi douk dukwechuk yaklipepamen uli nyupe nyutoglomu, ipak eke pudukemech umu abudak yopubali nyultab douk God eke nupe nebenalimu ipak ananipu elpech umu douk ahalakatimu butoglu. ");
INSERT INTO apeB_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Ali aduligu atugu yek yaklipepu. Doumeichi elpech eke kobi kebes chugak chutuh ali enyudak nyunatimaguk hevi douk yek yaklipepamen uli eke nyutoglu. ");
INSERT INTO apeB_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Chunatimaguk echudak chape iluh utagaluli chunu utagu agag yet, gunu chunatimaguk chape abudak amnab uli chunu amnab chopuk eke chunubu bulkwolech chunak chuwichuk. Wakuli yekin balan eke nyunubu nyupe eheh nyumneh.” ");
INSERT INTO apeB_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Ali Jisas balan nyeilen naklipam nakli, “Ipak imas punenek yologi. Kedeke wosik ati ipak pupemu puwak wolobaigun atugun woligun o puwak dodogowibali abal pugugaku ali pupemu punek warimu enechi enech apudak atapich atich. Sapos ipak pupemu punek enyudakmali atin umu, ahudak yek itanamali ahi nyumnah eke hutoglomepu ahudak atuh kobi enen mahin wo nyudukemech e ali ahudak atuh nyeil naduh ali loguh hwonechluken umu. ");
INSERT INTO apeB_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Ahudak nyumnah eke hutoglomu chanatimaguk elpech chape abudak amnab uli. ");
INSERT INTO apeB_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Namudak ali wihluwehlu ipak imas punek was pupe. Ipak punek beten pusalik God wihluwehlumu nugakamepu ali abudak yowebali nyultab bukli butoglomu, ipak wosik eke piyotu dodogowipu aliga punak putoglu piyotu agundak yek Anudak Alman douk yatoglu aduligeinyi elpen uli itoglu ipemu.” ");
INSERT INTO apeB_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Ali ehebuk nyumneh Jisas nape numun banis God ananitu nebetali wilpat tatawomu ali nape nenek skulumech ananin balan. Ali webus abali, anan isave naltomu maunten Oliv ali nanak nechuh agnabuk. ");
INSERT INTO apeB_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Ali chanatimaguk elpech isave chaitak agliguh atuguh chanamu God ananitu nebetali wilpat tatawomu umu chumnek ananin balan. ");
INSERT INTO apeB_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Ahudak nyumnah echech Juda chunek agundak nebeguni Pasovaigun woligun douk chawak bret douk chotoweh wo titak nebetali uli e douk ahanaki halakati. ");
INSERT INTO apeB_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Ali amam nebemi pris hanu amudak anam douk henek skulumech umu lo uli hape hatimu anah yah umu hakli hubo Jisas nugak umu. Umu moneken, amam elgeim umu hakli kedeke huneken yopugunmu ali almam almagou chom. ");
INSERT INTO apeB_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Ali Satan nawich Judas douk nanaki wabul Kariot uli. Anan douk ananamu amudak Jisas ananim 12-poleim disaipel. ");
INSERT INTO apeB_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Douk Satan nawichanu ali nanak nanu amam nebemi pris hanu amam henek wasumu God ananitu nebetali wilpat uli amamim nebemi heyagwleh umu huwechik Jisas umu. Ali anan naklipam nakli wosik umu nugilapam umu Jisas nanak napemu ali amam hunak huhwanu huwechikanu. ");
INSERT INTO apeB_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Ali douk hemnek namudak ali amam hanubu henehilau halikuk. Ali amam habo balan umu hakli eke hukanu anabal utabal. ");
INSERT INTO apeB_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Ali Judas nakli wosik umu hukanu utabal umu ali anan anape natulugunmu anabu yopubali nyultab umu nugilapam Jisas hunak huhwanamu. Anan nape natulugun umu nakli nutik kobi enech elpech chunanu chupe ali anan nunak nuklipam hunaki huhwanu hulawanu hunak. ");
INSERT INTO apeB_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Aliga ali ahudak nyumnah hanak hatoglolimu chuwak bret douk chotoweh wo titak nebetali uli e. Ali ahabuk nyumnah, echech isave chabo nugach sipsip umu chichah ababuk nyultab chunek agundak nebeguni Pasovaigun woligun umu. ");
INSERT INTO apeB_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Ali Jisas naklipu Pita uli Jon enyudak balan ali nakagam hanak. Nakli, “Ipak punak ali punek redimu agundak Pasovaigun woligun umu apak mugnah uli.” ");
INSERT INTO apeB_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Ali amam wata hasolikanu hakli, “Nyak nyakli wunak wunek redimogun agnumu?” ");
INSERT INTO apeB_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Ali anan naklipam nakli, “Ipak mnek! Ipak eke punak puwich ati wabul ali ananu alman nasahi anap abal bloleyopi malup uli eke nugwatepu. Ali pugipechanu punak puwich atabuk wilpat anan nunak nuwichatali. ");
INSERT INTO apeB_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Ipak puwich ali puklipu atabuk wilpatinali pukli, ‘Apakinu Nebenali Tisa nakli amudak rum douk elpech chape chechuh omi douk eke anan nunu apak ananipu disaipel muwak Pasovaigun woligun umu douk omumu?’ ");
INSERT INTO apeB_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Ali anan eke nugilapepu anam nebemi iluhim rum douk echudak chape chawak woligunechi chakusomi. Ali ipak pulto pukih pupe punek redimapamu woligun.” ");
INSERT INTO apeB_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Ali douk hanak ali hatik umu enyudak nyatoglu kobi douk dukwechuk Jisas naklipam umu. Ali amam henek redimu Pasovaigun woligun. ");
INSERT INTO apeB_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Douk aliga abudak nyultab umu huwak woligun abali batoglu, ali Jisas nanu ananim aposel hanaki hape halihi halih tebol. ");
INSERT INTO apeB_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Amam hape ali anan naklipam nakli, “Yek yanubu oub baitak umu inepu muwak agundak Pasovaigun woligun iyuh ali adakio ilau nebehi nyih. ");
INSERT INTO apeB_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Aduligu atugu yek yaklipepu. Yek eke kobi wata iwak anagun agundakmali Pasovaigun woligun, wak. Yek eke ipe namudak aliga wata inepu muwak aduligeigun Pasovaigun woligun agnabuk God ananich elpech chapemu.” ");
INSERT INTO apeB_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Ali Jisas nohuli anap kap wainibal abal bloleyapi nenek beten nenek tenkyumu God ali naklipam nakli, “Suh kap ali ipak punatimaguk pubalah punoblowabal ati. ");
INSERT INTO apeB_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Yek yaklipepu, nameitu aliga kwali, yek eke kobi wata iwak anabal abaludakmali wainibal abal, wak. Yek eke ipe namudak aliga ababuk nyultab douk eke God nupe nebenalimu ananich elpech umu butoglu.” ");
INSERT INTO apeB_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Ali wata nohuli bret nenek beten nenek tenkyumu God ali nagwudukatu nakam. Ali naklipam nakli, “Atudak bret douk yekihw yegenyihw. Yek yekepeyohw umu igakomepu. Ali ipak pupe punek namudak umu ipak ulkwip wata pulomu yek.” ");
INSERT INTO apeB_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Ali douk amam hawak bret heyatatu ali wata nenek namudak ati. Anan nohuli kap wainibal abal blolomu nakam ali naklipam nakli, “Abaludak wainibal abal ababal douk yekig butog douk eke che ali gutukwlemu gwugakamu ipak elpech uli. Ogudak butog douk gwonek enyudak God ananin nupolein adulin atinyi balan kontrak nyatoglu dodogowin. ");
INSERT INTO apeB_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Wakuli tik. Anudak alman douk eke nugilapu yekich birua ali chuhwe chulawe uli douk anudak nane wape wawak woligun enyudak tebol. ");
INSERT INTO apeB_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Yek Anudak Alman douk yatoglu aduligeinyi elpen uli eke che igak kobi douk seiwak God anaklimu eke chugimahumemu. Ali anabuk douk nugilapu yekich birua umu yek uli, anan douk yanubu yakli mapilinu. Umu moneken, enen nyanubu nebenyi hevi eke nyutoglomanu.” ");
INSERT INTO apeB_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Ali douk Jisas naklipam namudak ali amam hape hanasalimamu eke meinali nuneken enyudak. ");
INSERT INTO apeB_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Ali amam disaipel hohul enen balan ali hape halpoken umu hakli amam yet eke meinali nunubu nyape amaminu nebenali. ");
INSERT INTO apeB_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Ali Jisas naklipam nakli, “Amam king hape abudak amnab uli douk hanubu dodogowim atum hanalak hapemu elpech umu chunek enech echudak, ali echech isave chemnek amamin balan ali chenekech. Ali amabuk douk hape echechim nebemi uli, elpech isave chohwalam chakli, yopumi hagakamech uli. ");
INSERT INTO apeB_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Wakuli ipak kobi punek namudak, wak. Ipak meinali alman nukli niyotu nulikepaluli, anan imas nunubu nupe kobi douk ananu nape nugikuk yeul wakanalimu. Ali anabuk douk nukli nupe ipakinu nebenali uli, anan imas nunubu nupe kobi douk ananu yeul wakanu nenek moul meyoh umu kipaichi ulimu. ");
INSERT INTO apeB_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Ipak pakli meinali alman douk nape nebenalimu ipak panatimaguk? Anabuk douk nape tebol nawak woligun uli o anudak douk noluhumanu woligun uli? Adul, nebenali douk anudak nape tebol nawak woligun uli. Wakuli yek douk yanepu mape ali yagimeh kobi douk anudak noluhumanu woligun uli ali yenek moul umu yagakamu ipak. ");
INSERT INTO apeB_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Ali abudak nyultab hevi nyatoglu nyechakome abali, ipak douk pane huluk ali wo putukemeik e. ");
INSERT INTO apeB_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Ali yekinu Aninu douk noke namba umu ipe nebewelimu elpech. Ali douk namudak ati. Yek douk yekepu namba umu ipak pupe nebepalimu punek bosumu enech elpech. ");
INSERT INTO apeB_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Yek douk yenekepu namudak umu pune mupe yekin tebol muwak woligun uli abal agnabuk yekich elpech chapemu. Ali ipak eke putemu dudukech siahas kobi douk amam king atum hapenyich uli. Ali ipak eke pupe nebepali pusuh kwotog umu asudak 12-poleis awilas echech Isrel.” ");
INSERT INTO apeB_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Ali Jisas nakli, “Saimon, Saimon! Nyak mnek! God anaklipanu wosik Satan umu nichakamu ipak punatimaguk umu puneyais umu putukemaguk bilip kobi douk cheyomaguk ouguhitu wit umu. ");
INSERT INTO apeB_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Wakuli Saimon, yek ayenek beten yasalik God umu nugakamenyamu kobi nyutukemaguk nyakin bilip umu yek, wak. Ali ababuk nyultab nyutanamu nyugipech yek abali, nyak wata nyugakamu nyakim sahlim owahlim douk hagipech yek ulimu hiyotu dadag.” ");
INSERT INTO apeB_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Ali Pita wata naklipu Jisas nakli, “Diginyali, yek ayenek redimu inenyu wune kalabus ali chopuk yaklimu inenyu wugak ati.” ");
INSERT INTO apeB_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Ali Jisas naklipanu nakli, “Pita, kehikib wab, owotu eke kobi kebes tiyagwleh ali nyak eke anyunekuk loh bieh atuh nyukli nyak wak nyudukemu yek e.” ");
INSERT INTO apeB_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Ali Jisas wata naklipam nakli, “Likuk yek yekegepu panak penek moul umu, ipak wo punosuh begas uli su wunu paus panaluk utabal umu e. Ali ababuk nyultab ipak panak meyoh umu, ipak tukwahepamu enech echudak waka wak?” Ali amam haklipanu hakli, “Wak, apak wo tukwahapamu enech echudak e.” ");
INSERT INTO apeB_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Ali anan naklipam nakli, “Wakuli nameitu, anabuk douk nanaluk utabal anas paus uli o nanabuk anagu beg uli imas nunohwech. Ali meinali douk bainat wakanali imas nunek salimumu ananitu saket ali nunatal anatu bainat. ");
INSERT INTO apeB_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Umu moneken, balan douk chenyemu nyaklimu yek ali nyetemu God ananik buk uli imas nyutoglu adulin. Balan enyudak, ‘Anan douk chonowanuhuk yowemi henek yowenyi uli.’ Adul, enyudak balan douk nyaklimu yek uli nameitu douk nyape nyatoglu adulin.” ");
INSERT INTO apeB_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Ali amam disaipel haklipanu hakli, “Diginyali, tiki. Apak douk masuh biog bainatog.” Ali anan naklipam nakli, “Julug.” ");
INSERT INTO apeB_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Ali Jisas natukemaguk Jerusalem natoglu naltomu maunten Oliv kobi douk wihluwehlu anan nape nanak umu. Ali ananim disaipel hagipechanu hanak. ");
INSERT INTO apeB_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Ali douk anan nanak natoglu ali naklipam nakli, “Ipak imas punek beten umu ababuk nyultab traim nyutoglo-mepamu, ipak kobi punek yowenyi.” ");
INSERT INTO apeB_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Douk naklipamuk namudak ali natukemamuk nanak kwalowi lougun. Lougun umu douk kobi elpech chuwachak anam utam munak mubih umu. Douk nanak ali nabih noduk ohlubus nape nenek beten nakli, ");
INSERT INTO apeB_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Aninu, sapos nyukli wosik umu, nyak kobi nyukutuk enyudak hevi nyutoglome, wak. Wakuli yek yakli wak umu nyugipech yekin laik, wak. Nyak nyugipech nyakin atin laik.” ");
INSERT INTO apeB_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Ali enen ensel nyapeli iluh heven uli nyabihi nyatoglomanu ali nyagakamanu nyenekanu dodogowinu. ");
INSERT INTO apeB_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Ali ananin michin nyanubu yowen ali nanubu dodogowinu atunu nape nenek beten nechalakuk dukwechuk nalik neneken umu. Ali beyotog gweyohol-unaluli gwau gwagluk atap kobi douk butog gwakihi gwau gwagluk umu. ");
INSERT INTO apeB_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Douk nenek beten julug ali naitak nanak umu nutik ananim disaipel. Ali nanakumogu, anan natulum umu amam hechuh hagak. Amamich michich chanubu yowech umu enyudak douk eke nyutogloluli ali amam wo dodogowim e ali hechuh. ");
INSERT INTO apeB_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Ali anan nanak nasolikam nakli, “Ipak pechuh umu moneken? Kitak ali punek beten umu ababuk nyultab traim nyutoglo-mepamu, ipak kobi punek yowenyi.” ");
INSERT INTO apeB_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Ali douk Jisas wata nyape neyagwleh ati, wakuli Judas, ananamu amudak 12-poleim disaipel naliki wolobaimi almam hanak hatogloli. Ali Judas nanaki halakatimu Jisas umu nakli nunoplikanu. ");
INSERT INTO apeB_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Wakuli Jisas naklipanu nakli, “Judas, douk nyak nyagilapech yek Anudak Alman douk yatoglu aduligeinyi elpen uli yekich biruamu agundak nyanaki nyanaplikemu, waka?” ");
INSERT INTO apeB_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Ali Jisas ananim disaipel douk hananu heyotu uli hatik umu enyudak douk Jisas ananim birua hakli huneken-umanaluli ali amam hasolikanu hakli, “Diginyali, nyak nyakli malmu, apak mukumom apakig bainatog waka?” ");
INSERT INTO apeB_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Ali ananu amam disaipel natupak ananu nenek moulamu nanubu nebenali pris uli ananih anuh atah ali hanubu tukalah. ");
INSERT INTO apeB_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Wakuli Jisas nakli, “Julugin enyebukmali pasin.” Ali nasuh anudak alman ananih atah hatakamu ali ahah wata yopuh. ");
INSERT INTO apeB_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Ali Jisas nasalik amam nebemi pris hanu amam henek wasumu God ananitu nebetali wilpat uli amamim nebemi hanu echech Juda echechim nebemi douk hanamali huhwanu hulawanu uli. Anan nasolikam nakli, “Ipak pakli yek onowe yoweweli alman douk yenek onohw wanohw uli o, yakwu aluh ulimu pasuhi bainatog uli lowas umu punaki puhwe pulawemu? ");
INSERT INTO apeB_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Eheh nyumneh yek yanepu mape numun banis God ananitu nebetali wilpat tatawomu wakuli ipak wak kwalowi puklimu puwemeye ipakis wis puhwe e. Wakuli nameitu abudak nyultab douk banubu ipakibu nyultab umu Satan nupe yomotokweh atih ali dodogowinu atunamu nubo yek ibihuk umu.” ");
INSERT INTO apeB_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Douk Jisas neyagwleh umu julug ali hahwanu halawanu hanak hawich nanubu nebenali pris ananitu wilpat. Ali Pita nagikuk ati nape nagipecham nanak. ");
INSERT INTO apeB_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Ali agnabuk anam almam hejigul nyih olokohunis umu banis douk chenekas salihi salih nanubu nebenali pris ananitu wilpat tatawomu. Ali amam hanak hanopemu nyih hape atugun ali Pita chopuk nanak nanopemeh. ");
INSERT INTO apeB_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Ali onok kwonek moul agnabuk uli kwanaki kwatulunamu napemu nyih ali kwatulunu duk kwakli, “Anabuk alman chopuk douk nanu Jisas uli.” ");
INSERT INTO apeB_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Wakuli Pita nenek loh nakli, anan wo nudukemanu e Jisas. ");
INSERT INTO apeB_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Ali douk chapegu wo loubali e ali ananu alman wata natulunu ali nakli, “Nyak chopuk douk nyatanuh Jisas ananim uli.” Wakuli Pita nakli, anan wak. ");
INSERT INTO apeB_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Ali chape aliga loubamu nyultab halakatimu 1 aua banakuk, ali kipainali neyagwlehi nebegun nakli, “Aduligu, atugu. Anudak alman douk nanu Jisas uli. Umu moneken, anan chopuk douk napeli provins Galili uli.” ");
INSERT INTO apeB_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Wakuli Pita nakli, “Nya, balan nyak nyeyagwlehen uli, yek wak idukemen e.” Ali Pita wata nape neyagwleh ati ali owotu teyagwleh. ");
INSERT INTO apeB_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Ali douk owotu teyagwleh ali Diginali natanamali natulunali duk Pita. Ali Pita wata ulkum molomaguk enyudak balan nabatik Diginali nakli-paneyenyi. Balan enyudak, “Owotu eke kobi kebes tiyagwleh ali nyak eke anyunekuk loh bieh atuh nyukli, nyak wo nyudukemu yek e.” ");
INSERT INTO apeB_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Ali Pita ulkum molomu enyudak balan ali natoglu aduk ali neleh chukeich chanu. ");
INSERT INTO apeB_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Ali amabuk douk heyotu henek was umu Jisas uli henekanu enenyi enen heyakasunu ali hanu. ");
INSERT INTO apeB_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Ali amam howechik ananis nabes anap lupahip ali hasalikanu hakli, “Nyak klipapu kobi amam profet umu, nameitu douk omuni nyanyu?” ");
INSERT INTO apeB_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Ali amam henek tok bilasumanu ali hape heyagwlehumanu wolobainyi enenyi enen yowenyi balan chopuk. ");
INSERT INTO apeB_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Douk gagluk ali echech Juda echechim nebemi hanu nebemi pris hanu amudak anam henek skulumech umu lo uli hanaki hape atugun. Ali echech chalawali Jisas chanaki agundak amam hapemu. ");
INSERT INTO apeB_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Ali amam hasolikanu hakli, “Nyak klipapu, anudak alman Krais douk God naklimu nutalihanu nukaganu nunamali nunolau elpech uli douk nyak?” Ali anan naklipam nakli, “Sapos iklipepamu, ipak eke kobi punek bilip umu yekin balan. ");
INSERT INTO apeB_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Ali sapos yek isolikepu enen balan ele, ipak deke kobi pubeyenyume. ");
INSERT INTO apeB_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Wakuli nameitu aliga kwali, yek Anudak Alman douk yatoglu aduligeinyi elpen uli eke ipe anunamu nanubu dodogowinu atunali God.” ");
INSERT INTO apeB_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Ali hanatimaguk hasolikanu hakli, “Namudak ali nyak douk nyanubu God ananinyu Nuganinu?” Ali anan naklipam nakli, “Ipak pakli duldul. Yek douk kobi ipak paklimu.” ");
INSERT INTO apeB_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Ali amam heneyagwleh hakli, “Apak kobi wata mulimu enen alagun balan. Balan douk enyudak amemneken anan yet nakliyen.” ");
INSERT INTO apeB_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Douk amam hemnek Jisas ananin balan umu julug ali amam hanatimaguk haitak halawanu hanamu Pailat douk nape nebenalimu gavman uli. ");
INSERT INTO apeB_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Ali hanak hape henek loh henemanu balan hakli anan nape nohul elpech umu chunu gavman chulpak. Ali chopuk hakli anan nakli echech kobi chunek takis umu nanubu nebenalimu gavman uli Sisa. Ali chopuk hakli anan nakli anan douk Krais, ananu king douk God natalihanu nakaganu nanamali nunolau elpech uli. ");
INSERT INTO apeB_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Ali Pailat nasolikanu nakli, “Nyak douk echech Juda echechinu king?” Ali Jisas naklipanu nakli, “Adul, yek douk kobi nyak nyaklimu.” ");
INSERT INTO apeB_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Ali Pailat wata naklipu amam nebemi pris hanu echudak wolobaichi elpech nakli, “Yek wak igwatu enen yowenyi anan neneken uli e.” ");
INSERT INTO apeB_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Wakuli amam dodogowim atum hakli, “Anan nenek skulumech enen balan echech almam almagou ali nohul echechiluh apaluh umu chunu gavman chulpak. Enyudak douk nenyuhuli provins Galili ali nanak ihalub walub apak Isrel apakilub. Ali nameitu douk enyudak nyanak nyatogloli agundak.” ");
INSERT INTO apeB_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Ali Pailat nemnek enyudak balan ali nasolikech nakli, “Anudak alman Jisas anan douk ananu echech Galili?” ");
INSERT INTO apeB_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Ali douk Pailat nemnek umu chakli Jisas anan douk napeli provins Galili douk Herot nape nebenalimu, ali anan nakaganu nanamu Herot. Ababuk nyultab Herot chopuk douk nanak nape Jerusalem. ");
INSERT INTO apeB_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Ali Herot douk nanubu nenehilau ababuk nyultab anan natik Jisas umu. Umu moneken, anan nemnek balan umu agundak chape chakliyanamu ali loubomu nyultab anan nape natulugun umu nakli nutulunu. Anan nakli nutulunamu nunek enen God atunu neneken uli moul. ");
INSERT INTO apeB_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Douk namudak ali Herot nasolikanu wolobainyi balan Jisas. Wakuli Jisas wak kwalowi nubemanu enen balan e, wak. ");
INSERT INTO apeB_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Ali amam nebemi pris hanu amam henek skulumech umu lo uli hanak heyotu halakati ali dodogowim atum hape henemanu dodogowin atinyi balan. ");
INSERT INTO apeB_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Ali Herot nanu ananim soldia hape henekanu enenyi enen Jisas. Amam henek tok bilasumanu ali hanak hohuli anah dudukoh lupah douk nebemi atum henekeh uli ali hanaki hohusakumanu. Ali wata hakaganu nanamu Pailat. ");
INSERT INTO apeB_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Ali likuk Herot nanu Pailat isave henenemu birua. Wakuli hanubu ahabuk nyumnah Pailat nakagas Jisas nanamu Herot ahi, amam wata hanagabemu hape atugun. ");
INSERT INTO apeB_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Ali Pailat nohwalu nebemi pris hanu amam nebemimu echech Juda uli hanu echudak wolobaichi almam almagou chanaki. ");
INSERT INTO apeB_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Ali anan naklipech nakli, “Ipak palawali anudak alman umu yek ali pakli anan nohul elpech umu chunu gavman chulpak. Ali nameitu ipak douk pape ali yek yape yasalikanamu enyudak balan. Wakuli yek douk wak igwatu enen yowenyi anan neneken uli e. Yek yatik umu enyudak ipak penek kwotumanamen uli anan douk wo nuneken e. ");
INSERT INTO apeB_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Ali Herot chopuk douk wo nugwatu enen yowenyi Jisas neneken uli e. Ali anan wata nakaganu natanamalimu apak. Ali mnek. Anudak alman douk wo nunek enen yowenyimu eke monu nugakumen uli e, wak. ");
INSERT INTO apeB_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Douk namudak ali yek eke iklipam huleyanu enech echudak meyoh ali wata ikwechihanu nunak fri.” ");
INSERT INTO apeB_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Ababuk nyultab echech douk chagipech enyudak pasin. Ihech yohleguh ahudak nyumnah hutoglomu chunek Pasovaigun woligun umu, Pailat imas nukwechih-umechi ananu nenek kalabus uli nutoglomechi nupe fri. ");
INSERT INTO apeB_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Ali chanatimaguk elpech chanalamu chohwalu chakli, “Boweyanu nugak! Ali nyukwechih-umapali Barabas!” ");
INSERT INTO apeB_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Anudak alman Barabas douk nenek kalabus napemu agundak nohul onohw wanohw Jerusalem hwatik gavman ali nabo enech elpech chagak umu. ");
INSERT INTO apeB_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Ali Pailat nakli nukwechih Jisas nunak fri ali anan wata nagabe nasalikech. ");
INSERT INTO apeB_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Wakuli echech chohwalu chakli, “Ne nyilimanu lowag kruse. Ne nyilimanu lowag kruse.” ");
INSERT INTO apeB_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Ali Pailat wata chopuk naklipech anah alagun henekeh bieh atuh umu nakli, “Anan nenek moneken yowenyimu apak monu nugakumenyi? Yek wo igwatu enen yowenyimu eke monu nugakumenyi uli e. Douk namudak ali yek eke iklipam huleyanu enech echudak meyoh ali ikwechihanu nunak.” ");
INSERT INTO apeB_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Wakuli echech chape chohwalu nebegun atugun umu chakli chunek nyilumu Jisas umu lowag kruse ali chonu nugak. Echech chohwalu aliga ali echechin balan nyabouk Pailat ananin nyabihuk. ");
INSERT INTO apeB_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Namudak ali Pailat nakli wosik umu chubo Jisas nugak kobi douk echech chaklimu. ");
INSERT INTO apeB_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Ali nokwechih-umech Barabas nanak fri. Anan douk nenek kalabus umu agundak nanu gavman chalpak, ali nabo enech elpech chagak umu. Ali douk Pailat nokwechih-umechi anabuk echech chakli-analuli nanak ali nekech Jisas umu chugimeh-umanu kobi douk echech chaklimu. ");
INSERT INTO apeB_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Douk Pailat nekech Jisas nolu echechis wis ali amam soldia halawanu hanak. Amam hanak yah ali hogwatu Saimon douk nanaki wabul Sairini uli nanakumali nuwich Jerusalem. Ali amam hahwanu howemu lowag kruse ananih eleh ali hanalakumanu nenyusah nagimu Jisas. ");
INSERT INTO apeB_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Ali wolobaichi elpech chagipech Jisas chanak. Onou almagou chopuk wanamech chanak ali owo wape wolepanu. Owo woleh wanakukli wanaluwal. ");
INSERT INTO apeB_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Ali Jisas natanamu naklipou nakli, “Ipak almagou pape Jerusalem uli, ipak kobi pulepe yek, wak. Ipak pulepu ipakich batowich chunu ipak yet. ");
INSERT INTO apeB_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Umu moneken, nyultab eke butoglu ali ababuk nyultab elpech eke chukli, ‘Kupihewali almagou wanu owobuk douk wata wulu enech batowich uli e wanu owobuk douk wo wusuh enech batowich wukech nyumeb uli e owo wanatimaguk douk awonehilau.’ ");
INSERT INTO apeB_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Ali banubu ababuk nyultab, elpech eke chuklipu mauntenab chukli, ‘Kitak putugwalekehi putu pultowopali.’ Ali eke chuklipu nusug chukli, ‘Putugwalekehi pubihi pultowopu umu pubechukapu.’ ");
INSERT INTO apeB_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Yek douk wak inek enen yowenyi e, wakuli nameitu echech chakli chubo yek douk yape kobi naminyi lowag ulimu. Ali ipak douk pape kobi alinyi lowag ulimu agundak penek yowenyimu eke chugimehumepu malmu malmu? Echech eke chunekumepu yowenyi ali chunubu chijahepu.” ");
INSERT INTO apeB_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Ali amam soldia halau Jisas nanu biam henek yowenyi uli hanak umu hom hugak. ");
INSERT INTO apeB_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Ali echech chanak chatoglu agundak douk gnape kobi elpenyim boglom umu. Ali agagun douk chohwalagun, “Elpenyim Boglom.” Ali agnabuk, amam henek nyilumu Jisas umu lowag kruse. Ali amudak biam henek yowenyi uli, ananu chenek nyilumanu neil wobul anunamu Jisas ali ananu neil wobul alganomu. ");
INSERT INTO apeB_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Ali Jisas nakli, “Aninu! Nyak kobi nyunohwen umu enyudak yowenyi echech cheneken umu yek uli ali nyukwleyenyuk. Enyudak chenekenyume uli douk wo chudukemen e.” Ali amam soldia habilak satu umu heneyais ananih luseh. ");
INSERT INTO apeB_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Ali elpech cheyotu chape chatulunu ali echech Juda echechim nebemi hape henek tok bilasumanu ali heyakasunu. Ali hakli, “Anan douk nagakamu kipaichi. Ali sapos anan douk Krais douk God natalihanu nanamali nunolau elpech ulimu, anan wata nugakamu anan yet.” ");
INSERT INTO apeB_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Ali amam soldia chopuk hanak halakati ali henek tok bilasumanu ali hakanu anabal nubutibali abal. ");
INSERT INTO apeB_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Ali haklipanu hakli, “Sapos adul nyak douk Juda echechinyu king umu, nameitu nyugakamu nyak yet.” ");
INSERT INTO apeB_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Ali amam howemu enen balan ali hakih hechopen chichah lowag kruse Jisas neil umu. Balan enyudak, “Anudak alman douk echech Juda echechinu king.” ");
INSERT INTO apeB_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Ali ananamu amudak biam yowemi almam douk heil wibulwabul uli, nenek tok bilas umu Jisas nakli, “Nyak douk Krais, douk God natalihenyu nakagenyu nyanamali nyunalau elpech uli? Namudak umu nyak lau gakomu nyak yet ali nyugakomu ohwak chopuk!” ");
INSERT INTO apeB_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Wakuli anudak ananu neil wobul uli nahanu nakli, “Apak manatimaguk douk meil otuh naduh. Apak douk chapomu eke mugak uli atupu. Ali nyak elgeinyamu God waka wak? ");
INSERT INTO apeB_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Ohwak douk wosik chahu wanonuluh yowenyi ohwak woneken uli. Wakuli anudak alman wak nunek enen yowenyi e, wak.” ");
INSERT INTO apeB_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Ali anan naklipu Jisas nakli, “Jisas, nyak ulkum mulome ababuk nyultab nyak nyupe nebenyalimu nyakich elpech umu.” ");
INSERT INTO apeB_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Ali Jisas naklipanu nakli, “Aduligu yek yaklipenyu. Doumeih nyak eke nyune wupe dudukabul wabul heven.” ");
INSERT INTO apeB_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Douk aun nakihi aliga 12-kilok wah wo hutau e ali wab babihi. Ali blanatimaguk echech Juda echechilub walub blanubu yomotokweh tugtuguk. Agagun yomotokweh-igun gnape namobuk aliga wabigun 3-kilok ali wah wata hatau ali hwalalagun. ");
INSERT INTO apeB_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Ali lupah douk chahaul numun God ananitu nebetali wilpat uli tukalah umu bieh. ");
INSERT INTO apeB_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Douk enyudak nyanakuk ali Jisas nohwalu nebegun nakli, “Aninu. Yek yekenyu yekin michin nyalu nyakis wis.” Douk nakliyuk namudak ali anan nanubu nagak. ");
INSERT INTO apeB_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Ali anudak nebenali soldia douk nenek bosumu 100-poleim soldia uli natik namudak ali natuk God ananin yeul nyakih. Ali nakli, “Aduligu. Anudak alman douk yopunali.” ");
INSERT INTO apeB_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Ali chanatimaguk elpech douk chanakimu chutik enyudak uli chatik namudak ali echechiluh apaluh hlanubu yoweluh umu chabo Jisas nagak umu. Ali echech chadiyaluhuk otuh ati ali chanamu echechilub walub. ");
INSERT INTO apeB_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Ali wolobaichi Jisas ananichumu chanu onou almagou douk wagipechi Jisas gani provins Galili wanaki uli, cheyotu kwalowi lougun ali chape chatik enyudak douk chape cheneken umu Jisas uli. ");
INSERT INTO apeB_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Ali ananu alman douk chohwalanamu Josep uli nape. Anan douk yopunali duldulinali alman. Anan douk nanaki echech Juda echechibul wabul chohwalobul umu Arimatia uli. Ali anan douk ananu kansol douk natanuh echech Juda echechim nebemi uli. ");
INSERT INTO apeB_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Ali enyudak balan amudak nebemi heyagwlehen umu hakli hubo Jisas nugak umu, anan douk wo nunom nuhwen e. Anan nakli wak. Ali anan isave nape nobeyogunmu abudak nyultab douk eke God nupe nebenalimu ananich elpech umu. ");
INSERT INTO apeB_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Ali anudak alman Josep nanak Pailat napemu ali nasolikanamu nunak nuble Jisas nunak nunugomanu. ");
INSERT INTO apeB_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Ali douk Pailat nakli wosik ali anan nanak noble Jisas nabihi atap ali nechlehanu anah yopuhi chogalihwihi lupah. Ali nanahul nanak nawich onohw hulupihw douk chalagun chenekech onok bulbuduk uli ali nawich nanabukuk agnabuk. Ohwudak hulupihw douk wata chunugamu enen nyagak uli elpen e, wak. ");
INSERT INTO apeB_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Ali ahabuk nyumnah echech douk chape chenek redimu echudak umu wehluwih ahudak nyumnah Sabat hutoglu ali echech moul eke wak chupe meyoh. ");
INSERT INTO apeB_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Ali almagou douk wanu Jisas chapeli Galili chanaki uli wagipech Josep wanak ali watikuk ohwudak hulupihw anan nanak nobukuk Jisas umu. Ali chopuk watik agundak Jisas ananim boglom uli ayas chakus umu. ");
INSERT INTO apeB_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Ali owo watanamu wanamu wabul wanak wonek redimu ananu marasin nanu yopuli wel leih kalbaluli. Owo wonek redimal umu wakli wunak wulayok Jisas ananihw yegenyihw. Douk wonek redimu echudak umu julug ali ahudak nyumnah Sabat hatoglu. Ali owo wonek malolo kobi douk God ananin lo nyaklimu. ");
INSERT INTO apeB_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Ali susubeih nyumnah umu wik, wata gugamu gugluk e, oudak almagou wasuh aludak wel leih kalbaluli douk nubuwakihih wonek redimal uli wanamu ohwudak hulupihw douk Josep nanugomu Jisas umu. ");
INSERT INTO apeB_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Douk owo wanak watoglu ali watik umu amudak utam douk chagah hulupihw Jisas nakus umu douk amatihanu manak makusuk algas. ");
INSERT INTO apeB_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Douk namudak ali owo wanak wawich. Douk wawich wakuli owo wo wutik Diginali Jisas nukus numun e, wak. ");
INSERT INTO apeB_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Ali owo weyotu namobuk wape wonek tinytin. Ali ahudak atuh biam almam heneki hanubu hahiyatik uli luseh uli hanaki heyotu agnabuk owo weyotumu. ");
INSERT INTO apeB_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Ali owo watik namudak ali owo wanubu elgeiyu ali woulemu watik atap. Ali amudak biam almam hasalikou hakli, “Ipak panaki patimu anudak douk wata naitak nape uli agundak chanugomu chagak ulimu moneken? ");
INSERT INTO apeB_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Agundak wak ananu nukus e. Anan douk anaitak nape. Ipak punek tin umu enyudak balan douk nubuwakih wata nape Galili ali naklipe-pamaguk. ");
INSERT INTO apeB_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Balan douk enyudak, ‘yek Anudak Alman douk yatoglu aduligeinyi elpen uli eke chugilapu henek yowenyi uli almam huhwe hunek nyilume lowag kruse ali igak. Ali huklimu bieh atuh nyumneh umu, yek eke wata itaki ipe.’” ");
INSERT INTO apeB_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Douk amam haklipou namudak ali owo wata ulkwip polomaguk enyudak balan nubuwakih Jisas naklipechuk umu. ");
INSERT INTO apeB_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Ali owo watukemaguk matmat hulupihw hwapemu ali wanak waklipu ananim 11-poleim disaipel hanu chanatimaguk chapeik ulimu enyudak nyanatimaguk owo watulin uli. ");
INSERT INTO apeB_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Ali almagou douk wanak waklipu amam aposel umu enyudak owo watulin uli douk oudak. Maria, douk kwanaki wabul Makdala uli kwanu Joana uli Jems ananik mamakik douk chopuk kwonohwalomu Maria uli. Oudak biou otuk wanu onou almagou alagun. ");
INSERT INTO apeB_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Wakuli amam aposel hemnek ali hakli enyudak owo waklipam enyi balan douk meyoluhin chagakali cheyagwlehen uli. Amam wo hunek bilipumou e. ");
INSERT INTO apeB_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Wakuli Pita naitak nasahul nanamu matmat agundak hulupihw hwapemu. Anan nanak natoglu ali nogolpomu natiku numun ali natiku ehudak chogalihwihi luseh atih hakusuk. Ali anan wata natanamu nanamu wilpat ali nape nenek tinytin nanak umu enyudak nyatogloluli. ");
INSERT INTO apeB_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Ali ahabuk atuh nyumnah, biam hanamu anabul wabul yeulibulmu Emeas. Lougun umu agundak chupe Jerusalem chunamu Emeas umu douk halakatimu 11 kilomita. ");
INSERT INTO apeB_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Douk amam hanak ali hape heneyagwleh hanak umu enyudak nyanatimaguk douk nyatogloluli. ");
INSERT INTO apeB_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Amam heneyagwleh ali chopuk henek tinytin hape hanosolik-agasumu hanak. Ali Jisas anan yet nanaki halakati ali nanamom hanak atuh. ");
INSERT INTO apeB_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Ali amam hatulunu wakuli amam wo hudukemanu hukli anan douk Jisas e, wak. ");
INSERT INTO apeB_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Ali anan nasolikam nakli, “Ipak pape panak ali pape peyagwleh umu moneken?” Douk anan nasolikam namudak ali amam hanubu heyotu. Ali amamiluh apaluh hlanubu yoweluh ali amamigas yamagas sanubu sotuhiyahi. ");
INSERT INTO apeB_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Ali ananu chohwalanamu Kliopas uli nasolikanu nakli, “Wolobaichi kipailubi walubich douk nameitu chanaki chape Jerusalem uli chadukemen enyudak douk nubuwakihih nyumnah nyatoglu Jerusalem uli. Ati douk eke nyanubu nyak atinyu nyape Jerusalem uli wak nyudukemu enyudak douk nubuwakih nyatogloluli e?” ");
INSERT INTO apeB_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Ali Jisas nasolikanu nakli, “Moneken nyatoglu.” Ali amam haklipanu hakli, “Enyudak cheneken umu Jisas douk nanaki wabul Nasaret uli. Anudak Jisas anan douk ananu profet. Ali chanatimaguk elpech chanu God chatulunamu, anan douk nanubu dodogowinu atunali alman. Anan isave nenek God atunu neneken uli moul. Ali anan dodogowinu atunu naklipech yopinyi atin balan. ");
INSERT INTO apeB_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Ali apakim nebemi pris hanu amudak anam apakim nebemimu apakin kansol uli hokechanu nolu gavman echechis wis ali amam nebemimu gavman uli habo balan umu honu nugak. Ali anan douk ahenek nyilumanu lowag kruse ali hanu nagak. ");
INSERT INTO apeB_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Wakuli apak douk amonek bilip makli alman douk God natalihanu nakaganu nanamali nukwechih apak Isrel umu mupe fri uli douk eke anan. Ali balan douk wak enyudak atin e, wak. Enyudak douk nyatoglu nubuwakihih nyumnah. Ali doumeih douk henek bieh atuh umu. ");
INSERT INTO apeB_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","23","Ali dukwechuk onou almagou douk wanapu masuh ananin balan magipechen uli wonekapu loguh hwonechluk-apamu agundak aglupil atul wanamu matmat hulupihw hwapemu wakuli wak wutulunu nukus numun hulupihw umu e. Ali owo wata watanamali ali waklipapu wakli owo wanubu watik enech enselahas ali chaklipowali chakli Jisas anaitak nape. ");
INSERT INTO apeB_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Ali anam apakim almam haitak hanamu matmat hulupihw hwapemu ali hatik umu oudak almagou waklienyi balan douk adulin. Ali namudak ati, amam chopuk wak hutulunu nukus e, wak.” ");
INSERT INTO apeB_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Ali Jisas naklipam nakli, “Ipak ati tinytin wak enen nyupenyipu e. Ipak balagas sechuk ali ipakip ulkwip wak wisnabul pulomu enyudak nyanatimaguk balan douk seiwak amam profet haklienyuk uli ali punek bilipumen pukli adulin e. ");
INSERT INTO apeB_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Ipak eke padukemech waka wak? Krais douk God natalihanu nakaganu nanamali nunolau elpech uli imas chonu nulau nebehi nyih nugak iyuh ali God adakio nunubu nutuk ananin yeul nyukih.” ");
INSERT INTO apeB_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Ali Jisas nenek stat Moses nenyemaguk nyetemu God ananik buk uli balan nape naklipam aliga neyaten ali naklipam umu hanatimaguk profet henyemaguk uli. Anan nape nawalmom bawogos umu hudukemech umu enyudak nyanatimaguk balan nyetemu God ananik buk uli douk nyaklimu anan yet. ");
INSERT INTO apeB_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Ali douk naklipam nanak ali halakatimu hunak hutoglu abuldak wabul douk amam hakli hunakabuli, ali anan loh nanubu nagimu yah nanak. ");
INSERT INTO apeB_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Wakuli amam hanalak hapemanamu nunom hupe ali haklipanu hakli, “Nyak yowi nyunohu mupe agundak. Aun douk ahalakatimu nubihuk ali ahalakatimu wab.” Ali anan nanak nawich nanam hape. ");
INSERT INTO apeB_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Douk hape ali amam hapemu hakli huwak woligun ali anan naitak nanam hape halihi-halih tebol. Ali nohul bret nenek beten nenek tenkyumu God ali nagwudukatu nakam. ");
INSERT INTO apeB_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Ali banubu ababuk nyultab amam hatulunu ali wata hadukemanu. Wakuli anan bulkwolonu ali amam wata hutulunu e. ");
INSERT INTO apeB_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Ali amam hanaklipamu hakli, “Dukwechuk magimu yah manakumali anan douk naklipohwali balan nyetemu God ananik buk uli. Ali anan douk nanubu nawolmohu bawogenyumu balan. Ali ababuk nyultab ohwakich michich douk chanubu chanobilakuk anagun sik ali ohwak wonehilau.” ");
INSERT INTO apeB_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Douk amam heneyagwleh namudak umu julug ali banubu ababuk nyultab amam wata haitak hatanamu hanamu Jerusalem. Amam hanak hatoglu ali hogwatu amudak 11-poleim disaipel hanu echudak enech chagipech Jisas uli chowachabal chape. ");
INSERT INTO apeB_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Ali echech chaklipam chakli, “Aduligu atugu. Diginali wata naitak. Anan douk natoglomu Saimon ali natulunu.” ");
INSERT INTO apeB_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Ali amam biam chopuk, heneyogomech umu enyudak nyatoglomom yah uli nyanu agundak anan nagwuduk bret nokom ali amam adakio hohulanu yomagu hadukemanamu. ");
INSERT INTO apeB_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Ali douk amam wata hape haklipech enyudak balan ati ali ahudak atuh Diginali anan yet nanakwalmu neyotu agundak echech chapemu. Ali naklipech nakli, “Yek yakli God nunekepu ipakiluh apaluh hlulu kalbu.” ");
INSERT INTO apeB_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Wakuli echech loguh hwonechlukech ali chanubu elgeich. Umu moneken, echech chenek tin chakli ati echech eke chatik enen sagabu. ");
INSERT INTO apeB_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Wakuli anan nasolikech nakli, “Ipak elgeipu ali loguh hwonechluk-epamu moneken? Ali ipak pasuh bien tinytin umu moneken? ");
INSERT INTO apeB_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Tiki yekigas ayas uli loguh. Enyudak douk yek yet Jisas. Ipak punaki pususuhwe ipakis wis ali pichakome ali ipak eke pudukemech. Sagabehas biguh uli yebug wak enech chupenyich e. Wakuli yek douk patiwe yebug uli biguh chape.” ");
INSERT INTO apeB_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Douk anan nakli enyudak ali nagilapech ananis wis uli ayas. ");
INSERT INTO apeB_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Ali echech chatulunu ali chanubu chenehilau wakuli chopuk, echech loguh hwonechlukech. Wakuli echech wo chunubu chunek bilip chukli anan douk nanubu Jisas e, wak. Douk namudak ali anan nasolikech nakli, “Ipak pobuk enech kakwich agundak waka wak?” ");
INSERT INTO apeB_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Ali echech chohuli anap woblap hanup uli yelbup chakanu. ");
INSERT INTO apeB_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Ali anan natulichop ali napah echechis nabes. ");
INSERT INTO apeB_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Ali anan naklipech nakli, “Likuk yek wata yanepu mape ali yaklipepaguk yakli, nyanatimaguk balan douk henyemu God ananik buk nyaklimu yek uli imas nyutoglu adulin atin. Enyudak balan enen douk nyape Moses nenyemaguk uli God ananin lo. Ali enen nyape amam profet henyemaguk uli, ali enen nyape buk chohwalok umu Sam uli.” ");
INSERT INTO apeB_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Ali anan nagakamech nohul echechin tinytin umu hudukemen kalbu bawogenyumu balan nyetemu God ananik buk uli. ");
INSERT INTO apeB_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Ali naklipech, nakli, “Balan nyetemu God ananik buk uli douk nyakli Krais douk God natalihanu nakaganu nanamali nunolau elpech uli imas numnek nebehi nyih ali chonu nugak. Ali douk huklimu bieh atuh nyumneh umu, anan eke wata nitak nupe. ");
INSERT INTO apeB_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Ali umu Jisas ananin yeul, echech eke chunek stat Jerusalem chupe chuklipech yopinyi balan ihech elpech aliga chunak chiyatak ihab lainab elpech chape apudak atap uli. Echech eke chuklipech umu Jisas ananin yeul umu chukenyuk agabus yowenyi ali chutanamu chukanu apaluh God ali anan eke kobi nunohwen umu echechin yowenyi ali nukwleyenyuk. ");
INSERT INTO apeB_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Ali ipak eke puklipech balan umu echudak douk patulich chatogloluli. ");
INSERT INTO apeB_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Ali ipak mnek. Enyudak douk seiwak yekinu Aninu nakli adulin atin balan umu eke nukepeyen uli douk enyudak eke nameitu ikogen nyubihi nyuwichepu. Wakuli ipak pupe agundak Jerusalem aliga pulau enyudak strong nyanaki iluh heven uli nyubihi nyuwichepu dodogowipu iyuh.” ");
INSERT INTO apeB_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Ali anan nalawech chatukemaguk Jerusalem chanak aliga chatoglu wabul Betani. Douk chanak chatoglu ali anan nohul loguh naklipech yopinyi balan umu God nunekumech yopinyi. ");
INSERT INTO apeB_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Ali douk anan wata nape naklipech ati ali God wata nalawanu natukemechuk naltomu iluh heven. ");
INSERT INTO apeB_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Ali echech cheyotu chenek lotumanu agnabuk umu julug ali wata chatanamu chanamu Jerusalem. Ali echech chanubu chenehilau chalikuk. ");
INSERT INTO apeB_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Ali chapemu chatuk God ananin yeul nyakih namudak ati gani numun banis God ananitu nebetali wilpat tatawomu.");
INSERT INTO apeB_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Seiwak God watak nunek apudak atap e ali anudak Alman chohwalanamu Balan uli douk anape. Nanu God hape. Ali Anan douk nanubu God. ");
INSERT INTO apeB_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Seiwak wata bawogos umu Anan nanu God hape. ");
INSERT INTO apeB_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","God wo nunek enen enyudak anan atunu e, wak meyoh. God nakwu anudak alman Balan nenek ihechumali enechi enech echudak. ");
INSERT INTO apeB_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Anan douk nanubu bawogos umu agundak elpech chunubu chupe ali kobi wata chugak umu. Chopuk anan douk kobi anatu taglak uli lait umu tuglak ali elpech chunatulugun umu. ");
INSERT INTO apeB_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Atudak lait douk isave taglak agundak yomotokweh umu. Ali yomotokweh eke hubilak kobi hubuwehatu, wak. ");
INSERT INTO apeB_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","God nakagasi ananu nalawali ananin balan uli alman nanaki. Ananin yeul douk Jon. ");
INSERT INTO apeB_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Anan douk nanamali nuklipu elpech umu atudak lait. Umu chunatimaguk chumnek naklipech enyi balan ali chusuh anudak alman nape kobi laitumali ananin balan dadag chugipechen. ");
INSERT INTO apeB_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Anan Jon douk wo atudak lait e, wak. Wakuli Jon douk nanamali nuklipech balan umu anudak alman nape kobi laitumali. ");
INSERT INTO apeB_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Anudak alman douk nape kobi tanubu taglak uli laitumali douk nanamali atap umu nugakamu ihech elpech chudukemu God. ");
INSERT INTO apeB_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Seiwak God nakwu anudak alman Balan nenek apudak atap ali douk nanaki napenyup. Wakuli apudak atapichi elpech douk wo chutulunu ali chudukemanamu agundak anan douk nanubu monakanu alman umu e, wak. ");
INSERT INTO apeB_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Nanubu nanamali ananibul wabul, wakuli ananichi douk chokanaguk agabus chakli wakanu. ");
INSERT INTO apeB_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Wakuli enech douk chemnekanu ali chasuh ananin balan dadag chagipechen. Namudak ali echech douk nekech namba umu chutoglu God ananich batowich. ");
INSERT INTO apeB_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Wak chutoglu God ananich batowich meyoh umu mamechichig butog o echechin laik meyoh o enech chuklipech ali dakio chutoglu God ananich batowich e, wak meyoh. God anan yet nanaglahech ali chatoglu ananich batowich. ");
INSERT INTO apeB_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Anudak alman chohwalanamu Balan uli douk nalau elpenyihw yegenyihw ali nanaki nanapu mape. Apak douk amatik umu agundak anan nanubu dodogowinu atunu ali yeul nyakihanamu. God anan douk atunu nuganinu meyoh ali douk nagakomonu dodogowinu yeul nyakihanu ali nakaganu nanaki. Enyudak pasin umu chenelek elpech chagakomech meyoh umu nyanu cheyagwleh adulin atin balan umu douk nyanubu nyape anan. ");
INSERT INTO apeB_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Ali Jon douk naklipech umu anudak alman. Naklipech namudak. Nakli, “Alman likuk yaklipepu-manu uli douk anudak. Douk yaklipepu namudak. Yakli, ‘Anudak alman nugimali yek uli douk nanubu nebenali. Yek chokuweli meyoh. Umu moneken, yek wata chiyalali e ali anan douk aseiwak nape.’” ");
INSERT INTO apeB_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Anan douk nanubu yopuyopunali duldulinu alman ali nanubu nagakamapu meyoh. Ali wihluwehlu douk napemu nenekumapu yopinyi apak manatimaguk. ");
INSERT INTO apeB_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Seiwak God douk nakanali lo Moses nanaki naklipechen. Wakuli God nakagas Jisas Krais nanaki nagakamapu meyoh ali naklipapu adulin atinyi balan. ");
INSERT INTO apeB_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Wak kwalowi enen elpen nyutik God e, wak meyoh. Wakuli anudak ananinu Nuganinu douk nanubu nape huluk umu Aninu God uli, anan atunu natik God. Natulunu ali douk naklipapumanu. Namudak ali apak dakio madukemanu. ");
INSERT INTO apeB_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Echech Juda echechim nebemi hakagas anam pris hanu anam apudak awilop Livai hatukemaguk Jerusalem ali hanak hatik Jon. Hanak ali hasolikanu hakli, “Nyak meinyali?” ");
INSERT INTO apeB_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Jon nemnek ali wo nuklimu nubechukumom balan ali kobi nuklipam e, wak. Nanubu nowoleh-enyumom. Naklipam enyi balan douk enyudak. Nakli, “Yek wo Krais e, anudak douk God naklimu eke nutalihanu ali nukaganu nunamali nunolau elpech uli e, wak.” ");
INSERT INTO apeB_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Ali hasolikanu hakli, “Namudak ali nyak douk meinyali? Nyak Ilaija, waka?” Ali naklipam nakli, “Wak, yek douk wo Ilaija e.” Ali wata hasalikanu hakli, “Nyak douk ati anudak profet douk mape matimanamu eke nutogloluli, waka?” Ali nebemom balan nakli, “Wak.” ");
INSERT INTO apeB_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Namudak ali hasolikanu hakli, “Namudak ali klipapu. Nyak douk meinyali? Umu apak wata musuh enen balan mutanamu muklipu amudak nebemi douk hakagapu manamali musolikenyu uli. Klipapu, nyak nyakli nyak douk nyanubu meinyali alman?” ");
INSERT INTO apeB_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Ali Jon naklipam nakli, “Yek anudak alman douk seiwak profet Aisaia nenyemaguk uli balan nyakliyanali. Balan Enyudak. ‘Enen elpen nyape nyohwalu gani wohigunmu elpech wak umu ali nyakli, “Gapech yah hupe duldul umu Diginali nugimoh nunakimu.” ’” ");
INSERT INTO apeB_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Amudak almam douk hanaki hasolik Jon enyudak balan uli douk amam Farisi hakagam hanaki hasolikanu. ");
INSERT INTO apeB_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Ali hasolikanu hakli, “Nyak douk nyakli nyak wak Krais e o Ilaija o anudak nebenali profet e, wak. Namudak ali omuni nyaklipenyu ali dakio nyenek baptaisumu elpech?” ");
INSERT INTO apeB_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Ali Jon wata naklipam nakli, “Yek yenek baptaisumech abal meyoh. Ali agundak nameitu ananu alman douk nanepu peyotu. Ipak douk wo pudukemanu e, wak. ");
INSERT INTO apeB_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Anan douk nagimali yek uli. Ali yek douk wo yopuwelimu ikwechihumanu nadululuh ananinyu su e, wak.” ");
INSERT INTO apeB_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Jon douk neyagwleh enyudak balan wabul Betani. Ababul douk blape gani woblahahibamu wolub Jodan douk anan nape nenek baptaisumech umu. ");
INSERT INTO apeB_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Wehluwih ali Jon natik Jisas nanakimu nutulunu. Ali Jon naklipech nakli, “Tik anudak alman. Anan douk kobi God ananin nugan sipsip umu. Anan douk nanamali nutal yowenyi manatimaguk mape apudak atap uli moneken ali God eke kobi nunohwen nupe, wak. ");
INSERT INTO apeB_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Alman anudak douk yaklipepumanu uli. Douk yaklipepumanu yakli, ‘Ananu nagimali yek uli alman douk nanubu nebenali. Yek wak chokuweli meyoh. Umu moneken, yek douk watak chiyalali e ali anan douk seiwak nalik nape. ");
INSERT INTO apeB_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Yek yet douk wo idukemech umu anan nanubu meinali alman umu e, wak. Wakuli yek douk yanaki yenek baptaisumech umu inouh nutoglu yopugunmu ali ipak Isrel putulunu pudukemanu.’” ");
INSERT INTO apeB_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Ali Jon naklipech enyudak balan umu chudukemu Jisas umu. Naklipech nakli, “Yek yatik God ananin Michin nyagluki iluh heven kobi enyudak almin manyun umu nyabihi nyape Jisas. ");
INSERT INTO apeB_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Yek yet douk wo idukemech umu alman douk God natalihanu ali nakaganu nanakili douk anan umu e, wak. Wakuli God douk nenek salimume yanamali inek baptaisumech uli naklipe nakli, ‘Eke nyutik yekin Michin nyibihi nyupe ananu alman ali nyuwichanu. Ali anabuk alman douk eke nukech yekin Michin nyuwich wolobaichi elpech ali nyupenyich.’ ");
INSERT INTO apeB_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Yek douk ayatik enyudak nyatoglu ali douk yaklipepu. Anan douk adul nanubu God ananinu Nuganinu.” ");
INSERT INTO apeB_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Wehluwih ali Jon nanu biam ananim disaipel heyotu wolub Jodan. ");
INSERT INTO apeB_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Heyotu ali Jon natik umu Jisas nanakumali nichalak nunak. Ali nakli, “Tik anudak alman. Anan douk God ananin nugan sipsip.” ");
INSERT INTO apeB_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Douk ananim biam disaipel hemnekanu nakli namudak ali hanamu Jisas hanak. ");
INSERT INTO apeB_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Jisas natanamu natulum umu hagimanu hanak ali nasolikam nakli, “Pape paulimu moneken?” Ali amam wata hasolikanu hakli, “Rabai, nyak nyape agnumu?” Muwanamu enyudak balan Rabai umu douk nyakli Nebenyali Tisa. ");
INSERT INTO apeB_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Ali naklipam nakli, “Yowi puname munak ali putik agundak yek yapemu.” Ali hanamanu hanak hatik agundak napemu. Hatulugun ali hanubu hananu hape agnabuk ahabuk nyumnah. Umu moneken agagun douk ayawabigun 4 klok uli. ");
INSERT INTO apeB_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Amudak biam douk hemnek Jon ali hagipech Jisas hanak uli, ananu douk Andru. Anan douk Saimon Pita ananinu owaninu. ");
INSERT INTO apeB_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Ali Andru nenek wisnabul nanak naulimu ananinu saninu Saimon. Nanak nogwatanu ali naklipanu nakli, “Apak amogwatanu Mesaia.” Muwanamu enyudak balan Mesaia umu douk nyakli Krais, anudak douk God natalihanu ali nakaganu nanamali nunolau elpech uli. ");
INSERT INTO apeB_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Ali Andru nalau Saimon umu Jisas. Jisas natulunu ali nakli, “Nyak Saimon. Nyak douk Jon ananinu nuganinu. Kamanami douk eke wata chuhwalenyu Sifas.” Bawogenyumu balan umu echudak yeguh Sifas uli Pita douk chakli atin. Chakli Bulbuduk. ");
INSERT INTO apeB_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Wehluwih ali Jisas nakli nunamu enyudak provins Galili. Nanak douk nogwatu Filip ali naklipanu nakli, “Yowi nyugipech yek.” ");
INSERT INTO apeB_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Filip nanu Andru uli Pita douk hanaki atubul wabul Betsaida. ");
INSERT INTO apeB_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Douk Filip nanak nogwatu Nataniel ali naklipanu nakli, “Anudak alman douk Moses nowemu balan okudak lo nyetemeyok uli buk nyanu enyudak enen amam profet henyemaguk ali hakliyuk umu eke nunakili douk amogwatanu. Anan douk Josep ananinu nuganinu chohwalanamu Jisas uli. Anan douk nanaki wabul Nasaret.” ");
INSERT INTO apeB_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Ali Nataniel nasolik Filip nakli, “Nyak nyakli deke wosik enech yopichi echudak chutoglu abuldak wabul Nasaret? Ati wak.” Ali Filip naklipanu nakli, “Orait, yowi wunak ali eke nyutulunu.” ");
INSERT INTO apeB_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Douk Jisas natik Nataniel nanakimu nutulunu ali neyagwleh-umanu enyudak balan. Nakli, “Anudak alman nape Isrel uli, anan douk ananu yopunali alman. Lohwotuhwin balan douk wo niyagwlehen ati e, wak.” ");
INSERT INTO apeB_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Ali Nataniel nasolik Jisas nakli, “Nyak nyadukeme malmu?” Ali Jisas naklipanu nakli, “Filip watak nunaku nuhwalenyu e, ali yek douk ayatulinyu nyape chukamenyumu lowag fik.” ");
INSERT INTO apeB_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Ali Nataniel nakli, “Nebenyali Tisa, nyak douk God ananinyu Nuganinu. Nyanubu apak Isrel apakinyu King.” ");
INSERT INTO apeB_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Ali Jisas wata naklipu Nataniel nakli, “Ati nyak nyenek bilip umu yek umu douk eke nyenek bilip umu agundak yaklipenyamu yatulinyu nyape chukamenyumu lowag umu, waka? Yaklipenyu, kamanami eke nyutik enenyi enen God atunu neneken uli moul. Eke ineken nyichalakuk enyudak uli.” ");
INSERT INTO apeB_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Ali Jisas wata naklipam nakli, “Aduligu atugu yaklipepu. Kamanami ipak eke putik utagu tukalagu gunak giyotuk tiki tokon ali eke putik iluh heven. Eke putik God ananich ensel chunek luto bih chunamali yek Anudak Alman douk yatoglu aduligeinyi elpen uli.” ");
INSERT INTO apeB_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Bieh nyumneh hanak hadiyuk ali hakli bieh atuh umu, biech elpech chanasupu abuldak wabul Kana. Abuldak wabul Kana douk blape enyudak provins Galili. Ali Jisas ananik mamakik douk kwanak kwatulich. ");
INSERT INTO apeB_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Jisas nanu ananipu disaipel douk chopuk chohwalopu ali manak matulich umu agundak echudak biech elpech chanasupamu. ");
INSERT INTO apeB_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Douk aliga chawak wainibal abal cheyatabal ali Jisas ananik mamakik kwaklipu Jisas kwakli, “Wainibal abal douk chabalah cheyatabal.” ");
INSERT INTO apeB_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Ali Jisas naklipok nakli, “Nya, kobi nyuklipemu inek enech echudak, wak. Yekibu nyultab umu inek enyudakmali moul umu douk watak bunaki e, watak.” ");
INSERT INTO apeB_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Ali ananik mamakik kwaklipu echudak douk chenek moulomu woligun uli kwakli, “Anan nuklipepamu punek moneken umu, ipak imas puneken.” ");
INSERT INTO apeB_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Atabuk wilpat douk chobuk 6-poleis nebesi utabalis malus sakus. Chosubuk sakus umu abal blulu ali echech Juda chugipech enen echechin pasin ali chune chaulik umu. Asudak malus atup ati douk deke wolobaibali abal 100 lita bluleyos. ");
INSERT INTO apeB_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Ali Jisas naklipu echudak douk chenek moul uli nakli, “Pichalu abal asudak malus.” Naklipech ali chenyukwlabal blagluk aliga sanubu chichuknis ati. ");
INSERT INTO apeB_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Ali naklipech nakli, “Aliga pulu anabal pulawabal umu nebenalimu agundak woligun uli.” Namudak ali chagi anabal chalawobal-umanu. ");
INSERT INTO apeB_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Chalawobal ali nechakamabal, abaludak abal douk Jisas nenekabal blatoglu wainibal uli. Ali anan douk wo nudukemech e umu abaludak wainibal abal blanaki meigunimu e, wak. Wakuli echudak douk chenek moul ali cholu anabal chanak chokanaluli douk chadukemech. Namudak ali nebenalimu agundak woligun uli nohwalu anudak nasuh okwok uli nanaki. ");
INSERT INTO apeB_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Nanaki ali naklipanu nakli, “Iham almam douk isave hagimoh namudak. Susubati eke hulik hulawali nanubu yopunali wain chunowoh nulik ati. Chuwak yopunali aligas umu chumnek ali anudak ananu douk wo nunubu yopunu uli e eke adakio hunahuli chunowoh nugikuk. Wakuli nyak nyobukuk nanubu yopunali wain nakusuk aliga nameitu adakio nyanahuli.” ");
INSERT INTO apeB_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Ali enyudak douk nyanubu susubein dodogowinyi moul mirakel douk Jisas neneken uli. Neneken abuldak wabul Kana douk blape enyudak provins Galili uli. Neneken ali nagilapech umu agundak anan douk nanubu dodogowinu atunamu. Ali ananipu disaipel matulin monek bilip makli anan douk God ananinu Nuganinu. ");
INSERT INTO apeB_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Douk chenek enyudak umu julug ali Jisas naglumu Kapaneam. Nanu ananik mamakik kwanu ananim owahlim uli apak ananipu disaipel. Mabih ali mape agnabuk eneh nyumneh. ");
INSERT INTO apeB_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Nyultab ahalakatimu butoglu umu echech Juda eke chunek agundak nebeguni woligun Pasova umu. Ali Jisas naltomu Jerusalem. ");
INSERT INTO apeB_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Nalto ali nanak nawich banis atudak God ananitu nebetali wilpat tatawamu. Nawich ali nogwatu almam hape henek bisnis henek salim umu kauhas chanu sipsip uli almiguh douk hwape kobi machubiguh-umali. Ali chopuk natik almam hape halihihalih tebolahas hape henek senis umu mani. ");
INSERT INTO apeB_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Natik namudak ali nohul analuh nadululuh nelehaluh hlatoglu kobi anagas metegas umu ali nakwu agasudak metegas nape nahiyah hanatimaguk almam hanu sipsip uli kauhas chatogloguk aduk umu agundak God ananitu wilpat tatawomu. Nablanumom tebolahas amudak henek senis umu manili ali nasitusatamom mani nyanakuk atin atiyuk. ");
INSERT INTO apeB_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Ali nanalak umu amudak henek salim umu almiguh uli umu hutogloguk aduk. Nakli, “Laweyoguh toglomoguk agundak. Kobi punek yekinu Anineitu wilpat tutoglu kobi enen stua umu, wak.” ");
INSERT INTO apeB_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Ali ananipu disaipel wata ulkwip polomu enen balan nyetemu God ananik buk uli. Balan douk nyakli namudak. “Yek ulkum manubu molomu nyakitu wilpat ali yanubu yenek nebenyi moul yagapechatu tape kalbu.” ");
INSERT INTO apeB_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Echech Juda echechim nebemi hatik enyudak ali haklipanu hakli, “Nyak nyunubu nyunek enen God atunu neneken uli moul nyutoglu. Nyuneken umu apak mutulin ali mudukemech mukli nyak douk adul God nekenyu namba ali dakio nyanaki nyenek enyudak agundak numun ananitu wilpat.” ");
INSERT INTO apeB_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Jisas nemnek ali wata naklipam nakli, “Ipak pichicheh atudak God ananitu nebetali wilpat ali yek eke wata itahul ilatu iyatatu umu bieh atuh nyumneh meyoh.” ");
INSERT INTO apeB_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Namudak ali amam wata hasolikanu hakli, “Douk nyakli deke wata nyutahul nyulatu nyiyatatu bieh atuh nyumneh meyoh? Atudak wilpat douk chalatu wolobaichi 46-poleich yohwleguh ali adakio chalatu cheyatatu.” ");
INSERT INTO apeB_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Wakuli Jisas naklimu chichichehatu uli wilpat douk naklien nenyemu ananihw yegenyihw. ");
INSERT INTO apeB_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Namudak ali abudak nyultab chanu nagak ali God wata nanahuli iwagu umu batoglu, ali apak ananipu disaipel adakio ulkwip polomu enyudak balan likuk anan nakliyenyuk uli. Ali adakio monek bilip makli Jisas neyagwlehen uli balan nyanu enyudak nyetemu God ananik buk uli douk adulin atin. ");
INSERT INTO apeB_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Ehudak nyumneh douk chenek agundak woligun Pasova abali, Jisas douk nape Jerusalem. Nape ali nenek wolobainyi God atunu neneken uli moul douk elpech chatulin ali wolobaichi chasuh ananin balan chagipechen. ");
INSERT INTO apeB_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Douk Jisas natulich namudak umu agundak chasuh ananin balan dadag umu ali wo nunubu nunek bilip umu echech douk chanubu chasuh ananin balan e, wak. Umu moneken, anan douk nadukemu ihech elpech echechin tinytin nyolu nyanak umu. ");
INSERT INTO apeB_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Anan douk eke kobi enen elpen nyuklipanu adakio nudukemu echechin pasin o echechin tinytin, wak. Anan douk ananubu nadukemu echechin pasin nyanu echechin tinytin. ");
INSERT INTO apeB_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Ananu alman chohwalanamu Nikodimas uli douk nape. Anan douk ananu Farisi ali ananu nebenalimu echechin kansol. ");
INSERT INTO apeB_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Anab wab, anudak alman Nikodimas nanak natik Jisas ali naklipanu nakli, “Nebenyali Tisa, apak madukemech umu nyak douk enenyu tisa, douk God naklipenyomu nyunaki nyunek skul umu apak ananin balan uli. Enyudak God atunu neneken uli moul douk nyak nyape nyeneken uli, apak deke kobi enen elpen nyuneken, wak. Sapos God nugakamu enen elpen ele, enyen douk wosik deke nyuneken.” ");
INSERT INTO apeB_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Ali Jisas wata naklipanu nakli, “Aduligu atugu yaklipenyu, sapos enen elpen kobi wata nyutoglu nupolein umu, enyen eke kobi nyuwich agundak God nape nebenalimu ananich elpech umu, wak.” ");
INSERT INTO apeB_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Ali Nikodimas wata chopuk nasolikanu nakli, “Enen jugwainyi elpen deke wata nyutoglu nupolein malmu? Ati enyen wosik deke wata nyuwich enyenyik mamakikwih apahw umu wata kwinylali anah alagun ali adakio nyutoglu nupolein, waka?” ");
INSERT INTO apeB_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Ali Jisas nebemanu balan nakli, “Aduligu atugu yaklipenyu. Sapos elpech kobi chutoglu nupoleich umu agundak chunek baptais abal ali chulau God ananin Michin nyunekech chutoglu nupoleich umu, echech eke kobi chuwich agundak God nape nebenalimu ananich elpech umu, wak. ");
INSERT INTO apeB_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Elpech douk chalali batowich ali chanubu chatoglu elpech meyoh. Wakuli elpech douk God ananin Michin nyuwich nyupenyich uli, echech douk chanubu chatoglu God ananich batowich. ");
INSERT INTO apeB_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Namudak ali nyak kobi loguh hwunechluk-enyamu agundak yaklipenyamu ihepu elpech imas putoglu nupoleipu anah alagun umu, wak. ");
INSERT INTO apeB_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Wihun nulumu, anan douk eke nulu nunak agnabuk douk anan nukli nulu nunak umu. Nulumu douk eke nyumnekanu, wakuli agundak naitakumali o nulu nunak umu, nyak douk wo nyudukemagun e, wak. Ali ihech elpech douk God ananin Michin nyunekech chatoglu nupoleichili douk namudak ati.” ");
INSERT INTO apeB_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Ali Nikodimas wata nasolik Jisas nakli, “Enyudak deke nyutoglu malmu?” ");
INSERT INTO apeB_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Ali Jisas naklipanu nakli, “Malmu namudak? Nyak douk enenyu echech Isrel echechinyu tisa, wakuli enyudak yaklipenyamu douk wo nyudukemen e? ");
INSERT INTO apeB_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Adul ati yaklipenyu. Apak douk meyagwleh umu echudak madukemech uli ali maklipepu balan umu echudak matulich uli. Wakuli ipak douk pokenyuk agabus enyudak apakin balan. ");
INSERT INTO apeB_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Yek yaklipepu balan umu echudak chatoglu apudak atap uli ali ipak douk wo punek bilip umu yekin balan e, wak. Namudak ali sapos ikli iklipepamu iluh hevenich echudak ele, ipak douk eke kobi pusuh yekin balan pukli adulin, wak. ");
INSERT INTO apeB_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Wak kwalowi enen elpen nyultomu iluh heven e, wak. Wakuli douk yek Anudak Alman douk yatoglu aduligeinyi elpen uli otuwe yatukemaguk iluh heven yagluki. ");
INSERT INTO apeB_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Seiwak Moses nahau enen lowag agundak wohigunmu douk elpech wak umu. Ali nowaul enen idul douk neneken brasinu ain uli nyataul. Ali douk eke namudak ati. Yek Anudak Alman douk yatoglu aduligeinyi elpen uli eke chutuke chiyowaul itaul enen lowag. ");
INSERT INTO apeB_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Umu chunatimaguk elpech douk chusuh yekin balan chugipechen uli, echech douk eke chupe kalbu eheh nyumneh.” ");
INSERT INTO apeB_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","God anan douk atunu Nuganinu meyoh. Wakuli anan nanubu ulkum manosuh chanatimaguk apudak atapichi elpech ali nakaganu nanakimu echech. Nanakumali echebuk chusuh ananin balan dadag uli, echech eke kobi chunak chuwichuk, wak. Wakuli eke chunubu chupe kalbu eheh nyumneh. ");
INSERT INTO apeB_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","God wo nukagasi ananinu Nuganinu nunamali apudak atap umu nunemech balan elpech kobi jas umu e, wak. Wakuli anan douk nakaganu nanamali nunolawech chutanamali chupe kalbu. ");
INSERT INTO apeB_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Echebuk douk chusuh ananin balan chugipechen uli, God eke kobi nunekumech balan ali nuklimu echech eke chulau nebehi nyih, wak. Wakuli echebuk douk wo chusuh ananin balan chugipechen uli e, God douk anenekumech balan ali eke chulau nebehi nyih. Umu moneken, echech douk wo chunek bilip umu anudak God ananinu atunu Nuganinu e, wak. ");
INSERT INTO apeB_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Bawogenyumu balan umu agundak God eke nunemech balan umu douk namudak. Alman nape kobi laitumali douk ananaki apudak atap naglak, wakuli elpech echechip ulkwip panubu panosuh enenyi enen yowenyi douk nyape kobi yomotokweh umu. Lait chakli wakatu. Umu moneken, echech douk chapemu chenek yowenyi atin uli. ");
INSERT INTO apeB_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Ihech elpech douk chapemu chenek yowenyili, echech douk chenek biruamu anudak alman douk nape kobi laitumali. Echech douk chakli wak umu echechin yowenyi nyutoglu yopugunmu ali chunatimaguk tikuk ati, chakli wak. Namudak ali echech douk elgeich umu chunamali anudak alman douk nape kobi laitumali. ");
INSERT INTO apeB_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Wakuli echebuk douk chenek aduligein atin pasin uli, echech douk chanamali anudak alman kobi laitumali. Chanakimu elpech chutik enyudak yopinyi moul douk God naklimu echech chuneken ali douk anagakomech cheneken uli. ");
INSERT INTO apeB_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Douk enyudak nyanakuk ali Jisas nanu ananim disaipel hanamu enyudak provins Judia. Hanak hape agnabuk ali hape henek baptaisumech. ");
INSERT INTO apeB_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Jon douk chopuk nape nenek baptaisumech abuldak wabul Ainon. Ababul douk blape halakatimu Salim ali wolobaibali abal blalu agnabuk. Namudak ali elpech chanaki nape nenek baptaisumech. ");
INSERT INTO apeB_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Ali ababuk nyultab, Herot douk watak nuwechik Jon nupe haus kalabus e, watak. ");
INSERT INTO apeB_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Ali anam Jon ananim umu disaipel hanu ananu alman echech Juda hape halpak balan umu agundak echech Juda chagipech echechin lo ali chechlokuh abal umu chakli God nutulich nuhwalech yopichi umu. ");
INSERT INTO apeB_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Ali amam disaipel hanamali Jon ali haklipanu hakli, “Nebenyali Tisa, anudak alman douk likuk nanu nyak pape gani woblahahibamu wolub Jordan ali douk nyaklipopo-monu uli, nameitu douk nape nenek baptaisumech. Ali chanatimaguk elpech douk chanamu anan atunu.” ");
INSERT INTO apeB_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Jon nemnek ali nebemom balan nakli, “Sapos God nape iluh heven uli nukli kobi nuken moul enen elpen umu, enyen meyoh eke kobi nyuhul enyudak moul nyuneken, wak. ");
INSERT INTO apeB_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Ipak douk apemneken enyudak balan likuk yaklien uli. Douk yakli, ‘Yek douk wo anudak alman douk God naklimu nutalihanu ali nukaganu nunamali nunolau elpech uli e, wak. Wakuli yek douk God natalihe ali nekege yaliki. Anudak alman douk eke nigiki.’ ");
INSERT INTO apeB_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Ali sapos ananu alman nusuh ananik almatok umu, okudak almatok douk akwataglu ananik. Anudak nasuh okwok uli ananinamu elpenyinu nukli nunmek umu agundak nasuh okwok uli niyagwleh abali, anan douk eke nunubu nunehilau nulikuk. Ali yek douk namudak ati kobi anudak elpenyinamu. Nameitu yek douk yemnek Jisas ananin balan ali yanubu yenehilau yalikuk. ");
INSERT INTO apeB_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Anan yeul imas nyunubu nyukihanu ali yekin imas nyunubu nyubih.” ");
INSERT INTO apeB_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Jisas douk napeli iluh heven nanakili, anan douk nanubu nebenalimu ihechumali enechi enech echudak. Apudak atapichi elpech douk chadukemu apudak atapinyi ali cheyagwlepu apudak atapichi echudak. Ali anan napeli iluh heven nanakili, douk nanubu nebenali nechalakuk ihech elpech nach chabihuk. ");
INSERT INTO apeB_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Anan douk isave naklipapamu echudak natulich uli ali naklipapu nemnekenyuk uli balan. Naklipapu, wakuli wak enech elpech chumnek ananin balan ali chuhwen chugipechen e, wak. ");
INSERT INTO apeB_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Echebuk douk chemnek ananin balan chahwen chagipechen uli, echech chakli God naklienyi balan douk adulin atin. ");
INSERT INTO apeB_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Anudak alman God nakaganu nanakili, anan douk nanaki naklipu elpech God ananin balan. Umu moneken, God nanubu nakanu ananin Michin nyawich nyapenyunu chukninu ali nyagakamanu nenek enyudak. ");
INSERT INTO apeB_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Aninu God douk nanubu ulkum manosuh ananinu Nuganinu ali anakanu ihechumali echudak ali anan nape nebenalimech. ");
INSERT INTO apeB_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Echebuk douk chumnek anudak Nuganinu ananin balan chuhwen chugipechen uli, echech eke chupe kalbu eheh nyumneh. Wakuli echebuk douk chukanaguk agabus Nuganinu kobi chugipech ananin balan uli, echech eke kobi chupe eheh nyumneh, wak. Wakuli God eke nyihihichi-namu echech ali eke chumnek nebehi nyih eheh nyumneh. ");
INSERT INTO apeB_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Aliga ali amam Farisi ahemnek umu chakli Jisas nechalakuk Jon nenek baptais umu wolobaichi elpech ali nasonukech chagipech anan. ");
INSERT INTO apeB_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Wakuli Jisas anan yet douk wo nunek baptais umu enech elpech e, wak. Ananipu disaipel atupu monek baptaisumech. ");
INSERT INTO apeB_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Douk Jisas nemnek umu amam Farisi hemnek enyudak ali wata chopuk natukemaguk Judia natanomu nanamu enyudak enen provins Galili. ");
INSERT INTO apeB_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Ali ahudak yah hanamu Galili uli douk hawich hanak enyudak enen provins Sameria. Ali anan douk nagimah nanak. ");
INSERT INTO apeB_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Nanak aliga nanak natoglu anabul wabul chohwalabulmu Saika. Ababul douk blape enyudak provins Sameria ali blapeli halakatimu abudak chokubi amnab seiwak Jekop noku ananinu nuganinu Josep umu. ");
INSERT INTO apeB_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Ali Jekop ananigu bobigu douk seiwak nunugomu chape cholu abal umu douk golu agnabuk. Hanaki ahudak louhi yah ali Jisas aulpusinu. Ababuk nyultab douk anyumnah toul ali Jisas nanak nape algasigamu agudak abal bloleyagali bobigu. ");
INSERT INTO apeB_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Nape douk onok echech Sameria kwanakumali kulu abal ali naklipok nakli, “Chuke anabal abal ibalah.” ");
INSERT INTO apeB_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Ananipu disaipel douk amanak mawich abuldak wabul Saika umu mutali anagun mugnah uli woligun. ");
INSERT INTO apeB_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Ali okudak almatok kwaklipanu kwakli, “Nyak douk enenyu Juda ali yek douk Sameria. Nyak deke kobi nyusolikemu ikenyu abal nyubalah, wak.” Okwok kwakli namudak umu moneken, echech Juda chanu echech Sameria douk wo chunechlepomu enenyi enen o chuwak woligun atuluh ati yauleluh e, wak. ");
INSERT INTO apeB_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Ali Jisas nebemok balan namudak. Nakli, “Nyak nyukli nyudukemu yopichi echudak douk God naklimu nukenyeyech meyoh ulile, nyak deke nyusolikemu ikenyu yopubali abal douk elpech chulawabal ali blunekech chupe kalbu eheh nyumneh uli.” ");
INSERT INTO apeB_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Kwomnek namudak ali kwaklipanu kwakli, “Nebenyali, nyak douk baket wakenyamu nyunalu abal umu. Ali chopuk agudak abaligu bobigu douk gani atap meyoh. Ali abaludak abal douk elpech chubalah chupe kalbu eheh nyumneh umu eke nyubalulali agnumu? ");
INSERT INTO apeB_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Apakinu yamenu Jekop nanumapaguk agudak abaligu bobigu apak. Anan nanu ananich batowich chabalahagu. Chabalulamu ananich kauhas uli sipsip chabalah. Ali nyak douk nyakli nyak nebenyali nyechalakuk Jekop, waka?” ");
INSERT INTO apeB_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Ali Jisas nebemok balan nakli, “Echebuk elpech douk chuwak agudak bobigeibal abal uli, echech eke wata abal blugahogech. ");
INSERT INTO apeB_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Wakuli meichi echebuk douk chulau abal yek ikechabal uli, echech eke kobi wata abal blugahogech chopuk, wak. Abaludak abal yek ikechabal uli, ababal eke blutoglu blukih blupe namudak echechigun numun ali eke blunekech chunubu chupe kalbu eheh nyumneh.” ");
INSERT INTO apeB_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Okudak almatok kwomnek namudak ali kwaklipanu kwakli, “Nebenyali, nyak nyuke abalabuk nyakliyabal uli abal. Nyuke umu abal kobi wata blugahoge ali ipemu inaki agundak ibalulu, wak.” ");
INSERT INTO apeB_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Ali Jisas naklipok nakli, “Kale hwalu nyakinu alaminu ali wata punaki agundak.” ");
INSERT INTO apeB_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Kwomnek ali kwaklipanu kwakli, “Yek alaminu wak ananu e.” Ali Jisas naklipok nakli, “Enyebuk douk adul wo, umu nyakli nyak alaminu wakenyamu. ");
INSERT INTO apeB_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Umu moneken, likuk nyak douk nyasuh 5-poleim almam. Ali anabuk nameitu nyananu pape uli, anan douk wak nyakinu adulinu alaminu e, wak. Nyakin balan douk nyanubu adulin.” ");
INSERT INTO apeB_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Ali okudak almatok kwaklipanu kwakli, “Nebenyali alman, yek yadukemech umu nyak douk enenyu profet, douk God nagilapenyu balan umu nyuklipu elpechen uli. ");
INSERT INTO apeB_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Apakich popech yamech echech Sameria douk chenek lotumu God anudak maunten. Wakuli ipak Juda isave pakli agundak elpech imas chunak chunek lotumu God umu douk gnape Jerusalem atugun.” ");
INSERT INTO apeB_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Ali Jisas naklipok nakli, “Nya, nyusuh yekin balan nyukli adulin. Nyultab eke butoglu, umu eke kobi punek lotumu Aninu God anudak maunten o Jerusalem umu. ");
INSERT INTO apeB_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Ipak Sameria douk wo punubu pudukemu anudak douk penek lotumanaluli e, wak. Apak Juda douk madukemanu anudak monek lotumanaluli. Umu moneken, moul douk God neneken umu nunolau elpech chutanamali chupe kalbamu douk neneken nyaitak apak Juda. ");
INSERT INTO apeB_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Nyultab eke butoglu, ali douk abudak abatoglu, umu elpech douk chunek lotumu Aninaluli eke chukli adulin atin chulau ananin Michin enyenyin strong ali chunek lotumonu. Echech eke chunek lotumonu duldul kobi anan nanubu napemu. Elpech douk Aninu natimech umu chunek lotumonu uli douk echudakmali. ");
INSERT INTO apeB_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","God anan douk yegenihw wak. Anan douk Michin atin. Namudak ali elpech chukli chunek lotumu anan uli, echech michich imas chulau God ananin Michin enyenyin strong ali chugipech adulin atinyi balan ali chunek lotumonu.” ");
INSERT INTO apeB_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Okudak almatok kwomnek ali kwaklipanu kwakli, “Yadukemech umu Mesaia eke nunaki. Anudak alman Krais douk God natalihanu ali eke nukaganu nunamali nunolau elpech uli. Abudak nyultab anan nutoglomu, anan eke nuklipapamu ihechumali enechi enech echudak mudukemech.” ");
INSERT INTO apeB_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Ali Jisas wata naklipok nakli, “Anabuk alman douk yanubu yek wo. Enyudak douk yanenyu wape weyagwleh uli.” ");
INSERT INTO apeB_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Douk nowolehumok balan wakuli apak ananipu disaipel wata manak matogloli. Ali loguh hwanubu hwonechlukapu umu agundak matulunu nanu onok almatok chape cheyagwleh balan umu. Matulunu, wakuli wak ananu nusolik okudak almatok nukli, “Nyanaki agundak umu moneken?” o nusolik Jisas nukli, “Nyanu okwobuk almatok pape peyagwleh balan umu moneken?” Wo musolikech e. ");
INSERT INTO apeB_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Ali okudak almatok kwobukuk baket douk kwakli kulu abal umu ali wata kwatanamomu wabul. Kwanak ali kwaklipu almam almagou kwakli, ");
INSERT INTO apeB_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Yowi munak putik anudak alman douk naklipemu ihechumali echudak likuk yape yenekech uli. Ati anan douk eke Krais waka meinali?” ");
INSERT INTO apeB_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Namudak ali chatukemaguk wabul chanak umu chutik Jisas. ");
INSERT INTO apeB_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Ali ababuk nyultab, apak ananipu disaipel douk mape manalak umu Jisas makli, “Nebenyali Tisa, suh enech echudak kakwich kak.” ");
INSERT INTO apeB_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Nemnek ali naklipapu nakli, “Yek yachah uli kakwich douk wo pudukemech e, wak.” ");
INSERT INTO apeB_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Namudak ali apak ananipu disaipel amape manasasalimu makli, “Ati dukwechuk eke enen elpen nyalaumanali anagun woligun nagnah, waka?” ");
INSERT INTO apeB_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Ali Jisas naklipapu nakli, “Yekich kakwich douk echudak: Igipech anudak douk nekege yanakili ananin balan ali iyatak enyudak moul douk nekeyen umu ineken uli.” ");
INSERT INTO apeB_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","“Ipak douk isave pakliyen enyudak balan: Pakli, ‘Nubatib aub chopuk butuh ali kakwich eke yopich.’ Yaklipepu, ipak pugamu putulugun. Kakwich douk achasu chape nahabigas umu chunasagunmu. ");
INSERT INTO apeB_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Alman nusagunmu chasoluli kakwich uli, anan eke nulau pe ali nulimech nichubuk atugun umu chukus kalbu eheh nyumneh. Nenek namudak umu anudak nau kakwich uli nunu anudak natimech uli eke hunubu hunehilau hulikuk. ");
INSERT INTO apeB_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Enyudak enen balan isave cheyagwlehen uli douk adulin balan. Balan Enyudak. ‘Ananu alman nau kakwich ali kipainali nasagunmech.’ ");
INSERT INTO apeB_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Yek yakagepu panak umu pusagunmu kakwich nahabigu douk likuk ipak wo punek moul umu e, wak. Kipaimi henekuk moul ali ipak puwich pusagunmu kakwich douk hawechagu uli halik henekuk nebenyi moul umu.” ");
INSERT INTO apeB_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Wolobaichi Sameria chape Saika uli douk chasuh Jisas ananin balan chagipechen. Umu moneken, echech douk chemnek okudak almatok kwakli, “Anan naklipemu ihechumali likuk yape yenekech uli echudak.” ");
INSERT INTO apeB_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Douk namudak ali echech Sameria chanaki agundak Jisas napemu ali dodogowich atich chaklipanamu nunech chupe. Namudak ali nanech nape bieh nyumneh ablabuk wabul. ");
INSERT INTO apeB_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Wolobaichi elpech chemnek ananin balan chakli adulin ali chahwen chagipechen. ");
INSERT INTO apeB_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Ali chaklipu okudak almatok chakli, “Apak douk wo mumnek nyakin balan atin ali dakio munek bilipumanu e, wak. Apak yet memnek ananin balan ali madukemech makli anan douk anudak alman douk eke nugakamu ihapu mape apudak atap uli elpech ali wata nunolawapu mutanamu mupe kalbaluli.” ");
INSERT INTO apeB_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Douk nape ablabuk wabul bieh nyumneh umu julug ali natukemabuluk nanamu provins Galili. ");
INSERT INTO apeB_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Likuk Jisas anan yet nakliyen enyudak balan nakli, “Ananu profet, ananibul wabul douk wo chumneken ati e ananin balan chukli anan nebenali e, wak.” ");
INSERT INTO apeB_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Namudak ali abudak nyultab nanak natoglu Galili abali, echech Galili chanubu chenehilau-manu umu agundak nanak umu. Umu moneken, abudak nyultab chenek agundak nebeguni woligun Pasova Jerusalem abali, echech douk chanak ali chatik ihenyumali anan neneken uli nebenyi moul mirakel. ");
INSERT INTO apeB_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Ali wata nanak natoglu abuldak wabul Kana. Ababul douk blape enyudak provins Galili. Abuldak wabul douk nubuwakih nowanamu abal meyoh blatoglu wainibal uli. Ali ababuk nyultab, ananu nenek moul umu gavman uli ananinu nuganinu douk agudak ganu nape wabul Kapaneam. ");
INSERT INTO apeB_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Douk anudak alman nemnek umu Jisas natukemaguk Judia nanamali Galili ali nanak nasolikanamu nunamanu hunamu Kapaneam ali nugapech ananinu nuganinu umu yopunu. Anan douk agudak ganu ali halakatimu nakli nugak. ");
INSERT INTO apeB_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Ali Jisas naklipanu nakli, “Sapos ipak putiwemu kobi inek enenyi enen God atunu neneken uli moul umu, ipak eke kobi punek bilipume, wak.” ");
INSERT INTO apeB_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Anudak nenek moul umu gavman uli nemnek ali naklipu Jisas nakli, “Nebenyali alman, yowi wunak wisnabul. Kedeke yekinu nuganinu nugak.” ");
INSERT INTO apeB_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Ali Jisas naklipanu nakli, “Kale. Nyakinu nuganinu eke kobi nugak, wak.” Anudak alman nasuh Jisas ananin balan nakli adulin ali nanak. ");
INSERT INTO apeB_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Nape nanak yah ali ananim henemanu moul uli hanaki hogwatanu. Ali haklipanu hakli, “Nyakinu nuganinu ayopunu. Eke kobi nugak, wak.” ");
INSERT INTO apeB_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Ali nasolikam umu banubu meibali nyultab douk ananinu nuganinu wata yopunamu. Ali haklipanu hakli, “Agudak galhwosuk nabatik wabigun 1 klok aun patolanu abali.” ");
INSERT INTO apeB_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Namudak ali aninu wata nadukemech umu, nabatik douk banubu ababuk hakliyabali nyultab Jisas naklipanu nakli, “Kale, nyakinu nuganinu eke kobi nugak, wak.” Namudak ali anan nanu chanatimaguk chape ananitu wilpat uli chasuh Jisas ananin balan chagipechen. ");
INSERT INTO apeB_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Jisas douk anatukemaguk Judia nanaki nape Galili. Ali enyudakmali God atunu neneken uli moul douk nenek enyudak ali nyatoglu bien. ");
INSERT INTO apeB_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Enyudak nyanakuk ali anah nebehi nyumnah douk echech Juda chape chenek lotu ali chenek nebeguni woligun umu hatoglu. Ali Jisas naitak nanamu Jerusalem umu nutulich umu agundak woligun. ");
INSERT INTO apeB_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Ali agnabuk Jerusalem, enen nebenyi dua chohwalen umu Sipsip Echechin Nebenyi Dua uli douk nyape asudak banis douk chenekas chalihi chalih Jerusalem uli. Ali halakatimu enyudak dua, anagu nebegali wayag galu. Enyudak ganagain balan Arameik chohwalagamu douk chakli Betesda. Ali halakatimu agudak wayag douk anatu nebetali wilpat tatau ali chalak 5-poleiluh yadogwiluh. ");
INSERT INTO apeB_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Ali wolobaichi agasudak senekechi elpech chanaki chape chechuh ahludak yadogwiluh. Enech nabes sechukechi, enech ayas senekech ali chalahe sisahw uli chanu echudak douk loguh ayas chagakech uli chanaki chape. Echech chape chobeyagun umu abal blubilak umu. ");
INSERT INTO apeB_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Umu moneken, anabu nyultab Diginali ananin ensel isave nyabih nyagluk abal ali nyenek abal hichihicho blalu. Ali douk abal blubilak julug ali meinyi agudak genekenyi elpen nyulik nyitak nyugluk agudak wayag uli, enyen douk eke wata yopin. ");
INSERT INTO apeB_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Ali agnabuk, ananu aiyas sagak nape namudak umu 38-poleich yohwleguh uli douk nape onoh yadohw douk hwotau halakatimu agudak wayag uli. ");
INSERT INTO apeB_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Douk Jisas natik anudak aiyas sagakanali nechuh ali nadukemech umu anan douk aiyas sagak nape loubomu nyultab. Ali Jisas nasolikanu nakli, “Nyak nyakli wata yopinyu, waka?” ");
INSERT INTO apeB_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Ali anan naklipanu nakli, “Nebenyali, ababuk nyultab abal blabilak abali, yek douk elpen wakemu nyiyahul nyunak nyutuwe wayag uli. Yek yet yakli inak igluk wakuli kipaichi chenek wisnabul chechalake chalik chanak chagluk.” ");
INSERT INTO apeB_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Ali Jisas naklipanu nakli, “Nyak kitak nohul nyakis alas nyunohwas ali nyunak.” ");
INSERT INTO apeB_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Ali ahudak atuh anudak alman yopunu ali naitak nohul ananis alas nahwas nanak. Ali ahudak nyumnah Jisas nagabe anudak aiyas sagakanalimu douk Sabat. ");
INSERT INTO apeB_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Douk namudak ali echech Juda echechim nebemi haklipu anudak douk Jisas nagabeyanu uli hakli, “Apakin lo seiwak God nakaguk Moses umu douk nyakli, ahudak nyumnah Sabat douk kobi munek enen moul wak, mupe meyoh. Ali nyak douk kobi nyusuh nyakis alas nyulahe, wak.” ");
INSERT INTO apeB_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Wakuli anan naklipam nakli, “Anudak neneke yopuwe uli douk naklipemu itak ihul yekis alas inohwas ali inak.” ");
INSERT INTO apeB_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Ali amam hasolikanu hakli, “Meinali alman naklipenyamu nyunohul nyakis alas nyunohwas ali nyunak?” ");
INSERT INTO apeB_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Wakuli anudak alman douk Jisas nagabeyanu yopunu uli douk wo nudukemu Jisas e, wak. Umu moneken, wolobaichi elpech chape agnabuk ali Jisas douk ananakuk. ");
INSERT INTO apeB_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Aliga douk anabu nyultab banakuk ali Jisas wata nogwatanu numun banis agundak God ananitu nebetali wilpat tatawomu ali naklipanu nakli, “Tik, nyak douk ayopinyu. Nyunak ali kobi wata nyukli nyunek enen yowenyi alagun, wak. Kedeke enen nyanubu nebenyi hevi nyutoglomenyu.” ");
INSERT INTO apeB_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Ali anudak alman nanak naklipu echech Juda echechim nebemi umu anudak nagabeyanu uli douk Jisas. ");
INSERT INTO apeB_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Douk namudak ali amam hape henekanu anagu anagu Jisas. Umu moneken, anan douk nagabe anudak alman ahudak nyumnah Sabat. ");
INSERT INTO apeB_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Wakuli Jisas naklipam nakli, “Yekinu Aninu douk nenek ananin moul nape namudak hanatimaguk nyumneh. Namudak ali yek chopuk yape yeneken namudak ati.” ");
INSERT INTO apeB_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Douk Jisas nakli namudak ali amam nebemi Juda hanubu hakli honu nugak. Umu moneken, anan douk wo nublo enyudak lo umu kobi chunek enen moul ahudak nyumnah Sabat umu atin e, wak. Anan nakli God douk nanubu ananinu Aninu. Ali douk namudak umu, anan nakli nunek anan yet nunubu nutoglu alagun atimu God. ");
INSERT INTO apeB_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Ali Jisas nebemech balan nakli, “Aduligu atugu yaklipepu. Yek God ananiwe Nuganinu, yek yet eke kobi inek enech echudak wak. Yek eke inek echudak douk yek yatik yekinu Aninu nenekech uli atich. Echebuk douk Aninu nenekech uli, yek chopuk eke inekech. ");
INSERT INTO apeB_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Aninu ananim ulkum douk manubu manosuh yek ali anan nagilape chanatimaguk echudak anan nape nenekech uli. Anan eke nugilape inek enen douk nyechalakuk enyudak douk Aninu anagilape yeneken uli. Ineken ali ipak eke putulin loguh hwunechlukepu. ");
INSERT INTO apeB_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Aninu isave nohul chagak uli nolukech yapis ali wata chaitak chape. Ali douk namudak ati. Yek ananiwe nuganinu chopuk eke ihul echebuk yek ikli ichuhul uli. Ichuhul ilukwech yapis ali wata chitak chupe. ");
INSERT INTO apeB_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Ali Aninu anan yet eke kobi nusuh enen elpen enyenyitu kwot, wak. Enyudak moul umu nusuh kwotog umu douk anoku yeken. ");
INSERT INTO apeB_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Anan douk nenek namudak umu chunatimaguk elpech eke chutuk yekin yeul nyukih kobi chatuk yekinu Aninu ananin yeul umu. Ali enyebuk elpen douk wo nyutuk yek ananiwe nuganinu yekin yeul uli e, enyen douk wo nyutuk yekinu Aninu ananin yeul e, douk nakagasi yek yanakili, wak. ");
INSERT INTO apeB_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Aduligu atugu yaklipepu. Echebuk elpech douk chumnek yekin balan ali chugipech anudak douk nekege yanaki ulimu, echech eke chupe kalbu eheh nyumneh. Ali echech eke kobi chiyotumu atudak God ananitu nebetali kwot, wak. Echech douk achatukemaguk agundak chagak umu ali eke chupe kalbu eheh nyumneh. ");
INSERT INTO apeB_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Aduligu atugu yaklipepu. Nyultab douk eke butoglu, ali douk abatoglu, umu chagak uli eke chumneki yek God ananiwe Nuganinu yekigu nigamu. Ali echebuk douk chumneke ali chugipeche uli, echech eke chitak chupe kalbu ali kobi wata chugak, wak. ");
INSERT INTO apeB_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Aninu douk nanubu bawagas umu agundak elpech chupe kalbu ali kobi wata chugak umu. Ali douk namudak ati. Anan nenek yek yatoglu bawagas umu agundak elpech chupe kalbu ali kobi wata chugak atimu. ");
INSERT INTO apeB_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Ali God douk aneke enyudak namba umu isuh elpech echechig kwotog umu. Umu moneken, yek douk Anudak Alman douk yatoglu aduligeinyi elpen uli. ");
INSERT INTO apeB_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","29","Ali ipak loguh kobi hwunechluk-epamu enyudak umu chagak uli eke wata chitakumali. Nyultab douk abape banaki, umu elpech douk seiwak chagak ali chanugomech cholu iwagas uli eke chumneki yekigu nigu ali eke wata chitak chultowi echechigas iwagas umu. Ali echebuk douk chenek yopinyi pasin uli eke chitak chupe kalbu ali kobi wata chugak, wak. Echebuk douk chenek enenyi enen yowenyili eke chitaki chunak chiyotumu nebetali kwot ali chulau nebehi nyih.” ");
INSERT INTO apeB_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Ali Jisas nakli, “Yek yet eke kobi inek enech echudak umu yekin tinytin, wak. Yek yagipech yekinu Aninu naklipeyen uli balan ali yenek skel umu elpech. Namudak ali yasuh kwotog umu, yek douk yanubu yenek skel umu echechin balan duldul. Umu moneken, yek wo igipech yekin tinytin ali inek enyudak moul e, wak. Yek yagipech anudak douk nekege yanakili ananin balan ali yenek enyudak moul anan naklimu yek ineken uli. ");
INSERT INTO apeB_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Douk yek yet ikli iklipech umu yek yet ele, enyudak yekin yeyagwlehen uli balan eke kobi chuhwen chukli adulin, wak. ");
INSERT INTO apeB_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Wakuli douk ananu nagakome nape naklipech umu yek. Ali yek yadukemech umu, enyudak balan anan naklien umu yek uli douk adulin atin. ");
INSERT INTO apeB_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","“Seiwak ipak pakagas anam halau balan uli hanak hasolik Jon ali anan naklipepu adulin atin balan umu yek. ");
INSERT INTO apeB_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Ali yek douk wo iklimu enech elpech chuklipech yekin balan kipaichimu chudukemech umu yek meiweli e, wak. Yek yakli enyudak balan umu yakli God wata nunolawepu putanamu pupe kalbu. ");
INSERT INTO apeB_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Jon anan nape kobi lam douk hanin ali nyaglak umu elpech umu. Ali ipakiluh apaluh douk yopuluh ali penehilaumu ananitu lait douk taglak abudak banabu nyultab uli. ");
INSERT INTO apeB_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Wakuli enyudak moul yek yeneken uli douk nyanubu nyechalakuk enyudak balan douk Jon naklien umu yek uli. Enyudak moul douk God nekeyen umu ineken iyaten ali douk enyudak yape yeneken uli, enyen meyoh eke nyugilapu elpech ali chudukemech umu yek douk Aninu God nekegeli ali dakio yanaki. ");
INSERT INTO apeB_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Ali yekinu Aninu douk nakagasi yek yanakili, anan yet douk naklipepu bawogenyumu balan umu yek. Ipak douk wo pumnek ananitu yokwatu niyagwleh anagun e, wak. Ali chopuk ipak douk wo putulunu e. ");
INSERT INTO apeB_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Ananin balan chopuk douk wo nyupe ipakiluh apaluh e, wak. Umu moneken, ipak douk wo punek bilip umu yek douk Anan nekege yanakili e. ");
INSERT INTO apeB_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Ipak pakli enyudak balan nyetemu God ananik buk uli eke nyunekepu pupe kalbu eheh nyumneh! Douk namudak ali ipak pape patalih wolobainyi balan nyetemu okudak buk uli, ali penek tinyumen umu pakli pulau save. Enyudak nyetemu buk uli balan douk nyaklimu yek! ");
INSERT INTO apeB_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Wakuli ipak panubu pakli wak umu punakumali yek, umu pupe kalbu. ");
INSERT INTO apeB_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Ali yek yakli wak umu elpech chutuk yekin yeul, wak. ");
INSERT INTO apeB_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Wakuli yek yadukemepamu, ipakip ulkwip douk wo punosuh God e, wak. ");
INSERT INTO apeB_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Yek douk yanakimu yekinu Aninu ananin yeul, ali ipak douk wo puke apaluh pukli pumnek yekin balan e, wak. Wakuli sapos ananu alman meyoh nunaki nuklipepamu ananin yet yeul ele, ipakiluh apaluh deke yopuluh ali eke adakio pumnek ananin balan. ");
INSERT INTO apeB_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Ipak ulkwip polomu pakli ipak yet punotuk ipakich yeguh chukih. Wo kwalowi pichakomech umu punek enen pasin umu pukli anudak nanubu atunali God meyoh nutuk ipakich yeguh chukih e, wak. Douk namudak ali ipak eke pusuh yekin balan pugipechen malmu? Aduligu atugu eke wak. ");
INSERT INTO apeB_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Ali ipak douk kobi punek tin pukli yek eke inekumepu kwotog umu yekinu Aninu God, wak. Alman nunekumepu kwotog uli douk anudak ipak pakli eke nugakamepu uli. Anan douk Moses. ");
INSERT INTO apeB_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Ali sapos ipak punek bilip umu Moses ananin balan ele, ipak deke punek bilip umu yekin chopuk. Umu moneken, Moses nenyemaguk uli balan douk nyaklimu yek. ");
INSERT INTO apeB_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Ipak douk wo punek bilip umu enyudak balan seiwak Moses nenyemaguk uli e, wak. Namudak ali ipak eke punek bilip umu yekin balan malmu? Eke wak.” ");
INSERT INTO apeB_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Ali anabu nyultab banakuk, ali Jisas nablo nanamu gani woblahah enyudak nebenyi raunwara Galili. Enyudak enen yeul douk chohwalen umu Taibirias. ");
INSERT INTO apeB_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Ali chanubu wolobaichi elpech chagipechanu. Umu moneken, echech douk chatik enyudak God atunu neneken uli moul douk anan neneken umu nagabe agudak genekechi elpech yopich umu. ");
INSERT INTO apeB_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Jisas nanak nalto anatu nukut ali nakih nanu ananim disaipel hape agnabuk. ");
INSERT INTO apeB_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Ali ababuk nyultab umu echech Juda chunek agundak nebeguni woligun Pasova umu douk ahalakatimu eke butoglu. ");
INSERT INTO apeB_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Jisas natulugun neyatagun wakuli natik umu chanubu wolobaichi elpech chape chanamanali. Ali nasolik Filip nakli, “Filip, eke munak mutal anatu bret agnumu, umu echudak chunatimaguk elpech eke chutawah uli?” ");
INSERT INTO apeB_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Jisas nasolikanu enyudak balan umu nakli nichakamanu. Anan douk anadukemech umu enyudak douk eke nuneken uli. ");
INSERT INTO apeB_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Ali Filip nebemanu balan nakli, “Sapos apak muwachak wolobaibali utabal 200 kina mutal anatu bret ele, atabuk bret eke kobi tunokwnumu echudak chunatimaguk elpech umu kwalowi chuwak anagun muduk ati wak. Eke kobi tunokwnu.” ");
INSERT INTO apeB_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Ali anudak ananu Jisas ananinamu disaipel Andru douk nanu Saimon Pita amam sanyowan uli nakli, ");
INSERT INTO apeB_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Ananu chokunali neyotu agundak uli douk noluk bias chokusi yelbus sanu 5-poleitu chokutali balitu bret. Ali echebuk douk chopuk eke chunek moneken gipiya umu echudak wolobaichi elpech?” ");
INSERT INTO apeB_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Ali Jisas naklipapu nakli, “Klipech chupe atap.” Agnabuk douk wolobaipi wichap patoglu ali chanatimaguk chabih chape. Wolobaichumali, almam atum umu douk hanubu wolobaimi 5,000-poleim. ");
INSERT INTO apeB_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Douk chabih chapemu julug, ali Jisas nohul bret nahwotu nenek tenkyumu God ali nape neyaisatu nekech. Neyaisatamech umu julug, ali asudak bias yelbus douk nosuhul nenek namudak ati. Ali echech chanatimaguk chachah aliga dugolech uli atich. ");
INSERT INTO apeB_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Douk chanatimaguk dugolech ali naklipu ananipu disaipel nakli, “Putulich putalmu bret douk chatawah ali tenek lep takus uli. Kobi mutiteh anagunitamu tukusuk meyoh, wak.” ");
INSERT INTO apeB_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Memnek namudak ali matalmatu motoluk 12-poleig basketog ali chichuknig atimu tutukanitamu atudak 5-poleitu balitu bret douk echudak wolobaichi elpech chanu batowich chatawah ali tenek lep takusuk uli. ");
INSERT INTO apeB_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Douk echudak elpech chatik enyudak God atunu neneken uli moul douk anan Jisas neneken uli ali chakli, “Aduligu atugu, anudak alman douk anudak profet God naklimu eke nukaganu nunamali apudak atap uli.” ");
INSERT INTO apeB_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Jisas natulich ali anadukemech umu echech ahalakatimu eke chunaki didigep pupe chuhwanu ali chunekanu nupe echechinu king. Namudak ali natukemechuk anan atunu nanak nalto maunten. ");
INSERT INTO apeB_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Douk aliga wabigun ali ananipu disaipel maitak maglumu enyudak raunwara. ");
INSERT INTO apeB_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Mabih malto anatu bot ali mablo manak umu makli munamu wabul Kapaneam. Ababuk nyultab douk ayowab, wakuli Jisas douk watak nunaki nutoglomapu e, watak. ");
INSERT INTO apeB_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Ali ababuk nyultab, nebenali wihun douk nalu nohul yous nebebi molub batuk ali yous yoweg. ");
INSERT INTO apeB_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Apak eke amonek pul manak 5 o 6 kilomita lougun umu algas ali nameitamu Jisas nalaheli chihahibal umu abal nanaki halakatimu bot. Douk matik namudak ali manubu elgeipu. ");
INSERT INTO apeB_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Ali Jisas naklipapali nakli, “Kobi elgeipu, wak. Enyudak douk yek Jisas wo.” ");
INSERT INTO apeB_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Douk memnek ali monehilawomu mulawanu nulto bot. Ali ahudak atuh matik umu bot atanak tatoglu gani woblahah enyudak raunwara douk apak mape monek pul manak umu. ");
INSERT INTO apeB_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Wehluwih ali echudak wolobaichi elpech douk wata chape gani woblahah enyudak raunwara. Chadukemech umu nabatik wak anatu alagun bot tulu agnabuk e, wak. Atutu meyoh talu ali douk ananipu disaipel atupu malto monek pul manak. Jisas wo nunamapu munak e, wak. ");
INSERT INTO apeB_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Ali ababuk nyultab, onog botog gwalali wabul Taibirias uli douk gwanak gwatogloli. Gwatogloli halakatimu agundak douk Jisas nenek tenkyumu God umu bret ali noku echudak elpech chatawah umu. ");
INSERT INTO apeB_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Douk echudak elpech chatik umu Jisas nanu ananipu disaipel wo mupe agnabuk e, ali chabih chalto ogudak botog chanamu Kapaneam umu chutimu Jisas agnabuk. ");
INSERT INTO apeB_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Douk aliga chanak chogwatanu gani woblahah-inyumu enyudak raunwara ali chaklipanu chakli, “Nebenyali Tisa, makwnih nyanaki agundak?” ");
INSERT INTO apeB_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Ali Jisas nebemech balan nakli, “Aduligu atugu yaklipepu, ipakip ulkwip douk wo pulomu enyudak yeneken uli nebenyi moul olsem anagu mak yek yagilapepamu ali dakio panaki patime e, wak. Ipak douk pawak bret chuknipu atipu ali pape patimemu douk namudak. ");
INSERT INTO apeB_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Kobi pupe punek moul umu echudakmali kakwich douk eke pichah ali chunak chuwichuk uli, wak. Wakuli ipak imas punek moul umu putimu echudak enech kakwich douk eke pulawech ali eke chunekepu pupe kalbu eheh nyumneh uli. Echudak kakwich douk yek Anudak Alman douk yatoglu aduligeinyi elpen uli eke ikepeyech. Umu moneken, Aninu God douk aneke namba ali naklipe wasik umu inek enyudakmali moul.” ");
INSERT INTO apeB_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Namudak ali chasolikanu chakli, “Ali apak eke munek moneken, umu God nutulupu ali nukli wasik nunehilau-mapamu?” ");
INSERT INTO apeB_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Ali naklipech nakli, “Moul douk God naklimu puneken uli douk enyudak. Anan douk nakagasi yek yanaki, ali nakli ipak imas pusuh yekin balan dadag pugipechen.” ");
INSERT INTO apeB_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Namudak ali echech wata chasolikanu chakli, “Eke nyunek moneken God atunu neneken uli moul umu apak mutulin ali munek bilip umu nyakin balan? Eke nyunek moneken? ");
INSERT INTO apeB_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Apakich yamech douk chawak atudak bret mana gani wohigunmu elpech wak umu. Chatawah kobi God ananin balan nyetemu ananik buk uli nyaklimu. Nyakli namudak. ‘Anan nekech bret tabihi iluh heven uli chatawah.’” ");
INSERT INTO apeB_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Jisas nemnek ali naklipech nakli, “Aduligu atugu yaklipepu, atabuk bret tagluki iluh heven uli douk wo Moses nukepeyatu e, wak. Yekinu Aninu nekepu atudak aduligeitu bret douk tagluki iluh heven uli. ");
INSERT INTO apeB_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Bret douk God nekepeyatu uli douk tatukemaguk iluh heven ali taglukumali tugakomu apudak atapipali elpech umu pupe kalbu eheh nyumneh.” ");
INSERT INTO apeB_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Ali echech chaklipanu chakli, “Nebenyali, apak makli nyak nyupemu nyukapu atabukmali bret wihluwehlu.” ");
INSERT INTO apeB_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Ali Jisas naklipech nakli, “Yek douk atudak bret douk eke chulawatu ali chupe kalbu eheh nyumneh umu. Echebuk douk chunamali yek ali chusuh yekin balan chugipechen uli, echech eke kobi wata nyulub blech o wata abal blugahegech chopuk, wak. ");
INSERT INTO apeB_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Wakuli douk ayaklipepu, ipak douk apatuliwe wakuli wo pusuh yekin balan dadag pukli adulin e, wak. ");
INSERT INTO apeB_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Ihech elpech douk yekinu Aninu natalihech umu chunamali yek uli eke chunameli. Echebuk douk chunamali yek uli, yek eke kobi inoguglech ikechuk agab, wak meyoh. ");
INSERT INTO apeB_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Yek douk wo itukemaguk iluh heven ali iglukumali igipech yekin laik inek enenyi enen moul kobi yek ulkum molomen ulimu e, wak. Wakuli douk yanakumali igipech yekinu Aninu douk nekege yanakili ananin laik. ");
INSERT INTO apeB_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Ali anan nekege yanakili naklimu ineken uli douk enyudak. Nakli kobi itukemaguk enen echudak chanatimaguk elpech douk anan natalihech umu chunamali yek uli nyunak nyuwichuk, wak. Wakuli nakli yek imas ilukwech yapis chunatimaguk ali wata ichuhul chitak chupe abudak nyultab hugikuk uli nyumnah hutoglomu. ");
INSERT INTO apeB_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Aduligu, yekinu Aninu nakliyenyi douk akenyudak. Nakli chunatimaguk elpech douk chutik yek ananiwe Nuganinu ali chusuh yekin balan chugipechen uli, echech douk eke chunubu chupe kalbu eheh nyumneh. Ali douk eke wata ilukwech yapis ichuhul chitak chupe ahudak hugikuk uli nyumnah hutoglomu.” ");
INSERT INTO apeB_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Echech Juda chemnek nyihihichich ali achape cheneyagwleh chokwin atin, umu agundak Jisas nakli anan douk atudak bret tagluki gani iluh heven ulimu. ");
INSERT INTO apeB_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Namudak ali chakli, “Anudak alman anan douk Josep ananinu nuganinu chohwalanamu Jisas uli. Ananich mamechich douk madukemech. Ali malmu namudak, umu dukwechuk nakli anan douk napeli iluh heven naglukumali?” ");
INSERT INTO apeB_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Jisas nemnek ali nebemech balan nakli, “Ipak kobi nyihihichipu ali ipak yet pupe piyagwleh balan punobomu chokweh pulikuk, wak. ");
INSERT INTO apeB_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Wak enen elpen deke nyunokwnumu nyunamali yek e, wak. Sapos Aninu douk nakagas yek yanakili nuhul enyebuk elpen ele, enyen wasik deke nyunamali yek ali nyusuh yekin balan nyugipechen. Ali enyebuk elpen, yek douk eke wata inyuhul nyitaki iwagu ahudak hugikuk uli nyumnah hutoglomu. ");
INSERT INTO apeB_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Balan douk amam profet henyemu nyetemu God ananik buk uli douk nyakli: ‘God eke nunek skulumu ihech elpech ananin pasin.’ Namudak ali chunatimaguk elpech douk chumnek Aninein balan ali chudukemen kalbaluli, echech eke chunamali yek. ");
INSERT INTO apeB_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Wak enen elpen nyutik Aninu e, wak. Yek douk yanu God wapeli ali yaitak yanakili otuwe yatulunu. ");
INSERT INTO apeB_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Aduligu atugu yaklipepu, echebuk elpech douk chusuh yekin balan chugipechen uli, echech douk eke chupe kalbu eheh nyumneh. ");
INSERT INTO apeB_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Yek Jisas douk atudak bret douk elpech eke chulawatu ali tunekech chunubu chupe kalbu eheh nyumneh ulimu. ");
INSERT INTO apeB_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Seiwak ipakich popech yamech douk chawak atudak bret mana gani wohigunmu, wakuli echech douk wata chagak. ");
INSERT INTO apeB_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Wakuli elpech douk chuwak atudak aduligeitali bret douk tatukemaguk iluh heven taglukili, echech douk eke kobi chugak, wak. ");
INSERT INTO apeB_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Yek yet douk atudak aduligeitu bret douk tagluki gani iluh heven umu eke tunek elpech chupe eheh nyumneh uli. Elpech douk chuwak atudak bret uli eke chunubu chupe kalbu eheh nyumneh. Atudak bret douk yekihw yegenyihw. Eke ikech yekihw yegenyihw umu igakamu chanatimaguk apudak atapichi elpech umu chupe kalbu eheh nyumneh.” ");
INSERT INTO apeB_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Douk echech Juda chemnek namudak ali nyihihichich. Ali echech yet achape chalpak balan chakli, “Anudak alman nakli deke nukapu ananihw yegenyihw muhwah malmu?” ");
INSERT INTO apeB_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Ali Jisas naklipech nakli, “Aduligu atugu yaklipepu, sapos ipak kobi puwak yek Anudak Alman douk yatoglu aduligeinyi elpen uli yekihw yegenyihw o puwak yekig butog umu, ipak eke kobi pupe kalbu eheh nyumneh, wak. ");
INSERT INTO apeB_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Wakuli echebuk elpech douk chuwak yekih yegenyihw hwunu yekig butog uli, echech eke chupe kalbu eheh nyumneh. Ali ahudak hugikuk uli nyumnah hukli hutoglu abali, yek douk eke wata ichuhul chitak chupe. ");
INSERT INTO apeB_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Umu moneken, yekihw yegenyihw ohwohw douk hwanubu kobi aduligeichi kakwich umu. Yekig butog ogwog douk chopuk gwanubu kobi aduligeibal abal umu. ");
INSERT INTO apeB_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Echebuk elpech douk chuwak yekihw yegenyihw hwunu yekig butog uli, echech douk chape yek ali yek yape echech. ");
INSERT INTO apeB_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Yekinu Aninu douk nanubu bawagas umu agundak chupe kalbu eheh nyumneh ulimu douk nakagasi yek yanaki. Ali yek douk yape dodogowiwemu anan ali eke inubu ipe eheh nyumneh. Ali douk namudak ati. Yek douk dodogowiweli ali echebuk douk chuwak yekihw yegenyihw uli, yek douk eke inekech chunubu chupe kalbu eheh nyumneh. ");
INSERT INTO apeB_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Yek douk atudak bret douk tagluki gani iluh heven uli. Atudak bret douk wo kobi atudak seiwak ipakich yamech chatawah wakuli echech wata chagak ulimu e, wak. Elpech douk chuwak atudak bret uli, echech eke chunubu chupe kalbu eheh nyumneh.” ");
INSERT INTO apeB_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Jisas naklipech enyudak balan abuldak wabul Kapaneam. Naklipechen abudak nyultab nape nenek skulumech yopinyi balan gani numun echechitu chape cheyagwleh balan atali wilpat abali. ");
INSERT INTO apeB_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Wolobaichi elpech douk chapemu chemnek ananin balan ali chagipechanu uli douk chemnek enyudak balan ali cheneyagwleh chakli, “Enyudak balan douk nyanubu nyenek hat umu apak mugipechen umu. Deke omuni nyupe nyumneken nyugipechen?” ");
INSERT INTO apeB_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Jisas douk wak enech elpech chuklipanu e, wakuli anadukemech umu echech douk nyihihichich ali chape cheneyagwleh chokubul atimu enyudak balan douk naklipechen uli. Namudak ali naklipech nakli, “Ipak douk pemnek enyudak balan nyenek ipakip ulkwip yowep ali nyihihichipu, waka? ");
INSERT INTO apeB_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Ali douk eke malmu, sapos ipak putik yek Anudak Alman douk yatoglu aduligeinyi elpen uli iltomu iluh douk likuk yapelimu? ");
INSERT INTO apeB_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Elpech meyoh deke kobi dodogowich umu chugakomu echech yet umu chupe kalbu eheh nyumneh, wak. God ananin Michin atin wasik nyanubu dodogowin atin umu nyunekech chupe kalbu eheh nyumneh. Enyudak yek yaklipepu enyi balan douk eke nyugakamu ipakich michich ali eke nyunekepu punubu pupe kalbu eheh nyumneh. ");
INSERT INTO apeB_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Yaklipepu balan wakuli enepu wo punek bilipume e, wak.” Jisas anan douk alikuk nohul ananin moul nape neneken umu ali nadukemech umu echebuk elpech douk eke kobi chunek bilipumanu uli, chanu anabuk alman douk eke nugilapu ananim birua anan Jisas ali huhwanu hunak honu nugak uli. ");
INSERT INTO apeB_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Ali Jisas wata chopuk nakli, “Douk namudak ali dakio yaklipepu yakli, ‘Sapos God kobi nuken strong enen elpen umu, enyen meyoh eke kobi dodogowin umu nyunaki nyunek bilip umu yek, wak.’” ");
INSERT INTO apeB_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Jisas naklipech enyudak balan umu julug, ali wolobaichi elpech douk chapemu chagipechanu chemnek ananin balan uli wata chatukemanaguk chatanamu. Wata chuklimu chugipechanu e, wak. ");
INSERT INTO apeB_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Jisas natik namudak ali nasolik ananim 12-poleim disaipel nakli, “Ati ipak douk chopuk pakli putukemeik punak, waka?” ");
INSERT INTO apeB_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Ali Saimon Pita nebemanu balan nakli, “Diginyali, apak mutukemaguk nyak ali eke wata munamu omuni? Ati wak. Balan douk eke nyugakamapamu munubu mupe kalbu eheh nyumneh umu douk nyapemu nyak atinyu. ");
INSERT INTO apeB_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Nameitu apak douk manubu monek bilip ali madukemech umu, nyak douk nyanubu yopiyopinyali alman douk God natalihenyu ali nekegenyu nyanakili.” ");
INSERT INTO apeB_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Ali Jisas nebemom balan nakli, “Yek yet yatalih ipak 12-poleipu almam. Wakuli ipak 12-poleipu, ipak ananu douk Satan ananinu nuganinu.” ");
INSERT INTO apeB_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Enyudak balan douk nakliyen nenyemu Judas, anudak Saimon nanaki Kariot uli ananinu nuganinu. Anan douk ananu umu amudak 12-poleim disaipel, wakuli anan eke nugilapu Jisas ananim birua anan Jisas ali amam huhwanu hunak honu nugak. ");
INSERT INTO apeB_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Enyudak nyanakuk ali Jisas nape enyudak provins Galili nape nalahe nanak walub. Amam nebemi Juda hakli honu nugak. Namudak ali wo nunak nulahe nunak enyudak provins Judia e, wak. ");
INSERT INTO apeB_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Ali ahudak nyumnah umu echech Juda chunek lotumu God ali chulak chomeguhwiyu chuwich chupe chunek woligun umu douk ahalakatimu hutoglu. ");
INSERT INTO apeB_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Ali Jisas ananim owahlim haklipanu hakli, “Nyutukemaguk agundak ali nyunamu Judia. Nyunak umu nyakich elpech chagipech nyak uli chutik enyudak God atunu neneken uli moul douk nyak nyape nyeneken uli. ");
INSERT INTO apeB_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Sapos enen elpen nyuklimu chunatimaguk chumnek umu enyen umu, enyen douk wo nyunobechuk nyunek enyenyin moul ati e, wak. Ali nameitu nyak douk nyenek enyudak ali imas nyuneken yopugunmu, umu chunatimaguk tikuk ati.” ");
INSERT INTO apeB_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Ananim bawogeim owahlim heyagwleh enyudak umu moneken, amam chopuk wo hunek bilipumanu e, wak. ");
INSERT INTO apeB_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Jisas nemnekam ali nakli, “Yekibu duldulibu nyultab umu inak umu douk watak butoglu e, watak. Hanatimaguk nyumneh eheh douk ipakih. Ipak pukli punak umu, orait ipak douk wasik iken punak meibali nyultab ipak pakli punak umu. Yek watak. ");
INSERT INTO apeB_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Apudak atapichi elpech eke kobi chutulipaguk yowes chukepaguk agabus ipak, wak. Yek douk wasik eke chutuliweik yowes ali eke chukeik agabus. Umu moneken, yek douk yapemu yaklipech umu enenyi enen yowenyi douk echech chapemu cheneken uli. ");
INSERT INTO apeB_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Ipak atipu wasik punamu agundak nebeguni woligun. Yek eke kobi kebes inaku watak. Umu moneken, yekibu duldulibu nyultab umu inak umu douk watak butoglu e, wak.” ");
INSERT INTO apeB_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Naklipam namudak ali wata napeik Galili. ");
INSERT INTO apeB_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Douk ananim owahlim hanamu agundak nebeguni woligun ali Jisas chopuk naitak nagikuk nanak. Nanak wakuli wo nunak yopugunmu e, wak. Nonobechuk ati nanak. ");
INSERT INTO apeB_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Echech Juda echechim nebemi douk hape haulimanu agundak chenek woligun umu. Hape hasolikech hanak hakli, “Patulunu anudak alman nape agnumu?” ");
INSERT INTO apeB_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Wolobaichi elpech douk chanaki chowachabal umu chunek agundak nebeguni woligun. Ali chape chanobomu chokweh cheyagwleh chokubul atimu Jisas. Enech chakli anan yopunali alman. Wakuli enech chakli anan yowenali alman douk nalaugamu elpech meyoh. ");
INSERT INTO apeB_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Wakuli yopugunmu douk wak enech elpech chupe chiyagwleh-umanu enen balan e, wak. Umu moneken, echech douk elgeich umu echechim nebemi. ");
INSERT INTO apeB_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Chenek agundak nebeguni woligun aliga chanak cheyotu olokohun ali Jisas nanak nawich banis God ananitu nebetali wilpat tatawomu ali anape nenek skulumech God ananin balan. ");
INSERT INTO apeB_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Douk echech Juda echechim nebemi hatulunu ali loguh hwonechlukam. Ali hakli, “Anudak alman douk wo nunek skul enen apakin skul e, wak. Ali malmu namudak umu anan nanubu nadukemech nalikuk umu?” ");
INSERT INTO apeB_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Namudak ali Jisas nebemam balan nakli, “Enyudak balan yek yenek skulumepu-enyi douk wak inek skulumepu yekin e, wak. Yenek skulumepu God douk nekege yanakili ananin balan. ");
INSERT INTO apeB_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Sapos enen elpen nyunubu nyuklimu nyugipech God ananin laik umu, enyen douk eke nyudukemu bawogenyumu enyudak balan yek yenek skulumepu-enyi. Enyen eke nyudukemech umu enyudak balan douk God naklipelimu inaki iklipepeyen o yek meyoh yenenyuhul yaklipepeyen. ");
INSERT INTO apeB_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Elpen douk enyen yet ulkum mulomu enen balan ali nyiyagwlehen uli, enyebuk elpen douk nyaklimu nyiyagwleh umu nyutuk enyenyin yet yeul. Wakuli yek douk yakli ituk anudak douk nekege yanakili ananin yeul. Ali yek, lohwotuhwin balan douk wo iyagwlehen ati e, wak. Yeyagwleh adulin atin. ");
INSERT INTO apeB_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Seiwak Moses nekepu lo douk God nakaneyenyuk uli. Wakuli douk wo kwalowi enen elpen nyuhwen nyugipechen kalbu e, wak. Ali nameitu ipak douk pakli pubo yek igak umu moneken?” ");
INSERT INTO apeB_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Ali echudak wolobaichi elpech chebemanu balan chakli, “Nyak enen sagabu nyapenyinyu. Omuni nyaklimu nyenyu nyugak?” ");
INSERT INTO apeB_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Jisas nebemech balan nakli, “Yek yenek atin God atunu neneken uli moul ali ipak panatimaguk patulin loguh hwonechlukepu. ");
INSERT INTO apeB_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Ali Moses douk nekepaguk enyudak pasin umu putah nugamimiluh yegechiweluh umu. Ali ahudak wo punek moul ahi e nyumnah Sabat, ipak douk chopuk patah nugamimiluh yegechiweluh. Adul, enyudak pasin douk wo Moses ninyuhul nukepeyenyuk e, wak. Enyen douk ipakim popem yamem meyoh henyuhul hekepeyenyuk. ");
INSERT INTO apeB_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Ipak isave pagipechen duldul enyudak lo douk God nakaguk Moses umu agundak patah nugamimiluh yegechiweluh umu. Ali ahudak nyumnah Sabat douk wo punek moul umu e, ipak isave penek moul umu patah nugamimiluh yegechiweluh. Wakuli nubuwakih yek yagapech ananu agudak ganali alman nanubu yopunu ahudak nyumnah Sabat umu, ipak douk patuliwe panubu nyihihichi-pamu moneken? ");
INSERT INTO apeB_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Kobi putik enenyi enen nabes meyoh ali pukli enyudak yopinyi o yowenyi, namudak wak. Wakuli enenyi enen, ipak imas pudukemen kalbu ali adakio punek skelumen.” ");
INSERT INTO apeB_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Enech almam almagou chape Jerusalem uli chatik enyudak Jisas neneken uli moul ali cheneyagwleh chakli, “Alman ati eke anudak, douk apakim nebemi hape hatimanamu honu nugak uli. ");
INSERT INTO apeB_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Ali douk tik. Anan douk nape neyagwleh agundak wolobaichi chowachabal chapemu, wakuli amam douk wo husapanamu kobi niyagwleh e, wak. Ati amam douk eke hadukemech hakli anan Krais douk God natalihanu ali nakaganu nanamali nunolau elpech uli, waka? ");
INSERT INTO apeB_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Ali nani ananibul wabul douk madukemabul. Wakuli abudak nyultab Krais nutoglomu, apak eke kobi enen elpen nyudukemu abuldak wabul douk anan nunaki abuli, wak.” ");
INSERT INTO apeB_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Jisas douk wata nape nenek skulumech balan gani numun banis agundak God ananitu nebetali wilpat tatawomu. Douk echech cheyagwleh namudak ali anan wata neyagwleh nebenyi balan nakli, “Adul, ipak douk pakli ipak padukemu yek kalbu. Wabul yanaki abuli chopuk pakli padukemabul kalbu. Wakuli yek douk wo inamali yekin laik e, wak. Anudak nakagasi yek yanakili douk nanubu aduligeinu ali douk nape uli. Ali ipak douk wo pudukemu Anan e, wak. ");
INSERT INTO apeB_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Wakuli yek douk yadukemanu. Umu moneken, yek douk yanu Anan wapeli ali nekege yanaki.” ");
INSERT INTO apeB_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Douk nakli enyudak balan ali amam nebemi hakli huhwanu hunak huwechikanu nupe haus kalabus. Wakuli wo kwalowi ananu nuwemeyanu wis e, wak. Umu moneken, abudak nyultab douk eke chonu nugak umu douk watak butoglu e. ");
INSERT INTO apeB_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Wolobaichi elpech chenek bilip umu Jisas ali chakli, “Abudak nyultab Krais nutoglu abali, ati anan douk eke nutoglu nunek wolobainyi God atunu neneken uli moul nyichalakuk enyudak anudak alman neneken uli, waka? Ati wak.” ");
INSERT INTO apeB_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Aliga ali amam Farisi ahemnek umu echudak wolobaichi elpech chape cheneyagwleh chanak chokubul atimu enyudak Jisas neneken uli. Namudak ali amam hanu nebemi pris hakagas anam almam henek was umu God ananitu nebetali wilpat uli umu hunak husuh Jisas hulawanali. ");
INSERT INTO apeB_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Wakuli Jisas naklipam nakli, “Yek eke inepu mupe banabu nyultab meyoh. Wakuli eke wata itanamu inamu anudak douk nekege yanakili. ");
INSERT INTO apeB_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Ali ipak douk eke pupe pulime, wakuli eke kobi pugwate, wak. Umu moneken, agundak yek inak ipemu, ipak eke kobi punaku.” ");
INSERT INTO apeB_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Ali echech Juda echechim nebemi heneyagwleh hakli, “Nakli eke nunak agnumu, umu apak eke mubilak kobi mutulunamu? Ati nakli eke nunamu echech Grik echechilub nebelubi walub douk enech apak Juda chanak chapenyulub uli, waka? Umu nakli nunak nunek skulumech God ananin balan echech Grik, waka? ");
INSERT INTO apeB_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Anan douk nakli, ‘Ipak eke pupe pulime, wakuli eke kobi pugwate, wak.’ Ali chopuk douk nakli, ‘Ipak eke kobi punaku agundak douk yek inak ipemu, wak.’ Bawogenyumu enyudak balan douk nyakli malmu?” ");
INSERT INTO apeB_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Ahudak hagikuk uli nyumnah umu agundak nebeguni woligun gnutuh umu douk hanubu nebehi nyumnah. Ali Jisas naitak neyotu neyagwleh nebegun atugun ali nakli, “Echebuk elpech douk abal blugahegech uli, echech douk chunamali yek ali eke ikech anabal abal chubalah. ");
INSERT INTO apeB_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Kobi douk balan nyetemu God ananik buk uli nyaklimu. Echebuk elpech douk chusuh yekin balan chugipechen uli, abal douk blunekech chupe kalbu eheh nyumneh uli eke blu blupeli namudak gani numun echechip ulkwip ali blutogloli aduk.” Enyudak eke nyutoglu kobi balan nyetemu God ananik buk uli nyaklimu. ");
INSERT INTO apeB_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Jisas douk nakli enyudak balan umu God ananin Michin. Naklipech umu echebuk douk chunek bilip umu anan uli eke chulawen nyupenyich umu. Ali ababuk nyultab, God ananin Michin douk watak nyunaki nyuwichech e, wak. Umu moneken, Jisas douk watak chonu nugak ali nitaki nultomu iluh heven nukih nulau nebenyi yeul e. ");
INSERT INTO apeB_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Douk chemnek enyudak balan ali enech chakli, “Anudak alman douk nanubu anudak profet douk God naklimu eke nukaganu nunamali apudak atap uli.” ");
INSERT INTO apeB_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Wakuli enech chakli, “Wak. Anan Krais douk God natalihanu ali nakaganu nanamali nunolau elpech uli.” Wakuli enech chakli, “Krais eke kobi nitak enyudak provins Galili, wak. ");
INSERT INTO apeB_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Umu moneken, balan nyetemu God ananik buk uli nyakli Krais eke nitak apudak Devit ananip awilop, ali mamakik eke kunalali abuldak wabul Betlehem douk seiwak King Devit napemu.” ");
INSERT INTO apeB_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Namudak ali chanadiyagulmu. Woblech chakli Jisas anan adul Krais. Wakuli woblech chakli wak chaulal. ");
INSERT INTO apeB_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Anam almam douk hakli huhwanu hunak huwechikanu nupe, wakuli wo kwalowi enen elpen nyuklimu nyuwemeyanu wis e, wak. ");
INSERT INTO apeB_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Namudak ali amudak henek was umu God ananitu nebetali wilpat uli wata hatanamu hanamu amam nebemi pris hanu amam Farisi. Hatanamu ali amudak nebemi hasolikam hakli, “Ipak wo puhwonu pulawanali e umu moneken?” ");
INSERT INTO apeB_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Ali amam hebemom balan hakli, “Likuk douk wo kwalowi enen elpen nyugamu nyiyagwleh kobi nameitu anudak alman neyagwleh umu e, wak.” ");
INSERT INTO apeB_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Amam Farisi hemnek ali hebemom balan hakli, “Ati ipak douk chopuk nalaugame-palimu ananin balan, waka? ");
INSERT INTO apeB_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Ipak douk eke patik umu apak ananu nebenali o ananu Farisi nenek bilip umu Jisas waka? Ati wak meyoh. ");
INSERT INTO apeB_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Wakuli echudak wolobaichi elpech douk chenek bilipumanu uli, echech douk wo chudukemu God ananin lo e, wak. Namudak ali God eke nunekumech nebenyi balan ali eke chunubu chupe sisahw.” ");
INSERT INTO apeB_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Ananu alman chohwalanamu Nikodimas uli douk ananu Farisi ali ananu umu amudak nebemi almam. Anan douk likuk nanak natik Jisas wab uli. Anudak Nikodimas naitak ali naklipu amudak nebemi nakli, ");
INSERT INTO apeB_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Aipo, kobi douk apakin lo seiwak God nakaguk Moses enyi nyaklimu, apak eke kobi kebes mukli enen elpen enyen douk nyenek yowenyi, wak. Apak eke mumnek enyenyin balan douk mudukemech umu echudak enyen nyenekech uli ali eke adakio mukli.” ");
INSERT INTO apeB_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","53","Ali hebemanu balan hakli, “Ati nyak douk chopuk enenyu echech Galili, waka? Nyugamu nyutalih balan nyetemu God ananik buk uli, umu eke nyudukemech umu, profet eke kobi ananu nitak Galili, wak.” ");
INSERT INTO apeB_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1"," (v53) Douk aliga chanatimaguk elpech chanak silisili atimu echechig wilag ali Jisas naltomu maunten chohwalanamu Oliv uli. ");
INSERT INTO apeB_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Wehluwih aglupil atul wata chopuk naitak nanamali God ananitu nebetali wilpat. Ali wolobaichi elpech chanaki chowachabal ali nabih nape nenek skulumech umu God ananin balan. ");
INSERT INTO apeB_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Ali amam douk henek skulumech umu lo uli hanu amam Farisi halawali onok almatok douk chogwatok kwasanukeh kipainali alman uli. Halawokwi ali haklipok kweyotu agundak douk chanatimaguk chowachabal chapemu. ");
INSERT INTO apeB_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Ali haklipu Jisas hakli, “Nebenyali Tisa, okudak kwonek marit uli almatok douk chogwatok kwonek yowenyimu kwasanukeh kipainali alman. ");
INSERT INTO apeB_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Enen apakin lo seiwak God nakaguk Moses enyi douk nyakli, almatok kunek enyudak-malili douk chukumok utabal atubal aliga kugak. Ali nyak douk nyakli malmu?” ");
INSERT INTO apeB_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Hasolikanu namudak umu hakli kadak nukli kobi chubo okudak almatok ali eke hukli anan douk nablo enyudak lo ali eke hunekumanu kwot. Wakuli balan douk wak nuklipam enen e ali nabih natau meyoh naku ananih hah nape nowemu enen balan atap. ");
INSERT INTO apeB_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Amam watak heyotu hape hasolikanu ali naitak neyotu iluh ali naklipam nakli, “Ipak meinali alman douk wo kwalowi nunek enen yowenyili e, anan douk wasik iken nulik nukumok susubeim utam.” ");
INSERT INTO apeB_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Naklipomuk namudak ali wata nabih natau atap nape nowemu enen balan alagun. ");
INSERT INTO apeB_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Douk hemnek enyudak balan ali hanatimaguk atunu ati hape hatukemanaguk hanak. Amam takwia halik ali echudak enech adakio chape chatukemanaguk chanak. Chanak aliga aliga ali chatukemaguk Jisas atunu napeik. Okudak almatok otuk douk wata kweyotu agundak Jisas natawomu. ");
INSERT INTO apeB_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Jisas naitak neyotu ali nasolikok nakli, “Nya, amudak almam amumu? Douk wak ananu niyotuk umu nunekumenyu balan umu enyudak yowenyi nyak nyeneken uli e?” ");
INSERT INTO apeB_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Ali kwaklipanu kwakli, “Nebenyali, wo kwalowi ananu niyotuk e, wak.” Ali naklipok nakli, “Yek chopuk namudak ati. Eke kobi inemenyu balan umu yowenyi nyak nyeneken uli, wak. Nyak wasik iken nyunak ali kobi wata nyunak nyunek enen yowenyi alagun, wak.” ");
INSERT INTO apeB_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Jisas wata naklipech enyudak balan chopuk nakli, “Yek yet douk lait. Yek douk yanaki yaglak apudak atap umu ihech elpech chunatulugun kalbu. Ali echebuk elpech douk chusuh yekin balan chugipechen uli, echech eke kobi chulahe yomotokweh umu agundak chunek yowenyimu, wak. Wakuli echech eke chupe chulahe lait taglak umu atugun, umu agundak chunek yopinyi atin umu. Ali echech douk eke chupe kalbu eheh nyumneh.” ");
INSERT INTO apeB_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Douk amam Farisi hemnek namudak ali haklipanu hakli, “Nyak nyaulal. Nyak douk nyak atinyu nyape nyaklipapu balan umu nyak yet. Namudak ali nyakin balan eke kobi mukli adulin, wak.” ");
INSERT INTO apeB_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Ali Jisas wata nebemom balan nakli, “Enyen douk adul umu yek otuwe yape yaklipepu balan umu yek yet, wakuli yekin balan douk adulin atin. Umu moneken, yek douk yadukemu agundak douk yapeli yaitak yanakumali gnanu agundak eke wata itak inak umu. Wakuli ipak douk wo pudukemu agundak yek yapeli yaitak yanakumali gnanu agundak eke wata inak umu e, wak. ");
INSERT INTO apeB_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Ipak isave pagipech apudak atapinyi pasin ali penek skelumu elpech. Ali yek wak inek skelumu enen elpen enyenyin pasin e, wak. ");
INSERT INTO apeB_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Wakuli sapos ikli inek skelumu enen elpen enyenyin pasin ele, yek deke inek skelumen duldul. Umu moneken, enyen douk wo yek otuwe inek skelumen e, wak. Aninu douk nakagas yek yanakili douk chopuk nane wonek moul. ");
INSERT INTO apeB_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Enen balan nyetemu ipakin lo uli douk nyakli namudak. Nyakli, ‘Sapos biam almam hiyagwleh hukli atin balan umu, orait amamin balan douk adulin.’ ");
INSERT INTO apeB_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Yek yanu yekinu Aninu douk wonek namobuk. Yek douk yeyagwleh yaklipepamu yek yet. Ali yekinu Aninu douk nakagas yek yanakili douk chopuk nane weyagwleh enyudak atin balan umu yek.” ");
INSERT INTO apeB_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Ali hasolikanu hakli, “Nyakinu aninu douk nape agnumu?” Ali Jisas nebemom balan nakli, “Ipak douk wo pudukemu yek o pudukemu yekinu Aninu e, wak. Douk pudukemu yek ele, yekinu Aninu chopuk deke pudukemanu.” ");
INSERT INTO apeB_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Jisas naklipech enyudak balan abudak nyultab nape nenek skulumech God ananin balan abali. Naklipechen numun banis agundak God ananitu nebetali wilpat tatawomu halakatimu amudak rum douk chobuk ofain mani nyakus umu. Nape naklipech ali wak anam almam hitak huhwanu hunak hunekumanu balan e, wak. Umu moneken, ananibu nyultab umu chonu nugak umu douk watak bunaki e. ");
INSERT INTO apeB_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Ali Jisas wata naklipech nakli, “Yek douk eke inakuk ali ipak eke pupe pulime. Eke pupe pulime wakuli ipakin yowenyi eke wata nyupe ali nyepu pugak. Pugak ali eke kobi punaku agundak yek inak ipemu, wak.” ");
INSERT INTO apeB_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Namudak ali echech Juda echechim nebemi heneyagwleh hakli, “Malmu namudak, umu nakli, ‘Ipak eke kobi punaku agundak douk yek inak ipemu?’ Ati naklimu eke anan yet nunobo nugak, waka?” ");
INSERT INTO apeB_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Ali Jisas wata naklipam nakli, “Ipak douk agundakipu elpech ali yek douk yapeli gani iluh uli. Ipak douk apudak atapipu, wakuli yek douk wak apudak atapiwe alman e, wak. ");
INSERT INTO apeB_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Douk namudak ali yek dakio yaklipepu yakli ipakin yowenyi eke wata nyupe ali eke pugak. Namudak ali sapos ipak kobi punek bilip pukli Yek Douk Seiwak Yape Namudak Ulimu, orait ipakin yowenyi douk eke wata nyupe ali ipak eke pugak.” ");
INSERT INTO apeB_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Douk chemnek namudak ali chasolikanu chakli, “Nyak meinyali?” Ali nebemech balan nakli, “Yek douk anudak alman douk nubuwakih wata susubati yaklipepamu. ");
INSERT INTO apeB_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Yek wolobainyi balan douk yakli iklipepamu yowenyi ipak peneken uli ali inemepu kwotog umu. Wakuli abudak nyultab douk eke wak. Nameitu eke iklipu ipak apudak atapipali elpech enyudak balan douk yemnek anudak nekege yanakili naklien uli. Anan douk nanubu aduligeinu ali duldulinu alman.” ");
INSERT INTO apeB_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Ali echech douk wo chudukemech umu anan nape naklipech umu ananinu Aninamu e, wak. ");
INSERT INTO apeB_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Namudak ali wata naklipech nakli, “Abudak nyultab putuk yek Anudak Alman douk yatoglu aduligeinyi elpen uli piyowaul lowag kruse abali, ababuk nyultab eke adakio pudukeme kalbu pukli Yek douk Seiwak Yape Namudak Uli. Ali ababuk nyultab eke adakio pudukemech umu ihenyumali yeneken uli douk wo gulamaguk yek otuwe ineken e, wak. Wakuli eke pudukemech pukli balan yaklipepeyen uli douk Aninu nagilape dakio yaklipepeyen. ");
INSERT INTO apeB_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Anudak nakagas yek yanakili douk nane wape eheh nyumneh wo nutukemeik yek otuwe ipeik e, wak. Umu moneken, eheh nyumneh yek yapemu yenek enyudak douk anan naklien uli.” ");
INSERT INTO apeB_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Jisas wata nape naklipech enyudak balan ati, ali wolobaichi chanubu chahwen chakli adulin. ");
INSERT INTO apeB_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Namudak ali Jisas wata naklipu echudak Juda douk chasuh ananin balan chakli adulin uli nakli, “Sapos ipak pusuh yekin balan dadag pugipechen umu, ipak adul eke punubu putoglu yekipali douk pagipech yek uli. ");
INSERT INTO apeB_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Putoglu yekipali ali eke pudukemu aduligeinyi balan. Ali enyudak aduligeinyi balan eke nyukwechihepau mu ipakin yowenyi ali pupe fri.” ");
INSERT INTO apeB_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Ali echech wata chebemanu balan chakli, “Apak douk Ebraham ananipu bahlagas. Ali douk wo kwalowi enech elpech chuwechikapu mupe munemech moul meyoh e, wak. Ali namudak nyaklimu, umu nyakli apak eke mutukwechih mupe frimu?” ");
INSERT INTO apeB_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Ali Jisas wata nebemech balan nakli, “Aduligu atugu yaklipepu. Chanatimaguk elpech douk chape chenek yowenyili, echech douk yowenyi nyowechikech dadag ali nyenekech chape chenemen moul meyoh meyoh. ");
INSERT INTO apeB_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Elpen douk nyape chakamamu kipainyi nyape nyenek moul meyoh anatu wilpat uli, enyen douk nyenek moul meyoh. Eke kobi nyunubu nyupe atabuk wilpat, wak. Wilpatinali ananinu nuganinu wasik eke nunubu nupe. ");
INSERT INTO apeB_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Namudak ali sapos yek God ananiwe Nuganinu ikwechihepaguk umu yowenyimu, orait ipak adul eke punubu putukwechih pupe fri. ");
INSERT INTO apeB_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Yek yadukemech umu, ipak douk adul Ebraham ananipu bahlagas. Wakuli douk pakli pubo yek igak. Umu moneken, yek yaklipepu-enyi balan douk wo puhwen e, wak. ");
INSERT INTO apeB_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Yek douk yaklipepu balan umu echudak yekinu Aninu nagilapemu. Wakuli ipak isave penek enyudak pasin douk palawen ipakinu aninaluli.” ");
INSERT INTO apeB_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Ali echech wata chebemanu balan chakli, “Apakinu aninu douk Ebraham.” Jisas nemnek ali nebemech balan nakli, “Sapos ipakinu aninu Ebraham ele, orait enenyi enen peneken uli deke nyuduk enyudak yopinyi seiwak Ebraham neneken uli atin. ");
INSERT INTO apeB_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Yek douk yaklipepu nyanatimaguk aduligeinyi balan douk yemnek God naklipe enyi. Wakuli ipak douk pakli pe igak. Ebraham douk wo nuneken ati e enyudakmali yowenyi, wak. ");
INSERT INTO apeB_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Enenyi enen peneken uli douk penek enyudak ipakinu aninu neneken uli.” Ali echech wata chaklipanu chakli, “Apakiyu mamaliyu wo wiyotu yegwih upalali e, wak. Apak douk atunu Aninu meyoh. Anan douk God. Apak douk manubu ananipu batowich.” ");
INSERT INTO apeB_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Ali wata naklipech nakli, “Sapos adul God nunubu ipakinu aninu ele, ipakip ulkwip deke punosuh yek. Umu moneken, yek douk yanali God wapeli yanaki ali nameitu douk enyudak yape agundak. Wo itak inamali yekin laik e, wak. Anan nekegeli dakio yanaki. ");
INSERT INTO apeB_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Ipakip ulkwip wo pulomu yekin balan kalbu ali pudukemen e umu moneken? Wo pudukemen e umu moneken, ipak douk pakli wak umu pumnek yekin balan ali pagah ipakigas aligas. ");
INSERT INTO apeB_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Ipak douk panubu ipakinu aninu Satan ananipu batowich. Ali douk panubu dodogowipu atipamu punek yowenyi douk anan oub baitakumen uli. Seiwak susubati watak bawagas umu nabo elpech chagak aliga nameitu. Enenyi enen adulinyi balan douk wo kwalowi nugipechen o niyagwlehen ati e, wak. Umu moneken, enyudak aduligeinyi pasin douk wak enen nyupenyunu e, wak meyoh. Abudak nyultab niyagwleh enen lohwotuhwin balan abali, enyebuk douk nanubu nagipech ananin pasin duldul. Umu moneken, anan douk napemu naulal ali nanubu bawagas umu agundak chaulal umu. ");
INSERT INTO apeB_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Yek douk yaklipepu aduligeinyi balan, wakuli douk namudak uli, ali dakio wo punek bilipume e, wak. ");
INSERT INTO apeB_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Ipak deke wasik enen elpen nyuklipemu enen yowenyi douk yeneken uli waka? Ati wak meyoh. Yek douk yaklipepu aduligeinyi balan, wakuli ipak douk wo kwalowi pusuh yekin balan pukli adulin e umu moneken? ");
INSERT INTO apeB_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Ihech God ananich elpech douk chemnek ananin balan ali chahwen dadag chagipechen. Wakuli ipak douk panubu wo God ananipu elpech e, wak meyoh. Namudak ali dakio wo pumneken ati e ananin balan.” ");
INSERT INTO apeB_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Ali echech Juda echechim nebemi hebemanu balan hakli, “Nubuwakih apak douk maklipenyu adulin balan. Nyak douk enenyu meyaluhinyu alman douk nyanaki Sameria uli. Ali douk enen sagabu nyapenyinyu.” ");
INSERT INTO apeB_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Ali nebemom balan nakli, “Yek sagabu wak enen nyupenyuwe e, wak. Wakuli yek douk yatuk yekinu Aninu ananin yeul nyakih ali ipak douk pabo yekin nyabih. ");
INSERT INTO apeB_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Yek douk wak ipemu ituk yekin yeul nyukih e, wak. Wakuli Ananu douk nohul elpech ali echech chatuk yekin yeul nyakih. Ali Anan douk eke nunemech nebenyi balan echebuk douk cheke agabus yek uli. ");
INSERT INTO apeB_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Aduligu atugu yaklipepu. Echebuk elpech douk chusuh yekin balan dadag chugipechen uli, echech eke kobi chugak, wak. Eke chunubu chupe eheh nyumneh.” ");
INSERT INTO apeB_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Ali echech Juda echechim nebemi wata haklipanu hakli, “Nameitu apak manubu madukemech umu nyak adul enen sagabu nyapenyinyu. Ebraham nanu amam profet douk seiwak hagak. Wakuli nyak nyakli, enyebuk elpen douk nyusuh nyakin balan dadag nyugipechen uli eke kobi nyugak, wak. Eke nyunubu nyupe eheh nyumneh. ");
INSERT INTO apeB_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Nyak nyakli nyak enenyu nebenyali nyabouk apakinu yamenu Ebraham nabihuk, waka? Anan douk seiwak nagak ali amam profet douk chopuk seiwak hagakuk. Ali nyak nyakli nyak douk nyanubu monekenyu alman?” ");
INSERT INTO apeB_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Ali Jisas wata nakli, “Sapos yek ipemu ituk yekin yeul nyukih ele, yek deke itoglu yeul wakeli alman meyoh. Wakuli Anudak natuk yekin yeul nyakih uli douk yekinu Aninu. Nanubu anudak douk ipak pakli puhwalanamu ipakinu God uli. ");
INSERT INTO apeB_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Ipak douk wo pudukemanu e, wak. Yek wasik yanubu yadukemanu kalbu. Namudak ali sapos yek ikli yek wo idukemanamu e, yek douk eke chuhwale yenek lo uli kobi ipak umu. Wakuli yek douk yanubu yadukemanu kalbu ali yagipechen kalbu ananin balan. ");
INSERT INTO apeB_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Ipakinu yamenu Ebraham douk nanubu nenehilawomu nakli nutik yekih nyumneh umu inaki apudak atap umu. Anan douk anatuliwemu agundak yanakumali ali douk nanubu nenehilau.” ");
INSERT INTO apeB_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Ali echech Juda echechim nebemi wata haklipanu hakli, “Ebraham aseiwak nagak ali nyak, nyakich yohleguh douk wata wolobaich chunak chutoglu 50-poleich e, watak. Wakuli nyak douk nyakli nyatik Ebraham, waka? Ati nyaulal.” ");
INSERT INTO apeB_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Ali Jisas nebemam balan nakli, “Aduligu atugu yaklipepu. Ebraham anan douk wata chunalali e ali Yek Douk Seiwak Yape Namudak uli.” ");
INSERT INTO apeB_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Douk nakli enyudak balan ali hohuli utabal umu hakli honu nugak. Wakuli nonobechuk ati natukemaguk agundak God ananitu nebetali wilpat tatawomu ali natoglu nanak. ");
INSERT INTO apeB_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Jisas nape nanak ali natik ananu nabes sechukanali alman. Anan douk seiwak mamakik kwonalali atimu nabes sechukanu nape namobuk. ");
INSERT INTO apeB_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Ali apak Jisas ananipu disaipel masalik Jisas makli, “Tisa, omuni nyeneken uli yowenyi nyenekanu ali anan dakio nabes sechukanu nolu ananik mamakik okwokih apahw ali kwonalali? Ananin yowenyi meyoh nyenekanu waka ananich mamechich echechin yowenyi nyenekanu?” ");
INSERT INTO apeB_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Douk amam hasolikanu namudak ali Jisas nakli, “Anan nabes wo sichukanamu yowenyi anan nanu ananich mamechich echechin e, wak. Anan douk nabes sechukanamu yek igilapu elpech umu agundak douk God deke wata nugabeyanamu. ");
INSERT INTO apeB_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Ali nameitu abudak nyultab douk kobi nyumnah umu, ali apak mupe munek God douk nakagasi yek yanakili ananin moul. Ali anabu eke bunakili nyultab eke kobi douk wab umu. Ali ababuk nyultab eke kobi enech elpech chupe chunek God ananin moul, wak. ");
INSERT INTO apeB_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Nameitu abudak nyultab yek yape apudak atap umu, yek yape kobi douk lait umu. Ali yek yenek wolobainyi yopinyi moul yopugunmu atugun umu wolobaichi chutiwe ali eke chugipeche munek enyudakmali atin yopinyi moul.” ");
INSERT INTO apeB_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Douk Jisas nakliyuk namudak ali nokuseh amnab naku alpigas nenekab batoglu kobi masil umu. Ali noluhul nalayak anudak nabes sechukanali ananis nabes. ");
INSERT INTO apeB_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Douk nalayakumanu ali naklipanu nakli, “Nyak nyunak wayag chohwalagamu Siloam uli ali nyichlokuh.” Bawogenyumu enyudak yeul Siloam douk chakli “Nakaganu nanak.” Douk nanak nechlokuh ali anan nabes wata satulugun ali natanomalimu wilpat. ");
INSERT INTO apeB_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Ali echudak douk chananu chape atugunmaluli chanu echebuk likuk chatulunamu nape nonotaul elpech umu chukanu echudak uli douk chatulunamu wata natulugun umu ali chakli, “Nani douk nabes sechukanu nape nonotaul elpech umu chukanu echudak uli o nani kipainali?” ");
INSERT INTO apeB_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Wakuli enech chakli, “Douk anan wo.” Ali enech chakli, “Anan wak. Anan douk kobi anudak nabes sechukanalimu.” Wakuli anan yet nanubu nakli, “Douk yek wo, nabes sechukeli.” ");
INSERT INTO apeB_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Naklipech namudak ali echech chasolikanu chakli, “Nyak nyenekas malmu nyakis nabes, umu nameitu wata nyatulugun umu?” ");
INSERT INTO apeB_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Nemnek ali nebemech balan nakli, “Ananu alman chohwalanamu Jisas uli nanaki nohul amnab nokusehab nenek masil ali nalayokume nabes. Anan nalayokume ali nekegemu inak ichlokuh agudak wayag Siloam. Ali yek yaitak yanak yechlokuh ali yekis nabes wata satulugun. Ali nameitu yek dakio yatulugun.” ");
INSERT INTO apeB_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Ali echech chasolikanu chakli, “Anudak Jisas douk nape agunmu?” Ali anan nakli, “Yek wo idukemanu e.” ");
INSERT INTO apeB_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Ali echech chalau anudak likuk nabes sechukanali chanak umu amam Farisi. ");
INSERT INTO apeB_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Ali ahudak nyumnah Jisas nokuseh amnab nagabe anudak nabes sechukanali ananis nabes umu douk Sabat, ahudak nyumnah douk lo nyakli kobi chunek enen moul umu. ");
INSERT INTO apeB_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Douk chalawanu chanak chatoglu gani amam Farisi hapemu ali amam hasolikanamu agundak anan nenek malmu ali dakio wata natulugun umu. Ali anan naklipam nakli, “Anan nokuseh amnab nenekab batoglu masil ali nalayokume yekis nabes. Nalayokume douk yanak yakwlupaluk ali wata yatulugun.” ");
INSERT INTO apeB_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Nakli namudak ali anam amam Farisi hakli, “Anudak nagabemanu nabes anudak alman uli, anan douk wo God nukaganu nunakili e, wak. Umu moneken, anan douk wo nugipech enyudak lo umu kobi enech chunek enen moul ahudak nyumnah Sabat umu e.” Wakuli anam hakli, “Sapos anan douk ananu napemu nenek yowenyi ulile, anan douk deke kobi nunek enyudakmali God atunu neneken uli moul, wak.” Douk heyagwleh namudak ali anam hasuh enen tinytin ali anam hasuh enen. ");
INSERT INTO apeB_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Ali amam Farisi wata chopuk hagamu hasolik anudak likuk nabes sechukanali hakli, “Nyak nyakliyanu malmu anudak nagabemenyu nabes uli? Anan douk ananu yopunali alman waka ananu yowenali?” Wakuli anan nebemom balan nakli, “Anan douk ananu profet.” ");
INSERT INTO apeB_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Anan nakli namudak, wakuli amudak nebemi Juda douk wo huklimu hunek bilip umu agundak likuk anan douk nabes sechukanu ali nameitu wata natulugun umu e, wak. Ali amam henekumech balan ananich mamechich chanaki. ");
INSERT INTO apeB_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Douk chanaki ali hasolikech hakli, “Anudak douk ipakinu nuganinu? Ali chopuk anan douk seiwak mamakik kwonalali ali nabes sechukanu nape namudak ati? Ali anan douk nenek moneken, umu nameitu wata natulugun umu?” ");
INSERT INTO apeB_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Wakuli ananich mamechich chakli, “Adul, anudak douk ohwakinu nuganinu. Ali ababuk nyultab mamakik kwonalali atimu anan wo nutulugun e, wak.” ");
INSERT INTO apeB_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","“Wakuli ohwak douk wo wudukemech e umu anan nenek malmu ali dakio wata natulugun umu. Chopuk ohwak douk wo wudukemu anudak nagapechumanu nabes uli e, wak. Anan douk ayopunali. Pusalik anan yet nuklipepu!” ");
INSERT INTO apeB_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Echech Juda echechim nebemi douk ahowechik balan, umu hakli meichi elpech chukli Jisas anan douk God natalihanu ali nakaganu nanamali nunolau elpech ulimu, amam eke kobi hukutuwechuk chuwich ati atudak echech Juda chape cheyagwleh balan atali wilpat, wak. ");
INSERT INTO apeB_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Douk namudak ali anudak nabes sechukanali ananich mamechich elgeich ali chakli, “Anan douk ayopunali. Pusalik anan yet nuklipepu.” ");
INSERT INTO apeB_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Ali amam hohwalu anudak nabes sechukanali anah alagun ali hasolikanu hakli, “Nyak nyulimu God ananin yeul umu kadak nyak eke nyukli adulin atin balan! Apak madukemech umu, anudak alman nagabemenyu nabes uli douk ananu nenek enenyi enen yowenyili.” ");
INSERT INTO apeB_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Ali anan nebemom balan nakli, “Yek wo idukemech e. Anan douk ananu yopunali waka ananu nenek yowenyili. Wakuli atin yek yadukemen uli douk Enyudak. Seiwak nabes sechuke, wakuli nameitu wata yatulugun.” ");
INSERT INTO apeB_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Wakuli amam nebemi Juda hasolikanu hakli, “Anan nenekenyu malmu ali dakio nagabemenyu nabes nyatulugun?” ");
INSERT INTO apeB_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Ali anan nebemom balan nakli, “Yek douk adukwechuk yaklipepu, wakuli ipak douk pakli wak umu pumnek. Ipak pakli pumnek wolobaih atih umu moneken? Ati ipak douk chopuk pakli pugipechanu putoglu ananipu disaipel, waka?” ");
INSERT INTO apeB_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Wakuli amam haklipanu enen enen hakli, “Nyak douk anabuk nagabemenyu nabes uli ananinyu disaipel. Apak wak. Apak douk Moses ananipu disaipel. ");
INSERT INTO apeB_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Apak madukemech umu seiwak God douk nanu Moses heyagwleh. Ali nameitu anudak Jisas, apak douk wo kwalowi mwudukemech umu agundak anan nanakumali e, wak.” ");
INSERT INTO apeB_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Wakuli anudak douk seiwak nabes sechukanali nakli, “Enyudak douk nyanubu enen sik dodogowinyi moul! Anan nagabeme yekis nabes, wakuli ipak douk wo pudukemech umu agundak anan napeli ali naitak nanakumali e, wak. ");
INSERT INTO apeB_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Apak madukemech umu, God eke kobi numnek echudak douk chenek enenyi enen yowenyi uli chusalikanamu, wak. Anan eke numnek echebuk douk chenek lotumanu ali chagipech ananin laik uli atich. ");
INSERT INTO apeB_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Seiwak aliga aliga nameitu, apak douk wo kwalowi muti mumnek umu enen elpen nyagabemen nabes kipainyi, douk mamakik kwenylali atimu sechuken sape namudak ali enyen wata nyutulugun e, wak. ");
INSERT INTO apeB_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Ali anudak alman douk kobi nunali God hupeli ali nukaganu nunakile, anan deke kobi nunek enen enyudakmali moul, wak.” ");
INSERT INTO apeB_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Wakuli amam nyihihichim ali haklipanu hakli, “Likuk wata mamakik kwenyalali ati nyenek enenyi enen yowenyi aliga nameitu ali nyakli nyupe nyunek skulumapamu bawogenyumu balan umu God ananin balan apak?” Ali amam hahwanu howachanu natoglu aduk atudak echech Juda chowachabal chape cheyagwleh balan atali wilpat. ");
INSERT INTO apeB_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Jisas nape ali nemnek umu agundak echech Juda echechim nebemi hasuh anudak likuk nabes sechukanu uli ali howachanu natoglu aduk umu. Nemnek ali naitak natimanu nanak. Douk nanak nogwatanu ali nasolikanu nakli, “Nyak nyenek bilip umu Anudak Alman douk natoglu aduligeinyi elpen uli o wak?” ");
INSERT INTO apeB_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Ali anan nebemanu balan nakli, “Nebenyali, Anudak Alman natoglu aduligeinyi elpen uli douk meinali? Yakli nyuklipemanu ali yek eke inek bilipumanu.” ");
INSERT INTO apeB_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Ali Jisas naklipanu nakli, “Nyak douk anyatulunu. Anudak alman, anan douk nameitu nanenyu pape peyagwleh.” ");
INSERT INTO apeB_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Douk Jisas nakli namudak ali anudak alman nakli, “Diginyali, yek yenek bilip umu nyak.” Ali nabih noduk ohlubus natau halakatimu Jisas natuk ananin yeul nyakih. ");
INSERT INTO apeB_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Ali Jisas naklipanu nakli, “Yek yanaki apudak atap umu inek skelumu elpech ali iyaisech. Yanakumali echebuk douk nabes sechukech wo chudukemu God uli e wata chutulugun, ali echebuk chatulugun chadukemu God uli wata nabes sichukech.” ");
INSERT INTO apeB_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Jisas nakli namudak ali anam Farisi douk hanonu heyotu agnabuk uli hasolikanu hakli, “Nyak nyakli apak douk chopuk nabes sechukopu, waka?” ");
INSERT INTO apeB_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Ali Jisas naklipam nakli, “Sapos ipak nabes sichukepu ele, God eke wata nugabeyepu ali ipak eke kobi enen yowenyi nyupenyipu, wak. Wakuli ipak douk pakli ipak patulugun. Douk namudak ali balan umu ipakin yowenyi douk watak nyapenyipu.” ");
INSERT INTO apeB_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Jisas naklipech nakli, “Aduligu atugu yaklipepu, alman douk wo nuwichi dua asudak sipsip cheyotu asi banis, wakuli nusalpaki nebik nuwichili douk wo yopunali alman e, wak. Anan douk naku aluh atuh uli. ");
INSERT INTO apeB_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Wakuli alman douk nuwich witeisumu meyoh asudak sipsipis banis uli, anan douk adul nape neyoh echudak sipsip uli. ");
INSERT INTO apeB_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Abudak nyultab neyoh sipsip uli nukli nunaki abali, orait anudak ananu nape nenek was umu dua asudak banis uli eke nitak nijikumanu dua. Nijikagunmanu ali eke nuwich nusolik echech atin ati sipsip echechiguh yeguh. Nusolikech douk chumnek ananigu nigu ali eke nulikech nulawech chutoglu aduk. ");
INSERT INTO apeB_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Douk nulau chanatimaguk ananich sipsip chutoglu adukis umu banis nulikech ali echech eke chugimanu chunak. Umu moneken, echech douk chadukemu ananigu nigu. ");
INSERT INTO apeB_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Kipainali alman eke kobi chugipechanu, wak. Umu moneken, echech douk wo chudukemu ananigu nigu e. Namudak ali douk eke elgeich ali eke chulhwas-umanaguk.” ");
INSERT INTO apeB_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Jisas naklipech enyudak woblen balan, wakuli echech douk wo chudukemu bawogenyumu e, wak. ");
INSERT INTO apeB_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Echech douk wo chudukemu bawogenyumu e enyudak woblen balan ali Jisas wata naklipech nakli, “Aduligu atugu yaklipepu. Yek yet douk yanubu enyudak dua douk sipsip chunak chuwichen ali chuwich chupe numun banis umu. ");
INSERT INTO apeB_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Hanatimaguk almam douk likuk halik hanaki ali yek douk nameitu adakio yanakili, amabuk almam douk hakwu olugwih atih uli. Wakuli sipsip douk wo kwalowi chumnek amamin balan ali chugipecham ati e, wak. ");
INSERT INTO apeB_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Yek douk yanubu dua. Enyebuk elpen douk nyuwich enyudak dua ali nyuwich numun banis uli, enyen eke nyuwich God nunolawen ali eke wata nyutanamali nyupe kalbu. Ali eke nyunek witoglu asudak banis nyunak nyunatimu kakwich umu nyichah uli. ");
INSERT INTO apeB_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Haku olugwih uli douk hanakumali hukumech olugwih, hech ali hisito-soteyech. Wakuli yek douk yanakumali igakomech chunubu chupe kalbu ali chunehilau eheh nyumneh kobi hutuh. ");
INSERT INTO apeB_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Yek douk yanubu yopuweli alman douk yape yeyoh sipsip uli. Ali yek douk yakli wasik umu igak umu igakamu echech sipsip chupe kalbu. ");
INSERT INTO apeB_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Alman douk chatalunomu nupe niyoh sipsip uli, anabuk almam douk wo nunubu nunoglemu echudak sipsip uli e, wak. Anan douk nenek moul umu nupe niyohech meyoh. Ali abudak nyultab nukli nutik anatu wanalitu nubat tunakumali, anan eke nutukemech chiyotuk nulhwas. Ali atudak nubat eke tunaki tuhiyahech aliga tusuh enech ali enech eke chulhwas chunak atin atiyuk. ");
INSERT INTO apeB_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Anudak alman nalhwas umu moneken, anan douk nenek moulomu utabal atubal uli. Ananim ulkum wo munubu mulomu nukli nugakamu echudak sipsip e, wak. ");
INSERT INTO apeB_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Yek douk yanubu yopuweli alman yeyah sipsip uli. Yek douk yadukemech kalbu yekich sipsip ali echech chopuk chadukemu yek kalbu. ");
INSERT INTO apeB_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Kobi douk Aninu nadukemu yek ali yek yadukemu anan umu. Ali yek douk yakli wasik umu igak umu igakamu yekich sipsip chupe kalbu. ");
INSERT INTO apeB_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Echudak enech elpech kobi yekich sipsipumali douk chopuk yekich. Wakuli echech douk chapeik lougun wo chunu echudak sipsip nameitu cheyotu asudak yekis banis uli chiyotu e, wak. Ali yek douk chopuk imas ilawech chunaki ali eke chumnek yekin balan. Ali douk eke chunu echudak enech chalik uli chutoglu atich chiyotu atus banis ali yek otuwe ipe iyohech. ");
INSERT INTO apeB_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Yekinu Aninu douk nanubu ulkum manosuh yek. Umu moneken, yek douk yakli wasik umu che igak igakamu elpech ali eke wata chopuk itaki ipe. ");
INSERT INTO apeB_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Eke kobi enen elpen nyubo yek igak umu enyenyin laik, wak. Yek eke igak umu yekin laik. God neke namba umu inek enyudak ali douk eke ineken. Neke namba umu igak umu ali chopuk neke namba umu eke wata nugakome itaki ipemu.” ");
INSERT INTO apeB_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Douk Jisas naklipech enyudak balan ali echech Juda echechim nebemi wata chopuk hanodiyogulmu henek biob lainab. ");
INSERT INTO apeB_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Wolobaimi hakli namudak. Hakli, “Enen sagabu nyapenyunu ali nanubu lahahainu. Ipak pemnek ananin balan umu moneken?” ");
INSERT INTO apeB_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Ali anam hakli, “Ananu sagabu nyapenyunali deke kobi niyagwleh namudak, wak. Ali sagabu deke nyuhul ananu nabes sechukanali ananis nabes wata nutulugun malmu? Ati wak.” ");
INSERT INTO apeB_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Abudak nyultab umu echech Juda chuwachabal chupe Jerusalem ali chunek woligun umu ulkwip pulomu seiwak echechich popech yamech wata chopuk chagabe tempel chawich chenek lotumu God umu douk abanak batogloli. Ali ababuk nyultab chowachabal abali douk nyuglusibali nyultab. ");
INSERT INTO apeB_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Ali Jisas nanak nawich numun God ananitu nebetali wilpat tatawomu ali nape nalahe nanak ohwudak nebehwi yadoh douk chohwaloh umu Solomon ananihw yadoh uli. ");
INSERT INTO apeB_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Ali echech Juda echechim nebemi hanaki howachabal halihi-halihanu ali hasolikanu hakli, “Banubu meibali nyultab nyak eke nyuklipapamu nyak nyanubu meinyali alman umu? Sapos nyak Krais douk God natalihenyu ali nekegenyu nyanamali nyunalau elpech ulimu, orait nameitu apak makli nyunubu nyuklipapu duldul umu apak wata mudukemech.” ");
INSERT INTO apeB_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Ali Jisas nebemom balan nakli, “Yek douk ayaklipepu, wakuli ipak douk wo pusuh yekin balan pukli adulin e, wak. Ihen moul douk yohul yekinu Aninu ananin yeul yenyemu ali yeneken nyatoglu patulin uli, enyen douk nyanubu nyagilapepamu agundak yek douk meiweli alman umu. ");
INSERT INTO apeB_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Wakuli ipak douk wo pusuh yekin balan pukli adulin e, wak. Umu moneken, ipak douk wo yekipu sipsip e. ");
INSERT INTO apeB_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Yekich sipsip douk chadukemu yekigu nigu. Yek douk chopuk yadukemu echech kalbu ali douk chagipech yek. ");
INSERT INTO apeB_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Chagipeche ali eke igakomech umu kobi chunubu chunak chuwichuk, wak. Yek eke igakomech umu chunubu chupe kalbu eheh nyumneh. Ali eke kobi enen elpen nyunaki nyutuliweyech yekis wis, wak meyoh. ");
INSERT INTO apeB_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Yekinu Aninu douk nekeyech uli, anan douk nebenali nabouk ihechumali enechi enech echudak chabihuk. Ali douk eke kobi enen elpen nyunaki nyutuluneyech ananis wis, wak meyoh. ");
INSERT INTO apeB_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Yek yanu Aninu douk wanubu watoglu atunu meyoh.” ");
INSERT INTO apeB_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Douk amam Juda hemnek namudak ali wata chopuk hohuli utabal umu hakli honu nugak. ");
INSERT INTO apeB_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Ali Jisas wata naklipam nakli, “Yekinu Aninu naklipemu inek wolobainyi anan atunu neneken uli moul ali douk yeneken nyatoglu ipak patulin. Ali ipak ulkwip polomu meinyi dakinyi moul douk yek yeneken ali ipak dakio pakli pukume utabal umu?” ");
INSERT INTO apeB_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Ali amam wata hebemanu balan hakli, “Apak douk wo muklimu mukumenyu utabal umu agundak nyenek enyudak God atunu neneken uli moul nyatoglomu e, wak. Wakuli makli menyomu agundak nyenekanu enen enen God umu. Nyak douk elpen meyoh, wakuli nyakli nyak God.” ");
INSERT INTO apeB_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Ali Jisas wata nebemom balan nakli, “Enen balan nyetemu ipakin lo uli douk nyakli namudak. God nakli, ‘Ipak douk god.’ ");
INSERT INTO apeB_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Echudak elpech seiwak God nekechi ananin balan uli, anan douk nohwalech god. Ali apak madukemech umu, God ananin balan nyetemu ananik buk uli douk nyanubu adulin atinyi. Wo nyulal ati e. ");
INSERT INTO apeB_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Ali yek douk Aninu God meyoh natalihe yape ananiwe otuwe ali nekege yanamali apudak atap. Yabihi ali yaklipepu yakli yek douk God ananiwe nuganinu. Namudak ali ipak pakli yek yape yenekanu enen enen God umu moneken? Umu agundak yakli yek douk ananiwe Nuganinomu? ");
INSERT INTO apeB_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Sapos yek kobi inek yekinu Aninu God ananin moul umu, orait ipak douk wasik kobi pusuh yekin balan pukli adulin, wak. ");
INSERT INTO apeB_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Wakuli yek douk adul yenek ananin moul. Ali sapos ipak pukli wak umu punek bilip umu yek umu agundak yakli yek douk God nekege yanakumali, orait ipak douk patuliwe yenek wolobainyi God atunu neneken uli moul nyatoglu ali douk deke punek bilipume. Punek namudak umu ipak punubu pudukemech umu Aninu nape yek ali yek yape anan.” ");
INSERT INTO apeB_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Douk nakli namudak ali amam wata hakli huhwanu hunak huwechikanu nupe haus kalabus. Wakuli natukemomuk nanak. ");
INSERT INTO apeB_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Natukemomuk nanak ali nanak nabih nablo wolub Jordan nanamu agundak douk likuk Jon nenek baptaisumech uli nape nenek baptaisumech umu. Nanak ali nape agnabuk. ");
INSERT INTO apeB_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Ali wolobaichi elpech chanaki agundak anan napemu ali chakli, “Adul wo. Jon anan douk wo nunek enen God atunu neneken uli moul e, wak. Wakuli ihenyumali balan anan neyagwlehen umu anudak alman uli douk nyanubu nyatoglu adulin atin.” ");
INSERT INTO apeB_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Ali wolobaichi elpech chape agnabuk uli chenek bilip umu Jisas chakli anan douk adul Krais. ");
INSERT INTO apeB_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Ananu alman chohwalanamu Lasarus uli douk agudak ganu. Anan nanu ananinyu biou mehwoliyu, Maria kwanu okwokwik sakwik Mata douk chape abuldak wabul Betani. ");
INSERT INTO apeB_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Ali Maria douk okudak almatok likuk kwenyukul sanda Jisas ananiluh yaliluh ali wata kwaku okwokwim boglom kwanubloluh-umanu uli. Ali douk okwokwinu mehuninu Lasarus agudak ganu. ");
INSERT INTO apeB_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Ali ananiyu mehwoliyu wonek balan nyanamu Jisas wakli, “Diginyali, nyakinu elpenyinu douk nyak ulkum manohwanaluli douk agudak ganu.” ");
INSERT INTO apeB_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Douk Jisas nemnek namudak ali nakli, “Bawogas umu agudak sik ganamu douk wo gonomu nunubu nugak e, wak. Agag douk ganamu elpech chutik God ananin strong ali chutuk anan nunu yek ananiwe Nuganinu ohwakich yeguh chukih.” ");
INSERT INTO apeB_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Jisas anan douk nanubu ulkum manosuh Mata kwanu okwokwik owawik Maria wanu Lasaras. ");
INSERT INTO apeB_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Anan douk nemnek umu agundak Lasaras agudak ganamu, wakuli nape bieh nyumneh alagun. Nape agnabuk douk anan napemu. ");
INSERT INTO apeB_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Douk nape bieh nyumneh hanak hadiyuk ali naklipu ananipu disaipel nakli, “Apak wata mutanamu munamu Judia.” ");
INSERT INTO apeB_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Douk apak memnek ali makli, “Nebenyali Tisa, nubuwakih ati echech Juda chakli chukumenyu utabal. Wakuli nameitu wata chopuk nyakli nyunak agnabuk, waka?” ");
INSERT INTO apeB_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Wakuli Jisas nebemopu balan nakli, “Anah nyumnah douk 12-polein aua umu wah hutawomu. Ali douk enen elpen nyukli nyulahe nyumnah wah hutau abali nyultab umu, enyen eke kobi nyunotukwilep nyubih nyugoul, wak. Umu moneken, nyumnah wah hutawomu enyen eke nyutulugun kalbu ali eke kobi nyugoul, wak. ");
INSERT INTO apeB_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Wakuli enyen nyukli nyulahe wab umu, enyen douk eke nyunotukwilep ali nyubih nyugoul. Umu moneken, agagun douk yomotokweh ali enyen eke kobi nyunatulugun kalbu.” ");
INSERT INTO apeB_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Douk Jisas nakliyuk namudak ali nakli, “Apakinu elpenyinu Lasaras douk anechuh. Ali yek eke wata inak ibalunu.” ");
INSERT INTO apeB_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Wakuli apak ananipu disaipel makli, “Diginyali, sapos anan douk anagu agudak ganu nechuh umu, anan douk eke wata yopunu.” ");
INSERT INTO apeB_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Jisas douk naklimu agundak Lasaras nanubu nagak umu. Wakuli apak ananipu disaipel memnek ali makli anan naklimu adulibus yobus sanu ali nechuh. ");
INSERT INTO apeB_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Namudak ali Jisas nowolehumapu balan nakli, “Lasaras douk anagak. ");
INSERT INTO apeB_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Wakuli yek ulkum molomu ipak ali yenehilau. Umu moneken anan nagak umu, yek douk wo inak itoglomech e, wak. Yenehilaumu moneken, apak eke munak mutulich ali ipak eke putik enen moul eke yek ineken uli ali eke punek bilip pukli yekin balan douk adulin. Ali nameitu, ipak douk yowi munak.” ");
INSERT INTO apeB_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Echech Judia douk chakli chubo Jisas nugak. Namudak ali Tomas douk chohwalanamu Didimas uli naklipu apak anapu disaipel nakli, “Kitak munamu Diginali munak. Munak umu kadak chukli chubo anan nugak umu, echech douk chopuk chubo apak munonu mugak ahudak atuh.” ");
INSERT INTO apeB_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Douk Jisas nanak natoglu halakatimu Betani ali anan nemnek umu Lasaras douk achanugamanu nalaguk iwagu 4-poleih nyumneh. ");
INSERT INTO apeB_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Abuldak wabul Betani douk wo blupeik lougun umu Jerusalem e, wak. Blapeli halakati, kobi 3 kilomita umu. ");
INSERT INTO apeB_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Ali wolobaichi Juda chanaki chanu Maria uli Mata chapemu chugabemou owowiluh apaluh umu agundak owowinu mehuninu nagak umu. ");
INSERT INTO apeB_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Douk Mata kwomnek umu agundak Jisas nape nanakumali ali kwaitak kwanak umu kugwatonu yah. Wakuli Maria douk kwapeik wilpat. ");
INSERT INTO apeB_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Douk Mata kwanak ali kwaklipu Jisas kwakli, “Diginyali, sapos nyak nyupe agundak ele, yekinu mehuninu deke kobi nugak, wak! ");
INSERT INTO apeB_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Wakuli nameitu douk chopuk yadukemech umu, monekech echebuk douk nyak nyunek beten nyusolik God umu nukenyeyech uli, anan eke nukenyeyech.” ");
INSERT INTO apeB_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Ali Jisas naklipok nakli, “Nyakinu mehuninu eke wata nitaki.” ");
INSERT INTO apeB_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Mata kwomnek ali kwaklipanu kwakli, “Yek yadukemech, ahabuk hugikuk uli nyumnah chanatimaguk chagak uli wata chitakumali, anan douk eke wata nitaki.” ");
INSERT INTO apeB_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Ali Jisas naklipok nakli, “Douk yek otuwe nebeweli ali dodogowiwemu ihul chagak uli wata chitak chupe kalbamu. Ali echebuk douk chasuh yekin balan chagipechen ali chagak uli, echech douk eke wata chitak ali chunubu chupe kalbu. ");
INSERT INTO apeB_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Ali echebuk douk wata chupe ali chusuh yekin balan chugipechen uli, echech eke kobi chugak, wak.” Ali anan nasolikok nakli, “Nyak nyenek bilip nyakli enyudak balan douk adulin o wak?” ");
INSERT INTO apeB_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Ali Mata kwakli, “Adul, Diginyali. Yek douk yenek bilip yakli nyak douk God ananinyu Nuganinu. Yakli nyak Krais, douk God natalihenyu ali nekegenyu nyanamali nyunalau elpech uli.” ");
INSERT INTO apeB_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Douk Mata kwakliyuk enyudak balan ali wata kwatanamu kwanak kwohwalu okwokwik owawik Maria. Douk kwanaki ali kwabomok chokweh kwakli, “Apakinu Nebenali Tisa douk nanaki ali nakli nyak nyunak nyutulunu.” ");
INSERT INTO apeB_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Douk Maria kwomnek namudak ali wisnabul kwaitak kwanak umu kutik Jisas. ");
INSERT INTO apeB_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Anan Jisas douk wata nunak nutoglu wabul e, watak. Wata neyotu yah agundak douk Mata kwalik kwanak kwogwatanamu. ");
INSERT INTO apeB_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Enech Juda douk chanu Maria chape okwokwitu wilpat umu chugabemok apahw. Douk chatik umu okwok wisnabul kwaitak kwanak umu ali chakli okwok eke kwanamu iwagamu kupe kuleh. Namudak ali chaitak chagipechok chanak. ");
INSERT INTO apeB_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Douk Maria kwanak kwatoglu agundak Jisas natoglu napemu ali kwatulunu. Kwatulunu ali kwanak kwabih kwoduk ohlubus halakatimu anan ali kwakli, “Diginyali, sapos nyak nyupe agundak ele, yekinu mehuninu deke kobi nugak, wak.” ");
INSERT INTO apeB_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Jisas natuluk umu kwoleh ali echech chanamokwili Juda douk chopuk chagakomok cheleh. Natik namudak ali ananihw apahw hwanubu yowehw ali nenelekech. Ali anan chopuk nakli nunech chuleh. ");
INSERT INTO apeB_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Ali douk nasolikech nakli, “Ipak panak panugamanu agnumu?” Ali echech chakli, “Diginyali, nyak yowi tik.” ");
INSERT INTO apeB_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Douk chanak ali Jisas neleh. ");
INSERT INTO apeB_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Echudak Juda chatik umu agundak Jisas neleh umu ali chakli, “Ipak tik, ananim ulkum douk manubu manosuh Lasaras.” ");
INSERT INTO apeB_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Wakuli enech chakli, “Anan douk nagabe ananu nabes sechukanali ali anan wata natulugun. Ali namudak malmu, umu anan wo nugakamu Lasaras umu kobi nugak umu e?” ");
INSERT INTO apeB_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Jisas ananihw apahw wata chopuk hwanubu yoweh nenelek echudak elpech ali nanubu nanak aliga nanak natoglomu iwagu. Agudak iwagu douk chanugu chawich onok bulbuduk chenek hulupihw. Ali nuguhigamu douk chahinu anam utam chanak chechopam umu chugahogu. ");
INSERT INTO apeB_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Ali Jisas nakli, “Hinoguk amudak utam douk mataku nuguhigamu iwagaluli.” Wakuli anudak nagak uli ananik mehukik Mata kwakli, “Diginyali, apak manugamanu nalaguk nubatih nyumneh ali anan douk eke aneih.” ");
INSERT INTO apeB_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Wakuli Jisas naklipok nakli, “Yek douk adukwechuk yaklipenyu. Sapos nyak nyusuh yekin balan nyukli adulin umu, nyak douk eke nyutik agundak God nanubu dodogowinu atunamu.” ");
INSERT INTO apeB_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Namudak ali echech chanak chahinoguk amudak utam. Ali Jisas nanigu natik iluh ali nakli, “Aninu, yek douk yenek tenkyumenyu. Umu moneken, nyak douk anyemnek yekin beten. ");
INSERT INTO apeB_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Yek ayadukemech umu, wihluwehlu nyak isave nyemneke umu agundak yenek beten yohwalenyamu. Wakuli yek ulkum molomu echudak cheyotu agundak uli, ali dakio yakli namudak. Umu yakli echech chutik enyudak moul douk yek eke ineken uli ali chunek bilip chukli yek douk nyak nyekegeli ali dakio yanaki.” ");
INSERT INTO apeB_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Douk nakliyuk enyudak ali nohwalu nebegun nakli, “Lasaras, aliga kitak togloli!” ");
INSERT INTO apeB_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Ali anudak nagak uli nanubu naitak natogloli. Ananich loguh uli ayas douk chechlehech luseh. Ananigu wahegu chopuk chechlehagu anah lupah. Ali Jisas naklipech nakli, “Ipak pukwechihuk luseh ali anan nunak.” ");
INSERT INTO apeB_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Wolobaichi Juda douk chanaki chanu Maria chapemu chugabemok apahw. Echech douk chatik enyudak Jisas neneken uli moul ali chanubu chenek bilipumanu. ");
INSERT INTO apeB_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Wakuli enech chatanamu chanak chaklipu amam Farisi umu enyudak Jisas neneken uli. ");
INSERT INTO apeB_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Chaklipam ali amam hanu nebemi pris hohwalu amudak anam nebemi Juda douk hape hasuh kwotog uli hanaki. Hanaki hape atugun ali hakli, “Anudak alman douk nenek wolobainyi God atunu neneken uli moul. Ali apak douk eke munekanu malmu? ");
INSERT INTO apeB_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Apak mukli mukutuwanaguk nupe nunek enyudakmali atin umu, chunatimaguk elpech eke chunek bilip umu anan atunu. Namudak ali echech Rom echechim nebemi eke hunaki hichicheh atudak God ananitu nebetali wilpat ali eke hubo echudak chunatimaguk apakich elpech chugak.” ");
INSERT INTO apeB_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Ali anudak alman chohwalanamu Kaiafas uli douk nanom hape. Anan douk nanubu nebenali pris umu enyebuk yohlegul. Anan nemnek ali naklipam nakli, “Ipak douk wo kwalowi pudukemu enech echudak e, wak. ");
INSERT INTO apeB_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Eke padukemech waka wak? Enyen douk wosik umu mubo atunu alman nugak ali nugakamu echudak chunatimaguk elpech umu chupe kalbu. Douk wak umu, apak munatimaguk Juda eke mugak mutuh.” ");
INSERT INTO apeB_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Enyudak balan douk wo anan meyoh nukliyen e, wak. Anan douk nanubu nebenali pris umu enyebuk yohlegul. Namudak ali God nanahul nakli enyudak balan kobi amam profet heyagwleh umu. Nakliyen umu Jisas douk eke nugak umu nugakamu echech Juda. ");
INSERT INTO apeB_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Ali chopuk anan eke kobi nugak umu nugakamu echech Juda atich umu chupe kalbu, wak. Anan eke nugak umu nulau chanatimaguk God ananich batowich douk chanak chape sili sililub walub uli umu chunubu chutoglu atich elpech. ");
INSERT INTO apeB_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Ali hanubu ahabuk nyumnah echech Juda echechim nebemi ahape habo balan umu hulimu anah yah umu hubo Jisas nugak. ");
INSERT INTO apeB_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Douk namudak ali agundak echech Juda chapemu, Jisas douk wo nulahe yopugunmu ati e, wak. Ali naitak natukemaguk ablabuk wabul nanamu anagun douk gnape halakatimu wohigunmu elpech wak umu. Nanamu anabul wabul chohwalabul umu Ifrem uli ali nanu apak ananipu disaipel mape agnabuk. ");
INSERT INTO apeB_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Ali ahudak nyumnah umu echech Juda chunek echechigun nebeguni woligun Pasova umu douk ahanaki halakati. Ali wolobaichi elpech chapeli wolobailubi walub uli chaitak chaltomu Jerusalem. Chanak umu chugipech echechin lo chunogapech echech yet umu God nutulich nukli wosik ayopich ali adakio chunak chuwak agundak woligun. ");
INSERT INTO apeB_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Douk wolobaichi elpech chanaki ali chape chulimu Jisas. Echech cheyotu numun God ananitu wilpat ali echech yet chape cheneyagwleh chakli, “Ipak pakli malmu? Anan eke nunakimu agundak woligun waka wak?” ");
INSERT INTO apeB_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Ali amam nebemi pris hanu amam Farisi douk haklipech umu sapos enen elpen nyudukemech umu agundak Jisas nanak napemu, enyen imas nyunaki nyuklipam umu amam hunak huhwanu huwechikanu. ");
INSERT INTO apeB_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Douk 6-poleih nyumneh watak hapemu chunek agundak nebeguni woligun Pasova, ali Jisas naitak nanamu Betani. Betani douk Lasaras ananibul wabul. Anudak douk likuk nagak ali Jisas wata nanahul naitak nape uli. ");
INSERT INTO apeB_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Jisas nanak nape agnabuk ali echech chenekumanu anagun woligun. Mata kwape kwognahu ali Lasaras uli Jisas douk hanu echudak chanakimu chunu Jisas chuwak woligun uli chape chalihi chalih tebol. ");
INSERT INTO apeB_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Ali Maria kwaitak kwohul enen duduken sanda yeulinyumu nad douk chatalin nebebali utabal uli ali kwanak kwenyukwlen kwape kwenyayok Jisas ananiluh yaliluh. Kwenyuklen iyuh ali wata kwaku okwokwim boglom kwape kwanubloluhuk. Ali elpech chape numun wilpat uli chemnek enyudak sanda nyeih kalbu. ");
INSERT INTO apeB_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Ali ananu Jisas ananinamu disaipel chohwalanamu Judas uli douk nanech chape agnabuk. Ananibul wabul douk Kariot. Ali anan douk eke nugilapu Jisas ananim birua anan Jisas ali amam huhwanu hunak honu nugak uli. Douk anudak Judas natik namudak ali nakli, ");
INSERT INTO apeB_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Umu moneken ali ipak wo puklimu enech elpech chutal enyudak sanda ali chukopu 300 kina e? Chukopu ali miyaisen umu echudak wakechi elpech.” ");
INSERT INTO apeB_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Anan douk wo ulkum mulomu chanohwagagun uli elpech ali dakio nukli namudak e, wak. Anan douk naku aluh atuh uli. Chopuk asudak amamis bokis douk hape hautu mani nyolomu douk anan nenek lukautimas ali nape nakumen aluh enen nyololuli mani. ");
INSERT INTO apeB_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Jisas nemnek namudak ali nakli, “Ipak pukleyokuk. okwok douk kwonek enyudak ali kwonek redimu yek umu ahudak nyumnah eke che igak ali chunak chunugomemu. ");
INSERT INTO apeB_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Elpech chahwogagun umu echudak uli eke chunepu pupe eheh nyumneh. Meihi nyumnah ipak pukli ahi ipak dakio pugakomech. Wakuli yek eke kobi inepu mupe loubamu, wak.” ");
INSERT INTO apeB_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Wolobaichi Juda douk achemnek balan umu Jisas nanak nape Lasaras ananitu wilpat gani Betani. Namudak ali echech chanak umu chutulunu. Ali echech douk wo chunak umu chutik Jisas atunu e, wak. Echech chopuk chanak umu chutik Lasaras douk nagak ali Jisas wata nanahul naitak nape uli. ");
INSERT INTO apeB_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Douk namudak ali amam nebemi pris howechik balan umu hakli hubo Lasaras nugak chopuk. ");
INSERT INTO apeB_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Umu moneken, wolobaichi Juda douk chatik umu agundak Jisas nanahul naitak napemu, ali echech chatukemaguk echechim nebemi chanak chasuh Jisas ananin balan chagipechen. ");
INSERT INTO apeB_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Wolobaichi elpech douk chanaki chape Jerusalem umu chunek agundak nebeguni woligun Pasova. Douk wehluwih ali echudak wolobaichi elpech achemnek balan umu chakli Jisas douk neyotuwi yah nape nanamali Jerusalem. ");
INSERT INTO apeB_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Douk namudak ali echech chanak chobleli ohokwinemigas olgos chahwogas chanak. Chanak aliga chogwatanu ali chohwalu chakli, “Apak munehilaumu God! Apak makli God nunekumanu yopinyi anudak alman douk nanakumali Diginali ananin yeul uli. Makli anan nunekumanu yopinyi apak Isrel apakinu King!” ");
INSERT INTO apeB_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Jisas nogwatu enen nugan donki douk nakih netemu ali nanak. Kobi douk enyudak balan nyetemu God ananik buk uli nyaklimu. Balan Enyudak. ");
INSERT INTO apeB_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Nyakli, “O ipak elpech pape abuldak nebebuli wabul Saion uli, ipak kobi elgeipu. Tik, ipakinu King anudak nanaki. Anan netemali enen nugan donki ali nape nanaki.” ");
INSERT INTO apeB_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Ali ababuk nyultab, apak ananipu disaipel douk wo mudukemu bawogenyumu e enyudak balan, wak. Wakuli aliga douk Jisas wata natanamu naltomu iluh heven, ali ababuk nyultab apak adakio madukemen. Monek tin ali madukemech makli enyudak balan nyetemu God ananik buk uli douk nyaklimu anan. Apak douk chopuk monek tinyumaguk enyudak douk echech elpech cheneken umu anan uli. ");
INSERT INTO apeB_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Ali ababuk nyultab Jisas nohwalu Lasaras naitak natogloli iwagu wata napemu, wolobaichi elpech douk cheyotu chatulunu. Douk namudak ali echech chanak chanaklipamu chanak umu enyudak anan neneken uli. ");
INSERT INTO apeB_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Ali wolobaichi elpech chemnek umu enyudak Jisas neneken uli, umu nohul Lasaras umu. Douk namudak ali echech chanak chogwatanali yah. ");
INSERT INTO apeB_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Amam Farisi hatik namudak ali hanaklipamu hakli, “Tik, apak moneken uli moul douk wo dodogowin e, wak. Chanatimaguk almam almagou douk chachi chanak chagipech Jisas atunu.” ");
INSERT INTO apeB_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Enech echech Grik douk chanamu Jerusalem. Chanu echudak elpech douk chanak umu chunek lotumu God ahudak nebehi nyumnah douk chenek agundak nebeguni woligun ahi. ");
INSERT INTO apeB_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Ali echudak Grik chanaki chatoglomu Filip. Anan douk nanaki abuldak wabul Betsaida douk blape enyudak provins Galili uli. Chanaki ali chaklipanu chakli, “Nebenyali, apak makli mutik Jisas.” ");
INSERT INTO apeB_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Filip nemnek ali nanak naklipu Andru. Ali amam biam hanak haklipu Jisas. ");
INSERT INTO apeB_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Haklipanu ali anan nebemom balan nakli, “Abudak nyultab umu God nunek Yek Anudak Alman douk yatoglu aduligeinyi elpen uli ilau nebenyi yeul umu douk abudak abatoglu. ");
INSERT INTO apeB_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Aduligu atugu yaklipepu. Sapos wit tukli kobi bligolotu tubih tugluk amnab ali tugak umu, atat douk eke atabuk atutu tupemu tupe. Wakuli sapos atat bligolatu tubih tugluk amnab ali tugak umu, atat douk eke wata pupuwolotu tukih ali eke wolobaitali ulubitu til. ");
INSERT INTO apeB_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Enyebuk elpen douk enyen ulkum mulomu enyen atin umu nyukli nyupe kalbu nyupe loubali nyultab apudak atap uli, enyen eke kobi nyupe loubali, wak. Wakuli enyebuk elpen douk wata nyupe apudak atap ali enyen kobi ulkum mulomu enyen atin ali nyunek yekin moul uli, enyen douk eke nyupe kalbu eheh nyumneh. ");
INSERT INTO apeB_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Ali enyebuk elpen douk nyunek yekin moul uli, enyen imas nyunubu nyugipech yek. Ali agnabuk yek inak ipemu, enyen chopuk eke nyunaku nyune upe. Ali yekinu Aninu eke nutuk enyenyin yeul nyukih.” ");
INSERT INTO apeB_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Ali Jisas wata chopuk nakli, “Nameitu yekihw apahw douk hwanubu yowehw ali balan wak umu iklimu. Yek eke kobi isalik Aninamu nuwechikuk yah umu enyudak hevi kobi nyutoglome, wak. Bawogas umu agundak yek yanamali apudak atap umu douk yanamali iwich enyudak hevi atin. ");
INSERT INTO apeB_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Aninu, nyak nyunek enyudak nyunatimaguk moul kobi nyak nyaklimu. Nyuneken umu nyunotuk nyakin yeul nyukih.” Douk Jisas nakli namudak ali anagu nigu ganaki gani iluh heven. Ali enyudak nyeyagwlehili elpen nyakli, “Yek ayatuk yekin yeul nyakih. Ali douk eke wata chopuk igamu ituken nyukih anah alagun.” ");
INSERT INTO apeB_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Ali echudak wolobaichi elpech douk cheyotu halakatili chemnek agudak nigu ali chakli utagu bagalagu. Enech chakli enen ensel nyanu Jisas heyagwleh. ");
INSERT INTO apeB_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Wakuli Jisas naklipech nakli, “Enyudak balan nyanaki iluh utagaluli douk wo nyunakimu nyugakamu yek e, wak. Enyen douk nyanakimu nyugakamu ipak umu pusuh yekin balan pukli adulin. ");
INSERT INTO apeB_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Ali nameitu, God eke nunekumech kwot echebuk douk chokonu agabus uli. Ali chopuk anan eke nubo Satan nubihuk. Anan douk nape nebenalimu apudak atap uli. ");
INSERT INTO apeB_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Wakuli yek eke chutuke chiyowaul iluh ali eke isanuk chunatimaguk elpech chunamali yek.” ");
INSERT INTO apeB_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Anan douk nakli namudak umu echech chumnek ali chudukemu ahudak yah douk eke anan nugak umu. ");
INSERT INTO apeB_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Douk namudak ali echudak wolobaichi elpech chaklipu Jisas chakli, “Apak madukemech umu, apakin lo nyakli abudak nyultab Krais nutoglomu, anan eke kobi nugak, wak. Eke nunubu nupe eheh nyumneh. Ali namudak nyaklimu, umu nyakli eke chusuh Anudak Alman douk natoglu aduligeinyi elpen uli ali chonu nugak nyil lowag kruse umu? Anudak Alman natoglu aduligeinyi elpen uli douk nanubu meinali?” ");
INSERT INTO apeB_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Ali Jisas naklipech nakli, “Yek douk eke inepu mupe banabu nyultab meyoh kobi hanu anatu lait taglakumepamu. Douk namudak ali ipak pupe punek yopinyi atin pasin abudak nyultab atudak lait hunutu tuglakumepamu. Umu ipak kobi pupe yomotokweh-igunmu, wak. Elpen nyalahe yomotokweh uli, enyen douk wo nyudukemu agundak enyen nyanak umu e, wak. ");
INSERT INTO apeB_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Nameitu abudak nyultab yek atudak lait watak yanepu mapemu, ipak imas pusuh yekin balan dadag pugipechen. Punek namudak umu, ipak eke putoglu elpech douk chalahe hwalalagun-maluli.” Douk Jisas nakliyuk namudak ali natukemechuk nanak nonobechuk nape anagun. ");
INSERT INTO apeB_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Anan wata nanech chape abali, anan douk nenek wolobainyi God atunu neneken uli moul chatulin. Chatulin wakuli echech wo chunek bilip umu anan e, wak. ");
INSERT INTO apeB_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Echech chenek namudak umu enyudak balan seiwak profet Aisaia neyagwlehen ali nyetemu God ananik buk uli nyutoglu adulin atin. Balan enyudak. Nakli, “Diginyali, apak douk maklipech nyakin balan, wakuli echech wo chuhwen chukli adulin e, wak. Echech chatik enyudak dodogowinyi moul nyak Diginyali nyeneken uli ali echech wo chukli nyak douk Diginyali e, wak.” ");
INSERT INTO apeB_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Echech douk wo chunokwnumu chunek bilip umu Jisas e, wak. Umu moneken, enyudak enen Aisaia nenyemaluli balan douk nyetemu namudak, ");
INSERT INTO apeB_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","God nakli, “Yek ayowechik echechip ulkwip panu echechis nabes. Wakumomu kedeke chutulugun kalbu chutik echudak ulkwip pulomech ali chudukemu bawogenyumu balan. Namudak ali eke chukli chutanamu chuke apaluh yek umu igabeyech chupe kalbu.” ");
INSERT INTO apeB_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Seiwak Aisaia douk natik agundak Jisas nanubu dodogowinu atunu yeul nyakihanamu ali nowemaguk enyudak balan. ");
INSERT INTO apeB_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Ali enyen douk adul. Wolobaimi echech Juda echechim nebemi henek bilip umu Jisas. Wakuli amam douk elgeim umu amam Farisi ali wo huwoleh amamin bilip yopugunmu e, wak. Umu moneken, hakli kedeke amam Farisi hunek tambumom umu kobi huwich hunech hunek lotu ogudak wilag douk echech Juda isave chape cheyagwleh balan ogwi, wak.” ");
INSERT INTO apeB_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Amam henek bilip uli douk hanubu oub baitak umu elpech meyoh chutuk amamich yeguh chukih. Wo hukli God yet nutuk amamich yeguh chukih e, wak. ");
INSERT INTO apeB_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Ali Jisas naklipech nebegun nakli, “Echebuk elpech douk chunek bilip umu yek uli, echech douk wo chunek bilip umu yek otuwe ye, wak. Echech douk chenek bilip umu Anudak douk nakagas yek yanakili chopuk. ");
INSERT INTO apeB_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Ali echebuk douk chatik yek uli, echech douk chatik Anudak douk nakagas yek yanakili. ");
INSERT INTO apeB_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Yek douk yanaki apudak atap kobi lait umu. Yanakumali echebuk douk chusuh yekin balan chugipechen uli kobi wata chupe yomotokweh atih, wak. ");
INSERT INTO apeB_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Ali elpech douk chumnek yekin balan wakuli kobi chuhwen dadag chugipechen uli, yek douk eke kobi inek skelumech umu kwot kobi jas umu, wak. Yek douk wo inaki apudak atap umu inek skel umu elpech e, wak. Yek douk yanamali inalau elpech chutanamali chupe kalbu. ");
INSERT INTO apeB_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Ali echebuk douk chuke agabus yek chukli wak umu chusuh yekin balan uli, echechinu jas douk kwali eke nunekumech kwotog uli douk nape. Enyudak atin balan douk yek yaklipechen ali echech chechege-yenyuk uli, enyen yet eke nyunek skelumech ali nyunekumech kwotog ahudak hugikuk uli nyumnah hutoglomu. ");
INSERT INTO apeB_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Umu moneken, enyudak balan douk wak yek meyoh ulkum mulomen ipe iklipechen e, wak. Enyen douk yekinu aninu naklipeyen ali nekege yanakimu iklipech. ");
INSERT INTO apeB_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Ali yek yadukemech umu, God ananin balan eke nyunek elpech umu chuhwen chugipechen ali chupe kalbu eheh nyumneh. Namudak ali nyanatimaguk enyudak yek yakliyen uli balan, enyen douk Yekinu Aninu meyoh naklipeyen ali dakio yanaki yaklipepeyen.” ");
INSERT INTO apeB_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Ahudak nyumnah umu chunek agundak nebeguni woligun Pasova umu douk ahanaki halakati. Ali Jisas douk anadukemech umu abudak nyultab eke nutukemaguk apudak atap nunak nunu Aninu hupemu douk abanaki. Ali abudak nyultab anan napemu, ananim ulkum douk manubu manosuh manatimaguk ananipu elpech douk mape apudak atap uli aliga nagak. Ali nameitu chopuk anan wata ulkum manohwopu ati. ");
INSERT INTO apeB_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Satan douk anawich Saimon ananinu nuganinu Judas. Nawichanu ali nakanu yowenyi tinytin umu anan nugilapu Jisas ananim birua anan Jisas ali amam huhwanu hunak honu nugak. Anudak Judas douk nanaki wabul yeulibulmu Kariot. Douk aliga wabigun ali amam hape hawak woligun. ");
INSERT INTO apeB_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Jisas anadukemech umu God douk anakli wosik ali nautu Anan umu nupe Diginalimu chanatimaguk enechi enech echudak. Ali chopuk anadukemech umu anan douk nanu God hapeli naitak nanaki ali eke wata nutanamu nunak nunu anan hupe. ");
INSERT INTO apeB_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Ali naitak nowal ahudak louhi lupah douk nohloguk aduk uli nohubukuk ali nohul enen taul nowechiken nyape nalteinamu. ");
INSERT INTO apeB_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Nowechiken nyape ali nohuli abal nenyuklabal anas dis ali nape nakwlupumopu yaliluh ananipu disaipel. Nakwlupoluh-umapu iyuh ali wata nanubloluhuk enyudak taul douk nowechiken nyape nalteinamu uli. ");
INSERT INTO apeB_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Nakwlupaluh-umopu nanak natoglomu Saimon Pita ali Saimon naklipanu nakli, “Nyak douk Diginyali. Namudak ali yek douk yakli wak umu nyak nyukwlupu yekiluh yaliluh umu.” ");
INSERT INTO apeB_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Wakuli Jisas naklipanu nakli, “Nameitu, nyak douk wo nyudukemu bawogenyumu e, enyudak moul douk nameitu yek yeneken uli. Wakuli kamanomi nyak wosik eke nyudukemen.” ");
INSERT INTO apeB_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Wakuli Pita naklipanu nakli, “Wak, yek yanubu yakli wak umu nyak nyukwlupu yekiluh yaliluh umu!” Ali Jisas wata chopuk naklipanu nakli, “Sapos yek kobi ikwlupu nyakiluh yaliluh umu, nyak douk eke kobi nyupe yekinyu disaipel, wak.” ");
INSERT INTO apeB_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Saimon Pita nemnek namudak ali nakli, “Diginyali, namudak umu, nyak douk kobi nyukwlupu yekiluh yaliluh atuluh, wak. Yakli nyukwlupu loguh uli boglom chopuk.” ");
INSERT INTO apeB_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Wakuli Jisas nakli, “Enyebuk elpen douk anyechlokuh uli, enyen douk ayopin ali kobi wata nyuklimu nyichlokuh alagun, wak. Enyen eke nyunokwlupu yaliluh atuluh. Ipak panatimaguk douk yopipu. Wakuli atunu meyoh douk wo yopunu e. ");
INSERT INTO apeB_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Jisas douk anadukemanu anudak disaipel douk eke nugilapu Jisas ananim birua anan Jisas ali huhwanu hunak honu nugak uli. Ali anan dakio nakli namudak. Nakli, “Ipak panatimaguk douk yopipu, wakuli atunu alman meyoh douk wo yopunu e, wak.” ");
INSERT INTO apeB_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Douk nakwlupumapu yaliluh iyuh ali wata nohul ahudak louhi nohloguk aduk uli lupah nohlu. Ali nanak nabih nape agundak dukwechuk napemu. Nape ali nasolikapu nakli, “Ipak padukemu bawogenyumu balan umu enyudak dukwechuk ati yenekenyumepu uli o wak? ");
INSERT INTO apeB_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Ipak panu yek meyagwleh umu, ipak douk isave pohwale Nebeweli Tisa o Digiweli. Ali pohwale namudak umu, enyen douk adul. Umu moneken, yek douk ipakiwe Nebeweli Tisa o Digiweli. ");
INSERT INTO apeB_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Yek douk ipakiwe Digiweli ali ipakiwe Nebeweli Tisa chopuk, wakuli yek douk wata yakwlupu ipakiluh yaliluh. Ali yakli ipak douk chopuk imas punak punogakagamu punoklupu ipakiluh yaliluh. ");
INSERT INTO apeB_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Yek yenek enyudak pasin yagilapepu ali ipak chopuk punak punek namudak ati kobi yenek umu ipak umu. ");
INSERT INTO apeB_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Adul ati yaklipepu. Enen nyape chukamomu ananu nebenali nyenekumanu moul meyoh uli, enyen douk wak nebenyi nyichalakuk enyenyinu nebenali e, wak. Ali douk namudak ati. Enen nyalau balan uli douk wak nebenyi nyichalakuk enyudak enen douk nyokegen nyanak uli e, wak. ");
INSERT INTO apeB_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Ali nameitu ipak douk padukemu bawogenyumu balan umu enyudak pasin yek yeneken uli. Ali sapos ipak pugipechen umu, God eke nugakamepu nunekumepu yopinyi nunekepu punehilau! ");
INSERT INTO apeB_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Ali yek douk wo iklien umu ipak punatimaguk e, wak. Yek ayadukemepu ipak douk yek yaglahepaluli. Wakuli enyudak God ananin balan douk nyetemu ananik buk uli imas nyunubu nyutoglu adulin atin. Balan douk enyudak. ‘Anudak alman douk nane wape wawak kakwich atugunmoluli wata natanamu nenek biruame.’ ");
INSERT INTO apeB_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Enyudak nameitu yek yaklien uli douk watak nyutoglu e ali douk ayaklipepu. Yalik yaklipepu umu ababuk nyultab nyukli nyutoglomu, ipak douk eke punek bilip pukli Yek Douk Seiwak Yape Namudak Uli. ");
INSERT INTO apeB_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Aduligu atugu yaklipepu. Elpen douk nyumnek enyebuk elpen douk yek ikagen nyunak uli enyenyin balan ali nyulawen uli, enyen douk nyemnek yekin balan ali nyalau yek chopuk. Ali enyebuk douk nyumnek yekin balan nyalau yek uli, enyen douk nyemnek anudak douk nakagas yek yanakili ananin balan ali nyalau anan chopuk.” ");
INSERT INTO apeB_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Douk Jisas nakliyuk namudak iyuh ali ananihw apahw hwanubu yowehw. Ali douk nanubu nowolehen naklipam nakli, “Aduligu atugu yaklipepu. Ipak panatimaguk pape agundak uli, ipak ananu douk eke nugilapu yekim birua umu yek ali eke huhwe hunak he igak.” ");
INSERT INTO apeB_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Douk Jisas nakli namudak ali apak ananipu disaipel matanamu manatitimu. Makli anan douk naklimu meinali. ");
INSERT INTO apeB_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Ali anudak disaipel douk Jisas anan nanubu ulkum manohwanu uli douk nanubu nape halakatimu anan Jisas. ");
INSERT INTO apeB_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Douk namudak ali Saimon Pita noulmanagu boglom ali nakli, “Nyak kwasalikanu. Anan douk naklimu omuni?” ");
INSERT INTO apeB_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Ali anudak disaipel nenehekich nanak halakatimu Jisas ali nasolikanu nakli, “Diginyali, nyak nyaklimu omuni?” ");
INSERT INTO apeB_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Ali Jisas nakli, “Anabuk douk yek isekul bret abaludak wichusibali abal ikaneyotu uli, alman douk eke akanabuk.” Ali nohuli anagun bret nesekwlutu noku Saimon ananinu nuganinu Judas. Anan douk nanaki wabul yeulibulmu Kariot. ");
INSERT INTO apeB_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Douk Judas natulunu bret natawoh neyatatu wakuli Satan nanubu nawichanu. Ali Jisas naklipanu nakli, “Aliga kale nekeyen wisnabul enyebuk douk nyakli nyuneken uli!” ");
INSERT INTO apeB_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Naklipanu namudak, wakuli apak manatimaguk mape agnabuk mape mawak woligun uli douk wo mudukemu bawogenyumu e, enyudak balan, wak. ");
INSERT INTO apeB_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Judas anan douk nenek bos umu amamibal utabal. Douk namudak ali apak anapu makli Jisas eke nakaganamu nunak nutali enech kakwich umu agundak nebeguni woligun Pasova gnunenek umu, o nakaganamu nunak nukechuk anabal utabal echudak wakechi. ");
INSERT INTO apeB_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Douk Judas nawak atudak bret naitak natoglu nanakuk wakuli banubu wab. ");
INSERT INTO apeB_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Douk Judas natoglu nanakuk ali Jisas naklipapu nakli, “Nameitu yek Anudak Alman douk yatoglu aduligeinyi elpen uli, God douk aneneke yalau nebenyi yeul. Ali yek eke inek elpech chutik agundak God nanubu dodogowinu atunu nohiyatik umu ali eke chutuk ananin yeul nyukih. ");
INSERT INTO apeB_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Ali douk yek ituk God ananin yeul nyukih umu, God anan yet chopuk ahudak atuh eke nutuk yek Anudak Alman douk yatoglu aduligeinyi elpen uli yekin yeul nyukih. ");
INSERT INTO apeB_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","O ipak douk panubu kobi yekipu batowich-umali, yek douk eke inepu mupe banabu nyultab meyoh ali eke wata itukemepaguk inak. Inakuk ali ipak douk eke pupe pulime. Likuk douk yaklipu echech Juda echechim nebemi ali nameitu douk chopuk yaklipu ipak enyudak atin balan: Ipak douk eke kobi punaku agundak yek inak ipemu, wak. ");
INSERT INTO apeB_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Ali yek yakli iklipepu enen nupolein lo douk ipak imas puhwen pugipechen uli. Enyudak lo douk namudak. Ipak atunu ati, ipakip ulkwip imas punubu punosuh umu. Umu moneken, susubati douk yek yalik ulkum manosuh ipak, ali ipak chopuk imas punek namudak ati. ");
INSERT INTO apeB_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Ali sapos ipak atunu ati ipak ulkwip punubu punosuhumomu, chunatimaguk elpech eke chutulipu ali eke chudukemech chukli ipak douk pagipech yek uli.” ");
INSERT INTO apeB_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Douk Jisas naklipapu namudak julug ali Saimon Pita nasolikanu nakli, “Diginyali, nyak nyakli nyunak meiguni?” Wakuli Jisas nakli, “Nameitu nyak eke kobi nyuname wunak agnabuk douk eke yek inak umu. Wakuli anabu nyultab nyak wosik eke nyugipeche nyunaku.” ");
INSERT INTO apeB_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Wakuli Pita nasolikanu nakli, “Diginyali, ali nyak nyakli nameitu yek kobi inamenyu wunak umu moneken? Yek douk wo elgeiwemu igak umu agundak yagipech nyak umu e, wak!” ");
INSERT INTO apeB_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Ali Jisas nebemanu balan nakli, “Pita, douk aduligu nyakli nyak eke nyugak umu agundak nyagipech yek umu, waka? Aduligu atugu yaklipenyu. Kehikib wab, nyak eke anyunek lohumechuk bieh atuh nyukli nyak wo nyudukemu yek e, ali owotu eke adakio titak tiyagwleh.” ");
INSERT INTO apeB_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Ali Jisas naklipu apak ananipu disaipel nakli, “Ipakich michich kobi yowech, wak. Ipak imas punek bilip umu God ali yek chopuk imas punek bilipume. ");
INSERT INTO apeB_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Gani numunitamu atudak yekinu Anineitu wilpat douk panubu wolobaipi lip pape. Ali yek douk eke inak igabemepu anagun gnupemepu. Douk kobi enep lip pupele, yek deke kobi ilaugamepu iklipepu namudak, wak. ");
INSERT INTO apeB_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Adul eke inak igapech-umepaguk ipakiyu outib upemepoguk ali eke wata itanamali inolumepu. Ali agnabuk yek inak ipemu, ipak chopuk eke pune mupe. ");
INSERT INTO apeB_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Ali yah douk hanamu agundak yek yakli inak umu uli, ipak douk wasik padukemah.” ");
INSERT INTO apeB_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Ali Tomas naklipanu nakli, “Diginyali, apak douk wo mudukemu agundak nyak nyakli nyunak umu e, wak. Yah eke mudukemah malmu, umu munakumogu?” ");
INSERT INTO apeB_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Ali Jisas nebemanu balan namudak. Nakli, “Yek yet douk yanubu yah umu elpech chunak chutik God umu, yanubu bawogas umu agundak chiyagwleh adulin atin balan umu, ali douk chopuk yanubu bawogas umu agundak chupe kalbu eheh nyumneh umu. Wak enen elpen deke nyugipech kipaihi yah ali nyunak nyutik yekinu Aninu e, wak. Yah douk yanubu yek yet. ");
INSERT INTO apeB_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Sapos ipak apadukemu yek kalbamu, yekinu Aninu douk chopuk eke pudukemanu. Ali nameitu ipak douk apape padukemanu ali apatulunu.” ");
INSERT INTO apeB_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Ali Filip naklipanu nakli, “Diginyali, apak douk wo muklimu enech echudak alagun e, wak. Ati makli nyugilapapu Aninu atunu ali julug.” ");
INSERT INTO apeB_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Ali Jisas nebemom balan nakli, “Filip, yek douk ayanepu mape loubomu nyultab ali nyak douk watak nyudukeme ye? Yaklipenyu, echebuk elpech chatik yek uli douk chatik Aninu. Ali nyak douk nyasolikemu wata igilapepu Aninamu moneken? ");
INSERT INTO apeB_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Nyak imas nyunek bilip umu agundak yek yakli Aninu nape yek ali yek yape anan umu. Balan yaklipepeyen uli douk wo yek meyoh ulkum mulomen ipe iklipepeyen e, wak. Wakuli Aninu douk napenyuwe uli nenek ananin moul. ");
INSERT INTO apeB_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Ipak imas punek bilip umu yek umu agundak yakli yek yape Aninu ali Aninu nape yek umu. Wak umu, ipakip ulkwip wata pulamaguk enyudak God atunu neneken uli moul douk yek yape yeneken uli ali ipak punek bilip. ");
INSERT INTO apeB_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Aduligu atugu yaklipepu. Enyebuk elpen douk nyusuh yekin balan nyugipechen uli, ihenyumali moul yek yeneken uli, enyen douk chopuk eke nyuneken. Adul, enyen eke nyunek nyanubu nebeben atinyi moul nyichalakuk enyudak yek yeneken uli. Umu moneken, yek douk eke inak itik yekinu Aninu. ");
INSERT INTO apeB_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Monokech echebuk douk ipak punek betenumech umu yekin yeul uli, yek douk eke inekechumepu. Yek ananiwe nuganinu inek namudak ali Aninein yeul eke chutuken nyukih. ");
INSERT INTO apeB_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Ali monokech echebuk douk ipak punek beten pusalikemu inekechumepu umu yekin yeul uli, yek douk eke inekechumepu.” ");
INSERT INTO apeB_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Sapos ipak ulkwip punubu punosuh yek umu, yekin balan douk eke puhwen pugipechen kalbu. ");
INSERT INTO apeB_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Ali eke inek beten isolik Aninu ali eke wata nukepali enyudak enen douk eke Nyugakomepu umu dodogowipu uli. Nukepeyen ali eke nyunepu pupe eheh nyumneh. ");
INSERT INTO apeB_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Enyudak Nyugakomepu uli douk God ananin Michin douk nyapemu nyeyagwleh adulin atin balan uli. Ali elpech douk chapemu chenek yowenyi atapinyi pasin uli eke kobi chulawen nyupenyich, wak. Umu moneken, echech douk wo chutulin o chudukemen e, wak. Wakuli ipak douk apadukemen. Enyen douk nyanepu pape ali eke nyuwich nyupenyipu. ");
INSERT INTO apeB_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Yek douk eke itukemepaguk inak ali eke kobi itukemepu pupeik kobi douk batowich mamechich wakechimu, wak. Eke wata itanamumepali. ");
INSERT INTO apeB_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Wo loubali e ali elpech douk chapemu chenek yowenyi atapinyi pasin atin uli eke kobi wata chutuliwe, wak. Wakuli ipak wasik eke putuliwe. Yek douk yape eheh nyumneh ali ipak chopuk eke punubu pupe eheh nyumneh. ");
INSERT INTO apeB_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Ali ahudak nyumnah hutoglomu, umu che igak ali wata itakumali, ipak eke pudukemech pukli yek douk yape yekinu Aninu, ipak pape yek ali yek yape ipak. ");
INSERT INTO apeB_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Echebuk elpech douk chusuh yekin dodogowinyi balan chugipechen kalbaluli, echebuk elpech douk chanubu ulkwip panosuh yek. Ali yekinu Aninu eke nunubu ulkum munosuh echebuk elpech. Ali yek chopuk eke ulkum munosuh echebuk elpech ali eke itoglu igilapech yek yet umu chunubu chudukeme.” ");
INSERT INTO apeB_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Jisas nakli namudak ali Judas nakli, “Diginyali, malmu namudak umu nyakli nyutoglomu apak atupu ali chapemu chenek apudak atapinyi yowenyi pasin uli nyakli wak umu nyutoglomech umu?” Anudak Judas douk wo anudak douk nanaki Kariot uli e, wak. ");
INSERT INTO apeB_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Ali Jisas nebemanu balan nakli, “Echebuk elpech douk echech ulkwip punubu punosuh yek uli, echech douk eke chusuh yekin balan ali chugipechen kalbu. Ali yekinu Aninu anan douk eke ulkum munohwech. Ali yek inu Aninu eke wunaki wunech wupe eheh nyumneh. ");
INSERT INTO apeB_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Echebuk wo ulkwip punosuh yek uli e douk wo chusuh yekin balan chugipechen e. Ali enyudak balan douk pemneke yeyagwlehen uli douk wo iyagwleh enen yekin balan e, wak. Yek douk yeyagwleh yekinu Aninu douk nakage yanakili ananin balan. ");
INSERT INTO apeB_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Enyudak nyanatimaguk balan douk nameitu wata yanepu mape ali yaklipepeyen. ");
INSERT INTO apeB_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Wakuli enyudak God ananin Michin douk enyudak douk eke Nyugakomepu dodogowipu uli. Yekinu Aninu eke nukagen nyunakumali yekin yeul. Enyen nyunaki ali eke nyugilapepu ihenyumali enenyi enen pudukemen. Enyen eke wata nyuhul ipakin tinytin ali ipak eke wata ulkwip pulomu enyudak nyanatimaguk balan douk yek yaklipepamu. ");
INSERT INTO apeB_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Yek eke itukemepaguk inak, ali enyudak pasin umu chape kalbu apaluh hlalu kalbamu douk enyudak ikepeyenyuk. Enyudak pasin douk nyanubu yekin ali douk enyudak yekepeyenyuk. Yek wo ikepu enyudak pasin kobi elpech chapemu chenek atapinyi atin pasin uli deke chukepeyen umu e, wak. Namudak ali ipakich michich douk kobi yowech pukli elgeipu, wak. ");
INSERT INTO apeB_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Ipak douk pemneke yaklipepu yakli, ‘Yek eke itukemepaguk inak ali eke wata itanamumepali.’ Douk sapos ipakip ulkwip punubu punosuh yek ele, ipak deke punehilaumu agundak yek inak itik Aninamu. Umu moneken, anan douk nebenali nechalakuk yek. ");
INSERT INTO apeB_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Enyudak wata nyutoglu e ali douk ayaklipepumen. Namudak ali kamanami abudak nyultab enyen nyukli nyutoglu abali, ipak douk eke punek bilip umu yek pukli yek yaklipepaguk aduligein balan. ");
INSERT INTO apeB_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Yek eke kobi wata inepu miyagwleh wolobainyi balan chopuk, wak. Umu moneken, nebenalimu apudak atap uli douk ahuluk umu nunaki. Anan nunaki, wakuli eke kobi dodogowinamu nunek enech echudak umu yek, wak. ");
INSERT INTO apeB_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Wakuli yek yakli apudak atapichi elpech imas chudukemech umu agundak yek douk yanubu ulkum manosuh yekinu Aninamu. Ali chopuk yakli chudukemech umu enyudak yeneken uli douk Aninu naklipe dakio yeneken. Ali ipak douk kitak mutukemaguk agundak munak.” ");
INSERT INTO apeB_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Jisas wata chopuk nakli, “Yek douk yanubu enyudak aduligeinyi lowag wain. Ali yekinu Aninu God douk anudak nenek moul numun agundak wainigu nohobigaluli. ");
INSERT INTO apeB_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Ihou yeguhwiyu douk wataku yek enyudak lowag wain ali wak enep chulkwip pilou uli e, anan douk isave natupowoguk. Owobuk douk chulkwip peilou uli, anan isave nagamu nagapechou nobleyou banou umu wata wolobaipi chulkwip pil. ");
INSERT INTO apeB_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Ali douk namudak ati. Enyudak balan yek yaklipepeyen uli douk nyape ipakiluh apaluh ali anyenekepu patoglu yopipali. ");
INSERT INTO apeB_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Ipak imas punubu punek pas yek ali yek chopuk eke inubu inek pas ipak. Onok yegulik okwok yet eke kobi chulkwip pil, wak. Sapos okudak yegulik kutaku enyudak lowag wain umu, orait okwok douk wasik chulkwip eke pil. Ali douk namudak ati. Sapos ipak kobi punek pas yek ali pusuh yekin balan dadag pugipechen umu, ipak yet eke kobi dodogowipamu punek yopinyi pasin, wak. ");
INSERT INTO apeB_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Yek douk enyudak lowag wain ali ipak douk yeguhiyu. Namudak ali elpen douk nyunek pas yek ali yek inek pas enyen uli, enyen douk eke nyunek wolobainyi yopinyi pasin. Sapos ipak kobi punek pas yek umu, orait ipak douk eke kobi dodogowipamu punek enen yopinyi, wak. ");
INSERT INTO apeB_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Enyebuk elpen douk wo nyunek pas yek ali wo nyusuh yekin balan dadag nyugipechen uli e, yekinu Aninu eke nugimehumen kobi noble onok yelgulik enyudak lowag wain ali nokubukuk alik umu. Ali oudakmali yeguhiyu douk isave chatalmou chowobuk atugun ali chowohul chowachou wagluk nyih hanuwu. ");
INSERT INTO apeB_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Sapos ipak punek pas yek ali yekin balan nyupe ipak umu, orait abudak nyultab ipak punek beten pusolikemu enechi enech echudak ipak pakliech ulimu, orait aduligu atugu, echudak eke chutoglomepu kobi ipak penek beten pasolikemu. ");
INSERT INTO apeB_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Ali sapos ipak punek wolobainyi yopinyi pasin umu, orait namudak elpech eke chutulipu ali eke chutuk yekinu Aninu God ananin yeul nyukih. Pugimeh namudak ali elpech eke chutulipu chukli ipak douk panubu pagipech yek uli. ");
INSERT INTO apeB_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Yek douk ulkum manosuh ipak kobi yekinu Aninu anan ulkum manosuh yek umu. Yekim ulkum manosuh ipak ali wihluwehlu ipak ulkwip imas punubu pulomu enyudak. ");
INSERT INTO apeB_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Ali sapos ipak pugipech yekin balan duldul umu, orait yekim ulkum eke munohwepu. Ali wihluwehlu ipak eke ulkwip pulomu enyudak ali eke pupe kalbu. Kobi douk yek yagipech yekinu Aninu ananin balan ali ananim ulkum manosuh yek ali yek ulkum molomu enyudak yape kalbamu. ");
INSERT INTO apeB_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Yek douk yaklipepu enyudak balan umu moneken, yanubu yakli ipak imas pulau enyudak yekin pasin umu yenehilawomu nyupenyipu. Namudak ali ipak eke pupemu punehilau pulikuk. ");
INSERT INTO apeB_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Yekin dodogowinyi balan douk enyudak. Ipak atin ati ipakip ulkwip imas punosuhumu kobi yek ulkum manosuh ipak umu. ");
INSERT INTO apeB_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Enyudak pasin umu enen elpen ulkum munubu munosuh enyenyichi elpech ali nyugak umu nyugakamech umu, enyudak douk nyechalakuk nyanatimaguk pasin umu ulkwip panosuh kipahechimu. ");
INSERT INTO apeB_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Ali sapos ipak punubu pusuh yekin balan dadag pugipechen umu, orait ipak douk yekipu elpech. ");
INSERT INTO apeB_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Nameitu yek eke kobi wata ihwalepu peneme moul meyoh uli, wak. Umu moneken, elpen nyenek moulomu enyenyinu nebenalili, enyen douk wo nyudukemen ati e enenyi enen enyenyinu nebenali naklimu nuneken uli, wak. Wakuli nameitu, yek eke wata ihwalepu yekipu elpechim meyoh. Umu moneken, ihenyumali yekinu Aninu naklipeyenyi balan douk yaklipepeyen yeyaten. ");
INSERT INTO apeB_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Ipak douk wo punoglah yek e, wak. Yek yanaglah ipak umu punubu punek wolobainyi yopinyi pasin. Ali enyudak yopinyi pasin eke nyunubu nyupe namudak ati. Namudak ali yekinu Aninu God eke nukepu ihechumali douk ipak puhul yekin yeul pinyemu ali pusalikanamu nukepeyech uli. ");
INSERT INTO apeB_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Dodogowinyi balan yek yaklipepamu pugipechen uli douk enyudak. Ipak atin ati ulkwip imas punubu punosuhumu. ");
INSERT INTO apeB_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Sapos elpech douk chapemu chagipech apudak atapinyi yowenyi pasin uli chukepu agabus ali chunek biruamepamu ipak imas pwudukemech umu, echech douk chalik cheke agabus yek ali chenek biruame. ");
INSERT INTO apeB_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Sapos ipak pukli pugipech enyudak douk echech chapemu cheneken ulimu, orait echechip ulkwip douk eke punohwepu chukli ipak douk echechipu. Wakuli yek douk ayanaglahepamu pupe yekipu elpech ali ipak douk awak pugipech apudak atapinyi pasin e, wak. Namudak ali echech douk chakli wakepu ali chape chenek biruamepu. ");
INSERT INTO apeB_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Ipakip ulkwip imas pulomu enyudak balan douk ayaklipepeyen uli. Balan enyudak. ‘Alman nenek moul meyoh umu kipainali alman uli, anan douk wo nichalakuk ananinu nebenali e, wak.’ Ali douk namudak ati. Echech douk cheneke anagu anagu yek ipakiwe Nebeweli ali ipak chopuk eke chunekepu anagu anagu. Ali chopuk sapos echech chumnek yekin balan ele, ipakin chopuk deke chumneken ali chugipechen. ");
INSERT INTO apeB_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Enyudak yaklipepamu douk eke chuneken-umepu. Umu moneken, ipak douk yekipu pagipech yek ali echech douk wo chudukemu Anudak nakagasi yek yanakili e, wak. ");
INSERT INTO apeB_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Sapos yek kobi ibihi apudak atap ali iklipech God ananin balan chumneken ele, God deke kobi nukli balan nyupenyich umu chenek enenyi-enen yowenyi wak. Wakuli yek douk yabihi yaklipechen chemnek ali yegwih douk wakech umu chukli chunobechuk enenyi-enen cheneken uli yowenyimu. ");
INSERT INTO apeB_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Echebuk elpech douk chakli wak yek ali chenek biruame uli, echech douk chopuk chakli wak yekinu Aninu ali chenek biruamu anan chopuk. ");
INSERT INTO apeB_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Yek yenek enenyi enen God atunu neneken uli moul douk likuk wo kwalowi enen elpen nyuneken uli e nyatoglu ali chatulin. Ali douk adul, sapos yek kobi inek enyudak moul chutulin ele, orait God deke kobi nukli echech douk chenek yowenyi ali eke kobi nunubu nunemech nebenyi balan, wak. Wakuli echech douk chatuliwe yeneken nyatoglu ali chakli wakohu chenemohu birua, yek yanu yekinu Aninu chopuk. ");
INSERT INTO apeB_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Enyudak douk cheneken nyatoglu umu enen balan nyetemu God ananik buk uli nyutoglu adulin atin. Balan enyudak. ‘Bawogenyumu balan wak enen e, wakuli chakli wake cheneme birua meyoh meyoh.’ ");
INSERT INTO apeB_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Ali kamanami enyudak Nyugakomepu umu dodogowipu uli eke nyunaki. Enyen douk God ananin Michin douk nyeyagwleh adulin atinyi balan uli. Enyen douk nyanu Aninu nyape ali eke nyunaki. Enyen douk nyanu Aninu nyape ali eke ikagen nyutukemanaguk nyunaki. Eke nyunaki ali nyuklipepu nyanatimaguk yekin balan. ");
INSERT INTO apeB_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Ali ipak douk chopuk imas puklipech yekin balan. Umu moneken, likuk wata susubati yohul enyudak moul abali aliga nameitu, ipak douk patanuh yek ali patuliwe padukemech.” ");
INSERT INTO apeB_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Jisas balan nyeilen nakli, “Yek douk yaklipepu enyudak balan umu yakli ipak kobi putukemaguk yek, wak. ");
INSERT INTO apeB_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Eke chunalak chupemepu putukemaguk lotuwig wilag putoglaguk aduk umu kobi punech punek lotu. Ali nyultab eke butoglu umu enech elpech eke chepu pugak umu. Chepu pugak ali echech eke chunek tin chukli echech wosik chenek God ananin yopinyi moul. Wakuli wak. ");
INSERT INTO apeB_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Eke chunemepu enyudak umu moneken, echech douk wo chudukemu yek o chudukemu yekinu Aninu e, wak. ");
INSERT INTO apeB_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Yek douk yaklipepu enyudak umu abudak nyultab chukli chunekumepu enyudak abali, orait ipak eke ulkwip puloguk pukli yek douk yalik yaklipepu nebenyi balan umu enyudak. Likuk wata susubatimu douk wo iklipepu enyudak balan e, wak. Umu moneken, yek douk wata yanepu mape. ");
INSERT INTO apeB_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Wakuli nameitu, yek douk eke inak itik Anudak douk nakagas yek yanakili. Ali ipak douk wo kwalowi ananu nusolikemu agundak eke yek inak umu e, wak. ");
INSERT INTO apeB_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Wakuli yek yaklipepu enyudak balan umu eke inak umu, ali ipakich michich douk chanubu yowech. ");
INSERT INTO apeB_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Wakuli aduligu atugu yaklipepu. Yek itukemaguk ipak pupeik inak umu, enyudak douk kalbu umu igakamu ipak. Wakuli sapos yek ikli kobi inak umu, orait enyudak Nyugakomepa-luli eke kobi nyunakumepali, wak. Wakuli sapos yek inak umu, yek douk eke ikagenyi nyunaki nyunepu pupe nyugakomepu. ");
INSERT INTO apeB_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Ali ababuk nyultab Enyen nyunaki abali, Enyen douk eke nyugilapu apudak atapichi elpech umu yowenyi douk echech wo chudukemech e ali chape cheneken umu. Chopuk eke nyuwolmech bawogas nyugilapech duldulinyi pasin nyunu agundak God eke nunekumech nebenyi balan umu. ");
INSERT INTO apeB_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Enyen douk eke nyugilapu elpech ali chudukemech umu echech douk chenek yowenyimu agundak wo chunek bilip umu yek umu e. ");
INSERT INTO apeB_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Ali agundak nyuwolmech bawogas nyugilapech duldulinyi pasin umu douk namudak. Yek eke inak itik yekinu Aninu ali ipak eke kobi wata putiwe, wak. ");
INSERT INTO apeB_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Ali enyen eke nyunaki nyugilapech umu agundak God eke nunekumech nebenyi balan umu echechin yowenyi. Umu moneken, God douk anenekumanu nebetali kwot Satan douk nebenalimu enenyi enen apudak atapinyi pasin uli. ");
INSERT INTO apeB_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Yek wolobaichi echudak douk yakli iklipepumech uli. Wakuli nameitu eke iklipepu ali eke kobi pudukemech, wak. Namudak ali eke kobi iklipepu. ");
INSERT INTO apeB_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Wakuli abudak nyultab enyudak God ananin Michin douk nyeyagwleh adulin atin uli nyunaki abali, enyen eke nyugilapepu pudukemu ihenyumali aduligeinyi balan. Enyen eke nyunaki ali eke kobi gulamaguk Enyen atin ali nyiyagwleh enen balan, wak. Wakuli eke nyuklipepu enyudak balan douk nyemnek God naklien uli. Ali eke nyuklipepamu echudak eke chutogloluli. ");
INSERT INTO apeB_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Enyen douk eke nyunubu nyutuk yekin yeul nyukih umu agundak nyulawali yekin balan nyunaki nyuklipepamu. ");
INSERT INTO apeB_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Enechi-enech yekinu Aninu neglemech uli douk yekich atich. Namudak ali dakio yaklipepu yakli God ananin Michin eke nyuklipepu balan douk nyemnek yek yaklipen umu. ");
INSERT INTO apeB_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Banabu nyultab meyoh ali ipak eke kobi wata putiwe, wak. Inakuk wakuli eke kobi loubomu eke wata itanamali putiwe.” ");
INSERT INTO apeB_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Namudak ali anam ananim umu disaipel hatanamu hanasasalimu hakli, “Bawogenyumu enyudak balan umu nakli banabu nyultab meyoh apak eke kobi wata mutulunu wakuli kobi loubomu eke wata nutanamali mutulunamu douk nyakli malmu? Ali chopuk nakli apak eke kobi mutulunu umu moneken, anan douk eke nunak nutik ananinu Aninu uli.” ");
INSERT INTO apeB_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Amam hape hanosolik hakli, “Bawogenyumu enyudak balan umu nakli banabu nyultab meyoh umu douk nyanubu nyakli malmu? Apak wo mudukemen e, wak.” ");
INSERT INTO apeB_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Jisas natulumu ali nadukemech umu amam douk hakli husolikanu. Namudak ali naklipam nakli, “Yek douk yakli, ‘Banabu nyultab meyoh ipak eke kobi wata putiwe, wak. Wakuli eke kobi loubomu ali eke wata itanamali putuliwe.’ Ipak douk pape panasalimu umu pakli pudukemu bawogenyumu enyudak balan yek yaklien uli, waka? ");
INSERT INTO apeB_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Aduligu atugu yaklipepu. Ipak eke apaluh yoweluh puleh punakli atimu yek. Wakuli elpech chapemu chagipech atapinyi pasin uli eke chunehilau. Ipak eke apaluh yoweluh, wakuli agundak apaluh yoweluh umu eke wata gnunak gnuwichuk ali eke wata punubu punehilau pulikuk. ");
INSERT INTO apeB_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Abudak nyultab onok almatok kupe kubilak umu kutas kulu batowin abali, okwokwihw apahw douk yowehw. Umu moneken, okwokwibu nyultab umu kumnek nyih umu douk abatoglu. Wakuli abudak nyultab okwok akutasuk kwulu batowin umu julug, ali okwokwim ulkum eke kobi wata mulomu ehudak nyih, wak. Umu moneken, okwok douk akwatas kwolu batowin nyatoglu nyape apudak atap kwonehilau. ");
INSERT INTO apeB_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Ali ipak douk namudak ati. Nameitu abudak nyultab douk ipakibu umu ipakich michich yowech umu. Wakuli yek eke wata itanamali itulipu ali ipakiluh apaluh eke wata hlunubu hlulu kalbu punehilau. Ali eke kobi enech elpech chunaki chunekuk agundak ipak punehilau pulikuk umu, wak. ");
INSERT INTO apeB_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Abudak nyultab bukli butoglu abali, ipak eke kobi pusolike enen balan, wak. Aduligu atugu yaklipepu. Aninu God eke nukepu enechi enech echudak ipak pusolikanamu nukepeyech umu yekin yeul uli. ");
INSERT INTO apeB_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Likuk aliga nameitu, ipak douk wo pusolik God umu nukepu enech echudak umu yekin yeul e, watak. Ipak imas pusolikanu ali eke nukepeyech. Namudak ali ipak eke punubu punehilau pulikuk.” ");
INSERT INTO apeB_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Nameitu enyudak nyanatimaguk balan douk yek yape yaklipepeyen woblen atin. Wakuli nyultab eke butoglu umu yek eke kobi wata iklipepu woblen umu. Wakuli eke wata inubu iwolehen-umepu ali iklipepamu yekinu Aninu umu pudukemanu kalbu. ");
INSERT INTO apeB_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Ali ababuk nyultab bukli butoglomu, ipak yet eke punek beten pusolik yekinu Aninu umu yekin yeul. Yek douk wo iklipepamu yek yet eke isolik Aninamu nugakamepu e, wak. ");
INSERT INTO apeB_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Umu moneken, yekinu Aninu anan yet douk ulkum manubu manosuh ipak. Anan douk ulkum manohwepu umu moneken, ipak douk ulkwip panosuh yek ali chopuk penek bilip pakli adul yek douk yanu God wapeli ali yanaki. ");
INSERT INTO apeB_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Adul, yek douk yanu Aninu wapeli ali yatukemanaguk yanamali apudak atap. Ali nameitu, yek douk eke wata itukemaguk apudak atap ali wata itanamu inak itulunu.” ");
INSERT INTO apeB_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Ananipu disaipel memnek namudak ali maklipanu makli, “Adul, nameitu nyak douk nyanubu nyowolehen-umapu balan ali wata nyuklipopeyen woblen atin e, wak. ");
INSERT INTO apeB_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Nameitu apak madukemech umu, nyak douk adul nyadukemu chanatimaguk echudak. Sapos enen elpen nyukli nyusolikenyu enen balan abali, enyen douk watak nyusolikenyu e, wakuli nyak douk adukwechuk nyadukemu enyudak balan enyen nyakli nyusolikenyamu. Apak douk matik namudak ali monek bilip makli nyak douk nyanu God papeli ali nyanaki.” ");
INSERT INTO apeB_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Jisas wata nebemom balan ali nakli, “Ati douk aliga nameitu ali ipak adakio penek bilip umu yek, waka? ");
INSERT INTO apeB_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Mnek. Nyultab eke butoglu ali douk abudak ahalakatimu eke butoglu. Umu ipak punatimaguk eke chihiyahepu putukemaguk yek otuwe ipeik. Ali ipak eke pulhwas punak atunu ati, punamu ipakilub walub silisili ati. Wakuli douk eke kobi inubu yek otuwe ipeik, wak. Umu moneken, yekinu Aninu douk nane wape. ");
INSERT INTO apeB_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Yek douk yaklipepu enyudak balan umu yakli ipak punubu punek pas yek ali apaluh hlulu kalbu. Apudak atapichi elpech eke chunekepu anagu-anagu ali eke pulau nebehi nyih. Wakuli ipak kobi elgeipu, wak. Punubu piyotu dodogowipu atipu. Yek douk ayabouk apudak atapin pasin nyabihuk.” ");
INSERT INTO apeB_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Douk Jisas nakliyuk enyudak julug ali nepuhul natik iluh heven ali nenek beten nakli, “Yekinyu Aninu, abudak nyultab umu yek igak umu abudak abatoglu. Ali nyak nyutuk yekin yeul nyukih umu yek nyakiwe Nuganinu chopuk eke ituk nyakin yeul nyukih. ");
INSERT INTO apeB_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Umu moneken, nyak douk anyeke enyudak namba umu ipe nebewelimu chanatimaguk elpech umu igakamu echebuk elpech douk nyak nyukeyech uli umu chupe kalbu eheh nyumneh. ");
INSERT INTO apeB_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Ali bawogas umu agundak chunubu chupe kalbu eheh nyumneh umu douk namudak. Echech chudukemu nyak nyanubu atinyu adulinyu God ali chudukemu yek Jisas Krais douk nyak nyekege yanakili. ");
INSERT INTO apeB_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Yek yenek enyudak moul yeyaten, douk nyak nyekegelimu inaki ineken uli. Yeneken douk apudak atapichi elpech chatiwe ali chatuk nyakin yeul nyakih. ");
INSERT INTO apeB_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Aninu, nyak douk wata nyunek apudak atap e, wakuli yek douk ayanu nyak wape ali nyeke nebenyi yeul nyeneke yanubu yahiyatik. Ali nameitu yek yakli nyak wata nyuke enyudak atin nebenyi yeul nyuneke inubu ihiyatik kobi likuk susubati nyekeyen umu. ");
INSERT INTO apeB_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Ali yek yaklipu amudak almam douk nyak nyekeyam uli umu nyak. Amudak amam douk hatukemaguk enenyi enen apudak atapin yowenyi pasin. Amam douk nyakim almam ali douk nyoku yekam. Nyekeyam ali nyakin balan douk hahwen hagipechen kalbu. ");
INSERT INTO apeB_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Ali nameitu amam douk hadukemech umu, ihechumali echudak nyak anyekeyech uli douk nyakich atich. ");
INSERT INTO apeB_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Balan nyak nyaklipeyen uli douk ayaklipam ali hahwen hadukemech hakli adulin. Hakli likuk yek adul yanu nyak wapeli ali nyekege yanaki. ");
INSERT INTO apeB_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Ali yek douk yenek beten yasolikenyamu nyugakamom. Wo inek beten isolikenyamu nyugakamu elpech douk chapemu chenek apudak atapinyi yowenyi pasin uli e, wak. Yek yenek beten yasolikenyamu nyugakamu amudak almam douk nyak nyekeyam uli. Umu moneken, amam douk nyakim. ");
INSERT INTO apeB_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Chanatimaguk nyakich elpech douk yekich. Ali chanatimaguk yekich elpech douk nyakich. Ali kipahechi chatik echudak ohwakich elpech ali chadukemech umu agundak yek yanubu dodogowiwe otuwe ali yaglak umu. ");
INSERT INTO apeB_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Ali nameitu yek ahalakatimu itukemaguk apudak atap inaku inu nyak wupe. Wakuli amam eke hupeik apudak atap. Ali yekinyu nyanubu yopi-yopinali Aninu, yek yakli nyak nyugakamom ali amam hupe dodogowim umu nyakin dodogowinyi yeul douk nyak nyekeyen uli. Nyugakamom umu amam hunubu hupe atunu alman meyoh kobi ohwak wanubu wape atunamu. ");
INSERT INTO apeB_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Abudak nyultab yek yanam mapemu, yek douk yenek lukautumom yagakamom hape kalbamu nyakin dodogowinyi yeul douk nyak nyekeyen uli. Yape yenek banisumom ali wak ananu nunokwlobeik e. Wakuli anudak atunu douk eke nunamu yowebuli wabul hel uli atunu eke nunokwlobeik. Anan douk nonoklobeik umu enyudak balan nyetemu nyakik buk uli nyutoglu adulin atin. ");
INSERT INTO apeB_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Ali nameitu yek eke wata inaku inu nyak wupe. Douk namudak ali nameitu wata yape apudak atap ali yaklipenyu enyudak balan. Yaklipenyomu amam humnek ali amamiluh apaluh hlulu kalbu hunubu hunehilau hulikuk kobi yekihw apahw hwolu kalbu yenehilawamu. ");
INSERT INTO apeB_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Yek ayaklipam nyakin balan ali apudak atapichi elpech douk chanubu chakli wakam. Umu moneken, amam wo hugipechech umu hunek apudak atapinyi pasin e, wak. Hagimah kobi yek wo igipechech muneken umu e. ");
INSERT INTO apeB_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Ali yek wo isolikenyamu nyulau amudak almam hutukemaguk apudak atap e, wak. Yek yasolikenyamu nyunek banisumom umu yowenali alman kobi nunek lohumom ali hunek yowenyi, wak. ");
INSERT INTO apeB_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Ali yek wo igipech apudak atapichi elpech umu munek enenyi enen apudak atapin yowenyi pasin e, wak. Ali amudak chopuk douk namudak ati. Amam douk wo hugipechech e, wak. ");
INSERT INTO apeB_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Enyudak nyakin balan nyanubu adulin atin. Ali yek douk yakli nyak nyuwechik nyakin balan nyupe numun amamiluh apaluh umu amam hunubu hupe nyakim atum. ");
INSERT INTO apeB_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Ali yek douk yakagam umu hunak apudak atap hunek yekin moul. Yakagam umu hunak huneken kobi likuk nyak nyakagasi yek yanaki apudak atap ali yenek nyakin moul umu. ");
INSERT INTO apeB_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Yek douk yakli igakamu amam ali yekenyu yek yet umu inubu itoglu nyakiwe otuwe. Yenek namudak umu amam chopuk hunubu hutaglu nyakim atum. ");
INSERT INTO apeB_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Ali yek douk wo inek beten isolikenyamu nyugakamu amudak yekim disaipel atum e, wak. Yek chopuk yenek beten yasolikenyamu nyugakamu echebuk elpech douk eke chumnek nyakin balan amam huklipechen uli ali chunek bilip umu yek uli. ");
INSERT INTO apeB_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Yek yasolikenyamu echech chunubu chupe atin elpen. Yakli chupe kobi nyak nyape yek, yek yape nyak ali wanubu watoglu atunamu. Yakli chunubu chunek pas chupe ohwak umu apudak atapichi elpech chutulich ali chunek bilip chukli yek douk nyak nyekegeli ali dakio yanaki. ");
INSERT INTO apeB_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Ali yek douk ayokech enyudak atin strong nyanu nebenyi yeul douk nyak nyoku yek umu. Yekechen umu echech chunubu chupe atin elpen kobi ohwak wanubu wape atunu alman umu. ");
INSERT INTO apeB_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Nyak nyape yek ali Yek douk yape echech umu echech chunubu chutoglu atin elpen. Chunek namudak umu apudak atapichi elpech eke chudukemech chukli yek douk nyak nyekege yanaki. Ali chopuk eke chudukemech umu nyak douk ulkum manosuh yekichi elpech kobi nyak ulkum manosuh yek umu. ");
INSERT INTO apeB_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Aninu! Seiwak nyak watak nyunek apudak atap e ali nyak douk nyanubu ulkum manosuh yek. Namudak ali nyeneke yehiyatik yatoglu dodogowiwe otuwe. Douk namudak ali nameitu yakli echudak elpech nyak nyekeyech uli douk chunaku chunu yek mupe agundak yek yapemu. Yakli mupe ali chutik agundak douk yek yanubu yehiyatik ali dodogowiwe otuwemu. ");
INSERT INTO apeB_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Yekinyu duldulinyali Aninu, apudak atapichi elpech douk wo chudukemu nyak e, wak. Wakuli yek douk yadukemenyu. Ali echudak yekichi elpech chopuk chadukemech umu yek douk nyak nyekege yanaki. ");
INSERT INTO apeB_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Yek douk ayeneyogomech umu nyak ali chadukemenyu. Ali douk eke wata ipe ineyogomech umu echechip ulkwip punubu punosuh kipaichi kobi nyak ulkum manosuh yek umu. Ali chopuk ineyogomech umu yek eke ipe echech.” ");
INSERT INTO apeB_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Douk Jisas nenek beten nasolik God umu julug ali nanu ananipu disaipel maitak mablo anatu chokutali beyatu chohwalatomu Kidron uli ali manak gani woblahah. Gani woblahah beyotu douk anagas lowas chohwalagas umu oliv uli satau. Manak mawich ali mape agnabuk. ");
INSERT INTO apeB_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Likuk Jisas nanu apak ananipu disaipel manak mawich wolobaihi agundak agasudak lowas oliv satawomu. Douk namudak ali anudak Judas douk eke nugilapu Jisas ananim birua anan Jisas ali huhwanu hunak honu nugak uli douk nadukemogun. ");
INSERT INTO apeB_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Ali ababuk wab amam nebemi pris hanu Farisi hakagas anam soldia hanu amudak anam henek was umu God ananitu nebetali wilpat uli hanaku. Haitak hehemu nyih uli lepoguhas hahwechu, hasuhu bainatog uli bulawos ali Judas nalikom hanaku. ");
INSERT INTO apeB_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Jisas douk anadukemu nyanatimaguk enyudak douk eke nyutoglomanu uli. Douk hanaku ali anan neilmom nanak ali nasolikam nakli, “Ipak paulimu omuni?” ");
INSERT INTO apeB_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Ali amam hakli, “Apak maulimu Jisas douk nanaki wabul Nasaret uli.” Wakuli Jisas nakli, “Yek douk enyudak wo.” Anudak Judas douk nagilapam Jisas umu huhwanu hunak honu nugak uli douk nanam heyotu. ");
INSERT INTO apeB_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Douk hemnek umu Jisas nakli, “Yek douk enyudak wo” ali wata henehekich hanamu agabus ali hanak habih hakus atap. ");
INSERT INTO apeB_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Ali Jisas wata chopuk nasolikam nakli, “Ipak panaki paulimu omuni?” Ali amam hakli, “Apak maulimu Jisas douk nanaki wabul Nasaret uli.” ");
INSERT INTO apeB_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Ali Jisas nebemom balan nakli, “Adukwechuk yaklipepu wo. Alman pape paulimanu uli douk yek. Ali sapos ipak paulimu yek panakimu, ipak douk pusuh yek otuwe. Amudak pukleyomuk hunak.” ");
INSERT INTO apeB_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Anan douk nakli enyudak balan umu enen balan likuk anan yet naklien uli nyutoglu adulin atin. Balan enyudak. “Aninu, yek wo idiyuk ananu amudak almam douk nyak nyekeyam uli nunak nuwichuk e, wak.” ");
INSERT INTO apeB_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Saimon Pita douk nowilak anatu bainat neyotu agnabuk. Douk natukatali ati tagluk Malkus natupok ananih anuh atah tukalah. Anudak Malkus douk nenek moulomu nanubu nebenali Pris uli. ");
INSERT INTO apeB_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Jisas natik namudak ali naklipu Pita nakli, “Wilakuk bainat agnabuk dukwechuk nyatukatumali. Nyak nyakli yek kobi imnek ehudak nyih douk yekinu Aninu naklimu imnekeh uli, waka?” ");
INSERT INTO apeB_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Ali amudak soldia hanu amaminu nebenali soldia hanu amudak anam henek was umu God ananitu nebetali wilpat uli hasuh Jisas howechikanu. ");
INSERT INTO apeB_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Howechikanu ali halik halawanamu Anas. Anas ananinu nugawineinu Kaiafas douk nape nanubu nebenali pris umu enyebuk yohlegul. ");
INSERT INTO apeB_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Anudak Kaiafas, likuk douk naklipu echech Juda echechim nebemi nakli enyen douk kalbamu atunu alman meyoh nugak umu nugakamu chunatimaguk elpech. ");
INSERT INTO apeB_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Douk hasuh Jisas halawanu hanak ali Pita nanu anudak ananu disaipel hagipechanu hanak. Anudak ananu disaipel, anudak nanubu nebenali pris douk nanubu nadukemanu kalbu. Douk nadukemanu namudak ali anan nanubu nanamu Jisas hawich numun anudak nebenali pris ananigu awagu. ");
INSERT INTO apeB_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Amam hawich wakuli Pita neyotuk aduk dua. Ali anudak disaipel douk nanubu nebenali pris nadukemanu kalbaluli wata natanamu naklipu okudak almatok kwonek was umu dua uli, ali nalau Pita hawich. ");
INSERT INTO apeB_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Hawich ali okudak almatok kwasalik Pita kwakli, “Ati nyak douk chopuk enenyu Jisas ananinyu disaipel?” Wakuli Pita nakli, “Wak, yek wak.” ");
INSERT INTO apeB_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Agagun douk nyuglus ali echech chenek moul agnabuk uli chanu amam henek was umu God ananitu nebetali wilpat uli chejigul eneh nyih ali cheyotu chalihi chalih umu hiyokech. Ali Pita douk chopuk nanech cheyotumu nyih hiyokanu. ");
INSERT INTO apeB_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Ali ababuk nyultab, anudak nanubu nebenali pris nape nasolik Jisas. Nasolikanamu apak ananipu disaipel manu enyudak balan douk nape nenek skulumu elpech umu. ");
INSERT INTO apeB_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Ali Jisas naklipanu nakli, “Yek yaklipech yekin balan ihech elpech yopugunmu atugun. Isave yenek skulumech gani numun apak Juda mautubal mape meyagwleh balan ogwi wilag gwanu numun banis agundak God ananitu nebetali wilpat tatawomu. Yaklipechen agundak manatimaguk Juda isave manaki mowachabal umu. Yek douk wo ibechuk enen balan iklipech chokubul anagun e, wak. ");
INSERT INTO apeB_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Nyak nyasalik yek umu moneken? Nyusolik echebuk douk chemnek yekin balan uli chuklipenyu. Echech douk chanubu chadukemen yek yaklipechen uli balan.” ");
INSERT INTO apeB_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Douk Jisas nakli namudak ali ananu nenek was umu God ananitu nebetali wilpat uli nogoulepanu. Ali nakli, “Nyak kobi nyuklipanu balan nebegun atugun anudak nanubu nebenali pris, wak.” ");
INSERT INTO apeB_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Wakuli Jisas nebemanu balan nakli, “Sapos yek ikli enen wo duldulin uli e balan umu, nyak nyuklipu chunatimaguk cheyotu agundak ulimu enyudak balan douk yek yaklien uli. Wakuli sapos yek wo ikli enen wo duldulin uli e balan umu e, ali nyak douk nyae meyoh umu moneken?” ");
INSERT INTO apeB_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Ali ababuk nyultab Anas nakagas Jisas nanamu nanubu nebenali pris Kaiafas abali, ohudak naduh douk howechik Jisas ananich loguh umu douk wata hwolu. ");
INSERT INTO apeB_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Saimon Pita douk wata neyotumu nyih ali echech chananu cheyotuli chasolikanu chakli, “Ati nyak douk chopuk enenyu Jisas ananinyu disaipel, waka?” Wakuli Pita nechegeyenyuk nakli, “Wak, yek wak.” ");
INSERT INTO apeB_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Ananu nenek moul meyoh umu nanubu nebenali pris uli douk nanu anudak kwigani Pita nobleyonu atah uli amam atup awilop. Douk anudak alman natik Pita ali nasolikanu nakli, “Ati dukwechuk douk yatulinyu nyanu Jisas peyotu nahabigu douk lowas oliv satawomu?” ");
INSERT INTO apeB_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Pita wata chopuk nechegeyenyuk anah alagun ali ahudak atuh owotu tanubu taitak tape teyagwleh. ");
INSERT INTO apeB_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Ali aglupil atul echech Juda chaitak chatukemaguk Kaiafas ananitu wilpat chalau Jisas chanak. Chalawanu chanamu Pailat douk nape nebenalimu gavman umu Judia uli ananitu wilpat. Agagun douk watak aglupil ali chakli wak umu chuwich numun wilpat, wak. Chakli kedeke chuwich ali God nutulich nukli chanobosusih ali echech eke kobi chuwak agundak woligun Pasova, wak. Namudak ali douk cheyotuk aduk. ");
INSERT INTO apeB_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Douk namudak ali Pailat naitak natogloli aduk ali nasolikech nakli, “Ipak douk pakli punekumanu moneken balan anudak alman?” ");
INSERT INTO apeB_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Ali echech Juda chakli, “Sapos anan kobi nunek enen yowenyi ele, apak deke kobi mulawanalimu nyak, wak.” ");
INSERT INTO apeB_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Echech chakli namudak ali Pailat naklipech nakli, “Ipak meyoh puhwanu ali punak punekumanu balan. Punekenyumanu kobi douk ipakin lo nyaklimu puneken umu echebuk douk chenek yowenyi ulimu.” Ali echech Juda chakli, “Ipak Rom pakli apak kobi mubo enen elpen nyugak, wak.” ");
INSERT INTO apeB_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Echech douk chakli namudak umu enen balan likuk Jisas naklien umu chonu nugak nil lowag kruse umu nyutoglu adulin atin. ");
INSERT INTO apeB_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Ali Pailat wata natanamu nanak nawich ananitu wilpat nape nasuh kwotog umu ali nohwalu Jisas nawich. Nawich ali nasolikanu nakli, “Nyak douk echech Juda echechinyu king?” ");
INSERT INTO apeB_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Ali Jisas nasolikanu nakli, “Enyudak balan douk nyak meyoh nyasalike waka enech chaklipenyomu yek ali dakio nyasalike?” ");
INSERT INTO apeB_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Ali Pailat nebemanu balan nakli, “Yek douk wak onowe Juda e, wak. Wakuli nyak nyenek moneken ali nyakichi chanu amam nebemi pris dakio chahwenyu chalawenyomali yek umu imnek nyakitu kwot?” ");
INSERT INTO apeB_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Ali Jisas nebemanu balan nakli, “Agundak yek yape nebewelimu yekichi elpech umu douk wo kobi apudak atapichi elpech isave chagimeh umu e, wak. Sapos yek ipe nebewelimu echech namudak ele, echudak cheneme moul uli deke chunek wanohw ali deke kobi chuhweli chunaki chiyolu echech Juda echechis wis, wak. Wakuli agundak yek yape nebewelimu yekich elpech umu douk wo kobi apudak atapichi elpech isave chagimeh umu e, wak.” ");
INSERT INTO apeB_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Ali Pailat nasolikanu nakli, “Namudak ali nyak douk enenyu king, waka?” Ali Jisas nakli, “Nyak nyakli wo, yek douk king. Yekik mamakik douk kweyalali ali yanaki apudak atap umu inek enyudak moul iklipech adulin atinyi balan. Iklipech ali chunatimaguk elpech douk isave chagipech aduligeinyi balan uli eke chugipech yekin balan. ");
INSERT INTO apeB_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Ali Pailat nasolikanu nakli, “Enyudak adulin atinyi balan douk moneken?” Pailat nakliyuk namudak ali naitak natoglu naklipu echech Juda nakli, “Yek wo igwatu enen anan neneken uli yowenyi e, wak. ");
INSERT INTO apeB_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Wakuli enen ipak padukemen uli pasin douk namudak. Ihech yohleguh ipak penek agundak nebeguni woligun Pasova umu, yek isave yokwechih ananu nonowechik nape kalabus uli natoglu nanak fri. Douk namudak ali ipak pakli wosik umu yek ikwechih anudak ipak Juda ipakinu king nunak fri o wak?” ");
INSERT INTO apeB_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Wakuli echech chohwalu nebegun chakli, “Wak, anabuk wak. Apak makli nyukwechihi Barabas nutoglomapali.” Anudak Barabas anan douk isave nenek wanohw ali nakwu alugwih atih uli. ");
INSERT INTO apeB_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Douk echech chakli namudak ali Pailat naklipu amam soldia habo Jisas hasakanu onoh naduh wip. ");
INSERT INTO apeB_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Hasakonu naduh umu julug, ali hadalech onoh puligwiluh hlatoglohwi naduh hadalechoh henekoh kobi ananu king ananitu hat umu ali hohwemumanu boglom. Ali chopuk henekumanu anah ouchibalihi lupah. ");
INSERT INTO apeB_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Douk henekumanu echudak iyuh ali hanak halakati hakli, “Luahep, nyak echech Juda echechinyu king” Haklipanu namudak ali hogoulepanu. ");
INSERT INTO apeB_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Douk amam hanu julug ali Pailat wata chopuk naitak natogloli anah alagun ali naklipech nakli, “Ipak tiki, yek douk eke ilawanali nutogloli aduk. Nutogloli ali ipak yet eke pudukemech umu yek douk wo igwatu enen yowenyi anan neneken uli e, wak.” ");
INSERT INTO apeB_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Ali Jisas naitak natogloli. Natogloli abali, ahudak ouchibalihi lupah douk holomanali. Puligwiluh hlatoglohwi naduh chopuk hwotemali ananim boglom ali natogloli. Douk natogloli ali Pailat naklipu echech Juda nakli, “Ipak tiki! Alman douk anudak.” ");
INSERT INTO apeB_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Douk natogloli amam nebemi pris hanu amudak henek was umu God ananitu nebetali wilpat uli hatulunu ali hohwalu nebegun hakli, “Nek nyilimumanu lowag kruse! Nek nyilimumanu lowag kruse!” Ali Pailat naklipam nakli, “Ipak yet puhwanu punak punek nyilimumanu lowag kruse. Yek douk wo igwatu enen yowenyi douk pakli anan neneken uli e, wak.” ");
INSERT INTO apeB_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Ali echech Juda chebemanu balan chakli, “Enen apakin lo seiwak God nakaguk Moses umu douk nyakli, elpen nyunek tok bilas umu God uli imas chen nyugak. Ali lo douk nyakli apak imas monu nugak. Umu moneken, anan nakli anan douk God ananinu nuganinu.” ");
INSERT INTO apeB_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Douk Pailat nemnek enyudak balan ali nanubu elgeinu nechalakuk agundak nalik elgeinamu. ");
INSERT INTO apeB_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Ali anan wata nalau Jisas hawich wilpat ali nasolikanu nakli, “Nyak meibuli wabulinyu?” Nasolikanu wakuli Jisas wo nubemanu balan e. ");
INSERT INTO apeB_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Ali Pailat naklipanu nakli, “Nyak nyakli wak umu nyune wiyagwleh umu moneken? Nyak douk nyadukemech. Yek douk yalau namba umu iken ikwechihenyu nyunak fri o iklipech chunek nyilimumenyu lowag kruse.” ");
INSERT INTO apeB_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Jisas nemnek ali nebemanu balan nakli, “Nyak douk God meyoh nakli wosik ali dakio nyalau enyudak namba umu nyunek daunimu yek. Wakuli anabuk douk nalawali yek umu nyak uli, anan douk nanubu nenek nebenyi yowenyi nyechalakuk enyudak douk eke nyak nyuneken uli.” ");
INSERT INTO apeB_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Douk Pailat nemnek enyudak balan ali nape natimu anah yah umu nukwechih Jisas nunak meyoh. Wakuli echech Juda chohwalu nebegun chakli, “Sapos nyak nyukwechih anudak alman nunak meyoh umu, orait nyak douk wo anudak nebenalimu gavman umu Rom uli Sisa ananinyu elpenyinu e, wak. Meinali alman douk nukli anan nape king uli, anabuk alman douk Sisa ananinu birua.” ");
INSERT INTO apeB_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Douk Pailat nemnek enyudak balan ali nalawali Jisas hatogloli aduk. Hatogloli ali nanak netemu enyudak sia douk jas netemu nape nasuh kwotog umu. Netemu enyudak sia agundak douk chohwalagun umu “Utabal Blakus Umu.” Tokples Arameik douk chakli, “Gabata.” ");
INSERT INTO apeB_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Ali ahabuk nyumnah, echech Juda douk chape chenek redimu kakwich umu wehluwih chunek agundak nebeguni woligun Pasova. Ali douk nyumnah toul, aun netemu olokohun ali Pailat naklipu echech Juda nakli, “Ipak tiki ipakinu king!” ");
INSERT INTO apeB_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Ali echech wata chohwalu nebegun chakli, “Laweyanaguk! Laweyanaguk! Punak punek nyilimumanu lowag kruse!” Ali Pailat nasolikech nakli, “Ipak pakli yek inek nyilimumu ipakinu king nil lowag kruse, waka?” Wakuli amam nebemi pris hebemanu balan hakli, “Anabuk douk wo apakinu king e, wak. Apakinu king douk nebenalimu gavman uli Sisa atunu!” ");
INSERT INTO apeB_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Douk chakli namudak ali Pailat nekech Jisas echechis wi