﻿USE sofia;
DROP TABLE IF EXISTS sofia.apb_vpl;
CREATE TABLE apb_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES apb_vpl WRITE;
INSERT INTO apb_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Ie uusu-uusu aana mo na'ohai weuwana a Jisas Kraes uure oto mai aana pongine a Ebraham lae mai hule aana a Deved Inemauri, na hunie a Jisas Kraes. ");
INSERT INTO apb_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","A Ebraham aamana Aesak, na a Aesak aamana Jekob, na a Jekob aamana Jiuda na mo mwane aasine, ");
INSERT INTO apb_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","na a Jiuda aamana Peres (aasine a Sera na nikadarue a Tama), na a Peres aamana Hesron, na a Hesron aamana Ram, ");
INSERT INTO apb_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","na a Ram aamana Aminadab, na a Aminadab aamana Nason, na a Nason aamana Salmon, ");
INSERT INTO apb_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","na a Salmon aamana Boas (nikana a Rehab), na a Boas aamana Obed (nikana a Rut), na a Obed aamana Jesi, ");
INSERT INTO apb_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","na a Jesi aamana Deved Inemauri. Na a Deved Inemauri aamana Solomon (nge e hute aana hu'e e to'o-to'o aana ka'u a Iuraea), ");
INSERT INTO apb_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","na a Solomon aamana Rihoboam, na a Rihoboam aamana Abaeja, na a Abaeja aamana Asa, ");
INSERT INTO apb_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","na a Asa aamana Jehosapat, na a Jehosapat aamana Joram, na a Joram aamana Iusaea, ");
INSERT INTO apb_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","na a Iusaea aamana Jotam, na a Jotam aamana Ehas, na a Ehas aamana Hesekaea, ");
INSERT INTO apb_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","na a Hesekaea aamana Manase, na a Manase aamana Amon, na a Amon aamana Josaea, ");
INSERT INTO apb_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","na a Josaea aamana Jekonaea na mo mwane aasine nge kire hute aana maholo mo Babilon kire laue mo Israel mwaanie i Jerusalem. ");
INSERT INTO apb_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Na a Jekonaea aamana Sialtiel aana maholo mo Israel kire ii'o wau aana aalahanga i Babilon, na a Sialtiel aamana Serababel, ");
INSERT INTO apb_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","na a Serababel aamana Abaeud, na a Abaeud aamana Elaeakim, na a Elaeakim aamana Aso, ");
INSERT INTO apb_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","na a Aso aamana Sadok, na a Sadok aamana Akim, na a Akim aamana Eliud, ");
INSERT INTO apb_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","na a Eliud aamana Eleasa, na a Eleasa aamana Matan, na a Matan aamana Jekob, ");
INSERT INTO apb_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","na a Jekob aamana Josep nge e to'o aana a Meri na a Meri nikana a Jisas, sailana uri a Kraes. ");
INSERT INTO apb_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Oto uure aana a Ebraham lae mai hule aana a Deved Inemauri, aawalai na'ohai hute-hutanga mwana hai. Na uure lo'u aana Deved Inemauri lae mai hule aana maholo mo maelonga kire toolea mo Israel hunie aalahanga ikire i Babilon, ngaeta aawalai na'ohai hute-hutanga mwana hai lo'u. Na ngaeta aawalai na'ohai hute-hutanga mwana hai lo'u, uure aana maholo mo Babilon kire toolea mo Israel hunie i Babilon lae mai hule aana maholo a Kraes e hute. ");
INSERT INTO apb_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Hutelana a Jisas Kraes e lae uurini. A Meri, nikana Jisas e haiholota'i huni to'o aana a Josep, ta'e i na'ona kirerue ke si ii'o ruru, a Meri ko hi'e-hi'e oto aani mwela aana Li'oa Maa'i. ");
INSERT INTO apb_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","A Josep mone nga mwane oodota'i, na e ka'a sare ha'amasaa ike keni ingeie a Meri i maana mwala, oto ko lo'o-lo'onga'i huni toli'aasie mola mwa-mwanoto maraana. ");
INSERT INTO apb_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Maholo a Josep ko lo'o-lo'onga'i ue urine, ensel a God ko si wa'araa hunie aani ma'ahu-polenga na ko te'uri, “Josep, iini o hute mai aana komu a Deved Inemauri, su'uri me'u huni to'o aana a Meri. Kele mwela nge ko hi'e-hi'e aana ngeena, e lodo aana Li'oa Maa'i. ");
INSERT INTO apb_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","A Meri kei ha'ahutaa kele mwela mwane, oto o ke haara'inie aana a Jisas, oolisilana uuri, ‘God ko ha'a-uuri.’ O ke haara'inie urine aena aana ingeie kei ha'a-uurie mwala ingeie mwaanie mo ooraha'aa ikire.” ");
INSERT INTO apb_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Mo ola ienini ko reu huni ha'a-oaie nga taa a God e unue aana propet uuri, ");
INSERT INTO apb_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Nga keni raori'i kei hi'e-hi'e aani mwela, na kei ha'ahutaa kele mwela mwane, na kire kei saie aana Imaniuel, ere-oolisilana uuri, “God pe'ikie.” ");
INSERT INTO apb_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Oto i purine ma'ahu-polenga ngeena, nge a Josep ko si to'o aana a Meri na ko deu i sulie nga taa ensel a God e unue hunie. ");
INSERT INTO apb_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","A Josep e lio i suli diana aana a Meri mala keni raori'i lai hule aana a Meri e ha'ahutaa kele mwela mwane ngeena. Oto a Josep e si haara'inie kele mwela mwane ngeena aana a Jisas. ");
INSERT INTO apb_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","A Jisas e hute i Betlehem aana po'o ni henue i Jiudia, aana maholo a Herod Inemauri Peine ko aalaha. Oto lo'u i purine a Jisas e hute, ngaeta mo mwane saenanau kire uure oto mai ha'atau i pwaalana sato, kire ko lae oto mai hule aana hanue paine i Jerusalem. Mo mwane ngeena kire tohungei saenanau i sulie lo'onga'inge aana mo hee'u ta'au i salo. ");
INSERT INTO apb_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Oto mo mwaena ko dolosi uuri, “?Kele wee-wee e hute i tei, iini nge kei aalaha haahi'omu mo Jiu? Melu lae oto mai huni pouruuru ni ha'ama'unge aana, aena aana melu leesie ho hee'u ingeie ta'au aana hanue i'emeelu i pwaalana sato.” ");
INSERT INTO apb_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Maholo a Herod e rongoa mo wala ngeena, ko tohungei tolahi'e oto liutaa, na ahutana mo Jerusalem kire ko tolahi'e oto no'one pe'ie. ");
INSERT INTO apb_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Oto e lokoa ahutana mo na'ohai pris na mo ha'a-uusuli aana mo Ha'atolanga a Mosis, ko dolosi aada uuri, “?A Kraes kei hute i tei?” ");
INSERT INTO apb_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Oto kire ko aalamie uuri, “A Kraes kei hute i Betlehem aana po'o ni henue i Jiudia. Aana ngaeta propet e uusue ka'u uuri, ");
INSERT INTO apb_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Betlehem aana po'o ni henue i Jiudia, mwaanie o lo'onga'inie uri o mwai-mwei. I'oe oto ngaeta na'ohai henue i Jiudia, aena aana nga na'ohai aalaha kei uure mwaani'o, iini huni na'ona mwala ineu, mo Israel.” ");
INSERT INTO apb_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Mango urine, a Herod e si soi mumuni aana mo mwane uure i pwaalana sato na ko heitale mwaanire maholo uri taa nge kire leesie ho hee'u ngeena. ");
INSERT INTO apb_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Oto ko uusunge'inire hunie i Betlehem pe'ie mei wala uuri, “Omu ke lae, na omu ke lai heitale diana hunie kele mwela ngeena, na maholo omu ko lio oodoie, omu ke aaliho'i mei ha'arongoau, hunie ineu no'one ne ke lai pouruuru ni ha'ama'unge aana.” ");
INSERT INTO apb_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","10","Purine mo mwane ngeena kire rorongo i sulie walana a Herod, kire si lae mwaanie, na kire ko lae oto hunie i Betlehem. Maholo na ikire ue i sulie tala, kire ko he'i leesie lo'u ho hee'u nge kire leesie ka'u ta'au i pwaalana sato. Mo mwane ngeena kire ko tohungei ilenimwa'e oto liutaa aana kire ko he'i leesie lo'u ho hee'u ngeena. Ho hee'u ngeena e lae i na'oda hule aana e lai ha'adau oto i hahona nume nge kele wee-wee aana. ");
INSERT INTO apb_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Maholo kire sili i nume na kire ko leesie kele wee-wee na nikana, a Meri, oto kire ko pouruuru i na'ona ni ha'ama'unge aana. I leune kire ko tahanie mo mwe'i ikire, na kire ko tahoa mo ola diana hali'ite mala kol na e ro taungei dango wau-wesu nge kire haara'inie frankinsens na mur, mo ola nge holiteni e paine hiito'o, na kire ko nii'i oto hunie. ");
INSERT INTO apb_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Purine leune e mango, kire si eeliho'i takoie hanue ikire. Ta'e kire ka'a liu ike lo'u i saana Herod, aena aana a God e unue oto hunire aani ma'ahu-polenga uri kire ke su'uri liu lo'u i saana. Oto kire lai liu aaopa mola mwaanie. ");
INSERT INTO apb_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Oto i purine mo mwane kire aaliho'i, ensel a God ko haata'i lo'u hunie a Josep aani ma'ahu-polenga na ko te'uri hunie, “A Herod kei lo'ohie kele wee-wee huni horo maesie. Ta'ela'i na o ke tahile'inie kele wee-wee na nikana oto hunie aalahanga mo Ijip, na omu ke ii'o ka'u weu i leune lai hule aana ne kei saronai unue lo'u huni'omu.” ");
INSERT INTO apb_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Oto a Josep e ta'ela'i pe'ie kele mwa'u na nikana i rodo, kiraelu ko tehi oto hunie i Ijip. ");
INSERT INTO apb_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Kire ii'o wau i leune lai hule aana a Herod Inemauri Peine e haro mae. Leune e rau huni ha'a-oaie nga taa a God e unue ka'u aana ngaeta propet uuri, Nou soie a kaleku mwaanie i Ijip. ");
INSERT INTO apb_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Maholo a Herod Inemauri Peine e saie uri saenanaunge mo mwane i pwaalana sato e liue oala'inge aaela ingeie, e tohungei saewasu oto liutaa. Oto e si lo'o-lo'onga'inie nga taa mo mwane i pwaalana sato kire ere-ere i sulie maholo nge kire hola'i leesie ho hee'u ngeena. Oto e si uusunge'inie mo ramo aana mae ingeie hunie i Betlehem na mo henue lo'u kara'inie, hunie kire ke horo mangoa ahutana mo mwela mwane kire si hute lae hule aana mo iini nge e ro halisi e mango oto aada. ");
INSERT INTO apb_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Oto nga taa nge a Propet Jeremaea e unue e to'ohuu oto, aana e unue uuri, ");
INSERT INTO apb_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Kire rongoa ngaranga oto paine aana huilume i Rama, ngaranga pe'i saehuunge oto paine, aana mo teite ni Jiu ko ngara-ngarasie mo kaleda. Saeda na e ka'a dodo oto, aana mo mwela ikire, kire ai'aa mango mwaanire. ");
INSERT INTO apb_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Purine a Herod Inemauri Peine e mae oto, ensel a God e haata'i lo'u hunie a Josep aani ma'ahu-polenga i Ijip, ");
INSERT INTO apb_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","na ko te'uri, “Ta'ela'i na o ke toolea kele mwa'u na nikana, na omu ke lae lo'u hunie aalahanga i Israel, aana mo iini kire dau-deu ni horo'ie kele wee-wee, kire mae oto.” ");
INSERT INTO apb_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Oto a Josep e ta'ela'i pe'ie kele mwa'u na nikana, oto kire ko lae lo'u hunie i Israel. ");
INSERT INTO apb_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Maholo a Josep e rongoa uri kalena a Herod Inemauri Peine, a Akeleas, ko aalaha lo'u aana po'o ni henue i Jiudia oolisie aamana, ko si tohungei me'u huni lae lo'u weu i leune. Ta'e a God e ha'ananaue a Josep aani ma'ahu-polenga, oto e si lae hunie po'o ni henue i Kalili, ");
INSERT INTO apb_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","ko lai ii'o aana huilume i Nasaret. Na nga taa mo propet kire unue e to'ohuu oto aana kire unue uuri, “Kire kei saie aana mwane ni Nasaret.” ");
INSERT INTO apb_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Oto aana maholona, a Jon Loto Maa'i e lae mai i laona hanuesala aana po'o ni henue i Jiudia, na ko aehota lae-laeliwala oto uuri, ");
INSERT INTO apb_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“Omu ke aali'u to'ohuu mwaanie ooraha'aa aena aana Aalahanga a God ko kara'ini oto mai.” ");
INSERT INTO apb_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","A Jon ingeie oto mwane nge a Propet Aesaea e ere-ere rarangana uuri, Nga iini ko soi-soi peine i laona hanuesala uuri, “Omu ke dau aakau aana tala loosie laenga mai a Aalaha, na omu ke ha'a-oodohie tala ni lae ingeie.” ");
INSERT INTO apb_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","A Jon e ho'o-ho'osie mola to'oni aaela kire asuie aana iihune kamel, na e ho'osie haahie danumana roroto'oni aani te'e-te'ei puluke. Na ngaulaa ingeie oto mo oru na mo ngingidue. ");
INSERT INTO apb_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Na mwala oto hunge kire uure oto i Jerusalem, na mwaanie ta'ena nga leu lo'u aana po'o ni henue i Jiudia, na oto ahutana mo henue kali-kelie wai peine i Jodan, na kire ko meni lai loo-loko i saana. ");
INSERT INTO apb_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Mwala ngeena kire ko ha'ahoue oto mo ooraha'aa ikire, oto a Jon ko si loto maa'i aada i laona wai peine i Jodan. ");
INSERT INTO apb_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Mwala hunge aana mo Parise na aana mo Sadiusi, ikire no'one kire lae mai saana hunie ke loto maa'i aada. Ta'e maholo a Jon e leesie urine, e si te'uri hunire, “!I'omu oto mo mwaa ala-ala! ?Omu ko lo'o-lo'onga'i uri mala omu ko loto maa'i ha'alaa, omu ko tehisie saewasunge a God nge kei lae maine? ");
INSERT INTO apb_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","!E aasa! Ta'e omu ke hungu eeni hue-huei ola diana i laona mau-meuringe i'omu huni haata'inie uri omu oonisae to'ohuu oto mwaanie ahutana mo ooraha'aanga i'omu. ");
INSERT INTO apb_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Na mwaanie omu lo'o-lo'onga'inie uri omu kei tehisie saewasunge a God, aena aana omu hute aana komu a Ebraham. Leune e sa'a pe'i'omu ike aana no ko unue huni'omu uri a God e sai hu'isie mola mo heu ienini hunie kire ke ne'i iinoni haalu hunie komu a Ebraham. ");
INSERT INTO apb_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Aana a God e urihana mwane e ne'i aakau oto aana hakesi i ae'aena mo ei, na mo ei nge kire ka'a hungu ike aani hue-huei ei diana, kei tohu aasi'i na aasileni kei lae i laona dunge. ");
INSERT INTO apb_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“Ineu no ko loto maa'i eemiu aani wei huni haata'inie uri omu oonisae oto mwaanie mo ooraha'aanga i'omu. Ta'e iini nge kei lae mai puriku, ingeie e paine lo'u liutaa aaku, hule aana ineu na nou ka'a diana malisine ne ke asu mala koni-konihe huni luhesie ho'ohaahi'ae ingeie. Ingeie ke si loto maa'i aana ngaeta mwala aana Li'oa Maa'i, na ngaeta mwala kei lotohire aana dunge ni ha'amotaahinge. ");
INSERT INTO apb_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Ingeie ni e to'o aana nanamanga huni leie ahutana iinoni. Aana e urihana iinoni nge ko ta'aasie mo hule-hulei kooni mwaanie mo tohungei ola. Oto ko si ne'i konie mo tohungei ola i lengine haa i laona nume ni duru ingeie. Ta'e mo hule-hulei ola aaela ngeena, nge kei uunu'i aana dunge nge e sa'a mwa'a lo'u.” ");
INSERT INTO apb_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Aana maholona a Jisas e uure i Kalili ko lae hunie i Jodan uri hunie a Jon ke loto maa'i aana. ");
INSERT INTO apb_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Ta'e a Jon ko sare uure honosie leune, oto ko te'uri, “E malisine uri i'oe ni o ke loto maa'i eeku. ?Ta'e e ue o ko si unue mola uri ineu ne ke loto maa'i eemu?” ");
INSERT INTO apb_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Oto a Jisas ko aalamie a Jon uuri, “Toli'aasie ke rau oto urine, hunie kure ke dau i sulie nga taa a God e saeto'o aana.” Oto aena aana a Jisas e ere urine, a Jon e si loto maa'i aana a Jisas. ");
INSERT INTO apb_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Maholo a Jon e loto maa'i mango aana a Jisas, a Jisas e si lae poi uure i reune wai, na i Lengi ko taha oto, na ko leesie oto Li'oa a God ko siho mai mala hiroikuu, na ko lae mai oo'a oto i lengine a Jisas. ");
INSERT INTO apb_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Na aana maholona no'one mei wala e uure mai ta'au i Lengi ko te'uri, “Hahu'ana kaleku ni ienini, na nou tohungei manata diana hunie, na no ko ilenimwa'e oto liutaa haahie.” ");
INSERT INTO apb_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Oto Li'oa Maa'i a God e na'ona lo'u a Jisas huni lae i laona hanuesala hunie a Satan kei malaahongana. ");
INSERT INTO apb_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","A Jisas e ii'o i laona hanuesala hunie hai aawalai hei dinge na hai aawalai hei rodo, na e ka'a hikana nga mei ngeulaa aana maholona, oto ko hiolo. ");
INSERT INTO apb_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Oto a Satan e lae mai saana na ko te'uri hunie, “Mala o ko ne'ie Kalena God to'ohuu, o ke unue mo heu ngeena ke ne'i bred.” ");
INSERT INTO apb_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Ta'e a Jisas e aalamie ko te'uri, “Mo Uusu-uusu Maa'i e unue uuri, Iinoni e sa'a mauri ike mola aani bred hahaiteli, ta'e walana a God ha'alaa ko meuri aana.” ");
INSERT INTO apb_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Oto a Satan ko he'i toolea lo'u a Jisas i Jerusalem, na ko lai ha'a-uuresie oto ta'au i lengine ho susumaa aana Nume Maa'i Peine, ");
INSERT INTO apb_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","ko si te'uri lo'u hunie, “Mala o ko ne'ie Kalena God to'ohuu, o ke toli'aasi'o uure i lengi i leu hunie o ke teke hao i aano. Aana mo Uusu-uusu Maa'i e unue uuri, A God kei uusunge'inie mo ensel ingeie hunie kire ke tala'ahua'o aana nimada, mwaanie ae'aemu e hite aana nga ho heu.” ");
INSERT INTO apb_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Oto a Jisas ko aalamie a Satan uuri, “Ta'e mo Uusu-uusu Maa'i e unue no'one uuri, Omu ke su'uri oohongie a God Aalaha i'omu.” ");
INSERT INTO apb_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Oto a Satan ko he'i toolea lo'u a Jisas hunie toloi henue e lai lengi liutaa, na ko haata'inie aana ahutana mo henue paine aana walumalau ie, na oto ta'ena nga ola manikulu'e aani. ");
INSERT INTO apb_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Na a Satan ko te'uri hunie a Jisas, “Mala uri o kei pouruuru ni ha'ama'unge aaku na o kei palo-paloau, nge ne kei niie ahutana mo ola ienini namue.” ");
INSERT INTO apb_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Oto a Jisas ko aalamie lo'u uuri, “Tahi mwaanieu Satan aana mo Uusu-uusu Maa'i e unue uuri, Omu ke palo-paloa mola ta'e a God Aalaha i'omu, na omu ke asu mola nana ta'e ingeie hali'ite.” ");
INSERT INTO apb_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Oto aana maholona a Satan e lae mwaanie a Jisas, na mo ensel ko si lae oto mai saana huni pe'ie. ");
INSERT INTO apb_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Maholo a Jisas e rongoa uri a Jon ingeie i laona nume ni ho'o, oto ko lae oto hunie po'o ni henue i Kalili. ");
INSERT INTO apb_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Aana maholona a Jisas e lai liu i Nasaret, oto e lai ii'o aana huilume i Kapaneam kara'inie Aasi I Kalili aana po'o ni henue e ro komu ni Jiu, a Sebulun na a Naptali. ");
INSERT INTO apb_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","A Jisas e lai ii'o i leune huni ha'a-oaie nga taa nge a Propet Aesaea e unue uuri, ");
INSERT INTO apb_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","16","Raa-raa e raa haahire mo iini aana po'o ni henue a Sebulun na a Naptali, na mo iini po'o i eesi aana wai i Jodan, na mo Aapoloa Aaopa aana po'o ni henue i Kalili. Mwala ngeena kire ii'o ka'u i laona rodohono na i mamalutana maenga, ta'e maholo ie, kire ko si leesie matapwanga paine. ");
INSERT INTO apb_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Uure aana maholona a Jisas e lai ii'o i Kapaneam, na ko aehota lae-laeliwala uuri, “Omu ke aali'u mwaanie mo ooraha'aanga i'omu aena aana Aalahanga a God ko kara'ini oto mai.” ");
INSERT INTO apb_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Maholo a Jisas e lae-lae i reune Aasi I Kalili na ko leesie e ro mwane wee-weesi, kirerue ko weesi aana hu'o. Ngaeta mwane oto a Saemon nge ruana nga sata ingeie a Pita, na a Andru, aasine. ");
INSERT INTO apb_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Oto a Jisas ko te'uri hunirerue, “More ke lae mai, na more ke lulu i sulieu hunie ne ke ha'asai'omore'i aana tolahai weesinganga hunie mo iinoni.” ");
INSERT INTO apb_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Oto e ro mwaasine ngeena ko tolana toli'aasie oto mo hu'o ikirerue, na kirerue ko lulu i sulie oto a Jisas. ");
INSERT INTO apb_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Oto maholo ko ada lo'u hao, na ko he'i leesie lo'u ngaeta ro mwaasine, a Jemes na Jon e ro kalena Sebedi. E ro mwaasine ngeena pe'ie aamadarue ikiraelu i laona iiola, kire ko seumaana hu'o ikiraelu. Oto a Jisas ko soie lo'u e ro mwaasine ngeena hunie kirerue ke lulu i sulie no'one. ");
INSERT INTO apb_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Oto lo'u mola aana maholona, e ro mwaasine ngeena kirerue ko toli'aasie oto aamadarue i laona iiola, na kirerue ko lulu i sulie oto a Jisas. ");
INSERT INTO apb_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","A Jisas e lae-lae kalie ahutana mo henue aana po'o ni henue i Kalili, pe'i ha'a-uusulinge i laona mo nume ni palo-palo mo Jiu, na pe'i taroha'inilana Tataroha Diana i sulie Aalahanga a God. Na e ha'a-uurie no'one ahutana mwala nge kire to'o aana ta'ena nga maelaa hai aaopa'i. ");
INSERT INTO apb_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Oto tataroha aana a Jisas e taro oto i sulie ahutana mo henue aana po'o ni henue i Siria. Oto mwala ko toolea oto mai mwala hunge pe'ie mo maelaa hai aaopa'i i saana a Jisas, mo iini sapesalunge e paine aana sapeda, na mo iini mo li'oa aaela nge aada, na mo iini kire ko kokoko'a, na ngaeta mo iini sapeda e mae mango oto. Ta'e a Jisas e ha'a-uurire mango. ");
INSERT INTO apb_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Na aana maholona mwala hunge ko si lae mai huni lae i sulie a Jisas, uure mwaanie i Jerusalem na mo po'o ni henue i Kalili na i Dekapolis na i Jiudia na aapa po'o ta'au aana wai i Jodan. ");
INSERT INTO apb_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Maholo a Jisas e leesie uri mwala hunge ko lae i sulie, oto ko hanetaa ta'au i lengine uuwo. Na maholo e ii'o i aano huni ha'a-uusuli, mo pwaarongoisuli ingeie kire ko meni loko oto mai saana. ");
INSERT INTO apb_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Oto a Jisas ko aehota ha'a-uusulire oto uuri: ");
INSERT INTO apb_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Deidehie mo iini nge kire saie uri kire saeto'o aana a God, aena aana Aalahanga a God oto to'olada. ");
INSERT INTO apb_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Deidehie mo iini nge kire ii'o ni saehuu, aena aana a God kei ha'adodoa taane saeda. ");
INSERT INTO apb_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Deidehie mo iini nge kire ko ha'amwai-mwei'ara, aena aana kire kei to'o aana oto mo ola diana a God e haiholota'i huni nii'i hunie mwala ingeie. ");
INSERT INTO apb_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Deidehie mo iini nge kire ko hiolo na kire ko maarou hunie oodo-oodonga, aena aana kire kei pote taane. ");
INSERT INTO apb_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Deidehie mo iini nge kire sai hei-aamasi, aena aana a God kei aamasire no'one urine. ");
INSERT INTO apb_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Deidehie mo iini nge saeda e rere'a na e manola, aena aana kire kei ii'o pe'ie a God. ");
INSERT INTO apb_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Deidehie mo iini nge kire ko esuie hanuelamanga, aena aana a God kei saire aana mo kalena. ");
INSERT INTO apb_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Deidehie mo iini nge mwala ko teunge'inire haahie oodota'inge, aena aana to'olada ni oto Aalahanga a God. ");
INSERT INTO apb_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Oto i'omu na mwala kei teunge'ini'omu no'one urine, na kire kei ere aaelasi'omu, na kire kei pwelu wala eero-eero no'one i lengimiu urine, aena aana omu ko lulu i sulieu, ta'e ma'alana e urine omu ke ile-ilenimwa'e mola. ");
INSERT INTO apb_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Omu kei ile-ilenimwa'e oto lo'u liutaa, aena aana waaitemiu e paine oto ta'au i Lengi. Na urine e haata'i diana aana uri omu urihana mo propet a God oto i na'o, aana mwala i na'o kire taunge'inire no'one urine.” ");
INSERT INTO apb_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Oto a Jisas ko he'i te'uri lo'u hunie mo pwaarongoisuli ingeie, “I'omu oto domana ahaa hunie mo iinoni aana walumalau ie. Ta'e omu ke saie uri dianaha'ana ahaa nge kei ei'aa mwaanie, o sa'a roro'a ni esuie lo'u hunie ke ahaala. Mala ko urine oto, na e ka'a diana ike lo'u hunie nga mei ola eena. Na aasilana kei lae oto mola i sulie tala na mwala kei uuri puli-pulisie oto.” ");
INSERT INTO apb_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Na a Jisas ko he'i te'uri lo'u, “I'omu oto domana raa-raa hunie mo iinoni aana walumalau ie. Hanue nge e ii'o i lengine uuwo, e sa'a hahu'ei mumuni ike mwaanie mwala huni leesie. ");
INSERT INTO apb_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Na maholo nga iini ko ha'akaunie nga laite, e sa'a pwaoha'inie ike nga nime haahie, ta'e kei ne'i haada'i aana hunie ke raangie ahutana mwala i laona nume. ");
INSERT INTO apb_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Oto i'omu, omu ke urine no'one. Raa-raa i'omu ke raangie ahutana mwala, hunie kire ke lio saie mo ola diana nge omu ko esui'i na kire ke soi ha'amanikulu'aa Aamamiu i Lengi i tehula'ani.” ");
INSERT INTO apb_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Oto a Jisas ko he'i te'uri lo'u, “Mwaanie omu lo'o-lo'onga'inie uri nou lae mai huni ta'aasie mo Ha'atolanga a Mosis, na mo ha'a-uusulinge mo propet. !Ha'ike! Nou ka'a lae ike mai huni ta'aasi'i, ta'e huni ha'a-oai'i. ");
INSERT INTO apb_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","To'ohuu no ko unue huni'omu uri kei hule aana i Lengi na i aano kei suu, na nga ta'a-ta'a kele nganga'ai ola aana mo Ha'atolanga a Mosis e sa'a roro'a ai'aa ike, hule aana kire kei haro oa mango. ");
INSERT INTO apb_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Oto mala nga iini ko heitohea nga ta'a-ta'a kele iini aana mo Ha'atolanga, na ko ha'a-uusulie ngaeta mwala huni heimaanie tolahai ola aaela ingeie, nge ha'a-uusuli aaela ngeena ha'amwai-mwei'alana kei lae aana Aalahanga a God. Ta'e nga iini nge ko lulu i sulie ahutana mo Ha'atolanga na ko ha'a-uusulie ngaeta mwala huni lulu i suli'i mala ingeie, nge ingeie ngeena ha'apaina'alana kei lae aana Aalahanga a God. ");
INSERT INTO apb_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Oto no ko unue huni'omu uri mala oodota'inge i'omu e ka'a paine liutaa aana oodo-oodonga mo Parise na mo ha'a-uusuli aana mo Ha'atolanga a Mosis, omu sa'a roro'a ni adona ike silinge i laona Aalahanga a God.” ");
INSERT INTO apb_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Oto a Jisas ko he'i te'uri lo'u, “Omu rongoa oto uri Ha'atolanga a Mosis e unue uuri, Mwaanie o talei horo maesie nga iini. Na nga iini ko talei horo, kire kei toolea i laona leinge. ");
INSERT INTO apb_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Ta'e ineu, no ko unue huni'omu uri mala nga iini ko saewasulie aasine, e malisine uri ke lae no'one mola i laona leinge. Na nga iini ko ere aaelasie aasine, nge e adona tolalana i na'ona pulitaa ni na'ohai pris hunie leilana. Na nga iini ko haara'i ‘Pweu’ aana aasine, nge kei lae i laona dunge ni ha'amotaahinge. ");
INSERT INTO apb_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Aena ngeena, mala o ko toolea mai uuraa'inge i'oe takoie ora ni uunu-uunu huni niie hunie a God, na o ko aamasito'o aana i leune uri aasimu ko saewasuli'o, ");
INSERT INTO apb_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","o ke tolana toli'aasie ka'u uuraa'inge i'oe i epine ora ni uunu-uunu, na o ke lae ka'u huni uure ruru pe'ie aasimu. Purine uure-rurunge ngeena e mango, o ke si lae mai niie uuraa'inge i'oe hunie a God. ");
INSERT INTO apb_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Na mala uri nga maelonga i'oe ko sare toole'o i laona leinge, o ke uure ruru oto lau-leu pe'ie maholo i'omore'i ue i sulie tala takoie nume ni lei-lei. Mala o ka'a te'urine, nge maelonga i'oe kei toli'aasi'o hunie mwane lei-lei na a lei-lei kei toli'aasi'o i nimana mo ramo, oto kire kei aasi'o i laona nume ni ho'o. ");
INSERT INTO apb_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","To'ohuu no ko unue oto huni'o uri o sa'a roro'a ni iisitaa ike na o ka'a saro su'u mangoa mei to'oha nge kire holosie huni'o.” ");
INSERT INTO apb_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Oto a Jisas ko lae pe'i ha'a-uusuli lo'u uuri, “Omu rongoa oto no'one uri Ha'atolanga a Mosis e unue uuri, Mwaanie o aeni ola. ");
INSERT INTO apb_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Ta'e ineu, no ko unue huni'omu uri nga iini nge ko to'omaaie mola nga keni pe'ie mei sae ni heri-hunilana, ingeie ngeena ko mesi oto hunie a keine wau i laona saena. ");
INSERT INTO apb_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Oto mala uri maamu ko ha'atataro'o hunie ooraha'aa, nge o ke kae aasie. Ma'alana maai ola diana i'oe, ta'e o ke aasie oto mwaani'o, aana e tohungei diana huni ta'aasie mola nga ta'a-ta'a kele leu aana sapemu liutaa aana ahutana sapemu ko lae ta'ingelu i laona dunge ni ha'amotaahinge. ");
INSERT INTO apb_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Na mala uri ki'imu ko ha'atataro'o hunie ooraha'aa, o ke lama mousie. Ma'alana ki'i ola diana i'oe, ta'e o ke aasie oto mwaani'o, aana e tohungei diana huni ta'aasie mola nga ta'a-ta'a kele leu aana sapemu liutaa aana ahutana sapemu ko lae ta'ingelu i laona dunge ni ha'amotaahinge.” ");
INSERT INTO apb_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Na a Jisas ko he'i te'uri lo'u, “Omu rongoa oto no'one uri Ha'atolanga a Mosis e unue uuri, Nga iini ko sare sikaa hu'e ingeie, ke hola'i niie nga uusu-uusu aani sike-hu'anga hunie hu'e ingeie, purine ke si toli'aasie. ");
INSERT INTO apb_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Ta'e ineu, no ko unue huni'omu uri nga iini ko sikaa hu'e ingeie na a hu'ena e ka'a masi pe'ie nga iini, ingeie ngeena ko si da oto hunie a hu'ena ke masi eena, aana kei to'o aana lo'u nga mwane aaopa. Na mwane nge kei to'o aana lo'u a hu'ena, ingeie no'one ko mesi.” ");
INSERT INTO apb_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Na a Jisas e unue lo'u, “Omu rongoa oto no'one uri Ha'atolanga a Mosis e unue uuri, Omu ke su'uri hei-heiholota'i eero-eero, ta'e omu ke dau i sulie to'ohuu nga taa omu heiholota'inie hunie a God aani tohenga. ");
INSERT INTO apb_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Ta'e ineu, no ko unue huni'omu uri su'uri tohe takoie nga mei ola aana omu ko heiholota'i. Su'uri tohe lo'u takoie i Lengi, aana naunekume a God ni otona. ");
INSERT INTO apb_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Su'uri tohe no'one lo'u takoie walumalau, aena aana a God no'one e to'o aana walumalau ie. Na omu ke su'uri tohe no'one takoie i Jerusalem, aana hanue a God no'one ni ngeena. ");
INSERT INTO apb_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Na lo'u su'uri tohe takoie pwaumiu, aana omu sa'a roro'a ni da ike nga ta'a-ta'a kele iihui pweu hunie ke rere'a wa ke pulu-pulu'e. ");
INSERT INTO apb_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Ta'e maholo omu ko heiholota'i, omu ke unue mola, ‘Iau, ne kei te'urine,’ wa ‘Ha'ike, nou sa'a te'urine ike.’ Mala omu kei unue lo'u nga mei ola aaopa, leu ngeena e uure oto mai mwaanie a Satan, iini ooraha'aa eena.” ");
INSERT INTO apb_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Na a Jisas ko he'i te'uri lo'u, “Omu rongoa oto no'one uri Ha'atolanga a Mosis e unue uuri, Nga iini ko waelie maana nga iini, kire kei waelie maana no'one urine. Na nga iinoni ko oie nga ta'a-ta'a niho aana nga iinoni, kire kei oie nihona no'one urine. ");
INSERT INTO apb_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Ta'e ineu, no ko unue huni'omu uri omu ke su'uri oolisie lo'u mei ola aaela nge ngaeta iinoni e asuie aamiu. Mala nga iini ko hidelie papali i pwalo-pwalomu, nge o ke toli'aasie ngaeta po'o ni papali lo'u hunie. ");
INSERT INTO apb_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Mala nga iini ko sare toole'o i laona leinge haahie to'oni ni eeluhi i'oe, toli'aasie no'one to'oni ni lengi i'oe hunie. ");
INSERT INTO apb_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Na mala nga ramo ko deu rarahi'o hunie o ke aanga'inie mo ola ingeie hunie nga ta'a-ta'a kilomita, o ke aanga'inie lo'u hunie ngaeta kilomita. ");
INSERT INTO apb_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Na mala nga iini ko sukaa nga mei ola aamu, o ke niie oto hunie. Na mala nga iini ko sare tola ha'awali ke'u aana nga mei ola i'oe, o ke toli'aasie mola hunie.” ");
INSERT INTO apb_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Oto a Jisas ko lae pe'i ha'a-uusuli lo'u uuri, “Na omu rongoa oto no'one uuri, ‘Omu ke manata diana hunie mo malahumiu, na omu ke ngiduupu hunie mo maelonga i'omu.’ ");
INSERT INTO apb_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Ta'e ineu no ko unue huni'omu uri omu ke manata diana no'one hunie mo maelonga i'omu, na omu ke aarea God talana mo iini ko taunge'ini'omu. ");
INSERT INTO apb_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Aana omu kei te'urine, nge omu ke si haata'inie uri i'omu oto mo kalena Aamamiu i Lengi. Ingeie nge ko nii-niie sato hunie ke pwaa haahie mo iinoni diana na mo iini aaela oto no'one. Na ko nii-niie nemo hunie mo iinoni oodota'i na mo iini ka'a oodota'i oto no'one. ");
INSERT INTO apb_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Oto mala omu kei manata diana mola hunie mo iini e manata diana huni'omu, a God e sa'a niie ike nga waaite huni'omu. Taungei ola urine hule aana mo iini aaela nge ko susulu to'oha hunie aalahanga ni Rom, na kire sai te'urine no'one mola. ");
INSERT INTO apb_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Na mala uri mo malahumiu ha'alaa omu ko ere takoire, e ka'a aaopa ike no'one mwaanie iinoni aaopa. I leune hule aana mo pu'o na kire sai te'urine no'one mola. ");
INSERT INTO apb_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Ta'e i'omu, omu ke tohungei diana oto ta'ingelu mala Aamamiu i Lengi e tohungei diana ta'ingelu.” ");
INSERT INTO apb_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Oto a Jisas ko he'i te'uri lo'u, “Omu ke lio talamiu, mwaanie omu deu-deu haada'i aana nga moi taa diana aana oodo-oodonga i'omu i maana mwala uri hunie kire ke leesi'i mola. Aena aana omu kei te'urine, omu sa'a roro'a hele aana ike nga waaite mwaanie Aamamiu i Lengi. ");
INSERT INTO apb_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Ta'ena nga maholo o ko niie nga mo ola hunie nga iinoni meitale, o ke su'uri deu haada'i lo'u aana uri hunie mwala ke saie, mala mo iini ko lupwe'i deu-deu nge kire ko lai eu'esuie i laona mo nume ni palo-palo, na i sulie mo tala paine, uri hunie mwala ke too-tooha'inire. To'ohuu no ko unue huni'omu uri mo iini nge kire ko tete'urine, kire hele mangoa oto waaitada. ");
INSERT INTO apb_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Ta'e i'oe, maholo o ko pe'ie nga iinoni meitale, o ke dau mumuni mola aana, mwaanie nga iinoni e saie lo'u, ma'alana nga tohungei malahumu diana. ");
INSERT INTO apb_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Hunie pe'inge i'oe ke mumuni, na Aamamu nge ko lee-leesi ola mumuni ke si waai'o taane haahie.” ");
INSERT INTO apb_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Na a Jisas e he'i te'uri lo'u, “Maholo omu ko aarenga'i omu ke su'uri deu mala mo iini ko lupwe'i deu-deu, nge saeda uri kire ke uure i laona mo nume ni palo-palo, na aani maai tala rue uri hunie mwala ke leesie kire ko aarenga'i. Ineu no ko unue huni'omu uri mo iini urine, kire hele mangoa oto waaitada. ");
INSERT INTO apb_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Ta'e maholo o ko aarenga'i, o ke lae ii'o mumuni maraamu i duru i'oe, o ke honoa maa, na o ke aarenga'i hunie Aamamu iini e ii'o mumuni. Na ingeie iini e sai lio saie nga taa o ko esu mumuni aana, ke si waai'o haahie. ");
INSERT INTO apb_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Na maholo omu ko aarenga'i, mwaanie omu talei ooni-ooni mola aana mo wala mwaakule mala mwala ni pu'o. Aana lo'onga'inge ikire uri mo aarenga'inge tewa ni rongo-hunileni kei lae. ");
INSERT INTO apb_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Omu ke su'uri heimaanie mo iini urine, aana Aamamiu e manata'inie oto nga moi taa omu saeto'o aani na omu ka'a suke ue aana. ");
INSERT INTO apb_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Ta'e omu ko aarea God omu ke aarenga'i uuri. Mama'a i Lengi, mwala ke ha'ama'u aana satamu. ");
INSERT INTO apb_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Aalahanga i'oe ke lae mai. Mo ola saemu eeni deuleni, asuileni ke lae oto i aano i leu mala oto i Lengi. ");
INSERT INTO apb_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","O ke niie mai huni'emi mo ngeulaa e adona si'iri. ");
INSERT INTO apb_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Na o ke sae'aasie huni'emi mo ooraha'aa i'emi, mala i'emi no'one emi ko sae'aasie mo roro'anga ikire mo iini ko deu hu'isi'emi. ");
INSERT INTO apb_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Na mwaanie o toli'aasi'emi huni ooraha'aa maholo malaahongalamami ko lae, ta'e o ke lio i suli diana aamami mwaanie Iini Ooraha'aa. ");
INSERT INTO apb_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Mala omu kei sae'aasie hunie ta'ena nga iinoni mo roro'anga kire ko deu hu'isi'omu eeni, nge Aamamiu i Lengi kei sae'aasie huni'omu mo ooraha'aanga i'omu. ");
INSERT INTO apb_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Ta'e mala omu ka'a sae'aasie hunie ta'ena nga iinoni mo roro'anga kire dau hu'isi'omu eeni, nge Aamamiu i Lengi e sa'a sae'aasie ike no'one mwaani'omu mo ooraha'aanga i'omu.” ");
INSERT INTO apb_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Oto a Jisas ko he'i te'uri lo'u, “Maholo omu ko oolongau, mwaanie omu nunuku dara mala mo iini ko lupwe'i deu-deu. Aana kire ko lupwe'i lio rahitou mola hunie mwala ke leesie uri kire ko oolongau. Ta'e ineu no ko unue huni'omu uri mo iini nge kire ko te'urine, kire hele mangoa oto waaitada. ");
INSERT INTO apb_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Ta'e i'oe, maholo o ko oolongau, o ke hodalie maamu na o ke arapasie pwaumu. ");
INSERT INTO apb_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Mwaanie mwala e lio saie uri o ko oolongau, ta'e Aamamu e ii'o mumuni mola ke saie. Na Aamamu ko lee-leesi ola mumuni, ke si waai'o i tehula'ana.” ");
INSERT INTO apb_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Mwaanie omu dudurue mo ola diana i'omu mei laona walumalau, leu mo kokorosi kei ngeu'i aana na kauwa'a kei waeli'i aana. Na mo iinoni peli-peli kire sai hoka'ie mola nume huni pelileni. ");
INSERT INTO apb_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Ta'e omu ke dudurue mo ola diana namiu i Lengi, leu mo kokorosi e sa'a ngau aana na kauwa'a sa'a waeli'i aana. Na i Lengi no'one nge e aasa hunie mo iinoni peli-peli kire kei hoka'ie nume hunie pelinge. ");
INSERT INTO apb_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Aena aana leu nge to'olamiu e ii'o aana, nge saemiu kei talei o'o'o no'one mola aana leune.” ");
INSERT INTO apb_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Oto maamu e urihana raa-raa hunie sapemu. Mala uri maamu e manola, nge ahutana sapemu kei matapwa oto. ");
INSERT INTO apb_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Ta'e mala maamu e ka'a manola, nge ahutana sapemu kei rorodo'a mola. Mala uri raa-raa i saemu ngeena kei ne'i rodohono, nge o ke si tohungei ii'o oto mola i laona rodohono eena. ");
INSERT INTO apb_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Na e urine lo'u aana nga ta'a-ta'a koni-konihe e sa'a roro'a asu susule'i ike nana nga ro poro paine hai aaopa'i. Aana kei manata diana mola hunie eetana nga iini, na kei ngiduupu hunie ruana nga iini, wa kei ha'ama'u mola aana ruana nga iini, na kei maaleledie eetana nga iini. Oto e tohungei aasa hunie omu kei ne'isae ha'ama'u aana a God na to'o-to'onga aana walumalau ie mala uri e ro poro paine i'omu.” ");
INSERT INTO apb_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Aena ngeena no ko unue huni'omu uri, mwaanie omu lae oto i tolahi'e hiito'o i sulie mei ngeulaa ni ngaa, na mei wei ni inu huni ha'amaurie sapemiu. Na omu ke su'uri tolahi'e liutaa no'one i sulie mei ola ni to'oni haahie sapemiu. Aena mauringe oto e roro'a liutaa aana ngaulaa, na sapemiu e roro'a liutaa aana to'oni. ");
INSERT INTO apb_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Omu ke leesie ka'u mo menu ko loo-loho hailiu ngeena. Kire ka'a au'esu hohola, wa uri kire ke so'o-so'okoni huni duru'i. Ta'e Aamamiu i Lengi ko ha'a-ha'angaure taane. !Ilisie i'omu mo iinoni! Omu roro'a liutaa aana mo menu i maana a God. ");
INSERT INTO apb_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Oto aana ma'alana omu ke lo'o-lo'onga'i liutaa lo'u i sulie mauringe i'omu, ta'e omu sa'a roro'a da ike mauringe ngeena ke tewa lo'u. ");
INSERT INTO apb_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Omu ke su'uri tolahi'e hiito'o no'one i sulie to'oni ni ho'osie i'omu. Omu ke leesie ka'u mo ei tataka nge kire ko pwito hailiu ngeena. Kire ka'a au'esu wa kire ke tau-teuri sala. ");
INSERT INTO apb_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Ta'e no ko unue huni'omu uri ma'alana a Solomon Inemauri e to'o-to'o liutaa na e sai to'oni aana mo to'oni manikulu'e, ta'e mo ei tataka ngeena kire ho'o sala lio diana liutaa aana. ");
INSERT INTO apb_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Mo ei tataka ngeena, mo ola ka'a o'o'o tewa ike no'one. Kire ko eehurara mola i matana ho'owa, na i seulehi kire ko nunulu oto lo'u, na mwala ko aasi'i mola i laona dunge. ?Oto mala a God ko ha'ato'onie mo takai ei ngeena, ohe omu unue uri a God e sa'a nii to'oni ike haahi'omu? !Hiiwalaimolinge i'omu e lae otoi mwei-mwei hiito'o! ");
INSERT INTO apb_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Oto omu ke su'uri tolahi'e liutaa i sulie mei ngeulaa ni ngaa, wa mei wei ni inu, wa mei ola ni to'oni aana. ");
INSERT INTO apb_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Mwala ni pu'o, ni kire ko lae otoi totolahi'e hiito'o i sulie mo ola urine. Ta'e i'omu, Aamamiu i Lengi e saie taane oto uri omu saeto'o aana mo olana. ");
INSERT INTO apb_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Ta'e omu ke ne'i-ne'isae aana Aalahanga a God na oodo-oodonga ingeie liutaa aana ta'ena nga ola mai aano, na ingeie ke si sapeie ta'ena nga ola huni'omu. ");
INSERT INTO apb_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Aena ngeena mwaanie omu lae oto i totolahi'e liutaa aana nga taa kei reu i ho'owa. Toli'aasie oto hunie i ho'owa mo ne'isaenga aana. Aana ahutana mo dinge e mani ado oto aani aaelanga aana.” ");
INSERT INTO apb_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Oto a Jisas e he'i te'uri lo'u, “Mwaanie omu talei lei-leie ta'ena nga iinoni, mwaanie a God e lei'omu no'one urine. ");
INSERT INTO apb_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Aena aana tolahai ola nge omu kei leie ngaeta mwala aana, a God kei lei'omu no'one aana. Na nga ha'atolanga uri taa nge omu ko leie mwala aana, ta'a-ta'a ha'atolanga ngeena no'one mola nge a God kei lei'omu aana. ");
INSERT INTO apb_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","?E ue ka'u o ko ili lio susulie kele nganga'ai ola oto mola mwai-mwei i maana aasimu? Ta'e hule aana i'oe, rotoi ei leku e eno honosie maamu na o ka'a sai hiinge'inie. ");
INSERT INTO apb_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Na e ka'a diana ike no'one uri hunie o ke unue hunie aasimu uuri, ‘Ka'u ne ke ta'aasie nganga'ai ola mwaanie maamu,’ na hule aana i'oe maraamu, rotoi ei leku no'one mola e eno honosie maamu. ");
INSERT INTO apb_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","!Nga hero-heronga ka'a urine ike! Mala uri o ko te'urine, nge o ko lupwe'i deu-deu mola ni ngeena. Ta'e o ke hola'i ta'aasie ka'u rotoi ei leku ngeena mwaanie maamu hunie maamu ke manola. Oto o ke si lio susulie kele nganga'ai ola i maana aasimu hunie o ke kae aasie.” ");
INSERT INTO apb_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Mwaanie omu nii-niie mo ola maa'i mala Tataroha Diana hunie mo iini kei heliwala mola hunie. Aana urine e urihana mola omu ko niie mo ola maa'i ana mo usu, oto kire kei eeli'u mola na kire kei alai'omu. Na e urihana no'one omu ko aasie mo ola diana i'omu mala mo dehi i saana mo poo, na kire kei uuri puli-pulisi'i mola aana ae'aeda.” ");
INSERT INTO apb_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Oto a Jisas e he'i te'uri lo'u, “Omu ke susuke aana a God, na ingeie kei niie huni'omu. Omu ke hai-heitalea i saana God, na omu kei lio oodoie. Na omu ke iiki-iiki i kolune maa ingeie, na kei tahanie maa talamiu. ");
INSERT INTO apb_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Aana ta'ena nga iini ko sukaa nga mei ola aana a God, nge kei niie oto hunie. Na ta'ena nga iini ko heitalea nga mei ola aana a God, kei lio oodoie oto. Na ta'ena nga iini ko iiki-iiki ikolune maa ingeie, nge a God kei taha maa talana oto. ");
INSERT INTO apb_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","?E ue aana i'omu mo mama'a wa mo teite? ?Mala uri kalemu kei sukaa nga mei ngeulaa aamu, o sai niie mola nga ho heu ana? ");
INSERT INTO apb_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","?Wa ko sukaa nga ho ii'e aamu, o sai niie mola nga mwaa ana? !Ha'ike! ");
INSERT INTO apb_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","I'omu mo iinoni ooraha'aa, ta'e hule aana omu sai niie mo ola diana hunie mo mwela i'omu. ?Ilisie Aamamiu i Lengi iini e diana liutaa aana ta'ena nga iinoni, uri e sa'a nii liutaa aana mo ola diana hunie nga mo iini ko suke aana? ");
INSERT INTO apb_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Mo ola nge saemiu mwala ke dau'i huni'omu, nge i'omu no'one omu ke dau'i hunie mwala. Aena aana lo'onga'inge aana ahutana mo Ha'atolanga a Mosis na ha'a-uusulinge mo propet ni otona.” ");
INSERT INTO apb_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Omu sai sili i laona Aalahanga a God mola sulie maai para mwai-mwei. Aana maai para hunie maenga e paine na tala takoie e aaroka, na mwala hunge kire ko lae oto i sulie. ");
INSERT INTO apb_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Ta'e maai para hunie maurihe huu e mwai-mwei na tala takoie e kokohisi, na toota'i iini mola kire kei lio oodoie.” ");
INSERT INTO apb_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Omu ke lio talamiu aana mo propet eero-eero, kire kei lae mai seemiu na kire kei lupwe'i deu mala mo sipu e rako-rako, ta'e i laona saeda, ikire mo wawaulo ni me'esu oto to'ohuu. ");
INSERT INTO apb_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Omu kei lio saire taane aana tolahada, mala walo kau-keu e sa'a hungu ike aana fik, wa puli-pulisi poo ke hungu aana grep. ");
INSERT INTO apb_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","E urine lo'u aana ta'ena nga ai diana kei hungu oto aani hue-huei ei diana, na ai aaela kei hungu oto aani hue-huei ei aaela hali'ite. ");
INSERT INTO apb_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Ai diana e sa'a roro'a hungu ike aani hue-huei ei aaela, wa ai aaela ke hungu eeni hue-huei ei diana ");
INSERT INTO apb_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Ta'ena nga ai e ka'a hungu eeni hue-huei ei diana, nge kire kei tohue na kire kei aasie i laona dunge. ");
INSERT INTO apb_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Aena ngeena omu kei lio saie mo propet eero-eero aana tolahada. ");
INSERT INTO apb_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“E ka'a ike ahutana mo iini ko unu-unue hunieu uuri, ‘!Aalaha ineu!’ uri kire kei meni sili i laona Aalahanga a God, ta'e mo iini ko deu i sulie saena Aamaku i Lengi ha'alaa. ");
INSERT INTO apb_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Aana dinge ooreta, mwala hunge kei unue hunieu uuri, ‘!Aaia, aalaha i'emi! Emi taroha'inie walana a God aana satamu, na emi oohe aasie mo li'oa aaela aana satamu, na mo hu'i-hu'ite hunge emi deu'i aana satamu.’ ");
INSERT INTO apb_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Oto aana maholona ne ke si unue mola hunire uuri, ‘Nou ka'a manata'ini'omu ike. !Tahi mwaanieu, i'omu mo iinoni ni ooraha'aa!’” ");
INSERT INTO apb_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Aena ngeena ta'ena nga iini ko rongoa walaku pe'i sulu i suli'i, e urihana iinoni saenanau e tohue nume ingeie aana e eli kokoro talana mo hunu, na e ne'ie mo heu i poo-pootana mo hunu aana nume ngeena. ");
INSERT INTO apb_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Oto lae-lae maholo kei talei nemosie, na kei kone ahuie, na ooru peine kei halolo aana nume ngeena, ta'e e sa'a aa'oho ike, aena aana poo-pootana e ii'o i lengine hau. ");
INSERT INTO apb_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","“Na ta'ena nga iini ko rongoa walaku na e ka'a sulu ike i sulie, ingeie e urihana iinoni e pweu nge e tohue nume ingeie mola i lengine oone mwaakule. E ka'a eli kokoro ike wa ke ne'ie mo heu ehuie mo hunu. ");
INSERT INTO apb_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Oto lae-lae maholo nemo kei nemosie, na kone kei kone ahuie, na ooru peine kei hite aana, oto kei aa'oho ta'ingelu oto i aano.” ");
INSERT INTO apb_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Maholo a Jisas e unu mangoa mo ola ienini, oto ahutana mwala ko meni pangata'inie mo ha'a-uusulinge ingeie, ");
INSERT INTO apb_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","aana ha'a-uusulinge ingeie e ka'a urihana ike mo ha'a-uusuli aana mo Ha'atolanga a Mosis, aana e ha'a-uusuli aana nanamanga. ");
INSERT INTO apb_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Maholo a Jisas e siho toli mei mwaanie uuwo, oto mwala hunge ko lae i sulie. ");
INSERT INTO apb_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Na ngaeta mwane maelaa ni osa aana e lae mai saana a Jisas, oto ko pouruuru i na'ona na ko te'uri, “Aalaha ineu, mala o ko mwa'e-mwa'e, o ke kuraa sapeku hunie ne ke rere'a adona ii'onga lo'u pe'ie mwala a God.” ");
INSERT INTO apb_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Oto a Jisas e si susue'inie wau nimana huni hele i sapena mwaena, na ko te'uri, “Iau, nou mwa'e-mwa'e taane. Sapemu ke mola oto.” Oto maelaa ni osa ngeena e tolana mango oto mwaanie. ");
INSERT INTO apb_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Na a Jisas ko si unue hunie a mwaena uuri, “Mwaanie o ha'a-ha'arongoa nga iini aana nga taa e rau. Ta'e o ke oodo mola i saana mo pris hunie kire ke saie uri sapemu e mola oto. Na o ke niie uuraa'inge hunie a God mala mo Ha'atolanga a Mosis e unue. Urine ahutana mwala kire ke si meni saie uri sapemu e mola oto.” ");
INSERT INTO apb_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Maholo a Jisas e lai aarapuu aana huilume i Kapaneam, ngaeta mwane paine aana mae ni Rom e lae mai saana, na ko eitanaie uuri, ");
INSERT INTO apb_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Aalaha ineu, koni-konihe ineu e eno mola i nume aana ko rarasi. Na ko tohungei sapesalu oto liutaa.” ");
INSERT INTO apb_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Oto a Jisas ko te'uri, “Ne kei lae taane huni ha'a-uurie hunie ke awaa.” ");
INSERT INTO apb_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Oto na'ohai mwane aana mae ngeena ko te'uri, “!Ha'ike, aalaha ineu! Nou ka'a malisine ike uri o ke lai sili i nume ineu, ta'e o ke unue mola nga mei wala na koni-konihe ineu kei awaa oto. ");
INSERT INTO apb_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Aana ineu na nou ii'o no'one i mamalutana nanamanga ngaeta mo poro paine, na nou to'o aana no'one mo ramo i meluteku. Na mala no ko unue hunie nga ramo uuri, ‘Lae wau,’ na ko lae oto wau. Na mala no ko unue hunie ngaeta ramo uuri, ‘Lae mai,’ na ko lae oto mai. Na mala no ko unue hunie koni-konihe ineu uuri, ‘O ke asuie mei esunge waune,’ na ko esuie oto.” ");
INSERT INTO apb_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Maholo a Jisas e rongo urine, e si pangata'inie na ko te'uri hunie mo iini ko lae i sulie, “To'ohuu no ko unue huni'omu uri nou ka'a lio oodoie ike ue nga mwane ni Israel ke hiiwalaimoli eeku mala mwane ni Rom ie. ");
INSERT INTO apb_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Oto no ko unue huni'omu uri mo Aapoloa Aaopa hunge kei lae mai uure i pwaalana sato na i suulana sato, na kire kei ii'o i aano huni ngeu pe'ie a Ebraham, na Aesak, na Jekob aana Aalahanga a God. ");
INSERT INTO apb_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Ta'e mo Jiu nge a God e lio hilisire ka'u oto i na'o hunie aalahanga ingeie, aasilada kei lae mola sinaha i laona rodohono. Na kire kei ii'o ni saehuunge mola pe'ie ngaranga.” ");
INSERT INTO apb_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Oto a Jisas ko si unue hunie na'ohai mwane aana mae ngeena uuri, “Aaliho'i ta'i nume i'oe, na nga taa o hiiwalaimoli aana, kei oa oto huni'o.” Na oto mola aana maholona, koni-konihe ingeie e tolana awaa oto. ");
INSERT INTO apb_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Maholo a Jisas e lai hule aana nume a Pita, na ko leesie keni hungaona e eno aana ko tohungei mata'i oto hiito'o. ");
INSERT INTO apb_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Oto a Jisas e hele i nimana, na ko tolana awaa oto aana maholona. A keine e ta'ela'i, na ko rareta'inie oto a Jisas. ");
INSERT INTO apb_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Oto aana maholo ko seulehi oto, kire ko si toolea mai mo iini hunge mo li'oa aaela aada i saana a Jisas. Oto a Jisas e si oohe aasie mo li'oa aaela ngeena mola aani wala, na e ha'a-uurie mo iini ko mweri. ");
INSERT INTO apb_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Nga taa a God e unue hunie a Propet Aesaea e si oa i leune, aana e unue uuri, Ingeie mone e ta'aasie mo maelaa ikie, na e ha'amangoa ta'ena nga mwaringe mwaanikie. ");
INSERT INTO apb_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Maholo a Jisas e saie uri mwala hunge ko ruru mei saana, oto e unue hunie mo pwaarongoisuli ingeie uri kire ke aatoholo i reune Aasi I Kalili aana aapa po'o wau. ");
INSERT INTO apb_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Oto ngaeta ha'a-uusuli aana mo Ha'atolanga a Mosis e lae mai saana na ko te'uri hunie, “Ha'a-uusuli, nou mwa'e-mwa'e ni lulu i suli'o aana ta'ena nga leu o ko lae aana.” ");
INSERT INTO apb_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Oto a Jisas e aalamie ko te'uri, “Mo usu ni me'esu na hule aana kire to'o liwe ni ma'ahu ikire, na mo menu lo'u kire mani to'o niu'i taane no'one, ta'e ineu a Kale Ni Iinoni hule aana nga leu ni mamalo ineu na ha'ike lo'u.” ");
INSERT INTO apb_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Oto ngaeta iini lo'u hikana mwala ko lulu i sulie ngeena ko te'uri hunie, “Poro paine, o ke hola'i toli'aasieu ke'u hunie ne ke lai heitolinge'inie aamaku.” ");
INSERT INTO apb_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Oto a Jisas ko te'uri hunie, “Ha'ike, ta'e o ke lulu i sulieu oto molana, na mwaanie o maa'oohie mo tolahi'anga ni welumalau kei mango nge o ke si lulu i sulieu.” ");
INSERT INTO apb_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Oto a Jisas na mo pwaarongoisuli ingeie kire mani ta'elie iiola, kire si lae. ");
INSERT INTO apb_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Maholo kire ko kele lae mola su'u weu i laona aasi, na paineha'ana mawasidengi ko tolana hite aada oto. Aahe ko seu aaelasire oto, hule aana iiola na ko kara'i dodo oto, ta'e a Jisas ko ma'ahu mola. ");
INSERT INTO apb_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Oto mo pwaarongoisuli ingeie kire ko ha'alioa na kire ko te'uri hunie, “!Ha'a-uusuli, o ke ha'a-uurikolu! !Kolu ko kara'i mae oto!” ");
INSERT INTO apb_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","A Jisas ko aalamire uuri, “?E ue ni oto omu ko me'u urine? !Hiiwalaimolinge i'omu e lae otoi o'oru'e liutaa!” Oto e si ta'ela'i ko ere aana ooru na aahe hunie kire ke mamalo. Oto e si lae mola wai aange hoolaa. ");
INSERT INTO apb_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Mo pwaarongoisuli ingeie ko tohungei pangata'i, na kire ko unue, “?Nga iinoni uri taa ni ie? Hule aana ooru na aahe na kire ko rongo hunie walana.” ");
INSERT INTO apb_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Maholo a Jisas e lai aarapuu aana po'o ni hanue mo Kadara, aana po'o ni eesi i Kalili po'o ta'au, ko oodoie e ro mwane kirerue uure mwaanie mo kilipwe'u. E ro mwane ngeena mo li'oa aaela aadarue na kirerue sa'a lio aasie ike nga iini ke liu aana tala ngeena. ");
INSERT INTO apb_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Oto kire ko uulo oto paine uuri, “?Kalena a God, o ko kotahi'emi huni taa? ?Uri o lae mola mai huni ha'aloi'emi, na e ka'a hule ue aana maholo hunie?” ");
INSERT INTO apb_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Na paineha'ana amaa ni poo ko susude i hoorada i leune. ");
INSERT INTO apb_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Oto mo li'oa aaela ngeena kire ko eitanaie a Jisas uuri, “Mala o ko oohe aasi'emi, o ke toli'aasi'emi ke lae i laona amaa ni poo ta'aune.” ");
INSERT INTO apb_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Oto a Jisas ko unue hunire uuri, “!Omu ke lae!” Oto kire iisitaa, kire si lai sili i laona mo poo. Oto amaa ni poo ngeena kire mani loutaa pwau i aano i sulie uuwo na kire lai pola tala oto aana mao'i hunie i eesi, na kire ko meni inu oto. ");
INSERT INTO apb_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Oto mwala e lio-lio i sulie mo poo ngeena, kire tahi lai hule i henue, na kire ko taroha'inie oto nga taa e rau aana e ro mwane nge mo li'oa aaela i saedarue. ");
INSERT INTO apb_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Oto ahutana mwala aana huilume ngeena kire ko si lae honosie a Jisas. Maholo kire leesie a Jisas, kire ko meni eitanaie oto hunie uri ke lae mwaanie taitelihana hanue ikire. ");
INSERT INTO apb_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Oto a Jisas e ta'elie iiola ikire na ko aatoholo aaliho'i lo'u takoie hanue ko o'o'o aana i Kapaneam. ");
INSERT INTO apb_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","E hule ta'au, oto kire aanga'inie mai ngaeta mwane e rarasi i lengine hulite i saana. Oto a Jisas e leesie hiiwalaimolinge ikire e paine, ko si te'uri hunie mwane e rarasi ngeena, “Kaleku, saemu ke dodo. Mo ooraha'aa i'oe sae'aasileni e lae oto.” ");
INSERT INTO apb_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Oto ngaeta mo ha'a-uusuli aana mo Ha'atolanga a Mosis ko te'uri hunire maraada, “!Ha'ike eena! A mwane ie ko ere tooha'inie uri ingeie e paine lo'u mala a God.” ");
INSERT INTO apb_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","A Jisas e saie oto nga taa kire ko lo'o-lo'onga'inie, oto ko si te'uri hunire, “?E ue nge omu ko lo'o-lo'onga'i aaela urine? ");
INSERT INTO apb_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Omu saie ka'u uri erenga ni mola e mwada'u na ta'ena nga iini e sai ere mola uuri, ‘Mo ooraha'aa i'oe sae'aasileni e lae oto.’ Na lo'u uuri, ‘!Ta'ela'i! O ke toolea hulite i'oe, na o ke lae-lae oto.’ Ta'e huni esuie e ro mei ne'isaenga ngeena kire aasa oto hiito'o hunie iinoni. ");
INSERT INTO apb_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Ta'e ineu, a Kale Ni Iinoni, ne kei esuie mola mei ola hunie omu ke lio saie uri ineu, nou to'o aana no'one nanamanga huni sae'aasi ooraha'aa mai aano i leu.” Oto a Jisas e si te'uri hunie mwane e rarasi ngeena, “!Ta'ela'i! O ke toolea hulite i'oe, na o ke lae-lae oto i nume i'oe.” ");
INSERT INTO apb_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Oto a mwaena e ta'ela'i na ko lae oto i nume ingeie. ");
INSERT INTO apb_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Maholo mwala kire leesie urine, oto kire ko si me'u, na kire ko ha'amanikulu'aa God aana e niie nanamanga urine hunie mo iinoni. ");
INSERT INTO apb_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Maholo a Jisas ko si kele lae mola ta'au mwaanie leune na ko leesie nga mwane satana a Matiu, e ii'o aana leu ingeie huni totola to'oha aana takis hunie aalahanga ni Rom. Oto ko te'uri hunie a Matiu, “O ke lulu i sulieu.” Oto a Matiu e ta'ela'i ko si lulu i sulie. ");
INSERT INTO apb_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Oto maholo a Jisas na mo pwaarongoisuli ingeie kire lae huni ngeu pe'ie a Matiu, na hungelana mwala susulu to'oha hunie aalahanga ni Rom mala a Matiu, na mo iini hunge aana mwala ooraha'aala, kire ko lae no'one mai huni ngeu tararuru pe'ire. ");
INSERT INTO apb_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Ngaeta mo iini aana mo Parise e leesie urine, oto kire ko upwesie mo pwaarongoisuli uuri, “?E ue nge ha'a-uusuli i'omu ko ngeu na ko inu pe'ie mo iinoni ooraha'aala mala mo mwane susulu to'oha ngeena?” ");
INSERT INTO apb_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","A Jisas e rongo urine e si aalamire uuri, “Iinoni nge e awaa mola sa'a saeto'o aana ike mwane kure-kure, ta'e iini nge ko maelaa'a ha'alaa. ");
INSERT INTO apb_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Oto omu ke haitalea lo'u e ue ni mo Uusu-uusu Maa'i e unue uuri, Nou ka'a hari hunie ike uunu-olanga, ta'e aamasinge hunie mo iinoni. Aana nou lae mai huni haaraie mo iinoni ooraha'aa ke oonisae, na nou ka'a lae ike mai huni haaraie mo iini kire unue kire diana oto.” ");
INSERT INTO apb_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Oto mo pwaarongoisuli a John Loto Maa'i kire lae mai saana a Jisas na kire ko dolosi aana uuri, “?E ue ka'u nge i'emeelu na mo Parise, melu ko oolo-oolongau tarau, ta'e mo pwaarongoisuli i'oe nge kire ka'a sai oolongau?” ");
INSERT INTO apb_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","A Jisas e aalamire uuri, “?Mo malahune a poro haalu kire kei saehuu uri taa na kire ko ngeu-ngeu ue aana ngauhe ni ha'arurunge na a poro haalu e ii'o ue pe'ire? Ta'e kei hule aana hai dinge nge kire kei toolea poro haalu mwaanire, nge kire ke si oolongau taane.” ");
INSERT INTO apb_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Oto a Jisas ko he'i unue lo'u mei wala ni aalahuunge ie i sulie ha'a-uusulinge haalu ingeie hunire uuri, “Nga iini e sa'a lo'amenaa ike nga to'oni lalahu'e aana nga mei lo'amena haalu. Aana maholo ko hodalie, nge mei lo'amena haalu ngeena kei mwai-mwei na kei hakasie mola to'oni lalahu'e, oto ke si haka aaela lo'u mwaanie hola'ina'o. ");
INSERT INTO apb_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Na lo'u nga iini e sa'a dedeie ike waen haalu i laona mo ate'a lalahu'e huni ne'i-ne'i waen nge kire asui'i aana te'e-te'ena nanikot. Aena aana maholo waen haalu ngeena kei madoro, ko da mo ate'a lalahu'e ngeena ko po'o, oto kire sai hoka, na waen kei waeta'i oto na mo te'e-te'ei ola ngeena kei aaela oto no'one. Ta'e kire kei dedeie waen haalu i laona mo ate'a te'e-te'ei nanikot haalu ha'alaa kire ke si meni ii'o diana.” ");
INSERT INTO apb_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Na maholo a Jisas ko ere-ere ue urine hunire, ngaeta mwane paine aana mo Jiu e lae mai saana, na ko pouruuru i na'ona na ko te'uri, “Kele pule ineu e si mae oto molana, ta'e o ke lae ka'u mei na o ke hele i sapena aana nimemu na kei meuri oto.” ");
INSERT INTO apb_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Oto a Jisas e ta'ela'i ko lae i sulie, na mo pwaarongoisuli ingeie oto no'one pe'ie. ");
INSERT INTO apb_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Na ngaeta hu'e apu raha-raha ko seunie oto hunie aawalai helisi mwana rue, ko lae poi purine a Jisas, na ko kopi mumuni aana ngongo'ana to'oni ingeie. ");
INSERT INTO apb_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","A hu'ena e te'urine aena aana e hiiwalaimoli uri ma'alana ko kele kopi mola aana to'oni a Jisas, na kei awaa oto. ");
INSERT INTO apb_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","A Jisas e aali'u na ko leesie a hu'ena, oto ko te'uri hunie, “Kaleku saemu ke dodo, hiiwalaimolinge i'oe e ha'a-uuri'o oto.” Oto a hu'ena ko tolana awaa oto mwaanie maelaa ni epu aana maholoi satona. ");
INSERT INTO apb_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Oto a Jisas e lai hule aana nume mwane paine ngeena, na ko leesie mwala ko uuhi-uuhi eu aani saehuunge, na ahutana mwala ko talei e'engo oto mola. ");
INSERT INTO apb_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Oto ko si te'uri hunire, “Omu ke lae i sinaha. Kele pule ie e ka'a mae ike, ta'e ko ma'ahu mola.” Oto kire ko mwesi mola mwaanie. ");
INSERT INTO apb_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Na e haro oohera mango, e si sili weu i duru a pulena, na ko hele i nimana. Oto a pulena ko ta'ela'i oto. ");
INSERT INTO apb_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Na tataroha aana mei olana ko si taro ahusie oto ahutana po'o ni henuena. ");
INSERT INTO apb_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Oto aana maholo a Jisas ko lae ta'au mwaanie numena, e ro mwane kire ulu ko aehota lae i sulie pe'ie soinge uuri, “!Kalena Deved Inemauri, o ke aamasi'emere'i!” ");
INSERT INTO apb_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Oto a Jisas e lai sili i nume, e ro ulune kirerue ko si lae mai saana. Na a Jisas ko dolosi aadarue uuri, “?Uri more hiiwalaimoli taane aana nou sai ha'a-uuri'omore'i?” Oto kirerue ko aalamie uuri, “Iau, Aalaha, mere hiiwalaimoli oto.” ");
INSERT INTO apb_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Oto a Jisas e hele wau aana maadarue na ko te'uri, “Leune ke rau oto mala hiiwalaimolinge i'omore'i.” ");
INSERT INTO apb_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Oto maadarue ko tolana lio-lio lo'u. Na a Jisas ko ere aadarue, ko te'uri, “Su'uri ha'arongoa nga iini aana mei ola ienini.” ");
INSERT INTO apb_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Ta'e kirerue lae, oto kirerue ko si lai taroha'inie mola i sulie ahutana po'o ni henuena nga taa a Jisas e asuie aadarue. ");
INSERT INTO apb_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Maholo e ro mwane ko iisitaa ta'au, ngaeta mwala ko toolea lo'u mei saana a Jisas mwane e ka'a sai ere aena aana li'oa aaela nge aana. ");
INSERT INTO apb_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Oto a Jisas e oohea li'oa aaela ngeena mwaanie a mwaena, na a mwaena ko si ere taataha oto. Ahutana mwala kire leesie urine kire ko si meni pangata'inie, kire ko te'uri, “Uure oto mai waite, nga mei ola urine kie ka'a leesie ue mai Israel.” ");
INSERT INTO apb_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Ta'e mo Parise kire ko unue mola uuri, “!Iiei! Na'ohana mo li'oa aaela ni mola e niie nanamanga ngeena hunie huni oohe aasie mo li'oa aaela.” ");
INSERT INTO apb_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","A Jisas e lae pe'i maatolie ahutana mo huilume aana po'o ni henuena. Na e lae pe'i ha'a-uusuli i laona mo nume ni palo-palo mo Jiu aani laeliwalanga aana Tataroha Diana i sulie Aalahanga a God, na e ha'a-uurie mwala pe'ie ta'ena nga taungei maelaa oto mola. ");
INSERT INTO apb_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Oto e lae pe'i leesie mwala na saena ko si huu pe'i aamasilada, aana si'oha'ada e paine na kire tatanga hailiu mola mala mo sipu nge nga iini huni lio i suli'i ha'ike. ");
INSERT INTO apb_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Oto ko unue hunie mo pwaarongoisuli ingeie uuri, “So'okoninge e paine hiito'o, ta'e mwala au'esu ka'a hunge ike huni so'okoni. ");
INSERT INTO apb_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Omu ke aitanaie iini e to'o aana hohola hunie ke uusunge'inie lo'u mei nga mwala au'esu huni so'okoni nana.” ");
INSERT INTO apb_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Oto e haaraie mai aawalai pwaarongoisuli mwana rue ingeie i saana, na ko niie nanamanga e saka hunire hunie kire ke oohe aasie ahutana mo li'oa aaela na huni ha'a-uurie mwala pe'ie ta'ena nga maelaa hai aaopa'i. ");
INSERT INTO apb_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Ie satana aawalai hurula'aa mwana rue: Eetana a Saemon (haara'inilana lo'u a Pita), na a Andru (aasine a Saemon), na a Jemes (kalena Sebedi), na a Jon (aasine a Jemes), ");
INSERT INTO apb_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Na a Pilip, na a Batolomiu, na a Tomas, na a Matiu (mwane e susulu to'oha aana takis nana aalahanga ni Rom), na ngaeta Jemes lo'u (mwane kalena a Alpeas), na a Tadeas, ");
INSERT INTO apb_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","na ngaeta Saemon lo'u (ngaeta iini aana pulitaa nge ko sare haiseuni huni ta'aasie aalahanga ni Rom mwaanie hanue i Israel), na a Jiudas Iskariot (iini nge e pweloa a Jisas). ");
INSERT INTO apb_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Aawalai mwane mwana rue ienini a Jisas e uusunge'inire pe'ie mo ha'ananaunge uuri, “Mwaanie omu lae-lae i saana mo Aapoloa Aaopa, wa i saana mo Samaria. ");
INSERT INTO apb_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Ta'e omu ke lae i saana mo sipu e takalo ka'u, mwala ni Israel. ");
INSERT INTO apb_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Omu ke lae pe'i laeliwala aana Aalahanga a God ko kara'ini oto mai. ");
INSERT INTO apb_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Omu ke ha'a-uurie mo iini ko mweri, omu ke ta'ea lo'u mo iini e mae oto, omu ke ha'a-uurie mo iini ko sapesalu aana maelaa ni osa, na omu ke oohe aasie mo li'oa aaela. Omu hele mwaakule ka'u, na omu ke nii mwaakule lo'u. ");
INSERT INTO apb_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Mwaanie omu too-toolea nga mei to'oha i laona mo mwe'i i'omu. ");
INSERT INTO apb_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Na mwaanie omu too-toolea lo'u nga mwa'i aana omu ko lae aani laeha, wa nga ro to'oni, wa nga ro ho'ohaahi'ae, wa nga apa'a. Aana e diana hunie mwala ke pe'i'omu, aana iinoni au'esu e malisine uri nga taa e saeto'o aana niilana kei lae hunie. ");
INSERT INTO apb_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Oto maholo omu ko lai aarapuu aana nga hanue, omu ke lio hunie a tei kei tola koni'omu, na omu ke ii'o ka'u mola pe'ie hule aana omu kei lae lo'u mwaanie hanuena. ");
INSERT INTO apb_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Na maholo omu ko lai sili i laona nga nume, omu ke ha'adiana'ara uuri, ‘Hanuelamanga ke ii'o pe'i'omu.’ ");
INSERT INTO apb_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Mala mwala aana numena ko tola koni'omu, hanuelamanga ke oore pe'ire, ta'e mala kire ka'a tola koni'omu oto, kire sa'a hele aana ike hanuelamanga omu unue ngeena. ");
INSERT INTO apb_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Na mala uri nga hanue ka'a tola koni'omu oto, wa kire ke rongo huni'omu, nge omu ke lae mwaanie hanuena, na omu ke tataa'inie mo wasa-wasa mwaanie ae'aemiu, domana uri nga ha'apasunge hunire uri a God kei ha'aloire. ");
INSERT INTO apb_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","No ko unue oto huni'omu, aana dinge ni leinge, ha'aloilana mwala aana huilume ngeena kei aaela lo'u hiito'o liutaa aana ha'aloinge nge kei lae hunie mwala tata'ala aana e ro huilume i Sodom na i Komora.” ");
INSERT INTO apb_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Oto a Jisas ko he'i te'uri lo'u hunie mo hurula'aa, “Omu ke rongo ka'u. No ko uusunge'ini'omu i matolana mwala e ooraha'aa, na saeda huni horo'i'omu mala mo wawaulo ni me'esu ko seunie mo sipu. Aena ngeena omu ke saenanau aana mo tala ni horonga ikire, ta'e i'omu, omu ke maneko mola mala hiroikuu. ");
INSERT INTO apb_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Na lo'u, omu ke lio talamiu aana mo iinoni, aena aana kire kei toole'omu i laona leinge, na kire kei repusi'omu i laona mo nume ni palo-palo. ");
INSERT INTO apb_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Na tolalamiu kei lae-lae i na'ona mo mwane paine aana mo aalahanga ni welumalau na i na'ona mo inemauri hunie leilemiu i tehula'aku. Aana maholo walu olana kei reu uurini, maholo i'omu otona huni unu diana aana Tataroha Diana hunire, na lo'u hunie ahutana mo iinoni ni welumalau. ");
INSERT INTO apb_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Maholo kire ko toole'omu i laona leinge, omu ke su'uri tolahi'e hiito'o aana nga taa omu kei unue wa omu kei ere luhesie uri taa, aena aana a God kei niie taane huni'omu nga taa ni unue i'omu aana maholona. ");
INSERT INTO apb_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Aana omu sa'a ere tohumiu ike ta'e pe'ie Li'oa a Aamamiu ni kei ere i lalo aamiu. ");
INSERT INTO apb_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Aana maholona kei tohungei aaela huni'omu to'ohuu, aana mwala kei niie mo eeside maraada hunie horo'ilada, na mo mama'a kire kei deu urine no'one aana mo mwela ikire, na mo mwela no'one kire kei ta'ela'i honosie mo meu'ana ikire huni horo maesire. ");
INSERT INTO apb_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Na ahutana mwala kei teunge'ini'omu aena aana omu ko lulu i sulieu. Ta'e iini nge kei uure a'aila'a tara'asi aani hiiwalaimolinge lai hule aana ha'amangolana, nge a God ke si ha'a-uurie. ");
INSERT INTO apb_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Maholo mwala ko teunge'ini'omu aana nga hanue, omu ke tahi takoie ngaeta hanue. Aana to'ohuu no ko unue huni'omu uri omu sa'a roro'a ha'amangoa ike asunge i'omu aana ahutana mo henue i Israel na ineu a Kale Ni Iinoni no ko hule oto mai pe'ie manikuluha'ana a God. ");
INSERT INTO apb_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Iinoni ha'a-uusulilana ko lae-lae ue, e ka'a paine ike liutaa aana ha'a-uusuli ingeie, wa nga koni-konihe ke paine liutaa aana aalaha ingeie. ");
INSERT INTO apb_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","E malisine uri tolahana pwaarongoisuli ke urihana oto ha'a-uusuli ingeie, na koni-konihe ke urihana oto aalaha ingeie. Ineu oto pwaune nume ikolu, na oto mala mwala ko haara'inieu aana na'ohana mo li'oa aaela, i'omu, mwala aana nume kire ke si haara'i aaelasi'omu lo'u liutaa. ");
INSERT INTO apb_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Ta'e ma'alana e urine, omu ke su'uri me'ute'inire, aana ta'e-ta'ena nga mei ola iinoni ko mumumunie, haata'inilana kei saro lae mola, na ta'ena nga mei ola ko reu mumuni, sailana kei saronai lae taane. ");
INSERT INTO apb_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Nga taa no ko unu-unu mumuni aana huni'omu, omu ke si unu haada'i aana. Na lo'u nga taa omu ko rorongoa mola maraamiu, omu ke si soinge'inie hunie ahutana mwala ke rongoa. ");
INSERT INTO apb_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Mwaanie omu me'u-me'ute'inie mo iini ko sare horo'i'omu, aana kire sai horo'ie mola sapemiu, ta'e e aasa hunie kire ke horo'ie mauriha'amiu. Ta'e omu ke ma'ute'inie mola a God aana ta'e ingeie hali'ite nge e to'o aana nanamanga huni deu tekela'inie sape na mauriha'ai i laona dunge ni ha'amotaahinge. ");
INSERT INTO apb_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Omu ke saie ka'u uri e ro kele pipisu nga iini e sai holi'i mola aana nga ta'a-ta'a kele peni pulu, ta'e hule aana nga iini aadarue e sa'a mae na Aamamiu e ka'a toli'aasie. ");
INSERT INTO apb_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Na lo'u omu ke saie uri a God hule aana e sai susulie warai iihune pwaumiu. ");
INSERT INTO apb_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Oto omu ke su'uri me'u, aena aana omu tohungei hi'e lo'u liutaa aana mo pipisu oto hunge.” ");
INSERT INTO apb_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Oto mala uri nga iini nge ko unu tahanga'inie i na'ona mo iinoni uri ingeie iinoni ineu, nge ineu no'one ne kei unu tahanga'inie i na'ona Aamaku i Lengi. ");
INSERT INTO apb_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Ta'e mala uri nga iini kei taateinge'inieu i na'ona mo iinoni, nge ne kei taateinge'inie no'one i na'ona Aamaku i Lengi.” ");
INSERT INTO apb_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Oto a Jisas ko he'i te'uri lo'u, “Mwaanie omu ne'i-ne'isae uri nou lae mai hunie ne ke toolea mai hanuelamanga hunie walumalau. !Ha'ike! Nou ka'a lae ike mai hunie ne ke toolea mai hanuelamanga, ta'e horonga kei lae i tehula'ana ha'a-uusulinge ineu. ");
INSERT INTO apb_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Aana nou lae mai huni oopaa ro ha'i-aamana, na ro ha'inikana, na ro mahungaona keni. ");
INSERT INTO apb_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Mo tohungei iinoni oto aana uluhe nga iini, nge ke si ne'i maelonga ingeie. ");
INSERT INTO apb_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Nga iini nge ko manata diana hunie aamana wa nikana liutaa aaku, e ka'a malisine ike ke ne'i pwaarongoisuli ineu. Na nga iini ko manata diana hunie kalena mwane wa kalena keni liutaa aaku, e ka'a malisine ike ke ne'i pwaarongoisuli ineu. ");
INSERT INTO apb_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Na nga iini e ka'a mwa'e-mwa'e huni sapesalu hule aana maenga i lengine po'u-po'u i tehula'aku, e ka'a malisine ike ke ne'i pwaarongoisuli ineu. ");
INSERT INTO apb_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Na nga iini nge ko kineta'inie mauriha'ana kei lio oodoie maenga huu. Na ta'ena nga iini nge ko deu tekela'inie mauriha'ana i tehula'aku, kei lio oodoie maurihe huu.” ");
INSERT INTO apb_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Oto a Jisas ko he'i te'uri lo'u, “Nga iini ko tekuhi'omu nge ko tekuhieu eena. Na nga iini nge ko tekuhieu ko tekuhie no'one iini e uusunge'inieu mei. ");
INSERT INTO apb_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Nga iini ko tekuhie nga propet aena aana uri ingeie ko unu-unue walana a God, nge kei hele waaite oto mala propet ngeena. Na nga iini ko tekuhie nga iinoni diana aena aana iinonine e diana, nge kei hele waaite oto no'one mala iinoni diana ngeena. ");
INSERT INTO apb_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Omu ke saie mola uri ma'alana nga iini ko niie mola nga mei wei wawai ana nga ta'a-ta'a kele iini aana mo iini ko lulu i sulieu, aena aana uri ingeie pwaarongoisuli ineu, na kei hele waaite oto.” ");
INSERT INTO apb_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Maholo a Jisas e hatonga'i wala mango hunie aawalai pwaarongoisuli mwana rue ingeie, e si lae mwaanie i leune na ko lae lo'u hunie po'o ni henue i Kalili huni ha'a-uusuli na ni laeliwala nana mwala aana mo huilume hao i leune. ");
INSERT INTO apb_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Oto a Jon Loto Maa'i e ii'o i nume ni ho'o, na maholo ko rongoa tataroha aana asunge a Kraes, oto ko uusunge'inie ngaeta mo pwaarongoisuli ingeie i saana huni dolosi aana uuri, ");
INSERT INTO apb_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","“?Uri i'oe ni oto a Ha'a-uuri kei lae mai, wa melu kei maa'oohie ue nga iini aaopa?” ");
INSERT INTO apb_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Oto a Jisas ko aalamire ko te'uri, “Omu ke aaliho'i na omu ke ha'arongoa a Jon aana nga moi taa omu ko rongo'i na omu ko leesi'i oto. ");
INSERT INTO apb_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Aana mo ulu ko lio-lio oto, mo rarasi ko lae-lae diana oto lo'u, mo iini ko sapesalu aana maelaa ni osa kire mola oto, mo iini e pungu ko rorongo oto lo'u, na mo iini e mae kire ko meuri eeliho'i oto lo'u. Na laeliwalanga aana Tataroha Diana ko lae oto hunie mo meitale. ");
INSERT INTO apb_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Na omu ke ha'arongoa no'one a Jon uri ilenimwa'enga paine kei lae hunie mo iini hiiwalaimolinge ikire e susu, na kire ka'a ne'isae rue-rua'a aaku.” ");
INSERT INTO apb_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Oto mo pwaarongoisuli a Jon kire rorongo i sulie mo aalaminge a Jisas, kire si eeliho'i i saana a Jon. Oto a Jisas ko si aehota ere-ere nana mwala i sulie a Jon uuri, “?Maholo omu lae ta'au i saana Jon i henuesala, nga taa ni omu lae ta'au huni leesie? ?Ohe omu lo'onga'inie uri a Jon nga iinoni saena e rue-rua'a mala apai rade ko eu'esule'i aana iiru? !Ha'ike! ");
INSERT INTO apb_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","?Wa nga ola uri taa ni omu lae-lae ta'au huni leesie? ?Ohe iinoni e to'oni eeni to'oni lio manikulu'e? !Ha'ike no'one! Mwala e to'oni urine kire ko o'o'o mola aana mo nume mo inemauri. ");
INSERT INTO apb_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","?Ta'e nga taa ni omu lae ta'au huni leesie? ?Huni leesie nga propet? !Iau! !E to'ohuu oto! Na a Jon nge omu leesie e paine lo'u liutaa aana mo propet oto i na'o. ");
INSERT INTO apb_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Aana ingeie oto iini nge a God e ere rarangana i laona mo Uusu-uusu Maa'i uuri, Ne kei uusunge'inie hurula'aa ineu wau i na'omu hunie ke dau aakau aana tala i'oe loosi'o. ");
INSERT INTO apb_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","No ko unue oto huni'omu uri a Jon Loto Maa'i e paine liutaa aana ta'ena nga iini e hute mai welumalau. Ta'e iini nge e mwai-mwei oto liutaa aana Aalahanga a God e paine lo'u liutaa aana a Jon. ");
INSERT INTO apb_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Uure oto aana maholo a Jon Loto Maa'i e aehota laeliwala lae mai hule si'iri, Aalahanga a God ko peine a'aila'a mola, ma'alana mo mwane hai-heiseuni ko deu rarahie kire ke paine haahie. ");
INSERT INTO apb_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Uure oto waite mo uusu-uusu mo propet na mo Ha'atolanga a Mosis kire unu tahanga'inie oto walana a God lae mai hule aana pongine a Jon. ");
INSERT INTO apb_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Oto mala uri omu ko mwa'e-mwa'e ni hiiwalaimoli aana nga taa nge kire unu-unue lae-lae'i meine, na a Jon oto propet mala a Elaeja. ");
INSERT INTO apb_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Mwaanie omu rorongo aasie mola mo wala ienini, ta'e omu ke lo'o-lo'onga'i diana i suli'i. ");
INSERT INTO apb_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“?Ne kei unu ha'amalaa pwaunge aana maholo ienini aana nga taa? Kire urihana mola pulitaa ni mwela nge ko pwarero i laona amaa, oto ruana nga pulitaa ko ere uuri hunire, I'omu, omu sere'inie mola ahutana mo pwareronga, ");
INSERT INTO apb_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","Maholo melu ko kanalie mo kana ni ha'arurunge namiu, omu sa'a ilenimwa'e wa omu ke mao. Na maholo melu ko kanalie mo kana ni heitolinge namiu, omu sa'a saehuu wa omu ke ngara. ");
INSERT INTO apb_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","“I'omu, omu urihana mola mo mwela ngeena aena aana maholo a Jon e lae mai, e oolongau na e ka'a inu waen ike. Oto ahutana iinoni ko unue uuri, ‘A mwane ngeena nga li'oa aaela nge aana.’ ");
INSERT INTO apb_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Oto ineu a Kale Ni Iinoni, nou lae mai na no ko ngeu na no ko inu waen mola, oto mwala ko unue lo'u mola uuri, ‘A mwane ngeena ngauhana e paine na e tohungei sai inu hiito'o. Na mo malahune oto mola mwala susulu to'oha na mo iinoni ooraha'aa.’” Oto a Jisas e ha'amangoa erenga ingeie uuri, “Ta'e tolahana mo iini kire to'o aana saenanaunge a God kei haata'inie uri ikire oto mo iinoni to'ohuu.” ");
INSERT INTO apb_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Mo henue nge a Jisas e lae pe'i esuie mo hu'i-hu'ite aani, mwala kire ka'a aali'u ike mwaanie mo ooraha'aa ikire, oto a Jisas e si aehota ere aaelasire na ko te'uri, ");
INSERT INTO apb_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“!Kei aaela oto liutaa huni'omu mo Korasin! !Na no'one huni'omu mo Betsaeda! Mala uri mo hu'i-hu'ite nge asuileni e lae huni'omu ngeena, asuileni ke lae urine hunie mo pu'o i Taea na i Saedon, ha'alaa mwala aana e ro huilume ngeena kire pwani oonisae oto waite. Kire kara'i ha'amwai-mwei'ara aani ho'osilana mo to'oni lalahu'e, na ipe aani pwasa'ora huni haata'inie uri kire aali'u oto mwaanie mo ooraha'aa ikire. ");
INSERT INTO apb_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","No ko unue oto huni'omu uri aana dinge ni leinge a God kei aamasie mo iinoni tata'ala i Taea na i Saedon lo'u liutaa aamiu. ");
INSERT INTO apb_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","?Na huni'omu mo Kapaneam, omu ko lo'o-lo'onga'i uri a God kei sulu ala'a aamiu ta'au i Lengi? !Ha'ike! A God kei aasi'omu mola hai aano aana leu ni ha'amotaahinge. Aana mo hu'i-hu'ite nge asuileni e lae huni'omu, kire ke rau urine hunie hanue aaela i Sodom, ha'alaa ingeie e ii'o mola ue hule mai si'iri. ");
INSERT INTO apb_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","No ko unue oto huni'omu uri aana dinge ni leinge ha'amotaahilemiu kei lae lo'u liutaa aana i Sodom.” ");
INSERT INTO apb_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Na aana maholona a Jisas e te'uri, “Mama'a, i'oe oto o aalaha haahie i Lengi na mai aano. Uure oto waite o mumunie Tataroha Diana mwaanie kira saenanau, ta'e ie o ko haata'inie oto hunie mo iini ka'a saenanau. Oto no ko tohungei paalahe'o, ");
INSERT INTO apb_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Mama'a, aana o oala'inie hunie ke lae oto urine.” ");
INSERT INTO apb_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Oto e si te'uri lo'u hunie mwala, “Aamaku e niie oto ahutana walu ola hunieu hunie ne ke paine haahi'i. Na nga iini ka'a manata'inie ike a Kale ta'e a Mama'a mola hali'ite. Na nga iini e ka'a manata'inie ike a Mama'a ta'e a Kale mola hali'ite, na mo iini nge a Kale ko lio hilisire huni unu haata'i aana Aamana. ");
INSERT INTO apb_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Omu ke lae mai seeku ahutemiu mo iini omu ko weo aana omu ko tolahi'e, hunie ne ke ha'amamalo'omu. ");
INSERT INTO apb_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Omu ke lae mai huni aanga'inie tori aana ha'a-uusulinge ineu, na omu ke ne'i pwaarongoisuli ineu. Aena aana ineu, nou maneko na nou ha'amwai-mwei'aau to'ohuu. Na omu ke si lio oodoie mamalonga hunie mauriha'amiu i seeku. ");
INSERT INTO apb_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Aena aana tori aana ha'a-uusulinge ineu e mwada'u, na ludaa ineu e mwa-mwate huni aanga'inie.” ");
INSERT INTO apb_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Oto lo'u mola aana ngaeta Dinge Maa'i Mo Jiu, a Jisas na mo pwaarongoisuli ingeie kire ko lai liu i laona mo hohola ni ola mala mo kooni. Maholona na mo pwaarongoisuli kire ko hiolo, oto kire ko aehota aroa oto nga mo iini, na kire ko ngeue oto hue-hueni. ");
INSERT INTO apb_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Maholo mo Parise kire leesie urine, oto kire ko ere uuri hunie a Jisas, “!Ei, leesie ka'u! Mo pwaarongoisuli i'oe ko deu esunge mola aana Dinge Maa'i ikie, mei ola e aapu aana Ha'atolanga a Mosis.” ");
INSERT INTO apb_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Oto a Jisas e aalamire ko te'uri, “Omu saie taane nga taa nge a Deved Inemauri e asuie, aana maholo ingeie na ngaeta mo iini lo'u pe'ie kire hiolo. ?Ta'e e ue ni omu ka'a rongo saie ike ne'isaenga aana? ");
INSERT INTO apb_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","A Deved na mo mwane ingeie kire lae sili i laona nume maa'i a God, na kire ngaue mo bred maa'i, mo ola niilana e lae hunie a God. Ta'e mo Ha'atolanga a Mosis e unue kire ka'a malisine ike kire ke ngaue, aana ta'e mo pris hali'ite kire sai ngaue taungei bred maa'i urine. Ta'e ma'alana e urine, a God ka'a leie ike haahie. ");
INSERT INTO apb_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Na omu saai oodoie ka'u no'one mola i laona mo Ha'atolanga a Mosis uri mo pris ko deu hu'isie no'one mola mo ha'atolanga aena kire ko esu i suli Dinge Maa'i hai Nume Maa'i Peine. ?Ta'e e ue omu ka'a saie ike uri kire ka'a roro'a aana? ");
INSERT INTO apb_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Ta'e ineu, no ko unue huni'omu uri ngaeta iini e paine liutaa aana Nume Maa'i Peine taane i leu. ");
INSERT INTO apb_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Aana a God e unue i laona mo Uusu-uusu Maa'i uuri, Aamasinge ni mola nou heri hunie na uunu-olanga ha'ike. Mala omu ke sai diana aana mo wala ie, ha'alaa omu sa'a leie ike mo iini ka'a dau hu'isie ike nga mei ola. ");
INSERT INTO apb_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Aana ineu a Kale Ni Iinoni oto nou aalaha haahie Dinge Maa'i.” ");
INSERT INTO apb_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Oto a Jisas e uure mwaanie leune ko si lae hunie ngaeta nume ni palo-palo, ");
INSERT INTO apb_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","na nga mwane ki'ine e heko ingeie i laona numena. Ngaeta mwala no'one i leune kire ko sare pwelu wala i lengine a Jisas uri ko deu aaela. Oto kire ko dolosi aana uuri, “?Ohe e ado taane aana mo Ha'atolanga a Mosis huni ha'a-uuri aana Dinge Maa'i ikie wa ha'ike?” ");
INSERT INTO apb_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","A Jisas e aalamire ko te'uri, “?A tei hikemiu e ka'a sai esu aana Dinge Maa'i? ?Mala uri nga sipu i'oe e teke i laona nga kalinge aana Dinge Maa'i, nge o kei uaa? ?Uri ma'alana Dinge Maa'i na o sa'a lai hele aana hunie o ke wa'i eeliho'i aana mwaanie kalinge? ");
INSERT INTO apb_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Aana iinoni e hi'e lo'u liutaa aana sipu, oto mo Ha'atolanga ikie e toli'aasie uri kie sai pe'ie mola nga iinoni aana Dinge Maa'i.” ");
INSERT INTO apb_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Oto e si unue hunie mwane ki'ine e heko ngeena uuri, “O ke lalaa'inie ki'imu.” Oto e lalaa'inie ki'ine, na e diana oto lo'u mala ngaeta po'o ni ki'i. ");
INSERT INTO apb_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Oto mo Parise kire leesie urine, kire si iisitaa mwaanie nume ni palo-palo na kire ko meni wala oto huni horo maesie a Jisas. ");
INSERT INTO apb_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Oto a Jisas mone e manata'inie mola uri mo Parise ko lo'o-lo'onga'i huni horo'ie, e si lae mwaanie i leune, na mwala hunge ko lae i sulie. Oto e ha'a-uurie ahutana mo iini ko mweri, ");
INSERT INTO apb_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","na ko si ere honosire mwaanie kire ha'arongoa nga iini uri ingeie a tei. ");
INSERT INTO apb_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","E te'urine huni ha'a-oaie nga taa a God e unue ka'u aana Propet Aesaea uuri, ");
INSERT INTO apb_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Koni-konihe ineu ni oto ie, iini nou lio hilisie, na iini nou manata diana hunie, na iini nou tohungei ilenimwa'e haahie. Ne kei niie nanamanga ni Li'oa ineu hunie, na ingeie ke si haata'inie hunie ahutana mwala uri leinge a God ni e oodota'i. ");
INSERT INTO apb_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","E sa'a ha'a-ere, wa ke tea, wa ke ere paine i sulie mo tala. ");
INSERT INTO apb_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Ta'e kei maneko pe'ie mo iini kire mamaela'a, na kei toli rako pe'ie mo iini kire sa'a pe'ire ike maraada. Kei esu susule'i lai hule aana oodo-oodonga kei tola hehesie aaelanga. ");
INSERT INTO apb_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Na ahutana mwala aana walumalau ke si meni noruto'o oto aana. ");
INSERT INTO apb_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Oto ngaeta mwala kire toolea mai i saana Jisas nga mwane e ulu na ka'a sai ere ike aena aana li'oa aaela nge aana. Oto e ha'a-uurie uri hunie ke ere-ere na ke lio-lio lo'u. ");
INSERT INTO apb_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Ahutana mwala ko meni pangata'inie nga taa a Jisas e asuie, na kire ko te'uri, “?Ohe Kalena Deved Inemauri ni ienini, a Kraes?” ");
INSERT INTO apb_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Maholo mo Parise kire rongo urine, oto kire ko unue uuri, “!Ha'ike eena! A Bielsebul, na'ohana mo li'oa aaela nge e niie nanamanga ngeena hunie huni oohe aasie mo li'oa aaela urine.” ");
INSERT INTO apb_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","A Jisas e manata'inie mola mo lo'onga'inge ikire, oto ko si te'uri, “Ta'ena nga aalahanga kei oopa aani heiseuninge honosie maraana, nge kei na'onga oto. Na ta'ena nga hanue wa ta'ena nga nume nge kei oopa maraana, nge kei ei'aa oto. ");
INSERT INTO apb_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Na mala uri ngaeta mo li'oa aaela i laona aalahanga a Satan ko oohe aasie ngaeta mo li'oa aaela lo'u, nge aalahanga ingeie e oopa oto, na kei ei'aa oto. ");
INSERT INTO apb_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","?Nge mala omu ko unue uri ineu no ko sikera'inie mo li'oa aaela aana nanamanga a Bielsebul e niie hunieu, oto a tei ka'u e niie nanamanga hunie mo pwaarongoisuli i'omu huni sikera'inie mo li'oa aaela? ?A Bielsebul? !Ha'ike! Nga taa mo pwaarongoisuli i'omu kire ko esuie e haata'inie oto uri i'omu ni omu takalo. ");
INSERT INTO apb_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Ta'e ineu, no ko oohe aasie mo li'oa aaela aana nanamanga a God. Na leune e haata'i diana aana oto uri Aalahanga a God e hule oto i seemiu.” ");
INSERT INTO apb_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Oto a Jisas ko he'i ere ni aalahuunge lo'u i sulie nanamanga ingeie e saka liutaa aana Satan, na ko te'uri, “Nga mwane sa'a sili ike i laona nume ngaeta ramo hunie ke pelie to'o-to'olana, ta'e kei hola'i tapolie na kei pwesue, nge purine ke si toolea ahutana mo ola ingeie.” ");
INSERT INTO apb_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Oto a Jisas e he'i te'uri lo'u, “Ta'ena nga iini oto e ka'a aapa pe'ieu, ingeie maelonga ineu. Na nga iini oto ka'a so'okoni iinoni pe'ieu hunie Aalahanga a God, ingeie ni ko oohe tatanga'inie mwala mwaanie a God. ");
INSERT INTO apb_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Aena ngeena no ko unue huni'omu uri a God e sai sae'aasie ta'ena nga ooraha'aa na ta'ena nga iini ko ere mwakata'inie. Ta'e iini ko ere mwakata'inie Li'oa Maa'i, sae'aasilana e sa'a lae ike oto oo'oo. ");
INSERT INTO apb_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Wa nga iini ko ere mwakata'inie a Kale Ni Iinoni, sae'aasilana e sai lae mola, ta'e iini ko ere mwakata'inie Li'oa Maa'i, sae'aasilana e sa'a lae ike oto oo'oo, mai leu aana walumalau ienini wa aana iini ue mai.” ");
INSERT INTO apb_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Oto a Jisas e he'i te'uri lo'u, “Ai e mauri diana nge kei hungu eeni hue-huei ei diana, ta'e ai aaela kei hungu oto aani hue-huei ei aaela, aana lio sailana ai ko lae-lae oto aana hue-huana. ");
INSERT INTO apb_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","!I'omu oto mo mwaa! ?Omu kei roro'a unue mo ola diana uri taa, na hule aana i'omu maraamiu na omu ka'a diana? Aana wawana iinoni oto ko unu-unue nga taa saena e honu aana. ");
INSERT INTO apb_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Iinoni diana e to'o aana mo lo'onga'inge diana i laona saena, na kei haata'ini'i aana mo ola diana kei esui'i. Ta'e iinoni aaela e to'o aana mo lo'onga'inge aaela i laona saena, na kei haata'ini'i aana mo ola aaela kei esui'i. ");
INSERT INTO apb_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","“No ko unue oto huni'omu uri aana dinge ni leinge ta'ena nga mei wala oto mola mo iinoni ko talei unu-unue, iidumileni kei lae. ");
INSERT INTO apb_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Aana leilemu kei lae oto i sulie walamu, huni haata'inie uri o oodota'i taane wa o takalo oto.” ");
INSERT INTO apb_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Oto ngaeta mo ha'a-uusuli aana mo Ha'atolanga a Mosis na ngaeta mo Parise kire ko te'uri hunie a Jisas, “Ha'a-uusuli, melu sare leesie uri o ke asuie ka'u nga hu'i-hu'ite huni haata'inie uri a God ni e niie nanamanga huni'o.” ");
INSERT INTO apb_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Oto a Jisas ko aalamire ko te'uri, “!Ha'ike eena! Pwaunge ienini, omu lae otoi aaela hiito'o. Suata omu ka'a sai kineta'ini'omu ike nana a God. Omu ko sukaau taane hunie nga hu'i-hu'ite, ta'e nou sa'a asuie ike. Ta'a-ta'a hu'i-hu'ite nou sai haata'inie aamiu oto nga taa e rau aana a Propet Jona oto waite. ");
INSERT INTO apb_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Mala ka'u a Jona e ii'o i laona ho ii'e paine e oolu hei aatowaa na e oolu hei rodo, nge a Kale Ni Iinoni kei ii'o no'one urine i laona mwakano hunie e oolu hei aatowaa na e oolu hei rodo. ");
INSERT INTO apb_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Aana dinge ni leinge mo Ninive kire kei ta'ela'i, oto kire kei ere aamiu uri omu tohungei takalo oto liutaa. Aana ikire mo maelonga aaela mo Jiu, ta'e kire oonisae oto mwaanie mo ooraha'aa ikire aana kire rongoa laeliwalanga a Propet Jona. Ta'e no ko unue oto huni'omu uri nga iini taane i matolamiu i leu e paine lo'u liutaa aana Jona. ");
INSERT INTO apb_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Aana dinge ni leinge Toro ni Siba kei ta'ela'i no'one honosi'omu aana pwaunge ienini, na kei ere aamiu uri omu tohungei takalo oto liutaa. Aana ingeie e uure ha'atau oto i ngongo'ana walumalau huni lae mai rongoa mo ha'a-uusulinge ni saenanaunge a Solomon Inemauri. Na no ko unue oto huni'omu uri ngaeta iini e paine lo'u liutaa aana Solomon taane i matolamiu i leu, ta'e omu ko leledie mola.” ");
INSERT INTO apb_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Oto a Jisas e he'i ere ni aalahuunge lo'u i sulie pwaunge aana maholona, na ko te'uri, “Maholo nga li'oa ni ooraha'aa ko iisitaa mwaanie nga iinoni, kei waloliu i laona hanuesala ni lio hunie nga leu ni mamalo ingeie. Mala uri e ka'a lio oodoie oto nga leu, ");
INSERT INTO apb_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","nge ke si te'uri hunie maraana, ‘Ohe ne kei ooli lo'u mola takoie nume ineu, iini nou iisitaa ka'u mwaanie.’ Oto e ooli ta'au na ko lio oodoie a mwaena e urihana nume nge kire tala rere'a aana, na kire hataa'i diana aana mo ola i laona. ");
INSERT INTO apb_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Oto ko si lae lo'u huni toolea mai ngaeta hiu li'oa ni ooraha'aa aaela lo'u liutaa aana ingeie. Oto kire lae, kire ko si lae oto ii'o huu i laona iinonine. Oto aana ha'amangolana, tolahana iinonine lo'u mei puri ko si tohungei aaela oto hiito'o liutaa aana tolahana hola'ina'o.” ");
INSERT INTO apb_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Maholo a Jisas ko ere-ere ue hunie mwala, na a nikana pe'ie maeni eesine mwane nge kire hute pe'ie, kire ko hule oto. Oto kire uure mola ta'i sinaha, kire ko si dodolosi uri hunie kire ke ere pe'ie. ");
INSERT INTO apb_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Oto ngaeta iini aana mwala ngeena ko unue hunie a Jisas uuri, “!Lio ka'u! A nikemu na mo eesimu kire uure mola ta'i sinaha, na kire ko sare ere pe'i'o.” ");
INSERT INTO apb_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Oto a Jisas e aalamie na ko te'uri hunie iinonine, “?A tei ni a nikeku? ?Na kira tei ni maeni eesiku?” ");
INSERT INTO apb_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Oto ko uusuie mola mo pwaarongoisuli ingeie na ko te'uri, “Lio ka'u, nikeku na maeni eesiku ka'u ie. ");
INSERT INTO apb_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","A tei nge ko deu i sulie nga taa Aamaku i Lengi e saeto'o aana, ingeie ni aasiku na a nikeku.” ");
INSERT INTO apb_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Na lo'u aana hai dingena a Jisas e iisitaa mwaanie nume, e si lae hai reune Aasi I Kalili. ");
INSERT INTO apb_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Na aena aana mwala kire ruru mei saana kire lae oto i hunge, e si ta'elie iiola mwaanie kire uure su'u-su'uie, oto ko si ha'a-uusulire maholo kire uure hai oone. ");
INSERT INTO apb_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Mo ola hunge a Jisas e unu'i hunie mwala ngeena aani aalahuunge uuri, “Ngaeta mwane au'esu hohola e o'o'o, oto ko lai hesie mo litei ola ingeie mala mo kooni. Hasinge ngeena ko lae mola aana tataa'inilana mo lite, ");
INSERT INTO apb_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","na maholo ko tatataa'inie mo litei ola hailiu i laona hohola ingeie, ngaeta mo lite iini eeni kire ko teke i reune tala. Oto mo menu kire loho mai, kire ko ngeu'i mola. ");
INSERT INTO apb_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Ngaeta mo lite iini kire ko teke i lengine mei heu-heue. Oto mo lite ngeena kire ko tolana pwito poi aena aana mei mwakano ngeena e ka'a pi'ola ike. ");
INSERT INTO apb_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Ta'e e hule aana maholo sato ko peine, oto sato ko madorohi'i oto hiito'o, na kire ko nunulu mola aena aana kire ka'a susu'imi ike hiito'o i aano. ");
INSERT INTO apb_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Ngaeta mo litei ola kire ko teke i matolana mo walo kau-keu. Oto kire ko pwito tararuru pe'ie mo walo kau-keu, ta'e mo walo kau-keu kire paine haahi'i na kire ko si melusi'i mola. ");
INSERT INTO apb_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Ta'e ngaeta mo litei ola kire teke i lengine mei mwakano diana. Kire lai pwito diana na kire hungu, nga mo iini kire hungu oolu aawala, na nga mo iini e oono aawala, na nga mo iini tangalau.” ");
INSERT INTO apb_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Oto a Jisas e si ere ooreta hunire uuri, “Mwaanie omu rorongo aasie mola mo wala ienini, ta'e omu ke lo'o-lo'onga'i diana i suli'i.” ");
INSERT INTO apb_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Oto mo pwaarongoisuli e lae mai saana a Jisas, na kire ko dolosi aana uuri, “?E ue ni o ko ere-ere aani aalahuunge hali'ite aana maholo o ko ha'a-uusulie mwala?” ");
INSERT INTO apb_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","A Jisas e aalamire ko te'uri, “No ko te'urine aena aana a God e lio hilisi'omu hunie omu ke saenanau aana walaimolinge mumuni aana Aalahanga ingeie, ta'e ke ii'o mumuni ue mwaanire. ");
INSERT INTO apb_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Aana ta'ena nga iini e mwa'e-mwa'e huni rongo i sulie mo ha'a-uusulinge ineu, nge sapeilana saenanaunge ni Lengi kei lae lo'u oto liutaa hunie. Ta'e a tei nge e ka'a mwa'e-mwa'e huni rongo i sulie mo ha'a-uusulinge ineu, nge ma'alana uri nga kele mei saenanaunge ni Lengi e to'o aana, ta'e ta'aasilana kei lae mola mwaanie. ");
INSERT INTO apb_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Oto no ko ere-ere ni aalahuunge hali'ite hunire, aena aana kire ko lio-lio, ta'e kire sa'a lio saie ike, na kire ko rorongo, ta'e kire sa'a rongo saie ike. ");
INSERT INTO apb_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Aena ngeena mo erenga a God e unu'i aana a Propet Aesaea ko oa oto aana e unue uuri, I'omu, omu ko rorongo, ta'e omu ka'a rongo sai ola ike, na omu ko lio-lio na omu ka'a lio sai ola ike lo'u. ");
INSERT INTO apb_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Aana mwala ienini saeda e hau, na kire ponosie aalingada na kire ulue maada, mwaanie uri kire lio sai ola aana maada, na mwaanie kire rongo sai ola aana aalingada, na mwaanie saeda e taha, na mwaanie kire aali'u mei takoieu na ne kei ha'a-uurire. ");
INSERT INTO apb_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Ta'e deidehi'omu aana maamiu ko lio sai ola na aalingemiu ko rongo sai ola. ");
INSERT INTO apb_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Aana no ko unue oto huni'omu uri hungelana mo propet na mo mwane oodota'i kire tohungei sasare leesie mo ola omu ko leesi'i ie, ta'e kire ka'a lio mangini, na uri huni rongoa mo ola omu ko rongo'i ie, ta'e kire ka'a rongo lelengani.” ");
INSERT INTO apb_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Oto i'omu, omu ke rongoa ka'u lo'onga'inge aana aalahuunge i sulie iini ko hesi aani tataa'inilana mo lite, na hunie omu ke saie. ");
INSERT INTO apb_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Tala nge mo lite ngeena kire teke i sulie e urihana mo iini nge kire rongoa taane mo wala aana Aalahanga a God. Ta'e e ka'a tewa na a Satan e lae mai ko ta'aasie nga taa nge hasilana e lae ka'u i manatada. ");
INSERT INTO apb_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Na mo iini nge manatada e urihana mei mwakano hau-heue ngeena, kire rongoa walana God, na oto lau-leu kire ilenimwa'e haahie. ");
INSERT INTO apb_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Ta'e e ka'a susu'imi diana ike mone i manatada, oto e sa'a ii'o tewa ike. Maholo si'oha'anga kei toolera wa taunge'inilada kei lae i tehula'ana mei wala ngeena, oto kire ko tolana mamalo oto mwaanie. ");
INSERT INTO apb_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Nga mo iini lo'u manatada e urihana mei mwakano e honu aana walo kau-keu ngeena, kire rongoa no'one walana God, ta'e kire ne'isae painesie mola mau-meuringe aana walumalau. Kire tolahi'e, na kire saeto'o aana mola to'o-to'onga, na kire ko saehanalie ta'ena nga ola. Oto mo wala diana ngeena kire ka'a pwito kohi, na kire ka'a hungu ike lo'u. ");
INSERT INTO apb_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Ta'e mo iini lo'u, mo iini urihana mei mwakano diana ngeena, kire rongoa mo wala ngeena, oto kire lulu i suli'i. Oto kire hungu diana oto eena, mo iini oolu aawala, na nga mo iini oono aawala, na nga mo iini tangalau.” ");
INSERT INTO apb_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Oto a Jisas ko he'i unue lo'u ngaeta mei aalahuunge hunie mwala uuri, “Aalahanga a God e urihana iinoni e hasie mo litei ola diana mala kooni i laona hohola ingeie. ");
INSERT INTO apb_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Oto aana ngaeta hai rodo, maholo ahutana mwala ko ma'ahu mango oto, maelonga ingeie e lae mumuni mei, ko hesie mo rea mola i matolani, ko si tehi mwaani'i. ");
INSERT INTO apb_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Oto e ro taungei olana ko meni pwito poi na kire kara'i lio sada mola. Ta'e aana maholo mo kooni ko aehota hungu oto, mo rea ko si haata'i aana kire ka'a sai hungu ike. ");
INSERT INTO apb_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Mo koni-konihe iinoni ngeena kire lae mai saana, oto kire ko te'uri hunie, ‘!Poro paine! ?Uri mo rea kire uure lo'u i tei na o hasie ka'u mo litei ola diana i laona hohola i'oe?’ ");
INSERT INTO apb_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","“Oto ko aalamire uuri, ‘Nga maelonga ni oto e te'urine ngeena.’ “Oto kire ko dolosi aana uuri, ‘?Uri o saeto'o aana melu ke lai ware aasie mo rea?’ ");
INSERT INTO apb_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","“Oto ko aalamire uuri, ‘Su'uri, mwaanie omu ware pele aana nga mo kooni pe'ie mo rea. ");
INSERT INTO apb_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Toli'aasie ka'u mo kooni na mo rea ke mani pwito tararuru hule aana so'okoninge. Oto ne ke si unue hunie mo iini ko so'okoni uri kire ke hola'i ware aasie mo rea, kire ke loko i ho'o huni uunu aasi'i. Oto kire ke si haro so'okonie lo'u mo kooni huni ne'i'i lengine haa ineu.’” ");
INSERT INTO apb_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","A Jisas ko he'i unue lo'u ngaeta mei aalahuunge hunire uuri, “Aalahanga a God e urihana iinoni e hasie litei ola aana ai mastad i laona hohola ingeie. ");
INSERT INTO apb_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Kele litei ola oto mola mwai-mwei liutaa aana ahutana mo litei ola kolu sai hesi'i, ta'e maholo ko pwito, hule aana ingeie oto e paine liutaa aana mo ola i laona hohola, na maholo ko peine na ko ne'i ei oto, mo menu ko si lae mai tola niu'i i lengine sasarana.” ");
INSERT INTO apb_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Oto ko he'i unue lo'u ngaeta aalahuunge hunire uuri, “Aalahanga a God e urihana no'one kele mei iis nge hu'e e pwaie i laona nimei pulaoa oto paine, na ahutana e haro po'o mango mola aana e hane.” ");
INSERT INTO apb_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","A Jisas e ere-ere oto tarau aani aalahuunge hunie mwala, hule aana e sa'a ere ike hunire na e ka'a ere aana aalahuunge. ");
INSERT INTO apb_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","E ere-ere urine huni ha'a-oaie nga taa a propet e unue uuri, Ne kei ere aani aalahuunge maholo ne kei ere-ere pe'ire. Ne kei ha'arongora aana mo ola nga iini ka'a sai'i, uure oto aana ha'aholalana walumalau. ");
INSERT INTO apb_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Oto a Jisas e lae mwaanie mwala, e si lai sili i nume. Na mo pwaarongoisuli ingeie kire lae mai saana, oto kire ko te'uri hunie, “O ke unue ka'u oodoi'emeelu, nga taa ni lo'onga'inge aana aalahuunge i sulie mo rea i laona hohola.” ");
INSERT INTO apb_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","A Jisas e aalamire oto ko te'uri, “Iini e hasie mo lite diana nge a Kale Ni Iinoni otona, ");
INSERT INTO apb_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","na hohola walumalau eena. Litei ola diana mwala aana Aalahanga a God eena, na mo rea oto mo iinoni a Satan, ");
INSERT INTO apb_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","na maelonga nge e tataa'inie mo rea ingeie oto a Satan. Na so'okoninge oto ha'amangolana walumalau, na mo iini ko so'okoni oto mo ensel. ");
INSERT INTO apb_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Mala so'okonilana mo rea na uunu-aasileni e lae ka'u laloi dunge, nga taa kei reu aana ha'amangolana walumalau eena. ");
INSERT INTO apb_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","A Kale Ni Iinoni kei uusunge'inie mo ensel ingeie huni ta'aasie mo iini aaela mwaanie aalahanga ingeie. Oto kire ke so'okoni aasie mo iini ko ha'atataroa mwala hunie ooraha'aa na mo iini ko da tata'alanga. ");
INSERT INTO apb_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Oto kire kei aasire i laona dunge ni ha'amotaahinge, leu ngaranga na saehuunge e paine aana. ");
INSERT INTO apb_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Ta'e mwala a God kire kei lae i laona aalahanga aamada, na kire ke si raa oto mala rarangana sato. Mwaanie omu rorongo aasie mola mo wala ienini, ta'e omu ke lo'o-lo'onga'i diana i suli'i.” ");
INSERT INTO apb_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Oto a Jisas ko he'i unue lo'u ngaeta mei aalahuunge hunire uuri, “Aalahanga a God e urihana mwa'ii to'oha mumunilana e lae ka'u i laona mei aano. Oto nga mwane e lai lio oodoie, oto ko ne'i eeliho'i aana hunie ke ii'o mumuni. A mwaena ko tohungei ne'isae paine mone aana mwa'ii to'oha ngeena, oto hule aana e ilenimwa'e mola huni toli'aasie ahutana to'o-to'olana i tehula'ana. Oto e si lai ha'aholinge'inie to'o-to'olana, na ko eeliho'i lo'u huni holie mei aano ngeena pe'ie mwa'ii to'oha nge e lai lio oodoie. ");
INSERT INTO apb_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Aalahanga a God e urihana no'one mwane ko lio hunie mo u'umaai dehi diana. ");
INSERT INTO apb_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Na maholo e lio oodoie hohoi ola nge e lae otoi diana liutaa, ko si ha'aholinge'inie ahutana to'o-to'olana, na ko holie hohoi olana.” ");
INSERT INTO apb_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Aalahanga a God e urihana no'one hu'o mwala wee-weesi kire aasie i eesi, oto kire ko we'i haahie ta'e-ta'ena nga ii'e oto mola. ");
INSERT INTO apb_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Hu'o mone e honu aani ii'e, oto kire wa'inie i oone, kire si ii'o i aano, kire ko oopaa mo ii'e. Mo iini diana kire ko onime'ini'i laloi ite, na mo iini aaela kire ko aasi'i. ");
INSERT INTO apb_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Kei urine no'one aana ha'amangolana walumalau aana mo ensel kei siho mai, na kire kei oopaa kira ooraha'aa mwaanie mo iini oodota'i. ");
INSERT INTO apb_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Na kire kei aasire i laona dunge ni ha'amotaahinge, leu ngaranga na saehuunge e paine aana.” ");
INSERT INTO apb_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Oto a Jisas e dolosi aana mo pwaarongoisuli ingeie uuri, “?Omu sai diana aana taane oto mo lo'onga'inge aana mo aalahuunge ienini?” Oto kire ko aalamie uuri, “Iau, melu sai'i taane oto.” ");
INSERT INTO apb_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Oto a Jisas ko si aalamire lo'u uuri, “Nge ko urine ahutana mo ha'a-uusuli aana mo Ha'atolanga a Mosis nge kire lae mai ne'i pwaarongoisuli i laona Aalahanga a God, kire urihana iinoni e to'o aana nume. Na nume ngeena e honu aana mo ola diana huni pe'ie mo iinoni, mo iini e lalahu'e, na nga mo iini mo ola haalu. Aana iinoni urine e sai ha'a-uusuli aana mo tolahai ola lalahu'e, na mo ola haalu no'one.” ");
INSERT INTO apb_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Maholo a Jisas e saro unu mangoa mo aalahuunge ienini, e si lae mwaanie i leune, ");
INSERT INTO apb_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","na ko eeliho'i oto hunie huilume nge e paine ta'e aana. E ha'a-ha'a-uusuli i laona nume ni palo-palo, na mo iini e rongoa mo ha'a-uusulinge ingeie, kire ko tohungei pangata'i oto hiito'o hule aana kire ko dolosi oto uuri, “?A mwane ie e lae ka'u i toolea mo saenanaunge ngeena uure i tei? ?Na e toolea nanamanga huni esuie mo hu'i-hu'ite mala kolu ko rongo'i aana ngeena uure i tei? ");
INSERT INTO apb_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Ingeie kalena mola mwane aadu-eedu ni ngeena. Nikana ka'u mola a Meri, na mo eesine kire mani hute ka'u mola a Jemes, na a Josep, na a Saemon, na a Jiudas. ");
INSERT INTO apb_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Mo eesine keni ka'u no'one mola kire ii'o pe'ikolu i Nasaret ie. ?Ohe ingeie e lai toolea ka'u mo ola ienini uure i tei?” ");
INSERT INTO apb_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Oto aena aana kire ne'isae urine, nge kire ka'a sare rongo ike hunie walana. Oto a Jisas ko te'uri hunire, “Ahutana mwala kire sai ha'ama'u taane aana nga propet. Ta'e mwala oto aana hanue ingeie na mo iini aana nume ingeie maraana ha'alaa kire sa'a ha'ama'u ike aana.” ");
INSERT INTO apb_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Oto e ka'a asuie ike nga mo hu'i-hu'ite hunge i leune aena aana kire ka'a hiiwalaimoli ike aana. ");
INSERT INTO apb_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Maholo a Herod Antipas, aalaha aana po'o ni henue i Kalili, e rongo tarohana a Jisas aana mo hu'i-hu'ite ko esui'i, ");
INSERT INTO apb_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","oto ko ere uurini hunie mo na'ohai mwane ingeie, “A Jon Loto Maa'i ni oto e mauri lo'u ie, ka'u e to'o aana nanamanga huni deu hu'i-hu'ite ngeena.” ");
INSERT INTO apb_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","A Herod e ere urine aena aana a Jon Loto Maa'i e mae oto. Na laladonga i sulie maelana a Jon e lae uuri. Hola'ina'o, keni satana a Herodias ingeie hu'e a Pilip mwane aasine a Herod. Ta'e lae-lae a Herod ko he'i toolea lo'u a hu'ena mwaanie a Pilip aasine. Oto a Jon Loto Maa'i e unu-unue hunie a Herod uuri, “Aana Ha'atolanga a Mosis, e ka'a adona ike uri hunie o ke to'o aana lo'u a Herodias aena aana ingeie hu'e a Pilip aasimu.” Oto a Herod e si unue kire ke tapolie a Jon Loto Maa'i na kire ke pwasue aani iieli heu na kire ke ne'ie i nume ni ho'o. ");
INSERT INTO apb_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","A Herod e sare horo maesie a Jon, ta'e e ma'ute'inie mwala ni Jiu aena aana kire lo'onga'inie uri a Jon ingeie nga propet. ");
INSERT INTO apb_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Oto lo'u mola i puri, a Herod Antipas e asuie ngauhe paine huni aamasito'o aana hai dinge e hute. Na keni haalu kalena a Herodias ko mao i na'ona ruruhaa. A Herod e tohungei ilenimwa'e oto liutaa haahie, ");
INSERT INTO apb_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","na ko heiholota'i oto aani tohenga uuri, “Ne kei niie huni'o ta'ena nga mei ola o kei sukaa aaku.” ");
INSERT INTO apb_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Na oto i sulie nga taa a nikana e unue hunie, ko si te'uri hunie a Herod, “Nou saeto'o aana o ke niie oto pwaune a Jon Loto Maa'i hunieu i laona nga nime.” ");
INSERT INTO apb_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Oto a Herod Antipas Inemauri ko tohungei saehuu. Ta'e aena aana e haiholota'i na mwala kire rongoa oto nga taa e unue, oto ko si uusunge'inie ngaeta ramo ingeie huni deu i sulie nga taa a pulena e sukaa. ");
INSERT INTO apb_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Oto e lae i nume ni ho'o huni lama mousie pwaune a Jon. ");
INSERT INTO apb_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Oto e toolea mai pwaune a Jon i laona nime, ko si niie hunie keni kalena a Herodias. A keine e toolea, ko si lai niie hunie a nikana. ");
INSERT INTO apb_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Oto mo pwaarongoisuli a Jon kire lae mai toolea rae aana, kire lai heitolinge'inie, kire ko si lai ha'arongoa a Jisas. Na maelana a Jon Loto Maa'i e lae oto urine. ");
INSERT INTO apb_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Maholo a Jisas e rongo urine, e si lae mwaanie i leune aana iiola pe'ie mo pwaarongoisuli ingeie, kire lae hunie leu nga iinoni ha'ike aana hunie a Jisas ke ii'o ka'u maraana. Ta'e maholo mwala e rongoa uri ko lae oto, kire toli'aasie mo henue ikire na kire ko si hatale mola oalana i sulie oone. ");
INSERT INTO apb_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Oto maholo a Jisas e siho mai oone mwaanie iiola, na ko leesie lokotaa oto paine, oto saena ko tohungei hi'e i sulire aana ko aamasire. Oto e si ii'o huni ha'a-uurie mo iini ko mweri. ");
INSERT INTO apb_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Oto maholo kara'inie sato kei suu, mo pwaarongoisuli ingeie kire lae mai saana kire ko ere uuri hunie, “Ko seulehi oto na ikolu i laona hanuesala ni ie. Oto o ke uusunge'inie mwala ngeena kire ke lae hunie mo huilume huni holi ngeulaa ada.” ");
INSERT INTO apb_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","A Jisas ko aalamire ko te'uri, “?Kire ko lae lo'u huni taa? I'omu mola omu ke nii ngeulaa ada.” ");
INSERT INTO apb_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Oto mo pwaarongoisuli ingeie ko aalamie lo'u uuri, “!Ha'ike eena! Ta'e melu to'o aana mola e lime aata ho bred na e ro ho ii'e.” ");
INSERT INTO apb_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Oto a Jisas ko aalamire lo'u uuri, “Ko urine, toole'i mei hunieu.” ");
INSERT INTO apb_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Oto e unue mwala ke ii'o i aano i laona hahalisi. Oto a Jisas e hele aana lime ho bred ngeena na e ro ho ii'e, oto ko si lio i lengi, na ko paalahea a God. Oto e nisie mo ho bred ngeena, ko si nii'i hunie mo pwaarongoisuli ingeie hunie kire ke ha'a-adoa mwala aani. Na e te'urine no'one aana e ro ho ii'e hunie ahutada mango. ");
INSERT INTO apb_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Oto ahutana mwala kire mani ngeu pote, na i purine kire ngau mango, mo pwaarongoisuli ko si ha'ahonue aawalai lu'e mwana rue aana mo ooretai ngeulaa. ");
INSERT INTO apb_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Iidu-iidunge aana mwala e ngau aana maholona, e hule aana lime sinolai mwane, ta'e iidumilana mo keni na mo mwela ka'a lae ike. ");
INSERT INTO apb_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Oto a Jisas ko si uusunge'inie mo pwaarongoisuli ingeie uri kire ke lae i na'o aana iiola hunie raune aasi po'o ta'au. Ta'e ingeie maraana e oore mola huni uusunge'inie mwala aaliho'i takoie mo henue ikire. ");
INSERT INTO apb_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","I purine e uusunge'inie mwala takoie mo henue ikire, nge e si hanetaa maraana ta'au i lengine uuwo huni aarenga'i. Na maholo ko rodohono oto i seulehi, na a Jisas ue maraana ta'au i lengine uuwo. ");
INSERT INTO apb_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Maholona na mo pwaarongoisuli e ha'atau oto wau i eesi aana iiola, na aana kire ko suehie ooru, naho na ko pwelie oto no'one iiola. ");
INSERT INTO apb_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Oto i rodo hatari dengi a Jisas e lae mai saana mo pwaarongoisuli ingeie, na ko lae mola i kolune aasi. ");
INSERT INTO apb_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Maholo kire leesie ko lae mola mai kolune aasi, kire ko tohungei me'u oto hiito'o. Oto kire ko aawara na kire ko unue oto uuri, “!Iiei! !Aakalo!” ");
INSERT INTO apb_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Ta'e a Jisas e tolana soi oto takoire na ko unue uuri, “Saemiu ke hahuroto. Ineu taane mola ni ie. Mwaanie omu me'u-me'u.” ");
INSERT INTO apb_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","A Pita ko aalamie oto a Jisas ko te'uri, “Aalaha ineu, mala uri i'oe to'ohuu, unue ne ke lae wau honosi'o i kolune aasi.” ");
INSERT INTO apb_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Oto a Jisas ko aalamie a Pita uuri, “Lae mola mai.” Oto a Pita e siho mwaanie iiola, ko aehota lae oto honosie a Jisas i kolune aasi. ");
INSERT INTO apb_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Ta'e maholo a Pita e leesie uri ooru e paine, oto ko me'u na ko aehota dodo oto i laona aasi. I leune ko si soi oto paine uuri, “!Aalaha ineu, o ke ha'a-uurieu!” ");
INSERT INTO apb_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Oto a Jisas ko tolana tapo oto i nimana na ko unue, “Hiiwalaimolinge i'oe e o'oru'e hiito'o. ?E ue ni o ko ne'isae rue-rua'a?” ");
INSERT INTO apb_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Oto kirerue ko si meni hane i laona iiola, na ooru ko tolana aapwana'i oto. ");
INSERT INTO apb_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Oto mo pwaarongoisuli kire ko pouruuru ni ha'ama'unge i na'ona a Jisas, na kire ko unue uuri, “I'oe oto Kalena God to'ohuu.” ");
INSERT INTO apb_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Maholo kire aatoholo hunie po'o ni eesi po'o wau, oto kire ko si lai aarapuu aana po'o ni henue i Kenesaret. ");
INSERT INTO apb_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Na mwala aana hanuena kire lio saie a Jisas, oto kire ha'atola hunie mo mae-maea'a aana ahutana mo henue kara'inie leune, na kire ko toolera oto mai saana a Jisas. ");
INSERT INTO apb_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Kire aitanaie uri ke toli'aasie mo iini ko mweri kire ke kele kopi mola aana ta'ena nga leu aana to'oni ingeie. Na ahutana mo iini kire kopi aana to'oni ingeie, kire awaa oto. ");
INSERT INTO apb_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Oto ngaeta mo Parise na mo ha'a-uusuli aana mo Ha'atolanga a Mosis, kire uure mwaanie i Jerusalem huni lae mai saana a Jisas, oto kire ko dolosi aana uuri, ");
INSERT INTO apb_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“?Aana e ue ni mo pwaarongoisuli i'oe kire ko heitohea mola mo ha'atolanga mo weuwaka i na'o? Aana kire ko ngeu mola, na kire ka'a hola'i hoda rere'a aana nimada i sulie tolaha diana.” ");
INSERT INTO apb_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Oto a Jisas ko aalamire ko te'uri, “?Na e ue ka'u i'omu, omu ko heitohea mo Ha'atolanga a God, na omu ko lae mola i sulie mo ha'a-uusulinge i'omu maraamiu? ");
INSERT INTO apb_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Aana a God e unue uuri, O ke ha'ama'u aana aamamu na nikemu. Na e unue no'one uuri, Nga iini nge ko ere aaelasie aamana wa nikana, e malisine uri horo-aasilana ke lae oto. ");
INSERT INTO apb_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Ta'e i'omu, omu ko ha'a-uusuli uri mala nga iinoni e to'o aana nga mei ola huni pe'ilana aamana na nikana, ta'e ko unue lo'u uuri, ‘Mei ola ngeena nou niie oto hunie a God,’ ");
INSERT INTO apb_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","urine ke su'uri ha'ama'u lo'u aana aamana na nikana pe'ie niilana mei olana hunire. Aena aana omu ko lae oto i sulie tolahamiu urine, nge omu ko mwakata'inie mola walana God eena. ");
INSERT INTO apb_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","!Omu ne'i iinoni eero-eero oto, aana omu ko lupwe'i deu-deu mola! Nga taa a God e unue hunie a Propet Aesaea ke unue i suli'omu e to'ohuu oto. ");
INSERT INTO apb_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Aana a God e unue uuri, Mwala ie kire ko ha'ama'u eeku mola aana ngidude, ta'e manatada e ha'atau hiito'o mola mwaanieu. ");
INSERT INTO apb_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Mwala ngeena kire ka'a palo-paloau ike to'ohuu. Kire ko esuie mola mo ha'atolanga ikire maraada, na kire ko ha'a-uusulie mwala huni lulu i suli'i. Oto kire ko si unue uri mo ha'atolanga ineu eeni, ta'e ha'ike.” ");
INSERT INTO apb_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Oto a Jisas e soie mwala ke lae mai saana, nge ko si te'uri hunire, “Pwaarongo diana aana nga taa ne kei unue hunie omu ke sai diana aana. ");
INSERT INTO apb_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Mo ngeulaa nge iinoni ko ngeu'i kire ka'a ha'amada'aa ike iinonine i maana God, ta'e mo wala nge ko iisitaa mwaanie ngidune ni ko ha'amada'aa.” ");
INSERT INTO apb_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Oto mo pwaarongoisuli kire lae mai saana, na kire ko te'uri hunie, “?Uri o saie taane mo Parise ko hii aaela i sulie nga taa o unue?” ");
INSERT INTO apb_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Oto a Jisas ko aalamire ko te'uri, “Toli'aasire mola, aana ahutana mo ei nge Aamaku i Lengi e ka'a hasi'i, ware-aasileni kei lae. ");
INSERT INTO apb_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","!Oto mwaanie omu aapwasu lo'u aada! Mwala maada e ulu ni ngeena, oto kire ko sare na'ona lo'u ngaeta mo ulu. Na maholo nga ulu ko na'ona ngaeta ulu, kirerue kei meni domu oto i laona kalinge.” ");
INSERT INTO apb_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Oto a Pita ko te'uri hunie a Jisas, “O ke ere luhesie ka'u mo lo'onga'inge ngeena huni'emeelu.” ");
INSERT INTO apb_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Oto a Jisas ko te'uri hunire, “!I'omu na pwaumiu e aaela no'one mola mala mwala ngeena! ");
INSERT INTO apb_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","?Uri omu ka'a lio saie ike no'one? Mei ngeulaa nge ko sili i ngidune iinoni, ko lae mola i laona oopwana, oto ko iisitaa lo'u mola mwaanie sapena. ");
INSERT INTO apb_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Ta'e mo wala nge ko iisitaa mai mwaanie ngidune iinoni, kire uure oto mai mwaanie saena. Mo iini urine nge kire sai esuie iinoni ke mada'a. ");
INSERT INTO apb_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Aena aana mo ola nge ko iisi-iisitaa mai mwaanie saena iinoni, kire sai esuie iinoni ke lo'onga'i aaela hunie ke horo, ke masi, na ke aeni ola, ke peli, ke sihoai ola eero-eero, na ke ere aaelasie ngaeta mwala. ");
INSERT INTO apb_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Mo ola nge kire sai esuie iinoni ke mada'a eena. Ta'e huni ngeu mola, na omu ka'a hodalie nimemiu mala kire unue huni'omu ngeena, leune e sa'a da ike iinoni ke mada'a i maana God.” ");
INSERT INTO apb_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","A Jisas e uure mwaanie i leune, oto ko lae hunie po'o ni henue kara'inie e ro huilume paine mo pu'o i Taea na i Saedon. ");
INSERT INTO apb_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Oto ngaeta hu'e aana hanuena, ingeie nga keni ni Jiu ha'ike, ta'e keni aana komu ni Kenan. E lae mai saana a Jisas, oto ko soie uuri, “!Kalena Deved Inemauri! Aalaha ineu, o ke aamasieu aana kele pule ineu ko tohungei si'oha'a oto hiito'o aana li'oa aaela e hite aana.” ");
INSERT INTO apb_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Ta'e a Jisas e ka'a aalamie ike a hu'ena. Oto mo pwaarongoisuli ingeie kire lae mai saana, kire ko te'uri hunie, “O ke pe'ie na o ke uusunge'i eeliho'i aana. Ko lae oto mola i sulikolu pe'ie e'engonga.” ");
INSERT INTO apb_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Oto a Jisas ko ere mola uuri, “A God e uusunge'inieu mei mola hunie mo sipu e takalo ka'u, mwala ni Israel.” ");
INSERT INTO apb_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Maholo a hu'ena e rongo urine, ko si lae mai pouruuru i na'ona na ko unue, “Aalaha ineu, o ke aamasieu.” ");
INSERT INTO apb_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Ta'e a Jisas ko ere ni aalahuunge mola i sulie mo Jiu na mo pu'o, ko te'uri hunie, “E ka'a diana ike huni aasie mola mo ngeulaa mo mwela ana mo usu.” ");
INSERT INTO apb_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Oto a hu'ena ko aalamie lo'u a Jisas uuri, “E to'ohuu taane poro paine, ta'e ma'alana mo usu na kire sai ngaa mola mo eehuhu'ei ngeulaa ko usu mwaanie mo taetahe mo aalaha ikire.” ");
INSERT INTO apb_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Oto a Jisas ko si aalamie lo'u a hu'ena uuri, “Keine, hiiwalaimolinge i'oe e tohungei peine. Nga taa o saeto'o aana kei oa oto huni'o urine.” Na oto mola aana maholona, ha'a-uurilana kalena hu'ena e lae oto. ");
INSERT INTO apb_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","A Jisas e uure i leune, e si eeliho'i mei sulie raune Aasi I Kalili. Oto e hanetaa ta'au i lengine uuwo, e si ii'o i aano huni ha'a-uusulie mwala. ");
INSERT INTO apb_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Oto mwala hunge kire lae mai saana, na kire toolea mai mo rarasi, mo ulu, mo pweu ka'a ere-ere, na mo iini e loku, na mo mae-maea'a hunge lo'u. Kire ko ne'ire i saana a Jisas, na ko ha'a-uurire oto. ");
INSERT INTO apb_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Mwala ngeena ko tohungei pangata'i aana kire ko leesie mo pweu ka'a ere-ere ko ere lo'u, mo iini e loku ko a'aila'a lo'u, mo rarasi ko lae-lae hailiu lo'u, na mo iini e ulu ko lio lo'u. Oto mo Aapoloa Aaopa ngeena kire ko si ha'amanikulu'aa God mo Israel. ");
INSERT INTO apb_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Oto a Jisas e soie mai mo pwaarongoisuli ingeie ko si te'uri hunire, “No ko tohungei aamasie mwala ienini aena aana kire ko ii'o tewa oto pe'ieu hunie e oolu hei dinge, na kire ka'a to'o aana oto nga mei ngeulaa. Nou ka'a sare uusunge'i eeliho'i ike aada mwaakule mwaanie kire maehunu i sulie tala.” ");
INSERT INTO apb_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Oto mo pwaarongoisuli ko dolosi aana uuri, “?Oto kolu kei deu oodoie ka'u mei ngeulaa malisine mwala hunge uurini i tei, na ikolu i laona hanuesala?” ");
INSERT INTO apb_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","A Jisas ko dolosi aada ko te'uri, “?E nite ho bred omu to'o aani?” Oto kire ko unue uuri, “E hiu aata ho bred mola pe'ie toota'i kele ho ii'e.” ");
INSERT INTO apb_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Oto a Jisas ko unue hunie mwala uri kire ke ii'o i aano. ");
INSERT INTO apb_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Na e toolea e hiu ho bred ngeena pe'ie mo kele ho ii'e, oto ko paalahea God. Ko nisi'i na ko nii'i hunie mo pwaarongoisuli ingeie hunie kire ke ha'a-adoa mwala aani. ");
INSERT INTO apb_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Oto ahutana mwala kire mani ngeu pote, na i purine kire ngau mango, mo pwaarongoisuli ko si ha'ahonue e hiu lu'e aana mo ooretai ngeulaa. ");
INSERT INTO apb_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Na iidumilana mwala e ngau aana maholona e hule aana e hai sinolai mwane, ta'e iidumilana mo keni na mo mwela e ka'a lae ike. ");
INSERT INTO apb_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Oto a Jisas e si uusunge'i eeliho'i aana mwala, ko hane i laona iiola, na ko lae oto hunie nga leu kara'inie huilume i Magadan. ");
INSERT INTO apb_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Ngaeta maholo mo Parise na mo Sadiusi kire lae mai saana a Jisas aana kire ko sare lupwe'i oohongie mola a Jisas aana kire lo'onga'inie uri e ka'a uure ike mwaanie a God. Oto kire ko unue hunie uuri, “O ke asuie ka'u nga hu'i-hu'ite hunie melu ke leesie.” ");
INSERT INTO apb_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Ta'e a Jisas e aalamire ko te'uri, “Maholo omu ko leesie dangi e marahalisi i seulehi, oto omu ko tolana unue oto uuri, ‘Kei dei diana oto i ho'owa eena, aana dangi e marahalisi oto.’ ");
INSERT INTO apb_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Na i maahu'o-hu'o omu ko unue lo'u uuri, ‘Kei nemo oto eena, aana salo e nonoro'a na e kokohoa'a.’ Omu sai lio saie taane dai diana na dai ta'aa aana leesilana salo mala ngeena, ta'e omu sa'a roro'a lio saie ike tolimaa aana mo ola ko reu si'iri ie. ");
INSERT INTO apb_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","!Ha'ike eena! Pwaunge ienini, omu lae otoi aaela hiito'o. Suata omu ka'a sai kineta'ini'omu ike nana a God. Omu ko sukaau taane hunie nga hu'i-hu'ite, ta'e nou sa'a asuie ike. Ta'a-ta'a hu'i-hu'ite nou sai haata'inie aamiu oto nga taa e rau aana a Propet Jona oto waite.” Oto e si ta'ela'i, ko lae oto mwaanire. ");
INSERT INTO apb_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Maholo a Jisas na mo pwaarongoisuli kire aatoholo oto hunie po'o ni eesi po'o ta'au, nge mo pwaarongoisuli kire si saie uri kire pulongo huni tola bred ada. ");
INSERT INTO apb_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Oto a Jisas ko te'uri hunire, “Omu ke lio talamiu mwaanie iis mo Parise na mo Sadiusi.” ");
INSERT INTO apb_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Oto mo pwaarongoisuli ko lae pe'i ere hailiu i matolada maraada uuri, “Ohe ko ere urine i sulie kolu ka'a tola bred ike pe'ikolu.” ");
INSERT INTO apb_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","A Jisas e saie mone ne'isaenga ikire, oto ko dolosi aada uuri, “?E ue ni omu ko tolahi'e hiito'o aana uri omu ka'a tola bred ike pe'i'omu? !Hiiwalaimolinge i'omu e lae otoi mwei-mwei hiito'o! ");
INSERT INTO apb_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","?Uri omu ka'a saie ike ue? ?Uri omu ka'a aamasito'o ike aana maholo nou nisie e lime kele ho bred ana lime sinolai mwane? ?E nite lu'e nge omu ha'ahonu'i? ");
INSERT INTO apb_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","?Na lo'u aana e hiu kele ho bred ana e hai sinolai mwane? ?E nite lu'e nge omu ha'ahonu'i? ");
INSERT INTO apb_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","?E ue ni omu ka'a saenanau aana uri nou ka'a ere-ere ike huni'omu mola i sulie mo bred? Oto no ko unue lo'u huni'omu uri omu ke lio talamiu mwaanie iis mo Parise na mo Sadiusi.” ");
INSERT INTO apb_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","I leune nge mo pwaarongoisuli ko si saie uri a Jisas e ka'a ha'a-ha'apasulire ike mola aana iis huni bred, ta'e mwaanie mo ha'a-uusulinge mo Parise na mo Sadiusi. ");
INSERT INTO apb_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Maholo a Jisas na mo pwaarongoisuli ingeie kire lae hunie po'o ni henue kara'inie huilume i Sisaria Pilipae, nge e si dodolosi aada uuri, “?Ha'alaa mwala ko unu-unue uri ineu a Kale Ni Iinoni a tei?” ");
INSERT INTO apb_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Oto kire ko aalamie uuri, “Ngaeta mo iini ko unu-unue uri i'oe a Jon Loto Maa'i e mauri eeliho'i. Na nga mo iini ko unu-unue uri i'oe a Propet Elaeja. Na ngaeta mo iini lo'u ko unu-unue uri i'oe a Propet Jeremaea wa nga iini hikana mo propet oto i na'o.” ");
INSERT INTO apb_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Oto a Jisas ko he'i dolosi lo'u aada uuri, “?Oto e ue aana i'omu? ?Ha'alaa omu ko unu-unue uri ineu a tei?” ");
INSERT INTO apb_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Oto a Saemon Pita ko aalamie uuri, “I'oe oto a Kraes, Kalena God Mau-meuri'e.” ");
INSERT INTO apb_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","A Jisas ko aalamie a Saemon Pita uuri, “!Hahu'ana oto, Saemon kalena Jon! Aana mei walaimolinge aaku ie nga iinoni e ka'a haata'inie ike aamu, ta'e Aamaku i Lengi ni e haata'inie aamu. ");
INSERT INTO apb_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Oto no ko unue huni'o Pita, i'oe oto hau, na i lengine poo-poota aani heu ie ne kei tohue soihaada'inge ineu, na ma'alana maenga na e sa'a tari mwada'u ike aana huni ohoie. ");
INSERT INTO apb_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Ne kei niie mo kii aana Aalahanga a God huni'o. Nga moi taa o ko uure honosi'i mei aano, mo ola nge a God kei uure honosi'i ni otona. Na nga moi taa o ko toli'aasi'i mei aano, mo ola nge a God kei toli'aasi'i eena.” ");
INSERT INTO apb_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Oto a Jisas e si ere honosire mwaanie kire ha'arongoa lo'u nga iini uri ingeie oto a Kraes. ");
INSERT INTO apb_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Uure aana maholona nge a Jisas e si tala'ai unu diana aana hunie mo pwaarongoisuli ingeie uuri, “E malisine uri ne ke tohungei lae oto hunie i Jerusalem. I leune mo rato ni mwane aana mo Jiu na mo na'ohai pris na mo ha'a-uusuli aana mo Ha'atolanga a Mosis, kire kei ha'asapesalu'aau aana mo ola hunge, na kire kei horo maesieu. Ta'e aana oolune nga hai dinge ne kei ta'ela'i lo'u mwaanie maenga.” ");
INSERT INTO apb_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Oto a Pita ko toolea a Jisas mwaanie ngaeta mo pwaarongoisuli, ko si lai ere aana uuri, “!O ke su'uri ere urine, aalaha paine ineu! A God e sa'a roro'a toli'aasie ike leune huni'o.” ");
INSERT INTO apb_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Ta'e a Jisas e aali'u i lengine a Pita oto ko si unue mola hunie uuri, “!Tahi mwaanieu Satan! O ke su'uri ne'ie hau ni ha'atataro hunieu. O ka'a saie ike ne'isaenga a God, ta'e o ko ere mola i sulie lio-lionga mo iinoni.” ");
INSERT INTO apb_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Oto a Jisas ko si unue hunie mo pwaarongoisuli ingeie ko te'uri, “Mala nga iini ko sare lulu i sulieu nge ke pulongosie maraana, na ke lulu i sulieu ma'alana ko sapesalu oto hiito'o mala mo iini i lengine mo po'u-po'u. ");
INSERT INTO apb_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Aana nga iini ko sare kineta'inie mola mauriha'ana, nge kei deu tekela'inie oto. Ta'e nga iini ko deu tekela'inie mauriha'ana i tehula'aku, nge kei lio oodoie maurihe huu. ");
INSERT INTO apb_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","?Ha'alaa nga mei taa diana nge iinoni kei terie aana kei to'o aana oto ahutana mo to'o-to'onga aana walumalau ie, na ko deu tekela'inie mola mauriha'ana oto i tehula'ani? ?Oto uri to'o-to'olana kei pe'ie aana maholona? !Ha'ike oto oo'oo! Nga mei ola hunie ke niie huni tola aaliho'i aana mauriha'ana, ha'ike lo'u. ");
INSERT INTO apb_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Ta'e ineu a Kale Ni Iinoni ne kei lae taane mai pe'ie mo ensel aana manikuluha'ana Aamaku huni waaie nga iini oto i sulie helelana. ");
INSERT INTO apb_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","To'ohuu no ko unue oto huni'omu uri ngaeta mo iini hikemiu mwala nge omu uure ngeena, omu kei saronai leesieu, a Kale Ni Iinoni, ne kei lae mai mala aalaha, omu ke si mae.” ");
INSERT INTO apb_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Oto i purine e oono hai dinge e saro mango, a Jisas e si toolea a Pita na a Jemes pe'ie a Jon aasine, na kire ko hanetaa ta'au i lengine toloi henue hunie kire ke ii'o maraada. ");
INSERT INTO apb_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Ta'i lengi i leune, oto sapena Jisas ko hei-oolisi oto mola i na'oda. Maana ko nu'e oto mala sato e raa, na mo to'oni ingeie ko rere'a oto mala raa-raa. ");
INSERT INTO apb_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Oto mola aana maholona a Mosis na Elaeja ko tolana maau na kirerue ko ere oto pe'ie a Jisas. ");
INSERT INTO apb_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Oto a Pita ko te'uri hunie a Jisas, “Aalaha, e tohungei diana aana i'emeelu oto i leu. Mala o ko saeto'o aana, nou sai tohue mola nga oolu aapa-aapa—nga iini nemue, nga iini nana Mosis, na nga iini nana Elaeja.” ");
INSERT INTO apb_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Maholo a Pita ko ere-ere ue urine, na mei uuru rere'a ko lae oto mai haahire, na mei wala e uure mwaanie mei uuru ngeena ko unue oto uuri, “Tohungei kaleku oto ienini, iini nou tohungei ilenimwa'e haahie. Omu ke rongo hunie.” ");
INSERT INTO apb_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Maholo mo pwaarongoisuli e rongo urine, kire pouruuru oto haahie maada i aano aana kire ko tohungei me'u oto hiito'o. ");
INSERT INTO apb_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Oto a Jisas e lae mai saadaelu, ko hele i sapeda na ko te'uri, “Omu ke ta'ela'i, na mwaanie omu me'u-me'u.” ");
INSERT INTO apb_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Oto kiraelu ko lio i lengi na kire ka'a leesie lo'u nga iini, ta'e a Jisas mola maraana. ");
INSERT INTO apb_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Maholo kire ko siho toli oto mai mwaanie toloi henue ngeena, a Jisas ko si unue hunire uuri, “Mwaanie omu unu-unue nga taa omu leesie ngeena oodoie nga iini, lai hule aana ineu a Kale Ni Iinoni ne kei ta'ela'i mwaanie maenga.” ");
INSERT INTO apb_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Oto e oolu pwaarongoisuli ngeena ko dolosi aana a Jisas uuri, “?E ue ka'u mo ha'a-uusuli aana mo Ha'atolanga a Mosis kire unue uri a Elaeja kei hola'i lae mai i na'ona a Kraes?” ");
INSERT INTO apb_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","A Jisas ko aalamire ko te'uri, “A Elaeja to'ohuu kei hola'i lae mai huni deu aakau aana ahutana walu ola loosie a Kraes. ");
INSERT INTO apb_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ta'e no ko unue huni'omu uri a Elaeja e pwani lae taane oto mai, ta'e mwala ka'a lio saie ike, oto kire talei deu mala saeda mola aana. Na kei urine lo'u aana ineu a Kale Ni Iinoni, aana mwala ngeena kei ha'asapesalu'aau no'one mala lo'onga'inge ikire.” ");
INSERT INTO apb_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Oto e oolu pwaarongoisuli ngeena ko si manata'inie uri a Jon Loto Maa'i ni a Jisas ko ere-ere i suliena. ");
INSERT INTO apb_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Maholo a Jisas na e oolu pwaarongoisuli kiraelu lae mai hule i aano aana ruruhaa i leune, oto ngaeta iinoni e lae mai saana ko pouruuru i na'ona na ko te'uri, ");
INSERT INTO apb_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“Aalaha ineu, o ke aamasie kele mwa'u ineu, aana ko tohungei si'oha'a oto hiito'o aana li'oa aaela nge aana. Maholo li'oa aaela ngeena kei hulesie, oto ko pweu oto. Ngaeta mo maholo hule aana ko lai dou-domu i laona dunge, na nga mo maholo no'one i laona wai. ");
INSERT INTO apb_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Nou toolea ka'u mei saana mo pwaarongoisuli i'oe, ta'e kire ka'a sai ha'a-uurie ike.” ");
INSERT INTO apb_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Oto a Jisas ko aalamie a mwaena ko te'uri, “I'omu pwaunge si'iri ie, i'omu mo iinoni aaela, suata mone hule aana omu ka'a hiiwalaimoli ike aana a God. !No ko talei ha'aweoau oto mola pe'i'omu! ?Uri ne kei ii'o tewa ka'u lo'u uri taa pe'i'omu, omu ke si hiiwalaimoli? Toolea ka'u mei a mwa'une i seeku.” ");
INSERT INTO apb_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Oto a Jisas e ere aana li'oa aaela ngeena, nge ko si tehi mwaanie, na a mwa'une ko tolana diana oto aana maholona. ");
INSERT INTO apb_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Mango urine, mo pwaarongoisuli e si lae lo'u maraada i saana Jisas, na kire ko dolosi aana uuri, “?E ue ka'u nge i'emeelu, melu ka'a sai oohe aasie li'oa aaela ngeena mwaanie a mwa'une?” ");
INSERT INTO apb_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Oto a Jisas ko aalamire ko te'uri, “Aena aana hiiwalaimolinge i'omu e ka'a susu ike aana a God. No ko unue oto huni'omu, mala uri hiiwalaimolinge i'omu ke paine mola mala nga kele litei ola, na omu sai unue mola hunie uuwo ie uuri, ‘Lae wau i leune,’ na kei lae oto. Nga mei ola e sa'a aasai'omu ike.” ");
INSERT INTO apb_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Oto maholo ahutana mo pwaarongoisuli kire mani loko lo'u mai saana i Kalili, a Jisas e si unue hunire uuri, “Kara'inie oto kire kei pweloau a Kale Ni Iinoni hunie mo iinoni ");
INSERT INTO apb_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","kei horo maesieu. Ta'e i purine e oolu hei dinge, ne kei he'i meuri eeliho'i lo'u.” Maholo mo pwaarongoisuli kire rongo urine kire ko tohungei saehuu oto hiito'o. ");
INSERT INTO apb_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Oto maholo a Jisas na mo pwaarongoisuli ingeie kire lae mai hule i Kapaneam, mo mwane ko totola to'oha hunie Nume Maa'i Peine i Jerusalem kire lae mai saana Pita na kire ko dolosi aana uuri, “?Uri ha'a-uusuli i'omu ko nii-nii taane hunie Nume Maa'i Peine? Sa'a mola e ka'a sai nii ike.” ");
INSERT INTO apb_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Oto a Pita ko te'uri, “!Ha'ike! Ko nii taane.” Oto lae-lae, maholo a Pita e lai sili i nume nge kire o'o'o aana, oto a Jisas ko hola'i dolosi oto aana uuri, “?Saemon, nga taa ni lo'onga'inge i'oe? ?A tei ni ko niie mo takis hunie mo inemauri mei aana walumalau ie? ?Mo kaleda wa mwala aaopa?” ");
INSERT INTO apb_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","A Pita ko aalamie a Jisas ko te'uri, “Mwala aaopa.” Oto a Jisas ko he'i te'uri lo'u, “Nge ko urine, mo kaleda ka'a nii ike ka'une. ");
INSERT INTO apb_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Ta'e aana ke urine, na kolu ka'a saeto'o aana ike uri mwalana ke ne'isae aaelasikolu. Oto o ke lae, na o ke lai aasie walo hai laona aasi ngeena. Ho ii'e o kei hola'i we'inie, o ke lio i laona wawana, na i leune o kei lio oodoie nga seleni malisine nga taa kire ko sukaa mwaanikure. O ko hele aana, oto o ko lai niie hunire arengakarue.” ");
INSERT INTO apb_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Oto aana maholona mo pwaarongoisuli e lae mai saana a Jisas, kire ko dolosi aana uuri, “?A tei aameelu ni kei peine liutaa aana Aalahanga a God?” ");
INSERT INTO apb_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Oto a Jisas e soie mai ngaeta kele mwela hunie ke uure i matolada, ");
INSERT INTO apb_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","ko si te'uri, “No ko unue oto huni'omu uri, nge omu ka'a oolisie tolahamiu hunie omu ke urihana mwe-mwela, omu sa'a roro'a malisine ike silinge i laona Aalahanga a God. ");
INSERT INTO apb_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Aena aana nga iini oto ko ha'amwai-mwei'aa mala kele mwela ie, ingeie oto kei tohungei peine aana Aalahanga a God. ");
INSERT INTO apb_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Ta'ena nga iini nge ko tola konie nga kele mwela mala ienini aana sataku, nge ko tola konieu eena.” ");
INSERT INTO apb_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Oto a Jisas ko he'i ere uuri lo'u, “Oto mala nga iini ko ha'atataroa nga kele iini aana mo iini ko hiiwalaimoli eeku ienini, e lae otoi diana hunie iini urine pwarolana nga hau peine ke lae mola i luana, oto kulu-aasilana ke lae mola i laona aasi. ");
INSERT INTO apb_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Aama-aamasilana mo iinoni aana walumalau ie aena aana mo ola ni ha'atataro e hunge huni ta'aasie hiiwalaimolinge ikire. Walu ola urine kei reu-reu tarau taane, ta'e aama-aamasilana iini nge ko ne'ie hau ni ha'atataro. ");
INSERT INTO apb_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Mala uri nimemu wa ae'aemu ko ha'atataro'o huni ooraha'aa, o ke lama mousie na o ke aasie mwaani'o. Aana e diana oto liutaa huni'o huni sili i laona maurihe huu pe'ie ta'a-ta'a ninime wa ta'a-ta'a ae'ae, mwaanie kire aasi'o pe'ie ahutana ro nimemu wa ro ae'aemu i laona dunge nge ka'a sai mwa'a lo'u. ");
INSERT INTO apb_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Na mala maamu ko ha'atataro'o huni ooraha'aa, o ke kae aasie mwaani'o. Aana kei diana oto liutaa huni'o huni sili i laona maurihe huu pe'ie ta'a-ta'a po'o ni maa, mwaanie kire aasi'o pe'ie ahutana ro maamu i laona dunge ni ha'amotaahinge.” ");
INSERT INTO apb_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Oto a Jisas ko he'i te'uri lo'u, “Omu ke lio talamiu mwaanie omu lio tolinge'inie nga kele iini aana mo iini e hiiwalaimoli eeku. Aana no ko unue oto huni'omu uri ikire kire to'o aana mo ensel huni kakalire, na mo ensel ngeena kire sai ere mola pe'ie Aamaku i Lengi aana ta'ena nga maholo. ");
INSERT INTO apb_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“?Mala uri nga mwane e to'o aana tangalai sipu, na uri nga ta'a-ta'a iini eeni e takalo, a mwane ngeena kei ue? Kei toli'aasie oto siwe aawala mwana siwe aana leu kire ko ngeu-ngeu aana i lengine uuwo, na kei lae otoi heitalea iini nge e takalo lai hule aana kei lio oodoie. ");
INSERT INTO apb_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Na mala uri kei lio oodoie, no ko unue oto huni'omu uri kei tohungei ilenimwa'e oto liutaa haahie, mwaanie siwe aawala mwana siwe nge kire ka'a takalo ike. ");
INSERT INTO apb_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","E urine lo'u aana Aamaku i Lengi, e ka'a saeto'o aana ike uri nga ta'a-ta'a kele iini aana mo iini e hiiwalaimoli eeku ke takalo.” ");
INSERT INTO apb_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Oto a Jisas ko he'i te'uri lo'u, “Mala nga aasimu i laona Kraes ko deu aaelasie nga mei ola aamu, o ke lae mola i saana maraamu hunie more ke ha'a-oodohie i matolamore'i mola maraamore'i. Mala uri aasimu ko rongo hunie nga taa o kei unue, e urihana o tola aaliho'i lo'u aana aasimu eena hunie more ke ii'o diana lo'u. ");
INSERT INTO apb_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Ta'e mala uri e ka'a rongo oto huni'o, nge o ke dau mala Uusu-uusu Maa'i e unue, na o ke toolea nga iini wa e rue lo'u pe'i'o, hunie e ro iinoni ngeena kire ke ha'a-ahue walamu. ");
INSERT INTO apb_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Na mala uri e ka'a rongo oto no'one huni'omoolu, unue lo'u mei olana hunie soihaada'inge. Na leu ooreta mola uri, mala e ka'a rongo oto hunie soihaada'inge, toli'aasie hunie ke ii'o oto mola i sinaha mala iinoni ni pu'o wa mala iini peli-peli. ");
INSERT INTO apb_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Oto no ko unue lo'u huni'omu uri, nga moi taa omu ko uure honosi'i mei aano, mo ola nge a God i Lengi na e uure honosi'i ni otona. Na nga moi taa omu ko toli'aasi'i mei aano, mo ola nge a God i Lengi na e toli'aasi'i eena. ");
INSERT INTO apb_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Na lo'u no ko unue huni'omu, mala uri nga ro iini hikemiu mei aano i leu ko ne'isae tararuru huni sukaa nga mei ola aana a God, nge niilana kei lae hunirerue mwaanie Aamaku i Lengi. ");
INSERT INTO apb_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Aana nga ro iini wa e oolu eemiu kei ruru aana sataku aana ta'ena nga leu, nge ineu oto no'one i matolamiu i leune.” ");
INSERT INTO apb_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Oto a Pita e lae mai saana a Jisas ko si dolosi aana uuri, “?Aalaha ineu, mala uri aasiku kei lae mola pe'i deu hu'isieu tarau, ne kei sae'aasi hunie ha'anite? ?Uri ne kei sae'aasi hunie e hiu maholo, na e kohi oto?” ");
INSERT INTO apb_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Oto a Jisas ko aalamie uuri, “!Ha'ike! Nou ka'a unue ike e hiu aata maholo, ta'e e hiu aawalai maholo ha'ahiu. ");
INSERT INTO apb_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Aana Aalahanga a God e urihana nga aalaha e sare saie uri mwala paine aana mwala au'esu ingeie kire ko esu uri taa taane aana mo to'oha ingeie. ");
INSERT INTO apb_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Oto maholo ko aehota dau i suli'i, kire ko toolea mai mwane e tekela'inie molani-ola aani to'oha aana mo to'oha aalaha ingeie. ");
INSERT INTO apb_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Na a mwaena e ka'a malisine ike lo'u kei su'ue mei to'oha ngeena. Oto aalaha ingeie e unue mola uri kire ke ha'aholinge'i aasie a mwaena mola pe'ie hu'e ingeie na mo kalena na oto ahutana to'o-to'olana, hunie mei to'oha ni su'ue mo to'oha nge e waeli'i. ");
INSERT INTO apb_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","“Ta'e oto mola aana maholona, koni-konihe ngeena e tolana lae mai pouruuru i na'ona aalaha ingeie, na ko ngara aamasie oto uuri, ‘Aalaha ineu, o ke aamasieu na o ke rongo rako ka'u eeku hunie ne ke si saro su'u mango'i taane.’ ");
INSERT INTO apb_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Oto aalaha ingeie ngeena e aamasie oto hiito'o, e si unue mola hunie koni-konihe ngeena uri e sae'aasie mo roro'anga ingeie oto hunie, na e unue uri e sa'a su'u'i lo'u. ");
INSERT INTO apb_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Oto koni-konihe ngeena e iisitaa ta'au na ko oodoie ngaeta iini oana, mwane lo'u mala ingeie. A mwaena e toolea mola ta'a-ta'a tangalau aani to'oha mwaanie. Oto e tapo i luana oana, na ko unue uuri, ‘O ke su'ue mo to'oha ineu oto molana.’ ");
INSERT INTO apb_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","“Ta'e a mwane oana ngeena ko pouruuru i na'ona, na ko unue uuri, ‘Ne'ewau, o ke kele maa'oohi ke'u. Ne kei saro su'u mangoa taane mo to'oha i'oe.’ ");
INSERT INTO apb_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","“Ta'e a mwaena e ka'a sare maa'oohi ike lo'u. Oto e unue mola kire ke toolea mwane oana ngeena, na kire ke lai ne'ie i laona nume ni ho'o hunie ke ii'o i leune, hule aana kei saro su'u mangoa mo to'oha ingeie. ");
INSERT INTO apb_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","“Maholo ngaeta mo koni-konihe oana kire rongoa nga taa e raune, kire ko tohungei saewasu. Oto kire lae i saana aalaha ngeena, na kire ko ha'arongoa aana ahutana mo ola e raune. ");
INSERT INTO apb_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","“Oto aalaha ngeena e he'i soie lo'u mei koni-konihe ingeie ngeena ko si te'uri hunie, ‘I'oe oto koni-konihe aaela. Ineu ka'u nou aamasi'o na nou sae'aasie huni'o uri o sa'a su'ue lo'u mo to'oha paine ineu aana o ha'atohu eeku. ");
INSERT INTO apb_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","?Na e ue o ka'a aamasie iini oamune oto mala nou aamasi'o?’ ");
INSERT INTO apb_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Oto aalaha ingeie e saewasu e si uusunge'inie koni-konihe ngeena i laona leu ni ha'amotaahinge, uri ke ii'o i leune lai hule aana kei saro su'u mangoa ahutana mo to'oha nge e waeli'ine.” ");
INSERT INTO apb_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Oto a Jisas ko si ha'amangoa ere-erenga ingeie na ko unue uuri, “Aitana nga taa nge Aamaku i Lengi kei da huni'omu eena, aana uri omu ka'a sae'aasi to'ohuu hunie mo eesimiu.” ");
INSERT INTO apb_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Oto i purine a Jisas e saro ere-ere mango i sulie walu ola ienini, e si lae mwaanie i Kalili hunie po'o ni henue i Jiudia na lo'u hunie aapa po'o wau aana wai peine i Jodan hatarie sato pwaa. ");
INSERT INTO apb_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Mwala hunge kire lae i sulie, na e lai ha'a-uurire oto ta'i leune. ");
INSERT INTO apb_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Oto ngaeta mo Parise kire lae mai saana aana kire ko sare lupwe'i dolosi pweloa, oto kire ko dolosi aana uuri, “O ke unue ka'u oodoi'emeelu. ?Uri e diana taane aana mo Ha'atolanga ikie hunie poro ke sikaa mola hu'e ingeie i sulie saena?” ");
INSERT INTO apb_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","A Jisas e aalamire oto ko te'uri, “?Uri omu ka'a saie ike mo Uusu-uusu Maa'i e unue uuri, aana aehotalana a Ha'ahola e ha'aholaa mwane na keni? ");
INSERT INTO apb_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Oto a God e si unue uuri, Aena aana leune, nge nga mwane kei lae mwaanie aamana na nikana, kei ii'o ruru oto pe'ie hu'e ingeie, na kirerue kei ne'ie oto ta'a-ta'a iinoni. ");
INSERT INTO apb_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Aena ngeena kirerue ka'a ne'ie lo'u nga ro iinoni hai aaopa'i, ta'e e ta'a-ta'a iinoni oto. Na nga mei ola nge a God e ho'o rurue oto, mwaanie nga iini e he'i oopa-oopaa lo'u.” ");
INSERT INTO apb_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Oto mo Parise ko dolosi lo'u aana uuri, “?Nge ko urine, aana e ue ka'u nge a Mosis e unue aana ha'atolanga uri poro e sai sikaa mola hu'e ingeie mala uri ko hola'i uusue nga uusu-uusu aani sikanga?” ");
INSERT INTO apb_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","A Jisas ko aalamire lo'u uuri, “A Mosis e maaie mola uri omu ke sikaa mo hu'e i'omu aena aana saemiu e lae otoi heu. Ta'e aana ne'isaenga a God i aehotalana ha'aholanga e ka'a urine ike. ");
INSERT INTO apb_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Oto no ko unue huni'omu uri nga iini ko sikaa mola hu'e ingeie i tehula'ana nga mei ola aaopa, na a hu'ena e ka'a masi ike pe'ie nga iini, ingeie ngeena ko mesi oto mala uri kei to'o aana lo'u nga hu'e aaopa.” ");
INSERT INTO apb_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Oto mo pwaarongoisuli ingeie ko te'uri hunie, “Nge mala o unue uri nga mwane ke su'uri sikaa hu'e ingeie, e diana oto liutaa uri mo mwane ke su'uri tola hu'e.” ");
INSERT INTO apb_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Oto a Jisas ko he'i te'uri lo'u hunire, “E to'ohuu oto uri tola-hu'anga e ka'a ii'o ike hunie ahutana iinoni, ta'e hunie mola mo iini a God e niie oto hunire. ");
INSERT INTO apb_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Ngaeta mo iini kire ka'a sai tola hu'e ike, aena aana kire hute mola na kire ka'a sare aapwasu ike aana tola-hu'anga. Ngaeta mo iini lo'u kire ka'a tola hu'e ike aana mwala ko ha'a-ha'amau'ora mwaanie. Na nga mo iini lo'u kire ka'a sare tola hu'e ike, mwaanie kire tolahi'e lo'u aana nga mei ola aaopa mwaanie Aalahanga a God. Ta'e nga iini nge a God ko niie oto hu'e nana, ke hele diana aana oto ha'a-uusulinge ngeena.” ");
INSERT INTO apb_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Oto mwala ko toolea mai mo mwela i saana a Jisas hunie ke hele i pweude aana nimana, na hunie ke aarenga'i talada. Ta'e mo pwaarongoisuli ko ere aada mola. ");
INSERT INTO apb_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Oto a Jisas ko ere aana mo pwaarongoisuli uuri, “Omu ke toli'aasie mo mwela hunie kire ke lae mai seeku, na omu ke su'uri uure honosire. Aena aana mo iini kire urihana mo mwela ngeena ha'alaa kire ko sili i laona Aalahanga a God.” ");
INSERT INTO apb_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Oto e hele i pweude aana nimana, e ha'adiana'ara, e si lae mwaanie i leune. ");
INSERT INTO apb_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Ngaeta maholo nga mwane e lae mai saana a Jisas, oto ko dolosi aana uuri, “?Ha'a-uusuli, nga mei taa diana ni ne kei esuie ka'u hunie ne ke hele aana maurihe huu?” ");
INSERT INTO apb_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Oto a Jisas ko te'uri hunie, “?E ue ni o ko dolosie diananga aaku? Ta'a-ta'a iini mola nge e diana, na mala o ko sare hele aana maurihe huu o ke tola i sulie mo Ha'atolanga ingeie.” ");
INSERT INTO apb_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Oto a mwaena ko he'i dolosi lo'u uuri, “?Nga mo ha'atolanga uri taa eena?” A Jisas ko aalamie ko te'uri, “Ha'atolangana ka'u ie. Mwaanie o talei horo-horo, na mwaanie o mai-mesi, na mwaanie o peli-peli, na mwaanie o pwelu wala eero-eero. ");
INSERT INTO apb_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","O ke ha'ama'u aana aamamu na nikemu, na o ke manata diana hunie auhenue i'oe oto mala o manata diana huni'o maraamu.” ");
INSERT INTO apb_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Oto a saanau ngeena ko te'uri hunie a Jisas, “Nou tola i sulie ahutana mo ha'atolanga ngeena mango. ?Oto nga taa ue hunie ne ke asuie?” ");
INSERT INTO apb_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","A Jisas ko si unue hunie uuri, “Mala uri o ko sare ii'o oodota'i oto, o ke lae, na o ke ha'aholinge'inie to'o-to'olamu. Oto o ko niie mo to'oha aani nana mo iinoni meitale, aana ko urine nge o ke si to'o-to'o lo'u aana mo ola diana i Lengi. Mango urine, o ke si lae mai lulu i sulieu.” ");
INSERT INTO apb_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","A mwaena e rongo urine, oto ko si lae mwaanie pe'ie saehuunge paine aena aana e tohungei to'o-to'o oto liutaa. ");
INSERT INTO apb_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Oto a Jisas ko si unue hunie mo pwaarongoisuli ingeie uuri, “No ko unue oto huni'omu uri kei tohungei aasa hunie mwala e to'o-to'o ke toli'aasie a God hunie ke aalaha haahire. ");
INSERT INTO apb_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Na no ko he'i unue lo'u uri e mwada'u mola hunie uri nga kamel kei sili i sulie kele waa-waata aana nile tau-teuri, liutaa aana iinoni to'o-to'o ke sili i laona Aalahanga a God.” ");
INSERT INTO apb_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Maholo mo pwaarongoisuli kire rongo urine kire tohungei pangata'i oto liutaa, na kire ko dolosi uuri, “?Oto a tei ke'u ke si helesie maurihe huu?” ");
INSERT INTO apb_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","A Jisas e to'omaaire, ko si aalamire uuri, “Walu ola ienini kire aasa oto hiito'o hunie iinoni, ta'e hunie a God kire mwada'u mola.” ");
INSERT INTO apb_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Oto a Pita ko te'uri hunie a Jisas, “Lio ka'u. I'emeelu, melu meni toli puri oto aana to'o-to'olameelu, na melu ko lulu i suli'o oto. ?Nga mei taa ni melu kei terie aana leune?” ");
INSERT INTO apb_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Oto a Jisas ko si unue hunire uuri, “No ko unue oto huni'omu uri aana walumalau haalu, maholo ineu a Kale Ni Iinoni ne kei ii'o i lengine naunekume ni menikulu'anga ineu, i'omu mo iini nge omu ko lulu i sulieu, omu kei ii'o no'one i lengine aawalai neunekume mwana rue huni leie aawalai komu mwana rue mo Israel. ");
INSERT INTO apb_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Na ka'a ta'e ike mola i'omu, ta'e ta'ena nga iini ko toli puri aana nume ingeie, wa aasine mwane, wa aasine keni, wa aamana, wa nikana, wa hu'e ingeie, wa mo kalena, wa mei aano ingeie i tehula'ana sataku, nge kei hele ha'atangalau lo'u liutaa aana nga taa e toli puri ke'u aana, na kei hele aana oto tohungei waaite aana maurihe huu. ");
INSERT INTO apb_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Aana mo iini hunge kire ko na'o ka'u oto ie, kire kei saro puri mola. Na mo iini hunge kire ko puri oto ie, kire kei saro na'o lo'u mola.” ");
INSERT INTO apb_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Oto a Jisas ko he'i ere lo'u uuri, “Aalahanga a God e urihana nga na'ohai mwane nge e to'o aana hohola, na e iisitaa oto i maahu'o-hu'o huni haaraie nga mwala huni holire huni esu nana aana hohola ingeie. ");
INSERT INTO apb_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Oto kire mani ne'isae moute'i pe'ie na'ohai mwane ngeena uri kei holire aana waaite diana aana ta'a-ta'a seleni ni Rom aana hai dinge. Nge e si uusunge'inire ta'au i laona hohola ingeie. ");
INSERT INTO apb_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","“Aana siwana nga maholoi sato aana aapa i ho'owa, e tapaliu na ko leesie ngaeta mwala kire uure mola mwaakule aana leu ni uusi'e. ");
INSERT INTO apb_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Oto ko unue hunire uuri, ‘Omu ke lae no'one i esu nekue aana hohola ineu, na ne ke si waai'omu taane adona asunge i'omu.’ ");
INSERT INTO apb_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Oto kire ko lae oto i esu. Na oto i upui aatowaa na lo'u i aapai sato ko he'i te'urine lo'u. ");
INSERT INTO apb_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","“Oto maholo ko kara'inie limana nga maholoi sato i seulehi, e lai liu lo'u i saana leu ni uusi'e na ko leesie ngaeta mwala kire uure mola mwaakule. Oto ko dolosi lo'u aada uuri, ‘?E ue omu ko talei uure-uure oto mola mwaakule hunie hai dinge laku urine?’ ");
INSERT INTO apb_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","“Oto kire ko aalamie uuri, ‘Sulie nga iini huni esu nana ha'ike.’ “Oto ko unue hunire uuri, ‘Nge ko urine, omu ke lae no'one i hohola ineu huni esu nekue.’ ");
INSERT INTO apb_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Oto i seulehi, na'ohai mwane paine ngeena ko unue hunie na'ohana mwala au'esu uuri, ‘Soie mai mwala au'esu, na o ke niie mo to'oha ikire hunire. O ke tala'ae aana mo iini kire hule ha'i puri, o si lai ha'amango aana mo iini kire hule hola'ina'o.’ ");
INSERT INTO apb_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","“Mo mwane e aehota asu aana limana nga maholoi sato i seulehi, kire lae mai, oto kire ko toolea ta'a-ta'a seleni ni Rom nga mwane. ");
INSERT INTO apb_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Oto e lae urine, lai hule aana mo iini nge kire aehota asu oto uure i maahu'o-hu'o. Ikire, kire lae lo'u mei huni toolea waaitada, na kire ko lo'onga'inie uri kire kei tola liutaa aana mo iini nge kire aehota asu ha'i puri. Ta'e kire si lio, na kire ko meni tola sada lo'u mola aana ta'a-ta'a seleni nga iini. ");
INSERT INTO apb_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Kire tola to'oha mango, kire ko si aehota upwesie na'ohai mwane ngeena. ");
INSERT INTO apb_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Kire ko te'uri, ‘!Sei! Mwala kire lae poi puri ie kire asu mola hunie ta'a-ta'a maholoi sato, oto o ko si holi sada aada lo'u mola pe'ie mo iini melu esu hunie hai dinge laku i laona sato raramea.’ ");
INSERT INTO apb_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“Oto na'ohai mwane ngeena e aalamie ngaeta iini aada na ko te'uri, ‘Rongo ka'u malahuku, nou ka'a ha'amwe'u-mwe'u'o ike. O haiholota'inie ka'u hunieu uri o ne'isae moute'i huni esu uana ta'a-ta'a seleni aani dinge. ");
INSERT INTO apb_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Toolea mo to'oha i'oe na o ke aaliho'i mola i nume, aana nou sare niie no'one mola hunie iini e lae mai puri ie mala oto nou niie ka'u huni'o. ");
INSERT INTO apb_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","?Uri e ka'a adona ike ne ke dau mala saeku aana mo to'oha ineu maraaku? ?Wa omu ko upwesieu mola aana no ko deu diana aana mo iinine urine?’” ");
INSERT INTO apb_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Oto a Jisas ko si ha'amangoa ere-erenga ingeie na ko te'uri, “Mo iini hunge nge kire ko puri oto ie kire kei lae lo'u i na'o, na mo iini e na'o-na'o ka'u kire kei he'i puri lo'u.” ");
INSERT INTO apb_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Oto maholo a Jisas e lae hunie i Jerusalem, e si toolea aawalai pwaarongoisuli mwana rue maraada, na ko lae pe'i ere-ere nada lae-lae'i uuri, ");
INSERT INTO apb_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Kolu ko lae oto hunie i Jerusalem eena, na ineu a Kale Ni Iinoni, pwelolaku kei lae oto ta'au i leune. Kire kei niieu oto i nimana mo na'ohai pris na mo ha'a-uusuli aana mo Ha'atolanga a Mosis huni lei mae aaku. ");
INSERT INTO apb_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Oto kire kei he'i niieu lo'u hunie mo Aapoloa Aaopa huni ha'amwasi eeku, na huni wini-winieu, na huni horo maesieu i lengine po'u-po'u. Ta'e aana oolune nga hai dinge, ne kei ta'ela'i eeliho'i lo'u mwaanie maenga.” ");
INSERT INTO apb_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Oto hu'e a Sebedi e lae mai saana a Jisas pe'ie e ro kalena mwane, ko pouruuru i na'ona, na ko sukaa uri ke pe'ie. ");
INSERT INTO apb_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Oto a Jisas ko dolosi aana a hu'ena uuri, “?Nga ola taa ni o saeto'o aana?” Oto a hu'ena ko aalamie uuri, “Ne kei tohungei ilenimwa'e aana o kei ne'ie e ro kaleku ienini ke aalaha pe'i'o aana e ro na'ohai leu aana aalahanga i'oe, nga iini i pwalo-pwalomu na nga iini i meu-meulimu.” ");
INSERT INTO apb_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Oto a Jisas ko unue hunie e ro mwaasine ngeena uuri, “More ka'a saie ike nga taa more ko sukaa ni ngeena. ?Uri more sai hotela'inie taane iiola ne kei hotela'inie? ?Wa kei hi'e huni'omore'i?” Oto e ro mwaasine ko aalamie uuri, “Mere sai esuie mola.” ");
INSERT INTO apb_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Oto a Jisas ko unue lo'u hunirerue uuri, “To'ohuu more kei hotela'inie taane iiola ne kei hotela'inie, ta'e uri hunie ii'onga i pwalo-pwaloku na i meu-meuliku, e ka'a leu ike i sapeku huni niie hunie nga iini, aana e ro ii'o-ii'oha ngeena kire ii'o oto loosie mo iini Aamaku e lio hilisire.” ");
INSERT INTO apb_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Maholo ngaeta aawalai pwaarongoisuli lo'u kire rongoa sukanga ro mwaasine, oto kire ko si saewasulie e ro mwaasinena. ");
INSERT INTO apb_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Ta'e a Jisas e mani soire mai saana, ko si unue hunire uuri, “Omu saie oto uri mo aalaha ni welumalau kire ko sasare haata'inie nanamanga ikire haahie mwala ikire, na mo na'ohai mwane kire sai deu rarahie no'one mwala huni lae i sulie mo heri-huninge ikire. ");
INSERT INTO apb_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Ta'e i'omu, omu ke su'uri te'urine i matolamiu. Nga iini hikemiu ko sare aalaha, ke ne'i iinoni eu'esu nemiu. ");
INSERT INTO apb_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Na nga iini hikemiu ko sare ne'i na'ohai mwane haahi'omu, nge ke ne'i koni-konihe nana ahutemiu mango. ");
INSERT INTO apb_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Mala oto ineu a Kale Ni Iinoni nou ka'a lae ike mai hunie uri mwala ke asu nekue, ta'e nou lae mai huni ne'i koni-konihe nana mwala, na huni niie mauriha'aku i tehula'ana mwala hunge, na huni holi eeliho'i aana mwala hunge.” ");
INSERT INTO apb_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Maholo a Jisas na mo pwaarongoisuli ingeie kire ko lae mwaanie hanue i Jeriko, mwala oto hunge kire ko lae no'one i sulire. ");
INSERT INTO apb_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","E ro mwane e ulu kirerue o'o'o i reune tala i leune, na kirerue ko rongoa uri a Jisas nge ni ko tapaliu. Oto kirerue ko aehota aawara oto uuri hunie, “!Aalaha paine! !Kalena Deved Inemauri, o ke aamasi'emere'i!” ");
INSERT INTO apb_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Oto mwala ko ere aadarue uri kirerue ke rohu. Ta'e kirerue ko si aawara oto lo'u liutaa uuri, “!Aalaha paine! !Kalena Deved Inemauri, o ke aamasi'emere'i!” ");
INSERT INTO apb_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Oto a Jisas e uure hahuroto, ko dolosi aadarue uuri, “?Nga taa ni more saeto'o aana ne ke da huni'omore'i?” ");
INSERT INTO apb_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","E ro mwane e ulu ngeena ko aalamie a Jisas uuri, “Aalaha paine, saemere'i hunie mere ke lio-lio lo'u.” ");
INSERT INTO apb_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","A Jisas e aamasirerue, ko si hele wau i maadarue, na maadarue ko tolana lio-lio lo'u. Oto kirerue ko si lae i sulie. ");
INSERT INTO apb_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Oto maholo a Jisas na mo pwaarongoisuli ingeie kire lae hunie i Jerusalem, kire ko nanauhie oto wau huilume i Betfeis, kara'inie Uuwo Ni Ei Olif. I leune a Jisas ko uusunge'inie e ro pwaarongoisuli i na'o, ");
INSERT INTO apb_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","na ko ha'ananaurerue uuri, “More ke lae i na'o hunie hanue nge kolu ko leesie ta'aune, na more kei leesie nga dongki kire pwasue ta'au i leune, na kalei dongki no'one pe'ie. Oto more ko luhesi'i, more ke mani toole'i mai hunieu. ");
INSERT INTO apb_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Mala uri nga iini ko dolosi aamore'i uuri, ‘?More ko luhesi'i huni taa?’ oto more ke unue oodoie uuri, ‘A poro paine e saeto'o aani, na kei ha'atola'i eeliho'i taane lo'u mei lau-leu.’” ");
INSERT INTO apb_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Mo ola ienini ko reu urine huni ha'a-oaie nga taa propet e unue uuri, ");
INSERT INTO apb_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Omu ke unue hunie hanue paine i Jerusalem uuri, “Lio ka'u. Inemauri i'omu ko lae mai seemiu. Ingeie e ha'amwai-mwei'aa na e ta'e i lengine dongki, na dongki ngeena kalei ola mola.” ");
INSERT INTO apb_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Oto e ro pwaarongoisuli kire lae ta'au, kire ko deu oto i sulie nga taa a Jisas e unue hunirerue, ");
INSERT INTO apb_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","na kirerue ko toolea oto mai e ro dongki ngeena i saana. Kire ne'ie mo sala ikirerue i kolune e ro dongki ngeena, nge a Jisas e si ta'e. ");
INSERT INTO apb_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Oto mo iini hunge aana pulitaa oto paine ngeena, kire ko eepasie tala aana mo to'oni ikire, kire ko lamasie mo kele sasarai ei na kire holasi'i no'one i sulie tala. ");
INSERT INTO apb_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Oto mwala kire na'o na mo iini i purine a Jisas, kire ko si lae pe'i soi oto paine, na kire ko lahea God uuri, “!Ha'amanikulu'aa Kalena Deved Inemauri! !A God ke ha'adiana'aa iini ko lae mai nunuha'ana satana Aalaha! !Ha'amanikulu'aa God i Lengi!” ");
INSERT INTO apb_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Maholo a Jisas e lai hule ta'au i Jerusalem, ahutana mwala kire ko si huru heiliu pe'ie mawanga paine, na mwala ko dolosi heiliu uuri, “?A tei ni ko hule ngeena?” ");
INSERT INTO apb_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Oto mwala nge ko lae pe'ie a Jisas kire ko aalamire uuri, “A Jisas ni oto ie, propet uure i Nasaret aana po'o ni henue i Kalili.” ");
INSERT INTO apb_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Oto a Jisas e lai sili oto i laona lolata aana Nume Maa'i Peine, na ko aehota oohea mwala ko holi-holi na mo iini ko ha'a-ha'aholinge'i ola. Ko keusie oto no'one mo taetahe mwala ko ooli-oolisi to'oha, na mo leu ni ii'o-ii'o ikire mo iini ko ha'aholinge'i hiroikuu. ");
INSERT INTO apb_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Na ko ere aada uuri, “A God e unue aana mo Uusu-uusu Maa'i uuri, Nume ineu oto nume ni aarenga'inge. Ta'e omu ko si da mola ko ne'i hahale kira horopeli kire sai mumuni i laona.” ");
INSERT INTO apb_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Oto mo ulu na mo rarasi kire lae mai saana hai Nume Maa'i Peine, na e ha'a-uurire. ");
INSERT INTO apb_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Ta'e mo na'ohai pris na mo ha'a-uusuli aana ha'atolanga a Mosis, kire ko saewasu mola aana maholo kire leesie mo ola ni pangata'inge ko deu'ine, na kire ko rongoa mo mwela ko toolea soinge hai Nume Maa'i uuri, “!Ha'amanikulu'aa Kalena Deved Inemauri!” ");
INSERT INTO apb_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Oto kire ko dolosi aana Jisas uuri, “!Hai! ?Uri o ko rorongoa taane nga taa mo mwela ko unu-unuena?” A Jisas ko aalamire uuri, “!Si'ue! !No ko rorongoa taane! ?Ta'e e ue i'omu, omu ka'a rongo saie ike mo Uusu-uusu Maa'i nge omu ko saa-saai'i tarau? Aana Uusu-uusu Maa'i e unue uuri, O ha'asaie mo mwela na mo wee-wee mwai-mwei hunie kire ke ha'amanikulu'a'o God.” ");
INSERT INTO apb_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Oto a Jisas e toli'aasire na ko iisitaa oto mwaanie huilume paine i Jerusalem, ko si lai ma'ahu oto aana huilume i Betani. ");
INSERT INTO apb_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Oto e dangi ho'owa a Jisas ko eeliho'i lo'u hunie i Jerusalem, na maholona ko hiolo. ");
INSERT INTO apb_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Oto e leesie ai fik i reune tala, na ko lae oto i saana. Ta'e maholo e lae wai hule aana, na ko leesie uri nga ta'a-ta'a hue-huei ei ha'ike aana, ta'e apa-apana mola hali'ite. Oto ko unue hunie ai ngeena uuri, “O sa'a roro'a ni hungu lo'u.” Na ai ngeena ko tolana nunulu oto molo aana maholona. ");
INSERT INTO apb_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Na maholo mo pwaarongoisuli kire leesie urine kire ko si pangata'i na kire ko unue uuri, “!Ha'ike eena! ?Ai ngeena e tolana nunulu oto mola lau-leu uri taa?” ");
INSERT INTO apb_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Oto a Jisas ko aalamire uuri, “No ko unue oto huni'omu uri mala omu ko hiiwalaimoli to'ohuu na omu ka'a ne'isae rue-rua'a, omu sai da mola nga taa mala nou esuie hunie ai ienini. Na ka'a ta'e ike leu ie, ta'e hule aana omu sai unue no'one mola hunie uuwo ie uuri, ‘O ke pola mola i eesi,’ na kei reu oto urine. ");
INSERT INTO apb_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Aana mala omu ko hiiwalaimoli to'ohuu aana a God, ta'e-ta'ena nga mei ola mala omu ko sukaa aani aarenga'inge, a God e sai niie mola huni'omu.” ");
INSERT INTO apb_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","A Jisas e aaliho'i lo'u mei i laona Nume Maa'i Peine, na maholo ko ha'a-uusuli, mo na'ohai pris na mo rato ni mwane kire lae mai saana. Oto kire ko dolosi aana uuri, “?Nga nanamanga uri taa ni o to'o aana huni esuie walu ola o ko deu'i ngeena? ?Na a tei ni e niie nanamanga ngeena huni'o?” ");
INSERT INTO apb_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Oto a Jisas e aalamire ko te'uri, “Ineu no'one no ko sare hola'i dolosie ta'a-ta'a mei dolosinge aamiu. Mala omu ko aalamieu, nge ne ke si unue oodoi'omu uri nga nanamanga uri taa nou to'o aana huni esuie walu ola ienini. ");
INSERT INTO apb_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Oto omu ke unue ka'u oodoieu. ?A tei ni e niie nanamanga hunie a Jon huni loto maa'i aana mwala? ?A God wa mo iinoni mola?” Oto kire ko aehota ere hailiu i matolada uuri, “?Oto nga taa kolu kei unue? Mala uri kolu kei unue a God ni e niie nanamanga ngeena hunie a Jon, nge kei unue hunikolu uuri, ‘?Nge ko urine, na e ue omu ka'a hiiwalaimoli aana?’ ");
INSERT INTO apb_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Ta'e mala kolu kei unue uri iinoni mola ni e niie nanamanga ngeena hunie, nge kolu kei lio talakaelu aana mwala. Aena aana ahutana mwala kire mani ne'isae oto uri a Jon ingeie nga propet to'ohuu.” ");
INSERT INTO apb_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Oto kire ko si aalamie mola a Jisas uuri, “Melu ka'a saie ike.” Oto a Jisas ko si te'uri hunire, “Ko urine, nge ineu na nou sa'a unue ike no'one oodoi'omu uri nga nanamanga uri taa no ko esuie mo ola ienini aana.” ");
INSERT INTO apb_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Oto a Jisas ko he'i unue lo'u hunire uuri, “Omu ke unue ka'u oodoieu uri nga taa ni omu lo'onga'inie. Aana nga mwane e o'o'o e to'o aana e ro mwela mwane kire hute aana. Oto a mwaena e lae i saana na'ohai mwane, ko te'uri hunie, ‘Kaleku, si'iri o ke lai esu i lalona hohola ineu.’ ");
INSERT INTO apb_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","“Oto a kalena e aalamie, ko te'uri, ‘Nou ka'a sare lae ike.’ Ta'e lae-lae e he'i oonisae lo'u, oto e si lae. ");
INSERT INTO apb_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","“A mwaena ko he'i lae lo'u i saana mwane i puri, na ko unue lo'u hunie uuri, ‘Kaleku, si'iri o ke lai esu i lalona hohola ineu.’ “Oto a kalena ko aalamie uuri, ‘Iau mama'a, ne kei lae taane.’ Ta'e e ka'a lae ike. ");
INSERT INTO apb_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","“?Oto nga taa ni omu lo'onga'inie? ?Iini uri taa aana e ro kele saanau ngeena nge e sulu i sulie saena aamana?” Mo pris na mo rato ni mwane kire ko aalamie uuri, “Iini i na'o.” Oto a Jisas ko unue hunire uuri, “!Iau! Oto no ko unue oto huni'omu uri mo iinoni ni ooraha'aa mala mo repi na mwala susulu to'oha, kire kei hola'i sili i laona aalahanga a God i na'omiu. ");
INSERT INTO apb_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Aana a Jon e lae mai huni haata'inie tolahai ii'onga diana aamiu, ta'e omu ka'a hiiwalaimoli ike aana. Mwala susulu to'oha na mo repi kire hiiwalaimoli aana Jon, ta'e ma'alana omu leesie kire oolisie tolahada urine, na omu ka'a sare oonisae ike lo'u wa omu ke hiiwalaimoli aana.” ");
INSERT INTO apb_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Oto a Jisas ko he'i ere ni aalahuunge lo'u hunie mwala uuri, “Omu ke rongoa lo'u mei wala ni aalahuunge ie. Ngaeta mwane e o'o'o oto ko hesie hohola aani grep. Oto e para ahuie, na e asuie leu huni loosie mo grep hunie kei ne'i waen, na e tohue saohai nume huni kakakali. Oto e ha'amangoa hahu'ana hohola ingeie ngeena urine, e si ha'ahaulaa aana ngaeta mo mwane hunie kire ke lio i sulie aana maholo ko lae i suli henue. ");
INSERT INTO apb_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Oto e hule aana maholo ni so'okoninge, poro paine ngeena ko uusunge'inie ta'au mo koni-konihe ingeie i saana mo mwane ko lio i sulie hohola ngeena, uri huni toolea mai nga taa kire kei niie hunie. ");
INSERT INTO apb_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","“Oto mwalana kire tapolie mola mo koni-konihe ngeena, na kire ko wini-winie ngaeta iini, na kire ko horo maesie oto ngaeta iini, na kire uu'i maesie oto ngaeta iini aani heu. ");
INSERT INTO apb_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Oto poro painena ko he'i uusunge'inie lo'u ta'au ngaeta mo koni-konihe hunge lo'u liutaa aana mo iini hola'ina'o. Na mwala ko lio i sulie hohola ngeena ko he'i te'urine lo'u mola aada. ");
INSERT INTO apb_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","“Oto ooretalana, poro painena ko lo'onga'i ni uusunge'inie oto a kalena na ko unue uuri, ‘Kaleku ha'alaa kire kei ha'ama'u aana.’ ");
INSERT INTO apb_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Ta'e maholo mwala au'esu ngeena kire leesie a kalena, kire ko si meni ere i sulie mola uuri, ‘Mwane nge kei to'o aana hohola ngeena oolisie aamana oto ie. Kolu ke horo maesie mola hunie kolu ke to'o aana oto hohola ienini.’ ");
INSERT INTO apb_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Oto kire tapolie a mwaena, kire ko toolea i sinaha mwaanie hohola, na kire ko horo maesie oto.” ");
INSERT INTO apb_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Oto a Jisas ko dolosi lo'u aana mo pris na mo rato ni mwane uuri, “?Ha'alaa nga taa nge poro paine haahie hohola ngeena kei esuie aana mwala ngeena?” ");
INSERT INTO apb_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Oto kire ko aalamie uuri, “Kei tohungei horo suuhe'inie oto mwala aaela ngeena, na kei ha'ahaulaa lo'u hohola ngeena aana mo iini nge kire sai niie aapa ingeie hunie aana maholo ni so'okoninge.” ");
INSERT INTO apb_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Oto a Jisas ko unue lo'u hunire uuri, “Omu saaie ka'u oto mo Uusu-uusu Maa'i e unue uuri, Hau mwala tou-tohu nume kire leledie ka'u, e si ne'ie tohungei heu susu aana nume. A God ni e asuie urine, na e lai lio manikulu'e i maaka mo iinoni. ?Ta'e e ue omu ka'a rongo saie? ");
INSERT INTO apb_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Aena ngeena no ko unue huni'omu uri, ta'aasilana aalahanga a God kei lae mwaani'omu, na niilana kei lae oto hunie mo iini ko deu i sulie mo ola a God e saeto'o aani. ");
INSERT INTO apb_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Nga iini nge kei domu i lengine hau ienini kei ma'oi oto, na mala uri kei teke haahie nga iini na kei pili memesoa oto.” ");
INSERT INTO apb_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Maholo mo na'ohai pris na mo Parise kire rongoa mo aalahuunge ngeena, kire saie mola uri a Jisas ko ere mola i hoorada. ");
INSERT INTO apb_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Oto kire ko sare tapolie oto, ta'e kire ko me'ute'inie mwala, aena aana mwalana kire hiiwalaimoli aana uri a Jisas ingeie nga propet oto to'ohuu. ");
INSERT INTO apb_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Oto a Jisas e he'i ere ni aalahuunge lo'u hunire uuri, ");
INSERT INTO apb_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Aalahanga a God e urihana ngaeta inemauri e dau aaharota i sulie a kalena. ");
INSERT INTO apb_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Oto inemauri ngeena ko ha'arongoa mai ngaeta mwala hunie ngauhe. Maholo e dau aakau mango oto aana ahutana mo ola hunie ngauhe, ko si uusunge'inie mo koni-konihe ingeie huni soie mwala ngeena ke lae mai. Ta'e mwalana ka'a sare lae ike mai. ");
INSERT INTO apb_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","“Oto ko he'i uusunge'inie lo'u ngaeta mo koni-konihe, ko te'uri hunire, ‘Unue hunie mo iini nge ha'arongolada e lae uri nou deu aakau oto aana walu ola hunie ngauhe. Nou hunu mangoa oto mo puluke diana ineu, na hule aana nou hunue oto no'one mo iini nou nii-nii eni hunie kire ke pwi'e diana huni ngeu'i.’ ");
INSERT INTO apb_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","“Ta'e mwalana ka'a sare rongo lo'u hunie mo koni-konihe ngeena, na kire lae mola i sulie saeda. Nga iini e lae mola i hohola ingeie, na ngaeta iini mola aana uusi'e. ");
INSERT INTO apb_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Oto ngaeta mo iini kire tapolie mola mo koni-konihe ngeena, kire ko repusire na kire ko horo maesire oto. ");
INSERT INTO apb_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Oto inemauri ngeena e tohungei saewasu, ko uusunge'inie mo ramo ingeie huni horo aasie mwala e talei horo ngeena, na oto huni uunu aasie huilume ikire aana dunge. ");
INSERT INTO apb_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","“Purine leune e rau, inemauri ngeena ko si unue hunie mwala au'esu ingeie uuri, ‘Ngauhe e dau aakau mango oto, ta'e mo iini nge ha'arongolada e lae, kire ka'a malisine oto laenga mai. ");
INSERT INTO apb_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Oto omu ke lae lo'u i lio aana mo maai tala rue, na ta'ena nga iini omu ko lio oodoie, ha'arongoa mai hunie ngauhe ineu.’ ");
INSERT INTO apb_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Oto mwala au'esu ngeena kire ko lae hailiu lo'u i sulie mo tala paine. Kire ko tarakonie mai ahutana mwala kire ko lio oodoire, mo iini e diana na nga mo iini e aaela, lai hule aana nume ni aaharota e saro honu aana mwala. ");
INSERT INTO apb_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Oto a inemauri e lai sili i nume huni leesie mwala e hule, na ko leesie ngaeta mwane e ka'a to'oni ike aana nga to'oni ni aaharota. ");
INSERT INTO apb_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Oto ko te'uri hunie, ‘?Malahuku, e ue o lae mola mai urine na o ka'a to'oni aana nga to'oni ni aaharota?’ Ta'e a mwaena e ka'a nguuhie ike. ");
INSERT INTO apb_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","“Oto inemauri ngeena ko unue hunie mwala au'esu ingeie uuri, ‘Omu ke pwasue e ro nimana na e ro ae'aena, oto omu ko aasie i laona rodohono po'oi sinaha, leu nge mwala kei ii'o ni ngaranga pe'i saehuunge oto hiito'o aana.’” ");
INSERT INTO apb_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Oto a Jisas ko si ha'amangoa aalahuunge ngeena uuri, “Iau, aana mwala hunge ha'arongolada e lae, ta'e toota'i iini mola lio hilisilada e si lae hunie Aalahanga a God.” ");
INSERT INTO apb_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Oto mo Parise kire iisitaa, kire ko si lai ere-ere i sulie uri kire kei pweloa a Jisas uri taa aani dolosinge. ");
INSERT INTO apb_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Oto kire ere tararuru pe'ie pulitaa a Herod Inemauri, na kire ko uusunge'inie ta'au mo pwaarongoisuli ikire i saana a Jisas pe'ie ngaeta mo mwane aana po'o ni mwane a Herod. Oto mo mwaena kire ko unue hunie a Jisas uuri, “Ha'a-uusuli, melu saie uri walaimolinge ni oto o ko unu-unuena, aana o ko ha'a-uusuli i sulie hari-huninge a God hunie mo iinoni. Oto o ka'a aapwasu ike aana nga taa mwala ko lo'o-lo'onga'inie, aena aana o ka'a lio ike hunie maana mo iinoni. ");
INSERT INTO apb_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Aena ngeena, o ke unue oodoi'emeelu nga taa o lo'onga'inie. ?Uri e adona taane huni niie takis hunie aalahanga ni Rom wa ha'ike?” ");
INSERT INTO apb_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Ta'e a Jisas e lio saie mone uri kire ko lupwe'i pwaoa mola, ko si te'uri hunire, “!I'omu kira dau hahota! ?Aana e ue ni omu ko sare lupwe'i pwaoau urine? ");
INSERT INTO apb_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Omu ke haata'inie ka'u seleni hunie takis ngeena aaku.” Oto kire ko haata'inie ngaeta seleni ni Rom aana. ");
INSERT INTO apb_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Oto a Jisas ko dolosi aada uuri, “?A tei ni nunune na satana aana seleni ienini?” ");
INSERT INTO apb_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Oto kire ko unue uuri, “Inemauri ni Rom ni ngeena.” Oto a Jisas ko te'uri hunire, “Ko urine, omu ke nii eeliho'i aana hunie inemauri ngeena mo ola ingeie, na hunie a God mo iini a God.” ");
INSERT INTO apb_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Oto kire ko si tohungei pangata'inie hahu'ana aalaminge ingeie, na kire ko lae oto mwaanie. ");
INSERT INTO apb_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Oto lo'u mola aana hai dingena, ngaeta mo Sadiusi kire lae mai saana a Jisas. Ikire mo Sadiusi ngeena kire hiiwalaimoli uri nga iini sa'a ta'ela'i ike lo'u mwaanie maenga. ");
INSERT INTO apb_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Oto kire ko te'uri hunie, “Ha'a-uusuli, a Mosis e uusue ha'atolanga ie hunikie. Mala uri nga mwane ko mae na e ka'a to'o kalena, nge aasine mwane ke to'o aana lo'u mola nao keni iihana, hunie ke ha'ahute mwela oolisie aasine nge e mae ngeena. ");
INSERT INTO apb_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Oto wau i na'o, e hiu mwaasine mwane kire mani hute na kire o'o'o i leu. A na'ohada e tola hu'e, oto e mae mola na e ka'a to'o mwela. Oto aasine mwane e to'o aana lo'u naona. ");
INSERT INTO apb_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Ruana nga mwane ngeena ko he'i mae lo'u urine. Oolune nga mwane ko he'i urine lo'u, na lae-lae ahutana hiu mwaasine ngeena kire mani mae mango oto urine. ");
INSERT INTO apb_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Oto a hu'ena e si mae ooreta. ");
INSERT INTO apb_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","?Ha'alaa, kei hule aana hai dinge ta'ela'inge, a hu'e ngeena kei ne'i hu'e a tei aana e hiu mwaasine ngeena, aana kire mani to'o-to'o aana mola urine?” ");
INSERT INTO apb_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Oto a Jisas ko aalamire uuri, “Ne'isaenga i'omu e tohungei takalo oto hiito'o, aena aana omu ka'a saie ike mo Uusu-uusu Maa'i wa nanamanga a God. ");
INSERT INTO apb_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Maholo mwala kei ta'ela'i mwaanie maenga, nga tola-hu'anga wa nga to'o-poronga ha'ike lo'u. Ta'e kire kei ii'o oto mola mala mo ensel ta'au i Lengi. ");
INSERT INTO apb_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","?Ta'e hatarie ta'ela'inge mwaanie maenga, aana e ue omu ka'a rongo saie nga taa a God e unue huni'omu aana mo Uusu-uusu Maa'i? ");
INSERT INTO apb_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Aana a God e unue uuri, Ineu oto God a Ebraham, na Aesak na Jekob ko palo-paloa. Kie mani saie uri mo iini e mauri mola ko palo-paloa a God, e ka'a ike mo iini e mae. Oto uusu-uusu ie ko haata'inie uri ma'alana Ebraham, na Aesak na Jekob kire mani mae oto, ta'e kire mauri mola ue ta'au i Lengi.” ");
INSERT INTO apb_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Oto ahutana mwala e rongo urine, kire ko si meni pangata'inie ha'a-uusulinge diana a Jisas. ");
INSERT INTO apb_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Maholo mo Parise kire rongoa uri mo Sadiusi ka'a sai aalamie oto a Jisas, kire si meni lae mai saana huni ha'atataroa. ");
INSERT INTO apb_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Oto ngaeta ha'a-uusuli aana mo Ha'atolanga a Mosis, e dolosi aana uuri, ");
INSERT INTO apb_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“?Ha'a-uusuli, iini uri taa ni na'ohai ha'atolanga aana mo Ha'atolanga a Mosis?” ");
INSERT INTO apb_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Oto a Jisas ko aalamie uuri, “Na'ohai ha'atolanga oto, O ke manata diana hunie a God, aalaha i'oe, oto aana ahutana saemu, na aana ahutana mauriha'amu, na aana ahutana mo ne'isaenga i'oe. ");
INSERT INTO apb_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Aana na'ohai ha'atolanga oto ie na e hi'e liutaa. ");
INSERT INTO apb_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Na ruana nga ha'atolanga e urihana lo'u eetana, O ke manata diana hunie auhenue i'oe oto mala o manata diana huni'o maraamu. ");
INSERT INTO apb_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Aana aahu'ine ahutana mo Ha'atolanga a Mosis na mo ha'a-uusulinge mo propet ni oto e ro ha'atolanga ienini.” ");
INSERT INTO apb_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Maholo mo Parise kire mani loko, a Jisas e si dolosi aada uuri, ");
INSERT INTO apb_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“?Nga taa ni lo'onga'inge i'omu aana a Kraes? ?Kalena a tei ni ingeie?” Oto mo Parise e aalamie uuri, “A Kraes kei hute mola mai aana komu a Deved Inemauri.” ");
INSERT INTO apb_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Oto a Jisas ko te'uri hunire, “E to'ohuu oto. ?Ta'e e ue ni a Deved e si haara'inie lo'u aana aalaha? Aena aana a Deved e ere aana nanamanga ni Li'oa Maa'i uuri, ");
INSERT INTO apb_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","A God e unue hunie aalaha ineu, uuri ‘O ke ii'o ka'u i pwalo-pwaloku aana na'ohai ii'o-ii'oha, lai hule aana ne kei kama haahie mo maelonga i'oe i aano hunie o ke uuri puli-pulisire.’” ");
INSERT INTO apb_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Oto a Jisas ko te'uri lo'u, “A Deved maraana ni e unue uri a Kraes e ne'i aalaha ingeie. ?Ta'e e ue? ?Mwane nge e hute mola aana komu a Deved maraana, kei he'i ne'i aalaha ingeie lo'u uri taa eena?” ");
INSERT INTO apb_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Nga iini aana mo Parise hunie ke aalamie mo dolosinge a Jisas na ha'ike lo'u. Na uure i purine hai dingena, nga ta'a-ta'a iini hunie ke sare dolosie lo'u nga mei ola aana, ha'ike oto oo'oo. ");
INSERT INTO apb_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Oto a Jisas ko si unue hunie mwala na mo pwaarongoisuli ingeie uuri, ");
INSERT INTO apb_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Mo Parise na mo ha'a-uusuli aana mo Ha'atolanga, kire to'o aana nanamanga huni unue nga taa huni'omu aana mo Ha'atolanga a Mosis. ");
INSERT INTO apb_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Aena ngeena omu ke rongo hunire na omu ke dau i sulie nga taa kire ko unue huni'omu. Ta'e mwaanie omu lae-lae i sulie tolahada, aana tolahada e ka'a diana ike. Mo ha'a-uusulinge ikire, ikire maraada, na kire sa'a dau ike i suli'i no'one. ");
INSERT INTO apb_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Kire ko da ludaa e hi'e aana mo ha'atolanga hunie mwala. Ta'e hule aana ikire maraada na kire sa'a nii ki'i huni pe'ie mwala huni sulu'ie ludaa ngeena. ");
INSERT INTO apb_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","“Ahutana nga moi taa kire ko eu'esui'i, mo ola mola uri hunie mwala ke lee-leesire. E to'ohuu, a God e unue taane uri kie ke ho'o-ho'osie mo to'oni lauleuni'e na ngaeta mo ola lo'u huni aama-aamasito'o aana mo ha'atolanga ingeie. !Ta'e lio ka'u! Ikire, kire ko esu peine lo'u aana mo olana, hunie uri mwala ko leesi'i na kire ke unue uuri, ‘Ikire ni oto mwala maa'i.’ ");
INSERT INTO apb_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Mo Parise ngeena na mo ha'a-uusuli aana mo Ha'atolanga, saeda no'one uri kire ke to'o aana mo pweui tolinge aana ngauhe, na mo na'ohai ii'o-ii'oha aana mo nume ni palo-palo. ");
INSERT INTO apb_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Saeda no'one uri mwala ke ha'ama'u aada maholo kire ko walo liu i laona mo leu ni uusi'e, na saeda no'one uri mwala ke haara'inire aana, ‘Ha'a-uusuli.’” ");
INSERT INTO apb_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Ta'e i'omu, omu ke su'uri toli'aasie mwala ke haara'ini'omu aana, ‘Ha'a-uusuli,’ aena aana omu to'o aana mola e ta'a-ta'a ha'a-uusuli, na i'omu mo mwaasine hali'ite. ");
INSERT INTO apb_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Na mwaanie omu haara'inie nga iini mei aano uuri, ‘Mama'a,’ aana e ta'a-ta'a iini oto Aamamiu, ingeie ta'au i Lengi. ");
INSERT INTO apb_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Na mwaanie mwala e haara'ini'omu uri, ‘Aalaha,’ aena aana ineu a Kraes oto ta'a-ta'a aalaha i'omu. ");
INSERT INTO apb_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Na nga iini hikemiu nge ko sare aalaha, ke ne'i iinoni au'esu oto namiu. ");
INSERT INTO apb_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Aana ta'ena nga iini ko ha'apaina'aa maraana, nge a God kei ha'amwai-mwei'aa. Na ta'ena nga iini ko ha'amwai-mwei'aa maraana, nge a God kei ha'apaina'aa.” ");
INSERT INTO apb_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Oto a Jisas ko he'i unue lo'u uuri, “Aama-aamasilemiu mo Parise na mo ha'a-uusuli aana mo Ha'atolanga a Mosis. !I'omu oto mwala eero-eero! Aana omu ko lupwe'i deu-deu mola mala uri omu ko lulu i sulie a God. !Ta'e ha'ike! I'omu maraamiu omu ka'a sare sili ike i laona Aalahanga a God, na omu ka'a toli'aasie ike nga mo iini ke sili lo'u. ");
INSERT INTO apb_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","“Aama-aamasilemiu mo Parise na mo ha'a-uusuli aana mo Ha'atolanga. !I'omu oto mwala eero-eero! Aana omu ko lupwe'i deu mala uri i'omu oto mwala maa'i aani unulana mo aarenga'inge tewa i maana mwala. Ta'e hule aana omu ko ha'a-ha'amwe'u-mwe'ue mola mo nao keni, na omu ko leue mola mo nume ikire pe'ie ahutana to'o-to'olada. Aena urine, ha'aloilemiu kei peine liutaa. ");
INSERT INTO apb_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Aama-aamasilemiu mo Parise na mo ha'a-uusuli aana mo Ha'atolanga. !I'omu oto mwala eero-eero! Omu ko ha'aweo'omu maraamiu aani lo'ohinge i sulie mo mala-malau hunie nga mo iini ke lae i suli'omu. Oto maholo omu ko lio oodoie nga mo iini, omu ko si da oto kire ke aaela oto hiito'o lo'u liutaa aamiu hunie ikire no'one kire ke adona laenga i laona dunge ni ha'amotaahinge mala i'omu. ");
INSERT INTO apb_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Aama-aamasilemiu aana omu ko na'ona mwala, ta'e i'omu maraamiu maamiu e ulu. Aana omu ko ha'a-uusulie mwala uuri, ‘Nga iini ko tohe mola takoie Nume Maa'i Peine e ka'a roro'a ike, ta'e uri kei tohe takoie mo kol aana Nume Maa'i Peine, ha'alaa ke si roro'aie.’ ");
INSERT INTO apb_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","!I'omu kira pweu na kira ulu! ?Uri omu ka'a saie ike uri Nume Maa'i e roro'a oto liutaa aana kol? Aena aana Nume Maa'i mone ko si da kol ngeena ko maa'i. ");
INSERT INTO apb_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Na omu ko unue hunie mwala uuri, ‘Mala nga iini ko tohe mola takoie ora ni uunu-uunu aana ko heiholota'i, e ka'a roro'a ike, ta'e uri nga iini ko tohe takoie uuraa'inge i lengine ora ni uunu-uunu ha'alaa ko roro'aie.’ ");
INSERT INTO apb_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","!I'omu mo ulu! ?Uri omu ka'a saie ike uri ora ni uunu-uunu e roro'a oto liutaa aana uuraa'inge? Aena aana ora ni uunu-uunu mone ko si da uuraa'inge ngeena ko maa'i. ");
INSERT INTO apb_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Oto aana maholo nga iini ko tohe takoie ora ni uunu-uunu, e urihana ko tohe takoie ora ni uunu-uunu na oto ahutana mo uuraa'inge i lengine ni ngeena. ");
INSERT INTO apb_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Na maholo nga iini ko tohe takoie Nume Maa'i Peine, e urihana ko tohe takoie oto Nume Maa'i Peine na no'one takoie a God, iini nge ko o'o'o i leune. ");
INSERT INTO apb_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Na maholo nga iini ko tohe takoie i Lengi, nge ko tohe oto takoie naunekume ni aalaha a God, na ko tohe no'one takoie God nge e ii'o i lengine. ");
INSERT INTO apb_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Aama-aamasilemiu mo Parise na mo ha'a-uusuli aana mo Ha'atolanga. !I'omu oto mwala eero-eero! Omu ko niie taane tangahulu'ana tari-olanga i'omu hunie a God, na lai hule oto aana to'o-olanga i'omu aani sihola. Ta'e hule aana omu ka'a aapwasu ike aana tohungana ha'a-uusulinge aana mo Ha'atolanga, mala leinge to'ohuu, na aamasinge, na hiiwalaimolinge. Mo na'ohai ola uri hunie omu ke dau i suli'i ka'u ienini. Na lo'u mwaanie omu pulongosie mo ha'a-uusulinge mwai-mwei mala niilana tangahulu'ana tari-olanga i'omu. ");
INSERT INTO apb_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","I'omu, omu ko kakalie taane mwala mwaanie kire waelie mo Ha'atolanga, ta'e hule aana maamiu e ulu no'one mola. Omu urihana mola iinoni e ta'aasie kele ho nonoasi mwaanie wai ni inu ingeie, ta'e e si oono ha'ilekune mola paineha'ana kamel. ");
INSERT INTO apb_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Aama-aamasilemiu mo Parise na mo ha'a-uusuli aana mo Ha'atolanga. !I'omu oto mwala eero-eero! Aana omu urihana mola mo nime na mo kao-kao kire hoda rere'a aana aapa po'oi sinaha, ta'e wau i laona e honu mola aana ngaulaa e kasu. Omu ko sasare lio kohi i maana mwala, ta'e hule aana saemiu e honu oto mola aana horo-pelinge na ta'ena nga lo'onga'inge aaela. ");
INSERT INTO apb_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","!I'omu mo Parise oto mwala maamiu e tohungei ulu! Omu ke hola'i hoda rere'a ka'u aana aapa po'o i laona nime, nge aapa po'oi sinaha kei rere'a no'one. ");
INSERT INTO apb_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Aama-aamasilemiu mo Parise na mo ha'a-uusuli aana mo Ha'atolanga. !I'omu oto mwala eero-eero! Omu urihana mola mo kilipwe'u kire mole rere'a aani. Leesileni po'oi sinaha kire tohungei lai lio diana, ta'e wai laloni, kire honu mola aani suisuli hali'ite na kasuha'ana mo rae. ");
INSERT INTO apb_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","I'omu, omu urine no'one. Aana leesilemiu po'oi sinaha uri i'omu ni oto mo iinoni diana, ta'e wai lalo aamiu, e honu oto mola aana lupwe'i-deunge na ooraha'aa. ");
INSERT INTO apb_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Aama-aamasilemiu mo Parise na mo ha'a-uusuli aana mo Ha'atolanga. !I'omu oto mwala eero-eero! Omu ko esu diana aana mo kilipwe'u mo propet, na omu ko ha'alaunie mo kilipwe'u mo iini e oodota'i hunie kire ke lio diana. ");
INSERT INTO apb_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Na omu ko unue uuri, ‘!Saehuu oto hiito'o! Mala emi ke ii'o aana pongine mo aamamami, ha'alaa emi sa'a dau ike mala ikire huni horo'ie mo propet.’ ");
INSERT INTO apb_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Ta'e omu ko ere urine nge omu tohungei haata'i diana aana oto uri i'omu, omu uure oto mwaanie mwala nge kire horo'ie mo propet ni ngeena. ");
INSERT INTO apb_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Nge ko urine oto, omu ke lae tara'asi mola huni ha'amangoa oto mei roro'anga mo aamamiu e aehotaa ka'u. ");
INSERT INTO apb_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","!I'omu oto mo mwaa to'ohuu! !Komu ni mwaa ala-ala! ?Uri omu kei tehisie ha'aletehinge a God uri taa eena? Leilemiu kei lae, na uusunge'inilemiu kei lae mola hunie leu ni ha'amotaahinge. ");
INSERT INTO apb_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Oto no ko unue huni'omu uri, ne kei uusunge'inie huni'omu nga mo propet, na mwala saenanau, na nga mo ha'a-uusuli. Ta'e omu kei horo maesie ngaeta mo iini aada, nga mo iini omu kei repu taalengasire i lengine mo po'u-po'u, na nga mo iini omu kei repu lae-lae'i aada i laona mo nume ni palo-palo i'omu, na omu kei teunge'inire hailiu i suli henue. ");
INSERT INTO apb_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Oto i'omu, omu kei roro'a aana maelana ahutana mwala oodota'i nge horo maesilada e lae mai aano. Omu kei aehota roro'a aana horo'ilana ahutana mo mwane oodota'i, uure aana a Ebol lai hule aana horo'ilana a Sekaraea, mwane kalena Barakaea nge omu horo maesie kara'inie ora ni uunu-uunu aana Nume Maa'i Peine. ");
INSERT INTO apb_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","No ko unue oto huni'omu pwaunge si'iri ie, nge leinge haahie horo'ilana mwala oodota'i ngeena ke si lae huni'omu.” ");
INSERT INTO apb_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Oto a Jisas ko he'i ere uuri lo'u, “!Aaia Jerusalem, Jerusalem! I'omu oto omu ko horo suuhe'inie mo propet na omu ko uu'i maesie mo iini a God e uusunge'inire mai huni'omu. Mo maholo hunge nou sasare pe'i'omu mala pwa-pwa ni kue ko lokoa mo kalena i hahana apa-apana huni ha'a-uurire. Ta'e omu ka'a saeto'o aaku ike. ");
INSERT INTO apb_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Oto omu ke saie, a God kei toli'aasie hanue i'omu, na kei na'onga oto. ");
INSERT INTO apb_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Na no ko unue oto huni'omu uri omu sa'a he'i leesieu lo'u lai hule aana omu kei ere i sulieu uuri, God o ke ha'adiana'aa iini ko lae mai nunuha'ana satana Aalaha.” ");
INSERT INTO apb_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","A Jisas ko lae oto mwaanie Nume Maa'i Peine na mo pwaarongoisuli ingeie ko lae oto mai saana, kire ko ere pe'ie i sulie manikuluha'ana mo heri-herine Nume Maa'i Peine ngeena. ");
INSERT INTO apb_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Oto ko aalamire uuri, “?Omu leesie mo heri-herine nume ngeena? Ta'e no ko unue oto huni'omu uri aana nga maholo oho-aasileni kei saro lae, na nga ta'a-ta'a ho heu e sa'a oore ike lo'u aana leu e o'o'o aana.” ");
INSERT INTO apb_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Na maholo a Jisas e ii'o i aano i lengine Uuwo Ni Ei Olif, mo pwaarongoisuli kire lae mai saana, oto kire ko dolosi aana uuri, “?O ke unue oodoi'emeelu uri maholo uri taa ni walu ola ienini kei oa, na nga taa ni kei reu huni haata'inie uri e hule oto aana maholo o kei ooli lo'u mei, na ha'amangolana walumalau?” ");
INSERT INTO apb_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Oto a Jisas ko aalamire uuri, “Omu ke lio talamiu mwaanie nga iini e eero'omu. ");
INSERT INTO apb_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Aana mo iini hunge kei lae mai aana sataku, na kire kei ere uuri, ‘Ineu oto a Kraes,’ na kire kei ha'apweue mwala hunge. ");
INSERT INTO apb_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Na omu kei rongoa mo oohotaa aana ta'ena nga leu aana walumalau, ta'e mwaanie saemiu e liki-liki. Aena aana walu ola ngeena kire kei hola'i reu i na'o, ta'e ha'amangolana walumalau ha'ike ue ni ngeena. ");
INSERT INTO apb_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Haiseuninge kei lae i matolana mo henue hai aaopa'i, na i matolana mo aalahanga hailiu. Hiolonga kei toolea mo iini hunge i laona walumalau, na nunu kei tola ahusie mo henue hunge. ");
INSERT INTO apb_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Ta'e walu ola ienini ko haata'inie mola uri mo ola paine kei lae ue mai mala hu'e ko aehota hiinge'inie sapesalunge hunie to'o-mwelanga. ");
INSERT INTO apb_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Aana maholona mo maelonga i'omu kire kei tapoli'omu, na kire kei ha'aloi'omu, na kire kei horo maesi'omu. Ahutana mo iinoni kei maaleledi'omu aena aana omu ko lulu i sulieu. ");
INSERT INTO apb_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Mo iini hunge aana mo iini nge ko lulu i sulieu kei toli'aasie hiiwalaimolinge ikire aana maholona, hule aana kire kei pwelora hailiu mola maraada, na kire kei maaleledire maraada hailiu. ");
INSERT INTO apb_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Mo propet eero-eero hunge kei lae mai, na kire kei deu uri hunie mwala hunge ke hiiwalaimoli aana mo eeronga ikire. ");
INSERT INTO apb_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Mwala urine nge kire kei da aaelanga ke si peine i laona walumalau, na mwala hunge sa'a manata diana oto hunie nga iini. ");
INSERT INTO apb_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Ta'e iini nge kei uure a'aila'a tara'asi aani hiiwalaimolinge lai hule aana ha'amangolana, nge a God ke si ha'a-uurie. ");
INSERT INTO apb_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Laeliwalanga aana Tataroha Diana i sulie Aalahanga a God kei lae kalie ahutana walumalau hunie ahutana iinoni ke mani rongo. Oto puriha'ana ha'amangolana ke si lae mai.” ");
INSERT INTO apb_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Oto a Jisas e he'i unue lo'u uuri, “Omu kei leesie taane mei ola aaela liutaa nge ko esuie na'onga hunie mo henue nge a Propet Daniel e ere i sulie. Mei olana kei uure i laona leu maa'i. (Mo iini ko saaie mo wala ienini, kire ke lo'onga'i diana i suli'i hunie kire ke rongo saie nga mei ola uri taa ni ngeena.) ");
INSERT INTO apb_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Aana maholona mwala aana po'o ni henue i Jiudia kire ke tohungei tehi oto huni mumuni honosie mo toloi henue. ");
INSERT INTO apb_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Na mala nga iini e ii'o ta'i koluhana nume ingeie, nge ke tahi oto na ke su'uri waelie lo'u nga maholo huni lai toolea nga mo ola ingeie hai nume. ");
INSERT INTO apb_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Na mala nga iini ko eu'esu i hohola, ke tahi oto na ke su'uri waelie lo'u nga maholo huni lai toolea nga mo to'oni ingeie mai nume. ");
INSERT INTO apb_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Na aama-aamasilana mo hu'e ko hi'e-hi'e aani mwela, na mo iini nge kire ko ha'a-ha'asusuhie ue mo wee-wee ikire. ");
INSERT INTO apb_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Ta'e omu ke aarenga'i mola hunie walu ola ngeena ke su'uri hule aamiu aana maholo e aasa aana mo waro-waro ni wawai, wa aana Dinge Maa'i. ");
INSERT INTO apb_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Aana si'oha'anga kei tola aana maholona, kei peine liutaa aana lo'u ta'ena nga ola ko totola uure oto mai aehotalana walumalau hule mai aana mo dingena. Na e sa'a he'i aaela lo'u urine aana nga dinge. ");
INSERT INTO apb_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Mala uri a God ka'a holo o'oru'e aana maholo ni si'oha'anga ngeena, nge nga iini sa'a mauri ike lo'u. Ta'e i sulie a God e lo'onga'inie mo iini nge e lio hilisire oto, nge mone kei holo o'oru'e aana maholona.” ");
INSERT INTO apb_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Oto aana maholona mala uri nga iini ko unue huni'omu, ‘!Lio ka'u! A Kraes oto ie,’ wa ‘!Lio ka'u! Ingeie oto waune,’ ta'e omu ke su'uri hiiwalaimoli aana. ");
INSERT INTO apb_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Aena aana mo kraes eero-eero na mo propet eero-eero hunge kire kei lae mai. Na mala ko mwada'u, kire kei ha'atakaloa mo iini nge a God e lio hilisire oto. Kire kei haata'inie mo tolimaa na mo hu'i-hu'ite aana mwala, ta'e mwaanie omu hiiwalaimoli aada. ");
INSERT INTO apb_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Aena urine, nge no ko hola'i ha'apasuli'omu oto aana walu olana, hunie omu ke lio diana talamiu. ");
INSERT INTO apb_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Oto mala mwala ko unue huni'omu uuri, ‘A Kraes ta'au i laona hanuesala,’ su'uri lae ta'au i leune. Mala kire ko unue uuri, ‘A Kraes mai laona nume ie,’ su'uri hiiwalaimoli aada. ");
INSERT INTO apb_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Aana maholo ineu a Kale Ni Iinoni ne kei lae mai, e sa'a lio kolo-kolo ike. Ahutana iinoni kei meni leesieu mola. Ne kei lae mai mala wa'ariri ko eeso i laona salo, nge leesilana e sai lae mola ahusie ahutana mo henue. ");
INSERT INTO apb_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Na oolinge mai ineu e sa'a mumuni ike ta'e kei urihana no'one waieu tola manu. Aana mwala kei leesie mo keule, kire kei meni saie oto uri waieu oto i leune.” ");
INSERT INTO apb_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Oto a Jisas ko he'i unue lo'u uuri, “Oto lo'u mola i purine mo dinge ni si'oha'anga ngeena, sato kei ulue oto maana, na e sa'a pwaa lo'u. Waro-waro e sa'a he'i sineli lo'u. Na mo hee'u ta'au i laona salo kei teke i aano, na ahutana mo ola ta'au i laona salo kei hei-oolisi mango. ");
INSERT INTO apb_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Oto aana maholo urine nga tolimaa leesilana kei lae i laona salo huni haata'inie uri ineu a Kale Ni Iinoni no ko lae oto mai. Ahutana mo komu ni iinoni aana walumalau kei ngara aana kire kei leesieu a Kale Ni Iinoni no ko lae mai i laona mei uuru mwaanie salo. Ne kei lae mai pe'ie nanamanga na manikulu'anga oto paine. ");
INSERT INTO apb_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Oto ne kei uusunge'inie mai mo ensel ineu pe'ie aawatai eehuri oto paine, na kire kei lae pe'i so'okonie mo iini nou lio hilisire mwaanie e hai maai dengi aana walumalau, uure aana ngaeta ngongo'ai welumalau lai hule aana ngaeta ngongo'ai welumalau.” ");
INSERT INTO apb_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Oto a Jisas ko he'i te'uri lo'u, “Saeku omu ke rongo saie erenga ni aalahuunge ie i sulie ai fik. Maholo mo sasarana ko aehota ure na ure-urana ko maau, nge omu saie oto uri maholo hunie mo waro-waro ni madoro e kara'ini oto mai eena. ");
INSERT INTO apb_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Na e urine no'one aana maholo omu kei leesie walu ola ienini ko reu uurini, omu ke si manata'inie uri e kara'inie oto maholo no ko ere i sulie ni ngeena. ");
INSERT INTO apb_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","No ko unue oto huni'omu uri walu ola ienini kei saro oa mango mola ue oodoie mwala aana pwaunge si'iri ie na kire ka'a mae ue. ");
INSERT INTO apb_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","I Lengi na i aano kei suu, ta'e walaku e sa'a suu ike oto oo'oo.” ");
INSERT INTO apb_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Oto a Jisas ko he'i ere lo'u uuri, “Nga ta'a-ta'a iini e ka'a saie ike hai dinge wa maholoi sato uri taa ne kei ooli lo'u mei. Ma'alana mo ensel ta'au i Lengi, wa uri ineu a Kale, na melu ka'a saie ike. Ta'e a Mama'a ta'au i Lengi hali'ite nge e saie maholona. ");
INSERT INTO apb_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Na nga taa kei reu aana maholo ineu a Kale Ni Iinoni ne kei ooli mei, kei urihana no'one nga taa e rau aana pongine a Noa. ");
INSERT INTO apb_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Mo dinge i na'ona lue-lue e tola, mwala ka'a saie ike, oto kire ngau-ngeu na kire inu-inu mola. Kire totola keni na kire to'o-to'o poro mola lai hule aana hai dinge a Noa e ta'e i laona haka paine. ");
INSERT INTO apb_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Kire ka'a lo'o-lo'onga'inie ike lo'u uri nga mei ola kei hite aada, oto kire au'esuie walu olana lae hule aana lue-lue e hane haahire, na kire mani ei'aa mango oto. Kei urine no'one lo'u aana maholo ineu a Kale Ni Iinoni ne kei ooli mei. ");
INSERT INTO apb_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Aana maholona nga ro iinoni kei eu'esu i laona hohola, na nga iini a God kei toolea, na ngaeta iini kei oore mola. ");
INSERT INTO apb_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Na lo'u, nga ro keni kei meni ha'a-ha'alie ngaulaa, nga iini a God kei toolea, na ngaeta iini kei oore no'one mola i puri. ");
INSERT INTO apb_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“Aena urinena, omu ke ii'o aakau mola, aana omu ka'a saie ike hai dinge uri taa aalaha i'omu kei ooli mei. ");
INSERT INTO apb_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Na omu ke aamasito'o aana uri mala iinoni e to'o aana nume ke saie uri iinoni peli-peli kei lae mai huni peli, ha'alaa e sa'a ma'ahu ike. Ta'e kei lio-lio mola huni uure honosie iinoni peli-peli ngeena mwaanie e sili i nume. ");
INSERT INTO apb_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Oto i'omu no'one, omu ke ii'o aakau, aana ineu a Kale Ni Iinoni ne kei ooli mei aana maholoi sato nge omu ka'a lo'onga'i ike huni maa'oohieu.” ");
INSERT INTO apb_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Oto a Jisas ko he'i unue lo'u uuri, “?Aana a tei ka'u e saenanau na e ne'i koni-konihe diana? Ingeie oto iini nge aalaha ingeie e ne'ie hunie ke lio i sulie ngaeta mwala au'esu aana maholo ko lae, na hunie ke nii-niie waaitada hunire i suli maholo. ");
INSERT INTO apb_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Na kei tohungei diana oto liutaa hunie koni-konihe ngeena, mala uri aalaha ingeie kei lio oodoie ko esu diana urine maholo kei ooli mei. ");
INSERT INTO apb_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Mala ko urine, nge no ko unue oto huni'omu uri aalaha ngeena ke si ne'ie oto koni-konihe ngeena hunie ke lio i sulie oto ahutana to'o-to'olana. ");
INSERT INTO apb_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Ta'e mala uri koni-konihe ngeena e aaela na ko lo'onga'inie mola uri aalaha ingeie e sa'a hule ike lau-leu, ");
INSERT INTO apb_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","oto ko talei seu-seunie mola ngaeta mwala au'esu, na ko talei tara mola aana ngaunge, na ko pweu mola aana inuhilana wai ni mehiri, ");
INSERT INTO apb_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","oto aalaha ingeie kei hule mola, na e ka'a dau aakau ike. Na ko hule no'one mola aana maholo koni-konihe ngeena e ka'a lo'onga'inie huni maa'oohie. ");
INSERT INTO apb_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Oto aalaha ngeena kei tohungei ha'aloi letehie koni-konihe ingeie ngeena, na kei uusunge'i aasie oto pe'ie mwala ko lupwe'i deu-deu. I leune kire kei ii'o mola pe'ie ngaranga na saehuunge paine.” ");
INSERT INTO apb_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Oto a Jisas ko he'i unue lo'u uuri, “Aana maholona aalahanga a God kei urihana aawalai keni haalu nge kire lae huni maa'oohie poro haalu aana ko lae mai hunie aaharota ingeie. Kire toolea mo laite ikire pe'ire. ");
INSERT INTO apb_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","E lime iini aada e pweu, na e lime iini e manata. ");
INSERT INTO apb_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","E lime iini e pweu kire toolea mola mo laite ikire, ta'e kire ka'a tola rumu ike hiito'o pe'i'i. ");
INSERT INTO apb_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","E lime iini e manata kire toolea mo laite ikire na mo rumu hiito'o no'one pe'i'i laloi ate'a. ");
INSERT INTO apb_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","A poro haalu e ka'a hule lau-leu, oto ahutana mo keni kire ko meni mamauru'e, kire ko lae otoi ma'ahu. ");
INSERT INTO apb_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Oto i upui rodo, ngaeta iinoni e aawara na ko unue uuri, ‘A poro haalu ko lae oto mai. Omu ke lae mai honosie.’ ");
INSERT INTO apb_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","“Oto ahutana mo keni kire ko meni lio oto, na kire ko deu aakau oto aana mo laite ikire. ");
INSERT INTO apb_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Mo iini e pweu ko unue hunie mo iini e manata uuri, ‘Omu ke nii rumu nameelu, aana mo laite i'emeelu ko mwa'a oto.’ ");
INSERT INTO apb_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","“Mo iini e manata ko aalamire uuri, ‘Ha'ike, e lio mala uri e sa'a adongakaelu ike. Omu ke lae mola i saana mo iini ko ha'aholi rumu, na omu ke holi mola namiu.’ ");
INSERT INTO apb_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","“Oto maholo e lime keni e pweu ngeena kire ko lai lo'ohi rumu nada, na a poro haalu ko hule oto. E lime keni nge kire dau aakau, kire ko sili oto i nume pe'ie poro haalu hunie aaharota. Maholo kire sili i nume, na maa ko hono oto. ");
INSERT INTO apb_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“E ka'a tewa ike lo'u mola i purine, na e lime keni nge kire lai lo'o-lo'ohi rumu, kire ko hule oto. Kire lae mai oto kire ko si soi-soi uuri, ‘Poro paine, poro paine, o ke taha maa talameelu.’ ");
INSERT INTO apb_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","“Oto poro haalu ngeena ko si aalamire mola uuri, ‘No ko unue oto huni'omu uri nou ka'a manata'ini'omu ike.’” ");
INSERT INTO apb_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Oto a Jisas ko si ha'amangoa aalahuunge ngeena uuri, “Omu ke dau aakau taraure'i suli maholo, aana omu ka'a saie ike hai dinge wa maholoi sato ineu a Kale Ni Iinoni ne kei ooli lo'u mei.” ");
INSERT INTO apb_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Oto a Jisas ko he'i unue lo'u uuri, “Aana maholona Aalahanga a God kei urihana nga mwane paine e taule'i huni lae aana ngaeta hanue. I na'ona kei lae, a mwaena e saro ere-ere pe'ie mwala au'esu ingeie. Oto ko unue hunire uri kire ke lio i suli diana aana mo ola ingeie maholo ko lae. ");
INSERT INTO apb_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Oto ko niie hunie ngaeta mwane au'esu e lime mwa'ii to'oha. Na ngaeta mwane au'esu ko niie e ro mwa'ii to'oha hunie. Na oolune nga mwane au'esu ko niie ta'a-ta'a mwa'ii to'oha hunie. E ha'a-adoa mo mwane au'esu ngeena aani mwa'ii to'oha urine i sulie e nite nga iini e sai lio i suli'i i sulie saenanaunge ingeie. Oto a porona e si taule'i, e lae. ");
INSERT INTO apb_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Mwane au'esu nge e hele aana e lime mwa'ii to'oha, e lae oto ko lai deu esunge aana mo to'oha ngeena, na ko terie lo'u ngaeta lime mwa'ii to'oha lo'u haahie. ");
INSERT INTO apb_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Iini e hele aana e ro mwa'ii to'oha, na e urine lo'u. E lai deu esunge no'one, oto ko terie lo'u ngaeta ro mwa'i lo'u haahie e ro iini e hele aani. ");
INSERT INTO apb_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Ta'e iini nge e hele aana e ta'a-ta'a mwa'ii to'oha, e taule'i, oto ko elie mola kalinge, na ko mumunie mola mo to'oha aalaha ingeie i laona mwakano. ");
INSERT INTO apb_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“E haro tewa oto ni nge aalaha mo mwane au'esu ngeena e si eeliho'i mei. Oto ko dolosi aana mo mwane au'esu ingeie uri nga taa kire da aana mo to'oha ingeie. ");
INSERT INTO apb_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Oto mwane au'esu nge e hele aana e lime mwa'ii to'oha, ko toolea mai e lime mwa'ii to'oha lo'u pe'ie lime iini aalaha ingeie e nii'i hunie, na ko te'uri, ‘Aalaha ineu, o noruto'o aaku huni lio i sulie e lime mwa'ii to'oha i'oe. Oto nou deu esunge aani, na nou terie lo'u ngaeta lime mwa'ii to'oha pe'i'i.’ ");
INSERT INTO apb_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","“Oto aalaha ingeie ko aalamie uuri, ‘O tohungei deu diana, na i'oe oto mwane au'esu diana, iini ni nou-norue. O lio i suli diana aana mo ola ka'a hunge, oto ne kei ne'i'o o ke lio i sulie lo'u mo ola hunge. Lae mai na o ke ilenimwa'e pe'ieu.’ ");
INSERT INTO apb_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Mwane au'esu nge e hele aana e ro mwa'ii to'oha, e lae mai oto ko te'uri, ‘Aalaha ineu, e ro mwa'ii to'oha mola o nii'i hunieu. Ta'e ie o ke leesie ka'u, ngaeta ro mwa'ii to'oha lo'u nou teri'i pe'i'i.’ ");
INSERT INTO apb_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","“Oto aalaha ingeie ko aalamie uuri, ‘O tohungei deu diana, na i'oe oto mwane au'esu diana, iini ni nou-norue. O lio i suli diana aana mo ola ka'a hunge, ne kei ne'i'o o ke lio i sulie lo'u mo ola hunge. Lae mai na o ke ilenimwa'e pe'ieu.’ ");
INSERT INTO apb_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Oto mwane au'esu nge e hele aana ta'a-ta'a mwa'ii to'oha, e lae lo'u mei ko te'uri, ‘Aalaha ineu, nou saie uri i'oe mwane o tohungei raramaa oto hiito'o. O sai so'okonie mo ola o ka'a hasi'i ike. ");
INSERT INTO apb_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Oto nou me'u, nou lae mola i mumunie mei to'oha i'oe i laona mwakano. Leesie ka'u, mei to'oha i'oe mola ie.’ ");
INSERT INTO apb_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“Oto aalaha ingeie e aalamie ko te'uri, ‘I'oe oto mwane au'esu aaela na o tohungei lalawa'a. O unue uri nou sai so'okonie mo ola nou ka'a hasi'i. ");
INSERT INTO apb_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","?Nge ko urine, na e ue o ka'a ne'ie mola mei to'oha ineu i laona nume ni to'oha hunie ne ke tarie nga kele leu lo'u pe'ie?’ ");
INSERT INTO apb_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","“Oto aalaha ngeena ko si unue hunie ngaeta mo mwane au'esu ingeie uuri, ‘Omu ke toolea mo to'oha ngeena mwaanie, na omu ke nii'i hunie iini nge aawalai mwe'ii to'oha oto aana. ");
INSERT INTO apb_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Aana nga iini nge ko esu diana aana nga taa e to'o aana oto, aalaha ingeie kei niie nga mo iini lo'u hunie sapeiteni. Oto iinoni ngeena ke si to'o aana lo'u mo ola hunge liutaa aana nga taa e to'o aana ka'u. Ta'e nga iini nge e ka'a asu diana aana nga taa e to'o aana oto, nge aalaha ingeie kei ta'aasie ahutana mo ola mwaanie. ");
INSERT INTO apb_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Oto aana ko urine, omu ke aasie mwane au'esu aaela ngeena ta'i sinaha i laona rodohono, leu ngaranga na saehuunge e paine aana.’” ");
INSERT INTO apb_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Oto a Jisas ko he'i unue lo'u uuri, “Ineu, a Kale Ni Iinoni, ne kei ooli lo'u mei pe'ie manikuluha'aku na ahutana mo ensel ineu no'one pe'ieu, na ne kei ii'o i lengine naunekume ineu e manikulu'e. ");
INSERT INTO apb_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Ahutana iinoni ni welumalau kei ruru mei na'oku, na ne ke si oopara hunie e ro po'o ni iinoni, mala iini kakali sipu ko oopaa mo sipu mwaanie mo nanikot. ");
INSERT INTO apb_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Mala iini kakali sipu ko ne'ie mo sipu i pwalo-pwalona na mo nanikot i meu-meuline, nge ne ke ne'ie mo iinoni oodota'i, i pwalo-pwaloku, na mo iinoni aaela ke lae mola i meu-meuliku, hunie ahutana mwala ke ii'o aana e ro po'o ni iinoni. ");
INSERT INTO apb_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","“Oto ineu, a Inemauri, ne ke si unue hunie mo iini oodota'i nge ikire i pwalo-pwaloku uuri, ‘Omu ke lae mai mo iini nge a Mama'a e niie ha'adiana'anga ingeie oto huni'omu. Omu ke hele huu oto namiu aana aalahanga nge a Mama'a e dau aakau aana loosi'omu, uure oto aana ha'aholalana walumalau. ");
INSERT INTO apb_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Aana nou hiolo na omu ha'angaueu. Nou maarou, na omu ha'a-inuhieu. Maholo nou ka'a to'o aana nga leu ni ii'o ineu, omu tola konieu aana mo nume i'omu. ");
INSERT INTO apb_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Na maholo nou ka'a to'o aana nga mei ola huni ho'osie, omu nii sala nakue. Nou si'oha'a aani maelaa, omu lio i sulieu. Nou ii'o i nume ni ho'o, na omu maatolieu.’ ");
INSERT INTO apb_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Oto mwala oodota'i ngeena kei aalamieu uuri, ‘?Aalaha paine i'emi, maholo uri taa ni o hiolo, na emi ha'angau'o? ?Wa o maarou, nge emi ha'a-inuhi'o? ");
INSERT INTO apb_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","?Maholo uri taa nge o ka'a to'o aana nga leu ni ii'o i'oe, na emi tola koni'o aana mo nume i'emi? ?Wa o ii'o mwaakule na emi niie mo ola huni ho'osi'i i'oe? ");
INSERT INTO apb_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","?Maholo uri taa nge o si'oha'a aani maelaa wa o ii'o i laona nume ni ho'o nge emi maatoli'o?’ ");
INSERT INTO apb_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","“Oto ineu a Inemauri ne ke si aalamire uuri, ‘No ko unue oto huni'omu uri nga taa nge omu da urine hunie nga kele iini aana mo eesiku ienini, omu da hunieu ni otona.’ ");
INSERT INTO apb_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Oto ne ke si unue lo'u hunie mo iini i meu-meuliku uuri, ‘Omu ke tahi mwaanieu, mo iini nge omu ii'o oto loosie ha'amotaahinge a God. Omu ke tahi i laona dunge nge ko weru tarau mola, na e sa'a mwa'a lo'u. Dunge ngeena dau aakaulana e lae oto hunie a Satan na mo li'oa aaela ingeie. ");
INSERT INTO apb_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Aena aana maholo nou hiolo, omu ka'a ha'angaueu ike. Nou maarou na omu ka'a nii wei ike akue. Maholo nou ka'a to'o aana ike nga leu ni ii'o ineu, omu ka'a tola konieu ike aana mo nume i'omu. ");
INSERT INTO apb_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Na maholo nou ii'o mwaakule, omu ka'a niie ike nga mo ola ni ho'osi'i ineu. Na maholo nou si'oha'a aani maelaa na nou ii'o i laona nume ni ho'o, omu ka'a kele maatolieu lo'u.’ ");
INSERT INTO apb_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Aana maholona, mwalana kei aalamieu lo'u uuri, ‘?Aalaha paine i'emi, maholo uri taa ni o hiolo, wa o maarou, wa o ka'a to'o aana nga leu ni ii'o i'oe, wa o ka'a to'o sala, wa o si'oha'a aani maelaa, wa o ii'o i nume ni ho'o nge emi ka'a aapwasu eemu?’ ");
INSERT INTO apb_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","“Oto ineu, a Inemauri, ne ke si aalamire uuri, ‘No ko unue oto huni'omu uri nga taa nge omu ka'a da hunie nga kele iini aana mo eesiku ienini, omu ka'a da ike oto hunieu no'one eena.’” ");
INSERT INTO apb_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Oto a Jisas ko si ere ooreta uuri, “Mwala ngeena ha'amotaahilada kei lae tara'asi oto. Ta'e mo iini e oodota'i kire kei lae oto i laona maurihe huu.” ");
INSERT INTO apb_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Oto i purine a Jisas e saro ere-ere mango aana walu ola ienini, e si unue hunie mo pwaarongoisuli ingeie uuri, ");
INSERT INTO apb_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Omu saie oto uri e ruata hai dinge mola honosie Houlaa Ni Liumwaanie, ta'e omu ke saie lo'u uri aana hai dinge ngeena pwelolaku a Kale Ni Iinoni kei lae huni horo maesileku i lengine po'u-po'u.” ");
INSERT INTO apb_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Na oto aana maholona mo na'ohai pris na mo rato ni mwane kire mani ruru i nume a Kaiapas, Na'ohana Mo Na'ohai Pris. ");
INSERT INTO apb_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Kire ruru ngeena huni oala'inie nga tala mumuni uri taa huni pweloa a Jisas na huni horo maesie. ");
INSERT INTO apb_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Ta'e kire unue uuri, “Kolu sa'a te'urine ike aana mo dinge nge mwala ko loko hunie houlaa ngeena, mwaanie kire maaola-ola i tehula'ana.” ");
INSERT INTO apb_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Oto a Jisas e ii'o wau aana huilume i Betani, i nume a Saemon, iini nge maelaa ni osa e hite aana ka'u wai na'o. ");
INSERT INTO apb_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Oto maholo a Jisas ko ngeu i leune, ngaeta keni e lae mai saana. A keine e hele aana ho ate'ai rumu, ola holitana e tohungei peine na e tohungei wesu mangoni, oto ko lingisie ho rumu ngeena i pweune a Jisas. ");
INSERT INTO apb_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Mo pwaarongoisuli a Jisas kire leesie a keine ko te'urine, oto kire ko saewasu na kire ko dolosi uuri, “?E ue a keni ngeena ko waeta'inie mola ho rumu diana urine? ");
INSERT INTO apb_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Uri ke ha'aholinge'inie mola, ha'alaa e tarie mei to'oha paine aana, na niilana mei to'oha ngeena e kara'i lae mola hunie mo iinoni meitale eena.” ");
INSERT INTO apb_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Ta'e a Jisas e saie mone mola nga taa kire ko unuena, oto ko si te'uri hunire, “?Omu ko kotahie keita'aa huni taa? Tohungei mei ola diana ni ko esuie hunieu ie. ");
INSERT INTO apb_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Aana mo iinoni meitale kire kei ii'o pe'i'omu mola tarau, ta'e ineu nge nou sa'a ii'o ike pe'i'omu taraure'i. ");
INSERT INTO apb_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Oto e lingisie ho rumu ienini i lengine sapeku, aana ko deu aakau eeku loosie kire kei heitolinge'inieu ni ngeena. ");
INSERT INTO apb_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","No ko unue oto huni'omu uri ta'e-ta'ena nga leu i laona walumalau nge taroha'inilana aana Tataroha Diana kei lae-lae aana, unulana mei ola a keni ie ko esuie ngeena kei lae-lae huni aamasito'onga aana.” ");
INSERT INTO apb_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Oto ngaeta iini aana aawalai pwaarongoisuli mwana rue, iini nge kire ko sasaie satana aana a Jiudas Iskariot, e lae mai saana mo na'ohai pris. ");
INSERT INTO apb_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Oto ko dolosi aada uuri, “?Mala uri ne kei pweloa a Jisas huni'omu, nga taa nge omu kei niie nakue?” Oto kire iidumie e oolu aawalai mei to'oha aani siliva, kire ko si nii'i hunie. ");
INSERT INTO apb_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Uure aana maholona, a Jiudas ko si lio hunie uri nga maholo huni pweloa a Jisas hunire. ");
INSERT INTO apb_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Oto aana eetana nga dinge aana Houlaa Ni Bred Iis Ha'ike Aana, mo pwaarongoisuli e lae mai saana a Jisas, oto kire ko dolosi aana uuri, “?O saeto'o aana melu ke dau aakau aana ngaunge aana Liumwaanie huni'o i tei?” ");
INSERT INTO apb_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Oto a Jisas ko te'uri hunire, “Omu ke lae wai huilume paine i Jerusalem i saana iini nge nou lio hilisie oto, na omu ke unue hunie uri a Ha'a-uusuli e unue uuri, ‘Maholoi sato ineu ko kara'ini oto. Ne kei hele aana ngaunge aana Liumwaanie pe'ie mo pwaarongoisuli ineu i nume i'oe.’” ");
INSERT INTO apb_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Oto mo pwaarongoisuli kire dau i sulie nga taa a Jisas e unue hunire, na kire dau aakau oto aana ngaunge aana Liumwaanie. ");
INSERT INTO apb_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Oto i seulehi, a Jisas na aawalai pwaarongoisuli mwana rue kire si ii'o huni ngeu. ");
INSERT INTO apb_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Maholo kire ko ngeu ngeena, a Jisas ko si te'uri hunire, “No ko unue oto to'ohuu huni'omu uri nga iini hikemiu oto kei pweloau.” ");
INSERT INTO apb_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Oto kire ko tohungei hii aaela, na kire ko meni aehota dolosi oto aana uuri, “?Mwaanie ohe ineu, aalaha ineu?” ");
INSERT INTO apb_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Oto a Jisas ko aalamire uuri, “Ngaeta iini eemiu nge ko toonga'inie mei bred tararuru pe'ieu i laona nime si'iri, nge oto kei pweloau. ");
INSERT INTO apb_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Ineu a Kale Ni Iinoni ne kei mae taane oto mala mo Uusu-uusu Maa'i e unue. Ta'e aama-aamasilana a mwane ngeena nge kei pweloau a Kale Ni Iinoni, aana kei lae otoi diana hunie iinoni ngeena mala uri ke su'uri hute.” ");
INSERT INTO apb_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Oto a Jiudas, iini nge ko pweloa a Jisas ko te'uri no'one, “?Mwaanie ohe ineu, ha'a-uusuli ineu?” A Jisas ko aalamie uuri, “!Iau! I'oe oto a mwaena.” ");
INSERT INTO apb_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Oto maholo kire ko ngeu ngeena, a Jisas e hele aana ho bred, oto ko ere ni paalahenga, ko si nisie, na ko ha'a-adoa mo pwaarongoisuli aana. Oto ko te'uri, “Hele aana. Ngaue. Hasi'oku nge ienini.” ");
INSERT INTO apb_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Oto e hele aana lo'u kao-kaoi waen, ko ere ni paalahenga, ko niie hunire, na ko te'uri, “Omu ke mani inuhie, ");
INSERT INTO apb_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","aana apuku ni ienini nge ko ha'a-oaie haiholota'inge haalu a God ko esuie pe'ie mo iinoni ingeie. Apuku ha'a-aahesilana ko lae i tehula'ana mo iini hunge huni sae'aasie mo ooraha'aa ikire. ");
INSERT INTO apb_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","No ko unue huni'omu uri nou sa'a inuhie lo'u nga mei waen lai hule aana hai dinge nge ne kei inu aana waen haalu pe'i'omu i laona Aalahanga Aamaku.” ");
INSERT INTO apb_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Oto kire kanalie kana maa'i, nge kire si lae mwaanie hanuena huni hanetaa hunie Uuwo Ni Ei Olif. ");
INSERT INTO apb_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Oto a Jisas e he'i te'uri lo'u hunire, “Hai rodo si'iri oto, ahutemiu, omu kei meni tehi mwaanieu. Aana i laona mo Uusu-uusu Maa'i a God e unue uuri, Ne kei horo'ie a kakali sipu, oto mo sipu kei tatanga hailiu oto. ");
INSERT INTO apb_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Ta'e i purine ne kei ta'ela'i lo'u mwaanie maenga, ne kei lae i na'omiu huni maa'oohi'omu oto hao aana po'o ni henue i Kalili.” ");
INSERT INTO apb_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Oto a Pita ko aalamie a Jisas, ko te'uri, “Ineu nou sa'a roro'a ni toli'aasi'o ike, ma'alana ahutana mo mwane ngeena kire ko tehi mwaani'o.” ");
INSERT INTO apb_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Oto a Jisas ko te'uri hunie a Pita, “No ko unue oto huni'o uri i na'ona kue kei ngara i rodo si'irini, o kei taateinge'inieu ha'a-oolu uri o ka'a manata'inieu ike.” ");
INSERT INTO apb_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Ta'e a Pita ko tohungei ere a'aila'a oto uuri, “Ineu nou sa'a roro'a ni ere ike urine, ma'alana no ko mae pe'i'o.” Na ahutana mo pwaarongoisuli kire ko meni ere oto no'one urine. ");
INSERT INTO apb_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","A Jisas na mo pwaarongoisuli ingeie kire lai hule aana leu satana i Ketsemani. Oto a Jisas ko te'uri hunire, “Omu ke ii'o ka'u i leu, maholo no ko lai aarenga'i paro i leu.” ");
INSERT INTO apb_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Oto e toolea a Pita na e ro kalena Sebedi pe'ie, na ko si aehota tolahi'e hiito'o pe'ie saehuunge oto paine. ");
INSERT INTO apb_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Oto ko te'uri huniraelu, “Saeku ko lae otoi hi'e na e malisine oto maenga. Omu ke ii'o ka'u i leu, na omu ke lio-lio pe'ieu.” ");
INSERT INTO apb_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Oto a Jisas e kele lae ta'au mwaaniraelu, ko si pouruuru i aano haahie maana na ko aarea God, ko unue uuri, “Mama'a, iiola o niie mai hunie ne ke hotela'inie ko aasaieu oto. Mala ko mwada'u, saeku o ke oolisie aana nga iini mwa-mwate. Ta'e ne'ewau oto, o ke dau mola i sulie nga taa o saeto'o aana, na o ke su'uri deu i sulie nga taa nou saeto'o aana.” ");
INSERT INTO apb_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Oto a Jisas e aaliho'i lo'u mei saana e oolu pwaarongoisuli na ko leesie mola kire ko ma'ahu. Oto ko te'uri hunie a Pita, “?Ohe omu ka'a sai lio-lio ike pe'ieu nga kele maholoi sato? ");
INSERT INTO apb_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Omu ke lio na omu ke aarenga'i, mwaanie malaahonga e hane haahi'omu. Nou saie uri manatamiu e a'aila'a taane huni esuie mo ola diana, ta'e sapemiu ni mola ko tataku.” ");
INSERT INTO apb_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Oto a Jisas ko he'i ruana lae lo'u, na ko aarenga'i uuri, “Mama'a, mala e ka'a mwada'u oto huni ta'aasie mei sapesalunge ie mwaanieu, nge no ko eitanai'o ke oa oto urine huni'o.” ");
INSERT INTO apb_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Oto ko he'i eeliho'i lo'u mei saana mo pwaarongoisuli, na ko lio oodoie uri kire ko he'i ma'ahu lo'u, aana maadaelu e tohungei hi'e oto hiito'o. ");
INSERT INTO apb_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Oto a Jisas ko he'i lae lo'u mwaanire, ko lae lo'u i aarenga'i. Oolune nga maholo ko aarenga'i lo'u ie, ko unue lo'u mola ta'a-ta'a mei olana. ");
INSERT INTO apb_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Oto e ooli i saana mo pwaarongoisuli na ko unue, “?Uri omu ko ma'a-ma'ahu, na omu ko mamamalo ue? E hule oto aana maholo kire kei pweloau a Kale Ni Iinoni i nimana mo iinoni ooraha'aala. ");
INSERT INTO apb_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","!Ta'ela'i! !Kolu ke lae! Leesie ka'u, mwane nge ko pweloau ko lae oto mai ngeena.” ");
INSERT INTO apb_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Oto maholo a Jisas ko ere-ere ue, na a Jiudas Iskariot ko hule oto pe'ie pulitaa paine, mo iini nge mo na'ohai pris na mo rato ni mwane kire uusunge'inire mai pe'ie. Mwala ngeena kire mani hele naihi pe'i di'e, ");
INSERT INTO apb_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","na a Jiudas e unu aakau oto aana nga tolimaa hunire uuri, “Iini nge ne kei nono pe'ie, a Jisas otona. Ingeie oto omu ke tapolie.” ");
INSERT INTO apb_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Oto a Jiudas ko oodohie oto a Jisas, na ko unue hunie uuri, “Saulehi diana, Ha'a-uusuli.” Na ko nono oto pe'ie. ");
INSERT INTO apb_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Oto a Jisas ko aalamie uuri, “Malahuku, o ke dau leu-leu mola aana mei ola o lae mai huniena.” Oto kire tapolie a Jisas na kire ko hele ma'uta'a oto aana. ");
INSERT INTO apb_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Ta'e ngaeta iini aana mo pwaarongoisuli e darasie naihi ingeie, oto ko lama mousie oto aalingana ngaeta koni-konihe a Na'ohana Mo Na'ohai Pris. ");
INSERT INTO apb_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Oto a Jisas ko te'uri hunie pwaarongoisuli ingeie ngeena, “O ke ne'i eeliho'i aana naihi i'oe i talana. Aana ahutana mo iini ko heiseuni eeni naihi, horo'ilada kei lae aani naihi. ");
INSERT INTO apb_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","I'oe, o saie ka'u oto uri mala ne kei sukaa nga mei pe'inge mwaanie Aamaku, nge e sai uusunge'inie mola mai lau-leu mo sinolai ensel huni pe'ieu. ");
INSERT INTO apb_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Ta'e nga taa ko reu ienini ko reu oto huni ha'a-oaie mei ola nge mo Uusu-uusu Maa'i e unue uri kei reu oto urine.” ");
INSERT INTO apb_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Oto aana maholona, a Jisas e ere hunie mo ramo uuri, “?Uri omu unue ineu nga horopeli nge omu ko lae mai honosieu pe'i naihi na pe'i di'e urine? Ahutana dinge ka'u no ko talei o'o'o mola pe'i ha'a-uusulinge ta'au i laona Nume Maa'i Peine. ?Aana e ue ka'u omu ka'a tapolieu oto aana maholona? ");
INSERT INTO apb_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Ta'e ahutana mo ola ienini ko reu oto huni ha'a-oaie nga taa mo propet e uusue i laona mo Uusu-uusu Maa'i.” Oto ahutana mo pwaarongoisuli kire si toli'aasie a Jisas, na kire ko meni tehi oto mwaanie. ");
INSERT INTO apb_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Mo iini nge kire tapolie a Jisas, kire ko toolea oto hunie nume a Na'ohana Mo Na'ohai Pris, a Kaiapas. Maholona na mo ha'a-uusuli aana mo Ha'atolanga a Mosis na mo rato ni mwane aana mo Jiu, kire mani loko aakau oto ta'au i laona nume ngeena. ");
INSERT INTO apb_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","A Pita e holo maholoi tala taane mola i sulire. E lae mola wai hule aana lolata aana nume a Na'ohana Mo Na'ohai Pris. Oto e ii'o i aano pe'ie mwala kakakali i leune huni leesie nga taa kei reu aana a Jisas. ");
INSERT INTO apb_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Oto mo na'ohai pris na ahutana oto pulitaa ni lei-lei kire ko meni heitalenga'inie nga mo ola huni eerota'inie a Jisas huni horo maesie haahie. ");
INSERT INTO apb_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Mwala hunge kire lae mai na kire eerota'inie aana mo ola hunge. Ta'e pulitaa ni lei-lei ka'a lio oodoie ike nga tohungei mei ne'isaenga huni horo maesie a Jisas. Oto lae-lae, ngaeta ro mwane kire ta'ela'i lo'u poi, na kirerue ko ere uuri, ");
INSERT INTO apb_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","“A mwane ie e unue uuri, ‘Nou sai oho aasie mola Nume Maa'i Peine a God, na nou sai ha'a-uuresie lo'u mola i laona e oolu aata hai dinge.’” ");
INSERT INTO apb_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Oto Na'ohana Mo Na'ohai Pris e uure, ko te'uri hunie a Jisas, “?E ue? ?Uri o ka'a to'o aana ike nga mei ola huni aalamie mo ola nge kire ko ere waeli'o aani ngeena?” ");
INSERT INTO apb_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Ta'e a Jisas e tolirohu mola. Oto Na'ohana Mo Na'ohai Pris ko he'i unue lo'u hunie a Jisas uuri, “No ko unue huni'o, uri o ke tohe oodoi'emeelu aana satana God Mau-meuri'e uri i'oe Kalena God to'ohuu wa ha'ike.” ");
INSERT INTO apb_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Oto a Jisas ko aalamie uuri, “Nge ka'u oto o ko unuena. Na aana nga maholo omu kei meni leesieu a Kale Ni Iinoni ne kei ii'o aana na'ohai ii'o-ii'oha i pwalo-pwalona God Hahu'ana Nanama, na kei lae mai i laona mei uuru uure ta'au i salo.” ");
INSERT INTO apb_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Maholo Na'ohana Mo Na'ohai Pris ngeena ko a'arie to'oni ingeie, aana ko tohungei saewasu, ko si unue uuri, “A mwane ie ko ere mwakata'inie mola a God. !Ngeena kolu ka'a saeto'o aana lo'u nga iini ke ere takoie! Omu meni rongoa oto maraamiu uri e ere mwakata'inie a God. ");
INSERT INTO apb_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","?Ha'alaa nga taa nge omu kei unue aana?” Oto kire ko meni aalamie uuri, “!E malisine oto ke mae!” ");
INSERT INTO apb_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Oto kire ko ngisuhie maana a Jisas, na kire ko repusie. Kire pwasu haahie maana, na kire ko hidelie aana nimada, ");
INSERT INTO apb_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","na kire ko te'uri, “O unue uri i'oe oto a Kraes. Mala ko urine, o ke unue ka'u a tei e rapusi'o huni haata'inie uri i'oe oto nga propet to'ohuu.” ");
INSERT INTO apb_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Aana maholona na a Pita e ii'o ue i laona lolata po'oi sinaha. Oto ngaeta keni eu'esu e tapaliu, na ko leesie a Pita. Oto ko te'uri hunie, “I'oe no'one pe'ie a Jisas ni Kalili.” ");
INSERT INTO apb_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Oto a Pita ko taateinge'inie i na'ona ahutada ko te'uri, “Nou ka'a saie ike nga taa o ko ere i sulie.” ");
INSERT INTO apb_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Oto ko lae ta'au takoie maana para, na ngaeta keni eu'esu ko leesie lo'u. Oto a keine ko te'uri hunie mwala kire uure i leune, “A mwane ie e o'o'o no'one pe'ie a Jisas ni Nasaret.” ");
INSERT INTO apb_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Oto a Pita ko he'i taateinge'inie lo'u, na ko tohe oto uuri, “!Nou ka'a kele saie ike a mwane ngeena!” ");
INSERT INTO apb_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","E ka'a tewa lo'u na ngaeta mwala e uure-uure i leune, kire ko lae mai saana a Pita. Oto kire ko te'uri hunie, “Sa'a mola i'oe ngaeta mwane aada ni ngeena, i sulie melu rongo saie mola aana erenga i'oe, aana o ko aapani mala mo Kalili.” ");
INSERT INTO apb_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Oto a Pita e ere ni ho'asinge ko te'uri, “!To'ohuu oto mala God ta'au i Lengi! !Nou ka'a saie ike a mwaena!” Oto kue ko tolana ngara oto. ");
INSERT INTO apb_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Aana maholona nge a Pita ko si aamasito'o aana mo wala a Jisas e unu-unu'i hunie uuri, “I na'ona kue kei ngara i rodo si'irini, o kei taateinge'inieu ha'a-oolu uri o ka'a manata'inieu ike.” Oto a Pita e iisitaa i sinaha, ko si ngara uulo-uulo. ");
INSERT INTO apb_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Oto e dangi maahu'o-hu'o, na ahutana mo na'ohai pris na mo rato ni mwane kire mani loko na kire oala'inie oto horo'ilana a Jisas kei lae uri taa. ");
INSERT INTO apb_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Oto kire pwasue, kire ko si toolea, na kire ko toli'aasie i nimana Paelat, mwane ni Rom nge ko aalaha haahie mo Jiu aana maholona. ");
INSERT INTO apb_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","A Jiudas iini nge e pweloa, maholo e saie uri kire ko lei mae oto aana a Jisas, ko si oonisae. Oto ko tola aaliho'i aana oolu aawalai mei to'oha nge e hele-hele aani ngeena hunie mo na'ohai pris na mo rato ni mwane. ");
INSERT INTO apb_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Oto ko te'uri hunire, “Nou deu ooraha'aa oto aana nou talei pwelo tototala mola aana iini e ka'a dau hu'isie ike nga mei ola.” Oto mo rato ni mwane kire ko aalamie uuri, “Leu ngeena ka'a roro'anga ike i'emeelu ni ngeena. Roro'anga oto i'oe maraamu.” ");
INSERT INTO apb_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Oto a Jiudas e si aasie mo to'oha ngeena i aano wai Nume Maa'i, na ko iisitaa oto, ko si lae li'o maraana. ");
INSERT INTO apb_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Mo na'ohai pris kire so'ohie mo to'oha ngeena, na kire ko unue uuri, “Mei to'oha aani siwe ni ienini. Kolu sa'a ne'ie ike pe'ie mo to'oha aana Nume Maa'i aana ha'atolanga ikolu e uure honosie mei to'oha aani epu.” ");
INSERT INTO apb_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Oto kire ere-ere i sulie, kire ko si lo'onga'i huni holie mola mei aano huni heitolinge'inie mo awataa aana. Oto kire lae, kire ko si holie mei aano mwaanie ngaeta mwane ko eu'esu nime aani mwakano. ");
INSERT INTO apb_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Aena urine nge kire si haara'inie mei aano ngeena aana Aano Ni Epu hule oto mai aana mo dinge ienini. ");
INSERT INTO apb_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","I leune nge nga taa a Propet Jeremaea e unue oto mai waite e si to'ohuu, aana e unue uuri, Kire toolea oolu aawalai mei to'oha ngeena, mei ola mwala ni Israel kire lo'onga'inie oto huni holi talana aana, ");
INSERT INTO apb_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","na kire aasie mei to'oha aana oto huni holie mei aano mwaanie mwane ko eu'esu nime aani mwakano, mala oto a aalaha e hatonga'inie hunieu. ");
INSERT INTO apb_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Oto kire toolea mai a Jisas i na'ona a Paelat, na a Paelat ko si dolosi aana uuri, “?Uri i'oe ni oto inemauri mo Jiu?” Oto a Jisas ko aalamie uuri, “Nge ka'u oto o ko unuena.” ");
INSERT INTO apb_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Ta'e maholo mo na'ohai pris na mo rato ni mwane kire ere-ere aana, e ka'a aalamire ike oto oo'oo. ");
INSERT INTO apb_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Oto a Paelat ko si te'uri hunie, “?Uri o ka'a rorongoa ike mo ola hunge oto kire ko unu'i eemune?” ");
INSERT INTO apb_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Ta'e a Jisas e ka'a aalamie lo'u nga ta'a-ta'a kele mei wala, oto hule aana a Paelat na ko si tohungei pangata'inie lo'u mola. ");
INSERT INTO apb_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Suli helisi aana maholo Houlaa Ni Liumwaanie, aalaha ni Rom ngeena e sai luhesie ta'ena nga iini mwala ko ha'atohue mwaanie nume ni ho'o. ");
INSERT INTO apb_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Oto aana maholona, ngaeta mwane satana a Jisas Barabas, ingeie i laona nume ni ho'o. Na mo ola aaela a mwane ngeena e asui'i ahutana mwala kire mani sai'i. ");
INSERT INTO apb_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Oto maholo ahutana mwala kire mani loko, a Paelat ko si dolosi aada uuri, “?Iini uri taa aana e ro mwane ie nge omu saeto'o aana ne ke luhesie huni'omu? ?A Jisas Barabas, wa a Jisas iini sailana uri a Kraes?” ");
INSERT INTO apb_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","A Paelat e dolosi aada urine aana e saie mone uri mwala paine aana mo Jiu kire toolea mai a Jisas i saana aena aana kire ko upwesie. ");
INSERT INTO apb_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Oto maholo a Paelat e ii'o i aano i lengine naunekume ni leinge, hu'e ingeie e uusunge'inie mai mei wala hunie na ko unue uuri, “Mwaanie o eu'esuie nga mei ola aana mwane oodota'i ngeena, aena aana nou tohungei hii aaela i rodo aana nou ma'ahu polea.” ");
INSERT INTO apb_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Na aana maholo a Paelat ko pwaarongo i sulie mei wala hu'e ingeie ko unue ngeena, mo na'ohai pris na mo rato ni mwane kire ko unue oto uri mwala ke ha'atohu aana a Paelat hunie ke luhesie a Barabas, na ke horo maesie a Jisas. ");
INSERT INTO apb_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Oto a Paelat ko dolosi lo'u aada uuri, “?A tei hikana e ro mwane ienini omu saeto'o aana uri ne ke luhesie huni'omu?” Oto kire ko meni unue uuri, “!A Barabas!” ");
INSERT INTO apb_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Oto a Paelat ko he'i te'uri lo'u hunire, “?Ko urine, nga taa nge ne kei da aana a Jisas iini nge sailana uri a Kraes?” Oto kire ko meni aalamie uuri, “!Horo maesie i lengine po'u-po'u!” ");
INSERT INTO apb_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Oto a Paelat ko he'i dolosi lo'u aada uuri, “?Aana e ue? ?Ha'alaa nga mei taa nge e dau aaelasie?” Ta'e kire ko si meni tea paine mola liutaa uuri, “!Horo maesie i lengine po'u-po'u!” ");
INSERT INTO apb_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","A Paelat e lio-lio na ko lio aasaie oto uri kei uure honosire uri taa, na maaola-olanga ko kara'i reu oto. Oto e si da nimei wei, ko hodalie nimana i maadaelu na ko unue uuri, “!Lio ka'u! No ko hodalie nimeku mwaanie nou roro'a aana horo-maesilana a mwane ie. Nga roro'anga ineu ha'ike, ta'e roro'anga oto i'omu maraamiu.” ");
INSERT INTO apb_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Oto ahutana mwalana ko aalamie a Paelat uuri, “!E diana mola! !Ne'ewau! !Roro'anga oto i'emi maraamami! !Ma'alana nga mei ha'aloinge ko si hite aana mo kalemami haahie maelana, ta'e i sulie mei ola emi saeto'o aana mone oto!” ");
INSERT INTO apb_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Oto a Paelat e si luhesie a Barabas hunire. Na e unue hunie mo ramo uri kire ke hola'i wini-winie a Jisas, nge kire ke si horo maesie i lengine po'u-po'u. ");
INSERT INTO apb_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Oto mo ramo kire toolea a Jisas i laona lolata ahuie toohi peine a Paelat. Kire si soie mai ahutana mo ramo aana pulitaa ikire, na kire mani ruru i saana a Jisas huni ha'amwasi aana. ");
INSERT INTO apb_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Oto kire ta'aasie mo to'oni ingeie mwaanie, na kire ko ha'ato'onie mala inemauri aana to'oni tetewa nonoro'a mala mo aalaha ko ho'o-ho'osi'i. ");
INSERT INTO apb_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Oto mo ramo ngeena kire asuie rorodara aani walo kau-keu, kire ko ne'ie i pweune a Jisas. Na kire ne'ie mai rade i laona nime i pwalo-pwalona oto mala mo inemauri ko hele-hele aani. Oto kire pouruuru haahie, kire ko si ha'a-ha'amwasi aana, kire ko te'uri, “!Lahea inemauri mo Jiu!” ");
INSERT INTO apb_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Oto kire ngisuhie na kire da mai rade mwaanie, kire ko si reu-repusie pwaune. ");
INSERT INTO apb_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Maholo kire ha'a-ha'amwasi mango aana a Jisas urine, oto kire ko si ta'aasie to'oni nonoro'a mwaanie, na kire ko ha'ato'onie lo'u aana mo to'oni ingeie. Oto kire ko si toolea i sinaha huni lai horo maesie i lengine po'u-po'u. ");
INSERT INTO apb_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Maholo kire ko iisitaa ta'au mwaanie huilume pe'ie a Jisas, na kire ko oodoie ngaeta mwane uure mwaanie huilume paine i Saerin, satana a Saemon. Oto mo ramo ngeena kire ko deu rarahie oto uri ke aanga'inie po'u-po'u mwaanie a Jisas. ");
INSERT INTO apb_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Oto kire lae ta'i hule aana leu kire haara'inie aana i Kolkota, lo'onga'inge aana uuri, “Leu ni rarata.” ");
INSERT INTO apb_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","I leune i Kolkota, mo ramo ko niie waen hunie a Jisas uri ke inu. Waen ngeena kire aaropwaie pe'ie ai aha'i huni uure honosie sapesalunge, ta'e maholo a Jisas e mami aahongana, oto ka'a sare inuhie ike. ");
INSERT INTO apb_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Oto mo ramo kire si uie a Jisas i lengine po'u-po'u. Mango urine, kire ko si ado aana mo to'oni ingeie na kire ko inie daes huni'i. ");
INSERT INTO apb_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Oto kire si ii'o i aano i leune, kire ko kakalie. ");
INSERT INTO apb_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Oto kire ne'ie i hahona pwaune a Jisas mo wala huni haata'inie uri nga taa e dau aaelasie. Kire ko uusue uuri, A JISAS NI IENINI, INEMAURI MO Jiu. ");
INSERT INTO apb_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Na kire uie e ro mwane horopeli no'one pe'ie a Jisas i lengine ngaeta ro po'u-po'u. Nga iini i pwalo-pwalona na nga iini i meu-meuline. ");
INSERT INTO apb_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Oto mwala ko liu i leune, kire ko ere maaleledie, na kire ko teile'inie pwaude, ");
INSERT INTO apb_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","na kire ko ha'a-eetaa uuri, “Mwane nge o unue uri o kei oho aasie Nume Maa'i Peine na uri o kei ta'e aaliho'i aana lo'u mola i laona e oolu aata hai dinge eena. Mala o ko ne'ie Kalena a God to'ohuu, o ke ha'a-uuri'o ka'u maraamu. !O ke siho mai i aano mwaanie po'u-po'u!” ");
INSERT INTO apb_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","E urine no'one mola aana mo na'ohai pris, na mo ha'a-uusuli aana ha'atolanga, na mo rato ni mwane. Ikire na kire ko ha'amwasi aana a Jisas no'one urine, na kire ko unue uuri, ");
INSERT INTO apb_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“E roro'a ha'a-ha'a-uurie ka'u mwala aaopa, ta'e e sa'a ha'a-uurie ike maraana. Mala ke siho oto mai i aano mwaanie po'u-po'u aana maholo ienini, ha'alaa kolu ko hiiwalaimoli uri ingeie oto Inemauri ikie mo Jiu. ");
INSERT INTO apb_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","!Iiei! E nou-noruto'o aana a God, na e unue oto maraana uri ingeie Kalena God. Kolu ke lio-lio ka'u, ohe a God ko ha'a-uurie oto molana.” ");
INSERT INTO apb_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","E ro horopeli, nge kire uirerue pe'ie a Jisas, na kirerue ko ere aaelasie oto no'one mola urine. ");
INSERT INTO apb_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Oto i upui aatowaa, rodohono e dau haahie ahutana hanue hunie e oolu maholoi sato. ");
INSERT INTO apb_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Na ola mala oolune nga maholoi sato i aapau, a Jisas e si soi oto paine aana erenga ni Jiu uuri, “?Eloi, Eloi, lama sabaktani?” nge ne'isaenga aana uuri, “?God ineu, God ineu, e ue oto o aatopuri eeku?” ");
INSERT INTO apb_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Oto ngaeta mo iini aana mwala e uure-uure i leune kire rongo, kire ko te'uri, “!Rongo ka'u! Ko soie a Elaeja.” ");
INSERT INTO apb_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Oto ngaeta iini aada e huru pe'ie mei loi-losi, e ha'ahonue aana waen aha'i, ko susu'ie aana mai ei, oto ko susue'inie ta'au hunie ngidune a Jisas hunie ke inu. ");
INSERT INTO apb_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Ta'e ngaeta mo iini ko te'uri, “Oto kolu ke maa'oohi ke'u. Ohe kolu ko leesie a Elaeja ko lae mai ha'a-uurie.” ");
INSERT INTO apb_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Na a Jisas ko he'i soi lo'u aana mei wala paine, na ko mae oto. ");
INSERT INTO apb_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Oto mola aana maholoi satona, sala kire lohea honosie Hahu'ana Leu Maa'i i laona Nume Maa'i Peine e a'ari hunie e ro aapa, uure oto ta'i lengi lai hule oto hai aano. Na nunu peine e aanuie mwakano, hule aana mo heu kire talihite oto hunie e ro aapai heu. ");
INSERT INTO apb_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Mo kilipwe'u kire taha, na mo iini hunge aana mwala a God nge kire mae oto waite, kire ta'ela'i oto lo'u mwaanie maenga. ");
INSERT INTO apb_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Kire iisitaa mwaanie mo kilipwe'u, na i purine a Jisas e ta'ela'i mwaanie maenga, kire si laehie huilume maa'i i Jerusalem na mwala hunge kire leesire. ");
INSERT INTO apb_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Oto na'ohana mo ramo ni Rom na mo ramo pe'ie nge ko kakalie a Jisas, kire leesie nunu na ngaeta mo ola lo'u e raune, kire ko si tohungei me'u oto hiito'o na kire ko unue uuri, “A mwane ie Kalena God oto to'ohuu.” ");
INSERT INTO apb_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Mo keni hunge kire uure no'one wau ha'atau mwaanie po'u-po'u, kire ko ha'a-ha'amaesie nga taa ko reu. Mo keni ngeena kire lae oto mai pe'ie a Jisas uure i Kalili huni pe'i-pe'ie i sulie tala. ");
INSERT INTO apb_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Ngaeta mo keni aada nge kira Meri ni Makdala, na a Meri nikana Jemes na Josep, na nikana e ro kalena Sebedi. ");
INSERT INTO apb_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Aana maholona nga mwane to'o-to'o ni Arimetia, satana a Josep, ko lae oto mai. A mwane ngeena e hiiwalaimoli no'one aana a Jisas. Na maholo ko lae oto hunie i seulehi aana dingena, ");
INSERT INTO apb_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","a Josep e lae mai saana Paelat. Oto ko ha'atohue rae aana Jisas aana a Paelat. Oto a Paelat e unue kire ke toli'aasie hunie. ");
INSERT INTO apb_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Oto a Josep e lae i oohosie rae aana Jisas, ko si uloa aani sala rere'a diana, ");
INSERT INTO apb_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","na ko ne'ie i laona kilipwe'u haalu ingeie, ola kire si didie mola mwaanie hau oto paine. Oto e honoa maana kilipwe'u ngeena aana ho heu oto paine, ko si lae mwaanie. ");
INSERT INTO apb_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","A Meri ni Makdala na ngaeta Meri lo'u, kirerue ii'o taane i leune kire ko lee-leesie nga taa ko reu. ");
INSERT INTO apb_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Oto aana hai dinge i purine dinge ni talama'inge hunie Dinge Maa'i Mo Jiu, mo na'ohai pris na mo Parise kire ruru i saana a Paelat. ");
INSERT INTO apb_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Oto kire ko te'uri hunie, “Mwane Ou'ou, melu ko si aamasito'o aana nga taa mwane eero-eero ngeena e unue na e mauri ue aana e te'uri, ‘I purine oolu hei dinge ne kei ta'ela'i lo'u.’ ");
INSERT INTO apb_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Oto o ke unue hunie mo ramo i'oe, hunie kire ke kakali diana aana kilipwe'u ingeie lai hule aana oolune nga hai dinge, mwaanie mo pwaarongoisuli ingeie kire lae mola mai pelie rae aana i rodo. Oto kire ke si unue hunie mwala uuri, ‘E ta'ela'i oto mwaanie maenga,’ na eeronga ngeena kei tohungei aaela oto hiito'o lo'u liutaa aana iini hola'ina'o nge e unue uri ingeie a Kraes, Kalena God.” ");
INSERT INTO apb_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Oto a Paelat ko si unue hunire uuri, “Kohi taane. Omu ke toolea ngaeta mo ramo ineu, hunie kire ke kakali diana aana kilipwe'u mala lo'onga'inge i'omu.” ");
INSERT INTO apb_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Oto kire lae ta'au, kire puluie ha'a-ara ikire i reutana hau peine ngeena mwaanie nga iini e tahanie kilipwe'u, na kire ko toli'aasie mo ramo i saana huni kakalie. ");
INSERT INTO apb_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Oto i purine Dinge Maa'i Mo Jiu, na ko si mwaasisine aana eetana nga dinge aana wiki haalu, a Meri ni Makdala na ngaeta Meri lo'u, kirerue lae mai huni leesie kilipwe'u. ");
INSERT INTO apb_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Aana maholona paineha'ana nunu ko hite oto, aana ensel a God e siho mai uure i Lengi. E lae mai ta'aasie hau mwaanie maana kilipwe'u, oto e si ii'o i lengine. ");
INSERT INTO apb_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Sapena ensel ngeena e raa oto mala wa'ariri, na mo to'oni ingeie kire rere'a oto liutaa aana ta'ena nga ola e rere'a. ");
INSERT INTO apb_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Oto mo ramo nge kire ko kakalie kilipwe'u ngeena, kire apara'i pe'ie ma'unge. Kire ko eriri oto, na kire rapute'i i aano urihana oto mwala e mae. ");
INSERT INTO apb_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Oto ensel ko ere hunie e ro keni na ko te'uri, “!Mwaanie more ma'u-me'u! Nou saie taane uri more ko heitalea a Jisas, iini kire horo maesie i lengine po'u-po'u. ");
INSERT INTO apb_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Ingeie ha'ike oto i leu. E ta'ela'i eeliho'i oto lo'u mala e unue ka'u oto huni'omu waite. More ke lae ka'u mei leesie leu e eno-eno aana. ");
INSERT INTO apb_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Oto more ke lae oto lau-leu, na more ke ha'arongoa mo pwaarongoisuli ingeie uri e ta'ela'i oto mwaanie maenga. Ko lae oto i na'o huni maa'oohi'omu hai Kalili, na omu ke si leesie oto hai leune. Nga taa nou sare unue huni'omu ni otona.” ");
INSERT INTO apb_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Oto e ro keni ngeena kirerue ko tolana lae oto mwaanie kilipwe'u pe'ie ma'unge na saemangonga oto liutaa no'one. Oto kirerue ko si huru huni lai ha'arongoa mo pwaarongoisuli ingeie. ");
INSERT INTO apb_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Oto a Jisas ko tolana oodoirerue lo'u na ko unue uuri, “Ho'owa diana.” Oto kirerue lae mai saana, kirerue ko hele aana ae'aena pe'i ha'ama'unge aana. ");
INSERT INTO apb_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Oto a Jisas ko te'uri hunirerue, “Mwaanie more ma'u-me'u, ta'e more ke lae ta'i unue hunie maeni eesiku uri kire ke lae hai Kalili, na kire ke si leesieu oto hai leune.” ");
INSERT INTO apb_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Maholo na e ro keni ko lae-lae ue i sulie tala, ngaeta mo iini aana mo ramo nge kire kakakalie kilipwe'u, kire lae oto ta'au i henue i Jerusalem na kire ko ha'arongoa oto mo na'ohai pris aana nga moi taa e rau. ");
INSERT INTO apb_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Oto mo na'ohai pris kire loko pe'ie mo rato ni mwane, kire ko si meni wala. Oto kire ko niie mei to'oha oto paine hunie mo ramo ngeena, ");
INSERT INTO apb_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","na kire ko te'uri, “Omu ke hahu'ei unue oto oodoie mwala uri mo pwaarongoisuli ingeie kire lae mai pelie rae aana i rodo maholo na omu ko ma'ahu. ");
INSERT INTO apb_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Mala uri a Paelat ko pele'i rongoa leune, i'emeelu melu ke si ere-ere taane pe'ie aana, mwaanie omu roro'a lo'u aana.” ");
INSERT INTO apb_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Oto kire toolea mei to'oha ngeena, na kire ko deu oto i sulie nga taa mo rato ni mwane kire hatonga'inie hunire. Oto tataroha ngeena ko taro hailiu i matolana mo Jiu hule oto mai aana mo dinge ienini. ");
INSERT INTO apb_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Oto aawalai pwaarongoisuli mwana eeta kire lae oto hunie uuwo i Kalili, leu nge a Jisas e unue kire ke lae aana. ");
INSERT INTO apb_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Na maholo kire leesie a Jisas, oto kire ko si pouruuru ni ha'ama'unge aana, ta'e aana e urine na ngaeta mo iini aada kire ne'isae rue-rua'a mola ue. ");
INSERT INTO apb_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Oto a Jisas ko lae mai saada, na ko ere hunire uuri, “A God e niie oto ahutana nanamanga hunieu, haahie ahutana mo ola i Lengi na mai aano i leu. ");
INSERT INTO apb_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Aena urine, omu ke lae, na omu ke da hunie ta'ena nga iinoni ni welumalau ke ne'i pwaarongoisuli oto ineu. Omu ke loto maa'i aada aana satana a Mama'a na a Kale na Li'oa Maa'i. ");
INSERT INTO apb_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Omu ke ha'a-uusulire hunie kire ke tola i sulie oto ta'ena nga ola nou hatonga'inie huni'omu. Na omu sai noruto'o aana uri ne ke ii'o pe'i'omu oto tarau, lai hule aana ha'amangolana walumalau.” ");
INSERT INTO apb_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Tataroha Diana i sulie a Jisas Kraes, Kalena a God e aehota oto mala ");
INSERT INTO apb_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","uusulana e lae i laona uusu-uusu a Propet Aesaea, aana e unue uuri, Ne kei uusunge'inie hurula'aa ineu wau i na'omu hunie ke dau aakau aana tala i'oe loosi'o. ");
INSERT INTO apb_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Nga iini ko soi-soi peine i laona hanuesala uuri, “Omu ke dau aakau aana tala loosie laenga mai a Aalaha, na omu ke ha'a-oodohie tala ni lae ingeie.” ");
INSERT INTO apb_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Oto a Jon Loto Maa'i e ii'o i henuesala, na ko taroha'inie hunie mwala uri kire ke aali'u to'ohuu mwaanie ooraha'aa, nge kire ke si loto maa'i hunie a God ke sae'aasie mo ooraha'aa ikire. ");
INSERT INTO apb_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Na mwala hunge kire lae mai saana uure mwaanie i Jerusalem na ta'ena nga leu lo'u aana po'o ni henue i Jiudia. Kire ko ha'ahoue oto mo ooraha'aa ikire, oto a Jon ko si loto maa'i aada i laona wai peine i Jodan. ");
INSERT INTO apb_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","A Jon e ho'o-ho'osie mola to'oni aaela kire asuie aana iihune kamel, na e ho'osie haahie danumana roroto'oni aani te'e-te'ei puluke. Na ngaulaa ingeie oto mo oru na mo ngingidue. ");
INSERT INTO apb_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Na e taroha'inie i na'ona mwala uuri, “Ngaeta iini kei lae mai puriku, ingeie e paine lo'u liutaa aaku, hule aana ineu na nou ka'a diana ike malisine ne ke asu mala koni-konihe huni luhesie ho'ohaahi'ae ingeie. ");
INSERT INTO apb_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Ineu no ko loto maa'i eemiu mola aani wei, ta'e ingeie kei loto maa'i eemiu aana Li'oa Maa'i.” ");
INSERT INTO apb_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Oto aana maholona a Jisas e lae mai mwaanie i Nasaret aana po'o ni henue i Kalili, na a Jon e loto maa'i aana i laona wai i Jodan. ");
INSERT INTO apb_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Aana maholo a Jisas e ta'ela'i poi mwaanie wai, e lio na ko leesie ta'au i Lengi e taha, na Li'oa Maa'i ko siho oto i lengine mala hiroikuu. ");
INSERT INTO apb_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Na mei wala uure ta'au i Lengi ko te'uri, “I'oe oto hahu'ana kaleku, na nou tohungei manata diana huni'o, na no ko ilenimwa'e oto liutaa haahi'o.” ");
INSERT INTO apb_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Na oto lau-leu Li'oa Maa'i e toolea i laona hanuesala ");
INSERT INTO apb_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","aana leu nga mwala ha'ike aana, ta'e mo ola mauri ni me'esu hali'ite kire ii'o wau i leune. Oto a Satan e malaahongana hunie hai aawalai hei dinge wau i leune, oto mo ensel kire si lio i sulie. ");
INSERT INTO apb_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Oto i purine kire ne'ie a Jon i nume ni ho'o, a Jisas e lae hunie po'o ni henue i Kalili na ko taroha'inie Tataroha Diana a God. ");
INSERT INTO apb_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Na e ere uurini, “E hule oto aana pongi nge holosilana e lae, uri Aalahanga a God e kara'ini oto. Omu ke aali'u mwaanie mo ooraha'aanga i'omu, na omu ke hiiwalaimoli aana Tataroha Diana.” ");
INSERT INTO apb_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Maholo a Jisas e lae-lae i reune Aasi I Kalili, na ko leesie ro mwane wee-weesi, a Saemon na a Andru aasine. Kirerue ko weesi aani hu'o. ");
INSERT INTO apb_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Oto a Jisas ko te'uri hunirerue, “More ke lae mai i sulieu, na more ke lulu i sulieu hunie ne ke ha'asai'omore'i aana tolahai weesinganga hunie mo iinoni.” ");
INSERT INTO apb_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Oto e ro mwaasine ngeena ko tolana toli'aasie oto mo hu'o ikirerue, na kirerue ko lulu i sulie oto a Jisas. ");
INSERT INTO apb_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Oto maholo ko ada lo'u hao, na ko he'i leesie lo'u ngaeta ro mwaasine, a Jemes na Jon pe'ie aamadarue a Sebedi. Ikire i laona iiola, na kire ko seumaa aana mo hu'o ikire. ");
INSERT INTO apb_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Oto a Jisas e soirerue, na kire ko toli'aasie oto aamada a Sebedi na mo koni-konihe i laona iiola, kirerue ko lulu i sulie oto. ");
INSERT INTO apb_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Oto kire ko lae oto hunie huilume i Kapaneam, na aana Dinge Maa'i Mo Jiu, a Jisas e lae huni ha'a-uusuli ta'au i laona nume ni palo-palo ikire. ");
INSERT INTO apb_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Na ahutana mwala ko meni pangata'inie ha'a-uusulinge ingeie, aana ha'a-uusulinge ingeie e ka'a urihana ike mo ha'a-uusuli aana mo Ha'atolanga a Mosis, aana ko ha'a-uusuli aana nanamanga. ");
INSERT INTO apb_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Na nga mwane li'oa aaela aana ingeie no'one wau i laona nume ni palo-palo aana maholona. A mwaena ko toolea oto aawaranga paine na ko unue uuri, ");
INSERT INTO apb_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“!Aaia! !Jisas ni Nasaret! ?O kei ue emeelu lo'u eena? ?Ohe o lae oto mai huni waeli'emeelu ni ngeena? Ineu nou sai'o mola. I'oe iini maa'i a God.” ");
INSERT INTO apb_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Oto a Jisas ko si ere aana li'oa aaela ngeena ko te'uri, “O ke rohu oto, na o ke lae mwaanie a mwane ngeena.” ");
INSERT INTO apb_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Oto li'oa aaela ngeena e papata'inie a mwaena hailiu, e si aawara, na ko iisitaa oto mwaanie. ");
INSERT INTO apb_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Na ahutana mwala ko meni pangata'i, na kire ko dolosi heiliu oto i matolada uuri, “?Ha'a-uusulinge haalu uri taa ni ie? Mwane ngeena ko ere aana nanamanga. E ere hunie mo li'oa aaela, oto kire tola oto i sulie.” ");
INSERT INTO apb_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Na oto lau-leu tataroha aana e taro oto ahusie ahutana mo henue kali-kelie i Kalili. ");
INSERT INTO apb_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Oto a Jisas na e hai mwane pe'ie, kire iisitaa mwaanie nume ni palo-palo, kire ko si oodohie nume a Saemon na Andru. ");
INSERT INTO apb_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Na keni hungaona a Saemon e eno taane i nume aana ko tohungei mata'i oto hiito'o. Oto kire ha'arongoa a Jisas aana. ");
INSERT INTO apb_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Na e lae mai saana, oto e hele i ki'ine na ko ta'ea. Oto mata'i e tolana mango oto mwaanie, ko si rareta'inire. ");
INSERT INTO apb_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Oto aana maholo ko seulehi oto, nge mwala kire toolea mai mo mae-maea'a hunge i saana a Jisas, na ngaeta mo iini mo li'oa aaela aada no'one. ");
INSERT INTO apb_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Ahutana mwala ni Kapaneam kire loko tarakoni i maana nume. ");
INSERT INTO apb_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","A Jisas e ha'a-uurie mwala hunge aana mo maelaa hai aaopa'i e hite aada, na e oohe aasie no'one mo li'oa aaela mwaanie mwala hunge. E ka'a toli'aasie ike mo li'oa aaela ngeena kire ke ere, aena aana kire manata'inie oto. ");
INSERT INTO apb_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Oto i maahu'o-hu'o na e ka'a dangi ue, a Jisas e ta'ela'i na e lae maraana takoie leu nga mwala ha'ike aana, nge e si aarenga'i. ");
INSERT INTO apb_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Lae-lae a Saemon na ngaeta mo iini lo'u pe'ie, kire lae huni heitalea. ");
INSERT INTO apb_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Oto maholo kire lio oodoie, kire ko te'uri hunie, “Ahutana mwala ko lo'ohi'o.” ");
INSERT INTO apb_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Ta'e a Jisas e aalamire uuri, “Ha'ike, ta'e kolu ke lae aana ngaeta mo huilume lo'u, hunie ne ke laeliwala no'one nada, i sulie nou lae mai huni esu oto urine.” ");
INSERT INTO apb_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Oto e si lae kalie ahutana mo huilume i Kalili pe'i laeliwalanga i laona mo nume ni palo-palo mo Jiu, na pe'i oohe aasie mo li'oa aaela lo'u no'one. ");
INSERT INTO apb_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Na ngaeta mwane e to'o aana maelaa ni osa, e lae mai pouruuru i na'ona a Jisas, na ko ha'atohu aana uuri, “Mala o ko mwa'e-mwa'e, o ke kuraa sapeku hunie ne ke rere'a adona ii'onga lo'u pe'ie mwala a God.” ");
INSERT INTO apb_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","A Jisas e aamasie oto liutaa, oto e si susue'inie wau nimana huni hele i sapena mwaena, na ko te'uri, “Iau, nou mwa'e-mwa'e taane. Sapemu ke mola oto.” ");
INSERT INTO apb_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Oto mola lau-leu aana maholo e ere urine, maelaa ni osa ngeena e tolana mango oto mwaanie, na sapena e mola oto. ");
INSERT INTO apb_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","Oto a Jisas ko si ere aana a mwaena uuri, “!O ke rongo! Mwaanie o ha'a-ha'arongoa nga iini aana nga taa e rau. Ta'e o ke oodo mola i saana mo pris hunie kire ke saie uri sapemu e mola oto. Na o ke niie uuraa'inge hunie a God mala mo Ha'atolanga a Mosis e unue. Urine ahutana mwala kire ke si meni saie uri sapemu e mola oto.” ");
INSERT INTO apb_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Ta'e a mwaena e lae ta'au ngeena na ko aehota taroha'inie oto hailiu. Na aena ko tohungei ere hiito'o i sulie leune, oto hule aana a Jisas e ka'a sai lae haada'i ike lo'u takoie nga huilume. A Jisas e lae mola aana mo henuesala nge nga mwala ha'ike aani, na mwala kire ko si lae mola mai saana uure mwaanie ta'ena nga leu. ");
INSERT INTO apb_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Oto ngaeta mo hei dinge lo'u i puri, a Jisas e aaliho'i lo'u hunie huilume i Kapaneam. Aana maholo e hule wau, oto tataroha aana e taro hailiu uri e hule lo'u weu i nume. ");
INSERT INTO apb_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Na mwala hunge kire loko mai saana, oto hule aana nga leu ni uure aana ha'ike lo'u, ma'alana po'oi sinaha. Oto a Jisas ko si lalado nada aana mei wala diana. ");
INSERT INTO apb_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Na maholona e hai mwane kire aanga'inie mwane e rarasi, kire ko hule oto pe'ie i nume. ");
INSERT INTO apb_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Ta'e kire dau pu'ota'inie uri kire kei lae wau pe'ie i saana Jisas uri taa, i sulie mwala kire hunge. Oto kire hane pe'ie ta'i koluhana nume, na kire hoka talana ta'i lengi, kire si uukue pe'ie hulite ingeie hai saana a Jisas. ");
INSERT INTO apb_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Na a Jisas mone e saie mola kire hiiwalaimoli aana, oto ko te'uri hunie mwane nge e rarasi ngeena, “Kaleku, mo ooraha'aa i'oe sae'aasileni e lae oto mwaani'o.” ");
INSERT INTO apb_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Ta'e aana maholona ngaeta mo ha'a-uusuli aana mo Ha'atolanga a Mosis kire ii'o no'one pe'ire. Oto kire ko tohungei ne'isae hiito'o i manatada uuri, ");
INSERT INTO apb_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“!Ha'ike eena! ?A tei mwane ni ko ere tooha'inie uri ingeie e paine mala God ie? I sulie nga iini lo'u huni sae'aasie roro'anga ha'ike, ta'e a God mola ha'alaa.” ");
INSERT INTO apb_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Na lau-leu a Jisas ko saie oto maraana mo ne'isaenga ikire, oto ko si te'uri hunire, “?E ue nge omu ko lo'o-lo'onga'i oto hiito'o urine? ");
INSERT INTO apb_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Omu saie ka'u uri erenga ni mola e mwada'u na ta'ena nga iini e sai ere mola hunie mwane e rarasi ienini uuri, ‘Mo ooraha'aa i'oe sae'aasileni e lae oto.’ Na lo'u uuri, ‘!Ta'ela'i! O ke toolea hulite i'oe, na o ke lae-lae oto.’ Ta'e huni esuie e ro mei ne'isaenga ngeena kire aasa oto hiito'o hunie iinoni. ");
INSERT INTO apb_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Ta'e ineu, a Kale Ni Iinoni, ne kei esuie mola mei ola hunie omu ke lio saie uri ineu, nou to'o aana no'one nanamanga huni sae'aasi ooraha'aa mai aano i leu.” Oto a Jisas ko unue hunie mwane e rarasi ngeena uuri, ");
INSERT INTO apb_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“!Ta'ela'i! O ke toolea hulite i'oe na o ke lae-lae oto i nume i'oe.” ");
INSERT INTO apb_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Na oto lau-leu maholo kire ko to'o-to'omaaie ue, e ta'ela'i na e toolea hulite ingeie, na ko iisitaa oto mwaanie leune. Oto kire ko tohungei pangata'i, na kire ko soi ha'amanikulu'aa God, na kire ko te'uri, “!Emi ka'a leesie ike ue nga mei ola urine ke rau i na'o!” ");
INSERT INTO apb_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Oto a Jisas e he'i eeliho'i lo'u weu i reune Aasi I Kalili, na mwala hunge kire hule lo'u i saana, na ko aehota ere ni ha'ananaunge lo'u hunire. ");
INSERT INTO apb_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Na maholo e lae-lae ue, na ko leesie a Livae, kalena Alpeas, e ii'o aana leu ingeie huni susulu to'oha aana takis hunie aalahanga ni Rom. Oto a Jisas ko te'uri hunie, “O ke lulu i sulieu.” Oto a Livae e ta'ela'i, na ko lulu i sulie oto a Jisas. ");
INSERT INTO apb_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Na mwala hunge aana mo iini kire unue ikire mwala ooraha'aa, na mo mwane susulu to'oha aana takis, kire ko lae i sulie a Jisas. Oto maholo a Jisas e lai ii'o i nume a Livae huni ngeu pe'ie, mwala hunge no'one urine kire loko wau, na kire ko ngeu pe'ie a Jisas na mo pwaarongoisuli ingeie. ");
INSERT INTO apb_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Oto ngaeta mo ha'a-uusuli aana mo Ha'atolanga a Mosis kire leesie a Jisas ko ngeu pe'ie mwalana, oto kire ko upwesie mo pwaarongoisuli ingeie uuri, “?E ue nge a Jisas ko ngeu na ko inu pe'ie mo iinoni ooraha'aala mala mo mwane susulu to'oha ngeena?” ");
INSERT INTO apb_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Maholo a Jisas e rongo, oto ko te'uri hunire, “Iinoni nge e awaa mola sa'a saeto'o aana ike mwane kure-kure, ta'e iini nge ko maelaa'a ha'alaa. Aana nou lae mai huni haaraie mo iinoni ooraha'aa ke lulu i sulieu, na nou ka'a lae ike mai huni haaraie mo iini kire unue kire diana oto.” ");
INSERT INTO apb_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Maholona mo pwaarongoisuli a Jon na mo Parise kire ko oolongau. Oto ngaeta mwala kire lae mai saana a Jisas na kire ko dolosi aana uuri, “?E ue ka'u nge mo pwaarongoisuli a Jon na mo iini aana mo Parise kire ko oolongau, ta'e mo pwaarongoisuli i'oe ha'ike?” ");
INSERT INTO apb_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Oto a Jisas e aalamire ko te'uri, “?Mo malahune a poro haalu kire kei saehuu uri taa na kire ko ngeu-ngeu ue aana ngauhe ni ha'arurunge na a poro haalu e ii'o ue pe'ire? !E aasa! Maholo poro haalu ko ii'o pe'ire, kire sa'a oolongau ike. ");
INSERT INTO apb_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Ta'e kei hule aana hai dinge nge kire kei toolea poro haalu mwaanire, nge kire ke si oolongau taane.” ");
INSERT INTO apb_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Oto a Jisas ko he'i unue lo'u mei wala ni aalahuunge ie i sulie ha'a-uusulinge haalu ingeie hunire uuri, “Nga iini e sa'a lo'amenaa ike nga to'oni lalahu'e aana nga mei lo'amena haalu. Aana maholo ko hodalie, nge mei lo'amena haalu ngeena kei mwai-mwei na kei hakasie mola to'oni lalahu'e, oto ke si haka aaela lo'u mwaanie hola'ina'o. ");
INSERT INTO apb_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Na nga iini e sa'a ne'ie ike waen haalu i laona ho ate'a lalahu'e nge kire asuie aana te'e-te'ei nanikot. Aena aana mala kei esu urine aana, nge maholo waen haalu ngeena kei po'o, ate'a lalahu'e ngeena e sai a'ari na waen kei waeta'i oto. Ta'e waen haalu ke lae oto mola i laona ho ate'a haalu.” ");
INSERT INTO apb_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Oto aana ngaeta hai Dinge Maa'i Mo Jiu, a Jisas e liu i laona hohola aana ola mala kooni. Oto aana maholo kire ko lae ngeena, mo pwaarongoisuli ingeie kire ko aroa hue-huana mola huni ngeu'i. ");
INSERT INTO apb_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Oto mo Parise ko te'uri hunie, “!Ei, leesie ka'u! Mo pwaarongoisuli i'oe ko deu esunge mola aana Dinge Maa'i ikie, mei ola e aapu aana Ha'atolanga a Mosis.” ");
INSERT INTO apb_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Oto a Jisas ko aalamire ko te'uri, “Omu saie taane nga taa nge a Deved Inemauri e asuie, aana maholo ingeie na ngaeta mo iini lo'u pe'ie kire hiolo. ?Ta'e e ue ni omu ka'a rongo saie ike ne'isaenga aana? ");
INSERT INTO apb_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Aana maholo a Abaeata ingeie Na'ohana Mo Na'ohai Pris, a Deved e lae sili i laona nume maa'i a God, na e ngaue ho bred maa'i, ola niilana e lae hunie a God. Ta'e mo Ha'atolanga a Mosis e unue e ka'a malisine ike ke ngaue, aana ta'e mo pris hali'ite kire sai ngaue taungei bred maa'i urine. Na a Deved e nii no'one ana mo iini kire lae pe'ie. Ta'e ma'alana e urine, a God e ka'a leie ike haahie.” ");
INSERT INTO apb_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Oto a Jisas e te'uri lo'u hunire, “A God e asuie Dinge Maa'i huni pe'ie mola iinoni, na iinoni ha'ike hunie Dinge Maa'i. ");
INSERT INTO apb_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Aena ngeena ineu a Kale Ni Iinoni oto nou aalaha haahie Dinge Maa'i.” ");
INSERT INTO apb_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Oto a Jisas e lae lo'u i laona nume ni palo-palo mo Jiu, na ngaeta mwane ingeie i leune ki'ine e heko. ");
INSERT INTO apb_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Oto ngaeta mo iini kire ko lio hunie ohe kei ha'a-uurie a mwaena aana Dinge Maa'i ikire, hunie kire ke ere aaelasie i laona leinge. ");
INSERT INTO apb_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Oto a Jisas ko te'uri hunie mwane ki'ine e heko ngeena, “O ke uure ka'u i na'ona mwala.” ");
INSERT INTO apb_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Oto e te'uri hunie mo iini kire ko upwesie ngeena, “?Nga taa ni Ha'atolanga ikolu e toli'aasie huni esuie aana Dinge Maa'i? ?Huni pe'ie iinoni wa huni waelie mola? ?Huni ha'a-uurie iinoni wa huni horo'ie?” Ta'e kire rohu mola, na nga iini ka'a ere ike. ");
INSERT INTO apb_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","A Jisas e saehuu i sulie saeda e hau, oto e to'omaaire mola pe'i saewasunge. Oto ko te'uri hunie a mwaena, “O ke lalaa'inie ki'imu.” Oto e lalaa'inie ki'ine, na e diana oto lo'u. ");
INSERT INTO apb_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Oto lau-leu mo Parise kire iisitaa, na kire lae oto i meni wala pe'ie ngaeta mwala aana pulitaa a Herod huni horo maesie a Jisas. ");
INSERT INTO apb_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Ta'e a Jisas na mo pwaarongoisuli ingeie kire lae wau hunie po'o ni eesi i Kalili. Na mwala hunge kire lae i sulie, uure oto mwaanie mo po'o ni henue i Kalili na i Jiudia ");
INSERT INTO apb_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","na i Idumea, na uure mwaanie i Jerusalem, na mwaanie po'o hao aana wai peine i Jodan, na uure no'one mwaanie mo huilume mo Aapoloa Aaopa i Taea na i Saedon. Na mwala hunge kire hule i saana Jisas i sulie kire rongoa tataroha aana mo ola ko esui'i. ");
INSERT INTO apb_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Na lokotaa e paine hiito'o mone, oto a Jisas e unue hunie mo pwaarongoisuli ingeie uri kire ke dau aakau aana nga iiola hunie, mwaanie mwala kire loko haahie. ");
INSERT INTO apb_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","I sulie a Jisas e ha'a-uurie mango mwala hunge, oto mo mae-maea'a hunge kire ko eri'apasie lo'u uri kire ke kopi mola aana. ");
INSERT INTO apb_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Na maholo mwala nge mo li'oa aaela nge aada kire leesie a Jisas, oto kire ko rapute'i oto i na'ona pe'i ngaranga uuri, “!I'oe oto Kalena God!” ");
INSERT INTO apb_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Ta'e a Jisas e ere honosire mwaanie kire ha'arongoa nga iini uri ingeie a tei. ");
INSERT INTO apb_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Oto a Jisas e soie ngaeta mo iini mai saana, na ko hanetaa lo'u ta'au i lengine toloi henue. ");
INSERT INTO apb_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Oto e lio hilisie aawala mwana rue mwaanie pulitaa ngeena hunie kire ke ne'ie mo hurula'aa ingeie. Oto e si ha'atolara hunie kire ke lai taroha'i, ");
INSERT INTO apb_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","na e niie hunire nanamanga huni oohe aasie mo li'oa aaela. ");
INSERT INTO apb_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Oto ie satana aawala mwana rue nge a Jisas e lio hilisire: A Saemon nge a Jisas e haara'inie lo'u aana a Pita, ");
INSERT INTO apb_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Na Jemes kalena Sebedi, na Jon aasine a Jemes, nge a Jisas e haara'inirerue mo Kalena Lou-lou i sulie kirerue sai saewasu lau-leu. ");
INSERT INTO apb_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Na Andru, na Pilip, na Batolomiu, na Matiu, na Tomas, na Jemes kalena Alpeas, na Tadeas, na Saemon ngaeta iini aana pulitaa nge ko sare haiseuni huni ta'aasie aalahanga ni Rom mwaanie hanue i Israel, ");
INSERT INTO apb_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","na Jiudas Iskariot nge e pweloa Jisas hunie mo maelonga ingeie. ");
INSERT INTO apb_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Mango urine, oto a Jisas e aaliho'i lo'u hai nume, na pulitaa paine e hule lo'u i saana. Oto a Jisas na mo pwaarongoisuli ingeie, nga maholo huni ngeunge na ha'ike lo'u. ");
INSERT INTO apb_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Oto aana maholo uluhe iinoni a Jisas kire rongoa urine, kire unue uuri, “Ko pweu oto to'ohuu.” Oto kire ko teule'i huni lae mai toolea lo'u i henue hunie kire ke lio i sulie oto wau. ");
INSERT INTO apb_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Maholo kire ka'a hule ue, na mo ha'a-uusuli aana mo Ha'atolanga a Mosis nge kire lae mai uure ta'au i Jerusalem, kire ko te'uri, “Aakalo paine haahie mo li'oa aaela, a Bielsebul, ingeie oto aana. A Bielsebul ni ko niie nanamanga hunie huni oohe aasie mo li'oa aaela urine.” ");
INSERT INTO apb_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Oto a Jisas ko soire wau takoie, na ko ere ni aalahuunge uuri, “?Ohe a Satan kei ta'aasie lo'u a Satan? !E aasa! ");
INSERT INTO apb_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Ta'ena nga aalahanga kei oopa aani heiseuninge honosie maraana, nge kei na'onga oto. ");
INSERT INTO apb_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Na e urine lo'u mala nga uluhe ni iinoni kei oopara lo'u maraada, uluhe iinoni ngeena nge kei ei'aa oto. ");
INSERT INTO apb_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Na mala mo iini a Satan kire ta'ela'i honosire maraada, nge kire sa'a uure a'aila'a ike lo'u, ta'e kire kei ei'aa oto.” ");
INSERT INTO apb_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Na a Jisas ko he'i ere ni aalahuunge lo'u i sulie nanamanga ingeie e saka liutaa aana Satan, oto ko te'uri, “Nga mwane sa'a sili ike i laona nume ngaeta ramo hunie ke pelie to'o-to'olana, ta'e kei hola'i tapolie na kei pwesue, nge purine ke si toolea ahutana mo ola ingeie. ");
INSERT INTO apb_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“To'ohuu no ko unue huni'omu, a God e sai sae'aasie ta'ena nga ooraha'aa mo iinoni ko esui'i, hule aana e sai sae'aasie mo iini ko ere mwakata'inie. ");
INSERT INTO apb_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Ta'e iini ko ere mwakata'inie Li'oa Maa'i, nge sae'aasilana e sa'a lae ike oto oo'oo, aana e asuie mei ooraha'aa e ii'o huu.” ");
INSERT INTO apb_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","A Jisas e ere urine i sulie kire unue uuri, “Li'oa aaela nge aana.” ");
INSERT INTO apb_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Oto nikana pe'ie mo eesine mwane kire mani hute, kire hule na kire uure mola ta'i sinaha i sulie mwala hunge kire loko kali-kelie a Jisas. Oto kire ko ha'atolaa mei wala hunie, ");
INSERT INTO apb_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","kire ko te'uri, “!Lio ka'u! A nikemu na mo eesimu kire uure mola ta'i sinaha, na kire ko sare leesi'o.” ");
INSERT INTO apb_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Oto a Jisas ko aalamire uuri, “?A tei ni a nikeku, na kire a tei ni mo eesiku?” ");
INSERT INTO apb_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Oto ko lio wau hunie ahutana mwala kire ii'o kali-kelie, na ko te'uri, “I'omu oto mo nikeku na i'omu oto mo eesiku. ");
INSERT INTO apb_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Aena aana iini nge ko esuie nga taa e to'ohie saena God, ingeie oto aasiku na a nikeku.” ");
INSERT INTO apb_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Oto a Jisas ko aehota ha'a-uusuli lo'u i reune Aasi I Kalili, na aena aana mwala hunge kire loko, oto e ta'e i laona iiola wau i eesi. Oto ko ere ni ha'a-uusulinge hunie lokotaa paine wau i oone. ");
INSERT INTO apb_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","E ere ni ha'a-uusulinge hunire aana mo aalahuunge oto hunge i sulie maurihe, na ko te'uri hunire, ");
INSERT INTO apb_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Omu ke rongo ka'u. Ngaeta mwane au'esu hohola e o'o'o, oto ko lai hesie mo litei ola ingeie mala mo kooni. Hasinge ngeena ko lae mola aana tataa'inilana mo lite, ");
INSERT INTO apb_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","na maholo ko tatataa'inie mo litei ola hailiu i laona hohola ingeie, ngaeta mo litei iini eeni kire ko teke i reune tala. Oto mo menu kire loho mai, kire ko ngeu'i mola. ");
INSERT INTO apb_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Ngaeta mo litei iini kire ko teke i lengine mei heu-heue. Oto mo lite ngeena kire ko tolana pwito poi aena aana mei mwakano ngeena e ka'a pi'ola ike. ");
INSERT INTO apb_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Ta'e e hule aana maholo sato ko peine, oto sato ko madorohi'i oto hiito'o, na kire ko nunulu mola aena aana kire ka'a susu'imi ike hiito'o i aano. ");
INSERT INTO apb_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Ngaeta mo litei ola kire ko teke i matolana mo walo kau-keu. Oto kire ko pwito tararuru pe'ie mo walo kau-keu, ta'e mo walo kau-keu kire paine haahi'i nge kire ko si melusi'i mola. Oto kire ka'a hungu ike. ");
INSERT INTO apb_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Ta'e ngaeta mo litei ola kire teke i lengine mei mwakano diana. Kire lai pwito diana na kire hungu, nga mo iini kire hungu oolu aawala, na nga mo iini e oono aawala, na nga mo iini tangalau.” ");
INSERT INTO apb_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Oto a Jisas e si ere ooreta hunire uuri, “Mwaanie omu rorongo aasie mola mo wala ienini, ta'e omu ke lo'o-lo'onga'i diana i suli'i.” ");
INSERT INTO apb_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Na maholo a Jisas e ii'o maraana, oto aawalai pwaarongoisuli mwana rue ingeie pe'ie nga mo iini lo'u nge kire ko lulu i sulie, kire lae mai saana, na kire ko unue hunie uuri, “Melu saeto'o aana o ke ere luhesie mo aalahuunge i'oe ngeena.” ");
INSERT INTO apb_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Oto a Jisas ko te'uri hunire, “A God e lio hilisi'omu hunie omu ke saenanau aana walaimolinge mumuni aana Aalahanga a God, ta'e mo iini po'oi sinaha aana Aalahanga ingeie, nge mo ere-erenga ko lae mola hunire aani aalahuunge. ");
INSERT INTO apb_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Oto kire ko lio-lio ta'e kire ka'a lio saie, kire ko rorongo ta'e kire ka'a rongo saie ike, aena aana kire kei te'urine, nge kire kei oonisae na a God kei ta'aasie mo ooraha'aa ikire.” ");
INSERT INTO apb_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Oto a Jisas ko dolosi aada uuri, “?Uri omu ka'a saie ike aalahuunge ie? ?Mala uri omu ka'a saie ike aalahuunge ie, ha'alaa omu ke si saie ngaeta mo aalahuunge lo'u uri taa eena? ");
INSERT INTO apb_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Mwane hai-hesi e hasie walana a God. ");
INSERT INTO apb_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Tala nge mo lite ngeena kire teke i sulie e urihana mo iini nge kire rongoa taane mo wala. Ta'e e ka'a tewa na a Satan e lae mai, ko ta'aasie oto mo wala diana ngeena mwaanie manatada. ");
INSERT INTO apb_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Na mo iini nge manatada e urihana mei mwakano hau-heue ngeena, kire rongoa walana God, na oto lau-leu kire ilenimwa'e haahie. ");
INSERT INTO apb_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Ta'e e ka'a susu'imi diana ike mone i manatada, oto e sa'a ii'o tewa ike. Maholo si'oha'anga kei toolera wa taunge'inilada kei lae i tehula'ana mei wala ngeena, oto kire ko tolana mamalo oto mwaanie. ");
INSERT INTO apb_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Nga mo iini lo'u manatada e urihana mei mwakano e honu aana walo kau-keu ngeena, kire rongoa no'one walana God, ");
INSERT INTO apb_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","ta'e kire ne'isae painesie mola mau-meuringe aana walumalau. Kire tolahi'e, na kire saeto'o aana mola to'o-to'onga, na kire ko saehanalie ta'ena nga ola. Oto mo wala diana ngeena kire ka'a pwito kohi, na kire ka'a hungu ike lo'u. ");
INSERT INTO apb_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Ta'e mo iini lo'u, mo iini urihana mei mwakano diana ngeena, kire rongoa mo wala ngeena, oto kire lulu i suli'i. Oto kire hungu diana oto eena, mo iini oolu aawala, na nga mo iini oono aawala, na nga mo iini tangalau.” ");
INSERT INTO apb_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Oto a Jisas ko he'i te'uri lo'u hunire, “?Uri nga iini kei toolea mai laite oto ko mumunie mola i hahana hulite wa ke pwaoha'inie nga nime haahie? !Ha'ike! Ta'e kei ne'i haada'i mola aana ta'au i lengi. ");
INSERT INTO apb_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Na ta'ena nga mei ola mumunilana ko lae-lae, haata'inilana kei saronai lae taane mai haada'i aana leu matapwa. Na nga taa nge aaluhilana ko lae-lae, aelilana kei saronai lae taane mai haada'i huni leesie. ");
INSERT INTO apb_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Mwaanie omu rorongo aasie mola mo wala ienini, ta'e omu ke lo'o-lo'onga'i diana i suli'i.” ");
INSERT INTO apb_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Oto a Jisas ko he'i te'uri lo'u hunire, “Hele ma'uta'a aana nga taa o ko rongoa, i sulie ta'a-ta'a totoho nge o ko totohoa nga iini aana, ingeie nge a God kei he'i totoho'o lo'u aana, ta'e kei totoho'o oto lo'u liutaa. ");
INSERT INTO apb_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Aana ta'ena nga iini e mwa'e-mwa'e huni rongo i sulie mo ha'a-uusulinge ineu, nge sapeilana saenanaunge ni Lengi kei lae lo'u hunie. Ta'e a tei nge e ka'a mwa'e-mwa'e huni rongo i sulie mo ha'a-uusulinge ineu, nge ma'alana uri nga kele mei saenanaunge ni Lengi e to'o aana, ta'e ta'aasilana kei lae mola mwaanie.” ");
INSERT INTO apb_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Oto a Jisas ko he'i unue lo'u uuri, “Aalahanga a God e urihana maholo mwane e hasie mo lite i laona hohola ingeie. ");
INSERT INTO apb_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Oto ma'alana e ka'a da lo'u nga mei ola ta'e ko ma'ahu mola aana rodo, wa e ta'ela'i i aatowaa, ta'e mo lite nge e hasi'i ngeena kire ko pwito mola maraani. A mwaena ka'a saie ike no'one e ue nge mo lite ngeena kire sai pwito urine. ");
INSERT INTO apb_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Mei ola ngeena, mwakano ni mola ko da mo lite ngeena ko pwito urine na kire ke hungu. Kire kei hola'i ure, oto ko he'i taka lo'u, na purine e taka mango kolu ko leesie oto ko to'o hue-huana eena. ");
INSERT INTO apb_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Oto maholo hue-huana ko repo oto, nge a mwaena ko si aehota tapali'i oto aana naihi ingeie eena, aana kire repo oto na e hule oto aana maholo huni'i.” ");
INSERT INTO apb_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Oto a Jisas ko dolosi uuri, “?Nga taa ni kolu kei unu ha'amalaa Aalahanga God aana? ?Wa nga mei aalahuunge uri taa ni kolu kei unue huni ere luhesie? ");
INSERT INTO apb_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","E urihana kele litei ola oto mwai-mwei aana ai mastad. Ma'alana e mwai-mwei liutaa aana ahutana mo lite kolu ko hei-hesi'i, ");
INSERT INTO apb_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","ta'e maholo hasilana ko lae, oto ko pwito poi na ko peine oto liutaa aana ta'ena nga ola i laona hohola. Ko peine ngeena, oto ko aatosara hailiu, nge ahutana manu kire ko meni lae mai tola niu'i aana.” ");
INSERT INTO apb_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","A Jisas e asuie mo laladonga hunge uurini huni ha'a-uusulie mwala aani i sulie walana a God. E asuie mo laladonga maliside hunie kire ke saenanau aana ahutana mo ne'isaenga nge kire sai rongo sai'i. ");
INSERT INTO apb_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","E ere-ere ngeena aani aalahuunge hali'ite, ta'e maholo mo pwaarongoisuli kire ko ii'o maraada pe'ie a Jisas, nge e sai ere luhesie ahutana mo aalahuunge hunire. ");
INSERT INTO apb_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Oto i seulehi aana hai dingena, a Jisas ko te'uri hunie mo pwaarongoisuli ingeie, “Kolu ke aatoholo ka'u lo'u hunie raune aasi po'o ta'au.” ");
INSERT INTO apb_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Oto kire lae mwaanie ruruhaa, na kire lai ta'e i laona iiola nge a Jisas e ii'o aana. Oto kire mani lae, na ngaeta mo iiola ko lae no'one pe'ire. ");
INSERT INTO apb_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","E ka'a tewa ike lo'u na paineha'ana mawasidengi ko hite aada oto. Na aahe ko aehota aa'aro oto i laona iiola, hule aana ko kara'i honu oto aana aasi. ");
INSERT INTO apb_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Ta'e a Jisas e eno mola hai puri aana iiola, e pwaulunge aana ho uulunge aana ko ma'ahu. Oto mo pwaarongoisuli ingeie kire ko ha'alioa na kire ko te'uri, “?Ha'a-uusuli, ohe o ka'a aapwasu ike lo'u aana kolu ko kara'i mae oto ie?” ");
INSERT INTO apb_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Oto a Jisas e ta'e, ko ere aana ooru na aahe uuri, “!O ke rohu, na o ke hahuroto!” Oto ooru e rohu oto, na ko tolana hoolaa oto. ");
INSERT INTO apb_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Oto a Jisas ko te'uri hunie mo pwaarongoisuli ingeie, “?E ue ni oto omu ko me'u urine? ?Ohe omu ka'a to'o aana ike lo'u nga mei hiiwalaimolinge?” ");
INSERT INTO apb_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Ta'e kire ko tohungei me'u, na kire ko ere hunire hailiu uuri, “?A tei mwane ni ie? ?Oto hule aana e ere aana ooru na aahe, na kire ko rongo oto hunie?” ");
INSERT INTO apb_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","A Jisas na mo pwaarongoisuli ingeie kire lai aarapuu aana po'o ni eesi i Kalili po'o ta'au aana po'o ni henue mo Kerasa. ");
INSERT INTO apb_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Na maholo a Jisas e siho mai mwaanie iiola, na ngaeta mwane ko maau oto mai mwaanie mo kilipwe'u. Mwane ngeena li'oa aaela aana, ");
INSERT INTO apb_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","na ii'onga ingeie oto mola i saana mo kilipwe'u. Nga iini e sa'a hele aana, wa ke pwasue ma'alana aani walo wa aani iieli heu. ");
INSERT INTO apb_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Mo maholo hunge pwasulana ae'aena na ki'ine ko lae oto, ta'e ko mousi'i mola. Na nga iini ke a'aila'a hunie ke ha'amanata'aa, na ha'ike lo'u. ");
INSERT INTO apb_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Na oto tarau suli rodo na aatowaa, ingeie mola i sulie mo uuwo na mo kilipwe'u pe'i aawaranga na hunulana sapena mola aani ngedi. ");
INSERT INTO apb_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Na maholo e leesie a Jisas ue wau ha'atau, e huru mei i saana, na ko pouruuru oto i na'ona. ");
INSERT INTO apb_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Oto a Jisas ko te'uri hunie, “!I'oe, li'oa aaela, o ke iisitaa mai mwaanie mwane ngeena!” Oto a mwaena ko soi oto paine uuri, “!Ai Jisas, Kalena a God, iini e paine liutaa! ?Nga taa oto o kei esuie aaku? No ko eitanai'o aana satana God, o ke su'uri ha'aletehieu.” ");
INSERT INTO apb_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Oto a Jisas ko dolosi aana uuri, “?Satamu a tei?” A mwaena e aalamie oto ko te'uri, “Sataku a Hunge, aena aana emi hunge oto hiito'o i laona mwane ie.” ");
INSERT INTO apb_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Na ko eitanaie oto a Jisas uri ke su'uri uusunge'inire mwaanie hanuena. ");
INSERT INTO apb_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Na ola mala e ro sinolai poo kire ko susude i lengine uuwo oto po'o wau. ");
INSERT INTO apb_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Oto mo li'oa aaela ngeena ko eitanaie a Jisas uuri, “O ke toli'aasi'emi ke lae i laona amaa ni poo ta'aune hunie emi ke ii'o aani.” ");
INSERT INTO apb_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Maholo e toli'aasire, kire si iisitaa huni lai sili i laona mo poo. Oto amaa ni poo paine ngeena, kire mani loutaa pwau i aano i sulie uuwo, na kire ko lai pola tala oto aana mao'i hunie i eesi, na kire ko meni inu oto. ");
INSERT INTO apb_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Oto mwala nge kire lio-lio i sulie mo poo ngeena kire tahi, na kire lai taroha'inie tataroha oto wau i laona huilume ikire na aana mo henue kali-kelie. Oto mwala kire huru hunie kire ke lai leesie nga taa e rau. ");
INSERT INTO apb_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Maholo kire lae mai i saana Jisas, kire ko meni me'u aana kire ko leesie mwane nge mo li'oa aaela e hite-hite aana, e ii'o i aano, na e ho'o sala, na manatana e taha oto. ");
INSERT INTO apb_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Na mo iini nge kire leesie nga taa e rau ngeena, kire unue oodoie mwala uri nga taa e rau aana mwane nge mo li'oa aaela e o'o'o aana, na aana mo poo. ");
INSERT INTO apb_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Oto kire ko eitanaie mola a Jisas hunie ke lae oto mwaanie po'o ni henue ikire. ");
INSERT INTO apb_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Oto maholo a Jisas ko ta'e i laona iiola, na mwane nge mo li'oa aaela e iisitaa mwaanie ngeena ko eitanaie a Jisas uri ke hakusie. ");
INSERT INTO apb_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Ta'e a Jisas e ka'a toli'aasie ike. E unue mola hunie uuri, “O ke aaliho'i mola i saana uluhe i'oe na o ke ha'arongora aana walu ola diana nge a God e asui'i huni'o aana e tohungei aamasi'o.” ");
INSERT INTO apb_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Oto a mwaena e aaliho'i mola, na e laehie ahutana mo huilume aana po'o ni henue i Dekapolis pe'i taroha'inie mei ola paine ngeena a Jisas e asuie hunie. Na ahutana mwala kire ko si meni pangata'inie oto hiito'o. ");
INSERT INTO apb_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Oto a Jisas e aatoholo aaliho'i lo'u aana iiola hunie po'o ni eesi ta'au. E si siho mola i reune aasi i leune, na mwala oto hunge kire loko oto mai kali-kelie. ");
INSERT INTO apb_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Na aana maholona, ngaeta na'ohai mwane paine aana nume ni palo-palo, satana a Jaeras, e hule no'one. Maholo e leesie a Jisas, e pouruuru oto i na'ona, ");
INSERT INTO apb_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","na ko eitanaie uuri, “Kele pule kaleku e eno oto hunie maenga. No ko eitanai'o hunie o ke lae mai hele aana hunie ke awaa na ke mauri.” ");
INSERT INTO apb_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Oto a Jisas e lae oto pe'ie, na mwala hunge kire ko lae i sulie oto pe'i uusule'inire hailiu. ");
INSERT INTO apb_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Na ngaeta keni i leune, apu raha-raha ko seunie oto hunie aawalai helisi mwana rue. ");
INSERT INTO apb_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","A keine ko lae oto i saana mwala kure-kure hunge, ta'e hunie uri ke awaa mola ha'ike. Na e waiahea tari-olanga ingeie aana e holi-holi talana, ta'e nga mei ola hunie ke to'o hoorana ha'ike, ko si peine mola. ");
INSERT INTO apb_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Maholo a keine e rongo tarohana a Jisas, oto e lae liu i purine mola i matolana mwala, na e kopi aana to'oni a Jisas. ");
INSERT INTO apb_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Aana e lo'onga'inie uuri, “Mala ne ke kopi mola aana to'oni ingeie, na ne kei awaa oto.” ");
INSERT INTO apb_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Na maholo a keine e kopi aana to'oni a Jisas, oto apu raha-raha ngeena e mango oto mwaanie aana maholona, na e hiinge'inie uri e awaa oto ta'ingelu. ");
INSERT INTO apb_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Na a Jisas, oto lau-leu e hiinge'inie maraana uri nanamanga ingeie e ha'a-uurie nga iini, oto e aali'u ko te'uri, “?A tei e kopi aana to'oni ineu?” ");
INSERT INTO apb_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Oto mo pwaarongoisuli ingeie ko te'uri hunie, “!Lio ka'u! Ahutana mwala ko meni uusule'ini'o. ?Aana e ue nge o ko dolosie uri a tei e kopi aana to'oni i'oe?” ");
INSERT INTO apb_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Ta'e a Jisas ko lio hailiu mola huni leesie uri a tei nge e kopi aana to'oni ingeie. ");
INSERT INTO apb_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","A keita'aa ko si tohungei me'u oto na ko eriri i sulie e saie uri ingeie oto mei olana e rau aana. Oto e lae mai, ko pouruuru i na'ona a Jisas, na ko unue oodoie nga taa nge e rau aana. ");
INSERT INTO apb_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Oto a Jisas ko te'uri hunie, “Kaleku, hiiwalaimolinge i'oe e ha'a-uuri'o oto. O awaa oto mwaanie mei maelaa ngeena. Lae mola aani henuelamanga.” ");
INSERT INTO apb_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Na maholo a Jisas ko ere-ere ue urine, ngaeta mo iini kire lae mai uure mwaanie nume a Jaeras, kire ko te'uri hunie a Jaeras, “Kele pule i'oe e mae oto. O ke su'uri ha'aweoa lo'u a Ha'a-uusuli.” ");
INSERT INTO apb_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","A Jisas e rongoa mola nga taa kire ko unue, ta'e e unue mola hunie a Jaeras uuri, “O ke su'uri tolahi'e, ta'e o ke hiiwalaimoli mola aaku.” ");
INSERT INTO apb_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Oto a Jisas e ka'a toli'aasie ike lo'u nga iini aaopa hunie ke lae pe'ie, ta'e a Pita mola hali'ite, na a Jemes, na a Jon aasine a Jemes. ");
INSERT INTO apb_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Na maholo kire hule oto aana nume a Jaeras, na a Jisas ko leesie mwala hunge kire ko e'engo i leune na nga mo iini ko ngara-ngara na uulo-uulo oto paine. ");
INSERT INTO apb_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Oto maholo a Jisas e sili hao i laona nume, ko te'uri hunire, “?E ue ni omu ko e'engo na omu ko ngara-ngara urine? Kele pule ie ka'a mae ike, ta'e ko ma'ahu mola.” ");
INSERT INTO apb_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Ta'e kire ko mwesi mola mwaanie, na kire ko ha'a-eero mola aana. Oto a Jisas e oohe aasire i sinaha, e si toolea aamana pulena na nikana, na oolu pwaarongoisuli ingeie, kire ko si lae i laona duru nge a pulena e ii'o aana. ");
INSERT INTO apb_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","42","A pulena e hule oto aana aawalai helisi mwana rue, na a Jisas e hele i nimana, ko si te'uri hunie aana erenga ni Jiu, “Talitha, koum.” Lo'onga'inge aana uuri, “Kele pule, no ko unue huni'o o ke ta'ela'i oto.” Na oto lau-leu a pulena e ta'ela'i, ko lae hailiu oto. Oto maholo kire leesie urine, kire ko si tohungei pangata'i oto hiito'o. ");
INSERT INTO apb_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Ta'e a Jisas e si ere honosire uuri, “Omu ke su'uri ha'arongoa lo'u nga iini aana leune.” Na ko he'i unue lo'u uuri, “Omu ke nii ngeulaa mola ana.” ");
INSERT INTO apb_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Oto a Jisas e uure mwaanie i leune, e si eeliho'i hunie huilume nge e paine ta'e aana, na mo pwaarongoisuli ingeie kire lae no'one pe'ie. ");
INSERT INTO apb_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Na maholo e hule aana Dinge Maa'i Mo Jiu, oto a Jisas ko aehota ha'a-uusuli lo'u i laona nume ni palo-palo. Na mwala hunge kire loko hunie kire ke pwaarongo i sulie mo ha'a-uusulinge ingeie. Oto maholo kire rongoa mo ha'a-uusulinge a Jisas, kire ko tohungei pangata'i na kire ko te'uri, “!Ha'ike eena! ?Uri a mwane ngeena e saie ka'u walu ola ngeena uri taa? ?Na a tei ni e niie saenanaunge ngeena hunie? ?Na e to'o aana nanamanga huni esuie mo hu'i-hu'ite paine ngeena uri taa?” ");
INSERT INTO apb_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Na lau-leu kire ko upwesie lo'u mola uuri, “Kolu meni saie mola uri ingeie mwane aadu-eedu mola ni ngeena. Nikana ka'u mola a Meri, na mo eesine kire mani hute ka'u mola a Jemes, na a Josep, na a Jiudas, na a Saemon. Mo eesine keni ka'u no'one mola i leu pe'ikolu.” Oto kire ko si mola. ");
INSERT INTO apb_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","6","Oto a Jisas e pangata'i aena aana kire ka'a hiiwalaimoli ike aana, na ko te'uri hunire, “Ahutana mwala kire sai ha'ama'u taane aana nga propet. Ta'e mwala oto aana hanue ingeie na mo tekihana na mo iini aana nume ingeie maraana ha'alaa kire sa'a ha'ama'u ike aana.” Oto i leune e ka'a asuie ike nga mo hu'i-hu'ite hiito'o, ta'e e ha'a-uurie mola toota'i iini i leune aana mo iini ko mweri. Oto a Jisas e laehie lo'u mo huilume hailiu, pe'i ha'a-uusulie mo iinoni. ");
INSERT INTO apb_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","E soie mai aawalai pwaarongoisuli mwana rue ingeie, oto e uusunge'inire hailiu, to'o ro mwane aani henue. Na e niie nanamanga e saka hunire hunie kire ke oohe aasie ahutana mo li'oa aaela. ");
INSERT INTO apb_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","9","Na ko hatonga'i hunire uuri, “Omu ke su'uri toolea nga mo ola pe'i'omu aana laenga i'omu ienini, ma'alana nga mei ngeulaa, wa nga mwa'i, wa nga mei to'oha, wa ruana nga to'oni, na su'uri lo'u. Ta'e apa'a na ho'ohaahi'ae nge omu ko lae-lae aani mola hali'ite. ");
INSERT INTO apb_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","“Oto ta'ena nga nume omu ko lai sili aana, aana ta'ena nga hanue, omu ke ii'o ka'u i leune lai hule aana omu kei lae mwaanie hanuena. ");
INSERT INTO apb_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Mala uri nga hanue omu ko lai aarapuu aana na mwala ka'a soi koni'omu, wa kire ke sare rongo huni'omu, nge omu ke lae mwaanie hanuena, na omu ke tataa'inie mo wasa-wasa mwaanie ae'aemiu, domana uri nga ha'apasunge hunire uri a God kei ha'aloire.” ");
INSERT INTO apb_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Oto mo pwaarongoisuli kire ko lae oto i taroha'inie oodoie mwala uri kire ke oonisae na aali'u oto mwaanie mo ooraha'aa ikire. ");
INSERT INTO apb_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Na kire oohe aasie mo li'oa aaela hunge, na kire suuhie mo mae-maea'a aani rumu na kire ha'a-uurire oto. ");
INSERT INTO apb_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Oto a Herod Antipas Inemauri e rongoa tataroha aana a Jisas aena aana tataroha aana ko taro hailiu. Ngaeta mwala ko unue uuri, “A Jon Loto Maa'i ni oto e mauri lo'u ie, ka'u e to'o aana nanamanga huni esuie mo hu'i-hu'ite urine.” ");
INSERT INTO apb_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Ngaeta mo iini ko unue lo'u uuri, “A Elaeja oto ni ngeena.” Ngaeta mo iini lo'u kire ko unue uuri, “Ingeie ngaeta propet mala mo iini oto i na'o ni ngeena.” ");
INSERT INTO apb_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Oto a Herod e rongoa tataroha aana, ko si te'uri, “A Jon Loto Maa'i nge nou lama mousie ka'u pwaune ni ngeena, ta'e e mauri lo'u.” ");
INSERT INTO apb_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","A Herod oto maraana nge e unue hunie mo ramo ingeie uri kire ke pwasue a Jon Loto Maa'i na kire ke ne'ie i laona nume ni ho'o. E te'urine aena aana a Jon e ere aana Herod haahie e to'o aana a Herodias, hu'e a Pilip mwane aasine, ");
INSERT INTO apb_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","aana a Jon e ere uuri hunie, “O waelie oto ha'atolanga aana o to'o aana hu'e mwane aasimu.” ");
INSERT INTO apb_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Oto aena ngeena a Herodias e saewasulie a Jon, na e sare horo maesie oto. Ta'e e aasa ");
INSERT INTO apb_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","i sulie a Herod e ma'ute'inie a Jon, aena aana e saie uri a Jon mwane oodota'i na mwane maa'i. Oto a Herod e kineta'inie a Jon i laona nume ni ho'o, na e rorongo hunie. Maholo ko rongoa walana a Jon, manatana e rodohono mola ta'e ma'alana e urine ko sare rongo mola hunie. ");
INSERT INTO apb_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Oto lae-lae a Herodias e si lio oodoie tala huni horo'ie a Jon Loto Maa'i, na e lae oto uuri. E hule aana maholo ni aamasito'o aana dinge a Herod e hute, oto e asuie ngauhe paine huni ngeu pe'ie mo mwane paine aana aalahanga, na mo na'ohai ramo aana mae ingeie, na ahutana oto mo aalaha haahie po'o ni henue i Kalili. ");
INSERT INTO apb_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Oto keni haalu kalena Herodias e lae mai mao nada, na e tohungei to'ohie manatana a Herod na mo mwane paine. Oto a Herod Inemauri ko te'uri hunie a keine, “?Nga taa o ko saeto'o aana? Sukaa mola aaku na nou sai niie mola huni'o.” ");
INSERT INTO apb_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Na ko he'i heiholota'i lo'u hunie uuri, “Nou sai niie mola nga taa o kei sukaa ma'alana nga mei ola oto paine mala nga aapa aana aalahanga ineu.” ");
INSERT INTO apb_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Oto a keine e iisitaa i sinaha, ko si dolosi aana a nikana uuri, “?Nga taa nge ne kei sukaa?” Oto a nikana ko te'uri hunie, “O ke sukaa pwaune a Jon Loto Maa'i.” ");
INSERT INTO apb_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Oto a keine ko huru oto lau-leu i saana inemauri, na ko te'uri hunie, “Nou saeto'o aana o ke niie oto mai pwaune a Jon Loto Maa'i hunieu i laona nga nime.” ");
INSERT INTO apb_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","A inemauri ko tohungei saehuu oto hiito'o. Ta'e aana e haiholota'i i na'ona mo mwane paine nge ko ngeu pe'ie, oto e ka'a sare unue ha'ike aana nga taa a keine e sukaa. ");
INSERT INTO apb_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Oto a inemauri e uusunge'inie mola lau-leu ngaeta ramo hunie ke lai toolea pwaune a Jon. Oto ramo ngeena e lae i laona nume ni ho'o, na e lama mousie oto pwaune a Jon. ");
INSERT INTO apb_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Oto e ne'ie i laona nime, e si toolea, ko lai niie hunie a keine. Oto a keine e toolea, ko lai niie hunie a nikana. ");
INSERT INTO apb_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Oto maholo mo pwaarongoisuli a Jon kire rongoa nga taa e raune, oto kire lai toolea rae aana a Jon, kire si lai heitolinge'inie. ");
INSERT INTO apb_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Oto mo hurula'aa kire mani ooli mei saana Jisas, na kire ko ha'arongoa aana walu ola kire asui'i, na ha'a-uusulinge kire asuie hunie mwala e lae uri taa. ");
INSERT INTO apb_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Ta'e mwala hunge kire ko talei lae hailiu mola wau na mai, oto hule aana nga maholo huni ngeu ikire na ha'ike lo'u. Oto a Jisas ko te'uri hunire, “Kolu ke lae ka'u aana nga leu mwala ha'ike aana hunie kolu ke mamalo nga kele maholo o'oru'e.” ");
INSERT INTO apb_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Oto kire si lae maraada aana iiola takoie leu nga mo iinoni ha'ike aana. ");
INSERT INTO apb_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Ta'e mwala hunge kire leesie mola kire ko lae ngeena, na kire saire mola. Oto mwala ngeena kire uure mola mwaanie mo huilume ikire, na kire huru i sulie tala takoie leu a Jisas ko lae hunie. Na kire ko hola'i hule mola ta'au i na'ona a Jisas na mo pwaarongoisuli ingeie. ");
INSERT INTO apb_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Oto maholo a Jisas e siho mai oone mwaanie iiola, na ko leesie mwala hunge e loko, ko si aamasire aana kire lio si'oha'a mala amaa ni sipu nge nga iini huni lio i suli'i ha'ike. Oto e aehota huni ha'a-uusulire aana mo ne'isaenga hunge. ");
INSERT INTO apb_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Oto maholo kara'inie sato kei suu, mo pwaarongoisuli ingeie kire lae mai saana, oto kire ko te'uri hunie, “Ko seulehi oto na ikolu i laona hanuesala ni ie. ");
INSERT INTO apb_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Oto o ke uusunge'inie mwala ngeena hunie kire ke lae aana mo henue hailiu huni holi ngeulaa ada.” ");
INSERT INTO apb_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Oto a Jisas ko aalamire uuri, “I'omu, omu ke nii ngeulaa mola ada.” Oto kire ko he'i te'uri lo'u hunie, “!Ha'ike eena! Holitana nga mwane hunie walu waro-waro ka'a adona ike lokotaa paine ngeena kire kei oa ho ngeulaa nga iini. ?Uri o saeto'o aana emi ke waeta'inie mei to'oha oto paine urine aani ngeulaa hunire?” ");
INSERT INTO apb_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Oto a Jisas ko he'i dolosi lo'u aada uuri, “?E nite ho bred omu to'o aani? Omu lae ka'u i leesi'i.” Oto kire lae, na maholo kire lio oodoi'i, oto kire ko lae mai unue uuri, “Melu to'o aana mola e lime aata ho bred na e ro kele ho ii'e.” ");
INSERT INTO apb_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Oto a Jisas ko unue hunie mo pwaarongoisuli ingeie uri kire ke oopaa mwala hunie kire ke ii'o aani pulitaa i laona hahalisi. ");
INSERT INTO apb_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Oto mwalana kire ii'o tatalaa'i i aano aani pulitaa. Ngaeta mo pulitaa kire hule aana tangalau na ngaeta mo iini kire hule aana e lime aawala. ");
INSERT INTO apb_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Oto a Jisas e hele aana lime ho bred ngeena na e ro ho ii'e, oto ko si lio i lengi, na ko paalahea a God. Oto e nisie mo ho bred ngeena, ko si nii'i hunie mo pwaarongoisuli ingeie hunie kire ke ha'a-adoa mwala aani. Na e te'urine no'one aana e ro ho ii'e hunie ahutada mango. ");
INSERT INTO apb_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Oto ahutana mwala kire mani ngeu pote, ");
INSERT INTO apb_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","na i purine kire ngau mango, mo pwaarongoisuli ko si ha'ahonue aawalai lu'e mwana rue aana mo ooretai ngeulaa. ");
INSERT INTO apb_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Oto iidumilana mo mwane hali'ite nge ha'angaulada e lae, e hule aana e lime sinolai mwane. ");
INSERT INTO apb_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Na oto mola lau-leu no'one aana maholona, a Jisas e unue hunie mo pwaarongoisuli ingeie uri kire ke ta'e i laona iiola na kire ke hola'i lae i na'o loosie aana po'o ni eesi po'o ta'au hatarie huilume i Betsaeda. Oto ingeie maraana ko oore ue i puri huni uusunge'inie mwala aaliho'i takoie mo henue ikire. ");
INSERT INTO apb_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","I purine e uusunge'inie mwala takoie mo henue ikire, nge e si hanetaa maraana ta'au i lengine uuwo huni aarenga'i. ");
INSERT INTO apb_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Maholo na ko seulehi rorodo'a oto, mo pwaarongoisuli ikire mola ue wau i denumana aasi aana iiola, na a Jisas mola maraana ta'au i lengine uuwo. ");
INSERT INTO apb_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Na e leesie mo pwaarongoisuli ingeie kire ko tohungei ha'aweora oto hiito'o huni hotela'inie iiola suehie ooru. Oto maholo na ko hatari dengi oto, a Jisas ko lae oto mai saada, na ko lae mola mai kolune aasi, ko ne'isae huni liu mola mai kara'inire. ");
INSERT INTO apb_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Ta'e maholo kire leesie ko lae mai kolune aasi, oto kire ko lo'onga'i uri nga aakalo, na kire ko meni aawara oto paine. ");
INSERT INTO apb_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Kire ko tohungei me'u oto hiito'o aana maholo kire leesie. Ta'e a Jisas ko tolana ere oto wau pe'ire uuri, “Saemiu ke hahuroto. Ineu taane mola ni ie. Mwaanie omu me'u-me'u.” ");
INSERT INTO apb_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Na ko lai hane oto wau i laona iiola. Oto maholona ooru ko tolana aapwana'i oto. Oto mo pwaarongoisuli ko tohungei pangata'i oto hiito'o, ");
INSERT INTO apb_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","aena aana kire ka'a lio saie ike ne'isaenga aana hu'i-hu'ite nge a Jisas e si esuie aana mo ngeulaa ngeena, aana manatada e ka'a taha ue. ");
INSERT INTO apb_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Maholo kire aatoholo hunie po'o ni eesi po'o wau, oto kire aarapuu aana po'o ni henue i Kenesaret, na kire pwasue iiola ikire oto i leune. ");
INSERT INTO apb_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Maholo kire siho mola mai mwaanie iiola, na ahutana mwala ko meni lio saie oto a Jisas. ");
INSERT INTO apb_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Oto kire ko huru heiliu oto i laona mo huilume aana po'o ni henuena, na kire ko toolea oto mai mo mae-maea'a aana mo hulite ikire takoie mo leu nge kire ko rongoa a Jisas e ii'o aani. ");
INSERT INTO apb_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Na ahutana mo leu nge a Jisas ko lae aani mala mo henue paine wa mo huilume wa ngaeta mo leu lo'u, mwala kire ko ha'a-enohie mo mae-maea'a i laona mo amaa aana mo henue huni maa'oohie. Oto kire ko eitanaie uri hunie kire ke kopi mola aana ta'ena nga leu aana to'oni ingeie. Na ahutana mo iini kire kopi aana, kire awaa oto. ");
INSERT INTO apb_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Oto ngaeta mo Parise na mo ha'a-uusuli aana mo Ha'atolanga a Mosis kire uure mwaanie i Jerusalem huni lae mai saana a Jisas. ");
INSERT INTO apb_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Na aana maholona kire ko leesie uri mo pwaarongoisuli a Jisas kire ka'a hodalie ki'ide i sulie taungei hoda-ki'inge nge mo Parise kire saeto'o aana mo iinoni ke hele i sulie i na'ona ngaunge. ");
INSERT INTO apb_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Mo Parise na ahutana oto mo Jiu, kire ko lulu i sulie ha'atolanga ngeena uure oto wau aana mo weuwada, nge kire sa'a ngau na kire ka'a asuie taungei hoda-ki'inge kire unue e diana. ");
INSERT INTO apb_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Aana maholo kire ko lae mai uure mwaanie uusi'e, kire sa'a sare ngau ike ue na kire ka'a hodalie ki'ide. Na mo ha'atolanga hunge kire ko lulu i suli'i uure oto wau aana mo weuwada i sulie hoda-olanga aana mo kuki, na mo nime, na mo iini huni hoda-hoda ola, na mo taetahe huni ngeu-ngeu i lengini. ");
INSERT INTO apb_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Oto mo Parise na mo ha'a-uusuli aana mo Ha'atolanga kire ko dolosi aana a Jisas uuri, “?Aana e ue ni mo pwaarongoisuli i'oe kire ka'a lulu i sulie ike ha'atolanga mo weuwaka kire ha'a-uuresie? Lio ka'u, kire ko ngeu mola na kire ka'a hola'i hodalie ki'ide, na urine kire mada'a i maana God.” ");
INSERT INTO apb_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Oto a Jisas ko aalamire uuri, “Walana a God nge a Aesaea e uusue i suli'omu e to'ohuu oto. I'omu mwala omu ko lupwe'i deu-deu mola oto mala e uusue. Aana a God e unue uuri, Mwala ie kire ko ha'ama'u eeku mola aana ngidude, ta'e manatada e ha'atau hiito'o mola mwaanieu. ");
INSERT INTO apb_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Mwala ngeena kire ka'a palo-paloau ike to'ohuu. Kire ko esuie mola mo ha'atolanga ikire maraada, na kire ko ha'a-uusulie mwala huni lulu i suli'i. Oto kire ko si unue uri mo ha'atolanga ineu eeni, ta'e ha'ike.” ");
INSERT INTO apb_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Oto a Jisas ko he'i te'uri lo'u hunire, “Omu toli'aasie mo Ha'atolanga a God, oto omu ko si lulu i sulie mola mo ha'a-uusulinge ni iinoni. ");
INSERT INTO apb_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Omu tohungei saenanau liutaa mola huni lae mwaanie mo Ha'atolanga a God, hunie omu ke lulu i sulie mo ha'atolanga i'omu maraamiu. ");
INSERT INTO apb_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Omu saie ka'u a Mosis e unue uuri, O ke ha'ama'u aana aamamu na nikemu. Na e he'i unue lo'u uuri, Nga iini nge kei ere aaelasie aamana wa nikana, nge horo'ilana kei lae. ");
INSERT INTO apb_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Ta'e i'omu, omu ko ha'a-uusuli mola uri mala nga iini ko to'o aana nga mei ola diana nge e sai niie huni pe'ie aamana na nikana, ta'e ko unue uuri, ‘Mei ola ngeena nou niie oto hunie a God,’ ");
INSERT INTO apb_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","urine ke su'uri ha'ama'u lo'u aana aamana na nikana pe'ie niilana mei olana hunire. ");
INSERT INTO apb_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Oto aana omu ko lae mola i sulie mo ha'a-uusulinge mo weuwemiu, nge e haata'inie uri omu ko mwakata'inie mola walana a God. Na mo ola oto hunge urine omu ko esui'i oto.” ");
INSERT INTO apb_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Oto a Jisas e he'i soie lo'u mwala i saana na ko te'uri hunire, “Omu ke pwaarongo diana aana nga taa ne kei unue hunie omu ke sai diana aana. ");
INSERT INTO apb_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Mo ngeulaa nge iinoni ko ngeu'i kire ka'a ha'amada'aa ike iinonine i maana God, ta'e mo wala nge ko iisitaa mwaanie ngidune ni ko ha'amada'aa.” ");
INSERT INTO apb_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Oto maholo e lae mwaanie mwala na ko lai sili oto i nume, nge mo pwaarongoisuli ingeie kire ko si dolosie aalahuunge ngeena aana. ");
INSERT INTO apb_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Oto a Jisas ko te'uri hunire, “!I'omu na pwaumiu e aaela no'one mola mala mwala ngeena! ?Uri omu ka'a lio saie ike no'one? Mei ngeulaa nge ko lai sili i laona ngidune iinoni, mo ola ngeena ka'a ha'amada'aa ike iinoni, ");
INSERT INTO apb_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","i sulie kire ka'a lae ike i laona manatana, ta'e kire lae tara'asi mola hao i laona oopwana. Oto ko si iisitaa lo'u mola mwaanie sapena.” (Maholo a Jisas e ere urine e haata'inie uri ahutana mo ola ngau-ngeu kire mani rere'a mola i maana God.) ");
INSERT INTO apb_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Oto ko he'i te'uri lo'u, “Ta'e ne'isaenga aaela iinoni ha'alaa e sai ha'amada'aa iinoni i maana God. ");
INSERT INTO apb_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Aena aana mo ne'isaenga aaela ko meni uure oto mai mwaanie saena iinoni. Mo ne'isaenga mala masinge, pelinge, horonga, aeni-olanga, ");
INSERT INTO apb_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","saehanalinge, tata'alanga, eeronga, dau-olanga ta'ewau, heota'inge, ere-aaelasilana ngaeta iinoni, tooha'inge, na pu'onga. ");
INSERT INTO apb_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Ahutana walu ola ienini, ikire i saena iinoni. Kire ko iisitaa, nge kire sai ha'amada'aa iinoni.” ");
INSERT INTO apb_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Oto a Jisas na mo pwaarongoisuli kire uure i leune, kire ko lae lo'u weu hunie hanue ni pu'o i Taea, na ngaeta mwala i leune kire tolakonire i nume ikire. A Jisas e sere'inie uri mwala aaopa ke saie ingeie i leune, ta'e e aasa oto huni mumuni. ");
INSERT INTO apb_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Na ngaeta hu'e, li'oa aaela e hite aana kele pule ingeie, ingeie no'one i leune. Oto maholo e rongoa uri a Jisas e hule, oto ko tolana lae oto mai pouruuru i na'ona. ");
INSERT INTO apb_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","A hu'ena, ingeie nga hu'e ni Jiu ha'ike, ta'e e hute aana po'o ni henue i Ponisia i laona aalahanga i Siria. Na e lae mai ngarasie a Jisas hunie ke ta'aasie li'oa aaela mwaanie kele pule ingeie. ");
INSERT INTO apb_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Ta'e a Jisas ko ere ni aalahuunge mola i sulie mo Jiu na mo pu'o hunie uuri, “Toli'aasie ka'u mo mwela kire ke hola'i ngeu, hunie kire ke pote. Aana e ka'a diana ike huni aasie mola mo ngeulaa mo mwela ana mo usu.” ");
INSERT INTO apb_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Oto a hu'ena ko aalamie lo'u a Jisas, ko te'uri, “E to'ohuu oto aalaha ineu. Ta'e ma'alana mo usu na kire sai ngaa mola mo eehuhu'ei ngeulaa nge ko teke mwaanie taetahe mo mwela.” ");
INSERT INTO apb_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Oto a Jisas ko te'uri hunie, “Aena aana o ko ere kohi urine, ta'ela'i na o ke lae oto ta'i nume i'oe. Li'oa aaela ngeena e lae oto mwaanie pule i'oe.” ");
INSERT INTO apb_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Na maholo a hu'ena e ooli weu i nume ingeie, na ko leesie a kalena e eno i lengine hulite ingeie, na li'oa aaela ngeena e tahi to'ohuu oto mwaanie. ");
INSERT INTO apb_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Oto a Jisas na mo pwaarongoisuli ingeie kire uure mwaanie po'o ni henue i Taea, kire si lae i liu i Saedon, oto kire si lai hule aana aasi weu i Kalili hatarie po'o ni henue i Dekapolis. ");
INSERT INTO apb_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Oto ngaeta mwala kire toolea mai nga mwane e pungu na e ka'a sai ere kohi ike no'one i saana a Jisas. Na kire ko eitanaie uri ke ha'a-uurie. ");
INSERT INTO apb_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Oto a Jisas e toolea a mwaena mwaanie mwala, e si ne'ie ri'i-ri'ine i laona e ro aalingana mwaena. Na e ngisuhie ri'i-ri'ine, oto ko toonga'inie aana meana a mwaena. ");
INSERT INTO apb_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Oto e lio ta'i lengi, na ko mango paine mala iinoni ko saehuu, na ko te'uri hunie a mwaena aana erenga ni Jiu, “!Epata!” Lo'onga'inge aana uuri, “O ke taha oto.” ");
INSERT INTO apb_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Na oto mola aana maholona, aalingana a mwaena ko tolana taha oto, na meana e kohi oto no'one, na ko ere kohi oto lo'u. ");
INSERT INTO apb_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Oto a Jisas e ere honosire mwaanie kire ha'arongoa nga iini. Ta'e ma'alana e uure honosire ka'u urine, kire ko si laenga'inie mola hailiu. ");
INSERT INTO apb_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Na ahutana mwala nge kire rongoa tataroha ngeena, kire ko tohungei pangata'i oto hiito'o, na kire ko ere uuri, “!Ha'ike eena! !Ahutana mo ola a mwane ngeena ko esui'i kire tohungei kohi oto liutaa! E asuie mo pungu kire ko rorongo oto, na mo pweu kire manata lo'u.” ");
INSERT INTO apb_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Oto aana ngaeta mo dinge lo'u, na mwala hunge ko he'i loko lo'u mei saana Jisas. Na lae-lae kire ngau mangoa oto mo ngeulaa ikire. Oto a Jisas ko soie mai mo pwaarongoisuli ingeie i saana, ko ere uuri hunire, ");
INSERT INTO apb_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“No ko tohungei aamasie mwala ienini, aena aana kire ko ii'o oto pe'ikolu hunie e oolu hei dinge na kire ka'a to'o aana oto nga mei ngeulaa. ");
INSERT INTO apb_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Nou ka'a sare uusunge'i eeliho'i ike aada mwaakule mwaanie kire maehunu mola i sulie tala, aena aana ngaeta mo iini aada kire uure ha'atau.” ");
INSERT INTO apb_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Oto mo pwaarongoisuli ko dolosi aana uuri, “?Oto kolu kei deu oodoie ka'u mei ngeulaa malisine mwala hunge uurini i tei, na ikolu i laona hanuesala?” ");
INSERT INTO apb_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Oto a Jisas ko dolosi lo'u aada uuri, “?E nite ho bred ni omu to'o aani?” Oto kire ko unue, “E hiu mola.” ");
INSERT INTO apb_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Oto a Jisas ko unue hunie mwala uri kire ke ii'o i aano. Na e hele aana e hiu ho bred ngeena, oto ko paalahea God, na ko nisi'i. Oto ko nii'i hunie mo pwaarongoisuli ingeie hunie kire ke ha'a-adoa mwala aani. ");
INSERT INTO apb_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Na kire to'o aana nga mo kele ho ii'e no'one. Oto a Jisas e paalahea God haahi'i lo'u, ko si nii'i hunie mo pwaarongoisuli hunie kire ke ha'a-adoa mwala lo'u eeni. ");
INSERT INTO apb_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Oto ahutana mwala kire mani ngeu pote, na i purine kire ngau mango, mo pwaarongoisuli ko si ha'ahonue e hiu lu'e aana mo ooretai ngeulaa. ");
INSERT INTO apb_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Na iidumilana mo mwane nge kire ngau aana maholona e hule aana e hai sinolai mwane. Oto a Jisas e uusunge'i eeliho'i aada, ");
INSERT INTO apb_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","e si lae ta'e pe'ie mo pwaarongoisuli ingeie i laona iiola, na kire ko lae oto hunie po'o ni henue i Dalmanuta. ");
INSERT INTO apb_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Ngaeta mo Parise kire lae mai saana a Jisas, oto kire ko aehota dodolosi ola oto aana, aena aana kire ko sare lupwe'i oohongie mola a Jisas aana kire lo'onga'inie uri e ka'a uure ike mwaanie a God. Oto kire ko unue uri ke asuie nga hu'i-hu'ite hunie kire ke leesie. ");
INSERT INTO apb_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Ta'e a Jisas ko si aawasirahe mola na ko te'uri, “!Ha'ike eena! ?E ue ni i'omu mwala aana maholo ienini, oto tarau omu ko sare leesie nga hu'i-hu'ite? !No ko unue oto huni'omu uri nga ta'a-ta'a mei ola urine haata'inilana e sa'a lae ike huni'omu!” ");
INSERT INTO apb_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Oto a Jisas e lae mola mwaanire, ko si lae wau i ta'e i laona iiola, na ko aatoholo oto lo'u pe'ie mo pwaarongoisuli takoie po'o ni eesi po'o ta'au. ");
INSERT INTO apb_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Na aana maholona, mo pwaarongoisuli kire si saie uri kire pulongo huni tola bred ada, na ta'a-ta'a ho bred mola kire to'o aana i laona iiola. ");
INSERT INTO apb_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Na a Jisas ko ha'apasulire uuri, “Omu ke lio talamiu mwaanie iis mo Parise, na iis a Herod Inemauri.” ");
INSERT INTO apb_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Oto mo pwaarongoisuli ko lae pe'i ere hailiu i matolada maraada uuri, “Ohe ko ere urine i sulie kolu ka'a tola bred ike pe'ikolu.” ");
INSERT INTO apb_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","A Jisas e saie mone ne'isaenga ikire, oto ko dolosi aada uuri, “?E ue ni omu ko tolahi'e hiito'o aana uri omu ka'a tola bred ike pe'i'omu? ?Ohe omu ka'a lo'onga'i saie ike ue, wa omu ke lio saie? ?E ue ni saemiu e rorodo'a urine? ");
INSERT INTO apb_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","?Omu to'o maamiu ka'u taane, na e ue omu ka'a sai lio sai ola? ?Omu to'o aalingemiu no'one, na e ue omu ka'a sai rongo sai ola? ?Ohe omu pulongosie oto, ");
INSERT INTO apb_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","maholo nou nisie e lime kele ho bred hunie e lime sinolai mwane? ?E nite lu'e nge omu onime'ini'i kire honu aana mo ooretai ngeulaa?” Oto kire ko unue uuri, “Aawala mwana rue.” ");
INSERT INTO apb_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Oto a Jisas ko dolosi lo'u aada uuri, “?Na maholo nou nisie e hiu kele ho bred hunie e hai sinolai mwane, e nite lu'e nge omu ha'ahonu'i aana mo ooretai ngeulaa?” Oto kire ko aalamie uuri, “E hiu.” ");
INSERT INTO apb_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Oto a Jisas ko te'uri lo'u hunire, “?Na e ue omu ka'a sai lio sai'i?” ");
INSERT INTO apb_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Oto maholo kire lae mai hule aana huilume i Betsaeda, ngaeta mwala kire toolea mai saana a Jisas nga mwane maana e ulu, na kire ko eitanaie uri ke hele i sapena. ");
INSERT INTO apb_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","A Jisas e hele i ki'ine mwane e ulu ngeena, oto ko toolea ta'au mwaanie huilume. Oto e ngisuhie maana a mwaena, na e hele i pweune aana nimana, ko si dolosi aana uuri, “?E ue? ?O sai leesie taane oto nga mei ola?” ");
INSERT INTO apb_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Oto a mwaena e lio i lengi na ko te'uri, “Iau, no ko leesie oto mwala, ta'e kire lio mala mo ei ko wale hailiu.” ");
INSERT INTO apb_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Oto a Jisas ko he'i hele lo'u weu i maana mwaena. Oto a mwaena ko si lio hahuroto, na maana e kohi oto, na ko lio diana aana ahutana walu ola. ");
INSERT INTO apb_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Oto a Jisas ko si unue mola hunie uuri, “O ke su'uri lae lo'u i laona huilume waune, ta'e o ke oodo mola hunie nume i'oe.” ");
INSERT INTO apb_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Oto a Jisas na mo pwaarongoisuli ingeie kire ko lae lo'u hunie mo henue kali-kelie huilume paine i Sisaria Pilipae. Na maholo kire ko lae ngeena, a Jisas ko dolosi aada uuri, “?Ha'alaa mwala ko unu-unue uri ineu a tei?” ");
INSERT INTO apb_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Oto kire ko aalamie uuri, “Ngaeta mo iini ko unu-unue uri i'oe a Jon Loto Maa'i e mauri eeliho'i. Na nga mo iini ko unu-unue uri i'oe a Propet Elaeja. Na ngaeta mo iini lo'u ko unu-unue uri i'oe nga iini hikana mo propet oto i na'o.” ");
INSERT INTO apb_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Oto a Jisas ko he'i dolosi aada uuri, “?Oto e ue aana i'omu? ?Ha'alaa omu ko unu-unue uri ineu a tei?” Oto a Pita ko aalamie uuri, “I'oe oto a Kraes, a Ha'a-uuri nge a God e haiholota'inie kei lae mai.” ");
INSERT INTO apb_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Oto a Jisas ko ere honosire mwaanie kire ha'arongoa lo'u nga iini aana uri ingeie a tei. ");
INSERT INTO apb_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Na e aehota oto huni ha'a-uusulire uuri, “Ineu, a Kale Ni Iinoni, mo ola hunge ne kei sapesalu eeni. Mo rato ni mwane, na mo na'ohai pris, na mo ha'a-uusuli aana mo Ha'atolanga a Mosis, kire kei leledieu, na hule aana kire kei horo maesieu oto. Ta'e aana oolune nga hai dinge, ne kei ta'ela'i eeliho'i lo'u.” ");
INSERT INTO apb_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","E tohungei unu haada'i aana leune oto urine hunire. Oto a Pita e kele toolea wau mwaanire, na ko ere honosie leune mwaanie. ");
INSERT INTO apb_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Ta'e a Jisas e to'omaaie ngaeta mo pwaarongoisuli, ko si ere aana a Pita, ko te'uri, “!Tahi mwaanieu, Satan! O ka'a saie ike ne'isaenga a God, ta'e o ko ere mola i sulie lio-lionga mo iinoni.” ");
INSERT INTO apb_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Oto a Jisas e soie mai mwala hunge na mo pwaarongoisuli ingeie i saana, ko si te'uri hunire, “Mala uri nga iini ko sare lulu i sulieu, nge ke pulongosie walu ola e sae haahi'i, na ke lulu i sulieu, ma'alana ke sapesalu i tehula'aku, hule aana maenga i lengine po'u-po'u. Iini nge ko aanga'inie po'u-po'u ingeie urine, ha'alaa e sai lulu i sulieu. ");
INSERT INTO apb_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Aana ta'ena nga iini nge ko sare kineta'inie mola mauriha'ana, nge kei deu tekela'inie oto. Ta'e iini nge ko deu tekela'inie mauriha'ana i tehula'aku na haahie Tataroha Diana ineu, nge kei ha'a-uurie. ");
INSERT INTO apb_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","?Ha'alaa nga mei taa diana nge iinoni kei terie aana kei to'o aana oto ahutana mo to'o-to'onga aana walumalau ie, na ko deu tekela'inie mola mauriha'ana oto i tehula'ani? ");
INSERT INTO apb_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","?Oto uri to'o-to'olana kei pe'ie aana maholona? !Ha'ike oto oo'oo! Nga mei ola hunie ke niie huni tola aaliho'i aana mauriha'ana, ha'ike lo'u. ");
INSERT INTO apb_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Mwala aana maholo ienini kire ko talei deu ta'e wau oto mola, aana kire ka'a kineta'inire ike lo'u mala mo iinoni a God. Oto mala uri nga iini ko masa huni unu tahanga'inieu na mo ha'a-uusulinge ineu i matolana mwala ni ooraha'aa ienini, nge ineu no'one ne kei masa huni unu tahanga'inie aana maholo ne kei lae mai pe'ie mo ensel maa'i aana manikuluha'ana a Mama'a.” ");
INSERT INTO apb_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Na a Jisas e he'i te'uri lo'u hunire, “To'ohuu no ko unue oto huni'omu uri ngaeta mo iini hikemiu mwala nge omu uure ngeena, omu kei saronai leesie Aalahanga a God kei lae mai, omu ke si mae.” ");
INSERT INTO apb_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Purine oono hai dinge e mango, a Jisas e toolea a Pita na Jemes na Jon pe'ie, na e na'oda ta'au takoie toloi henue paine hunie kire ke ii'o maraada. Ta'i lengi i leune, oto sapena Jisas ko hei-oolisi oto mola i na'oda, ");
INSERT INTO apb_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","na mo to'oni ingeie ko wana-wana, na kire ko rere'a oto hiito'o, liutaa aana ta'ena nga iini mei aano e sai hoda rere'a aani. ");
INSERT INTO apb_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Oto mola aana maholona a Mosis na Elaeja ko tolana maau na kirerue ko ere oto pe'ie a Jisas. ");
INSERT INTO apb_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Oto a Pita ko te'uri hunie a Jisas, “Ha'a-uusuli e tohungei diana aana i'emeelu oto i leu. Melu kei esuie oto nga oolu aapa-aapa—nga iini nemue, nga iini nana Mosis, na nga iini nana Elaeja.” ");
INSERT INTO apb_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","A Pita ko ere tatakalo urine, aena aana kiraelu ko tohungei me'u oto, hule aana e ka'a saie nga taa ko unue. ");
INSERT INTO apb_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Oto mola aana maholona, mei uuru e lae oto mai haahire, na mei wala e uure mai mwaanie mei uuru ngeena ko te'uri, “Tohungei kaleku oto ienini. Omu ke rongo hunie.” ");
INSERT INTO apb_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Oto kire ko tolana lio hailiu ta'e kire ka'a leesie ike nga iini lo'u pe'ire, ta'e a Jisas hali'ite mola pe'ire. ");
INSERT INTO apb_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Oto maholo kire ko siho toli oto mai mwaanie toloi henue ngeena, a Jisas ko si unue hunire uuri, “Mwaanie omu unu-unue nga taa omu leesie oodoie nga iini, lai hule aana maholo ineu a Kale Ni Iinoni ne kei ta'ela'i mwaanie maenga.” ");
INSERT INTO apb_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Oto kiraelu ko tola i sulie oto nga taa e unue, ta'e kiraelu ko heitalenga'inie taane i matoladaelu uuri, “?Nga taa ni lo'onga'inge aana ta'ela'inge mwaanie maenga ienini?” ");
INSERT INTO apb_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Na kire ko dolosi aana Jisas uuri, “?E ue ka'u mo ha'a-uusuli aana mo Ha'atolanga a Mosis kire unue uri a Elaeja kei hola'i lae mai i na'ona a Kraes?” ");
INSERT INTO apb_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Oto a Jisas ko te'uri, “E to'ohuu oto, na e malisine uri a Elaeja ni ke hola'i lae mai huni deu aakau aana ahutana walu ola loosie a Kraes. ?Ta'e aana e urine, na e ue ka'u mo Uusu-uusu Maa'i e unue uri kire kei maaleledie a Kale Ni Iinoni na kei sapesalu oto hiito'o? ");
INSERT INTO apb_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Ta'e no ko unue oto huni'omu uri a Elaeja e pwani lae taane oto mai, na mwala kire talei deu mala saeda mola aana, mala mo Uusu-uusu Maa'i e ere lalai ka'u aana.” ");
INSERT INTO apb_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Maholo a Jisas na Pita na Jemes na Jon kire ooli mei saana ngaeta mo pwaarongoisuli ingeie, na kire ko leesie mwala hunge kire loko ahuire. Na ngaeta mo ha'a-uusuli aana mo Ha'atolanga a Mosis, kire ko ere-ere haitapali pe'ire. ");
INSERT INTO apb_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Oto maholo mwala kire leesie a Jisas, kire ko tohungei pangata'i, na kire ko huru oto mai honosie. ");
INSERT INTO apb_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Oto a Jisas ko dolosi aana mo pwaarongoisuli ingeie uuri, “?Nga taa ni omu ko ere haitapali pe'ire haahie?” ");
INSERT INTO apb_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Oto ngaeta mwane aana mwala hunge ngeena ko aalamie a Jisas uuri, “Ha'a-uusuli, nou toolea mai kaleku i seemu, aena aana li'oa aaela e hite aana, oto e ka'a sai ere ike. ");
INSERT INTO apb_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Maholo li'oa aaela ngeena kei hulesie, oto ko repute'inie oto i aano, na huto-huto ko tahe oto aana wawana, na ko ngangadie oto nihona, na ahutana sapena ko rarasi mango oto. Nou unue ka'u oodoie mo pwaarongoisuli i'oe hunie kire ke ta'aasie li'oa aaela ngeena mwaanie, ta'e kire dau kasoa mola.” ");
INSERT INTO apb_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Oto a Jisas ko te'uri hunire, “I'omu pwaunge si'iri ie, i'omu mo iinoni aaela, suata mone hule aana omu ka'a hiiwalaimoli ike aana a God. !No ko talei ha'aweoau oto mola pe'i'omu! ?Uri ne kei ii'o tewa ka'u lo'u uri taa pe'i'omu, omu ke si hiiwalaimoli? Toolea ka'u mei a mwa'une i seeku.” ");
INSERT INTO apb_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Oto kire toolea mai a mwa'une i saana Jisas. Na maholo li'oa aaela ngeena e leesie mola a Jisas, oto ko hulesie oto a mwa'une na ko repute'inie oto i aano, na a mwa'une ko tesilepa oto hailiu, na huto-huto ko tahe oto aana wawana. ");
INSERT INTO apb_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Oto a Jisas ko dolosi aana aamana mwa'une uuri, “?Maholo uri taa ni mei ola ngeena e aehota hite aana?” Oto aamana ko aalamie uuri, “Uure oto aana maholo e mwai-mwei. ");
INSERT INTO apb_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Mo maholo hunge li'oa aaela ngeena ko horo'ie oto aani aasilana i laona dunge na i laona wai. Oto mala uri nanamanga i'oe e sai pe'ie, nge o ke aamasi'emeelu na o ke pe'i'emeelu oto.” ");
INSERT INTO apb_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Oto a Jisas ko ere uuri hunie, “?E ue o ko unue uuri, ‘Mala uri nanamanga i'oe e sai pe'ie’? Ta'ena nga iini ko hiiwalaimoli aana God e sai esuie ahutana walu ola.” ");
INSERT INTO apb_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Oto aamana mwa'une ko tolana soi oto paine uuri, “Nou hiiwalaimoli taane, ta'e hiiwalaimolinge ineu e o'oru'e. !Oto o ke pe'ieu hunie hiiwalaimolinge ineu ke a'aila'a na mwaanie nou ne'isae rue-rua'a lo'u!” ");
INSERT INTO apb_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Oto a Jisas e leesie mwala hunge kire ko lae mai kara'inie, ko si ere aana li'oa aaela ngeena uuri, “I'oe li'oa aaela nge o ko ha'apungue aalingana kele mwa'u ngeena na o ko ha'apweue mwaanie e ere-ere, no ko unue oto huni'o uri o ke iisitaa mai mwaanie a mwa'u ngeena. Na o ke su'uri sili eeliho'i lo'u i laona mwa'u ngeena aana nga maholo.” ");
INSERT INTO apb_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Oto li'oa aaela ngeena ko aawara oto paine, ko ha'a-aririe, ko si iisitaa oto mwaanie a mwa'une. Na a mwa'une e lio mala e mae oto, na ahutana mwala ko meni te'uri, “E mae oto ni ngeena.” ");
INSERT INTO apb_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Ta'e a Jisas e hele i nimana, oto ko ta'ea, na a mwa'une ko uure oto i lengi. ");
INSERT INTO apb_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Oto maholo a Jisas e hule aaliho'i i nume, mo pwaarongoisuli ingeie ko lae mai maraada, kire ko si dolosi aana uuri, “?E ue ka'u nge i'emeelu, melu ka'a sai oohe aasie li'oa aaela ngeena mwaanie a mwa'une?” ");
INSERT INTO apb_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Oto a Jisas ko aalamire uuri, “Omu sai oohe aasie taungei li'oa aaela urine mola aani aarenga'inge ha'alaa.” ");
INSERT INTO apb_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Oto a Jisas na mo pwaarongoisuli ingeie, kire uure i leune, kire si lae lo'u i liu aana po'o ni henue wau i Kalili. A Jisas e ka'a saeto'o aana ike nga ta'a-ta'a iini ke saie leu e ii'o aana, ");
INSERT INTO apb_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","aena aana ko ha'a-uusulie mo pwaarongoisuli ingeie, na ko te'uri hunire, “Pwelolaku a Kale Ni Iinoni kei lae i nimana mo iinoni hunie kire ke horo maesieu, ta'e i purine e oolu hei dinge ne kei ta'ela'i lo'u hunie mauringe.” ");
INSERT INTO apb_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Mo pwaarongoisuli kire ka'a sai diana aana ike nga taa lo'onga'inge aana ha'a-uusulinge ingeie, ta'e kire ko me'u mola huni dolosi lo'u aana. ");
INSERT INTO apb_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Maholo a Jisas na mo pwaarongoisuli ingeie kire hule hai Kapaneam, oto kire lae i laona ngaeta nume. Oto a Jisas ko dolosi aada uuri, “?Nga mei taa ni omu ere-ere i sulie maholo kolu lae poi sulie tala?” ");
INSERT INTO apb_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Ta'e kire ka'a aalamie ike aena aana kire lae pe'i ere haitelili haahie uri a tei hikada ni e paine liutaa. ");
INSERT INTO apb_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Oto a Jisas e ii'o i aano, na ko soie aawalai pwaarongoisuli mwana rue ingeie, ko si te'uri hunire, “Mala uri ta'ena nga iini ko sare aalaha, nge ke ha'amwai-mwei'aa maraana, na ke asu mala koni-konihe nana ahutana mwala.” ");
INSERT INTO apb_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Oto e toolea kele mwela, ko si ha'a-uuresie i matolada. E ako haahie, na ko te'uri hunire, ");
INSERT INTO apb_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Ta'ena nga iini nge ko tola konie nga kele mwela mala ienini aana sataku, nge ko tola konieu eena. Na ta'ena nga iini nge ko tola konieu, ko tola konie no'one iini e uusunge'inieu mei eena.” ");
INSERT INTO apb_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Oto a Jon ko ere uuri hunie, “Ha'a-uusuli, emi leesie ngaeta mwane ko oohe aasie mo li'oa aaela mwaanie mwala aana satamu, oto melu ere aana, aena aana ingeie ha'ike aana pulitaa ikolu.” ");
INSERT INTO apb_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Ta'e a Jisas e unue hunire uuri, “Su'uri uure honosie, aena aana nga iini e sa'a asuie ike nga hu'i-hu'ite mola aana sataku, na uri ke ere aaelasieu lo'u i puri. ");
INSERT INTO apb_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Aana ta'ena nga iini nge ka'a uure honosikolu, nge ingeie iini pe'ikolu eena. ");
INSERT INTO apb_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","No ko unue oto huni'omu uri, mala nga iini ko niie nga mei wei emiu aena aana omu ko lulu i sulieu, nge a God kei waaie taane iinoni ngeena.” ");
INSERT INTO apb_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Oto a Jisas ko he'i ere uuri lo'u, “Oto mala nga iini ko ha'atataroa nga kele iini aana mo iini ko hiiwalaimoli eeku ienini, e lae otoi diana hunie iini urine pwarolana nga hau peine ke lae mola i luana, oto kulu-aasilana ke lae mola i laona aasi. ");
INSERT INTO apb_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","“Na mala uri ki'imu maraamu ko ha'atataro'o hunie ooraha'aa, nge o ke lama mousie mola. Aana e diana liutaa huni lai sili i laona maurihe huu mola pe'ie ta'a-ta'a ki'i-ki'i, mwaanie uri laenga pe'ie e ro ki'imu i laona dunge ni ha'amotaahinge. Leu ngeena, leu dunge paine aana, na nga mei ola huni mwa'asie ha'ike lo'u. ");
INSERT INTO apb_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Na mala ae'aemu ko ha'atataro'o hunie ooraha'aa, nge o ke lama mousie mola. Aana e diana liutaa huni lai sili i laona maurihe huu pe'ie ta'a-ta'a ae'ae, mwaanie uri laenga pe'ie e ro ae'aemu i laona dunge ni ha'amotaahinge. ");
INSERT INTO apb_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Na mala uri maamu ko ha'atataro'o hunie ooraha'aa, nge o ke kae aasie mola. Aana e diana liutaa huni lae i laona Aalahanga a God mola pe'ie ta'a-ta'a maa, mwaanie laenga pe'ie e ro maamu i laona dunge ni ha'amotaahinge. ");
INSERT INTO apb_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Aana leune, mo mwaa-mwaa huni ngaa mwala urine, kire ka'a sai mae ike, na dunge i leune no'one sa'a roro'a ni mwa'a oto oo'oo aana ta'ena nga maholo. ");
INSERT INTO apb_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Na i leune dunge kei weruhie ahutada tara'asi. ");
INSERT INTO apb_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","“Ahaa mei ola diana, ta'e mala uri ahaanga aana kei lae mwaanie, kei ne'i ola aaela oto aana e sa'a ahaala ike lo'u. Oto urine, e malisine tolahamiu ke ahaala tara'asi, na omu ke ii'o ni henuelama i matolamiu heiliu.” ");
INSERT INTO apb_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Oto a Jisas e lae mwaanie i leune, e si lae mwaanie i Kalili hunie po'o ni henue i Jiudia na lo'u hunie aapa po'o wau aana wai peine i Jodan hatarie sato pwaa. Na mwala hunge kire loko lo'u mei i saana, ko si ha'a-uusulire oto mala ko eu'esuie tarau hunire. ");
INSERT INTO apb_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Ngaeta mo Parise kire lae mai saana huni lupwe'i dolosi pweloa, na kire ko dolosi aana uuri, “O ke unue ka'u oodoi'emeelu. ?Uri e diana taane aana mo Ha'atolanga ikie hunie poro ke sikaa mola hu'e ingeie?” ");
INSERT INTO apb_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Oto a Jisas ko aalamire pe'ie mei wala ni dolosinge uuri, “?Nga Ha'atolanga uri taa a Mosis e niie huni'omu oto uure mai na'o?” ");
INSERT INTO apb_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Oto kire ko te'uri, “A Mosis e toli'aasie taane mola uri poro e sai sikaa mola hu'e ingeie mala uri ko hola'i uusue nga uusu-uusu aani sikanga.” ");
INSERT INTO apb_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Oto a Jisas ko te'uri hunire, “A Mosis e uusue ha'atolanga ngeena huni'omu, aena aana saemiu e lae otoi heu. ");
INSERT INTO apb_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Ta'e aana aehotalana walumalau, A God e ha'aholaa mwane na keni, oto mala mo Uusu-uusu Maa'i e unue. ");
INSERT INTO apb_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Na aena urine, nga mwane kei oopa mwaanie aamana na nikana, kei ii'o ruru oto pe'ie hu'e ingeie. ");
INSERT INTO apb_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Na kirerue kei ne'ie oto ta'a-ta'a iinoni, na e ro iinoni ngeena nga ro iinoni hai aaopa'i ha'ike lo'u, ta'e ta'a-ta'a iinoni oto. ");
INSERT INTO apb_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Aena urine, mei ola nge a God e ho'o rurue oto, mwaanie nga iini e he'i oopa-oopaa lo'u.” ");
INSERT INTO apb_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Oto maholo kire aaliho'i weu i nume, mo pwaarongoisuli ingeie kire ko he'i dolosie lo'u mei ne'isaenga ngeena aana a Jisas. ");
INSERT INTO apb_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Oto a Jisas ko te'uri hunire, “Mala uri nga mwane ko sikaa hu'e ingeie na ko to'o aana lo'u ngaeta hu'e aaopa, a mwane ngeena ko mesi oto eena aana ko hele roro'anga haahie hu'e ingeie. ");
INSERT INTO apb_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Na e urine lo'u aana hu'e nge ko sikaa poro ingeie na ko to'o aana lo'u ngaeta poro aaopa. A hu'e ngeena ko mesi no'one, aana ko hele roro'anga haahie poro ingeie.” ");
INSERT INTO apb_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Ngaeta mwala kire toolea mai mo mwela i saana Jisas hunie ke hele i pweude aana nimana, ta'e mo pwaarongoisuli ingeie kire ko ere aada. ");
INSERT INTO apb_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Na maholo a Jisas e manata'inie urine, ko saewasulire, na ko ere aana mo pwaarongoisuli ingeie uuri, “Omu ke toli'aasie mo mwela hunie kire ke lae mai seeku, na omu ke su'uri uure honosire. Aena aana mo iini kire urihana mo mwela ngeena ha'alaa kire ko sili i laona Aalahanga a God. ");
INSERT INTO apb_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","To'ohuu no ko unue huni'omu uri mala nga iini e ka'a ha'amwai-mwei'aa mala mo mwela mwai-mwei, nge e sa'a roro'a sili ike i laona Aalahanga a God.” ");
INSERT INTO apb_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Oto a Jisas e akoire, na e hele i pweude aana nimana, e si ha'adiana'ara. ");
INSERT INTO apb_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Maholo a Jisas ko aehota oto hunie kei lae lo'u, na ngaeta mwane e huru mei i saana, ko pouruuru oto i na'ona, na ko dolosi aana uuri, “?Ha'a-uusuli diana, nga taa ne kei esuie ka'u hunie ne ke hele aana maurihe huu?” ");
INSERT INTO apb_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Oto a Jisas ko aalamie uuri, “?E ue o ko unue uri ineu nou diana? Nga ta'a-ta'a iini ka'a diana ike ta'e a God hali'ite. ");
INSERT INTO apb_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Ta'e aana dolosinge i'oe, o saie ka'u oto mo Ha'atolanga a Mosis. Mwaanie o talei horo-horo, na mwaanie o mai-mesi, na mwaanie o peli-peli, na mwaanie o pwelu wala eero-eero, na mwaanie o ha'amwe'u-mwe'ue nga iini, na o ke ha'ama'u aana aamamu na nikemu.” ");
INSERT INTO apb_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Oto a mwaena ko te'uri hunie, “Ha'a-uusuli, ahutana mo ha'atolanga ngeena nou hele i suli'i uure oto aana maholo nou mwei-mwei hule mai si'irini.” ");
INSERT INTO apb_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Oto a Jisas ko to'omaaie pe'i manata-diananga hunie, na ko te'uri hunie, “Ta'a-ta'a mei ola lo'u mola nge o kei esuie. O ke lai ha'aholinge'inie to'o-to'olamu, na o ke niie mei to'oha aani nana kira maitale. Aana ko urine nge o ke si to'o-to'o lo'u aana mo ola diana i Lengi. Mango urine, o ke si lae mai lulu i sulieu.” ");
INSERT INTO apb_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Oto maholo a mwaena e rongo urine, ko si lae mwaanie pe'i saehuunge paine aena aana e tohungei to'o-to'o oto liutaa. ");
INSERT INTO apb_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Oto a Jisas e to'omaaie mo pwaarongoisuli ingeie, ko si te'uri hunire, “Kei tohungei aasa oto hiito'o hunie mwala e to'o-to'o huni sili i laona Aalahanga a God.” ");
INSERT INTO apb_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Oto mo pwaarongoisuli ingeie kire ko tohungei apara'i pe'i pangata'inge aana e ere urine, ta'e a Jisas ko te'uri lo'u hunire, “Maeni mwela ineu, e tohungei aasa huni lai sili i laona Aalahanga a God. ");
INSERT INTO apb_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","E mwada'u mola hunie uri nga kamel kei sili i sulie kele waa-waata aana nile tau-teuri, liutaa aana iinoni to'o-to'o ke sili i laona Aalahanga a God.” ");
INSERT INTO apb_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Maholo mo pwaarongoisuli e rongo urine, oto kire ko tohungei pangata'i liutaa, na kire ko dolosi heiliu i matolada uuri, “?Oto a tei ke'u ke si helesie maurihe huu?” ");
INSERT INTO apb_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","A Jisas e to'omaaire, na ko te'uri, “Walu ola ienini kire aasa oto hiito'o hunie iinoni, ta'e hunie a God kire mwada'u mola.” ");
INSERT INTO apb_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Oto a Pita ko dolosi aana Jisas uuri, “Oto, o ke lio ka'u. ?E ue aana i'emeelu? Melu toli'aasie oto ahutana walu ola i'emeelu mango oto huni lulu i suli'o.” ");
INSERT INTO apb_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Oto a Jisas ko te'uri hunire, “To'ohuu no ko unue huni'omu uri nga iini nge ko toli'aasie nume ingeie, wa mo eesine mwane, wa mo eesine keni, wa nikana, wa aamana, wa mo mwela ingeie, wa mo aano ingeie, i tehula'aku na i tehula'ana Tataroha Diana, ");
INSERT INTO apb_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","nge kei to'o-to'o lo'u liutaa aana nga moi taa ko toli'aasi'i ngeena. I laona walumalau ie kei hele ha'atangalau aani nume, na aani eesine mwane, na aani eesine keni, na aani nikana, na aani mwela, na aani mei aano. Ta'e taunge'inilana kei lae oto no'one. Na aana walumalau haalu ko lae maine, nge ke si hele aana maurihe huu. ");
INSERT INTO apb_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Aana mo iini hunge kire ko na'o ka'u oto ie, kire kei saro puri mola. Na mo iini hunge kire ko puri oto ie, kire kei saro na'o lo'u mola.” ");
INSERT INTO apb_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Oto maholo a Jisas na mo pwaarongoisuli ingeie kire ko lae ta'au i sulie tala hunie i Jerusalem, a Jisas ko lae oto i na'o aana mo pwaarongoisuli. Mo pwaarongoisuli kire ko tohungei pangata'i oto hiito'o, na mwala ko lae pe'ire ngeena kire ko me'u. Oto a Jisas e he'i toolea lo'u aawalai pwaarongoisuli mwana rue wau maraada, ko si ha'arongora aana nga moi taa kei reu aana. ");
INSERT INTO apb_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Oto ko te'uri hunire, “Omu ke rongo ka'u. Kolu ko lae oto hunie i Jerusalem ie, leu nge ineu a Kale Ni Iinoni pwelolaku kei lae aana i nimana mo na'ohai pris na mo ha'a-uusuli aana mo Ha'atolanga a Mosis. Kire kei leieu oto hunie maenga, na kire kei niieu lo'u hunie mo Aapoloa Aaopa. ");
INSERT INTO apb_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Oto kire kei ha'amwasi eeku, na kire kei ngisuhieu, na kire kei repusieu, na kire kei horo maesieu oto. Ta'e aana oolune nga hai dinge, ne kei ta'ela'i eeliho'i lo'u mwaanie maenga.” ");
INSERT INTO apb_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Oto a Jemes na Jon, e ro kalena Sebedi, kire lae mai i saana Jisas, oto kire ko te'uri hunie, “Ha'a-uusuli, ta'a-ta'a mei ola mere saeto'o aana uri o ke da huni'emere'i.” ");
INSERT INTO apb_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Oto a Jisas ko dolosi aadarue uuri, “?Nga mei taa ni ngeena?” ");
INSERT INTO apb_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Oto kire ko aalamie uuri, “Mere saeto'o aana o ke toli'aasie mere ke aalaha pe'i'o aana e ro na'ohai leu aana aalahanga manikulu'e i'oe, nga iini i pwalo-pwalomu na nga iini i meu-meulimu.” ");
INSERT INTO apb_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Oto a Jisas ko te'uri hunirerue, “More ka'a saie ike nga taa more ko sukaa ni ngeena. ?Uri more sai hotela'inie taane iiola ne kei hotela'inie? ?Wa kei hi'e huni'omore'i?” ");
INSERT INTO apb_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Oto kirerue ko aalamie uuri, “Mere sai esuie mola.” Oto a Jisas ko te'uri lo'u hunirerue, “To'ohuu, more kei hotela'inie taane iiola ne kei hotela'inie. ");
INSERT INTO apb_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Ta'e uri hunie ii'onga i pwalo-pwaloku na i meu-meuliku, e ka'a leu ike i sapeku huni niie hunie nga iini, aana e ro ii'o-ii'oha ngeena kire ii'o oto loosie mo iini a God e lio hilisire.” ");
INSERT INTO apb_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Maholo ngaeta aawalai pwaarongoisuli kire rongoa sukanga a Jemes na Jon oto kire ko si saewasulirerue. ");
INSERT INTO apb_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Oto a Jisas e soie ahutada mai i saana, ko si te'uri hunire, “Omu saie oto uri mo aalaha ni welumalau kire ko sasare haata'inie nanamanga ikire haahie mwala ikire, na mo na'ohai mwane kire sai deu rarahie no'one mwala huni lae i sulie mo heri-huninge ikire. ");
INSERT INTO apb_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Ta'e i'omu, omu ke su'uri te'urine i matolamiu. Nga iini hikemiu ko sare aalaha, nge ke ne'i iinoni eu'esu nemiu. ");
INSERT INTO apb_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Na nga iini hikemiu ko sare ne'i na'ohai mwane haahi'omu, nge ke ne'i koni-konihe nana ahutemiu mango. ");
INSERT INTO apb_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Aana ma'alana ineu a Kale Ni Iinoni, nou ka'a lae ike mai hunie uri mwala ke asu nekue, ta'e nou lae mai huni ne'i koni-konihe nana mwala, na huni niie mauriha'aku i tehula'ana mwala hunge, na huni holi eeliho'i aana mwala hunge.” ");
INSERT INTO apb_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Oto a Jisas na mo pwaarongoisuli ingeie, kire lae mai hunie huilume i Jeriko. Maholo kire iisitaa lo'u mwaanie i Jeriko, na mwala hunge e lae no'one pe'ire. Na a Batimeas, kalena Timeas, ko o'o'o suli maholo i reune tala mola huni susuke ola nana aana mwala ko liu-liu, aena aana maana e ulu. ");
INSERT INTO apb_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Maholo e rongoa a Jisas ni Nasaret ko liu, oto ko soi uuri, “!Jisas, Kalena Deved Inemauri, o ke aamasieu!” ");
INSERT INTO apb_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Oto mwala hunge ko ere aana hunie ke rohu, ta'e ko si soi mola oto i lengi mola uuri, “!Kalena Deved Inemauri, o ke aamasieu!” ");
INSERT INTO apb_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Oto a Jisas e uure hahuroto, na ko te'uri hunire, “Omu ke soie mai.” Oto kire soie mwane e ulu ngeena na kire ko unue uuri, “O ke ilenimwa'e mola. !Ta'ela'i! A Jisas ni ko soi'o ngeena.” ");
INSERT INTO apb_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Oto e aasie to'oni tetewa ingeie mwaanie na ko pola oto i lengi na ko lae oto i saana Jisas. ");
INSERT INTO apb_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Oto a Jisas ko dolosi aana uuri, “?Nga taa o saeto'o aana ne ke asuie huni'o?” Oto a mwane e ulu ngeena ko te'uri, “Ha'a-uusuli, saeku hunie ne ke lio-lio lo'u.” ");
INSERT INTO apb_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Oto a Jisas ko te'uri hunie, “O ke lae. Hiiwalaimolinge i'oe aaku e ha'a-uuri'o oto.” Oto maana e tolana lio-lio lo'u, na a mwaena ko lae oto i sulie a Jisas. ");
INSERT INTO apb_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Maholo a Jisas na mo pwaarongoisuli ingeie kire lae hunie i Jerusalem, kire ko nanauhie mo huilume i Betfeis na i Betani, kara'inie Uuwo Ni Ei Olif. Oto a Jisas ko uusunge'inie e ro pwaarongoisuli ingeie oto i na'o, ");
INSERT INTO apb_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","na ko te'uri hunirerue, “More ke lae i na'o aana huilume nge kolu ko leesie ta'aune. Na maholo more kei hule ta'au, more kei leesie kele dongki haalu kire pwasue ta'au i leune. Dongki ngeena, nga iinoni ka'a ta'e ike ue aana. Oto more ko luhesie, more ko toolea mai hunieu. ");
INSERT INTO apb_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Mala uri nga iini ko dolosi aamore'i uuri, ‘?More ko luhesie huni taa?’ oto more ke unue oodoie uuri, ‘A poro paine e saeto'o aana, na kei ha'atola aaliho'i taane lo'u mei aana lau-leu.’” ");
INSERT INTO apb_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Oto kirerue lae ta'au, na kire ko lio oodoie oto kalei dongki i sulie tala nge ngaeta mwala kire pwasue oto i maana nume. Na maholo kirerue ko luhesie, ");
INSERT INTO apb_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","ngaeta mwala kire uure i leune, kire ko dolosi aadarue uuri, “!Ei! ?More ko luhesie dongki ngeena huni taa?” ");
INSERT INTO apb_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Oto kirerue ko aalamire oto mala a Jisas e hatonga'i hunirerue, na mo mwaena ko toli'aasie oto hunirerue. ");
INSERT INTO apb_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Oto kirerue toolea mai kalei dongki ngeena i saana a Jisas, na kirerue ko aasie mo to'oni ikirerue i kolune dongki, oto a Jisas e si ta'e i lengine. ");
INSERT INTO apb_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Na aana maholona mwala hunge kire eepasie tala aana mo to'oni ikire, na ngaeta mo iini kire ko lamasie mo kele sasarai ei i laona ma'usu na kire holasi'i no'one i sulie tala. ");
INSERT INTO apb_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Oto mwala kire na'o na mo iini i purine a Jisas, kire ko si lae pe'i soi oto paine, na kire ko lahea God uuri, “!Lahea God! A God ke ha'adiana'aa iini ko lae mai nunuha'ana satana. ");
INSERT INTO apb_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","A God ke ha'adiana'aa mwane ie, aana ko lae oto mai huni ne'i inemauri naka mala a Deved Inemauri weuwaka. !Lahea God ta'au i Lengi!” ");
INSERT INTO apb_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","A Jisas e lae hule ta'au i Jerusalem, oto e lae sili ta'au i laona Nume Maa'i Peine, ko lio hailiu hunie leesie ahutana mo ola. Ta'e aena aana maholona ko seulehi mone oto, e lae mola hunie i Betani pe'ie aawalai pwaarongoisuli mwana rue ingeie. ");
INSERT INTO apb_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Oto e dangi ho'owa kire ko eeliho'i mei mwaanie i Betani, na maholona a Jisas ko hiolo. ");
INSERT INTO apb_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Oto e leesie ai fik uure mai ha'atau, na apana e ure diana. Oto ko lae oto i saana huni leesie ohe nga hue-huei ei aana. Ta'e maholo e lae mai hule aana, na ko leesie mola ta'e apa-apana hali'ite, i sulie e ka'a hule ue aana maholo hunie mo fik kei hungu. ");
INSERT INTO apb_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Oto a Jisas ko te'uri hunie ai ngeena, “Nga iini sa'a roro'a ni ngaue lo'u nga hue-huei ei lo'u eemu uure si'iri pwau weu.” Na mo pwaarongoisuli ingeie kire rongoa oto nga taa e unue. ");
INSERT INTO apb_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Maholo kire lai aarapuu ta'au i Jerusalem, oto a Jisas ko lae i laona lolata aana Nume Maa'i Peine, na ko aehota oohea mwala ko holi-holi na mo iini ko ha'a-ha'aholinge'i ola. Ko keusie oto mo taetahe mwala ko ooli-oolisi to'oha na mo leu ni ii'o-ii'o ikire mo iini ko ha'aholinge'i hiroikuu. ");
INSERT INTO apb_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Na ko uure honosie oto mwaanie nga iini e toolea lo'u mei nga mei ola huni ha'aholi i laona lolata aana Nume Maa'i Peine. ");
INSERT INTO apb_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Oto ko si ere aada uuri, “A God e unue aana mo Uusu-uusu Maa'i uuri, Nume ineu oto nume ni aarenga'inge hunie mwala aana ahutana mo henue i laona walumalau. Ta'e omu ko si da mola ko ne'ie hahale kira horopeli kire sai mumuni i laona.” ");
INSERT INTO apb_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Oto mo na'ohai pris na mo ha'a-uusuli aana mo Ha'atolanga a Mosis kire rongo urine, kire ko aehota lo'onga'i oto i sulie nga tala uuri taa kire kei horo maesie a Jisas aana. Ta'e kire ko me'ute'inie, aena aana ahutana mwala ko tohungei pangata'inie ha'a-uusulinge ingeie. ");
INSERT INTO apb_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Oto e hule i seulehi, a Jisas na mo pwaarongoisuli ingeie kire lae oto lo'u mwaanie i Jerusalem. ");
INSERT INTO apb_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Oto i maahu'o-hu'o aana hai dinge lo'u i puri, kire ko eeliho'i lo'u mei sulie tala, na kire ko leesie ai nge a Jisas e uesie, e mae uure i to'elena lai hule oto aana imi-imine. ");
INSERT INTO apb_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Oto a Pita ko aamasito'o aana nga taa nge a Jisas e unue, oto ko te'uri hunie, “Ha'a-uusuli, o ke lio ka'u. Ai nge o uesie e mae oto.” ");
INSERT INTO apb_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Oto a Jisas ko unue hunire uuri, “Omu ke hiiwalaimoli mola aana a God. ");
INSERT INTO apb_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","To'ohuu no ko unue huni'omu uri mala ta'ena nga iini eemiu ko unue hunie toloi henue ie uuri, ‘O ke pola mola i eesi,’ na e ka'a ne'isae rue-rua'a, nge nga taa e sukaa kei reu mola hunie. ");
INSERT INTO apb_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Oto aena ngeena no ko unue huni'omu uri aana maholo omu ko aarenga'i na omu ko sukaa nga mei ola aana a God, omu ke noruto'o oto uri omu hele aana oto, na niilana nga taa omu sukaa kei lae oto huni'omu. ");
INSERT INTO apb_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Na maholo omu ko aarenga'i, omu ke hola'i sae'aasie ka'u nga mei ola omu ko to'o aana honosie nga iinoni, hunie Aamamiu i Lengi ke si sae'aasie mo ooraha'aanga i'omu mala omu esuiena.” ");
INSERT INTO apb_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Oto kire ko he'i hule lo'u ta'au i Jerusalem, na maholo a Jisas e lae i laona Nume Maa'i Peine, mo na'ohai pris, na mo ha'a-uusuli aana mo Ha'atolanga a Mosis, na mo rato ni mwane, kire lae mai saana. ");
INSERT INTO apb_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Oto kire ko dolosi aana uuri, “?Nga nanamanga uri taa ni o to'o aana huni esuie walu ola o ko deu'i ngeena? ?Na a tei ni e niie nanamanga ngeena huni'o?” ");
INSERT INTO apb_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Oto a Jisas e aalamire ko te'uri, “Ineu no'one no ko sare hola'i dolosie ta'a-ta'a mei dolosinge aamiu. Mala omu ko aalamieu, nge ne ke si unue oodoi'omu uri nanamanga uri taa nou to'o aana huni esuie walu ola ienini. ");
INSERT INTO apb_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Oto omu ke unue ka'u oodoieu. ?A tei ni e niie nanamanga hunie a Jon huni loto maa'i aana mwala? ?A God wa mo iinoni mola?” ");
INSERT INTO apb_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Oto kire ko aehota ere hailiu i matolada uuri, “?Oto nga taa kolu kei unue? Mala uri kolu kei unue a God ni e niie nanamanga ngeena hunie a Jon, nge kei unue hunikolu uuri, ‘?Nge ko urine, na e ue omu ka'a hiiwalaimoli aana?’ ");
INSERT INTO apb_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Ta'e mala kolu kei unue uri iinoni mola ni e niie nanamanga ngeena hunie a Jon, nge kolu kei lio talakaelu aana mwala. Aena aana ahutana mwala kire mani ne'isae oto uri a Jon ingeie nga propet to'ohuu.” ");
INSERT INTO apb_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Oto kire ko si aalamie mola a Jisas uuri, “Melu ka'a saie ike.” Oto a Jisas ko si te'uri hunire, “Ko urine, nge ineu na nou sa'a unue ike no'one oodoi'omu uri nga nanamanga uri taa no ko esuie mo ola ienini aana.” ");
INSERT INTO apb_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Oto a Jisas ko aehota ere ni aalahuunge hunire uuri, “Ngaeta mwane e o'o'o oto ko hesie hohola aani grep. Oto e para ahuie, na e asuie leu huni losie mo grep hunie kei ne'i waen, na e tohue saohai nume huni kakakali. Oto e ha'amangoa hahu'ana hohola ingeie ngeena urine, e si ha'ahaulaa aana ngaeta mo mwane hunie kire ke lio i sulie aana maholo ko lae i suli henue. ");
INSERT INTO apb_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Oto e hule aana maholo ni so'okoninge, a mwaena ko uusunge'inie ngaeta koni-konihe ingeie huni toolea mai nga taa mo mwane ko lio i sulie hohola ingeie kei niie hunie. ");
INSERT INTO apb_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Ta'e mo mwane ngeena kire wini-winie mola koni-konihe ngeena, na kire uusunge'i eeliho'i aana mola mwaakule. ");
INSERT INTO apb_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Oto poro painena ko he'i uusunge'inie lo'u ngaeta koni-konihe ingeie wau i saada. Oto kire ko he'i seunie lo'u, na kire rapu i pweune, na kire ko horo waelie oto hiito'o. ");
INSERT INTO apb_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Oto a mwaena ko he'i uusunge'inie lo'u ngaeta koni-konihe ingeie, ta'e kire horo maesie lo'u mola. Na mo iini hunge aana mwala au'esu ingeie, ta'a-ta'a taungei mei olana e rau no'one aada urine, aana kire rapusie ngaeta mo iini aada, na kire horo maesie ngaeta mo iini aada no'one. ");
INSERT INTO apb_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Oto lae-lae a mwaena e to'o aana mola ta'a-ta'a iinoni e oore lo'u huni ha'atolaa, ta'e ta'a-ta'a mwela moute'i ingeie ni otona. Oto a porona ko si uusunge'inie oto a kalena, aana e lo'onga'i uuri, ‘A kaleku ha'alaa kire kei ha'ama'u aana.’ ");
INSERT INTO apb_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Ta'e mwala au'esu ngeena kire ko si meni ere i sulie mola uuri, ‘Mwane nge kei to'o aana hohola ngeena oolisie aamana oto ie. Kolu ke horo maesie mola hunie kolu ke to'o aana oto hohola ienini.’ ");
INSERT INTO apb_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Oto kire tapolie na kire ko horo maesie oto. Na kire ko aasie oto wau i purine para aana hohola.” ");
INSERT INTO apb_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Oto a Jisas ko dolosi aada uuri, “?Ha'alaa nga taa nge poro paine haahie hohola ngeena kei esuie aana mwala ngeena? Maholo kei lae mai, nge kei tohungei horo suuhe'inie oto mwala aaela ngeena, na kei ha'ahaulaa lo'u hohola ngeena aana ngaeta mwala aaopa. ");
INSERT INTO apb_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Omu saie ka'u oto Uusu-uusu Maa'i e unue uuri, Hau nge mwala tou-tohu nume kire leledie ka'u, e si ne'ie tohungei heu susu aana nume. ");
INSERT INTO apb_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","A God ni e asuie urine, na e lai lio manikulu'e i maaka mo iinoni. ?Ta'e e ue omu ka'a rongo saie?” ");
INSERT INTO apb_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Oto mo na'ohai mwane aana mo Jiu kire ko sare tapolie mola a Jisas, aana kire rongo saie mola uri aalahuunge a Jisas aana mo mwane aaela ngeena ko ere mola i sulire. Ta'e kire ma'ute'inie mola mwala e hunge, oto kire toli'aasie, kire si lae mola mwaanie. ");
INSERT INTO apb_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Oto mo na'ohai mwane aana mo Jiu kire ko uusunge'inie ngaeta mo Parise na ngaeta mo iini aana pulitaa a Herod huni lai pweloa a Jisas aani dolosinge. ");
INSERT INTO apb_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Kire lae mai saana a Jisas, oto kire ko te'uri, “Ha'a-uusuli melu saie uri walaimolinge ni oto o ko unu-unuena. Oto o ka'a aapwasu ike aana nga taa mwala aaopa ko lo'o-lo'onga'inie aena aana o ka'a lio ike hunie maana mo iinoni, ta'e o ko ha'a-uusuli mola i sulie hari-huninge a God hunie mo iinoni. Oto o ke unue oodoi'emeelu. ?Uri e adona taane huni niie takis hunie aalahanga ni Rom wa ha'ike?” ");
INSERT INTO apb_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Ta'e a Jisas e lio saie mola mo pwelonga ikire, oto ko aalamire uuri, “?E ue omu ko sare lupwe'i pwaoau? Omu ke haata'inie ka'u seleni hunie takis ngeena aaku.” ");
INSERT INTO apb_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Oto kire toolea mai ngaeta seleni ni Rom hunie, oto ko dolosi aada uuri, “?A tei ni nunune na satana aana seleni ienini?” Oto kire ko aalamie uuri, “Inemauri ni Rom ni ngeena.” ");
INSERT INTO apb_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Oto a Jisas ko te'uri hunire, “Ko urine, omu ke nii eeliho'i aana hunie inemauri ngeena mo ola ingeie, na hunie a God mo iini a God.” Na maholo kire rongo urine, oto kire ko si tohungei pangata'inie a Jisas. ");
INSERT INTO apb_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Oto i puri, ngaeta mo Sadiusi kire lae mai saana a Jisas. Ikire mo Sadiusi ngeena kire hiiwalaimoli uri nga iini sa'a ta'ela'i ike lo'u mwaanie maenga. Oto kire ko te'uri hunie a Jisas, ");
INSERT INTO apb_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Ha'a-uusuli, a Mosis e uusue ha'atolanga ie hunikie. Mala uri nga mwane ko mae mwaanie hu'e, na e ka'a to'o kalena, nge aasine mwane ke to'o aana lo'u mola nao keni iihana, hunie ke ha'ahute mwela oolisie aasine nge e mae ngeena. ");
INSERT INTO apb_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Oto wau i na'o, e hiu mwaasine mwane kire mani hute na kire o'o'o i leu. A na'ohada e tola hu'e, oto e mae mola na e ka'a to'o mwela. ");
INSERT INTO apb_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Oto ruana nga mwane ko he'i to'o aana lo'u a keine, na ko he'i mae lo'u mola, na e ka'a to'o mwela ike no'one. Na ko reu oto lo'u urine hunie oolune nga aasine. ");
INSERT INTO apb_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Na lae-lae ko reu oto urine hunie ahutana e hiu mwaasine mwane ngeena. Ahutada kire mani to'o aana a hu'ena, ta'e lae-lae kire mae na a hu'ena ka'a to'o mwela. Oto a hu'ena e si mae ooreta. ");
INSERT INTO apb_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","?Ha'alaa, kei hule aana hai dinge ta'ela'inge, a hu'e ngeena kei ne'i hu'e a tei aana e hiu mwaasine ngeena, aana kire mani to'o aana mola urine?” ");
INSERT INTO apb_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Oto a Jisas ko aalamire uuri, “Ne'isaenga i'omu e tohungei takalo oto hiito'o, aena aana omu ka'a saie ike mo Uusu-uusu Maa'i wa nanamanga a God. ");
INSERT INTO apb_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Maholo mwala kei ta'ela'i mwaanie maenga, nga tola-hu'anga wa nga to'o-poronga ha'ike lo'u. Ta'e kire kei ii'o oto mola mala mo ensel ta'au i Lengi. ");
INSERT INTO apb_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","?Ta'e hatarie ta'ela'inge mwaanie maenga, aana e ue omu ka'a rongo saie nga taa a Mosis e uusue? Maholo a God e ere pe'ie a Mosis i saana kele ai nge e ka'a waru aana dunge, e unue hunie a Mosis uuri, Ineu oto God nge a Ebraham na Aesak na Jekob ko palo-paloa. ");
INSERT INTO apb_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Kie mani saie oto uri mo iini e mauri mola kire ko palo-paloa God. Oto uusu-uusu ie ko haata'inie uri ma'alana Ebraham, na Aesak na Jekob kire mani mae oto, ta'e kire mauri mola ue ta'au i Lengi. !Ne'isaenga i'omu mo Sadiusi ko lae takalo oto hiito'o!” ");
INSERT INTO apb_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Ngaeta ha'a-uusuli aana mo Ha'atolanga a Mosis e ii'o no'one i leune, ko pwaa-pwaarongo i sulie kire ko ere-ere haitelili pe'ie a Jisas. E rongo saie uri a Jisas ko niie mei wala ni aalaminge diana hunie mo Sadiusi, oto ko dolosi aana uuri, “?Nga ha'atolanga uri taa ni oto e roro'a liutaa?” ");
INSERT INTO apb_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Oto a Jisas ko aalamie uuri, “Na'ohai ha'atolanga oto ienini, !Rongo diana aana, i'omu mo Israel! A God, aalaha ikie, ingeie oto ta'a-ta'a God. ");
INSERT INTO apb_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","O ke manata diana hunie a God, aalaha i'oe, oto aana ahutana saemu, na aana ahutana mauriha'amu, na aana ahutana mo ne'isaenga i'oe, na aana ahutana a'aila'anga i'oe. ");
INSERT INTO apb_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","“Oto ruana nga na'ohai ha'atolanga lo'u ienini, O ke manata diana hunie auhenue i'oe oto mala o manata diana huni'o maraamu. Na nga ha'atolanga ka'a liutaa ike lo'u aana e ro ha'atolanga ienini.” ");
INSERT INTO apb_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Oto a ha'a-uusuli ngeena ko te'uri hunie a Jisas, “E to'ohuu oto, Ha'a-uusuli. E to'ohuu oto mala o unue uri ta'a-ta'a God mola e ne'i aalaha, na nga God aaopa lo'u mwaanie ha'ike. ");
INSERT INTO apb_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Oto ikie iinoni kie ke manata diana hunie a God oto aana ahutana saeka, na aana ahutana mo ne'isaenga ikie, na aana ahutana a'aila'anga ikie, na kie ke manata diana no'one hunie mo iinoni, mala kie manata diana hunikie maraaka. Na e tohungei roro'a oto liutaa hunie kie ke lulu i sulie e ro ha'atolanga ie, liutaa aana kie ke uunu ola hunie a God.” ");
INSERT INTO apb_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Oto a Jisas e saie uri aalaminge a ha'a-uusuli ngeena e lae aani saenanaunge, ko si te'uri hunie, “I'oe, o kara'inie oto Aalahanga a God.” Oto i puri, mwala ko si me'u mola huni dolosie lo'u nga mei ola aana a Jisas. ");
INSERT INTO apb_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Oto maholo a Jisas e ha'a-uusulie mwala i laona Nume Maa'i Peine, e dolosie mei dolosinge uuri, “?E ue nge mo ha'a-uusuli aana mo Ha'atolanga a Mosis ko unue uri a Kraes kei hute mola mai aana komu a Deved Inemauri? ");
INSERT INTO apb_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Ta'e a Li'oa Maa'i e unue hunie a Deved ke uusue i sulie a Kraes uuri, A God e unue hunie aalaha ineu, uuri ‘O ke ii'o ka'u i pwalo-pwaloku aana na'ohai ii'o-ii'oha, lai hule aana ne kei kama haahie mo maelonga i'oe i aano hunie o ke uuri puli-pulisire.’ ");
INSERT INTO apb_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","A Deved maraana ni e unue uri a Kraes e ne'i aalaha ingeie. ?Ta'e e ue? ?Mwane nge e hute mola aana komu a Deved maraana, kei he'i ne'i aalaha ingeie lo'u uri taa eena?” Na mwala hunge kire rongoa pe'i ilenimwa'enga. ");
INSERT INTO apb_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Oto a Jisas ko he'i ha'a-uusulie lo'u mwala na ko te'uri, “Omu ke lio talamiu mwaanie mo ha'a-uusuli aana mo Ha'atolanga a Mosis nge kire ko walo liu pe'i to'oni tetewa lauleuni'e ngeena. Aena kire saeto'o aana uri mwala ke ha'apaina'ara maholo kire ko walo liu i laona mo leu ni uusi'e. ");
INSERT INTO apb_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Na kire ko lio hilisie mo na'ohai ii'o-ii'oha i laona mo nume ni palo-palo, na mo na'ohai tolinge aani ngeuhe. ");
INSERT INTO apb_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Ta'e kire ko ha'amwe'u-mwe'ue mola mo nao keni, hule aana kire ko pelie lo'u mo nume ikire mwaanire. Oto kire ko si aarenga'i tewa lo'u i maana mwala hunie mwala ke ne'isae uri ikire mwala maa'i. !Ikire ngeena ha'aloilada kei lae lo'u liutaa!” ");
INSERT INTO apb_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","A Jisas e ii'o i hoorana leu ni nii-nii to'oha i laona Nume Maa'i Peine, oto ko ha'a-ha'amaesie mwala kire ko niie mo niinge ikire. Mwala hunge kire to'o-to'o kire ko niie mei to'oha oto paine. ");
INSERT INTO apb_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Na lae-lae mei nao keni meitale e lae lo'u mei, oto ko niie mola e ro kele peni pulu. ");
INSERT INTO apb_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Oto a Jisas e soie mai mo pwaarongoisuli ingeie, oto ko te'uri hunire, “No ko unue oto huni'omu uri nao keni meitale ienini e nii peine liutaa aana ahutana mwala ko nii ie. ");
INSERT INTO apb_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Aana ahutana mwala ngeena, kire ko niie mola kele nganga'ai ola aana to'o-to'onga ikire. Ta'e mei nao keni meitale ie, kele mei to'oha uri huni meu-meuri aana ingeie oto ko nii mangoa ienini.” ");
INSERT INTO apb_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Aana maholo a Jisas ko iisitaa mwaanie Nume Maa'i Peine, oto ngaeta iini aana mo pwaarongoisuli ingeie ko te'uri hunie, “Ha'a-uusuli, o ke lio ka'u. Mo heri-herine Nume Maa'i Peine ngeena kire tohungei lio diana. Mo heu kire asui'i eeni na kire tohungei peine oto hiito'o.” ");
INSERT INTO apb_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Oto a Jisas ko aalamie uuri, “?O leesie mo heri-herine nume ngeena? Aana nga maholo oho-aasileni kei saro lae, na nga ta'a-ta'a ho heu e sa'a oore ike lo'u aana leu e o'o'o aana.” ");
INSERT INTO apb_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Oto lo'u mola i puri a Jisas e ii'o ta'au i lengine Uuwo Ni Ei Olif aana leu kire sai lio ha'aholo wau hunie Nume Maa'i Peine. Oto a Pita na a Jemes na a Jon na a Andru, kire lae mai maraada i saana. ");
INSERT INTO apb_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","Oto kire ko te'uri hunie, “O ke unue oodoi'emeelu maholo uri taa ni walu ola ngeena kei reu, na nga tolimaa uri taa huni haata'inie uri maholo e kara'ini oto hunie walu olana kei reu.” ");
INSERT INTO apb_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Oto a Jisas ko aalamire uuri, “Omu ke lio talamiu mwaanie nga iini e eero'omu. ");
INSERT INTO apb_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Aena aana mo iini hunge kire kei lae mai aana sataku, na kire kei te'uri, ‘Ineu oto a Kraes,’ na kire kei ha'apweue mwala hunge. ");
INSERT INTO apb_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Na omu kei rongoa mo oohotaa aana ta'ena nga leu aana walumalau, ta'e mwaanie saemiu e liki-liki. Aena aana walu ola ngeena kire kei hola'i reu i na'o, ta'e ha'amangolana walumalau ha'ike ue ni ngeena. ");
INSERT INTO apb_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Haiseuninge kei lae i matolana mo henue hai aaopa'i, na i matolana mo aalahanga hailiu. Hiolonga kei toolea mo iini hunge i laona walumalau, na nunu kei tola ahusie mo henue hunge. Ta'e walu ola ienini ko haata'inie mola uri mo ola paine kei lae ue mai mala hu'e ko aehota hiinge'inie sapesalunge hunie to'o-mwelanga. ");
INSERT INTO apb_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Oto omu ke lio talamiu aena aana mwala kei toole'omu i laona leinge, na kire kei repusi'omu no'one i laona mo nume ni palo-palo, aena aana omu ko lulu i sulieu. Na kire kei toole'omu i na'ona mwala paine na mo inemauri haahie asunge ineu, hunie kire kei lei'omu. Aana maholo walu olana kei reu uurini, maholo i'omu otona huni unu diana aana Tataroha Diana hunire. ");
INSERT INTO apb_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Aana taroha'inilana Tataroha Diana kei hola'i lae hunie ahutana mwala aana walumalau, hai dinge ooreta ke si lae mai. ");
INSERT INTO apb_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Na maholo mo ramo kei tapoli'omu huni toole'omu i laona leinge, omu ke su'uri tolahi'e oto hiito'o aana nga taa omu kei unue. Aana maholona, omu ke unu tahanga'inie mo ne'isaenga i laona manatamiu, aena aana omu sa'a ere tohumiu ike, ta'e Li'oa Maa'i ni kei hatonga'i huni'omu ngeena. ");
INSERT INTO apb_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Aana maholona kei tohungei aaela huni'omu to'ohuu, aana mwala kei niie mo eeside maraada hunie horo'ilada, na mo mama'a kire kei deu urine no'one aana mo mwela ikire, na mo mwela no'one kire kei ta'ela'i honosie mo meu'ana ikire huni horo maesire. ");
INSERT INTO apb_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Na ahutana mwala kei teunge'ini'omu aena aana omu ko lulu i sulieu. Ta'e iini nge kei uure a'aila'a tara'asi aani hiiwalaimolinge lai hule aana ha'amangolana, nge a God ke si ha'a-uurie.” ");
INSERT INTO apb_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","(Mo iini nge kire saaie walana a Jisas i sulie tata'alanga ie, kire ke lo'onga'i diana i sulie hunie kire ke rongo saie lo'onga'inge aana.) Oto a Jisas ko he'i te'uri lo'u, “Omu kei leesie mei ola aaela liutaa nge ko esuie na'onga hunie mo henue. Mei olana kei uure i laona Nume Maa'i Peine a God, leu e ka'a malisine ike uri ke uure aana. Aana maholona mwala wau i Jiudia kire ke tahi takoie mo toloi henue, hunie kire ke lai mumuni. ");
INSERT INTO apb_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Na mala nga iini e ii'o ta'i koluhana nume ingeie, nge ke tahi oto na ke su'uri waelie lo'u nga maholo huni lai toolea nga mo ola ingeie hai nume. ");
INSERT INTO apb_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Na mala nga iini ko eu'esu i hohola, ke tahi oto na ke su'uri waelie lo'u nga maholo huni lai toolea nga mo to'oni ingeie mai nume. ");
INSERT INTO apb_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Na aama-aamasilana mo hu'e ko hi'e-hi'e aani mwela, na mo iini nge kire ko ha'a-ha'asusuhie ue mo wee-wee ikire. ");
INSERT INTO apb_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Ta'e omu ke aarenga'i mola hunie walu ola ngeena ke su'uri hule aamiu aana maholo e aasa aana mo waro-waro ni wawai. ");
INSERT INTO apb_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Aana si'oha'anga kei tola aana maholona, kei peine liutaa aana lo'u ta'ena nga ola ko totola uure oto mai aehotalana walumalau hule mai aana mo dingena. Na e sa'a he'i aaela lo'u urine aana nga dinge. ");
INSERT INTO apb_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Mala uri a God ka'a holo o'oru'e aana maholo ni si'oha'anga ngeena, nge nga iini sa'a mauri ike lo'u. Ta'e i sulie a God e lo'onga'inie mo iini nge e lio hilisire oto, nge mone kei holo o'oru'e aana maholona. ");
INSERT INTO apb_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Oto aana maholona mala uri nga iini ko unue huni'omu, ‘!Lio ka'u! A Kraes oto ie,’ wa ‘!Lio ka'u! Ingeie oto waune,’ ta'e omu ke su'uri hiiwalaimoli aana. ");
INSERT INTO apb_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Aena aana mo kraes eero-eero na mo propet eero-eero hunge kire kei lae mai. Na mala ko mwada'u, kire kei ha'atakaloa mo iini nge a God e lio hilisire oto. Kire kei haata'inie mo tolimaa na mo hu'i-hu'ite aana mwala, ta'e mwaanie omu hiiwalaimoli aada. ");
INSERT INTO apb_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Aena urine, nge no ko hola'ina'o ha'apasuli'omu oto aana walu olana, hunie omu ke lio diana talamiu.” ");
INSERT INTO apb_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Oto a Jisas ko he'i te'uri lo'u, “Oto lo'u mola i purine mo dinge ni si'oha'anga ngeena, sato kei ulue oto maana, na e sa'a pwaa lo'u. Waro-waro e sa'a he'i sineli lo'u. ");
INSERT INTO apb_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Na mo hee'u ta'au i laona salo kei teke i aano, na ahutana mo ola ta'au i laona salo kei hei-oolisi mango. ");
INSERT INTO apb_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Oto puriha'ana, mwala kei leesieu oto a Kale Ni Iinoni, ne kei lae oto mai i laona mei uuru pe'ie nanamanga paine na manikulu'anga. ");
INSERT INTO apb_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Na aana maholona, ne kei uusunge'inie mo ensel hunie kire ke lae aana e hai su'u-su'ue aana walumalau, huni so'okonie mo iini nou lio hilisire mwaanie e hai maai dengi aana walumalau, uure aana ngaeta ngongo'ai welumalau lai hule aana ngaeta ngongo'ai welumalau.” ");
INSERT INTO apb_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Oto a Jisas ko he'i te'uri lo'u, “Saeku omu ke rongo saie erenga ni aalahuunge ie i sulie ai fik. Maholo mo sasarana ko aehota ure na ure-urana ko maau, nge omu saie oto uri maholo hunie mo waro-waro ni madoro e kara'ini oto mai eena. ");
INSERT INTO apb_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Na e urine no'one aana maholo omu kei leesie walu ola ienini ko reu uurini, omu ke si manata'inie uri e kara'inie oto maholo no ko ere i sulie ni ngeena. ");
INSERT INTO apb_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","No ko unue oto huni'omu uri walu ola ienini kei saro oa mango mola ue oodoie mwala aana pwaunge si'iri ie na kire ka'a mae ue. ");
INSERT INTO apb_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","I Lengi na i aano kei suu, ta'e walaku e sa'a suu ike oto oo'oo.” ");
INSERT INTO apb_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","A Jisas e unue no'one uuri, “Nga ta'a-ta'a iini e ka'a saie ike hai dinge wa maholoi sato uri taa ne kei ooli lo'u mei. Ma'alana mo ensel ta'au i Lengi, wa uri ineu a Kale, na melu ka'a saie ike. Ta'e a Mama'a ta'au i Lengi hali'ite nge e saie maholona. ");
INSERT INTO apb_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Aena urine, omu ke lio talamiu na omu ke dau aakau taraure'i suli maholo, aena aana omu ka'a saie ike maholo ne kei ooli lo'u mei. ");
INSERT INTO apb_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Aena aana kei urihana, mwane e lae mwaanie nume ingeie hunie ngaeta hanue. Oto e ne'ie mo mwane au'esu ingeie hunie kire ke lio i sulie nume, na e niie mo esunge hai aaopa'i hunie mwala au'esu ingeie, oto e si unue hunie kakalihe hunie ke kakali diana. ");
INSERT INTO apb_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Na e urine lo'u mola huni'omu, omu ke lio-lio na omu ke dau-deu aakau diana. Aena aana omu ka'a saie ike maholo nge mwane e to'o aana nume kei hule, mwaanie ohe i seulehi, wa i upui rodo, wa i wa'alie, wa i maahu'o-hu'o. ");
INSERT INTO apb_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Mwaanie da na e tolana hule mola lau-leu, na e lae mola mai leesie omu ko ma'ahu liu. ");
INSERT INTO apb_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Oto nga taa no ko unue huni'omu ienini, no ko unue no'one hunie ahutana mwala. Dau aakau suli maholo.” ");
INSERT INTO apb_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Oto Houlaa Ni Liumwaanie e kara'ini oto. (Houlaa ngeena kire haara'inie no'one uri Houlaa Ni Bred Iis Ha'ike Aana.) Oto e ro hai dinge mola i na'ona houlaa ngeena, na mo na'ohai pris na mo ha'a-uusuli aana mo Ha'atolanga a Mosis kire mani loko, oto kire ko heitalea nga tala mumuni huni pweloa a Jisas huni horo maesie. ");
INSERT INTO apb_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Ta'e kire unue uuri, “Kolu sa'a tapolie ike aana maholo mwala kei loko hunie houlaa, mwaanie kire maaola-ola i tehula'ana.” ");
INSERT INTO apb_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Maholona na a Jisas e ii'o wau aana huilume i Betani i nume a Saemon, iini nge maelaa ni osa e hite aana ka'u wai na'o. Oto maholo a Jisas ko ngeu i leune, ngaeta keni e lae mai saana. A keine e toolea mai ho ate'a diana e honu aana rumu e wasu mangoni, na holitana e paine. Oto e tahanie na ko lingisie oto i pweune a Jisas. ");
INSERT INTO apb_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Maholo ngaeta mwala i leune kire leesie, oto kire ko saewasu na kire ko ere hailiu i matolada uuri, “?E ue a keni ngeena ko si waeta'inie mola ho rumu diana urine? ");
INSERT INTO apb_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Mala uri ke ha'aholinge'inie, ha'alaa e sai terie mei to'oha e sada aana waaitana nga mwane au'esu hunie halisi leku. Na e malisine mei to'oha aana ke niie hunie kira maitale.” Na kire ko tohungei ere aaelasie a keine oto hiito'o. ");
INSERT INTO apb_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Ta'e a Jisas e te'uri hunire, “!Ei! ?Omu ko kotahie huni taa? !Toli'aasie mola! Tohungei mei ola diana ni ko esuie hunieu ie. ");
INSERT INTO apb_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Kira maitale kire ko o'o'o pe'i'omu oto tarau, na omu sai pe'ire mola aana ta'ena nga maholo. Ta'e ineu nou sa'a ii'o tewa ike lo'u pe'i'omu. ");
INSERT INTO apb_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","A keni ngeena e asuie tohungei mei ola diana hunieu, aana e huie rumu wau-wesu haahie sapeku oto lalai loosie maholo kire kei heitolinge'inieu ni ngeena. ");
INSERT INTO apb_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","No ko unue oto huni'omu uri ta'e-ta'ena nga leu i laona walumalau nge laeliwalanga aana Tataroha Diana kei lae-lae aana, unulana mei ola a keni ie ko esuie ngeena kei lae-lae huni aamasito'onga aana.” ");
INSERT INTO apb_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Oto a Jiudas Iskariot, ngaeta iini aana aawalai pwaarongoisuli mwana rue, e iisitaa, ko si lae i saana mo na'ohai pris huni pweloa Jisas hunire. ");
INSERT INTO apb_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Mwala paine ngeena kire ko tohungei saemango huni rongoa nga taa e unue, na kire ko heiholota'i oto huni nii to'oha nana. Oto uure aana maholona a Jiudas ko aehota lio hunie nga maholo huni pweloa a Jisas hunire. ");
INSERT INTO apb_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Oto e hule aana eetana nga hai dinge aana Houlaa Ni Bred Iis Ha'ike Aana, na dinge ngeena oto dinge huni horo'ie mo kalei sipu hunie ngaunge aana Liumwaanie. Oto mo pwaarongoisuli a Jisas kire ko dolosi aana uuri, “?O saeto'o aana uri melu ke dau aakau aana ngaunge aana Liumwaanie huni'o i tei?” ");
INSERT INTO apb_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Oto a Jisas ko uusunge'inie ngaeta ro iini hikada, na ko te'uri hunirerue, “More ke lae i laona huilume paine i Jerusalem ngeena, na nga mwane e aanga'inie ho ate'a aani wei kei oodoi'omore'i. Oto more ke lae oto i sulie ");
INSERT INTO apb_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","ta'i nume nge kei lai sili aana. Oto more ko te'uri hunie mwane nge e to'o aana numena, ‘A Ha'a-uusuli e unue uri o ke haata'inie aamere'i duru nge kei hele aana ngaunge aana Liumwaanie pe'ie mo pwaarongoisuli ingeie.’ ");
INSERT INTO apb_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","A mwane ngeena ke si haata'inie duru peine ingeie ta'au i lengi aamore'i, iini kire dau aakau oto aana. Nge more kei deu aakau aana mo ola hunikolu i leune.” ");
INSERT INTO apb_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Oto e ro pwaarongoisuli kire taule'i, kire ko lae oto wau i Jerusalem, na kire ko lae oodoie oto ahutana walu ola, mala a Jisas e unu'i hunire. Oto kirerue ko deu aakau oto aana mo ola hunie ngaunge aana Liumwaanie. ");
INSERT INTO apb_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Oto i seulehi, a Jisas e lae mai hule i nume pe'ie aawalai pwaarongoisuli mwana rue. ");
INSERT INTO apb_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Na maholo kire ko ngeu oto, a Jisas ko si te'uri, “No ko unue oto to'ohuu huni'omu uri nga iini hikemiu nge ko ngeu pe'ieu oto molana kei pweloau.” ");
INSERT INTO apb_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Oto kire ko tohungei hii aaela, na kire ko meni aehota dolosi oto aana uuri, “?Mwaanie ohe ineu?” ");
INSERT INTO apb_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Oto a Jisas ko te'uri hunire, “Ingeie oto ngaeta iini eemiu aawala mwana rue nge ko toonga'inie mei bred tararuru pe'ieu i laona nime si'iri. ");
INSERT INTO apb_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Ineu a Kale Ni Iinoni ne kei mae taane oto mala mo Uusu-uusu Maa'i e unue. Ta'e aama-aamasilana a mwane ngeena nge kei pweloau a Kale Ni Iinoni, aana kei lae otoi diana hunie iinoni ngeena mala uri ke su'uri hute.” ");
INSERT INTO apb_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Oto maholo kire ko ngeu ngeena, a Jisas e hele aana ho bred, oto ko ere ni paalahenga, ko si nisie, na ko ha'a-adoa mo pwaarongoisuli aana. Oto ko te'uri, “Hele aana. Ngaue. Hasi'oku nge ienini.” ");
INSERT INTO apb_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Oto e hele aana lo'u kao-kaoi waen, na ko ere ni paalahenga, oto e niie hunire, na ahutada kire mani inu aana. ");
INSERT INTO apb_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Oto a Jisas ko te'uri, “Apuku oto ienini nge e aahe i tehula'ana mwala hunge, na mei epu nge ko ha'a-oaie haiholota'inge haalu a God ko esuie pe'ie mo iinoni ingeie. ");
INSERT INTO apb_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","No ko unue oto huni'omu uri nou sa'a inuhie lo'u nga mei waen lai hule aana ne kei inuhie waen haalu i laona Aalahanga a God.” ");
INSERT INTO apb_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Oto kire kanalie kana maa'i, nge kire si lae mwaanie hanuena huni hanetaa hunie Uuwo Ni Ei Olif. ");
INSERT INTO apb_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Oto a Jisas ko te'uri hunire, “Ahutemiu, omu kei meni tehi mwaanieu. Aana i laona mo Uusu-uusu Maa'i a God e unue uuri, Ne kei horo'ie a kakali sipu, oto mo sipu kei tatanga hailiu oto. ");
INSERT INTO apb_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Ta'e i purine ne kei ta'ela'i lo'u mwaanie maenga, ne kei lae i na'omiu huni maa'oohi'omu oto hao aana po'o ni henue i Kalili.” ");
INSERT INTO apb_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Oto a Pita ko aalamie uuri, “Ineu nou sa'a roro'a ni toli'aasi'o ike, ma'alana ahutana mo mwane ngeena kire ko tehi mwaani'o.” ");
INSERT INTO apb_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Oto a Jisas ko te'uri hunie a Pita, “No ko unue oto huni'o uri i na'ona kue kei ngara ha'arue i rodo si'irini, o kei taateinge'inieu ha'a-oolu uri o ka'a manata'inieu ike.” ");
INSERT INTO apb_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Ta'e a Pita ko tohungei ere a'aila'a oto uuri, “Ineu nou sa'a roro'a ni ere ike urine, ma'alana no ko mae pe'i'o.” Na ahutana mo pwaarongoisuli kire ko meni ere oto no'one urine. ");
INSERT INTO apb_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","A Jisas na mo pwaarongoisuli ingeie kire lai hule aana leu satana i Ketsemani. Oto a Jisas ko te'uri hunire, “Omu ke ii'o ka'u i leu, maholo no ko lai aarenga'i.” ");
INSERT INTO apb_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Oto e toolea a Pita na Jemes na Jon pe'ie, na ko si aehota tolahi'e hiito'o pe'ie saehuunge oto paine. ");
INSERT INTO apb_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Oto a Jisas ko te'uri huniraelu, “Saeku ko lae otoi hi'e na e malisine oto maenga. Omu ke ii'o ka'u i leu na omu ke lio-lio.” ");
INSERT INTO apb_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Oto a Jisas ko kele lae lo'u ta'au mwaanire, na ko lae pouruuru i aano haahie maana, na ko aehota aarenga'i uri mala ko mwada'u sapesalunge ngeena ke su'uri hite aana. ");
INSERT INTO apb_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Oto ko eitanaie a God uuri, “Mama'a, iiola o niie mai hunie ne ke hotela'inie ko aasaieu oto. Mala ko mwada'u, aana nou saie walu ola e mwada'u mola huni'o, oto saeku o ke oolisie aana nga iini mwa-mwate. Ta'e ne'ewau oto, o ke dau mola i sulie nga taa o saeto'o aana, na o ke su'uri deu i sulie nga taa nou saeto'o aana.” ");
INSERT INTO apb_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Oto a Jisas e aaliho'i lo'u mei saana oolu pwaarongoisuli, na ko leesie kire ko ma'ahu mola. Oto ko te'uri hunie a Pita, “?E Saemon, uri o ko ma'ahu mola? ?Ohe o ka'a sai lio-lio ike pe'ieu nga kele maholoi sato?” ");
INSERT INTO apb_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Oto a Jisas ko he'i te'uri lo'u hunire, “Omu ke lio-lio pe'i aarenga'inge, mwaanie malaahonga e hane haahi'omu. Nou saie uri manatamiu e a'aila'a taane huni esuie mo ola diana, ta'e sapemiu ni mola ko tataku.” ");
INSERT INTO apb_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Oto a Jisas ko he'i eeliho'i lo'u huni aarenga'i, na ko ooni aana lo'u mola ta'a-ta'a taungei aarenga'inge. ");
INSERT INTO apb_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Oto ko he'i ooli lo'u mei i saana mo pwaarongoisuli ingeie, na ko leesie kire ko ma'ahu lo'u mola, i sulie maada e hi'e oto hiito'o. Na maholo kire lio lo'u, kire ka'a saie ike lo'u nga taa kire kei unue hunie. ");
INSERT INTO apb_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Oto i purine oolune nga maai aarenga'inge, e aaliho'i lo'u mei saada, oto ko te'uri hunire, “?Uri omu ko ma'a-ma'ahu, na omu ko mamamalo ue? !E ado oto! E hule oto aana maholo kire kei pweloau a Kale Ni Iinoni i nimana mo iinoni ooraha'aala. ");
INSERT INTO apb_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","!Omu ta'ela'i! !Kolu ke lae! !Lio ka'u! Iini nge ko pweloau ko hule oto.” ");
INSERT INTO apb_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Oto maholo a Jisas ko ere-ere ue, na a Jiudas Iskariot ko hule oto pe'ie pulitaa paine, mo iini nge mo na'ohai pris na mo ha'a-uusulie aana mo Ha'atolanga na mo rato ni mwane kire uusunge'inire mai pe'ie. Mwala ngeena kire mani hele naihi pe'i di'e, ");
INSERT INTO apb_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","na a Jiudas e unu aakau oto aana nga tolimaa hunire uuri, “Iini nge ne kei nono pe'ie, a Jisas otona. Ingeie oto omu ke tapolie na omu ke toolea.” ");
INSERT INTO apb_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Oto a Jiudas ko oodohie oto a Jisas, na ko unue hunie uuri, “Ha'a-uusuli.” Na ko nono oto pe'ie. ");
INSERT INTO apb_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Oto kire tapolie a Jisas na kire ko hele ma'uta'a oto aana. ");
INSERT INTO apb_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Ta'e ngaeta iini e uure i leune e darasie naihi ingeie, oto ko lama mousie oto aalingana ngaeta koni-konihe a Na'ohana Mo Na'ohai Pris. ");
INSERT INTO apb_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Ta'e a Jisas ko te'uri hunire, “?Uri omu unue ineu nga horopeli nge omu ko lae mai honosieu pe'i naihi na pe'i di'e urine? ");
INSERT INTO apb_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Ahutana dinge ka'u no ko talei o'o'o mola pe'i ha'a-uusulinge ta'au i laona Nume Maa'i Peine. ?Aana e ue ka'u omu ka'a tapolieu oto aana maholona? Ta'e ahutana mo ola ienini ko reu oto huni ha'a-oaie nga taa mo propet e uusue i laona mo Uusu-uusu Maa'i.” ");
INSERT INTO apb_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Oto ahutana mo pwaarongoisuli kire si toli'aasie a Jisas, na kire ko meni tehi oto mwaanie. ");
INSERT INTO apb_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Ngaeta iini nge e lae i sulie a Jisas aana maholona nga saanau nge e ho'osie mola mei sala mwaakule. Mo ramo ko sare tapolie no'one, ");
INSERT INTO apb_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","ta'e e toli'aasie mola mei sala ingeie, oto e si tehi mola mwaakule mwaanire. ");
INSERT INTO apb_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Oto kire toolea a Jisas ta'au i nume a Na'ohana Mo Na'ohai Pris. Maholona mo na'ohai pris, na mo rato ni mwane, na mo ha'a-uusuli aana mo Ha'atolanga a Mosis, kire mani loko aakau oto ta'au i laona nume ngeena. ");
INSERT INTO apb_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Oto a Pita ko holo maholoi tala taane mola i sulire. E lae ta'i sili i laona lolata aana nume a Na'ohana Mo Na'ohai Pris, oto e ii'o i aano pe'ie mo mwane ko kakakali, ko si rakani aana dunge. ");
INSERT INTO apb_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Oto mo na'ohai pris na ahutana oto pulitaa ni lei-lei kire ko meni heitalenga'inie nga mo ola huni eerota'inie a Jisas huni horo maesie haahie. Ta'e kire ka'a dau oodoie ike nga mei ola. ");
INSERT INTO apb_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Mwala hunge kire ere aaelasie a Jisas aani eeronga, ta'e kire ko meni ere hai aaopa'i mola, na mo laladonga ikire ka'a sada. ");
INSERT INTO apb_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Oto lae-lae ngaeta mo mwane kire uure, kire ko eerota'inie a Jisas uuri, ");
INSERT INTO apb_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Melu rongoa e unue uuri, ‘Ne kei ohoie Nume Maa'i Peine nge mwala kire asuie ie, na i laona oolu aata hai dinge ne kei esuie lo'u nga iini haalu nge nga iinoni sa'a asuie ike.’” ");
INSERT INTO apb_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Ta'e ma'alana kire ko ere urine, ta'e mo ere-erenga ikire ka'a mani sada ike. ");
INSERT INTO apb_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Oto Na'ohana Mo Na'ohai Pris e uure i na'oda, ko si dolosi aana a Jisas uuri, “?E ue? ?Uri o ka'a to'o aana ike nga mei ola huni aalamie mo ola nge kire ko ere waeli'o aani ngeena?” ");
INSERT INTO apb_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Ta'e a Jisas e tolirohu mola. Oto Na'ohana Mo Na'ohai Pris ko dolosi lo'u aana a Jisas uuri, “?Ohe i'oe ni oto a Kraes, Kalena God, iini e diana liutaa?” ");
INSERT INTO apb_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Oto a Jisas ko aalamie uuri, “Ineu ka'u otona. Na aana nga maholo omu kei meni leesieu a Kale Ni Iinoni ne kei ii'o aana na'ohai ii'o-ii'oha i pwalo-pwalona God Hahu'ana Nanama, na kei lae mai i laona mei uuru uure ta'au i salo.” ");
INSERT INTO apb_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Oto Na'ohana Mo Na'ohai Pris ngeena ko a'arie to'oni ingeie, aana ko tohungei saewasu, na ko te'uri, “!Ngeena kolu ka'a saeto'o aana ike lo'u nga iini ke ere takoie! ");
INSERT INTO apb_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Omu meni rongoa oto maraamiu uri e ere mwakata'inie a God. ?Ha'alaa nga taa nge omu kei unue aana?” Oto kire ko meni aalamie uuri, “!E malisine oto ke mae!” ");
INSERT INTO apb_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Oto ngaeta mwala ko aehota ngisuhie oto a Jisas. Na ngaeta mo iini kire ko pwesu honosie maana, oto kire ko si hidelie, na kire ko te'uri, “O ke unue ka'u uri a tei e hideli'o huni haata'inie uri i'oe propet to'ohuu.” Oto mwala kakakali kire toolea a Jisas, na kire ko hidelie no'one. ");
INSERT INTO apb_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","A Pita e ii'o mola i laona lolata aana nume nge kire ko leie a Jisas aana, na ngaeta keni au'esu a Na'ohana Mo Na'ohai Pris ngeena e lae poi tapaliu. ");
INSERT INTO apb_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Maholo a keine e leesie a Pita ko rakani aana dunge, oto ko lio hahuroto aana, na ko te'uri hunie, “I'oe o lae-lae no'one pe'ie a Jisas mwane ni Nasaret.” ");
INSERT INTO apb_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Ta'e a Pita ko taateinge'inie, na ko te'uri, “Nou ka'a saie ike nga taa o ko ere i sulie.” Oto e ta'ela'i, ko lai uure wau i aena maa aana para ahuie lolata ngeena. Na maholona kue ko ngara oto. ");
INSERT INTO apb_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Oto keni au'esu ngeena, ko leesie lo'u weu a Pita na ko ooni aana mei walana lo'u hunie mwala nge kire uure ngeena, ko te'uri, “Ingeie ngaeta iini oto aada ni ngeena.” ");
INSERT INTO apb_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Ta'e a Pita ko he'i taateinge'inie lo'u. E ka'a tewa lo'u na ngaeta mwala nge kire uure ngeena, kire ko te'uri hunie a Pita, “Sa'a mola i'oe ngaeta iini oto aada, i sulie i'oe no'one mwane ni Kalili.” ");
INSERT INTO apb_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Oto a Pita e ere ni ho'asinge ko te'uri, “!To'ohuu oto mala God ta'au i Lengi! !Nou ka'a manata'inie ike mwane nge omu ko unue ngeena!” ");
INSERT INTO apb_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Oto mola aana maholona, kue ko he'i ngara lo'u ruana nga ngaranga. Hoe, a Pita ko aamasito'o aana mei wala nge a Jisas e unue uuri, “I na'ona kue kei ngara ha'arue i rodo si'irini, o kei taateinge'inieu ha'a-oolu uri o ka'a manata'inieu ike.” Oto a Pita e si saie mola uri mei walana e oa oto, ko si ngara oto paine. ");
INSERT INTO apb_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Oto i maahu'o-hu'o na e ka'a dangi kohi ue, mo na'ohai pris pe'ie mo rato ni mwane na mo ha'a-uusuli aana ha'atolanga na ahutana pulitaa ni lei-lei, kire oala'inie oto nga taa kire kei esuie aana a Jisas. Oto kire pwasue a Jisas, kire si toolea, na kire ko lai toli'aasie oto i nimana a Paelat. ");
INSERT INTO apb_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Oto a Paelat ko dolosi aana Jisas uuri, “?Uri i'oe ni oto Inemauri mo Jiu?” Oto a Jisas ko aalamie uuri, “Nge ka'u oto o ko unuena.” ");
INSERT INTO apb_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Na mo na'ohai pris kire ko ere waelie a Jisas oto aana mo ola hunge. ");
INSERT INTO apb_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Oto a Paelat ko he'i dolosi lo'u aana Jisas uuri, “?E ue ni o ka'a aalamire? O saie ka'u mola kire ko tohungei ere waeli'o ngeena.” ");
INSERT INTO apb_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Ta'e a Jisas e ka'a ere ike lo'u. Oto a Paelat ko tohungei pangata'i oto hiito'o. ");
INSERT INTO apb_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Suli helisi aana maholo Houlaa Ni Liumwaanie, a aalaha ni Rom ngeena e sai luhesie ta'ena nga iini mwala ko ha'atohue mwaanie nume ni ho'o. ");
INSERT INTO apb_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Aana maholona, ngaeta mwane satana a Barabas kire ne'ie i nume ni ho'o i sulie ingeie nga iini aana mo iini nge kire horo maesie ngaeta mwala aana maholo kire haiseuni huni ta'aasie aalahanga ni Rom mwaanie i Israel. ");
INSERT INTO apb_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Oto mwala kire ruru mei saana a Paelat na kire ko aehota ha'atohu aana uri ke luhesie nga iini mwaanie nume ni ho'o oto mala ko eu'esuie suli helisi. ");
INSERT INTO apb_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Oto a Paelat ko dolosi aada uuri, “?Ohe omu saeto'o aana Inemauri mo Jiu nge ne ke luhesie huni'omu?” ");
INSERT INTO apb_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","E ere mola urine aena aana e saie uri mo na'ohai pris kire niie mola a Jisas hunie aena aana kire ko upwesie. ");
INSERT INTO apb_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Ta'e mo na'ohai pris kire ko unue hunie mwala hunie kire ke unue hunie a Paelat uri ke luhesie mola a Barabas. ");
INSERT INTO apb_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Oto a Paelat ko dolosi lo'u aana mwala uuri, “?Ko urine, nga taa ka'u ne ke si da aana mwane nge omu haara'inie Inemauri mo Jiu?” ");
INSERT INTO apb_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Oto kire ko si meni tea paine mola uuri, “!Horo maesie i lengine po'u-po'u!” ");
INSERT INTO apb_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Oto a Paelat ko he'i dolosi lo'u aada uuri, “?Aana e ue? ?Ha'alaa nga mei taa nge e dau aaelasie?” Ta'e kire ko si tea paine mola uuri, “!Horo maesie i lengine po'u-po'u!” ");
INSERT INTO apb_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","A Paelat e sare ha'asaediana'aa mola mwala, oto e luhesie mola a Barabas hunire. Na e unue hunie mo ramo uri kire ke hola'i wini-winie a Jisas, nge kire ke si horo maesie i lengine po'u-po'u. ");
INSERT INTO apb_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Oto mo ramo kire toolea a Jisas i laona lolata ahuie toohi peine a Paelat. Kire si soie mai ahutana mo ramo aana pulitaa ikire, na kire mani ruru i saana a Jisas huni ha'amwasi aana. ");
INSERT INTO apb_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Oto kire ha'ato'onie a Jisas aana to'oni tetewa nonoro'a mala mo aalaha ko ho'o-ho'osi'i, na kire asuie rorodara aani walo kau-keu, kire si ne'ie i pweune. ");
INSERT INTO apb_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Oto kire ko si ha'a-ha'amwasi aana, kire ko te'uri, “Lahea inemauri mo Jiu.” ");
INSERT INTO apb_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Na kire ko pou-pouruuru honosie pe'i aala pwaunge hunie, na kire ko reu-repusie pwaune aana mai rade, na kire ko ngi-ngisuhie. ");
INSERT INTO apb_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Maholo kire ha'a-ha'amwasi mango aana a Jisas urine, oto kire ko si ta'aasie to'oni nonoro'a mwaanie, na kire ko ha'ato'onie lo'u aana mo to'oni ingeie. Oto kire ko si toolea i sinaha huni lai horo maesie i lengine po'u-po'u. ");
INSERT INTO apb_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Maholo kire ko toolea ta'au a Jisas i sulie tala mwaanie i Jerusalem, na kire ko oodoie mwane satana a Saemon, ko si hule mola uure i me'esu. (A Saemon mwane ni Saerin, na ingeie aamana Aleksanda na Rufas.) Oto mo ramo kire ko deu rarahie hunie ke aanga'inie po'u-po'u a Jisas. ");
INSERT INTO apb_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Kire toolea a Jisas takoie leu satana Kolkota, nge sailana uuri, “Leu ni rarata.” ");
INSERT INTO apb_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Na i leune kire ko niie waen hunie, ola kire pwaie pe'ie ai satana mur, ola huni ta'aasie salunge. Ta'e a Jisas ka'a inuhie ike. ");
INSERT INTO apb_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","25","Oto mo ramo kire ko uie oto a Jisas i lengine po'u-po'u aana siwana nga maholoi sato i ho'owa. Na kire ko oopaa mo to'oni ingeie i matolada hailiu, na kire ko inie daes huni leesie uri a tei kei toolea nga mei sala aana to'oni ingeie. ");
INSERT INTO apb_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Na mei wala kire uusue i pweune po'u-po'u huni haata'inie nga taa kire unue e dau aaelasie. Kire uusue uuri, INEMAURI MO Jiu KA'U IE. ");
INSERT INTO apb_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Na kire uie ngaeta ro mwane horopeli no'one pe'ie a Jisas, nga iini i pwalo-pwalona na ngaeta iini i meu-meuline. ");
INSERT INTO apb_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Na Uusu-uusu Maa'i ko oa oto aana e ere uuri, Iidumilana kei lae pe'ie mo iini nge ko waelie mo ha'atolanga. ");
INSERT INTO apb_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Na mwala kire ko liu i sulie tala, kire ko teile'i pweu mwaanie a Jisas pe'i ha'amwasinge aana uuri, “!Nge ka'une! I'oe, ni o unue uri o kei ohoie Nume Maa'i Peine, na uri o kei esu eeliho'i lo'u mola aana i laona oolu hei dinge. ");
INSERT INTO apb_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","!Hoe! O ke siho ka'u mei mwaanie po'u-po'u na o ke ha'a-uuri'o maraamu.” ");
INSERT INTO apb_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Mo na'ohai pris na mo ha'a-uusuli aana mo Ha'atolanga a Mosis, kire ko ha'amwasi aana a Jisas no'one mala ahutana mwala. Na hule aana kire ko te'uri hunire maraada, “E roro'a ha'a-ha'a-uurie ka'u mwala aaopa, ta'e e sa'a ha'a-uurie ike maraana. ");
INSERT INTO apb_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Kolu ke lio-lio ka'u ohe kolu ko leesie inemauri mo Jiu ie ko siho mai mwaanie po'u-po'u. Nge kei urine ha'alaa kolu ke si hiiwalaimoli aana uri ingeie a Kraes.” E ro mwane nge kire uirerue no'one pe'ie a Jisas, kire ko tohungei ere aaelasie no'one. ");
INSERT INTO apb_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Oto i upui aatowaa, rodohono e dau haahie ahutana hanue hunie e oolu maholoi sato. ");
INSERT INTO apb_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Na aana oolune nga maholoi sato i aapau, a Jisas e si soi oto paine aana erenga ni Jiu uuri, “?Eloi, Eloi, lama sabaktani?” nge ne'isaenga aana uuri, “?God ineu, God ineu, e ue oto o aatopuri eeku?” ");
INSERT INTO apb_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Oto ngaeta mo iini aana mwala e uure-uure i leune kire rongo, kire ko te'uri, “!Rongo ka'u! Ko soie a Elaeja.” ");
INSERT INTO apb_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Oto ngaeta iini aada e huru pe'ie mei loi-losi, e ha'ahonue aana waen aha'i, ko susu'ie aana mai ei, oto ko susue'inie ta'au hunie ngidune a Jisas hunie ke inu, na ko te'uri, “Oto kolu ke maa'oohi ke'u. Ohe kolu ko leesie a Elaeja ko lae mai oohosie mwaanie po'u-po'u.” ");
INSERT INTO apb_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Oto a Jisas e si soi oto paine, na ko mae oto. ");
INSERT INTO apb_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Oto mola aana maholoi satona, sala kire lohea honosie Hahu'ana Leu Maa'i i laona Nume Maa'i Peine e a'ari hunie e ro aapa, uure oto ta'i lengi lai hule oto hai aano. ");
INSERT INTO apb_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Na'ohana mo ramo ni Rom e uure-uure i saana po'u-po'u, na e leesie ahutana walu ola e rau aana maholo a Jisas e mae, oto ko te'uri, “A mwane ie Kalena God oto to'ohuu.” ");
INSERT INTO apb_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Ngaeta mo keni kire uure no'one wau ha'atau mwaanie po'u-po'u, kire ko ha'a-ha'amaesie nga taa ko reu. Ngaeta mo iini aada nge kira Meri ni Makdala, na a Salome, na a Meri (nikana a Jemes Saanau na a Josep). ");
INSERT INTO apb_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Mo keni ngeena kire lae-lae pe'ie a Jisas aana maholo e o'o'o wau i Kalili, na kire pe'i-pe'ie. Mo keni hunge kire lae no'one mai pe'ie hunie i Jerusalem, ikire no'one i leune aana maholona. ");
INSERT INTO apb_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Walu ola ienini e rau aana hai dinge ni deu-aakaunge loosie Dinge Maa'i Mo Jiu. Oto i sulie ko lae oto hunie i seulehi, maholo Dinge Maa'i ikire ko aehota, ");
INSERT INTO apb_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","nge a Josep ni Arimetia, e toli'aasie ma'unge, ko lae oto i saana Paelat huni ha'atohue rae aana a Jisas. A Josep ngaeta na'ohai mwane aana pulitaa ni lei-lei na ngaeta iini aana mwala ko maa-maa'oohie Aalahanga a God kei lae mai. ");
INSERT INTO apb_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","A Paelat e tohungei pangata'i aana e rongoa uri a Jisas e mae oto. Oto e soie mwane paine aana mo ramo, na ko dolosi aana uuri, “?Ohe a Jisas e mae oto to'ohuu?” ");
INSERT INTO apb_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","A mwaena e te'uri, “Iau, e mae oto.” A Paelat e rongo urine, ko si maaie rae aana Jisas hunie a Josep ke toolea. ");
INSERT INTO apb_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","A Josep e holie mei sala diana, na e lai oohosie rae aana Jisas mwaanie po'u-po'u, ko si uloa aana mei sala ngeena, na ko lai ne'ie i laona kilipwe'u kire didie aana hau. Oto e honoa maana kilipwe'u ngeena aana ho heu oto paine. ");
INSERT INTO apb_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Na a Meri ni Makdala na a Meri nikana Josep kirerue leesie leu nge kire ne'ie sapena a Jisas aana. ");
INSERT INTO apb_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Oto i seulehi, aana maholo Dinge Maa'i Mo Jiu e si mango, a Meri ni Makdala, na a Salome, na a Meri nikana Jemes, kire holie ngaeta mo ola wasu mangoni uri hunie kire ke lai hui'i haahie sapena a Jisas. ");
INSERT INTO apb_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Na oto mola i maahu'o-hu'o aana eetana nga hai dinge aana wiki, mo keine ko lai hule aana kilipwe'u na sato ko si pwaa. ");
INSERT INTO apb_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Na maholo kire ko lae ngeena kire ko lae pe'i unu-unue uuri, “?Ta'e hau oto paine nge kire honoa maana kilipwe'u aana, a tei nge kei ta'aasie hunikolu?” ");
INSERT INTO apb_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Kire ko ere urine aana hau ngeena e lae wai peine oto hiito'o. Ta'e maholo kire hule ta'au, na kire ko leesie oto hau ngeena, ta'aasilana e lae oto. ");
INSERT INTO apb_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Oto maholo mo keni ngeena kire lae sili hao i laona kilipwe'u, na kire ko leesie mwane saanau e to'oni aani to'oni rere'a, e ii'o aana aapa i pwalo-pwalona kilipwe'u. Oto mo keine kire ko tohungei me'u. ");
INSERT INTO apb_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Ta'e a mwaena ko te'uri hunire, “Omu ke su'uri me'u. Nou saie uri omu ko heitalea a Jisas ni Nasaret nge kire horo maesie i lengine po'u-po'u. Ta'e ingeie ha'ike oto i leu. E ta'ela'i oto mwaanie maenga. !Lio ka'u! Leu nge kire ne'i-ne'ie aana ka'u ie. ");
INSERT INTO apb_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Omu ke lai ha'arongoa mo pwaarongoisuli ingeie na a Pita uuri, ‘A Jisas ko lae oto i na'o loosi'omu hai Kalili. Na omu ke si leesie oto hai leune, mala e unue oto huni'omu.’” ");
INSERT INTO apb_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Oto mo keine kire ka'a unue lo'u nga mei ola, ta'e kire si tehi mola mwaanie kilipwe'u pe'i me'unge na ariringe. ");
INSERT INTO apb_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","I purine a Jisas e ta'ela'i mwaanie maenga i maahu'o-hu'o aana eetana nga hai dinge aana wiki, e hola'i haata'i aana a Meri ni Makdala, iini nge e oohe aasie ka'u e hiu li'oa aaela mwaanie. ");
INSERT INTO apb_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Oto a Meri e lae, ko lai ha'arongoa mo pwaarongoisuli ingeie. Kire ii'o ni saehuu oto mola pe'i ngaranga, ");
INSERT INTO apb_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","na maholo kire rongoa uri a Jisas e mauri eeliho'i oto, na uri a Meri e leesie, kire ka'a hiiwalaimoli ike aana. ");
INSERT INTO apb_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Oto lo'u i puri, a Jisas ko he'i haata'i lo'u, aana ngaeta ro iini aana maholo kirerue ko lae i sulie tala takoie ngaeta hanue, ta'e e ka'a lio ike lo'u mala hola'ina'o. ");
INSERT INTO apb_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Kirerue aaliho'i ta'au i Jerusalem, oto kire ko lai ha'arongoa mo pwaarongoisuli, ta'e kire ka'a hiiwalaimoli ike no'one aadarue. ");
INSERT INTO apb_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Oto lo'u i puri a Jisas ko he'i haata'i lo'u aana aawalai pwaarongoisuli mwana eeta aana maholo kire ko ngeu. E ere aada aena kire ka'a hiiwalaimoli ike aana, na i sulie saeda e hau hule aana kire ka'a hiiwalaimoli ike aana mo iini nge kire leesie a Jisas e ta'ela'i. ");
INSERT INTO apb_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Oto a Jisas ko te'uri hunire, “Omu ke lae i sulie ahutana mo henue i laona walumalau, na omu ke taroha'inie Tataroha Diana hunie ahutana mo iinoni. ");
INSERT INTO apb_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Ta'ena nga iini nge ko hiiwalaimoli eeku na loto-maa'ilana e lae, nge a God kei ha'a-uurie. Ta'e a God kei lei mae aana iini nge e ka'a hiiwalaimoli ike aaku. ");
INSERT INTO apb_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Na mo iini ko hiiwalaimoli eeku, nge a God kei niie nanamanga hunire, huni esuie mo hu'i-hu'ite. Kire kei sikera'inie mo li'oa aaela mwaanie mo iinoni aana sataku, na kire kei ere aana mo erenga hai aaopa'i. ");
INSERT INTO apb_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Na ma'alana kire ko hele aana mo mwaa ala-ala, wa kire ko inuhie nga mo ola ni maesi'i, ta'e kire sa'a roro'a ni maesi'i ike. Na kire kei hele i sapena mo mae-maea'a aana nimada, kire kei awaa oto.” ");
INSERT INTO apb_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Oto i purine Aalaha ikie a Jisas e ere mango urine pe'ire, a God e tahela'inie oto ta'au i Lengi na e lai ii'o oto aana ii'o-ii'oha paine i pwalo-pwalona God. ");
INSERT INTO apb_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Oto puriha'ana, mo pwaarongoisuli ingeie kire si lai taroha'inie Tataroha Diana hailiu i laona walumalau. Na a God e ii'o pe'ire, na e ha'awalaimoli'aa laeliwalanga ikire aana e niie nanamanga hunire huni esuie mo hu'i-hu'ite. ");
INSERT INTO apb_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Mwala hunge kire dau-deu aahonga huni uusu-uusu i sulie nga moi taa nge kire oa i saakaelu. ");
INSERT INTO apb_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Kire uusue mo ola kire rongo'i mwaanie mo iini e lae-laeliwala nameelu aana nga taa kire leesie oto aana maada, uure mai aehotalana laladonga i sulie a Jisas. ");
INSERT INTO apb_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Oto ineu maraaku no'one, poro paine Tiopilas, aena aana nou heitalenga'inie na nou sai diana aana walu olana uure oto mai aehotalana, nou lo'onga'inie uri ne ke uusu samanga'ini'i oto namue. ");
INSERT INTO apb_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","No ko uusu'i urine hunie o ke sai diana aana uri nga moi taa nge ha'a-uusulilemu e lae aani mo ola to'ohuu. ");
INSERT INTO apb_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","A Sekaraea ingeie ngaeta pris aana maholo nge a Herod e aalaha haahie i Israel. Ingeie aana po'o ni iinoni a Abaeja aana komu ni pris. Na satana hu'e ingeie a Elisabet. Ingeie no'one e uure mwaanie komu a Eron, ikire mo pris. ");
INSERT INTO apb_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Tolahadarue e tohungei oodota'i na kirerue hele i sulie ahutana mo ha'atolanga God. ");
INSERT INTO apb_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","E ro mau'ana ngeena kirerue ka'a to'o mwela ike, aena aana a Elisabet e amara. Na kirerue ko meni repo oto hiito'o. ");
INSERT INTO apb_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Oto aana ngaeta maholo e hule oto lo'u hunie po'o ni iinoni a Sekaraea huni esu mala pris i laona Nume Maa'i Peine a God i Jerusalem. ");
INSERT INTO apb_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Oto mala tolahana mo pris, kire inie daes huni leesie iini uri taa aada nge a God e lio hilisie huni uunue dango wau-wesu i lengine ora ni uunu-uunu aana Hahu'ana Leu Maa'i i laona Nume Maa'i a God. Oto aana hai dingena, lio-hilisilana a Sekaraea e lae. ");
INSERT INTO apb_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Na aana maholo a Sekaraea ko uunue dango wau-wesu, ahutana mwala mola po'oi sinaha pe'i aarenga'inge. ");
INSERT INTO apb_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Oto ensel a God e haata'i aana a Sekaraea, e uure kara'inie pwalo-pwalona ora ni uunu-uunue dango wau-wesu. ");
INSERT INTO apb_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Maholo a Sekaraea e leesie ensel ngeena, ko si teipu'o-pu'o na ko tohungei me'u oto hiito'o. ");
INSERT INTO apb_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Ta'e ensel e te'uri hunie, “!Mwaanie o me'u-me'u Sekaraea! A God e rongoa oto aarenga'inge i'oe, na hu'e i'oe a Elisabet kei ha'ahutaa oto kele mwela mwane, na o ke haara'inie satana aana a Jon. ");
INSERT INTO apb_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","O kei ile-ilenimwa'e na o kei sae-saediana oto liutaa haahie. Mwala hunge no'one kire kei ilenimwa'e haahie aana kei hute. ");
INSERT INTO apb_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","A Jon kei ne'ie tohungei iinoni peine a God. Niilana kei lae hunie a God, na huni haata'inie urine aana mwala, e sa'a roro'a ni inu waen ike wa nga mei wei ni mehiri. Kei honu oto aana Li'oa Maa'i uure i iiana nikana. ");
INSERT INTO apb_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Kei pe'ie mo iini hunge aana mwala ni Israel huni ha'a-aali'ure takoie a God, Aalaha ikire. ");
INSERT INTO apb_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Ingeie maraana kei lae i na'ona a Aalaha huni deu aakau aana mwala loosie laenga ingeie mai. A Jon kei tohungei a'aila'a na kei nanama aani Li'oa mala a Propet Elaeja. Ingeie kei da hanuelamanga i matolana mo he'i aamana, na kei ha'a-aali'ue kira haitohe takoie tala ni lo'onga'inilana oodota'inge.” ");
INSERT INTO apb_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Oto a Sekaraea ko te'uri hunie ensel, “?Uri ne kei manata'inie leu o ko unuena uri e to'ohuu uri taa? Aana ineu nou repo oto, na hu'e ineu e repo oto no'one.” ");
INSERT INTO apb_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Ensel ko aalamie uuri, “Ineu a Gebrel, na nou uure i na'ona God. Na ingeie oto ni e uusunge'inieu mei huni ere pe'i'o, na ni ha'arongo'o aana tataroha diana ie. ");
INSERT INTO apb_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Na nga taa no ko unue ie kei saro lae taane mai oa, aana maholo hunie. Ta'e i'oe aena aana o ka'a hiiwalaimoli ike aana walaku, o sa'a ere-ere ike, lai hule aana hai dinge walu ola ienini kei oa.” ");
INSERT INTO apb_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Aana maholona na mwala ko maa-maa'oohie ue a Sekaraea ta'i sinaha. Kire ko papangata'i oto aana ko ii'o tewa oto wau i Nume Maa'i. ");
INSERT INTO apb_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Maholo a Sekaraea e iisitaa poi sinaha, na e ka'a sai ere oto pe'ire, ta'e ko ha'a-ha'amalaa ola mola aana nimana. Oto kire si saie uri e leesie oto nga aanoa wau i Nume Maa'i. ");
INSERT INTO apb_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Maholo mo dinge ingeie huni deu esunge i Nume Maa'i mala pris e haro mango, nge e si eeliho'i ta'au i nume ingeie. ");
INSERT INTO apb_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","E ka'a tewa ike lo'u i purine leune e rau, na hu'e ingeie a Elisabet ko hi'e-hi'e oto. Na e ii'o hahuroto mola i nume ikirerue hunie e lime waro-waro. Oto a Elisabet ko te'uri, ");
INSERT INTO apb_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Leesie ka'u nga taa a Aalaha e da hunieu. Mwala ineu kire maa-masa ka'u i tehula'aku aana nou amara, ta'e ie a Aalaha e aamasieu na e ta'aasie oto mei masanga ngeena mwaanieu.” ");
INSERT INTO apb_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Aana oonona nga waro-waro i purine a Elisabet ko hi'e-hi'e oto, a God e uusunge'inie ensel Gebrel hunie huilume i Nasaret aana po'o ni henue i Kalili. ");
INSERT INTO apb_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Ensel ngeena e toolea mai tataroha hunie nga keni raori'i, na a keine e ere ruru oto huni to'o aana mwane satana a Josep aana komu a Deved Inemauri. Satana a keine a Meri. ");
INSERT INTO apb_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Oto ensel e sili mei saana ko te'uri, “Saediananga a God huni'o. A Aalaha e ii'o oto pe'i'o.” ");
INSERT INTO apb_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Oto a Meri saena ko si liki i tehula'ana walana ensel ngeena, na ko lo'onga'i hiito'o i sulie uri nga taa ni lo'onga'inge aana mo wala ngeena. ");
INSERT INTO apb_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Oto ensel ko te'uri hunie, “Mwaanie o ma'u-me'u Meri. A God ko tohungei ilenimwa'e oto hiito'o haahi'o. ");
INSERT INTO apb_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Na o kei hi'e-hi'e aani mwela, oto o kei ha'ahutaa kele mwane, na o ke haara'inie satana aana a Jisas. ");
INSERT INTO apb_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Ingeie kei ne'i mwane paine, na mwala kei haara'inie uri ingeie Kalena iini e Paine Liutaa. Na a God Aalaha ikie kei ha'a-aalahaa no'one mala weuwana, a Deved Inemauri. ");
INSERT INTO apb_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Oto ingeie kei aalaha tara'asi oto haahie mwala ni Israel, na aalahanga ingeie e sa'a mango oto oo'oo.” ");
INSERT INTO apb_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Oto a Meri ko unue hunie ensel uuri, “?Mo ola ienini ke si reu uri taa eena, na nou ka'a saie ike nga mwane?” ");
INSERT INTO apb_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Oto ensel ko aalamie uuri, “Li'oa Maa'i kei siho i lengimu, na nanamanga iini e Paine Liutaa kei melusi'o. Na aena ngeena kele wee-wee i'oe kei maa'i na sailana kei lae uri ingeie Kalena a God. ");
INSERT INTO apb_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","O ke leesie ka'u keni tekihemu a Elisabet, e tohungei repo aaela oto. Ta'e ingeie no'one ko hi'e-hi'e aani mwela. Ahutana mwala kire mani lo'onga'i uri e sa'a to'o mwela lo'u, ta'e ko hi'e-hi'e oto na e oono waro-waro e mango oto aana. ");
INSERT INTO apb_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Aana ta'e-ta'ena nga mei ola e sa'a aasaie ike a God huni esuie.” ");
INSERT INTO apb_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Oto a Meri ko si unue hunie ensel uuri, “Ineu oto koni-konihe a Aalaha. Leune ke oa oto hunieu mala o ko unuena.” Oto ensel e si lae mwaanie. ");
INSERT INTO apb_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Oto lo'u mola i purine, a Meri e taule'i, oto ko tolana lae oto hunie ngaeta huilume ta'au i lengine mo uuwo i Jiudia. ");
INSERT INTO apb_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","E lae ta'au i sili i nume a Sekaraea, oto ko ere ni saediananga hunie a Elisabet. ");
INSERT INTO apb_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Maholo a Elisabet e rongoa mola mei wala ni saediananga a Meri, oto kele mwela i iiana ko esule'i na ko lalaa'i sape oto. Na maholona Li'oa Maa'i ko siho oto i lengine a Elisabet, ");
INSERT INTO apb_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","na ko unue oto uuri, “A God ke ha'adiana'a'o liutaa aana ahutana mo keni, na ke ha'adiana'aa kele wee-wee o ko hi'e-hi'e aana ngeena. ");
INSERT INTO apb_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","I'oe oto nikana a Aalaha ineu, na o lae mai seeku. ?Aana e ue ka'u mei ola diana urini ko reu eeku? ");
INSERT INTO apb_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Maholo nou rongoa walamu, oto kele wee-wee e si lalaa'i sape oto pe'ie ilenimwa'enga i iieku. ");
INSERT INTO apb_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Deidehi'o keine, aana o hiiwalaimoli uri nga taa a Aalaha e unue huni'o kei oa oto.” ");
INSERT INTO apb_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Oto a Meri ko te'uri, “Saeku ko soi ha'amanikulu'aa Aalaha, ");
INSERT INTO apb_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Na mauriha'aku ko ilenimwa'e aana God, a Ha'a-uurileku, ");
INSERT INTO apb_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","aana a God e lo'onga'inieu mei iinoni reu ingeie. Uure si'iri pwau weu ahutana mwala kei saieu uri keni deidehie, ");
INSERT INTO apb_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","aana a God, iini e nanama na e maa'i, e da mo ola e hi'e hunieu. ");
INSERT INTO apb_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","A God e aamasie mo iini kire ha'ama'u aana, uure oto aana mo pweunge i na'o lae mai hule si'iri na mo pweunge ue mai. ");
INSERT INTO apb_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","E haata'inie ramolana aana nimana, aana e tatanga'inire mwala e sai tooha'inire aani lo'onga'inilada maraada. ");
INSERT INTO apb_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","E ha'asihoa mo aalaha mwaanie mo neunekume ikire, na e sulu ala'a aana mo mei iinoni reu. ");
INSERT INTO apb_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","E niie mo ola diana hunie mo iini kire hiolo, ta'e mo iini e to'o-to'o e uusunge'i mwaakule mola aada. ");
INSERT INTO apb_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","E hule oto mai huni pe'ie mwala ingeie mo Israel, mo koni-konihe ingeie. E ka'a pulongosie ike haiholota'inge ingeie huni aamasie mwala ingeie, ");
INSERT INTO apb_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","aana e da oto nga taa e haiholota'inie hunie mo weuwaka, hunie a Ebraham na hunie mo kalena, uri kei aamasire oto tarau.” ");
INSERT INTO apb_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","A Meri e ii'o pe'ie a Elisabet hunie ola mala e oolu waro-waro, oto e si eeliho'i lo'u i henue ingeie. ");
INSERT INTO apb_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Oto e hule aana pongine a Elisabet, ko si ha'ahutaa kele mwela mwane. ");
INSERT INTO apb_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Mo euhenue ingeie na mo tekihana kire rongoa uri a Aalaha e ha'a-oaie aamasinge ingeie hunie a Elisabet urine, kire si meni ilenimwa'e pe'ie. ");
INSERT INTO apb_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Oto wiki e ahu i purine kele wee-wee e hute, kire si meni loko hunie torilana na hunie kire ke haara'inie aana aamana, a Sekaraea. ");
INSERT INTO apb_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Ta'e a nikana e unue uuri, “Ha'ike, omu ke haara'inie satana aana a Jon.” ");
INSERT INTO apb_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Oto mwala a nikana ko te'uri hunie, “Ta'e more ka'a to'o aana ike nga satai ola urine aana komu i'omore'i.” ");
INSERT INTO apb_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Oto kire ko si ha'amalaa hunie aamana uri e sare haara'inie satana aana a tei. ");
INSERT INTO apb_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Oto a Sekaraea e sukaa ola ni uusu-uusu, ko si uusue uuri, “Satana a Jon.” I leune kire ko si meni pangata'inie oto hiito'o. ");
INSERT INTO apb_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Oto mola aana maholoi satona, a Sekaraea ko si aehota ere-ere oto lo'u, na ko paalahea God. ");
INSERT INTO apb_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Oto mo euhenue ikirerue kire ko si me'u oto hiito'o, na tataroha aana mo olana e si tarohie ahutana mo henue ta'au i lengine mo uuwo i Jiudia. ");
INSERT INTO apb_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Na ahutana mo iini e rongoa mo olana, kire ko si lo'o-lo'onga'i i suli'i na kire ko unue uuri, “?A mwa'u ie kei ue taane? Aana e lio mala uri nanamanga a Aalaha oto aana.” ");
INSERT INTO apb_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Oto a Sekaraea, aamana a Jon, e honu aana Li'oa Maa'i, e si ere rarangana walana God uuri, ");
INSERT INTO apb_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Kolu ke paalahea God, Aalaha ikie mo Israel, aana e lae mai huni pe'ikie mo iinoni ingeie, na e tapa-oolisikie. ");
INSERT INTO apb_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Na uure mwaanie komu a Deved koni-konihe ingeie, e niie iini nanama huni ha'a-uurikie. ");
INSERT INTO apb_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Uure oto mai na'o, e unue ka'u aana mo propet maa'i ingeie ");
INSERT INTO apb_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","uri kei ha'a-uurikie mwaanie mo maelonga ikie, na mwaanie nimada kira ngiduupu hunikie. ");
INSERT INTO apb_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","E unue kei haata'inie aamasinge hunie mo weuwaka, huni aamasito'o aana haiholota'inge maa'i ingeie, ");
INSERT INTO apb_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","nge e haiholota'inie hunie a Ebraham aamaka. ");
INSERT INTO apb_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Aana e haiholota'i uri kei ha'a-uurikie mwaanie mo maelonga ikie, mwaanie kie ma'ute'inire. Ta'e kie ke asu mamanuto'o mola nana, ");
INSERT INTO apb_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","uri hunie kie ke ii'o maa'i na ii'o oodota'i i na'ona, i suli hei dinge aana mauriha'aka. ");
INSERT INTO apb_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","“Na i'oe wee-wee ineu, sailemu kei lae uri nga propet nana iini e Paine Liutaa, aana o kei lae i na'ona Aalaha huni salea tala ingeie loosie. ");
INSERT INTO apb_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Na huni ha'arongoa mwala ingeie uri ingeie kei ha'a-uurire aani sae'aasilana mo roro'anga ikire. ");
INSERT INTO apb_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Aena aana aamasinge a God ikie mone, ingeie kei siho mai uure ta'au i Lengi mala sato ko pwaa, ");
INSERT INTO apb_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","huni raangie mo iini kire ii'o i laona rodohono na i mamalutana maenga, na huni ha'a-oodohie ae'aeka i sulie tala ni henuelama.” ");
INSERT INTO apb_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Oto kele mwelana e paine ta'e, na ko manata pe'i lo'onga'inge diana. E talei o'o'o mola i laona hanuesala, lai hule aana hai dinge e aehotaa asunge ingeie i matolana mwala ni Israel. ");
INSERT INTO apb_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Aana maholona, inemauri peine ni Rom, a Ogastas, e ne'ie ha'atolanga hunie ahutana mwala aana mo henue i mamalutana. Ha'atolanga ngeena e unue uri ahutana iinoni ke mani uusu sata huni toolea wilinge mwaanire. ");
INSERT INTO apb_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Uusu-satanga ie nge eetana nga iini e rau aana maholo a Kuaerinias e aalaha aana po'o ni henue i Siria. ");
INSERT INTO apb_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Oto ahutana mwala ko meni lae oto huni uusu sata aana mo henue ikire, nga iini ni oto aana hanue ingeie. ");
INSERT INTO apb_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Oto a Josep e uure i Nasaret, ngaeta huilume wau aana po'o ni henue i Kalili, ko lae oto hunie huilume i Betlehem wau aana po'o ni henue i Jiudia, huilume nge a Deved Inemauri e hute aana. E lae wau i leune aena aana ingeie e uure aana komu a Deved Inemauri. ");
INSERT INTO apb_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","A Josep e lae huni uusu sata pe'ie a Meri, keni nge e ere ruru pe'ie huni to'o aana. Maholona na a Meri ko hi'e-hi'e oto. ");
INSERT INTO apb_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Maholo ikirerue ue i Betlehem na ko hule oto aana pongine a Meri huni meuri eeni mwela. ");
INSERT INTO apb_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Oto ko ha'ahutaa oto na'ohai mwela ingeie, ko uloa aani sala na ko ha'a-enohie aana leu ni ha'angau puluke, aana nga leu ha'ike talada i nume ni awataa. ");
INSERT INTO apb_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Oto aana hai rodona ngaeta mo mwane kire ii'o po'oi sinaha ka'a ha'atau lo'u mwaanie huilume aana kire ko kakalie mo sipu ikire. ");
INSERT INTO apb_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Oto ensel a God e lae mai saada na manikuluha'ana a God ko raa kali-kelire. Oto kire ko si tohungei me'u oto liutaa. ");
INSERT INTO apb_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Oto ensel ngeena ko te'uri hunire, “!Mwaanie omu me'u-me'u! Nou toolea mai tataroha diana namiu na ilenimwa'enga oto liutaa hunie ahutana mo iinoni. ");
INSERT INTO apb_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Iini nge kei ha'a-uuri'omu e si kele hute oto molana aana hanue a Deved. Ingeie oto a Kraes, Aalaha ikie. ");
INSERT INTO apb_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Na tolimaa nge kei ha'awalaimoli'aa walaku huni'omu nge uri, omu kei lio oodoie kele wee-wee kire uloa aani sala i laona leu ni ha'angau puluke.” ");
INSERT INTO apb_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Na oto mola lau-leu, pulitaa ni ensel uure ta'au i Lengi oto pe'ie iini nge ko ere-ere ngeena, kire ko meni paalahea God, kire ko te'uri, ");
INSERT INTO apb_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Manikulu'anga hunie a God i Lengi, na hanuelamanga mai aano hunie mo iini e ilenimwa'e haahire.” ");
INSERT INTO apb_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Oto maholo mo ensel kire aaliho'i i Lengi mwaanire, mo kakali sipu ko si ere hailiu hunire uuri, “Kolu ke lae ka'u i Betlehem huni leesie nga taa nge a Aalaha e unue hunikolu ie.” ");
INSERT INTO apb_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Oto kire ko tolana lae lau-leu oto wau, na kire ko leesie a Meri na a Josep pe'ie kele wee-wee, na e eno mola aana leu ni ha'angau puluke. ");
INSERT INTO apb_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Maholo mo kakali sipu kire lae wau i leesie kele wee-wee na e eno aana leu ni ha'angau puluke, oto kire ko si ladoa nga taa ensel e unue hunire i sulie kele wee-wee ngeena. ");
INSERT INTO apb_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Ahutana mwala ko si pangata'i aana kire ko rongoa nga taa mo kakali sipu kire ko ladoa. ");
INSERT INTO apb_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Ta'e a Meri e ne'ie walu ola ienini mola i saena, na ko si talei lo'o-lo'onga'i mwa-mwanoto mola i suli'i maraana. ");
INSERT INTO apb_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Oto mo kakali sipu kire si eeliho'i takoie mo sipu ikire pe'i soi ha'amanikulu'aa God na pe'i paalahenga aena aana walu ola ensel e unu'i hunire, kire leesi'i uri kire to'ohuu oto. ");
INSERT INTO apb_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Oto wiki e ahu i purine kele wee-wee e hute, nge kire si esuie torihesi'onga aana kele wee-wee i sulie mo Ha'atolanga a Mosis, na kire haara'inie aana a Jisas, satai ola nge ensel e unue ka'u oto maholo na e ka'a lodo ue i iiana nikana. ");
INSERT INTO apb_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Na lae-lae, e haro hule oto aana maholo huni ha'arere'anga a Meri i purine ha'ahutanga i sulie mo Ha'atolanga a Mosis. Oto a Josep na a Meri kirerue si toolea ta'au kele wee-wee i Jerusalem, huni niie hunie a Aalaha, ");
INSERT INTO apb_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","oto mala uusulana e lae i laona Ha'atolanga a God uuri, Niie ahutana ta'ena nga na'ohai mwela mwane hunie a Aalaha. ");
INSERT INTO apb_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Oto a Josep na Meri kire lae huni esuie uunu-olanga mala Ha'atolanga a God e unue, aana e ere uuri, O ke niie e ro hiroikuu wa e ro kalei urou. ");
INSERT INTO apb_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Aana maholona, ngaeta mwane satana a Simeon e o'o'o no'one i Jerusalem. A mwane ngeena ingeie nga mwane oodota'i, na e ii'o mola pe'i palolana a God, na Li'oa Maa'i no'one pe'ie. A Simeon e maa-maa'oohie a Kraes nge a God e haiholota'i huni uusunge'inie mai huni ha'a-uurie mwala ni Israel. ");
INSERT INTO apb_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Aana Li'oa Maa'i e unue hunie uri e sa'a mae ue na e ka'a haro leesie a Ha'a-uuri. ");
INSERT INTO apb_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Oto Li'oa Maa'i e na'ona a Simeon hunie Nume Maa'i Peine, na maholona a Josep na Meri ko toolea no'one mai a Jisas huni deu i sulie Ha'atolanga a Mosis. ");
INSERT INTO apb_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Oto a Simeon e aapalaa kele wee-wee, e si paalahea God, ko te'uri, ");
INSERT INTO apb_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Hahu'ana Aalaha, ineu oto koni-konihe i'oe, na oto ie ne kei mae ni henuelama. Aana o deu oto i sulie haiholota'inge i'oe hunieu. ");
INSERT INTO apb_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Aana nou leesie oto aana maaku a Ha'a-uuri nge o uusunge'inie mai. ");
INSERT INTO apb_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Ingeie oto kei ha'a-uurie mwala i'oe. ");
INSERT INTO apb_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Ingeie oto raa-raa hunie mo Aapoloa Aaopa, na kei toolea mai manikulu'anga hunie mo iinoni i'oe mo Israel.” ");
INSERT INTO apb_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Aamana a Jisas na nikana, kirerue ko tohungei pangata'inie mo ola nge a Simeon ko unu'i i sulie kele wee-wee. ");
INSERT INTO apb_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Oto a Simeon e si ha'adiana'araelu, na ko te'uri hunie a Meri, “Kele wee-wee ienini a God e lio hilisie huni ha'a-uurie mo iini hunge ni Israel. Ta'e ingeie kei ha'atekehie no'one mo iini hunge lo'u, aena aana ingeie kei ne'ie tolimaa a God nge kire sere'i lae i sulie. ");
INSERT INTO apb_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Na mo lo'onga'inge mumuni mwala ngeena ke si haata'i i leune. Oto i'oe, o kei saehuu na o kei hii aaela oto mala kire otomie saemu aana naihi.” ");
INSERT INTO apb_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Na ngaeta mei nao keni satana a Anna ingeie no'one aana maholona. A hu'ena ingeie nga propet no'one na ingeie kalena a Panueli, mwane aana komu a Asa. E to'o-to'o poro taane, ta'e e ii'o mola pe'ie poro ingeie hunie e hiu aata halisi, ");
INSERT INTO apb_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","na poro ingeie ko mae oto mwaanie, oto e si ii'o mola maraana. A keine e walu-aawalai helisi mwana hai e mango oto aana, na e talei o'o'o mola i Nume Maa'i na e palo-paloa mola a God susue aatowaa na rodo aani oolongaunge na aani aarenga'inge. ");
INSERT INTO apb_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Oto mola aana ta'a-ta'a maholoi satona, nge a hu'ena e lae mai saada na ko tala'ai paalahea God. Oto aana mo dinge lo'u i puri, a hu'ena ko si ha'a-ha'arongoa mwala uri a Jisas ingeie oto a Ha'a-uuri. E ere urine hunie ahutana mo iini nge kire ko maa'oohie uri a God kei tapa oolisie mwala ni Israel. ");
INSERT INTO apb_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","A Josep na Meri kirerue haro asu mangoa mo ola i sulie ha'atolanga a Aalaha, nge kire si ooli takoie huilume ikire i Nasaret hao i Kalili. ");
INSERT INTO apb_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Oto kele wee-wee ko peine ta'e oto hao. E paine a'aila'a, na e honu aani saenanaunge, na ha'adiana'anga a God e ii'o oto aana. ");
INSERT INTO apb_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","E ro mau'ana a Jisas kirerue ko lae-lae i Jerusalem i suli helisi hunie Houlaa Ni Liumwaanie. ");
INSERT INTO apb_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Oto maholo a Jisas e hule aana aawalai helisi mwana rue, kiraelu ko lae oto lo'u mala kirerue ko lae-lae i suli helisi. ");
INSERT INTO apb_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Maholo mo dinge paine ngeena kire mango oto, nge mwala ko si ooli takoie mo henue ikire. Ta'e a Jisas e oore mola ue i puri ta'au i Jerusalem, na aamana na nikana ka'a saie. ");
INSERT INTO apb_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Kirerue ko lo'o-lo'onga'i uri ingeie taane pe'ire i laona laeha. Kire ko lae oto hunie hai dinge laku, oto i seulehi kirerue ko si aehota lo'ohie i saana mwala ikire na mo malahude. ");
INSERT INTO apb_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Kirerue lo'o-lo'ohie na kirerue ka'a lio oodoie, oto kirerue ko eeliho'i lo'u hunie i Jerusalem. ");
INSERT INTO apb_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Oto i purine e oolu hei dinge e saro mango oto, nge kirerue ko si lai lio oodoie i matolana mo ha'a-uusuli ni Jiu ta'au i laona Nume Maa'i Peine, na ko rorongo i sulire pe'i dodolosi ola aada. ");
INSERT INTO apb_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Na ahutana mwala nge kire rorongoa ere-erenga ingeie, kire ko tohungei pangata'inie saenanaunge ingeie oto hiito'o na mo aalaminge e dau'ine. ");
INSERT INTO apb_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Aamana na nikana kirerue lae ta'au i lio oodoie, kirerue ko tohungei pangata'i oto hiito'o. Oto a nikana ko te'uri hunie, “?Kaleku, e ue ni o ko te'urine aamere'i? Ineu na aamamu, mere ko tohungei heitale'o pe'i saehuunge oto hiito'o.” ");
INSERT INTO apb_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Oto a Jisas ko aalamirerue uuri, “?E ue nge more ko heitaleau urine? ?Uri more ka'a saie ike leu i sapeku hunie ne ke ii'o i nume Aamaku?” ");
INSERT INTO apb_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Ta'e kirerue ka'a rongo saie ike nga taa e unue. ");
INSERT INTO apb_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Oto a Jisas e si eeliho'i pe'irerue hunie i Nasaret, aana e tola i sulirerue. A nikana ko talei lo'o-lo'onga'i mola i sulie mo ola e rau ngeena i saena. ");
INSERT INTO apb_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Oto a Jisas ko si peine ta'e pe'i saenanaunge oto lo'u liutaa. Na a God ko tohungei saemango oto hiito'o haahie, na mwala ko meni ilenimwa'e oto no'one haahie. ");
INSERT INTO apb_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Oto e hule aana aawalai helisi mwana lime aana mo helisi nge a Taebirias e inemauri haahie aalahanga mo Rom. Aana maholona a Pontias Paelat ko aalaha haahie po'o ni henue i Jiudia, na a Herod Antipas ko aalaha haahie po'o ni henue i Kalili. A Pilip, aasine a Herod, ko aalaha haahie e ro po'o ni henue i Iturea na i Trakonaetis, na a Lisanias ko aalaha haahie po'o ni henue i Abilin. ");
INSERT INTO apb_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","E ro na'ohai pris mo Jiu aana maholona oto a Anas na a Kaiapas. Aana maholona, nge mei wala e si uure mwaanie a God hunie a Jon kalena Sekaraea, na ingeie i laona hanuesala. ");
INSERT INTO apb_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Oto a Jon ko lae oto i sulie ahutana mo henue kali-kelie wai peine i Jodan na ko taroha'inie hunie mwala uri kire ke aali'u to'ohuu mwaanie ooraha'aa, nge kire ke si loto maa'i hunie a God ke sae'aasie mo ooraha'aa ikire. ");
INSERT INTO apb_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","E asuie oto urine mala uusulana e lae i laona uusu-uusu a Propet Aesaea aana e unue uuri, Nga iini ko soi-soi peine i laona hanuesala uuri, “Omu ke dau aakau aana tala loosie laenga mai a Aalaha, na omu ke ha'a-oodohie tala ni lae ingeie. ");
INSERT INTO apb_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Omu ke aanomie ahutana mo deiderie. Omu ke ha'asadaa mo uuwo na mo toloihenue, na omu ke ha'a-oodohie mo tala kire mwa'ilu, na omu ke mwanaa mo tala hunie kire ke mwana-mwana'a. ");
INSERT INTO apb_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Hunie ahutana mwala ke mani leesie ha'a-uuringe a God.” ");
INSERT INTO apb_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Mwala oto hunge kire lae mai saana a Jon hunie ke loto maa'i aada. Oto e si te'uri mola hunire, “!I'omu oto mo mwaa ala-ala! ?Omu ko lo'o-lo'onga'i uri mala omu ko loto maa'i ha'alaa, omu ko tehisie saewasunge a God nge kei lae maine? ");
INSERT INTO apb_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","!E aasa! Ta'e omu ke hungu eeni hue-huei ola diana i laona mau-meuringe i'omu huni haata'inie uri omu oonisae to'ohuu oto mwaanie ahutana mo ooraha'aanga i'omu. Na mwaanie omu lo'o-lo'onga'inie uri omu kei tehisie saewasunge a God aena aana omu hute aana komu a Ebraham. Leune e sa'a pe'i'omu ike aana no ko unue huni'omu uri a God e sai hu'isie mola mo heu ienini hunie kire ke ne'i iinoni haalu hunie komu a Ebraham. ");
INSERT INTO apb_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Aana a God e urihana mwane e ne'i aakau oto aana hau tou-tohu i ae'aena mo ei, na mo ei nge kire ka'a hungu ike aani hue-huei ei diana, kei tohu aasi'i na aasileni kei lae i laona dunge.” ");
INSERT INTO apb_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Oto mwala ko dolosi aana uuri, “?Nge ko urine, nga taa ka'u melu ke si esuie?” ");
INSERT INTO apb_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Oto a Jon ko aalamire ko te'uri, “A tei ko to'o aana nga ro to'oni, ke niie nga iini nana iinoni nge e ka'a to'o aana ike nga iini. Na a tei ko to'o ngaulaa, ke nii-nii'i no'one urine.” ");
INSERT INTO apb_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Ngaeta mwala susulu to'oha hunie aalahanga ni Rom kire lae no'one mai uri hunie a Jon ke loto maa'i aada. Oto kire ko dolosi aana uuri, “?Ha'a-uusuli, oto i'emeelu, melu kei ue?” ");
INSERT INTO apb_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Oto a Jon ko te'uri hunire, “Omu ke su'uri tola to'oha liutaa aana lo'u nga taa kire hatonga'inie huni'omu mwaanie mwala.” ");
INSERT INTO apb_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Ngaeta mo ramo ko dolosi no'one aana a Jon uri, “?Nge i'emeelu? ?Melu kei ue?” Oto ko te'uri hunire, “Mwaanie omu deu-deu rarahie nga iini hunie mo to'oha ingeie, wa omu ke ere-ere aana mola tototala. Ta'e omu ke ilenimwa'e mola haahie holitemiu.” ");
INSERT INTO apb_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Mwala ko meni maa'oohie mone a Kraes, oto kire ko lo'onga'i heiliu oto i sulie a Jon. Kire ko lo'onga'i oto uuri, “Ohe ingeie ni oto a Kraes.” ");
INSERT INTO apb_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Oto a Jon ko si aalamire ko te'uri, “Ineu a Kraes ha'ike. Ineu no ko loto maa'i eemiu mola aani wei, ta'e iini nge ko lae mai i puriku, e paine lo'u liutaa aaku, hule aana ineu na nou ka'a diana ike malisine ne ke asu mala koni-konihe huni luhesie ho'ohaahi'ae ingeie. Ingeie ke si loto maa'i aana ngaeta mwala aana Li'oa Maa'i, na ngaeta mwala kei lotohire aana dunge ni ha'amotaahinge. ");
INSERT INTO apb_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Ingeie ni e to'o aana nanamanga huni leie ahutana iinoni. Aana e urihana iinoni nge ko ta'aasie mo hule-hulei kooni mwaanie mo tohungei ola. Oto ko si ne'i konie mo tohungei ola i lengine haa i laona nume ni duru ingeie. Ta'e mo hule-hulei ola aaela ngeena, nge kei uunu'i aana dunge nge e sa'a mwa'a ike lo'u.” ");
INSERT INTO apb_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Mo tala hunge a Jon Loto Maa'i e lae pe'i laeliwala aana Tataroha Diana hunie mwala aani, na huni ere ha'asusue mwala. ");
INSERT INTO apb_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Na e tohungei ere aana a Herod Antipas hiito'o haahie e to'o aana lo'u mola a Herodias, hu'e a mwane aasine. Na e ere aana no'one a Herod haahie ahutana mo ola aaela e dau hu'isi'i. ");
INSERT INTO apb_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Oto a Herod e si sapeie lo'u mo aaelanga ngeena aana e ne'ie a Jon i laona nume ni ho'o. ");
INSERT INTO apb_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Maholo kire ka'a ne'ie ue a Jon i laona nume ni ho'o, ngaeta hai dinge e loto maa'i aana mwala, na e loto maa'i lo'u aana a Jisas. Na aana maholo a Jisas ko aarea a God, nge i Lengi e si taha, ");
INSERT INTO apb_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","na Li'oa Maa'i e siho mai i lengine mala hiroikuu. Oto mei wala e uure mai Lengi, na ko te'uri, “I'oe oto hahu'ana kaleku, na nou tohungei manata diana huni'o, na no ko ilenimwa'e oto liutaa haahi'o.” ");
INSERT INTO apb_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Maholo a Jisas e aehotaa asunge ingeie, na ola mala e oolu aawalai helisi mola ue e mango aana, na mwala e lo'onga'i uri ingeie kalena Josep. A Josep e uure mwaanie a Hilae. ");
INSERT INTO apb_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","A Hilae e uure mwaanie a Matat. A Matat e uure mwaanie a Livae. A Livae e uure mwaanie a Melkae. A Melkae e uure mwaanie a Janae. A Janae e uure mwaanie a Josep. ");
INSERT INTO apb_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","A Josep e uure mwaanie a Matataeas. A Matataeas e uure mwaanie a Emos. A Emos e uure mwaanie a Neham. A Neham e uure mwaanie a Eslae. A Eslae e uure mwaanie a Nagae. ");
INSERT INTO apb_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","A Nagae e uure mwaanie a Meata. A Meata e uure mwaanie a Matataeas. A Matataeas e uure mwaanie a Semein. A Semein e uure mwaanie a Josek. A Josek e uure mwaanie a Joda. ");
INSERT INTO apb_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","A Joda e uure mwaanie a Joanan. A Joanan e uure mwaanie a Risa. A Risa e uure mwaanie a Serababel. A Serababel e uure mwaanie a Sialtiel. A Sialtiel e uure mwaanie a Nirae. ");
INSERT INTO apb_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","A Nirae e uure mwaanie a Melkae. A Melkae e uure mwaanie a Adae. A Adae e uure mwaanie a Kosam. A Kosam e uure mwaanie a Elmadam. A Elmadam e uure mwaanie a Ere. ");
INSERT INTO apb_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","A Ere e uure mwaanie a Josua. A Josua e uure mwaanie a Eliesa. A Eliesa e uure mwaanie a Jorim. A Jorim e uure mwaanie a Matat. A Matat e uure mwaanie a Livae. ");
INSERT INTO apb_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","A Livae e uure mwaanie a Simeon. A Simeon e uure mwaanie a Jiuda. A Jiuda e uure mwaanie a Josep. A Josep e uure mwaanie a Jonam. A Jonam e uure mwaanie a Elaeakim. ");
INSERT INTO apb_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","A Elaeakim e uure mwaanie a Milia. A Milia e uure mwaanie a Mena. A Mena e uure mwaanie a Matata. A Matata e uure mwaanie a Netan. A Netan e uure mwaanie a Deved Inemauri. ");
INSERT INTO apb_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","A Deved Inemauri e uure mwaanie a Jesi. A Jesi e uure mwaanie a Obed. A Obed e uure mwaanie a Boas. A Boas e uure mwaanie a Salmon. A Salmon e uure mwaanie a Nason. ");
INSERT INTO apb_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","A Nason e uure mwaanie a Aminadab. A Aminadab e uure mwaanie a Admin. A Admin e uure mwaanie a Anae. A Anae e uure mwaanie a Hesron. A Hesron e uure mwaanie a Pires. A Pires e uure mwaanie a Jiuda. ");
INSERT INTO apb_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","A Jiuda e uure mwaanie a Jekob. A Jekob e uure mwaanie a Aesak. A Aesak e uure mwaanie a Ebraham. A Ebraham e uure mwaanie a Tera. A Tera e uure mwaanie a Neho. ");
INSERT INTO apb_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","A Neho e uure mwaanie a Sirag. A Sirag e uure mwaanie a Riu. A Riu e uure mwaanie a Pileg. A Pileg e uure mwaanie a Eba. A Eba e uure mwaanie a Sila. ");
INSERT INTO apb_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","A Sila e uure mwaanie a Keinan. A Keinan e uure mwaanie a Afaksad. A Afaksad e uure mwaanie a Siem. A Siem e uure mwaanie a Noa. A Noa e uure mwaanie a Lamek. ");
INSERT INTO apb_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","A Lamek e uure mwaanie a Metusala. A Metusala e uure mwaanie a Inok. A Inok e uure mwaanie a Jered. A Jered e uure mwaanie a Mahelalel. A Mahelalel e uure mwaanie a Kenan. ");
INSERT INTO apb_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","A Kenan e uure mwaanie a Enos. A Enos e uure mwaanie a Set. A Set e uure mwaanie a Adam. A Adam e uure mwaanie a God. ");
INSERT INTO apb_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Oto a Jisas e aaliho'i mwaanie wai i Jodan, na Li'oa Maa'i e ii'o oto pe'ie, e si toolea ta'au i henuesala. ");
INSERT INTO apb_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Na a Satan e malaahongana hunie hai aawalai hei dinge, na e ka'a hikana nga mei ngeulaa aana maholona, oto ko hiolo. ");
INSERT INTO apb_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Oto a Satan ko te'uri hunie, “Mala o ko ne'ie Kalena God to'ohuu, o ke unue ho heu ie ke ne'i bred.” ");
INSERT INTO apb_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Ta'e a Jisas e aalamie mola uuri, “Mo Uusu-uusu Maa'i e unue uuri, Iinoni e sa'a mauri ike mola aani bred hahaiteli.” ");
INSERT INTO apb_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Oto a Satan ko he'i toolea lo'u ta'au, na ko tolana haata'i lau-leu oto aana ahutana mo aalahanga aana walumalau hunie. ");
INSERT INTO apb_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Oto a Satan ko he'i te'uri lo'u hunie, “Nou sai niie ahutana mo aalahanga ie namue pe'ie manikuluha'ani hunie o ke paine haahi'i, aana niilana e lae oto hunieu uri ineu ne ke si nii'i hunie ta'ena nga iini i sulie saeku. ");
INSERT INTO apb_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Oto mala uri o kei pouruuru ni ha'ama'unge aaku na o kei palo-paloau, nge ne kei niie ahutana mo ola ienini namue.” ");
INSERT INTO apb_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Oto a Jisas ko aalamie lo'u uuri, “Mo Uusu-uusu Maa'i e unue uuri, Omu ke palo-paloa mola ta'e a God Aalaha i'omu, na omu ke asu mola nana ta'e ingeie hali'ite.” ");
INSERT INTO apb_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Oto a Satan ko he'i toolea lo'u a Jisas ta'au i Jerusalem, na ko lai ha'a-uuresie oto ta'au i lengine ho susumaa aana Nume Maa'i Peine, ko si te'uri lo'u hunie, “Mala o ko ne'ie Kalena God to'ohuu, o ke toli'aasi'o uure i lengi i leu hunie o ke teke hao i aano. ");
INSERT INTO apb_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Aana mo Uusu-uusu Maa'i e unue uuri, A God kei uusunge'inie mo ensel ingeie huni lio i suli diana aamu. ");
INSERT INTO apb_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Kire kei tala'ahua'o aana nimada mwaanie ae'aemu e hite aana nga ho heu.” ");
INSERT INTO apb_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Oto a Jisas ko aalamie lo'u a Satan ko te'uri, “Ta'e mo Uusu-uusu Maa'i e unue no'one uuri, Omu ke su'uri oohongie a God Aalaha i'omu.” ");
INSERT INTO apb_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Oto maholo a Satan e malaahongana a Jisas aana mo tala ngeena mango, nge e si lae mwaanie a Jisas, ko lai maa'oohie nga maholo aaopa huni malaahongana lo'u. ");
INSERT INTO apb_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","A Jisas e aaliho'i lo'u hunie po'o ni henue i Kalili, na e honu oto aana nanamanga aana Li'oa Maa'i. Oto taroha'ana e si taro i sulie ahutana mo henue aana po'o ni henuena. ");
INSERT INTO apb_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Na a Jisas e aehota ha'a-ha'a-uusuli i laona mo nume ni palo-palo na ahutana mwala kire ko meni lahea. ");
INSERT INTO apb_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Oto a Jisas e aaliho'i lo'u i Nasaret, huilume nge e paine ta'e aana. Oto aana Dinge Maa'i Mo Jiu, e lai sili weu i nume ni palo-palo ikire oto mala ko lae-lae tarau, na e uure i lengi huni saaie mo Uusu-uusu Maa'i. ");
INSERT INTO apb_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Oto kire ko niie uusu-uusu hio-hio a Propet Aesaea hunie, na ko tahanie oto aana leu nge e uusue uuri, ");
INSERT INTO apb_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Li'oa Maa'i a God oto pe'ieu, aena aana e lio hilisieu huni taroha'inie Tataroha Diana hunie mo iinoni meitale. E uusunge'inieu huni taroha'inie uri mo iini kire ho'osire i nume ni ho'o uri kire ke ii'o luheta'i oto, na huni ha'arongoa mo ulu uri kire ke lio lo'u, na huni unue hunie mo iini kire ii'o i mamalutana mwala e sai ha'amwe'u-mwe'u uri kire ke ii'o luheta'i lo'u, ");
INSERT INTO apb_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","na huni tola tahanga'inie uri e hule oto aana maholo a God kei pe'ie mwala ingeie. ");
INSERT INTO apb_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Oto a Jisas e si lulungie uusu-uusu hio-hio, ko niie hunie iini ko hei rareta'i aana nume ni palo-palo ngeena, na ko ii'o oto i aano huni ha'a-uusuli. Maholona oto ahutana mwala i laona nume ni palo-palo ngeena kire ko si meni lio hahuroto oto aana. ");
INSERT INTO apb_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Oto a Jisas ko aehota ere-ere hunie mwala e loko ngeena na ko te'uri, “Mei wala aana mo Uusu-uusu Maa'i nge omu si kele rongoa saailana e lae namiu ngeena, ko oa oto huni'omu si'iri.” ");
INSERT INTO apb_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Oto ahutana mwala ngeena kire ko si meni lahea oto pe'i pangata'inilana mo eehu'i wala nge ko unu'ine, ta'e kire ko unue lo'u uuri, “A mwane ngeena, ingeie kalena Josep mola ni ngeena.” ");
INSERT INTO apb_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Oto a Jisas ko te'uri hunire, “Nou saie mola kara'inie omu kei unue mei wala ni aalahuunge ngeena hunieu uuri, ‘Mwane kure-kure, o ke ha'a-uuri'o ka'u.’ Aana omu ko lo'onga'inie mola uri, e lae otoi diana uri mo hu'i-hu'ite nge omu rongoa nou esui'i ke'u hai Kapaneam, ne ke asui'i lo'u mei leu. ");
INSERT INTO apb_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Ta'e no ko unue oto huni'omu uri mwala aana tohungei henue nga propet, e aasa oto hunie kire ke ha'ama'u aana wa kire ke rongo hunie. ");
INSERT INTO apb_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Nga taa no ko unue ie e to'ohuu. Aana maholo pongine a Propet Elaeja, mo nao keni hunge kire o'o'o i Israel. Aana maholona e ka'a nemo ike hunie e oolu helisi pe'ie e oono waro-waro, na hiolonga paine e toolea ahutana hanue. ");
INSERT INTO apb_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Ta'e hule aana uusunge'inilana Elaeja e ka'a lae ike i saana nga ta'a-ta'a iini aada. Uusunge'inilana e lae mola huni pe'ie mei nao keni aana huilume mo pu'o wau i Serepat aana po'o ni henue i Saedon. ");
INSERT INTO apb_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Na aana maholo pongine a Propet Elaesa mwala hunge ni Israel kire to'o aana maelaa ni osa, ta'e e ka'a ha'a-uurie ike nga iini aada. Ta'a-ta'a iini e ha'a-uurie oto a Neman, mwane aana aalahanga mo pu'o i Siria.” ");
INSERT INTO apb_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Oto maholo mwala i laona nume ni palo-palo ngeena kire rongoa walu ola ienini, kire ko si tohungei saewasu. ");
INSERT INTO apb_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Oto kire taule'i, kire ko oohea oto ta'au i lengine tolana uuwo nge hanue ikire e ii'o aana, aena aana kire sasare pwelusie i kere-kerena mao'i aana leu e aasa. ");
INSERT INTO apb_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Ta'e maholo kire hule aana leune, a Jisas e liu mola i matolada, e si lae mwaanire. ");
INSERT INTO apb_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Oto a Jisas e si lae hunie huilume i Kapaneam aana po'o ni henue i Kalili. Na aana Dinge Maa'i Mo Jiu e si ha'a-uusulie mwala. ");
INSERT INTO apb_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Ahutana mwala ko tohungei pangata'inie ha'a-uusulinge ingeie, aana ko ha'a-uusuli aana nanamanga. ");
INSERT INTO apb_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Na nga mwane li'oa aaela aana ingeie no'one wau i laona nume ni palo-palo aana maholona. A mwaena ko toolea oto aawaranga paine na ko unue uuri, ");
INSERT INTO apb_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“!Aaia! !Jisas ni Nasaret! ?O kei ue emeelu lo'u eena? ?Ohe o lae oto mai huni waeli'emeelu ni ngeena? Ineu nou sai'o mola. I'oe iini maa'i a God.” ");
INSERT INTO apb_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Oto a Jisas ko si ere aana li'oa aaela ngeena ko te'uri, “O ke rohu oto, na o ke lae mwaanie a mwane ngeena.” Oto li'oa aaela ngeena e ka'a waelie lo'u a mwaena, ta'e e si repute'inie mola hai aano i matolana mwala na ko iisitaa oto mwaanie. ");
INSERT INTO apb_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Ahutana mwala ko si meni pangata'i na kire ko ere hailiu oto i matolada uuri, “?Nga mei ha'a-uusulinge uri taa ni ienini? Aana a mwane ie e to'o aana nanamanga huni ere aana mo li'oa aaela pe'ie mei wala e saka, oto kire iisitaa oto.” ");
INSERT INTO apb_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Oto tataroha aana Jisas ko si tatangasie oto ahutana po'o ni henuena. ");
INSERT INTO apb_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Oto a Jisas e uure mwaanie nume ni palo-palo mo Jiu ko si lai sili i nume a Saemon. Keni hungaona Saemon ko tohungei mata'i oto hiito'o, oto mwala ko aitanaie Jisas uri ke pe'ie. ");
INSERT INTO apb_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Oto e lae wau i uure i sulie tahe a hu'ena, ko si ere aana mata'i ngeena uri ke lae mwaanie. Mata'i ngeena e lae oto mwaanie a hu'ena, na e tolana ta'ela'i, na ko rareta'inire oto. ");
INSERT INTO apb_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Oto aana maholo ko seulehi oto, mwala e to'o aana mo iini ko mweri aani maelaa hai aaopa'i kire ko toolera oto mai saana a Jisas. Na e hele i sapeda aana nimana, na ko ha'a-uurire oto. ");
INSERT INTO apb_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Mo iini hunge mo li'oa aaela e iisitaa no'one mwaanire, na kire ko aawara uuri, “!I'oe oto Kalena God!” Ta'e a Jisas e ere aada mwaanie uri kire he'i unue lo'u nga mei wala, aana kire saie uri ingeie ni oto a Kraes. ");
INSERT INTO apb_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Oto e dangi ho'owa, a Jisas e uure mwaanie huilumena ko si lae huni ii'o maraana aana nga leu, ta'e mwala ko lo'ohie lo'u mola. Maholo kire lio oodoie, oto kire ko sare uure honosie uri mwaanie e he'i lae lo'u mwaanire. ");
INSERT INTO apb_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Ta'e a Jisas e te'uri hunire, “Ne kei lae pe'i laeliwala no'one aana Tataroha Diana aana Aalahanga God nana ngaeta mo henue, aena aana leune mone a God e uusunge'inieu mei.” ");
INSERT INTO apb_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Oto a Jisas e si lae pe'i laeliwala i laona ahutana mo nume ni palo-palo mo Jiu ahusie oto ahutana hanue i Jiudia. ");
INSERT INTO apb_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Ngaeta hai dinge a Jisas e uure i reune Aasi I Kalili na mwala hunge kire loko no'one mai saana. Oto mwala ngeena kire ko uure su'u-su'uie, aena aana kire ko sare rongoa walana God. ");
INSERT INTO apb_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Oto a Jisas e leesie e ro iiola kire ooke puri eeni hai oone, na mwala wee-weesi e lae oto mwaani'i aana kire ko hodalie mo hu'o ikire. ");
INSERT INTO apb_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","A Jisas e hane i laona ngaeta iiola, iini a Saemon, na ko unue hunie uri ke kele uusue wau mwaanie oone. Oto e ii'o i laona iiola, ko si ha'a-uusulie mwala. ");
INSERT INTO apb_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Maholo e ere-ere mango nana mwala, e si unue hunie a Saemon uuri, “O ke dau su'uweu aana leu kokoro, na omu ke aatongie hu'o i eesi hunie nga mo ii'e.” ");
INSERT INTO apb_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Oto a Saemon ko aalamie na ko te'uri, “Poro paine, melu ha'aweo'emeelu ka'u aani lionga haidengie'i, na melu ka'a kele saunie ike nga mei ola. Ta'e i sulie walamu, nge ne kei he'i aatongie lo'u hu'o.” ");
INSERT INTO apb_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Oto kire ko aatongie lo'u hu'o, na kire ko si we'i haahie mo ii'e oto hunge, hule aana hu'o na ko kara'i haka oto lo'u. ");
INSERT INTO apb_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Oto kire soie mo oada aana ngaeta iiola huni lae mai pe'ire. Mo oada kire lae mai saada, kire ko si ha'ahonue ahutana e ro iiola aani ii'e, hule aana kire ko kara'i dodo oto. ");
INSERT INTO apb_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Maholo a Saemon Pita e leesie nga taa e rau ngeena, oto ko si pouruuru i na'ona Jisas na ko te'uri, “O ke lae mwaanieu Aalaha, aana ineu iinoni ni ooraha'aa.” ");
INSERT INTO apb_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Aana a Pita na mo iini lo'u pe'ie kire ko si meni pangata'inie mo ii'e oto hunge nge kire wa'i haahi'ine. ");
INSERT INTO apb_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","A Jemes na a Jon, e ro kalena Sebedi, e ro oana a Saemon na kirerue ko tohungei pangata'i no'one. Oto a Jisas ko te'uri hunie a Saemon, “Mwaanie o ma'u-me'u. Uure si'iri pwau weu, o kei ne'i iinoni wee-weesi oto hunie mo iinoni.” ");
INSERT INTO apb_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Oto kire ookea mo iiola i oone, na kire toli puri aana to'o-to'olada, kire si lulu i sulie a Jisas. ");
INSERT INTO apb_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Ngaeta maholo a Jisas e ii'o aana ngaeta huilume na mwane ko sapesalu aana maelaa ni osa, ingeie no'one i leune. Oto maholo a mwaena e leesie a Jisas, ko si lai pouruuru honosie na ko ha'atohu aana uuri, “Aalaha ineu, mala o ko mwa'e-mwa'e, o ke kuraa sapeku hunie ne ke rere'a adona ii'onga lo'u pe'ie mwala a God.” ");
INSERT INTO apb_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Oto a Jisas e si susue'inie wau nimana huni hele i sapena mwaena, na ko aalamie uuri, “Iau, nou mwa'e-mwa'e taane. Sapemu ke mola oto.” Oto maelaa ni osa ngeena e tolana mango oto mwaanie. ");
INSERT INTO apb_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Oto a Jisas ko si te'uri hunie, “Mwaanie o ha'a-ha'arongoa nga iini aana nga taa e rau. Ta'e o ke oodo mola i saana mo pris hunie kire ke saie uri sapemu e mola oto. Na o ke niie uuraa'inge hunie a God mala mo Ha'atolanga a Mosis e unue. Urine ahutana mwala kire ke si meni saie uri sapemu e mola oto.” ");
INSERT INTO apb_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Ta'e tataroha aana Jisas e si taro hiito'o lo'u mola, nge mwala hunge e si lae mai huni rongoa Jisas, na hunie ke ha'a-uurire mwaanie ta'ena nga maelaa. ");
INSERT INTO apb_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Ta'e ingeie e he'i lae lo'u mola mwaanire huni ii'o maraana huni aarenga'i. ");
INSERT INTO apb_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Aana ngaeta hai dinge a Jisas e ha'a-uusulie mwala, na ngaeta mo Parise na mo ha'a-uusuli aana mo Ha'atolanga a Mosis, ikire no'one i leune. Kire uure no'one mai mwaanie i Jerusalem na ahutana mo huilume aana mo po'o ni henue i Kalili na i Jiudia. Na a Jisas e to'o aana nanamanga a God e wa'u huni ha'a-uurie mo iini ko mweri. ");
INSERT INTO apb_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Ngaeta mo mwane kire lae mai na kire aanga'inie mwane e rarasi aana hulite. Oto mo mwaena ko sare toolea i nume hunie kire ke ne'ie i na'ona Jisas. ");
INSERT INTO apb_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Ta'e aena aana mwala e hunge, oto kire ka'a saie ike uri kire kei liu pe'ie uri taa i nume. Oto kire aanga'inie, kire ko si hane pe'ie mola ta'au i koluhana nume. Oto kire si hoka'ie koluhana nume talana mwane rarasi ngeena. Oto kire uukue mola i aano i matolana mwala i na'ona Jisas. ");
INSERT INTO apb_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","A Jisas e leesie hiiwalaimolinge mo mwane ngeena e paine, e si te'uri hunie mwane e rarasi ngeena, “Kaleku, mo ooraha'aa i'oe sae'aasileni e lae oto.” ");
INSERT INTO apb_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Oto mo Parise na mo ha'a-uusuli aana mo Ha'atolanga a Mosis, kire ko aehota papanguru-nguru oto hunire maraadaelu uuri, “?A tei mwane ni ko ere tooha'inie uri ingeie e paine mala God ie? Ta'a-ta'a iini e sai sae'aasi ooraha'aa oto mola nge a God.” ");
INSERT INTO apb_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Oto a Jisas mone e saie mola mo lo'onga'inge ikire, ko si te'uri hunire, “?E ue nge omu ko lo'o-lo'onga'i oto hiito'o urine? ");
INSERT INTO apb_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Omu saie ka'u uri erenga ni mola e mwada'u, na ta'ena nga iini e sai unue mola uuri, ‘Mo ooraha'aa i'oe sae'aasileni e lae oto,’ na lo'u uuri, ‘!Ta'ela'i! !O ke lae-lae oto!’ Ta'e huni esuie e ro mei ne'isaenga ngeena, kire tohungei aasa oto hiito'o hunie iinoni. ");
INSERT INTO apb_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Ta'e ineu, a Kale Ni Iinoni, ne kei esuie mola mei ola hunie omu ke lio saie uri ineu, nou to'o aana no'one nanamanga huni sae'aasi ooraha'aa mai aano i leu.” Oto a Jisas e si unue hunie mwane e rarasi ngeena uuri, “!Ta'ela'i! O ke toolea hulite i'oe na o ke lae-lae oto i nume i'oe.” ");
INSERT INTO apb_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Oto a mwaena e tolana ta'ela'i oto i na'ona ahutada, e toolea hulite nge e eno-enohie, na ko lae oto pe'i paalahea God i nume ingeie. ");
INSERT INTO apb_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Oto ahutana mwala ko si meni pangata'i, na kire ko soi ha'amanikulu'aa God. Ta'e kire ko me'u no'one, oto kire ko unue uuri, “!Ha'ike eena! Mo ola e si lai lio aaopa ka'u kolu ko leesi'i si'iri ie.” ");
INSERT INTO apb_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Oto i purine, a Jisas e si lae mwaanie huilume na ko leesie nga mwane satana a Livae e ii'o aana leu ingeie huni totola to'oha aana takis hunie aalahanga ni Rom. Oto a Jisas ko te'uri hunie, “O ke lulu i sulieu.” ");
INSERT INTO apb_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Oto a Livae e ta'ela'i, ko toli puri oto aana to'o-to'olana na ko lulu i sulie oto. ");
INSERT INTO apb_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Oto a Livae ko esuie ngaunge paine hunie a Jisas i nume ingeie, na mwala hunge kire loko aana ngaunge ngeena. Hungelana mwala e loko ngeena, ikire mwala susulu to'oha no'one. ");
INSERT INTO apb_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Aena leune, ngaeta mo iini aana mo Parise na mo ha'a-uusuli aana mo Ha'atolanga a Mosis kire ko upwesie mo pwaarongoisuli a Jisas uuri, “?E ue nge omu ko ngeu na omu ko inu pe'ie mo iinoni ooraha'aala mala mo mwane susulu to'oha ngeena?” ");
INSERT INTO apb_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Ta'e a Jisas ko aalamire uuri, “Iinoni nge e awaa mola sa'a saeto'o aana ike mwane kure-kure, ta'e iini nge ko maelaa'a ha'alaa. ");
INSERT INTO apb_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Nou lae mai huni haaraie mo iinoni ooraha'aa ke oonisae, na nou ka'a lae ike mai huni haaraie mo iini kire unue kire diana oto.” ");
INSERT INTO apb_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Oto ngaeta mo iini ko unue hunie a Jisas uuri, “Mo pwaarongoisuli a Jon nge kire ko oolo-oolongau tarau, hunie aarenga'inge. Mo iini ikire mo Parise na kire ko tete'urine no'one. ?Ta'e e ue nge mo pwaarongoisuli i'oe kire ko talei ngeu-ngeu na inu-inu mola?” ");
INSERT INTO apb_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Oto a Jisas ko aalamire uuri, “?Mo malahune a poro haalu kire kei saehuu uri taa na kire ko ngeu-ngeu ue aana ngauhe ni ha'arurunge na a poro haalu e ii'o ue pe'ire? ");
INSERT INTO apb_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Ta'e kei hule aana hai dinge nge kire kei toolea poro haalu mwaanire, nge kire ke si oolongau taane.” ");
INSERT INTO apb_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Oto a Jisas ko he'i unue lo'u mei wala ni aalahuunge ie i sulie ha'a-uusulinge haalu ingeie hunire uuri, “Nga iini e sa'a a'arie ike nga leu aana to'oni haalu huni lo'amenaa nga to'oni lalahu'e. Mala uri kei te'urine, ko waelie mola to'oni haalu ni ngeena, aena aana mei lo'amena haalu e sa'a sada ike pe'ie to'oni lalahu'e. ");
INSERT INTO apb_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Wa uri nga iini sa'a huie ike waen haalu i laona mo ate'a lalahu'e nge kire asui'i eeni te'e-te'ei nanikot. Mala kei te'urine, ahutana e ro mei ola ngeena kei meni aaela, aana waen haalu kei hoka'ie mola mo te'e-te'ei olana, oto waen ko si aahe aasie mola. ");
INSERT INTO apb_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","!Ha'ike! Ta'e ne'i-ne'ie oto waen haalu i laona mo ate'a aani te'e-te'ei nanikot haalu hali'ite. ");
INSERT INTO apb_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Ta'e omu saie mone tolahana mo iinoni. Kire kei sere'inie ha'a-uusulinge haalu ineu mala mwala ka'a saeto'o aana ike waen haalu i purine inuhilana waen lalahu'e.” ");
INSERT INTO apb_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Ngaeta Dinge Maa'i Mo Jiu a Jisas e lai liu i laona mo hohola aani ola mala kooni. Oto mo pwaarongoisuli ingeie kire ko aroa mo hue-huei ola, kire ta'aasie hule-huleni, oto kire ko ngeu'i. ");
INSERT INTO apb_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Oto ngaeta mo Parise kire ko dolosi uuri, “?E ue nge omu ko deu esunge mola aana Dinge Maa'i ikie, mei ola e aapu aana Ha'atolanga a Mosis?” ");
INSERT INTO apb_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Oto a Jisas e aalamire ko te'uri, “Omu saie taane nga taa nge a Deved Inemauri e asuie, aana maholo ingeie na ngaeta mo iini lo'u pe'ie kire hiolo. ?Ta'e e ue ni omu ka'a rongo saie ike ne'isaenga aana? ");
INSERT INTO apb_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","A Deved e lae sili i laona nume maa'i a God, na e ngaue ho bred maa'i, ola niilana e lae hunie a God. Ta'e mo Ha'atolanga a Mosis e unue e ka'a malisine ike ke ngaue, aana ta'e mo pris hali'ite kire sai ngaue taungei bred maa'i urine. Na a Deved e nii no'one ana mo iini kire lae pe'ie. Ta'e ma'alana e urine, a God ka'a leie ike haahie.” ");
INSERT INTO apb_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Oto a Jisas ko he'i te'uri lo'u hunire, “Ineu a Kale Ni Iinoni oto nou aalaha haahie Dinge Maa'i.” ");
INSERT INTO apb_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Oto aana ngaeta Dinge Maa'i Mo Jiu lo'u, a Jisas e lai sili i nume ni palo-palo huni ha'a-uusulie mwala. Na ngaeta mwane i leune ki'ine i pwalo-pwalona e heko. ");
INSERT INTO apb_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Oto mo Parise na mo ha'a-uusuli aana mo Ha'atolanga a Mosis, kire ko talei to'o-to'omaaie ohe kei ha'a-uurie a mwaena aana Dinge Maa'i, aana kire sare leesie uri a Jisas ke dau aaelasie nga mei ola hunie kire ke ere aana na kire ke toolea huni leie haahie. ");
INSERT INTO apb_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Ta'e a Jisas e saie mone mola lo'onga'inge ikire, ko si te'uri hunie mwane ki'ine e heko ngeena, “O ke uure ka'u i na'ona mwala.” Oto a mwaena e ta'ela'i, e si uure haada'i i na'ona mwala. ");
INSERT INTO apb_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Oto a Jisas ko te'uri hunie mo iini kire ko upwesie ngeena, “Ta'a-ta'a mei ola nou sare dolosie aamiu. ?Nga taa ni Ha'atolanga ikolu e toli'aasie huni esuie aana Dinge Maa'i? ?Huni pe'ie iinoni wa huni waelie mola? ?Huni ha'a-uurie iinoni wa huni horo'ie?” ");
INSERT INTO apb_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","E ere mango urine, ko si to'omaaie nga iini, na e to'omaaie lo'u nga iini. E to'omaaire mango, oto ko unue hunie mwane ki'ine e heko ngeena uuri, “O ke lalaa'inie ki'imu.” Oto a mwaena ko lalaa'inie ki'ine, na e diana oto lo'u. ");
INSERT INTO apb_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Oto mo Parise na mo ha'a-uusuli aana mo Ha'atolanga a Mosis kire ko tohungei saewasu, na kire ko aehota ere oto i matolada maraada uuri, “?Ohe kolu kei uaa ka'u a mwane ngeena?” ");
INSERT INTO apb_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Aana maholona a Jisas e hanetaa ta'au i lengine ngaeta uuwo huni aarenga'i. E ii'o ta'au i leune hai rodo laku aani aarenga'inge hunie a God. ");
INSERT INTO apb_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Oto e dangi ho'owa e soie mo iini ko lulu i sulie mai i saana, ko si lio hilisie aawalai mwane mwana rue mwaanire, na ko haara'inire aana mo hurula'aa. ");
INSERT INTO apb_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Na satana aawalai mwane mwana rue ngeena e uuri, a Saemon nge a Jisas e he'i haara'inie lo'u aana a Pita, na a Andru aasine, na a Jemes, na a Jon, na a Pilip, na a Batolomiu, ");
INSERT INTO apb_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","na a Matiu, na a Tomas, na a Jemes kalena Alpeas na a Saemon, ngaeta iini aana pulitaa nge ko sare haiseuni huni ta'aasie aalahanga ni Rom mwaanie hanue i Israel, ");
INSERT INTO apb_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","na a Jiudas kalena Jemes, na a Jiudas Iskariot iini oto e pweloa Jisas. ");
INSERT INTO apb_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Oto a Jisas na mo hurula'aa ingeie kire siho mai mwaanie uuwo, kire si lae mai uure i laona mei oote. Aana maholona nge mwala hunge aana mo iini ko lulu i sulie a Jisas kire si loko mai i saana. Mwala hunge kire loko no'one uure mai mwaanie i Jerusalem na mwaanie ahutana oto po'o ni henue i Jiudia na mwaanie mo henue i sulie hatalea i Taea na i Saedon. ");
INSERT INTO apb_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Mwala ngeena kire lae mai huni rongoa a Jisas ko ha'a-uusuli, na uri hunie ha'a-uurilada ke lae mwaanie mo maelaa ikire. Mo iini ko si'oha'a aana mo li'oa aaela e hite aada na kire hule no'one, oto a Jisas e ha'a-uurire. ");
INSERT INTO apb_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Ahutana mwala kire mani deu-deu uri kire ke kopi mola aana a Jisas, aena aana nanamanga ingeie ko ha'a-uurie ahutana mo maelaa ikire. ");
INSERT INTO apb_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Na a Jisas e to'o-to'omaaie mo pwaarongoisuli ingeie, ko si unue hunire uuri, “Deidehi'omu mo iini nge omu meitale, aena aana Aalahanga a God oto to'olamiu. ");
INSERT INTO apb_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Deidehi'omu mo iini nge omu ko hiolo oto ie, aena aana omu kei pote taane. Deidehi'omu mo iini nge omu ko ngara-ngara oto ie, aena aana omu kei mwesi taane. ");
INSERT INTO apb_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Deidehi'omu mo iini nge mwala ko maaleledi'omu, na kire ko teunge'ini'omu, na kire ko ere aaelasi'omu uri i'omu mo iinoni aaela aana omu ko lulu i sulieu a Kale Ni Iinoni. ");
INSERT INTO apb_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Omu ke tohungei ilenimwa'e aana maholona na omu ke mao-mao pe'i saediananga, aena aana waaitemiu e paine oto ta'au i Lengi. Na urine e haata'i diana aana uri omu urihana mo propet a God oto i na'o, aana mo weuwada i na'o kire taunge'inire no'one urine. ");
INSERT INTO apb_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Ta'e aama-aamasilemiu mo iini omu to'o-to'o oto, aana ahutana walu ola e mani mwada'usi'omu mango oto, ta'e aasanga paine kei re'usi'omu taane. ");
INSERT INTO apb_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Aama-aamasilemiu mo iini omu ko pote oto ie, aana omu kei saronai hiolo taane. Aama-aamasilemiu mo iini omu ko mwesi pe'i saediananga aana maholo ienini, aana omu kei saronai saehuu pe'i ngara aamasi'omu taane. ");
INSERT INTO apb_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Aama-aamasilemiu maholo mwala ko ere ha'adiana'a'omu, aana leune e haata'i diana aana uri omu meni sada oto pe'ie mo propet eero-eero i na'o, i sulie ta'a-ta'a taungei olana e rau ke'u no'one aada.” ");
INSERT INTO apb_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Oto a Jisas e he'i unue lo'u uuri, “Ta'e ineu no ko unue huni'omu, mo iini omu ko pwaarongoa ere-erenga ineu, uri omu ke manata diana no'one hunie mo maelonga i'omu. Omu ke dau diana hunie mo iini ko maaleledi'omu. ");
INSERT INTO apb_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Omu ke aitanaie a God hunie ke ha'adiana'aa mo iini ko ere aaelasi'omu, na omu ke aarenga'i talana mo iini ko teunge'ini'omu. ");
INSERT INTO apb_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Mala nga iini ko mwakata'ini'o aani hidelilana papalimu, nge o ke toli'aasie ngaeta po'o ni papali lo'u hunie. Mala nga iini ko toolea to'oni ni eeluhi i'oe, toli'aasie no'one to'oni ni lengi i'oe hunie. ");
INSERT INTO apb_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Omu ke nii-nii hunie ta'ena nga iini ko suke aamiu. Mala uri nga iinoni ko toolea nga mei ola i'oe, su'uri suke aaliho'i lo'u aana. ");
INSERT INTO apb_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Mo ola nge saemiu mwala ke dau'i huni'omu, nge i'omu no'one omu ke dau'i hunie mwala. ");
INSERT INTO apb_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","?Aana mala uri omu kei manata diana mola hunie mo iini e manata diana huni'omu, omu unue uri a God kei ha'adiana'a'omu haahie leune? !Ha'ike oto oo'oo! Aena aana mo iinoni ooraha'aa na kire ko maa-manata diana no'one mola urine hunie mo iini e manata diana hunire. ");
INSERT INTO apb_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","?Na mala uri omu kei deu diana mola hunie mo iini ko deu-deu diana huni'omu, omu ko lo'o-lo'onga'i uri a God kei ha'adiana'a'omu haahie leune? !Ha'ike oto oo'oo! Aena aana mo iinoni ooraha'aa na kire ko tete'urine no'one mola. ");
INSERT INTO apb_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","?Na mala uri omu ko sai nii ola mola hunie mo iini nge omu saie uri kire kei he'i su'u'i lo'u huni'omu, omu ko lo'o-lo'onga'i uri a God kei ha'adiana'a'omu haahie leune? !Ha'ike oto oo'oo! Aena aana mo iinoni ooraha'aa kire sai nii urine no'one hunie ngaeta mo iinoni ooraha'aa uri hunie kire ke su'u sada aani lo'u hunire. ");
INSERT INTO apb_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","!Ta'e ha'ike! Omu ke manata diana hunie mo maelonga i'omu na omu ke dau diana hunire. Omu ke nii-nii na omu ke su'uri lo'onga'inie lo'u su'uleni eeliho'i huni'omu. Mala uri omu kei te'urine nge waaitemiu ke si peine lo'u liutaa, na omu ke si ne'i kalena God, iini e paine liutaa. Aana ingeie no'one hule aana e diana hunie mo iini e ooraha'aala na mo iini ka'a sai paalahea. ");
INSERT INTO apb_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Omu ke hai-hei aamasi oto mala Aamamiu i Lengi ko hei-hei aamasi hunie ta'ena nga iinoni.” ");
INSERT INTO apb_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Oto a Jisas ko he'i te'uri lo'u, “Mwaanie omu talei lei-leie ta'ena nga iinoni, mwaanie a God e lei'omu no'one urine. Mwaanie omu talei lei-lei maesie nga mwala, hunie a God ke su'uri lei maesi'omu no'one. Na omu ke sae-sae aasi hunie mo iinoni, hunie a God ke si sae'aasi no'one huni'omu. ");
INSERT INTO apb_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Omu ke nii-nii hunie ta'ena nga iinoni, nge a God ke si nii lo'u liutaa huni'omu. Aana to'ohuu niilana kei lae huni'omu, hule aana omu ka'a saie omu kei hele uri taa aani aana nimemiu, oto kire ko maalingi mola. Aana nga tolahai niinge uri taa nge omu ko nii-nii hunie mwala aana, nge a God kei nii no'one huni'omu aana.” ");
INSERT INTO apb_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Oto a Jisas ko ere ni aalahuunge lo'u uuri, “Nga iinoni e ulu e sa'a na'ona ike lo'u ngaeta ulu, mwaanie kirerue mani domu mola i laona kalinge. ");
INSERT INTO apb_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Iinoni ha'a-uusulilana ko lae-lae ue, e ka'a paine ike liutaa aana ha'a-uusuli ingeie. Ta'e mala kei esu waa'ini'ini nge ke si urihana mola ha'a-uusuli ingeie. ");
INSERT INTO apb_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","?E ue ka'u o ko ili lio susulie kele nganga'ai ola oto mola mwai-mwei i maana aasimu? Ta'e hule aana i'oe, rotoi ei leku e eno honosie maamu na o ka'a sai hiinge'inie. ");
INSERT INTO apb_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Na e ka'a diana ike no'one uri hunie o ke unue hunie aasimu uuri, ‘Ka'u, ne ke ta'aasie kele nganga'ai ola ngeena mwaanie maamu,’ na hule aana i'oe maraamu rotoi ei laku no'one mola e eno honosie maamu. !Nga hero-heronga ka'a urine ike! Mala uri o ko te'urine, nge o ko lupwe'i deu-deu mola ni ngeena. Ta'e o ke hola'i ta'aasie ka'u rotoi ei laku ngeena mwaanie maamu hunie maamu ke manola. Oto o ke si lio susulie kele nganga'ai ola i maana aasimu hunie o ke kae aasie.” ");
INSERT INTO apb_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Oto a Jisas ko he'i te'uri lo'u, “Ai diana e sa'a roro'a hungu ike aani hue-huei ei aaela, wa ai aaela ke hungu eeni hue-huei ei diana. ");
INSERT INTO apb_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Ta'ena nga ai, lio sailana ko lae-lae oto aana hue-huana, aana mwala e sa'a hisue ike nga hue-huei fik mwaanie nga puli-pulisi poo, wa kire ke hisue nga hue-huei grep mwaanie nga walo kau-keu. ");
INSERT INTO apb_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Iinoni diana e to'o aana mo lo'onga'inge diana i laona saena, na kei haata'ini'i aana mo ola diana kei esui'i. Ta'e iinoni aaela e to'o aana mo lo'onga'inge aaela i laona saena, na kei haata'ini'i aana mo ola aaela kei esui'i. Aana iinoni ko ere-ere i sulie nga taa nge saena e honu aana.” ");
INSERT INTO apb_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Oto a Jisas e he'i te'uri lo'u, “?E ue ni omu ko soieu na ni omu unue oto, ‘!Aalaha ineu!’ ta'e hule aana omu sa'a dau i sulie nga taa no ko unue? ");
INSERT INTO apb_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Ta'e-ta'ena nga iini ko lae mai seeku na ko rongoa walaku pe'i sulu i suli'i, ");
INSERT INTO apb_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","e urihana iinoni saenanau e tohue nume ingeie aana e eli kokoro talana mo hunu, na e ne'ie mo heu i poo-pootana mo hunu aana nume ngeena. Oto lae-lae maholo wai kei kone na kei halolo aana nume ngeena, ta'e hule aana e sa'a asule'i ike, aena aana e tohu diana aana. ");
INSERT INTO apb_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Ta'e nga iini nge ko rongoa walaku na e ka'a sulu ike i sulie, ingeie e urihana iinoni e tohue nume ingeie mola i lengine oone mwaakule. E ka'a eli kokoro ike wa ke ne'ie mo heu ehuie mo hunu. Oto lae-lae maholo kone kei halolo aana numena, na kei tolana aa'oho ta'ingelu oto.” ");
INSERT INTO apb_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","I purine a Jisas e saro ere-ere mango aana walu ola ienini hunie mwala, e si lae hunie i Kapaneam. ");
INSERT INTO apb_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Na koni-konihe ngaeta na'ohai mwane aana mae ni Rom ko tohungei mweri oto hiito'o wau i leune. Koni-konihe ngeena ko kara'i mae oto, na poro paine ingeie e tohungei ne'isae paine haahie. ");
INSERT INTO apb_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Oto maholo na'ohana mae ngeena e rongo tarohana a Jisas, oto ko uusunge'inie ngaeta mo rato aana mo Jiu, uri kire ke lai eitanaie a Jisas hunie ke lae mai ha'a-uurie koni-konihe ingeie nge ko mweri ngeena. ");
INSERT INTO apb_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Mo rato ni mwane ngeena kire lae mai saana a Jisas, oto kire ko eitanaie uuri, “E tohungei adona oto uri o ke pe'ie a poro paine aana mae ie, ");
INSERT INTO apb_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","aena aana e manata diana hunikie mo Jiu, hule aana ingeie maraana e tohue nume ni palo-palo hunie huilume i'emeelu.” ");
INSERT INTO apb_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Oto a Jisas e lae oto pe'ie mo mwaena. Maholo ko lae oto mai kara'inie nume a poro painena, na a porona ko uusunge'inie oto ta'au ngaeta mo malahune honosie huni ha'arongoa uuri, “Aalaha ineu, o ke su'uri ha'aweo'o lo'u huni lae mai, aana nou ka'a malisine ike uri o ke lai sili i nume ineu. ");
INSERT INTO apb_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Aena leune no'one nge nou lo'onga'inie uri nou ka'a malisine ike laenga mai honosi'o. Ta'e nou hiiwalaimoli uri aana o ke unue mola nga mei wala, na koni-konihe ineu kei awaa oto. ");
INSERT INTO apb_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Aana ineu na nou ii'o no'one i mamalutana nanamanga ngaeta mo poro paine, na nou to'o aana no'one mo ramo i meluteku. Na mala no ko unue hunie nga ramo uuri, ‘Lae wau,’ na ko lae oto wau. Na mala no ko unue hunie ngaeta ramo uuri, ‘Lae mai,’ na ko lae oto mai. Na mala no ko unue hunie koni-konihe ineu uuri, ‘O ke asuie mei esunge waune,’ na ko esuie oto.” ");
INSERT INTO apb_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Maholo a Jisas e rongo urine, e si pangata'inie na ko te'uri hunie mo iini ko lae i sulie, “To'ohuu no ko unue huni'omu uri nou ka'a lio oodoie ike ue nga mwane ni Israel ke hiiwalaimoli eeku mala mwane ni Rom ie.” ");
INSERT INTO apb_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Oto mo malahune a poro paine ngeena kire aaliho'i ta'au i nume ingeie, na kire ko leesie oto koni-konihe ingeie e awaa oto lo'u. ");
INSERT INTO apb_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Oto lo'u mola i purine leune e rau, a Jisas na mo pwaarongoisuli ingeie kire ko he'i lae lo'u hunie huilume i Nein. Na mwala hunge kire hakusire no'one aana maholona. ");
INSERT INTO apb_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Maholo ko nanauhie mai maana para aana huilume, na ko leesie mwala ko lai heitoli. Kire aanga'inie rae aana ta'a-ta'a kele mwela moute'i, kalena mei nao keni, na mwala hunge aana hanuena no'one pe'ie. ");
INSERT INTO apb_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Oto maholo a Aalaha e leesie ko si aamasie, na ko te'uri hunie, “Su'uri ngara-ngara.” ");
INSERT INTO apb_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Oto a Jisas e lae wau kara'inie, ko hele aana taetahe, na mwala e aanga'i kire uure hahuroto oto. Oto ko te'uri, “!Saanau, no ko unue huni'o, o ke ta'ela'i!” ");
INSERT INTO apb_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Oto saanau ngeena e ta'ela'i, na ko aehota ere-ere oto. Oto a Jisas e si toli'aasie hunie a nikana. ");
INSERT INTO apb_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Oto ahutana mwala ko meni pangata'i na kire ko soi ha'amanikulu'aa God uuri, “!Nga propet paine liutaa ka'u e ta'ela'i i matolakaelu ie! !A God e lae oto mai huni ha'a-uurie mo iinoni ingeie!” ");
INSERT INTO apb_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Oto tataroha aana a Jisas e si taro i sulie ahutana po'o ni henue i Jiudia na ahutana mo henue kali-kelie. ");
INSERT INTO apb_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Maholo mo pwaarongoisuli a Jon kire ha'arongoa aana walu ola nge a Jisas e asui'ine, oto a Jon ko haaraie ngaeta ro iini aada i saana. ");
INSERT INTO apb_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Oto ko uusunge'inire i saana a Jisas hunie uri kire ke lai dolosi aana uri ohe ingeie ni oto a Ha'a-uuri nge kire hiiwalaimoli aana uri kei lae mai, wa ohe kire kei maa'oohie ue nga iini aaopa. ");
INSERT INTO apb_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Oto maholo e ro mwane ngeena kire hule i saana Jisas, kire ko te'uri hunie, “A Jon Loto maa'i e uusunge'ini'emere'i huni dolosi eemu uuri, ‘?Uri i'oe ni oto a Ha'a-uuri kei lae mai, wa melu kei maa'oohie ue nga iini aaopa?’” ");
INSERT INTO apb_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Aana maholona no'one a Jisas ko ha'a-uurie mwala hunge pe'ie mo maelaa hai aaopa'i. E ha'a-uurie mo mae-maea'a na mo iini hunge mo li'oa aaela e hite aada, na e tahanie maana mo iini hunge maada e ulu. ");
INSERT INTO apb_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Oto a Jisas ko aalamie e ro mwane ngeena uuri, “More ke aaliho'i na more ke ha'arongoa a Jon aana nga moi taa more ko leesi'i na more ko rongo'i ienini. Aana mo ulu ko lio-lio oto, mo rarasi ko lae-lae diana oto lo'u, mo iini ko sapesalu aana maelaa ni osa kire mola oto, mo iini e pungu ko rorongo oto lo'u, na mo iini e mae kire ko meuri eeliho'i oto lo'u. Na laeliwalanga aana Tataroha Diana ko lae oto hunie mo meitale. ");
INSERT INTO apb_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Na more ke ha'arongoa no'one a Jon uri ilenimwa'enga paine kei lae hunie mo iini hiiwalaimolinge ikire e susu, na kire ka'a ne'isae rue-rua'a aaku.” ");
INSERT INTO apb_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Maholo e ro pwaarongoisuli a Jon kirerue aaliho'i oto, a Jisas ko si aehota ere-ere nana mwala i sulie a Jon uuri, “?Maholo omu lae ta'au i saana Jon i henuesala, nga taa ni omu lae ta'au huni leesie? ?Ohe omu lo'onga'inie uri a Jon nga iinoni saena e rue-rua'a mala apai rade ko eu'esule'i aana iiru? !Ha'ike! ");
INSERT INTO apb_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","?Wa nga ola uri taa ni omu lae-lae ta'au huni leesie? ?Ohe iinoni e to'oni eeni to'oni lio manikulu'e? !Ha'ike lo'u! Aana mwala nge kire to'o aana walu ola manikulu'e na kire ho'o to'oni diana urine, kire ko o'o'o mola aana mo nume mo inemauri. ");
INSERT INTO apb_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","?Ta'e nga taa ni omu lae ta'au huni leesie? ?Huni leesie nga propet? !Iau! !E to'ohuu oto! Na a Jon nge omu leesie e paine lo'u liutaa aana mo propet oto i na'o. ");
INSERT INTO apb_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Aana ingeie oto iini nge a God e ere rarangana i laona mo Uusu-uusu Maa'i uuri, Ne kei uusunge'inie hurula'aa ineu wau i na'omu hunie ke dau aakau aana tala i'oe loosi'o.” ");
INSERT INTO apb_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Oto a Jisas ko he'i unue lo'u uuri, “No ko unue oto huni'omu uri a Jon Loto Maa'i e paine liutaa aana ta'ena nga iini e hute mai welumalau. Ta'e iini nge e mwai-mwei oto liutaa aana Aalahanga a God e paine lo'u liutaa aana a Jon.” ");
INSERT INTO apb_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Maholo kire rongo urine, oto ahutana mo iini nge a Jon e loto maa'i aada, na oto mo iini e aaela oto hiito'o mala mwala susulu to'oha, kire mani unue uri leinge a God e oodota'i. ");
INSERT INTO apb_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Ta'e mo iini nge kire sere'inie uri a Jon ke loto maa'i aada mala mo Parise na mo ha'a-uusuli aana mo Ha'atolanga a Mosis, ikire maraada kire waelie mola ne'isaenga diana a God hunire. ");
INSERT INTO apb_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Oto a Jisas ko he'i unue lo'u uuri, “?Ne kei unu ha'amalaa pwaunge aana maholo ienini aana nga taa? ?Na uri kire urihana nga taa? ");
INSERT INTO apb_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Kire urihana mola pulitaa ni mwela nge ko pwarero i laona amaa, oto ruana nga pulitaa ko ere uuri hunire, I'omu, omu sere'inie mola ahutana mo pwareronga, Maholo melu ko kanalie mo kana ni ha'arurunge namiu, omu sa'a ilenimwa'e wa omu ke mao. Na maholo melu ko kanalie mo kana ni heitolinge namiu, omu sa'a saehuu wa omu ke ngara. ");
INSERT INTO apb_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","“I'omu, omu urihana mola mo mwela ngeena aena aana maholo a Jon e lae mai, e oolongau na e ka'a inu waen ike. Oto ahutana iinoni ko unue uuri, ‘A mwane ngeena nga li'oa aaela nge aana.’ ");
INSERT INTO apb_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Oto ineu a Kale Ni Iinoni, nou lae mai na no ko ngeu na no ko inu waen mola, oto mwala ko unue lo'u mola uuri, ‘A mwane ngeena ngauhana e paine na e tohungei sai inu hiito'o. Na mo malahune oto mola mwala susulu to'oha na mo iinoni ooraha'aa.’” ");
INSERT INTO apb_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Oto a Jisas e ha'amangoa erenga ingeie uuri, “Ta'e tolahana mo iini kire to'o aana saenanaunge a God kei haata'inie uri ikire oto mo iinoni to'ohuu.” ");
INSERT INTO apb_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Ngaeta maholo a Saemon, ngaeta iini aana mo Parise, e haaraie a Jisas hunie ke ngau pe'ie i nume ingeie. Oto a Jisas e lai sili i nume a mwaena, kire ko eno i aano oto i sulie tolahada hunie ngaunge. ");
INSERT INTO apb_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Na ngaeta keni aana hanuena e tohungei ooraha'aala oto hiito'o. Maholo a keine e rongoa uri a Jisas ko ngeu i nume Parise ngeena, oto e toolea mai ho ate'a diana e honu eeni rumu, ola e wasu mangoni oto hiito'o. ");
INSERT INTO apb_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Oto a keine e lae mai i saana a Jisas ko pouruuru i saana e ro ae'aena, ko si ngara pe'i oonisaenga na ko ha'amedoa e ro ae'aena a Jisas aana mo wei ni aakalo ko aahe mwaanie maana. Na ko hulo a'ate aana e ro ae'aena aana iihune pwaune. Oto ko nono'ie e ro ae'aena, na ko huie ho rumu e wasu mangoni ngeena i lengini. ");
INSERT INTO apb_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Maholo Parise nge e haaraie mai a Jisas e leesie urine, ko si lo'onga'i mola i saena maraana uuri, “Mala uri a mwane ie ke ne'ie nga propet to'ohuu, ha'alaa e lio saie mola taungei keni ie na e ka'a toli'aasie ike uri ke hele i sapena, aena aana keni ienini e ooraha'aala.” ");
INSERT INTO apb_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Oto a Jisas ko te'uri hunie, “Saemon, nou to'o aana nga mei ola huni unue huni'o.” Oto a Saemon ko aalamie uuri, “!Iau, Ha'a-uusuli! O ke unue ka'u.” ");
INSERT INTO apb_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Oto a Jisas ko unue uuri, “Ngaeta ro mwane kire o'o'o, kirerue mani tola kaoni aani to'oha mwaanie nga ta'a-ta'a aalaha huni su'ue lo'u mei puri. Nga iini e toolea e lime tangalai mei to'oha huni su'ue, na ngaeta iini e toolea mola e lime aata aawala. ");
INSERT INTO apb_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Ta'e lae-lae e ro mwane ngeena ka'a to'o aana ike nga mei to'oha huni su'ue lo'u nga taa kirerue tola kaoni aana. Oto aalaha ngeena, e unue mola uri kirerue sa'a su'ue lo'u nga taa kirerue tola kaoni aana ngeena. Oto ne ke dolosi mola uuri aamu, Saemon. ?Ha'alaa iini uri taa aadarue nge kei manata diana liutaa hunie aalaha ngeena?” ");
INSERT INTO apb_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Oto a Saemon ko aalamie uuri, “Nou lo'onga'inie uri sa'a mola iini nge e tola to'oha hiito'o mwaanie.” Oto a Jisas ko te'uri hunie a Saemon, “Ingeie otona. O ko ere to'ohuu oto.” ");
INSERT INTO apb_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Oto a Jisas e aali'u takoie a keine na ko te'uri hunie a Saemon, “?O leesie taane a keni ie? Maholo nou lae mai sili i nume i'oe, o ka'a kele niie ike nga mei wei huni hodalie e ro ae'aeku i sulie tolahaka. Ta'e keita'aa ie nge e hodalie e ro ae'aeku aana mo wei ni aakalo e aahe mwaanie maana, na e hulo a'ate aani aana iihune pwaune. ");
INSERT INTO apb_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","I'oe o ka'a tolakonieu ike aani nononga i sulie tolahaka, ta'e ingeie e uure ni nono'ie e ro ae'aeku aana nou lae mai ue ie. ");
INSERT INTO apb_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","I'oe, o ka'a kele suuhie ike pwauku aana nga mei rumu i sulie tolahaka, ta'e keita'aa ie hule aana ko aalohie oto e ro ae'aeku aani rumu nge e tohungei wesu mangoni. ");
INSERT INTO apb_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","No ko unue oto huni'o uri mo ooraha'aa ingeie e talei hunge taane, ta'e a God e sae'aasi'i mango oto i tehula'ana manata-diananga ingeie e paine. Aana iinoni nge sae'aasilana kele mei ola mola mwai-mwei ko lae hunie, manata-diananga ingeie kei mwei-mwei no'one mola.” ");
INSERT INTO apb_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Oto a Jisas e si te'uri hunie a keine, “Mo ooraha'aa i'oe, sae'aasileni e lae oto huni'o.” ");
INSERT INTO apb_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Ngaeta mo iini kire ii'o no'one pe'ire aana maholona, kire ko si lo'onga'i maraada uuri, “?A tei mwane ni ie, na uri kei sae'aasi ooraha'aa uri taa?” ");
INSERT INTO apb_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Ta'e a Jisas ko he'i unue lo'u mola hunie a keine uuri, “Hiiwalaimolinge i'oe e ha'a-uuri'o oto. O ke lae ni henuelama.” ");
INSERT INTO apb_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Oto puriha'ana walu olana e saro mango, a Jisas e si lae i sulie ahutana mo henue paine na mo kele huilume mwai-mwei aana po'o ni henuena, aana ko laenga'inie Tataroha Diana aana Aalahanga a God. Aawalai pwaarongoisuli mwana rue ingeie kire lae no'one pe'ie. ");
INSERT INTO apb_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Na ngaeta mo keni no'one pe'ire, mo iini nge ha'a-uurilada e lae mwaanie mo li'oa aaela na mo maelaa. Ngaeta mo iini aada, a Meri (keni aana huilume i Makdala nge a Jisas e oohea e hiu li'oa aaela mwaanie), ");
INSERT INTO apb_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","na a Susana, na a Joana nge poro ingeie a Kusa (nge ingeie na'ohai mwane au'esu haahie ahutana mo mwane au'esu i nume a Herod Antipas), na mo keni hunge lo'u. Mo keni ngeena kire ko pe'i-pe'ie a Jisas na mo pwaarongoisuli ingeie aana to'o-to'olada. ");
INSERT INTO apb_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Na mwala hunge e ruru mei saana Jisas uure mwaanie ta'ena nga hanue. Oto ingeie ko si ere ni aalahuunge hunire uuri, ");
INSERT INTO apb_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Ngaeta mwane au'esu hohola e o'o'o, oto ko lai hesie mo litei ola ingeie mala mo kooni. Hasinge ngeena ko lae mola aana tataa'inilana mo lite, na maholo ko tatataa'inie mo litei ola hailiu i laona hohola ingeie, ngaeta mo lite iini eeni kire ko teke i sulie tala. Oto mwala ko uuri'i na mo menu ko ngeu'i mola. ");
INSERT INTO apb_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Ngaeta mo iini eeni kire ko teke i lengine mei heu-heue. Oto maholo kire ko pwito poi, kire ko tolana nunulu mola aena aana leune e a'ate. ");
INSERT INTO apb_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Ngaeta mo litei ola kire ko teke i matolana mo walo kau-keu. Oto kire ko pwito tararuru pe'ie mo walo kau-keu, ta'e mo walo kau-keu kire paine haahi'i na kire ko si melusi'i mola. ");
INSERT INTO apb_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Ta'e ngaeta mo litei ola kire teke i lengine mei mwakano diana, na kire ko pwito diana. Oto kire ko si hungu ha'atangalau lo'u.” Oto a Jisas e si ere ooreta hunire uuri, “Mwaanie omu rorongo aasie mola mo wala ienini, ta'e omu ke lo'o-lo'onga'i diana i suli'i.” ");
INSERT INTO apb_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Oto mo pwaarongoisuli ingeie kire ko dolosi aana uuri, “?Nga taa ni lo'onga'inge aana aalahuunge ienini?” ");
INSERT INTO apb_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Oto a Jisas ko unue uuri, “A God e lio hilisi'omu hunie omu ke saenanau aana walaimolinge mumuni aana Aalahanga a God. Ta'e hunie mo iini aaopa, no ko ere ni aalahuunge oto ha'alaa, hunie uri kire ko lio-lio na kire ke su'uri lio sai'i, kire ko rorongo na mwaanie kire rongo sai'i.” ");
INSERT INTO apb_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Na a Jisas e he'i unue lo'u uuri, “Lo'onga'inge aana aalahuunge ienini e lae uuri. Mo lite walana God ni ngeena. ");
INSERT INTO apb_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Tala nge mo lite ngeena kire teke i sulie e urihana mo iini nge kire rongoa taane mo wala. Ta'e e ka'a tewa na a Satan e lae mai ko ta'aasie mwaanie manatada, hunie uri kire ke su'uri hiiwalaimoli na mwaanie uri ha'a-uurilada e lae. ");
INSERT INTO apb_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Na mo iini nge manatada e urihana mei mwakano hau-heue ngeena, kire rongoa walana God, na oto lau-leu kire ilenimwa'e haahie. Ta'e ola mala nga ai ke uure i laona mei mwakano urine, ha'alaa imi-imine e ka'a susu'imi ike hiito'o i aano. Kire hiiwalaimoli mola ha'awali, na aana maholo malaahongalada kei lae, oto kire ko tolana toli'aa mola. ");
INSERT INTO apb_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Nga mo iini lo'u manatada e urihana mei mwakano e honu aana walo kau-keu ngeena, kire rongoa no'one walana God, ta'e kire ne'isae painesie mola mau-meuringe aana walumalau. Kire tolahi'e, na kire saeto'o aana mola to'o-to'onga, na kire ko saehanalie ta'ena nga ola. Oto mo wala diana ngeena kire ka'a pwito kohi, na kire ka'a hungu ike lo'u. ");
INSERT INTO apb_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Ta'e mo iini lo'u, mo iini urihana mei mwakano diana ngeena, kire rongoa mo wala ngeena, na kire koni diana aani i laona manatada. Kire tola i sulie mo ha'a-uusulinge ngeena, na kire ko si hungu eeni noruto'onga pe'i esunge susule'i hunie Aalahanga a God.” ");
INSERT INTO apb_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Oto a Jisas ko he'i unue lo'u uuri, “Na nga ta'a-ta'a iini e sa'a ha'akaunie ike mola nga laite na ke pwaoha'inie nga nime haahie, wa ke mumunie mola i hahana nga tahe. Ta'e kei aaroroa oto i lengi hunie ke matapwa i laona numena, na hunie ahutana mwala nge ko sili mei nume kire sai lio diana. ");
INSERT INTO apb_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Aana ta'ena nga ola mumunilana e lae, nge haata'inilana kei saronai lae taane mai haada'i aana leu matapwa. Na nga taa nge aaluhilana e lae, aelilana kei saronai lae taane mai haada'i huni leesie. ");
INSERT INTO apb_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Aena ngeena, omu ke rorongo mwako. Aana ta'ena nga iini e mwa'e-mwa'e huni rongo i sulie mo ha'a-uusulinge ineu, nge sapeilana saenanaunge ni Lengi kei lae lo'u hunie. Ta'e a tei nge e ka'a mwa'e-mwa'e huni rongo i sulie mo ha'a-uusulinge ineu, nge ma'alana uri nga kele mei saenanaunge ni Lengi e to'o aana, ta'e ta'aasilana kei lae mola mwaanie.” ");
INSERT INTO apb_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Oto nikana Jisas na mo eesine mwane kire mani hute, kire sare lae mai saana, ta'e kire ka'a sai lae mai kara'inie, aena aana mwala e hunge. ");
INSERT INTO apb_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Oto ngaeta iini aana mwala ngeena ko unue hunie a Jisas uuri, “!Lio ka'u! A nikemu na mo eesimu kire uure mola ta'i sinaha, na kire ko sare leesi'o.” ");
INSERT INTO apb_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Oto a Jisas ko aalamie uuri, “A nikeku na mo eesiku oto ahutana mo iini nge ko rongoa walana God na kire ko lulu i sulie oto.” ");
INSERT INTO apb_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Aana ngaeta hai dinge a Jisas ko te'uri hunie mo pwaarongoisuli ingeie, “Kolu ke aatoholo ka'u hunie raune aasi po'o ta'au.” Oto kire ta'elie iiola, kire ko si lae, ");
INSERT INTO apb_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","na lae-lae a Jisas e lae otoi eno huni ma'ahu, no ko ma'ahu eelisuu oto. E ka'a tewa na paineha'ana mawasidengi ko hite aada oto i laona aasi, na iiola ko aehota honu oto aana aasi, hule aana kire ko kara'i dodo oto. ");
INSERT INTO apb_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Oto mo pwaarongoisuli kire ko ha'alioa Jisas na kire ko te'uri hunie, “!Poro paine! !Poro paine! !O ke lio ka'u, kolu ko kara'i mae oto!” Oto a Jisas e ta'ela'i ko ere aana ooru na aahe, oto kire ko tolana aapwana'i na ko hoolaa oto. ");
INSERT INTO apb_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Oto a Jisas ko si te'uri hunie mo pwaarongoisuli ingeie, “?Nge i tei hiiwalaimolinge i'omu?” Ta'e kire ko me'u pe'i pangata'inge, na kire ko unue oto hunire maraada uuri, “?A tei mwane ni ie? !Oto hule aana e ere aana mola ooru na aahe, oto kire ko meni tola i sulie oto walana!” ");
INSERT INTO apb_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","A Jisas na mo pwaarongoisuli ingeie kire aatoholosie aasi uure i Kalili hunie po'o ni henue mo Kerasa. ");
INSERT INTO apb_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","29","Maholo a Jisas ko siho hai oone i leune mwaanie iiola, na ko oodoie oto ngaeta mwane mo li'oa hunge aaela aana. Mwala aana hanuena kire ko pwesue ka'u mo ki'ine na mo ae'aena aani iieli heu, ta'e ko mousi'i mola na ko tehi oto i henuesala. Ko lae tewa oto mai, na mwaena e ka'a sai ho'osie nga mei sala wa nga to'oni, na ii'olana oto tarau mola i saana mo kilipwe'u. Oto maholo a Jisas e oodoie a mwaena, ko si ere aana mo li'oa aaela ngeena hunie kire ke iisitaa mwaanie. Oto a mwaena ko uulo na ko lai pouruuru oto i na'ona Jisas pe'ie mei wala paine uuri, “!Jisas Kalena God, iini e paine liutaa! ?O kei uaau oto eena? !No ko eitanai'o, uri o ke su'uri ha'aloieu!” ");
INSERT INTO apb_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Oto a Jisas ko dolosi aana uuri, “?A tei ni satamu?” Oto a mwaena ko aalamie uuri, “Sataku a Hunge.” E ere urine aena aana mo li'oa aaela hunge ni kire aana. ");
INSERT INTO apb_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Na mo li'oa aaela ngeena kire aitanaie a Jisas uri ke su'uri uusunge'i aasire i laona kalinge ni ha'amotaahinge nge e ka'a to'o kaona. ");
INSERT INTO apb_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Maholona na hakaa ni poo oto paine ko susude ta'au i sulie uuwo i leune. Oto mo li'oa aaela ngeena kire aitanaie a Jisas uri ke toli'aasire hunie kire ke lai sili i laona mo poo ngeena. Oto a Jisas e si toli'aasire mola. ");
INSERT INTO apb_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Na maholo mo li'oa aaela ngeena kire iisitaa mwaanie a mwaena, oto kire si lai sili i laona mo poo. Amaa ni poo ngeena e mani tehi, na kire ko lai pola oto i sulie mao'i i laona aasi, na kire ko meni inu oto. ");
INSERT INTO apb_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Oto mwala nge kire lio-lio i sulie mo poo ngeena kire leesie nga taa e raune, kire si huru na kire ko lae otoi taroha'inie tataroha aana i laona huilume ikire, na lo'u aana mo henue kali-kelie. ");
INSERT INTO apb_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Oto mwala kire lae mai huni leesie nga taa e raune, kire lai hule i saana a Jisas, na kire ko lio oodoie uri mwane nge a Jisas e oohea mo li'oa aaela mwaanie, e ii'o oto i saana Jisas. E manata na e ho'o sala oto. Oto mwala ngeena ko si meni me'u oto. ");
INSERT INTO apb_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Na mo iini e leesie mei olana, kire ko si ha'arongoa mwala aana uri a Jisas e ha'a-uurie a mwaena uri taa. ");
INSERT INTO apb_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Oto ahutana mwala aana po'o ni henuena kire ko si meni eitanaie a Jisas uri ke lae mwaanire, aena aana kire ko tohungei me'u oto hiito'o. Oto a Jisas e ta'elie iiola ko si lae mwaanire. ");
INSERT INTO apb_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Oto mwane nge mo li'oa aaela e iisitaa mwaanie ngeena ko eitanaie a Jisas uri ke hakusie, ta'e a Jisas e uusunge'i eeliho'i mola aana, na ko unue hunie uuri, ");
INSERT INTO apb_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“O ke aaliho'i mola i saana uluhe i'oe, na o ke ha'arongoa mwala aana walu ola diana nge a God e asui'i huni'o.” Oto a mwaena e si lae hailiu i laona huilumena pe'i taroha'inie oodoie mwala nga taa a Jisas e asuie aana. ");
INSERT INTO apb_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Maholo a Jisas e aaliho'i lo'u hunie po'o ni eesi ta'au, na mwala oto hunge kire maa'oohie i leune pe'ie saemangonga oto liutaa haahie. ");
INSERT INTO apb_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Oto ngaeta mwane satana a Jaeras e lae mai, na ingeie nga na'ohai mwane aana nume ni palo-palo mo Jiu aana hanuena. A mwaena ko pouruuru i aano oto i na'ona Jisas, na ko eitanaie a Jisas uri ke lae ka'u ta'au i nume ingeie, ");
INSERT INTO apb_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","aana kele pule ingeie ko kara'i mae oto. A pulena ta'a-ta'a mwela moute'i, na ola mala aawalai helisi mwana rue ue aana. Maholo a Jisas ko lae hunie nume a Jaeras, mwala oto hunge ko si lae mai kali-kelie. ");
INSERT INTO apb_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Na i matolana mwala e hunge ngeena, ngaeta keni no'one i leune maelaa mada'a aana apu raha-raha ko seunie oto hunie aawalai helisi mwana rue. A keine e nii mangoa oto to'o-to'olana hunie mwala kure-kure, ta'e nga iini na e ka'a ha'a-uurie ike. ");
INSERT INTO apb_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","A keni ngeena e lae poi i matolana ruruhaa i purine a Jisas, oto ko kopi aana ngongo'ana to'oni ingeie, na apu raha-raha ngeena ko tolana mango oto mwaanie. ");
INSERT INTO apb_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Oto a Jisas ko dolosi uuri, “?A tei ni e kopi eeku?” Ta'e kire ko meni taateinge'inie mola. Oto a Pita ko te'uri, “Aalaha, mwala hunge ka'u kire ruru kali-keli'o ngeena, na kire ko lae pe'i helipa'o uri huni leesi'o.” ");
INSERT INTO apb_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Ta'e a Jisas ko te'uri, “!Ha'ike! Nga iini e kopi eeku, aana nou hiinge'inie uri nanamanga ineu e ha'a-uurie nga iini.” ");
INSERT INTO apb_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Na a keine e saie mola uri e sa'a mumuni ike lo'u, oto ko si eriri na ko lai pouruuru oto i na'ona Jisas. Oto ko unu tahanga'inie hunie a Jisas i na'ona mwala uri aena nga taa e kopi aana, na uri ha'a-uurilana e tolana lae oto mola aana maholona. ");
INSERT INTO apb_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Oto a Jisas ko si unue hunie a keine uuri, “Kaleku, hiiwalaimolinge i'oe e ha'a-uuri'o oto. O ke lae ni henuelama.” ");
INSERT INTO apb_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Maholo na a Jisas ko ere-ere ue, ngaeta mwane e uure ta'au i nume a Jaeras, e lae mai hule i saada, oto ko te'uri hunie a Jaeras, “Kele pule i'oe e mae oto. O ke su'uri ha'aweoa lo'u a Ha'a-uusuli.” ");
INSERT INTO apb_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Oto maholo a Jisas e rongo urine, ko si te'uri hunie a Jaeras, “O ke su'uri tolahi'e, ta'e o ke hiiwalaimoli mola aaku na a kalemu ha'a-uurilana kei lae oto.” ");
INSERT INTO apb_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Maholo a Jisas e lai hule ta'au i nume a Jaeras, e ka'a toli'aasie ike nga iini ke sili lo'u pe'ie hai nume. Ta'e a Pita, a Jon, na Jemes pe'ie aamana na nikana a pulena, nge a Jisas e toli'aasire hunie kire ke lae sili i nume pe'ie. ");
INSERT INTO apb_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Na aana maholona, ahutana mwala ko meni ngara-ngarasie oto a pulena pe'i saehuunge. Ta'e a Jisas e te'uri hunire, “Omu ke su'uri ngara-ngara. A pule ie e ka'a mae ike, ta'e ko ma'ahu mola.” ");
INSERT INTO apb_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Oto ahutana mwala ngeena kire ko meni mwesi mola mwaanie a Jisas, aena aana kire saie uri a pulena e pwani mae. ");
INSERT INTO apb_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Oto a Jisas e sili hai nume, e hele i nimana pulena na ko soie uuri, “!Kaleku, o ke ta'ela'i!” ");
INSERT INTO apb_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Oto mangona pulena ko tolana aaliho'i oto lo'u, na ko ta'ela'i oto. Oto a Jisas ko si unue hunire uri kire ke nii ngeulaa ana. ");
INSERT INTO apb_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Oto nikana a pulena na aamana, kirerue ko si tohungei pangata'i oto hiito'o. Ta'e a Jisas ko si ere honosire mola uri mwaanie kire ha'a-ha'arongoa nga iini aana walu ola e raune. ");
INSERT INTO apb_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Oto a Jisas e soie mai ahutana aawalai hurula'aa mwana rue i saana, na ko niie nanamanga e saka hunire hunie kire ke oohe aasie ahutana mo li'oa aaela, na huni ta'aasie ta'ena nga maelaa. ");
INSERT INTO apb_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Na e uusunge'inire hunie kire ke lai laeliwala aana Aalahanga a God na huni ha'a-uurie mo iini ko mweri. ");
INSERT INTO apb_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Oto ko si te'uri hunire, “Maholo omu ko lae, omu ke su'uri toolea lo'u nga mei ola pe'i'omu, nga apa'a, wa nga mwa'i, wa nga mei ngeulaa, wa nga mei to'oha. Ma'alana uri nga ro to'oni na su'uri lo'u, ta'e mo iini oto omu ho'osi'i mola. ");
INSERT INTO apb_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Maholo omu ko lai sili aana nga nume, omu ke ii'o oto i leune lai hule aana maholo ni lae mwaanie hanuena. ");
INSERT INTO apb_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Mala uri mwala aana hanuena ka'a takuhi'omu oto, nge omu ke lae mwaanie hanuena, na omu ke tataa'inie mo wasa-wasa mwaanie ae'aemiu, domana uri nga ha'apasunge hunire uri a God kei ha'aloire.” ");
INSERT INTO apb_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Oto mo hurula'aa e taule'i, kire ko si lae i sulie ahutana mo henue huni taroha'inie Tataroha Diana, na kire ko ha'a-uurie mwala aana ta'ena nga leu. ");
INSERT INTO apb_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Maholo a Herod Antipas, aalaha ni Kalili, e rongo tarohana walu ola nge ko reune, ko tohungei teipu'o-pu'o, aena aana ngaeta mwala ko unue uuri, “A Jon Loto maa'i ni e mauri lo'u.” ");
INSERT INTO apb_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Ngaeta mo iini ko unue uuri, “A Elaeja e maau aameelu.” Na ngaeta mo iini ko unu-unue ue uuri, “Nga iini aana mo propet oto i na'o ni e he'i meuri lo'u ngeena.” ");
INSERT INTO apb_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Oto a Herod ko unue uuri, “A Jon nou lamasie ka'u oto pwaune. ?A tei mwane ni no ko rongo tarohana lo'u ienini?” Oto ko si eri'apasie uri ke leesie a Jisas. ");
INSERT INTO apb_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Maholo mo hurula'aa kire ooli mei, oto kire ko ha'arongoa Jisas aana walu ola nge kire lae pe'i esui'i. Oto e toolera kire ko lae maraada hunie huilume i Betsaeda. ");
INSERT INTO apb_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Oto maholo mwala e rongo tarohana urine, kire ko si lae i sulire. Na a Jisas e takuhie mwalana, e ha'a-uusulire i sulie Aalahanga a God, na e ha'a-uurie mo iini ko mweri. ");
INSERT INTO apb_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Oto maholo kara'inie sato kei suu, aawalai hurula'aa mwana rue kire lae mai saana a Jisas, oto kire ko te'uri hunie, “O ke uusunge'inie mwala ngeena hunie kire ke lai lo'ohi ngeulaa ada na mo leu ni ma'ahu ikire aana mo huilume, aena aana ikolu aana hanuesala ni ie.” ");
INSERT INTO apb_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Oto a Jisas ko te'uri hunire, “I'omu, omu ke nii ngeulaa mola ada.” Oto kire ko aalamie uuri, “!Ha'ike eena! Melu to'o aana mola e lime aata ho bred na e ro ho ii'e. ?Ta'e mo ola urine kei adona mwala hunge urine uri taa? ?Ohe o saeto'o aana melu ke lae holi ngeulaa ada?” ");
INSERT INTO apb_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Sulie ola mala e lime sinolai mwane ni ngeena. Oto a Jisas ko te'uri hunie mo pwaarongoisuli ingeie, “Omu ke ha'a-ii'osie mwala aani pulitaa ni lime aawalai iinoni nga pulitaa.” ");
INSERT INTO apb_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Oto mo pwaarongoisuli ko deu oto i sulie nga taa a Jisas e unue hunire, na mwala kire ii'o oto aani pulitaa. ");
INSERT INTO apb_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Oto a Jisas e hele aana lime ho bred ngeena na e ro ho ii'e, oto ko si lio i lengi, na ko paalahea a God. Oto e nisie mo ho bred ngeena, ko si nii'i hunie mo pwaarongoisuli ingeie hunie kire ke ha'a-adoa mwala aani. Na e te'urine no'one aana e ro ho ii'e hunie ahutada mango. ");
INSERT INTO apb_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Oto ahutana mwala kire mani ngeu pote, na i purine kire ngau mango, mo pwaarongoisuli ko si ha'ahonue aawalai lu'e mwana rue aana mo ooretai ngeulaa. ");
INSERT INTO apb_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Ngaeta hai dinge a Jisas e ii'o mola pe'ie aarenga'inge, na mo pwaarongoisuli ingeie mola kire ii'o pe'ie. Oto ko si dolosi aada uuri, “?Ha'alaa mwala ko unu-unue uri ineu a tei?” ");
INSERT INTO apb_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Oto kire ko aalamie uuri, “Ngaeta mo iini ko unu-unue uri i'oe a Jon Loto Maa'i e mauri eeliho'i. Na nga mo iini ko unu-unue uri i'oe a Propet Elaeja. Na ngaeta mo iini lo'u ko unu-unue uri i'oe nga iini hikana mo propet oto i na'o ni e he'i meuri lo'u ngeena.” ");
INSERT INTO apb_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Oto a Jisas ko he'i dolosi lo'u aada uuri, “?Oto e ue aana i'omu? ?Ha'alaa omu ko unu-unue uri ineu a tei?” Oto a Pita ko aalamie uuri, “I'oe oto a Kraes, a Ha'a-uuri nge a God e haiholota'inie kei lae mai.” ");
INSERT INTO apb_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Oto a Jisas ko ere honosire mwaanie kire ha'arongoa lo'u nga iini aana leune. ");
INSERT INTO apb_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Oto a Jisas ko he'i unue lo'u uuri, “Leu oto i sapeku uri hunie ineu a Kale Ni Iinoni, ne ke sapesalu oto hiito'o. Aana mo na'ohai pris na mo ha'a-uusuli aana mo Ha'atolanga a Mosis na ngaeta mo rato lo'u, kire kei leledieu. Oto kire kei horo maesieu, ta'e aana oolune nga hai dinge ne kei ta'ela'i eeliho'i lo'u mola mwaanie maenga.” ");
INSERT INTO apb_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Na ko he'i unue lo'u hunie ahutada uuri, “Mala uri nga iini ko sare lulu i sulieu, nge ke pulongosie walu ola e sae haahi'i, na ke lulu i sulieu i suli hei dinge, ma'alana ke sapesalu i tehula'aku, hule aana maenga i lengine po'u-po'u. Iini nge ko aanga'inie po'u-po'u ingeie urine, ha'alaa e sai lulu i sulieu. ");
INSERT INTO apb_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Aana ta'ena nga iini ko sare kineta'inie mola mauriha'ana, nge kei deu tekela'inie oto. Ta'e nga iini nge ko deu tekela'inie mauriha'ana i tehula'aku, nge kei ha'a-uurie tohungana mauriha'ana eena. ");
INSERT INTO apb_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","?Ha'alaa nga mei taa diana nge iinoni kei terie aana kei to'o aana oto ahutana mo to'o-to'onga aana walumalau ie, na ko deu tekela'inie mola mauriha'ana oto i tehula'ani? ?Oto uri to'o-to'olana kei pe'ie aana maholona? !Ha'ike oto oo'oo! Nga mei ola hunie ke niie huni tola aaliho'i aana mauriha'ana, ha'ike lo'u. ");
INSERT INTO apb_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Mala uri nga iini ko masa huni unu tahanga'inieu na mo ha'a-uusulinge ineu, nge ineu no'one ne kei masa huni unu tahanga'inie aana maholo ne kei lae mai pe'ie manikuluha'aku na manikuluha'ana a Mama'a na mo ensel maa'i. ");
INSERT INTO apb_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","To'ohuu no ko unue oto huni'omu uri ngaeta mo iini hikemiu mwala nge omu uure ngeena, omu kei saronai leesie Aalahanga a God kei lae mai, omu ke si mae.” ");
INSERT INTO apb_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Oto ola mala e walu hei dinge e mango i purine a Jisas e unue walu ola ienini, e si toolea a Pita, na a Jon, na a Jemes, na kire ko hanetaa ta'au i lengine toloi henue huni aarea God. ");
INSERT INTO apb_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Na maholo ko aarea God ngeena, nge maana ko si lio aaopa, na mo to'oni ingeie kire ko tohungei lio wana-wana na ko raa oto mala wa'ariri. ");
INSERT INTO apb_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","31","Oto mola aana maholona a Mosis na Elaeja ko tolana maau pe'ie manikuluha'ana a God, na kirerue ko ere oto pe'ie a Jisas i sulie maelana nge kei reu i Jerusalem huni ha'a-oaie oala'inge a God. ");
INSERT INTO apb_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Aana maholona na a Pita pe'ie e ro oana kiraelu ko ma'ahu. Oto maholo kiraelu lio, kire ko si leesie rarangana God e raa kali-kelie a Jisas na e ro mwane e uure oto pe'ie. ");
INSERT INTO apb_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Oto maholo e ro mwane ko deu huni lae oto mwaanie a Jisas, a Pita ko te'uri hunie, “Poro paine, e tohungei diana aana i'emeelu oto i leu. Melu kei esuie oto nga oolu aapa-aapa i leu—nga iini nemue, nga iini nana a Mosis, na nga iini nana a Elaeja.” A Pita e talei ere mola urine, ta'e e ka'a saie ike nga taa ko unue. ");
INSERT INTO apb_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Maholo a Pita ko ere-ere ue urine, na mei uuru ko tolana lae oto mai, na e oolu mwane ngeena ko tohungei me'u oto aana mei uuru ngeena ko siho oto mai haahire. ");
INSERT INTO apb_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Na kire ko rongoa mei wala e uure mai mwaanie mei uuru ngeena ko te'uri, “Tohungei Kaleku ni ienini, iini nou lio hilisie. Omu ke rongo hunie.” ");
INSERT INTO apb_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Oto maholo mei wala ngeena e mango, kiraelu ko si leesie mola a Jisas e uure maraana. Oto mo pwaarongoisuli kiraelu rohu mola haahie, na kiraelu ka'a ha'arongoa lo'u nga iini aana mo dingena, aana nga moi taa nge kiraelu leesi'i. ");
INSERT INTO apb_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Oto aana hai dinge lo'u i sulie, i purine a Jisas na e oolu pwaarongoisuli kiraelu siho toli mei mwaanie uuwo, oto kire ko oodoie mwala oto hunge. ");
INSERT INTO apb_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Oto ngaeta iini hikada ko aawara, na ko unue uuri, “!Ha'a-uusuli! No ko eitanai'o uri o ke pe'ie ka'u kele mwa'u ineu, aana ta'a-ta'a mwela moute'i ineu ni otona. ");
INSERT INTO apb_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Maholo li'oa aaela kei hulesie, oto ko aawara na ko eriri oto, na huto-huto ko tahe oto aana wawana. Li'oa aaela ngeena ko talei waelie oto mola tarau urine, na e ka'a sai mango ike lo'u mwaanie. ");
INSERT INTO apb_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Nou haaraie ka'u mo pwaarongoisuli i'oe uri kire ke ta'aasie mwaanie, ta'e kire dau kasoa mola.” ");
INSERT INTO apb_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Oto a Jisas ko te'uri, “I'omu pwaunge si'iri ie, i'omu mo iinoni aaela, suata mone hule aana omu ka'a hiiwalaimoli ike aana a God. !No ko talei ha'aweoau oto mola pe'i'omu! ?Uri ne kei ii'o tewa ka'u lo'u uri taa pe'i'omu, omu ke si hiiwalaimoli?” Oto ko si te'uri hunie a mwaena, “Toolea ka'u mei a kalemu i leu.” ");
INSERT INTO apb_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Oto maholo nge a mwa'une ko lae mai takoie a Jisas, li'oa aaela ko repute'i lae-lae'i oto aana a mwa'une i aano. Ta'e a Jisas e ere aana li'oa aaela ngeena, ko si ha'a-uurie a mwa'une, na ko toli'aasie oto hunie aamana. ");
INSERT INTO apb_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Oto ahutana mwala ko si meni pangata'inie lo'u paineha'ana nanamanga a God ngeena. Maholo na ahutana mwala ko papangata'inie ue walu ola nge a Jisas ko deu'ine, a Jisas ko si te'uri hunie mo pwaarongoisuli ingeie, ");
INSERT INTO apb_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Mwaanie omu pupulongosie nga taa nge no ko unue huni'omu ienini. Ineu a Kale Ni Iinoni, pwelolaku kei lae i laona nimana mo iinoni.” ");
INSERT INTO apb_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Ta'e mo pwaarongoisuli ko teipu'o-pu'o mola aana nga taa nge a Jisas e ere urine hunire aana. A God e mumunie lo'onga'inge aana mo wala ienini mwaanire, mwaanie kire rongo sai'i. Oto aana maholona, ikire na kire ko me'u lo'u mola huni dolosi aana a Jisas, uri nga taa lo'onga'inge aana erenga ingeie. ");
INSERT INTO apb_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Oto mo pwaarongoisuli ingeie ko aehota ere haitelili maraada i sulie uri a tei hikada kei peine liutaa. ");
INSERT INTO apb_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Ta'e a Jisas mone e saie mola lo'onga'inge ikire, oto e si toolea kele mwela, ko ha'a-uuresie i sulie, ");
INSERT INTO apb_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","na ko te'uri hunire, “Ta'ena nga iini nge ko tola konie nga kele mwela mala ienini aana sataku, nge ko tola konieu eena. Na ta'ena nga iini nge ko tola konieu, ko tola konie no'one iini e uusunge'inieu mei eena. Aana a tei hikemiu nge ko ha'amwai-mwei'aa to'ohuu, ingeie ni oto e paine liutaa.” ");
INSERT INTO apb_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Oto a Jon ko aalamie a Jisas uuri, “Poro paine, melu leesie nga iini ko oohe li'oa aaela mwaanie mwala aana satamu, na melu ere aana oto mwaanie e he'i te'urine lo'u, aana ingeie ha'ike aana pulitaa ikolu.” ");
INSERT INTO apb_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Oto a Jisas ko te'uri hunie, “Omu ke su'uri uure honosie, aena aana nga iini nge e ka'a uure honosikolu, ingeie iini pe'ikolu eena.” ");
INSERT INTO apb_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Maholo ko kara'inie oto uri a God kei tola aaliho'i lo'u aana a Jisas i saana ta'au i Lengi. Oto a Jisas e lo'onga'inie uri ke lae hunie i Jerusalem, ");
INSERT INTO apb_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","na e uusunge'inie ngaeta mo mwane uri kire ke lae i na'o. Oto mo mwane ngeena kire lae aana ngaeta huilume i Samaria huni deu aakau aana ahutana mo ola loosie a Jisas. ");
INSERT INTO apb_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Ta'e mwala aana huilume ngeena, kire ka'a sare takuhie ike a Jisas, aena aana kire lio saie uri ko lae hunie i Jerusalem. ");
INSERT INTO apb_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Maholo ngaeta ro pwaarongoisuli ingeie, a Jemes na a Jon kirerue leesie urine, oto kirerue ko unue hunie a Jisas uuri, “?E ue Poro paine, o saeto'o aana mere ke unue nga dunge ke siho mai uure i Lengi hunie ke waelie mwala ngeena?” ");
INSERT INTO apb_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Ta'e a Jisas e aali'u oto ko si ere aadarue mola. ");
INSERT INTO apb_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Oto a Jisas na mo pwaarongoisuli ingeie kire si lae lo'u mola hunie ngaeta huilume. ");
INSERT INTO apb_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Maholo kire ko lae oto i sulie tala, ngaeta mwane ko si te'uri hunie a Jisas, “Nou mwa'e-mwa'e ni lulu i suli'o aana ta'ena nga leu o ko lae aana.” ");
INSERT INTO apb_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Oto a Jisas e aalamie ko te'uri, “Mo usu ni me'esu na hule aana kire to'o liwe ni ma'ahu ikire, na mo menu lo'u kire mani to'o niu'i taane no'one, ta'e ineu a Kale Ni Iinoni hule aana nga leu ni mamalo ineu na ha'ike lo'u.” ");
INSERT INTO apb_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Oto ko te'uri lo'u hunie ngaeta mwane, “O ke lulu i sulieu.” Ta'e a mwaena e unue uuri, “Poro paine, o ke hola'i toli'aasieu ke'u hunie ne ke lai heitolinge'inie aamaku.” ");
INSERT INTO apb_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Ta'e a Jisas e aalamie oto ko te'uri, “Ha'ike, ta'e o ke lulu i sulieu oto molana, na mwaanie o maa'oohie mo tolahi'anga ni welumalau e mango nge o ke si lulu i sulieu. Ta'e o ke lae oto molana huni taroha'inie Aalahanga a God.” ");
INSERT INTO apb_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Ngaeta mwane lo'u e unue uuri, “Ne kei lulu i suli'o taane, Poro paine, ta'e o ke hola'i toli'aasieu ke'u hunie ne ke lai ha'arongoa mwala ta'au i nume ineu.” ");
INSERT INTO apb_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Ta'e a Jisas e unue uuri, “Ta'ena nga iini ko esu i hohola ingeie, ta'e ko talei lo'o-lo'onga'inie lo'u mola nga mo ola aaopa kei waelie oto hohola ngeena. Na e urine no'one mala nga iini ko sare ne'i pwaarongoisuli ineu ta'e ko lo'o-lo'onga'inie mola mo ola aaopa. Iinoni urine e ka'a malisine ike Aalahanga a God.” ");
INSERT INTO apb_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Oto i purine walu ola ie e haro mango, a Aalaha e si lio hilisie lo'u ngaeta hiu aawalai mwane mwana rue. Oto ko hola'i uusunge'inire oto i na'o takoie ahutana mo huilume na mo leu nge e lo'onga'i huni lae aani. ");
INSERT INTO apb_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Oto a Jisas ko te'uri hunire, “So'okoninge e paine hiito'o, ta'e mwala au'esu ka'a hunge ike huni so'okoni. Omu ke aitanaie iini e to'o aana hohola hunie ke uusunge'inie lo'u mei nga mwala au'esu huni so'okoni nana. ");
INSERT INTO apb_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","No ko uusunge'ini'omu i matolana mwala e ooraha'aa, na saeda huni horo'i'omu mala mo wawaulo ni me'esu ko seunie mo sipu. ");
INSERT INTO apb_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Mwaanie omu too-toolea nga mwa'ii to'oha, wa nga mwa'i ni laeha, wa nga ho'ohaahi'ae. Na mwaanie omu waelie maholo mola aana erenga pe'ie nga iini omu ko oodoie i sulie tala. ");
INSERT INTO apb_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","“Maholo omu ko lai sili aana nga nume, omu ke hola'i aarenga'i talana mwala aana nume ngeena hunie a God ke ha'adiana'ara aani henuelamanga. ");
INSERT INTO apb_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Mala uri nga iinoni diana na tolahana e maneko ko ii'o aana nume ngeena, nge hanuelamanga ke ii'o pe'ie. Ko ha'ike, na kire sa'a hele aana ike ha'adiana'anga ngeena. ");
INSERT INTO apb_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Na omu ke ii'o rako oto mola aana numena. Mwaanie omu lae-lae hailiu lo'u aana ngaeta mo nume. Omu ke ngau-ngeu mola na omu ke inu-inu aana nga moi taa kire ko nii'i huni'omu. Aana e diana hunie mwala ke pe'i'omu, aana iinoni au'esu e malisine oto uri ke hele aana waaitana. ");
INSERT INTO apb_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","“Mala uri omu ko lae aana nga huilume na mwala ko tekuhi'omu, nge omu ke ngau-ngeu mola aana nga moi taa kire ko nii'i huni'omu. ");
INSERT INTO apb_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Omu ke ha'a-uurie mo iini ko mweri aana hanuena, na omu ke unue hunie mwala i leune uuri, ‘Aalahanga a God ko kara'ini'omu oto mai.’ ");
INSERT INTO apb_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Ta'e nga huilume omu ko lae aana na mwala ka'a takuhi'omu, nge omu ke lae lo'u mola mwaanie huilume ngeena, na omu ke unue hunire uuri, ");
INSERT INTO apb_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Kele mei mada aana huilume i'omu e rara'o aana ae'aemeelu na melu ko usuri aasie aani ha'apasunge huni'omu uri a God kei ha'aloi'omu. Ta'e omu ke manata'inie uri Aalahanga a God ko kara'ini oto mai.’” ");
INSERT INTO apb_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Oto a Jisas ko te'uri hunire, “No ko unue oto huni'omu, aana dinge ni leinge, ha'aloilana mwala aana huilume ngeena kei aaela lo'u hiito'o liutaa aana ha'aloinge nge kei lae hunie mwala tata'ala aana huilume i Sodom.” ");
INSERT INTO apb_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Na a Jisas ko he'i te'uri lo'u, “!Kei aaela oto liutaa huni'omu mo Korasin! !Na no'one huni'omu mo Betsaeda! Mala uri mo hu'i-hu'ite nge asuileni e lae huni'omu ngeena, asuileni ke lae urine hunie mo pu'o i Taea na i Saedon, ha'alaa mwala aana e ro huilume ngeena kire pwani oonisae oto waite. Kire kara'i ha'amwai-mwei'ara aani ho'osilana mo to'oni lalahu'e na ipe aani pwasa'ora huni haata'inie uri kire aali'u oto mwaanie mo ooraha'aa ikire. ");
INSERT INTO apb_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Ta'e aana dinge ni leinge, a God kei aamasie mo iinoni tata'ala i Taea na i Saedon lo'u liutaa aamiu. ");
INSERT INTO apb_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","?Na i'omu mo Kapaneam, omu ko lo'o-lo'onga'i uri a God kei sulu ala'a aamiu ta'au i Lengi? !Ha'ike! A God kei aasi'omu mola hai aano aana leu ni ha'amotaahinge.” ");
INSERT INTO apb_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Oto a Jisas ko he'i te'uri lo'u hunie mo pwaarongoisuli ingeie, “Nga iini nge ko rongo huni'omu, ko rongo hunieu no'one eena. Na nga iini nge ko leledi'omu, ko leledieu no'one. Na iini nge ko leledieu, ko leledie no'one iini nge e uusunge'inieu mei eena.” ");
INSERT INTO apb_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Oto e hiu aawalai mwane mwana rue ngeena kire aaliho'i mei pe'ie ilenimwa'enga, na kire ko te'uri hunie a Jisas, “Aalaha i'emi, maholo melu sasaie satamu, hule aana mo li'oa aaela na kire ma'ute'ini'emeelu oto pe'i tola i sulilameelu.” ");
INSERT INTO apb_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Oto a Jisas e aalamire ko te'uri, “Nou leesie taane a Satan e domu uure mwaanie i Lengi mala wa'ariri. ");
INSERT INTO apb_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Aana nou niie oto huni'omu nanamanga huni uuri haahie mo mwaa ala-ala na mo heri-heri. Na nou niie oto no'one nanamanga e saka lo'u liutaa aana nanamanga a Satan. Oto nga mei ola e sa'a hu'isi'omu ike lo'u. ");
INSERT INTO apb_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Omu ke ile-ilenimwa'e mola. Ta'e su'uri ilenimwa'e haahie uri mo li'oa aaela ko me'ute'ini'omu. Omu ke ilenimwa'e haahie a God e uusue oto satamiu ta'au i Lengi.” ");
INSERT INTO apb_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Aana maholona a Jisas e honu aani ilenimwa'enga aana Li'oa Maa'i, oto ko te'uri, “Mama'a, i'oe oto o aalaha haahie i Lengi na mai aano. Uure oto waite o mumunie Tataroha Diana mwaanie kira saenanau, ta'e ie o ko haata'inie oto hunie mo iini ka'a saenanau. Oto no ko tohungei paalahe'o, Mama'a, aana o oala'inie hunie ke lae oto urine.” ");
INSERT INTO apb_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Oto ko he'i unue lo'u hunie mwala uuri, “Aamaku e niie oto ahutana walu ola hunieu hunie ne ke paine haahi'i. Na nga iini ka'a manata'inie ike a Kale ta'e a Mama'a mola hali'ite. Na nga iini e ka'a manata'inie ike a Mama'a ta'e a Kale mola hali'ite, na mo iini nge a Kale ko lio hilisire huni unu haata'i aana Aamana.” ");
INSERT INTO apb_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Oto a Jisas e aali'u takoie mo pwaarongoisuli, ko si unue hunire maraada uuri, “Deidehi'omu aana omu ko leesie walu ola ienini. ");
INSERT INTO apb_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Aana no ko unue oto huni'omu uri hungelana mo propet na mo inemauri kire tohungei sasare leesie mo ola omu ko leesi'i ie, ta'e kire ka'a lio mangini, na uri huni rongoa mo ola omu ko rongo'i ie, ta'e kire ka'a rongo lelengani.” ");
INSERT INTO apb_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Oto ngaeta ha'a-uusuli aana mo Ha'atolanga a Mosis e lupwe'i dolosi pweloa a Jisas uuri, “?Ha'a-uusuli, nga mei taa ni ne kei esuie ka'u hunie ne ke helesie maurihe huu?” ");
INSERT INTO apb_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Oto a Jisas ko aalamie uuri, “?Nga taa ni uusulana e lae i laona mo Ha'atolanga a Mosis? ?O ko saa-saai uri taa aani?” ");
INSERT INTO apb_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Oto a mwaena ko aalamie a Jisas uuri, “O ke manata diana hunie a God, Aalaha i'oe oto aana ahutana saemu, na aana ahutana mauriha'amu, na aana ahutana a'aila'anga i'oe, na aana ahutana mo ne'isaenga i'oe, na o ke manata diana hunie auhenue i'oe oto mala o manata diana huni'o maraamu.” ");
INSERT INTO apb_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Oto a Jisas ko aalamie a mwaena uuri, “Iau, o ko ere to'ohuu. O kei te'urine nge o ke si hele aana maurihe huu.” ");
INSERT INTO apb_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Ta'e a mwaena mone ko heitalea nga mei ne'isaenga hunie ha'atolanga e aasa ngeena ke mwada'u mola hunie. Oto ko te'uri hunie a Jisas, “?Ha'alaa, a tei ni nge auhenue ineu?” ");
INSERT INTO apb_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Oto huni aalamie dolosinge ngeena, a Jisas ko te'uri hunie, “Nga mwane ikie mo Jiu e uure i Jerusalem ko pweu hao i sulie tala hunie i Jeriko. Oto lae-lae e oodoie ngaeta mo horopeli. Oto kire tapolie, kire ko si repusie, na kire ko ta'aasie oto mo to'oni ingeie mwaanie. Oto kire si lae mwaanie na e maehunu oto. ");
INSERT INTO apb_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Oto ngaeta pris ikie mo Jiu e tapaliu hao i sulie tala na ko leesie a mwaena, oto e si eeli'u mola mwaanie. ");
INSERT INTO apb_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Oto lae-lae, ngaeta mwane lo'u ikie mo Jiu, mwane aana komu a Livae nge ko hei-hei rareta'i wau i Nume Maa'i Peine, na e urine lo'u. E liu taane hai leesie mweita'aana, ta'e e liu tara'asi no'one mola mwaanie. ");
INSERT INTO apb_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Ta'e lae-lae, ngaeta mwane ni Samaria, mwane aana hanue mo maelonga ikie mo Jiu, ko lae no'one hao i sulie tala ngeena. E lae hao i leesie a mwaena na e eno mola i sulie tala, oto ko tohungei aamasie. ");
INSERT INTO apb_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Mwane ni Samaria ngeena e da ho waen na ho rumu, oto ko lingisi'i mala meresine i laona mo malaka i sapena mwaena, ko si ho'o haahi'i. Oto e ne'ie i lengine dongki ingeie nge ko lae-lae aana, e si toolea ko lai lio i sulie ta'au i nume ni awataa. ");
INSERT INTO apb_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Oto hai dinge lo'u i sulie, mwane ni Samaria e ta'aasie mei to'oha mwaanie mwa'i ingeie adona ii'onga aana nume ngeena ola mala e oolu wiki. Oto ko nii'i hunie mwane ko lio i sulie nume ngeena, na ko unue hunie uuri, ‘O ke lio i suli diana aana oto a mwane ie. Mala uri o ko aasie lo'u nga mei to'oha huni holie nga mei ola aana, ne ke si su'ue huni'o aana maholo ne kei ooli lo'u mei.’” ");
INSERT INTO apb_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Oto a Jisas ko si te'uri hunie ha'a-uusuli aana mo Ha'atolanga a Mosis ngeena uuri, “?Iini uri taa aana e oolu mwane ngeena nge i'oe o lo'onga'inie uri e ne'i euhenue to'ohuu hunie mwane nge mo horopeli e horo'iena?” ");
INSERT INTO apb_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Oto ha'a-uusuli aana mo Ha'atolanga ko aalamie a Jisas uuri, “Iini nge e aamasie.” Oto a Jisas ko si te'uri hunie, “O ke lae, na o ke asu no'one urine mala ingeie.” ");
INSERT INTO apb_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Maholo a Jisas na mo pwaarongoisuli ingeie kire lae-lae, oto kire lai hule aana ngaeta huilume. Oto aana huilume ngeena keni satana a Maata e tolakonie a Jisas wau i nume ingeie. ");
INSERT INTO apb_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","A Maata e to'o aana nga keni eesine, satana a Meri, ta'e a Meri e ii'o mola i saana a Jisas huni pwaarongo i sulie mo ha'a-uusulinge ingeie. ");
INSERT INTO apb_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Oto, a Maata ko tohungei hii aaela aana ko hei rareta'i maraana. E lae wau, oto ko te'uri hunie a Jisas, “?Poro paine, uri e kohi mola aamu aana a keni eesiku e toli'aasieu mola hunie ne ke ha'alie maraaku? !O ke unue ke lae mai esu no'one pe'ieu!” ");
INSERT INTO apb_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Oto a Jisas e aalamie mola uuri, “Maata, Maata. O ko lae otoi tolahi'e aana mo ola hunge. ");
INSERT INTO apb_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Ta'e ta'a-ta'a mei ola ni mola e roro'a, na a Meri ko lae otoi deu diana, aana e lio hilisie oto tohungana mei ola diana, na nga iini e sa'a he'i ta'aasie lo'u mwaanie.” ");
INSERT INTO apb_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Ngaeta hai dinge a Jisas e lai ii'o aana ngaeta leu, oto ko aarenga'i. Maholo e aarenga'i mango oto, nge ngaeta iini aana mo pwaarongoisuli ingeie ko si te'uri hunie, “Aalaha ineu, o ke ha'asai'emeelu no'one aana tolahana aarenga'inge, oto mala a Jon e ha'asaie ka'u mo pwaarongoisuli ingeie.” ");
INSERT INTO apb_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Oto a Jisas ko te'uri hunire, “Maholo omu ko aarenga'i, omu ke ere uurini. Mama'a, Mwala ke ha'ama'u aana satamu. Aalahanga i'oe ke lae mai. ");
INSERT INTO apb_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","O ke niie mai huni'emi suli hei dinge, mo ngeulaa e adona dinge ngeena. ");
INSERT INTO apb_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","O ke sae'aasie huni'emi mo ooraha'aa i'emi, aana emi ko sae'aasie no'one mo roro'anga ta'ena nga iini ko deu hu'isi'emi. Na mwaanie o toli'aasi'emi huni ooraha'aa maholo malaahongalamami ko lae.” ");
INSERT INTO apb_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Na a Jisas e te'uri hunie mo pwaarongoisuli ingeie, “Mala uri nga iini hikemiu ke lae i saana a malahune i upui rodo, oto ko te'uri hunie, ‘Malahuku, o ke niie nga oolu ho ngeulaa hunieu, ");
INSERT INTO apb_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","aana ngaeta malahuku ko lae i suli henue, na e si kele hule ta'au i nume ineu oto molana, ta'e nga mei ola hunie ne ke niie ana ha'ike.’ ");
INSERT INTO apb_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Oto uri a malahumu ke aalami'o uure wau i nume uuri, ‘!Su'uri kotahieu! Maa e hono oto, na ahutameelu melu ko ma'ahu oto. Oto nou sa'a ta'ela'i ike lo'u huni niie nga mei ola amore'i.’ ");
INSERT INTO apb_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","?Oto nga taa eena? No ko unue oto huni'omu, ma'alana e unue uri e sa'a ta'ela'i lo'u huni niie nga kele ho ngeulaa huni'o aena aana i'oe oto malahune, ta'e kei ta'ela'i taane na kei haro niie mola mo ola saemu huni'i, aena aana o ka'a masa ike huni deu su'u-su'uie. ");
INSERT INTO apb_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“Oto no ko unue huni'omu uri omu ke susuke aana a God, na ingeie ke si niie huni'omu. Omu ke hai-heitalea i saana God, na omu ke si lio oodoie. Na omu ke iiki-iiki i kolune maa ingeie, na ingeie ke si tahanie maa talamiu. ");
INSERT INTO apb_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Aana ta'ena nga iini ko sukaa nga mei ola aana a God, nge kei niie oto hunie. Na ta'ena nga iini ko heitalea nga mei ola aana a God, kei lio oodoie oto. Na ta'ena nga iini ko iiki-iiki ikolune maa ingeie, nge a God kei taha maa talana oto. ");
INSERT INTO apb_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","?E ue aana i'omu mo mama'a? ?Mala uri kalemu ko sukaa nga ho ii'e aamu, o sai niie mola nga mwaa ana? ");
INSERT INTO apb_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","?Wa uri ko sukaa nga ho ma'opu, o kei niie mola nga hari-heri ana? !Ha'ike! ");
INSERT INTO apb_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","I'omu mo iinoni ooraha'aa, ta'e hule aana omu sai niie mo ola diana hunie mo mwela i'omu. ?Ilisie Aamamiu i Lengi iini e diana liutaa aana ta'ena nga iinoni, uri e sa'a niie Li'oa Maa'i hunie nga mo iini ko suke aana?” ");
INSERT INTO apb_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Ngaeta maholo a Jisas ko oohe aasie li'oa aaela mwaanie mwane e ka'a sai ere ike. Maholo li'oa aaela ngeena e iisitaa oto mwaanie a mwaena, nge ko si ere-ere lo'u. Mwala oto hunge kire loko i leune na kire ko tohungei pangata'i. ");
INSERT INTO apb_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Ta'e ngaeta mo iini aana mwala ngeena, kire ko unue mola uuri, “A Bielsebul, na'ohana mo li'oa aaela nge e niie nanamanga ngeena hunie huni oohe aasie mo li'oa aaela urine.” ");
INSERT INTO apb_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Na ngaeta mwala lo'u kire ko sare lupwe'i oohongie mola a Jisas aana kire lo'onga'inie uri e ka'a uure ike mwaanie a God, oto kire ko unue hunie uri ke da nga hu'i-hu'ite hunie kire ke leesie. ");
INSERT INTO apb_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Ta'e a Jisas mone e saie mola nga taa kire ko lo'o-lo'onga'inie, oto ko si te'uri hunire, “Ta'ena nga aalahanga kei oopa aani heiseuninge honosie maraana, nge kei na'onga oto. Na nga nume nge kei oopaa aani heiseuninge honosie maraana, nge kei ei'aa oto. ");
INSERT INTO apb_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","I'omu, omu ko unue uri no ko oohe aasi li'oa aaela aana nanamanga a Bielsebul, ta'e omu ke rongo ka'u. ?Mala uri aalahanga a Satan kei heiseuni honosie lo'u mola maraana, nge aalahanga ingeie ke si ii'o susu uri taa eena? ");
INSERT INTO apb_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","?Mala uri ineu no ko oohe aasi li'oa aaela aana nanamanga a Bielsebul, oto nga nanamanga uri taa ka'u nge mo pwaarongoisuli i'omu ko oohe aasi li'oa aaela aana? Mo pwaarongoisuli i'omu kire haata'i diana aana uri i'omu ni omu takalo. ");
INSERT INTO apb_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Ta'e ineu, no ko oohe aasie mo li'oa aaela aana nanamanga a God. Na leune e haata'i diana aana oto uri Aalahanga a God e hule oto i seemiu.” ");
INSERT INTO apb_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Oto a Jisas ko he'i ere ni aalahuunge lo'u i sulie nanamanga ingeie e saka liutaa aana Satan, na ko te'uri, “Mala uri nga mwane a'aila'a e to'o aana mo reisinge huni heiseuni na a mwaena ko kakalie nume ingeie, nge ahutana mo ola i laona nume ingeie kei ii'o pupupu. ");
INSERT INTO apb_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Ta'e mala uri ngaeta mwane e a'aila'a lo'u liutaa aana kei polahie na kei horo'ie oto, nge mwane a'aila'a liutaa ngeena kei leue oto mo reisinge a mwaena e puu-puuto'o aani ngeena, na ke si niie mola walu ola e toole'i mwaanie nume ngeena hunie mo malahune. ");
INSERT INTO apb_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Nga iini oto e ka'a lulu i sulieu, ingeie oto maelonga ineu. Na nga iini oto e ka'a pe'ieu huni toolea mai mo iinoni takoie a God, ingeie e urihana uri ko peesie mola mwala mwaanie a God.” ");
INSERT INTO apb_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Oto a Jisas ko he'i te'uri lo'u, “Maholo nga li'oa ni ooraha'aa ko iisitaa mwaanie nga iinoni, kei waloliu i laona hanuesala ni lio hunie nga leu ni mamalo ingeie. Mala uri e ka'a lio oodoie oto nga leu, nge ke si te'uri hunie maraana, ‘Ohe ne kei ooli lo'u mola takoie nume ineu, iini nou iisitaa ka'u mwaanie.’ ");
INSERT INTO apb_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Oto e ooli ta'au na ko lio oodoie a mwaena e urihana nume nge kire tala rere'a aana, na kire hataa'i diana aana mo ola i laona. ");
INSERT INTO apb_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Oto ko si lae lo'u huni toolea mai ngaeta hiu li'oa ni ooraha'aa aaela lo'u liutaa aana ingeie. Oto kire lae, kire ko si lae oto ii'o huu i laona iinonine. Oto aana ha'amangolana, tolahana iinonine lo'u mei puri ko si tohungei aaela oto hiito'o liutaa aana tolahana hola'ina'o.” ");
INSERT INTO apb_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Maholo a Jisas ko ere-ere ue urine, na ngaeta keni aana mwala e ruru ngeena ko te'uri hunie, “!Deidehie oto a nikemu!” ");
INSERT INTO apb_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Ta'e a Jisas e aalamie uuri, “Iau, ta'e ilenimwa'enga oto liutaa hunie ahutana mo iini ko rongoa walana God na kire ko lulu i sulie.” ");
INSERT INTO apb_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Na maholo mwala hunge ko ruru mei saana a Jisas, oto ko si ere uuri hunire, “I'omu mwala aana maholo ienini, tolahamiu e tohungei aaela. Omu ko sukaa uri omu ke leesie mola nga hu'i-hu'ite mwaanie a God. Ta'e nou sa'a asuie ike. Ta'a-ta'a hu'i-hu'ite nou sai haata'inie aamiu oto nga taa e rau aana a Propet Jona oto waite. ");
INSERT INTO apb_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Aena aana nga taa e rau aana a Jona ngeena, e haata'inie uri a God ni nge e uusunge'inie a Jona i saada mwala ni pu'o i Ninive. Na e urine no'one aana ineu a Kale Ni Iinoni, aana nga taa kei reu eeku kei haata'inie uri a God ni e uusunge'inieu mei huni'omu, mwala aana maholo ienini. ");
INSERT INTO apb_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Aana dinge ni leinge Toro ni Siba kei ta'ela'i no'one honosi'omu aana pwaunge ienini, na kei ere aamiu uri omu tohungei takalo oto liutaa. Aana ingeie e uure ha'atau oto i ngongo'ana walumalau huni lae mai rongoa mo ha'a-uusulinge ni saenanaunge a Solomon Inemauri. Na no ko unue oto huni'omu uri ngaeta iini e paine lo'u liutaa aana Solomon taane i matolamiu i leu, ta'e omu ko leledie mola. ");
INSERT INTO apb_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Na aana dinge ni leinge, mo Ninive no'one kei ta'ela'i honosie mwala aana maholo ienini. Oto kire kei haata'inie uri omu tohungei takalo oto hiito'o, aena aana maholo a Jona e laeliwala nana mwalana, kire oonisae oto. Ta'e lio ka'u, ngaeta iini e paine liutaa aana a Jona ka'u taane oto ie, na omu ka'a oonisae ike.” ");
INSERT INTO apb_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Oto a Jisas ko he'i te'uri lo'u, “Maholo nga iini ko ha'akaunie nga laite, e sa'a ne'i mumuni ike aana wa ke pwaoha'inie lulu'e haahie. !Ha'ike! Ta'e kei ne'i haada'i aana oto ta'au i lengi, hunie mwala ko sili mei nume na kire ke leesie oto rarangana laite ngeena. ");
INSERT INTO apb_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Oto maamu e urihana raa-raa hunie sapemu. Mala uri maamu e manola, nge ahutana sapemu kei matapwa oto, ta'e mala uri maamu e ka'a manola, nge ahutana sapemu kei rodohono oto. ");
INSERT INTO apb_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Lio diana aana, mwaanie o unu-unue uri saemu e manola taane, ta'e e rodohono mola. ");
INSERT INTO apb_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Aana ahutana sapemu kei honu aana raa-raa na nga leu aana ka'a rodohono lo'u, nge e urihana maholo laite e raangi'o na ahutana sapemu e matapwa mango.” ");
INSERT INTO apb_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Maholo a Jisas e ere-ere mango, nge ngaeta Parise ko si haaraie uri huni lai ngeu pe'ie i nume ingeie. Oto a Jisas e lae pe'ie na maholo kirerue hule wau i nume a mwaena, a Jisas e ii'o mola i aano huni ngeu ");
INSERT INTO apb_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","na e ka'a hola'i hodalie ike ki'ine i sulie tolahada mo Parise. Oto Parise ngeena ko tohungei pangata'i aana e leesie urine. ");
INSERT INTO apb_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Oto a Aalaha ko te'uri hunie, “I'omu mo Parise omu urihana mola mo nime na mo kao-kao kire hoda rere'a aana aapa po'oi sinaha, ta'e wau i laona e honu mola aana ngaulaa e kasu. Omu ko sasare lio kohi i maana mwala, ta'e hule aana saemiu e honu oto mola aana horo-pelinge na ta'ena nga lo'onga'inge aaela. ");
INSERT INTO apb_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","!Omu tohungei pweu! ?Ohe omu ko lo'onga'inie uri iini e ha'aholaa po'oi sinaha, e ka'a ha'aholaa ike po'oi lalo no'one? ");
INSERT INTO apb_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Taungei hoda-olanga urine e ka'a roro'a ike. Ta'e mala omu ke nii ola mola i laona mo nime na mo kao-kao ngeena ana kira maitale, ha'alaa ahutana walu ola ngeena ke si meni rere'a to'ohuu huni'omu. ");
INSERT INTO apb_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","!Aama-aamasilemiu mo Parise! Aana omu sai niie tangahulu'ana tari-olanga i'omu hunie a God, na hule aana omu ko niie no'one tangahulu'ana mo kele takai ei mwei-mwei uure mwaanie mo hohola i'omu. Ta'e hunie ha'a-oodohilemiu pe'ie mwala na huni manata diana hunie a God, nge omu ka'a sai aapwasu ike aana. Mo na'ohai ola uri hunie omu ke dau i suli'i ka'u ienini. Na lo'u mwaanie omu pulongosie mo ha'a-uusulinge mwai-mwei mala niilana tangahulu'ana tari-olanga i'omu. ");
INSERT INTO apb_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","!Aama-aamasilemiu mo Parise! Aana omu ko heri hunie mo na'ohai ii'o-ii'oha hali'ite i laona mo nume ni palo-palo, na uri mwala ke ha'apaina'a'omu aana maholo omu ko walo liu i laona mo leu ni uusi'e. ");
INSERT INTO apb_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","!Aama-aamasilemiu! Aana omu urihana mola mo kilipwe'u kire aano oto, aana aapa po'oi sinaha e lio diana taane na mwala sa'a lio saie ike uri rae kire aanomie i leune.” ");
INSERT INTO apb_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Oto ngaeta iini hikana mo ha'a-uusuli aana mo Ha'atolanga a Mosis ko aalamie a Jisas uuri, “Ha'a-uusuli, o ko ere urine, o ko ere aaelasi'emi oto no'one ni ngeena.” ");
INSERT INTO apb_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Oto a Jisas ko aalamie ko te'uri, “!Aama-aamasilemiu no'one mo ha'a-uusuli aana mo Ha'atolanga! I'omu, omu ko da ludaa e hi'e aana mo ha'atolanga hunie mwala. Ta'e hule aana i'omu maraamiu na omu sa'a nii ki'i huni pe'ie mwala huni sulu'ie ludaa ngeena. ");
INSERT INTO apb_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","!Aama-aamasilemiu! Aana omu esu diana aana mo kilipwe'u talana mo propet nge mo aamamiu e horo maesire. ");
INSERT INTO apb_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Aena urinena, i'omu, omu ko ha'awalaimoli'aa nga taa nge mo aamamiu kire asuie eena. Aana ikire, nge kire horo'ie mo propet, na i'omu, omu ko esuie mo kilipwe'u huni aamasito'o aana horo'ilada. ");
INSERT INTO apb_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Aana e urine ka'u, a God e ere ni saenanaunge uuri, ‘Ne kei uusunge'inie mai mo propet na mo hurula'aa i saada. Na kire kei horo maesie nga mo iini aada, na kire kei teunge'inie nga mo iini.’ ");
INSERT INTO apb_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Oto ha'aloilemiu pwaunge si'iri kei lae haahie maelana mo propet nge horo'ilada e lae ka'u uure oto i aehotalana walumalau. ");
INSERT INTO apb_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Ha'aloilemiu kei lae haahie horo'ilada, aehota pe'ie a Ebol lae hule aana a Sekaraea, iini horo'ilana e lae kara'inie ora ni uunu-uunu aana Nume Maa'i Peine. To'ohuu no ko unue oto huni'omu uri i'omu pwaunge si'iri ie a God kei ha'aloi'omu haahie horo'ilana ahutada mango. ");
INSERT INTO apb_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","!Aama-aamasilemiu mo ha'a-uusuli aana mo Ha'atolanga! Aana omu ko mumunie kii huni tahanie maa aana nume ni saenanaunge i sulie tolahana a God. Na i'omu maraamiu no'one hule aana omu ka'a sare sili ike i laona numena, na omu ko deu honosie mo iini ko sare sili i nume.” ");
INSERT INTO apb_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Maholo a Jisas ko iisitaa oto mwaanie leune, mo ha'a-uusuli aana mo Ha'atolanga a Mosis na mo Parise ko si aehota ere aaelasie oto hiito'o, na uure aana maholona kire ko tala'ai dolosie oto mo ola hunge aana, ");
INSERT INTO apb_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","aena aana kire sare lupwe'i da mola uri hunie ke unue nga mei wala huni waelie maraana. ");
INSERT INTO apb_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Ngaeta maholo, mo sinolai iinoni oto hunge kire ruru mei saana a Jisas, na leune e lae wai honu aani iinoni hule aana nga leu ni uure ha'ike lo'u. Oto a Jisas ko si hola'i te'uri hunie mo pwaarongoisuli ingeie, “Omu ke lio talamiu mwaanie tolahana mo Parise, aana ikire mwala eero-eero. Mala nga kele mei iis ko esuie nga nime pulaoa paine ke hane, nge tolahana eeronga ikire ko to'ohie walu ola kire ko esui'i. ");
INSERT INTO apb_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Ta'e-ta'ena nga mei ola iinoni ko mumumunie, haata'inilana kei saro lae mola, na ta'ena nga mei ola ko reu mumuni, sailana kei saronai lae taane. ");
INSERT INTO apb_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Na nga taa nge omu ko ere-ere mumuni aana, na mwala kei saronai saie mola. Na nga taa nge omu ko kele sasawarunge'inie oto mola i eelingemiu i laona duru i'omu maraamiu, soinge'inilana kei lae taane hunie mwala ke mani rongoa.” ");
INSERT INTO apb_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Oto a Jisas ko he'i te'uri lo'u, “Maeni malahuku, omu ke su'uri me'ute'inie mwala ko sare horo'i'omu, aana kire sa'a da lo'u nga mei ola aaela huni waeli'omu mei puri. ");
INSERT INTO apb_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Ta'e ne ke haata'inie aamiu iini hunie omu kei me'ute'inie. Omu ke ma'ute'inie mola a God, iini nge e sai horo maesi'omu, na e to'o aana no'one nanamanga huni aasi'omu i laona dunge ni ha'amotaahinge lo'u mei puri. Iau, no ko unue lo'u huni'omu, ingeie ni oto iini omu ke ma'ute'inie. ");
INSERT INTO apb_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","E lime kele pipisu holileni e lae mola aana e ro peni pulu. Ta'e hule aana a God e sa'a roro'a pulongosie ike nga ta'a-ta'a kele iini eeni. ");
INSERT INTO apb_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Omu ke saie uri a God hule aana e sai susulie warai iihune pwaumiu. Oto omu ke su'uri me'u, aena aana omu tohungei hi'e liutaa aana mo pipisu oto hunge. ");
INSERT INTO apb_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Ineu, no ko unue oto huni'omu uri ta'ena nga iini kei unu tahanga'inieu i na'ona mo iinoni uri ingeie iinoni ineu, nge ineu a Kale Ni Iinoni, ne kei unu tahanga'inie iinonine no'one urine i na'ona mo ensel a God, uri ingeie iinoni ineu. ");
INSERT INTO apb_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Ta'e nga iini nge kei taateinge'inieu i na'ona mo iinoni, nge ineu a Kale Ni Iinoni, ne kei taateinge'inie no'one i na'ona mo ensel a God uri iinoni ngeena nga iinoni ineu ha'ike. ");
INSERT INTO apb_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Na mala nga iini kei unue nga mei wala honosieu a Kale Ni Iinoni, a God e sai sae'aasie mola hunie. Ta'e mala nga iini kei ere mwakata'inie Li'oa Maa'i, nge a God e sa'a roro'a sae'aasie lo'u mwaanie iinonine. ");
INSERT INTO apb_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Na i'omu mo iinoni ineu, maholo kire kei toole'omu hunie leilemiu i laona mo nume ni palo-palo mo Jiu, wa i na'ona mo aalaha, wa i na'ona mo inemauri, omu ke su'uri tolahi'e i sulie omu kei uure ma'uta'a uri taa, wa nga taa omu kei unue. ");
INSERT INTO apb_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Aana Li'oa Maa'i kei haata'inie taane aamiu nga taa ni unue aana maholona.” ");
INSERT INTO apb_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Oto ngaeta mwane aana ruruhaa ko te'uri hunie, “Ha'a-uusuli, o ke unue hunie aasiku ke oopaa to'o-to'onga nge aamamere'i e niie namere'i aana hai dinge e mae.” ");
INSERT INTO apb_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Oto a Jisas ko aalamie uuri, “!Mwaena! Lio hilisileku e ka'a lae ike hunie ne ke oopa to'o-to'olamore'i wa uri ne ke leie mo ola urine.” ");
INSERT INTO apb_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Na a Jisas ko he'i lae lo'u pe'i erenga uurini hunie ahutada, “Omu ke lio talamiu na omu ke kineta'ini'omu mwaanie ta'ena nga saehanalinge. Aana tohungana mauriha'ana iinoni e ka'a lae ike i sulie nga taa nge iinoni e to'o aana, ma'alana iinoni ngeena ke to'o-to'o lo'u uri taa.” ");
INSERT INTO apb_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Oto a Jisas ko ere ni aalahuunge hunire uuri, “Ngaeta mwane to'o-to'o e to'o aana mei aano diana nge ahutana ola e aahu diana i laona. ");
INSERT INTO apb_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","E o'o'o, oto ko aehota lo'o-lo'onga'i uuri, ‘Nga leu ni durue mo ngeulaa ineu ha'ike. ?Oto ne ke si ue eena?’ ");
INSERT INTO apb_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Oto ko he'i lo'onga'i lo'u uuri, ‘Nou saie oto nga taa ne kei esuie. Ne kei ohoie mola mo nume ni duru ineu, na ne ke asu peine lo'u eeni. Oto ne ke si durue mo ngeulaa ineu, na oto ahutana walu ola ineu i laona nume haalu ngeena. ");
INSERT INTO apb_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Purine, ne ke si unue hunieu maraaku uuri, !Ingeie ka'une! Nou to'o aana oto walu ola diana adona mo helisi hunge. Ne ke mamalo mola, aana mauringe e mwada'u oto hunieu.’ ");
INSERT INTO apb_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Ta'e a God e te'uri hunie a mwaena, ‘!O tohungei pweu! Si'iri rodo, oto o kei mae. ?Ha'alaa, a tei nge kei to'o aana ahutana walu ola nge o ko duduru'i mola namue maraamune eena?’” ");
INSERT INTO apb_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Oto a Jisas ko si ere uuri, “Kei urine oto hunie mo iini nge ko dudurue mola dianaha'ana mo ola aana walumalau ie nada maraada, ta'e kire ka'a to'o-to'o ike aana tolahana a God.” ");
INSERT INTO apb_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Oto a Jisas ko unue hunie mo pwaarongoisuli ingeie uuri, “Aena urinena, no ko unue oto huni'omu uri mwaanie omu ne'i-ne'isae paine aana mei ngeulaa ni meuri aana i'omu, wa mo to'oni huni to'oni haahie sapemiu. ");
INSERT INTO apb_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Aana mauringe e roro'a liutaa aana ngaulaa, na sapemiu e roro'a liutaa aana to'oni. ");
INSERT INTO apb_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Omu ke leesie ka'u mo menu ko loo-loho hailiu ngeena. Kire ka'a au'esu hohola, wa uri kire ke so'o-so'okoni huni duru'i. Ta'e a God ko ha'a-ha'angaure taane. !Ilisie i'omu mo iinoni! Omu roro'a liutaa aana mo menu i maana a God. ");
INSERT INTO apb_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Oto aana ma'alana omu ke lo'o-lo'onga'i liutaa lo'u i sulie mauringe i'omu, ta'e omu sa'a roro'a da ike mauringe ngeena ke tewa lo'u. ");
INSERT INTO apb_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","?Mala uri omu ka'a sai deu i sulie mo kele ola mwai-mwei urine, na e ue omu ko si lae otoi tolahi'e i sulie mo ola paine? ");
INSERT INTO apb_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Omu ke leesie ka'u mo ei tataka nge kire ko pwito hailiu ngeena. Kire ka'a au'esu wa kire ke tau-teuri sala. Ta'e no ko unue huni'omu uri ma'alana a Solomon Inemauri e to'o-to'o liutaa na e sai to'oni aana mo to'oni manikulu'e, ta'e mo ei tataka ngeena kire ho'o sala lio diana liutaa aana. ");
INSERT INTO apb_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Mo ei tataka ngeena, mo ola ka'a o'o'o tewa ike no'one. Kire ko eehurara mola i matana ho'owa, na i seulehi kire ko nunulu oto lo'u, na mwala ko aasi'i mola i laona dunge. ?Oto mala a God ko ha'ato'onie mo takai ei ngeena, ohe omu unue uri a God e sa'a nii to'oni ike haahi'omu? !Hiiwalaimolinge i'omu e lae otoi mwei-mwei hiito'o! ");
INSERT INTO apb_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Omu ke su'uri lae otoi tolahi'e hiito'o lo'u aani lo'onga'inge aakau i sulie nga taa omu kei ngaa na nga taa omu kei inuhie. ");
INSERT INTO apb_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Mwala ni pu'o ni kire ko lae otoi totolahi'e hiito'o i sulie mo ola urine. Ta'e i'omu, Aamamiu e saie taane oto uri omu saeto'o aana mo olana. ");
INSERT INTO apb_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Ta'e omu ke ne'i-ne'isae aana Aalahanga a God liutaa aana ta'ena nga ola mai aano, na ingeie ke si sapeie ta'ena nga ola huni'omu. ");
INSERT INTO apb_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Ma'alana omu ka'a hunge, ta'e mwaanie omu me'u-me'u, maeni mwela, aena aana Aamamiu ko tohungei ilenimwa'e hunie omu kei aalaha pe'ie i laona Aalahanga ingeie. ");
INSERT INTO apb_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Oto omu ke ha'aholinge'inie mola to'o-to'olamiu, na omu ke niie mei to'oha aani hunie kira maitale. Omu ke mwa'ie mo to'oha i'omu i laona mwa'i e sa'a moka ike. Na omu ke looha'inie to'olamiu i Lengi, aana leu kire sa'a peli'i ike aana, wa mo kokorosi ke waeli'i. ");
INSERT INTO apb_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Aena aana leu nge to'olamiu e ii'o aana, nge saemiu kei talei o'o'o no'one mola aana leune.” ");
INSERT INTO apb_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Oto a Jisas ko he'i te'uri lo'u, “Omu ke dau aakau taraure'i loosie nga taa ko lae mai. Omu ke roro ma'uta'a aana mo to'oni i'omu, na omu ke ha'akaunie mo laite i'omu kire ke eeso-eeso, ");
INSERT INTO apb_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","mala mo koni-konihe ko maa'oohie aalaha ikire kei ooli mei mwaanie aaharota. Aana maholo kei lae mai iiki ikolune maa, oto kire ko tolana tahamaa oto talana. ");
INSERT INTO apb_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Deidehie mo koni-konihe ngeena nge aalaha ikire e hule na kire ko lio-lio mola ue aana kire dau aakau loosie. No ko unue oto huni'omu uri aalaha ikire ngeena kei oolisi aana mo to'oni ni esunge, kei ha'a-ii'osire oto hunie ngaunge, na kei rareta'inire oto aani ha'alianga hunire. ");
INSERT INTO apb_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Deidehie mo koni-konihe ngeena, aana ma'alana aalaha ikire ko si hule mola i upui rodo wa i hatari dengi, ta'e kei lio oodoie oto kire dau aakau loosie pe'ie maa'oohilana. ");
INSERT INTO apb_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","“Oto omu ke sai diana aana uri, mala iinoni e to'o aana nume ko saie maholo iinoni peli-peli kei lae mai, e sa'a roro'a ni toli'aasie ike uri iinoni peli-peli ngeena ke sili i nume ingeie. ");
INSERT INTO apb_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Oto i'omu no'one, omu ke ii'o aakau, mwaanie ineu a Kale Ni Iinoni, nou lae mola mai aana maholo omu ka'a lo'o-lo'onga'inie ike ne kei lae mai aana.” ");
INSERT INTO apb_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Oto a Pita ko te'uri, “?Poro paine, uri o unue aalahuunge ie mola huni'emeelu hali'ite, wa no'one hunie mwala e loko ngeena?” ");
INSERT INTO apb_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Oto a Jisas ko aalamie a Pita uuri, “No ko unue huni'omu na hunie ta'ena nga iini e saenanau. ?Aana a tei ka'u e saenanau na e ne'i koni-konihe diana? Ingeie oto iini nge aalaha ingeie e ne'ie hunie ke lio i sulie ngaeta mwala au'esu aana maholo ko lae, na hunie ke nii-niie waaitada hunire i suli maholo. ");
INSERT INTO apb_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Na kei tohungei diana oto liutaa hunie koni-konihe ngeena, mala uri aalaha ingeie kei lio oodoie ko esu diana urine maholo kei ooli mei. ");
INSERT INTO apb_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Mala ko urine, nge no ko unue oto huni'omu uri aalaha ngeena ke si ne'ie oto koni-konihe ngeena hunie ke lio i sulie oto ahutana to'o-to'olana. ");
INSERT INTO apb_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","“Ta'e mala uri koni-konihe ngeena ko lo'onga'inie mola uri aalaha ingeie e sa'a hule ike lau-leu, oto ko talei seu-seunie mola ngaeta mwala au'esu, na ko talei tara mola aana ngaunge, na ko pweu mola aana inuhilana wai ni mehiri, ");
INSERT INTO apb_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","oto aalaha ingeie kei hule mola, na e ka'a dau aakau ike. Na ko hule no'one mola aana maholo koni-konihe ngeena e ka'a lo'onga'inie huni maa'oohie. Oto aalaha ngeena kei tohungei ha'aloi letehie koni-konihe ingeie ngeena, na kei uusunge'i aasie oto pe'ie mwala hai-heitohe. ");
INSERT INTO apb_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Aana koni-konihe nge e saie taane saena aalaha ingeie uri nga moi taa e saeto'o aani, ta'e e ka'a dau aakau wa ke dau i suli'i, kire kei tohungei ha'aloi letehie oto hiito'o. ");
INSERT INTO apb_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","“Ta'e koni-konihe nge e ka'a saie ike saena aalaha ingeie, na ko deu hu'isie mola saena aalaha ingeie, kire sa'a lae otoi ha'aloi letehie hiito'o. Aana nga iini nge niilana nga mo ola hunge e lae hunie, a God kei saeto'o aana lo'u a mwaena ke asuie nga mo ola hunge. Na nga iini nge niilana mo ola hunge liutaa e lae hunie, nge a God kei saeto'o aana lo'u a mwaena ke asuie nga mo ola hunge liutaa.” ");
INSERT INTO apb_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Na a Jisas ko he'i te'uri lo'u, “Nou lae mai huni eereha'inie walumalau, na nou saeto'o aana uri dunge ngeena ke eeso-eeso oto, hunie ke oopaa mo iini diana mwaanie mo iini aaela. ");
INSERT INTO apb_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Nou manata'inie oto uri ne kei sapesalu oto hiito'o hule aana maenga, na ne kei tolahi'e oto hiito'o i sulie sapesalunge ngeena lae hule aana kei oa. ");
INSERT INTO apb_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","“Mwaanie omu lo'o-lo'onga'inie uri nou lae mai huni toolea mai hanuelamanga hunie walumalau. !Ha'ike! Ka'a hanuelamanga ike, ta'e oopanga. ");
INSERT INTO apb_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Uure si'iri pwau weu, mo uluhe ni iinoni kei heukama honosire hailiu. Nga oolu iini kei heukama honosie nga ro iini, na nga ro iini kei heukama honosie nga oolu iini. ");
INSERT INTO apb_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Mo he'i aamana kei heukama honosire hailiu, na mo he'i nikana kei heukama honosire hailiu, na mo mahungaona keni kei heukama honosire hailiu.” ");
INSERT INTO apb_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","A Jisas e unue no'one hunie mwala uuri, “Maholo omu ko leesie mei rorodo pulu-pulu'e ko hane, oto omu ko tolana unue oto uuri, ‘Kei nemo oto eena,’ na kei nemo oto. ");
INSERT INTO apb_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Na maholo omu ko hiinge'inie ko iiru ni maraau, na ni omu unue uuri, ‘I eesi meuri kei aaela oto eena,’ na kei aaela oto urine. ");
INSERT INTO apb_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","!I'omu kira lupwe'i deu! Omu tohungei pweu oto to'ohuu. Omu sai lio saie ka'u mola walu ola aana walumalau ie na mo ola ta'au i salo. ?Ta'e e ue omu ka'a sai lio saie nga taa ko reu aana maholo ienini?” ");
INSERT INTO apb_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Na a Jisas e he'i aalahuu lo'u i sulie uure-rurunge pe'ie a God, ko te'uri, “?Aana e ue ni omu ka'a sai lei'omu maraamiu nga taa e diana huni esuie? ");
INSERT INTO apb_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Mala nga iini ko sare toole'o i laona leinge, o ke uure ruru oto lau-leu pe'ie iinoni ngeena maholo i'omore'i ue i sulie tala takoie nume ni lei-lei. Mala o ka'a te'urine, nge maelonga i'oe kei toli'aasi'o hunie mwane lei-lei na a lei-lei kei toli'aasi'o i nimana mo ramo, oto kire kei aasi'o i laona nume ni ho'o. ");
INSERT INTO apb_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","To'ohuu no ko unue oto huni'omu uri omu sa'a roro'a ni iisitaa ike na omu ka'a saro su'u mangoa mei to'oha nge kire holosie huni'omu.” ");
INSERT INTO apb_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Aana maholona ngaeta mwala e o'o'o pe'ie a Jisas, kire ha'arongoa aana mwala ni Kalili nge a Paelat e horo maesire aana maholo kire uunu-uunu ola i saana God. ");
INSERT INTO apb_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Oto a Jisas ko te'uri hunire, “?Ohe omu ko lo'o-lo'onga'inie uri mwala ni Kalili ngeena kire mae urine, e haata'inie uri kire ooraha'aala lo'u liutaa aana ahutana mwala aaopa ni Kalili? ");
INSERT INTO apb_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","!Ha'ike oto oo'oo! Na no ko unue oto huni'omu uri mala omu ka'a oolisie saemiu na omu ke toli'aasie tolahai iinoni aaela i'omu ngeena, omu kei meni mae no'one mola mala ikire. ");
INSERT INTO apb_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","?E ue aana aawalai iinoni mwana walu ni Jerusalem nge kire mae aana saohai nume e aa'oho haahire i Saeloam? ?Omu lo'onga'inie uri mwala ngeena kire ooraha'aala liutaa aana lo'u ahutana mo iini nge kire ii'o no'one i Jerusalem? ");
INSERT INTO apb_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","!Ha'ike oto oo'oo! Na no ko unue oto huni'omu uri mala omu ka'a oolisie saemiu na tolahamiu, omu kei meni mae no'one mola mala ikire.” ");
INSERT INTO apb_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Oto a Jisas ko ere ni aalahuunge hunire uuri, “Nga mwane e hasie ai hungu-hungu i laona hohola ingeie. Ahutana maholo a mwaena ko lae mai lio-lio hunie ohe ai ngeena ko hungu-hungu taane, ta'e ha'ike mola. ");
INSERT INTO apb_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Oto a mwaena ko te'uri hunie koni-konihe ingeie nge ko lio i sulie hohola, ‘No ko talei lio-lio hunie ohe ai ngeena ko hungu-hungu taane aani hue-huei ei suli maholo, ta'e oolune nga halisi lo'u ie na e ka'a sai hungu ike. E lae otoi diana uri o ke tohu aasie mola mwaanie e waelie mei mwakano kohi ngeena.’ ");
INSERT INTO apb_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Ta'e koni-konihe ingeie e aalamie uuri, ‘O ke toli'aasie ka'u, aalaha ineu, hunie ne ke eli mwakano ka'u lo'u i ae'aena, na ne ke lio diana i sulie lo'u hunie nga ta'a-ta'a halisi. ");
INSERT INTO apb_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Mwaanie ohe ne kei esu urine aana, kei hungu taane aana halisi meine. Mala uri e ka'a hungu lo'u, nge o ke si tohu aasie taane.’” ");
INSERT INTO apb_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Aana ngaeta Dinge Maa'i Mo Jiu, a Jisas e ha'a-uusulie mwala i laona nume ni palo-palo mo Jiu. ");
INSERT INTO apb_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Maholona na ngaeta keni li'oa aaela e hite aana ingeie no'one i leune. A keine, kolune e kokosu oto, na e ka'a sai uure hala-hala ike lo'u. E ii'o mola urine hunie aawalai helisi mwana walu. ");
INSERT INTO apb_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Maholo a Jisas e leesie a keine, oto ko soie mai saana na ko te'uri hunie, “Keine, mei maelaa i'oe e ai'aa oto mwaani'o.” ");
INSERT INTO apb_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Oto a Jisas e hele i sapena a keine, na a keine ko tolana uure oodo oto pe'i ha'amanikulu'aa God. ");
INSERT INTO apb_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Maholo na'ohai mwane haahie nume ni palo-palo ngeena e leesie a Jisas e ha'a-uurie a keine aana Dinge Maa'i Mo Jiu, oto ko saewasu na ko te'uri hunie mwala, “E oono aata hai dinge mola kolu sai deu esunge aani. Oto omu ke lae mola mai aana e oono hai dinge ngeena. Omu ke su'uri lae mai hunie ha'a-uurilemiu aana Dinge Maa'i.” ");
INSERT INTO apb_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Oto a Jisas ko aalamie uuri, “!I'omu oto mwala mola huni lupwe'i deu-deu! Ahutemiu omu ko luluhesie ka'u mola mo puluke na mo dongki i'omu, na omu ko too-toole'i ka'u mola i wei huni inu-inu aana ahutana dinge, ma'alana uri aana Dinge Maa'i. ");
INSERT INTO apb_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","A keni nge nou ha'a-uurie ie, ingeie keni aasikaelu no'one mo Jiu, na a Satan e hele aana oto hunie aawalai helisi mwana walu. ?Oto e ue? ?Uri e ka'a diana ike huni ha'a-uurie aana Dinge Maa'i?” ");
INSERT INTO apb_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Maholo a Jisas e ere urine, oto mo maelonga ingeie kire ko tohungei masa oto hiito'o, ta'e ahutana mwala ko si meni ilenimwa'e mola haahie walu ola manikulu'e nge a Jisas ko esui'ine. ");
INSERT INTO apb_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Oto a Jisas ko dolosi aana mwala uuri, “?Aalahanga a God e urihana nga taa? ?Nga taa ni ne kei ha'amalaa aana? ");
INSERT INTO apb_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Ne kei ha'amalaa aana kele litei ola aana ai mastad nge iinoni e toolea, oto e hasie i laona hohola ingeie. Oto maholo e pwito poi na ko peine, ko ne'i ei oto, na mo menu ko si lae mai tola niu'i i lengine mo sasarana.” ");
INSERT INTO apb_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Na ko he'i dolosi lo'u uuri, “?Nga taa ni ne kei ha'amalaa Aalahanga a God aana? ");
INSERT INTO apb_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","E urihana no'one kele mei iis nge hu'e e pwaie i laona nimei pulaoa oto paine, na ahutana e haro po'o mango mola aana e hane.” ");
INSERT INTO apb_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Oto a Jisas ko lae pe'i ha'a-uusulie mwala aana mo huilume paine na mo iini mwai-mwei aana ko lae hunie i Jerusalem. ");
INSERT INTO apb_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Na ngaeta iini e dolosi aana uuri, “?Poro paine, e nite iinoni ni ha'a-uurilada kei lae? ?Mwaanie nga toota'i iini mola nge a God kei ha'a-uurire?” Oto a Jisas ko aalamire uuri, ");
INSERT INTO apb_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Omu ke dau aahonga to'ohuu huni sili i sulie maai para e kokohisi, aana no ko unue oto huni'omu uri mo iini hunge kei eri'apasie silinge wau, ta'e e sa'a mwada'usire ike. ");
INSERT INTO apb_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Na maholo mwane e to'o aana nume kei honoa maa aana nume ingeie, omu kei uure mola po'oi sinaha, na omu kei talei iiki-iiki mola pe'ie erenga uuri, ‘Poro paine, o ke tahamaa talameelu.’ Oto kei aalami'omu mola uuri, ‘Nou ka'a manata'ini'omu ike. ?Omu uure i tei?’ ");
INSERT INTO apb_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Oto omu kei he'i te'uri lo'u hunie, ‘I'emeelu ka'u melu ngeu-ngeu na melu inu-inu pe'i'o, na o ha'a-uusuli'emi aana mo henue i'emi.’ ");
INSERT INTO apb_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Ta'e a mwaena ke si he'i te'uri lo'u mola huni'omu, ‘Nou ka'a tohungei sai'omu ike wa ne ke saie mo henue i'omu. Omu ke tahi mwaanieu, i'omu mo iinoni aaela.’ ");
INSERT INTO apb_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","“I leune omu kei ii'o ni saehuunge mola pe'ie ngaranga. Aana omu kei leesie a Ebraham, na a Aesak, na a Jekob pe'ie mo propet oto i na'o ikire i laona Aalahanga a God, na i'omu, aasilemiu kei lae mola po'oi sinaha mwaanie leune. ");
INSERT INTO apb_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Na mwala hunge kei ruru mei mwaanie ahutana mo henue i laona walumalau. Kire kei ii'o i aano hunie ngauhe aana Aalahanga a God. ");
INSERT INTO apb_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Oto mo iini nge kire ii'o aana mo ii'o-ii'oha mwai-mwei aana mauringe si'iri, kire kei to'o aana mo ii'o-ii'oha paine aana maurihe ue mai. Na mo iini nge kire ii'o aana mo ii'o-ii'oha paine si'iri, kire kei ii'o aana mo ii'o-ii'oha mwai-mwei aana maurihe ue mai.” ");
INSERT INTO apb_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Oto aana maholona, ngaeta mo Parise kire lae mai saana Jisas, oto kire ko te'uri hunie, “!O ke tahi oto mwaanie i leu! A Herod Antipas ko sare horo maesi'o.” ");
INSERT INTO apb_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Oto a Jisas ko aalamire uuri, “E aasa hunie a Herod ke waelie asunge ineu, aana ingeie nga kele usu ni me'esu mola. Omu ke lai ha'arongoa uri aana mo dinge ienini, no ko ha'a-uurie mo mae-maea'a na no ko oohe aasi li'oa aaela mwaanie mo iinoni. Ta'e aana nga dinge e sa'a tewa taane lo'u, ne ke si ha'amangoa taane asunge ineu ie. ");
INSERT INTO apb_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Ta'e aana e urine na ne kei saro lae ue i sulie asunge ineu ie si'iri, i ho'owa, na i weite. Aana e ka'a diana ike uri hunie nga propet horo-maesilana ke lae aana nga leu aaopa, mwaanie oto i Jerusalem ha'alaa.” ");
INSERT INTO apb_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Oto a Jisas ko si te'uri, “!Aaia Jerusalem, Jerusalem! I'omu oto omu ko horo suuhe'inie mo propet na omu ko uu'i maesie mo iini a God e uusunge'inire mai huni'omu. Mo maholo hunge nou sasare pe'i'omu mala pwa-pwa ni kue ko lokoa mo kalena i hahana apa-apana huni ha'a-uurire. Ta'e omu ka'a saeto'o aaku ike. ");
INSERT INTO apb_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Oto omu ke saie, a God kei toli'aasie hanue i'omu, na kei na'onga oto. Na no ko unue oto huni'omu uri omu sa'a he'i leesieu lo'u lai hule aana omu kei ere i sulieu uuri, God o ke ha'adiana'aa iini ko lae mai nunuha'ana satana Aalaha.” ");
INSERT INTO apb_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Aana ngaeta Dinge Maa'i Mo Jiu, a Jisas e lae huni ngeu pe'ie ngaeta na'ohai Parise i nume ingeie. Na aana maholona, mwala i leune kire ko talei lio-lio hahuroto aana a Jisas uri huni leesie nga taa kei esuie. ");
INSERT INTO apb_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Oto ngaeta mwane e ro ki'ine na e ro ae'aena kire uupu, e lae mai saana a Jisas. ");
INSERT INTO apb_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Na a Jisas ko hola'i dolosi aana mo Parise na mo ha'a-uusuli aana mo Ha'atolanga a Mosis uuri, “?Ohe e diana taane aana mo Ha'atolanga huni ha'a-uuri aana Dinge Maa'i wa ha'ike?” ");
INSERT INTO apb_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Ta'e kire ka'a sai aalamie ike dolosinge ingeie. Oto a Jisas e hele aana a mwaena, e ha'a-uurie, e si toli'aasie hunie ke lae. ");
INSERT INTO apb_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Oto a Jisas ko he'i dolosi lo'u aana mo mwaena uuri, “?A tei hikemiu e ka'a sai esu aana Dinge Maa'i? ?Mala uri kalemu wa nga puluke i'oe e teke i laona nga kalinge aana Dinge Maa'i, nge o kei uaa? ?Uri ma'alana Dinge Maa'i na o sa'a lai hele aana hunie o ke wa'i eeliho'i aana mwaanie kalinge?” ");
INSERT INTO apb_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Ta'e kire ka'a sai aalamie ike no'one aana leune. ");
INSERT INTO apb_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Na a Jisas e lio saie uri ngaeta mo iini aada ko sare ii'o aana mo na'ohai ii'o-ii'oha. Oto ko unue mei aalahuunge ie hunire uuri, ");
INSERT INTO apb_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Mala nga iini ko haarai'o hunie aaharota, o ke su'uri ii'o ka'u aana na'ohai ii'o-ii'oha ta'au i na'o pe'ie mo aalaha. Mwaanie da na iinoni ko esuie ngauhe ngeena e haaraie no'one nga iini e paine liutaa aamu. ");
INSERT INTO apb_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Oto iini e haarai'omore'i kei lae mai unue huni'o uuri, ‘O ke ada mwaanie leu ngeena, hunie a mwane ie ke ii'o i leune.’ Urine, o kei tohungei masa oto hiito'o aana o kei lai ii'o oto hai puri. ");
INSERT INTO apb_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Ta'e maholo kire ko haarai'o urine, o ke lae ka'u mei, ii'o aana ii'o-ii'oha mwai-mwei. Hunie poro paine haahie ngauhe ngeena kei lae mai seemu, ke si unue huni'o uuri, ‘Malahuku, o ke ada ta'au i na'o.’ Oto urine nge ahutana mo iini aana ngauhe ngeena ke si ha'apaina'a'o. ");
INSERT INTO apb_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Aana ta'ena nga iini ko ha'apaina'aa maraana, ha'amwai-mwei'alana kei lae. Na nga iini ko ha'amwai-mwei'aa maraana, nge ha'apaina'alana ke si lae.” ");
INSERT INTO apb_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Oto a Jisas ko si te'uri hunie mwane nge e haaraie huni ngeu pe'ie, “Maholo o ko esuie nga ngauhe, o ke su'uri haaraie mola mai mo malahumu, wa mo eesimu, wa mo tekihemu, wa mo euhenue to'o-to'o i'oe, aana kire sai haarai'o lo'u huni su'u ola huni'o aana nga taa o da ka'u hunire. ");
INSERT INTO apb_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Ta'e maholo o ko esuie nga ngauhe, o ke haaraie mai kira maitale, na kira to'u, na kira rarasi, na kira ulu. ");
INSERT INTO apb_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Na ha'adiana'alamu ke si lae i leune, aana kire sa'a roro'a ni su'u ola ike lo'u huni'o. Aana a God ke si su'u ola oto huni'o aana dinge mo iini oodota'i kei ta'ela'i.” ");
INSERT INTO apb_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Na maholo ngaeta iini aana mwala e ii'o pe'ie a Jisas e rongoa mo ola ie, oto ko si te'uri hunie, “Deidehie mo iini kei ngeu aana ngauhe aana Aalahanga a God.” ");
INSERT INTO apb_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Oto a Jisas ko te'uri hunie, “Ngaeta iinoni e asuie ngauhe paine, oto e haaraie mai mwala hunge. ");
INSERT INTO apb_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Maholo e dau aakau aana ahutana walu ola mango, oto ko si uusunge'inie koni-konihe ingeie huni lai ha'arongoa mwala nge e haaraire ngeena uuri, ‘Omu ke lae mai aana walu ola e dau aakau mango oto.’ ");
INSERT INTO apb_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","“Ta'e kire ko meni aehota ere hailiu oto. Eetana nga iini ko unue hunie koni-konihe uuri, ‘Nou si holie mola mei aano haalu, na saeku uri ne ke lae ka'u i leesie. No ko eitanai'o, o ke toli'aasieu ke'u.’ ");
INSERT INTO apb_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Ngaeta iini ko unue uuri, ‘Nou si holie aawalai puluke haalu, na nou sare lai deu aadongani aana asunge ikire. No ko eitanai'o, o ke toli'aasieu ke'u.’ ");
INSERT INTO apb_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Na ngaeta iini ko unue uuri, ‘Nou si tola hu'e haalu, oto nou sa'a lae ike ta'au.’ ");
INSERT INTO apb_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Oto koni-konihe ngeena e ooli weu, ko si ha'arongoa aalaha ingeie aana mo olana. Poro paine ngeena ko tohungei saewasu, oto ko te'uri hunie koni-konihe ingeie, ‘O ke lae oto lau-leu ta'au i sulie mo tala paine na mo hari-heri tala i laona huilume, na o ke toolea mai mo iini e maitale, na mo to'u, na mo ulu, na mo rarasi.’ ");
INSERT INTO apb_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Oto maholo koni-konihe ngeena e ooli lo'u mei ko si te'uri, ‘Aalaha ineu, nga taa o unue hunieu, nou deu i sulie mango oto eena, ta'e mo leu hunge kire pwala mola ue adona mwala hunge.’ ");
INSERT INTO apb_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","“Oto poro paine ngeena ko he'i te'uri lo'u, ‘O ke lae lo'u i sulie mo tala mwai-mwei, na mo maai tala po'oi sinaha aana hanue, na nga mwala o ko leesire, o ke dau rarahire uri kire ke lae mola mai hunie nume ineu ke haro honu. ");
INSERT INTO apb_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","No ko unue oto huni'o uri nga ta'a-ta'a iini aana mwala nge nou hola'i haaraire, e sa'a lae ike mai ngeu aana ngauhe ineu ienini.’” ");
INSERT INTO apb_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Ngaeta maholo, mwala hunge kire hakusie a Jisas. Oto e aali'u takoire na ko te'uri hunire, ");
INSERT INTO apb_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Nga iini ko lae mai seeku aana ko sare ne'i pwaarongoisuli ineu, nge ke manata diana hunieu liutaa aana lo'u aamana, na nikana, na hu'e ingeie, na mo kalena, na mo eesine mwane, na mo eesine keni. Na hule aana ke manata diana hunieu lo'u liutaa aana mauriha'ana maraana. ");
INSERT INTO apb_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Na nga iini e ka'a mwa'e-mwa'e huni sapesalu hule aana maenga i lengine po'u-po'u i tehula'aku, nge e sa'a roro'a ne'i pwaarongoisuli ineu ike. ");
INSERT INTO apb_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Mala uri nga iini hikemiu ko sare tohue nga sao-saohai nume, kei hola'i ii'o ka'u i aano na ke iidumie mei to'oha ingeie, huni leesie uri ohe e to'o-to'o adona taane kei ha'amangoa nume ngeena. ");
INSERT INTO apb_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Mala uri e ka'a asuie urine, kei aehotaa taane asunge aana nume, ta'e e sa'a ha'amangoa ike numena. Oto mala uri nume ngeena e ka'a mango, mwala kei leesie na kire kei ha'amwasi aana uuri, ");
INSERT INTO apb_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","‘A mwane ngeena e aehota tohue taane nume, ta'e e ka'a sai ha'amangoa ike.’ ");
INSERT INTO apb_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Mala uri nga inemauri e to'o aana mola nga aawalai sinolai ramo huni ooho honosie ngaeta inemauri nge e to'o aana e ro aawalai sinolai ramo, nge kei hola'i ii'o ka'u i aano na ke ne'isae i sulie ohe kei a'aila'a taane huni ooho honosie ngaeta inemauri ngeena wa ha'ike. ");
INSERT INTO apb_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Mala ko ha'ike, na kei uusunge'inie oto nga mo mwane i na'o hunie kire ke lai ere pe'ie ngaeta inemauri mola hunie hanuelamanga.” ");
INSERT INTO apb_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Oto a Jisas ko si ere ooreta uuri, “E urine no'one aana nga iini ko sare ne'i pwaarongoisuli ineu, ke toli'aasie oto ahutana to'o-to'olana. Ko ha'ike na e sa'a roro'a ne'i pwaarongoisuli ineu ike. ");
INSERT INTO apb_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Ahaa tohungei ola diana, ta'e mala dianaha'ana kei ei'aa mwaanie, nge nga tala uri huni esuie ke ahaala ha'ike lo'u. ");
INSERT INTO apb_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","E ka'a diana lo'u hunie nga mei ola, ta'e mwala kei aasie mola.” Oto a Jisas e si ha'amangoa ere-erenga ingeie pe'ie mei wala uuri, “Mwaanie omu rorongo aasie mola mo wala ienini, ta'e omu ke lo'o-lo'onga'i diana i suli'i.” ");
INSERT INTO apb_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Aana ngaeta hai dinge, mwala susulu to'oha na mo iini e ooraha'aala kire lae mai saana Jisas huni rongoa mo ha'a-uusulinge ingeie. ");
INSERT INTO apb_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Oto mo Parise na mo ha'a-uusuli aana mo Ha'atolanga a Mosis kire ko aehota upwesie a Jisas, kire ko te'uri, “!Lio ka'u! A mwane ie ko tekuhie mola kira ooraha'aala na hule aana ko ngeu oto pe'ire.” ");
INSERT INTO apb_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Oto a Jisas ko ere ni aalahuunge hunire uuri, ");
INSERT INTO apb_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“?Mala uri nga iini hikemiu e to'o aana tangalai sipu, na uri nga ta'a-ta'a iini eeni e takalo, a mwane ngeena kei ue? Kei toli'aasie oto siwe aawala mwana siwe aana leu kire ko ngeu-ngeu aana, na kei lae otoi heitalea iini nge e takalo lai hule aana kei lio oodoie. ");
INSERT INTO apb_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Na maholo e lio oodoie, ko si tohungei ilenimwa'e oto liutaa haahie. E aanga'inie, ");
INSERT INTO apb_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","na ko lae oto pe'ie i nume ingeie. Oto ko si haaraie mai maeni malahune na mo euhenue ingeie, na ko te'uri hunire, ‘Omu ke lae mai ilenimwa'e pe'ieu, aana nou lio oodoie oto sipu ineu nge e takalo ka'u.’ ");
INSERT INTO apb_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Oto no ko unue huni'omu uri kei urine no'one ta'au i Lengi. Aana ilenimwa'enga haahie nga ta'a-ta'a iini ni ooraha'aa ko oonisae oto mwaanie tolahana e tata'ala, kei peine lo'u liutaa aana ilenimwa'enga haahie siwe aawalai iinoni mwana siwe kire unue uri kire oodota'i na kire ka'a to'o aana ike nga mei ola aaela huni oonisae mwaanie.” ");
INSERT INTO apb_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Na a Jisas ko he'i unue lo'u uuri, “?Oto mala nga keni e to'o aana nga aawalai kawei ha'atahanga, na e ha'atekehie tangahulu'ana nga kawei iini, a keine kei ue? A keine kei ha'akaunie oto laite hunie ke sine hunie, na kei talaa oto nume ingeie, na kei heitale diana oto hunie, lai hule aana kei saronai lio oodoie. ");
INSERT INTO apb_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Na e saro lio oodoie oto, ko si haaraie mai maeni malahune na mo euhenue ingeie, na ko te'uri hunire, ‘Omu ke lae mai ilenimwa'e pe'ieu, aana nou lio oodoie oto mei to'oha ineu nge e takalo ka'u.’ ");
INSERT INTO apb_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","No ko unue huni'omu uri kei urine no'one ta'au i Lengi. Aana mo ensel a God kire kei ilenimwa'e haahie nga ta'a-ta'a iini ni ooraha'aa ko oonisae oto mwaanie tolahana e tata'ala.” ");
INSERT INTO apb_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Na a Jisas ko he'i ere uuri lo'u, “Ngaeta iinoni ni Jiu e to'o aana e ro mwela mwane. ");
INSERT INTO apb_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Oto mwane i puri ko te'uri hunie aamana, ‘Mama'a, o ke oopaa oto po'o ni iini nakue aana to'o-to'olamu.’ Oto aamadarue ko oopaa oto to'o-to'olana i matolana e ro kalena. ");
INSERT INTO apb_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","“E ka'a tewa ike lo'u mei puri, na mwane i puri ngeena ko ha'aholinge'inie oto to'o-to'olana, oto e hele aana mei to'oha ingeie, e si lae mwaanie hanue ingeie, na ko lae oto hunie ngaeta hanue ha'atau. Na i leune e si waiahea mo to'oha ingeie aana ta'ena nga ola aaela oto mola. ");
INSERT INTO apb_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Maholo e waiahea oto to'o-to'olana mango, nge iihi'ure aha'i e si toolea hanuena. Oto a mwa'une ko si si'oha'a oto hiito'o aana nga mei to'oha ha'ike oto aana. ");
INSERT INTO apb_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","“Oto a mwa'une e lae, nge ko si lai esu nana ngaeta mwane aana mo Aapoloa Aaopa aana hanuena. A mwaena e uusunge'inie saanaune hunie ke asuie asunge aaela aana e uusunge'inie hunie ke nii-nii ana amaa ni poo ingeie. ");
INSERT INTO apb_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Kele mweita'aa ko sere'inie taane mei esunge e tohungei eepune ngeena, ta'e ko esuie mola aana ko oolo mone oto aana hiolo, hule aana ko sasare ngau oto pe'ie mo poo, aena aana nga iini hunie ke nii ngeulaa ana ha'ike lo'u. ");
INSERT INTO apb_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","A mwa'une e talei tete'urine, lae-lae na ko lai lo'onga'i saie uri ingeie ni mola ko deu aaela. Oto ko si lo'onga'i uuri, ‘Ahutana mwala nge ko esu nana aamaku kire to'o ngaulaa tarau mola, na kire ko ngeu-ngeu ni pote. Ta'e ineu no ko si kara'i maesie mola hiolo. ");
INSERT INTO apb_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Ne kei ta'ela'i na ne kei ooli oto takoie aamaku. Ne kei te'uri hunie, Mama'a, nou ooraha'aa oto i na'ona God na oto i na'omu. ");
INSERT INTO apb_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Nou ka'a malisine ike uri o ke saieu lo'u aana a kalemu. Ta'e o ke da hunie ne ke ne'ie mola ngaeta koni-konihe i'oe.’” ");
INSERT INTO apb_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","“Oto e si ta'ela'i, ko eeliho'i takoie aamana. Na maholo a mwa'une ko lae-lae ue mai ta'au ha'atau, na aamana ko leesie oto ta'au ko lae mai. Oto aamana e leesie na e aamasie. E si huru, ko lai ako haahie, na ko nono'ie oto. ");
INSERT INTO apb_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Oto a mwa'une ko te'uri hunie aamana, ‘Mama'a, nou ooraha'aala oto i na'ona God na oto no'one i na'omu, na nou ka'a malisine ike lo'u uri o ke saieu aana a kalemu.’ ");
INSERT INTO apb_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Ta'e aamana e unue hunie mo koni-konihe ingeie uuri, ‘Omu ke toolea mai nga mo to'oni diana lau-leu, na omu ke ha'ato'onie aani. Omu ke ne'ie nga ringi i ri'i-ri'ine, na nga mo ho'ohaahi'ae i ae'aena. ");
INSERT INTO apb_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Oto omu ko lai toolea mai kele puluke pwi'e-pwi'ala ineu na omu ke horo'ie hunie kolu ke ngau ni ilenimwa'enga pe'ie a kaleku. ");
INSERT INTO apb_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Aana a kaleku e mae oto ka'u, ta'e ie e mauri oto lo'u. E ai'aa ka'u, ta'e kolu lio oodoie oto lo'u.’ Oto kire ko si ngeu ni ilenimwa'enga pe'ie a mwa'une. ");
INSERT INTO apb_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Na maholo walu ola ngeena ko reu-reu, mwane i na'o ingeie mola ue i me'esu. Maholo ko ooli oto mai kara'inie nume, na ko rongoa aawatai eu na maonga. ");
INSERT INTO apb_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Oto ko soie ngaeta koni-konihe ikire, na ko dolosi aana uuri, ‘?Nga taa ni ko reu ngeena?’ ");
INSERT INTO apb_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Oto koni-konihe ngeena ko te'uri hunie, ‘Aasimu e aaliho'i oto mai. Na aamamu e horo'ie kele puluke pwi'e-pwi'ala huni ngeu ni ilenimwa'enga pe'ie aana e hule sapemawa lo'u.’ ");
INSERT INTO apb_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Oto mwane i na'o ngeena ko saewasu, na e ka'a sare lae ike lo'u weu i nume na aana ngauhe. Aamana e iisitaa, oto ko lai haaraie uri ke lae mai nume. ");
INSERT INTO apb_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Ta'e e aalamie mola aamana uuri, ‘Lio ka'u, mo helisi hunge oto no ko talei eu'esu nemue, na nou ka'a haitohea walamu. Ta'e hule aana o sa'a sare niie ike nga mei ola hunieu, ma'alana uri nga kele kalei nanikot hunie ne ke ngau ke'u pe'ie mo malahuku. ");
INSERT INTO apb_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Ta'e a kalemu ie, e lai waiahea to'o-to'olamu mola aana mo repi, oto e aaliho'i mei, o ko si horo'ie oto kele puluke pwi'e-pwi'ala ana.’ ");
INSERT INTO apb_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Oto aamana ko aalamie uuri, ‘Kaleku, i'oe, o ii'o susule'i mola pe'ieu, na nga moi taa nou to'o aani, mo ola oto i'oe. ");
INSERT INTO apb_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Ta'e ie, e malisine oto kolu ke ngau ni ilenimwa'enga pe'ie aasimu. Aana e mae oto ka'u, ta'e ie e mauri oto lo'u. E ai'aa ka'u, na lio oodoilana e lae lo'u.’” ");
INSERT INTO apb_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Na a Jisas e te'uri lo'u hunie mo pwaarongoisuli ingeie, “Ngaeta mwane to'o-to'o e to'o aana nga na'ohai mwane au'esu huni lio i sulie mo esunge ingeie. Mwane to'o-to'o ngeena, e o'o'o na ko rongoa mwala ko unue uri na'ohai mwane ngeena ko waelie mola mo to'oha ingeie. ");
INSERT INTO apb_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Oto e soie mai na ko te'uri hunie, ‘?Nga taa ni no ko rongoa mwala ko unue aamu? O ke uusu samanga'inie ka'u mei nga moi taa o esui'i aana o lio-lio i sulie to'o-to'olaku, aena aana o sa'a lio i suli ike lo'u.’ ");
INSERT INTO apb_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","“Oto na'ohai mwane lio-lio i suli ngeena ko lo'onga'i mola i saena maraana uuri, ‘E lio mala poro paine ineu kei ha'amangoau oto mwaanie mei esunge ineu ni ngeena. ?Nga mei taa ni ne kei da? Ineu, nou ka'a adona oto elilana nga ineli, na no ko mamasa huni suke to'oha mwaanie mwala. ");
INSERT INTO apb_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","!Oo! Nou saie oto nga taa ne kei da hunie uri ma'alana no ko mango mwaanie asunge ineu, na mwala e sai soi konieu mola aana mo nume ikire.’ ");
INSERT INTO apb_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","“Oto e soie mai ahutana mwala nge kire ka'a su'u ola ue hunie poro paine ingeie. Na ko dolosi aana eetana nga mwane uuri, ‘?E nite mei ola o ka'a su'u'i ue hunie poro paine ineu?’ ");
INSERT INTO apb_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Oto a mwaena ko aalamie uuri, ‘Ne kei su'ue ue, e ro aawalai taramu peine aani rumu.’ Oto mwane lio-lio i suli ngeena ko te'uri hunie, ‘Kaoni i'oe uusulana e lae, na ingeie mola aaku ie. O ke ii'o ka'u i aano, na o ke ha'asihoa mola hunie ta'a-ta'a aawala.’” ");
INSERT INTO apb_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","“Oto ko dolosi lo'u aana ngaeta mwane uuri, ‘?Oto i'oe e nite o kei su'ue ue hunie poro paine ineu?’ Oto ko aalamie uuri, ‘Ne kei su'ue ue sinolai lu'e aani ngeulaa.’ Oto mwane lio-lio i suli ngeena ko te'uri hunie, ‘Kaoni i'oe, uusulana e lae, na ingeie mola aaku ie. O ke ii'o ka'u i aano na o ke ha'asihoa mola hunie walu tangalai lu'e.’ ");
INSERT INTO apb_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Oto lae-lae, a poro paine ngeena e tohungei pangata'inie sai-olanga mwane au'esu eero-eero ngeena aana e pweloa urine.” Na a Jisas ko he'i unue lo'u uuri, “Oto e to'ohuu oto, mwala ni welumalau kire tohungei saenanau i sulie ii'onga mai aano i leu pe'ie mo iinoni ni welumalau mala ikire. Sai-olanga ikire ngeena e tohungei peine lo'u liutaa aana sai-olanga mo iinoni aana raa-raa. ");
INSERT INTO apb_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Oto i'omu no'one, omu ke sai ola mala ikire. I'omu no'one omu ke ha'imalahune pe'ie mwala aana mo ola omu holi'i pe'ie mei to'oha omu pelie. Ta'e mwaanie omu pola mola pe'ie mei wala no ko unue ienini, aana maholo to'olamiu kei ai'aa mwaani'omu, nge mo malahumiu mai aano i leu kei deu aasaie tolakonilemiu aana mo nume huu. Ta'e omu ke saenanau aana ii'onga i laona raa-raa. ");
INSERT INTO apb_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Nga iini nge e sai kineta'inie nga mo ola ka'a hunge, ingeie ngeena e sai kineta'inie no'one mo ola hunge. Na nga iini nge e ka'a sai lio i suli diana aana mo ola ka'a hunge, ingeie ngeena e sa'a lio i suli diana aana ike no'one mo ola hunge. ");
INSERT INTO apb_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Oto mala uri omu ka'a sai lio i suli diana aana to'o-to'onga ni welumalau, nga iini e sa'a roro'a toli'aasie ike hunie omu ke lio i sulie to'o-to'onga to'ohuu ni Lengi. ");
INSERT INTO apb_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Na mala uri omu ka'a sai lio i suli diana aana to'o-to'olana ngaeta iinoni, nge niilana nga mo ola namue e sa'a lae ike huni'o. ");
INSERT INTO apb_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Nga ta'a-ta'a koni-konihe e sa'a roro'a asu susule'i ike nana nga ro poro paine hai aaopa'i. Aana kei manata diana mola hunie eetana nga iini, na kei ngiduupu hunie ruana nga iini, wa kei ha'ama'u mola aana ruana nga iini, na kei maaleledie eetana nga iini. Oto e tohungei aasa hunie omu kei ne'isae ha'ama'u aana a God na to'o-to'onga aana walumalau ie mala e ro poro paine i'omu.” ");
INSERT INTO apb_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Na maholo mo Parise kire rongoa walu ola ienini, oto kire ko si ha'amwasi mola aana a Jisas, i sulie ikire ngeena mwala e ne'isae paine aana to'oha oto liutaa. ");
INSERT INTO apb_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Oto a Jisas e te'uri hunire, “I'omu, omu ko tohungei sare da mola uri omu ke lio diana i maana mwala. Ta'e a God oto e sai diana aana nga taa i laona saemiu. Aana mo ola nge mo iinoni kire ne'isae paine aani kire lio aaela mola i maana God.” ");
INSERT INTO apb_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Na a Jisas e he'i te'uri lo'u, “Hola'ina'o mo Ha'atolanga a Mosis na walana mo propet kire haata'inie tala hunie mwala. Ta'e uure aana a Jon Loto Maa'i e lae mai, oto taroha'inilana Tataroha Diana i sulie Aalahanga a God ko si lae. Na mo pulitaa ni iinoni hunge ko si meni eri'apasie silinge mai i laona aalahanga ngeena. ");
INSERT INTO apb_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","I Lengi na i aano e sai suu mola, ta'e nga ta'a-ta'a kele nganga'ai ola aana mo Ha'atolanga a Mosis e sa'a suu oto oo'oo. ");
INSERT INTO apb_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Oto mala nga iini ko sikaa hu'e ingeie na ko he'i to'o aana lo'u ngaeta keni aaopa, iinoni ngeena ko mesi oto. Na mwane ko to'o aana keni nge poro ingeie e sikaa ka'u, a mwane ngeena ko mesi oto no'one.” ");
INSERT INTO apb_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Oto a Jisas ko te'uri lo'u, “Ngaeta mwane to'o-to'o e o'o'o na e ii'o ni ilenimwa'enga pe'i ngeu-ngeu ni pote mola i suli hei dinge, na e to'o-to'oni eeni to'oni lio manikulu'e hali'ite. ");
INSERT INTO apb_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Na ngaeta iinoni si'oha'a no'one i leune, satana a Lasaros, na sapena e honu eeni osa. A Lasaros ko talei o'o'o mola i aena maa aana nume mwane to'o-to'o ngeena suli maholo. ");
INSERT INTO apb_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Aana e sasare ngaue mo eehuhu'ei ngeulaa nge ko tee-teke mwaanie taetahe mwane to'o-to'o ngeena. Na ahutana mo usu kire sai lae mai mealie mo osa i sapena. ");
INSERT INTO apb_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“A Lasaros e o'o'o, na ko mae. Oto mo ensel kire toolea na kire ko lai ha'a-ii'osie oto pe'ie a Ebraham. Mwane to'o-to'o ngeena e mae no'one na kire haitoli oto aana. ");
INSERT INTO apb_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Ta'e uusunge'inilana e lae aana leu mo iini e mae na kire ii'o oto mola pe'ie sapesalunge. Mwane to'o-to'o ngeena e leesie a Ebraham wau ha'atau na a Lasaros oto pe'ie. ");
INSERT INTO apb_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","“Oto ko soi weu hunie a Ebraham na ko te'uri, ‘Mama'a Ebraham, o ke aamasieu, na o ke uusunge'inie mai a Lasaros hunie ke toonga'inie mola ngongo'ana ri'i-ri'ine i laona mei wei huni ha'awawaie meaku. Aana ko tohungei rako aaela aaku oto hiito'o i laona dunge ni ha'amotaahinge ie.’ ");
INSERT INTO apb_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“Ta'e a Ebraham e te'uri mola, ‘Kaleku, o ke aamasito'o aana maholo o o'o'o mauri, o to'o aana oto dianaha'ana ahutana mo ola, ta'e a Lasaros e lae pe'i si'oha'a oto hiito'o. Oto ie, a Lasaros e ii'o ni ilenimwa'enga na i'oe ko motaahi'o. Oto e aasa hunie ke pe'i'o. ");
INSERT INTO apb_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Na ngaeta leu lo'u, aena aana kalinge paine nge e liu honosikolu ie, nga iini sa'a pe'i'o ike. E aasa hunie nga iini ke lae wau huni pe'i'o, na e aasa hunie nga iini ke uure wau huni lae mai.’ ");
INSERT INTO apb_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“Oto mwane to'o-to'o ngeena ko te'uri, ‘Ko urine oto mama'a ineu Ebraham, no ko eitanai'o, o ke uusunge'inie a Lasaros hai nume aamaku i welumalau. ");
INSERT INTO apb_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Aana nou to'o aana e lime aasiku hao, na e diana uri a Lasaros ke ha'apasulire mwaanie kire lae lo'u poi aana leu ni ha'amotaahinge ie.’ ");
INSERT INTO apb_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","“Ta'e a Ebraham e te'uri, ‘Mo eesimu kire to'o aana oto mo Ha'atolanga a Mosis na mo Uusu-uusu Maa'i mo propet hao huni saai'i. Toli'aasie kire ke saai'i maraada.’ ");
INSERT INTO apb_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","“Oto mwane to'o-to'o ngeena ko te'uri, ‘Ha'ike mama'a Ebraham. Mala uri nga iini aana mwala e mae oto, ko meuri eeliho'i lo'u na ko lae oto i saada, ha'alaa kire ko hiiwalaimoli, na kire ko oolisie saeda na tolahada.’ ");
INSERT INTO apb_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","“Ta'e a Ebraham e te'uri hunie, ‘Mala uri mo eesimu ka'a sai hiiwalaimoli oto aana mo Ha'atolanga a Mosis na mo Uusu-uusu Maa'i mo propet, ma'alana nga iini ko meuri eeliho'i lo'u mwaanie maenga, na kire sa'a hiiwalaimoli ike lo'u eeni.’” ");
INSERT INTO apb_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Oto a Jisas ko te'uri lo'u hunie mo pwaarongoisuli ingeie, “Mo ola huni ha'atataroa mwala hunie ooraha'aa kei reu oto. Ta'e aama-aamasilana iini nge kei esuie mo olana hunie kire ke rau. ");
INSERT INTO apb_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Oto mala nga iini ko ha'atataroa nga kele iini aana mo iini ko hiiwalaimoli eeku ienini, e lae otoi diana hunie iini urine pwarolana nga hau peine ke lae mola i luana, oto kulu-aasilana ke lae mola i laona aasi. ");
INSERT INTO apb_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Oto omu ke lio talamiu aana ta'e-ta'ena nga ola omu ko eu'esuie. Mala uri aasimu ko ooraha'aa, ere aana, na o ke unue hunie uri ko deu aaela. Na mala ko oonisae, o ke sae'aasi oto hunie. ");
INSERT INTO apb_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Mala uri ko deu hu'isi'o ha'ahiu aana ta'a-ta'a hai dinge, na suli maholo ko lae mai seemu huni unue uri e oonisae oto, nge o ke sae'aasi oto hunie.” ");
INSERT INTO apb_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Mo hurula'aa kire te'uri hunie, “O ke sapeie hiiwalaimolinge i'emi hunie ke paine.” ");
INSERT INTO apb_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Oto a Aalaha ko aalamire uuri, “Ma'alana omu ke to'o aana mola nga hiiwalaimolinge mwai-mwei mala nga kele litei ola, na omu kei unue hunie ai weune uuri, ‘O ke aalangu oto maraamu aana imi-imimu, na o ke lai hesi'o maraamu wau i eesi.’ Na aine kei tola i suli'omu oto.” ");
INSERT INTO apb_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Na a Jisas e te'uri lo'u, “Maholo iinoni eu'esu ko ooli oto i nume mwaanie asunge i hohola wa lio i sulilana mo sipu, e sa'a lae mola mai ii'o i aano hunie ke ngau. ");
INSERT INTO apb_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Ta'e poro paine ingeie kei unue hunie uuri, ‘O ke dau aakau ka'u aana mo ngeulaa akue. Mango o ke si oolisi na o ke rareta'inieu. Ne kei ngeu na ne kei inu mango, nge i'oe o ke si ngeu lo'u.’ ");
INSERT INTO apb_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Na koni-konihe ngeena e sa'a lo'onga'inie ike uri aalaha ingeie kei paalahea haahie walu ola e asui'i. ");
INSERT INTO apb_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Oto e urine no'one aana i'omu. Maholo omu ko esuie mo ola haarailemiu e lae huni esui'i, omu ke unue mola uuri, ‘Ikie mo koni-konihe mola ni ngeena, na e ka'a adona ike nga iini ke ha'apaina'akie, aena aana kie ko esuie mola mo ola malisine oto kie ke asui'i.’” ");
INSERT INTO apb_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Maholo a Jisas e lae hunie i Jerusalem, e lai liu i sulie taitelihe i matolana i Samaria na i Kalili. ");
INSERT INTO apb_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Oto maholo e lae mai hule aana ngaeta kele huilume, na ko oodoie aawalai mwane. Mo mwane ngeena kire to'o aana maelaa ni osa. Oto kire uure mola mai ha'atau, ");
INSERT INTO apb_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","na kire ko si soi hunie a Jisas uuri, “!Jisas! !Aalaha! O ke aamasi'emeelu.” ");
INSERT INTO apb_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Na maholo a Jisas e leesire, oto ko te'uri hunire, “Omu ke lae ka'u i saana mo pris hunie kire ke hola'i leesi'omu mala Ha'atolanga a Mosis e unue.” Maholo kire lae ta'au mwaanie a Jisas na ikire ue i sulie tala, sapeda e tolana mola oto. ");
INSERT INTO apb_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Maholo ngaeta iini aada e leesie uri sapena e mola oto, ko si eeliho'i mei i saana a Jisas, na ko soi ha'amanikulu'aa God. ");
INSERT INTO apb_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Oto e lai pouruuru i aano i na'ona a Jisas, na ko paalahea. Na a mwane ngeena, ingeie mwane ni Samaria. ");
INSERT INTO apb_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Oto a Jisas ko dolosi aana mwala e ruru ngeena, ko te'uri, “Aawalai mwane ka'u ha'a-uurilada e lae. ?Ngaeta siwe iini ka'u i tei? ");
INSERT INTO apb_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","?E ue ka'u mwane nge ingeie nga Jiu ha'ike ie mola ko ili lae mai paalahea God?” ");
INSERT INTO apb_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Oto a Jisas ko si te'uri hunie a mwaena, “Ta'ela'i na o ke lae, hiiwalaimolinge i'oe e ha'a-uuri'o oto.” ");
INSERT INTO apb_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Ngaeta mo Parise kire dolosi aana a Jisas uuri, “?Maholo uri taa ni Aalahanga a God kei lae mai?” Oto a Jisas e aalamire ko te'uri, “Aalahanga a God ko lae taane mai, ta'e e ka'a lae ike mai aana tala nge omu sai leesie aana maamiu. ");
INSERT INTO apb_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Na nga iini e sa'a te'uri ike, ‘!Lio ka'u, Aalahanga a God oto ie!’ wa, ‘!Ingeie oto ngeena!’ !Ha'ike! Aana Aalahanga a God ingeie oto i lalo aana mo iinoni.” ");
INSERT INTO apb_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Oto ko si te'uri hunie mo pwaarongoisuli ingeie, “Maholo hunie kei lae taane mai, na i'omu, omu kei tohungei sare leesie no'one pongine a Kale Ni Iinoni, ta'e omu sa'a leesie ike. ");
INSERT INTO apb_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Nga mo iini kei unue huni'omu uuri, ‘!Lio ka'u, ingeie oto ngeena!’ wa ‘!Lio ka'u, ingeie oto ie!’ Ta'e su'uri aapwasu aada na su'uri lae lo'u huni leesie nga taa kire ko unue. ");
INSERT INTO apb_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Aana maholo ineu a Kale Ni Iinoni ne kei ooli mei, kei urihana wa'ariri ko eeso paine i laona salo. Oto ko raa hailiu weu na mai i laona walumalau. ");
INSERT INTO apb_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Ta'e i na'ona maholo ngeena kei hule, mwala aana maholo ienini kei maaleledieu ke'u, na ne kei haro sapesalu hiito'o ka'u. ");
INSERT INTO apb_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","“Na nga taa kei reu aana maholo ineu a Kale Ni Iinoni ne kei ooli mei, kei urihana no'one nga taa e rau aana pongine a Noa. ");
INSERT INTO apb_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Mo dinge i na'ona lue-lue e tola, mwala ka'a saie ike, oto kire ngau-ngeu na kire inu-inu mola. Kire totola keni na kire to'o-to'o poro mola lai hule aana hai dinge a Noa e ta'e i laona haka paine. Oto lue-lue e hane haahire, na ahutana mwala kire mani mae mango. ");
INSERT INTO apb_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","“Na kei urihana no'one nga taa e rau aana pongine a Lot. Mwala kire ngau-ngeu na kire inu-inu mola. Kire holi-holi na kire ha'a-ha'aholi mola. Kire hai-hesi na kire tou-tohu nume mola. ");
INSERT INTO apb_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Kire au'esuie mola mo olana, lai hule aana hai dinge nge a Lot e lae mwaanie i Sodom. Oto dunge pe'ie mo heu eeso-eeso kire ooho toli mei uure i Lengi, na e suuhe'inire mango. ");
INSERT INTO apb_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","“Aitana kei urine no'one aana hai dinge nge ineu a Kale Ni Iinoni ne kei ooli mei. ");
INSERT INTO apb_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Aana hai dingena, mala nga iini ko ii'o ta'au i koluhana nume ingeie, ke tahi oto na ke su'uri waelie lo'u nga maholo huni lai toolea nga mo ola ingeie hai nume. Na mala nga iini ko eu'esu i hohola, ke tahi oto na ke su'uri waelie lo'u nga maholo huni lai toolea nga mo to'oni ingeie mai nume. ");
INSERT INTO apb_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Omu ke aama-aamasito'o aana nga taa e rau aana hu'e a Lot. ");
INSERT INTO apb_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Aana nga iini ko sare kineta'inie mauriha'ana, nge kei deu tekela'inie oto tohungana mauriha'ana. Ta'e nga iini ko deu tekela'inie mauriha'ana i tehula'aku, nge kei hele aana maurihe huu. ");
INSERT INTO apb_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","No ko unue oto huni'omu uri aana maholo nge ne kei ooli lo'u mei ngeena, nga ro iinoni e ma'a-ma'ahu i lengine nga ta'a-ta'a tahe. A God kei toolea ta'a-ta'a iini, na ngaeta iini kei oore mola. ");
INSERT INTO apb_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Na nga ro keni kei meni eu'esu tararuru huni uusu hui. Ta'a-ta'a iini no'one mola kire kei toolea. Ngaeta iini kei oore mola.” ");
INSERT INTO apb_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Oto mo pwaarongoisuli ko dolosi aana a Jisas uuri, “?Uri mo ola ngeena kei reu i tei, Poro paine?” Oto a Jisas ko aalamire uuri, “Oolinge mai ineu e sa'a mumuni ike, ta'e kei urihana no'one waieu tola manu. Aana mwala kei leesie mo keule, kire kei meni saie oto uri waieu oto i leune.” ");
INSERT INTO apb_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Oto a Jisas e ere ni aalahuunge huni haata'inie aana mo pwaarongoisuli ingeie uri kire ke aarenga'i tarau mwaanie kire aakohe na mwaanie kire mou-mou mwaanie. ");
INSERT INTO apb_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Oto ko te'uri, “Nga mwane lei-lei e o'o'o aana huilume, na a mwane ngeena e ka'a sai ha'ama'u ike aana a God wa ke ma'ute'inie mo iinoni. ");
INSERT INTO apb_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Ngaeta mei nao keni e o'o'o no'one aana huilume ngeena, na ko lae mola mai taraure'i i saana mwane lei-lei ngeena, na ko unu-unue uuri, ‘O ke ha'a-oodohie ka'u hunieu mei roro'anga i matolamere'i maelonga ineu.’ ");
INSERT INTO apb_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Ta'e ko tewa oto na mwane lei-lei ngeena ka'a aapwa-aapwasu ike aana. Ta'e lae-lae, aana ko te'urine mola i suli maholo, oto mwane lei-lei ngeena e o'o'o na ko lo'onga'i mola maraana uuri, ‘Ma'alana uri nou ka'a ha'ama'u aana a God wa ne ke ma'ute'inie mo iinoni, ");
INSERT INTO apb_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","ta'e ne kei ha'a-oodohie oto mei ne'isaenga a keni ie hunie. Aena aana uri nou ka'a ha'a-oodohie hunie, kei talei aeolieu mola mai na mwaanie e ha'apweueu mola.’” ");
INSERT INTO apb_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Oto a Jisas ko he'i te'uri lo'u, “Omu rongoa oto nga taa nge mwane lei-lei aaela ngeena e unue. ");
INSERT INTO apb_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","?Uri omu lo'onga'inie a God e sa'a ha'a-oodohie ike nga mei ola urine hunie mo iini kire hiiwalaimoli aana, aena aana kire ko ngarasie i suli rodo na aatowaa huni pe'inge? ?Na e ue? ?Uri omu lo'onga'inie e sa'a pe'ire ike lau-leu? ");
INSERT INTO apb_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","No ko unue oto huni'omu uri kei pe'ire lau-leu taane. ?Ta'e e ue aana maholo ineu a Kale Ni Iinoni ne kei ooli lo'u mei? ?Nou sai lio oodoie taane mo iinoni kire hiiwalaimoli eeku wa ha'ike?” ");
INSERT INTO apb_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Oto a Jisas ko he'i unue lo'u ngaeta mei aalahuunge i sulie mwala nge kire lo'onga'inie uri ikire oto kire oodota'i, na kire ko lio toli mola aana ahutana mwala. ");
INSERT INTO apb_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","A Jisas e unue uuri, “Ngaeta hai dinge e ro mwane e o'o'o, oto kirerue ko hanetaa ta'au i Nume Maa'i Peine huni aarea a God. Nga iini Parise, na ruana nga iini mwane susulu to'oha hunie aalahanga ni Rom. ");
INSERT INTO apb_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Oto Parise ngeena e uure wau maraana mwaanie mwane susulu to'oha, ko si aarenga'i i sulie maraana, na ko te'uri, ‘God, no ko paalahe'o aana nou ka'a aaela ike mala ngaeta mwala. Nou ka'a urihana ike mwala nge kire sai peli, kire sai leu-leu ola, na kire ko mei-mesi. No ko paalahe'o aana nou ka'a urihana ike mwane susulu to'oha waune. ");
INSERT INTO apb_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","No ko oolongau ha'arue suli wiki, na no ko nii-niie tangahulu'ana tari-olanga ineu huni'o.’ ");
INSERT INTO apb_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“Ta'e mwane susulu to'oha ngeena, e uure mola mai ha'atau, hule aana e ka'a sare lio lo'u i lengi. Ko kukumu mola i mamangona aani saehuunge, na ko unue uuri, ‘God, o ke aamasieu, ineu iinoni ni ooraha'aa.’” ");
INSERT INTO apb_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Oto a Jisas ko si unue uuri, “No ko unue oto huni'omu uri a mwane susulu to'oha ngeena e ooli hai nume ingeie, na a God e ha'a-oodohie oto. Ta'e Parise ngeena ha'ike. Aana ta'ena nga iini ko ha'apaina'aa, nge ha'amwai-mwei'alana kei lae. Ta'e iini ko ha'amwai-mwei'aa, nge ha'apaina'alana kei lae.” ");
INSERT INTO apb_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Ngaeta mwala kire toolea mai mo kele wee-wee ikire i saana a Jisas hunie ke hele aada huni ha'adiana'ara. Maholo mo pwaarongoisuli kire leesie urine, oto kire ko ere aada. ");
INSERT INTO apb_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Ta'e a Jisas e soie mai mo kele mwela i saana, na ko unue hunie mo pwaarongoisuli ingeie uuri, “Omu ke toli'aasie mo mwela hunie kire ke lae mai seeku, na omu ke su'uri uure honosire. Aena aana mo iini kire urihana mo mwela ngeena ha'alaa kire ko sili i laona Aalahanga a God. ");
INSERT INTO apb_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","To'ohuu no ko unue huni'omu uri mala nga iini e ka'a ha'amwai-mwei'aa mala mo mwela mwai-mwei nge e sa'a roro'a sili ike i laona Aalahanga a God.” ");
INSERT INTO apb_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Oto ngaeta na'ohai mwane aana mo Jiu, e dolosi aana a Jisas uuri, “Ha'a-uusuli diana. ?Nga mei taa ni ne kei da ka'u hunie ne ke si hele aana maurihe huu?” ");
INSERT INTO apb_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Oto a Jisas ko aalamie uuri, “?E ue o ko unue uri ineu nou diana? Nga ta'a-ta'a iini ka'a diana ike ta'e a God hali'ite. ");
INSERT INTO apb_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Ta'e aana dolosinge i'oe, o saie ka'u oto mo Ha'atolanga a Mosis. Mwaanie o talei horo-horo, na mwaanie o mai-mesi, na mwaanie o peli-peli, na mwaanie o pwelu wala eero-eero, na o ke ha'ama'u aana aamamu na nikemu.” ");
INSERT INTO apb_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Oto na'ohai mwane ngeena ko aalamie a Jisas uuri, “Nou tola i sulie walu ola ngeena uure oto i mwei-mweiha'aku.” ");
INSERT INTO apb_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Maholo a Jisas e rongo urine, ko si te'uri hunie a mwaena, “Ta'a-ta'a mei ola ni mola ue o saeto'o aana lo'u huni esuie. O ke ha'aholinge'inie to'o-to'olamu, na o ke niie mo to'oha aani nana kira maitale. Aana ko urine nge o ke si to'o-to'o lo'u aana mo ola diana i Lengi. Mango urine o ke si lae mai lulu i sulieu.” ");
INSERT INTO apb_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Ta'e maholo a mwaena e rongo urine, ko si saehuu oto hiito'o aena aana e tohungei to'o-to'o oto liutaa. ");
INSERT INTO apb_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Maholo a Jisas e leesie a mwaena ko saehuu oto hiito'o, ko si te'uri, “Kei tohungei aasa oto hiito'o hunie mwala e to'o-to'o huni sili i laona Aalahanga a God. ");
INSERT INTO apb_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","E mwada'u mola hunie uri nga kamel kei sili i sulie kele waa-waata aana nile tau-teuri, liutaa aana iinoni to'o-to'o ke sili i laona Aalahanga a God.” ");
INSERT INTO apb_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Oto maholo mwala e rongoa a Jisas e ere urine, kire ko si dolosi aana uuri, “?Oto a tei ka'u ke si helesie maurihe huu?” ");
INSERT INTO apb_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","A Jisas e aalamire uuri, “Nga taa nge e aasa hunie iinoni, e tohungei mwada'u mola hunie a God.” ");
INSERT INTO apb_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Oto a Pita ko dolosi aana a Jisas uuri, “?E ue aana i'emeelu? Melu toli'aasie oto ahutana to'o-to'olameelu mango huni lulu i suli'o.” ");
INSERT INTO apb_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Oto a Jisas e te'uri hunire, “No ko unue oto huni'omu uri nga iini nge ko toli'aasie nume ingeie, wa hu'e ingeie, wa mo eesine, wa aamana, wa nikana, wa mo kalena i tehula'ana Aalahanga a God, ");
INSERT INTO apb_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","kei hele liutaa aana maurihe ienini, na i purine maenga kei ii'o huu oto pe'ie a God aana maurihe huu.” ");
INSERT INTO apb_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Oto a Jisas e toolea aawalai pwaarongoisuli mwana rue, na kire ko lae maraada, ko si unue hunire uuri, “!Omu ke rongo ka'u! Kolu ko lae oto hunie i Jerusalem eena, leu nge ahutana walu ola mo propet kire uusu-uusu i sulieu a Kale Ni Iinoni kei oa aana. ");
INSERT INTO apb_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Na kire kei pweloau hunie mo Aapoloa Aaopa. Oto mwala ngeena kei ha'amwasi eeku, na kire kei repusieu na kire kei ngisuhieu. ");
INSERT INTO apb_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Kire kei repusieu na kire kei horo maesieu oto. Ta'e aana oolune nga hai dinge, ne kei ta'ela'i eeliho'i lo'u mwaanie maenga.” ");
INSERT INTO apb_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Ta'e mo pwaarongoisuli kire ka'a rongo saie ike nga mei ola aana mo olana. Lo'onga'inge aani e ii'o mumuni mwaanire, oto kire ka'a saie ike nga taa a Jisas ko ere i sulie. ");
INSERT INTO apb_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Maholo a Jisas ko lae mai kara'inie huilume i Jeriko, na ngaeta mwane e ulu e ii'o i reune tala i leune, ko susuke to'oha. ");
INSERT INTO apb_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Mwane e ulu ngeena e rongoa mwala ko liu i sulie tala, oto ko dolosi aada uuri, “?Nga taa ni ko reu ngeena?” ");
INSERT INTO apb_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Oto kire ko unue hunie uuri, “A Jisas, iini ni Nasaret, ni ko liu ie.” ");
INSERT INTO apb_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Oto a mwaena ko uulo oto paine, na ko te'uri, “!Jisas! !Kalena Deved Inemauri! !O ke aamasieu!” ");
INSERT INTO apb_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Mwala e na'o aana laeha ngeena kire ko ere aana uri hunie ke rohu. Ta'e ko si uulo paine mola liutaa mwaanie hola'ina'o uuri, “!Kalena Deved Inemauri! !O ke aamasieu!” ");
INSERT INTO apb_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Oto a Jisas e uure hahuroto, na ko unue hunire uri kire ke toolea mai mwane e ulu ngeena i saana. Maholo ko lae oto mai kara'inie, a Jisas ko si dolosi aana uuri, ");
INSERT INTO apb_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“?Nga taa ni o saeto'o aana ne ke asuie huni'o?” Oto mwane e ulu ngeena ko aalamie a Jisas uuri, “Aalaha ineu, saeku hunie ne ke lio-lio lo'u.” ");
INSERT INTO apb_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Oto a Jisas ko te'uri hunie, “!O ke lio-lio oto! Hiiwalaimolinge i'oe e ha'a-uuri'o oto.” ");
INSERT INTO apb_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Oto maana a mwaena ko tolana lio-lio lo'u, na ko lulu i sulie oto a Jisas pe'i paalahelana a God. Na ahutana mwala kire leesie urine, kire ko si meni paalahea God no'one. ");
INSERT INTO apb_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Oto a Jisas e lai liu i laona huilume i Jeriko, ");
INSERT INTO apb_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","na ngaeta mwane satana a Sakias i leune. Ingeie nga mwane to'o-to'o aena aana ingeie nga na'ohai mwane aana mo iini ko susulu to'oha hunie aalahanga ni Rom. ");
INSERT INTO apb_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","E sasare leesie a Jisas uri ingeie a tei, ta'e e ka'a sai leesie ike, aena aana mwala e hunge na ingeie e tohungei o'oru'e. ");
INSERT INTO apb_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Oto a Sakias e huru ta'au i na'ona mwala aana leu nge e saie uri a Jisas kei liu aana, e si hane i lengine ai hunie ke leesie. ");
INSERT INTO apb_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Maholo a Jisas e liu mei aana leune, e lio ta'au i lengi na ko leesie a Sakias i lengine ai. Oto ko te'uri hunie, “Sakias, o ke siho mai aano lau-leu, aana si'iri ne kei ii'o pe'i'o i nume i'oe.” ");
INSERT INTO apb_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Oto a Sakias e tolana siho oto i aano aana maholona, na e takuhie oto pe'i ilenimwa'enga. ");
INSERT INTO apb_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Na maholo mwala e leesie urine, kire ko si meni upwesie a Jisas na kire ko te'uri, “A mwane ngeena ko lae mola huni ngeu pe'ie iinoni ooraha'aala.” ");
INSERT INTO apb_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Ta'e a Sakias e ta'ela'i, oto ko te'uri hunie poro painena, “!Aalaha ineu! Ne kei niie ngaeta po'o ni leu aana to'o-to'olaku nana mo iinoni meitale. Na mo iini nge nou pwelora aana nou tola to'oha mola mwaakule mwaanire, ne kei nii eeliho'i lo'u aana mo to'oha ikire, na ne kei nii ha'ahai liutaa aana lo'u nga taa nou toolea mwaanire.” ");
INSERT INTO apb_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Oto a Jisas ko te'uri hunie, “Si'iri a God ko ha'a-uurie mwala aana nume i'oe ienini, aena aana i'oe, o si hute haalu aana komu a Ebraham. ");
INSERT INTO apb_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Ineu a Kale Ni Iinoni, nou lae mai huni lo'ohie mwala e takalo ka'u, na huni ha'a-uurire.” ");
INSERT INTO apb_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Oto maholo mwala ko meni pwaa-pwaarongo ue i sulie a Jisas, oto ko ladoa lo'u nga aalahuunge hunire, aana e kara'inie oto i Jerusalem, na mwala hunge ko lo'onga'inie uri Aalahanga a God kei tala'ae oto molana. ");
INSERT INTO apb_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Ta'e a Jisas e saie mone uri kire ko lo'o-lo'onga'i urine, oto ko si ladoa mei aalahuunge ie nada, “Ngaeta na'ohai mwane e o'o'o, oto ko lae aani henue ha'atau hunie kire ke ha'a-aalahaa haahie mwala aana hanue ingeie. ");
INSERT INTO apb_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Oto i na'ona a mwaena e lae, e soie mai aawalai mwane au'esu ingeie, na ko ha'a-adora aani mwe'ii to'oha na ko te'uri hunire, ‘Omu ke asu aana mo to'oha ngeena, na omu ke tarie lo'u nga mo iini pe'i'i aana maholo no ko lae mwaani'omu.’ ");
INSERT INTO apb_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","“Oto e lae oto, ta'e mwala aana hanue ingeie kire ka'a saeto'o aana ike. Oto kire uusunge'inie nga mo iini i sulie pe'ie mei wala uuri, ‘Melu ka'a saeto'o aana ike a mwane ie ke aalaha haahi'emeelu.’ ");
INSERT INTO apb_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Ta'e a mwaena e ne'i aalaha oto haahie hanue ingeie. Oto maholo e aaliho'i mei, e soie mo mwane au'esu ingeie nge e nii to'oha hunire, hunie ke leesie uri nga mei to'oha uri taa kire tarie aana kire asu i purine. ");
INSERT INTO apb_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","“Oto eetana nga mwane au'esu e lae mai saana, ko te'uri, ‘Aalaha ineu, nou terie aawalai mei to'oha lo'u haahie leu nge o niie hunieu.’ ");
INSERT INTO apb_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Oto aalaha ngeena ko te'uri hunie, ‘!E diana! I'oe oto mwane au'esu diana. Nou lio saie uri o sai kineta'inie mo ola mwai-mwei. Ngeena, ne kei ne'i'o o ke aalaha oto haahie ngaeta aawalai huilume ineu.’ ");
INSERT INTO apb_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","“Ruana nga mwane au'esu e lae lo'u mei na ko te'uri, ‘Aalaha ineu, nou terie e lime leu lo'u pe'ie leu nge o niie hunieu.’ ");
INSERT INTO apb_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Oto aalaha ingeie ko te'uri hunie, ‘Urine, i'oe o kei aalaha haahie e lime huilume ineu.’ ");
INSERT INTO apb_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Na ngaeta mwane au'esu e lae mai, oto ko te'uri, ‘!Aalaha ineu, leesie ka'u! Mei to'oha i'oe mola ie. Nou ulo haahie mola aana mei sala, oto nou mumunie mola. ");
INSERT INTO apb_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","!Nou kele ma'ute'ini'o mwae! Aena aana i'oe, o lae otoi raramaa hiito'o, na hule aana o sai toolea mola mei to'oha o ka'a tarie ike maraamu, na i'oe o ko so'okonie mo ngeulaa mwala aaopa e hasi'i no'one.’ ");
INSERT INTO apb_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Oto aalaha ingeie ko te'uri hunie, ‘I'oe oto mwane au'esu aaela. Ngeena, ne kei lei'o oto i sulie walamu maraamu. O unue ka'u oto uri nou lae otoi raramaa hiito'o aani tolalana mola mei to'oha nge nou ka'a tarie maraaku, na uri no ko eli-elie mola mo ngeulaa nou ka'a hasi'i ike. ");
INSERT INTO apb_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","?Nge ko urine, na e ue o ka'a ne'ie mola mei to'oha ineu i laona nume ni to'oha hunie ne ke tarie nga kele leu lo'u pe'ie?’ ");
INSERT INTO apb_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","“Oto aalaha ngeena ko unue hunie mwala kire uure-uure kara'inie uuri, ‘Omu ke toolea mei to'oha ngeena mwaanie, na omu ke niie nana iini nge e tarie aawalai mei to'oha.’ ");
INSERT INTO apb_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Oto kire ko te'uri hunie aalaha ngeena, ‘Poro paine, ta'e ingeie e to'o aana oto aawalai mei to'oha.’ ");
INSERT INTO apb_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","“Oto aalaha ngeena ko aalamire uuri, ‘No ko unue oto huni'omu, nga iini nge ko esu diana aana nga taa e to'o aana oto, nge aalaha ingeie kei nii hiito'o lo'u hunie. Ta'e nga iini nge e ka'a asu diana ike aana nga taa e to'o aana oto, ma'alana nga kele mei ola mola mwai-mwei e to'o aana, na aalaha ingeie kei ta'aasie oto mwaanie. ");
INSERT INTO apb_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Oto, hunie mo maelonga ineu nge kire sere'inie uri ne ke aalaha haahire, no ko unue huni'omu, omu ke toolera mai i leu, na omu ke horo'ire mango oto i na'oku.’” ");
INSERT INTO apb_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Oto i purine a Jisas e ere urine mango, e si lae lo'u hunie i Jerusalem. ");
INSERT INTO apb_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Na e lae mai kara'inie i Betfeis na i Betani, e ro huilume kara'inie uuwo nge kire haara'inie Uuwo Ni Ei Olif. Oto e uusunge'inie e ro pwaarongoisuli ingeie uri kirerue ke lae oto i na'o, na ko unue hunirerue uuri, ");
INSERT INTO apb_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","“More ke lae i na'o aana huilume nge kolu ko leesie ta'aune. Na maholo more kei hule ta'au, more kei leesie kele dongki haalu kire pwasue ta'au i leune. Dongki ngeena, nga iinoni ka'a ta'e ike ue aana. Oto more ko luhesie, more ko toolea mai hunieu. ");
INSERT INTO apb_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Mala uri nga iini ko dolosi aamore'i uuri, ‘?More ko luhesie huni taa?’ oto more ke unue oodoie uuri, ‘A poro paine e saeto'o aana.’” ");
INSERT INTO apb_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Oto e ro pwaarongoisuli ko lae oto i na'o. Kirerue lae ta'au na kirerue ko lio oodoie oto mo ola nge a Jisas e unu'i hunirerue. ");
INSERT INTO apb_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Maholo kirerue ko luluhesie dongki haalu ngeena, na mo mwane e to'o aana ko lae oto mai. Oto kire ko dolosi aana e ro pwaarongoisuli uuri, “!Ei! ?More ko luhesie dongki ngeena huni taa?” ");
INSERT INTO apb_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Oto kirerue ko aalamie uuri, “A poro paine e saeto'o aana.” ");
INSERT INTO apb_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Oto kirerue si toolea dongki ngeena hunie a Jisas, na kire ko aasie mo to'oni ikire ikolune dongki, na kire ko pe'ie oto a Jisas huni ta'e i lengine. ");
INSERT INTO apb_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Na maholo a Jisas ko lae hunie i Jerusalem aana dongki ngeena, mwala ko lae pe'i eepasie tala aana mo to'oni ikire. ");
INSERT INTO apb_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Oto maholo a Jisas ko nanauhie i Jerusalem, aana leu nge tala e sihotoli mei mwaanie Uuwo Ni Ei Olif ngeena, ahutana mwala ko lae pe'ie kire ko meni ilenimwa'e pe'i paalahelana God haahie mo hu'i-hu'ite kire leesie a Jisas e asui'i. ");
INSERT INTO apb_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Na kire ko te'uri, “!God ke ha'adiana'aa inemauri ko lae mai nunuha'ana satana Aalaha! !Hanuelamanga i Lengi na manikulu'anga hunie a God!” ");
INSERT INTO apb_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Ngaeta mo Parise kire ii'o no'one aana maholona, kire ko te'uri hunie a Jisas, “Ha'a-uusuli, o ke unue mo pwaarongoisuli i'oe kire ke su'uri unue mo ola ngeena.” ");
INSERT INTO apb_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Ta'e a Jisas e aalamire mola uuri, “No ko unue oto huni'omu, mala uri mo pwaarongoisuli ineu kire ka'a unue mo olana, nge mo heu kei mawa pe'i paalahelana God no'one urine.” ");
INSERT INTO apb_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Na maholo a Jisas e lae lo'u mei kara'inie i Jerusalem, e si hule aana leu e sai leesie hanue aana, oto ko si ngarasie. ");
INSERT INTO apb_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Na ko te'uri hunie hanuena, “E tohungei diana hunie o ke lio saie si'iri tala takoie hanuelamanga, ta'e o sa'a saie ike, aena aana e ii'o mumuni mwaani'o. ");
INSERT INTO apb_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Kei hule taane aana maholo mo maelonga i'oe kire kei para ahui'o, na kire kei aala honosi'o aana ahutana mo leu ngeena, mwaanie uri nga iini eemiu e tahi lo'u. ");
INSERT INTO apb_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Kire kei oho aasi'o oto pe'ie ahutana mo mwela i'oe. Na nga ta'a-ta'a ho heu e sa'a oore ike lo'u i huline, aena aana o ka'a lio saie ike maholo nge a God e lae mai huni ha'a-uuri'o.” ");
INSERT INTO apb_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Oto a Jisas e lai sili ta'au i laona lolata aana Nume Maa'i Peine, na ko aehota oohea mwala e ha'a-ha'aholinge'i ola, ");
INSERT INTO apb_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","na ko ere aada uuri, “A God e unue aana mo Uusu-uusu Maa'i uuri, Nume ineu oto nume ni aarenga'inge. Ta'e omu ko si da mola ko ne'ie hahale kira horopeli kire sai mumuni i laona.” ");
INSERT INTO apb_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Oto i suli hei dinge a Jisas e ha'a-ha'a-uusuli i laona Nume Maa'i Peine. Oto mo na'ohai pris, na mo ha'a-uusuli aana mo Ha'atolanga a Mosis, na mo na'ohai mwane aana mo Jiu, kire eri'apasie uri kire ke horo maesie. ");
INSERT INTO apb_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Ta'e kire ka'a lio oodoie ike nga tala huni horo'ie, aena aana ahutana mwala kire mani o'o'o mola pe'ie i suli maholo, aana kire sere'i liue nga ta'a-ta'a mei wala aana mo ha'a-uusulinge ingeie. ");
INSERT INTO apb_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","A Jisas e ha'a-uusulie mwala ta'au i laona lolata aana Nume Maa'i Peine, na e lae-laeliwala aana Tataroha Diana. Oto aana ngaeta hai dinge, mo na'ohai pris na mo ha'a-uusuli aana mo Ha'atolanga a Mosis pe'ie mo rato ni mwane kire lae ta'au huni ere pe'ie. ");
INSERT INTO apb_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Oto kire ko te'uri hunie, “?Nga nanamanga uri taa ni o to'o aana huni esuie walu ola o ko deu'i ngeena? ?Na a tei ni e niie nanamanga ngeena huni'o?” ");
INSERT INTO apb_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Oto a Jisas e aalamire ko te'uri, “Ne ke hola'i dolosi ke'u eemiu uuri, ");
INSERT INTO apb_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","?A tei ni e niie nanamanga hunie a Jon huni loto maa'i aana mwala? ?A God wa mo iinoni mola?” ");
INSERT INTO apb_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Oto kire ko aehota ere hailiu i matolada uuri, “?Oto nga taa kolu kei unue? Mala uri kolu kei unue a God ni e niie nanamanga ngeena hunie a Jon, nge kei unue hunikolu uuri, ‘?Nge ko urine, na e ue omu ka'a hiiwalaimoli aana?’ ");
INSERT INTO apb_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Ta'e mala kolu kei unue, iinoni mola ni e niie nanamanga ngeena hunie a Jon, ahutana mwala ie kire kei meni uu'i kolu aani heu, aena aana kire hiiwalaimoli aana a Jon uri ingeie nga propet e uure mwaanie a God.” ");
INSERT INTO apb_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Oto kire aalamie mola a Jisas uuri, “!Oo! Melu ka'a saie ike.” ");
INSERT INTO apb_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Oto a Jisas ko te'uri lo'u hunire, “Ko urine, nge ineu na nou sa'a unue ike no'one oodoi'omu nga nanamanga uri taa no ko esuie mo ola ienini aana.” ");
INSERT INTO apb_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Oto a Jisas ko ere ni aalahuunge lo'u hunie mwala uuri, “Ngaeta mwane e o'o'o oto ko hesie hohola aani grep. Oto e ha'ahaulaa aana ngaeta mo mwane hunie kire ke lio i sulie maholo ingeie ko lae i suli henue, na e lae ngeena e kele lai ii'o tewa. ");
INSERT INTO apb_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Oto e hule aana maholo ni so'okoninge, a mwaena ko uusunge'inie ngaeta koni-konihe ingeie huni toolea mai nga taa mo mwane ko lio i sulie hohola ingeie kei niie hunie. Ta'e mo mwane ngeena kire wini-winie mola koni-konihe ngeena, na kire uusunge'i eeliho'i aana mola mwaakule. ");
INSERT INTO apb_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Oto poro painena ko he'i uusunge'inie lo'u ngaeta koni-konihe, ta'e mo mwane ko lio i suli ngeena kire ko he'i wini-winie lo'u mola, na kire ko tohungei waelie oto hiito'o, na kire ko uusunge'i eeliho'i lo'u mola aana mwaakule. ");
INSERT INTO apb_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Na a porona ko he'i uusunge'inie lo'u oolune nga koni-konihe. Ta'e kire ne'i malaka lo'u mola aana, na kire si aasie po'oi sinaha mwaanie leune. ");
INSERT INTO apb_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","“Oto poro paine nge e to'o aana hohola ngeena ko lo'onga'i uuri, ‘?Ne kei ue eena? Ne kei uusunge'inie kele madu ineu. Sa'a mola ingeie ha'alaa kire kei ha'ama'u aana.’ ");
INSERT INTO apb_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","“Ta'e maholo kire leesie a kalena, kire ko si meni ere i sulie mola uuri, ‘Mwane nge kei to'o aana hohola ngeena oolisie aamana oto ie. Kolu ke horo maesie mola hunie kolu ke to'o aana oto hohola ienini.’ ");
INSERT INTO apb_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Oto mo mwane ko lio i sulie hohola ngeena kire aasie kalena poro painena i sinaha mwaanie hohola, na kire ko horo maesie oto.” Oto a Jisas ko he'i dolosi lo'u aana mwala uuri, “?Ha'alaa nga taa nge poro paine haahie hohola ngeena kei esuie aana mwala ngeena? ");
INSERT INTO apb_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Maholo kei lae mai, nge kei tohungei horo suuhe'inie oto mwala aaela ngeena, na kei ha'ahaulaa lo'u hohola ngeena aana ngaeta mwala aaopa.” Maholo mwala e rongo urine, kire si meni te'uri, “!Ha'ike, ke su'uri urine!” ");
INSERT INTO apb_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Ta'e a Jisas e to'omaaire, ko si te'uri, “?Oto nga taa ni lo'onga'inge aana mo wala uusuleni e lae ienini, Hau nge mwala tou-tohu nume kire leledie ka'u, e ne'i tohungei heu susu oto aana nume? ");
INSERT INTO apb_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Oto no ko unue huni'omu uri nga iini ko domu i lengine hau ngeena kei ma'oi oto, na mala uri kei teke haahie nga iini na kei pili memesoa oto.” ");
INSERT INTO apb_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Oto mo ha'a-uusuli aana mo Ha'atolanga a Mosis na mo na'ohai pris kire rongo saie uri aalahuunge a Jisas aana mo mwane aaela ngeena ko ere mola i sulire. Kire ko si sare tapolie oto aana maholona, ta'e kire ko me'ute'inie no'one mwala. ");
INSERT INTO apb_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Oto kire ko si lio hunie nga maholo huni tapolie a Jisas. Na kire si uusunge'i mumuni aana ngaeta mo mwane uri kire ke lupwe'i lai dolosi aana mala ikire mwala oodota'i. Aena aana saeda uri a Jisas ke unue nga mei wala huni waelie maraana, huni uusu i maana i na'ona aalaha ni Rom. ");
INSERT INTO apb_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Oto mo mwaena ko te'uri hunie a Jisas, “Ha'a-uusuli, melu saie uri nga taa o ko unu-unue na o ko ha'a-ha'a-uusuli aana e to'ohuu. Na i'oe, o ka'a aapwasu ike aana lo'onga'inge nga iini, ta'e o ko ha'a-ha'a-uusuli mola aana walaimolinge i sulie tolahana God. ");
INSERT INTO apb_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","?Oto e ue, ohe e adona taane huni niie takis hunie aalahanga ni Rom wa ha'ike?” ");
INSERT INTO apb_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Ta'e a Jisas mone e saie mola kire ko raomae hunie, oto ko si te'uri hunire, ");
INSERT INTO apb_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Omu ke haata'inie ka'u seleni hunie takis ngeena aaku. ?A tei ni nunune na satana aana seleni ienini?” Oto kire ko unue uuri, “Inemauri ni Rom ni ngeena.” ");
INSERT INTO apb_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Oto a Jisas ko te'uri hunire, “Ko urine, omu ke nii eeliho'i aana hunie inemauri ngeena mo ola ingeie, na hunie a God mo iini a God.” ");
INSERT INTO apb_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Oto kire ko si meni pangata'inie aalaminge ingeie. Kire toli rohu, na nga iini ka'a nguu. Na kire ka'a saie ike lo'u nga mei ola huni raomae hunie aana i na'ona mwala. ");
INSERT INTO apb_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Oto ngaeta mo Sadiusi kire lae mai saana Jisas. Mo Sadiusi ngeena kire hiiwalaimoli uri nga iini sa'a ta'ela'i ike lo'u mwaanie maenga. Oto kire ko dolosi aana uuri, ");
INSERT INTO apb_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Ha'a-uusuli, a Mosis e uusue ha'atolanga ie hunikie. Mala uri nga mwane ko mae mwaanie hu'e, na e ka'a to'o kalena, nge aasine mwane ke to'o aana lo'u mola nao keni iihana, hunie ke ha'ahute mwela oolisie aasine nge e mae ngeena. ");
INSERT INTO apb_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Oto wau i na'o, e hiu mwaasine mwane kire mani hute na kire o'o'o i leu. A na'ohada e tola hu'e, oto e mae mola na e ka'a to'o mwela. ");
INSERT INTO apb_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Oto ruana nga mwane e he'i to'o aana lo'u naona, na ko mae lo'u. ");
INSERT INTO apb_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Na oolune nga mwane ko he'i to'o aana lo'u mei nao keni ngeena, na ko he'i mae lo'u. E hiu mwaasine ngeena kire ko meni to'o aana oto mola ta'a-ta'a hu'e ngeena urine, ta'e kire ka'a to'o mwela ike. ");
INSERT INTO apb_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Lae-lae, oto a hu'ena e si mae ooreta. ");
INSERT INTO apb_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","?Ha'alaa, kei hule aana hai dinge ta'ela'inge, a hu'e ngeena kei ne'i hu'e a tei aana e hiu mwaasine ngeena, aana kire mani to'o aana mola urine?” ");
INSERT INTO apb_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Oto a Jisas ko aalamire uuri, “Mai aano i leu mone mwala ko to'o poro na kire ko tola hu'e. ");
INSERT INTO apb_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Ta'e mo iini nge kire kei adona ta'ela'inge aaliho'i mwaanie maenga, na huni ii'o aana walumalau haalu nge kei lae maine, kire sa'a to'o-to'o poro wa kire ke totola hu'e lo'u, ");
INSERT INTO apb_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","na kire sa'a mae lo'u. Oto aana ii'onga urine nge kire kei ii'o oto mola mala mo ensel. Mwala ngeena oto mo kalena God, nge kire ta'ela'i eeliho'i lo'u mwaanie maenga hunie maurihe haalu. ");
INSERT INTO apb_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","A Mosis e haata'i diana aana oto uri iinoni e sai ta'ela'i eeliho'i lo'u mwaanie maenga. Maholo e uusu-uusu i sulie kele ai nge e ka'a waru ike aana dunge, e ere i sulie a Aalaha uri ingeie oto God nge a Ebraham, na Aesak na Jekob ko palo-paloa. ");
INSERT INTO apb_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Oto aana ko unue uri kiraelu ko palo-paloa ue a God ma'alana kire mae e tewa oto, a God e haata'inie uri ma'alana nga iini e mauri ue wa e mae oto, ta'e ahutana mwala kire mani meuri mola i na'ona God. Oto a God e ka'a ike nada mo iini e mae, ta'e God nada mo iini e mauri.” ");
INSERT INTO apb_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Oto ngaeta mo ha'a-uusuli aana mo Ha'atolanga a Mosis ko te'uri, “Ha'a-uusuli, aalaminge i'oe e to'ohuu oto.” ");
INSERT INTO apb_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Na kire ko meni maarara oto huni dolosie lo'u nga mei ola aana a Jisas. ");
INSERT INTO apb_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Oto a Jisas ko dolosi aada uuri, “?Aana e ue ni mwala ko unue uri a Kraes kei hute mola mai aana komu a Deved Inemauri? ");
INSERT INTO apb_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Aana a Deved nge e unue maraana i laona puke ni kananga uuri, A God e unue hunie aalaha ineu, uuri ‘O ke ii'o ka'u i pwalo-pwaloku aana na'ohai ii'o-ii'oha, ");
INSERT INTO apb_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","lai hule aana ne kei kama haahie mo maelonga i'oe i aano hunie o ke uuri puli-pulisire.’ ");
INSERT INTO apb_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","A Deved maraana ni e unue uri a Kraes e ne'i aalaha ingeie. ?Ta'e e ue? ?Mwane nge e hute mola aana komu a Deved maraana, kei he'i ne'i aalaha ingeie lo'u uri taa eena?” ");
INSERT INTO apb_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Maholo ahutana mwala ko meni pwaarongo ue i sulie erenga ingeie, a Jisas ko si te'uri hunie mo pwaarongoisuli ingeie. ");
INSERT INTO apb_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Omu ke kineta'ini'omu mwaanie mo ha'a-uusuli aana mo Ha'atolanga a Mosis. Kire ko sare walo liu mola pe'ie launiha'ana mo to'oni maa'i, na hunie uri mwala ke ha'apaina'ara maholo kire ko walo liu i laona mo leu ni uusi'e. Na kire ko lio hilisie mo na'ohai ii'o-ii'oha i laona mo nume ni palo-palo, na mo na'ohai tolinge aani ngeuhe. ");
INSERT INTO apb_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Na lo'u kire ko sare da mola uri kire ke lio manikulu'e aani aarenga'inge tewa i maana mwala. Ta'e hule aana kire ko ha'a-ha'amwe'u-mwe'ue mola mo nao keni, na kire ko leue mola mo nume ikire pe'ie ahutana to'o-to'olada. Ikire ngeena, ha'aloilada kei lae lo'u liutaa.” ");
INSERT INTO apb_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","A Jisas e lio-lio hailiu na ko leesie mwala e to'o-to'o kire ko niie mo niinge ikire i laona mwa'i aana Nume Maa'i Peine. ");
INSERT INTO apb_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Na lae-lae mei nao keni meitale e lae lo'u mei, oto ko niie mola e ro kele peni pulu. ");
INSERT INTO apb_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Oto a Jisas ko te'uri, “No ko unue oto huni'omu uri nao keni meitale ienini e nii peine liutaa aana ahutana mwala ko nii ie. ");
INSERT INTO apb_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Aana ahutana mwala ngeena, kire ko niie mola kele nganga'ai ola aana to'o-to'onga ikire. Ta'e mei nao keni meitale ie, kele mei to'oha uri huni meu-meuri aana ingeie oto ko nii mangoa ienini.” ");
INSERT INTO apb_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Ngaeta mo pwaarongoisuli a Jisas kire ko ere-ere i sulie Nume Maa'i Peine uri e lae otoi lio manikulu'e aena aana kire ha'alaunie pe'ie mo heu diana na mo niinge niilana ko lae huni ha'amanikulu'aa God. ");
INSERT INTO apb_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Ta'e a Jisas e te'uri hunire, “Ahutana walu ola omu ko lee-leesi'i ngeena, aana nga maholo oho-aasileni kei saro lae, na nga ta'a-ta'a ho heu e sa'a oore ike lo'u aana leu e o'o'o aana.” ");
INSERT INTO apb_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Oto ngaeta mo pwaarongoisuli ko dolosi aana Jisas, kire ko te'uri, “?Ha'a-uusuli, maholo uri taa ni walu ola ngeena kei reu? ?Na nga tolimaa uri taa ni huni haata'inie uri maholo hunie mo olana e kara'ini oto?” ");
INSERT INTO apb_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Oto a Jisas ko te'uri, “Omu ke lio talamiu mwaanie nga iini e eero'omu. Aana mo iini hunge kei lae mai aana sataku, na kire kei unue uuri, ‘Ineu oto a Kraes,’ na lo'u uuri, ‘Pongi e hule oto.’ Ta'e omu ke su'uri rongo hunire wa omu ke lae i sulire. ");
INSERT INTO apb_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Na maholo omu ko rongoa mo oohotaa, na mo heiseuninge honosie mo kahamani, mwaanie omu me'u-me'u, aana walu ola ngeena kei hola'i reu i na'o. Ta'e ha'amangolana walumalau ie ha'ike ue ni ngeena.” ");
INSERT INTO apb_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Oto ko he'i unue lo'u uuri, “Mwala aana ngaeta hanue kei ooho honosie mwala aana ngaeta hanue. Nga aalahanga kei ta'ela'i honosie ngaeta aalahanga. ");
INSERT INTO apb_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Na mo nunu peine kei tola. Hiolonga paine na liunge ni maelaa kei tola aana mo po'o ni henue hunge. Mo ola ni me'u i suli'i na mo tolimaa paine kei siho mai uure i lengi. ");
INSERT INTO apb_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Ta'e i na'ona walu ola ienini ke si reu, mwala kei tapoli'omu na kire kei teunge'ini'omu. Kire kei toole'omu i laona mo nume ni palo-palo hunie mo mwane paine kei lei'omu. Na kire kei toole'omu lo'u i na'ona mo aalaha na mo inemauri hunie kire kei lei'omu no'one. Na kire kei meni aasi'omu i laona mo nume ni ho'o aena aana omu ko lulu i sulieu. ");
INSERT INTO apb_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Aana maholo walu olana kei reu uurini, maholo i'omu otona huni unu diana aana Tataroha Diana hunire. ");
INSERT INTO apb_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Omu ke lo'o-lo'onga'i diana mola, na mwaanie omu lae otoi tolahi'e aana nga taa ni unue honosi'omu. ");
INSERT INTO apb_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Ineu, ne kei haata'inie taane aamiu nga taa ni unue aana tohungana saenanaunge hule aana nga iini aana mo maelonga i'omu, na e sa'a oolisie ike lo'u nga mei wala aana erenga i'omu. ");
INSERT INTO apb_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Ahutana mwala kei meni leledi'omu. Ma'alana mo aamamiu, na mo nikemiu, na mo eesimiu, mo tekihemiu, na mo malahumiu, na kire kei teunge'ini'omu no'one. Hule aana kire kei horo maesie ngaeta mo iini eemiu. ");
INSERT INTO apb_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Ahutana mwala kei teunge'ini'omu aena aana omu ko lulu i sulieu. ");
INSERT INTO apb_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Ta'e nga ta'a-ta'a mei ola aana mo ola ngeena e sa'a roro'a to'ohi'omu ike. ");
INSERT INTO apb_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Na a God ke si ha'a-uurie ahutemiu nge omu kei uure a'aila'a tara'asi aani hiiwalaimolinge lai hule aana ha'amangolana.” ");
INSERT INTO apb_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Oto a Jisas ko he'i te'uri lo'u, “Maholo omu ko leesie mae e aala ahuie oto i Jerusalem, omu ke si saie uri e kara'inie oto oho-aasilana hanue paine ngeena eena. ");
INSERT INTO apb_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Oto aana maholona, mwala i Jiudia kire ke tahi oto i mumuni honosie mo toloi henue. Mo iini e ii'o i Jerusalem kire ke tahi oto mwaanie hanue painena, na mo iini e ii'o kali-kelie i Jerusalem kire ke su'uri lae lo'u weu i laona hanue. ");
INSERT INTO apb_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Aena aana mo dinge ni ha'aloinge a God ni otona, huni ha'a-oaie mo ola uusuleni e lae oto i laona mo Uusu-uusu Maa'i. ");
INSERT INTO apb_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Na aama-aamasilana mo hu'e ko hi'e-hi'e aani mwela, na mo iini nge kire ko ha'a-ha'asusuhie ue mo wee-wee ikire. Aana si'oha'anga paine kei toolea hanue ie aana maholona, na saewasunge a God kei to'ohie oto mwala ingeie mo Jiu. ");
INSERT INTO apb_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Nga mo iini horo maesilada kei lae aani naihi, na ngaeta mo iini kire kei tola mauri aada takoie mo henue hai aaopa'i mala mwala e ii'o ni ho'o. Mwala aaopa nge ikire nga mo Jiu ha'ike, kire kei uuri puli-pulisie i Jerusalem lai hule oto aana maholo mo Aapoloa Aaopa kei saro mango.” ");
INSERT INTO apb_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Na a Jisas ko he'i te'uri lo'u, “Mo tolimaa hai aaopa'i kei reu aana sato na waro-waro na mo hee'u ta'au i salo. Na ahutana mo henue mai laona walumalau kire kei meni me'ute'inie kou-kouha'ana naho na kone-kone i eesi, na hule aana kire sa'a saie ike lo'u nga taa ni da. ");
INSERT INTO apb_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Mwala kei maesie ma'unge aana maholo kire ko maa'oohie nga taa kei siho mai haahie ahutana walumalau, aana ahutana mo ola ta'au i salo kei meni esu oolo-oolo mango, na kire kei meni hei-oolisi mango oto. ");
INSERT INTO apb_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Oto aana maholona, mwala ke si leesieu a Kale Ni Iinoni, aana ne kei lae mai i laona mei uuru pe'ie nanamanga na manikulu'anga paine. ");
INSERT INTO apb_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Na maholo walu ola ienini kei aehota rau, su'uri me'u, ta'e omu ke uuwe pwau mola i lengi, aana maholo a God kei ha'a-uuri'omu ko kara'ini oto mai.” ");
INSERT INTO apb_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Oto a Jisas ko si ere ni aalahuunge hunire uuri, “Omu ke lo'onga'i ke'u i sulie ai fik na oto ahutana mo ei. ");
INSERT INTO apb_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Maholo omu ko leesie kire ko aehota ure, omu saie oto uri mo waro-waro ni madoro ko kara'ini oto mai eena. ");
INSERT INTO apb_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Na e urine no'one aana maholo omu kei leesie walu ola ienini ko reu uurini, omu ke si manata'inie uri Aalahanga a God ko kara'ini oto mai.” ");
INSERT INTO apb_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“No ko unue oto huni'omu uri walu ola ienini kei saro oa mango mola ue oodoie mwala aana pwaunge si'iri ie, na kire ka'a mae ue. ");
INSERT INTO apb_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","I Lengi na i aano kei suu, ta'e walaku e sa'a suu ike oto oo'oo.” ");
INSERT INTO apb_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Oto a Jisas ko he'i te'uri lo'u, “!Omu ke lio talamiu! Mwaanie omu tolahi'e mola aana mo ola ni welumalau, wa mwaanie omu talei tara mola aani ngeuhe na aani inunge. Aana mala omu kei tara mola aana mo ola urine, hai dingena kei hule mola na omu ka'a dau aakau ike. ");
INSERT INTO apb_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Hai dinge ngeena kei sikile'i mala hune kire lolosie, aani ha'aparasilana ahutana mwala aana walumalau. ");
INSERT INTO apb_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Oto omu ke kakali diana pe'i aarenga'inge taraure'i, hunie omu ke uure a'aila'a huni lae sapemawa i matolana walu ola kei reu ngeena, lai hule aana maholo omu kei uure i na'oku a Kale Ni Iinoni.” ");
INSERT INTO apb_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Mo dinge ngeena a Jisas e sai ha'a-uusulie mwala ta'au i laona lolata aana Nume Maa'i Peine aana aatowaa, na maholo ko seulehi na ni e lae huni ma'ahu ta'au i lengine Uuwo Ni Ei Olif. ");
INSERT INTO apb_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Ahutana mwala kire ko meni ha'a-ha'ahu'o ta'au i lolata aana Nume Maa'i Peine huni rongoa mo ha'a-uusulinge ingeie suli dinge. ");
INSERT INTO apb_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Maholona na ko kara'inie oto Houlaa Ni Bred Iis Ha'ike Aana, nge kire haara'inie no'one aana Houlaa Ni Liumwaanie. ");
INSERT INTO apb_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Mo na'ohai pris na mo ha'a-uusuli aana mo Ha'atolanga a Mosis kire ko lo'o-lo'onga'inie horo-maesilana a Jisas kei lae uri taa, ta'e kire ko me'ute'inie mwala mwaanie kire maaola-ola. ");
INSERT INTO apb_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Oto a Satan e sili i saena ngaeta iini aana aawalai hurula'aa mwana rue a Jisas nge sailana uri a Jiudas Iskariot. ");
INSERT INTO apb_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Na e lae, oto ko lai ere ruru pe'ie mo na'ohai pris na mo mwane paine aana pulitaa ko kakakalie Nume Maa'i Peine. Na ko unue uri kei pweloa a Jisas uri taa hunire. ");
INSERT INTO apb_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Oto kire ko tohungei saemango hiito'o na kire ko heiholota'i oto huni nii to'oha nana. ");
INSERT INTO apb_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Oto a Jiudas e ne'isae moute'i pe'ire, na ko aehota heitalea oto nga maholo diana huni nii mumuni aana a Jisas hunire, mwaanie uri mwala e saie lo'u. ");
INSERT INTO apb_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Oto e hule aana eetana nga hai dinge aana Houlaa Ni Bred Iis Ha'ike Aana, na dinge ngeena oto dinge huni horo'ie mo kalei sipu hunie ngaunge aana Liumwaanie. ");
INSERT INTO apb_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","A Jisas ko si uusunge'inie a Pita na Jon, na ko te'uri hunirerue, “More ke lae na more ke dau aakau aana ngaunge aana Liumwaanie hunie kolu kei ngeu.” ");
INSERT INTO apb_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Oto kirerue ko dolosi aana uuri, “?Mere kei lai deu aakau aana i tei eena?” ");
INSERT INTO apb_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Oto a Jisas ko aalamirerue uuri, “Maholo more kei lae ta'au i hule i henue, more kei oodoie nga mwane nge ko aanga'inie ho ate'ai wei. More ke lae oto i sulie hunie nume nge kei lai sili aana. ");
INSERT INTO apb_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Oto more ko unue hunie iinoni e to'o aana nume ngeena uuri, ‘A Ha'a-uusuli e unue uri o ke haata'inie aamere'i duru nge kei hele aana ngaunge aana Liumwaanie pe'ie mo pwaarongoisuli ingeie.’ ");
INSERT INTO apb_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","A mwane ngeena ke si haata'inie duru paine ingeie ta'au i lengi aamore'i, iini kire dau aakau oto aana. Nge more kei deu aakau aana mo ola hunikolu i leune.” ");
INSERT INTO apb_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Oto a Pita na a Jon kirerue lae ta'au na kirerue ko leesie walu ola ko reu oto mala a Jisas e unue hunirerue. Oto kirerue ko deu aakau oto aana ngaunge aana Liumwaanie. ");
INSERT INTO apb_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Oto e hule aana maholoi sato hunie ngaunge i seulehi, nge a Jisas na mo hurula'aa kire si ii'o huni ngeu. ");
INSERT INTO apb_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Na ko te'uri hunire, “Maholo nou maa-maa'ohie pe'ie hari-huninge paine e hule oto, aana nou ne'i-ne'isae haahie ngaunge aana Liumwaanie ienini pe'i'omu i na'ona sapesalunge ineu kei aehota. ");
INSERT INTO apb_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Aana no ko unue oto huni'omu uri nou sa'a roro'a ngau lo'u aana nga ngaunge aana Liumwaanie mala ie pe'i'omu lai hule aana mo lo'onga'inge aana kei saro oa aana Aalahanga a God.” ");
INSERT INTO apb_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Oto a Jisas e hele aana kao-kaoi waen, e ere ni paalahenga mango, ko si te'uri hunire, “Omu ke hele aana na omu ke mani inu aana. ");
INSERT INTO apb_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","No ko unue oto huni'omu uri nou sa'a inuhie lo'u nga mei waen lai hule aana Aalahanga a God kei lae mai.” ");
INSERT INTO apb_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Oto e hele aana ho bred, oto ko ere ni paalahenga haahie, ko si nisie, na ko ha'a-adoa mo pwaarongoisuli aana. Oto ko te'uri, “Hasi'oku oto ienini nge toli'aasilana e lae i tehula'amiu. Omu ke tete'urine, huni aamasito'onga aaku.” ");
INSERT INTO apb_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","E urine lo'u i purine ngaunge e mango, e hele aana lo'u kao-kaoi waen, na ko te'uri, “Apuku oto ienini nge e aahe huni'omu, na mei epu nge ko ha'a-oaie haiholota'inge haalu a God ko esuie pe'ie mo iinoni ingeie. ");
INSERT INTO apb_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","!Ta'e omu ke saie! Iini ko pweloau taane oto pe'ieu i leu. ");
INSERT INTO apb_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Na ineu a Kale Ni Iinoni ne kei mae taane oto i sulie oala'inge a God, ta'e aama-aamasilana iini nge ko pweloau.” ");
INSERT INTO apb_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Oto mo pwaarongoisuli ko si aehota dolosi aada hailiu uri a tei iini hikada kei pwaoa leune. ");
INSERT INTO apb_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Kire ere-ere, na kire ko aehota ere haitapali oto haahie uri a tei hikada e paine liutaa. ");
INSERT INTO apb_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Ta'e a Jisas e te'uri hunire, “Mo inemauri aana walumalau ie oto kire ko sasare haata'inie nanamanga ikire haahie mwala ikire. Na mwala nge kire to'o aana nanamanga haahie ngaeta mwala, saeda uri mwala ke ha'apaina'ara mala uri ta'e ikire oto mo iini ko pe'ie mwala. ");
INSERT INTO apb_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Ta'e i'omu, omu ke su'uri te'urine. Nga iini ko ne'i na'ohai mwane i'omu, nge ke ne'i iinoni mwei-mwei. Na mwane paine i'omu, ke ne'i koni-konihe mola namiu. ");
INSERT INTO apb_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","?A tei ni e roro'a, iini e ii'o i aano nge ko maa'oohie mola ngaunge, wa iini nge ko rareta'i? To'ohuu iini nge e ii'o i aano oto e roro'a. Ta'e ineu, nou ii'o i matolamiu ie mala iini ko hei rareta'i. ");
INSERT INTO apb_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“I'omu, omu ii'o oto pe'ieu taraure'i aana ahutana maholo aasanga ko oohongieu. ");
INSERT INTO apb_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Na oto mala Aamaku e niie nanamanga nakue huni aalaha haahie mo iinoni, nge ineu no ko niie ta'a-ta'a taungei nanamanga ngeena no'one huni'omu. ");
INSERT INTO apb_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Hunie uri omu kei ngeu na omu kei inu pe'ieu aana aalahanga ineu. Na omu kei ii'o i lengine mo neunekume ni aalaha huni leie aawalai komu mwana rue ni Israel.” ");
INSERT INTO apb_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Na a Jisas e he'i te'uri lo'u, “!Saemon, Saemon! O ke saie, a God e toli'aasie uri a Satan ke dau aahongamiu huni leesie uri a tei kei uure a'aila'a. ");
INSERT INTO apb_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Ta'e ineu, no ko aarenga'i taane talamu Saemon hunie uri hiiwalaimolinge i'oe ke susu. Oto maholo o ko eeli'u mei takoieu, o ke si ha'asusue mo eesimu hunie kire ke a'aila'a no'one.” ");
INSERT INTO apb_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Oto a Pita ko te'uri, “Aalaha ineu, no ko maa'oohie mola laenga pe'i'o i nume ni ho'o na oto huni mae pe'i'o.” ");
INSERT INTO apb_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Oto a Jisas ko aalamie uuri, “No ko unue oto huni'o Pita, i na'ona kue kei ngara i rodo si'iri, o kei saronai taateinge'inieu ha'a-oolu uri o ka'a manata'inieu ike.” ");
INSERT INTO apb_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Oto a Jisas ko te'uri lo'u hunie mo pwaarongoisuli ingeie, “Omu ke lo'onga'inie ka'u aana maholo nou uusunge'ini'omu ke'u waite, na omu ka'a toolea nga mwa'ii to'oha, wa nga mwa'i lo'u, wa nga ho'ohaahi'ae. ?Ohe omu tola talea nga mei ola lo'u huni pe'i'omu wa ha'ike?” Oto kire aalamie a Jisas uuri, “Ha'ike taane.” ");
INSERT INTO apb_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Oto a Jisas ko te'uri, “Ta'e oto molana, nga iini ko to'o aana nga mwa'ii to'oha wa nga mwa'i lo'u nge ke toolea oto. Na nga iini ka'a to'o aana nga naihi hei-heiseuni ke ha'aholinge'inie to'oni ingeie hunie ke holie lo'u nga naihi. ");
INSERT INTO apb_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Aana no ko unue oto huni'omu uri nga taa nge mo Uusu-uusu Maa'i e unue kei oa oto hunieu, aana e unue uuri, Mwala ko ere takalo uri ingeie ngaeta iinoni ooraha'aa mola. Ahutana mo ola uusuleni e lae i sulieu, kire ko reu oto.” ");
INSERT INTO apb_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Oto mo pwaarongoisuli ko te'uri, “Lio ka'u, Poro paine, e ro naihi ka'u oto ie.” Oto a Jisas ko te'uri, “E ado oto.” ");
INSERT INTO apb_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Oto a Jisas e uure mwaanie huilume paine ngeena, ko si lae hunie Uuwo Ni Ei Olif oto mala ko lae-lae suli maholo. Mo pwaarongoisuli ingeie na kire lae no'one pe'ie aana maholona. ");
INSERT INTO apb_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Maholo e hule oto ta'au i leune, e si te'uri hunie mo pwaarongoisuli ingeie, “Omu ke aarenga'i mwaanie malaahonga e hane haahi'omu.” ");
INSERT INTO apb_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Oto e kele lae mola ta'au mwaanire, e pouruuru i aano ko si aarenga'i, ");
INSERT INTO apb_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","ko te'uri, “Mama'a, iiola o niie mai hunie ne ke hotela'inie ko aasaieu oto. Mala ko mwada'u, saeku o ke oolisie aana nga iini mwa-mwate. Ta'e ne'ewau oto, o ke dau mola i sulie nga taa o saeto'o aana, na o ke su'uri deu i sulie nga taa nou saeto'o aana.” ");
INSERT INTO apb_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Oto ensel uure i Lengi ko haata'i aana a Jisas, na ko ere ha'asusue saena. ");
INSERT INTO apb_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Na aena aana sapesalunge e paine hiito'o, a Jisas ko si aarea God lo'u liutaa. Na ko madara'a oto hiito'o hule aana mo uudu-uuduhe ni madara'anga kire lio oto mala mo uudu-uuduhe ni epu. ");
INSERT INTO apb_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Oto e aarenga'i mango, e ta'ela'i ko si lae i saana mo pwaarongoisuli, na ko leesie mola kire ko ma'ahu aena aana kire tohungei weo aana kire saehuu. ");
INSERT INTO apb_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Oto ko te'uri hunire, “?Uri omu ko ma'ahu mola? Omu ke ta'ela'i na omu ke aarenga'i mwaanie malaahonga e hane haahi'omu.” ");
INSERT INTO apb_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Maholo a Jisas ko ere-ere ue, na mwala hunge kire ko maau oto aana. A Jiudas ngaeta iini aana aawala mwana rue, nge ni e na'oda. Oto a Jiudas e lae mai saana a Jisas hunie ke nono pe'ie. ");
INSERT INTO apb_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Ta'e a Jisas e te'uri hunie, “?Jiudas, uri o ko pweloau a Kale Ni Iinoni mola aani nononga pe'ieu?” ");
INSERT INTO apb_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Maholo mo pwaarongoisuli kire leesie nga taa ko reune, oto kire ko te'uri, “?Poro paine, uri melu ko heiseuni oto aani naihi?” ");
INSERT INTO apb_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Oto ngaeta iini hikada e lama mousie aalinge i pwalo-pwalo aana koni-konihe a Na'ohana Mo Na'ohai Pris. ");
INSERT INTO apb_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Ta'e a Jisas e te'uri hunire, “!Su'uri te'urine lo'u!” Na ko hele wau aana aalingana, ko ha'a-uurie oto. ");
INSERT INTO apb_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Oto a Jisas ko si ere hunie mo na'ohai mwane aana mo pulitaa hai aaopa'i kire hule ngeena, aana ngaeta mo na'ohai pris, na mo na'ohai ramo nge kire ko kakakalie Nume Maa'i Peine, na mo rato ni mwane ni Jiu kire hule no'one. Oto ko te'uri hunire, “?Uri omu unue uri ineu nga horopeli nge omu ko lae mai honosieu pe'i naihi na pe'i di'e? ");
INSERT INTO apb_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Ahutana dinge ka'u no ko talei o'o'o mola pe'i ha'a-uusulinge ta'au i laona Nume Maa'i Peine. ?Aana e ue ka'u omu ka'a tapolieu oto aana maholona? !Ta'e ne'ewau! Maholoi sato i'omu hunie aalahanga ni rodohono ke paine oto ienini.” ");
INSERT INTO apb_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Oto kire si tapolie a Jisas na kire ko toolea oto ta'au i nume a Na'ohana Mo Na'ohai Pris, na a Pita ko holo maholoi tala taane mola i sulire. ");
INSERT INTO apb_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Oto ta'au i nume ngeena, mo ramo kire rurue dunge i denumana lolata na kire ii'o i aano kali-kelie. Oto a Pita e lae mai ko ii'o i aano no'one pe'ire. ");
INSERT INTO apb_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Na ngaeta keni eu'esu e leesie a Pita maholo dunge ko raangie maana, oto ko lio hahuroto oto aana na ko te'uri, “!A mwane ienini no'one pe'ie a Jisas!” ");
INSERT INTO apb_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Ta'e a Pita e taateinge'inie, ko te'uri, “!Keine, nou ka'a saie ike a mwane ngeena!” ");
INSERT INTO apb_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","E ka'a tewa ike lo'u i purine na ngaeta iini lo'u ko leesie a Pita na ko te'uri, “I'oe no'one ngaeta iini aada.” Oto a Pita ko te'uri, “!Mwae! !Ineu ha'ike!” ");
INSERT INTO apb_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Ola mala nga ta'a-ta'a maholoi sato lo'u mola i purine, na ngaeta mwane ko si susule'inie na ko te'uri, “Sa'a mola a mwane ngeena e o'o'o no'one pe'ie a Jisas. Aana ingeie mwane ni Kalili no'one.” ");
INSERT INTO apb_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Ta'e a Pita e aalamie uri, “!Mwae! !Nou ka'a manata'inie ike nga taa o ko unuena!” Na oto mola aana maholo nge ko ere-ere ue ngeena, kue ko tolana ngara oto. ");
INSERT INTO apb_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Na aana kele maholoi satona, a Aalaha e aali'u, e si to'omaaie a Pita. Oto a Pita ko si aamasito'o aana nga taa poro painena e unue ka'u hunie uuri, “I na'ona kue kei ngara i rodo si'iri, o kei saronai taateinge'inieu ha'a-oolu uri o ka'a manata'inieu ike.” ");
INSERT INTO apb_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Oto a Pita e lae ta'au i iisitaa i sinaha, ko si ngara uulo-uulo. ");
INSERT INTO apb_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Na aana maholona mo iini kire kakakalie a Jisas kire ko si aehota ha'amwasi aana na kire ko repusie. ");
INSERT INTO apb_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Kire pwasu honosie maana, na kire ko si dodolosi aana uuri, “!Hoe propet! !O ke unue ka'u oodoi'emeelu! ?A tei ni e si repusi'o ngeena?” ");
INSERT INTO apb_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Na kire ko ere aaelasie a Jisas oto no'one aana mo ola hunge. ");
INSERT INTO apb_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Oto maholo na ko aehota dangi oto, mo rato ni mwane na mo na'ohai pris oto pe'ie mo ha'a-uusuli aana mo Ha'atolanga a Mosis, kire meni loko oto. Na i leune kire ko si toolea mai a Jisas i na'oda. ");
INSERT INTO apb_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Oto kire ko dolosi aana a Jisas uri, “O ke unue ka'u oodoi'emeelu. ?Uri i'oe ni oto a Kraes?” Oto a Jisas ko aalamire uuri, “Ma'alana no ko unue ka'u oodoi'omu, na omu sa'a hiiwalaimoli ike aaku. ");
INSERT INTO apb_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Na ma'alana no ko dolosie nga mei ola aamiu, na omu sa'a mwa'e-mwa'e ni aalamieu ike no'one. ");
INSERT INTO apb_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Ta'e uure aana maholoi sato ienini pwau weu, ineu a Kale Ni Iinoni ne kei ii'o oto aana na'ohai ii'o-ii'oha i pwalo-pwalona God Hahu'ana Nanama.” ");
INSERT INTO apb_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Oto kire ko meni dolosi lo'u aana uuri, “?Nge uri i'oe oto Kalena God?” Oto a Jisas ko aalamire uuri, “Nge ka'u oto omu ko unuena.” ");
INSERT INTO apb_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Oto kire ko si te'uri, “!Rongo ka'u! !Kolu rongoa oto maraakaelu nga taa e unue! !Ngeena kolu ka'a saeto'o aana ike lo'u nga iini ke ere takoie!” ");
INSERT INTO apb_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Oto kire mani ta'ela'i, kire ko toolea oto a Jisas i na'ona a Paelat. ");
INSERT INTO apb_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Na kire ko aehota unue oto mo ola hunge i sulie a Jisas uuri, “Melu deu oodoie oto a mwane ienini ko ha'atakaloa mwala i'emi mo Jiu, na ko ere aada mwaanie nii-to'ohanga hunie aalahanga ni Rom, pe'ie ko unue uri ingeie oto a Kraes, Inemauri i'emi mo Jiu.” ");
INSERT INTO apb_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Oto a Paelat e dolosi aana a Jisas, ko te'uri, “?Uri i'oe ni oto Inemauri mo Jiu?” Oto e aalamie a Paelat ko te'uri, “Nge ka'u oto o ko unuena.” ");
INSERT INTO apb_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Oto a Paelat ko te'uri hunie mo na'ohai pris na ahutana mwala, “Nou ka'a lio oodoie ike nga mei roro'anga aana a mwane ienini.” ");
INSERT INTO apb_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Ta'e kire ko meni rara oto uuri, “A mwane ngeena ko talei kotahie mola i'emi mo Jiu aana ha'a-uusulinge ingeie i sulie mo henue, uure oto hao aana po'o ni henue i Kalili, na hule oto mai aana po'o ni henue i Jiudia.” ");
INSERT INTO apb_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Maholo a Paelat e rongo urine, ko si dolosi aada uuri, “?Uri a mwane ienini ingeie nga mwane ni Kalili?” ");
INSERT INTO apb_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Maholo e rongoa uri a Jisas e uure mwaanie po'o ni henue nge a Herod Antipas ko aalaha haahie, e si uusunge'inie i saana a Herod, aena aana maholona a Herod ingeie no'one i Jerusalem. ");
INSERT INTO apb_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","A Herod e tohungei ilenimwa'e oto hiito'o maholo e leesie a Jisas, aena aana e talei rorongo tarohana na e sasare leesie ko tewa oto mai. Na uri hunie a Jisas ke asuie ka'u nga hu'i-hu'ite hunie ke leesie. ");
INSERT INTO apb_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Oto a Herod e dolosie mo ola hunge aana a Jisas, ta'e a Jisas ka'a aalamie ike oto oo'oo. ");
INSERT INTO apb_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Mo na'ohai pris na mo ha'a-uusuli aana mo Ha'atolanga a Mosis kire mani lae no'one mai, oto kire ko meni rara oto aani unulana ta'ena nga ola honosie a Jisas. ");
INSERT INTO apb_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Oto a Herod na mo ramo ingeie kire ko si ha'amwasi mola aana Jisas, na kire ko ere mwakata'inie. Kire ha'ato'onie aana to'oni tetewa nonoro'a mala mo aalaha ko ho'o-ho'osi'i, kire si uusunge'i eeliho'i lo'u aana i saana a Paelat. ");
INSERT INTO apb_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Aana hai dingena a Paelat na a Herod kirerue ko si he'imalahune lo'u, ta'e hola'ina'o ikirerue e ro maelonga ni ngeena. ");
INSERT INTO apb_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Oto a Paelat e lokoa mo na'ohai pris, na mo rato ni mwane, na ahutana mwala, ");
INSERT INTO apb_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","ko si te'uri hunire, “Omu toolea mai mwane ienini i seeku aana omu ko unue uri ko ha'atakaloa mwala aani hei polanga honosie aalahanga ni Rom. Ta'e lio ka'u. Nou dodolosi oto aana i na'omiu na nou ka'a lio oodoie ike nga mei roro'anga omu unue a mwane ie e dau hu'isie. ");
INSERT INTO apb_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","A Herod na e ka'a lio oodoie ike no'one nga mei roro'anga aana, ka'u e uusunge'i eeliho'i aana mola mai seeku. E lio mala uri a mwane ienini e ka'a dau hu'isie ike nga mei ola adona maenga. ");
INSERT INTO apb_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Oto ne kei repusie mola, na no ko toli'aasie ke ii'o luheta'i oto.” ");
INSERT INTO apb_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Ta'e ahutana mwala ko si meni tea paine mola aana maholona na kire ko unue uuri, “!Horo maesie mola! A Barabas ni melu saeto'o aana o ke luhesie.” ");
INSERT INTO apb_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","(A Barabas ko ii'o i nume ni ho'o aena aana e horo maesie nga mo iini i Jerusalem maholo pulitaa ingeie kire haiseuni honosie aalahanga ni Rom.) ");
INSERT INTO apb_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Ta'e a Paelat e sare toli'aasie mone a Jisas ke ii'o luheta'i, oto ko he'i ha'arongoa lo'u mwala aana leune. ");
INSERT INTO apb_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Ta'e kire ko meni soi peine lo'u mola uuri, “!Horo maesie! !Horo maesie mola i lengine po'u-po'u!” ");
INSERT INTO apb_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Oto oolune nga maholo a Paelat ko he'i unue lo'u hunire uuri, “?Aana e ue? ?Ha'alaa nga mei taa ni e dau aaelasie? Nou ka'a lio oodoie ike nga mei ola huni horo maesie i tehula'ana. Aena urine, ne kei repusie mola na no ko toli'aasie oto ke ii'o luheta'i.” ");
INSERT INTO apb_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Ta'e kire ko si he'i soi peine lo'u mola uri a Paelat ke horo maesie a Jisas i lengine po'u-po'u. Na lae-lae walada e hane haahie oto a Paelat. ");
INSERT INTO apb_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Oto a Paelat e si tolatahanga'inie leinge ingeie uri mei ola kire saeto'o aana kei lae oto urine. ");
INSERT INTO apb_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","E luhesie a Barabas, mwane e haiseuni na e horo mwaanie nume ni ho'o, na e si toli'aasie a Jisas i laona nimada hunie kire ke dau mala saeda aana. ");
INSERT INTO apb_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Maholo mo ramo kire toolea a Jisas mwaanie nume a Paelat, na kire ko oodoie nga mwane satana a Saemon, mwane aana huilume i Saerin, e si uure mola mwaanie hohola. Oto kire si deu rarahie mola hunie ke aanga'inie po'u-po'u i sulie a Jisas. ");
INSERT INTO apb_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Na mwala oto hunge kire ko lulu i sulie a Jisas no'one aana maholona. Na mo keni hunge ko lae pe'i ngarasie a Jisas lae-lae'i. ");
INSERT INTO apb_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Oto a Jisas e aali'u takoire, ko te'uri hunire, “!Maeni keni ni Jerusalem! Omu ke su'uri ngara-ngarasieu, ta'e omu ke ngara-ngarasi'omu mola maraamiu na mo kalemiu. ");
INSERT INTO apb_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Aana mo dinge ko lae maine mwala kei unue uuri, ‘Deidehie mo iini e amara, na mo iini ka'a ha'ahute, na mo iini nge mo wee-wee ha'ike ikire huni ha'asusuhire.’ ");
INSERT INTO apb_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Na aana maholona nge mwala ke si unue uuri, ‘I'omu mo toloi henue ngeena, omu ke aa'oho mola mai haahi'emi ha'alaa e diana.’ Na kire kei unue no'one hunie mo uuwo uuri, ‘I'omu, mo uuwo ngeena, omu ke aanomi'emeelu mola.’ ");
INSERT INTO apb_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Ineu nou urihana ai nge e mauri, aana nou ka'a dau hu'isie nga mei ola, ta'e ma'alana e urine walu ola aaela ko reu oto aaku ienini. ?Oto kei uri taa taane huni'omu, mo iinoni ooraha'aala? Kei tohungei aaela oto liutaa huni'omu aana omu urihana mola ai nge e mae aakau oto loosie aasilana i laona dunge.” ");
INSERT INTO apb_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Na mo ramo kire toolea no'one ngaeta ro mwane horopeli huni horo maesirerue pe'ie a Jisas. ");
INSERT INTO apb_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Maholo kire lai hule oto aana leu sailana uuri “Leu ni Rarata,” kire si repu taalengasie a Jisas i lengine po'u-po'u. Na e ro mwane horopeli ngeena kire ko repu taalengasirerue no'one i lengine ngaeta ro po'u-po'u. Oto kire ko si ne'ie nga iini i pwalo-pwalona a Jisas, na nga iini i meu-meuline. ");
INSERT INTO apb_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","35","Oto a Jisas e te'uri, “Mama'a, o ke ne'isae-aasie leu ie mwaanire, aana kire ka'a saie ike uri nga taa kire ko da.” Na maholo mwala ko maa-maa ni ola ue aana maelana e oolu mwane, mo ramo kire ko si inie daes huni leesie iini uri taa aada kei to'o aana mo sala a Jisas. Na mo rato ni Jiu ko ha'amwasi aana a Jisas, kire ko te'uri, “E roro'a ha'a-ha'a-uurie mwala aaopa. Kolu ke lio ka'u ohe ko ha'a-uurie maraana, mala ko ne'ie a Kraes to'ohuu, inemauri a God e lio hilisie hunikie mo Jiu.” ");
INSERT INTO apb_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Mo ramo no'one na kire ha'amwasi aana a Jisas. Kire lae mai saana, oto kire ko niie waen aha'i hunie ke inuhie. ");
INSERT INTO apb_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Na kire ko te'uri, “O ke ha'a-uuri'o ka'u, mala o ko ne'ie nga inemauri mo Jiu to'ohuu.” ");
INSERT INTO apb_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Na nga taa kire uusue na kire ne'ie i pweune po'u-po'u a Jisas e ere uuri, INEMAURI MO Jiu KA'U IE. ");
INSERT INTO apb_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Oto ngaeta iini aana e ro mwane horopeli nge aaroroladarue e lae pe'ie, ko ere aaelasie a Jisas na ko te'uri, “?Uri i'oe ni oto a Kraes wa ha'ike? O ke ha'a-uurikolu mone.” ");
INSERT INTO apb_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Ta'e ngaeta iini ko si ere aana mola uuri, “?Uri o ka'a ma'ute'inie ike a God? Aana leilemu ko lae tararuru pe'ie a mwane ienini. ");
INSERT INTO apb_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Ikure aana e urine, na horo'ilakarue ko lae oto haahie mo ola kure dau aaelasi'i. Ta'e a mwane ienini, ingeie e ka'a dau aaelasie ike nga mei ola oto oo'oo.” ");
INSERT INTO apb_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Oto ko si te'uri hunie a Jisas, “Jisas, o ke ne'isae aaku maholo o kei ii'o aana aalahanga i'oe.” ");
INSERT INTO apb_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Oto a Jisas ko te'uri hunie a mwaena, “No ko unue oto huni'o uri si'iri o kei ii'o pe'ieu i Lengi.” ");
INSERT INTO apb_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Ola mala i upui aatowaa aana hai dingena, rodohono e dau haahie ahutana hanue lai hule aana sato e ngara e oolu i aapai sato. ");
INSERT INTO apb_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Na sala paine kire lohea honosie Hahu'ana Leu Maa'i wau i laona Nume Maa'i Peine, e a'ari i denumana. ");
INSERT INTO apb_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Oto a Jisas e si soi aana mei wala paine na ko te'uri, “Mama'a no ko ne'ie mangoku i laona nimemu.” A Jisas e ere mango urine na ko mae oto. ");
INSERT INTO apb_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Oto na'ohana mo ramo ni Rom e uure-uure i leune, maholo e leesie mei olana e rau urine, ko si ere ni ha'ama'unge hunie a God, na ko te'uri, “To'ohuu oto, a mwane ie nga mwane oodota'i.” ");
INSERT INTO apb_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Maholo mwala e loko ngeena kire leesie walu olana e rau, kire ko si meni ooli hunie mo nume ikire pe'i saehuunge oto hiito'o. ");
INSERT INTO apb_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Ta'e mo malahune a Jisas pe'ie mo keni nge kire lulu i sulie a Jisas uure oto i Kalili, kire uure mola wau ha'atau, kire ko ha'a-ha'amaesie nga taa ko reu. ");
INSERT INTO apb_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Na a Josep, mwane aana huilume i Arimatia aana po'o ni henue i Jiudia, ingeie no'one i leune aana maholona. Ingeie mwane diana na e oodota'i, na ko maa-maa'oohie Aalahanga a God kei lae mai. A Josep mwane taane no'one aana pulitaa ni lei-lei mo Jiu, ta'e e ka'a ilenimwa'e ike pe'ie walu ola kire asui'i aana a Jisas. ");
INSERT INTO apb_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Oto a Josep e lae i saana a Paelat, na ko ha'atohue rae aana a Jisas. ");
INSERT INTO apb_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Oto e oohosie mwaanie po'u-po'u, ko si uloa aana mei sala rere'a, na ko lai ne'ie i laona kilipwe'u ingeie. Kilipwe'u ingeie ngeena, kire didie aana hau, na kire ka'a haitolinge'inie ue nga iini i laona. ");
INSERT INTO apb_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Na hai dinge ngeena, Dinge Ni Talama'inge, aana ko seulehi mei na Dinge Maa'i Mo Jiu ko kara'i aehota oto. ");
INSERT INTO apb_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Mo keni nge kire hakusie a Jisas oto uure i Kalili, kire holo maholoi tala mola i sulie a Josep, na kire leesie leu nge kira Josep kire ha'a-enohie rae aana a Jisas i laona kilipwe'u. ");
INSERT INTO apb_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Oto kire aaliho'i i nume, kire ko si deu aakau aana mo ola wasu mangoni hunie lingisi'i i lengine sapena a Jisas. Kire dau-deu aakau taane aana mo rumu wasu mangoni ngeena, ta'e kire ka'a lae lo'u i saana kilipwe'u, aena aana e seulehi oto na Dinge Maa'i Mo Jiu e aehota oto. Oto kire si mamalo mola aana hai dinge laku ngeena i sulie mo Ha'atolanga a Mosis. ");
INSERT INTO apb_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Oto mola i maahu'o-hu'o i ho'owa aana dinge i purine Dinge Maa'i Mo Jiu, mo keni kire lae mai saana kilipwe'u, na kire toolea mai mo ola wasu diana nge kire dau aakau eeni. ");
INSERT INTO apb_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Na kire lio oodoie hau ta'aasilana e lae oto mwaanie maana kilipwe'u. ");
INSERT INTO apb_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Oto kire sili hao i laona kilipwe'u, ta'e kire ka'a lio oodoie ike lo'u rae aana a Jisas Aalaha. ");
INSERT INTO apb_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Maholo kire ko lo'o-lo'onga'i pe'ie taipu'o-pu'onga i sulie nga taa e raune, na e ro mwane kire to'oni aani to'oni rere'a wana-wana kire uure oto pe'ire. ");
INSERT INTO apb_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Oto maholona mo keni kire liotoli oto i aano aana kire ko tohungei me'u hiito'o. Oto e ro mwane ngeena ko te'uri hunire, “?E ue ni omu ko heitalea iini e mauri oto lo'u i matolana mo iini e mae? ");
INSERT INTO apb_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Ingeie ha'ike oto i leu, ta'e e ta'ela'i oto. Omu ke aamasito'o aana nga taa e unue huni'omu maholo na ingeie ue pe'i'omu hai Kalili. Aana e unue uuri, ");
INSERT INTO apb_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","‘Kire kei niieu a Kale Ni Iinoni i laona nimana kira ooraha'aala huni horo maesieu i lengine po'u-po'u, na oolune nga hai dinge ne kei ta'ela'i lo'u.’” ");
INSERT INTO apb_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Oto mo keni kire si aamasito'o aana nga taa a Jisas e unue. ");
INSERT INTO apb_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Oto kire lae mwaanie kilipwe'u, kire ko si lai ha'arongoa aawalai pwaarongoisuli mwana eeta, na ngaeta mo iini lo'u. ");
INSERT INTO apb_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Mo keni nge kire ha'arongoa mo hurula'aa aana nga taa e rau, nge a Meri ni Makdala, na a Joana, na Meri nikana Jemes, na ngaeta mo keni lo'u. ");
INSERT INTO apb_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Ta'e mo hurula'aa kire lo'onga'inie mola uri nga taa mo keni e unue e ka'a rongo ike mala nga mei ola, na kire ka'a hiiwalaimoli ike aada. ");
INSERT INTO apb_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Ta'e a Pita e ta'ela'i, na ko huru oto i saana kilipwe'u. E lae ta'au i aonga'i, na ko leesie mola ta'e sala rere'a nge kire uloa sapena Jisas aana. Oto e si eeliho'i mola pe'i tola ohie nga taa e raune. ");
INSERT INTO apb_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Oto lo'u mola aana hai dingena, ngaeta ro iini aana mwala ko lulu i sulie a Jisas ko lae hunie huilume i Emeas, ola mala aawalai kilomita mwana eeta ha'ataulie i Jerusalem. ");
INSERT INTO apb_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Na kirerue ko lae pe'i ere-ere i sulie walu ola e raune. ");
INSERT INTO apb_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Maholo kirerue ko lae pe'i totola i sulie walu olana, na a Jisas maraana ko lae oto mai saadarue na ko hekusirerue oto. ");
INSERT INTO apb_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Kirerue leesie taane a Jisas, ta'e kirerue ka'a lio saie ike. ");
INSERT INTO apb_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","A Jisas ko te'uri hunirerue, “?Nga taa ni more ko lae pe'i ere-ere i suliena?” Oto kirerue uure hahuroto na maadarue ko rehitou oto. ");
INSERT INTO apb_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Oto ngaeta iini aadarue, iini nge satana a Kleiopas, ko te'uri hunie a Jisas, “!Ha'ike eena! Sa'a mola i'oe oto ta'a-ta'a iini ni Jerusalem nge o ka'a sasaie ike nga taa e rau aana mo dinge e mango haona.” ");
INSERT INTO apb_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Oto a Jisas ko dolosi aadarue uuri, “?Nga mo ola uri taa?” Oto kirerue ko unue uuri, “Mo ola nge kire rau aana a Jisas iini ni Nasaret. A mwaena ingeie nga ha'a-uusuli diana na propet nanama nge a God e ne'isae paine haahie na ahutana mwala kire ha'ama'u aana. ");
INSERT INTO apb_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","21","Oto i'emeelu, melu lo'o-lo'onga'inie uri ingeie ni oto iini kei esuie mwala ni Israel ke ii'o luheta'i mwaanie aalahanga ni Rom. Ta'e mo na'ohai pris na mo aalaha, kire niie oto hunie mo Rom kire ke lei mae aana na kire horo maesie oto i lengine po'u-po'u. Na oolune nga hai dinge uure oto aana mo olana e rau lo'u ie. ");
INSERT INTO apb_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Oto ngaeta mo keni aameelu ko si ladoa lo'u mo ola ni pangata'inge uri kire ha'ahu'olie kilipwe'u, ");
INSERT INTO apb_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","ta'e kire ka'a lio oodoie ike rae aana i laona. Mo keine kire aaliho'i mei, oto kire ko unue uri kire leesie mo ensel e haata'i hunire, na mo ensel ngeena kire unue uri a Jisas e mauri lo'u. ");
INSERT INTO apb_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Ngaeta mo iini aameelu kire lae no'one i saana kilipwe'u, na kire lio oodoie oto mala mo keni e unue ka'u. Ta'e kire ka'a leesie ike a Jisas.” ");
INSERT INTO apb_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Oto a Jisas ko te'uri hunirerue, “!Mwae! More tohungei pweu na more ka'a sai lio saie ike nga taa e to'ohuu lau-leu. E malisine uri more ke hiiwalaimoli oto aana mo ola mo propet kire unu'i. ");
INSERT INTO apb_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Aana kire unue uri a Kraes kei saro sapesalu na kei mae oto urine, nge ke si lai ii'o aana manikuluha'ana.” ");
INSERT INTO apb_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Oto a Jisas ko aehota luhesie hunirerue mo ola uusuleni e lae i sulie maraana i laona mo Ha'atolanga a Mosis lae hule aana mo Uusu-uusu Maa'i mo propet. ");
INSERT INTO apb_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Maholo kiraelu lae mai kara'inie huilume nge kirerue ko lae huniena, oto a Jisas ko deu uri ke liu tara'asi mola mwaanirerue. ");
INSERT INTO apb_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Ta'e kirerue haaraie, kire ko te'uri, “Kolu ke ii'o ka'u i leu aana ko seulehi oto, na kara'inie ke rodo oto.” Oto a Jisas e si lae na ko ii'o oto pe'irerue aana nume kirerue ii'o aana. ");
INSERT INTO apb_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Oto maholo kiraelu ii'o i aano huni ngeu, a Jisas e hele aana ho bred na ko ere ni paalahenga haahie. Oto e nisie, ko si niie hunirerue. ");
INSERT INTO apb_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Oto aana maholoi satona, maadarue e si taha na kirerue ko lio saie oto a Jisas. Ta'e e tolana waa lo'u mola mwaanirerue. ");
INSERT INTO apb_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Oto kirerue ko si ere hailiu hunirerue uuri, “!Mwae! Maholo nge e ere-ere hunikure i sulie tala na e luhesie lo'onga'inge i laona mo Uusu-uusu Maa'i, e tohungei rongo hai sai'i oto.” ");
INSERT INTO apb_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Oto kirerue ko tolana ta'ela'i oto aana maholona, na kirerue ko eeliho'i oto hunie i Jerusalem. Kirerue lae ta'au na kirerue ko lio oodoie aawalai pwaarongoisuli mwana eeta pe'ie ngaeta mwala lo'u kire loko. ");
INSERT INTO apb_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Oto kire ko hola'i ha'arongorarue uuri, “A Aalaha e ta'ela'i oto to'ohuu na e haata'i hunie a Saemon.” ");
INSERT INTO apb_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Oto kirerue ko ladoa lo'u nga taa e rau i sulie tala, na aana kirerue lio saie a Jisas maholo e nisie ho bred. ");
INSERT INTO apb_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Maholo kirerue ko ha'a-ha'arongora aana mo olana, na a Jisas maraana e uure oto i matolada na ko te'uri, “Hanuelamanga ke ii'o pe'i'omu.” ");
INSERT INTO apb_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Oto kire apara'i na kire ko tohungei me'u oto, aana kire lo'onga'inie uri kire ko leesie aakalo. ");
INSERT INTO apb_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Ta'e a Jisas e te'uri hunire, “?E ue ni omu ko lae otoi me'u hiito'o urine? ?Na e ue ni saemiu ko rue-rua'a? ");
INSERT INTO apb_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Omu ke leesie ka'u e ro nimeku na e ro ae'aeku. Ineu taane ni ie. Omu ke hele ka'u i sapeku hunie omu ke saie, aana aakalo ka'a to'o hasi'o ike na ka'a to'o suisuli ike, mala omu ko leesi'i eeku ie.” ");
INSERT INTO apb_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","E ere urine mango, ko si haata'inie e ro nimana na e ro ae'aena aada. ");
INSERT INTO apb_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Kire ko tohungei pangata'i na kire ko ilenimwa'e oto liutaa, ta'e ma'alana e urine na kire ka'a hiiwalaimoli ike ue aana. Oto a Jisas ko dolosi aada uuri, “?Omu to'o aana nga mei ola ni nga i leu?” ");
INSERT INTO apb_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Oto kire ko niie mei ii'e maado'o hunie, ");
INSERT INTO apb_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","na e hele aana, ko si ngaa i maada huni haata'inie uri ingeie nga aakalo ha'ike. ");
INSERT INTO apb_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Oto ko te'uri hunire, “Mei ola nge e rau eeku ngeena, nou unu mangoa oto oodoi'omu maholo nge nou o'o'o ue pe'i'omu. Aana nou unue uri ahutana walu ola uusuleni e lae i sulieu i laona Ha'atolanga a Mosis na aana mo Uusu-uusu Maa'i mo propet na aana Puke ni Kana, kire kei saronai oa mango.” ");
INSERT INTO apb_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Oto a Jisas e si tahanie manatada hunie kire ke lio saie mo Uusu-uusu Maa'i. ");
INSERT INTO apb_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Na ko te'uri hunire, “Uusulana e lae oto uurini. A Kraes kei saronai sapesalu na kei saronai ta'ela'i lo'u mwaanie maenga aana oolune nga hai dinge. ");
INSERT INTO apb_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","48","Kire unue no'one uri mei wala i sulieu ke lae hunie ahutana mo iinoni ni welumalau ke aali'u takoie God hunie ke sae'aasie mo ooraha'aa ikire. Oto omu ke lai ha'arongoa mwala aana walu olana, aehota mai i Jerusalem, lae hule aana ahutana mo komu ni welumalau. ");
INSERT INTO apb_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Na ineu maraaku, ne ke si uusunge'inie mai haahi'omu nga taa nge Aamaku e haiholota'inie. Ta'e omu ke ii'o ka'u i Jerusalem hule aana omu kei hele aana nanamanga ngeena uure i Lengi.” ");
INSERT INTO apb_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Oto a Jisas e toolera ta'au mwaanie i Jerusalem hule i hoorana huilume i Betani, e si susue'inie e ro nimana, ko ha'adiana'ara. ");
INSERT INTO apb_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Maholo ko ere-ere ni ha'adiana'ara ue, na ko oopa oto mwaanire aana a God e tahela'inie oto ta'au i Lengi, ");
INSERT INTO apb_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","na kire ko mani pouruuru ni ha'ama'unge aana. Oto kire si eeliho'i pe'ie saemangonga oto liutaa ta'au i Jerusalem. ");
INSERT INTO apb_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Na kire si ii'o mola suli maholo ta'au i Nume Maa'i Peine pe'i paalahelana God. ");
INSERT INTO apb_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Aana aehotalana walu ola na walumalau ha'ike ue, a mei Wala e pwani ii'o oto, na a mei Wala ngeena oto i saana God, na a mei Wala ngeena ingeie tohungei God oto no'one. ");
INSERT INTO apb_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Ingeie oto i saana God uure i aehotalana. ");
INSERT INTO apb_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Ha'aholalana ta'ena nga ola e si lae no'one mola aana. Nga ta'a-ta'a mei ola nge ha'aholalana e lae, e ka'a lae ike aaho'a aana. ");
INSERT INTO apb_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","A mei Wala ngeena oto aahu'ine maurihe, na maurihe ngeena oto raa-raa hunie mo iinoni aana walumalau. ");
INSERT INTO apb_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","A Raa-raa ngeena ko raa i laona rodohono, na rodohono e ka'a a'aila'a ike liutaa aana hunie ke mwa'asie. ");
INSERT INTO apb_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Oto a God e uusunge'inie nga mwane satana a Jon. ");
INSERT INTO apb_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Na ingeie ienini, e lae mai huni ha'arongoa mwala aana a Raa-raa ngeena, hunie kire ke mani rongoa tataroha aana, na kire ke hiiwalaimoli aana. ");
INSERT INTO apb_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","A Jon maraana, ingeie a Raa-raa ngeena ha'ike, ta'e e lae mola mai huni ere i sulie a Raa-raa ngeena. ");
INSERT INTO apb_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","A Jon e unue uri a tohungei Raa-raa ko lae oto mai laona walumalau, na ingeie oto kei raangie ahutana iinoni i laona walumalau. ");
INSERT INTO apb_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","A mei Wala ngeena e lae oto mai i laona walumalau, na ha'aholalana walumalau e lae taane oto aana, ta'e walumalau e ka'a manata'inie ike. ");
INSERT INTO apb_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Ma'alana tohungana mwala ingeie mo Jiu, ta'e kire ka'a takuhie ike. ");
INSERT INTO apb_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Ta'e ngaeta mo iini kire takuhie taane, na kire hiiwalaimoli oto aana. Oto e asuie uri ikire oto, kire ke ne'ie mo kalena God. ");
INSERT INTO apb_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Kire ka'a ne'i kalena God ike aana hutanga nge e uure mwaanie hari-huninge ni sape i sulie tolaha ni iinoni, ta'e kire hute haalu oto aana God maraana. ");
INSERT INTO apb_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","A mei Wala ngeena e lae oto mai na e ne'i iinoni. E o'o'o oto i matolameelu na melu leesie oto manikuluha'ana, mei menikulu'anga oto paine aena aana ingeie oto ta'a-ta'a mwela moute'i a God. Ingeie oto ko niie ahutana hahu'ana manata-diananga a God hunikie, na ko unu-unue ahutana walaimolinge a God hunikie. ");
INSERT INTO apb_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","A Jon e ere i sulie a mei Wala ngeena, na e soi oto paine uuri, “Iini nge nou ere-ere rarangana ka'u ienini, nge nou unue uuri ‘Iini kei lae mai sulieu e paine lo'u liutaa aaku, aana ingeie e pwani ii'o oto na ineu nou ka'a hute ue.’” ");
INSERT INTO apb_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Oto aena aana e tohungei honu aana manata-diananga na walaimolinge, nge ko nii-niie mai ngaeta mo niinge diana lo'u hunie ke oolisie niinge diana wau i na'o ngeena. ");
INSERT INTO apb_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Aana waite a God e niie mo Ha'atolanga hunie a Mosis hunie ke he'i nii'i lo'u hunie mwala, ta'e a Jisas Kraes maraana ko niie mai manata-diananga na walaimolinge hunikie. ");
INSERT INTO apb_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Nga ta'a-ta'a iini e ka'a leesie ike ue a God. Ta'e ta'a-ta'a mwela moute'i ingeie ko o'o'o pe'ie Aamana, na aana ingeie tohungei God no'one, ingeie oto e haata'i diana aana a God hunikie. ");
INSERT INTO apb_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Oto laladonga i sulie laeliwalanga a Jon e lae uuri. Mo na'ohai mwane ni Jiu i Jerusalem kire uusunge'inie ngaeta mo pris na ngaeta mo iini aana komu a Livae i saana Jon huni dolosi aana uuri, “?A tei ni i'oe? ?Mwaanie ohe i'oe a Kraes?” ");
INSERT INTO apb_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Oto a Jon e ka'a eero ike, ta'e e tola tahanga'inie mola uuri, “Ineu a Kraes ha'ike.” ");
INSERT INTO apb_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Oto kire ko he'i dolosi lo'u aana uuri, “?Oto i'oe a tei ke'u? ?Wa ohe i'oe a Propet Elaeja?” Oto a Jon ko aalamire mola uuri, “Ineu ha'ike.” Oto kire ko dolosi lo'u aana uuri, “?Mwaanie ohe i'oe oto propet paine mala a Mosis nge emi ko maa-maa'oohie?” Oto ko aalamire lo'u uuri, “Ha'ike no'one.” ");
INSERT INTO apb_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Aena urine kire ko si te'uri hunie, “?Oto i'oe nga iinoni uri taa ka'u? O ke unu diana aana oodoi'emeelu hunie melu ke lai ha'arongoa mo iini kire uusunge'ini'emeelu mei.” ");
INSERT INTO apb_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Oto a Jon e si aalamire mola aana walana Propet Aesaea uuri, “Ineu ka'u oto iini ko soi-soi peine i laona hanuesala uuri, ‘Omu ke ha'a-oodohie tala loosie laenga mai a Aalaha.’” ");
INSERT INTO apb_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Oto mo iini aana pulitaa ngeena nge ikire mo Parise kire uusunge'inire mai ngeena, ");
INSERT INTO apb_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","kire ko si dolosi aana a Jon uuri, “?Mala uri i'oe a Kraes ha'ike wa a Elaeja wa a propet paine ngeena, na e ue ka'u o ko loo-loto maa'i oto aana mwala?” ");
INSERT INTO apb_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Oto a Jon ko aalamire uuri, “Ineu, nou to'o aana nanamanga taane huni loto maa'i aana mwala aani wei. Ta'e nga iini omu ka'a lio saie ike uri ingeie a tei, ingeie taane mola i matolakaelu. ");
INSERT INTO apb_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Ingeie oto iini nge no ko deu aakau aana tala loosie, na ingeie oto e tohungei peine lo'u liutaa aaku, hule aana ineu, na nou ka'a diana ike malisine ne ke asu mala koni-konihe huni luhesie ho'ohaahi'ae ingeie.” ");
INSERT INTO apb_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Walu erenga ienini kire rau oto wau aana leu a Jon e loto maa'i aana, nge e kara'inie huilume i Betani po'o wau hatarie sato pwaa aana wai i Jodan. ");
INSERT INTO apb_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Oto hai dinge lo'u mola i purine, a Jon e leesie a Jisas ko lae mai saana, oto ko si te'uri, “!Lio ka'u! A mwane ngeena, ingeie oto Kalei Sipu a God, aena aana ingeie ni ko ta'aasie ooraha'aa aana walumalau. ");
INSERT INTO apb_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Iini nge nou ere-ere i sulie ka'u oto ngeena, aana maholo nou unue uuri, ‘Nga iini kei lae mai sulieu, ta'e ingeie e paine lo'u liutaa aaku aana ingeie e pwani ii'o oto na ineu nou ka'a hute ue.’ ");
INSERT INTO apb_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Ineu na nou ka'a saie ike no'one hola'ina'o uri ingeie a tei. Ta'e ma'alana e urine nou lae pe'i loo-loto maa'i aana mwala mola aani wei loosie maholo kei hule, hunie uri mwala ni Israel kire ke si lio saie uri ingeie a tei maholo ko hule ngeena.” ");
INSERT INTO apb_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","33","Oto a Jon ko si unu tahanga'inie hunie mwala uuri, “A God e uusunge'inieu mei huni loto maa'i aana mwala aani wei loosie iini nge kei lae ue mai. Aana maholona, ineu nou ka'a sai diana aana ike ue uri ingeie a tei. Ta'e a God e unue hunieu uuri, ‘Iini o ko leesie Li'oa Maa'i ko siho i lengine na ko ii'o oto i lengine, ingeie otona iini kei loto maa'i aana mwala aana Li'oa Maa'i.’ Oto no ko unu tahanga'inie uri ingeie oto mwane nou leesie Li'oa Maa'i e siho mai uure i Lengi oto mala hiroikuu na e ii'o oto i lengine. ");
INSERT INTO apb_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Nou leesie oto, na no ko unue oto huni'omu uri ingeie oto Kalena God.” ");
INSERT INTO apb_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Oto hai dinge lo'u i sulie, a Jon e uure lo'u weu i leune pe'ie ngaeta ro pwaarongoisuli ingeie. ");
INSERT INTO apb_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Maholo e leesie a Jisas ko tapaliu oto ko te'uri hunie e ro mwaena, “!Lio ka'u! Kalei Sipu a God, ka'u oto waune.” ");
INSERT INTO apb_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","E ro pwaarongoisuli ngeena e rongoa a Jon ko ere urine, oto kirerue aali'u, kirerue ko lulu i sulie oto a Jisas. ");
INSERT INTO apb_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","A Jisas e aali'u na ko leesie e ro mwane ko lae i sulie. Oto ko dolosi aadarue uuri, “?Nga taa more saeto'o aana?” Oto kirerue ko aalamie uuri, “?O ko o'o'o i tei, Rabae?” (Mei wala “Rabae” ngeena, ngaeta mei wala aana erenga mo Jiu, lo'onga'inge aana uri “Ha'a-uusuli.”) ");
INSERT INTO apb_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Oto a Jisas ko te'uri hunirerue, “More ke lae mai na more ke leesie oto maraamore'i.” E ere urine mola hunire ola mala maholo sato e ngara aawala haahuu i ho'owa aana hai dingena. Oto kirerue si lae pe'ie hunie leu nge ko o'o'o aana, na kirerue ko ii'o oto pe'ie aana hai dinge ngeena. ");
INSERT INTO apb_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Ngaeta mwane aana e ro mwane ngeena, a Andru, aasine a Saemon Pita. ");
INSERT INTO apb_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Oto a Andru ko tolana lo'ohie oto aasine, a Saemon, na ko ha'arongoa oto uuri, “Mere lio oodoie oto a Mesaea.” (Mei wala “Mesaea” ngeena, ngaeta mei wala aana erenga mo Jiu, lo'onga'inge aana uri “Kraes,” iini nge a God e haiholota'i ni uusunge'inie mai huni ha'a-uurie walumalau.) ");
INSERT INTO apb_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Oto a Andru e toolea Saemon i saana Jisas. A Jisas e to'omaaie a Saemon, e si te'uri, “I'oe oto a Saemon kalena Jon, ta'e haara'inilemu kei lae oto aana a Sipas.” (Satai ola aana erenga mo Jiu ngeena e sada mola pe'ie satai Pita aana erenga ni Krik, na lo'onga'inge aana uri “a Hau” aana a Jisas e saie uri a Pita kei ne'ie mwane kei uure ma'uta'a diana mala hau e susu.) ");
INSERT INTO apb_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Oto hai dinge lo'u i sulie, a Jisas e ne'isae huni lae hao i Kalili. E lio oodoie a Pilip, oto ko te'uri hunie, “O ke lae mai lulu i sulieu.” ");
INSERT INTO apb_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","A Pilip ingeie mwane ni Betsaeda, huilume no'one a Andru na Pita. ");
INSERT INTO apb_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Oto a Pilip e lae haitalea a Nataniel, ko si te'uri hunie, “Melu lio oodoie oto a Kraes nge a Mosis e uusu-uusu i sulie i laona uusu-uusu aana mo Ha'atolanga, na mo propet no'one kire uusu-uusu i sulie. Ingeie oto a Jisas ni Nasaret, kalena a Josep.” ");
INSERT INTO apb_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Oto a Nataniel ko dolosi aana uuri, “!Ha'ike eena! ?Uri nga mei ola diana uri taa ni kei uure mai mwaanie i Nasaret?” A Pilip ko aalamie uuri, “Lae mai na o ke leesie oto maraamu.” ");
INSERT INTO apb_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Maholo a Jisas e leesie a Nataniel ko lae mai takoie, ko si ere oalana uuri, “A mwane ie tohungei mwane ni Israel to'ohuu nge e sa'a hahu'ei eeroa ike nga iini.” ");
INSERT INTO apb_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Oto a Nataniel e dolosi aana Jisas uuri, “?O manata'inieu ke'u uri taa?” A Jisas e aalamie uuri, “Nou leesi'o ka'u weu i ae'aena ai fik, na a Pilip e ka'a soi'o ue.” ");
INSERT INTO apb_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Oto a Nataniel ko si te'uri hunie a Jisas, “!Poro paine, i'oe oto Kalena God! !I'oe oto inemauri nana mo Israel!” ");
INSERT INTO apb_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Oto a Jisas ko dolosi aana a Nataniel uuri, “?Uri o ko hiiwalaimoli mola aena aana nou unue huni'o uri nou leesi'o i mamalutana ai fik ngeena? O kei leesie taane mo ola paine lo'u liutaa aana leu ienini.” ");
INSERT INTO apb_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Na ko he'i unue lo'u hunire uuri, “No ko unue oto to'ohuu huni'omu uri omu kei leesie mo ola paine lo'u liutaa, hule aana omu kei leesie i Lengi kei taha na mo ensel a God ko walo-waloliu ta'au na mai aano i seeku a Kale Ni Iinoni.” ");
INSERT INTO apb_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Oto lo'u mola i purine e ro hai dinge e mango, ngaeta ngauhe aana ha'arurunge e rau aana huilume i Kena aana po'o ni henue i Kalili. Nikana Jisas no'one i leune, ");
INSERT INTO apb_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","na kire ha'arongoa mai no'one a Jisas na mo pwaarongoisuli ingeie hunie ngauhe ngeena. ");
INSERT INTO apb_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Oto i sulie tolahada, kire ko inu-inu waen aana ngauhe aana ha'arurunge, na lae-lae waen ikire e mango oto. Oto maholo waen ikire e mango, nge nikana Jisas ko si te'uri hunie, “Waen e mango oto mwaanire.” ");
INSERT INTO apb_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Oto a Jisas ko aalamie uuri, “?Hunie kure ke ue ka'u, Teite, na e ka'a hule ue aana maholo ineu hunie ne ke haata'inie manikuluha'aku?” ");
INSERT INTO apb_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Ta'e a nikana e unue mola hunie mo koni-konihe uuri, “Nga mei taa ko unue huni'omu, omu ke dau mola i sulie.” ");
INSERT INTO apb_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Na i sulie tolahana mo Jiu huni hodalie walu ola hunie mauriha'ada ke maa'i, kire ne'ie e oono ho ate'a hau peine i leune. Na kire mani adona ola mala tangalai lita aani wei nga hue. ");
INSERT INTO apb_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Oto a Jisas ko te'uri hunie mo koni-konihe, “Omu ke dedeie mo ho ate'a ngeena aani wei.” Oto kire dedei'i na kire mani honu makeato oto. ");
INSERT INTO apb_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Oto a Jisas ko te'uri lo'u hunie mo koni-konihe, “Omu ke taluhie nga leu mwaanie ngaeta ho ate'a, na omu ke toolea hunie na'ohai koni-konihe nge ko lio i sulie mo ngeulaa aana ngauhe.” Oto kire si toolea kao-kao ngeena hunie. ");
INSERT INTO apb_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Maholo na'ohai koni-konihe e mami aahongana, na wai ngeena e ne'i waen oto. A porona e ka'a saie ike uri waen ngeena e uure i tei, ta'e mo koni-konihe ha'alaa kire saie. Oto na'ohai koni-konihe ngeena e soie poro haalu, ");
INSERT INTO apb_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","ko si te'uri hunie, “No ko tohungei pangata'ini'o, aana ta'ena nga iinoni lo'u, kire ko hola'i nii-niie ka'u tohungei waen diana ana mwala. Oto maholo mwala kire inu hiito'o oto, nge kire ko si niie lo'u waen nge e ka'a tohungei diana ike ngeena. Ta'e i'oe, tohungei waen diana ienini o ko si lae pe'i niie mai puri.” ");
INSERT INTO apb_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Eetana nga mei tolimaa aana nanamanga a Jisas ienini, e asuie i Kena aana po'o ni henue i Kalili. I leune e haata'inie manikuluha'ana, nge mo pwaarongoisuli ingeie e si hiiwalaimoli aana. ");
INSERT INTO apb_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","I purine ngauhe aana ha'arurunge ngeena e mango, e si lae hunie i Kapaneam pe'ie nikana, na mo eesine mwane kire mani hute, na mo pwaarongoisuli ingeie. Oto kire ii'o lo'u i leune hunie ngaeta mo hei dinge. ");
INSERT INTO apb_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Maholona ko kara'inie mone oto hai dinge paine ikire mo Jiu huni esuie Houlaa Ni Liumwaanie, oto a Jisas e hanetaa ta'au i Jerusalem. ");
INSERT INTO apb_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","E lae ta'au i Nume Maa'i Peine na ko leesie mwala ko ha'aholinge'inie mo ola mauri hunie mo uuraa'inge. Mwala ko ha'aholinge'inie mola mo puluke na mo sipu na mo hiroikuu ta'au i laona lolata aana Nume Maa'i Peine. Na mwala nge kire ko ooli-oolisi to'oha aana mo henue hai aaopa'i hunie to'oha ikire mo Jiu, kire ii'o oto no'one ta'au i sulie mo taetahe ikire. ");
INSERT INTO apb_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Oto a Jisas e asuie nga ola huni reu-repu aana iieli walo, ko si oohe aasie mo puluke na mo sipu ngeena mwaanie lolata aana Nume Maa'i Peine. Na ko korasie oto mo to'oha mwala ko ooli-oolisi to'oha ngeena, na ko pwelusie oto mo taetahe ikire i aano. ");
INSERT INTO apb_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Oto a Jisas ko te'uri hunie mo iini ko ha'a-ha'aholi hiroikuu, “!Omu ke ta'aasie mo ola ienini mwaanie i leu! !Omu ko tohungei waelie mola nume Aamaku, aana omu ko da ko ne'i leu ni ha'aholi!” ");
INSERT INTO apb_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Maholo nge a Jisas e ere urine, mo pwaarongoisuli ingeie ko si aamasito'o aana Uusu-uusu Maa'i e unue uuri, Ne'isaenga paine haahie nume i'oe God, ko weru oto mala dunge i manataku. ");
INSERT INTO apb_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Oto mo mwane paine mo Jiu kire lae mai saana Jisas, kire ko si te'uri hunie, “?Nga hu'i-hu'ite uri taa o sai esuie mala nga tolimaa huni haata'inie aameelu uri o to'o aana nanamanga huni esuie leune?” ");
INSERT INTO apb_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Oto a Jisas e aalamire mola uuri, “Mala uri omu kei ohoie Nume Maa'i ienini i aano, ta'e ineu ne kei ta'e aaliho'i aana lo'u mola aana e oolu aata hai dinge.” ");
INSERT INTO apb_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Oto kire ko te'uri, “!Ha'ike eena! E hai aawalai helisi mwana oono nge mwala kire tohue Nume Maa'i Peine ie i suli'i. ?Oto uri i'oe o kei ta'ea lo'u mola aana e oolu aata hai dinge?” ");
INSERT INTO apb_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Ta'e nume maa'i nge a Jisas e ere rarangana uri sapena mola maraana ni ngeena. ");
INSERT INTO apb_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Oto maholo e ta'ela'i mwaanie maenga, nge mo pwaarongoisuli ingeie kire si aamasito'o aana e ere urine. Na kire si hiiwalaimoli aana mo Uusu-uusu Maa'i na oto aana mei wala nge a Jisas e unuena. ");
INSERT INTO apb_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Oto aena aana a Jisas e haata'inie mo tolimaa aana nanamanga ingeie maholo e o'o'o i Jerusalem aana Houlaa Ni Liumwaanie ngeena, mwala oto hunge kire hiiwalaimoli uri ingeie oto a Kraes, iini kire ko maa-maa'oohie. ");
INSERT INTO apb_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Ta'e a Jisas e ka'a tohungei noruto'o ike aada, aena aana e saie mone tolahana ahutana iinoni. ");
INSERT INTO apb_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Oto ma'alana nga iini e ka'a unue lo'u tolahana mwala oodoie, ta'e ingeie e saie mola nga taa i laona manatada. ");
INSERT INTO apb_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Oto ngaeta na'ohai mwane haahie mo Jiu nge satana a Nikodimas, na ingeie no'one aana pulitaa mo Parise, ");
INSERT INTO apb_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","e lae mai saana Jisas aana ngaeta hai rodo, oto ko te'uri, “Ha'a-uusuli, melu leesie tolimaa aana mo hu'i-hu'ite o ko esui'i ngeena, na melu manata'inie uri i'oe nga ha'a-uusuli uure oto mwaanie a God. Aana nga ta'a-ta'a iinoni e sa'a roro'a ni esuie ike mo hu'i-hu'ite o ko esui'i ngeena, na uri a God ka'a pe'ie.” ");
INSERT INTO apb_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Oto a Jisas ko aalamie ko te'uri, “No ko unue oto to'ohuu huni'o uri nga ta'a-ta'a iinoni e sa'a roro'a ni lio mangine Aalahanga a God na e ka'a hute haalu lo'u.” ");
INSERT INTO apb_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Oto a Nikodimas ko te'uri hunie a Jisas, “?Nge iinoni e repo oto, kei hute uri taa lo'u? ?Uri kei sili eeliho'i lo'u iiana nikana hunie ke si hute ha'arue lo'u?” ");
INSERT INTO apb_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Oto a Jisas ko aalamie uuri, “No ko unue oto to'ohuu huni'o uri mala nga iini e ka'a hute aani wei na lo'u aana Li'oa Maa'i, nge e sa'a roro'a ni sili ike i laona Aalahanga a God. ");
INSERT INTO apb_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Iini nge e hute mola aani iinoni, nge ingeie kei to'o aana mauringe no'one mola mala iinoni. Ta'e iini e hute aana Li'oa Maa'i a God, nge ingeie kei to'o aana maurihe oto mala ngaeta kalena God. ");
INSERT INTO apb_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","O ke su'uri papangata'i aana no ko unue huni'o uri omu ke haro hute haalu lo'u ha'alaa. ");
INSERT INTO apb_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Li'oa Maa'i a God e urihana iiru nge ko ooru-ooru mola aana ta'ena nga leu i sulie saena. O ko rorongoa taane aawa-aawatana, ta'e o ka'a saie ike uri e uure mai i tei, wa ko lae pwau i tei. E urine no'one maholo Li'oa Maa'i a God ko niie maurihe huu nana nga iini, aana o ka'a saie e rau uri taa, ta'e o si saie mola uri e to'ohuu.” ");
INSERT INTO apb_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Oto a Nikodimas ko dolosi uuri, “?Ha'alaa leune kei reu uri taa eena?” ");
INSERT INTO apb_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","A Jisas ko aalamie ko te'uri, “!Ha'ike eena! I'oe oto ha'a-uusuli peine i Israel. ?Oto e ue ka'u o ka'a lio saie leune? ");
INSERT INTO apb_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","No ko ere to'ohuu oto huni'o uri melu ko ere oto i sulie nga taa melu manata'inie, na melu ko unu tahanga'inie oto oodoi'omu nga taa melu leesie. Ta'e nga iini eemiu e ka'a sare hiiwalaimoli ike mola aana. ");
INSERT INTO apb_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","?Mala uri omu ka'a hiiwalaimoli oto aaku aana no ko ere i sulie mo ola ko reu-reu mei aano i leu, omu ke si hiiwalaimoli eeku uri taa eena aana uri ne kei ere i sulie mo ola ko reu ta'au i Lengi? ");
INSERT INTO apb_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Aana nga ta'a-ta'a iini aaopa lo'u e ka'a lae ike ue ta'au i Lengi hunie ke ha'arongo'omu aana, mwaanieu a Kale Ni Iinoni nge nou uure ta'au i Lengi. ");
INSERT INTO apb_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","“Oto i na'o maholo mo mwaa ala-ala oto hunge kire ko alaie mo Israel i laona hanuesala, a God e unue hunie a Mosis ke asuie mwaa aana bras hunie ke ta'ea i lengi pe'ie hai ei. Oto ta'ena nga iini ko lio takoie, nge ha'a-uurilana ko lae oto. Nge e urine no'one aana ineu a Kale Ni Iinoni, kire kei ta'eau i lengi pe'ie hai ei, ");
INSERT INTO apb_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","uri hunie ta'ena nga iini ko hiiwalaimoli eeku kei helesie maurihe huu.” ");
INSERT INTO apb_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","A God e tohungei manata diana hunie walumalau, hule aana e uusunge'inie ta'a-ta'a mwela moute'i ingeie ke mae oalana, hunie ta'ena nga iini ko hiiwalaimoli aana ke su'uri ei'aa, ta'e ke helesie maurihe huu i tehula'ana. ");
INSERT INTO apb_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Aana a God e ka'a uusunge'inie ike a Kalena i laona walumalau hunie ke leie walumalau, ta'e hunie ha'a-uurilana walumalau ke lae aana. ");
INSERT INTO apb_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","A tei nge ko hiiwalaimoli aana a Kale, leilana e sa'a lae ike. Ta'e a tei nge e ka'a sare hiiwalaimoli aana, nge leilana e pwani lae oto, aena aana e ka'a hiiwalaimoli ike aana ta'a-ta'a mwela moute'i a God. ");
INSERT INTO apb_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Na leilada kei lae mola aena aana raa-raa e lae oto mai laona walumalau, ta'e kire hari hunie mola rodohono liutaa aana raa-raa, aena aana helelada e tata'ala. ");
INSERT INTO apb_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Mo iini helelada e tata'ala kire tohungei leledie raa-raa, aena aana kire sere'inie uri haata'inilana mo tata'alanga ikire ke lae haada'i. ");
INSERT INTO apb_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Ta'e iini nge helelana e diana aana ko eu'esuie mo ola aana walaimolinge hali'ite, nge ingeie e saeto'o aana raa-raa, aena aana raa-raa ko haata'inie uri a God ni ko pe'ie huni esuie ahutana mo esunge ingeie. ");
INSERT INTO apb_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Oto puriha'ana, a Jisas na mo pwaarongoisuli ingeie kire si lae wau mwaanie mo huilume na kire o'o'o ka'u weu aana po'o ni henue i Jiudia i leune ha'ataulie mo huilume. Oto mwala ko si lae mai i saada, na kire ko lae pe'i loto maa'i aana mwalana. ");
INSERT INTO apb_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","24","Na aana maholona, a Herod e ka'a ne'ie ike ue a Jon Loto Maa'i i nume ni ho'o, ta'e a Jon ko lae ue pe'i loo-loto maa'i aana mwala i laona mo lama i Aenon kara'inie huilume i Salim, aena aana mo huulaa ni wei e hunge i leune. Mwala oto hunge kire ko lae oto mai saana, na e loto maa'i oto aada. ");
INSERT INTO apb_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Oto erenga haitapali ko aehota lae oto i matolana mo pwaarongoisuli a Jon na ngaeta mwane ni Jiu haahie mo Ha'atolanga a Mosis i sulie ha'ahili-hilinge aani lotonga rere'a. ");
INSERT INTO apb_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Lae-lae, kire lae mai i saana Jon na kire ko ha'arongoa uuri, “?Ha'a-uusuli, o saie mwane nge e o'o'o pe'i'o i reune wai i Jodan aana aapa po'o wau, nge o ere-ere i sulie? A mwaena ko loo-loto maa'i oto, na ahutana mwala ko meni lae oto i saana.” ");
INSERT INTO apb_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Oto a Jon ko aalamire uuri, “Ta'ena nga ola nga iini e to'o aana, e to'o aana mola aena aana a God ta'au i Lengi e niie nana. Oto nou sa'a saehanalie ike asunge a porona, wa ne ke upwesie mwala nge kire ko lae oto i saana. ");
INSERT INTO apb_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","I'omu maraamiu omu rongoa ka'u oto aana nou unue uri Ineu a Kraes ha'ike, ta'e ineu iini a God e uusunge'inieu mola huni deu aakau aana tala loosie a Kraes ni ie. ");
INSERT INTO apb_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Maholo ha'arurunge ko lae, a poro haalu oto iini nge ko to'o keni. Ta'e tohungei malahune poro haalu ngeena nge e na'ona laeha hunie tola-keninge, ingeie ko si ilenimwa'e mola haahie ha'arurunge a poro haalu ngeena. Oto ineu domana malahune poro haalu ngeena, na ilenimwa'enga ineu ko lae mola mai oa urine. ");
INSERT INTO apb_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Ingeie ke pai-peine oto, na ineu ne ke mwai-mwei oto.” ");
INSERT INTO apb_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Iini nge e lae mai uure ta'au i Lengi, ingeie oto e paine liutaa aana ahutana mwala. Iini nge e uure mola mai mwaanie walumalau mai aano i leu, iini oto mai aano eena aana walumalau, na ko ere-ere mola i sulie walu ola ko reu-reu mai aano aana walumalau ie. Ta'e iini nge e lae mai uure ta'au i Lengi, ingeie oto e paine haahie ahutada mango. ");
INSERT INTO apb_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","E uure ta'au i Lengi na ko unu-unu tahanga'inie mo ola e leesi'i na e rongo'i, ta'e toota'i iini mola kire hiiwalaimoli lo'u aana walana. ");
INSERT INTO apb_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Ta'e mo iini nge kire ko hiiwalaimoli aana walana, kire haata'inie uri kire hiiwalaimoli aana nga taa a God e unue e tohungei to'ohuu. ");
INSERT INTO apb_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Aana iini nge a God e uusunge'inie mai uure ta'au i Lengi ngeena ko unu-unue walana God oto tarau, aena aana a God e nii ta'ingelu aana Li'oa Maa'i ingeie oto hunie. ");
INSERT INTO apb_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","A Mama'a e manata diana hunie a Kalena, na e niie ahutana walu ola mango oto i laona nimana huni lio i suli'i. ");
INSERT INTO apb_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Oto iini ko hiiwalaimoli aana a Kale e hele aana oto maurihe huu eena. Ta'e iini nge e ka'a hiiwalaimoli ike aana a Kale, e sa'a roro'a ni hele aana oto maurihe ngeena, ta'e kei ii'o huu oto i mamalutana saewasunge a God. ");
INSERT INTO apb_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Oto mo Parise kire rongoa uri mo iini hunge ko lulu i sulie oto a Jisas, na ko loto maa'i oto aada, na hule aana kire hunge oto liutaa aana mo iini kire ko pwaarongo i sulie a Jon Loto Maa'i. ");
INSERT INTO apb_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(Ta'e a Jisas maraana e ka'a loto maa'i ike aana mwala. Mo pwaarongoisuli ingeie ni mola kire ko esuie loto-maa'inge.) ");
INSERT INTO apb_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Oto maholo a Jisas e manata'inie uri mo Parise kire rongo oto urine, e si ta'ela'i mwaanie po'o ni henue i Jiudia na ko eeliho'i oto hunie po'o ni henue i Kalili. ");
INSERT INTO apb_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Na tala hunie i Kalili ngeena e liu i laona po'o ni henue i Samaria. ");
INSERT INTO apb_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Oto a Jisas ko si hule i Samaria aana huilume satana i Saeka. Huilume ngeena, e ii'o mola kara'inie mei aano nge a Jekob e niie oto waite nana a Josep, a kalena. ");
INSERT INTO apb_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","8","Na kakalu a Jekob e elie, e ii'o ue i leune. Oto a Jisas e lae wau e ii'o i aano i reune kakalu ngeena, aena aana ko weo aana laenga. Maholona sato e ngara e oono i seulehi, na i purine mo pwaarongoisuli kire lae ta'au i huilume huni holi ngeulaa, oto ngaeta keni ni Samaria e lae mai huni tei wei aana kakalu ngeena. Oto a Jisas ko te'uri hunie, “O ke dangu wei ekue.” ");
INSERT INTO apb_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","A keine ko tohungei pangata'i aena aana mo Jiu ko tohungei leledie mo Samaria, hule aana kire ka'a sare ngau ike wa kire ke inu aana mo kao-kao mo Samaria. Oto a keine ko te'uri hunie a Jisas, “I'oe mwane ni Jiu, na ineu keni ni Samaria. ?Oto e ue o ko si sukaa nga mei wei emue aaku?” ");
INSERT INTO apb_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","A Jisas e aalamie ko si te'uri hunie, “I'oe o ka'a saie ike mei niinge a God ko sare niie huni'o, na o ka'a saie no'one uri a tei nge ko suke wai eemu ienini. Ha'alaa, o sukaa oto mei wei meuri emue mwaanieu, na nou niie oto huni'o.” ");
INSERT INTO apb_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Oto a keine ko te'uri, “Poro paine, kakalu ienini e kokoro oto hiito'o na nga mei ola huni dengu wei aana ha'ike aamu. ?Oto o ke si toolea mei wei meuri ngeena ka'u uure i tei eena? ");
INSERT INTO apb_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","?Uri o ko lo'o-lo'onga'ini'o uri o paine lo'u liutaa aana weuwaka a Jekob oto wau i na'o nge e niie kakalu ie naka? ?Oto nga mei wei diana uri taa o kei niie lo'u, aana a Jekob na mo kalena na ahutana mo ola mauri ingeie kire mani inu-inu mola aana kakalu ienini?” ");
INSERT INTO apb_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Oto a Jisas e aalamie ko te'uri, “Ta'ena nga iini ko inu-inu aana wai ie, e sai maarou lo'u mola. ");
INSERT INTO apb_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Ta'e iini nge ko inu aana mei wei nge ne kei niie ana, e sa'a maarou lo'u. Mei wei nou niie ana ngeena kei ne'i huulaa mauri i lalo aana, na kei niie maurihe huu hunie.” ");
INSERT INTO apb_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Oto a keine ko si te'uri hunie a Jisas, “Poro paine, o ke niie mei wei ngeena akue hunie ne ke su'uri he'i maarou lo'u, na mwaanie nou he'i lae lo'u mei huni tei wei i leu.” ");
INSERT INTO apb_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Oto a Jisas ko unue hunie uuri, “O ke lai unue hunie poro i'oe uri more ke lae ka'u mei seeku i leu.” ");
INSERT INTO apb_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Oto a keine ko aalamie a Jisas, ko te'uri, “Nou ka'a to'o poro ike.” Oto a Jisas ko te'uri hunie, “E to'ohuu oto aana o ko unue uri o ka'a to'o poro ike. ");
INSERT INTO apb_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Aana o to'o aana ka'u e lime poro, na iini nge o ko o'o'o i saana maholo ienini na ingeie nga poro to'ohuu i'oe ha'ike. O ko ere to'ohuu oto.” ");
INSERT INTO apb_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Oto a keine ko si te'uri hunie a Jisas, “Poro paine, no ko si lio saie uri i'oe nga propet ni ngeena. ");
INSERT INTO apb_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Oto saeku hunie uri o ke ere luhesie hunieu iini uri taa e to'ohuu. Mo weuwemami mo Samaria oto i na'o, kire palo-paloa God i lengine toloi henue ie, ta'e i'omu mo Jiu, omu unue uri i Jerusalem hali'ite ni leu huni palo-paloa God.” ");
INSERT INTO apb_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Oto a Jisas ko te'uri lo'u hunie, “Keine, o ke hiiwalaimoli eeku aana no ko unue uri maholo nge ko lae maine, mwala sa'a palo-paloa ike taane lo'u a Mama'a mola i lengine toloi henue ienini wa ta'au i Jerusalem. ");
INSERT INTO apb_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","I'omu mo Samaria, omu ka'a tohungei sai diana aana ike uri a tei ni omu ko palo-paloa. Ta'e i'emi mo Jiu emi saie a tei nge emi ko palo-paloa, aena aana a Ha'a-uuri ingeie mwane ni Jiu. ");
INSERT INTO apb_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Na maholo ko nanauhie oto mai, na e hule mone oto, hunie mwala ke palo-paloa a God Mama'a oto to'ohuu aani sae na aani walaimolinge. Aana a Mama'a e tohungei saeto'o aana mo iini kire ko palo-paloa urine. ");
INSERT INTO apb_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","A God e ka'a to'o aana ike mei sape mala iinoni aena aana ingeie Li'oa, na mo iini ko palo-paloa, kire ke palo-paloa oto aani sae na aani walaimolinge.” ");
INSERT INTO apb_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Oto a keine ko te'uri hunie, “Nou saie taane uri a Kraes kei lae mai, na maholo kei hule oto mai, nge ke si unu diana aana ahutana walu ola hunikie.” ");
INSERT INTO apb_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Oto a Jisas ko te'uri hunie a keine, “Ingeie ka'u oto ko ere-ere pe'i'o ienini. Ineu oto ingeie.” ");
INSERT INTO apb_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Maholona na mo pwaarongoisuli a Jisas kire si hule mola i saadarue. Kire ko tohungei pangata'i aana kire leesie uri a Jisas ko ere-ere pe'ie a keni ngeena. Ta'e nga iini aada e ka'a he'i dolosi lo'u aana a keine uuri, “?Nga taa o saeto'o aana?” wa ke dolosi aana a Jisas uuri, “?E ue o ko ere-ere pe'ie a keni ngeena?” ");
INSERT INTO apb_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Oto a keine e toli'aasie ho ate'a ingeie huni wei, na ko eeliho'i oto ta'au i huilume. E lai hule ta'au, ko si unue hunie mwala uuri, ");
INSERT INTO apb_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“!Omu ke lae ka'u mei leesie a mwane mai ie! Ko unue mola walu ola nou talei deu-deu'i oodoieu. ?Mwaanie ohe ingeie ni oto a Kraes?” ");
INSERT INTO apb_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Oto mwalana kire ta'ela'i mwaanie huilume na kire ko lae oto i saana Jisas. ");
INSERT INTO apb_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Ta'e mo pwaarongoisuli, maholo a keine e lae mwaanire ngeena, nge kire ko ha'atohu aana a Jisas uuri, “Ha'a-uusuli, o ke ngau ke'u.” ");
INSERT INTO apb_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Ta'e a Jisas e te'uri mola hunire, “Mei ngeulaa taane aaku hule aana i'omu na omu ka'a saie ike nga mei ola aana.” ");
INSERT INTO apb_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Oto mo pwaarongoisuli ko si dolosi heiliu aada uuri, “?Mwaanie ohe nga iini e tola ngaulaa oto mai ana?” ");
INSERT INTO apb_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Oto a Jisas ko te'uri hunire, “Mei ngeulaa ineu oto huni ha'ato'oa saena iini e uusunge'inieu mei, na hunie ne ke ha'amangoa oto mei esunge e niie hunie ne ke asuie. ");
INSERT INTO apb_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Omu ko unu-unue ka'u uri e hai waro-waro lo'u nge kolu ke si so'okoni oto. Ta'e ineu, no ko unue huni'omu uri maholo hunie so'okoninge oto ie. Leesie ka'u ahutana mwala ngeena, aana kire urihana hohola nge e repo oto, na kire urihana mo ngeulaa e malisine oto so'okonileni ke lae. ");
INSERT INTO apb_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Na maholo e hule oto hunie mo iini so'o-so'okoni kire ke asu hunie waaitada. Kire ke pe'ie mwala huni hiiwalaimoli oto aaku, na mo iinoni nge so'okonilada e lae ngeena, ikire no'one kire kei hele aana maurihe huu. Oto iini e hola'i taroha'inie walana God hunie mwala, na iini e toolera mai saana God kire kei meni ilenimwa'e tararuru. Leune e urihana mola lio i sulilana hohola, na ");
INSERT INTO apb_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","mei wala e to'ohuu taane nge kie ko unu-unue uri, ‘Nga iini ko hesie mo litei ola, na ngaeta iini lo'u ke so'okoni.’ ");
INSERT INTO apb_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Ineu no ko uusunge'ini'omu ta'au huni so'okonie mola mo ola omu ka'a hasi'i. Mo iini aaopa kire hola'i esu i laona hohola ngeena, na i'omu omu ko si helesie diananga mola aana asunge ikire.” ");
INSERT INTO apb_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Mo iini hunge aana mwala ni Samaria i laona huilume ngeena kire hiiwalaimoli aana a Jisas, aena aana a keine e unue ka'u uuri, “Ko unue mola walu ola nou talei deu-deu'i oodoieu.” ");
INSERT INTO apb_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Oto maholo mo Samaria e lae mai hule i saana Jisas, kire ko ha'atohu aana uri ke ii'o ka'u pe'ire. Na e ii'o oto aana hanuena e ro hai dinge. ");
INSERT INTO apb_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Mo iini hunge lo'u kire hiiwalaimoli aena aana kire rongoa walana Jisas oto maraada. ");
INSERT INTO apb_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Oto mwalana kire ko unue hunie a keine uuri, “Melu hiiwalaimoli oto eena, ka'a ike mola i sulie nga taa o unue, ta'e aena aana melu rongoa oto no'one walana maraameelu. Na ie melu saie uri ingeie ni oto a Ha'a-uuri hunie walumalau.” ");
INSERT INTO apb_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","I purine e ro hai dinge a Jisas e ii'o wau i leune e saro mango, e si ta'ela'i ko eeliho'i lo'u hunie i Kalili. ");
INSERT INTO apb_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","45","Maholo a Jisas e hule hao i Kalili, mwala i leune kire ko ilenimwa'e mola haahie aena aana ikire no'one, kire lae aana Houlaa Ni Liumwaanie ta'au i Jerusalem, na kire leesie oto walu ola e asui'i ta'au. Ta'e kire ka'a tohungei lio saie ike uri ingeie a tei. E rau mola urine mala a Jisas maraana e unue ka'u i na'o, uri mwala aana tohungana hanue nga propet kire sa'a ha'ama'u ike aana. ");
INSERT INTO apb_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","47","Oto ngaeta na'ohai mwane a Herod Inemauri e o'o'o oto aana huilume i Kapaneam, na kele mwela mwane ingeie ko mata'i. Maholo a mwaena e rongoa uri a Jisas e lae oto mwaanie po'o ni henue i Jiudia na ko lae oto mai hunie po'o ni henue i Kalili, a mwaena ko si lae huni ere pe'ie. Oto e oodoie aana huilume i Kena aana po'o ni henue i Kalili, leu nge a Jisas e hu'isie wai ke ne'i waen aana. A mwaena ko si lae i saana Jisas na ko eitanaie uri ke lae oto i Kapaneam huni ha'a-uurie a kalena, aana kara'inie oto kei mae. ");
INSERT INTO apb_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Oto a Jisas ko te'uri hunie a mwaena, “Omu hiiwalaimoli mola aaku aena aana omu leesie oto mo ola ni pangata'inge na mo tolimaa aana mo hu'i-hu'ite.” ");
INSERT INTO apb_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Ta'e a mwaena ko ha'atohu aana lo'u uuri, “Poro paine, o ke lae oto mai pe'ieu maholo a kaleku e ka'a mae ue.” ");
INSERT INTO apb_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Oto a Jisas ko si aalamie uuri, “O ke lae mola. A kalemu e awaa oto.” A mwaena e hiiwalaimoli aana nga taa a Jisas e unue hunie, oto e si lae. ");
INSERT INTO apb_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Oto aana hai dinge lo'u i sulie, maholo ko lae-lae ue hao i sulie tala, na ko oodoie mo mwane au'esu ingeie. Oto kire ko unue hunie uri “A kalemu e awaa oto.” ");
INSERT INTO apb_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Oto a mwaena ko dolosi aada uuri, “?Maholoi sato uri taa e tala'ai awaa?” Na kire aalamie uuri, “E tala'ai awaa oto aana ola mala sato e ngara e hiu i seulehi nonola.” ");
INSERT INTO apb_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Oto aamana mwa'une e manata'inie oto uri maholoi satona ni a Jisas e unue hunie uuri, “A kalemu e awaa oto.” Oto a mwaena na ahutana mwala aana nume ingeie kire mani hiiwalaimoli oto aana a Jisas. ");
INSERT INTO apb_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Ienini ruana nga maholo a Jisas e lae mwaanie po'o ni henue i Jiudia hunie po'o ni henue i Kalili na e asuie hu'i-hu'ite huni haata'inie tolimaa aana uri ingeie a tei. ");
INSERT INTO apb_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Oto ngaeta maholo lo'u i purine leune e mango, a Jisas e si hanetaa ta'au i Jerusalem mala ha'atolanga e unue i laona Uusu-uusu Maa'i hunie ngaeta houlaa paine ikire mo Jiu. ");
INSERT INTO apb_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Na nga lama oto ta'au i leune i Jerusalem nge kire haara'inie aana erenga ni Jiu uri “Betsata.” Lama ngeena e ii'o po'oi sinaha mwaanie para aana huilume i Jerusalem, hoorana maai para kire haara'inie “Maai Para Ni Sipu.” E lime Leu Ni Haa-haanaku kire ii'o no'one ahuie lama ngeena. ");
INSERT INTO apb_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Hungelana mo mae-maea'a mala mo ulu, na mo rarasi, na mo to'u kire sai eno mola tarau aana mo Leu Ni Haa-haanaku ngeena. ");
INSERT INTO apb_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Ngaeta mwane e eno no'one i leune, ko lae pe'i mweri oto hunie oolu aawalai helisi mwana walu. ");
INSERT INTO apb_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Maholo a Jisas e leesie a mwaena e eno na e saie oto uri ko mweri tewa oto, ko si dolosi aana uuri, “?O saeto'o aana uri ha'a-uurilemu ke lae?” ");
INSERT INTO apb_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Oto mwane ko mweri ngeena ko aalamie uuri, “E aasa, Poro paine, aana nou ka'a to'o aana ike nga iini huni sulu'ieu i laona lama maholo ko tei hiru-hiru. Oto suli maholo no ko lae-lae ue hao hunie wai, na nga iini aaopa e hola'i liu oto i na'oku na ta'e ingeie mola ha'a-uurilana ko lae.” ");
INSERT INTO apb_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Oto a Jisas ko te'uri hunie a mwaena, “!Ta'ela'i! O ke toolea hulite i'oe, na o ke lae-lae oto.” ");
INSERT INTO apb_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Oto ae'aena a mwaena e tolana kohi oto mola aana maholona. Oto e toolea hulite ingeie, na ko lae-lae oto. Mei ola ngeena e rau aana Dinge Maa'i Mo Jiu. ");
INSERT INTO apb_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Oto mo na'ohai mwane mo Jiu, kire ko te'uri hunie mwane nge ha'a-uurilana e lae ngeena, “Si'iri Dinge Maa'i ikie, na e ka'a malisine ike mo Ha'atolanga ikie uri o ke toolea hulite i'oe urine, sulie asunge ni ngeena.” ");
INSERT INTO apb_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Oto a mwaena ko aalamire uuri, “Mwane nge e ha'a-uurieu ni e unue uri ne ke toolea hulite ineu, na ne ke lae oto.” ");
INSERT INTO apb_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Oto kire ko dolosi aana mwaena uuri, “?A tei mwane ni e unue huni'o uri o ke te'urine?” ");
INSERT INTO apb_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Ta'e mwane nge ha'a-uurilana e lae ngeena, e ka'a saie ike uri a tei ni e ha'a-uurie, aena aana a Jisas e aara'imuni oto mwaanie aana mwala hunge i leune. ");
INSERT INTO apb_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Oto lo'u i puri, a Jisas e haitalea na e oodoie a mwaena ta'au i laona Nume Maa'i Peine, ko si te'uri hunie, “Lio ka'u, ha'a-uurilemu e lae oto. Oto o ke rohu mwaanie ooraha'aa mwaanie da na nga mei ola aaela lo'u hiito'o e he'i hite aamu lo'u.” ");
INSERT INTO apb_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Oto a mwaena e lae, ko si lai ha'arongoa mo na'ohai mwane mo Jiu uri a Jisas ni e ha'a-uurie. ");
INSERT INTO apb_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Oto aena aana a Jisas e asuie mei ha'a-uuringe ngeena aana hai Dinge Maa'i Mo Jiu, nge mo na'ohai mwane mo Jiu kire ko si aehota taunge'inie. ");
INSERT INTO apb_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Ta'e a Jisas e unue hunire uuri, “Aamaku ko esu tara'asi hule mai ienini, na ineu no'one no ko esu mala ingeie.” ");
INSERT INTO apb_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Na aena mei olana, mo na'ohai mwane mo Jiu kire si ne'isae oto hiito'o huni horo maesie. E ka'a ilisie ike uri a Jisas e dau aaelasie ha'atolanga ikire aana Dinge Maa'i hahaiteli, ta'e aena aana ko unue no'one uri a God oto tohungei aamana, na urine nge ko da uri ingeie e sada oto pe'ie a God. ");
INSERT INTO apb_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Oto a Jisas e aalamire ko te'uri, “No ko unue oto huni'omu uri a Kale e sa'a roro'a ni da ike nga mei ola tohune ta'e mwaanie nga mei ola oto ko leesie Aamana ko eu'esuie ha'alaa ingeie ko esuie. Aana ta'ena nga ola a Mama'a ko esuie, nge a Kale ko esuie no'one mola. ");
INSERT INTO apb_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","A Mama'a e haata'inie walu ola ko eu'esui'i oto aana a Kale, aena aana e tohungei manata diana hunie. Na kei haata'inie mo ola paine lo'u hunieu hunie ne ke asui'i, hule aana omu kei pangata'ini'i. ");
INSERT INTO apb_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Oto mala ka'u a Mama'a ko ta'ea mo iini e mae mwaanie maenga hunie kire ke mauri lo'u, nge a Kale na e urine no'one mola, aana e sai niie maurihe hunie mo iini e saeto'o aada. ");
INSERT INTO apb_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Na lo'u a Mama'a mone e sa'a leie ike nga iini, aana e niie oto ahutana nanamanga aana leinge hunie a Kale. ");
INSERT INTO apb_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Aena ngeena, ahutana mo iinoni ke mani ha'ama'u aana a Kale oto mala kire ko ha'ama'u aana Mama'a. Iini oto e ka'a ha'ama'u ike aana a Kale, nge e ka'a ha'ama'u oto no'one aana a Mama'a nge e uusunge'inie mai eena. ");
INSERT INTO apb_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“No ko unue oto to'ohuu huni'omu uri iini ko rongoa walaku na ko hiiwalaimoli aana iini e uusunge'inieu mei, iinoni ngeena e hele aana oto maurihe huu eena, na leilana e sa'a roro'a ni lae ike lo'u. Iini urine e pwani liu oto mwaanie maenga na e sili oto i laona maurihe. ");
INSERT INTO apb_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","“No ko unue oto to'ohuu huni'omu uri maholo ko nanauhie oto mai, na e hule mone oto, hunie mo iini mauriha'ada e mae kei rongoa walaku a Kalena God. Na mo iini ko rongo pe'i hiiwalaimolinge aaku kei hele aana maurihe. ");
INSERT INTO apb_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Na e urine oto aena aana a Mama'a e maaie hunieu a Kalena no'one ne ke to'o aana nanamanga ni meurihe mala ingeie. Mala maurihe e uure mai mwaanie a Mama'a maraana, nge urine lo'u a Mama'a e maaie hunieu a Kalena uri hunie ne ke sai niie maurihe no'one urine hunie ta'ena nga iini. ");
INSERT INTO apb_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Na a Mama'a e niie no'one nanamanga huni lei-lei hunieu a Kalena, aena aana ineu a Kale Ni Iinoni. ");
INSERT INTO apb_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","“Mwaanie omu pangata'i aana walu ola ngeena, aana ko kara'inie oto maholo hunie mo iini e mae kei rongoa walaku, na ");
INSERT INTO apb_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","kire kei iisitaa poi mwaanie mo kilipwe'u ikire. Mo iini kire asu diana ha'alaa kire kei ta'ela'i hunie maurihe huu. Ta'e mo iini helelada e tata'ala, kire kei ta'ela'i mola hunie leilada kei lae aana maenga huu. ");
INSERT INTO apb_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Ineu nou sa'a roro'a ni esuie ike nga mei ola tohuku, aana a Mama'a e uusunge'inieu mei, na ingeie oto ni e unue hunieu uri ne kei lei-lei uri taa. Oto leinge ineu e oodo mola, aena aana nou ka'a dau ike mola i sulie saeku, ta'e i sulie saena iini e uusunge'inieu mei.” ");
INSERT INTO apb_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Oto a Jisas ko he'i te'uri lo'u hunire, “Mala uri ta'e ineu mola maraaku ni no ko lalado i sulieu nana mwala, nge e lio mala nou ka'a ere to'ohuu ike. ");
INSERT INTO apb_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Ta'e nga iini aaopa taane i leune ko ha'awalaimoli'aa walaku, na nou saie uri nga taa ko unue i sulieu e to'ohuu. ");
INSERT INTO apb_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","I'omu, omu uusunge'inie mwala i'omu ka'u i saana a Jon Loto Maa'i, na nga taa e unue huni'omu i sulieu ngeena e to'ohuu oto. ");
INSERT INTO apb_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Ineu maraaku na nou ka'a hari hunie ike nga iinoni ke ere i sulieu, ta'e no ko ha'a-aamasito'o'omu mola aana nga taa a Jon e unue i sulieu, uri hunie omu ke hele aana maurihe huu. ");
INSERT INTO apb_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Aana a Jon e urihana laite ko eeso-eeso aana ko sinelie saena mwala, na omu ilenimwa'e haahie raa-raa aana walana mola hunie kele maholo o'oru'e. ");
INSERT INTO apb_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","“Ta'e iini no ko ere i sulie ngeena e haata'i diana lo'u liutaa aana a Jon, uri a Mama'a ni oto e uusunge'inieu mei. Na mo esunge no ko eu'esui'i kire haata'i diana aana taane uri ineu a tei, aena aana mo ola a Mama'a e nii'i hunieu huni esui'i ni otona. ");
INSERT INTO apb_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","“Na a Mama'a iini e uusunge'inieu mei e pwani unu haata'i oto aana walu ola i sulieu maraana. Ta'e i'omu, omu ka'a leesie ue maana, na hule aana omu ka'a rongoa ike lo'u walana. ");
INSERT INTO apb_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Na walana e ka'a ii'o ike i laona saemiu, aena aana omu ka'a hiiwalaimoli ike aaku, iini nge e uusunge'inie mai huni'omu. ");
INSERT INTO apb_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","“Omu ko tohungei heitale susulie mo Uusu-uusu Maa'i aena aana omu lo'onga'inie uri i laona mo Uusu-uusu Maa'i ngeena ni omu kei lio oodoie maurihe huu. Na mo Uusu-uusu ngeena ka'u mola kire ere i sulieu. ");
INSERT INTO apb_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Ta'e omu ka'a sare lulu i sulieu ike huni hele aana maurihe ngeena. ");
INSERT INTO apb_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Nou ka'a lo'ohie ike uri mwala ke ha'amanikulu'aau, ");
INSERT INTO apb_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","aana nou sai diana aana mola tolahamiu aana uri nga kele mei manata-diananga hunie a God ha'ike lo'u i manatamiu. ");
INSERT INTO apb_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Ineu nou lae mai oalana a Mama'a, ta'e omu ka'a sare takuhieu ike. Ta'e mala uri nga iini aaopa ko lae mai pe'ie mei ne'isaenga ingeie mola maraana, nge omu ko si tekuhie. ");
INSERT INTO apb_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Omu saeto'o aana mola uri mwala ke lahe'omu, ta'e omu ka'a sare ii'o oodota'i ike uri hunie ta'a-ta'a tohungei God ke lahe'omu. ?Nge ko urine, omu ke si hiiwalaimoli eeku uri taa eena? ");
INSERT INTO apb_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","“Mwaanie omu lo'o-lo'onga'inie uri ineu ni ne kei ha'asusunge'ini'omu i saana a Mama'a. !Ha'ike! Iini kei ha'asusunge'ini'omu taane nge mo Ha'atolanga a Mosis nge omu tohungei noruto'o aani. ");
INSERT INTO apb_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Mala uri omu ko hiiwalaimoli to'ohuu aana a Mosis, ha'alaa omu hiiwalaimoli no'one aaku, aena aana ingeie ka'u e uusu-uusu i sulieu. ");
INSERT INTO apb_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","?Ta'e mala uri omu ka'a hiiwalaimoli ike aana nga taa a Mosis e uusue, nge omu ke si hiiwalaimoli eeku uri taa eena?” ");
INSERT INTO apb_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","4","Oto lo'u i purine leune, maholo ko kara'inie oto Houlaa Ni Liumwaanie, a Jisas na mo pwaarongoisuli ingeie kire aatoholo po'o wau aana Aasi I Kalili nge kire ko sasaie no'one aana Aasi a Taebirias Inemauri. A Jisas e hanetaa ta'i lengine uuwo i leune, oto ko ii'o i aano huni ha'a-uusulie mo pwaarongoisuli ingeie. Na mwala oto hunge kire lae mai no'one i sulie, aena aana kire leesie mo hu'i-hu'ite e asui'i aana e ha'a-uurie mwala ko mweri. ");
INSERT INTO apb_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Oto a Jisas e lio wau na ko leesie mwala hunge ko lae mai saana, ko si te'uri hunie a Pilip, “?Kolu kei holi ngeulaa ka'u adona mwala ngeena i tei?” ");
INSERT INTO apb_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","A Jisas e saie taane nga taa kei esuie, ta'e e dolosi aana a Pilip urine mola uri huni oohongie hiiwalaimolinge ingeie. ");
INSERT INTO apb_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","A Pilip e aalamie na ko te'uri, “!Ha'ike eena! Holitana nga mwane hunie walu waro-waro na e ka'a adona ike lokotaa paine ngeena kire kei oa mei ngeulaa nga iini.” ");
INSERT INTO apb_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Oto ngaeta iini aana mo pwaarongoisuli, a Andru, aasine a Saemon Pita, e si te'uri hunie a Jisas, ");
INSERT INTO apb_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Kele mwa'u i leune, e lime kele ho bred pe'ie nga ro kele ho ii'e ikire aana. ?Ta'e mo kele ngaulaa urine kei adona mwala hunge urine uri taa?” ");
INSERT INTO apb_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Oto a Jisas ko te'uri hunie mo pwaarongoisuli, “Omu ke unue mwala ke ii'o i aano.” Leu ngeena hahalisi hali'ite e aaluhie, na ahutana mwala ko meni ii'o oto i aano. Na ola mala e lime sinolai mwane ikire i leune. ");
INSERT INTO apb_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Oto a Jisas e hele aana mo ho bred ngeena, e paalahea God mango haahi'i, ko si nii-nii'i hunie mwala e ii'o i aano i leune. E he'i te'urine lo'u aana mo ho ii'e, na kire mani ngeu ni pote i sulie saeda. ");
INSERT INTO apb_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Maholo kire mani ngeu pote mango, a Jisas ko si te'uri hunie mo pwaarongoisuli ingeie, “Omu ke so'okonie mo ooretai ngeulaa mwaanie nga leu eeni e waeta'i.” ");
INSERT INTO apb_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Oto kire si so'okoni na kire ko ha'ahonue aawalai lu'e mwana rue aana mo ooretai ngeulaa uure mwaanie e lime kele ho bred ngeena. ");
INSERT INTO apb_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Oto maholo mwala kire leesie hu'i-hu'ite a Jisas e asuie ngeena, kire ko si te'uri, “Sa'a mola propet paine nge mo Uusu-uusu Maa'i e unue uri kei lae mai laona walumalau ni oto ienini.” ");
INSERT INTO apb_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","A Jisas e lio saie mone uri mwala ngeena ko sare dau su'uie mola uri hunie ke ne'i inemauri nada, oto e oopa mwaanire, na e hanetaa lo'u mola ta'au i lengine uuwo maraana. ");
INSERT INTO apb_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Oto i seulehi aana hai dingena, mo pwaarongoisuli a Jisas kire siho lo'u hao i oone i reune Aasi I Kalili. ");
INSERT INTO apb_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Kire hule i oone na ko rodo oto, ta'e a Jisas e ka'a hule ike ue i saada. Oto kire si ta'elie iiola, na kire ko aatoholo oto po'o mai aana Aasi I Kalili takoie i Kapaneam. ");
INSERT INTO apb_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Kire lae-lae ngeena kire ko suehie ooru peine na aasi ko mawa oto. ");
INSERT INTO apb_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Maholo kire hote ha'atau oto mala e lime wa e oono kilomita mwaanie i oone, oto kire ko si leesie a Jisas ko taalau i kolune aasi na ko lae oto mai takoie iiola. Mo pwaarongoisuli kire leesie urine, kire ko si tohungei me'u oto hiito'o. ");
INSERT INTO apb_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Ta'e a Jisas e te'uri hunire, “Ineu taane mola ni ie. Mwaanie omu me'u-me'u.” ");
INSERT INTO apb_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Kire rongo urine, oto kire si mwa'e-mwa'e hunie ke ta'e i laona iiola, na kire ko tolana aarapuu oto aana leu kire ko lae hunie. ");
INSERT INTO apb_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Oto hai dinge lo'u mola i sulie, pulitaa paine nge a Jisas e lae mwaanire aana aapa po'o hao aana Aasi I Kalili, kire ko hai-heitalea lo'u a Jisas. Kire saie uri ta'a-ta'a iiola ni mola e o'o'o ka'u hai leune, na kire saie no'one uri mo pwaarongoisuli kire lae mola maraada aana iiola ngeena na a Jisas e ka'a lae ike pe'ire. ");
INSERT INTO apb_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Kire ko lio-lio ue hunie, na mo iiola uure aana huilume i Taebirias kire ko lae mai i oone kara'inie leu nge mwala e ngau bred aana i purine a Jisas e ere ni paalahenga. ");
INSERT INTO apb_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Oto maholo mwala hunge ngeena kire leesie uri a Jisas na mo pwaarongoisuli ingeie kire mani ei'aa mwaanie leune, kire si ta'elie mo iiola nge kire si hule ngeena, kire ko lai heitalea a Jisas lo'u hao i Kapaneam. ");
INSERT INTO apb_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Oto maholo mwala ngeena e lai lio oodoie a Jisas hai Kapaneam, oto kire ko dolosi aana uuri, “?Ha'a-uusuli, o lae ka'u mei i leu maholo uri taa?” ");
INSERT INTO apb_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Oto a Jisas ko aalamire uuri, “No ko unue oto huni'omu uri omu ko heitaleau mola aena aana omu ngeu ni pote aana mo ho bred, ta'e ka'a ike aana uri omu lio saie ne'isaenga aana mo tolimaa nou esui'i. ");
INSERT INTO apb_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Omu ke su'uri esu mola talana mo ngeulaa nge kire sai ei'aa mola lau-leu, ta'e omu ke asu a'aila'a talana mei ngeulaa nge e sai ii'o huu na kei niie maurihe huu huni'omu. Na mei ngeulaa ngeena, ineu a Kale Ni Iinoni mola nou sai niie huni'omu, aena aana a God Mama'a e uusunge'inieu mei huni esuie urine pe'ie nanamanga paine ingeie.” ");
INSERT INTO apb_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Oto mwalana ko si dolosi aana a Jisas uuri, “?Nga mei taa ka'u melu kei esuie hunie uri melu ke si hele i sulie saena God?” ");
INSERT INTO apb_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Oto a Jisas ko aalamire uuri, “Nga taa a God e saeto'o aana oto uri omu ke hiiwalaimoli mola aaku, aana e uusunge'inieu mei.” ");
INSERT INTO apb_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","31","Oto kire ko he'i dolosi lo'u aana uuri, “?Nga tolimaa uri taa ni o sai esuie hunie uri melu ke leesie na melu ke hiiwalaimoli eemu? Mo weuwaka oto i na'o maholo kire ii'o i laona hanuesala pe'ie a Mosis, kire ngau aana ngaulaa nge kire haara'inie aana mana nge e teke mola uure i Lengi, oto mala uusulana e lae uuri, E nii ngeulaa ada uure i Lengi. ?Oto i'oe, nga mei hu'i-hu'ite uri taa ni o kei esuie?” ");
INSERT INTO apb_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Oto a Jisas ko si te'uri hunire, “No ko unue oto to'ohuu huni'omu uri a Mosis ha'ike ni e niie mei ngeulaa uure i Lengi amiu, ta'e Aamaku ni e niie amiu. Na oto ie ingeie ni ko niie tohungei ngeulaa uure i Lengi huni'omu. ");
INSERT INTO apb_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Aana mei tohungei ngeulaa nge a God ko niie, ingeie oto iini e siho mai uure ta'au i Lengi na ko niie maurihe hunie walumalau.” ");
INSERT INTO apb_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Oto mwalana ko si te'uri hunie, “Poro paine, o ke niie mei ngeulaa ngeena ameelu tarau.” ");
INSERT INTO apb_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","A Jisas ko si unue hunire uuri, “Ineu oto ngaulaa ni meurihe. Iini ko lae mai ne'i pwaarongoisuli ineu, e sa'a he'i hiolo lo'u, na iini ko hiiwalaimoli eeku, e sa'a he'i maarou lo'u. ");
INSERT INTO apb_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Ta'e oto mala nou unue ka'u huni'omu oto i na'o, omu leesieu taane oto, ta'e omu ka'a sare hiiwalaimoli ike. ");
INSERT INTO apb_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Ta'ena nga iini nge Aamaku e niie nakue kei lae oto mai seeku. Na ta'ena nga iini ko lae mai seeku, nou sa'a roro'a toli'aasie ike lo'u hunie ke lae mwaanieu. ");
INSERT INTO apb_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Aena aana nou siho mai uure i Lengi, ka'a ike hunie ne ke asuie mo ola i sulie saeku maraaku, ta'e i sulie saena iini e uusunge'inieu mei. ");
INSERT INTO apb_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Na saena iini e uusunge'inieu mei uri ne ke su'uri deu tekela'inie nga iini aana mo iini e niire nakue, ta'e uri ne ke ta'e aaliho'i aada hunie maurihe huu aana dinge ooreta. ");
INSERT INTO apb_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Aana nga taa Aamaku e saeto'o aana uri ahutana mo iini ko leesieu a Kale na kire ko hiiwalaimoli eeku, kire ke hele aana maurihe huu, aana ineu ne ke si ta'e aaliho'i aada aana dinge ooreta.” ");
INSERT INTO apb_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Oto mo na'ohai mwane mo Jiu ko aehota papanguru-nguru oto hoorana Jisas aana e unue uuri, “Ineu oto ngaulaa e siho mai uure i Lengi.” ");
INSERT INTO apb_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Oto kire ko unue uuri, “A mwane ngeena, kalena Josep mola ni ngeena. Kolu saie ka'u mola aamana na nikana. ?Oto aana e ue ka'u ko si unue uri e siho mai uure ta'au i Lengi?” ");
INSERT INTO apb_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","A Jisas e aalamire oto ko te'uri, “Omu ke su'uri upwesieu urine haahie nga taa nou si unue ngeena. ");
INSERT INTO apb_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Nga ta'a-ta'a iini e sa'a roro'a ni lae ike mai seeku na oto a Mama'a nge e uusunge'inieu mei e ka'a wa'inie hunie ke lae mai seeku. Ta'e mo iini kire lae oto mai seeku, ineu ne ke si ta'era lo'u hunie maurihe huu aana dinge ooreta. ");
INSERT INTO apb_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Ngaeta propet e uusue i laona mo Uusu-uusu Maa'i uuri, A God kei ha'a-uusulie taane ahutana iinoni. Oto ahutana mo iini ko rongo hunie walana Mama'a na ko lulu i sulie, kire ke si lae mai seeku. ");
INSERT INTO apb_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Nga ta'a-ta'a iini e ka'a leesie ue a Mama'a, ta'e ineu ha'alaa nou leesie a God aana nou uure oto mai aana a Mama'a. ");
INSERT INTO apb_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","No ko unue oto to'ohuu huni'omu uri iini ko hiiwalaimoli eeku, nge e hele aana oto maurihe huu. ");
INSERT INTO apb_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Ineu oto ngaulaa nge ko niie maurihe. ");
INSERT INTO apb_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Mo aamamiu kire ngau-ngeu taane aana ngaulaa nge kire haara'ie aana mana, ta'e kire saronai mae mola i laona hanuesala. ");
INSERT INTO apb_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Ta'e mei ngeulaa nge e siho oto uure mai Lengi nge no ko ere-ere i sulie ienini e tohungei aaopa. Aana iini ko ngaue, e sa'a he'i mae lo'u. ");
INSERT INTO apb_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Ineu oto mei ngaulaa mauri nge e siho mai uure i Lengi. Na iini ko ngeu aana mei ngeulaa ienini kei meuri huu. Aana mei ngeulaa ne kei niie hunie, nge hasi'oku otona, aana no ko niie i tehula'ana walumalau hunie ke to'o aana maurihe.” ");
INSERT INTO apb_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Oto mo Jiu kire ko tohungei saewasulie oto, na kire ko ere hailiu i matolada oto aani dolosinge uuri, “?A mwane ie kei niie hasi'ona akaelu uri taa eena?” ");
INSERT INTO apb_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Oto a Jisas ko te'uri hunire, “No ko unue oto huni'omu uri mala omu ka'a ngaue hasi'ona a Kale Ni Iinoni, na omu ke inuhie apune, omu sa'a roro'a ni to'o aana ike maurihe i lalo aamiu. ");
INSERT INTO apb_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Na ta'ena nga iini nge ko ngeue hasi'oku na ko inuhie apuku, nge e to'o aana oto maurihe huu na ne kei ta'ea lo'u aana dinge ooreta. ");
INSERT INTO apb_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Aana hasi'oku oto hahu'ana mei ola ni ngaa, na apuku oto hahu'ei mei ola ni inu. ");
INSERT INTO apb_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Iini ko ngeue hasi'oku na ko inuhie apuku, nge ko ii'o susu oto i lalo aaku na ineu ne kei ii'o susu oto i lalo aana. ");
INSERT INTO apb_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","A Mama'a, ingeie oto aahu'ine maurihe, na ingeie oto e uusunge'inieu mei. Nou to'o aana maurihe aena aana Mama'a, na urine lo'u mo iini ko ngeue hasi'oku kire kei hele aana maurihe aena aana ineu no ko niie hunire. ");
INSERT INTO apb_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Aana tohungei ngeulaa e siho mai uure i Lengi ni oto ngeena. E ka'a urihana ike ngaulaa nge mo aamamiu kire ngau-ngeue ka'u, ta'e kire saro mae mola. Iini ko ngeue mei tohungei ngeulaa no ko ere-ere i sulie ngeena, kei meuri huu.” ");
INSERT INTO apb_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","A Jisas e unu-unue ahutana mo wala ni ha'a-uusulinge ienini wau i laona nume ni palo-palo mo Jiu i Kapaneam. ");
INSERT INTO apb_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Mo iini hunge aana mo pwaarongoisuli ingeie kire rongoa mo ha'a-uusulinge ngeena, oto kire ko te'uri, “Ha'a-uusulinge ienini e tohungei rongo aasa'a. ?A tei nge kei rongo hunie?” ");
INSERT INTO apb_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Nga iini ka'a ha'arongoa ike a Jisas, ta'e ingeie e manata'inie mola maraana uri mo pwaarongoisuli ko ere-ere mumuni i sulie mei ha'a-uusulinge ngeena. Oto ko te'uri hunire, “?Uri mei olana ni oto ko da omu ka'a sare lulu i sulieu? ");
INSERT INTO apb_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","?Ta'e nga taa nge omu kei lo'onga'inie aana maholo omu kei leesieu a Kale Ni Iinoni kei tahela'i ta'au i Lengi takoie leu nge nou uure aana? ");
INSERT INTO apb_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Li'oa Maa'i mone ko niie maurihe, nge mei ola mo iinoni sa'a roro'a ni hele aana ike aana nanamanga ikire maraada. Oto omu ke rongo diana mola hunie walaku, aana kire to'o aana nanamanga a Li'oa Maa'i hunie maurihe. ");
INSERT INTO apb_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Ta'e saehuu oto aana nga mo iini eemiu ka'a hiiwalaimoli ike ue.” A Jisas e ere urine aena aana e manata'inie oto uure mai aehotalana, kira tei nge kire sa'a hiiwalaimoli ike aana, na iini uri taa nge kei pweloa. ");
INSERT INTO apb_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Na a Jisas ko he'i te'uri lo'u, “Aena mei olana nge nou unue huni'omu uri nga iini sa'a lae ike mai seeku na a Mama'a e ka'a toolea mai seeku.” ");
INSERT INTO apb_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Aena urine, mo iini hunge aana mo pwaarongoisuli a Jisas kire du'e aaliho'i, na kire ka'a sare lae lo'u pe'ie. ");
INSERT INTO apb_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Oto a Jisas ko dolosi aana aawalai pwaarongoisuli mwana rue uuri, “?Oto i'omu, uri omu ko sare lae oto no'one mwaanieu?” ");
INSERT INTO apb_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","A Saemon Pita e aalamie oto ko te'uri, “?Melu ke si lae lo'u i tei, Poro paine? I'oe oto o to'o aana mo wala nge ko niie maurihe huu hunie iinoni. ");
INSERT INTO apb_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Melu hiiwalaimoli oto aamu, na melu saie uri i'oe oto Iini Maa'i e uure mai mwaanie a God.” ");
INSERT INTO apb_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Oto a Jisas ko si te'uri hunire, “I'omu oto aawalai mwane mwana rue nge nou lio hilisi'omu hunie omu ke lulu i sulieu, ta'e ngaeta iini eemiu nga li'oa aaela nge mola aana.” ");
INSERT INTO apb_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","A Jisas e ere urine mola hoorana a Jiudas, kalena Saemon Iskariot. A Jiudas e talei ne'ie taane ngaeta iini aana aawalai pwaarongoisuli mwana rue, ta'e kei saronai pweloa mola ue a Jisas. ");
INSERT INTO apb_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Oto puriha'ana walu ola ienini, a Jisas e si lae-lae hailiu mola i laona po'o ni henue i Kalili. E ka'a sare lae hailiu ike i laona po'o ni henue i Jiudia aena aana mo Jiu ta'au kire ko eri'apasie kire ke horo maesie. ");
INSERT INTO apb_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Maholona na ko kara'inie oto mo dinge paine ikire mo Jiu huni deu i sulie Houlaa Ni Aapa-aapa. ");
INSERT INTO apb_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Oto mo mwane aasine a Jisas kire mani hute, kire ko te'uri hunie, “O ke lae oto mwaanie i leu, na o ke lae ta'au hunie po'o ni henue paine i Jiudia uri hunie mo pwaarongoisuli i'oe kire ke leesie oto mo hu'i-hu'ite nge o ko esui'i ngeena. ");
INSERT INTO apb_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Nga iini ka'a mumumunie ike nga taa ko esuie, mala uri saena hunie ke ne'i mwane paine na hunie ahutana mwala ke sai diana aana. Oto aana o ko sare asuie mo ola ngeena, o ke lae ta'au i uure haada'i i na'ona walumalau.” ");
INSERT INTO apb_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Mo eesine a Jisas kire ere urine, aena aana ikire na kire ka'a hiiwalaimoli ike no'one aana. ");
INSERT INTO apb_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Oto a Jisas ko te'uri hunire, “Pongiku e ka'a hule ue, ta'e i'omu, omu ke lae mola aena aana ta'ena nga maholo e diana mola huni'omu. ");
INSERT INTO apb_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Mwala aana walumalau ie kire sa'a maaleledi'omu ike, ta'e ineu ni kire ko maaleledieu, aena aana no ko lae pe'i unu haata'inie uri nga taa kire ko esuie e aaela. ");
INSERT INTO apb_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","I'omu, omu ke lae mola ta'au aana Houlaa Ni Aapa-aapa ngeena. Ineu, nou sa'a lae ike ue ta'au aana houlaa ngeena, na e ka'a hule ue aana maholo ineu.” ");
INSERT INTO apb_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","A Jisas e ere urine mango, oto e si oore mola hao aana po'o ni henue i Kalili. ");
INSERT INTO apb_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Oto i purine mo mwane aasine kire lae mango ta'au i Jerusalem aana houlaa, nge a Jisas ko si lae lo'u i sulire. Ta'e e ka'a sare lae haada'i ike hunie mwala ke leesie. ");
INSERT INTO apb_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Oto mo na'ohai mwane mo Jiu ta'au i Jerusalem, kire ko hei-heitalea pe'i dolosinge hailiu uuri, “?A mwaena ni i tei?” ");
INSERT INTO apb_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Mwala oto hunge ikire ta'au i leune, na mo iini hunge aada ko talei kele sasawaru taane hailiu hunire i sulie a Jisas uuri, “Ingeie mwane diana ni ngeena.” Ngaeta mwala kire ko ere oolisire uuri, “Ha'ike, aana ko eeroa mola mwala.” ");
INSERT INTO apb_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Ta'e nga iini aada e ka'a sare ere haada'i lo'u, aena aana kire ko meni me'ute'inie mola mo na'ohai mwane ikire. ");
INSERT INTO apb_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Maholo ko hule oto i denumana e hiu hei dinge aana houlaa ngeena, nge a Jisas e si hanetaa ta'au i laona lolata aana Nume Maa'i Peine na ko aehota ha'a-uusulie oto mwala i leune. ");
INSERT INTO apb_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Mo na'ohai mwane mo Jiu ngeena kire ko tohungei pangata'i aana kire ko rongoa mo ha'a-uusulinge a Jisas. Oto kire ko te'uri, “A mwane ie nga iini e ka'a ha'a-uusulie ike. ?Oto e sai diana aana walu ola ienini ka'u uri taa?” ");
INSERT INTO apb_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Oto a Jisas e aalamire ko te'uri, “Mo ola no ko ha'a-uusuli eeni ie, ka'a mo ola ike tohuku. Ha'a-uusulinge ineu e uure mai mwaanie a God, iini e uusunge'inieu mei. ");
INSERT INTO apb_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Mala nga iini ko ne'isae moute'i huni deu i sulie saena God, nge ha'alaa ke si lio saie ha'a-uusulinge ineu. Na ke si saie uri ohe e uure mai mwaanie a God wa ohe e uure mola mwaanie mo lo'onga'inge ineu maraaku. ");
INSERT INTO apb_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Aana iinoni nge ko ere mola tohune, ingeie ngeena ko lo'ohie mola ha'apaina'alana maraana ni ngeena. Ta'e a tei nge ko sare ha'apaina'aa iini e uusunge'inieu mei, nge iini urine ko ere to'ohuu na nga mei eeronga ha'ike lo'u aana. ");
INSERT INTO apb_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","A Mosis e niie ka'u oto mo Ha'atolanga huni'omu, ta'e nga ta'a-ta'a iini eemiu e ka'a lulu i suli'i ike. ?Oto e ue ka'u omu ko si eri'apasie uri omu ke horo maesieu?” ");
INSERT INTO apb_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Oto mwala e loko ngeena kire ko aalamie a Jisas uuri, “!Mwae! !O ko tohungei pweu! ?Kira tei ni ko sare horo'i'o? !Sa'a mola, li'oa aaela oto aamu!” ");
INSERT INTO apb_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","A Jisas e aalamire oto ko te'uri, “Ta'a-ta'a mei ola ka'u nou esuie aana Dinge Maa'i ikie mo Jiu aana nou ha'a-uurie mwane e to'u ngeena, ta'e omu ko si meni upwesieu mola. ");
INSERT INTO apb_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Ta'e i'omu no'one omu sai esu mola aana mo Dinge Maa'i. Mo aamamiu oto wau i na'o kire aehotaa tolahai torihesi'onga, na lo'u mei puri a Mosis e si ha'a-uuresie lo'u ha'atolanga i sulie torihesi'onga ngeena. Oto aana omu ko sare tola i sulie mo Ha'atolanga a Mosis, ma'alana tohungei maholo hunie torihesi'onga e hule aana nga Dinge Maa'i, ta'e i'omu, omu ko lae pe'i esuie mola torihesi'onga ngeena. ");
INSERT INTO apb_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Oto ma'alana Dinge Maa'i, ta'e i'omu maraamiu, omu ko esuie torihesi'onga aana hai dingena hunie kele mwela mwane ngeena ke diana i sulie Ha'atolanga a Mosis. ?Oto e ue ka'u omu ko si saewasulieu haahie ha'a-uuringe nou esuie hunie ahutana sapena ngaeta mwane ke diana aana Dinge Maa'i? ");
INSERT INTO apb_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Mwaanie omu lei-leie ta'ena nga mei ola mola i sulie liotana, ta'e omu ke lei oto i sulie nga taa e to'ohuu.” ");
INSERT INTO apb_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Oto nga mo iini aana mwala ni Jerusalem ko te'uri, “Mwane nge mo rato ko eri'apasie uri kire ke horo maesie ni oto ie. ");
INSERT INTO apb_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","!Ta'e lio ka'u! Ko ere-ere oto nana mwala, ta'e mo rato ngeena ka'a si unu-unue nga mei ola aana. ?Mwaanie ohe kire ko lo'o-lo'onga'inie uri a mwane ngeena ni oto a Kraes? ");
INSERT INTO apb_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Ta'e maholo a Kraes kei lae mai, nga ta'a-ta'a iini e sa'a saie ike uri e uure i tei. A mwane ngeena kolu meni saie ka'u mola hanue ingeie.” ");
INSERT INTO apb_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Oto a Jisas ko si ere paine maholo ko ha'a-uusuli ta'au i laona lolata aana Nume Maa'i Peine, “Iau, omu saieu, na omu saie taane leu nou uure aana. Ta'e nou ka'a lae ike mola mai tohuku, na omu ka'a saie ike iini nge e uusunge'inieu mei, na ingeie e ka'a sai eero ike. ");
INSERT INTO apb_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Ineu ha'alaa nou manata'inie, aena aana nou uure oto mwaanie na ingeie e uusunge'inieu mei.” ");
INSERT INTO apb_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Oto kire ko si eri'apasie uri kire ke tapolie, ta'e e aasa mola, aena aana e ka'a hule ue aana maholo hunie ke mae. ");
INSERT INTO apb_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Ta'e mo iini hunge aana mwala ngeena kire hiiwalaimoli aana Jisas, na kire ko dodolosi aada hailiu uuri, “?Maholo a Kraes kei lae mai, uri kei esuie nga mo tolimaa hunge liutaa aana mo iini a mwane ie ko esui'ine?” ");
INSERT INTO apb_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Oto mo Parise kire rongoa mwala ko kele sasawarunge'inie walu olana i sulie a Jisas, oto ikire na mo na'ohai pris kire ko si uusunge'inie mo ramo kakakali aana Nume Maa'i Peine huni lae i tapolie a Jisas. ");
INSERT INTO apb_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Oto a Jisas ko te'uri hunire, “No ko kele ii'o o'oru'e mola pe'i'omu, na no ko lae oto lo'u i saana iini e uusunge'inieu mei. ");
INSERT INTO apb_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Omu kei lo'ohieu, ta'e omu sa'a lio oodoieu ike, aena aana omu sa'a lae ike i hule aana leu ne kei lai ii'o aana.” ");
INSERT INTO apb_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Oto mo na'ohai mwane mo Jiu kire ko lae pe'i ere-ere maraada uuri, “?A mwane ie kei lae i tei ni uri kolu sa'a lio oodoie lo'u? ?Mwaanie ohe kei lae i saana mwala ikolu aana mo po'o ni henue mo Krik, wa ohe kei lae huni ha'a-uusulie mo Aapoloa Aaopa? ");
INSERT INTO apb_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Aana e unue uri kolu kei lo'ohie ta'e kolu sa'a lio oodoie ike, na uri kolu sa'a lae ike i hule aana leu kei lai ii'o aana. ?Nga mei taa ni e ere urine aana?” ");
INSERT INTO apb_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Oto aana dinge ooreta, nge e ne'i dinge paine oto liutaa aana houlaa ngeena, a Jisas e uure, oto ko ere paine uuri, “Mala uri nga iini ko maarou, nge ke lae mai seeku hunie ke inu. ");
INSERT INTO apb_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Mala oto mo Uusu-uusu Maa'i e unue uri Iini ko hiiwalaimoli eeku, nge huulaa aani wei nge ko niie maurihe kei hure'itaa mai mwaanie saena.” ");
INSERT INTO apb_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Maholo a Jisas e ere urine, e ere rarangana Li'oa Maa'i a God nge kei ii'o i lalo aana mo iini kire ko hiiwalaimoli aana. Aana maholona niilana Li'oa Maa'i e ka'a lae ike ue, aena aana ha'amanikulu'alana a Jisas e ka'a lae ike no'one ue. ");
INSERT INTO apb_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Oto maholo mwala ngeena kire rongoa ko ere urine, ngaeta mo iini aada kire ko si te'uri, “A mwane ie ni oto propet paine nge kolu ko maa-maa'oohiena.” ");
INSERT INTO apb_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Ngaeta mo iini lo'u kire ko unue uuri, “Ingeie ni oto a Kraes.” Ta'e ngaeta mo iini kire ko unue mola uuri, “?Uri a Kraes kei lae mai uure i Kalili? !Ha'ike! ");
INSERT INTO apb_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Aana mo Uusu-uusu Maa'i e unue uri a Kraes kei uure oto aana komu a Deved Inemauri, na kei hute oto i Betlehem, aana huilume nge a Deved Inemauri e o'o'o aana.” ");
INSERT INTO apb_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Oto mwala ngeena kire ko si oopa i tehula'ana Jisas. Nga mo iini ko ere ha'adiana'aa, ta'e nga mo iini ko ere aaelasie mola. ");
INSERT INTO apb_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Nga mo iini aada ko sare tapolie oto a Jisas, ta'e nga iini ka'a tari mwada'u ike aana. ");
INSERT INTO apb_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Maholo mo ramo kakakali kire aaliho'i ta'au i saana mo na'ohai pris na mo Parise, oto kire ko dolosi aada uuri, “?E ue omu ka'a toolea oto poi a Jisas?” ");
INSERT INTO apb_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Oto kire ko aalamire uuri, “!Nga iinoni hunie ke ere ni saenanaunge lo'u mala a mwaena, ha'ike oto oo'oo!” ");
INSERT INTO apb_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Oto mo Parise ko aalamire uuri, “?Mwaanie ohe a mwaena e pwelo'omu no'one mola? ");
INSERT INTO apb_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","?Uri nga iini aana mo na'ohai mwane wa mo Parise kire hiiwalaimoli aana? ");
INSERT INTO apb_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","!Ha'ike! Ta'e pulitaa ni iinoni reu mola kire hiiwalaimoli aana. Ta'e ikire, kire ka'a saie ike nga mei ola aana mo Ha'atolanga a Mosis, na a God ke si ha'aloire.” ");
INSERT INTO apb_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Oto a Nikodimas, ngaeta mwane aana mo Parise nge e lae ka'u i leesie a Jisas i na'o, na ingeie nga iini aana mo mwane paine ngeena ko te'uri hunire, ");
INSERT INTO apb_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“?Uri mo Ha'atolanga ikie e sai toli'aasie hunie kie ke lei mae aana nga iinoni na kie ka'a hola'i rongo diana aana, na lio oodoie nga taa nge e dau aaelasie? Nou saie ha'ike.” ");
INSERT INTO apb_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Oto kire aalamie, kire ko si te'uri, “?Uri i'oe no'one o uure i Kalili? O ke lio diana aana ka'u mo Uusu-uusu Maa'i, na o ke leesie nga ta'a-ta'a propet e ka'a lae ike mai uure mwaanie i Kalili.” ");
INSERT INTO apb_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Oto kire mani ta'ela'i, kire ko si eeliho'i takoie mo nume ikire. ");
INSERT INTO apb_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Oto a Jisas e lae ta'au aana uuwo nge kire haara'inie Uuwo Ni Ei Olif. ");
INSERT INTO apb_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Na oto i maahu'o-hu'o aana hai dinge lo'u mola i sulie, a Jisas e he'i eeliho'i lo'u ta'au i lolata aana Nume Maa'i Peine. Oto ahutana mwala e ruru mei saana, e si ii'o i aano huni ha'a-uusulire. ");
INSERT INTO apb_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Oto mo ha'a-uusuli aana mo Ha'atolanga a Mosis na mo Parise kire toolea mai ngaeta keni nge kire tapolie maholo ko aeni ola pe'ie nga poro aaopa. Oto kire toolea oto mai i matolada, kire ko si te'uri hunie a Jisas, ");
INSERT INTO apb_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","“Ha'a-uusuli, a keni ie melu tapolie maholo ko ae'aeni ola ue pe'ie mwane aaopa mwaanie poro ingeie. ");
INSERT INTO apb_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Aana mo Ha'atolanga ikie, a Mosis e unue uri kie ke uu'i maesie aani heu mo keni nge kire ko tete'urine. ?Oto i'oe, nga taa o kei unue aana?” ");
INSERT INTO apb_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Kire lupwe'i dodolosi mola urine huni pweloa a Jisas, hunie uri kire ke ha'asusu eero-eero i lengine. Ta'e a Jisas e ooroma'i mola i aano, na ko uusu-uusu i mwakano aana ri'i-ri'ine. ");
INSERT INTO apb_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Mo ha'a-uusuli na mo Parise kire ko lae pe'i dodolosi lo'u aana, oto lae-lae a Jisas e uure hala-hala i lengi, ko si te'uri hunire, “Mala nga iini hikemiu ko saie uri e ka'a dau hu'isie ike ue nga mei ooraha'aa, nge ke hola'i uu'ie a keni ie aani heu.” ");
INSERT INTO apb_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Oto e he'i ooroma'i lo'u i aano, ko uusu-uusu lo'u i mwakano aana ri'i-ri'ine. ");
INSERT INTO apb_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Maholo mo ha'a-uusuli na mo Parise kire rongo urine, kire ko si aehota oopa mwaanie. Mo repo ni mwane oto kire hola'i lae, nga iini ko lae, na nga iini e lae lo'u. Oto lae-lae ta'e a Jisas mola e si oore maraana pe'ie a keni ngeena i matolana mwala i laona lolata ngeena. ");
INSERT INTO apb_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","A Jisas e uure hala-hala, oto ko te'uri hunie a keine, “?Mwala ngeena oto i tei? ?Uri nga iini e ka'a oore lo'u huni lei mae aamu?” ");
INSERT INTO apb_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Oto a keine ko aalamie a Jisas uuri, “Nga ta'a-ta'a iini ha'ike lo'u, Poro paine.” A Jisas ko si unue hunie a keine uuri, “Ineu, na nou ka'a lei mae ike no'one aamu. O ke lae oto, ta'e mwaanie o he'i ooraha'aala lo'u.” ");
INSERT INTO apb_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Oto a Jisas ko he'i ere uuri lo'u hunie mo Parise, “Ineu oto raa-raa hunie mo iinoni aana walumalau. Iini ko lulu i sulieu, e sa'a he'i lae lo'u i laona rodohono, ta'e kei to'o aana raa-raa nge e sai niie maurihe.” ");
INSERT INTO apb_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Oto mo Parise ko si te'uri hunie, “I'oe mola ni o ko ere i suli'o maraamu ngeena, na nga taa o ko unue ngeena e ka'a to'ohuu ike.” ");
INSERT INTO apb_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Oto a Jisas e aalamire ko si te'uri, “!Ha'ike! Ma'alana no ko ere i sulieu maraaku urine, ta'e nga taa nou unue e to'ohuu taane. Aana ineu nou saie leu nou uure mai mwaanie, na leu no ko lae hunie. I'omu, omu ka'a saie ike leu nou uure mai mwaanie, wa leu no ko lae hunie. ");
INSERT INTO apb_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","I'omu, omu ko lei-lei mola i sulie tolahai iinoni ni welumalau. Ineu, nou sa'a leie ike nga iini urine. ");
INSERT INTO apb_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Ta'e mala uri ne kei leie nga iini, ne kei lei oodo-oodo mola aana. E to'ohuu oto aena aana nou ka'a sai lei ike maraaku, aana Aamaku nge e uusunge'inieu mei nge kei pe'ieu. ");
INSERT INTO apb_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Mo Ha'atolanga i'omu maraamiu e unue uri mala nga ro iini ko meni unue ta'a-ta'a mei ola, nge ha'alaa omu sai hiiwalaimoli aana nga taa kire ko unuena. ");
INSERT INTO apb_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Oto ineu oto ngaeta iini huni ere i sulieu, na Aamaku nge e uusunge'inieu mei, ingeie oto ruana nga iini huni ere ha'a-oaie nga taa no ko unue i sulieune.” ");
INSERT INTO apb_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Oto kire ko si dolosi aana Jisas uuri, “?Oto aamamu ingeie i tei?” A Jisas e aalamire oto ko te'uri, “Omu ka'a saieu ike, ka'u omu ka'a saie ike no'one Aamaku. Mala uri omu ke saieu, ha'alaa omu saie oto no'one Aamaku.” ");
INSERT INTO apb_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","A Jisas e unue mo wala ienini aana maholo e ha'a-uusulie mwala ta'au i laona lolata aana Nume Maa'i Peine kara'inie leu nge mwala ko nii-nii to'oha aana. Na nga iini e ka'a tapolie ike, aana e ka'a hule ike mone ue aana maholo hunie ke mae. ");
INSERT INTO apb_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Oto a Jisas e he'i te'uri lo'u hunire, “Ne kei lae oto mwaani'omu, na omu kei hei-heitaleau taane, ta'e omu sa'a lio oodoieu ike. Na aena urinena nge mo ooraha'aa i'omu kei ii'o ue aamiu lae hule aana omu kei mae. Oto omu sa'a lae ike aana leu no ko lae aana.” ");
INSERT INTO apb_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Oto mo na'ohai mwane mo Jiu ngeena, kire ko te'uri hunire maraada, “E unue uri kolu sa'a lae ike aana leu ko lae aana. ?Mwaanie e lo'onga'inie uri kei lai horo'ie maraana?” ");
INSERT INTO apb_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","A Jisas e aalamire oto ko te'uri, “I'omu mwala mola aana walumalau mei aano ie ni ngeena, ta'e ineu nou lae mai uure ta'au i Lengi. I'omu, omu uure mwaanie walumalau ie, ta'e ineu, nou ka'a uure ike mwaanie walumalau ie. ");
INSERT INTO apb_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Aena ngeena nou unue oto huni'omu uri mo ooraha'aa i'omu sae'aasileni e sa'a lae ike huni'omu. Mala uri omu ka'a hiiwalaimoli ike aana uri ineu oto iini e ii'o huu, nge mo ooraha'aa i'omu kei ii'o mola ue aamiu hule aana omu kei mae.” ");
INSERT INTO apb_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Oto kire ko si dolosi aana a Jisas uuri, “?I'oe ni a tei?” Oto a Jisas e aalamire ko te'uri, “Ineu oto iini nge nou unue ka'u oto huni'omu. ");
INSERT INTO apb_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Mo ola hunge taane ue aaku huni unu'i huni'omu na huni lei'omu eeni, ta'e nou ka'a unu'i ike mola tohuku, aana no ko unue mola hunie walumalau walana iini e uusunge'inieu mei, na ingeie oto iini walaimolinge nge aana.” ");
INSERT INTO apb_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Ta'e mwala kire ka'a rongo saie ike mola uri a Jisas ko ere-ere hunire i sulie Aamana. ");
INSERT INTO apb_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Oto a Jisas ko si te'uri hunire, “Maholo omu kei ta'eau a Kale Ni Iinoni i lengi pe'ie hai ei, nge omu ke si saie uri ineu oto iini e ii'o huu. Nou ka'a da ike taane nga mei ola tohuku, ta'e no ko unu-unue mola mo ola a Mama'a e ha'a-uusulieu eeni. ");
INSERT INTO apb_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Na iini e uusunge'inieu mei, ingeie taane pe'ieu, e ka'a toli'aasieu ike mola maraaku, aena aana no ko hele i sulie saena mola tarau.” ");
INSERT INTO apb_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Oto maholo ko ere-ere ue, mo iini hunge aada kire unue uri kire ko hiiwalaimoli oto aana. ");
INSERT INTO apb_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Oto a Jisas ko si te'uri hunie mo Jiu nge kire unue kire hiiwalaimoli aana ngeena, “Mala uri omu kei lulu i sulie mo ha'a-uusulinge ineu, nge omu ke si ne'i pwaarongoisuli ineu oto to'ohuu. ");
INSERT INTO apb_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Oto omu ke si manata'inie walaimolinge aana God, na walaimolinge ngeena ke si da omu ke ii'o luheta'i mwaanie nanamanga nge omu ko esu ni ho'o nana.” ");
INSERT INTO apb_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Oto kire aalamie a Jisas uuri, “!Ha'ike eena! I'emi mo weuwana Ebraham, na emi ka'a asu ni ho'o ike ue nana nga iini. ?E ue nge o ko unue uri walaimolinge ke si da emi ke ii'o luheta'i?” ");
INSERT INTO apb_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Oto e aalamire uuri, “No ko unue oto to'ohuu huni'omu uri nga iini nge ko oora-ooraha'aa, ingeie ngeena ko esu ni ho'o oto aana ooraha'aa eena. ");
INSERT INTO apb_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Omu meni saie taane uri iinoni ko esu ni ho'o mola, e sa'a ii'o oto huu pe'ie poro paine nge e to'o aana. Ta'e tohungei Kalena poro paine aana nume, ingeie oto kei ii'o oto huu pe'ie aamana, na pe'ie ta'a-ta'a nanamanga no'one mala ingeie. ");
INSERT INTO apb_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Oto mala uri a Kale ko luhesi'omu, nge ha'alaa omu ko ii'o luheta'i to'ohuu. ");
INSERT INTO apb_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Nou lio saie taane uri i'omu mo weuwana Ebraham. Ta'e aena aana omu ka'a sare hiiwalaimoli ike aana walaku, nge omu ko eri'apasie mola uri omu ke horo maesieu. ");
INSERT INTO apb_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Ineu, no ko ere-ere mola i sulie mo ola nou leesi'i aana Aamaku, ta'e i'omu, omu ko deu i sulie nga taa aamamiu e unue huni'omu.” ");
INSERT INTO apb_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Oto kire aalamie a Jisas uuri, “!Aamameelu to'ohuu oto a Ebraham, mwae!” Oto a Jisas e te'uri hunire, “!Ha'ike! Aana mala uri i'omu mo kalena Ebraham to'ohuu, ha'alaa omu ko kara'i esuie mo ola diana nge e au'esui'i. ");
INSERT INTO apb_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Ta'e i'omu, omu ko si eri'apasie mola uri omu ke horo'ieu i tehula'ana uri ineu no ko sare ha'arongo'omu aana mo wala to'ohuu nou rongo'i mwaanie a God. A Ebraham e ka'a tete'urine ike. ");
INSERT INTO apb_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","I'omu, omu ko deu oto mola i sulie tolahana tohungei aamamiu ni ngeena.” Oto kire ko aalamie uuri, “!Ha'ike eena! !I'emeelu nga mo kaleni aro-aro ha'ike! A God maraana oto aamameelu, na i'emeelu oto mo tohungei kalena.” ");
INSERT INTO apb_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Oto a Jisas ko te'uri hunire, “Mala uri a God ke ne'i aamamiu to'ohuu, ha'alaa omu manata diana hunieu, aena aana nou uure oto mai mwaanie a God na ineu oto i seemiu ie. Nou ka'a lae ike mola mai tohuku, ta'e ingeie ni e uusunge'inieu mei. ");
INSERT INTO apb_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","?E ue nge omu ka'a sai rongo saie nga taa no ko unu-unue? Omu ka'a sai rongo saie aena aana omu ka'a sare rongo ike hunie walaku. ");
INSERT INTO apb_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","I'omu oto mo kalena a Pwelu Eero-eero, na saemiu uri omu ke lae mola i sulie mo ne'isaenga ingeie. Oto tarau, ingeie iini e talei horo mola, na e leledie walaimolinge, aena aana walaimolinge ha'ike no'one aana. Maholo ko ere aani eeronga, nge ko ere-ere oto aana tohungana erenga ni henue ingeie eena, aena aana ingeie iinoni eero-eero, na ingeie aamana oto mo eeronga. ");
INSERT INTO apb_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","“Ta'e ineu mone no ko ere aana walaimolinge, na aena mei olana nge omu ka'a sare hiiwalaimoli ike aaku. ");
INSERT INTO apb_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","?A tei iini hikemiu e sai haata'inie uri nou deu hu'isie nga mei ooraha'aa? No ko ere-ere mola aana walaimolinge. ?Ta'e e ue ka'u omu ka'a sai hiiwalaimoli eeku? ");
INSERT INTO apb_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Nga iini oto e uure aana God ha'alaa ko rongo hunie walana God. Ta'e i'omu, omu ka'a sare rongo ike hunie walana, aena aana i'omu mone nga mo iini a God ha'ike.” ");
INSERT INTO apb_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Oto mo na'ohai mwane mo Jiu ngeena, kire ko unue hunie a Jisas uuri, “!Aaii! Si'ue, melu ere to'ohuu oto, aana melu unue uri i'oe mwane aaela ni Samaria, na uri li'oa aaela nge aamu.” ");
INSERT INTO apb_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Oto a Jisas e aalamire uuri, “Nga li'oa aaela ha'ike aaku. Ineu no ko ha'ama'u aana Aamaku, ta'e i'omu omu ko si ere aaelasieu mola. ");
INSERT INTO apb_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Ineu nou ka'a ari'apasie ike manikulu'anga nakue maraaku. Ta'e iini ko eri'apasie ne ke manikulu'e e ii'o taane, na ingeie oto iini kei leie walumalau. ");
INSERT INTO apb_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","No ko unue oto huni'omu uri ta'ena nga iini ko lulu i sulie walaku, e sa'a mae oto oo'oo.” ");
INSERT INTO apb_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Oto mo na'ohai mwane ngeena ko te'uri lo'u hunie a Jisas, “Melu ko si lio saie uri li'oa aaela nge aamu to'ohuu eena. Aana a Ebraham e mae oto, na oto ahutana mo propet kire mani mae mango. Ta'e i'oe o ko si unue uri ta'ena nga iini ko lulu i sulie walamu, e sa'a mae oto oo'oo. ");
INSERT INTO apb_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","?Ohe o lo'onga'inie uri i'oe o paine liutaa aana weuwaka a Ebraham? Ingeie, e mae oto na ahutana mo propet kire mae oto no'one. ?Oto o ko lo'onga'inie uri i'oe a tei eena?” ");
INSERT INTO apb_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Oto a Jisas ko aalamire uuri, “Mala uri ne kei ha'amanikulu'aau mola maraaku, nga mei lo'onga'inge ha'ike aana manikulu'anga ineu ngeena. Ta'e iini nge ko ha'amanikulu'aau oto Aamaku, iini nge omu ko unue oto uri ingeie God i'omu. ");
INSERT INTO apb_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","I'omu hule aana omu ka'a saie ike, ta'e ineu ha'alaa nou sai diana aana. Oto mala ne ke unue uri nou ka'a saie ike, nge ne kei ne'i iinoni eero-eero no'one mala i'omu eena. !Ta'e ha'ike! Nou sai diana aana taane, na no ko lulu i sulie walana. ");
INSERT INTO apb_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Weuwaka a Ebraham e sae-sae diana aana e lo'onga'inie kei leesie pongiku. Oto e leesieu taane, na e tohungei saemango oto hiito'o.” ");
INSERT INTO apb_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Oto mo na'ohai mwane mo Jiu ngeena, ko te'uri lo'u hunie a Jisas, “I'oe hule aana nga lime aawalai helisi e ka'a mango ue aamu. ?Oto o ko si unue uri o leesie a Ebraham oto wau i na'o? !Aaii!” ");
INSERT INTO apb_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Oto a Jisas e te'uri hunire, “No ko unue oto huni'omu uri, a Ebraham e si hute, na ineu, nou ii'o oto.” ");
INSERT INTO apb_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Oto kire so'o hau huni uu'i maesie, ta'e a Jisas e liu mumuni mola mwaanire, e si lae oto mwaanie Nume Maa'i Peine. ");
INSERT INTO apb_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","A Jisas e lae-lae, na ko leesie mwane e hute na e ulu oto. ");
INSERT INTO apb_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Oto mo pwaarongoisuli ingeie ko dolosi aana uuri, “?Ha'a-uusuli, a tei ni e ooraha'aala ka'u nge e asuie a mwane ie e hute na e ulu oto uuri ie? ?Ohe e hute urine i tehula'ana mo ooraha'aanga ingeie maraana, wa i tehula'ana mo ooraha'aanga e ro mau'ana ingeie?” ");
INSERT INTO apb_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","A Jisas e aalamire oto ko te'uri, “Ulunge ingeie ngeena, ka'a ike i tehula'ana nga mei ooraha'aanga ingeie maraana wa uri e ro mau'ana ingeie. E ulu urine hunie uri haata'inilana nanamanga a God ke lae maholo ha'a-uurilana kei lae. ");
INSERT INTO apb_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Maholo kolu ko mau-meuri ue e urihana mola e dai-dengi ue, na kolu sai esu oto nana iini e uusunge'inieu mei. Ta'e aana maholo kei rodo oto, na nga iini e sa'a asu ike lo'u. ");
INSERT INTO apb_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Maholo nou ii'o ue mai laona walumalau, ineu oto raa-raa hunie walumalau.” ");
INSERT INTO apb_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","A Jisas e ere mango urine, e si ngisu i mwakano na ko esuie mei pwii-pwii aana ho ngisu ngeena. Oto e aaloha'inie mei pwii-pwii ngeena i maana a mwaena, ");
INSERT INTO apb_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","ko si unue hunie uuri, “O ke lae hodalie maamu i laona lama i Saeloam.” (Ne'isaenga aana mei wala aana ere-erenga mo Jiu “Saeloam” ngeena nge “Uusunge'inie.”) Oto a mwaena e lae, e hodalie maana e si eeliho'i poi, na ko lio-lio oto. ");
INSERT INTO apb_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Oto mwala e ii'o kara'inie aana hanue ingeie na mo iini e talei lee-leesie ka'u aana e susuke to'oha hola'ina'o, kire ko dolosi heiliu aada uuri, “?Uri mwane nge e talei susuke to'oha ni oto ie?” ");
INSERT INTO apb_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Nga mo iini kire ko unue uuri, “Ingeie ni otona.” Ta'e ngaeta mo iini kire ko unue lo'u uuri, “!Ha'ike! Ingeie ha'ike, ta'e e lio mola mala ingeie.” Oto a mwaena maraana ko unue uuri, “Ineu ka'u oto mwane nge nou susuke oto i na'o ngeena.” ");
INSERT INTO apb_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Oto kire ko dolosi aana uuri, “?Nga taa nge e da o ko lio-lio lo'u ngeena?” ");
INSERT INTO apb_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","A mwaena e aalamire, oto ko te'uri, “Mwane satana a Jisas e da mei pwii-pwii, oto e aalohie maaku aana, e si unue hunieu uri ne ke lai hodalie maaku i Saeloam. Oto nou lae, nou hoda maa mango mola, na no ko lio-lio oto lo'u.” ");
INSERT INTO apb_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Oto kire ko dolosi aana a mwaena uuri, “?Ingeie oto i tei?” E aalamire uuri, “Nou ka'a saie oto.” ");
INSERT INTO apb_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Oto kire toolea mwane nge e ulu ke'u ngeena i saana mo Parise. ");
INSERT INTO apb_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Na hai dinge nge a Jisas e da mei pwii-pwii na e tahanie maana mwane e ulu ngeena aana, Dinge Maa'i Mo Jiu ni ngeena. ");
INSERT INTO apb_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Oto mo Parise ko dolosi lo'u aana mwaena mala mwala nge kire hola'i dolosi ke'u aana uri nga taa ni e da maana nge ko lio-lio oto lo'u. Oto e unue hunire uuri, “E aalohie maaku aana mei pwii-pwii, oto nou hodalie maaku nge no ko lio-lio oto lo'u ie.” ");
INSERT INTO apb_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Oto ngaeta mo Parise ko te'uri, “Mwane nge e asuie mei ola ienini, e ka'a uure ike aana God, ka'u e ka'a kineta'inie ike ha'atolanga aana Dinge Maa'i.” Ta'e ngaeta mo iini ko unue uuri, “Iinoni ooraha'aala e sa'a asuie ike mo hu'i-hu'ite mala ienini,” Oto mei oopanga ko reu i matolada mo Jiu i tehula'ana mo wala ienini. ");
INSERT INTO apb_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Oto mo Parise kire he'i dolosi lo'u aana a mwaena uuri, “?Ha'alaa e tahanie maamu urine, oto i'oe, nga taa nge o kei unue aana a mwane ngeena?” Oto a mwaena e aalamire uuri, “Ingeie nga propet.” ");
INSERT INTO apb_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Ta'e mo na'ohai mwane aana mo Jiu ngeena ka'a sare hiiwalaimoli ike aana uri a mwane ngeena e ulu-ulu ke'u, na ko lio oto lo'u. Oto kire haro soie lo'u aamana na nikana, ");
INSERT INTO apb_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","na kire dolosi aadarue uuri, “?A kalemore'i ni ie? ?Uri ingeie ni more unue e hute na e ulu oto? ?Oto nga taa nge e da ko lio-lio oto lo'u ngeena?” ");
INSERT INTO apb_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Oto aamana na nikana mwaena e aala, na kirerue ko te'uri, “Mere saie uri mwane kalemere'i ni ie, na mere saie uri e hute na e ulu oto. ");
INSERT INTO apb_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Ta'e mere ka'a saie ike uri nga taa e da nge ko lio-lio oto lo'u ie, wa mere ke saie uri a tei ni e tahanie maana. Omu ke dolosi mola aana. Ingeie e rato oto hunie ke aala maraana.” ");
INSERT INTO apb_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Aamana na nikana kirerue ere urine, aena aana kirerue ma'ute'inie mo na'ohai mwane aana mo Jiu. Aana kire unue oto uri nga iini ko hiiwalaimoli aana a Jisas uri ingeie a Kraes, kire kei ne'ie i sinaha mwaanie nume ni palo-palo mo Jiu. ");
INSERT INTO apb_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Aena mei olana nge aamana na nikana kirerue unue uuri, “E rato oto. Omu ke dolosi mola aana.” ");
INSERT INTO apb_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Oto kire ko he'i soie lo'u mwane nge e ulu ke'u ngeena mai saada, na kire ko te'uri hunie, “O ke ere to'ohuu mola huni ha'amanikulu'aa God, na mwaanie o eero lo'u. Aana i'emeelu, melu saie uri a mwane ngeena, ingeie iinoni ooraha'aala.” ");
INSERT INTO apb_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Oto a mwaena ko aalamire uuri, “Nou ka'a saie ike uri ingeie nga mwane ooraha'aala wa ha'ike. Ta'a-ta'a leu mola nou saie, nge uri nou ulu ke'u, na ie no ko lio-lio oto lo'u.” ");
INSERT INTO apb_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Oto kire ko dolosi lo'u aana a mwaena uuri, “?E ua'o? ?E tahanie maamu uri taa?” ");
INSERT INTO apb_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","A mwaena e aalamire oto ko te'uri, “Nou unue ka'u oto huni'omu, ta'e omu ka'a sare rongo hunieu. ?E ue nge omu ko sare rongoa uri ne ke ladoa lo'u nga taa e raune? ?Ohe omu ko sare ne'i pwaarongoisuli ingeie lo'u no'one?” ");
INSERT INTO apb_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Oto kire ko si tohungei ere aaelasie na kire ko unue lo'u uuri, “I'oe oto ngaeta pwaarongoisuli a mwane aaela ngeena, ta'e i'emeelu, melu ko lulu i sulie a Mosis, propet paine i'emeelu. ");
INSERT INTO apb_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Kie mani saie uri a God e ere to'ohuu hunie a Mosis, ta'e a mwane aaela ngeena, na hule aana melu ka'a saie ike uri e uure i tei.” ");
INSERT INTO apb_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Oto a mwaena e aalamire ko te'uri, “!Aana e urine na mei ola ni pangata'inge! Omu ka'a saie ike uri e uure i tei, ta'e ingeie nge iini e tahanie maaku. ");
INSERT INTO apb_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Kie mani saie uri a God e ka'a sai rongo ike hunie kira ooraha'aala, ta'e e sai rongo mola hunie mo iini kire manata'inie a God na ko deu i sulie saena. ");
INSERT INTO apb_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Uure oto mai i aehotalana walumalau, nga iini e ka'a rongoa ike ue nga ta'a-ta'a iinoni ke tahanie maana nga iini e hute na e ulu oto. ");
INSERT INTO apb_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Mala uri mwane nge e tahanie maaku ie ke su'uri uure mai mwaanie a God, ha'alaa e sa'a roro'a ni esuie ike nga mei ola urine.” ");
INSERT INTO apb_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Oto kire aalamie na kire ko te'uri hunie, “!I'oe o hute, na o ooraha'aa oto! ?Uri o ko sare ha'a-uusuli'emeelu?” Oto kire si aasie i sinaha mwaanie nume ni palo-palo. ");
INSERT INTO apb_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Maholo a Jisas e rongoa uri kire aasie mwane nge e tahanie maana i sinaha, oto e lae lo'ohie na ko dolosi aana uuri, “?Uri o hiiwalaimoli taane aana a Kale Ni Iinoni?” ");
INSERT INTO apb_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Oto a mwaena e aalamie uuri, “?A tei ni ingeie, Poro paine? O ke unue oodoieu hunie ne ke hiiwalaimoli aana.” ");
INSERT INTO apb_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Oto a Jisas ko te'uri hunie, “O leesie ka'u oto, na ingeie ka'u oto ko ere-ere pe'i'o ie.” ");
INSERT INTO apb_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Oto a mwaena e si te'uri, “!Nou hiiwalaimoli oto aamu, Poro paine!” Oto e pouruuru i na'ona a Jisas, na ko palo-paloa oto. ");
INSERT INTO apb_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Na a Jisas e te'uri, “Nou lae mai laona walumalau ie hunie uri tohungei ii'onga mo iinoni ke haada'i. Mo iini e ulu aana kire ka'a lio saie ike walaimolinge i sulie a God, ne kei da uri kire ke lio-lio lo'u. Na mo iini kire ko eero mola uri kire lio saie walaimolinge i sulie a God, ne kei haata'inie mola uri ikire mo iini e ulu.” ");
INSERT INTO apb_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Ngaeta mo Parise nge kire uure wau kara'inie kire rongoa a Jisas e ere urine, oto kire ko dolosi aana uuri, “?Uri o ko unue uri i'emeelu ni melu ulu?” ");
INSERT INTO apb_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Oto a Jisas ko te'uri hunire, “Mala uri omu ke ulu to'ohuu aena aana omu ka'a rongo saie ike walaimolinge, nge ha'alaa omu ka'a roro'a ike aana ooraha'aa. Ta'e aana omu ko unu-unue uri omu ko lio-lio mola na uri omu saie walaimolinge, ngeena omu roro'a aana ooraha'aanga i'omu.” ");
INSERT INTO apb_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Oto a Jisas ko he'i unue lo'u uuri, “No ko unue oto huni'omu uri iinoni nge e ka'a sili ike i sulie maa aana para ni sipu ta'e ko hane mola aana nga leu aaopa, ingeie iinoni peli-peli na iini horo-horo. ");
INSERT INTO apb_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Ta'e tohungei kakalihe hunie mo sipu, ingeie oto ko sili mola i sulie maa aana para. ");
INSERT INTO apb_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Na mwane nge ko kakalie maai para ko tahanie maa talana tohungei kakalihe. Oto tohungei kakalihe ko soie mo sipu ingeie aana satada, na kire rongo saie walana na kire ko lae oto mai saana. Oto a kakalihe ko si ha'atalaire i sinaha takoie leu nge hahalisi kohi huni ngeue e ii'o aana. ");
INSERT INTO apb_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Maholo ko ha'a-iisitaanga'inie ahutana mo sipu ingeie, nge ko si na'oda. Na mo sipu ingeie ko lulu i sulie, aena aana kire rongo saie walana. ");
INSERT INTO apb_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Mala uri nga iinoni aaopa kei lae mai saana mo sipu kire sa'a roro'a ni lulu i sulie ike, ta'e kire kei tehi mola mwaanie aena aana kire ka'a rongo saie ike walana.” ");
INSERT INTO apb_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","A Jisas e unue mei aalahuunge ie hunire, ta'e kire ka'a saie ike uri nga taa ni ko sare unue hunire. ");
INSERT INTO apb_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Oto a Jisas ko he'i te'uri lo'u, “No ko unue oto to'ohuu huni'omu, ineu oto domana maa hunie mo sipu. ");
INSERT INTO apb_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Ahutana mo iini kire hola'i lae mai i na'oku nge kire unue uri ikire mo kakali sipu, ikire mwala peli-peli na mwala horo-horo mola. Oto mo sipu ka'a rongo ike hunire. ");
INSERT INTO apb_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Ineu oto domana maa nge mo sipu ko liu-liu aana, aana kire ko sili mei i laona para hunie kire ke ii'o sapemawa, na kire ko iisi-iisitaa lo'u huni lae i lo'ohi ngeulaa. Oto e urine lo'u eeku, aana iini ko liu i seeku ha'alaa ha'a-uurilana ko lae, na kei oodoie mo ola diana huni pe'ie mauriha'ana. ");
INSERT INTO apb_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Iinoni peli-peli ko lae mola mai huni peli na huni horo na huni waelie mola nga mo ola. Ineu, nou lae mai uri hunie kire ke hele aana maurihe huu, maurihe nge nga mei ola diana e ka'a ai'aa ike mwaanie. ");
INSERT INTO apb_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Ineu oto a kakalihe diana, iini e mwa'e-mwa'e ni mae honotana mo sipu. ");
INSERT INTO apb_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Iinoni eu'esu nge ko hele waaite mola huni lio i sulie mo sipu, e aaopa mwaanie a kakalihe iini e to'o aana oto mo sipu. Maholo iinoni eu'esu ko leesie wawaulo ko lae mai, oto ko tehi mola mwaanie mo sipu. Oto wawaulo ngeena ko si polahi'i na kire ko tatanga hailiu oto. ");
INSERT INTO apb_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Iinoni eu'esu ngeena ko tehi mola urine, aena aana ko esu uei waaite mola, na e ka'a tohungei manata diana ike hunie mo sipu. ");
INSERT INTO apb_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","“Ineu oto a kakalihe diana. Mala oto a Mama'a e saieu na ineu nou saie a Mama'a, e urine no'one mola mala ineu, nou saie mo sipu ineu, na ikire, kire saieu. Na nou mwa'e-mwa'e oto ni mae honotani. ");
INSERT INTO apb_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Nou to'o aana taane ngaeta mo sipu na ikire ha'ike ue i laona para ni sipu ineu. Ta'e ne kei haro toole'i taane ue mai hunie kire ke ii'o pe'ie mo iini kire ii'o oto i laona para. Kire kei haro ne'ie ta'a-ta'a hakaa ni sipu mola, na ineu oto ta'a-ta'a kakalihe nge kire sai rongo hunie. ");
INSERT INTO apb_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","A Mama'a e manata diana hunieu, aena aana nou mwa'e-mwa'e ni toli'aasie mauriha'aku hunie uri ne ke si hele aaliho'i lo'u aana. ");
INSERT INTO apb_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Nga iini ka'a ta'aasie ike mauriha'aku mwaanieu. Ineu, nou toli'aasie mola maraaku. Nou to'o aana nanamanga huni toli'aasie mola maraaku, na nou to'o aana nanamanga no'one huni tola aaliho'i lo'u aana. Na nga taa Aamaku e unue mei ola ne kei esuie ni otona.” ");
INSERT INTO apb_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Oto mei oopanga ko reu lo'u i matolada mo na'ohai mwane mo Jiu i tehula'ana mo wala ienini. ");
INSERT INTO apb_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Mo iini hunge aada ko unue uuri, “!Li'oa aaela nge aana! !A mwaena ko tohungei hero-hero oto! ?Aana e ue omu ko rongo hunie?” ");
INSERT INTO apb_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Ta'e ngaeta mo iini aada ko te'uri, “Iinoni li'oa aaela aana, e sa'a unue ike mo ola urini. ?Na uri li'oa aaela e sa'a tahanie ike maana mwala e ulu? !Ha'ike oto oo'oo!” ");
INSERT INTO apb_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Oto aana mo waro-waro wawai ni iihi'ure, e hule oto aana maholo hunie Houlaa Ni Ha'amaa'ilana Nume Maa'i Peine i Jerusalem. ");
INSERT INTO apb_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","A Jisas ingeie i laona lolata aana Nume Maa'i Peine, na ko liu aana Leu Ni Haa-haanaku a Solomon Inemauri. ");
INSERT INTO apb_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Oto ngaeta mo na'ohai mwane mo Jiu kire lae mai loko ahuie a Jisas, kire ko si dodolosi aana uuri, “?Melu kei maa'oohi tewa uri taa, i na'ona o kei unu haada'i aana oodoi'emeelu uri i'oe a tei? Mala uri i'oe a Kraes to'ohuu, o ke unue oto oodoi'emeelu.” ");
INSERT INTO apb_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Oto a Jisas ko aalamire uuri, “Nou unue ka'u oto huni'omu, ta'e omu ka'a sare hiiwalaimoli ike aaku. Mo hu'i-hu'ite nge no ko esui'i aana satana Aamaku, kire haata'inie taane oto uri ineu a tei. ");
INSERT INTO apb_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Ta'e omu sa'a hiiwalaimoli ike aaku aena aana i'omu nga mo sipu ineu ha'ike. ");
INSERT INTO apb_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Mo sipu ineu kire rongo saie walaku, na kire ko lulu i sulieu. Nou sai diana aada, ");
INSERT INTO apb_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","na no ko niie maurihe huu hunire, oto kire sa'a ai'aa oto oo'oo. Nga iini e ka'a sai leu'i ike no'one mwaanie nimeku. ");
INSERT INTO apb_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Aamaku e nii'i hunieu, na ingeie e paine liutaa aana lo'u ta'ena nga iini. Oto nga iini e sa'a roro'a ni leu'i ike mwaanie nimana a Mama'a. ");
INSERT INTO apb_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","I'emere'i a Mama'a ta'a-ta'a iinoni mola.” ");
INSERT INTO apb_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Oto mo na'ohai mwane ngeena kire ko si so'o hau lo'u huni uu'i maesie a Jisas. ");
INSERT INTO apb_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Oto a Jisas ko te'uri hunire, “Mo hu'i-hu'ite diana oto hunge nou haata'ini'i eemiu uure mwaanie a Mama'a. ?Oto iini uri taa aani nge omu ko sare horo'ieu haahie?” ");
INSERT INTO apb_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Oto mo mwaena kire aalamie uuri, “Melu ka'a sare uu'i maesi'o ike haahie mo ola ngeena, ta'e haahie o ko ere mwakata'inie a God. !I'oe iinoni mola mala i'emeelu, ta'e o ko si sare dau oto mala uri i'oe a God!” ");
INSERT INTO apb_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","A Jisas e aalamire oto ko te'uri, “Uusulana e lae i laona mo Uusu-uusu Maa'i i'omu uri a God e unue hunie ngaeta mo na'ohai mwane oto i na'o uuri, I'omu mo god. ");
INSERT INTO apb_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Kolu meni saie ka'u uri walu ola mo Uusu-uusu Maa'i e ere i suli'i, mo ola to'ohuu. Na mo iinoni nge walana a God e hule aada wau i na'o, a God e haara'inire uri ikire mo god. ");
INSERT INTO apb_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","?Oto e ue omu ko si unue uri no ko ere mwakata'inie a God aana nou unue uuri, ‘Ineu a Kalena God.’? Ineu ka'u oto iini a God e lio hilisieu na e uusunge'inieu mei. ");
INSERT INTO apb_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Mala uri nou ka'a asuie mo esunge Aamaku, nge omu ke su'uri hiiwalaimoli eeku. ");
INSERT INTO apb_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Ta'e mala uri no ko esuie taane mo esunge Aamaku, nge e malisine uri omu ke hiiwalaimoli aana mo ola no ko esui'i, ma'alana omu ka'a hiiwalaimoli ike aana walaku. I leune nge omu kei sai diana aana uri a Mama'a taane i lalo aaku, na ineu i lalo aana a Mama'a.” ");
INSERT INTO apb_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Oto kire ko eri'apasie lo'u kire ke tapolie, ta'e e liu mola i matolada, e si lae mwaanire. ");
INSERT INTO apb_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Oto a Jisas e si aatoholo aaliho'i lo'u aana wai i Jodan hunie leu nge a Jon e loto maa'i ke'u aana, na e si o'o'o wau i leune. ");
INSERT INTO apb_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Mwala oto hunge kire lae mai saana, na kire ko unue uuri, “A Jon e ka'a asuie ike nga mo hu'i-hu'ite ta'e ahutana mo ola e unu'i i sulie a mwane ie, kire to'ohuu oto.” ");
INSERT INTO apb_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Na mwala hunge i leune kire si hiiwalaimoli aana a Jisas. ");
INSERT INTO apb_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","2","Oto nga mwane satana a Lasaros e o'o'o pe'ie e ro keni eesine, a Meri na a Maata, aana ngaeta huilume satana i Betani aana po'o ni henue i Jiudia kara'inie huilume paine i Jerusalem. A Meri ienini, ingeie nge keni e huie ae'aena a Jisas aana rumu e tohungei wesu diana, na e hulo a'ate aana ae'aena aana iihune pwaune. Oto a Lasaros ngeena ko mweri, ");
INSERT INTO apb_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","na e ro mwaasine keni kirerue hai uusunge'i hunie a Jisas uuri, “Poro paine, iini o manata diana hunie ko mweri.” ");
INSERT INTO apb_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Maholo a Jisas e rongo urine, e si te'uri, “Mwaringe ngeena ka'a ola ike hunie a Lasaros ke maesie, ta'e ko reu urine huni haata'inie manikuluha'ana God na huni ha'amanikulu'aa a Kalena.” ");
INSERT INTO apb_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","A Jisas e manata diana hunie a Maata na keni eesine a Meri, na mwane aasiderue a Lasaros, ");
INSERT INTO apb_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","oto aena urine, maholo e rongoa uri a Lasaros ko mweri, e si he'i ii'o lo'u e ro hai dinge wau i leune. ");
INSERT INTO apb_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Oto puriha'ana, ko si unue hunie mo pwaarongoisuli uuri, “Kolu ke aaliho'i lo'u hunie po'o ni henue i Jiudia.” ");
INSERT INTO apb_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Oto mo pwaarongoisuli ko aalamie a Jisas uuri, “Ha'a-uusuli, mo na'ohai mwane mo Jiu oto wau na hule aana kire ko eri'apasie uri kire ke uu'i maesi'o aani heu mola aana mo dinge e si mango haona. ?Oto uri o ko sare aaliho'i lo'u ta'au i saada?” ");
INSERT INTO apb_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Oto a Jisas ko si te'uri hunire, “Mwaanie omu me'u-me'u, aana maholo ha'ike ue hunie sato ke suu ni ngeena. A Mama'a e holosie maholo ineu huni esu nana, mala e holosie no'one uri ke dai-dengi hunie aawalai maholoi sato mwana rue suli dinge. Oto kira tei ko walo liu maholo e dai-dengi ue, kire sa'a tataro ike. ");
INSERT INTO apb_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Ta'e a tei ko walo liu aana rodo, e sai tataro mola aena aana nga mei ola hunie ke raa talana ha'ike.” ");
INSERT INTO apb_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","A Jisas e ere mango urine, e si te'uri lo'u hunire, “Malahukaelu a Lasaros ko ma'ahu eelisuu oto, na no ko lae oto huni ha'alioa.” ");
INSERT INTO apb_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Oto mo pwaarongoisuli ko aalamie uuri, “Mala uri ko ma'ahu oto, Poro paine, nge e haata'inie uri ko aehota awaa oto.” ");
INSERT INTO apb_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Lo'onga'inge a Jisas aana e ere urine, uri a Lasaros e mae oto, ta'e ikire mo pwaarongoisuli kire lo'onga'inie uri ko ere i sulie ma'ahunge mola to'ohuu. ");
INSERT INTO apb_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Oto a Jisas ko si unu tahanga'inie oodoire uuri, “A Lasaros e mae oto. ");
INSERT INTO apb_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Ta'e no ko ilenimwa'e mola uri nou ka'a ii'o ike i saana, aena aana nga taa ko reu ienini kei pe'i'omu hunie omu ke hiiwalaimoli eeku. Oto kolu ke lae oto i saana.” ");
INSERT INTO apb_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Oto a Tomas, nge ingeie ngaeta iini aana e ro iu, e si te'uri hunie mo pwaarongoisuli oana, “Kolu ke lae oto no'one pe'ie a Ha'a-uusuli hunie kolu ke mae tararuru oto pe'ie.” ");
INSERT INTO apb_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Maholo a Jisas e hule ta'au i Betani e si rongoa uri kire haitoli aana a Lasaros e hai hei dinge e mango oto. ");
INSERT INTO apb_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","I Betani e ka'a ha'ataulie ike i Jerusalem, ola mala e oolu kilomita mola, ");
INSERT INTO apb_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","na mwala hunge aana mo na'ohai uluhe ni iinoni ikire mo Jiu, kire lae no'one mai leune i saana Meri na a Maata, huni ii'o ha'asusurerue i purine aasiderue e mae. ");
INSERT INTO apb_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Maholo a Maata e rongoa uri a Jisas ko lae mai, e si iisitaa honosie, ta'e a Meri e oore mola hai nume. ");
INSERT INTO apb_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Oto a Maata ko te'uri hunie a Jisas, “Poro paine, mala uri o ke ii'o i leu, ha'alaa aasiku e ka'a mae ike. ");
INSERT INTO apb_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Ta'e nou saie taane uri ma'alana e urine, na nga taa o kei sukaa aana a God, kei niie mola huni'o.” ");
INSERT INTO apb_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Oto a Jisas e unue hunie a Maata uuri, “Aasimu kei ta'ela'i na kei meuri oto lo'u.” ");
INSERT INTO apb_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","A Maata e aalamie a Jisas oto ko te'uri, “Nou saie taane uri kei ta'ela'i na kei meuri lo'u aana dinge ooreta.” ");
INSERT INTO apb_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Oto a Jisas e si te'uri hunie, “Ineu oto iini e sai ta'ela'inie mo iini kire mae oto, na ineu oto aahu'ine maurihe. Iini ko hiiwalaimoli eeku, ma'alana e mae oto, ta'e kei he'i ta'ela'i lo'u. ");
INSERT INTO apb_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Na ta'ena nga iini e mauri ue na e hiiwalaimoli eeku, e sa'a he'i mae lo'u. ?Uri o hiiwalaimoli taane urine?” ");
INSERT INTO apb_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Oto a Maata e aalamie ko te'uri hunie, “Iau, Poro paine, nou hiiwalaimoli aana uri i'oe oto a Kraes, Kalena God nge a God e uusunge'inie mai huni ha'a-uurie walumalau.” ");
INSERT INTO apb_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Na maholo a Maata e ere mango urine, e si eeliho'i ko lai ha'arongoa a Meri keni eesine mola mwa-mwanoto uuri, “A Ha'a-uusuli e hule oto na ko dodolosi ohi'o.” ");
INSERT INTO apb_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Maholo a Meri e rongo urine, oto e tolana ta'ela'i na ko lae oto i saana. ");
INSERT INTO apb_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","A Jisas e ka'a hule ike ue mai laona huilume, ta'e ingeie ue po'oi sinaha aana leu a Maata e lai oodoie aana. ");
INSERT INTO apb_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Maholona na mo uluhe ni Jiu ngeena, nge kire ii'o pe'ie a Meri huni ha'asusue, ikire ue hai nume. Oto maholo kire leesie mola a Meri e ta'ela'i na ko iisitaa oto lau-leu, kire si meni lulu i sulie aana kire unue ko lai ngara i saana kilipwe'u. ");
INSERT INTO apb_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Ta'e a Meri e lae mola i saana leu nge a Jisas aana. Maholo e leesie a Jisas oto e si pouruuru i na'ona, na ko te'uri hunie, “Poro paine, mala uri o ke ii'o i leu ha'alaa aasiku e ka'a mae ike.” ");
INSERT INTO apb_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","A Jisas e leesie a Meri ko ngara na mwala pe'ie no'one urine, nge saena e si makaka oto aana saehuunge. ");
INSERT INTO apb_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Oto ko si dolosi aada uuri, “?Omu heitolinge'inie i tei?” Na kire aalamie uuri, “Lae mai na o ke leesie, Poro paine.” ");
INSERT INTO apb_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Oto a Jisas ko ngara ni saehuunge, ");
INSERT INTO apb_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","na maholo kire leesie urine mo Jiu kire ko te'uri, “!Leesie ka'u! A Jisas e tohungei manata diana hunie a mwane ngeena.” ");
INSERT INTO apb_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Ta'e ngaeta mo iini aada ko te'uri, “A mwane ie ka'u e tahanie maana mwane e ulu. ?Oto e ue ka'u e ka'a uure honosie a Lasaros mwaanie e mae?” ");
INSERT INTO apb_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Oto a Jisas e hule aana kilipwe'u, na saena e si makaka oto lo'u. Kilipwe'u ngeena nga hahale, na hau oto paine kire honoa maa aana. ");
INSERT INTO apb_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Oto a Jisas ko te'uri, “Omu ke ta'aasie ka'u hau ngeena.” A Maata, keni eesine mwane e mae ngeena ko aalamie uuri, “Poro paine, e hai hei dinge oto ko mango aana ienini, na ko kesu oto ni ngeena.” ");
INSERT INTO apb_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Oto a Jisas ko te'uri hunie a Maata, “O ke hiiwalaimoli mola, aana nou unue ka'u oto huni'o uri o ko hiiwalaimoli ha'alaa, o ke si leesie manikuluha'ana a God.” ");
INSERT INTO apb_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Kire ta'aasie hau ngeena mwaanie maana kilipwe'u, oto a Jisas e lio i lengi ko si te'uri, “Mama'a, no ko paalahe'o haahie o ko rorongo hunie aarenga'inge ineu. ");
INSERT INTO apb_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Nou saie taane uri o ko rorongo hunieu taraure'i, ta'e i tehula'ana mwala ienini nge no ko unue walu ola ie uri hunie kire ke hiiwalaimoli aana uri i'oe oto o uusunge'inieu mei.” ");
INSERT INTO apb_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Purine e aarenga'i mango urine, e si soi peine uuri, “!Lasaros, o ke iisitaa mai!” ");
INSERT INTO apb_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Oto a Lasaros, iini e mae ka'u, e si iisitaa mai, na mo sala kire uloa aani ikire ue haahie mo ki'ine na mo ae'aena, na leu haahie maana. Oto a Jisas ko si unue hunire uuri, “Omu ke luhesie mo sala mwaanie sapena, na omu ke toli'aasie ke lae-lae.” ");
INSERT INTO apb_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Oto mo iini hunge aana mo Jiu e lae mai saana Meri kire leesie walu ola nge a Jisas e asui'i ngeena, kire si hiiwalaimoli aana. ");
INSERT INTO apb_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Ta'e ngaeta mo iini aada kire ooli i saana mo Parise na kire ha'arongora aana nga taa nge a Jisas e asuie. ");
INSERT INTO apb_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Oto mo na'ohai pris pe'ie mo Parise kire lokoa mwala lei-lei, kire ko si dodolosi uuri, “?Kolu kei ue eena? A mwane ie ko haata'inie mo tolimaa nanama aana ko esuie mo hu'i-hu'ite hunge oto mala iini ie. ");
INSERT INTO apb_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Mala uri kolu kei toli'aasie ke lae mola pe'i esuie walu ola urini, ahutana mwala kei meni hiiwalaimoli oto aana, na kire kei sare asuie ke ne'i inemauri ikie oolisie inemauri ni Rom. Oto mo Rom kei ooho honosikie, na kire kei lae oto mai oho aasie Nume Maa'i Peine ikie, na kire kei horo suuhe'inie oto ahutaka mo Jiu eena.” ");
INSERT INTO apb_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Aana halisi ngeena, Na'ohana Mo Na'ohai Pris satana a Kaiapas. Oto a Kaiapas e si te'uri hunire, “!Omu tohungei pu'osasu oto hiito'o! ");
INSERT INTO apb_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Omu ka'a lio saie ike uri e lae otoi diana hunie nga ta'a-ta'a iini ke mae mola honotana mwala mwaanie uri ahutana mwala ko meni mae.” ");
INSERT INTO apb_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","A Kaiapas e ka'a lo'onga'inie leune mola tohune. Ta'e aana ingeie mone Na'ohana Mo Na'ohai Pris aana halisine, oto a God e da uri ke hola'i unu tahanga'inie uri a Jisas kei mae honotana mwala ni Jiu. ");
INSERT INTO apb_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Na e ka'a ike mola honotana mo Jiu hahaiteli, ta'e huni lokoa ahutana mo iinoni a God nge kire ii'o tatanga i laona walumalau hunie kire ke ne'ie ta'a-ta'a iinoni. ");
INSERT INTO apb_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Oto uure aana maholo nge a Kaiapas e ere urine, kire si aehota oala'i huni horo maesie a Jisas. ");
INSERT INTO apb_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Aena urine, a Jisas e ka'a lae-lae haada'i ike lo'u i matolana mo henue nge mo mwane paine mo Jiu kire sai leesie. Oto e uure mola mwaanie leune na e lae mola kara'inie hanuesala aana huilume i Ifrim. Na e ii'o oto i leune pe'ie mo pwaarongoisuli ingeie. ");
INSERT INTO apb_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Oto maholo ko kara'inie oto Houlaa Ni Liumwaanie ikire mo Jiu, mo iini hunge aana mo henue hailiu kire hanetaa ta'au i Jerusalem i na'ona Houlaa Ni Liumwaanie hunie ha'arere'alada i sulie mo Ha'atolanga a Mosis. ");
INSERT INTO apb_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Oto mwala ngeena kire ko si lio-lio hunie a Jisas. Na maholo kire loko oto ta'au i laona lolata aana Nume Maa'i Peine, kire ko si dodolosi heiliu aada uuri, “?Ohe kei lae taane mai aana houlaa? ?Wa omu ko lo'o-lo'onga'i uri taa?” ");
INSERT INTO apb_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Ta'e mo na'ohai pris na mo Parise kire niie oto ha'atolanga uri mala nga iini ko saie leu a Jisas e ii'o aana, nge ke ha'arongora hunie uri kire ke tapolie. ");
INSERT INTO apb_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","E oono hai dinge ue i na'ona Houlaa Ni Liumwaanie, a Jisas e lae oto hunie i Betani, huilume a Lasaros mwane nge a Jisas e ta'ea ka'u mwaanie maenga. ");
INSERT INTO apb_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Oto i leune kire ha'alie hunie kele ngauhe huni ha'ama'u aana. A Maata nge ko rareta'inire, na a Lasaros no'one ngaeta iini aana mwala e ngau pe'ie a Jisas aana maholona. ");
INSERT INTO apb_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Oto a Meri e si hele aana ho ate'a aani rumu nge e tohungei wesu mangoni. Ho ate'a ngeena e hele aana e ro kao-kao aani rumu, na holitana e tohungei peine. Oto e toolea na ko huie e ro ae'aena a Jisas aana, na ko hulo a'ate aana e ro ae'aena lo'u aana iihune pwaune. Oto nume ngeena e si honu aana wasuha'ana ho rumu ngeena, na e lae otoi wesu mangoni hiito'o. ");
INSERT INTO apb_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Oto a Jiudas Iskariot, ngaeta iini aana mo pwaarongoisuli a Jisas na iini oto kei pweloa, ko si upwesie na ko te'uri, ");
INSERT INTO apb_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“?Aana e ue ka'u ha'aholinge'inilana ho rumu ie e ka'a lae mola, na mei to'oha niilana ke lae mola hunie kira maitale? !A keine ko si waeta'inie mola waaitana nga mwane au'esu hunie halisi leku!” ");
INSERT INTO apb_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","A Jiudas e talei ere ka'u urine, ta'e hule aana ingeie e ka'a ne'i-ne'isae ike aana mo iinoni meitale. E ere urine mola i sulie ingeie iinoni peli-peli. Mwa'ii to'oha mo pwaarongoisuli mone aana, oto ko talei deu mala saena mola aana. ");
INSERT INTO apb_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Oto a Jisas ko si te'uri, “!Ei! !Su'uri kotahie ka'u! E loo-looha'inie ka'u ho rumu ngeena hunie ke dau aakau eeku loosie kire kei heitolinge'inieu ni ngeena. ");
INSERT INTO apb_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Kira maitale kei o'o'o taane ue pe'i'omu tarau, ta'e ineu, nou sa'a ii'o ike lo'u pe'i'omu.” ");
INSERT INTO apb_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Mwala oto hunge aana mo Jiu kire rongoa uri a Jisas ingeie i Betani, oto kire lae wau i leune. Kire ka'a lae ike mola wau i tehula'ana a Jisas maraana, ta'e huni leesie no'one a Lasaros, iini nge a Jisas e ta'ea ka'u mwaanie maenga. ");
INSERT INTO apb_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Oto mo na'ohai pris kire si oala'i huni horo maesie a Lasaros no'one pe'ie a Jisas, ");
INSERT INTO apb_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","aena aana mwala oto hunge ko aehota huni eeli'u oto mwaanire na kire ko hiiwalaimoli mola aana a Jisas i tehula'ana a Lasaros. ");
INSERT INTO apb_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Oto hai dinge lo'u mola i sulie, mwala oto hunge nge kire hule aana Houlaa Ni Liumwaanie ngeena, kire rongoa uri a Jisas ko lae mai hunie i Jerusalem. ");
INSERT INTO apb_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Kire si toolea mo sasarai ei na kire ko lae mwaanie huilume ngeena huni lae ta'au honosie pe'i soinge uuri, “!Lahea God! A God ke ha'adiana'aa iini ko lae mai nunuha'ana satana. !A God ke ha'adiana'aa inemauri ikie mo Israel!” ");
INSERT INTO apb_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Oto a Jisas e toolea kalei dongki, e si ta'e i lengine oto mala uusulana e lae uuri, ");
INSERT INTO apb_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","I'omu mo Jerusalem, mwaanie omu me'u-me'u. Leesie ka'u, inemauri i'omu oto e ta'e i lengine kalei dongki, ko lae mai ie. ");
INSERT INTO apb_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Hola'ina'o, mo pwaarongoisuli a Jisas kire ka'a sai diana aana ike ne'isaenga aana walu ola ngeena. Ta'e maholo ha'amanikulu'alana a Jisas e lae aana a God e ta'ela'inie mwaanie maenga, nge kire ko si aamasito'o aana uri uusulana mo olana e lae taane i sulie, na uri kire asui'i taane oto hunie. ");
INSERT INTO apb_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Mwala oto hunge nge kire ii'o pe'ie a Jisas maholo e soie a Lasaros mwaanie kilipwe'u na e ta'ea mwaanie maenga, kire ko lae pe'i taroha'inie nga taa a Jisas e asuie ngeena. ");
INSERT INTO apb_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Aena aana mei olana no'one nge mwala hunge kire lae ta'au honosie, aana kire rongoa e asuie mei hu'i-hu'ite pe'ie tolimaa ienini. ");
INSERT INTO apb_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Oto mo Parise ko si ere hunire maraada uuri, “!Lio ka'u! Walu ola kolu ko eu'esui'i honosie a mwane ngeena e ka'a oa oto hunikolu. !Ahutana walumalau ko lulu i sulie oto!” ");
INSERT INTO apb_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Ngaeta mo iinoni ni Krik no'one kire lae ta'au i Jerusalem pe'ie mo Jiu huni paloa God aana maholo hunie houlaa ngeena. ");
INSERT INTO apb_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Oto kire lae i saana a Pilip, mwane aana huilume i Betsaeda hao i laona po'o ni henue i Kalili, na kire ko te'uri hunie, “Poro paine, melu ko sare leesie a Jisas.” ");
INSERT INTO apb_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","A Pilip e ha'arongoa a Andru, oto kirerue ko si meni lai ha'arongoa a Jisas. ");
INSERT INTO apb_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Oto a Jisas e aalamirerue ko te'uri, “Maholoi sato e hule oto, uri hunie ha'amanikulu'alana a Kale Ni Iinoni kei lae. ");
INSERT INTO apb_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","No ko unue oto to'ohuu huni'omu uri mala uri o ko hele-helesie mola ho litei ola na o ka'a hasie, nge kei o'o'o maraana oto mola urine aana e sa'a hungu ike lo'u. Ta'e mala uri o ko hesie i laona mwakano, nge ke si hungu aani hue-huei ola oto lo'u hiito'o. ");
INSERT INTO apb_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Na mo iinoni kire urihana mola mo litei ola ngeena, aana iinoni nge ko mana-manata diana mola hunie mauringe ingeie maraana, nge kei deu tekela'inie mola mauriha'ana. Ta'e iini nge e ka'a ne'isae paine aana mauringe ingeie mai leu i laona walumalau, nge kei deu oodoie maurihe huu. ");
INSERT INTO apb_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Ta'ena nga iini ko sare asu nekue, nge ke lulu i sulieu oto, uri hunie iini eu'esu ineu ke ii'o oto pe'ieu aana leu no ko ii'o aana. Na nga iini ko esu nekue, nge a Aamaku ke si ha'apaina'aa i maana mwala. ");
INSERT INTO apb_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“Saeku ko lae otoi hi'e ni ienini, hule aana nou ka'a saie oto nga taa ne kei unue. ?Uri ne ke unue hunie a Mama'a ke su'uri toli'aasie mei ola e hi'e ie ke rau eeku? !Ha'ike! Aena aana mei ola nou lae mone oto mai hunie ni ngeena, uri hunie ne ke liu i laona sapesalunge ie. ");
INSERT INTO apb_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","!Mama'a, o ke ha'amanikulu'aa satamu!” Oto mei wala e loho mai uure i Lengi uuri, “Nou hahu'ei ha'amanikulu'aa oto, na ne kei he'i ha'amanikulu'aa lo'u.” ");
INSERT INTO apb_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Oto mwala hunge e uure-uure wau i leune kire rongoa mei walana, kire ko si unue mola uri lou-lou ko hoka, ta'e ngaeta mo iini lo'u ko unue uuri, “!Nga ensel e ere pe'ie ni ngeena!” ");
INSERT INTO apb_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Oto a Jisas e te'uri, “Mei wala ie e ka'a loho ike mai huni pe'ieu, ta'e ola huni pe'i'omu ni ngeena. ");
INSERT INTO apb_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Maholo e hule oto ie hunie a God kei leie walumalau, na ke oohe aasie a Satan, iini ko aalaha haahie walumalau. ");
INSERT INTO apb_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Na ineu, maholo kire kei ta'eau i lengi mwaanie mwakano pe'ie hai ei, ne ke si toolea mai ta'ena nga iinoni i seeku.” ");
INSERT INTO apb_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","A Jisas e ere urine, uri huni haata'inie kei mae i lengine po'u-po'u. ");
INSERT INTO apb_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Oto mwala hunge ngeena ko si aalamie uuri, “Emi rongoa oto aana mo Uusu-uusu Maa'i uri a Kraes kei ii'o huu. ?Oto e ue nge o ko si unue uri kire kei ta'ea a Kale Ni Iinoni pe'ie hai ei huni horo maesie? ?Ha'alaa a Kale Ni Iinoni ngeena, ingeie a tei eena?” ");
INSERT INTO apb_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Oto a Jisas ko si te'uri hunire, “Raa-raa kei ii'o ha'awali mola ue pe'i'omu huni ha'asinelie saemiu. Oto omu ke noruto'o mola aana, na omu ke lae-lae maholo raa-raa e ii'o ue i matolamiu, mwaanie e rodo honosi'omu i sulie tala. Aana iini ko lae-lae i laona rodohono, e ka'a saie ike uri ko lae i tei. ");
INSERT INTO apb_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Omu ke hiiwalaimoli aana raa-raa maholo ingeie ue pe'i'omu, hunie uri omu ke ne'i kale ni raa-raa oto.” A Jisas e unue walu ola ienini mango, ko si lae mumuni mwaanire. ");
INSERT INTO apb_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","A Jisas e talei esuie ka'u mo hu'i-hu'ite hunge huni haata'inie mo tolimaa i na'ona mwala, ta'e kire ka'a sare hiiwalaimoli ike mola aana. ");
INSERT INTO apb_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Oto e oa oto mala a Propet Aesaea e unue uuri, Poro paine, nga ta'a-ta'a iini e ka'a hiiwalaimoli ike aana tataroha melu unue hunire. Na hule aana mo iini kire leesie nanamanga i'oe, ta'e toota'i iini mola kire lio sai'o. ");
INSERT INTO apb_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Na aana ngaeta leu lo'u a Aesaea e ere luhesie aana e ue ka'u mwala ka'a sai hiiwalaimoli ike, aana a God e unue no'one hunie a Aesaea uuri, ");
INSERT INTO apb_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Nou ha'a-ulue maada, na nou honoa manatada mwaanie uri kire lio sai ola aana maada, na mwaanie uri kire lo'onga'i saie nga mei ola aana manatada. Oto kire kei eeli'u mei seeku hunie uri ne ke ha'a-uurire. ");
INSERT INTO apb_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","A Aesaea e unue walu olana, aana e leesie manikuluha'ana a Jisas na e ere oto i sulie. ");
INSERT INTO apb_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Ma'alana ahutana mwala kire ka'a hiiwalaimoli ike, ta'e mo iini hunge aana mo na'ohai mwane mo Jiu kire hiiwalaimoli taane aana a Jisas. Ta'e kire ka'a sare unu tahanga'inie ike uri kire hiiwalaimoli, mwaanie uri mo Parise kire uure honosire mwaanie mo nume ni palo-palo mo Jiu. ");
INSERT INTO apb_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Kire ma'u urine aana kire saeto'o aana mo iinoni ke lahera, liutaa aana kire saeto'o aana uri a God ke lahera. ");
INSERT INTO apb_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Oto a Jisas e si ere paine uuri, “A tei nge ko hiiwalaimoli eeku, e ka'a hiiwalaimoli ike mola aaku, ta'e no'one aana iini e uusunge'inieu mei. ");
INSERT INTO apb_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","A tei ko leesieu, ko leesie no'one iini e uusunge'inieu mei. ");
INSERT INTO apb_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Ineu nou lae mai mala raa-raa i laona walumalau, hunie uri ta'ena nga iini ko hiiwalaimoli eeku, ke su'uri ii'o i laona rodohono. ");
INSERT INTO apb_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","“Na ta'ena nga iini ko rongoa walaku, ta'e e ka'a lulu i suli'i ike, ineu nou sa'a leie ike aana maholo ie. Aana nou ka'a lae ike mai ie huni leie mo iinoni aana walumalau, ta'e huni ha'a-uurie walumalau. ");
INSERT INTO apb_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Nga mei ola huni leie mo iinoni e ii'o taane. Mo iini kire ka'a sare hiiwalaimoli eeku, na kire ka'a sare rongo hunie walaku, nge mo wala nge no ko unu-unu'i ngeena, kire ke si lei mae aana mwala urine aana dinge ooreta. ");
INSERT INTO apb_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Walaku mei ola to'ohuu ni ngeena, aena aana walu ola nou ha'a-ha'a-uusuli eeni, ka'a mo ola ike mola ineu maraaku. A Mama'a, iini e uusunge'inieu mei, nge ni e unue hunieu nga taa ni unue, na huni ha'a-uusuli aana. ");
INSERT INTO apb_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Na nou saie uri nga taa e unue e sai toolea mo iinoni takoie maurihe huu. Oto nga taa no ko unu-unue, nga taa nge a Mama'a e unue hunieu uri ne ke unu haada'i aana ni otona.” ");
INSERT INTO apb_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Oto mola i na'ona Houlaa Ni Liumwaanie, a Jisas e manata'inie uri e hule oto aana maholo hunie ke ho'ala'i mwaanie walumalau ie, na ke ooli i saana Aamana. A Jisas e manata diana oto tarau hunie mo iini ingeie nge kire ko lulu i sulie mai welumalau, na e hahu'ei manata diana hunire lai hule oto aana ooretalana. ");
INSERT INTO apb_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Oto e hule aana maholo a Jisas na mo pwaarongoisuli ingeie kire ko ngeu i seulehi, ta'e a Pwelu Eero-eero e pwani ne'ie oto mei ne'isaenga ni pweloa a Jisas i saena a Jiudas Iskariot, kalena Saemon. ");
INSERT INTO apb_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","A Jisas e manata'inie oto uri Aamana e toli'aasie ahutana walu ola mango oto i laona nimana. Na e saie no'one uri e uure mai mwaanie a God, na uri ko eeliho'i lo'u takoie a God. ");
INSERT INTO apb_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Oto e ta'ela'i mwaanie leu nge kire ko ngeu aana, e si ta'aasie to'oni tetewa ingeie, na e hele aana maamango, oto ko ho'osie i denumana. ");
INSERT INTO apb_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Oto e huie mei wei i laona nime, ko si aehota hodalie ae'aena mo pwaarongoisuli ingeie na ko maamango a'ate aana ae'aeda aana maamango nge e ho'osie i denumana. ");
INSERT INTO apb_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Na maholo e lae mai hule aana a Saemon Pita, a Pita ko si te'uri hunie, “!Ha'ike eena, Poro paine! ?Uri i'oe, mwane paine o ko sare hodalie ae'aeku?” ");
INSERT INTO apb_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","A Jisas e aalamie, oto ko te'uri, “Oto molana o ka'a lio saie ike nga taa no ko esuie, ta'e aana nga maholo o ke si lio saie taane.” ");
INSERT INTO apb_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Oto a Pita ko te'uri hunie, “!O sa'a roro'a hodalie ike ae'aeku oto oo'oo!” A Jisas e aalamie a Pita, oto ko te'uri, “Mala uri nou ka'a hodalie oto e ro ae'aemu, i'oe nga pwaarongoisuli ineu ha'ike lo'u.” ");
INSERT INTO apb_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Oto a Saemon Pita ko si te'uri hunie, “Ko urine, Poro paine, nge o ke su'uri hodalie mola e ro ae'aeku, ta'e o ke hodalie no'one e ro ki'iku na pwauku.” ");
INSERT INTO apb_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","A Jisas e aalamie, oto ko te'uri, “Iini e loto ahu oto, sapena e rere'a oto. Maholo ko lae hailiu, nge e ro ae'aena mola ke si hodali'i lo'u na e rere'a ta'ingelu oto lo'u. I'omu, saemiu e rere'a mango oto, ta'e ahutemiu ha'ike.” ");
INSERT INTO apb_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","A Jisas e saie oto a tei kei pweloa, na aena urine e si unue uuri, “Ahutemiu omu ka'a mani rere'a ike.” ");
INSERT INTO apb_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Oto maholo e hodalie ae'aeda mango, e si ho'osie lo'u to'oni tetewa ingeie, na ko lai ii'o lo'u i aano aana leu kire ko ngeu aana. I leune a Jisas ko si te'uri, “?Uri omu saie taane mei ola nge nou si esuie huni'omu ie? ");
INSERT INTO apb_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Omu ko sasaieu aana ‘Ha'a-uusuli’ na ‘Aalaha,’ na e to'ohuu oto, aena aana ineu nou urine oto. ");
INSERT INTO apb_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Oto ineu, Aalaha i'omu na Ha'a-uusuli i'omu, nou si ha'amwai-mwei'aau huni hodalie oto ae'aemiu. Oto i'omu, omu ke hoda-hodalie ae'aemiu heiliu no'one urine. ");
INSERT INTO apb_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Aana nga taa nou esuie ienini e ne'ie oto nga ha'amalanga huni'omu, hunie omu ke haimaanie tolahaku, na omu ke ha'amwai-mwei'a'omu mola hunie omu ke pe'i-pe'i'omu heiliu. ");
INSERT INTO apb_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","No ko unue to'ohuu oto huni'omu uri nga koni-konihe e ka'a paine ike lo'u liutaa aana Aalaha ingeie, wa hurula'aa ke liutaa aana iini e uusunge'inie. ");
INSERT INTO apb_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Omu saie oto walu ola ienini, oto omu ke asui'i. Aana a God kei ha'adiana'a'omu haahi'i.” ");
INSERT INTO apb_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Oto a Jisas e he'i unue lo'u uuri, “Ta'e nou ka'a ere ike i sulie ahutemiu eena, aana nou saie mola mo iini nou lio hilisire. Ta'e Uusu-uusu Maa'i nge e unue uuri, Iini ko ngeu tararuru pe'ieu nge kei pweloau oto, ko kara'i oa oto ienini. ");
INSERT INTO apb_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Oto no ko hola'i unue oto nga taa kei reu oodoi'omu, hunie uri ko si reu na omu ke hiiwalaimoli aana uri ineu oto nou ii'o huu. ");
INSERT INTO apb_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","No ko unue oto huni'omu uri a tei ko tekuhie nga iini no ko uusunge'inie wau, nge ko tekuhieu no'one oto. Na a tei ko tekuhieu, ko tekuhie no'one iini e uusunge'inieu mei.” ");
INSERT INTO apb_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Oto i purine a Jisas e ere mango urine, saena ko si hi'e, na ko ere haada'i oto uuri, “No ko unue oto to'ohuu huni'omu uri nga iini hikemiu oto kei pweloau.” ");
INSERT INTO apb_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Oto mo pwaarongoisuli ko si to'omaaire hailiu aana kire ka'a saie ike iini a Jisas ko ere i sulie. ");
INSERT INTO apb_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Na ngaeta iini aana mo pwaarongoisuli, iini nge a Jisas e manata diana hiito'o hunie, e ii'o mola i sulie a Jisas. ");
INSERT INTO apb_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Oto a Saemon Pita e salohie aana ki'ine na ko unue uuri, “O ke dolosi ka'u aana. ?A tei ni ko ere-ere oalana?” ");
INSERT INTO apb_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Oto pwaarongoisuli ngeena e ada kara'inie a Jisas, ko si dolosi uuri, “?Poro paine, a tei mwane ni ngeena?” ");
INSERT INTO apb_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","A Jisas e aalamie ko si te'uri, “Iini nge ne kei toonga'inie mei bred i laona nime na ne kei niie hunie, a mwaena otona.” Oto e da mei bred, ko toonga'inie i laona nime, ko si niie hunie a Jiudas Iskariot, kalena a Saemon. ");
INSERT INTO apb_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Oto mola i purine a Jiudas e hele aana mei bred ngeena mango, a Pwelu Eero-eero e si sili i lalo aana. Oto a Jisas ko si te'uri hunie, “Nga taa o ko sare asuie, o ke asuie oto lau-leu.” ");
INSERT INTO apb_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Nga ta'a-ta'a iini hikana mwala ko ngeu ngeena na e ka'a saie lo'u uri aena nga mei taa nge a Jisas e ere urine hunie a Jiudas aana. ");
INSERT INTO apb_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Ngaeta mo iini aana mo pwaarongoisuli kire lo'onga'inie e ere urine aena aana a Jiudas mone ko lio i sulie mei to'oha ikire, oto ohe a Jisas e unue hunie uri ke lai holie nga mo ola kire saeto'o aani hunie houlaa, wa huni niie nga mo ola hunie kira maitale. ");
INSERT INTO apb_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","A Jiudas e hele aana mola mei bred nge a Jisas e niie hunie, oto e tolana iisitaa oto i sinaha. Na e rodo oto. ");
INSERT INTO apb_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Oto i purine a Jiudas e iisitaa, a Jisas ko si te'uri, “Oto molana a God kei haata'inie manikuluha'aku a Kale Ni Iinoni, na lio sailana manikuluha'ana a God kei lae oto no'one aana nga taa ineu a Kale Ni Iinoni ne kei esuie. ");
INSERT INTO apb_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Na aana ne kei haata'inie nanamanga na manikuluha'ana a God, nge a God ke si haata'inie manikuluha'aku a Kale no'one, na kei esuie oto molana. ");
INSERT INTO apb_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","“Maeni mwela ineu, nou sa'a ii'o tewa ike lo'u pe'i'omu. E sa'a tewa oto, na omu kei tola haitaleau, ta'e omu sa'a oodoieu ike. Aana no ko unue lo'u huni'omu nga taa nou unue ka'u hunie mo na'ohai mwane mo Jiu, uri kire sa'a roro'a ni lae ike aana leu no ko lae aana ie. ");
INSERT INTO apb_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","“Oto ie no ko niie ha'atolanga haalu huni'omu. Omu ke manata diana huni'omu heiliu. Mala oto ineu, nou manata diana ka'u huni'omu, nge i'omu no'one omu ke manata diana huni'omu urine. ");
INSERT INTO apb_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Mala uri omu kei manata diana huni'omu heiliu urine, nge ahutana mwala ke si saie uri i'omu mo pwaarongoisuli ineu to'ohuu.” ");
INSERT INTO apb_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Oto a Saemon Pita ko si te'uri hunie a Jisas, “?Poro paine, oto i'oe, o ko lae i tei?” A Jisas e aalamie, oto ko te'uri, “Leu no ko lae aana ie, o sa'a lae ike i sulieu aana oto molana, ta'e o ke si lae taane i sulieu aana nga maholo.” ");
INSERT INTO apb_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Oto a Pita ko dolosi aana uuri, “?Poro paine, e ue ka'u nou ka'a sai lae pe'i'o oto molana? !Nou mwa'e-mwa'e mola huni mae honotamu!” ");
INSERT INTO apb_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Oto a Jisas e aalamie, ko te'uri, “?Uri o mwa'e-mwa'e taane to'ohuu huni mae honotaku? No ko unue to'ohuu oto huni'o uri i na'ona kue kei ngara i rodo si'iri, o kei saronai taateinge'inieu ha'a-oolu uri o ka'a manata'inieu ike.” ");
INSERT INTO apb_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Oto a Jisas ko si he'i te'uri lo'u hunie mo pwaarongoisuli ingeie, “Omu ke su'uri totolahi'e. Omu ke hiiwalaimoli aana a God, na omu ke hiiwalaimoli no'one aaku. ");
INSERT INTO apb_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Mo leu ni ii'o aani kire hunge mola aana nume Aamaku. Mala uri nga mo ola urine ha'ike, ha'alaa nou ka'a unue ike leune huni'omu. Ta'e leune e to'ohuu oto, na ie no ko lae oto i deu aakau aana nga leu talamiu. ");
INSERT INTO apb_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Na i purine no ko lae i deu aakau aana nga leu talamiu, ne kei he'i ooli lo'u mei, hunie uri omu ke ii'o pe'ieu aana leu ne kei ii'o aana. ");
INSERT INTO apb_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","I'omu, omu saie mola tala takoie leu no ko lae aana.” ");
INSERT INTO apb_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Oto a Tomas ko te'uri hunie a Jisas, “Poro paine, melu ka'a manata'inie ike leu o ko lae aana. ?Ha'alaa melu ke si saie tala hunie uri taa eena?” ");
INSERT INTO apb_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","A Jisas e aalamie oto ko te'uri, “Ineu oto tala, na walaimolinge, na maurihe. Nga tala aaopa hunie nga iini ke lae lo'u i sulie takoie a Mama'a ha'ike, ta'e ko liu i seeku ha'alaa. ");
INSERT INTO apb_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Oto aana omu sai diana aaku, nge omu saie oto no'one Aamaku eena. Na omu sai diana aana taane oto, na omu leesie oto.” ");
INSERT INTO apb_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Oto a Pilip ko te'uri hunie a Jisas, “Poro paine, o ke haata'inie mola a Mama'a aameelu na e kohi oto.” ");
INSERT INTO apb_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Oto a Jisas e aalamie ko te'uri, “!Mwae! ?No ko ii'o tewa oto pe'i'omu, na uri o ka'a saieu ue, Pilip? A tei nge ko leesieu, e leesie a Mama'a otona. ?E ue o ko saeto'o aana ne ke haata'inie a Mama'a lo'u eemiu? ");
INSERT INTO apb_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","?Uri o ka'a hiiwalaimoli ike, Pilip, aana uri ineu i lalo aana a Mama'a na uri a Mama'a no'one i lalo aaku? Mo wala nou unu'i huni'omu ngeena, nou ka'a unu'i ike tohuku, ta'e a Mama'a ni e ii'o aaku nge ko esuie walu ola omu leesie nou esui'i ngeena. ");
INSERT INTO apb_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Omu ke hiiwalaimoli mola aana no ko unue uri ineu i lalo aana a Mama'a na a Mama'a ingeie i lalo aaku. Wa ma'alana omu ka'a hiiwalaimoli ike mola aena aana walaku, ta'e omu ke hiiwalaimoli aana walu ola nge omu leesie nou esui'i ngeena. ");
INSERT INTO apb_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","No ko unue oto to'ohuu huni'omu uri iini ko hiiwalaimoli eeku, e sai esuie no'one mola taungei esunge no ko esuie ie. Na hule aana e sai esuie mo esunge paine lo'u liutaa aana mo iinine, aena aana no ko lae oto i saana a Mama'a. ");
INSERT INTO apb_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Na mala uri omu ko sukaa nga mei ola i tehula'ana hiiwalaimolinge i'omu eeku, ne kei da mola huni'omu, hunie mwala ke si soi ha'amanikulu'aa a God i tehula'aku a Kale. ");
INSERT INTO apb_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Iau, mala omu kei sukaa nga mei ola aaku i tehula'ana omu noruto'o oto aaku, ne kei da oto urine huni'omu.” ");
INSERT INTO apb_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Oto a Jisas e he'i unue lo'u hunie mo pwaarongoisuli ingeie uuri, “Mala uri omu ko manata diana hunieu, omu ke tola i sulie mo ha'atolanga ineu. ");
INSERT INTO apb_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Na ne kei ha'atohu aana a Mama'a, oto ingeie ke si uusunge'inie mai ngaeta iini huni pe'i'omu na hunie ke ii'o susu oto pe'i'omu. ");
INSERT INTO apb_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Na ingeie Li'oa aani walaimolinge otona. Mo iinoni aana walumalau sa'a takuhie ike, aena aana kire sa'a lio saie ike wa kire ke manata'inie. Ta'e i'omu, omu manata'inie oto, aena aana e ii'o oto pe'i'omu na kei ii'o i lalo aamiu. ");
INSERT INTO apb_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","I purine ne kei lae mwaani'omu, omu sa'a ii'o ni rei'inge ike maraamiu aana ne kei eeliho'i taane lo'u mei seemiu. ");
INSERT INTO apb_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","E sa'a tewa na mwala aana walumalau ie kire sa'a leesieu lo'u, ta'e i'omu, omu kei leesieu taane lo'u. Oto aena aana ne kei meuri lo'u, i'omu no'one omu kei he'i meuri lo'u. ");
INSERT INTO apb_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Aana hai dinge ngeena, omu ke si saie uri ineu i lalo aana a Mama'a, na i'omu i lalo aaku, na ineu i lalo aamiu. ");
INSERT INTO apb_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","A tei nge ko rongo hunie mo ha'atolanga ineu na ko tola i suli'i, ingeie oto iini e manata diana hunieu. Na a tei ko manata diana hunieu, nge Aamaku kei manata diana hunie. Ineu no'one ne kei manata diana hunie, na ne ke si ha'asaie aana tolahaku.” ");
INSERT INTO apb_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Oto ngaeta Jiudas aaopa lo'u mwaanie a Jiudas Iskariot, ko si te'uri hunie a Jisas, “?Poro paine, aana e ue ka'u o unue uri o sa'a ha'asaie ike walumalau aana walu ola i suli'o? ?E ue o ko si ha'asai'emeelu mola maraameelu?” ");
INSERT INTO apb_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Oto a Jisas e aalamie ko te'uri, “Mala nga iini ko manata diana hunieu, nge ke tola i sulie walaku. Oto Aamaku ke si manata diana hunie, na i'emere'i Aamaku mere ke si lae mai saana huni ii'o susu oto pe'ie. ");
INSERT INTO apb_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Ta'e iini nge e ka'a manata diana oto hunieu, e ka'a tola oto i sulie walaku eena. Mo wala omu ko rorongo'i ngeena, e ka'a mo lo'onga'inge ike mola ineu maraaku, ta'e kire uure mai mwaanie a Mama'a iini nge e uusunge'inieu mei. ");
INSERT INTO apb_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“No ko unue oto to'ohuu huni'omu walu ola ienini maholo ineu ue mai pe'i'omu i leu. ");
INSERT INTO apb_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Na i'emere'i a Mama'a mere kei uusunge'inie mai nga iini huni pe'i'omu, nge a Li'oa Maa'i eena. Ingeie ke si ha'a-aamasito'o'omu aana walu ola nou unu'i oto huni'omu, na ke ha'asai'omu aana ahutana mo ola ngeena. ");
INSERT INTO apb_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","No ko ha'a-oorea hanuelamanga oto huni'omu, na hanuelamanga ineu no ko niie oto huni'omu ie. Nou ka'a niie ike mala mwala aana walumalau ko nii-nii, ta'e no ko nii to'ohuu. Oto omu ke su'uri totolahi'e wa omu ke ma'u-me'u. ");
INSERT INTO apb_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","“Omu rongoa oto aana nou unue huni'omu uri no ko lae oto, na ne kei he'i ooli lo'u mei seemiu. Mala uri omu ko manata diana hunieu to'ohuu, nge omu ke ile-ilenimwa'e mola uri no ko lae i saana Aamaku, aana ingeie e paine lo'u liutaa aaku. ");
INSERT INTO apb_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Oto molana no ko hola'i unue nga taa kei reu oodoi'omu, hunie uri maholo kei reu, na omu ke hiiwalaimoli oto. ");
INSERT INTO apb_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Nou sa'a ii'o tewa ike lo'u pe'i'omu huni ere-ere pe'i'omu, aana aalaha haahie walumalau ie, a Pwelu Eero-eero, ko lae oto mai. Ingeie e ka'a to'o aana ike nga nanamanga haahieu, ");
INSERT INTO apb_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","ta'e nga taa kei reu ngeena, kei reu mola hunie walumalau ke saie uri nou manata diana hunie a Mama'a. Aena leune nge no ko eu'esuie walu ola e unu'i hunieu. “!Hoe! Ta'ela'i, kolu ke lae oto mwaanie leu ie.” ");
INSERT INTO apb_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Oto a Jisas e he'i unue lo'u hunie mo pwaarongoisuli ingeie uuri, “Ineu oto ai grep to'ohuu, na Aamaku oto iini ko esuie hohola ni grep. ");
INSERT INTO apb_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Ingeie oto ko ta'aasie ta'ena nga sasarai ola aaku nge e ka'a hungu ike aani hue-huei ola. Na aana ko lio i suli diana aana hohola ingeie, nge mo sasarai ola kire ko hungu eeni hue-huei ola diana, ingeie ko si olo aasie ta'ena nga aaelanga mwaani'i hunie kire ke rere'a na ke hungu oto lo'u hiito'o. ");
INSERT INTO apb_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","I'omu, omu rere'a mango oto, aana nga taa nge nou ha'a-uusuli'omu aana. ");
INSERT INTO apb_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Omu ke ii'o susu oto aaku, na ineu ne kei ii'o susu oto no'one aamiu. Nga sasarai ola e sa'a hungu ike aani hue-huei ola mola maraana, na oto e ka'a lado aana tohungana ai. Oto e urine lo'u aana i'omu, aana omu sa'a hungu ike aani hue-huei ola na oto omu ka'a ii'o aaku. ");
INSERT INTO apb_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Ineu oto ai grep to'ohuu na i'omu oto mo sasarana. Iini ko ii'o susu oto aaku na ineu no'one aana, nge ke si hungu oto lo'u liutaa. Aena aana aaho'a aaku, omu sa'a roro'a ni da ike nga mei ola diana. ");
INSERT INTO apb_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Aana nga iini e ka'a ii'o susu eeku, aasilana kei lae mola mala sasarai ola aaela, oto ko nunulu mola. Na mo sasarai ola urine, kire ke so'okoni'i na aasileni ke lae mola i laona dunge hunie ke waru tetehu. ");
INSERT INTO apb_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Mala uri omu ke ii'o susu oto aaku na walaku ke ii'o susu oto aamiu, nge omu sai sukaa ta'ena nga mei ola saemiu hunie, na niilana kei lae oto huni'omu. ");
INSERT INTO apb_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Omu ke hungu diana huni haata'inie uri i'omu mo pwaarongoisuli ineu, na aena urine nge mwala ke si lio saie manikuluha'ana Aamaku. ");
INSERT INTO apb_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","“Ineu nou manata diana huni'omu oto mala a Mama'a e manata diana hunieu. Omu ke ii'o susu oto i laona manata-diananga ineu. ");
INSERT INTO apb_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Mala omu ko tola i sulie mo ha'atolanga ineu, ha'alaa omu ko ii'o susu i laona manata-diananga ineu, mala oto ineu nou lulu i sulie mo ha'atolanga Aamaku na nou ii'o i laona manata-diananga ingeie. ");
INSERT INTO apb_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","No ko unue walu ola ienini huni'omu uri hunie omu ke to'o aana ta'a-ta'a taungei ilenimwa'enga nge ineu nou to'o aana, na uri hunie ilenimwa'enga i'omu ke paine lo'u liutaa. ");
INSERT INTO apb_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Ha'atolanga ineu oto ie, uri omu ke manata diana huni'omu heiliu, mala oto ineu nou manata diana huni'omu. ");
INSERT INTO apb_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Nga iini e ka'a haata'inie ike nga mei manata-diananga ke paine lo'u liutaa aana iini ko niie mauriha'ana hunie mo malahune. ");
INSERT INTO apb_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Na i'omu oto mo malahuku, mala uri omu ke dau i sulie nga taa nou unue huni'omu. ");
INSERT INTO apb_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Nou ka'a sai'omu ike lo'u aana mo koni-konihe, aena aana koni-konihe e ka'a saie ike nga taa aalaha ingeie ko lo'o-lo'onga'inie. Ta'e no ko sai'omu uri maeni malahuku, na ahutana walu ola nou rongo'i mwaanie Aamaku, nou ha'arongo'omu oto aani. ");
INSERT INTO apb_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","I'omu, omu ka'a lio hilisieu ike, ta'e ineu ni nou lio hilisi'omu. Na nou niie mei esunge ie namiu, hunie omu ke hungu eeni hue-huei ola diana nge e sai ii'o huu. Oto aena leune, ta'ena nga mei ola omu ko sukaa mwaanie a Mama'a aena aana omu noruto'o aaku, a Mama'a ke si niie huni'omu. ");
INSERT INTO apb_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Oto no ko unue lo'u huni'omu uri omu ke manata diana huni'omu heiliu.” ");
INSERT INTO apb_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Oto a Jisas e he'i unue lo'u uuri, “Mala uri walumalau ko ngiduupu oto huni'omu, omu ke manata'inie uri e hola'i ngiduupu oto hunieu wau i na'o. ");
INSERT INTO apb_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Mala uri omu ke ne'ie mo iinoni aana walumalau, ha'alaa walumalau e sai manata diana oto huni'omu, mala e manata diana hunie ahutana mo iini ingeie nge kire ka'a lae ike i sulie a God. Ta'e aena aana omu ka'a uure ike aana walumalau, ta'e nou lio hilisi'omu mwaanie walumalau, oto aena mei olana nge walumalau ko si ngiduupu huni'omu. ");
INSERT INTO apb_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Omu ke aamasito'o aana mei wala nou unue ka'u huni'omu uri nga koni-konihe e ka'a paine ike lo'u liutaa aana aalaha ingeie. Oto mala uri mwala aana walumalau ngeena ko teunge'inieu, nge kire kei teunge'ini'omu no'one. Mala uri kire ke tola i sulie mo ha'atolanga ineu, ha'alaa kire kei tola i sulie no'one mo ha'atolanga i'omu. ");
INSERT INTO apb_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Ta'e kire kei teunge'ini'omu mola aena aana omu ko noruto'o aaku, na aana kire ka'a saie ike iini e uusunge'inieu mei. ");
INSERT INTO apb_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Mala uri ne ke su'uri lae mai laona walumalau huni ere-ere nada, ha'alaa mo ooraha'aanga ikire sa'a ii'o haada'i ike urine. Ta'e maholo ienini, e aasa oto hunie nga iini kei mumunie nga mo ooraha'aanga ingeie. ");
INSERT INTO apb_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Nga iini ko ngiduupu hunieu, nge ko ngiduupu oto no'one hunie Aamaku. ");
INSERT INTO apb_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Mala uri ne ke su'uri lae mai esuie mo ola nge nga iini aaopa e ka'a asui'i ue ngeena i matolada, ha'alaa mo ooraha'aanga ikire sa'a ii'o haada'i ike urine. Ta'e oto ie kire leesie taane mo hu'i-hu'ite, na kire saronai ngiduupu mola ue huni'emere'i Aamaku. ");
INSERT INTO apb_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Ta'e walu ola ienini ko reu oto urine, huni ha'a-oaie nga taa uusulana e lae i laona mo Uusu-uusu Maa'i uuri, Kire talei ngiduupu hunieu mola mwaakule. ");
INSERT INTO apb_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“I'emere'i a Mama'a mere kei uusunge'inie mai seemiu nga iini huni pe'i'omu, na ingeie oto Li'oa aani walaimolinge. Maholo kei lae mai, ke si unu haada'i eeku, ");
INSERT INTO apb_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","na i'omu no'one omu ke unu haada'i eeku oodoie mwala, aena aana omu o'o'o oto pe'ieu uure oto i aehotalana. ");
INSERT INTO apb_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Nou unue oto mo ola ienini huni'omu mwaanie uri omu deu tekela'inie hiiwalaimolinge i'omu. ");
INSERT INTO apb_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Aana kire kei oohe'omu mwaanie mo nume ni palo-palo mo Jiu, na aana maholoi sato ko lae maine, kire kei waeli'omu hiito'o hule aana iini ko horo'i'omu kei lo'onga'inie uri ko deu i sulie saena God. ");
INSERT INTO apb_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Mwala kei ha'asapesalu'a'omu urine, aena aana kire ka'a manata'ini'emere'i ike a Mama'a. ");
INSERT INTO apb_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Ta'e no ko unue oto mo ola ienini huni'omu, uri hunie kire ko si lai reu eemiu na omu ke aamasito'o aana uri nou ha'apasuli'omu taane oto aani. Nou ka'a unue ike mo ola ienini huni'omu oto aana maholo omu aehota lulu i sulieu, aena aana ineu ue pe'i'omu.” ");
INSERT INTO apb_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Oto a Jisas e he'i unue lo'u hunie mo pwaarongoisuli ingeie uuri, “Ta'e ie no ko lae oto i saana iini e uusunge'inieu mei. Na nga iini hikemiu e ka'a lo'onga'i ike hunie ke dolosi eeku uuri, ‘?Oto i'oe, o ko lae i tei na kei uri taa huni'o aana leune?’ ");
INSERT INTO apb_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Saemiu e honu mola aani saehuunge i'omu maraamiu, aena aana nou unue mo ola ienini huni'omu. ");
INSERT INTO apb_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Ta'e no ko unue oto huni'omu, e lae otoi diana huni'omu uri ne ke lae oto. Aana mala uri nou ka'a lae oto, nge iini huni pe'i'omu e sa'a lae ike mai i seemiu. Ta'e mala no ko lae oto ie, nge ne ke si uusunge'inie mai i seemiu. ");
INSERT INTO apb_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Na maholo kei lae mai, nge ke si haata'i diana aana hunie walumalau uri kire roro'a aana ooraha'aa, na uri kire ka'a saie ike oodota'inge, na uri a God kei saronai leire taane. ");
INSERT INTO apb_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Ingeie kei haata'i diana aana hunie mwala aana walumalau uri kire ooraha'aa ka'u aana kire ka'a sare hiiwalaimoli ike aaku. ");
INSERT INTO apb_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Na kei haata'i diana aana hunire uri kire ka'a saie ike oodota'inge aana ma'alana kire lei mae aaku, ta'e ineu, nou ii'o oodota'i mola na ko lae oto i saana a Mama'a aana leu kire sa'a he'i leesieu lo'u. ");
INSERT INTO apb_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Na kei haata'i diana aada uri a God kei saronai leire taane, aana lei-maesilana aalaha aana walumalau ie e pwani lae oto. ");
INSERT INTO apb_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Mo ola hunge taane ue aaku ni unu'i huni'omu, ta'e omu sa'a lo'onga'i susuli'i ike oto molana. ");
INSERT INTO apb_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Ta'e a Li'oa kei haata'inie walaimolinge a God huni'omu. Maholo kei lae mai ngeena, nge ke si na'omiu oto i lalo aana ahutana walaimolinge uure mwaanie a God. E sa'a ere ike mola tohune, ta'e kei ere i sulie nga taa e rongoa, na kei unue huni'omu mo ola kei haro oa taane ue aana nga maholo. ");
INSERT INTO apb_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Ingeie ke si ha'amanikulu'aau, aana kei ha'arongo'omu aana walaimolinge ineu. ");
INSERT INTO apb_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Ahutana walaimolinge na saenanaunge na oto ahutana to'o-to'olana a Mama'a mango, to'olaku ni otona. Oto maholo a Li'oa ko ha'arongo'omu aana walaimolinge a God, nge ko niie mo ola ineu namiu ni ngeena.” ");
INSERT INTO apb_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Oto a Jisas e he'i unue lo'u uuri, “Tatahana oto omu sa'a leesieu lo'u, na tatahana oto lo'u, omu kei he'i leesieu lo'u.” ");
INSERT INTO apb_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Oto ngaeta mo pwaarongoisuli ingeie ko si dolosi heiliu aadaelu uuri, “?Nga taa ni ko unu-unue hunikolu ie uri tatahana oto kolu sa'a leesie lo'u, na tatahana oto lo'u kolu kei he'i leesie lo'u? ?Na aana e ue ka'u ko unue uri kei reu urine aena aana ko lae oto i saana a Mama'a? ");
INSERT INTO apb_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","?Nga taa ni lo'onga'inge aana tatahana oto? !Kolu ka'a saie ike nga taa ko ere i sulie!” ");
INSERT INTO apb_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","A Jisas e saie mola kire ko sare dolosi aana, oto ko si te'uri hunire, “Nou unue uri tatahana oto omu sa'a leesieu lo'u, na tatahana oto lo'u omu kei he'i leesieu lo'u. ?Oto uri omu ko heitalenga'inie maraamiu aana nou ere urine? ");
INSERT INTO apb_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","No ko unue oto huni'omu uri omu kei ngara-ngara pe'i saehuunge, ta'e walumalau kei ile-ilenimwa'e mola. Omu kei sae-saehuu taane, ta'e saehuunge i'omu kei ne'i ilenimwa'enga lo'u mola. ");
INSERT INTO apb_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Maholo hu'e e kara'inie oto kei meuri aana mwela, nge ko saehuu aena aana maholoi sato ni sapesalunge ingeie e hule oto. Ta'e maholo kele mwela e hute oto, hu'e ngeena e pulongosie oto sapesalunge ingeie, aena aana ko ilenimwa'e oto haahie a kalena e hute mai laona walumalau. ");
INSERT INTO apb_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Oto i'omu na e urine no'one. Omu ko saehuu oto molana, ta'e ne kei he'i leesi'omu taane lo'u, na saemiu ke si honu aani ilenimwa'enga, aana taungei ilenimwa'enga nge nga iini e sa'a ta'aasie ike lo'u mwaani'omu. ");
INSERT INTO apb_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Na aana maholona omu sa'a dolosie ike nga mei ola aaku. No ko unue oto to'ohuu huni'omu uri ta'ena nga mei ola omu ko sukaa aana a Mama'a aena aana omu noruto'o aaku, nge kei niie oto huni'omu. ");
INSERT INTO apb_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Lai hule mai si'iri ienini, omu ka'a tohungei noruto'o aaku, nge omu ka'a sukaa ue nga mei ola aana Mama'a. Oto omu ke suke aana Mama'a, na aena aana saena hunie ilenimwa'enga i'omu ke ahu, nge ke si niie nga taa omu sukaa huni'omu.” ");
INSERT INTO apb_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Oto a Jisas ko si te'uri lo'u, “Nou ere-ere ka'u aani aalahuunge huni'omu i sulie walu ola ienini, ta'e maholoi sato ko kara'ini oto mai na nou sa'a ere ike lo'u pe'i'omu aani aalahuunge. Aana maholona ne kei haata'i oodo-oodo mola aana a Mama'a huni'omu. ");
INSERT INTO apb_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Oto aana maholona i'omu maraamiu omu ke si sukaa nga mo ola aana a Mama'a aena aana omu noruto'o aaku. Nou ka'a unue ike uri ineu mola nge nou sai sukaa nga mei ola namiu aana a Mama'a, ta'e i'omu maraamiu omu sai suke oodo-oodo mola aana a Mama'a. ");
INSERT INTO apb_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Aena aana a Mama'a maraana e manata diana oto huni'omu, aana omu manata diana no'one hunieu, na omu hiiwalaimoli aana uri ineu nou uure oto mai mwaanie a God. ");
INSERT INTO apb_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Nou uure ka'u mei mwaanie a Mama'a, nge nou si lae mai laona walumalau. Oto ie no ko ho'ala'i oto lo'u mwaanie walumalau, na no ko lae oto i saana a Mama'a.” ");
INSERT INTO apb_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Oto mo pwaarongoisuli ingeie kire ko te'uri hunie, “Ie, o ko si ere taa eena, na o ka'a ere ni aalahuunge ike lo'u. ");
INSERT INTO apb_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Melu lio saie taane oto uri i'oe o saie ahutana walu ola, na melu ka'a to'o aana ike nga mo dolosinge lo'u. Aena urinena nge melu si hiiwalaimoli uri o uure oto mai mwaanie a God.” ");
INSERT INTO apb_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","A Jisas e aalamire, oto ko te'uri, “?Omu hiiwalaimoli taane oto ohe eena? ");
INSERT INTO apb_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Lio ka'u, maholoi sato ko kara'ini oto mai, na ingeie oto taane ie, maholo oto hunie ahutemiu omu kei meni tatanga oto mwaanieu. Nga iini ni oto e lae-lae oto takoie hanue ingeie, na ta'e ineu mola ne ke si oore maraaku. Ta'e nou ka'a oore ike taane maraaku, aena aana a Mama'a taane pe'ieu. ");
INSERT INTO apb_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Nou unue oto walu ola ienini huni'omu, hunie uri omu ke si to'o aana hanuelamanga aani ii'onga tararuru pe'ieu. Walumalau kei ha'asapesalu'a'omu taane, ta'e mwaanie omu me'u-me'u. Saemiu ke mango mola, aana nou tola hehesie oto walumalau.” ");
INSERT INTO apb_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Oto i purine a Jisas e ere mango urine, e si lio ta'au i Lengi na ko aarenga'i uuri, “Mama'a, maholoi sato e hule oto. O ke ha'amanikulu'aau a Kalemu, hunie ineu a Kalemu ne ke si ha'amanikulu'a'o lo'u. ");
INSERT INTO apb_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Aana o niie oto mai hunieu nanamanga haahie ahutana iinoni, uri ne ke si niie maurihe huu nana mo iini o niire nakue. ");
INSERT INTO apb_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Na lo'onga'inge aana maurihe huu ngeena, uri hunie mwala ke sai diana aamu, ta'a-ta'a God oto to'ohuu, na uri kire ke saieu no'one, a Jisas Kraes, iini o uusunge'inie mai. ");
INSERT INTO apb_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Nou ha'amanikulu'a'o oto mai aano i leu aana nou ha'amangoa oto mei esunge o niie hunieu uri ne ke asuie. ");
INSERT INTO apb_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Oto ie, Mama'a, o ke ha'amanikulu'aau aana mei menikulu'anga ngeena nou to'o aana ka'u oto pe'i'o i na'ona ha'aholalana walumalau.” ");
INSERT INTO apb_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Oto a Jisas e si he'i aarenga'i lo'u uuri, “Mama'a, nou haata'inie oto walu ola i suli'o hunie mo iini o maire nakue mwaanie walumalau ie. Ikire mo iinoni i'oe, na o maire oto nakue. Oto kire tola oto i sulie walamu, ");
INSERT INTO apb_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","na kire si saie uri ta'ena nga ola o niie hunieu e uure oto mai mwaani'o to'ohuu. ");
INSERT INTO apb_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Aana mo ha'a-uusulinge o nii-nii'i hunieu, nou nii'i oto hunire na kire toole'i oto. Kire manata'inie oto to'ohuu uri nou uure mai mwaani'o, na kire hiiwalaimoli oto aana uri i'oe o uusunge'inieu mei. ");
INSERT INTO apb_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Oto no ko eitanai'o talada. Nou ka'a aitanai'o ike talana mwala aana walumalau ie, ta'e no ko eitanai'o talana mo iini o maire oto nakue, aena ikire mo iini i'oe ni ngeena. ");
INSERT INTO apb_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Ahutana walu ola nou to'o aani, mo ola i'oe, na ahutana walu ola i'oe, mo ola ineu. Na i tehula'ana mo mwane ikure ngeena, nge mwala ke si leesie manikuluha'aku. ");
INSERT INTO apb_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Ineu no ko lae oto ta'au i seemu. Nou sa'a ii'o ike lo'u mei welumalau, ta'e ikire ha'alaa kire ko o'o'o ue mai welumalau. Mama'a Maa'i, o ke kineta'inire aana nanamanga i'oe, nanamanga nge o niie hunieu, hunie uri kire ke ne'ie nga ta'a-ta'a iinoni oto mala ikure. ");
INSERT INTO apb_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Maholo nou o'o'o pe'ire, nou koni diana aada aana nanamanga aana satamu, nanamanga nge o niie ka'u hunieu. Nou lio i suli diana aada, hule aana nga ta'a-ta'a iini aada e ka'a ai'aa, ta'e ta'a-ta'a iini mola e adona oto ke ai'aa huni ha'a-oaie mo Uusu-uusu Maa'i. ");
INSERT INTO apb_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","“Ta'e ie no ko lae oto ta'au i seemu, na no ko unue walu ola ienini ta'au huni'o maholo ineu ue mai welumalau uri hunie saena mo mwane ienini ke honu aana ilenimwa'enga ineu. ");
INSERT INTO apb_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Nou nii mangoa oto mo ha'a-uusulinge i'oe hunire, na walumalau e ngiduupu hunire aena aana ikire mo iinoni aana walumalau ha'ike, oto mala ineu nga iinoni aana walumalau ha'ike. ");
INSERT INTO apb_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Nou ka'a sukaa ike uri o ke ta'aasire mwaanie walumalau, ta'e hunie o ke kineta'inire mwaanie iini tata'ala, a Pwelu Eero-eero. ");
INSERT INTO apb_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Aana ikire nga mo iini ha'ike aana walumalau, oto mola mala ineu nga iinoni aana walumalau ha'ike. ");
INSERT INTO apb_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Saeku uri o ke ha'a-uusulire aana walamu, aena aana walaimolinge ni otona, na walaimolinge ngeena e sai pe'ire hunie kire ke oopara maraada mwaanie ooraha'aa, na hunie kire ke ii'o maa'i mola namue. ");
INSERT INTO apb_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Mala ka'u ie o uusunge'inieu mei laona walumalau, nge no ko uusunge'inire oto i laona walumalau. ");
INSERT INTO apb_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Na i tehula'ada, nou oopaau oto huni esunge mola namue, hunie ikire no'one, kire ke oopara maraada mwaanie ta'ena nga ooraha'aa huni esunge no'one namue.” ");
INSERT INTO apb_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Oto a Jisas e si he'i aarenga'i lo'u uuri, “Mama'a, nou ka'a aitanai'o ike mola talana mo iini ie hahaiteli, ta'e no'one talana mo iini e hiiwalaimoli eeku i tehula'ana mo ha'a-uusulinge ikire. ");
INSERT INTO apb_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Oto no ko eitanai'o Mama'a, uri hunie kire ke mani ne'ie ta'a-ta'a iinoni, mala oto i'oe i lalo aaku na ineu i lalo aamu. No ko eitanai'o uri hunie kire ke ii'o no'one i lalo aakarue, hunie walumalau ke hiiwalaimoli aana uri i'oe o uusunge'inieu mei. ");
INSERT INTO apb_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Oto mei menikulu'anga nge o niie hunieu, nou he'i niie lo'u hunire, uri hunie kire ke ne'ie oto nga ta'a-ta'a iini mala oto ikure ta'a-ta'a iinoni. ");
INSERT INTO apb_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","I'oe o ii'o i lalo aaku, na ineu ne ke ii'o i lalo aada, uri hunie kire ke tohungei ne'ie oto ta'a-ta'a iinoni. Oto walumalau ke si lio saie uri i'oe ni taane o uusunge'inieu mei, na uri o manata diana hunire oto mala o manata diana hunieu. ");
INSERT INTO apb_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Mama'a, nou saeto'o aana mo iini nge o maire oto nakue, kire ke ii'o oto pe'ieu aana leu no ko ii'o aana. Saeku hunie uri kire ke leesie manikuluha'aku, mei menikulu'anga nge o niie nakue aana o manata diana hunieu oto wai na'ona ha'aholalana walumalau. ");
INSERT INTO apb_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","“Mama'a, i'oe oto o tohungei oodota'i, na ma'alana uri walumalau e ka'a sai'o, ta'e ineu nou sai'o mola, na mo iini ineu ie kire saie taane uri i'oe ni o uusunge'inieu mei. ");
INSERT INTO apb_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Nou haata'ini'o taane oto aada, na ne kei he'i ha'asaire lo'u aana walu ola i suli'o, hunie uri mei manata-diananga nge o manata diana hunieu aana, ke ii'o i lalo aada na hunie uri ineu no'one ne ke ii'o i lalo aada.” ");
INSERT INTO apb_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Maholo a Jisas e aarenga'i mango urine, e si iisitaa pe'ie mo pwaarongoisuli ingeie na kire ko lae holosie darimwa'a i Kedron. Po'o ta'au aana dari ngeena, nga hohola aani ei olif e ii'o ta'au i leune. Oto kire ko lai sili ta'au i laona hohola ngeena. ");
INSERT INTO apb_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","5","A Jiudas e saie mone mola leune aana kire lae-lae tarau pe'ie a Jisas aana. Oto aana a Jiudas ko pweloa Jisas hunie mo maelonga ingeie, nge e si lae i ha'arongoa mo Parise na mo na'ohai pris. Oto kire ko uusunge'inie mai pulitaa paine aani ramo mo Rom, pe'ie mo mwane ni Jiu e kakakali aana Nume Maa'i Peine, na a Jiudas e na'oda hunie leu a Jisas e ii'o aana. Kire lae ta'au pe'i laite, na pe'i sine, na oto pe'ie walu ola huni heiseuni. A Jisas mone e saie mola nga taa kei reu aana, ko si iisitaa honosire na ko dolosi oto aada uuri, “?A tei ni nge omu ko lo'ohiena?” Oto kire ko aalamie uuri, “A Jisas ni Nasaret.” Oto a Jisas ko si te'uri hunire, “Ineu ka'u oto ie.” ");
INSERT INTO apb_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Maholo a Jisas e unue hunire uuri, “Ineu ka'u oto ie,” kire du'e aaliho'i na kire ko ladama'i oto i aano. ");
INSERT INTO apb_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Oto ko he'i dolosi lo'u aada uuri, “?A tei ni omu ko lo'ohiena?” Kire aalamie, oto kire ko te'uri, “A Jisas ni Nasaret.” ");
INSERT INTO apb_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Oto a Jisas ko he'i unue lo'u hunire uuri, “Nou unue ka'u oto huni'omu uri ineu oto ingeie. Mala uri omu ko lo'ohieu to'ohuu, nge omu ke toli'aasie mo pwaarongoisuli ineu ie kire ke lae.” ");
INSERT INTO apb_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Ko ere urine huni ha'a-oaie mei wala nge e unue uuri, “Nou ka'a dau tekela'inie ike nga iini hikana mo iini nge o maire nakue.” ");
INSERT INTO apb_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Oto a Saemon Pita ko si darasie naihi ingeie na ko lama mousie aalinge i pwalo-pwalona a Malakas, koni-konihe a Na'ohana Mo Na'ohai Pris. ");
INSERT INTO apb_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Oto a Jisas ko te'uri hunie a Pita, “O ke ne'i eeliho'i aana naihi i'oe i talana. A Mama'a ni e unue leune ke rau urine, na ne kei tola oto i sulie ma'alana ne ke sapesalu oto uri taa.” ");
INSERT INTO apb_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Oto na'ohai ramo haahie sinolai ramo ni Rom, pe'ie ngaeta mo ramo ingeie, na mo mwane kakakali ikire mo Jiu, kire mani lae mai tapolie a Jisas na kire ko pwesue oto. ");
INSERT INTO apb_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Oto kire ko hola'i toolea oto i na'ona a Anas aana ingeie repo mwane hungaona a Kaiapas, Na'ohana Mo Na'ohai Pris aana maholo ngeena. ");
INSERT INTO apb_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Na a Kaiapas oto iini e ha'ananaue mo na'ohai mwane mo Jiu uri e lae otoi diana liutaa hunie nga ta'a-ta'a iinoni mola ke mae honotana ahutana mwala. ");
INSERT INTO apb_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","A Saemon Pita na ngaeta pwaarongoisuli lo'u kirerue ko holo maholo i tala taane mola i sulie pulitaa ni ramo nge kire tapolie a Jisas. Oto ngaeta pwaarongoisuli ngeena mone e sai diana aana na'ohai pris ngeena a Anas, oto ko si lai sili pe'ie a Jisas ta'au i laona lolata aana nume ingeie. ");
INSERT INTO apb_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Ta'e a Pita e oore mola ta'au i aena maa aana para po'oi sinaha. Oto pwaarongoisuli ngeena nge a na'ohai pris e sai diana aana, e aaliho'i lo'u poi sinaha, ko si ere pe'ie keni ko kakalie maa na ko toolea ta'au a Pita i laona lolata. ");
INSERT INTO apb_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Oto a keine ko te'uri hunie a Pita, “Sa'a mola i'oe ngaeta iini no'one aana mo pwaarongoisuli a mwane ie.” Oto a Pita ko aalamie a keine uuri, “Ineu ha'ike.” ");
INSERT INTO apb_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Maholona wawai e tohungei peine, oto mwala au'esu na mo mwane kakakali ngeena, kire rurue dunge aani loilohi, kire si uure kali-kelie aana kire ko rakani. Na a Pita no'one lo'u pe'ire, e uure ko rarakani. ");
INSERT INTO apb_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Oto aana maholona Na'ohana Mo Na'ohai Pris ko si dolosi aana a Jisas i sulie mo pwaarongoisuli ingeie na i sulie ha'a-uusulinge ingeie. ");
INSERT INTO apb_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","A Jisas e aalamie, oto ko te'uri, “Nou talei ere-ere haada'i ke'u hunie ahutana walumalau. Nou ha'a-ha'a-uusuli ke'u i laona mo nume ni palo-palo na i laona Nume Maa'i Peine, mo leu ahutana mo Jiu ko loo-loko aani. Nou ka'a ere-ere mumuni ike aana nga mei ola. ");
INSERT INTO apb_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","?E ue o ko dolosi urine aaku? O ke dolosi aana mo iini e rongoa mo ha'a-uusulinge ineu, uri nga moi taa ni nou unu-unu'i hunire. Ikire, kire saie nga taa nou unu-unue.” ");
INSERT INTO apb_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Na maholo e ere mango urine, oto ngaeta iini aana mo mwane kakakali nge kire uure pe'ie i leune, ko si lae mai hidelie maana a Jisas, na ko te'uri hunie, “?Uri o malisi ni ere urine hunie Na'ohana Mo Na'ohai Pris?” ");
INSERT INTO apb_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Oto a Jisas ko aalamie uuri, “Mala uri no ko ere takalo aana nga mei ola, o ke haata'inie takalonga ineu aana mwala. ?Ta'e mala uri no ko ere to'ohuu, na e ue o ko hidelieu?” ");
INSERT INTO apb_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Oto a Anas ko si uusunge'inie a Jisas i saana a Kaiapas, Na'ohana Mo Na'ohai Pris, na kire pwasue ue. ");
INSERT INTO apb_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Maholo na a Saemon Pita e uure ko rarakani ue, kire ko si te'uri hunie, “Sa'a mola i'oe ngaeta iini no'one aana mo pwaarongoisuli a mwane ngeena.” Ta'e a Pita ko taateinge'inie lo'u mola, na ko te'uri, “Ineu ha'ike.” ");
INSERT INTO apb_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Oto ngaeta iini aana mo koni-konihe a Na'ohana Mo Na'ohai Pris, iini e takihana mwane nge a Pita e lama mousie aalingana, ko si te'uri, “Sa'a mola nou leesi'o no'one pe'ie a Jisas oto ta'au i hohola.” ");
INSERT INTO apb_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Oto a Pita ko si he'i taateinge'inie lo'u, na kue ko tolana ngara oto. ");
INSERT INTO apb_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Oto mola i wa'alie i maahu'o-hu'o, kire si toolea a Jisas mwaanie nume a Kaiapas hunie nume paine ni aalahanga mo Rom. Mo mwane paine ikire mo Jiu, kire ko ha'ahili-hili aena aana kire sare ii'o rere'a malisine Houlaa Ni Liumwaanie. Oto kire ka'a sare sili ike i laona nume ni aalahanga ngeena mwaanie kire waelie ha'atolanga ikire aana kire sili i laona nume mo Aapoloa Aaopa, na urine kire lo'uhanga'a oto. ");
INSERT INTO apb_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Oto a Paelat ko iisitaa ta'au i saada i sinaha, na ko te'uri, “?Nga mei ola aaela uri taa ni a mwane ie e asuie?” ");
INSERT INTO apb_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Kire aalamie a Paelat, oto kire ko te'uri, “Mala uri ke su'uri deu aaela, ha'alaa melu ka'a niie ike ta'au i nimemu urine.” ");
INSERT INTO apb_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Oto a Paelat ko si te'uri hunire, “Omu ke toolea, na omu ke leie maraamiu i sulie mo ha'atolanga i'omu.” Oto mo Jiu kire aalamie uuri, “Ta'e e ka'a adona ike mo ha'atolanga i'omu mo Rom hunie i'emi mo Jiu emi ke horo maesie nga iinoni i tehula'ana leinge i'emi.” ");
INSERT INTO apb_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Leune e rau urine huni ha'a-oaie nga taa a Jisas e unue maholo e ere lalai uri kire kei horo maesie i sulie tolahana mo Rom. ");
INSERT INTO apb_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Oto a Paelat e he'i sili eeliho'i lo'u weu i nume ni aalahanga ngeena, na ko soie a Jisas, ko si dolosi aana uuri, “?Uri i'oe ni oto inemauri mo Jiu?” ");
INSERT INTO apb_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","A Jisas e aalamie, oto ko te'uri, “?Uri o ko dolosi aaku urine tohumu, wa ohe nga mwala aaopa e unueu i seemu?” ");
INSERT INTO apb_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Oto a Paelat e aalamie a Jisas uuri, “?Uri o ko lo'o-lo'onga'i uri ineu nga mwane ni Jiu? Mwala i'oe maraada na oto mo na'ohai pris ni kire toole'o mai seeku ie. ?Nga taa ni o deu aaelasie?” ");
INSERT INTO apb_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Oto a Jisas ko te'uri, “Aalahanga ineu nga ola aana walumalau ienini ha'ike. Mala uri ne ke urihana mo inemauri ni welumalau, ha'alaa mo koni-konihe ineu kire ooho honosieu mwaanie uri mo mwane paine aana mo Jiu kire tooleau. Ta'e ha'ike, aana aalahanga ineu e aaopa oto mwaanie i leu.” ");
INSERT INTO apb_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Oto a Paelat ko si te'uri hunie, “!Oto i'oe ngaeta inemauri taane!” A Jisas e aalamie, oto ko te'uri, “Nge ka'u oto o ko unuena, uri ineu inemauri. Na aena aana aalahanga ineu ngeena mone nou hute. Na nou lae mai uri hunie ne ke toolea walaimolinge mai i laona walumalau. Ta'ena nga iini ko mwa'e-mwa'e huni lulu i sulie walaimolinge, nge e sai rongo hunie walaku.” ");
INSERT INTO apb_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Oto a Paelat ko si dolosi uuri, “?Nga taa ni walaimolinge?” Na e ere mango urine, e si he'i iisitaa lo'u i saana mo Jiu ta'i sinaha, na ko te'uri hunire, “Nou ka'a lio oodoie ike nga mei ola aaela aana a mwane ie. ");
INSERT INTO apb_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Ta'e oto i sulie tolahamiu suli maholo aana Houlaa Ni Liumwaanie, nou sai luhesie nga iini huni'omu mwaanie nume ni ho'o. ?Oto e ue? ?Uri omu saeto'o aana ne ke luhesie huni'omu mwane ie kire haara'inie aana ‘Inemauri mo Jiu?’” ");
INSERT INTO apb_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Oto kire ko si meni tea paine mola uuri, “!A mwane ie ha'ike! !Ta'e a Barabas ni melu saeto'o aana!” (A Barabas ie ingeie nga horopeli nge e ooho honosie mo Rom). ");
INSERT INTO apb_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Oto a Paelat e si unue hunie mo ramo uri kire ke toolea a Jisas na kire ke rapusie. ");
INSERT INTO apb_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Na kire ko ha'ato'onie mala inemauri huni ha'amwasi aana. Kire asuie rorodara aani walo kau-keu, kire ko si ne'ie i pweune a Jisas, na kire ko ha'ato'onie aana to'oni tetewa nonoro'a mala mo aalaha ko ho'o-ho'osi'i. ");
INSERT INTO apb_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Oto kire ko si ha'a-ha'amwasi aana uuri, “!Lahea inemauri mo Jiu!” Na kire ko hide-hidelie papaline. ");
INSERT INTO apb_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Mango urine a Paelat e he'i iisitaa lo'u ta'au i saada mo na'ohai mwane ni Jiu, ko si te'uri hunire, “Lio ka'u, ne kei toolea oto poi seemiu i sinaha i leu, uri hunie omu ke saie uri nou ka'a lio oodoie ike nga mei ola aaela aana huni lei mae aana haahie.” ");
INSERT INTO apb_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Oto kire toolea a Jisas poi i sinaha, na e ho'osie oto rorodara aani walo kau-keu i pweune na e to'oni oto aani to'oni noro. Oto a Paelat ko si te'uri hunire, “!Lio ka'u! !A mwaena ka'u oto ie!” ");
INSERT INTO apb_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Maholo mo na'ohai pris na mo mwane kakakali kire leesie a Jisas, oto kire ko si tea oto paine uuri, “!Horo maesie! !Horo maesie i lengine po'u-po'u!” Oto a Paelat ko te'uri hunire, “I'omu, omu ke toolea hunie omu ke lai horo maesie i lengine po'u-po'u maraamiu, aana ineu nou ka'a lio oodoie ike nga mei ola ke dau hu'isie.” ");
INSERT INTO apb_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Oto mo Jiu ko aalamie a Paelat uuri, “Ha'atolanga i'emeelu e unue uri e malisine oto ke mae, aana ko unue uri ingeie Kalena God.” ");
INSERT INTO apb_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Maholo a Paelat e rongo urine ko si tohungei me'u oto hiito'o. ");
INSERT INTO apb_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Oto e sili lo'u ta'au i nume ni aalahanga, ko si dolosi aana a Jisas uuri, “?I'oe, o uure mai i tei?” Ta'e a Jisas e ka'a aalamie ike. ");
INSERT INTO apb_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Oto a Paelat ko he'i te'uri lo'u hunie, “?Aana e ue ka'u o ka'a sare ere ike pe'ieu? ?Uri o saie taane nou to'o aana nanamanga huni toli'aasi'o, wa huni horo maesi'o i lengine po'u-po'u?” ");
INSERT INTO apb_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","A Jisas e aalamie, oto ko te'uri, “Mala uri a God ke su'uri niie nanamanga ngeena huni'o, ha'alaa o ka'a to'o aana ike no'one nga nanamanga haahieu. Aena urine, iini nge e pweloau huni'o, ooraha'aanga ingeie e paine oto lo'u liutaa.” ");
INSERT INTO apb_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Maholo a Paelat e rongo urine, ko si eri'apasie uri ke toli'aasie a Jisas. Ta'e mo Jiu ko si tea paine lo'u mola uuri, “Mala uri o kei luhesie a mwane ngeena, i'oe nga malahune a inemauri peine i Rom ha'ike. Aana ta'ena nga iini ko unue maraana uri ingeie inemauri, nge ko heukama honosie a inemauri peine i Rom ni ngeena.” ");
INSERT INTO apb_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Maholo a Paelat e rongoa kire ko ere urine, e si toolea a Jisas i sinaha na ko ii'o i aano i lengine naunekume ni leinge aana leu sailana uuri, “Leu kire hataa'i heu aana” na aana erenga mo Jiu uuri, “Gabata.” ");
INSERT INTO apb_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Maholona na ko kara'inie oto maholo sato e ngara e oono i maahu'o-hu'o aana hai dinge talama'inge loosie Houlaa Ni Liumwaanie. Oto a Paelat ko te'uri hunie mo Jiu, “!Inemauri i'omu oto ie!” ");
INSERT INTO apb_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Oto kire ko si tea paine mola uuri, “!Horo maesie! !Horo maesie! !Horo maesie i lengine po'u-po'u!” Oto a Paelat ko dolosi aada uuri, “?Uri omu saeto'o aana uri ne ke horo maesie inemauri i'omu?” Mo na'ohai pris e aalamie, oto kire ko te'uri, “Ta'a-ta'a inemauri mola emi to'o aana oto a inemauri peine i Rom.” ");
INSERT INTO apb_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Oto a Paelat e si toli'aasie a Jisas hunire huni horo maesie i lengine po'u-po'u. Oto mo ramo kire si toolea a Jisas, ");
INSERT INTO apb_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","na kire ko deu rarahie uri ke aanga'inie po'u-po'u maraana, na e iisitaa ta'au takoie leu sailana uuri, “Leu ni Rarata,” na aana erenga mo Jiu uuri, “Golgata” ");
INSERT INTO apb_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Oto kire rapu taalengasie a Jisas wau i leune i lengine po'u-po'u. Na ngaeta ro mwane lo'u kire ko horo maesirerue i lengine mo po'u-po'u pe'ie, nga iini aana nga aapa, na a Jisas i matoladarue. ");
INSERT INTO apb_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Na a Paelat e uusue mo wala uuri, A Jisas Ni Nasaret, Inemauri Mo Jiu, oto ko si ne'ie i pweune po'u-po'u a Jisas. ");
INSERT INTO apb_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Mwala hunge aana mo Jiu kire saaie mo wala ngeena, aena aana leu nge kire ne'ie po'u-po'u a Jisas aana, e ka'a ha'ataulie ike lo'u huilume, na kire uusue aana e oolu erenga—erenga mo Jiu, na erenga mo Rom, na erenga mo Krik. ");
INSERT INTO apb_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Oto mo na'ohai pris mo Jiu ko si te'uri hunie a Paelat, “O ke su'uri uusue, ‘Inemauri mo Jiu,’ ta'e o ke uusue mola uuri, ‘A mwane ie e unue uri ingeie inemauri mo Jiu.’” ");
INSERT INTO apb_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","A Paelat e aalamire, oto ko te'uri, “Nga taa nou uusue, nou uusue oto.” ");
INSERT INTO apb_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Maholo mo ramo kire uie a Jisas mango i lengine po'u-po'u, oto kire ko si da mo to'oni ingeie, kire ko oa aana e hai aapa, nga leu ni oto nga ramo. Leu ooreta kire toolea no'one ngaeta to'oni ingeie nge nga maai teu-teurite ha'ike aana, aena aana ola kire hao ha'ileku mola aana. ");
INSERT INTO apb_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Oto kire ko si te'uri hunire maraada, “Kolu ke su'uri hakasie lo'u, ta'e kolu ke inie daes mola hunie, huni leesie uri a tei kei to'o aana.” Leune e rau urine uri huni ha'a-oaie Uusu-uusu Maa'i nge e unue uuri, Kire oa aana mo to'oni ineu, na kire inie daes hunie ngaeta mo to'oni ineu. Nga taa mo ramo kire asuie aana mo to'oni a Jisas otona. ");
INSERT INTO apb_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Ngaeta mo iini kire uure kara'inie po'u-po'u a Jisas nge a nikana, na keni eesine a nikana, na a Meri hu'e a Klopas, na a Meri ni Makdala. ");
INSERT INTO apb_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","A Jisas e leesie a nikana na pwaarongoisuli e tohungei manata diana hunie, kirerue uure mola kara'ini, ko si te'uri hunie a nikana, “Teite, o ke leesie a mwane ngeena oto mala a kalemu.” ");
INSERT INTO apb_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Oto ko te'uri lo'u hunie pwaarongoisuli ngeena, “O ke leesie, a nikemu oto ngeena.” Oto uure aana maholona, pwaarongoisuli ngeena e si toolea a Meri, nikana Jisas, na ko lio oto i sulie i nume ingeie. ");
INSERT INTO apb_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Mango urine, a Jisas mone e manata'inie oto uri walu ola e mango tee-tee oto. Oto huni ha'a-oaie mo Uusu-uusu Maa'i, nge ko si te'uri, “No ko maarou.” ");
INSERT INTO apb_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Na i leune kire to'o aana nga nime e honu aani waen aha'i. Oto kire da mei loi-losi, kire ko ha'amedoa aana waen ngeena. Kire ne'ie i ngongo'ana mai ei, kire ko si teela'inie i ngidune a Jisas. ");
INSERT INTO apb_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Maholo a Jisas e mami aahongana mei waen aha'i ngeena, oto ko si te'uri, “E mango oto eena.” Oto e si ha'atengo-tengoa pwaune na ko mae oto. ");
INSERT INTO apb_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Oto mo na'ohai mwane mo Jiu kire lai ha'atohu aana a Paelat uri hunie ke toli'aasie mo ramo ke oie mo ae'aena e oolu mwane i lengine mo po'u-po'u ngeena hunie kire ke mae lau-leu, na uri kire ke oohosie mo rae aada i aano. Kire sare sukaa urine aena aana dinge talama'inge ni ngeena, hai dinge huni deu aakau loosie Dinge Maa'i lo'u mola i ho'owa. Oto kire ka'a saeto'o aana ike mo rae aana mo mwaena ke saronai o'o'o i lengine mo po'u-po'u aana Dinge Maa'i, aana hai dinge ngeena e tohungei maa'i oto liutaa. ");
INSERT INTO apb_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Oto mo ramo ko si lae mai, kire ko oie ae'aena eetana nga mwane, na lo'u ae'aena ruana nga mwane nge kire horo'ie pe'ie a Jisas. ");
INSERT INTO apb_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Ta'e maholo kire lai hule aana a Jisas na kire ko leesie uri e mae oto, nge kire ka'a oie ike lo'u ae'aena. ");
INSERT INTO apb_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Ngaeta iini aana mo ramo e otomie papara'ana Jisas aana noma, oto aapu na wai e tolana pwisitaa oto. ");
INSERT INTO apb_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Na ineu nge no ko uusu-uusu ienini, ineu maraaku nou leesie leune e rau oto to'ohuu, na no ko unu ha'a-oaie uri e to'ohuu oto. No ko ere aana walaimolinge hunie uri i'omu no'one omu ke hiiwalaimoli. ");
INSERT INTO apb_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Walu ola ienini e rau urine, uri huni ha'a-oaie Uusu-uusu Maa'i uuri, Nga ta'a-ta'a suisuli aana e sa'a ma'oi ike. ");
INSERT INTO apb_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Na ngaeta Uusu-uusu Maa'i e unue lo'u uuri, Kire kei to'omaaie iini kire otomie ka'u. ");
INSERT INTO apb_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Oto i purine walu ola ienini e haro mango, nge a Josep ni Arimatia ko si ha'atohu aana a Paelat uri ke toolea rae aana a Jisas. A Josep ingeie nga pwaarongoisuli mumuni a Jisas, aena aana e ma'ute'inie mo na'ohai mwane ni Jiu. A Paelat e toli'aasie hunie a Josep, oto e si lae mai, ko toolea rae aana a Jisas. ");
INSERT INTO apb_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","A Nikodimas iini nge e hola'i lae ka'u i saana Jisas aana ngaeta hai rodo, e lae no'one pe'ie a Josep na e toolea ola mala oolu aawalai kilo aani dango wau-wesu, mo ola huni ne'i'i i sapena mo rae. ");
INSERT INTO apb_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","E ro mwane ngeena kirerue toolea rae aana a Jisas oto kirerue uloa aani sala rere'a pe'ie mo dango wau-wesu oto mala tolahada mo Jiu hunie haitolinge. ");
INSERT INTO apb_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Na aana leu nge kire horo'ie a Jisas aana, nga hohola wau i leune, na i laona hohola ngeena, nga kilipwe'u haalu i leune, ola kire ka'a haitolinge'inie ue nga iini i laona. ");
INSERT INTO apb_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Oto aana sato ko kara'i suu hunie ha'amangoa hai dinge ikire mo Jiu hunie dau aakau loosie Dinge Maa'i, nge e ro mwane ko ne'ie oto rae aana a Jisas wau i laona kilipwe'u ngeena, aena aana e kele ii'o kara'ini. ");
INSERT INTO apb_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Oto i maahu'o-hu'o aana eetana nga dinge i purine Dinge Maa'i Mo Jiu, maholo e rorodo'a ue, a Meri ni Makdala e lae i saana kilipwe'u. Maholo e lae wau i hule aana kilipwe'u, na ko leesie hau nge kire hono-honoa kilipwe'u aana, ta'aasilana e lae oto. ");
INSERT INTO apb_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Oto e huru, ko lae oto i saana Saemon Pita na ngaeta pwaarongoisuli lo'u, iini nge a Jisas e manata diana hunie. Oto ko ha'arongorarue uuri, “Kire toolea oto rae aana Aalaha mwaanie kilipwe'u na melu ka'a saie ike uri kire lai konie i tei.” ");
INSERT INTO apb_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Oto a Pita na ngaeta pwaarongoisuli lo'une, kirerue huru oto i saana kilipwe'u. ");
INSERT INTO apb_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Na pwaarongoisuli lo'une e huru liutaa aana a Pita, na e hola'i hule oto aana kilipwe'u. ");
INSERT INTO apb_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","E aonga'i hao i laona kilipwe'u, na ko leesie mo sala rere'a kire uloa aani kire ii'o laku taane. Ta'e e ka'a sili ike hao i laona. ");
INSERT INTO apb_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Oto a Saemon Pita e hule lo'u hao i sulie, ko sili tara'asi oto i laona kilipwe'u, na ko leesie mo sala rere'a kire uloa aani kire ii'o laku taane. ");
INSERT INTO apb_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Na e leesie no'one mei sala nge kire erea'inie ahuie pwaune a Jisas. E ka'a ii'o ike pe'ie mo sala kire uloa aani, ta'e e ii'o aaopa mola na lulungilana e lae oto. ");
INSERT INTO apb_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Oto ngaeta pwaarongoisuli lo'une, iini nge e hola'i hule aana kilipwe'u, e he'i sili lo'u hao, na e leesie walu olana, ko si hiiwalaimoli uri a Jisas e ta'ela'i to'ohuu mwaanie maenga. ");
INSERT INTO apb_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Uure oto wau i na'o kire ka'a hiiwalaimoli ike aana mo Uusu-uusu Maa'i nge e unue uri a Kraes kei saronai ta'ela'i mwaanie maenga, ta'e aana maholona nge kire si aehota hiiwalaimoli. ");
INSERT INTO apb_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Oto e ro pwaarongoisuli ngeena kire si eeliho'i takoie leu kire ko o'o'o aana. ");
INSERT INTO apb_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Ta'e a Meri ni Makdala e uure mola po'oi sinaha aana kilipwe'u, ko ngara-ngara. Maholo ko ngara-ngara ngeena, e aonga'i ta'au i laona kilipwe'u. ");
INSERT INTO apb_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Oto ko leesie e ro ensel kire to'oni rere'a na kire ii'o aana leu nge rae aana a Jisas e o'o'o aana ka'u, nga iini hatarie pwaulungana na ngaeta iini hatarie aali'aena. ");
INSERT INTO apb_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Oto kirerue ko si dolosi aana uuri, “?Keine, e ue ni o ko ngara-ngara?” A Meri e aalamirerue, oto ko te'uri, “Kire toolea oto aalaha ineu, na nou ka'a saie ike leu kire lai ne'ie aana.” ");
INSERT INTO apb_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Maholo a Meri e ere mango urine, ko si eeli'u na ko leesie a Jisas e uure oto i leune, ta'e e ka'a saie ike uri ingeie a Jisas. ");
INSERT INTO apb_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Oto a Jisas ko te'uri hunie, “?Keine, e ue ni o ko ngara-ngara? ?A tei ni o ko heitalea?” Oto aana a Meri e lo'onga'i uri ingeie mwane ko lio i sulie hohola ngeena nge kilipwe'u e ii'o i laona, nge ko si te'uri hunie, “Poro paine, mala uri o toolea rae aana, nge o ke unue oodoieu leu o lai ne'ie aana, hunie ne ke lai toolea.” ");
INSERT INTO apb_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Oto a Jisas e soie aana satana uuri, “!Meri!” A Meri e si eeli'u takoie na ko ere aana erenga mo Jiu uuri, “!Raboni!” (Lo'onga'inge aana uuri, “Ha'a-uusuli.”) ");
INSERT INTO apb_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Oto a Jisas ko si te'uri hunie a Meri, “Mwaanie o hele-hele aaku urine aana nou ka'a tahela'i ue i saana Aamaku. Ta'e saeku o ke lae i ha'arongoa mo pwaarongoisuli ineu uri no ko tahela'i i saana Aamaku na Aamamiu, na God ineu na God i'omu.” ");
INSERT INTO apb_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Oto a Meri e si lae, ko lai ha'arongoa mo pwaarongoisuli uri e leesie oto a Aalaha na ko ha'arongora aana mo ola a Jisas e unu'i hunie. ");
INSERT INTO apb_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Oto mola i seulehi aana eetana nga dinge i purine Dinge Maa'i Mo Jiu ngeena, mo pwaarongoisuli kire mani loko na kire hono honosire i nume, aana kire ko me'ute'inie mo na'ohai mwane mo Jiu. Kire ii'o mola i nume urine na a Jisas e si lae mai uure i matolada, na ko te'uri, “Hanuelamanga ke ii'o pe'i'omu.” ");
INSERT INTO apb_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","E ere urine mango, ko si haata'inie e ro ki'ine aada na papara'ana. Mo pwaarongoisuli ko tohungei ilenimwa'e oto liutaa aana kire leesie a Aalaha. ");
INSERT INTO apb_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Oto a Jisas ko he'i te'uri lo'u, “Hanuelamanga ke ii'o pe'i'omu. No ko uusunge'ini'omu oto wau mala a Mama'a e uusunge'inieu mei.” ");
INSERT INTO apb_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Maholo e ere urine, e si mango haahire na ko unue uuri, “Omu ke helesie a Li'oa Maa'i namiu, ");
INSERT INTO apb_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","na aana ingeie kei na'omiu, nge mala uri omu ko sae'aasi hunie mwala mo ooraha'aanga ikire, nge sae'aasileni ke si lae. Na mala uri omu ka'a sae'aasi'i hunire, nge sae'aasileni sa'a lae ike.” ");
INSERT INTO apb_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Ngaeta iini hikana aawalai pwaarongoisuli mwana rue, a Tomas, nge ingeie ngaeta iini aana e ro iu, e ka'a ii'o ike pe'ire aana maholo a Jisas e lae mai saada. ");
INSERT INTO apb_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Oto mo pwaarongoisuli nge a Jisas e haata'i aada kire ha'arongoa uuri, “!Melu leesie oto a Aalaha!” Ta'e a Tomas e unue mola hunire uuri, “Mala uri nou ka'a leesie ike talahuli'ana mo wara'o i laona ki'ine, wa ne ke ne'ie ri'i-ri'iku oto i talahuli'eni, wa ne ke ne'ie nimeku oto i laona malaka i papara'ana, nou sa'a roro'a ni hiiwalaimoli ike.” ");
INSERT INTO apb_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Oto wiki lo'u i puri, mo pwaarongoisuli a Jisas e he'i ruru lo'u i nume, na a Tomas no'one oto pe'ire. Mo maa kire hono ma'uta'a lo'u, ta'e a Jisas e lae mola mai nume na e uure oto i matolada, ko si te'uri, “Hanuelamanga ke ii'o pe'i'omu.” ");
INSERT INTO apb_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Na ko te'uri hunie a Tomas, “O ke to'omaaie mo ki'iku, na o ke ne'ie ri'i-ri'imu oto i laoni. Na o ke lae mai ne'ie nimemu i laona malaka i papara'aku. O ke su'uri ne'isae rue-rua'a ta'e o ke hiiwalaimoli mola.” ");
INSERT INTO apb_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Oto a Tomas e tolana aalamie a Jisas, na ko te'uri, “!I'oe oto Aalaha ineu, na God ineu!” ");
INSERT INTO apb_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Oto a Jisas ko si te'uri hunie, “I'oe, o hiiwalaimoli eeku mola aena aana o leesieu. Ta'e deidehie oto liutaa mo iini e ka'a leesieu, ta'e kire hiiwalaimoli.” ");
INSERT INTO apb_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","A Jisas e asuie mo hu'i-hu'ite oto hunge i maana mo pwaarongoisuli ingeie mala mo tolimaa uri ingeie Kalena God, ta'e uusuleni e ka'a lae ike i laona uusu-uusu ie. ");
INSERT INTO apb_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Mo iini ie uusuleni e lae mola uri hunie omu ke hiiwalaimoli aana a Jisas uri ingeie a Kraes, Kalena God, na hunie omu ke manata'inie maurihe huu aani hiiwalaimolinge aana. ");
INSERT INTO apb_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Ngaeta maholo lo'u i puri, a Jisas e haata'i lo'u maraana hunie mo pwaarongoisuli ingeie wau i reune Aasi I Kalili, na laladonga aana e lae uuri. ");
INSERT INTO apb_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","A Saemon Pita, na a Tomas (nge ingeie ngaeta iini aana e ro iu), na a Nataniel (iini e uure aana huilume i Kena aana po'o ni henue i Kalili), na e ro kalena Sebedi, na ngaeta ro pwaarongoisuli lo'u a Jisas, kire mani loko. ");
INSERT INTO apb_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Oto a Saemon Pita ko te'uri hunire, “Ne kei lae oto i weesi eena.” Oto kire ko unue hunie uuri, “Oo, kolu kei meni lae oto.” Oto kire mani lae oto aana iiola, ta'e aana hai rodona kire ka'a saunie ike nga ho ii'e. ");
INSERT INTO apb_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Maholo na sato ko pwaa oto aana e dangi ho'owa, a Jisas e uure hao i oone, ta'e mo pwaarongoisuli ka'a saie ike uri ingeie a Jisas. ");
INSERT INTO apb_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Oto ko dolosi aada uuri, “?E ue eena mo saanau, omu weesi taane?” Kire aalamie uuri, “!Ha'ike oto oo'oo!” ");
INSERT INTO apb_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Oto a Jisas ko unue hunire uuri, “Omu ke aatongie lo'u hu'o i'omu i eesi aana rau iiola i pwalo-pwalo na omu kei weesi oto.” Oto kire aatongie lo'u hu'o na kire ka'a saie oto uri kire kei we'i eeliho'i aana uri taa, aena aana e honu oto hiito'o aani ii'e. ");
INSERT INTO apb_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Oto pwaarongoisuli nge a Jisas e manata diana hunie ngeena, ko si te'uri hunie a Pita, “!A Aalaha ni otona!” Maholo a Pita e rongoa uri a Aalaha ni e uure hai oone ngeena, oto ko si tolana ho'osie lo'u to'oni tetewa e ta'aasie ka'u aana ko weesi, na ko pola oto i eesi huni oolo wau i saana. ");
INSERT INTO apb_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Iiola ikire ngeena e ka'a ha'ataulie ike i oone, ola mala lime aawalai tahanga mola. Oto mo pwaarongoisuli oana a Pita ngeena kire lae mai oone aana iiola i sulie, na kire ko we'inie oto hu'o e honu aani ii'e. ");
INSERT INTO apb_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Oto kire siho i oone na kire ko leesie dunge aani loilohi oto i leune, na ho ii'e i laona pe'ie nga ho bred. ");
INSERT INTO apb_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Oto a Jisas ko te'uri hunire, “Omu ke toolea mai nga mo ii'e aana mo ii'e omu si hu'o'i ngeena.” ");
INSERT INTO apb_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","A Pita e lae, ko si lai ta'e i laona iiola na ko we'inie mai hu'o e honu aani ii'e paine. Kire iidumie e tangalai ho ii'e pe'ie e lime aawala mwana oolu, na ma'alana kire hunge urine, ta'e hu'o e ka'a haka ike. ");
INSERT INTO apb_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Oto a Jisas ko si te'uri hunire, “Omu ke lae mai hunie ngaunge ni ho'owa.” Na nga ta'a-ta'a iini aana mo pwaarongoisuli ka'a ne'isae lo'u huni dolosi aana uuri, “?I'oe a tei?” aena aana kire saie mola uri ingeie oto a Aalaha. ");
INSERT INTO apb_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Oto a Jisas e lae mai da ho bred ngeena ko si ha'a-adora aana, na mo ii'e oto no'one urine. ");
INSERT INTO apb_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Ie oolune nga maholo a Jisas ko haata'i aana mo pwaarongoisuli ingeie i purine e ta'ela'i mwaanie maenga. ");
INSERT INTO apb_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Maholo kire ngau mango oto, nge a Jisas ko si te'uri hunie a Saemon Pita, “?Saemon, kalena Jon, uri o manata diana taane hunieu liutaa aana mo iini ie kire manata diana hunieu?” Oto a Pita e aalamie ko te'uri, “Iau, Poro paine, o saie ka'u oto uri nou manata diana huni'o.” Oto a Jisas ko si te'uri hunie, “O ke nii-nii ana mo kalei sipu ineu.” ");
INSERT INTO apb_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Oto a Jisas ko ruana dolosi lo'u aana a Pita uuri, “?Saemon, kalena Jon, uri o manata diana taane hunieu?” Oto a Pita ko aalamie uuri, “Iau, Poro paine. O saie ka'u oto uri nou manata diana huni'o.” A Jisas ko si te'uri hunie, “O ke lio i suli diana aana mo sipu ineu.” ");
INSERT INTO apb_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Oto oolune nga maholo a Jisas ko he'i unue lo'u hunie a Pita uuri, “?Saemon, kalena Jon, uri o manata diana taane hunieu?” Oto a Pita ko si saehuu oto hiito'o aana a Jisas ko dolosi ha'a-oolu oto aana uuri, “?O manata diana taane hunieu?” Oto e aalamie a Jisas, ko si te'uri, “Aalaha ineu, o manata'inie oto walu ola, na o saie ka'u oto uri nou manata diana huni'o.” A Jisas e aalamie oto ko si te'uri hunie, “O ke nii-nii ana mo sipu ineu. ");
INSERT INTO apb_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","No ko unue oto huni'o uri maholo o o'o'o saanau o ho'o-ho'o to'oni mola maraamu na o talei lae-lae oto mola i sulie saemu. Ta'e aana maholo o kei repo oto, nga mo iini aaopa oto kei ho'o haahi'o hunie o ke hii aaela, na kire kei toole'o aana leu o ka'a sare lae ike aana, na kire kei da o kei tahangaa e ro ki'imu.” ");
INSERT INTO apb_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","A Jisas e ere urine huni haata'inie uri kire kei horo maesie a Pita uri taa, na uri maenga ngeena kei tohungei ha'amanikulu'aa oto a God. Oto a Jisas e ere mango urine, ko si te'uri hunie, “O ke lulu i sulieu mola.” ");
INSERT INTO apb_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","A Pita e aali'u na ko leesie pwaarongoisuli nge a Jisas e manata diana hunie ko lae poi puridarue. Pwaarongoisuli ngeena oto iini e eno hatarie a Jisas aana maholo kire ngau tararuru na e dolosi aana uuri, “?Poro paine, a tei ni kei pwelo'o?” ");
INSERT INTO apb_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Maholo a Pita e leesie pwaarongoisuli ngeena, oto ko dolosi aana a Jisas uuri, “?Poro paine, oto a mwane ie kei ue?” ");
INSERT INTO apb_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","A Jisas e aalamie, oto ko te'uri, “?Mala uri no ko saeto'o aana uri ke o'o'o mola hule aana ne kei ooli lo'u mei, e ue o ko tolahi'e aana? I'oe, o ke lulu i sulieu.” ");
INSERT INTO apb_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Oto mei wala ko taro i matolana mo pwaarongoisuli a Jisas uri pwaarongoisuli ngeena e sa'a mae ike. Ta'e a Jisas e ka'a unue ike uri e sa'a mae, ta'e e unue mola uuri, “?Mala no ko saeto'o aana ke o'o'o mola hule aana ne kei ooli lo'u mei, e ue o ko tolahi'e aana?” ");
INSERT INTO apb_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Ineu oto pwaarongoisuli ngeena, na nou unu ha'a-oaie walu ola ienini na nou uusu'i oto ie. Na kie mani manata'inie uri nga taa nou unue e to'ohuu oto. ");
INSERT INTO apb_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Na mo ola hunge aaopa taane lo'u a Jisas e asui'i. Mala uri uusuleni ke lae mango laloi uusu-uusu, ha'alaa nou lo'onga'inie uri nga leu talana mo uusu-uusu ngeena ha'ike i laona ahutana walumalau. ");
INSERT INTO apb_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Huni'o Tiopilas: I laona eetana nga uusu-uusu ineu, nou unue oto huni'o ahutana mo ola nge a Jisas e asui'i na e ha'a-uusulie mwala aani, ");
INSERT INTO apb_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","lai hule oto aana hai dinge a God e tola aaliho'i aana lo'u ta'au i Lengi. Oto i na'ona e tahela'i eeliho'i ta'au i Lengi, e ere aana nanamanga aana Li'oa Maa'i na ko ha'ananaue mo iini e lio hilisire mala mo hurula'aa. ");
INSERT INTO apb_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","I laona hai aawalai hei dinge i purine a Jisas e mae, e haata'i lo'u aana mo hurula'aa mo maholo hunge. Aana mo tala hunge hai aaopa'i e haata'i diana aada uri e mauri eeliho'i to'ohuu, na aana mo maholona e ha'ananaure i sulie Aalahanga a God. ");
INSERT INTO apb_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Na ngaeta maholo a Jisas e ngau-ngeu pe'ie mo hurula'aa oto ko te'uri hunire, “Omu ke su'uri lae-lae mwaanie i Jerusalem, ta'e omu ke maa'oohie ka'u mei niinge nge a Mama'a e haiholota'inie huni'omu, oto mala nou unue ka'u no'one huni'omu. ");
INSERT INTO apb_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","A Jon e loto maa'i eemiu eeni wei, ta'e i purine lo'u nga mo hei dinge, a God kei loto maa'i eemiu oto aana Li'oa Maa'i.” ");
INSERT INTO apb_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Oto maholo kire mani loko ngeena, kire ko dodolosi aana a Jisas uuri, “?Aalaha, uri maholo e hule oto hunie o kei esuie Israel ke aalaha haahie ta'ena nga aalahanga ni welumalau?” ");
INSERT INTO apb_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Oto a Jisas e aalamire ko te'uri, “A Mama'a ni mola e to'o aana nanamanga huni oala'inie mo maholo urine. Oto e ka'a malisine ike uri omu ke saie mo maholona. ");
INSERT INTO apb_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Ta'e maholo Li'oa Maa'i kei siho oto mai haahi'omu, omu ke si honu aana nanamanga huni unu tahanga'inieu ta'au i Jerusalem, na ahutana mo leu i Jiudia, na oto aana po'o ni henue i Samaria, na ahusie oto ahutana walumalau.” ");
INSERT INTO apb_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Oto mola i purine a Jisas e ere mango urine, kire ko si leesie a Jisas ko tahela'i oto i Lengi aana a God ko toolea oto lae hule aana mei rorodo e mumunie oto mwaanie maada. ");
INSERT INTO apb_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Maholo kire ko lio-lio ue i sulie a Jisas ko tahela'i i Lengi ngeena, na e ro mwane kirerue to'oni aani to'oni rere'a ko tolana uure oto pe'ire. ");
INSERT INTO apb_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Na kirerue ko te'uri oto hunire, “!Mo mwane ni Kalili! ?Nga taa ni omu uure, omu ko lio-lio ue hunie ta'au i salo? A Jisas nge a God ko tola aaliho'i aana i Lengi mwaani'omu ngeena, kei ooli lo'u mei oto mala omu ko leesie ko lae i Lengi ngeena.” ");
INSERT INTO apb_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Oto puriha'ana, mo hurula'aa kire si eeliho'i hunie i Jerusalem mwaanie Uuwo Ni Ei Olif ngeena, aana e ka'a ha'atau ike, ola mala nga ta'a-ta'a kilomita mola. ");
INSERT INTO apb_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Maholo kire lai hule ta'au i Jerusalem, kire oodohie oto duru kire ko o'o'o i laona aana ruana nga sao-saohai nume. Na mo mwaena oto: a Pita, na a Jon, na a Jemes, na a Andru, na a Pilip, na a Tomas, na a Batolomiu, na a Matiu, na a Jemes kalena Alpeas, na a Saemon iini aana pulitaa nge ko sare haiseuni huni ta'aasie aalahanga ni Rom mwaanie hanue i Israel, na a Jiudas kalena Jemes. ");
INSERT INTO apb_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Ahutadaelu kire sai loko oto tarau pe'ie a Meri nikana a Jisas, na ngaeta mo hu'e lo'u, na mo mwane aasine a Jisas kire mani hute, hunie ahutada kire ke mani aarea God. ");
INSERT INTO apb_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Oto aana mo dingena, aana ngaeta maholo ola mala tangalai iinoni pe'ie nga ro aawala aana mo iini kire hiiwalaimoli kire mani loko. Oto a Pita e uure i lengi ko si te'uri, ");
INSERT INTO apb_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Maeni eesiku, mei wala nge Li'oa Maa'i e niie hunie a Deved Inemauri e unue oto mai i na'o i laona Uusu-uusu Maa'i e to'ohuu na ko oa oto, mala kolu ko meni leesie ngeena. Mei wala ngeena e lae i sulie a Jiudas, iini nge e na'ona mo ramo huni tapolie a Jisas, ");
INSERT INTO apb_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","ma'alana uri ingeie ngaeta iini taane no'one aana pulitaa ikolu hola'ina'o na e au'esu taane pe'ikolu.” ");
INSERT INTO apb_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","(A Jiudas ngeena e holie nga mei aano aana mei to'oha nge e hele aana mala nga waaite haahie mei ooraha'aa nge e asuiena. Oto e teke anie pwaune i aano i lengine mwakano ngeena, na oopwana e hoka na e dedera'i mango oto i sinaha. ");
INSERT INTO apb_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Oto ahutana mwala ta'au i Jerusalem kire rongoa tataroha i sulie leune, oto kire si haara'inie mei mwakano ngeena aana walada Akeldama, lo'onga'inge aana uri “Aano ni Epu.”) ");
INSERT INTO apb_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Na a Pita e unue no'one uuri, “Uusulana e lae i laona uusu-uusu aana mo Kana Maa'i uuri, Nume ingeie kei ne'i na'onga oto—toli'aasie nga iini ke su'uri ii'o lo'u aana. Na uusulana e lae no'one uuri, Nga iini aaopa ke oolisie mola aana lio i sulinge ingeie. ");
INSERT INTO apb_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","“Oto e malisine uri kolu ke lio hilisie oto nga iini huni unu ha'a-oaie pe'ikolu uri a Jisas Aalaha ikie e ta'ela'i to'ohuu oto mwaanie maenga. Na iini nge lio-hilisilana kei lae ngeena, nga iini oto aana mwala nge kire o'o'o pe'ikolu aana maholo a Jisas e walo-waloliu pe'ikolu, uure oto aana maholo a Jon e loto maa'i aana, lae hule aana maholo a God e tola aaliho'i aana Jisas mwaanikolu hunie i Lengi.” ");
INSERT INTO apb_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Oto kire lio hilisie e ro mwane, a Josep na a Mataeas. (A Josep kire ko haa-haara'inie aana a Basabas na a Jastas.) ");
INSERT INTO apb_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Oto puriha'ana, kire ko si aarenga'i uuri, “Aalaha, i'oe o saie mola ne'isaenga mo iinoni. O ke haata'inie mai aameelu iini uri taa aana e ro mwane ienini ni o lio hilisie ");
INSERT INTO apb_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","hunie ke ne'i hurula'aa oolisie a Jiudas, iini e toli'aasie oto mei ii'o-ii'oha paine ie, na e lae oto hunie leu aaela nge e malisine ke lae aana.” ");
INSERT INTO apb_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Oto kire ko si hehuto'o hunie aana ola mala inilana daes, na e haata'inie uri a Mataeas oto lio-hilisilana e lae. Na e ne'ie oto ngaeta hurula'aa aana aawala mwana rue ngeena. ");
INSERT INTO apb_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Oto e hule aana Houlaa Ni Pentekos e hiu wiki mola i purine a Jisas e tahela'i mwaanie maenga, na aana hai dinge ngeena mo hurula'aa kire mani ruru aana ta'a-ta'a leu i Jerusalem. ");
INSERT INTO apb_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Kire si apara'i na kou-kouha'ana ola e rongo mala paineha'ana mawasi dengi ko lae oto mai uure ta'au i Lengi na ko ha'ahonue oto nume paine kire ruru i laona. ");
INSERT INTO apb_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Na aana maholona kire ko leesie mo ola mala mo mela-melahai dunge ko eeso, na kire oopa hailiu na kire ko meni oa aada oto. ");
INSERT INTO apb_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Na ahutada kire ko meni honu oto aana Li'oa Maa'i, na kire ko aehota ere oto aana mo erenga hai aaopa'i i sulie mo erenga nge Li'oa Maa'i e nii'i mei hunire huni ere aani. ");
INSERT INTO apb_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Na mo iini hunge aana mo Jiu kire mani loko poi Jerusalem aana dinge maa'i peine ikire ngeena uure mwaanie mo po'o ni henue hai aaopa'i i laona walumalau aena aana kire ko tohungei sare paloa God. ");
INSERT INTO apb_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Maholo kire rongoa no'one aawa-aawatai ola ngeena, kire si meni loko huni leesie nga taa ko reu. Na ahutada kire ko tohungei pangata'i aana nga iini na e rorongo saie oto mo mwane ngeena ko ere aana erenga ingeie maraana. ");
INSERT INTO apb_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Kire ko tohungei pangata'i na kire ko teipu'o-pu'o mola i sulie nga taa ko reu. Oto kire ko te'uri, “!Ha'ike eena! Mo mwane nge kire ko ere-ere ngeena, mo mwane ni Kalili mola ni ngeena. ");
INSERT INTO apb_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","?Oto e ue ni kolu ko si rongoa mola kire ko ere aana mo erenga hai aaopa'i ikolu urine? ");
INSERT INTO apb_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Aana ikolu, kolu uure mola mwaanie mo henue mala i Patia na i Midia na i Elam na i Mesopotemia na i Jiudia na i Kapadosia na i Pontas na i Esia, ");
INSERT INTO apb_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","11","na i Frijia na i Pamfilia na i Ijip na i Libia kara'inie huilume paine i Saerin, na huilume paine i Rom, na i Krit na i Arabia. Na ngaeta mo iini aakaelu mo Jiu to'ohuu, na ngaeta mo iini aakaelu kire talama'inie mola tolahaka. !Ta'e ma'alana e urine, na kolu meni rongoa oto kire ko ere-ere aana mo erenga hai aaopa'i ikolu i sulie mo ola paine a God e asui'i!” ");
INSERT INTO apb_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Oto aena aana kire ko tohungei pangata'i na kire ka'a saie ike nga taa e rau, nge kire ko si dolosi heiliu aada uuri, “?Nga taa ni lo'onga'inge aana mei ola e rau ngeena?” ");
INSERT INTO apb_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Ta'e ngaeta mwala ko ha'a-eero mola aada, na kire ko te'uri, “Mo mwane ngeena kire ko mehiri mola ni ngeena.” ");
INSERT INTO apb_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Oto a Pita e uure i na'ona mwala pe'ie ngaeta aawalai hurula'aa mwana eeta, ko si soi peine hunie mwala kire loko ngeena na ko te'uri, “Maeni eesiku aana komu mo Jiu na oto ahutemiu nge omu ko ii'o mai Jerusalem aana maholo ie, omu ke pwaarongoa ka'u no ko ere luhesie mei ola e rau ie namiu. ");
INSERT INTO apb_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","?Uri omu ko lo'o-lo'onga'i uri melu ko mehiri? !Ha'ike! E si hule mola aana siwana nga maholoi sato aana aapa i ho'owa ka'u ie. ");
INSERT INTO apb_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Ta'e a Propet Joel e hola'i ere-ere lalai ka'u oto wau i na'o i sulie nga taa omu ko leesie ngeena. ");
INSERT INTO apb_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","A God e te'uri, ‘Aana mo dinge kara'inie ha'amangolana walumalau ienini, ne kei lingisie mai Li'oa ineu haahie ahutana mwala. Na mo kalemiu mwane na mo kalemiu keni, kire kei meni houle'inie walaku. Na ne kei niie mo haata'inge hunie mo saanau i'omu, na ne kei niie mo ma'ahu-polenga hunie mo repo i'omu. ");
INSERT INTO apb_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Iau, aana maholona, ne kei niie mai Li'oa ineu hunie ahutana mo mwane na mo keni eu'esu ineu, na kire kei houle'inie walaku. ");
INSERT INTO apb_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Na ne kei esuie mo hu'i-hu'ite ta'au i laona salo i lengi, na ne kei esuie mo tolimaa mai aano i leu. Dunge na pwa'ulana dunge kei hane, na apu kei aahe. ");
INSERT INTO apb_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Na sato kei ne'i rodohono oto, na waro-waro kei nonoro'a mala apu. Oto puriha'ana, nge hai dinge paine Aalaha ke si hule. Na hai dinge ngeena e roro'a oto liutaa na e manikulu'e. ");
INSERT INTO apb_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Na ta'ena nga iini ko aarenga'i aana satana Aalaha, nge ne ke si ha'a-uurie.’ ");
INSERT INTO apb_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","“!I'omu mo Israel, omu ke pwaarongo diana aana mo wala ienini! A Jisas ni Nasaret ngeena, a God e haata'i diana aana oto aamiu uri ingeie ni e uusunge'inie mai. Omu saie oto maraamiu uri a God ni e haata'inie mei olana aana mo hu'i-hu'ite na mo tolimaa a Jisas e asui'i i matolamiu. ");
INSERT INTO apb_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Na a God e lae oto i sulie oala'inge ingeie mala e lo'onga'inie uure oto mai na'o maholo e toli'aasie uri omu ke tapolie a Jisas hunie horo'ilana. Oto omu si niie i laona nimada mo pu'o, na kire horo maesie i lengine po'u-po'u. ");
INSERT INTO apb_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Ta'e a God e ta'ea mwaanie maenga hunie ke ii'o luheta'i mwaanie nanamanga aana maenga, i sulie e tohungei aasa hunie maenga kei hele ma'uta'a aana. ");
INSERT INTO apb_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Mo wala nge a Deved Inemauri e unu'i, kire si oa aana a Jisas. Aana a Deved e ere uuri i sulie, Nou leesie Aalaha e ii'o i na'oku mola tarau. Oto nou ka'a ma'u ike aana ta'ena nga maholo aana ingeie e rarauhe'i eeku. ");
INSERT INTO apb_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Oto aena mei olana, nge no ko tohungei ilenimwa'e oto liutaa, na walaku e haata'inie oto ilenimwa'enga ineu. Na ma'alana sapeku e sai mae taane, ta'e nou noruto'o mola aamu, ");
INSERT INTO apb_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","aena aana o sa'a toli'aasie ike mauriha'aku aana leu mwala kire mae oto, na o sa'a toli'aasie ike Iini Maa'i i'oe hunie ke kasu i laona kilipwe'u. ");
INSERT INTO apb_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","O haata'inie oto mo tala aana meurihe aaku, na o kei da ne kei tohungei ilenimwa'e aana maholo o kei ii'o pe'ieu. ");
INSERT INTO apb_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“Maeni eesiku, no ko sare unu oodo-oodo aana mola huni'omu i sulie a weuwaka a Deved Inemauri. E mae na kire haitolinge'inie oto, na kilipwe'u aana mola i saakaelu i leu hule si'iri. ");
INSERT INTO apb_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Ta'e aana a Deved ingeie nga propet, oto e saie mola uri a God e haiholota'inie hunie kei niie nga iini aana komu a Deved hunie ke inemauri mala a Deved maraana. Na iini nge kei lae mai urine kire haara'inie a Kraes. ");
INSERT INTO apb_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","A Deved e lio saie mone nga taa a God kei esuie mai puri. Oto e ere urine aena aana e saie uri a Kraes kei ta'ela'i eeliho'i lo'u mwaanie maenga. E unue uri a God e sa'a toli'aasie ike hunie ke ii'o mola aana leu mwala e mae oto, na e sa'a toli'aasie ike hunie sapena ke kasu i laona kilipwe'u. ");
INSERT INTO apb_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Na a Jisas oto a God e ta'ea hunie ke mauri eeliho'i mwaanie maenga, na melu tohungei leesie oto aana maameelu. ");
INSERT INTO apb_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","A God e tola aaliho'i aana hunie ke ii'o aana na'ohai ii'o-ii'oha, i pwalo-pwalona, na a God Aamana e niie Li'oa Maa'i hunie oto mala e haiholota'inie. Oto nga taa nge omu ko leesie na omu ko rongoa ngeena, mei ola a God e lingisie mai haahi'emeelu oto ni ngeena. ");
INSERT INTO apb_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Aana a Deved maraana e ka'a tahela'i ike hunie i Lengi, ta'e e unu tahanga'inie mola uuri, A God e ere hunie Aalaha ineu e te'uri ‘O ke ii'o ka'u mei i pwalo-pwaloku aana na'ohai ii'o-ii'oha, ");
INSERT INTO apb_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","lai hule aana ne kei kama haahie mo maelonga i'oe i aano hunie o ke uuri puli-pulisire.’ ");
INSERT INTO apb_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“Oto ahutemiu mwala ni Israel, omu ke saie uri a Jisas nge omu horo maesie i lengine po'u-po'u, a God e unue ingeie oto a Kraes nge e haiholota'inie, na ingeie oto kei aalaha haahikie.” ");
INSERT INTO apb_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Oto maholo mwala kire rongoa mei wala ngeena, kire ko si tohungei hii aaela oto hiito'o, na kire ko ere uuri hunie a Pita na mo hurula'aa, “?Maeni eesimemi, oto emi ke si ue eena?” ");
INSERT INTO apb_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Oto a Pita e aalamire ko te'uri, “Ahutemiu mango, omu ke oonisae mwaanie mo ooraha'aanga i'omu na omu ke loto maa'i aana satana a Jisas Kraes hunie a God ke si sae'aasie mo ooraha'aanga i'omu na ke niie mai Li'oa Maa'i huni'omu. ");
INSERT INTO apb_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Aena aana a God e haiholota'i urine oto huni'omu na hunie mo kalemiu na no'one hunire mo iini kire ii'o aana mo henue ha'atau, na ahutana oto mo iini a God Aalaha ikie e soire mai saana maraana.” ");
INSERT INTO apb_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Mo wala hunge a Pita e unu'i hunire na e ere hiito'o no'one hunire uuri, “Omu ke lio talamiu mwaanie ha'aloilemiu e lae mala kei lae hunie mo iinoni aaela aana maholo ienini.” ");
INSERT INTO apb_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Oto mo iini kire hiiwalaimoli aana walana Pita, kire si loto maa'i. Na aana hai dingena ola mala oolu sinolai iinoni nge kire sili lo'u mei pe'ire i laona soihaada'inge. ");
INSERT INTO apb_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Oto kire niie maraada hunie mo hurula'aa ke ha'a-uusulire, na kire mani ne'ie ta'a-ta'a mei sae pe'ie kira tei kire hiiwalaimoli aana a Jisas. Kire ko ngeu-ngeu ni lokonga aani aamasito'onga aana maelana Kraes, na kire ko ii'o oto mola pe'ie aarenga'inge. ");
INSERT INTO apb_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Ahutana mwala kire ko tohungei pangata'i na kire ko me'u, na kire ko ha'ama'u oto aana a God, aena aana mo hu'i-hu'ite na mo tolimaa oto hunge a God e asui'i aana nimana mo hurula'aa. ");
INSERT INTO apb_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Ahutana mo iini nge kire hiiwalaimoli aana a Jisas, kire ii'o mola pe'ie lokonga tararuru, na kire ko pe'ire hailiu aana to'o-to'olada. ");
INSERT INTO apb_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Na kire ko ha'a-ha'aholinge'inie to'o-to'olada, na kire ko nii-niie mo to'oha aani hunie ngaeta mo iini aada nge kire maitale. ");
INSERT INTO apb_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Kire ko loko tarau mola i suli dinge i laona Nume Maa'i Peine a God i Jerusalem. Na kire ko ngeu-ngeu tararuru i laona mo nume hai aaopa'i ikire, na kire sai ilenimwa'e tararuru aani pe'ilada hailiu mola aana mo ngeulaa ikire. ");
INSERT INTO apb_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Na kire ko lahea God mola tarau, oto mwala ko tohungei ne'isae paine aada. Na i suli hei dinge a Aalaha ko ha'a-uurie lo'u mo iini hunge mwaanie mo ooraha'aa ikire, na ko sapeire lo'u mei i laona pulitaa ikire ngeena. ");
INSERT INTO apb_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Ngaeta hai dinge a Pita na Jon kirerue ko lae ta'au i Nume Maa'i Peine a God aana maholo ni aarenga'inge aana oolune nga maholoi sato i aapai sato. ");
INSERT INTO apb_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Na ta'au i aena maa aana para honosie Nume Maa'i Peine ngeena, nga mwane ae'aena e rarasi oto uure i mwai-mweiha'ana e ii'o ta'au i leune, aana leu kire ko haa-haara'inie aana Maa Manikulu'e. Mo malahune kire sai toolea oto ta'au i leune urine i suli dinge hunie ke susuke to'oha mwaanie mwala ko lae-lae mai i Nume Maa'i. ");
INSERT INTO apb_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Oto maholo e leesie a Pita na Jon kirerue ko deu huni sili oto i laona Nume Maa'i, ko suke to'oha oto aadarue. ");
INSERT INTO apb_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Kirerue to'omaaie wau, oto a Pita ko te'uri, “O ke to'omaai'emerue ka'u.” ");
INSERT INTO apb_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Oto a mwaena ko to'omaairerue aana ko lo'onga'inie uri e ro mwane kei niie nga mei ola hunie. ");
INSERT INTO apb_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Ta'e a Pita e te'uri mola hunie, “Nou ka'a to'o aana ike nga mei to'oha, ta'e ngaeta mei ola mola nou to'o aana huni niie namue. No ko unue huni'o aana satana a Jisas Kraes ni Nasaret—Ta'ela'i na o ke lae hailiu oto.” ");
INSERT INTO apb_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Oto a Pita e hele aana ninime i pwalo-pwalona, ko si ta'ea i lengi. Na oto mola aana kele maholoi satona, e ro ae'aena a mwaena ko tolana a'aila'a oto. ");
INSERT INTO apb_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Oto e pola i lengi, na ko uure oto aana e ro ae'aena, na ko lae hailiu oto. Ko lae oto pe'ie a Pita na Jon ta'au i laona Nume Maa'i Peine, na ko lae pe'ie polanga hailiu oto na pe'i paalahelana God. ");
INSERT INTO apb_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Ahutana mwala kire leesie ko lae hailiu pe'i paalahelana God. ");
INSERT INTO apb_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Oto maholo kire lio saie uri ingeie ni mwane nge e rarasi ka'u na ko ii'o-ii'o i aena Maa Manikulu'e na ko susuke to'oha aada, kire ko si tohungei pangata'i na saeda e pu'o mola aana kire ka'a saie ike nga taa e rau aana a mwaena. ");
INSERT INTO apb_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","A mwaena mone ko hele-hele ue aana a Pita na a Jon ta'au i laona Nume Maa'i Peine aana lolata kire haara'inie “Leu Haa-haanaku a Solomon.” Ahutana mwala kire ko tohungei pangata'i oto hiito'o, oto kire ko si huru mei saadaelu. ");
INSERT INTO apb_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Oto maholo a Pita e leesie urine ko si te'uri hunire, “?Mo Israel, e ue ni omu ko tohungei pangata'inie mei ola ienini na omu ko lio hahuroto aamere'i? ?Uri omu ko ne'i-ne'isae uri mere asuie a mwane ienini hunie ke lae-lae lo'u aana nanamanga wa aana ii'onga maa'i i'emere'i maraamere'i? !Ha'ike oto oo'oo! ");
INSERT INTO apb_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","God mo weuwaka, iini a Ebraham na Aesak na Jekob kire mani palo-paloa oto waite, ingeie oto nge ko ha'amanikulu'aa koni-konihe ingeie a Jisas. Ta'e i'omu ni omu niie wau i nimana a Paelat hunie horo'ilana ma'alana a Paelat e sare toli'aasie hunie ke ii'o luheta'i, ta'e i'omu nge omu uure honosie mwaanie e toli'aasie. ");
INSERT INTO apb_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","A Jisas e tohungei maa'i na e oodota'i i maana a God, ta'e omu leledie mola. Na i'omu nge omu teangie a Paelat hunie ke luhesie a Barabas, mwane horo-horo. ");
INSERT INTO apb_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Nge ko urine, na huulaa ni meurihe nge omu horo maesie oto. Ta'e a God e ta'e aaliho'i aana lo'u mola mwaanie maenga, na i'emeelu oto melu tohungei leesie aana maameelu. ");
INSERT INTO apb_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Na nanamanga aana satana Jisas oto e ha'a-uurie mwane ienini nge omu ko meni lee-leesie e tewa oto na omu meni saie. Na aena aana mei hiiwalaimolinge aana a Jisas ngeena, nge ha'a-uurilana mwane ienini e lae aana oto mala omu ko leesie. ");
INSERT INTO apb_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Maeni eesiku, nou saie i'omu na mo na'ohai mwane i'omu, omu ka'a saie ike no'one nga taa nge omu esuie aana maholona. ");
INSERT INTO apb_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Ta'e a God e unue oto wau i na'o aana mo propet uri Kraes, Ha'a-uuri nge e haiholota'inie kei lae mai, kei sapesalu oto urine. Na a God e ha'a-oaie leune oto urine. ");
INSERT INTO apb_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Oto omu ke oonisae mwaanie mo ooraha'aanga i'omu, na omu ke lulu i sulie a God hunie ingeie ke si sae'aasi'i mwaani'omu. ");
INSERT INTO apb_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Mala uri omu kei te'urine, nge Aalaha ikie kei ha'a-a'aila'aa mauriha'amiu na kei uusunge'inie lo'u mei Kraes ngeena huni'omu, na ingeie oto a Jisas, iini nge a God e lio hilisie oto wau i na'o. ");
INSERT INTO apb_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Ingeie kei ii'o ka'u ta'au i Lengi hule aana maholo a God kei ha'ahaalue ahutana walu ola, mala e unue ka'u oto waite aana mo propet maa'i ingeie. ");
INSERT INTO apb_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Aana a Mosis e te'uri, A God Aalaha i'omu kei uusunge'inie nga propet nemiu oto mala e uusunge'inieu, na kei uure oto mwaani'omu maraamiu. Oto omu ke tola i sulie ta'ena nga mei ola ko unue huni'omu. ");
INSERT INTO apb_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Na ta'ena nga iini nge e ka'a tola i sulie propet ngeena, nge oopalana kei lae mwaanie mo iinoni a God, na horo'ilana kei lae. ");
INSERT INTO apb_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Aana ahutana mo propet nge kire unu-unue walana God, aehota oto aana a Samuel, kire mani unu lalai oto aana walu ola nge ko reu si'iri ie. ");
INSERT INTO apb_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Mo heiholota'inge nge a God e nii'i mei hunie mo propet, mo ola huni'omu ni ngeena mala mo heiholota'inge nge a God e nii'i mei hunie mo weuwemiu. Aana a God e te'uri hunie a Ebraham, Ha'adiana'anga kei uure mwaanie komu i'oe, nge ke si lae hunie ahutana mwala aana walumalau. ");
INSERT INTO apb_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Oto maholo a God e ha'a-uuresie koni-konihe ingeie a Jisas, nge e hola'i uusunge'inie huni'omu hunie ke niie ha'adiana'anga huni'omu aani tola aaliho'inilemiu mwaanie mo ooraha'aanga i'omu.” ");
INSERT INTO apb_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Maholo a Pita na Jon kirerue ko ere-ere ue nana mwala, na ngaeta mo pris pe'ie na'ohai mwane aana pulitaa ko kakakalie Nume Maa'i Peine, na ngaeta mo Sadiusi kire ko hule oto. ");
INSERT INTO apb_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Kire ko tohungei saewasulie e ro hurula'aa aana kirerue ko ha'a-uusulie mwala uri ta'ela'inge a Jisas mwaanie maenga e ha'awalaimoli'aa oto uri mo iini e mae kire kei haro mauri eeliho'i lo'u. ");
INSERT INTO apb_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Oto kire tapolirerue, kire ko ne'irerue i laona nume ni ho'o loosie i maahu'o-hu'o aena aana ko seulehi oto. ");
INSERT INTO apb_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Ta'e mo iini hunge nge kire rongoa walana e ro mwane, kire hiiwalaimoli oto aana. Na iidumilana mola mo mwane nge kire hiiwalaimoli aana a Jisas e lae hunie ola mala lime sinolai mwane. ");
INSERT INTO apb_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Oto e dangi ho'owa, na ahutana mo mwane aana pulitaa lei-lei mo Jiu nge kire ii'o i Jerusalem mala mo na'ohai mwane, na mo rato ni mwane, na mo ha'a-uusuli aana mo Ha'atolanga kire mani ruru oto. ");
INSERT INTO apb_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Kire loko pe'ie a Na'ohana Mo Na'ohai Pris, a Anas, na pe'ie ngaeta mo iini lo'u aana uluhe ingeie mala a Kaiapas na a Jon na a Aleksanda. ");
INSERT INTO apb_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Oto kire toolea e ro mwane kire si ha'a-uuresirerue i matolada na kire ko dolosi aadarue uuri, “?A tei ni e unue more ke asuie mei olana, wa aana nanamanga uri taa ni more asuie ngeena?” ");
INSERT INTO apb_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","A Pita mone e honu oto aana Li'oa Maa'i, e aalamire ko te'uri, “Mo aalaha ineu, i'omu mo iini nge omu ko na'ona mo Jiu na i'omu mo rato ni mwane. ");
INSERT INTO apb_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Omu ko dodolosi aamere'i i sulie mere aamasie mwane ae'aena e rarasi na omu ko sare saie mere ha'a-uurie a mwane ngeena uri taa. ");
INSERT INTO apb_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Oto no ko sare ha'arongo'omu na oto ahutana mwala ni Israel, uri mwane ienini nge e uure oto i na'omiu, ha'a-uurilana e lae mola aana satana a Jisas ni Nasaret na aana nanamanga ingeie. Na ingeie oto omu horo'ie i lengine po'u-po'u, ta'e a God e ta'ea lo'u hunie ke mauri eeliho'i. ");
INSERT INTO apb_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Na a Jisas oto iini nge mo Uusu-uusu Maa'i e ere i sulie aana e te'uri, Hau nge i'omu kira tou-tohu nume omu leledie ka'u, e ne'ie oto poo-pootana nume eena. ");
INSERT INTO apb_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Aana a Jisas mola e sai ha'a-uurikie mwaanie mo ooraha'aa ikie, aena aana a God e ka'a niie ike lo'u satana nga iini aaopa huni ha'a-uurikie.” ");
INSERT INTO apb_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Oto mo mwane aana pulitaa ni lei-lei ngeena kire ko si tohungei pangata'i aana kire leesie a Pita na Jon kirerue ka'a ma'u lo'u, ma'alana uri kirerue e ro mei iinoni reu mola na kirerue ka'a sukulu diana ike. Na i leune nge kire si lio saie uri ikirerue ni kire lae-lae tarau pe'ie a Jisas hola'ina'o. ");
INSERT INTO apb_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Na aana kire leesie mwane nge ha'a-uurilana e lae e uure pe'ie a Pita na Jon, oto e aasa hunie kire kei unue lo'u nga mei ola. ");
INSERT INTO apb_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Oto kire si unue e oolu mwaena kire ke iisitaa i sinaha mwaanire hunie kire ke ere-ere lo'u maraada i sulie leune. ");
INSERT INTO apb_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Oto kire ko te'uri, “!Mwae! ?Nga taa ni kolu kei esuie aana e ro mwane ngeena? Aana ahutana mwala i Jerusalem kire saie oto uri e ro mwane ngeena kire asuie mei hu'i-hu'ite oto paine, na e tohungei aasa hunie kolu kei unue uri e ka'a rau ike. ");
INSERT INTO apb_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Ta'e mwaanie nga mo iini hunge kire rongoa lo'u ha'a-uusulinge ngeena, nge kolu ke tohungei uure honosirerue na kolu ke ha'apasulirerue oto mwaanie kire ha'a-uusulie lo'u nga mwala aana satana Jisas.” ");
INSERT INTO apb_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Oto kire si unue kirerue ke lae lo'u mei, na kire ko tohungei uure honosirerue oto mwaanie kire unue lo'u nga mei wala wa kire ke ha'a-uusulie lo'u nga iini aana satana Jisas. ");
INSERT INTO apb_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Ta'e a Pita na Jon ko aalamire mola uuri, “Omu ke lo'o-lo'onga'i diana. ?Uri e diana mola i maana God huni heitohea walana na mere ke dau mola i sulie ne'isaenga i'omu? !Ha'ike oto oo'oo! ");
INSERT INTO apb_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Aana ienini mere sa'a rohu ike aani erenga i sulie nga taa mere leesie na mere rongoa oto maraamere'i.” ");
INSERT INTO apb_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Mo mwane paine aana pulitaa ni lei-lei kire ko ha'amau'orarue lo'u liutaa, ta'e lae-lae kire ko si he'i toli'aasirerue lo'u hunie kirerue ke lae. Aana e aasa hunie kire kei leirerue aana kire lio saie uri mwala ko lae pe'i lahea God oto haahie mei ola nge e raune. ");
INSERT INTO apb_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Na mwane nge mei tolimaa e rau aana ngeena e liue oto e hai aawalai helisi. ");
INSERT INTO apb_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Oto maholo kire toli'aasie a Pita na Jon hunie kire ke ii'o luheta'i, kirerue si lae i saana pulitaa kira hiiwalaimoli na kire ko ha'arongora oto aana mo ola nge mo na'ohai pris na mo rato ni mwane kire unu-unu'i hunirerue. ");
INSERT INTO apb_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Oto maholo ahutada kire rongo urine, kire ko si meni aarea a God uuri, “Hahu'ana Aalaha, i'oe oto o ha'aholaa salo na aano huu na aasi na ta'ena nga ola i laloni. ");
INSERT INTO apb_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","I'oe nge o da Li'oa Maa'i hunie a weuwameelu a Deved koni-konihe i'oe hunie ke unue walamu aana e te'uri, ?E ue ni mo Aapoloa Aaopa ko tohungei saewasu? ?E ue ni mwala ngeena ko oala'inie mo ola tata'ala? ");
INSERT INTO apb_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Mo inemauri aana walumalau ienini kire ko deu aakau huni heiseuni. Na mo na'ohai mwane aana walumalau kire ruru huni seunie a Iawe na a Ha'a-uuri nge e lio-hilisie. ");
INSERT INTO apb_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Na e to'ohuu oto, aana a Herod Antipas pe'ie mo Israel, na a Pontias Paelat pe'ie mo Aapoloa Aaopa kire mani esu loko-loko huni horo'ie a Jisas, koni-konihe maa'i i'oe nge o lio hilisie oto waite hunie ke ne'ie a Kraes. ");
INSERT INTO apb_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Kire loko urine nge kire hahu'ei deu oto mola i sulie ne'isaenga i'oe. Aana nanamanga i'oe nge o unue oto wau i na'o uri walu ola ienini kei reu. ");
INSERT INTO apb_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Na oto ie, Aalaha, o ke lio-lio diana aana mo na'ohai mwane nge kire ko ha'amau'o'emeelu ienini. O ke pe'i'emeelu, mo koni-konihe i'oe mwaanie melu me'u ni houle'inie walamu. ");
INSERT INTO apb_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Na o ke haata'inie nanamanga i'oe huni ha'a-uurie mo iini ko mweri, na huni esuie mo hu'i-hu'ite, na mo tolimaa aana satana Jisas koni-konihe maa'i i'oe.” ");
INSERT INTO apb_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Maholo kire aarenga'i mango, nge nume kire loko i laona ko si eenu-eenule'i heiliu, na kire si honu oto aana Li'oa Maa'i. Oto puriha'ana kire ko si tohungei a'aila'a lo'u liutaa ni houle'inie walana God. ");
INSERT INTO apb_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Oto ahutana mo iini kire hiiwalaimoli kire si meni ne'isae tararuru i sulie walu ola. Nga iini e ka'a lo'onga'inie ike uri mo ola e to'o aani uri mo ola oto ingeie maraana, ta'e mo ola nge nga iini e to'o aani mo ola ahutada mango. ");
INSERT INTO apb_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Na mo hurula'aa ko si houle'inie Aalaha ikie pe'ie nanamanga uri e mauri eeliho'i to'ohuu mwaanie maenga. Na a God e si ha'adiana'aa ahutana soihaada'inge. ");
INSERT INTO apb_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Oto nga iini aana pulitaa ikire ngeena e ka'a tola talea ike lo'u nga mei ola, aena aana mo iini nge kire to'o aana mo mei aano wa nga mo nume kire ha'aholinge'ini'i. Oto mei to'oha nge kire tarie ngeena kire si nii'i ");
INSERT INTO apb_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","hunie mo hurula'aa. Oto mo hurula'aa kire toolea mei to'oha ngeena, kire si ha'a-adoa kira maitale i laona soihaada'inge aana. ");
INSERT INTO apb_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Ngaeta mwane e nii urine oto a Josep, mwane aana komu a Livae nge e uure mai mwaanie mala-malau i Saepras. Mo hurula'aa ko haa-haara'inie aana a Banabas, lo'onga'inge aana uri “Kale ni Ha'asaedodo.” ");
INSERT INTO apb_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Ingeie e ha'aholinge'inie ngaeta mei aano ingeie, oto e toolea mei to'oha aana, e si lai mai niie hunie mo hurula'aa. ");
INSERT INTO apb_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Oto lae-lae ngaeta mwane satana a Ananaeas na hu'e ingeie satana a Sapaera, kirerue ko ha'aholinge'inie no'one ngaeta mei aano ikirerue. ");
INSERT INTO apb_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Ta'e kirerue mani ne'isae tararuru huni hele oorea ngaeta aapa aana mei to'oha ngeena. Oto a Ananaeas maraana e lae mai saana mo hurula'aa, na ko unue uri ko nii ta'ingelu oto aana mei to'oha hunire. ");
INSERT INTO apb_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Oto a Pita ko te'uri hunie a Ananaeas, “?Ananaeas, e ue ni o toli'aasie a Pwelu Eero-eero ke na'omu huni eeroa Li'oa Maa'i? Aana i'oe, o hele oorea ngaeta aapa aana mei to'oha nge o terie aana mei aano o ha'aholinge'inie. ");
INSERT INTO apb_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Maholo o ka'a ha'aholinge'inie ue mei aano ngeena, mei aano i'oe mola ni ngeena, na maholo o ha'aholinge'inie oto, ahutana mei to'oha mei ola oto i'oe. ?Oto e ue ni o si lo'onga'i huni eero lo'u urine? Aana o ka'a eeroa ike mola mo iinoni, ta'e o eeroa oto a God ni ngeena.” ");
INSERT INTO apb_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","A Ananaeas e rongo mola urine, e ladama'i hai aano na ko mae oto. Oto ahutana mwala kire rongoa leune kire ko si tohungei me'u oto liutaa. ");
INSERT INTO apb_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Oto mo saanau kire lae mai uloa sapena, kire toolea i sinaha, kire si lai heitolinge'inie. ");
INSERT INTO apb_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Na purine e oolu maholoi sato e mango, a Sapaera e lae lo'u mei i nume, ta'e e ka'a saie ike nga taa e rau aana poro ingeie. ");
INSERT INTO apb_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Oto a Pita ko dolosi aana ko te'uri, “?O ke unue ka'u, uri ahutana mei to'oha more tarie aana mei mwakano more ha'aholinge'inie ni oto ie?” A hu'ena e aalamie a Pita oto ko te'uri, “Iau, ahuteni oto ngeena.” ");
INSERT INTO apb_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Oto a Pita ko te'uri lo'u hunie, “?Oto e ue ni more ne'isae tararuru huni ha'angai-ngeie Li'oa Maa'i a God? !O ke rongo! Mo saanau nge kire lai heitolinge'inie poro i'oe, ikire oto ta'au i aena maa, na kire kei aanga'ini'o oto no'one ta'au urine.” ");
INSERT INTO apb_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Na oto mola aana kele maholoi satona a hu'ena e ladama'i hai aano na ko mae lo'u mola i na'ona Pita. Mo saanau kire sili mei nume, na kire ko leesie a hu'ena e mae oto no'one, oto kire aanga'inie, kire ko si lai heitolinge'inie lo'u i sulie poro ingeie. ");
INSERT INTO apb_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Ahutana mo iini aana soihaada'inge kire ko si tohungei me'u oto liutaa, na ahutana mo iini kire rongoa mei olana kire ko me'u oto no'one. ");
INSERT INTO apb_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Na kira hiiwalaimoli kire ko loko tararuru tarau i laona Nume Maa'i Peine aana lolata kire haara'inie “Leu Haa-haanaku a Solomon.” Mo hurula'aa kire ko esuie mo hu'i-hu'ite na mo tolimaa hunge i matolana mwala, ");
INSERT INTO apb_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","na ahutana mwala kire ko me'u ni uure pe'ire, ta'e kire ko lae-lahera mola. ");
INSERT INTO apb_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Na mo iini hunge aana mo mwane na mo keni kire lae pe'i hiiwalaimoli aana Aalaha. ");
INSERT INTO apb_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Oto aena aana mo hu'i-hu'ite hunge nge mo hurula'aa ko esui'i, nge mwala kire lae pe'i toolea mai mo mwei-mweria'a oto i sinaha, na kire ko lai ha'a-enosire i lengine mo tahe na mo ni'e i sulie tala. Aana ne'isaenga ikire uri maholo a Pita kei liu aana leune, ma'alana nunune ko liu mola haahie mo iini ko mweri ngeena na kire sai awaa lo'u. ");
INSERT INTO apb_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Na mwala hunge aana mo kele huilume kali-kelie i Jerusalem kire ko lae no'one mai, aana kire ko too-toolea mai mo iini ko mweri na mo iini mo li'oa aaela e ii'o aada. Oto ahutada mango ha'a-uurilada e si meni lae. ");
INSERT INTO apb_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Oto Na'ohana Mo Na'ohai Pris na pulitaa ingeie mo Sadiusi kire ko tohungei heota'inie mo hurula'aa aena aana mwala kire ko lulu i sulire oto. Oto mo Sadiusi kire ne'isae moute'i oto huni uure honosie mo hurula'aa. ");
INSERT INTO apb_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Oto kire lai tapolire, na kire si lai ne'ire i laona nume ni ho'o. ");
INSERT INTO apb_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Ta'e aana hai rodona, ensel a God e tahanie maa aana nume ni ho'o, e si na'oda i sinaha, oto ko si te'uri hunire, ");
INSERT INTO apb_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Omu ke lae wau i Nume Maa'i Peine, oto omu ko ha'arongoa mwala aana walu ola i sulie maurihe ienini.” ");
INSERT INTO apb_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Kire tola i sulie nga taa ensel e unue, oto e dangi ho'owa kire lae ta'au i Nume Maa'i Peine na kire ko aehota huni ha'a-uusulie oto mwala. Oto Na'ohana Mo Na'ohai Pris na mo mwane ko esu pe'ie, kire lokoa mo rato ni mwane aana pulitaa lei-lei huni loko. Oto maholo ahutada kire mani hule, kire si uusunge'inie ngaeta mo mwane wau i nume ni ho'o huni toolea mai mo hurula'aa i saana pulitaa lei-lei. ");
INSERT INTO apb_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Ta'e maholo mo ramo kire lai hule wau i nume ni ho'o, kire ka'a leesie ike lo'u mo hurula'aa. Oto kire aaliho'i, kire ko si te'uri hunie pulitaa ni lei-lei, ");
INSERT INTO apb_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Melu leesie mo maa aana nume ni ho'o kire hono ma'uta'a taane aani, na mo mwane kakakali kire ko kakalie taane mo maa. Ta'e maholo melu tahanie mo maa, melu ka'a leesie lo'u nga iini i laona nume ni ho'o.” ");
INSERT INTO apb_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Oto maholo na'ohana pulitaa kakakali aana Nume Maa'i Peine na mo na'ohai pris kire rongo urine kire ko si meni tohungei tolahi'e aana kire ka'a saie nga taa e rau aana mo hurula'aa. ");
INSERT INTO apb_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Ta'e ngaeta mwane e lae mai aana kele maholona oto ko te'uri hunire, “!Sei! Mo mwane nge omu ne'ire i laona nume ni ho'o, ikire mola ta'au kire uure, kire ko ha'a-uusulie mwala ta'au i laona Nume Maa'i Peine oto molana.” ");
INSERT INTO apb_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Oto na'ohana pulitaa kakakali na mo ramo ingeie, kire si lai tola aaliho'i aana mo hurula'aa. Ta'e kire ka'a dau ramo-ramo'a ike lo'u huni tapolire, aana kire ko me'ute'inie mwala mwaanie kire uu'i maesire aani heu. ");
INSERT INTO apb_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Mo mwane kakakali kire toolea mai mo hurula'aa, kire si ha'a-uuresire i na'ona pulitaa ni lei-lei. Oto Na'ohana Mo Na'ohai Pris e si ere aada uuri, ");
INSERT INTO apb_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Melu tohungei ere hiito'o oto huni'omu mwaanie omu ha'a-uusulie lo'u nga iini i sulie a mwane ngeena, ta'e omu ko da ha'a-uusulinge i'omu ko lae ahusie oto ta'ena nga leu i Jerusalem. Na omu ko ha'aroro'ai'emeelu aana omu ko unue uri i'emeelu nge melu horo maesie a mwane ngeena.” ");
INSERT INTO apb_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Oto a Pita e ere oalana mo hurula'aa e te'uri, “A God ni melu ko deu i sulie walana, mo iinoni ha'ike. ");
INSERT INTO apb_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Na i'omu nge omu horo'ie a Jisas aana omu uie i lengine po'u-po'u, ta'e God nge mo weuwaka i na'o kire palo-paloa nge e ta'ea lo'u mwaanie maenga. ");
INSERT INTO apb_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","A God e ta'ea na e ha'a-ii'osie aana na'ohai ii'o-ii'oha i pwalo-pwalona hunie ke aalaha haahikie, na hunie ke ha'a-uurikie, na hunie mwala ni Israel ke oonisae mwaanie mo ooraha'aanga ikire hunie a God ke sae'aasi'i mwaanire. ");
INSERT INTO apb_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Na melu leesie walu ola nge a God e asui'i ienini nge melu ko unu tahanga'ini'i huni'omu. Na e ka'a ike mola i'emeelu nge melu ko ere urine, ta'e a Li'oa Maa'i no'one, iini nge a God e niie hunie ahutana mo iini ko deu i sulie walana.” ");
INSERT INTO apb_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Oto maholo mwala aana pulitaa ni lei-lei kire rongoa mo wala a Pita e unu'i ngeena, kire ko si tohungei saewasu hule aana kire ko sare horo maesie oto mo hurula'aa. ");
INSERT INTO apb_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Ta'e ngaeta mwane aana pulitaa ni lei-lei satana a Kamaliel e uure i lengi huni ere. A mwane ngeena ingeie aana pulitaa mo Parise na ingeie ngaeta ha'a-uusuli no'one aana mo Ha'atolanga, na hule aana mwala kire tohungei ha'ama'u aana. E uure i lengi, oto e unue hunie mo mwane kakakali uri kire ke toolea mo hurula'aa i sinaha mola hunie nga kele maholo. ");
INSERT INTO apb_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Oto puriha'ana ko si te'uri hunie pulitaa ni lei-lei, “Mo mwane ni Israel, omu ke lo'onga'i diana ka'u i sulie nga taa nge omu ko sare asuie aana mo mwane ngeena. ");
INSERT INTO apb_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Omu saie oto aana mo helisi e mango, a Tiudas e unue uri ingeie ngaeta na'ohai mwane, oto lae-lae hai tangalai mwane ko lae lo'u mei pe'ie. Ta'e mae ni Rom kire horo'ie, oto mo mwane ingeie kire tatanga hailiu mola na hari-huninge ingeie e ka'a oa ike. ");
INSERT INTO apb_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Oto lae-lae, aana maholo ni uusu-satanga, a Jiudas mwane ni Kalili e uure, na mwala hunge kire lulu no'one i sulie. Ta'e kire horo'ie no'one. Oto mo mwane kire lulu i sulie ngeena kire tatanga hailiu lo'u mola. ");
INSERT INTO apb_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Oto aena mei olana, nge no ko unue huni'omu uri omu ke su'uri esuie lo'u nga mei ola aana mo mwane ienini, ta'e omu ke toli'aasire mola. Mala uri mo ola nge kire ko esui'i ngeena nga mo ola ni iinoni mola, e sa'a tewa na kire kei mango mola. ");
INSERT INTO apb_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Ta'e mala uri mo ola ngeena e uure mwaanie a God, nge e aasa hunie omu kei uure honosire. Oto omu ke si saie mola uri omu ko sare haliwala pe'ie a God.” ");
INSERT INTO apb_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Oto pulitaa ni lei-lei kire rongo hunie uri kire sa'a horo maesire ike aana maholona. Ta'e aana kire ko sae-saewasulie ue mo hurula'aa, kire si unue mo hurula'aa ke aaliho'i lo'u mei. Oto kire rapusire na kire ere hiito'o lo'u hunire uri kire ke su'uri unue lo'u nga mei wala i sulie a Jisas. Oto puriha'ana kire si toli'aasire. ");
INSERT INTO apb_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Mo hurula'aa kire lae mwaanie pulitaa ni lei-lei, kire ko tohungei ilenimwa'e oto liutaa, aena aana a Jisas e haata'inie uri kire ado taane huni sapesalu i tehula'ana satana. ");
INSERT INTO apb_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Na kire ko ha'a-uusulie mwala oto tarau i laona Nume Maa'i Peine na i laona mo nume ikire. Na kire ko lae pe'i houle'inie Tataroha Diana i sulie a Jisas uri ingeie a Kraes, a Ha'a-uuri nge a God e haiholota'inie hunie ke uusunge'inie mai welumalau. ");
INSERT INTO apb_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Aana maholona soihaada'inge ko peine lau-leu oto mola, oto kira hiiwalaimoli nge kire ko ere-ere mola aana erenga ni Krik, kire ko aehota upwesie mo iini nge kire sai ere aana tohungana erenga mo Jiu. Oto kire ko te'uri, “Suli dinge maholo omu ko ha'a-adoa kira maitale aana mo niinge kolu meni nii'i, omu ka'a tohungei pe'i-pe'i diana aana ike mo nao i'emeelu mala mo iini i'omu.” ");
INSERT INTO apb_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Oto aawalai hurula'aa mwana rue kire lokoa ahutana mwala aana soihaada'inge, kire ko si te'uri hunire, “E ka'a diana ike hunie melu ke toli'aasie houle'inilana walana God na melu ke lio mola i sulie to'oha na ngaulaa. ");
INSERT INTO apb_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Oto mo mwane, kei lae oto i diana liutaa hunie omu ke lio hilisie nga hiu mwane aamiu nge omu saie uri kire saenanau liutaa na kire honu aana Li'oa Maa'i hunie melu ke niie mei esunge ngeena hunire. ");
INSERT INTO apb_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Ta'e i'emeelu, melu kei ii'o mola pe'ie aarenga'inge na pe'i houle'inilana walana God.” ");
INSERT INTO apb_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Oto ahutana mwala kire rongoa mei wala ngeena kire ko si ilenimwa'e haahie. Oto kire si lio hilisie a Stivin, na a Pilip, na a Prokoras, na a Nikeno, na a Timon, na a Pamenas, na a Nikolas. Hiiwalaimolinge a Stivin ngeena e tohungei susu, na e honu aana Li'oa Maa'i. Na a Nikolas ngeena e hute aana mo Aapoloa Aaopa aana huilume i Antiok, ta'e e talama'inie tolahana mo Jiu na e ne'ie oto ngaeta iini aada. ");
INSERT INTO apb_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Oto kire ha'a-uuresie e hiu mwane ngeena i na'ona mo hurula'aa, na kire si hele i pweude pe'i aarenga'inge haahire. ");
INSERT INTO apb_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Oto walana God mone ko lae ahusie oto mo henue hunge, na mo pwaarongoisuli i Jerusalem kire ko hunge lo'u liutaa, na hungelana mo pris ko lulu i sulie oto a Jisas no'one. ");
INSERT INTO apb_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","A God mone ko ha'adiana'aa a Stivin na ko nii-niie nanamanga hunie, oto ko esuie mo hu'i-hu'ite na mo ola ni pangata'inge i matolana mwala. ");
INSERT INTO apb_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Ta'e ngaeta mo mwane ni Jiu kire ko leledie mola a Stivin. Mo mwane ngeena kire uure mwaanie mo huilume ha'atau i Saerin na i Aleksandria na e ro po'o ni henue i Silisia na i Esia. Na kire mani sai loko aana nume ni palo-palo mo Jiu nge kire haara'inie aana Nume Ni Palo-palo Mwala Kire Ii'o Luheta'i Lo'u. Oto mo mwane ngeena kire ko aehota ha'a-ere oto pe'ie a Stivin, ");
INSERT INTO apb_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","ta'e Li'oa Maa'i ko pe'ie a Stivin hunie erenga ingeie ke a'aila'a liutaa aana mo mwane ngeena. ");
INSERT INTO apb_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Oto lae-lae kire si lai waaie ngaeta mo mwane hunie kire ke eerota'inie a Stivin uuri, “Melu rongoa a mwane ie e ere mwakata'inie a Mosis na a God.” ");
INSERT INTO apb_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Oto aana kire ko ere urine, kire ko da ahutana mwala, na mo rato ni mwane aana mo Jiu, na mo ha'a-uusuli aana mo Ha'atolanga a Mosis, kire ko meni tohungei saewasulie a Stivin. Oto kire tapolie na kire ookea wau oto i na'ona pulitaa ni lei-lei. ");
INSERT INTO apb_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Oto mo mwane ngeena kire uure i lengi huni eero, na kire ko te'uri, “A mwane ngeena, ko ere-ere aaelasie Nume Maa'i Peine ikolu na ko ere-ere aaelasie mo Ha'atolanga a Mosis oto tarau. ");
INSERT INTO apb_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Na melu rongoa e unue uri a Jisas, mei ola ni Nasaret ngeena, kei ohoie Nume Maa'i Peine ikolu, na kei oolisie mo tolahai ola nge a Mosis e nii'i mei hunikie.” ");
INSERT INTO apb_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Oto aana maholona ahutana mwala nge kire loko ngeena, kire ko si lio hahuroto oto aana a Stivin aana kire ko si leesie maana e lio oto mala ensel. ");
INSERT INTO apb_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Oto a Na'ohana Mo Na'ohai Pris ko dolosi aana a Stivin ko te'uri, “?Uri mo wala ienini e to'ohuu wa ha'ike?” ");
INSERT INTO apb_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Oto a Stivin ko te'uri, “Maeni aamaku na maeni eesiku, omu ke pwaarongo ka'u. Maholo a weuwaka a Ebraham e ka'a lae ike ue hunie huilume i Haran, God ikie, iini e manikulu'e, e hola'i haata'i oto aana maholo e o'o'o aana po'o ni henue i Mesopotemia. ");
INSERT INTO apb_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Na e te'uri, O ke ho'ala'i mwaanie mwala i'oe na po'o ni henue i'oe na o kei lae hunie po'o ni henue nge ne kei haata'inie huni'o. ");
INSERT INTO apb_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Oto e ho'ala'i mwaanie mo Kaldia aana hanue ingeie ngeena, e si lai ii'o i Haran. Na purine aamana e mae, a God e si adaa lo'u mei hunie po'o ni henue i Kenan nge omu ii'o aana si'iri ngeena. ");
INSERT INTO apb_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Aana maholona, ma'alana nga kele mei aano na hule aana a God e ka'a niie ike ue nana a Ebraham. Ta'e a God e haiholota'inie uri kei haro to'o aana taane po'o ni henue ngeena aana nga dinge. Na ma'alana a Ebraham e ka'a to'o aana ue nga mwela aana maholona, ta'e a God e haiholota'inie uri mwala kei hute aana komu ingeie, ikire nge kire kei to'o aana po'o ni henue ngeena. ");
INSERT INTO apb_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Na a God ko te'uri hunie, Mwala kei hute aana komu i'oe, kire kei lai ii'o aana po'o ni henue mwala aaopa. Na mwala aana po'o ni henue ngeena kire kei deu rarahire huni esu mwaakule nada hunie ola mala hai tangalai helisi. ");
INSERT INTO apb_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Ta'e ne kei ha'aloie po'o ni henue nge kire ko te'urine aana komu i'oe. Oto puriha'ana nge komu i'oe kire ke si lae mai palo-paloau aana leu ienini. ");
INSERT INTO apb_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Oto a God e si unue hunie a Ebraham uri ke asuie torihesi'onga aana mo kalena mala nga tolimaa huni haata'inie uri a God e asuie haiholota'inge hunire. Aena urinena nge a Ebraham e asuie torihesi'onga aana a Aesak maholo wiki e ahu i purine e hute. Na a Aesak e asuie torihesi'onga lo'u aana a Jekob, na a Jekob e asuie lo'u torihesi'onga aana aawalai mwela mwana rue ingeie, na ikire oto aehotalana aawalai komu mwana rue ikie mo Jiu. ");
INSERT INTO apb_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Ta'e mo kalena a Jekob ngeena kire ko heota'inie aaside a Josep, oto kire ha'aholinge'inie mola hunie ngaeta mwala, na kire toolea oto hunie aalahanga i Ijip. Ta'e a God e ii'o susule'i mola pe'ie. ");
INSERT INTO apb_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","A God e pe'ie a Josep aana ahutana mo aasanga e hite aana, na e niie saenanaunge hunie, hunie inemauri ni Ijip ke saeto'o aana. Oto a inemauri e si ne'ie a Josep ke na'ohai mwane huni lio i sulie ahutana po'o ni henue a inemauri, na hule aana nume a inemauri no'one. ");
INSERT INTO apb_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","“Na lae-lae hiolonga paine e hite aana mo po'o ni henue i Ijip na lo'u i Kenan no'one. Na leune ko esuie aasanga hunie ahutana mwala, hule aana mo weuwaka no'one na kire ka'a to'o ngaulaa ada. ");
INSERT INTO apb_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Maholo a Jekob e rongoa uri mo Ijip kire to'o ngaulaa oto, e si uusunge'inie mo kalena, mo weuwaka, aana eetana nga laenga ikire. ");
INSERT INTO apb_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Aana ruana nga laenga ikire nge a Josep e si unu haada'i aana uri ingeie oto aaside to'ohuu. Na aana maholona, inemauri ni Ijip ko si saie no'one uri ikire mo eesine a Josep. ");
INSERT INTO apb_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Oto a Josep e si niie mei wala hunie aamana, a Jekob, uri ke lae mai Ijip pe'ie ahutana mwala aana uluhe ni iinoni ingeie. Na ahutada e hule aana hiu aawalai iinoni mwana lime. ");
INSERT INTO apb_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Oto a Jekob e lae, ko si lai ii'o i Ijip, na i leune a Jekob na mo weuwaka kire mani mae. ");
INSERT INTO apb_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Kire haro lai heitolinge'inire i Sekem aana po'o ni henue i Kenan aana mei aano nge a Ebraham e holie aana mei to'oha mwaanie komu a Hemo hunie mo kilipwe'u ingeie. ");
INSERT INTO apb_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Oto lae-lae aana ko kara'inie oto maholo a God kei deu i sulie haiholota'inge e unue hunie a Ebraham, nge mwala ikie ko tohungei hunge oto liutaa i Ijip. ");
INSERT INTO apb_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Na aana maholona ngaeta inemauri aaopa nge e ka'a saie ike a Josep ko aalaha haahie i Ijip. ");
INSERT INTO apb_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","E tohungei pweloa mo weuwaka aana e tohungei ha'amotaahire, na hule aana e dau rarahire oto hiito'o uri hunie kire ke ne'i aasie mo kele wee-wee ikire i sinaha hunie kire ke mae. ");
INSERT INTO apb_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Na aana maholona a Mosis e si hute, na e tohungei lio diana i maana a God. Na aamana na nikana kirerue ko lio i sulie mola i nume oto hunie e oolu waro-waro. ");
INSERT INTO apb_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Oto i sulie ha'atolanga mone, kire ne'i aasie mola wau i sinaha, oto toro ni Ijip ko si konie na e lio i sulie oto mala kalena. ");
INSERT INTO apb_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Na kire ko ha'a-uusulie oto aana saenanaunge ikire mwala ni Ijip na e ne'ie mwane nanama aana erenga na aana asunge no'one. ");
INSERT INTO apb_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Maholo a Mosis e hule aana hai aawalai helisi, ko si lo'onga'i ni lai kelie mwala ingeie mo Israel. ");
INSERT INTO apb_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Na aana maholona ko leesie ngaeta mwane ni Ijip ko tohungei horo aaelasie oto nga mwane ni Israel. Oto ko si pe'ie mwane ingeie ni Israel ngeena na ko horo maesie oto mwane ni Ijip. ");
INSERT INTO apb_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","A Mosis ko lo'onga'i uri mwala ingeie ni Israel kire kei lio saie uri a God e uusunge'inie huni luhesire oto mwaanie ii'onga ni ho'o, ta'e kire ka'a lio saie ike. ");
INSERT INTO apb_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Oto aana dinge i puri, a Mosis ko leesie lo'u e ro mwane ni Israel ko heiseuni. Oto ko sare oopararue, oto ko te'uri, ‘!Mwae! ?I'omore'i e ro mwane ni Israel mola ni ngeena, oto more ko heiseuni huni taa?’ ");
INSERT INTO apb_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","“Ta'e iini nge ko sare saunie ngaeta iini, e uusule'inie wau a Mosis, oto ko te'uri, ?A tei ni e lio hilisi'o hunie o ke aalaha haahi'emi na o ke lei'emi? ");
INSERT INTO apb_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","?Oto uri o ko sare horo maesieu lo'u mala o horo maesie mwane ni Ijip nonola? ");
INSERT INTO apb_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Maholo a Mosis e rongo urine, oto e taule'i ko tehi oto mwaanie i Ijip, na ko lai ii'o oto aana aalahanga i Midia. Oto lae-lae e tola hu'e na ko to'o aana e ro mwela. ");
INSERT INTO apb_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Oto purine e hai aawalai helisi e mango, ensel ko si haata'i aana a Mosis aana nga leu i laona hanuesala kara'inie toloi henue i Saenae. Ensel ngeena e haata'i mola i laona eeso-eesohai dunge nge e ii'o aana kele ai mwei-mwei ta'e e ka'a waruhie ike. ");
INSERT INTO apb_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Maholo a Mosis e leesie, oto ko tohungei pangata'i na ko lae oto wau kara'inie hunie ke lio diana aana. Na ko rongoa a Aalaha ko te'uri, ");
INSERT INTO apb_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","Ineu oto God mo weuwemiu, God a weuwe Ebraham na God a weuwe Aesak na God a weuwe Jekob nge kire ko palo-paloa. A Mosis ko tohungei eriri na ko me'u ni lio lo'u weu hunie dunge. ");
INSERT INTO apb_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Oto a Aalaha ko te'uri hunie a Mosis, O ke ta'aasie mo ho'ohaahi'ae i'oe, sulie leu o uure aana ngeena leu maa'i ni ngeena. ");
INSERT INTO apb_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Oto o ke rongo ka'u. Nou leesie oto mwala ineu wau i Ijip ko tohungei sapesalu hiito'o. Na nou lae oto mai aano huni luhesire mwaanie ii'onga ni ho'o, aana nou rongoa ngaranga ikire haahie sapesalunge ngeena. Oto no ko uusunge'i eeliho'i eemu, na o ke lae oto molana hunie i Ijip. ");
INSERT INTO apb_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“Mwala ni Israel kire tohungei leledie a Mosis, hule aana kire te'uri hunie, ?A tei ni e lio hilisi'o hunie o ke aalaha haahi'emi na o ke lei'emi? Ta'e ingeie oto nge a God e uusunge'inie hunie ke aalaha nada na hunie ke ha'a-uurire, na a Mosis e si saie mola urine e to'ohuu aana maholo ensel e haata'i aana i laona melahai dunge nge e ka'a waruhie ike kele ai mwei-mwei ngeena. ");
INSERT INTO apb_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Oto a Mosis e asuie mo hu'i-hu'ite na mo ola ni pangata'inge huni na'ona mwala huni lae mwaanie i Ijip, na holosie Aasi Nonoro'a, na i laona hanuesala hunie hai aawalai helisi. ");
INSERT INTO apb_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Na a Mosis maraana nge e te'uri hunie mwala ni Israel, A God kei lio hilisie nga iini eemiu hunie kei ne'i propet mala ineu. ");
INSERT INTO apb_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Ingeie oto e o'o'o pe'ie mwala a God i laona hanuesala. Na ingeie oto e ha'a-ha'arongoa mo weuwaka, aana walu ola nge ensel e unu'i hunie i lengine toloi henue i Saenae. Na e rongoa mei wala ni meurihe a God, oto e niie mai hunikie. ");
INSERT INTO apb_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Ta'e mo weuwaka ka'a sare rongo ike hunie a Mosis. Kire ko leledie mola, na saeda kire ke aaliho'i lo'u mola hunie i Ijip. ");
INSERT INTO apb_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Oto kire ko te'uri hunie a Eron, O ke asuie nga mo god hunie kire ke na'o-na'o naka. Aana kie ka'a saie oto nga taa e rau aana a ola, a Mosis, nge e toolekie mai mwaanie i Ijip. ");
INSERT INTO apb_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Oto kire asu ha'amalaa oto kalei puluke, na kire ko esuie oto uunu-olanga hunie. Na kire ko esuie oto ngauhe ni ilenimwa'enga hunie nunui ola nge kire asuie mola aana ki'ide. ");
INSERT INTO apb_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Oto a God e si aatopuri aada, na e toli'aasire hunie kire ke palo-paloa sato, na waro-waro, na mo hee'u ta'au i salo. Aana e unue oto i laona apai uusu-uusu mo propet aana Uusu-uusu Maa'i uuri, I'omu mo Israel, i laona hai aawalai helisi nge omu ii'o i laona hanuesala omu horo'ie taane mo ola mauri huni uunu ola aani. ?Ta'e uri mo ola ngeena omu esui'i taane huni ha'apaina'aau? ");
INSERT INTO apb_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","!Ha'ike oto oo'oo! Ta'e omu ha'a-ha'apaina'aa mola mo pweai god Molok na a Repan. Omu eedumie mo nunui ola aani, na omu toolea mo nume susulu haahi'i, na omu palo-palo'i aana tolahai ola e tohungei aaela. Aena mei olana, nge ne kei uusunge'ini'omu ha'atau lo'u liue i Babilon. ");
INSERT INTO apb_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“Maholo mo weuwaka kire o'o'o ue i laona hanuesala, kire aanga-aanga'i heiliu mola aana nume maa'i susulu a God. Na kire asuie nume maa'i susulu ngeena oto mala a God e unue hunie a Mosis, na e lae oto i sulie nunui ola nge a Mosis e leesie. ");
INSERT INTO apb_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Oto lae-lae, a Josua na mo weuwaka kire toolea oto mai nume maa'i susulu maholo kire laue po'o ni henue ienini mwaanie mo Aapoloa Aaopa, nge a God e oohe aasire mwaanie leune. Na e o'o'o i leu hule aana pongine a Deved Inemauri. ");
INSERT INTO apb_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","A God ko tohungei ilenimwa'e haahie a Deved, oto a Deved e ha'atohu aana a God hunie ke toli'aasie ke asuie nga nume maa'i nana God ikie mo Israel hunie ke ii'o aana. ");
INSERT INTO apb_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Ta'e ma'alana e urine, a Deved e ka'a asuie ike nume maa'i, ta'e a Solomon, kalena a Deved, nge e si esuie nume nana. ");
INSERT INTO apb_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“Ta'e Iini i Lengi oto Liutaa e ka'a sai ii'o ike i laona nume mo iinoni ko esuie. Ngaeta propet ko ere i sulie leune uuri, ");
INSERT INTO apb_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","A Aalaha e te'uri ‘I Lengi oto naunekume a inemauri nge nou ii'o aana ie, na walumalau oto leu huni ne'ie ae'aeku. ?Oto nga nume uri taa omu kei esuie nakue? ?Na omu kei esuie leu ni mamalo ineu i tei? ");
INSERT INTO apb_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Aana ineu oto nou esuie walu ola aana nimeku.’ ");
INSERT INTO apb_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","“!Ha'ike eena! I'omu si'irini, omu tohungei sada mola mala mo pu'o na omu ka'a sare tola ike i sulie walana God. Suli maholo omu ko leledie mola Li'oa Maa'i mala mo weuwemiu oto i na'o. ");
INSERT INTO apb_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","?Maholo mo weuwemiu kire ha'aloie mo propet oto wau i na'o, uri kire liue nga iini aada? !Ha'ike! Ta'e kire ha'aloie ahutada mango, hule aana kire horo'ie mo iini nge kire ko laenga'inie laenga mai koni-konihe oodota'i a God. Na hule aana ingeie maraana, i'omu oto omu pweloa na omu horo maesie. ");
INSERT INTO apb_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","!Omu tohungei lae takalo! A God e uusunge'inie mai mo ensel huni toolea mai mo Ha'atolanga ingeie huni'omu, ta'e omu ka'a sare tola i suli'i.” ");
INSERT INTO apb_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Oto maholo mwala aana pulitaa ni lei-lei kire rongoa a Stivin ko ere urine, saeda ko si tohungei mela oto mala dunge aana kire ko saewasu. ");
INSERT INTO apb_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Ta'e a Stivin mone e honu aana Li'oa Maa'i, e lio ta'au i Lengi na ko leesie manikuluha'ana God na ko leesie a Jisas e uure aana leu ni nanamanga i pwalo-pwalona God. ");
INSERT INTO apb_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Oto a Stivin ko te'uri, “!Lio ka'u! Nou leesie i Lengi e taha, na a Kale Ni Iinoni e uure aana leu ni nanamanga i pwalo-pwalona God.” ");
INSERT INTO apb_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Oto mwala aana pulitaa ni lei-lei kire ponosie aalingada, na kire ko tea oto paine. Oto kire si meni huru oto wau huni tapolie a Stivin, ");
INSERT INTO apb_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","na kire ko we'i ookea oto mwaanie huilume, na kire ko aehota huni uu'i maesie oto aani heu. Oto mo iini nge kire ko heliwala pe'ie a Stivin kire si ha'a-oorea mo to'oni tetewa ikire i saana mwane satana a Sol hunie ke lio i suli'i. ");
INSERT INTO apb_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Na maholo kire ko uu'i-uu'ie ue a Stivin aani heu, a Stivin ko si soi peine hunie Aalaha, ko te'uri, “Jisas, Aalaha ineu, o ke tola konie mangoku.” ");
INSERT INTO apb_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Oto e pouruuru hai aano ko si soi peine, ko te'uri, “Aalaha, o ke su'uri su'ue lo'u mei ooraha'aanga ienini hunire.” E ere urine mola, na ko mae oto. ");
INSERT INTO apb_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","2","Ngaeta mo iini nge kire ko aare-aarea God to'ohuu, kire ko si lai heitolinge'inie a Stivin pe'ie saehuunge na ngaranga, ta'e a Sol ko ilenimwa'e mola haahie horo'ilana. Aehota oto aana hai dinge a Stivin e mae, ahutana mwala ko tohungei waelie na kire ko horo'ie oto mo iini aana soihaada'inge i Jerusalem. Na ahutana mo iini kire hiiwalaimoli aana Jisas, kire tahi oto takoie mo huilume mwai-mwei aana mo po'o ni henue i Jiudia na i Samaria, ta'e mo hurula'aa mola nge kire oore i Jerusalem. ");
INSERT INTO apb_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Ta'e a Sol ko tohungei deu aahonga huni horo'ie mo iini aana soihaada'inge, oto ko si silihie ahutana mo nume huni tapolie mo mwane na mo keni nge kire hiiwalaimoli huni lai ne'ire i laona nume ni ho'o. ");
INSERT INTO apb_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Oto mwala nge kire tahi mwaanie i Jerusalem, kire si lae pe'ie houle'inilana walana God aana ahutana mo leu kire ko lae aani. ");
INSERT INTO apb_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Na a Pilip e lae no'one hao aana ngaeta huilume i Samaria huni taroha'inie a Kraes hunie mwala. ");
INSERT INTO apb_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Na maholo kire rongoa walana a Pilip, na kire leesie mo hu'i-hu'ite e dau'i, oto kire ko si tohungei sare pwaarongo hunie. ");
INSERT INTO apb_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Na mo iini nge mo li'oa aaela e ii'o i lalo aada, mo li'oa ngeena kire ko soi peine na kire ko iisitaa oto mwaanire. Na mo iini ae'aeda e rarasi na mo iini e to'u, ha'a-uurilada e lae no'one. ");
INSERT INTO apb_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Oto mwala oto hunge aana huilume paine ngeena kire ko tohungei ilenimwa'e. ");
INSERT INTO apb_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Na aana huilume ngeena ngaeta maato'o satana a Saemon e ii'o no'one i leune. Na a mwane ngeena ko esuie mwala i Samaria ke pangata'inie nanamanga ni si'onga ingeie. Na ko ere tooha'inie uri ingeie oto ngaeta mwane paine, ");
INSERT INTO apb_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","na ahutana mo rato na mo iinoni reu aana huilume kire ko pwaarongo hunie oto. Na kire ko te'uri, “Ingeie oto Iini Peine, aana ingeie oto nanamanga a God.” ");
INSERT INTO apb_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Na kire ko lulu i sulie oto, aena aana ko esuie mwala ko pangata'inie nanamanga ingeie ko tewa oto mai. ");
I