﻿USE sofia;
DROP TABLE IF EXISTS sofia.aom_vpl;
CREATE TABLE aom_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES aom_vpl WRITE;
INSERT INTO aom_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Aveho Iesu Keriso-are hijo mionoꞌo jiobe rovade jöhoje. Iesu hu David-are uje jiadeje. David hu Abraham-are uje jiadeje. ");
INSERT INTO aom_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham hu Isaac-are vavue jiadeje. Isaac hu Jacob-are vavue jiadeje. Jacob hu Judah-are o Judah-are ö ömoꞌömo jabesi vavue jiadeje. ");
INSERT INTO aom_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Judah hu Perez o Zerah-mesi vavue jiadeje. Jabesi vëmoho Tamar jiadeje. Röhu Perez hu Hezron-are vavue jiadeje. Hezron hu Ram-are vavue jiadeje. ");
INSERT INTO aom_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ram hu Amminadab-are vavue jiadeje. Amminadab hu Nahshon-are vavue jiadeje. Nahshon hu Salmon-are vavue jiadeje. ");
INSERT INTO aom_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmon hu Boaz-are vavue jiadeje. Boaz-are vëmoho Rahab jiadeje. Röhu Boaz hu Obed-are vavue jiadeje. Obed-are vëmoho Ruth jiadeje. Röhu Obed hu Jesse-are vavue jiadeje. ");
INSERT INTO aom_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Jesse hu a böröme David-are vavue jiadeje. David hu Solomon-are vavue jiadeje. Solomon-are vëmoho Uriah-are dorue jiadeje. ");
INSERT INTO aom_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Röhu Solomon hu Rehoboam-are vavue jiadeje. Rehoboam hu Abijah-are vavue jiadeje. Abijah hu Asa-are vavue jiadeje. ");
INSERT INTO aom_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa hu Jehoshaphat-are vavue jiadeje. Jehoshaphat hu Joram-are vavue jiadeje. Joram hu Uzziah-are vavue jiadeje. ");
INSERT INTO aom_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uzziah hu Jotham-are vavue jiadeje. Jotham hu Ahaz-are vavue jiadeje. Ahaz hu Hezekiah-are vavue jiadeje. ");
INSERT INTO aom_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hezekiah hu Manasseh-are vavue jiadeje. Manasseh hu Amon-are vavue jiadeje. Amon hu Josiah-are vavue jiadeje. ");
INSERT INTO aom_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josiah hu Jechoniah-are o hesi ö ömoꞌömo jabesi vavue jiadeje. Evare majare Babylon rajohuro muorovoꞌi rueromo Israel rajoho tövëvoromo ujuoho vaꞌoromo Babylon rëmareje. ");
INSERT INTO aom_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Tövëvo ujuoho vaꞌoromo Babylon rëmare maja hesi ijore evare Jechoniah hu Shealtiel-are vavue jiadeje. Shealtiel hu Zerubbabel-are vavue jiadeje. ");
INSERT INTO aom_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zerubbabel hu Abiud-are vavue jiadeje. Abiud hu Eliakim-are vavue jiadeje. Eliakim hu Azor-are vavue jiadeje. ");
INSERT INTO aom_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azor hu Zadok-are vavue jiadeje. Zadok hu Achim-are vavue jiadeje. Achim hu Eliud-are vavue jiadeje. ");
INSERT INTO aom_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliud hu Eleazar-are vavue jiadeje. Eleazar hu Matthan-are vavue jiadeje. Matthan hu Jacob-are vavue jiadeje. ");
INSERT INTO aom_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jacob hu Joseph-are vavue jiadeje. Joseph hu Mary-are barue jiadeje. Mary hu Iesuare vëme jiadeje. Iesuare jöho uvarueje: Böröme namiromo ajamuaje aho höjo. ");
INSERT INTO aom_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Iesuare hijo mionoꞌoho ëhi jiobe rovadeje. Abraham bëhoho jioromo hesi ujo ömoꞌömo jiobe rovadoho ro David-arire ë vituoho jioromo bëhohuꞌo ujohuꞌo ahoꞌobëhe 14 jiadeje. O David bëhoho jioromo hesi ujo ömoꞌömo jiobe rovadoho ro Israel rajo tövëvoromo Babylon ujuoho vaꞌare majare ë vituoho jioromo bëhohuꞌo ujohuꞌo ahoꞌobëhe 14 jiadeje. O Israel rajo tövëvoromo ujuoho vaꞌare majare jioromo ujo ömoꞌömo jiobe ruejuvo böröme namiromo ajamuaje a rahade majare ë vituoho jioromo ujoho ahoꞌobëhe 14 jiadeje. ");
INSERT INTO aom_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Röhu Iesu Keriso rahadoho aviëhije. Hesi vëme Maryꞌo Josephꞌo masurovoꞌiröhëro uarovoromo arijareje. Bogo masurovoromo gemuoroho arijëꞌe Mary-ro gavadeje God-are Aruꞌahohuro uje bojamijëꞌëro hu dëꞌe jiamu. ");
INSERT INTO aom_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Hesi aemoꞌaeme Joseph-ro gavade hu dëꞌe jiamu gagorovo jögoru ejaje aëro jiëꞌëro Mary nugöꞌöꞌi uehorovadeje. Röhu Mary a nunire javoji bojamiꞌiröhoho bijönimamu uvadeje: Iae na saginiëri ëhi ëꞌejöjo. ");
INSERT INTO aom_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Ëhi uehorovojuvo niaꞌovoro gavadeje Badare aneraëro rueromo uavavamu: David-are hije Joseph jaehu Mary masuꞌiranoho nadi juhuonivonëjo. Ëhesi bëhoho bogo aho ujoho bojamiꞌi hesi God-are Aruꞌahëro bojamamu dëꞌiraejëꞌe höjo. ");
INSERT INTO aom_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Harihoho rahego hesi ihoho Iesu jumuvonëjo rabëni huro hesi aribövi jabesi sisëho muꞌuvëhoromo maro rëmoꞌiëꞌe jiaje. ");
INSERT INTO aom_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Röhu ë mue ahoꞌo rovade hesi bëhoho ëhuro Badahu hesi jö majëhijaje a uavamu jajivadëhi ëhi jioröhego. ");
INSERT INTO aom_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Jajivoromo ëhi uvadeje: Aboridohuro dëꞌiraeromo harihe rahoꞌaꞌajëjo. Rahoꞌiramu aëro hesi ihoho Emmanuel jumuvoꞌaruëjo. Emmanuel ë iho hesi bëhoho God-hu noꞌo jiaje jöhoje. ");
INSERT INTO aom_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Amo Joseph-ro niavëꞌëro riꞌöromo Badare anera hesi jöho ejahoromo hesi magonahoho masuvadeje. ");
INSERT INTO aom_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Masuromo röhu bogo huꞌoho gemuoroho niavadeje uꞌemu harihoho rahego niavoꞌiröhëro. Amo harihoho rahamu Iesu jumuvadeje. ");
INSERT INTO aom_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Iae Iesu Bethlehem amore Judea saꞌare ë rahadeje Herod saꞌa a böröme jiadevare. Rahamu iae jiji adahoꞌamarue a masijohuro aruhe saꞌa göre jioromo rovaroho ro Jerusalem amore suorovareje. ");
INSERT INTO aom_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Suorovoromo uëvareje: Jew rajo jemesi saꞌa a böröme jioröhego rahade aharihoho dinöꞌe höjo. No aruhe saꞌa göre raromoromo gavare hesi jijoho rojomamu garomo hu rajahiꞌi rovare höjo. ");
INSERT INTO aom_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Ëjöho heromo Herod saꞌa a börömohuro dë sisërëromo uehore gö gö baejadeje Jerusalem amo rajo a ioroꞌiorohuꞌo. ");
INSERT INTO aom_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Uehore gö gö baeromo huro Jew rajo priest masijohuꞌo jabesi jögoru öri röjëhijarue ariböviohuꞌo uëvamu gemuoro gagovoruomadeje. Gagovamu uëvadeje: Böröme namiromo ajëmiꞌiröhe aho hu dinöꞌe rahoꞌaꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Uavareje: Bethlehem amore Judea saꞌare ë rahoꞌaꞌajëjo. Mamiꞌe jö God-aro baeromo majëhinövade ahuro ëhi jajivoromo uvëꞌe höjo: ");
INSERT INTO aom_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Bethlehem ja Judea saꞌare javajoho Judea saꞌare a masijo jabesi nuniroho jasi ihoho bogo biseꞌoho jioꞌaꞌajëjo. Jasirire jioromo a böröme rueꞌaꞌajëjo. Rueromo nasi aribövie Israel rajoho muebejëvoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Ëhi majahijamu hegorovo Herod-ro ë saꞌa gö rajo a masijohuro ruejöro saginiëri jöe nugöꞌöromo uëvadeje: Ëjijoho maja raburo aevoromo rojomamu gavarije höjo. Nadi ruëroho numëroho ueꞌi majaho ma-gemu uevego na hejöjo. ");
INSERT INTO aom_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Majaho uavamu henugoromo uëvadeje: Rue Bethlehem amoro vaꞌirarijoho aharihoho avoho nahobe jijihorëjo. Birohogoro rueromo dinöꞌe jiajoho uerego na heꞌiröjo naꞌo ë vaꞌoromo hu rajahiꞌirode. ");
INSERT INTO aom_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Ëhi uëvamu hegoro vaꞌareje. Örire vaꞌihö gavareje mamiꞌe ruhe saꞌa göre gavare jije gemuoho jabesi nuninö urimo vaꞌamu. Jijohuro urimo vaꞌadoho vaꞌo aharihehu hijajire ë hesi simano bure namijadeje. ");
INSERT INTO aom_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Namijamu ganugoromo bogo biseꞌo vaduꞌoho nimorohareje. ");
INSERT INTO aom_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Nimorohoromo ë osare rumo vaꞌoromo gavareje aharihoho hesi vëme Maryꞌo ë hijamu. Garomo saꞌare ague aho raromoromo hu rajahijareje. Rajahiromo inömo inömoho jiovoromo suvuore bamahareje. Gold o ridiꞌe inöme niöꞌi göho frankincense göho myrrh ëhi iꞌimamareje. ");
INSERT INTO aom_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Iꞌimamëꞌëro niaꞌovonöꞌe hejare God-ro uëvamu: Bogave Herod-are öriroho vuonoröꞌö vaꞌirarijë uëvamu hegorovo vuonoröꞌöromo öri gönö jabesi saꞌare vaꞌareje. ");
INSERT INTO aom_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Vaꞌamu Joseph-ro niaꞌovoro gavadeje Badare aneraëro rovamu. Aneraëro rueromo uavavamu: Riꞌö aharihohuꞌo hesi vëmohuꞌo huꞌiraejëvoromo juꞌebiromo Egypt saꞌaro vaꞌëjo. Vaꞌo ëhuro jionëjo hujeji naro uavego rueꞌirane ë hesi bëhoho Herod-ro aharihoho anoꞌi nahoꞌiëꞌe jiaje. ");
INSERT INTO aom_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Ëhi uavamu hegorovo Joseph-ro riꞌöromo jabumë huꞌiraejëvoromo vahiꞌe ë amoho vuonugoꞌi Egypt vaꞌadeje. ");
INSERT INTO aom_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Egypt vaꞌoromo ë hijuvo hejade uavavamu: Herod guomëꞌe hö uavamu hegoro rovadeje. Ëmue ahoꞌo rovade hesi bëhoho urimëꞌi Badahu uavamu hesi jö majëhinövade aehu jajivadëhi ëhi jioröhego. Badahu uavade jöho hesi surire jajivoromo ëhi uvëꞌeje: Nasi Harihoho uvamu Egypt jioromo rovëꞌe höjo. ");
INSERT INTO aom_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Ëhi ëꞌareje röhu ë hesi urimoho Herod-ro gavade saꞌa gö rajo masijoho bogo vejöꞌoho rueruomamu gagorovo uvadeje: Sareremijare höromo dë vörönimo avohadeje. Dë vörönimamu hesi aribövioho jöe bojëmiromo uëvadeje: Bethlehem-nö vaꞌoromo asisöꞌo ininoho ahoꞌo bijuëmorëjo. Magonahoho nadi vadune niöꞌi iosiramëꞌoho nadi aꞌi asisöꞌo ioroꞌioroho ahoꞌo bijuëmo barërëjo. Mamiꞌe saꞌa gö rajohuro jije rojomamu gavare majaho uavamu hejëꞌëro ëhuni vadune niöꞌi bogo iosiramijëꞌe asisöꞌoho bijuëmoröhego uëvadeje. Uëvamu iae vaꞌoromo bijuëmoruomadeje. ");
INSERT INTO aom_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Bijuëmamu ëhuro mamiꞌe jö God-aro baeromo majëhinövade ae Jeremiah-hu uëvadëhi ëhi jiadeje. ");
INSERT INTO aom_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Jeremiah-ro ëhi uëvadeje: No hejaruëjo Ramah amore uvavoꞌego. Haraꞌuoromo nivavoꞌego. Rachel-ro hesi ujo ömoꞌömohuni nivavajëjo. Hesi ujoho barëjahëꞌëro aehu sanuamaruoho bogo ejajëjo. ");
INSERT INTO aom_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Herod guomamu Joseph-ro Egypt hiromo niaꞌovoꞌiraeromo gavadeje Badare aneraëro rueromo ");
INSERT INTO aom_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","uavamu: Riꞌöromo aharihohuꞌo hesi vëmohuꞌo huꞌirae ömëvoromo Israel saꞌaro vuonoröꞌö vaꞌëjo aharihu anoꞌi uehorovare aribövioho mamiꞌe vuovëꞌe jiaje. ");
INSERT INTO aom_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Ëhi majahijamu hegorovo Joseph-ro riꞌöromo aharihohuꞌo vëmohuꞌo huꞌirae ömëvoromo Israel saꞌare vuonoröꞌö rovadeje. ");
INSERT INTO aom_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Rueromo hejade uvavamu: Archelaus-ro hesi vavue Herod-are sionoho baeromo bövie namiromo Judea saꞌaho muebejaje hö uvamu hegorovo juhuonivoromo ë saꞌaroho bogo hijadeje. Aꞌi niaꞌovoꞌiraeromo hejade God-arire jöe rueromo majahijamu hegorovo Galilee saꞌare vaꞌadeje. ");
INSERT INTO aom_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Galilee saꞌare vaꞌoromo amo ihe Nazareth ë hijadeje. Nazareth hijade hesi bëhoho urimëꞌi jö God-aro baeromo majëhinövare ariböviohuro God-are surire jajivarëhi ëhi jioröhego. Jajivoromo ëhi uvareje: Aëro hesi jöho atoromo uvoꞌaꞌaruëjo: Hu Nazareth raje ae höjo. ");
INSERT INTO aom_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Ëhiꞌamu John a bapataeto vaejëvaje ahuro Judea saꞌa a rumoꞌere Jordan jovo riröre hiromo jöho majëhinövadeje. ");
INSERT INTO aom_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Majëhiromo uënövadeje: Uehoro sisëho vuonugoꞌi uehoro mae baehëjo. Jemë iae gaꞌiëꞌarujëjo God-ro böröme namiromo muebejëvego. Ëhi majëhinövadeje. ");
INSERT INTO aom_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Ëaho John hesi jöho God-ro mamiꞌe uavamu hesi jö baeromo majëhinövade ae Isaiah-ro God-are surire jajivoromo ëhi uvëꞌeje: Aëro a rumoꞌe saꞌare hiromo ma-darugoꞌo uvoꞌaꞌajëjo: Badahu rueröhe öroho avohorego hu maro rueꞌirajo. Hesi öroho ahorirëro vajivorego hu maro juvoꞌirajo. John-hu ëꞌiröhe jöho mamiꞌe ëhi jajivoromo uvëꞌeje. ");
INSERT INTO aom_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Ëhi jajivoromo uvëꞌëro ë aho John-ro camel mi uehu avohoꞌamëꞌe niögu sisëho ruohoromo mi sinehu avohëꞌe götaho dëꞌahore baꞌamonövadeje. O hesi ioho hu guajuguajue vuome ëhi ibe juvonövadeje. ");
INSERT INTO aom_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Ëhiꞌego Jerusalem amo rajoho Judea saꞌa ioroꞌiorore raromarue aribövioho Jordan jovo bëhinö dinöꞌe dinöꞌe raromarue aribövioho ëho jaburo rueruomonövadeje. ");
INSERT INTO aom_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Rueromo jabesi sisëho huruohoꞌego John-ro Jordan jovore bapataeto vaejëvonövadeje. ");
INSERT INTO aom_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Ëhiꞌoromo John-ro gavade Pharisee ariböviohuꞌo Sadducee ariböviohuꞌo ahoꞌobëhe huro bapataeto vaejëvojöro rueruomamu gëgorovo uëvadeje: Sigobu aboji harihuꞌe jëvanovajëjo. Jemë raro uëvade höjo: God-are vöröehu rueꞌiröhire jioromo huruomoromo manö vaꞌirarijoho eni jëvoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Bogajo. Ijehu bajo mae raejajëhi ëhi mu mae vaerego no garomo uvoꞌirarëjo: Iae jemë uehoro sisëho vuonugoꞌi uehoro mae baejëꞌe jëvajëjo. ");
INSERT INTO aom_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Röhu nadi uvorëjo: Abraham nosi bëhohuro jiëꞌëro ëhuꞌëro no mae javuajëjo. Naro jemë uëvajëjo: Jemë Abraham-are ujo ömoꞌömo jëvajoho ëho ma-biseꞌe höjo. God-ro nimoꞌibejajo ave munëho ujuohoromo avohëvego araeromo Abraham-are ujo ömoꞌömoho jioꞌamoꞌibejajo. Ëhuni nadi nimorohëꞌioho ëhioho atorëjo. ");
INSERT INTO aom_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Röhu tonëro ijoho bëhiꞌo huoꞌöꞌiëꞌajëjo. Di ijohuro bajoho bogo ma raejëꞌe jiego huoꞌöromo vëniro huoꞌiëꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Naro jovëremu bapataeto vaejëvaje höjo aëro garuomoröhego jemë öri sisëho vuonugoꞌi aevoromo öri mare jijihëꞌe jëvego. Röhu ae gö nasi ijonö rueꞌiëꞌajëjo. Huro na iosiremiromo börömoho höjo. Naehu hesi mu biseꞌo vaejahoromo höru sino ujuohahoromo hesi ijore vaꞌibejodoho o mu biseꞌo biseꞌe rabe vaejahoꞌibejodoho röhu na ma-biseꞌe jevajëjo. Ëahuro God-are Aruꞌahohuro o vënëro bapataeto vaejëvoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Hesi ijo garanoho övore höjo. Ijo garanoho övore jiëꞌëro ioho tevoromo döro hijiohijiovoromo mevoromo i maho gagovoromo hesi irunoꞌe osare ë avoho bahiꞌi subueho sinoho ravemu ravaje vënire huoꞌaꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Ëhiꞌamu Iesuro Galilee saꞌare jioromo abuejadoho abo Jordan jovore höröjadeje John-ro hu bapataeto vaejöro. ");
INSERT INTO aom_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Rovamu gagorovo John-ro nijioꞌiraeromo uavadeje: O-ajo. Jero na bapataeto vaejevoꞌibejanëjo iae mae jioꞌibejajo. Röhu jero rabëni nasi öriroho rovane höjo naro ja bapataeto vaejavojöro. ");
INSERT INTO aom_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Ëhi uavamu hegorovo Iesuro uavadeje: Bogajo. Avevejöꞌe naehu uavajëhi ëhi ëꞌëjo. Ëhi ëꞌëꞌoho ëhuro God-hu nimaje muoho vaeꞌejarëjo. God-hu nimaje mu noehu vae barëjëꞌoho iae mae höjo. Iae mae höjamu hegorovo John-ro ejahadeje. ");
INSERT INTO aom_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Bapataeto vaejamu gagorovo Iesuro jovore jioromo rojo ionire namijadeje. Namijamu öꞌidöho arorovadeje. Arorovamu Iesuro gavadeje God-are Aruꞌahe guaho vaꞌënohuro ruvebiromo hesirire gerejamu. ");
INSERT INTO aom_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Ëhiꞌamu ae ahoꞌobëhe hejareje öꞌidöre uvavamu: Ave aho nasi Harihu mabëhe höjo. Na hu garomo ëhuro nasi dë vövöbajoꞌoho nimorohevajëjo. ");
INSERT INTO aom_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Iae Satan-ro Iesuare dëre bijioho garöhego God-are Aruꞌahëro uavamu Iesuro a rumoꞌe saꞌa göre ajiomadeje. ");
INSERT INTO aom_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Ajiomoromo ioho bogo ijëꞌe majae vahie ma-hibe vaꞌamu majae ahoꞌobëhe 40 barëjadeje. Majae ahoꞌobëhe 40 barëjamu vadunëro hömadeje. ");
INSERT INTO aom_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Hömamu dëre bijahuaje ahuro rueromo uavadeje: Ja God-are Harihe javëꞌoho ave munëho uëvego iraeꞌamajo. ");
INSERT INTO aom_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Iraeꞌamajamu ruehuro uavadeje: Röhu God-are jöho jajivoromo ëhi uvëꞌe höjo: Aehu iemu uehorovëꞌoho bogo maho raromoꞌaruëjo. Aꞌi God-hu jöe ahoꞌo jövajohuro ëhuro mae raromoꞌaruëjo. ");
INSERT INTO aom_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Ëhiꞌamu Satan-ro Iesu huꞌirae baeromo God-are amo ihe Jerusalem ajiomoromo ajio ruhe God-are osa börömo hesi döre baꞌojio ë nugamu namijadeje. ");
INSERT INTO aom_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Namijamu Satan-ro uavadeje: Ja God-are Harihe javëꞌoho jöröꞌörovëjo. Ëhesi bëhoho God-are surire jöho ëhi uvëꞌe höjo: God-ro hesi aneraho uëꞌiramu ja muebejavoꞌaruëjo. O hesi surire jö göho ëhi uvëꞌe höjo: Aneraho jaburo övore maꞌenagonövoꞌaruëjo jasi hörure munëro bibejavojöëni. Ëhuni jöröꞌörovëjo. ");
INSERT INTO aom_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Jöröꞌörovëjamu uavadeje: Röhu ave God-are surire jöhuꞌo ëhi uvëꞌe höjo: Nadi riꞌöromo Bada jasi God hesi dëho ëma bijiohoromo uanëjo: God jero ëhi ëhi ëꞌëjo. ");
INSERT INTO aom_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Ëhi uavamu Satan-ro Iesu huꞌirae baeromo dahoru ëgobövire ajiomadeje. Ajiomoromo a masijehu dinöꞌe dinöꞌe raromoromo muebeꞌamarue öri ariꞌoho saꞌae inömo inöme bövie biseꞌe ma-mabëhe jiëꞌego aehu muebeꞌamaruoho ëho röjahi barëjadeje. ");
INSERT INTO aom_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Röjahiromo uavadeje: Ëbövioho biseꞌoho ahoꞌo jasi örire bojamiꞌejöjo. Jaehu ague ahoromo na rajehijëꞌoho iae na bojamiꞌejöjo. ");
INSERT INTO aom_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Bojamiꞌejöjamu ruehuro uavadeje: Satan vaꞌëjo. God-are surire jöho uvëꞌe höjo: Bada jasi God gemu rajahiromo hesi muohemu gemu vaejahonëjo. ");
INSERT INTO aom_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Ëhi uavamu Satan-ro vaꞌadeje. Vaꞌamu aneraëro rueromo Iesu ajamijareje. ");
INSERT INTO aom_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Ëhiꞌamu Iesuro hejade uavavamu: John bapataeto vaejavuaje aho aëro guduamo bavaꞌoromo savoji gagore baꞌamëꞌe höjamu hegorovo Galilee saꞌare ajiomadeje. ");
INSERT INTO aom_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Ajiomoromo Nazareth amore hiromo ëho vuonugoꞌi abueromo Capernaum amore hijadeje. Capernaum amoho jovo eꞌu riröreje Zebulun rajo Naphtali rajo jabesi öri ariꞌere. ");
INSERT INTO aom_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Iesuhu ë saꞌare hijade hesi bëhoho God-hu uavamu hesi jö baeromo majëhinövade ae Isaiah-hu jajivadëhi ëhi jioröhego. Isaiah-ro God-are surire jajivoromo ëhi uvadeje: ");
INSERT INTO aom_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Zebulun rajo Naphtali rajo jabesi saꞌaho jovo börömore vaꞌarue öroho Jordan ioroꞌioro göre saꞌaho ë saꞌare Jew rajoho bogo aꞌi saꞌa ioroꞌioro rajehu ë Galilee saꞌare raromaruoho ");
INSERT INTO aom_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","ë aribövioho ramoramoꞌere raromarue höjo. Uꞌemu aji mabëhe iae garuomoꞌajëjo. Jaruvoho ramoramoꞌero vuovo öriro jijiharue höjo. Uꞌemu ajoho rueromo jabesi örire ajivëvoꞌajëjo. Iesuhu ëhi ëꞌiröhego God-are surire jö jajivadëhi Iesuro ëhi Galilee saꞌare hiromo ajoho barovadeje. ");
INSERT INTO aom_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Iesuro ajoho barueromo aevoromo jöho majëhiromo uënövadeje: Uehoro sisëho vuonugoꞌi uehoro mae baehëjo. Jemë iae gaꞌiëꞌarujëjo God-ro böröme namiromo muebejëvego. ");
INSERT INTO aom_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Ëhiꞌoromo iae Iesuro Galilee eꞌu riröre juvadeje. Juvoꞌi gavadeje Simon hesi iho göho Peterꞌo Andrewꞌo öꞌo öꞌo visue suovarue aëro jëvëꞌëro viöho jovore baꞌamamu. ");
INSERT INTO aom_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Viöho jovore baꞌamamu gëgorovo uëvadeje: Nasi ijoro ijoro ruehëjo naro röjëhijego jemëro bogo visuoho gagovoꞌi aꞌi ae magonahe gagovëvego nasinö jioruomoꞌiröhe höjo. ");
INSERT INTO aom_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Ëhi uëvamu hejëꞌi jaburo viöho ëhi vuonugoꞌi aevoromo hesi ijore ijore jirehonövareje. ");
INSERT INTO aom_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Ëhiꞌamu Iesuro vaꞌi gavadeje ae gö öꞌo öꞌo Jamesꞌo Johnꞌo Zebedee-are harihe niöꞌi boat gagore jabesi vavuohuꞌo gemuore arijamu. Ariromo jabesi viöho sigohijamu gëgorovo uvëvadeje: Ruehëjo. ");
INSERT INTO aom_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Ruehëjamu hejëꞌi jaburo boat-ohuꞌo jabesi vavuohuꞌo ë vuonugoꞌi aevoromo Iesuare ijore ijore jirehonövareje. ");
INSERT INTO aom_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Ëhiꞌamu Iesuro God rajahijarue osare osare God-are jö bëhoho röjëhibe God-hu böröme namiromo ae muebejëvoꞌiröhe jö maho majëhibe guomo guome gö gö baejëꞌe aribövioho avohëvobe ëhiꞌobe Galilee saꞌae bövioho juvo barëjadeje. ");
INSERT INTO aom_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Ëhiꞌobe juvamu huhu ëhi ëꞌade jöho hebe vaꞌadoho Syria saꞌare raromarue aribövioho jabuꞌo ë jöho hebe vaꞌoruomadeje. Hebe vaꞌoromo aëro guomo guome gö gö viꞌehe gö gö baejëꞌe aribövioho Satan-are ariböviehu dëre abueꞌamëꞌe aribövioho simano sisërëjëꞌe aribövioho övo höru vuovëhëꞌe aribövioho ëhi jiëꞌe aribövioho ujuohoromo jabesi saꞌare jioromo ruenövareje. Ujuoho rueꞌego Iesuro ajëmiꞌego marëjëvonövadeje. ");
INSERT INTO aom_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Ae ahoꞌobëhe ave Galilee saꞌare jioromo aruhe Amo 10 Jioꞌamaje Saꞌare jioromo arue Jerusalem amo börömore Judea saꞌa ioroꞌiorore jioromo aruhe Jordan jovo ioni gönö jioromo ë ro tagavoromo Iesu rihiromonövareje. ");
INSERT INTO aom_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Rihiromamu Iesuro gavade ae ahoꞌobëhe tagavoromo raromamu gagoro dahorure ajiomadeje. Ajiomoromo saꞌare hijadeje. Hijamu hesi ijore ijore jijiharue ariböviohuro rovamu gëgorovo ");
INSERT INTO aom_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","aevoromo jöho röjëhiromo uëvadeje: ");
INSERT INTO aom_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","Ae rahu uvëꞌoho: No bogo eni javuëꞌëro hesi God-ro ajamuijaje hö uvëꞌoho huë mae jioruomaje höjo God-ro muebejëvego hesi aharire mae raromoꞌiëꞌëro. ");
INSERT INTO aom_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Huë vavaeni baejarue aribövioho huë mae jioruomaje höjo God-ro huë sanue bojëmiꞌiëꞌego. ");
INSERT INTO aom_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Ma-taemo raromarue aribövioho huë mae jioruomaje höjo God-hu uëvade bövioho biseꞌoho baeꞌiëꞌëro. ");
INSERT INTO aom_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","God-are mu maemu gaꞌi nimo avoharue aribövioho huë mae jioruomaje höjo God-ro mu maho nugöꞌöjëhego jabesi dë vövöbajoꞌoho mae jëvoꞌiëꞌego. ");
INSERT INTO aom_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Ae göëni vavaenimarue aribövioho huë mae jioruomaje höjo God-ro jabesi jöëni vavaenimoꞌiëꞌego. ");
INSERT INTO aom_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Dë vövöbajoꞌo ma-maemu jiaruoho huë mae jioruomaje höjo God gaꞌiëꞌëro. ");
INSERT INTO aom_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Muorovo öri tugohoꞌi huë baerovarue öri jiovarue aribövioho huë mae jioruomaje höjo God-ro uvoꞌiëꞌego: Jabumë nasi aboji harihuꞌe hö uvoꞌiëꞌego. ");
INSERT INTO aom_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Mu mae vaejego aehu ma-jabu gemu iꞌu bojëmego baejaruoho huë mae jioruomaje höjo God-ro muebejëvego hesi aharire mae raromoꞌiëꞌëro. ");
INSERT INTO aom_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Jemëhu na uehorovevamu aehu sivëgoromo mu sisë vaejëvoromo ae sarerëmiromo jemesi jö sisë gö gö ëma atëꞌoho huë mae jëvaje höjo. ");
INSERT INTO aom_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Dë sasohoromo nimoro avohorëjo ë hesi bëhoho God-hu suvuoro jemëni öꞌidöre bamëhajoho böröme jiëꞌe jiaje. Urimo jö God-aro baeromo majëhinövare aribövi jabesi örire jabuꞌo aëro ëhi gemuoho sisë vaejëvonövare höjo. ");
INSERT INTO aom_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Söehu rumorovego i marëjajëhi jemëro saꞌare aribövioho ëhi ajëmego mae jioruomaje höjo. Jemëhu ëhi sönöꞌe ajëmijarujoho sö hesi rihu barëjëꞌoho diehiꞌoromo röhu maho avohojöëni sisëgo ruruhöꞌöjarue höjo. Ruruhöꞌöromo ë döre jijiharue höjo. ");
INSERT INTO aom_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","O irehu ajivego gavaruëhi jemë saꞌare aribövioho ëhi ajivëvoꞌirarijoho jëvajëjo. Ame hojire jiëꞌoho bogo gurihiroho jëvoꞌi ma-vaꞌorahoro jëvoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","O iro bunoꞌiraejëꞌiroho hevö gagoroho bogo gurihiꞌi ma-vaꞌorahoro bamoꞌanuëjo ae ahoꞌobëhe ë osare raromaruoho ajivëvoꞌiröhego. ");
INSERT INTO aom_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Ëhesi bëhoho jemëro jemesi aji muoho ma-vaꞌorahoro vaejego aëro ë garomo jemesi Vavue öꞌidöre hijajoho rajahiruomoꞌirajo. ");
INSERT INTO aom_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Röhu jö göho nadi uvorëjo: Naehu rovode hesi bëhoho Moses-hu bojamuade jögorohuꞌo jö God-aro baeromo majahuinövare a ioroꞌioro jabesi jöhuꞌo Iesu naehu muꞌuꞌirodoho höjo. Na bogo ëhunioho rovode höjo. Aꞌi ë ariböviehu jajivare jöe ahoꞌo naehu ejego marë barëꞌiröhohuni ëhuni rovode höjo. ");
INSERT INTO aom_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Ave jöho na jö mae uëꞌiëꞌajëjo. Öꞌidöꞌo saꞌaꞌo biririvoromo jiobe vaꞌiröhoho Moses-are jögoroho bogo iaroho bisemu vaduꞌoho sisërëꞌi jöe ahoꞌobëhe ë hesi muoho marë barëꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Ëhuni ae rahu Moses-are jögoru masijohuꞌo inino mahuꞌo ahëꞌoho o ae göehu ahoröhego röjëhijëꞌoho ëhi jiëꞌe a hesi ihoho God-are öri ariꞌeroho bogojioꞌajëjo. Aꞌi ae rahu Moses-are jögoru ejëꞌoho o ae göehu eröhego röjëhijëꞌoho ëhi jiëꞌe a hesi ihoho God-are öri ariꞌere böröme jioꞌaꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Ëhuni naro jemë uëvajëjo: God-are jögoru öri röjëhijarue ariböviohuꞌo Pharisee ariböviohuꞌo jaburo Moses-are jöho maꞌenarue höjo. Röhu jemëhu ë aribövi bogo iosirëmiromo God-hu nimaje mu bogo uhohuꞌo vaejëꞌoho God-are öri ariꞌeroho bogo mae bogo vaꞌaꞌarujëjo. ");
INSERT INTO aom_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Jemë hejarije höjo uvavamu: Aëro a mamioho ëhi uëvare höjo: Nadi aho anonëjo. Jaehu a anëꞌoho aëro ja guduamavoromo court-ro baejavo vaꞌaꞌaruëjo. Ëhi uvamu hejarije höjo. ");
INSERT INTO aom_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Röhu naro uëvajëjo: Ae rahu jaehu ae gö hesi örire dë vörönimëꞌoho aëro guduamavoromo court-ro baejavo vaꞌo hesi höjo. O ae rahu jaehu jasi aemoꞌaemo sivoromo uavëꞌoho: Ja uehore bogojiëꞌe ae javajë uavëꞌoho aëro guduamavoromo council masijo jabesi nunire baejavo vaꞌo hesi höjo. O ae rahu jaehu ae gö agoromo uavëꞌoho: Ja simano bogojiëꞌe ae javajë uavëꞌoho ëhuro ja vëni örire vaꞌo hesi javajëjo. ");
INSERT INTO aom_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Ëhuni jasi suvuoro God-are maratuore bamahoꞌi ë namiromo uehorovoromo uvëꞌoho: O nasi aemoꞌaemohuro nasi jö sisëho uehorovaje hö uvëꞌoho ");
INSERT INTO aom_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","suvuoroho maratu nuninö ëhuro bamo nugoꞌirögoro urimo vaꞌoromo jasi aemoꞌaemohuꞌo sanuamirovoromo evare ijonö vuonoröꞌö rueromo God-are öroro suvuoroho bamahonëjo. ");
INSERT INTO aom_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Aehu jasi jö sisë hesirire jiëꞌëro ja baejavoromo court-re vaꞌiëꞌiroho jemë niöꞌiro örire vaꞌarujevaro jero ma-burëro sanuꞌe jöho majahinëjo. Sanuꞌe jö bogo majahijëꞌoho huro court gavaje a hesi övore bojamiꞌajëjo. Bojamiꞌiramu court gavaje ahuro police bojamiꞌiramu savoji gagore baꞌamavoꞌiramu ë hiꞌaꞌanuëjo. ");
INSERT INTO aom_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Ëhi ma-hiemu hijuvo bojamiꞌirane monioho ahoꞌobëhe bojami barëꞌanuëjo. Iae na mae uëvajëjo. ");
INSERT INTO aom_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Jemë hejarije höjo uvavamu: Urimo ëhi uëvare höjo: Nadi gohoꞌamonëjo. ");
INSERT INTO aom_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Ëhi uvamu hejarije höjo. Röhu naro uëvajëjo: Ae rahu magonaho garomo gohoꞌamoꞌiëꞌohuro ëhuro hesi simanore gohoꞌamëꞌe höjo. ");
INSERT INTO aom_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Ëhuni jasi övo manörire nunehu mu sisë garomo ëhuro God uehorovanue mu vuonugoꞌiëꞌiroho nunoho jahoromo buꞌönëjo. Inöme gemu boremiꞌöjëꞌoho ma-jianovoꞌi jasi sine ahoꞌo vënire vaꞌëꞌoho ëho sisë höjo. ");
INSERT INTO aom_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Jasi övo manöhuro mu sisë vaeromo God uehorovanue mu vuonugoꞌiëꞌiroho tarioromo buꞌönëjo. Inöme gemu boremiꞌöjëꞌoho ma-jianovoꞌi jasi sine ahoꞌo vënire vaꞌëꞌoho ëho sisë höjo. ");
INSERT INTO aom_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Röhu ave jöhuꞌo uövuëꞌe höjo: Vaboro nugöꞌöꞌiëꞌiroho suroro jajivoromo vaboroho bojamiromo evaro nugöꞌönëjo. Ëhi uövuëꞌe höjo. ");
INSERT INTO aom_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Röhu naro uëvajëjo: Vaboroho bogo ma-juvëꞌe baruehu ëma nugöꞌöjëꞌoho ëho huro magonaho hesi örire mu sisë vaejaje höjo. Ëhuꞌëro ë magonahohuro ae gö masuvëꞌoho bogo maho masuꞌi ëho gohoꞌamarue muoho vaeꞌaꞌajëjo. O ae göehu nugöꞌöjade magonaho masuvëꞌoho gohoꞌamarue muoho vaeꞌaꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Jemë hejarije höjo uvavamu: Aëro a mamioho ëhi uëvare höjo: Darugoꞌe jö jövoromo mu vaeꞌi mae uavëꞌoho nadi ahonëjo. Aꞌi diehi vaeꞌi uavanëhi ëhi Badare nunoro vaenëjo. Ëhi uvamu hejarije höjo. ");
INSERT INTO aom_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Röhu naro uëvajëjo: Mu vaeꞌi mae uavëꞌoho nadi darugoꞌe jöho jövoꞌi ma-ahorirëro uanëjo. Nadi öꞌidö ihoho uvoromo darugoꞌoho jövonëjo God hu böröme jioromo ë hijaje jiaje. ");
INSERT INTO aom_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Nadi ave saꞌa ihoho uvoromo darugoꞌoho jövonëjo God-ro hesi höroho ë bamoromo hijaje jiaje. Jerusalem amo ihoho nadi uvoromo darugoꞌoho jövonëjo böröme namijaje a hesi ame jiaje. ");
INSERT INTO aom_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Jasi simano ihoho nadi uvoromo darugoꞌoho jövonëjo. Simano siꞌöre gemu namijöro uvëꞌoho o simano ue rövëꞌe gemu namijöro uvëꞌoho ja bogo mae bogo eni javoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Ëhuni nadi simano ihoho uvoꞌirögoro ae ma-uërëjo: Iae na ëꞌejöjo. O bogo ëꞌejöjo. Jöe ruëre numëre ëma jövëꞌoho ëho hesi Satan-are jöho höjo. ");
INSERT INTO aom_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Jemë hejarije höjo uvavamu: Urimo ëhi uëvare höjo: Ae göehu gö hesi nune gemu bijioho hisivëꞌoho mana nune gemu bijioho hisivahonëjo. Ae göehu gö hesi ane gemu buꞌuvëꞌoho mana ane gemu buꞌuvahonëjo. ");
INSERT INTO aom_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Röhu naro uëvajëjo: Aehu sisë vaejavëꞌoho nadi nijioꞌiraerovonëjo. Aꞌiro aehu aꞌisabi övo manörire anagëꞌiroho huotorovego aꞌisabi gönöhuꞌo anagoꞌirajo. ");
INSERT INTO aom_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Aehu jasi niögu baeꞌi court-re baejavo vaꞌiëꞌiroho jasi döre baꞌamanue niögohuꞌo bojamego baeꞌirajo. ");
INSERT INTO aom_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Rome muorovoꞌe aehu uavëꞌoho: Ma-burëro riꞌöromo nasi inömoho baejego vaꞌoromo ëhuro bamë uavëꞌoho jero huë baeromo ajamiromo bamojöro uavade röhoho iosiramiromo vaꞌo numoriꞌo bamahonëjo. ");
INSERT INTO aom_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Aehu jasi örire böviëni biseꞌëni ëninamëꞌoho bojaminëjo. Ma-jahuri baeꞌi nimëꞌoho nadi nijioꞌiraenëjo. ");
INSERT INTO aom_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Jemë hejarije höjo uvavamu: Urimo ëhi uëvare höjo: Jasi ae gemuoho huë baenëjo. Jaꞌo muorovaje aho nue huodivonëjo. ");
INSERT INTO aom_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Röhu naro uëvajëjo: Jemëꞌo muorovarue aribövioho huë baejëvorëjo. Jemë mu sisë vaejëvarue ariböviohuni God-are öroro ëninamirëjo. ");
INSERT INTO aom_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Jemëhu ëhi ëꞌëꞌoho Vavue öꞌidöre hijaje hesi aboji harihuꞌo mae jëvoꞌajëjo. Ëhesi bëhoho Vavuehu maja ëni nugöꞌöjajoho bogo a mahuni gemu nugöꞌöꞌi a mahuꞌo a sisëhuꞌo ahoꞌo jabuni röromo nugöꞌöjaje höjo. ");
INSERT INTO aom_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","O jemë huë baejëvarue aganohemu huë baejëvëꞌoho rabëni uvorëjo: Ëhuni God-ro suorovo mabëhe bojamuiꞌajëjo. Jemëꞌo uehorovorëjo. Vajiohuꞌe tax baeruomaje aribövioho jabuꞌo ëhi jabesi aganoho huë baejëvarue höjo. ");
INSERT INTO aom_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","O jemëhu jemesi ö muenoꞌemu rajëhijëꞌoho rabëni nimorohoromo uvorëjo: No ae ahoꞌobëhe iosirëmiromo mu ma-mabëhe vaejëꞌe javuajëjo. Jemëꞌo uehorovorëjo. God-are jö bogo hejëꞌe aribövioho jabuꞌo iae ëhi gemuoho ëꞌoromo jabesi ö muenoꞌohemu rajëhijarue höjo. ");
INSERT INTO aom_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Ëhi jiëꞌe jiaje jemesi Vavue öꞌidöre hijajehu mu bövi biseꞌo ma-mae vaejajëhi jemëꞌo ëhi avoho vaerëjo. ");
INSERT INTO aom_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","God uehorovaruje mu vaejëꞌiroho gavëꞌiajo. Nadi a nuniroho ë muoho vaerego ëhuro aëro jemë gëꞌirarëjo. A nunire vaejëꞌoho jemesi Vavue öꞌidöre hijajohuro suvuoroho bogo mana bojëmiꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Ëhi jiëꞌe jiaje mae sisë bogojiëꞌe a huë baeromo suvuoro bojëmiꞌiëꞌiroho nadi sinemuoho nimorohoromo hëgöe huanovoromo uvorëjo: Suvuoroꞌe ae jevajoho ro gehëjo. Hesi döhemu mae jioꞌamaje aribövi jabesi mue höjo. Ëho jaburo God rajahijarue osare raromoromo o örire jijihoromo ëhi a nunire nimorohëꞌi suvuoroho iꞌimëmarue höjo aëro jabumë rajëhijöro. Röhu aveho na jö mae uëvajëjo. Jabesi iho döre jiajoho ëho jabu jabesi manaho mamiꞌe ma-ioroꞌioremu bae barëjëꞌe höjo. ");
INSERT INTO aom_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Aꞌi jemëhu huë baeromo a ajëmijëꞌiroho övo maehu ae ajëmijëꞌoho nadi adoho huruoho majahiꞌi ");
INSERT INTO aom_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","jasi ma-saginiëri aho ajëminëjo. Ma-saginiëri ajëmijëꞌoho Vavue jaehu saginiëri vaejego gavajohuro jasi manaho iae bojamiꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","O jemëhu God-are örire jö atëꞌiroho ma-döhemu mae jioruomaje ariböviehu vaejaruëhioho nadi ëhioho vaerëjo. Jabumëro God rajahijarue osare o öri duvahore riravoromo parie vaeꞌi nimoruomaje höjo aëro gëjöro. Röhu aveho na jö mae uëvajëjo. Jabesi iho döre jiajoho ëho jabu jabesi manaho mamiꞌe ma-ioroꞌioremu bae barëjëꞌe höjo. ");
INSERT INTO aom_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Aꞌi jemëhu God-are örire jö atëꞌiroho jero jasi sivue osaro vaꞌoromo ojoho tugohoromo parie vaejego jasi Vavue gurihiro hijajohuro heꞌirajo. Ëhiꞌoromo pari vaejëꞌoho jasi Vavue jaehu saginiëri vaejego gavajohuro jasi manaho iae bojamiꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","O pari vaejëꞌoho nadi ruëroho numëroho ma-atobe vaꞌorëjo. Hesi God-are jö bogo hejëꞌe ariböviohuro uvoruomaje höjo: Nani noehu jö ëgobövi jaguromo majëhijëꞌoho ëhuro aruꞌaho masijohuro avoho heꞌaꞌaruëjo. ");
INSERT INTO aom_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Jabuhu pari vaejaruëhioho nadi ëhioho ëꞌorëjo. Bogo pari vaejaruje majare jemesi Vavuohuro jemesi huë vavaenoho huro urimo gavaje höjo. ");
INSERT INTO aom_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Ëhuni jemëro jöho nadi ëhioho jaguꞌirögoro aꞌi aviëhi jiëꞌe jöho majahiromo parie vaerëjo. Uarëjo: Nosi apajo. Öꞌidöre hijanuoho jero ae ahoꞌobëhe nosi dë vövöbajoꞌoho avohahuego noro ja gemu mae uehorovavoꞌirarëjo. ");
INSERT INTO aom_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Jero böröme namiromo ahoꞌobëhe muebejavuego no jasi aharire gemu raromoꞌirarëjo. Jasi aharire gemu raromoromo jaehu nimanuoho ruhe öꞌidöre mae ejaharuëhi ave saꞌarohuro ëhi ejahoꞌirarëjo. ");
INSERT INTO aom_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Nosi ioho jaruvo iꞌimamuijego no ueꞌahego daꞌuaguajo. ");
INSERT INTO aom_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Nosi sisëho uehorovoromo vuonugonëjo. Ae göehu no sisë vaejavuego noehu uehorovoromo vuonugaruëhi jero ëhi ajamuinëjo. ");
INSERT INTO aom_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Nadi vöröꞌeroho ramuego rireromavuoꞌi aꞌi ajamuinego A Sisëho bogo ruahöꞌöjavuoꞌirajo. ");
INSERT INTO aom_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Ëhesi bëhoho jemëhu a jabesi sisë uehorovoromo vuonugëꞌoho ëhuro jemesi Vavue öꞌidöre hijajohuro jemesi sisëhuꞌo uehorovoromo vuonugoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","O a jabesi sisë bogo uehorovoromo vuonugëꞌoho jemesi Vavuohuro jemesi sisëhuꞌo bogo uehorovoromo vuonugoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","O jemëhu God uehorovoꞌi i vuonugëꞌiroho döëremu mae jiëꞌe ariböviehu nu anoꞌe sisërërovaruëhioho nadi ëhioho ëꞌorëjo. Ëhesi bëhoho döëremu mae jiëꞌe ariböviehu i vuonugëꞌoho jabesi nu anoꞌoho ijumorovarue höjo aëro gëjöro jabuhu i bogo ijaruoho. Röhu aveho na jö mae uëvajëjo. Jabesi iho döre jiajoho ëho jabu jabesi manaho mamiꞌe ma-ioroꞌioremu bae barëjëꞌe höjo. ");
INSERT INTO aom_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","O jaehu i vuonugëꞌoho jasi sine bövie biseꞌe avohorovoromo ninuguꞌe jovëro simanoro otehoromo nu anoꞌoho uꞌorovonëjo. ");
INSERT INTO aom_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Ëhi ëꞌëꞌoho aho bogo gaꞌaꞌaruëjo ja ioho vuonugëꞌe javoꞌiramu gaꞌi jasi Vavue gurihiro hijajohuro huro sivue ja gaꞌaꞌajëjo. Jasi Vavue jaehu saginiëri vaejego gavajohuro jasi manaho iae bojamiꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Röhu ave saꞌaroho nadi inömoho ahoꞌobëhe jemesi sinënioho avohoromo babaenemirëjo. Saꞌaroho inömoho dëꞌiraeꞌamaje höjo. Majo majëro tarivoꞌamaje höjo. Vajiohuꞌe ariböviëro osaho dadovoromo ujuoharue höjo. Aꞌi öꞌidöro avoho babaenemirëjo. Öꞌidöroho inömoho bogo dëꞌiraeꞌamaje höjo. Majo majoho bogo tarivoꞌamaje höjo. Vajiohuꞌe aribövioho bogo osaho dadovoromo ujuoharue höjo. ");
INSERT INTO aom_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Inömo inömoho nadi jemesi sinënioho gemu bahiꞌi God-are öroro bojamego huro hesi öri ariꞌere bahi nugëhoꞌirajo. Ëhi jiëꞌoho majo majoho bogo tarivoꞌamoꞌajëjo. Bogo dëꞌiraeꞌamoꞌajëjo. O vajiohuꞌe aehu ojo dadovoromo inömo ujuohoꞌiröhoho bogojioꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Jasi mae sisë dinöꞌe jiajire jasi dë vövöbajoꞌoho ë gemu jioꞌaꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Jasi sino hesi iroho nunoho höjo. Jasi nuni mae jiëꞌoho ëhuro aji maro hiꞌaꞌanuëjo. ");
INSERT INTO aom_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","O jasi nuni sisë jiëꞌoho ëhuro ja ramoramoro hiꞌaꞌanuëjo. Ëhesi bëhoho naro uëromo ëꞌajëjo: Jasi uehoro ramoramovavëꞌohuro ëhuro ramoramo maro hiꞌaꞌanuëjo. ");
INSERT INTO aom_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Ae niöꞌi börömoho gemuoho jëvajëromo jabesi mu gemuore havoromo vaejëꞌoho bogo eni javoꞌajëjo. Ja göho nue huodivoꞌi göho rajahiꞌanuëjo. O göho mae uehorovoꞌi göho bijönimoꞌanuëjo. Ëhesi bëhoho Godꞌo moniꞌo niöꞌi börömoho gemuoho jëvajëromo gemuore havoromo mu vaejëꞌoho bogo eni jëvoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Ëhuni uëvajëjo: Nadi uvorëjo: I jovoꞌo rabe ueꞌahoromo bogo vuovoꞌi biririvoromo raromoꞌejarëjo. O uho niöguꞌo rabëro sino hahoꞌoho riogivoꞌejarëromo nurunurumorëjo. Ëhesi bëhoho ioho ma-biseꞌe jioꞌi jemëhu biririvoromo raromarujoho ëho börömoho höjo. Uho niöguꞌoho ma-biseꞌe jioꞌi sino hahoꞌo jëvajoho ëho börömoho höjo. ");
INSERT INTO aom_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Röhu ugehu döre vaꞌaruoho uehorovohëjo. Noehu ëꞌaruëhioho ugoho bogo ëhioho irunoꞌoho bivoꞌi o bogo gagovoꞌi o bogo ujuohoromo osaroho ro avoho bahijarue höjo. Bogo ëhioho ëꞌoruomaje höjo röhu jemesi Vavue öꞌidöre hijajohuro ugoho mioꞌamaje höjo. Röhu jabumë ma-biseꞌe jioꞌamoꞌi jemë masijo mae jëvajëjo. Ëhuni hu jemëꞌo avoꞌavoho muebejëvoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","O jemëhu uvëꞌoho: No diehiꞌoromo ave saꞌaroho majae ëgoꞌo raromoꞌejarë uvoromo nurunurumëꞌoho na ëhuro jemesi vuovoꞌirarije majaho iosiramiromo ruëhi ma-bisemu göꞌo raromobe vaꞌorëjo. Bogajo. ");
INSERT INTO aom_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","O niögënioho rabëni nurunurumaruje höjo. Bëhoho bogohöjo. Jeꞌore resu resuehu diehiꞌoromo riꞌamaruoho ëhuꞌo uehorovohëjo. Aehu mu vaeromo niögu avoharuëhioho resu resuoho bogo ëhioho ëꞌarue höjo. ");
INSERT INTO aom_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Bogo ëhioho ëꞌarue höjo röhu ave resu resuohuro ma-mabëhe kavuego garomo nosi dëho vuëvavuaje höjo. Naro jemë uëvajëjo: A böröme Solomon niögu ma-mabëhe ioꞌamonövadoho ëho ma-jianovoꞌi ave resu resuohuro ëhi ma-mabëhe mae kavuoꞌamaje höjo. ");
INSERT INTO aom_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Jaruvëhi resu resuoho rijego nërëhi ëhi aëro jahoromo vëniro huoꞌamarue höjo. Röhu ëhi jiëꞌe resu resuoho God-ro muebejego marëromo kavuoꞌamaje höjo. Resu resuoho ma-biseꞌe jioꞌamoꞌi jemë masijo mae jëvajëjo. Ëhuni uvorëjo: Hu noꞌo avoꞌavoho muebejavuoromo uhe niöge iꞌimamuiꞌajëjo. Nurunurumarujoho God bogo ma uehorovaruje aribövie jëvajëjo. ");
INSERT INTO aom_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Ëhuni nadi uvorëjo: No i rabe jovo rabe iꞌejarëjo. O niögu rabe ioꞌamoꞌejarëromo nurunurumorëjo. ");
INSERT INTO aom_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","God-are jö bogo hejëꞌe raromarue ariböviohuro ie jove bövie biseꞌe ëhuremu uehorovoruomaje höjo. Röhu jemëro nadi ëhioho ëꞌorëjo. Jemesi Vavue öꞌidöre hijajohuro iae mae garomo uvajëjo: Jemë iëro jovëro rabëro ëhuro biririvoromo raromarujëjo. ");
INSERT INTO aom_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Ëhuni nadi ëhemuoho uehorovoꞌi aꞌi God-hu böröme namiromo muebejëvaje muoho noehu vaejöro huhu nimaje muoho ëho nunoro bamorëjo. Ëhi ëꞌëꞌoho God-ro jemesi aruꞌahoho muebejëvoromo röhu ie jove niöge givae bövie biseꞌe ëhuꞌo romoromoro bojëmiꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Ëhuni nëröhunioho nadi nurunurumorëjo. Nëri evare ë maja hesi muoho uehorovoꞌarujëjo. Majae gemu hesi huë vavaene jaruvo majae gemu uehorovarujoho höjo. Ëhuni nëri hesiroho nadi nurunurumorëjo. ");
INSERT INTO aom_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Röhu nadi döroho bamorovoromo a jabesi sisëho mevorëjo. Jabesi sisë bogo mevëꞌoho Godꞌo jemesi sisëho bogo mevoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Jemë diehi jiëꞌe uehoro baeromo mevarujëhi God-ro ëhi jiëꞌe uehoroho baeromo mevëhoꞌajëjo. Iꞌuꞌe mae bojamëꞌohuro ëhuro iꞌuꞌe mae baeꞌaꞌarujëjo. O bisemu bojamëꞌoho bisemu baeꞌaꞌarujëjo. ");
INSERT INTO aom_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Ja diehiꞌoromo ijo ugobajoꞌe biseharihehu isiare nunire namijajoho gaꞌi ijo börömehu jasi nunire namijavajoho bogo gavanuëjo. ");
INSERT INTO aom_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Jasi nunire ijo börömehu tugohavëꞌoho ëhuꞌoho ja rabëni jasi aemoꞌaemoho uanëjo: Ëꞌego na jasi nunire ijo ine namijavajoho jahahöjo. ");
INSERT INTO aom_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Sareri ae javajëjo. Jasi nunire ijo börömehu tugohavajoho jero urimo jahonëjo. Jahonugoromo evare avoho garomo ijo ino harihoho isiare nuniroho jahahoꞌanuëjo. ");
INSERT INTO aom_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Röhu God-are inömo maho nadi öho mëmiꞌi jemesi nieniaho nadi mahu nuniroho ruruhöꞌörëjo. Ëhi ëꞌëꞌoho jaburo önu bijöꞌëro vaenugoromo evare huotorovoromo jemë umijëvoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Röhu biririvoromo God ua garëjo. Biririvoromo ua gavëꞌoho ujuohoꞌarujëjo. Biririvoromo nahorëjo. Nahëꞌoho birohoꞌarujëjo. Ojoho anoꞌanovorëjo. Anoꞌanovëꞌoho God-ro jiovëhoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Ae rahu ua gavëꞌoho ujuohoruomoꞌajëjo. Nahëꞌoho birohoruomoꞌajëjo. Anoꞌanovëꞌoho ojoho jiovëhoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Nasi jö hejarujoho ae gö vavu ömoꞌömoꞌe jëvajëjo. Jemesi harihehu uëvëꞌiroho: Ie bojemego na ijö uëvamu hejëꞌoho na jemë sareramiromo munë bojamirëjo. ");
INSERT INTO aom_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","O uëvëꞌiroho jovo mie bojemego na ijö uëvamu hejëꞌoho na jemë sareramiromo sigobu sisëho bojamirëjo. Bogajo. Jemë i mae iꞌimamiꞌarujëjo. ");
INSERT INTO aom_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Jemë sisë aribövie jëvajëjo röhu jemesi aboji harihuꞌo avoho suvuorëmiꞌirarije öroho iae gavaruje höjo. Jemë sisë jëvoꞌi öꞌidöre hijaje jemesi Vavuoho mae jiaje jemëro biririvoromo uvorëjo: Hu maëro jiëꞌëro ae rahu ua gavëꞌoho suvuoro mabëhe bojamuinövoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Ëhi jiëꞌe jiaje jemë ae göehu diehi vaejëvojöro nëgëꞌoho jemëꞌo ëhi jiëꞌe muoho ae gö jabesi öroro vaejëvorëjo. Ëhi jiëꞌe mu vaejëꞌohuro ëhuro Moses-are surire jögorohuꞌo jö God-aro baeromo majëhinövare surire jöhuꞌo ë jö hesi bëhoho ejëhoꞌarujëjo. ");
INSERT INTO aom_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Röhu ojo harihoro rumo vaꞌorëjo. Vëniꞌere vaꞌarue ojoho öroho börömëro jiëꞌëro ëhuꞌëro ae ahoꞌobëhe ë vaꞌoruomaje höjo. ");
INSERT INTO aom_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Aꞌi maro raromoröhe ojoho öroho biseharihe jiëꞌëro hesi ae ma-gemuëro gemuëro birohoromo ë vaꞌarue höjo. ");
INSERT INTO aom_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Gavëꞌi raromorëjo. Aëro rueromo God-are jöho huotohuotovoromo majëhijego ejëhojöëni uëvajëjo. Jabumë ma-döhemu sheep vaꞌëne jioꞌamoꞌi uhoho vöröꞌe mioho vaꞌëne jioꞌamajëjo. ");
INSERT INTO aom_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Jabesi mure garomo uvoꞌaꞌarujëjo: Ëaribövioho God-are jö sareriꞌe majahuijarue aribövioho jioruomajëjo. Rihuꞌe grape bajo uroꞌiëꞌiroho ë öꞌiremu uroꞌi bibëꞌe ijo sisëroho bogo uroꞌaꞌanuëjo. O meso böso uroꞌiëꞌiroho mesoremu uroꞌi bibëꞌe resu sisëroho bogo uroꞌaꞌanuëjo. ");
INSERT INTO aom_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","O ijo mahuro bajo mae raeꞌi ijo sisëhuro bajo sisë raeꞌamaje höjo. ");
INSERT INTO aom_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Ijo maho bajo sisëho bogo raeꞌi ijo sisëho bajo maho bogo raejaje höjo. ");
INSERT INTO aom_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Ije ahoꞌobëhe bajo bogo ma raejëꞌoho huoꞌöromo vëniro ruruhöꞌöjarue höjo. ");
INSERT INTO aom_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Ëhuꞌëro jiëꞌëro jabesi mure garomo uvoꞌaꞌarujëjo: Ëho jaburo bogo rae avohëꞌëro God-are jöho bogo avoho majahuijarue höjo. ");
INSERT INTO aom_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Aehu na uevaruoho: Bada Bada uevaruoho ioroꞌiorohuremu God-are öri ariꞌeroho vaꞌoruomoꞌajëjo. Ioroꞌioroho bogajo. Aꞌi ae rahu nasi Vavue öꞌidöre hijaje aehu nimajoho ëꞌëꞌohuro ë ariböviohuremu ëho vaꞌoruomoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Ëmajaho rueꞌiramu ae ahoꞌobëhe ueruomoꞌajëjo: Bada Badajo. Noro jasi ihore God-are jöho majëhiromo Satan-are sisë aribövioho a dëroho rarovöꞌöjëvoromo mu masijoho ahoꞌobëhe vaeꞌamare höjo. ");
INSERT INTO aom_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Vaeꞌamare höꞌiramu evare naro uëꞌejöjo: Na jemë bogo gëvode höjo. Bogo mae bogajo. Jemë mu sisë vaejaruje aribövie jëvaje ëhuni roriꞌo vaꞌohëjo. ");
INSERT INTO aom_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Röhu naehu jövaje jö ae rahu ejehajoho ëhi jiëꞌe a hesi jöho naro uhuꞌe majëhiꞌiëꞌajëjo. Simano maꞌe ae gemuëro javuoho munëꞌe saꞌare vaejade höjo. ");
INSERT INTO aom_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Vaejëꞌëro ëni börömëro jovo börömëro buru börömëro rueromo ë javuoho anade höjo. Anamu bogo buevade höjo munëꞌe saꞌaro vaejëꞌëro. Nasi jö ejehaje aho ë simano maꞌe aho vaꞌëne höjo. ");
INSERT INTO aom_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Aꞌi naehu jövaje jö ae rahu heromo bogo ejehajoho ëhi jiëꞌe a hesi jöho na majëhiꞌiëꞌajëjo. Simano sisëꞌe ae gemuëro javuoho nieꞌure vaejade höjo. ");
INSERT INTO aom_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Vaejëꞌëro ëni börömëro jovo börömëro buru börömëro rueromo ë javuoho anamu buevade höjo. Buevoromo saꞌare nemoromo garahöröꞌe baejade höjo. Ahia minoꞌëjo. ");
INSERT INTO aom_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Ëjöho Iesuro majëhi barëjamu ë tagavare ariböviohuro heromo tiöromo uvoruomadeje: Hesi jöho darugoꞌe jö ma-mabëhe javavajëjo. ");
INSERT INTO aom_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Ëhi uvoruomade hesi bëhoho jabesi jögoru öri röjëhijarue ariböviehu röjëhijarëhioho hu bogo ëhioho majëhiꞌi aꞌi hesi birire baejëꞌëro jöho majëhijadeje. ");
INSERT INTO aom_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Iae Iesuro dahorure abuejadeje. Abuejamu gagorovo ae ahoꞌobëhe hu rihiromoruomadeje. ");
INSERT INTO aom_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Rihiromoromo sino jomoꞌe ae gemuëro hu birohoromo ague aho hiromo uavadeje: Bada ja nasi sino avohehoꞌiranoho ja eni javajëjo. Ëhuni jasi nimoromo ajemijëꞌohuro iae ajemiꞌanuëjo. ");
INSERT INTO aom_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Ajemiꞌanuëjamu Iesuro övoho nugöꞌöromo sinoho rëhahoromo uavadeje: Iae na negajëjo ajamiꞌiro. Marëjëjo. Marëjë uavamu gavëꞌi jomoho rireromoromo hesi sinore sisë sisëho barëjadeje. ");
INSERT INTO aom_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Sisë sisëho barëjamu gagorovo Iesuro uavadeje: Aveho hejëjo. Nadi aho uënëjo. Aꞌi ma-vaꞌiranoho jasi sinoho priest röjahijego gaꞌirajo. Ëhiꞌoromo Moses-hu uövuade ëhi jiëꞌe suvuoroho God-are öroro bojamego aëro garomo uvoꞌirarëjo: Jasi sinore sisëho barëjëꞌëro iae mae javajëjo. ");
INSERT INTO aom_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Ëhiꞌonugoromo Iesuro vaꞌo Capernaum amore höröjadeje. Höröjamu Rome raje muorovo simano vaejaje ahuro rueromo uavadeje: ");
INSERT INTO aom_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Bada nasi mu vaejehaje aho guomo guome jioromo viꞌehe sisë maro baeromo bogo vuodovëꞌe ma-röhoremu raromajëjo. Na ja ajaminëjo o bogajo. ");
INSERT INTO aom_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Bogajamu uavadeje: Iae na jaꞌo öꞌoromo hesi sinoho ajamiꞌejöjo. ");
INSERT INTO aom_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Ajamiꞌejöjamu rue simano vaejaje ahuro uavadeje: Bada iae mae höjo röhu na ae ma-biseꞌe jevoromo sisë jevëꞌe jaehu nasi osare öꞌëꞌoho bogo maehu höjo. Aꞌi ma-jöꞌëro jöe jövego nasi mu vaejehaje aho marëꞌirajo. ");
INSERT INTO aom_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Ma-jö jövego mu rovaje hesi öroho iae na gavëꞌe jevajëjo. Ëhesi bëhoho na nasi a masijo jabesi aharire jevëꞌëro jabesi jöho ejëhoromo muoho vaeꞌi muorovo aribövioho nasi aharire jëvëꞌëro nasi jöho ejehoromo muoho vaejarue höjo. Naehu muorovo ae gö uavëꞌoho: Vaꞌë uavëꞌiroho iae hu vaꞌaje höjo. O muorovo ae gö uavëꞌoho: Rovë uavëꞌiroho iae hu rovaje höjo. O nasi mu ajemaje a uavëꞌoho: Mue ëhi ëhi vaejë uavëꞌiroho iae hu ëhi vaejaje höjo. Ëhuꞌëro jö jövego mu rovaje hesi bëhoho iae na gavëꞌe jevajëjo. Ëhuni uavajëjo: Ma-jöꞌëro jöe jövego marëjajo. ");
INSERT INTO aom_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Ëhi uavamu Iesuro heromo tiöjadeje. Tiöromo hu rihiromare aribövioho uëvadeje: Hu mabëhe uehorovevade höjo. Ëhi jiëꞌe aho na bogo birohëꞌe jevajëjo. Nosi Israel rajoho jabuꞌo bogo ëhioho mae uehorovevaruëjo. Iae na mae jövajëjo. ");
INSERT INTO aom_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Ëhuni uëvajëjo: Saꞌa ioroꞌioro raje ae ahoꞌobëhe maja rojomajire bevaꞌajire jioromo God-are öri ariꞌere vaꞌoromo Abraham Isaac Jacob jabuꞌo gemuore raromoromo ie ueꞌahoruomoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Aꞌi Israel raje God-are öri ariꞌere vaꞌo raromoꞌiröhe röho jiëhajoho God-ro Israel rajo a ioroꞌioroho babuꞌöjëvoꞌiramu ëho bogo vaꞌi roriꞌo ramoramoro vaꞌaꞌaruëjo. Ëdiröꞌore ae ahoꞌobëhe nierusuburuꞌe bamoromo ane jaꞌiho vuogigimoruomoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Ëhi uënugoromo Iesuro ë simano vaejaje aho uavadeje: Vaꞌonëjo. Diehi jioꞌiröhego jaehu mae uehorovanëhi iae ëhi jiahoꞌajëjo. Ëhi uavamu gavëꞌi evare hesi aho marëjadeje. ");
INSERT INTO aom_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Ëhiꞌonugoromo Iesuro Peter-are osare vaꞌadeje. Vaꞌoromo gavadeje Peter-are jure magonahoho sine vöröꞌiraeꞌego röhore raromamu. ");
INSERT INTO aom_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Raromamu gagorovo Iesuro magonaho hesi övoho rëhahamu vöröho uꞌuhadeje. Vöröho uꞌuhamu hegorovo magonahohuro riꞌöromo Iesuni irunoꞌe avohahadeje. ");
INSERT INTO aom_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Ëhiꞌamu majae bevaꞌamu gavëꞌi Satan-are a sisëhu dëre abueꞌamëꞌe aribövioho ahoꞌo aëro sö rovareje. Sö rovamu gagoro Iesuro jöe jövoromo ajëmiromo Satan-are aribövioho rarovöꞌöjëvadeje. O guomo guomoꞌe aribövioho ahoꞌo jabesi sinoho avohëvamu marëjëvadeje. ");
INSERT INTO aom_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Ëhi a ajëmade hesi bëhoho mamiꞌe jö God-aro baeromo majëhinövade ae Isaiah-ro jajivoromo uvadeje: Nosi guomo guomo hesi iꞌuoho huro nigemahuëꞌe höjo. Nosi viꞌehoho roriꞌo bavaꞌëꞌe höjo. ");
INSERT INTO aom_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Ëhiꞌoromo Iesuro gavade ae ahoꞌo hesi bëhire ruë numë tagavamu gëgorovo hesi ijorajo ömoꞌömoho uëvadeje: Ruerego no eꞌu ioni gönö vaꞌirarëjo. ");
INSERT INTO aom_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Ëhi uëvamu Jew rajo jögoru öri röjëhijaje ae gemuëro rueromo Iesu uavadeje: Tisa ja dinöꞌe dinöꞌe vaꞌëꞌiroho na jasi ijore ijore juvonövoꞌejöjo. ");
INSERT INTO aom_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Juvonövoꞌejöjamu Iesuro ë aho uavadeje: Jero nasi ijore ijore juvoꞌi uevanuëjo röhu jeꞌo majehu saꞌa gagore röho avohoromo mare raromaruoho iae jiajëjo. O jeꞌo ugehu iju vaeromo mare raromaruoho iae jiajëjo. Aꞌi God-are A Ma naehu niavaje hijaje osaho bogojevajëjo. Nadi uvonëjo: Nöröꞌo hibe juvëꞌoho mae hibe juvoꞌejöromo nasiriroho ruenëjo. ");
INSERT INTO aom_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Ëhiꞌamu Iesuare ijore ijore juvaje ae göëro riꞌöromo Iesu uavadeje: Bada uevego na nimo vuonoröꞌö vaꞌoromo nasi vavuoho guavoꞌiröjo. Guavoromo hujeji evare jasi ijore ijore juvoꞌiröjo. ");
INSERT INTO aom_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Juvoꞌiröjamu Iesuro uavadeje: O-ajo. Jero nasi ijoro ijoro juvëjo. Vuonugego vuovo örire jijiharue ariböviohuro jabesi aribövioho guavoꞌamoꞌirarëjo. ");
INSERT INTO aom_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Ëhiꞌoromo Iesuro boat gagore ajio hijamu hesi ijorajo ömoꞌömohuro huꞌo ajio gemuore raromoromo vaꞌareje. ");
INSERT INTO aom_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Vaꞌihö gavareje eꞌu döre buru börömoho rueromo jovoho hasaꞌego boat gagoho abo rarovamu. Abo rarovoꞌi röhu Iesu niavëꞌe jiadeje. ");
INSERT INTO aom_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Iesu niavëꞌe jiamu gagorovo vaꞌo ioromo uavareje: Bada ajamuëjo. Vuovavuoꞌiëꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Vuovavuoꞌiëꞌajëjamu uëvadeje: Jemë rabëni juhuonivarujëjo. Jemë God bogo ma uehorovaruje aribövie jëvajëjo. Ëhi uënugoromo riꞌöromo burohuꞌo jovohuꞌo uëvadeje: Vuonugohëjo. Vuonugohëjamu jovoho uꞌuhoromo ma-jörume ruhijadeje. ");
INSERT INTO aom_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Ma-jörume ruhijamu gavëꞌi rueho jaburo uarovareje: Ave aho diehi jiëꞌe ae höjo. Huhu uëvëꞌoho bogo aëremuoho ejahoꞌi burohuꞌo jovohuꞌo jabuꞌo hesi jöho ejaharue höjo. ");
INSERT INTO aom_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Ëhiꞌonugoromo Iesumëro vaꞌaroho vaꞌo eꞌu ioni gönö Gadarene rajo jabesi saꞌare vaꞌo baboro bejareje. Baboro bejamu gavëꞌi ae niöꞌiro guavoꞌamarue juju gagore arijëꞌëro rueromo Iesu birohareje. Röhu ë ae niöꞌioho Satan-are a sisëro dëre abueruomëꞌëro jiëꞌëro vörö maꞌe jëvadeje. Ëhuni ae ahoꞌobëhe juhuonivareje ë örire jijihoꞌiröhoho. ");
INSERT INTO aom_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Ëhi jiëꞌe vöröho jëvëꞌëro birohoromo ma-darugoꞌo uvareje: God-are Harihoho ja rabëni sihusihuaguoꞌi rovane höjo. Noehu iꞌu baeꞌiröhe majaho bogo rovëꞌe na ja ëma öriꞌahoro huë sisëho viꞌehoho bojamuiꞌi rovane höjo. O diehiꞌavuoꞌi rovane höjo. ");
INSERT INTO aom_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Rovane höromo gavare aruhëre mahe ahoꞌobëhe gemuoro ie ueꞌahamu gagorovo ");
INSERT INTO aom_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Iesu uavareje: Ja rarovöꞌöjavuogorovo uövuego no suorovo vaꞌoromo aruhe mahu jabesi dëre vaꞌo abuejarëjo. ");
INSERT INTO aom_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Abuejarëjamu uëvadeje: Ëhuro vaꞌohëjo. Vaꞌohë uëvamu hejëꞌi ë ae niöꞌi jabesi dëre jioromo suorovo vaꞌoromo ruhe mahu jabesi dëre abueruomadeje. Abueruomamu ë mahohuro ahoꞌobëhe baradore vaꞌo rireromoromo eꞌure siö ruruhöꞌö vaꞌoromo jove ueꞌahoromo vuovadeje. ");
INSERT INTO aom_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Vuovamu gavëꞌi mahu muebejarue ariböviohuro huruomoromo amore vaꞌoromo ae uëvareje: Aruꞌaho sisëhu dëre jëvade aho ëhi marëjëvohijajo. O mue gö gö ëhi ëhi ruehijajo. ");
INSERT INTO aom_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Ëhi majëhijamu ae ahoꞌobëhe heromo Iesu birohoꞌi rueruomadeje. Rueromo garomo uavareje: Ave saꞌaho vuonugoꞌi vaꞌëjo. ");
INSERT INTO aom_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Ëhiꞌamu Iesuro boat gagore ajiomoromo jovo döre vaꞌadoho vaꞌo hesi amore ravoꞌamadeje. ");
INSERT INTO aom_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Amore ravoꞌamamu gagorovo övo höruꞌe vuovahëꞌëro hesi maratuore raromaje aho aëro giojimo barovareje. Barovamu gagorovo Iesuro gavade jaburo hu mae uehorovamu gëgorovo övo höruꞌe vuovahëꞌe aho uavadeje: Harihohajo. Ma-biririvëjo. Jasi sisëho uehorovoromo vuonugoromo muꞌu barëjahëꞌe höjo. ");
INSERT INTO aom_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Muꞌu barëjahëꞌe höjamu hegorovo jögoru öri röjëhijarue a ioroꞌiorohuro uehorovoromo uvareje: Asëꞌëjo. Ave ahuro God-are ihoho ijumajëjo. ");
INSERT INTO aom_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Ëhi uvamu Iesuro gëromo uvadeje: Jabumë ëhi uehorovaruëromo uëvadeje: Jemë rabëni uehoro sisëho baejarujëjo. ");
INSERT INTO aom_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Jemëꞌo uehorovohëjo. Nani ja ae ëma uaꞌaꞌanuëjo: Jasi sisëho uehorovoromo vuonugahëꞌe hö uaꞌaꞌanuëjo. Ja ëhi uaꞌibejanëjo aho nunoho bogo gaꞌibejarëjo ja mae o sarere jövëꞌe javego. Röhu ja bogo ëma uaꞌaꞌanuëjo: Riꞌöromo nami juvëjo hesi guomo guomoho bogo barëjego ja javojagojöëni. ");
INSERT INTO aom_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Röhu ë bogo ëma jövoꞌibejane jöho iae na jövoꞌejöjo huro ejehoromo riꞌö nami juvego jemëro ë muoho garomo ëhuro gaꞌirarijego God-are A Maho naro saꞌare hijajire evare sisë muꞌuvaje darugoho baejëꞌe jevego. Ëhi uënugoromo röhu övo höruꞌe vuovahëꞌe aho uavadeje: Riꞌöromo raromanue maratuoho banigojiomoromo baeromo jasirëro vaꞌëjo. ");
INSERT INTO aom_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Vaꞌëjamu iae riꞌöromo hesirëro vaꞌadeje. ");
INSERT INTO aom_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Vaꞌamu gavëꞌi ë ariböviohuro juhuonivoromo uvoruomadeje: God-ro ma-ae uavamu mu böröme ëꞌade höromo God rajahiruomadeje. ");
INSERT INTO aom_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Ëhiꞌamu Iesuro vaꞌadeje. Vaꞌi gavade tax baejaje ae hesi ihoho Matthew hesi mu vaejaje osare hijamu gagorovo uavadeje: Rueromo nasi ijoro ijoro juvonövonëjo. Juvonövonëjamu hegorovo riꞌöromo aevoromo hesi ijore ijore juvonövadeje. ");
INSERT INTO aom_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Ëhiꞌamu Iesumëro Matthew-are osare ie ueꞌahamu evare tax baejarue ae ahoꞌo sisë aribövie ahoꞌo ëho jaburo rueromo Iesuꞌo hesi ijorajo ömoꞌömohuꞌo gemuoro ioho ueꞌahareje. ");
INSERT INTO aom_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Ie ueꞌahamu gëgorovo Pharisee ariböviohuro Iesuare ijorajoho uëvareje: Asëꞌëjo. Jemesi börömoho rabëni tax baejarue ariböviohuꞌo sisë a ioroꞌiorohuꞌo gemuoroho hiromo ioho ijajëjo. Ëhi jiëꞌoho sisë höjo. ");
INSERT INTO aom_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Ëhi jiëꞌoho sisë hö uvavamu Iesuro huꞌo hegorovo ë Pharisee aribövioho uhuꞌe uëvadeje: Jemëhu nasi aribövi ëhi uëvarujoho röhu guomo guomoꞌe ariböviohuremu doctor gavarue höjo mae jëvëꞌe aribövioho bogajo. ");
INSERT INTO aom_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Vaꞌoromo ave jö hesi bëhoho nahoromo birohorëjo. God-ro uvajëjo: Na negajëjo a huë baeꞌirarije muoho vaejöro mi suvuoroho bogajo. Naro sisë aribövioho nasinö jëvojöro uëꞌi rovode höjo ma-döemu mae jëvëꞌe aribövioho bogajo. ");
INSERT INTO aom_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Ëhiꞌamu John-are ijore ijore jijiharue ariböviohuro rueromo Iesu uavareje: Noꞌo Pharisee ariböviohuꞌo God uehorovoꞌi ie vuonugarue höjo. Noro ëhi ëꞌarue höjo röhu jasi aribövioho rabëni bogo ëhioho ioho vuonugarue höjo. ");
INSERT INTO aom_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Rabëni bogo ëhioho ioho vuonugarue höjamu hegorovo Iesuro uëvadeje: Nasi ijore ijore jijiharue ariböviehu i bogo vuonugarue hesi bëhoho naro uhuꞌe uëꞌiëꞌajëjo. Na jemëro uvarujëjo: Iꞌo masuröhe a hesi söröre rueromo aemoꞌaemëro huë vavaene baeruomoꞌajëjo. Bogo ëhioho ëꞌi iae ie ueꞌahoruomoꞌajëjo. Röhu majae ijonö iꞌo masuröhe aho aëro guduamo bavaꞌiramu evare ioho vuonugoꞌaruëjo. Avevejöꞌoho naro jabuꞌo hijëꞌego jabu ioho bogo vuonugoꞌaruëjo. ");
INSERT INTO aom_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Ëhi uënugoromo Iesuro uhu jöe göꞌo majëhiromo uëvadeje: Niögu iꞌohuꞌo mamiohuꞌo bogo havoꞌanuëjo. Bogo havoromo niögu mami dadovadiroho niögu iꞌo hesi vituoho baeromo niögu mami hesi gagoroho bamoromo sigohiꞌanuëjo iꞌohuro duduhirovoromo ruho barovego böröme dadorovojöëni. ");
INSERT INTO aom_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","O wine jovo mi sino gagore biguꞌiëꞌiroho jovo iꞌohuꞌo mi sino mamiohuꞌo bogo gemuoroho havoromo jovo iꞌoho mi sino mamiroho biguꞌanuëjo. Ëhi ëꞌibejanëjo jovohuro gatovoromo ögohuro bibivoromo mi sinoho mamiëro jiëꞌëro tögömoromo dadorovego jovoho rovaꞌibejajo. Aꞌi jovo iꞌoho mi sino iꞌo hesi gagoremu biguꞌanuëjo. Biguꞌiramu jovoho mi sinoho mae jioꞌamoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Iesuro ëhi uëvamu gavëꞌi Jew rajo a böröme gemuëro rovadeje. Rueromo ague aho hiromo Iesu uavadeje: Nasi aboje avevejöꞌe guomajëjo. Jero rueromo jasi övoho hesi sinoro bamego iꞌovajo. ");
INSERT INTO aom_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Iꞌovajamu hegorovo Iesuro riꞌöromo huꞌo hesi ijorajo ömoꞌömohuꞌo ë a hesi ijore vaꞌareje. ");
INSERT INTO aom_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","21","Örire vaꞌamu gavëꞌi magonahe gemuëro jabuꞌo vaꞌadeje. Ëmagonahoho manaero garorovade guomo guomoho bogo barëꞌi vadune ahoꞌobëhe 12 baejëꞌëro jiëꞌëro uehorovoromo uvadeje: Na Iesu ma-niögohuremu rëhëꞌohuro ëhuro marëjevoꞌajëromo Iesuare dejonö rueromo niögu viture rëhadeje. ");
INSERT INTO aom_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Rëhamu hegorovo Iesuro huotorovoromo magonahoho garomo uavadeje: Abojëjo. Nadi juhuonivoꞌi biririvëjo. Jero na mae uehorovevamu ëhuro ja marëjavëꞌe höjo. Marëjavëꞌe hö uavamu gavëꞌi marëjadeje. ");
INSERT INTO aom_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Marëjamu gagorovo Iesuro vaꞌoromo ë a börömo hesi osare vaꞌoromo gavade virikö vavaeniꞌe huosiharue aribövioho ë raromoꞌi ae ahoꞌobëhe darugoꞌo nierusuburuꞌe bamamu gëgorovo ");
INSERT INTO aom_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","uëvadeje: Ae ahoꞌo vaꞌohëjo. Magonaho harihoho bogo guomoꞌi ma-niavajëjo. Ma-niavajëjamu hegoro rueho jaburo Iesu sivoromo ijoꞌijahareje. ");
INSERT INTO aom_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Ijoꞌijahamu huro ae ahoꞌobëhe rarovöꞌöjëvonugoromo magonaho hesi osare vaꞌoromo övoho baejamu iꞌovoromo riꞌöjadeje. ");
INSERT INTO aom_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Ëhi ëꞌade jöho ë saꞌaho ahoꞌobëhe rumorovobe vaꞌadeje. ");
INSERT INTO aom_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Ëhiꞌamu Iesuro ë amoho vuonugoꞌi örire juvo vaꞌadeje. Örire juvo vaꞌamu gagorovo nuni sisëꞌe ae niöꞌiro rihiromoromo uvobe vaꞌareje: David-are ujoho böröme javaje jero noni vavaenimëjo. ");
INSERT INTO aom_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Ëhi uvobe vaꞌamu Iesuro osare vaꞌadeje. Osare vaꞌamu rue ae niöꞌiohuro rovareje. Rovamu gëgorovo Iesuro uëvadeje: Na jemë mae uehorovoromo uvarujëjo: Nörö ajamuiꞌiröhoho eni höjo. Eni höjamu uavareje: Bada ioꞌajo. ");
INSERT INTO aom_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Ioꞌajamu Iesuro nunoho rëhëhoromo uëvadeje: Ëhi jiëꞌoho jemëhu uehorovarujëhi iae ëhi jiëhoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Ëhi uëvamu gëgorovo nunoho marëjëvamu mae uherihareje. Mae uherihamu gagorovo Iesuro darugoꞌo majëhiromo uëvadeje: Bogave aho uëꞌirarijëjo. ");
INSERT INTO aom_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Ëhi uëvamu hegorovo ë ae niöꞌiohuro höꞌöromo vaꞌoromo Iesuare jöho bogo ejahoꞌi Iesuhu jabumë ajëmijade jöho majëhibe saꞌae bövioho jirehareje. ");
INSERT INTO aom_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Ëae niöꞌioho jaburo ë osare jioromo höꞌöjamu gavëꞌi aëro ae gemu huꞌirae baeromo rovareje. Ëaho aruꞌaho sisë dëre jiëꞌëro jörumoꞌe jiadeje. ");
INSERT INTO aom_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Jörumoꞌe jiamu Iesuro ë aruꞌaho sisëho rarovöꞌöjamu aho aevoromo jöe jövadeje. Jöe jövamu hegorovo ae ahoꞌobëhe tiöromo uarovareje: Asëꞌe ëhi jiëꞌe muoho Israel saꞌaroho bogo gavëꞌe javuajëjo. ");
INSERT INTO aom_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Ëhi uarovamu Pharisee ariböviohuro uëvareje: Sisë a börömohuro vöröho bojamijego ëhuro a dëre aruꞌaho sisëho rarovöꞌöꞌamaje höjo. ");
INSERT INTO aom_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Ëhiꞌamu Iesuro God rajahijarue osare osare God-are jö bëhoho röjëhibe God-hu böröme namiromo muebejëvoꞌiröhe jö maho majëhibe guomo guome gö gö baejëꞌe aribövioho avohëvobe ëhiꞌobe amo masijore ininore juvo barëjadeje. ");
INSERT INTO aom_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Juvoromo ganövade ae ahoꞌobëhe tagavoromo huë vavaene baeromo sisëꞌi raromoꞌego gëgorovo uvonövadeje: Ëaribövioho vëmu vavu rumoꞌe ö mahuꞌëro raromanovaruë uvoromo jabesi jöëni vavaenimonövadeje. ");
INSERT INTO aom_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Jabesi jöëni vavaenimamu hesi ijorajo ömoꞌömoho uhuꞌe uëvadeje: Ae ahoꞌobëhe nasinö sö rueꞌiröhoho ëho mure irunoꞌe gagovoꞌiröhoho vaꞌëne höjo. Mure gagovoꞌiröhe irunoꞌoho bövi mae jioꞌi gagovarue aribövioho no ma-gemu gemu javuajëjo. ");
INSERT INTO aom_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Ëhuni mu Arijoꞌoho ëninamiromo uarego huro ae göꞌo rëmöꞌöjego mure rueromo ajamuiromo irunoꞌoho gagovoꞌirarëjo. ");
INSERT INTO aom_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Ëhiꞌamu Iesuro hesi ijoraje 12-ho uëvadeje: Ruehëromo rovamu daruge bojëmiromo uëvadeje: Satan-are ariböviehu a jabesi dëre jioꞌamamu gëvëꞌoho rarovöꞌöjëvego suorovoromo vaꞌirarëjo. Guomo guome gö gö baejëꞌe o sino hahoꞌe uꞌuhoꞌamëꞌe jiamu gëvëꞌoho avohëvego marëjëvoꞌirajo. ");
INSERT INTO aom_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Röhu hesi apostle aribövie 12 jabesi ihoho aviëhije. Urimo Simon hesi iho göho Peterꞌo hesi öho Andrewꞌo ëhi jëvadeje. Göho Jamesꞌo Johnꞌo öꞌo öꞌo Zebedee-are harihoho jëvadeje. ");
INSERT INTO aom_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Göho Philipꞌo Bartholomewꞌo jëvadeje. Göho Thomasꞌo tax baenövade ae Matthewꞌo jëvadeje. Göho James Alphaeus-are harihohuꞌo Thaddaeusꞌo jëvadeje. ");
INSERT INTO aom_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Göho Simon hu Jew rajehu jabesi mueberovoꞌi nimade aho jiadeje. Göho Judas Iscariot jiadeje. Judas Iscariot hu ijonö Iesuni hiruëmiromo a jabesi övore bojëmiꞌiröhe aho jiadeje. Iesuare apostle 12 jabesi ihoho ëhi jioꞌamadeje. ");
INSERT INTO aom_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Ëaribövie 12-ho jaburo mue vaebe jijihoröhego Iesuro rëmöꞌöromo uëvadeje: Vaꞌirarijoho saꞌa ioroꞌioro rajo jabesiriroho Samaria saꞌa rajo jabesi amoroho nadi vaꞌorëjo. ");
INSERT INTO aom_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Aꞌi Israel rajo jabesiriremu vaꞌorëjo jabumë sheep-ëro öre sidövanovoromo ëma jijiharue jiaje. ");
INSERT INTO aom_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Vaꞌoromo uëbe jijihorëjo: Iae gaꞌiëꞌarujëjo God-ro böröme namiromo muebejëvego. ");
INSERT INTO aom_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Ëhi uëbe guomo guomoꞌe aribövioho ajëmibe vuovëꞌe aribövioho iꞌovëvobe sino jomoꞌe aribövioho avohëvobe Satan-are ariböviehu a dëre jioꞌamëꞌoho rarovöꞌöjëvobe ëhiꞌobe jijihorëjo. A ajëmiꞌirarije darugo God-arire baejarijoho bogo manaho bojamarije höjo. Ëhuni manaho nadi baeꞌi aho ma-ajëmibe jijihorëjo. ");
INSERT INTO aom_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Gold ijo bajoho ajivëꞌe ijo bajoho rövëꞌe ijo bajoho göta esöroho nadi aegoromo ujuoho jijihorëjo. ");
INSERT INTO aom_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","A ëninëmiromo ujuohoromo aegoꞌirarije esöho nadi ujuohoromo jijihorëjo. Niögoho nadi göho ujuohoꞌi ma-gemu ruohoromo jijihorëjo. Höru guduoho nadi ioꞌamoromo ijahoho nadi ujuohoromo jijihorëjo. Ëhi jiëꞌe inömo inömoho nadi ujuoho jijihorëjo ë hesi bëhoho ae rahu mu vaeromo i mana baejëꞌoho iae mae jiëꞌe jiaje. ");
INSERT INTO aom_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Vaꞌirarijoho amo masijore o ininore suorovëꞌoho vaꞌoromo a ma-maho nahorëjo. Nahoromo birohogorovo ë a hesi osaro raromonövorëjo ijonö ë amore jioromo vaꞌiëꞌe jëvaje. ");
INSERT INTO aom_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Röhu osare rumo vaꞌëꞌiroho jejëmiromo uënövorëjo: Huë mae baerëjo. ");
INSERT INTO aom_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Huë mae baerëjamu hegorovo ë osare raromarue ariböviehu uëvëꞌoho: Iae mae hö uëvëꞌoho iae huë mae baeruomoꞌajëjo. O bijönimëꞌoho uërëjo: God-are huë ma jö uëvodoho vuonugajëjo. Ëhuꞌëro bogo baeꞌaꞌarujëjo. ");
INSERT INTO aom_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","O di osaehu di amehu jemesi örire nu huodëgoromo jö bogo ejëhëꞌoho uvorëjo: Jabesi muoho bövioho biseꞌoho saꞌaho tohotohoho sisë höromo jabesi tohotohe jemesi hörure jiajoho riremo vaꞌorëjo. ");
INSERT INTO aom_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Ave jöho na jö mae uëvajëjo: God-hu iꞌu bojëmiꞌiröhe maja rovëꞌiroho Sodom o Gomorrah amo rajo jabuhu iꞌu baeröhoho ma-jianovoꞌi aꞌi jemesi jö bogo eruomaje aribövioho jaburo iꞌu börömo maho baeruomoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Aveho hehëjo. Naro rëmöꞌöjego jemë vaevëꞌe sheep harihunöꞌe vöröꞌe miehu jioruomajire vaꞌiëꞌarujëjo. Ëhuni vaꞌoromo sigobehu a gagoro ma-burëro juꞌebiromo vaꞌajëhi ëhi gavëꞌi jijihorëjo. O ugo ma-maehu hesi iemu iromo ma-taemo hijajëhi ëhi taemo raromobe vaꞌorëjo. ");
INSERT INTO aom_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Ae gëvëꞌiajo. Jaburo guduamo ujuohëvo vaꞌoromo jögoru muebejarue aribövi jabesi övore bojëmiꞌaruëjo. Jabuhu God rajahijarue osa göro göro hisuebijëvoꞌaruëjo. ");
INSERT INTO aom_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Gavana o saꞌare a masijo gö gö jabesi nunire rëmoꞌiramu nasi jöëni ë riravoromo nasi jöho jabesi örire saꞌa gö rajo jabesi örire majëhiꞌarujëjo. ");
INSERT INTO aom_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Röhu jabuhu guduamo ujuohëvo vaꞌamu a masijo jabesi nunire riravëꞌoho nadi uvorëjo: Na diehi jöho majëhiꞌejöjo. O rabu jöe majëhiꞌejöromo nurunurumorëjo. Rabëni hesi bëhoho jö majëhiꞌirarije majaho rueꞌiramu evare majare God-ro ajëmiromo jöho röjëhiꞌiramu majëhiꞌarujëjo. ");
INSERT INTO aom_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Bogo jemëhu jöho majëhiꞌirögoro aꞌi jemesi Vavu hesi Aruꞌahohuro jöho simanore bojëmiꞌiramu jemëro jöho majëhiꞌarujëjo. ");
INSERT INTO aom_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Röhu öhuro öho ae gö jabesi örire bojëminövoꞌaruëjo muoꞌamojöro. Vavuohuro aboji harihuꞌoho ëhi gemuoho ëꞌaꞌaruëjo. Aboji harihuꞌohuro riꞌöromo ae uëꞌiramu vëmu vavuꞌoho muoꞌamoꞌaruëjo. ");
INSERT INTO aom_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Röhu jemëhu na uehorovevarujohuni ae ahoꞌobëhe jaburo jemesi örire nue huodëgoruomoꞌajëjo. Röhu ae rahu biririvoromo mae uehorovevobe vaꞌojuvo maja barëꞌiröhe maja rovëꞌiroho God-ro baejëvoromo manö bamëvoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Jemë amo göre raromamu aehu sisë vaejëvëꞌoho huruomoromo amo göro vaꞌonövorëjo. Aveho na jö mae uëvajëjo. Jemë Israel saꞌare amo göre göroho bogo vaꞌo barëjëꞌe God-are A Maho na öꞌejöjo. ");
INSERT INTO aom_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Jö hejaruje aribövioho jö röjëhijaje aho na bogo iosiremiromo masijoho jëvajëjo. O mu vaejeharuje aribövioho mu simano vaejaje aho na bogo iosiremiromo döroho jëvajëjo. ");
INSERT INTO aom_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Ëhuni jö röjëhijaje aho ae göehu huë vavaene bojemego naehu baejajëhi nasi jö hejaruje ariböviehu ëhi baejëꞌoho iae mae höjo. O mu simano vaejaje aho ae göehu huë vavaene bojemego naehu baejajëhi nasi mu vaejeharuje ariböviehu ëhi baejëꞌoho iae mae höjo. Ëhesi bëhoho agano muebejëvaje aho na aehu uevaroho: Ja Beelzebul a sisë jabesi böröme javajë uevarohuni ëhuni ëhi jiëꞌe ariböviohuro jemë nasi agane jëvëꞌego jö sisë bëhi mae uëruomoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Jö sisëho ëhi uëruomoꞌajëjo röhu nadi juhuonëmirëjo. Mue rabe gurihiro jiajoho ahoꞌobëhe vaꞌorahoro jioꞌaꞌajëjo. Rabe rabe subivëhajoho ahoꞌobëhe ma-samaro jioꞌaꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Ëhi jiëꞌe jiaje naehu jöe rabe vahiꞌe saginiëri majëhijajoho ijonö majaꞌe ë jöho ma-vaꞌorahoro majëhirëjo. O saginiëri hiaꞌire majëhijego hejarujoho ëho amo riroro majëhirëjo. ");
INSERT INTO aom_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Röhu nadi uvorëjo: Ëariböviohuro anaguoꞌajëromo juhuonëmiromo jabesi jöho uehorovorëjo. Jemesi sinohemu muoꞌamëꞌoho eni jëvoꞌi jemesi aruꞌaho muoꞌamëꞌoho bogo eni jioruomëꞌe jiaje ëhuni jabumë nadi juhuonëmiꞌi God juhuonamiromo hesi jöho uehorovorëjo. Huhu jemesi aruꞌahohuꞌo sinohuꞌo vëniꞌe öri ariꞌere babuꞌöjëvoromo ijumëvoꞌiröhoho hu eni jiajëjo. Ëaho juhuonamiromo hesi jöho uehorovorëjo. ");
INSERT INTO aom_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Aꞌi aho bövioho biseꞌoho nadi juhuonëmirëjo. Ëhesi bëhoho God-ro uvajëjo: Jemë iae masije jëvajëromo avoꞌavoho muebejëvaje höjo. Monie ma-bisemu buꞌöromo ugo inine niöꞌi imoꞌarujëjo. Röhu jemesi Vavuoho bogo uvaje höjo: Ugoho ininego bogo muebeꞌejöjo. Bogo ëhioho uvoꞌi ugoho muebeꞌamëꞌego ugoho bogo gemu vaduꞌoho ëma vuovoromo öꞌidöroho jioromo saꞌaroho rireromo rovarue höjo. Vavuohuro gëvego rireromo rovarue höjo. ");
INSERT INTO aom_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Aꞌi jemë God-ro jemesi bövie biseꞌe ahoꞌo muebejëhoromo röhu jemesi simano uoho ëhuꞌo adahëhoromo avoꞌavoho muebejëhaje höjo. ");
INSERT INTO aom_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Ëhuni nadi juhuonivorëjo uge ahoꞌobëhe jioꞌamajoho ëho ma-jianovoꞌi ae gemu gemu jemë masije jëvëꞌe jiaje. ");
INSERT INTO aom_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Ae rahu a nunire uvëꞌoho: Na Iesuare ae jevajë uvëꞌoho naro nasi Vavue öꞌidöre hijaje hesi nunire uvoꞌejöjo: Ëho nasi ae magonahe höjo. ");
INSERT INTO aom_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","O ae rahu a nunire uvëꞌoho: Na bogo Iesuare aehu jevajë uvëꞌoho naro nasi Vavue öꞌidöre hijaje hesi nunire uvoꞌejöjo: Ëho bogo nasi aehu magonahehu höjo. ");
INSERT INTO aom_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Nadi uvorëjo: Nöröhu rovade hesi bëhoho ajamuego saꞌae ahoꞌobëhe iro muorovoꞌoho vuonugoꞌi ma-huë baerovoromo gemuoro raromoꞌiröhego rovade höjo. Na bogo ëhunioho rovode höjo. Aꞌi naehu rovode hesi bëhoho naro nasi jöho majëhijego aëro heromo jöe gö gö uehorovoromo muorovoꞌiröhego rovode höjo. ");
INSERT INTO aom_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Naehu rovode hesi bëhoho nasi jöhuni harihohuro vavuoho nue huodivoꞌi abojohuro vëmoho nue huodivoꞌi ajohuro ajoho nue huodivoꞌiröhego ëhuni rovode höjo. ");
INSERT INTO aom_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","A nu huodëgarue aribövioho jabesi agane gemuoho jioruomoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Ae rahu ja vavu o vëmu nuninö bamoꞌi na dejonö bamevëꞌoho nasi a ma jioꞌiranoho bogo eni javoꞌajëjo. O ae rahu harihu o aboji nuninö bamoꞌi na dejonö bamevëꞌoho nasi a ma jioꞌiranoho bogo eni javoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Ae rahu ja bogo uvëꞌoho: Iesuare jöëni viꞌehe huë vavaene javoje rabe baeromo guomevëꞌoho iae hesi hö uvoromo bogo korosi hesi iꞌu banigojiomanovoromo nasi ijore ijore juvëꞌoho nasi ae jioꞌiranoho ja bogo eni javoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Ja jasi sinohuni uehorovoromo biririvoromo ave saꞌare hiꞌi ëhemu uehorovëꞌoho ijonöho guomo öriro vaꞌaꞌanuëjo. O ja nasi jöëni guomëꞌoho ijonöho maro hiꞌaꞌanuëjo. ");
INSERT INTO aom_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Jemëhu nasi jö majëhibe vaꞌëꞌiroho ae rahu jemë rajëhiromo baejëvëꞌoho ëhuro naꞌo rajehiromo baejevoruomaje höjo. O ae rahu na rajehiromo baejevëꞌoho ëhuro remöꞌöjamu rovode ahuꞌo rajahiruomaje höjo. ");
INSERT INTO aom_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Ae rahu uvëꞌoho: Ëaho jö God-aro baeromo majahuijaje ae höromo rajahiromo baejëꞌoho ëhuro jö God-aro baeromo majëhiruomaje ariböviehu suvuoro ujuoharue ëhi jiëꞌe suvuoroho God-are örire ujuohoruomoꞌajëjo. O ae rahu uvëꞌoho: Ëaho ma-mae höromo rajahiromo baejëꞌoho ëhi jiëꞌe a maehu suvuoro ujuoharuëhi ëhi ujuohoruomoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Ave jöho na jö mae uëꞌiëꞌajëjo. Ave nasi ijorajoho ae ma-biseꞌehu öꞌamu aehu garomo uvëꞌoho: Ëaho Iesuare ijore ijore juvaje ae höromo ma-bisemu ajamiromo enatuore jovo baguso bojamijëꞌoho ë aribövioho jaburo iae manaho ujuohoruomoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Iesuro hesi aribövie 12 jabesi örire jöho majëhinugoromo vaꞌadoho ë bëhire jioꞌamaje amore amore jöho majëhibe bëhoho röjëhibe juvadeje. ");
INSERT INTO aom_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Iae John bapataeto vaejaje ahuro savoji gagore hiromo hejade uavamu: Kerisoro muoho ëhi vaejaje hö uavamu hegorovo hesi ijorajoho rëmöꞌöromo uëvadeje: Vaꞌoromo ëhi ëhi Iesu ua garëjo. ");
INSERT INTO aom_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Ua garëjamu vaꞌoromo Iesu uavareje: No uvaruëjo: God-ro a böröme nugöꞌöꞌiramu nosi örire rueꞌaꞌajëjo. Na ja ë aho javajëjo. O na no muebeꞌejarëjo ae göëro rueröhego. ");
INSERT INTO aom_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Ëhi uavamu hegorovo Iesuro uëvadeje: Vaꞌoromo diehi hejarujoho gavarujoho John majahirego heꞌirajo. ");
INSERT INTO aom_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Uarëjo: Nöröro ae nuni sisëꞌoho ajëmijego mae uheriharue höjo. Höru sisëꞌoho ajëmijego mae jijiharue höjo. Jomoꞌe aho ajëmijego marëjëvoromo jabesirire sisë sisëho barëjëhaje höjo. Hiaꞌi sisëꞌoho ajëmijego hiaꞌe dadovoromo jöe hejarue höjo. Vuovëꞌe aho ajëmijego iꞌovarue höjo. Bogo eni jiëꞌe aribövioho ajëmiromo majëhijego God-are jö maho hejarue höjo. John ëhi majahirëjo. ");
INSERT INTO aom_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Röhu John o ae rahu biririvoromo nasi örire mae uehorovevëꞌoho ë ahuro maho hiꞌaꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Maho hiꞌaꞌajëjamu hegorovo vuonoröꞌö vaꞌareje. Vaꞌamu gavëꞌi Iesuro ë hesi bëhire gagovare aribövioho John-are jöho majëhiromo uëvadeje: Urimëꞌioho jemë rabe gaꞌirögoro John-hu a rumoꞌe saꞌare hijajiroho ëho vaꞌonövarije höjo. Ijo rudu burehu huosihego arue anume vaꞌaje ëhi uehorovaje aho na John ëhi jiëꞌe ae jiamu gaꞌi vaꞌarije höjo. Bogajo. ");
INSERT INTO aom_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","O diehi jiëꞌe aho gaꞌi vaꞌarije höjo. Na John niögu mabëhe sanuꞌe ioꞌamëꞌe ae jiamu gaꞌi vaꞌarije höjo. Röhu ëhi jiëꞌe niögu ma ioꞌamarue aribövioho bogo a rumoꞌe saꞌaroho raromoꞌi a masijehu raromarue osaremu raromarue höjo. ");
INSERT INTO aom_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Ëhi jiëꞌoho jemë rabëni a rumoꞌe saꞌaroho vaꞌarije höjo. Na John jö God-aro baeromo majëhijaje ae jiamu gaꞌi vaꞌarije höjo. Ioꞌajo. John iae hu ëhi jiëꞌe ae höjo. Röhu aveho hehëjo. Jö God-aro baeromo majëhinövare a ioroꞌioroho iosirëmiromo John hu börömoho höjo. ");
INSERT INTO aom_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Iae ë a hesi jöho God-are surire ëhi jajivoromo uvëꞌe höjo: Ave aho God nasi jö bajuvaje aho höjo. Ja vaꞌiëꞌiroho naro hu urimo nugöꞌöꞌiramu vaꞌoromo ae uëꞌaꞌajëjo jaehu vaꞌirane öroho iogorahoröhego. ");
INSERT INTO aom_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Ave jöho na jö mae uëꞌiëꞌajëjo. Ave saꞌare raromobe rovare aho ae gemu vaduꞌoho John bogo iosiramiromo börömoho jiëꞌe höjo. Aꞌi God-hu böröme namiromo muebejëvego hesi aharire raromarue a inino mahuro John iosiramiromo döroho jioruomajëjo. ");
INSERT INTO aom_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Urimo John bapataeto vaejavuaje aehu a jö majëhijadevare evare aëro aevoromo daruge ahoꞌo bojamiromo biririvoromo öroho jiovobe rueruomëꞌe höjo ëhuro God-ro böröme namiromo muebejëvego hesi aharire jëvoröhego. Jaruvoho ëhi gemuoho ëꞌoruomaje höjo. ");
INSERT INTO aom_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Aevoꞌioho Moses jögoru bojëmade ahuro God-hu böröme namiromo ae muebejëvoꞌiröhe jöho majëhijamu jö God-aro baeromo majëhibe rovare ariböviohuro ëhi gemuoho ëꞌobe rovaroho röhu ijo tugohoꞌioho John-ro ë jöho majëhijade höjo. ");
INSERT INTO aom_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Röhu urimo majëhiromo uënövare höjo: God-hu böröme namiromo muebejëvego gaꞌirarije ë hesi urimo ae gö rueꞌaꞌajëjo. Ëahuro Elijah-hu vaenövade mue gemuoho barueꞌajëjo. Jöho ëhi majëhinövare höjo. Röhu jemë mae uehorovoꞌi nëgëꞌoho uvorëjo: Elijah-are mu barueröhego uövuare aho iae John höjo. ");
INSERT INTO aom_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Ae rahu ja God-are jö hejanue ae javëꞌoho bëhoho nahoromo birohonëjo. ");
INSERT INTO aom_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Röhu jaruvore raromaruje aribövi jemesi jöho uhuꞌe majëhiꞌiëꞌajëjo. Amo ririre raromarue jö bijönimoruomaje asisöꞌoho jëvanovajëjo. Amo ririre raromoromo asisöꞌo ioroꞌiorohuro ioroꞌioroho uvëvoruomajëjo: ");
INSERT INTO aom_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","Noehu aninivoromo jemëni virikö huosihëharoho jemëro bijönimoromo bogo ejahuoromo javavarije höjo. Noehu aninivoromo huë vavaeniꞌe jö iaroho jemëro bijönimoromo bogo ejahuoromo nierusuburuꞌe bamarije höjo. ");
INSERT INTO aom_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Ëhesi bëhoho John-ro rueromo God uehorovoromo ma-hiꞌi ioho jovoho bogo inövade höjo. Ëhiꞌonövadoho jemëro ë jö bijönimarue asisöꞌoho vaꞌëne bijönëgamu John-are jöho bogo ejahoꞌi sisëꞌi uehorovoromo uvonövarije höjo: Aruꞌaho sisë dëre jiëꞌëro ëhuꞌëro ioho jovoho bogo ijaje höjo. ");
INSERT INTO aom_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","O God-are A Maho naro rueromo ioho jovoho ma-ijaje höjo. Ëhi ëꞌajoho jemëro ëhuꞌo bijönimoromo uvaruje höjo: Nörö gahëjo. Ioho mahunöꞌe iromo vöröꞌe jovemu ijaje höjo. Hu vajiohuꞌe tax baejarue ahuꞌo a sisë ioroꞌiorohuꞌo ëho jabesi aemoꞌaeme höjo. Jemëro John-are muohuꞌo nasi muohuꞌo bijönimaruje höjo röhu no God-are uehoro maho baejëꞌëro muoho vaejarue höjo. Ëmuoho aëro garomo uvoruomoꞌajëjo: God-are uehoroho iae mae höjo. Ëhuꞌëro muoho vaejare höjo. ");
INSERT INTO aom_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Ëhi uënugoromo ame gö gö birëgadeje ë hesi bëhoho urimëꞌi huhu a ajëmiromo darugoꞌe mu masijo vaebe ë amore amore juvamu jabuhu bogo huotorovoromo hu mae uehorovarohuni. Birëgoromo uëvadeje: ");
INSERT INTO aom_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Chorazinꞌo Bethsaidaꞌo amo rajohumë vaevëꞌoho jemë sisëro revo hesi jëvajëjo. Naro darugoꞌe muoho jemesi amore vaejego garomo röhu nasi jöho bijönimaruje höjo. Naehu darugoꞌe mu jemesi amore vaejodoho Tyre amore o Sidon amore vaejego gaꞌibejarëjo mami göꞌe jabesi sisëni huë vavaene baeromo niögu sisë ioꞌamoromo uonëro buerovoromo uehoro sisëho vuonugoꞌi uehoro mae baeruomoꞌibejajo. ");
INSERT INTO aom_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","God-hu iꞌu bojëmiꞌiröhe maja rovëꞌiroho Tyre o Sidon rajo jabuhu iꞌu baeꞌiröhoho ma-jianovoꞌi jemëro iꞌu börömo maho baeꞌaꞌarujëjo. Ëhuremu uehorovorëjo. ");
INSERT INTO aom_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Röhu Capernaum amo rajohumë jemëro jemesi sivue uehorovoromo uvaruje höjo: Nosi ihoho öꞌidöre ajiomoꞌajëjo. Bogo ëhioho jioꞌi saꞌaro beꞌaꞌajëjo. Ëhesi bëhoho naro darugoꞌe muoho jemesi amore vaejego garomo röhu nasi jöho bijönimaruje höjo. Naehu darugoꞌe mu jemesi amore vaejodoho Sodom amore vaejego gaꞌibejarëjo mu sisëho vuonugoꞌibejarëjo ëhuro jabesi amoho bogo sisërëꞌi jaruvoho ëhi mae jioꞌibejajo. ");
INSERT INTO aom_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","God-hu iꞌu bojëmiꞌiröhe maja rovëꞌiroho Sodom rajo jabuhu iꞌu baeröhoho ma-jianovoꞌi jemëro iꞌu börömo maho baeꞌaꞌarujëjo. Ëhuremu uehorovorëjo. ");
INSERT INTO aom_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Iesuro ëhi uënugoromo evare God uavadeje: Apo ja öꞌidörohuꞌo saꞌarohuꞌo muebejanue ae javajëjo. Naro jasi örire huë mae uavajëjo. Rabëni hesi bëhoho jero gavane nuni ajiꞌe a masijohuro uvoruomamu: Nosi simanoho mae javuoromo bövie biseꞌe ga barëjëꞌe javuajë uvamu gëgorovo jero jasi jöho jabesi örire subivëhëꞌe javajëjo. Aꞌi gavane bogo gavëꞌe ariböviohuro bogo döroho bamorovoꞌi jöho heꞌi nëgamu gëgorovo jero jasi jö bëhoho röjëhijëꞌe javajëjo. ");
INSERT INTO aom_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Apo iae mae höjo. Jero jasi nimoromo ëꞌane höjo. ");
INSERT INTO aom_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","God ëhi uanugoromo ë aribövioho uëvadeje: Nasi Vavuohuro jöe ahoꞌo bojemijëꞌe höjo muebeꞌirodego. Vavuohuro gemuëro Harihoho na avoho gevaje höjo. Harihoho naremuëremu Vavuoho avoho gavaje höjo. O Harihu naehu di aribövi röjëhiꞌi negëꞌohuro ëhuro ë ariböviohuremu röjëhijego jabuꞌo Vavuoho gavarue höjo. ");
INSERT INTO aom_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Röhu jemë ae rahu sivohoromo iꞌuꞌe mu vaejamu uꞌuvëvëꞌoho ruerego naro jemesi dë vövöbajoꞌoho sasohëhoꞌiröjo. ");
INSERT INTO aom_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Na sanuꞌe mae jevëꞌe jiaje ëhuni nasi muoho banigojiomoromo nasi jöho henövorëjo. Ëhi ëꞌëꞌoho jemesi dë vövöbajoꞌoho ma-mabëhe sasohëvoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Rabëni hesi bëhoho nasi muoho iꞌuoho bogojioꞌi sase höjo. ");
INSERT INTO aom_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Ëhiꞌoromo Jew rajo jabesi nuho majaho rovamu gagorovo Iesumëro mure jijihareje. Jijihoromo hesi ijorajo ömoꞌömohuro hömëvamu ioho babovoromo ueꞌahobe vaꞌareje. ");
INSERT INTO aom_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Babovoromo ueꞌahobe vaꞌamu gagorovo Pharisee ariböviëro Iesu uavareje: Asëꞌe jaruvoho nuho majae höjo. Jasi ijorajo ömoꞌömehu i avoharuoho ëho nuho maja hesi jögoroho aharuëjo. ");
INSERT INTO aom_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Aharuëjamu Iesuro uëvadeje: David nosi a böröme jionövade höjo. Röhu huꞌo hesi ariböviohuꞌo jabumë hömëvamu hegorovo huhu ëꞌade jö God-are surire adaharijoho ëho diehiꞌoromo bogo avoho uehorovarujëjo. ");
INSERT INTO aom_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","David-ro God-are osa mare vaꞌade höjo. Vaꞌoromo God-are nunire bahijare ioho huꞌo hesi ariböviohuꞌo ueꞌahare höjo. Ëioho bogo Davidꞌo hesi ariböviohuꞌo ueꞌahoꞌiröhoho jioꞌi hesi ma-priest-ëremu ueꞌahoꞌiröhe ie jiade höjo. Röhu jabuhu ueꞌaharohuro ëhuro jögoroho ahare höjo. Röhu ë hesi jöho bogojiade höjo. ");
INSERT INTO aom_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Ave jöhuꞌo Moses-hu jögoru surire jajivadoho jemë diehiꞌoromo bogo avoho adaharije höjo. Nuho maja rovëꞌiroho priest ariböviohuro God-are osa börömo hesi muoho vaeromo ëhuro nuho maja hesi jögoroho ahoruomaje höjo. Röhu God-are osa börömo hesi muoho vaejaruëro jiëꞌëro ëhuꞌëro jöho bogojiajëjo. ");
INSERT INTO aom_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Naro jemë uëvajëjo: Mu iꞌëro aviae rueromo God-are osa börömo hesi muoho iosiramijëꞌe höjo. Ëhuni nasi ariböviehu i babovoromo ueꞌaharuoho jöho bogohöjo. ");
INSERT INTO aom_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","God-are surire jöho jajivoromo uvëꞌe höjo: God-ro uvajëjo: Na negajëjo a huë baeꞌirarije muoho vaejöro mi suvuoroho bogajo. Ëjö hesi bëhoho avoho heꞌibejarijëjo ave övo unoꞌe aribövioho bogo uëꞌibejarijëjo: Mu sisë ëꞌëꞌe jëvajëjo. ");
INSERT INTO aom_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","God-are A Maho naro nuho maja hesi jögoroho muebejaje höjo. ");
INSERT INTO aom_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Iesuro ëhi uënugoromo vaꞌadeje. Vaꞌoromo Jew rajehu God rajahijarue osare rumo vaꞌadeje. ");
INSERT INTO aom_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Amo ë osare övo hitahi guomahëꞌe aho ë hijëꞌe jiadeje. Hijamu gagorovo aëro ë raromëꞌëro uehorovoromo uvareje: Ëꞌego noro Iesuare jö sisëho nahoromo jögoru muebejarue aribövioho majëhijarëromo Iesu uavareje: Nuho majare a jabesi sino ajëmijëꞌoho na ëhuro no nosi jögoroho aharue höjo o bogajo. ");
INSERT INTO aom_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","O bogajamu Iesuro uhuꞌe uëvadeje: Jemë ae gemu sheep gemu javëꞌoho röhu nuho majare guare bevaꞌëꞌoho na ja ajamiromo io bamonëjo o bogajo. Ioꞌajo. Nuho majaroho iae io bamoꞌanuëjo. ");
INSERT INTO aom_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Röhu sheep-oho ma-jianovoꞌi aho börömo mae höjo. Ëhuni nuho majare a ajëmijëꞌoho iae mae höjo. ");
INSERT INTO aom_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Iesuro ëhi uënugoromo ë övo guomahëꞌe aho uavadeje: Jasi övoho nugöꞌöjëjo. Ëhi uavamu hegorovo övoho nugöꞌöjamu marëromo övo gö jiajëhi ëhi jiadeje. ");
INSERT INTO aom_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Mae jiamu gagorovo Pharisee ariböviohuro vaꞌoromo Iesu anoröhe jöho mevoruomadeje. ");
INSERT INTO aom_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Iesu anoröhe jöho mevaruë uvamu hegorovo Iesuro ë amore jioromo vaꞌadeje. Vaꞌamu gagorovo ae ahoꞌobëhe hu rihiromareje. Rihiromamu huro guomo guomoꞌe aribövioho ahoꞌo ajëmamu mae jëvadeje. ");
INSERT INTO aom_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Mae jëvoꞌego uënövadeje: Naehu jemë ajëmijode jöho bogave aho uëꞌirarijëjo. ");
INSERT INTO aom_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Ëhi uënövade jö hesi bëhoho jö God-aro baeromo majëhinövade ae Isaiah-hu jajivadëhi ëhi jioröhego. Isaiah-ro God-are surire jajivoromo ëhi uvadeje: ");
INSERT INTO aom_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Naehu baejëꞌëro mu vaejaje aho gahëjo. Nasi dë vövöbajoꞌe ahoꞌo uehorovego dë mae jevaje aho aviae höjo. Naro nasi Aruꞌahoho hesirire bamahoꞌejöjo. Bamahoꞌiramu ae ahoꞌobëhe dinöꞌe dinöꞌe raromaruoho huro nasi mu ma hesi jöho majëhiꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Hu bogo giagiavoromo darugoꞌoho uvoꞌaꞌajëjo. Aho hesi huëho amo ririroho bogo heꞌaꞌaruëjo. ");
INSERT INTO aom_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Ijo adehu aho buꞌöjanovoꞌiëꞌiroho hu bogo ahöꞌöꞌajëjo. Irehu duorohanovoꞌiëꞌiroho bogo duohoꞌaꞌajëjo. Ëhi ëꞌobe vaꞌojuvo hujeji evare hesi mu mahuro ruahöꞌöjëvoromo dö maro jioꞌaꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Ëhi jioꞌiramu ae ahoꞌobëhe dinöꞌe dinöꞌe raromaruohuro hu uehorovoromo uvoruomoꞌajëjo: Iae huro gemuëro ajamuiꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Ëhiꞌamu aëro ae gemu huꞌirae baeromo rovareje. Ëaho Satan-are a sisëro dëre abo hijëꞌëro ëhuꞌëro nune tugohahoromo bitare tövahëꞌe jiadeje. Ëaho huꞌirae baeromo rovamu gagorovo Iesuro a sisë dëre jiajoho rarovöꞌöjamu bitaroho nunoho mae jioromo jöe jövoromo uherihadeje. ");
INSERT INTO aom_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Ëhi ajamamu gagorovo ae ahoꞌobëhe jioduduꞌiraeromo uarovareje: Ave aho na hu a böröme David-are uje no ajamuiꞌiröhe aho höjo. O rahuo höjo. ");
INSERT INTO aom_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Ëhi atoruomamu hegorovo Pharisee ariböviohuro uëruomadeje: O bogo ëhi jiëꞌe a maho jioromo ëꞌaje höjo. Aꞌi Beelzebul aruꞌaho sisë jabesi börömohuro vöröho bojamego ëhuro a dëre aruꞌaho sisëho rarovöꞌöꞌamaje höjo. ");
INSERT INTO aom_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Ëhi uëruomamu Iesuro gëromo uvadeje: Ëariböviohuro nasi jöho ëhi uehorovaruëromo uhuꞌe uëvadeje: Saꞌae gemuehu adovoromo jabesi arijoꞌarije muorovëꞌoho barërovoꞌajëjo. Ame gemuehu o agane gemuehu adovoromo jabesi arijoꞌarije muorovëꞌoho bogo biririvoꞌi barërovoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Ëhuni Satan-ro riꞌöromo hesi aribövi a jabesi dëre jioꞌamajoho rarovöꞌöjëvoꞌibejajo ëhuro hesi ariböviohuꞌo muorovoꞌibejajo hesi darugoho muoho uehoroho diehiꞌoromo biririvoromo namiꞌibejajo. ");
INSERT INTO aom_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Röhu jemëro uvarujëjo: Sisë a börömohuro nörö vöröho bojamego hesi sisë aribövioho rarovöꞌöꞌamaje höjo. Ëhi jiëꞌoho na jemesi ariböviohuro sisë a börömo hesi vöröho baeromo rarovöꞌöꞌamarue höjo. O diehiꞌoromo ëꞌarue höjo. Jaburo uëꞌaꞌaruëjo: Sarerivarujëjo. Aho bogo sisë a börömo hesi vöröho baeromo ëhioho ëꞌarue höjo. ");
INSERT INTO aom_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Aꞌi naro God-are Aruꞌaho hesi darugoho baeromo rarovoꞌamaje höjo. Ëhuni uvorëjo: God-ro aevoromo böröme namiromo nosi örire muebejavuajëro jiëꞌëro ëhuꞌëro ëꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Röhu aehu darugoꞌe a hesi osare rumo vaꞌoromo hesi mae sisë ujuohaho vaꞌiëꞌiroho bogo ëma ujuohaho vaꞌirögoro urimo darugoꞌe aho guduamoromo tövonugoromo evare hesi inömo inömoho ujuohaho vaꞌaꞌajëjo. Naro Satan ëhi ruahöꞌöjaje höjo. ");
INSERT INTO aom_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Ae rahu bogo nasi a jiëꞌoho ëho huro naꞌo muorovaje höjo. O na bogo ajemiromo nasi aribövi gagovëꞌoho ëho huro arua anumiae nugöꞌöꞌamaje höjo. ");
INSERT INTO aom_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Ëhuni uëvajëjo: Aehu mu sisë vaejëꞌoho God-are iho ijumarue jö sisë atëꞌoho ahoꞌo God-ro uehorovoromo vuonugëhoꞌajëjo. Aꞌi God-are Aruꞌaho hesi iho ijumëꞌoho ëhi jiëꞌe jö sisëho God bogo uehorovoromo vuonugoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","God-are A Ma nasi jö sisëꞌi atëꞌoho God-ro uehorovoromo vuonugoꞌajëjo. Aꞌi God-are Aruꞌaho hesi jö sisëꞌi atëꞌoho ëho God bogo uehorovoromo vuonugoꞌajëjo jaruvo majahuꞌo maja ijohuꞌo. ");
INSERT INTO aom_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Ijo bajo mae uroꞌi nagëꞌoho ijo ma hesi bajoho uroꞌaꞌanuëjo. O ijo sisë javëꞌoho bajo sisë uroꞌaꞌanuëjo. Ijoho bajoro garomo uvoꞌaꞌanuëjo: Ëijoho mae höjo ëho sisë höjo. ");
INSERT INTO aom_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Sigobu aboji harihuꞌe jëvanovajëjo. Ijo sisë vaꞌëne jëvëꞌoho jemë diehiꞌoromo ijo bajo manöꞌe raeromo jö mae atorëjo. Bogo eni jëvajëjo. Uehoro maehu o uehoro sisëhu dë vövöbajoꞌere rarovëvajoho ëhi jiëꞌe jöho jöꞌëro atarue höjo. ");
INSERT INTO aom_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","A maho uehoro maëremu jëvëꞌëro jö maemu atarue höjo. A sisëho uehoro sisëremu jëvëꞌëro jö sisëmu atarue höjo. ");
INSERT INTO aom_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Naro jemë uëvajëjo: Jö sisë rabe rabe ëma atëꞌoho mevëvo gëröhe majaho rueꞌiramu God-ro uëꞌaꞌajëjo: Ëjöho rabëni atarije hö uëꞌiramu mana uaꞌaꞌarujëjo. ");
INSERT INTO aom_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Ae gemu gemu jasi jöre garomo uaꞌaꞌajëjo: Ja a mae javajëjo. O jasi jöre garomo uaꞌaꞌajëjo: Ja a sisë javajëjo. ");
INSERT INTO aom_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Ëhi jövamu hegorovo Jew rajo jögoru öri röjëhijarue ae gö gö o Pharisee ae gö gö ëho jaburo riꞌöromo uavareje: Tisa no naguajëjo gaꞌi jero darugoꞌe muoho vaejego ëhuro uvoꞌiröhëro: Ja daruge God-aro baeromo muoho vaejanue höjo. ");
INSERT INTO aom_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Vaejanue höjamu uëvadeje: Sareriꞌe aribövi sisë jëvajëjo. Magonahehu hesi baru vuonugoꞌi ma-juvajëhi jemëro ëhi God vuonugoꞌi mue gö gö uehorovaruje höjo. Jemë rabëni darugoꞌe muoho gaꞌi nimarujëjo. Na ëhi jiëꞌe muoho bogo vaeꞌi aꞌi jö God-aro baeromo majëhinövade ae Jonah-hu God-are mu börömo röjëhijade ëhi jiëꞌe muohuremu röjëhiꞌejöjo. Mue gö gö bogajo. ");
INSERT INTO aom_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Jonah-are mu börömo hesi bëhoho jovo mi börömohuro Jonah nimuꞌöjamu abueromo hesi dëre hijade höjo. Hiromo majae niöꞌi gemu vahie niöꞌi gemu hesi uhure ëgubijiohamu höröjade höjo. Höröromo rovadëhi God-are A Maho naro saꞌa gagore abo hiromo majae niöꞌi gemu vahie niöꞌi gemu hesi uhure höröromo rueꞌejöjo. ");
INSERT INTO aom_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Nineveh amo rajohuro ave jaruvore raromaruje ariböviohuꞌo gemu mae riꞌöromo God-are nunire riravoruomoꞌajëjo. Riravoꞌiramu God-ro jabesi mu maho garomo jemesi mu sisëho garomo jemë uëꞌaꞌajëjo: Nineveh amo rajehu vaejare ëhi jiëꞌe mu maho bogo vaejëꞌego ëhuni na uëvajëjo: Jemë sisëꞌe aribövie jëvaje sisëro vaꞌohëjo. Ëhesi bëhoho ë Nineveh amo rajohuro mu sisë vaeruomëꞌëro hejare Jonah-ro God-are jöe majëhijamu hegorovo jabesi uehoro sisëho vuonugoꞌi uehoro mae baejare höjo. Jonah ma-biseꞌo jioromo jö majëhijadoho Nineveh amo rajohuro hesi jöho ejahare höjo. Aꞌi naehu hu iosiramiromo börömo jioromo jö majëhijajoho jemë bogo ejeharuje höjo. Ëhuꞌëro jiëꞌëro mevo gëröhe majaho rueꞌiramu jemë sisërëjëvoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","O ëho majaho rueꞌiramu arue saꞌa göre börömo vaenövade magonahohuro ave jaruvore raromaruje ariböviohuꞌo gemu mae riꞌöromo God-are nunire namiꞌaꞌajëjo. Namiꞌiramu God-ro saꞌa gö rajo magonaho hesi mu maho garomo jemesi mu sisëho garomo jemë uëꞌaꞌajëjo: Ëmagonahehu vaejade ëhi jiëꞌe mu maho bogo vaejëꞌego ëhuni na uëvajëjo: Jemë sisëꞌe aribövie jëvaje sisëro vaꞌohëjo. Ëhesi bëhoho ë saꞌare börömo vaenövade magonahohuro hesi saꞌaho vuonugoꞌi öri ëgoböviro rovade höjo a böröme Solomon-hu nuni ajiꞌe jö jövajoho heꞌiro. Solomon-hu ae ma-bisemu börömo jioromo jö majëhijajoho ë magonahohuro heꞌi nimade höjo. Aꞌi naehu Solomon iosiramiromo börömo mae jioromo jö majëhijajoho heꞌirarijoho jemë bijönëgajëjo. Ëhuꞌëro jiëꞌëro mevo gëröhe majaho rueꞌiramu jemë sisërëjëvoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Röhu Satan-are mu ajamijaje aruꞌaho sisëhuro ae gemu hesi dëre hiꞌaꞌajëjo. Hiromo hörö vaꞌaꞌajëjo. Vaꞌoromo jovo rumoꞌe saꞌare vaꞌoromo hiꞌiröhe röhoho nahobe juvojuvo bogo birohogorovo ");
INSERT INTO aom_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","uvoꞌaꞌajëjo: Na vuonoröꞌö vaꞌoromo hijode sionore röhu maho ë hiꞌejöjo. Ëhi uvonugoromo vuonoröꞌö vaꞌoromo urimo hijade a hesi dëre abueromo gaꞌaꞌajëjo dë vövöbajoꞌoho gagemu jioꞌi bibivoromo iogorëꞌe ma-mabëhe osa vaꞌëne jioꞌiramu. ");
INSERT INTO aom_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Ëhi jioꞌiramu gagorovo vaꞌoromo Satan-are aruꞌaho sisë ahoꞌobëhe söromo rueꞌaꞌajëjo. Ëurimore ro hijade aruꞌahoho a sisë höjo. Ijore huhu sö rovade ariböviohuro hu iosiramiromo jabumë sisë bëhi mae jioruomajëjo. Ëhuꞌëro urimo sisëꞌi hijade aho ijonöho sisë bëhe hiꞌaꞌajëjo. Jaruvore raromaruje aribövi sisëho jemë ëhi sisërëjëvoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Ëhi jövamu evare hesi vëmohuꞌo ö ömoꞌömohuꞌo jaburo Iesuꞌo jöe atoꞌi nëgamu rueromo amonö riravareje. ");
INSERT INTO aom_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Riravamu ae gemuëro riꞌöromo Iesu uavadeje: Hë-ajo. Jasi vëmohuꞌo ö ömoꞌömohuꞌo jaꞌo jöe atoꞌi nimoromo amonö riravaruëjo. ");
INSERT INTO aom_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Riravaruëjamu Iesuro uavadeje: Ja uehorovanuoho nasi vëmoho nasi ö ömoꞌömoho di aribövioho jioruomajëjo. ");
INSERT INTO aom_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Ëhi uanugoromo hesi ijore ijore jijiharue aribövioho övëro röjëhijadeje ae ahoꞌobëhe jaburo gëjöro. Hesi aribövioho röjëhiromo ae ahoꞌobëhe uëvadeje: Aruëroho nasi vëmohuꞌo ö ömoꞌömohuꞌo jëvajëjo. ");
INSERT INTO aom_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Ae rahu nasi Vavue öꞌidöre hijaje aehu nimajëhi ëhi ëꞌëꞌoho ëhuro ë aribövioho nasi öe maꞌine vëme jioruomajëjo. ");
INSERT INTO aom_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Ëmajae gemuore Iesuro osare jioromo vaꞌoromo nume jovo eꞌu riröre abuejadeje. Abueromo God-are jö bëhoho röjëhiꞌi saꞌaro hijadeje. ");
INSERT INTO aom_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Hijamu ae ahoꞌobëhe ro tagavamu Iesu jovore boat gagore vaꞌo hiꞌi ae ahoꞌobëhe jovo riröre riravareje. ");
INSERT INTO aom_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Riravamu Iesuro uhu jöe majëhiromo ëhuro jöe ahoꞌobëhe röjëhijadeje. Röjëhiromo uëvadeje: Iae ae gemuëro i uje ujuohoromo mure riremoꞌi vaꞌade höjo. ");
INSERT INTO aom_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Riremobe vaꞌamu ujo ioroꞌioroho örire rireromade höjo. Rireromamu gavëꞌi ugëro ro i barëjare höjo. ");
INSERT INTO aom_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Ujo ioroꞌioroho munë uhunö jiëꞌe saꞌare rireromade höjo. Rireromoromo ma-burëro riꞌamade höjo saꞌaho munë döro ma-bisemu jiëꞌëro. ");
INSERT INTO aom_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Riromo dirumoho bogo ma ioꞌamëꞌëro majaëro rojomoromo anamu sahoriꞌamade höjo. ");
INSERT INTO aom_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Ujo ioroꞌioroho bibëꞌe resu resuꞌe saꞌare rireromade höjo. Rireromëꞌëro bibëꞌe resuohuro riromo ujo maho babaꞌamade höjo. ");
INSERT INTO aom_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Ujo ioroꞌioroho saꞌa mare rireromade höjo. Rireromoromo riromo bajoho raeꞌamade höjo. Uje gemu gemu röhu ioroꞌioroho baje 100 raeꞌamoꞌi ioroꞌioroho 60 raeꞌamoꞌi ioroꞌioroho 30 raeꞌamade höjo. ");
INSERT INTO aom_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Ae rahu ja God-are jö hejanue ae javëꞌoho bëhoho nahoromo birohonëjo. ");
INSERT INTO aom_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Ëhiꞌamu Iesuare ijorajo ömoꞌömohuro rueromo Iesu uavareje: Ja ae ahoꞌobëhe jö majëhijëꞌiroho ja rabëni uhuꞌoho majëhijanue höjo. ");
INSERT INTO aom_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Rabëni uhuꞌoho majëhijanue höjamu uëvadeje: God-ro böröme namiromo ahoꞌobëhe muebejaje jöho urimoho subivëhade höjo. Ësubivëhade jöho huro hesi suvuore jemë bojëmijëꞌe höjo jemëremu heꞌi a ioroꞌioroho bogo heruomoröhego. ");
INSERT INTO aom_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Ëhesi bëhoho ajiꞌe jö javëꞌoho God-ro göꞌo bojamiꞌiramu baeromo bövi mae javoꞌajëjo. O bogojavëꞌoho bisemu baejanoho God-ro ë uehoroho muꞌuvahoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Ëhuni naehu uhu jöemu ë aribövi majëhijaje hesi bëhoho jabu gavaruoho bogo avoho gavarue höjo. Hejaruoho bogo avoho heromo simanoroho baejarue höjo. ");
INSERT INTO aom_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Jabumë ëhi jiëꞌe aribövie jioruomajëjo. Jabesi jöho mamiꞌe jö God-aro baeromo majëhinövade ae Isaiah-ro jajivoromo ëhi uvëꞌe höjo: Jemë hemu heꞌaꞌarujëjo röhu bëhoho bogo avoho heꞌaꞌarujëjo. Jemë gaemu gaꞌaꞌarujëjo röhu bëhoho bogo avoho gaꞌaꞌarujëjo. ");
INSERT INTO aom_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Ëaribövi jabesi dë vövöbajoꞌoho iꞌuhëgaje höjo. Hiaꞌoho tugohëhëꞌe höjo. Nunoho sigohijëhëꞌe höjo. Bogo ëhioho jëvoꞌibejajo nunëro gaꞌibejarëjo. Hiaꞌëro heꞌibejarëjo. Dë vövöbajoꞌoho sasohoromo jöho baeꞌibejarëjo ëhuro jabumë huotorovoromo rueꞌibejarëjo naro avohëvego mae jëvoꞌibejajo. ");
INSERT INTO aom_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Isaiah-hu jajivadëhi aribövi ioroꞌioroho ëhi jioruomaje höjo. Aꞌi jemë huë mae baejëꞌe jëvajëjo. Rabëni jemë nunëro garomo avoho gavaruje höjo. Hiaꞌëro heromo avoho hejaruje höjo. ");
INSERT INTO aom_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Ave jöho na jö mae uëꞌiëꞌajëjo. Jemë gavaruje muoho o hejaruje jöho urimëꞌi jö God-aro baeromo majëhinövare ariböviohuꞌo a ma ioroꞌiorohuꞌo ahoꞌobëhe jaburo nimoruomade höjo garomo heꞌiro. Röhu bogo garomo bogo heruomade höjo. ");
INSERT INTO aom_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Röhu aehu i ujo riremade uhu jö hesi bëhoho hehëjo. ");
INSERT INTO aom_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","God-hu böröme namiromo muebejëvaje jöho ae rahu hiaꞌëremu heromo bogo avoho hejamu gavëꞌoho a sisë börömohuro rovaje höjo. Rueromo gavaje God-are jöho i ujo vaꞌëne jabesi dëre jiego garomo baeniëhiromo roriꞌo buꞌöjaje höjo. Ujo örire rireromamu ugehu i barëjare jö hesi bëhoho ëhi höjo. ");
INSERT INTO aom_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","O i ujehu munë uhunö jiëꞌe saꞌare rireromoromo riromo sahoriꞌamade jö hesi bëhoho aëro God-are jöho heromo ma-burëro nimorohoromo jöho ejaharue höjo. ");
INSERT INTO aom_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Ejahoromo jöho ma-döëremu baejëꞌëro ëhuꞌëro majae ma-bunemu mae uehorovoromo garöhe God-are jö uehorovaruohuni aehu sisë vaejëvamu gavëꞌoho o huë vavaene rovamu gavëꞌoho ma-burëro vuonugarue höjo. ");
INSERT INTO aom_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","O ujehu bibëꞌe resu gemuore rireromade jö hesi bëhoho aëro God-are jöho hejarue höjo. Heromo ave saꞌa hesi muohuni nurunurumoromo o sarerivoromo uvarue höjo: Inöme bövie biseꞌe masije höromo jabesi nuninö bamarue höjo. Bamoromo saꞌarohemu uehorovaruohuro ëhuro God-are jö jabesi dëre jiajoho taemego jabumë bogo rae avoharue höjo. ");
INSERT INTO aom_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","O ujehu saꞌa mare rireromoromo baje 100 o 60 o 30 raeꞌamade jö hesi bëhoho aëro God-are jöho heromo avoho hejarue höjo. Avoho heromo rae avoharue höjo. Ioroꞌiorohuro ioroꞌioroho iosirëmiromo mu ma-mabëhe vaejarue höjo. ");
INSERT INTO aom_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Iae Iesuro uhu jöe göꞌo majëhijadeje. Majëhiromo uëvadeje: Ae gemuehu ujo ma riremoromo ëꞌadëhi God-ro böröme namiromo hesi öri ariꞌoho ëhi muebejaje höjo. Ae gemuëro mure vaꞌoromo irunoꞌe ujo maho riremobe vaꞌade höjo. ");
INSERT INTO aom_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Ëhi ëꞌëꞌëro ae ahoꞌobëhe momoröꞌöjëꞌe jiamu gagoro mu arijoꞌohuꞌo muorovaje ae gemuëro mure rovade höjo. Rueromo i vaꞌëne resu sisëho i ujo riremadire ë riremonugoromo vaꞌade höjo. ");
INSERT INTO aom_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Ëhi ëꞌëꞌëro irunoꞌoho riromo baje raejamu gavëꞌi resu sisëhuꞌo riromo raeꞌamade höjo. ");
INSERT INTO aom_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Resu sisëhuꞌo raeꞌamamu gagorovo mu arijoꞌo hesi mu vaejarue ariböviohuro rueromo uavare höjo: Asëꞌe ja ujo mae jasi mure riremane höjo. Diehiꞌoromo resu sisëhuꞌo rijade höjo. ");
INSERT INTO aom_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Uëvade höjo: Naꞌo muorovaje ahuro ëꞌade höjo. Ëꞌade höjamu uavare höjo: Ëhi jiëꞌoho na ja nagajëjo no vaꞌoromo resu sisëho ravojöro. ");
INSERT INTO aom_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Uëvade höjo: Bogajo. Jemëro resue ravoꞌihöromo irunoꞌohuꞌo ravoꞌamojöëni bogo ëhioho ëꞌaꞌarujëjo. ");
INSERT INTO aom_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Ëhuni irunoꞌohuꞌo resuohuꞌo nugego ëhi gemu mae riꞌirajo gagovoꞌiröhe majaho rueꞌiröhe höjo. Ëmajaho rueꞌiramu irunoꞌe gagovarue aribövioho naro uëꞌejöjo: Urimo resuoho ravoromo huhohoꞌamorëjo vëniro huoꞌirarije. Amo evaro irunoꞌoho gagovoromo ujuoho vaꞌoromo nasi irunoꞌo osaro bahirëjo. ");
INSERT INTO aom_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Röhu uhu jöe göꞌo majëhiromo uëvadeje: Ijo hisu ihe mustard ujehu börömoriromo ëgovajëhi God-ro böröme namiromo ae göꞌo göꞌo ëhi gagovoromo muebejëvobe vaꞌaꞌajëjo. Ae gemuëro mustard ijo hisu uje gemu baeromo hesi mure öjade höjo. ");
INSERT INTO aom_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Röhu bajo ioroꞌioroho ma-jianovoꞌamoꞌi aꞌi ë mustard ujoho biseharihe höjo. Ëhi höjo röhu riromo ëgovoromo ijo hisu ioroꞌioroho iosiramiꞌamoromo ijo vaꞌëne jiaje höjo. Ijo vaꞌëne jiego ugëro rueruomoromo ë ijo hesi adore ijue vaeꞌamarue höjo. ");
INSERT INTO aom_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Ëhi majëhinugoromo uhu jöe göꞌo majëhiromo uëvadeje: God-hu böröme namiromo muebejëvaje öroho aviëhi höjo. I dë huaje osehu ire rumorovajëhi God-hu böröme namiromo muebejëvaje muohuro saꞌae ahoꞌo ëhi rumorovobe vaꞌaje höjo. Magonahe gemuëro ie ahoꞌobëhe gagovoromo i dë huaje osoho i gemuore bamoromo iohuꞌo buarohade höjo. Buarohamu ë ioho ahoꞌobëhe rumorovo barëjade höjo. ");
INSERT INTO aom_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Ëjöho ahoꞌobëhe Iesuro uhuꞌe majëhijamu rue gagovare ariböviohuro hejareje. Jöe ahoꞌo ma-uhuꞌe gemu majëhinövadeje. ");
INSERT INTO aom_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Ëhi uhuꞌe majëhijade jö hesi bëhoho urimo jö God-aro baeromo majëhinövade ae gemuëro Iesuhu vaeꞌiröhe mu jöho God-are surire jajivoromo uvadeje: Naro uhuꞌe majëhinövoꞌejöjo. Öꞌidö saꞌa bamadevare evare aevoromo subivëhobe rovade jöho na jövonövoꞌejöjo. ");
INSERT INTO aom_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Ëhiꞌonugoromo gagovarue aribövioho rëmoꞌi osare vaꞌadeje. Osare vaꞌamu gagorovo hesi ijorajo ömoꞌömohuro rueromo uavareje: I vaꞌëne resu sisëhu i mure riꞌamade jöho huruoho majahuijego no hejarëjo. ");
INSERT INTO aom_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Hejarëjamu uëvadeje: Ujo ma riremade a hesi jö bëhoho uëromo ëꞌode höjo: God-are A Maho nörö höjo. ");
INSERT INTO aom_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","I mu hesi jö bëhoho uëromo ëꞌode höjo: Saꞌae ahoꞌobëhe dinöꞌe dinöꞌe jiobe vaꞌajëjo. I ujo hesi jö bëhoho naro uëromo ëꞌode höjo: God-hu muebejëvego hesi aharire raromarue aribövie jioruomajëjo. I vaꞌëne resu sisë hesi jö bëhoho naro uëromo ëꞌode höjo: A sisë börömo hesi aribövie jioruomajëjo. ");
INSERT INTO aom_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Mu arijoꞌo nu huodivoromo resu sisë hesi ujo riremade a hesi jö bëhoho naro uëromo ëꞌode höjo: Satan höjo. I gagovoꞌiröhe maja hesi jö bëhoho naro uëromo ëꞌode höjo: Ave saꞌa bövi biseꞌo barëꞌiröhe majaho höjo. I gagovoꞌiröhe aribövi jabesi jö bëhoho naro uëromo ëꞌode höjo: Anera aribövioho jioruomajëjo. ");
INSERT INTO aom_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Resu sisë gagovoromo vëniro huaruëhi saꞌa bövi biseꞌo barëꞌiröhe majaho rueꞌiramu ëhi jioꞌaꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Ëho majaho rueꞌiramu evare God-are A Maho naro nasi anera aribövioho rëmöꞌöꞌiramu jabumëro rueruomoꞌajëjo. Rueruomoromo mu sisë röjëhijarue o God-are jö aharue aribövi God-hu muebejëvajoho mevoromo ");
INSERT INTO aom_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","vëni börömehu ravajire ruruhöꞌöruomoꞌajëjo. Ëdiröꞌore ae ahoꞌobëhe nierusuburuꞌe bamoromo ane jaꞌiho vuogigimoruomoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Ëhi ëꞌiramu evare mu mae vaejarue ariböviohuro jabesi Vavuehu muebejaje öri ariꞌere raromoromo majaehu bamoromo ajivajëhi ëhi ajivoruomoꞌajëjo. Ae rahu ja God-are jö hejanue ae javëꞌoho bëhoho nahoromo birohonëjo. ");
INSERT INTO aom_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Röhu God-hu böröme namiromo muebejëvaje jö göho uhuꞌe uëꞌiëꞌajëjo. Ae gemuehu gurihi nugëꞌe inömo mabëhi birohoromo ëhuremu gemu uehorovadëhi God-hu böröme namiromo muebejëvaje jö ëhuremu ëhi uehorovoꞌirarije jöho höjo. Ae gemuëro ae gö hesi mure juvoꞌi gavade höjo inömo ma-mabëhe gagovoromo gurihi nugëꞌe jiamu. Gurihi nugëꞌe jiamu gagorovo huro ujuohoromo röhu maho gurihiromo duhade höjo. Duhonugoromo ë inömohuremu uehorovoromo nimorohëꞌi vaꞌoromo hesi maho sisëho ahoꞌo imoꞌamo barënugoromo ijo bajo bövi mae baeromo vuonoröꞌö vaꞌoromo gurihi nugëꞌe inömoho baeꞌi ë muoho imade höjo. ");
INSERT INTO aom_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","O aehu nienia mabëhe ëhemu uehorovadëhi God-hu böröme namiromo muebejëvaje jö ëhemu ëhi uehorovoꞌirarije jöho uhuꞌe uëꞌiëꞌajëjo. Nienia imoꞌamaje ae gemuëro nienia mabëhe imoꞌamoꞌi nahobe juvade höjo. ");
INSERT INTO aom_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Nahojuvo nieniae gemu ma-mabëhoho birohade höjo. Birohonugoromo ë nieniahuremu uehorovoromo vaꞌoromo hesi maho sisëho imoꞌamo barënugoromo ijo bajo bövi mae baeromo vuonoröꞌö vaꞌoromo ë nieniaho gemu imade höjo. ");
INSERT INTO aom_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Röhu God-hu böröme namiromo muebejëvaje jö göho uhuꞌe uëꞌiëꞌajëjo. Aëro viö böröme jovo eꞌure baꞌamare höjo. Baꞌamamu jovo maje ihe gö gö viöre aegade höjo. ");
INSERT INTO aom_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Aegoromo irijiomamugo evare jovo riröre bavaꞌoromo raromare höjo. Raromoromo jovo majo maho suovoromo hevöre ioꞌamoꞌi sisëho ruruhöꞌöjare höjo. ");
INSERT INTO aom_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Ëjö hesi bëhoho ave saꞌa hesi majaho barëꞌiramu ëhi jioꞌaꞌajëjo. Aneraëro rueruomoromo a maho ëhi rëmoꞌi a sisëho mevoromo ujuohoromo ");
INSERT INTO aom_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","vëni börömehu ravajire ë ruruhöꞌöꞌaruëjo. Ëdiröꞌore ae ahoꞌobëhe nierusuburuꞌe bamoromo ane jaꞌiho vuogigimoruomoꞌajëjo. Ëhi jioꞌaꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Röhu naehu majëhijode jöho ahoꞌo na jemë he barëjarije höjamu uavareje: Ioꞌajo. ");
INSERT INTO aom_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Ioꞌajamu Iesuro uëvadeje: Ëhuꞌëro God-are jögoru mami öri röjëhijaje ae rahu God-hu böröme namiromo muebejëvaje jö iꞌohuꞌo ëhuꞌo hejëꞌoho inömo mamiohuꞌo iꞌohuꞌo hesi osare jiaje aho vaꞌëne jianovajëjo. Ëhi jiëꞌe aehu inömo mamiohuꞌo iꞌohuꞌo bahijaje osare jioꞌamajoho vaꞌorahoro ujuoho rueromo röjëhijajëhi ëhi jiëꞌe ariböviohuro God-are jö mamiohuꞌo iꞌohuꞌo ae röjëhiruomoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Ëhi jiëꞌe uhu jöho majëhinugoromo Iesuro vaꞌadeje. ");
INSERT INTO aom_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Vaꞌoromo hesi amëro rovadeje. Rueromo hiromo God rajahijarue osare rumo vaꞌoromo God-are jö bëhoho röjëhijadeje. Röjëhijamu hegorovo tiöjëvadeje. Tiöromo uvoruomadeje: Diehiꞌoromo simano maho baeromo darugoꞌe mu masijoho vaejaje höjo. ");
INSERT INTO aom_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Hu sarerivajëjo. Ma-ijo muemu vaejaje a hesi harihe höjo. Hesi vëmoho Mary höjo. Hesi ö ömoꞌömoho James Joseph Simon Judas ëhi jioꞌamajëjo. ");
INSERT INTO aom_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Hesi maꞌino ömoꞌömoho ahoꞌo noꞌo gemu mae raromarue höjo. Ëhi jiëꞌoho diehiꞌoromo aviëhi jiëꞌe muoho baejade höjo. ");
INSERT INTO aom_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Ëhi uvoromo nue huodivareje. Nue huodivamu gëgorovo Iesuro uëvadeje: Jö God-aro baeromo majëhijarue aribövioho dinöꞌe dinöꞌe vaꞌëꞌiroho aëro no mae uehorovavuarue höjo. Aꞌi nosi saꞌa raje agane gemuoho jemëremu bogo ëhioho uehorovavuaruje höjo. ");
INSERT INTO aom_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Ëhi uënugoromo darugoꞌe muoho ma-gemu gemu ë vaejadeje amo rajoho bogo ma uehorovaruego. ");
INSERT INTO aom_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Ëhiꞌamu Iesuhu mu börömo vaejaje jöho saꞌa a böröme Herod-ro hejadeje. ");
INSERT INTO aom_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Herod-ro jöho heromo hesi mu vaejarue aribövioho uëvadeje: Ëaho John bapataeto vaenövade aho höjo. Hu guomoromo riꞌöjëꞌe höjo. Guomoromo riꞌöjëꞌëro ëhuꞌëro darugo böröme baeromo mu masijoho vaejaje höjo. ");
INSERT INTO aom_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Röhu ë jö hesi bëhoho urimëꞌi Herod-ro hesi öe Philip-are vabore hesi ihoho Herodias gohoniahijadeje. Gohoniahijamu John-ro riꞌöromo uaꞌi hijadeje: Ëmagonaho baejanoho ëho bogo maehu höjo. Ëhi uaꞌi hijamu Herod-ro ë magonaho hesi jöëni ae uëvamu John guduamoromo tövoromo savoji gagore baꞌamareje. ");
INSERT INTO aom_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Ëhiꞌamu Herod-ro John anoꞌi nimoromo röhu uvadeje: Ae ahoꞌobëhe uvoruomaje höjo: John hu jö God-aro baeromo majahuijaje ae hö uvarue höjo. Ëhi uvoromo ë aribövioho juhuonëmiromo bogo anadeje. ");
INSERT INTO aom_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Ëhiꞌojuvo Herod rahade majaho rovadeje. Herod rahade majaho rovamu Herodias-are abojohuro ae ahoꞌobëhe jabesi nunire rueromo javavadeje. Javavamu Herod-ro garomo vuëvadeje. ");
INSERT INTO aom_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Vuëvoromo magonahoho uavadeje: Ja rabe rabe nagëꞌoho iae na bojamiꞌejöjo. God-ro geꞌego na mae uavajëjo. ");
INSERT INTO aom_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Ëhi uavamu abojohuro vaꞌo vëmehu nimade jöho heromo rueromo Herod uavadeje: Bapataeto vaejaje ae John-are sönöho tarioromo simanoho hevöro bamoromo avehuro baro bojemëjo. ");
INSERT INTO aom_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Ëhi uavamu hegorovo rue a börömohuro huë vavaene baejadeje. Huë vavaene baejade höjo röhu urimo darugoꞌe jöho ë aribövi jabesi nuniro ë magonahoho mae uavëꞌëro ëhuꞌëro jöe bojëmiromo uëvadeje: Magonahehu nimajoho baro bojamihëjo. ");
INSERT INTO aom_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Bojamihëromo ae rëmöꞌöjamu savoji gagore vaꞌoromo John-are sönöho tarioromo ");
INSERT INTO aom_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","simanoho hevöre bamonugoromo barueromo abojoho bojamijareje. Bojamamu huro bavaꞌo vëmoho bojamadeje. ");
INSERT INTO aom_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Ëhiꞌamugo John-are ijore ijore jijiharue ariböviohuro rueromo sinoho bavaꞌoromo guavareje. Guavonugoromo vaꞌoromo Iesu majahijareje. ");
INSERT INTO aom_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","John bapataeto vaejëvaje a guomade jöho majëhijamu hegorovo Iesuro vaꞌoromo boat-re ajio hiromo a rumoꞌe saꞌare vaꞌi vaꞌadeje huꞌo hesi ariböviohuꞌo sivue raromoröhëni. Ëvaꞌaje jöho hegoro ae ahoꞌobëhe jabesi amore amore jioromo vaꞌoromo Iesuhu vaꞌajire saꞌa hörëro ë vaꞌoruomadeje. ");
INSERT INTO aom_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Vaꞌoruomamu Iesuro jovo döre boat-re vaꞌadoho saꞌare rueromo ravoꞌamoromo gavade ae ahoꞌobëhe tagavëꞌe jiamu gëgorovo jabesi jöëni vavaenimoromo jabesi aribövie guomo guomoꞌoho ajëmijadeje. ");
INSERT INTO aom_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Ëhiꞌojuvo majae garoboꞌe bamamugo hesi ijorajo ömoꞌömohuro rueromo uavareje: Aveho a rumoꞌe saꞌae höjo. O majae mamiꞌe barëjëꞌe höjo. Ëhuni aribövioho rëmöꞌöjego amo göro göro vaꞌoromo ie imoꞌamoꞌirarëjo. ");
INSERT INTO aom_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Ie imoꞌirarëjamu Iesuro uëvadeje: Jabumë rabëni vaꞌojörajo. Jemëro irunoꞌoho daꞌuojëhirëjo. ");
INSERT INTO aom_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Daꞌuojëhirëjamu uavareje: Iae mae höjo röhu aviae no ie övo gö mine visue niöꞌi ëhemu javuajëjo. ");
INSERT INTO aom_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Ëhemu javuajëjamu uëvadeje: Baro bojemihëjo. ");
INSERT INTO aom_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Ëhi uënugoromo huro aribövioho uëvadeje: Garasioro raromohëjo. Raromohëromo ie övo gö mine visue niöꞌi ujuoho rovaroho ëho huro ujuohoromo öꞌidöho sioroho garomo God huë mae uavadeje. Huë mae uanugoromo ioho atoꞌatovoromo hesi ijorajo ömoꞌömoho iꞌimëmamu ujuohoromo ae ahoꞌobëhe suvuorëmijareje. ");
INSERT INTO aom_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Suvuorëmijamu ae ahoꞌobëhe ë ioho visuoho ueꞌahamu daꞌuëgadeje. Daꞌuëgamu gagorovo ijorajoho jaburo vitu vituoho gagovoromo aegamu esöe ahoꞌobëhe 12 irijiomoꞌamadeje. ");
INSERT INTO aom_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Ëhiꞌareje. Amaꞌe ahoꞌobëhe 5,000 rabuꞌe iohuꞌo visuohuꞌo ueꞌahoruomadeje. Röhu magonahe asisöꞌe jabuꞌo ueꞌahareje. ");
INSERT INTO aom_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Ëhiꞌamu Iesuro hesi ijorajo ömoꞌömoho uëvadeje: Boat-oro ajio raromoromo eꞌu ioni gönö urimo vaꞌohego na a ioroꞌioroho rëmöꞌöjöjo. ");
INSERT INTO aom_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Ëhi uëromo ae ahoꞌobëhe rëmöꞌönugoromo parie vaeꞌi hesi sivue dahorure ajiomadeje. Ajiomoromo hesi sivue hijamu vahiromadeje. ");
INSERT INTO aom_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Vahiromamu nume ijorajoho jaburo öri ëgoböviro jovo döre vaꞌoruomamu evare burëro jabesi nuninö rueromo jovoho hasaromo boat-ohuꞌo babuꞌöjëvobe vaꞌadeje. ");
INSERT INTO aom_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Ëhiꞌojuvo sisonuvoꞌiaꞌamu Iesuro jovo döre hörëro rovadeje. ");
INSERT INTO aom_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Jovo döre rovamu gagorovo ijorajoho jaburo jioduduꞌiraeromo uvareje: Aruꞌahëro rovajëromo juhuonivoromo jöꞌe dadovareje. ");
INSERT INTO aom_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Jöꞌe dadovamu hejëꞌi Iesuro uëvadeje: Nadi juhuonivoꞌi biririvohëjo. Na jevajëjo. ");
INSERT INTO aom_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Na jevajëjamu Peter-ro uavadeje: Bada ja javëꞌoho uevego na jovo döre öꞌöjo. ");
INSERT INTO aom_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Öꞌöjamu Iesuro uavadeje: Rovëjo. Rovëjamu hegorovo Peter-ro boat-re jioromo jovo döre abueromo Iesu birohoꞌi hörëro jovo döre vaꞌadeje. ");
INSERT INTO aom_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Vaꞌihö gavade bure rovamu gagorovo juhuonivadeje. Juhuonivoromo jovo gagore abueꞌiaꞌamu gavëꞌi uvadeje: Bada ajemëjo. ");
INSERT INTO aom_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Ajemëjamu hejëꞌi Iesuro övoho nugöꞌöromo Peter maꞌenoromo uavadeje: Mae uehorovevo avohoꞌibejanëjo. Ja rabëni uehoro niöꞌioho baejane höjo. ");
INSERT INTO aom_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Ëhi uanugoromo jaburo niöꞌiro boat gagore ajiomamu gavëꞌi buroho barëjadeje. ");
INSERT INTO aom_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Buroho barëjamu gagorovo boat-re raromare ariböviohuro Iesu rajahiromo uavareje: Iae mae-ëjo. Ja God-are Harihe javajëjo. ");
INSERT INTO aom_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Ëhiꞌonugoromo eꞌu ioni gönö rueromo Gennesaret saꞌare ravoꞌamareje. ");
INSERT INTO aom_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Ravoꞌamamu gagorovo ë saꞌa rajohuro Iesu garomo uvoruomadeje: Iae Iesu hö uvoromo ë saꞌae bövioho jöe nugöꞌöjamu guomo guomoꞌe ae ahoꞌobëhe ujuoho rueruomadeje. ");
INSERT INTO aom_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Ujuoho rueromo ëninamiromo uanövareje: Guomo guomoꞌe aribövioho uëvego ja niögu vituohuremu rëhego ëhuro guomo guomoho barëꞌamajo. Ëhi uaꞌego ae rahu rëhëꞌoho marëꞌamonövadeje. ");
INSERT INTO aom_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Ëhiꞌamu Pharisee ariböviohuꞌo Jew rajo jögoru öri röjëhijarue ariböviohuꞌo ëho jaburo Jerusalem jioromo rovareje. Rueromo Iesu uavareje: ");
INSERT INTO aom_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","Jasi ijorajo ömoꞌömoho nosi a mamiehu bojëmibe rovare jögoroho ahoruomaje höjo. Nosi a mamiehu ëꞌarëhioho jasi aribövioho jovoho övoho bogo ëhioho otehodivorovëꞌe ioho ma-ueꞌaharue höjo. Rabëni ëhioho ëꞌarue höjo. ");
INSERT INTO aom_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Ëhi uavamu hegorovo Iesuro uëvadeje: Röhu jemë rabëni jemesi a mami jabesi muohuremu uehorovoromo ëhuro God-are jögoroho aharuje höjo. ");
INSERT INTO aom_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Ëhesi bëhoho God-ro uëvade höjo: Jasi vëmu vavuꞌoho mae uehorovëvonëjo. O jöe göꞌo uëvade höjo: Ae rahu jö sisë jövoromo vëmu o vavu hesi iho ijumahëꞌoho anego guomoꞌirajo. ");
INSERT INTO aom_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Röhu jemëro ë jöho ahoromo ae röjëhiromo uëvaruje höjo: Jaehu jasi vëmu vavuꞌo God-are nunire uëvëꞌoho: Nasi maho sisëho ujuohoromo jemë ajëmiꞌibejodoho röhu aveho na God-are ihoro bamëꞌe jevajë uëvëꞌoho ");
INSERT INTO aom_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","nadi röhu maho huotorovoromo vavuoho ajaminëjo. Ajamijëꞌoho sisë höjo. Vavu ajamijëꞌoho sisë hö uëvarujohuro ëhuro vëmu vavuꞌo mae uehorovëvoꞌirarijego God-hu bojëmade jöho jemëro aharuje höjo jemesi a mami jöho eꞌirovo. ");
INSERT INTO aom_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Sareri sareriꞌe aribövie jëvajëjo. Jö God-aro baeromo majëhijade ae Isaiah-ro jemëhu ëꞌirarije jöho jajivoromo ëhi uvëꞌe höjo: ");
INSERT INTO aom_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Ave ariböviohuro ma-jöꞌëremu God na rajehiꞌi dë vövöbajoꞌoho bogo nasi gemuoroho jioꞌi roriꞌo jioruomajëjo. ");
INSERT INTO aom_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Jabumë a jabesi jögoroho ae röjëhiromo uëruomaje höjo: Ëho God-are jöe jiaje ejahuorëjo. Ma-a jabesi jögoroho ëhi röjëhiromo ëhuro ma-döhemu God na rajehiruomaje höjo. Ëjemesi jö Isaiah-hu jajivadoho iae mae höjo. ");
INSERT INTO aom_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Iesuro ëhi uënugoromo ae ahoꞌobëhe uëvadeje: Ro gemuoro gagovohëromo ro gagovamu uëvadeje: Ave uhu jö uëꞌiëꞌajoho avoho heromo bëhoho baerëjo. ");
INSERT INTO aom_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Rabe jöꞌore vaꞌëꞌoho bogo ëhuro aho sisërëꞌamoꞌi aꞌi rabe jöꞌore jioromo suorovëꞌohuro ëhuro aho sisërëꞌamaje höjo. ");
INSERT INTO aom_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Iesuro ëhi jövamu hejëꞌëro hesi ijorajoho jaburo rueromo uavareje: Jaehu ë jö majëhijamu Pharisee ariböviehu heromo huë sisë baeruomadoho na ja uehorovanuëjo. ");
INSERT INTO aom_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Na ja uehorovanuëjamu Iesuro uëvadeje: Nasi Vavue öꞌidöre hijaje a hesi aribövioho mure i maehu rijajoho vaꞌëne jioruomajëjo. Ëmure hesi ëma riꞌamaje resu resuoho nasi Vavuohuro jahoꞌamoromo ruruhöꞌöꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Ëhuni ë resu resu vaꞌëne Pharisee aribövioho ëhi vuonugorëjo. Jaburo nuni sisëꞌe ariböviohuro öroho röjëhijanovarue höjo. Nuni sisëꞌe a göehu nuni sisëꞌe a gö öri röjahijëꞌoho jabumë niöꞌi guare bejëvo vaꞌaꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Bejëvo vaꞌaꞌajëjamu Peter-ro Iesu uavadeje: Röhu jöꞌore vaꞌaje o jöꞌore jioromo suorovaje uhu jö hesi bëhoho huruoho majahuijego no hejarëjo. ");
INSERT INTO aom_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Hejarëjamu Iesuro uëvadeje: Na jaruvoho ëhi jemëꞌo uehoroho bogojëvajëjo. ");
INSERT INTO aom_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Jemë rabëni bogo garomo uvarujëjo: Rabe jöꞌore vaꞌëꞌoho dëre abueromo dëre jioromo suorovoromo bogo aho ijumëvëꞌe ma-gua gagore vaꞌaje höjo. ");
INSERT INTO aom_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Aꞌi jöꞌore jioromo suorovaje jöhuro dë vövöbajoꞌere jioromo rojomoromo jöꞌore suorovaje höjo. Suorovoromo ëhuro aho God-are nuniroho sisërëꞌamaje höjo. ");
INSERT INTO aom_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Ëhesi bëhoho uehoro sisëhuro dë vövöbajoꞌere jioromo rojomego ëhuro ae muoꞌamoruomaje höjo. Gohoꞌamoruomaje höjo. Öëro jijihanovoruomaje höjo. Vajiohëro ujuohoruomaje höjo. Ae sarerëmiruomaje höjo. Ae gö jabesi ihoho ijumoruomaje höjo. ");
INSERT INTO aom_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Ëhi jiëꞌe mu sisë vaejëꞌohuro ëhuro aho God-are nunire sisërëꞌamaje höjo. Aꞌi övo bogo eguëꞌe i ijëꞌoho bogo ëhuro aho God-are nuniroho sisërëꞌamaje höjo. ");
INSERT INTO aom_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Ëhiꞌoromo Iesuro ë saꞌaho nugo vaꞌadeje. Vaꞌadoho vaꞌo Tyre amo Sidon amo jiajinö saꞌare ë rovadeje. ");
INSERT INTO aom_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Rovamu iae Canaan saꞌa rajo magonahëro ë saꞌare hijëꞌëro rueromo Iesu uavadeje: Bada ja a böröme David-are ujoho javaje nani vavaenimoromo ajeminëjo. Satan-are a sisëro nasi aboji hesi dë gagore abuejëꞌe höjo. Abuejëꞌëro magonahoho sisëꞌi hijajëjo. ");
INSERT INTO aom_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Sisëꞌi hijajëjamu Iesuro bogo jöho uavadeje. Bogo jöho uavamu hesi ijorajo ömoꞌömohuro rueromo uavareje: Magonahoho uavego vaꞌajo. Hu ma-darugoꞌo uvobe nosi ijore ijore rovajëjo. ");
INSERT INTO aom_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Rovajëjamu Iesuro uëvadeje: God-ro saꞌare remöꞌöjade höjo naro rueromo bogo saꞌa gö rajoho ajëmiꞌi aꞌi Israel raje sheep vaꞌëne subiröꞌöꞌamëꞌohemu ajëmiꞌirodego. ");
INSERT INTO aom_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Ëhi uëvamu ë saꞌa gö rajo magonahohuro ro Iesuare bëhire ague aho hiromo uavadeje: Bada ajemijëjo. ");
INSERT INTO aom_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Ajemijëjamu Iesuro uehorovoromo uvadeje: Vëmu vavuꞌehu jabesi aboji harihuꞌo urimo ajëmijaruëhi naro nasi saꞌa rajohemu ëhi urimo ajëmiꞌi rovode höjo. Ëhi uvoromo ë saꞌa gö rajo magonahoho uhuꞌe uavadeje: O-ajo. Noehu aboji harihuꞌo jabesi i ujuohoromo ö harihu mioꞌamëꞌoho ëho bogo maehu höjo. ");
INSERT INTO aom_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Bogo maehu höjamu hegorovo magonahohuro uehorovoromo uvadeje: Iae na bisemu ioniro saꞌa gö raje jevoꞌego ëhuni bogo ajemiꞌi jöho jövajëjo. Röhu noehu bogo rarovego öehu i ugobajoꞌo ueꞌaharuëhi nani Iesuro naꞌo ëhi ejehoromo nasi abojoho ajamiꞌajëjo. Ëhi uvoromo mana uhuꞌe uavadeje: Bada iae mae-ëjo röhu jabesi öhuro vavu jabesi maratuore jioromo rireromëꞌe i ugobajoꞌoho ueꞌaharue höjo. ");
INSERT INTO aom_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Ueꞌaharue höjamu Iesuro uavadeje: Asëꞌe naro ajamijöro uehoro ma-mabëhe barovane höjo. Ëhuni jaehu nimanuëhi ëhi ëꞌejöjo. Ëhi ëꞌejöjamu gavëꞌi abojoho marëjahadeje. ");
INSERT INTO aom_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Ëhiꞌamu Iesuro vaꞌadeje. Vaꞌadoho vaꞌo Galilee jovo riröre vaꞌoromo dahorure ajiomoromo saꞌaro hijadeje. ");
INSERT INTO aom_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Hijamu ae ahoꞌobëhe maho jaburo höru sisëꞌe aho nuni sisëꞌe aho övo höru tövëhëꞌe aho bitaro tövëhëꞌe aho guomo guomoꞌe a ioroꞌioroho ahoꞌobëhe ëhi ujuoho rueruomadeje. Ujuoho rueromo Iesuhu hijajire saꞌare bahiruomadeje. Bahijamu huro avohëvamu mae jëvadeje. ");
INSERT INTO aom_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Mae jëvamu ae ahoꞌobëhe garuomadeje bitaro tövëhëꞌe aribövioho mae jioromo jöe atamu övo höruꞌe tövëhëꞌoho mae jëvamu höru sisëꞌe aribövioho mae jioromo jijihamu nuni sisëꞌe aribövioho mae jioromo uherihamu. Ëhiꞌamu gëgorovo jabumë ae ahoꞌobëhe tiöjëvadeje. Tiöromo God Israel rajo muebejëvaje a hesi ihoho döro bamoruomadeje. ");
INSERT INTO aom_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Ëhiꞌamu Iesuro hesi ijorajo ömoꞌömoho uëvadeje: Ruehë uëromo rovamu uëvadeje: Ave ariböviohuni vavaenegajëjo. Jabumë naꞌo raromobe rovaroho majae niöꞌi gemu barëjëꞌëro ëhuꞌëro i ueꞌahoꞌiröhoho bogohöjo. Ma-dë gagëremu rëmöꞌöjëꞌoho na bijönegajëjo vaꞌego örire nune örijëvojöëni. ");
INSERT INTO aom_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Ëhi uëvamu rue ijorajoho jaburo uavareje: Iae ëhi höjo röhu aveho ma-saꞌaemu jiëꞌe öri ariꞌero ae ahoꞌobëhe rovëꞌe höjo. Ëhi jiëꞌoho no dinöꞌe ioho birohoromo daꞌuojëhiꞌejarëjo. ");
INSERT INTO aom_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Daꞌuojëhiꞌejarëjamu uëvadeje: Ioho diminoꞌe jëvajëjo. Diminoꞌe jëvajëjamu uavareje: Ioho övo gö mine övo göre niöꞌi visu ininoho ma-gemu gemu javuajëjo. ");
INSERT INTO aom_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Ëhi uavamu hegorovo Iesuro ae ahoꞌobëhe uëvadeje: Saꞌaro raromohëjo. ");
INSERT INTO aom_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Raromohëromo ie övo gö mine övo göre niöꞌi ujuoho rovarohuꞌo visuohuꞌo ujuohoromo God huë mae uanugoromo atoꞌatovoromo hesi ijorajo ömoꞌömoho iꞌimëmamu ae ahoꞌobëhe suvuorëmijareje. ");
INSERT INTO aom_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Suvuorëmijamu ae ahoꞌobëhe ueꞌahamu daꞌuëgadeje. Daꞌuëgamu gagorovo ijorajoho jaburo vitu vituoho gagovoromo esöe övo gö mine övo göre niöꞌi aegamu irijiomoꞌamadeje. ");
INSERT INTO aom_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Amaꞌe ahoꞌobëhe 4,000 jaburo ë ioho visuoho ueꞌahoruomadeje. Röhu magonahe asisöꞌe jabuꞌo ueꞌahareje. ");
INSERT INTO aom_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Ëhiꞌamu Iesuro ë aribövioho rëmöꞌönugoromo boat-re ajio hiromo Magadan saꞌare vaꞌadeje. ");
INSERT INTO aom_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Iae Pharisee ariböviohuꞌo Sadducee ariböviohuꞌo ëho jaburo rovareje. Rueromo Iesu guaro bevaꞌojöro nimoromo uavareje: God-are darugoho baeromo bogo gavarue muoho röjahuijego no gavarëjo huro ja ajamego muoho vaejanue javego o bogo. ");
INSERT INTO aom_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Ëhi uavamu huro uëvadeje: Jeniromoromo öꞌidöho kavuego uvaruje höjo: Öꞌidö kavuajoho vamae jioꞌiro ëꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","O sueꞌoho uvaruje höjo: Öꞌidö kavuoromo ramoramovajoho jaruvoho ëni buruꞌe rue hesi höjo. Jemëro öꞌidöho uherihoromo kavuego garomo uvaruje höjo: Ëhesi bëhoho iae ëhi jioꞌiëꞌajëjo. Röhu ave jaruvore rovaje muoho garomo ë hesi bëhoho bogo avoho garomo uvarujëjo: Iae God-are mu börömoho rovajëjo. ");
INSERT INTO aom_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Sareriꞌe aribövi sisë jëvajëjo. Magonahehu hesi baru vuonugoꞌi ma-juvajëhi jemëro ëhi God vuonugoꞌi mue gö gö uehorovaruje höjo. Jemë rabëni darugoꞌe muoho gaꞌi nimarujëjo. Na ëhi jiëꞌe muoho bogo vaeꞌi aꞌi Jonah-hu God-are mu börömo röjëhijade ëhi jiëꞌe muohuremu röjëhiꞌejöjo. Mue gö gö bogajo. Ëhi uënugoromo rëmo vaꞌadeje. ");
INSERT INTO aom_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Ëhiꞌamu Iesumëro eꞌu döre vaꞌoromo ioni gönö rovareje. Rueromo ijorajoho jaburo gavareje rumonëgamu irunoꞌoho bogo ujuohëꞌe jëvamu. ");
INSERT INTO aom_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Ëhiꞌamu Iesuro uhuꞌe uëvadeje: Jemë gavëꞌiajo. Pharisee aribövi o Sadducee aribövi jabesi i dë huoꞌamaje osohuro jemesirire rumorovoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Rumorovoꞌajëjamu rueho jaburo ë jöho mevoromo uarovareje: Noro ie bogo ujuoho rovëꞌëro ëhuni jövajëjo. ");
INSERT INTO aom_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Ëhi uarovamu Iesuro gëromo uvadeje: Jabumë ëhi jiëꞌe jöho ataruëromo uëvadeje: Mae uehorovevo avohoꞌibejarijëjo. Jemë rabëni i bogojavuaje jöho atarujëjo. ");
INSERT INTO aom_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Jemë rabëni avevejöꞌohuꞌo bogo gavarujëjo. Naehu ie övo gö mine ujuohoromo ae ahoꞌobëhe 5,000 iꞌimëmodoho ë i vitu vitu aegamu esöe diminoꞌe irijiomoꞌamadoho jemë ëhuꞌo rabëni bogo uehorovarujëjo. ");
INSERT INTO aom_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","O naehu ie ahoꞌobëhe övo gö mine övo göre niöꞌi ujuohoromo ae ahoꞌobëhe 4,000 iꞌimëmodoho ë i vitu vitu aegamu esöe diminoꞌe irijiomoꞌamadoho jemë rabëni bogo ëhuꞌo uehorovarujëjo. ");
INSERT INTO aom_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Jemë rabëni uvarujëjo: Ie bogojavuoꞌego nöröro i jöe uehorovoromo majahuijajëjo. Bogo ë jöho uëromo ëꞌode höjo. Röhu gavëꞌiajo. Pharisee aribövi o Sadducee aribövi jabesi i dë huoꞌamaje osohuro jemesirire rumorovoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Rumorovoꞌajëjamu hegorovo ijorajoho jaburo uhu jö hesi bëhoho avoho uehorovoromo uvareje: O Iesu bogo i dë huoꞌamaje oso jöho majahuiromo uövuade höjo: Gavëꞌiajo. Aꞌi Pharisee aribövi o Sadducee aribövi jabesi jö sisëhuro nosiro rumorovojöëni ë jöho uhuꞌe majahuiromo uövuade höjo: Gavëꞌiajo. ");
INSERT INTO aom_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Iae Iesuro ajiomadoho Caesarea Philippi amo bëhinö saꞌare rovadeje. Rueromo huro hesi ijorajo ömoꞌömoho uëvadeje: God-are A Maho na rahuo jevaje jöho ae ahoꞌobëhe diehi atoruomaje höjo. ");
INSERT INTO aom_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Diehi atoruomaje höjamu uavareje: A ioroꞌiorohuro uvoruomaje höjo: Ja John bapataeto vaejavuonövane ahuro rovëꞌe javajëjo. A ioroꞌiorohuro uvoruomaje höjo: Ja Elijah-ro rovëꞌe javajëjo. A ioroꞌiorohuro uvoruomaje höjo: Ja Jeremiah-ro o jö God-aro baeromo ae majëhinövane ae göëro rovëꞌe javajëjo. ");
INSERT INTO aom_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Ëhi uavamu hegorovo Iesuro uëvadeje: Röhu jemë nasi jöho diehi ataruje höjo. ");
INSERT INTO aom_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Diehi ataruje höjamu Simon Peter-ro riꞌöromo uavadeje: Ja böröme namiromo ajamuijanue aho javajëjo. God hiemu hijaje a hesi Harihe javajëjo. ");
INSERT INTO aom_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Hesi Harihe javajëjamu Iesuro Peter uavadeje: John-are harihoho Simon ja huë mabëhe baejëꞌe javajëjo. Bogo ma-aehu ë jöho röjahijamu jövoꞌirögoro nasi Vavue öꞌidöre hijajohuro röjahijëꞌëro jövanuëjo. ");
INSERT INTO aom_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Röhu na ave jöho uaꞌiëꞌajëjo: Ja Peter javajëjo. Peter hesi bëhoho munë javajëjo. Röhu ave munëho bamoꞌejöjo nasi ekaresiae ahoꞌobëhe ë hesi döre gagovëvego bibivoromo riravoꞌirarijego. Nasi ekaresiae ahoꞌobëhe ëhi riravoꞌiramu vuovo hesi vöröho bogo ruahöꞌöjëvoromo ijumëvoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Röhu naro Peter jasi örire darugoho bojamiꞌejöjo jero ojoho jiovëhego aëro God-are öri ariꞌere ë vaꞌoruomoröhego. Ja saꞌare hiromo öri tugohëꞌoho jero ma-mae tugohoꞌiramu Godꞌo öꞌidöre hiromo avoho tugohoꞌajëjo. O saꞌare hiromo öri jiovëꞌoho jero ma-mae jiovoꞌiramu Godꞌo öꞌidöre hiromo avoho jiovoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Ëhi uaromo hesi ijorajoho ahoꞌobëhe darugoꞌo uëvadeje: Nadi aho huruoho majëhiromo uërëjo: Nörö böröme namiromo a ajëmijaje aho höjo. ");
INSERT INTO aom_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Ëhiꞌonugoromo evare majare Iesuro aevoromo hesi ijorajo ömoꞌömoho röjëhiromo uëvadeje: God-ro ëhi bamëꞌëro ëhuꞌëro na Jerusalem ajiomoꞌejöjo. Ajiomoꞌiramu a duvaho ariböviohuro priest masijohuro Jew rajo jögoru öri röjëhijarue ariböviohuro ëho jaburo viꞌehe huë vavaene bövie biseꞌe bojemiꞌaruëjo. Ëhi ëꞌoromo ae gö jabesi övore bojëmiꞌiramu anegoꞌiramu guomoromo majae niöꞌi gemu hesi uhure riꞌöꞌejöjo. ");
INSERT INTO aom_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Ëhi uëvamu hegorovo Peter-ro Iesu roriꞌo huꞌirae bavaꞌoromo uavadeje: Bada bogajo. Ëhi jiëꞌe huë vavaenoho bogo mae bogo baeꞌaꞌanuëjo. ");
INSERT INTO aom_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Ëhi uavamu hegorovo Iesuro huotorovoromo Peter uavadeje: Satan roriꞌo vaꞌëjo. Jero nasi muoho ahanuëjo. God-hu uehorovajëhioho ja bogo ëhioho uehorovoꞌi ma-aehu uehorovaruëhi jero ëhi uehorovoromo ëhuni ë jöho jövanuëjo. ");
INSERT INTO aom_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Ëhi uanugoromo hesi ijorajo ömoꞌömoho uëvadeje: Ae rahuaro nasi ijore ijore juvoꞌi nimëꞌoho jasi sinehu nimajoho nadi uehorovoꞌi uvonëjo: Iesuare jöëni viꞌehe huë vavaene javoje rabe baeromo guomevëꞌoho iae hesi hö uvoromo korosi hesi iꞌuoho banigojiomanovoromo nasi ijoro ijoro juvonövonëjo. ");
INSERT INTO aom_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Ja jasi sinohuni uehorovoromo biririvoromo ave saꞌare hiꞌi ëhemu uehorovëꞌoho ijonöho guomo öriro vaꞌaꞌanuëjo. O ja nasi jöëni guomëꞌoho ijonöho maro hiꞌaꞌanuëjo. ");
INSERT INTO aom_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Jaehu are jove saꞌae mae sisë ahoꞌobëhe bae baerëꞌi röhu jasi arijoꞌarije ijumorovëꞌoho na ja ëhuro mae javoꞌajëjo. Bogajo. Arijoꞌarije ijumorovëꞌoho diehi röhu maho avohorovoꞌiramu mae javoꞌajëjo. Öre bogohöjo. ");
INSERT INTO aom_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Röhu God-are A Maho naro nasi Vavu hesi ajohuꞌo nasi anera ömoꞌömohuꞌo gemu mae vuonoröꞌö rueꞌejöjo. Rueromo evare ae gemu gemu diehi jiëꞌe mu vaejarije manaho ëhi bojëmibe vaꞌejöjo. ");
INSERT INTO aom_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Ave jöho na jö mae uëꞌiëꞌajëjo. Jemë a ioroꞌiore ave riravarujoho bogo vuovëꞌe raromoromo geꞌaꞌarujëjo God-are A Maho naro böröme namiromo muebejëvoꞌi rueꞌiramu. ");
INSERT INTO aom_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Ëhi uënugoromo majae ahoꞌobëhe övo gö mine övo göre gemu barëjamu Iesuro Peter James o James-are öe John ëhi söromo dahoru ëgobövire ajiomoromo jabesi sivue raromareje. ");
INSERT INTO aom_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Raromoromo ë ijorajoho jaburo gavareje Iesuare sino hahoꞌe gorosovoromo hesi nu anoꞌoho majaehu bamajëhi ëhi jioꞌi hesi niögoho ajivo avohamu. ");
INSERT INTO aom_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Ëhi gaꞌi gavareje Mosesꞌo Elijahꞌo ëma jëvoromo jabuꞌo Iesuꞌo jöe atoruomamu. ");
INSERT INTO aom_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Jöe atamu gëgorovo Peter-ro Iesu uavadeje: Bada no ave raromaruoho iae mae höjo. Ja nagëꞌoho naro javue niöꞌi gemu vaeꞌamoꞌejöjo jani gemu Moses-ni gemu Elijah-ni gemu. ");
INSERT INTO aom_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Ëhi jövamu gavëꞌi ajivëꞌe suehuro rueromo aegëhadeje. Aegëhamu hejareje sue uhure uvavamu: Ave aho nasi Harihu mabëhe höjo. Na hu garomo nimorohevajëjo. Huhu jövaje jöho avoho herëjo. ");
INSERT INTO aom_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Ëhi uvavamu hejëꞌi ë ijorajoho jaburo sisë maro juhuonivoromo saꞌare rireromoromo nu anoꞌoho saꞌare amoromo momoröꞌöjareje. ");
INSERT INTO aom_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Saꞌare momoröꞌöjamu Iesuro rueromo jabumë rëhëvoromo uëvadeje: Nadi juhuonivoꞌi riꞌöhëjo. ");
INSERT INTO aom_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Riꞌöhëjamu hegorovo riꞌö uherihoꞌi gavareje ae gö bogojioꞌi Iesu gemu namijamu. ");
INSERT INTO aom_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Ëhiꞌonugoromo dahorure ruvebijëꞌi Iesuro uëvadeje: Jemëhu gavarijoho nadi aho majëhirëjo. Uꞌemu God-are A Maho naro guomoromo riꞌöjego evaro majëhirëjo. ");
INSERT INTO aom_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Ëhi uëvamu rueho jaburo uavareje: Jew rajo nosi jögoru öri röjahuijarue ariböviohuro uövuarue höjo: God-are a börömoho bogo ëma rueꞌi aꞌi urimo Elijah God-aro vaꞌadoho iae vuonoröꞌö rueꞌaꞌajëjo. Rueꞌiramu God-are a börömoho ijore rueꞌaꞌajëjo. Jögoru öri röjahuijarue aribövioho rabëni ë jöho majahuijarue höjo. ");
INSERT INTO aom_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Rabëni majahuijarue höjamu Iesuro uëvadeje: Ioꞌajo. Elijah-hu urimo rueromo bövi biseꞌo avohoꞌamoꞌiröhe jöho iae mae-ëjo. ");
INSERT INTO aom_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Röhu ave jöho naro jemë uhuꞌe uëꞌiëꞌajëjo. Hehëjo. Elijah iae mamiꞌe rovade höjo. Rovamu aëro hu bogo ma gaꞌirögoro jabuhu diehi nimarëhi ëhi hesi örire sisë vaeruomade höjo. Jabuhu hu sisë vaejarëhi God-are A Maho naꞌo ëhi sisë vaejevoruomoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Ëhi majëhijamu hegorovo evare Elijah uëvaje hesi bëhoho uehorovoromo uvareje: John bapataeto vaejavuonövade a hesi jöho majahuiromo ëꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Dahorure ruvebinugoromo ae ahoꞌobëhe raromaruire ë rovareje. Rovamu gavëꞌi ae gemuëro rueromo ague aho hiromo ");
INSERT INTO aom_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","Iesu uavadeje: Bada nasi harihohuni vavaenimoromo ajamijëjo. Hesi simanoho sisërëromo sisëꞌi sisëꞌi hi juvaje höjo. Sisëꞌi sisëꞌi hiromo vënire jovore ëma ravorovaje höjo. ");
INSERT INTO aom_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Ëhuni jasi ijorajo jabesi örire barovode höjo. Barovamu ajamiꞌiröhoho bogo eni jëvade höjo. ");
INSERT INTO aom_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Bogo eni jëvade höjamu Iesuro uëvadeje: Asëꞌe ave jaruvore raromaruje aribövioho jemë bogo ma uehorovoꞌi jöe gö gö ëma uehorovaruje aribövie jëvajëjo. Na majae diminoꞌe jemëꞌoho hibe vaꞌejöjo. Majae diminoꞌe jemesi mu sisëho garomo ma-nunëro ga taemobe vaꞌejöjo. Jemesi mu sisëhuro na uꞌuvevajëjo. Ëaharihoho avehuro barovego na gavöjo. ");
INSERT INTO aom_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Barovamu gagorovo Iesuro Satan-are a sisëho birevamu aharihu hesi dëre jioromo hörö vaꞌadeje. Hörö vaꞌamu gavëꞌi aharihoho mae jiadeje. ");
INSERT INTO aom_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Ëhiꞌamu Iesuare ijorajoho jaburemu rueromo Iesu uavareje: Diehiꞌoromo noehu aruꞌaho sisë rarovöꞌöjaroho bogo eni javuade höjo. ");
INSERT INTO aom_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Bogo eni javuade höjamu Iesuro uëvadeje: Jemëro bogo ma uehorovëꞌëro ëhuꞌëro bogo eni jëvadeje höjo. Röhu ave jöho na jö mae uëꞌiëꞌajëjo. Mustard bajoho inino mae jioꞌamajëjo. Mustard baje gemu ma-biseꞌo jiajëhi ëhi uehoro mae ma-bisemu baeromo God mae uehorovëꞌoho ave dahorehu böviehu biseꞌehu jemesi mu ahanovajoho uavëꞌoho: Roriꞌo vaꞌë uavëꞌoho iae roriꞌo vaꞌaꞌajëjo. Ëhi jiëꞌe mu bövi biseꞌo vaejëꞌoho eni jëvoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Amo ë aharihu hesi dëre jiade ëhi jiëꞌe a sisë ae gö hesi dëre jiajoho rarovöꞌöꞌiëꞌiroho i ueꞌaharujoho vuonugoꞌi God-are örire uehore ahoꞌo bojamiromo ëninamijëꞌohuro ëhuro rarovöꞌöꞌamoꞌarujëjo. Öri göho bogoꞌe höjo. ");
INSERT INTO aom_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Ëhiꞌoromo Iesuare ijorajoho jaburo Galilee saꞌare ë ro gemuoro gagovareje. Gagovamu gavëꞌi Iesuro uëvadeje: God-ro ëhi bamëꞌëro hesi A Maho na a jabesi övore vaꞌoromo ");
INSERT INTO aom_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","anegoꞌiramu guomoꞌejöjo. Guomoromo majae niöꞌi gemu hesi uhure riꞌöꞌejöjo. Ëhi majëhijamu heromo huë vavaene böröme baeruomadeje. ");
INSERT INTO aom_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Ëhi ëꞌëꞌëro Iesuꞌo hesi ijorajo ömoꞌömohuꞌo ëho jaburo Capernaum amore rovareje. Rovamu God-are amo börömo hesi mu nigemoꞌiröhe tax moni baejarue ariböviohuro rueromo Peter uavareje: Na jasi a börömoho God-are amo börömo hesi tax-oho bojamijaje höjo. ");
INSERT INTO aom_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Bojamijaje höjamu Peter-ro uëvadeje: Ioꞌajo. Ioꞌa uënugoromo osare vaꞌamu gavëꞌi Iesuro urimo jöho jövoromo Peter uavadeje: Simon ja diehi uvanuëjo. Saꞌae dinöꞌe dinöꞌe raromoromo masijo vaejaruoho tax ihe gö gö ujuohoꞌiëꞌiroho rahumesi örire uëvego iꞌimëmarue höjo. Na jabesi ae gemuoho jabesi örire o ae gö jabesi örire uëvarue höjo. ");
INSERT INTO aom_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Uëvarue höjamu Peter-ro uavadeje: Ae gö jabesi örire uëvarue höjo tax monie bojëmijöro. Ëhi uavamu Iesuro Peter uavadeje: Ëhuꞌëro jiëꞌëro jabesi agane gemuoho tax-oho bogo vaejarue höjo. ");
INSERT INTO aom_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","No God-are agane javuajëjo röhu no hesi osa hesi tax-oho bogo bojëmiꞌibejarëjo tax baejarue aribövioho huë sisë baeꞌibejarëjo. Ëhuni iae bojëmiꞌejarëjo. Röhu jovo eꞌuoro vaꞌoromo anuge baꞌamoromo aevoꞌi jiomoꞌirane visuoho baeromo jöꞌoho tarivahonëjo. Tarivahoromo gaꞌaꞌanuëjo tax hesi ijo bajoho jöꞌore jioꞌiramu. Ëho bavaꞌoromo tax-oho jasirohuꞌo nasirohuꞌo bojëminëjo. jöhoje. ");
INSERT INTO aom_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Ëhiꞌamu evare Iesuare ijorajoho jaburo rueromo uavareje: God-hu böröme namiromo muebejavuajoho di ahuro a ioroꞌioroho iosiramuiromo börömoho javuajëjo. ");
INSERT INTO aom_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Börömoho javuajëjamu hegorovo Iesuro aharihoho uvamu rovadeje. Rovamu jabesi nunire huꞌirae barueromo ");
INSERT INTO aom_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","uëvadeje: Ave jöho na jö mae uëꞌiëꞌajëjo. Jemë jemesi iho böröme jiojöro uehorovarujoho vuonugoromo huotorovoromo asisöꞌonöꞌe ma-taemo raromorëjo. Jemë bogo ëhi ëꞌëꞌoho God-hu muebejaje öri ariꞌeroho bogo vaꞌo hesi jëvajëjo. ");
INSERT INTO aom_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Ae rahu döre bamorovaruoho vuonugoꞌi ave aharihoho vaꞌëne ma-taemo raromëꞌoho ë ariböviohuro God-hu böröme namiromo muebejëvaje a ioroꞌioroho iosirëmiromo jabumë masijo mae jioruomajëjo. ");
INSERT INTO aom_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Ae rahu aviëhi jiëꞌe asisöꞌoho gemu nasi ihore rajahiromo baejëꞌoho ëhuro naꞌo rajehiromo baejevoruomaje höjo. ");
INSERT INTO aom_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Ae göëro asisöꞌonöꞌe jörume hiromo nasi örire mae uehorovevoꞌajëjo. Ëhiꞌoꞌiramu ae göëro ë aho mu sisë röjahiromo ëhuro na uehorovevaje muoho ijumahoꞌajëjo. Ijumahoromo ëhuro hu iꞌu sisëho baeꞌaꞌajëjo. Mu sisë bogo röjahijajevare evare ë mu sisë röjahijaje a hesi sönöꞌahore aëro iꞌuꞌe munë hitahiohuro tövoromo sö jovore baꞌamego eꞌu ëgobövire bevaꞌoromo jove iromo guomoꞌibejajo ëho ma-jianovoꞌibejajo. Aꞌi ë mu sisë röjahiꞌiröhe ë hesi iꞌuoho börömo bëhe baeꞌaꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Saꞌare aribövioho ahoꞌo vaevëꞌe jioruomajëjo göehu gö bijioho gavego sisë vaeröhe muoho jiëꞌego. Ëhi jiëꞌe muoho iae rueꞌaꞌajëjo. Röhu ae rahu ë mu barovëꞌoho vaevëꞌoho sisërëꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Jasi övehu o hörehu mu sisë vaeromo God uehorovanue mu vuonugoꞌiëꞌiroho övoho o höroho tarioromo buꞌönëjo. Ja öve o höre gemu javamu ijonö vaꞌoromo mare hijëꞌoho ëhuro mae javoꞌajëjo. Aꞌi öve niöꞌi o höre niöꞌi javamu ijonö God-hu ramöꞌöjamu ravemu ravaje vënire vaꞌëꞌoho ëhuro sisë bëhe javoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","O jasi nunehu mu sisë vaeromo God uehorovanue mu vuonugoꞌiëꞌiroho nunoho jahoromo buꞌönëjo. Ja nune gemu javamu ijonö vaꞌoromo mare hijëꞌoho ëhuro mae javoꞌajëjo. Aꞌi nune niöꞌi javamu God-hu ramöꞌöjamu vëni sisëre vaꞌëꞌoho ëhuro sisë bëhe javoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Röhu gavëꞌi raromorëjo. Asisöꞌo vaꞌëne ma-taemo raromarue aribövioho bogave nue huodëgoꞌirarijëjo. Rabëni hesi bëhoho jabumë muebejëvarue aneraho jaburo öꞌidöre raromoromo nasi Vavue öꞌidöre hijaje a hesi nuniro raromemu raromarue höjo. ");
INSERT INTO aom_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","God-are A Ma naehu rovode hesi bëhoho subiröꞌöꞌamëꞌe aribövioho sö rueromo maro nugoꞌamoꞌirodëni rovode höjo. ");
INSERT INTO aom_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Röhu ave uhu jö majëhiꞌiëꞌajoho jemë diehi uehorovarujëjo. Ae gemu sheep ahoꞌobëhe 100 jioꞌi gemu sidövoromo ëma juvëꞌoho arijoꞌohuro sheep ioroꞌioroho 99 dahorure nugoꞌamoꞌi vaꞌoromo subiröꞌöjade sheep-oho nahobe juvoꞌaꞌajëjo. Na mae-ëjo. ");
INSERT INTO aom_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Nahobe juvoromo birohëꞌoho evare sheep ioroꞌiore 99 mae raromare jabesi jöënioho ma-bisemu nimorohoꞌi aꞌi ë subiröꞌöjade sheep gemuꞌohunioho nimoroho avohoꞌajëjo. Iae na mae uëvajëjo. ");
INSERT INTO aom_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Ëuhu jö hesi bëhoho asisöꞌo vaꞌëne jörume raromarue aribövioho röhu gemu sisëre vaꞌëꞌoho jemesi Vavue öꞌidöre hijajohuro ëhi jiëꞌoho bijönimaje höjo. ");
INSERT INTO aom_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Jaꞌo huꞌo God uehorovaruje öehu riꞌöromo jasi örire sisë vaejavëꞌoho jasi sivue vaꞌoromo jemë niöꞌiro ariromo hesi sisëho avoho majahijego hu heꞌirajo. Heromo huhu ejahëꞌohuro ëhuro jasi öho jasiro barueꞌanuëjo. ");
INSERT INTO aom_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","O bogo ejahëꞌoho vaꞌoromo ae göꞌo gemu o niöꞌi huꞌiraejëvoromo ö hesi öroro vuonoröꞌö vaꞌonëjo. Ëhesi bëhoho God-are surire jöho ëhi uvëꞌe höjo: Ae rahu ae gö hesi sisë a masijo jabesi nunire majëhijëꞌiroho ae niöꞌi o niöꞌi gemu gavare o hejare jö sisë gemuohuremu majëhijëꞌoho aëro heromo uvoꞌaꞌaruëjo: Iae mae-ëjo. Ëhi jiëꞌe mu sisëho vaejade höjo. Ëhuni ae göꞌo gemu o niöꞌi huꞌiraejëvoromo ö hesi öroro vaꞌoromo hesi jö sisëho mevego jabuꞌo heromo ja ajamiꞌirarëjo. ");
INSERT INTO aom_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","O jabesi jöhuꞌo bogo ejëhëꞌoho vaꞌoromo ekaresiaho ë a hesi sisëho huruoho majëhinëjo. O huhu ekaresia jabesi jö ëhuꞌo bogo ejëhamu gavëꞌiroho uvonëjo: Hu a gö vaꞌëne o vajiohuꞌe tax gagovaje aho vaꞌëne höromo nadi gavanovonëjo. ");
INSERT INTO aom_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Ave jöho na jö mae uëꞌiëꞌajëjo. Jemë saꞌare raromoromo öri tugohëꞌoho jemëro ma-mae tugohoꞌiramu Godꞌo öꞌidöre hiromo avoho tugohoꞌajëjo. O saꞌare raromoromo öri avoho jiovëꞌoho jemëro ma-mae jiovoꞌiramu Godꞌo öꞌidöre hiromo avoho jiovoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Röhu ave jöhuꞌo uëꞌiëꞌajëjo. Jemë ae niöꞌi saꞌare ariromo jöe gemuoro uehorovoromo ëninamijëꞌoho nasi Vavue öꞌidöre hijajohuro ejëhoromo jemëhu ëninamijarijëhi iae ëhi vaejëhoꞌajëjo ");
INSERT INTO aom_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","rabëni ae niöꞌi o niöꞌi gemu nasi ihore gemuore gagovëꞌoho naro ë diröꞌore jemëꞌo jevajëro jiëꞌëro. ");
INSERT INTO aom_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Ëhiꞌamu Peter-ro rueromo Iesu uavadeje: Bada nasi öehu nasi örire mu sisë vaeꞌi hijëꞌiroho na majae diminoꞌe uehorovoromo vuonugoꞌi hiꞌejöjo. Na na vae 7 uehorovoromo vuonugoꞌi hiꞌejöjo. ");
INSERT INTO aom_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Ëhi uavamu hegorovo Iesuro uavadeje: Na uavajëjo: Bogo vae 7 ëhemu aꞌi vae majae uehorovoromo vuonugoꞌi hiꞌaꞌanuëjo. ");
INSERT INTO aom_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Ëhesi uhu jöho na uaꞌiëꞌajëjo. Saꞌa a börömo hesi mu vaejaharue aribövi jabuhu moni bojamiꞌiröhe suri suri ë saꞌa a börömehu adahoromo ëꞌadëhi God-ro böröme namiromo hesi öri ariꞌoho ëhi muebejaje höjo. ");
INSERT INTO aom_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Iae saꞌa a böröme gemuëro hijade höjo. Hiromo hesi mu muebejaharue jabesi suri surioho aevoromo adahoꞌamade höjo. Adahoꞌamamu ae gemuehu a börömo hesi örire 7 million kina bojamiꞌiröhoho huꞌirae barovare höjo. ");
INSERT INTO aom_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Barovamu a börömohuro gavade ë aho moni bojamiꞌiröhoho bogo eni jiamu gagorovo hesi aribövioho uëvade höjo: Ëhuni ave aho hesi vaborohuꞌo aboji harihuꞌohuꞌo maho sisëho ahoꞌobëhe ëhuꞌo jemëro ae gö imëvoromo monioho mana baeromo nasi öroro bojemirëjo. Ëhi jiëꞌoho ë mu vaejaje aehu na mana bojemego baeꞌibejodëhi ë monioho naro baeꞌejöjo. ");
INSERT INTO aom_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Ëhi majëhijamu hegorovo ë ahuro ague aho hiromo ëninamiromo uavade höjo: Ma-biririvoromo hiromo muebejevonëjo. Iae na ahoꞌo bojami barëꞌejöjo. ");
INSERT INTO aom_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Ëhi jövamu hegorovo rue a börömohuro huni vavaenimoromo uavade höjo: Iae mae-ëjo. Nadi ijoho bojeminëjo. Iae barëjajëjo. Vaꞌonëjo. ");
INSERT INTO aom_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Ëhi uavamu iae vaꞌade höjo. Vaꞌihö gavade ae gemu huꞌo mue vaeromo a börömo hesi mu muebejahajoho jiamu gagorovo guduamade höjo 12 kina hesi örire bojamiꞌiröhëro jiëꞌëro. Guduamoromo huë husuovahoromo uavade höjo: Nasi monioho bojemijëjo. ");
INSERT INTO aom_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Bojemijëjamu ague aho hiromo ëninamiromo uavade höjo: Ma-biririvoromo hiromo muebejevonëjo. Iae na bojamiꞌejöjo. ");
INSERT INTO aom_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Bojamiꞌejöjamu bogo ejahade höjo. Bogo ejahoꞌi guduamo bavaꞌoromo savoji gagore baꞌamade höjo hu ë hibe vaꞌojuvo ë monioho hesi örire bojamiꞌiröhego. ");
INSERT INTO aom_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Ëhiꞌamu gagorovo a börömo hesi mu muebejaharue a ioroꞌiorohuro garomo dë vörönëgoromo sisë maro vavaenëgade höjo. Vavaenëgamu vaꞌoromo a börömoho huruoho majahiromo uavare höjo: Ëhi ëhi ëꞌëꞌe höjo. ");
INSERT INTO aom_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Ëhi ëhi ëꞌëꞌe höjamu rue a börömohuro jöe nugöꞌöjamu ë mu muebejahaje ahuro rovade höjo. Rovamu a börömohuro uavade höjo: Nasi mu vaejanue aho sareri a sisë bëhe javajëjo. Jero uevëꞌëro ëhuni jaehu moni bojemiꞌiranoho na uehorovoromo vuonugo barëjode höjo. ");
INSERT INTO aom_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Naehu jani vavaenimodëhi ja rabëni jasi a göhunioho bogo ëhioho vavaenimane höjo. ");
INSERT INTO aom_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Ëhi uanugoromo ë arijoꞌohuro dë vörönimamu ae uëvamu hegoro mu vaejaje aho guduamo bavaꞌoromo savoji gagore baꞌamare höjo ë hibe vaꞌojuvo monie ahoꞌobëhe bojami barëꞌiröhego. ");
INSERT INTO aom_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Jöho ëhi jiëꞌëro jemë ae gemu gemu jemesi a ioroꞌioro jabesi sisë bogo uhohuꞌo uehorovoromo vuonugëꞌoho nasi Vavue öꞌidöre hijajohuro ë börömehu ëꞌadëhi jemesi örire ëhi ëꞌaꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Iesuro ë jöho majëhinugoromo Galilee saꞌare jioromo vaꞌadeje. Vaꞌoromo Jordan beromo ioni göre Judea saꞌare rovadeje. ");
INSERT INTO aom_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Rovamu ae ahoꞌobëhe mae rihiromoruomamu huro guomo guomoꞌe aribövioho avohëvamu mae jëvadeje. ");
INSERT INTO aom_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Ëhiꞌamu gagorovo Pharisee ariböviohuro rueromo Iesu guaro bevaꞌojöro uavareje: Vaboro nugöꞌöꞌamoꞌiröhe jögoru hesi jöho no heꞌi naguajëjo. Baruehu rabëni rabëni bijönimoromo vaboro nugöꞌöjëꞌoho na mae o sisë höjo. ");
INSERT INTO aom_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Mae o sisë höjamu Iesuro uëvadeje: Röhu jemë ave jö adaharijoho rabëni bogo avoho uehorovarujëjo. God-are surire ëhi uvëꞌe höjo: Bövi biseꞌo bamade ahuro aevoromo ahuꞌo magonahohuꞌo bamëvade höjo. ");
INSERT INTO aom_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Bamëvoromo uëvade höjo: Ëhuꞌëro jiëꞌëro aëro vëmu vavuꞌoho rëmöꞌöꞌi vaborohuꞌo gemu mae hiꞌaꞌajëjo. Vaborohuꞌo hiꞌiramu jabumë niöꞌi jëvadoho röhu gemu jioꞌaꞌajëjo. Ëhi uvëꞌe höjo. ");
INSERT INTO aom_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Ëhuꞌëro jiëꞌëro ë ahuꞌo magonahohuꞌo bogo hahagu hahagu jioꞌi ma-gemu jëvoꞌajëjo. God-hu mamiꞌe gemuore havoromo muohadoho jemë ma-ae jëvaje nadi tarivorëjo. ");
INSERT INTO aom_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Nadi tarivorëjamu uavareje: Vaboro nugöꞌöꞌiröhoho sisë hö uövuanuoho röhu ëhi jiëꞌoho Moses-ro rabëni ave jögoroho bojamuade höjo: Vaboro nugöꞌöꞌi nagëꞌoho nugöꞌöꞌirane jöho suroro jajivoromo vaboroho bojamiromo evaro nugöꞌönëjo. ");
INSERT INTO aom_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Nugöꞌönëjamu Iesuro uëvadeje: Jemë hiaꞌi biririꞌe aribövie jëvobe rovëꞌego ëhuni baruehu vaboro nugöꞌöꞌamoꞌirarije ë hesi öroho Moses bogo tugohade höjo. Röhu niꞌiꞌivadiroho ëhi jiëꞌe muoho bogojiade höjo. ");
INSERT INTO aom_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Röhu ave jöho na uëꞌiëꞌajëjo. Vaboroho bogo ma-juvëꞌe baruehu ëma nugöꞌöromo magonahe gö masuvëꞌoho ëho bogo maho masuꞌi gohoꞌamarue muoho vaeꞌaꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Ëhi majëhijamu hegorovo hesi ijorajoho jaburo Iesu uavareje: Ja uövuanuoho: Baruehu vaboro masuvëꞌoho nadi ëma nugöꞌöꞌamorë uövuanuëjo röhu ëhi jiëꞌoho aehu magonaho masuvëꞌoho bogo maho jianovajëjo. ");
INSERT INTO aom_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Ëhi uavamu Iesuro uëvadeje: Magonaho bogo masuꞌi ma-raromëꞌoho ae ahoꞌobëhe ëhi ëꞌëꞌoho bogo eni jioruomoꞌajëjo. God-hu darugo bojëmamu baeruomëꞌoho ë ariböviohuremu ëhi ëꞌëꞌoho eni jioruomoꞌi a ioroꞌioroho bogo eni jioruomoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Ëhesi bëhoho ae göëro göëro bëhe gö gö uehorovoromo magonahoho bogo masuꞌi ëma raromarue höjo. A ioroꞌioroho rahare majare sinoho ëhi jëvëꞌëro magonahoho bogo masuꞌi ëma raromarue höjo. A ioroꞌioroho sinoho tarivëhëꞌëro magonahoho bogo masuꞌi ëma raromarue höjo. A ioroꞌiorohuro God-hu böröme namiromo muebejëvaje hesi muoho uehorovoromo magonahoho bogo masuꞌi ëma raromarue höjo. Ae rahu ëhi jiëꞌe mu vaeꞌirarije darugo baejëꞌoho ëhi vaerëjo. ");
INSERT INTO aom_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Ëhiꞌamu gagorovo aëro asisöꞌoho sö ujuoho rueruomadeje Iesuro öve jabesi sinore bamëhoromo God uavego ajëmiꞌiröhego. Ujuoho rovamu gëgorovo Iesuare ijorajo ömoꞌömohuro birëgareje. ");
INSERT INTO aom_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Birëgamu hegorovo Iesuro hesi ijorajoho uëvadeje: Nadi ahëvoꞌi uëhego rueruomajo. Ëhi jiëꞌe asisöꞌo vaꞌëne jörume raromëꞌe aribövioho God-ro böröme namiromo muebejëvego hesi aharire raromoruomaje höjo. ");
INSERT INTO aom_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Ëhi uëvëꞌëro övoho jabesi simanore bamëhonugoromo vaꞌadeje. ");
INSERT INTO aom_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Ëhiꞌamu iae a iꞌe gemuëro rueromo Iesu uavadeje: Tisa na diehi jiëꞌe mu maho vaeromo ëhuro ioroꞌioremuoho maroho hiꞌejöjo. ");
INSERT INTO aom_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Maroho hiꞌejöjamu uavadeje: Mu ma vaeꞌirane jöho ja rabëni nasi öriroho ue gevanuëjo. God gemu a maho höjo. Röhu mare hiꞌi nagëꞌoho hesi jögoroho ejahonövonëjo. ");
INSERT INTO aom_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Ejahonövonëjamu uavadeje: Diehi jiëꞌe jögoroho uevanuëjo. Uevanuëjamu Iesuro uavadeje: Nadi aho anonëjo. Nadi gohoꞌamonëjo. Nadi vajiohoho baenëjo. Nadi sareriꞌe jöho aho majëhinëjo. ");
INSERT INTO aom_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Jasi vëmoho vavuoho mae uehorovëvonëjo. Jasi arijoꞌarije rajahirovanuëhi jasi ae gemuoho ëhi rajahinëjo. ");
INSERT INTO aom_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Rajahinëjamu uavadeje: Ëjöho iae na e barëjëꞌe jevajëjo. Ëhi ëꞌëꞌe jevajëjo röhu mu göho rabe vaeꞌejöjo ëhuro maro hiꞌirodoho eni jevoꞌiröhe. ");
INSERT INTO aom_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Ëhi uavamu Iesuro uavadeje: Maro hiꞌiranëro ma-mae javojöro nagëꞌoho vaꞌoromo jasi bövioho biseꞌoho imoꞌamoromo monioho baeromo inömo bogo eni jiëꞌe aribövioho suvuorëminëjo. Ëhi ëꞌëꞌoho bövie biseꞌe maho maho janioho öꞌidöre jiahoꞌajëjo. Ëhiꞌoromo rueromo nasi ijoro ijoro juvonövonëjo. ");
INSERT INTO aom_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Ëhi uavamu hegorovo ruehuro hesi uehorovoromo uvadeje: Na bövie biseꞌe börömo mae jevëꞌëro suvuorëmiꞌirodoho na bogo eni jevajëromo vavaenimoromo vaꞌadeje. ");
INSERT INTO aom_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Vaꞌamu gagorovo Iesuro ijorajo ömoꞌömoho uëvadeje: Ave jöho na jö mae uëꞌiëꞌajëjo. Bövi biseꞌo marohëꞌe aehu God-hu muebejaje öri ariꞌere vaꞌëꞌoho ëhi jiëꞌoho anojiꞌe mae jioꞌaꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Röhu avehuꞌo uëvajëjo. Mi börömo anugo gagore nugöꞌöjëꞌoho ja bogo eni javoꞌajëjo. Röhu ëhi ëꞌëꞌoho samae jianovoꞌi bövi biseꞌo marohëꞌe ariböviehu God-hu muebejaje öri ariꞌere vaꞌiröhoho ëho anojiꞌe mae höjo. ");
INSERT INTO aom_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Anojiꞌe mae höjamu heromo tiötiövoromo uavareje: Ëhi jiëꞌoho no diehiꞌoromo maroho vaꞌejarëjo. No ae ahoꞌobëhe bogo eni javuajëjo. ");
INSERT INTO aom_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Bogo eni javuajëjamu Iesuro ërimëhoromo uëvadeje: Ioꞌajo. Jemë aëro jëvëꞌëro bogo eni jëvajëjo. Aꞌi God-hu mue ahoꞌobëhe vaejëꞌoho hu eni höjo. ");
INSERT INTO aom_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Ëhi uëvamu hegorovo Peter-ro riꞌöromo Iesu uavadeje: Aveho gavëjo. Noro bövie biseꞌe nosiroho vuonugoꞌi jasi ijore ijore jijihëꞌe javuajëjo. Ëhuni no manaho rabe baeꞌejarëjo. ");
INSERT INTO aom_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Rabe baeꞌejarëjamu Iesuro uëvadeje: Ave jöho na jö mae uëꞌiëꞌajëjo. Maja iꞌoho rueꞌiramu God-are A Maho naro nasi ihoho dö maro jioꞌiramu nasi röho mare hiromo nasi aribövioho muebejëvoꞌejöjo. Muebejëvoꞌiramu evare nasi ijoraje 12-ho jemëro naꞌo gemu mae arëto göro göro raromoromo Israel rajo nosi agane gö gö 12 jabesi muoho mevo gaꞌaꞌarujëjo. ");
INSERT INTO aom_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","O ae rahu javue öe maꞌine vavue vëme aboji harihuꞌe o saꞌae nasi iho hesi jöëni vuonugoꞌamoꞌi vaꞌëꞌoho ëhi jiëꞌe ariböviohuro bövi mae baeromo ijonö ma-ioroꞌioremu maro raromoꞌarujëjo. ");
INSERT INTO aom_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Ëhi höjo röhu a ioroꞌiore ahoꞌo nuninö jiaruoho dejonö jioruomoꞌi a ioroꞌiore dejonö jiaruoho nuninö jioruomoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Saꞌa arijoꞌe aehu hesi mu hesi öri muebejadëhi öꞌidöre hijaje A Börömohuro hesi öri ariꞌoho ëhi muebejaje höjo. Saꞌa arijoꞌe ae gemuëro sueꞌo vaꞌade höjo ae baejego jaburo hesi grape öꞌi bajo mure vaꞌoromo mue vaejahoromo manaho baeruomoröhego. ");
INSERT INTO aom_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Vaꞌo ae birohëvoromo uëvade höjo: Muoho vaejehorego noehu a bojëmijaruëhi ëhi jiëꞌe ajivëꞌe ijo baje gemu majae gemu hesi muohuni bojëmiꞌiröjo. Bojëmiꞌiröjamu uavare höjo: Iae mae höjo. Iae mae höjamu rue mu arijoꞌohuro hesi mure rëmöꞌöjade höjo. ");
INSERT INTO aom_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Ëhi ëꞌëꞌëro majae 9 oꞌclock jiamu gavëꞌi vuonoröꞌö vaꞌoromo gavade höjo a ioroꞌioroho mu rumoꞌe market-re ëma riravamu gëgorovo ");
INSERT INTO aom_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","uëvade höjo: Jemëꞌo nasi muoro vaꞌo mue vaerëjo. Suvuoro mae diminoꞌe jiajëhi na ëhi bojëmiꞌejöjo. ");
INSERT INTO aom_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Bojëmiꞌejöjamu muro vaꞌare höjo. Ëhiꞌamu maja ririrohuꞌo maja huotorovadevarohuꞌo huro market-re vuonoröꞌö vaꞌoromo ae gö gö jöe gemuoho uëꞌi hijade höjo. ");
INSERT INTO aom_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Ëhi ëꞌëꞌëro majae bevaꞌiaꞌamu gavëꞌi market-re vaꞌoromo gavade a ioroꞌioroho riravamu gëgorovo uëvade höjo: Majae bövioho jemë rabëni muoho bogo ëꞌëꞌe ëma riravemu riravarujëjo. ");
INSERT INTO aom_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Uavare höjo: Aho moni muoho bogo bojamuijëꞌëro ëhuni ma-riravaruëjo. Uëvade höjo: Jemëꞌo nasi muoro vaꞌoromo mue vaejehorëjo. ");
INSERT INTO aom_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Ëhi ëꞌëꞌëro majae barëjamu gagorovo mu arijoꞌohuro hesi mu muebejahaje aho uavade höjo: Mu aribövioho uëvego rueꞌirarëjo. Rovego suvuoroho bojëmibe vaꞌonëjo. Ijonö ro aevoromo mu vaejare aribövioho urimo manaho bojëmiromo evaro vaꞌo urimo majae göre göre mu vaebe rovare aribövioho bojëmibe vaꞌoromo ijo tugohoꞌioho urimo ro mu aevoromo vaejare aribövioho bojëminëjo. ");
INSERT INTO aom_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Ëhiꞌamu majae bevaꞌiaꞌamu ro mu vaejare ariböviohuro ajivëꞌe ijo baje gemu gemu baeruomade höjo. ");
INSERT INTO aom_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Ëhi baeruomamu gavëꞌi urimo ro mu vaejare ariböviohuro uvare höjo: No göꞌo döre baeꞌejarë uvare höjo röhu jabuꞌo ajivëꞌe ijo bajoho ëhi gemuoho baeruomade höjo. ");
INSERT INTO aom_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Ëhi gemuoho baeruomoromo mu arijoꞌoho birevoromo ");
INSERT INTO aom_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","uaruomade höjo: Ijo tugohoꞌi ro mu vaejare ariböviohuro majae ma-bisemu mue vaeꞌi noro sisonuvamu muoho aevoromo majae nijoꞌe huë vavaeniꞌe muoho vaebe vaꞌojuvo hujeji jeniromamu vuonugare höjo. Röhu jero jabumë bojëmijanëhi noꞌo ëhi gemuoho bojamuijanuëjo. ");
INSERT INTO aom_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Bojamuijanuëjamu rue mu arijoꞌohuro ae gemu uavade höjo: Isiajo. Na bogo sisëꞌioho vaejavode höjo. Jaꞌo uehorovëjo. Na mamiꞌe uavode höjo: Ajivëꞌe ijo baje gemu bojamiꞌejöjamu hegoro jero uevane höjo: Iae mae höjo. ");
INSERT INTO aom_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Ëhuni jasi suvuoroho baeromo vaꞌëjo. Nasi nimoromo naehu ja bojamijodëhi ave ijo tugohoꞌi ro mu vaejehade aho suvuore ëhi gemuoho bojamijajëjo. ");
INSERT INTO aom_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Nasi moniëro jiëꞌëro naehu baeromo rabe rabe negajoho ëꞌëꞌoho ëho na mae höjo o sisë höjo. Na suvuoroꞌe huë baejëꞌe ae jevajëjo röhu jero rabëni ëho uehorovoromo aho nue huodëganuëjo. Ëhi uavade höjo. ");
INSERT INTO aom_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Röhu uhu jö bëhoho ëhi höjo. Dejonö jiaruoho nuninö jioruomoꞌi nuninö jiaruoho dejonö jioruomoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Iae Iesuro Jerusalem amo börömore ajiomoꞌi vaꞌadeje. Örire vaꞌoromo huro hesi ijoraje 12-ho roriꞌo sö vaꞌoromo örire uëbe vaꞌadeje: ");
INSERT INTO aom_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","Aveho hehëjo. No Jerusalem amore vaꞌaruëjo. Vaꞌo ë raromoromo God-ro hesi ëhi bamëꞌëro hesi A Maho naro priest masijo jabesi övore Jew rajo jögoru öri röjëhijarue a jabesi övore vaꞌiramu baejevoꞌaruëjo. Baejevoromo nasi jöho mevo garomo uvoruomoꞌajëjo: Nörö sisëꞌe aego guomoꞌaꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Guomoꞌaꞌajëromo na baejevoromo saꞌa göre jioromo rovare aribövi jabesi övore bojëmiꞌiramu baejevoromo sivegoromo hisuebijevoromo korosire anegoꞌiramu guomevoꞌajëjo. Guomoromo majae niöꞌi gemu hesi uhure riꞌöꞌejöjo. ");
INSERT INTO aom_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Ëhiꞌamu iae Zebedee-are harihe niöꞌi Jamesꞌo Johnꞌo jabesi vëmohuro jabumë huꞌiraejëvoromo rovadeje. Rueromo ague aho hiromo Iesu uavadeje: Na ja ajamuinëjo o bogajo. ");
INSERT INTO aom_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","O bogajamu hegorovo Iesuro uavadeje: Ja diehi nagajëjo. Diehi nagajëjamu uavadeje: Na negajëjo jaehu böröme namiromo muebejavuëꞌiroho jero uëvego ave nasi harihu niöꞌiohuro öꞌo jasi bëhire masije rirarovoromo göhuro jasi övo manö göhuro jasi övo adonö ëhi ariꞌiröhego. ");
INSERT INTO aom_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Ëhi uavamu hegorovo Iesuro öꞌo öꞌo uëvadeje: Iae ëhi höjo röhu jemëhu ue gevaruje jö hesi bëhoho jemë bogo gavëꞌe ëma uevarujëjo. Na gavajëjo ajuoꞌe jovo sisëro ajuemanovo hesi jioꞌego. Ëhi jiëꞌe huë vavaeni baeꞌirarijoho na jemëꞌo eni jëvajëjo. Eni jëvajëjamu uavareje: Iae no eni javuajëjo. ");
INSERT INTO aom_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Ëhi uavamu Iesuro uëvadeje: Iae mae höjo. Na ajuemiꞌiröhe jovo sisëhuro jemëꞌo ajuëmiꞌajëjo. Röhu nasi bëhire övo manö o övo adonö ariꞌirarije jö uëꞌirodoho ëho bogo nasirehu höjo. Nasi Vavuehu a rahumëni uvoromo nugade röhoho ë aho jaburemu nasi bëhiroho ariꞌaꞌaruëjo. ");
INSERT INTO aom_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Ëhiꞌamu Iesuare ijorajo ioroꞌiore 10-ho jaburo hejare uvavamu: Öꞌo öꞌo Iesuare bëhire böröme rirarovoꞌi uvare höjamu hegorovo jabesi örire dë vörönimoruomadeje. ");
INSERT INTO aom_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Dë vörönimoruomamu gëgorovo Iesuro hesi ijorajoho ahoꞌobëhe uëvadeje: Ruehëromo rovamu uëvadeje: Iae jemëꞌo gavarujëjo. Saꞌa ioroꞌioro rajo jabesi a masijoho jaburo jabesi aribövioho ruahöꞌöjëvoromo jabumëremu masije riravarue höjo. O jabesi bëhire riravaruohuro ëhi taemëvoromo jöe bojëmijarue höjo. ");
INSERT INTO aom_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Saꞌa ioroꞌioro rajohuro ëhi ëꞌarue höjo. Röhu jemë nadi ëhioho döroho bamorovorëjo. Aꞌi jemesi ae gemu rahu böröme namiꞌi nimëꞌoho ë aho a ioroꞌioro jemë ajëminövoꞌiröhe ae jioꞌaꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","O jemesi ae gemu rahu nunire jioꞌi nimëꞌoho hu a ioroꞌioro jemesi mu vaejëhonövoꞌiröhe ae jioꞌaꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","God-are A Ma naehu a ajëmiꞌi rovodëhi ëhi ëꞌorëjo. Naehu rovode hesi bëhoho bogo aëro na ajemiꞌirarijego rueꞌi aꞌi naro ae ajëmiromo nasi arijoꞌarije bojamirovoromo guomorovoromo ëhuro ae ahoꞌobëhe sisëhu tövëvajoho jiovo rëmöꞌöꞌirodëni ëhuni rovode höjo. ");
INSERT INTO aom_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Ëhiꞌoromo Iesumëro Jericho amoho nugoꞌi vaꞌamu ae ahoꞌobëhe rihiromoruomadeje. ");
INSERT INTO aom_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Röhu nuni sisëꞌe ae niöꞌi öri ionire arijëꞌe jiareje. Ariromo hejare uvavamu: Iesuro rovaꞌajë uvamu hegorovo ma-darugoꞌo uvareje: Bada David-are ujoho böröme javaje noni vavaenimëjo. ");
INSERT INTO aom_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Vavaenimëjamu hegorovo ae ahoꞌobëhe jaburo birëgoromo uëvareje: Jöe vuonugohëjo. Jöe vuonugohëjamu hejëꞌi röhu maho darugo maꞌo uvareje: Bada David-are ujoho böröme javaje noni vavaenimëjo. ");
INSERT INTO aom_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Vavaenimëjamu Iesuro vaꞌadoho vuonugoꞌi ë namiromo uvëvadeje: Avehuro ruehëromo rovamu uëvadeje: Naro diehi ajëmijöro nëgajëjo. ");
INSERT INTO aom_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Nëgajëjamu uavareje: Bada ajamuego no nune dadovoromo uheriharëjo. ");
INSERT INTO aom_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Uheriharëjamu Iesuro jabumëni vavaenimoromo nunoho rëhëhadeje. Rëhëhamu ma-burëro uherihoromo hesi ijore vaꞌareje. ");
INSERT INTO aom_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Iae Iesumëro vaꞌo Jerusalem bëhire vaꞌoromo Olives Dahorure Bethphage amoꞌere ajio suorovareje. Suorovoromo Iesuro ijorajoho niöꞌi rëmöꞌöromo ");
INSERT INTO aom_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","uëvadeje: Arue jemesi nunörire amohuro vaꞌohëjo. Vaꞌo höröꞌi gaꞌaꞌarujëjo donkey-oho harihohuꞌo benugëꞌe jioꞌiramu. Benugëꞌe jiego jiovoromo huꞌiraejëvo ruerëjo. ");
INSERT INTO aom_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","O aehu jö uëvëꞌiroho uarëjo: Badaro ave mioho nimoꞌego ëhuni huꞌiraejëvo vaꞌaruëre. Ëhi uaꞌiramu iae ma-burëro uëꞌaꞌajëjo: Ëhi ëꞌohëjo. ");
INSERT INTO aom_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Röhu ëhi ëꞌiröhe mu hesi bëhoho God-are surire jö jajivarëhi ëhi jioröhego. Jö God-aro baeromo majëhinövade ahuro uëvadeje: ");
INSERT INTO aom_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Jemëro Zion amo rajoho ëhi uërëjo: Gahëjo. Jemesi börömohuro jemesi örire rovajëjo. Hu sanuꞌe aëro jiëꞌëro donkey döre hiromo rovajëjo. Donkey hesi harihure hiromo rovajëjo. ");
INSERT INTO aom_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Amo Iesuro hesi ijorajoho rëmöꞌöjamu vaꞌoromo Iesuhu uëvadëhi ëhi ëꞌareje. ");
INSERT INTO aom_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Ëhiꞌoromo ë donkey niöꞌioho vëmohuꞌo harihohuꞌo huꞌiraejëvo rueromo niögoho jabesi dejore ruahoꞌamo bahijamu gagorovo Iesuro ë ajio hijadeje. ");
INSERT INTO aom_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Hijamu ae ahoꞌobëhe a ioroꞌiorohuro niögoho örire ahahobe vaꞌi a ioroꞌiorohuro ijo rude tarivoꞌamoromo ahahobe vaꞌareje. ");
INSERT INTO aom_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Iesuare nuninö vaꞌoruomadohuꞌo dejonö rueruomadohuꞌo ma-darugoꞌo uvoruomadeje: Ave aho David-are ujoho böröme vaeromo rovajoho mabëhëjo. Ave aho Badare ihore rovajoho mabëhëjo. God mabëhëjo. ");
INSERT INTO aom_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Ëhiꞌamu Iesuro Jerusalem amore höröjamu gavëꞌi amo raje ae magonahe ahoꞌobëhe tiötiövoromo uëvareje: Ëho rahuo höjo. ");
INSERT INTO aom_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Rahuo höjamu Iesuꞌo rueruomade ariböviohuro uëvareje: Ëaho Galilee saꞌare Nazareth amore hiromo jö God-aro baeromo majahuijaje aho höjo. ");
INSERT INTO aom_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Ëhiꞌamu Iesuro God-are amo börömore vaꞌadeje. Vaꞌi gavade aëro bövie biseꞌe imoꞌamamu rarovöꞌöjëvadeje. Rarovöꞌöjëvoromo gavade aëro saꞌa göre göre jioromo rovare aribövi jabesi ijo bajoho ujuohoꞌi amo börömo hesi ijo bajoho iꞌimëmamu gëgorovo jabesi mu maratuoho huotovöꞌöjëhoromo ugo imoꞌamarue aribövi jabesi arëtohuꞌo huotovöꞌöjëhadeje. ");
INSERT INTO aom_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Huotovöꞌöromo uëvadeje: God-are surire jajivoromo uvëꞌe höjo: God nasi osaho aëro uvoruomoꞌajëjo: Ëho God-are örire jö atoꞌiröhe osaho höjo. Ëhi uvëꞌe höjo röhu jemëro mu sisë ëꞌëꞌëro ëhuro ave osaho vajiohuꞌe ariböviehu gurihirovarue juju gagoho vaꞌëne höjo. ");
INSERT INTO aom_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Ëhi uëvamu nuni sisëꞌe höru sisëꞌe aribövioho God-are amo börömore rueruomamu Iesuro avohëvadeje. ");
INSERT INTO aom_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Avohëvamu gagorovo priest masijohuꞌo jögoru öri röjëhijarue ariböviohuꞌo ëho jaburo gavare Iesuro ëhi jiëꞌe mu masijoho vaeꞌamamu hejare asisöꞌëro uvoꞌi arijavamu: Ave aho David-are ujoho böröme vaeromo rovajoho mabëhë uvoruomamu hegorovo dë vörönimoruomadeje. ");
INSERT INTO aom_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Dë vörönimoruomoromo Iesu uavareje: Arue asisöꞌehu jö sisë uvoruomajoho na ja hejanuëjo o bogajo. O bogajamu hegorovo Iesuro uëvadeje: Ioꞌajo. Iae na hejajëjo. God-are jöho surire jajivoromo uvëꞌe höjo: God jero asisöꞌohuꞌo asisöꞌo inino mahuꞌo avohëvëꞌego jasi ihoho mabëhe uvoruomaje höjo. Ësurire jöho rabëni bogo avoho gavarije höjo. ");
INSERT INTO aom_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Ëhi uënugoromo Iesuro ë rëmoromo Jerusalem amore jioromo vaꞌoromo Bethany amore höröromo vahie gemu ë hijadeje. ");
INSERT INTO aom_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Hijëꞌëro sisonuvamu gagorovo Iesuro Jerusalem amo börömore vuonoröꞌö vaꞌi vaꞌadeje. Örire vaꞌamu hömadeje. ");
INSERT INTO aom_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Hömamu vaꞌihö gavade mesoho öri ionire namijamu gagorovo bëhire vaꞌoromo gavadeje bajoho bogojioꞌi ma-hano ruduꞌemu jiamu. Ma-hano ruduꞌemu jiamu gagorovo mesoho uavadeje: Ijoho nadi bajoho raenëjo. Ëhi uavamu gagorovo mesoho ma-burëro sahorijadeje. ");
INSERT INTO aom_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Sahorijamu gagorovo Iesuare ijorajoho jaburo tiöromo uavareje: Diehiꞌego mesoho ma-burëro sahorijajëjo. ");
INSERT INTO aom_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Sahorijajëjamu Iesuro uëvadeje: Ave jöho na jö mae uëꞌiëꞌajëjo. Jemë bogo uehore niöꞌi baeꞌirögoro God gemu mae uehorovëꞌoho naehu meso avohode ëhi jiëꞌe mu vaejëꞌoho eni jëvoꞌajëjo. Röhu bogo ëhemuoho vaeꞌi ave dahoru uavëꞌoho: Riꞌöromo vaꞌo jovo börömoro buꞌörovonë uavëꞌoho iae ëhi jioꞌaꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","O rabe rabe God ua gavëꞌoho mae uehorovoromo uvëꞌoho: God-ro ajemiꞌajë uvëꞌohuro ëhuro iae baeꞌaꞌarujëjo. ");
INSERT INTO aom_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Ëhi uënugoromo Iesuro God-are amo börömore ajiomadeje. Ajiomoromo God-are jö bëhoho ae röjëhijadeje. Röjëhijamu priest masijohuꞌo a duvaho ömoꞌömohuꞌo ëho jaburo rueromo uavareje: Jaehu God-are amo börömore hiromo mue gö gö vaejanuoho diehi jiëꞌe daruge javoromo o raro darugoho bojamijëꞌëro ëhi jiëꞌe muoho vaejanue höjo. ");
INSERT INTO aom_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Vaejanue höjamu Iesuro uëvadeje: Nasi darugo hesi jö ue gevarujoho naꞌo jemë jöe gemu uë gëꞌiëꞌajëjo. Jemëhu mana uevëꞌoho naro jemë uëꞌejöjo: Na ëhi jiëꞌe darugohuro muoho vaejaje höjo. ");
INSERT INTO aom_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","John-hu bapataeto vaejavuonövadoho ë darugoho dinöꞌe baejade höjo. Na God-ro o ma-aëro darugoho bojamijëꞌëro ëhioho ëꞌonövade höjo. Ëꞌonövade höjamu rue a masijohuro Iesu diehi mana uaꞌiröhe jöho jabesi mevoromo uarovareje: Noehu uavëꞌoho God-ro John darugoho bojamijade hö uavëꞌoho Iesuro uöꞌaꞌajëjo: Ëhi jiëꞌoho jemë rabëni John bogo ma uehorovarije höjo. ");
INSERT INTO aom_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","O noehu Iesu uaꞌiröhoho: Ma-aëro John uavamu ëꞌade hö uaꞌiröhoho röhu ae ahoꞌobëhe juhuonëmiromo bogo ëhioho uaꞌejarëjo ë hesi bëhoho jaburo uvoruomëꞌëro: John hu jö God-aro baeromo majahuinövade ae hö uvoruomëꞌëro. ");
INSERT INTO aom_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Ëhi uarovoromo Iesu uavareje: Jaehu uö gövuanue jö hesi bëhoho no dadivavuajëjo. Dadivavuajëjamu hegorovo Iesuro uëvadeje: Ëhi jiëꞌoho jemëhu uevarije jöho naꞌo bogo uëꞌejöjo: Na ëhi jiëꞌe darugohuro muoho vaejaje höjo. ");
INSERT INTO aom_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Röhu ave uhu jö heromo diehi uehorovarujoho majehirego na heꞌiröjo. Iae ae gemu hu harihe niöꞌi jëvade höjo. Harihe niöꞌi jëvëꞌëro vavuohuro vaꞌoromo murioho uavade höjo: Jueꞌi jaruvo grape öꞌi bajo muoro vaꞌoromo mue vaejehonëjo. ");
INSERT INTO aom_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Vaejehonëjamu muriohuro riꞌöromo uavade höjo: Na bijönegajëjo. Bijönegajë uanugoromo röhu ijonö avoho uehorovoromo mue vaejahoꞌi vaꞌade höjo. ");
INSERT INTO aom_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Ëhiꞌamu vavuohuro vaꞌoromo ijorajoho jöe gemuoho majahiromo uavade höjo: Muoro vaꞌoromo mue vaejehonëjo. Vaejehonëjamu ijorajohuro uavade höjo: Apo iae na vaꞌejö uaromo röhu bogo vaꞌade höjo. ");
INSERT INTO aom_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Ëhi jiëꞌoho di ahuro vavuehu nimadëhioho vaejade höjo. Vaejade höjamu uëvareje: Muriohurajo. Muriohurajamu Iesuro uëvadeje: Ave jöho na jö mae uëꞌiëꞌajëjo. Vajiohuꞌe tax baejarue ariböviohuꞌo önöꞌe jijiharue magonahohuꞌo ëho jaburo jemë iosirëmiromo urimo God-are aharire vaꞌoromo raromego huro jabumë muebejëvaje höjo. ");
INSERT INTO aom_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Rabëni hesi bëhoho John-ro jemesirire rovade höjo öri maho röjëhijego gaꞌirarijego. Rovamu jemëro hu bogo ma uehorovoꞌirögoro vajiohuꞌe tax baejarue ariböviohuꞌo önöꞌe jijiharue magonahohuꞌo ëho jaburo hu mae uehorovoruomade höjo. Mae uehorovamu jemëro ëho garomo röhu bogo avoho uehorovoromo huotorovoromo John ma uehorovarije höjo. ");
INSERT INTO aom_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Röhu uhu jöe göꞌo majëhiꞌiëꞌajoho hehëjo. Iae saꞌa arijoꞌe ae gemuëro mure grape öꞌoho bivoꞌamade höjo. Bivoromo ë muoho buore iromo rovaꞌo rojomoromo öꞌi bajo saꞌijovoröhe guaho umoromo mu javue döro vaejade höjo hesi mu ahuro ajio ë hiromo muoho atovoröhego. Ëhi avohoromo gavade eni jiamu gagorovo ae uëvade höjo: Na vaꞌejöjo. Jemëro nasi muoho muebejehorëjo. Mueberomo öꞌi bajoho raeromo mavego nasiroho bahiꞌi ioroꞌioroho jemesi ujuohorëjo. Ëhi uënugoromo riꞌöromo vaꞌo saꞌa göro ë hijade höjo. ");
INSERT INTO aom_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Saꞌa göro vaꞌoromo hijuvo gavade öꞌi bajo urarue majaho dunovamu gagorovo hesi mu vaejaharue aribövioho uëvade höjo: Vaꞌirarijoho mu muebejarue aribövioho uërego nasi öꞌi bajoho iꞌimëmego ujuoheho ruerëjo. ");
INSERT INTO aom_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Ujuoheho ruerëjamu hegorovo vaꞌare höjo. Vaꞌoromo suorovamu gëgorovo mu muebejarue ariböviohuro guduamëvare höjo. Guduamëvoromo göho hisuebiꞌi göho ano bamoꞌi göho munëro vajamijamu guomade höjo. ");
INSERT INTO aom_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Ëhiꞌamugo mu arijoꞌohuro mu vaejaharue ae göꞌo rëmöꞌöjade höjo mure vaꞌoröhego. Urimo mu vaejaharue ae gemu gemu rëmöꞌöjëꞌëro röhu evaroho ae ahoꞌobëhe rëmöꞌöjade höjo. Rëmöꞌöjamu vaꞌoromo mure suorovamu gëgorovo mu muebejarue ariböviohuro urimo rueruomamu ëꞌarëhi ëhi sisë vaejëvare höjo. ");
INSERT INTO aom_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Sisë vaejëvamu ijo tugohoꞌi mu arijoꞌohuro uvade höjo: Arue mu muebejarue ariböviohuro nasi harihoho garomo uvoꞌaꞌaruëjo: Nöruare harihe hö uvoromo ëhuni mae uehorovoꞌaruëjo. Ëhi uvoromo nugöꞌöjamu mure vaꞌade höjo. ");
INSERT INTO aom_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Vaꞌo höröjamu garomo uarovare höjo: Arue rovaje ahuro hesi vavu hesi sionoho bae hesi höjo. Ëhuni ëꞌego ano bamoromo hesi saꞌaho nosi baejarëjo. ");
INSERT INTO aom_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Ëhi uarovoromo ë aho mure jiamu guduamoromo roriꞌo bijimo buꞌöromo anamu guomade höjo. Ëhiꞌare höjo. ");
INSERT INTO aom_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Ëhi jiëꞌoho mu arijoꞌohuro mure rovëꞌiroho mu muebejarue aribövi jabesi öriroho diehiꞌëvoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Diehiꞌëvoꞌajëjamu uavareje: Sisë jioruomoꞌego ijumëvo barëromo muoho a maho bojëmiꞌajëjo jaburo mueberöhego. Mueberomo majae eni jiego öꞌi bajoho uroromo hesiroho iꞌimamiröhego. ");
INSERT INTO aom_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Ëhi uëvamu hegorovo Iesuro uëvadeje: Ave uhu jöho God-are surire jajivoromo uvëꞌe höjo: Munë javue vaeꞌirögoro munë gemu bijönimoromo vuonugare höjo. Vuonugaroho jaruvoho ë munëhuro javuoho nigemoꞌego bibivoromo mae namijajëjo. Hesi Bada God-ro ëhi ëꞌade höjo. Ëho noro garomo uvarue höjo: God-ro mu mabëhe ëꞌëꞌe höjo. Ëjö God-are surire jajivamu adaharijoho jemë diehiꞌoromo ë hesi bëhoho bogo avoho baejarije höjo. ");
INSERT INTO aom_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Ëhuꞌëro jiëꞌëro naro jemë uëvajëjo: Jemëhu God-are aharire raromoromo hesi mu muebebe rovarije muoho God-ro baeniëhiromo ae gö bojëmiꞌiramu jaburo hesi aharire raromoromo ë muoho mueberomo rae avohoꞌaruëjo. ");
INSERT INTO aom_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Röhu aehu ë munë döre bejëꞌoho ahoro ahoro baeꞌaꞌajëjo. O ë munëhu a döre berovëꞌoho aho saꞌijovo barëꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Iesuro uhu jöe gö gö ëhi jövamu hegorovo priest masijohuꞌo Pharisee ariböviohuꞌo ëho jaburo garomo uvareje: Nosi jöe jövajëromo ");
INSERT INTO aom_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","guduamo bavaꞌiëꞌoromo uvareje: Ae ahoꞌobëhe uvoruomaje höjo: Iesu hu jö God-aro baeromo majahuijaje ae hö uvoruomaje hö uvoromo jabumë juhuonëmiromo vuonugareje. ");
INSERT INTO aom_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Iae Iesuro röhu maho uhu jöe gö gö ae majëhijadeje. ");
INSERT INTO aom_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","Majëhiromo uëvadeje: God-hu böröme namiromo muebejëvaje öroho aviëhi höjo. Saꞌa a böröme gemuëro söröe baejade höjo hesi harihohuro masuromo iröhego. ");
INSERT INTO aom_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Ëhi ëꞌëꞌëro hesi mu vaejaharue aribövioho uëvade höjo: Vaꞌirarijoho rueröhego naehu mamiꞌe uëvode aribövioho uërego rueꞌirarëjo. Rueꞌirarëjamu uëvamu bijönimoruomade höjo. ");
INSERT INTO aom_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Bijönimamu hegorovo saꞌa a börömohuro mu vaejaharue a ioroꞌioroho uëvade höjo: Söröre rueröhego uëvodoho ëhi uërëjo: Jöe hehëjo. Nasi söröho eni jiëꞌe höjo. Nasi mi masije ma-mabëhe naehu ma-je mioꞌamaje sanuovëꞌe mioho bijuëmoromo buvomoromo bahijëꞌe jevajëjo. Bövie biseꞌe eni avohëꞌe jevajëjo. Ëhuni rovego no ë söröho iꞌirarëjo. Ëhi uërëjo. ");
INSERT INTO aom_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Ëhi uëvamu jöho bavaꞌoromo majëhijamu ë ariböviohuro bogo ejëhëꞌe öre gö öre gö vaꞌare höjo. Göëro hesi mure vaꞌade höjo. Göëro hesi moni muro vaꞌade höjo. ");
INSERT INTO aom_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Ioroꞌiorohuro ë anu rovare aribövioho guduamëvoromo mu sisë vaejëvoromo muoꞌamare höjo. ");
INSERT INTO aom_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Ëhiꞌamu ë saꞌa a börömohuro dë vörönimade höjo. Dë vörönimamu muorovo aribövioho rëmöꞌöjamu jaburo ë anëgare aho muoꞌamoromo jabesi amoho bueꞌöjëhare höjo. ");
INSERT INTO aom_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Bueꞌöjamu gagorovo a börömohuro hesi mu vaejaharue aho uëvade höjo: Söröho eni jiëꞌe höjo. Röhu rueromo sörö ihë uëvamu juahemijare ariböviehu rueromo sörö ijëꞌoho sisë höjo. ");
INSERT INTO aom_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Ëhuni öri masijoro vaꞌirarijoho vaꞌoromo ae rahu rahu birohëvëꞌoho uëvego söröro rueꞌirarëjo. ");
INSERT INTO aom_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Rueꞌirarëjamu hegorovo rue mu ariböviohuro örire vaꞌoromo a sisëhuꞌo a mahuꞌo birohëvoromo ahoꞌo sö ujuoho rovare höjo. Rueruomamu sörö osaho rarovade höjo. ");
INSERT INTO aom_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Rarovamu a börömohuro ë aribövioho gëꞌi osare rovade höjo. Rueꞌi gavade höjo ae gemu masuvarue sörö iꞌi ioꞌamarue niögoho bogo baꞌamëꞌe ma-hijamu. ");
INSERT INTO aom_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Ma-hijamu gagorovo uavade höjo: Isiajo. Masuvarue niögoho bogo baꞌamëꞌe ja diehiꞌoromo ave osaroho rovane höjo. Osaroho rovane höjamu ruehuro jörumoraejade höjo. ");
INSERT INTO aom_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Jörumoraejamu rue a börömohuro riꞌöromo mu aribövioho uëvade höjo: Övo höruꞌoho tövoꞌamoromo babuꞌöhego amonö ramoramore vaꞌo hijajo. Ëdiröꞌore ae ahoꞌobëhe nierusuburuꞌe bamoromo ane jaꞌiho vuogigimoruomoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Ëhesi bëhoho God-ro ae ahoꞌobëhe ruejöro uëvaje höjo. Röhu ae ma-gemu gemu hesinö jëvojöro baejëvaje höjo. ");
INSERT INTO aom_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Ëhiꞌamu iae Pharisee ariböviohuro vaꞌoromo jöe atoromo uarovareje: Ëꞌego no Iesu sareramego hu guaro berovoꞌirajo. ");
INSERT INTO aom_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Ëhi atonugoromo jabesi ijore ijore jijiharue a ioroꞌiorohuꞌo Herod-are aribövi ioroꞌiorohuꞌo rëmöꞌöjamu vaꞌoromo Iesu sarerisareriamiromo uavareje: Tisajo. Iae no gavarue höjo ja a mae javëꞌëro God-are mu örohemu röjahuijego. O aho bogo juhuonëmijego. Ëhesi bëhoho jero no göromo ae böröme o biseꞌe javuajëromo jöe gö gö bogo röjahuijanue höjo. ");
INSERT INTO aom_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Ëhuni ave jöho ja diehi uehorovanuoho majahuijego no hejarëjo. Rome a börömohuro nosi saꞌaho muebejego noro hu tax bojamijarue höjo. Noehu ëhi ëꞌaruoho na ëhuro nosi jögoroho aharue höjo o bogajo. ");
INSERT INTO aom_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Bogajamu Iesuro gëromo uvadeje: Jabumë sisë vaejevoꞌi ue gevaruëromo uëvadeje: Sareri aribövie jëvajëjo. Jemë rabëni na bijioho gevarujëjo. ");
INSERT INTO aom_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Tax a bojëmijaruje ijo bajoho röjehihego na gavöjo. Gavöjamu ijo bajoho barovareje. ");
INSERT INTO aom_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Barovamu garomo uëvadeje: Aveho rahuare nu anoꞌohuꞌo ihohuꞌo jajivëꞌe höjo. ");
INSERT INTO aom_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Jajivëꞌe höjamu uavareje: Rome a börömo hesi höjo. Rome a börömo hesi höjamu uëvadeje: Ëhuni Rome a börömo hesiroho ëho hesi öroro bojamiꞌi God-aroho ëho God-are öroro bojaminövorëjo. ");
INSERT INTO aom_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Ëhi uëvamu hegorovo tiöjëvamu Iesu ë nugoꞌi vaꞌoruomadeje. ");
INSERT INTO aom_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Vaꞌamu gagorovo majae gemuore Jew rajo a masijo ioroꞌiorohuro rovareje. Jabumë Sadducee jö uehorovarue aribövie jioruomadeje. Sadducee ariböviohuro uehorovoromo uvoruomajeje: A vuovëꞌoho ijonöho bogo riꞌöꞌamoꞌi ma-ioroꞌiore gemu vuovoꞌajëjo. Ëhi uvoruomaje ariböviohuro rueromo Iesu guaro berovojöro sarerisareriamiromo uavareje: ");
INSERT INTO aom_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Tisa Moses-ro jögore jajivoromo uövuëꞌe höjo: Aboji harihuꞌo rumoꞌe vuovego diehi ëꞌiröhe öroho aviëhi höjo. Aehu vaboro masuromo vaboroho aboji harihuꞌoho bogo vaejëꞌe baruehu guomoꞌi vaboro nugëꞌoho hesi öhuro vuojiroho masuromo ëhuro guomade ö hesi ihoro ujoho vaejahoꞌajëjo. Moses-are jögoroho ëhi höjo. ");
INSERT INTO aom_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Ëhi jiëꞌëro iae ae ahoꞌobëhe 7 ma-ö ömoꞌömëremu nosirire raromare höjo. Raromoromo muriohuro magonahoho masuvade höjo. Masuromo vaboroho aboji harihuꞌoho bogo vaejëꞌe baruoho guomade höjo. Guomamu hesi vaboroho dorue hijamu gagorovo ö göhuro vuojiroho masuvade höjo. ");
INSERT INTO aom_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Masuromo guomade höjo. Ö ömoꞌömo ioroꞌioroho ëhi gemuoho ëꞌobe rovare höjo. Ö ömoꞌöme 7 jabuhu ë magonahe gemuoho masube rovaroho ë magonahoho aboji harihuꞌoho bogo vaejëꞌe aho ma-vuovëvobe rovade höjo. ");
INSERT INTO aom_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Vuovobe ruejuvo barëjamu ijo tugohoꞌioho ë magonahoho huꞌo guomade höjo. Ëhiꞌare höjo. ");
INSERT INTO aom_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Ëhi ëꞌarohuni ëhuni ave jöho no ua gaꞌiëꞌaruëjo. Jero uvanue höjo: Vuovoromo riꞌöꞌejarëjo. Ëhuni vuovëꞌe ariböviehu riꞌöruomoröhe majaroho ae 7 höjo röhu ë magonahoho di ahuꞌo hiꞌaꞌajëjo. Barue ahoꞌobëhe masuvëꞌego ëhuni uavaruëjo. ");
INSERT INTO aom_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Ëhi uavamu hegorovo Iesuro uëvadeje: Bogajo. God-are surire jöhuꞌo huhu mu vaeröhe darugohuꞌo jemë bogo avoho gavarujëro sisëꞌi uehorovoromo ue gevarujëjo. ");
INSERT INTO aom_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Ëhesi bëhoho vuovëꞌëro riꞌöruomoꞌiröhe maja rovëꞌiroho vaboroho baruoho bogo masurovoꞌi aneraehu öꞌidöre ma-raromaruëhi ëhi raromoꞌaruëjo. Ëhuni ë magonahehu di ahuꞌo hiꞌiröhe jö ue gevarujoho bëhi rumoꞌe höjo. ");
INSERT INTO aom_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Ëjöho jemëro uvaruje höjo: Vuovëꞌe ariböviehu riꞌöꞌiröhe jöho sareri jöe höjo. Ëho bogo sareri jöehu jioꞌi jö mae höjo. Ëhesi bëhoho vuovoromo riꞌöꞌiröhe jöho God-ro jemëni jövamu hesi surire jajivoromo uvëꞌe höjo: ");
INSERT INTO aom_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Na Abraham Isaac Jacob ëhi muebejëvaje ae jevajëjo. Jemë rabëni ë jö hesi bëhoho bogo avoho baejarije höjo. God-hu Abraham Isaac Jacob muebejëvaje jö hesi bëhoho jabumë vuovoromo bogo ioroꞌioremuoho barëꞌi vaꞌo raromego muebejëvaje höjo. God bogo vuovoromo ioroꞌioremu barëjëꞌe aribövioho muebejëvoꞌibejajo. Aꞌi hu vuovoromo vaꞌo raromarue aribövioho iae muebejëvaje höjo. ");
INSERT INTO aom_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Iesuro Sadducee aribövioho ëhi uëvamu ae ahoꞌobëhe heromo jöe barëjëvadeje. ");
INSERT INTO aom_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Ëhiꞌamu Pharisee ariböviohuro hejare uvavamu: Iesuro jö mae jövamu ëhuro Sadducee aribövioho jö mana majahiꞌiröhoho bogohö uvavamu hegoro gagovorovareje. ");
INSERT INTO aom_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Gagovorovonugoromo Jew rajo jögoru öri röjëhijaje ae gemuëro Iesuare dëho bijioho gaꞌirögoro riꞌöromo uavadeje: ");
INSERT INTO aom_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","Tisajo. God-hu bojamuijade jögore ahoꞌo jioꞌamajoho di jöho börömoho höjo. ");
INSERT INTO aom_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Börömoho höjamu uavadeje: Jasi dë vövöbajoꞌe aruꞌahe uehore ahoꞌobëhe Bada jasi God ma-hu gemu bojaminëjo. ");
INSERT INTO aom_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Ëho jö börömo börömoho jiëꞌego ëho nuniroho höjo. ");
INSERT INTO aom_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","O ë jö hesi bëhirohuꞌo iae gemuoho höjo. Jaehu jasi arijoꞌarije rajahirovanuëhi jasi ae gemuoho ëhi rajahinëjo. ");
INSERT INTO aom_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Dë vövöbajoꞌe ahoꞌo God bojamiꞌirane jöhuꞌo jasi ae gemuoho rajahiꞌirane jöhuꞌo bëhoho jëvajëjo. God-are surire jö Mosesꞌo jö God-aro baeromo majëhinövare a ioroꞌiorohuꞌo jajivoꞌamaroho ëho ado sirinoꞌoho jioꞌamajëjo. ");
INSERT INTO aom_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Iae Pharisee ariböviohuro gagovoruomamu gavëꞌi Iesuro uëvadeje: ");
INSERT INTO aom_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","Böröme namiromo ajëmiꞌiröhe a hesi jöho jemë diehi uehorovarujëjo. Hu rahuare ujoho höjo. Uavareje: Hu David-are ujoho höjo. ");
INSERT INTO aom_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","David-are ujoho höjamu uëvadeje: Ëhi jiëꞌoho God-are Aruꞌahoho rabëni uavamu David-ro böröme namiromo ajëmiꞌiröhe aho Bada uavade höjo. ");
INSERT INTO aom_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Ëhesi jöho David-ro God-are surire jajivoromo uvëꞌe höjo: God Badaro nasi Bada uavade höjo: Nasi övo manö rojo hijego jaꞌo muorovarue aribövioho naro ruahöꞌöjëvego hörëro vijuvo taemoꞌamoꞌirane höjo. ");
INSERT INTO aom_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Ëhesi bëhoho böröme namiromo ajëmiꞌiröhe a hesi jöho David-ro jajivoromo uvëꞌe höjo: Bada höjo. Bada hö uvëꞌe jiaje ëhuni nadi uvorëjo: Böröme namiromo ajamuiꞌiröhe aho ma-David-are uje höjo. ");
INSERT INTO aom_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Ëhi uëvamu aehu Iesu mana uaꞌiröhoho bogo eni jëvadeje. Bogo eni jëvamu ijonö jöe gö gö ua gaꞌiëꞌaroho juhuonivoromo vuonugareje. ");
INSERT INTO aom_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Ëhiꞌamu Iesuro hesi ijorajo ömoꞌömohuꞌo a ioroꞌiorohuꞌo ahoꞌobëhe uëvadeje: ");
INSERT INTO aom_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","Jew rajo jögoru öri röjëhijarue ariböviohuꞌo Pharisee ariböviohuꞌo ëho jaburo Moses-are sionoho baejëꞌe höjo. ");
INSERT INTO aom_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Moses-are sionoho baejëꞌe jëvaje ëhuni mu jö rabe rabe uëvëꞌoho ejëhoromo ëhi vaenövorëjo. Aꞌi jabuhu ömaruëhioho nadi ëhioho ömorëjo. Rabëni hesi bëhoho jö majëhijaruëhioho muoho bogo ëhioho vaejarue höjo. ");
INSERT INTO aom_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Aehu iꞌuꞌe inömo ujuoho vaꞌoruomojöro buahore bahijëhoromo tövëhoromo vaꞌego bogo ajëmiromo övo namehu vitu banigojiomëharuëhi ë Pharisee ariböviohuꞌo jögoru öri röjëhijarue ariböviohuꞌo jaburo ëhi ëꞌarue höjo. Iꞌuꞌe muoho ahoꞌo ae bojëmiromo bogo mae bogo ajëmiꞌi ma-nunëremu gëvarue höjo. ");
INSERT INTO aom_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Jabu mu rabe rabe vaejëꞌoho aëro gëjöro ma-döhemu vaeruomaje höjo. Ëhesi bëhoho jabumëro nimoruomaje höjo aëro gëromo uvoruomoröhego: Jabumëremu God mabëhe uehorovoruomaje höjo. Aëro ëhi uvoruomoröhego nëgego God-are jöꞌe suri surioho maua gagore bahiromo övo ahore varijore muoho taemoruomaje höjo vaꞌorahoro jioꞌamego aëro garuomojöro. O God-are örire jö atoꞌi ioꞌamarue niögure öꞌi ëgobövie be ioꞌamoruomaje höjo vaꞌorahoro jioꞌamego aëro garuomojöro. ");
INSERT INTO aom_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","O sörö iꞌi vaꞌëꞌoho o God rajahijarue osare vaꞌëꞌoho a masijehu raromaruire ë vaꞌo raromoꞌi nimarue höjo. ");
INSERT INTO aom_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","O imoꞌamaruire vaꞌëꞌoho nimarue höjo ae ahoꞌobëhe uvoruomoröhego: Jabumë a masijëro jijihajëromo rajëhiromo jejëmiruomoröhego. O nimarue höjo aëro jejëmiromo uëröhego: Tisajo. ");
INSERT INTO aom_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Röhu ae göehu jemë döre bamëvoromo uëvëꞌoho: Tisa uëvëꞌoho ëhi jiëꞌoho sisë höjo rabëni hesi bëhoho jemë ö ömoꞌömëremu jëvoꞌi jemesi Tisaho na gemu jevëꞌego. ");
INSERT INTO aom_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","O ave saꞌare raromarue aribövioho nadi döroho bamëvoromo uërëjo: Apajo. Ëhesi bëhoho ae gemu öꞌidöre hijajoho ëho iae jemesi Vavu Börömoho höjo. Ëhuni ëhi jiëꞌe jöho nadi uërëjo. ");
INSERT INTO aom_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","O ae göehu jemë döre bamëvoromo uëvëꞌoho: Simano vaejanue aho javajë uëvëꞌoho ëhi jiëꞌoho sisë höjo. Ëhesi bëhoho jemesi Simano Vaejaje Aho ma-gemu jevajëjo böröme namiromo ajëmijaje ahuro jevëꞌëro. ");
INSERT INTO aom_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Aꞌi a masije jemesirire jioruomajoho ëhi jiëꞌe aribövioho mu ajëmiꞌiröhe aribövie jioruomoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Ae rahu sivu uehorovoromo döre bamorovëꞌoho hesi ihoho abueꞌaꞌajëjo. O ae rahu baꞌobuerovëꞌoho hesi ihoho döro ajiomoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Vaevëꞌe jögoru öri röjëhijaruje ariböviohuꞌo Pharisee ariböviohuꞌo jemë ma-döëremu muoho ömarujëro sisërëjëvoꞌajëjo. Ëhesi bëhoho God-hu böröme namiromo muebejëvego hesi aharire raromoruomoꞌiröhe öroho tugohëharuje höjo aëro ë vaꞌo raromojöëni. Jemë God-are ahariroho bogo vaꞌo raromoꞌi nimaruje höjo. O ae göehu God-are aharire vaꞌo raromoꞌiaꞌamu gëvëꞌoho ahëvaruje höjo. ");
INSERT INTO aom_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Vaevëꞌe jögoru öri röjëhijaruje ariböviohuꞌo Pharisee ariböviohuꞌo jemë ma-döëremu muoho ömarujëro sisërëjëvoꞌajëjo. Ëhesi bëhoho magonaho doru jabesi bövioho biseꞌoho ëma ujuohëharuje höjo. Ëma ujuohëhoromo sarerivoromo pari ëgobövie jaguvaruje höjo aëro gëromo uvojöro: Mu mae vaejaruëjo. Ëhi jiëꞌe sareriꞌe muoho vaejarujego ëhuni God-ro iꞌu börömo mae bojëmiꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Vaevëꞌe jögoru öri röjëhijaruje ariböviohuꞌo Pharisee ariböviohuꞌo jemë ma-döëremu muoho ömarujëro sisërëjëvoꞌajëjo. Ëhesi bëhoho jemëro jovo göre göre saꞌa göre göre ae dinëmibe vaꞌaruje höjo ma-ae gemuëro hesi muoho vuonugoꞌi Jew rajo muoho baeröhego. Ae dinëmibe vaꞌoromo gavaruje aho jemesi jöho ejëhoromo Jew rajo mu baejamu gavëꞌoho jemëro ë aho mu sisë röjahijego mae höromo vaeromo jemëhu sisë ëꞌoromo vëniꞌe örire vaꞌarujoho ë ahuro jemë iosirëmiromo sisë börömo bëhe ëꞌoromo vëniꞌe örire vaꞌo hesi höjo. ");
INSERT INTO aom_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Vaevëꞌe nuni ramoramovëꞌe aribövi jemëhu ae gö öri röjëhiꞌiëꞌarujoho sisërëjëvoꞌajëjo. Ëhesi bëhoho jemëro ae ëma majëhiromo uëvaruje höjo: Ae rahu darugoꞌe jö uvoꞌiëꞌoho God-are osa börömo hesi iho uvoromo ae uëvëꞌoho: Na mue ëhi ëhi ëꞌejö uëromo röhu mu bogo vaejëꞌoho iae hesi höjo. Aꞌi God-are osa börömore jioꞌamaje gold hesi iho uvoromo ae uëvëꞌoho: Na mue ëhi ëhi ëꞌejö uëvëꞌoho iae ë muoho vaeꞌaꞌanuëjo. Bogo sarerivoꞌanuëjo. ");
INSERT INTO aom_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Nune ramoramovoromo simane sisëꞌi uehorovëꞌe aribövie jëvajëjo. Ëhi majëhijaruje hesi bëhoho nani jemëro uvaruje höjo: God-are osa börömo hesi ihoho biseꞌe jioꞌi God-are osa börömore jioꞌamaje gold-ho iho böröme höjo. Röhu ë gold-ho bogo God-are osa börömoroho jioꞌamoꞌibejajo bogo God-are gold maho jioꞌamoꞌibejajo. Aꞌi ë gold-ho God-are osa börömore jioꞌamëꞌëro ëhuꞌëro ëho gold maho höjo. Gold-huro bogo God-are osa börömoho iosiramiromo iho börömoho jioꞌi God-are osa börömo hesi ihohuro gold ihoho iosiramiromo bövioho jiaje höjo. ");
INSERT INTO aom_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","O jemëro jöe gö ëma majëhiromo uëvaruje höjo: Ae rahu darugoꞌe jö uvoꞌiëꞌoho God-are maratu hesi iho uvoromo ae uëvëꞌoho: Na mue ëhi ëhi ëꞌejö uëromo röhu mu bogo vaejëꞌoho iae hesi höjo. Aꞌi God-are maratu döre bahijahare suvuoro hesi iho uvoromo ae uëvëꞌoho: Na mue ëhi ëhi ëꞌejö uëvëꞌoho iae ë muoho vaeꞌaꞌanuëjo. Bogo sarerivoꞌanuëjo. ");
INSERT INTO aom_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Nuni ramoramoꞌe aribövie jëvajëjo. Nani jemëro uvaruje höjo: God-are maratu hesi ihoho biseꞌe jioꞌi God-are maratuore jioꞌamaje suvuoroho iho böröme höjo. Röhu ë suvuoroho bogo God-are maratuoroho jioꞌamoꞌibejajo bogo God-hu ujuohoꞌiröhe suvuoro maho jioꞌamoꞌibejajo. Aꞌi ë suvuoroho God-are maratuore jioꞌamëꞌëro ëhuꞌëro ëho suvuoro maho höjo. Suvuorohuro bogo God-are maratuoho iosiramiromo iho bövioho jioꞌi God-are maratu hesi ihohuro suvuoro ihoho iosiramiromo bövioho jiaje höjo. ");
INSERT INTO aom_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Aehu darugoꞌe jö atoꞌiëꞌiroho God-are maratu hesi iho darugoꞌo majëhijëꞌoho ë hesi bëhoho bogo maratu hesi ihohemu uvoꞌi maratuore jioꞌamaje suvuoro hesi ihohuꞌo uvoromo ëꞌarue höjo. ");
INSERT INTO aom_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","O ae rahu God-are osa börömo hesi iho darugoꞌo majëhijëꞌoho ë hesi bëhoho bogo osa hesi ihohemu uvoꞌi osare hijaje A hesi ihohuꞌo uvoromo ëꞌarue höjo. ");
INSERT INTO aom_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","O ae rahu öꞌidö hesi iho darugoꞌo majëhijëꞌoho ë hesi bëhoho öꞌidöre jiaje God-are röho hesi ihohuꞌo ë hijaje a hesi ihohuꞌo uvoromo ëꞌarue höjo. Ëhuro darugoꞌo majëhijarue höjo. ");
INSERT INTO aom_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Vaevëꞌe jögoru öri röjëhijaruje ariböviohuꞌo Pharisee ariböviohuꞌo ma-döëremu muoho ömarujëro sisërëjëvoꞌajëjo. Jemëro jemesi i jögoru e avohoromo iꞌo buarohoromo ijarue rihuꞌe oso harihu harihue gö gö garue gö gö mevoromo 10 10 bahibe vaꞌoromo gemu gemu God suvuore bojamijaruje höjo. Ëhi jiëꞌe jögoru ininoho ejaho avoharuje höjo. Ëhi jiëꞌoho iae mae höjo. Nadi vuonugorëjo. Röhu ëho ma-jianovoꞌi jö ioroꞌioroho masijo jiajoho ëho bogo uehorovaruje höjo. A ma-mae vaejëvoꞌirarije muoho a huë baejëvoꞌirarije muoho ahorire vaejëvoꞌirarije muoho ëho rumonimaruje höjo. Nadi rumonimoꞌibejarijëjo. ");
INSERT INTO aom_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Majo majo biseharihehu jemesi jovore bevaꞌëꞌoho io buꞌöromo jovoho iꞌi majo börömo börömoho bogo avoho gavëꞌe ma-nimuꞌöjaruje höjo. Jö masijoho bogo uehorovoꞌi ma-jö ininohemu uehorovaruje höjo. Ëhuro nunoho ramoramovëvego öroho sisëꞌi röjëhijaruje aribövie jëvajëjo. ");
INSERT INTO aom_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Vaevëꞌe jögoru öri röjëhijaruje ariböviohuꞌo Pharisee ariböviohuꞌo ma-döëremu muoho ömarujëro sisërëjëvoꞌajëjo. Jemë hevöe enatue dönöhemu uꞌoꞌamaruje höjo. Gagonöho ae gö jabesi ie jove vajiohëro ujuohoromo aegëꞌëro irijiomoꞌamëꞌe höjo. Ëhuꞌëro dönöho aje jioꞌi gagonöho vaꞌinumiꞌe jioꞌamajëjo. Jemesi mu sisëho ëhi jianovajëjo. ");
INSERT INTO aom_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Pharisee jemë ae gemu gemu nuni ramoramoꞌe ae jëvajëjo. Urimo ae gö jabesi iohuꞌo jovohuꞌo vajiohehu ujuohoromo hevöre bahiromo enatuore oteharujoho vuonugorego hevö o enatu gagoroho vaꞌinumoho bogojioꞌirajo. Ëhi ëꞌëꞌoho jemesi hevöhuꞌo enatuohuꞌo döhuꞌo uhohuꞌo ma-mae jioꞌamoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Vaevëꞌe jögoru öri röjëhijaruje ariböviohuꞌo Pharisee ariböviohuꞌo jemë ma-döëremu muoho ömarujëro sisërëjëvoꞌajëjo. Jemesi jöho uhuꞌe uëꞌiëꞌajëjo. Vuovëꞌe sino bahiꞌamarue munëho aëro ajivëꞌe osëro buejahoꞌamarue höjo nu anoꞌe mae jioꞌamoröhego. Buejahoꞌamego dönöho ajivëꞌe mabëhe jioꞌamoꞌi gagonöho vuovëꞌe a jabesi ijoꞌahohuꞌo sagohohuꞌo ëhuremu jioꞌamajëjo. Jemë ëhi jiëꞌe jëvanovajëjo. ");
INSERT INTO aom_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Döhemu mae jëvego aëro gëromo uvoruomaje höjo: Jemë a mae jëvajëjo. Aꞌi jemesi uhoho sareri sareriꞌe mu sisëmu vaejaruje jëvajëjo. ");
INSERT INTO aom_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Vaevëꞌe jögoru öri röjëhijaruje ariböviohuꞌo Pharisee ariböviohuꞌo ma-döëremu muoho ömarujëro sisërëjëvoꞌajëjo. Jö God-aro baeromo majëhinövare aribövi jabesi sino guavoꞌamare huoho avohoꞌamaruje höjo. Mu mae vaejare a mami jabesi huoho avohoromo muebejaruje höjo. ");
INSERT INTO aom_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Avohoromo mueberomo jemë uvaruje höjo: Nosi hijo mionoꞌehu raromare majaroho evaroho noꞌo javuoꞌibejajo no jabumë bogo ajëmiromo God-are jö majëhijarue aribövioho muoꞌamoꞌibejarëjo. ");
INSERT INTO aom_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Iae mae-ëjo. Ëhi atarujoho ëho jemëro huruoho majahuiromo uöromo ëꞌarujëjo: God-are jö majëhinövare a muoꞌamare aribövi jabesi ujo ömoꞌömëro javuëꞌëro jabesi öre gemuore jijiharue aribövie javuajëjo. ");
INSERT INTO aom_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Jemë ëhi jiëꞌe aribövie jëvëꞌe jiaje ëhuni jemesi hijo mionoꞌehu mu sisë aevoromo vaebe rovarëhi jemesi nimarujoho jemëꞌo ëhi jiëꞌe muoho vaebe jijihorëjo. Na ë hesi jöho bogo uëꞌejöjo. ");
INSERT INTO aom_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Sigobe jëvoꞌamajëjo. Sigobu aboji harihuꞌe jëvoꞌamajëjo. Ëhi jiëꞌe mu vaejëꞌoho diehiꞌoromo vënoho garaedivorëjo. ");
INSERT INTO aom_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Ëhuni aveho hehëjo. Jö God-aro baeromo majëhinövoꞌiröhe aribövioho simano maꞌe aribövioho jö röjëhinövoꞌiröhe aribövioho Iesu naro rëmöꞌöꞌiramu öꞌoruomoꞌajëjo. Öꞌiramu jemëro ioroꞌioroho muoꞌamoꞌarujëjo. O korosire ano taemoꞌamoꞌarujëjo. Ioroꞌioroho God rajahijaruje osare osare hisuebiꞌamoꞌarujëjo. O amo göre jioꞌiramu amo göre siho ujuoho vaꞌonövoꞌarujëjo. ");
INSERT INTO aom_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Ëhi ëꞌiramu ëhuni ma-maemu jiëꞌe aribövi aehu muoꞌamobe rovare ë hesi iꞌuoho jemesi örire rueꞌaꞌajëjo. Aevoꞌioho aëro Abel a mae anoromo a ma ioroꞌioroho muoꞌamobe ruejuvo ro ijo tugohoꞌioho jemesi hijo mionoꞌohuro Barachiah-are harihe Zechariah anare höjo. God-are osa börömoho numëhi jioꞌi God-are suvuoro bahijarue maratuoho ruhëhi jiamu Zechariah ë ririre anare höjo. ");
INSERT INTO aom_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Ave jöho na jö mae uëꞌiëꞌajëjo. God-are aribövi ëhi muoꞌamobe rovare ë hesi iꞌuoho ahoꞌobëhe ave jaruvore raromaruje aribövioho jemëni rueꞌaꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Vaevëꞌe Jerusalem amo rajohumë jemëro jö God-aro baeromo majëhijarue aribövioho muoꞌamaruje höjo. God-hu jemëni rëmöꞌöjaje aribövioho munëro vajëmijaruje höjo. Kököröko vëmehu harihu vivoju uhure nugoꞌamoromo diehehu aegëharuëhi naro jemë ëhi gagovëvoromo gemuore rëmoꞌi nimoꞌi hijode höjo röhu jemëro bijönimarije höjo. ");
INSERT INTO aom_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Ëhuni ave jöho hehëjo. God-ro jemesi amoho vuonugego jemesi sivue jëvoꞌiëꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Naro jemëꞌo hiromo vaꞌiramu jemë nasi nu anoꞌoho bogo gaꞌaꞌarujëjo hujeji na vuonoröꞌö rueꞌiramu evare avoho geromo nasi jöho majëhiromo uvoꞌaꞌarujëjo: Badare ihore rovajoho mabëhëjo. Ëhuremu uehorovorëjo. ");
INSERT INTO aom_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Ëhi uënugoromo Iesuro God-are amo börömore jioromo vaꞌamu gavëꞌi hesi ijorajo ömoꞌömohuro ro birohoromo God-are amo hesi javue gö gö röjahiꞌamareje. ");
INSERT INTO aom_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Röjahiꞌamamu Iesuro uëvadeje: Ave öri ariꞌoho ahoꞌo jemë iae gavarujëjo. Röhu aveho na jö mae uëꞌiëꞌajëjo. Ave munë javuoho ahoꞌobëhe aëro dadovoruomoꞌiramu munëho ahoromo saꞌaro ruvebi barë nahonahovoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Ëhi ëꞌëꞌëro Iesuro Olives Dahorure ajio hijadeje. Hijamu hesi ijorajoho jaburo sivue ajio huꞌo raromoromo uavareje: Ave jöho majahuego no hejarëjo. God-are javu masijehu rireromoꞌiröhego uövuanoho ëho divare jioꞌaꞌajëjo. O no mu rabe garomo uvoꞌejarëjo: Jero rueꞌiëꞌanuëjo. Rovego ave saꞌaho bövioho biseꞌoho barëꞌiëꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Barëꞌiëꞌajëjamu hegorovo Iesuro uëvadeje: Gavëꞌiajo. Aëro sarerëmiꞌiramu guaro rireromëvo vaꞌaꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Ae ahoꞌobëhe rueromo sarerëmiromo uëꞌaꞌaruëjo: Nöruare ihoro rovajëjo. God-hu uevëꞌëro böröme namiromo ajëmiꞌirode aho na jevajëjo. Ëhi uëromo ae ahoꞌobëhe sarerëmiꞌiramu uvoꞌaꞌaruëjo: Mae-ëromo guaro rireromoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Röhu heꞌaꞌarujëjo muorovo jöe ruenövo muorovonövoꞌiramu heꞌaꞌarujëjo. Ëhi hejëꞌoho bogave gemu juhuonivoꞌirarijëjo. Öre gö bogojiëꞌëro ëhi jiëꞌe mu sisëho iae jioꞌaꞌajëjo. Röhu saꞌaho bövioho biseꞌoho evaroho bogo barëꞌi hesi majae göro jioꞌaꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Saꞌae göëro göhuꞌo muorovonövo a masijo ioroꞌiorohuro ioroꞌiorohuꞌo muorovonövoꞌaruëjo. Saꞌae gö gö irunoꞌe bogojioꞌajëjo. Saꞌae dinöꞌe dinöꞌe jiajoho hijiohijiovoꞌamoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Ëhi jiëꞌe huë vavaenoho rueꞌiramu mu sisëho bogo burëroho barëꞌi magonahehu aevoromo rahoꞌi haraꞌuajëhi ëhi aho aevoromo huë vavaene börömoho baebe vaꞌoruomoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Ëhiꞌoꞌiramu evare aëro jemë guduamo ujuohëvo vaꞌo a masijo jabesi övore bojëmiꞌaruëjo jaburo huë vavaene bojëmiꞌiröhego. O muoꞌamëvoꞌaruëjo. Saꞌae dinöꞌe dinöꞌe raromarue aribövioho ahoꞌobëhe jaburo uvoruomoꞌajëjo: Jemëro na uehorovevaruje hö uvoromo nue huodëgoruomoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Ëhiꞌoꞌiramu evare ae ahoꞌobëhe nasi örire mae uehorovevaruoho vuonugoꞌi mue gö gö uehorovoruomoꞌajëjo. Aemoꞌaemohuro aemoꞌaemoho sarerisareriëmiromo ae gö jabesi övore bojëmiꞌaruëjo sisë vaejëvoröhego. Göëro göho nue huodivorovoruomoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Ae göëro göëro riꞌöromo ae sarerëmiromo uëꞌaꞌaruëjo: Na jö God-aro baeromo majëhijaje ae jevajë uëꞌiramu ae ahoꞌobëhe heromo mae höromo guaro rireromoꞌaruëjo. ");
INSERT INTO aom_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Mu sisë ahoꞌo rumorovobe vaꞌiramu gagorovo ae ahoꞌobëhe göehu gö huë baerovarue muoho vuonugoꞌiramu sisërëꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Ëhi ëꞌoruomoꞌajëjo röhu ae rahu biririvoromo mae uehorovevobe vaꞌojuvo maja barëꞌiröhe maja rovëꞌiroho God-ro baejëvoromo manö bamëvoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Röhu God-hu böröme namiromo muebejëvaje jö maho aëro saꞌae dinöꞌe dinöꞌe majëhibe vaꞌoruomoꞌajëjo ae ahoꞌobëhe samaꞌe heruomoröhego. Jöho saꞌae ahoꞌobëhe majëhi barëꞌiramu evare saꞌa bövi biseꞌo barëꞌiröhe majaho rueꞌaꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Röhu Daniel jö God-aro baeromo majëhinövade ahuro mamiꞌe God-are surire jajivoromo uövuade höjo: God-are osa ijumaje sisëhuro God-are osa maremu namiꞌaꞌajëjo. Daniel-hu jajivadëhi ëhi gaꞌaꞌarujëjo ë sisëho God-are osare namiꞌiramu. Iesuro ëhi majëhijadeje. Ëjö Iesuhu majëhijadoho adahoromo avoꞌavoho gare. ");
INSERT INTO aom_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Amo Iesuro jö vituoho majëhiromo uëvadeje: Sisëhuro God-are osare namijego gagorovo ave Judea saꞌare raromaruje aribövioharo huruomoromo dahoruꞌero iojiomorëne. ");
INSERT INTO aom_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Ae rahu javu dönö haradare raromëꞌoho nadi abueromo osare inömoho vaꞌo ujuohoꞌi ma-huruomoromo vaꞌorëne. ");
INSERT INTO aom_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","O mure raromëꞌoho nadi vuonoröꞌö vaꞌo niögoho ujuohoꞌi ma-huruomoromo vaꞌorëne. ");
INSERT INTO aom_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Röhu ë huë vavaeni rueꞌiröhe majaroho dëꞌe magonahohuꞌo aboji harihuꞌo inino jioꞌamëꞌe magonahohuꞌo jabumë vaevëꞌoho diehi huruomoruomoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Röhu God ua garëjo huro ajëmego ëhuro niohijo majaroho o nuho majaroho bogo huruomoꞌirarije höjo. ");
INSERT INTO aom_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Rabëni hesi bëhoho evare majaroho huë vavaene bogo biseꞌo vaduꞌoho rueꞌaꞌajëjo. Ëhi jiëꞌe huë vavaenoho urimo God-hu saꞌa bövi biseꞌo bamadevaroho bogojiobe ruejuvo ro jaruvo majahuꞌo ëhi jiëꞌe huë vavaenoho bogohöjo. O ijonöhuꞌo bogojioꞌi ë majaho gemu börömoho jioꞌaꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Ëhuë vavaeni maja ëgobövi jiajoho God bogo tarioromo bunemuoho bamoꞌibejajo aho bogo biririvoromo raromoꞌibejajo. Aꞌi God-ro hesi baejëvade aribövioho uehorovëvoromo ë majaho tarioromo bunemu bamoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Ëhi jiamu ae göehu uëvëꞌoho: Aveho ro gahëjo. O arueho vaꞌo gahëjo. God-hu uavëꞌëro böröme namiromo ajamuiꞌiröhe aho aviae o aruae hö uëvëꞌoho nadi maho uehorovorëjo. ");
INSERT INTO aom_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Ëhesi bëhoho rabëniajo. Ae ahoꞌobëhe rueromo sarerëmiromo uëbe vaꞌaꞌaruëjo: God-hu uevëꞌëro böröme namiromo ajëmiꞌirode aho jevajëjo o jö God-aro baeromo majëhijaje ae jevajëjo. Sarerëmiromo ëhi majëhiꞌaruëjo. Majëhiromo bogo gavarue mu masijo masijoho vaenövoꞌaruëjo eni jëvego God-hu söjëvade ariböviohuꞌo sarerëmego rireromoꞌiröhego. ");
INSERT INTO aom_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Röhu hehëjo. Ijonö jioröhe jöho na urimo majëhijëꞌe jevajëjo. ");
INSERT INTO aom_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Ëhuꞌe jiaje aehu uëvëꞌoho: Ëhuro vaꞌo garëjo. Aruae jeꞌore hijajë uëvëꞌoho nadi vaꞌo garëjo. O uëvëꞌoho: Hu gurihiromo osaro hijajë uëvëꞌoho nadi maho uehorovorëjo. ");
INSERT INTO aom_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Aꞌi baderehu aruhe baderivoromo ajivo vaꞌo anume buꞌöjego gavarujëhi God-are A Maho naro ëhi ma-vaꞌorahoro rueꞌiramu geꞌaꞌarujëjo. ");
INSERT INTO aom_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Sagohe dinöꞌe jiajire ë ugoho gagovoruomoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Röhu ë huë vavaeni majaho barëꞌiramu evare maja nunoho ramoramovoromo manaeroho duorohoromo jijoho sisërëꞌamoromo öꞌidöre inömoho ahoꞌo arua anumiae vaꞌoꞌamoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Ëhiꞌoꞌiramu evare God-are A Ma nasi ajohuro öꞌidöre ajivoꞌiramu gaꞌaꞌaruëjo. Ëho garomo saꞌare aribövioho ahoꞌobëhe nierusuburuꞌe bamoromo gaꞌaꞌaruëjo God-are A Maho naro darugoꞌo ajiꞌo börömo mae baeromo öꞌidöre suere ruvebiꞌiramu. ");
INSERT INTO aom_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Ruvebiromo hëgöho ma-darugoꞌo huoꞌiramu nasi aneraho rëmöꞌöꞌejöjo. Rëmöꞌöꞌiramu ro God-hu söjëvade aribövioho gagovëvoꞌaruëjo. Arua anumiae saꞌae dinöꞌe dinöꞌe maja rojomajire bevaꞌajire jioruomajoho gagovëvoꞌaruëjo. ");
INSERT INTO aom_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Röhu meso hesi uhu jöho heromo bëhoho avoho uehorovorëjo. Gavaruje mesoho gumutivoromo rahego garomo evare jemë uvaruje höjo: Jew rajo nosi vama majaho iae dunovajëjo. ");
INSERT INTO aom_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Ëhesi bëhoho jemë gaꞌirarije naehu uëvodëhi mue gö gö rovamu gavëꞌiroho uvorëjo: Ëmajaho iae rovajëjo. ");
INSERT INTO aom_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Ave jöho na jö mae uëꞌiëꞌajëjo. Ave jaruvore raromaruje aribövioho jemë bogo vuovo barëjëꞌiro evare naehu uëvaje muoho ahoꞌobëhe rueꞌaꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Öꞌidöe saꞌae bövie biseꞌe barëꞌi nasi jöho gemu bogo barëꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Röhu ë majaho divare jioꞌiröhoho aho bogo gavaruëjo. Öꞌidöre raromarue anerahuꞌo Harihoho naꞌo bogo gaꞌi hesi Vavuohuro gemuëro gavajëjo. ");
INSERT INTO aom_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Röhu God-are A Ma naehu a nunire rueꞌiëꞌiroho a mami ae Noah-hu hijade majare jiadëhi ëhi gemuoho jioꞌaꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Jovo börömo bëhe rojomoromo öri ariꞌe ahoꞌo baeꞌiröhe majaho dunovamu evare aëro ie jove ueꞌahobe masurovobe ëhi jiëꞌe muohemu uehorovobe vaꞌojuvo evare Noah-mëro boat börömore rumo vaꞌare höjo. ");
INSERT INTO aom_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Rumo vaꞌamu gavëꞌi a ioroꞌiorohuro uvoruomade höjo: No mae raromaruëjamu evare jovo börömohuro rojomoromo jabumë ahoꞌo baeniagëgo barë nahonahovade höjo. God-are A Ma naehu rueꞌiëꞌiroho ëhi jiëꞌe muoho jioꞌaꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Ëmajaho rueꞌiramu evare ae niöꞌiro mure ariromo muoho vaeꞌiramu gavëꞌi aneraëro göho baeꞌi göho ë vuonugoꞌaruëjo. ");
INSERT INTO aom_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Magonahe niöꞌiro gemuoro ariromo ioho saꞌijovoromo avohoꞌiramu aneraëro göho baeꞌi göho ë vuonugoꞌaruëjo. ");
INSERT INTO aom_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Ëhi ëꞌiröhohuni ëhuni gavëꞌiajo. Jemesi Bada naehu rueꞌirode majaho jemëꞌo bogo gavarujëjo. ");
INSERT INTO aom_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Ave uhu jöhuꞌo avoꞌavoho uehorovohëjo. Vajiohuꞌe aehu vahiꞌe divare rueröhe majaho osa arijoꞌoho bogo gavade höjo. Gaꞌibejajo gavëꞌi hiromo vajiohuꞌe a hesi öroho tugohahego osaho bogo dadovoromo inömoho ujuohoꞌibejajo. ");
INSERT INTO aom_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Osa arijoꞌohuro gavëꞌi hiꞌibejajo mae jioꞌibejajo. Jemëꞌo gavëꞌi raromorëjo. Jemë bogo uehorovëꞌe raromaruje majare evare God-are A Maho naro rueꞌejöjo. ");
INSERT INTO aom_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Aehu hesi a börömo hesi muohemu uehorovëꞌi simano mae uehorovoromo mu vaejaje ëhi jiëꞌe aho uehorovohëjo. Ëa hesi a börömohuro hu uavëꞌe höjo. Na vaꞌiëꞌajëjo. Jero nasi mu vaejarue a ioroꞌioroho muebejëvonëjo. Muebejëvoromo majae eni jiego jabesi irunoꞌoho iꞌimëminövonëjo. Iꞌimëminövonë uanugoromo vaꞌëꞌe höjo. ");
INSERT INTO aom_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Vaꞌo hijuvo röhu ijonö vuonoröꞌö rueromo garöhe ë ahuro hesi muoho avoho vaejahoꞌiramu gagorovo huë mabëhe bojamiꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Huë mabëhe bojamiromo uaꞌaꞌajëjo: Ja mu mae vaejanohuni ëhuni na mu börömoro bamavoꞌejöjo. Jero nasi saꞌae inömo inöme bövie biseꞌe ahoꞌo muebejehonëjo. Mu avoꞌavoho muebejëꞌoho iae hu ëhi uaꞌaꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Aꞌi ë mu vaejahaje aho sisë jiëꞌohuro ëhuro uehorovoromo uvoꞌaꞌajëjo: Nasi börömoho örisanuovajëromo ");
INSERT INTO aom_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","riꞌöromo mu vaejarue aribövi ioroꞌioroho muoꞌamoromo vöröꞌe jovo sisë ueꞌahoruomaje ariböviohuꞌo gemuore hiromo ioho jovoho iꞌaꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Ëhiꞌoromo bogo gavëꞌe uehorovëꞌe hiꞌiramu evare hesi börömoho ma-majioho rueꞌaꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Rueromo sino hahoꞌoho sisë maro ijumahoromo nugöꞌöꞌiramu sisëro vaꞌoromo sareri sareriꞌe ariböviohuꞌo hiꞌaꞌajëjo. Ëdiröꞌore ae ahoꞌobëhe nierusuburuꞌe bamoromo ane jaꞌiho vuogigimoruomoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Nasi majaho rovego God-hu böröme namiromo a diehi muebejëvoꞌiröhe jöho naro uhuꞌe majëhiꞌiëꞌajëjo. Iae magonaho aboride ahoꞌobëhe övo gö mine övo gö mine raromoruomade höjo. Raromoromo iroho gae ujuohoromo iꞌo masuvade aho birohoꞌi vaꞌoruomade höjo. ");
INSERT INTO aom_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Röhu aboride övo gö mine simano sisëꞌi uehorovarue aborido ömoꞌöme jioruomoꞌi aboride övo gö mine ëho simano mae uehorovarue aboride jioruomade höjo. ");
INSERT INTO aom_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Simano sisëꞌi uehorovarue aboridoho jaburo irore biguröhe jovoho bogo ujuohoꞌi irohemu ujuoho vaꞌirögoro ");
INSERT INTO aom_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","simano mae uehorovarue aboridoho jaburo irore biguröhe huonore jovohuꞌo irohuꞌo ëhi ujuohoromo vaꞌoruomade höjo. ");
INSERT INTO aom_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Ëaboridoho övo gö mine övo gö mine jaburo vaꞌoromo muebejuvo gavare iꞌo masuvade aho bogo vejöꞌoho rovamu gagorovo nunëhëgamu hegorovo momoröꞌöruomade höjo. ");
INSERT INTO aom_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Momoröꞌöjuvo vahi ririꞌe aëro ma-darugoꞌo uvare höjo: Nosi aho rovajëjo. Ruehego vaꞌoromo biroharëjo. ");
INSERT INTO aom_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Ruehego vaꞌoromo biroharëjamu hegorovo aborido ömoꞌömohuro riꞌöruomoromo jabesi iroho avohoꞌamare höjo. ");
INSERT INTO aom_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Avohoromo simano sisëꞌi uehorovarue aboridoho jaburo simano mae uehorovarue aboridoho uëvare höjo: Jemesi jovoho gö bojamuihëjo. Nosi iroho duorohahuoꞌamajëjo. ");
INSERT INTO aom_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Duorohajëjamu uëvare höjo: Bogajo. Jemëꞌo noꞌo biguvego barëjöëni bogo bojëmiꞌejarëjo. Ëhuni vaꞌoromo jemesi gö imohëjo. ");
INSERT INTO aom_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Imohëjamu ë aboridoho jaburo jove imoꞌi vaꞌoruomade höjo. Vaꞌoruomamu iꞌo masuvade ahuro rovade höjo. Rovamu iro ma avohare aboridoho jaburo ë ahuꞌo gemu mae osanö vaꞌoruomade höjo masurovare söröho iꞌiröhëni. Osanö vaꞌoruomamu ojoho tugohare höjo. ");
INSERT INTO aom_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Ojoho tugohamu magonaho ioroꞌiorohuro ijore rueruomade höjo. Rueruomoromo iꞌo masuvade ahuni uvare höjo: Asëꞌe asëꞌe oje jiovahuego no öꞌarëjo. ");
INSERT INTO aom_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Öꞌarëjamu ruehuro uëvade höjo: Na jemë bogo gëvaje höjo. Iae na mae uëvajëjo. Ëhiꞌare höjo. ");
INSERT INTO aom_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Ëhuni gavëꞌiajo na divare majare rueꞌirodoho jemë bogo gavëꞌe jëvaje. ");
INSERT INTO aom_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Röhu God-hu böröme namiromo muebejëvoꞌiröhe öri hesi uhu jö göho aviëhi höjo. Ae gemuëro öre gö vaꞌirögoro hesi mu vaejaharue aribövioho uëvamu rovare höjo. Rovamu uëvade höjo: Na vaꞌejöjo. Jemëro nasi saꞌaho bövioho biseꞌoho avoho muebejehorëjo. ");
INSERT INTO aom_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Avoho muebejehorëromo mu ariböviehu mu böröme o biseꞌe vaeꞌiröhoho eni jëvamu garomo ëhi hesi monioho böröme o biseꞌe ëhi ae gemu gemu bojamibe vaꞌade höjo jaburo ëho baeromo hesi muoho vaejahoröhego. A göho 5,000 kina bojamiꞌi a göho 2,000 kina bojamiꞌi a göho 1,000 kina ëhi bojamijade höjo. Ëhi iꞌimëminugoromo vaꞌade höjo. ");
INSERT INTO aom_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Vaꞌamu gavëꞌi 5,000 kina baejade ahuro ujuoho vaꞌoromo mue vaeromo ëhuro 5,000 kina göꞌo döre baejade höjo. ");
INSERT INTO aom_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","2,000 baejade aho huꞌo mue vaeromo 2,000 kina göꞌo döre baejade höjo. ");
INSERT INTO aom_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Ëhiꞌoꞌirögoro 1,000 kina baejade ahuro vaꞌoromo guae umoromo hesi a börömo hesi ijo bajoho ë gurihi bahijade höjo. ");
INSERT INTO aom_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Ëhiꞌoromo raromobe vaꞌojuvo majae ëgobövie barëjamu jabesi a börömohuro vuonoröꞌö rovade höjo. Rueromo uëvade höjo: Ruehego na gëvöjo nasi ijo bajoho diehi muebejehëꞌe jëvego. ");
INSERT INTO aom_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Ëhi uëvamu 5,000 kina baejade ahuro 5,000 kina göꞌo döre baejadoho ëhuꞌo barueromo bojamiromo uavade höjo: Bada jero 5,000 kina bojemijane höjo. Aveho gavëjo. Naro mue vaeromo 5,000 kina göꞌo döre baejahëꞌe jevajëjo. ");
INSERT INTO aom_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Baejahëꞌe jevajëjamu hesi a börömohuro uavade höjo: Mabëhëjo. Ja mue vaejehanue a ma-mae javajëjo. Naehu ijo baje ma-bisemu bojamamu avoho muebejehanohuni ëhuni naro bövi mae bojamiꞌejöjo muebejehoꞌiranego. Rovego gemuoro nimorohoꞌirarëjo. ");
INSERT INTO aom_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Gemuoro nimorohoꞌirarëjamu 2,000 kina baejade ahuro rueromo uavade höjo: Bada jero 2,000 kina bojemijane höjo. Aveho gavëjo. Naro mue vaeromo 2,000 kina göꞌo döre baejahëꞌe jevajëjo. ");
INSERT INTO aom_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Baejahëꞌe jevajëjamu hesi a börömohuro uavade höjo: Mabëhëjo. Ja mue vaejehanue a ma-mae javajëjo. Naehu ijo baje ma-bisemu bojamamu avoho muebejehanohuni ëhuni naro bövi mae bojamiꞌejöjo muebejehoꞌiranego. Rovego gemuoro nimorohoꞌirarëjo. ");
INSERT INTO aom_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Gemuoro nimorohoꞌirarëjamu 1,000 kina baejade ahuro rovade höjo. Rueromo uavade höjo: Bada na mae garomo uvode höjo: Ja vöröꞌe aëro javëꞌëro ae göehu baꞌamaroho bivaroho ja ma-ijanue höjo. ");
INSERT INTO aom_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Ëhi javëꞌe aego ëhuni naro ja juhuonamiromo jasi 1,000 kina bavaꞌoromo saꞌa gagore gurihi bamode höjo. Aveho gavëjo. Jasi ijo bajoho aviae höjo. ");
INSERT INTO aom_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Aviae höjamu rue a börömohuro riꞌöromo uavade höjo: Sareri mu bijöniꞌe a sisë bëhe javajëjo. Jero uvane höjo: Ae göehu baꞌamaroho bivaroho nöröro ma-ijaje höjo. Jero ëhi uvane höjo. Na mae-ëjo. ");
INSERT INTO aom_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Ëhuni ja nasi ijo bajoho baeromo avoho bahijarue aribövi jabesi övore bamoꞌibejanëjo. Ëhi ëꞌibejanëjo na rueromo nasiroho baeromo göꞌo döre bamaroho ëhuꞌo baeꞌibejöjo. ");
INSERT INTO aom_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Ëhuni jemëro 1,000 kina ë ia hesiriroho baeniahiromo 10,000 kina baejëꞌe aho bojamihëjo. ");
INSERT INTO aom_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Ëhesi bëhoho mu vaeꞌirane suvuore javëꞌoho God-ro göꞌo bojamiꞌiramu baeromo bövi mae javoꞌajëjo. O bogojavëꞌoho bisemu baejanoho God-ro baeniahiꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Röhu ë mu bogo vaejaje aho guduamoromo babuꞌöhego amonö ramoramore vaꞌo hijajo. Ëdiröꞌore ae ahoꞌobëhe nierusuburuꞌe bamoromo ane jaꞌiho vuogigimoruomoꞌajëjo. Ëhi uëvade höjo. ");
INSERT INTO aom_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Röhu jö göho God-are A Maho naro anerae ahoꞌobëhe jabuꞌo gemu mae nasi ajiꞌo rovëꞌiroho evare nasi ajiꞌe röho mare ajio hiꞌejöjo. ");
INSERT INTO aom_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Hiꞌiramu saꞌae dinöꞌe dinöꞌe raromarue aribövioho jaburo rueromo nasi nunire gagovoruomoꞌajëjo. Gagovoruomoꞌiramu sheep muebejaje aehu sheep o goat adovoromo hahagu hahagu nugoꞌamaruëhi naro ë aribövioho ëhi adovëvoromo hahagu hahagu rëmoꞌejöjo. ");
INSERT INTO aom_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Hahagu hahagu rëmoromo sheep ma vaꞌënoho nasi övo manö rëmoꞌi goat sisë vaꞌënoho nasi övo adonö rëmoꞌejöjo. ");
INSERT INTO aom_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Rëmonugoromo a börömoho naro övo manö riravarue aribövioho uëꞌejöjo: Nasi Vavuohuro jemesi örire huë mabëhe bojëmijëꞌe jiaje jemesi röhoho ro baehëjo. Ëröhoho urimo saꞌa bövi biseꞌo bamadevare huro avoho nugëhobe rovëꞌe höjo jemëro ë hesi aharire raromoꞌirarijego. ");
INSERT INTO aom_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Rabëni hesi bëhoho urimo na hömevamu jemëro ie iꞌimemijarije höjo. Na huë girihevamu jemëro jovoho bojemijarije höjo. Naro ame göro jioromo öꞌamu gegorovo uevarije höjo: Nosi osaro ro hijëjo. ");
INSERT INTO aom_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Niögu rumoꞌe jevamu niögoho iꞌimemamu ioꞌamode höjo. Guomo guome baejevamu jemëro muebejevarije höjo. Savoji gagore hijamu jemëro rueromo gevarije höjo. ");
INSERT INTO aom_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Gevarije höꞌiramu rue aribövi mahuro ueruomoꞌajëjo: Bada iae ëhi höjo röhu no divare gavare höjo ja hömavamu ioho iꞌimamare höjo. Divare gavare höjo ja huë girihavamu jovoho bojamare höjo. ");
INSERT INTO aom_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Divare gavare höjo ja ame göro jioromo rovamu uavare höjo: Nosi osaro ro hijëjo. Divare gavare höjo niögu rumoꞌe javamu niögoho iꞌimamare höjo. ");
INSERT INTO aom_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Divare gavare höjo ja guomo guome baejavamu o savoji gagore hijamu no öꞌoromo gavare höjo. ");
INSERT INTO aom_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Ëhi ueꞌiramu a börömoho naro uëꞌejöjo: Aveho na jö mae uëvajëjo. Nasi öe iho ma-biseꞌo jiëꞌoho mae avoharijohuro ëhuro naꞌo mae avohevarije höjo. ");
INSERT INTO aom_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Ëhi uënugoromo huotorovoromo nasi övo adonö riravarue aribövioho uëꞌejöjo: Iꞌue baeꞌiëꞌe aribövie jëvaje roriꞌo vaꞌohëjo. Ravemu ravaje vëniꞌe öri ariꞌoro vaꞌohëjo. Ëvënoho God-ro Satanꞌo hesi anera ömoꞌömohuꞌo ëho jabuni avohëhëꞌe höjo. ");
INSERT INTO aom_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Rabëni hesi bëhoho na hömevadoho jemë ioho bogo iꞌimemijarije höjo. Huë girihevadoho jemë jovoho bogo bojemijarije höjo. ");
INSERT INTO aom_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Ame göro jioromo öꞌodoho jemë bogo uevarije höjo: Nosi osaro ro hijëjo. Niögu rumoꞌe jevadoho jemë niögoho bogo iꞌimemarije höjo. Guomo guomo baejevadoho o savoji gagore hijodoho jemë bogo ro muebejevarije höjo. ");
INSERT INTO aom_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Bogo ro muebejevarije höꞌiramu rue ariböviohuro ueruomoꞌajëjo: Bada iae ëhi höjo röhu no divare gavare höjo ja hömavamu o huë girihavamu o ame göro jioromo rovamu o niögu rumoꞌe javamu o guomo guome baejavamu o savoji gagore hijamu garomo bogo ajamiꞌi ma-nunëremu gavare höjo. ");
INSERT INTO aom_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Ma-nunëremu gavare höꞌiramu naro uëꞌejöjo: Nasi öe iho ma-biseꞌo jiëꞌoho bogo ma avoharijohuro ëhuro naꞌo bogo ma avohevarije höjo. ");
INSERT INTO aom_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Ëhi uëꞌiramu ë aribövioho sisëro vaꞌoromo ma-ioroꞌioremu iꞌue baeruomoꞌajëjo. Aꞌi aribövi mahuro maro vaꞌoromo ma-ioroꞌioremu raromoruomoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Ëjöho majëhi barënugoromo Iesuro hesi ijorajo ömoꞌömoho uëvadeje: ");
INSERT INTO aom_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","Iae jemëꞌo gavarujëjo majae niöꞌi hesi uhure evare God-hu Vörö Tugohade Sörö majaho rueꞌaꞌajëjo. Rueꞌiramu aëro God-are A Maho na guduamevoromo a masijo jabesi övore bojëmiꞌaruëjo korosire ano taemevoröhego. ");
INSERT INTO aom_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Iesuro ëhi jövoꞌirögoro röhu evare priest masijohuꞌo Jew rajo a duvaho ömoꞌömohuꞌo ëho jaburo priest börömo ihe Caiaphas-are osa börömore ë ro gagovareje. ");
INSERT INTO aom_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Gagovoromo jöe mevoromo uarovareje: No diehiꞌoromo Iesu saginiëri guduamoromo anoꞌejarëjo. ");
INSERT INTO aom_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Sörö majaroho bogo guduamoꞌejarëjo aëro göromo noꞌo muorovoruomojöëni. ");
INSERT INTO aom_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Ëhiꞌamu Iesuro Bethany amore rueromo sino jomoꞌe ae Simon-are osare ro hiromo ie ijadeje. ");
INSERT INTO aom_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Ie ijamu gagorovo magonahe gemuëro munë huono mabëhe baeromo rovadeje. Ëhuono gagore ridiꞌe osoho jiadeje. Huonore oso imarue hesi manaho bövi mae jiadeje. Magonahohuro ë osoho barueromo Iesuare simanore otehadeje. ");
INSERT INTO aom_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Simanore otehamu gagorovo Iesuare ijorajoho jaburo dë vörönëgamu uarovareje: Osoho rabëni ëma otehöꞌöjajëjo. ");
INSERT INTO aom_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Ae gö jabesi örire imoꞌibejarëjo manaho bövi mae baeꞌibejarëjo. Ëmanaho baeromo bövi biseꞌo rumoꞌe aribövioho suvuorëmiꞌibejarëjo. Ëhi jiëꞌoho iae mae jioꞌibejajo. Röhu ëma otehöꞌöjade höjo. ");
INSERT INTO aom_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Ëhi atamu hegorovo Iesuro gëromo uvadeje: Ëhi jiëꞌe jöho ataruëromo uëvadeje: Jemë rabëni magonahoho huë vavaenoho bojamijarujëjo. Mu mabëhe nasi örire vaejevëꞌe höjo. ");
INSERT INTO aom_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Bövi biseꞌo rumoꞌe ariböviohuro jemëꞌo raromobe jijihoꞌaruëjo mae vaejëvojöro. Aꞌi naro jemëꞌoho bogo hibe juvoꞌejöjo ëhi avohevojöro. ");
INSERT INTO aom_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Ëmagonahehu oso nasi sinore bamehade hesi bëhoho nasi sinoho avohehade höjo ëhuro aëro hure mae bamevoröhego. ");
INSERT INTO aom_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Ave jöho na jö mae uëꞌiëꞌajëjo. Saꞌae dinöꞌe dinöꞌe aehu nasi jö ma majëhibe jijihëꞌiroho ë magonahehu ëꞌade jöhuꞌo majëhibe jijihoꞌaruëjo aëro hu mae uehorovoruomoröhego. ");
INSERT INTO aom_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Ëhiꞌamu Iesuare ijoraje 12 röhu gemu hesi ihe Judas Iscariot-ro vaꞌoromo priest masijoho uëvadeje: ");
INSERT INTO aom_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Naehu Iesu jemesi övore bojëmijëꞌoho jemë ijo baje diminoꞌe bojemirëjo. Bojemirëjamu rueho jaburo ajivëꞌe ijo bajoho adahoromo 30 bojamijareje. ");
INSERT INTO aom_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Bojamijamu evare Judas-ro aevoromo öre nahadeje Iesu jabesi övore bojëmiꞌiröhëro. ");
INSERT INTO aom_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","I Dë Huaje Oso Rumoꞌe I ibe vaꞌiröhe majaho aevoromo rovamu gagorovo Iesuare ijorajoho jaburo rueromo Iesu uavareje: Ja nagajoho no dinöꞌe vaꞌoromo God-hu Vörö Tugohade Söröho avohahoꞌejarëjo. ");
INSERT INTO aom_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Ëhi uavamu uëvadeje: Jerusalem amo börömohuro vaꞌoromo ë a hesi osaro vaꞌoromo uarëjo: No röjahuijaje ahuro uvajëjo: Nasi majaho dunovajëjo. Ëhuni naro jasi osare öꞌoromo God-hu Vörö Tugohade Söröho nasi ijorajoho jabuꞌo gemu mae iꞌejöjo. Ëhi uarëjo. ");
INSERT INTO aom_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Ëhi uarëjamu rue ijorajoho jaburo Iesuhu uëvadëhi ëhi ëꞌoromo söröho avohareje. ");
INSERT INTO aom_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Ëhiꞌamu vahiromadeje. Vahiromamu gagorovo Iesuro hesi ijoraje 12-ho jabuꞌo gemuore hijadeje ë ioho iꞌirovo. ");
INSERT INTO aom_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Hiromo ioho ijëꞌi uëvadeje: Ave jöho na jö mae uëꞌiëꞌajëjo. Jemë ae gemuëro na bijönegarue aribövi jabesi övore bojëmiꞌanuëjo. ");
INSERT INTO aom_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Bojëmiꞌanuëjamu hegorovo uehore gö gö böröme baeromo ae gemuëro gemuëro uavareje: Na bogo ëhioho ëꞌejöjo. Na na mae uavajëjo. ");
INSERT INTO aom_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Mae uavajëjamu hegorovo uëvadeje: Naehu i hevöre baꞌamoꞌego huꞌo gemuore baꞌamaje ahuro ë mu sisëho vaeꞌaꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","God-are surire jajivarëhi hesi A Maho na ëhi guomevoꞌajëjo. Röhu na bijönegarue aribövi jabesi övore bojëmiꞌiröhe aho vaevëꞌoho sisërëꞌajëjo. Ëaho bogo rahoꞌibejajo ëhuro mae jioꞌibejajo. ");
INSERT INTO aom_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Mae jioꞌibejajamu Judas Iesu bijönimarue a jabesi övore bojëmiꞌiröhe ahuro uavadeje: Na bogo ëhioho ëꞌejöjo. Na mae-ëjo. Na mae-ëjamu uavadeje: Jero jasi jövanuëjo. ");
INSERT INTO aom_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Ëhiꞌamu ioho ueꞌahoromo Iesuro ioho baeromo God mae uanugoromo atoꞌatovoromo hesi aribövioho suvuorëmiromo uëvadeje: Baeromo ihëjo. Aveho nasi sine höjo. ");
INSERT INTO aom_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Ëhiꞌonugoromo enatuore jovoho baeromo God mae uanugoromo bojëmiromo uëvadeje: Jemë ae ahoꞌobëhe enatuore jovoho baeromo ihëjo. ");
INSERT INTO aom_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Aveho nasi köe höjo. Ae ahoꞌo jemesi jöëni köho rovevoromo guomevoꞌajëjo ëhuro sisëho muꞌuvëhoröhego. Guomevoꞌiramu ëhuro God-hu muebejëvoꞌiröhe jögoroho marëꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Röhu aveho hehëjo. Na ijoho öꞌi bajo jovoho bogo iꞌejöjo hujeji ëho majaho rovego evare jemëꞌo naꞌo nasi Vavuehu muebejaje öri ariꞌere raromoromo öꞌi bajo jovo iꞌoho ueꞌahoröhëni. ");
INSERT INTO aom_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Ëhi uënugoromo God rajahijarue jöho ionugoromo suorovo vaꞌoromo Olives Dahorure iojiomareje. ");
INSERT INTO aom_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Iojiomoromo Iesuro hesi aribövioho uëvadeje: Jaruvo vahire ae ahoꞌobëhe nasi örire mae uehorovevarujoho vuonugoꞌi remo vaꞌaꞌarujëjo. Ëhesi bëhoho God-are surire jöho jajivoromo uvëꞌe höjo: Sheep muebeꞌamaje aho God naro anoꞌejöjo. Anoꞌiramu huhu muebeꞌamade sheep-oho jaburo arua anumiae vaꞌoꞌamoꞌajëjo. God-are jö jiajëhi ëhi remo vaꞌaꞌarujëjo. ");
INSERT INTO aom_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Remo vaꞌiramu guomoromo riꞌönugoromo naro urimo Galilee vaꞌejöjo. Jemë ijore öꞌaꞌarujëjo. ");
INSERT INTO aom_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Ëhi uëvamu Peter-ro riꞌöromo uavadeje: Nani a ioroꞌioroho jasi örire uehorovaruoho vuonugoꞌi ramo vaꞌaꞌaruëjo röhu na bogo ëhioho ëꞌejöjo. ");
INSERT INTO aom_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Bogo ëhioho ëꞌejöjamu Iesuro Peter uavadeje: Ëhi uevanuëjo röhu ave jöho na jö mae uaꞌiëꞌajëjo. Jaruvo vahire kökörökoho bogo urimoho uvëꞌe jero urimo vae niöꞌi gemu ae uëꞌaꞌanuëjo: Na Iesu bogo gavaje höjo. ");
INSERT INTO aom_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Ëhi uëꞌaꞌanuëjamu hegorovo Peter-ro uavadeje: O na bogo ëhioho ëꞌejöjo. Aehu anegamu jaꞌo gemuore guomoꞌiëꞌiroho na bogo ëhioho majëhiꞌejöjo. Bogo majëhiꞌejöjamu ijorajo ioroꞌioroho ahoꞌo jabuꞌo ëhi gemuoho Iesu uaruomadeje. ");
INSERT INTO aom_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Ëhiꞌamu Iesuro öri ariꞌo ihe Gethsemane hesi ariböviohuꞌo rovadeje. Rueromo uëvadeje: Avehuro raromohego na aruëre vaꞌoromo God-are örire jöe jövöjo. ");
INSERT INTO aom_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Ëhi uënugoromo Peterꞌo Zebedee-are harihoho niöꞌi jabuꞌo sö ujuoho vaꞌoromo huë vavaene böröme baeromo nurunurumadeje. ");
INSERT INTO aom_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Nurunurumoromo uëvadeje: Na sisë maro huë vavaene baejevajëjo. Ëhuro guomevo hesi höjo. Ëhuni nadi momoröꞌöꞌi ma-nune jioromo avoho mueberovëꞌe raromohëjo. ");
INSERT INTO aom_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Ëhi uënugoromo roriꞌo vaꞌoromo saꞌare behumoromo nu anoꞌoho saꞌare amoromo God ëninamiromo uavadeje: Apo jasi örire öre gö javëꞌoho iꞌue huë vavaene nasi örire rovajoho ahego na bogo baeꞌiröjo. Röhu naehu nimajoho nadi ëꞌi jaehu nimanuëhi ëhi ëꞌonëjo. ");
INSERT INTO aom_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Ëhi ëninaminugoromo vuonoröꞌö rueromo gavade hesi ae niöꞌi gemu momoröꞌöjamu gëgorovo Peter uavadeje: Majae ma-bunemu nune jioromo naꞌo gemuoro mueberovëꞌe raromoꞌirarijoho jemë diehiꞌoromo bogo eni jëvajëjo. ");
INSERT INTO aom_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Nune jioromo mueberomo ëninamihego God-ro ajëmego Satan-ro bogo dinëmego ëhuro bogo bejëvoꞌirajo. Jemesi aruꞌahoho mu mae vaeꞌi nimoꞌi jemesi sino hahoꞌoho uꞌuhëꞌe höjo. ");
INSERT INTO aom_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Ëhi uënugoromo röhu maho vaꞌoromo ëninamiromo uavadeje: Apo öre gö bogojavoꞌi iꞌuehu huë vavaenehu nasirire ruejöro nimëꞌoho iae ëhi ëꞌonëjo. ");
INSERT INTO aom_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Ëhi uanugoromo vuonoröꞌö rueromo gavade jabumë nunëhimoꞌamoꞌego momoröꞌöjamu gëgorovo ");
INSERT INTO aom_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","rëmoꞌi vuonoröꞌö vaꞌoromo urimëꞌi vae niöꞌi ëninamijade jöe gemuoho röhu maho ëninamijadeje. ");
INSERT INTO aom_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Ëninaminugoromo rueromo hesi aribövioho uëvadeje: Jemë diehiꞌoromo nuhoromo ma-momoröꞌöemu momoröꞌöjarujëjo. Gahëjo. Majaho mamiꞌe rovëꞌe höjo. Aëro God-are A Maho na bijönegarue aribövi jabesi övore bojëmiꞌiëꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Riꞌöromo go vaꞌohego vaꞌarëjo. Gahëjo. Na bijönegarue a bojëmiꞌiröhe aho rovajëjo. ");
INSERT INTO aom_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Ëhi uëvamu gavëꞌi Judas rovadeje. Iesuare ijoraje ahoꞌobëhe 12 röhu Judas huꞌo jabesi ae gemuoho jiadeje. Judas rovamu ae ahoꞌobëhe mae siravae kepatae ujuohoromo huꞌo rueruomadeje priest masijohuꞌo Jew rajo a duvaho ömoꞌömohuꞌo ëho jaburo rëmöꞌöjëꞌëro jiëꞌëro. ");
INSERT INTO aom_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Röhu ë hesi urimo ë sareriꞌe aho Judas-ro ë aribövioho uëvadeje: Gaꞌirarije naro di aho dudöhamu gavëꞌoho uvorëjo: Iae Iesu höromo guduamorëjo. ");
INSERT INTO aom_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Judas-ro ëhi uëvëꞌëro huro rueromo ma-burëro ro Iesu uavadeje: Bada vaevëꞌëromo dudöhadeje. ");
INSERT INTO aom_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Dudöhamu uavadeje: Isi jasi nimanue muoho vaejëjo. Ëhi uavamu aëro rueromo Iesu guduamareje. ");
INSERT INTO aom_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Guduamamu gagorovo ae gemu Iesuare bëhire namijadohuro hesi kaejöho jijöromo priest börömo hesi mu vaejaje aho anoromo hiaꞌoho tariöꞌöjahadeje. ");
INSERT INTO aom_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Tariöꞌöjahamu gagorovo Iesuro uavadeje: Jasi kaejöho sionoro vuonoröꞌö baꞌamëjo. Ae rahu kaejöehu o bijehu bunehu muorovëꞌoho kaejöhuro bijohuro bunohuro muoꞌamëvoꞌiramu vuovëvoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","O jaehu a ananue hesi bëhoho nani jero uvanuëjo: Nöröhu hesi Vavu ua gavëꞌoho bogo ajamiromo anerae ahoꞌobëhe mae gemuore jioruomajoho rëmöꞌöꞌiramu rueruomoromo na ajemiꞌaruëromo ëhuni aho ananuëjo. ");
INSERT INTO aom_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Röhu naro hu ua gaꞌibejöjo God-are surire jajivarëhi muoho bogo ëhioho jioꞌibejajo. Ëhuni ajemiꞌiröhe jöho Vavuoho bogo ua gaꞌejöjo. ");
INSERT INTO aom_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Iesuro ëhi uanugoromo ë rueruomade aribövioho uëvadeje: Aveho na bogo vajiohuꞌe ananoꞌe aehu jevajëjo. Jemë rabëni siravaho kepataho ujuohoromo guduamevoꞌi rovarujëjo. Mamiꞌe majae ahoꞌo naehu God-are amo börömore hiromo God-are jö hesi öri a röjëhinövodoho jemë evaroho bogo guduamevarije höjo. ");
INSERT INTO aom_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Röhu avevejöꞌe vaejaruje mue ahoꞌo hesi bëhoho urimo jö God-aro baeromo majëhinövare ariböviohuro God-are surire jajivoromo uvare höjo: Ëhi jiëꞌe muoho jioꞌaꞌajëjo. Jabuhu jajivarëhi ëhi jioröhego ëhuni ave muoho rovëꞌe höjo. Ëhi uëvamu hesi ijoraje ahoꞌobëhe hu nugoꞌi huruomoromo vaꞌareje. ");
INSERT INTO aom_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Ëhiꞌamu gagorovo Iesu huꞌirae rueromo priest böröme Caiaphas-are osare rovareje. Rueromo gavareje jögoru öri röjëhijarue ariböviohuꞌo a duvaho ömoꞌömohuꞌo ë gemuoro gagovëꞌe jiamu. ");
INSERT INTO aom_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Iesu priest börömo hesi osare barovamu Peter-ro arue riribövire Iesu rihiromoromo priest börömo hesi osare rovadeje. Rueromo osare rumo vaꞌoromo abo osa ririre ruë numë javue vaeꞌi riroho ma-vaꞌoraho nugarire ë vaꞌoromo priest hesi mu vaeruomaje ariböviohuꞌo gemuore hijadeje diehiꞌaruoho garöhëni. ");
INSERT INTO aom_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Ëhiꞌamu priest masijohuꞌo a masijo ioroꞌiorohuꞌo ae nahareje sarerivoromo ëma huruoho majëhiromo uëröhego: Iesuro ëhi jiëꞌe mu sisëho vaejamu gavare höjego heromo Iesu anego guomoröhego. ");
INSERT INTO aom_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Nahoromo bogo birohareje. Ae göëro göëro rueromo Iesuare jö sarerivoromo majëhijaroho bogo eni jiobe vaꞌojuvo hujeji ae niöꞌiro rueromo ");
INSERT INTO aom_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","jöe gemuoho majëhiromo uëvareje: Ëiahuro uvavohijajo: God-are amo börömo dadovoromo majae niöꞌi gemu hesi uhure röhu maho vae barëꞌirodoho na eni jevajëjo. Ëjö sisëho uövuamu hejare höjo. ");
INSERT INTO aom_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Ëhi majëhijamu hegorovo priest börömohuro riꞌöromo Iesu uavadeje: Na ja jö mana uöꞌiranoho bogojavajëjo. Aehu jasi jö sisë majahuijaruoho na ëho mae o sarere höjo. ");
INSERT INTO aom_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Mae o sarere höjamu Iesuro jörume namijadeje. Jörume namijamu priest börömohuro uavadeje: God biririvoromo hijaje a hesi nunoro ave jöho ma-maemu uevego na hejöjo. Böröme namiromo ajamuijanue aho na ja javajëjo. Na ja God-are Harihe javajëjo. ");
INSERT INTO aom_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Javajëjamu uavadeje: Jaehu uevanuëhi iae ëhi jevajëjo. Röhu naro jemë ae ahoꞌobëhe ave jöho uëvajëjo. Uꞌemu jemëro geꞌaꞌarujëjo God-are A Maho darugo eni jiëꞌe A hesi övo manö hiꞌiramu. Öꞌidöre jioꞌamaje suehuꞌo gemu mae ruvebiꞌiramu. ");
INSERT INTO aom_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Ëhi uavamu hegorovo rue priest börömohuro hesi niögoho dadovoromo uëvadeje: Huro God-are ihoho ijumajëjo. A göho rabëni rueromo hesi jöho huruoho majahuijörajo. Iae no eni hejëꞌe javuajëjo. God-are iho ijumajoho jemë iae hejarujëjo. ");
INSERT INTO aom_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Ëhuni jemë diehi uehorovarujëjo. Diehi uehorovarujëjamu uavareje: Jö sareriꞌe aego anoꞌiramu guomoꞌaꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Ëhi uanugoromo Iesuare nu anoꞌere sabëro ödivoromo övo mugö mugöëro anoruomadeje. O övo hitahiëro anoromo ");
INSERT INTO aom_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","sivoromo uavareje: Jero uvanuëjo: Na böröme namiromo ajëmaje aho jevajëjo. Ëhi jiëꞌe javaje jöho God-aro baeromo huruoho majahuiromo anagade a hesi ihoho uövuego no hejarëjo. ");
INSERT INTO aom_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Ëhiꞌamu Peter-ro amonö aehu raromaruire ë hijadeje. Hijamu gagorovo mu ajamijaje magonahe gemuëro rueromo uavadeje: Jaꞌo Galilee saꞌa rajo ae Iesuꞌo gemu mae javade höjo. ");
INSERT INTO aom_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Javade höjamu Peter-ro ae ahoꞌobëhe jabesi nunire magonahoho sareramiromo uavadeje: Jaehu jövanue jöho na dadivevo avohajëjo. ");
INSERT INTO aom_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Ëhi uanugoromo aribövioho ë rëmoꞌi ojo bëhire vaꞌadeje. Vaꞌamu magonaho göëro Peter garomo hesi bëhire riravarue aribövioho uëvadeje: Ave iaho Nazareth amo rajo ae Iesuꞌo gemu mae jiade höjo. ");
INSERT INTO aom_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Jiade höjamu hejëꞌi Peter-ro röhu maho sareramadeje. Sareramiromo uavadeje: God-are nuniro na mae uavajëjo. Ëaho na bogo gavaje höjo. ");
INSERT INTO aom_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Ëhi uavadoho ririvanovamu bëhire riravarohuro ro Peter uavareje: Iae mae-ëjo Iesuare aribövi jabesi ae gemuoho javajëjo. Jasi huëre heromo ëhuni uavaruëjo. ");
INSERT INTO aom_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Uavaruëjamu Peter-ro uëvadeje: Na jemë sarerëmijëꞌoho iꞌue baejöëni ëhuni na jö mae uëvajëjo. Ëaho na bogo gavaje höjo. ");
INSERT INTO aom_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Bogo gavaje höjamu gavëꞌi kökörökoho uvadeje. Uvavamu hegorovo Peter-ro uehorovoromo uvadeje: O mamiꞌe Iesuro uevade höjo: Kökörökoho bogo urimoho uvëꞌe jero urimo vae niöꞌi gemu ae uëꞌaꞌanuëjo: Na Iesu bogo gavaje höjo. Ëhi uehorovoromo amonö hörö vaꞌoromo sisë maro nivadeje. ");
INSERT INTO aom_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Iae sisonuvoꞌiaꞌamu gagorovo priest masijohuꞌo Jew rajo a duvaho ömoꞌömohuꞌo ë aribövioho ahoꞌobëhe jaburo gagovoromo jöe mevoromo uarovareje: No ëhi ëhi ëꞌejarëjo Iesu guomoröhego. ");
INSERT INTO aom_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Ëhi mevoromo eni jiamu gagorovo Iesu tövoromo bavaꞌoromo gavana Pilate-are övore bamareje. ");
INSERT INTO aom_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Ëhiꞌamu Iesuni hiruëmiromo a jabesi övore bojëmade aho Judas-ro gavade Iesuare jöho court-roho bejëꞌe jiamu gagorovo uvadeje: Na mae ëꞌajëꞌi sisë ëꞌëꞌe jevajëjo. Sisë ëꞌëꞌe jevajë uvonugoromo ajivëꞌe ijo baje ahoꞌobëhe 30 ujuohadoho vuonoröꞌö ujuoho vaꞌoromo priest masijohuꞌo a duvahohuꞌo bojëmiꞌiëꞌadeje. ");
INSERT INTO aom_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Bojëmiꞌiëꞌoromo uëvadeje: Naro mu sisë ëꞌëꞌe jevajëjo. Naro a mahuni jemë hiruëmiromo hu jemesi övore bojëmijëꞌe jevajëjo anego guomoröhego. Ëhi uëvamu uavareje: Ëho bogo nosi muehu höjo. Jero jasi ganëjo. ");
INSERT INTO aom_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Ëhi uavamu hejëꞌi ijo bajoho God-are osare buꞌönugoromo jabumë rëmo vaꞌoromo öꞌëro sönöre benugoromo vioruhirovoromo guomadeje. ");
INSERT INTO aom_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Ëhiꞌamu priest masijohuro ijo bajoho ujuohoromo uarovareje: Ave ijo bajoho guomoröhe a hesi manaho höjo. Ëhuni God-ni moni bahijaruire ë bahijëꞌoho sisë höjo. ");
INSERT INTO aom_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Jöho mevonugoromo eni jiamu gagorovo ijo bajoho ujuohoromo saꞌaho imareje saꞌa ioroꞌiorore jioromo rovare aribövioho vuovëvego ë guavoꞌamoröhëni saꞌa ihoho Rama Avohoꞌamaje A Hesi Saꞌaho jiëꞌëro. ");
INSERT INTO aom_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","A guomoröhe manaho baeromo ë saꞌaho imëꞌëro ëhuni ë saꞌaho Kö Rovade Saꞌaho jumuvaroho jaruvoho hesi ihoho ëhije. ");
INSERT INTO aom_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Röhu jö God-aro baeromo majëhinövade ae Jeremiah-hu Iesuare mana ujuohoromo saꞌa imoruomoröhego urimo uëvadëhi ëhi ëꞌareje. Amo Jeremiah-ro uëvadeje: Jabumë ajivëꞌe ijo bajoho ahoꞌobëhe 30 ujuohare höjo Israel rajohuro monie ëminoꞌe hu imoröhëni uvëꞌëro. ");
INSERT INTO aom_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Ijo bajoho ujuohoromo Badahu na uevadëhi ëhi rama avohoꞌamaje a hesi saꞌahuni buꞌöruomade höjo. Jeremiah-ro ëhi uëvadeje. ");
INSERT INTO aom_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Amo Iesuro gavanare nunire namijamu gavanaro uavadeje: Na ja Jew rajo jabesi a börömoho javajëjo. Javajëjamu Iesuro uavadeje: Ëjöho jero jasi jövanuëjo. ");
INSERT INTO aom_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Jövanuëjamu priest masijohuꞌo a duvahohuꞌo ëho jaburo Iesuare jö sisëho gavana huruoho majahijareje. Majahijamu Iesu bogo mana uavadeje. ");
INSERT INTO aom_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Bogo mana uavamu Pilate-ro Iesu uavadeje: Rueho jabuhu jasi jö sisë ahoꞌobëhe majehijaruoho na ja hejanuëjo o bogajo. ");
INSERT INTO aom_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Bogajamu Iesuro jöho bogo mana majahijadeje. Bogo majahijamu rue a börömohuro tiö avohadeje. ");
INSERT INTO aom_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Röhu God-hu Vörö Tugohade Sörö maja rovëꞌiroho savoji gagore raromarue aribövioho di aho jiovo nugöꞌöjöro aehu uvoruomëꞌoho Pilate-ro ë aho jiovo nugöꞌönövadeje. ");
INSERT INTO aom_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Röhu ae gemu hesi jö sisë ae ahoꞌobëhe hemu hejaruoho ë aho savoji gagore hijadeje. Hesi ihoho Iesu Barabbas jiadeje. ");
INSERT INTO aom_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","18","Röhu Pilate-ro gëromo uvadeje: Iesuare ihoho bövie jiëꞌego ë ariböviohuro dë vörönëgamu nasi övore bojemijare höjo. Bojemijare hö uvoromo gavade ae ahoꞌobëhe gagovorovëꞌe jiamu gëgorovo uëvadeje: Jemë nëgajoho na di aho jiovoromo bojëmiꞌejöjo. Na na Iesu Barabbas jiovo nugöꞌöꞌejöjo. O na na Iesu göho Keriso hö uvarujoho jiovo nugöꞌöꞌejöjo. ");
INSERT INTO aom_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Ëhi uënugoromo röhu Pilate-ro court-re hiromo jöho hejamu evare hesi vaborohuro jöe nugöꞌöromo uavadeje: Ëaho sisë rumoꞌe ae jiaje ëhuni hesi öriroho nadi bövioho biseꞌoho ëꞌonëjo. Jaruvo vahiꞌe naro niavoromo Iesu niaꞌovoro garomo huë vavaene börömo bëhe baejode höjo. ");
INSERT INTO aom_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Jöho ëhi rovamu gavëꞌi Jew rajo priest masijohuꞌo a duvahohuꞌo ëho jaburo ae ahoꞌobëhe biririvoromo dinëmiromo uëvareje: Jemëro uvohëjo: Barabbas jiovo nugöꞌöꞌi Iesu anohëjo. ");
INSERT INTO aom_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Ëhi uëvamu Pilate-ro ae ahoꞌobëhe uëvadeje: Ëae niöꞌioho jemë nëgajoho na di aho jiovoromo bojëmiꞌejöjo. Uavareje: Barabbas-ajo. ");
INSERT INTO aom_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Barabbas-ajamu uëvadeje: Ëhi jiëꞌoho Iesu Keriso na diehiꞌoꞌejöjo. Ae ahoꞌobëhe uvoruomadeje: Korosioro anego guomajo. ");
INSERT INTO aom_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Guomajamu uëvadeje: Rabëniajo. Diehi jiëꞌe mu sisë vaejëꞌe höjo. Vaejëꞌe höjamu ae ahoꞌobëhe ma-darugo maꞌe uvoꞌi arijareje: Korosioro anego guomajo. ");
INSERT INTO aom_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Ëhi uvamu hegorovo Pilate-ro gavade hu jö jövajoho bogo eni jioꞌi aribövioho muorovoꞌiaꞌamu gëgorovo vuonugoꞌi jovoho baejadeje. Jovoho baeromo ae ahoꞌobëhe jabesi nunire övoho eguadeje. Övoho eguoromo uëvadeje: Na övo unoꞌe ae jevajëjo. Ëia hesi kö rumoꞌe jevajëjo. Jemesi garëjo. ");
INSERT INTO aom_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Jew raje ae ahoꞌobëhe uvoruomadeje: Iae mae-ëjo. Nosi övore nosi ujo jabesi övore ë ia hesi köho javuobe vaꞌaꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Köho javuobe vaꞌaꞌajëjamu Pilate-ro ejëhoromo Barabbas jiovo nugöꞌöjadeje. Barabbas jiovo nugöꞌöꞌi Iesu hisuebijöro ae uënugoromo uëvadeje: Ave aho bavaꞌoromo korosioro anohego guomajo. ");
INSERT INTO aom_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Guomajamu rue gavanare muorovo ariböviohuro hesi osa börömore Iesu bavaꞌoromo muorovo a ioroꞌiorohuꞌo gagovoromo Iesu ruë numë numareje. ");
INSERT INTO aom_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Numonugoromo hesi niögoho jijövahoꞌi a masijehu kavuëꞌe niögu ëgo ioꞌamoromo mu vaejarue ëhi jiëꞌe niögoho baꞌamahareje. ");
INSERT INTO aom_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Baꞌamahoromo a masijehu bosö didiꞌarue ëhi jiëꞌe bosöho Iesuare simanore didiꞌahareje. Röhu bogo inömo maho baeromo bosöho avohahoꞌi bibëꞌe ijo hisuoho ujuohoromo huoromo simanore baꞌamahareje. Baꞌamahonugoromo a masijehu inömo ma-mabëhe maꞌeno raromaruëhi jiëꞌe inömoho övore bamahareje. Röhu bogo inömo maho bamahoꞌi ma-ijahemu övore bamahareje. Bamahoromo hesi nuninö ro ague aho raromoromo sivoromo uavareje: Jew rajo jabesi börömoho vaevëꞌe hijanuëjo. ");
INSERT INTO aom_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Hijanuëromo sabëro ödivoromo ijahoho baeniahiromo hesi simanore anareje. ");
INSERT INTO aom_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Ëhi sivoruomoromo niögu ëgoho jijövahoꞌi hesi niögu maho ioꞌamahoromo huꞌirae bavaꞌareje korosire ano taemoꞌi. ");
INSERT INTO aom_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Bavaꞌoromo örire vaꞌihö gavare Cyrene amo raje ae gemu hesi ihe Simon rovamu gagorovo övëro bijimöꞌöromo uavareje: Ave a hesi korosioho baeromo vaꞌëjo. ");
INSERT INTO aom_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Baeromo vaꞌëjamu ejëhoromo baeromo jabumë ahoꞌo vaꞌaroho ajiomoromo saꞌa ihe Golgotha nosi huëhu huotovëꞌoho simano gijo vaꞌëne saꞌare ë ajio suorovareje. ");
INSERT INTO aom_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Suorovonugoromo wine jovohuꞌo ajuoꞌe jovohuꞌo buaroharoho Iesu bojamijareje hesi viꞌehoho bisemu uꞌuhoröhego. Bojamijamu i garomo juahëmadeje. ");
INSERT INTO aom_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Juahëmamu korosire ano taemareje. Ano taemoromo hesi niögoho adovoromo ajajovoromo ujuohareje. ");
INSERT INTO aom_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","37","Röhu Iesuare jö sisë jajivaroho hesi simano namore korosire ano taemareje. Jajivoromo ëhi uvëꞌe jiadeje: Ave aho Iesu Jew rajo jabesi a börömoho höjo. Ëhiꞌonugoromo saꞌare raromoromo hu muebejareje. ");
INSERT INTO aom_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Ëhiꞌoꞌirögoro röhu aëro ananoꞌe vajiohuꞌe ae niöꞌi jabuꞌo korosire ano taemëvoromo göho ruëhi Iesuare övo manö göho viëhi övo adonö ëhi amëvareje. ");
INSERT INTO aom_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Ëhiꞌamu aëro rovaꞌëꞌi uvene hijiohijiovoromo sivoromo ");
INSERT INTO aom_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","uvoruomonövadeje: Asëꞌe sareri ae javajëjo. Jero uvane höjo: Naro God-are osa börömoho dadovoromo majae niöꞌi gemu hesi uhure röhu maho vae barëꞌejöjo. Ëhi uvëꞌe javaje ëhuni ja God-are Harihe javëꞌoho jasi arijoꞌarije ajamirovoromo korosire javajoho ruvebijego bogo guomavajo. ");
INSERT INTO aom_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Jabuhu sivarëhi priest masijoho jögoru öri röjëhijarue aribövioho a duvaho ömoꞌömoho ëho jabuꞌo ëhi sivoromo uarovareje: ");
INSERT INTO aom_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Ëahuro uövuade höjo: Naro a ioroꞌioroho ajëmego marëjëvaje höjo. Ëhi uövuade höjo röhu hesi sino ajamirovëꞌoho hu bogo eni höjo. Huro uövuade höjo: Israel rajo jemesi börömoho na jevajëjo. Ëhuni nadiꞌego hu korosire jioromo ruvebijego no garomo mae uehorovarëjo. ");
INSERT INTO aom_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Röhu ave jöhuꞌo huro uövuade höjo: God-ro na muebejevaje höjo. Hu uvaje höjo: Na God-are Harihe jevajëjo. Ëhuni nadiꞌego no gaꞌirarëjo God iaho nimoromo ajamijego o bogo ajamijego. ");
INSERT INTO aom_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Ëhi uarovamu gavëꞌi hesi bëhire vajiohuꞌe ae niöꞌi korosiꞌo amëvare aho jabuꞌo ëhi sivoromo jöe gemuoho uavareje. ");
INSERT INTO aom_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Ëhiꞌamu majae ririre öri ariꞌe ahoꞌo ramoramovadeje. Ramoramovobe vaꞌojuvo majae huotorovamu ajivadeje. ");
INSERT INTO aom_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Majae huotorovoromo ajivamu Iesuro Jew rajo jabesi jöëro ma-darugoꞌo uvadeje: Eliajo. Eliajo. Lema sabaktaniajo. Nosi jöehu huotovëꞌoho God nasi Böviohajo. God nasi Böviohajo. Ja rabëni remo vaꞌane höjo. ");
INSERT INTO aom_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Remo vaꞌane höjamu bëhire riravare a ioroꞌiorohuro Elia uvavamu hegorovo uarovareje: Elijah-ni uvajëjo. ");
INSERT INTO aom_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Ëhi uarovoromo ae gemuëro ma-burëro tutuvo vaꞌoromo uꞌuhëꞌe inömoho barueromo niogaꞌiꞌe wine jovore baꞌamoromo rumorovamu ioromo ijaho viture bijiohoromo Iesu bojamiꞌiëꞌadeje. ");
INSERT INTO aom_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Bojamiꞌiaꞌamu a ioroꞌiorohuro uarovareje: Nadiꞌego no gaꞌirarëjo Elijah-ro hu ajamiꞌi rovego o bogo rovego. ");
INSERT INTO aom_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Ëhi uarovamu Iesuro röhu maho jöꞌe dadovoromo guomadeje. ");
INSERT INTO aom_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Guomamu God-are osa börömo ojo göho gagonö jiajoho niögehu tugoharoho arorovo ruvebijadeje. Saꞌaho hijiohijiovamu munëho arorovoꞌamadeje. ");
INSERT INTO aom_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Arorovoꞌamamu huoho tögömoromo jiororovoꞌamamu God-are aribövie vuovëvade ioroꞌioroho ahoꞌobëhe iꞌovoꞌamadeje. ");
INSERT INTO aom_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Iꞌovoromo suorovoromo Iesu riꞌöjamu evare vaꞌoromo God-are osa börömo jiaje amore vaꞌo ae ahoꞌobëhe jabesi nunire rueruomamu garuomadeje. ");
INSERT INTO aom_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Röhu Iesu guomamu gagorovo muorovo simano vaejaje ahuꞌo ë hesi ariböviohuꞌo riravoromo Iesu muebejarohuro gavare saꞌaho hijiohijiovoromo mue gö gö jiamu garomo sisë maro juhuonivoromo uvareje: Iae mae-ëjo. Ave aho iae God-are Harihe jiade höjo. ");
INSERT INTO aom_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Ëhiꞌamu magonahe ahoꞌobëhe arue riribövire riravoromo Iesu diehiꞌaruoho garuomadeje. Urimoho ë magonahoho jaburo Galilee jioromo Iesu ajamibe hesi ijore ijore rovareje. ");
INSERT INTO aom_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Mary Magdalene o Mary göho James o Joseph jabesi vëmoho o Zebedee-are harihu jabesi vëmoho o magonaho ioroꞌioroho ëhi jioruomadeje. ");
INSERT INTO aom_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Iae majae garoboꞌe bamamu bövie biseꞌe eni jiëꞌe ae gemu hesi ihe Joseph-ro rovadeje. Hesi amoho Arimathea jioꞌi huꞌo Iesuare ijoraje jiadeje. ");
INSERT INTO aom_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Ëhi jiëꞌëro huro vaꞌoromo Pilate uavadeje: Uevego na Iesuare sinoho baeꞌiröjo. Baeꞌiröjamu Pilate-ro ae uëvadeje: Vaꞌo sinoho ave aho babojamego bavaꞌirajo. ");
INSERT INTO aom_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Babojamamu Joseph-ro baeromo niögu iꞌohuro numadeje. ");
INSERT INTO aom_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Numoromo Joseph guomego hesi sino bamoꞌiröhego uvadire Iesuare sinoho ë bamadeje munë gage iꞌe ubuvëꞌëro jiëꞌëro. Bamoromo munë börömoho höhö barueromo ojoho tugohonugoromo vaꞌadeje. ");
INSERT INTO aom_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Ëhiꞌamu Mary Magdaleneꞌo Mary göhuꞌo Iesu bamarire ë nunoho bamoromo ëhi arijareje. ");
INSERT INTO aom_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Ëmajaho Friday jiadeje. Friday jiamu momoröꞌöjëꞌëro sisonuvamugo Jew rajo priest masijohuꞌo Pharisee ömoꞌömohuꞌo rueromo Pilateꞌo gagovoruomadeje. ");
INSERT INTO aom_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Gagovoromo Pilate uavareje: Gavanajo. Iesu hu sareri sareriꞌe ae jiade höjo. No uehorovoromo uvaruëjo: Mamiꞌe hu bogo guomëꞌe hijadevare evare sareramuiromo uövuade höjo: Guomoromo majae niöꞌi gemu hesi uhure iꞌovoromo riꞌöꞌejöjo. ");
INSERT INTO aom_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Ëhuni ae uëvego huoho tugohoromo majae niöꞌi gemu ëhi atovoꞌirarëjo. Ëhesi bëhoho no juhuoninaguajëjo Iesuare ijore ijore jijiharue ariböviohuro hure vaꞌoromo hesi sinoho vajiohëro baeromo ae ahoꞌo sarerëmiromo uëjöëni: Iaho guomoromo riꞌöjëꞌe höjo. Ëhi jiëꞌe sareriꞌe jö atëꞌoho ëhuro urimo Iesuro mae uövuajëromo aribövioho ma-bisemu sisërërovaroho avevejöꞌoho riꞌöjade jöho mae höromo börömo bëhe sisërërovo avohoꞌaruëjo. Ëhuni huoho avoho tugohojöro naguajëjo. ");
INSERT INTO aom_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Tugohojöro naguajëjamu Pilate-ro uëvadeje: Muorovo aribövioho ujuoho vaꞌego atovoꞌirarëjo. Huoho diehi tugohoꞌi uehorovarujëhi ëhi tugoho garëjo. ");
INSERT INTO aom_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Ëhi uëvamu vaꞌoromo tugohoromo sivaëro badihi taemareje. Taemoromo muorovo aho ë nugoꞌamareje huoho atovoröhego. ");
INSERT INTO aom_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Iae Jew rajo nuho majaho barëjamu nëröho hura börömoho sisonuvoꞌiëꞌadeje. Sisonuvoꞌiaꞌamu Mary Magdaleneꞌo Mary göhuꞌo jaburo niöꞌiro Iesu bamaroho gaꞌi vaꞌareje. ");
INSERT INTO aom_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Vaꞌamu saꞌaho hijiohijiovadeje. Ëhesi bëhoho Badare anerae gemuëro öꞌidöre jioromo ruvebiromo Iesu bamoromo ojo tugohare munëho höhö bavaꞌadeje. Bavaꞌoromo ë munë döre hijadeje. ");
INSERT INTO aom_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Amo anera hesi nu anoꞌoho baderivoromo ajivajëhi ëhi jiadeje. Hesi niögoho ajivoromo sa buso vaꞌëne jiadeje. ");
INSERT INTO aom_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Ëhi jiamu gagorovo muorovo aribövie munë muebejarohuro ëho garomo juhuonivoromo butubutumoromo saꞌare rireromoromo vuovëꞌe ahuro momoröꞌöjanovadeje. ");
INSERT INTO aom_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Ëhiꞌamu magonahoho jaburo rovamu gagorovo anerahuro uëvadeje: Nadi juhuonivohëjo. Na gavajoho jemë korosire anamu guomade a hesi sinoho naharujëjo. ");
INSERT INTO aom_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Hu aveho bogohöjo. Guomoromo riꞌöröhëni uëvadëhi ëhi ëꞌëꞌe höjo. Ro hesi sinehu raromade sionoho gahëjo. ");
INSERT INTO aom_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Garomo ma-burëro vaꞌoromo hesi ijorajo ömoꞌömoho uërëjo: Iesu guomoromo riꞌöjëꞌe höre. Huro urimo Galilee saꞌare vaꞌiramu jemëro ijore öꞌoromo gaꞌaꞌarujëre. Ave naehu uëvaje jöho uehorovorëjo. ");
INSERT INTO aom_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Ëhi uëvamu hegorovo juhuonivëꞌi sisë maro nimorohoromo hure jioromo tutuvoromo Iesuare ijorajoho jöho majëhiꞌi vaꞌareje. ");
INSERT INTO aom_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Vaꞌamu gavëꞌi Iesuro birohëvadeje. Birohëvoromo uëvadeje: Vaevëꞌe jëvajëjo. Vaevëꞌe jëvajëjamu rueromo hesi höroho guduamoromo rajahijareje. ");
INSERT INTO aom_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Rajahijamu uëvadeje: Nadi juhuonivohëjo. Vaꞌoromo nasi ö ömoꞌömoho uërëjo: Galilee saꞌaro vaꞌorëjo. Iae na ë geꞌaꞌarujëjo. Ëhi uërëjo. ");
INSERT INTO aom_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Ëhi uëvamu vaꞌareje. Magonahoho jaburo vaꞌirögoro muorovo a ioroꞌioro Iesuare sino muebejarohuro amo börömore vuonoröꞌö vaꞌareje. Vaꞌoromo priest masijoho uëvareje: No hu muebejaroho ëhi ëhi jiade höjo. ");
INSERT INTO aom_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Ëhi majëhijamu hegorovo priest masijohuro uëvareje: Jew rajo a duvahohumë ro gagovohëjo. Gagovohëjamu gagovorovoromo jöho mevoromo avohonugoromo ijo bajo böröme muorovo aribövioho suvuorëmiromo ");
INSERT INTO aom_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","uëvareje: Jemëro ae majëhiromo uënövorëjo: Vahiꞌe noro momoröꞌöꞌi bogo gavamu Iesuare ijore ijore jijiharue ariböviohuro sinoho vajiohëro bavaꞌëꞌëro ëhuꞌëro Iesuare huoho gagemu höjo. ");
INSERT INTO aom_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","O momoröꞌöjarije jö gavanahu hejëꞌoho noro hu sanuamiꞌejarëjo. Sanuamiꞌiramu hu huë vavaenoho jemesi öriroho bogo bojëmiꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Ëhi uëvamu hegorovo rue muorovo ariböviohuro ijo bajoho ujuohoromo Jew rajo a masijehu ae majëhiröhego uëvarëhi ëhi majëhibe jijihonövareje. Ëhi majëhibe jijihonövëꞌëro ëhuꞌëro Jew raje ae ahoꞌobëhe ë jöho atarueje. ");
INSERT INTO aom_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Iae Iesuare ijoraje 11-ho jaburo Galilee saꞌare vaꞌoromo Iesuhu birohëvoꞌiröhëni uëvade dahorure ë iojiomareje. ");
INSERT INTO aom_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Iojiomoromo hu garomo rajahijareje. Röhu ijorajo ioroꞌiorohuro uvareje: Na aveho Iesu höjo o ae gö höjo. ");
INSERT INTO aom_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Ëhiꞌamu Iesuro bëhire rueromo uëvadeje: God-ro nasi örire daruge bojemijëꞌe höjo mue ahoꞌobëhe öꞌidöre o saꞌare jioꞌamajoho naro muebeꞌamoꞌirodego. ");
INSERT INTO aom_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Ëhuni saꞌae dinöꞌe dinöꞌe vaꞌoromo ae ahoꞌobëhe ajëmibe jijihorego jabuꞌo nasi ijore ijore jijihoꞌirarëjo. Ëhi ajëmiromo Vavu hesi ihoro Harihu nasi ihoro God-are Aruꞌaho hesi ihoro bapataeto vaejëvobe jijihorëjo. ");
INSERT INTO aom_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Bapataeto vaejëvoromo naehu mu rabe rabe bojëmodoho ëho röjëhibe jijihorego jaburo nasi jöho ejehoꞌirarëjo. Ëhi ëꞌiramu naro jemëꞌo gemu mae juvemu juvobe vaꞌiramu saꞌae bövie biseꞌe barëꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","God-are Harihe Iesu Kerisohu mu mae barovade jöho na jajivoꞌiëꞌe. Ëmu ma aevadoho ëhi jiadeje. ");
INSERT INTO aom_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Mami göꞌe hu bogo rovadevare evare jö God-aro baeromo majëhinövade ae Isaiah-ro ë mu maehu saꞌare rueröhe jöho God-are surire jajivadeje. God-hu Keriso-are örire jövade jöho jajivoromo uvëꞌeje: Ave aho God nasi jö bajuvaje aho höjo. Ja vaꞌiëꞌiroho naro hu urimo nugöꞌöꞌiramu vaꞌoromo ae uëꞌaꞌajëjo jaehu vaꞌirane öroho iogoroꞌiröhego. ");
INSERT INTO aom_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Aëro a rumoꞌe saꞌare hiromo ma-darugoꞌo uvoꞌaꞌajëjo: Badahu rueröhe öroho avohorego hu maro rueꞌirajo. Hesi öroho ahorirëro vajivorego hu maro juvoꞌirajo. ");
INSERT INTO aom_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Ëhi ëꞌiröhego Isaiah-hu jajivadëhi iae ëhi John-ro ijonö rueromo a rumoꞌe saꞌare ro hijadeje. Hiromo aribövioho rueruomoꞌego bapataeto vaejëvoromo jöe majëhinövadeje. Majëhiromo uënövadeje: Uehoro sisëho vuonugoꞌi uehoro mae baeromo bapataeto vaehego God-ro jemesi sisëho uehorovoromo vuonugëhajo. ");
INSERT INTO aom_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Ëhiꞌego Jerusalem amo rajoho ahoꞌobëhe o Judea saꞌa ioroꞌiorore raromarue aribövioho ahoꞌobëhe ëho jaburo rueruomonövadeje. Rueromo jabesi sisëho huruohoꞌego John-ro Jordan jovore bapataeto vaejëvonövadeje. ");
INSERT INTO aom_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Röhu John niöge camel mi uehu avohëꞌe niögu sisëho ruohoromo mi sinehu avohëꞌe götaho dëꞌahore baꞌamoromo juvonövadeje. O hesi ioho hu guajuguajue vuome ëhi ibe juvonövadeje. ");
INSERT INTO aom_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Röhu hu jöho ëhi uënövadeje: Ae gö nasi ijonö rueꞌiëꞌajëjo. Huro na iosiremiromo börömoho höjo. Naehu hesi mu biseꞌo vaejahoromo uruhoꞌamoromo höru sino jiovahoꞌibejodoho o mu biseꞌo biseꞌe rabe vaejahoꞌibejodoho röhu na ma-biseꞌe jevajëjo. ");
INSERT INTO aom_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Na ma-jovëremu bapataeto vaejëvëꞌe jevajëjo. Aꞌi ë ahuro God-are Aruꞌahohuro bapataeto vaejëvoꞌiëꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","John-ro ëhi jiëꞌe muoho vaejamu Iesuro Galilee saꞌare Nazareth amore jioromo rovadeje. Rueromo uavamu John-ro ë Jordan jovore bapataeto vaejadeje. ");
INSERT INTO aom_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Bapataeto vaejamu gagorovo Iesuro jovore jioromo rojo ionire namiꞌi gavadeje öꞌidöho arorovoꞌego God-are Aruꞌahe guaho vaꞌënohuro hesirire ruvebijamu. ");
INSERT INTO aom_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Ruvebijamu gavëꞌi ae ahoꞌobëhe hejareje öꞌidöre uvavamu: Ja nasi Harihu mabëhe javajëjo. Na ja garomo ëhuro nasi dë vövöbajoꞌoho nimorohevajëjo. ");
INSERT INTO aom_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Ëhi uvamu gavëꞌi God-are Aruꞌahohuro darugoꞌe jöho Iesuare dë vövöbajoꞌere bojamamu huro riꞌöromo a rumoꞌe saꞌa göre ajiomadeje. ");
INSERT INTO aom_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Ajiomamu huro God-are jöho ahojöro Satan-ro hesi dëho bijioho gaꞌi hijadeje. Bijioho gaꞌi hijamu jeꞌo mi sisë jioruomajinö ë hijadeje röhu aneraëro ajamareje. Ëhiꞌobe vaꞌadoho majae 40 barëjadeje. ");
INSERT INTO aom_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Ëhiꞌamu aëro John guduamo bavaꞌoromo savoji gagore baꞌamareje. Savoji gagore baꞌamamu evare Iesuro Galilee saꞌare ajiomoromo God-are jö maho majëhinövadeje. ");
INSERT INTO aom_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Majëhiromo uënövadeje: God-are maja börömoho rovëꞌe höjo. Jemë iae gaꞌiëꞌarujëjo God-ro böröme namiromo muebejëvego. Ëhuni uehoro sisëho vuonugoꞌi God-are jö maho mae uehorovohëjo. ");
INSERT INTO aom_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Ëhiꞌoromo iae Galilee eꞌu riröre juvadeje. Juvoꞌi gavadeje Simonꞌo Andrewꞌo öꞌo öꞌo visue suovarue aëro jëvëꞌëro viöho jovore baꞌamamu. ");
INSERT INTO aom_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Viöho jovore baꞌamamu gëgorovo uëvadeje: Nasi ijoro ijoro ruehëjo naro röjëhijego jemëro bogo visuoho gagovoꞌi aꞌi ae magonahe gagovëvego nasinö jioruomoꞌiröhe höjo. ");
INSERT INTO aom_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Ëhi uëvamu hejëꞌi jaburo viöho ëhi vuonugoꞌi aevoromo hesi ijore ijore jirehonövareje. ");
INSERT INTO aom_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Ëhiꞌamu Iesuro ma-bisemu vaꞌanovoꞌi gavadeje Zebedee-are harihe niöꞌi Jamesꞌo Johnꞌo öꞌo öꞌo jabesi boat gagore arijamu. Ariromo jabesi viöho sigohijamu gëvëꞌi ");
INSERT INTO aom_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","uvëvadeje: Ruehëjo. Ruehëjamu hegorovo jaburo jabesi vavue Zebedee hesi mu vaejarue ariböviohuꞌo gemu mae boat-re hijajoho vuonugoꞌi aevoromo Iesuare ijore ijore jirehonövareje. ");
INSERT INTO aom_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Ëhiꞌoromo Iesumëro rue Capernaum amore vaꞌareje. Vaꞌoromo God-are nuho majaho rovamu Iesuro God rajahijarue osare vaꞌoromo God-are jö bëhoho röjëhijadeje. ");
INSERT INTO aom_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Röjëhijamu heromo tiöromo uvoruomadeje: Hesi jöho darugoꞌe jö ma-mabëhe javavajëjo. Ëhi uvoruomade hesi bëhoho Jew rajo jögoru öri röjëhijarue ariböviehu röjëhijarëhioho hu bogo ëhioho majëhiꞌi aꞌi hesi birire baejëꞌëro jöho majëhijadeje. ");
INSERT INTO aom_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Jabumëro ëhi uvoruomamu röhu evare majare Satan-are a sisëhu dëre abuejëꞌe aho ë osare hijëꞌëro ma-darugoꞌo uvadeje: ");
INSERT INTO aom_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","Iesu Nazareth rajoho ja rabëni sihusihuaguoꞌi rovane höjo. Na ja ijumavuoꞌiëꞌanuëjo. Na iae ja gavajëjo. Ja God-aro jioromo rovëꞌe a ma-maemu jiëꞌe ae javajëjo. ");
INSERT INTO aom_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Ëhi uavamu hejëꞌi uavadeje: Jöho vuonugoꞌi höröjëjo. ");
INSERT INTO aom_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Höröjëjamu hejëꞌi uhure a sisëhuro ë a hesi simanoho huotovahamu bijöbijövoromo övoꞌo höruꞌo ajiomadeje. Övoꞌo höruꞌo ajiomamu a sisëhuro jöꞌe dadovoromo höröromo vaꞌadeje. ");
INSERT INTO aom_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Höröromo vaꞌamu ë aribövioho ahoꞌo tiöjëvadeje. Tiöromo berohoromo uarovareje: Aveho mu rabe höjo. No bogo hejarue jöho jövajëjo. Ëiaho daruge baejëꞌëro ëhuꞌëro huhu jö bojëmijëꞌoho aruꞌaho sisëho jabuꞌo ejaharue höjo. ");
INSERT INTO aom_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Ëhiꞌamu Iesuhu vaejaje mu hesi jöho ë Galilee saꞌare raromaruoho ahoꞌo hebe vaꞌareje. ");
INSERT INTO aom_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Ëhiꞌamu Iesumëro God rajahijarue osare ë jioromo vaꞌareje. Vaꞌoromo Iesuro Jamesꞌo Johnꞌo gemu mae vaꞌoromo Simonꞌo Andrewꞌo arijarue osare rovareje. ");
INSERT INTO aom_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Röhu Simon-are jure magonaho hesi sino hahoꞌoho vöröꞌiraejamu röhore raromëꞌe jiadeje. Raromamu Iesuro osare rovamu gavëꞌi ë ariböviohuro uavareje: Ave magonahoho guomo guome baejëꞌe höjo. ");
INSERT INTO aom_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Baejëꞌe höjamu hegorovo Iesuro rueromo övore maꞌenoromo banigojiomadeje. Banigojiomamu sino hahoꞌere vöröꞌiraejadoho uꞌuhadeje. Vöröho uꞌuhamu hegorovo magonahohuro riꞌöromo irunoꞌe avohëhadeje. ");
INSERT INTO aom_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Avohëhëꞌëro majae bevaꞌamu gagorovo aëro guomo guomo baejëꞌe aribövioho ahoꞌo Satan-are a sisëhu dëre abueꞌamëꞌe aribövioho ahoꞌo ëhi ujuoho rueruomadeje. ");
INSERT INTO aom_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Amo raje ae ahoꞌobëhe rueromo Simon-are ojanore gagovoruomadeje. ");
INSERT INTO aom_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Gagovamu Iesuro guomo guome gö gö baejëꞌe ae ahoꞌo jabesi sinoho avohëhoromo aruꞌaho sisëho ahoꞌo a jabesi dëroho rarovöꞌöjëvonövadeje. Rarovöꞌöjëvoromo ë aruꞌaho sisëho uënövadeje: Jöe nugohëjo. Nadi nasi jöho huruohohëjo. Iesuhu ëhi jiëꞌe jö jövade hesi bëhoho ë aruꞌaho sisëho jaburo gavëꞌego hu ëhi jiëꞌe ae jiamu garuomëꞌego ëhuni jövadeje. ");
INSERT INTO aom_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Ëhi ëꞌëꞌëro sisonuvoꞌi titimamugo Iesuro riꞌöromo vaꞌo a rumoꞌe saꞌare hiromo ë parie vaejadeje. ");
INSERT INTO aom_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Parie vaejamu Simon-mëro Iesu nahobe rovareje. ");
INSERT INTO aom_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Nahobe rueromo birohoromo uavareje: Ae ahoꞌobëhe ja nahavaruëjo. ");
INSERT INTO aom_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Nahavaruëjamu Iesuro uëvadeje: Ruehego no amo göre göre vaꞌarëjo naro God-are jöho amo ioroꞌiorohuꞌo majëhiꞌirode höjo. Ëhesi bëhoho na ëhi ëꞌirodëro rovode höjo. ");
INSERT INTO aom_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Ëhi uënugoromo vaꞌoromo God-are jöho Jew rajehu God rajahijarue osare osare majëhibe Satan-are aruꞌaho sisëho a jabesi dëroho rarovöꞌöjëvobe ëhiꞌobe Galilee saꞌae bövioho juvo barëjadeje. ");
INSERT INTO aom_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Ëhiꞌamu iae sino jomoꞌe ae gemuëro rueromo ague aho hiromo ëninamiromo uavadeje: Ja nasi sino avohehoꞌiranoho ja eni javajëjo. Ëhuni jasi nimoromo ajemijëꞌohuro iae ajemiꞌanuëjo. ");
INSERT INTO aom_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Ajemiꞌanuëjamu Iesuro huni vavaenimoromo övoho nugöꞌöromo sinoho rëhahoromo uavadeje: Iae na negajëjo ajamiꞌiro. Marëjëjo. ");
INSERT INTO aom_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Marëjëjamu gavëꞌi jomoho rireromoromo hesi sinore sisë sisëho barëjadeje. ");
INSERT INTO aom_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Barëjamu gavëꞌi Iesuro hu nugöꞌöromo darugoꞌe jöho uavadeje: ");
INSERT INTO aom_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","Aveho hejëjo. Nadi aho uënëjo. Aꞌi ma-vaꞌiranoho jasi sinoho priest röjahego gaꞌirajo. Ëhiꞌego Moses-hu uövuade ëhi jiëꞌe suvuoroho God-are öroro bojamego aëro garomo uvoꞌirarëjo: Jasi sinore sisëho barëjëꞌëro iae mae javajëjo. ");
INSERT INTO aom_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Ëhi uavamu rue ahuro Iesuare jöho bogo ejahoꞌi vaꞌoromo Iesuhu ajamade jöho ae majëhibe juvadeje. Ae majëhibe juvamu ae ahoꞌobëhe hebe vaꞌamu Iesuro urimo ëꞌonövadëhi amore amore ma-vaꞌorahoro juvoꞌiëꞌoromo gavade ae ahoꞌo hu gaꞌi tagavamu gëgorovo vuonugoꞌi a rumoꞌe saꞌare vaꞌo hijadeje. Hiꞌego ae ahoꞌobëhe dinöꞌe dinöꞌe jioromo hu gaꞌi ruenövareje. ");
INSERT INTO aom_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Ëhiꞌamu iae majae gemu niöꞌi barëjamu gagoro Iesuro Capernaum amore vuonoröꞌö rovadeje. Rovamu ae ahoꞌobëhe hejare uvamu: Iesu hesi osare hijajë uvamu hegorovo ");
INSERT INTO aom_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","rueromo ë gagovoruomadeje. Gagovoruomamu röhe ahoꞌobëhe osaho ojanoho rarovo barëjadeje. Rarovo barëjamu huro God-are jöho majëhijadeje. ");
INSERT INTO aom_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Majëhijamu evare ae ëhi niöꞌi ëhi niöꞌi jaburo övo höruꞌe vuovahëꞌe aho maratuore giojimo barueꞌi a ioroꞌiorohuro ma-namijëho rovareje. ");
INSERT INTO aom_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Rueromo Iesuare bëhire rueꞌiëꞌoromo gavare ae ahoꞌobëhe tagavoromo röhoho rarovëꞌe jiamu gagorovo javu dönö baꞌojiomoromo Iesuare simano namonö dadovareje. Dadovoromo maratuohuꞌo ëhi nume osare baꞌamareje. ");
INSERT INTO aom_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Baꞌamamu Iesuro gavade iꞌe rovare ariböviohuro hu mae uehorovoruomamu gëgorovo övo höruꞌe vuovahëꞌe aho uavadeje: Harihëjo. Jasi sisëho uehorovoromo vuonugoromo muꞌu barëjahëꞌe höjo. ");
INSERT INTO aom_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Muꞌu barëjahëꞌe höjamu hegorovo Jew rajo jögoru öri röjëhijarue a ioroꞌiorohuro ë raromoromo jabesi simanëro uehorovoromo uvoruomadeje: ");
INSERT INTO aom_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","Asëꞌëjo. Ave aho rabëni ëhi jiëꞌe jöho jövajëjo. Ëhi jiëꞌoho huro God-are ihoho ijumajëjo. Hu ma-ae höjo. Röhu huro ë aho uavajëjo: Naro jasi sisëho uehorovoromo vuonugoromo muꞌu barëjahëꞌe jevajëjo. Ëhi jiëꞌe muoho hesi God-ro gemuëro vaejaje höjo. Ma-aho bogajo. ");
INSERT INTO aom_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Ëhi uehorovamu Iesuro hesi dë vövöbajoꞌëro gëromo uvadeje: Jabumë ëhi uehorovaruëromo uëvadeje: Jemë rabëni uehore gö gö baejarujëjo. ");
INSERT INTO aom_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Jemëꞌo uehorovohëjo. Ave övo höruꞌe vuovahëꞌe aho nani ja ëma uaꞌaꞌanuëjo: Jasi sisëho uehorovoromo vuonugahëꞌe hö uaꞌaꞌanuëjo. Ja ëhi uaꞌibejanëjo aho nunoho bogo gaꞌibejarëjo ja mae o sarere jövëꞌe javego. Röhu ja bogo ëma uaꞌaꞌanuëjo: Riꞌöromo jasi maratuoho banigojiomoromo nami juvëjo hesi guomo guomoho bogo barëjego ja javojagojöëni. ");
INSERT INTO aom_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Röhu ë bogo ëma jövoꞌibejane jöho iae na jövoꞌejöjo huro ejehoromo riꞌö nami juvego jemëro ë muoho garomo ëhuro gaꞌirarijego God-are A Maho naro saꞌare hijajire evare sisë muꞌuvaje darugoho ëhuꞌo baejëꞌe jevego. Ëhi uënugoromo röhu övo höruꞌe vuovahëꞌe aho uavadeje: ");
INSERT INTO aom_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","Naro ja uavajëjo: Riꞌöromo raromanue maratuoho banigojiomoromo baeromo jasi osahuro vaꞌëjo. ");
INSERT INTO aom_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Vaꞌëjamu hejëꞌi ruehuro riꞌöromo maratuoho ma-burëro banigojiomoromo baeromo ae ahoꞌobëhe jabesi nunire höröromo amonö vaꞌadeje. Höröromo vaꞌamu gagorovo ë ariböviohuro ahoꞌobëhe tiöꞌi God rajahiromo uarovareje: Asëꞌëjo. Ëhi jiëꞌe mu börömoho urimoho no bogo gavare höjo. ");
INSERT INTO aom_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Ëhiꞌamu iae Iesuro amore jioromo vaꞌoromo röhu maho Galilee jovo eꞌu riröre vaꞌadeje. Vaꞌamu ae ahoꞌobëhe ijore vaꞌoromo hesi bëhire gagovoruomadeje. Gagovamu gagorovo jöho röjëhijadeje. ");
INSERT INTO aom_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Röjëhi barënugoromo vaꞌadeje. Vaꞌi gavade tax baejaje ae hesi ihoho Levi Alphaeus-are harihoho hesi mu vaejaje osare hijamu gagorovo uavadeje: Rueromo nasi ijoro ijoro juvonövonëjo. Juvonövonëjamu hegorovo riꞌöromo aevoromo Iesuare ijore ijore juvonövadeje. ");
INSERT INTO aom_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Ëhiꞌamu Iesumëro Levi-are osare ie ueꞌahamu evare tax baejarue ae ahoꞌo sisë aribövie ahoꞌo urimo Iesuare ijore ijore jijihonövëꞌëro jiëꞌëro ëhuꞌëro ëho jaburo rueromo Iesuꞌo hesi ijorajo ömoꞌömohuꞌo gemuoro ioho ueꞌahareje. ");
INSERT INTO aom_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Ie ueꞌahamu gëgorovo Pharisee aribövie Jew rajo jögoru öri röjëhijarue ariböviohuro gavare Iesuro sisë ariböviohuꞌo tax baejarue ariböviohuꞌo ëho jabuꞌo gemu mae ie ijamu gagorovo hesi ijorajo ömoꞌömoho uëvareje: Asëꞌëjo. Hu rabëni tax baejarue ariböviohuꞌo sisë a ioroꞌiorohuꞌo gemuoroho hiromo ioho ijajëjo. Ëhi jiëꞌoho sisë höjo. ");
INSERT INTO aom_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Ëhi jiëꞌoho sisë hö uvavamu hegorovo Iesuro huꞌo heromo ë Pharisee aribövioho uhuꞌe uëvadeje: Jemëhu nasi aribövi ëhi uëvarujoho röhu guomo guomoꞌe ariböviohuremu doctor gavarue höjo mae jëvëꞌe aribövioho bogajo. Ëhesi bëhoho naro sisë aribövioho nasinö jëvojöro uëꞌi rovode höjo ma-döemu mae jëvëꞌe aribövioho bogajo. ");
INSERT INTO aom_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Ëhiꞌamu iae John-are ijore ijore jijiharue ariböviohuꞌo Pharisee ariböviohuꞌo ëho jaburo God uehorovoꞌi ioho vuonugareje. Ioho vuonugamu aëro rueromo Iesu uavareje: John-are jö o Pharisee jabesi jö hejarue ë aribövioho jaburo ioho vuonugarue höjo. Röhu jasi aribövioho rabëni bogo ëhioho ioho vuonugarue höjo. ");
INSERT INTO aom_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Rabëni bogo ëhioho ioho vuonugarue höjamu hegorovo Iesuro uëvadeje: Nasi ijore ijore jijiharue ariböviehu i bogo vuonugarue hesi bëhoho naro uhuꞌe uëꞌiëꞌajëjo. Na jemëro uvarujëjo: Iꞌo masuꞌiröhe a hesi söröre rueromo aemoꞌaemëro ioho vuonugoꞌaruëjo. Bogo ëhioho jioꞌi aꞌi iꞌo masuröhe aehu jabuꞌo hijajevare evare ioho ueꞌahoꞌaruëjo. ");
INSERT INTO aom_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Röhu majae ijonö iꞌo masuröhe aho aëro guduamo bavaꞌiramu evare ioho vuonugoꞌaruëjo. Avevejöꞌoho naro jabuꞌo hijëꞌego jabu ioho bogo vuonugoꞌaruëjo. ");
INSERT INTO aom_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Ëhi uënugoromo Iesuro uhu jöe göꞌo majëhiromo uëvadeje: Niögu iꞌohuꞌo mamiohuꞌo bogo havoꞌanuëjo. Bogo havoromo niögu mami dadovadiroho niögu iꞌo hesi vituoho baeromo niögu mami hesi gagoroho bamoromo sigohiꞌanuëjo iꞌohuro duduhirovoromo mamioho ruho barovego dadovego gagoho böviraejöëni. ");
INSERT INTO aom_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","O wine jovo mi sino gagore biguꞌiëꞌiroho jovo iꞌohuꞌo mi sino mamiohuꞌo bogo gemuoroho havoromo jovo iꞌoho mi sino mamiroho biguꞌanuëjo. Ëhi ëꞌibejanëjo jovohuro gatovoromo ögohuro bibivoromo mi sinoho mamiëro jiëꞌëro tögömoromo ioroꞌioremu dadorovego jovoho rovaꞌo barëꞌibejajo. Aꞌi jovo iꞌoho mi sino iꞌo hesi gagoremu biguꞌanuëjo. ");
INSERT INTO aom_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Iae Jew rajo nuho majaho rovamu gagorovo Iesumëro mure jijihareje. Jijihoromo hesi ijorajo ömoꞌömohuro ioho babovoromo ueꞌahobe vaꞌareje. ");
INSERT INTO aom_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Babovoromo ueꞌahobe vaꞌamu Pharisee ariböviëro Iesu uavareje: Asëꞌe jaruvoho nuho majae höjo. Jasi ijorajo ömoꞌömehu i avoharuoho ëho nuho maja hesi jögoroho aharuëjo. Jabumë rabëni ëhi jiëꞌoho ëꞌaruëjo. ");
INSERT INTO aom_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Ëhi uëvamu Iesuro uëvadeje: David nosi a böröme jionövade höjo. Röhu huꞌo hesi ariböviohuꞌo ie bogojëvoromo hömëvamu huhu ëꞌade jö God-are surire adaharijoho ëho diehiꞌoromo bogo avoho uehorovarujëjo. ");
INSERT INTO aom_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Abiathar priest böröme jiadevare evare David-ro God-are osa mare vaꞌade höjo. Vaꞌoromo God-are nunire bahijare ioho ujuohoromo vituoho iꞌi vituoho hesi aribövioho iꞌimëmamu ueꞌahare höjo. Ëhi jiëꞌe ioho bogo aho ueꞌahoꞌi hesi ma-priest-ëremu ueꞌahoꞌiröhe ie höjo. Röhu jabuhu ueꞌaharohuro ëhuro jögoroho ahare höjo. Röhu ë hesi jöho bogojiade höjo. ");
INSERT INTO aom_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Ëhi uënugoromo uëvadeje: God-ro nuho majaho bamëꞌe höjo ae ajamuiꞌiröhëro. Bogo aho bamavuade höjo nuho maja hesi jöho eꞌiröhego. ");
INSERT INTO aom_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Ëhuꞌëro God-are A Maho naro nuho maja hesi jögoroho ëhuꞌo muebejaje höjo. ");
INSERT INTO aom_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Ëhiꞌamu iae Iesuro God rajahijarue osare rumo vaꞌadeje. Amo ë osare övo hitahi guomahëꞌe aho hijëꞌe jiadeje. ");
INSERT INTO aom_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Hijamu gagorovo aëro ë raromëꞌëro Iesuare jö sisëho nahoromo uvareje: Iesuhu ë a hesi övo avohëhëꞌoho noro a masijoho huruoho majëhiromo uëꞌejarëjo: Iesuro a ajamaje muoho vaeromo nuho maja hesi jögoroho ahade höjo. Ëhi uvoromo jabumëro ma-hu gemu ërimahareje gaꞌiro nuho majare huro ë a hesi övoho avohahego o bogo. ");
INSERT INTO aom_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Ërimahamu Iesuro övo guomahëꞌe aho uavadeje: Ave a nunoro rovëjamu rovadeje. ");
INSERT INTO aom_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Rovamu hu bijönimoromo ërimaharuoho uëvadeje: Nosi jögoroho diehi höjo. Nuho majaroho na ae mae vaejëvoꞌejarëjo o sisë vaejëvoꞌejarëjo. Iꞌovëvoꞌejarëjo o muoꞌamoꞌejarëjo. Ëhi uëvamu rue ariböviohuro ma-jörumoraejareje. ");
INSERT INTO aom_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Jörumoraejamu Iesuro uvadeje: Ëaribövioho hiaꞌi biririꞌe aribövie jioruomajë uvoromo huë vavaeni böröme baeromo dë vörönimamu uherihoromo ë aribövioho gëvadeje. Gënugoromo övo guomahëꞌe aho uavadeje: Jasi övoho nugöꞌöjëjo. Ëhi uavamu hegorovo övoho nugöꞌöjamu marëjadeje. ");
INSERT INTO aom_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Marëjamu gagorovo rue Pharisee ariböviohuro suorovo vaꞌoromo saꞌare a böröme Herod nimarue ariböviohuꞌo gemu mae gagovoromo Iesu anoröhe jöho mevoruomadeje. ");
INSERT INTO aom_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Ëhiꞌamu Iesuro hesi ijorajo ömoꞌömohuꞌo gemu mae ë amore jioromo vaꞌoromo Galilee eꞌu riröre abuejadeje. Abuejamu ae ahoꞌobëhe mae Galilee saꞌare jioromo hesi ijore rueruomadeje. ");
INSERT INTO aom_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Rueruomamu rue Jerusalem amore Judea saꞌa ioroꞌiorore jioromo arue Idumea saꞌare jioromo ruhe Jordan jovo ioroꞌioro gönö jioromo nume Tyre amoꞌo Sidon amoꞌo jiajinö ë ae ahoꞌobëhe jioromo Iesuhu mu masijo vaejaje jöho hegorovo hesi örire rueruomadeje. ");
INSERT INTO aom_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Rueruomamu gëgorovo Iesuro uvadeje: Ae ahoꞌobëhe jioruomëꞌëro nani jabumëro na tatijiomevoruomoꞌajë uvoromo hesi ijorajo ömoꞌömoho uëvadeje: Boat harihe avohehego na ë hiꞌiröjo. ");
INSERT INTO aom_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Röhu Iesuro hu tatijiomoröhe jö uehorovade hesi bëhoho huro ae ahoꞌobëhe avohëvamu mae jioꞌamëꞌego guomo guomoꞌe aho ahoꞌobëhe göëro gö bijimöꞌöbe iosiramirovobe rueꞌiëꞌareje hu rëhego mae jëvoröhego. ");
INSERT INTO aom_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","O Satan-are aruꞌaho sisë a jabesi dëre raromaroho ëho jabuhu Iesu gavëꞌiroho hesi nuninö behumorovoꞌamoromo ma-darugoꞌo uvonövareje: Ja God-are Harihe javajëjo. ");
INSERT INTO aom_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","God-are Harihe javajëꞌego Iesuro ë aruꞌaho sisëho uënövadeje: Jöe nugohëjo. Na rahu jevajoho bogave aho huruoho majëhiꞌirarijëjo. ");
INSERT INTO aom_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Ëhiꞌonugoromo iae Iesuro dahorure ajiomoromo hesi baejëvoꞌi nimade aribövioho uëvadeje: Ruehëjo. Ruehëjamu rovareje. ");
INSERT INTO aom_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Rovamu ae ahoꞌobëhe 12 baejëvadeje huꞌo gemu mae raromo jijihoꞌiröhego. O rëmöꞌöjego hesi jöho ae majëhibe jijihoꞌiröhego. ");
INSERT INTO aom_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","O Satan-are ariböviehu a dëre jioruomajoho uëvego suorovoromo vaꞌoruomoröhego. ");
INSERT INTO aom_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Röhu baejëvade aribövi jabesi ihoho ëhi jëvadeje. Simon baejadeje. Röhu Iesuro iho göho Peter jumuvadeje. ");
INSERT INTO aom_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Röhu Zebedee-are harihe niöꞌi Jamesꞌo Johnꞌo öꞌo öꞌo baejëvadeje. Röhu Iesuro jabumë niöꞌi ihe Boanerges jumëgadeje. Jabesi jöho Boanerges iho bëhoho nosi jöho vajerehu anajëhi ëhi jëvëꞌe ae jëve. ");
INSERT INTO aom_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Röhu Andrew Philip Bartholomew Matthew Thomas o Alphaeus-are harihe James o Thaddaeus o Simon ëhi baejëvadeje. Röhu Simon hu Jew rajehu jabesi mueberovoꞌi nimade aho jiadeje. ");
INSERT INTO aom_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","O Judas Iscariot huꞌo baejadeje. Judas Iscariot hu ijonö Iesuni hiruëmiromo a jabesi övore bojëmiꞌiröhe aho jiadeje. ");
INSERT INTO aom_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Ëhiꞌonugoromo Iesu vaꞌoromo hesi osare hijadeje. Hijamu ae ahoꞌobëhe mae röhu maho hu gaꞌi ro gagovamu ëhuro Iesuꞌo hesi ijorajo ömoꞌömohuꞌo i ueꞌahoꞌiröhoho bogo eni jëvadeje. ");
INSERT INTO aom_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Bogo eni jëvamu hesi aganohuro ëho heromo uvareje: Nani Iesuare simanoho sisërëjahëꞌe höromo hu guduamoromo huꞌirae bavaꞌi rovareje. ");
INSERT INTO aom_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Ëhiꞌamu Jew rajo jögoru öri röjëhijarue ariböviohuro urimo Jerusalem jioromo rovëꞌëro atoromo uvonövareje: Iesu hu Beelzebul aruꞌaho sisë dëre jiajëjo. Sisë a börömohuro vöröho bojamijego ëhuro a dëre aruꞌaho sisëho rarovöꞌöꞌamaje höjo. ");
INSERT INTO aom_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Rarovöꞌöꞌamaje höjamu hegorovo Iesuro uëvadeje: Ruehego na jöe majëhijöjo. Majëhijöjamu rovamu uhuꞌe uëvadeje: Diehiꞌoromo Satan-ro hesi aruꞌaho sisëho rarovöꞌöjëvojöro uvarujëjo. ");
INSERT INTO aom_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Saꞌae gemuehu adovoromo jabesi arijoꞌarije muorovëꞌoho ë saꞌaho bogo biririvoꞌi barërovoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","O agane gemuehu adovoromo jabesi arijoꞌarije muorovëꞌoho ë aganoho bogo biririvoꞌi barërovoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Ëhuni Satan-ro riꞌöromo hesi ariböviohuꞌo muorovoꞌibejajo hesi darugoho uehoroho muoho bogo biririvoꞌi barëꞌibejajo. ");
INSERT INTO aom_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Röhu aehu darugoꞌe a hesi osare rumo vaꞌoromo hesi mae sisë ujuohaho vaꞌiëꞌiroho bogo ëma ujuohaho vaꞌirögoro urimo darugoꞌe aho guduamoromo tövonugoromo evare hesi inömo inömoho ujuohaho vaꞌaꞌajëjo. Naro Satan ëhi ruahöꞌöjaje höjo. ");
INSERT INTO aom_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Ave jöho na jö mae uëꞌiëꞌajëjo. Aehu mu sisë vaejëꞌoho God-are iho ijumarue jö sisë atëꞌoho ahoꞌo God-ro uehorovoromo vuonugëhoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Aꞌi God-are Aruꞌaho hesi iho ijumëꞌoho ëhi jiëꞌe jö sisëho God bogo mae bogo uehorovoromo vuonugoꞌi ë mu sisë vaejëꞌoho ë hesi iꞌuoho ma-ioroꞌiore gemu baeruomoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Iesuhu ëhi uëvade hesi bëhoho ë ariböviohuro atoromo uvareje: Aruꞌaho sisëro Iesuare dëre abuejëꞌe höjo. ");
INSERT INTO aom_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Ëhiꞌamu iae Iesuare vëmohuꞌo ö ömoꞌömohuꞌo rovareje. Rueromo amonö riravoromo Iesuro ruejöro jöe nugöꞌöjareje. ");
INSERT INTO aom_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Jöe nugöꞌöjamu Iesu ririre hiꞌi ae ahoꞌobëhe ruë numë raromo rovaꞌo rojomëꞌëro uavareje: Hë-ajo. Jasi vëmohuꞌo ö ömoꞌömohuꞌo ja gaꞌi nimoromo amonö ro riravaruëjo. ");
INSERT INTO aom_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Riravaruëjamu uëvadeje: Jemë uehorovarujoho nasi vëmoho ö ömoꞌömoho di aribövioho jioruomajëjo. ");
INSERT INTO aom_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Ëhi uënugoromo uherihoromo ruë numë raromo rovaꞌo rojomarue aribövioho gëromo uëvadeje: Aveho gahëjo. Aruëroho nasi vëmohuꞌo ö ömoꞌömohuꞌo jëvajëjo. ");
INSERT INTO aom_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Ae rahu God-hu nimaje mu vaejëꞌoho ëhuro ë aribövioho nasi öe maꞌine vëme jioruomajëjo. ");
INSERT INTO aom_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Ëhiꞌamu iae Iesuro röhu maho eꞌu riröre vaꞌo hiromo jöho röjëhijadeje. Röjëhijamu ae ahoꞌobëhe ro tagavamu Iesuro jovore boat gagore vaꞌo hiꞌi ae ahoꞌobëhe jovo riröre raromareje. ");
INSERT INTO aom_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Jovo riröre raromamu Iesuro uhu jöe majëhiromo ëhuro jöe ahoꞌobëhe röjëhijadeje. Röjëhiromo uëvadeje: ");
INSERT INTO aom_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","Jöe hehëjo. Iae ae gemuëro i uje ujuohoromo mure riremoꞌi vaꞌade höjo. ");
INSERT INTO aom_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Riremobe vaꞌamu ujo ioroꞌioroho örire rireromade höjo. Rireromamu gavëꞌi ugëro ro i barëjare höjo. ");
INSERT INTO aom_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Ujo ioroꞌioroho munë uhunö jiëꞌe saꞌare rireromade höjo. Rireromoromo ma-burëro riꞌamade höjo saꞌaho munë döro ma-bisemu jiëꞌëro. ");
INSERT INTO aom_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Riromo dirumoho bogo ma ioꞌamëꞌëro majaëro rojomoromo anamu sahoriꞌamade höjo. ");
INSERT INTO aom_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Ujo ioroꞌioroho bibëꞌe resu resuꞌe saꞌare rireromade höjo. Rireromëꞌëro bibëꞌe resuohuro riromo ujo maho babaꞌamade höjo. Babaꞌamamu maho bogo raeꞌamade höjo. ");
INSERT INTO aom_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Ujo ioroꞌioroho saꞌa mare rireromade höjo. Rireromoromo riromo ëgovoromo bajoho raeꞌamade höjo. Uje gemu gemu röhu ioroꞌioroho baje 30 raeꞌamoꞌi ioroꞌioroho 60 raeꞌamoꞌi ioroꞌioroho 100 raeꞌamade höjo. ");
INSERT INTO aom_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Ëhi uënugoromo uëvadeje: Ae rahu ja God-are jö hejanue ae javëꞌoho bëhoho nahoromo birohonëjo. ");
INSERT INTO aom_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Ëhi uëvamu ijonöho ae ahoꞌobëhe bogojioꞌi Iesuro hesi ariböviohuꞌo gemu mae hijadeje. Hijamu hesi ijorajo 12-huꞌo hesi bëhire raromarue aribövi ioroꞌiorohuꞌo ëho jaburo uhu jö hesi bëhoho ua gavareje. ");
INSERT INTO aom_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Ua gavamu Iesuro uëvadeje: God-ro böröme namiromo ahoꞌobëhe muebejaje jöho urimoho subivëhade höjo. Ësubivëhade jöho huro hesi suvuore jemë bojëmijëꞌe höjo jemëremu heꞌirarijego. Ëhuꞌëro jemëro jö bëhoho heꞌi a ioroꞌioro jabesi öriroho ma-uhu jöemu rovaje höjo. ");
INSERT INTO aom_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Jabuni ma-uhu jöemu rovaje hesi bëhoho ë jöho God-are surire jajivoromo ëhi uvëꞌe höjo: God-ro nimade höjo ë ariböviohuro muoho ma-gaemu gaꞌi bogo avoho garuomoröhego. O jöho ma-hemu heꞌi bogo avoho heröhego. Garomo heꞌibejarëjo jabumë huotorovoromo God-arinö vaꞌego ëhuro hu jabesi sisëho uehorovoromo vuonugoꞌibejajo. ");
INSERT INTO aom_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Ëhi uënugoromo uëvadeje: Röhu naehu majëhijode uhu jöho jemë diehiꞌoromo bëhoho bogo hejarujëjo. Bogo hejarujoho diehiꞌoromo uhu jö ioroꞌioro hesi bëhohuꞌo avoho herëjo. ");
INSERT INTO aom_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Aehu mure ruruhöꞌöjade i ujo hesi bëhoho ëho God-are jö a majëhijajoho uëromo ëꞌode höjo. ");
INSERT INTO aom_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Ujo örire rireromamu ugehu i barëjare jö hesi bëhoho aehu God-are jö hejamu gavëꞌoho Satan-ro ma-burëro rovaje höjo. Rueromo gavaje God-are jöho i ujonöꞌe jabesi dëre jiego garomo baeniëhiromo roriꞌo buꞌöjaje höjo. ");
INSERT INTO aom_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","O i ujehu munë uhunö jiëꞌe saꞌare rireromoromo riromo sahoriꞌamade jö hesi bëhoho aëro God-are jöho hejarue höjo. Heromo ma-burëro nimorohoromo jöho ejaharue höjo. ");
INSERT INTO aom_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Ejahoromo jöho ma-döëremu baejëꞌëro majae ma-bunemu mae uehorovoromo garöhe God-are jö uehorovaruohuni aehu sisë vaejëvamu gavëꞌoho o huë vavaene rovamu gavëꞌoho ma-burëro vuonugarue höjo. ");
INSERT INTO aom_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","O ujehu bibëꞌe resu gemuore rireromade jö hesi bëhoho aëro God-are jöho heruomaje höjo. ");
INSERT INTO aom_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Heromo ave saꞌa hesi muohuni nurunurumoromo o sarerivoromo inöme börömo mae ujuohoꞌi o bövie biseꞌe ujuohoꞌi nimoromo ëhemu uehorovoromo ëho jabesi nuninö bamarue höjo. Bamoromo saꞌarohemu uehorovaruohuro ëhuro God-are jö jabesi dëre jiajoho taemego jabumë bogo rae avoharue höjo. ");
INSERT INTO aom_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","O ujehu saꞌa mare rireromoromo baje 30 o 60 o 100 raeꞌamade jö hesi bëhoho aëro God-are jöho heromo ejahoromo rae avohoruomaje höjo ioroꞌiorohuro ioroꞌioroho iosirëmiromo mu ma-mabëhe vaejarue höjo. ");
INSERT INTO aom_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Röhu uhu jöe göꞌo majëhiꞌiëꞌajëjo. Jemëꞌo uehorovohëjo. Iro bunoꞌiraeromo osare barovarue hesi bëhoho bogo hevö gagoroho o maratu ahariroho gurihi bamoꞌi vaꞌorahoro bamoꞌiro ëhuni barovarue höjo. ");
INSERT INTO aom_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Ëho naro uëromo ëꞌajëjo: Nasi jöe rabe rabe gurihiro jiaje naehu jövaje hesi bëhoho ma-vaꞌorahoro jioröhego jövajëjo. O rabe rabe subivëhaje naehu uëvaje hesi bëhoho ma-samaro jioröhego uëvajëjo. ");
INSERT INTO aom_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Ae rahu ja God-are jö hejanue ae javëꞌoho bëhoho nahoromo birohonëjo. ");
INSERT INTO aom_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Ëhi uënugoromo uëvadeje: Nasi jö hejarujoho avoꞌavoho uehorovonövorëjo. Uehore ma-bisemu bamëꞌoho ëhuro ajiꞌe jöho ma-bisemu baeꞌaꞌarujëjo. O börömo bamëꞌohuro ëhuro böröme baeꞌaꞌarujëjo. Röhu göꞌo döre börömo bëhe baeꞌaꞌarujëjo. ");
INSERT INTO aom_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Ajiꞌe jö javëꞌoho God-ro göꞌo bojamiꞌiramu baeꞌaꞌanuëjo. O bogojavëꞌoho bisemu baejanoho God-ro ë uehoroho muꞌuvahoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Röhu Iesuro uhu jöe göꞌo majëhiromo uëvadeje: I ujehu riromo raejajëhi God-ro böröme namiromo hesi öri ariꞌoho bövioho biseꞌoho ëhi muebejëvaje höjo. Ëjöho naro majëhiꞌiëꞌajëjo. Mu arijoꞌohuro nani ujoho saꞌare suovo ruruhöꞌöbe vaꞌaꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Vaꞌoromo vahiromoꞌiramu niavoromo sisonuvoꞌiramu riꞌönövoꞌajëjo. Ëhiꞌobe vaꞌiramu ë majae gemuore ujo suovo ruruhöꞌöjadohuro rëdijiomoromo riꞌamoꞌajëjo. Ëhiꞌoꞌiramu mu arijoꞌohuro ëho garomo dadivoromo uvoꞌaꞌajëjo: Diehiꞌoromo ëꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Ëhi uvoꞌaꞌajëjo röhu hesi saꞌaëro rihuoho bojamego i ujoho riromo inovoromo maho raejaje höjo. ");
INSERT INTO aom_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Maho raeromo mavego evare arijoꞌohuro ma-burëro tarivoromo gagovoromo avoho bahijaje höjo ë hesi bëhoho ë gagovarue majaho rovëꞌego. ");
INSERT INTO aom_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Röhu Iesuro jöe göꞌo majëhiromo uëvadeje: God-hu böröme namiromo muebejëvaje öroho naro uhuꞌe buꞌöromo jemëꞌo naꞌo uehorovoꞌejarëjo. ");
INSERT INTO aom_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Ijo hisu ihe mustard ujehu börömoriromo ëgovajëhi God-ro böröme namiromo ae göꞌo göꞌo ëhi gagovoromo muebejëvobe vaꞌaꞌajëjo. Mustard uje gemu saꞌare öjëꞌiroho bajo ioroꞌioro dinöꞌe dinöꞌe jioꞌamajoho ëho ma-jianovoꞌamoꞌi aꞌi ë mustard ujoho biseharihe höjo. ");
INSERT INTO aom_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Ëhi höjo röhu riromo ëgovoromo ijo hisu ioroꞌioroho iosiramiꞌamoromo ëho börömoho höjo. Börömoriromo adoho ëgovoꞌamego ugëro rueromo gavarue sanu mae jiegorovo ijuoho ë vaeꞌamarue höjo. Ëhi uëvadeje. ");
INSERT INTO aom_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Ëhi jiëꞌe uhu jöho ahoꞌobëhe Iesuro uëromo ëhuro hesi jöho majëhinövadeje. Jabumë diehi jiëꞌe jö baeꞌiröhoho eni jëvëꞌoho ëhi jiëꞌe jöhuremu majëhinövadeje. ");
INSERT INTO aom_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Jöho bogo mae bogo samaroho majëhiꞌi ma-uhuꞌe gemu majëhinövadeje. Majëhiromo röhu huꞌo hesi ariböviohuꞌo jabesi sivue raromëꞌiroho jöho ahoꞌo huruoho majëhinövadeje. ");
INSERT INTO aom_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Iesuro boat-re hiromo ëhi jiëꞌe uhu jöho majëhinugoromo vöꞌöromamu gagorovo hesi aribövioho uëvadeje: Ruehego no aruhe eꞌu ioni gönö vaꞌarëjo. ");
INSERT INTO aom_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Vaꞌarëjamu hegorovo ë Iesuare ariböviohuro ae ahoꞌobëhe ë rëmoꞌi Iesuhu hijaje boat-re iojiomoromo hu boat-re baeromo vaꞌareje. Bavaꞌamu boat ioroꞌioroho ëhuꞌo gemu mae vaꞌoruomadeje. ");
INSERT INTO aom_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Vaꞌamu buru böröme eꞌure rovadeje. Bure rovamu jovohuro hasaromo boat-re ro nemoromo ruahoromo abueromo irijiomoromo diruvëvoꞌiëꞌadeje. ");
INSERT INTO aom_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Diruvëvoꞌiaꞌamu gavëꞌi ijorajoho jaburo gavare Iesu mamiꞌe boat dejonö vaꞌo raromoromo simano dövaejaruohuro simane dövaeromo niavëꞌe jiamu gagorovo ioromo uavareje: Tisa no vuovavuoꞌiëꞌajëjo. Na ja nosi jöënioho bogo uehorovanuëjo. ");
INSERT INTO aom_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Uehorovanuëjamu Iesuro riꞌöromo burohuꞌo hasajaje jovohuꞌo uëvadeje: Vuonugohëjo. Vuonugohëjamu buroho ahöꞌöꞌi jovoho uꞌuhoromo ma-jörume ruhijadeje. ");
INSERT INTO aom_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Ma-jörume ruhijamu gagorovo hesi aribövioho uëvadeje: Jemë rabëni juhuonivarujëjo. Urimëꞌi jemë bogo ma uehorovevobe rovarijoho na jemë jaruvohuꞌo ëhi gemuoho ëꞌarujëjo. ");
INSERT INTO aom_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Ëhi gemuoho ëꞌarujëjamu sisë maro juhuonivoromo uarovareje: Ave aho diehi jiëꞌe ae höjo. Huhu uëvëꞌoho bogo aëremuoho ejahoꞌi burohuꞌo jovohuꞌo jabuꞌo hesi jöho ejaharue höjo. ");
INSERT INTO aom_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Ëhiꞌonugoromo jabuꞌo Iesuꞌo vaꞌaroho vaꞌo eꞌu ioni gönö Gerasene rajo jabesi saꞌare vaꞌo baboro bejareje. ");
INSERT INTO aom_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Baboro bejamu gagorovo ae gemuëro guavoꞌamarue juju gagore jioromo rueromo Iesu birohadeje. Ëa hesi dëre Satan-are a sisëro abueruomamu simane huotorovëꞌe jiadeje. ");
INSERT INTO aom_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Simane huotorovëꞌëro guavoꞌamarue juju gago jioꞌamajire ë hinövadeje. Hiꞌego aëro vajaëro öꞌëro rabëro tövoꞌiëꞌoromo gavare bogo eni jëvamu vuonugareje. ");
INSERT INTO aom_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Urimoroho aëro vajaëro övore hörure tövoꞌego övore öꞌoho ruho tarivoromo hörure vajaho ano ahöꞌönövadeje. Ëhiꞌoromo vöröꞌiraeꞌego aehu guduamoromo huꞌirae ro röhore nugoꞌiröhoho bogo eni jëvonövadeje. ");
INSERT INTO aom_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Majae vahie jöꞌe dadovëꞌi munëro anorovëꞌi guavaruire hinövo dahorure ajio hinövadeje. ");
INSERT INTO aom_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Ëhiꞌonövëꞌëro ë ahuro roriꞌo öri ëgoböviro namiromo Iesu garomo tutuvo rueromo hesi bëhire ague aho hiromo ");
INSERT INTO aom_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","ma-darugoꞌo uvadeje: Iesu ja God dö mare hijaje a hesi Harihe javajëjo. Ja rabëni sihusihuegoꞌi rovane höjo. Na God-are nuniro uavajëjo: Nadi huë sisëho viꞌehoho bojemëjo. ");
INSERT INTO aom_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Viꞌehoho nadi bojemijë uvade hesi bëhoho urimëꞌi Iesuro hu uavadeje: Aruꞌaho sisëho jero ë a hesi dëre hijanuoho vuonugoꞌi vaꞌëjo. Ëhi uavëꞌego ëhuni uvadeje. ");
INSERT INTO aom_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Ëhi uvamu hegorovo Iesuro uavadeje: Jasi ihoho rahuo höjo. Rahuo höjamu uavadeje: Nasi ihoho Siriehu Bimuvanovëꞌoho jevajëjo. Ëhesi bëhoho no aruꞌahe ahoꞌobëhe dëre javuëꞌego ëhuni ëhi jumegëꞌe höjo. ");
INSERT INTO aom_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ëhi uaromo Iesu uaꞌi hijadeje: Aruꞌahoho nadi uëvego jabumë ave saꞌare jioromo vaꞌirarëjo. ");
INSERT INTO aom_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Röhu mahe ahoꞌobëhe aruhe dahoru ahore gemuoro gagovoromo ie ueꞌahamu gagorovo ");
INSERT INTO aom_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","dëre sisë ariböviohuro Iesu uavareje: Uövuego no suorovo vaꞌoromo aruhe mahu jabesi dëre vaꞌo abuejarëjo. ");
INSERT INTO aom_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Abuejarëjamu uëvadeje: Ëhuro vaꞌohë uëvamu hejëꞌi ë sisë ariböviohuro ë a hesi dëre jioromo suorovo vaꞌoromo ruhe mahu jabesi dëre abueruomadeje. Abueruomamu ë mahohuro vaꞌo baradore rireromoromo eꞌure siö ruruhöꞌö vaꞌoromo jove ueꞌahoromo vuovadeje. Mahe ahoꞌobëhe 2,000 rabuꞌe ëhi vuovoꞌamadeje. ");
INSERT INTO aom_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Vuovamu gavëꞌi mahu muebeꞌamarue ariböviohuro huruomoromo amo börömore amo ininore jöho majëhibe vaꞌareje. Jöho majëhijamu hejëꞌi ae ahoꞌobëhe rueruomadeje gaꞌiro diehi jiego. ");
INSERT INTO aom_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Iesuaro rueromo gavareje aruꞌaho sisëhu dëre jioromo suorovo vaꞌoruomade aho simanoho mae jioꞌego niöge baꞌamëꞌe hijamu. Urimoho ganövareje aruꞌaho sisë Siriehu Bimuvanovëꞌohuro hesi dëre jioruomëꞌe ëhi hiꞌego röhu evare majare gavareje ma-mae hijamu. Ëhi gagorovo juhuonivoruomadeje. ");
INSERT INTO aom_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Juhuonivamu Iesuhu mu vaejamu gavare ariböviohuro uëvareje: Sisë ariböviehu dëre abueꞌamade ahuꞌo mahohuꞌo ëhi jiëꞌe muoho birohoruomohijajo. ");
INSERT INTO aom_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Ëhi majëhijamu ae ahoꞌobëhe heromo Iesu uavareje: Ave saꞌaho vuonugoꞌi vaꞌëjo. ");
INSERT INTO aom_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Vuonugoꞌi vaꞌëjamu Iesuro boat-re ajiomoromo sionëro vuonoröꞌö vaꞌiëꞌadeje. Vaꞌiaꞌamu gavëꞌi aruꞌaho sisë hesirire jioromo suorovo vaꞌoruomade ahuro Iesu uavadeje: Na öꞌoromo jaꞌo hiꞌi negajëjo. ");
INSERT INTO aom_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Negajëjamu Iesuro uavadeje: Bogo rueꞌaꞌanuëjo. Sionëro jasi amëro vaꞌoromo jasi aganoho uënëjo: Badaro huë baejevoromo ëhi mabëhe ajemijamu rovode höjo. ");
INSERT INTO aom_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Ëhi uavamu hegorovo rue ahuro vaꞌoromo hesi saꞌa ihoho Ame 10 Jioꞌamaje Saꞌaho ë saꞌare majëhibe juvoromo uënövadeje: Iesuro ëhi mabëhe ajemamu rovode höjo. Ëhi majëhijamu hegorovo ae ahoꞌobëhe jöe barëjëvadeje. ");
INSERT INTO aom_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Ëhiꞌamu Iesuro boat-re vaꞌoromo anume eꞌu ioni gönö vaꞌo ravoꞌamadeje. Ravoꞌamoromo eꞌu riröre namijamu ae ahoꞌobëhe ruë numë gagovo rovaꞌoromo ëhi riravareje. ");
INSERT INTO aom_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Riravamu iae ae gemu hesi ihe Jairus-ro rovadeje. Jairus hu Jew rajehu God rajahijarue osa muebejaje ae jiadeje. Rueromo Iesu garomo hesi höru bëhire ague aho hiromo ");
INSERT INTO aom_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","dinamiromo uavadeje: Bësu guomoꞌiëꞌajëjo. Rueromo jasi övoho hesi sinoro bamego iꞌovoromo hijajo. ");
INSERT INTO aom_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Hijajamu hegorovo Iesuro huꞌo gemu mae vaꞌadeje. Vaꞌamu ae ahoꞌobëhe tatijiomobe huꞌo gemu mae ëhi vaꞌoruomadeje. ");
INSERT INTO aom_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Vaꞌoruomamu iae magonahe gemuëro jabuꞌo vaꞌadeje. Ëmagonahoho manaero garorovade guomo guomoho bogo barëꞌi ëhi jiemu jiobe vaꞌadoho vadune ahoꞌo 12 barëjëꞌe jiadeje. ");
INSERT INTO aom_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Doctor ahoꞌobëhe gëromo ëhuro viꞌehe sisë maro baenövadeje. Viꞌehe baeromo hesi ijo baje buꞌö barëꞌi röhu bogo marëꞌi sisërëbe vaꞌonövadeje. ");
INSERT INTO aom_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","28","Sisërëbe vaꞌamu ë magonahohuro hejade uvoruomamu: Iesuro ae magonahe mabëhe ajamuijaje hö uvamu hejëꞌëro uehorovoromo uvadeje: Na Iesu ma-niögohuremu rëhëꞌohuro ëhuro marëjevoꞌajëromo ae ahoꞌobëhe vaꞌaruire ë vaꞌoromo Iesuare dejonö rueromo niögoho rëhadeje. ");
INSERT INTO aom_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Niögoho rëhamu gavëꞌi magonahoho kö rovadoho ijoho bogo rovadeje. Ijoho bogo rovamu magonahohuro herovadeje mae jiavamu. ");
INSERT INTO aom_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Mae jiavamu Iesuro hejade a ajëmaje daruge gö hesirire jioromo vaꞌëꞌe jiavamu evare ma-burëro huotorovoromo ae ahoꞌobëhe uëvadeje: Ja rahuaro nasi niögoho rëhane höjo. ");
INSERT INTO aom_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Rëhane höjamu hegorovo hesi ijorajoho jaburo uavareje: Jaꞌo iae gavanuëjo ae ahoꞌobëhëro ja tatijiomavoꞌego. Ëhi jiëꞌoho ja rabëni uövuanuëjo: Ja rahuaro na rëhevane höjo. ");
INSERT INTO aom_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Ëhi uëvamu Iesuro arua anumiae uherihadeje gaꞌi di ahuro o di magonahohuro hu rëhëꞌe jiego. ");
INSERT INTO aom_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Uherihoromo gëvamu rue magonahohuro iae mae garomo uvadeje: Huro na ajemade hö uvoromo juhuonivoromo butubutumoromo röhu ma-biririvoromo rueromo Iesuare höru bëhire ague aho hiromo diehi ëꞌade jöho samaꞌe huruoho majahi barëjadeje. ");
INSERT INTO aom_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Majahi barëjamu Iesuro uavadeje: Abojëjo. Jero na mae uehorovevamu ëhuro ja marëjavëꞌe höjo. Vaevëꞌe vaꞌonëjo. Jasi guomo guomoho barëjavëꞌe jiaje ijonö mae jionëjo. ");
INSERT INTO aom_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Iesuro ëhi uavamu gavëꞌi ae göëro göëro Jairus-are osare jioromo rueromo Jairus uavareje: Jasi abojoho mamiꞌe guomëꞌe höjo. Ëhuꞌoho rabëni ja tisaho uꞌuoho bojamijanuëjo. ");
INSERT INTO aom_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Uꞌuoho bojamijanuëjamu hegorovo Iesuro he bogo hejanovëꞌe Jairus uavadeje: Nadi juhuonivoꞌi God mae uehorovonëjo. ");
INSERT INTO aom_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Ëhi uanugoromo Peter James o James-are öe John ëho jaburo huꞌo vaꞌojöro uëꞌi a ioroꞌioroho nijioꞌiraejëvadeje. ");
INSERT INTO aom_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Nijioꞌiraejëvonugoromo jaburo vaꞌoromo Jairus-are osare rovareje. Rueromo Iesuro gavadeje ae ahoꞌobëhe gagovorovëꞌëro garahöröꞌe baeromo ma-darugoꞌo nierusuburuꞌe bamoruomamu. ");
INSERT INTO aom_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Ëhiꞌamu gagorovo osare vaꞌoromo uëvadeje: Jemë rabëni garahöröꞌe baeromo nierusuburuꞌe bamarujëjo. Ëmagonaho harihoho bogo guomoꞌi ma-niavajëjo. ");
INSERT INTO aom_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Ma-niavajëjamu hegorovo rueho jaburo Iesu sivoromo ijoꞌijahareje. Ijoꞌijahamu gagorovo Iesuro ë aribövioho ahoꞌobëhe amonö rarovöꞌöjëvonugoromo magonaho harihu hesi vëmu vavuꞌohuꞌo huꞌo rovare ae niöꞌi gemu jabuꞌo ëhi söjëgoromo magonaho harihehu raromaje osare vaꞌadeje. ");
INSERT INTO aom_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Osare vaꞌoromo magonaho hesi övore maꞌenoromo hesi jöëro uavadeje: Tarita kumajo. Ëjöho huotovëꞌoho ëho uaromo ëꞌadeje: Bësu naro ja uavajëjo: Riꞌöjëjo. ");
INSERT INTO aom_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Riꞌöjëjamu hejëꞌi rue magonahohuro ma-burëro riꞌöromo nami juvadeje hesi vadunoho ahoꞌobëhe 12 jiëꞌëro. Juvamu gavëꞌi ae ahoꞌobëhe hu garomo tiöjëvadeje. ");
INSERT INTO aom_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Tiöjëvamu gagorovo Iesuro ma-darugoꞌo uëvadeje: Naehu vaejode muoho nadi aho huruohorëjo. Ëhi uënugoromo uëvadeje: Magonahoho ie bojamego ijajo. ");
INSERT INTO aom_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Ëhiꞌonugoromo Iesuro vaꞌadeje. Vaꞌoromo hesi amëro rueꞌi hesi ijorajoho jaburo huꞌo gemu mae rovareje. ");
INSERT INTO aom_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Rueruomoromo Jew rajo jabesi nuho majaho rovamu Iesuro God rajahijarue osare vaꞌoromo God-are jö bëhoho röjëhijadeje. Röjëhijamu ae ahoꞌobëhe heromo tiöjareje. Tiöromo uvoruomadeje: Ëiahuro jöho dinöꞌe hejëꞌëro jövajëjo. Hu diehiꞌoromo ëhi jiëꞌe simano maho baejade höjo. Darugoꞌe mu masijoho diehiꞌoromo vaejaje höjo. ");
INSERT INTO aom_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Hu sarerivajëjo. Ma-ijo muemu vaejaje ae höjo. Hu Mary-are harihe höjo. Hu James-are Joses-are Judas-are Simon-are öe höjo. Hesi maꞌino ömoꞌömoho aviae noꞌo gemu mae raromarue höjo. Ëhi uvoruomoromo nue huodivareje. ");
INSERT INTO aom_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Nue huodivamu gëgorovo Iesuro uëvadeje: Jö God-aro baeromo majëhijarue aribövioho dinöꞌe dinöꞌe vaꞌëꞌiroho aëro no mae uehorovavuarue höjo. Aꞌi nosi saꞌa rajoho aganoho osae gemuore raromaruoho jemëremu bogo ëhioho uehorovavuaruje höjo. ");
INSERT INTO aom_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Ëhi uëromo hu darugoꞌe mu vaeꞌiröhoho bogo eni jiadeje. Huro guomo guomoꞌe ae ma-gemu gemu jabesi sinore hesi övoho bamëhoromo sinoho avohëvamu marëjëvadeje. Ëhemu ëꞌadeje. ");
INSERT INTO aom_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Röhu hesi amo rajehu hu bogo ma uehorovarohuni ëhuni tiöjadeje. Ëhiꞌonugoromo vaꞌadeje. Vaꞌoromo amore amore jöho röjëhibe juvadeje. ");
INSERT INTO aom_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Röjëhibe juvoromo hesi ijoraje 12-ho uëvadeje: Ruehëromo rovamu uëvadeje: Naro jemë rëmöꞌöꞌiëꞌajëjo jemëro nasi jöho ae majëhibe jijihoꞌirarijego. Jemë ae niöꞌi niöꞌi ame göro göro vaꞌorëjo. Jemëhu mu vaeꞌirarijohuni nasi darugoho bojëmijajëjo ëhuro jemëro Satan-are a sisë gö gö a dëre jioꞌamëꞌoho rarovöꞌöꞌirarijego. ");
INSERT INTO aom_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Röhu vaꞌiëꞌiroho ma-guduodemu ujuohorëjo. Ioho esöho ijo bajoho bövioho biseꞌoho bogavëjo. ");
INSERT INTO aom_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","O höru guduoho ioꞌamoromo niöge ma-gemu gemu ioꞌamoꞌi nadi niöꞌi niöꞌioho ioꞌamorëjo. ");
INSERT INTO aom_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Ëhi uënugoromo uëvadeje: Amo göre göre vaꞌoromo aehu di osare raromojöro uëvamu vaꞌo raromëꞌoho ëhuremu raromonövorëjo ijonö ë amore jioromo vaꞌiëꞌe jëvaje. ");
INSERT INTO aom_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","O di amore ariböviehu jemesi örire nu huodëgoromo jö bogo ejëhëꞌoho amoho nugo vaꞌirögoro jabesi saꞌa hesi tohotohe jemesi höru hitahire jiajoho saꞌaro riremo vaꞌego ë amo rajohuro garomo uvoꞌirarëjo: No sisë ëꞌëꞌe javuajëjo. ");
INSERT INTO aom_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Ëhi majëhijamu hegorovo ijorajo ömoꞌömohuro vaꞌoromo jöe majëhibe jijihoromo uënövareje: Uehoro sisëho vuonugoꞌi uehoro mae baerëjo. ");
INSERT INTO aom_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Ëhi jiëꞌe jöho majëhibe Satan-are aribövi sisë ahoꞌobëhe jabesi dëre jëvajoho rarovöꞌöbe ose guomo guomoꞌe a jabesi sinore otehoromo sinoho avohëvobe ëhi jiëꞌe mu masijoho vaebe jijihareje. ");
INSERT INTO aom_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Ëhi jiëꞌe mu masijoho vaebe jijihamu saꞌa a böröme Herod-ro ë jöho hejadeje rabëni Iesuhu ëꞌaje jöho ae ahoꞌobëhe dinöꞌe dinöꞌe vaerovëꞌëro jiëꞌëro. A ioroꞌiorohuro uvoruomadeje: Ëaho John bapataeto vaenövade ahuro guomoromo riꞌöjëꞌe höjo. Ëhuꞌëro darugo böröme baeromo mu masijoho vaejaje höjo. ");
INSERT INTO aom_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","A ioroꞌiorohuro uvoruomadeje: Iesu hu mamiꞌe hijade ae Elijah-ro rovëꞌëro ëꞌajëjo. A ioroꞌiorohuro uvoruomadeje: Jö God-aro baeromo majëhinövare aribövi ioroꞌioro jiarëhi hu ëhi jiëꞌe aëro jiëꞌëro ëꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Ae göëro göëro Iesuare jöho gö gö atavamu hegoro Herod-ro ae uëvadeje: Ëaho hu John höjo. Urimo naro hesi sönöho tariojahode höjo röhu hu guomoromo riꞌöjëꞌëro hijajëjo. ");
INSERT INTO aom_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Röhu ë jö hesi bëhoho urimëꞌi Herod-ro hesi öe Philip-are vabore hesi ihoho Herodias gohoniahijadeje. Gohoniahijamu John-ro riꞌöromo uaꞌi hijadeje: Jasi vuojiri baejanoho ëho bogo maehu höjo. Ëhi uaꞌi hijamu Herod-ro ë magonaho hesi jöëni ae uëvamu John guduamoromo tövoromo savoji gagore baꞌamareje. ");
INSERT INTO aom_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Ëhiꞌamu ë magonahohuro John nue huodivoromo anoꞌi nimadeje. Ëhi nimoromo röhu Herod-ro magonahoho ahamu anoꞌiëꞌadoho vuonugadeje. ");
INSERT INTO aom_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Herod-hu magonaho ahade hesi bëhoho huro uvadeje: John hu a ma-mabëhe hö uvoromo ëhuni John juhuonamiromo avoho mueberomo magonahoho ahadeje. Magonahoho ahoromo vaꞌoromo henövadeje John-ro God-are jöe majahiꞌego. Jöe majahiꞌego Herod-ro nurunurumoꞌego hesi jöho heꞌi nimonövadeje. ");
INSERT INTO aom_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Ëhiꞌoromo John anojöëni magonahoho ahobe ruejuvo Herod rahade majaho rovamu evare magonahehu vaeꞌi nimade majaho rovadeje. Ëhesi bëhoho Herod-ro söröe baeromo hu ajamiromo ë saꞌa muebejarue aribövioho muorovo mu muebejarue aribövioho a masijo ioroꞌiore Galilee saꞌare raromaruoho ë a masijoho uëvadeje: Ruehego na söröe bojëmiꞌiröjo. Bojëmiꞌiröjamu rueruomadeje. ");
INSERT INTO aom_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Rueruomamu ë magonaho hesi abojohuro rueromo javavadeje. Javavamu gagorovo Herodꞌo hesi örire rueruomade ariböviohuꞌo ë magonahoho garomo vuëvorovoruomadeje. Vuëvorovoromo Herod-ro magonahoho uavadeje: Ja rabe rabe nimëꞌoho uevego bojamiꞌiröjo. ");
INSERT INTO aom_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Naehu muebejaje öri ariꞌo nimëꞌoho iae ëhuꞌo ririre tarioromo vituoho bojamiꞌejöjo. God-ro geꞌego na mae uavajëjo. ");
INSERT INTO aom_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Ëhi uavamu ë magonahohuro vaꞌoromo vëmoho uavadeje: Na rabe baeꞌejöjo. Rabe baeꞌejöjamu rue vëmohuro uavadeje: Uanëjo bapataeto vaejaje ae John-are sönöho tarioromo simanoho baro bojemëjo. ");
INSERT INTO aom_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Ëhi uavamu hejëꞌi rue abojohuro ma-burëro vuonoröꞌö rueromo a börömoho uavadeje: Na negajoho avevejöꞌe ae uëvego bapataeto vaejaje ae John-are sönöho tarioromo simanoho hevö döre bamoromo baro bojemarëjo. ");
INSERT INTO aom_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Ëhi uavamu hegorovo rue a börömohuro huë vavaene böröme baejadeje. Iae hu huë vavaene baejadeje röhu urimo darugoꞌe jöho ë aribövi jabesi nuniro ë magonahoho mae uavëꞌëro ëhuꞌëro huotorovoromo nijioꞌiraeröhoho hu bijönimadeje. ");
INSERT INTO aom_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Bijönimamu evare ae gemu ma-burëro nugöꞌöromo uavadeje: Vaꞌoromo John-are sönöho tarioromo simanoho baruenëjo. Baruenëjamu savoji gagore vaꞌoromo sönöho tarioromo simanoho ");
INSERT INTO aom_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","hevöre bamonugoromo barueromo abojoho bojamadeje. Bojamamu huro bavaꞌo vëmoho bojamadeje. ");
INSERT INTO aom_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Ëhiꞌamu John-are ijore ijore jijiharue ariböviohuro ë jöho heromo rueromo sinoho bavaꞌoromo munë gagore bamareje. ");
INSERT INTO aom_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Iesuare apostle ömoꞌömohuro mu masije vaebe jijihëꞌëro vuonoröꞌö rueromo Iesu uavareje: No muoho ëhi ëhi vaeromo jöho ëhi ëhi majëhiromo rovare höjo. Ëhi jiëꞌe jöho jabumëro Iesu majahi barëjareje. ");
INSERT INTO aom_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Majëhi barëjamu gagorovo ruehuro gavade ae ahoꞌobëhe rovëꞌi vaꞌëꞌi rovëꞌi vaꞌëꞌëro huꞌo hesi ariböviohuꞌo i ueꞌahoꞌiröhe o bövi biseꞌo vaeꞌiröhe majaho bogojiamu gagorovo uëvadeje: Ruehego no a rumoꞌe saꞌare nosi sivue vaꞌo raromoromo jemëro ëhuro ma-bisemu nuhorëjo. ");
INSERT INTO aom_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Ëhi uënugoromo jaburo boat-re ajio raromoromo a rumoꞌe saꞌare jabesi sivue vaꞌi vaꞌareje. ");
INSERT INTO aom_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Vaꞌi vaꞌamu ae ahoꞌobëhe gavare jabumë vaꞌamu iae mae gëromo uvoruomadeje: Ëaribövioho Iesumëro boat-re vaꞌaruë uvoromo amo göre göre jioromo saꞌa hörëro ma-burëro vaꞌoromo Iesuꞌo hesi ariböviohuꞌo boat-re vaꞌaruoho iosirëmiromo jaburo jovo ioni gönö urimo rueruomadeje. ");
INSERT INTO aom_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Urimo rovamu Iesuro ijonö ro höröromo ravoꞌamoromo gavade ae ahoꞌobëhe tagavëꞌe jiamu gëgorovo uehorovoromo uvadeje: Vaevëꞌëjo. Ëaribövioho vëmu vavuꞌo rumoꞌe ö mahuꞌëro raromanovaruë uvoromo jabesi jöëni vavaenimadeje. Jabesi jöëni vavaenimamu evare jöe ahoꞌobëhe röjëhijadeje. ");
INSERT INTO aom_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Jöe ahoꞌobëhe röjëhijuvo majae bevaꞌiaꞌamu gagorovo hesi ijorajo ömoꞌömohuro rueromo uavareje: Aveho a rumoꞌe saꞌae höjo. O majae mamiꞌe barëjëꞌe höjo. ");
INSERT INTO aom_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Ëhuni ave aribövioho rëmöꞌöjego ave bëhire amo masijore ininore vaꞌoromo ie imoꞌamoꞌirarëjo ueꞌahoröhe. ");
INSERT INTO aom_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Ueꞌahoröhe höjamu uëvadeje: Bogajo. Jemëro irunoꞌoho daꞌuojëhirëjo. Daꞌuojëhirëjamu uavareje: Asëꞌëjo. Dinöꞌe ioho baeromo daꞌuojëhijöro uvanuëjo. Na ja uvoromo ëꞌanuëjo: No 200 kina javuëꞌëro noro ëho bavaꞌoromo buꞌö barëromo ioho imoꞌamoromo ujuoho rueromo ëhuro daꞌuojëhiꞌejarë uvoromo o diehi uvoromo jövanuëjo. ");
INSERT INTO aom_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Jövanuëjamu uëvadeje: Ioho diminoꞌe jëvajëjo. Vaꞌoromo gahëjo. Vaꞌoromo gahëjamu vaꞌoromo adaho garomo vuonoröꞌö rueromo uavareje: No ie ahoꞌobëhe övo gö mine o visue niöꞌi ëhi javuajëjo. ");
INSERT INTO aom_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Ëhi uëvamu hegorovo ruehuro ae ahoꞌobëhe uëvadeje: Vaꞌoromo hahagu hahagu gagovoromo ëhi garasiohuro raromobe vaꞌohëjo. ");
INSERT INTO aom_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Vaꞌohëjamu rue ariböviohuro vaꞌoromo ë 50 50 o 100 100 hahagu hahagu gagovoromo ëhi garasi rövëꞌe mabëhire raromobe vaꞌareje. ");
INSERT INTO aom_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Raromobe vaꞌamu gagorovo ie övo gö mine visue niöꞌi ujuoho rovaroho ëho Iesuro ujuohoromo öꞌidöho sioroho garomo God huë mae uavadeje. Huë mae uanugoromo ioho atoꞌatovoromo hesi ijorajo ömoꞌömoho iꞌimëmijadeje ae ahoꞌobëhe suvuorëmijöro. Ëhiꞌoromo visue niöꞌi taritarivoromo iꞌimëmijadeje jaburo ëhuꞌo suvuorëmijöro. ");
INSERT INTO aom_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Ëhiꞌamu ae ahoꞌobëhe ë ioho visuoho ueꞌahamu daꞌuëgadeje. ");
INSERT INTO aom_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Daꞌuëgamu gagorovo ijorajoho jaburo i vitu vituoho visu vitu vituoho aegamu esöe ahoꞌobëhe 12 irijiomoꞌamadeje. ");
INSERT INTO aom_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Ëhiꞌareje. Iesuro ie övo gö mine visue niöꞌi ujuohoromo suvuorëmijamu amaꞌe ahoꞌobëhe 5,000 ë ioho ueꞌahoruomadeje. ");
INSERT INTO aom_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Ëhiꞌamu gavëꞌi Iesuro ijorajo ömoꞌömoho uëvadeje: Boat-oro ajio raromoromo eꞌu ioni gönö Bethsaida amoro urimo vaꞌohego na a ioroꞌioroho rëmöꞌöjöjo. ");
INSERT INTO aom_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Ëhi uëvamu hegorovo hesi ijorajoho jaburo boat-re iojiomoromo vaꞌoruomamu Iesuro parie vaeꞌi dahorunö ajiomadeje. ");
INSERT INTO aom_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Ajiomoromo parie vaejamu vahiromadeje. Vahiromamu nume ijorajoho jaburo öri ëgoböviro jovo döre vaꞌoruomoꞌi Iesuro ruhe saꞌare hesi sivue hijadeje. ");
INSERT INTO aom_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Hiꞌi gavadeje burëro jabesi nuninö rueꞌego ijorajoho jaburo jovoho sisëꞌi sisëꞌi huoꞌöbe vaꞌoruomamu. Ëhiꞌojuvo sisonuvoꞌiëꞌadeje. Sisonuvoꞌiaꞌamu Iesuro abueromo jovo döre hörëro vaꞌadeje. Vaꞌoromo jabumë iosirëmiꞌiëꞌadeje. ");
INSERT INTO aom_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","50","Iosirëmiꞌiaꞌamu ijorajoho jaburo gavareje hu jovo döre juvamu gagorovo uvareje: Aruꞌahëro juvajëromo jioduduꞌiraeromo jöꞌe dadovareje. Jöꞌe dadovamu hejëꞌi uëvadeje: Nadi juhuonivoꞌi biririvohëjo. Na jevajëjo. ");
INSERT INTO aom_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Na jevajë uënugoromo boat gagore ajiomoromo jabuꞌo gemu mae hijamu buroho barëjadeje. Buroho barëjamu ë aribövioho dadivëvadeje. ");
INSERT INTO aom_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Ëhesi bëhoho Iesuhu mamiꞌe i daꞌuojëhade hesi bëhoho bogo avoho baejareje jabesi uehoroho bogo eni jiëꞌëro. ");
INSERT INTO aom_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Ëhiꞌamu eꞌu ioni gönö rueromo Gennesaret saꞌare ravoꞌamoromo boat-oho ijo bunore be nugareje. ");
INSERT INTO aom_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Röhu ravoꞌamamu gavëꞌi evare ae ahoꞌobëhe Iesu garomo uvoruomadeje: Iae Iesu hö uvoromo ");
INSERT INTO aom_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","ë saꞌae börömoho ma-burëro jijihoromo aevoromo guomo guomoꞌe aribövioho giojimo ujuoho rueromo henövare uvavoꞌego: Iesu ë diröꞌore hijajëꞌego ë vaꞌonövareje. ");
INSERT INTO aom_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Iesuhu amo masijore ininore o dinöꞌe dinöꞌe rovëꞌiroho guomo guomoꞌe aribövioho giojimo ujuohoromo aehu gagovarue öri ariꞌere ë ro bahinövareje. Bahinugoromo Iesu ëninamiromo uanövareje: Guomo guomoꞌe aribövioho uëvego ja niögu vituohuremu rëhego ëhuro guomo guomoho barëꞌamajo. Ëhi uaꞌego ae rahu niögu rëhëꞌoho ëhuro marëꞌamonövadeje. ");
INSERT INTO aom_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Iae Pharisee ariböviohuro Jew rajo jögoru öri röjëhijarue ariböviohuro urimo Jerusalem jioromo rovëꞌëro jiëꞌëro Iesu jiajire ro gagovoruomadeje. ");
INSERT INTO aom_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Gagovoromo gavareje Iesuare ijorajo ömoꞌömohuro Pharisee rajo jabesi jögoroho ahoromo jovoho övoho bogo otehodivorovoromo sisëho uꞌovëꞌe ioho ma-ueꞌahamu. ");
INSERT INTO aom_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Ëhesi bëhoho Pharisee ariböviohuꞌo Jew rajo a ioroꞌiorohuꞌo ioho bogo ëma ueꞌaharueje. Aꞌi urimo Jew rajo a mamiehu jö bojëmibe rovarëhi ëhiꞌoromo jovëro övoho otehodivorovoromo uvoruomajeje: Nosi sinore sisëho uꞌovahuëꞌëro God-are nunire mae javuajëromo evare ioho ueꞌaharueje. ");
INSERT INTO aom_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","O i imoꞌamarue öri ariꞌere jioromo ujuoho rovëꞌiroho uvoruomajeje: Sisë höromo jovëro otehodivoromo uꞌoꞌamoromo uvoruomajeje: Avevejöꞌoho ë ioho iae mae uꞌovëꞌe höromo evare ueꞌaharueje. Ëhiꞌoromo a mami ariböviehu bojëmibe rovare jögoroho ahoꞌobëhe jabumëro ejëhoromo enatue ramae gö gö i ijarue röhe ëhi uꞌoꞌamoromo uvoruomajeje: Ëinömo inömo hesi sisëho uꞌo barëꞌego God nimorohajëjo. Ëhiꞌarueje. ");
INSERT INTO aom_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Ëhiꞌaruëro jiëꞌëro ë Pharisee ariböviohuꞌo Jew rajo jögoru öri röjëhijarue ariböviohuꞌo riꞌöromo Iesu uavareje: Jasi ijorajo ömoꞌömoho a mamiehu bojëmibe rovare jöho bogo eromo jovoho övoho bogo otehodivorovëꞌe ioho ma-ueꞌaharue höjo. Rabëni ëhioho ëꞌarue höjo. ");
INSERT INTO aom_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Ëhi uavamu hegorovo Iesuro uëvadeje: Sareri sareriꞌe aribövie jëvajëjo. Jö God-aro baeromo majëhijade ae Isaiah-ro jemëhu ëꞌirarije jöho jajivoromo ëhi uvëꞌe höjo: Ave ariböviohuro ma-jöꞌëremu God na rajehiꞌi dë vövöbajoꞌoho bogo nasi gemuoroho jioꞌi ma-roriꞌo jioruomajëjo. ");
INSERT INTO aom_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Jabumë a jabesi jögoroho ae röjëhiromo uëruomaje höjo: Ëho God-are jöe jiaje ejahuorëjo. Ma-a jabesi jögoroho ëhi röjëhiromo ëhuro ma-döhemu God na rajehiruomaje höjo. Ëjemesi jö Isaiah-hu jajivadoho iae mae höjo. ");
INSERT INTO aom_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","God-hu bojëmade jögoroho jemëro vuonugoꞌi aehu bojëmibe rovare jögorohemu maꞌenaruje höjo. ");
INSERT INTO aom_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Ëhi uënugoromo uëvadeje: Sareriꞌe uehoroho baeromo ëhuro God-hu bojëmade jöho aharuje höjo jemëhu a bojëmijaruje jögoroho maꞌenoꞌirarijëro. ");
INSERT INTO aom_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Ëhesi bëhoho Moses-ro uëvade höjo: Jasi vëmu vavuꞌoho mae uehorovëvonëjo. O jöe göꞌo uëvade höjo: Ae rahu jö sisë jövoromo vëmu o vavu hesi iho ijumahëꞌoho anego guomoꞌirajo. ");
INSERT INTO aom_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Röhu jemëro ë jöho ahoromo ae röjëhiromo uëvaruje höjo: Jaehu jasi vëmu vavuꞌo God-are nunire uëvëꞌoho: Nasi maho sisëho ujuohoromo ajëmiꞌibejodoho röhu aveho na God-are ihoro bamëꞌe jevajë uëvëꞌoho ");
INSERT INTO aom_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","nadi röhu maho huotorovoromo jasi vëmu vavuꞌoho ajëminëjo. Ajëmijëꞌoho sisë höjo. Ëhi uëvaruje höjo. ");
INSERT INTO aom_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Vëmu vavuꞌo ajëmijëꞌoho sisë hö uëvarujohuro ëhuro vëmu vavuꞌo mae uehorovëvoꞌirarijego God-hu bojëmade jöho jemëro aharuje höjo jemesi a mami jöho eꞌirovo. Ëhi jiëꞌe mu sisëho ahoꞌobëhe röjëhijaruje höjo. ");
INSERT INTO aom_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Iesuro ëhi uënugoromo ae ahoꞌobëhe röhu maho uëvadeje: Ro gemuoro gagovohëromo ro gagovamu uëvadeje: Naehu ave uhu jö uëꞌiëꞌajoho jemë ae ahoꞌobëhe avoho heromo bëhoho baerëjo. ");
INSERT INTO aom_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Rabe roriꞌo jiajehu jöꞌore vaꞌëꞌoho bogo ëhuro aho sisërëꞌamoꞌi aꞌi rabe dë vövöbajoꞌere jioromo suorovëꞌohuro ëhuro aho sisërëꞌamaje höjo. ");
INSERT INTO aom_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Ae rahu ja God-are jö hejanue ae javëꞌoho bëhoho nahoromo birohonëjo. ");
INSERT INTO aom_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Ëhi majëhinugoromo Iesuro ae ahoꞌobëhe rëmoꞌi osare vaꞌadeje. Osare vaꞌamu hesi ijorajoho jaburo uavareje: Uhu jö majahuijane hesi bëhoho huruohego no hejarëjo. ");
INSERT INTO aom_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Hejarëjamu Iesuro uëvadeje: Ëhi jiëꞌoho na jemëꞌo uehoroho bogojëvajëjo. Jemë rabëni bogo garomo uvarujëjo: Rabe roriꞌo jiajehu jöꞌore vaꞌëꞌoho bogo ëhuro aho sisërëꞌamaje höjo. ");
INSERT INTO aom_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Ëhesi bëhoho rabe jöꞌore vaꞌëꞌoho vövöbajoꞌeroho bogo abueꞌi dëre abuejaje höjo. Dëre abueromo dëre jioromo suorovoromo bogo aho ijumëvëꞌe ma-gua gagore vaꞌaje höjo. Ëhuꞌëro aho God-are nuniroho bogo sisërëꞌamaje höjo. Iesuhu ëhi jövadoho huro uöromo ëꞌadeje: Jaruvoho ie ahoꞌo ma-ueꞌahëꞌoho God-ro uvaje höjo: Iae mae höjo. ");
INSERT INTO aom_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Röhu Iesuro hesi jö vituoho majëhiromo uëvadeje: I ueꞌahëꞌohuro bogo ëhuro aho sisërëꞌamoꞌi aꞌi dë vövöbajoꞌere jioromo rojomoromo suorovëꞌohuro ëhuro aho God-are nuniroho sisërëꞌamaje höjo. ");
INSERT INTO aom_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Uehoro sisëhuro dë vövöbajoꞌere jioromo rojomego ëhuro öëro jijihanovoruomaje höjo. Vajiohëro ujuohoruomaje höjo. Ae muoꞌamoruomaje höjo. ");
INSERT INTO aom_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","Gohoꞌamoruomaje höjo. A jabesiroho ujuohoniëhiꞌi ganiganimoruomaje höjo. Mu sisë rabe rabe vaeruomaje höjo. Ae gö sarerëmiruomaje höjo. A nunire javojiꞌe muoho vaeruomaje höjo. A jabesi mu mahuni dë vörönëgaje höjo. A jabesi ihoho ijumoruomaje höjo. Sivue uehorovoromo jabesi ihoho döro bamoruomaje höjo. Simane sisëꞌi uehorovoruomaje höjo. ");
INSERT INTO aom_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Ëhi jiëꞌe uehoro sisë ahoꞌobëhe dë vövöbajoꞌere jioromo rojomoromo suorovajohuro ëhuro aho God-are nunire sisërëꞌamaje höjo. ");
INSERT INTO aom_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Ëhiꞌonugoromo Iesuro riꞌöromo ë Jew rajo jabesi saꞌaho vuonugoꞌi vaꞌadoho vaꞌo saꞌa göre Tyre amo Sidon amo jiajinö saꞌare ë rovadeje. Ruenugoromo osare vaꞌoromo uëvadeje: Naehu ave rovodoho nadi huruohorëjo. Ëhi uëvadeje röhu hesi ihoho ë saꞌaroho börömëro jiëꞌëro hu rovadoho bogo a subivëho varijënoho jiadeje. ");
INSERT INTO aom_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Ëhuꞌëro jiëꞌëro magonahe gemuëro ma-burëro hejadeje uvavamu: Iesu rovëꞌe höjo. Ëmagonahoho aboje gemu biseꞌe jiadeje. Satan-are a sisëro ë aboji hesi dëre abueromo simanoho huotovahëꞌe jiadeje. Hesi abojoho ëhi jiëꞌëro ë magonahohuro hejade uvavamu: Iesu rovëꞌe hö uvavamu hegorovo rueromo Iesuare höru bëhire ague aho hijadeje. ");
INSERT INTO aom_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Röhu ë magonahoho hu bogo Jew rajo magonahehu jioromo bogo Jew rajo jöehu jövaje magonahehu jioꞌi aꞌi hesi saꞌa börömoho Syria jioꞌi hesi saꞌa biseꞌoho Phoenicia jiadeje. Hu bogo Jew rajoho jiëꞌe Iesu ëninamiromo uavadeje: Ajemiromo a sisë nasi aboji hesirire jiajoho rarovöꞌöjego vaꞌirajo. ");
INSERT INTO aom_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Rarovöꞌöjego vaꞌirajamu Iesuro uehorovoromo uvadeje: Vëmu vavuꞌehu jabesi aboji harihuꞌo urimo ajëmijaruëhi naro nasi saꞌa rajohemu ëhi urimo ajëmiꞌi rovode höjo. Ëhi uvoromo ë saꞌa gö rajo magonahoho uhuꞌe uavadeje: O-ajo. Nadiꞌego urimo aboji harihuꞌoho ie daꞌuojëhiꞌiröjo. Ëhesi bëhoho noehu aboji harihuꞌo jabesi i ujuohoromo ö harihu mioꞌamëꞌoho ëho bogo maehu höjo. ");
INSERT INTO aom_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Bogo maehu höjamu hegorovo rue magonahohuro uehorovoromo uvadeje: Iae na bisemu ioniro saꞌa gö raje jevoꞌego ëhuni bogo ajemiꞌi jöho jövajëjo. Röhu noehu bogo rarovego öehu i ugobajoꞌo ueꞌaharuëhi nani Iesuro naꞌo ëhi ejehoromo nasi abojoho ajamiꞌajëjo. Ëhi uvoromo mana uhuꞌe uavadeje: Bada iae mae-ëjo röhu i maratu aharire raromarue öho jabumëro aboji harihuꞌo jabesi i ugobajoꞌoho iae ueꞌaharue höjo. ");
INSERT INTO aom_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Ueꞌaharue höjamu Iesuro uavadeje: Iae mae uevanuëjo. Ëhuni vaꞌonëjo. A sisëho jasi aboji hesi dëre jioromo iae mamiꞌe höröromo vaꞌëꞌe höjo. ");
INSERT INTO aom_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Ëhi uëvamu hegorovo rue magonahohuro vuonoröꞌöromo hesi osare vaꞌoromo gavadeje a sisëho mamiꞌe hörö vaꞌi abojoho röhore raromamu. ");
INSERT INTO aom_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Ëhiꞌamu Iesuro Tyre amonö jioromo vaꞌoromo Sidon amonö rovaꞌadoho vaꞌo saꞌa ihe Ame 10 Jioꞌamaje Saꞌare ë vaꞌoromo nume Galilee eꞌure ruvebijadeje. ");
INSERT INTO aom_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Ruvebijamu gagorovo aëro ae gemu huꞌirae baeromo rovareje. Ëa hesi hiaꞌoho tugohëꞌe o jöho aꞌoꞌaꞌohëꞌe jövëꞌe ae jiadeje. Ëaho huꞌirae baeromo rueromo Iesu ëninamiromo uavareje: Jasi övoho hesi sinoro bamego hu mae jiajo. ");
INSERT INTO aom_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Ëhi uavamu Iesuro huꞌirae baeromo ae ahoꞌobëhe riravaruire jioromo vaꞌoromo jabesi sivue rirarovoromo hesi övo namoho niöꞌi ë a hesi hiaꞌi gagore rëmöꞌöjadeje. Rëmöꞌöromo jijönugoromo sabëro öromo ë a hesi bitaroho rëhahadeje. ");
INSERT INTO aom_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Bitaroho rëhahonugoromo öꞌidöho sioroho garomo ë ahuni haraꞌuoromo hesi jöëro uavadeje: Epatajo. Ëhesi bëhoho huotovëꞌoho: Hiaꞌe dadovoꞌamëjo. ");
INSERT INTO aom_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Ëhi uavamu gavëꞌi ë a hesi hiaꞌoho dadovahoꞌi bitaroho marëromo jöho avoho jövadeje. ");
INSERT INTO aom_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Jöho avoho jövamu Iesuro ae ahoꞌobëhe uëvadeje: Naehu mu vaejodoho nadi aho majëhirëjo. Iesuhu nijioꞌiraejëvoꞌi hijadoho bogo ejahoruomoꞌi ae ëma majëhibe vaꞌareje. ");
INSERT INTO aom_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Röhu ae ahoꞌobëhe Iesuare muoho garomo tiöruomadeje. Tiöromo uvoruomadeje: Mue bövie biseꞌe ma-mabëhe vaejëꞌe höjo. Mu masije gö gö vaeromo röhu hiaꞌi tugohëꞌe bitaro tövëꞌe aribövioho jabuꞌo avohëvego marëꞌamoromo jöe heromo jöe atarue höjo. ");
INSERT INTO aom_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Ëhiꞌamu ae ahoꞌobëhe röhu maho gagovëꞌëro ie bogojëvadeje. Ie bogojëvamu gagorovo Iesuro hesi ijorajo ömoꞌömoho uëvadeje: Ruehë uëromo rovamu uëvadeje: ");
INSERT INTO aom_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","Ave ariböviohuni vavaenegajëjo. Jabumë naꞌo raromobe rovaroho majae niöꞌi gemu barëjëꞌëro ëhuꞌëro i ueꞌahoꞌiröhoho bogohöjo. ");
INSERT INTO aom_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Naehu ma-dë gagëremu rëmöꞌöjamu jabesirëro vaꞌëꞌoho nune öriꞌamobe vaꞌoruomoꞌajëjo jabumë ae gö gö öre ëgoro rueruomëꞌëro jiëꞌëro. ");
INSERT INTO aom_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Ëhi uëvamu rue ijorajoho jaburo uavareje: Röhu diehiꞌoromo ë aribövioho ioho daꞌuojëhiꞌejarëjo. Aveho a rumoꞌe saꞌae höjo. ");
INSERT INTO aom_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","A rumoꞌe saꞌae höjamu uëvadeje: Ioho diminoꞌe jëvajëjo. Diminoꞌe jëvajëjamu uavareje: Ie övo gö mine övo göre niöꞌi javuajëjo. ");
INSERT INTO aom_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Ëhi uavamu hegorovo Iesuro ae ahoꞌobëhe uëvadeje: Saꞌaro raromohëjo. Raromohëromo ie övo gö mine övo göre niöꞌi ujuoho rovaroho ëho Iesuro ujuohoromo God huë mae uaromo atoꞌatovoromo hesi ijorajo ömoꞌömoho iꞌimëmijadeje jaburo suvuorëmijöro. Iꞌimëmamu ujuohoromo ae ahoꞌobëhe suvuorëmijareje. ");
INSERT INTO aom_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Ëhiꞌoꞌi visu inine ma-gemu gemu Iesuare ijorajo jabesirire jiadeje. Jëvamu Iesuro ujuohoromo God huë mae uanugoromo hesi aribövioho uëvadeje: Ave visuohuꞌo suvuorëmibe vaꞌohëjo. ");
INSERT INTO aom_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Ëhi ëꞌëꞌëro ae ahoꞌobëhe ë ioho ueꞌahamu daꞌuëgadeje. Daꞌuëgamu gagorovo ijorajoho jaburo i vitu vituoho gagovoromo esöe övo gö mine övo göre niöꞌi aegamu irijiomoꞌamadeje. Ëhiꞌareje. ");
INSERT INTO aom_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Röhu ë i visu ueꞌahare aribövioho ahoꞌobëhe 4,000 rabuꞌe jiadeje. Ueꞌahoromo Iesuro rëmöꞌöjamu vaꞌoruomadeje. ");
INSERT INTO aom_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Vaꞌamu gavëꞌi Iesuro hesi ijorajo ömoꞌömohuꞌo gemu mae boat-re ajiomoromo Dalmanutha saꞌare vaꞌadeje. ");
INSERT INTO aom_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Ëhiꞌamu iae Pharisee ariböviohuro rueromo Iesu jö ahoꞌahamijareje. Jö ahoꞌahamiromo Iesu bijioho gaꞌi nimareje gaꞌi hu guaro bevaꞌego. Ëhi nimoromo Iesu uavareje: God-are darugoho baeromo bogo gavarue muoho röjahuijego no gavarëjo huro ja ajamego muoho vaejanue javego o bogo. ");
INSERT INTO aom_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Ëhi uëvamu hegorovo dë vövöbajoꞌo uhure sisë maro vavaenimoromo haraꞌuoromo uëvadeje: Ave jaruvore raromaruje aribövioho jemë rabëni bogo gavarue muoho gaꞌi nimarujëjo. Na God-are ae jevego gaꞌi nadi ëhioho uehëjo. Ave jöho na jö mae majëhiꞌiëꞌajëjo. Ave jaruvore raromaruje aribövioho ëhi jiëꞌe darugoꞌe muoho bogo mae bogo gaꞌaꞌarujëjo. ");
INSERT INTO aom_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Ëhi uënugoromo rëmöꞌöꞌi Iesumëro vaꞌoromo boat-re iojiomoromo jovo eꞌu ioni gönö vaꞌi vaꞌareje. ");
INSERT INTO aom_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Vaꞌoromo hesi ijorajoho jaburo rumonëgamu irunoꞌoho bogo göꞌoho ujuohëꞌe jiareje. Ioho ma-bisemu urimo jiadohemu ëhuremu boat-re jëvadeje. ");
INSERT INTO aom_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Ie ma-bisemu jëvamu Iesuro uhuꞌe uëvadeje: Jemëro gavëꞌiajo. Pharisee aribövi jabesi o Herod-are i dë huoꞌamaje osohuro jemesirire rumorovoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Rumorovoꞌajëjamu rueho jaburo ë jöho mevoromo uarovareje: No ie bogojavuoꞌego ëhuni jövajëjo. ");
INSERT INTO aom_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Ëhi uarovamu Iesuro gëromo uvadeje: Jabumë ë jöho ataruëromo uëvadeje: Jemë rabëni i bogojavuaje jöho atarujëjo. Jemë rabëni avevejöꞌohuꞌo bogo gavarujëjo. O rabëni bogo uehorovarujëjo. Na mu ma hesi uehoroho bogojëvëꞌëro ëhuꞌëro bogo gavarujëjo. ");
INSERT INTO aom_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Jemë nuniꞌe hiaꞌiꞌe jëvajëjo. Röhu rabëni bogo garomo bogo hejarujëjo. Jemë rabëni ave jö hesi bëhoho bogo uehorovarujëjo. ");
INSERT INTO aom_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Naehu ie övo gö mine ujuohoromo atoꞌatovoromo ae ahoꞌobëhe 5,000 iꞌimëmodoho jemë ë i vitu vituoho aegamu esöe diminoꞌe irijiomoꞌamade höjo. Uëvareje: Esöe ahoꞌobëhe 12 irijiomoꞌamade höjo. ");
INSERT INTO aom_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Ëhi uavamu uëvadeje: O naehu ie övo gö mine övo göre niöꞌi atoꞌatovoromo ae ahoꞌobëhe 4,000 iꞌimëmodoho jemë ë i vitu vituoho aegamu esöe diminoꞌe irijiomoꞌamade höjo. Uavareje: Esöe ahoꞌobëhe övo gö mine övo göre niöꞌi ëhi irijiomoꞌamade höjo. ");
INSERT INTO aom_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Irijiomoꞌamade höjamu uëvadeje: Urimo nasi mu bëhi bogo gavarijoho jaruvohuꞌo jemë rabëni bogo avoho gevaruje höjo na diehi jiëꞌe ae jevajoho. ");
INSERT INTO aom_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Ëhiꞌonugoromo Iesuꞌo hesi ijorajo ömoꞌömohuꞌo ëho jaburo Bethsaida amore rovareje. Rovamu aëro nuni sisëꞌe ae gemu huꞌirae baeromo rovareje. Barueromo Iesu ëninamiromo uavareje: Ave iaho rëhego nunoho marëjajo. ");
INSERT INTO aom_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Marëjajamu Iesuro nuni sisëꞌe a hesi övore maꞌenoromo amore jioromo huꞌirae baeromo vaꞌadeje. Huꞌirae baeromo vaꞌoromo ë a hesi nunoho sabëro ödivoromo övoho nunire bamëvoromo uavadeje: Na ja uherihoromo bövioho biseꞌoho gavanuëjo. ");
INSERT INTO aom_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Gavanuëjamu ruehuro nigerohoromo garomo uavadeje: Na sisëꞌi gavajëjo ae jijihoꞌi röhu jabesi nu anoꞌoho ijo vaꞌëne jioꞌamoꞌego. ");
INSERT INTO aom_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Ëhi uëvamu ruehuro övoho nunire röhu maho bamëvadeje. Bamëvamu röhu maho uherihoromo avoho garomo bövie biseꞌe ahoꞌo ma-mae gaꞌamadeje. ");
INSERT INTO aom_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Ma-mae gaꞌamamu uavadeje: Nadi arue amoho vuonoröꞌö vaꞌi o öre gö öre göho vaꞌi ma-ahorirëro jasi osaëro vaꞌëjo. ");
INSERT INTO aom_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Ëhi ëꞌëꞌëro Iesuꞌo hesi ijorajo ömoꞌömohuꞌo vaꞌareje. Vaꞌoromo Caesarea Philippi amo börömo jiajinö amore amore suorovoꞌi iojiomareje. Örire iojiomëꞌi Iesuro uëvadeje: Na rahuo jevaje jöho ae ahoꞌobëhe diehi atoruomaje höjo. ");
INSERT INTO aom_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Diehi atoruomaje höjamu uavareje: A ioroꞌiorohuro uvoruomaje höjo: Ja John bapataeto vaejavuonövane ahuro rovëꞌe javajëjo. A ioroꞌiorohuro uvoruomaje höjo: Ja Elijah-ro rovëꞌe javajëjo. A ioroꞌiorohuro uvoruomaje höjo: Mami göꞌe jö God-aro baeromo majëhinövarijohuro röhu jero gemuëro rovëꞌe javajëjo. ");
INSERT INTO aom_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Ëhi uavamu hegorovo Iesuro uëvadeje: Röhu jemë nasi jöho diehi ataruje höjo. Diehi ataruje höjamu Peter-ro riꞌöromo uavadeje: Ja böröme namiromo ajamuijanue aho javajëjo. ");
INSERT INTO aom_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Javajëjamu uëvadeje: Ëjöho nadi aho huruoho majëhirëjo. ");
INSERT INTO aom_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Ëhiꞌonugoromo Iesuro aevoromo hesi ijorajo ömoꞌömoho röjëhiromo uëvadeje: God-ro ëhi bamëꞌëro ëhuꞌëro hesi A Maho naro viꞌehe huë vavaene bövie biseꞌe baeꞌejöjo. Jew rajo a duvaho ömoꞌömoho priest masijoho jögoru öri röjëhijarue aribövioho ëho jaburo na bijönegoruomoꞌajëjo. Bijönegoruomoꞌiramu aëro anegoꞌiramu guomevoꞌajëjo. Guomoromo majae niöꞌi gemu hesi uhure iꞌovoromo riꞌöꞌejöjo. ");
INSERT INTO aom_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Ëjöho Iesuro bogo subivëhoꞌi ma-samaꞌe röjëhijadeje. Röjëhijamu Peter-ro Iesu roriꞌo huꞌirae bavaꞌoromo uavadeje: Ëhi jiëꞌe jöho nadi jövëjo. ");
INSERT INTO aom_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Nadi jövëjamu Iesuro huotorovoromo hesi ijorajo ömoꞌömoho gëromo Peter uavadeje: Satan roriꞌo vaꞌëjo. God-hu uehorovajëhioho ja bogo ëhioho uehorovoꞌi ma-aehu uehorovaruëhi jero ëhi uehorovoromo ëhuni ë jöho jövanuëjo. ");
INSERT INTO aom_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Ëhi uënugoromo Iesuro hesi ijorajo ömoꞌömohuꞌo a ioroꞌioroho ahoꞌobëhe ëhuꞌo uëvadeje: Ruehë uëromo rovamu uëvadeje: Ae rahuaro nasi ijore ijore jijihoꞌi nimëꞌoho jasi sinehu nimajoho nadi uehorovoꞌi uvonëjo: Iesuare jöëni viꞌehe huë vavaene javoje rabe baeromo guomevëꞌoho iae hesi hö uvoromo korosi hesi iꞌuoho banigojiomanovoromo nasi ijoro ijoro juvonövonëjo. ");
INSERT INTO aom_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Ja jasi sinohuni uehorovoromo biririvoromo ave saꞌare hiꞌi ëhemu uehorovëꞌoho ijonöho guomo öriro vaꞌaꞌanuëjo. O ja nasi jöëni o nasi jö ma hesi jöëni guomëꞌoho ijonöho maro hiꞌaꞌanuëjo. ");
INSERT INTO aom_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Jaehu are jove saꞌae mae sisë ahoꞌobëhe bae barëꞌi röhu jasi arijoꞌarije ijumorovëꞌoho na ja ëhuro mae javoꞌajëjo. Bogajo. ");
INSERT INTO aom_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Arijoꞌarije ijumorovëꞌoho diehi röhu maho avohorovoꞌiramu mae javoꞌajëjo. Öre bogohöjo. ");
INSERT INTO aom_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Ëhesi bëhoho ave jaruvore raromarue aribövioho sisë ariböviëro jioruomëꞌëro bogo God gemu uehorovoꞌi mue gö gö uehorovoruomaje höjo. Jabumë ae rahu nasi jöëni o naehu majëhijaje jö hesi jöhuni javojëgëꞌoho uꞌemu God-are A Maho naro maemu jiëꞌe anera ömoꞌömohuꞌo nasi Vavu hesi ajohuꞌo rueꞌiramu evare nani javojimoruomade ariböviohuni javojegoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Ëhi uënugoromo uëvadeje: Ave jöho na jö mae uëꞌiëꞌajëjo. Jemë a ioroꞌiore ave riravarujoho bogo vuovëꞌe raromoromo gaꞌaꞌarujëjo God-hu böröme namiromo hesi darugehu muebejaje ajoho rueꞌiramu. ");
INSERT INTO aom_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Ëhiꞌoromo majae ahoꞌobëhe övo gö mine övo göre gemu barëjamu Iesuro Peter James John ëhi söromo dahoru ëgobövire ajiomoromo jabesi sivue hahagu raromareje. Raromoromo ë ijorajoho jaburo gavareje Iesuare sino hahoꞌe gorosovoromo ");
INSERT INTO aom_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","niögoho ajivo avohamu. Saꞌare raromarue aribövioho noro niöge uꞌoꞌibejo bogo ëhioho ajivoꞌibejo. Iesuare niögohuro ëhi ajivamu gavareje. ");
INSERT INTO aom_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Ëhi gaꞌi gavareje a mami ae niöꞌi Elijahꞌo Mosesꞌo ëma jëvoromo jabuꞌo Iesuꞌo jöe atoruomamu. ");
INSERT INTO aom_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Jöe atamu gëgorovo Peter-ro Iesu uavadeje: Tisa no ave raromaruoho iae mae höjo. Uövuego no javu harihe niöꞌi gemu vaeꞌamarëjo jani gemu Moses-ni gemu Elijah-ni gemu. ");
INSERT INTO aom_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Peter-hu ëhi uavade hesi bëhoho Peter James John ëho jaburo sisë maro juhuonirovëꞌëro jö ma diehi jövoꞌiröhoho Peter dadivamu ëhuni ëhi jövadeje. ");
INSERT INTO aom_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Ëhi jövoromo Iesuare ijorajoho jaburo gavare suehuro Iesumë aegëhamu gagorovo hejareje sue uhure uvavamu: Ave aho nasi Harihu mabëhe höjo. Huhu jövaje jöho avoho herëjo. ");
INSERT INTO aom_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Ëhi uvamu hejëꞌi Iesuare ijorajoho jaburo ruaroho numiaroho uherihoꞌi gavareje Mosesꞌo Elijahꞌo bogojëvoꞌi Iesuro gemuëro ë jabesi bëhire namijamu. ");
INSERT INTO aom_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Ëhiꞌoromo dahorure ruvebijëꞌi Iesuro uëvadeje: Jemëhu gavarijoho nadi aho huruoho majëhirëjo. Uꞌemu God-are A Maho naro guomoromo riꞌöjego evaro majëhirëjo. ");
INSERT INTO aom_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Ëhi uëvamu rue ijorajoho jaburo iae ejahoromo Iesu gorosovamu gavare jöho subivëhobe vaꞌareje. Röhu jabesi sivue atoromo uarovareje: Guomoromo riꞌöꞌiröhëro uövuaje jö hesi bëhoho rabe höjo. ");
INSERT INTO aom_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Ëhi uarovoromo jabumëro Iesu uavareje: Jew rajo nosi jögoru öri röjahuijarue ariböviohuro uövuarue höjo: God-are a börömoho bogo ëma rueꞌi hu rueꞌiëꞌiroho a mami ae Elijah God-arire vaꞌadohuro vuonoröꞌö rueꞌaꞌajëjo. Rueꞌiramu God-are a börömoho ijore rueꞌaꞌajëjo. Jögoru öri röjahuijarue aribövioho rabëni ë jöho majahuijarue höjo. ");
INSERT INTO aom_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Rabëni majahuijarue höjamu Iesuro uëvadeje: Ioꞌajo. Elijah-hu urimo rueromo bövi biseꞌo avohoꞌamoꞌiröhe jöho iae mae-ëjo. Röhu ave jöhuꞌo God-are surire jajivoromo uvëꞌe höjo: Aëro God-are A Maho nörö nue huodivoromo sisë vaeꞌiramu viꞌehe huë vavaene bövie biseꞌe baeꞌaꞌajëjo. Ëhi jajivëꞌe höjo. Ëjöho bogo ëma jajivoꞌi iae mae jajivare höjo. ");
INSERT INTO aom_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Röhu naro ave jöho jemë uhuꞌe uëꞌiëꞌajëjo. Hehëjo. Elijah iae mamiꞌe öre avohoꞌi rovade höjo. Rovamu jaburo diehi nimarëhi ëhi hesi örire sisë vaeruomade höjo. Ëhi ëꞌiröhe jöhuꞌo God-are surire jajivëꞌe höjo. ");
INSERT INTO aom_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Ëhi uënugoromo Iesu Peter James John ëho jaburo dahorure ruvebijareje. Ruvebiromo Iesuare ijorajo ioroꞌioro jabesirire rueꞌi gavareje ae ahoꞌobëhe jabesi bëhire gagovoromo riravo rovaꞌo rojomoꞌi Jew rajo jögoru öri röjëhijarue ariböviohuro Iesuare aribövi jabesi jöho ahoꞌahëmijamu. ");
INSERT INTO aom_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Ëhi jiëꞌëro ae ahoꞌobëhe gavare Iesu rovamu gagorovo tiöjëvadeje. Tiöjëvamu Iesu ma-burëro birohoromo jejamiruomadeje. ");
INSERT INTO aom_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Jejamijamu Iesuro uëvadeje: Jemë rabu jöe nasi ariböviohuꞌoho atarujëjo. ");
INSERT INTO aom_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Atarujëjamu ae gemuëro uavadeje: Tisa na nasi harihoho jasi örire barovode höjo. Ëhesi bëhoho Satan-are ae gemuëro hesi dëre abo hiromo hesi bitaroho tövahëꞌe höjo. Ëhi jiëꞌe aruꞌahoho hesirire höjo. ");
INSERT INTO aom_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Hesirire jiëꞌëro nasi harihu hesi simano huotovahëꞌiroho ijumahego jueꞌi saꞌare behumorovaje höjo. Behumorovoromo jöꞌonö obohu tatogoꞌe rueromo ane vuogigimoromo biririꞌövaje höjo. Ëhiꞌajego naro jasi ijorajo ömoꞌömoho uëvode höjo: Aruꞌaho sisëho rarovöꞌöhego vaꞌajo. Ëhi uëvamu rarovöꞌöꞌi ëꞌo gavaroho bogo eni jëvade höjo. ");
INSERT INTO aom_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Bogo eni jëvade höjamu Iesuro uëvadeje: Asëꞌe ave jaruvore raromaruje aribövioho jemë bogo ma uehorovaruje aribövie jëvajëjo. Na majae diminoꞌe jemëꞌoho hibe vaꞌejöjo. Majae diminoꞌe jemesi mu sisëho garomo ma-nunëro ga taemobe vaꞌejöjo. Jemesi uehoro sisëhuro na uꞌuvevajëjo. Ëaharihoho barovego na gavöjo. ");
INSERT INTO aom_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Na gavöjamu rueho jaburo aharihoho huꞌirae rovareje. Rovamu uhure a sisëhuro Iesu garomo ma-burëro dë vövöbajoꞌoho ijumahamu simane sisërëromo bijöbijövoromo övoꞌo höruꞌo ajiomoromo saꞌare behumorovoromo jöꞌonö obohu tatogoꞌe rueromo ubiriꞌubirivadeje. ");
INSERT INTO aom_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Ubiriꞌubirivamu gagorovo Iesuro vavuoho uavadeje: Divare aevoromo simanoho sisërëbe rovade höjo. Sisërëbe rovade höjamu uavadeje: Asisöꞌo jiadevare evare aevoromo ëhi jiobe rovade höjo. ");
INSERT INTO aom_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Röhu uhure a sisëhuro majae ahoꞌobëhe ijumo avohoꞌi nimego simane huotovahego vënire jovore ëma ravorovaje höjo. Röhu ja eni javëꞌoho nosi jöëni vavaenimoromo ajamuijëjo. O bogo eni javego ëhuro vuonugëjo. Vuonugëjamu Iesuro uavadeje: ");
INSERT INTO aom_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Ja rabëni uvanuëjo: Nani nörö bogo eni höjo. Ae rahu God mae uehorovëꞌoho God-hu ëhi jiëꞌe ariböviohuni bövi biseꞌo vaeꞌiröhoho eni höjo. ");
INSERT INTO aom_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Eni höjamu rue vavuohuro ma-darugoꞌo uvadeje: Iae na ma-bisemu mae uehorovajëjo. Ajemego na mae uehorovo avohöjo. ");
INSERT INTO aom_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Ëhi uavamu heromo Iesuro gavade rue ariböviohuro ahoꞌobëhe tutubijiohoromo ruë numë hu babaꞌamoꞌi rueruomamu gëgorovo uhure a sisëho birevoromo uavadeje: Aruꞌaho sisë a jabesirire abueromo bitaro tövëhoromo hiaꞌi tugohëhanuoho naro ja uavajëjo: Höröromo vaꞌëjo. Ijoho bogave gemu vuonoröꞌö abueꞌiranëjo. ");
INSERT INTO aom_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Ëhi uavamu hegorovo rue uhure a sisëhuro jöꞌe dadovoromo aharihu hesi simanoho huotovahamu bijöbijövoromo sisë maro övoꞌo höruꞌo ajiomadeje. Sisë maro övoꞌo höruꞌo ajiomamu uhure a sisëhuro höröromo vaꞌamu aharihoho guomo barëjëꞌe sinoho vaꞌëne raromadeje. Ëhi raromamu ae ahoꞌobëhe uvoruomadeje: Ëiaho mamiꞌe guomëꞌe höjo. ");
INSERT INTO aom_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Guomëꞌe höjamu Iesuro aharihoho övore maꞌenoromo nigemamu riꞌöjadeje. ");
INSERT INTO aom_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Ëhiꞌamu Iesuro vaꞌo osare hijamu hesi ijorajoho jaburemu huꞌo raromoromo uavareje: Diehiꞌoromo noehu aruꞌaho sisë rarovöꞌöjaroho bogo eni javuade höjo. ");
INSERT INTO aom_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Bogo eni javuade höjamu Iesuro uëvadeje: Ëaharihu hesi dëre jiade ëhi jiëꞌe a sisë ae gö hesi dëre jiajoho rarovöꞌöꞌiëꞌiroho God-are örire ëninamijëꞌohuro ëhuro rarovöꞌöꞌamoꞌarujëjo. Öri göho bogoꞌe höjo. ");
INSERT INTO aom_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Ëhiꞌonugoromo Iesuꞌo hesi ariböviohuꞌo ë saꞌaho vuonugoꞌi vaꞌareje. Vaꞌoromo Galilee saꞌare ma-saginiëri jijihoruomadeje aëro Iesu gajöëni. ");
INSERT INTO aom_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Ëhesi bëhoho huro hesi aribövioho röjëhibe juvoromo uënövadeje: God-ro ëhi bamëꞌëro hesi A Maho na a jabesi övore vaꞌoromo anegoꞌiramu guomoꞌejöjo. Guomoromo majae niöꞌi gemu hesi uhure riꞌöꞌejöjo. ");
INSERT INTO aom_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Jöho ëhi röjëhamu bëhoho bogo heꞌirögoro juhuoninëgamu bogo ua gavareje. ");
INSERT INTO aom_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Ëhiꞌoromo Iesumëro Capernaum amore rovareje. Rueromo osare vaꞌo raromoromo Iesuro hesi aribövioho uëvadeje: Jemë rabu jöe öriroho atobe rovarije höjo. ");
INSERT INTO aom_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Atobe rovarije höjamu jörumoraejareje ë hesi bëhoho örire rueromo atoromo uarovëꞌëro: Iesuare ijorajo ömoꞌömoho di aho börömoho javuajëjo. Ëhi uarovobe rovëꞌëro jörumoraejareje. ");
INSERT INTO aom_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Jörumoraejamu Iesuro saꞌaro hiromo hesi aribövi 12-ho jaburo ruejöro uvëvamu rovareje. Rovamu uëvadeje: Ae rahu a ioroꞌioro iosirëmiromo nunire namiꞌi uehorovëꞌoho uvonëjo: Na a ioroꞌioro jabesi dejonö namijajëromo jabesi muoho vaejëhonövonëjo. ");
INSERT INTO aom_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Ëhi uënugoromo Iesuro vaꞌo aharihoho viëhi jabesi nunire baro gurasijiomo namiromo uëvadeje: ");
INSERT INTO aom_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","Ae rahu aviëhi jiëꞌe asisöꞌoho gemu nasi ihore rajahiromo baejëꞌoho ëhuro naꞌo rajehiromo baejevoruomaje höjo. O ae rahu na rajehiromo baejevëꞌoho ëhuro bogo na gemu rajehiꞌi remöꞌöjamu rovode ahuꞌo rajahiruomaje höjo. ");
INSERT INTO aom_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Ëhi uëvamu John-ro riꞌöromo uavadeje: Tisa no gavare höjo ae gemuëro jasi ihoho uvoromo aruꞌaho sisë a jabesi dëroho rarovöꞌöjëvamu. Rarovöꞌöjëvamu garomo röhu gavare hu bogo noꞌo juvaje aho jiamu gagorovo uavareje: Vuonugëjo. ");
INSERT INTO aom_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Vuonugëjamu Iesuro uëvadeje: Nadi ëhi jiëꞌoho ëꞌorëjo. Ae rahu nasi iho uvoromo darugoꞌe mu vaejëꞌoho bogo burëroho huotorovoromo nasi jö sisëho aho majëhi varijënoho höjo. ");
INSERT INTO aom_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Ae rahu nosi örire bogo bijönimëꞌoho ë aribövioho nosi aemoꞌaeme jioruomajëjo. ");
INSERT INTO aom_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Röhu ave jöho na jö mae uëꞌiëꞌajëjo. Ae rahu jemë gëromo uvëꞌoho: Jemë Keriso-are aribövie jëvajëromo ma-bisemu ajëmiromo enatuore jovo bojëmijëꞌoho jabu iae manaho ujuohoruomoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Ae göëro asisöꞌonöꞌe jörume hiromo nasi örire mae uehorovevoꞌajëjo. Ëhiꞌoꞌiramu ae göëro ë aho mu sisë röjahiromo ëhuro na mae uehorovevaje muoho ijumahoꞌajëjo. Ijumahoromo iꞌu sisëho baeꞌaꞌajëjo. Mu sisë bogo röjahijajevare evare ë mu sisë röjahijaje a hesi sönöꞌahore aëro iꞌuꞌe munë hitahiohuro tövoromo sö jovore baꞌamego eꞌure bevaꞌoromo guomoꞌibejajo ëho ma-jianovoꞌibejajo. Aꞌi ë mu sisë röjahiꞌiröhe ë hesi iꞌuoho börömo bëhe baeꞌaꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","O jasi övehu mu sisë vaeromo God uehorovanue mu vuonugoꞌiëꞌiroho övoho tariöꞌönëjo. Ja öve gemu javamu ijonö vaꞌoromo mare hijëꞌoho ëhuro mae javoꞌajëjo. Aꞌi öve niöꞌi javamu ijonö God-hu ramöꞌöjamu ravemu ravaje vënire vaꞌëꞌoho ëhuro sisë bëhe javoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Ëdiröꞌore huiniohuro bogo vuovoꞌi a sine ma-ueꞌahemu ueꞌahego vënoho bogo duorohego ë diröꞌore aho viꞌehoho ma-baemu baejarue höjo. ");
INSERT INTO aom_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","O jasi hörehu mu sisë vaeromo God uehorovanue mu vuonugoꞌiëꞌiroho höroho tariöꞌönëjo. Ja höre gemu javamu ijonö vaꞌoromo mare hijëꞌoho ëhuro ja mae javoꞌajëjo. Aꞌi höre niöꞌi javamu ijonö God-hu ramöꞌöjamu vënire vaꞌëꞌoho ëhuro ja sisë bëhe javoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Ëdiröꞌore huiniohuro bogo vuovoꞌi a sine ma-ueꞌahemu ueꞌahego vënoho bogo duorohego ë diröꞌore aho viꞌehoho ma-baemu baejarue höjo. ");
INSERT INTO aom_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","O jasi nunehu mu sisë vaeromo God uehorovanue mu vuonugoꞌiëꞌiroho nunoho jahonëjo. Ja nune gemu javamu ijonö vaꞌoromo God-are aharire hijëꞌoho ëhuro mae javoꞌajëjo. Aꞌi nune niöꞌi javamu God-hu ramöꞌöjamu vënire vaꞌëꞌoho ëhuro ja sisë bëhe javoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Ëdiröꞌore huiniohuro bogo vuovoꞌi a sine ma-ueꞌahemu ueꞌahego vënoho bogo duorohego ë aho viꞌehoho ma-baemu baejarue höjo. ");
INSERT INTO aom_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Söëro ioho huꞌihego ëhuro ioho bogo sisërëꞌi mae jiaje höjo. Söehu i huꞌihego i bogo sisërëꞌi mae jiajëhi ëhi ae ahoꞌobëhe jemë vënëro ravëvanovoromo viꞌehe baeꞌaꞌarujëjo ëhuro jemesi dë vövöbajoꞌoho bogo sisërëjëhoꞌi ma-mae jëvoröhego. ");
INSERT INTO aom_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Söho rihuꞌe mabëhe höjo. Röhu sö hesi rihu barëjëꞌoho röhu bogo maho avoho hesi höjo. Ëhuni nasi rihuꞌe jöho maꞌenoꞌi nadi boremiꞌörëjo. Nadi boremiꞌöꞌi nadi iro muorovoꞌoho vaeꞌi ma-huë baerovorëjo. ");
INSERT INTO aom_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Iesuro jöho ëhi majëhinugoromo ë saꞌaho vuonugoꞌi vaꞌadeje. Vaꞌadoho vaꞌo Judea saꞌare vaꞌoromo Jordan beromo ioni göre ajiomadeje. Ajiomamu gagorovo ae ahoꞌobëhe hesi örire röhu maho ro gagovareje. Gagovamu huro urimo ëꞌajëhi ëhi God-are jöe röjëhijadeje. ");
INSERT INTO aom_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Röjëhijamu Pharisee ariböviohuro rueromo Iesu guaro bevaꞌojöro uaruomadeje: Vaboro nugöꞌöꞌamoꞌiröhe jögoru hesi jöho no heꞌi naguajëjo. Aehu vaboro nugöꞌöjëꞌoho ëhi jiëꞌoho na mae o sisë höjo. ");
INSERT INTO aom_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Na mae o sisë höjamu Iesuro uëvadeje: Röhu Moses-hu jajivoromo bojëmade jögoroho diehi höjo. ");
INSERT INTO aom_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Diehi höjamu uavareje: Moses-ro jajivoromo uövuëꞌe höjo: Nugöꞌöꞌi nagëꞌoho nugöꞌöꞌirane jöho suroro jajivoromo vaboroho bojamiromo evaro nugöꞌönëjo. ");
INSERT INTO aom_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Ëhi uavamu uëvadeje: Iae ëhi höjo röhu jemë hiaꞌi biririꞌe aribövie jëvobe rovëꞌego ëhuni Moses-ro ë jögoroho jemëni jajivëhade höjo. ");
INSERT INTO aom_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Röhu aevoꞌi God-hu bövi biseꞌo bamade majaroho bogo ëhioho jioꞌi ë hesi jöho God-are surire ëhi uvëꞌe höjo: God-ro aevoromo ahuꞌo magonahohuꞌo bamëvade höjo. ");
INSERT INTO aom_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Ëhuꞌëro jiëꞌëro aëro vëmu vavuꞌoho rëmöꞌöꞌi vaborohuꞌo gemu mae hiꞌaꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Vaborohuꞌo hiꞌiramu jabumë niöꞌi jëvadoho röhu gemu jioꞌaꞌajëjo. Ëhi uvëꞌe höjo. Ëhuꞌëro jiëꞌëro ë ahuꞌo magonahohuꞌo bogo hahagu hahagu jioꞌi ma-gemu jëvoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","God-hu mamiꞌe gemuore havoromo muohadoho jemë ma-ae jëvaje nadi tarivorëjo. ");
INSERT INTO aom_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Ëhi uënugoromo huꞌo hesi ijorajo ömoꞌömohuꞌo vuonoröꞌö vaꞌo osare raromoromo ijorajoho jaburo Iesu uavareje: Vaboro nugöꞌöꞌamarue jöho röhu maho majahuijego no hejarëjo. ");
INSERT INTO aom_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Hejarëjamu Iesuro uëvadeje: Baruehu vaboro nugöꞌöꞌi gö masuvëꞌoho ëho gohoꞌamarue muoho vaeꞌaꞌajëjo. Ëhuro vaboro maho ijumoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","O vaborehu baru nugöꞌöꞌi gö masuvëꞌoho ëho bogo maho masuꞌi gohoꞌamarue muoho vaeꞌaꞌajëjo. Ëhi uëvadeje. ");
INSERT INTO aom_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Ëhi uëvëꞌëro aëro asisöꞌoho sö ujuoho rueruomadeje Iesuro öve jabesi sinore bamëhojöro. Ujuoho rovamu gëgorovo Iesuare ijorajo ömoꞌömohuro birëgoromo uëvareje: Asisöꞌoho nadi aveho sö ruehëjo. ");
INSERT INTO aom_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Ëhi birëgamu hegoro Iesuro dë vörönimamu hesi aribövioho uëvadeje: Nadi ahëvoꞌi uëhego rueruomajo. Ëhi jiëꞌe asisöꞌo vaꞌëne jörume raromëꞌe aribövioho God-ro böröme namiromo muebejëvego hesi ahariremu raromoruomaje höjo. ");
INSERT INTO aom_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Ave jöho na jö mae uëꞌiëꞌajëjo. Asisöꞌo ininehu bogo sivu uehorovoꞌi God-hu muebejavuajoho mae hö uvaruëhi ae rahu bogo ëhi uvëꞌoho ë God-are ahariroho bogo vaꞌo raromoꞌaruëjo. ");
INSERT INTO aom_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Ëhi uënugoromo ë asisöꞌoho huohudëꞌamoromo övoho jabesi simanore bamëhoromo uëvadeje: God-ro huë mae bojëmiꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Ëhi ëꞌëꞌëro Iesuro riꞌöromo örire vaꞌadeje. Vaꞌamu ae gemuëro tutuvo rueromo hesi bëhire ague aho hiromo uavadeje: Tisa ja a mae javajëjo. Na diehiꞌoromo ioroꞌioremuoho maroho hiꞌejöjo. ");
INSERT INTO aom_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Maroho hiꞌejöjamu uavadeje: Jero na uevanuëjo: Ja a mae javajëjo. Iae mae höjo röhu hesi God gemu a maho höjo. ");
INSERT INTO aom_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Röhu mae hiꞌiranëro ue gevanuoho ja God-are jögoroho iae gavanue höjo. Nadi aho anonëjo. Nadi gohoꞌamonëjo. Nadi vajiohoho baenëjo. Nadi sareriꞌe jöho aho majëhinëjo. Nadi sareri sarerioho ëꞌoromo vajiohu muoho vaenëjo. Jasi vëmoho vavuoho mae uehorovëvonëjo. Mae hiꞌirane öroho ëhi höjo. ");
INSERT INTO aom_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Öroho ëhi höjamu uavadeje: Tisa iae mae-ëjo röhu na asisöꞌoꞌere aevoromo jö ebe rovodoho jaruvohuꞌo ëhi gemuoho ëꞌaje höjo. ");
INSERT INTO aom_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Ëhi uavamu hegorovo Iesuro hu garomo hesi örire dë vövöbajoꞌe ahoꞌo uehorovoromo uavadeje: Iae ëhi höjo röhu mue gemu bogo vaejëꞌëro javëꞌëro ëhuꞌëro ja bogo eni javajëjo mae hiemu hiꞌiranoho. Vaꞌoromo jasi inömoho bövioho biseꞌoho imoꞌamoromo monioho baeromo inömo bogo eni jiëꞌe aribövioho suvuorëminëjo. Ëhi ëꞌëꞌoho bövie biseꞌe maho maho janioho öꞌidöre jiahoꞌajëjo. Ëhiꞌoromo rueromo nasi ijoro ijoro juvonövonëjo. ");
INSERT INTO aom_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Ëhi uavamu hegorovo ruehuro hesi uehorovoromo uvadeje: Na bövie biseꞌe börömo mae jevëꞌëro suvuorëmiꞌirodoho na bogo eni jevajëromo vavaenimoromo nu anoꞌe sisërëromo vaꞌadeje. ");
INSERT INTO aom_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Vaꞌamu gagorovo Iesuro uherihoromo hesi ijorajo ömoꞌömoho gëromo uëvadeje: Bövi biseꞌo marohëꞌe ariböviehu God-hu muebejaje öri ariꞌere vaꞌëꞌoho anojiꞌe mae jioꞌaꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Ëhi uëvamu rue ijorajoho jabu jöe barëjëvadeje. Jöe barëjëvamu Iesuro röhu maho uëvadeje: Aganomë God-hu muebejaje ajiꞌe öri ariꞌere vaꞌiröhoho anojiꞌe mae höjo. ");
INSERT INTO aom_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Mi börömo anugo gagore nugöꞌöjëꞌoho ja bogo eni javoꞌajëjo. Röhu ëhi ëꞌëꞌoho samae jianovoꞌi aꞌi bövi biseꞌo marohëꞌe ariböviehu God-hu muebejaje öri ariꞌere vaꞌiröhoho ëho anojiꞌe mae höjo. ");
INSERT INTO aom_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Ëhi jövamu heromo tiötiövoromo uavareje: Ëhi jiëꞌoho no diehiꞌoromo maroho vaꞌejarëjo. No ae ahoꞌobëhe bogo eni javuajëjo. ");
INSERT INTO aom_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Bogo eni javajëjamu Iesuro ërimëhoromo uëvadeje: Ioꞌajo. Jemë aëro jëvëꞌëro bogo eni jëvajëjo. Aꞌi God-hu öri avohëhëꞌoho hu eni höjo hu mue ahoꞌobëhe vaejëꞌoho eni jiajëro jiëꞌëro. ");
INSERT INTO aom_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Ëhi uëvamu hegorovo Peter-ro riꞌöromo Iesu uavadeje: Aveho gavëjo. Noro bövie biseꞌe nosiroho vuonugoꞌi jasi ijore ijore jijihëꞌe javuajëjo. ");
INSERT INTO aom_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Jijihëꞌe javuajëjamu Iesuro uëvadeje: Ëho iae mae höjo. Aveho na jö mae uëꞌiëꞌajëjo. Ae rahu javue öe maꞌine vëme vavue aboji harihuꞌe o saꞌae vuonugoꞌi nasi jöëni vaꞌoromo nasi jö ma a majëhijëꞌoho ");
INSERT INTO aom_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","ëhi jiëꞌe aribövioho jemë jemesi bövioho biseꞌoho ëho ma-biseꞌe vuonugarije höjo röhu avevejöꞌe ave saꞌare bövi mae baeꞌaꞌarujëjo. Javue ahoꞌo ö ömoꞌöme ahoꞌo maꞌino ömoꞌöme ahoꞌo vëmu ömoꞌöme ahoꞌo aboji harihuꞌe ahoꞌo saꞌae ahoꞌo baeꞌaꞌarujëjo. Ëhi baeꞌaꞌarujëjo röhu aëro nasi jöëni huë vavaenohuꞌo bojëmiꞌiramu baeꞌaꞌarujëjo. Röhu majae ijonö jemë ma-ioroꞌioremu maro raromoꞌarujëjo. ");
INSERT INTO aom_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Ëhi höjo röhu a ioroꞌiore ahoꞌo nuninö jiaruoho dejonö jioꞌi a ioroꞌiore dejonö jiaruoho nuninö jioruomoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Ëhi ëꞌëꞌëro Iesuꞌo huꞌo vaꞌarue ariböviohuꞌo ëho jaburo Jerusalem amo börömore ajiomoꞌi örire vaꞌareje. Iesuro urimo vaꞌi hesi ijorajo ömoꞌömohuro uehoro böröme baebe hesi ijore vaꞌi a ioroꞌioroho ahoꞌobëhe jaburo jabesi ijore juhuonivobe vaꞌoruomadeje. Vaꞌoromo Iesuro hesi ijoraje 12-ho röhu maho roriꞌo sö vaꞌoromo aehu hesi örire diehi jiëꞌe mu vaeꞌiröhe jöho majëhiromo uëvadeje: ");
INSERT INTO aom_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Aveho hehëjo. No Jerusalem amore ajiomaruëjo. Ajio ë raromoromo God-ro hesi ëhi bamëꞌëro hesi A Maho naro priest masijo jabesi övore Jew rajo jögoru öri röjëhijarue a jabesi övore vaꞌiramu baejevoꞌaruëjo. Baejevoromo nasi jöho mevo garomo uvoruomoꞌajëjo: Nörö sisëꞌe aego guomoꞌaꞌajëjo. Guomoꞌaꞌajëromo na baejevoromo saꞌa göre jioromo rovare aribövi jabesi övore bojëmiꞌiramu baejevoromo ");
INSERT INTO aom_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","sivegoromo sabëro ödegoromo hisuebijevoromo anegoꞌiramu guomevoꞌajëjo. Guomoromo majae niöꞌi gemu hesi uhure riꞌöꞌejöjo. ");
INSERT INTO aom_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Ëhi uëvëꞌëro iae Zebedee-are harihe niöꞌi Jamesꞌo Johnꞌo rueromo Iesu uavareje: Tisa no naguajëjo noehu rabu jö ua gaꞌiëꞌaruëhi jero ëhi ëꞌiranego. ");
INSERT INTO aom_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Ëhi uavamu uëvadeje: Naro rabe ëꞌëhojöro uevarujëjo. ");
INSERT INTO aom_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Rabe ëꞌëhojöro uevarujëjamu uavareje: No naguajëjo jaehu jasi ajiꞌe öri ariꞌere hijëꞌiroho jero uövuego no öꞌo jasi bëhire masije rirarovoromo noro göëro jasi övo manö göëro jasi övo adonö ëhi ariꞌiröhëro. ");
INSERT INTO aom_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Ëhi uavamu uëvadeje: Iae ëhi höjo röhu jemëhu ue gevaruje jö hesi bëhoho jemë bogo gavëꞌe ëma uevarujëjo. Na gavajëjo ajuoꞌe jovo sisëhu ajuemanovoꞌiröhoho jioromo nasi örire jovëro rovanovo hesi jioꞌego. Ëhi jiëꞌe huë vavaeni baeꞌirarijoho na jemëꞌo eni jëvajëjo. ");
INSERT INTO aom_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Eni jëvajëjamu uavareje: Iae no eni javuajëjo. Ëhi uavamu Iesuro uëvadeje: Iae mae höjo. Na ajuemiꞌiröhe jovo sisëhuro jemëꞌo ajuëmiꞌajëjo. O nani rueröhe jovohuro jemëni rueꞌaꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Röhu nasi bëhire övo manö o övo adonö ariꞌirarije jö uëꞌirodoho ëho bogo nasirehu höjo. Hesi God-hu a rahumëni uvoromo nugade röhoho ë aho jaburemu nasi bëhiroho ariꞌaꞌaruëjo. ");
INSERT INTO aom_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Ëhiꞌamu Iesuare ijorajo ioroꞌioroho 10 jaburo hejareje uvavamu: Jamesꞌo Johnꞌo Iesuare bëhire böröme rirarovoꞌi uvare höjamu hegorovo jabesi örire dë vörönimoruomadeje. ");
INSERT INTO aom_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Dë vörönimoruomamu gagorovo Iesuro hesi ijorajoho ahoꞌobëhe uëvadeje: Ruehëromo rovamu uëvadeje: Iae jemëꞌo gavarujëjo. Saꞌa ioroꞌioro rajëro uvoruomaje höjo: Ëa masijohuro no muebejavuarue höjo. Ëhi höjo röhu ë a masijoho jaburo jabesi aribövioho ruahöꞌöjëvoromo jabumëremu masije riravarue höjo. O jabesi bëhire riravaruohuro ëhi taemëvoromo jöe bojëmijarue höjo. ");
INSERT INTO aom_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Saꞌa ioroꞌioro rajohuro ëhi ëꞌarue höjo. Röhu jemëꞌo nadi ëhioho döroho bamorovorëjo. Aꞌi jemesi ae gemu rahu bövie namiꞌi nimëꞌoho hu a ioroꞌioro jemë ajëminövoꞌiröhe ae jioꞌaꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","O jemesi ae gemu rahu nunire jioꞌi nimëꞌoho hu a ioroꞌioro jemesi mu vaejëhonövoꞌiröhe ae jioꞌaꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Ëhesi bëhoho God-are A Maho naꞌo ae ajëmiꞌi ëhuni rovode höjo. Naehu rovode hesi bëhoho bogo aëro na ajemiꞌirarijego rueꞌi aꞌi naro ae ajëmiromo nasi arijoꞌarije bojamirovoromo guomorovoromo ëhuro ae ahoꞌobëhe sisëhu tövëvajoho jiovo rëmöꞌöꞌirodëni ëhuni rovode höjo. ");
INSERT INTO aom_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Ëhiꞌoromo Iesumëro vaꞌaroho vaꞌo Jericho amore suorovareje. Suorovëꞌëro Iesuꞌo hesi ijorajo ömoꞌömohuꞌo a ioroꞌiorohuꞌo ahoꞌobëhe ëho jaburo Jericho amoho nugoromo vaꞌi ëꞌareje. Röhu Timaeus-are harihe Bartimaeus öri ionire hijëꞌe jiadeje. Hu nuni sisëꞌe aëro jiëꞌëro hiromo maëni sisëni ëninëminövadeje. ");
INSERT INTO aom_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Ëahuro öri ionire hiromo hejade uvoruomamu: Rovaꞌaje aho Nazareth amo raje Iesu hö uvamu hegorovo ma-darugoꞌo uvoꞌi hijadeje: David-are ujoho böröme javaje Iesu jero nani vavaenimëjo. ");
INSERT INTO aom_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Vavaenimëjamu hegorovo ae ahoꞌobëhe jaburo birevoromo uavareje: Jöe vuonugëjo. Jöe vuonugëjamu hejëꞌi röhu maho darugo maꞌo uvoꞌi hijadeje: Hë David-are ujoho nani vavaenimëjo. ");
INSERT INTO aom_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Ëhi uvoꞌi hijamu hegorovo Iesuro vaꞌadoho vuonugoꞌi ë namiromo uëvadeje: Uvohego rovajo. Rovajamu rueho jaburo ë nuni sisëꞌe aho uavareje: Iae mae höjo. Riꞌöromo rovëjo. Arue ahuro uvajëjo jero ruejöro. ");
INSERT INTO aom_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Ëhi uavamu hejëꞌi ruehuro döre baꞌamade niögoho jaho buꞌöromo ma-burëro riꞌöromo Iesuaro vaꞌadeje. ");
INSERT INTO aom_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Vaꞌamu Iesuro uavadeje: Naro diehi ajamijöro nagajëjo. Nagajëjamu rue nuni sisëꞌe ahuro uavadeje: Bada ajemego na nune dadovoromo uherihöjo. ");
INSERT INTO aom_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Uherihöjamu Iesuro uavadeje: Iae mae höjo. Vaꞌëjo. Jero God mae uehorovamu ëhuro marëjavëꞌe höjo. Ëhi uavamu gavëꞌi ma-burëro uherihadeje. Uherihoromo Iesuare ijore örire vaꞌadeje. ");
INSERT INTO aom_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Iae Iesumëro vaꞌo Jerusalem bëhire vaꞌoromo Olives Dahorure iojiomoromo Bethphage amo o Bethany amo jiajinö ë rovareje. Rueromo Iesuro hesi ijorajoho niöꞌi rëmöꞌöromo ");
INSERT INTO aom_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","uëvadeje: Arue jemesi nuninörire amohuro vaꞌohëjo. Vaꞌo höröꞌi gaꞌaꞌarujëjo donkey harihe biseꞌego aehu döre bogo hiromo vaꞌaruoho benugëꞌe jioꞌiramu. Benugëꞌe jiego jiovoromo huꞌirae ruerëjo. ");
INSERT INTO aom_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","O aehu uëvëꞌoho: Jemë rabëni jiovarujë uëvëꞌoho uërëjo: Badaro ave mioho nimoꞌego ëhuni jiovaruëre. Huro mu nimadoho vaeromo iae ma-burëro sionëro nugöꞌöꞌajëre. ");
INSERT INTO aom_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Ëhi uëvamu vaꞌoromo gavareje donkey harihoho öri börömore javue gemu namiꞌego ë ojanore benugëꞌe jiamu. Benugëꞌe jiamu gagorovo jiovareje. ");
INSERT INTO aom_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Jiovamu gëgorovo ë bëhire riravare aribövioho jaburo uëvareje: Jemë rabëni donkey harihoho jiovarujëjo. ");
INSERT INTO aom_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Rabëni jiovarujëjamu Iesuhu uëvadëhi ëhi majëhijareje. Ëhi majëhijamu rueho jaburo uëvareje: Iae mae höjo. Bavaꞌohëjo. ");
INSERT INTO aom_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Bavaꞌohëjamu huꞌirae barueromo jabesi niögoho mi dejore ruahoꞌamo bahijamu Iesuro ë ajio hijadeje. ");
INSERT INTO aom_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Hiromo vaꞌamu gavëꞌi ae ahoꞌobëhe a ioroꞌiorohuro niögoho örire ahahobe vaꞌi a ioroꞌiorohuro mure ijo rude tarivëꞌëro ahahobe vaꞌareje. ");
INSERT INTO aom_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Vaꞌoromo Iesuare nuninö vaꞌoruomadohuꞌo dejonö rueruomadohuꞌo ma-darugoꞌo uvoruomadeje: God mabëhëjo. Ave aho Badare ihore rovajoho mabëhëjo. ");
INSERT INTO aom_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Nosi hije David-are sionoho baeromo böröme namiromo muebejavuoꞌiëꞌajëjo. No naguajëjo ë muoho mae tutuvoröhego. God mabëhëjo. ");
INSERT INTO aom_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Ëhi rajahibe rovëꞌi Iesuꞌo Jerusalem rovareje. Iesuro Jerusalem ruenugoromo God-are amo börömore vaꞌadeje. God-are amo börömore vaꞌoromo bövioho biseꞌoho gabe juvonugoromo gavade mamiꞌe vöꞌöromamu gagorovo huro hesi ijoraje 12-ho jabuꞌo gemu mae Bethany amore sionëro vaꞌadeje. ");
INSERT INTO aom_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Bethany amore vaꞌëꞌëro nërö riꞌöromo ë jioromo vuonoröꞌö rovareje. Örire rueromo Iesuro hejade hömamu hejëꞌi ");
INSERT INTO aom_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","rueꞌi gavadeje arue riribövire mesoho hanoꞌe namijamu. Mesoho namijamu gagorovo ë bëhire vaꞌadeje gaꞌi bösoho raejëꞌe jiego o bogo. Vaꞌoromo gavadeje bajoho bogojioꞌi ma-hano ruduꞌemu jiamu hesi raejaje majaho bogo rovëꞌëro jiëꞌëro. ");
INSERT INTO aom_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Hano ruduꞌemu jiamu gagorovo mesoho uavadeje: Ijonöho nadi bajoho raenego aho ueꞌahoꞌirarëjo. Ëhi uavamu hesi ijorajoho jaburo hejareje. ");
INSERT INTO aom_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Ëhiꞌoromo Iesumëro örëro ajiomoromo Jerusalem ajio suorovareje. Suorovoromo Iesuro God-are amo börömore vaꞌadeje. Vaꞌi gavade aëro bövie biseꞌe imoꞌamamu gëgorovo rarovöꞌöjëvadeje. Rarovöꞌöjëvoromo gavade aëro saꞌa göre göre jioromo rovare aribövi jabesi ijo bajoho ujuohoꞌi amo börömo hesi ijo bajoho iꞌimëmamu gëgorovo jabesi mu maratuoho huotovöꞌöjëhoromo ugo imoꞌamarue aribövi jabesi arëtohuꞌo huotovöꞌöjëhadeje. ");
INSERT INTO aom_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Huotovöꞌöromo ae ahoꞌobëhe ahëvadeje jabuhu inömo inömo ujuohoromo God-are amo ririre örörovaruoho vuonugojöro. ");
INSERT INTO aom_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Ëhi uënugoromo God-are jö hesi öroho ae röjëhiromo uëvadeje: God-are surire jajivoromo uvëꞌe höjo: God nasi osaho aëro uvoruomoꞌajëjo: Ëosa hesi bëhoho saꞌae dinöꞌe dinöꞌe raromarue ariböviehu ro God-are örire jö atarue osaho höjo. Ëhi uvëꞌe höjo röhu jemëro mu sisë ëꞌëꞌëro ëhuro ave osaho vajiohuꞌe ariböviehu gurihirovarue juju gagoho vaꞌëne höjo. ");
INSERT INTO aom_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Ëhi uëvamu priest masijohuꞌo Jew rajo jögoru öri röjëhijarue ariböviohuꞌo ëho jaburo ë jöho heromo gavare ae ahoꞌobëhe Iesuhu röjëhijaje jöho heromo tiöruomamu gëgorovo uvareje: Nani ae ahoꞌobëhe no ramuoꞌi Iesu gemu uehorovoꞌaruëromo juhuonivareje. Juhuonivoromo öre nahareje Iesu anego guomoröhego. ");
INSERT INTO aom_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Ëhiꞌamu vöꞌöromamu gagorovo Iesuꞌo hesi ariböviohuꞌo Jerusalem jioromo vaꞌareje. ");
INSERT INTO aom_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Vaꞌëꞌëro sisonuvamu Iesuꞌo hesi ariböviohuꞌo örire vuonoröꞌö rueꞌi gavareje mesoho mamiꞌe sahori barëjëꞌe jiamu. ");
INSERT INTO aom_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Sahori barëjëꞌe jiamu gagorovo Peter-ro Iesuhu urimo jövade jöho uehorovoromo uavadeje: Bada arueho gavëjo. Jaehu sahorijöro uavane mesoho iae sahorijëꞌe höjo. ");
INSERT INTO aom_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Sahorijëꞌe höjamu Iesuro uëvadeje: God mae uehorovorëjo. ");
INSERT INTO aom_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Ave jöho na jö mae uëꞌiëꞌajëjo. Jemë bogo uehore niöꞌi baeꞌirögoro God gemu mae uehorovoromo uvëꞌoho: Na uvajëhi iae ëhi jioꞌaꞌajë uvoromo ave dahoru uavëꞌoho: Riꞌöromo vaꞌo jovo börömoro buꞌörovonë uavëꞌoho jemëhu uvarije muoho God-ro vaejëhoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Ëhuni na uëvajëjo: Rabe rabe God ua gavëꞌoho mae uehorovoromo uvorëjo: Iae mae-ëjo. God-ro iae bojemiꞌiramu baeꞌejöjo. Ëhi uvëꞌohuro ëhuro iae baeꞌaꞌarujëjo. ");
INSERT INTO aom_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","O jemë döre riravoromo God-are örire ëninamiꞌirögoro röhu ae göëni dë vörönëgëꞌoho ë a hesi sisëho uehorovoromo vuonugorëjo. Ëhi ëꞌëꞌoho ëhuro jemesi Vavue öꞌidöre hijaje ahuro jemesi sisëhuꞌo uehorovoromo vuonugoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","O jemëhu jabesi sisë bogo uehorovoromo vuonugëꞌoho jemesi Vavue öꞌidöre hijaje aho huꞌo jemesi sisëho bogo uehorovoromo vuonugoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Ëhi majëhinugoromo Iesuꞌo hesi ariböviohuꞌo Jerusalem röhu maho rovareje. Jerusalem rueromo Iesuro God-are amo börömore vaꞌoromo ë juvadeje. Juvamu gagorovo priest masijohuro Jew rajo jögoru öri röjëhijarue ariböviohuro a duvaho ömoꞌömohuro rueromo ");
INSERT INTO aom_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Iesu uavareje: Jaehu God-are amo börömore hiromo mue gö gö vaejanuoho diehi jiëꞌe daruge javoromo o raro darugoho bojamijëꞌëro ëhi jiëꞌe muoho vaejanue höjo. ");
INSERT INTO aom_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Vaejanue höjamu Iesuro uëvadeje: Nasi darugo hesi jö ue gevarujoho naꞌo jemë jöe gemu uë gëꞌiëꞌajëjo. Jemëhu mana uevëꞌoho naro jemë uëꞌejöjo: Na ëhi jiëꞌe darugohuro muoho vaejaje höjo. ");
INSERT INTO aom_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","John-hu bapataeto vaejavuonövadoho na God-ro o ma-aëro darugoho bojamijëꞌëro ëhioho ëꞌonövade höjo. Uehego na hejöjo. ");
INSERT INTO aom_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Hejöjamu rue a masijohuro Iesu diehi mana uaꞌiröhe jöho jabesi mevoromo uarovareje: Noehu uavëꞌoho: God-ro John darugoho bojamade hö uavëꞌoho Iesuro uöꞌaꞌajëjo: Ëhi jiëꞌoho jemë rabëni John bogo ma uehorovarije höjo. ");
INSERT INTO aom_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","O noehu Iesu uaꞌiröhoho: Ma-aëro John uavamu ëꞌade hö uaꞌiröhoho röhu ë jöho bogo uaꞌejarëjo. Ëhi uarovare hesi bëhoho ae ahoꞌobëhe uvoruomadeje: John hu jö God-aro baeromo majahuinövade ae höjo. Ëhi uvoruomamu ë a masijehu ae ahoꞌo jabesi jö ahoꞌi jö gö Iesu uaꞌiröhoho juhuonivareje. Juhuonivoꞌi ëhuni Iesu uaꞌiröhoho: Ma-aëro John uavamu ëꞌade hö uaꞌiröhoho bijönimareje. ");
INSERT INTO aom_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Bijönimoromo Iesu uavareje: Jaehu uö gövuanue jö hesi bëhoho no dadivavuajëjo. Dadivavuajëjamu hegorovo Iesuro uëvadeje: Ëhi jiëꞌoho jemëhu uevarije jöho naꞌo bogo uëꞌejöjo: Na ëhi jiëꞌe darugohuro muoho vaejaje höjo. ");
INSERT INTO aom_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Iesuro ëhi uënugoromo ë Jew rajo aribövi jabesi jö sisëho uhuꞌe majëhiromo uëvadeje: Iae ae gemuëro mure grape öꞌoho bivoꞌamade höjo. Bivoromo ë muoho buore iromo rovaꞌo rojomoromo öꞌi bajo saꞌijovoröhe guaho umoromo mu javue döro vaejade höjo hesi mu ahuro ajio ë hiromo muoho atovoröhego. Muoho ëhi avohoromo gavade eni jiamu gagorovo ae uëvade höjo: Na vaꞌejöjo. Jemëro nasi muoho muebejehorëjo. Mueberomo öꞌi bajoho raeromo mavego nasiroho bahiꞌi ioroꞌioroho jemesi ujuohorëjo. Ëhi uënugoromo riꞌöromo vaꞌo saꞌa göro ë hijade höjo. ");
INSERT INTO aom_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Saꞌa göro vaꞌoromo hijuvo gavade öꞌi bajo urarue majaho rovamu gagorovo mu vaejaharue aho gemu uavade höjo: Vaꞌiranoho mu muebejarue aribövioho uënego öꞌi baje gö iꞌimamego ujuoheho ruenëjo. Ujuoheho ruenëjamu ruehuro vaꞌade höjo. ");
INSERT INTO aom_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Vaꞌo mure höröjamu gavëꞌi rue mu muebejarue ariböviohuro ë aho guduamoromo anoromo sihöꞌöjamu sionëro övemu rovade höjo. ");
INSERT INTO aom_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Övemu rovamu gagorovo rue a börömohuro mu vaejaharue ae göꞌo nugöꞌöjamu mure vaꞌade höjo. Vaꞌo höröjamu gavëꞌi rue mu muebejarue ariböviohuro ë aho simanore anoromo hesi örire mu sisë vaejare höjo. ");
INSERT INTO aom_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Ëhiꞌamu mu arijoꞌohuro mu vaejaharue ae göꞌo nugöꞌöjamu mure vaꞌade höjo. Vaꞌoromo höröjamu gavëꞌi mu muebejarue ariböviohuro ë aho anamu guomade höjo. Anamu guomamugo mu arijoꞌohuro hesi mu vaejaharue ae gö gö nugöꞌöbe rovade höjo. Nugöꞌöꞌego vaꞌo mure höröꞌego ioroꞌioroho ijahëro hisuebiꞌamoꞌi ioroꞌioroho muoꞌamo barënövare höjo. ");
INSERT INTO aom_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Ëhiꞌojuvo huꞌoho ae gemu jiade höjo. Ëaho hesi harihu mabëhoho jiade höjo. Ijo tugohoꞌi mu arijoꞌohuro uehorovoromo uvade höjo: Arue mu muebejarue ariböviohuro hu garomo uvoꞌaꞌaruëjo: Nöruare harihe hö uvoromo ëhuni mae uehorovoꞌaruëjo. Ëhi uvoromo nugöꞌöjamu mure vaꞌade höjo. ");
INSERT INTO aom_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Vaꞌo höröjamu gavëꞌi ë mu muebejarue ariböviohuro uarovare höjo: Arue rovaje ahuro hesi vavu hesi sionoho bae hesi höjo. Ëhuni ëꞌego ano bamarëjo ëhuro ave muoho noro baeröhe höjo. ");
INSERT INTO aom_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Ëhi uarovonugoromo ë aho guduamoromo anoromo guomamu muro jiamu baeromo roriꞌo buꞌöruomade höjo. Ëhiꞌare höjo. ");
INSERT INTO aom_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Ëhi jiëꞌoho mu arijoꞌohuro diehi ëꞌaꞌajëjo. Huro rueromo mu muebejarue aribövioho iꞌue bojëmiromo muoꞌamoꞌi ë muoho ae gö bojëmiꞌajëjo jaburo mueberöhego. ");
INSERT INTO aom_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","11","Röhu ave uhu jöho God-are surire jajivoromo uvëꞌe höjo: Munë javue vaeꞌirögoro munë gemu bijönimoromo vuonugare höjo. Vuonugaroho jaruvoho ë munëhuro javuoho nigemoꞌego bibivoromo mae namijajëjo. Hesi Bada God-ro ëhi ëꞌade höjo. Ëho noro garomo uvarue höjo: God-ro mu mabëhe ëꞌëꞌe höjo. Ëjö God-are surire jajivamu adaharijoho jemë diehiꞌoromo ë hesi bëhoho bogo avoho baejarije höjo. ");
INSERT INTO aom_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Ëhi uëvamu hegorovo rue Jew rajo a masijohuro garomo uvareje: Iesuro a masijoho no biraguoromo ëhuni uhu jöho jövajëjo. Jövajë uvoromo Iesu guduamo bavaꞌiëꞌoromo ae ahoꞌobëhe juhuonëmiromo vuonugo vaꞌareje. ");
INSERT INTO aom_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Ëhiꞌamu aëro Pharisee aribövioho o Herod-are aribövioho rëmöꞌöjareje vaꞌoromo Iesu sareramego huro jöe sisëꞌi jövoromo guaro berovoröhego. ");
INSERT INTO aom_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Rëmöꞌöjamu vaꞌoromo Iesu sarerisareriamiromo uavareje: Tisajo. Iae no gavarue höjo ja a mae javego. O aho bogo juhuonëmijego. Ëhesi bëhoho jero no göromo ae böröme o biseꞌe javuajëromo jöe gö gö bogo röjahuiꞌi God gemu uehorovoromo hesi örohemu mae röjahuijanue höjo. Ëhuni no jö harihe ua gaꞌiëꞌaruëjo tax jöho. Rome a börömohuro nosi saꞌaho muebejego noro hu tax bojamijarue höjo. Noehu ëhi ëꞌaruoho na ëhuro Jew rajo nosi jögoroho aharue höjo o bogajo. Na no bojamiꞌejarëjo o bogajo. ");
INSERT INTO aom_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Bogajamu Iesuro gëromo uvadeje: Arue ariböviohuro nasi örire ma-döemu mae ue geꞌi aꞌi jabesi uhoho na ijumevoꞌi nimoromo majehijaruëromo uëvadeje: Jemë rabëni nasi dëho bijioho gevarujëjo gaꞌi na bejevego. Ajivëꞌe ijo baje gemu baruehego na gavöjo. ");
INSERT INTO aom_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Gavöjamu barovareje. Barovamu garomo uëvadeje: Aveho rahuare nu anoꞌohuꞌo ihohuꞌo jajivëꞌe höjo. Jajivëꞌe höjamu uavareje: Rome a börömo hesi höjo. ");
INSERT INTO aom_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Rome a börömo hesi höjamu Iesuro uëvadeje: Ëhuni Rome a börömo hesiroho ëho hesi öroro bojamiꞌi God-aroho ëho God-are öroro bojaminövorëjo. Ëhi uëvamu heromo jöe barëjëvadeje. ");
INSERT INTO aom_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Ëhiꞌamu iae Jew rajo a masijo ioroꞌiorohuro rovareje. Jabumë Sadducee jö uehorovarue aribövie jioruomadeje. Sadducee ariböviohuro uehorovoromo uvoruomajeje: A vuovëꞌoho ijonöho bogo riꞌöꞌamoꞌi ma-ioroꞌiore gemu vuovoꞌajëjo. Ëhi uvoruomaje ariböviohuro rueromo Iesu guaro berovojöro sarerisareriamiromo uavareje: ");
INSERT INTO aom_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Tisajo. Moses-ro jögore jajivoromo uövuëꞌe höjo: Aboji harihuꞌo rumoꞌe a vuovego diehi ëꞌiröhe öroho aviëhi höjo. Aehu vaboro masuromo vaboroho aboji harihuꞌoho bogo vaejëꞌe baruehu guomoꞌi vaboro nugëꞌoho hesi öhuro vuojiroho masuromo ëhuro guomade ö hesi ihoro ujoho vaejahoꞌajëjo. Moses-are jögoroho ëhi höjo. ");
INSERT INTO aom_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Ëhi jiëꞌëro iae ma-ö ömoꞌömëremu ae ahoꞌo 7 raromare höjo. Raromoromo muriohuro magonahoho masuvade höjo. Masuromo vaboroho aboji harihuꞌoho bogo vaejëꞌe baruoho guomade höjo. ");
INSERT INTO aom_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Guomamu hesi vaboroho dorue hijamu ö göhuro vuojiroho masuvade höjo. Masuromo vaboroho aboji harihuꞌoho bogo vaejëꞌe baruoho guomade höjo. Guomamu hesi vaboroho röhu maho dorue hijamu gagorovo ö göhuro vuojiroho masuvade höjo. Masuromo guomade höjo. ");
INSERT INTO aom_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Ö ömoꞌömo ioroꞌiorohuꞌo ëhi gemuoho ëꞌobe rovare höjo. Ö ömoꞌöme 7 jabuhu ë magonahe gemuoho masube rovaroho ë magonahoho aboji harihuꞌoho bogo vaejëꞌe aho ma-vuovëvobe rovade höjo. Vuovobe ruejuvo barëjamu ijo tugohoꞌioho ë magonahoho huꞌo guomade höjo. Ëhiꞌare höjo. ");
INSERT INTO aom_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Ëhi ëꞌarohuni ëhuni ave jöho no ua gaꞌiëꞌaruëjo. Jero uvanue höjo: Vuovoromo riꞌöꞌejarëjo. Ëhuni vuovëꞌe ariböviehu riꞌöruomoröhe majaroho ë magonahoho di ahuꞌo hiꞌaꞌajëjo. Barue ahoꞌo 7 masuvëꞌego uavaruëjo. ");
INSERT INTO aom_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Ëhi uavamu hegorovo Iesuro uëvadeje: Bogajo. God-are surire jöhuꞌo huhu mu vaeröhe darugohuꞌo jemë bogo avoho gavarujëro sisëꞌi uehorovoromo ue gevarujëjo. ");
INSERT INTO aom_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Ëhesi bëhoho vuovëꞌëro riꞌöruomoꞌiröhe maja rovëꞌiroho vaboroho baruoho bogo masurovoꞌi aneraehu öꞌidöre ma-raromaruëhi ëhi raromoꞌaruëjo. Ëhuni ë magonahehu di ahuꞌo hiꞌiröhe jö ue gevarujoho bëhi rumoꞌe höjo. ");
INSERT INTO aom_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Ëjöho jemëro uvaruje höjo: Vuovëꞌe ariböviehu riꞌöꞌiröhe jöho sareri jöe höjo. Ëho bogo sareri jöehu jioꞌi jö mae höjo. Ëhesi bëhoho vuovoromo riꞌöꞌiröhe jöho Moses-ro God-are surire iae jajivëꞌe höjo. Ijo hisu vënehu ravade jö jajivadevare evare God-hu jövade jöho jajivoromo ave jöhuꞌo uvëꞌe höjo: God na Abraham Isaac Jacob ëhi muebejëvaje ae jevajëjo. Jemë rabëni ë jö hesi bëhoho bogo avoho baejarije höjo. ");
INSERT INTO aom_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","God-hu Abraham Isaac Jacob muebejëvaje jö hesi bëhoho jabumë vuovoromo bogo ioroꞌioremuoho barëꞌi vaꞌo raromego God-ro muebejëvaje höjo. God bogo vuovoromo ioroꞌioremu barëjëꞌe aribövioho muebejëvoꞌibejajo. Aꞌi hu vuovoromo vaꞌo raromarue aribövioho iae muebejëvaje höjo. Ëhuni ae vuovoromo ioroꞌioremu barëjaje hö uvarujoho ëho sarerivarujëjo. ");
INSERT INTO aom_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Ëhi uëvamu Jew rajo jögoru öri röjëhijarue ae gemuëro rueromo hejade Iesuꞌo Sadducee ariböviohuꞌo jö ahoꞌahamirovamu hejëꞌi röhu gavade Iesuro jö mae mana majëhijamu gagorovo Iesu uavadeje: Na ave jöho ua gaꞌiëꞌajëjo. God-hu bojamuade jögore ahoꞌo jioꞌamajoho di jöhuro jö ioroꞌioroho iosiramiꞌamoromo nuniroho höjo. ");
INSERT INTO aom_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Nuniroho höjamu Iesuro uavadeje: Nunire jö börömoho aveho höjo: Israel ariböviohumë ave jöho hehëjo. Bada nosi God hu gemu börömoho höjo. ");
INSERT INTO aom_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Jasi dë vövöbajoꞌe aruꞌahe uehore daruge ahoꞌobëhe Bada jasi God ma-hu gemu bojaminëjo. ");
INSERT INTO aom_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Ëjöho nuniroho höjo. Röhu ë jö hesi bëhiroho aveho höjo. Jaehu jasi arijoꞌarije rajahirovanuëhi jasi ae gemuoho ëhi rajahinëjo. Jögoru ioroꞌioroho ë jö niöꞌioho bogo iosirëmiromo masijoho jioꞌamoꞌi ë jö niöꞌioho börömo maho jëvajëjo. ");
INSERT INTO aom_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Börömo maho jëvajëjamu hegorovo rue jögoru öri röjëhijaje ahuro Iesu uavadeje: Tisa ja jö mae jövanuëjo. Jaehu uevanuoho: God ma-gemu jioꞌi god gö gö bogohöjo. ");
INSERT INTO aom_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Noehu dë vövöbajoꞌe uehore daruge ahoꞌobëhe ma-hu gemu bojamiromo röhu nosi arijoꞌarije rajahirovaruëhi nosi ae gemuoho ëhi rajahijëꞌoho ëho ma-mabëhe höjo. O mi vënire bueromo God-are örire bojamijëꞌoho o suvuore gö gö hu bojamijëꞌoho ëho ma-jianovajëjo. ");
INSERT INTO aom_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Ma-jianovajëjamu hegorovo Iesuro gavade rue aho simano mae uehorovoromo jövamu gagorovo uavadeje: Jaehu God-are aharire vaꞌo hijego huhu muebejavoꞌiröhoho ja bogo roriꞌoho javoꞌi iae bëhiro javajëjo. Ëhi uavamu hegorovo ae ahoꞌobëhe jöe gö gö ua gaꞌiëꞌaroho juhuonivoromo vuonugareje. ");
INSERT INTO aom_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Vuonugamu Iesuro God-are osa börömore hiromo jögoroho röjëhijadeje. Röjëhiromo uëvadeje: Aveho hehëjo. Böröme namiromo ajëmiꞌiröhe a hesi jöho jövoꞌiëꞌajëjo. Jew rajo jögoru öri röjëhijarue ariböviohuro uvoruomaje höjo: Böröme namiromo ajamuiꞌiröhe aho ma-David-are uje jioꞌaꞌajëjo. Rabëni ëhioho uvoruomaje höjo. ");
INSERT INTO aom_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","God-are Aruꞌahohuro jöho David-are simanore bojamamu jajivoromo uvëꞌe höjo: Bada God-ro nasi Bada uavade höjo: Nasi övo manö rojo hijego jaꞌo muorovarue aribövioho naro ruahöꞌöjëvego hörëro vijuvo taemoꞌamoꞌirane höjo. ");
INSERT INTO aom_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Ëhesi bëhoho böröme namiromo ajëmiꞌiröhe a hesi jöho David-ro jajivoromo uvëꞌe höjo: Bada höjo. Bada hö uvadoho ëhuꞌoho rabëni uvoruomaje höjo: Böröme namiromo ajamuiꞌiröhe aho ma-David-are uje höjo. Ëhi uëvamu ae ahoꞌobëhe huhu majëhijaje jöho heromo nimorohoruomadeje. ");
INSERT INTO aom_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Ëhiꞌamu Iesuro jöho röjëhijuvo röhu uëvadeje: Jemëro Jew rajo jögoru öri röjëhijarue aribövioho gë avohorëjo. Ëhesi bëhoho ë aribövioho jaburo jabesi sinohemu uehorovoromo niögu ëgobövie höruꞌo utahëꞌoho ioꞌamoromo jijiharue ëhi jiëꞌe muoho nimarue höjo aëro gëromo rajëhijöro. O imoꞌamaruire vaꞌëꞌoho jaburo nimarue höjo aëro uvoruomoröhego: Jabumë a masijëro jijihajëromo rajëhiromo jejëmiruomoröhego. ");
INSERT INTO aom_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","O God rajahijarue osare vaꞌëꞌoho o sörö iꞌi vaꞌëꞌoho a masijehu raromaruire ë vaꞌo raromoꞌi nimarue höjo. ");
INSERT INTO aom_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Raromoꞌi nimoromo magonaho doru jabesi bövioho biseꞌoho ëma ujuohëharue höjo. Ujuohoromo sarerivoromo pari ëgobövie jaguvarue höjo aëro gëromo uvojöro: Mu mae vaejaruëjo. Ëhi jiëꞌe sareriꞌe muoho vaejaruego ëhuni God-ro iꞌu börömo mae bojëmiꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Ëhi uënugoromo Iesuro God-are suvuoro bahijarue bëhire ë vaꞌo hijadeje. Hiromo uherihoꞌi gavadeje ae ahoꞌobëhe ijo bajoho ë ioꞌamamu. Bövi biseꞌo marohëꞌe mae jiëꞌe aribövie ahoꞌobëhe jaburo rueromo ijo baje böröme baꞌamoromo vaꞌonövareje. ");
INSERT INTO aom_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Ëhiꞌamu magonaho dorue gemuëro rueromo rövëꞌe ijo baje niöꞌi baꞌamëvadeje. Aꞌi ë monioho ma-biseꞌe jiadeje. ");
INSERT INTO aom_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Baꞌamëvamu Iesuro ëho garomo hesi ijorajo ömoꞌömohuro ruejöro uvëvadeje. Rovamu uëvadeje: Ëbövi biseꞌo marohëꞌe jiëꞌe ariböviohuro ijo baje ahoꞌo ioꞌamoꞌi arue bogo eni jiëꞌe magonahohuro rövëꞌe ijo bajoho niöꞌi baꞌamade höjo. Röhu God-ro ëhi uvajëjo: God-are suvuoro ioꞌamare a ioroꞌiorohuro bisemu bisemu ioꞌamoꞌi ë bogo eni jiëꞌe magonaho doruohuro bövi mae baꞌamade höjo. Na mae uëvajëjo. ");
INSERT INTO aom_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","God-hu ëhi uehorovaje hesi bëhoho ë a ioroꞌiorohuro inömo marohëꞌe maëro jiëꞌëro ma-vituohemu bojamiꞌi ë magonahohuro inömo rumoꞌëro jiëꞌëro hesi i iꞌibejade monioho ahoꞌo bojami barëjëꞌe höjo. ");
INSERT INTO aom_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Ëhiꞌonugoromo Iesuro God-are amo börömore jioromo vaꞌamu gavëꞌi hesi ijorajo ömoꞌöme röhu ae gemuëro Iesu uavadeje: Tisa aruëroho gavëjo. God-are javu masijo vaeꞌamarohuꞌo javu masijo hesi munëhuꞌo ma-mabëhe jioꞌamajëjo. ");
INSERT INTO aom_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Ëhi uavamu uavadeje: Ave munë javu masijoho na jemë gavarujëjo. Ëjavuoho ahoꞌobëhe aëro dadovoruomoꞌiramu munëho ahoromo saꞌaro ruvebi barë nahonahovoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Ëhi uënugoromo Iesuro vaꞌoromo Olives Dahorure ajio hiromo gavadeje God-are amo börömoho anume jiamu. God-are amo börömoho anume jiamu Peter James John Andrew ëho jaburo sivue ajio Iesuꞌo raromoromo uavareje: ");
INSERT INTO aom_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","Ave jöho majahuego hejarëjo. God-are javu masijehu rireromoꞌiröhego uövuanoho ëho divare jioꞌaꞌajëjo. O no mu rabe garomo uvoꞌejarëjo: Ëhi jiëꞌe muoho ahoꞌobëhe rueꞌiëꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Rueꞌiëꞌajëjamu uëvadeje: Gavëꞌiajo. Aëro sarerëmiꞌiramu guaro rireromëvo vaꞌaꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Ae ahoꞌobëhe rueromo sarerëmiromo uëꞌaꞌaruëjo: Nöruare ihoro rovajëjo. God-hu uevëꞌëro böröme namiromo ajëmiꞌirode aho na jevajëjo. Ëhi uëromo ae ahoꞌobëhe sarerëmiꞌiramu uvoꞌaꞌaruëjo: Mae-ëromo guaro rireromoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","O heꞌirarije muorovo jö ruenövo muorovonövamu hejëꞌoho nadi juhuonivorëjo. Öre gö bogojiëꞌëro ëhi jiëꞌe mu sisëho iae jioꞌaꞌajëjo. Röhu saꞌaho bövioho biseꞌoho evaroho bogo barëꞌi ëho hesi majae göro jioꞌaꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Saꞌae göëro göhuꞌo muorovonövo a masijo ioroꞌiorohuro ioroꞌiorohuꞌo muorovonövoꞌaruëjo. Saꞌae dinöꞌe dinöꞌe jiajoho hijiohijiovoꞌamoꞌajëjo. Saꞌae gö gö irunoꞌe bogojioꞌajëjo. Ëhi jiëꞌe huë vavaenoho rueꞌiramu mu sisëho bogo burëroho barëꞌi aꞌi magonahehu aevoromo rahoꞌi haraꞌuajëhi ëhi aho aevoromo huë vavaene börömoho baebe vaꞌoruomoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Röhu gavëꞌi raromorëjo. Aëro guduamo ujuohëvo vaꞌoromo jögoru muebejarue aribövi jabesi övore bojëmiꞌaruëjo. God rajahijarue osa göro göro ë hisuebijëvoꞌaruëjo. Gavana o saꞌare a masijo gö gö jabesi nunire rëmoꞌiramu nasi jöëni ë riravoꞌarujëjo nasi jöho huruoho majëhiꞌi. ");
INSERT INTO aom_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Röhu God-are jö maho aëro saꞌae dinöꞌe dinöꞌe majëhibe vaꞌo barëꞌajëjo. Ëmuoho urimoho jio hesi höjo. Bövi biseꞌo barëꞌiröhe majaho ë hesi ijonö jioꞌaꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Röhu jabuhu guduamo ujuohëvo vaꞌamu a masijo jabesi nunire riravëꞌoho nadi uvorëjo: Na rabu jöe majëhiꞌejöromo nurunurumorëjo. Nadi ëhioho ëꞌi aꞌi a masijo jabesi nunire riravoꞌirarije maja rovamu evare God-hu rabu jö jemesi simanore bojëmëꞌoho ë jöho majëhirëjo. Ëhesi bëhoho bogo jemëhu jöho majëhiꞌirögoro aꞌi God-are Aruꞌahohuro jöho simanore bojëmiꞌiramu jemë ë jöho majëhiꞌarujëjo. ");
INSERT INTO aom_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Röhu öhuro öho ae gö jabesi örire bojëminövoꞌaruëjo muoꞌamojöro. Vavuohuro aboji harihuꞌoho ëhi gemuoho ëꞌaꞌaruëjo. Aboji harihuꞌohuro riꞌöromo ae uëꞌiramu vëmu vavuꞌoho muoꞌamoꞌaruëjo. ");
INSERT INTO aom_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","O jemëhu na uehorovevarujohuni ae ahoꞌobëhe jaburo jemesi örire nue huodëgoruomoꞌajëjo. Röhu ae rahu biririvoromo mae uehorovevobe vaꞌojuvo maja barëꞌiröhe maja rovëꞌiroho God-ro baejëvoromo manö bamëvoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Röhu jemë gaꞌaꞌarujëjo God-are osa ijumaje sisëhuro maehu jiaje röhore ëma namiꞌiramu. Ëjö Iesuhu majëhijadoho adahoromo avoꞌavoho gare. Amo Iesuro jö vituoho majëhiromo uëvadeje: Sisëhuro maehu jiajire ëma namijamu gavëꞌoho ave Judea saꞌare raromaruje aribövioharo huruomoromo dahoruꞌero iojiomorëne. ");
INSERT INTO aom_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Ae rahu javu dönö haradare raromëꞌoho abueromo osare inömoho nadi vaꞌo ujuohoꞌi ma-huruomoromo vaꞌorëne. ");
INSERT INTO aom_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","O mure raromëꞌoho nadi vuonoröꞌö vaꞌo niögoho ujuohoꞌi ma-huruomoromo vaꞌorëne. ");
INSERT INTO aom_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Röhu ë huë vavaeni rueꞌiröhe majaroho dëꞌe magonahohuꞌo aboji harihuꞌo inino jioꞌamëꞌe magonahohuꞌo jabumë vaevëꞌoho diehi huruomoruomoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Röhu God ua garëjo huro ajëmego ëhuro aho niohijo majaroho bogo huruomoꞌiröhe höjo. ");
INSERT INTO aom_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Rabëni hesi bëhoho evare majaroho huë vavaene bogo biseꞌo vaduꞌoho rueꞌaꞌajëjo. Ëhi jiëꞌe huë vavaenoho urimo God-hu saꞌa bövi biseꞌo bamadevaroho bogojiobe ruejuvo ro jaruvo majahuꞌo ëhi jiëꞌe huë vavaenoho bogohöjo. O ijonöhuꞌo bogojioꞌi ë majaho gemu börömoho jioꞌaꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Ëhuë vavaeni maja ëgobövi jiajoho God bogo tarioromo bunemuoho bamoꞌibejajo aho bogo biririvoromo raromoꞌibejajo. Aꞌi God-ro hesi baejëvade aribövioho uehorovëvoromo ë majaho tarioromo bunemu bamoꞌi uvëꞌe höjo. ");
INSERT INTO aom_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Ëhi jiamu ae göehu uëvëꞌoho: Aveho ro gahëjo. O arueho vaꞌo gahëjo. God-hu uavëꞌëro böröme namiromo ajamuiꞌiröhe aho aviae o aruae hö uëvëꞌoho nadi maho uehorovorëjo. ");
INSERT INTO aom_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Ëhesi bëhoho rabëniajo. Ae ahoꞌobëhe rueromo sarerëmiromo uëbe vaꞌaꞌaruëjo: God-hu uevëꞌëro böröme namiromo ajëmiꞌirode aho jevajëjo o jö God-aro baeromo majëhijaje ae jevajëjo. Sarerëmiromo ëhi majëhiromo bogo gavarue mu masijoho vaenövoꞌaruëjo eni jëvego God-hu söjëvade aribövioho sarerëmego rireromoꞌiröhego. ");
INSERT INTO aom_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Röhu jemëro avoho mueberovorëjo. Ijonö jioröhe jöho na urimo majëhijëꞌe jevajëjo. Ëhuni sareriꞌe jöho nadi maho uehorovorëjo. ");
INSERT INTO aom_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Röhu ë huë vavaeni majaho barëꞌiramu evare maja nunoho ramoramovoromo manaeroho duorohoromo ");
INSERT INTO aom_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","jijoho sisërëꞌamoromo öꞌidöre inömoho ahoꞌo arua anumiae vaꞌoꞌamoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Ëhiꞌoꞌiramu saꞌare raromarue ariböviohuro ae ahoꞌobëhe gaꞌaꞌaruëjo God-are A Maho naro darugoꞌo ajiꞌo börömo mae baeromo suere ruvebiꞌiramu. ");
INSERT INTO aom_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Ruvebiromo nasi aneraho rëmöꞌöꞌiramu ro God-hu söjëvade aribövioho gagovëvoꞌaruëjo. Arua anumiae saꞌae dinöꞌe dinöꞌe maja rojomajire bevaꞌajire jioruomajoho gagovëvoꞌaruëjo. ");
INSERT INTO aom_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Röhu meso hesi uhu jöho heromo bëhoho avoho uehorovorëjo. Gavaruje mesoho gumutivoromo rahego garomo evare jemë uvaruje höjo: Jew rajo nosi vama majaho iae dunovajëjo. ");
INSERT INTO aom_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Ëhesi bëhoho jemë gaꞌirarije naehu uëvodëhi mue gö gö rovamu gavëꞌiroho uvorëjo: Ëmajaho iae rovajëjo. ");
INSERT INTO aom_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Ave jöho na jö mae uëꞌiëꞌajëjo. Ave jaruvore raromaruje aribövioho jemë bogo vuovo barëjëꞌiro evare naehu uëvaje mue ahoꞌobëhe rueꞌaꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Öꞌidöe saꞌae bövie biseꞌe barëꞌi nasi jöho gemu bogo barëꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Röhu ë majaho divare jioꞌiröhoho aho bogo gavaruëjo. Öꞌidöre raromarue anerahuꞌo Harihoho naꞌo bogo gaꞌi hesi Vavuohuro gemuëro gavajëjo. ");
INSERT INTO aom_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Avoho mueberovorëjo. Gavëꞌiajo. Jemëꞌo ë majaho bogo gavarujëjo. ");
INSERT INTO aom_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Ëhesi jöho uhuꞌe majëhiꞌiëꞌajëjo avoho heꞌirarijego. Ae gemuëro öre gö vaꞌiëꞌajëjo. Amore jioromo vaꞌiëꞌiroho hesi mu vaejaharue aribövioho ae gö gö mue gö gö bojëmibe vaꞌaꞌajëjo jaburo simane vaeromo ë muoho muebejahoꞌiröhego. Bojëmibe vaꞌoromo hesi osa ojo muebejaje aho uaꞌaꞌajëjo: Ojoho avoꞌavoho muebenëjo. Osa arijoꞌohuro ëhi ëꞌaꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Ëhesi bëhoho na ë osa arijoꞌoho vaꞌëne jevajëjo. Na divare vuonoröꞌö rueꞌirodoho jemë bogo gavarujëjo. Nani vöꞌöꞌe o vahi ririꞌe o sisonuvoꞌi titimoꞌiramu o sisonuvoꞌiramu rueꞌejöjo. Jemë bogo gavarujëjo. Ëhuni muoho avoꞌavoho mueberëjo. ");
INSERT INTO aom_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","O bogo nuni jioromo mu avoho muebejëꞌoho nani na ma-majioho rueꞌi gaꞌejöjo jemë momoröꞌö uroꞌamëꞌe jëvoꞌiramu. ");
INSERT INTO aom_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Na jemë uëvajëhi ae ahoꞌobëhe ëhi gemuoho uëvajëjo: Nune jioromo muoho avoꞌavoho mueberëjo. ");
INSERT INTO aom_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Iae God-hu Vörö Tugohade Sörö o I Dë Huaje Oso Rumoꞌe Sörö jiamëhi iꞌiröhoho jioꞌi röhu jaruvëhi priest masijohuꞌo Jew rajo jögoru öri röjëhijarue ariböviohuꞌo ëho jaburo öre nahareje Iesu saginiëri guduamoromo anoꞌiröhëro. ");
INSERT INTO aom_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Öre nahoromo uarovareje: Sörö majaroho bogo guduamoꞌejarëjo aëro göromo noꞌo muorovojöëni. ");
INSERT INTO aom_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Ëhiꞌamu Iesuro Bethany amore rueromo sino jomoꞌe ae Simon-are osare ro hiromo ie ijadeje. Ie ijamu gagorovo magonahe gemuëro munë huono mabëhe baeromo rovadeje. Ëhuono gagore ridiꞌe osoho jiëꞌe jiadeje. Osoho bogo jovoꞌoho buarohëꞌe ma-oso maemu jiadeje. Oso ihoho nard jiadeje. Röhu hesi manaho bogo biseꞌo vaduꞌoho jiadeje. Magonahohuro ë munë gagore jiaje osoho barueromo munëho hahovoromo Iesuare simanore otehadeje. ");
INSERT INTO aom_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Simanore otehamu gagorovo ae göëro göëro dë vörönëgamu jö sisë atoromo uarovareje: Ëmagonahoho rabëni osoho ëma otehöꞌöjajëjo. ");
INSERT INTO aom_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Aro imoꞌibejarëjo 300 kina iosiramijëꞌe manaho bövi mae baeꞌibejarëjo. Ëmanaho baeromo bövi biseꞌo rumoꞌe aribövioho suvuorëmiꞌibejarëjo. Ëhi jiëꞌoho iae mae jioꞌibejajo. Röhu huro ëma otehöꞌöjade höjo. Ëhi uarovoromo magonahoho birevareje. ");
INSERT INTO aom_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Birevamu hegorovo Iesuro uëvadeje: Ëmagonaho birevarujoho vuonugohëjo. Jemë rabëni magonahoho huë vavaenoho bojamijarujëjo. Huro na mabëhe avohevëꞌe höjo. ");
INSERT INTO aom_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Bövi biseꞌo rumoꞌe ariböviohuro jemëꞌo raromobe jijihoꞌaruëjo. Jemesi nimoromo jabumë ajëmijëꞌoho iae jemë eni jëvaje höjo. Aꞌi naro jemëꞌoho bogo hibe juvoꞌejöjo. Ijonö ëhi avohevoꞌirarijoho bogo eni jëvoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Ëmagonahohuro rabe eni jiadoho ëho nasi örire mae avohevade höjo. Mae avohevoromo oso nasi sinore otehade hesi bëhoho nasi sinoho avohehade höjo ëhuro nasi sinoho mae jevego aëro hure bamevoruomoröhego. ");
INSERT INTO aom_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Ave jöho na jö mae uëꞌiëꞌajëjo. Saꞌae dinöꞌe dinöꞌe aehu nasi jö ma majëhibe jijihëꞌiroho ë magonahehu ëꞌade jöhuꞌo majëhibe jijihoꞌaruëjo aëro hu mae uehorovoruomoröhego. ");
INSERT INTO aom_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Ëhiꞌamu Iesuare ijoraje 12 röhu gemuëro Judas Iscariot-ro vaꞌoromo priest masijoho uëvadeje: Jemë nëgëꞌoho na Iesu jemesi övore bojëmiꞌejöjo. ");
INSERT INTO aom_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Bojëmiꞌejöjamu hegorovo nimorohoromo uavareje: Iae mae höjo. Ëhi jiëꞌoho no ijo baje mana bojamiꞌejarëjo. Ëhi uavamu hegorovo Judas-ro öre nahadeje Iesu jabesi övore bojëmiꞌiröhëro. ");
INSERT INTO aom_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","I Dë Huaje Oso Rumoꞌe I ibe vaꞌiröhe majaho aevoromo rovadeje. Aevoromo rovaje majaho rueꞌego Jew rajëro sheep harihoho muoꞌamonövareje God-hu Vörö Tugohade Söröho iꞌiro. Amo ë majaho rovamu gagorovo Iesuare ijorajoho jaburo Iesu uavareje: Ja nagajoho no dinöꞌe vaꞌoromo söröho avohahoꞌejarëjo. ");
INSERT INTO aom_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Avohoꞌejarëjamu Iesuro hesi ijorajoho niöꞌi uëvadeje: Jerusalem amo börömoro vaꞌorëjo. Vaꞌi gaꞌaꞌarujëjo aëro jovoꞌe ramaho simanëro baeromo ro birohëvoꞌiramu. ");
INSERT INTO aom_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Ro birohëvego vaꞌoromo gaꞌirarije hu di osare rumo vaꞌego gagorovo jemëꞌo ë osaro vaꞌoromo osa arijoꞌoho uarëjo: Tisahuro uvade höjo: Osaho dinöꞌe höjo naehu nasi ijorajoho jabuꞌo gemu mae sörö iꞌirodoho. Ëhi uarëjo. ");
INSERT INTO aom_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Ëhi uaꞌiramu osa arijoꞌohuro jemë huꞌiraejëvoromo vuahure ajiomoromo döre osa börömoho röjëhiꞌaꞌajëjo. Röjëhiꞌiramu gaꞌaꞌarujëjo maratue bövie biseꞌe eni avohoromo bahijëꞌe jioꞌiramu. Ëhi jiamu gavëꞌiroho ë diröꞌoro söröho avohorëjo jemëꞌo noꞌo ë iꞌiröhe. ");
INSERT INTO aom_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Ëhi uëvamu rue ae niöꞌiohuro riꞌöromo Jerusalem vaꞌareje. Vaꞌoromo gavare Iesuhu uëvadëhi bövioho biseꞌoho ëhi jiamu gagorovo söröho avohareje. ");
INSERT INTO aom_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Ëhiꞌamu vahiromadeje. Vahiromamu gagorovo Iesuro hesi ijoraje 12-ho jabuꞌo gemu mae rovadeje. ");
INSERT INTO aom_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Rueromo ioho ijëꞌi Iesuro uëvadeje: Ave jöho na jö mae uëꞌiëꞌajëjo. Jemë ae gemuëro na bijönegarue aribövi jabesi övore bojëmiꞌanuëjo. Ëaho ja aviae naꞌo ie ijanuëjo. ");
INSERT INTO aom_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Ie ijanuëjamu hegorovo jaburo uehore gö gö baeromo ae gemuëro gemuëro uavareje: Na bogo ëhioho ëꞌejöjo. Na na mae uavajëjo. ");
INSERT INTO aom_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Mae uavajëjamu hegorovo uëvadeje: Ae ahoꞌobëhe 12 röhu gemu naehu i hevöre baꞌamoꞌego huꞌo gemuore baꞌamaje ahuro ë mu sisëho vaeꞌaꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","God-are surire jajivarëhi hesi A Maho na ëhi guomevoꞌajëjo. Röhu na bijönegarue aribövi jabesi övore bojëmiꞌiröhe aho vaevëꞌoho sisërëꞌajëjo. Ëaho bogo rahoꞌibejajo ëhuro mae jioꞌibejajo. ");
INSERT INTO aom_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Ëhi uënugoromo ioho ueꞌahoromo Iesuro ioho baeromo God mae uanugoromo atoꞌatovoromo hesi aribövioho suvuorëmiromo uëvadeje: Baehëjo. Aveho nasi sine höjo. ");
INSERT INTO aom_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Ëhiꞌonugoromo enatuore jovoho baeromo God mae uanugoromo bojëmadeje. Bojëmamu ae ahoꞌobëhe ë jovoho ibe rovaꞌareje. ");
INSERT INTO aom_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Ibe rovaꞌamu Iesuro uëvadeje: Aveho nasi köe höjo. Ae ahoꞌo jemesi jöëni köho rovevoromo guomevoꞌajëjo. Guomevoꞌiramu ëhuro God-hu jemë muebejëvoꞌiröhe jögoroho marëꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Röhu ave jöho na jö mae uëꞌiëꞌajëjo. Na ijoho öꞌi bajo jovoho bogo iꞌejöjo hujeji ëho majaho rovego evare na God-hu muebejaje öri ariꞌere hiromo öꞌi bajo jovo iꞌoho iꞌirodëni. ");
INSERT INTO aom_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Ëhi uënugoromo God rajahijarue jöho ioruomoromo suorovo vaꞌoromo Olives Dahorure iojiomareje. ");
INSERT INTO aom_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Olives Dahorure iojiomoromo Iesuro hesi aribövioho uëvadeje: Jemë ae ahoꞌobëhe nasi örire mae uehorovevarujoho vuonugoꞌi remo vaꞌaꞌarujëjo. Ëhesi bëhoho God-are surire jöho jajivoromo uvëꞌe höjo: Sheep muebeꞌamaje aho God naro anoꞌejöjo. Anoꞌiramu huhu muebeꞌamade sheep-oho jaburo arua anumiae vaꞌoꞌamoꞌajëjo. God-are jö jiajëhi ëhi remo vaꞌaꞌarujëjo. ");
INSERT INTO aom_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Remo vaꞌiramu guomoromo riꞌönugoromo naro urimo Galilee vaꞌejöjo. Jemë ijore öꞌaꞌarujëjo. ");
INSERT INTO aom_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Ëhi uëvamu Peter-ro riꞌöromo uavadeje: Nani a ioroꞌioroho jasi örire uehorovaruoho vuonugoꞌi ramo vaꞌaꞌaruëjo röhu na bogo ëhioho ëꞌejöjo. ");
INSERT INTO aom_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Bogo ëhioho ëꞌejöjamu Iesuro Peter uavadeje: Ëhi uevanuëjo röhu ave jöho na jö mae uaꞌiëꞌajëjo. Jaruvo vahire kökörökoho bogo urimoho vae niöꞌi uvëꞌe jero urimo vae niöꞌi gemu ae uëꞌaꞌanuëjo: Na Iesu bogo gavaje höjo. ");
INSERT INTO aom_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Ëhi uëꞌaꞌanuëjamu hegorovo Peter-ro ma-darugoꞌo uavadeje: O na bogo ëhioho ëꞌejöjo. Aehu anegamu jaꞌo gemuore guomoꞌiëꞌiroho na bogo ëhioho majëhiꞌejöjo. Bogo majëhiꞌejöjamu Iesuare aribövi ioroꞌioroho ahoꞌo jabuꞌo ëhi gemuoho Iesu uaruomadeje. ");
INSERT INTO aom_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Ëhi uanugoromo Iesuꞌo hesi ariböviohuꞌo vaꞌoromo öri ariꞌo ihe Gethsemane rovareje. Rueromo Iesuro uëvadeje: Avehuro raromohego na aruëre vaꞌoromo God-are örire jöe jövöjo. ");
INSERT INTO aom_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Ëhi uënugoromo Peter James John ëhi sö ujuoho vaꞌoromo hesi dë vövöbajoꞌo uhure huë vavaene ahoꞌo rovamu sisë maro nurunurumadeje. ");
INSERT INTO aom_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Nurunurumoromo uëvadeje: Na sisë maro huë vavaene baejevajëjo. Ëhuro guomevo hesi höjo. Ëhuni nadi momoröꞌöꞌi ma-nune jioromo naꞌo gemuoro avoho mueberovëꞌe raromohëjo. ");
INSERT INTO aom_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Ëhi uënugoromo roriꞌo ëgoꞌo vaꞌoromo saꞌare behumoromo God ëninamijadeje ëhuro eni jiego viꞌehoho bogo baeꞌiröhëni. ");
INSERT INTO aom_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Ëninamiromo uavadeje: Apo mue ahoꞌo vaeꞌiranoho ja eni javajëjo. Ëhuni iꞌue huë vavaene nasi örire rovajoho ahego na bogo baeꞌiröjo. Röhu naehu nimajoho nadi ëꞌi jaehu nimanuëhi ëhi ëꞌonëjo. ");
INSERT INTO aom_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Ëhi ëninaminugoromo vuonoröꞌö rueromo gavade hesi ae niöꞌi gemu momoröꞌöjamu gëgorovo Peter uavadeje: Simon-ajo. Rabëni niavanuëjo. Majae ma-bunemu nune jioromo mueberovëꞌe hiꞌiranoho ja diehiꞌoromo bogo eni javajëjo. ");
INSERT INTO aom_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Jemëro nune jioromo mueberomo ëninamihego God-ro ajëmego Satan-ro bogo dinëmego ëhuro bogo bejëvoꞌirajo. Jemesi aruꞌahoho mu mae vaeꞌi nimoꞌi jemesi sino hahoꞌoho uꞌuhëꞌe höjo. ");
INSERT INTO aom_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Ëhi uënugoromo röhu maho vaꞌoromo urimo ëninamiromo uavade jöe gemuoho ëninamijadeje. ");
INSERT INTO aom_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Ëninaminugoromo vuonoröꞌö rueromo gavadeje jabumë nunëhimoꞌamoꞌego momoröꞌöjamu. Rueho jaburo momoröꞌöjëꞌëro riꞌöromo Iesuare örire jö mana uaꞌiröhoho dadivëvadeje. ");
INSERT INTO aom_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Dadivëvamu Iesuro urimëꞌi vae niöꞌi vaꞌoromo ëninamijadoho röhu maho vaꞌoromo ëninamijadeje. Ëninaminugoromo rueromo uëvadeje: Jemë diehiꞌoromo ma-momoröꞌöemu momoröꞌöjarujëjo. Iae minoꞌëjo. Iae barëjajëjo. Majaho mamiꞌe rovëꞌe höjo. Aëro God-are A Maho na bijönegarue aribövi jabesi övore bojëmiꞌiëꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Riꞌöromo go vaꞌohego vaꞌarëjo. Gahëjo. Na bijönegarue aribövi jabesi övore bojëmiꞌiröhe aho rovajëjo. ");
INSERT INTO aom_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Ëhi uëvamu gavëꞌi Judas rovadeje. Iesuare ijoraje ahoꞌobëhe 12 röhu Judas huꞌo jabesi ae gemuoho jiadeje. Judas rovamu ae ahoꞌobëhe siravae kepatae ujuohoromo huꞌo rueruomadeje priest masijohuꞌo Jew rajo jögoru öri röjëhijarue ariböviohuꞌo a duvaho ioroꞌiorohuꞌo ëho jaburo rëmöꞌöjëꞌëro. ");
INSERT INTO aom_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Röhu urimëꞌi ë sareriꞌe aho Judas-ro ë aribövioho uëvadeje: Gaꞌirarije naro di aho dudöhamu gavëꞌoho uvorëjo: Iae Iesu höromo guduamoromo huꞌiraeromo avoho muebebe vaꞌorëjo. ");
INSERT INTO aom_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Judas-ro ëhi uëvëꞌëro huro rueromo ma-burëro ro Iesu jejamiromo Bada uavëꞌi dudöhadeje. ");
INSERT INTO aom_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Dudöhamu gavëꞌi ë ariböviohuro Iesu guduamareje. ");
INSERT INTO aom_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Guduamamu ae gemu Iesuare bëhire namijadohuro hesi kaejöho jijöromo priest börömo hesi mu vaejaje aho anoromo hiaꞌoho tariöꞌöjahadeje. ");
INSERT INTO aom_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Ëhiꞌamu Iesuro ë rueruomade aribövioho uëvadeje: Aveho na bogo vajiohuꞌe ananoꞌe aehu jevajëjo. Jemë rabëni siravaho kepataho ujuohoromo guduamevoꞌi rovarujëjo. ");
INSERT INTO aom_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Mamiꞌe majae ahoꞌo naehu God-are amo börömore hiromo God-are jö hesi öri a röjëhinövodoho jemë evaroho bogo guduamevarije höjo. Röhu jemëhu vaejaruje muoho ë hesi jö God-are surire jajivarëhi muoho ëhi jioröhego ëhuni ave muoho rovëꞌe höjo. ");
INSERT INTO aom_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Ëhi uëvamu hesi ijoraje ahoꞌobëhe hu nugoꞌi huruomoromo vaꞌareje. ");
INSERT INTO aom_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Vaꞌamu a iꞌe gemuëro niöge hane gemu ruohëꞌe Iesuare ijore vaꞌadeje. Iesuare ijore vaꞌamu aëro guduamoꞌiaꞌamu ");
INSERT INTO aom_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","niögoho jaho buꞌönugoromo dëꞌahobatëremu juꞌebiromo vaꞌadeje. ");
INSERT INTO aom_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Ëhiꞌamu Iesu huꞌirae rueromo priest börömo hesi osare rovareje. Ëosare priest masijoho a duvaho ömoꞌömoho jögoru öri röjëhijarue aribövioho ë aribövioho ahoꞌobëhe jaburo ë gemuoro gagovareje. ");
INSERT INTO aom_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Iesu priest börömo hesi osare barovamu Peter-ro arue riribövire Iesu rihiromoromo priest börömo hesi osare rovadeje. Rueromo osare rumo vaꞌoromo abo osa ririre ruë numë javue vaeꞌi riroho ma-vaꞌoraho nugarire ë vaꞌoromo priest hesi mu vaeruomaje ariböviohuꞌo gemuore hiromo vënoho jurovadeje. ");
INSERT INTO aom_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Ëhiꞌamu priest masijohuꞌo a masijo ioroꞌiorohuꞌo ae nahareje jaburo huruoho majëhiromo uëröhego: Iesuro ëhi jiëꞌe mu sisëho vaejamu gavare höjego heromo Iesu anego guomoröhego. Nahareje röhu jö sisëho bogo birohareje. ");
INSERT INTO aom_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Ae ahoꞌo sarerëmiromo Iesuare jö sisëho majëhiromo ae göëro göëro jöe gö gö majëhijareje. ");
INSERT INTO aom_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Ae göëro göëro jöe gö gö majëhijuvo a ioroꞌiorëro riꞌöromo sarerëmiromo Iesuare jö sisëho huruoho majëhiromo uëvareje: ");
INSERT INTO aom_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","Ëahuro ëhi uvavohijajo: Ave God-are javu börömoho naro dadovoꞌejöjo. Dadovoromo majae niöꞌi gemu hesi uhure javu iꞌoho vaeꞌejöjo. Urimore javuoho aëro övëro vaejare höjo. Aꞌi ijore javuoho ëho bogo övehu vaejëꞌoho jioꞌaꞌajëjo. Ëhi uvade höjo. ");
INSERT INTO aom_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Jöho ëhi majëhijareje röhu jabuꞌo jöe bogo gemuoho majëhiꞌi ae göëro göëro jöe gö gö majëhijareje. ");
INSERT INTO aom_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Jöe gö gö majëhijamu hegorovo priest börömohuro riꞌöromo ae ahoꞌobëhe jabesi nuninö vaꞌo namiromo Iesu uavadeje: Na ja jö mana uöꞌiranoho bogojavajëjo. Aehu jasi jö sisë majahuijaruoho na ëho mae o sarere höjo. ");
INSERT INTO aom_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Mae o sarere höjamu Iesuro jöho bogo mana uaꞌi ma-jörume namijadeje. Jörume namijamu priest börömohuro röhu maho jöe gö buꞌöromo bijioho garomo uavadeje: Böröme namiromo ajamuijanue aho na ja javajëjo. Na ja noehu rajahijarue A hesi Harihoho javajëjo. ");
INSERT INTO aom_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Javajëjamu uavadeje: Iae na ë aho jevajëjo. Röhu uꞌemu jemëro geꞌaꞌarujëjo God-are A Maho naro darugo eni jiëꞌe A hesi övo manö hiꞌiramu. Öꞌidöre jioꞌamaje suehuꞌo gemu mae ruvebiꞌiramu. ");
INSERT INTO aom_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Ëhi uavamu hegorovo rue priest börömohuro hesi niögoho dadovoromo uëvadeje: Iae eni jiëꞌe höjo. A göho rabëni rueromo hesi jöho huruoho majahuijörajo. Iae no eni hejëꞌe javuajëjo. ");
INSERT INTO aom_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","God-are iho ijumajoho jemëꞌo iae hejarujëjo. Ëhuni jemë diehi uehorovarujëjo. Diehi uehorovarujëjamu uavareje: Jö sareriꞌe aego anoꞌiramu guomoꞌaꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Ëhi uanugoromo a ioroꞌiorëro riꞌöromo Iesu sabëro ödivoromo nunoho tugohahoromo övo mugö mugöëro anareje. Anoromo sivoromo uavareje: Na jö God-aro baeromo majëhijaje ae jevajë uövuanue javaje ëhuni anagare aribövi jabesi ihoho huruoho majahuijego hejarëjo. Ëhi uavamu Iesu atovarue ariböviohuro Iesu baeromo sisë maro anoꞌi arijareje. ");
INSERT INTO aom_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Ëhiꞌamu Peter-ro anume aehu raromaruire ë hijadeje. Hijamu priest börömo mu ajamijarue magonahoho röhu gemuëro rovadeje. ");
INSERT INTO aom_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Rueromo gavade Peter hiromo vëne jurovamu gagorovo ërimahoromo uavadeje: Jaꞌo Nazareth amo rajo ae Iesuꞌo gemu mae javade höjo. ");
INSERT INTO aom_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Javade höjamu Peter-ro magonahoho sareramiromo uavadeje: Jaehu jövanue jö hesi bëhoho na bogo garomo bogo hejajëjo. Ëhi uanugoromo ojonö vaꞌo namijadeje. Namijamu kököröke uvadeje. ");
INSERT INTO aom_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Amo Peter-ro ëhi namijamu gagorovo priest börömo mu ajamijaje magonahohuro Peter garomo hesi bëhire riravarue aribövioho uëvadeje: Ëaho Iesuare aribövi jabesi ae gemuoho höjo. ");
INSERT INTO aom_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Iesuare aribövi jabesi ae gemuoho höjamu Peter-ro röhu maho sareramiromo uavadeje: Na bogajo. Ëhi uavadoho ririvanovamu bëhire riravaroho jaburo Peter uavareje: Iae mae-ëjo. Iesuare aribövi jabesi ae gemuoho javajëjo. Jaꞌo huꞌo Galilee saꞌa raje jëvëꞌego ëhuni uavaruëjo. ");
INSERT INTO aom_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Uavaruëjamu Peter-ro uëvadeje: Na jemë sarerëmijëꞌoho iꞌue baejöëni ëhuni na jö mae uëvajëjo. Jemëhu uevaruje aho na bogo gavaje höjo. ");
INSERT INTO aom_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Bogo gavaje höjamu gavëꞌi kököröko urimo vae gemu uvadoho röhu maho uvadeje. Uvamu hegoro Peter-ro uehorovoromo uvadeje: O mamiꞌe Iesuro uevade höjo: Kökörökoho bogo urimoho vae niöꞌi uvëꞌe jero urimo vae niöꞌi gemu ae uëꞌaꞌanuëjo: Na Iesu bogo gavaje höjo. Ëhi uehorovoromo sisë maro nivadeje. ");
INSERT INTO aom_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Iae sisonuvoꞌiaꞌamu gagorovo priest masijohuro a duvaho ömoꞌömohuro Jew rajo jögoru öri röjëhijarue ariböviohuro jö mevarue a masijo ioroꞌiorohuro ëho jaburo gemuore gagovoromo jöe mevoromo uvoruomadeje: No Iesuare örire ëhi ëhi ëꞌejarëjo. Ëhi mevoromo eni jiamu gagorovo Iesu tövoromo bavaꞌoromo Pilate-are övore bamareje. ");
INSERT INTO aom_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Bamamu Pilate-ro Iesu uavadeje: Na ja Jew rajo jabesi a börömoho javajëjo. Javajëjamu Iesuro uavadeje: Ëjöho jero jasi jövanuëjo. ");
INSERT INTO aom_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Ëhi uavamu priest masijohuro Pilate sareramiromo Iesuare jö sisëho ahoꞌobëhe huruoho majahijareje. ");
INSERT INTO aom_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Majahijamu Pilate-ro Iesu röhu maho jöe ua garomo uavadeje: Jasi jö sisë ahoꞌobëhe majehijaruoho ja hejanuëjo. Na ja jö mana majëhiꞌiranoho bogojavajëjo. ");
INSERT INTO aom_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Bogojavajëjamu Iesu jöho bogo mana majëhamu Pilate-ro uvadeje: Diehiꞌoromo jöho bogo jövajëromo tiöjadeje. ");
INSERT INTO aom_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Röhu God-hu Vörö Tugohade Sörö maja rovëꞌiroho savoji gagore raromarue aribövioho di aho jiovo nugöꞌöjöro aehu uvoruomëꞌoho Pilate-ro ë aho jiovo nugöꞌönövadeje. ");
INSERT INTO aom_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Röhu ae gemu hesi ihe Barabbas savoji gagore hijadeje. Urimëꞌi saꞌare a masijohuꞌo muorovare majaho jiamu ae ahoꞌo saꞌare a masijohuꞌo muorovoromo ae muoꞌamareje. Ae muoꞌamëꞌëro savoji gagore raromareje. Röhu ae gemu Barabbas jiadeje. ");
INSERT INTO aom_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Barabbas savoji gagore hijamu amonö gagovoromo riravare aribövioho ae ahoꞌobëhe jaburo rueromo Pilate uavareje: Savoji gagore raromaruoho noehu uavego jiovo nugöꞌöjahuanuëhi ëhi ëꞌonëjo. ");
INSERT INTO aom_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","10","Ëhi ëꞌonëjamu Pilate-ro gëromo uvadeje: Iesuare ihoho bövie jiëꞌego priest masijohuro dë vörönëgamu nasi övore bojemijare hö uvoromo uëvadeje: Na jemë nëgajëjo naro Jew rajo jemesi a börömoho jiovo nugöꞌöjöro. ");
INSERT INTO aom_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Ëhi uëvamu priest masijohuro ae ahoꞌobëhe biririvoromo dinëmijamu hegorovo jaburo uvoruomadeje: Iesu vuonugoꞌi Barabbas jiovo nugöꞌöjëjo. ");
INSERT INTO aom_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Ëhi uvoruomamu hegorovo Pilate-ro uëvadeje: Ëhi jiëꞌoho jemëhu uvarujoho: Jew rajo nosi a böröme hö uvaruje ë aho na diehiꞌoꞌejöjo. ");
INSERT INTO aom_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Diehiꞌoꞌejöjamu uvoruomadeje: Korosioro anego guomajo. ");
INSERT INTO aom_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Guomajamu Pilate-ro uëvadeje: Rabëniajo. Diehi jiëꞌe mu sisë vaejëꞌe höjo. Vaejëꞌe höjamu ma-darugo maꞌe uvoꞌi arijareje: Korosioro anego guomajo. ");
INSERT INTO aom_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Guomajamu hegorovo Pilate-ro ë aribövioho ahoꞌobëhe sanuëmiꞌi nimamu Barabbas jiovo nugöꞌöjadeje. Barabbas jiovo nugöꞌöꞌi Iesu hisuebijöro uënugoromo uëvadeje: Ave aho bavaꞌoromo korosioro anohego guomajo. ");
INSERT INTO aom_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Ëhi uëvamu rue muorovo ariböviohuro Iesu huꞌirae bavaꞌoromo gavanare osa börömore vaꞌareje. Osa börömo hesi ihoho praetorium uvonövareje. Vaꞌoromo jabesi muorovo ariböviohuni jöe nugöꞌöromo uëvareje: Jemë ahoꞌo avehuro ro gagovohëjamugo ro gagovareje. ");
INSERT INTO aom_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Gagovoromo Iesu sivoꞌirögoro saꞌare a masijehu kavuëꞌe niögu ëgo ioꞌamoromo mu vaejarue ëhi jiëꞌe niögoho Iesu baꞌamahareje. Baꞌamahoromo a masijehu bosö didiꞌarue ëhi jiëꞌe bosöho Iesuare simanore didiꞌahareje. Röhu bogo inömo maho baeromo bosöho avohahoꞌi bibëꞌe ijo hisuoho ujuohoromo huoromo simanore baꞌamahareje. ");
INSERT INTO aom_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Ëhiꞌonugoromo sivoromo jejamiromo uavareje: Jew rajo jabesi börömoho vaevëꞌe hijanuëjo. ");
INSERT INTO aom_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Vaevëꞌe hijanuëromo ijahëro simanore anoromo sabëro ödivoromo ëma sarere ague aho raromoromo rajahijareje. ");
INSERT INTO aom_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Ëhi sivoruomoromo niögu ëgoho jijövahoꞌi hesi niögu maho ioꞌamahoromo osare jioromo huꞌirae bavaꞌareje korosire ano taemoꞌi. ");
INSERT INTO aom_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Bavaꞌoromo örire vaꞌihö gavareje ae gemu hesi ihe Simon muro jiëꞌëro rovamu. Röhu Simon hu Cyrene saꞌa rajo ae jiadeje. Hu Alexanderꞌo Rufusꞌo jabesi vavue jiadeje. Amo Simon-ro örire rovamu gagorovo muorovo ariböviohuro hu garomo övëro bijimöꞌöromo uavareje: Ave a hesi korosioho baeromo vaꞌëjo. ");
INSERT INTO aom_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Baeromo vaꞌëjamu ejëhoromo baeromo jabumë ahoꞌo vaꞌaroho ajiomoromo saꞌa ihe Golgotha nosi huëhu huotovëꞌoho simano gijo vaꞌëne saꞌare ë ajio suorovareje. ");
INSERT INTO aom_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Suorovonugoromo wine jovohuꞌo myrrh osohuꞌo buaroharoho Iesu bojamareje hesi viꞌehoho bisemu uꞌuhoröhego. Bojamamu juahëmadeje. ");
INSERT INTO aom_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Juahëmamu korosire ano taemareje. Ano taemoromo hesi niögoho adovoromo ajajovareje gaꞌi di aho di niögoho bae hesi jiego. Ajajovonugoromo niögoho ujuohareje. ");
INSERT INTO aom_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Röhu Iesu korosire ano taemare majaho 9 oꞌclock sisonuꞌe jiadeje. ");
INSERT INTO aom_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","O Iesuare jö sisëho jajivoromo ëhi uvëꞌe jiareje: Ave aho Jew rajo jabesi a börömoho höjo. ");
INSERT INTO aom_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Röhu aëro ananoꞌe vajiohuꞌe ae niöꞌi jabuꞌo korosire ano taemëvoromo göho ruëhi Iesuare övo manö göho viëhi övo adonö ëhi amëvareje. ");
INSERT INTO aom_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Amëvamu Iesu ë a sisë niöꞌi jabesi ririre korosire iromadeje. A sisë jabesi ririre iromadohuro ëhuro ëhi ëꞌiröhego God-are surire jö aehu jajivadëhi iae ëhi jiadeje. God-are surire jöho jajivoromo uvëꞌeje: Aëro uvoruomëꞌe höjo: Hu jö ahoruomaje ariböviohuꞌo gemuore höjo. ");
INSERT INTO aom_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Ëhiꞌamu aëro rovaꞌëꞌi uvene hijiohijiovoromo sivoromo uvoruomonövadeje: Asëꞌe sareri ae javajëjo. Jero uvane höjo: Naro God-are osa börömoho dadovoromo majae niöꞌi gemu hesi uhure röhu maho vae barëꞌejöjo. ");
INSERT INTO aom_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Ëhi uvëꞌe javaje ëhuni jasi sinoho ajamirovoromo korosire javajoho ruvebijëjo. Sivoromo ëhi uvoruomadeje. ");
INSERT INTO aom_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Jabuhu sivarëhi priest masijohuꞌo jögoru öri röjëhijarue ariböviohuꞌo ëhi sivoromo uarovareje: Ëahuro uövuade höjo: Naro a ioroꞌioroho ajëmego marëjëvaje höjo. Ëhi uövuade höjo röhu hesi sino ajamirovëꞌoho hu bogo eni höjo. ");
INSERT INTO aom_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Huro uövuade höjo: Böröme namiromo jemë ajëmaje aho na jevajëjo. Israel rajo jemesi börömoho na jevajëjo. Ëhuni nadiꞌego hu korosire jioromo ruvebijego no garomo hu mae uehorovarëjo. Ëhi uarovamu ë ae niöꞌi hesi bëhire korosiꞌo amëvare aho jabuꞌo Iesu sivareje. ");
INSERT INTO aom_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Ëhiꞌamu maja ririre öri ariꞌe ahoꞌo ramoramovadeje. Ramoramovobe vaꞌojuvo majae huotorovamu gavëꞌi ajivadeje. ");
INSERT INTO aom_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Majae huotorovoromo ajivamu gavëꞌi Iesuro Jew rajo jabesi jöëro ma-darugoꞌo uvadeje: Eloiajo. Eloiajo. Lema sabaktaniajo. Nosi jöehu huotovëꞌoho God nasi Böviohajo. God nasi Böviohajo. Ja rabëni remo vaꞌane höjo. ");
INSERT INTO aom_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Remo vaꞌane höjamu bëhire riravare a ioroꞌiorohuro hejare uvavamu: Eloia uvamu heromo uarovareje: Ëho hehëjo. Elijah-ni uvajëjo. ");
INSERT INTO aom_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Ëhi uarovoromo ae gemuëro tutuvo vaꞌoromo uꞌuhëꞌe inömoho barueromo niogaꞌiꞌe wine jovore baꞌamoromo rumorovamu ioromo ijaho viture bijiohoromo Iesu bojamiꞌiëꞌadeje. Bojamiꞌiëꞌoromo aribövioho uëvadeje: Nadiꞌego no gavarëjo Elijah-ro God-arire jioromo ro Iesu juvo baruvebijego o bogo. ");
INSERT INTO aom_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Ëhi uëvamu Iesuro jöꞌe dadovoromo guomadeje. ");
INSERT INTO aom_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Guomamu gavëꞌi God-are osa börömo ojo göho gagonö jiajoho niögehu tugoharoho arorovo ruvebijadeje. ");
INSERT INTO aom_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Ëhiꞌamu muorovo simano vaejaje ahuro Iesuare nuninö namiromo gavade Iesu ëhiꞌoromo guomamu gagorovo uvadeje: Iae mae-ëjo. Ave aho God-are Harihe jiade höjo. ");
INSERT INTO aom_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Ëhiꞌamu magonaho ömoꞌömohuro arue riribövire riravoromo Iesu diehiꞌaruoho garuomadeje. Mary Magdalene o Mary göho James a iꞌo o Joses jabesi vëmoho o Salome o magonaho ioroꞌioroho ëhi jioruomadeje. ");
INSERT INTO aom_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Urimëꞌi Iesu Galilee saꞌare hijadevare evare ë magonaho ömoꞌömohuro bövie biseꞌe ajamibe hesi ijore ijore jijihonövareje. Ëhi ëꞌëꞌëro ë magonahohuꞌo magonaho ioroꞌiorohuꞌo ahoꞌobëhe Jerusalem amore huꞌo gemu mae rovëꞌëro ë riravoromo garuomadeje. ");
INSERT INTO aom_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Röhu ë majaho bövi biseꞌo avohoꞌamarue majae jiadeje nëröho nuhoromo God rajahiꞌiröhëro. Ëmajaho garoboꞌe bamadeje. ");
INSERT INTO aom_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Nuho majae rueꞌiaꞌamu majae garoboꞌe bamamu gagorovo Arimathea amo raje ae gemu hesi ihe Joseph-ro vaꞌadeje. Hu Jew rajo jabesi a duvahëro jiëꞌëro Jew rajo a masijo ioroꞌiorohuꞌo hiromo jöe mevonövadeje. Jöe mevoꞌego ae ahoꞌobëhe hesi örire mae uehorovonövareje. Röhu ae göehu göehu ëꞌaruëhi huꞌo ëhi muebejëꞌe hijadeje God-ro ro böröme namiromo ahoꞌobëhe muebejëvoröhego. Joseph ëhi jiëꞌe ae jiadeje. Ëhi jiëꞌe aëro jiëꞌëro huro biririvoromo vaꞌoromo Pilate uavadeje: Uevego na Iesuare sinoho baeꞌiröjo. ");
INSERT INTO aom_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Iesuare sinoho baeꞌiröjamu Pilate-ro tiöromo uvadeje: Iesu diehiꞌoromo ma-burëroho guomade höjo. Ëhi uvoromo jöe nugöꞌöjamu Iesu muebejade muorovo ahuro rovadeje. Rovamu Pilate-ro uavadeje: Na Iesu mamiꞌe guomëꞌe höjo. ");
INSERT INTO aom_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Guomëꞌe höjamu ruehuro uavadeje: Iae guomëꞌe höjamu hegorovo Joseph uavadeje: Jaehu Iesuare sino baejëꞌoho iae mae höjo. ");
INSERT INTO aom_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Iae mae höjamu Joseph-ro vaꞌoromo niögu mabëhe imoromo guomëꞌe sinoho baruvebiromo niögohuro numadeje. Niögohuro numoromo munë ubuvarire ë bamadeje. Bamoromo munë höhö barueromo ojoho tugohadeje. ");
INSERT INTO aom_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Ëhiꞌamu Mary Magdaleneꞌo Joses-are vëmoho Maryꞌo jaburo niöꞌiro ariromo gavareje Iesu ë diröꞌore bamamu. ");
INSERT INTO aom_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Iae Jew rajo jabesi nuho majaho barëjadeje. Jew rajo jabesi nuho majaho barëjamu Mary Magdalene o Mary göho James-are vëmoho o Salome ëho jaburo vaꞌoromo ridiꞌe osoho imareje vaꞌoromo Iesuare sinore otehoröhëro. ");
INSERT INTO aom_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Imëꞌëro hura börömore sueꞌo majae rojomamu gagorovo riꞌöromo Iesuare sino bamarire vaꞌareje. ");
INSERT INTO aom_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Vaꞌëꞌi uarovareje: Raro ojo tugohare munëho roriꞌo höhö baejahuo vaꞌaꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Ëhi uarovoromo avoho gaꞌi gavareje mamiꞌe roriꞌo bavaꞌëꞌe jiamu. Röhu ë munëho böröme jiadeje. ");
INSERT INTO aom_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Bavaꞌëꞌe jiamu gagoro vaꞌo munë gagore rumo vaꞌoromo gavareje rue jabesi övo manö a iꞌe ajivëꞌe niögu baꞌamëꞌoho ë hijamu. Hijamu gagorovo jioduduꞌiraejareje. ");
INSERT INTO aom_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Jioduduꞌiraejamu gagorovo ruehuro uëvadeje: Nadi jioduduꞌiraehëjo. Nazareth rajo ae Iesu korosire anamu guomade a hesi sinoho jemë naharujëjo. Hu aveho bogohöjo. Guomoromo riꞌöjëꞌe höjo. Hesi sino bamare sionoho gahëjo. ");
INSERT INTO aom_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Garomo vaꞌoromo Peterꞌo Iesuare ijorajo ioroꞌiorohuꞌo uërëjo: Iesuro urimo Galilee vaꞌiramu mamiꞌe uëvadire jemë ë ijore vaꞌoromo gaꞌaꞌarujë uërëjo. ");
INSERT INTO aom_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Ëhi uëvamu ë magonaho ömoꞌömohuro jioduduꞌiraeromo butubutumoromo munë gagore jioromo suorovoromo huruomoromo vaꞌareje. Vaꞌoromo juhuonivoꞌi ë jöho aho bogo majëhijareje. ");
INSERT INTO aom_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Iae hura börömore sisonuvoꞌiaꞌamu Iesu guomadoho riꞌöjadeje. Riꞌöromo aevoꞌioho Mary Magdalene-are nunire rovadeje. Röhu urimo bogo guomade majare Iesuro ë magonaho hesi dëre jioꞌamaje aruꞌaho sisë 7 rarovoꞌamadeje. ");
INSERT INTO aom_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Ëmagonaho hesi nunire rovamu gagorovo ë magonahohuro vaꞌoromo gavade Iesuare aribövioho huë vavaene baeromo nivoruomamu gëgorovo uëvadeje: Iesu riꞌöjëꞌëro hijamu gavode höjo. ");
INSERT INTO aom_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Hijamu gavode höjamu heromo bogo ma uehorovareje. ");
INSERT INTO aom_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Bogo ma uehorovamu Iesuro Mary Magdalene-are nunire rovamu ijonö ae niöꞌiro amore jioromo vaꞌi gavareje Iesu nu anoꞌe gorosovëꞌe rovamu. ");
INSERT INTO aom_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Rovamu gagorovo jaburo niöꞌiro vuonoröꞌö rueromo Iesuare aribövi ioroꞌioroho Iesu gavare jöho majëhijamu bogo ma uehorovareje. ");
INSERT INTO aom_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Bogo ma uehorovoromo Iesuare ijoraje 11-ho jaburo ie ueꞌahamu evare ijo tugohoꞌi Iesu jabesi nuniroho rovadeje. Rueromo uehorovoromo uvadeje: Ave nasi ariböviohuro hejare ae göëro göëro uëvamu: Nörö riꞌöjëꞌe jiamu noro gavare hö uëvamu heromo bogo ma uehorovare hö uvoromo birëgadeje. Birëgoromo uëvadeje: Jemë rabu hiaꞌi birire ëꞌoromo naehu riꞌöjode jöho bogo ma uehorovarije höjo. ");
INSERT INTO aom_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Ëhi birëgonugoromo uëvadeje: Saꞌae dinöꞌe dinöꞌe vaꞌoromo nasi jö maho ae ahoꞌobëhe majëhi barërëjo. ");
INSERT INTO aom_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Ae rahu mae uehorovoromo bapataeto vaejëꞌoho God-ro baejëvoromo manö bamëvoꞌajëjo. Ae rahu bogo ma uehorovëꞌoho God-ro uëꞌaꞌajëjo: Jemë sisë jëvaje öri sisënö vaꞌohëjo. ");
INSERT INTO aom_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","O ae rahu mae uehorovëꞌoho aviëhi jiëꞌe bogo gavarue mu masijoho vaeruomoꞌajëjo aëro ëho garomo uvoruomoröhego: Iae mae-ëjo. Jemë jö mae atarujëjo. Nasi ihoho uvoromo Satan-are sisë aribövi a dëre jëvajoho rarovöꞌöruomoꞌajëjo. Bogo hejarue jöëro atoruomoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Vöröꞌe sigobu banigojiomëꞌoho o oso sisëꞌe jovo ueꞌahëꞌoho bogo sisërëjëvoꞌajëjo. O guomo guomoꞌe aribövi jabesi sinore övo bamëhëꞌoho marëjëvoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Bada Iesuro ëhi jiëꞌe jöho majëhiromo God-ro hu ajamamu huro öꞌidöre ajiomoromo God-are övo manö hijadeje. ");
INSERT INTO aom_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","God-are övo manö hijamu hesi ariböviohuro vaꞌoromo jöho majëhibe dinöꞌe dinöꞌe jijihonövareje. Majëhibe jijihoꞌego Badaro jabuꞌo bimuvoromo muoho ajëmiꞌego bogo gavarue darugoꞌe muoho vaenövareje aëro ëho garomo jabesi jöho mae uehorovoꞌiröhego. Ëhiꞌareje. Ahia minoꞌe. ");
INSERT INTO aom_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","2","O asëꞌe Theophilus naro ave jöho jasi örire jajivoꞌiëꞌe gane. Mu böröme nosirire rovëꞌeje. Ëmu aevadire aëro nunëro gabe rovëꞌëro ë jöho ae majahuinövareje. Majahuijamu ae ahoꞌobëhe heromo ë jö gö göho gemuoro gagovoromo jajivo gavareje. ");
INSERT INTO aom_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Ëhuni ë muoho ahoꞌo diehi diehi vaejaroho he avohoꞌi uë gëbe rovëꞌëro naro jani avoho ahorirëro jajivoꞌamoꞌi uehorovodeje ");
INSERT INTO aom_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","ëhuro jero adahoromo mamiꞌe hejane jöho mae uehorovoꞌiranego. ");
INSERT INTO aom_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Iae Herod-hu Judea saꞌa muebejadevare priest gemu ë hijadeje. Priest hesi ihoho Zechariah jiadeje. Abijah-are ujore priest ömoꞌömoho Zechariah huꞌo ae gemuoho jiadeje. Hesi vaboro hesi ihoho Elizabeth jiadeje. Elizabeth hu aevoꞌi jiade priest Aaron-are uje jiadeje. ");
INSERT INTO aom_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Vaboroꞌo baruꞌo jaburo niöꞌiro Badahu bojëmade jögoroho bövioho biseꞌoho ahoꞌo avoho ejahoromo hesi nunire ma-mabëhe arijareje. ");
INSERT INTO aom_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Jabumë aboji harihuꞌo rumoꞌe jëvadeje Elizabeth dë tiojëꞌe magonahëro jiëꞌëro. Röhu mamiꞌe mavojiraejëvëꞌe jiadeje. Jabumë ëhi jiëꞌe a magonahoꞌe jëvadeje. ");
INSERT INTO aom_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Ëhi jëvëꞌëro Zechariahꞌo huꞌo gemu mae priest mu vaejarue ariböviohuꞌo jabesi mu majaho rovamu evare Zechariah-ro priest muoho God-are nunire vaejadeje. ");
INSERT INTO aom_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Muoho vaejamu Jew rajo priest-ehu vaejaruëhi jabumëro priest ihoho jajivoꞌamoromo gemuore buarohoromo gemu iareje gaꞌi di ahuro di muoho bae hesi jiego. Ihoho ioromo gavareje Badare osa börömore rumo vaꞌoromo ridiꞌe oso God-ni vënehu bueröhe muoho Zechariah-ro baejëꞌe jiamu. Zechariah-ro ë muoho baenugoromo ose bueꞌi Badare osa börömore vaꞌirögoro ");
INSERT INTO aom_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","a ioroꞌiorohuro ahoꞌo amonö raromoromo God-are örire jöe atoruomadeje. ");
INSERT INTO aom_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","God-are örire jöe atamu gavëꞌi Zechariah-ro osa börömore muoho vaeꞌi gavadeje Badare anerae gemu nume oso buejarue maratu övo manö ro namijamu. ");
INSERT INTO aom_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Aneraho ro namijamu gagorovo jioduduꞌiraeromo juhuonivadeje. ");
INSERT INTO aom_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Juhuonivamu gagorovo anerahuro uavadeje: Zechariah nadi juhuonivëjo. Jaehu God ëninamijanoho hu iae ejahëꞌe höjo. Ejahëꞌëro huro jasi vabore Elizabeth ajamiꞌiramu huro jani harihoho rahoꞌaꞌajëjo. Rahëꞌiroho hesi ihoho John jumuvonëjo. ");
INSERT INTO aom_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Jero sisë maro nimorohoꞌiramu ae ahoꞌobëhe jabuꞌo uvoꞌaꞌaruëjo: Mabëhe rahade hö uvoromo nimorohoꞌaruëjo. ");
INSERT INTO aom_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Hu Badare nunire a böröme jioꞌaꞌajëjo. Wine jove vöröꞌe jove gö gö bogo iꞌaꞌajëjo. Hu hesi vëmu hesi dëre jioꞌiröhire aevoromo God-are Aruꞌohohuro hesi dë vövöbajoꞌere simanore rarovoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Rarovoꞌiramu Israel raje ae ahoꞌobëhe jabesi dë vövöbajoꞌoho huotovëhoꞌiramu jabumëro Bada jabesi God-are örire avoho uehorovoruomoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Huro Elijah-are öre daruge gemuoho baeromo ëhuro Badare jöho baeromo urimo vaꞌaꞌajëjo. Vaꞌoromo aribövi jabesi dë vövöbajoꞌoho huotovëhoꞌiramu vavu ömoꞌömohuro aboji harihuꞌoho huë baejëvoꞌaruëjo. Jö bijönimarue ariböviohuro mu mae vaejarue aribövi jabesi jö maho ejëhoruomoꞌajëjo. Ëhi ajëmiꞌiramu evare aribövioho avoho raromoruomoꞌajëjo Bada maro rueröhego. ");
INSERT INTO aom_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Anerahuro ëhi majahijamu hegorovo Zechariah-ro uavadeje: Nasi vaboroho rahoꞌaꞌajë uevanuoho röhu na mavoje jevoromo nasi vaborohuꞌo mavoje höjo. Ëhi jiëꞌoho na diehiꞌoromo uvoꞌejöjo: Ja jö mae uevanuëjo. ");
INSERT INTO aom_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Uevanuëjamu anerahuro uavadeje: Na Gabriel jevajëjo. Na God-are nuninö namijaje höjo. Huro na remöꞌöjade höjo naro jaꞌo jöe jövoromo jaehu hejanue jö mabëhoho majahiꞌirodego. ");
INSERT INTO aom_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Ëhuni hejëjo. Jaehu nasi jö bogo ma uehorovanuohuni ëhuni ja jö jövanuoho bitaroho tövavoꞌiramu jörume hibe vaꞌojuvo naehu uavodëhi ëhi jioꞌiramu evare jöho jövoꞌanuëjo. Amo ë jöho bogo sareroho jioꞌi hesi majaho rueꞌiramu iae jioꞌaꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Ëhiꞌamu ae ahoꞌobëhe Zechariah mueberomo uvoruomadeje: Hu rabe ëꞌoromo osa börömoroho hiromo örisanuovajëjo. ");
INSERT INTO aom_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Örisanuovajëjamu Zechariah-ro amonö hörö rueromo jöho bogo majëhi varijënoho jiadeje. Jöho bogo majëhi varijënoho jiamu gagorovo rue ariböviohuro garomo uvoruomadeje: Hu God-are osa börömore hijadevare God-ro röjahamu niaꞌovoꞌiraeromo mu böröme gavëꞌëro ëhuꞌëro jöho bogo majahui varijënoho höjo. Röhu hu tövëꞌëro jiëꞌëro jöho bogo majëhiꞌi ma-övëremu majëhijadeje. ");
INSERT INTO aom_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Ëhi ëꞌëꞌëro God-are osare mu majaho barëjamu Zechariah-ro hesi amëro vuonoröꞌö vaꞌadeje. ");
INSERT INTO aom_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","25","Vaꞌamu hesi vabore Elizabeth-ro dëꞌiraeromo uvadeje: Dë tioromo hiromo ae ahoꞌobëhe jabesi nunire javoji baebe rovodoho aviavejöꞌe Badaro huë baejevoromo ajemamu javojoho barëjevëꞌe höjo. Ëhi uvoromo osaremu hijamu manaere övo gö mine barëjadeje. ");
INSERT INTO aom_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Elizabeth dëꞌiraeromo manaere 5 barëromo röhu manaere 6-ho jiamu gavëꞌi God-ro anerae Gabriel nugöꞌöjamu Galilee saꞌare Nazareth amore rovadeje ");
INSERT INTO aom_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","aboride gemu jöe majahiꞌiröhëni. Ëaborido hesi ihoho Mary jiadeje. Hu o a juvije gemu jabu niöꞌihu masurovoꞌiröhe jöho ae ahoꞌobëhe jabesi nunire majëhijareje. A juvijo hesi ihoho Joseph jiadeje. Joseph hu Israel saꞌare börömo vaenövade ae David-are uje jiadeje. ");
INSERT INTO aom_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Amo anerahuro rueromo Mary uavadeje: Vaevëꞌe javajëjo. God-hu huë baejavaje magonahe javajëjo. Badaro jaꞌo juvaje höjo. ");
INSERT INTO aom_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Jaꞌo juvaje höjamu hegorovo Mary-ro sisë maro nurunurumoromo uehorovoromo uvadeje: Bëhoho rabëni ëhi jiëꞌe huë baejëꞌe jöho majehiromo jejemijajëjo. ");
INSERT INTO aom_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Ëhi uvamu anerahuro uavadeje: Mary God-ro jasi örire huë baejavëꞌe jiaje nadi juhuonivoꞌi ");
INSERT INTO aom_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","aveho gavëjo. Jero dëꞌiraeromo harihe rahoromo Iesu jumuvoꞌanuëjo. ");
INSERT INTO aom_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Hu böröme jioꞌaꞌajëjo. Huro ave ihoho baeꞌaꞌajëjo Dö Mare Hijaje A hesi Harihe ë ihoho baeꞌaꞌajëjo. Bada God-ro ë aho uaꞌaꞌajëjo: Jasi hije David-are sionoho baeromo böröme namiromo Israel rajoho muebejëvonëjo. ");
INSERT INTO aom_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Muebejëvonë uaꞌiramu huro Jacob-are ujo ömoꞌömoho ma-ioroꞌioremu muebejëvonövoꞌajëjo. Bogo vuonugoꞌi ëhi muebejëvobe vaꞌaꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Muebejëvobe vaꞌaꞌajëjamu Mary-ro aneraho uavadeje: Iae jö mae-ëjo. Röhu aho bogo masegëꞌe na ëma hijajëjo. Ëhi jiëꞌoho diehiꞌoromo na dëꞌiraejevoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Dëꞌiraejevoꞌajëjamu anerahuro uavadeje: God-are Aruꞌahohuro ruahöꞌöjavoꞌajëjo. Dö mare hijaje A hesi darugohuro aegahoꞌajëjo. Ëhuni rahoꞌirane a ma hesi jöho God-ro uëꞌaꞌajëjo: Hu nasi Harihe höjo. ");
INSERT INTO aom_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Röhu aveho gavëjo. Jasi agane Elizabeth mavoje höjo röhu huꞌo harihe rahoꞌirögoro ëꞌajëjo. Ae ahoꞌobëhe garomo uvoruomade höjo: Hu dë tiojëꞌe magonahe höjo. Röhu hu dëꞌiraejadoho manaere 5 barëꞌi aveho 6-ho höjo. ");
INSERT INTO aom_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Rahade hesi bëhoho mue bövie biseꞌe vaeꞌiröhoho God hu eni jiajëjo. ");
INSERT INTO aom_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Eni jiajëjamu Mary-ro uavadeje: Iae mae höjo. Na Badare mu vaejaje magonahe jevajëjo. Ëhuni jaehu uevanue ëhi jiëꞌe muehu nasi örire rovëꞌoho iae mae höjo. Ëhi uavamu anerahuro hu nugoꞌi vaꞌadeje. ");
INSERT INTO aom_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Vaꞌamu gagorovo Mary-ro riꞌöromo dahorunörire Judea saꞌare ë ma-burëro ajiomoromo amore höröjadeje. ");
INSERT INTO aom_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Hörönugoromo Zechariah-are osare vaꞌoromo Elizabeth jejamijadeje. ");
INSERT INTO aom_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Jejamijamu hejëꞌi Elizabeth-ro hejadeje hesi dëre aharihoho tiöjavamu. Tiöꞌego God-are Aruꞌahohuro hesi dë vövöbajoꞌere sino hahoꞌere ahoꞌobëhe rumorovavamu hegorovo ");
INSERT INTO aom_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Mary-ni ma-darugoꞌo uvadeje: Ja huë mae baejëꞌe javajëjo. Magonaho ioroꞌioroho iosirëmijëꞌe javajëjo. Jaehu rahoꞌiranoho huë mae jiajëjo. ");
INSERT INTO aom_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Aveho na diehiꞌoromo huë mae baejevëꞌe höjo nasi Börömo hesi vëmehu nasi örire rovanoho. ");
INSERT INTO aom_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Ëhesi bëhoho jero jejemijamu hejëꞌi hejode höjo nasi dëre aharihohuro nimorohoromo tiöjavamu. ");
INSERT INTO aom_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Ja huë mae javajëjo Badahu uvadëhi ëhi jioꞌaꞌajë uvanohuro. ");
INSERT INTO aom_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Ëhi uavamu hegorovo Mary-ro uavadeje: Naro nasi dë vövöbajoꞌo uhure Bada mabëhe uavajëjo. ");
INSERT INTO aom_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","God na ajemaje aho uehorovoromo na nimorohevajëjo. ");
INSERT INTO aom_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Na hesi mu magonahe ma-biseꞌe jevajëjo röhu huro nasi örire uehorovevëꞌe höjo. Aviavejöꞌe aevoromo ae ahoꞌobëhe uvonövoꞌaruëjo: Nörö huë mae baejëꞌe höjo. ");
INSERT INTO aom_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Darugo maꞌe Ahuro mu böröme vaejehëꞌe höjo. Hesi ihoho gemu maemu höjo. ");
INSERT INTO aom_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Hu mae uehorovarue aribövi jabesi jöëni vavaenimaje höjo. Jabesi a ujo ömoꞌömohuni hesi vavaenoho ëhi jiemu jiobe vaꞌaꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Hesi darugoꞌe mu maho röjëhiromo a masije javuajë uvarue aribövioho rarovöꞌöjëvamu huruomëꞌe höjo. ");
INSERT INTO aom_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Huro darugoꞌe a masijo jabesi ihoho saꞌaro baꞌobueꞌi iho rumoꞌe aribövioho banigojiomëvëꞌe höjo. ");
INSERT INTO aom_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Vadunehu vuovëꞌe aribövioho irunoꞌo mahuro daꞌuojëhiꞌi bövi biseꞌo marohëꞌe aribövioho rëmöꞌöjamu ma-övemu vaꞌoruomëꞌe höjo. ");
INSERT INTO aom_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Huro hesi mu aribövie Israel raje no ajamuijëꞌe höjo. Nosi hijo mionoꞌo uëvadëhi huro ëhi Abrahamꞌo hesi ujo ömoꞌömohuꞌo nosi jöëni vavaenimemu vavaenimobe rovëꞌe höjo. ");
INSERT INTO aom_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Ëhi jövonugoromo Mary-ro Elizabethꞌo hiromo manaere niöꞌi gemu barëjamu hesi amëro vuonoröꞌö abuejadeje. ");
INSERT INTO aom_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Iae Elizabeth-are majaho rovamu harihoho rahadeje. ");
INSERT INTO aom_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Rahamu hesi amo rajohuꞌo aganohuꞌo hejare uëvavamu: Badaro huë baeromo Elizabeth mabëhe ajamijade hö uëvavamu hegorovo jabuꞌo nimorohoruomadeje. ");
INSERT INTO aom_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Nimorohoromo rahadoho hurae gemu barëjamu gagorovo rueruomadeje garöhëni jabesi Jew rajo muoho vaeromo aharihu hesi sinoho tariojahego. Rueromo ihoho hesi vavu hesi ihe Zechariah ë ihe gemuoho jumuvoꞌiëꞌareje. ");
INSERT INTO aom_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Jumuvoꞌiaꞌamu gagorovo vëmohuro uëvadeje: Bogajo. Hesi ihoho John uaꞌejarëjo. ");
INSERT INTO aom_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","John uaꞌejarëjamu uavareje: Iae mae höjo röhu jasi aganoho ëhi jiëꞌe ihoho bogohöjo. ");
INSERT INTO aom_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Bogohö uanugoromo vavuoho övëremu ua gavareje: Harihu hesi ihoho rahuo jioꞌaꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Rahuo jioꞌaꞌajëjamu vavuohuro övëremu uëvadeje: Ijo haꞌosoho barovego na jajivöjo. Ijo haꞌosoho baro bojamamu jajivoromo uëvadeje: Hesi ihoho John höjo. Hesi ihoho John hö uëvamu gagorovo rue aribövioho gövögövövareje. ");
INSERT INTO aom_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Ëhiꞌamu evare Zechariah-are jöꞌoho bitaroho marëjamu God rajahijadeje. ");
INSERT INTO aom_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Rajahijamu gagorovo rue amo rajohuro ae ahoꞌobëhe juhuonivoruomadeje. Juhuonivoromo ë mu börömo hesi jöho ahoꞌo Judea dahorunörire saꞌa börömore ë vaerovemu vaerovoruomadeje. ");
INSERT INTO aom_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Vaerovemu vaerovoromo ë jöho sisë maro uehorovoruomadeje. Uehorovoromo gavare Badaro aharihoho mae ajamamu gagoro uvareje: Ëaharihoho hu diehi jiëꞌe a mabëhe jio hesi höjo. ");
INSERT INTO aom_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Iae aharihu hesi vavue Zechariah-ro hejade God-are Aruꞌahoho hesi dë vövöbajoꞌere sino hahoꞌere rumorovoromo uehore bojamamu hegorovo ave jöho majëhiromo uëvadeje: ");
INSERT INTO aom_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Bada God Israel rajo muebejavuaje aho hu mabëhe höjo. Huro uehoro ma-mae baeromo hesi aribövioho ajamuiꞌi rovëꞌe höjo. Rueromo sisëꞌi raromaroho maro bamavuëꞌe höjo. ");
INSERT INTO aom_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Huro darugoꞌe aho God-are mu vaenövade ae David-are ujoho bojamuijëꞌe höjo no baejavuoromo maro ramuoꞌiröhego. ");
INSERT INTO aom_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Huro ëhi ëꞌiröhëro mami göꞌe hesi jö baejare aribövi maho ëhi huruohoꞌego jabumëro ë jöho ae majëhinövare höjo. ");
INSERT INTO aom_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Huro noꞌo muorovarue aribövioho ruahöꞌöjëvoromo no baejavuoromo maro ramuoꞌiröhëro no nu huodaguarue aribövi jabesi övore javuego baeniëhiromo maro bamavuoꞌiröhëro ëhi uvade höjo. ");
INSERT INTO aom_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Huro muebejavuobe vaꞌiröhe jöho uehorovoromo nosi hijo mionoꞌoho huë baejëvoꞌi uvade höjo. ");
INSERT INTO aom_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Huro nosi hije Abraham darugoꞌe jöho majahiromo uavade höjo ");
INSERT INTO aom_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","75","ajamuiromo noꞌo muorovarue aribövi jabesi övore javuego baeniëhiꞌiröhëro. Baeniëhijego noro bogo juhuonivoꞌi ma-ioroꞌioremu hesi nuniro raromoromo hu gemu uehorovoromo ae mae vaejëvoromo hesi muoho vaenövoꞌiröhego. ");
INSERT INTO aom_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Röhu jueꞌiajo. Dö mare hijaje Aho God-ro ave jöho majahiromo uaꞌaꞌajëjo: Ja jö God nasiro baeromo a majëhijanue ae javajëjo. Jero Badare jöho baeromo urimo vaꞌaꞌanuëjo huhu rueröhe öroho avohahego maro rueröhego. ");
INSERT INTO aom_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Jero jöe majëhijego God-are ariböviohuro heromo uvoruomoröhego: God-ro nosi sisëho uehorovoromo vuonugoromo no baejavuoromo maro ramuaje hö uvoröhego. ");
INSERT INTO aom_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","79","Ëhesi bëhoho God-ro noni vavaenimajohuro majaëro öꞌidöre rojomanovoromo ramoramore vuovo örire jijiharue aribövioho no ajivavuoꞌajëjo. Ajivavuoromo huë mae baeꞌiröhe öroho röjahuiꞌaꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Zechariah-ro ëhi jövëꞌëro John-ro böviraebe hesi aruꞌahoho dë vövöbajoꞌoho biririvobe vaꞌadeje. Biririvobe vaꞌoromo a rumoꞌe saꞌare vaꞌo hijadeje uꞌemu Israel rajo jabesi nunire muoho ma-vaꞌorahoro vaeröhëni. ");
INSERT INTO aom_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Ëhiꞌamu evare Rome a böröme saꞌae ahoꞌobëhe muebejaje a ihe Caesar Augustus-ro jöe nugöꞌöjadeje. Jöe nugöꞌöromo uëvadeje: Nasi aribövie saꞌae dinöꞌe dinöꞌe raromarujoho jemëro vaꞌoromo jemesi ihoho census aribövioho bojëmirego jajivëhoꞌirarëjo. ");
INSERT INTO aom_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Röhu evare majaho ëho iho aevoromo jajivoꞌamare majaho jiadeje. Evare majaroho Quirinius-ro bövie vaeromo Syria saꞌaho muebenövadeje. ");
INSERT INTO aom_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Amo ë jöho rovamu gagorovo ae gemu gemu amo göre göre vaꞌo raromaroho jabesi amo mare vuonoröꞌö rueruomadeje jabesi ihoho uëvego jajivojöro. ");
INSERT INTO aom_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Rueruomamu Joseph-ro huꞌo Galilee saꞌare Nazareth amore hiromo vuonugoromo hu David-are ujëro jiëꞌëro David-hu aevoꞌi hijade amore Bethlehem ë rovadeje. ");
INSERT INTO aom_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Rueꞌi Mary huꞌirae rovadeje jabesi ihohuꞌo jajivëhojöro rabëni Mary huro masuröhe magonahego. Röhu hu dëꞌe jiadeje. ");
INSERT INTO aom_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Bethlehem rueromo arijamu magonahehu rahoröhe majaho rovadeje. ");
INSERT INTO aom_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Majaho rovamu gavare aehu nuharue osaho rarovamu gagorovo mi nugoꞌamarue osare vaꞌo harihu murioho rahoromo niögëro numoromo mi jabesi i bahijarue röhore ë bamareje. ");
INSERT INTO aom_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Ëhiꞌamu gavëꞌi iae diröꞌe gemuore aëro vahiꞌe sheep mure raromoromo sheep-oho muebeꞌamareje. ");
INSERT INTO aom_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Sheep-oho muebeꞌi gavare Badare anerahuro ro namiꞌego Badare ajohuro ajivëvamu gagorovo sisë maro juhuonivareje. ");
INSERT INTO aom_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Juhuonivamu gagorovo anerahuro uëvadeje: Nadi juhuonivohëjo. Naehu rovaje hesi bëhoho na jö mae baeromo rovajëjo jemëꞌo jemesi a ioroꞌiorohuꞌo ahoꞌobëhe heromo börömo bëhe nimorohoꞌirarijego. ");
INSERT INTO aom_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Aruëre David-hu hinövade amore jemë baejëvoromo mare bamëvoꞌiröhe aho jaruvo rahëꞌe höjo. God-hu uavëꞌëro böröme namiromo ajëmiꞌiröhe aho höjo. Hu Bada höjo. ");
INSERT INTO aom_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Röhu jemëro vaꞌoromo gaꞌirarije aharihoho niögëro numëꞌe mi jabesi i bahijarue röhore raromamu gavëꞌiroho uvorëjo: Nörö jö mae uövuade höjo. ");
INSERT INTO aom_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Jö mae uövuade hö uëvamu gavëꞌi anerae ahoꞌobëhe öꞌidöre jioromo ma-majioho ruvebiruomoromo urimore rovade anerahuꞌo gemu mae riravoromo God rajahiromo uvoruomadeje: ");
INSERT INTO aom_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","Dö mare hijaje aho God hu mabëhe höjo. Saꞌare raromarue aribövioho huhu huë baejëvajoho maro raromoruomoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Aneraho jaburo ëhi uvoruomoromo öꞌidöre vuonoröꞌö iojiomamu gagorovo nume sheep muebejarue ariböviohuro uarovareje: Rovego Bethlehem vaꞌoromo Badahu uövuade muoho gavarëjo. ");
INSERT INTO aom_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Ëhi uarovonugoromo ma-burëro rueromo nahoromo gavareje Maryꞌo Josephꞌo ariꞌirögoro aharihoho miehu i ijarue röhore raromamu. ");
INSERT INTO aom_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Ëhi ganugoromo aharihu hesi jö aneraehu uëvamu hejaroho Maryꞌo Josephꞌo majëhijareje. ");
INSERT INTO aom_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Majëhijamu hegorovo ae ahoꞌobëhe tiöjëvadeje. ");
INSERT INTO aom_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Tiöjëvamu Mary-ro jöho avoho heromo hesi simanore bamoromo uehorovemu uehorovadeje. ");
INSERT INTO aom_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Ëhiꞌamu rue sheep muebejarue ariböviohuro aneraehu uëvadëhi ëhi jiamu gavëꞌëro o jöho ëhi hejëꞌëro God rajahibe mae uabe jabesirëro sionëro vaꞌareje. ");
INSERT INTO aom_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Iesu rahadoho hurae gemu barëjamugo Iesuare örire Jew rajo muoho vaeromo sinoho tariöꞌöjahoromo urimo Mary bogo maꞌenorohëꞌe ma-hijadevare aneraehu iho uavadëhi ëhi Iesu jumuvareje. ");
INSERT INTO aom_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Mary-ro aharihoho rahoromo hijuvo gavade Moses-hu bojëmade mu vaeromo jabesi sisë uꞌoröhe majaho rovamu gagorovo huro Joseph-mu niöꞌiro aharihe Iesu baeromo Jerusalem amore ajiomareje aharihoho Bada bojamiꞌiröhëni. ");
INSERT INTO aom_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Ëmu hesi jöho God-are surire jajivoromo uvëꞌeje: Harihu murioho ahoꞌobëhe God-are öroro iꞌimamego hesiremu jioꞌamoꞌirajo. Amo Maryꞌo Josephꞌo aharihoho bavaꞌareje ëhi jiëꞌe muoho vaeröhëni. ");
INSERT INTO aom_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","O jö göho Badare surire jajivoromo ëhi uvëꞌeje: Ihititore niöꞌi o guaho harihe niöꞌi ëhi jiëꞌe ugoho priest bojëmego God-ni vënëro muejëvoꞌirajo. Ëmuohuꞌo vaeꞌiröhëni jabumë aharihoho bavaꞌareje. ");
INSERT INTO aom_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Röhu ae gemu Jerusalem amore hijëꞌe jiadeje. Hesi ihoho Simeon jiadeje. Hu ae mae vaejëvoromo God-are muoho gemu uehorovaje aëro jiëꞌëro muebenövadeje God-ro Israel rajoho ajëmiromo jabesi huë vavaenoho tugohëhoröhego. Röhu God-are Aruꞌahohuro huꞌo juvonövadeje. Hu ëhi jiëꞌe ae jiadeje. ");
INSERT INTO aom_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Simeon hu ëhi jiëꞌe ae jiamu God-are Aruꞌahohuro röjahiromo uavadeje: Ja bogo avevejöꞌoho guomoꞌi Badahu uavëꞌëro böröme namiromo ajëmiꞌiröhe aho rueꞌiramu ganugoromo evare guomoꞌaꞌanuëjo. ");
INSERT INTO aom_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Ëhi uavëꞌëro ijonö God-are Aruꞌahohuro uehore bojamamu Simeon-ro God-are osa börömore rovadeje. Rovamu evare Iesuare vëmu vavuꞌohuro aharihoho God-are osa börömore barovareje Jew rajo jögoru jiaje ëhi jiëꞌe muoho vaeꞌiro. ");
INSERT INTO aom_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Barovamu gagorovo Simeon-ro aharihoho övëro huohudëromo God rajahiromo uavadeje: ");
INSERT INTO aom_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Bada jaruvo jero jasi nimoromo uevego na muoho vuonugoꞌi huë mae öꞌiröjo jaehu uevanëhi ëhi jiëꞌe jiaje. ");
INSERT INTO aom_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","No maro bamavuoꞌiröhe aho nasi nunëro gavëꞌe jevajëjo. ");
INSERT INTO aom_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Ëaehu vaeröhe muoho jero avohane höjo saꞌae ahoꞌo garöhego. ");
INSERT INTO aom_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Avohane hesi bëhoho huro ajoho barovego ëhuro jasi jö bogo hejëꞌe aribövioho jasi öroho gaꞌi jasi aribövie Israel rajo nosi ihoho döro jioröhego. ");
INSERT INTO aom_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Simeon-ro ëhi jövamu hegorovo Iesuare vëmohuꞌo vavuohuꞌo tiöjëvadeje. ");
INSERT INTO aom_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Tiöjëvamu God-ro jabumë huë mae bojëmiꞌiröhego Simeon-ro God uanugoromo Iesuare vëme Mary uavadeje: Aveho hejëjo. Ave aharihoho God-ro bamade höjo huro muoho vaejego ëhuro Israel rajo a ioroꞌioroho saꞌare rireromëvoꞌi ioroꞌioroho döro riꞌöröhego. God-ro bamade höjo huro hesi jöho barueröhego. Huro hesi jöho barueꞌiramu aëro ahoruomoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Ahoromo ëhuro ae ahoꞌobëhe jabuhu diehi diehi uehorovaruoho vaꞌorahoro jioꞌiramu gaꞌejarëjo. Ëhiꞌoꞌiramu jero jasi dë vövöbajoꞌo uhure huë vavaene börömoho baeꞌaꞌanuëjo. ");
INSERT INTO aom_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Simeon-ro Mary ëhi uavadeje. Röhu magonaho mavoje gemu ë hijëꞌe jiadeje. Hesi ihoho Anna jiadeje. Hu jö God-aro baeromo majëhijaje magonahe jiadeje. Phanuel-are aboje jiadeje. Asher-are uje gemuoho jiadeje. Röhu hesi vadunoho ahoꞌobëhe mae jiadeje. Urimëꞌi barue masuromo baruꞌo hijadoho vadune ahoꞌobëhe 7 barëjamu ");
INSERT INTO aom_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","baru guomamu doru hijadoho rahade vadunoho ahoꞌobëhe 84 jiadeje. Ëhuꞌëro mavoji mae jiadeje. Röhu huro ë God-are osa börömoremu vaꞌoromo majae vahie jene ioho vuonugoꞌi God gemu uehorovoromo hesi örire jöe jövoromo rajahinövadeje. ");
INSERT INTO aom_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Amo Maryꞌo Josephꞌo God-are osa börömore arijamu ë magonahohuro jabesirire rovadeje. Rueromo aharihoho garomo God huë mae uavadeje. Huë mae uaromo vaꞌoromo ganövade di ariböviohuro God-ro Jerusalem amo rajoho maro bamëvoröhego muebejarue ë aribövioho gëromo aharihu hesi jöho majëhinövadeje. ");
INSERT INTO aom_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Ëhiꞌamu Maryꞌo Josephꞌo Badare surire jiaje ëhi jiëꞌe muoho vae barënugoromo Galilee saꞌare vuonoröꞌö rueromo ro jabesi amore Nazareth ë arijareje. ");
INSERT INTO aom_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Arijamu aharihoho böviraebe biririvobe vaꞌadeje. Hu uehoro mabëhe hesi simanore jiadeje. God-ro hesi örire huë bae avohobe vaꞌadeje. ");
INSERT INTO aom_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Ëhi jiëꞌëro God-hu Vörö Tugohade Maja Börömoho rueꞌego vadune göro göro Iesuare vëmu vavuꞌohuro Jerusalem ajiomoromo ë hesi söröho inövareje. ");
INSERT INTO aom_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Ëhiꞌobe rovaroho Iesu vadune ahoꞌobëhe 12 baejamu gagoro Iesuare vëmu vavuꞌohuro ëhi gemuoho ëꞌoromo Jerusalem amore ajiomareje. ");
INSERT INTO aom_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Ajiomoromo sörö majaho barëjamu vuonoröꞌöromo sionëro jabesi amëro rueꞌiëꞌareje. Röhu jabesi harihe Iesuro ë Jerusalem hijadeje. Hijamu vëmu vavuꞌoho dadivëvadeje. ");
INSERT INTO aom_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Dadivëvamu uehorovoromo uvareje: Evaho Iesu nosi a ioroꞌiorohuꞌo gemu mae rovajëromo rovaroho majae gemu barëjadeje. Majae gemu barëjamu agano ioroꞌiorehu örire rovaruire Iesu nahobe jirehojuvo ");
INSERT INTO aom_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","gavare Iesu bogojiamu gagorovo öri ahore vuonoröꞌöromo Jerusalem naho vaꞌareje. ");
INSERT INTO aom_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Nahojuvo jiamëhi vaꞌi gavareje Iesu God-are amo börömore hiromo God-are jö öri röjëhijarue aribövi jabesi jöho hejëꞌi huꞌo mana uë gëvamu. ");
INSERT INTO aom_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Hejareje huro ëhiꞌego ae ahoꞌobëhe tiöromo uvoruomamu: Rabu simano ma-mabëhe baejëꞌëro jöho mana buꞌöjajëjo. ");
INSERT INTO aom_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Ëhiꞌamu vëmu vavuꞌohuro Iesu garomo tiöromo vëmohuro uavadeje: Jueꞌi ja rabëni nosi öriroho ëhioho ëꞌane höjo. No jasi vavuohumu niöꞌiro nurunurumëꞌi nahavobe rovare höjo. ");
INSERT INTO aom_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Rovare höjamu Iesuro uëvadeje: Jemë rabëni na nahevobe rovarije höjo. Jemë rabëni bogo uvarije höjo: Nörö hesi Vavuohuro nimoꞌego hesi osare hijajëjo. ");
INSERT INTO aom_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Ëhi uëvamu hegorovo vëmu vavuꞌoho Iesuhu uëvaje jö hesi bëhoho dadivëvadeje. ");
INSERT INTO aom_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Dadivëvamu Iesuro vëmu vavuꞌohuꞌo sionëro vuonoröꞌö rovadoho jabesi amore Nazareth ë hiromo jabesi jöho ejëhëꞌe hinövadeje. Hijamu vëmohuro gavade hejade jöho hesi simanore bamoromo uehorovemu uehorovonövadeje. ");
INSERT INTO aom_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Ëhiꞌamu Iesuro simano mae jiobe daje böviraebe vaꞌadeje. God o ae ahoꞌobëhe jaburo hesi örire huë bae avohobe vaꞌareje. ");
INSERT INTO aom_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Iae Tiberius Caesar-hu Rome amore bövie namiromo hesi saꞌae dinöꞌe dinöꞌe aevoromo muebejavuadoho vadune ahoꞌobëhe 14 barëꞌi 15-ho jiadeje. Röhu Pontius Pilate-ro Judea saꞌaho muebeꞌi Herod-ro Galilee saꞌaho muebeꞌi Herod-are murie Philip-ro Iturea saꞌahuꞌo Trachonitis saꞌahuꞌo muebejëvoꞌi Lysanias-ro Abilene saꞌaho muebejadeje. ");
INSERT INTO aom_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Annasꞌo Caiaphasꞌo jabumë niöꞌi Jew rajo jabesi priest böröme jëvadeje. Ësaꞌare a masijoꞌo priest masijoꞌo ëhi jioꞌamade majare evare Zechariah-are harihe John-ro a rumoꞌe saꞌare hijamu God-are jöhuro dëre abuejadeje. ");
INSERT INTO aom_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Abuejamu hegorovo jöho majëhibe juvoromo Jordan jovonörire öri ariꞌoho juvo barëjadeje. Juvo barëromo majëhiromo uënövadeje: Uehoro sisëho vuonugoꞌi uehoro mae baeromo bapataeto vaehego God-ro jemesi sisëho uehorovoromo vuonugëhajo. ");
INSERT INTO aom_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","John-hu ëhi ëꞌiröhe jöho urimëꞌi jö God-aro baeromo majëhinövade ae Isaiah-ro surire jajivoromo uvadeje: Aëro a rumoꞌe saꞌare hiromo ma-darugoꞌo uvoꞌaꞌajëjo: Badahu rueröhe öroho avohorego hu maro rueꞌirajo. Hesi öroho ahorirëro vajivorego hu maro juvoꞌirajo. ");
INSERT INTO aom_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Guoröte ahoꞌobëhe huoꞌamoꞌiramu rojomoꞌamoꞌajëjo. Dahoru ëgohuꞌo bunohuꞌo ahoꞌobëhe ahoꞌamoꞌiramu ahorire jio vaꞌaꞌajëjo. Tagu taguꞌe öroho vajivoꞌiramu ahorirëro jioꞌamoꞌajëjo. Abue ajiomëꞌe öroho avohoꞌiramu ahorirëro jio vaꞌaꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Ëhiꞌoꞌiramu ae ahoꞌobëhe garuomoꞌajëjo God-hu baejëvoromo mare bamëvajoho. ");
INSERT INTO aom_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Ëhi jajivëꞌëro jiëꞌëro iae John-ro gavade ae ahoꞌobëhe mae huro bapataeto vaejëvojöro rueruomamu gëgorovo uëvadeje: Sigobu aboji harihuꞌe jëvanovajëjo. Jemë raro uëvade höjo: God-are vöröehu rueꞌiröhire jioromo huruomoromo manö vaꞌirarijoho eni jëvoꞌajëjo. Bogajo. ");
INSERT INTO aom_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Ijehu bajo mae raejajëhi ëhi mu mae vaerego no garomo uvoꞌirarëjo: Iae jemë uehoro sisëho vuonugoꞌi uehoro mae baejëꞌe jëvajëjo. Röhu nadi uvorëjo: Abraham nosi bëhohuro jiëꞌëro ëhuꞌëro no mae javuajëjo. Naro jemë uëvajëjo: Jemë Abraham-are ujo ömoꞌömo jëvajoho ëho ma-biseꞌe höjo. God-ro nimoꞌibejajo ave munëho ujuohoromo avohëvego araeromo Abraham-are ujo ömoꞌömoho jioꞌamoꞌibejajo. Ëhuni nadi nimorohëꞌioho ëhioho atorëjo. ");
INSERT INTO aom_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Röhu tonëro ijoho bëhiꞌo huoꞌöꞌiëꞌajëjo. Di ijohuro bajoho bogo ma raejëꞌe jiego huoꞌöromo vëniro huoꞌiëꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Ëhi jiëꞌe jöho majëhiꞌego aëro uanövareje: Ëhi jiëꞌoho no diehi jiëꞌe muoho vaeꞌejarëjo. ");
INSERT INTO aom_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Vaeꞌejarëꞌego John-ro uënövadeje: Ae rahu niöge niöꞌi jëvëꞌoho gö baeromo niögu rumoꞌe aho bojaminëjo. O ie jëvëꞌoho i rumoꞌe aho gö bojaminëjo. ");
INSERT INTO aom_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Ëhi uëꞌego tax baejarue aribövioho jabuꞌo bapataeto vaeꞌi ruenövareje. Rueromo uanövareje: Tisa no diehi jiëꞌe muoho vaeꞌejarëjo. ");
INSERT INTO aom_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Vaeꞌejarëꞌego John-ro uënövadeje: Tax baejëꞌiroho saꞌare a masijehu uëvaruëhi ëminoꞌe baeꞌi nadi göꞌoho döroho jemesi ëma baerëjo. ");
INSERT INTO aom_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Ëhi uëꞌego muorovo aribövioho jabuꞌo uanövareje: Jabesi muoho ëhi höjo röhu nomë diehi jiëꞌe muoho vaeꞌejarëjo. Vaeꞌejarëjamu uëvadeje: Jemëro vaꞌoromo nadi ae gö jabesi monioho baeniëhirëjo o nadi sarerëmiromo uërëjo: Jemë mu sisë vaejëꞌe jëvaje monie mana bojamuihëjo. Nadi ëhi jiëꞌe muoho vaeromo monioho ujuohoꞌi ma-uvorëjo: No suvuoro baejaruoho iae eni höjo. ");
INSERT INTO aom_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Ëhi majëhijamu hegorovo ae ahoꞌobëhe dë vövöbajoꞌere uvoruomadeje: Nani mu börömëro rovajëjo. O nani John hu God-hu uavëꞌëro böröme namiromo ajamuiꞌiröhe ahuro jöe majahuijajëjo. ");
INSERT INTO aom_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Ëhi uvoruomamu gagorovo John-ro uëvadeje: Naro jovëremu bapataeto vaejëvaje höjo. Röhu ae gö nasi ijonö rueꞌiëꞌajëjo. Huro na iosiremiromo börömoho höjo. Naehu hesi mu biseꞌo vaejahoromo höru sino jiovahoꞌibejodoho o mu biseꞌo biseꞌe rabe vaejahoꞌibejodoho röhu na ma-biseꞌe jevajëjo. Naro ma-jovëremu bapataeto vaejëvaje höjo. Ëahuro God-are Aruꞌahohuro o vënëro bapataeto vaejëvoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Hesi ijo garanoho övore höjo. Ijo garanoho övore jiëꞌëro ioho tevoromo döro hijiohijiovoromo mevoromo i maho gagovoromo hesi irunoꞌe osare ë avoho bahiꞌi subueho sinoho ravemu ravaje vënire huoꞌaꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Ëhi jiëꞌe jöho o jöe gö gö John-ro majëhiromo ëhuro jabesi simanoho huotovëho ganövadeje. Ëhiꞌoromo God-are jö maho majëhinövadeje. ");
INSERT INTO aom_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Ëhiꞌamu gagorovo iae ë saꞌa muebejaje a böröme Herod-ro hesi muri hesi vabore Herodias gohoniahiromo mu sisë gö gö vaejamu gagorovo John-ro riꞌöromo birevadeje. ");
INSERT INTO aom_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Birevamu Herod-ro mu sisë ahoꞌobëhe vaejëꞌëro röhu ave mu sisëhuꞌo vaejadeje. Huro ae uëvamu John guduamo bavaꞌoromo savoji gagore baꞌamareje. ");
INSERT INTO aom_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Röhu ë hesi urimo John-hu a bapataeto vaejëvade majare huro ae ahoꞌobëhe bapataeto vaejëvonugoromo Iesuꞌo bapataeto vaejadeje. Bapataeto vaejamu Iesuro God-are örire jöe jövamu gavëꞌi öꞌidöho arorovadeje. ");
INSERT INTO aom_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Arorovamu God-are Aruꞌahohuro sino hahoꞌe jioromo guaho vaꞌënohuro Iesuaro ruvebijamu gavëꞌi ae ahoꞌobëhe hejareje öꞌidöre uvavamu: Ja nasi Harihu mabëhe javajëjo. Naro ja garomo ëhuro nasi dë vövöbajoꞌoho nimorohevajëjo. ");
INSERT INTO aom_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Röhu Iesuhu mu aevade majaho hu vadune ahoꞌobëhe 30 rabuꞌe jiadeje. Ae ahoꞌobëhe uvoruomadeje: Iesu hu Joseph-are harihe höjo. Röhu Joseph hu Heli-are harihe jiadeje. ");
INSERT INTO aom_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Heli hu Matthat-are harihe jiadeje. Matthat hu Levi-are harihe jiadeje. Levi hu Melchi-are harihe jiadeje. Melchi hu Jannai-are harihe jiadeje. Jannai hu Joseph-are harihe jiadeje. ");
INSERT INTO aom_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Joseph hu Mattathias-are harihe jiadeje. Mattathias hu Amos-are harihe jiadeje. Amos hu Nahum-are harihe jiadeje. Nahum hu Esli-are harihe jiadeje. Esli hu Naggai-are harihe jiadeje. ");
INSERT INTO aom_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Naggai hu Maath-are harihe jiadeje. Maath hu Mattathias-are harihe jiadeje. Mattathias hu Semein-are harihe jiadeje. Semein hu Josech-are harihe jiadeje. Josech hu Joda-are harihe jiadeje. ");
INSERT INTO aom_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Joda hu Joanan-are harihe jiadeje. Joanan hu Rhesa-are harihe jiadeje. Rhesa hu Zerubbabel-are harihe jiadeje. Zerubbabel hu Shealtiel-are harihe jiadeje. Shealtiel hu Neri-are harihe jiadeje. ");
INSERT INTO aom_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri hu Melchi-are harihe jiadeje. Melchi hu Addi-are harihe jiadeje. Addi hu Cosam-are harihe jiadeje. Cosam hu Elmadam-are harihe jiadeje. Elmadam hu Er-are harihe jiadeje. ");
INSERT INTO aom_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er hu Joshua-are harihe jiadeje. Joshua hu Eliezer-are harihe jiadeje. Eliezer hu Jorim-are harihe jiadeje. Jorim hu Matthat-are harihe jiadeje. Matthat hu Levi-are harihe jiadeje. ");
INSERT INTO aom_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Levi hu Simeon-are harihe jiadeje. Simeon hu Judah-are harihe jiadeje. Judah hu Joseph-are harihe jiadeje. Joseph hu Jonam-are harihe jiadeje. Jonam hu Eliakim-are harihe jiadeje. ");
INSERT INTO aom_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliakim hu Melea-are harihe jiadeje. Melea hu Menna-are harihe jiadeje. Menna hu Mattatha-are harihe jiadeje. Mattatha hu Nathan-are harihe jiadeje. Nathan hu David-are harihe jiadeje. ");
INSERT INTO aom_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","David hu Jesse-are harihe jiadeje. Jesse hu Obed-are harihe jiadeje. Obed hu Boaz-are harihe jiadeje. Boaz hu Shelah-are harihe jiadeje. Shelah hu Nahshon-are harihe jiadeje. ");
INSERT INTO aom_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nahshon hu Amminadab-are harihe jiadeje. Amminadab hu Admin-are harihe jiadeje. Admin hu Arni-are harihe jiadeje. Arni hu Hezron-are harihe jiadeje. Hezron hu Perez-are harihe jiadeje. Perez hu Judah-are harihe jiadeje. ");
INSERT INTO aom_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Judah hu Jacob-are harihe jiadeje. Jacob hu Isaac-are harihe jiadeje. Isaac hu Abraham-are harihe jiadeje. Abraham hu Terah-are harihe jiadeje. Terah hu Nahor-are harihe jiadeje. ");
INSERT INTO aom_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nahor hu Serug-are harihe jiadeje. Serug hu Reu-are harihe jiadeje. Reu hu Peleg-are harihe jiadeje. Peleg hu Eber-are harihe jiadeje. Eber hu Shelah-are harihe jiadeje. ");
INSERT INTO aom_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Shelah hu Cainan-are harihe jiadeje. Cainan hu Arphaxad-are harihe jiadeje. Arphaxad hu Shem-are harihe jiadeje. Shem hu Noah-are harihe jiadeje. Noah hu Lamech-are harihe jiadeje. ");
INSERT INTO aom_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamech hu Methuselah-are harihe jiadeje. Methuselah hu Enoch-are harihe jiadeje. Enoch hu Jared-are harihe jiadeje. Jared hu Mahalaleel-are harihe jiadeje. Mahalaleel hu Cainan-are harihe jiadeje. ");
INSERT INTO aom_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Cainan hu Enos-are harihe jiadeje. Enos hu Seth-are harihe jiadeje. Seth hu Adam-are harihe jiadeje. Adam hu God-are harihe jiadeje. ");
INSERT INTO aom_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Iae Iesuro hejade God-are Aruꞌahohuro hesi dë vövöbajoꞌere sino hahoꞌere rumorovavamu hegorovo Jordan jovoho vuonugoꞌirögoro God-are Aruꞌahehu uavajire a rumoꞌe saꞌa göre ë vaꞌo juvadeje. ");
INSERT INTO aom_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","A rumoꞌe saꞌare juvamu gagorovo Iesuro God-are jöho ahojöro Satan-ro hesi dëho bijioho gabe vaꞌadoho majae ahoꞌo 40 barëjadeje. Bijioho gaꞌi hijamu evare majaroho Iesuro ioho bogo ijëꞌe ma-hibe vaꞌoromo ë majaho barëjamu vadunëro hömadeje. ");
INSERT INTO aom_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Vadunëro hömamu Satan-ro riꞌöromo uavadeje: Ja God-are Harihe javëꞌoho ave munëho uavego iraejajo. ");
INSERT INTO aom_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Iraejajamu ruehuro uavadeje: Röhu God-are jöho jajivoromo ëhi uvëꞌe höjo: Aehu iemu uehorovëꞌoho bogo maho raromoꞌaruëjo. ");
INSERT INTO aom_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Ëhi uavamu Satan-ro Iesu huꞌirae baꞌojiomoromo a masijehu dinöꞌe dinöꞌe raromoromo muebeꞌamarue öri ariꞌoho ëho ma-burëro röjahi barëjadeje. ");
INSERT INTO aom_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Röjahiromo uavadeje: Ëöri ariꞌoho ahoꞌobëhe naro bojami barëꞌejöjo jero mueberomo ë bövi biseꞌo maho ujuohoꞌiranego. Ëhesi bëhoho ë öri ariꞌoho naro baejëꞌëro jevëꞌëro ae rahu bojëmiꞌi negëꞌoho iae bojëmaje höjo. ");
INSERT INTO aom_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Ëhuni jaehu uvene aho röjehijëꞌoho ahoꞌobëhe jasi jioꞌamoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Jasi jioꞌamoꞌajëjamu Iesuro uavadeje: Röhu God-are surire jöho ëhi uvëꞌe höjo: Bada jasi God gemu rajahiromo hesi muohemu gemu vaejahonëjo. ");
INSERT INTO aom_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Ëhi uavamu Satan-ro Iesu Jerusalem huꞌirae baeromo ajiomadoho ruhe God-are osa börömo hesi döre baꞌojio ë nugamu namijadeje. Namijamu Satan-ro uavadeje: Ja God-are Harihe javëꞌoho avehuro namiꞌi jöröꞌörovëjo. ");
INSERT INTO aom_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Ëhesi bëhoho God-are surire jöho ëhi uvëꞌe höjo: God-ro hesi aneraho uëꞌiramu ja avoho muebejavoꞌaruëjo. ");
INSERT INTO aom_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","O hesi surire jö göho ëhi uvëꞌe höjo: Aneraho jaburo övore maꞌenagonövoꞌaruëjo jasi hörure munëro bibejavojöëni. Ëhuni jöröꞌörovëjo. ");
INSERT INTO aom_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Jöröꞌörovëjamu uavadeje: Röhu God-are jöho ëhi uvëꞌe höjo: Nadi riꞌöromo Bada jasi God hesi dëho ëma bijiohoromo uanëjo: God jero ëhi ëhi ëꞌëjo. ");
INSERT INTO aom_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Ëhi uavamu Iesuro mue gö gö ahoꞌo vaejöro Satan-ro hesi dëho bijioho ganugoromo vuonugo vaꞌadeje majae eni jiego vuonoröꞌö rueröhëro. ");
INSERT INTO aom_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Vaꞌamu iae Iesuro God-are Aruꞌaho hesi darugoho baeromo vuonoröꞌöromo Galilee saꞌare vaꞌadeje. Vaꞌamu huhu rovade jöho ë saꞌaho ahoꞌobëhe heruomadeje. ");
INSERT INTO aom_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Iesuro Jew rajehu God rajahijarue osare osare jöe röjëhibe juvamu ae ahoꞌobëhe uvoruomadeje: Hu a mae höjo. ");
INSERT INTO aom_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Ëhiꞌamu Iesuro jöe röjëhibe juvoromo urimëꞌi asisöꞌoꞌere hiromo böviraejade amore Nazareth ë rovadeje. Rueromo nuho majae rovamu amo göre göre vaꞌoromo ëꞌajëhi ëhi huro God rajahijarue osare vaꞌadeje. Vaꞌoromo God-are surire jöho adahoꞌi riꞌö namijadeje. ");
INSERT INTO aom_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Namijamu jö God-aro baeromo majëhinövade ae Isaiah-hu jajivade jöꞌe suroho ae göëro bojamijadeje. Bojamamu Iesuro baeromo jiovöꞌöromo ave jajivade jöho nahoromo birohoromo adahoromo ");
INSERT INTO aom_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","uvadeje: Badare Aruꞌahohuro nasi simanore rumorovevajëjo Badaro hesi Aruꞌahoho nasirire bamëꞌëro jiëꞌëro. Huhu bamade hesi bëhoho naro hesi jö maho baeromo bogo eni jiëꞌe aribövioho majëhiꞌirodego bamade höjo. Huro na remöꞌöjade höjo naro vaꞌoromo tövëvëꞌe aribövioho uëꞌirodego: Jiovo rëmöꞌöꞌirode majaho rovëꞌe höjo. Nuni tugorohëvëꞌe aribövioho uëꞌirodego: Nuni dadovëhoꞌirode majaho rovëꞌe höjo. Remöꞌöjade höjo sisëhu ruahöꞌöjëvëꞌe aribövioho naro manö bamëvoꞌirodego. ");
INSERT INTO aom_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Naro ae uëꞌirodego: Badahu ajëmiꞌiröhe majaho iae rovëꞌe höjo. ");
INSERT INTO aom_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Ëjöho adahonugoromo Iesuro suroho huhoho taemoromo osa muebejaje aho sionëro bojamiromo jö bëhoho röjëhiꞌi saꞌaro hijadeje. Hijamu gagorovo ë osare raromare ariböviohuro ae ahoꞌobëhe heꞌi Iesu gemu ërimahareje. ");
INSERT INTO aom_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Ërimahamu uëvadeje: God-are jö adahamu hejarije ë hesi muoho aviavejöꞌe rovëꞌe höjo. ");
INSERT INTO aom_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Iesuro ëhi jiëꞌe jöho jövamu hegorovo ae ahoꞌobëhe uvoruomadeje: Hu jö mae jövajëromo hesi huë ma jöho heromo tiöjëvadeje. Tiöjëvamu uvoruomadeje: Ëiaho bogo a börömehu jioꞌi hu Joseph-are harihe höjo. ");
INSERT INTO aom_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Ëhi uvoruomamu Iesuro uëvadeje: Ave uhu jö atarujoho jemëro ëhi ueꞌaꞌarujëjo: Oso muebejanue aho jero jasi ajamirovego mae javajo. Ëhesi bëhoho jemëro ueromo ëꞌarujëjo: Arue Capernaum amore mu vaejane ë hesi jö hejaroho ëhi jiëꞌe muoho ave jasi amoro vaejego no gavarëjo. ");
INSERT INTO aom_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Röhu ave jöho na jö mae uëꞌiëꞌajëjo. Jö God-aro baeromo majëhijarue aribövioho nosi saꞌa rajohuro bogo ma uehorovavuarue höjo. Bogo mae bogajo. ");
INSERT INTO aom_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Röhu aveho na jö mae uëꞌiëꞌajëjo. Elijah-hu hijade majaroho ave Israel saꞌare magonaho dorue ahoꞌobëhe jioꞌamade höjo. Evare majare ëni bogo mae bogo rovadoho vadune niöꞌi gemu röhu döre manaere 6 ëhi barëjëꞌëro ëhuꞌëro saꞌae ahoꞌobëhe majae ëgobövie vadune raromare höjo. Vadune raromamu evare ");
INSERT INTO aom_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","magonaho dorue ahoꞌobëhe ave Israel saꞌare raromaroho God-ro Elijah hesi saꞌa rajo magonaho doruoho bogo gemu vaduꞌe ajamijöro jabumënioho nugöꞌöꞌi saꞌae gö Sidon amonörire saꞌare Zarephath amore hijade magonaho doruohuni gemu nugöꞌöjade höjo ajamiꞌiröhego. ");
INSERT INTO aom_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","O jö God-aro baeromo majëhinövade ae Elisha-hu hijade majaroho ave Israel saꞌare sino jomoꞌe ae ahoꞌobëhe jioꞌamade höjo. Röhu Elisha-ro Israel raromarue jomoꞌe aribövi bogo ae gemu vaduꞌe jabesi sinoho avohëhoꞌi Syria rajemu gemu a ihe Naaman hesi sinoho avohahade höjo. ");
INSERT INTO aom_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Ëhi majëhijamu hegorovo ë God rajahijarue osare raromarue ariböviohuro heromo sisë maro dë vörönimoruomadeje. ");
INSERT INTO aom_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Dë vörönëgamu riꞌöromo Iesu amore jiamu guduamo baeromo amoꞌe dahoru bönure iojiomoromo dahoru vösöre suorovareje barado döre riravoꞌi babaꞌamoꞌirovo. ");
INSERT INTO aom_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Ëhiꞌoꞌi ëꞌoruomamu gëgorovo Iesuro jabesi ririre jioromo rëmöꞌöromo vaꞌadeje. ");
INSERT INTO aom_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Vaꞌoromo Iesuro abuejadoho abo Galilee saꞌare Capernaum amore höröjadeje. Höröromo Jew rajo jabesi nuho majaho rovamu God rajahijarue osare vaꞌoromo jöho röjëhijadeje. ");
INSERT INTO aom_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Jöho röjëhijamu heromo tiöromo uvoruomadeje: Hesi jöho darugoꞌe ma-mabëhe javavajëjo. Ëhi uvoruomade hesi bëhoho hesi birire baejëꞌëro hu jöho majëhijadeje. ");
INSERT INTO aom_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Amo ë osare Satan-are a sisëhu dëre abuejëꞌe aho hijëꞌe jiadeje. Hijëꞌëro ma-darugoꞌo uvadeje: ");
INSERT INTO aom_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","Hë-ajo. Iesu Nazareth rajoho ja rabëni sihusihuaguoꞌi rovane höjo. Na ja ijumavuoꞌi ëꞌanuëjo. Na iae ja gavajëjo. Ja God-aro jioromo rovëꞌe a ma-maemu jiëꞌe ae javajëjo. ");
INSERT INTO aom_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Ëhi uavamu hejëꞌi Iesuro uavadeje: Jöho vuonugoꞌi höröjëjo. Höröjëjamu hejëꞌi uhure a sisëhuro ë a hesi simanoho huotovahamu ë aribövi jabesi nunire saꞌare behumorovadeje. Saꞌare behumorovamu uhure a sisëhuro ë a hesi sino hahoꞌoho bogo ijumahoꞌi ma-höröromo vaꞌadeje. ");
INSERT INTO aom_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Höröromo vaꞌamu gagorovo ae ahoꞌobëhe garomo tiöjëvamu uarovareje: Aveho rabuꞌe jöho höjo. Darugoꞌe jöho jövego a sisëhuro ma-burëro ejahoromo suorovo vaꞌoruomaje höjo. ");
INSERT INTO aom_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Ëhiꞌamu Iesuhu vaejaje mu hesi jöho ë saꞌaho ahoꞌobëhe he barëjareje. ");
INSERT INTO aom_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Röhu a sisëho dëre jioromo hörö vaꞌamu Iesuro God rajahijarue osare jioromo vaꞌadeje. Vaꞌoromo Simon-are osare vaꞌadeje. Röhu Simon-are jure magonaho hesi sino hahoꞌoho vöröꞌirae avohëꞌe jiadeje. Vöröꞌiraejamu Iesu uavareje: Na ja magonahoho ajaminëjo. ");
INSERT INTO aom_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Ajaminëjamu hegorovo Iesuro vaꞌoromo bëhire ruahoꞌamo namiromo uavadeje: Vöröꞌiraejanuoho uꞌuhëjo. Uꞌuhëjamu sino hahoꞌere vöröꞌiraejadoho uꞌuhadeje. Uꞌuhamu hejëꞌi riꞌöromo irunoꞌe avohëhoromo iꞌimëmadeje. ");
INSERT INTO aom_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Iꞌimëmamu majae bevaꞌamu gagorovo ae rahu hesi ae guomo guome gö gö jiëꞌoho ujuoho rovamu Iesuro hesi övoho ae ahoꞌobëhe jabesi sinore bamëhoꞌego marëꞌamonövadeje. ");
INSERT INTO aom_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Marëꞌamoꞌego aruꞌaho sisë ae ahoꞌobëhe jabesi dëre raromarohuro suorovo vaꞌonövareje. Suorovo vaꞌiëꞌiroho ma-darugoꞌo uvonövareje: Ja God-are Harihe javajëꞌego heromo uënövadeje: Jöe nugohëjo. Nadi nasi jöho huruohohëjo. Iesuhu ëhi jiëꞌe jö jövade hesi bëhoho ë aruꞌaho sisëho jaburo garomo uvareje: Hu böröme namiromo ae ajëmaje aho höjo. ");
INSERT INTO aom_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Ëhi ëꞌëꞌëro sisonuvamugo Iesuro riꞌöromo vaꞌoromo a rumoꞌe saꞌare ë hijadeje. Hijamu ae ahoꞌobëhe hu nahobe rovareje. Nahobe rueromo gavare ë hijamu gagorovo nijioꞌiraeromo uavareje: Nadi vaꞌi rueromo noꞌo hijëjo. ");
INSERT INTO aom_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Noꞌo hijëjamu hegorovo uëvadeje: Iae mae uevarujëjo röhu God-hu böröme namiromo muebejëvaje jöho ë jöho amo ioroꞌiorohuꞌo majëhibe vaꞌejöjo ë hesi bëhoho God-ro ëhuni remöꞌöjamu rovëꞌëro. ");
INSERT INTO aom_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Ëhiꞌonugoromo Judea saꞌare God rajahijarue osare osare jöho majëhibe juvadeje. ");
INSERT INTO aom_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Iae Iesuro Gennesaret eꞌu riröre namijadeje. Namijamu ae ahoꞌobëhe God-are jöho heꞌi tagavoromo bijimöꞌörovobe rueruomadeje. ");
INSERT INTO aom_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Rovamu Iesuro namiromo gavadeje boat niöꞌi eꞌu riröre raromëvoꞌi visu suovarue aribövioho roriꞌo raromoromo viöho uꞌovamu. ");
INSERT INTO aom_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Ëhi ganugoromo boat gemu Simon-are boat-re ajio hiromo Simon uavadeje: Ave riröre jioromo biduohöꞌöjego roriꞌo vaꞌajo. Roriꞌo vaꞌa uanugoromo gavade eni jiamu gagorovo boat-re ëhi hiromo jöho röjëhijamu rue saꞌare raromare ariböviohuro heruomadeje. ");
INSERT INTO aom_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Heruomamu Iesuro hesi jöho jövobe vaꞌojuvo barëjamu Simon uavadeje: Ave jasi boat-oho baeromo eꞌu umahëꞌinö huoꞌöbe vaꞌoromo jaꞌo jasi ariböviohuꞌo viöho baꞌamorëjo ëhuro visue ahoꞌo suovoꞌirarije höjo. ");
INSERT INTO aom_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Suovoꞌirarije höjamu Simon-ro uavadeje: Tisa ëho iae mae höjo röhu no vahi bövie visu suovoꞌi ëꞌo gabe rovaroho gavare höjo bogo eni javuamu. Röhu jero uëꞌego ëhuni viöho baꞌamoꞌejöjo. ");
INSERT INTO aom_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Ëhi uanugoromo viöho baꞌamoromo visue ahoꞌobëhe suovamu viöho dadorovoꞌiëꞌadeje. ");
INSERT INTO aom_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Dadorovoꞌiaꞌamu gagorovo Peter-mëro jabesi a ioroꞌiore boat göre arijaruoho övëro uëvareje: Ro ajamuihëjo. Ro ajamuihëjamu rueho jaburo rueromo ajëmiromo visue ahoꞌobëhe suovoromo ë boat niöꞌire bahijamu irijiomoromo diruvëvo varijëne jiadeje. ");
INSERT INTO aom_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Ëhiꞌamu gagorovo Simon Peter-ro Iesuare bëhire ague aho hiromo uavadeje: Bada na remo vaꞌëjo. Na a sisë jevajëjo. ");
INSERT INTO aom_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Peter-mëro visue ahoꞌobëhe mae suovoruomoromo tiöjëvëꞌëro jiëꞌëro ëhuꞌëro ëhi uavadeje. ");
INSERT INTO aom_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Peter-më tiöjëvoꞌi Jamesꞌo Johnꞌo jabuꞌo tiöjëvadeje. Röhu Jamesꞌo Johnꞌo jabumë Zebedee-are harihe jëvadeje. Jabumë Simonꞌo gemu mae muoho vaenövareje. Amo tiöjëvamu Iesuro Simon uavadeje: Nadi juhuonivonëjo. Aviavejöꞌe aevoromo ja bogo visuoho gagovoꞌi ae magonahe gagovëvoꞌiramu nasinö jioruomoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Ëhi jövamugo boat-re rueromo ravoꞌamoromo boat-oho jagu ömëvo vaꞌo nieꞌuahore ötöjëvareje. Ötöjëvonugoromo jabesi muoho bövioho biseꞌoho vuonugoꞌi aevoromo Iesuare ijore ijore jijihonövareje. ");
INSERT INTO aom_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Iae Iesuro amore hijadeje. Hijamu ae gemu sino hahoꞌe jomemu jiëꞌohuro rueromo Iesu garomo ague aho hiromo ëninamiromo uavadeje: Bada ja nasi sino avohehoꞌiranoho ja eni javajëjo. Ëhuni jasi nimoromo ajemijëꞌohuro iae ajemiꞌanuëjo. ");
INSERT INTO aom_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Ajemiꞌanuëjamu Iesuro övoho nugöꞌöromo sinoho rëhahoromo uavadeje: Iae na negajëjo ajamiꞌiro. Marëjëjo. Marëjëjamu gavëꞌi jomoho rireromoromo hesi sinore sisë sisëho barëjadeje. ");
INSERT INTO aom_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Sisëho barëjamu gagorovo Iesuro uavadeje: Naehu ëhi ëꞌodoho nadi aho huruoho majëhinëjo. Aꞌi ma-vaꞌoromo jasi sinoho priest röjahijego gaꞌirajo. Ëhiꞌoromo Moses-hu uövuade ëhi jiëꞌe suvuoroho God-are öroro bojamego aëro garomo uvoꞌirarëjo: Jasi sinore sisëho barëjëꞌëro iae mae javajëjo. ");
INSERT INTO aom_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Bogo aho huruoho majëhiꞌiröhego uavadeje röhu ë huhu vaejade mu jöho börömo mae rumorovamu ae gö gö hebe vaꞌoruomadeje. Hebe vaꞌoruomëꞌëro ae ahoꞌobëhe rueromo gagovoruomadeje hesi jöho heruomoꞌi huro jabesi sino hahoꞌoho ajëmego marëjëvoꞌiröhego. ");
INSERT INTO aom_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Ro gagovoruomamu gëgorovo Iesuro a rumoꞌe saꞌare vaꞌo hiromo God-are örire jöe jövadeje. ");
INSERT INTO aom_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Ëhiꞌoromo iae Iesuro aribövioho jöho röjëhijamu Pharisee ariböviohuꞌo Jew rajo jögoru öri röjëhijarue ariböviohuꞌo ëho jaburo hesi bëhire raromoruomadeje. Urimëꞌi ë aribövioho ioroꞌiorohuro ë Galilee saꞌare amo göre göre jioromo ioroꞌiorohuro arue Jerusalem amore Judea saꞌare amo ioroꞌiorore jioromo rueruomëꞌëro ë raromoruomadeje. Raromamu Iesuro jöho röjëhiromo Badare darugoho baejëꞌëro guomo guomoꞌe a jabesi sino avohëhoꞌiröhoho eni jiadeje. ");
INSERT INTO aom_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Sino avohëhoꞌiröhoho eni jiamu iae aëro övo höruꞌe vuovahëꞌe aho maratuoroho giojimo barovareje. Barueromo osanö bavaꞌoromo Iesuare bëhire bamoꞌiröhe öroho nahareje. ");
INSERT INTO aom_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Öroho nahoromo gavare ae ahoꞌobëhe tagavoromo ojanoho urahëꞌe jiamu gagorovo baꞌojiomoromo javuoho dönö dadovöꞌöromo maratuohuꞌo nume osare riravarue aribövi jabesi ririre Iesuare bëhire ë baꞌamareje. ");
INSERT INTO aom_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Baꞌamamu gagorovo Iesuro gavade iꞌe rovare ariböviohuro hu mae uehorovoruomamu gëgorovo övo höruꞌe vuovahëꞌe aho uavadeje: Isiajo. Jasi sisëho uehorovoromo vuonugoromo muꞌu barëjahëꞌe höjo. ");
INSERT INTO aom_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Muꞌu barëjahëꞌe höjamu hegorovo jögoru öri röjëhijarue ariböviohuꞌo Pharisee ariböviohuꞌo uarovareje: Asëꞌëjo. Sareri ae höjo. Huro God sivoromo ëhi jiëꞌe jöho jövajëjo. Hu ma-ae höjo. Röhu huro ë aho uavajëjo: Naro jasi sisëho uehorovoromo vuonugoromo muꞌu barëjahëꞌe jevajëjo. Ëhi jiëꞌe muoho hesi God-ro gemuëro vaejaje höjo. Ma-aho bogajo. ");
INSERT INTO aom_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Ëhi atamu gagorovo Iesuro uëvadeje: Jemë rabëni uehore gö gö baejarujëjo. ");
INSERT INTO aom_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Jemëꞌo uehorovohëjo. Nani ja ae ëma uaꞌaꞌanuëjo: Jasi sisëho uehorovoromo vuonugahëꞌe hö uaꞌaꞌanuëjo. Ja ëhi uaꞌibejanëjo aho nunoho bogo gaꞌibejarëjo ja mae o sarere jövëꞌe javego. Röhu ja bogo ëma uaꞌaꞌanuëjo: Riꞌöromo nami juvëjo hesi guomo guomoho bogo barëjego ja javojagojöëni. ");
INSERT INTO aom_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Röhu ë bogo ëma jövoꞌibejane jöho iae na jövoꞌejöjo huro ejehoromo riꞌö nami juvego jemëro ë muoho garomo ëhuro gaꞌirarijego God-are A Maho naro saꞌare hijajire evare sisë muꞌuvaje darugoho ëhuꞌo baejëꞌe jevego. Ëhi uënugoromo röhu övo höruꞌe vuovahëꞌe aho uavadeje: Naro ja uavajëjo: Jero riꞌöromo raromanue maratuoho banigojiomoromo baeromo jasirëro vaꞌëjo. ");
INSERT INTO aom_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Vaꞌëjamu hejëꞌi ruehuro ae ahoꞌobëhe jabesi nunire riꞌöromo maratuoho banigojiomoromo baeromo God rajahibe hesirëro vaꞌadeje. ");
INSERT INTO aom_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Vaꞌamu gagorovo ë aribövioho ahoꞌobëhe tiöjëvamu juhuonivoromo God rajahiromo uarovareje: Asëꞌëjo. No bogo gavarue muoho jaruvo gavëꞌe javuajëjo. ");
INSERT INTO aom_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Ëhiꞌamu gagorovo Iesuro riꞌöromo vaꞌadeje. Vaꞌi gavade tax baejaje ae hesi ihoho Levi hesi mu vaejaje osare hijamu gagorovo uavadeje: Rueromo nasi ijoro ijoro juvonövonëjo. ");
INSERT INTO aom_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Juvonövonëjamu hegorovo hesi muoho ahoꞌo vuonugoꞌi riꞌöromo aevoromo Iesuare ijore ijore juvonövadeje. ");
INSERT INTO aom_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Ëhiꞌoromo Levi-ro Iesu rajahiꞌi sörö böröme hesi osare bamoromo Iesuꞌo a ioroꞌiorohuꞌo ahoꞌobëhe uëvadeje: Rueromo söröe ihëjo. Ihëjamu hegorovo tax baejarue ae ahoꞌobëhe ëhi jiëꞌe a ioroꞌiore ahoꞌobëhe ëho jaburo ro gemuoro raromoromo ie ueꞌahareje. ");
INSERT INTO aom_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Ie ueꞌahamu gëgorovo Jew rajo jögoru öri röjëhijarue Pharisee ariböviohuꞌo Pharisee aribövi ioroꞌiorohuꞌo ëho jaburo dë vörönëgamu Iesuare aribövioho uëvareje: Jemë rabëni tax baejarue ariböviohuꞌo sisë a ioroꞌiorohuꞌo gemuoroho ioho jovoho ueꞌaharujëjo. Ëhi jiëꞌoho sisë höjo. ");
INSERT INTO aom_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Sisë höjamu hegorovo Iesuro uhuꞌe uëvadeje: Röhu guomo guomoꞌe ariböviohuremu doctor gavarue höjo mae jëvëꞌe aribövioho bogajo. ");
INSERT INTO aom_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Ëhesi bëhoho naro sisë aribövioho sisë vaejaruoho vuonugojöro uëꞌi rovode höjo ma-döemu mae jëvëꞌe aribövioho bogajo. ");
INSERT INTO aom_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Iae aëro Iesu uavareje: John-are jö hejarue ariböviohuro majae ahoꞌobëhe God uehorovoꞌi ioho vuonugoromo hesi örire jöe atoꞌi arijarue höjo. O Pharisee jabesi jö hejarue aribövioho jabuꞌo ëhi jiëꞌe muoho vaeꞌi arijarue höjo. Jabumëhu ëhi ëꞌaruoho iae mae höjo. Röhu jasi aribövioho ioho bogo vuonugoꞌi ma-iemu jovemu ueꞌaharue höjo. Rabëni ëhioho ëꞌarue höjo. ");
INSERT INTO aom_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Rabëni ëhioho ëꞌarue höjamu hegorovo Iesuro uhuꞌe uëvadeje: Iꞌo masuröhe a hesi söröre aemoꞌaemehu rueromo i iꞌiëꞌiroho jemë tugohëvoꞌirarijoho na eni jëvajëjo o bogajo. Bogajo. ");
INSERT INTO aom_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Röhu majae ijonö iꞌo masuröhe aho aëro guduamo bavaꞌiramu evare majare ioho vuonugoꞌaruëjo. Avevejöꞌoho naro jabuꞌo hijëꞌego jabu ioho bogo vuonugoꞌaruëjo. ");
INSERT INTO aom_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Ëhi uënugoromo Iesuro uhu jöe göꞌo majëhiromo uëvadeje: Niögu iꞌohuꞌo mamiohuꞌo bogo havoꞌanuëjo. Bogo havoromo dadovadiroho niögu iꞌoho baeromo bisemu tariöꞌöromo niögu mami hesi gagoroho bamoromo sigohiꞌanuëjo. Ëhi ëꞌibejanëjo niögu iꞌoho tariöꞌöjëꞌëro ëhuro sisërëꞌibejajo. O niögu mamioho ëho nu anoꞌe gö jioꞌi iꞌoho nu anoꞌe gö jioromo ëhuro niögu mamiohuꞌo sisërëꞌibejajo. ");
INSERT INTO aom_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","O wine jovo mi sino gagore biguꞌiëꞌiroho jovo iꞌohuꞌo mi sino mamiohuꞌo bogo gemuoroho havoromo jovo iꞌoho mi sino mamiroho biguꞌanuëjo. Ëhi ëꞌibejanëjo jovohuro gatovoromo ögohuro bibivoromo mi sinoho mamiëro jiëꞌëro tögömoromo ioroꞌioremu dadorovego jovoho rovaꞌibejajo. ");
INSERT INTO aom_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Aꞌi jovo iꞌoho mi sino iꞌo hesi gagoremu biguꞌanuëjo. ");
INSERT INTO aom_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Röhu jovo mami ueꞌahëꞌoho aëro uvarue höjo: Mamioho mae höromo ëhuni iꞌoho bijönimarue höjo. ËJew rajehu Iesuare mu iꞌo bijönimarue jöho Iesuro uhuꞌe ëhi majëhijadeje. ");
INSERT INTO aom_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Iae Jew rajo jabesi nuho majaho rovamu gagorovo Iesumëro mure jijihareje. Jijihoromo hesi ijorajo ömoꞌömohuro ioho babovoromo övëro uhiromo ueꞌahobe vaꞌoruomadeje. ");
INSERT INTO aom_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Ioho övëro uhiromo ueꞌahobe vaꞌamu gëgorovo Pharisee ariböviëro uëvareje: Jaruvoho nuho majae höjo. I avoharujoho ëho nuho maja hesi jögoroho aharujëjo. Rabëni ëhi jiëꞌoho ëꞌarujëjo. ");
INSERT INTO aom_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Ëꞌarujëjamu Iesuro uëvadeje: David nosi a böröme jionövade höjo. Röhu huꞌo hesi ariböviohuꞌo hömëvamu hegorovo huhu ëꞌade jö God-are surire adaharijoho ëho diehiꞌoromo bogo avoho uehorovarujëjo. ");
INSERT INTO aom_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","David-ro God-are osare vaꞌoromo God-are nunire bahijare ioho ujuohoromo vituoho iꞌi vituoho hesi aribövioho iꞌimëmamu ueꞌahare höjo. Ëhi jiëꞌe ioho aho bogo ueꞌahoꞌi hesi ma-priest-ëremu ueꞌahoꞌiröhe ie höjo. Röhu jabuhu ueꞌaharohuro ëhuro jögoroho ahare höjo. Röhu ë hesi jöho bogojiade höjo. ");
INSERT INTO aom_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Ëhi uënugoromo uëvadeje: God-are A Maho naro nuho maja hesi jögoroho muebejaje höjo. ");
INSERT INTO aom_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Ëhi uëvëꞌëro Jew rajo jabesi nuho majae göꞌo rovadeje. Nuho majae göꞌo rovamu Iesuro God rajahijarue osare vaꞌoromo hesi jöho röjëhijadeje. Amo ë osare övo manörire övo hitahi guomahëꞌe aho hijëꞌe jiadeje. ");
INSERT INTO aom_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Jew rajo jögoru öri röjëhijarue ariböviohuꞌo Pharisee ariböviohuꞌo ëho jaburo Iesuare jö sisëho nahoromo uvareje: Iesuhu guomo guomoꞌe aribövi jabesi sino avohëhëꞌoho noro a masijoho huruoho majëhiromo uëꞌejarëjo: Iesuro a ajëmaje muoho vaeromo nuho maja hesi jögoroho ahade höjo. Ëhi uvoromo jabumëro ma-hu gemu ërimahareje gaꞌiro nuho majare hu guomo guomoꞌe aribövi jabesi sinoho avohëhego o bogo. ");
INSERT INTO aom_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Ërimahamu Iesuro gëromo uvadeje: Jabumë ëhi ëhi uehorovaruë uvoromo övo guomahëꞌe aho uavadeje: Ro ave nosi riroro namijëjo. Namijëjamu ro jabesi ririre namijadeje. ");
INSERT INTO aom_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Namijamu hu bijönimoromo ërimaharuoho Iesuro uëvadeje: Na ave jöho uë gëꞌiëꞌajëjo. Nosi nuho maja hesi jögoroho diehi höjo. Nuho majaroho na ae mae vaejëvoꞌejarëjo o sisë vaejëvoꞌejarëjo. Iꞌovëvoꞌejarëjo o muoꞌamoꞌejarëjo. ");
INSERT INTO aom_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Ëhi uënugoromo uherihoromo ë aribövioho ahoꞌobëhe gënugoromo övo guomahëꞌe aho uavadeje: Jasi övoho nugöꞌöjëjo. Ëhi uavamu hegorovo övoho nugöꞌöjamu marëjadeje. ");
INSERT INTO aom_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Marëjamu rue ariböviohuro gavare Iesuro ë aho ajamiꞌego marëjamu gagorovo dë vörönëgo avohadeje. Dë vörönëgamu jöe atoromo uarovareje: No Iesuare öriroho diehiꞌoꞌejarëjo. ");
INSERT INTO aom_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Ëhiꞌoꞌirögoro Iesuro God-are örire jöe jövoꞌiro dahorure ajiomadeje. Ajio hiromo vahi bövie God-are örire jöe jövobe vaꞌojuvo ëhi sisonuvadeje. ");
INSERT INTO aom_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Sisonuvamu gagorovo hesi ijore ijore jijiharue ariböviohuro ruejöro uvëvadeje. Uvëvoromo rovamu ae ahoꞌobëhe 12 hesi baejëvadeje. Baejëvoromo uëvadeje: Jemë nasi apostle jëvajëjo. ");
INSERT INTO aom_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Iesuro Simon baejadeje. Baeromo iho göho Peter jumuvadeje. O Peter-are öho Andrew baejadeje. O göho James John Philip Bartholomew ");
INSERT INTO aom_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matthew Thomas o James Alphaeus-are harihe o Simon aehu uvaruoho Jew rajehu jabesi mueberovoꞌi nimaje aho ");
INSERT INTO aom_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","o Judas James-are harihoho o göho Judas Iscariot ë aribövioho baejëvadeje. Judas Iscariot Iesuni hiruëmiromo a jabesi övore bojëmiꞌiröhe aho jiadeje. ");
INSERT INTO aom_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Ëaribövioho baejëvonugoromo Iesuro jabuꞌo gemu mae abueromo enure ë namijadeje. Namijamu hesi aribövie ahoꞌobëhe mae o a ioroꞌiorohuꞌo arue Jerusalem amore jioromo Judea saꞌa ioroꞌiorore jioromo nume Tyre amo Sidon amo jiajinö sö jovo bëhire saꞌare jioromo ae ahoꞌobëhe mae ë ro riravareje ");
INSERT INTO aom_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Iesuare jöho heruomoꞌi huro ajëmego jabesi sino hahoꞌoho marëjëvoꞌiröhego. Ro riravamu a sisëhu dëre abuejëvëꞌëro iꞌu baejarue aribövioho Iesuro ajëmamu marëjëvadeje. ");
INSERT INTO aom_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Marëjëvamu ae ahoꞌobëhe gavare Iesuare darugohuro rueromo guomo guomoꞌe ae ahoꞌobëhe ajëmamu gagorovo Iesu rëhoꞌi ëꞌo gavareje ëhuro guomo guomoho barëjëvoꞌiröhego. ");
INSERT INTO aom_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Ëhiꞌamu Iesuro hesi ijorajo ömoꞌömoho gëromo uëvadeje: Bövi biseꞌo rumoꞌe aribövioho jemë huë mae jëvajëjo God-ro muebejëvego hesi aharire mae raromoꞌiëꞌëro. ");
INSERT INTO aom_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Avevejöꞌe hömëvaje aribövioho jemë huë mae jëvajëjo maja ijonöho eni daꞌuëgoꞌiëꞌëro. Avevejöꞌe nierusuburuꞌe bamaruje aribövioho jemë huë mae jëvajëjo maja ijonöho nimorohoꞌiëꞌëro. ");
INSERT INTO aom_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Jemëhu God-are A Maho na uehorovevamu aehu gëromo bijönëgoromo nu huodëgoromo sivëgoromo jemesi ihoho sisë höromo vuonugëhëꞌoho huë mae jëvaje höjo. ");
INSERT INTO aom_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Jabuhu ëhi sisë vaejëvëꞌiroho jemëro hirohiromoromo nimoroho avohorëjo God-hu suvuoro jemëni öꞌidöre bamëhajoho böröme jiëꞌe jiaje. Ëaribövi jabesi hijo mionoꞌohuro jö God-aro baeromo majëhinövare aribövi jabesi örire ëhi gemuoho sisë vaejëvonövare höjo. ");
INSERT INTO aom_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Aꞌi bövi biseꞌo marohëꞌe mae jëvëꞌe aribövioho vaevëꞌe jëvajëjo. Jemesi bövi biseꞌo maho ujuoho barëjëꞌëro ijonöho bogo ujuoho hesi jëvajëjo. ");
INSERT INTO aom_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Avevejöꞌe daꞌuëgëꞌe aribövioho vaevëꞌe jëvajëjo. Maja viture vadunëro vuovëvo hesi höjo. Avevejöꞌe nimoroharuje aribövioho vaevëꞌe jëvajëjo. Maja viture huë vavaene baejëꞌi nierusuburuꞌe bae hesi jëvajëjo. ");
INSERT INTO aom_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Ae ahoꞌobëhe jemesi jö ma-mabëhe atëꞌoho vaevëꞌe jëvajëjo. Ëaribövi jabesi hijo mionoꞌohuro God-are jö huotohuotovoromo majëhinövare aribövi jabesi örire ëhi gemuoho mae atonövare höjo. ");
INSERT INTO aom_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Röhu jemë nasi jö hejaruje ariböviohumë ave jöho majëhiꞌiëꞌajëjo. Jemëꞌo muorovarue aribövioho huë baejëvorëjo. Jemë nu huodëgarue aribövioho mae vaejëvorëjo. ");
INSERT INTO aom_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Jö sisë uëvarue aribövioho jö mae uërëjo. Sisë vaejëvarue ariböviohuni God-are öroro ëninamirëjo. ");
INSERT INTO aom_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Aehu aꞌisabi gönö anagëꞌiroho hunuorovego aꞌisabi gönöhuꞌo anagoꞌirajo. Aehu niögu gö baeniahijëꞌoho nadi nijioꞌiraejego niögu göhuꞌo baeꞌirajo. ");
INSERT INTO aom_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Aehu jasi örire böviëni biseꞌëni ëninamijëꞌoho bojaminëjo. Aehu jasi mae sisë baejahëꞌoho nadi uanëjo: Sionëro bojemëjo. ");
INSERT INTO aom_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Jemë ae göehu diehi vaejëvojöro nëgëꞌoho jemëꞌo ëhi jiëꞌe muoho ae gö jabesi öroro vaejëvorëjo. ");
INSERT INTO aom_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","O jemë huë baejëvarue aganohemu huë baejëvëꞌoho rabëni uvorëjo: God-are nunire mabëhe javuajëjo. Sisë ariböviohuro jabuꞌo huë baejëvarue aganoho mana huë baejëvarue höjo. ");
INSERT INTO aom_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","O jemë mae vaejëvarue ariböviohemu mae vaejëvëꞌoho rabëni uvorëjo: God-are nunire mabëhe javuajëjo. Sisë ariböviohuro jabuꞌo ëhi gemuoho ëꞌarue höjo. ");
INSERT INTO aom_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","O uvëꞌoho: Ëhi gemuoho vuonoröꞌö baeꞌejöromo ëhuni bövi biseꞌo ma-jahuri ae gö bojëmijëꞌoho rabëni uvorëjo: God-are nunire mabëhe javuajëjo. Sisë ariböviohuro jabuꞌo uvoruomaje höjo: Ëhi gemuoho vuonoröꞌö baeꞌejöromo ëhuni bövioho biseꞌoho ma-jahuri ae gö bojëmijarue höjo. ");
INSERT INTO aom_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Aꞌi jemë nu huodëgarue aribövioho huë baejëvorëjo. Mae vaejëvorëjo. Nadi uvorëjo: Mana bojemiꞌaruë uvëꞌi jemesi bövioho biseꞌoho ma-bojëmirëjo. Ëhi ëꞌëꞌoho God-ro jemë suvuoro böröme bojëmiꞌajëjo. Ëhuro God-hu dö mare hijaje a hesi aboji harihuꞌo mae jëvoꞌajëjo. Ëhesi bëhoho God-ro gëvaje a sisë jioruomoꞌi bogo mana mabëhe uavëꞌe suvuore ëma baejarue aribövie jëvego gëgorovo huro ëma huë baejëvoromo ajëmijaje höjo. Huhu ëꞌaje ëhi jiëꞌe mu vaejëꞌoho jemë hesi aboji harihuꞌo mae jëvoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Ëhuni jemesi Vavuehu jemëni vavaenimajëhi ëhi ae göëni vavaenimorëjo. ");
INSERT INTO aom_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Nadi döroho bamorovoromo a jabesi sisëho mevorëjo. Jabesi sisë bogo mevëꞌoho God jemesi sisëhuꞌo bogo mevoꞌajëjo. Nadi a jabesi sisëhunioho iꞌuoho bojëmirëjo. Iꞌu bogo bojëmijëꞌoho God jemëꞌo iꞌuoho bogo bojëmiꞌajëjo. Aꞌi ae gö jabesi sisëho uehorovoromo vuonugorëjo. Ëhi ëꞌëꞌoho God-ro jemesi sisëhuꞌo uehorovoromo vuonugoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Ae suvuorëmirëjo. Jemë ëhi ëꞌëꞌoho God-ro jemëꞌo suvuorëmiꞌajëjo. Börömo mae suvuorëmiromo jemëro övoho avohoꞌiramu sörö vaꞌëne ë bamëhoꞌiramu övo duvahoho rarovoromo oterohoꞌaꞌajëjo. Bogo biseꞌo vaduꞌoho suvuorëmiꞌajëjo. Jemë diminoꞌe bojëmëꞌohuro ëhuro ë bojëmarije minoꞌe ëhi baeꞌaꞌarujëjo. Iesuro ëhi jövadeje. ");
INSERT INTO aom_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Röhu Iesuro röjëhiꞌiro ave uhu jöho uëvadeje: Nuni sisëꞌe a göhuro nuni sisëꞌe a göho diehi öroho röjahibe vaꞌaꞌajëjo. Bogajo. Röjahijëꞌoho jabumë niöꞌi guare bejëvo vaꞌaꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Jö hejaruje aribövioho jö röjëhijaje aho na bogo iosiremiromo jö maho baeꞌaꞌarujëjo. Jöho he barëꞌiramu evare jö röjëhijaje aho vaꞌëne jëvoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Röhu ja diehiꞌoromo ijo ugobajoꞌe biseharihehu isiare nunire namijajoho gaꞌi ijo börömehu jasi nunire namijavajoho bogo gavanuëjo. ");
INSERT INTO aom_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Ijo börömehu jasi nunire namijavajoho bogo gavëꞌoho ëhuꞌoho ja rabëni jasi aemoꞌaemoho uanëjo: Isi ëꞌego na jasi nunire ijo ine namijavajoho jahahöjo. Sareri ae javajëjo. Jasi nunire ijo börömehu tugohavajoho jero urimo jahonëjo. Jahonugoromo evare avoho garomo ijo ino harihoho isiare nuniroho jahahoꞌanuëjo. ");
INSERT INTO aom_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Ijo maho bajo sisëho bogo raeꞌi ijo sisëho bajo maho bogo raejaje höjo. ");
INSERT INTO aom_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Ijoho bajoro garomo uvoꞌaꞌanuëjo: Ëijoho mae höjo ëho sisë höjo. Meso böso uroꞌiëꞌiroho mesoremu uroꞌi bibëꞌe ijo sisëroho bogo uroꞌaꞌanuëjo. Rihuꞌe grape bajo uroꞌiëꞌiroho ë öꞌiremu uroꞌi bibëꞌe resu sisëroho bogo uroꞌaꞌanuëjo. Ijo sisëhuro bajo sisëho raeꞌamaje höjo. Ijo mahuro bajo maho raeꞌamaje höjo. ");
INSERT INTO aom_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Ëhesi bëhoho a maho ijo maehu bajo mae raejajëhi ëhi jëvaje höjo. A maho uehoro maëremu jabesi dë vövöbajoꞌere jëvëꞌëro mu maemu vaeruomaje höjo. A sisëho uehoro sisëremu jabesi dë vövöbajoꞌere jëvëꞌëro mu sisëmu vaeruomaje höjo. Aëro diehi jiëꞌe uehorehu jabesi dë vövöbajoꞌere irijiomëvajoho jabesi jöꞌëro atarue höjo. ");
INSERT INTO aom_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Jemëro uevaruje höjo: Bada ja no mu bojamuijanue aho javajëjo. Ëhi jiëꞌoho jemë rabëni naehu bojëmaje muoho bogo vaejaruje höjo. ");
INSERT INTO aom_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Röhu ae rahu nasi örire rueromo nasi jö heromo ejehajoho ëhi jiëꞌe a hesi jöho naro uhuꞌe majëhiꞌejöjo. ");
INSERT INTO aom_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Ae gemuëro javue vaeꞌiëꞌade höjo. Javue vaeꞌirögoro ëgobövie umo abuejuvo munëꞌe saꞌaho birohogoro öboho ë ruhoromo javuoho vaejade höjo bibivoröhego. Javuoho vae barëromo hijamu jovo börömëro ruomoromo ë javuoho anade höjo. Anamu javuoho mae vaejëꞌëro jiëꞌëro bogo orivoꞌi ma-bibivoromo namijade höjo. Nasi jö ejehaje aho ë bibivëꞌe javu vaejade aho vaꞌëne höjo. ");
INSERT INTO aom_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Aꞌi ae rahu nasi jö heromo bogo ejehajoho ëhi jiëꞌe a hesi jöho naro uhuꞌe majëhiꞌejöjo. Ae gemuëro javue vaeꞌiëꞌade höjo. Röhu saꞌaho bogo umo abueromo öboho ruhoꞌi ma-saꞌa döre vaejade höjo. Vaejëꞌëro ë javuoho jovëro ro anamu dadorovo barë nahonahovade höjo. ");
INSERT INTO aom_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Iesuro hesi jöho ae ahoꞌobëhe majëhinugoromo vaꞌadoho vaꞌo Capernaum amore hijadeje. ");
INSERT INTO aom_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Röhu Rome raje muorovo simano vaejaje ae gemuëro ë hijëꞌe jiadeje. Hu bogo Jew rajehu jioꞌi saꞌa gö raje jiadeje. Hesi muemu vaejahaje ahuro huꞌo hijadeje. Hijamu rue simano vaejaje ahuro ë iaho mae uehorovo avohadeje. Mae uehorovo avohamu rue aho guomo guomo böröme baejëꞌëro guomoꞌiëꞌadeje. ");
INSERT INTO aom_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Guomoꞌiaꞌamu gagorovo rue simano vaejaje ahuro Iesuhu a ajëmaje jöho hegoro Jew rajo a duvaho ioroꞌioroho uëvadeje: Vaꞌoromo Iesu uarego rueromo nasi mu vaejehaje a hesi sinoho avohahego marëꞌirajo. ");
INSERT INTO aom_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Ëhi uëvamu hegorovo vaꞌareje. Vaꞌoromo Iesu ëninamiromo uavareje: Ëaho ajaminëjo. Hu a maego jaehu ajamijëꞌoho iae mae höjo. ");
INSERT INTO aom_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Hu saꞌa gö raje höjo röhu huro ave saꞌa rajoho no uehorovavuaje höjo. Uehorovavuajëro jiëꞌëro huro ajamuiromo ae uëvade höjo noehu God rajahijarue osaho vaejahuoröhego. ");
INSERT INTO aom_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Ëhi uavamu Iesuro riꞌöromo jabuꞌo vaꞌadeje. Vaꞌoromo ë simano vaejaje a hesi osa bëhire rovamu gavëꞌi rue simano vaejaje ahuro hesi aho uëvadeje: Vaꞌoromo Iesu birohoromo uarëjo: Badajo. Nadi nasiriroho rueromo uꞌuoho baejëjo. Na ae ma-biseꞌe jevoromo sisë jevëꞌe jaehu nasi osare rovëꞌoho bogo maehu höjo. ");
INSERT INTO aom_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Ëhuni na uehorovoromo uvode höjo: Na öꞌirodoho röhu na bogo maehu jevajëjo. Ëhuni nadi rueꞌi ma-jöꞌëro jöe jövego nasi mu vaejehaje aho marëꞌirajo. ");
INSERT INTO aom_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Ma-jö jövego mu rovaje hesi öroho iae na gavëꞌe jevajëjo. Ëhesi bëhoho na nasi a masijo jabesi aharire jevëꞌëro jabesi jöho ejëhoromo muoho vaeꞌi muorovo aribövioho nasi aharire jëvëꞌëro nasi jöho ejehoromo muoho vaejarue höjo. Naehu muorovo ae gö uavëꞌoho: Vaꞌë uavëꞌiroho iae hu vaꞌaje höjo. O muorovo ae gö uavëꞌoho: Rovë uavëꞌiroho iae hu rovaje höjo. O nasi mu ajemaje a uavëꞌoho: Mue ëhi ëhi vaejehë uavëꞌiroho iae hu ëhi vaejaje höjo. Ëhuꞌëro jö jövego mu rovaje hesi bëhoho iae na gavëꞌe jevajëjo. Ëhuni uavajëjo: Ma-jöꞌëro jöe jövego marëꞌirajo. Ëjöho baeromo Iesu majahirego heꞌirajo. ");
INSERT INTO aom_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Heꞌirajamu simano vaejaje a hesi ariböviohuro ë jöho bavaꞌoromo Iesu majahijareje. Majahijamu Iesuro heromo tiöjadeje. Tiöromo huotorovoromo hu rihiromare aribövioho uëvadeje: Hu mabëhe uehorovevade höjo. Ëhi jiëꞌe aho na bogo birohëꞌe jevajëjo. Nosi Israel rajoho jabuꞌo bogo ëhioho mae uehorovevaruëjo. Iae na mae jövajëjo. ");
INSERT INTO aom_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Ëhi uëvamu hegorovo rue ariböviohuro vuonoröꞌö rueromo simano vaejaje a hesi osare ro gavareje hesi mu vaejahaje aho mamiꞌe marëjëꞌe jiamu. ");
INSERT INTO aom_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Ëhiꞌoꞌirögoro iae Iesuro Nain amore vaꞌi vaꞌadeje. Vaꞌamu Iesuare ijorajo ömoꞌömohuꞌo a ioroꞌiorohuꞌo ae ahoꞌobëhe mae huꞌo vaꞌoruomadeje. ");
INSERT INTO aom_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Vaꞌoromo amo rejo ojo bëhire höröꞌiaꞌamu suorovoꞌiaꞌamu evare aëro guomëꞌe a hesi sinoho amore jioromo guavoꞌi giojimo baeromo rovareje. Röhu vaevëꞌoho guomëꞌe aho magonaho doru hesi harihu gemuꞌoho jiadeje. Amo raje ae ahoꞌobëhe ë magonahohuꞌo rueruomadeje. ");
INSERT INTO aom_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Rueruomamu Badaro magonahoho ganugoromo huni vavaenimamu uavadeje: Nadi nivonëjo. ");
INSERT INTO aom_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Nadi nivonëromo rueromo sino bamare maratuoho rëhadeje. Rëhamu giojimo barovare ariböviohuro ëhi riravareje. Riravamu gagorovo Iesuro a juvijoho uavadeje: Jueꞌiajo. Naro ja uavajëjo: Guomanoho riꞌöjëjo. ");
INSERT INTO aom_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Riꞌöjëjamu döro riꞌö hiromo aevoromo jöe jövadeje. Jöe jövamu gagorovo Iesuro harihoho vëmu hesi övore bamadeje. ");
INSERT INTO aom_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Ëhiꞌamu gavëꞌi ae ahoꞌobëhe juhuonivoromo God rajahiromo uvoruomadeje: Asëꞌe jö God-aro baeromo majahuijaje a börömohuro nosi örire rovëꞌe hö uvoromo God-ro hesi aribövi nosi jöëni vavaenimëꞌe hö uvoruomadeje. ");
INSERT INTO aom_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Ëhiꞌamu gagorovo ae ahoꞌobëhe Judea saꞌahuꞌo saꞌa ioroꞌiore bëhirohuꞌo Iesuare jöho ëhi vaerovemu vaerovobe vaꞌareje. ");
INSERT INTO aom_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Iesuhu ëhi jiëꞌe mu vaejade jöho John-are ijore ijore jijiharue ariböviohuro John majahijareje. ");
INSERT INTO aom_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Ëhi majahijamu hegorovo John-ro hesi aribövioho niöꞌiro ruejöro uëvamu rovareje. Rovamu uëvadeje: Vaꞌoromo Iesu ua garëjo: No uvaruëjo: God-ro ae nugöꞌöꞌiramu nosi örire rueꞌaꞌajëjo. Na ja ë aho javajëjo. O na no muebeꞌejarëjo ae göëro rueröhego. ");
INSERT INTO aom_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Ëhi uëvamu hegorovo vaꞌoromo Iesu uavareje: John bapataeto vaejavuaje ahuro uövuamu rovare höjo. Huro uövuade höjo: Iesu uarëjo: No uvaruëjo: God-ro a böröme nugöꞌöꞌiramu nosi örire rueꞌaꞌajëjo. Na ja ë aho javajëjo. O na no muebeꞌejarëjo ae göëro rueröhego. ");
INSERT INTO aom_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Ëhi uavamu hegoro evare Iesuro guomo guome gö gö juhuoniniꞌoho ahoꞌo aruꞌaho sisëꞌoho ahoꞌo avohoꞌamadeje. Nuni tugorohëꞌe aribövioho ahoꞌo jabesi nunoho dadovëhadeje. ");
INSERT INTO aom_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Ëhiꞌoromo John-are ae niöꞌioho uëvadeje: Vaꞌoromo diehi gavarijoho hejarijoho John majahirego heꞌirajo. Uarëjo: Nöröro ae nuni sisëꞌoho ajëmijego mae uheriharue höjo. Höru sisëꞌoho ajëmijego mae jijiharue höjo. Jomoꞌe aho ajëmijego marëjëvoromo jabesirire sisë sisëho barëjëhaje höjo. Hiaꞌi sisëꞌoho ajëmijego hiaꞌe dadovoromo jöe hejarue höjo. Vuovëꞌe aho ajëmijego iꞌovarue höjo. Bogo eni jiëꞌe aribövioho ajëmiromo majëhijego God-are jö maho hejarue höjo. Vaꞌoromo John ëhi majahirëjo. ");
INSERT INTO aom_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Röhu John o ae rahu biririvoromo nasi örire mae uehorovevëꞌoho ë ahuro maho hiꞌaꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Maho hiꞌaꞌajëjamu John-are ae niöꞌiohuro vuonoröꞌöromo vaꞌareje. Vaꞌamu gavëꞌi Iesuro ë hesi bëhire gagovare aribövioho John-are jöho majëhiromo uëvadeje: Urimëꞌioho jemë rabe gaꞌirögoro John-hu a rumoꞌe saꞌare hijajiroho ëho vaꞌonövarije höjo. Ijo rudu burehu huosihego arue anume vaꞌaje ëhi uehorovaje aho na John ëhi jiëꞌe ae jiamu jemë gaꞌi vaꞌarije höjo. Bogajo. ");
INSERT INTO aom_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","O diehi jiëꞌe ae gaꞌi vaꞌarije höjo. Na niögu mabëhe sanuꞌe ioꞌamëꞌe ae jiego gaꞌi vaꞌarije höjo. Röhu ëhi jiëꞌe niögu ma ioꞌamoromo bövi biseꞌo marohëꞌe ma baeromo raromarue aribövioho bogo a rumoꞌe saꞌaroho raromoꞌi a masijehu raromarue osaremu raromarue höjo. ");
INSERT INTO aom_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Röhu diehi jiëꞌe ae gaꞌi vaꞌarije höjo. Na John jö God-aro baeromo majëhijaje ae jiamu gaꞌi vaꞌarije höjo. Ioꞌajo. John iae hu ëhi jiëꞌe ae höjo. Röhu aveho hehëjo. Jö God-aro baeromo majëhinövare a ioroꞌioroho iosirëmiromo John hu börömoho höjo. ");
INSERT INTO aom_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Iae ë a hesi jöho God-are surire jajivoromo ëhi uvëꞌe höjo: Ave aho God nasi jö bajuvaje aho höjo. Ja vaꞌiëꞌiroho naro hu urimo nugöꞌöꞌiramu vaꞌoromo ae uëꞌaꞌajëjo jaehu vaꞌirane öroho iogorahoröhego. Ëhi jajivëꞌe höjo. ");
INSERT INTO aom_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Ave jöho na jö mae uëꞌiëꞌajëjo. Ave saꞌare raromarue aho ae gemu vaduꞌoho John bogo iosiramiromo börömoho jiëꞌe höjo. Aꞌi God-hu böröme namiromo muebejëvego hesi aharire raromarue a inino mahuro John iosiramiromo döroho jioruomajëjo. ");
INSERT INTO aom_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Iesuro ëhi majëhijamu tax baejarue ariböviohuꞌo a ioroꞌiorohuꞌo ahoꞌobëhe ë jöho heromo uvoruomadeje: God hu mae höjo. Rabëni John-hu bapataeto vaeröhe jöho jaburo ejahëꞌëro. ");
INSERT INTO aom_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Aꞌi Pharisee ömoꞌömohuꞌo Jew rajo jögoru öri röjëhijarue a ömoꞌömohuꞌo ë jöho heromo jabuhu ëꞌojöro God-hu nimaje muoho juahovareje rabëni John-hu bapataeto vaeröhe jöho jaburo bijönimëꞌëro. ");
INSERT INTO aom_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Röhu Iesuro hesi jö vituoho majëhiromo uëvadeje: Ave jaruvore raromaruje aribövi jemesi jöho uhuꞌe majëhiꞌiëꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Amo ririre raromoromo jö bijönimoruomaje asisöꞌoho jëvanovajëjo. Amo ririre raromoromo asisöꞌo ioroꞌiorohuro ioroꞌioroho uvëvoruomajëjo: Noehu aninivoromo jemëni virikö huosihëharoho jemëro bijönimoromo bogo ejahuoromo javavarije höjo. Noehu aninivoromo huë vavaeniꞌe jö iaroho jemëro bijönimoromo bogo ejahuoromo nierusuburuꞌe bamarije höjo. ");
INSERT INTO aom_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Ëhesi bëhoho bapataeto vaejavuaje ae John-ro rueromo God uehorovoromo ma-hiꞌi ioho wine jovoho bogo inövade höjo. Ëhiꞌonövadoho jemëro ë jö bijönimarue asisöꞌoho vaꞌëne bijönëgamu John-are jöho bogo ejahoꞌi sisëꞌi uehorovoromo uvonövarije höjo: Aruꞌaho sisë dëre jiëꞌëro ëhuꞌëro ioho jovoho bogo ijaje höjo. ");
INSERT INTO aom_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","O God-are A Maho naro rueromo ioho jovoho ma-ijaje höjo. Ëhi ëꞌajoho jemëro ëhuꞌo bijönimoromo uvaruje höjo: Nörö gahëjo. Ioho mahunöꞌe iromo vöröꞌe jovemu ijaje höjo. Hu vajiohuꞌe tax baejarue ahuꞌo a sisë ioroꞌiorohuꞌo ëho jabesi aemoꞌaeme höjo. ");
INSERT INTO aom_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Jemëro John-are muohuꞌo nasi muohuꞌo bijönimaruje höjo röhu no God-are uehoro maho baejëꞌëro muoho vaejarue höjo. Ëmu nimarue aribövioho ahoꞌo jaburo garomo uvoruomoꞌajëjo: God-are uehoroho iae mae höjo. Ëhuꞌëro muoho vaejare höjo. ");
INSERT INTO aom_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Ëhiꞌamu Pharisee ae gemuëro Iesu uavadeje: Nasi osaro rovego no ie ijarëjo. Ie ijarëjamu ë a hesi osare vaꞌoromo ie iꞌi saꞌaro hijadeje. ");
INSERT INTO aom_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Röhu sisë magonahe gemuëro ë amore hijadeje. Hiromo hejade uvavamu: Iesuro Pharisee a hesi osare hiromo ie ijajë uvavamu hegorovo ridiꞌe ose munë huono mabëhiroho baeromo rovadeje. ");
INSERT INTO aom_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Barueromo Iesuare dejonö höru bëhire hiromo nivoromo hesi nuni jovohuro Iesuare hörure ahoꞌamodivamu buejahoromo simano uohuro uhijahoromo höroho dudöhahoromo ridiꞌe jovohuro otehahadeje. ");
INSERT INTO aom_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Ëhiꞌamu gagorovo ë Pharisee ae Iesu uavamu rueromo i ijade ahuro uehorovoromo uvadeje: Ave aho jö God-aro baeromo majahuijaje ae jioꞌibejajo hu gaꞌibejajo magonahehu maꞌenajoho rahuo jioꞌi o diehi jiëꞌe mue vaebe juvaje magonahe jiego ahego ëhuro mae jioꞌibejajo. Ëhesi bëhoho hu magonaho sisë höjo. Röhu Iesuhu ë magonaho bogo avoho gavajoho ëhuro hu bogo jö God-aro baeromo majahuijaje aehu höjo. ");
INSERT INTO aom_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Ëhi uehorovamu gagorovo Iesuro Simon ë Pharisee a hesi ihoho Simon uavadeje: Simon na jö harihe majahiꞌiëꞌajëjo. Majahiꞌiëꞌajëjamu Simon-ro uavadeje: Tisa iae mae höjo. Majehego hejöjo. ");
INSERT INTO aom_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Hejöjamu Iesuro uhuꞌe uavadeje: Iae ae niöꞌiehu ae gemu hesi örire moni mana sionehu bojamiꞌiröhoho jëvade höjo. Göhuro 500 kina göhuro 50 kina ë a hesi örire bojamiꞌiröhoho jiade höjo. ");
INSERT INTO aom_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Röhu bogo eni jëvade höjo. Bogo eni jëvamu gagorovo moni baeꞌiröhe ahuro ë ae niöꞌiehu moni bojamiꞌiröhoho uehorovoromo vuonugëhade höjo. Ëhi jiëꞌoho ë ae niöꞌioho di ahuro ë moni baeꞌiröhe a hesi öriroho böröme rajahiꞌi di ahuro ma-bisemu rajahiꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Rajahiꞌajëjamu Simon-ro uavadeje: Na uehorovoromo uvajëjo: Moni böröme bojamiꞌiröhe ahuro ë moni baeꞌiröhe aho böröme rajahiꞌajëjo ë hesi bëhoho huro moni börömo mae uehorovoromo vuonugahëꞌego. Rajahiꞌajëjamu Iesuro uavadeje: Ja mae uevanuëjo. ");
INSERT INTO aom_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Ëhi uaromo huotorovoromo magonahoho gavëꞌi Simon uavadeje: Ave magonahoho gavëjo. Naro jasi osare rovode höjo röhu ja bogo rajehiromo jovoho bojemijane höjo nasi höroho uꞌojöro. Aꞌi ave magonahohuro rajehiromo hesi nuni jovohuro nasi hörure ahoꞌamodegamu ëhuro uꞌovehade höjo. Uꞌovehoromo hesi simano uohuro uhijehade höjo. ");
INSERT INTO aom_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Ja bogo rajehiromo dudöhevëꞌe javajëjo. Aꞌi ë magonahohuro naehu jasirire rovodevare evare aevoromo rajehiromo nasi höroho dudöhobe rovëꞌe höjo. ");
INSERT INTO aom_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ja bogo rajehiromo ninuguꞌe jovoho nasi simanoroho otehehoꞌi ë magonahohuro rajehi avohoromo ridiꞌe jovo mabëhohuro nasi hörure otehehade höjo. ");
INSERT INTO aom_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Ëhuni uavajëjo: Ëmagonahohuro na rajehi avohëꞌëro ëhuꞌëro hesi sisë ahoꞌobëhe jiadoho uehorovoromo vuonugëꞌe höjo. Aꞌi sisë ma-bisemu uehorovoromo vuonugëhëꞌoho ëhi jiëꞌe aribövioho ma-bisemu rajehiꞌaruëjo. ");
INSERT INTO aom_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Ëhi uanugoromo magonahoho uavadeje: Jasi sisëho uehorovoromo vuonugahëꞌe höjo. ");
INSERT INTO aom_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Vuonugahëꞌe höjamu Iesuꞌo raromoromo i ueꞌaharue ariböviohuro jabesi uehorovoromo uvareje: Ëaho hu diehi jiëꞌe aëro jiëꞌëro huro God-are muoho baeromo ae magonahe jabesi sisëho uehorovoromo vuonugëhaje höjo. Hu ëhi jiëꞌe muohuꞌo vaejaje höjo. ");
INSERT INTO aom_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Ëhi uvamu Iesuro magonahoho uavadeje: Jero nasi örire mae uehorovevamu God-ro ja baejavoromo maro ramëꞌe höjo. Vaevëꞌe vaꞌonëjo. ");
INSERT INTO aom_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Ëhi ëꞌëꞌëro Iesuro vaꞌadeje. Vaꞌoromo God-hu böröme namiromo muebejavuaje jö maho baeromo ae majëhibe amo masijore ininore ë vaꞌadeje. Röhu hesi ijoraje 12-ho jabuꞌo ");
INSERT INTO aom_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","magonaho ömoꞌömohuꞌo ëhi Iesuꞌo gemu mae vaꞌareje. Ëmagonahoho ioroꞌioroho urimo aruꞌaho sisëhu dëre abuejëvoꞌi ioroꞌioroho guomo guomo baejëvadoho Iesuro ajëmijamu marëjëvadeje. Ëmagonaho jabesi ihoho göho Mary aehu uvaruoho Mary Magdalene jiadeje. Iesuro ë magonaho hesi dëre jioꞌamaje aruꞌaho sisë 7 rarovoꞌamadeje. ");
INSERT INTO aom_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","O magonaho gö hesi ihoho Joanna jiadeje. Joanna hu Chuza-are vabore jiadeje. Chuza hu a böröme Herod-are bövi biseꞌo muebejahaje ae jiadeje. Röhu magonaho gö hesi ihoho Susanna jiadeje. Ëmagonaho ömoꞌömohuꞌo magonaho ioroꞌiorohuꞌo ahoꞌobëhe jaburo jabesi bövi biseꞌo jëvadohuro ëhuro Iesumë rabe rabe bogo eni jëvajoho ajëmibe vaꞌonövareje. ");
INSERT INTO aom_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Ëhiꞌamu iae ae ahoꞌobëhe amo göre göre jioromo gagovamu saꞌaho rarovadeje. Rarovamu gagorovo Iesuro uhuꞌe majëhiromo uëvadeje: ");
INSERT INTO aom_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","Iae ae gemuëro hesi i uje ujuohoromo mure riremoꞌi vaꞌade höjo. Riremobe vaꞌamu ujo ioroꞌioroho örire rireromade höjo. Rireromamu gagorovo aëro taemotaemovamu ugëro ro i barëjare höjo. ");
INSERT INTO aom_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Ujo ioroꞌioroho munë uhunö jiëꞌe saꞌare rireromade höjo. Rireromonugoromo rijamu sahoriꞌamade höjo saꞌaho jovo rumoꞌëro jiëꞌëro. ");
INSERT INTO aom_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Ujo ioroꞌioroho bibëꞌe resu resuꞌe saꞌare rireromade höjo. Rireromëꞌëro ujo ma hesi gemuoro riromo babaꞌamade höjo. ");
INSERT INTO aom_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Ujo ioroꞌioroho saꞌa mare rireromade höjo. Rireromoromo riromo maho ahoꞌobëhe 100 100 ëhi raeꞌamade höjo. Uhuꞌe ëhi uënugoromo ma-darugoꞌo uëvadeje: Ae rahu ja God-are jö hejanue ae javëꞌoho bëhoho nahoromo birohonëjo. ");
INSERT INTO aom_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Ëhiꞌamu Iesuare ijorajo ömoꞌömohuro uhu jö hesi bëhoho heꞌi ua gavareje. ");
INSERT INTO aom_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Ua gavamu Iesuro uëvadeje: God-ro böröme namiromo ahoꞌobëhe muebejaje jöho urimoho subivëhade höjo. Ësubivëhade jöho huro hesi suvuore jemë bojëmijëꞌe höjo jemëremu heꞌirarijego. Ëhuꞌëro jemëro jö bëhoho heꞌi aꞌi a ioroꞌioro jabesi öriroho ma-uhu jöemu rovaje höjo ëhuro nunëremu gaꞌi bëhoho bogo avoho gaꞌi hiaꞌëremu heꞌi bëhoho bogo avoho heruomoröhego. ");
INSERT INTO aom_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Röhu ë uhu jö hesi bëhoho aviëhi höjo. I ujo hesi bëhoho God-are jöe höjo. ");
INSERT INTO aom_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Ujehu örire rireromamu ugehu i barëjare jö hesi bëhoho aehu God-are jö hejamu gavëꞌoho Satan-ro rueromo jöho baeniëhiromo roriꞌo buꞌöjaje höjo ëhuro jabumë bogo ma uehorovoromo maroho vaꞌoruomoröhego. ");
INSERT INTO aom_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","O i ujehu munë uhunö jiëꞌe saꞌare rireromoromo riromo sahoriꞌamade jö hesi bëhoho aëro God-are jöho heromo nimorohoromo jöho ejaharue höjo. Ejahoromo jöho ma-döëremu baejëꞌëro majae ma-bunemu mae uehorovoromo Satan-ro dinëmego evare vuonugarue höjo. ");
INSERT INTO aom_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Ujehu bibëꞌe resu resu gemuore rireromade jö hesi bëhoho aëro God-are jöho hejarue höjo. Heromo röhu jabesi muohuni nurunurumoromo monie bövie biseꞌe uehorovoromo ave saꞌa hesirohemu nimoronimorohoromo ëhi jiëꞌe muohemu uehorovaruohuro God-are jö jabesi dëre jiajoho taemego jabumë bogo rae avoharue höjo. ");
INSERT INTO aom_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Ujehu saꞌa mare rireromade hesi bëhoho aëro jabesi dë vövöbajoꞌoho maëro jiëꞌëro God-are jöho heromo ejahoromo maꞌeno titimoromo biririvobe vaꞌo ijonö rae avohoruomaje höjo. ");
INSERT INTO aom_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Röhu iro bunoꞌiraejëꞌiroho bogo hevö gagoroho o maratu ahariroho gurihiꞌi ma-vaꞌorahoro bamoꞌanuëjo ae osare rovëꞌoho ajivëvoröhego. ");
INSERT INTO aom_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Nasi jö bëhoho rabe rabe gurihiro jiajoho ahoꞌobëhe ma-vaꞌorahoro jioꞌaꞌajëjo. O rabe rabe subivëhajoho ahoꞌobëhe ma-samaro jioꞌaꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Ëhuni naehu jövaje jöho avoꞌavoho herëjo. Ajiꞌe jö javëꞌoho God-ro göꞌo bojamiꞌiramu baeꞌaꞌanuëjo. O bogojavëꞌoho ma-döëremu baejanoho God-ro ë uehoroho muꞌuvahoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Ëhi uëvamu iae Iesuare vëmohuꞌo ö ömoꞌömohuꞌo jaburo rovareje. Rueromo gavareje ae ahoꞌobëhe tagavoromo öroho rarovëꞌëro hu jiajiroho bogo rue varijënoho jëvamu. ");
INSERT INTO aom_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Bogo rue varijënoho jëvamu gagorovo aëro Iesu uavareje: Jasi vëmohuꞌo ö ömoꞌömohuꞌo ja gaꞌi nimoromo amonö riravaruëjo. ");
INSERT INTO aom_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Riravaruëjamu Iesuro ë aribövioho uhuꞌe uëvadeje: Iae hejajëjo. Röhu ae magonahe rahu God-are jö heromo ejahëꞌoho ëhuro ë aribövioho nasi vëme ö ömoꞌöme jioruomajëjo. ");
INSERT INTO aom_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Ëhi ëꞌëꞌëro iae Iesuro hesi ijorajoho jabuꞌo gemu mae boat-re ajio hijadeje. Hiromo uëvadeje: Ruehego no eꞌu ioni gönö vaꞌarëjo. Vaꞌarëromo riꞌöromo vaꞌareje. ");
INSERT INTO aom_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Riꞌöromo vaꞌaroho vaꞌoromo Iesuro niavadeje. Niavamu gavëꞌi buru börömëro eꞌure rovadeje. Bure rovamu jovëro hasaromo boat gagore abueromo irijiomoromo diruvëvoꞌiëꞌadeje. ");
INSERT INTO aom_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Diruvëvoꞌiaꞌamu gavëꞌi Iesuare ijorajoho jaburo vaꞌo Iesu ioromo uavareje: Asëꞌe Tisa vuovavuoꞌiëꞌajëjo. Vuovavuoꞌiëꞌajëjamu riꞌöromo burohuꞌo hasajaje jovohuꞌo uëvadeje: Vuonugohëjo. Vuonugohëjamu buru rovadoho barëꞌi jovoho uꞌuhadeje. ");
INSERT INTO aom_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Uꞌuhamu gagorovo Iesuro hesi aribövioho uëvadeje: Jemë rabëni bogo ma uehorovevarujëjo. Ëhiꞌamu rueho jaburo tiöromo juhuonivoromo uarovareje: Ave aho diehi jiëꞌe ae höjo. Huhu uëvëꞌoho bogo aëremuoho ejahoꞌi burohuꞌo jovohuꞌo jabuꞌo hesi jöho ejaharue höjo. ");
INSERT INTO aom_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Ëhiꞌamu Iesumëro eꞌu döre vaꞌadoho vaꞌo Gergesa saꞌare vaꞌo baboro bejareje. Galilee saꞌaho nume eꞌu ioni gönö jioꞌi Gergesa saꞌaho ruhe ioni gönö jiadeje. ");
INSERT INTO aom_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Gergesa saꞌare vaꞌo baboro bejamu gagorovo amo raje ae gemuëro rueromo Iesu birohadeje. Ëaho aruꞌaho sisë ahoꞌobëhëro dëre abueꞌamamu simane huotorovëꞌe jiadeje. Niögu rumoꞌe ma-dëꞌahobatëremu majae ëgobövie hibe rovëꞌe jiadeje. Osaroho bogo hiꞌi guavoꞌamarue munë gagoremu hinövadeje. ");
INSERT INTO aom_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Hijëꞌëro rueromo Iesu garomo jöꞌe dadovoromo Iesuare höru bëhire ague aho hiromo ma-darugoꞌo uvadeje: Iesu ja God dö mare hijaje a hesi Harihe javajëjo. Ja rabëni sihusihuegoꞌi rovane höjo. Vuonugevëjo. Nadi huë sisëho viꞌehoho bojemëjo. ");
INSERT INTO aom_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Viꞌehoho nadi bojemijë uvade hesi bëhoho urimëꞌi aruꞌaho sisëhuro höröjöro Iesuro uavëꞌego ëhuni uvadeje. Röhu urimoho ë aruꞌaho sisëhuro hu baenövadeje. Baeꞌego aëro hu avoho mueberomo hesi övoho höroho tövahoꞌamonövareje. Tövahoꞌamoꞌego öꞌoho tarivo ruruhöꞌöromo aruꞌaho sisëhuro hesi uhure jiëꞌëro uaꞌego a rumoꞌe saꞌare vaꞌonövadeje. ");
INSERT INTO aom_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Ëhi ëꞌonövëꞌëro Iesuro uavadeje: Jasi ihoho rahuo höjo. Rahuo höjamu uavadeje: Nasi ihoho Siriehu Bimuvanovëꞌoho jevajëjo. Huhu ëhi uavade hesi bëhoho a sisë ahoꞌobëhe siri vaꞌëne hesi dëre abueꞌamëꞌëro jiëꞌëro ëhi uavadeje. ");
INSERT INTO aom_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Ëhiꞌamu ë dë uhure sisë ariböviohuro Iesu ëninamiromo uaruomadeje: Nadi uönego no sisëroho revoꞌirarëjo. ");
INSERT INTO aom_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Röhu mahe ahoꞌobëhe aruhëre dahoru ahore gemuoro ie ueꞌahamu gagorovo dëre sisë ariböviohuro Iesu uaruomadeje: Uövuego no suorovo vaꞌoromo aruhe mahu jabesi dëre vaꞌo abuejarëjo. Abuejarëjamu uëvadeje: Ëhuro vaꞌohëjo. ");
INSERT INTO aom_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Ëhuro vaꞌohë uëvamu hejëꞌi rue sisë ariböviohuro ë a hesi dëre jioromo suorovo vaꞌoromo ruhe mahu jabesi dëre abueruomadeje. Abueruomamu ë mahohuro vaꞌo baradore rireromoromo eꞌure siö ruruhöꞌö vaꞌoromo jove ueꞌahoromo vuovadeje. ");
INSERT INTO aom_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Vuovamu gavëꞌi mahu muebeꞌamarue ariböviohuro huruomoromo amo börömore amo ininore jöho majëhibe vaꞌareje. ");
INSERT INTO aom_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Jöho majëhijamu hejëꞌi ae ahoꞌobëhe rueruomadeje gaꞌiro diehi jiego. Iesuaro rueromo gavareje aruꞌaho sisëhu dëre jioromo suorovo vaꞌoruomade aho simanoho mae jioꞌego niöge baꞌamëꞌe Iesuare höru bëhire hijamu. Ëhi gagorovo juhuonivoruomadeje. ");
INSERT INTO aom_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Juhuonivamu Iesuhu mu vaejamu gavare ariböviohuro uëvareje: Sisë ariböviehu dëre abueꞌamade aho Iesuro ëhi ajamiꞌego marëhijajo. ");
INSERT INTO aom_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Marëhijajamu Gergesa saꞌa rajoho jaburo heromo sisë maro juhuonivëꞌëro Iesu uavareje: Nosi saꞌaho vuonugoꞌi vaꞌëjo. Vuonugoꞌi vaꞌëjamu Iesuro boat-re ajiomoromo sionëro vuonoröꞌö vaꞌiëꞌadeje. ");
INSERT INTO aom_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Vaꞌiaꞌamu aruꞌaho sisëhu dëre jioromo suorovo vaꞌoruomade ahuro Iesu uavadeje: Na öꞌo jaꞌo hiꞌi negajëjo. Negajëjamu Iesuro nijioꞌiraeromo sionëro nugöꞌöromo ");
INSERT INTO aom_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","uavadeje: Bogo rueꞌaꞌanuëjo. Sionëro jasi amoro vaꞌoromo uënëjo: God-ro ëhi mabëhe ajemijamu rovode höjo. Ëhi uavamu rue ahuro vaꞌoromo amo börömoho jöe majëhibe juvo barëjadeje. Majëhiromo uëvadeje: Iesuro ëhi mabëhe ajemijamu rovode höjo. ");
INSERT INTO aom_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Ëhiꞌamu Iesuro boat-re vuonoröꞌö rueromo ve eꞌu ioni gönö rovadeje. Rovamu ae ahoꞌobëhe hu muebejëꞌëro gavare rovamu gagorovo nimorohoromo rajahiruomadeje. ");
INSERT INTO aom_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","42","Rajahiruomamu iae ae gemu hesi ihe Jairus-ro rovadeje. Jairus hu God rajahijarue osa muebejaje ae jiadeje. Röhu hu aboje ihevae gemu jiadeje. Abojoho vadune ahoꞌobëhe 12 rabuꞌe jiadeje. Amo guomoꞌiëꞌadeje. Guomoꞌiaꞌamu gagorovo Jairus-ro rueromo Iesuare höru bëhire ague aho hiromo dinamiromo uavadeje: Nasi osaro rueromo nasi abojoho ajamëjo. Ajamijëjamu hegorovo Iesuro huꞌo vaꞌadeje. Vaꞌamu ae ahoꞌobëhe huꞌo gemuore ëhi tatijiomobe vaꞌareje. ");
INSERT INTO aom_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Tatijiomobe vaꞌamu gagorovo iae magonahe gemuëro jabuꞌo vaꞌadeje. Ëmagonahoho manaero garorovade guomo guomoho bogo barëꞌi ëhi jiemu jiobe vaꞌadoho vadune ahoꞌo 12 barëjëꞌe jiadeje. Hesi ijo baje doctor jabesi örire buꞌö barëjadeje. Röhu ajamiꞌiröhoho bogo eni jëvëꞌëro ëhi jiemu jiadeje. ");
INSERT INTO aom_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Ëhi jiemu jiëꞌëro ë magonahohuro Iesuare dejonö rovadeje. Rueromo niögu vituoho rëhamu gavëꞌi kö rovadoho ijoho bogo rovadeje. ");
INSERT INTO aom_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Ijoho bogo rovamu Iesuro ae uëvadeje: Ja rahuaro rëhevane höjo. Rëhevane höjamu hegorovo ae ahoꞌobëhe uavareje: No bogo rëhavëꞌe javuajëjo. Rëhavëꞌe javuajëromo Peter-ro uavadeje: Tisa ja rabëni ëhioho uövuanuëjo. Ae ahoꞌobëhe jasi bëhire jijihoromo tatijiomavaruëjo. ");
INSERT INTO aom_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Tatijiomavaruëjamu uëvadeje: Iae aëro rëhevade höjo. Na hejajoho nasi darugoho ae ajëmiꞌi gö vaꞌëꞌe jiavajëjo. ");
INSERT INTO aom_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Vaꞌëꞌe jiavajëjamu ë magonahohuro garomo uvadeje: Naehu Iesu niögure rëhodoho bogo subivo varijënoho jevajë uvoromo juhuonivadeje. Juhuonivoromo butubutumobe rueromo Iesuare höru bëhire ague aho hijadeje. Ague aho hiromo ae ahoꞌobëhe jabesi nunire Iesu uavadeje: Na ëhi marëjevojöro negamu ëhuni rëhavode höjo. Rëhavamu ëhuro ma-burëro marëjevade höjo. ");
INSERT INTO aom_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Ëhi uavamu hegorovo Iesuro uavadeje: Abojëjo. Jero na mae uehorovevamu ëhuro marëjavëꞌe höjo. Vaevëꞌe vaꞌonëjo. ");
INSERT INTO aom_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Iesuro ëhi uavamu gavëꞌi ae göëro Jairus-are osare jioromo rueromo uavadeje: Jasi abojoho mamiꞌe guomëꞌe höjo. Ëhuni minoꞌe tisaho uꞌuoho bojamëjo. ");
INSERT INTO aom_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Minoꞌe uꞌuoho bojamëjamu Iesuro muꞌöjahiromo Jairus uavadeje: Nadi juhuonivoꞌi mae uehorovonëjo. Ëhi jiëꞌohuro jasi abojoho iꞌovoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Iꞌovoꞌajë uanugoromo Iesuro Jairus-are osare vaꞌoromo Peter John James magonaho harihu hesi vëmu vavuꞌoho ëho jaburo huꞌo vaꞌojöro uëꞌi a ioroꞌioroho nijioꞌiraejëvadeje. ");
INSERT INTO aom_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Nijioꞌiraejëvonugoromo osare vaꞌoromo gavade ae ahoꞌobëhe magonaho hesi jöëni nierusuburuꞌe bamoromo jabesi muoꞌamorovamu gëgorovo Iesuro uëvadeje: Nadi nierusuburuꞌe bamohëjo. Ëmagonaho harihoho bogo guomoꞌi ma-niavajëjo. ");
INSERT INTO aom_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Ma-niavajëjamu hegorovo rueho jaburo garomo uvareje: Magonahoho iae mae guomëꞌe höromo Iesu sivoromo ijoꞌijahareje. ");
INSERT INTO aom_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Ijoꞌijahamu Iesuro vaꞌoromo magonaho hesi övore maꞌenoromo ma-darugoꞌo uvadeje: Bësu riꞌöjëjo. ");
INSERT INTO aom_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Riꞌöjëjamu magonaho hesi aruꞌahohuro vuonoröꞌö rovamu hejëꞌi ma-burëro riꞌöjadeje. Riꞌöjamu gagorovo Iesuro uëvadeje: Ie bojamego ijajo. ");
INSERT INTO aom_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Ëhiꞌamu vëmu vavuꞌoho tiöjëvadeje. Tiöjëvamu Iesuro uëvadeje: Naehu vaejode muoho nadi aho uërëjo. ");
INSERT INTO aom_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Iae Iesuro hesi ijoraje 12-ho uëvadeje: Ro gemuoro gagovohëjo. Gagovohëromo rovamu uëvadeje: Jemëhu mu vaeꞌirarijohuni nasi darugoho bojëmijajëjo ëhuro jemëro Satan-are a sisë a dëre jioꞌamëꞌoho rarovöꞌöꞌamoromo guomo guomoꞌe aribövioho ajëminövoꞌirarijego. ");
INSERT INTO aom_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Ëjöho darugoho bojëmijëꞌe jevaje ëhuni vaꞌoromo God-hu böröme namiromo muebejëvaje jöho majëhibe guomo guomoꞌe aribövioho ajëmibe jijihorëjo. ");
INSERT INTO aom_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Ëhi uëromo uëvadeje: Vaꞌiëꞌiroho bövioho biseꞌoho nadi ujuohorëjo. Haꞌitoho esöho irunoꞌoho ijo bajoho nadi ujuohorëjo. Niögoho nadi göho ujuohoꞌi ma-gemu ruohoromo jijihorëjo. ");
INSERT INTO aom_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Amo göre göre vaꞌoromo aehu di osare raromojöro uëvamu vaꞌo raromëꞌoho ëhuremu raromoromo vaꞌonövorëjo. ");
INSERT INTO aom_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","O di amore ariböviehu jemesi örire nu huodëgëꞌoho amoho nugo vaꞌirögoro jabesi saꞌa hesi tohotohe jemesi höru hitahire jiajoho saꞌaro riremo vaꞌego ë amo rajohuro garomo uvoꞌirarëjo: No sisë ëꞌëꞌe javuajëjo. ");
INSERT INTO aom_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Ëhi majëhijamu hegorovo Iesuare ijorajoho jaburo riꞌöromo vaꞌareje. Vaꞌoromo jö maho majëhibe guomo guomoꞌe aribövi jabesi sinoho ajëmibe ame ahoꞌo jijihareje. ");
INSERT INTO aom_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Iae Galilee saꞌare a böröme Herod-ro hejade uvoruomamu: Iesumëro ëhi jiëꞌe mu masije vaeꞌamëꞌe hö uvavamu hegorovo Iesuare jöho uehorovoromo uvadeje: Diehiꞌoromo ëꞌajëjo. Ëhesi bëhoho hu hejadeje a ioroꞌiorohuro uvoruomamu: Iesu hu John bapataeto vaenövade ahuro guomoromo riꞌöjëꞌe höjo. Ëhuꞌëro ëhi jiëꞌe muoho vaeꞌamaje höjo. ");
INSERT INTO aom_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","O a ioroꞌiorohuro uvoruomamu: Iesu hu mamiꞌe hijade ae Elijah-ro rovëꞌëro ëꞌajëjo. O a ioroꞌiorohuro uvoruomamu: Mami göꞌe jö God-aro baeromo majëhinövare aribövioho röhu gemuëro iꞌovoromo riꞌöjëꞌëro ëꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Ae göëro göëro jöe gö gö ëhi atavamu hegoro Herod-ro dadivamu uvadeje: Nani ë aho bogo John-hu höjo. Mamiꞌe na John-are sönöho tariojahode höjo. Röhu ë mu masijo vaeꞌego aehu garomo atoꞌego na hejajoho ë iaho rahuo höjo. Ëhi uvoromo Iesu gaꞌi nimadeje. ");
INSERT INTO aom_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Ëhiꞌamu apostle ömoꞌömohuro vuonoröꞌö rueromo Iesu uavareje: No ëhi ëhi ëꞌoromo rovare höjo. Rovare höjamu Iesuro söjëvoromo Bethsaida amore jabesi sivue raromoꞌi vaꞌareje. ");
INSERT INTO aom_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Bethsaida jabesi sivue raromoꞌi vaꞌi vaꞌamu ae ahoꞌobëhe ë jöho heromo rueruomadeje. Rueromo birohoruomamu gëgorovo Iesuro uëvadeje: Iae mae rovëꞌe jëvajë uënugoromo God-hu böröme namiromo muebejavuaje jöho majëhiromo guomo guomoꞌe aribövioho ajëmijadeje. ");
INSERT INTO aom_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Ëhiꞌojuvo majae garoboꞌe bamamugo hesi ijoraje 12-ho jaburo rueromo uavareje: Aveho a rumoꞌe saꞌae höjo. Ëhuni ave aribövioho rëmöꞌöjego ave bëhire amo masijore amo ininore vaꞌoromo ie nahoromo ueꞌahoromo momoröꞌöꞌirarëjo. ");
INSERT INTO aom_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Momoröꞌöꞌirarëjamu uëvadeje: Bogajo. Jemëro irunoꞌoho daꞌuojëhirëjo. Daꞌuojëhirëjamu uavareje: Iae mae höjo röhu no ie övo gö mine visue niöꞌi ëhemu javuoꞌi gö bogojavuajëjo. O na ja uöromo ëꞌanuëjo noro vaꞌoromo ave ariböviohuni ie imoꞌamojöro. Ae ahoꞌobëhe jiëꞌëro no bogo eni javuajëjo. ");
INSERT INTO aom_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Ëhi uavare hesi bëhoho amaꞌe ahoꞌobëhe 5,000 rabuꞌe ë raromëꞌego ëhuni uavareje. Ëhi uavamu Iesuro hesi ijorajo ömoꞌömoho uëvadeje: Uëvego 50 50 rabuꞌe hahagu hahagu gagovoromo ëhi raromobe vaꞌarëjo. ");
INSERT INTO aom_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Raromobe vaꞌarëjamu rue ijorajoho jaburo uëvamu ae ahoꞌobëhe ëhi raromobe vaꞌoruomadeje. ");
INSERT INTO aom_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Ëhi raromobe vaꞌamu gagorovo ie övo gö mine visue niöꞌi ujuoho rovaroho ëho Iesuro ujuohoromo öꞌidöho sioroho garomo God huë mae uavadeje. Huë mae uanugoromo ioho atoꞌatovoromo hesi ijorajo ömoꞌömoho iꞌimëmijamu suvuorëmijareje. ");
INSERT INTO aom_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Suvuorëmijamu ae ahoꞌobëhe ueꞌahamu daꞌuëgadeje. Daꞌuëgamu gagorovo ijorajoho jaburo vitu vituoho gagovoromo esöe ahoꞌobëhe 12 aegoꞌamareje. ");
INSERT INTO aom_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Ëhiꞌamu Iesuro huro hesi sivue parie vaejamu evare hesi ijorajoho jaburo huꞌo raromareje. Raromamu gagorovo uëvadeje: Na rahuo jevaje jöho ae ahoꞌobëhe diehi atoruomaje höjo. ");
INSERT INTO aom_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Diehi atoruomaje höjamu uavareje: A ioroꞌiorohuro uvoruomaje höjo: Ja John bapataeto vaejavuonövane ahuro rovëꞌe javajëjo. A ioroꞌiorohuro uvoruomaje höjo: Ja Elijah-ro rovëꞌe javajëjo. A ioroꞌiorohuro uvoruomaje höjo: Mami göꞌe jö God-aro baeromo majëhinövarije aribövioho röhu jero gemuëro iꞌovoromo rovëꞌe javajëjo. ");
INSERT INTO aom_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Ëhi uavamu Iesuro uëvadeje: Röhu jemë nasi jöho diehi ataruje höjo. Diehi ataruje höjamu Peter-ro riꞌöromo uavadeje: Ja God-hu uavëꞌëro böröme namiromo ajamuijanue aho javajëjo. ");
INSERT INTO aom_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Javajëjamu Iesuro jöho darugoꞌo majëhiromo uëvadeje: Ëjöho nadi aho huruoho majëhirëjo. ");
INSERT INTO aom_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Ëhi uënugoromo uëvadeje: God-ro ëhi bamëꞌëro ëhuꞌëro hesi A Maho naro viꞌehe huë vavaene bövie biseꞌe baeꞌejöjo. Jew rajo a duvaho ömoꞌömoho priest masijoho Jew rajo jögoru öri röjëhijarue aribövioho ëho jaburo na bijönegoruomoꞌajëjo. Bijönegoruomoꞌiramu aëro anegoꞌiramu guomevoꞌajëjo. Guomoromo majae niöꞌi gemu hesi uhure iꞌovoromo riꞌöꞌejöjo. ");
INSERT INTO aom_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Iesuro hesi ijorajoho ëhi majëhinugoromo ae ahoꞌobëhe uëvadeje: Ae rahuaro nasi ijore ijore juvoꞌi nimëꞌoho jasi sinehu nimajoho nadi uehorovoꞌi vae majae uvonëjo: Iesuare jöëni viꞌehe huë vavaene javoje rabe baeromo guomevëꞌoho iae hesi hö uvoromo korosi hesi iꞌuoho banigojiomanovoromo nasi ijoro ijoro juvonövonëjo. ");
INSERT INTO aom_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Ja jasi sinohuni uehorovoromo biririvoromo ave saꞌare hiꞌi ëhemu uehorovëꞌoho ijonöho guomo öriro vaꞌaꞌanuëjo. O ja nasi jöëni guomëꞌoho ijonöho maro hiꞌaꞌanuëjo. ");
INSERT INTO aom_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Jaehu are jove saꞌae mae sisë ahoꞌobëhe bae barëꞌi röhu arijoꞌarije ijumorovëꞌoho o sisërërovëꞌoho na ja ëhuro mae javoꞌajëjo. Bogajo. ");
INSERT INTO aom_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Ëhesi bëhoho ae rahu nasi jöëni o naehu majëhijaje jö hesi jöhuni javojëgëꞌoho uꞌemu God-are A Maho naro nasi ajohuꞌo nasi Vavu hesi ajohuꞌo anera maemu jiëꞌe jabesi ajohuꞌo rueꞌiramu evare nani javojimoruomade ariböviohuni javojegoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Röhu ave jöho na jö mae uëꞌiëꞌajëjo. Jemë a ioroꞌiore ave riravarujoho bogo vuovëꞌe raromoromo God-hu böröme namiromo muebejaje ajoho gaꞌaꞌarujëjo. ");
INSERT INTO aom_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Ëhi uënugoromo hurae gemu barëjamu Iesuro Peter John James ëhi söromo God-are örire jöe jövoꞌi dahorure ajiomadeje. ");
INSERT INTO aom_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Ajiomoromo God-are örire jöe jövamu Iesuare nu anoꞌoho gorosovoromo ma-mabëhe jioꞌi hesi niögoho majaehu bamajëhi ëhi ajivo avohadeje. ");
INSERT INTO aom_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","31","Ajivo avohamu gavëꞌi iae urimëꞌi arinövare ae niöꞌi Mosesꞌo Elijahꞌo ma-majioho aji mare rirarovoromo jabuꞌo Iesuꞌo jöe atareje. Atoromo God-hu nimaje mu Iesuhu vaeromo Jerusalem guomoröhe jöho atareje. ");
INSERT INTO aom_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Atoruomamu Peter-mëro nunëhëgamu momoröꞌö uroꞌamareje. Momoröꞌö uroꞌamëꞌëro riꞌöꞌi gavareje Iesu ajiꞌere namiꞌego ë ae niöꞌioho jabuꞌo ë rirarovamu. ");
INSERT INTO aom_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Rirarovoromo Mosesꞌo Elijahꞌo Iesu nugo vaꞌiaꞌamu gavëꞌi Peter-ro Iesu uavadeje: Tisa no ave raromaruoho iae mae höjo. Uövuego no javu harihe niöꞌi gemu vaeꞌamarëjo jani gemu Moses-ni gemu Elijah-ni gemu. Peter-ro bëhoho bogo avoho uehorovëꞌe ë jöho ëma jövadeje. ");
INSERT INTO aom_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Jövamu gavëꞌi suëro rueromo aegëhadeje. Aegëhamu Peter-mëro gavare Iesu Moses Elijah suëro numëvamu gagorovo juhuonivareje. ");
INSERT INTO aom_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Juhuonivëꞌi hejareje sue uhure uvavamu: Ave aho nasi Harihe naehu baejode aho höjo. Huhu jövaje jöho avoho herëjo. ");
INSERT INTO aom_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Ëhi uvavamu hejëꞌi gavareje Iesu hesi sivue namijamu. Ëhi gavëꞌëro Peter-mëro rabe rabe gavaroho subivëhoromo aho bogo majëhijareje uꞌemu majëhiꞌiröhëro. ");
INSERT INTO aom_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Ëhi ëꞌëꞌëro sisonuvamu gagorovo Iesu o hesi ae niöꞌi gemu dahorure abuejareje. Abuejamu gavëꞌi ae ahoꞌobëhe rueromo Iesu birohoruomadeje. ");
INSERT INTO aom_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Ae ahoꞌobëhe ro birohoromo röhu ae gemuëro ma-darugoꞌo uvadeje: Tisa huë baejevoromo nasi harihoho ro gavëjo. Na aboji harihuꞌe bogojevoꞌi avehuremu gemu jevajëjo. ");
INSERT INTO aom_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Röhu Satan-are a sisëro hesi dëre abueromo ijumahego aharihoho simane sisërëromo ma-majioho jöꞌe dadovoromo bijöbijövoromo övoꞌo höruꞌo ajiomoromo jöꞌonö obohu tatogoꞌe rovaje höjo. Obohu tatogoꞌe rovego a sisëhuro bogo burëroho hörö vaꞌi sino hahoꞌoho ijumahojuvo uꞌuhego evare höröromo vaꞌaje höjo. ");
INSERT INTO aom_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Ëhi ëꞌi hijëꞌego naro jasi ijorajo ömoꞌömoho uëvode höjo: Aruꞌaho sisëho rarovöꞌöhego vaꞌajo. Ëhi uëvamu rarovöꞌöꞌi ëꞌo gavaroho bogo eni jëvade höjo. ");
INSERT INTO aom_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Bogo eni jëvade höjamu Iesuro uëvadeje: Asëꞌe ave jaruvore raromaruje aribövioho jemë bogo ma uehorovoꞌi jöe gö gö ëma uehorovaruje aribövie jëvajëjo. Na majae diminoꞌe jemëꞌoho hiromo jemesi mu sisëho garomo ma-nunëro ga taemobe vaꞌejöjo. Jemesi uehoro sisëhuro na uꞌuvevajëjo. Jasi harihoho avehuro barovego na gavöjo. ");
INSERT INTO aom_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Gavöjamu ë harihoho rovamu gavëꞌi Satan-are a sisë dëre hijadohuro dë vövöbajoꞌoho ijumahamu simane sisërëromo saꞌare darugoꞌo behumorovoromo bijöbijövoromo övoꞌo höruꞌo ajiomadeje. Övoꞌo höruꞌo ajiomamu gagorovo Iesuro aruꞌaho sisëho rarovöꞌöjamu marëjadeje. Marëjamu Iesuro aharihoho baeromo vavuoho sionëro bojamijadeje. ");
INSERT INTO aom_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Bojamamu ae ahoꞌobëhe God-are darugo börömoho garomo jöe barëjëvadeje. Ae ahoꞌobëhe Iesuare mu masijoho ahoꞌo uehorovoromo jöe barëjëvamu gavëꞌi Iesuro hesi ijorajo ömoꞌömoho majëhiromo uëvadeje: ");
INSERT INTO aom_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","Ave jöhuremu avoho hehëjo. God-ro ëhi bamëꞌëro hesi A Maho na a jabesi övore vaꞌiramu baejevoruomoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Ëhi uëvamu hejareje röhu jö bëhoho dadivëvadeje. Subivëhëꞌëro bëhoho bogo gavareje. O ua gaꞌiröhoho juhuonivareje. ");
INSERT INTO aom_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Ëhiꞌonugoromo ë ijorajoho jaburo jö ahoꞌahamirovoromo uarovareje: Iesuare ijorajo ömoꞌömoho di aho börömoho javuajëjo. ");
INSERT INTO aom_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Börömoho javuajëjamu Iesuro jabesi uehoroho garomo aharihe gemu baro hesi bëhire nugamu namijadeje. ");
INSERT INTO aom_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Namijamu hesi ijorajo ömoꞌömoho uëvadeje: Ae rahu aviëhi jiëꞌe aharihoho nasi ihore rajahiromo baejëꞌoho ëhuro naꞌo rajehiromo baejevoruomaje höjo. O ae rahu na rajehiromo baejevëꞌoho ëhuro remöꞌöjamu rovode ahuꞌo rajahiruomaje höjo. Ëhesi bëhoho jemesirire di aho biseꞌo jiajoho God-hu gavajoho ëhi jiëꞌe aho börömoho höjo. ");
INSERT INTO aom_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Ëhi uëvamu John-ro riꞌöromo uavadeje: Tisa no gavare höjo ae gemuëro jasi ihoho uvoromo aruꞌaho sisë a jabesi dëroho rarovöꞌöjëvamu. Rarovöꞌöjëvamu garomo röhu gavare hu bogo noꞌo juvaje aho jiamu gagorovo uavare höjo: Vuonugëjo. ");
INSERT INTO aom_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Vuonugëjamu Iesuro uavadeje: Nadi ëhi jiëꞌoho ëꞌorëjo. Ae rahu jemesi örire bogo bijönimëꞌoho ë aribövioho jemesi aemoꞌaeme jioruomajëjo. ");
INSERT INTO aom_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","God-hu Iesu uavego öꞌidöre ajiomoꞌiröhe majaho dunovamu gagorovo Iesuro uehore gemu baeromo uvadeje: Iae na Jerusalem ajiomoꞌiëꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Ëhi uvoromo ae rëmöꞌöromo uëvadeje: Jemëro urimo vaꞌirarijoho Samaria saꞌare amo göhuro vaꞌoromo amo rajoho uënëjo: Nörö öꞌaꞌajëjo. Öꞌaꞌajëjamu hegoro rueho jaburo vaꞌoromo amore suorovareje bövie biseꞌe Iesuni avohahoröhëro. ");
INSERT INTO aom_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Suorovamu ë amore ariböviohuro uvoruomadeje: Jerusalem amoho sisë jiëꞌe Iesuro ë amore vaꞌi rovajëromo ëhuni Iesuhu jabesi amore hiꞌiröhoho ahoruomadeje. ");
INSERT INTO aom_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Ahoruomamu gagorovo Iesuare ijoraje Jamesꞌo Johnꞌo jaburo Iesu uavareje: Tisajo. Na ja nagajëjo noro uavego vënëro öꞌidöre jioromo ruvebiromo ë amo rajoho ravëvojöro. ");
INSERT INTO aom_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Ëhi uavamu hegorovo Iesuro huotorovoromo Jamesꞌo Johnꞌo uëvadeje: Bogave ëhioho uvoꞌirarijëjo. ");
INSERT INTO aom_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Ëhi uënugoromo ame göro vaꞌareje. ");
INSERT INTO aom_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Örire vaꞌoruomoromo ae gemuëro Iesu uavadeje: Ja dinöꞌe dinöꞌe vaꞌëꞌiroho na jasi ijore ijore juvonövoꞌejöjo. ");
INSERT INTO aom_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Juvonövoꞌejöjamu Iesuro uavadeje: Jero nasi ijore ijore juvoꞌi uevanuëjo röhu jeꞌo majehu saꞌa gagore röho avohoromo mare raromaruoho iae jiajëjo. Jeꞌo ugehu iju vaeromo mare raromaruoho iae jiajëjo. Aꞌi God-are A Ma naehu niavaje hijaje osaho bogojevajëjo. Nadi uvonëjo: Nöröꞌo hibe juvëꞌoho mae hibe juvoꞌejöromo nasiriroho ruenëjo. ");
INSERT INTO aom_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Ëhi ëꞌëꞌëro Iesuro ae gö uavadeje: Rueromo nasi ijoro ijoro juvëjo. Juvëjamu ruehuro uavadeje: Iae mae höjo röhu uevego na nimo vuonoröꞌö vaꞌoromo nasi vavuoho guavoromo hujeji evare jasi ijore ijoroho juvoꞌiröjo. ");
INSERT INTO aom_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Juvoꞌiröjamu Iesuro uavadeje: O-ajo. Vuonugego vuovo örire jijiharue ariböviohuro jabesi aribövioho guavoꞌamoꞌirarëjo. Aꞌi jero vaꞌoromo God-hu böröme namiromo muebejëvaje jöho majëhibe juvonövonëjo. ");
INSERT INTO aom_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Ëhi uavamu ae göëro Iesu uavadeje: Bada iae na jasi ijore ijore juvonövoꞌejöjo. Röhu uevego na urimo vaꞌoromo nasi aganoho jejëmiromo rueromo evare jasi ijore ijoroho juvoꞌiröjo. ");
INSERT INTO aom_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Juvoꞌiröjamu Iesuro uhuꞌe uavadeje: Röhu aehu aevoromo mu ravoromo vuonoröꞌö uherihobe ravobe vaꞌëꞌoho hu muoho bogo avoꞌavoho ravaje höjo. Ëhesi bëhoho ja uehoro niöꞌi baejëꞌoho ëhuro God-are ajiꞌe öri ariꞌo hesi mu vaeꞌiranoho bogo eni javoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Ëhi ëꞌëꞌëro Badaro ae gö ahoꞌobëhe 72 baejëvoromo rëmöꞌöromo uëvadeje: Naehu juvoꞌirode ë amoro amoro ëhuro jemëro ae niöꞌi niöꞌi urimo vaꞌorëjo. ");
INSERT INTO aom_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Ëhi uënugoromo uhuꞌe uëvadeje: Ae ahoꞌobëhe nasinö sö rueꞌiröhoho ëho mure irunoꞌe gagovoꞌiröhoho vaꞌëne höjo. Mure gagovoꞌiröhe irunoꞌoho bövi mae jioꞌi gagovarue aribövioho no ma-gemu gemu javuajëjo. Ëhuni mu Arijoꞌoho ëninamiromo uarego huro ae göꞌo rëmöꞌöjego mure rueromo ajamuiromo irunoꞌoho gagovoꞌirarëjo. ");
INSERT INTO aom_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Jemëro vaꞌorëjo. Röhu gavëꞌiajo. Naro rëmöꞌöjego jemë vaevëꞌe sheep harihunöꞌe vöröꞌe miehu jioruomajire vaꞌiëꞌarujëjo. ");
INSERT INTO aom_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Monioho esöho höru sinoho nadi ujuoho vaꞌorëjo. Öriroho nadi ae gö gö jabesi öriroho jejëmibe vaꞌoromo örisanuoho ëꞌorëjo. ");
INSERT INTO aom_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Jemë ae gö jabesi osare vaꞌiëꞌiroho urimo jejëmiromo uënövorëjo: Ave osare aribövioho huë mae baerëjo. ");
INSERT INTO aom_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Huë mae baerëꞌiramu God-are huë ma baeꞌi nimaje aho ë osare hijëꞌoho iae huë mae baeꞌaꞌajëjo. O God-are huë ma baeröhoho bijönimoruomëꞌoho uërëjo: God-are huë ma jö uëvodoho vuonugajëjo. Ëhuꞌëro bogo baeꞌaꞌarujëjo. ");
INSERT INTO aom_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Nadi osa göroho göroho momoröꞌöbe vaꞌi ma-osae gemuoro raromoromo ie jove rabe iꞌimëmijëꞌoho ëho ueꞌahorëjo. Jemëhu jabesi irunoꞌo o jovo ueꞌahëꞌoho iae mae höjo rabëni jemë jabesi mue vaeꞌiëꞌëro. Ëhesi bëhoho ae rahu mu vaeromo mana baejëꞌoho iae mae höjo. ");
INSERT INTO aom_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Jemë di amore vaꞌo suorovamu jabuhu huë baejëvamu gavëꞌohuro ie rabe rabe iꞌimëmëꞌoho ëho ueꞌahorëjo. ");
INSERT INTO aom_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Guomo guomoꞌe aribövie ë amore raromëꞌoho ajëmirëjo. Amo rajoho jöe majëhiromo uërëjo: Avevejöꞌoho God-ro böröme namiromo jemë muebejëvoꞌiëꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","O jemë di amore vaꞌo suorovamu jabuhu jemë bijönëgëꞌoho amoho nugo vaꞌirögoro amoro jijihoromo jöe majëhiromo uërëjo: ");
INSERT INTO aom_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","Noro jemesi bövioho biseꞌoho riremiꞌöromo jemesi amore saꞌa hesi tohotohehu nosi hörure aegadoho no vaꞌi ëhuꞌo riremo vaꞌejarëjo ëhuro jemë garomo uvoꞌirarijego: No sisë aribövie javuajëjo. Röhu ave jöhuꞌo avoꞌavoho uehorovohëre. God-ro böröme namiromo aevoromo jemë mabëhe muebejëvoꞌiëꞌoromo vuonugëꞌe höre. Ame gö gö jemesi jö bijönimëꞌoho ëhi majëhinövorëjo. ");
INSERT INTO aom_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Naro jemë uëvajëjo: God-hu iꞌu bojëmiꞌiröhe maja rovëꞌiroho Sodom amo rajo jabuhu iꞌu baeröhoho ëho ma-jianovoꞌi aꞌi jemesi jö bogo eruomaje aribövioho jaburo iꞌu börömo maho baeruomoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Chorazinꞌo Bethsaidaꞌo amo rajohumë vaevëꞌoho sisëro revo hesi jëvajëjo. Naro darugoꞌe muoho jemesi amore vaejego garomo röhu nasi jöho bijönimaruje höjo. Naehu darugoꞌe mu jemesi amore vaejodoho Tyre amore o Sidon amore vaejego gaꞌibejarëjo mamiꞌe jabesi sisëni huë vavaene baeromo niögu sisë ioꞌamoromo uonëro buerovoromo raromoromo uehoro sisëho vuonugoꞌi uehoro mae baeruomoꞌibejajo. ");
INSERT INTO aom_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","God-hu iꞌu bojëmiꞌiröhe maja rovëꞌiroho Tyre o Sidon rajo jabuhu iꞌu baeröhoho ma-jianovoꞌi jemëro iꞌu börömo maho baeꞌaꞌarujëjo. ");
INSERT INTO aom_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Röhu Capernaum amo rajohumë jemëro jemesi sivue uehorovoromo uvaruje höjo: Nosi ihoho öꞌidöre ajiomoꞌajëjo. Bogo ëhioho jioꞌi saꞌaro beꞌaꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Röhu nasi ariböviohumë ae rahu jemesi jö ejëhëꞌoho nasi jöhuꞌo ejeharue höjo. O ae rahu jemë juahëmijëꞌoho naꞌo juahemijarue höjo. Ae rahu na juahemijëꞌoho remöꞌöjamu rovode ahuꞌo juahamijarue höjo. Hesi ae 72-ho ëhi uënugoromo rëmöꞌöjamu vaꞌareje. ");
INSERT INTO aom_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Vaꞌëꞌëro ë ae ahoꞌobëhe 72-ho jaburo nimorohëꞌi vuonoröꞌö rueromo Iesu uavareje: Bada mue ahoꞌobëhe mabëhe vaebe jijihëꞌëro rovaruëjo. No jasi ihore uëvamu Satan-are sisë ariböviohuro ejahuoromo suorovo vaꞌoruomade höjo. Ëhi jiëꞌe muoho ëhuꞌo gavëꞌe javuajëjo. ");
INSERT INTO aom_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Gavëꞌe javuajëjamu Iesuro uëvadeje: Satan-are ariböviehu jemë ejëhare hesi bëhoho naro gavode höjo Satan-are vöröe barëromo baderehu baderivajëhi Satan ëhi öꞌidöre jioromo berovamu. ");
INSERT INTO aom_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Iae nasi mu vaeꞌirarije darugoho bojëmijëꞌëro ëhuro jemëro vöröꞌe sigobohuꞌo nianiꞌöhuꞌo hörëro taemoꞌamoromo Satan-are vöröho ahoꞌobëhe ruahöꞌöꞌamoꞌarujëjo. Ëhi ëꞌiramu bövioho biseꞌoho jemë bogo ijumëvoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Iae ëhi höjo. Röhu Satan-are ariböviehu jemesi jö ejëharuoho ma-jianovëꞌe jiaje nadi uehorovoꞌi aꞌi jemesi ihe öꞌidöre jajivëꞌe jiajoho ëho uehorovoromo nimorohorëjo. ");
INSERT INTO aom_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Ëhi uëromo evare majare Iesuro God-are Aruꞌaho hesi huë maho baeromo nimoroho avohadeje. Nimorohoromo God uavadeje: Apo ja öꞌidörohuꞌo saꞌarohuꞌo muebejanue ae javajëjo. Naro jasi örire huë mae uavajëjo. Rabëni hesi bëhoho jero gavane nuni ajiꞌe a masijohuro uvoruomamu: Nosi simanoho mae javuoromo bövie biseꞌe ga barëjëꞌe javuajë uvamu gëgorovo jero jasi jöho jabesi örire subivëhëꞌe javajëjo. Aꞌi gavane bogo gavëꞌe ariböviohuro bogo döroho bamorovoꞌi jöho heꞌi nëgamu gëgorovo jero jasi jö bëhoho röjëhijëꞌe javajëjo. Apo iae mae höjo. Jero jasi nimoromo ëꞌane höjo. ");
INSERT INTO aom_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","God ëhi uanugoromo ë aribövioho uëvadeje: Nasi Vavuohuro jöe ahoꞌo bojemijëꞌe höjo muebeꞌirodego. Vavuohuro gemuëro Harihoho na avoho gevaje höjo. Harihoho naremuëremu Vavuoho avoho gavaje höjo. O Harihu naehu di aribövi röjëhiꞌi negëꞌohuro ëhuro ë ariböviohuremu röjëhijego jabuꞌo Vavuoho gavarue höjo. ");
INSERT INTO aom_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Ëhi uëvëꞌëro Iesuꞌo hesi ijorajoho jabuꞌo jabesi sivue raromoromo Iesuro hunuorovoromo uëvadeje: Jemë mu maho gavarujëro jëvëꞌëro ëhuꞌëro jemë mae jëvajëjo. ");
INSERT INTO aom_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Ave jöho na jö mae uëꞌiëꞌajëjo. Jemëhu gavaruje muoho o hejaruje jöho urimëꞌi jö God-aro baeromo majëhinövare ariböviohuꞌo saꞌare a masijohuꞌo ahoꞌobëhe jaburo nimoruomade höjo garomo heꞌiro. Röhu bogo garomo heruomade höjo. Röhu God-ro jemë ajëmijëꞌëro ëho gavaruje höjo. Ëhuꞌëro jemë huë mae baejëꞌe jëvajëjo. ");
INSERT INTO aom_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Ëhiꞌamu gagorovo Jew rajo jögoru öri röjëhijaje ae gemuëro Iesuare dëho bijioho gaꞌirögoro riꞌöromo uavadeje: Tisajo. Na diehiꞌoromo ioroꞌioremuoho maroho hiꞌejöjo. ");
INSERT INTO aom_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Maroho hiꞌejöjamu Iesuro uavadeje: God-are surire jöho diehi jajivëꞌe höjo. Ja uehorovanuoho bëhoho diehi höjo. ");
INSERT INTO aom_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Bëhoho diehi höjamu ruehuro uavadeje: Jasi dë vövöbajoꞌe aruꞌahe daruge uehore ahoꞌobëhe Bada jasi God ma-hu gemu bojaminëjo. O jö göho jaehu jasi arijoꞌarije rajahirovanuëhi jasi ae gemuoho ëhi rajahinëjo. ");
INSERT INTO aom_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Rajahinëjamu Iesuro uavadeje: Ja jö mae jövanuëjo. Ëhi ëꞌëꞌoho ëhuro ja maro hiꞌaꞌanuëjo. ");
INSERT INTO aom_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Hiꞌaꞌanuëjamu rue röjëhijaje ahuro hesi ihoho mae jiojöro nimamu Iesu uavadeje: Röhu nasi ae gemuoho rahumë höjo. ");
INSERT INTO aom_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Rahumë höjamu Iesuro uhuꞌe uavadeje: Iae Jew raje ae gemuëro Jerusalem jioromo Jericho amore abueꞌiëꞌade höjo. Örire abueromo nume vajiohuꞌe aribövi jabesi övoro vaꞌade höjo. Övoro vaꞌamu guduamoromo niögoho maho sisëho vajiohëro ujuohahoromo saꞌijosaꞌijovoromo gavare guomoꞌiaꞌamu gagorovo nugo vaꞌare höjo. ");
INSERT INTO aom_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Vaꞌamu gagorovo priest-ëro ijonö örire ruvebijade höjo. Ruvebiꞌi gavade aho raromamu gagorovo iosiramiromo öri ioni gönö vaꞌade höjo. ");
INSERT INTO aom_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Ëhiꞌamu Levi raje God-are mu ajamaje ahuro ëhi gemuoho ëꞌade höjo. Ruvebiromo bëhire vaꞌoromo aho ërimahonugoromo öri ioni gönö vaꞌoromo iosirami vaꞌade höjo. ");
INSERT INTO aom_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Vaꞌamu gagorovo saꞌa gö raje ae gemuëro örire ruvebijade höjo. Hu Samaria saꞌa raje jemëhu nu huodëgaruje saꞌa raje ae gemuëro ruvebijade höjo. Ëho rajëro ruvebiromo Jew rajoho birohade höjo. Birohoromo gavade raromamu gagorovo huni vavaenimade höjo. ");
INSERT INTO aom_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Vavaenimamu vaꞌo garomo nemoꞌamade sagohore ninuguꞌe osohuꞌo wine jovo osohuꞌo otehahoromo muohahoꞌamade höjo. Muohahonugoromo banigojiomoromo hesi mi dejore bamonugoromo huꞌirae baꞌobuejadoho abo öri jijihoromo momoröꞌöjarue osare rovade höjo. Rueromo hiromo aho avoho ajamijade höjo. ");
INSERT INTO aom_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Ajamiromo diroharëro sisonuvamu gagorovo Samaria rajohuro ajivëꞌe ijo baje niöꞌi jabesi uhure ahoꞌo jiëꞌoho baeromo osa muebejaje aho bojamiromo uavade höjo: Na vaꞌajëjo. Jero ave aho avoho muebenëjo. Monie göꞌo buꞌöjëꞌoho vuonoröꞌö rueromo naro jaehu buꞌöjane ë hesi manaho bojamiꞌejöjo. Ëhiꞌade höjo. ");
INSERT INTO aom_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Röhu ja diehi uehorovanuëjo. ËJew rajohuro vajiohuꞌe aribövi jabesi övore vaꞌoromo sisë birohade höjo. Sisë birohamu ae niöꞌi gemu ro hu gavare höjo. Göho priest-ëro göho God-are mu ajamijaje ahuro göho nu huodëgaruje saꞌa gö rajohuro ëhi ro gavare höjo. Röhu di aho hesi ae gemuoho jiade höjo. ");
INSERT INTO aom_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Ae gemuoho jiade höjamu jögoru öri röjëhijaje ahuro uavadeje: Huë baeromo ajamijade aho hu hesi ae gemuoho jiade höjo. Ëhi uavamu Iesuro uavadeje: Jero vaꞌoromo ëhi jiëꞌe muoho vaenövonëjo. ");
INSERT INTO aom_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Ëhi uënugoromo iae Iesuꞌo hesi ijorajoho jabuꞌo vaꞌaroho vaꞌo amore suorovareje. Suorovamu magonahe gemu hesi ihe Martha-ro Iesu uavadeje: Nasi osaro ro hijëjo. ");
INSERT INTO aom_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Hijëjamu Iesuro osare vaꞌo hijadeje. Hijamu Martha-are öe Mary-ro ro Badare höru bëhire hiromo huhu jö röjëhijajoho hejadeje. ");
INSERT INTO aom_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Hiromo jöho hejamu gagorovo Martha-ro Iesuni bövie biseꞌe avohoromo bogo eni jiamu nurunurumoromo Iesu uavadeje: Bada nasi öho na remöꞌöjëꞌëro nasi sivue mue vaejajëjo. Na ja nasi jöënioho bogo uehorovanuëjo. Uavego ro ajemajo. ");
INSERT INTO aom_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Ajemajamu Badaro uavadeje: Asëꞌe Martha-ajo. Jero mue ahoꞌobëhe uehorovoꞌego ëhuro nurunuruagajëjo. ");
INSERT INTO aom_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Röhu ja mue gemu bogo baejëꞌe javajëjo. Aꞌi Mary-ro mu maho baejëꞌe höjo. Ëmuoho no bogo ahoꞌejarëjo. ");
INSERT INTO aom_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Iae Iesuro hiromo God-are örire jöe jövadeje. Jöe jövoromo barëjamu gagorovo hesi ijorajoho gemuëro uavadeje: Bada God-are örire jö atoꞌiröhego John-hu hesi ijorajo ömoꞌömo röjëhijadëhi jero noꞌo ëhi ë hesi öroho röjahuijëjo. ");
INSERT INTO aom_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Röjahuijëjamu hegorovo Iesuro uëvadeje: Jemëhu God-are örire jö atëꞌiroho ëhi uarëjo: Apo ae ahoꞌobëhe nosi dë vövöbajoꞌoho avohahuego ja gemu mae uehorovavoꞌirarëjo. Jero böröme namiromo ahoꞌobëhe muebejavuego no jasi aharire gemu raromoꞌirarëjo. ");
INSERT INTO aom_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Vae majae ioho bojamuibe vaꞌego ueꞌahego daꞌuaguoꞌirajo. ");
INSERT INTO aom_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Nosi sisëho uehorovoromo vuonugahuëjo no a jabesi sisëho uehorovoromo vuonugëharue jiaje. Nadi vöröꞌeroho ramuöꞌöjego rireromavuoꞌirajo. ");
INSERT INTO aom_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Ëhi uënugoromo Iesuro hesi ijorajo ömoꞌömoho uhuꞌe uëvadeje: Nani jemë ae gemuëro vahi ririꞌe aemoꞌaemo hesi osare vaꞌoromo uaꞌaꞌanuëjo: Isiajo. Ie gö bojemëjo. ");
INSERT INTO aom_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Nasi aemoꞌaeme gö örire juvëꞌëro nasi osare ro hijajëjo. Röhu i bojamiꞌirodoho bogojevajëjo. ");
INSERT INTO aom_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Bogojevajëꞌiramu nani jasi aemoꞌaemohuro osare raromoromo uaꞌaꞌajëjo: Nadi nunëhoho iegëjo. Mamiꞌe oje tugohoromo asisöꞌoꞌo naꞌo momoröꞌöjëꞌëro na bogo riꞌöromo ajamiꞌejöjo. ");
INSERT INTO aom_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Nani ëhi uaꞌaꞌajëjo. Röhu naro jemë uëvajëjo: Nani hu bogo uehorovoromo uvoꞌaꞌajëjo: Nasi aemoꞌaemego riꞌöromo ajamiꞌejö uvoromo ajamiꞌi röhu heröhe jero biririvoromo ua gaꞌi hiꞌiramu evare hu riꞌöromo ja rabe rabe nimanuoho bojamiꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Ëhuni na jemë uëvajëjo: Biririvoromo God ua garëjo. Biririvoromo ua gavëꞌoho ujuohoꞌarujëjo. Biririvoromo nahorëjo. Nahëꞌoho birohoꞌarujëjo. Ojoho anoꞌanovorëjo. Anoꞌanovëꞌoho God-ro jiovëhoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Ae rahu ua gavëꞌoho ujuohoruomoꞌajëjo. Nahëꞌoho birohoruomoꞌajëjo. Anoꞌanovëꞌoho ojoho jiovëhoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Nasi jö hejarujoho ae gö vavu ömoꞌömoꞌe jëvajëjo. Jemesi harihehu uëvëꞌiroho: Jovo mie bojemego na ijö uëvamu hejëꞌoho na jemë sareramiromo sigobu sisëho bojamirëjo. ");
INSERT INTO aom_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","O uëvëꞌiroho: Ugo une bojemego na ijö uëvamu hejëꞌiroho na jemë sareramiromo ögusuru une bojamirëjo. Bogajo. Jemë i mae iꞌimamiꞌarujëjo. ");
INSERT INTO aom_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Jemë sisë aribövie jëvajëjo röhu jemesi aboji harihuꞌo avoho suvuorëmiꞌirarije öroho iae gavaruje höjo. Jemë sisë jëvoꞌi öꞌidöre hijaje jemesi Vavuoho mae jiaje jemëro uvorëjo: Hu maëro jiëꞌëro ae rahu ua gavëꞌoho nosi Vavuohuro hesi Aruꞌahoho iae mabëhe suvuoramuiꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Ae gemu aruꞌaho sisë dëre jiëꞌëro bitare tövoromo jöe bogo jövëꞌe hijadeje. Hijamu Iesuro aruꞌaho sisëho rarovöꞌöjadeje. Rarovöꞌöjamu ë aho aevoromo jöe jövadeje. Jöe jövamu gagorovo ae ahoꞌobëhe tiöjëvadeje. ");
INSERT INTO aom_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Tiöjëvamu a ioroꞌiorohuro uarovareje: Beelzebul sisë a börömohuro vöröho bojamijego ëhuro Iesuro a dëre aruꞌaho sisëho rarovöꞌöꞌamaje höjo. ");
INSERT INTO aom_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","A ioroꞌiorohuro nimareje Iesuare darugoho gaꞌi diehi jiëꞌe jiego. Ëhi nimoromo uavareje: Bogo gavarue darugoꞌe muoho röjahuijego no gavarëjo God-ro ja ajamego o bogo ajamego. ");
INSERT INTO aom_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Ëhi uavamu Iesuro jabesi sareri sarerioho gëromo uëvadeje: Saꞌae gemuehu adovoromo jabesi arijoꞌarije muorovëꞌoho barërovoꞌajëjo. O agane gemuehu adovoromo jabesi arijoꞌarije muorovëꞌoho sisërërovoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Ëhuni Satan-ro riꞌöromo hesi ariböviohuꞌo muorovoꞌibejajo hesi darugoho uehoroho muoho diehiꞌoromo biririvoromo namiꞌibejajo. Jemëro uvarujëjo: Sisë a börömohuro nörö vöröho bojamego hesi sisë aribövioho rarovöꞌöjaje höjo. ");
INSERT INTO aom_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Ëhi jiëꞌoho na jemesi ariböviohuro sisë a börömo hesi vöröho baeromo rarovöꞌöꞌamarue höjo. O diehiꞌoromo ëꞌarue höjo. Jaburo uëꞌaꞌaruëjo: Sarerivarujëjo. Aho bogo sisë a börömo hesi vöröho baeromo ëhioho ëꞌarue höjo. ");
INSERT INTO aom_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Aꞌi naro God-are darugoho baeromo rarovoꞌamaje höjo. Ëhuni uvorëjo: God-ro aevoromo böröme namiromo nosi örire muebejavuajëro jiëꞌëro ëhuꞌëro ëꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Biririꞌe aehu bije tone bahiromo javuoho avoho muebejëꞌoho hesi inömo inömoho ma-jiemu jioꞌaꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","O ae göehu rueromo javu arijoꞌo hesi biriri iosiramijëꞌoho javu arijoꞌohuro uvoꞌaꞌajëjo: Bije tone eni javajëromo hiꞌiramu ruehuro osare rueromo arijoꞌoho guduamoromo ruahoromo bijoho tonoho ujuohoniahiromo inömo inöme ahoꞌo ujuoho vaꞌaꞌajëjo. Vajiohehu ujuohadoho ae suvuorëmiꞌajëjo. Naro Satan ëhi ruahöꞌöjaje höjo. ");
INSERT INTO aom_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Ae rahu bogo nasi a jiëꞌoho ëho huro naꞌo muorovaje höjo. O na bogo ajemiromo nasi aribövi gagovëꞌoho ëho huro arua anumiae nugöꞌöꞌamaje höjo. ");
INSERT INTO aom_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Röhu Satan-are mu ajamaje aruꞌaho sisëhuro ae gemu hesi dëre hiꞌaꞌajëjo. Hiromo hörö vaꞌaꞌajëjo. Vaꞌoromo jovo rumoꞌe saꞌare vaꞌoromo hiꞌiröhe röhoho nahobe juvojuvo bogo birohogorovo uvoꞌaꞌajëjo: Na vuonoröꞌö vaꞌoromo hijode sionore röhu maho ë hiꞌejöjo. ");
INSERT INTO aom_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Ëhi uvonugoromo vuonoröꞌö vaꞌoromo urimo hijade a hesi dëre abueromo gaꞌaꞌajëjo dë vövöbajoꞌoho bibivoromo iogorëꞌe ma-mabëhe osa vaꞌëne jioꞌiramu. ");
INSERT INTO aom_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Ëhi jioꞌiramu gagorovo vaꞌoromo Satan-are aruꞌaho sisë ahoꞌobëhe söromo rueꞌaꞌajëjo. Ëurimore ro hijade aruꞌahoho a sisë höjo. Ijore huhu sö rovade ariböviohuro hu iosiramiromo jabumë sisë bëhi mae jioruomajëjo. Ëhuꞌëro urimo sisëꞌi hijade aho ijonöho sisë bëhe hiꞌaꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Iesuro ëhi uëvamu hejëꞌi magonahe gemuëro ae ahoꞌobëhe jabesi ririre jiëꞌëro Iesu ma-darugoꞌo uavadeje: Ja rahavoromo amu bojamijade magonahohuro maroho hijaje höjo. ");
INSERT INTO aom_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Maroho hijaje höjamu uavadeje: Ëho ma-jianovoꞌi aꞌi ae rahu God-are jö heromo ejahëꞌoho ë ariböviohuro ma-maroho raromarue höjo. ");
INSERT INTO aom_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Iae ae ahoꞌobëhe Iesuare bëhire ro tagavoruomadeje. Tagavoruomamu gëgorovo Iesuro uëvadeje: Ave jaruvore raromaruje aribövioho sisë aribövie jëvajëjo. Jemëro darugoꞌe muoho gaꞌi uevaruje höjo gaꞌi God-ro na ajemego muoho vaejaje jevego o bogo. Na ëhi jiëꞌe muoho bogo vaeꞌi aꞌi Jonah-hu God-are mu börömo röjëhijadëhi ëhi jiëꞌe muohuremu röjëhiꞌejöjo. Mue gö gö bogajo. ");
INSERT INTO aom_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Nineveh amo rajehu mae uehorovoröhego Jonah-hu mu röjëhijadëhi God-are A Maho naro ëhi jiëꞌe muohemu röjëhiꞌejöjo ave jaruvore raromaruje ariböviohuro mae uehorovevoꞌirarijego. ");
INSERT INTO aom_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","God-hu mevoromo gëröhe majaho rueꞌiramu arue saꞌa göre börömo vaenövade magonahohuro ave jaruvore raromaruje ariböviohuꞌo gemu mae riꞌöromo God-are nunire namiꞌaꞌajëjo. Namiꞌiramu God-ro ë saꞌa gö rajo magonaho hesi mu maho garomo jemesi mu sisëho garomo jemë uëꞌaꞌajëjo: Ëmagonahehu vaejade ëhi jiëꞌe mu maho bogo vaejëꞌego ëhuni na uëvajëjo: Jemë sisëꞌe aribövie jëvaje sisëro vaꞌohëjo. Ëhesi bëhoho ë saꞌare börömo vaenövade magonahohuro hesi saꞌaho vuonugoꞌi öri ëgoböviro rovade höjo a böröme Solomon-hu nuni ajiꞌe jö jövajoho heꞌiro. Solomon-hu ae ma-bisemu börömo jioromo jö majëhijajoho ë magonahohuro heꞌi nimade höjo. Aꞌi naehu Solomon iosiramiromo börömo mae jioromo jö majëhijajoho heꞌirarijoho jemë bijönëgajëjo. Ëhuꞌëro jiëꞌëro mevo gëröhe majaho rueꞌiramu jemë sisërëjëvoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","O ëho majaho rueꞌiramu ë saꞌae gö aribövie Nineveh amo rajohuro ave jaruvore raromaruje ariböviohuꞌo gemu mae riꞌöromo God-are nunire riravoruomoꞌajëjo. Riravoꞌiramu God-ro jabesi mu maho garomo jemesi mu sisëho garomo jemë uëꞌaꞌajëjo: Nineveh amo rajehu vaejare ëhi jiëꞌe mu maho bogo vaejëꞌego ëhuni na uëvajëjo: Jemë sisëꞌe aribövie jëvaje sisëro vaꞌohëjo. Ëhesi bëhoho ë Nineveh amo rajohuro mu sisë vaeruomëꞌëro hejare Jonah-ro God-are jöe majëhijamu hegorovo jabesi uehoro sisëho vuonugoꞌi uehoro mae baejare höjo. Jonah ma-biseꞌo jioromo jö majëhijadoho Nineveh amo rajohuro hesi jöho ejahare höjo. Aꞌi naehu hu iosiramiromo börömo jioromo jö majëhijajoho jemë bogo ejeharuje höjo. Ëhuꞌëro jiëꞌëro mevo gëröhe majaho rueꞌiramu jemë sisërëjëvoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Iro bunoꞌiraejëꞌiroho bogo saꞌa gagoroho hevö gagoroho gurihiꞌi ma-vaꞌorahoro bamoꞌanuëjo ae ë osare rovëꞌoho ajivëvoröhego. ");
INSERT INTO aom_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Jasi sino hesi iroho nunoho höjo. Jasi nuni mae jiëꞌoho ëhuro aji maro hiꞌaꞌanuëjo. O jasi nuni sisë jiëꞌoho ëhuro ja ramoramoro hiꞌaꞌanuëjo. Ëhesi bëhoho naro uëromo ëꞌajëjo: Jasi uehoro mae jiëꞌohuro God-are ajiꞌe jöho baeromo aji maro hiꞌaꞌanuëjo. O uehoro sisë jiëꞌohuro nunoho ramoramovavoꞌiramu ramoramoro hiꞌaꞌanuëjo. ");
INSERT INTO aom_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Avoꞌavoho mueberovonëjo. Nani jasi uehoroho sisëremu jioromo ramoramoꞌeremu javajëjo. ");
INSERT INTO aom_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Röhu jasi nuni mae jiego ajire hijanuëhi ramoramoho bogojioꞌi ma-aje gemu jiëꞌoho ëhuro aje ahoꞌobëhe jasirire rueromo ja ajivavo barëꞌajëjo. Irehu ajivavajëhi ëhi ajivavoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Iesuro jöho majëhiromo barëjamu gavëꞌi Pharisee ae gemuëro uavadeje: Nasi osaro rovego no i harihe gemuoro ijarëjo. Ijarëjamu Iesuro vaꞌoromo osare vaꞌo hijadeje ie iꞌirovo. ");
INSERT INTO aom_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Hijamu rue Pharisee ahuro gavade Iesuro a mami muoho bogo vaeromo övoho bogo eguëꞌe ioho ëma ijamu gagorovo tiöromo uehorovoromo uvadeje: Iesu diehiꞌoromo övoho bogo eguëꞌe ioho ëma ijajëjo. Ëhi jiëꞌe muoho God hu bijönimaje höjo. ");
INSERT INTO aom_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","God bijönimaje höjamu Badaro uavadeje: Övo eguo jö uvanuoho aveho hejëjo. Ëhi jiëꞌe muoho ëho ma-döemu höjo. Pharisee aribövioho jemëro döre muohemu vaeromo hevöho enatuoho uꞌoꞌamoromo uvaruje höjo: God iae ëhuni nimorohajëjo. Röhu jemesi uhoho vajiohuꞌe mu o mu sisë gö gö uehorovarujohuro ëhuro jemesi dë vövöbajoꞌoho irijiomëhëꞌe höjo. ");
INSERT INTO aom_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Simano sisërëjëꞌe aribövie jëvajëjo. Nani jemë uvarujëjo: Nunehu gaꞌamarue inömohemu God-ro avohoꞌamoꞌi nosi dë vövöbajoꞌoho bogo avohade höromo ëhuni öve hevöe enatue ëhi jiëꞌe inömo hesi vaꞌinumohemu uehorovoꞌi dë vövöbajoꞌo hesi sisëho bogo uehorovaruje höjo. ");
INSERT INTO aom_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Röhu ae huë baejëvoromo jemesi enatu gagore jovoho hevö gagore ioho ae suvuorëminövorëjo. Ëhi ëꞌëꞌohuro uvoꞌaꞌarujëjo: Inöme bövie biseꞌe ma-mae gemu jioꞌamajëjo. ");
INSERT INTO aom_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Pharisee ariböviohumë vaevëꞌoho jemë sisërëjëvoꞌajëjo. Jemëro jemesi i jögoru e avohoromo iꞌo buarohoromo ijarue rihuꞌe oso harihu harihue gö gö garue gö gö mevoromo 10 10 bahibe vaꞌoromo gemu gemu God suvuore bojamijaruje höjo. Ëhi jiëꞌe jögoru ininoho ejaho avoharuje höjo. Ëhi jiëꞌoho iae mae höjo. Nadi vuonugorëjo. Röhu a mu ma-maemu vaejëvoꞌirarije muohuꞌo God-are örire dë vövöbajoꞌere uehorovoꞌirarije muohuꞌo rumonimaruje höjo. Nadi rumonimoꞌibejarijëjo. ");
INSERT INTO aom_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Pharisee ariböviohumë vaevëꞌoho sisërëjëvoꞌajëjo. God rajahijarue osare vaꞌëꞌiroho jemëro jemesi sinohemu uehorovoromo ëhuni a masijehu raromaruire ë vaꞌo raromoꞌi nimaruje höjo. O imoꞌamaruire vaꞌëꞌiroho jemë nimaruje höjo ae ahoꞌobëhe uvoruomoröhego: Jemë a masijëro jijiharujëromo rajëhiromo jejëmiruomoröhego. ");
INSERT INTO aom_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Vaevëꞌoho sisërëjëvoꞌajëjo. Jemë ma-döhuremu mae jëvoꞌi uhoho sisë jëvajëjo. A guavoromo hure guodo sibiriꞌe bogo ruhëꞌoho jëvanovajëjo. Aëro sagohe saꞌa uhure jiaje jöho bogo uehorovëꞌe ëma uvarue höjo: Ma-saꞌa maemu höromo hu döre ë jijiharue höjo. Ëhesi bëhoho ae göëro uvarue höjo: Jemë maemu jëvajëjo. Röhu uhoho ëhi sisë bëhe jëvajëjo. ");
INSERT INTO aom_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Iesuro ëhi majëhijamu hegorovo Jew rajo jabesi jögoru öri röjëhijarue ae gemuëro riꞌöromo uavadeje: Tisa jaehu ëhi jiëꞌe jö jövanuoho ëho ja bogo Pharisee ariböviohemuoho agëvoꞌi jögoru öri röjëhijarue aribövioho ahoꞌobëhe noꞌo agavuanuëjo. ");
INSERT INTO aom_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Agavuanuëjamu Iesuro uëvadeje: Iae mae uvanuëjo. Jögoru öri röjëhijaruje ariböviohumë vaevëꞌoho jemëꞌo sisërëjëvoꞌajëjo. Aehu iꞌuꞌe inömo ujuoho vaꞌoruomojöro buahore bahijëhoromo vaꞌego bogo ajëmiromo övo name gemu vaduꞌehu vitu banigojiomëharuëhi jemëro ëhi ëꞌaruje höjo. Jemëro iꞌuꞌe muoho ahoꞌo ae bojëmiromo bogo mae bogo ajëmiꞌi ma-nunëremu gëvaruje höjo. ");
INSERT INTO aom_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Vaevëꞌoho sisërëjëvoꞌajëjo. Jö God-aro baeromo majëhinövare aribövioho jemesi hijo mionoꞌohuro muoꞌamare höjo. Muoꞌamëꞌëro jemëro ëma uvaruje höjo: No God-are aribövioho uehorovëvaruëromo jabesi sino guavoꞌamare huoho avohoꞌamaruje höjo. ");
INSERT INTO aom_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Röhu jabesi hu avoharujoho ëho uöromo ëꞌaruje höjo: Jö God-aro baeromo majëhinövare aribövioho nosi hijo mionoꞌehu muoꞌamaroho iae mae höjo. Naehu uëvaje hesi bëhoho jemesi hijo mionoꞌehu muoꞌamaroho jemëro jabesi sionoho avohoꞌamaruje höjo. ");
INSERT INTO aom_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Jemëhu a anoꞌirarije uehore ëhi jëvëꞌëro God-are simano maꞌe jöho ëhi uvëꞌe höjo: Jö nasiro baeromo majëhiꞌiröhe ariböviohuꞌo nasi apostle ariböviohuꞌo ëhi naro rëmöꞌöꞌiramu a jabesi örire vaꞌaꞌaruëjo. Vaꞌiramu aëro a ioroꞌioroho muoꞌamoꞌi ioroꞌioroho huë vavaene bojëmiꞌaruëjo. Ëhi uvëꞌe höjo. ");
INSERT INTO aom_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Ëhuꞌëro jiëꞌëro God-hu saꞌa bamadevare evare aevoromo jemesi hijo mionoꞌehu jö God-aro baeromo majëhinövare aribövi muoꞌamobe rovare ë hesi iꞌuoho ave jaruvore raromaruje aribövioho jemëni rueꞌaꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Aevoꞌioho aëro Abel anoromo God-are aribövi ioroꞌioroho ëhi muoꞌamobe ruejuvo ro ijo tugohoꞌioho Zechariah anare höjo. God-are suvuoro bahijarue maratuoho ruhëhi jioꞌi God-are osa börömo numëhi jiamu Zechariah ë ririre anare höjo. Ave jöho na jö mae uëꞌiëꞌajëjo. God-are aribövi ëhi muoꞌamobe rovare ë hesi iꞌuoho ave jaruvore raromaruje aribövioho jemëni rueꞌaꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Jögoru öri röjëhijaruje ariböviohumë vaevëꞌoho sisërëjëvoꞌajëjo. God-are mu ma hesi jöho jemëro bogo röjëhiꞌi aëro heruomojöëni jemëro ë hesi ojo jiovaruoho gurihi bamëꞌe jëvajëjo. Jemë ë mu ma hesi jöho bogo baejaruje höjo. O ae göehu baeꞌiaꞌamu gëvëꞌoho ahëvaruje höjo. ");
INSERT INTO aom_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Iesuro ëhi majëhinugoromo vaꞌadeje. Vaꞌamu gavëꞌi Jew rajo jögoru öri röjëhijarue ariböviohuꞌo Pharisee ariböviohuꞌo ëho jaburo Iesuꞌo vaꞌoromo aevoromo hu nue huodivoromo dinamiromo jöe gö gö ua gaꞌi arijareje. ");
INSERT INTO aom_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Jöe gö gö ua gaꞌi ariromo muꞌöjahareje heꞌi hu guaro berovoromo jöe sisëꞌi jövego. ");
INSERT INTO aom_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Iae ae ahoꞌobëhe mae ro tagavoromo tatijiomorovoromo hörëro bijöëro vaerovamu hesi ijorajoho jaburo urimo hejöro Iesuro ëhi majëhiromo uëvadeje: Jemëro gavëꞌiajo. Pharisee aribövi jabesi i dë huaje osohuro jemesirire rumorovoꞌajëjo. Jabuhu sareriꞌe mu vaejarue ëhi jiëꞌe muohuro jemesirire rumorovojöëni uëvajëjo. ");
INSERT INTO aom_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Jaruvoho Pharisee ariböviohuro jabesi mu sisëho gurihijarue höjo. Röhu mue rabe gurihiro jiajoho ahoꞌobëhe vaꞌorahoro jioꞌaꞌajëjo. Rabe rabe saginiëri vaejaruoho ahoꞌobëhe ma-samaro jioꞌaꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Ëhuꞌëro jiëꞌëro jemëhu jöe rabe vahiꞌe saginiëri atëꞌoho ijonö majaꞌe ë jöho ma-vaꞌorahoro heruomoꞌajëjo. O osa gagore raromoromo saginiëri hiaꞌire majëhijëꞌoho aëro amo ririre ë jöho ma-darugoꞌo majëhiruomoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Röhu nasi ariböviohumë naro ave jöho jemesi örire majëhiꞌiëꞌajëjo. Nadi uvorëjo: Ëariböviohuro anaguoꞌajëromo juhuonëmiromo jabesi jöho uehorovorëjo. Jemesi sino hahoꞌo muoꞌamëꞌoho eni jëvajëjo. Röhu sino hahoꞌo muoꞌamonugoromo ijonö mu sisë gö jemesi örire vaejëvëꞌoho bogo eni jioruomo hesi höjo. Ëhuni nadi ë aribövioho juhuonëmirëjo. ");
INSERT INTO aom_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Aꞌi juhuonamiꞌirarije aho naro uëꞌiëꞌajëjo. God juhuonamiromo hesi jöho uehorovorëjo. Ëhesi bëhoho God-hu jemesi aruꞌaho baejëhego vuovëvego evare ijonö vëniꞌe öri ariꞌere ujuoho ruruhöꞌöjëvoꞌiröhoho hu eni jiajëjo. Iae mae-ëjo. Jemë ë aho gemu juhuonamirëjo. ");
INSERT INTO aom_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Aꞌi aho bövioho biseꞌoho nadi juhuonëmirëjo. Ëhesi bëhoho God-ro uvajëjo: Jemë iae masije jëvajëromo avoꞌavoho muebejëvaje höjo. Monie ma-bisemu buꞌöromo ugo inine övo gö mine imoꞌarujëjo. Röhu God bogo uvaje höjo: Ugoho ininego bogo muebeꞌamoꞌejöjo. Bogo ëhioho uvoꞌi iae hu avoꞌavoho muebeꞌamaje höjo. ");
INSERT INTO aom_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Aꞌi jemë God-ro jemesi bövie biseꞌe ahoꞌo muebejëhoromo röhu jemesi simano uoho ëhuꞌo adahëhoromo avoꞌavoho muebejëhaje höjo. Ëhuni nadi juhuonivorëjo uge ahoꞌobëhe jioꞌamajoho ëho ma-jianovoꞌi ae gemu gemu jemë masije jëvëꞌe jiaje. ");
INSERT INTO aom_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Röhu ave jöho naro uëvajëjo. Ae rahu a nunire uvëꞌoho: Na Iesuare ae jevajë uvëꞌoho God-are A Maho naro God-are anera jabesi nunire uvoꞌejöjo: Ëho nasi ae magonahe höjo. ");
INSERT INTO aom_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","O ae rahu a nunire uvëꞌoho: Na bogo Iesuare aehu jevajë uvëꞌoho naro God-are anera jabesi nunire uvoꞌejöjo: Ëho bogo nasi aehu magonahehu höjo. ");
INSERT INTO aom_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","O ae rahu God-are A Ma nasi jö sisëꞌi atëꞌoho God-ro uehorovoromo vuonugoꞌajëjo. Aꞌi ae rahu God-are Aruꞌaho hesi jö sisëꞌi atëꞌoho ëho God bogo uehorovoromo vuonugoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","O jemë nasi mu vaejamu gavëꞌoho aëro uvoꞌaꞌaruëjo: Iesuare mu vaejarujoho ëho mu sisë vaejaruje höromo jemë guduamëvoromo God rajahijarue osare mu vaejarue a masijo jabesi nunire o gavana jabesi o saꞌare a masijo gö gö jabesi nunire rëmoruomoꞌajëjo court vaejëvojöro. Ërëmëꞌiroho nadi uvorëjo: No diehi nosi jöho majëhiꞌejarëjo. O rabu jöe majëhiꞌejarëromo nurunurumorëjo. ");
INSERT INTO aom_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Ëhesi bëhoho jemëhu jö majëhiꞌirarije majaho rueꞌiramu evare majare God-are Aruꞌahohuro röjëhiꞌiramu garomo uvoꞌaꞌarujëjo: Iae no ëhi ëhi majëhiꞌejarëromo ëhuni nadi nurunurumorëjo. ");
INSERT INTO aom_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Iae ae ahoꞌobëhe jiareje röhu ae gemuëro riꞌöromo Iesu uavadeje: Tisa nasi öho uavego nosi vavuehu guomoꞌi nugahuadoho na gö bojemiꞌirajo. ");
INSERT INTO aom_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Gö bojemiꞌirajamu Iesuro uavadeje: Raro uvade höjo naro jemesi muoho gavëhoromo jemesi inömo inömoho maho sisëho mevonövoꞌirodego. Ëho bogo nasi muehu höjo. ");
INSERT INTO aom_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Ëhi uanugoromo ae ahoꞌobëhe uëvadeje: Jemëro gavëꞌi avoꞌavoho mueberovorëjo. Jemesi sinohemu uehorovoromo bövie biseꞌe baeꞌi ëma nëgojöëni uëvajëjo. Ja saꞌae jove inömo inöme rabe rabe bövi mae baejëꞌoho bogo ëhuro maroho hiꞌaꞌanuëjo. ");
INSERT INTO aom_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Ëhi uënugoromo ave uhu jöho röjëhiromo uëvadeje: Iae bövi biseꞌo marohëꞌe ae gemuëro hijade höjo. Hijamu hesi saꞌaroho irunoꞌoho ma-mabëhe riꞌamade höjo. ");
INSERT INTO aom_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Ma-mabëhe riꞌamamu gagorovo huro hesi simanore uehorovoromo uvade höjo: Nasi irunoꞌoho börömo böröme jevajëjo. Ëhuꞌëro nasi irunoꞌo avoho bahiꞌirode röhoho bogo eni jioꞌamajëjo biseꞌëro jiëꞌëro. Ëhi jiëꞌoho na diehiꞌoꞌejöjo. ");
INSERT INTO aom_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","O iae na ëhi ëꞌejöjo. Nasi i bahijaje osaho biseꞌe jioꞌamëꞌëro naro dadovoꞌamoꞌi javu masijo masije vaeꞌamoꞌejöjo nasi irunoꞌe nasi bövie biseꞌe ë maro bahiꞌirodëni. ");
INSERT INTO aom_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Vaenugoromo naro nasi uvoꞌejöjo: Na eni jevëꞌe ae jevajëjo. Irunoꞌoho inömo inömoho bövi mae avoho bahijëꞌëro vadune ahoꞌobëhe eni jevobe vaꞌaꞌajëjo. Ëhuni na nuhoromo ma-hijëꞌi ie jove iromo nimoronimorohonövoꞌejöjo. ");
INSERT INTO aom_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Nimorohonövoꞌejöjamu God-ro uavade höjo: Ja simano sisëꞌi uehorovanue ae javajëjo. Jaruvo vahiꞌe naro jasi aruꞌahoho baejahoꞌiramu guomoꞌaꞌanuëjo. Guomoꞌiramu jaehu bahijane irunoꞌoho bövioho biseꞌoho raro baeꞌaꞌajëjo. God-ro ëhi uavade höjo. ");
INSERT INTO aom_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Ëaehu ëꞌade mu hesi bëhoho ëhi höjo. Ae rahu hesi sinohemu uehorovoromo bövi biseꞌo marohëꞌe mae bahiromo uvëꞌoho: Ëhuro na eni jevajë uvamu röhu God-hu uvëꞌoho: Bogo ëhioho jioꞌi hu bogo eni jiëꞌe hö uvëꞌoho ëhuro ë ahuꞌo hesi muohuꞌo beꞌaꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Ëhi uënugoromo Iesuro hesi ijorajo ömoꞌömoho uëvadeje: Inömemu uehorovëꞌoho bëhi rumoꞌe jiëꞌe jiaje ëhuni nadi uvorëjo: No i rabe ueꞌahoromo bogo vuovoꞌi biririvoromo raromoꞌejarëjo. Uho niöguꞌo rabëro sino hahoꞌoho riogivoꞌejarëromo nurunurumorëjo. ");
INSERT INTO aom_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Ëhesi bëhoho ioho biseꞌe jioꞌi jemëhu biririvoromo raromarujoho ëho börömoho höjo. Uho niöguꞌoho biseꞌe jioꞌi sino hahoꞌo jëvajoho ëho börömoho höjo. ");
INSERT INTO aom_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Magugoho uehorovohëjo. Noehu ëꞌaruëhioho magugoho bogo ëhioho irunoꞌoho bivarue höjo o gagovarue höjo. I bahijarue osaho bogojëvajëjo. Röhu God-ro ë ugoho mioꞌamaje höjo. Röhu jabumë ma-biseꞌe jioꞌamoꞌi jemë masijo mae jëvajëjo. Ëhuni hu jemëꞌo avoꞌavoho muebejëvoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","O jemëhu uvëꞌoho: No diehiꞌoromo ave saꞌaroho majae ëgoꞌo raromoꞌejarë uvoromo nurunurumëꞌoho na ëhuro jemesi vuovoꞌirarije majaho iosiramiromo ruëhi ma-bisemu göꞌo raromobe vaꞌorëjo. Bogajo. ");
INSERT INTO aom_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Ajamirovoromo bogo vuovoꞌi majae ëgoꞌo raromëꞌoho ëho mu biseꞌe höjo. Röhu nurunurumëꞌohuro ëgoꞌo raromoꞌirarijoho jemë bogo eni jëvajëjo. Ëhuꞌoho rabëni mu göëni göënioho nurunurumaruje höjo. Bëhe bogohöjo. ");
INSERT INTO aom_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","O jeꞌore resu resuehu diehiꞌoromo riꞌamaruoho ëhuꞌo uehorovohëjo. Aehu mu vaeromo niögu avoharuëhioho resu resuoho bogo ëhioho ëꞌarue höjo. Bogo ëhioho ëꞌarue höjo röhu ave resu resuoho ma-mabëhe kavuego garomo nosi dëho vuëvavuaje höjo. Naro jemë uëvajëjo: A böröme Solomon niögu ma-mabëhe ioꞌamonövadoho ëho ma-jianovoꞌi ave resu resuoho ma-mabëhe mae kavuoꞌamaje höjo. ");
INSERT INTO aom_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Jaruvëhi resu resuoho saꞌare rijego nërëhi ëhi aëro jahoromo vëniro huoꞌamarue höjo. Röhu ëhi jiëꞌe resu resuoho God-ro muebejego marëromo kavuoꞌamaje höjo. Resu resuoho ma-biseꞌe jioꞌamoꞌi jemë masijo mae jëvajëjo. Ëhuni uvorëjo: Hu noꞌo avoꞌavoho muebejavuoromo uhe niöge iꞌimamuiꞌajëjo. Nurunurumarujoho God bogo ma uehorovaruje aribövie jëvajëjo. ");
INSERT INTO aom_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Röhu jemëro nadi uvorëjo: No i rabe jovo rabe iꞌejarëromo nurunurumorëjo. ");
INSERT INTO aom_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","God-are jö bogo hejëꞌe raromarue ariböviohuro ie jove bövie biseꞌe ëhuremu uehorovoruomaje höjo. Röhu jemëro nadi ëhioho ëꞌorëjo. Jemesi Vavuohuro iae mae garomo uvajëjo: Jemë iëro jovëro rabëro ëhuro biririvoromo raromarujëjo. ");
INSERT INTO aom_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Ëhuni nadi ëhemuoho uehorovoꞌi aꞌi God-hu böröme namiromo muebejëvaje muoho ëho uehorovorëjo. Ëhi ëꞌëꞌoho God-ro jemesi aruꞌahoho muebejëvoromo röhu ie jove niöge ëhuꞌo romoromoro bojëmiꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Jemë bogo ae ahoꞌo jëvoꞌi God-are ö mahuꞌe ma-gemu gemu jëvajëjo. Röhu nadi juhuonivorëjo. Jemesi Vavuohuro iae nimajëjo hesi ajiꞌe öri ariꞌe ë hesi huë maho bojëmiꞌiröhëni. ");
INSERT INTO aom_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Röhu jemesi bövioho biseꞌoho imoꞌamoromo monioho baeromo bogo eni jiëꞌe aribövioho suvuorëmirëjo. Ëhi ëꞌëꞌoho jemesi bövioho biseꞌoho öꞌidöre bahiꞌarujëjo. Ëhuro bogo sisërëjëhoꞌi vajiohuꞌe aho bogo bëhiroho vaꞌoromo ujuohëhoꞌi majo majoho bogo tarivëhoꞌi aꞌi jemesi bövioho biseꞌoho marohëꞌe mae jiemu jiëhoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Jemesi mae sisë dinöꞌe jiajire jemesi dë vövöbajoꞌoho ë gemu jioꞌaꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Röhu jö göho ave muohuꞌo vaenövorëjo. Jemëro avohorovoromo uho niöguꞌe vaeromo iroho bueromo avoho raromorëjo. ");
INSERT INTO aom_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Avoho raromoromo mu ajamijarue ariböviehu jabesi börömehu rovego ajamiꞌi muebejaruëhi ëhi avoho raromoromo mueberëjo. Ëhesi bëhoho mu ajamarue aribövi jabesi börömohuro aehu masuꞌiröhe söröre vaꞌëꞌëro vuonoröꞌö rueromo ojore anoꞌanovoꞌiramu rueho jaburo heromo ojoho ma-burëro jiovahoꞌaruëjo. ");
INSERT INTO aom_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Ma-burëro jiovahoꞌiramu jabesi a börömohuro garöhe jabumë nune jioruomoromo eni jëvamu gëvëꞌoho huë mabëhe bojëmiꞌajëjo. Huë mabëhe bojëmiromo hesi niögoho avoho ruahoromo jaburo saꞌare raromojöro uënugoromo ioho jovoho iꞌimëmiꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Ëa börömehu bogo burëro rueꞌi vahi ririꞌe o vahi riri duvahoho iosiramiromo ëhi ruëhi rueromo gëröhe jabumë eni jëvamu gëvëꞌoho huë mabëhe bojëmiꞌiramu baeruomoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Ave uhu jöhuꞌo avoꞌavoho uehorovohëjo. Vajiohuꞌe aehu rueröhe majaho osa arijoꞌoho bogo gavade höjo. Gaꞌibejajo vajiohuꞌe a hesi öroho tugohahego osaho bogo dadovoromo inömoho ujuohoꞌibejajo. ");
INSERT INTO aom_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Osa arijoꞌohuro gavëꞌi hiꞌibejajo mae jioꞌibejajo. Jemëꞌo gavëꞌi raromorëjo. Jemë bogo uehorovëꞌe raromaruje majare evare God-are A Maho naro rueꞌejöjo. ");
INSERT INTO aom_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Ëhi uëvamu hegorovo Peter-ro Iesu uavadeje: Bada na ja jasi ijorajoho noremuëremu röjahuiꞌi o ae ahoꞌobëhe röjahuiꞌi ë uhu jöho majahuijanuëjo. ");
INSERT INTO aom_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Majahuijanuëjamu Badaro uëvadeje: Naehu ë jö majëhijaje hesi bëhoho aehu hesi a börömo hesi muohemu uehorovëꞌi simano mae uehorovoromo mu vaejajëhi jemëro ëhi muoho vaenövoꞌirarijego uëvajëjo. Ëhi jiëꞌe mu muebejaje a hesi a börömohuro uaꞌaꞌajëjo: Na vaꞌiëꞌajëjo. Jero nasi mu vaejarue a ioroꞌioroho muebejëvonëjo. Muebejëvoromo majae eni jiego jabesi irunoꞌoho iꞌimëminövonëjo. Iꞌimëminövonë uanugoromo vaꞌaꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Vaꞌo hijuvo röhu ijonö vuonoröꞌö rueromo garöhe ë ahuro hesi muoho avoho vaejahoꞌiramu gagorovo huë mabëhe bojamiꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Huë mabëhe bojamiromo uaꞌaꞌajëjo: Ja mu mae vaejanohuni ëhuni na mu börömore bamavoꞌejöjo. Jero bövie vaeromo nasi saꞌae inömo inöme bövie biseꞌe ahoꞌo muebejehonëjo. Mu avoꞌavoho muebejëꞌoho iae hu ëhi uaꞌaꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Aꞌi ë mu vaejahaje aho sisë jiëꞌohuro ëhuro uehorovoromo uvoꞌaꞌajëjo: Nasi börömoho bogo burëroho rueꞌi örisanuovajëromo riꞌöromo mu vaejarue aho magonahoho muoꞌamoromo ie jove iromo ëhuro simane sisërëꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Ëhiꞌoromo bogo gavëꞌe uehorovëꞌe hiꞌiramu evare hesi börömoho ma-majioho rueꞌaꞌajëjo. Rueromo sino hahoꞌoho sisë maro ijumahoromo nugöꞌöꞌiramu sisëro vaꞌoromo jö ahoꞌahoꞌe ariböviohuꞌo hiꞌaꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","A börömehu nimajoho mu vaejahaje aehu heromo röhu jö bogo ejahoromo bövi biseꞌo bogo avohoꞌamëꞌoho ëhuro hesi a börömohuro rueromo sisë maro anoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","O a börömehu nimajoho mu vaejahaje aehu bogo hejëꞌe mu sisë vaejëꞌëro mana anoröhe bëhi jiëꞌoho iae ma-bisemu anoꞌajëjo. Röhu mu vaeꞌirarije simano ma-mabëhemu o suvuoro gö gö bövi mae God-hu jemesi örire bojëmijëꞌoho huro uvoꞌaꞌajëjo: Na böröme bojëmijëꞌëro ëhuro mu böröme vaeruomoꞌajëjo. O bogo vaeruomëꞌoho ëho sisë höjo. ");
INSERT INTO aom_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Naehu rovode hesi bëhoho saꞌae ahoꞌobëhe vëninöꞌe ravëvoꞌi rovode höjo mu sisëho barëꞌi ahoꞌobëhe ma-maemu jioröhego. Ëmuoho mamiꞌe vae barëꞌibejajo iae mae jevoꞌibejajo. ");
INSERT INTO aom_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Röhu ë hesi urimo na viꞌehe huë vavaene baeꞌirodoho ëho nasi örire jovëro rovanovo hesi höjo. Ëho bapataeto vaejevanovoꞌajëjo. Ëhuni naehu nurunuru börömo baejajoho hujeji ë huë vavaenoho baegorovo evare mae hiꞌejöjo. ");
INSERT INTO aom_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Nani jemëro uehorovoromo uvarujëjo: Nöröhu rovade hesi bëhoho nöröro ajamuego saꞌae ahoꞌobëhe iro muorovoꞌoho vuonugoꞌi ma-huë baerovoromo gemuoro raromoꞌiröhego rovade höjo. Jemëro ëhi uvarujëjo röhu na bogo ëhunioho rovode höjo. Bogo mae bogajo. Aꞌi naehu rovode hesi bëhoho naro nasi jöho majëhijego aëro heromo adovoromo ae göëro jöe gö uehorovoꞌi ae göëro jöe gö uehorovoꞌirarijego rovode höjo. ");
INSERT INTO aom_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Ëhesi bëhoho nani agane gemuoho ae ahoꞌobëhe övo gö mine osae gemuore huë mae raromoromo röhu a ioroꞌiorohuro avevejöꞌe aevoromo nasi muoho nimoꞌi ioroꞌiorohuro bogo nimoromo ae niöꞌi gemu jaburo jöe gö uehorovoꞌi ae niöꞌiro jöe gö uehorovoromo ëhuro huë sisë baeromo bogo gemuoroho avoho raromoꞌaruëjo. ");
INSERT INTO aom_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Vavuohuro uehore gö baeromo harihoho nue huodivoꞌi harihohuro uehore gö baeromo vavuoho nue huodivoꞌajëjo. Vëmohuro uehore gö baeromo abojoho nue huodivoꞌi abojohuro uehore gö baeromo vëmoho nue huodivoꞌajëjo. Ajohuro uehore gö baeromo ajoho nue huodivoꞌi ajohuro uehore gö baeromo ajoho nue huodivoꞌajëjo. Ëhi jiobe vaꞌaꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Ëhi uënugoromo Iesuro ae ahoꞌobëhe uëvadeje: Jemëro gavaruje anumëhi sue rojomego uvaruje höjo: Iae ënëro rueꞌiëꞌajëjo. Rueꞌiëꞌajëjego evare ënoho rovaje höjo. ");
INSERT INTO aom_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","O jemëro gavaruje aruëhi bure rovego uvaruje höjo: Birebire böröme jioꞌiëꞌajëjego iae ëhi birebire böröme jiaje höjo. ");
INSERT INTO aom_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Jemë sareri sareriꞌe ae jëvajëjo. Jemëro saꞌaho öꞌidöho uherihoromo sue bure rabe rabe garomo uvaruje höjo: Ëhesi bëhoho iae ëhi jioꞌiëꞌajëjo. Röhu ave jaruvore rovaje muoho garomo ë hesi bëhoho bogo avoho garomo uvarujëjo: Iae God-are mu börömoho rovajëjo. Diehiꞌoromo bogo avoho gavarujëjo. ");
INSERT INTO aom_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Röhu jemë rabëni bogo avoho mevoromo gavaruje höjo di muoho mae jiego. ");
INSERT INTO aom_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Ae göehu jasi jö sisë hesirire jiëꞌëro ja baejavoromo court-re vaꞌiëꞌiroho jemë niöꞌiro örire vaꞌarujevaro jero huꞌo jöho mevoromo ahorire vae ganëjo. Bogo ahorire vaejëꞌoho huro guduamavoromo court gavaje a hesi övore bojamiꞌajëjo. Bojamiꞌiramu court gavaje ahuro police bojamiꞌiramu savoji gagore baꞌamavoꞌiramu ë hiꞌaꞌanuëjo. ");
INSERT INTO aom_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Ëhi hiemu hijuvo moni bojamiꞌiranoho ahoꞌobëhe bojami barë nahonahovoꞌanuëjo. Iae na mae uavajëjo. ");
INSERT INTO aom_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Ëhi uëvamu gavëꞌi ë raromarohuro Iesu uavareje: Galilee saꞌa raje ae göëro God-ni mie bahiꞌirögoro muoꞌamare höjo. Muoꞌamoromo köe otehamu gavëꞌi Pilate-are muorovo ariböviohuro ro ë aribövioho muoꞌamamu ëhuro jabesi köhuꞌo God-are mi köhuꞌo gemuore buarohëꞌe höjo. ");
INSERT INTO aom_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Buarohëꞌe höjamu hegorovo Iesuro uëvadeje: Na jemëro uvarujëjo: ËGalilee rajohuro Galilee rajo ioroꞌioroho iosirëmiromo sisë bëhe jioruomëꞌëro ëhuꞌëro ëhi jiëꞌe huë vavaenoho baeromo vuovade höjo. ");
INSERT INTO aom_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Hesi bëhoho bogo ëhioho höjo. Bogo mae bogajo. Aꞌi jemëhu uehoro sisë bogo vuonugoꞌi God mae uehorovëꞌoho jabumë vuovëvadëhi ae ahoꞌobëhe jemëꞌo ëhi iꞌuoho mana baeromo vuovëvoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","O Jerusalem raje ae ahoꞌobëhe 18 vuovëvade jöho uehorovohëjo. Jerusalem amore Siloam jovo bëhire javu ëgoböviohuro ahoromo ae ahoꞌobëhe 18 jabesi döre ruvebiromo taemoꞌamade höjo. Na jemëro uvarujëjo: Taemoꞌamade Jerusalem amo rajohuro Jerusalem amo rajo ioroꞌioroho iosirëmiromo sisë bëhi mae jioruomëꞌëro ëhuꞌëro ëhi jiëꞌe huë vavaenoho baeromo vuovade höjo. ");
INSERT INTO aom_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Bogo mae bogajo. Aꞌi jemëhu uehoro sisë bogo vuonugoꞌi God mae uehorovëꞌoho jabumë vuovëvadëhi ae ahoꞌobëhe jemëꞌo ëhi jiëꞌe iꞌuoho mana baeromo vuovëvoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Ëhi uënugoromo ave uhu jöho majëhiromo uëvadeje: Ae gemu hesi öꞌi bajo mure mesoho riꞌöjëꞌe jiade höjo. Riꞌöjëꞌe jiamugo rueromo böse nahoromo gavade höjo bogojiamu. ");
INSERT INTO aom_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Bogojiamu gagorovo mu arijoꞌohuro mu ajamijaje aho uavade höjo: Aveho gavëjo. Na aviae rueromo böse nahoromo gaꞌi hijode höjo mesoho bajoho bogo raejëꞌe jiamu gaꞌi hijodoho vadune ahoꞌobëhe niöꞌi gemu barëjëꞌe höjo. Ëhi jiëꞌe jiaje mesoho uejëjo. Rabëni ëma nugoꞌiramu saꞌa rihuoho barëꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Ëhi uavamu hegorovo mu ajamaje ahuro uavade höjo: Iae mae höjo röhu vuonugego vadune gemu göꞌo namijego naro bëhire voꞌonöe umo rovaꞌoromo mi dëho ë bahijego ëhuro rihue baeꞌiröhe höjo. ");
INSERT INTO aom_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Rihu baebe vaꞌoromo vadune gemu barëjamu bajoraejëꞌiroho ëho iae mae jioꞌaꞌajëjo. O bogo raejëꞌoho uevego na mesoho ueꞌiröjo. ");
INSERT INTO aom_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Iae Jew rajo jabesi nuho majae jiamu gagorovo Iesuro God rajahijarue osare hiromo jöho röjëhijadeje. ");
INSERT INTO aom_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Röhu ë osare magonahe gemu hijëꞌe jiadeje. Satan-are a sisë hesi dëre abuejëꞌëro ëhuꞌëro hesi sino hahoꞌo sisërëjadoho vadune ahoꞌobëhe 18 barëjadeje. Sisërëromo hesi dejoho gurorovëꞌëro ahorire namiꞌiröhoho bogo eni jiadeje. ");
INSERT INTO aom_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Ëhi jiamu gagorovo Iesuro magonahoho garomo uvamu rovadeje. Rovamu uavadeje: Maꞌino ja marëjavëꞌe höjo. ");
INSERT INTO aom_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Marëjavëꞌe hö uaromo övoho sinore bamahamu gavëꞌi ahorire namiromo God huë mae uavadeje. ");
INSERT INTO aom_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Ëhiꞌamu God rajahijarue osa muebejaje ahuro gavade nuho majare Iesuro magonahoho ëhi ajamamu gagorovo dë vörönimadeje. Dë vörönimamu ae ahoꞌobëhe uëvadeje: Mu vaejarue majaho majae ahoꞌo övo gö mine övo göre gemu ëhi höjo. Ëmajaro rovego hu jemesi sinoho ajëmiꞌirajo. Nosi nuho majaroho nadi ruerego hu ajëmiꞌirajo. ");
INSERT INTO aom_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Ëhi uëvamu hegorovo Badaro ë osa muebejaje aho uavadeje: Jemë sareri sareriꞌe aribövie jëvajëjo. Nuho maja jiëꞌiroho jemë ae ahoꞌobëhe mue vaeromo jemesi ö mahuꞌoho jiovoꞌamoromo jovore sö ujuoho vaꞌaruje höjo jove ueꞌahojöro. Na mae-ëjo. ");
INSERT INTO aom_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Jemëro jemesi ö mahuꞌoho nuho majare ëhi ajamijaruje höjo. Röhu ave magonahoho bogo ö mahuꞌehu jioꞌi hu Abraham-are ujëro jiëꞌëro ëhuꞌëro God-ro huë baejaje magonahe höjo. Röhu Satan-hu hu tövahadoho vadune ahoꞌobëhe 18 barëjajëjo. Ëhi jiëꞌoho naro rabëni nuho majaroho bogo ajamego bogo marëjörajo. ");
INSERT INTO aom_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Ëhi uëvamu hegorovo Iesu bijönimoruomade aribövioho ahoꞌobëhe javoje böröme baeꞌi a ioroꞌiorohuro ahoꞌobëhe uvoruomadeje: Iesuro mu mabëhe ahoꞌobëhe vaejaje hö uvoromo nimorohoruomadeje. ");
INSERT INTO aom_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Ëhiꞌamu Iesuro jöe gö majëhiromo uëvadeje: God-hu böröme namiromo muebejëvaje öroho naro uhuꞌe buꞌöromo jemëꞌo naꞌo uehorovoꞌejarëjo. ");
INSERT INTO aom_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Ijo hisu ihe mustard ujehu riromo ëgovoromo börömo rijajëhi God-ro böröme namiromo ae göꞌo göꞌo ëhi gagovoromo muebejëvobe vaꞌaꞌajëjo. Ae gemuëro mustard ijo hisu uje gemu baeromo hesi mure öjade höjo. Öjamu riromo ijo vaꞌëne ëgovoromo börömorijade höjo. Börömorijamu ugëro rueromo hesi adore ijue vaeꞌamare höjo. ");
INSERT INTO aom_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Ëhi uënugoromo jö göho majëhiromo uëvadeje: God-hu böröme namiromo muebejëvaje öri ë hesi uhu jö göho naro majëhiꞌiëꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","I dë huaje osehu ire rumorovajëhi God-hu böröme namiromo muebejëvaje muohuro saꞌae ahoꞌo ëhi rumorovobe vaꞌaje höjo. Magonahe gemuëro ie ahoꞌobëhe gagovoromo i dë huaje osoho i gemuore bamoromo iohuꞌo buarohade höjo. Buarohamu ë ioho ahoꞌobëhe rumorovo barëjade höjo. ");
INSERT INTO aom_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Ëhiꞌonugoromo Iesuro Jerusalem vaꞌiröhëni amo masijore amo ininore jöho röjëhibe vaꞌadeje. ");
INSERT INTO aom_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Vaꞌamu ae gemuëro uavadeje: Bada naehu jö ua gaꞌiëꞌajoho hejëjo. Na ae ma-gemu gemu ëhemu vuovoromo sisëroho bogo vaꞌi God-are öri ariꞌeroho vaꞌoromo maroho raromoꞌejarëjo. O diehi jioꞌaꞌajëjo. Diehi jioꞌaꞌajëjamu Iesuro ae ahoꞌobëhe uëvadeje: ");
INSERT INTO aom_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Sivohemu sivohoromo ojo harihoro rumo vaꞌo garëjo ëhuro ijonö God-are öri ariꞌere vaꞌirarije. Naro jemë uëvajëjo: Ae ahoꞌobëhe rumo vaꞌiëꞌiroho bogo eni jëvoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Röhu jemë ojo harihure bogo rumo vaꞌëꞌoho majae ijonö ë osa arijoꞌohuro riꞌöromo ojoho tugoho titimoꞌajëjo. Ojoho tugoho titimoꞌiramu jemëro amonö riravoromo aevoromo ojoho anoꞌanovoromo osa arijoꞌoho uaꞌaꞌarujëjo: Bada oje jiovahuego öꞌarëjo. Öꞌarëꞌiramu huro uëꞌaꞌajëjo: Jemë a rabëro rueruomoromo ojoho jiovëhojöro uvarujëjo. Ojoho na bogo jiovëhoꞌejöjo. ");
INSERT INTO aom_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Ojoho na bogo jiovëhoꞌejöꞌiramu jemëro uaꞌaꞌarujëjo: Röhu no ie jove jaꞌo gemu mae inövare höjo. Nosi amoroho jero jöho röjahuinövane höjo. ");
INSERT INTO aom_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Röjahuinövane höꞌiramu rue osa arijoꞌohuro uëꞌaꞌajëjo: Jemë a rabëro rueruomoromo ojoho jiovëhojöro uvarujëjo. Jemë mu sisë vaejaruje aribövie jëvaje roriꞌo vaꞌohëjo. ");
INSERT INTO aom_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Vaꞌohëꞌiramu jemëro gaꞌaꞌarujëjo jemesi hijo mionoꞌe Abraham Isaac Jacob o jö God-aro baeromo majëhinövare ae ahoꞌobëhe God-are öri ariꞌere ë raromoꞌi jemë babuꞌöjëvoꞌiramu gagorovo nierusuburuꞌe bamoromo ane jaꞌiho vuogigimoꞌarujëjo. ");
INSERT INTO aom_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Röhu maja rojomajire bevaꞌajire arua anumiae jioromo ae ahoꞌo God-are öri ariꞌere vaꞌoromo ie ueꞌahoruomoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Ueꞌahoꞌiramu a ioroꞌiore dejonö jiaruoho nuninö jioruomoꞌi a ioroꞌiore nuninö jiaruoho dejonö jioruomoꞌajëjo. Ëhuremu uehorovorëjo. ");
INSERT INTO aom_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Iesuro ëhi uëvamu gavëꞌi Pharisee ae göëro rueruomoromo uavareje: Riꞌöromo öre gö vaꞌëjo. Ave saꞌa muebejaje ae Herod-ro anagoꞌiëꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Anagoꞌiëꞌajëjamu hegorovo Iesuro uëvadeje: Herod hu sareriꞌe mu vaejaje ö sisëho vaꞌëne ae höjo. Vaꞌoromo hu uarëjo: Ave jöho hejëjo. Nörö hiromo Satan-are aruꞌaho sisë aribövi jabesi dëre jioꞌamajoho rarovöꞌöjëvobe a jabesi sinoho avohëvobe vaꞌojuvo evare nasi muoho barëꞌajëjo. Ëhi uarëjo. ");
INSERT INTO aom_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Röhu iae na ave saꞌaho vuonugoromo örire juvobe hibe vaꞌojuvo evare Jerusalem höröꞌejöjo nasi muoho ëhi jiëꞌëro. Ëhesi bëhoho jö God-aro baeromo majëhijarue ae ahoꞌobëhe ë amoremu muoꞌamamu vuovëvobe rovëꞌe höjo. Ëhuni naꞌo ë amore vaꞌiramu anegoꞌiramu guomoꞌejöjo. ");
INSERT INTO aom_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Vaevëꞌe Jerusalem amo rajohumë jemëro jö God-aro baeromo majëhijarue aribövioho muoꞌamaruje höjo. God-hu jemëni rëmöꞌöjaje aribövioho munëro vajëmijaruje höjo. Kököröko vëmehu harihu vivoju uhure nugoꞌamoromo diehehu aegëharuëhi naro jemë ëhi gagovëvoromo gemuore rëmoꞌi nimoꞌi hijode höjo röhu jemëro bijönimarije höjo. ");
INSERT INTO aom_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Ëhuni ave jöho hehëjo. God-ro jemesi amoho vuonugego jemesi sivue jëvoꞌiëꞌajëjo. Naro jemëꞌo hiromo vaꞌiramu jemë nasi nu anoꞌoho bogo gaꞌaꞌarujëjo hujeji na vuonoröꞌö rueꞌiramu evare avoho geromo ueꞌaꞌarujëjo: Bada God-are ihore rovanuoho mabëhe rovanuëjo. Ëhuremu uehorovorëjo. ");
INSERT INTO aom_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Iae Jew rajo jabesi nuho majaho rovamu Iesuro Pharisee a böröme gemu hesi osare ie iꞌi vaꞌadeje. Osare vaꞌamu gagorovo Pharisee ariböviohuro ë raromoromo Iesu gaꞌi muebejareje hu mu sisë o rabe ëꞌego. ");
INSERT INTO aom_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Röhu ë osare ae gemu hijëꞌe jiadeje. Hesi övo höruꞌe ahoꞌobëhe huoꞌamëꞌe jiadeje. ");
INSERT INTO aom_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Huoꞌamëꞌe jiamu gagorovo Iesuro riꞌöromo Jew rajo jögoru öri röjëhijarue ariböviohuꞌo Pharisee ariböviohuꞌo uëvadeje: Nuho majare a jabesi sino ajëmijëꞌoho na ëhuro no nosi jögoroho aharue höjo o bogajo. ");
INSERT INTO aom_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Bogajamu rueho jaburo jörumoraejareje. Jörumoraejamu Iesuro aho baeromo sinoho avohahoromo nugöꞌöjamu vaꞌadeje. ");
INSERT INTO aom_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Vaꞌamu gavëꞌi Iesuro uëvadeje: Nuho majare jemesi harihoho o mioho jovoꞌe guare bevaꞌibejajo na jemë burëro io barojomoꞌibejarijëjo o bogajo. Iae jemë ëhi ëꞌibejarijëjo. ");
INSERT INTO aom_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Ëhi ëꞌibejarijëjamu jö mana uaröhoho bogojëvadeje. ");
INSERT INTO aom_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Jöe bogojëvamu Iesuro gavade ë ruenugade ariböviohuro röho ma-mahemu baeromo raromamu gëgorovo uhuꞌe uëvadeje: ");
INSERT INTO aom_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","Aehu ja uavëꞌoho: Rueromo masuröhe sörö inë uavëꞌiroho nadi jasi sivuoho uehorovoromo vaꞌo a masijo raromaruiroho hinëjo. Ja ëhi ëꞌëꞌoho nani ae gö jasi iho iosiramijëꞌohuro söröre rueꞌaꞌajëjo sörö arijoꞌohuro mamiꞌe uavëꞌëro. ");
INSERT INTO aom_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Rovëꞌoho jaꞌo a börömohuꞌo ruejöro uëvade ahuro rueromo ja uaꞌaꞌajëjo: Röhe bojamego hu ë hijajo. Ëhi uavëꞌoho ja javoje baeromo roriꞌo vaꞌo hiꞌaꞌanuëjo. ");
INSERT INTO aom_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Aꞌi aehu ja sörö ro ijöro uavëꞌiroho vaꞌoromo ma-roriꞌo hinëjo. Ëhi ëꞌëꞌoho ro ijöro uavade ahuro rueromo uaꞌaꞌajëjo: Isio döro ajio hijëjo. Ajio hiꞌiramu gagorovo sörö ueꞌaharue ariböviohuro uehorovavoromo uvoꞌaꞌaruëjo: Ja a böröme javajëjo. ");
INSERT INTO aom_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Ëhesi bëhoho ae rahu hesi sivue uehorovoromo döre bamorovëꞌoho hesi ihoho abueꞌaꞌajëjo. O ae rahu baꞌobuerovëꞌoho hesi ihoho döro ajiomoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Ëruenugade aribövioho Iesuro ëhi uënugoromo huotorovoromo ro i ijöro uavade aho uavadeje: Jaehu i harihu majaꞌe o jeniꞌe bamoꞌiëꞌiroho nadi jasi aemoꞌaemoho ö muenoꞌoho bövi biseꞌo marohëꞌe mae jiëꞌe bëhire raromarue aribövioho nadi ëhi jiëꞌe ariböviohemuoho uëvego ro ioho ueꞌahoꞌirarëjo. Uëvëꞌoho jabumëro ijonö mana bojamiꞌiramu jasi suvuoroho bae barëꞌanuëjo. ");
INSERT INTO aom_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Aꞌi jaehu i bamoꞌiëꞌiroho bövi biseꞌo bogo eni jiëꞌe aribövioho övo höru sisëꞌe o nuni sisëꞌe aribövioho ëhi jiëꞌe aribövioho uëvego rueꞌirarëjo. ");
INSERT INTO aom_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Ëhi ëꞌëꞌoho ë ariböviehu mana bojamiꞌiröhoho bogo eni jëvëꞌëro ja huë mabëhe baeꞌaꞌanuëjo. Hujeji mu mae vaejarue aribövioho vuovëꞌëro iꞌovoromo riꞌöruomoꞌiramu evare God-ro jasi manaho bojamiꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Ëhi uavamu hegorovo Iesuꞌo raromoromo i iruomade ae gemuëro Iesu uavadeje: Ariböviehu riꞌöromo God-are öri ariꞌere vaꞌo raromoromo i ueꞌahoꞌiröhoho no huë mae baeꞌejarëjo. ");
INSERT INTO aom_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Huë mae baeꞌejarëjamu Iesuro uhuꞌe uavadeje: Iae ae gemuëro sörö böröme baeromo ae ahoꞌobëhe uëvade höjo: Rueromo söröe iꞌaꞌarujëjo. ");
INSERT INTO aom_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Ëhi ëꞌëꞌëro sörö majaho rovamu hesi mu vaejahaje aho nugöꞌöjamu sörö anue vaꞌoromo ae uëbe juvoromo uëvade höjo: Söröho eni jiajëjo. Evaro ruehëjo. ");
INSERT INTO aom_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Ëhi uëvamu hegorovo ae ahoꞌobëhe mae juahamare höjo. Ae göëro riꞌöromo uavade höjo: O asëꞌëjo. Na öꞌibejodoho röhu na saꞌae iꞌe imëꞌëro ë vaꞌoromo gaꞌejöjo. ");
INSERT INTO aom_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Ae göëro uavade höjo: O asëꞌëjo. Na öꞌibejodoho röhu na mu vaejaje mioho ahoꞌobëhe 10 imëꞌëro ëhuni ë vaꞌoromo gaꞌiëꞌajëjo gëꞌi mae ëꞌoruomego. ");
INSERT INTO aom_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Ae göëro uavade höjo: Na magonahe masuvëꞌe jevëꞌëro ëhuni bogo öꞌejöjo. ");
INSERT INTO aom_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Ëhiꞌamu rue ahuro vuonoröꞌö rueromo hesi a börömoho uavade höjo: Ëhi ëhi uevare höjo. Ëhi uevare höjamu rue osa arijoꞌohuro vöröꞌiraeromo hesi aho uavade höjo: Ma-burëro vaꞌiranoho amoꞌe öri masijoho ininoho ahoꞌobëhe juvo barënëjo. Juvo barëromo bogo eni jiëꞌe aribövioho sino sisërëjëꞌe aribövioho nuni sisëꞌe aribövioho höru sisëꞌe aribövioho ëhi jiëꞌe aribövioho ujuoho ruenëjo. ");
INSERT INTO aom_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Ëhi uavamu ejahoromo ëhi ëꞌëꞌëro jiëꞌëro rueromo hesi börömoho uavade höjo: Ja uevanëhi iae na ëhi ëꞌëꞌe jevajëjo. Röhu röhe iae jiajëjo. ");
INSERT INTO aom_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Röhe iae jiajëjamu rue börömohuro uavade höjo: Mu öroro jeꞌo öroro vaꞌiranoho dinëmiromo uëvego ae ahoꞌobëhe rueruomoꞌirajo ëhuro nasi osaho irijiomoꞌiröhe höjo. ");
INSERT INTO aom_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Na jemë ae ahoꞌobëhe uëvajëjo: Na urimo uëvamu juahemijare aribövioho nasi i söröꞌoho bogo iꞌaꞌaruëjo. Bogo mae bogajo. ");
INSERT INTO aom_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Iae ae magonahe ahoꞌobëhe siri vaꞌëne Iesuꞌo gemu mae örire jijihoruomonövadeje. Jijihojuvo Iesuro huotorovoromo uëvadeje: ");
INSERT INTO aom_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","Jemëhu nasiro rovëꞌoho jemesi vëmu vavuꞌe vabore aboji harihuꞌe öe maꞌine nadi ë aribövioho nuninöho bamoꞌi na dejonöho remorëjo. Röhu avehuꞌo gemuoho höjo. Jemëhu ave saꞌare raromoꞌirarijoho nadi ëho nuninöho bamoꞌi na dejonöho remorëjo. Jemëhu bövie biseꞌe göemu göemu nuninö bamëꞌoho nasi ijore ijoroho bogo jijihoꞌarujëjo. ");
INSERT INTO aom_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","O ae rahu ja bogo uvëꞌoho: Iesuare jöëni viꞌehe huë vavaene javoje rabe baeromo guomevëꞌoho iae hesi hö uvoromo bogo korosi hesi iꞌu banigojiomanovoromo nasi ijore ijore juvëꞌoho ja bogo nasi ijorajoho javoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Nasi ijore ijore jijihoꞌiëꞌiroho ëho mu böröme jiaje nadi ëma jijihoꞌi urimo uehorovo avohoromo evaro nasi ijore ijoroho jijihorëjo. Ëhesi bëhoho ae rahu ja javu ëgobövi vaeꞌiëꞌiroho bogo ëma vaeꞌi urimo saꞌaro hiromo javu vaeꞌirane monioho adaho gaꞌaꞌanuëjo gaꞌi vae barëꞌirane monioho eni jiego o bogo. ");
INSERT INTO aom_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Ja bogo adaho gavëꞌoho ëhuro nani saꞌahemu vaeromo gaꞌaꞌanuëjo monioho barëꞌiramu vituoho vuonugoꞌanuëjo. Vuonugoꞌiramu ae ahoꞌobëhe ëho garomo ja sivagoromo uvoruomoꞌajëjo: ");
INSERT INTO aom_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Ësareriꞌe aho javu ëgobövie vaeꞌiëꞌoromo bogo eni jiamu vituoho vuonugade höjo. ");
INSERT INTO aom_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","O uhu jö göho bëhe gemuoho höjo. Saꞌare a börömo göehu saꞌa a börömo göhuꞌo muorovoꞌiëꞌiroho hu bogo ëma muorovoꞌi urimo saꞌaro hiromo uehorovoromo uvoꞌaꞌajëjo: Rue a börömo göhuro muorovo ae ahoꞌobëhe 20,000 ae ahoꞌobëhe mae sö ujuoho rovajëjo. Na muorovo ae ahoꞌobëhe 10,000 ma-veminoꞌe ëhemu jevajëjo. Naehu huꞌo muorovëꞌoho na na eni jevoꞌajëjo o bogo eni jevoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Ëhi uvonugoromo uvëꞌoho: Bogo eni jevo hesi hö uvëꞌoho muorovoꞌi rovaje a börömoho bogo bëhiroho rovëꞌe evare ve hijaje a börömo göhuro hesi aho rëmöꞌöꞌiramu vaꞌoromo rue rovaje a börömo göho sanuamiromo jö mae majahiromo uaꞌaꞌaruëjo: No diehiꞌoromo muorovoho tugohoromo avoho raromoꞌejarëjo. ");
INSERT INTO aom_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Ëuhu jö hesi bëhoho jemëhu jemesi saꞌae inömo inöme bövie biseꞌe uehorovarujoho bogo vuonugëꞌoho bogo nasi ijorajo ömoꞌömoho jëvoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Nasi ijore ijore jijiharujoho jemë sö vaꞌëne jëvajëjo. Söho rihuꞌe mabëhe höjo. Röhu sö hesi rihu barëjëꞌoho röhu bogo maho avoho hesi höjo. ");
INSERT INTO aom_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Ëhuꞌëro ë hesi muoho bogohöjo. Bogo muroho ruruhöꞌöjego muoho rihuvoꞌi bogo mi dëhuꞌo buarohoromo bahijego muoho marëꞌi aꞌi ëhi jiëꞌe söho ma-ruruhöꞌöjarue höjo. Ae rahu ja God-are jö hejanue ae javëꞌoho bëhoho nahoromo birohonëjo. ");
INSERT INTO aom_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Iae vajiohuꞌe tax baejarue ariböviohuꞌo sisë aribövi ioroꞌiorohuꞌo ëho jaburo Iesuare jöho heꞌi rueruomadeje. ");
INSERT INTO aom_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Rovamu gagorovo Pharisee ariböviohuꞌo Jew rajo jögoru öri röjëhijarue ariböviohuꞌo uarovareje: Ësareriꞌe ahuro sisë aribövioho rajëhiromo jabuꞌo gemuoro ie ijaje höjo. ");
INSERT INTO aom_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Ijaje höjamu Iesuro uhuꞌe uëvadeje: ");
INSERT INTO aom_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","Jemë ae gemu sheep ahoꞌobëhe 100 javoꞌi gemu subiröꞌöjëꞌoho ja diehiꞌonëjo. Ja sheep ioroꞌiore mure raromaruoho ëhi nugoꞌamoꞌi vaꞌoromo ë sheep gemuꞌoho nahobe juvojuvo hujeji vae göro birohoꞌanuëjo. ");
INSERT INTO aom_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Birohonugoromo nimorohëꞌi babuariromo amëro rueꞌaꞌanuëjo. ");
INSERT INTO aom_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Rueromo jasi amo rajoho aganoho uëꞌaꞌanuëjo: Nasi sheep subiröꞌöjadoho iae birohëꞌe jevajëjo. Ëhuni ruehego no gemuoro nimoroharëjo. ");
INSERT INTO aom_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Ëhesi bëhoho naro uëꞌiëꞌajëjo. Öꞌidöre raromarue ariböviohuro gavarue ae gemu öri sisëre juvajoho vuonugoꞌi huotorovoromo öri mare juvamu gavëꞌoho nimoroho avoharue höjo. O gavarue ae ahoꞌobëhe jabesi sivue uehorovoromo uvamu: No mae javuëꞌëro ëhuꞌëro mu sisë vuonugoꞌiröhoho bogojavuajë uvamu gëvëꞌoho bogo ëhioho nimoroharue höjo. ");
INSERT INTO aom_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","O uhu jö göho hehëjo. Magonahe gemu ajivëꞌe ijo baje ahoꞌobëhe 10 jiajoho gemu subiröꞌöjëꞌoho hu diehi ëꞌaꞌajëjo. Iroho buenugoromo ari sisuoho bibivëꞌi ma-avoho nahobe juvoromo hujeji vae göro birohoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Birohonugoromo hesi amo rajoho aganoho uëꞌaꞌajëjo: Subiröꞌöjade ijo bajoho birohëꞌe jevaje ëhuni ruehego no gemuoro nimoroharëjo. ");
INSERT INTO aom_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Ëhesi bëhoho na uëꞌiëꞌajëjo. God-are anerahuro gavarue ae gemu öri sisëre juvajoho vuonugoꞌi huotorovoromo öri mare juvamu gavëꞌoho nimoroharue höjo. ");
INSERT INTO aom_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Ëhi uënugoromo Iesuro uhu jöe göꞌo majëhiromo uëvadeje: Iae ae gemu harihe niöꞌi jëvade höjo. ");
INSERT INTO aom_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Harihe niöꞌi jëvëꞌëro ijorajohuro riꞌöromo vavuoho uavade höjo: Apo ja guomavego naehu ujuohoꞌirodego uevane bövioho biseꞌoho avevejöꞌe bojemëjo. Bojemijëjamu rue vavuohuro hesi bövioho biseꞌoho adovoromo harihu göho ioni göho bojamiꞌi harihu göho ioni göho bojamijade höjo. ");
INSERT INTO aom_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Bojamamu majae ma-gemu niöꞌi barëjamu rue ijorajohuro huhu ujuohadoho imoꞌamo barëromo monioho baeromo vaꞌade höjo. Vaꞌadoho vaꞌojuvo öri ëgoböviro saꞌa göro vaꞌoromo nimoronimorohëꞌi hiromo hesi maho sisëho ma-buꞌönövade höjo. ");
INSERT INTO aom_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Ëhi buꞌöbe vaꞌamu hesi bövioho biseꞌoho barëjahade höjo. Barëjahamu ë saꞌare irunoꞌoho ahoꞌo barëromo ë saꞌare aribövioho vadunëro vuovamu ë aho huë vavaene böröme baejëꞌe hijade höjo. ");
INSERT INTO aom_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Ëhi hiromo vaꞌoromo ë saꞌaho raje ae gemu uavade höjo: Ja mue javëꞌoho uevego na ë jasiro mue vaejöjo. Mue vaejöjamu ruehuro uavade höjo: Mahu muohuro vaꞌoromo mahe mioꞌamonëjo. ");
INSERT INTO aom_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Mahe mioꞌamonëjamu ë Jew rajehu sisë hö uvarue muoho baeromo vaꞌoromo mahoho mueberomo hömamu uvade höjo: Raro mahu ioho babojemego na ijego daꞌuegoꞌirajo. Ëhi uvade höjo röhu a vaduꞌoho ioho bogo bojamare höjo. ");
INSERT INTO aom_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Bogo bojamamu hiromo ijonö avoho uehorovoromo uvade höjo: O apare mu aribövioho ie ahoꞌobëhe jëvëꞌëro i barëꞌiröhoho bogo eni jëvajëjo. Na aviae harihoho jevajëjo röhu vadunëro guomevoꞌiëꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Ëhuni naro riꞌöromo aparo vaꞌoromo uaꞌejöjo: Apo naehu God-are örire jasi örire huë vavaeni bojëmodoho ëho naro mu sisë vaejëꞌe jevajëjo. ");
INSERT INTO aom_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Na a sisë jevëꞌego ëhuni ja bogo na harihoho ueꞌaꞌanuëjo. Aꞌi jasi muoro bamevego na muoho vaejahoromo manaho baeꞌiröjo. ");
INSERT INTO aom_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Ëijorajohuro ëhi uvonugoromo riꞌöromo hesi vavuehu hijajire vaꞌi vaꞌade höjo. Vaꞌi vaꞌamu vavuohuro gavade höjo arue riribövire hesi harihoho rovamu. Ganugoromo vavaenimoromo tutuvo vaꞌoromo guduamoromo dudöhade höjo. ");
INSERT INTO aom_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Dudöhamu rue harihohuro uavade höjo: Apo naehu God-are örire jasi örire huë vavaeni bojëmodoho ëho naro mu sisë vaejëꞌe jevajëjo. Na a sisë jevëꞌego ëhuni ja bogo na harihoho ueꞌaꞌanuëjo. ");
INSERT INTO aom_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Ëhi uavamu hejëꞌi rue vavuohuro harihoho bogo ejahoꞌi hesi mu vaejaharue aribövioho uëvade höjo: Ma-burëro vaꞌoromo niögu maho jaegoho höru guduoho ëhi jueꞌini ujuohaho rueromo sinoro övo gaenoro höroro ioꞌamahohëjo. ");
INSERT INTO aom_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Jemëhu ma-je i muoharuje sanuovëꞌe mioho baro anohego no i söröꞌe iromo nimoronimoroharëjo. ");
INSERT INTO aom_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Urimoho naro uvode höjo: Nani nasi harihoho guomëꞌe höjo. Nani diehi ëꞌëꞌe höjo. Avevejöꞌoho na gavajoho hu iae hijajëjo. Urimoho öri ariꞌe göro subiröꞌöjade höjo. Avevejöꞌoho iae birohëꞌe jevajëjo. Ëhuni ëꞌego no nimoroharëjo. Ëhi uëvëꞌëro söröe iromo nimoro nimore bamare höjo. ");
INSERT INTO aom_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Ëhiꞌamu gavëꞌi iae muriohuro muro hijade höjo. Muro hiromo amo bëhire rueꞌi hejade höjo javavoꞌego jajoho hëgöho rovavamu. ");
INSERT INTO aom_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Jajoho hëgöho rovavamu hegorovo mu vaejarue ae gemuëro ruejöro uaromo rovamu uavade höjo: Rabëni ëꞌaruëjo. ");
INSERT INTO aom_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Rabëni ëꞌaruëjamu ruehuro uavade höjo: Jasi ijorajohuro rovamu jasi vavuohuro gavade hesi harihoho raboho raboho bogo ëꞌëꞌe hesi örire ma-mae rovamu gagoro ma-je i muoharue sanuovëꞌe mioho huni anahade höjo. ");
INSERT INTO aom_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Anade höjamu rue muriohuro dë vörönimamu osare vaꞌiröhoho bijönimade höjo. Bijönimamu vavuohuro amonö hörö rueromo uavade höjo: Nadi juahovoꞌi osaëro rueromo ioho ma-ijëjo. ");
INSERT INTO aom_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Ijëjamu rue muriohuro uavade höjo: Aveho hejëjo. Jasi jöho na bogo gemu vaduꞌoho ahahoꞌi vadune vadune na jasi muohemu vaejahobe rovëꞌe jevajëjo. Iae ëhi höjo röhu mi mae o mi sisë ëhuꞌo bogo bojemijane höjo ëhuro naehu nasi aemoꞌaemohuꞌo iromo nimorohoꞌirodoho. Bogo mae bogajo. ");
INSERT INTO aom_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Nasi öriroho bogo bojemiꞌi jasi harihoho magonaho sisëho gaꞌamoromo ëhuro jasi maho sisëho i barëjëꞌëro rovamu gavëꞌi jero sanuovëꞌe mi mabëhoho anoromo hesi örire bojamane höjo. ");
INSERT INTO aom_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Bojamane höjamu rue vavuohuro uavade höjo: Jueꞌi ja majae ëhi naꞌo gemu mae hijanue höjo. Nasi saꞌae are inömo inöme ie bövie biseꞌe ahoꞌo ma-jasiremu höjo. ");
INSERT INTO aom_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Ëhi höjo röhu urimoho naro uvode höjo: Nani jasi ijorajoho guomëꞌe höjo. Nani diehi ëꞌëꞌe höjo. Avevejöꞌoho na gavajoho hu iae hijajëjo. Urimoho öri ariꞌe göro subiröꞌöjade höjo. Avevejöꞌoho iae birohëꞌe jevajëjo. Ëhuni noehu huë mae baeromo nimoronimorohëꞌoho iae mae höjo. ");
INSERT INTO aom_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Iae Iesuro hesi ijorajo ömoꞌömoho uhuꞌe uëvadeje: Iae moni marohëꞌe jiëꞌe ahuꞌo hesi mu muebejahaje ahuꞌo jaburo niöꞌiro arijare höjo. Ariromo eni jiëꞌe ahuro hejade höjo uavamu: Jasi mu vaejahaje ahuro jasi inömo inömoho ma-buꞌöjahaje höjo. ");
INSERT INTO aom_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Ma-buꞌöjahaje höjamu hegorovo ë iahuni uvoromo rovamu uavade höjo: Jaehu ëꞌanuoho na hejëꞌe jevajëjo. Nasi mu muebejanuoho vuonugoꞌanuëjo. Ëhuni nasi mu suri surioho ujuoho ro memego na gavöjo ja nasi mu diehi muebejanoho. ");
INSERT INTO aom_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Ëhi uavamu rue mu muebejaje ahuro uehorovoromo uvade höjo: Nasi a börömohuro uevajëjo naro muoho vuonugojöro. Ëhuni na diehiꞌoꞌejöjo. Saꞌa umoromo o ëhi jiëꞌe iꞌuꞌe mu gö vaeꞌirodoho darugoho bogo eni jevajëjo. Ae gö jabesi örire ëninëmiꞌirodoho na javojegajëjo. ");
INSERT INTO aom_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","O iae na uehorovajëjo. Na ae ajëmiromo ëhi ëꞌejöjo ëhuro nasi börömohuro remöꞌöjego na vaꞌego jabumë ae göëro göëro ueruomoröhego: Nasi osaro rovëjo. ");
INSERT INTO aom_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Ëhi uvonugoromo ae rahu rahu inömo inöme rabe rabe hesi a börömo bojamiꞌiröhohuni jöe nugöꞌöromo uëvade höjo ae gemu gemu ruejöro. Urimore ahuro rovamu mu vaejaje ahuro uavade höjo: Nasi a börömo hesi örire mana bojamiꞌiranoho diminoꞌe javajëjo. ");
INSERT INTO aom_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Diminoꞌe javajëjamu uavade höjo: Jovoꞌe rama masije ahoꞌobëhe 100 bojamiꞌirodoho jevajëjo. Bojamiꞌirodoho jevajëjamu uavade höjo: Ja diminoꞌe bojamiꞌirane jöho jiëꞌe jiaje ave suroho baejëjo. Baeromo ma-burëro saꞌaro hiromo ramae 100 bojamiꞌirane jöho muꞌuꞌi baꞌobueromo ramae ahoꞌobëhe 50 bojamiꞌiranoho jajivëjo. ");
INSERT INTO aom_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Ëhi ëꞌëꞌëro ae göëro rovamu mu vaejaje ahuro uavade höjo: Jaꞌo bojamiꞌiranoho diminoꞌe javajëjo. Diminoꞌe javajëjamu uavade höjo: I esöe ahoꞌobëhe 100 bojamiꞌirodoho jevajëjo. Jevajëjamu uavade höjo: Ja bojamiꞌirane jöho jiëꞌe jiaje ave suroho baeromo esöe 100 bojamiꞌirane jöho muꞌuꞌi baꞌobueromo esöe ahoꞌobëhe 80 bojamiꞌiranoho jajivëjo. Ëhiꞌobe vaꞌade höjo. ");
INSERT INTO aom_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Ëhi ëꞌade jöho hejëꞌëro a börömohuro hesi mu sisëꞌi muebejaje aho uavade höjo: Ja uehoro mabëhe mae rovavamu ëho ëꞌane höjo. Ëhi rajahijade hesi bëhoho ave saꞌa hesi muohemu uehorovarue ariböviohuro uehoro mabëhe birohoromo jabesi muoho vaeruomaje höjo. Aꞌi God-are ajiꞌe mu uehorovarue ariböviohuro simane sisëꞌi sisëꞌi uehorovoromo muoho vaeruomaje höjo. ");
INSERT INTO aom_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Ëhesi bëhoho na uëꞌejöjo. Jemëro ave saꞌa hesi monioho baeromo ëhuro mu mae vaeromo jemesi agane baejëvorëjo. Ëhi ëꞌëꞌoho ëhuro vuovëvoꞌiramu moni hesi bëhoho barëꞌiramu God-ro uëꞌaꞌajëjo: Nasi amoro rueromo ma-ioroꞌioremu raromohëjo. ");
INSERT INTO aom_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Ae rahu mu inino avoho muebejëꞌohuro mu masijohuꞌo avoho mueberuomoꞌajëjo. Ae rahu mu inino sisëꞌi muebejëꞌohuro mu masijohuꞌo sisëꞌi mueberuomoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Ëhuni jemë ave saꞌa hesi inömo sisëꞌi muebejëꞌoho God rabëni öꞌidö hesi inömo maho bojëmiꞌajëjo jemëro muebejöro. ");
INSERT INTO aom_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","O jemëhu ae gö hesi bövi biseꞌo bogo avoho muebejahëꞌoho God rabëni bövioho biseꞌoho iꞌimëmiꞌajëjo jemesi ujuohojöro. ");
INSERT INTO aom_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Ae niöꞌi börömoho gemuoho jëvajëromo jabesi mu gemuore havoromo vaejëꞌoho bogo eni javoꞌajëjo. Ja göho nue huodivoꞌi göho rajahiꞌanuëjo. O göho mae uehorovoꞌi göho bijönimoꞌanuëjo. Ëhesi bëhoho Godꞌo moniꞌo niöꞌi börömoho gemuoho jëvajëromo gemuore havoromo mu vaejëꞌoho bogo eni javoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Iesuro ëhi uëvamu hejëꞌi Pharisee ariböviohuro moniemu uehorovoruomëꞌëro Iesu sivareje. ");
INSERT INTO aom_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Sivamu hegorovo Iesuro uëvadeje: Jemë ma-döëremu mu maho vaejaruje höjo aëro jemë gëromo uvojöro: Ëaribövioho mu mae vaeruomaje aribövie jioruomajëjo. Röhu jemesi dë vövöbajoꞌoho diehi jiajoho God iae gë barëjaje höjo. Huhu jemesi dë vövöbajoꞌo gëvëꞌoho aehu gëvaruëhioho hu bogo ëhioho gëvaje höjo. Ëhesi bëhoho aehu sarerivoromo uvarujoho: Mabëhe hö uvarujoho God-hu gavajoho sisë bëhe höjo. ");
INSERT INTO aom_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Urimëꞌi Moses-hu surire jajivade jögorohuꞌo jö God-aro baeromo majëhinövare a ioroꞌioro jabesi surire jöhuꞌo aehu hebe rovaroho evare John rovade höjo. John rovamu evare God-hu böröme namiromo ae ahoꞌobëhe muebejëvaje ë hesi huë ma jöho aevoromo rovëꞌe höjo. Aevoromo rovëꞌego ae ahoꞌobëhe daruge ahoꞌo bojamirovoromo biririvoromo öroho jiovoruomaje höjo ëhuro God-ro muebejëvego hesi aharinö jëvoröhego. ");
INSERT INTO aom_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Ëhi jiëꞌe mu iꞌoho rovëꞌe höjo röhu God-hu urimo bojëmade jögoroho bogo barë hesi höjo. Öꞌidöꞌo saꞌaꞌo sisërëjëꞌoho ëho samae höjo. Aꞌi God-are jögoroho gö bogo bisemu vaduꞌoho sisërë hesi höjo. ");
INSERT INTO aom_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Röhu jö göhajo. Baruehu vaboro nugöꞌöꞌi gö masuvëꞌoho ëho bogo masuvëꞌe muoho jioꞌi gohoꞌamarue muoho höjo. O aehu nugöꞌöjëꞌe magonaho masuvëꞌoho bogo hesi vaboro maho masuꞌi ëho gohoꞌamarue muoho höjo. ");
INSERT INTO aom_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Iae ae gemuëro hijade höjo. Hesi inömo inöme are saꞌae bövie mae jiade höjo. Niöge sanuovëꞌe kavuëꞌe mabëhe ioꞌamonövade höjo. Irunoꞌe ahoꞌobëhe sörönöꞌe iromo nimoronimorohonövade höjo. Majae ahoꞌo ëhi gemu ëhiꞌobe rovade höjo. ");
INSERT INTO aom_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Ëhiꞌego inömoꞌe a hesi ojanore bövi biseꞌo bogojiëꞌe ahuro ë raromonövade höjo. A ihoho Lazarus jiade höjo. Lazarus-are sino hahoꞌoho ma-sagohemu jiëꞌe jiade höjo. ");
INSERT INTO aom_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Sagohemu jioꞌego Lazarus-ro nimonövade höjo eni jiëꞌe a hesi i vitu vituoho iꞌirovo ëhuro daꞌuomojöro. Röhu vaevëꞌoho öëro rueruomoromo hesi sagohoho sëhahonövare höjo. ");
INSERT INTO aom_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Ëhiꞌojuvo iae ë bövi biseꞌo bogojiëꞌe aho guomade höjo. Guomamu aneraëro hesi aruꞌahoho bavaꞌamu nosi bëhe Abraham-are guruto mare avoho hijade höjo. Hijamu ë eni jiëꞌe ahuꞌo guomade höjo. Guomamu guavare höjo. ");
INSERT INTO aom_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Guavamu vuovarue ariböviehu raromaruire vaꞌo hijade höjo. Hiromo viꞌehi sisë bëhe baejëꞌëro nunëro ga avohoꞌi gavade höjo Abraham arue riribövire hiꞌi Lazarus Abraham-are guruto mare hijamu. ");
INSERT INTO aom_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Ëhi gënugoromo ma-darugoꞌo uvade höjo: Saso Abraham-ajo. Nani vavaenimoromo Lazarus nugöꞌöjego huro hesi övo namoho jovore baꞌamoromo rueromo nasi bitaroho rëhoromo sanuovehoꞌirajo. Na vëniro jevëꞌëro sisë maro viꞌehegavajëjo. ");
INSERT INTO aom_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Viꞌehegajëjamu Abraham-ro riꞌöromo uavade höjo: Sasajo. Aveho uehorovëjo. Saꞌare hijëꞌi ja huë ma-mabëhe birohane höjo. Lazarus hu hijëꞌi ma-huë sisëmu birohade höjo. Röhu jaruvoho Lazarus-ro sanue baeromo hijajëjo. Jero viꞌehi böröme baeromo hijanuëjo. ");
INSERT INTO aom_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Röhu jö göho ëhuꞌo hejëjo. No aviae javuoꞌi jemë aruae jëvajëjo. Röhu ririre hahe guoröte jiëꞌëro ëhuro ave jioromo jemesirire öꞌëꞌoho bogo eni jioꞌi jemesirire jioromo ave rovëꞌoho bogo eni jiajëjo. ");
INSERT INTO aom_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Bogo eni jiajëjamu uavade höjo: Saso ëhi jiëꞌoho huë baejevoromo Lazarus nugöꞌöjego huro nasi aganehu raromaruire vaꞌajo. ");
INSERT INTO aom_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Na öe ahoꞌobëhe övo gö mine jevëꞌe jiaje uavego Lazarus-ro vaꞌoromo nasi ö ömoꞌömoho jögore majëhiꞌirajo ëhuro ave vöröꞌeroho bogo rueruomoröhe höjo. ");
INSERT INTO aom_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Ëhi uavamu Abraham-ro uavade höjo: Röhu jasi ö ömoꞌömoho Moses-are surire jöho mamiꞌe gavarue höjo. Jö God-aro baeromo majëhinövare a ioroꞌioro jabesi surire jöhuꞌo gavarue höjo. Ëhuni nadiꞌego jabumëro jabesi jöho ejëhoꞌirarëjo. ");
INSERT INTO aom_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Ejëhoꞌirarëjamu uavade höjo: Saso Abraham iae ëhi höjo. Röhu surire jöho bogo eruomoꞌajëjo. Aꞌi vuovoromo ave ro raromajire aehu ë jioromo riꞌö vaꞌoromo jö majëhijamu hejëꞌiroho iae jabu huotorovoromo mae uehorovoꞌaruëjo. ");
INSERT INTO aom_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Mae uehorovoꞌaruëjamu Abraham-ro uavade höjo: Bogo ëhioho jioꞌaꞌajëjo. Jasi ö ömoꞌömoho Moses-are surire jöho bogo ejaharue höjo. Jö God-aro baeromo majëhinövare a ioroꞌioro jabesi surire jöho bogo ejëharue höjo. Jabesi jöho bogo ejëhobe rovëꞌëro heꞌiröhe ae gö guomoromo riꞌöromo jö majëhijamu hejëꞌoho hesi jöhuꞌo bogo ma uehorovoꞌaruëjo. ");
INSERT INTO aom_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Ëhiꞌoromo Iesuro hesi ijorajo ömoꞌömoho uëvadeje: Göehu gö bijioho gavego sisë vaeröhe muoho iae ruenövoꞌajëjo. Iae ëhi jioꞌaꞌajëjo röhu ae rahu ë mu barovëꞌoho vaevëꞌoho sisërëꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Asisöꞌonöꞌe jörume raromarue ae gemu mu sisë röjahijamu bejëꞌoho mu sisë bogo röjahijajevare ë mu sisë röjahijaje a hesi sönöꞌahore aëro iꞌuꞌe munë hitahiohuro tövoromo sö jovore baꞌamego eꞌure bevaꞌoromo guomoꞌibejajo ëho ma-jianovoꞌibejajo. Aꞌi ë mu sisë röjahiꞌiröhe ë hesi iꞌuoho börömo bëhe baeꞌaꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Ëhuni avoꞌavoho mueberovorëjo. Jasi öehu jasi örire sisë vaejavëꞌoho ahonëjo. Ahamu huhu huotorovoromo uehoro mae baejëꞌoho ëhuro jero hesi sisëho uehorovoromo vuonugonëjo. ");
INSERT INTO aom_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","O majae gemu röhu mu sisë göꞌo göꞌo vae 7 vaejavoꞌi hiromo röhu vae 7 ro uaꞌi hijëꞌoho: Iae naro mu sisëho vaejëꞌëro jevëꞌëro vuonugoꞌejö uaꞌi hijëꞌoho jero uehorovoromo vuonugahoꞌi hinëjo. ");
INSERT INTO aom_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Ëhi uëvamu Iesuare apostle ömoꞌömohuro riꞌöromo Bada uavareje: Iae no jasi darugoho ma-bisemu mae uehorovarue höjo. Röhu jero ajamuego no mae uehorovo avohoꞌirarëjo. ");
INSERT INTO aom_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Mae uehorovo avohoꞌirarëjamu huro uhuꞌe uëvadeje: Mustard bajoho inino mae jioꞌamajëjo. Mustard baje gemu ma-biseꞌo jiajëhi ëhi uehoro mae ma-bisemu baeromo God mae uehorovoꞌibejarijëjo ave namijaje ijo börömoho uaꞌibejarijëjo: Jasi jahorovëjo. Jahorovoromo vaꞌoromo sö jovohuro jasi baꞌamorovë uaꞌibejarijëjo ë ijohuro jemë ejëhoꞌibejajo. Mae uehorovoꞌibejarijëjo ëhi jiëꞌe muoho vaeꞌibejarijëjo. ");
INSERT INTO aom_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Röhu jö göho jemë nasi jö hejaruje aribövioho nani ja ae gemu jasi muemu vaejaje ae javajëjo. Nani huro jasi muro hiromo saꞌaho avohahoꞌajëjo o ö mahuꞌoho muebejahoꞌajëjo. Mu vaeromo rovëꞌoho na ja hu uanëjo: Ro hiromo ie ijëjo. Ja bogo ëhi jiëꞌe jöho uaꞌi ");
INSERT INTO aom_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","aꞌi uaꞌaꞌanuëjo: Nasi ioho avohehoromo jasi niögoho avoho ruohoromo ro ioho jovoho iꞌimemego na iꞌiröjo. Na ijego evaro jaꞌo inëjo. ");
INSERT INTO aom_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Jaehu mu jö ëhi bojamamu hu ejahoromo mu vaejëꞌoho na ja uanëjo: Mabëhe huë baejevoromo ajemijane höjo. Bogo ëhioho uaꞌaꞌanuëjo hu jasi muemu vaejajego. ");
INSERT INTO aom_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Ëuhu jö hesi bëhoho jemë God-are muemu vaejaruje aribövie jëvajëjo. God-hu jemë bojëmaje mu jemë vae barëjëꞌiroho uvorëjo: No mu aribövi sisë sisë javuajëjo. Ëho nosi muego ëꞌare höjo. ");
INSERT INTO aom_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Iae Iesuro Jerusalem amore vaꞌëꞌi vaꞌëꞌi Galilee saꞌa vituohuꞌo Samaria saꞌa vituohuꞌo birorohadinö ëhunö vaꞌadeje. ");
INSERT INTO aom_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Vaꞌoromo ë diröꞌore amore höröꞌiaꞌamu gavëꞌi sino jomoꞌe ae ahoꞌobëhe 10 rueromo roriꞌo riravareje. ");
INSERT INTO aom_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Riravoromo ma-darugoꞌo uvoruomadeje: Iesuajo. Badajo. Noni vavaenimoromo ajamuijëjo. ");
INSERT INTO aom_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Ajamuijëjamu Iesuro gëromo uëvadeje: De vaꞌirarijoho arue priest ömoꞌömoho röjëhirego jabumëro morijëgo gëꞌirarëjo. Morijëgo gëꞌirarëjamu örire vaꞌamu gavëꞌi marëjëvadeje. ");
INSERT INTO aom_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Marëjëvamu gagorovo ae gemuëro vuonoröꞌöromo ma-darugoꞌo God mabëhe uabe rovadeje. ");
INSERT INTO aom_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Rueromo Iesuare höru bëhire ague aho hiromo rajahijadeje. Röhu ë aho bogo Jew rajehu jioꞌi Samaria raje jiadeje. ");
INSERT INTO aom_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Rovamu gagorovo Iesuro uavadeje: Jomoꞌe ae ahoꞌobëhe 10 marëjëvade höjo. Na mae-ëjo. Röhu a ioroꞌiore 9-ho diehiꞌoromo bogo rovare höjo. ");
INSERT INTO aom_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Diehiꞌoromo nosi Jew rajoho bogo rueruomoꞌi ave saꞌa gö rajohuremu God mae uaꞌi vuonoröꞌö rovade höjo. ");
INSERT INTO aom_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Ëhi uanugoromo ë Samaria rajoho uavadeje: Riꞌö vaꞌëjo. Jero God mae uehorovamu ëhuro marëjavëꞌe höjo. ");
INSERT INTO aom_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Ëhiꞌamu Pharisee a ioroꞌiorëro riꞌöromo Iesu uavareje: God divare aevoromo böröme namiromo muebejavuoꞌiramu no hesi ahariremu raromoꞌejarëjo. Raromoꞌejarëjamu Iesuro uëvadeje: God-hu böröme namiromo ahoꞌobëhe muebejëvajoho vöröꞌe muoho jemesi nunoho bogo garomo uvoꞌaꞌarujëjo: God-ro aevoromo muebejavuoꞌego no hesi ahariremu raromaruëjo. ");
INSERT INTO aom_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","O ja bogo aho uëꞌaꞌanuëjo: Aveho gahëjo. God-ro ave diröꞌoremu böröme namiromo muebejavuajëjo. O arueho gahëjo. God-ro ë diröꞌoremu böröme namiromo muebejëvajëjo. Bogo ëhioho uëꞌaꞌanuëjo ë hesi bëhoho God-ro jemesirire böröme namiromo muebejëvajëro jiëꞌëro. ");
INSERT INTO aom_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Ëhi uënugoromo hesi ijorajo ömoꞌömoho uëvadeje: Majae ijonö jemëro God-are A Maho geꞌi nimo avohoromo uvoꞌaꞌarujëjo: Majae ëgobövie bogo gavëꞌëro nörö majae ma-bisemu gaꞌibejarëjo mae javuoꞌibejajo. Röhu bogo geꞌaꞌarujëjo. ");
INSERT INTO aom_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Bogo geꞌiramu aëro jemë sarerëmiromo uëꞌaꞌaruëjo: Gahëjo. Nörö aruae höjo. O nörö aviae höjo. Ëhi uëvëꞌoho nadi ejëhoromo geꞌi jabuꞌoho vaꞌorëjo. ");
INSERT INTO aom_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Ëhesi bëhoho naehu rueꞌirode majaho rueꞌiramu na bogo diröꞌe gemuoroho ro hiꞌi aꞌi baderehu öꞌidöre baderivoromo öꞌidöe ahoꞌo ajivo barëjego ae ahoꞌobëhe ga barëjaruëhi God-are A Maho naro ëhi rueꞌiramu geꞌaꞌarujëjo. ");
INSERT INTO aom_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Iae ëhi jioꞌaꞌajëjo röhu urimoho na viꞌehe huë vavaene bövie biseꞌe baeꞌejöjo. Ave jaruvore raromarue ariböviohuro na bijönegoruomoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Röhu God-are A Ma naehu a nunire rueꞌiëꞌiroho a mami ae Noah-hu hijade majare jiadëhi ëhi gemuoho jioꞌaꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Noah hijadevare evare aëro ie jove ueꞌahobe masurovobe ëhi jiëꞌe muohemu uehorovobe vaꞌojuvo evare Noah-mëro boat börömore rumo vaꞌamu gavëꞌi jovo börömëro rojomoromo a ioroꞌioroho baeniagëgamu vuovo barë nahonahovade höjo. ");
INSERT INTO aom_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","O a mami ae Lot-hu hijade majare jiadëhi God-are A Ma naehu a nunire rueꞌiëꞌiroho ëhi gemuoho jioꞌaꞌajëjo. Lot hijade majare evare ae ahoꞌobëhe ie jove ueꞌahobe bövie biseꞌe imobe iꞌo muꞌe vaebe javue vaebe ëhi jiëꞌe muohemu uehorovobe vaꞌojuvo ");
INSERT INTO aom_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","evare Lot-ro Sodom amore jioromo mae vaꞌamu gavëꞌi vënëro girosijiomëꞌe munëhuro rireromo ruvebiromo a ioroꞌioroho bijuëmamu vuovo barë nahonahovade höjo. ");
INSERT INTO aom_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","God-are A Ma naehu rueꞌiëꞌiroho aëro ëhi gemuoho ëꞌobe vaꞌojuvo evare ë majaho ma-majioho rueꞌaꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Ëmaja rovëꞌoho ae rahu javu dönö haradare raromoꞌi jabesi inömo inömo osanö jiëꞌoho nadi inömoho ujuohoꞌi abo osaroho rumo vaꞌi o mure raromëꞌoho jabuꞌo nadi inömoho ujuohoꞌi uehorovoromo vuonoröꞌö rueꞌi ma-huruomoꞌirarëjo. ");
INSERT INTO aom_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Lot-are vaborehu hesi inömo uehorovoromo vuonoröꞌöꞌiaꞌamu iꞌuehu hesi örire rovade jöho avoho uehorovorëjo. ");
INSERT INTO aom_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Ae rahu hesi sinohuni uehorovoromo biririvoromo ave saꞌare hiꞌi ëhemu uehorovëꞌoho vuovo öriro vaꞌaꞌajëjo. O ae rahu hesi sinëni bogo uehorovoꞌi nasi jöhuremu uehorovoromo ma-guomorovëꞌoho ë ahuro maro hiemu hiꞌaꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Röhu na avehuꞌo uëvajëjo. Naehu rueꞌirode vahire evare ae niöꞌiro röhe gemuore dirohoꞌaruëjo. Dirohoꞌiramu God-ro göho baeꞌi göho ë vuonugoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Magonahe niöꞌiro gemuoro ariromo ioho saꞌijovoromo avohoꞌiramu God-ro göho baeꞌi göho ë vuonugoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Ae niöꞌiro mure ariꞌiramu God-ro göho baeꞌi göho ë vuonugoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Ëhi uëvamu rue ijorajo ömoꞌömohuro uavareje: Bada ja di öri ariꞌere vuonoröꞌö ruenëjo. Ruenëjamu uhuꞌe uëvadeje: Sagohe dinöꞌe jiajire ë ugoho gagovoruomoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Iae Iesuro uhu jöe gö majëhijadeje aëro heromo uvoröhego: No bogo uꞌuhoꞌi biririvoromo parie vaeꞌi ariꞌejarëjo. ");
INSERT INTO aom_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Majëhiromo uëvadeje: Iae ae gemuëro hijade höjo. Hu jö heromo mevaje a böröme jiade höjo. Hu God bogo ma uehorovoromo a jabesi örirohuꞌo bogo ma uehorovonövade höjo. ");
INSERT INTO aom_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Hu bogo mae uehorovëꞌe ae jioꞌi röhu magonaho doruëro ë ame gemuore hijade höjo. Hiromo ë jö mevaje a hesi örire rueromo uaꞌi hinövade höjo: Ajemego sisë vaejevaje aho iosiramiꞌiröjo. ");
INSERT INTO aom_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Ëhi uaꞌego bogo ejahonövade höjo. Ëhiꞌoꞌi arijuvo ë jö mevaje ahuro hesi uehorovoromo uvade höjo: Na God bogo uehorovoromo a jabesi örirohuꞌo bogo uehorovaje höjo ");
INSERT INTO aom_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","röhu ave magonaho doruohuro dinemiꞌi hiꞌego na bijönegoꞌego ëhuni na hesi öroho avohahoꞌejöjo huro ro ueꞌi hijego na heꞌi hijego uꞌuvevojöëni. ");
INSERT INTO aom_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Badaro ë uhu jöho ëhi majëhinugoromo jö bëhoho uëvadeje: Ëjö mevaje a sisëhu diehi jövadoho uehorovorëjo. ");
INSERT INTO aom_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Aꞌi God-ro diehi ëꞌaꞌajëjo. Hesi aribövi maehu vahie sisone jene hesi örire ëninamiꞌi arijaruoho na hu jabesi mu öroho bogo avohëhoꞌajëjo. Na hu majae ëgobövie örisanuovoꞌi bogo burëroho ajëmiꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Iae hu ma-burëro ajëmiꞌajëjo. Röhu God-are A Ma naehu saꞌare rovëꞌiroho na na gaꞌejöjo aëro biririvoromo God mae uehorovoꞌiramu o bogo. ");
INSERT INTO aom_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Iae Iesuro gëvadeje ae gö jabesi sivue uehorovoromo uvamu: Noremuëremu maho javuajëromo a ioroꞌioro jabesi jöho bogo uehorovoruomamu gëgorovo jabesi örire ave uhu jöho majëhiromo uëvadeje: ");
INSERT INTO aom_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Iae ae niöꞌiro God-are osa börömore parie vaeꞌi ajiomare höjo. Göho Pharisee ae jiade höjo. Göho vajiohuꞌe tax baejaje ae jiade höjo. ");
INSERT INTO aom_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Ajiomoromo Pharisee ahuro vaꞌoromo namiromo parie vaeromo ëhi uavade höjo: God-ajo. Na jasi örire huë mae uavajëjo rabëni a ioroꞌioroho jabu ananoꞌe vajiohuꞌe gohoꞌamarue mu vaeruomajëhi naehu bogo ëhi ëꞌajohuni. O aruëre tax baejaje ae jiajëhi na bogo ëhi jevajohuni. ");
INSERT INTO aom_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Aꞌi hurae gemu gemu hesi uhure majae niöꞌi jasi jöëni na ioho bogo ijaje höjo. Inöme rabe ujuohëꞌoho 9 nasi bahiꞌi gemu jani bamahobe vaꞌaje höjo. ");
INSERT INTO aom_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Ëhi uaꞌirögoro rue tax baejaje ahuro roriꞌo namiromo javojimamu nunoho bogo öꞌidöho siorohoꞌi vineboho övëro anoꞌanovoromo God uavade höjo: Na a sisë jevaje nani vavaenimëjo. Ëhiꞌare höjo. ");
INSERT INTO aom_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Naro jemë uëvajëjo: Tax baejaje aho God-ro hesi sisëho uehorovoromo vuonugamu God-are nurire mae namijëꞌëro hesi osare vuonoröꞌö abuejade höjo. Aꞌi rue Pharisee aho bogo ëhioho maho abuejade höjo. Ëhesi bëhoho ae rahu hesi sivu uehorovoromo döre bamorovëꞌoho hesi ihoho abueꞌaꞌajëjo. O ae rahu baꞌobuerovëꞌoho hesi ihoho döro ajiomoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Ëhi uëvamu aëro asisöꞌo ininoho ëhuꞌo sö ujuoho rueruomadeje Iesuro öve jabesi sinore bamëhojöro. Ujuoho rovamu gëgorovo Iesuare ijorajo ömoꞌömohuro birëgareje. ");
INSERT INTO aom_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Birëgamu hegoro Iesuro asisöꞌoho ujuoho ruejöro uvoromo hesi ijorajoho uëvadeje: Nadi ahëvoꞌi uëhego rueruomajo. Ëhi jiëꞌe asisöꞌo vaꞌëne jörume raromëꞌe aribövioho God-ro böröme namiromo muebejëvego hesi ahariremu raromoruomaje höjo. ");
INSERT INTO aom_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Ave jöho na jö mae uëꞌiëꞌajëjo. Asisöꞌo ininehu bogo sivu uehorovoꞌi God-hu muebejavuajoho mae hö uvaruëhi ae rahu bogo ëhi uvëꞌoho God-are ahariroho bogo vaꞌo raromoꞌaruëjo. ");
INSERT INTO aom_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Ëhiꞌamu iae Jew rajo a böröme gemuëro riꞌöromo Iesu uavadeje: Tisa ja a mae javajëjo. Na diehiꞌoromo ma-ioroꞌioremuoho maroho hiꞌejöjo. ");
INSERT INTO aom_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Maroho hiꞌejöjamu uavadeje: Jero na uevanuëjo: Ja a mae javajëjo. Iae mae höjo röhu hesi God gemu a maho höjo. ");
INSERT INTO aom_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Röhu mae hiꞌiranëro ue gevanuoho ja God-are jögoroho iae gavanue höjo. Nadi gohoꞌamonëjo. Nadi aho anonëjo. Nadi vajiohoho baenëjo. Nadi sareriꞌe jöho aho majëhinëjo. Jasi vëmoho vavuoho mae uehorovëvonëjo. Mae hiꞌirane öroho ëhi höjo. ");
INSERT INTO aom_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Öroho ëhi höjamu uavadeje: Iae mae-ëjo röhu na asisöꞌere aevoromo jö ebe rovodoho jaruvohuꞌo ëhi gemuoho ëꞌaje höjo. ");
INSERT INTO aom_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Ëhi gemuoho ëꞌaje höjamu hegorovo Iesuro uavadeje: Iae mae ëꞌanue höjo röhu mue gemu bogo vaejëꞌe javajëjo. Jasi bövioho biseꞌoho imoꞌamoromo monioho baeromo inömo bogo eni jiëꞌe aribövioho suvuorëminëjo. Ëhi ëꞌëꞌoho bövie biseꞌe maho maho janioho öꞌidöre jiahoꞌajëjo. Ëhiꞌoromo rueromo nasi ijoro ijoro juvonövonëjo. ");
INSERT INTO aom_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Ëhi uavamu hegorovo ruehuro hesi uehorovoromo uvadeje: Na bövie biseꞌe börömo mae jevëꞌëro suvuorëmiꞌirodoho na bogo eni jevajëromo huë vavaene böröme baejadeje. ");
INSERT INTO aom_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Huë vavaene baejamu Iesuro hu garomo a ioroꞌioroho uëvadeje: Bövi biseꞌo marohëꞌe mae jiëꞌe ariböviehu God-hu muebejaje öri ariꞌere vaꞌëꞌoho anojiꞌe mae höjo. ");
INSERT INTO aom_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Mi börömo anugo gagore nugöꞌöjëꞌoho ja bogo eni javoꞌajëjo. Röhu ëhi ëꞌëꞌoho samae jianovoꞌi aꞌi bövi biseꞌo marohëꞌe ariböviehu God-hu muebejaje öri ariꞌere vaꞌiröhoho ëho anojiꞌe mae höjo. ");
INSERT INTO aom_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Ëhi jövamu heromo uavareje: Ëhi jiëꞌoho no diehiꞌoromo maroho vaꞌejarëjo. No ae ahoꞌobëhe bogo eni javuajëjo. ");
INSERT INTO aom_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Bogo eni javuajëjamu Iesuro uëvadeje: Iae ëhi höjo röhu jemë ma-aëro jëvëꞌëro mu vaejëꞌoho bogo eni jëvajoho ëho God hu eni jiajëjo. ");
INSERT INTO aom_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Ëhi uëvamu Peter-ro riꞌöromo Iesu uavadeje: Aveho gavëjo. Noro bövie biseꞌe nosiroho vuonugoꞌi jasi ijore ijore jijihëꞌe javuajëjo. ");
INSERT INTO aom_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Jijihëꞌe javuajëjamu Iesuro uavadeje: Ëho iae mae höjo. Aveho na jö mae uëꞌiëꞌajëjo. Ae rahu God-hu muebejëvoꞌiröhe mu uehorovoromo ëhuni javue vabore ö ömoꞌöme vëmu vavuꞌe aboji harihuꞌe vuonugoꞌamëꞌoho ");
INSERT INTO aom_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","ëhi jiëꞌe aribövioho jemë jemesi bövioho biseꞌoho ëho ma-biseꞌe vuonugarije höjo röhu avevejöꞌe ave saꞌare bövi mae baeꞌaꞌarujëjo. O majae ijonö jemë ma-ioroꞌioremu maro raromoꞌarujëjo. ");
INSERT INTO aom_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Iae Iesuro hesi ijoraje 12-ho roriꞌo sö vaꞌoromo uëvadeje: Aveho hehëjo. No Jerusalem amore ajiomaruëjo. Ajio raromoꞌiramu evare urimo jö God-aro baeromo majëhinövare ariböviehu jö jajivoꞌamarëhi ëhi jiëꞌe muoho Jerusalem rajëro God-are A Ma nasi örire vaejevoꞌaruëjo. ");
INSERT INTO aom_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","God-ro hesi ëhi bamëꞌëro naro saꞌa göre jioromo rovare aribövi jabesi övore vaꞌejöjo. Vaꞌiramu jaburo baejevoromo sivegoromo ijumevoromo sabëro ödegoromo ");
INSERT INTO aom_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","hisuebijevoromo anegoꞌiramu guomevoꞌajëjo. Guomoromo majae niöꞌi gemu hesi uhure riꞌöꞌejöjo. ");
INSERT INTO aom_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Ëhi uëvamu hegorovo hesi ijorajoho jabu bogo mae bogo hejareje. Bëhoho subivëhëꞌëro hesi jöho bogo avoho baejareje. ");
INSERT INTO aom_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Ëhiꞌamu iae Iesuro vaꞌadoho vaꞌo Jericho amore höröꞌiro ëꞌadeje. Röhu nuni sisëꞌe ae gemuëro ë öri ionire hiromo maëni sisëni ae ëninëmijadeje. ");
INSERT INTO aom_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Ae ëninëmiromo hejade ae ahoꞌobëhe mae rovaꞌavamu hejëꞌi ae uëvadeje: Jabumë rabëꞌi rovaꞌaruëjo. ");
INSERT INTO aom_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Rabëꞌi rovaꞌaruëjamu aëro uavareje: Iesu Nazareth rajohuro rovaꞌego ëhuni ëꞌaruëjo. ");
INSERT INTO aom_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Ëhi uavamu hegorovo nuni sisëꞌe ahuro ma-darugoꞌo uvadeje: David-are ujoho böröme javaje Iesu jero nani vavaenimëjo. ");
INSERT INTO aom_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Vavaenimëjamu hegorovo rue urimo vaꞌare ariböviohuro birevoromo uavareje: Jöe vuonugëjo. Jöe vuonugëjamu hejëꞌi ma-darugo maꞌo uvoꞌi hijadeje: Hë David-are ujoho nani vavaenimëjo. ");
INSERT INTO aom_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Ëhi uvoꞌi hijamu Iesuro vaꞌadoho vuonugoꞌi ë namiromo uëvadeje: Nuni sisëꞌe aho huꞌirae baruehëromo barovamu nuni sisëꞌe aho uavadeje: ");
INSERT INTO aom_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","Naro diehi ajamijöro nagajëjo. Nagajëjamu uavadeje: Bada ajemego na nune dadovoromo uherihöjo. ");
INSERT INTO aom_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Uherihöjamu Iesuro uavadeje: De nune dadovoromo uherihëjo. Jero God mae uehorovamu ëhuro marëjavëꞌe höjo. ");
INSERT INTO aom_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Ëhi uavamu ma-burëro uherihadeje. Uherihoromo God huë mae uabe Iesuare ijore ijore vaꞌadeje. Vaꞌamu ae ahoꞌobëhe garomo God rajahiruomadeje. ");
INSERT INTO aom_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Ëhiꞌamu Iesuro Jericho amore rovëꞌëro amo ririre rovaꞌadeje. ");
INSERT INTO aom_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Röhu ë amore ae gemu hijëꞌe jiadeje. Hesi ihoho Zacchaeus jiadeje. Hu tax baejaje a böröme jiadeje. Hesi bövioho biseꞌoho marohëꞌe mae jiadeje. ");
INSERT INTO aom_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Amo Iesuro rueromo vaꞌiaꞌamugo Zacchaeus-ro Iesu gaꞌi sivohoromo röhu ae ahoꞌobëhe tagavoromo urahëꞌëro bunosirivamu bogo avoho gavadeje. ");
INSERT INTO aom_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Bogo gagorovo uvadeje: Iesuro ë örire vaꞌaꞌajë uvoromo urimo tutuvo vaꞌoromo öri bëhire ijo duvahore ajio hijadeje Iesu rovego niomoꞌamo gaꞌiro. ");
INSERT INTO aom_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Ajio hijamu Iesuro hu jiajiꞌere ruegoro namiromo sioroho garomo uavadeje: Zacchaeus-ajo. Ma-burëro ruvebijego vaꞌarëjo jaruvoho na jasi osare hiꞌiëꞌe jevaje. ");
INSERT INTO aom_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Ëhi uavamu hejëꞌi Zacchaeus-ro nimorohoromo ma-burëro abueromo Iesu huꞌirae baeromo hesi osare vaꞌoromo rajahijadeje. ");
INSERT INTO aom_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Rajahijamu ae ahoꞌobëhe gavare Iesuro Zacchaeus-are osare vaꞌamu gagorovo bijönimoromo uarovareje: Asëꞌe Zacchaeus a sisë höjo. Iesu rabëni ëhi jiëꞌe a hesi osaroho niavoꞌi vaꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Ëhi uarovamu Zacchaeus-ro riꞌöromo Bada uavadeje: Bada aveho hejëjo. Nasi bövioho biseꞌoho ririre tarioromo vituoho baeꞌi vituoho bogo eni jiëꞌe aribövioho suvuorëmiꞌejöjo. Naehu a rahuare inömo sarerëmiromo vajiohehu ujuohodoho iae na ëhi niöꞌi ëhi niöꞌi ëhi mana vuonoröꞌö bojëmibe vaꞌejöjo. ");
INSERT INTO aom_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Bojëmibe vaꞌejöjamu hegorovo Iesuro ae ahoꞌobëhe uëvadeje: Jaruvo ave osare raromarue aribövi jabesi sisëho uehorovoromo vuonugëhëꞌëro mae jëvajëjo. Ëhesi bëhoho Zacchaeus huꞌo Abraham-are ujëro jiëꞌëro ëhuꞌëro God-hu huë baejaje ae höjo. ");
INSERT INTO aom_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Zacchaeus vaꞌëne ëhi subiröꞌöꞌamëꞌe aribövi ioroꞌioroho nahoꞌamoromo sö rueromo maro nugoꞌamoꞌirodëni ëhuni God-are A Maho na rovode höjo. ");
INSERT INTO aom_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Ëhi uëvamu ae ahoꞌobëhe hejareje. Heromo uvareje: Iesu Jerusalem höröꞌi dunovajëjo. Höröꞌiramu gavëꞌi no aevoromo gaꞌejarëjo God-ro böröme namiromo no muebejavuoꞌiramu. Ëhi uvoruomamu gëgorovo Iesuro hesi jöho uhuꞌe majëhiromo uëvadeje: ");
INSERT INTO aom_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Iae a böröme gemuëro hijade höjo. Hiromo öre ëgoböviro saꞌa göro vaꞌiëꞌade höjo hesi saꞌa mueberöhe darugoho baeromo vuonoröꞌö rueꞌiröhëni. ");
INSERT INTO aom_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Vaꞌirögoro hesi mu vaejaharue ae ahoꞌobëhe 10 jaburo ruejöro uvëvoromo rueruomamu ae gemu gemu 20 kina 20 kina ëhi bojëmibe vaꞌade höjo. Bojëmibe vaꞌoromo uëvade höjo: Ave monioho baeromo muoho ma-vaemu vaeromo monie göꞌo döro baejehorego evare na vuonoröꞌö rueromo baeꞌiröjo. ");
INSERT INTO aom_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Ëhi uëvëꞌëro vaꞌamu gagorovo ë a börömoho hesi saꞌa rajohuro nue huodivëꞌëro ae gö rëmöꞌöjamu a börömo hesi ijore vaꞌare höjo. Vaꞌoromo ë saꞌa göre suorovoromo a masijoho uëvare höjo: Ëaehu böröme namiromo nosi saꞌa muebejavuoꞌiröhoho no bijönaguajëjo. ");
INSERT INTO aom_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Ëhiꞌamu ë ahuro hesi saꞌa mueberöhe darugoho baeromo vuonoröꞌö rovade höjo. Rueromo jöe nugöꞌöromo hesi moni bojëmade mu aribövioho uëvade höjo: Ruehego na gëvöjo monioho dimine dimine göꞌo döroho baejehëꞌe jëvego. ");
INSERT INTO aom_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Ëhi uëvamu ae gemuëro urimo rueromo uavade höjo: Jaehu 20 kina bojemijanohuro ëhuro na mue vaeromo göꞌo döre 200 kina baejahëꞌe jevajëjo. ");
INSERT INTO aom_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Baejahëꞌe jevajëjamu ruehuro uavade höjo: Mabëhëjo. Ja mu mae vaejanue ae javajëjo. Ja mu biseꞌoho mabëhe muebejehobe rovanohuni ëhuni naro darugoho bojamiꞌejöjo jero ame ahoꞌo 10 muebejehoꞌiranego. ");
INSERT INTO aom_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Ëhi uavamu gavëꞌi mu vaejaje a göhuro rueromo uavade höjo: Jaehu 20 kina bojemanohuro ëhuro na mue vaeromo göꞌo döre 100 kina baejahëꞌe jevajëjo. ");
INSERT INTO aom_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Baejahëꞌe jevajëjamu ruehuro uavade höjo: Jero ame 5 muebenëjo. ");
INSERT INTO aom_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Muebenëjamu gavëꞌi mu vaejaje a göhuro rueromo uavade höjo: Jasi 20 kinaho aviae höjo. Niögëro numoromo avoho bamahëꞌe jevajëjo. ");
INSERT INTO aom_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Ëhesi bëhoho naro ja juhuonamijode höjo ja vöröꞌe ae javëꞌego. Ae göehu baꞌamaroho bivaroho ja ma-ijanue höjo. ");
INSERT INTO aom_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Ëhi uavamu hesi börömohuro uavade höjo: Ja mu sisë vaejanue ae javajëjo. Jaehu jasi jöꞌehu jövanue jöe gemuoho ëho naro baeromo vuonoröꞌö ja mana majahiꞌiëꞌajëjo jero heromo uvoꞌiranego: Ojoꞌe na sisë ëꞌaje ae jevajëjo. Jero uvane höjo: Nörö vöröꞌe aëro jiëꞌëro ae göehu baꞌamaroho bivaroho ma-ijaje höjo. ");
INSERT INTO aom_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Ëhi uvanoho röhu ja rabëni nasi ijo bajoho bogo baeromo avoho bahijarue aribövi jabesi övoroho bamane höjo na rueromo nasiroho baeromo göꞌo döre bamaroho ëhuꞌo baeꞌirode. ");
INSERT INTO aom_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Ëhi uanugoromo ë bëhire riravarue aribövioho uëvade höjo: Ëia hesi 20 kina baeniahiromo 200 kina baejade aho bojamihëjo. ");
INSERT INTO aom_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Bojamihëjamu rue ariböviohuro uavare höjo: Iae mae höjo röhu mamiꞌe iae hu 200 kina baejade höjo. ");
INSERT INTO aom_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Baejade höjamu ruehuro uëvade höjo: Na aveho uëvajëjo. Mu vaeꞌirane suvuore javëꞌoho God-ro göꞌo bojamiꞌiramu baeꞌaꞌanuëjo. O bogojavëꞌoho bisemu baejanoho God-ro baeniahiꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Röhu na nu huodegarue aribövi jabesi jöho uëꞌiëꞌajëjo. Naro böröme namiromo muebejëvoꞌiaꞌamu bijönimare jiaje ëhuni guduamo ujuoho rueromo nasi nunoro muoꞌamego vuovajo. ");
INSERT INTO aom_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Ëaribövioho ëhi uënugoromo Iesuro urimo Jerusalem höröꞌi ajiomamu gavëꞌi ë ariböviohuro ijore rihiromareje. ");
INSERT INTO aom_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Ëhiꞌoromo Iesuro Olives Dahorure Bethphage amo o Bethany amo jiajinö ë ajio höröjadeje. Hörönugoromo hesi ijorajoho niöꞌi rëmöꞌöromo ");
INSERT INTO aom_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","uëvadeje: Arue jemesi nuninörire amohuro vaꞌohëjo. Vaꞌo höröꞌi gaꞌaꞌarujëjo donkey harihe biseꞌego aehu döre bogo hiromo vaꞌaruoho benugëꞌe jioꞌiramu. Benugëꞌe jiego jiovoromo huꞌirae ruerëjo. ");
INSERT INTO aom_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","O aehu uëvëꞌoho: Jemë rabëni jiovarujë uëvëꞌoho uërëjo: Badaro ave mioho nimoꞌego ëhuni jiovaruëre. ");
INSERT INTO aom_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Ëhi uëvamu vaꞌoromo gavareje Iesuhu uëvadëhi ëhi jiamu. ");
INSERT INTO aom_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Ëhi jiamu gagorovo jaburo donkey harihoho jiovamu gavëꞌi ë mi arijoꞌoho jaburo gëromo uëvareje: Jemë rabëni donkey harihoho jiovarujëjo. ");
INSERT INTO aom_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Rabëni jiovarujëjamu rueho jaburo uëvareje: Badaro ave mioho nimoꞌego jiovaruëjo. ");
INSERT INTO aom_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Ëhi uëromo jiovoromo huꞌirae barueromo jabesi niögoho mi dejore ruahoꞌamo bahiromo Iesu maꞌenamu ajio döre hijadeje. ");
INSERT INTO aom_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Hiromo vaꞌamu gavëꞌi ae ahoꞌobëhe niögoho örire ahahobe vaꞌareje. ");
INSERT INTO aom_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Ahobe vaꞌamu Iesuro ë vaꞌoromo Olives Dahorure ajiomoromo hojire höröromo Jerusalem höröꞌi abueꞌiëꞌadeje. Abueꞌiaꞌamu Iesuare aribövie ahoꞌobëhe Iesuro mu masije ahoꞌo vaejamu garuomëꞌëro ma-darugoꞌo God mae uabe nimorohobe abueruomadeje. ");
INSERT INTO aom_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Abuejëꞌi uvoruomadeje: Ave aho a börömehu Badare ihore rovajoho mabëhëjo. Öꞌidöre aribövioho huë maro raromaruëjo. Aje ahoꞌo God-aremu höjo. ");
INSERT INTO aom_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Ae ahoꞌobëhe huꞌo gemuore vaꞌoruomadeje röhu Pharisee a ioroꞌiorohuro Iesu uavareje: Tisa jasi aribövioho uëvego ja rajahijaruoho vuonugarëjo. ");
INSERT INTO aom_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Vuonugarëjamu Iesuro uëvadeje: Bogajo. Na aveho uëvajëjo. Nasi ariböviehu rajehijaruoho vuonugoꞌibejarëjo ë munëho jaburo aëro ëꞌanovoromo nasi örire rajehiruomoromo ma-darugoꞌo uvoruomoꞌibejajo. ");
INSERT INTO aom_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Ëhi uënugoromo Iesuro vaꞌadoho Jerusalem amo bëhi mare vaꞌadoho vaꞌo amoho garomo vavaenimoromo ");
INSERT INTO aom_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","nivëꞌi uvadeje: Vaevëꞌoho jemë jaruvo gaꞌibejarijëjo jemë diehi ëꞌoromo ma-mae raromoꞌirarije öroho ëhi jiego gaꞌibejarijëjo mae jëvoꞌibejajo. Röhu jaruvo gaꞌibejarijoho tugohëꞌëro bogohöjo. ");
INSERT INTO aom_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Majae ijoho rueꞌiramu jemëꞌo muorovarue ariböviohuro rueromo saꞌae babaenemi rovaꞌoromo tugohoromo ruë numë numëvo barëꞌaruëjo. ");
INSERT INTO aom_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Numëvoromo jemë ujuoho saꞌare behumëvoꞌamoꞌaruëjo jemëꞌo jemesi asisöꞌohuꞌo. Munë javu vaeromo babaenemibe ajiomaroho jaburo dadovoꞌiramu ahoromo saꞌaro ruvebi barë nahonahovoꞌajëjo. Rabëni hesi bëhoho God-ro jemë ajëmiꞌi rovamu jemëro ëho bogo uehorovëꞌego ëhuniajo. ");
INSERT INTO aom_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Iesuro nivëꞌi ëhi uvoromo God-are amo börömore ajiomoromo bövie biseꞌe imoꞌamarue aribövioho osare jëvamu rarovöꞌöjëvadeje. ");
INSERT INTO aom_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Rarovöꞌöjëvoromo uëvadeje: God-are surire jöho ëhi uvëꞌe höjo: God nasi osaho nasi örire jö atoꞌirarije osae höjo. Ëhi uvëꞌe höjo röhu jemëro mu sisë ëꞌëꞌëro ëhuro ave osaho vajiohuꞌe ariböviehu gurihirovarue juju gagoho vaꞌëne höjo. ");
INSERT INTO aom_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Ëhi ëꞌëꞌëro Iesuro majae ëhi God-are osare hiromo jöho röjëhinövadeje. Röjëhijamu priest masijohuꞌo Jew rajo jögoru öri röjëhijarue ariböviohuꞌo Iesu anoꞌiröhe öroho nahoꞌi amo rajo a masijoho jabuꞌo ëhi ëꞌareje. ");
INSERT INTO aom_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Öroho nahoromo gavare ae ahoꞌobëhe Iesuare jöhuremu heꞌi hiaꞌe avohamu gëgorovo uvareje: No Iesu anëꞌoho ë aribövioho jaburo diehiꞌavuoꞌaruëjo. Ëhi jiëꞌëro Iesu anoröhe öroho bogo birohareje. ");
INSERT INTO aom_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Ëhiꞌamu Iesuro God-are amo börömore hiromo ae magonahe hesi jö maho majëhiromo hesi öroho röjëhijadeje. Röjëhijamu gavëꞌi Jew rajo priest masijohuꞌo jabesi jögoru öri röjëhijarue ariböviohuꞌo ëho jaburo a duvaho ömoꞌömohuꞌo gemu mae rueruomadeje. ");
INSERT INTO aom_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Rueromo Iesu uavareje: Ave jöho uövuego no heꞌirarëjo. Jaehu God-are amo börömore hiromo mue gö gö vaejanuoho diehi jiëꞌe daruge javoromo o raro darugoho bojamijëꞌëro ëhi jiëꞌe muoho vaejanue höjo. ");
INSERT INTO aom_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Vaejanue höjamu Iesuro uëvadeje: Nasi darugo hesi jö ue gevarujoho naꞌo jemë jöe gemu uë gëꞌiëꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","John-hu bapataeto vaejavuonövadoho na God-ro o ma-aëro darugoho bojamijëꞌëro ëhioho ëꞌonövade höjo. ");
INSERT INTO aom_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Ëꞌonövade höjamu rue a masijohuro Iesu diehi mana uaꞌiröhe jöho jabesi mevoromo uarovareje: Noehu uavëꞌoho: God-ro John darugoho bojamade hö uavëꞌoho Iesuro uöꞌaꞌajëjo: Ëhi jiëꞌoho jemë rabëni John bogo ma uehorovarije höjo. ");
INSERT INTO aom_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","O noehu Iesu uavëꞌoho: Ma-aëro John uavamu ëꞌade hö uavamu hejëꞌoho ae ahoꞌobëhe munëro vajamuiꞌaruëjo ë hesi bëhoho jaburo uvoruomëꞌëro: John hu jö God-aro baeromo majahuinövade ae hö uvoruomëꞌëro. ");
INSERT INTO aom_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Ëhi uarovoromo Iesu uavareje: No dadivavuajëjo John darugoho dinöꞌe baeromo muoho vaejade höjo. ");
INSERT INTO aom_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Vaejade höjamu Iesuro uëvadeje: Ëhi jiëꞌoho jemëhu uevarije jöho naꞌo bogo uëꞌejöjo: Ëhi jiëꞌe darugohuro na muoho vaejaje höjo. ");
INSERT INTO aom_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Iesuro ëhi uënugoromo ë Jew rajo aribövi jabesi jö sisëho uhuꞌe majëhiromo ae ahoꞌobëhe uëvadeje: Iae ae gemuëro mure grape öꞌoho bivoꞌamade höjo. Bivonugoromo ae uëvade höjo: Na vaꞌejöjo. Jemëro nasi muoho muebejehorëjo. Mueberomo öꞌi bajoho raeromo mavego nasiroho bahiꞌi ioroꞌioroho jemesi ujuohorëjo. Ëhi uënugoromo riꞌöromo saꞌa göro vaꞌoromo majae ëgobövie ë hijade höjo. ");
INSERT INTO aom_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Hijuvo gavade öꞌi bajo urarue majaho rovamu mu vaejaharue aho gemu uavade höjo: Vaꞌiranoho mu muebejarue aribövioho uënego öꞌi baje gö iꞌimamego ujuoheho ruenëjo. Ujuoheho ruenëjamu ruehuro vaꞌade höjo. Vaꞌo mure höröjamu gavëꞌi rue mu muebejarue ariböviohuro ë aho anoromo sihöꞌöjamu sionëro övemu rovade höjo. ");
INSERT INTO aom_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Övemu rovamu gagorovo mu arijoꞌohuro mu vaejahaje a göho nugöꞌöjamu mure vaꞌade höjo. Vaꞌo höröjamu gavëꞌi rue mu muebejarue ariböviohuro ë aho anoromo hesi örire mu sisë vaeromo sihöꞌöjamu sionëro övemu rovade höjo. ");
INSERT INTO aom_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Rovamu gagorovo mu arijoꞌohuro mu vaejahaje a göho nugöꞌöjamu mure vaꞌade höjo. Vaꞌamu gavëꞌi mu muebejarue ariböviohuro ë aho anojuvo gavare hesi sino hahoꞌoho ma-köëremu rumorovoromo rövamu roriꞌo babuꞌöjare höjo. ");
INSERT INTO aom_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Ëhiꞌamu gagorovo mu arijoꞌohuro uehorovoromo uvade höjo: Ëhi jiëꞌoho na diehiꞌoromo öꞌi bajoho ujuohoꞌejöjo. Iae na nasi harihu mabëhoho nugöꞌöꞌejöjo. Nugöꞌöꞌiramu vaꞌiramu rue ariböviohuro hu garomo uvoruomoꞌajëjo: Nöruare harihe hö uvoromo ëhuni nani hu mae uehorovoruomoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Ëhi uvoromo hesi harihoho nugöꞌöjamu mure vaꞌade höjo. Vaꞌo höröjamu gavëꞌi rue mu muebejarue ariböviohuro uarovare höjo: Arue rovaje ahuro hesi vavu hesi sionoho bae hesi höjo. Ëhuni ëꞌego ano bamarëjo ëhuro ave muoho noro baeröhe höjo. ");
INSERT INTO aom_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Ëhi uarovoromo ë aho guduamoromo mure jiamu roriꞌo bijimo buꞌöromo anamu guomade höjo. Ëhiꞌare höjo. Ëhi jiëꞌoho mu arijoꞌohuro ë mu muebejarue aribövioho diehiꞌëvoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Huro rueromo iꞌue bojëmiromo muoꞌamoꞌi ë muoho ae gö bojëmiꞌajëjo jaburo mueberöhego. Ae gö bojëmiꞌajëjamu hegorovo ae ahoꞌobëhe bëhoho uehorovoromo uvareje: Mu muebejare ariböviehu sisë ëꞌoromo iꞌu baejarëhi nosi a masijo ëhi jëvoröhoho no bijönaguajëromo Iesu uavareje: Asëꞌe ëhi jiëꞌoho mu sisë höjo. ");
INSERT INTO aom_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Mu sisë höjamu hegoro Iesuro jabumë ërimëhoromo uëvadeje: Jemesi a masijehu ëhi jiëꞌe mu sisë vaeromo iꞌu baeröhoho jemë bijönëgajëjo röhu ave uhu jö God-are surire jajivadoho bëhe gemuoho höjo: Munë javue vaeꞌirögoro munë gemu bijönimoromo vuonugare höjo. Vuonugaroho jaruvoho ë munëhuro javuoho nigemoꞌego bibivoromo mae namijajëjo. Ëhi jajivëꞌe höjo. ");
INSERT INTO aom_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Röhu aehu ë munë döre bejëꞌoho ahoro ahoro baeꞌaꞌajëjo. O ë munëhu a döre berovëꞌoho aho saꞌijovo barëꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Ëhi uëvamu hegorovo rue Jew rajo jögoru röjëhijarue ariböviohuꞌo priest masijohuꞌo ëho jaburo garomo uvareje: Iesuro a masijoho no biraguoromo ëhuni uhu jöho jövajëjo. Jövajë uvoromo evare Iesu guduamo bavaꞌiëꞌoromo ae ahoꞌobëhe juhuonëmiromo vuonugareje. ");
INSERT INTO aom_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Vuonugonugoromo Iesu garomo muebejuvo majae eni jiamu gagorovo ae uëvareje: Vaꞌirarijoho Iesu sareramijego huro uvoꞌirajo: Jemë a mae jëvajëjo. Ëhiꞌoromo hesi öroro jöe ua gavego huro jöe sisëꞌi jövoromo guaro berovoꞌirajo. Berovego evare no guduamo bavaꞌoromo gavanare övore bojamiꞌiröhe höjo. ");
INSERT INTO aom_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Ëhi uëvamu hegorovo jaburo vaꞌoromo Iesu sarerisareriamiromo uavareje: Tisajo. Iae no gavarue höjo ja jö maemu jövoromo mu maemu röjahuijego. Jero no göromo ma-gemu uehorovavuoromo God-are örohemu mae röjahuijanue höjo. ");
INSERT INTO aom_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Ëhuni jö harihe ua gaꞌiëꞌaruëjo tax jöho. Rome a börömohuro nosi saꞌaho muebejego noro hu tax bojamijarue höjo. Noehu ëhi ëꞌaruoho na ëhuro nosi jögoroho aharue höjo o bogajo. ");
INSERT INTO aom_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Bogajamu Iesuro gëromo uvadeje: Naehu ioꞌa o boga uëvëꞌoho ijumevoꞌi nimaruëromo uëvadeje: ");
INSERT INTO aom_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Ijo baje gemu röjehihego na gavöjo. Röjahijamu uëvadeje: Rahuare nu anoꞌohuꞌo ihohuꞌo jajivëꞌe höjo. Jajivëꞌe höjamu uavareje: Rome a börömo hesi höjo. ");
INSERT INTO aom_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Rome a börömo hesi höjamu Iesuro uëvadeje: Ëhuni Rome a börömo hesiroho ëho hesi öroro bojamiꞌi God-aroho ëho God-are öroro bojaminövorëjo. ");
INSERT INTO aom_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Ëhi uëvamu hegorovo rue Iesuare jö sisë nahare ariböviohuro uvareje: Noro uvare höjo: Noro Iesu bijioho gaꞌiramu huro tax jöho sisëꞌi jövoromo a nuniro beꞌaꞌajë uvaroho röhu hu bogo bejade höjo. Ëhi uvoromo jöe barëjëvamu jörumoraejareje. ");
INSERT INTO aom_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Jörumoraejamu iae Jew rajo a masijo ioroꞌiorohuro rovareje. Jabumë Sadducee jö uehorovarue aribövie jioruomadeje. Sadducee ariböviohuro uehorovoromo uvoruomajeje: A vuovëꞌoho ijonöho bogo riꞌöꞌamoꞌi ma-ioroꞌiore gemu vuovoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Ëhi uvoruomaje ariböviohuro rueromo Iesu guaro berovojöro sarerisareriamiromo uavareje: Tisajo. Moses-ro jögore jajivoromo uövuëꞌe höjo: Aboji harihuꞌo rumoꞌe a vuovego diehi ëꞌiröhe öroho aviëhi höjo. Aehu vaboro masuromo vaboroho aboji harihuꞌoho bogo vaejëꞌe baruehu guomoꞌi vaboro nugëꞌoho hesi öhuro vuojiroho masuromo ëhuro guomade ö hesi ihoro ujoho vaejahoꞌajëjo. Moses-are jögoroho ëhi höjo. ");
INSERT INTO aom_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Ëhi jiëꞌëro iae ma-ö ömoꞌömëremu ae ahoꞌo 7 raromare höjo. Raromoromo muriohuro magonahoho masuvade höjo. Masuromo vaboroho aboji harihuꞌoho bogo vaejëꞌe baruoho guomade höjo. ");
INSERT INTO aom_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Guomamu hesi vaboroho dorue hijamu gagorovo ö göhuro vuojiroho masuvade höjo. ");
INSERT INTO aom_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Masuromo guomade höjo. Guomamu hesi vaboroho röhu maho dorue hijamu gagorovo ö göhuro vuojiroho masuvade höjo. Masuromo guomade höjo. Ö ömoꞌömo ioroꞌiorohuꞌo ëhi gemuoho ëꞌobe rovare höjo. Ö ömoꞌöme 7 jabuhu ë magonahe gemuoho masube rovaroho magonahoho aboji harihuꞌoho bogo vaejëꞌe aho ma-vuovëvobe rovade höjo. ");
INSERT INTO aom_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Vuovobe ruejuvo barëjamu ijo tugohoꞌioho ë magonahoho huꞌo guomade höjo. Ëhiꞌare höjo. ");
INSERT INTO aom_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Ëhi ëꞌarohuni ëhuni ave jöho no ua gaꞌiëꞌaruëjo. Jero uvanue höjo: Vuovoromo riꞌöꞌejarëjo. Ëhuni vuovëꞌe ariböviehu riꞌöruomoröhe majaroho ë magonahoho di ahuꞌo hiꞌaꞌajëjo. Barue ahoꞌo 7 masuvëꞌego ëhuni uavaruëjo. ");
INSERT INTO aom_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Uavaruëjamu uëvadeje: Bogajo. Ave saꞌare raromarue aribövioho masurovarue höjo. ");
INSERT INTO aom_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Aꞌi God-hu uvëꞌoho: Mae jëvëꞌego vuovoromo riꞌöromo maja iꞌore raromoꞌaruë uvëꞌoho ë aribövioho evaroho bogo masurovoꞌaruëjo ");
INSERT INTO aom_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","bogo röhu maho vuovëvoꞌiëꞌëro. Ëhesi bëhoho ëhi jiëꞌe aribövioho vuovoromo riꞌöꞌamëꞌëro jabumë God-are aboji harihuꞌe jëvoromo anera vaꞌëne jëvoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Röhu vuovëꞌe ariböviehu riꞌöꞌiröhoho ë jöho Moses-ro röjëhijade höjo. Ijo hisu vënehu ravade jö jajivadevare evare surire jajivoromo uvëꞌe höjo: Bada God-hu Abraham Isaac Jacob ëhi muebejëvaje ae höjo. ");
INSERT INTO aom_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","God-hu Abraham Isaac Jacob muebejëvaje jö hesi bëhoho jabumë vuovoromo bogo ioroꞌioremuoho barëꞌi vaꞌo raromego God-ro muebejëvaje höjo. God bogo vuovoromo ioroꞌioremu barëjëꞌe aribövioho muebejëvoꞌibejajo. Aꞌi hu vuovoromo vaꞌo raromarue aribövioho muebejëvaje höjo. God gavaje höjo vuovëꞌe o bogo vuovëꞌe aribövioho bogo barëꞌi raromego muebejëvaje höjo. ");
INSERT INTO aom_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Ëhi uëvamu hegorovo Jew rajo jögoru öri röjëhijarue aribövi ioroꞌiorohuro uavareje: Tisa ja mae uvanuëjo. ");
INSERT INTO aom_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","O Iesu bijönimare ariböviohuro Iesuare dëre bijioho garöhe jöho ua gaꞌiëꞌaroho juhuonivoromo ioroꞌioremu vuonugareje. ");
INSERT INTO aom_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Vuonugamu Iesuro uëvadeje: Aëro atoromo uvoruomaje höjo: Böröme namiromo ajamuiꞌiröhe aho hu ma-David-are uje jioꞌaꞌajëjo. Rabëni ëhioho uvoruomaje höjo. ");
INSERT INTO aom_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","David-ro Psalms jajivoꞌamare surire jajivoromo uvëꞌe höjo: Bada God-ro nasi Bada uavade höjo: Nasi övo manö rojo hijego ");
INSERT INTO aom_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","jaꞌo muorovarue aribövioho naro ruahöꞌöjëvego hörëro vijuvo taemoꞌamoꞌirane höjo. ");
INSERT INTO aom_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Ëhesi bëhoho böröme namiromo ajëmiꞌiröhe a hesi jöho David-ro jajivoromo uvëꞌe höjo: Bada höjo. Bada hö uvadoho ëhuꞌoho rabëni uvoruomaje höjo: Böröme namiromo ajamuiꞌiröhe aho ma-David-are uje höjo. ");
INSERT INTO aom_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Ma-David-are uje höjamu rue Jew rajo jögoru öri röjëhijarue ariböviohuro jöho bogo mana uavareje. Bogo mana uavamu ae ahoꞌobëhe riravoromo muꞌöjahijamu gavëꞌi Iesuro hesi aribövioho uëvadeje: ");
INSERT INTO aom_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","Jew rajo jögoru öri röjëhijarue aribövioho gë avohorëjo. Ëhesi bëhoho ë aribövioho jaburo jabesi sinohemu uehorovoromo niögu ëgobövie höruꞌo utahëꞌoho ioꞌamoromo jijiharue ëhi jiëꞌe muoho nimarue höjo aëro gëromo rajëhijöro. O imoꞌamaruire vaꞌëꞌoho jaburo nimarue höjo aëro uvoruomoröhego: Jabumë a masijëro jijihajëromo rajëhiromo jejëmiruomoröhego. O God rajahijarue osare vaꞌëꞌiroho o sörö iꞌi vaꞌëꞌiroho a masijehu raromaruire ë vaꞌo raromoꞌi nimarue höjo. ");
INSERT INTO aom_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Raromoꞌi nimoromo magonaho doru jabesi bövioho biseꞌoho ëma ujuohëharue höjo. Ujuohoromo sarerivoromo pari ëgobövie jaguvarue höjo aëro gëromo uvojöro: Mu mae vaejaruëjo. Ëhi jiëꞌe sareriꞌe muoho vaejaruego ëhuni God-ro iꞌu börömo mae bojëmiꞌajëjo. Ëhuni avoho mueberovoꞌi nadi ëhi jiëꞌe muoho vaerëjo. ");
INSERT INTO aom_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Ëhi uënugoromo Iesuro avoho uherihoꞌi gavadeje bövi biseꞌo marohëꞌe mae jiëꞌe aribövioho God-are amo börömore riravoromo God-are suvuoro bahijaruire ë vaꞌoromo jabesi suvuoroho ioꞌamamu. ");
INSERT INTO aom_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Ioꞌamamu gëvëꞌi gavadeje bövi biseꞌo rumoꞌe magonaho dorue gemuëro rueromo rövëꞌe ijo baje niöꞌi ë gemuore baꞌamëvamu. ");
INSERT INTO aom_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Baꞌamëvamu gagorovo Iesuro ae uëvadeje: Ëbövi biseꞌo marohëꞌe jiëꞌe ariböviohuro ijo baje ahoꞌo ioꞌamoꞌi arue bogo eni jiëꞌe magonahohuro rövëꞌe ijo bajoho niöꞌi baꞌamade höjo. Röhu God-ro ëhi uvajëjo: Ëmagonaho hesi suvuorohuro a ioroꞌioro jabesi suvuoroho iosiramiꞌamoromo börömo mae höjo. Na mae uëvajëjo. ");
INSERT INTO aom_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","God-hu ëhi uehorovaje hesi bëhoho ë a ioroꞌiorohuro inömo marohëꞌe maëro jiëꞌëro ma-vituohemu bojamiꞌi ë magonahohuro inömo rumoꞌëro jiëꞌëro hesi i iꞌibejade monioho bövioho biseꞌoho ahoꞌo bojami barëjëꞌe höjo. ");
INSERT INTO aom_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Ëhiꞌamu aëro God-are amo börömo hesi jöho atareje. Munë mabëhëro iromëꞌëro God-ni suvuoro nu anoꞌe mabëhe ë amore bahijëꞌëro ëhuꞌëro ë amo hesi nu anoꞌe mabëhe jiajoho ë hesi jöho atareje. Ëhi atamu hegorovo Iesuro uëvadeje: ");
INSERT INTO aom_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Jemë ave ahoꞌo gavarujoho majae ijonö ë munë javuoho ahoꞌobëhe aëro dadovoruomoꞌiramu munëho ahoromo saꞌaro ruvebi barë nahonahovoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Ëhi uëvamu rue ariböviohuro uavareje: Tisa jaehu uövuanue muoho ëho divare jioꞌaꞌajëjo. O mu rabe garomo uvoꞌejarëjo: Iae ë majaho rueꞌiëꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Rueꞌiëꞌajëjamu Iesuro uëvadeje: Gavëꞌiajo. Aëro sarerëmiꞌiramu jemë rireromëvo vaꞌaꞌajëjo. Ae ahoꞌobëhe rueromo sarerëmiromo uëꞌaꞌaruëjo: Nöruare ihoro rovajëjo. God-hu uevëꞌëro böröme namiromo ajëmiꞌirode aho na jevajëjo. O uëꞌaꞌaruëjo: Jemëhu muebejaruje majaho iae aviae rovajëjo. Ëhi jiëꞌe jö uëvamu hejëꞌoho jabesi ijore ijoroho nadi jijihorëjo. ");
INSERT INTO aom_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","O heꞌirarije saꞌae göehu saꞌa göhuꞌo muorovarue jöhuꞌo saꞌa gemuehu arijoꞌarije muorovamirovarue jöhuꞌo hejëꞌoho nadi juhuonivorëjo. Öre gö bogojiëꞌëro ëhi jiëꞌe mu sisëho iae urimo jioꞌaꞌajëjo. Röhu saꞌaho bövioho biseꞌoho evaroho bogo barëꞌi hesi majae göro jioꞌaꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Ëhi uënugoromo röhu ave jö börömohuꞌo majëhiromo uëvadeje: Saꞌae göëro göhuꞌo muorovonövo a masijo ioroꞌiorohuro ioroꞌiorohuꞌo muorovonövoꞌaruëjo. ");
INSERT INTO aom_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Saꞌae darugoꞌo hijiohijiovoꞌamoꞌajëjo. Saꞌae gö gö irunoꞌe bogojioromo guomo guomo sisë rueꞌaꞌajëjo. Bogo gavarue vöröꞌe mu masijoho öꞌidöre jioꞌaꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Röhu ë mue ahoꞌo ë hesi urimo aëro na bijönegoromo jemë guduamëvoromo sisë vaejëvoꞌaruëjo. Ujuohëvo vaꞌoromo God rajahijarue osae göre göre court vaejëvoromo savoji gagore ioꞌamëvoꞌaruëjo. Gavana o saꞌare a masijo gö gö jabesi nunire rëmoꞌiramu ë riravoꞌarujëjo. ");
INSERT INTO aom_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Jabesi nunire riravoꞌiramu ëhuro jemëhu nasi jö huruoho majëhiꞌirarije öroho jiovëhoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Nasi jö majëhiꞌirarije öroho jiovëhoꞌiëꞌaje jiaje ëhuni a masijo jabesi nunire riravoꞌirarije maja ë hesi urimo uehore gemu baeromo uvorëjo: Noehu jabesi nunire riravëꞌiroho no bogo uvoꞌejarëjo: Diehi mana uëꞌejarëromo nurunurumoꞌejarëjo. ");
INSERT INTO aom_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Ëhesi bëhoho Iesu naro jemesi jöꞌe simane sasohëhoꞌiramu jöho majëhiꞌarujëjo. Majëhiꞌiramu jemë nu huodëgarue aribövioho jemesi jöho heromo röhu ahëhoromo jö mana majëhiꞌiröhoho bogo eni jioruomoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Bogo a göho gemu aꞌi jemesi vëmu vavuꞌëro ö ömoꞌömëro aganëro aemoꞌaemëro jabuꞌo jemë guduamëvoromo ujuohëvo vaꞌoromo a masijo jabesi övore bojëmiꞌiramu baejëvoruomoꞌajëjo. Baejëvoromo a ioroꞌioroho jemë muoꞌamëvoꞌiramu vuovëvoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Jemëhu na uehorovevarujohuni ae ahoꞌobëhe jaburo jemesi örire nue huodëgoruomoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Röhu jemesi aruꞌahoho bogo ëhi ëhiꞌoꞌi ma-mabëhe jëvoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Biririvëꞌohuro ëhuro mae raromoꞌirarije öroho birohoꞌarujëjo. ");
INSERT INTO aom_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Röhu jemëro gaꞌirarije muorovo ariböviehu rueromo amo numamu gavëꞌiroho uvorëjo: Jerusalem ijumo barëꞌiröhe majaho iae rovajëjo. ");
INSERT INTO aom_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Ëhi uvoromo ave Judea saꞌare raromaruje aribövioharo huruomoromo dahoruꞌero iojiomorëne. O Jerusalem raromaruje aribövioharo roriꞌo vaꞌorëne. O mure jeꞌore raromaruje aribövioharo nadi amo börömoroho vaꞌorëne. ");
INSERT INTO aom_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Huruomo vaꞌo jö uëvaje hesi bëhoho iꞌue mana ave saꞌare rueröhego God-are surire jajivare jöho ë iꞌuoho ahoꞌobëhe evare majare rue barëꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Ëhuë vavaeni rueꞌiröhe majaroho dëꞌe magonahohuꞌo aboji harihuꞌo inino jioꞌamëꞌe magonahohuꞌo jabumë vaevëꞌoho jëvoꞌajëjo. God-ro ave aribövi jabesi örire dë vörönimoromo iꞌue nugöꞌöꞌiramu huë vavaene sisë mae ave saꞌare rueꞌaꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Huë vavaene ave saꞌare rueꞌiramu muorovo ariböviohuro bije bune baeromo saꞌae göro jioromo rueromo jemesi a ioroꞌioroho muoꞌamoꞌiramu vuovoꞌi a ioroꞌioroho guduamoromo tövoꞌamoromo saꞌae göro göro ujuoho vaꞌoruomoꞌajëjo. O saꞌa göre göre jioromo rueröhe ariböviohuro Jerusalem ijumo barëromo ave saꞌaho jabesi baeromo sisëꞌi muebejëvobe vaꞌojuvo hujeji God-hu bamade majaho rueꞌiramu evare jabesi vöröho barëꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Röhu majare manaerore jijire mujörure vöröꞌe muoho jioꞌiramu aëro sioroho garuomoꞌajëjo. O saꞌaroho saꞌa gö gö rajëro heꞌiröhe sö jovoho ma-darugoꞌo hasajavoꞌiramu hegorovo uehorovoromo uvoruomoꞌajëjo: Rabëro ëꞌajëromo juhuonivoromo huë vavaene böröme baeruomoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Garöhe öꞌidöre inömoho ahoꞌo arua anumiae vaꞌiramu gagorovo nune örijanovoromo dë vövöbajoꞌe butubutumoromo uvoruomoꞌajëjo: Saꞌaho diehi diehi jioꞌiëꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Ëhi uvoromo garuomoꞌajëjo God-are A Maho naro darugoꞌo ajiꞌo böröme baeromo suere ruvebiꞌiramu. Ëhi jioꞌaꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Röhu ëhi jiëꞌe mu aevoromo jiëꞌiroho döro riravoromo sioroho garomo uvorëjo: God-ro nosi iꞌuꞌe muoho tugohoꞌi hesi sasohëꞌe muoho röjahuiꞌirögoro ëꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Iesuro ëhi uënugoromo ave uhu jöho uëvadeje. Mesohuꞌo ijo ioroꞌiorohuꞌo uehorovohëjo. ");
INSERT INTO aom_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Gavaruje hane gumutivego garomo evare jemë uvaruje höjo: Jew rajo nosi vama majaho iae dunovajëjo. ");
INSERT INTO aom_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Ëhesi bëhoho gaꞌirarije naehu uëvodëhi mue gö gö rovamu gavëꞌiroho uvoꞌaꞌarujëjo: No gaꞌiëꞌaruëjo God-ro böröme namiromo ahoꞌobëhe muebejavuego. ");
INSERT INTO aom_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Ave jöho na jö mae uëꞌiëꞌajëjo. Ave jaruvore raromaruje aribövioho bogo vuovëvo barëjëꞌiro naehu uëvaje muoho ahoꞌobëhe rueꞌaꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Öꞌidöe saꞌae bövie biseꞌe barëꞌi nasi jöho gemu bogo barëꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Röhu gavëꞌi raromorëjo. Nadi nimoronimorohoromo irunoꞌemuoho uehorovoromo vöröꞌe jovemuoho ueꞌahoromo simanoho sisërërovorëjo. O ave saꞌa hesi muohemu nadi uehorovoromo nurunurumorëjo. Ëhi ëꞌëꞌoho jemëhu bogo uehorovoꞌirarije majare evare nasi majahuro ma-majiohëvoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Öꞌehu mahu miꞌe ma-majioho baejajëhi majae höröjajire bevaꞌajire aëro ma-raromo jijihoꞌi gaꞌaꞌaruëjo nasi majaho ëhi ma-majioho rueꞌiramu. ");
INSERT INTO aom_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Aꞌi jemëro nune jioromo muebenövorëjo. Mueberomo God uanövorëjo: Ëhuë vavaeni maja rovëꞌiroho jero ajamuego no mae biririvoꞌirarëjo ëhuro mae javuobe vaꞌoromo jasi A Ma hesi nunire mae riravoꞌiröhe höjo. ");
INSERT INTO aom_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Iesuro ëhi majëhijadeje. Röhu hesi muoho aviëhi jionövadeje. Sisonuvoꞌego God-are amo börömore hiromo God-are jöho ae röjëhiromo vahiromoꞌego vaꞌoromo ajio Olives Dahorure ë hinövadeje. ");
INSERT INTO aom_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Ëhi ëꞌego sisonu sisonuꞌe ae ahoꞌobëhe rueromo God-are amo börömore gagovonövareje Iesuhu jövaje jöho heꞌiro. ");
INSERT INTO aom_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Jew rajehu Dë Huaje Oso Rumoꞌe I Ueꞌaharue Söröho dunovadeje. Sörö hesi iho göho God-hu Vörö Tugohade Söröhoje. ");
INSERT INTO aom_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Amo sörö majaho dunovamu priest masijohuꞌo Jew rajo jögoru öri röjëharue ariböviohuꞌo ëho jaburo Jew rajo a ioroꞌioroho juhuonëmiromo öre nahareje Iesu ma-saginiëri baeromo anego guomoröhego. ");
INSERT INTO aom_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Öre nahamu Judas hesi iho göho Iscariot-ro rovadeje. Iesuare ijoraje ae ahoꞌobëhe 12 röhu Judas hu jabesi gemuoho jiadeje. Judas hu Iesuare ijorajo jabesi gemuoho jiamu Satan-ro hesi dëre abueromo jöe bojamadeje. ");
INSERT INTO aom_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Jöe bojamamu Judas-ro vaꞌoromo priest a masijohuꞌo osa börömo muebejarue ariböviohuꞌo jöe jövadeje hu diehiꞌoromo Iesu ë aribövi jabesi övore bojëmego guduamoꞌiröhoho. ");
INSERT INTO aom_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Jöe jövamu hegorovo rueho jaburo nimorohoromo Judas uavareje: Iae mae höjo. Ëhi jiëꞌoho no monie mana bojamiꞌejarëjo. ");
INSERT INTO aom_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Bojamiꞌejarëjamu Judas-ro uëvadeje: Ëhi jiëꞌoho iae mae höjo. Iae mae hö uëromo vaꞌoromo öre nahadeje ae ahoꞌo bogojëvego evare Iesu a masijo jabesi övore bojëmiꞌiröhëro. ");
INSERT INTO aom_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Ëhiꞌamu iae Oso Rumoꞌe I Ueꞌaharue Sörö majaho rovadeje. Röhu ë maja rovëꞌiroho Jew rajëro sheep harihoho bijuëmarueje God-hu Vörö Tugohade Söröho iꞌiro. ");
INSERT INTO aom_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Sörö majaho rovamu Iesuro Peterꞌo Johnꞌo nugöꞌöjëvoromo uëvadeje: Vaꞌoromo söröho avohorego no ueꞌahoꞌirarëjo. ");
INSERT INTO aom_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Ueꞌahoꞌirarëjamu uavareje: Ja nagajoho no dinöꞌe vaꞌoromo söröho avohoꞌejarëjo. ");
INSERT INTO aom_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Avohoꞌejarëjamu Iesuro uëvadeje: Aveho hehëjo. Jerusalem amo börömoro vaꞌorëjo. Vaꞌi gaꞌaꞌarujëjo aëro jovoꞌe ramaho simanëro baeromo ro birohëvoꞌiramu. Ro birohëvego hesi ijoro ijoro vaꞌorëjo. Vaꞌoromo gaꞌirarije hu di osare rumo vaꞌego gagorovo jemëꞌo ë osaro vaꞌorëjo. ");
INSERT INTO aom_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Osaro vaꞌoromo osa arijoꞌoho uarëjo: Tisahuro jani uvade höjo: Osaho dinöꞌe höjo naehu nasi ijorajoho jabuꞌo gemu mae sörö iꞌirodoho. Ëhi uarëjo. ");
INSERT INTO aom_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Ëhi uaꞌiramu osa arijoꞌohuro jemë huꞌiraejëvo ajiomoromo döre osa börömoho röjëhiꞌaꞌajëjo. Röjëhiꞌiramu gaꞌaꞌarujëjo maratue bövie biseꞌe eni avohoromo bahijëꞌe jioꞌiramu. Ëhi jiamu gavëꞌiroho ë diröꞌoro söröho avohorëjo. ");
INSERT INTO aom_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Ëhi uëvamu rueho jaburo vaꞌareje. Vaꞌoromo gavare Iesuhu uëvadëhi ëhi jiamu gagorovo söröho avohareje. ");
INSERT INTO aom_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Ëhi ëꞌëꞌëro sörö majaho rovamu Iesuro hesi apostle ömoꞌömohuꞌo gemuore hijadeje ie iꞌirovo. ");
INSERT INTO aom_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Hiromo uëvadeje: Na nego avohajëjo God-hu Vörö Tugohade ë hesi Ioho jemëꞌo iꞌirovo ijonö viꞌehe baeromo guomevoröhego. ");
INSERT INTO aom_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Ëhesi bëhoho na uëꞌiëꞌajëjo. Na ijoho ë ioho bogo iꞌejöjo. Hujeji God-ro a nunire böröme namiromo ahoꞌobëhe muebejëvoꞌiramu sörö bëhoho vaꞌorahoro jioꞌiramu evare iꞌejöjo. ");
INSERT INTO aom_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Ëhi uënugoromo enatuore jovoho baeromo God mae uaromo hesi aribövioho uëvadeje: Aveho jemë ae gemu gemu ba ibe göëro göho bojamibe vaꞌorëjo. ");
INSERT INTO aom_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Aveho hehëjo. Na ijoho öꞌi bajo jovoho bogo iꞌejöjo. Hujeji God-ro rueromo a nunire böröme namiromo ahoꞌobëhe muebejëvoꞌiramu evare iꞌejöjo. ");
INSERT INTO aom_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Ëhiꞌonugoromo ioho baeromo God mae uanugoromo atoꞌatovoromo hesi aribövioho suvuorëmiromo uëvadeje: Aveho nasi sine höjo. Na nasi sinoho God-are örire bojamirovoꞌiëꞌajëjo jemë mae jëvoröhego. Aviëhi jiëꞌe muoho vaenövorëjo ëhuro na uehorovevoꞌirarije höjo. ");
INSERT INTO aom_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Ëhi ëꞌëꞌëro ioho ueꞌahonugoromo enatuore jovoho baeromo ëhi jiëꞌe mue gemuoho vaeromo hesi aribövioho uëvadeje: Ave enatuore jovo hesi bëhoho iae nasi köho jemëni rovevoꞌajëjo ëhuro God-hu muebejëvonövoröhe jögoru iꞌoho marëꞌiröhego. ");
INSERT INTO aom_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Iae ëhi höjo. Röhu gahëjo. Aehu na bijönegarue a jabesi övore bojëmiꞌiröhe ahuro naꞌo ie ijajëjo. ");
INSERT INTO aom_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","God-hu bamadëhi hesi A Maho na iae ëhi guomevoꞌajëjo röhu na bijönegarue a jabesi övore bojëmiꞌiröhe aho vaevëꞌoho sisërëꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Ëhi uëvamu hesi ariböviohuro uarovareje: Di aho noro ëhi jiëꞌe mu sisëho vaeꞌejarëjo. ");
INSERT INTO aom_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Ëhiꞌoromo Iesuare ijorajo ömoꞌömohuro jö ahoꞌahamirovoromo uarovareje: Di aho a nuniroho a börömoho javuajëjo. ");
INSERT INTO aom_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Ëhi uarovamu Iesuro uëvadeje: Saꞌa ioroꞌioro rajohuro jabesi saꞌa rajoho ruahöꞌöjëvoromo jabumëremu masije riravarue höjo. Riravoromo röhu jabesi jumuvorovoromo jabesi saꞌa rajoho uëvarue höjo: Uönövorëjo: Saꞌa aribövi ajamuijaruje a masije jëvajëjo. ");
INSERT INTO aom_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Röhu jemëꞌo nadi ëhioho döroho bamorovorëjo. Aꞌi ae rahu a börömo börömo jiëꞌoho ë aho jero ijorajonöꞌe jionövonëjo. O ae rahu simano vaejëꞌoho ë aho jero ae gö ajëmiꞌirane ae jionövonëjo. ");
INSERT INTO aom_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Röhu jemë diehi uehorovarujëjo. Di aho böröme jioꞌi di aho biseꞌe höjo. Na hiromo i ijaje aho börömoho höjo o ajëmiromo jabesi i ujuoho mëmijajoho börömoho höjo. Hiromo i ijaje aho iae börömoho höjo. O ajëmijaje aho ma-biseꞌe höjo. Na mae-ëjo. Röhu Iesu na ajëmiromo i ujuoho mëmijaje aho vaꞌëne jevajëjo. ");
INSERT INTO aom_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Na iꞌue bövie biseꞌe baeꞌego jemëro biririvoromo naꞌo jijihobe ruenövarije höjo. ");
INSERT INTO aom_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Nasi Vavuohuro darugoho bojemijade höjo naro böröme namiromo nasi aribövioho muebejëvoꞌirodego. Huhu ëꞌadëhi naro ëhi jemesi örire daruge bojëmijajëjo masije riravoꞌirarijego. ");
INSERT INTO aom_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Naro böröme namiromo nasi aribövioho muebejëvoꞌiramu jemëro naꞌo raromoromo ioho jovoho ueꞌahoꞌarujëjo. Ioho ueꞌahoromo jemë ae ahoꞌobëhe 12 naꞌo gemu mae arëto göro göro raromoromo Israel rajo nosi agane gö gö 12 jabesi muoho mevo gaꞌaꞌarujëjo gaꞌi mae o sisë jiego. ");
INSERT INTO aom_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Röhu Simon-ajo. Ave jöho hejëjo. Satan-ro God ua gavëꞌe höjo jemë baejëvoromo jemesi dëre bijëhoꞌirohëni. Ëhuni aehu i hijiohijiovoromo garuomaje diho mae jiego diho sisë jiego gavaruëhi Satan-ro ëhi jemesi dëre bijëho gëꞌaꞌajëjo gëꞌi rahuo darugoꞌoho jioꞌi rahuo darugo rumoꞌoho jiego. Amo Satan-ro ëhi ua gavamu God-ro jemë hesi övore bojëmijëꞌe höjo. ");
INSERT INTO aom_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Ëhi jie röhu Simon naro jani parie vaejëꞌe jevajëjo jero bogo uehorovevoromo vuonugoꞌiranego. Röhu ijonö Satan-hu jasi dë bijioho garomo barëjamu jaehu huotorovoromo nasi örire avoho uehorovevëꞌiroho jasi aganoho ajëmego biririvoꞌirarëjo. ");
INSERT INTO aom_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Biririvoꞌirarëjamu Peter-ro uavadeje: Bada iae ëhi höjo röhu na jaꞌo gemu mae juvoromo jaꞌo savoji gagore vaꞌëꞌoho o jaꞌo guomevëꞌoho iae na eni jevajëjo. ");
INSERT INTO aom_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Eni jevajëjamu Iesuro uavadeje: Peter röhu nasi jöho hejëjo. Jaruvo vahiꞌoho kökörökoho bogo uvëꞌe jero majae niöꞌi gemu ae uëꞌaꞌanuëjo: Na Iesu bogo gavaje höjo. ");
INSERT INTO aom_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Iae Iesuro hesi ijorajo ömoꞌömoho uëvadeje: Urimoho naro rëmöꞌöromo uëvode höjo: Monioho esöho bövioho biseꞌoho nadi ujuoho vaꞌorëjo. O höru sinoho nadi ioꞌamoromo vaꞌorëjo. Röhu na jemë bövi biseꞌo nimarijoho eni baejarije höjo o bogajo. Bogajamu uavareje: Iae no eni baejare höjo. ");
INSERT INTO aom_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Eni baejare höjamu Iesuro uhuꞌe uëvadeje: Urimoho aëro ajëmamu ëhi baejarije höjo röhu avevejöꞌoho bogo ëhioho jioꞌaꞌajëjo. Ëhuni monie o esöe jëvëꞌoho ujuohoromo vaꞌorëjo. O muorovoꞌirarije kaejö ëge bogojëvëꞌoho jemë döre ioꞌamaruje niögoho imoꞌamoromo monie mana ujuohoromo kaejö ëgoho imoꞌamorëjo. ");
INSERT INTO aom_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Ëhesi bëhoho hehëjo. God-ro ëhi bamade höjo hesi surire jö jajivarëhi ëhi jioröhego. God-are surire jajivoromo ëhi uvëꞌe höjo: Aëro uvoruomëꞌe höjo: Hu jö ahoruomaje ariböviohuꞌo gemuore höjo. Nasi jöho ëhi uvëꞌe höjo. God-are surire jö jajivarëhi iae ëhi jioꞌirögoro ëꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Ëhi jioꞌirögoro ëꞌajëjamu ijorajoho jaburo uavareje: Bada gavëjo. Aviae kaejö ëge niöꞌi javuajëjo. Kaejöe niöꞌi javuajëjamu uëvadeje: Ëhi jiëꞌe jöho iae minoꞌëjo. ");
INSERT INTO aom_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Ëhiꞌoromo Iesuro ë osaho vuonugoꞌi Olives Dahorure mamiꞌe vaꞌonövadire röhu maho ë vaꞌadeje. Vaꞌamu hesi ijorajoho jaburo hu rihiromareje. ");
INSERT INTO aom_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Rihiromoromo vaꞌo suorovoromo Iesuro uëvadeje: Ëninamihego God-ro ajëmego Satan-ro bogo dinëmego ëhuro bogo bejëvoꞌirajo. ");
INSERT INTO aom_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Ëhi uënugoromo roriꞌo vaꞌadeje. Munë buꞌöjego vaꞌo bejaje ëminoꞌe vaꞌoromo ague aho hiromo parie vaeromo uavadeje: ");
INSERT INTO aom_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Apajo. Ja nagëꞌoho iꞌue huë vavaene nasi örire rovajoho ahego na bogo baeꞌiröjo. Röhu naehu nimajoho nadi ëꞌi jaehu nimanuëhi ëhi ëꞌonëjo. ");
INSERT INTO aom_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Ëhiꞌamu gavëꞌi anerae gemuëro öꞌidöre jioromo rueromo Iesu ajamamu biririvadeje. ");
INSERT INTO aom_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Biririvoromo röhu huë vavaene bogo biseꞌo vaduꞌoho baeromo parioho maꞌeno titimoromo vaemu vaejadeje. Parie vaemu vaejamu nu anoꞌere jöho köe direjohijëꞌehu saꞌare ahajëhi ëhi ahoꞌamadeje. ");
INSERT INTO aom_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Parie vaenugoromo döro riꞌöjadeje. Riꞌöromo vuonoröꞌö vaꞌoromo gavadeje ijorajoho jabumë huë vavaene böröme baejëꞌëro momoröꞌöjamu. ");
INSERT INTO aom_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Momoröꞌöjamu gëgorovo uëvadeje: Jemë rabëni momoröꞌöjarujëjo. Riꞌöromo ëninamihëjo. Satan-ro dinëmiꞌiramu bejëvoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Ëhi uëvamu gavëꞌi ae ahoꞌobëhe Judas-ro öroho röjëhiromo sö ujuohoromo rovamu rueruomadeje. Iesuare ijoraje ahoꞌobëhe 12 röhu Judas huꞌo jabesi ae gemuoho jiadeje. Judas-ro rueromo Iesu dudöhoꞌi bëhire rovadeje. ");
INSERT INTO aom_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Dudöhoꞌi rovamu Iesuro uavadeje: Judas-ajo. Na God-are A Maho jevajëjo. Ja diehiꞌoromo ma-döëremuoho rajehiromo dudöhevanuëjo arue ariböviohuro guduamo baejevo vaꞌojöro. ");
INSERT INTO aom_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Ëhi uavamu Iesuare aribövie hesi bëhire riravaroho jaburo gavare a ioroꞌiorohuro mu sisë vaeꞌiaꞌamu gëgorovo uavareje: Bada na no kaejö ëgobövioho jijöromo muoꞌamoꞌejarëjo o diehiꞌoꞌejarëjo. ");
INSERT INTO aom_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Ëhi uaromo Iesuare ae gemuëro priest börömo hesi mu vaejaje aho anoromo övo manörire hiaꞌoho tariöꞌöjahadeje. ");
INSERT INTO aom_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Tariöꞌöjahamu Iesuro uavadeje: Ëhi jiëꞌe muoho vuonugëjo. Vuonugëꞌi ë anade a hesi hiaꞌi sionoho rëhamu marëjadeje. ");
INSERT INTO aom_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Marëjamu priest masijohuro God-are osa börömo atovarue ariböviohuro a duvahohuro Iesu guduamo bavaꞌi rovëꞌëro riravareje. Riravamu gagorovo Iesuro uëvadeje: Aveho na bogo vajiohuꞌe ananoꞌe aehu jevajëjo. Jemë rabëni siravaho kepataho ujuohoromo rovarujëjo. ");
INSERT INTO aom_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Mamiꞌe majae ahoꞌo naehu God-are amo börömore jemëꞌo hinövodoho jemë evaroho bogo guduamevarije höjo. Röhu jaruvoho jemesi majae höjo. Ramoramoꞌe mu muebejaje a hesi vöröho rovëꞌe höjo. ");
INSERT INTO aom_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Ëhi uëvamu Iesu guduamo barueromo priest börömo hesi osare rovareje. Priest hesi osare rueꞌirögoro Peter-ro arue riribövire Iesu rihiromoromo ijore rovadeje. ");
INSERT INTO aom_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Osare rueromo gavade aehu raromaruire vëne huëꞌëro ravoꞌego ae uono bëhire raromamu. Ae uono bëhire raromamu gagorovo jabuꞌo gemu mae hijadeje. ");
INSERT INTO aom_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Hijamu gagorovo mu ajëmijarue magonahe gemuëro gavade Peter uono bëhire hiꞌego nu anoꞌoho vënëro ajivëꞌe jiamu. Ajivëꞌe jiamu gavëꞌi Peter ërimahëꞌi ë aribövioho uëvadeje: Ave iaho huꞌo Iesuꞌo gemu mae juvonövade ae höjo. ");
INSERT INTO aom_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Juvonövade ae höjamu Peter-ro uavadeje: Sarerivanuëjo. Na ë iaho bogo mae bogo gavaje höjo. ");
INSERT INTO aom_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Bogo gavaje höjamu majae ma-bunemu jioromo barëjamu ae göëro Peter garomo uavadeje: Jaꞌo Iesuare ae javajëjamu Peter-ro uavadeje: Sarerivanuëjo. Na bogojevajëjo. ");
INSERT INTO aom_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Bogojevajëjamu hour gemu rabuꞌe barëjamu ae göëro biririvoromo ë aribövioho uëvadeje: Iae mae-ëjo. Iae na gavajëjo ave aho Iesuꞌo juvonövade ae höjo. Huꞌo Galilee saꞌa raje höjo. ");
INSERT INTO aom_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Ëhi uëvamu Peter-ro uavadeje: Sarerivanuëjo. Ja jövanue jöho na dadivevo avohajëjo. Dadivevo avohajëjamu kökörökoho uvadeje. ");
INSERT INTO aom_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Kökörökoho uvamu Badaro huotorovoromo Peter gavadeje. Gavamu gavëꞌi Peter-ro uehorovoromo uvadeje: O Badaro mamiꞌe uevade höjo: Jaruvo vahire kökörökoho bogo urimoho uvëꞌe jero urimo vae niöꞌi gemu ae uëꞌaꞌanuëjo: Na Iesu bogo gavaje höjo. ");
INSERT INTO aom_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Ëhi uevade hö uvoromo Peter-ro amonö hörö vaꞌoromo sisë maro nivadeje. ");
INSERT INTO aom_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Ëhiꞌamu iae Iesu mueberuomaje ariböviohuro Iesu sivoromo sino hahoꞌere anoꞌanovareje. ");
INSERT INTO aom_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Anoꞌanovoromo nu anoꞌe niögëro tugohahoromo uavareje: Na jö God-aro baeromo majëhijaje ae jevajë uövuanue javaje ëhuni anagade a hesi ihoho huruoho majahuijego no hejarëjo. ");
INSERT INTO aom_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Ëhi jiëꞌe jö sisë gö gö ahoꞌobëhe atoromo Iesu sivareje. ");
INSERT INTO aom_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Ëhi ëꞌëꞌëro sisonuvamu Jew rajo a duvaho ömoꞌömohuro priest masijohuro Jew rajo jögoru öri röjëhijarue ariböviohuro gagovorovoromo ae uëvareje: Iesu huꞌirae barovego no court vaejarëjo. ");
INSERT INTO aom_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Barovamu rue a masijohuro Iesu uavareje: Na ja God-hu uavëꞌëro böröme namiromo ajamuiꞌirane aho javajëjo. Ja ë aho javëꞌoho uövuego no hejarëjo. Hejarëjamu Iesuro uëvadeje: Na uëvëꞌoho röhu jemë bogo ma uehorovoꞌarujëjo. ");
INSERT INTO aom_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","O na jö uë gëvëꞌoho jemë bogo mana ueꞌaꞌarujëjo. ");
INSERT INTO aom_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Röhu majae dunovoꞌiramu evare God-are A Maho naro börömëro jevëꞌëro ajiomoromo God darugo eni jiëꞌe A hesi övo manö ëhi hiemu hiꞌejöjo. ");
INSERT INTO aom_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Hiꞌejöjamu rue a masijohuro uavareje: Ëhi jiëꞌoho na ja God-are Harihe javajëjo. Uëvadeje: Iae mae-ëjo. Jemëro jemesi uevarujëjo: Ja ëhi javajëjo. ");
INSERT INTO aom_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Ëhi javajëjamu rue a masijohuro uarovareje: Iesuro hesi jöꞌëro hesi jö sisëho majahuijamu iae mamiꞌe hejëꞌe javuajëjo. Ëhuni rabëni ae gö uëꞌejarëjo: Gavarije o hejarije jöho majahuijego no hejarëjo. Court-oho iae barëjajëjo. ");
INSERT INTO aom_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Ëhi uarovonugoromo ë a masijo ömoꞌömohuro riꞌöromo Iesu huꞌiraeromo Pilate-are nunire vaꞌareje. ");
INSERT INTO aom_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Vaꞌoromo Pilate-are nunire riravoromo Iesuare jö sisëho aevoromo huruoho majahijareje. Majahiromo uavareje: Iae no hejare höjo ë iaho sareriꞌe jöe majëhijavamu. Ëhi majëhijëꞌëro ëhuꞌëro nosi saꞌa rajohuro saꞌare a masijo jemesi jöho bogo eruomo hesi höjo. No hejare höjo Iesuro uvavamu: Rome a börömoho tax-oho nadi ijoho bojamirëjo ë hesi bëhoho saꞌare a börömoho na jevëꞌe jiaje. God-hu uevëꞌëro böröme namiromo ajëmiꞌirode aho Keriso na jevajëjo. ");
INSERT INTO aom_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Keriso jevajëjamu Pilate-ro Iesu uavadeje: Na ja Jew rajo jabesi a börömoho javajëjo. Börömoho javajëjamu Iesuro uavadeje: Ëjöho jero jasi jövanuëjo. ");
INSERT INTO aom_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Jövanuëjamu Pilate-ro priest masijohuꞌo a ioroꞌiorohuꞌo uëvadeje: Ave aehu iꞌu baeröhe hesi sisëho bogo birohëꞌe jevajëjo. ");
INSERT INTO aom_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Ëhi uëvamu hegorovo ae ahoꞌobëhe biririvoromo uavareje: Ëiahuro Galilee saꞌare aevoromo jö sisë ae röjëhiromo muorovojöro simane huotovëhobe Judea saꞌaho ahoꞌo juvoromo avehuꞌo rovëꞌe höjo. ");
INSERT INTO aom_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Ëhi uaruomamu hegorovo Pilate-ro uëvadeje: Na ë iaho Galilee saꞌa raje höjo. ");
INSERT INTO aom_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Galilee saꞌa raje höjamu rue ariböviohuro uavareje: Ioꞌajo. Ioꞌajamu hegorovo Pilate-ro uehorovoromo uvadeje: Herod hu Galilee saꞌa muebejaje ae höjo. Röhu hu aviae Jerusalem rovëꞌe höjo. Rovëꞌe hö uvoromo Iesu nugöꞌöjamu aëro bavaꞌareje Herod-ro court vaeröhego. ");
INSERT INTO aom_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Iesu bavaꞌamu Herod-ro garomo uehorovoromo uvadeje: Na mamiꞌe Iesuhu mu vaeꞌamade jöho hejëꞌëro gaꞌi nimobe rovëꞌe jevajëjo. Nani huro darugoꞌe muoho vaejehoꞌiramu na gaꞌejö uvoromo Iesu garomo nimoroho avohadeje. ");
INSERT INTO aom_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Nimorohoromo jöe ahoꞌobëhe Iesu ua gavadeje. Ua gavamu jöho bogo mana uavadeje. ");
INSERT INTO aom_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Bogo mana uavamu priest masijohuꞌo Jew rajo jögoru öri röjëhijarue ariböviohuꞌo ëho jaburo Herod-are nunire riravoromo Iesuare jö sisëho darugoꞌo huruoho majahijareje. ");
INSERT INTO aom_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Majahijamu Herod-ro heromo huꞌo hesi muorovo ariböviohuꞌo Iesu nue huodivoromo sisë vaeromo sivareje. Sivoromo Iesu niögu ëgo mabëhëro baꞌamahoromo nugöꞌöjamu sionëro Pilate-aro bavaꞌareje. ");
INSERT INTO aom_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Bavaꞌamu evare majae gemuore Herodꞌo Pilateꞌo urimo nu huodivorovaroho vuonugoꞌi huë baerovoromo ma-mae arijareje. ");
INSERT INTO aom_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Iesu barueruomamu gëgorovo Jew rajo priest masijoho ë saꞌare a masijoho a ioroꞌioroho ëho jabumëni Pilate-ro uvadeje gagovoromo raromojöro. ");
INSERT INTO aom_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Gagovamu gëgorovo Pilate-ro uëvadeje: Ëiaho jemëro barueromo uevarije höjo: Huro sareriꞌe jöho majëhijëꞌëro ae ahoꞌobëhe saꞌare masijo nosi jöho bogo e hesi jëvajëjo. Jemëro ëhi uevamu hejode höjo. Röhu naro jemesi nunire namiromo Iesuare jöho morijovoromo gavode höjo Iesuare jö sisëho uevarijoho bogojiamu. ");
INSERT INTO aom_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","O Iesu mae jiajoho Herod-ro huꞌo gavade höjo. Ëhi gagorovo sionëro nosi örire nugöꞌöjade höjo. Ëhuni aveho hehëjo. Hu mu sisë vaejëꞌëro mana anego guomoröhe bëhoho bogohöjo. ");
INSERT INTO aom_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Ëhuni naro ae uëꞌiramu hisuebiromo jiovo nugöꞌöꞌiramu vaꞌaꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Röhu God-hu Vörö Tugohade Sörö maja rovëꞌiroho savoji gagore raromarue aho gemu Pilate-ro Jew rajo ariböviohuni jiovo nugöꞌöjëhonövadeje hu bojamare muoho ëhi jiëꞌëro. ");
INSERT INTO aom_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Muoho ëhi jiamu ae ahoꞌobëhe ma-gemu mae uvoruomadeje: Ëiaho anëjo. Barabbas jiovahuëjo. ");
INSERT INTO aom_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Röhu Barabbas savoji gagore hijade hesi bëhoho urimëꞌi a masijohuꞌo amo börömoro muorovare majaho jiamu huꞌo muorovoromo ae anamu police ariböviohuro hu guduamo bavaꞌoromo savoji gagore baꞌamareje. ");
INSERT INTO aom_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Röhu Pilate-ro Iesu jiovo nugöꞌöꞌi nimamu jöe göꞌo majëhijadeje. ");
INSERT INTO aom_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Majëhijamu hejëꞌi ae ahoꞌobëhe uvoꞌi arijareje: Korosioro anego guomajo. Korosioro anego guomajo. ");
INSERT INTO aom_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Guomajamu Pilate-ro urimo vae niöꞌi röhu maho uëvadeje: Rabëniajo. Diehi jiëꞌe mu sisë vaejëꞌe höjo. Na gavajoho mu sisë ëꞌëꞌëro mana anego guomoröhe bëhoho bogohöjo. Ëhuni hisuebiromo jiovo nugöꞌöꞌejöjo. ");
INSERT INTO aom_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Jiovo nugöꞌöꞌejöjamu ae ahoꞌobëhe biririvoromo dinamiromo ma-darugoꞌo uvoꞌi arijareje: Korosioro anego guomajo. Ëhi uvamu jabesinö marëjadeje. ");
INSERT INTO aom_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Marëjamu jabuhu uvarëhi Pilate-ro jöho ëhi majëhijadeje. ");
INSERT INTO aom_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Urimo Barabbas-ro a sisë ioroꞌiorohuꞌo gemuoro buꞌöromo saꞌare a masijohuꞌo muorovoromo ae muoꞌamadeje. Ëhi ëꞌëꞌëro savojire raromadeje. Ëhi jiëꞌe a sisë jiadeje röhu Pilate-ro hejade Jew rajohuro Barabbas nimoromo uvoꞌi arijavamu hegorovo hesi mu aribövioho uëvadeje: Barabbas jiovo nugöꞌöꞌi jaburo nimëꞌe jiarue Iesu anohëjo. ");
INSERT INTO aom_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Anohëjamu aëro Iesu court-re jioromo anoꞌi bavaꞌareje. Bavaꞌoromo örire vaꞌi gavareje Cyrene amo raje ae gemu hesi ihe Simon muro jiëꞌëro Jerusalem rovamu. Rovamu gagorovo övëro maꞌenoromo korosioho hesi dejore bamoromo uavareje: Baeromo Iesuare ijoro vaꞌëjo. Vaꞌëjamu Simon-ro Iesuare korosioho bavaꞌadeje. ");
INSERT INTO aom_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Bavaꞌamu iae ae ahoꞌobëhe Iesu rihiromareje. Rihiromoromo magonaho ioroꞌiorohuro muoꞌamorovëꞌi nierusuburuꞌe bamobe rovareje. ");
INSERT INTO aom_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Nierusuburuꞌe bamobe rovamu gagorovo Iesuro hunuorovoromo uëvadeje: Jerusalem magonaho ömoꞌömohumë nadi nanioho vavaenimoromo nierusuburuꞌe bamoꞌi jemëꞌo jemesi aboji harihuꞌohuꞌo uehorovoromo nivoꞌamirovorëjo. ");
INSERT INTO aom_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Huë vavaene bogo biseꞌo vaduꞌoho rueꞌiramu aëro uvoruomoꞌajëjo: Dë tiojëꞌe magonahoho aboji harihu rumoꞌe raromarue magonahoho huë mae jëvajëjo. ");
INSERT INTO aom_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Ëhi uvoromo juhuonivoromo uvoruomoꞌajëjo: Dahoru masijoho ininoho jemëro ahoromo taemavuorëjo. Ëhi uvoruomoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Na ijo ma vaꞌëne jevajëjo röhu ije uejevanovaruëjo. Aꞌi jemë ijo sahonöꞌe huoꞌöjëvoromo baradore siöꞌöjëvoꞌamoꞌaruëjo. ");
INSERT INTO aom_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Iae mu sisë vaejare ae niöꞌioho guduamo ömëvo vaꞌareje Iesuꞌo gemu mae vuovëvoröhego. ");
INSERT INTO aom_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Vaꞌaroho ajiomoromo saꞌa ihe Simano Gijo ajio suorovareje. Suorovoromo Iesu baeromo korosire ano taemareje. Iesu ano taemoꞌi ë a sisëho niöꞌi jabuꞌo ano taemëvareje. Ano taemoromo ujuoho nigemoꞌamoromo Iesu ririre amoꞌi a sisë göho ruëhi Iesuare övo manö amoꞌi göho viëhi övo adonö amareje. ");
INSERT INTO aom_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Amamu Iesuro uavadeje: Apajo. Aehu nasi örire mu sisë vaejevaruoho uehorovoromo vuonugëjo. Jabumë ë mu hesi bëhoho dadibijiohajëjo. Dadibijiohajëjamu rue muorovo ariböviohuro Iesuare niögoho adovoromo ajajovoromo ae gemu niöge gemu ëhi baebe rovareje. ");
INSERT INTO aom_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","O ae ahoꞌobëhe riravoromo ërimahareje. Ërimahamu a masijohuro sivoromo uarovareje: Ëahuro uövuade höjo: Naro a ioroꞌioroho ajëmego marëjëvaje höjo. Ëhuni nadiꞌego hu hesi arijoꞌarije ajamirovego hu mae jiajo. Huro uövuade höjo: God-hu uevëꞌëro böröme namiromo ajëmiꞌirode aho na jevajëjo. God-hu nimoromo baejevade aho na jevajëjo. Ëhuni nadiꞌego hu hesi arijoꞌarije ajamirovajo. ");
INSERT INTO aom_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","A masijohuro ëhi sivamu muorovo ariböviohuro jabuꞌo Iesu sivareje. Sivoromo rueromo niogaꞌiꞌe wine jovoho bojamiꞌiëꞌareje. ");
INSERT INTO aom_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Bojamiꞌiëꞌoromo uavareje: Jew rajo jabesi a börömo javëꞌoho ëhuro jasi ajamirovego mae javajo. Sivoromo ëhi uavareje. ");
INSERT INTO aom_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Röhu Iesuare simano namore ijo viture jajivoromo uvëꞌe jiadeje: Ave aho Jew rajo jabesi a börömoho höjo. ");
INSERT INTO aom_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Iae korosire iromëꞌe a sisë göhuro Iesu sivoromo uavadeje: God-hu uavëꞌëro böröme namiromo ajamuiꞌirane aho ja javajëjo. Na mae-ëjo. Ëhi jiëꞌoho jasi arijoꞌarije ajamirovoromo noꞌo ajamuego mae javuajo. ");
INSERT INTO aom_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Ëhi uavamu a sisë göhuro uavadeje: Nadi ëhi jiëꞌe jöho jövëjo. Jaꞌo iꞌue gemuoho baejanuëjo. Ëhi jiëꞌoho ja diehiꞌoromo God bogo juhuonamijanuëjo. ");
INSERT INTO aom_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","No niöꞌiro mu sisë vaejëꞌëro ëhuꞌëro iae mae no iꞌue baeromo ëꞌaruëjo. Aꞌi ë iaho mu sisëho bogo vaejëꞌe höjo. ");
INSERT INTO aom_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Bogo vaejëꞌe höꞌi Iesu uavadeje: Iesuajo. A muebejavuoꞌirane darugo barueromo böröme namijëꞌiroho nasi öroro uehorovevonëjo. ");
INSERT INTO aom_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Uehorovevonëjamu Iesuro uavadeje: Aveho na jö mae uavajëjo. Jaruvoho jaꞌo naꞌo gemu mae Paradise-re ariꞌejarëjo. ");
INSERT INTO aom_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Iae majae ririre jiadeje. Majae ririre jiamu öri ariꞌe ahoꞌo ramoramovadeje. Ramoramovobe vaꞌojuvo majae huotorovamu gavëꞌi ajivadeje. ");
INSERT INTO aom_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Ajivamu gavëꞌi God-are osa börömo ojo göho gagonö jiajoho niögehu tugoharoho arorovadeje. ");
INSERT INTO aom_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Arorovamu gavëꞌi Iesuro God ma-darugoꞌo uavadeje: Apajo. Naro nasi aruꞌahoho jasi övo döre nugajëjo. Nugajëromo evare nugoꞌamadeje. ");
INSERT INTO aom_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Nugoꞌamamu muorovo a börömëro gavade ëhi jiëꞌe mue gö gö ëꞌamu gagorovo uvadeje: Iae mae-ëjo. Ëaho iae a mae jiade höjo. Ëhi uvamu ëhuro God-are ihoho mae jiadeje. ");
INSERT INTO aom_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Ae ahoꞌobëhe urimo ë mu börömo gaꞌi gagovarohuro gavare ëhi jiëꞌe mue gö gö ëꞌamu gagorovo vuonoröꞌöromo vavaenimoromo vinebe anobe vaꞌareje. ");
INSERT INTO aom_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Vaꞌamu Iesuare ariböviohuꞌo Galilee saꞌare jioromo Iesuare ijore ijore rovare magonaho ömoꞌömohuꞌo ëho jaburo roriꞌo riravoromo gavareje ëhi jiëꞌe mue gö gö ëꞌamu. ");
INSERT INTO aom_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Ëhiꞌamu ae gemu hesi ihe Joseph-ro iae hijadeje. Hu Arimathea amo raje jiadeje. Hu Jew rajo jabesi a duvahëro jiëꞌëro a masijo ioroꞌiorohuꞌo hiromo jöe mevonövadeje. Hu a mabëhe God-are jöho avoho ejahaje ae jiadeje. ");
INSERT INTO aom_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","A maëro jiëꞌëro ëhuꞌëro a masijo ioroꞌiorohuꞌo hiromo hejade uvoruomamu: Ëꞌego no Iesu anoꞌirarë uvoruomamu hegorovo bogo ejëhadeje. Bogo ejëhoromo gavade jaburo Iesu anamu gëgorovo uvadeje: Ëhi jiëꞌoho sisë höjo. Röhu huro muebejëꞌe hijadeje God-ro böröme namiromo ahoꞌobëhe muebejëvoröhego. Joseph ëhi jiëꞌe ae jiadeje. ");
INSERT INTO aom_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Ëhi jiëꞌe aëro jiëꞌëro huro vaꞌoromo Pilate uavadeje: Uevego na Iesuare sinoho baeꞌiröjo. ");
INSERT INTO aom_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Sinoho baeꞌiröjamu Pilate-ro ejahamu vaꞌoromo sinoho baruvebiromo niögu maëro numoromo munë ubuvarire ë bamadeje. Ëmunë gagoho ae gö bogo bamëꞌe Iesu ë bamadeje. ");
INSERT INTO aom_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Ëmajaho Friday jiëꞌëro Jew rajehu nuharue majaho rueꞌiëꞌadeje. ");
INSERT INTO aom_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Joseph-hu Iesuare sino bavaꞌoromo bamadevare evare Galilee saꞌare jioromo Iesuꞌo gemuore rovare magonaho ömoꞌömohuro Joseph-are ijore rueromo ubuvare munëho garomo gavareje Iesuare sinoho ë avoho bamamu. ");
INSERT INTO aom_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Iesuare sinoho ë avoho bamamu gagorovo vuonoröꞌö vaꞌoromo ridiꞌe ose gö gö avohoꞌamareje Iesuare sinore bahiꞌiröhëro. Avohoromo nuho majaho rovamu Jew rajo jögoroho eromo ma-nuhareje. ");
INSERT INTO aom_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Nuhëꞌëro hura börömore sueꞌo sueꞌo ë magonaho ömoꞌömohuro riꞌöromo ridiꞌe oso avoharoho ujuohoromo Iesu bamarire ë vuonoröꞌö vaꞌareje. ");
INSERT INTO aom_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Iesu bamarire vaꞌi gavareje munë gago tugohare munë börömoho roriꞌo höhö bavaꞌëꞌe jiamu. ");
INSERT INTO aom_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Höhö bavaꞌëꞌe jiamu gagorovo munë gagore rumo vaꞌareje röhu Bada Iesuare sinoho bogo birohareje. ");
INSERT INTO aom_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Bogo birohogoro ë riravoromo uehore gö gö baejareje. Uehore gö gö baejamu gavëꞌi ae niöꞌiro ma-majioho rovareje jabesi niögoho majaehu bamanovëꞌe ëhi ajivëꞌe niögoho ioꞌamëꞌëro. Rueromo ë magonaho jabesi bëhire rirarovareje. ");
INSERT INTO aom_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Bëhire ro rirarovamu gëgorovo rue magonahoho jaburo juhuonëmiromo uruhoꞌamo riravareje. Uruhoꞌamo riravamu gavëꞌi rue ae niöꞌiohuro uëvareje: Jemë rabëni iꞌovëꞌe aho guomëꞌe a sino bamaruiroho naharujëjo. ");
INSERT INTO aom_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Iesu aveho bogohöjo. Hu mamiꞌe riꞌöjëꞌe höjo. Riꞌöröhe jö Galilee saꞌare hiromo majëhijadoho uehorovohëjo. ");
INSERT INTO aom_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Huro jemë uëvade höjo: Aëro God-are A Maho na baejevoromo a sisë jabesi övore bojëmiꞌiramu baejevoromo korosire ano taemevoruomoꞌajëjo. Ano taemevoꞌiramu guomoromo majae niöꞌi gemu hesi uhure riꞌöꞌejöjo. Nasi muoho God-ro ëhi bojemëꞌe höjo. Iesuro ëhi uëvamu hejarije höjo. ");
INSERT INTO aom_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Hejarije höjamu rue magonahoho jaburo ë jöho uehorovareje. ");
INSERT INTO aom_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Uehorovoromo Iesu bamarire jioromo vuonoröꞌö vaꞌareje. Vaꞌoromo rabe rabe gavare hejare jöho majëhijamu Iesuare ijoraje 11-ho jabuꞌo Iesuare aribövi ioroꞌiorohuꞌo ë jöho heruomadeje. ");
INSERT INTO aom_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Röhu ë jö majëhijare magonaho jabesi ihoho Mary Magdalene o Joanna o James-are vëme Mary ëhi jëvadeje. Ëmagonahohuꞌo magonaho ioroꞌiore jabuꞌo gemu mae jijiharohuꞌo ëho jaburo ë jöho apostle aribövioho majëhijareje. ");
INSERT INTO aom_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Majëhijamu hegorovo rue apostle ariböviohuro uvareje: Ëmagonahoho jaburo ë jöho ëma ataruëromo bogo ma uehorovareje. ");
INSERT INTO aom_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Bogo ma uehorovoromo röhu Peter-ro riꞌöromo sino bamarire tutuvoromo ë vaꞌadeje. Vaꞌoromo munë gagoho hohitohoromo gavadeje Iesu numare niögohemu jioꞌamamu. Niögohemu jiamu gagorovo uehorovoromo uvadeje: Aveho diehiꞌade hö uvoromo hesirëro vuonoröꞌö vaꞌadeje. ");
INSERT INTO aom_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Vaꞌëꞌëro jeniromamu Iesuare ae niöꞌiro Emmaus amore vaꞌirögoro örire vaꞌareje Jerusalem jioromo Emmaus vaꞌiröhe öri hesi vahuoho 11 kilometre jiëꞌëro. ");
INSERT INTO aom_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Örire vaꞌoromo mu rabe rabe jiade jöho jörovobe vaꞌareje. ");
INSERT INTO aom_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Jöho jörovoromo berohobe vaꞌamu Iesuro birohëvoromo jabuꞌo gemu mae vaꞌadeje. ");
INSERT INTO aom_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Vaꞌamu ë ae niöꞌi jabesi uehoroho tugohëhamu bogo avoho garomo uvareje: Ëho Iesu höjo. ");
INSERT INTO aom_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Bogo avoho gavamu Iesuro uëvadeje: Jemë diehi jiëꞌe jöho jörovobe jireharujëjo. Jireharujëjamu rueho jaburo jireharoho vuonugoꞌi nu anoꞌe sisëꞌirërovoromo rirarovareje. ");
INSERT INTO aom_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Rirarovoromo ae gemu hesi ihe Cleopas-ro uavadeje: Ae ahoꞌobëhe Jerusalem raromaruohuro avevejöꞌe rabehu ëꞌadoho iae garuomoꞌi ja gemu diehiꞌavoꞌego bogo gavanuëjo. ");
INSERT INTO aom_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Bogo gavanuëjamu Iesuro uëvadeje: Diehi jiëꞌe muohajo. Uavareje: Nazareth raje Iesuare örire vaejare jöho uavaruëjo. Iesu hu jö God-aro baeromo no majahuijaje ae jiade höjo. Ëhi jiëꞌe aëro jiëꞌëro God-are nunire o ae ahoꞌobëhe nosi nunire namiromo biririꞌe muoho vaenövo biririꞌe jöho jövonövade höjo. ");
INSERT INTO aom_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Iesu hu ëhi jiëꞌe ae jiade höjo. Röhu nosi priest masijohuꞌo nosi a masijo ioroꞌiorohuꞌo ëho jaburo Rome aribövi jabesi övore bojëmijare höjo ëhuro ëho jaburo court vaeromo Iesu anoꞌiröhe jöho uëröhego. Rome aribövi jabesi övore bojëmamu ëhuro Iesu korosire ano taemare höjo. ");
INSERT INTO aom_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Röhu noro uehorovoromo uvare höjo: Ëaho nani God-ro nugöꞌöjade höjo rueromo no ajamuiromo Israel rajo nosi iꞌuꞌe muoho ahavuoꞌi hesi sasohëꞌe muoho röjahuiröhego. No ëhi uehorovare höjo. Röhu jöe göꞌo ë mu sisë vaeruomadoho majae niöꞌi barëjamu röhu aveho majae göho rovëꞌe höjo. ");
INSERT INTO aom_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Iae ëhi höjo röhu noꞌo gemu mae Iesuare ijore ijore jijiharue magonahohuro ave jö börömoho majahuijamu hegoro no tiöjavuade höjo. Jaburo jaruvo sueꞌo riꞌöromo Iesu bamarire vaꞌare höjo. ");
INSERT INTO aom_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Vaꞌoromo gavare höjo Iesuare sinoho bogojiamu. Bogojiamu gagorovo vuonoröꞌö rueromo uövuare höjo: No vaꞌoromo niaꞌovoꞌiraejanovoromo garomo hejare höjo aneraho jaburo uövuamu: Iesu bogo guomoꞌi iꞌovëꞌe höjo. Magonahoho jaburo ëhi uövuamu hejare höjo. ");
INSERT INTO aom_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Jöho henugoromo nosi ae göëro göëro Iesu bamarire vaꞌoromo gavare höjo magonahehu uövuadëhi ëhi jiamu. Röhu Iesu bogo gavare höjo. ");
INSERT INTO aom_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Iesu bogo gavare höjamu Iesuro riꞌöromo ë ae niöꞌioho uëvadeje: Asëꞌe jemë simane iꞌuhëgoꞌego God-are jöho bogo ma-burëroho baejarujëjo. Ëhuꞌëro jiëꞌëro jö God-aro baeromo majëhinövare a jabesi jöho bogo maho uehorovarujëjo. ");
INSERT INTO aom_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Jemë diehiꞌoromo ave jöho bogo uehorovarujëjo. God-ro bamade höjo böröme namiromo ajëmiꞌiröhe aho viꞌehi böröme baeromo guomojöro röhu ijonö ajiꞌere ajio hiröhego. ");
INSERT INTO aom_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Ëhi uënugoromo Iesuro hesi jöe God-are surire jajivoꞌamadoho huruoho majëhi barëjadeje. Moses-hu jajivade jöho aevoꞌi majëhiromo jö God-aro baeromo majëhinövare a ioroꞌiorehu jajivoꞌamade jöhuꞌo huruoho majëhijadeje. Majëhijamu rue ae niöꞌiohuro hebe vaꞌareje. ");
INSERT INTO aom_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Hebe vaꞌaroho vaꞌi nimare amore höröꞌiëꞌareje. Höröꞌirögoro Iesu öre ëgoꞌo vaꞌo hesi jiamu gagorovo ");
INSERT INTO aom_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","rueho jaburo nijioꞌiraeromo uavareje: Nadi vaꞌi noꞌo hijëjo. Majae mamiꞌe barëjëꞌëro vahiromavuoꞌiëꞌajëjo. Vahiromavuoꞌiëꞌajëjamu ejëhoromo jabuꞌo vaꞌoromo osare hijadeje. ");
INSERT INTO aom_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Hiromo jabuꞌo ie iꞌirögoro saꞌaro hiromo ie baeromo God mae uaromo atoꞌatovoromo iꞌimëmamu rueho jaburo baejareje. ");
INSERT INTO aom_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Baeromo God-ro jabesi simanoho jiovëhamu evare Iesu avoho garomo uvareje: Ojoꞌe ë aho Iesu höjo. Iesu höromo gaꞌi gavareje Iesu ëma bogojio vaꞌamu. ");
INSERT INTO aom_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Vaꞌamu gagorovo uarovareje: Jaꞌo uehorovëjo. Ëahuro noꞌo jöe jövoromo God-are suri bëhoho huruoho majahuibe örire rovamu heromo nosi dë vövöbajoꞌoho sasohavuoromo riꞌöjavuo avohade höjo. ");
INSERT INTO aom_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Ëhi uarovoromo ma-burëro sionëro vuono buꞌöromo Jerusalem amore vaꞌareje. Jerusalem vaꞌoromo gavare Iesuare ijoraje 11-huꞌo jabesi a ioroꞌiorohuꞌo gagovoromo raromëꞌe jiamu. ");
INSERT INTO aom_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Raromëꞌëro jaburo ë ae niöꞌioho uëvareje: Bada iae riꞌöjëꞌe höjo. Riꞌöromo Simon-are örire rovamu huro gavade höjo. ");
INSERT INTO aom_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Gavade höjamu rue ae niöꞌiohuro uëvareje: Noro niöꞌiro örire jirehoromo ëhi ëhi gavare höjo. Ëhi uëromo uëvareje: Iesuro ie atoꞌatovoromo iꞌimamuamu evare no avoho garomo uvare höjo: Iae Bada höjo. ");
INSERT INTO aom_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Bada höjamu gavëꞌi Iesuro ro ma-majioho jabuꞌo gemu mae namijadeje. Namiromo uëvadeje: Aganomë vaevëꞌe raromarujëjo. ");
INSERT INTO aom_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Vaevëꞌe raromarujëjamu juhuonivoromo jioduduꞌiraeromo uvareje: No aruꞌahe gavaruëjo. ");
INSERT INTO aom_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Aruꞌahe gavaruëjamu uëvadeje: Jemë rabëni juhuonivarujëjo. Rabëni uehore gö gö baejarujëjo. ");
INSERT INTO aom_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Ave nasi övoho höroho geromo uvorëjo: Nörö höjo. Maꞌenego heromo uvorëjo: Nörö bogo aruꞌahemuoho jioꞌi a mae höjo. Aruꞌahoho sine ijoꞌahe bogohöjo. Röhu jemë iae gevarujëjo na sinoꞌe ijoꞌahoꞌe jevoꞌego. ");
INSERT INTO aom_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Ëhi uënugoromo övohuꞌo hörohuꞌo röjëhijamu gavareje. ");
INSERT INTO aom_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Garomo uehorovemu uehorovoꞌi arijareje. Uehorovoromo uvareje: Aveho mu ma-mabëhe jiëꞌe nani noro sisëꞌi gavaruëromo bogo ma uehorovareje. Bogo ma uehorovamu gavëꞌi Iesuro uëvadeje: Na jemë ioho jëvajëjo o bogojëvajëjo. ");
INSERT INTO aom_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Ëhi uëvamu visue vënire buejëꞌoho babojamareje. ");
INSERT INTO aom_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Babojamamu Iesuro baeromo ae ahoꞌobëhe jabesi nunire ijadeje. ");
INSERT INTO aom_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Iromo uëvadeje: Urimo naehu jemëꞌo hiromo majëhijamu hejarije jöho iae avevejöꞌe röhu maho majëhiꞌirögoro ëꞌajëjo. Na uëvode höjo: Nasi jöho ahoꞌobëhe Moses-hu jajivadoho jö God-aro baeromo majëhinövare a ioroꞌiorehu jajivaroho Psalms jö jajivaroho nasi jöe ahoꞌobëhe God-are surire jajivarëhi iae ëhi jioꞌaꞌajëjo. Öre gö bogohöjo. Ëhi uëvamu hejarije höjo. ");
INSERT INTO aom_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Hejarije hö uëromo jabesi simanoho huotovëhamu God-are surire jö bëhoho avoho gavareje. ");
INSERT INTO aom_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Avoho gavamu huro uëvadeje: God-are surire jajivoromo ëhi uvëꞌe höjo: God-ro bamëꞌëro böröme namiromo ajëmijaje aho nörö viꞌehi böröme baeromo guomoromo majae niöꞌi gemu hesi uhure riꞌöꞌaꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Riꞌöꞌiramu aëro nöruare ihore jöe majëhiromo ae uëꞌaꞌaruëjo: Ae ahoꞌobëhe öri sisëre jijiharujoho vuonugohëjo. Mu sisëho vuonugoꞌi avoho uehorovoromo mu mae vaehego God-ro jemesi sisëho uehorovoromo vuonugajo. Ëhi jiëꞌe jöho Jerusalem amore aevoromo majëhiromo maja rojomajire bevaꞌajire saꞌare saꞌare majëhibe jijihoꞌaruëjo. God-are surire jöho ëhi uvëꞌe höjo. ");
INSERT INTO aom_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Röhu ëhi jiëꞌe muoho jemë gavëꞌe jëvaje ëhuni ë jöho majëhibe jijihorëjo. ");
INSERT INTO aom_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Röhu aveho hehëjo. Urimo nasi Vavuehu hesi Aruꞌaho suvuorëmiꞌi mae uëvadëhi naro ë Aruꞌaho suvuoroho jemëni nugöꞌöꞌiramu baeꞌaꞌarujëjo. Ëhuni ë hesi urimo jemëro vaꞌoromo Jerusalem amohuremu raromorego hujeji God-are darugohuro ruvebiromo ruahöꞌöjëvoꞌiröhe höjo. God-are darugohuro ruvebiromo ruahöꞌöjëvoꞌiramu evare vaꞌoromo nasi muoho vaeꞌaꞌarujëjo. ");
INSERT INTO aom_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Ëhi uënugoromo sö ujuohoromo Bethany amonö vaꞌadeje. Vaꞌoromo övoho nigemëvoromo uëvadeje: God-ro jemë huë mae bojëmiꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","God-ro jemë huë mae bojëmiꞌajë uëromo God-ro uavamu jabumë ë rëmoꞌi huro öꞌidöre ajiomadeje. ");
INSERT INTO aom_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Ajiomamu gagorovo rue Iesuare ariböviohuro hu rajahiromo börömo bëhe nimorohobe Jerusalem vuonoröꞌö vaꞌareje. ");
INSERT INTO aom_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Vaꞌoromo raromoromo God-are osa börömore vaꞌoromo majae ahoꞌo God rajahinövareje. Ahia minoꞌe. ");
INSERT INTO aom_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Niꞌiꞌivade majaroho ae gemu hesi ihoho God-are Jö jumuvëꞌoho iae hijëꞌe jiadeje. Hu Godꞌo gemu mae hiꞌi huꞌo God jiadeje. ");
INSERT INTO aom_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Niꞌiꞌivadire ë aho Godꞌo gemu mae hijëꞌe jiadeje. ");
INSERT INTO aom_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","God-ro uavamu huro saꞌae bövie biseꞌe bamadeje. Bogo bamoꞌibejo bövioho biseꞌoho bogo mae bogojioꞌibejo. ");
INSERT INTO aom_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Darugoho ahoꞌo hesirire gemu jioromo rovadeje. Rueromo ae ahoꞌo ajoho bojamuadeje. ");
INSERT INTO aom_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Ëajohuro ramoramore ajivajeje. Ramoramoho ajoho bogo tugohëꞌeje. ");
INSERT INTO aom_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Ae gemu God-ro nugöꞌöjamu rovadeje. Hesi ihoho John jiadeje. ");
INSERT INTO aom_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Hu rovadeje aji hesi bëhi gavadoho huruoho majahuiꞌiröhëro. Majahuijego ae ahoꞌobëhe hesi jöho heromo mae uehorovoꞌiröhego. ");
INSERT INTO aom_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Hu bogo ajoho jiadeje. Aꞌi huro aji hesi bëhoho majahuiꞌi rovadeje. ");
INSERT INTO aom_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Ëajoho iae aji maho jiohijo. Evare majare ë aje ae ahoꞌobëhe ajivavuajohuro saꞌare ruehijo. ");
INSERT INTO aom_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Amo God-are Jö jumuvade ahuro ave saꞌare hijadeje. Urimëꞌi God-ro uavamu ave saꞌaroho avohoꞌamadeje röhu ave saꞌare ariböviohuro hu bogo avoho garuomadeje. ");
INSERT INTO aom_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Hu hesiro rovadeje röhu hesi aribövi mahuro hu bijönimoruomadeje. ");
INSERT INTO aom_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Röhu hesi a ioroꞌiorohuro hu nimoromo mae uehorovoruomadeje. Mae uehorovoruomamu ëhuni uëvadeje: Avevejöꞌe jemë God-are aboji harihuꞌe raejëvajëjo. ");
INSERT INTO aom_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","God-are aboji harihuꞌe raejëvade hesi öroho bogo aehu nimoromo baejëvamu iꞌoroho rahëvoꞌi aꞌi God-ro baejëvëꞌëro ëhuro hesi aboji harihuꞌe jëvadeje. ");
INSERT INTO aom_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Röhu God-are Jö jumuvëꞌe ahuro sino hahoꞌe baeromo ro God-are jöho mae röjahui avohoromo huë baejavuo avohoromo noꞌo gemu mae hibe juvadeje. Hi juvamu no hesi ajoho gavareje ë ajoho hesi Vavu hesi Harihe hu gemuꞌëro jiëꞌëro baejëꞌëro. ");
INSERT INTO aom_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Ëhiꞌamu gagorovo John-ro ë a hesi jöho ae huruoho majëhijadeje. Majëhiromo ma-darugoꞌo uvadeje: Naehu uëvode aho aviae höjo. Na mamiꞌe uëvode höjo: Naro urimo rovëꞌe jevajëjo. Ae gemuëro nasi ijonö rueꞌiëꞌajëjo. Ëhi höjo röhu ë ahuro na iosiremiromo hu börömoho höjo na bogo rahevadevare hu jiobe rovëꞌëro jiëꞌëro. Ëhi uëvadeje. ");
INSERT INTO aom_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Iae hu huë baejavuo avohëꞌëro ëhuꞌëro huë mae no ae ahoꞌobëhe bojamuiromo döre döre bojamuibe rovëꞌeje. ");
INSERT INTO aom_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Mu vaeꞌiröhe jögoroho God-ro uavamu Moses-ro bojamuadeje. Aꞌi God-ro uavamu Iesu Kerisoro huë baejavuoromo God-are bëhoho maemu röjahuijadeje. ");
INSERT INTO aom_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Aho God bogo mae bogo gavëꞌe javue. God Harihoho gemu Vavu hesi bëhi mare hijaje aëro jiëꞌëro huro God röjahuijëꞌeje. ");
INSERT INTO aom_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Röhu Jerusalem raromarue Jew rajo a masijohuro priest ömoꞌömohuꞌo priest ajëmijarue a ömoꞌömohuꞌo uëvareje: Vaꞌirarijoho John uarëjo: Ja rahuo javajëre. Ëhi uëvamu vaꞌoromo ë jöho ua gavamu huro aviëhi jiëꞌe jöho majëhijadeje. ");
INSERT INTO aom_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Hu bogo jöho subivëhoꞌi samaꞌe huruoho majëhiromo uëvadeje: Na bogo böröme namiromo ajëmiꞌirode aho jevajëjo. ");
INSERT INTO aom_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Uavareje: Ëhi jiëꞌoho na ja Elijah javajëjo. Uëvadeje: Bogajo. Uavareje: No muebejaruëjo a börömohuro jöe God-aro barueromo majahuiꞌiröhego. Na ja ë aho javajëjo. Uëvadeje: Bogajo. ");
INSERT INTO aom_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Uavareje: Ëhi jiëꞌoho ja rahuo javajëjo. Majahuijego no vaꞌoromo ramuöꞌöjamu rovare aho majëhiꞌiröhe höjo. Jasi jöho ja diehi jövanue höjo. ");
INSERT INTO aom_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Diehi jövanue höjamu John-ro uëvadeje: Na a rumoꞌe saꞌare hiromo aviëhi jiëꞌe jöho ma-darugoꞌo majëhijaje ae jevajëjo. Badahu rueröhe öroho ahorirëro vajivahorego hu maro rueꞌirajo. Urimëꞌi jö God-aro baeromo majëhinövade ae Isaiah-ro ë jöho jajivadeje. Ëho John-ro uëromo ëꞌadeje: Isaiah-hu jajivade jö hesi muoho iae na vaeromo ëꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Ëhi jövamu rueho jaburo Pharisee a masijohuro rëmöꞌöjamu rovëꞌëro ");
INSERT INTO aom_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","uavareje: Ja bogo böröme namiromo ajamuiꞌirane aho javajëjo bogo Elijah javajëjo bogo jö God-aro baeromo majahuijanue a börömoho javajëjo röhu ja diehiꞌoromo aho bapataeto vaejëvanue höjo. ");
INSERT INTO aom_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Vaejëvanue höjamu John-ro uëvadeje: Naro jovëro bapataeto vaejëvaje höjo. Röhu jemëhu bogo gavaruje aho jemesi ririre namijajëjo. ");
INSERT INTO aom_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Huro nasi ijonö rueꞌiëꞌajëjo röhu huro na iosiremiromo börömoho höjo. Naehu hesi mu biseꞌo vaejahoromo hesi höru sino jiovahoꞌibejodoho o mu biseꞌo biseꞌe rabe vaejahoꞌibejodoho na ma-biseꞌe jevajëjo. John-ro ëhi uëvadeje. ");
INSERT INTO aom_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Johnꞌo Jerusalem jioromo rovare ariböviohuꞌo jö ëhi vaerovaroho ëho Bethany jiadeje. Bethany amoho Jordan jovo ruhëhi jiadeje. Ësaꞌare Jordan jovore John-ro ae bapataeto vaejëvonövadeje. ");
INSERT INTO aom_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Nërö John-ro gavade Iesu rovamu gagorovo ae uëvadeje: Arueho gahëjo. Sheep harihu muoꞌamamu God-hu mu sisë roriꞌo babuꞌöjadëhi ëhi ë ahuro saꞌae gö gö ahoꞌobëhe nosi sisëho roriꞌo babuꞌöꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Ëa hesi jöho na mamiꞌe majëhijode höjo. Majëhiromo uëvode höjo: Naro urimo rovëꞌe jevajëjo. Ae gemuëro nasi ijonö rueꞌiëꞌajëjo. Ëhi höjo röhu huro na iosiremiromo hu börömoho höjo na bogo rahevadevare hu jiobe rovëꞌëro jiëꞌëro. Ëhi majëhijode höjo. ");
INSERT INTO aom_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Mamiꞌoho na hu bogo avoho gavode höjo. Röhu naehu rueromo jovehu bapataeto vaejëvode hesi bëhoho ëho naro hu röjëhijego Israel aribövioho jemëro gaꞌirarijego ëhuni ëꞌode höjo. ");
INSERT INTO aom_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","O ave jöho John-ro gavëꞌëro huruoho majëhiromo uëvadeje: Naro gavode höjo God-are Aruꞌahe guaho vaꞌënohuro öꞌidöre jioromo ë a hesi simano namore ruvebiromo gerejamu. ");
INSERT INTO aom_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Mamiꞌe na hu bogo gavode höjo röhu naehu jovehu bapataeto vaejëvojöro uevadohuro uevade höjo: Gaꞌirane Aruꞌahohuro ruvebiromo di a hesi simanore gerejamu gavëꞌoho uvonëjo: Ëahuro God-are Aruꞌaho Mahuro ëhuro bapataeto vaejëvoꞌajëjo. Vavuohuro ëhi uevamu hejëꞌëro ijonö gavode höjo Aruꞌahoho ruvebiromo ë a hesi simanore gerejamu. ");
INSERT INTO aom_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Ëho nasi nunëro gavode höjo. Gavëꞌëro naro jemë uëvajëjo: Arue aho God-are Harihe höjo. ");
INSERT INTO aom_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Ëhi uëvëꞌëro nërö John-ro röhu maho ë rueromo hesi ijorajoho niöꞌi jabuꞌo gemu mae namijadeje. ");
INSERT INTO aom_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Namiꞌi gavade Iesu rovaꞌamu gagorovo ijorajo niöꞌioho uëvadeje: Arueho gahëjo. God-are Sheep Harihoho iae jiajëjo. ");
INSERT INTO aom_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Ëhi uëvamu hegorovo rueho jaburo John nugoꞌi Iesuare ijore vaꞌareje. ");
INSERT INTO aom_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Iesuare ijore vaꞌamu huro huotorovoromo gëvade ë ae niöꞌioho hesi ijore rovamu gëgorovo uëvadeje: Jemë rabe naharujëjo. Rabe naharujëjamu jabesi huëro uavareje: Rabae ja dinöꞌe hijanue höjo. Röhu Rabae uavaroho ëho uaromo ëꞌareje: Röjahuijanue a börömohajo. ");
INSERT INTO aom_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Rabae ja dinöꞌe hijanue hö uavamu hegorovo Iesuro uëvadeje: Rueromo gahëjo. Gahëjamu hegorovo majae garoboꞌe bamamu huꞌo vaꞌoromo hu hijaje osaho gavareje. Garomo huꞌo arijuvo vahiromamu vaꞌareje. ");
INSERT INTO aom_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Ae niöꞌiohuro John-are jöho hejëꞌëro Iesuare ijore rovare a gö hesi ihoho Andrew Simon Peter-are öho jiadeje. ");
INSERT INTO aom_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Andrew-ro ma-burëro hesi öho Simon naho vaꞌoromo birohoromo uavadeje: Böröme namiromo ajamuiꞌiröhe aho noro birohëꞌe javuajëjo. Böröme namiromo ajamuiꞌiröhe aho Greece huëhu huotovëꞌoho Kerisoje. ");
INSERT INTO aom_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Böröme namiromo ajamuiꞌiröhe aho birohëꞌe javuajëromo Simon huꞌirae baeromo Iesu gaꞌiro rovadeje. Rovamu Iesuro hu garomo uavadeje: Ja Simon John-are harihe javajëjo. Jasi ihoho Cephas jioꞌaꞌajëjo. Hebrew huëhu Cephas huotovëꞌoho Greece huëho Peter-je. Ëiho hesi bëhoho munëje. ");
INSERT INTO aom_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Ëhi ëꞌëꞌëro nërö Iesuro uvadeje: Jaruvo na Galilee saꞌare ajiomoꞌejöjo. Ajiomoꞌejö uvonugoromo ajiomadoho ajio Philip birohadeje. Philip birohoromo uavadeje: Nasi ijoro ijoro rovëjo. ");
INSERT INTO aom_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Röhu Philip hu Bethsaida amo rajo ae jiadeje. Andrewꞌo Peterꞌo jabuꞌo ame gemuoho jëvadeje. ");
INSERT INTO aom_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Ëhiꞌamu Philip-ro Nathanael naho vaꞌoromo birohoromo uavadeje: Urimëꞌi Moses-ro hesi jögoru surire uövuade höjo: Ijonö a böröme rueꞌaꞌajëjo. O jö God-aro baeromo majëhinövare ariböviohuro jöe gemuoho jajivoromo uönövare höjo. Ërueröhego jajivoruomade aho iae no birohëꞌe javuajëjo. Hesi ihoho Iesu höjo. Hu Joseph-are harihe höjo. Hesi amo ihoho Nazareth höjo. ");
INSERT INTO aom_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Nazareth höjamu Nathanael-ro uavadeje: Asëꞌe a maho ëhi jiëꞌe amoroho bogo rue hesi höjo. Bogo rue hesi höjamu Philip-ro uavadeje: Jaꞌo ro gavëjo. ");
INSERT INTO aom_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Ëhiꞌamu Iesuro gavade Nathanael rovamu gagorovo ae uëvadeje: Arueho gahëjo. Israel rajo a ma-maëro rovajëjo. Hesi uhuroho sareriꞌe jöho bogohöjo. ");
INSERT INTO aom_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Ëhi uavamu Nathanael-ro uavadeje: Ja diehiꞌoromo na gevanue höjo. Gevanue höjamu Iesuro uavadeje: Jaehu ruejöro Philip-hu uavade hesi urimo ja meso gurutore hijamu gavode höjo. ");
INSERT INTO aom_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Gavode höjamu Nathanael-ro uavadeje: Tisa ja God-are Harihe javajëjo. Ja böröme namiromo Israel rajo muebejavuanue aho javajëjo. ");
INSERT INTO aom_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Muebejavuanue aho javajëjamu Iesuro uavadeje: Na uavode höjo: Ja meso gurutore hijamu gavode höjo. Ëmu harihu vaejode jöho uavamu hejëꞌëro jero mae uehorovevanuëjo. Röhu uꞌemu mu masijo maho gaꞌamoꞌanuëjo. ");
INSERT INTO aom_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Ëhi uanugoromo uëvadeje: Ave jöho na jö mae uëꞌiëꞌajëjo. Jemë iae gaꞌaꞌarujëjo öꞌidöho arorovoꞌi God-are A Ma naehu jiajire God-are anerahuro iojiomoromo ruvebiꞌi ariꞌiramu. ");
INSERT INTO aom_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Majae niöꞌi gemu hesi uhure iae masurovoꞌiröhe söröho Cana amore Galilee saꞌare avohareje. Avohamu Iesuare vëmohuro ë hijadeje. ");
INSERT INTO aom_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Iesuꞌo hesi ijorajoho jabuꞌo söröre ruejöro uëvëꞌëro ë ro raromareje. ");
INSERT INTO aom_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Raromoromo söröꞌe ariböviohuro wine jovoho ueꞌaho barënugoromo vëmohuro Iesu uavadeje: Wine jovoho barëjëꞌe höjo. ");
INSERT INTO aom_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Barëjëꞌe höjamu uavadeje: Mamajo. Rabëni ajëmijöro uevanuëjo. Nasi maja börömoho bogo rovëꞌe höjo. ");
INSERT INTO aom_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Bogo rovëꞌe höjamu hegorovo vëmohuro mu ajëmijarue aribövioho uëvadeje: Ëaehu diehi uëvamu hejëꞌoho ëhi ëꞌorëjo. ");
INSERT INTO aom_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Röhu Jew rajëro God uehorovoromo jabesi sine inöme uꞌoꞌamarue jögoroho enövareje. Ëhuni jovo hevöe munëhu ubuvoromo avohoꞌamaroho ahoꞌobëhe övo gö mine övo göre gemu ë momoröꞌöjadeje. Jovo bövi mae 80 o 120 litre gemu gemu otehoꞌamoꞌego irijiomoꞌamonövadeje. ");
INSERT INTO aom_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Ëhi jiëꞌe jiëꞌëro Iesuro mu aribövioho uëvadeje: Ëmunë hevöro jovo maho otehoꞌamego irijiomoꞌamoꞌirajo. Ëhi uëvamu irijiomoꞌamo barëjareje. ");
INSERT INTO aom_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Ëhiꞌamu uëvadeje: Jove gö ë hevöro vuoromo ujuoho vaꞌoromo sörö muebejaje aho iꞌimamirëjo. Iꞌimamirëjamu ujuoho vaꞌoromo iꞌimamijareje. ");
INSERT INTO aom_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Iꞌimamamu rue sörö muebejaje ahuro i heromo hejadeje jovoho rihuꞌe jiamu ë jovo maho mamiꞌe wine-rëjëꞌëro jiëꞌëro. Röhu ë wine jovoho dinöꞌe jioromo ujuoho rovaroho bogo gaꞌi hesi jovo vuare mu ariböviohuro gavareje. Amo hejade rihuꞌe jiamu hegoro iꞌo masuvade aho uvamu rovadeje. ");
INSERT INTO aom_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Rovamu rue sörö muebejaje ahuro uavadeje: Ae ahoꞌobëhe wine jovo mabëhoho urimo bahijëharue höjo. Bahijëhonugoromo aëro jovo bövi mae ueꞌahego ijonö jove ma-bisemu sisëho bahijëharue höjo. Aꞌi jero wine jovo maho avoho runoꞌe bamane höjo aviavejöꞌe iꞌiröhohuni. ");
INSERT INTO aom_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Iesuro Cana amore Galilee saꞌare hiromo bëhiꞌe mu börömoho aevoꞌi ëhi vaejadeje. Vaeromo ëhuro hesi aji maho röjëhijamu gagorovo hesi ijorajoho jaburo hu mae uehorovareje. ");
INSERT INTO aom_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Ëhiꞌamu Iesu o hesi vëmoho o ö ömoꞌömoho o ijorajo ömoꞌömoho ëho jaburo Capernaum amore abuejareje. Abueromo ë raromaroho majae gemu niöꞌi rabuꞌe barëjadeje. ");
INSERT INTO aom_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","God-hu Vörö Tugohade Sörö Jew rajehu ijarue majaho dunovadeje. Sörö majaho dunovamu Iesuro Jerusalem ajiomadeje. ");
INSERT INTO aom_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Ajiomoromo God-are amo börömore vaꞌoromo gavadeje a ioroꞌioroho cow-ho Sheep-oho guaho vaꞌëne ugoho ëhi imoꞌamoꞌi o a ioroꞌioroho mu maratu bëhire raromoromo ijo bajoho ujuohoꞌi amo börömo hesi ijo bajoho mana iꞌimëmijamu. ");
INSERT INTO aom_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Ëhi gënugoromo öꞌe ujuohoromo badunoꞌe öꞌoho huadeje ëhuro hisuebiꞌamoröhëni. Huonugoromo ë aribövioho ahoꞌobëhe God-are amore jioruomamu hisuebijëvoromo rarovöꞌöjëvoromo sheep-ohuꞌo cow-huꞌo rarovöꞌöꞌamadeje. Ijo bajo mu vaeruomaje aribövi jabesi mu maratuoho huotovöꞌöjëhamu ijo bajoho rireromoromo arua anumiae vaꞌadeje. ");
INSERT INTO aom_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Guaho vaꞌëne ugo imoruomaje aribövioho uëvadeje: Ave inömo inömoho roriꞌo ujuoho vaꞌohëjo. Nadi aveho imohëjo. Nasi Vavu hesi amoho bogo bövi biseꞌo imarue amoho höjo. ");
INSERT INTO aom_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Bogo bövi biseꞌo imarue amoho höjamu hegorovo Iesuare ijorajoho jaburo uehorovoromo uvareje: Huhu ë mu vaejaje hesi bëhoho God-are surire jajivoromo uvëꞌe höjo: Vavuoho jasi osa hesi mu nimajohuro ëhuro vëninöꞌe nasi dë vövöbajoꞌere ravevajëjo. ");
INSERT INTO aom_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Röhu Jew rajo a masijohuro gavare Iesu ëhiꞌamu uavareje: Rabëni ëhioho ëꞌanuëjo. Bogo gavarue darugoꞌe muoho röjahuijego no garomo uvarëjo: God-ro uavëꞌëro ëꞌanuëjo. ");
INSERT INTO aom_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Ëꞌanuëjamu Iesuro uëvadeje: Ave God-are amoho dadovorëjo. Dadovëꞌoho majae niöꞌi gemu hesi uhure naro röhu maho vae barëꞌiramu mae namiꞌaꞌajëjo. Ëhi jiëꞌe darugoꞌe muohemu röjëhiꞌejöjo. ");
INSERT INTO aom_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Röjëhiꞌejöjamu Jew rajohuro uëvareje: Sarerivanuëjo. Ave amo vaebe rovaroho vadune ahoꞌobëhe 46 barëjëꞌe höjo. Ëhuni dadovëꞌoho röhu ja diehiꞌoromo majae niöꞌi gemu hesi uhuroho vae barëꞌiramu maho namiꞌaꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Jaburo uvareje: Nani God-are amo börömoho dadovo barëjego huro vae barëꞌi jövajëjo. Röhu bogo amo hesi jöho jövoꞌi hesi sino hahoꞌehu guomoromo röhu maho riꞌöröhe jöho jövadeje. ");
INSERT INTO aom_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Ëhuꞌëro jiëꞌëro ijonö Iesuhu guomoromo riꞌöjadevare evare hesi ijorajoho jaburo uehorovoromo uvareje: Iesuro mamiꞌe uönövade höjo: God-are amoho naro avoho vaeꞌiramu namiꞌaꞌajëromo evare Iesu riꞌöꞌiröhe jö God-are surire jajivare Iesuhu majëhijadoho ëho mae uehorovareje. ");
INSERT INTO aom_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","God-hu Vörö Tugohade Sörö majare Iesuro Jerusalem amo börömore hijamu evare ae ahoꞌobëhe gavare hu mu masije vaejamu gagorovo hesi örire mae uehorovoruomadeje. ");
INSERT INTO aom_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Mae uehorovamu Iesuro uvadeje: Ëaribövioho ma-döëremu uehorovevaruëromo jabesi öriroho bogo ma uehorovëvadeje ae ahoꞌobëhe mamiꞌe gëvëꞌëro jiëꞌëro. ");
INSERT INTO aom_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Iae hu ae ahoꞌobëhe jabesi dë vövöbajoꞌoho gë barënövadeje. Ëhuꞌëro ae gö jabesi jö Iesuare örire majahiꞌiröhe bëhoho bogojiadeje. ");
INSERT INTO aom_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Iae Jew rajo a böröme gemuëro hijadeje hesi ihoho Nicodemus. Hu Pharisee ae jiadeje. ");
INSERT INTO aom_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Vahie gemu huro Iesu gaꞌi vaꞌadeje. Vaꞌoromo Iesu uavadeje: Tisa no ja garomo uvarue höjo: God-hu ramöꞌöjamu röjahuiꞌi rovane ae javajëjo. Rabëniajo. God aꞌoho bogo hiꞌibejajo jaehu vaejanue ëhi jiëꞌe mu masijo vaejëꞌoho bogo eni javuoꞌibejajo. ");
INSERT INTO aom_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Bogo eni javuoꞌibejajamu Iesuro uavadeje: Ave jöho na jö mae uaꞌiëꞌajëjo. Ae mamiꞌe rahadoho röhu maho bogo rahoꞌamëꞌoho God-hu muebejaje öri ariꞌo garuomoröhoho bogo eni jioruomoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Bogo eni jioruomoꞌajëjamu Nicodemus-ro uavadeje: Iae mae höjo röhu aho mavojiraejëꞌoho diehiꞌoromo röhu maho rahoꞌamoꞌiröhoho eni jioruomoꞌajëjo. Vëmu jabesi dëre vuonoröꞌö rumo vaꞌoromo suorovonövëꞌoho bogo eni höjo. ");
INSERT INTO aom_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Bogo eni höjamu Iesuro uavadeje: Ave jöho na jö mae uaꞌiëꞌajëjo. Jovohuꞌo God-are Aruꞌahohuꞌo bogo ajëmijamu röhu maho rahëꞌoho God-are öri ariꞌere vaꞌiröhoho bogo eni jioruomoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Sino hahoꞌoꞌe aëro sino hahoꞌoꞌe harihoho baeruomoꞌi aꞌi God-are Aruꞌahohuro iae aruꞌahoꞌe harihoho avohoꞌamaje höjo. ");
INSERT INTO aom_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Na uavode höjo: Jemë mamiꞌe rahëvadoho röhu maho rahëvëꞌoho ëhuremu mae jëvoꞌajë jöho hejanuoho nadi tiönëjo. ");
INSERT INTO aom_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Buroho dinöꞌe dinöꞌe vaꞌi nimëꞌoho hesi ëma vaꞌaje höjo. Ja heꞌaꞌanuëjo rovavoꞌiramu röhu bogo gaꞌaꞌanuëjo dinöꞌe jioromo rovajoho o dinöꞌe vaꞌajoho. God-are Aruꞌahehu a rahu ajëmamu röhu maho rahëꞌoho jabesi öroho iae ëhi dadivavoꞌiramu bogo gaꞌaꞌanuëjo. ");
INSERT INTO aom_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Bogo gaꞌaꞌanuëjamu Nicodemus-ro uavadeje: Röhu ëhi jiëꞌe muoho diehi jioꞌaꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Diehi jioꞌaꞌajëjamu Iesuro uavadeje: Ja Israel rajo röjahuijanue a böröme javajëjo. Röhu ja diehiꞌoromo ëhi jiëꞌe muoho bogo gavanue höjo. ");
INSERT INTO aom_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Ave jöho na jö mae uaꞌiëꞌajëjo. Simane javuëꞌëro ë jöho no atarue höjo. Nunehu gavëꞌe jöho huruoho majëhijarue höjo. Majëhijego jemëro bogo ejahuaruje höjo. ");
INSERT INTO aom_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Saꞌa hesi mu jö majëhijodoho jemë bogo maho uehorovevaruje höjo. Ëhuni öꞌidö hesi mu jö majëhijëꞌoho jemë diehiꞌoromo mae uehorovevorëjo. ");
INSERT INTO aom_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","A ioroꞌioroho bogo öꞌidöroho ajio raromoruomade höjo. God-are A Maho öꞌidöre jioromo ruvebijodoho naro gemuëro ëho hijode höjo. ");
INSERT INTO aom_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Röhu urimëꞌi Moses-ro a rumoꞌe saꞌare hiromo sigobu vaꞌëne inömoho ma-mabëhe avohoromo ijore bamoromo a jabesi nunire banigojiomade höjo aëro ëho garomo mae raromonövoröhego. Sigobu vaꞌëne inömo banigojiomadëhi God-ro bamëꞌëro aëro ëhi hesi A Maho na a jabesi nunire banigojiomevoꞌaruëjo ");
INSERT INTO aom_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","ëhuro ae rahu na mae uehorovevëꞌoho iꞌe rahanovoromo ma-ioroꞌioremu maro raromoꞌiröhego. ");
INSERT INTO aom_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Saꞌae dinöꞌe dinöꞌe God-ro dë vövöbajoꞌe ahoꞌo uehorovavuadeje. Uehorovavuoromo hesi Harihu gemuꞌoho bojamuijadeje ëhuro ae rahu Harihu mae uehorovëꞌohuro ëhuro bogo sisëroho vaꞌi ma-ioroꞌioremu maro raromoröhego. ");
INSERT INTO aom_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","God-hu hesi Harihu saꞌare nugöꞌöjade hesi bëhoho bogo nosi sisëho garomo sisëroho bamavuoꞌi aꞌi ajamuiromo maro ramuoꞌiröhego ëhuni nugöꞌöjadeje. ");
INSERT INTO aom_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Ae rahu Harihu mae uehorovëꞌoho bogo sisëroho vaꞌo hesije. O bogo ma uehorovëꞌoho mamiꞌe sisënö bamëꞌeje ë hesi bëhoho hu God-are Harihu gemuꞌoho bogo ma uehorovëꞌego. ");
INSERT INTO aom_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","A sisënö bamëvaje hesi öroho aviëhije. Ajohuro saꞌare rovëꞌeje. Rovëꞌe jiamu aëro ajoho bijönimoꞌi ramoramoho nimoruomadeje mu sisëmu vaejaruëro jiëꞌëro. ");
INSERT INTO aom_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Ae rahu mu sisë vaejëꞌoho ajoho garomo bijönimoromo bogo bëhiroho rovajeje hesi mu sisëho vaꞌorahoro jiojöëni. ");
INSERT INTO aom_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Aꞌi ae rahu mu ma vaejëꞌohuro aji bëhire rovajeje huhu God-are jö ejahoromo mu vaejajoho ëho samaro jioröhego. ");
INSERT INTO aom_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Ëhiꞌamu Iesuꞌo hesi ijorajo ömoꞌömohuꞌo ëho jaburo Judea saꞌare vaꞌareje. Vaꞌoromo huro jabuꞌo hiromo ae bapataeto vaejëvonövadeje. ");
INSERT INTO aom_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Bapataeto vaejëvoꞌi John-ro Aenon saꞌare Salim amo bëhire hiromo huꞌo bapataeto vaejëvonövadeje ë diröꞌoho jove ahoꞌobëhe jiëꞌëro. Bapataeto vaeꞌego ae ahoꞌobëhe ë rueromo vaenövareje ");
INSERT INTO aom_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","ë hesi bëhoho John bogo guduamoromo savoji gagoroho baꞌamëꞌëro ijonö baꞌamoꞌiröhego. ");
INSERT INTO aom_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","John-ro bapataeto ëhi vaejëvamu hesi ijorajo ömoꞌömohuꞌo Jew rajo ae göꞌo jö ahoꞌahamirovoromo uarovareje: Jovehu sisë uꞌoꞌiröhe öroho ëhi ëhi höjo. ");
INSERT INTO aom_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Jöho ëhi ahoꞌahamirovoromo John-are ijorajohuro vaꞌoromo John uavareje: Tisa Jordan jovo ioroꞌiorore jaꞌo hijamu jaehu hesi jö majahuijanoho ë ahuro jasi muoho vajiohunöꞌe baeromo bapataeto vaejëvego jabu ae ahoꞌobëhe hesirire vaꞌoruomaje höjo. ");
INSERT INTO aom_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Vaꞌoruomaje höjamu John-ro uëvadeje: Röhu aehu nosirire rueruomëꞌoho o muehu o rabehu rabehu rovëꞌoho bogo ëma rovego baeꞌi aꞌi God-ro bojamuijego baejarue höjo. ");
INSERT INTO aom_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Jemë mamiꞌe hejarije höjo naro jemë uëvamu: Böröme namiromo ajëmiꞌirode aho bogo naehu jevajëjo. Aꞌi God-ro na urimo remöꞌöjamu rovëꞌe jevajëjo ë ahuro ijore rueröhego. ");
INSERT INTO aom_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Ëa hesi jöho uhunöꞌe majëhiꞌiëꞌajëjo. Iꞌo masuröhe aho huro gemuëro vaboroho baeꞌaꞌajëjo. O ë a hesi aemoꞌaemohuro namiromo muꞌöjamiromo heröhe masuröhe aho jöe jövavamu hejëꞌoho nimorohoꞌajëjo. Nimorohoꞌiröhëhi jemëhu uevaruje a hesi mu jöho heromo na nimorohevo avohajëjo. ");
INSERT INTO aom_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","God-ro ëhi nimoꞌego ë a hesi ihoho ajiomoꞌi nasi ihoho abuejajëjo. ");
INSERT INTO aom_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","John-hu majëhijadëhi iae ëhije. Döre jioromo ruvebijade ahuro ae ahoꞌobëhe iosiramuiromo börömohoje. Bogo döre jioromo ruvebiꞌi aꞌi ma-saꞌare rahëvare aribövioho jabumë ma-saꞌaremu raromarue ariböviëro jëvëꞌëro saꞌa hesi jöhemu majahuijarueje. O öꞌidöre jioromo ruvebijade ahuro ahoꞌobëhe iosiramuiromo hu börömohoje. ");
INSERT INTO aom_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Börömoho jiëꞌëro garomo hejade jöho huro ae majëhijajeje. Majëhijego hesi jöho aho bogo ejaharueje. ");
INSERT INTO aom_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Röhu ae rahuro hesi jö ejahëꞌoho ëhuro uvarueje: Iae mae-ëjo God mae höjo. ");
INSERT INTO aom_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Ëhesi bëhoho God-hu nugöꞌöjade ahuro God-are jöhuremu jövajeje. Rabëni hesi bëhoho God-ro hesi Aruꞌahoho bojami avohego dë vövöbajoꞌe rarovahego jöho jövajeje. ");
INSERT INTO aom_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Vavuohuro Harihoho rajahijajeje. Rajahiromo bövie biseꞌe hesi övore bamëꞌeje. ");
INSERT INTO aom_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Ae rahu Harihu mae uehorovëꞌoho ma-ioroꞌioremu maro hijajeje. O ae rahu Harihu bogo ejahëꞌoho bogo maroho hiꞌi God-ro hesi örire dë vörönimemu vörönimajeje. ");
INSERT INTO aom_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Iae Pharisee ariböviohuro hejareje aëro uvoruomamu: John rinëgoromo bapataeto vaejëvobe rovaje aho ma-jianovoꞌi Iesuhu rinëgoromo bapataeto vaejëvobe rovaje aho börömoho höjo. ");
INSERT INTO aom_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Ëhi hejareje röhu Iesu bogo hesi övoho bapataeto vaejëvoꞌi aꞌi hesi ijorajoho jaburo ëꞌareje. ");
INSERT INTO aom_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Amo Iesuro hejade uvavamu: Huhu ëꞌaje muohuro John hesiroho iosiramijëꞌe jöho Pharisee ariböviohuro hejëꞌe hö uvavamu hegorovo Judea saꞌaho vuonugoꞌi vuonoröꞌöromo Galilee saꞌare ajiomoꞌi vaꞌadeje. ");
INSERT INTO aom_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Galilee ajiomoꞌirögoro Samaria örëro vaꞌadeje hesi muëro jiëꞌëro. ");
INSERT INTO aom_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Vaꞌoromo Samaria saꞌare ajiomoromo amo ihe Sychar ë rovadeje. Röhu Sychar amo bëhire jiaje saꞌaho urimëꞌi a mami ae Jacob-ro hesi harihoho Joseph bojamijadeje. Ësaꞌanö Iesu rovadeje. ");
INSERT INTO aom_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Rueromo maja ririvanovëꞌiro öri ëgoböviro rovëꞌëro uꞌuvamu hegoro Jacob-mëhu jovëni umare gua bëhire hijadeje. ");
INSERT INTO aom_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Hesi ijorajoho jabu ie imoꞌi amore vaꞌëꞌëro hesi sivue hijadeje. Hijamu iae Samaria saꞌa rajo magonahe gemuëro jove vuoꞌi rovadeje. Rovamu gagorovo Iesuro uavadeje: Jove vuo bojemego na ijöjo. ");
INSERT INTO aom_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Jove bojemego na ijöjamu rue magonahohuro uavadeje: Ja Jew raje javoꞌi na Samaria rajo magonahe jevajëjo. Ëhuꞌoho rabëni jovo jöho ue gevanuëjo. Ëmagonahehu ëhi uavade hesi bëhoho Jew rajohuro uvoruomajeje: Samaria rajo jabesi ano saboꞌe hevöho enatuoho unoho ioho bogo iꞌejarëjo. Jew rajehu ëhi uvoromo ömaruëhi Iesu bogo ëhioho ömëꞌëro ëhuꞌëro magonahohuro uavadeje: Rabëni jovo jöho ue gevanuëjo. ");
INSERT INTO aom_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Ue gevanuëjamu hegorovo Iesuro uavadeje: God-hu a bojëmijaje suvuoroho jero bogo gavanuëjo. O naehu jovo bojemijöro ua gavaje aho jero bogo gevanuëjo. Geꞌibejanëjo ja ue geꞌibejanëjo naro a iꞌovëvaje jovoho bojamiꞌibejöjo iromo maro hiꞌiranego. ");
INSERT INTO aom_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Bojamiꞌibejöjamu magonahohuro uavadeje: Iae mae höjo röhu jovo vuoromo bojemiꞌirane hevöho bogojavajëjo. Röhu jovo vuoꞌirane guaho ëgobövi mae jio abuejajëjo. Ëhi jiëꞌoho ja diehiꞌoromo a iꞌovëvaje jovoho vuo bojeminëjo. ");
INSERT INTO aom_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Nosi hije bövi mae Jacob-ro ave jovo vuarue guaho bojamuijade höjo. Huꞌo hesi harihu ömoꞌömohuꞌo ëho jaburo ave guare rueromo jovoho vuoromo ueꞌahëꞌi jabesi mioho mioꞌamonövare höjo. Na jero Jacob iosiramiromo börömoho javajëromo ëhuꞌëro jero a iꞌovëvaje jovoho bojemiꞌi uevanuëjo. ");
INSERT INTO aom_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Uevanuëjamu uavadeje: Ae rahu ave jovo ueꞌahëꞌoho huë girihëvoꞌiramu röhu maho göꞌo iꞌi nimonövoꞌarujëjo. ");
INSERT INTO aom_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","O naehu jovo mëmamu ueꞌahëꞌoho huëho bogo girihëvoꞌi ioroꞌiore gemu ma-maemu jioruomoꞌajëjo. Ëhesi bëhoho naro jovoho bojëmiꞌiramu nasi jovo mahuro jabesi dë vövöbajoꞌere jovëro bubujivanovo rojomëvoꞌiramu ma-ioroꞌiore gemu maro raromoꞌaruëjo. ");
INSERT INTO aom_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Raromoꞌaruëjamu magonahohuro uvadeje: Mae jovo jöe jövajëromo uavadeje: Iae mae höjo. Ëhi jiëꞌe jovoho bojemego na ijöjo. Iromo ijonöho huëho bogo girihevego aveho bogo rueromo jovoho vuoꞌirode höjo. ");
INSERT INTO aom_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Bogo vuoꞌirode höjamu Iesuro uavadeje: Vaꞌoromo jasi baruoho uaromo huꞌirae baruenëjo. ");
INSERT INTO aom_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Baruenëjamu rue magonahohuro uavadeje: Baru rumoꞌe jevajëjo. Baru rumoꞌe jevajëjamu uavadeje: Iae mae uevanuëjo: Baru rumoꞌe jevajëjo. ");
INSERT INTO aom_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Urimo baru masu nugobe rovanoho ahoꞌobëhe övo gö mine höjo. Avevejöꞌe garomo hijanuoho ëho bogo jasi baruoho höjo. Ëhuni ja mae uevanuëjo. ");
INSERT INTO aom_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Mae uevanuëjamu rue magonahohuro uavadeje: Iae na gavajoho ja jö God-aro baeromo majahuijanue ae javajëjo. ");
INSERT INTO aom_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Ëhuni ave jöho uevego na hejöjo. Nosi Samaria hijo mionoꞌo ömoꞌömohuro rue dahorure iojiomoromo God rajahibe rovëꞌe höjo. Röhu Jew rajoho jemëro uvaruje höjo: Jerusalem amohuremu rojomoromo God rajahinövorëjo. Di öri ariꞌoho maho höjo. ");
INSERT INTO aom_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Maho höjamu uavadeje: Röhu ave nasi jöho mae uehorovëjo. Majae ijonöho aho bogo rue dahoruroho o Jerusalem amoroho Vavuoho rajahiruomoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Samaria rajoho jemëhu rajahijaruje bëhoho bogo gavëꞌe ëma ëꞌaruje höjo. Röhu Jew rajo noehu rajahijaruoho noro avoho garomo ëꞌarue höjo. Rabëni hesi bëhoho God-hu a manö babamëvoꞌiröhe muoho Jew rajo nosirire aevëꞌëro jiëꞌëro ëhuꞌëro noro öroho avoho garomo God rajahijarue höjo. ");
INSERT INTO aom_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Majae gö rueꞌiëꞌajëjo. Röhu mamiꞌe rovanovëꞌe höjo. Evare majare aehu uhohuꞌo God rajahijëꞌoho God-are Aruꞌahoho baeromo Vavuoho avoho uehorovoromo ëhi rajahiꞌaruëjo. Vavuohuro iae nimajëjo ëhi jiëꞌe ariböviohuro hu rajahinövoröhego. ");
INSERT INTO aom_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","God hu aruꞌahe höjo. Ëhuni ae rahu God rajahijëꞌiroho hesi Aruꞌahoho baeromo God avoho uehorovoromo rajahiꞌaruëjo. Öre gö bogohöjo. ");
INSERT INTO aom_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Bogohöjamu rue magonahohuro uavadeje: Iae na gavajëjo. Böröme namiromo ajamuiꞌiröhe aho Keriso iae rueꞌaꞌajëjo. Rueromo jöe ahoꞌobëhe huruoho majahui barëꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Majahui barëꞌajëjamu Iesuro uavadeje: Jaehu uvanue aho iae na aviae jevajëjo jaꞌo jö jövajoho. ");
INSERT INTO aom_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Ëhi uavamu gavëꞌi Iesuare ijorajoho jaburo vuonoröꞌö rovareje. Rueꞌi gavare Iesuro magonahoꞌo jöe jövamu gagorovo tiöjëvadeje. Tiöjëvamu röhu aho Iesu bogo uavareje: Ja rabe nagajëjo. O bogo uavareje: Ja rabëni huꞌoho jöho jövanuëjo. ");
INSERT INTO aom_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Ëhiꞌamu magonahohuro riꞌöromo jovoꞌe hevöho ë nugoꞌi amëro vaꞌadeje. Vaꞌoromo ae uëvadeje: ");
INSERT INTO aom_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","Rueromo ae gemu gahëjo. Naehu bövi biseꞌo ömode jöho huro majehijamu hejëꞌe jevajëjo. Na ë aho böröme namiromo ajamuiꞌiröhe aho höjo o rahuo höjo. ");
INSERT INTO aom_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Ëhi uëvamu amoho vuonugoꞌi Iesu gaꞌi örire rueruomadeje. ");
INSERT INTO aom_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Ëmagonahohuro ëhi ëꞌirögoro Iesuare ijorajoho jaburo ioho imëꞌëro uavareje: Tisa ie ijëjo. ");
INSERT INTO aom_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Ijëjamu Iesuro uëvadeje: Iae nasi ie jiajëjo. Röhu jemë bogo gavarujëjo. ");
INSERT INTO aom_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Bogo gavarujëjamu rueho jaburo uarovareje: Na aëro ioho ba ro bojamijare höjo. O dinöꞌe baejade höjo. ");
INSERT INTO aom_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Ëhi uarovamu Iesuro uëvadeje: Ëho na bogo i jöho uëꞌiro aꞌi Vavuehu saꞌare remöꞌöromo nimaje jöho naro ejahoromo huhu bojemade muoho vae barëjego ëhuro inöꞌe daꞌuegaje höjo. ");
INSERT INTO aom_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Jemëꞌo uehorovohëjo. Jemë atoromo ëhi uvaruje höjo: Manaere ëhi niöꞌi ëhi niöꞌi mueberomo irunoꞌoho mavoꞌiramu evare gagovoꞌejarëjo. Röhu aveho hehëjo. Iꞌo muꞌoho ruë numë uherihoromo gahëjo. Irunoꞌoho iae mavoꞌamëꞌe höjo gagovoꞌamoꞌiröhego. Ëhi uëvade jö hesi bëhoho bogo irunoꞌo jöho jioꞌi aꞌi Samaria raje ae ahoꞌobëhe magonahohuro uëvëꞌëro Iesu gaꞌi örire rueruomade jöhoje. ");
INSERT INTO aom_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Röhu uhu jö hesi vituoho majëhiromo uëvadeje: Gagovarue ariböviohuro aviavejöꞌe jabesi suvuoroho ujuohoromo aribövioho irunoꞌo vaꞌëne gagovëvaruëjo jaburo ma-ioroꞌioremu maro raromoröhego. Ëhuꞌëro irunoꞌe bamarue ariböviohuꞌo gagovarue ariböviohuꞌo ma-gemuoro nimorohoruomoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Röhu ave jöhuꞌo atoromo uvarue höjo: A ioroꞌiorohuro irunoꞌoho bamego a ioroꞌiorohuro gagovarue höjo. Ëjöho iae mae höjo. ");
INSERT INTO aom_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Naro jemë rëmöꞌöjode höjo iꞌuꞌe mu bogo vaejarijire ë vaꞌoromo ma-gagovoꞌirarijego. Hesi a ioroꞌiorohuro iꞌuꞌe muoho ë vaejamu jemëro jabesi mu vituoho baejëꞌëro ae ma-gagovëvoꞌiëꞌarujëjo nasinö jëvojöro. ");
INSERT INTO aom_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Ëhiꞌamu Samaria saꞌa rajo aribövie ë amore raromaruohuro hejare magonahoho uëvamu: Naehu bövi biseꞌo ömode jöho majehijamu hejëꞌe jevajë uëvamu hegorovo ae ahoꞌobëhe Iesu mae uehorovareje. ");
INSERT INTO aom_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Mae uehorovoromo rueromo Iesu uavareje: Ro nosi amoro noꞌo hijëjo. Hijëjamu Iesuro vaꞌoromo majae niöꞌi jabuꞌo hijadeje. ");
INSERT INTO aom_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Hijamu urimo ae ahoꞌo magonaho hesi jöho heromo mae uehorovëꞌëro hejare Iesuro jöe majëhijamu hegorovo ae gö gö ahoꞌobëhe mae uehorovareje. ");
INSERT INTO aom_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Mae uehorovoromo magonahoho uavareje: Urimoho jasi jöho heromo Iesu mae uehorovare höjo. Jaruvoho bogo ëhunioho mae uehorovoꞌi aꞌi nosi hiaꞌëro hejare Iesuro jöe majahuijamu hejëꞌëro ëhuꞌëro noro mae garomo uvarue höjo: Iae mae-ëjo. Ëaho saꞌae dinöꞌe dinöꞌe raromarue aribövioho manö babamavuaje aho höjo. ");
INSERT INTO aom_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Ëhi uavamu Iesuro ë amore hiromo majae niöꞌi barëjamu gagorovo vaꞌadeje. Vaꞌoromo Galilee saꞌare ajiomadeje. ");
INSERT INTO aom_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Urimëꞌi Iesuro ae majëhiromo uëvadeje: Jö God-aro baeromo majëhijarue aribövioho ëhi jiëꞌe aribövioho nosi saꞌa rajohuro bogo masijoho höromo maho uehorovavuoruomaje höjo. ");
INSERT INTO aom_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Röhu vaꞌoromo Galilee saꞌare rovamu gagorovo ë saꞌa rajohuro hu rajahiruomadeje ë hesi bëhoho mamiꞌe söröho iꞌi Jerusalem vaꞌoromo gavare Iesuro darugoꞌe mu masijoho vaejamu gavëꞌëro. ");
INSERT INTO aom_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Rajahijamu Iesuro Galilee saꞌare hiromo röhu maho vaꞌoromo Cana amore höröjadeje. Urimëꞌi huro ë amore hiromo jovo maho baeromo avohamu wine-rëjadeje. Ëamore röhu maho rovadeje. Röhu gavamen mu vaejaje aëro ë saꞌae gemuore hijëꞌe jiadeje. Saꞌae gemuore Capernaum amore hiꞌi hesi harihoho guomo guome baeromo huꞌo hijadeje. ");
INSERT INTO aom_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Hijamu vavuohuro hejade uvavamu: Iesuro Judea jioromo Galilee ro hijajë uvamu hegorovo ajio Cana höröromo Iesu uavadeje: Nasi harihoho guomehoꞌiëꞌajëjo. Ëhuni naꞌo ruvebiromo anume Capernaum amoro ajamego mae jioꞌirajo. ");
INSERT INTO aom_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Mae jioꞌirajamu Iesuro uavadeje: Na jemë nasi darugoꞌe mu masijoho garomo mae uehorovevoꞌi ëhuni na bogo maho uehorovevaruje höjo. ");
INSERT INTO aom_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Uehorovevaruje höjamu rue vavuohuro uavadeje: Iae ëhi höjo röhu ruvebiromo ajamijëjo. Jueꞌi guomoꞌiëꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Guomoꞌiëꞌajëjamu Iesuro uavadeje: Vaꞌëjo. Jasi harihoho iae iꞌovoromo hiꞌiëꞌajëjo. Hiꞌiëꞌajëjamu hegorovo rue vavuohuro jöho mae uehorovoromo abuejadeje. ");
INSERT INTO aom_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Abuejamu gagorovo hesi mu vaejaharue ariböviohuro rueromo örire birohoromo uavareje: Jasi harihoho iae iꞌovoromo hijajëjo. ");
INSERT INTO aom_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Hijajëjamu uëvadeje: Maja raburo jueꞌi iꞌovade höjo. Iꞌovade höjamu uavareje: Nëri jeniꞌe majae huotorovamu gavëꞌi evare hesi sino dajoꞌe vöröꞌiraejadoho uꞌuhade höjo. ");
INSERT INTO aom_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Uꞌuhade höjamu rue vavuohuro uehorovoromo uvadeje: O majae ëhi gemuoho jiamu gavëꞌi Iesuro uevade höjo: Jasi harihoho iae iꞌovoromo hiꞌiëꞌajëromo huꞌo hesi ö muenoꞌe ahoꞌobëhe jabuꞌo mae uehorovareje. ");
INSERT INTO aom_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Röhu urimëꞌi Iesuro Judea saꞌare jioromo Galilee rueromo evare bëhiꞌe mu börömo gö vaejadoho avevejöꞌe jö jövamu a börömo hesi harihu iꞌovadoho ëho bëhiꞌe mu göho jiadeje. ");
INSERT INTO aom_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Ëhiꞌamu Jew rajehu God uehorovoromo sörö ijarue majaho gemu rovadeje. Sörö majaho rovamu Iesuro Jerusalem ajiomadeje. ");
INSERT INTO aom_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Röhu Jerusalem amo börömo oje gemu hesi ihoho Sheep Ojohoje. Ëojo hesi bëhire jovo eꞌue gemu ruhijëꞌeje. Ëjovo hesi ihoho Hebrew huëhu uvaruoho Bethzatha-je. Röhu ë jovo hesi ruhëhi numëhi ionire ionire ririre javu ëge övo gö mine jioꞌame. Javuoho bogo iromëꞌe ma-döhemu vaeromo ëhi ma-gagemu nugoꞌamëꞌejö ë raromonövoröhëni. ");
INSERT INTO aom_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Ëjavuore guomo guomoꞌe ae ahoꞌobëhe raromonövareje. Nuni sisëꞌe höru sisëꞌe övo höruꞌo tövëꞌe ëhi jiëꞌe aribövioho ë raromoromo muebejareje jovoho avaduꞌavaduvoröhego. ");
INSERT INTO aom_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Ëhesi bëhoho Badare anerae gemuëro majae gö gö ë jovore abueromo jovoho huotohuotovoꞌego avaduꞌavaduvonövadeje. Avaduꞌavaduvoꞌego guomo guomoꞌe aribövioho di aho urimo jovore abuejadoho marënövadeje. ");
INSERT INTO aom_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Iae ae gemuëro ë raromadeje. Guomo guomo maminö göꞌe baeromo ëhi jiobe rovadoho vadune ahoꞌobëhe 38 barëjëꞌe jiadeje. ");
INSERT INTO aom_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Ëraromamu Iesuro hu gavadeje. Garomo uvadeje: Ëaho guomo guomo baejadoho majae ëgobövie barëjëꞌe höromo uavadeje: Na ja marëjavojöro nagajëjo. ");
INSERT INTO aom_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Marëjavojöro nagajëjamu rue guomo guomoꞌe ahuro uavadeje: Na aemoꞌaeme bogojevëꞌëro jovo avaduꞌavaduvëꞌiroho bogo baejevoromo jovoroho baꞌamevarue höjo. O na jovore abueꞌiëꞌiroho ae göëro na iosiremiromo urimo abuejaje höjo. ");
INSERT INTO aom_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Urimo abuejaje höjamu uavadeje: Riꞌö namiromo raromanue suhoho banigojiomoromo baeromo juvëjo. ");
INSERT INTO aom_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Juvëjamu ë aho ma-burëro marëjadeje. Marëjamu hesi suhoho banigojiomoromo baeromo juvo vaꞌadeje. Ëhi ëꞌadeje röhu ë majaho Jew rajehu mu bogo vaeꞌi nuharue majaho jiadeje. ");
INSERT INTO aom_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Nuharue majaho jiamu gagorovo Jew rajo a masijohuro gavare ë ahuro suhoho bavaꞌamu gagorovo uavareje: Jaruvo nosi nuho majae höjo. Ëhuni ja suhi baeromo juvanuoho ëho jero nosi jögoroho ahanuëjo. ");
INSERT INTO aom_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Ahanuëjamu uëvadeje: Röhu ajemamu marëjevade ahuro uevade höjo: Jasi suhoho banigojiomoromo baeromo juvë uevadohuni ëhuni baeromo juvajëjo. ");
INSERT INTO aom_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Baeromo juvajëjamu uavareje: Raro ëhioho uavade höjo. ");
INSERT INTO aom_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Ëhi uavamu röhu dadivamu bogo uëvadeje rabëni ae ahoꞌobëhe jovo riröre tagavamu Iesuro ajamiromo vaꞌëꞌëro jiëꞌëro. ");
INSERT INTO aom_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Ëhi ëꞌëꞌëro Iesuro God-are amo börömore vaꞌoromo ë aho birohoromo uavadeje: Hejëjo. Iae mamiꞌe marëjavëꞌe jiaje ijoho nadi mu sisëho vaenëjo. Urimo huë vavaene ma-bisemu baejanoho röhu ijonöho börömo bëhe baeꞌaꞌanuëjo. ");
INSERT INTO aom_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Ëhi uavamu hegorovo rue ahuro vaꞌoromo Jew rajo a masijoho uëvadeje: Ajemamu marëjevade aho Iesu höjo. ");
INSERT INTO aom_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Iesu hö uëvamu hegorovo Jew rajo a masijohuro uvareje: Iesuro ë muoho nuho majaro ömade hö uvoromo dë vörönimoromo aevoromo Iesu huë vavaene bojamiꞌi arijareje. ");
INSERT INTO aom_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Huë vavaene bojamiꞌi arijamu Iesuro uëvadeje: Nasi Vavuoho bogo nuhoꞌi aꞌi ma-muemu vaemu vaejego naꞌo ëhi ëꞌaje höjo. ");
INSERT INTO aom_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Ëhi uëvamu hegorovo rue a masijohuro uvareje: Nuho maja hesi jögoroho ahëꞌe höjo. Röhu göho hu uvajëjo: God nasi Vavu mae höjo. Ëhuꞌëro hu uvoromo ëꞌajëjo: Na Godꞌo gemuoho jevajëjo. Ëhi uvoromo ëhuni jaburo uehore ahoꞌo ma-gemu baeromo uvareje: Iaho anoꞌejarëjo. ");
INSERT INTO aom_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Ëhi uvamu Iesuro jöe majëhiromo uëvadeje: Ave jöho na jö mae uëꞌiëꞌajëjo. God-are Harihu naehu nasi sivu mu vaeꞌirodoho bogo eni jevajëjo. Aꞌi Apohu vaejego gavaje muohemu vaejaje höjo. Apohu vaejajëhi Harihoho naro ëhi gemuoho vaejaje höjo. ");
INSERT INTO aom_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Ëhesi bëhoho Aporo Harihoho na uehorovevoromo huhu mu bövi biseꞌo vaejajoho ëho röjehijaje höjo. Röhu ë mu röjehijajoho uꞌemu iosiramiromo masijo maho röjehiꞌaꞌajëjo naro vaejego jemëro garomo tiöromo uvoꞌirarijego: Mabëhe ëꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Vavuehu vuovëꞌe aribövi ajëmijego iꞌovaruëhi ëhi Harihoho naꞌo vuovëꞌe ae rahu ajëmiꞌi negëꞌoho ajëmego iꞌovarue höjo. ");
INSERT INTO aom_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Vavuohuro aho bogo mevoromo gëvaje höjo mae o sisë jioꞌamego aꞌi mevoromo mae o sisë jëvego gëꞌirode muoho Vavuohuro Harihu nasi övore bamo barëjëꞌe höjo naro ë muoho vaeꞌirodego. ");
INSERT INTO aom_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Naro vaejego ae ahoꞌobëhe Vavu rajahijaruëhi Harihoho naꞌo ëhi rajehiruomoröhego. Ae rahu Harihoho bogo rajehijëꞌoho ëhuro Vavue remöꞌöjadohuꞌo bogo rajahijarue höjo. ");
INSERT INTO aom_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Ave jöho na jö mae uëꞌiëꞌajëjo. Ae rahu nasi jö heromo saꞌare remöꞌöjade aho mae uehorovëꞌoho ma-ioroꞌioremu mae raromoꞌiröhe örire jijihoruomaje höjo. Mae raromoꞌiröhe örire jijihobe vaꞌojuvo mevoromo gëꞌirode majaho rueꞌiramu God-are iꞌuoho bogo baeruomoꞌajëjo vuovo örire jijiharoho mamiꞌe vuonugoꞌi iꞌovo örire jijiharuëro jiëꞌëro. ");
INSERT INTO aom_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Ave jöho na jö mae uëꞌiëꞌajëjo. Majaho rueꞌaꞌajëjo. Röhu mamiꞌe rovanovëꞌe höjo. Evare majare vuovëvëꞌe aribövie göëro göëro heꞌaꞌaruëjo God-are Harihoho naro uvavoꞌiramu. Ae rahu Harihu naehu uvamu hejëꞌoho vuovo örire jijiharuoho vuonugoꞌi iꞌovo örire jijihoꞌaruëjo. ");
INSERT INTO aom_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Vavuehu ae uëvego iꞌovaruëhi huro na ajemijëꞌëro Harihoho naꞌo ëhi uëvego iꞌovarue höjo. ");
INSERT INTO aom_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Vavuohuro ëhi ajemiromo röhu jöho bojemijade höjo naro ae mevëvoromo gëꞌirodego mae o sisë jëvego rabëni na hesi A Maho jevëꞌego. ");
INSERT INTO aom_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Ëjö hejarujoho nadi tiörëjo. Majaho rueꞌiramu evare ae ahoꞌobëhe hure raromaruohuro heröhe naro uvavoꞌiramu ");
INSERT INTO aom_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","hegorovo hure jioromo suorovoruomoꞌajëjo. Suorovoromo mu ma vaejare ariböviohuro riꞌöromo ma-ioroꞌioremu maro raromoꞌirögoro mu sisë vaejare ariböviohuro riꞌöromo naro mevëvo gëromo iꞌue mana bojëmiꞌiramu sisëro vaꞌoruomoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Naehu nasi sivu mu vaeꞌirodoho bogo eni jevajëjo. Vavuehu uevego hejajëhi na ëhi mevëvoromo gëvaje höjo ae mae o sisë jëvego. Bogo ëma mevëvoꞌi aꞌi mae mevëvoromo gëvaje höjo rabëni hesi bëhoho nasi nimajoho bogo uehorovoꞌirögoro aꞌi saꞌare na remöꞌöjade aehu nimajoho uehorovajëro jiëꞌëro. Iae ëhuni avoho mevëvoromo gëvaje höjo. ");
INSERT INTO aom_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Naro nasi sivue nasi jöho huruoho majëhijego heꞌibejarijëjo nani aëro uvoꞌibejarijëjo: Sarere höjo. ");
INSERT INTO aom_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Röhu bogo nasi sivuoho jövoꞌi ae gö na ömego gevajohuro jövo ajemiromo uëvaje höjo: Nörö jö mae jövaje höjo. Iae na gavajoho ë aho hu jö maemu jövaje höjo nasi Vavuohuro jiëꞌëro. ");
INSERT INTO aom_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Mamiꞌe jemëro jemesi ae rëmöꞌöjamu John-are örire vaꞌare höjo. Vaꞌoromo hejare höjo huro jö ma hesi jöho mae majëhijamu. ");
INSERT INTO aom_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Ëhesi bëhoho nasi jöho majëhijade höjo. Na ëhi uëvaje hesi bëhoho bogo aëro nasi jöho ajemiromo majëhijöro negoꞌego uëvajëjo. Aꞌi ëhi uëvaje hesi bëhoho jemëro ejehoromo bogo sisëroho vaꞌi maro vaꞌirarijego ëhuni uëvajëjo. ");
INSERT INTO aom_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Röhu John-ro irehu höduvoromo ajivavuajëhi huro ëhi ajivëvonövade höjo. Ëhiꞌamu majae ma-bunemu nimarije höjo hesi ajire raromogoro nimorohoꞌirovo. ");
INSERT INTO aom_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","John-hu nasi jö majëhijamu hejarijoho iae mae höjo röhu ëho ma-jianovoꞌi Vavuehu bojemego vaeꞌamaje muoho ëho masijoho höjo. Ëho garomo uvoꞌibejarijëjo: Iae mae-ëjo. Vavuohuro nörö nugöꞌöjamu rovëꞌe höjo. ");
INSERT INTO aom_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Röhu Vavue na saꞌare remöꞌöjade ahuro huꞌo ajemiromo nasi jöho majëhijëꞌe höjo. Hesi huëho jemë bogo heromo nu anoꞌoho bogo gavëꞌe jëvajëjo. ");
INSERT INTO aom_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Hesi jöho jemesi dë vövöbajoꞌeroho bogoꞌe höjo rabëni huhu remöꞌöjamu rovode aho na bogo ma uehorovevarujëro jëvëꞌëro. ");
INSERT INTO aom_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Röhu jemëro uehorovoromo uvaruje höjo: God-are surire jö adahëꞌoho noehu ma-ioroꞌioremu mae raromoꞌiröhe öroho birohoꞌejarëromo ë hesi öroho nahoꞌirögoro suroho adaho avoharuje höjo. Röhu nasi jöho jemëhu adaharuje surire iae ë jajivëꞌe höjo. ");
INSERT INTO aom_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Nasi jöe ë surire jajivare höjo röhu jemëhu ë jö eromo nasirire rueromo ëhuro mae raromoꞌirarijoho bijönimaruje höjo. ");
INSERT INTO aom_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Ma-aehu nasi iho döre bamehoꞌirarijoho ëho na bogo uehorovoromo jövajëjo. ");
INSERT INTO aom_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Röhu jemesi dëho iae na gëvajëjo. God-are öriroho jemesi dë vövöbajoꞌeroho bogo uehorovaruje höjo. ");
INSERT INTO aom_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Naro nasi Vavu hesi ihore rovode höjo. Röhu jemëro bogo ejeharuje höjo. Ae göehu hesi ëma rovëꞌoho ëma ejëhoꞌarujëjo. ");
INSERT INTO aom_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Jemë nimarujëjo jemesi ariböviëro jemesi ihoho döro bamëhojöro. Aꞌi God gemu eni jiëꞌe aehu jemesi iho döre bamëhoröhe ë hesi öroho bogo naho gavaruje höjo. Bogo naho gavëꞌoho jemë diehiꞌoromo na mae uehorovevorëjo. ");
INSERT INTO aom_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Röhu nadi uvorëjo: Nöröro hesi Vavu hesi örire nosi jö sisëho huruoho majahiꞌajëjo. Na bogo ëhioho ëꞌejöjo. Aꞌiro Moses-ro jemesi jö sisëho huruoho majahiꞌajëjo. Jemë uvaruje höjo: Moses-ro ajamuiꞌiramu mae raromoꞌejarë uvaruje höjo röhu hesi jöho bogo ejaharuje höjo. Ëhuni huro huruoho majahiꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Ëhesi bëhoho jemëro Moses-are jöho ejahoꞌibejarijëjo nasi jöhuꞌo ejehoꞌibejarijëjo. Huro nasi jöho jajivëꞌego ëhuni uëvajëjo. ");
INSERT INTO aom_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Röhu huhu jajivoꞌamade jö bogo ejaharujoho jemë diehiꞌoromo nasi jöho ejehorëjo. ");
INSERT INTO aom_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Ëhiꞌonugoromo Iesumëro boat-re ajio raromoromo Galilee eꞌu döre eꞌu hesi iho göho Tiberias eꞌu ioni göre ë vaꞌareje. ");
INSERT INTO aom_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Vaꞌamu ae ahoꞌobëhe mae Iesuro darugoꞌe muoho vaeromo guomo guomoꞌe ae ajëmamu mamiꞌe gavëꞌëro Iesu ijore rihiromoruomadeje. ");
INSERT INTO aom_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Amo Iesuro hesi ijorajo ömoꞌömoho söjëvo ujuohoromo dahorure ajiomoromo jabuꞌo ë hijadeje. ");
INSERT INTO aom_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Ëmajaho God-hu Vörö Tugohade Majaho Jew rajo jabesi sörö majaho dunovadeje. ");
INSERT INTO aom_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Evare majare Iesuro dahorure hiromo uherihoꞌi gavadeje ae ahoꞌobëhe ijore rojomoruomamu. Rojomamu gëgorovo Philip uavadeje: No dinöꞌe ioho imoromo ë aribövioho ahoꞌo daꞌuojëhoꞌejarëjo. ");
INSERT INTO aom_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Hu mamiꞌe gavadeje rabe ëꞌiröhoho. Röhu huro Philip uavadeje heꞌi Philip-ro diehi uavego. ");
INSERT INTO aom_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Amo ëhi ua gavamu Philip-ro uavadeje: Monie ahoꞌobëhe 200 kina röhu döre göꞌo buꞌöromo ie imoromo iꞌimëmiꞌibejarëjo ae ahoꞌo jiëꞌëro ma-bisemu bisemu ueꞌahoruomoꞌibejajo. ");
INSERT INTO aom_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Ëhi uavamu Iesuare ijoraje ae gö hesi ihoho Andrew Simon Peter-are öhuro uavadeje: ");
INSERT INTO aom_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","Aharihe gemu iae höjo. Hu ie ahoꞌobëhe 5 visue niöꞌi ëhi jiajëjo. Röhu jaꞌo uehorovëjo ëho bogo eni höjo ae ahoꞌobëhe jiëꞌëro. ");
INSERT INTO aom_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Ëhi uavamu hegorovo Iesuro hesi aribövioho uëvadeje: Ae ahoꞌobëhe uëvego saꞌare raromarëjo. Röhu ë diröꞌoho ma-garasiemu jiëꞌe jiadeje. Ëhiꞌamu ae ahoꞌobëhe 5,000 rabuꞌe ë raromareje. ");
INSERT INTO aom_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Raromamu Iesuro ë aharihehu ujuoho rovade ioho ujuohoromo God mae uaromo raromarue aribövioho iꞌimëmadeje. Ëhiꞌoromo visuohuꞌo ujuohoromo ëhi gemuoho ëꞌadeje. Ëhiꞌamu ë ariböviohuro diminoꞌe iꞌi nimarëhi ëhi ueꞌahareje. ");
INSERT INTO aom_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Ueꞌahoromo daꞌuëgamu gagorovo Iesuro hesi ijorajo ömoꞌömoho uëvadeje: I vitu vituoho gagovorego bogo mae bogo muꞌuꞌirajo. ");
INSERT INTO aom_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Ëhi uëvamu ie ahoꞌobëhe 5 ueꞌahare ë hesi vitu vituoho gagovoromo esöe ahoꞌobëhe 12 irijiomoꞌamareje. ");
INSERT INTO aom_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Irijiomoꞌamamu Iesuhu bëhiꞌe mu börömo vaejadoho ae ahoꞌobëhe garomo uarovareje: No muebejarue höjo jö God-aro baeromo majahuijaje a börömohuro saꞌare rueröhego. Ëaho jiajëjo. ");
INSERT INTO aom_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Ëhi uvoromo rueromo Iesu ëma guduamoromo uaꞌirögoro ëꞌareje: Jero nosi börömoho jionëjo. Ëhi ëꞌiaꞌamu gëgorovo Iesuro vaꞌadeje. Vaꞌoromo dahorure vuonoröꞌö ajiomoromo hesi sivue hijadeje. ");
INSERT INTO aom_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Majae bevaꞌiaꞌamu Iesuare ijorajo ömoꞌömohuro eꞌu riröre abuejareje. ");
INSERT INTO aom_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Abueromo boat-re ajio raromoromo Capernaum amore vaꞌi jovo döre vaꞌareje. Vaꞌamu vahiromëvadeje. Röhu Iesu evaroho jabesiriroho bogo rovëꞌe jiadeje. ");
INSERT INTO aom_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Bogo rovamu gavareje buru börömoho rueꞌego jovoho hasajamu. ");
INSERT INTO aom_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Jovoho hasajamu jovo döre huoꞌöbe vaꞌaroho 5 o 6 kilometre ëminoꞌe vaꞌaroho vaꞌihö gavare Iesuro jovo döre juvobe jabesi bëhire rovamu gagorovo juhuonivareje. ");
INSERT INTO aom_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Juhuonivamu uëvadeje: Na jevajëjo. Nadi juhuonivohëjo. ");
INSERT INTO aom_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Nadi juhuonivohëjamu hegorovo jaburo nimareje Iesuro boat gagore rojomojöro. Ëhiꞌoromo dinöꞌe vaꞌi nimarire ë ma-burëro vaꞌareje. ");
INSERT INTO aom_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Iesuꞌo hesi ijorajo ömoꞌömohuꞌo ëhi jovo ioni gönö vaꞌi aꞌi iꞌo visuꞌo ueꞌahare aribövie ahoꞌobëhe mae jovo ioni gönö ëhi raromareje. Raromëꞌëro nërö gavareje Iesu bogojiamu. Bogojiamu uvoruomadeje: Nëröho boat gemuëro ave jovo riröroho namiꞌi boat gö gö bogojiohijajo. Röhu Iesu ë boat-roho bogo vaꞌi hesi ijorajohuremu vaꞌoruomade höjo. ");
INSERT INTO aom_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Ëhi uvoromo gavareje boat gö gö Tiberias amore jioromo rueromo Bada Iesuhu Vavu mae uavamu i ueꞌaharinö ë ro riravamu. ");
INSERT INTO aom_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Boat gö gö ro riravamu gagorovo gavare Iesuꞌo hesi ijorajo ömoꞌömohuꞌo bogojëvamu gëgorovo arue boat göre göre iojiomoromo Iesu nahoꞌirögoro Capernaum amore vaꞌoruomadeje. ");
INSERT INTO aom_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Vaꞌaroho jovo ioni gönö vaꞌo baboro beromo Iesu birohoruomadeje. Birohoromo uaruomadeje: Tisa ja divare aveho rovane höjo. ");
INSERT INTO aom_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Divare aveho rovane höjamu hegoro uëvadeje: Ave jöho na jö mae uëꞌiëꞌajëjo. Jemëhu na nahevaruje hesi bëhoho jemë bogo uehorovoromo uvarije höjo: Nöröro bëhiꞌe mu masijoho röjahuijëꞌe hö uvoromo ëhunioho nahevoꞌi aꞌi jemë ie ahoꞌobëhe ueꞌahamu daꞌuëgadohuni ëhuni nahevarujëjo. ");
INSERT INTO aom_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Röhu mudurohoꞌiröhe iënioho nadi muoho vaeꞌi aꞌi jiemu jioröhe iohuremu uehorovoromo muoho vaerego ëhuro ma-ioroꞌioremu maro raromoꞌirarije höjo. Ëioho God-are A Maho naro suvuorëmiꞌejöjo rabëni God Vavuohuro a nuniro uevëꞌego: Jasi muoho mae höjo. ");
INSERT INTO aom_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Ëhi uëvamu uaruomadeje: Ëhi jiëꞌoho no diehi jiëꞌe muoho vaeromo ëhuro God-hu nimaje muoho vaeꞌamoꞌejarëjo. ");
INSERT INTO aom_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Vaeꞌejarëjamu uëvadeje: God-hu nimaje mu vaeꞌirarijoho aviëhi höjo huhu saꞌare remöꞌöjade aho na jemëhu mae uehorovevoꞌirarijoho. Iae ëhi ëꞌorëjo. ");
INSERT INTO aom_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Ëhi ëꞌorëjamu uaruomadeje: Röhu jaꞌo ja mu rabe vaenëjo. Diehi jiëꞌe darugoꞌe muoho ömoꞌiramu no garomo mae uehorovoꞌejarëjo ");
INSERT INTO aom_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Iae urimëꞌi nosi hijo mionoꞌohuro darugoꞌe muoho iae gavare höjo. A rumoꞌe saꞌare raromo jijiharevare evare bogo ijarue i mabëhi hesi ihe manna ueꞌahoruomade höjo. God-are surire uvëꞌe höjo: Öꞌidöre jioromo ruvebijade ioho huro iꞌimëmade höjo jaburo ueꞌahoröhego. ");
INSERT INTO aom_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Ëhi uavamu Iesuro uëvadeje: Iae jemë uevarujëjo: Öꞌidöre jioromo ruvebijade ioho Moses-ro nosi hijo mionoꞌoho iꞌimëmade höjo ueꞌahoröhego. Röhu aveho na jö mae uëvajëjo. Ëjö hesi bëhoho avoho uehorovoromo uvorëjo: Bogo Moses-hu mamiꞌe bojëmade jöho jioꞌi aꞌi nöruare Vavuehu avevejöꞌe öꞌidöre i ma bojamuijaje jöho höjo. ");
INSERT INTO aom_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","God-hu bojëmaje iohuro öꞌidöre jioromo ruvebiromo birire bojëmego saꞌae dinöꞌe dinöꞌe iꞌovoromo maro raromarue höjo. ");
INSERT INTO aom_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Maro raromarue höjamu uvareje: I ma hesi jöho jövajëromo uavareje: No naguajëjo jero majae ëhi ë ioho bojamuinövoꞌiranego. ");
INSERT INTO aom_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Ëhi uavamu uëvadeje: Röhu ë i hesi bëhoho na iꞌovëvajoho jevajëjo. Ae rahu nasinö rovëꞌoho ijoho bogo hömoꞌajëjo. Mae uehorovevëꞌoho ijoho bogo huëho girihoꞌaꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Röhu na mamiꞌe uëvode höjo: Jemë na gevëꞌe jëvajëjo röhu bogo ma uehorovevaruje höjo. ");
INSERT INTO aom_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Nasi Vavuehu ae rahu bojemijëꞌoho ë ariböviohuro nasi örire rueruomaje höjo. Ae rahu nasi örire rovëꞌoho na bogo mae bogo uëꞌejöjo: Roriꞌo vaꞌohëjo ");
INSERT INTO aom_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","rabëni naehu öꞌidöre jioromo ruvebijode hesi bëhoho bogo nasi nimaje muoho ömoꞌi aꞌi saꞌare na remöꞌöjade aehu nimajohemu ömoꞌirodëni rovëꞌëro. ");
INSERT INTO aom_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Hu nimajëjo huhu bojemade aribövioho na bogo ae gemu vaduꞌoho boremiꞌöꞌi aꞌi muebejëvojuvo ijo tugohoꞌi majare naro ajëmego vuovoromo riꞌöruomoröhego. ");
INSERT INTO aom_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Nasi Vavuohuro aveho nimaje höjo ae rahu Harihu na geromo mae uehorovevëꞌoho ma-ioroꞌioremu maro raromoruomoröhego. Ëaribövioho ijo tugohoꞌi majare naro iꞌovëvoꞌiramu jabumë riꞌöromo raromoꞌaruëjo. ");
INSERT INTO aom_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Röhu Iesuhu öꞌidöre jioromo inöꞌe rueromo a iꞌovëvaje jöho ëhi majëhijamu hegorovo Jew rajo ariböviohuro dë vörönëgamu jöe sisëꞌi atoruomadeje. ");
INSERT INTO aom_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Jöe sisëꞌi atoromo uarovareje: Ave iaho Joseph-are harihe höjo. Hesi vëmu vavuꞌoho iae no gëvarue höjo. Röhu hu rabëni uvajëjo: Na öꞌidöre jioromo ruvebijëꞌe jevajëjo. ");
INSERT INTO aom_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Ëhi uarovamu uëvadeje: Nadi nasi jöho sisëꞌioho atohëjo. ");
INSERT INTO aom_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Aho bogo jabesi ëma rueromo naꞌoho raromoꞌi aꞌi nasi Vavue saꞌare remöꞌöjadohuro rinëgamu ëhuro nasirire rueruomëꞌoho eni jëvaje höjo. A ioroꞌioroho bogajo. Rovëꞌoho naro ijo tugohoꞌi majare iꞌovëvoꞌiramu vuovoromo riꞌöruomoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Mamiꞌe jö God-aro baeromo majëhinövare ariböviohuro jajivoromo uvare höjo: God-ro ae ahoꞌobëhe röjëhiꞌiramu hesi jöho heruomoꞌajëjo. Ëhi jajivëꞌe höjo. Röhu Vavuehu hesi jö röjëhijamu ae rahu heromo ejahëꞌoho nasi örire rueruomaje höjo. ");
INSERT INTO aom_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Ëhi höjo röhu aho Vavuoho bogo gavëꞌe höjo. God-arire jioromo ruvebijode aho naremuëremu Vavuoho gavëꞌe jevajëjo. ");
INSERT INTO aom_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Ave jöho na jö mae uëꞌiëꞌajëjo. Ae rahu mae uehorovevëꞌoho mamiꞌe aevëꞌëro ma-ioroꞌioremu maro raromaruje höjo. ");
INSERT INTO aom_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","A iꞌovëvaje ioho na jevajëjo. ");
INSERT INTO aom_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Jemesi hijo mionoꞌohuro a rumoꞌe saꞌare raromo jijihoromo bogo ijarue i mabëhi hesi ihe manna inövare höjo. Inövare höjo röhu vuovëvade höjo. ");
INSERT INTO aom_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Aꞌi öꞌidöre jioromo ruvebijaje ioho ae rahu ijëꞌoho ëhuro bogo vuovëvoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Öꞌidöre jioromo ruvebijëꞌëro a iꞌovëvaje ioho na jevajëjo. Ae rahu ë i ijëꞌoho ma-ioroꞌioremu maro raromoꞌarujëjo. Naehu bojëmiꞌirode ioho ëho nasi sine höjo. Ëhesi bëhoho nasi sinoho bojamirovoꞌejöjo saꞌae ahoꞌobëhe vuovëvadoho iꞌovoromo mae raromoꞌirarijego. ");
INSERT INTO aom_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Ëhi majëhijamu hegorovo Jew rajohuro dë vörönëgamu jö ahoꞌahamirovoromo uarovareje: Ëaho diehi hesi sinoho bojamuiꞌiramu iꞌejarëjo. ");
INSERT INTO aom_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Iꞌejarëjamu uëvadeje: Ave jöho na jö mae uëꞌiëꞌajëjo. God-are A Ma nasi sinohuꞌo köhuꞌo bogo ijëꞌoho darugoho bogo baeꞌi vuovëvoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Ae rahu nasi sino kö ijëꞌoho ma-ioroꞌioremu maro raromarue höjo. Raromojuvo ijo tugohoꞌi majare iꞌovëvoꞌiramu riꞌöꞌaꞌaruëjo. ");
INSERT INTO aom_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Ëhesi bëhoho nasi sinoho iae i mae jioꞌi nasi köho iae jovo mae jiëꞌëro ëhuꞌëro ijëꞌoho mae raromoꞌaruëjo. ");
INSERT INTO aom_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Ae rahu nasi sinohuꞌo köhuꞌo ijëꞌoho naꞌo gemu mae jioꞌi na jabuꞌo gemu mae jevaje höjo. ");
INSERT INTO aom_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Vavue daruge eni jiëꞌëro hijajohuro na saꞌare remöꞌöjade höjo. Remöꞌöjëꞌëro darugoho bojemijego na hijaje höjo. Naehu hesi darugo baeromo hijajëhi ae rahu na ijevëꞌoho nasi darugoho ëhi baeromo raromoꞌaruëjo. ");
INSERT INTO aom_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Ëhuꞌëro jiëꞌëro öꞌidöre jioromo ruvebijade i hesi jöho na majëhijëꞌe jevajëjo. Jemesi hijo mionoꞌe jabesi i mabëhe ueꞌahare höjo röhu vuovëvade höjo. O naehu uëvaje ioho bogo ëhioho jioꞌi ae rahu ijëꞌoho bogo vuovëvoꞌi ma-ioroꞌioremu maro raromoꞌaruëjo. Ahia minoꞌëjo. ");
INSERT INTO aom_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Iesuhu Capernaum hiromo God rajahijarue osare jö röjëhijadevare evare hu ë jöho majëhijadeje. ");
INSERT INTO aom_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Ëhi majëhijamu hegorovo Iesuare ijore ijore jijiharue a ioroꞌioroho ae ahoꞌobëhe uarovareje: Ëhi jiëꞌe jöho iꞌu maꞌe höjo. Nomë diehiꞌoromo baeꞌejarëjo. ");
INSERT INTO aom_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Baeꞌejarëjamu Iesuro hesi simanore garomo uvadeje: Nasi ijore ijore jijiharue ariböviohuro nasi jöho bijönimoromo sisëꞌi ataruëromo uëvadeje: Naehu öꞌidöre jioromo ruvebijode jö hejarijoho jemë diehi uehorovarujëjo. Na jemë nëgajëjo naꞌo jijiharujoho vuonugoꞌi. ");
INSERT INTO aom_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Röhu jemë gevëꞌoho God-are A Ma naehu urimo hijodire sionëro ajiomamu gevëꞌoho jemë diehi uehorovorëjo. ");
INSERT INTO aom_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Hesi God-are Aruꞌahohuro darugoho bojëmiꞌiramu iꞌovoromo mae raromoꞌarujëjo. Jemesi sino hesi biriroho baeromo arijoꞌarije ajamirovoꞌiëꞌiroho bogo eni jëvoꞌajëjo. Röhu naehu jövaje jö ejahëꞌohuro ëhuro Aruꞌaho daruge baeromo iꞌovoromo mae raromoꞌarujëjo. ");
INSERT INTO aom_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Röhu a ioroꞌioroho jemëro bogo ma uehorovevaruje höjo. Ëhi uëvade hesi bëhoho mamiꞌe huhu urimo ijorajo gagovëvade majare aevoromo gëromo uvobe rovadeje: Ëaribövioho bogo ma uehorovevoꞌiröhoho höjo. O ë aho a hiruëmiromo na baejevoromo jabesi övore bojëmiꞌiröhoho höjo. Ëhi gëromo uvobe rovëꞌëro ëhuꞌëro uëvadeje: A ioroꞌioroho jemëro bogo ma uehorovevaruje höjo. ");
INSERT INTO aom_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Röhu hesi jö viture uëvadeje: A ioroꞌioroho jemëro bogo ma uehorovevaruje höjo. Ëhuni uëvode höjo: Aho nasi öriroho bogo ëma rueruomaje höjo bogo eni jëvëꞌëro. Ma-Vavuehu uëvëꞌohuremu rueruomaje höjo. ");
INSERT INTO aom_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Ëhi uëvamu hegorovo Iesuare ijore ijore jijiharue aribövi ioroꞌioroho ae ahoꞌobëhe hu nugo vaꞌoruomadeje ijonöho huꞌoho bogo gemuoroho jijihoruomoröhëni. ");
INSERT INTO aom_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Vaꞌamu gëgorovo Iesuro gëvade hesi ijoraje 12-ho ëhi raromamu gëgorovo uëvadeje: Röhu jemëjo. Na jemëꞌo na remo vaꞌorëjo. ");
INSERT INTO aom_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Remo vaꞌorëjamu Simon Peter-ro uavadeje: Bada no rahuare örire vaꞌojörajo. Jero jöho jövego ëhuro no darugoho baeromo ma-ioroꞌioremu maro raromarue höjo. ");
INSERT INTO aom_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Iae no garomo mae uehorovoromo uvarue höjo: God-hu baejavade A Mahuremu ja javajëjo. ");
INSERT INTO aom_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Ja javajëjamu Iesuro uëvadeje: Jemëꞌo uehorovohëjo. Naro jemë ae ahoꞌobëhe 12 baejëvode höjo. Röhu jemesirire ae gemu hu Satan höjo. ");
INSERT INTO aom_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Ëhi uëvadeje. Röhu Satan hö uëvade hesi bëhoho Judas Simon Iscariot-are harihu hesi jöho uëromo ëꞌadeje. Iesuare ijoraje ahoꞌobëhe 12 jioꞌamajoho Judas huꞌo ë ae gemuoho jiadeje. Röhu huro ijonö ae hiruëmiromo Iesu jabesi övore bojëmadeje. Iae ëhuni Iesuro Satan hö uëvadeje. ");
INSERT INTO aom_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Ëhiꞌamu Iesuro garomo uvadeje: Jew rajohuro anegoꞌi nimaruëromo Judea saꞌaroho bogo hiꞌi Galilee saꞌaremu hibe juvadeje. ");
INSERT INTO aom_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Galilee saꞌare hibe juvamu Jew rajo jabesi sörö maja börömoho dunovadeje. Sörö hesi ihoho Amo Harihu Ma-Jahuri Vaeꞌamëꞌe Söröhoje. ");
INSERT INTO aom_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Ësörö majaho dunovamu Iesuare ö maho jaburo riꞌöromo Iesu uavareje: Ave amoho nugoꞌi Judea saꞌahuro vaꞌoromo jasi mu masijoho röjëhijego jasi ijore ijore jijiharue aribövioho jaburo garuomoꞌirajo. ");
INSERT INTO aom_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Ae ahoꞌobëhe jabuhu nosi iho hejöro noehu nimëꞌoho bogo gurihiroho muoho vaejarue höjo. Ëhuni ja mu masije vaejanue javaje jero vaꞌoromo ma-vaꞌorahoro muoho vaenego ae ahoꞌobëhe garuomoꞌirajo. ");
INSERT INTO aom_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Ëhi uavare hesi bëhoho jabumë Iesuare ö ömoꞌöme jëvadeje röhu hesi öriroho bogo ma uehorovëꞌëro ëhuni ëhi uavareje. ");
INSERT INTO aom_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Ëhi uavamu uëvadeje: Nasi majaho bogo rovëꞌe höjo ijonö rueꞌiröhëro. Jemëhu söröro vaꞌirarije majaho majae ahoꞌobëhe höjo. ");
INSERT INTO aom_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Saꞌare mu sisëmu uehorovoruomaje aribövioho jemesi öriroho bogo nu huodëgo varijënoho höjo bëhe bogojioꞌego. Aꞌi nasi örire iae nue huodegarue höjo. Rabëni hesi bëhoho naro majëhiromo uëvaje höjo: Jemë mu sisë vaejaruje hö uëvego ëhuni nue huodegarue höjo. ");
INSERT INTO aom_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Jemesi iojiomoromo maja börömoho vaerëjo. Nasi majaho bogo rovëꞌego söröroho bogo ajiomoꞌejöjo. ");
INSERT INTO aom_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Ëhi uënugoromo Galilee saꞌare ëhi hijadeje. ");
INSERT INTO aom_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Hijamu hesi ö ömoꞌömohuro iojiomareje maja börömoho vaeröhëro. Iojiomamu evare Iesuro huꞌo ajiomadeje. Bogo vaꞌorahoroho ajiomoꞌi ma-saginiëri ajiomadeje. ");
INSERT INTO aom_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Saginiëri ajiomamu Jew rajo a masijohuro sörö ririre Iesu nahoromo uvoruomadeje: Ëaho dinöꞌe höjo. ");
INSERT INTO aom_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Ëhi atoromo ae ahoꞌobëhe gemuore gagovëꞌëro göëro göho saginiëri majahirovoromo Iesuare jöho uarovareje. Uarovoromo a ioroꞌiorohuro uvareje: Ëaho a mae höjo. A ioroꞌiorohuro uvareje: Bogajo. Huro ae ahoꞌobëhe sareramuijaje höjo. ");
INSERT INTO aom_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Ëhi atoromo Jew a masijoho juhuonëmiromo aho bogo vaꞌorahoroho Iesuare jöho atoꞌi ma-saginiëri atoruomadeje. ");
INSERT INTO aom_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Ëhiꞌamu Iesuro sörö maja hesi ririre God-are amo börömore ajiomoromo ae jöe majëhijadeje. ");
INSERT INTO aom_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Jöe majëhijamu hegorovo Jew rajohuro tiöromo uvareje: Ae gö hu bogo röjahijëꞌe höjo. Ëhi jiëꞌoho hu diehiꞌoromo nuni ajiꞌe jioromo jöho majahuijajëjo. ");
INSERT INTO aom_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Jöho majahuijajëjamu Iesuro uëvadeje: Naehu röjëhaje jöho bogo naehu uehorovoromo röjëhiꞌi saꞌare na remöꞌöjade ahuro bojemijëꞌëro röjëhijaje höjo. ");
INSERT INTO aom_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Ae rahu God-hu nimaje mu vaeꞌi nimëꞌoho ë ariböviohuro garomo uvoruomoꞌajëjo: Nörö bogo hesi simanëremuoho jöho ëma röjahuiꞌi aꞌi God-ro jöho bojamijego röjahuijaje höjo. ");
INSERT INTO aom_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Ae rahu jabesi simanëremu jö majëhijëꞌoho jö majëhijarue hesi bëhoho jaburo nimoruomaje höjo jabesi ihoho döro jiojöro. O noehu naguëꞌoho ramuöꞌöjamu rovare a hesi iho döro jiojöro naguëꞌoho ëhi javuëꞌe aribövioho sareroho bogojavuoꞌi ma-maemu javuaje höjo. ");
INSERT INTO aom_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Jemëꞌo uehorovohëjo Moses-ro God-are jögoroho jemë bojëmijade höjo. Röhu jemë bogo ae gemu vaduꞌoho jögoroho ejaharuje höjo. Jemë rabëni ë jöho ahoromo anegoꞌiro ëꞌarujëjo. ");
INSERT INTO aom_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Ëhi uëvamu ae ahoꞌobëhe uaruomadeje: Sarerivanuëjo. Sisëhuro baejavëꞌëro simane sisërëromo jövanuëjo. Raro ja anagoꞌiëꞌego uvanuëjo. ");
INSERT INTO aom_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Uvanuëjamu Iesuro uëvadeje: Naro mue gemu vaejamu jemë ae ahoꞌobëhe tiöromo uehore gö gö baejëꞌe jëvajëjo. ");
INSERT INTO aom_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Röhu Moses-ro aharihu jabesi sino tarivëhoꞌirarije muoho bojëmijade höjo. Bogo huro aevoromo bojëmiꞌi aꞌi urimore jemesi a mamiohuro aevoromo bojëmijare höjo. Bojëmijëꞌëro ëhuꞌëro jemëro nuho majaro mue vaeromo aharihu jabesi sinoho tarivëharuje höjo. ");
INSERT INTO aom_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Nuho majaro jemëro a sino tarivëharuje muoho vaejaruje höjo Moses-are jögoroho ahojöëni. Aꞌi nuho majare naro a hesi sinoho avohahamu marë barëjade höjo. Ëhi jiëꞌoho röhu jemë rabëni uvarujëjo: Nöröro nuho maja hesi jögoroho ahade höromo nasi öriroho dëho vörönimarujëjo. ");
INSERT INTO aom_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Ëhiꞌoromo jemë nasi muoho ma-döemu garomo mevoromo nasi öriroho dëho vörönëgajëjo. Nadi ëhioho ëꞌi nasi mu öroho ma-avoho garomo mevorëjo. ");
INSERT INTO aom_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Ëhi uëvamu gagorovo Jerusalem amo rajo a ioroꞌiorohuro uarovareje: Ëaho nosi a masijehu anoꞌiëꞌarue aho höjo. Na mae-ëjo. ");
INSERT INTO aom_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Röhu gahëjo. Hu a nunire jöe jövajëjo röhu nosi a masijohuro hesi öriroho jöho bogo uaꞌi ma-nunëremu gavaruëjo. Na jabumë garomo uvaruëjo: Ëaho böröme namiromo ajamuiꞌiröhe aho höromo ëhioho ëꞌaruëjo. ");
INSERT INTO aom_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Röhu böröme namiromo ajamuiꞌiröhe aehu rovëꞌiroho hu di amore jioromo rueröhoho no dadivavuoꞌajëjo. Aꞌi ë aho di amore jioromo rovadoho iae no gavaruëjo. Ëhuni hu bogo ë aho höjo. ");
INSERT INTO aom_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Ëhi atamu Iesuro hejadeje. Heromo God-are amo börömore hiromo jöho majëhiromo ma-darugoꞌo uvadeje: Jemëro uvarujëjo: Noro nörö iae mae gavaruëjo. Di amore jioromo rovadoho ëhuꞌo gavaruëjo. Röhu jemë bogo avoho gevaruje höjo. Na bogo nasi ëma rueꞌi Vavuohuro remöꞌöjamu rovode höjo. Ëaho hu mae höjo. Röhu jemë hu bogo gavaruje höjo. ");
INSERT INTO aom_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Naro hu gavaje höjo naro huꞌo jiamu huro na remöꞌöjamu rovëꞌëro jevëꞌëro. ");
INSERT INTO aom_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Ëhi uëvamu hegorovo guduamoꞌiëꞌoromo hesi majaho bogo rovëꞌe jiamu vuonugareje. ");
INSERT INTO aom_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Vuonugamu a ioroꞌioroho ahoꞌobëhe Iesu mae uehorovareje. Mae uehorovoromo uarovareje: Böröme namiromo ajamuiꞌiröhe aehu rovëꞌiroho na huro ave aho iosiramiromo bëhiꞌe mu masijoho vaeꞌaꞌajëjo. Bogajo. Ëhuni nani hu ë rueröhe a börömoho höjo. ");
INSERT INTO aom_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Jö ëhi vaerovobe rovaruoho Pharisee ariböviohuro hejareje. Heromo jabuꞌo priest masijohuꞌo ëho jaburo jabuni atovarue aribövi ioroꞌioroho rëmöꞌöjareje vaꞌoromo Iesu guduamo barueröhego. ");
INSERT INTO aom_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Ëhiꞌamu Iesuro ae uëvadeje: Majae ma-bunemu jemëꞌo hiromo remöꞌöjamu rovode a hesirire vuonoröꞌö vaꞌejöjo. ");
INSERT INTO aom_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Vaꞌiramu jemëro na nahevoromo bogo birohevoꞌarujëjo. Naehu hiꞌirodire jemëhu ë öꞌirarijoho bogo eni jëvoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Öꞌirarijoho bogo eni jëvoꞌajë uëvamu Jew rajo a masijohuro uarovareje: Ëaho dinöꞌe vaꞌego no bogo birohoꞌiröhego uövuajëjo. Na hu Jew rajehu saꞌa göre vaꞌo raromaruire ë vaꞌoromo God rumoꞌe aribövioho jöe röjëhiꞌiröhëni uvajëjo o dinöꞌe vaꞌi uvajëjo. ");
INSERT INTO aom_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Hu uvajëjo: Jemë na nahevoromo bogo birohevoꞌarujëjo. O naehu hiꞌirodire jemëhu öꞌirarijoho jemë bogo eni jëvoꞌajëjo. Ëhi jiëꞌe jöho hu diehi jövoromo ëꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Ëhiꞌamu sörö maja böröme jiobe ruejuvo ijo tugohoꞌi maja börömo maho rovadeje. Rovamu evare Iesuro döre riꞌö namiromo ma-darugoꞌo uvadeje: Jovo ueꞌahoꞌi nëgëꞌiroho nasi öroro rueromo irëjo. ");
INSERT INTO aom_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Ae rahu na mae uehorovevëꞌoho God-are surire jö jajivoromo uvarëhi ëhi jëvoꞌajëjo. Ëhesi bëhoho ae rahu mae uehorovevëꞌoho a iꞌovëvaje jovohuro jemesi dë vövöbajoꞌere jioromo rojomoromo suorovo vaꞌiramu aho iꞌovëvoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Ëjovo jö hesi bëhoho God-are Aruꞌaho hesi jöho jövoromo ëꞌadeje Iesu mae uehorovarue ariböviohuro ijonö ëho baeꞌiröhego. Iesuhu ëhi jövade majaroho Aruꞌahoho bogo saꞌaroho nugöꞌöjëꞌe jiadeje ë hesi bëhoho Iesu öꞌidöroho bogo ajiomoromo ajoho baejëꞌëro. ");
INSERT INTO aom_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Ëhi jövamu hegorovo a ioroꞌioroho ae ahoꞌobëhe uvareje: Ëaho iae jö God-aro baeromo majahuijaje a börömoho rueröhego muebejaruoho höjo. ");
INSERT INTO aom_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","A ioroꞌiorohuro uvareje: Ëaho böröme namiromo ajamuiꞌiröhe aho höjo. A ioroꞌiorohuro uvareje: Hu bogo ë aho höjo. Hu Galilee rajo ae höjo. Röhu böröme namiromo ajamuiꞌiröhe aho bogo Galilee saꞌaroho jioromo rueꞌaꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Aꞌi God-are surire jajivoromo uvëꞌe höjo: Böröme namiromo ajamuiꞌiröhe aho David-are ujoho jiëꞌëro David-hu hijade ame Bethlehem ë rahoꞌaꞌajëjo. Aꞌi Iesu Galilee rajëro jiëꞌëro ëhuꞌëro hu bogo ë uehorovarue a börömoho höjo. ");
INSERT INTO aom_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Ëhi atoromo ae ahoꞌobëhe Iesuare jöho jöe gö gö uehorovareje. ");
INSERT INTO aom_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","A ioroꞌiorohuro Iesu guduamoꞌi nimareje. Röhu aho hesi sinoroho övoho bogo bamareje. ");
INSERT INTO aom_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Ëhiꞌamu Pharisee ömoꞌömohuni priest masijohuni atovarue ariböviohuro mamiꞌe Iesu guduamo barueꞌi vaꞌëꞌëro övemu vuonoröꞌö rovamu gëgorovo jabesi masijohuro uëvareje: Jemë rabëni hu bogo guduamo barovarije höjo. ");
INSERT INTO aom_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Barovarije höjamu uëvareje: Urimëꞌi aehu bogo ëhi jiëꞌe jö ma jövamu hejaroho ë iahuro jö maho jövamu hegoro ëhuni vuonugare höjo. ");
INSERT INTO aom_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Vuonugare höjamu Pharisee ariböviohuro uëvareje: Na hu jemëꞌo sarerëmiromo jaguvëvade höjo. ");
INSERT INTO aom_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Jemë gavarujoho di a masijohuro o di Pharisee ahuro hesi öriroho maho uehorovëꞌe javuajëjo. Bogoꞌe höjo. ");
INSERT INTO aom_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Hesi ma-raromo jijihoꞌe vaejarue ariböviohuremu Iesu mae uehorovarue höjo. Jabumë Moses-are jögoroho bogo hejaruëro jiëꞌëro ëhuꞌëro God-are iꞌuoho baeruomo hesi höjo. ");
INSERT INTO aom_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Pharisee ömoꞌömohuro ëhi uënugoromo jabesi ae gemu Nicodemus-ro mamiꞌe Iesu gaꞌi vaꞌadohuro riꞌöromo uëvadeje: ");
INSERT INTO aom_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","Ëjöho bogo maehu höjo. No aho bogo ëma uavarue höjo: Sisëro vaꞌëjo. Nosi jögoroho bogo ëhioho höjo. Urimo huro hesi jöꞌëro jöho jövego heromo huhu rabe rabe ëꞌadoho heromo evare uavarue höjo: Ja iꞌue baejëꞌe javajëjo. ");
INSERT INTO aom_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","53","Ëhi uëvamu sivoromo uavareje: Sareri ae javajëjo. Na ja Iesuare saꞌae gemuoho Galilee rajëro javëꞌëro ëhuni ja hesi öroho avohanuëjo. Röhu jaꞌo God-are surire jöho avoho adahoromo ganëjo jö God-aro baeromo majahuijarue aehu Galilee saꞌare jioromo rueröhe jöho bogojiajoho. ");
INSERT INTO aom_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Ëhiꞌamu ae gemu gemu jabesi osaëro osaëro vaꞌirögoro Iesuro aruhe Olives Dahorure ajiomadeje. ");
INSERT INTO aom_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Ajiomoromo niavëꞌëro sueꞌo riꞌöromo God-are amo börömore vuonoröꞌö rovadeje. Rueromo gavade ae ahoꞌobëhe hesi bëhire rueruomamu gëgorovo saꞌaro hiromo aevoromo jöho röjëhijadeje. ");
INSERT INTO aom_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Jöho röjëhijamu gagorovo Moses-are jögoru öri röjëhijarue ariböviohuꞌo Pharisee ömoꞌömohuꞌo ëho jaburo masuvëꞌe magonahe gemu huꞌirae baeromo rovareje mamiꞌe ë magonahohuro ae göꞌo niavamu aëro garomo guduamëꞌëro. Huꞌirae barueromo ae ahoꞌobëhe jabesi nunire nugareje. ");
INSERT INTO aom_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Nunire nugoromo Iesu uavareje: Tisa ave magonahohuro ae göꞌo niavamu aëro gavare höjo. ");
INSERT INTO aom_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Röhu mamiꞌe Moses-ro jögoroho jajivoromo uövuade höjo ëhi jiëꞌe magonahoho munëro vajamiꞌiröhego. Röhu ja diehi uehorovanuëjo. ");
INSERT INTO aom_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Ëhi uavare hesi bëhoho jabumë nimareje Iesuro jöe sisëꞌi jövego jöho jaburo court-re huruoho majëhiꞌiröhëro. Ëhuni ëhi uavareje. Ëhi uavamu hegorovo Iesuro jöho bogo uëvëꞌe ma-uruhoꞌamoromo övo namëro saꞌare jajivadeje. ");
INSERT INTO aom_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Saꞌare jajivamu jö ua gaꞌi arijaroho bogo mana uëvëꞌe ma-saꞌare jajivojuvo hujeji ijonö ririrohoromo uëvadeje: Jemë di aharo sisë rumoꞌe javego aevoromo munëro vajamijëjo. ");
INSERT INTO aom_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Munëro vajamijëromo röhu maho uruhoꞌamoromo saꞌare jajivadeje. ");
INSERT INTO aom_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Saꞌare jajivamu huhu jövade jöho heromo ë ariböviohuro vaꞌoruomadeje. Amaꞌi mavojoho jaburo aevoromo huruomoromo gemu gemu riꞌö vaꞌojuvo ijore a iꞌoho vaꞌamu barëjadeje. Barëjamu Iesu hesi sivue jioꞌi magonahoho hesi nunire ë namijëꞌe jiadeje. ");
INSERT INTO aom_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Namijëꞌe jiamu Iesuro ririrohoromo magonahoho uavadeje: Maꞌino aribövioho dinöꞌe jioruomajëjo. Na jasi sisë mevoromo iꞌu bojamiꞌiröhe aho bogohöjo. ");
INSERT INTO aom_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Uavadeje: Bada ae bogohöjo. Ëhi uavamu uavadeje: Ëhi jiëꞌoho naꞌo jasi jö sisëho bogo jövoromo iꞌuoho bojamiꞌejöjo. Vaꞌoromo nadi ijoho ëhi jiëꞌe muoho vaenëjo. ");
INSERT INTO aom_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Ëhiꞌëꞌëro Iesuro röhu maho jöe majëhiromo uëvadeje: Na ajoho jevëꞌëro saꞌae dinöꞌe dinöꞌe ajivëvaje höjo. Ae rahu nasi ijore ijore jijihëꞌiroho bogo mae bogo ramoramoroho jijihoꞌi ajoho baeromo maro raromoꞌaruëjo. ");
INSERT INTO aom_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Maro raromoꞌaruëjamu Pharisee ömoꞌömohuro uavareje: Röhu jero jasi sivue jasi jöho majahuiromo uövuanuëjo: Nasi jöho mae höjo. Ëhi jiëꞌoho no jasi jöho diehi maho uehorovoꞌejarëjo. Öre bogohöjo. ");
INSERT INTO aom_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Öre bogohöjamu uëvadeje: Iae mae-ëjo. Iae na nasi sivue jöho majëhijajëjo. Röhu nasi jöho iae mae höjo. Rabëni hesi bëhoho na dinöꞌe jioromo rovodoho o dinöꞌe vaꞌirodoho naro gavaje höjo. Jemë ëho bogo gavaruje höjo. ");
INSERT INTO aom_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Jemëro ma-saꞌa hesi uehore baeromo ae magonahe sisëro bahijaruje höjo. Na bogo aho sisëroho bahijaje höjo. ");
INSERT INTO aom_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Röhu na sisëro bahiꞌi uehorovoꞌibejöjo sareriꞌe jöho bogo uehorovoꞌi ma-mae ëꞌibejöjo. Rabëni hesi bëhoho na bogo nasi sivuoho mevoromo jöho jövoꞌi naꞌo Vavue remöꞌöjadohuꞌo noro niöꞌiro mevoromo jöho majëhijarue höjo. ");
INSERT INTO aom_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Ëhesi jöho jemesi jögoru surire ave jöho jajivoromo uvëꞌe höjo: Ae niöꞌiehu mu garomo ajamirovoromo jöe gemuoho majëhijamu gavëꞌoho uvorëjo: Jabesi jöho iae mae höjo. Ëhi jajivëꞌe höjo. ");
INSERT INTO aom_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Naro nasi jöho majëhijego nasi Vavue saꞌare remöꞌöjadohuro huꞌo nasi jöe gemuoho majëhijaje höjo. Ëhuni nasi jöho iae mae höjo. ");
INSERT INTO aom_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Mae höjamu uavareje: Röhu jasi Vavuoho dinöꞌe höjo. Dinöꞌe höjamu Iesuro uëvadeje: Jemë naꞌo nasi Vavuohuꞌo bogo gövuaruje höjo. Jemë na geꞌibejarijëjo nasi Vavuohuꞌo gaꞌibejarijëjo. ");
INSERT INTO aom_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Iesuro God-are amo börömore hiromo God-ni suvuoro bahijarue osare jö röjëhijadevare evare ë jöho majëhijadeje. Majëhijamu aho hu bogo guduamo bavaꞌareje hesi majaho bogo rovëꞌëro jiëꞌëro. ");
INSERT INTO aom_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Ëhi ëꞌëꞌëro iae Iesuro jöe gö Jew rajoho majëhiromo uëvadeje: Naro öre gö vaꞌejöjo. Vaꞌiramu jemëro nahevoꞌarujëjo. Nahevoꞌiramu röhu mu sisëꞌe jëvoromo vuovëvoꞌajëjo. Vuovëvoꞌiramu naehu vaꞌirodire ë öꞌirarijoho bogo eni jëvoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Bogo eni jëvoꞌajëjamu rue Jew rajohuro uarovareje: Huro uövuajëjo: Naehu vaꞌirodire ë öꞌirarijoho bogo eni jëvoꞌajëjo. Hu diehi uöromo jövajëjo. Na hu anorovoꞌi jövajëjo. O diehi ëꞌiro jövajëjo. ");
INSERT INTO aom_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Diehi ëꞌiro jövajëjamu Iesuro uëvadeje: Jemë ave saꞌare sisëꞌi raromaruje aribövie jëvoꞌi na aruhe döre jioromo ruvebijëꞌe jevajëjo. Jemë ave saꞌaho raje jëvoꞌi na bogo ave saꞌa rajehu jevoꞌi dö raje jevajëjo. ");
INSERT INTO aom_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Ëhuni uëvajëjo: Jemë sisëꞌe jëvoromo vuovëvoꞌajëjo. Jemë bogo ma uehorovevoromo uvëꞌoho: Nöröhu uëvaje ë aho hö uvëꞌoho sisëꞌe jëvoromo vuovëvoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Vuovëvoꞌajëjamu uavareje: Ëhi jiëꞌoho ja rahuo javajëjo. Ja rahuo javajëjamu uëvadeje: Na aevoromo uëbe rovode ë aho jevajëjo. ");
INSERT INTO aom_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Jemesi mu sisë jöho ahoꞌobëhe nasiriro jiajëjo jövoꞌirodoho. Röhu remöꞌöjade aehu uevamu hejode jöho na ëhuremu jövaje höjo saꞌare raromaruje aribövioho jemëro hejöro rabëni hesi bëhoho remöꞌöjade aho jö maemu jövajëro jiëꞌëro. ");
INSERT INTO aom_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Ëhi uëvamu jaburo bogo avoho uehorovoromo uvareje: Remöꞌöjade hö uövuaje aho Vavuoho höjo. ");
INSERT INTO aom_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Bogo ëhioho uvoruomamu Iesuro uëvadeje: God-are A Maho na banigojiomevoromo döre nugevëꞌiroho evare jemë avoho garomo uvoꞌaꞌarujëjo: Nöröhu uëvaje ë aho höjo. Evare jemë garomo uvoꞌaꞌarujëjo: Na bogo nasi simanoho muoho vaeꞌi Vavuehu röjehijade jöhuremu jövaje höjo. ");
INSERT INTO aom_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Remöꞌöjade ahuro bogo vuororemiromo vaꞌi naꞌo hijaje höjo hu nimaje muoho naro majae ëhi vaejajego. ");
INSERT INTO aom_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Ëhi uëvamu hegorovo ae ahoꞌobëhe hesi örire mae uehorovareje. ");
INSERT INTO aom_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Jew rajo ioroꞌiorohuro Iesuare jöho mae uehorovamu gagorovo uëvadeje: Jemë nasi jö ejehonövëꞌoho nasi ijorajo mae jëvoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Ëhi jëvoꞌiramu jö maho gaꞌaꞌarujëjo. Jö maho garomo ëhuro ijonöho iꞌuꞌe mu hesi uhure jëvajoho barëjëvoꞌi ma-sasohëꞌe mu hesi aharire jëvoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Jëvoꞌajëjamu uavareje: Iae ëhi höjo röhu no Abraham-are ujo ömoꞌömëro javuëꞌëro avare iꞌuꞌe mu hesi uhuroho bogo raromobe rovëꞌe javuajëjo. Ëhi jiëꞌoho ja diehi uöromo ëꞌanuëjo: Iꞌuꞌe mue jëvajoho barëjëvoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Barëjëvoꞌajëjamu Iesuro uëvadeje: Ave jöho na jö mae uëꞌiëꞌajëjo. Ae rahu sisë vaejaruoho mu sisë hesi uhure jioruomajëjo. ");
INSERT INTO aom_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Iꞌuꞌe mu vaemu vaejarue ariböviohuro aganohuꞌo ma-jahuri raromoꞌi harihu ömoꞌömohuro aganohuꞌo ma-ioroꞌioremu raromarue höjo. ");
INSERT INTO aom_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Jemë iꞌuꞌe mu hesi uhure jëvamu Harihu naehu tugohëhëꞌoho ëhuro iae mu ma hesi aharire jëvoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Iae na garomo uvajëjo: Jemë Abraham-are a uje jëvajëjo. Röhu nasi jöho bijönëgoꞌego ëhuni anegoꞌiëꞌarujëjo. ");
INSERT INTO aom_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Nasi Vavuehu röjehijamu gavode jöho naro jövaje höjo. Aꞌi jemëro jemesi vavuehu uëvamu hejarije jöho ejahoromo ömaruje höjo. ");
INSERT INTO aom_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Ömaruje höjamu uavareje: Röhu nosi aevoꞌi jiade vavuoho Abraham jioꞌi no hesi ujo ömoꞌömoho javuajëjo. Hesi ujoho javuajëjamu uëvadeje: Iae ëhi jëvajëjo röhu jemë Abraham-are ujo mae jëvoꞌibejajo huhu mu ma vaejade ëhi jiëꞌe mu maho vaeꞌibejarijëjo. ");
INSERT INTO aom_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","God-hu uevamu hejode jö maho majëhibe rovode höjo röhu jaruvoho jemëro na anegoꞌiëꞌarujëjo. Abraham ëhi jiëꞌe muoho bogo vaenövade höjo. ");
INSERT INTO aom_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Jemesi vavuehu sisëꞌi ëꞌadëhi ëhi ëꞌarujëjo. Ëhi ëꞌarujëjamu uavareje: Asëꞌe no bogo öbiehu javuoꞌi God gemu nosi Vavuoho höjo. No hesi ujo mahuremu javuajëjo. ");
INSERT INTO aom_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Ujo mahuremu javuajëjamu Iesuro uëvadeje: Jemë ëhi uvarujëjo röhu jemesi Vavuoho God jioꞌibejajo nasi örire rajehiꞌibejarijëjo. Rabëni hesi bëhoho na God jiajire jioromo rovodoho aviae jevajëjo. Bogo nasi ma-rueꞌi God-ro na remöꞌöjamu rovode höjo. Röhu jemëhu bogo rajehijarujohuni ëhuni God bogo jemesi Vavuehu höjo. ");
INSERT INTO aom_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Jemë rabëni nasi jö bëhoho bogo avoho hejarujëjo. Nasi jöho bijönëgoꞌego ëhuni ëꞌarujëjo. ");
INSERT INTO aom_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Jemë jemesi vavu hesi agane gemuoho jëvajëjo. Röhu jemesi vavuoho Satan höjo. Jemesi vavuehu nimajëhi ëhi ömoꞌi nimaruje höjo. Niꞌiꞌivadire Satan-ro aevoromo ae muoꞌamobe rovëꞌe höjo. Hu ma-sareriꞌe jöemu uehorovajëro ëhuni hu jö maho bogo ajamijaje höjo. Hu sareriꞌe jö jövëꞌiroho hesi muoho ëhi jiëꞌëro ëhuꞌëro hu ëhi gemu muoho vaejaje höjo rabëni sareriꞌe mu hesi bëhoho hu jiëꞌëro sareriꞌe jöhemu uehorovajëro jiëꞌëro. Jemëꞌo ëhi gemuoho jëvajëjo. ");
INSERT INTO aom_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Naehu jö ma jövajoho ëho bijönimoromo jemë nasi jöho bogo ma uehorovaruje höjo. ");
INSERT INTO aom_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Di aho ja nasi sisë garomo huruohoꞌiranoho eni javajëjo. Nasi sisëho bogojiëꞌëro jemë huruohoꞌirarijoho bogo eni jëvajëjo. Naehu jö ma majëhijajoho jemë rabëni nasi öriroho bogo maho uehorovevarujëjo. ");
INSERT INTO aom_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","God-are aganoho hesi jöho hejarue höjo. Röhu jemë bogo God-are agane gemuoho jëvëꞌëro ëhuꞌëro hesi jöho bogo hejaruje höjo. ");
INSERT INTO aom_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Ëhi uëvamu Jew rajohuro Iesu birevoromo uavareje: Iae no mae uavare höjo: Ja sareriꞌe Samaria rajo vaꞌëne javanovajëjo. Satan-are a sisëho jasi dëre jiajëjo. ");
INSERT INTO aom_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Jiajëjamu uëvadeje: Satan-are aho nasi dëroho bogohöjo. Aꞌi naro nasi Vavu hesi ihoho banigojiomego döro jiaje höjo. Röhu jemëro nasi ihoho sisë vaejeharujëjo saꞌaro jiehojöro. ");
INSERT INTO aom_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Röhu nasi ihehu döro jioröhoho ëho bogo naehu uehorovoꞌi aꞌi A Göhuro iae uehorovaje höjo. Ëho uehorovoromo huro böröme namiromo nasi jöho mae mevehaje höjo. ");
INSERT INTO aom_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Ave jöho na jö mae uëꞌiëꞌajëjo. Ae rahu nasi jö ejehëꞌoho ijonöho bogo mae bogo vuovëvoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Bogo vuovëvoꞌajëjamu rue Jew rajohuro uavareje: Avevejöꞌoho iae no gavaruoho Satan-are a sisëho jasi dëre jiajëjo. Abrahamꞌo jö God-aro baeromo majahuinövare a masijohuꞌo mamiꞌe vuovobe rovëꞌe höjo. Röhu jero uövuanuëjo: Ae rahu nasi jö ejehëꞌoho bogo mae bogo vuovëvoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Nosi aevoꞌi jiade vavuoho Abraham guomade höjo. Na jero uvanuëjo: Na Abraham iosiramijëꞌe a böröme jevajëjo. O jö God-aro baeromo majahuinövade aribövioho vuovobe rovëꞌe höjo. Diehi jiëꞌe aharo nimoronimorohëꞌi jövanuëjo. ");
INSERT INTO aom_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Jövanuëjamu Iesuro uëvadeje: Naro nasi ihoho banigojiomoꞌibejöjo ëho bëhe bogojioꞌibejajo. Röhu nasi Vavuohuro nasi ihoho banigojiomehego döro jiaje höjo. Ëaho jemëro uvaruje höjo: God nosi Börömoho höjo. ");
INSERT INTO aom_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Röhu jemë hu bogo gavëꞌe jëvajëjo. Naro iae hu gavaje höjo. Na uëꞌibejöjo: Na hu bogo gavaje hö uëꞌibejöjo jemë jö sareriꞌe ae jëvajëhi na ëhi jiëꞌe ae jevoꞌibejajo. Röhu iae naro hu garomo hesi jöho ejahaje höjo. ");
INSERT INTO aom_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Jemesi aevoꞌi jiade vavuoho Abraham-ro naehu hijode maja gaꞌiröhohuni ëhuni nimoroho avohade höjo. Nimorohëꞌëro naehu hijode majaho iae hu gavamu dë sasohade höjo. ");
INSERT INTO aom_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Dë sasohade höjamu rue Jew rajoho jaburo uavareje: Sarerivanuëjo. Hu mami gö göꞌe guomadoho ja vadune ahoꞌobëhe 50-ho bogo baejëꞌe javajëjo. Ëhi jiëꞌoho ja diehiꞌoromo Abraham gavane höjo. ");
INSERT INTO aom_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Gavane höjamu Iesuro uëvadeje: Ave jöho na jö mae uëꞌiëꞌajëjo. Abraham bogo rahadevaroho na urimoho jevëꞌe jiade höjo. ");
INSERT INTO aom_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Ëhi jövamu hejëꞌi vajamiꞌirögoro munëho ujuohareje. Ujuohamu Iesuro gurihirovëꞌëro God-are amo börömoho nugoꞌi vaꞌadeje. ");
INSERT INTO aom_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Iae Iesuro juvo vaꞌadeje. Vaꞌihö gavadeje nuni sisëꞌe ae gemu hijamu rahade majare aevoromo hesi nunoho sisërëjëvëꞌëro jiëꞌëro. ");
INSERT INTO aom_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Ëaho ë hijamu gagorovo Iesuare ijorajo ömoꞌömohuro uavareje: Tisa rahuare sisëro ëhuro nuni sisëꞌoho rahade höjo. Na hesi sisëro o hesi vëmu vavuꞌo jabesi sisërajo. ");
INSERT INTO aom_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Ëhi uavamu uëvadeje: Bogo hesi sisëhuro o bogo hesi vëmu vavuꞌo jabesi sisëhuro ëhuro nunoho sisërëjade höjo. Aꞌi sisërëjade hesi bëhoho jemë gaꞌirarijego God-ro hesi darugohuro diehi ajamego mae jiajoho iae ëhuni nuni sisëꞌoho jiade höjo. ");
INSERT INTO aom_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Aji maja jiajevare evare saꞌare remöꞌöjade aehu nimaje muoho no vaenövoꞌejarëjo. Vahiromavuoꞌiëꞌajëjo. Evaroho aehu mu vaeꞌiröhoho bogo eni jioꞌaꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Na ave saꞌare hijajevare evare na ajoho jevëꞌëro saꞌae ahoꞌobëhe ajivëvaje höjo. ");
INSERT INTO aom_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Ëhi uënugoromo sabëro saꞌaho ödivoromo tevoromo övëro hatohatovoromo nuni sisëꞌe a hesi nunoho buejahadeje. ");
INSERT INTO aom_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Buejahoromo uavadeje: Siloam jovo eꞌuoro vaꞌoromo nu anoꞌoho eguëjo. Röhu Siloam nosi jöehu huotovëꞌoho nugöꞌöjade jöhoje. Nu anoꞌoho eguëjamu hegorovo rue nuni sisëꞌe ahuro vaꞌoromo nu anoꞌoho eguoromo mae uherihoromo vuonoröꞌö rovadeje. ");
INSERT INTO aom_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Rovamu hesi amo rajohuꞌo a ioroꞌiorohuꞌo böviëni biseꞌëni ëninëmiꞌego ganövëꞌëro jaburo uarovareje: Ave iaho urimëꞌi hiromo noehu ajamijöro ëninamuinövade aho höjo. Na mae-ëjo. ");
INSERT INTO aom_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Na mae-ëjamu a ioroꞌiorohuro uvareje: Ioꞌajo. Iae ë aho höjo. A ioroꞌiorohuro uvareje: Bogajo. Ae gö ë iaho vaꞌëne höjo. Ëiaho vaꞌëne höjamu rue ahuro uëvadeje: Na bogo ae göehu jevoꞌi jemesi örire ëninëmijode aho jevajëjo. ");
INSERT INTO aom_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Ëninëmijode aho jevajëjamu uavareje: Ëhi jiëꞌoho diehiꞌamu jasi nunoho marëjahade höjo. ");
INSERT INTO aom_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Marëjahade höjamu uëvadeje: Ae gemu hesi ihe Iesu ë ahuro busasovëꞌe saꞌaho hatohatovoromo nunoho buejehoromo uevade höjo: Siloam jovo eꞌuoro vaꞌoromo nu anoꞌoho eguëjamu naro vaꞌoromo eguoromo evare mae uherihode höjo. ");
INSERT INTO aom_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Mae uherihode höjamu uavareje: Röhu hu dinöꞌe höjo. Dinöꞌe höjamu uëvadeje: Hesi naniꞌajo. ");
INSERT INTO aom_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Ëhi uëvamu ë urimo nuni sisëꞌe jiade aho ë ariböviohuro huꞌirae baeromo Pharisee aribövi jabesirire vaꞌareje. ");
INSERT INTO aom_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Röhu mamiꞌe Iesuhu busasovëꞌe saꞌa hatohatovoromo ë ia hesi nuni dadovahade majaho Jew rajehu mu bogo vaeꞌi ma-nuharue majaho jiadeje. ");
INSERT INTO aom_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Ma-nuharue majare Iesuro nunoho dadovahëꞌego Pharisee aribövioho jabuꞌo jöe gemuoho uavareje: Diehiꞌamu jasi nunoho marëjahade höjo. Marëjahade höjamu uëvadeje: Huro busasovëꞌe saꞌaho hatohatovoromo nunire buejehamu naro vaꞌoromo nu anoꞌoho eguëꞌëro ëhuꞌëro mae uherihaje höjo. ");
INSERT INTO aom_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Mae uherihaje höjamu Pharisee aribövi ioroꞌiorohuro uvareje: O ë ahuro nunoho dadovahoromo ëhuro nuho maja hesi jögoroho ahade höjo. Ëhuꞌëro ë aho bogo God-hu nugöꞌöjamu rovëꞌe aho höjo. Bogo God-hu nugöꞌöjamu rovëꞌe aho höjamu Pharisee a ioroꞌiorohuro uvareje: Iae ëhi höjo röhu hu a sisë jioꞌibejajo hu diehiꞌoromo ëhi jiëꞌe mu masijoho vaeꞌibejajo. Ëhi uarovoromo Pharisee ariböviohuro jöe gö gö uehorovoꞌamareje. ");
INSERT INTO aom_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Jöe gö gö uehorovoromo urimo nuni sisëꞌe jiade aho röhu maho jöe majahiromo uavareje: Jero uövuanuëjo: Huro nasi nunoho dadovehade höjo. Ëhi jiëꞌoho ja uehorovanuoho hu diehi jiëꞌe ae höjo. Diehi jiëꞌe ae höjamu uëvadeje: Hu jö God-aro baeromo majahuijaje ae höjo. ");
INSERT INTO aom_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Röhu rue Jew rajohuro uvareje: Nani sareramuiromo uövuaruëjo: Aevoꞌi nuni sisëꞌe jiadoho avevejöꞌoho gavajëromo ae uëvareje: Uëvego ave a hesi vëmu vavuꞌohuro rueꞌirarëjo. ");
INSERT INTO aom_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Jabumë rovamu uëvareje: Na ave aho jemesi harihe höjo. Jemë uövuarije höjo: No ave harihu baejare majare evare hu aevoromo nuni sisëꞌe jiade höjo. Na mae o sarerëjo. Mae jiëꞌoho diehiꞌëꞌëro jaruvoho hu mae uherihajëjo. ");
INSERT INTO aom_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Mae uherihajëjamu rue vëmu vavuꞌohuro uëvareje: No gavaruoho ave aho iae hu nosi harihe höjo. No hu baejarevare evare aevoromo nuni sisëꞌe jiade höjo. Ëjöho iae no gavaruëjo. ");
INSERT INTO aom_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Röhu rahuhu diehi ajamamu nuni dadovadoho no bogo gavëꞌe javuajëjo. Jueꞌio ua garego huro hesi jöꞌëro majëhiꞌirajo hu bövie jiaje. ");
INSERT INTO aom_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Röhu vëmu vavuꞌehu ë jö uëvare hesi bëhoho jaburo ë Jew rajo masijoho juhuonëmijareje. Urimëꞌi ë a masijohuro jöe mevoromo ae ahoꞌobëhe uëvareje: Ae rahu huruoho majahuiromo uövuëꞌoho: Böröme namiromo ajamuijaje aho Iesu hö uövuëꞌoho ëhi jiëꞌe aribövioho noro ahëvoꞌiramu ijonöho nosi osa börömoroho bogo rueromo God rajahinövoꞌaruëjo. Ëjöho uehorovoromo vëmu vavuꞌohuro juhuonëmijareje. ");
INSERT INTO aom_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Juhuonëmiromo ëhuni uëvareje: Ëaho bövie jiaje ëhuni jemëro hu ua garëjo. ");
INSERT INTO aom_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Hu ua garëjamu hegorovo rue a masijohuro jöe nugöꞌöjareje urimo nuni sisëꞌe jiade ahuro vuonoröꞌö rueröhego. Jöe nugöꞌöromo rovamu Iesuare jöho atoromo uavareje: God-are nunoro jöe ma-maemu jövego no hejarëjo. No gavaruoho ë aho a sisë höjo. ");
INSERT INTO aom_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","A sisë höjamu uëvadeje: Naꞌo bogo gavajëjo. Nani hu a sisë höjo o bogajo. Röhu jöe gemu iae na gavajëjo urimo nuni sisëꞌe jevadoho jaruvoho mae uherihevoꞌego. ");
INSERT INTO aom_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Ëhi uëvamu uavareje: Hu diehiꞌavade höjo. Hu diehi nunoho dadovahade höjo. ");
INSERT INTO aom_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Dadovahade höjamu uëvadeje: Na mamiꞌe uëvamu jemëro bogo ejeharije höjo. Rabëni röhu maho heꞌi nëgajëjo. Nani jemëꞌo hesi ijore ijore jijihoꞌi nëgoꞌego o rabëni ue geꞌi arijarujëjo. ");
INSERT INTO aom_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Ue geꞌi arijarujëjamu sivoromo uavareje: Ja ë ia hesi ijore ijore juvanue ae javajëjo. No bogajo. No Moses-are jögoru ijore ijore jijiharue aribövie javuajëjo. ");
INSERT INTO aom_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","No iae garomo uvarue höjo: God-ro Moses jöe bojamamu majahuijade höjo. Aꞌi ë a gö hesi bëhoho no bogo gavaruëjo. ");
INSERT INTO aom_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Bogo gavaruëjamu rue nuni sisëꞌe jiade ahuro uëvadeje: Asëꞌe jemë diehiꞌoromo hesi bëhoho bogo gavaruje höjo. Iae huro nasi nunoho dadovehade höjo röhu jemë hu bogo gavaruje höjo. ");
INSERT INTO aom_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","No gavaruoho God a sisë jabesi jöho bogo ejëhaje höjo. O aehu God uehorovoromo huhu nimaje mu vaejëꞌoho ëhi jiëꞌe aribövioho God-ro ejëhaje höjo. ");
INSERT INTO aom_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Niꞌiꞌivadire jioromo ëhi ro avevejöꞌoho bogo hebe rovëꞌe javuajëjo uvavamu: Vëmu dëre jioromo nuni sisëꞌe raharoho aëro nunoho dadovëhade höjo. ");
INSERT INTO aom_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","God bogo nugöꞌöjego rueꞌibejajo ëhi jiëꞌe darugoꞌe mu vaejajoho hu bogo mae bogo eni jioꞌibejajo. ");
INSERT INTO aom_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Bogo eni jioꞌibejajamu uavareje: Jasi vëmu hesi dëre jioromo mu sisëmu vaebe rovëꞌe javajëjo. Ëhi javajëjo röhu ja diehiꞌoromo jögoroho bojamuijanuëjo. Ëhi uanugoromo jabesi osa börömoroho rarovöꞌöjamu vaꞌadeje. ");
INSERT INTO aom_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Ërarovöꞌöjamu vaꞌade jöho aëro atamu Iesuro hejadeje. Heromo ë aho birohoromo uavadeje: Na ja God-are A Ma hesi öriroho mae uehorovanuëjo. ");
INSERT INTO aom_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Mae uehorovanuëjamu uavadeje: Röhu God-are A Maho rahuo höjo. Uevego na hesi örire mae uehorovöjo. ");
INSERT INTO aom_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Mae uehorovöjamu Iesuro uavadeje: God-are A Maho jero mamiꞌe gavane höjo. Röhu aviavejöꞌe jaꞌo jöe jövajëjo. Iae na jevajëjo. ");
INSERT INTO aom_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Na jevajëjamu uavadeje: Bada naro jasi örire mae uehorovavajëjo. Mae uehorovavajëromo ague aho hiromo rajahijadeje. ");
INSERT INTO aom_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Rajahijamu Iesuro uëvadeje: Naro saꞌare rovode höjo mae o sisë aribövie mevëvoꞌirodëni. Nuni ramoramoꞌe aribövioho nune dadovëhoꞌi ma-döhemu nuni maꞌe aribövioho nune tugohëhoꞌirodëni ëhuni saꞌare rovode höjo. ");
INSERT INTO aom_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Ëhi uëvamu Pharisee a ioroꞌiore bëhire raromarohuro ë jöho heromo uavareje: Na ja nosi jöho jövoromo ëꞌanuëjo. No bogo nuni ramoramoꞌe ariböviehu javuajëjo. ");
INSERT INTO aom_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Javuajëjamu Iesuro uëvadeje: Jemë nuni ramoramoꞌe jëvoꞌibejajo jö sisëho bogojëvoꞌibejajo. Röhu jemë ëma uvaruje höjo: Iae no mae gavarue höjo. Ëhuni jemesi sisëho iae jëvajëjo. ");
INSERT INTO aom_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Iae Iesuro uhuꞌe uëvadeje: Ave jöho na jö mae uëꞌiëꞌajëjo. Ae rahu sheep jabesi amore vaꞌiëꞌiroho bogo ojoroho vaꞌi buoru iromaroho ruahoromo vaꞌamu gavëꞌoho uvoꞌaꞌanuëjo: Ëhi jiëꞌe aho ananoꞌe vajiohuꞌe ae höjo. ");
INSERT INTO aom_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","O ae rahu ojore vaꞌamu gavëꞌoho uvoꞌaꞌanuëjo: Ëho sheep muebeꞌamaje aho höjo. ");
INSERT INTO aom_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Sheep muebeꞌamaje aho sheep amore vaꞌiaꞌamu gavëꞌiroho ojo muebejaje ahuro ojoho jiovahego ë vaꞌaje höjo. O sheep-ohuro hesi huëho heruomaje höjo. Hejego hesi sheep gemu gemu hesi ihoho uvoromo sö ujuohoromo vaꞌo amonö höröjaje höjo. ");
INSERT INTO aom_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Sö ujuoho vaꞌo barënugoromo evare jabesi nuninö vaꞌego sheep-ohuro ijore vaꞌoruomaje höjo hesi huëho heruomajëro jiëꞌëro. ");
INSERT INTO aom_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","A ioroꞌioro jabesi huëho bogo hejaruëro jiëꞌëro jabesi ijoroho bogo vaꞌi huruomoromo vaꞌoruomoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Ëjöho Iesuro uhuꞌe uëvamu ë jö hesi bëhoho bogo avoho hejareje. ");
INSERT INTO aom_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Bogo avoho hejëꞌëro Iesuro uëvadeje: Ave jöhuꞌo na jö mae uëꞌiëꞌajëjo. Na sheep-ehu vaꞌoruomaje ojoho vaꞌëne jevajëjo. ");
INSERT INTO aom_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Urimo rueruomade aribövioho ananoꞌe vajiohuꞌe a vaꞌëne jëvobe rovadoho nasi sheep mahuro jabumë bogo ejëhare höjo. ");
INSERT INTO aom_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Na ojo vaꞌëne jevajëjo. Ae rahu nasirire ruaho rovëꞌoho maro jioruomoꞌajëjo. Maro jioromo ruaho rueromo osare jioromo ruaho vaꞌoromo vaꞌorahonö ioho birohoromo ueꞌahoꞌaruëjo. Ëhi gemu ëꞌonövoꞌaruëjo. ");
INSERT INTO aom_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Röhu ananoꞌe vajiohuꞌe ahuro rueruomaje höjo vajiohëro ujuohoꞌi bijuëmoꞌi ijumoꞌamoꞌirovo. Naro rovode höjo nasi sheep ömoꞌömohuro iꞌovoromo ma-maro raromoröhego. ");
INSERT INTO aom_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Sheep muebeꞌamaje a maho na jevajëjo. Sheep muebejaje a mahuro uvaje höjo: Naehu sheep jabesi jöëni nasi arijoꞌarije bojamirovoromo guomorovëꞌoho iae mae höjo. ");
INSERT INTO aom_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","O ma-moniemu nimoromo ae gö hesi sheep muebejahaje aho ëho bogo sheep jabesi vavuoho jioꞌi ma-muebeꞌamajëro jiëꞌëro gaꞌiröhe vöröꞌe mioho rovamu gavëꞌiroho sheep-oho rëmöꞌöromo juꞌebiromo vaꞌaje höjo. Juꞌebiromo vaꞌego miohuro ro sheep-oho umi ujuoho vaꞌego sheep ioroꞌiorohuro huruomoromo arua anumiae vaꞌaje höjo. ");
INSERT INTO aom_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Amo a hesi sheep muebejahajohuro moniemu nimëꞌëro sheep-oho bogo huëho baejëvaje höjo. Ëhuꞌëro huruomaje höjo. ");
INSERT INTO aom_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","Aꞌi na sheep muebeꞌamaje a maho jevajëjo. Vavuohuro na geꞌi naehu Vavu gavajëhi ëhi naro nasi sheep-oho gaꞌamaje höjo. O nasi sheep-ohuro na geruomaje höjo. Ëhi jiëꞌëro naehu sheep jabesi jöëni nasi arijoꞌarije bojamirovoromo guomorovëꞌoho iae mae höjo. ");
INSERT INTO aom_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Röhu sheep ioroꞌioroho iae jevajëjo. Jabumë ave sheep amoroho bogo raromarue höjo. Bogo raromaruoho jabuꞌo söjëvo rueꞌejöjo. Rueromo jöe majëhiꞌiramu ejehonövoꞌaruëjo. Ëhuꞌëro jiëꞌëro sheep ahoꞌobëhe ma-gemuoro jioꞌi sheep muebejaje aho ma-gemu jevoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Vavuehu na rajehijaje hesi bëhoho naro guomorovoꞌejöjo iꞌovoromo röhu maho hiꞌirodëni. ");
INSERT INTO aom_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Aho bogo ma-anegoꞌi nasi nimoromo bojamirovoꞌiramu anegoꞌiramu guomevoꞌajëjo. Naehu bojamirovamu anegamu guomevëꞌoho iae mae höjo. O ajamirovoromo iꞌovoromo röhu maho hijëꞌoho ëhuꞌo iae mae höjo ëhi guomoromo röhu maho riꞌöꞌirodoho nasi Vavuohuro uevamu hejëꞌëro jevëꞌëro. ");
INSERT INTO aom_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Ëhi uëvamu hegorovo rue Jew rajohuro röhu maho jöe gö gö uehorovareje. ");
INSERT INTO aom_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","A ioroꞌioroho ahoꞌobëhe jaburo atoromo uarovareje: Satan-are a sisë gemuëro hesi dë vövöbajoꞌere abuejëꞌëro simane sisëꞌi uehorovoromo jövajëjo. Jemë rabëni hesi jöho hejarujëjo. ");
INSERT INTO aom_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","A ioroꞌiorohuro uarovareje: O huhu jö jövajoho bogo Satan-are a hesi dëroho abuejëꞌëro jöho jövajëjo. Ëhesi bëhoho Satan-are a sisëhuro nuni sisëꞌe aho diehi ajamego mae jioꞌibejajo. Bogajo. Ëhi atoruomadeje. ");
INSERT INTO aom_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Iae Jerusalem amore maja börömoho rovadeje. Ëmaja börömo hesi bëhoho Jew rajo ömoꞌömohuro uehorovoromo uvonövareje: Evare majare nosi a mamiohuro God-are amo börömo hesi ojoho jiovoromo God-are örire ma-ioroꞌioremu bojamare höjo hesi baeröhego. Ëmaja börömoho runoni majae jiëꞌiro evare rovadeje. ");
INSERT INTO aom_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Ëmaja börömoho rovamu Iesuro God-are amo börömo hesi haradare juvadeje. Harada hesi ihoho Solomon-are Haradae jiadeje. ");
INSERT INTO aom_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Juvamu gagorovo Iesu ririre jioꞌi Jew rajohuro ruë numë riravo rovaꞌoromo uavareje: Ja divare jö subivahuanuoho vuonugoꞌiramu ëhuro bogo dadivavuoꞌajëjo. Ma-samaꞌe majahuijego hejarëjo. Na ja böröme namiromo ajamuiꞌirane aho javajëjo o bogajo. ");
INSERT INTO aom_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Ëhi uavamu Iesuro uëvadeje: Naro mamiꞌe uëvode höjo. Röhu jemë bogo ma uehorovevaruje höjo. Naro nasi Vavu hesi ihore mu masijoho vaejaje höjo jemëro ë muoho garomo uvoꞌirarijego: Iae mae-ëjo. Nörö iae a mae höjo. ");
INSERT INTO aom_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Röhu jemëhu na bogo ma uehorovevaruje hesi bëhoho jemë bogo nasi sheep-oho jëvajëjo. ");
INSERT INTO aom_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Nasi sheep-ohuro nasi huëho heromo ejehoruomego naro jabumë gëvaje höjo. Gëvego jaburo nasi ijore ijore jijihoruomaje höjo. ");
INSERT INTO aom_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Nasi ijore ijore jijihoruomego naro jabu ajëmego ma-ioroꞌioremu maro raromarue höjo. Ëhuꞌëro jiëꞌëro jabumë bogo mae bogo sisëroho vaꞌoruomoꞌajëjo. O nasi övo döre raromaruoho aho bogo baeniehiꞌaruëjo. ");
INSERT INTO aom_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Nasi Vavue jabumë baejëvoromo nasi örire bojemade ahuro ahoꞌobëhe iosirëmijëꞌe höjo. Ëhuni Vavu hesi övo döre raromaruoho aho bogo baeniahiꞌaruëjo. ");
INSERT INTO aom_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Naꞌo nasi Vavuohuꞌo no gemuoho javuajëjo. ");
INSERT INTO aom_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Naꞌo nasi Vavuohuꞌo no gemuoho javuajëjamu hegorovo Jew rajohuro urimo munëhu vajamiꞌiëꞌaroho röhu maho munëho ujuohareje vajamiꞌirovo. ");
INSERT INTO aom_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Munëho ujuohamu gagorovo Iesuro uëvadeje: Vavuohuro na ajemamu mu mae ahoꞌobëhe vaeꞌamamu gavarije höjo. Di mu vaejamu gavarijohuni munëho vajemiꞌiëꞌarujëjo. ");
INSERT INTO aom_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Munëho vajemiꞌiëꞌarujëjamu uavareje: Bogo mu ma hesi jöënioho munëho vajamiꞌiëꞌaruëjo. Aꞌi jero God-are ihoho ijumoꞌego ëhuni ëꞌaruëjo. Ja ma-ae javajëjo. Röhu jero uvanuëjo: Na God jiaje gemuoho jevajë uvanuohuro ëhuro God-are ihoho ijumanuëjo. ");
INSERT INTO aom_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Ijumanuëjamu Iesuro uëvadeje: Röhu jemesi jögoru surire jajivoromo ëhi uvëꞌe höjo: God naro uëvajëjo: Jemë god ömoꞌöme jëvajëjo. ");
INSERT INTO aom_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Ëhi jajivëꞌe höjo. God-are surire jöho ioroꞌioremu jioröhe jöho höjo. Ësurire jajivoromo uvëꞌe höjo: God-are jö baejare aribövioho jabumë god ömoꞌöme jioꞌamajë uvëꞌe höjo. ");
INSERT INTO aom_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Röhu na bogo ma-God-are jöho baeꞌi aꞌi Vavuohuro na baejevoromo saꞌare remöꞌöjamu rovëꞌëro uëvajëjo: Na God-are Harihe jevajëjo. Ëhi jiëꞌoho jemë rabëni uevarujëjo: Jaehu uövuanuoho: Na God-are Harihe jevajë uövuanuohuro ëhuro God-are ihoho ijumanuëjo. Ëhi jiëꞌoho bogo maehu höjo. ");
INSERT INTO aom_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Röhu nasi Vavuehu bojemade muoho na na vaejaje höjo o bogo vaejaje höjo. Bogo vaejaje jevamu gavëꞌoho nadi maho uehorovevorëjo. ");
INSERT INTO aom_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Röhu Vavuehu bojemade muohuremu iae na vaejaje höjo. Nani jemëro na bogo ma uehorovevoꞌarujëjo röhu nasi muoho ëhuro garomo uvorëjo: Iae mae-ëjo. Vavuohuro ajamamu vaejade höjo. Jemë ëhi uehorovëꞌoho ëhuro avoho ga barëromo uvoꞌaꞌarujëjo: Vavuohuro nasi dë vövöbajoꞌere jioꞌi naro Vavu hesi dë vövöbajoꞌere jiaje höjo. ");
INSERT INTO aom_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Ëhi jövamu hegorovo rueho jaburo röhu maho Iesu guduamoꞌiëꞌareje. Guduamoꞌiaꞌamu garaedëgoromo vaꞌadeje. ");
INSERT INTO aom_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Vaꞌadoho vaꞌo Jordan jovoho beromo ioni gönö vaꞌoromo John-hu aevoromo bapataeto vaejëvadire ë vaꞌo hijadeje. ");
INSERT INTO aom_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Vaꞌo hijamu gagorovo ae ahoꞌobëhe rueruomadeje. Rueromo uarovareje: John bogo darugoꞌe mu masijoho vaenövade höjo. Röhu ave a hesi jö John-hu majahuijamu hejaroho ë jöho ahoꞌobëhe iae mae uövuade höjo. ");
INSERT INTO aom_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Ëhi uarovoromo ae ahoꞌobëhe Iesu ë öri ariꞌere mae uehorovoruomadeje. ");
INSERT INTO aom_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Iae guomo guomoꞌe ae gemu hesi ihoho Lazarus Bethany amore hijadeje. Röhu hesi maꞌine niöꞌi Maryꞌo Marthaꞌo jabesi amoho gemuoho jiadeje. ");
INSERT INTO aom_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Röhu Mary hu majae ijonö hiromo Badare hörure ridiꞌe jovehu otehodivoromo simano uehu uhijahoꞌiröhe magonahoho jiadeje. Amo ë magonaho hesi maꞌine Lazarus-ro guomo guome baeromo hijadeje. ");
INSERT INTO aom_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Hijamu Lazarus-are maꞌine niöꞌiro jöe nugöꞌöromo Iesu uavareje: Bada jaehu huë baejanue aho guomo guome baejëꞌe höjo. ");
INSERT INTO aom_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Guomo guome baejëꞌe höjamu hegorovo Iesuro uëvadeje: Ëguomo guomo baejade hesi bëhoho hu bogo ioroꞌioremuoho guomoꞌirögoro God-are ihoho döro jioröhego. Hu guomo guome baejëꞌëro ëhuꞌëro God-ro ajemiꞌiramu hesi Harihe nasi ihohuꞌo dö maro jioꞌaꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Röhu Iesuro öꞌo öꞌo Marthaꞌo Maryꞌo jabesi maꞌine Lazarusꞌo ëhi dë vövöbajoꞌe ahoꞌo uehorovëvadeje. ");
INSERT INTO aom_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Amo hejade uavamu: Lazarus guomo guome baejëꞌe hö uavamu heromo bogo Judea saꞌaroho vaꞌoromo Lazarus gaꞌirögoro ëhi hijamu majae niöꞌi barëjëvadeje. ");
INSERT INTO aom_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Majae niöꞌi barëjëvamu gagorovo hesi ijorajo ömoꞌömoho uëvadeje: Ruehego no Judea saꞌare vuonoröꞌö vaꞌarëjo. ");
INSERT INTO aom_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Vaꞌarëjamu ijorajoho jaburo uavareje: Tisa iae mae höjo röhu avevejöꞌe Jew rajoho jaburo ja munëro vajamiꞌiëꞌare höjo. Ëhi jiëꞌoho ja rabëni ë saꞌaroho vuonoröꞌö vaꞌiëꞌanuëjo. ");
INSERT INTO aom_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Vaꞌiëꞌanuëjamu Iesuro uëvadeje: Aveho aji majaromëro jiëꞌëro vaꞌejöjo. Jemëꞌo uehorovohëjo. Majae höröromo hour ahoꞌobëhe 12 barëjego evare bevaꞌaje höjo. Ëhuꞌëro ae rahu majaꞌe jijihëꞌoho ave saꞌae ahoꞌo hesi ajire jijihoromo ëhuro bogo biberovarue höjo. ");
INSERT INTO aom_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","O vahiꞌe jijihëꞌoho ajoho bogojëvëꞌëro ëhuro biberovarue höjo. ");
INSERT INTO aom_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Ëhi uëromo ijonö uëvadeje: Nosi aemoꞌaemoho Lazarus niavëꞌe höjo. Ëhuni na vaꞌoromo ioꞌejöjo. ");
INSERT INTO aom_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","13","Ioꞌejöjamu hesi ijorajoho jaburo uvareje: Nani Iesuro uöromo ëꞌajëjo: Lazarus ma-niavajë uövuajëromo uavareje: Bada hu niavëꞌoho iae marëꞌajëjo. Röhu Iesu bogo ëhioho uëꞌi aꞌi uëromo ëꞌadeje: Lazarus hu guomëꞌe höjo. ");
INSERT INTO aom_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Ëhuni Iesuro huruoho majëhiromo uëvadeje: Lazarus guomëꞌe höjo. ");
INSERT INTO aom_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Guomamu naehu bogo huꞌo hijodohuni ëhuni jemesi jöëni nimorohajëjo ëhuro jemëro nasi muoho garomo mae uehorovoꞌirarijego. Röhu ruehego no hesirire vaꞌarëjo. ");
INSERT INTO aom_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Ëhi uëvamu hegorovo Thomas hesi ihoho aehu uvaruoho Huodiꞌe Rahade Aho huro ijorajo ioroꞌioroho uëvadeje: Go vaꞌohego noꞌo vaꞌoromo Iesuꞌo gemu mae vuovoꞌirarëjo. ");
INSERT INTO aom_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Ëhiꞌamu Iesuro vaꞌoromo Bethany amore höröꞌirögoro hejade uavavamu: Lazarus mamiꞌe guomamu guavaroho majae ëhi niöꞌi ëhi niöꞌi barëjëꞌe höjo. ");
INSERT INTO aom_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Röhu Bethany amoho Jerusalem bëhire jiëꞌëro 3 kilometre rabuꞌe jiadeje. ");
INSERT INTO aom_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Ëhuꞌëro Jew raje ae ahoꞌobëhe jaburo Jerusalem jioromo Bethany rovëꞌëro ë raromareje Marthaꞌo Maryꞌo jabesi maꞌinoho guomëꞌëro huë vavaeni baejaruoho sanuëmiröhëro. ");
INSERT INTO aom_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Ëhiꞌamu Martha-ro hejade uvavamu: Iesu rovajëjamu hegorovo osare jioromo höröromo Iesu birohoꞌi rovadeje. Rueꞌirögoro Mary-ro ëhi osare hijadeje. ");
INSERT INTO aom_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Hijamu Martha-ro rueromo Iesu birohoromo uavadeje: Bada ja ave hiꞌibejanëjo nasi maꞌinoho bogo guomoꞌibejajo. ");
INSERT INTO aom_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Nasi maꞌinoho iae guomëꞌe höjo. Röhu jaruvohuꞌo God-hu diehi ajamijöro Iesu jaehu ua gavëꞌoho iae ajamiꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Ajamiꞌajëjamu Iesuro uavadeje: Jasi maꞌinoho iae iꞌovoromo riꞌöꞌaꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Riꞌöꞌaꞌajëjamu Martha-ro uavadeje: Iae na garomo uvajëjo: Ijo tugohoꞌi rueröhe majaho rueꞌiramu evare ae ahoꞌobëhe iꞌovoromo riꞌöruomoꞌiramu huꞌo riꞌöꞌaꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Riꞌöꞌaꞌajëjamu Iesuro uavadeje: Vuovoromo iꞌovoromo riꞌöromo mae raromoꞌirarije darugo hesi bëhoho na jevajëjo. Ëhuꞌëro ae rahu nasi örire mae uehorovevëꞌohuro daruge baeromo mae raromoꞌaruëjo. Nani vuovoꞌajëjo röhu iae iꞌovëvoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Ae rahu iꞌovoromo raromoromo nasi örire ma uehorovevëꞌoho bogo sisëroho vaꞌi mae raromemu raromoꞌaruëjo. Na ja ë jöho mae uehorovanuëjo. ");
INSERT INTO aom_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Mae uehorovanuëjamu uavadeje: Bada ioꞌajo. Iae na mae uehorovoromo uvajëjo: Böröme namiromo ajamuiꞌirane aho God-are Harihoho ja javajëjo. Ave saꞌare rueꞌiranego God-hu uövuade aho ja javajëjo. ");
INSERT INTO aom_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Martha-ro Iesu ëhi uanugoromo vaꞌadeje. Vaꞌoromo osare vaꞌo hesi öho Mary saginiëri uavadeje: Tisae rovëꞌe höjo. Rovëꞌëro uvajëjo jero ruejöro. ");
INSERT INTO aom_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Ruejöro uvajëjamu hejëꞌi ma-burëro riꞌöromo Iesu birohoꞌi vaꞌadeje. ");
INSERT INTO aom_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","31","Ma-burëro riꞌöromo Iesu birohoꞌi vaꞌamu gagorovo Jew raje Maryꞌo osare raromoromo sanuamijarohuro uvareje: Nani Lazarus-are sino bamarire nivoꞌi vaꞌajëromo rihiromareje. Rihiromamu Iesuro amo maroho bogo rueꞌi Martha-hu birohadire ë hijëꞌëro Mary-ro ë birohoꞌi rovadeje. ");
INSERT INTO aom_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Rueromo Iesu garomo hesi bëhire ague aho hiromo uavadeje: Bada ja ave hiꞌibejanëjo nasi maꞌinoho bogo guomoꞌibejajo. ");
INSERT INTO aom_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Ëhi uaromo nivamu Jew raje huꞌo gemu mae rovarohuꞌo nivoruomamu gëgorovo Iesuro hesi dë vövöbajoꞌo uhure haraꞌuoromo vavaenimo avohadeje. ");
INSERT INTO aom_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Vavaenimoromo uëvadeje: Jemë sinoho dinöꞌe bamarije höjo. Bamarije höjamu uavareje: Bada rueromo gavëjo. ");
INSERT INTO aom_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Rueromo gavëjamu Iesuro nivadeje. ");
INSERT INTO aom_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Nivamu gagorovo rue Jew rajohuro uarovareje: Aroriaho gahëjo. Hu Lazarus-are örire hesi dë vövöbajoꞌere bogo bisemuoho uehorovëꞌëro ëhuni nivajëjo. ");
INSERT INTO aom_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Nivajëromo ae göëro göëro uvareje: Ëahuro nuni sisëꞌe aho ajamamu marëjade höjo. Ëhuni nani huro Lazarus mamiꞌe ro ajamiꞌibejajo hu bogo guomoꞌibejajo. ");
INSERT INTO aom_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Ëhi uarovamu hegorovo Iesuro röhu maho haraꞌuoromo vavaenimamu sino bamarire vaꞌadeje. Vaꞌoromo gavadeje juju gagoho munëro tugohëꞌe jiamu. ");
INSERT INTO aom_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Tugohëꞌe jiamu gagorovo uëvadeje: Munëho roriꞌo bavaꞌohëjo. Bavaꞌohëjamu guomëꞌe a hesi maꞌine Martha-ro uavadeje: Bada iae ëhi höjo röhu majae ëhi niöꞌi ëhi niöꞌi barëjëꞌëro jiëꞌëro usihövajëjo. ");
INSERT INTO aom_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Usihövajëjamu Iesuro uavadeje: Iae ëhi höjo röhu na mamiꞌe uavode höjo: Jaehu mae uehorovëꞌoho God-are aji maho gaꞌaꞌanuëjo. Naehu uavode jöho na ja ëho uehorovanuëjo o bogajo. ");
INSERT INTO aom_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Ëhi uavamu hegorovo rueho jaburo munëho bavaꞌareje. Bavaꞌamu Iesuro sioroho garomo uavadeje: Apo naro jasi örire huë mae uavajëjo rabëni jero nasi jöho ejehëꞌego. ");
INSERT INTO aom_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Iae na garomo uvajëjo: Jero majae ëhi ejehanue höjo. Röhu naro ave jöho uavajëjo arue aribövi jabesi jöëni ëhuro jaburo uvoruomoröhego: Iae mae-ëjo. God-ro nörö nugöꞌöjamu rovade höjo. ");
INSERT INTO aom_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Ëhi uanugoromo ma-darugoꞌo uvadeje: Lazarus vaꞌorahonö hörö rovëjo. ");
INSERT INTO aom_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Hörö rovëjamu guomamu bamare ahuro iꞌovoromo hesi övo höruꞌoho nu anoꞌoho niögëro muoho taemoꞌamëꞌe juju gagore jioromo hörö rovadeje. Rovamu gagorovo Iesuro uëvadeje: Niögoho jiovahohego vaꞌajo. ");
INSERT INTO aom_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Ëhiꞌamu Jew raje ae ahoꞌobëhe Mary gaꞌi rovarohuro gavare Iesuro Lazarus ëhi ajamiꞌego iꞌovoromo riꞌöjamu gagorovo hesi örire mae uehorovareje. ");
INSERT INTO aom_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","A ioroꞌiorohuro bogo ma uehorovoꞌi vaꞌoromo Pharisee aribövioho huruoho majëhiromo uëvareje: Iesuro ëhi jiëꞌe muoho vaejade höjo. ");
INSERT INTO aom_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Ëhi majëhijamu hegorovo priest masijohuꞌo Pharisee ömoꞌömohuꞌo ëho jaburo Jew rajo a masijo ioroꞌioroho uëvareje: Gagovohego no jöe mevarëjo. Jöe mevarëromo gagovamu uëvareje: No ave a hesi öriroho diehiꞌoꞌejarëjo. Huro darugoꞌe mu masijoho ahoꞌobëhe vaejaje höjo. ");
INSERT INTO aom_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Ëhi jiëꞌe mu masijoho vaemu vaejamu noehu bogo tugohëꞌoho ae ahoꞌobëhe hesi örire mae uehorovoruomoꞌajëjo. Mae uehorovoꞌiramu gagorovo Rome ariböviohuro rueromo nosi amo börömohuꞌo saꞌahuꞌo ijumavuo barëꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Röhu ae gemu hesi ihoho Caiaphas hu jabuꞌo jiadeje. Evare vaduniroho hu priest böröme namijëꞌe jiadeje. Ëahuro riꞌöromo uëvadeje: Jemë ave muoho bogo avoꞌavoho gavarujëjo. ");
INSERT INTO aom_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Jemë diehiꞌoromo bogo uehorovarujëjo ae gemuehu ae ahoꞌobëhe noni guomëꞌoho ëhuro jemë marëjëvoꞌajëjo. Ëhi jiëꞌoho nosi saꞌaho ahoꞌobëhe bogo barëjavuoꞌajëjo. Caiaphas-ro ëhi jövadeje. ");
INSERT INTO aom_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Ëjöho bogo hesi ëma jövoꞌirögoro evare vaduniroho hu priest börömëro jiëꞌëro ijonö jioröhe jöho God-ro bojamamu majëhijadeje. Majëhijade jö hesi bëhi huruoho majëhijëꞌoho Iesu guomoꞌaꞌajëjo Jew raje ahoꞌobëhe ajëmiꞌiröhëro. ");
INSERT INTO aom_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Röhu bogo Jew rajo jabesi jöëni ëhemuoho guomoꞌi aꞌi guomoromo ëhuro God-are aboji harihuꞌe ahoꞌobëhe dinöꞌe dinöꞌe raromaruoho gemuoro gagovoꞌiröhego Caiaphas-ro jö bëhoho bogo uehorovëꞌe ëhi ma-jövadeje. ");
INSERT INTO aom_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Iesu guomoröhe jöho ëhi atoromo evare majare aevoromo öroho nahoromo avohobe rovareje hu anoröhëro. ");
INSERT INTO aom_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Ëhiꞌamu Iesuro Judea saꞌare vaꞌorahore juvadoho vuonugoꞌi vaꞌadeje. Vaꞌoromo a rumoꞌe saꞌa hesi bëhire amo ihe Ephraim ë vaꞌoromo hesi ijorajo ömoꞌömohuꞌo gemu mae hijadeje. ");
INSERT INTO aom_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Hijamu Jew rajo jabesi maja börömoho dunovadeje. Maja börömo hesi ihoho God-hu Vörö Tugohade hesi Majaho jiadeje. Ëmaja börömoho dunovamu ae ahoꞌobëhe amo harihu harihure jioromo Jerusalem amo börömore iojiomareje Moses-are jögoroho ejahoromo jabesi sisëho avohorovoꞌi sörö majaho rovego avoho ueꞌahoröhëni. ");
INSERT INTO aom_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Iojiomoromo Iesu nahoromo God-are amo börömore gagovoromo uarovareje: Jemë diehi uehorovarujëjo. Na jemë uehorovarujoho Iesu sörö börömoroho rueꞌaꞌajëjo o bogajo. Nani bogajo. ");
INSERT INTO aom_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Röhu mamiꞌe priest masijohuro Pharisee ömoꞌömohuro ae ahoꞌobëhe jöe bojëmiromo uëvareje: Iesu dinöꞌe hijajoho ae rahu gavëꞌoho ro huruoho majahuirego no heromo vaꞌoromo hu guduamoꞌirarëjo. ");
INSERT INTO aom_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Ijonö majae ahoꞌobëhe 6 barëjego God-hu Vörö Tugohade Sörö maja rueꞌiröhoho jiadeje. Rueꞌiröhoho jiamu evare Iesuro Bethany amore Lazarus-hu hijajire ë ajiomadeje. Lazarus guomamu Iesuhu ajamamu riꞌöjade aho jiadeje. ");
INSERT INTO aom_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Amo Iesuro ë ajiomamu ariböviohuro i harihe avohoromo Iesu bojamijareje. Bojamiromo Martha-ro ajëmiromo ie iꞌimëmamu Lazarus-ro ie iꞌi Iesumëꞌo ro hijadeje. ");
INSERT INTO aom_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Ëhi ro raromamu Mary-ro ridiꞌe osoho bisemu bövie barovadeje. Osoho bogo jovoꞌoho buarohëꞌe ma-oso maemu jiadeje. Hesi manaho bogo biseꞌo vaduꞌoho jiadeje. Ëosoho Mary-ro barueromo Iesuare höru döre otehodivoromo simano uohuro höroho uhijahadeje. Uhijahamu ridohuro osae ahoꞌobëhe rumorovo barëjadeje. ");
INSERT INTO aom_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Rumorovo barëjamu Iesuare ijorajo ömoꞌömoho ae gemu hesi ihe Judas Iscariot Iesuni hiruëmiromo a jabesi övore bojëmiꞌiröhe ahuro uëvadeje: ");
INSERT INTO aom_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","Ridiꞌe osoho rabëni bogo aroho imëvoromo 300 kina rabuꞌe baeromo bövi biseꞌo rumoꞌe aribövioho suvuorëmijare höjo. Ëhi jiëꞌoho iae mae jioꞌibejajo. ");
INSERT INTO aom_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Ëhi uëvade hesi bëhoho Judas Iscariot-ro bövi biseꞌo rumoꞌe ariböviohunioho bogo uehorovoromo jövoꞌi aꞌi vajiohuꞌe aëro jiëꞌëro ëhi jövadeje. Ëhesi bëhoho huro Iesumesi moniꞌe esöho muebenövadeje. Muebejëꞌi gö vajiohëro baenövadeje. Vajiohëro baenövëꞌëro ëhuꞌëro uëvadeje: Ridiꞌe osoho rabëni bogo aroho imëvoromo bövi biseꞌo rumoꞌe aribövioho suvuorëmijare höjo. ");
INSERT INTO aom_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Bövi biseꞌo rumoꞌe aribövioho suvuorëmijare höjamu hegorovo Iesuro uavadeje: Bogave magonahoho vavaenoho bojamiꞌiranëjo. Huro nimade höjo osoho avoho mueberomo guomevego otehodegoromo guavevoꞌiröhëni. ");
INSERT INTO aom_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Bövi biseꞌo rumoꞌe aribövioho jemëꞌo jiemu jioruomoꞌi na bogo jemëꞌoho hiemu hiꞌejöjo. Ëhuni hu iae mae otehodegade höjo. ");
INSERT INTO aom_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Ëhiꞌamu Jew raje ae ahoꞌobëhe hejare uvavamu: Iesuro Lazarusꞌo gemuore hijajë uvamu hegorovo rueruomadeje Iesu gaꞌirovo. Röhu bogo Iesu gemu gaꞌi rueꞌirögoro Lazarusꞌo gaꞌi rovareje Iesuro ajamamu iꞌovëꞌëro jiëꞌëro. ");
INSERT INTO aom_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Lazarus gaꞌi rueruomaje jöho hegoro priest masijohuro jöe mevoromo uarovareje: Ëꞌego Lazarusꞌo anoꞌirarëjo. ");
INSERT INTO aom_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Lazarus anoꞌi atare hesi bëhoho Jew raje ae ahoꞌobëhe uvareje: Iesuro Lazarus mabëhe ajamijade höromo priest masijo jabesi jöho vuonugoꞌi Iesu mae uehorovareje. Ëhuni anoꞌi atareje. ");
INSERT INTO aom_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Ëhiꞌamu nërö sörö iꞌi rovare aribövioho ahoꞌobëhe hejareje uvavamu: Iesu Jerusalem rojomajëjo. ");
INSERT INTO aom_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Rojomajëjamu hegorovo ijo rude ujuohoromo Iesu birohoꞌirögoro uvobe vaꞌoromo uvoruomadeje: God mabëhëjo. Ave aho Badare ihore rovajoho mabëhëjo. Israel rajo nosi börömoho mabëhëjo. ");
INSERT INTO aom_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Ëhi uvoruomamu Iesuro donkey harihe baeromo hesi döre ajio hijadeje. Donkey döre hijego Jerusalem amo rajehu garuomoꞌiröhe jöho mamiꞌe God-are surire jajivoromo uvëꞌeje: ");
INSERT INTO aom_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Zion rajomë nadi juhuonivoꞌi arueho gahëjo. Jemesi börömohuro donkey harihu döre hiromo rovajëjo. Ëhi jajivëꞌeje. Röhu mamiꞌe God-are surire jajivadëhi Iesuro ëhi ëꞌadeje. ");
INSERT INTO aom_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Urimoho Iesuare ijorajo ömoꞌömohuro ë surire jö hesi bëhoho bogo avoho uehorovareje. Röhu ijonö Iesuro döre ajiomoromo aje baeromo böröme namijamu evare ë jöho uehorovoromo uvareje: Iae mae-ëjo. Iesuare jö God-are surire jajivarëhi no hesi örire ëhi vaejahare höjo. ");
INSERT INTO aom_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Röhu ae ahoꞌobëhe Iesu birohoꞌi rueruomade hesi bëhoho urimëꞌi Lazarus guomamu Iesuro huni uvamu iꞌovoromo munë gagore jioromo hörö rovamu evare ae ahoꞌobëhe Iesuꞌo raromoromo ë muoho gavareje. Gavëꞌëro ë jöho majëhibe jijihareje. ");
INSERT INTO aom_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Ëbëhiꞌe mu börömo hesi jöho majëhijamu hejëꞌëro ëhuni ae ahoꞌobëhe Iesu birohoꞌi rueruomadeje. ");
INSERT INTO aom_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Iesu birohoꞌi rueruomamu gëgorovo Pharisee ariböviohuro uarovareje: Jemëꞌo gahëjo. Ëa hesi mu tugohëꞌoho bogo eni javuo hesi höjo. Iae ae ahoꞌobëhe mae hu gemu uehorovoromo hesi ijore ijore jijihoruomajëjo. ");
INSERT INTO aom_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Ëhiꞌamu ae ahoꞌobëhe Jerusalem rojomamu Greece raje ae gö gö jabuꞌo rojomareje sörö majaho rovego God rajahiꞌiröhëro. ");
INSERT INTO aom_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Rojomoromo Philip gaꞌi rovareje. Philip hu Galilee saꞌa raje Bethsaida amo raje jiadeje. Jaburo Philip gaꞌi rueromo uavareje: No naguajëjo Iesu gaꞌirovo. ");
INSERT INTO aom_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Ëhi uavamu hegorovo Philip-ro vaꞌoromo Andrew uanugoromo jaburo niöꞌiro vaꞌoromo ë jöho Iesu majahijareje. ");
INSERT INTO aom_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Majahijamu Iesuro uëvadeje: God-are A Ma nasi iho döre jioröhe majaho iae rovëꞌe höjo. ");
INSERT INTO aom_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Ave naehu ëꞌirode jöho uhuꞌe majëhiꞌiëꞌajëjo. Ëhesi bëhoho iae jö mae ma-gemuohemu höjo. I ujo gemu saꞌare beruvebiromo sisërëꞌajëjo. Sisërëjëꞌëro ëhuꞌëro tögömoromo ëgovoromo baje ahoꞌo raeꞌamoꞌajëjo. Bogo sisërëꞌibejajo ëhi ma-gemu jioꞌibejajo. Sisërëjëꞌohuro ëhuro bogo sivuoho jioꞌi ahoꞌo jioꞌamoꞌajëjo. Na ëhi sisërëjevoꞌiramu ëhuro ae ahoꞌo gemuore jioꞌaꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Ae rahu jabesi sinohemu uehorovëꞌoho ijumorovarue höjo. O ave saꞌare raromoromo sinehu nimaje mu bogo uehorovëꞌoho ëhuro ioroꞌiore gemu raromoꞌaruëjo. ");
INSERT INTO aom_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Ae rahu nasi mu vaeꞌi nimëꞌoho nasi ijore ijore jijihoꞌaruëjo. Na dinöꞌe hijëꞌiroho nasi mu aribövioho jabuꞌo ë raromonövoꞌaruëjo. Ae rahu nasi mu vaejehëꞌoho nasi Vavuohuro jabesi ihoho döro bamoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Avevejöꞌoho na dë vövöbajoꞌere vavaenegavajëjo. Ëhuni na diehi uaꞌejöjo. Na na uaꞌejöjo: Apajo. Ave vavaeni maja rueröhoho tugohehego bogo baeꞌiröjo. Bogajo. Na bogo ëhioho uaꞌejöjo rabëni na ë vavaenoho baeꞌi rovëꞌëro. ");
INSERT INTO aom_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Ëhuni bogo tugoho jöho uaꞌirögoro aꞌi uaꞌejöjo: Apo jasi ajiꞌe muoho röjëhijego aëro garomo uvarëjo: Jasi ihoho böröme höjo. Jasi ihoho böröme hö uanugoromo hejadeje öꞌidöre uvavamu: Na mamiꞌe nasi ajiꞌe muoho röjëhijëꞌe jevajëjo. Röhu maho röjëhiꞌejöjo aëro uvoruomoröhego: God nasi ihoho böröme höjo. ");
INSERT INTO aom_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Ëhi uvavamu hegorovo ae ahoꞌobëhe bëhire riravarohuro a ioroꞌiorohuro uvareje: Varurëro anavohijajo. A ioroꞌiorohuro uvareje: O aneraëro Iesu jöe majahiromo uvavohijajo. ");
INSERT INTO aom_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Ëhi atoruomamu hegorovo Iesuro uëvadeje: Ëjö uvavamu hejarijoho bogo nasi jöënioho uvoꞌi jemesi jöëni uvade höjo. ");
INSERT INTO aom_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Jaruvoho ave saꞌare mu sisë vaeruomaje aribövioho God-ro mevëvoꞌirögoro ëꞌajëjo. Jaruvoho ave saꞌare mu sisë simano vaejaje aho God-ro ruahöꞌöꞌirögoro ëꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Na saꞌare jevajoho aehu banigojiomevëꞌoho evare naro ae ahoꞌobëhe rinëgoꞌiramu nasinö rueruomoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Aehu hu banigojiomoꞌiröhe jö majëhijadoho huro uëromo ëꞌadeje: Aëro ëhi korosire banigojiomevoꞌiramu guomoꞌejöjo. ");
INSERT INTO aom_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Ëhi uëvamu hegoro rue ariböviohuro uaruomadeje: Guomoꞌirane jö uövuanuoho röhu no hejëꞌe javuajëjo nosi jögoru surire adahoromo uövuamu: Böröme namiromo ajamuiꞌiröhe aho nosirire rovëꞌiroho hu bogo guomoꞌi ma-ioroꞌioremu hiꞌaꞌajëjo. Ëhi jiëꞌoho ja diehi uöromo ëꞌanuëjo: Aëro God-are A Maho na banigojiomevoꞌaruëjo. God-are A Maho ja diehi jiëꞌe aëro javëꞌëro ja guomoꞌi uvanuëjo. ");
INSERT INTO aom_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Guomoꞌi uvanuëjamu hegorovo Iesuro uëvadeje: Ajoho naro majae ma-bunemu jemëꞌo hiromo ajivëvoꞌejöjo. Jemëꞌo hiromo ajivëvego ajiro jijihorëjo ëhuro bogo ramoramovëvoꞌiröhe höjo. Ramoramore jijihëꞌoho öroho sidövëvoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Ëhi jiëꞌe jiaje aji naehu jemëꞌo hijajevaro evaro ajoho na mae uehorovevorëjo. Mae uehorovevëꞌoho ajiꞌe aribövie jëvoꞌajëjo. Ëhi uënugoromo vaꞌadeje. Vaꞌoromo gurihirovoromo diröꞌo göro hijadeje jaburo gajöëni. Ëhiꞌadeje. ");
INSERT INTO aom_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Urimo Iesuro Jew rajohuꞌo hiromo bëhiꞌe mu masije ahoꞌobëhe jabesi nunire vaebe rovadeje. Röhu jabumëro hesi öriroho bogo maho uehorovareje. ");
INSERT INTO aom_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Ëhesi bëhoho jö God-aro baeromo majëhinövade ae Isaiah-hu maminö göꞌe jajivadëhi ëhi jioröhego ëhuni Iesu bijönimareje. Isaiah-ro God-are surire jajivoromo uvadeje: Bada rahuro nosi jöho mae uehorovëꞌe höjo. Badare darugoꞌe mu hesi bëhoho rahuro avoho gavëꞌe höjo. Isaiah-ro ëhi jajivadeje ijonö jioröhego. Huhu jajivadëhi jaburo ëhi ëꞌoromo Iesu bogo ma uehorovareje. ");
INSERT INTO aom_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Iesu mae uehorovoꞌiröhoho bogo eni jëvadeje. Bogo eni jëvade hesi bëhoho Isaiah-ro ave jöhuꞌo surire uhunöꞌe jajivadeje. Jajivoromo uvadeje: ");
INSERT INTO aom_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","God-ro uvajëjo: Naro jabesi nunoho tugohëhoromo uehoroho ijumëhëꞌe jevajëjo ëhuro nunoho ramoramovëvoromo uehoroho bogojëvoröhego. Uehoroho bogojëvego bogo huotorovoromo nasi öriroho bogo rovego naro bogo iꞌovëvego bogo mae jëvoröhego. ");
INSERT INTO aom_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Isaiah-hu ëhi jajivade hesi bëhoho huro uehore God-aro baeromo Iesuhu baeröhe ajoho garomo huhu vaeröhe jöho jövadeje. ");
INSERT INTO aom_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Iae a ioroꞌioroho Iesu bogo ma uehorovareje röhu a ioroꞌioroho ahoꞌo Jew rajo a masijo ioroꞌiorohuꞌo iae hu mae uehorovareje. Mae uehorovoromo röhu uvareje: Pharisee ömoꞌömohuro uöꞌaꞌaruëjo: Iesu mae uehorovarujohuni God rajahijarue osaroho nadi ijoroho ruerë uöꞌaꞌaruëromo ëhuni Pharisee juhuonëmiromo Iesu mae uehorovare jöho subivëhareje. ");
INSERT INTO aom_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Uvareje: God-hu no rajahuiꞌiröhoho ëho ma-jianovoꞌi aehu no rajahuijaruoho iae mae höjo. ");
INSERT INTO aom_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Iae Iesuro ma-darugoꞌo uvadeje: Ae rahu na mae uehorovevëꞌoho bogo nasi öriroho gemu uehorovevoꞌi saꞌare remöꞌöjade ahuꞌo mae uehorovarue höjo. ");
INSERT INTO aom_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Ae rahu na gevëꞌoho saꞌare na remöꞌöjade ahuꞌo gavarue höjo. ");
INSERT INTO aom_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Naro saꞌare rovëꞌëro ahoꞌo ajivëvaje höjo ëhuro ae rahu na mae uehorovevëꞌoho ë aribövioho bogo ramoramoroho raromoröhego. ");
INSERT INTO aom_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","O ae rahu nasi jö heromo bogo ejehëꞌoho na bogo jabesi jöho mevoromo sisëroho bamëvoꞌejöjo. Saꞌae ahoꞌo bogo sisëroho bamëvoꞌi maro bamëvoꞌi rovode höjo. ");
INSERT INTO aom_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Röhu naꞌo nasi jöhuꞌo bijönimëꞌoho sisëre vaꞌiröhe bëhoho iae jiajëjo. Bëhoho ëho naehu majëhibe rovode jöho höjo. Hujeji ijo tugohoꞌi majaho rueꞌiramu ë jöho bijönimëꞌëro ëhuꞌëro sisëro vaꞌaꞌaruëjo. ");
INSERT INTO aom_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Rabëni hesi bëhoho naehu majëhibe rovode jöho bogo nasi ëma jövoꞌi Vavue saꞌare remöꞌöjadohuro jöho bojemijade höjo naro ëhuremu jövoꞌirodego. ");
INSERT INTO aom_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Röhu naro garomo uvaje höjo: God-hu bojemijade jö aehu ejahëꞌohuro ëhuro ma-ioroꞌioremu maro raromarue höjo. Ëhuꞌëro jiëꞌëro naehu jövaje jöho Vavuehu uevadëhi iae ëhi gemuoho höjo. ");
INSERT INTO aom_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Iae God-hu Vörö Tugohade Sörö majaho nërëhi jio hesi jiadeje. Nërëhi jio hesi jiamu Iesuro garomo uvadeje: Naehu saꞌa nugoꞌi Vavu hesi örire vaꞌirode majaho iae rovëꞌe höjo. Röhu hesi aribövi maho ave saꞌare raromaruoho mamiꞌe dë vövöbajoꞌe ahoꞌo uehorovëvobe rovadoho bogo vuonugoꞌi uehorovëvobe vaꞌadeje ëhi ma-guomoröhego. ");
INSERT INTO aom_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Iae Satan-ro mamiꞌe Simon Iscariot-are harihe Judas-are simanoho ijumahadeje huro Iesu bijönimarue a jabesi övore bojëmiꞌiröhego. Ëhi jiëꞌëro Iesuꞌo hesi ijorajoho jabuꞌo raromoromo i harihe ueꞌahareje. ");
INSERT INTO aom_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Ie ueꞌahoromo Iesuro garomo uvadeje: Vavuohuro daruge ahoꞌobëhe nasi övoro bamehëꞌe höjo. Na God-arire jioromo rovodoho hesi örire vuonoröꞌö vaꞌejöjo. ");
INSERT INTO aom_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Hesi örire vuonoröꞌö vaꞌejöromo Iesuro ie ijëꞌëro riꞌöromo döre niögoho jijöromo uhirovarue niögoho dëꞌahore muohorovadeje. ");
INSERT INTO aom_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Muohorovoromo jovoho hevöre otehoromo aevoromo hesi ijorajo jabesi höroho eguëhoromo muohorovade niögoho baeromo höroho uhijëhadeje. ");
INSERT INTO aom_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Ëhiꞌobe vaꞌoromo Simon Peter-hu hijajire rovadeje. Rovamu uavadeje: Bada na ja nasi hörohuꞌo eguehonëjo. ");
INSERT INTO aom_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Eguehonëjamu uavadeje: Naehu ömaje hesi bëhoho jaruvoho ja bogo gavanuëjo. Uꞌemu gaꞌaꞌanuëjo. ");
INSERT INTO aom_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Gaꞌaꞌanuëjamu hegorovo Peter-ro uavadeje: Nasi höroho bogo eguehoꞌanuëjo. Bogo mae bogajo. Bogajamu uavadeje: Naehu jasi höru bogo eguahëꞌoho ijonöho ja bogo nasi ae gemuoho javoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Javoꞌajëjamu hegorovo Simon Peter-ro uavadeje: Ëhi jiëꞌe jiaje nadi höremuoho eguehoꞌi aꞌi övohuꞌo simanohuꞌo ëhuꞌo eguehëjo. ");
INSERT INTO aom_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Eguehëjamu Iesuro uavadeje: Rabëni övoho simanoho eguahojörajo. Bëhoho bogohöjo. Ae rahu jabesi sino hahoꞌo jovo eguoromo uꞌo barëjëꞌoho röhu maho bogo eguoruomoꞌi jabesi hörohemu eguonövoꞌaruëjo. Röhu jemesi sisëho mamiꞌe uꞌovëhëꞌëro mae jëvajëjo. Mae jëvoꞌi sisëho jemesi ae gemu hesiriremu höjo. ");
INSERT INTO aom_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Iesuhu ëhi uëvade hesi bëhoho huro garomo uvadeje: Judas-ro na bijönegarue a jabesi övore bojëmiꞌajëjo. Ëhuni uëvadeje: Jemë mae jëvoꞌi sisëho jemesi ae gemu hesiriremu höjo. ");
INSERT INTO aom_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Ëhi uëromo ijorajo jabesi höroho eguëhonugoromo niögu jijö bamadoho röhu maho baꞌamoromo vaꞌo hesi röhore hinugoromo uëvadeje: Naehu jemesi örire ömode mu hesi bëhoho na jemë gavarujëjo o bogajo. ");
INSERT INTO aom_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Bëhoho iae na majëhiꞌiëꞌajëjo. Jemëro uevaruje höjo: Tisajo o Badajo. Iae mae uevaruje höjo na ëhi jevëꞌego. ");
INSERT INTO aom_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Na jemesi Badaꞌo Tisaꞌo jevajëjo röhu na bogo uvode höjo: Böviëro jevëꞌëro höroho bogo eguëhoꞌejö uvoꞌi ma-eguëhode höjo. Ëhuni jemëꞌo nadi bövie javuajë uvoꞌi göëro göho huë baerovoromo höroho eguahorovorëjo. ");
INSERT INTO aom_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Ëhesi bëhoho naro mu mae röjëhijëꞌe jevajëjo ëhuro naehu jemë ajëmijodëhi jemëꞌo ëhi huë baerovoromo ajamirovoꞌirarijego. ");
INSERT INTO aom_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Ave jöho na jö mae uëꞌiëꞌajëjo. Mu ariböviohuro o anue jijiharue ariböviohuro jabesi a börömoho bogo iosiramiromo masije riravarue höjo. ");
INSERT INTO aom_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Ëjöho mae jioꞌego jemë iae gavarujëjo. Ëhuni nadi na iosiremiromo uvorëjo: No masijëro javuëꞌëro aho bogo ajëmiꞌejarë uvoꞌi ma-ajamirovorëjo. Ëhi ëꞌëꞌoho huë mae jëvoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Huë mae jëvoꞌajë uëvaje jöho ëho bogo ae ahoꞌobëhe jemesi jöho uëromo ëꞌajëjo. Jemë diehi jiëꞌe aribövie baejëvodoho iae na gëvaje höjo. Mamiꞌe God-are surire jöho jajivoromo uvëꞌe höjo: Naꞌo gemu mae i ijajohuro huotorovoromo naꞌo muorovoꞌi nimade höjo. Ëhi jioröhego God-are surire jajivadëhi iae ëhi jiëꞌe mu sisëho jioꞌaꞌajëjo God-are surire jöho bogo bejajëro jiëꞌëro. ");
INSERT INTO aom_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Ëmu sisëho bogo vejöꞌoho jioꞌi uꞌemu jioꞌaꞌajëjo. Röhu aviavejöꞌe uëvajëjo jemëro gaꞌirarijego ë mu sisëho rovego garomo uvoꞌirarijego: Iae mae-ëjo. Nörö jiemu jiaje A Börömoho höjo. ");
INSERT INTO aom_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Röhu ave jöho na jö mae uëꞌiëꞌajëjo. Naehu rëmöꞌöjego rovarue aribövioho ae rahuhu ë aribövi rajëhiromo baejëvëꞌoho ëhuro naꞌo rajehiromo baejevoruomaje höjo. O ae rahu na rajehiromo baejevëꞌoho ëhuro remöꞌöjamu rovode ahuꞌo rajahiruomaje höjo. ");
INSERT INTO aom_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Ëhi uëromo hesi dë vövöbajoꞌere huë vavaene böröme baejadeje. Huë vavaene böröme baeromo ma-samaꞌe majëhiromo uëvadeje: Ave jöho na jö mae uëꞌiëꞌajëjo. Jemesirire jiaje ae gemuëro na bijönegarue aribövi jabesi övore bojëmiꞌanuëjo. ");
INSERT INTO aom_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Ëhi uëvamu hegorovo hesi ijorajoho jaburo nuniro garoro garoro baeromo uvareje: Rahuare jöho uöromo ëꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Röhu Iesuare ijoraje ae gemuëro Iesuare bëhi mare hijëꞌe jiadeje. Iesuro ë aho hesi dë vövöbajoꞌe ahoꞌo rajahinövadeje. ");
INSERT INTO aom_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Ëaho Iesuare bëhire hijëꞌe jiamu Simon Peter-ro ë a hesi örire uvenëro uavadeje: Ua gavëjo: Rahuare jöho uöromo ëꞌanuëjo. ");
INSERT INTO aom_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Uöromo ëꞌanuëjamu ë ijorajohuro Iesu hiaꞌiro saginiëri uavadeje: Bada ja rahuare jöe uöromo ëꞌanuëjo. ");
INSERT INTO aom_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Uöromo ëꞌanuëjamu Iesuro uavadeje: Naro ioho baeromo ijo bajo nemarire baꞌamoromo ioromo ae gemu bojamiꞌejöjo. Bojamijego garomo uvonëjo: Iae ë ahuro ëhi sisë vaejevoꞌajëjo. Ëhi uanugoromo ie gemu baeromo baꞌamoromo ioromo Simon Iscariot-are harihoho Judas bojamijadeje. ");
INSERT INTO aom_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Bojamamu Judas-ro baeromo ijamu gavëꞌi Satan-ro ë a hesi dë vövöbajoꞌere abuejadeje. Abuejamu Iesuro uavadeje: Jaehu vaeꞌi ëꞌanue muoho ma-burëro vaꞌoromo vaejëjo. ");
INSERT INTO aom_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Vaejëjamu hegorovo raromoromo i ijarue ariböviohuro bëhoho rabëni Iesuhu Judas ëhi uavajoho bogo avoho hejareje. ");
INSERT INTO aom_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Bogo avoho heꞌirögoro a ioroꞌiorohuro uvareje: Judas-ro moni bahijaruoho muebejajego ëhuni nani Iesuro uaromo ëꞌajëjo: Vaꞌoromo söröëni ie imahuëjo. O vaꞌoromo inömo rumoꞌe aribövioho monioho gö suvuorëmijëjo. Ëhuni uaromo ëꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Röhu Judas-ro Iesuhu bojamijade ioho baeromo ma-burëro höröromo ramoramore vaꞌadeje. ");
INSERT INTO aom_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Judas vaꞌamu gagorovo Iesuro uëvadeje: Avevejöꞌoho God-are A Ma nasi ajiꞌe muoho röjëhijëꞌe höjo. God-ro daruge bojemijëꞌëro hesi ajiꞌe muohuꞌo röjëhijëꞌe jevajëjo. ");
INSERT INTO aom_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Naro God-are ajoho ae röjëhiꞌiramu evare God-ro hesi A Ma nasi ihoho banigojiomehoꞌajëjo. Hu ma-burëro iae ëhi ëꞌiëꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Nasi harihu ömoꞌömohumë na jemëꞌoho majae ma-bunemu hiꞌejöjo. Hiromo vaꞌiramu nahevoꞌarujëjo. Röhu Jew rajo masijo mamiꞌe uëvodëhi jemëꞌo ëhi uëꞌiëꞌajëjo: Naehu vaꞌirodire jemë ë öꞌirarijoho bogo eni jëvajëjo. ");
INSERT INTO aom_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Röhu jögoru iꞌe bojëmiꞌiëꞌajëjo. Göëro göho rajahirovorëjo. Naehu jemë rajëhibe rovodëhi jemëꞌo ëhi gemuoho ëꞌorëjo. ");
INSERT INTO aom_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Jemë rajahirovëꞌoho ëhuro ae ahoꞌobëhe gëromo uvoruomoꞌajëjo: Jemë nöruare ijore ijore jijiharuje aribövie jëvajëjo. ");
INSERT INTO aom_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Ëhi uëvamu Simon Peter-ro uavadeje: Bada röhu ja dinöꞌe vaꞌonëjo. Dinöꞌe vaꞌonëjamu uavadeje: Naehu vaꞌirodire avevejöꞌe ë öꞌiranoho bogo eni javajëjo. Uꞌemu öꞌaꞌanuëjo. ");
INSERT INTO aom_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Öꞌaꞌanuëjamu hegorovo Peter-ro uavadeje: Bada röhu avevejöꞌe naehu jasi ijore öꞌëꞌoho rabëro bogo eni jevajëjo. Naehu ajamiromo jani guomevëꞌoho iae mae höjo. ");
INSERT INTO aom_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Iae mae höjamu Iesuro uavadeje: Peter jero uvanuëjo: Naro nörö ajamiromo guomorovoꞌejöjo. Röhu ave jöho na jö mae uaꞌiëꞌajëjo. Kökörökoho bogo uvëꞌe jero majae niöꞌi gemu ae uëꞌaꞌanuëjo: Na Iesu bogo gavaje höjo. ");
INSERT INTO aom_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Iae Iesuro hesi ijorajo ömoꞌömoho uëvadeje: Nadi nurunurumoromo uehore gö gö baeꞌi aꞌi God-are öroro mae uehorovoromo nasi örohuꞌo ëhuꞌo mae uehorovorëjo. ");
INSERT INTO aom_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Ëhesi bëhoho nasi Vavu hesi osare röhoho ahoꞌobëhe jioꞌamajëjo. Ëhuni na ë vaꞌoromo jemëhu raromoꞌirarije röhoho avohëhoꞌejöjo. Naehu jövaje jöho bogo maehu jioꞌibejajo bogo uëꞌibejöjo. ");
INSERT INTO aom_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Vaꞌoromo jemesi röhoho avohëhonugoromo vuonoröꞌö rueromo söjëvoromo nasirëro vaꞌejöjo ëhuro naehu hijajire jemëꞌo ë raromoꞌirarijego. ");
INSERT INTO aom_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Naehu vaꞌoromo hiꞌirode öroho jemë iae gavaruje höjo. ");
INSERT INTO aom_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Gavaruje höjamu Thomas-ro uavadeje: Bada jero ëhi uövuanuëjo röhu jaehu dinöꞌe vaꞌo hiꞌiranoho no bogo gavaruëjo. Ëhi jiëꞌoho ja diehiꞌoromo uövuanuëjo: Öroho iae gavaruje höjo. ");
INSERT INTO aom_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Gavaruje höjamu Iesuro uavadeje: Mare vaꞌirarije öroho na jevajëjo. Jö ma gaꞌirarije öroho na jevajëjo. Darugo baeꞌirarije öroho na jevajëjo. Vavuohuꞌo gemu mae jëvojöro nëgëꞌiroho öroho na gemu jevajëjo. ");
INSERT INTO aom_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Jemë na gevëꞌe jëvëꞌëro nasi Vavuohuꞌo gaꞌaꞌarujëjo. Jaruvoho aevoromo jemë ë A hesi bëhoho uehore baeromo gabe vaꞌaꞌarujëjo. ");
INSERT INTO aom_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Gabe vaꞌaꞌarujëjamu Philip-ro uavadeje: Vavuoho röjahuijego no gavarëjo. Gavëꞌoho ëhuro no mae javuoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Mae javuoꞌajëjamu uavadeje: Philip na majae ëgobövie jemëꞌo hijëꞌe jevajëjo. Ëhuꞌoho ja diehiꞌoromo bogo avoho gevanuëjo. Ae rahu na gevëꞌoho nasi Vavuohuꞌo garuomaje höjo. Ëhuꞌoho ja diehiꞌoromo uevanuëjo: Vavuoho röjahuijego no gavarëjo. ");
INSERT INTO aom_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Ja diehiꞌoromo bogo uehorovoromo uvanuëjo: Nöröro Vavu hesi dë vövöbajoꞌere jioꞌi Vavuohuro nöruare dë vövöbajoꞌere jiajëjo. Naehu jemë uëvaje jöho bogo nasi ëma uehorovoromo uëꞌi aꞌi Vavue nasi dë vövöbajoꞌere hijajohuro huro hesi muoho nasi dë vövöbajoꞌere vaejego na vaejaje höjo. ");
INSERT INTO aom_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Na uëvode höjo: Naro Vavu hesi dë vövöbajoꞌere jioꞌi Vavuohuro nasi dë vövöbajoꞌere jiajëjo. Ëjöho heromo uvorëjo: Iae mae-ëjo. O jemë uvëꞌoho: Nöruare jöho bogo eni hö uvëꞌoho naehu vaejaje mu masijoho uehorovoromo uvorëjo: Nöruare jöho mae höjo. ");
INSERT INTO aom_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Ave jöho na jö mae uëꞌiëꞌajëjo. Ae rahu na mae uehorovevëꞌoho naehu vaejajëhi jiëꞌe darugoꞌe muoho vaeꞌaꞌarujëjo. Röhu naehu vaejaje darugoꞌe muoho ma-jianovajoho uꞌemu jemëro darugoꞌe mu masijo maho vaeꞌaꞌarujëjo rabëni naro Vavu hesi örire vaꞌiramu. ");
INSERT INTO aom_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","O jemë rabe rabe Vavuoho nasi ihore ua gavëꞌoho naro ëhi vaejëhoꞌejöjo ëhuro Harihu nasi muoho garomo uvoꞌirarijego: Vavuoho böröme höjo. ");
INSERT INTO aom_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","No nöruare aribövie javuajë uvoromo rabe rabe ue gevëꞌoho iae na vaejëhoꞌejöjo. ");
INSERT INTO aom_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Jemë na rajehijëꞌohuro nasi jögoroho ejehoꞌarujëjo. ");
INSERT INTO aom_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Ejehoꞌiramu naro Vavuoho uaꞌiramu Ajëminövoꞌiröhe A göho bojëmiꞌajëjo huro rueromo jemëꞌo ma-ioroꞌioremu hiꞌiröhego. ");
INSERT INTO aom_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Ajëminövoꞌiröhe Aho iae jö maemu barovaje Aruꞌahoho höjo. Saꞌarohemu uehorovarue ariböviohuro ë Aruꞌahoho bogo uehorovoromo simanoho bogo avoho gavaruëro jiëꞌëro ëhuni baeꞌiröhoho bogo eni jëvajëjo. Aꞌi jemëro hu avoho gavaruje höjo. Avevejöꞌe hu jemëꞌo hijajoho uꞌemu jemesi dëre abo hibe vaꞌaꞌajëjo. Iae ëhuni jemë gavaruje höjo. ");
INSERT INTO aom_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Naro jemë rëmo vaꞌiramu jemë bogo sivuoho öbioho raromanovoꞌarujëjo. Aꞌiro na vuonoröꞌöromo jemesirire rueꞌejöjo. ");
INSERT INTO aom_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Majae ma-bunemu barëꞌiramu saꞌarohemu uehorovarue ariböviohuro bogo geruomoꞌajëjo. Röhu jemëro iae geꞌaꞌarujëjo. Na hiemu hijajohuro ëhuro jemëꞌo daruge baeromo raromoꞌarujëjo. ");
INSERT INTO aom_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Ëho majaho rueꞌiramu jemë garomo uvoꞌaꞌarujëjo: Nörö hesi Vavu hesi dë vövöbajoꞌere jioꞌi no nöruare dë vövöbajoꞌere javuoꞌi nörö nosi dë vövöbajoꞌere jiajëjo. ");
INSERT INTO aom_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Ae rahu nasi jögoru baeromo ejehëꞌoho ëhi jiëꞌe ariböviohuro rajehiruomaje höjo. Rajehijëꞌoho nasi Vavuohuro jabumë rajëhiꞌajëjo. Rajëhiꞌiramu naꞌo ë aribövioho rajëhiromo vaꞌorahoro röjahirovoꞌejöjo geruomoröhego. ");
INSERT INTO aom_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Ëhi uëvamu Judas-ro bogo Judas Iscariot aꞌi Judas göhuro Iesu uavadeje: Bada ja diehiꞌoromo nosi örire gemu jasi arijoꞌarije röjahirovoꞌi saꞌarohemu uehorovarue aribövi jabesi öriroho bogo röjahirovoꞌiëꞌanuëjo. ");
INSERT INTO aom_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Bogo röjahirovoꞌiëꞌanuëjamu uavadeje: Ae rahu na rajehijëꞌoho ë ariböviohuro nasi jöho ejehoruomoꞌajëjo. Ejehoꞌiramu nasi Vavuohuro jabumë rajëhiromo huꞌo naꞌo öꞌoromo jabuꞌo gemu mae ariꞌejarëjo. ");
INSERT INTO aom_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","O ae rahu bogo rajehijëꞌoho nasi jöho bogo ejehoruomaje höjo. Jemë hejaruje jöho bogo nasirehu jioꞌi aꞌi Vavuehu remöꞌöjamu rovode a hesi jöho höjo. ");
INSERT INTO aom_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Na jemëꞌo hijëꞌi ë jöho majëhijëꞌe jevajëjo. ");
INSERT INTO aom_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","O Vavuohuro jemë Ajëminövoꞌiröhe Aho ë hesi bëhoho Vavu hesi Aruꞌahoho nasi ihore nugöꞌöꞌiramu huro jemë bövioho biseꞌoho röjëhiromo simanoho huotovëhoꞌiramu naehu majëhijode jöho uehorovo barëꞌarujëjo. ");
INSERT INTO aom_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Nasi huë maho jemesi örire bojëmijajëjo rëmo vaꞌiëꞌëro. Saꞌarohemu uehorovarue ariböviehu huë ma bojëmijaruëhioho na bogo ëhioho bojëmiꞌi uhohuꞌo bojëmijajëjo. Nadi nurunurumoromo juhuonivorëjo. ");
INSERT INTO aom_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Mamiꞌe jemë hejarije höjo naro uëvamu: Na vaꞌejöjo. Röhu na vuonoröꞌöromo jemesirire rueꞌejöjo. Jemë na avoho rajehiꞌibejarijëjo nasi Vavu hesirire vaꞌirode jöho heromo nimorohoꞌibejarijëjo Vavuehu na iosiremiromo börömo jiajohuni. ");
INSERT INTO aom_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Avevejöꞌoho ë muoho bogo vaejëꞌe röhu urimo na ma-majëhijëꞌe jevajëjo ëhiꞌego garomo evare mae uehorovoꞌirarijego. ");
INSERT INTO aom_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Röhu na bogo majae ëgoꞌoho jemë jöho majëhiꞌejöjo ave saꞌare Sisë A Börömoho rueꞌego ëhunivo. Röhu hu bogo nasi bövioho jiëꞌëro hu jöho bogohöjo. ");
INSERT INTO aom_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Röhu na nege saꞌae ahoꞌo jaburo garomo uvoruomoröhego: Nöröro Vavuoho iae rajahiromo Vavuehu jö bojamijadëhi nöröro ëhi ëꞌaje höjo. Ahia minoꞌëjo. Riꞌöhego no vaꞌarëjo. ");
INSERT INTO aom_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Iae Iesuro hesi ijorajo ömoꞌömoho jö viture uhuꞌe uëvadeje: Grape bajo rae avohaje öꞌoho na jevajëjo. Öꞌi muebejaje aho nasi Vavuoho höjo. ");
INSERT INTO aom_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Naꞌo bimuvaruje aribövioho ëho öꞌi ado sirinoꞌoho jioꞌamajëjo. Öꞌi muebejaje ahuro garöhe di adoho bajoho bogo raeꞌamamu gavëꞌoho duvahore tarivoromo ruruhöꞌöjaje höjo. O garöhe di adoho bajoho raejamu gavëꞌoho iogororomo sirino sirino harihu sahoriꞌamëꞌoho tarivo ruruhöꞌöꞌi mahemu nugaje höjo ëhuro ë adohuro bajoho rae avohoröhego. ");
INSERT INTO aom_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Röhu naehu majëhijode jöho ejehëꞌëro ëhuro jemë adonöꞌe mamiꞌe iogorëvëꞌe höjo. ");
INSERT INTO aom_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Röhu jemë naꞌo gemuore bimuvoromo raromarujoho ëhi raromorëjo. O naro jemëꞌo gemuore bimuvoromo hijajoho ëhi hiꞌejöjo. Jemëhu naꞌo bogo gemuore bimuvoromo raromëꞌoho bogo rae avoho hesi jëvajëjo. Öꞌi adehu aho najore bogo bimuvëꞌëro sisërëromo bajo bogo ma raejajëhi ëhi jëvoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Öꞌi bëhoho na jevoꞌi jemë ado sirinoꞌoho jëvajëjo. Ae rahu naꞌo gemuore bimuvoromo raromoꞌi naehu jemëꞌo gemuore bimuvoromo hijëꞌohuro ëhuro rae avohoꞌarujëjo. O naꞌo gemuore bogo bimuvëꞌoho iꞌo muꞌo vaejëꞌoho bogo mae bogo eni jëvoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Ae rahu naꞌo bogo gemuore bimuvoromo raromëꞌoho ado suaromo ruruhöꞌöjego sisërëjajëhi ëhi jëvoꞌajëjo. Ëhi jiëꞌe adoho gagovoromo vënire huego ravoꞌamaje höjo. ");
INSERT INTO aom_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Röhu jemë naꞌo gemuore bimuvoromo raromëꞌoho o nasi jö jemesi dë vövöbajoꞌere jiëꞌoho ëhuro jemë rabe rabe God ua gaꞌi nëgëꞌoho uarëjo. Ua gavëꞌoho iae baeꞌaꞌarujëjo. ");
INSERT INTO aom_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Jemë bajo rae avohëꞌohuro ëhuro nasi Vavu hesi ihoho döro jiaje höjo. O bajo rae avohëꞌohuro ëhuro nasi ijore ijore jijiharuje aribövi mae jëvoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Iae Vavuehu na rajehijadëhi naro ëhi jemë rajëhijëꞌe jevajëjo. Naro ëhi rajëhijëꞌe jevaje ëhuni naꞌo gemu mae ëhi raromorego na rajëhiemu rajëhinövoꞌiröjo. ");
INSERT INTO aom_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Jemëhu nasi jögoru ejehëꞌoho ëhuro naꞌo gemu mae raromoꞌiramu ëhuro na rajëhinövoꞌejöjo. Naehu nasi Vavu hesi jögoru ejahëꞌëro huꞌo hijego huhu rajehijajëhi jemëro ëhi naꞌo raromoꞌiramu rajëhinövoꞌejöjo. ");
INSERT INTO aom_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Naehu jö ëhi jövaje hesi bëhoho naehu nimorohajëhi jemëꞌo naꞌo gemu mae nimorohoꞌirarijego bogo bisemuoho nimorohoꞌi nimoroho avohoꞌirarijego. ");
INSERT INTO aom_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Ave jögoroho naro bojëmiꞌiëꞌajëjo. Naehu jemë dë vövöbajoꞌe ahoꞌo uehorovëvajëhi jemëro göëro göho ëhi uehorovëvorëjo. ");
INSERT INTO aom_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Göehu gö dë vövöbajoꞌere uehorovëvarue mu börömoho aviëhi höjo nosi aganoho ajëmiꞌi vuovorovoꞌejarëjo. Mu ioroꞌioroho ma-jianovajëjo. ");
INSERT INTO aom_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Nasi jögoru ejehëꞌoho jemë nasi agane jëvaje höjo. ");
INSERT INTO aom_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Urimoho na bogo aganoho uëꞌi aꞌi uënövode höjo: Nasi mu vaejaruje aribövie jëvajëjo. Ae gö jabesi mu vaejarue ariböviohuro jabesi masijehu vaejarue mu hesi bëhoho bogo garuomaje höjo. Ëhuni avevejöꞌoho na bogo nasi mu vaejaruje aribövioho uëꞌi aꞌi agane uëvajëjo ë hesi bëhoho nasi Vavuehu rabe rabe uevamu hejode jöho naro röjëhijamu jemë gavëꞌego. ");
INSERT INTO aom_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Jemë na bogo baejevoꞌi aꞌi naro jemë baejëvode höjo. Baejëvoromo muro bamëvode höjo jemëro vaꞌoromo ioroꞌioremu jioröhe bajoho rae avohoꞌirarijego. Ëhi jiëꞌe bajo rae avohëꞌoho ëhuro jemëhu Vavu hesi örire rabe rabe nasi ihore ua gavëꞌoho iae huro bojëmiꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Ëhuꞌëro jiëꞌëro ave jögoroho naro bojëmijajëjo. Göëro göho dë vövöbajoꞌe ahoꞌo uehorovëvorëjo. ");
INSERT INTO aom_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Saꞌarohemu uehorovarue ariböviehu jemë nu huodëgaruoho uvorëjo: Urimo ëhi jiëꞌe ariböviohuro nörö nue huodivoruomade höjo. ");
INSERT INTO aom_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Jemëꞌo saꞌarohemu uehorovaruje aribövie jëvoꞌibejajo ë ariböviohuro uvoruomoꞌibejajo: Jemë nosi aribövie gemuoho jëvajëromo rajëhiꞌibejarëjo. Aꞌi jemë saꞌarohemu uehorovarijoho naro baejëvode höjo nasinö jëvoröhego. Baejëvëꞌego jemë bogo jabuꞌoho havoromo ave saꞌa hesirohemuoho uehorovaruje höjo. Ëhuni ë ariböviohuro jemë nue huodëgarue höjo. ");
INSERT INTO aom_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Jemëꞌo uehorovohëjo. Naro mamiꞌe uëvode höjo: Mu ariböviohuro jabesi a masijoho bogo iosirëmiromo masijoho riravarue höjo. Ëjö hesi bëhoho jemesi börömoho na sisë vaejevëꞌëro ëhuꞌëro saꞌae ahoꞌo jaburo mu vaejaruje aribövioho jemëꞌo sisë vaejëvoꞌaruëjo. O nasi jö ejehëꞌoho jemesi jöhuꞌo ejëhoꞌaruëjo. ");
INSERT INTO aom_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Jemëro nasi ihoho baejëꞌego ëhuni ëho jaburo jemesi örire ëhi sisë vaejëvoruomoꞌajëjo rabëni hesi bëhoho saꞌare na remöꞌöjade aho jabumë bogo gavaruëro jiëꞌëro. ");
INSERT INTO aom_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Na bogo saꞌaroho rueromo jöho jabesi öriroho majëhiꞌibejöjo jabesi jö sisëho bogojioꞌibejajo. Röhu nasi jöho majëhijamu hejare höjo. Hejëꞌëro bogo uöꞌaꞌaruëjo: Noehu mu sisë vaejaroho bogo gavëꞌe ëma ëꞌare höjo. ");
INSERT INTO aom_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Na nu huodegëꞌoho nasi Vavuohuꞌo nue huodivoruomaje höjo. ");
INSERT INTO aom_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Ae göehu bogo vaejarue ëhi jiëꞌe darugoꞌe mu masijoho naro jabesi nunire vaenövode höjo. Jabesi nuniroho ëhi jiëꞌe muoho bogo vaeꞌibejöjo ëhuro jabesi jö sisëho bogojioꞌibejajo. O avevejöꞌoho jabumë nasi muoho iae gavare höjo röhu naꞌo nasi Vavuohuꞌo nue huodaguoruomaje höjo. ");
INSERT INTO aom_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Jabuhu nu huodaguarue hesi bëhoho urimëꞌi jabesi jögoru surire jajivoromo uvëꞌe höjo: Na sisëho bogo ömëꞌe jabumë ëma nue huodegare höjo. Röhu nue huodegoꞌiröhe jö jajivadëhi ëhi nue huodegarue höjo God-are jöho bogo bejajëro jiëꞌëro. ");
INSERT INTO aom_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Röhu jemë Ajëminövoꞌiröhe Aho jö maemu barovaje Aruꞌahohuro jiëꞌëro Vavuohuꞌo gemu mae hijaje höjo. Ëhi hijajëro jiëꞌëro naro nugöꞌöꞌiramu Vavu hesirire jioromo jemesi örire ruvebiꞌajëjo. Ruvebiromo nasi jöho huruoho majëhiꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","O jemëꞌo nasi jöho huruoho majëhiꞌarujëjo aevoꞌi naꞌo raromobe rovëꞌëro jëvëꞌëro. ");
INSERT INTO aom_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Ëjöho naro uëvajëjo jemë mae uehorovevarujoho vuonugojöëni. ");
INSERT INTO aom_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Jew rajehu God rajahijarue osare osare jemëhu gagovoromo God rajahijarujoho aëro ahëvoruomoꞌajëjo. O majae ijonö aehu jemë muoꞌamëvëꞌiroho uvoruomoꞌajëjo: Noehu Iesuare aribövi muoꞌamaruoho ëho God-are mue vaejaruëjo. ");
INSERT INTO aom_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Ëhi jiëꞌe huë vavaeniꞌe muoho jemesi örire vaejëvoꞌaruëjo ë hesi bëhoho Vavuohuꞌo naꞌo bogo gövuaruëro jiëꞌëro. ");
INSERT INTO aom_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Röhu naro ë jöho uëvajëjo ëhuro naehu ëhi uëvode huë vavaeni majaho rovego jemëro uehorovoromo uvoꞌirarijego: Nöröro uövuade höjo: Ëhi jiëꞌe mu sisëho rueꞌaꞌajëjo. Ëhi jiëꞌe jöho na bogo aevoꞌioho uëvode hesi bëhoho na urimëꞌi jemëꞌo hibe juvoromo ëhuni bogo uëvode höjo. ");
INSERT INTO aom_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Röhu avevejöꞌoho na jemëꞌoho bogo hiꞌi aꞌi na remöꞌöjamu saꞌare rovode a hesi örire vuonoröꞌö vaꞌiëꞌajëjo. Jemë bogo ae gemu vaduꞌoho uevarujëjo: Ja dinöꞌe vaꞌiëꞌanuëjo. ");
INSERT INTO aom_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Röhu na vaꞌi uëvodohuni ëhuni jemë sisë maro vavaenimarujëjo. ");
INSERT INTO aom_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Ave jöho na jö mae uëꞌiëꞌajëjo. Na bogo vaꞌibejöjo bisemu sisë jëvoꞌibejajo. O na vaꞌëꞌohuro ëhuro maho jëvoꞌajëjo. Ëhesi bëhoho na bogo vaꞌibejöjo ëhuro God-are Aruꞌahehu Ajëminövoꞌiröhoho jemesi öriroho bogo rueꞌibejajo. O vaꞌëꞌoho ëhuro naro Aruꞌahoho jemëni nugöꞌöꞌiramu rueꞌaꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Aruꞌahohuro rueromo samaꞌe röjëhiꞌaꞌajëjo ae ahoꞌo gaꞌirarijego saꞌarohemu uehorovarue aribövioho jaburo mu sisë hesi öroho mu ma hesi öroho sisë mevëhoꞌiröhe hesi öroho bogo avoho uehorovoruomego. ");
INSERT INTO aom_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Mu sisë hesi öri bogo avoho uehorovarue hesi bëhoho jabumë nasi öriroho bogo maho uehorovevoruomaje höjo. ");
INSERT INTO aom_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Mu ma hesi öri bogo avoho uehorovarue hesi bëhoho naro Vavu hesi örire maro vaꞌiramu ijonöho bogo geꞌaꞌarujëjo. ");
INSERT INTO aom_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Sisë mevëhoꞌiröhe hesi öri bogo avoho uehorovarue hesi bëhoho ave saꞌare Sisë A Börömo hesi muoho mamiꞌe mevamu bejëꞌe höjo. ");
INSERT INTO aom_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Naehu jemë jöe ahoꞌobëhe majëhiꞌirodoho avevejöꞌe simanore uehorovoꞌirarijoho jemë bogo eni jëvajëjo. ");
INSERT INTO aom_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Iae ëhi höjo röhu jö mae barovaje Aruꞌahohuro rovëꞌiroho huro mu ma hesi öroho röjëhi barëꞌajëjo. Hu bogo hesi ëma uehorovoromo jöho jövoꞌi aꞌiro jöe rabe rabe hejëꞌoho ëho jövoromo röhu uꞌemu jioröhe mu jöho huruoho majëhiꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Naro jöe jövoꞌiramu Aruꞌahohuro nasi jöho baeromo jemë huruoho majëhiꞌiramu ëhuro nasi ihoho döro jioꞌaꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Vavuehu jövaje jöho ahoꞌo nasirohuꞌo gemuoho höjo. Iae ëhuni na uëvajëjo: Naro God-are jöe jövoꞌiramu Aruꞌahohuro nasi jöho baeromo jemë majëhiꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Majae ma-bunemu barëꞌiramu jemë na bogo geꞌaꞌarujëjo. Bogo geromo röhu vaꞌo majae ma-bunemu barëꞌiramu evare röhu maho geꞌaꞌarujëjo. ");
INSERT INTO aom_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Geꞌaꞌarujëjamu hegorovo hesi ijorajo ioroꞌiorohuro uarovareje: Iesuro no uövuajëjo: Majae ma-bunemu barëꞌiramu bogo geromo röhu majae ma-bunemu barëꞌiramu geꞌaꞌarujëjo. Hu diehi uöromo jövajëjo. O uövuajëjo: Na bogo geꞌirarije hesi bëhoho na Vavu hesi örire vaꞌiëꞌajëjo. Ëhuꞌo hu diehi uöromo ëꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Majae ma-bunemu uvaje jö bëhoho rabe höjo. Hu rabu jö jövajoho no dadivavuajëjo. ");
INSERT INTO aom_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Ëhi uarovamu Iesuro garomo uvadeje: Arue aribövioho ue geꞌi nimaruëromo uëvadeje: Na uëvajëjo: Majae ma-bunemu barëꞌiramu bogo geꞌaꞌarujëjo. Bogo geromo röhu vaꞌo majae ma-bunemu barëꞌiramu röhu maho geꞌaꞌarujëjo. Na jemë ë jö hesi bëhoho nahoꞌi atarujëjo. ");
INSERT INTO aom_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Ave jöho na jö mae uëꞌiëꞌajëjo. Jemë sisë maro nierusuburuꞌe bamoꞌarujëjo. Aꞌi ave saꞌarohemu uehorovarue ariböviohuro nimoroho avohoꞌaruëjo. Jemë huë vavaene baeꞌaꞌarujëjo röhu huë vavaeni baeꞌirarijoho barëromo dë mae jëvoꞌiramu nimorohoꞌarujëjo. ");
INSERT INTO aom_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Magonahehu rahoꞌiëꞌiroho hejaje höjo viꞌehimavego huë vavaene baejaje höjo. Huë vavaene baeromo harihoho rahonugoromo uvaje höjo: Iae harihoho mabëhe baejëꞌe jevajëromo nimorohaje höjo. Nimorohego ëhuro hesi viꞌehoho rumonimaje höjo. ");
INSERT INTO aom_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Magonahehu huë vavaeni rumonimajëhi jemëꞌo huë vavaeni baejarujoho ëhi rumonimoꞌarujëjo. Avevejöꞌoho jemë nasi jöëni huë vavaene baejarujëjo. Huë vavaeni baejarujoho uꞌemu naro röhu maho ro gëꞌiramu nimorohoꞌarujëjo. Jemëhu nimorohoꞌirarijoho aho bogo ahëvo hesi höjo. ");
INSERT INTO aom_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Ëmajaho rueꞌiramu jemë bogo nasi öriroho ue geꞌaꞌarujëjo naro ajëmijöro. Röhu ave jöho na jö mae uëꞌiëꞌajëjo. Jemë rabe nëgamu Vavuoho nasi ihore ua gavëꞌoho hu iae ajëmiꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Urimoho nasi ihoroho bogo uabe rovarijoho röhu aevoromo nasi ihoro ua ganövorëjo. Ëhi jiëꞌoho jemë ua gaꞌirarijoho iae baeromo nimoroho avohoꞌarujëjo. ");
INSERT INTO aom_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Na uhuꞌe jöe gö gö jövoromo ëhuro nasi jöho majëhijajëjo. Röhu ijonö majaho rueꞌiramu evare uhuꞌoho bogo majëhiꞌi Vavu hesi jöho ma-samaꞌe majëhiꞌejöjo. ");
INSERT INTO aom_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Ëho majaho rueꞌiramu jemë Vavuoho nasi ihore ua ganövoꞌarujëjo huro ajëmiꞌiröhego. Ua gaꞌirarijoho na bogo uëvajëjo: Naro jemesi jöëni hu ua gaꞌejöjo ");
INSERT INTO aom_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","rabëni hesi bëhoho Vavuohuro iae hesi dë vövöbajoꞌe ahoꞌo jemë uehorovëvajëro jiëꞌëro. Ëhuni jemesi jöënioho na bogo ua gaꞌi jemesi ua ganövoꞌarujëjo. Vavuehu jemë uehorovëvaje hesi bëhoho jemëro na rajehiromo mae uehorovoromo uvaruje höjo: Nörö Vavu hesirire jioromo rovade höjo. ");
INSERT INTO aom_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Iae mae-ëjo. Iae na Vavu hesirire rovëꞌëro ave saꞌare hijajëjo. Hijajëro ave saꞌaho nugoꞌi Vavu hesi örire vuonoröꞌö vaꞌiëꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Vaꞌiëꞌajëjamu hesi ijorajoho jaburo uavareje: Asëꞌe avevejöꞌoho ja bogo uhuꞌoho jövoꞌi ma-samaꞌe jövanuëjo. ");
INSERT INTO aom_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Avevejöꞌoho no garomo uvaruëjo: Ja bövie biseꞌe ga barëjëꞌe javajëjo. Ja bogo ae gö uö gövuanue höjo: Jö rabe ue geꞌi nëgajëjo. Uö göꞌirane bëhoho bogohöjo jero mamiꞌe gövuëꞌëro. Ëhuni no mae uehorovoromo uvaruëjo: Ja God-arire jioromo rovane höjo. ");
INSERT INTO aom_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Rovane höjamu Iesuro uëvadeje: Na jemë jaruvoho mae uehorovarujëjo. ");
INSERT INTO aom_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Majae ijonöho majae ma-bunemu jioꞌiramu jemëro na remöꞌö barëromo jemesi osare osare huruomo vaꞌiramu sivue jevoꞌajëjo. Röhu na bogo sivuoho jevoꞌi Vavuoho naꞌo jiaje höjo. ");
INSERT INTO aom_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Ëjöho na majëhijajëjo ëhuro jemë heromo nasi ae gemuohuro jëvëꞌëro juhuonoho bogojëvoꞌi huë mae jëvoꞌiröhego. Saꞌare jiaje mu sisëro jiëꞌëro ëhuro saꞌare raromoromo huë vavaene baeꞌaꞌarujëjo. Ëhi höjo röhu naro mu sisëho ruahöꞌöjëꞌe jevaje ëhuni biririvorëjo. ");
INSERT INTO aom_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Iesuro hesi aribövioho ëhi uënugoromo öꞌidöre siorohoromo uavadeje: Apajo. Majaho rovëꞌe höjo. Na jasi Harihe jevaje nasi ihoho döro banigojiomehonego naro jasi ihohuꞌo döro banigojiomahoꞌiröjo. ");
INSERT INTO aom_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Jero jöho bojemijane höjo naro döro namiromo ae ahoꞌobëhe muebejëvoꞌirodego. Muebejëvoromo ëhuro jaehu bojemijane aribövioho naro darugoho bojëmego jaburo ma-ioroꞌioremu maro raromoꞌiröhego. ");
INSERT INTO aom_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Aehu ma-ioroꞌioremu maro raromarue hesi bëhoho ëho God ja gavarue höjo ja gemu maho javego. O jaehu remöꞌöjamu ave saꞌare rovode aho Iesu Keriso na gevarue höjo. Ma-ioroꞌioremu maro raromarue hesi bëhoho iae ëhi höjo. ");
INSERT INTO aom_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Naro ave saꞌare hiromo jaehu bojemane muoho vae barëromo ëhuro jasi ihoho döro banigojiomëꞌe jevajëjo. ");
INSERT INTO aom_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Röhu Apo avevejöꞌe na jaꞌo hijajoho jero nasi ihoho döro banigojiomehonëjo. Urimo saꞌa bövi biseꞌo bogo bamanevare evare naro jaꞌo hijamu nasi ihoho dö maro jiade höjo. Ëhi jiëꞌe ihe gemuoho bojemego na baeꞌiröjo. ");
INSERT INTO aom_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Ave saꞌa hesirohemu uehorovarue aribövioho God jero a ioroꞌioroho baejëvoromo nasi örire bojemamu baejëvode höjo. Baejëvoromo ja diehi jiëꞌe ae javajoho naro röjëhijode höjo. Jabumë jasinö jiaroho jero na bojemamu baejëvode höjo. Baejëvamu jabumë jasi jöho ejahëꞌe höjo. ");
INSERT INTO aom_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Ejahëꞌëro avevejöꞌoho jaburo garomo uvarue höjo: Jaehu bojemijane jöho muoho bövioho biseꞌoho jasi örire jioromo rovëꞌe höjo. ");
INSERT INTO aom_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Jabuhu ëhi uvarue hesi bëhoho jaehu röjehijane jöho naro jabesi örire röjëhijëꞌe jevajëjo. Röjëhijamu heromo baejare höjo. Baejëꞌëro garomo uvarue höjo: Iae mae-ëjo. Nörö jasi örire jioromo rovade höjo. Ëhi uvoromo mae uehorovoromo uvarue höjo: God jero nörö ave saꞌare nugöꞌöjane höjo. ");
INSERT INTO aom_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Na jabumëni ëninamijajëjo. Na bogo uavajëjo jero saꞌarohemu uehorovarue aribövioho ajëmiꞌi aꞌi jaehu bojemane aribövioho ajëmiꞌiranego jasinö jëvëꞌëro. ");
INSERT INTO aom_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Ae bövie biseꞌe naꞌo jiaruoho jasirohuꞌo jioruomajëjo. O ae bövie biseꞌe jaꞌo jiaruoho nasirohuꞌo jioruomajëjo. Nasi iho börömoho jabumëro ae ma-vaꞌorahoro röjëhijëꞌe höjo. ");
INSERT INTO aom_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Na jasirire öꞌiëꞌajëjo. Ave saꞌaroho bogo ëgoꞌoho hiꞌi aꞌi jabumë ave saꞌare ëhi raromonövoꞌaruëjo. Saꞌare raromo hesi jioruomëꞌe jiaje ëhuni Apo maemu javajoho jero jasi darugohuro avoho muebejëvonëjo. Ëdarugoho jero na bojemane höjo. Ëdarugo gemuohuro jabumë muebejëvego ëhuro jaꞌo naꞌo ma-gemu jiaruëhi jabuꞌo ëhi ma-gemu jioruomoröhe höjo. ");
INSERT INTO aom_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Naro jabuꞌo hijodevare jaehu bojemijane darugohuro ëhuro avoho muebejëvonövode höjo rireromëvojöëni. Muebejëvoromo nasi gurutore rëmamu aho sisëroho bogo vaꞌëꞌe höjo. Sisëro vaꞌiröhe ahuremu sisëro vaꞌëꞌe höjo jasi surire jö jiajëhi ëhi jioröhego. ");
INSERT INTO aom_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Aviavejöꞌe naro jasi örire öꞌiëꞌajëjo. Röhu naro ave saꞌare hiromo ave jöho jasi örire uavajëjo ëhuro naehu nimorohajëhi jabuꞌo ëhi nimoroho avohoꞌiröhego. ");
INSERT INTO aom_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Naro jasi jöho jabesi örire röjëhijamu baeruomëꞌe höjo. Baeruomamu saꞌarohemu uehorovarue ariböviohuro jabesi örire nue huodëgoruomëꞌe höjo. Rabëni hesi bëhoho naehu bogo saꞌarohemu uehorovajëhioho ëhioho nasi aribövioho jabuꞌo bogo saꞌarohemuoho uehorovaruego ëhuni nue huodëgëꞌe höjo. ");
INSERT INTO aom_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Röhu na bogo ëninamiromo uavajëjo: Sö vaꞌego ave saꞌaroho bogo raromoꞌirarëjo. Aꞌi naro uavajëjo: Avoho muebejëvego A Sisëho bogo baejëvoꞌirajo. ");
INSERT INTO aom_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Naehu saꞌarohemu bogo uehorovajëhioho ëhioho jabuꞌo saꞌarohemuoho bogo uehorovarue höjo. ");
INSERT INTO aom_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Jero jabumë baejëvego jö mahemu ejahoromo ëhuro jasi ariböviemu jioꞌamoꞌirajo. Jö mahemu uavaje ë hesi bëhoho aviëhi höjo. Jaehu jövanue jöho höjo. ");
INSERT INTO aom_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Jaehu na saꞌare remöꞌöjanëhi ëhi naro jabumë rëmöꞌöjëꞌe jevajëjo saꞌare ariböviohuꞌo raromoromo mue vaeröhego. ");
INSERT INTO aom_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Rëmöꞌöjëꞌëro jabesi jöëni uehorovoromo naro nasi arijoꞌarije jasi örire bojamirovajëjo naro jabumë ajëmijego ëhuro jabuꞌo jasi gemu jioruomoröhego. ");
INSERT INTO aom_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Naꞌo raromarue aribövi jabesi jöëni ëhi ëninamijajëjo. Bogo jabesi jöënioho gemu uehorovoꞌi uꞌemu nasi jö majëhijego heromo na mae uehorovevoꞌiröhe aribövi jabesi jöhuꞌo uehorovajëjo. ");
INSERT INTO aom_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Uehorovoromo ëninamijajëjo ëhuro jabumë ae ahoꞌobëhe ma-gemu jioröhego. Apajo. Na negajëjo jaehu naꞌo bimuvoꞌi naehu jaꞌo bimuvajëhi jaburo ëhi noꞌo gemuoro bimuvoröhego. Bimuvego saꞌarohemu uehorovarue ariböviohuro ëho garomo uvoruomoröhego: Iae mae-ëjo. God-ro nörö nugöꞌöjamu saꞌare rovade höjo. ");
INSERT INTO aom_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Jaehu nasi iho banigojiomoromo aji bojemijanëhi naro ëhi jiëꞌe ajoho bojëmëꞌe jevajëjo ëhuro jaꞌo naꞌo ma-gemu javuajëhi jabuꞌo ëhi ma-gemu jioruomoröhego. ");
INSERT INTO aom_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Naehu jabuꞌo bimuvoꞌi jaehu naꞌo bimuvanëhi ëhi jabuꞌo bimuvoromo ma-gemu jëvego saꞌarohemu uehorovarue ariböviohuro ëho garomo uvoruomoröhego: God-ro nörö nugöꞌöjamu rovade höjo. O God-hu nörö rajahijadëhi huro hesi ariböviohuꞌo ëhi rajëhijaje höjo. ");
INSERT INTO aom_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Apajo. Na negajëjo jaehu bojemijane ariböviohuro nasinö öꞌoromo naꞌo gemu mae raromoruomoröhego. Raromoromo nasi aji maho garuomoröhego. Ëajoho jero na bojemane höjo rabëni mami göꞌe saꞌa bövi biseꞌo bogo bamanevare evare jaehu na rajehinövanohuni. ");
INSERT INTO aom_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","O Apo ja mu maemu vaejanue ae javajëjo. Saꞌarohemu uehorovarue aribövioho ja bogo gavarue höjo. Aꞌi naro iae ja gavaje höjo. O ave nasi ariböviohuro iae garomo uvoruomaje höjo: Jero nörö nugöꞌöjamu rovade höjo. ");
INSERT INTO aom_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Ja diehi jiëꞌe ae javajoho naro nasi aribövioho röjëhijëꞌe jevajëjo. Iae na ëhi röjëhinövoꞌejöjo ëhuro jaehu na rajehijanuëhi jaburo ëhi göëro göho rajahirovego naro jabuꞌo gemu mae juvoꞌirodëro. ");
INSERT INTO aom_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Iesuro ëhi ëninaminugoromo hesi ijorajo ömoꞌömohuꞌo gemu mae vaꞌadeje. Vaꞌoromo Kidron dodure abueromo iojiomoromo aehu ijo bivare öri ariꞌere ë vaꞌo raromareje. ");
INSERT INTO aom_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Röhu Iesuni hiruëmade aho Judas ë öri ariꞌoho iae gavadeje mamiꞌe Iesuro hesi ijorajoho jabuꞌo ë ro hinövëꞌëro. ");
INSERT INTO aom_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Judas-ro ë öri ariꞌoho gavëꞌëro ae söjëvo ujuohoromo rovadeje. Muorovo aribövioho söromo God-are amo börömo atovarue aribövie priest masijohuꞌo Pharisee ömoꞌömohuꞌo jabuhu rëmöꞌöjamu rovaroho sö ujuohoromo rovamu bijo bunoꞌoho ujuohoromo iroho gae ujuohoromo rueruomadeje. ");
INSERT INTO aom_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Rovamu gëgorovo diehi jiëꞌe muehu hesi örire rueꞌiröhoho Iesu iae ga barëromo ro birohëvoromo uëvadeje: Jemë rahuo naharujëjo. ");
INSERT INTO aom_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Rahuo naharujëjamu uavareje: Iesu Nazareth rajoho naharuëjo. Naharuëjamu uëvadeje: Ëuvaruje aho iae na aviae jevajëjo. Röhu Iesuni hiruëmade aho Judas jabuꞌo gemu mae namijadeje. ");
INSERT INTO aom_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Jabuꞌo gemu mae namijamu gagorovo rueho jaburo hejare Iesuro uëvamu: Na jevajë uëvamu hegorovo dejonö vaꞌoromo saꞌare rireromareje. ");
INSERT INTO aom_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Ëhiꞌamu Iesuro röhu maho uëvadeje: Jemë rahuo naharujëjo. Naharujëjamu uavareje: Iesu Nazareth rajoho naharuëjo. ");
INSERT INTO aom_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Naharuëjamu uëvadeje: Na mamiꞌe uëvode höjo: Iae na aviae jevajëjo. Jemë na nahevogoro ave nasi aribövioho rëmöꞌöjego ma-vaꞌarëjo. ");
INSERT INTO aom_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Ëhi uëvade hesi bëhoho mamiꞌe Iesuro Vavuoho uavadeje: Jaehu bojemane aribövioho naro bogo ae gemu vaduꞌoho nugöꞌöjamu sisëroho vaꞌëꞌe höjo. Hu Vavu uavadëhi hesi aribövioho ëhi mae jioꞌamoröhego ëhuni guduamoꞌi rovare aribövioho uëvadeje: Nasi aribövioho rëmöꞌöjego vaꞌarëjo. ");
INSERT INTO aom_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Ëhi uëvamu Simon Peter-ro kaejöe gurihi bamëꞌëro jiëꞌëro jijöromo priest börömo hesi mu vaejaje a ihe Malchus anoromo övo manörire hiaꞌoho tariöꞌöjahadeje. ");
INSERT INTO aom_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Hiaꞌoho tariöꞌöjahamu Iesuro Peter uavadeje: Kaejöho sionoro baꞌamëjo. Naehu iꞌu baejöro Vavuehu uevajoho rabëni bogo baejörajo. ");
INSERT INTO aom_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Ëhiꞌamu gagorovo muorovo ariböviohuꞌo jabesi a börömohuꞌo Jew rajo atovarue ariböviohuꞌo ëho jaburo Iesu guduamoromo tövonugoromo ");
INSERT INTO aom_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","huꞌirae baeromo urimo Annas gaꞌi rovareje. Annas hu Caiaphas-are vaboro hesi vavue jiadeje. Ëvaduniroho Caiaphas hu priest böröme jiadeje. ");
INSERT INTO aom_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Caiaphas-ro urimëꞌi Jew rajo a masijoho uëvadeje: Ae gemuehu ae ahoꞌobëhe noni guomëꞌoho iae mae höjo. Ëhi jövade a hesi juroho Annas gaꞌirögoro Iesu huꞌirae bavaꞌareje. ");
INSERT INTO aom_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Huꞌirae bavaꞌamu Simon Peterꞌo ijoraje göꞌo jaburo niöꞌiro Iesu rihiromareje. Rihiromoromo priest börömo hesi amo rejo iromare ojore rovareje. Rueromo göhuro Iesuhu vaꞌajire ë vaꞌadeje priest börömoho ë aho mamiꞌe gavajego. Huro ë vaꞌi Peter-ro rejo ojore viëhi amonö namijadeje. ");
INSERT INTO aom_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Ojore viëhi amonö namijamu Iesuare ijorajo göho priest börömehu gavaje ahuro sionëro ojore rueromo ojo muebejaje magonahoho uanugoromo Peter ojore namijajoho osanö huꞌirae bavaꞌadeje. ");
INSERT INTO aom_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Bavaꞌamu ë ojo muebejaje magonahohuro Peter uavadeje: Na mae jaꞌo ë ia hesi ijoraje javajëjo. Ijoraje javajëjamu uavadeje: O na bogajo. ");
INSERT INTO aom_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Ëhi uanugoromo vaꞌoromo gëvade mu ariböviohuꞌo atovarue ariböviohuꞌo runonëgamu vëni muraege bihoꞌamëꞌëro bëhire riravoromo jurovoruomamu gëgorovo vaꞌoromo jabuꞌo gemu mae namiromo vënoho jurovadeje. ");
INSERT INTO aom_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Ëhiꞌamu priest böröme Annas-ro Iesu uavadeje: Jasi ijore ijore jijiharue aribövioho rahumë höjo. Ja diehi jiëꞌe jöho aho röjëhijanue höjo. Ëjöho majehijego hejöjo. ");
INSERT INTO aom_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Majehijego hejöjamu uavadeje: Na bogo gurihiromo jöho majëhiꞌi ma-vaꞌorahoro samaꞌe majëhinövode höjo ae ahoꞌobëhe heruomoröhego. God rajahijarue osare osare o God-are amo börömore ë röjëhibe juvonövode höjo Jew raje ahoꞌobëhe ë gagovaruëro jiëꞌëro. ");
INSERT INTO aom_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Ëhuꞌoho ja rabëni nasi öriroho ue gevanuëjo. Nasi jö heruomade aribövioho jabumë uë gënego majahiruomoꞌirajo. Naehu majëhijode jöho jabumë iae gavarue höjo. ");
INSERT INTO aom_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Ëhi jövamu hejëꞌi evare atovarue ae gemu Iesuare bëhire namijadohuro Iesu övo hitahiëro anoromo uavadeje: Hë ja rabëni priest börömoho ëhioho uavanuëjo. ");
INSERT INTO aom_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Uavanuëjamu hegorovo uavadeje: Naehu jö sisë majahamu hejanoho huruoho majahuego no ae ahoꞌobëhe hejarëjo. O naehu jö mae majahamu hejanoho röhu rabëni na aneganuëjo. ");
INSERT INTO aom_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Ëhi uavamu hegorovo Annas-ro Iesu tövare öꞌoho bogo jiovahëꞌe ëhuꞌo ëhi nugöꞌöjadeje vaꞌoromo priest böröme Caiaphas-are nunire namiröhego. ");
INSERT INTO aom_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Ëhiꞌamu Simon Peter-ro ëhi namiromo vënoho jurovadeje. Jurovamu gagorovo aëro uavareje: Na mae jaꞌo hesi ijoraje javajëjo. Ijoraje javajëjamu uëvadeje: O na bogajo. ");
INSERT INTO aom_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Ëhi uavamu priest börömo hesi mu vaejarue röhu ae gemu Peter-hu anoromo hiaꞌi tariöꞌöjahade ë a hesi agane gemuohuro Peter uavadeje: Iae na gavode höjo ijo bivare öri ariꞌere ja Iesuꞌo gemuore namijamu. Na mae-ëjo. ");
INSERT INTO aom_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Ëhi uavamu Peter-ro uavadeje: Bogajo. Bogajamu gavëꞌi evare kökörökoho uvadeje. ");
INSERT INTO aom_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Ëhiꞌamu Iesu Caiaphas-are nunire namijëꞌëro sisonuvamu aëro hu huꞌirae baeromo saꞌa muebejaje a börömo hesi osare rovareje. Rueromo röhu uvareje: Osare vaꞌëꞌoho no sisë baeromo God-hu Vörö Tugohade Söröho bogo avoho iꞌejarë uvoromo bogo osaroho vaꞌi ma-ojanore riravareje. ");
INSERT INTO aom_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Ojanore riravamu Pilate-ro hörö rueromo uëvadeje: Ave ia hesi sisëho rabe jiamu baeromo rovarije höjo. ");
INSERT INTO aom_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Baeromo rovarije höjamu uëvareje: Ëiaho bogo mu sisë vaejaje aho jioꞌibejajo no bogo barueromo jasi öriroho bojamiꞌibejarëjo. ");
INSERT INTO aom_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Bogo bojamiꞌibejarëjamu Pilate-ro uëvadeje: Jemëro jemesi bavaꞌoromo court vaeromo jemesi jögoroho atoromo hesi muoho mevo garëjo mae o sisë jiego. Ëhi uëvamu Jew rajo masijohuro uavareje: Iae ëhi höjo röhu aehu mu sisë vaejarohuni noehu uëvego vuovoröhe darugoho nosi öriroho bogohöjo. ");
INSERT INTO aom_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Uëvego vuovoröhe darugoho nosi öriroho bogohö uavare hesi bëhoho God-ro nimadeje Iesu korosire anego guomoröhe jöho Iesuhu mamiꞌe jövadëhi ëhi jioröhego. Ëhuni uavareje: Ëhi jiëꞌe darugoho bogojavuajëjo. ");
INSERT INTO aom_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Bogojavuajëjamu Pilate-ro hesi osa börömore vuonoröꞌö vaꞌadeje. Vaꞌoromo Iesuni uvoromo rovamu uavadeje: Na ja Jew rajo jabesi a börömoho javajëjo. ");
INSERT INTO aom_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Börömoho javajëjamu Iesuro uavadeje: Na jasi ëma uehorovoromo uevanuëjo. O na ae göëro nasi jöho uavëꞌëro uevanuëjo. ");
INSERT INTO aom_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Uevanuëjamu Pilate-ro uavadeje: Asëꞌe na bogo Jew rajehu jevajëjo. Jasi saꞌa rajohuꞌo jasi priest masijohuꞌo ëho jaburo baejavoromo ro nasi övore bojemare höjo. Ja diehiꞌamu baejavo rovare höjo. ");
INSERT INTO aom_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Rovare höjamu uavadeje: Ave saꞌare masije riravarue aribövi jabesi muoho gö jioꞌi naehu börömo namijaje muoho gö höjo. Nasi muoho saꞌare jiaje mue gemuoho jioꞌibejajo nasi mu ariböviohuro muorovoromo ahëvoꞌibejarëjo ëhuro Jew rajohuro bogo guduamevoröhego. Röhu bogo ëhioho höjo. Naehu börömo namijaje muoho bogo ave saꞌare vaejarue mue gemuoho höjo. ");
INSERT INTO aom_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Ëhi uavamu Pilate-ro uavadeje: Ëhi jiëꞌoho na ja böröme namiromo ae muebejëvanue ae javajëjo. Javajëjamu Iesuro uavadeje: Naehu börömo namijajoho jero jasi jövanuëjo. Röhu na saꞌare ruvebijamu rahevade hesi bëhoho jö mahuremu majëhiꞌirodëro ruvebijamu rahevade höjo. Ae rahu jö mahuremu nimaruoho nasi jöe ejeharue höjo. ");
INSERT INTO aom_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Ejeharue höjamu Pilate-ro uavadeje: Röhu jö ma hesi bëhoho diehi höjo. Jö ma hesi bëhoho diehi hö uaromo amonö röhu maho hörö vaꞌoromo Jew rajoho uëvadeje: Ave aehu iꞌu baeröhe hesi sisëho bogo birohëꞌe jevajëjo. ");
INSERT INTO aom_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Röhu ave sörö majaho rovego evare naro savoji ojoho jiovoromo jemëni ae gemu nugöꞌöjëhego hu mae vaꞌaje höjo jemesi muoho ëhi gemu jiobe rovëꞌego. Ëhi jiëꞌoho na jemë nëgajëjo naro Jew rajo jemesi börömoho jiovo nugöꞌöjëhego mae vaꞌojöro. ");
INSERT INTO aom_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Ëhi uëvamu hegorovo jöꞌe dadovoromo uvoruomadeje: Bogo ë iahajo. Aꞌi Barabbas-ajo. Ëhi uvoruomadeje. Jaburo Barabbas jiovahego vaꞌojöro nimareje röhu hu vajiohuꞌe ananoꞌe ae jiadeje. ");
INSERT INTO aom_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Iae Pilate-ro uëvamu muorovo ariböviohuro Iesu bavaꞌoromo hisuebijareje. ");
INSERT INTO aom_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Hisuebiromo a masijehu bosö didiꞌarue ëhi jiëꞌe bosöho Iesuare simanore didiꞌahareje. Röhu bogo inömo maho baeromo bosöho avohahoꞌi bibëꞌe ijo hisuoho ujuoho huoromo simanore baꞌamahareje. Baꞌamahoromo a masijehu kavuëꞌe niögu ëgo ioꞌamarue ëhi jiëꞌe niögoho baꞌamahoromo ");
INSERT INTO aom_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","ro sivoromo uaꞌi arijareje: Jew rajo a börömoho vaevëꞌe hijanuëjo. Ëhi uaromo övo hitahiëro anoꞌi arijareje. ");
INSERT INTO aom_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Ëhiꞌamu gagorovo Pilate-ro osare jioromo röhu maho hörö rueromo ë gagovare aribövioho uëvadeje: Jöe hehëjo. Naro ë iaho huꞌirae barueꞌiëꞌajëjo jemëro garomo uvoꞌirarijego: Iꞌu bojamiꞌirode bëhoho na bogo birohëꞌe jevajëjo. ");
INSERT INTO aom_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Ëhi uëvamu gavëꞌi Iesuro bibëꞌe bosöho simanore didiꞌëꞌe kavuëꞌe niögoho baꞌamëꞌe huꞌo höröjadeje. Höröjamu gagorovo Pilate-ro uëvadeje: Gahëjo. Ëiaho aviae höjo. ");
INSERT INTO aom_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Iesu ganugoromo priest masijohuro God-are osa atovarue ariböviohuro uvoruomadeje: Korosioro anego guomajo. Korosioro anego guomajo. Guomajamu Pilate-ro uëvadeje: Jemëro jemesi bavaꞌoromo korosioro anohego guomajo. Iꞌu bojamiꞌirode bëhoho na bogo birohëꞌe jevajëjo. ");
INSERT INTO aom_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Bogo birohëꞌe jevajëjamu rue Jew rajohuro uaruomadeje: Röhu jögoru börömoho nosi örire jiajëjo. Ëiahuro ë jöho ahoromo uövuade höjo: Na God-are Harihe jevajëjo. Ëjögoru ahadohuni ëhuni guomoꞌaꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Ëhi uavamu hegorovo Pilate-ro urimo juhuonivadoho ë jabesi jöho hegoro evare juhuonivo avohadeje. ");
INSERT INTO aom_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Juhuonivo avohoromo Iesu huꞌirae baeromo rue osa börömore vuonoröꞌö vaꞌoromo uavadeje: Ja dinöꞌe jioromo rovane höjo. Rovane höjamu Iesu bogo mana uaꞌi ma-jörumoraejadeje. ");
INSERT INTO aom_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Jörumoraejamu Pilate-ro uavadeje: Ja diehiꞌoromo jöho bogo mana majehijanuëjo. Aveho uehorovëjo. Na jiovo ramöꞌöꞌirode darugoho korosire ano taemavoꞌirode darugoho iae na jevajëjo. ");
INSERT INTO aom_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Jevajëjamu uavadeje: Iae ëhi höjo röhu God darugoho bogo bojamiꞌibejajo nasi örire mae o sisë vaeꞌirane darugoho bogojavoꞌibejajo. Aꞌi God-ro bojamijëꞌëro ëhuꞌëro iae eni javajëjo. Ëhi jiëꞌëro jasi övore bojamamu ja baejevane a hesi jö sisëhuro jasiriroho iosiramiromo bövi mae höjo. ");
INSERT INTO aom_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Ëhi uavamu hegorovo Pilate-ro öre nahadeje Iesu jiovo nugöꞌöꞌirovo. Jiovo nugöꞌöꞌi öre nahamu Jew rajohuro ma-darugoꞌo uvoruomadeje: Jaehu hu jiovo nugöꞌöjëꞌoho ëho ja bogo Rome a börömo nimanue aho javoꞌajëjo. Ae rahu uvëꞌoho: Na böröme namijaje ae jevajë uvëꞌoho ë iahuro Rome a börömo hesi muoho ahaje höjo. ");
INSERT INTO aom_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Ahaje höjamu hegoro Pilate-ro vaꞌo Iesu huꞌirae baeromo amonö ro hörönugoromo vaꞌadoho munëhu ahare öri ariꞌere Hebrew huëhu huotovëꞌoho Gabbatha ë vaꞌoromo jö mevarue arëto börömore hijadeje. ");
INSERT INTO aom_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Röhu God-hu Vörö Tugohade Sörö iröhe majaho nërëhi jioꞌi röhu evaroho majae ririre jioꞌiro ëꞌadeje. Evare majare Pilate-ro arëto börömore hiromo Jew rajoho uëvadeje: Jemesi a börömoho gahëjo. ");
INSERT INTO aom_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Gahëjamu hejëꞌi rue ariböviohuro ma-darugoꞌo uvoruomadeje: Anëjo. Anëjo. Korosioro anego guomajo. Pilate-ro uëvadeje: Na na jemesi börömoho korosiroho anoꞌejöjo. Anoꞌejöjamu priest masijohuro uaruomadeje: Rome a börömoho ëhemu nosi börömoho jiajëjo. Ae gö bogohöjo. ");
INSERT INTO aom_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Ae gö bogohöjamu Pilate-ro ë aribövioho ejëhoromo muorovo a jabesi övore Iesu bojëmadeje jaburo bavaꞌoromo korosire anego guomojöro. Bojëmamu Iesu baeruomadeje. ");
INSERT INTO aom_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Iesu baeruomamu huro korosioho banigojiomoromo dejore bamoromo baeromo vaꞌadoho ajio ëꞌo ihe Simano Gijo Vaꞌëne Ëꞌoho Hebrew huëhu huotovëꞌoho Golgotha ë ajio suorovareje. ");
INSERT INTO aom_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Suorovonugoromo ë diröꞌore korosire ano taemareje. Röhu ae niöꞌi jabuꞌo ano taemëvareje uꞌemu ujuoho nigemoꞌamoromo Iesu ririre amoꞌi a göho ruëhi amoꞌi göho viëhi amoꞌiröhëro. ");
INSERT INTO aom_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Ëhiꞌoꞌi röhu urimo Pilate-ro Iesuare jöho jajivoromo ae bojëmijadeje bavaꞌoromo Iesuare simano namore korosire ano taemego aëro garuomoröhego. Jöho jajivoromo ëhi uvëꞌe jiadeje: Iesu Nazareth raje Jew rajo jabesi a börömoho höjo. ");
INSERT INTO aom_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Ëjöho Jew raje ae ahoꞌobëhe adahoruomadeje Iesuhu korosire iromadoho amo börömo bëhiro jiëꞌëro. Ëjöho Hebrew jöëro Rome jöëro Greece jöëro jajivoꞌamëꞌe jiadeje. ");
INSERT INTO aom_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Jajivëꞌe jiamu gagorovo Jew rajo priest masijohuro vaꞌoromo Pilate uavareje: Nadi ëhioho jajivoromo uvoꞌibejanëjo: Jew rajo jabesi a börömoho höjo. Aꞌi jajivoromo uvonëjo: Ave iahuro hesi ëma uvade höjo: Na Jew rajo jabesi börömoho jevajëjo. ");
INSERT INTO aom_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Börömoho jevajëjamu Pilate-ro uëvadeje: Bogajo. Na jajivodoho hesi ëhi jiemu jioꞌaꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Ëhiꞌamu muorovo ariböviohuro Iesu korosire ano taemonugoromo hesi niögoho adovoromo muorovo ae ëhi niöꞌi ëhi niöꞌi jiëꞌëro gemu gemu ujuohareje. Röhu hesi niögu ëgobövioho ëhuꞌo baejareje. Baeromo gavareje bogo niögu göho göho gemuoroho bimuvoromo sigohijëꞌe jioꞌi ma-böröme gemu jiamu gagorovo ");
INSERT INTO aom_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","uarovareje: Ëꞌego no niögoho bogo arororomo gemu gemu baeꞌirögoro aꞌi ajajovoromo gavarëjo raro baejego. Jabuhu ëhi ëꞌare hesi bëhoho mamiꞌe God-are surire jajivoromo uvëꞌeje: Nasi uho givaꞌoho adovoromo ujuohare höjo. Nasi niögoho ajajovoromo ae gemuëro baejade höjo. Surire jajivadëhi ë muorovo ariböviohuro ëhi ëꞌareje. ");
INSERT INTO aom_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Ëhiꞌamu Iesuare vëmoho o vëmu hesi öho o Mary Clopas-are vaboroho o Mary Magdalene ëho jaburo korosi bëhire riravareje. ");
INSERT INTO aom_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Riravamu gagorovo Iesuro gavadeje aruëre hesi vëmohuꞌo hesi ijoraje huhu dë vövöbajoꞌe ahoꞌo rajahijajoho jabu niöꞌiro rirarovamu. Rirarovamu gëgorovo vëmoho uavadeje: Mamajo. Ave iahuro harihëro muebejavanovoꞌajë uaꞌi ");
INSERT INTO aom_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","ijorajoho uavadeje: Ave magonahoho vëmunöꞌe muebenëjo. Ëhi uavëꞌëro rue ahuro magonahoho huꞌirae bavaꞌamu hesi osare hijadeje. ");
INSERT INTO aom_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Ëhi ëꞌëꞌëro Iesuro garomo uvadeje: God-hu nimade muoho mamiꞌe barëjëꞌe höjo. Mamiꞌe barëjëꞌe höromo diehi ëꞌiröhego God-are surire jö jajivadëhi ëhi ëꞌi nimamu uvadeje: Na jove iꞌi negajëjo. ");
INSERT INTO aom_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Jove iꞌi negajëjamu ramaho roriae jiadeje. Niogaꞌiꞌe wine jovëro ë ramaho irijiomëꞌe jiadeje. Ëhi jiamu aëro uꞌuhëꞌe inömoho jovore baꞌamonugoromo rumorovamu ioromo ijaho viture bijiohonugoromo nigemoromo hirore bamahadeje. ");
INSERT INTO aom_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Bamahamu jovoho sunuohonugoromo uvadeje: Iae barëjajëjo. Ëhi uvoromo simanoho uruhoromo aruꞌahoho nugöꞌönugoromo guomadeje. ");
INSERT INTO aom_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Guomamu majaho Friday jiëꞌëro Jew rajohuro uvareje: Nëröho nuho majae sörö maja börömoho jioꞌiëꞌego ëhuni vuovëꞌe sinehu korosire nuho majare raeꞌamoꞌiröhoho no bijönaguajëromo iae vaꞌareje. Vaꞌoromo Pilate uavareje: Uëvego korosire raeꞌamaje aribövioho aëro vaꞌo höroho ahoꞌamëhego vuovëvoꞌirajo. Vuovëvego evare korosire jiajoho ujuoho ruvebiꞌirarëjo. ");
INSERT INTO aom_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Ruvebiꞌirarëjamu Pilate-ro ejëhamu muorovo ariböviohuro vaꞌoromo vaꞌo Iesuꞌo gemu mae ano taemare a gö hesi hörohuꞌo gö hesi hörohuꞌo ahëhoromo ");
INSERT INTO aom_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Iesuaro vaꞌoromo gavare mamiꞌe guomëꞌe jiamu gagorovo höroho bogo ahahareje. ");
INSERT INTO aom_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Bogo ahahoꞌirögoro muorovo ae gemuëro bijohuro Iesuare ionire bijiohamu gavëꞌi köꞌo jovoꞌo rovadeje. ");
INSERT INTO aom_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Köꞌo jovoꞌo rovamu gavade ahuro majahuijëꞌeje jemëro heromo mae uehorovoꞌirarijego. Hesi jöho bogo sareriꞌehu jioꞌi iae maeje. Huro mae garomo uvajeje: Naehu majëhijode jöho iae mae höjo. ");
INSERT INTO aom_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Röhu Iesuare höru bogo ahahare hesi bëhoho mamiꞌe diehi ëꞌiröhego God-are surire jö jajivadëhi ëhi jioröhego. Jöho jajivoromo ëhi uvëꞌeje: Hesi ijoꞌahe gemu vaduꞌoho bogo ahöꞌöjahoꞌaruëjo. ");
INSERT INTO aom_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","O Iesuare ionire bijiohade hesi bëhoho mamiꞌe God-are surire jö göho jajivoromo ëhi uvëꞌeje: Bijëro bijiohoromo ë aho nunëro garuomoꞌajëjo. Diehi ëꞌiröhego God-are surire jajivadëhi iae ëhi bijiohadeje. ");
INSERT INTO aom_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Ëhiꞌamu Joseph Arimathea amo rajohuro rovadeje. Joseph hu Iesuare ijore ijore juvaje ae jiadeje. Röhu Jew rajo a masijoho juhuonëmiromo bogo huruoho majëhiꞌi ma-saginiëri Iesu uehorovobe juvadeje. Ëahuro rueromo Pilate uavadeje: Uevego na vaꞌoromo Iesuare sinoho bavaꞌiröjo. Bavaꞌiröjamu Pilate-ro ejahamu Iesuare sinoho baeꞌi vaꞌadeje. ");
INSERT INTO aom_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Röhu Nicodemus-ro huꞌo gemu mae vaꞌadeje. Nicodemus hu urimëꞌi vahiꞌe Iesu gaꞌi rovade aho jiadeje. Huꞌo hesi ariböviohuꞌo ridiꞌe osoho ujuohoromo Josephꞌo vaꞌareje. Ëosoho ridiꞌe ije niöꞌi jabesi siva buaroharoho ë hesi iꞌuoho 40 kilo rabuꞌe ëhi jiadeje. ");
INSERT INTO aom_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Ëosoho ujuoho vaꞌoromo Iesuare sinoho baeromo Jew rajehu sino guavoꞌi ëꞌaruëhi Josephꞌo Nicodemusꞌo ëhi niögohuꞌo ridiꞌe osohuꞌo ujuohoromo ëhuro sinoho avohahoromo numareje. ");
INSERT INTO aom_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Röhu Iesu korosire anare ë hesi bëhoho mue jiadeje. Ëmure munë gage gemu bogo aho bamëꞌe ëma unoꞌe jiëꞌe jiadeje. ");
INSERT INTO aom_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Unoꞌe jiëꞌëro Iesuare sinoho numonugoromo uvareje: Nëröho Jew rajo nosi nuho majae jioꞌaꞌajëromo munë gagoho bëhiro jiëꞌëro ë dunemu bamareje. ");
INSERT INTO aom_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Iae hura börömoho bogo ajivëꞌe iꞌo ma-sisonuvoꞌiaꞌamu Mary Magdalene-ro Iesu bamarire vaꞌadeje. Vaꞌi gavadeje ojo tugohare munëho roriꞌo bavaꞌëꞌe jiamu. ");
INSERT INTO aom_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Bavaꞌëꞌe jiamu gavëꞌi ë magonahohuro tutuvoromo vaꞌadoho Simon Peterꞌo ijoraje Iesuhu dë vövöbajoꞌe ahoꞌo rajahinövade ë ahuꞌo uëvadeje: Badare sinoho munë gagoroho bavaꞌëꞌe höjo. Bavaꞌoromo dinöꞌe bamaroho no dadivavuajëjo. ");
INSERT INTO aom_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Dadivavuajëjamu gagorovo Peterꞌo Iesuare ijorajo göhuꞌo riꞌöromo Iesu bamarire vaꞌareje. ");
INSERT INTO aom_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Jaburo niöꞌiro tutuvo vaꞌoromo ijorajo göhuro Peter iosiramiromo munë bëhire urimo rovadeje. ");
INSERT INTO aom_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Urimo rueromo hohitohoromo sino numoꞌamare niögoho gaꞌamadeje. Gaꞌi munë gagoroho bogo rumo vaꞌadeje. ");
INSERT INTO aom_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Bogo rumo vaꞌamu Simon Peter-ro ijore rovadoho ro munë gagore vaꞌadeje. Vaꞌoromo gavadeje sino numoꞌamare niögoho momoröꞌöꞌi ");
INSERT INTO aom_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Iesuare simano numare niögoho hesi hahagu huhohëꞌe raromamu. ");
INSERT INTO aom_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Ëhi gavamu gavëꞌi urimo rovade Iesuare ijorajo göhuro huꞌo rumo vaꞌoromo nunëro garomo mae uehorovadeje. ");
INSERT INTO aom_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Jaburo niöꞌiro Iesuhu guomoromo riꞌöꞌiröhe God-are surire jajivare jöho bogo uehorovareje. ");
INSERT INTO aom_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Bogo uehorovëꞌëro Iesuare ijoraje niöꞌiro sionëro jabesirëro vaꞌareje. ");
INSERT INTO aom_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Iesuare ijoraje niöꞌiro vaꞌirögoro Mary-ro sino bamare ojo bëhire namiromo nivadeje. Nivoromo hohitohoromo sino bamarire uherihadeje. ");
INSERT INTO aom_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Uherihoꞌi gavadeje anerae niöꞌi ajivëꞌe niögoho ioꞌamëꞌe Iesuare sino bamare sionore göho simano bamarinö hiꞌi göho höru bamarinö hijamu. ");
INSERT INTO aom_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Ëhi gëvamu gagorovo rue aneraho jaburo uavareje: Maꞌinoho ja rabëni nivanuëjo. Ja rabëni nivanuëjamu rue magonahohuro uëvadeje: Aëro nasi Badare sinoho bavaꞌëꞌe höjo. Bavaꞌoromo dinöꞌe bamaroho na bogo gagoro ëhuni nivajëjo. ");
INSERT INTO aom_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Ëhuni nivajëromo huotorovoꞌi gavade Iesu namijamu gagorovo uvadeje: Nani hesi ae gö höjo. ");
INSERT INTO aom_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Hesi ae gö höjamu Iesuro uavadeje: Maꞌinoho ja rabëni nivanuëjo. Ja rahuo nahanuëjo. Ja rahuo nahanuëjamu magonahohuro uvadeje: Nani ave mu muebejaje aho höromo uavadeje: Jero sinoho bavaꞌëꞌe javego röjehego na vaꞌo baejöjo. ");
INSERT INTO aom_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Baejöjamu ruehuro uavadeje: Mary-ajo. Mary-ajamu magonahohuro huotorovoromo Hebrew jöëro uavadeje: Raboniajo. Rabonia uavade hesi bëhoho uaromo ëꞌadeje: Tisajo. ");
INSERT INTO aom_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Rabonia uavamu uavadeje: Nasi Vavu hesi öriroho bogo ajiomëꞌe jevaje maꞌeneganuoho vuonugëjo. Vuonugoꞌi vaꞌoromo nasi ö ömoꞌömoho uënëjo: Nörö God-are örire ajiomoꞌiëꞌajëjo. God hu nöruare Vavue jioromo jemesi Vavue höjo. Hu nöruare God jioromo jemesi God höjo. ");
INSERT INTO aom_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Ëhi uavamu Mary Magdalene-ro vaꞌoromo Iesuare ijorajo ömoꞌömoho uëvadeje: Na Bada gavëꞌe jevajëjo. Gavamu huro jöho ëhi ëhi majehade höjo. ");
INSERT INTO aom_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Evare majare hura börömore vahiromamu Iesuare ijorajo ömoꞌömohuro Jew rajo a masijoho juhuonëmiromo osare gagovoromo ojoho tugoho titimëꞌëro ë raromareje. Raromamu gavëꞌi Iesuro jabesi ririre ëma ro namiromo uëvadeje: Huë mae raromohëjo. ");
INSERT INTO aom_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Huë mae raromohëꞌi hesi övohuꞌo ionohuꞌo röjëhijadeje. Röjëhijamu gagorovo uvareje: Iae Bada hö uvoromo nimorohareje. ");
INSERT INTO aom_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Nimorohamu röhu maho uëvadeje: Huë mae raromohëjo. Nasi Vavuehu na remöꞌöjamu saꞌare rovodëhi ëhi naro jemë rëmöꞌöjajëjo jemëro vaꞌoromo nasi muoho vaebe jijihoꞌirarijego. ");
INSERT INTO aom_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Ëhi uënugoromo nu öge ahodëgoromo uëvadeje: God-are Aruꞌahoho baerëjo. ");
INSERT INTO aom_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Jemëhu ae rahuare örire uavëꞌoho: God-ro jasi sisëho uehorovoromo vuonugajë uavëꞌoho God-ro ë a hesi sisëho uehorovoromo ma-ioroꞌioremu vuonugoꞌajëjo. O jemëhu ae rahuare örire uavëꞌoho: God-ro jasi sisëho majae ëhi uehorovaje hö uavëꞌoho God-ro ë a hesi sisëho majae ëhi uehorovoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Ëhiꞌamu ijoraje ae gemu bogojiëꞌëro Iesu rovajoho bogo gavadeje. Ëijorajo hesi ihoho Thomas aehu uvaruoho Huodiꞌe Rahade Ahoje. ");
INSERT INTO aom_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Thomas Iesu bogo gavëꞌego Iesuare ijorajo ioroꞌiorohuro Thomas uavareje: No Bada gavëꞌe javuajëjo. Bada gavëꞌe javuajëjamu uëvadeje: Hesi övore vioꞌuehu ano taemoꞌamare sionoho naehu bogo garomo nasi övo namehu bogo rëhëꞌoho o hesi ioniꞌahore bijehu bijiohadire nasi övo bogo nugöꞌöjëꞌoho ëhuro bogo ma uehorovoromo bogo uvoꞌejöjo: Iesu riꞌöjëꞌe höjo. ");
INSERT INTO aom_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Röhu urimo Iesuhu jabesi nunire rovadoho hurae gemu barëjamu hesi ijorajoho jaburo röhu maho osare raromareje. Raromamu Thomas-ro jabuꞌo hijadeje. Ojoho tugoho titimoromo osare raromamu gavëꞌi Iesuro jabesi ririre ëma ro namiromo uëvadeje: Huë mae raromohëjo. ");
INSERT INTO aom_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Ëhi uënugoromo Thomas uavadeje: Jasi övo namoho barueromo ave nasi övoho gavehëjo. Jasi övoho barueromo nasi ioniꞌahoro nugöꞌö gavëjo. Ëhiꞌoromo naehu riꞌöjode jöho mae o sarere hö uvanuoho vuonugoꞌi ma-avoho uehorovonëjo. ");
INSERT INTO aom_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Avoho uehorovonëjamu Thomas-ro uavadeje: Nasi Bada nasi God ja javajëjo. ");
INSERT INTO aom_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Nasi God ja javajëjamu Iesuro uavadeje: Jero na gevëꞌëro ëhuꞌëro mae uehorovanuëjo. Röhu bogo gevëꞌe ëma mae uehorovëꞌoho ëhi jiëꞌe aribövioho huë mae baeꞌaꞌaruëjo. ");
INSERT INTO aom_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Iae Iesuhu bëhiꞌe mu masije ahoꞌo hesi ijore ijore jijiharue aribövi jabesi nunire vaeꞌamadoho ave suriroho ë jöho bogo jajivoꞌamëꞌeje. ");
INSERT INTO aom_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Ëhi jie röhu naehu ave jö jajivobe rovode hesi bëhoho jemëro adahoromo uvoꞌirarijego: Iae mae-ëjo. Iesu hu böröme namiromo ajamuaje aho höjo. Hu God-are Harihe höjo. Ëjöho uehorovoromo hesi darugoho baeromo ëhuro iꞌovoromo maro raromoꞌirarijego ëhuni jajivëꞌe jeve. ");
INSERT INTO aom_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Ëhiꞌamu ijonö röhu maho Iesuro hesi ijorajo jabesi nunire rovadeje. Evare majaroho Tiberias eꞌu riröre ë rovadeje. Rueromo huhu ëꞌade jöho na jajivoꞌiëꞌe. ");
INSERT INTO aom_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Iae Simon Peter o Thomas aehu uvaruoho Huodiꞌe Rahade Aho o Nathanael Galilee saꞌa raje Cana amo rajoho o Zebedee-are harihe niöꞌi o ijoraje göꞌo niöꞌi ëho jaburo gemuore gagovoromo raromareje. ");
INSERT INTO aom_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Raromoromo Simon Peter-ro riꞌöromo a ioroꞌioroho uëvadeje: Na visu maje vaꞌiëꞌajëjo. Vaꞌiëꞌajëjamu jaburo uavareje: Noꞌo öꞌiëꞌaruëjo. Öꞌiëꞌaruëromo vaꞌoromo boat gagore ajiomoromo jovo döre vaꞌoromo vahi bövie visuëni viöe jovore baꞌamoromo io gabe jijihoromo visuoho bogo birohëꞌe gavareje sisonuvamu. ");
INSERT INTO aom_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Sisonuvamu gavëꞌi gavare arue Iesu jovo riröre namijamu gagorovo jaburo hu garomo uvareje: Nani hesi ae gö höjo. ");
INSERT INTO aom_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Hesi ae gö höjamu Iesuro jabumë gëromo uvëvadeje: Aganomë na jemë visuoho suovëꞌe jëvajëjo. Suovëꞌe jëvajëjamu rueho jaburo uvareje: Visuoho no bogo suovëꞌe javuajëjo. ");
INSERT INTO aom_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Bogo suovëꞌe javuajëjamu uvëvadeje: Boat-re viöho ioromo övo manö baꞌamohëjo visue suovoꞌirarije. Ëhi uëvamu viöho baꞌamoromo gavareje visue ahoꞌobëhe ro abuejëꞌëro viö barojomoꞌiröhoho bogo eni jëvamu. ");
INSERT INTO aom_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Bogo eni jëvamu gagorovo Iesuhu dë vövöbajoꞌe ahoꞌo rajahijaje ijorajohuro Peter uavadeje: Iae Bada höjo. Bada höjamu hegorovo Peter-ro döre baꞌamaje niögoho mamiꞌe jijövëꞌëro röhu maho baꞌamoromo avoho ruohoromo jovore jöröꞌöromo Iesu birohoꞌi vaꞌadeje. ");
INSERT INTO aom_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Peter-ro jovore jöröꞌöromo vaꞌirögoro ijorajo ioroꞌiorohuro boat gagore raromoromo viöre visuoho ioninö jagu baeromo rovareje jovo riröho bogo ëgoho jioꞌi ma-90 metre rabuꞌe ëhi jiëꞌëro. ");
INSERT INTO aom_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Rueromo saꞌare ravoꞌamoromo gavareje vëni muraege bihoꞌamëꞌëro visuoho ë mueꞌi ioho ë bëhire momoröꞌöjamu. ");
INSERT INTO aom_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Ëhiꞌamu Iesuro uëvadeje: Avevejöꞌe suovarije visuoho gö ujuoho ruehëjo. ");
INSERT INTO aom_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Ujuoho ruehëjamu Simon Peter-ro vaꞌoromo boat-re ajiomoromo viöho saꞌare jagu barovadeje. Röhu viöre visu masijoho ahoꞌobëhe 153 jiëꞌëro ëhuro irijiomëꞌe jiadeje. Visuoho ahoꞌobëhe jiadeje röhu viöho bogo dadorovadeje. ");
INSERT INTO aom_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Viöho barovamu Iesuro uëvadeje: Ro ie ihëjo. Ro ie ihëjamu rue ijorajoho jabu bogo biririvoromo uavareje: Ja rahuo javajëjo. Jabumë iae garomo uvareje: Iae hu Bada höjo. ");
INSERT INTO aom_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Ëhiꞌamu Iesuro rueromo ioho ujuoho iꞌimëmiromo visuohuꞌo ëhi gemuoho ëꞌadeje. ");
INSERT INTO aom_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Urimëꞌi Iesuro guomoromo riꞌönugoromo urimo vae niöꞌi hesi ijorajo jabesi nunire rovadoho evare majare röhu maho jabesi nunire rueromo iohuꞌo visuohuꞌo ëhi suvuorëmijadeje. ");
INSERT INTO aom_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Suvuorëmiromo ueꞌahamu gagorovo Iesuro Simon Peter uavadeje: Simon John-are harihoho na jero ave aribövioho iosirëmiromo na rajehi avohanue höjo. Ëhi uavamu Peter-ro uavadeje: Bada ioꞌajo. Jero na gevanue höjo naro ja rajahijego. Ëhi uavamu uavadeje: Ëhi jiëꞌoho jero nasi sheep harihoho mioꞌamego jabesi aruꞌahoho daꞌuomoꞌamoꞌirajo. ");
INSERT INTO aom_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Daꞌuomoꞌamoꞌira uanugoromo röhu maho uavadeje: Simon John-are harihoho na jero na rajehijanue höjo. Rajehijanue höjamu Peter-ro uavadeje: Bada ioꞌajo. Jero na gevanue höjo naro ja rajahijego. Ëhi uavamu Iesuro uavadeje: Ëhi jiëꞌoho jero nasi sheep-oho muebejehonövonëjo. ");
INSERT INTO aom_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Muebejehonë uaromo urimo vae niöꞌi uavadoho röhu maho uavadeje: Simon John-are harihoho na jero na rajehijanue höjo. Vae niöꞌi gemu ë jöe gemuoho ëhi uaꞌi hijamu hegorovo Peter vavaenimadeje. Vavaenimoromo uavadeje: Bada jero bövioho biseꞌoho gavanue höjo. Jero na gevanue höjo naro ja rajahijego. Ëhi uavamu Iesuro uavadeje: Ëhi jiëꞌoho jero nasi sheep-oho mioꞌamego jabesi aruꞌahoho daꞌuomoꞌamoꞌirajo. ");
INSERT INTO aom_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Ave jöho na jö mae uaꞌiëꞌajëjo. Urimo ja a iꞌo javadevare evare jasi arijoꞌëro niögoho ruoho titimoromo dinöꞌe juvoꞌi nagadire ëma juvonövane höjo. Röhu ijonö ja mavojiraeꞌirane majare evare jero jasi öve niöꞌi ahorire vaeꞌiramu ae göëro jasi övoho muoho titimëvoromo ja ë diröꞌore vaꞌëꞌoho bijönagajire ë baejavo vaꞌaꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Ëhi uavade hesi bëhoho hu Peter röjahiromo ëꞌadeje huro heromo uvoröhego: Aëro ëhi ëhiꞌoromo na anegoꞌiramu guomevoꞌajëjo. Guomevoꞌiramu ëhuro God-are ihoho döro jioꞌaꞌajëjo. Amo Iesuro ë jöho uanugoromo Peter uavadeje: Nasi ijoro ijoro juvonövonëjo. ");
INSERT INTO aom_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Juvonövonëjamu Peter-ro huotorovoꞌi gavade Iesuhu dë vövöbajoꞌe ahoꞌo rajahijaje ijorajoho ijore rovamu. Urimëꞌi ë ahuro Iesuare bëhire ie iromo vaꞌo hiaꞌiro saginiëri uavadeje: Bada ja bijönagarue a jabesi övore bojamiꞌiröhe aho rahuo höjo. Ëhi ua gavade ae gemuohuro rovamu Peter-ro huotorovoromo gavadeje. ");
INSERT INTO aom_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Garomo uavadeje: Bada ave iaho diehi jioꞌaꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Diehi jioꞌaꞌajëjamu Iesuro uavadeje: Hesi jöho ëho bogo jasi muehu höjo. Na negëꞌohuro hu biririvoromo ëhi hiemu hiꞌiramu na vuonoröꞌö rueꞌejöjo ëho bogo jasi muoho höjo. Jero nasi ijoro juvonövonëjo. ");
INSERT INTO aom_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Ëhi jövëꞌëro Iesuhu Peter ëhi majahijade jöho Iesuare aribövioho jaburo jabesi ëma vaerovemu vaerovoromo uvoruomadeje: Ëjö hesi bëhoho ë iaho bogo guomoꞌi ma-hiemu hiꞌiröhe jöho höjo. Ëhi uvoruomadeje röhu Iesuro Peter bogo uavadeje: Iaho bogo guomoꞌaꞌajë uaꞌi aꞌi uavadeje: Na negëꞌohuro hu biririvoromo ëhi hiemu hiꞌiramu na vuonoröꞌö rueꞌejöjo ëho bogo jasi muoho höjo. Iesuro dë vövöbajoꞌe ahoꞌo rajahijaje ijorajo hesi jöho ëhi jövadeje. ");
INSERT INTO aom_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Röhu ë adaharije mu hesi jöho ë ijoraje gemuohuro garomo hejëꞌëro no majahuijajeje. Röhu ë jöho huro surire jajivëꞌeje. Noro garomo uvarueje: Hu iae jö mae majahuijaje höjo. ");
INSERT INTO aom_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Röhu ë mu jö jajivadoho Iesu bogo ë muohemuoho vaeꞌi mue ahoꞌobëhe vaeꞌamadeje. Röhu na uehorovoromo uve: Iesuhu vaejade muoho ahoꞌobëhe aëro mue gemu gemu surire jajivoꞌamo vaꞌo barëꞌibejajo suri bahiꞌiröhe röhoho saꞌae dinöꞌe dinöꞌe jioꞌamajoho nani bogo eni jioꞌibejajo. Ahia minoꞌe. ");
INSERT INTO aom_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","2","O asëꞌe Theophilus ave jöho naro jajivoꞌiëꞌe. Urimëꞌi Iesuhu mue rabe rabe vaejade jöho naro jajivo barëjamu ja adahaneje. Huro muoho aevoꞌi vaenugoromo mue vaebe jöe röjëhibe ëhiꞌobe ruejuvo God-ro uavamu öꞌidöre ajiomadeje. Urimore jöho na ëhi jajivodeje. Röhu Iesuro öꞌidöre ajiomoꞌirögoro God-are Aruꞌaho hesi darugohuro jögoroho apostle ömoꞌömoho bojëmijadeje jabumë mamiꞌe hesi baejëvëꞌëro. ");
INSERT INTO aom_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Guomoromo riꞌöjëꞌëro majae ahoꞌobëhe 40 hesi uhure jabesi nunire rueromo hesi arijoꞌarije röjahirovoꞌi hinövadeje. Röjahirovamu jaburo garomo uvareje: Iae hijajëjo. Huro jabesi nunire rueromo God-hu böröme namiromo muebejavuaje ë hesi jöho majëhiꞌego henövareje. ");
INSERT INTO aom_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Hejamu huro jabuꞌo hiromo uëvadeje: Naro mamiꞌe uëvode höjo: Vavuohuro suvuoroho mëmiꞌajëjo. Ëhuni Jerusalem vaꞌirarijoho nadi nugo vaꞌi ë amoremu raromoromo ë suvuoroho mueberëjo. ");
INSERT INTO aom_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Suvuoro hesi bëhoho ëhi höjo. Urimëꞌi John jovëro bapataeto vaejëvade höjo. Bogo majae ëgoho baebe vaꞌëꞌiro God-ro hesi Aruꞌahoho mëmiromo ëhuro jovoho bogo aꞌi Aruꞌahohuro bapataeto vaejëvoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Ëhiꞌamu iae apostle ömoꞌömohuro Iesuꞌo gemuore jioruomëꞌëro uavareje: Bada na ja avevejöꞌe ajamuiꞌiramu Israel rajoho nomëro urimo ëꞌarëhi ëhi masije riravoromo saꞌa ioroꞌioroho muebejëvoꞌejarëjo o bogajo. ");
INSERT INTO aom_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","O bogajamu uëvadeje: Ëhi jiëꞌe muoho bövioho biseꞌoho divare majare jioꞌamoröhoho hesi Vavuohuro bamëꞌëro ëhuꞌëro bogo gaꞌaꞌarujëjo. ");
INSERT INTO aom_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Iae ëhi höjo röhu God-are Aruꞌahohuro jemesirire ruvebiꞌiramu darugoho baeꞌaꞌarujëjo. Baenugoromo naehu diehi diehi ëꞌamu gavarije jöho ë jöho Jerusalem amore majëhibe Judea saꞌae bövioho majëhibe Samaria saꞌae bövioho majëhibe saꞌae gö gö majëhibe jijiho barëꞌarujëjo. ");
INSERT INTO aom_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Ëhi uëvamu hegoro gavareje hu öꞌidöre ajiomamu God-ro uavëꞌëro. Ajiomamu suëro riogivëꞌëro hu bogo gavareje. ");
INSERT INTO aom_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Röhu ajiomamu bogo gavëꞌe öꞌidöho ëma ërimahamu gavëꞌi ae niöꞌi ajivëꞌe niögu ioꞌamëꞌoho jaburo ma-majioho rueromo bëhire rirarovareje. ");
INSERT INTO aom_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Rirarovoromo uëvareje: Asëꞌe Galilee rajomë jemë rabëni riravoromo öꞌidöho ërimaharujëjo. Ëaho Iesu jemesirire jioromo öꞌidöre ajiomëꞌëro sionëro ruvebiꞌajëjo. Sue uhure ajiomamu gavarijëhi ëhi rueꞌaꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Ëhi majëhijamu hegorovo apostle ömoꞌömohuro Olives Dahorure jioromo öri dunonö 1 kilometre rabuꞌe vuonoröꞌö vaꞌoromo abo Jerusalem vaꞌo suorovareje. ");
INSERT INTO aom_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Suorovonugoromo vaꞌoromo urimo raromonövare döre osa gagore ë iojiomareje. Ëapostle jabesi ihoho Peter John James Andrew Philip Thomas Bartholomew Matthew o Alphaeus-are harihe James o Simon. Röhu Simon hu Jew rajehu jabesi mueberovoꞌi nimade aho jiadeje. O apostle gö James-are harihe Judas jiadeje. Apostle jabesi ihoho ëhi jioꞌamadeje. ");
INSERT INTO aom_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Ëaribövioho ahoꞌobëhe ë iojiomoromo Iesuare ö ömoꞌömoho hesi vëme Mary magonaho ioroꞌioroho ë ariböviohuꞌo gemu mae raromoromo God-are örire jöe atoꞌi arinövareje. ");
INSERT INTO aom_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Ëhiꞌoromo majae veminoꞌe barëjamu evare Iesu mae uehorovarue aribövioho 120 rabuꞌe ëho jaburo gemuore gagovorovëꞌëro Peter-ro riꞌöromo uëvadeje: ");
INSERT INTO aom_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","Ö muenoꞌohumë Judas-hu ëꞌade jöho God-are surire jajivarëhi öre gö bogojiëꞌëro iae ëhi jiade höjo. Urimëꞌi God-are Aruꞌahohuro David uavamu Judas-hu majae ijonö vaeröhe jöho jajivade höjo. Judas hu aehu Iesu guduamojöro öri röjëhijade ae jiade höjo. ");
INSERT INTO aom_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Hu noꞌo gemu mae hi juvonövade höjo. Huro noꞌo bimuvoromo mue gemu vaeröhego ëhuni Iesuro hu baejade höjo. ");
INSERT INTO aom_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Peter-ro ëhi jövadeje röhu hesi jö bëhoho Judas-hu mu sisë vaeromo ujuohade ë ijo bajohuro ëhuro saꞌaho imadeje. Imoromo ë saꞌare beruvebiromo dëho tögömamu dë hötöre suoro suoro baeromo guomadeje. ");
INSERT INTO aom_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Guomamu ë jöho Jerusalem raje ae ahoꞌobëhe jaburo henugoromo ë saꞌaho jabesi jöëro Akeldama jumuvareje. Akeldama huotovëꞌe hesi bëhoho Kö Rovëꞌe Saꞌahoje. ");
INSERT INTO aom_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Amo Peter-ro Judas-are jö vituoho majëhiromo uëvadeje: David-ro Judas-are jöho Psalms surire jajivoromo uvëꞌe höjo: Hesi amoho a rumoꞌe jioröhe höjo. Nadi a göho ëho hiꞌirajo. O jö göho uvëꞌe höjo: Ae göëro hesi sionoho baeromo mue baeꞌaꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","Ëhi uvëꞌego na negajëjo ae gemuëro Judas-are sionoho baeromo noꞌo gemu mae juvoromo Bada Iesu riꞌöjëꞌëro hijamu nunehu gavade jöho ae majëhinövoröhego. Na negajëjo Iesuhu noꞌo hibe juvoꞌego John-hu bapataeto mu vaejamu aevoꞌi noꞌo hibe ruejuvo Iesu öꞌidöre ajiomamu ëhi hiemu hibe rovade ëhi jiëꞌe ae jioꞌiröhego. ");
INSERT INTO aom_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Peter-ro ëhi uëvamu hegorovo rueho jaburo ae niöꞌi jabesi ihoho uvareje Judas-are sionoho baeröhego. A gö hesi ihoho Joseph jiadeje. Ëa hesi iho göho Barsabbas jioꞌi iho göho Justus jiadeje. Hesi ihoho niöꞌi gemu jiadeje. O a gö hesi ihoho Matthias jiadeje. ");
INSERT INTO aom_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Ëae niöꞌi jabesi ihoho uvonugoromo God-are örire ëninamiromo uavareje: Bada ae ahoꞌobëhe nosi dë vövöbajoꞌoho jero gövuanue höjo. Ëhuni ae niöꞌi röhu di aho gemu nimanuoho jero röjahuijego no baeꞌirarëjo ");
INSERT INTO aom_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","ëhuro hu Judas-are sionoho baeromo apostle muoho vaeꞌiröhe höjo. Ëhesi bëhoho urimëꞌi Judas apostle jiëꞌëro röhu muoho vuonugoꞌi guomoromo hesi röho sisëre vaꞌade höjo. ");
INSERT INTO aom_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","God ëhi uanugoromo munë inine ömëvonugoromo ë ae niöꞌi jabesi ihoho ë munë jabesi döre jajivoromo hevö gagore baꞌamoromo hijiohijiovareje gaꞌiro di aho baeꞌiröhoho jiego. Hijiohijiovoromo gavareje baeꞌiröhe aho Matthias jiamu gagorovo uavareje huro Iesuare apostle 11-ho jabuꞌo gemuore juvonövoröhego. ");
INSERT INTO aom_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Ëhiꞌamu Pentecost majaho rovamu Keriso mae uehorovarue ariböviohuro ahoꞌobëhe osae gemuore raromoruomadeje. ");
INSERT INTO aom_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Raromoromo ma-majioho hejareje buru börömonöꞌe öꞌidöre jioromo ruvebiromo jabuhu raromarue osaho ahoꞌo huosihuosihavamu. ");
INSERT INTO aom_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Huosihavamu hejëꞌi gavareje vëni hödu vaꞌëne bitaroho rumorovoromo ae gemu gemu jabesi simano döre jiorovamu. ");
INSERT INTO aom_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Jiorovamu gagorovo God-are Aruꞌahohuro ae ahoꞌobëhe jabesi dë vövöbajoꞌere abueromo rarovadeje. Rarovoromo bitaroho ajëmijamu aevoromo huë göëro göëro jöe vaerovobe vaꞌareje. ");
INSERT INTO aom_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Röhu Jew rajo ae göëro göëro Jerusalem amore ë raromoruomadeje God mae uehorovaruëro jiëꞌëro saꞌae göre göre jioromo rueruomëꞌëro. ");
INSERT INTO aom_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Jerusalem raromoromo hejare Iesuare ariböviohuro atavavamu hegorovo ae ahoꞌobëhe gemuore rueromo gagovoruomadeje. Gagovoromo ae gemu gemu hejare jaburo jabesi huë göëro göëro vaerovavamu hegorovo hire göröꞌöjëvadeje. ");
INSERT INTO aom_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Hire göröꞌöjëvamu riꞌöromo uvoruomadeje: Jabumë bogo nosi saꞌae gemuoho jioꞌi Galilee rajemu jioruomajëjo. ");
INSERT INTO aom_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Ëhi jiëꞌoho diehiꞌoromo nosi huë göëro göëro atoꞌego no hejaruëjo. ");
INSERT INTO aom_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","No Parthia saꞌa raje javuajëjo. Media raje Elam raje Mesopotamia raje Judea raje Cappadocia raje Pontus raje Asia raje ");
INSERT INTO aom_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Phrygia raje Pamphylia raje Egypt raje javuajëjo. Cyrene amo bëhire Libya saꞌa raje javuajëjo. Rome amo raje javuajëjo. ");
INSERT INTO aom_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Rome amo rajo a ioroꞌioroho Jew rajo ae javuajëjo. A ioroꞌioroho bogo Jew aehu javuoꞌi röhu Jew rajo jabesi muoho noro ijonö baejëꞌe javuajëjo. Crete saꞌa raje javuajëjo. Arabia saꞌa raje javuajëjo. No saꞌae gö gö ëhi javuajëjo. Röhu no ae ahoꞌobëhe hebe rovaruëjo God-hu mu masije gö gö ëꞌade jöho ë aribövioho jaburo ae gemu gemu nosi jöëro atavavoꞌego. ");
INSERT INTO aom_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Ëhi uvoromo ae ahoꞌo tiöromo uehore gö gö baeromo uarovareje: Diehiꞌego ëhioho ëꞌaruëjo. ");
INSERT INTO aom_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","A ioroꞌioroho bogo ëhioho uvoꞌi aꞌi ma-sivëgoromo uarovareje: Ëaribövioho rihuꞌe jovo sisë ueꞌaho avohëꞌëro simane huotovëhoꞌego ëꞌaruëjo. ");
INSERT INTO aom_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Ëhiꞌamu Peter-ro apostle ioroꞌiore 11-ho jabuꞌo gemu mae jiëꞌëro riꞌöromo ae ahoꞌobëhe ma-darugoꞌo uëvadeje: Jew raje Jerusalem raromarujohumë ae ahoꞌobëhe naehu jö jövoꞌiëꞌajoho avoꞌavoho hehëjo. ");
INSERT INTO aom_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Jemëro uvarujëjo: Ave aribövioho simane sisërëjëꞌëro ëꞌaruëjo. Bogo ëhioho höjo rabëni majae rojomanovego vöröꞌe jovoho aho bogo ueꞌahoruomajëro jiëꞌëro. ");
INSERT INTO aom_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Ëhuni bogo ëhioho jioꞌi aꞌi ë mu hesi bëhoho urimëꞌi Joel-ro ave jöho God-aro baeromo jajivoromo uvade höjo: ");
INSERT INTO aom_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","God-ro uövuavohijajo: Ijo tugohoꞌi majaho rueꞌiramu naro ave muoho vaeꞌejöjo. Naro nasi Aruꞌahoho jovonöꞌe otehëhoꞌiramu ae magonahe ahoꞌo rumorovoꞌajëjo. Rumorovoꞌiramu jemesi ujo ömoꞌömoho aꞌo magonahoꞌo nasi jöho huruohoꞌaruëjo. Jemesi a iꞌohuro nasi muoho niaꞌovoro gaꞌaꞌaruëjo. Jemesi a mavojohuro momoröꞌöromo mue gemuoho gaꞌaꞌaruëjo. ");
INSERT INTO aom_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Ëho majaho rueꞌiramu nasi Aruꞌahoho otehëhoꞌiramu nasi mu vaejarue aho magonahoho jabuꞌo rumorovoꞌajëjo. Rumorovoꞌiramu nasi jöho huruohoꞌaruëjo. ");
INSERT INTO aom_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Öꞌidöre vöröꞌe muoho vaeꞌejöjo. Saꞌare darugoꞌe muoho ömoꞌejöjo. Saꞌare ömoꞌiramu köemu jioromo vëne ravoromo uꞌe ajiomoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Öꞌidöre vaeꞌiramu majaho ramoramovoromo manaeroho köꞌe jioꞌaꞌajëjo. Badare ajiꞌe maja börömo rueröhe ë hesi urimo ëho jioꞌaꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Evare ae rahu Badani uvëꞌoho maro jëvoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Röhu Israel rajomë ave jöho hehëjo. Naro Nazareth raje Iesuare jöho majëhiꞌiëꞌajëjo. God-ro Iesu ajamijamu bogo gavarue darugoꞌe muoho vaeꞌamade höjo ëhuro jemëro tiöromo ma-samaꞌe uvoꞌirarijego: Iesu bogo ëma rueꞌi God-ro nugöꞌöjamu rovade höjo. Ëmuoho jemesirire vaejëꞌëro jemëꞌo iae gavaruje höjo. ");
INSERT INTO aom_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Ëaho jemesi övore rovade höjo God-ro ëhi nimoromo uvëꞌëro. Jemesi övore rovamu jemëro baeromo sisë aribövioho uëvamu korosire anare höjo. Jemesi sisë höjo. ");
INSERT INTO aom_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Röhu vavaene baeromo guomo raromoromo God-ro hesi vavaenoho avohahamu riꞌöjade höjo bogo ioroꞌioremu guomoröhe ahuro jiëꞌëro. ");
INSERT INTO aom_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Ëhi riꞌöꞌiröhe jöho urimëꞌi David-ro God-are surire jajivoromo uvëꞌe höjo: Naro gavode höjo Badaro naꞌo gemu mae juvoꞌi hijamu. Huro nasi bëhire juvoꞌego na bogo juhuonivoꞌejöjo. ");
INSERT INTO aom_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Ëhuro dë vövöbajoꞌoho sasohevaje höjo. O bitarohuro nimorohëꞌi jöe jövaje höjo. Iae nasi sino hahoꞌoho guomo hesi höjo. Röhu na mae hiromo muebeꞌejöjo hujeji God-ro ajemiꞌiröhego. ");
INSERT INTO aom_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Ëhesi bëhoho guomevoꞌiramu vuovoromo raromaruiroho God ja nasi aruꞌahoho ëho bogo nugehoꞌiramu bogo ioroꞌioremuoho ëho hiꞌaꞌajëjo. Na jasi aëro jevëꞌëro ëhuꞌëro jero ajemiꞌiramu nasi sinoho bogo sagohorijevoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Naehu hiemu hiꞌirode öroho jero röjehijëꞌe javajëjo. Jero naꞌo gemu mae juvoꞌego ëhuro na nimorohevo avohoꞌajëjo. Iesuhu ëhi ëꞌiröhe jöho David-ro jajivade höjo. ");
INSERT INTO aom_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Aganomë naro nosi hijo mionoꞌe David-are jöho jemesi örire huruoho majëhiꞌejöjo. David guomamu guavare höjo. Hu guavare huoho jaruvohuꞌo aviae jiajëjo. Ëhuni hesi sinoho bogo sagohoriꞌiröhe jöho hu bogo jövoꞌi Iesuare jöho jövade höjo. ");
INSERT INTO aom_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Ëhesi bëhoho David-ro jö God-aro baeromo juvaje aëro jiëꞌëro ijonö jioröhe jöho gavade höjo. Ëhuꞌëro hu garomo uvade höjo: God-ro na jöe darugo maꞌe majehiromo uevëꞌe höjo: God naro jasi uje gemu baeromo böröme bamoꞌejöjo David jaehu öri ariꞌe muebejanuëhi ëhi ëꞌiröhego. ");
INSERT INTO aom_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","God-hu Keriso böröme bamoröhe jöho David-ro gavëꞌëro ëhuni Kerisohu riꞌöröhe jöho jajivoromo uvade höjo: Vuovoromo raromaruiroho God ja hesi aruꞌahoho ëho bogo nugahamu bogo ioroꞌioremuoho ëho hijade höjo. Jero hu ajamamu hesi sinoho bogo sagohorijahade höjo. ");
INSERT INTO aom_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Röhu ë aho Iesu God-ro ajamijamu riꞌöromo röhu maho hijade höjo. Hijamu hesi aribövioho ahoꞌo no iae nunëro gavëꞌe javuajëjo. ");
INSERT INTO aom_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Riꞌö hiromo God-ro böröme bamamu ajiomoromo hesi övo manö hijëꞌe höjo. Hiromo Vavuehu uavadëhi ëhi hesi Aruꞌahoho bojamamu baeromo jovonöꞌe otehahuëꞌëro jemë garomo hejaruje muoho nomëro vaejaruëjo. ");
INSERT INTO aom_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Röhu Iesuhu God-arire ajiomade jöho iae mae jioꞌego röjëhiꞌejöjo. Iesuhu ajiomadëhioho David God-ariroho bogo ëhioho ajiomade höjo. David hu bogo ajiomade höjo röhu God-are surire jajivoromo uövuade höjo: Bada God-ro nasi Bada uavade höjo: Nasi övo manö rojo hijego jaꞌo muorovarue aribövioho ");
INSERT INTO aom_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","naro ruahöꞌöjëvego hörëro vijuvo taemoꞌamoꞌirane höjo. Bada Iesuhu ajio God-are övo manö hiꞌiröhe jöho David-ro ëhi jajivade höjo. ");
INSERT INTO aom_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Ëhuni Israel aribövioho ahoꞌobëhe jemëro ave jöho avoho hehëjo. Jemëhu korosire anarije aho Iesu ë aho God-ro böröme bamëꞌëro hu Bada höjo. Böröme namiromo ajamuijaje ae höjo. ");
INSERT INTO aom_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Peter-ro ëhi majëhijamu hegorovo ë aribövioho jaburo juhuone böröme baeromo Peterꞌo apostle ioroꞌiorohuꞌo uëvareje: Ö ömoꞌömoho no diehi ëꞌejarëjo. ");
INSERT INTO aom_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Diehiꞌoꞌejarëjamu Peter-ro uëvadeje: Jemë ae gemu gemu uehoro sisëho vuonugoꞌi uehoro mae baeromo Iesu Keriso-are ihoro bapataeto vaejego God-ro jemesi sisëho uehorovoromo vuonugoꞌirajo ëhuro God-ro hesi Aruꞌahoho suvuore mëmego baeꞌirarije höjo. ");
INSERT INTO aom_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Ëhesi bëhoho God-ro hesi Aruꞌahoho jemëꞌo jemesi aboji harihuꞌohuꞌo mëmiꞌi uvade höjo. Ae dinöꞌe dinöꞌe raromoromo nosi Bada God-hu uvamu ejahëꞌoho hesi Aruꞌahoho mëmiꞌi uvade höjo. ");
INSERT INTO aom_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Peter-ro ëhi uënugoromo ëhi jiëꞌe jö göho ahoꞌobëhe majëhiromo uëvadeje: Sisëho vuonugoꞌi avoho raromohego ave sisë ariböviehu iꞌu baeꞌiröhoho jemë bogo ëhioho baeꞌirarije höjo. ");
INSERT INTO aom_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Peter-ro ëhi majëhamu hegorovo hesi jö ejahare ariböviohuro bapataeto vaeruomadeje. Vaejëꞌëro ëhuꞌëro evare majare ae ahoꞌobëhe 3,000 ëhi aevoromo Iesuare aribövi ioroꞌiorohuꞌo gemu mae jijihonövareje. ");
INSERT INTO aom_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Gemu mae jijihoromo apostle jabesi jöho heromo agane vaerovoromo gemuoro ie ueꞌahoromo God-are örire jöe atonövareje. Ëhi jiëꞌe muohuremu uehorovonövareje. ");
INSERT INTO aom_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Ëhiꞌoꞌego God-ro apostle-ho ajëmiꞌego bogo gavarue darugoꞌe muoho vaenövareje. Vaeꞌego ae ahoꞌobëhe ëho gagorovo tiöromo uvonövareje: O mu mabëhe barueromo röjahuijaruëjo. ");
INSERT INTO aom_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Ëhiꞌoꞌego Iesu mae uehorovarue aho jaburo agane gemuoho vaꞌëne gemuoro raromo jijihoromo bövie biseꞌe bogo sivu sivuoho baeꞌi ma-gemuoro bahinövareje. ");
INSERT INTO aom_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Jabesi saꞌae inömo inöme bövie biseꞌe imoꞌamoromo ijo baje ujuohoromo ae gö rabe rabe bogojiëꞌoho suvuorëminövareje. ");
INSERT INTO aom_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Majae ëhi God-are amo börömore gagovorovonövareje. O osare osare gemuoro raromoromo nimorohëꞌi huë baerovëꞌi ie ueꞌahonövareje. ");
INSERT INTO aom_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Ueꞌahoromo God rajahiromo a ioroꞌioro jabesiro huë mae baenövareje. Ëhiꞌoꞌego Badaro ae gö gö baejëvoromo maro bamëvoromo ekaresia gemuore bimuvëvonövadeje. ");
INSERT INTO aom_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Majae sanuovamu Jew rajehu pari vaejarue majare Peterꞌo Johnꞌo jaburo niöꞌiro ruhe God-are amo börömore höröꞌi ajiomareje. ");
INSERT INTO aom_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Ajiomoromo amo börömo hesi rejo ojo bëhire rovareje. Ëojo hesi iho jumuvaroho Ojo Mabëheje. Rueꞌi gavareje ae gemu ë hijamu mamiꞌe höru sisëꞌe ëhi rahëꞌe jiëꞌëro. Höru sisëꞌego majae ëhi hesi ariböviohuro barueromo ojo bëhire ë bamonövareje. Ojo bëhire bamoꞌego ae gö gö osa börömore vaꞌiëꞌiroho jaburo hu ijo baje bojamijöro ëninëminövadeje. ");
INSERT INTO aom_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Ëhi ëꞌojuvo hiromo gavade Peterꞌo Johnꞌo jabuꞌo osare rovaꞌiaꞌamu gëgorovo ëninëmadeje. ");
INSERT INTO aom_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Ëninëmamu hegorovo rueho jaburo hu ërimahoromo Peter-ro uavadeje: No gövuëjo. ");
INSERT INTO aom_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Gövuëjamu hegorovo rue ahuro uvadeje: Jaburo suvuore memiꞌi uevaruëromo gëvadeje. ");
INSERT INTO aom_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Gëvamu Peter-ro uavadeje: Ijo baje bogojevajëjo. Röhu nasi örire jevajohuro ëhuro ajamiꞌejöjo. Naro Nazareth amo raje Iesu Keriso-are ihore ja uavajëjo: Riꞌöromo juvëjo. ");
INSERT INTO aom_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Riꞌöromo juvëromo hesi övo manö maꞌenoromo nigemadeje. Nigemamu gavëꞌi hejade hesi höru hitahioho öbinajoho mae jiavamu hegorovo ");
INSERT INTO aom_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","döro majioho riꞌöromo namiromo hesi hörëro juvadeje. Hesi hörëro juvoromo tiöbe God rajahibe jabuꞌo gemu mae God-are osare vaꞌadeje. ");
INSERT INTO aom_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Ëhiꞌamu ae ahoꞌobëhe garuomadeje huro God rajahibe juvamu gagorovo ");
INSERT INTO aom_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","gavare Ojo Mabëhi hesi bëhire hiromo ijo bajëni ëninëmaje aho jiamu garomo tiöjëvamu uvareje: Diehiꞌoromo höroho marëjëꞌëro juvajëjo. ");
INSERT INTO aom_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Ëhi uvoromo gavare ë aho Peterꞌo Johnꞌo jabesi övoro jiorovoromo jabuꞌo ëhi juvamu God-are amo börömo hesi harada ihe Solomon-are haradare ë juvamu garomo tiöjëvamu tutuvoromo ë gemu vaꞌoromo gagovoruomadeje gaꞌirovo. ");
INSERT INTO aom_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Gagovamu gëgorovo Peter-ro uëvadeje: Israel rajomë jemë ave aho garomo rabëni tiöjarujëjo. Jemë rabëni Johnꞌo naꞌo ërimahuarujëjo. Bogave uvoꞌirarijëjo: No vöröꞌe aëro javuëꞌëro o mu maemu vaejaruëro ëhuꞌëro noro ajamiꞌego marëromo juvajëjo. Bogo ëhioho höjo. ");
INSERT INTO aom_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Aꞌi hu marëjade hesi bëhoho aviëhi höjo. God-hu Abraham Isaac Jacob nosi hijo mionoꞌo ioroꞌioro muebeꞌamadohuro hesi mu vaejaje aho Iesuare ihoho döro nigemahade höjo. Ëaho jemëro guduamoromo a masijo jabesi övore bojëmijarije höjo baeromo sisë vaeröhego. Bojëmiromo hejarije Pilate-ro uvavamu: Ëꞌego naro Iesu jiovo nugöꞌöꞌirö uvamu hegorovo jemëro Pilate-are nunire Iesu bijönimarije höjo. ");
INSERT INTO aom_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Iesu hu God gemu uehorovoromo mu maemu vaenövade höjo röhu jemëro hu bijönimoromo Pilate uavarije höjo huro a muoꞌamaje aho jemëni jiovo nugöꞌöjëhego vaꞌiröhego. ");
INSERT INTO aom_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","A muoꞌamaje aho jiovo nugöꞌöjëhojöro uaꞌi a iꞌovavuaje aho Iesu anojöro uavarije höjo. Ëhiꞌamu guomoromo God-ro ajamamu riꞌöromo hijamu nosi nunëro gavëꞌëro ë jöho majëhijarue höjo. ");
INSERT INTO aom_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Ëaho Iesu mae uehorovadohuro ëhuro hesi darugohuro ajamamu ave höru sisëꞌe a jemë gavarujoho biriroho baejade höjo. Ëaho Iesu mae uehorovamu ëhuro marëjadoho jemë ae ahoꞌobëhe iae gavarujëjo. ");
INSERT INTO aom_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Aganomë iae ëhi höjo röhu na gavajoho jemëꞌo jemesi a masijohuꞌo bëhoho bogo avoho gavëꞌëro Iesu anarije höjo. ");
INSERT INTO aom_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Röhu jemëhu vaejarije mu sisë hesi bëhoho urimëꞌi God-ro jöho nugöꞌöjamu jö hesiro baeromo majehinövare ariböviohuro surire jajivoromo uöbe rueruomade höjo: God-hu uavëꞌëro böröme namiromo ajamuiꞌiröhe aho viꞌehe baeromo guomoꞌaꞌajëjo. God-ro mamiꞌe jö bamoromo uövuadëhi öroho ëhi avohamu Iesu guomade höjo. ");
INSERT INTO aom_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Ëhi jiëꞌe jiaje ëhuni öri sisëre jijiharujoho vuonugoꞌi God-are öroro jijihego huro jemesi sisëho muꞌuvëhoꞌirajo. ");
INSERT INTO aom_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Ëhi ëꞌëꞌoho Badaro jemesi aruꞌahoho biririvëhoꞌajëjo. Biririvëhoromo Iesu nugöꞌöꞌiramu jemëni rueꞌaꞌajëjo. Iesu böröme namiromo ajëmiꞌiröhe aho ë aho God-ro jemesi jöëni baejade höjo. ");
INSERT INTO aom_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Baejëꞌëro huro öꞌidöre hijuvo hujeji God-ro saꞌae bövie biseꞌe röhu maho iꞌe avohoꞌiramu evare rueꞌaꞌajëjo. Ëhi jiëꞌe jöho mami göꞌe nugöꞌöjamu jö hesiro baeromo majëhinövare aribövi mahuro surire jajivobe rovare höjo. ");
INSERT INTO aom_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Iesuare jöho Moses-ro God-are surire jajivoromo uövuade höjo: Jemesi a bövie God-hu na remöꞌöjamu rovodëhi huro jö hesiro baeromo majëhiꞌiröhe a göhuꞌo ëhi nugöꞌöꞌiramu rueꞌaꞌajëjo. Hu jemesi saꞌa raje jioꞌaꞌajëjo. Jö rabe uëvëꞌoho ejahonövorëjo. ");
INSERT INTO aom_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Ae rahu hesi jö bogo ejahëꞌoho ë aribövioho roriꞌo sö vaꞌoromo ijumëvoꞌaruëjo. Iesuare jöho ëhi jajivëꞌe höjo. ");
INSERT INTO aom_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Ëhi jajivamu jö God-aro baeromo majahinövare a ioroꞌioroho Samuel-arire aevoromo hesi ijore rueromo jö majëhijare ae ahoꞌobëhe ëho jaburo jaruvore mu rabehu rovaje jöho majëhibe rovare höjo. ");
INSERT INTO aom_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Röhu jemëꞌo huë mae baeꞌirarijego ëhuni ë ariböviohuro jöho God-aro baeromo majëhiromo uënövare höjo: Huro mu mabëhe nugöꞌöꞌiramu rueꞌaꞌajëjo. Jemëꞌo huë mae baeꞌirarijego ëhuni God-ro jemesi hijo mionoꞌoho darugoꞌe jögoroho bojëmiromo uëvade höjo: Iae naro muebejëvonövoꞌejöjo. Huro ëhi jiëꞌe jögoroho Abraham bojamiromo uavade höjo: Naro jasi a ujoho mae avohëvoꞌiramu ëhuro saꞌae dinöꞌe dinöꞌe raromarue ariböviohuꞌo huë mae baeruomoꞌajëjo. ");
INSERT INTO aom_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Ëhi uavëꞌëro huro hesi mu vaejaje aho Iesu baeromo urimo jemesirire nugöꞌöjade höjo huro rueromo jemë huë mae bojëmiromo dë vövöbajoꞌoho huotovëhego jemë ae ahoꞌobëhe mu sisëho vuonugoꞌirarijego. ");
INSERT INTO aom_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","2","Peterꞌo Johnꞌo jaburo jöho ëhi majëhijamu hejëꞌi Jew rajo a masijohuro rueruomadeje. Priest ömoꞌömohuro God-are amo börömo atovarue jabesi a böviohuro Sadducee ömoꞌömohuro ëho jaburo hejare Peterꞌo Johnꞌo ae uëvamu: Iesu guomoromo riꞌöjëꞌëro ëhuꞌëro vuovarue ae ahoꞌobëhe noꞌo riꞌöꞌejarë uëvamu hegorovo uvareje: Jö sisë ae majëhijaruëromo dë vörönëgamu rovareje. ");
INSERT INTO aom_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Rueromo Peterꞌo Johnꞌo guduamo ömëvo vaꞌoromo majae barëjamu gagorovo savoji gagore baꞌamëvareje hujeji nërö rueromo jabesi nunire rirarovoröhego. ");
INSERT INTO aom_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Amo ae ahoꞌobëhe Peterꞌo Johnꞌo majëhijare jöho heromo Iesu mae uehorovoruomadeje. Mae uehorovëꞌëro ëhuꞌëro Iesu mae uehorovarue aribövioho ahoꞌobëhe 5,000 rabuꞌe jiadeje. ");
INSERT INTO aom_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Peterꞌo Johnꞌo savoji gagore baꞌamëvamu momoröꞌöjëꞌëro sisonuvamu gagorovo council a masijohuro a duvaho ömoꞌömohuro jögoru öri röjëhijarue ariböviohuro ëho jaburo Jerusalem rueromo gemuore gagovoruomadeje. ");
INSERT INTO aom_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Gagovoruomamu priest böröme Annas-ro Caiaphas-ro John-ro Alexander-ro priest börömo hesi agano ioroꞌiorohuro ëho jaburo a masijo ioroꞌiorohuꞌo gemuoro gagovareje. ");
INSERT INTO aom_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Gagovoromo Peterꞌo Johnꞌo huꞌiraejëvo ruejöro jöe nugöꞌöjamu rueromo jabesi nunire ë rirarovareje. Rirarovamu gëgorovo uëvareje: Jemë diehiꞌoromo höru sisëꞌe aho ajamijamu marëjade höjo. Diehi jiëꞌe vöröho baeromo rahuare ihoro uvoromo ëꞌarije höjo. ");
INSERT INTO aom_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Ëhi uëvamu God-are Aruꞌahohuro Peter-are dë vövöbajoꞌoho rarovamu riꞌöromo uëvadeje: Jew rajo a masijohuꞌo a duvahohuꞌo nasi jöe hehëjo. ");
INSERT INTO aom_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Noehu höru sisëꞌe a ajamamu marëjade jöho evaho nani jemë heꞌi nëgamu ëhuni noro jemesi nunire rirarovojöro atëꞌëro uö gövuarujëjo. ");
INSERT INTO aom_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Ëhi jiëꞌoho na negajëjo jemëꞌo Israel a ioroꞌiorohuꞌo ae ahoꞌobëhe jemëro ave jöho heꞌirarijego. Ave aho jemesi nunire marëjëꞌe namijaje hesi bëhoho Nazareth raje Iesu Keriso hesi darugohuro ëhuro ajamamu marëjëꞌe höjo. Ëaho Iesu jemë korosire anamu guomamu God-ro iꞌovamu riꞌöjade höjo. ");
INSERT INTO aom_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Ëaho Iesuare jöho God-are surire uhunöꞌe jajivoromo uövuëꞌe höjo: Jemë munë javue vaeꞌirögoro munë gemu bijönimoromo vuonugarije höjo. Vuonugarijoho jaruvoho ë munëhuro javuoho nigemoꞌego bibivoromo mae namijajëjo. Ëhi jajivëꞌe höjo. ");
INSERT INTO aom_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Iesuro huro gemuëro ajamuijego iꞌuoho bogo baeꞌi marëjavuaje höjo. Ëhesi bëhoho God-ro Iesuare ihe gemu saꞌae dinöꞌe dinöꞌe bojamuijëꞌe höjo aho bogo sisëroho vaꞌi mae javuoröhego. Iho göho bogohöjo. ");
INSERT INTO aom_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Ëhi uëvamu hegorovo rue Jew rajo a masijoho jaburo gavare Peterꞌo Johnꞌo bogo nuni ajiꞌe aho jëvoꞌi ëma unoꞌe ae jëvëꞌe bogo juhuonivoꞌi biririvoromo jöho majëhijamu gagorovo tiöruomadeje. Tiöromo evare garomo uvareje: Ëaho jaburo niöꞌiro Iesuꞌo gemu mae jirehonövëꞌëro ëhuꞌëro ëꞌaruëjo. ");
INSERT INTO aom_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Ëhi uvoromo gavare höru sisëꞌe aho mamiꞌe marëjëꞌëro Peterꞌo Johnꞌo jabesi gemuore namijamu gagorovo jabesi jö ahoꞌiröhoho bogo eni jioruomadeje. ");
INSERT INTO aom_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Bogo eni jioruomamu aëro Peterꞌo Johnꞌo huꞌiraejëvoromo gagovarue osaho vuonugoꞌi roriꞌo vaꞌojöro uënugoromo jabesi sivue jöho mevoromo uarovareje: ");
INSERT INTO aom_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Noro ave ae niöꞌioho diehiꞌëvoꞌejarëjo. Ëhesi bëhoho Jerusalem raromarue ae ahoꞌobëhe hejare uvamu: Ëae niöꞌiohuro bogo gavarue mue gö vaejëꞌe hö uvamu hejëꞌëro ëhuꞌëro subivoꞌiröhoho bogo eni javuajëjo. ");
INSERT INTO aom_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Röhu ae göëro göëro hebe vaꞌojöëni ëꞌego no jögore bojëmiromo uëꞌirarëjo: Bogave ijoho Iesuare ihoroho jöho majëhiꞌirarijëjo. ");
INSERT INTO aom_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Ëhi uarovoromo ae uëvamu Peterꞌo Johnꞌo osaëro huꞌiraejëvo rovareje. Huꞌiraejëvo rovamu uëvareje: Bogave gemu Iesuare ihoroho jöho majëhiromo röjëhiꞌirarijëjo. ");
INSERT INTO aom_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Ëhi uëvamu hegorovo rue ae niöꞌiohuro uëvareje: Jemëhu uövuarujoho nadi Iesuare ihoroho jöho majëhirë uövuarujoho iae no hejaruëjo. Röhu na no jemesi jöho ejëhoꞌejarëjo o God-are jöho ejahoꞌejarëjo. Jemesi garëjo God di muoho nimego. ");
INSERT INTO aom_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Iesuhu ëꞌamu noehu garomo hejare jöho diehiꞌoromo vuonugojörajo. ");
INSERT INTO aom_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Ëhi uëvamu rue Jew rajo a masijohuro Peterꞌo Johnꞌo iꞌu bojëmiꞌibejaroho röhu uvareje: Höru sisëꞌe aho marëjamu gavëꞌëro ae ahoꞌobëhe God rajahiruomajëromo iꞌu bojëmiꞌiröhe öroho bogo birohogoro vuonugoꞌi jöe göꞌo darugo maꞌe majëhiromo jiovo rëmöꞌöjëvamu vaꞌareje. ");
INSERT INTO aom_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Amo ae ahoꞌo God rajahijare hesi bëhoho ë höru sisëꞌe aehu hijade hesi vadunoho ahoꞌo 40 ëminoꞌe iosiramiromo ruëhi jiëꞌëro bogo marë hesi jiadoho röhu Peterꞌo Johnꞌo Iesuare daruge baeromo ajamamu marëjadeje. ");
INSERT INTO aom_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Iae jiovo rëmöꞌöjëvamu vaꞌoromo Peterꞌo Johnꞌo ma-burëro vuonoröꞌö vaꞌoromo jabesi aribövioho uëvareje: Jew rajo priest masijohuꞌo a duvahohuꞌo jaburo no uövuare höjo: Iesuare ihoroho nadi ijoho jöho majëhirëjo. ");
INSERT INTO aom_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Ëhi uëvamu hegorovo rue Iesuare ae ahoꞌobëhe jaburo uehore gemu baeromo God uaruomadeje: O asëꞌe nosi A Börömoho öꞌidöe saꞌae jove bövie biseꞌe jero bamavuane höjo. ");
INSERT INTO aom_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Urimëꞌi jero ave jöho bojamamu jasi Aruꞌahohuro jasi mu vaejaje ae David nosi hije David-are simanore bojamamu huro jajivade höjo. Jajivoromo uövuëꞌe höjo: Saꞌa ioroꞌioro rajoho rabëni jovëro gatovanovoruomade höjo. Saꞌae göre göre aribövioho rabëni simano rumoꞌe muoho vaeꞌi öroho naho garuomade höjo. ");
INSERT INTO aom_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Saꞌae dinöꞌe dinöꞌe raromarue a masijohuro muorovoꞌi avohorovare höjo. Saꞌare simano vaejarue ariböviohuro gagovorovare höjo Bada Godꞌo muorovoꞌi God-hu uavëꞌëro böröme namiromo ajamuaje ahuꞌo muorovoꞌi. ");
INSERT INTO aom_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","David-hu ë jö jajivadëhi ëhi ave amore iae gagovoruomade höjo Iesuꞌo muorovoꞌirovo. A masije niöꞌi Herodꞌo Pontius Pilateꞌo ëho jaburo saꞌa ioroꞌioro rajohuꞌo Israel rajohuꞌo gemuoro gagovare höjo Iesuꞌo muorovoꞌirovo. Iesu jasi muohuremu vaejaje aho höjo. Jero hu uavane höjo huro böröme namiromo ajamuiꞌiröhego. Ëahuꞌo muorovoꞌi gagovoruomade höjo. ");
INSERT INTO aom_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Ëmuoho vaeꞌi gagovare höjo. Röhu urimëꞌi ëhi jiëꞌe muoho jioröhego God jero darugoꞌëro javëꞌëro jasi nimoromo ëhi bamane höjo. ");
INSERT INTO aom_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Bada röhu jaruvoho ë ariböviehu uövuaroho Iesuare jö majëhijëꞌoho iꞌue baeꞌaꞌarujë uövuare jöho jero ëho heromo uehorovoromo no jasi mu vaejarue aho ajamuinego bogo juhuonivoꞌi biririvoromo jasi jöho ma-samaꞌe majëhinövoꞌirarëjo. ");
INSERT INTO aom_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Jasi muemu vaejaje ae Iesuare jöëni riꞌöromo guomo guomoꞌe aribövioho ajëmiromo darugoꞌe mue gö gö vaejego aëro garomo jöho mae uehorovoꞌirarëjo. Ahia minoꞌëjo. ");
INSERT INTO aom_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","God-are örire ëhi atamu gagorovo jabuhu raromaruoho hijiohijiovamu God-are Aruꞌaho hesi darugohuro ae ahoꞌobëhe jabesi dë vövöbajoꞌoho rarovamu bogo juhuonivoꞌi biririvoromo God-are jöho atobe vaꞌareje. ");
INSERT INTO aom_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Ëhiꞌamu iae Iesu uehorovarue aribövioho ahoꞌobëhe uehore gemu dë vövöbajoꞌe gemu baeromo bogo uvonövareje: Nasi höromo sivu sivue bahiꞌi aꞌi uvonövareje: Ae ahoꞌobëhe nosi höromo ma-gemuoro bahinövareje. ");
INSERT INTO aom_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Apostle ömoꞌömohuro darugo maꞌo ae majëhiromo uënövareje: Bada Iesu guomoromo riꞌöjëꞌëro hijamu nosi nunëro gavëꞌe javuajëjo. Ëhiꞌoꞌego God-are huë mahuro ë aribövioho ahoꞌo ruahöꞌöjëvonövadeje. ");
INSERT INTO aom_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Ruahöꞌöjëvoꞌego Iesuare aribövioho ahoꞌobëhe i runoꞌe bövie biseꞌe eni jëvonövadeje. Ëhesi bëhoho ae rahu saꞌae o javue ma-jioꞌamëꞌoho imoꞌamoromo monioho ujuohoromo rueromo ");
INSERT INTO aom_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","apostle jabesi övore bahinövareje. Bahiꞌego apostle-ho jaburo ganövare Iesuare ae gö gö rabe bogojiamu gavëꞌoho suvuorëminövareje. ");
INSERT INTO aom_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Suvuorëmijamu iae ae gemu hesi ihoho Joseph-ro mue gemuoho vaejadeje. Joseph-are iho göho apostle ömoꞌömohuro Barnabas jumuvareje. Barnabas huotovëꞌe hesi bëhoho biriri bojëmaje ahoje. Hesi agano ihoho Levi raje jiadeje. Cyprus saꞌare jioromo rovadeje. ");
INSERT INTO aom_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Rovëꞌëro hiromo saꞌae gö imoromo monioho barueromo apostle jabesi övore bojëmadeje ae suvuorëmiröhego. ");
INSERT INTO aom_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Ëhi jiëꞌe mu maho vaejamu röhu ae göëro mu sisëho vaejadeje. A hesi ihoho Ananias jioꞌi hesi vaboro ihoho Sapphira jiadeje. Ananias-ro mu sisëho vaeromo jabesi saꞌaho gö imoromo ");
INSERT INTO aom_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","subivëhoromo moni vitu hesi tario bamadoho vaborohuro iae gavadeje. Vituoho hesi tario bamoꞌi vituoho apostle ömoꞌömoho iꞌimëmiromo sarerëmiromo uëvadeje: Saꞌa imode hesi ijo bajoho iae bojëmi barëjëꞌe jevajëjo. ");
INSERT INTO aom_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Bojëmi barëjëꞌe jevajëjamu Peter-ro uavadeje: Ananias Satan-hu dinamijadoho ja rabëni ejahoromo hesi jöho baejane höjo. Nadi God-are Aruꞌahoho sareramiromo saꞌa moni vituoho subivëhoromo tario bamoromo uöꞌibejanëjo: Na saꞌa hesi monioho iae bojëmi barëjëꞌe jevajëjo. ");
INSERT INTO aom_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Saꞌa bogo imane majaroho ëho jasi jiade höjo. Jero jasi gaꞌibejanëjo imavego o bogo. O saꞌa imanevare monioho ahoꞌo jasi jiade höjo. Jero jasi gaꞌibejanëjo ae bojëmavego o jasi maꞌenavego. Röhu ja rabëni ëhioho ëꞌi uehorovane höjo. Ëhi ëꞌanoho ja bogo ma-aemuoho sareramuiꞌi Godꞌo sareramijane höjo. ");
INSERT INTO aom_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Jöho ëhi majahijamu hejëꞌi Ananias saꞌare beromo guomadeje. Guomamu ae ahoꞌobëhe ë jöho hegorovo sisë maro juhuonivareje. ");
INSERT INTO aom_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Amo guomamu a iꞌo ömoꞌömohuro rueromo sinoho niögëro numoromo bavaꞌoromo guavareje. ");
INSERT INTO aom_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Guavamu majae 3 hours rabuꞌe barëjamu gagorovo vaborohuro hesi baru guomade jöho bogo hejëꞌe ma-rovadeje. ");
INSERT INTO aom_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Rovamu gagorovo Peter-ro uavadeje: Ave jöho uevego na hejöjo. Saꞌaho imoromo na jemë monioho aveminoꞌe baejarije höjo o göꞌo döre baejarije höjo. Baejarije höjamu sareramiromo uavadeje: Iae ëminoꞌe baejëꞌëro jemesi örire bojëmi barëjëꞌe javuajëjo. ");
INSERT INTO aom_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Bojëmi barëjëꞌe javuajëjamu hegorovo Peter-ro uavadeje: Jaꞌo jasi baruohuꞌo jemë rabëni uvarije höjo: Nani Badare Aruꞌahohuro bogo göromo iꞌuoho bojamuiꞌajëromo ëma sareramuijarije höjo. Nadi ëhioho ëꞌibejarijëjo. Aveho gavëjo. Aribövioho jasi baruoho guavëꞌëro aruëre ojanore rovaruoho hejëjo. Jasi sinohuꞌo bavaꞌoromo guavoꞌaruëjo. ");
INSERT INTO aom_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Ëhi uavamu gavëꞌi vaborohuro Peter-are bëhire ma-majioho beromo guomadeje. Guomamu rue a iꞌohuro osare rueromo gavare vaboroho mamiꞌe guomëꞌe jiamu gagorovo amonö bavaꞌoromo hesi baru hesi bëhire guavareje. ");
INSERT INTO aom_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Ëhiꞌamu ekaresiae ahoꞌobëhe o a ioroꞌioroho jabuꞌo ë jöho hegoro sisë maro juhuonivoruomadeje. ");
INSERT INTO aom_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Ëhi ëꞌëꞌëro iae God-ro ajëmiꞌego apostle ömoꞌömohuro bogo gavarue darugoꞌe muoho ahoꞌobëhe vaeꞌego ae ahoꞌobëhe ganövareje. Ëhiꞌoꞌego Iesuare ariböviohuro God-are amo börömore iojiomoromo amo börömo hesi harada ihe Solomon-are haradare ë gemuoro gagovorovonövareje. ");
INSERT INTO aom_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Gagovoꞌego a ioroꞌioroho jaburo Iesuare aribövioho mae uehorovëvoꞌi röhu juhuonivoromo bogo ëma gemuoroho vaꞌo raromonövareje. ");
INSERT INTO aom_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Bogo ëma gemuoroho raromoꞌi röhu ae magonahe göꞌo göꞌo ahoꞌobëhe Bada mae uehorovoromo Iesuare ariböviohuꞌo aevoromo gemu mae raromo jijihonövareje. ");
INSERT INTO aom_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Ëhi jiëꞌe mu masijoho rovëꞌego aëro guomo guomoꞌe aribövioho örire ujuoho ruenugoromo momoröꞌöjarue röho nu anoꞌe göre göre ë bahinövareje Peter rovaꞌego hesi övehu bogo ajëmijëꞌoho röhu hesi maja aruꞌahohuro bamëvego marëꞌiröhego. ");
INSERT INTO aom_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Ëhiꞌoꞌego ae ahoꞌobëhe Jerusalem-nörire amo göre göre raromarue aribövioho jaburo guomo guomoꞌe ariböviohuꞌo aruꞌaho sisëhu simano sisë vaejëhëꞌe ariböviohuꞌo ujuoho rueꞌego apostle ömoꞌömohuro jabumë ahoꞌobëhe ajëmiromo avohëvonövareje. ");
INSERT INTO aom_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Ëhiꞌamu gagorovo iae Jew rajo priest börömohuꞌo hesi aemoꞌaeme Sadducee ariböviohuꞌo ëho jaburo apostle jabesi 