﻿USE sofia;
DROP TABLE IF EXISTS sofia.aoj_vpl;
CREATE TABLE aoj_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES aoj_vpl WRITE;
INSERT INTO aoj_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Wambota atamba bafapana akupana Jisas Kraisi amamba. Jisas nataga wambota Deviti, Devit nataga wambota atamba Abrahami. ");
INSERT INTO aoj_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Bafas ihas wambota atamba Abrahami isimba. Nogama Abrahami Aisak. Nogama Aisaki Jekop. Eaꞌ Jekop ahama Judai naloma sahopana owapana ananimi. ");
INSERT INTO aoj_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Juda ahama Peres naloma Sira. Maꞌmam amamuꞌwi Tamar. Eaꞌ Peres ahama Hesroni, eaꞌ Hesron ahama Rami. ");
INSERT INTO aoj_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ram nogamana agilinama Aminadap. Eaꞌ nogamana Aminadapi Nason. Eaꞌ nogama Nasoni Salmon. ");
INSERT INTO aoj_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Eaꞌ Salmon nogamana agilinama Boas. Boas maꞌmana Rehap. Boas nogamana agilinama Obet. Obet maꞌmana Rut, eaꞌ Obet nogamana agilinama Jesi. ");
INSERT INTO aoj_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Eaꞌ Jesi anen ahama dembinai king Deviti. Devit nasoꞌ anoꞌw nemataꞌw fowaꞌ Uria nagasoꞌakwi nola king Solomon. ");
INSERT INTO aoj_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Eaꞌ Solomon nogamana agilinama Rehoboam, eaꞌ Rehoboam nola Abiyah. Eaꞌ nogamana Abiyah agilinama Aser. ");
INSERT INTO aoj_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Aser anen ahama Jehosafati, nola Joram. Eaꞌ Joram ahama Usia. ");
INSERT INTO aoj_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Eaꞌ Usia nola Jotam, Jotam nola Ehas ahama Hesekaiai. ");
INSERT INTO aoj_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hesekaia nogamana agilinama Manase, eaꞌ Manase nola Amos. Amos ahama Josaiai. ");
INSERT INTO aoj_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Eaꞌ Josaia nola Jekonia naloma owapana ananimi maloma ahamam maꞌmam safeꞌ sandaꞌ kalabus sapani wambel Babilon lauguni. ");
INSERT INTO aoj_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Esis sofaꞌas sawasiꞌas sisihis sapani Babilon, Jekonia nogamana ananinai agilinama Sealtiel, eaꞌ Sealtiel nola Jerubal. ");
INSERT INTO aoj_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Jerubal anen ahama Abiuti eaꞌ Abiut nola Eliakim. Nogamana ananinai agilinama Asor. ");
INSERT INTO aoj_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Asor nogamana agilinama Sadok, eaꞌ Sadok ahama Akimi. Akim nola Eliut. ");
INSERT INTO aoj_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eaꞌ Eliut nogamana agilinama Eleasar, eaꞌ Eleasar ahama Matanii. Eaꞌ Matani nola Jekop ahama Josepi. ");
INSERT INTO aoj_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Josep anamba nagasoꞌ Mariai. Eaꞌ Maria deiꞌ kola Jisas, deiꞌ esis sagaꞌi anen Krais Dembinai God nandandepana nasapaꞌana nagafiꞌii. ");
INSERT INTO aoj_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Amom bafapana akupana Jisasi fowaꞌimi siambam magataga naꞌamba. Amom amamba Abraham nolam magiꞌ magatagai mafiꞌi matagama Devit, amamba siambam mataga 14-pelaim. Eaꞌ amom amamba Devit nolam magiꞌ magatagai mafiꞌi matagama nemaf afamba bousi sofaꞌ esis Israel safeꞌ sandaꞌ kalabus sagape wambel Babiloni, amamba wapani 14-pelaim. Eaꞌ amom amamba esis Israel sandaꞌ kalabus Babilon solam magiꞌ magatagai mafiꞌi aꞌ matagama nogota Krais nagataga, amamba wapani 14-pelaim. Siambam sagakolasom aꞌ mataga hiami 42-pelaim. ");
INSERT INTO aoj_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Fowaꞌ Maria kogola Jisas Krais basef fagape naꞌamba. Maꞌmana Maria esis saꞌi akoꞌw kosoꞌ Josep, eaꞌ esis bias ina deiꞌ sandasoꞌama, ataꞌ owaꞌatin. Eaꞌ sati Maria akofaꞌ opafa Ambal buꞌunai Godi nafiꞌmai akoꞌw eaꞌ deiꞌ aꞌ opafuꞌw. ");
INSERT INTO aoj_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Waulunamaꞌw akwoꞌunai Josep anen aman buꞌunai. Anen nandaiwaꞌma nondaꞌakw ambal aol. Naꞌamba okom maꞌi nondambahoꞌ niliꞌamonaꞌw kope dowaf. ");
INSERT INTO aoj_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Anen nape ataꞌ okom mandandaꞌma isimba atis, eaꞌ naꞌoh nandondoꞌah owaꞌ, anona ensel Dembinaii natagama anen naꞌipana naꞌi, “Josep, inaꞌ akunama Deviti, ina ombal mehenama negaoꞌwa wauluꞌmina ineꞌikwi Maria, owaꞌi. Deiꞌ main, awani inimba nagapauꞌwi, Ambal buꞌunai Godi nafiꞌmai akoꞌw. ");
INSERT INTO aoj_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Eaꞌ atiasi aꞌ kola awani aman, awani inimba anen nogatopalopa amam nematawa hiasi ma nogakwaha waf awafi asasifi nofaꞌas sogotanimaii. Naꞌamba deiꞌ inaꞌ nihapomana agol ananigili Jisas. Basef kofagefa ma agol agalemba ifimba faꞌi, anen aman nogofaꞌ epes ananisii ma sogape andeandeꞌi. ");
INSERT INTO aoj_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Hiahaom amamba hiami mataga naꞌamba siꞌi anif basef Dembinai nagasoꞌanaef malogol anona aman profet fowaꞌinai, deiꞌ afataga endilisi. Fowaꞌ gani profet anamba nagaꞌias naꞌamba naꞌi, ");
INSERT INTO aoj_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","‘Owagama anoꞌw nemataꞌw saꞌukwi owaꞌ otaꞌ kogasoꞌ amania aꞌ opafuꞌw. Eaꞌ kola anin awani aman agol ananigili Emanuel. Agol agalemba kofagogola gaꞌias naꞌamba gaꞌi, God nape naloma apaꞌ. ");
INSERT INTO aoj_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","25","Eaꞌ Josep naꞌoh nandambema aꞌ nandaꞌas siꞌi ensel nagaꞌipana. Eaꞌ naila basef ifimba naoꞌwakw apaꞌ esis ina sandasoꞌama atogon atin, owaꞌ. Ataꞌ sape daindai safeꞌ ma akoꞌw aꞌ kogola awani aman. Eaꞌ nahapomana agol Jisas. ");
INSERT INTO aoj_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Maria kola Jisas Betlehem, itap luꞌupa agilipa Judia. Nogota atamba Maria kogola Jisas, anona aman dembinai king Herot nape nugumafi walemb hielimbi esis Judai. Akoꞌw kolana eaꞌ, anom amam dembami gawaimi owaꞌ mogogawa Godia mafiꞌi lauguni gani awin nagatafima aꞌ mafiꞌi mafiꞌi mataga luꞌwambili Jerusalem eaꞌ maꞌi, ");
INSERT INTO aoj_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","“Deiꞌ awani Dambaini nagataga king dembinai esis Judai nape ani? Afaꞌ wati ondoꞌw ananiꞌwi kwatafi kwape gani awin nagatafima, eaꞌ deiꞌ wailaꞌw wafiꞌi waꞌi ondaꞌ lotumana ofela agol ananigili.” ");
INSERT INTO aoj_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Afamba Dembinai King Herot nameꞌ basef ifimba, okom iwanim malamafeꞌma atiasi awani inimba netaga damben aꞌ niliꞌamona anen. Eaꞌ esis hiasi sagape Jerusalami wapani aꞌ ombal mahas saꞌi atiasi nemaf awafi aꞌ fetaga. ");
INSERT INTO aoj_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Eaꞌ king Herot nakolasai amom pris hiami dembami maloma amom dembami magawalipasa muꞌuli Godi eaꞌ nahaliꞌam naꞌi, “Aman anamba Krais God nandandepana nosapaꞌana nogafiꞌii, atiasi anen notaga wambel anima?” ");
INSERT INTO aoj_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Eaꞌ amom magwamana basef maꞌi, “Maꞌmana kolana Betlehem, itap luꞌupa Judia. Deiꞌ main, anona profet fowaꞌinai nagaꞌi basef naꞌi, ");
INSERT INTO aoj_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Ipaꞌ Betlehem itap luꞌupa Judia, ipaꞌ ina epes falafipai, owaꞌatin. Ipaꞌ ina pape pagiꞌ ma amom gavman dembami mugumafi ipaꞌ Judiai, owaꞌ. Deiꞌ main, anona Dembinai anaf aꞌ notaga wambel ipeꞌimbili saꞌumbili Betlehem. Anen anaf aꞌ nogape dembinai ma ipaꞌ amam nematawa aeꞌipai Israel eaꞌ numafi ipaꞌ hipai ma pegape andeandeꞌ.’” ");
INSERT INTO aoj_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Eaꞌ king Herot nandambahoꞌ atin nofalai amom gawaimi amamba magafiꞌi awin nagatafimai mandambahoꞌ mandakolas nahaliꞌam naꞌi, “Nemaf maif ipaꞌ pati ondoꞌw akwamba kwataga?” ");
INSERT INTO aoj_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Eaꞌ amom maꞌipana ma eaꞌ, nasapaꞌam aꞌ mafeꞌ Betlehem naꞌipam naꞌi, “Ipaꞌ foꞌo pelapelaoma awani inimba. Ama pitilin, pitanima pefaꞌai basef pifiꞌi piꞌipa aeꞌ wapani. Aeꞌ aꞌi efeꞌ itilin endaꞌ lotuman efela agol ananigili wapani.” ");
INSERT INTO aoj_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Amom mameꞌ basef ananifi eaꞌ, mosafel makwaha anen aꞌ mafeꞌ, mati ondoꞌw akwamba saꞌukwi fowaꞌ maliꞌ magatoloꞌw gani awin nagatafimai, aꞌ kwafeꞌ kwaliꞌa amom. Eaꞌ kwape atapiꞌw ipat atamba ilif awani inimba Jisas nagapautai. ");
INSERT INTO aoj_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Amom mati ondoꞌw akwamba kwape ipat atamba eaꞌ sonaham aꞌowaꞌ. ");
INSERT INTO aoj_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Eaꞌ mawis ipat atamba awani inimba naloma maꞌman Maria sagapautai. Amom mati awani inimba mindiwa nembawa motawa mandaꞌ lotuman mafela agol ananigili. Ama main, mupalia paus amamisi magiai hiahawes amom magatalis otamba luꞌumbaisi alogw fasifasigwi gwagasi masoꞌanas. Eaꞌ masoꞌana gol naloma anin paura saꞌi frankinsens, alogw fasigwi gwagani saloma anin sanda buꞌwani sofalan sagaꞌi meri, masoꞌanas awani inimba Jisas. ");
INSERT INTO aoj_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Masoꞌanas eaꞌ, God naꞌipam naꞌi, “Ipaꞌ ina ataꞌ pitanima pefeꞌma King Herot, owaꞌi. Eaꞌ pila anoꞌw ufiaꞌw pitanima pefeꞌ wambel ipeꞌimbili.” Eaꞌ maila anoꞌw ufiaꞌw daiaꞌw motanima mafeꞌ wambel amamimbili lauguni. ");
INSERT INTO aoj_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Amom amamba gawaimi mafeꞌ, Josep naꞌoh owaꞌ, nandondoꞌah anona ensel Dembinaii nafiꞌmai anen naꞌipana naꞌi, “Inaꞌ safel aꞌ neꞌwa awani inimba neloma maꞌmana ananiꞌwi pefeꞌ anambel wambel lauguni itap luꞌupa Isip. Eaꞌ pipani Isip ama anaf pemeꞌ aeꞌ iꞌipipa wapani daoꞌ, pifiꞌi. Deiꞌ main, dembinai King Herot atiasi niꞌipa soldia ananimi molaꞌ molaoma awani inimba ma mohan negagaꞌ.” ");
INSERT INTO aoj_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Eaꞌ Josep nosafel owamb ambamba atomb naoꞌwa awani naloma maꞌmana Maria asafeꞌ Isip lauguni. ");
INSERT INTO aoj_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Josep napani Isip ama King Herot nagaꞌ eaꞌ naoꞌwas sotanimai siꞌi anif basef Dembinai God nagaꞌif malogol anona aman profeti ifimba deiꞌ aꞌ fataga fandawalap faꞌi, God naꞌi, “Nogame aeꞌanai napani Isip eaꞌ aeꞌ efalana aꞌ notanima nafiꞌi.” ");
INSERT INTO aoj_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","King Herot aꞌ nogawa amom amamba gawaimi ina mutanimai maꞌipana, owaꞌ. Mambasoꞌmana mafeꞌ anoꞌw ufiaꞌw daiaꞌw. Eaꞌ nembel ananinai aꞌ wandafuna kwapeteꞌ naꞌi noha Jisas nogaꞌ. Deiꞌ anen okom mandandaꞌma basef ifimba amom gawaimi maliꞌ magaꞌipanaefi ma nemaf afamba ondoꞌw kwagatagaefi. Naꞌamba deiꞌ nasapaꞌ anom soldia mafeꞌ Betlehema walemb ambalemba bagape felefeleꞌi maha awasi amam hiami deiꞌ sogalam dambaimi mafeꞌ motaga afagof biagof fagaloꞌami magaꞌ hiꞌalam. ");
INSERT INTO aoj_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Eaꞌ deiꞌ anif basef fowaꞌ God nagaꞌipanaef profet Jeremaiai afataga endilisi fandawalap. ");
INSERT INTO aoj_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Anen naꞌi, “Esis sagape anambel wambel Ramai sameꞌ analemb amalemb. Esis salef sindiwagef mehipa sagaꞌi uwahipigama awasi sagagaꞌi. Anoꞌw nemataꞌw Resel kwalopa batawisaꞌw akwaꞌusi, ina atiasi anis amam nematawa laꞌifisa sondaꞌ nembel akwoꞌumbili begape awanembel, owaꞌatin. Deiꞌ main, awasi akwaꞌusi asagaꞌ hiꞌalas.” ");
INSERT INTO aoj_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Josep ataꞌ napani Isip ama King Herot nagaꞌ, ensel Dembinai Godi nafeꞌ naꞌipana ma koh dondoꞌah ananini ");
INSERT INTO aoj_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","naꞌi, “Inaꞌ safel a neꞌwa awani neloma maꞌmana ananiꞌwi a pitanima pefeꞌ itap luꞌupa Israel. Amom maꞌi mogaha awani nogagaꞌi aꞌ magaꞌ eaꞌ.” ");
INSERT INTO aoj_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Eaꞌ Josep nosafel naoꞌwa awani naloma maꞌmana ananiꞌwi asafeꞌ itap luꞌupa Israel. ");
INSERT INTO aoj_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Apaꞌ Josep nameꞌ basefa anona aman Arkelaus king Herot nogamana nataga nofaꞌ wambel nahaꞌofana nape dembinai king esis Judai. Eaꞌ Josep ombal mahana ma nogafeꞌ Judia. Owaꞌ naꞌoh nandondoꞌah wapani, God naꞌipana ma nogafeꞌ anamba itap luꞌupa Galili. ");
INSERT INTO aoj_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Eaꞌ nafeꞌ nape anin taun saꞌuni sofalagon Nasaret siꞌi anif basef amom profet fowaꞌ magaꞌiefi maꞌi, “Owagama esis sofalana siꞌi Nasaretinai.” Basef ifimba deiꞌ fataga fandawalap endilisi. ");
INSERT INTO aoj_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Nimaguf hiafi ma nogota atamba anona aman Jon nagapisiꞌas embeli nafiꞌi nape anep itap luꞌupa Judia wafigima fataupigima eaꞌ nawalapa basef fasifi. ");
INSERT INTO aoj_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Anen naꞌipas naꞌamba naꞌi, “Nemaf afamba buꞌwafi eaꞌ felefeleꞌ fegataga ma epes sogawis nomona maol Godi nope Dembinai nugumafias. Naꞌamba deiꞌ ipaꞌ pendewaꞌ alafugaha waf awafi pembema nelelemb pefeꞌma God.” ");
INSERT INTO aoj_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Eaꞌ Jon nafeꞌ naꞌipasa basef ifimba God nagaꞌipanafi siꞌi malogol anona amani profet Aisaia fowaꞌ nagaꞌiefi naꞌi, “Anaf malogol anona amani noga niꞌi anep itap wafigima fataupigima niꞌi basef naꞌamba niꞌi, ‘Pendomba ufiaꞌw Dembinai. Pisindiꞌamona ufiawa ananiwai.’” ");
INSERT INTO aoj_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Klos Jon nagalami sandaꞌ auf anom mafis luꞌwami kameli sandaꞌam, eaꞌ nowahoꞌ anota let sandaꞌ agwahup mafisina sandaꞌanai. Gwaꞌaisi ananisi naꞌ gwamuꞌwis saloma aupimbel alupumi. ");
INSERT INTO aoj_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Nogota atamba amam nematawa sagape Jerusalami saloma hiasi sagape itap luꞌwipai Judia eaꞌ walemb ambalemba felefeleꞌma walemb Jordani, hiasi safiꞌmai Jona nogapisiꞌas embel. ");
INSERT INTO aoj_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Eaꞌ esis sawalapa waf awafi esis sandaꞌafi eaꞌ Jon napisiꞌas walemb Jordan. ");
INSERT INTO aoj_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Afamba Jon nati anom amam dembami esis Judai Farisi maloma anom dembami Sadyusi mafiꞌi ma mogofaꞌ baptais, eaꞌ naꞌipam naꞌi, “Ipaꞌ pandaꞌ waf awafii siꞌi batawis ul aunaii. Ami naꞌipipa ma paꞌi pefaꞌ pefeꞌ okom wandafunai Godi anaf nogatagama ipeꞌi?” ");
INSERT INTO aoj_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Anen naꞌipas naꞌi, “Ipaꞌ pembema nelelemb pewaꞌ alafugaha waf awafi ipeꞌifi, eaꞌ pendaꞌ waf fasifi ma pigihimbaꞌmas ipaꞌ aꞌ pambema opalef endilisi paila waf buꞌwafi. ");
INSERT INTO aoj_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Ipaꞌ ina aꞌ ukup pendandaꞌ piꞌi, ‘Abraham anen ahamapa apeꞌinai’, owaꞌi. Aeꞌ aꞌipipa endilisi, God anen laꞌifinai ma nondaꞌ otamba atemba begataga epes siꞌi awasi Abrahami. ");
INSERT INTO aoj_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Tamiaꞌw eaꞌ kwape lawah kofagogaha. Lawah mamahogaha owaꞌ hil hogola saꞌutip buꞌwapia, atiasi solagah sotopaꞌagah hefeꞌma nif.” ");
INSERT INTO aoj_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Eaꞌ anen naꞌipam naꞌi, “Ipaꞌ pewaꞌ alafugaha waf awafi deiꞌ aeꞌ apisiꞌipa embela pigihimbaꞌmas ipaꞌ aꞌ pambema nelelemb pakwaha waf awafi a pefeꞌma God. Apaꞌ anona aman atiasi nigiꞌ nugafiꞌii, anen banagonai nikilaꞌ aeꞌ. Anef nemaf anen neseꞌepa Ambal buꞌunai Godi nogape opalef ipeꞌilifi nomon eaꞌ neseꞌepa nif wapani. Aeꞌ ina aman buꞌuwai ma egatagwaha mandelefa su ananimi, owaꞌ. ");
INSERT INTO aoj_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Anen nahapila anol savol lagof ananigufi ma nigasimbaꞌ wit siꞌi rais amamba andeandeꞌ. Ama nofaꞌ buꞌunai nuwis nembeꞌana ipat ananitai. Apaꞌ duꞌwaꞌwanimi awasimi nembeham nofam nif amamba luꞌwami fandom atapim magapani.” ");
INSERT INTO aoj_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Nogota atamba Jisas anakwaha itap luꞌupa Galili aꞌ nafiꞌi walemb Jordan, eaꞌ nafiꞌmai Jon ama nogapisiꞌana. ");
INSERT INTO aoj_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Owaꞌ Jon naꞌi nosopama Jisas naiꞌpana naꞌi, “Aeꞌ ina aman buꞌuwai ma igapisiꞌina, owaꞌ. Inaꞌ nipisiꞌ aeꞌ daoꞌ, andeandeꞌ. Deiꞌ inaꞌ nafiꞌmai aeꞌ ma main?” ");
INSERT INTO aoj_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Owaꞌ Jisas nagwamana basef naꞌi, “Inaꞌ nendaꞌmeas siꞌi aeꞌ agaꞌipina. Afaꞌ biafa ondaꞌas naꞌamba ma ondahama waf hiafi usiꞌifi, siꞌi God nagaꞌiefi.” Eaꞌ Jon naꞌi ahoꞌ napisiꞌana. ");
INSERT INTO aoj_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Jisas nofaꞌ baptais nakwaha embel nandagiai atin, owaꞌ, heven aꞌ nandawisiꞌ ma anen, eaꞌ nati Ambal buꞌunai Godi nafiꞌmai anen, siꞌi amil alamba apaꞌ magaꞌi maꞌunai nufiaꞌ nisilaꞌmai anen. ");
INSERT INTO aoj_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Eaꞌ anagol malogol gaꞌi gatagai heven gaꞌi anif basef gaꞌi, “Aman anamba Nogame aeꞌanai endilisi. Aeꞌ okom mohafel maimailana aꞌowaꞌ. Okom aeꞌami boꞌoma anen.” ");
INSERT INTO aoj_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Ambal buꞌunai Godi nofaꞌ Jisas nafeꞌ anep itap wafigima fataupigima ma aman aunai Satan nogwambana nondaꞌ waf awafi. ");
INSERT INTO aoj_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Jisas nape awin siꞌini duꞌwanini, ina naꞌ gwaꞌaisi, owaꞌ. Nolomahana nape dowaf. ");
INSERT INTO aoj_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Eaꞌ aman anamba Satan nagagwambanai nafiꞌi naꞌipana naꞌi, “Inaꞌ naꞌi inaꞌ Nogamana Godi, deiꞌ kipa otamba ambamba bagaꞌoh itapi betaga siꞌi bret.” ");
INSERT INTO aoj_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Eaꞌ Jisas nagwa basef naꞌipa Satan, naꞌi, “Baibel naꞌi, apaꞌ ina ukup pepoma gwaꞌaisi atis sondaꞌapa banagepa, owaꞌ. Apaꞌ ukup pendapoma basef Godi atif fendaꞌapa mogape banagipai.” ");
INSERT INTO aoj_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Eaꞌ Satan naoꞌwana nafeꞌ Jerusalem nahaponana nalutu ipat Godi luꞌunai ilif. ");
INSERT INTO aoj_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Eaꞌ Satan naꞌipana naꞌi, “Inaꞌ naꞌi inaꞌ God Nogamana, deiꞌ nindipaꞌ newa itap. Deiꞌ main, basef fagail Baibeli fagaꞌi naꞌamba faꞌi, ‘God atiasi aꞌ niꞌipa ensel ananimi mifiꞌi muhapilina mumafina ma otamba ina beha boꞌwagah ineꞌigahi, owaꞌ.’” ");
INSERT INTO aoj_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Eaꞌ Jisas nagwamana basef naꞌi, “Anif basef Godi wapani fagape faꞌi, ‘Ipaꞌ ina aꞌ pegwamba Dembinai God ipeꞌinai nondaꞌ waf awafi, owaꞌ.’” ");
INSERT INTO aoj_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Eaꞌ Satan naoꞌwana mafeꞌ wapani malota anona halafuta launai aꞌ nihimbaꞌmana hiahaom hiami buꞌwami magape itap hiagomai maloma amam nematawa hiasi. ");
INSERT INTO aoj_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Eaꞌ naꞌipa Jisas naꞌi, “Iꞌi inaꞌ nindiwa nembawa netawa niꞌi aeꞌ dembiwai ineꞌiwai, atiasi aꞌ eseꞌena hiahaom amamba buꞌwami mefeꞌma inaꞌ hiꞌilam eaꞌ ineꞌimi siꞌim.” ");
INSERT INTO aoj_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Owaꞌ Jisas nagwamana basef naꞌi, “Satan inaꞌ kwaho aeꞌ, a foꞌo. Baibel nagaꞌias naꞌamba naꞌi, ‘Ipaꞌ pendaꞌ lotuma Dembinai God atona ipeꞌinai eaꞌ pendaꞌ maola anen atona.’” ");
INSERT INTO aoj_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Eaꞌ Satan nakwahona nafeꞌ, deiꞌ ensel Godi mafiꞌi matopalopa Jisas mumafiana. ");
INSERT INTO aoj_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Jisas nameꞌ basefa Jon nandaꞌ kalabus, eaꞌ nosafel nakwaha Nasaret nafeꞌ itap luꞌupa Galili. ");
INSERT INTO aoj_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Eaꞌ nakwaha wambel ananimbili nafeꞌ Kaperneam, bagape felefeleꞌma dumb luꞌwambi Galili, anep itap agilipa Sebulun naloma Naptali. ");
INSERT INTO aoj_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Eaꞌ nafeꞌ nape itap apamba siꞌi basef fowaꞌ anona profet Aisaia nagaꞌiefi, a fataga fandawalap endilisi. Anen nandaꞌ basef ifimba naꞌi, God naꞌi, ");
INSERT INTO aoj_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Itap apamba Sebuluni Naptalii felefeleꞌma Itap apamba ufiaꞌw kwafeꞌ kwagataga naohi. Itap apamba walemb Jordan fisanamb, walemb hielimbi agol luꞌwagili Galili. Esis walemb hielimbi ambalemba ina sogawa basef aeꞌafi, owaꞌ. ");
INSERT INTO aoj_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Eaꞌ sape siꞌi epes isimba sagape akot atonai, siꞌi sagagaꞌi. Owagama gani sigati owaf luꞌwafi figaluwi sotologon andeandeꞌ.” ");
INSERT INTO aoj_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Eaꞌ deiꞌ Jisas nasefela maola nagaꞌipasa basef atapif. Nawalipasa basef ifimba naꞌi, “Nemaf afamba buꞌwafi felefeleꞌ fegataga ma ipaꞌ pigawis nomona maol Godi nope Dembinai nugumafipa. Naꞌamba deiꞌ ipaꞌ pembema nelelemb pefeꞌma God pewaꞌ alafugaha waf awafi.” ");
INSERT INTO aoj_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Jisas naila akata nafeꞌ atin dumb luꞌwambi Galili, nati amam biam Saimon agol waꞌagol Pita naloma owamana Andru. Amom mala anembeh mowafa agof mandaꞌ bisnis. ");
INSERT INTO aoj_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Anen nati amom biam naꞌipam naꞌi, “Ipaꞌ bipa pifiꞌi pihapifa aeꞌ pili pefeꞌ. Fowaꞌ ipaꞌ pewafa agof, apaꞌ deiꞌ ihimbaꞌmepa pefeꞌ piꞌipai anis epes sufiꞌi sila aeꞌ.” ");
INSERT INTO aoj_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Eaꞌ amam mameꞌana mosafel kwafalis makwaha anembeh haꞌoh mailana mafeꞌ. ");
INSERT INTO aoj_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Eaꞌ Jisas naꞌi nindikiꞌah nafoꞌo kwasakwasala owaꞌ nati anom amam biam wapani Jems naloma owamana Jon maloma ahamam amamunai Sebedi. Amom matoma bot mape mosambala anembeh amamimbihi. Eaꞌ Jisas nofala amom biam Jemsi Jon. ");
INSERT INTO aoj_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Eaꞌ mosafel kwafalis makwaha bot mafiꞌi maila Jisas mafeꞌ. Ahamam amamunai Sebedi makwahona nape bot. ");
INSERT INTO aoj_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Jisas nafeꞌ itap luꞌupa Galili, nafeꞌ naꞌipasa basef buꞌwafi Godi amam nematawa hiasi nomon ifagw esis Juda sandakolasugwi. Basef buꞌwafi anen nagaꞌipasafi ifimba faꞌi, “Nemaf afamba buꞌwafi afafiꞌi fafiꞌmai apaꞌ. Ama ipaꞌ hipai pigawis nomona maol Godi nope Dembinai nugumafipa.” Eaꞌ natopalopa epes hiasi aowas naninani nandaꞌasi sataga boꞌwes wapani. Aowas maina naninani nandaꞌasi, Jisas laꞌifina nandaꞌas sataga boꞌwes. ");
INSERT INTO aoj_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Basef Jisasi fesafel fafeꞌagon walemb anamba hiagoma agol Siria ma nagatopalopa aowas nandaꞌasi hiasi sagataga boꞌwes. Eaꞌ esis Siria wapani sofaꞌai hiasi aowas naninani nandaꞌasi sofaꞌas safiꞌmai Jisas. Anis ambagof awami mandaꞌas a sahaga sagagauli, anis ambagof awami mahas maofas nif, anis sameꞌ alop akep pagahasapi, esis asofaꞌas safiꞌmai Jisas nandaꞌas sataga boꞌwes hiꞌalas. ");
INSERT INTO aoj_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Naꞌamba amam nematawa hiasi sagiꞌmana safeꞌ. Anis sape itap apamba Galili saloma anis sagape walemb ambalemba ilifunamailimb Dekapolis saloma anis sagape Jerusalami, anis sagape itap luꞌupa Judiai, saloma anis epes sagape walemb Jordan fisanambi esis hiasi sagiꞌmana safeꞌ. ");
INSERT INTO aoj_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Jisas nati esis amam nematawa hiasi eaꞌ nandowasaꞌ halafuta aꞌ nape. Eaꞌ alipumi ananimi mafiꞌi mandakolas malomana. ");
INSERT INTO aoj_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Eaꞌ anen aꞌ nosafela basef ifimba laufi nawalipamef. ");
INSERT INTO aoj_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","Anen naꞌi, “Ipaꞌ mamahipama pegawa eaꞌ ipaꞌ atipa owaꞌ laꞌifipama pendaꞌ maol buꞌwani Godia, deiꞌ daoꞌ ipaꞌ apandagala. Deiꞌ main, ipaꞌ pawis eaꞌ nomona maol Godi nope Dembinai nugumafipa. ");
INSERT INTO aoj_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","“Eaꞌ ipaꞌ mamahipama kilef pagapani, ipaꞌ deiꞌ daoꞌ apandagala. Deiꞌ main, God atiasi nondaꞌ nelelemb ipeꞌilimbi ambepe boꞌwalemb. ");
INSERT INTO aoj_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","“Eaꞌ ipaꞌ mamahipama pagape saꞌombel lafela anisi, deiꞌ daoꞌ ipaꞌ apandagala. Deiꞌ main, ipaꞌ atiasi aꞌ pefaꞌ hiahaom buꞌwami God naꞌi endilisi ma nogasiꞌipami. ");
INSERT INTO aoj_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","“Eaꞌ ipaꞌ mamahipama ukup pehafel pagapagaꞌi waf usiꞌifii, siꞌi nolomagahasa gwaꞌaisi iap pagasoꞌasa embeli, deiꞌ daoꞌ ipaꞌ apandagala. Deiꞌ main? Atiasi God neseꞌepa waf afamba ukup pagapagailafi dondoꞌma ipaꞌ siꞌipamef. ");
INSERT INTO aoj_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","“Eaꞌ ipaꞌ mamahipama pagati anis daias uwahipisi, deiꞌ daoꞌ ipaꞌ apandagala. Deiꞌ main, atiasi God aꞌ niti ipaꞌ uwahipipa. ");
INSERT INTO aoj_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","“Eaꞌ ipaꞌ mamahipama ukup pagape beꞌep hililiꞌi ma waf awafi akipai, deiꞌ daoꞌ ipaꞌ apandagala. Deiꞌ main, ipaꞌ atiasi aꞌ piti God. ");
INSERT INTO aoj_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","“Eaꞌ ipaꞌ mamahipama pandaꞌ maola pigindiwaꞌwasa wandaf patalogasa sondaꞌ waf buꞌwafi, deiꞌ daoꞌ ipaꞌ apandagala. Deiꞌ main, God atiasi aꞌ nofalepa niꞌi ipaꞌ awasi ananipai. ");
INSERT INTO aoj_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","“Eaꞌ ipaꞌ mamahipama pagiꞌma waf usiꞌifi ma anis epes sandaꞌmepa waf awafi sagaseꞌepa nimanimi akafimi, deiꞌ daoꞌ ipaꞌ apandagala. Deiꞌ main, deiꞌ ipaꞌ pawis nomona maol Godi nope Dembinai nugumafipa. ");
INSERT INTO aoj_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Ipaꞌ mamahipama pagagiꞌma aeꞌi pagape naꞌamba. Anis sandaiwaꞌma pagagiꞌma aeꞌi asondaꞌ basef fafifafi awafi basoꞌaifi ma ipaꞌ. Eaꞌ sandaꞌepa tofalaepama basef awafi ma sagaseꞌepa akafimi nimanimi. Esis sondaꞌepa naꞌambai deiꞌ ipaꞌ pandagala. ");
INSERT INTO aoj_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Nelelemb ipeꞌilimbi bendape andeandeꞌ sonondehepa endilisi. Deiꞌ main? Hiahaom hiami fasimi ipeꞌimi maꞌoh heven. Esis isimba sandaꞌ waf awafi ma ipaꞌ naꞌamba atin siꞌi fowaꞌ anis sandaꞌ waf awafi ma profet amamba mape magaliꞌma ipeꞌi. ");
INSERT INTO aoj_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Ipaꞌ siꞌi sol ama pegatopalopa epes hiasi sagape itapi. Apaꞌ iꞌi sol alamba aꞌ lumbula usihila aꞌ akal, owaꞌatin. Atiasi ipaꞌ pendaꞌal piꞌimama usihil wapani? Owaꞌatin. Sol alambai kuꞌumbili maol akala sondaꞌal, esis a sokwahol lefeꞌ itap atep a sondaꞌal fiꞌifaꞌasol atin. ");
INSERT INTO aoj_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Ipaꞌ siꞌi lam epes hiasi sagape itapi pigihimbaꞌmas. Anagon taun luꞌwagoma wamon nagatoma halafuta ilifi ina nape nandambahoꞌ, owaꞌatin. ");
INSERT INTO aoj_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Epes ina sakata lambeh sopaloꞌambeh haꞌoh belitagw lafelagwa, owaꞌatin. Esis sawamonambeh hatoma belitagw ilifa hogogalaꞌma epes hiasi sagape ipat nomoni. ");
INSERT INTO aoj_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Eaꞌ naꞌamba atin, ipaꞌ pendaꞌ waf usiꞌifi siꞌi lambeh ipeꞌimbihi hagape alihimbiha ma hogogalaꞌma naep esis amam nematawai, sogati waf fasifi ipaꞌ pandaꞌafi ma sogasaꞌma agol ahamepa nagape ilifi luꞌwagol. ");
INSERT INTO aoj_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Ipaꞌ ina aꞌ ukup pendandaꞌ piꞌi aeꞌ afiꞌi ma igaliꞌamona muꞌuli Godi neloma basef amom profet fowaꞌ gani magawalipasafi, owaꞌatin. Aeꞌ ina afiꞌi ma igaliꞌamonam, owaꞌ. Aeꞌ afiꞌi ma esapafef iwatanifa fegataga endilisi. ");
INSERT INTO aoj_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Aeꞌ aꞌipipa endilisi. Basef ifimba fepe fefeꞌma hiahaom magape ilif itapi moloma otagai itap higililam hiꞌilam. Apaꞌ anif basef duꞌwanif amef saꞌusaꞌufi feloma anif basef bandafi fagail nomona buk muꞌuli Godi, ifimba fepe atapif naꞌamba atin fefeꞌma maol hiani Godi netaga nendawalap hiꞌigalan. ");
INSERT INTO aoj_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Naꞌamba iꞌi anin epen negaliꞌamona anif basef kwasalaꞌufa basef ifimba fagape muꞌuli Godi ma anin nihimbaꞌma anis epes daiasa sondaꞌas naꞌamba atin, atiasi agol aman anambai aꞌ gofeꞌ saꞌosaꞌogol ama anamba God nagalaꞌambemagoma. Apaꞌ epen ami nila muꞌuli Godi andeandeꞌma nihimbaꞌma anisa sigagiꞌmana, atiasi anin aꞌ nefaꞌ agol luꞌwagili ma anamba God nagalaꞌambemagoma. ");
INSERT INTO aoj_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Naꞌamba deiꞌ aeꞌ aꞌipipa aꞌi, Ipaꞌ aꞌ ukup pendapoma amom dembami magawalipasa muꞌuli Godi moloma amom dembami Farisi. Iꞌi waf ipeꞌifi usiꞌifi owaꞌ fikilaꞌ waf amamifia, atiasi ipaꞌ ina pefeꞌ piwis nomona maol Godi nope Dembinai nugumafipa ma owagama pigawis anamba anen nagalaꞌambemagoma, owaꞌatin. ");
INSERT INTO aoj_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Ipaꞌ aꞌ pameꞌ basef ifimba amom akupipa mogofaꞌafi fagaꞌias naꞌamba faꞌi, ‘Ipaꞌ owaꞌi peha anin epen negaꞌa. Iꞌi anin neha anin epen negagaꞌ, epen inimba atiasi aꞌ netagama basefa kot.’ ");
INSERT INTO aoj_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Apaꞌ deiꞌ aeꞌ aꞌipipa aꞌi, Epen ami okom aꞌ wandafuma anin sahin owan ananisi, anin atiasi aꞌ netagama basefa kot. Eaꞌ epen ami niꞌipa anin sahin owan ananini niꞌi, ‘Inaꞌ epen falafini’, anis sondaꞌ kotimana amom Juda dembami mugumafi koti. Apaꞌ iꞌi anin epen niꞌipa anin daian niꞌi, ‘Inaꞌ okom nagahena endilisii’, epen inimba nefeꞌ wambel awambili nif fandif fagapomani. ");
INSERT INTO aoj_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","“Iꞌi ipaꞌ piꞌi pindalali ma God pendaꞌ ofa felefeleꞌ ma belita atamba sondolalima Godatai ma iꞌi ipaꞌ ukup pegapoma anef waf awafi ipaꞌ pandaꞌafa anis ukup numbutipa ipeꞌi, pendaꞌas naꞌamba. ");
INSERT INTO aoj_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","Ataꞌ pekwaha mafis gwaꞌaisi paꞌi pindalalima Godasi sondaꞌoh felefeleꞌma belita atamba, ipaꞌ ataꞌ pitanima pefeꞌ penandona basef peloma epes isimba pandaꞌmas waf awafii. Ama eaꞌ, daoꞌ pifiꞌi pefaꞌ ofa pefeꞌ pindalali peseꞌanas God. ");
INSERT INTO aoj_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Iꞌi anin epen niꞌi nendaꞌ kotimipai, nelomepa pefeꞌ ma ataꞌ pegalo ufiaꞌwa, ipaꞌ kwafalis peseꞌana nembel pewalapa isimba piꞌias peloman, ama aꞌ owaꞌatin. Naꞌamba epen inimba aꞌ nendaꞌepa pendaꞌ basefa isimba ma amom jas mondaꞌepa pefeꞌma polisman, eaꞌ mondaꞌepa pendaꞌ kalabus. ");
INSERT INTO aoj_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Aeꞌ aꞌipipa endilisi, ipaꞌ ina atiasi pekwaha ipat atamba sandaꞌ kalabusatai ulal, owaꞌ. Ama pegwa hiahaom luꞌwami saꞌumi ma wiaf ipeꞌifi hiꞌilaf, daoꞌ, aꞌ pefeꞌ.” ");
INSERT INTO aoj_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Jisas naꞌipam wapani naꞌi, “Ipaꞌ pameꞌef eaꞌ basef ifimba fowaꞌ fagatagai. Ipaꞌ ina pendaꞌ waf awafi ma soꞌa waola anis amam nematawa daindaias, owaꞌi. ");
INSERT INTO aoj_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Apaꞌ deiꞌ aeꞌ aꞌipipa naꞌamba aꞌi, iꞌi anona aman aꞌ niti anoꞌw nemataꞌw, ama nembel ananimbili behafema akoꞌw, aman anamba eaꞌ nandaꞌ waf awafi soꞌa waulafi ma nembel ananimbili.” ");
INSERT INTO aoj_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Jisas naꞌipam naꞌamba eaꞌ naꞌipam anif basef waminif atin naꞌi, “Iꞌi naep ipeꞌipi pagape lagof kwahisigufi pendaꞌepa pewa ma waf awafi, pigip pikwahip. Iꞌi alop duꞌwanip ipeꞌipi pogofaꞌ akafimi, amamba aom kwasakwasala. Apaꞌ ina andeandeꞌma esis sogakwaha alop siꞌip ipeꞌipi hiꞌigalap pogafeꞌ wambel awambili hel nif fagapoma, owaꞌ. Amambai atiasi aꞌ pefaꞌ akafimi awami luꞌwami aꞌowaꞌ. ");
INSERT INTO aoj_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","“Apaꞌ iꞌi lagof kwahisigufi fondaꞌepa pewa ma waf awafi, petopaꞌagof pekwahogof. Iꞌi alop duꞌwanip ipeꞌipi pogofaꞌ akafimi, amamba aom kwasakwasala. Apaꞌ ina andeandeꞌma esis sogakwaha alop siꞌip ipeꞌipi hiꞌilap pogafeꞌ wambel awambili hel nif fagapoma, owaꞌ. Amambai akafimi luꞌwami endilisi aꞌowaꞌ. ");
INSERT INTO aoj_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Basef ifimba fowaꞌ fagatagai faꞌi, iꞌi anona aman niꞌi niliꞌamona wauluꞌmana ananiꞌwi, anen ataꞌ niꞌi anif basef nondaꞌef fil anop okwatip nosoꞌakw ma nogatopaꞌ dasoꞌama. ");
INSERT INTO aoj_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Apaꞌ aeꞌ aꞌipipa aꞌi, iꞌi nemataꞌw akwamba owaꞌ kondaꞌ waf awafi soꞌa waulafia, ma waulunamaꞌw nogakwahoꞌw dowaf, anen nandaꞌ akoꞌw kwandaꞌ waf awafi soꞌa waola anom amam daindaiam. Eaꞌ aman ami nagasoꞌ nemataꞌw fowaꞌ anona aman nagaliꞌamonaꞌwi, aman anamba nagiꞌ nagasoꞌakwi wapani nandaꞌ soꞌa waola nemataꞌw akwamba. ");
INSERT INTO aoj_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Anif basef fowaꞌ pagameꞌafi fagaꞌias naꞌamba faꞌi, ‘Basef ifimba banagafi pagaꞌi endilisi atisafi, ipaꞌ ina aꞌ pesambalif, owaꞌi. Basef ifimba pigaꞌi endilisi atisafi, pigiꞌma basef ifimba dondoꞌafi a pendaꞌas siꞌi ipaꞌ pagaꞌiasa naep Dembinaii. ");
INSERT INTO aoj_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Apaꞌ deiꞌ aeꞌ aꞌipipa, ipaꞌ ina a piꞌi basef banagafi endilisi gani ilif, owaꞌi. Eaꞌ ina piꞌi ilif hevena pegewaꞌ banaga anif basef basoꞌafi, owaꞌi. Deiꞌ main, gani ilif heven sia buꞌwani dembinai Godi nagapoma. ");
INSERT INTO aoj_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Eaꞌ naꞌamba atin ina piꞌi itap apaꞌe dowaf pegewaꞌ banaga anif basef, owaꞌi. Itap apaꞌe pandahama siꞌi anin tebol saꞌwini God nagahapona boꞌwagahani. Eaꞌ naꞌamba atin ipaꞌ ina piꞌi Jerusalema pegewaꞌ banaga anif basef ipeꞌifi, owaꞌi. Jerusalem anamba taun wambel luꞌwagoma dembinai kingi. ");
INSERT INTO aoj_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Ipaꞌ ina pewaꞌ banaga basef ipeꞌifi piꞌi balagah ipeꞌigahi, owaꞌi. Deiꞌ main, ipaꞌ ina laꞌifipama pendaꞌ anif auf ama balaga ipeꞌigai fegataga afitiga aꞌa alialiga, owaꞌatin. ");
INSERT INTO aoj_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Ipaꞌ piꞌias pindaꞌi ahoꞌ aꞌa owaꞌ. Pindaꞌi ifimba atif. Apaꞌ basef wataniaifi, ifimba fataga Satan atona. ");
INSERT INTO aoj_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Ipaꞌ pameꞌef eaꞌ basef ifimba fowaꞌ fagatagai faꞌi, ‘Iꞌi ipaꞌ pepaꞌ pegaloma anisa sogahepa naep aꞌa sogatamepa nalelef, ipaꞌ pegwamas pehas wapani pendaꞌas sondagwama atin.’ ");
INSERT INTO aoj_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Apaꞌ aeꞌ aꞌipipa, ipaꞌ ina pegwama epes sondaꞌ ipaꞌ aupai, owaꞌi. Iꞌi anin epen mamahina negahepa aomb ineꞌimbi waꞌol, pendambema nehepa waꞌol wapani. ");
INSERT INTO aoj_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Eaꞌ iꞌi anona aman nondaꞌ kotimipa niꞌi nogofaꞌ siaogw ipeꞌigwi, ipaꞌ peseꞌana sagegw ipeꞌigwi wapani. ");
INSERT INTO aoj_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Iꞌi anona aman dindinapina ma pefeꞌ pegalomana anagon feleꞌ siꞌi nogota atotota, daoꞌ ipaꞌ andeandeꞌma ataꞌ pefeꞌ pelomanago nohotagw biagw laogw wapani. ");
INSERT INTO aoj_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Apaꞌ iꞌi epen mamahina nefalepa ma anis maefah, daoꞌ peseꞌasas. Apaꞌ iꞌi anin epen niꞌi negewaolamepa wiafi, daoꞌ ipaꞌ ina pindaiwaꞌman pesambala basef ananifi, owaꞌi. ");
INSERT INTO aoj_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Ipaꞌ pameꞌef eaꞌ basef ifimba fowaꞌ fagatagai faꞌi, ‘Ipaꞌ peseꞌasa nelelemb epes isimba sagape felefeleꞌma ipeꞌi, apaꞌ ipaꞌ ukup wandafipa bousi ipeꞌisi.’ ");
INSERT INTO aoj_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Apaꞌ aeꞌ deiꞌ aꞌipipa anif basef daif aꞌi, ipaꞌ ukup pipila bousi ipeꞌisi peseꞌas nelelemb, pendabetena God nogatopalopas isimba sandaꞌmepa waf awafi. ");
INSERT INTO aoj_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Ipaꞌ pendaꞌas naꞌamba ma pegape awasi Godi ahamapa nagape heven ilifi. Anen nandaꞌ awin alipini nataga nape heven ilifa nagatopalopa epes buꞌwasi saloma epes sandaꞌ waf awafii wapani. Anen nandaꞌ asaf falai ma epes isimba sagape hililiꞌi saloma isimba owaꞌ sogape hililiꞌia wapani. ");
INSERT INTO aoj_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Iꞌi ipaꞌ ukup pigaila epes isimba ukup pagapagaila ipeꞌi atis, atiasi pefaꞌ hiahawes fasisi maisa waf afamba? Owaꞌatin. Amom amamba mandaꞌ waf awafii mogofaꞌ takisi mandaꞌ waf afambai atef. Eaꞌ anom daiam mandaꞌ waf awafii, amom wapani mandaꞌ waf afambai atef. Amom matopalopa esis isimba nomonas sagapoma esis atisii. ");
INSERT INTO aoj_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Iꞌi ipaꞌ piganifela isimba alipisi atis ipeꞌisi, atiasi ipaꞌ petaga pikilaꞌ anisa waf mamahefa fasifi? Owaꞌatin. Esis sogololama Godi sandaꞌas naꞌamba atin. ");
INSERT INTO aoj_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Eaꞌ ipaꞌ pendape hililiꞌ endilisi siꞌi ahamepa ipeꞌinai God nagape heven ilifi. ");
INSERT INTO aoj_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Ipaꞌ solawaipa. Owaꞌi pendaꞌ waf buꞌwafi ipeꞌifi ma naep esis epesi ma sogatilipaea, ma sogaꞌi ipaꞌ epes buꞌupai ma sogasaꞌma agof ipeꞌigufia, owaꞌi. Iꞌi ipaꞌ pendaꞌas naꞌamba, ipaꞌ ina atiasi pefaꞌ anis hiahawes fasisi ma ahamepa God nagape heveni, owaꞌatin. ");
INSERT INTO aoj_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Iꞌi ipaꞌ piꞌi pegatopalopa anis epes isimba kwahusi, ipaꞌ inaꞌ apiꞌipa anis daias, owaꞌi. Ipaꞌ ina pendaꞌas siꞌi waf afamba amom mambasoꞌas magaꞌi malogof biagufi mofapula alelefi batagw maꞌipas sagaliꞌ, owaꞌi. Amom mandaꞌam ifagw sandaꞌ lotuwagwi a anamba ufiawa dawalegefa naep epesi sogati amom sogasaꞌma agof amamugufi luꞌwagof. Owaꞌ hapaimi. Aeꞌ aꞌipipa endilisi, atiasi God owaꞌatina nogasoꞌama hiahawes fasisi amam amambaea, owaꞌatin. Hiahawes isimba amamisi naꞌamba. Epes isimba sagasaꞌma agof amamugufi eaꞌ maꞌwis isimba atis. ");
INSERT INTO aoj_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Apaꞌ iꞌi ipaꞌ pegatopalopa epes isimba naꞌambaisi kwahusi, ipaꞌ pembahoꞌas pendaꞌas naꞌamba. Lagol mamahogola gondaꞌasi, lagol waꞌagol ina aꞌ gogawas, owaꞌatin. Eaꞌ naꞌamba atin, waf afambai ipaꞌ pendaꞌafa pegatopalopa anisi, ipaꞌ ina piꞌias mehip anis daias someꞌepa ma pendaꞌas, owaꞌi. ");
INSERT INTO aoj_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Ipaꞌ pembahoꞌas pendaꞌas. Ama Ahamepa ipeꞌinai nagati hiahawes isimba sape sandambahiꞌi eaꞌ anen atona atiasi nogwamepas ipaꞌ. ");
INSERT INTO aoj_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Nemaf mamahefa ipaꞌ pendabeten, ipaꞌ ina pendaꞌam siꞌi waf afamba amam amamba magambasoꞌasi magaꞌi malogof biagufi mandaꞌafi, ma mulutu atin nomon ifagw esis Juda sandakolasugwi a ufiawa luꞌuwai dawalegef, ama epes sogatolom, owaꞌi. Aeꞌ aꞌipipa endilisi, ipaꞌ, amom anaf God ina aꞌ nogwamama hiahawes fasisi ma waf afambai, owaꞌatin. Epes isimba asagatolomi eaꞌ maꞌwis isimba atis. ");
INSERT INTO aoj_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Apaꞌ ipaꞌ nogota atamba piꞌi pendabeten, piwis ifagw nomon pewalo utagw eaꞌ pendabetena God ahamepa ipeꞌinai, anen nape anamba dambahiꞌigima. Anen nagati hiahawes sape sandambahiꞌi ma bola nogagwamipai beten. ");
INSERT INTO aoj_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Apaꞌ afamba ipaꞌ pendabeten, ipaꞌ ina pendabeten dowaf siꞌi epes isimba sogololama Godi sandaꞌam, owaꞌi. Esis saꞌi sondabeten launi ma atiasi God nogameꞌas. Owaꞌ owaꞌatin, God ina nameꞌas. ");
INSERT INTO aoj_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Apaꞌ ipaꞌ ina pigiꞌma waf asasifi, hapaifi. Ahamepa God nagape ilifi nogawa eaꞌ ma hiahawes akipai. Nogota atamba ipaꞌ ataꞌ owaꞌ pihaliꞌanamasa, anen aꞌ nagawas eaꞌ. ");
INSERT INTO aoj_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Ipaꞌ pendabeten naꞌamba piꞌi, Ahamapa apeꞌinai nagape heveni, apaꞌ maꞌi agol ineꞌigili gondape hililiꞌ ma hiasi sogasaꞌma agol ineꞌigili luꞌwagol. ");
INSERT INTO aoj_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Apaꞌ maꞌi nemaf afamba buꞌwafi fetaga ma epes hiasi sogawis nomona maol ineꞌini nope Dembinai nugumafias. Waf buꞌwafi esis ineꞌisi sagailaf heveni, apaꞌ maꞌi milaf itap apaꞌe wapani naꞌamba atin. ");
INSERT INTO aoj_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Deiꞌ inaꞌ neseꞌapa gwaꞌaisi sondahama apaꞌ ma nemaf afaꞌe. ");
INSERT INTO aoj_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Inaꞌ nekwahomasa waf awafi apeꞌifi okom moseꞌenaf siꞌi apaꞌ magakwahomasa waf awafi anis daias sandaꞌmapafi ukup pagasoꞌapaf. ");
INSERT INTO aoj_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Inaꞌ owaꞌi niliꞌapa mefeꞌma hiahaom ahifimi mogogwamba apeꞌia. Owaꞌ hapaimi. Netagwahepa ma aman aunai. Anamba inaꞌ nagalaꞌambemagoma noloma banagami ineꞌimi moloma hiahaom mogogalaꞌi ineꞌimi, amamba ineꞌimi atom dondol lifilafi. Endilisi. ");
INSERT INTO aoj_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Eaꞌ Jisas naꞌipam wapani naꞌi, “Iꞌi ipaꞌ pekwahomasa waf awafi anis daias sandaꞌmepafi ukup peseꞌepafa, andeandeꞌma Ahamepa nagape heveni okom mogasoꞌanafa ipaꞌ wapani. ");
INSERT INTO aoj_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Apaꞌ iꞌi ipaꞌ owaꞌ ukup peseꞌepa waf awafi anis daias sandaꞌmepafia, Ahamepa nagape heveni ina atiasi okom mosoꞌanafa ipaꞌ, owaꞌatin. ");
INSERT INTO aoj_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Nimaguf mamahifa ipaꞌ pegakwaha gwaꞌaisi, ina pendaꞌam siꞌi amam amamba mambasoꞌmas magaꞌi malogof biagufi mandaꞌami ma mandaꞌ amagah amamumi awasim, owaꞌi. Amom mandaꞌ amagah aom naꞌamba ma amam nematawa sogatulumi sogawa sogaꞌi amom mogakwaha gwaꞌaisii. Aeꞌ aꞌipipa endilisi amom mofaꞌam eaꞌ hiahaom amamba ma dagala amamini. Epes isimba sagati waf afambai, eaꞌ maꞌwis isimba atis. ");
INSERT INTO aoj_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Apaꞌ nemaf mamahefa ipaꞌ pegakwaha gwaꞌaisi ma pendabetena God, ipaꞌ pesaꞌof pendaꞌ wel pindisa balagah pihiꞌagah. ");
INSERT INTO aoj_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Ama anis epes daias ina sogawa ipaꞌ pagakwaha gwaꞌaisi, owaꞌ. Pendaꞌas naꞌamba ma Ahamepa nape nandambahiꞌi anen atona nogawepa. Anen nagati hiahawes sape sandambahiꞌi, ma bola nogagwamipai beten. ");
INSERT INTO aoj_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Ipaꞌ ina aꞌ petama hiahaom buꞌwami atom ipeꞌimi bimbilam itap anaꞌe, owaꞌi. Anis sandaꞌ wali sapisila ifagw sawis sagakwalopami, bamagof fomamam magahambombagama waimba nagasagihami. ");
INSERT INTO aoj_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Apaꞌ aeꞌ aꞌipipa petama hiahaom fasimi ipeꞌimi moꞌomepa gani heven. Anamba bambagufi totoloh ina mototopaꞌam a waimba ina nasagiham, owaꞌatin endilisi. Eaꞌ sandaꞌ wali ina aꞌ suwis sakwalopam, owaꞌatin. ");
INSERT INTO aoj_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Wambel mamahembela hiahawes fasisi ipeꞌisi sagaꞌoma, eaꞌ wambel ambalemba atembel anaf ukup ipeꞌipi wapani pegapoma. ");
INSERT INTO aoj_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Naep nomon ukup ipeꞌipi siꞌi lama alop siꞌip ipeꞌipi. Iꞌi ukup ipeꞌipi beꞌep pepe, eaꞌ alop siꞌip ipeꞌipi pogalaꞌ hiꞌilap. ");
INSERT INTO aoj_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Apaꞌ iꞌi ukup ipeꞌipi awasip, atiasi alop ipeꞌipi hiꞌilap eaꞌ akutina. Eaꞌ naꞌamba atin, iꞌi lam amamba magape ukup ipeꞌipi nomoni siꞌi akot atona, atiasi akot anamba eaꞌ luꞌuna aꞌowaꞌ. ");
INSERT INTO aoj_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Ina anin epen nandaꞌ maoli laꞌifin nihapila maol biafina amam dembami biam, owaꞌatin. Naꞌamba okom mila anona, anona aꞌ nesambalona. Eaꞌ naꞌamba atin, ipaꞌ ina aꞌ laꞌifipa pepe lafela God noloma ugai moni, owaꞌatin. ");
INSERT INTO aoj_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Eaꞌ aeꞌ aꞌipipa aꞌi ipaꞌ ina aꞌ nomonas solasefeꞌ hiahiasa ambagof ipeꞌigufi piꞌi, Apaꞌ ataꞌ meaꞌ main? A meaꞌ embel maimbel? Owaꞌi. Ipaꞌ ina aꞌ nomonas solasefeꞌ ma alop ipeꞌipi piꞌi, Atiasi apaꞌ mondaꞌ main mombahoꞌ alop apeꞌipi? Aꞌi ambagufi alop asikilaꞌ gwaꞌaisii luwaguf? ");
INSERT INTO aoj_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Ipaꞌ ataꞌ ukup pepoma amiguf. Afof owaꞌ fondaꞌ aofah fowa gwaꞌaisi maisa, owaꞌ fotoma gwaꞌaisi fimbilasa. Afof ifagw owaꞌatina fotama gwaꞌaisi sogaꞌoh, eaꞌ satamam sofaꞌam maꞌoh ifagw gwaꞌaisiagwi, owaꞌatin. Apaꞌ Ahamepa ipeꞌinai nagape heveni, anen nasoꞌagof gwaꞌaisi. Apaꞌ ipaꞌ epes pikilaꞌ amiguf agwafomba. ");
INSERT INTO aoj_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Ipaꞌ atiasi ami laꞌifin nomonas solasefeꞌ lawisa nigiwatania anef nemaf wapani ma ambal ananili logape nogota laota wapani? Owaꞌatin. ");
INSERT INTO aoj_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Deiꞌ maina nomonas ipeꞌisi salasagafeꞌ aꞌowaꞌ ma luwaguf mais? Ipaꞌ ataꞌ ukup pepoma afis main sagalo andoꞌi. Esis sataga salo luꞌwis saꞌimama? Esis ina sandaꞌ maol, ina sandaꞌ luwaguf mais, owaꞌatin. ");
INSERT INTO aoj_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Apaꞌ aeꞌ aꞌipipa fowaꞌ anona aman hiahaom hiamunai Solomon nandaꞌ sosaf hianai ma luwaguf ananimi owaꞌ, sosaf ananifi ina fasif siꞌi afis isimba, owaꞌatin. ");
INSERT INTO aoj_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Ahoꞌ, otalef afalemba deiꞌ ataꞌ fetawa aof ama naman atef sotopaꞌalef sokwahelef fefeꞌ nif. Otalef afalemba falafilifi God nofaloꞌmalef. Apaꞌ ipaꞌ amam nematawa pikilaꞌ otalef afalemba. Eaꞌ deiꞌ ipaꞌ pagahapifa basef Godi kwasakwasalai, pendegawa endilisi anen nugumafipa wapanii. ");
INSERT INTO aoj_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Eaꞌ ipaꞌ ina ukup pelapefeꞌ hihip aꞌowaꞌ piꞌi, ‘Atiasi apaꞌ meaꞌ main? A meaꞌ embel ani? A mondaꞌ luwaguf ani? Naꞌambai owaꞌi. ");
INSERT INTO aoj_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Epes sagape itapi sogolalama Godi ukup malamondafeꞌ aꞌowaꞌ ma sogolaoma hiahaom amambai hiami. Apaꞌ Ahamepa ipeꞌinai nagape heveni anen nogawa eaꞌ hiahawes mamahisa akipai. ");
INSERT INTO aoj_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Apaꞌ ipaꞌ ataꞌ ukup piliꞌ pelapelaoma waf usiꞌifi buꞌwafi feloma pigawis nomona maol Godi nope Dembinai nugumafipa piliꞌ, daoꞌ aꞌ neseꞌepa hiahawes isimba ipaꞌ wapani. ");
INSERT INTO aoj_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Eaꞌ ipaꞌ ina nomonas sopoma hiahawes sogataga namani, owaꞌ. Nemaf namanifi fendapoma naman atef, ama hiahawes mamahisa sogataga namani. Hiahaom nimanimi akafimi magatagama nimaguf daindai mandahama nimaguf ifimba atif dondo. Ipaꞌ inaꞌ aꞌ nomonas iwanis solasefeꞌ, owaꞌ. ");
INSERT INTO aoj_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Ipaꞌ ina aꞌ pewaloga anis epes siꞌi anona jas dembinai nagawaloga basef kot luꞌunai, owaꞌi. Ama anaf God ina nowalogepa, owaꞌ. ");
INSERT INTO aoj_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Waf ipaꞌ pandaꞌafa pagawawaloga anis epesafi, anaf waf afamba atef God aꞌ nondaꞌmepaf ipaꞌ wapani. Ikwaf afamba atef ipaꞌ pandaꞌaf pagawalogasafi nogwaf nowaloga ipaꞌ. ");
INSERT INTO aoj_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Deiꞌ maina ipaꞌ pagati usan saꞌusaꞌuni nagape naep sahin owan ipeꞌisii, apaꞌ ipaꞌ owaꞌ pegawa hapataf luꞌunai nagape naep ipeꞌipia? ");
INSERT INTO aoj_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Deiꞌ maina ipaꞌ ataꞌ paliꞌ paꞌipa alipisi pagaꞌi, ‘Owame, aeꞌ aꞌi igimina usan saꞌuni nagape naep ineꞌipii.’ Apaꞌ hapataf luꞌunai nape naep ineꞌipi. Naꞌambai owaꞌi. ");
INSERT INTO aoj_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Ipaꞌ malogof biagufipai pagambasoꞌami. Ipaꞌ ataꞌ piliꞌ pigi usan hapataf luꞌunai nagape naep ipeꞌipii ama piti andeandeꞌ daoꞌ, aꞌ pigimana usas saꞌusi sagape naep alipisi ipeꞌisii.” ");
INSERT INTO aoj_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Eaꞌ Jisas naꞌipam anif basef waminif atini wapani naꞌi, “Hiahawes buꞌwasi hililiꞌi, isimba ipaꞌ ina pesoꞌ nombagw, owaꞌi. Eaꞌ ipaꞌ ina pekwaha aolep amamba fasifasimi ipeꞌimi mefeꞌma bogof, owaꞌi. Naꞌamba fofaꞌasa aolep amamba fasifasimi boꞌwalef afafilifi, eaꞌ nomabagw gwehepa gweaꞌepa. ");
INSERT INTO aoj_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Ipaꞌ pihaliꞌ God atiasi nogaseꞌepa hiahawes. Isimba ipaꞌ pala pigalaomasi atiasi aꞌ pitilis. Ipaꞌ peha uta, atiasi God nuwisiꞌmipata ipaꞌ. ");
INSERT INTO aoj_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Deiꞌ main, epes ami sogahaliꞌ Godi, atiasi sofaꞌ maefah. Epen ami nelaꞌ negelaoma hiahawasi, atiasi nigatilisi. Eaꞌ epen ami negaha utai, atiasi God nuwisiꞌmanata anin. ");
INSERT INTO aoj_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Iꞌi anin awani negahaliꞌ ahamanama anis gwaꞌaisi, atiasi ahaman nosaꞌma anom otam nosoꞌanam? Owaꞌatin. ");
INSERT INTO aoj_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Iꞌi anin awani negahaliꞌ ahamana nogasoꞌan anol aol, anen atiasi ina nosoꞌan anol ul awali, owaꞌatin. ");
INSERT INTO aoj_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Eaꞌ ipaꞌ amam nematawa aupai pagasoꞌasa hiahawes fasisi atisa awasi ipeꞌisii, Ahamepa ipeꞌinai nagape heveni anen wapani atiasi nosoꞌasa hiahawes fasifasisi isimba sagahaliꞌ anini. ");
INSERT INTO aoj_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Waf maif ipaꞌ paꞌi esis sondaꞌmepaf ipeꞌi, ipaꞌ pendaꞌmasaf naꞌamba atin. Basef ifimba kofagefa ma muꞌuli Godi nagaꞌipa Mosesani naloma basef God fowaꞌ nagaꞌipa amom profet mandaꞌafi. ");
INSERT INTO aoj_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Ipaꞌ pefeꞌ piwis uta saꞌutai buꞌutai. Deiꞌ main, anoꞌw ufiaꞌw kwafeꞌ kwagawis wambel awambili heli alihiꞌw aꞌowaꞌi uta wapani alihitai. Eaꞌ hiasi amam nematawa safeꞌ saila ufiaꞌw akwamba. ");
INSERT INTO aoj_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Apaꞌ uta ma ufiaꞌw kwafeꞌ kwagawis wambel sagape namisagoma ina alihita aꞌowaꞌ, owaꞌatin. Wapaꞌmota. Wambel ambalemba sagape beꞌes andeandeꞌ lifilafima. Ufiaꞌw akwamba ahifiꞌw aꞌowaꞌ ma sogafeꞌ. Amam nematawa atona atin esis eaꞌ isimba atis sati ufiaꞌw akwamba sailaꞌw. ");
INSERT INTO aoj_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Ipaꞌ solawaipa andeandeꞌma amom profet mambasoꞌam maꞌi mogowalipasa basef Godi. Amom mandaꞌ uhuf mafiꞌi mambasoꞌmepa mataga patolom andoꞌ atogon mape boꞌom saꞌumbilim siꞌi sipsip. Apaꞌ ukup amamipi nomon awep endilisi ma ipaꞌ maꞌi mohambombagepa mehepa siꞌi nombagw wandafugwi. Eaꞌ ipaꞌ ina pemeꞌam, owaꞌi. ");
INSERT INTO aoj_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Ipaꞌ piti waf amamifi fetaga fendawalap siꞌi saꞌutip pagail lawahi, apegawa waf amamifi beꞌef aꞌa awef. Epes ina sola saꞌutip wainip mandelef afalemba higatagulifi, owaꞌatin. A ina sola saꞌutip fikip mandelef awalifi, isimba wapani, owaꞌ. Eaꞌ waf awafi amamifi fataga fandawalap awef siꞌi saꞌutip awapi. ");
INSERT INTO aoj_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Eaꞌ naꞌamba atin lawah hiagahi anogah buꞌugahi hogola saꞌutip buꞌwapi gwaꞌaipi, apaꞌ lawah augahi hail hola saꞌutip awapi numbutipi. ");
INSERT INTO aoj_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Lawah buꞌugahi ina a hail hola saꞌutip gwaꞌaipi, a lawah aogahi ina a hil hola saꞌutip buꞌwapi, owaꞌatin. ");
INSERT INTO aoj_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Lawah hiagahi owaꞌ higail hogola saꞌutip gwaꞌaipia, agahemba esis salagah saofagah nif luꞌwafi. ");
INSERT INTO aoj_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Ipaꞌ pati waf amamifi fetaga fendawalap siꞌi saꞌutip pagail lawahi, waf amom profeti beꞌef aꞌa awef. ");
INSERT INTO aoj_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Ipaꞌ ina piꞌi amam nematawa hiasi sofala aeꞌ sagaꞌi Dembiwai, piꞌi atiasi sofeꞌ sogawis nomona maol Godi nope Dembinai nugumafias, owaꞌatin. Epen ami nagiꞌma okom Ahamai nagape heveni ma nigailami, anin atin atiasi nuwis heven. Anis daias owaꞌatin. ");
INSERT INTO aoj_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Nemaf afamba atiasi amam nematawa hiasi sifiꞌi sofala aeꞌ siꞌi, ‘Apaꞌ magawalipasa basef Godi siꞌi profet amamba magawalipas eaꞌ maꞌi agol ineꞌigili matofa amom ambagof awami! Apaꞌ maꞌi agol ineꞌigili mandaꞌ hiahaom banagami siꞌi God nandaꞌami!’ ");
INSERT INTO aoj_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","“Ama nemaf afamba owaꞌ, aeꞌ iwalipas iꞌipas alihis naꞌamba iꞌi, aeꞌ ina egawa ipaꞌ kwasakwasala, owaꞌ. Ipaꞌ epes pandaꞌ waf awafii delefata pekwaha aeꞌ, eaꞌ foꞌo. ");
INSERT INTO aoj_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Epes ami someꞌ basef aeꞌafi ma sigiꞌmif silif, esis siꞌi epen gawaini nalaꞌ ipat ananitai togotawa banagota itap apamba otambaipa banagapi. ");
INSERT INTO aoj_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Aꞌi owaꞌ asaf luꞌunai nalai, embel bataga, fufin banagonai naluwi, amamba makotoꞌma ipat atamba apaꞌ ina tato, owaꞌatin. Epen inimba aꞌ nala otamba luꞌwami mowala itap mosahopata banagota totawa. ");
INSERT INTO aoj_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Apaꞌ epen ami nameꞌ basef aeꞌafi ma anin owaꞌ nigiꞌmifa, anen siꞌi anona aman okom magahanai. Anen nalaꞌ ipat ananitai tatoma ilifa koꞌonaga atoga. ");
INSERT INTO aoj_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Ama aꞌi owaꞌ, asaf luꞌunai nalai, embel mataga, eaꞌ fufin naluwi banagona. Amamba aꞌi owaꞌ maola ipat atamba aꞌ tondokwaef towa. Ipat atamba tato taꞌoh kwapeteꞌ endilisi aota.” ");
INSERT INTO aoj_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Nogota atamba Jisas naꞌi basef ifimba laufi ma hiꞌalef, esis sameꞌ basef ananifi eaꞌ gogolalasis kwapeteꞌ endilisi. ");
INSERT INTO aoj_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Anen ina nawalipas siꞌi amam falafumi magaꞌipas, owaꞌ. Anen nawalipas dindinip naloma banagami naꞌamba atin siꞌi amom agufumi. Anen banagona aꞌowaꞌ nikilaꞌ. Amam dembami magawalipasa muꞌuli Godi ina mawalipas naꞌamba siꞌi anen, owaꞌ. ");
INSERT INTO aoj_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Eaꞌ Jisas nakwaha halaf afamba nilianai, amam nematawa hiasi sagiꞌmana safeꞌ. ");
INSERT INTO aoj_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Owaꞌ, anona aman aowas aunai nandaꞌ alop ananipi pagambuꞌwi nafiꞌi felefeleꞌma Jisas nindiwa nembawa notawa felefeleꞌ ma anen naꞌi, “Dembinai, iꞌi inaꞌ niꞌi ahoꞌ, netopalope ma egataga boꞌowe.” ");
INSERT INTO aoj_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Eaꞌ Jisas nando lagol nasagol alop aman anambai naꞌipana naꞌi, “Aeꞌ aꞌi ahoꞌma inaꞌ negataga boꞌwena.” Eaꞌ deiꞌ atef aowas anamba aunai nandaꞌ alop pagambuꞌwi nakwahona eaꞌ boꞌona. ");
INSERT INTO aoj_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Eaꞌ Jisas naꞌipana naꞌi, “Ina aꞌ nefeꞌ niꞌipa anin epen niꞌi aeꞌ andaꞌena amboꞌwena, owaꞌi. Inaꞌ foꞌo nihimbaꞌmana alop ineꞌipi ma aman anamba pris. Eaꞌ neseꞌana hiahaom amamba anen nondolalima God eaꞌ inaꞌ ninifelona ma nagataga boꞌwena siꞌi muꞌuli ananini fowaꞌ Moses nagaꞌipasani nagaꞌi. Ama amam nematawa hiasi sitilina sogogawa aowas ineꞌini ahiꞌalan.” ");
INSERT INTO aoj_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Jisas nafeꞌ wambel Kaperneam eaꞌ anona soldia dembinai nape. Anen dembinai ma nugumafi amom soldia hiami 100-pelaim. Eaꞌ nafiꞌi nahaliꞌ Jisas dindinip naꞌi, ");
INSERT INTO aoj_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Dembinai, anona aman nandaꞌme maoli aowas nandaꞌana naꞌoh ipat ananitai. Boꞌwagahi lagof sagaꞌ sailana. Alop ananipi akep mahana kwapeteꞌ.” ");
INSERT INTO aoj_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Eaꞌ Jisas naꞌipana naꞌi. “Aeꞌ atiasi efoꞌo endaꞌana boꞌona.” ");
INSERT INTO aoj_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","9","Eaꞌ dembinai anamba soldia naꞌipana naꞌi, “Aeꞌ ina aman buꞌuwai ma inaꞌ nefoꞌo negawis ipat aeꞌatai, owaꞌ. Inaꞌ nindaꞌi basef atif, bola anen boꞌona. Deiꞌ main, aeꞌ ape lafela anom soldia dembami mumafi maseꞌe maol. Eaꞌ ape ilifa anom soldia aeꞌami imafiam. Igaꞌipa anona igaꞌi, ‘Inaꞌ foꞌo’, nameꞌe nafeꞌ. A igaꞌipa anona igaꞌi, ‘Inaꞌ fiꞌi’, nameꞌe nafiꞌi. Eaꞌ igaꞌipa anamba agol akanai nandaꞌme maoli igaꞌi, ‘Inaꞌ daꞌa maol inimba’, anan nameꞌe nandaꞌan. Inaꞌ dembinai. Eaꞌ aowas inimba atiasi nemeꞌ basef ineꞌifi aꞌ nefeꞌ. Deiꞌ inaꞌ nindaꞌi atin, bola anen boꞌona.” ");
INSERT INTO aoj_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Eaꞌ Jisas nameꞌ basef ananifi okom malamafeꞌ naꞌipa amam nematawa hiasi sagagiꞌma anini naꞌi, “Endilisi atis aeꞌ aꞌipipa! Soldia dembinai anamba anen ina ipaꞌ Israelinai. Owaꞌ deiꞌ anen nahapifa aeꞌ. Owaꞌ anona aman Israelinai nohapifi naꞌambaea, owaꞌatin. Anen nikilaꞌ ipaꞌ Israela nagahapifi banagambel. ");
INSERT INTO aoj_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Endilisi aeꞌ aꞌipa ipaꞌ Juda hipai, ipaꞌ ina aꞌ ukup piꞌi ipaꞌ atipa pefeꞌ piwis anamba God nagalaꞌambemagoma, owaꞌ. Amam nematawa hiasi daias sifiꞌi gani awin nagatafima nowala nagasoꞌma, isimba sofeꞌ sogawis anambai. A sofeꞌ suwis soloma dembami bafapepa ipeꞌimi Juda, Abrahami Aisak a Jekop, sope atifigin seaꞌ gwaꞌaisi solomam. ");
INSERT INTO aoj_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Apaꞌ ipaꞌ Juda hipai owaꞌatin. God nandondomba anamba anen nagalaꞌambemagoma ma ipaꞌ pigawis, apaꞌ owaꞌatin. Anaf anen nogaloꞌma ipaꞌ niꞌipipa niꞌi pefeꞌ wambel awambili owamb atona nagapoma. Eaꞌ pemeꞌ akafimi luꞌwami pendaꞌ nalelef ipeꞌimi tilili talalaꞌ pepe.” ");
INSERT INTO aoj_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Eaꞌ Jisas naꞌipa soldia anamba dembinai naꞌi, “Inaꞌ aꞌ foꞌo. Inaꞌ naꞌi aeꞌ laꞌifiwai ma egatopalopa aman anamba nandaꞌmena maol ineꞌi nogataga boꞌona. Aeꞌ andaꞌana boꞌona siꞌi inaꞌ nagahapifa aeꞌ.” Eaꞌ deiꞌ atef aman anamba amboꞌona wapani. ");
INSERT INTO aoj_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","15","Jisas nafeꞌ nawis nomon ipat Pitai nati Pita nandagiꞌmoꞌwi awasiꞌw kwaꞌoh, alop akwaꞌupi nifip. Eaꞌ natoloꞌw nahapila lagol akwaꞌugili aowas inimba nakwahoꞌw nafeꞌ amboꞌokw. Eaꞌ kosafel kwape kwandaꞌmana gwaꞌaisi anen. ");
INSERT INTO aoj_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Wambomota felefeleꞌ ma owamb esis sofaꞌai amam nematawa hiasi ambagof awami magapaisi sofaꞌas safiꞌmai Jisas. Eaꞌ naꞌipa ambagof awami mehip natofam mafaꞌ mafeꞌ. Anen nandaꞌ esis hiasi aowas nandaꞌasi boꞌwes. ");
INSERT INTO aoj_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Anen nandaꞌas boꞌwes wapani siꞌi fowaꞌ gani anona profet Aisaia nagaꞌiefi basef naꞌi, “Anen atona nofaꞌ aowas apeꞌinai natopalopapa ma mogape beꞌepa.” ");
INSERT INTO aoj_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Jisas nati epes hiasi salutu salaꞌambemana, eaꞌ naꞌipa alipumi ananimi mondandombola mofaꞌ bot mogafeꞌ dumb ambamba fisanamb. ");
INSERT INTO aoj_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Eaꞌ anona aman dembinai nagawalipasa muꞌuli Godi aꞌ nafiꞌi naꞌipana naꞌi, “Dembinai tisa, aeꞌ aꞌi efeꞌ elomena. Eaꞌ ofeꞌ atin anamba hiagoma ina naꞌi negafeꞌma.” ");
INSERT INTO aoj_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Owaꞌ Jisas nagwamana naꞌipana naꞌi, “Nombagw alupugwi gwaꞌoh bologwalef itap apaꞌe wambel agwagumbili. Amiguf wapani fufiaꞌ fagafeꞌ ilifi falaꞌ owah fapaoh gani ilif, apaꞌ aeꞌ owaꞌatin. Aeꞌ ataga epen egefaꞌ alop epesi, wambel ake ma eꞌeh egalo balaga aeꞌagai.” ");
INSERT INTO aoj_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Eaꞌ anona aman alipunai Jisasi nafiꞌi naꞌipana naꞌi, “Aeꞌ aꞌi ataꞌ epe imafi ahame, ataꞌ etopalopana ma nogaꞌ iwana nogapani ifiꞌi ilina.” ");
INSERT INTO aoj_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Apaꞌ Jisas naꞌipana naꞌi, “Hapaimi, esis sagagaꞌi sondawago esis atis isimba sagagaꞌi. Apaꞌ inaꞌ owaꞌ, inaꞌ fiꞌi nila aeꞌ.” ");
INSERT INTO aoj_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Jisas nalota anota bot naloma alipumi ananimi mafeꞌ malomana mafeꞌ anemb dumb luꞌwambi. ");
INSERT INTO aoj_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Eaꞌ kwafalis atis fufin luꞌwani naluwi, embel mohafel mawis bot nomon felefeleꞌma bot taꞌi togowala embel. Apaꞌ Jisas naꞌoh nalola bot. ");
INSERT INTO aoj_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Eaꞌ alipumi ananimi mafeꞌ minimbalona maꞌipana maꞌi, “Dembinai! Inaꞌ safel netopalopafa. Afaꞌ waꞌi ahigililafa owala embel!” ");
INSERT INTO aoj_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Eaꞌ naꞌipam naꞌi, “Deiꞌ maina ipaꞌ ombal magahepa? Ipaꞌ ina pahapifi paꞌi aeꞌ banagewe, owaꞌatin. Eaꞌ nosafel naꞌipa fufin naloma embel naꞌi, “Ipaꞌ eaꞌ beꞌ tol a betah.” Eaꞌ fufin nowala, embel ina ataꞌ lasialiꞌ aꞌowaꞌ, betah hililiꞌ. ");
INSERT INTO aoj_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Eaꞌ amom alipumi ananimi gogolalasom ombal maham kwapeteꞌam maꞌi, “Anen epen ami? Naꞌipa fufini embel sameꞌana sagahapifana?” ");
INSERT INTO aoj_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Jisas nafeꞌ nataga anagon waꞌol dumb ambamba anep itap esis Gadara sagapoma. Eaꞌ anom amam biam ambagof awami magapaumi mafiꞌmai anen. Amom mape wandelef sagawa sagagaꞌima mafiꞌi. Amom amamba epes awami magahasi. Eaꞌ esis amam nematawa hiasi ombal mahasa sogafeꞌ ufiaꞌw akwamba amom magapoma. Eaꞌ mofala Jisas mehip maꞌi, ");
INSERT INTO aoj_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","“Inaꞌ God Nogamana. Inaꞌ naꞌi nendaꞌ maina afaꞌ? Inaꞌ naꞌi neha afaꞌ? Nemaf afamba inaꞌ naꞌi negahafafi ina deiꞌ afataga, ataꞌ owaꞌatin.” ");
INSERT INTO aoj_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Eaꞌ anagof bogof hiagufi falutu faꞌ gwaꞌaisi anota damota felefeleꞌ. ");
INSERT INTO aoj_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Eaꞌ amom ambagof awami mahaliꞌ Jisas maꞌi, “Iꞌi inaꞌ negatofafama nesapaꞌafa ofeꞌ uwisa bogof gwagwafumba.” ");
INSERT INTO aoj_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Eaꞌ naꞌipagof naꞌi, “Ipaꞌ foꞌo!” Eaꞌ makwaha aman anamba mawisi mafeꞌ mawisa bogof. Eaꞌ bogof agwafomba hiagufi fasagih mafaꞌ mafeꞌ mehip mowala awagoma tata aꞌ mowala mala embel dumb afum hiꞌalam. ");
INSERT INTO aoj_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Eaꞌ amom mugumafiagufi mafaꞌ mafeꞌ wambel luꞌwagoma maꞌipasa basef ifimba amam nematawa hiasi maꞌipasa hiahaom amamba magatagama amam amamba biami eaꞌ maꞌipasa bogof wapani afum hiꞌalam. ");
INSERT INTO aoj_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Eaꞌ epes hiasi wambel ambalembaisi safiꞌi sati Jisas sahaliꞌana saꞌipana dindinip saꞌi anen nokwaha itap apamba asasima aꞌ nefeꞌ anagon. ");
INSERT INTO aoj_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Esis sandaiwaꞌma Jisas eaꞌ nalota anota bot nafeꞌ dumb luꞌwambi fisanamb eaꞌ nataga wambel ananimbili kofagama. ");
INSERT INTO aoj_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Eaꞌ anom amam mofaꞌai anona aman mafiꞌi. Lagufi boꞌwagah sagaꞌ sagailanai eaꞌ tol naꞌoh alahis. Nogota atamba Jisas natolom nogawa amom mahapifana maꞌi anen banagonai ma nogatopalopa aman anamba aowas nandaꞌanai boꞌona. Eaꞌ naꞌipa aman anamba naꞌi, “Inaꞌ epen aeꞌinai! Opaf ineꞌifi fondape awanef. Waf awafi inaꞌ nandaꞌafi aeꞌ akwahomenaf hiꞌalaf okom maseꞌeaf.” ");
INSERT INTO aoj_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Eaꞌ anom amam dembami magawalipasa muꞌuli Godi ukup pandandaꞌ naꞌamba mandaꞌipama maꞌi, “Aman anamba Jisas nandaꞌ God findiwana naꞌipana awagon.” ");
INSERT INTO aoj_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Jisas nogawa nomonas isimbai amamisi. Eaꞌ naꞌipam naꞌi, “Deiꞌ maina ipaꞌ ukup pandandaꞌ awepa pagaꞌi naꞌamba? ");
INSERT INTO aoj_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Deiꞌ hiahaom maim ipaꞌ paꞌi ahifima aeꞌ? Aeꞌ banagiwai ma iꞌipa aowas nandaꞌanai igaꞌi, ‘Aeꞌ ekwahomana waf awafi anen nandaꞌafi okom mogaseꞌeaf’ aꞌa iꞌipana igaꞌi, ‘Nosafel nogafeꞌ.’ Basef ifimba ma nosafel nogafeꞌ ipaꞌ paꞌi amamba ahifima aeꞌ. ");
INSERT INTO aoj_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Aeꞌ ataga epen egefaꞌ alop epesi, aꞌi ipaꞌ pegawa aeꞌ laꞌifiwai ma ekwahomasa waf awafi hiafi amam nematawa sagape itapi sandaꞌafi okom mogaseꞌeaf. Aeꞌ aꞌi ihimbaꞌmepa aeꞌ laꞌifiwai ma endaꞌ hiahaom amamba.” Eaꞌ naꞌipana naꞌi, “Inaꞌ safel saꞌma alahis ineꞌisi foꞌo ipat ineꞌitai.” ");
INSERT INTO aoj_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Eaꞌ anen nosafel nafeꞌ ipat ananitai. ");
INSERT INTO aoj_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Eaꞌ amam nematawa hiasi satolona sosafel gogolalasis ombal mahas kwapeteꞌ sogawa God natopalopa aman anamba nasoꞌana banagami luꞌwami. Naꞌamba esis sasaꞌma agol Godi luꞌwagol. ");
INSERT INTO aoj_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Eaꞌ Jisas nosafel nakwaha wambel ambalemba nafoꞌo nati aeꞌ Matyu, andaꞌ basefa buk akwaꞌii. Aeꞌ ape ipat ataꞌe mogofaꞌ takisa. Eaꞌ Jisas naꞌipi naꞌi, “Inaꞌ fiꞌi nila aeꞌ.” Eaꞌ aeꞌ asafel ailana afeꞌ. ");
INSERT INTO aoj_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Eaꞌ Jisas naloma alipufai ananifai wape ipat aeꞌatai waꞌ gwaꞌaisi atin, owaꞌ amam hiami mandaꞌ waf awafii maloma anom hiami mogofaꞌ takisi mafiꞌi malomafa maꞌ gwaꞌaisi. ");
INSERT INTO aoj_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Eaꞌ amom Farisi dembami mati Jisas nape nalomafa waꞌ gwaꞌaisi, mahaliꞌ alipumi ananimi maꞌi, “Deiꞌ maina anen dembinai tisa ipeꞌinai nape naloma amom mogofaꞌ takisi maloma amam amamba mandaꞌ waf awafii magaꞌ gwaꞌaisi atogon?” ");
INSERT INTO aoj_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Owaꞌ Jisas nameꞌam naꞌipam naꞌi, “Isimba aowas akasi ina a safeꞌma dokta, owaꞌ. Esis buꞌwasi. Apaꞌ isimba aowas nandaꞌasi atis daoꞌ, safeꞌma dokta. ");
INSERT INTO aoj_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Anif basef fagape buk Baibeli fagaꞌi naꞌamba faꞌi, God naꞌi, ‘Ipaꞌ ina peha mafis pesoꞌ aeꞌ, owaꞌi. Apaꞌ ipaꞌ pindati anis amam nematawa uwahipis a petopalopas daoꞌ, aꞌ andeandeꞌ.’ Apaꞌ ipaꞌ ina pegawa basef ifimba kofagefa, owaꞌ. Deiꞌ pefeꞌ pitalifif pendegawef. Deiꞌ main, aeꞌ ina afiꞌi ma egefala epes sandaꞌ waf buꞌwafii, owaꞌ. Aeꞌ afiꞌi ma egefala epes isimba sandaꞌ waf awafii atis.” ");
INSERT INTO aoj_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Jon aman anamba nagapisiꞌas embeli, alipisi ananisi sameꞌ basef ananifi safiꞌi anamba Jisas nagapoma sahaliꞌana naꞌamba saꞌi, “Anif nimaguf afaꞌ waloma amom Farisi afaꞌ ukup pandandaꞌma anif basef fowaꞌifi deiꞌ wakwaha gwaꞌaisi wape dowaf. Deiꞌ maina amom alipumi ineꞌimi owaꞌ mokwaha gwaꞌaisi siꞌi afaꞌa?” ");
INSERT INTO aoj_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Eaꞌ Jisas nagwamam naꞌi basef waminif atin naꞌi, “Iꞌi anis sondaꞌ anis gwaꞌaisi luꞌwasi ma anis aman nemataꞌw bias sondasoꞌamai, ipaꞌ paꞌi esis alipisi atiasi aꞌ sondaiwaꞌma gwaꞌaisi afamba anen nagasoꞌ nemataꞌwi nape nagalomas? Owaꞌatin endilisi. Apaꞌ nemaf afamba anen nokwaha esis nogafeꞌ anagon lauguni daoꞌ, esis sololama gwaꞌaisi.” ");
INSERT INTO aoj_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Eaꞌ naꞌipasa anif basef waminif atina luwaguf naꞌi, “Ina andeandeꞌma pegatopaꞌ lowaf namifi pesambalef fegaloma anef lowaf apifi, owaꞌ. Naꞌamba atiasi lowaf afamba namifi fendatagwah, fehapeꞌ apifi bolotaf aꞌ notaga luꞌuna.” Eaꞌ naꞌi anif basef waminif atin wapani naꞌi, ");
INSERT INTO aoj_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","“Embel wainimbel dambaimbeli apaꞌ ina mowalambel agwahup apinai memeina siꞌi botol, owaꞌatin. Iꞌi anin nendaꞌam naꞌamba, embel wain netef hian, nohapeꞌ agwahup anamba pepeꞌetana eaꞌ wain koloꞌolam awasim hiꞌilam. Apaꞌ wain dambaini mowalan agwahup dambaina, naꞌambai andeandeꞌ. Ma embel beloma agwahup sogape andeandeꞌ.” ");
INSERT INTO aoj_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Jisas ataꞌ nape naꞌipas atin, owaꞌ anona aman dembinai esis Judai nafiꞌi nindiwa nembawa notawa naꞌipana naꞌi, “Nogame aeꞌakwi aꞌ afuꞌw. Aeꞌ aꞌi inaꞌ nefeꞌ newamona lagol ineꞌigili akoꞌwa ambal lopaoꞌw kogape namoꞌw.” ");
INSERT INTO aoj_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Eaꞌ Jisas nosafel naloma alipumi ananimi mafeꞌ malomana. ");
INSERT INTO aoj_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Owaꞌ anoꞌw nemataꞌw kwafiꞌi alafuga Jisasi kwahapila lowaf ananifi daꞌmalififa. Aowas awasini nandaꞌakwa kwape gamba atapiꞌw afagof 12-pelaiguf. ");
INSERT INTO aoj_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Eaꞌ akoꞌw okom mandandaꞌ maꞌi, “Iꞌi aeꞌ egasa lagola lowaf ananifi, atiasi amboꞌowe.” ");
INSERT INTO aoj_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Eaꞌ Jisas nandambema natoloꞌw naꞌipaꞌw naꞌi, “Nogame aeꞌinai! Opaf ineꞌifi fope awanef. Inaꞌ eaꞌ nahapifa aeꞌ banagiwai. Isimba atis deiꞌ andaꞌena boꞌwena.” ");
INSERT INTO aoj_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Eaꞌ Jisas nafeꞌ ipat aman anamba dembinai esis Judai nati anis amam nematawa sofapula batagwa nemataꞌw akwamba aiawaiꞌwi afuꞌwi. Eaꞌ epes hiasi saꞌi gugul sapomaꞌw. ");
INSERT INTO aoj_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Eaꞌ anen naꞌipas naꞌi, “Ipaꞌ siꞌamae! Akoꞌw ina kwagaꞌ dogw, owaꞌ. Kwaꞌoh atin.” Owaꞌ esis sandaꞌiafana. ");
INSERT INTO aoj_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","A sohafel sawis andoꞌ eaꞌ, Jisas nikilaꞌas nawis nomon nahapila lagol akwaꞌugili nafelaꞌw kosafel amboꞌokw wapani. ");
INSERT INTO aoj_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Eaꞌ basef nemataꞌw akwambai aꞌ fafeꞌagon hiꞌalagon. ");
INSERT INTO aoj_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Jisas nakwaha wambel ambalemba nafeꞌ atin, nati amam biam naep pagasoꞌami magiꞌmana mofalana mehip naꞌamba maꞌi, “Inaꞌ akunamana Deviti, niti afaꞌ uwahipifa.” ");
INSERT INTO aoj_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Eaꞌ Jisas nafeꞌ nawis anota ipat nomon owaꞌ, amom amamba mafiꞌmai anen nahaliꞌam naꞌi, “Ipaꞌ pihapifa aeꞌ banagiwai ma endaꞌepa boꞌwepa?” Eaꞌ amom maꞌi, “Ahoꞌ, Dembinai afaꞌinai.” ");
INSERT INTO aoj_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Eaꞌ nasa lagofa naep amamipi naꞌi, “Aeꞌ egawepa, ipaꞌ paꞌi aeꞌ laꞌifiwai. Naꞌamba aeꞌ endaꞌ naep ipeꞌipi amboꞌwep wapani pendahama pagahapifa aeꞌ.” ");
INSERT INTO aoj_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Eaꞌ deiꞌ naep amamipi amboꞌwep matologon andeandeꞌ. Naꞌamba Jisas naꞌipam dindinip naꞌi, “Ipaꞌ ina pefeꞌ piꞌipa anis amam nematawa daiasa andaꞌepa boꞌwepa, owaꞌi.” ");
INSERT INTO aoj_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Owaꞌ amom mafeꞌ mawalapa basef maꞌipa amam nematawa hiasi maꞌi Jisas nandaꞌ naep amamupi boꞌwep. Eaꞌ basef ifimba fafeꞌagon hiꞌalagon. ");
INSERT INTO aoj_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Amom amamba naep pagasoꞌami mafeꞌ eaꞌ, esis sofaꞌi anona aman malogol gagasoꞌanai. Anen ambal aunai nandaꞌana, naꞌamba ina noga naꞌi basef, owaꞌ. Eaꞌ sofaꞌana nafiꞌmai Jisas. ");
INSERT INTO aoj_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Jisas natofa ambal anamba aunai. Naꞌamba deiꞌ aman anamba aꞌ naꞌi andeandeꞌ. Eaꞌ amam nematawa hiasi sohafel gogolalasis saꞌi naꞌamba saꞌi, “Fowaꞌ apaꞌ Israel ina mati anom hiahaom amambai, owaꞌatin.” ");
INSERT INTO aoj_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Apaꞌ anom Farisi dembami esis Judai mambasoꞌmas maꞌi, “Anen natofa ambagof awami ma banagami ambal mamana aunai.” ");
INSERT INTO aoj_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Maol Jisas nandaꞌani nagape naꞌamba. Anen nosafel nafeꞌ walemb hiagoma naꞌipasa basef buꞌwafi Godi. Nafeꞌ nawis ifagw esis Juda sandakolasugwi naꞌipasa sogawis nomona maol Godi nope Dembinai nugumafias. Anen natopalopa amam nematawa hiasi aowas hiana haona nandaꞌasi sataga boꞌwes wapani. ");
INSERT INTO aoj_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Eaꞌ nati amam nematawa hiasi uwahipis. Esis dola sape ombal mahas kwapeteꞌ. Ina anona aman nape numafias, owaꞌatin. Esis sape siꞌi sipsip owaꞌ anin epen nugumafiapia. Eaꞌ nati esis uwahipis. ");
INSERT INTO aoj_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Eaꞌ naꞌipa alipisi ananisi anif basef waminif atin naꞌi, “Ipaꞌ piti aofah hiagahi gwaꞌaimi hiami aꞌ maof eaꞌ. Apaꞌ epes sandaꞌ maoli owaꞌ hiasa, kwasalaꞌwis. ");
INSERT INTO aoj_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Eaꞌ ipaꞌ pihaliꞌ dembinai kofagonama aofahi. Pihaliꞌana ma nogasapaꞌi epes hiasi sofeꞌ sondaꞌ maola sola gwaꞌaimi ananimi sogambeꞌam atifigin.” ");
INSERT INTO aoj_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Jisas nofalai alipumi ananimi 12-pelaim mafiꞌmai anen nasoꞌam agol luꞌwagili nowaꞌ banagama mogatofa ambagof awami mondaꞌ hiasi aowas hiana haona nandaꞌasi boꞌwes. ");
INSERT INTO aoj_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Amom amamba aposel 12-pelaim Jisasi, agufuma amamba. Nagaliꞌi Saimon agol waꞌagol Pita, owamana ananinai Andru. Eaꞌ Jems nogama Sebedi naloma owamana Jon, ");
INSERT INTO aoj_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Filip naloma Bartolomyu, Tomas naloma aeꞌ Matyu andaꞌ basef ifiꞌi egefaꞌasa takisi. A Jems Alfius nogamana, a Tadius, ");
INSERT INTO aoj_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","eaꞌ Saimon anen miniꞌap Seloti. Eaꞌ aman anamba Judas nogawalapa Jisasa amom boumi ananimii. ");
INSERT INTO aoj_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Jisas nasapaꞌ amam amamba 12-pelaim mafeꞌ, nasoꞌama basef amom naꞌi, “Ipaꞌ ina pefeꞌma epes isimba owaꞌ sogogawa Godia, owaꞌ. Eaꞌ ina pefeꞌ piwis anembel wambel itap esis Samariaipi, owaꞌi. ");
INSERT INTO aoj_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Ipaꞌ pefeꞌ ma esis miniꞌap Israel sagape siꞌi sipsip higilagalapi. ");
INSERT INTO aoj_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Pefeꞌ pewalapa basef naꞌamba piꞌi, ‘Nemaf buꞌwafi ma ipaꞌ pigawis nomona maol Godi nope Dembinai nugumafipa a fafiꞌi felefeleꞌ eaꞌ.’ ");
INSERT INTO aoj_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Ipaꞌ pendaꞌ awasisi boꞌwes pesaꞌma sagagaꞌi sope namis wapani, a pendaꞌ isimba aowas aunai nandaꞌ alop asasipi pagambuꞌwi sotaga boꞌwes. Eaꞌ petofa ambagof awami magapaisi. Banagami Godi ipaꞌ pegefaꞌami, amamba ipaꞌ pefaꞌam dowaf ina patalom otamba, owaꞌatin. Eaꞌ naꞌamba atin ipaꞌ peseꞌasam dowaf esis ina sotaloma ipaꞌ, owaꞌatin. ");
INSERT INTO aoj_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","“Ipaꞌ ina peloꞌ otamba goli silva moloma kapa poket isalef ipeꞌisi, owaꞌi. ");
INSERT INTO aoj_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Ipaꞌ ina pefaꞌ roksaki siaogw biagw atogw, a su, moloma galahitagw pandahiꞌamonam pagafiꞌi, owaꞌ. Epes sandaꞌ maoli, andeandeꞌma sogofaꞌ gwaꞌaisi asasisi. ");
INSERT INTO aoj_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Iꞌi ipaꞌ pefeꞌ pigawis anambel wambel, ataꞌ petologon pegawagon andeandeꞌ. Aman wambel ambalembainai mamahonama fasinai nogaꞌi awima ipeꞌi, aꞌ pepe atapipa peloma anen atona a pefeꞌ ma afamba pekwaha wambel ambalemba pegafeꞌ. ");
INSERT INTO aoj_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Afamba ipaꞌ pefeꞌ pigawis anota ipat, piꞌipa esis amam nematawa sagape ipat atambai piꞌi, ‘Ipaꞌ pepe opalef awanelef.’ ");
INSERT INTO aoj_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Iꞌi anis ipat atambaisi fasisi sondaꞌmepa waf sogaꞌi ahoꞌma ipeꞌma, atiasi basef ipeꞌifi opalef awanelefafi fepomas. Apaꞌ iꞌi owaꞌ, hapaimi, basef ifimba buꞌwafi fitanimamai fepemepa atapif. ");
INSERT INTO aoj_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Iꞌi anin epen nindaiwaꞌma negaseꞌepa nembela nefaꞌepa pefeꞌ pigawis ipat ananitai ma nindaiwaꞌ ma negameꞌ basef ipeꞌifia, daoꞌ pesafel pekwaha ipat taun inimba pindilaꞌma usas itap pagail boꞌwagah ipeꞌigahi, ma esis sitilipa sogogawa waf awafi asasifi kofagema asasimi atom. ");
INSERT INTO aoj_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Aeꞌ aꞌipipa endilisi, nemaf afamba luꞌwafi anaf God nogawaloga epesafi, niti esis fowaꞌ sagape Sodomi Gomora uwahipis kwasakwasala. Apaꞌ epes isimba wambel ambalembaisi ina niti uwahipis, owaꞌ. Akafimi luꞌwami awami endilisii anaf aꞌ motagamas.” ");
INSERT INTO aoj_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Eaꞌ Jisas naꞌipam wapani naꞌi, “Ipaꞌ pemeꞌ, aeꞌ esapaꞌepa pefeꞌ siꞌi anom sipsip pefeꞌ laꞌafena nombagw wandafugwi alupugwi. Naꞌamba ipaꞌ ukup pendandaꞌ andeandeꞌ pefeꞌ pila gawa siꞌi uguf fagafeꞌ. Eaꞌ pigiꞌma waf buꞌwafi siꞌi anal amil maꞌunai, ipaꞌ ina ukup pepe awepa pendaꞌ waf awafi, owaꞌ. ");
INSERT INTO aoj_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Ipaꞌ solawaipa andeandeꞌma anom amam. Amom atiasi aꞌ mondaꞌmepa kota amom dembami Juda eaꞌ mehepa nomon ifagw esis Juda sandakolasugwi. ");
INSERT INTO aoj_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Amom mogawa ipaꞌ ukup pagapoma basef aeꞌafi eaꞌ miꞌi mondaiwaꞌmepa, eaꞌ mofaꞌepa pefeꞌ pilutu nogohnaep kingi gavman dembami ma pegawalapa basef aeꞌafi buꞌwafi ma amom moloma esis amam nematawa sogolalama Godi pigaꞌipasef. ");
INSERT INTO aoj_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Esis atiasi sowalapepa ma kot, ipaꞌ ina aꞌ ombal mehepa aꞌowaꞌ piꞌi, ‘Apaꞌ atiasi mogwa basef miꞌif miꞌimama?’ Owaꞌi. Atiasi nogota atamba atota God nihimbaꞌmepa basef maif ipaꞌ pewalapef pigaꞌiefi. ");
INSERT INTO aoj_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Ifimba ina ipaꞌ atipa piꞌif, owaꞌatin. Spirit Ambal buꞌunai Godi atona nowalapa basefa malogof ipeꞌigufi. ");
INSERT INTO aoj_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Nemaf afamba atiasi esis atis sahin owan sondandaꞌma kot sohas sogaꞌ. Eaꞌ ahapas sondaꞌam naꞌamba atina esis nogaopas asasisi. Eaꞌ batawisas wapani sondaꞌ kotima mamasas asasisi anis sohas sogaꞌ. ");
INSERT INTO aoj_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Atiasi epes hiasi walemb hiagoma nelelemb numbutima ipaꞌ kwapeteꞌ endilisi. Esis sati ipaꞌ pagaila basef aeꞌafii, naꞌamba deiꞌ sahepa. Apaꞌ epen ami nihapifi banagen nilutuma negatagama nemaf akutaifii, inimba atiasi God nuwambilan nokwahoman waf awafi ananifi nitanimai nepe andeandeꞌ. ");
INSERT INTO aoj_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Iꞌi esis sagape anin tauni sondaꞌ waf awafima ipaꞌ ma, pefaꞌ pefeꞌ anambel wambel daiambel. Aeꞌ aꞌipipa endilisi, aeꞌ ataga epen egefaꞌ alop epesi. Ipaꞌ ina atiasi pendaꞌ maol aeꞌani hiꞌilana walemb ambalemba Israeli hiagoma, ataꞌ owaꞌ, ipaꞌ a piti aeꞌ igafiꞌi. ");
INSERT INTO aoj_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Epes sandaꞌ skul atini ina sape dambes sikilaꞌ tisa asasinai, owaꞌ. Eaꞌ epen inimba agol akani nandaꞌ maol dowafi anin ina nape ilifa dembinai ananinai, owaꞌ. ");
INSERT INTO aoj_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Apaꞌ iꞌi esis sandaꞌ skuli sogape naꞌamba atin siꞌi aeꞌ tisa asasiwai, esis aꞌ ukup pendegawa andeandeꞌ piꞌi, ‘Andeandeꞌma afaꞌ ogameꞌ akafimi siꞌi tisa afaꞌinai.’ Apaꞌ iꞌi anin epen agol akani nandaꞌ maol dowafi negape siꞌi dembinai ananinai, isimba wapani daoꞌ aꞌ andeandeꞌma negameꞌ akafimi siꞌi dembinai ananinai. Aeꞌ dembiwai ahamepa ma wambota aeꞌatai esis saꞌi basef awafi ma agol aeꞌagili saꞌi aeꞌ Belsebul. Anaf esis siꞌipipa sondaꞌmepa agof awogufi endilisi fikilaꞌ agol Belsebul sandaꞌmeagol aeꞌi. ");
INSERT INTO aoj_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Eaꞌ ipaꞌ ina ombal mehepa ma amom, owaꞌi. Hiahaom mape mandambahiꞌi anaf motaga alihigima hiasi sotolom sogawam. Hiahaom hiami ataꞌ sambahoꞌwam magaꞌihi, anaf aꞌ motaga mondawalap, hiasi sogawam. ");
INSERT INTO aoj_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Basef ifimba aeꞌ ambaheꞌef akot agaꞌipa ipaꞌ atipafi, ifimba pewalapef piꞌif alip. Eaꞌ basef pagameꞌef saꞌombel hikihikaꞌ aligah atogahi, ifimba pelota petoma ifagw ilif pewalapef piꞌifa amam nematawa sogameꞌef. ");
INSERT INTO aoj_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Ipaꞌ owaꞌi ombal mehepama esis sogahepa alop atop pogagaꞌia, apaꞌ esis ina atiasi laꞌifis sogaha nomonasi ambagof ipeꞌisi, owaꞌatin. Apaꞌ ipaꞌ ombal mondahepama aman anamba laꞌifinai ma nogaha ipaꞌ alop siꞌip pogaloma nomonasi ambagof ipeꞌisi ma wambel awambili hel. ");
INSERT INTO aoj_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","“Ipaꞌ pegawa epes satala amiguf bias saꞌusi ma moni otam waꞌani atitin. Apaꞌ ahamepa ipeꞌinai ina natiti anin amil atitin niwai dowaf, owaꞌatin. Numafiagof andeandeꞌ. ");
INSERT INTO aoj_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Eaꞌ anen aꞌ niamba awif fagalo balagah ipeꞌigahi dondoꞌ hiꞌalef. ");
INSERT INTO aoj_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Eaꞌ ipaꞌ owaꞌi ombal mehepaea. Anen okom mapoma ipaꞌ apikilaꞌ amiguf hiagufi agwafomba saꞌugufi.” ");
INSERT INTO aoj_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Eaꞌ Jisas naꞌipas naꞌi, “Epen ami newalapa agol aeꞌagili ma amam nematawa hiasi, anaf aeꞌ wapani ewalapa agol epen inimbai ma naep ahame Godi gani heven. ");
INSERT INTO aoj_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Apaꞌ epen ami newaꞌe alafuga nindaiwaꞌme ma owaꞌ newalape niꞌipas naep epesia, naꞌamba atin anaf aeꞌ wapani eseꞌana alafuga epen inimba ma naep ahame Godi gani heven.” ");
INSERT INTO aoj_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Jisas naꞌi anif basef waminif atina wandaf naꞌi, “Ipaꞌ ina piꞌi aeꞌ afiꞌi itap apaꞌe ma egakolasa ipaꞌ pegape opalef awanelefa atiasi wandaf lopaꞌ gugul owaꞌatin, owaꞌ. Aeꞌ ifaꞌi bainat hikalinai aꞌ ifiꞌi ma atiasi anis epes sosafel sopaꞌ sogaloma anis. ");
INSERT INTO aoj_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Aeꞌ afiꞌi ma endaꞌ waf afamba lopaꞌ gugulifi fegataga, siꞌi basef faꞌias fagaꞌi, ‘Anaf anona aman noloma ahamana ananinai mondatopaꞌ biafim, eaꞌ anoꞌw nemataꞌw koloma maꞌmaꞌw ondatopaꞌ biafiwa, eaꞌ mefiꞌmaꞌw akwoꞌukwi koloma maꞌmaꞌw kwandagiꞌmoꞌwi ondatopaꞌ biafiwa. ");
INSERT INTO aoj_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Eaꞌ esis sagape ipat atotai esis wambota aman anambai atiasi sondawal sotaga bousi.’ ");
INSERT INTO aoj_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Epen ami okom magamagaila ahamani maꞌman ananisi atisi ma owaꞌ okom mimila aeꞌa, epen inimba ina aꞌ netaga alipini aeꞌani endilisi, owaꞌatin. Eaꞌ epes amam nematawa ami nomonas asasisi asohafel sisila awasi asasisi aꞌowaꞌ, ma owaꞌ nomonas sisila aeꞌa, isimba ina asotaga alipisi aeꞌasi endilisi, owaꞌatin. ");
INSERT INTO aoj_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Aeꞌ efaꞌ akafimi andaꞌ maol Godi sehe egaꞌ lawag usiꞌigai tiꞌwanaegai. Epen ami owaꞌ nendaꞌas naꞌamba atin siꞌi aeꞌa ma nigailima, epen inimba ina laꞌifin netaga alipini aeꞌani, owaꞌatin. ");
INSERT INTO aoj_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Epen ami okom mopoma ambal ananili atol niꞌi nihapilal tatalaꞌil nendaꞌ maol nelaꞌambema ambal ananili, anaf ambal ananili higililal. Apaꞌ epen okom mopoma aeꞌ ma nesambala ambal ananili itap apaꞌe, anaf God nowambilai ambal ananili nitanimai nepe andeandeꞌ lifilafi.” ");
INSERT INTO aoj_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Epen ami neseꞌepa nembela nigaꞌi ipaꞌ aeꞌipai, anin aꞌ naseꞌe nembel aeꞌ wapani. Eaꞌ epen inimba nagaseꞌe nembela aeꞌi, anin nasoꞌana nembel God nasapaꞌe agafiꞌii. ");
INSERT INTO aoj_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Epen ami niti anona aman profeta nigaꞌi, ‘Aman anamba profet nandaꞌ maol Godii. Aeꞌ eseꞌana opaf endatopalopana.’ Epen inimba anaf aꞌ nefaꞌ hiahaom buꞌwami siꞌi profet anamba nogofaꞌami. Eaꞌ epen ami niti anona aman fasinai nifiꞌi ma anin niꞌi, ‘Aeꞌ aꞌi anen aman fasinai. Eaꞌ etopalopana eseꞌana opaf.’ Epen inimba bola nefaꞌ hiahaom fasimi siꞌi aman anamba fasinai nogofaꞌami. ");
INSERT INTO aoj_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Iꞌi epen ami niti anis epes falafisi wafisi aꞌa agufisi ma anin nitilis okom mimila epes isimba Jisasi, netopalopas neseꞌasa embel mais. Aeꞌ aꞌipipa endilisi, anaf epen inimba nefaꞌ hiahaom ananimi fasimi ina higililam, owaꞌatin.” ");
INSERT INTO aoj_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Jisas naꞌipama basef ifimba alipumi ananimi ma hiꞌalef, nosafel nakwaha wambel ambalemba nafeꞌ taun walemb hielimbi itap luꞌupa Galili nawalipa amam nematawa hiasi naꞌipasa basef Godi. ");
INSERT INTO aoj_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Jon nagapisiꞌas embeli nape nandaꞌ kalabus, eaꞌ nameꞌ basefa maol hiani Krais nandaꞌani. Eaꞌ deiꞌ Jon nasapaꞌ anom alipumi ananimi mafeꞌma Krais. ");
INSERT INTO aoj_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Eaꞌ mahaliꞌana maꞌi, “Inaꞌ aman maꞌwina aꞌ nafiꞌi, eaꞌ aꞌa ataꞌ mope mohafa anona daiana?” ");
INSERT INTO aoj_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Eaꞌ Jisas nagwamama basef naꞌi, “Ipaꞌ pitanima pefeꞌ piꞌipa Jona hiahawes isimba deiꞌ patilis pagameꞌasi. ");
INSERT INTO aoj_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Isimba naep pagasoꞌasi asati wapani, boꞌwagah awamisi asafeꞌ andeandeꞌ, aowas aunai nandaꞌ alop asasipi pagambuꞌwi amboꞌwes, aligah hagasoꞌasi eaꞌ sameꞌ basef andeandeꞌ, sagagaꞌi sotanima sosafel wapani, a kwahusi sameꞌ basef buꞌwafi Godi. ");
INSERT INTO aoj_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Epes mamahisa ukup atifip sagahapifai, isimba asonahas andeandeꞌ.” ");
INSERT INTO aoj_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Eaꞌ alipumi amamba Joni mafeꞌ atin, Jisas naꞌipa esis amam nematawa ma Jon naꞌi, “Fowaꞌ ipaꞌ pafeꞌ anep itap fataupigima wafigima, pafeꞌ pati main? Pafeꞌma pagati anona aman pupulinai siꞌi anota elifita fufin naolata tagalimbi? Owaꞌatin. ");
INSERT INTO aoj_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Aꞌa pafeꞌ pati main? Pafeꞌ pati anona aman nagala klos fasimi atumii? Owaꞌatin. Epes isimba sandaꞌ luwaguf maim fasimi atumi esis sape ifagw king dembamii atogw. ");
INSERT INTO aoj_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Apaꞌ ipaꞌ deiꞌ pafeꞌ pati main? Pafeꞌ pati anona aman profet? Aeꞌ aꞌipipa, anen profet dembinai nikilaꞌ profet hiami hiꞌalam. ");
INSERT INTO aoj_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Aman anamba eaꞌ maꞌuna anen atona siꞌi basef fagape Baibeli naꞌiasa God fowaꞌ naꞌipa Jisas nagaꞌi, ‘Pemeꞌ, anaf aeꞌ esapaꞌ anona aman nogawalipasa basef aeꞌafii niliꞌ nofeꞌma inaꞌ. Eaꞌ nondondomba ufiaꞌw ineꞌikwi.’ ");
INSERT INTO aoj_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","“Aeꞌ aꞌipipa endilisi. Aman anamba Jon nagapisiꞌas embeli aꞌ nikilaꞌ amam hiami hiꞌalam magataga itap apaꞌi. Apaꞌ epen ami deiꞌ nigawis nomona maol Godi nope Dembinai nugumafian, inimba dembeni nikilaꞌ Jon. Iꞌi epen inimba saꞌusaꞌuni ma wambota Godi, anin wapani deiꞌ nape damben nikilaꞌana. ");
INSERT INTO aoj_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Nogota atamba fowaꞌ Jon nagapisiꞌas embeli eaꞌ tafiꞌi togotambel deiꞌ, anom amam banagami maꞌi mohambombaga waf epes sogawis nomona maol Godi nope Dembinai nugumafias. Apaꞌ anom amam dindinapimi deiꞌ mawis mape nomona maol inimba atapim mahapilan tatalaꞌina anen nogape Dembinai ma amom. ");
INSERT INTO aoj_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Amom magawalipasa basefa muꞌuli Godi faloma basef amom profeti mawalipasef mape mafiꞌi metambel nogota Jon nagatagatai. ");
INSERT INTO aoj_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Apaꞌ iꞌi ipaꞌ piꞌi ahoꞌma pigahapifa basef amamifima, deiꞌ pegawa Jon anen siꞌi Elaija, aman anamba fowaꞌ amom profet maꞌi nogafiꞌii. ");
INSERT INTO aoj_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Ipaꞌ epes ami aligah hagagalipai, pemeꞌ basef ifimba andeandeꞌ. ");
INSERT INTO aoj_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Atiasi aeꞌ indilaꞌwaifa ipaꞌ amam nematawa deiꞌ pagape itapi ataipai iꞌimama? Ipaꞌ pape siꞌi awasi sandakolas sagapoma sofala anis awasi daias sagaꞌi, ");
INSERT INTO aoj_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Apaꞌ mandagala mufapula batagwa ipaꞌ, apaꞌ ipaꞌ ina palemb. Apaꞌ mandaꞌ awalef siꞌi sagatala fawiagof malef mindiwagef, apaꞌ ipaꞌ owaꞌ pelefa.’ Ipaꞌ epes deiꞌ pagape itapi pandaꞌ duꞌwanigai siꞌi awasi isimba owaꞌ sealemb selef sigindiwagefia. ");
INSERT INTO aoj_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Aman anamba Jon nagapisiꞌas embeli nafiꞌi ina naꞌ gwaꞌaisii embel wainimbel, owaꞌatin. Eaꞌ paꞌi ambal aunai napaona. ");
INSERT INTO aoj_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Aeꞌ ataga epen egefaꞌ alop epesi afiꞌi aꞌ gwaꞌaisi saloma embel wain, eaꞌ patolowe paꞌi, ‘Piti aman anamba nagaꞌ waliꞌita hiatai nagaꞌ embel wain hiani endilisii. Anen alipunai ma amom mogofaꞌ takisi magambasoꞌmasi maloma amam mandaꞌ waf awafii.’ Apaꞌ epes ami sigaila gawa fasini Godi sondaꞌ waf buꞌwafi, isimba atis deiꞌ hiasi saꞌi, ‘Gawa inimba buꞌwani.’” ");
INSERT INTO aoj_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Analemb walemb luꞌwalimbi taun fowaꞌ Jisas nandaꞌ hiahaom banagami esis satolom sogawam apaꞌ esis ina sambema nelelemba God, owaꞌatin. Eaꞌ deiꞌ Jisas nandaꞌ megahahas. ");
INSERT INTO aoj_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Eaꞌ naꞌipas naꞌi, “Aeꞌ ati ipaꞌ Korasinipai paloma Betsaida uwahipipa aꞌowaꞌ. Nimanimi akafimi luꞌwami atiasi aꞌ motagamepa. Epes isimba fowaꞌ gani sandaꞌ waf awafii sagape walemb ambalemba bialemb Tairi Saidon ina sati anom hiahaom maol banagami siꞌi deiꞌ andaꞌam walemb ipeꞌilimbi, owaꞌ. Iꞌi sotolumai, sowahoꞌ begah pepeꞌagatami siꞌi luwaguf tol sope nif agambeh. Ama sigihimbaꞌma anis epes esis eaꞌ sambema nelelemb endilisi safeꞌma God. Owaꞌ, owaꞌatin. ");
INSERT INTO aoj_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Endilisi aeꞌ aꞌipipa. Anaf God nogawaloga esis amom nematawa hiasi, afamba nimanimi Tairi soloma Saidoni amamba ina luꞌum aꞌowaꞌ siꞌi nimanimi amamba anaf mogatagama ipeꞌi, owaꞌatin. Anaf anen niti uwahipis, apaꞌ ipaꞌ owaꞌ. ");
INSERT INTO aoj_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Eaꞌ ipaꞌ Kaperneam, anaf esis sosaꞌma agof ipeꞌigufi folota ilif? Owaꞌatin. Anaf God nokwahipa pefeꞌ wambel awambili hel. Iꞌi fowaꞌ gani anona aman nondaꞌ anom banagami wambel ambalemba Sodom siꞌi andaꞌam wambel ipeꞌimbiliai, epes isimba Sodom ina sogaꞌ ma nif luꞌwami, owaꞌatin. Deiꞌ bafasas akusas asasisi sope namis. Owaꞌ, owaꞌatin. ");
INSERT INTO aoj_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Deiꞌ aeꞌ aꞌipipa, nemaf afamba luꞌwafi God nogawaloga epesafi, niti fowaꞌ sagape Sodomi uwahipis kwasakwasala. Apaꞌ anen ina niti uwahipipa, owaꞌ. Anaf pefaꞌ akafimi luꞌwami awami endilisi.” ");
INSERT INTO aoj_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Nemaf afamba Jisas naꞌias naꞌamba naꞌi, “O ahame, inaꞌ dembinai ma ilifi itapi. Inaꞌ nambahoꞌ hiahaom amamba ma esis epes gawaisi sogofaꞌ gawa luꞌwanii, eaꞌ nambemam nihimbaꞌmasam epes isimba gawa akasi falafisi. ");
INSERT INTO aoj_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Ahoꞌ ahame okom ineꞌimi magaꞌi eaꞌ amamba atom. ");
INSERT INTO aoj_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Ahame aeꞌanai nandaꞌ hiahaom hiami hiꞌalam mape lagol aeꞌagili. Ina anin epen negawa aeꞌ Nogamana Godi, owaꞌatin. Anen atona nogawe. Eaꞌ owaꞌ anin epen negawa ahamea, owaꞌatin. Aeꞌ Nogamana ananiwai atowe egawana. Epes isimba mamahisa igihimbaꞌmasa ahamai, isimba wapani esis atis sogawana. ");
INSERT INTO aoj_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Ipaꞌ epes pandaꞌ maol numaꞌwinii nomaꞌw kwagahipai ma pegelaoma ufiaꞌw buꞌwakwi kwagafeꞌma Godi, ipaꞌ hipai pifiꞌmai aeꞌ, endaꞌepa pegapoma nomaꞌw. ");
INSERT INTO aoj_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Pemeꞌ basef aeꞌafi pigiꞌmif pandaꞌ waf aeꞌafi. Waf afamba siꞌi anoga lawag aeꞌ aseꞌepaga pegewandefaga ikaguf ipeꞌifii. Ipaꞌ pendefaꞌ gawa aeꞌani ma pegegawa aeꞌ. Deiꞌ main? Aeꞌ andaꞌ waf saꞌumbilifi ma epesi, aeꞌ ina agasaꞌma agol aeꞌagili atogila okom aeꞌami, owaꞌ. Ipaꞌ pifiꞌmai aeꞌ ma atiasi pegapoma nomaꞌwa ambagof ipeꞌigufi. ");
INSERT INTO aoj_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Deiꞌ main? Maol aeꞌ eseꞌepan pegefaꞌani, inimba ina hiahaom nimanimi, owaꞌatin. Maol inimba fasini endilisi ma negatopalopa ipaꞌ epes hipai.” ");
INSERT INTO aoj_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Aꞌi owaꞌ anef nemaf Juda sagapoma nomaꞌwafi sabat, Jisas nafeꞌ anagon owaꞌ, nataga anof aof sagawa witafi aꞌ nawis. Eaꞌ alipumi ananimi mafeꞌ malomana nolomaham mosaga anom wit magaufi maꞌam. ");
INSERT INTO aoj_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Owaꞌ amom Farisi mati waf afambai alipumi Jisasi mandaꞌafi eaꞌ mahaliꞌana maꞌi, “Inaꞌ niti waf afamba alipumi ineꞌimi mandaꞌafi. Amom ina mondaꞌam naꞌamba ma nemaf afaꞌe sabat magapoma nomaꞌwafi, owaꞌi. Deiꞌ maina amom mandaꞌam naꞌamba?” ");
INSERT INTO aoj_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Eaꞌ Jisas nagwamam naꞌipam naꞌi, “Ipaꞌ pegawa basef ifimba eaꞌ ma waf fowaꞌ dembinai king Devit nandaꞌafi. Afamba Devit naloma alipumi ananimi nolomagaham ");
INSERT INTO aoj_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","anen nawis ipat luꞌunai Godi nomon naꞌ bret atamba amom pris mondolali magasoꞌ Godatai. Eaꞌ anen naꞌata nasoꞌ alipumi ananimi wapani maꞌata atin. Apaꞌ muꞌuli apeꞌini naꞌi amom eaꞌ pris atom meaꞌata. Owaꞌ anen ina naila muꞌuli inimba, owaꞌ. ");
INSERT INTO aoj_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Ipaꞌ patalifa basef ifimba fagape buk muꞌuliꞌwi Godi eaꞌ ma amom pris mandaꞌ maol ipat luꞌunai Godi nomon. Basef ifimba ma nemaf sagapoma nomaꞌwafi amom ina magiꞌmif, owaꞌ. Mumbisilaꞌef. Apaꞌ amom ina mandaꞌ waf awafi, owaꞌatin. ");
INSERT INTO aoj_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Aeꞌ deiꞌ aꞌipipa, anin epen deiꞌ nagape naꞌai anin aꞌ nikilaꞌ ipat luꞌunai Godi. ");
INSERT INTO aoj_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Basef fagail buk Baibel fowaꞌ amom mandaꞌafi faꞌias naꞌamba faꞌi, God naꞌi, ‘Aeꞌ ina okom maꞌi bulmakau mafis pindalalima aeꞌasi, owaꞌ. Aeꞌ okom maꞌi ipaꞌ piti sahin owan ipeꞌisi uwahipis.’ Iꞌi ipaꞌ pegawa basef ifimba Godi kofagefa ai, ipaꞌ ina apewaloga epes isimba owaꞌ sondaꞌ anef waf awafia, piꞌi awasi. Owaꞌ owaꞌatin. Ipaꞌ owaꞌ pegawefa. ");
INSERT INTO aoj_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Deiꞌ main, aeꞌ ataga epen egefaꞌ alop epesi, aeꞌ atowe ape dembiwai ma nemaf afamba sabata igaꞌipipa maol main andeandeꞌma pigaila basef pendaꞌan nemaf afamba.” ");
INSERT INTO aoj_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Jisas nosafel nakwaha aof afamba nafeꞌ nawis anota ipat esis Juda sandakolasatai. ");
INSERT INTO aoj_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Eaꞌ nati anona aman lagol awagilinai nape ipat atamba. Aowas nandaꞌana lagol ananigili gagaꞌ dindigigil gailana. Anom amam maꞌi mowandoꞌmana ufiaꞌwa mogasapaga Jisasa anif basef basoꞌafi ma mondaꞌ kotimana. Eaꞌ mahaliꞌana maꞌi, “Afaꞌ andeandeꞌma ogatopalopa anis epes aowas nandaꞌasi ma nemaf afaꞌe sagapoma nomaꞌwafi, aꞌa owaꞌ?” ");
INSERT INTO aoj_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Eaꞌ Jisas naꞌipam naꞌi, “Iꞌi anona aman ipeꞌinai sipsip ananipi pofeꞌ powala pogape anoga nowaga lougai nemaf afamba sagapoma nomaꞌwafi, ipaꞌ pafeꞌ pagiapi. ");
INSERT INTO aoj_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Waf afambai buꞌwafi. Apaꞌ epes sikilaꞌ sipsip aꞌowaꞌ. Eaꞌ naꞌamba atin apaꞌ mondaꞌ waf fasifi mondotopalopa epes nemaf afamba magapoma nomaꞌwafi.” ");
INSERT INTO aoj_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Eaꞌ Jisas naꞌipa aman anamba lagol awagilinai naꞌi, “Dowa lagol ineꞌigili usiꞌigil.” Eaꞌ aman nando lagol ananigili agataga boꞌwagol wapani, siꞌi waꞌagol. ");
INSERT INTO aoj_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Owaꞌ amom Farisi mosafel mawis andoꞌ munduwaꞌanima maꞌi basef mandameꞌmaefa moha Jisas nogagaꞌ. ");
INSERT INTO aoj_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Owaꞌ Jisas nogawa basef ifimba ma amom maꞌi mohana nogagaꞌ. Eaꞌ nakwaha wambel ambalemba nafeꞌ eaꞌ hiasi sagiꞌmana safeꞌ, nandaꞌ isimba aowas nandaꞌasi hiasi amboꞌwes hiꞌalas. ");
INSERT INTO aoj_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Eaꞌ naꞌipas dindinip naꞌi esis ina sowalapa anen siꞌiana alihina, owaꞌ. ");
INSERT INTO aoj_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Anen naꞌipas naꞌamba atin siꞌi anif basef God fowaꞌ nagaꞌipa profet Aisaiefi. Basef ifimba fataga endilisi fagaꞌias naꞌamba faꞌi, ");
INSERT INTO aoj_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Piti aman anamba nandaꞌ maola aeꞌi, aeꞌ andandepana eaꞌ. Nomonas aeꞌasi peleleꞌ saisailana aꞌowaꞌ, okom aeꞌami eaꞌ boꞌoma anen. Aeꞌ atiasi eseꞌana Ambal buꞌunai Aeꞌanai nuwalipasa basef aeꞌafi ma nogawaloga epes hiasi owaꞌ sogogawa aeꞌia. ");
INSERT INTO aoj_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Aman anamba ina nondaꞌ megahohas ninifalis niꞌipas diga luꞌugai, owaꞌatin. Esis ina someꞌ malagol ananigili noga nigaꞌi ufiawa luꞌuwama, owaꞌ. ");
INSERT INTO aoj_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Anota elifita saꞌutai tondolaꞌi atamba anen ina nowalota, owaꞌatin. Eaꞌ anom lam fagandom nimanisi, amamba anen ina nehefam mogaꞌ, owaꞌatin. Anen nope nondaꞌ maol atapina nefeꞌ nefeꞌ notagama nemaf afamba nondaꞌ waf buꞌwafi fikilaꞌ endilisi waf awafi ma fegenalo. ");
INSERT INTO aoj_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Eaꞌ esis amam nematawa hiasi owaꞌ sogogawa aeꞌia sila basef ananifi sope sohafana.” ");
INSERT INTO aoj_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Nemaf afamba esis sofaꞌai anona aman ambal aunai nagawisanai safiꞌmai Jisas. Naep paloma malagol ananisi sosoꞌana, eaꞌ Jisas nandaꞌana boꞌona, naꞌi andeandeꞌ naep pati natologon nafeꞌ andeandeꞌ. ");
INSERT INTO aoj_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Eaꞌ amam nematawa hiasi gogolalasis kwapeteꞌ saꞌi, “Aman anamba anen Devit akunamana aꞌa owaꞌ?” ");
INSERT INTO aoj_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Owaꞌ amom Farisi mameꞌ isimba maꞌi, “Anen natofa ambagof awami ma banagami anona ambal mamana aunai agilinama Bielsebul.” ");
INSERT INTO aoj_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Owaꞌ Jisas nogawa ukup amamipi naꞌipam naꞌi, “Iꞌi anis epes hiasi sagape itap luꞌupa anin kantri sondatopaꞌ biafis sogapaꞌ, ina atiasi banages, owaꞌ. Iꞌi anis epes wambota atota sondatopaꞌ biafisa sogapaꞌ, esis ina atiasi banages sopaꞌ, owaꞌ. ");
INSERT INTO aoj_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Iꞌi wambota Satani sondawal biafis sogapaꞌ, atiasi wambota ananitai banages siꞌimama? Owaꞌatin. ");
INSERT INTO aoj_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Iꞌi endilisi aeꞌ atofa ambagof awami ma banagami Bielsebulai, deiꞌ ami natopalopa epes ipeꞌisi natofam? Owaꞌatin. Deiꞌ epes isimba ipeꞌisi sihimbaꞌmepa basef ipeꞌifi owaꞌ endilisifia. ");
INSERT INTO aoj_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Endilisi, Ambal buꞌunai Godi natopalopa aeꞌ atofa ambagof amamba awami. Eaꞌ deiꞌ ipaꞌ pendegawa nemaf afamba pigawisa maol Godi nope Dembinai nugumafipa eaꞌ fatagamepa. ");
INSERT INTO aoj_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Anona aman ina banagona nefeꞌ nuwis ipat anona aman banagonai nagapautai nondaꞌ wala hiahaom ananimi, owaꞌ. Anen ataꞌ niliꞌ nombaloꞌana nowaꞌana sisihina daoꞌ, atiasi banagona ma nefeꞌ nuwis nondaꞌ wal nogofaꞌi hiahaom magaꞌoh ipat aman anambai. ");
INSERT INTO aoj_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Epen ami owaꞌ alipini aeꞌani ma owaꞌ negape atapin negaloma aeꞌia, anin bouni aeꞌani. Epen ami owaꞌ nekolasa sipsip pogaloma aeꞌapia, anin nagatofa sipsip pafaꞌ pagafeꞌ atona bianai. ");
INSERT INTO aoj_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Eaꞌ aeꞌ deiꞌ aꞌipipa, God atiasi aꞌ nokwaha waf fafifafi hiafi feloma basef findiwaifi hiafi amam nematawa sandaꞌafi hiꞌilif okom mosoꞌanaf. Apaꞌ epen ami nendaꞌ basef findiwaefa Ambal buꞌunai Godi, God ina atiasi nokwahomanaf okom mosoꞌanaf, owaꞌatin. ");
INSERT INTO aoj_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Epen ami nendaꞌ anif basef awafi findiwaefa aeꞌ, ataga epen egefaꞌ alop epesi, bola God aꞌ nokwahomana awami amamba ananimi okom mosoꞌanam. Apaꞌ epen ami nendaꞌ basef findiwaefa Ambal buꞌunai Godi, God anaf owaꞌatin endilisi ma nogakwaha findiwa anamba aunai okom mogasoꞌanana epen inimbaia, owaꞌatin. Findiwa aunai atapina nopain, deiꞌ nogota ataꞌe nefeꞌ anaf nogota tigiꞌ togatagai wapani nope atapina. ");
INSERT INTO aoj_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Lawah buꞌugahi hail hola gwaꞌaisi buꞌwasi. Apaꞌ lawah augahi hail hola gwaꞌaisi awasi. Apaꞌ mati gwaꞌaisi sagailagahi, mogawa lawah buꞌugahi augahi. ");
INSERT INTO aoj_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Ipaꞌ epes aupai siꞌi uguf fagahasi, ipaꞌ atiasi laꞌifipa piꞌi basef fasifi? Owaꞌatin. Basef mamahifa fagape siꞌifa opalef epesi, ifimba atif esis sawalapefa malogof asasigufi. ");
INSERT INTO aoj_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Epes buꞌwasi, esis nomonas fasisi sapais eaꞌ sawalapa waf buꞌwafi. Apaꞌ epes awasi waf hiafi awafi fapais eaꞌ sawalapa waf awafi atef.” ");
INSERT INTO aoj_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","“Apaꞌ aeꞌ aꞌipipa. Basef hiafi amam nematawa sagaꞌiefi, anaf God nohaliꞌasa basef ifimba eaꞌ nowalogas nemaf afamba nogawaloga epes hiesiefi. ");
INSERT INTO aoj_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Basef ipeꞌifi atif anaf God nemeꞌepamef nowaloga ipaꞌ niꞌi ipaꞌ epes buꞌupai. Apaꞌ iꞌi owaꞌatin, eaꞌ basef ifimba ipeꞌifi atif anaf God nilif wapani nowaloga ipaꞌ niꞌi ipaꞌ epes aupai.” ");
INSERT INTO aoj_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Eaꞌ nemaf afamba anom amam dembami magawalipasa muꞌuli Godi maloma anom Farisi mahaliꞌana maꞌi, “Tisa dembinai, afaꞌ waꞌi inaꞌ nendaꞌ anom banagami siꞌi God nandaꞌami ma afaꞌ ataꞌ otolom.” ");
INSERT INTO aoj_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Owaꞌ Jisas nagwamam naꞌipam naꞌi, “Ipaꞌ amam nematawa deiꞌ pagape itap apaꞌi pandaꞌ waf awafii pegewaꞌ alafugaha Godi. Deiꞌ maina ipaꞌ paꞌi pigati aeꞌ endaꞌ hiahaom amamba igihimbaꞌmepa banagami Godi? Aeꞌ ina ihimbaꞌmepa banagami amamba ipaꞌ, owaꞌatin. Ametal inimba banagani fowaꞌ God nigihimbaꞌmanan profet Jonai atin atiasi ihimbaꞌmepan ipaꞌ. ");
INSERT INTO aoj_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Fowaꞌ aman anamba Jona aol luꞌunai nowaloꞌana nape nembel nomon nimaguf wanif, owambeh wanembeh. Eaꞌ naꞌamba atina aeꞌ ataga epen egefaꞌ alop epesi atiasi egape nimaguf wanif owambeh wanembeh itap nomon. ");
INSERT INTO aoj_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Afamba God nogawaloga esis amam nematawafi esis epes Ninivaisi sosafel solaꞌ basef fitanima filipa ma waf awafi ipaꞌ pandaꞌafi. Deiꞌ main, esis Ninive sameꞌ basef Godi Jona nagaꞌipasafi eaꞌ sambema nelelemb sakwaha waf awafi safeꞌma God. Apaꞌ aeꞌ ikilaꞌ Jona. ");
INSERT INTO aoj_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Anaf God nogawaloga epesafi, nemaf afamba anoꞌw nemataꞌw kwin dembeꞌwi kwagapani gani waꞌol awin negembaꞌmai kosafel koloma ipaꞌ pagape naꞌai kolaꞌ basef fitanima filipa kwiꞌi ipaꞌ aupai. Deiꞌ main, kwin akwamba kwapani gani itap pafeꞌ pegetambela eaꞌ kwafiꞌi kwameꞌ basefa gawa luꞌwani dembinai king Solomon nagawalipasani. Apaꞌ deiꞌ anona nigikilaꞌ Solomoni nape naꞌaꞌe. ");
INSERT INTO aoj_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Nemaf afamba anona ambal aunai nakwaha anin epen nawisi nagafiꞌi, anen nafeꞌ anamba fatauguma nolaoma anagon naꞌi nogapoma nomaꞌwa. Owaꞌ owaꞌatin. Ina nati anagona nogape, owaꞌ. ");
INSERT INTO aoj_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Eaꞌ naꞌi, ‘Aeꞌ itanima efeꞌ ipat fowaꞌ agapautai.’ Eaꞌ nafiꞌi nati ipat atamba asambehata andeandeꞌ sofaloꞌmata tape wafita. ");
INSERT INTO aoj_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Eaꞌ notanima nafeꞌ naoꞌwai anogof ambagof daiagof awagufi 7-pelaiguf wapani mafiꞌi mawis mape ipat atamba. Ambagof amamba awami aꞌowaꞌ mandaꞌ waf awafii fikilaꞌ waf awafi fowaꞌ naliꞌ nandaꞌafi. Fowaꞌ epen inimba nape awen kwasakwasala, apaꞌ deiꞌ nape awen aꞌowaꞌ nikilaꞌ endilisi poe fowaꞌ naliꞌ nagapaini. Ipaꞌ amam nematawa deiꞌ pagape itap apaꞌi pandaꞌ waf awafii, anaf pepe awepa naꞌamba atin siꞌi epen inimba.” ");
INSERT INTO aoj_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Jisas ataꞌ naꞌipasa basef atin esis amam nematawa owaꞌ, maꞌmana kwafiꞌi kwaloma owapana ananimi safiꞌi salutu andoꞌ saꞌi siꞌipana anif basef. ");
INSERT INTO aoj_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Eaꞌ anona aman naꞌipa Jisas naꞌi, “Inaꞌ nemeꞌ, maꞌmena ineꞌikwi kwaloma anom owapena ineꞌimi salutu andoꞌ saꞌi solomena siꞌi.” ");
INSERT INTO aoj_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Owaꞌ anen nagwamana basef naꞌipana naꞌi, “Maꞌmai owape aeꞌasi ami?” ");
INSERT INTO aoj_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Eaꞌ nandaꞌ lagol nondolaꞌwaifa amom alipumi ananimi naꞌipas naꞌi, “Piti maꞌme kwaloma owape aeꞌasi isimba. ");
INSERT INTO aoj_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Epes mamahisa sigaila okom Ahamai nagape heveni, ma sondaꞌ waf ananifii, isimba atis siꞌi maꞌme owape hanitiame aeꞌasi.” ");
INSERT INTO aoj_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Nemaf afamba atef Jisas nakwaha ipat nawisi andoꞌ nafeꞌ nape felefeleꞌma akata dumb luꞌwambi. ");
INSERT INTO aoj_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Eaꞌ amam nematawa hiasi safiꞌi salipana sape. Eaꞌ nalota natoma anota bot saꞌutai, apaꞌ esis salutu akata. ");
INSERT INTO aoj_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Eaꞌ nasoꞌasa basef hiafi waminif atin naꞌipas naꞌamba naꞌi, “Anona aman nafeꞌ nowaha olemb witimb siꞌi raisi anof aof. ");
INSERT INTO aoj_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Anen nowahemb nafeꞌ, anemb bewa ufiaꞌw sagafeꞌma eaꞌ amiguf fufiaꞌ fafiꞌi faꞌamb. ");
INSERT INTO aoj_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Apaꞌ anemb bewa otambaipa itap owaꞌ luꞌupa kwasalaꞌup, patoma ilif atogon, owaꞌ pewala awina. Eaꞌ batagai kwafalis. ");
INSERT INTO aoj_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Aꞌi awin natafi ma owaf faluwi fahamb alimb masilimb ina bewafa bewala itap atep, owaꞌ. Eaꞌ owaf fahamb aꞌ alimb. ");
INSERT INTO aoj_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Apaꞌ anemb bewala laꞌafena mandelef wandafumi mataga malomam maofana wit, eaꞌ amom ina mail mola gwaꞌaimi, owaꞌ. ");
INSERT INTO aoj_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Apaꞌ anemb bewa bagafeꞌ itap fasipai eaꞌ bataga balo bail bela gwaꞌaisi. Anemb bela 100-pelaimb, anemb bail bela 60-pelaimb, apaꞌ anemb bail bela 30-pelaimb atom. ");
INSERT INTO aoj_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Ipaꞌ aligah hagapaipai ma pagameꞌ basef ifimbai, pendameꞌef andeandeꞌ ukup pendapomef.” ");
INSERT INTO aoj_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Eaꞌ amom alipumi ananimi mafiꞌmai Jisas maꞌipana maꞌi, Deiꞌ maina inaꞌ nagaꞌipasa basef esis waminif atin?” ");
INSERT INTO aoj_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Eaꞌ nagwamama basef naꞌi, “God eaꞌ nihimbaꞌmepa basef kofagefa fape fandambahiꞌi ma ipaꞌ piwis nomona maol ananini nope Dembinai nugumafipa. Apaꞌ epes isimba, owaꞌatin. Anen ina nihimbaꞌmasa basef ifimba kofagefa, owaꞌ. ");
INSERT INTO aoj_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Epes ami sogahapila basef Godii, atiasi God aꞌ nowatanimasef wapani. Apaꞌ isimba owaꞌ sogahapilifia, atiasi basef kwawiaꞌwif ifimba esis sagahapilafi, God aꞌ nondalombasef esis eaꞌ sope dowaf. ");
INSERT INTO aoj_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Basef kofagefa ma aeꞌ deiꞌ agaꞌi basef waminif atinafi ma esis, ifimba. Esis satologon, apaꞌ esis ina atiasi siti anis maefah. Eaꞌ esis sogahembeꞌ semeꞌ basef, apaꞌ ina sogawa kofagefa, owaꞌatin. ");
INSERT INTO aoj_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Esis sandaꞌam naꞌamba ma anif basef fowaꞌifi fandawalap endilisi. Basef ifimba anona profet Aisaia fowaꞌ God naꞌipanaef nandaꞌafi fagaꞌias naꞌamba faꞌi, ‘Ipaꞌ anaf pegehembeꞌ pemeꞌ basef, apaꞌ ina pegawa kofagefa. Ipaꞌ petologon atapigin, apaꞌ ina piti anis maefah, owaꞌatin endilisi. ");
INSERT INTO aoj_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Deiꞌ main, ukup amam nematawa isimbai masoꞌas aꞌowaꞌ, aligah asasigahi hasoꞌas ukup iwanipa sogameꞌ basef. Eaꞌ sasopama naep asasipi ma sogati hiahawes. Eaꞌ aligah asasigahi hasoꞌasa sogameꞌ basef. Ukup asasipi pasoꞌ ma sogogawa basef kofagefa. Ama esis sombema opalef sigagiꞌma aeꞌ ma endaꞌas boꞌwes wapani. Apaꞌ owaꞌ, owaꞌatin.’ ");
INSERT INTO aoj_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“Apaꞌ ipaꞌ sonahepa. Deiꞌ main, naep ipeꞌipi eaꞌ pati hiahawes, aligah ipeꞌigahi hameꞌ basef. ");
INSERT INTO aoj_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Aeꞌ aꞌipipa endilisi, fowaꞌ amom profet hiami maloma anom amam mandaꞌ waf usiꞌifi hililiꞌi maꞌi miti hiahaom amamba deiꞌ ipaꞌ pagatulumi, apaꞌ ina matolom, owaꞌatin. Ukup amamipi paꞌipaꞌi aꞌowaꞌ ma mogameꞌ basef ifimba ipaꞌ pagameꞌafi, apaꞌ owaꞌ, owaꞌatin. Amom ina mameꞌef.” ");
INSERT INTO aoj_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Ipaꞌ pemeꞌ basef kofagefa ifimba waminif atini ma aman anamba nogowaha olemb gwaꞌaimbi aofi. ");
INSERT INTO aoj_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Basef ifimba ma epes sogawis nomona maol Godi nope Dembinai nugumafias fagape naꞌamba. Olemb begewa ufiaꞌwi ambamba siꞌi epes isimba sagameꞌ basef ifimbai, apaꞌ esis owaꞌ ukup pepemefa. Eaꞌ Satan nafiꞌi nelefata basef ifimba God nagawef nomon ukup asasipii. ");
INSERT INTO aoj_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Apaꞌ anemb bewa bafeꞌ anagon otambaigimai, ambamba siꞌi anis epes sameꞌ basef Godi sofaꞌef kwafalis sandagalamef. ");
INSERT INTO aoj_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Apaꞌ isimba siꞌi masilimb owaꞌ bendala itap awinia. Esis sahapilif nogota bandata ma aꞌi owaꞌ, anis amam nematawa sandaiwaꞌma sagahapifa basef Godi sandaꞌas findiwas, sahas, sandaꞌmasa waf awafi eaꞌ kwafalis atis sandahagas sakwaha sagahapifa Godi. ");
INSERT INTO aoj_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Anemb begewala mandelef wandafumi laꞌafini, ambamba siꞌi anis sameꞌ basef sailif safeꞌ, owaꞌ nomonas salasafeꞌ ma hiahaom magape itapi ma ukup pagapagaila moni maim hiami eaꞌ amambai mataga maofana basef Godi. Eaꞌ ina sahapifif sandaꞌ waf buꞌwafi banages, owaꞌatin. A sowa siꞌi gwaꞌaisi owaꞌ sogalo andeandeꞌia. ");
INSERT INTO aoj_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Apaꞌ anemb begewa itap fasipai siꞌi epes isimba sameꞌ basef buꞌwafi ma ukup asasipi pagapomef sahapilif sogawefa sandaꞌ waf fasifii. Anis sandaꞌ waf buꞌwafi siꞌi begela 100-pelaisi, apaꞌ anis siꞌi begela 60-pelaisi. Apaꞌ anis siꞌi begela 30-pelaim dowafi.” ");
INSERT INTO aoj_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Eaꞌ Jisas naꞌipasa anif basef waminif atini wapani esis amam nematawa hiasi naꞌi, “Epes sogawis nomona maol Godi nope Dembinai nugumafias siꞌi anona aman nafeꞌ nogowaha olemb fasimbi gwaꞌaimbi aof ananifi. ");
INSERT INTO aoj_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Aꞌi owaꞌ owamb esis hiasi sagaꞌihi, anin epen bouni ananini nafiꞌi, nowaha otalef awalifi wapani aof afamba anen dokoꞌ nogowaha olemb buꞌwambia eaꞌ nafeꞌ. ");
INSERT INTO aoj_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Ama main, olemb ambamba buꞌwambi bataga ma benafa bela gwaꞌaisi, amom mandaꞌ maola aman kofagonama aofi eaꞌ mati otalef awalifi fataga fape faloma olemb fasimbi. ");
INSERT INTO aoj_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Eaꞌ mati naꞌamba, mafiꞌi maꞌipa anen maꞌi, ‘Dembinai, afaꞌ waꞌi owaꞌ inaꞌ newaha olemb gwaꞌaimbi aof ineꞌifi. Apaꞌ otalef amamba awasimi magaluwi. Ami newahom mataga?’ ");
INSERT INTO aoj_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Eaꞌ naꞌipam naꞌi, ‘Anona aman bounai nandaꞌam.’ Eaꞌ maꞌipana maꞌi, ‘Inaꞌ naꞌi afaꞌ ofeꞌ ugi otalef amamba awami owaꞌaniam moꞌoh atogon?’ ");
INSERT INTO aoj_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Owaꞌ aman anamba naꞌipam naꞌi, ‘Ahaeꞌ owaꞌ. Naꞌamba pelelama wit a pigiam moloma otalef awalifi. ");
INSERT INTO aoj_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Ipaꞌ kwahowam mondape atifima laꞌisitai daoꞌ, eaꞌ winifaꞌam. Nogota atamba sogofaꞌ gwaꞌaisiatai, aeꞌ iꞌipa amom mandaꞌ maol inimbai iꞌipam iꞌi, ‘Ipaꞌ piwaꞌania otalef afalemba awalifi piwasiꞌalef ondogw feꞌeha pegaofalef. Eaꞌ petama wit pefaꞌam pekolasom mofeꞌ muwis moꞌoh ipat aeꞌatai.’” ");
INSERT INTO aoj_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Eaꞌ Jisas nasoꞌasa anif basef waminif atin wapani naꞌi, “Epes sogawis nomona maol Godi nope Dembinai nugumafias siꞌi nalelef saꞌutipilif saꞌulifi. Anona aman nofaꞌalef nawalef aof ananifi. ");
INSERT INTO aoj_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Anelef nalelef mastetilif saꞌusaꞌulifi. Ina luꞌwalef siꞌi saꞌutip gwaꞌaipi lawah hiagahi, owaꞌ. Afalemba saꞌusaꞌulef aꞌowaꞌ. Apaꞌ natagai ma nagalo, luꞌuna nikilaꞌ gwaꞌaisi hiasi sagape aufahi. Anen nataga lawag luꞌunai eaꞌ amiguf fafiꞌi fala owah fatoma agufugama.” ");
INSERT INTO aoj_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Eaꞌ nawalapa anif basef waminif atini wapani ma esis naꞌi, “Epes isimba sogawis nomona maol Godi nope Dembinai nugumafias siꞌi yis anoꞌw nemataꞌw kofaꞌas kwambemas saloma plaua hiami magala dram luꞌwamii. Aꞌi owaꞌ main, aꞌ matef luꞌum.” ");
INSERT INTO aoj_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Basef ifimba hiafi Jisas naꞌipasef waminif atina amam nematawa isimba hiasi. Anen ina naꞌipasef alihif, owaꞌatin. Naꞌif waminif atin. ");
INSERT INTO aoj_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Deiꞌ anif basef anona aman profet fowaꞌ nandaꞌafi deiꞌ eaꞌ fataga fandawalap. Profet anamba nagaꞌias naꞌamba naꞌi, “Anaf aeꞌ igaꞌi malogol iꞌi basef waminif atin. Aeꞌ iꞌi basef fape fandambahiꞌi dambadamba God nandaꞌ ilifi itap fafiꞌi fafiꞌi fataga deiꞌ.” ");
INSERT INTO aoj_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Eaꞌ Jisas nosafel nakwaha esis amam nematawa hiasi nafeꞌ ipat, eaꞌ alipumi ananimi mafiꞌmai anen maꞌipana maꞌi, “Basef ifimba waminif atina otalef awalifi fagataga aofi, inaꞌ aꞌ newalapa kofagefa ma afaꞌ.” ");
INSERT INTO aoj_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Eaꞌ Jisas nagwamam basef naꞌipam naꞌi, “Aman nogowaha olemb buꞌwambii anamba aeꞌ ataga epen egefaꞌ alop epesi. ");
INSERT INTO aoj_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Apaꞌ aof afamba siꞌi walemb itap apaꞌe hiagoma hiꞌalagon. Eaꞌ olemb ambamba buꞌwambi siꞌi epes sogawis nomona maol Godi nope Dembinai nugumafias. Apaꞌ otalef awalifi, afalemba siꞌi epes awasisi Satani. ");
INSERT INTO aoj_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Eaꞌ aman anamba bounai nogowaha otalef awalifii, anen Satan. Eaꞌ nogota atamba sogola gwaꞌaisiatai, atamba siꞌi nemaf akutaifi ma itap apaꞌe hiagoma. Apaꞌ amam amamba mogola gwaꞌaimi witi, amamba siꞌi amom ensel. ");
INSERT INTO aoj_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Nemaf afamba amom motama otalef awalifi mofalef nif hiꞌigalalef naꞌamba atin siꞌi nemaf akutaifi. ");
INSERT INTO aoj_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Aeꞌ ataga epen egefaꞌ alop epesi anaf aeꞌ esapaꞌi amom ensel aeꞌami eaꞌ motofa hiahaom amamba hiami mandaꞌ epes sandaꞌ waf awafii, moloma amam nematawa isimba hiasi hiꞌilas sandaꞌ waf awafii muliꞌamonas sogakwaha anamba aeꞌ agalaꞌambemagoma. ");
INSERT INTO aoj_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Eaꞌ amom ensel aꞌ mokwaha epes isimba sofeꞌ nif luꞌwafi, sope nif amamba selef kwapeteꞌas nalelef tilili talalaꞌ sope awes. ");
INSERT INTO aoj_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Nemaf afamba amam nematawa buꞌwasi sogalaꞌ aꞌowaꞌ siꞌi awin alipini anamba Ahamas nagalaꞌambemagoma. Epes aligah hagapaipai, ipaꞌ pendameꞌ basef ifimba andeandeꞌ. ");
INSERT INTO aoj_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Epes sogawis nomona maol Godi nope Dembinai nugumafias siꞌi anin moni sambahoꞌwan nagape anof aof itapi. Eaꞌ anona aman nafiꞌi natilin nambahoꞌwan wapani. Anen sonahana endilisi nafeꞌ nofala anis epes safiꞌi sasoꞌana moni ma satala hiahawes ananisi hiꞌagalas. Eaꞌ nofaꞌ moni inimba nafeꞌ natala aof afamba. ");
INSERT INTO aoj_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Epes sogawis nomona maol Godi nope Dembinai nugumafias siꞌi anona aman nandaꞌ bisnisi nalaꞌ nogolaoma anis bahigis fasifasisi atis. ");
INSERT INTO aoj_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Eaꞌ nati anis fasisi endilisi sagatalis otamba hiambaii nofala anis epes safiꞌi ma sogasoꞌana otamba sogatala hiahaom ananimi hiꞌigalam. Eaꞌ nofaꞌ otamba ma isimba nafeꞌ natala bahigis isimba sowasuwaisi atis. ");
INSERT INTO aoj_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Anif wapani. Epes sogawis nomona maol Godi nope Dembinai nugumafias siꞌi anona anemb anom amam mafeꞌ malana nowala dumb awina migiliꞌamai agof mamimami. ");
INSERT INTO aoj_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Eaꞌ anemb anamba asiꞌina ma agof mahondoꞌana nafiꞌi akata wataꞌita. Eaꞌ mape manifaꞌ agof fasigufi atogof maloꞌagof folalef. Apaꞌ agof amamba awasimi makwahom. ");
INSERT INTO aoj_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Ama anef nemaf akutaifi itap apaꞌe eaꞌ naꞌamba atin siꞌi amom maganifaꞌ agof fasigufi dei awasigufi dei. Amom ensel anaf mufiꞌi munifaꞌ epes sandaꞌ waf awafii sagape laꞌafena amam nematawa isimba fasisii mofaꞌas mefeꞌ ");
INSERT INTO aoj_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","mokwahis sofeꞌ nif luꞌwami. Ama sogape nif amamba luꞌwami sowa selef kwapeteꞌas nalelef tilili talalaꞌ sogape.” ");
INSERT INTO aoj_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Eaꞌ Jisas nahaliꞌam naꞌi, “Ipaꞌ eaꞌ pegawa basef ifimba hiafi aꞌa owaꞌ?” Eaꞌ magwamana maꞌi, “Ahoꞌ.” ");
INSERT INTO aoj_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Eaꞌ naꞌipam naꞌi, “Amom hiami dembami magawalipas muꞌuli Godi molafa basef ananifi ma mugawis nomona maol ananini nope Dembinai nugumafiam amom mandahama naꞌamba. Amom siꞌi anona aman kofagonama ipati. Anen nafeꞌ nawis ipat nomon nofaꞌai hiahawes fasisi, namisi saloma apisi eaꞌ nofaꞌas nafiꞌi.” ");
INSERT INTO aoj_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Jisas nawalipam basef ifimba waminif atini ma eaꞌ, nakwaha wambel ambalemba ");
INSERT INTO aoj_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","nafeꞌ wambel ananimbili kofagama. Eaꞌ nawis ipat esis Juda sandakolasatai nasefela basef Godi naꞌipasef. Anen naꞌias naꞌamba esis agogolalasis kwapeteꞌ saꞌi, “Gawa inimba naloma banagami amamba ma nandaꞌ hiahaom siꞌi God nandaꞌami, anen nofaꞌami ani? ");
INSERT INTO aoj_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Aꞌi aman anamba nogama aman nagalaꞌ ifagwi Maria kogolanai aꞌa? Apaꞌ mogawa owapana ananimi Jems Josep Saimoni Judas mape naꞌa. ");
INSERT INTO aoj_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Hanitiamana ananiwai wape walomapa naꞌa. Apaꞌ hiahaom amamba gawa banagani anen nofaꞌani ani?” ");
INSERT INTO aoj_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Eaꞌ sowaꞌ alafugaha anen. Owaꞌ Jisas naꞌipas naꞌi, “Anona profet agol gatomana analemb walemb hielimbi daialemb, saꞌi anen dembinai sahapifana. Apaꞌ ina anagol agol gatoma gandawalapana alihigila wambel kofagama ananima, a ipat ananitai nagapoma, owaꞌatin.” ");
INSERT INTO aoj_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Esis owaꞌ sogahapifa aninia. Naꞌamba deiꞌ anen ina nandaꞌ anom hiahaom banagami hiami wambel ambalemba, owaꞌatin. ");
INSERT INTO aoj_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Nemaf afamba anona aman agilinama Herot nape dembinai gavmana itap luꞌupa Galili. Anen nameꞌ basefa maol buꞌwani Jisas nandaꞌani, eaꞌ nameꞌ sasaꞌma agol Jisasi gafeꞌ luꞌwagol. ");
INSERT INTO aoj_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Eaꞌ Herot naꞌipa isimba sandaꞌmana maol naꞌi, “Aman anamba Jon nagapisiꞌas embeli, aꞌ nosafel wapani deiꞌ nape banagona nandaꞌ maol siꞌi God nandaꞌani.” ");
INSERT INTO aoj_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Fowaꞌ basef ifimba fagape naꞌamba. Herot owamana Filip wauluꞌmana ananiꞌwi agiliꞌwa Herodias. Eaꞌ sahomana Herot nandalombanaꞌw. Eaꞌ Jon naꞌipa Herot naꞌi, “Inaꞌ nasoꞌ nemataꞌw sahomenai, eaꞌ nawala muꞌuli Godi. Naꞌambai ina andeandeꞌ, owaꞌ.” Apaꞌ Herod nandaiwaꞌma nogaliꞌamonaꞌw eaꞌ naꞌipa amom soldia mofaꞌ Jon mafeꞌ mandaꞌana nandaꞌ kalabus. ");
INSERT INTO aoj_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Herot naꞌi nohana nogaꞌ apaꞌ owaꞌ owaꞌatin. Deiꞌ main, anen ombal mahanama amam nematawa hiasi saꞌi Jon anen profet. Naꞌamba Herot ina nahana, owaꞌ. ");
INSERT INTO aoj_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","7","Nafeꞌ ma anef nemaf Herot nofala epes hiasi safiꞌi sandaꞌ kolasa nandagalama nemaf maꞌmana kogolanafi. Nemaf afamba Herodias nogamaꞌw kwafiꞌi kwawisi nomon kwalutu kwalemb. Esis hiasi satoloꞌw eaꞌ Herot nandagalamaꞌw naꞌi basef endilifi atif nagaꞌif banagafi naꞌi, “Endilisi aeꞌ aꞌipina, iꞌi inaꞌ niꞌipa aeꞌ ma egaseꞌena anom maefah, aeꞌ igasiꞌenami.” ");
INSERT INTO aoj_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Eaꞌ akoꞌw kwafeꞌma maꞌmakw kwaꞌipaꞌw kwafeꞌ kwaꞌipa Herot kwaꞌi, “Deiꞌ atef aeꞌ aꞌi inaꞌ neha aman anamba Jon nagapisiꞌas embeli nogaꞌ netopaꞌ balaga gola anota plet nefaꞌagai neseꞌe.” ");
INSERT INTO aoj_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","11","Akoꞌw kwaꞌias naꞌamba, opaf Heroti aꞌ nemanif aꞌowaꞌ. Apaꞌ anen okom mandandaꞌ ma naꞌi basef endilifi atif nagaꞌif banagafi, eaꞌ amam nematawa hiasi isimba sameꞌana. Eaꞌ nasapaꞌ anona aman soldia nafeꞌ ipat kalabusitai natopaꞌ bamatoꞌw Joni nala balaga gala plet nafiꞌi nasoꞌ Herodias nogamaꞌw kofaꞌaga kwafeꞌ kwasoꞌ maꞌmakw. ");
INSERT INTO aoj_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Eaꞌ amom alipumi Joni mafiꞌi mofaꞌ alop ananipi mafeꞌ mawana matmat. Eaꞌ mafeꞌ maꞌipa Jisasa hiahaom amamba. ");
INSERT INTO aoj_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Jisas nameꞌ basef ifimba, anen atona nafeꞌ nakwaha wambel ambalemba nofaꞌ bot nafeꞌ anagon wafigima epes akagoma. Eaꞌ amam nematawa hiasi sameꞌ basefa Jisas nafeꞌ sakwaha wambel hiagoma asasima sailana safeꞌ ufiaꞌw saꞌi sotolona. ");
INSERT INTO aoj_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Jisas nafeꞌ nataga akata nati esis hiasi nati uwahipis. Eaꞌ nati epes asasisi aowas nandaꞌasi, nandaꞌas boꞌwes wapani. ");
INSERT INTO aoj_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Aꞌi owaꞌ main wambomota felefeleꞌma owamb alipumi ananimi mafiꞌi maꞌipana maꞌi, “Afaꞌ wape naꞌa wafigima eaꞌ wambomota felefeleꞌma owamb. Inaꞌ nesapaꞌas sofoꞌo analemb walemb sogotala gwaꞌaisi sondaꞌas sogaꞌas.” ");
INSERT INTO aoj_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Owaꞌ Jisas nagwamam naꞌipam naꞌi, “Aeꞌ ina esapaꞌas sefeꞌ, owaꞌ. Ipaꞌ atipa peseꞌas gwaꞌaisi.” ");
INSERT INTO aoj_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Eaꞌ amom maꞌipana maꞌi, “Afaꞌ gwaꞌaisi owaꞌ hiasa. Bret waꞌagolita taloma agof biagof eaꞌ maꞌwis saꞌomafa.” ");
INSERT INTO aoj_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Eaꞌ naꞌipam naꞌi, “Ipaꞌ faꞌas fiꞌi peseꞌeas aeꞌ.” ");
INSERT INTO aoj_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","20","Eaꞌ naꞌipa amam nematawa hiasi sape otalef boꞌwalifi itap. Eaꞌ nasaꞌma bret atamba waꞌagolita taloma agof naniga nati heven ilif naꞌi nanifela God. Ama eaꞌ, nindiwata nasoꞌ alipumi ananimi mafeꞌ masoꞌas saꞌas dondoꞌ aꞌ alihis andeandeꞌ. Eaꞌ alipumi ananimi matatama duꞌwaꞌwanis sagasagaꞌihi maloꞌwas folalef luꞌwalifi 12-pelailif asiꞌilif kwaef. ");
INSERT INTO aoj_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Epes sagaꞌ gwaꞌaisi isimbai hiasi. Esis siamba amam atom mataga 5000-pelaim. Apaꞌ ina siamba awasi nematawa, owaꞌ. ");
INSERT INTO aoj_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Jisas nasapaꞌ alipumi ananimi mofaꞌ bot maliꞌ mafeꞌ dumb ambamba mambo fisana. Eaꞌ nasapaꞌ amam nematawa hiasi safeꞌ. ");
INSERT INTO aoj_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Safeꞌma eaꞌ, anen atona nalota anota halafuta nape nandabeten nahaliꞌ God. Wambomota felefeleꞌma owamb, anen atona ataꞌ napani halafuta ilif. ");
INSERT INTO aoj_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Apaꞌ alipumi ananimi mape bot maliꞌ mafeꞌ mandasapaꞌ dumb laꞌafimba, owaꞌ fufin luꞌwani nalo nafiꞌi. Eaꞌ embel lasialiꞌ mafiꞌi mahagasai bot. Eaꞌ fufin wapani nakotoꞌma bot, tandaꞌam bimi bema tala. ");
INSERT INTO aoj_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Akot ataꞌ tail atin, felefeleꞌma logola, owaꞌ Jisas nagiꞌmam natoma nafeꞌ embel ilif nafeꞌma amom. ");
INSERT INTO aoj_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Amom mati anen nalutu nafiꞌi embel ilif, ombal maham kwapeteꞌ maꞌi owaꞌ, anona gamba nailam nafeꞌ. Eaꞌ mandaꞌam wiwa maꞌoh kwapeteꞌ. ");
INSERT INTO aoj_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Owaꞌ Jisas nalomam naꞌi kwafalis naꞌi, “Ipaꞌ banagepa, ombel mogahepa owaꞌ. Aeꞌ atowe maꞌuwi ailipa afiꞌi.” ");
INSERT INTO aoj_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Eaꞌ Pita nagwamana naꞌipana naꞌi, “Dembinai! Iꞌi inaꞌ maꞌwina, niꞌipa aeꞌ ilutu efeꞌmago inaꞌ embel ilif.” ");
INSERT INTO aoj_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Eaꞌ Jisas naꞌipana naꞌi, “Inaꞌ fiꞌi.” Eaꞌ Pita nakwaha bot natoma nafeꞌ embel ilifam nafeꞌma Jisas. ");
INSERT INTO aoj_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Apaꞌ owaꞌ, anen nati embel mohafel luꞌum, ombal mahana naꞌi aꞌ nowala embel. Eaꞌ nofala Jisas naꞌi, “Dembinai! Inaꞌ topalopae.” ");
INSERT INTO aoj_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Eaꞌ kwafalis atis Jisas nowasaꞌ lagol nahapilana naꞌipana naꞌi, “Inaꞌ owaꞌ nihapilif banagena niꞌi aeꞌ laꞌifiwaia, owaꞌ. Deiꞌ maina inaꞌ nomonas sagape biafis?” ");
INSERT INTO aoj_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Eaꞌ amom biam malota bot, fufin naloma embel mandahagas. ");
INSERT INTO aoj_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Eaꞌ amom magape boti mati hiahaom amamba mandaꞌ lotuma Jisas mafela agol Godi luꞌwagol maꞌi, “Endilisi atis, inaꞌ Nogamana Godi.” ");
INSERT INTO aoj_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Eaꞌ Jisas naloma alipumi ananimi mowala mambo dumb ambamba mafeꞌ mataga anagon itap luꞌupa Genesaret. ");
INSERT INTO aoj_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Eaꞌ anis epes sagape itap apambai sogawana saꞌi anamba Jisas. Eaꞌ sasapaꞌ anis safeꞌ saꞌipa anis sagape felefeleꞌi sofaꞌai anis aowas nandaꞌasi safiꞌmai anen. ");
INSERT INTO aoj_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Eaꞌ sofaꞌai isimba aowas nandaꞌasi saꞌipana saisailana saꞌi anen niꞌi ahoꞌma isimba sogahapila lowaf ananifi daꞌmalififa atef. Eaꞌ epes mamahisa sagahapilaf lowaf ananifii sataga boꞌwes wapani. ");
INSERT INTO aoj_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Nemaf afamba anom Farisi dembami esis Judai maloma anom amam dembami magawalipasa muꞌuli Godi, makwaha Jerusalem mafiꞌmai Jisas. Eaꞌ mahaliꞌana maꞌi, ");
INSERT INTO aoj_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Deiꞌ maina alipumi ineꞌimi mugumbisilaꞌ waf apeꞌifi akupapa magasoꞌapafi? Ama amom owaꞌ mosaꞌopa lagofa mogaꞌ gwaꞌaisia.” ");
INSERT INTO aoj_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Eaꞌ Jisas nagwamama basef naꞌi, “Deiꞌ maina ipaꞌ pagawala muꞌuli Godi ma pagaila waf ipeꞌifi atef? ");
INSERT INTO aoj_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Ipaꞌ pawala basef God naꞌif nagaꞌi, ‘Ipaꞌ pinifela mamasepa ipeꞌisi pihapifas petopalopas. Epen ami nigaꞌi basef awafi ma ahaman maꞌman ananisii, inimba anis daias sohan negaꞌ.’ ");
INSERT INTO aoj_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Owaꞌ ipaꞌ pambasoꞌam paꞌi anif daif naꞌamba paꞌi, Epen mamahina nindaiwaꞌma negatopalopa mamasan niꞌipas niꞌi, ‘Otamba mais aeꞌasi andaiwaꞌma egaseꞌepas. Aeꞌ aꞌ andandepasa egasoꞌanas God.’ ");
INSERT INTO aoj_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Apaꞌ ipaꞌ Farisi paloma ipaꞌ anipa pagawalipasa muꞌuli Godi, ipaꞌ paꞌi ahoꞌma epen inimba negambasoꞌma mamasan, eaꞌ owaꞌ netopalopasa.” Ipaꞌ pandaꞌ waf afambai pesambala basef ifimba Godi naꞌi mogatopalopa mamasapa. Eaꞌ pandaꞌ waf ipeꞌifi atef luꞌuf. ");
INSERT INTO aoj_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Fowaꞌ profet Aisaia nondolaꞌwaifa ipaꞌ endilisi, ipaꞌ pagaꞌi basefa malogof biagufi. Anen nandaꞌef andeandeꞌ dondoꞌma ipaꞌ, naꞌias naꞌamba naꞌi, ");
INSERT INTO aoj_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Amam nematawa isimba sasaꞌma agol aeꞌagili luꞌwagola malogof asasigufi atogof andoꞌ, apaꞌ opalef asasilifi fape laogona aeꞌ. Ukup asasipi ina sahapifi, owaꞌ atin. ");
INSERT INTO aoj_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Esis ina sawalipasa basef aeꞌafi. Esis sawalapa muꞌuli epes sagape itapi atin sambasoꞌmas saꞌi, “Muꞌuli inimba basef Godi.” Eaꞌ sandaꞌ lotu sasaꞌma agol aeꞌagili dowadowaf.’” ");
INSERT INTO aoj_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Eaꞌ Jisas nofala esis amam nematawa hiasi safiꞌmai anen naꞌipas naꞌi, “Ipaꞌ pemeꞌ basef ifimba andeandeꞌma pegegawef. ");
INSERT INTO aoj_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Hiahawes gwaꞌaisi mais andoꞌasi ipaꞌ pagaꞌasi sagawis nomoni, isimbai ina sandaꞌepa awepa, owaꞌ. Apaꞌ hiahaom magape ukup ipeꞌipi nomoni mawisi andoꞌ, amambai atom mandaꞌepa awepa.” ");
INSERT INTO aoj_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Eaꞌ alipumi ananimi 12-pelaim mafiꞌmai anen maꞌipana maꞌi, “Inaꞌ negawa amom Farisi mameꞌ basef ifimba ineꞌifi mandaiwaꞌmef nelelemb aoma inaꞌ?” ");
INSERT INTO aoj_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Eaꞌ nagwa basef waminif atina amom naꞌipam naꞌi, “Ahame aeꞌanai nagape heveni nawa hiahaom anof aof. Eaꞌ hiahaom hiami anen owaꞌ nogowamia amamba anaf aꞌ nigiam moloma nombalef masilimb. ");
INSERT INTO aoj_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Ipaꞌ kwahowa amom amamba Farisi ataꞌ mondape. Amom siꞌi amam naep pagasoꞌami maꞌi migihimbaꞌma ufiaꞌwa anis daias. Iꞌi esis naep pagasoꞌasi siꞌi sigihimbaꞌmasa ufiaꞌw anis epes isimba naep pagasoꞌasii, atiasi esis hiasi dogwas sefeꞌ sowa asondakolef atin sowasowala sope kwambiwag.” ");
INSERT INTO aoj_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Eaꞌ Pita nagwamana basef naꞌipa Jisas naꞌi, “Inaꞌ niꞌi basef ifimba kofagefa waminif atina hiahaom awami ma afaꞌ ataꞌ omeꞌef.” ");
INSERT INTO aoj_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Eaꞌ Jisas naꞌipam naꞌi, “Ipaꞌ wapani nomonas ataꞌ akepa aꞌa? ");
INSERT INTO aoj_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Aꞌi ipaꞌ owaꞌ ataꞌ pegawaea! Hiahaom andoꞌami mawis malogofa mogowala nelelembi, amamba eaꞌ motanima mawisi andoꞌ mafeꞌ mowala dowah. ");
INSERT INTO aoj_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Apaꞌ hiahaom magape ipaꞌ nomoni, ukup nomonas awami maim mataga andoꞌ, amambai atom mandaꞌepa awepa. ");
INSERT INTO aoj_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Hiahaom awami magape ukup nomoni magawisii amamba. Ukup awami, waf soha anis sogagaꞌi, sondaꞌ soꞌa waola anis amam nematawa daindaiasi, eaꞌ sondaꞌ anef waf awafi siꞌi waf afamba soꞌa waulafi, wal, basoꞌam, findiwa. ");
INSERT INTO aoj_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Waf afambai atef fawisi andoꞌ fandaꞌ epes awasis. Apaꞌ epes owaꞌ sosaꞌopa lagof andeandeꞌma sogaꞌ gwaꞌaisia siꞌi amom Farisi magaꞌi, amambai ina mandaꞌas awes, owaꞌatin.” ");
INSERT INTO aoj_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Eaꞌ Jisas nakwaha wambel ambalemba nafeꞌ gani waꞌol itap felefeleꞌma walemb ambalemba bialemb Tairi Saidon. ");
INSERT INTO aoj_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Owaꞌ anoꞌw nemataꞌw Kenaniꞌwi kwape naꞌamba. Akoꞌw kwafiꞌi kofalana naꞌamba kwaꞌi, “O, Dembinai, inaꞌ akunamana Deviti, inaꞌ niti aeꞌ uwahipiwi. Ambal aunai nahambombaga nogame aeꞌakwi endilisi.” ");
INSERT INTO aoj_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Owaꞌ Jisas ina nagwamaꞌwa anif basef akoꞌw, owaꞌ. Eaꞌ amom alipumi ananimi mafiꞌmai anen maꞌipana maꞌi, “Nemataꞌw akwamba kwandaꞌam falafala kwagiꞌmafai. Inaꞌ sapaꞌakw kotanima kofoꞌo!” ");
INSERT INTO aoj_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Eaꞌ Jisas nagwa basef naꞌipaꞌw naꞌi, “God nasapaꞌ aeꞌ afiꞌi ma epes sagape siꞌi sipsip higilagalapi isimba esis Israeli atis.” ");
INSERT INTO aoj_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Owaꞌ akoꞌw kwafiꞌi kwindiwa nembawa kwotawa felefeleꞌma anen kwaꞌi, “Dembinai, inaꞌ natopalopa aeꞌ.” ");
INSERT INTO aoj_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Eaꞌ nagwamaꞌwa basef naꞌi, “Apaꞌ ina mofaꞌ gwaꞌaisi awasi apeꞌisii mokwahis sofeꞌma nombagw, owaꞌ.” ");
INSERT INTO aoj_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Owaꞌ akoꞌw kwagwamana basef anen kwaꞌi, “Dembinai, inaꞌ naꞌi endilisi. Nombagw agogw gwafeꞌ lafela tebol gwatatama gwaꞌaisi mamasagw agwagwisii sogowa itapi gwaꞌas.” ");
INSERT INTO aoj_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Akoꞌw kwaꞌias naꞌamba, Jisas nagwamaꞌwa basef naꞌi, “O, nemataꞌw, hapif ineꞌini luꞌwani. Deiꞌ hiahawes ina okom magaꞌiasi atiasi sotagamena siꞌi inaꞌ nagaꞌias.” Eaꞌ nogota atamba atota nogamaꞌw akwaꞌukwi amboꞌokw wapani. ");
INSERT INTO aoj_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Jisas nakwaha wambel ambalemba nafeꞌ felefeleꞌma dumb Galili. Eaꞌ nondowasaꞌ halafuta tol nape. ");
INSERT INTO aoj_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Eaꞌ esis amam nematawa hiasi safiꞌi salagamana sofaꞌi aowas naninani nandaꞌasi safiꞌmai anen. Anis boꞌwagah awamisi, anis naep pagasoꞌasi, bihitagof mondolaꞌasi, anis malogof fagasoꞌasi, aowas anamba hianai. Esis sofaꞌas safiꞌi sambeꞌas saꞌoh felefeleꞌma boꞌwagah Jisasi eaꞌ nandaꞌas boꞌwes. ");
INSERT INTO aoj_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Eaꞌ esis gogolalasisa sagati epes isimba naep pagasoꞌasi satologon, malogof fagasoꞌasi saꞌi, bihitagof mondolaꞌasi eaꞌ usiꞌim, boꞌwagah awasimisi eaꞌ boꞌom safeꞌ. Eaꞌ deiꞌ esis hiasi sasaꞌma agol God Israeli luꞌwagol. ");
INSERT INTO aoj_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Eaꞌ Jisas nofalai alipumi ananimi mafiꞌi naꞌipam naꞌamba naꞌi, “Aeꞌ ati esis amam nematawa isimba uwahipis. Esis sape salome nimaguf wanif gwaꞌaisi akas aꞌ nolomahas aꞌowaꞌ. Iꞌi aeꞌ esapaꞌas sogafeꞌ dowaf uta baop asasima, sitilif atona atona sowa soꞌoh sofeꞌ ufiawa.” ");
INSERT INTO aoj_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Eaꞌ alipumi ananimi maꞌipana naꞌamba maꞌi, “Naꞌa wafigima epes akagoma. Atiasi afaꞌ ofaꞌai bret atamba ani ma ogasoꞌ amam nematawa isimba hiasi?” ");
INSERT INTO aoj_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Eaꞌ Jisas naꞌipam naꞌi, “Deiꞌ ipaꞌ bret maꞌufita taꞌoh?” Owaꞌ amom maꞌi, “Afaꞌ bret 7-pelaita taloma agof saꞌugufi kwasalaꞌuguf.” ");
INSERT INTO aoj_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Eaꞌ Jisas naꞌipa esis amam nematawa ma sogape itap, ");
INSERT INTO aoj_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","nasaꞌma bret 7-pelaita taloma agof agwafomba nanifela God nawalis nasoꞌ alipumi ananimi ma mogasoꞌasas esis amam nematawa hiasi. Amom masoꞌas hiꞌalas dondoꞌ. ");
INSERT INTO aoj_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Eaꞌ saꞌas dondoꞌ aꞌ alihis andeandeꞌ. Eaꞌ alipumi ananimi matatama duꞌwaꞌwanisi sagasagaꞌihi makolasis maloꞌwas folalef luꞌwalifi 7-pelailif asiꞌilif kwaef. ");
INSERT INTO aoj_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Esis amam nematawa sagaꞌ gwaꞌaisi isimbai, siamba amam atom mataga 4,000-pelaim. Apaꞌ esis ina siamba awasi nematawa wapani, owaꞌ. ");
INSERT INTO aoj_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Ama Jisas nasapaꞌas sagafiꞌi, anen nalota bot nafeꞌ gani waꞌol dumb luꞌwambi anep itap luꞌupa Magadan. ");
INSERT INTO aoj_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Eaꞌ anom dembami Farisi maloma anom dembami daiam Sadyusi mafiꞌmai Jisas maꞌi mogwambana ma anen ataꞌ nondaꞌ anom banagami siꞌi God nagape ilifi nandaꞌami ma ataꞌ motolom. ");
INSERT INTO aoj_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Owaꞌ anen nagwamam anif basef waminif atin naꞌi, “Ipaꞌ pagati otaga wambomota felefeleꞌma owamb aꞌ paꞌi, ‘Otaga nasaꞌof akwahina. Naꞌamba atiasi nogota boꞌotama owaf figalowatai.’ ");
INSERT INTO aoj_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Apaꞌ kuhumbita paꞌi, ‘Otaga ilagw eaꞌ alialim. Mandaꞌam naꞌamba ma atiasi fufini asaf mogataga.’ Ahoꞌ, ipaꞌ pati ametal hiani ilifani itapani andeandeꞌ apaꞌ deiꞌ ipaꞌ owaꞌ pegawa ametal nogota ataꞌili andeandeꞌa. ");
INSERT INTO aoj_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Ipaꞌ miniꞌap amam nematawa deiꞌ pagape itap apaꞌi pandaꞌ waf awafii pegewaꞌ alafugaha Godi. Deiꞌ pefalagama paꞌi pigati anin ametal banagani. Apaꞌ aeꞌ owaꞌatina endaꞌan pigatilina, owaꞌatin. Ametal inimba banagani fowaꞌ God nigihimbaꞌmanan profet Jonai atin atiasi ihimbaꞌmepan ipaꞌ.” Jisas naꞌipam eaꞌ, nakwahom nafeꞌ. ");
INSERT INTO aoj_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Eaꞌ Jisas naoꞌwa alipumi ananimi mofaꞌ bot mowala mambo dumb ambamba mataga fisana, apaꞌ amom ukup pasoꞌama mofaꞌ anota bret togalomam. ");
INSERT INTO aoj_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Eaꞌ Jisas naꞌipam naꞌi, “Ipaꞌ pindimafuma andeandeꞌ, solawaipama yis amamba amom Farisii maloma amom Sadyusii!” ");
INSERT INTO aoj_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Eaꞌ amom mameꞌ anen naꞌias naꞌamba, amom mandaꞌipama maꞌi, “Afaꞌ okom masoꞌafa bret taꞌihi, deiꞌ naꞌipafa.” ");
INSERT INTO aoj_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Owaꞌ Jisas nogawa ukup amamipi naꞌipam naꞌi, “Hapif ipeꞌini ina banagen. Deiꞌ maina ipaꞌ pandaꞌipama pagaꞌi, ‘Afaꞌ bret akafa?’ ");
INSERT INTO aoj_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Ipaꞌ ukup pandandaꞌ ma bret atamba wanifita biafita esis hiasi 5,000-pelais saꞌata ma duꞌwanita tagaꞌihi, aꞌa owaꞌ? Pakolasata paloꞌwata folalef maꞌulif? Ipaꞌ ataꞌ owaꞌ pegawefa? ");
INSERT INTO aoj_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Eaꞌ ipaꞌ owaꞌ ukup pepoma bret atamba 7-pelaita afamba hiasi 4,000-pelais sagaꞌatama duꞌwanita tagaꞌihi pakolasata paloꞌwata folalef maꞌulif? ");
INSERT INTO aoj_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Deiꞌ maina ipaꞌ owaꞌ pegegawaea? Aeꞌ ina aꞌipipa bret endilisitai, owaꞌ. Aeꞌ aꞌi ipaꞌ solawaipama yis amamba amom Farisii maloma amom Sadyusii.” ");
INSERT INTO aoj_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Eaꞌ deiꞌ amom mogawa, anen ina naꞌipama yis isimba endilisisi, owaꞌ. Anen naꞌi amom solawaima basef amom Farisi maloma amom Sadyusi magawalipasafi. ");
INSERT INTO aoj_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Jisas nafeꞌ naloma alipumi ananimi mataga felefeleꞌma anambel wambel Sisaria Filipai. Eaꞌ nahaliꞌam naꞌi, “Amam nematawa esis sogawa aeꞌ ataga epen egefaꞌ alop epesi sogawa agol maigil sandaꞌmeagol? ");
INSERT INTO aoj_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Eaꞌ maꞌipana maꞌi, “Anis saꞌi inaꞌ Jon aman nagapisiꞌas embeli. Anis saꞌi inaꞌ Elaija. Apaꞌ anis saꞌi inaꞌ Jeremaia aꞌa anina profet.” ");
INSERT INTO aoj_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Eaꞌ nahaliꞌam naꞌi, “Deiꞌ ipaꞌ paꞌi aeꞌ ami?” ");
INSERT INTO aoj_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Saimon Pita nagwamana basef naꞌi, “Inaꞌ Krais, aman anamba God nandandepena nasapaꞌena nagafiꞌii. Inaꞌ Nogamana God ambal namili lagapaunai.” ");
INSERT INTO aoj_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Eaꞌ Jisas nagwamana basef Pita naꞌi, “Saimon, inaꞌ nogama Jonai, inaꞌ sonahena. Ina anona aman itapanai nihimbaꞌmena basef ifimba naꞌif, owaꞌatin. Ahame atona nagape heveni nihimbaꞌmenaef naꞌif. ");
INSERT INTO aoj_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Deiꞌ aꞌipina endilisi, agol ineꞌigili Pita, agol agalemba gaꞌi otam. Atiasi aeꞌ endaꞌ maꞌol banaganima sios aeꞌasi sotoma otam amamba ilif. Ama banagami amamba gaꞌi ina banagema migikilaꞌ esis, owaꞌatin. ");
INSERT INTO aoj_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Aeꞌ atiasi eseꞌena ki utaini inaꞌ ma anamba God nagalaꞌambemagoma heven. Hiahaom inaꞌ negewaꞌam naꞌa itapi, amamba anaf God nowaꞌam gani heven wapani. Apaꞌ hiahaom mamahoma inaꞌ negatagwahom naꞌa itapi, amamba anaf God notagwahom gani heven wapani.” ");
INSERT INTO aoj_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Eaꞌ Jisas naꞌipam basef banagafi naꞌi amom owaꞌi miꞌipa anis epesa anen Krais, God nandandepana nasapaꞌana nagafiꞌiia, owaꞌi. Mombahoꞌana. ");
INSERT INTO aoj_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Nogota atamba Jisas naliꞌ nandasafel nihimbaꞌma alipumi ananimi ma atiasi nofeꞌ nogawis Jerusalem ama agufumi Judai mogasoꞌana akafimi. Amom dembami magawalipasa muꞌuli Godi moloma amom pris dembami atiasi mosoꞌana akafimi luꞌwami anona mohana nogagaꞌ. Ama nimaguf bif hiꞌilifa anef fegafeꞌma wanifi aꞌ notanima nosafel wapani. ");
INSERT INTO aoj_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Eaꞌ Pita nofaꞌ Jisas nendelefata nasa gemba eaꞌ naꞌipana naꞌi, “Dembinai, owaꞌatin, aeꞌ andaiwaꞌ endilisi ma hiahaom amamba mogatagama inaꞌ, owaꞌi, hapaimi!” ");
INSERT INTO aoj_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Eaꞌ Jisas nandambema naꞌipa Pita naꞌi, “Inaꞌ siꞌi Satan. Deiꞌ main, inaꞌ owaꞌ okom mopoma okom Godia, owaꞌ. Okom mandapoma nomonas epes sagape itapi atis. Owaꞌi nehefa ufiaꞌw aeꞌakwia. Delefata nefeꞌ alafuga aeꞌagai.” ");
INSERT INTO aoj_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Deiꞌ Jisas naꞌipa alipumi ananimi naꞌi, “Aeꞌ efaꞌ akafimi andaꞌ maol Godi sehe egaꞌ lawag usiꞌigai tiꞌwanaegai. Iꞌi anin epen niꞌi nila aeꞌ, anin nendaꞌas naꞌamba atin siꞌi aeꞌ ma nigaili. Eaꞌ nitalogofa okom ananimi ma maol main anin naꞌi nendaꞌani. ");
INSERT INTO aoj_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Epen ami okom mopoma ambal ananili atol, niꞌi nihapilal tatalaꞌil, anaf ambal ananili higililal. Apaꞌ ami okom mopoma aeꞌ ma nesambala ambal ananili itap apaꞌe, anaf ambal ananili God aꞌ nofaꞌal lotanimai nepe andeandeꞌ lifilafi. ");
INSERT INTO aoj_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Iꞌi epen ami nendaꞌ maol naninani ma negefaꞌ gwaꞌaimi uga hiahaom hiami itapami atom higiligalami, anin wapani awen higililan nelomam. Deiꞌ bola hiahaom amamba anaf motopalopan miꞌimama? Owaꞌatin endilisi. Inimba atiasi nefaꞌ hiahaom maima negatal ambal ananili ma netanima negewambilali wapani? Owaꞌatin. ");
INSERT INTO aoj_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Aeꞌ ataga epen egefaꞌ alop epesi, anaf aeꞌ ifiꞌi elomai hiahaom fasimi banagami mogogalaꞌi ahamai moloma amom ensel aeꞌami. Ama nemaf afamba, aeꞌ egwamasa hiahaom hiami esis amam nematawa hiasi mondahama waf esis sandaꞌafi hiꞌilaf. ");
INSERT INTO aoj_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Aeꞌ aꞌipipa endilisi! Anis epes deiꞌ sagalutu naꞌai, esis ina atiasi sogaꞌ ulal, ataꞌ owaꞌatin, asiti aeꞌ ataga epen egefaꞌ alop epesi egape siꞌi dembiwai king igafiꞌi.” ");
INSERT INTO aoj_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Aꞌi owaꞌ main, nimaguf wanif fafeꞌma hiꞌalef, Jisas naoꞌwa Pita naloma Jemsi owamana Jon naoꞌwam mondowasaꞌ anota halafuta lautai. Naoꞌwa amom atom tol mape. ");
INSERT INTO aoj_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Owaꞌ mati alop ananipi apandati naꞌa pogalaꞌ aꞌowaꞌ. Eaꞌ nogohnaep ananisi sogalaꞌ siꞌi owaf, eaꞌ luwaguf ananimi mataga afitim siꞌi lambeh magahihil. ");
INSERT INTO aoj_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Eaꞌ amom wanom mape owaꞌ mati amam biam fowaꞌimi Mosesi Elaija mataga malutu maꞌi maloma Jisas. ");
INSERT INTO aoj_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Amom mati isimba, Pita naꞌipa Jisas naꞌi, “Dembinai, afaꞌ wape naꞌaꞌe aꞌ fafas. Inaꞌ nigaꞌi awima, daoꞌ aeꞌ elaꞌ aolah wanoh naꞌaꞌe, anop ineꞌipi anop Mosesi anop Elaijai.” ");
INSERT INTO aoj_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Anen ataꞌ naꞌi nagail atini, anom ilagw afitimi mogogalaꞌ aꞌowaꞌi maluwi maofana amom. Eaꞌ anagol malogol gaꞌi gatagai ilagw amamba gaꞌi basef gaꞌi, “Anen nogame aeꞌani, aeꞌ okom mohafel maimailana aꞌowaꞌ eaꞌ aeꞌ okom mohafel maila waf ananifi. Ipaꞌ pendameꞌ basef ananifi.” ");
INSERT INTO aoj_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Amom alipumi ananimi mameꞌ basef ifimba, ombal maham aꞌowaꞌ eaꞌ mowafa motawa mandoꞌ amagah itap. ");
INSERT INTO aoj_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Owaꞌ Jisas nafiꞌi felefeleꞌma amom nasa lagola amom naꞌipam naꞌi, “Ipaꞌ safel. Ipaꞌ ina ombal mehepa, owaꞌi.” ");
INSERT INTO aoj_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Eaꞌ amom masaꞌma naep matologon owaꞌ, ina ataꞌ mati anin epen, owaꞌatin. Mati Jisas atona nalutu nalomam. ");
INSERT INTO aoj_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Eaꞌ amom ataꞌ makwaha halafuta milianai atin, owaꞌ Jisas naꞌipam dindinip naꞌi, “Ipaꞌ ina pewalapa hiahaom amamba deiꞌ pagatulumi, piꞌipa anin epenam, owaꞌi. A pefeꞌ dondoꞌma nemaf afamba aeꞌ ataga epen egefaꞌ alop epesi ekwaha wandofa itanima egasafel wapani, daoꞌ piꞌipas.” ");
INSERT INTO aoj_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Eaꞌ alipumi ananimi mahaliꞌana maꞌi, “Deiꞌ maina amom dembami magawalipasa muꞌuli Godi magaꞌi Elaija fowaꞌinai ataꞌ niliꞌ nogafiꞌi?” ");
INSERT INTO aoj_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Eaꞌ anen nagwa basef naꞌi, “Ahoꞌ endilisi, Elaija anen nifiꞌi ma nondondomba hiahaom hiami hiꞌigalam wapani. ");
INSERT INTO aoj_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Apaꞌ owaꞌ deiꞌ aeꞌ aꞌipipa, anona Elaija aꞌ nafiꞌi eaꞌ, apaꞌ esis amam nematawa ina sogawa anen, owaꞌ saꞌi anona daiana. Esis sandaila ukup asasimi atom sandandaꞌ waf aunai naninani ma anen. Eaꞌ atiasi sondaꞌam naꞌamba atina sogaseꞌe akafimi aeꞌ ataga epen egefaꞌ alop epesi.” ");
INSERT INTO aoj_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Jisas naꞌias naꞌamba, eaꞌ alipumi ananimi mogawa anen naꞌipama Elaija anen waminif atina Jon nagapisiꞌas embeli. ");
INSERT INTO aoj_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Amom mafeꞌ mataga ma esis amam nematawa hiasi, anona aman nafiꞌi natagama Jisas nindiwa nembawa notaoma anen ");
INSERT INTO aoj_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","naꞌipana naꞌi, “Dembinai, inaꞌ niꞌi uwahipigai ma awani aman aeꞌani. Anin ambal aunai nandaꞌan nameꞌ akafimi luꞌwami aꞌowaꞌ ma alop ananipi. Ahoꞌ, lifilafi ambal amamba nandaꞌan newala nasef nif fagandifi nafeꞌ newala nala embel dondol. ");
INSERT INTO aoj_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Aeꞌ aoꞌwan wafeꞌma alipumi ineꞌimi owaꞌ, amom ina laꞌifima mondaꞌan boꞌwen, owaꞌ.” ");
INSERT INTO aoj_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Eaꞌ Jisas nagwamasa basef naꞌamba naꞌi, “Ipaꞌ amam nematawa deiꞌ pagape itap apaꞌi owaꞌ pigahapifaia. Eaꞌ nelelemb ipeꞌimi owaꞌ bepe andeandeꞌa. Nimaguf ataꞌ epe elomepa? Nimaguf maꞌuf wapani ma egefaꞌ nimanimi ipeꞌimi? Ipaꞌ okwan nifiꞌmai aeꞌ.” ");
INSERT INTO aoj_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Jisas nagagaola ambal anamba aunai eaꞌ nakwaha aman anamba saꞌunai, eaꞌ deiꞌ atef aowas ananini hiꞌalan. ");
INSERT INTO aoj_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Ama main, alipumi Jisasi atom malomana mape, mahaliꞌana maꞌi, “Deiꞌ maina afaꞌ owaꞌ banagefama ogatofa ambal anamba aunaia?” ");
INSERT INTO aoj_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Eaꞌ naꞌipam naꞌi, “Hapif ipeꞌini ataꞌ saꞌwin, Isimba atis deiꞌ ipaꞌ ina laꞌifipa, ataꞌ owaꞌ. Ahoꞌ, aeꞌ aꞌipipa endilisi, iꞌi hapif ipeꞌini nendahama siꞌi nalelef saꞌwisaꞌwisi mastetilif lawag, daoꞌ atiasi ipaꞌ piꞌipa halafuta tati piꞌi, inaꞌ dagia nefeꞌ newala gani waꞌol, atiasi anen nondagia nogafiꞌi. Ipaꞌ pihapifi banagambel naꞌamba, deiꞌ banagepa ma pendaꞌ maol hiani hiꞌigalan. ");
INSERT INTO aoj_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Apaꞌ owaꞌ anoꞌw ufiaꞌw daiaꞌwa pegatofa ambagof amambai awamia, owaꞌatin. Pelelama gwaꞌaisi ma pendabeten, daoꞌ eaꞌ isimba atis.” ");
INSERT INTO aoj_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Nemaf afamba Jisas naoꞌwa alipumi ananimi mafiꞌi atef anamba itap luꞌupa Galili, eaꞌ naꞌipam naꞌi, “Aeꞌ ataga epen egefaꞌ alop epesi, atiasi felefeleꞌ anona aman nosoꞌasa aeꞌ efeꞌma lagof amom boumi aeꞌami. ");
INSERT INTO aoj_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Eaꞌ amam amamba mohe egaꞌ. Ama nimaguf bif hiꞌilifa eaꞌ, iꞌi owaꞌ anef fegafeꞌma wanifi, itanima esafel wapani.” Eaꞌ nelelemb amom alipumi ananimi nimanilimb aꞌowaꞌ. ");
INSERT INTO aoj_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Ama main Jisas naloma alipumi ananimi mataga anambel wambel Kaperneam. Eaꞌ amom mogofaꞌ takisa ipat luꞌunai Godi mafiꞌmai Pita mahaliꞌana maꞌi, “Dembinai Tisa ipeꞌinai anen natala takisa ipat anamba?” ");
INSERT INTO aoj_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Eaꞌ Pita naꞌi “Ahoꞌ.” Ama Pita notanima nafeꞌ nawis anota ipat nomon, eaꞌ Jisas naliꞌ nahaliꞌana naꞌi, “Inaꞌ okom mandandaꞌ maꞌimama? Amom king dembami itapami mofaꞌ otamba ma takisa uga maima ami? Amom mofaꞌasa miniꞌap esis amam nematawa amamisi atis aꞌa anis daiasa anin kantri?” ");
INSERT INTO aoj_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Eaꞌ Pita naꞌi, “Ama anis amam nematawa daias.” Eaꞌ Jisas naꞌipana naꞌi, “Naꞌamba esis miniꞌap kingi ina satala takis, owaꞌ. Sape dowaf. ");
INSERT INTO aoj_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Afaꞌ aꞌ solawaifa. Naꞌamba amom muti afaꞌ owaꞌ ondaꞌ takisa amom ukup numbutipa afaꞌ miꞌi afaꞌ aofai. Eaꞌ deiꞌ inaꞌ foꞌo la huk dumb ambamba ma nigagiai aol alamba lagaliꞌi inaꞌ newala malogol aoli niti anin moni atitin, moni inimba dondoꞌ ma takisa afaꞌ biafa. Eaꞌ inaꞌ nefaꞌ moni inimba neseꞌaman amom, ama negatala takis isimba afaꞌ biafai.” ");
INSERT INTO aoj_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Nemaf afamba amom alipumi Jisasi mafiꞌmai anen mahaliꞌana maꞌi, “Ami nikilaꞌ anis daias nataga damben aꞌowaꞌ ma anamba inaꞌ nagalaꞌambemagoma?” ");
INSERT INTO aoj_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Eaꞌ Jisas nofala anin awani nafiꞌmai anen nahaponan nalutu laꞌafena amom. ");
INSERT INTO aoj_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Eaꞌ naꞌipam, “Aeꞌ aꞌipipa endilisi. Epen ami niꞌi ahoꞌma God nope dembinai ma anin, ama nasoꞌana nembel God iꞌi awasi isimba sagaꞌi ahoꞌmana, isimba sandaꞌas naꞌambai atiasi sogawis anamba God nagalaꞌambemagomai. Iꞌi owaꞌ, owaꞌatin. ");
INSERT INTO aoj_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Epen ami negape saꞌumbilini owaꞌ negasaꞌma agol ananigili luꞌwagilia netaga siꞌi awani inimbai daoꞌ epen inimbai eaꞌ nikilaꞌ anis daiasa negape dambeni anamba aeꞌ agalaꞌambemagoma. ");
INSERT INTO aoj_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Epen ami nesoꞌ opafa negatopalopa anin awani siꞌi iniꞌi ma okom ananimi mopoma aeꞌ, anin naseꞌe opaf aeꞌ wapani natopalope. ");
INSERT INTO aoj_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Iꞌi anin epen nendaꞌ anin epen saꞌwini nagahapifa aeꞌi, nefeꞌ nendaꞌ waf awafi, epen inimba negape naꞌamba. Iꞌi anis epes sofaꞌ epen inimba sondola otam luꞌunai nila biniꞌw ananiꞌwi sofaꞌan sofeꞌ solan negewala naoh mami luꞌwamiai, anin ataꞌ nepe andeandeꞌ kwasakwasala. Apaꞌ owaꞌ owaꞌatin. Iꞌi epen inimba nendaꞌ anin saꞌwini negakwaha nagahapifa aeꞌa, epen inimba atiasi nepe awen aꞌowaꞌ nikilaꞌ negewala naoh afini. ");
INSERT INTO aoj_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Ipaꞌ epes itapipai, aeꞌ ati ipaꞌ uwahipipa ma hiahaom amamba mogogwambipai mondaꞌepa pendaꞌ waf awafii. Endilisi hiahaom amamba atiasi mogatagai, apaꞌ epes ami sondaꞌam mogatagai, aeꞌ ati esis uwahipis endilisi. Deiꞌ main, anaf semeꞌ akafimi luꞌwami.” ");
INSERT INTO aoj_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Eaꞌ Jisas naꞌipam anif basef wapani waminif atin naꞌi, “Iꞌi lagof aꞌa boꞌwagah ipeꞌisi sondaꞌepa pewa ma waf awafi, petopaꞌas pikwahis sofoꞌo. Andeandeꞌ kwasakwasala ma lagufi boꞌwagah atona atin sope, ma pefaꞌ ambal namili pegape andeandeꞌ. Apaꞌ sofaꞌepa sokwahepa nif luꞌwami fandom atapim magapaini, anamba ina atiasi pepe andeandeꞌ, owaꞌ. Pepe awepa. ");
INSERT INTO aoj_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Apaꞌ iꞌi naep ipeꞌipi pendaꞌepa pewa ma waf awafi, daoꞌ pigip pikwahip. Atom atin mope ma pefaꞌ ambal namili pegape andeandeꞌ. Naꞌamba naep bip pepomepa sakwahepa pefeꞌ pewala nif luꞌwafi fandif atapif fagapani wambel awambili hel. Naꞌamba ina atiasi pepe andeandeꞌ, owaꞌ. Pepe awepa. ");
INSERT INTO aoj_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Ipaꞌ solawaipa! Naꞌamba piꞌi anin epen atitin saꞌwini piꞌi inimba anin falafini, owaꞌi. Deiꞌ main, amom ensel magape heveni mumafi epes isimbai saꞌwisi andeandeꞌ. Ensel amamba dondol magape felefeleꞌma ahame God nagape heveni. ");
INSERT INTO aoj_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Aeꞌ ataga epen egefaꞌ alop epesi, aeꞌ afiꞌi ma elaoma epes higilagalasi iwambilas sokwaha waf awafi sogotanimai. ");
INSERT INTO aoj_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Ipaꞌ ukup paꞌimama? Iꞌi anona aman nugumafi anop sipsip 100-pelaip ama anop atotop higililap, aman anamba ataꞌ nokwaha sipsip apamba 99-pelaip pulutu anagon dohogw, anen ataꞌ nefeꞌ nolaꞌ nolaoma anona higiligalanai. ");
INSERT INTO aoj_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Aeꞌ aꞌipipa endilisi, iꞌi nogofaꞌi sipsip apamba eaꞌ, atiasi sonohana aꞌowaꞌ ma sipsip apamba. Dagala ananimi aꞌ mikilaꞌ nandagala ma sipsip amamba magalutuwi. ");
INSERT INTO aoj_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Eaꞌ naꞌamba atin ahamepa ipeꞌinai nagape gani heveni nandaiwaꞌ ma anin epen saꞌwini higiligalan, owaꞌ. ");
INSERT INTO aoj_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Iꞌi sahin owan sondaꞌ waf awafima inaꞌ, inaꞌ nefeꞌ nitilin ipaꞌ atipa pepe eaꞌ nihimbaꞌman waf awafi ananifi. Iꞌi anin negameꞌ basef ineꞌifima daoꞌ, andeandeꞌ, siꞌi inaꞌ niwambilai anin aꞌ nigitanimai wapani. ");
INSERT INTO aoj_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Apaꞌ iꞌi anin owaꞌ nemeꞌ basef ineꞌifia, inaꞌ nihaliꞌ anin epen o epes bias wapani eaꞌ pefeꞌ atin. Ama ipaꞌ bipa o wanipa pefeꞌma pegameꞌ basef epen inimbai ma pegawalegef. ");
INSERT INTO aoj_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Ama iꞌi anin nindaiwaꞌma negameꞌ basef ipeꞌifi ma daoꞌ inaꞌ aꞌ niꞌipa esis Kristen hiasi sondakolas atogini aꞌ niꞌipasan. Ama anin niꞌi nindaiwaꞌma negameꞌ basefa esis Kristen hiasi wapani daoꞌ, inaꞌ nekwahin nepe siꞌi isimba owaꞌ sogogawa Godia, siꞌi amam amamba awami mogofaꞌ takisi. ");
INSERT INTO aoj_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Aeꞌ aꞌipipa endilisi! Hiahaom ipaꞌ pegewaꞌam naꞌa itapi, amamba anaf God nowaꞌam gani heven wapani. Apaꞌ hiahaom mamahoma ipaꞌ pegatagwahom naꞌa itapi, amamba anaf God notagwahom gani heven wapani. ");
INSERT INTO aoj_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Eaꞌ aeꞌ aꞌias endilisi ma ipaꞌ wapani. Iꞌi epes bias sagape itapi ukup pefeꞌ atogona anis maefaha esis bias siꞌi sondabeten sohaliꞌ Goda nogasoꞌasa hiahawes isimba, eaꞌ andeandeꞌ ahame aeꞌanai nagapani heveni atiasi aꞌ nosoꞌasam esis. ");
INSERT INTO aoj_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Ahoꞌ, iꞌi epes bias aꞌa wanis ukup pepoma agol aeꞌagili ma sunduwaꞌanima anamba atogon, aeꞌ ape alomas.” ");
INSERT INTO aoj_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Nemaf afamba Pita nafiꞌi nahaliꞌ Jisas naꞌi, “Dembinai, nimaguf maꞌumaꞌuf sahin owan aeꞌasi sondaꞌme waf awafi aeꞌ, ma okom moseꞌe waf awafi asasifi egakwahef? Nimaguf 7-pelaif aꞌa maꞌuf?” ");
INSERT INTO aoj_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Eaꞌ Jisas naꞌipana naꞌamba naꞌi, “Aeꞌ ina aꞌipina nimaguf ifimba atif 7-pelaif, owaꞌatin. Aeꞌ aꞌi inaꞌ nekwaha waf awafi asasifi nimaguf hiafi 490-pelaif. ");
INSERT INTO aoj_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“Deiꞌ main, esis sogawis nomona maol Godi nope Dembinai nugumafias siꞌi anona dembinai king naꞌi nogawa wialef fagapoma amom mandaꞌ maol ananinii maꞌulif. ");
INSERT INTO aoj_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Eaꞌ anen nasefelas nandaꞌas nogawas andeandeꞌma nondaꞌ amom mogogwamana wiaf, eaꞌ sofaꞌ anona aman safeꞌma anen. Eaꞌ aman anamba nogowaola wiafa moni inimba 10 milian kinai. ");
INSERT INTO aoj_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Apaꞌ anen moni akana ma nogagwan dondoꞌma nigambi wiaf afamba anen nandaꞌafi. Eaꞌ dembinai king naꞌipas naꞌi esis aꞌ sotala aman anamba noloma wauluꞌmana awasi ananisi ma sope agof akas sondaꞌ maol sogape lafela anis epes atapis eaꞌ sotala hiahaom asasimi wapani, sofaꞌ moni ma sogagwa wiaf afamba. ");
INSERT INTO aoj_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","“Eaꞌ aman anamba nowafa notawa itapa naep king anamba dembinai naꞌipana naꞌamba naꞌi, ‘Inaꞌ niti aeꞌ uwahipiwi nepe nehafa aeꞌ. Anaf aeꞌ egwamena wiaf afamba hiꞌilafa inaꞌ.’ ");
INSERT INTO aoj_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Eaꞌ dembinai anamba nati owahipina aꞌ okom masoꞌana wiaf ananifi nakwahona nafeꞌ wahifina. ");
INSERT INTO aoj_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Owaꞌ aman anamba nawisi andoꞌ nati anona amom atom mandaꞌ maol atini, anen nowaola wiafa moni kwaiaꞌwin siꞌi 10 kina. Eaꞌ nombaloꞌ aman anamba nowaꞌana sisihina biniꞌw ananiꞌwi naꞌipana naꞌi, ‘Inaꞌ negwame wiaf ineꞌifi hiꞌindalaf!’ ");
INSERT INTO aoj_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","“Eaꞌ aman anamba nowafa notawa itap eaꞌ nahaliꞌana dindinip naꞌi, ‘Inaꞌ niti aeꞌ owahipiwi eaꞌ nepe nehafa aeꞌ! Bola egwamena wiaf ineꞌifi hiꞌilaf.’ ");
INSERT INTO aoj_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","“Owaꞌ anen nandaiwaꞌ. Eaꞌ nofaꞌana nafeꞌ nandaꞌana nandaꞌ kalabus, ama nope nogagwa wiaf afamba. ");
INSERT INTO aoj_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Amom mandaoꞌoma mandaꞌ maoli mati isimba, aꞌ nelelemb nimanilimb endilisi mafeꞌ mawalapa hiahawes isimba ma dembinai amamunai. ");
INSERT INTO aoj_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","“Eaꞌ dembinai nofalai aman anamba nandaꞌ maoli eaꞌ naꞌipana naꞌi, ‘Inaꞌ aman nandaꞌ maol awasinii. Dokoꞌ inaꞌ naloma aeꞌ nalef, eaꞌ akwaha wiaf afamba luꞌwafi ineꞌifi hiꞌalaf. ");
INSERT INTO aoj_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Aeꞌ ati inaꞌ owahipina, apaꞌ deiꞌ maina inaꞌ owaꞌ nigaꞌi owahipigama alipini ineꞌini pandaꞌ maol atinia?’ ");
INSERT INTO aoj_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Eaꞌ dembinai okom numbutina nasoꞌamana amam amamba mugumafi kalabusi ma mogasoꞌana akafimi luꞌwami nope nope nogwa wiaf ananifi hiꞌigalaf. ");
INSERT INTO aoj_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","“Iꞌi ukup ipaꞌ hipaii owaꞌ pekwaha waf awafi endilisima sahin owan ipeꞌisi ukup peseꞌepafa, bola naꞌamba atina Ahame aeꞌanai nagape heveni wapani nondaꞌmepas ipaꞌ naꞌamba atin siꞌi dembinai nandaꞌama aman anamba.” ");
INSERT INTO aoj_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Jisas naꞌi basef ifimba hiafi ma hiꞌalef, aꞌ nakwaha itap apamba Galili nafeꞌ anep itap Judia gani waꞌol walemb Jordan fisanamb. ");
INSERT INTO aoj_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Eaꞌ amam nematawa hiasi sagiꞌmana safeꞌ eaꞌ nandaꞌ epes hiasi aowas nandaꞌasi amboꞌwes. ");
INSERT INTO aoj_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Eaꞌ anom dembami Farisi mafiꞌmai anen mahaliꞌana anif basef magwambana maꞌi, “Muꞌuli apeꞌini andeandeꞌma anona aman nondaiwaꞌma wauluꞌmana ananiꞌwi nogaliꞌamonaꞌwa okom ananimi atom aꞌa owaꞌ?” ");
INSERT INTO aoj_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Eaꞌ anen nagwamama basef amom naꞌi, “Ipaꞌ patalifa basef ifimba Godi pagawef eaꞌ. Basef ifimba fagaꞌias naꞌamba faꞌi, ‘Fowaꞌ gani dambadamba God nandaꞌ hiahaom hiami nandaꞌ epes sataga suwafisi numaꞌisi.’ ");
INSERT INTO aoj_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","God naꞌias naꞌamba naꞌi, ‘Naꞌamba esis bias ina ataꞌ sope siꞌi sagape daindai, owaꞌ. Aman aꞌ nokwaha mamasana ananisi eaꞌ nefeꞌ noloma wauluꞌmana ananiꞌwi, asotaga sope alop atotop.’ ");
INSERT INTO aoj_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Eaꞌ esis bias sondasoꞌama asotaga siꞌi alop atifip. Esis ina ataꞌ siꞌi sagape biasa sagape daindai, owaꞌ. Eaꞌ hiahawes mais God nagapeteꞌas sisihisi, isimba anin epen ina nehapeꞌas, owaꞌi.” ");
INSERT INTO aoj_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Eaꞌ Farisi amamba maꞌipana wapani maꞌi, “Moses naꞌipapa muꞌuli inimba nagaꞌi, aman nondaꞌ anif basef fil okwatip nosoꞌakwef eaꞌ niliꞌamonaꞌw kofeꞌ.” ");
INSERT INTO aoj_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Eaꞌ Jisas naꞌipa amom naꞌi, “Ipaꞌ pandaꞌ duꞌwaniga. Deiꞌ Moses naꞌi ahoꞌma ufiaꞌw akwamba deiꞌ pailaꞌw paliꞌamona wauhiamepa patopaꞌ waf dasoꞌamaifi. Apaꞌ fowaꞌ gani dambadamba ina anif basef ifimbai ma pagatopaꞌ waf dasoꞌamaifi, owaꞌatin. ");
INSERT INTO aoj_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Aeꞌ aꞌipipa aꞌi, Iꞌi anoꞌw nemataꞌw anona amani owaꞌ kondaꞌ waf awafi soꞌa waulafia, ma anen nogakwahoꞌw dowafa nogasoꞌ anoꞌw daiaꞌw wapani, anen nandaꞌ waf awafi soꞌa waola nemataꞌw akwamba naliꞌ nagasoꞌakwi.” ");
INSERT INTO aoj_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Eaꞌ amom alipumi ananimi aꞌ maꞌipana maꞌi, “Iꞌi waf afambai endilisifi ma owaꞌ nope atapina noloma akoꞌwa, daoꞌ dasoꞌama hapaini. Eaꞌ andeandeꞌma nemataꞌw akana nogape dowaf.” ");
INSERT INTO aoj_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Eaꞌ anen naꞌipam naꞌamba naꞌi, “Ina atiasi amam nematawa hiasi laꞌifis sofaꞌ basef ifimba ma sogahapilif, owaꞌatin. Epes atis isimba God nagasoꞌas pepel eaꞌi, esis atis sofaꞌef. ");
INSERT INTO aoj_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","“Deiꞌ main, amam naꞌambaimi mape amom owaꞌ laꞌifima mogasoꞌ nematawaia. Anom mamamam amamuwai olam eaꞌ atapim mape naꞌamba. Eaꞌ anom, amam matopaꞌmam alop amamipi. Eaꞌ amom ina laꞌifima mogasoꞌ nematawa, owaꞌ. Eaꞌ anom, ukup papoma mugawis nomona maol Godi nope Dembinai nugumafiam. Eaꞌ mandaiwaꞌma mogasoꞌ nematawa. Aman ami laꞌifina nigaila basef ifimbai, anen aꞌ nindailif andeandeꞌ.” ");
INSERT INTO aoj_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Nemaf afamba esis saoꞌwamanai anis awasi saꞌwisi sofaꞌas safiꞌmai anen, saꞌi anen nowamona lagof ananigufi ma awasi isimba nondabetenas. Owaꞌ alipumi ananimi mandaiwaꞌma awasi isimba eaꞌ masopama esis sofaꞌas sagafiꞌmai anen. ");
INSERT INTO aoj_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Eaꞌ Jisas naꞌi, “Ipaꞌ kwahowa awasi isimba sifiꞌmai aeꞌ. Ipaꞌ pindaiwaꞌmas owaꞌ. Esis amam nematawa sogawis nomona maol Godi nope Dembinai nugumafiasi, esis sameꞌ basef ananifi sagailif siꞌi awasi isimba.” ");
INSERT INTO aoj_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Eaꞌ nawamona lagof ananigufi balagah asasigahi, nakwaha esis aꞌ nafeꞌ. ");
INSERT INTO aoj_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Eaꞌ anona aman nagwama Jisas naꞌi, “Dembinai Tisa, aeꞌ atiasi endaꞌ waf maif buꞌwafi ma egefaꞌ ambal namili egape andeandeꞌ lifilafi?” ");
INSERT INTO aoj_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Eaꞌ Jisas naꞌipana naꞌi, “Deiꞌ maina inaꞌ nagahaliꞌ aeꞌ ma hiahawes isimbai? Anona aman atotona nagape ilifi anen buꞌunai. Iꞌi inaꞌ niꞌi nefaꞌ ambal namiliai, daoꞌ andeandeꞌma nigaila basefa muꞌuli God nagasoꞌ Mosasani hiani.” ");
INSERT INTO aoj_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Eaꞌ aman anamba nahaliꞌ Jisas naꞌi, “Muꞌuli mamahina?” Eaꞌ Jisas nagwamana naꞌipana naꞌi, “Inaꞌ owaꞌi nendaꞌ waf awafi soꞌa waulafia, neha anis epes sogaꞌ nendaꞌ wal, owaꞌi, inaꞌ owaꞌi nembasoꞌma anis epes daiasa, ");
INSERT INTO aoj_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","inaꞌ nemeꞌ basef mamasinai nihapilif nilif eaꞌ nindimafias andeandeꞌ. Inaꞌ aꞌ okom mimila anis sagape felefeleꞌma ineꞌi, siꞌi inaꞌ okom magamagaila inaꞌ atinama nigimafi inaꞌ.” ");
INSERT INTO aoj_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Eaꞌ aman anamba ataꞌ saꞌunai awaminai naꞌipa Jisas naꞌi, “Muꞌuli inimba hiani aeꞌ ahapilan ailan afiꞌi eaꞌ. Deiꞌ waf mamahefa ataꞌ fape?” ");
INSERT INTO aoj_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Eaꞌ Jisas naꞌipana naꞌi, “Iꞌi inaꞌ niꞌi negataga boꞌwena dondoꞌma negefaꞌ ambal namili ma, daoꞌ inaꞌ foꞌo neseꞌasa hiahaom ineꞌimi ma anis daias sotalinama nefaꞌ moni inimba nendaꞌan nesoꞌ isimba kwahusi. Nendaꞌas naꞌamba ma anaf negefaꞌ hiahawes fasisi gani heven. Eaꞌ inaꞌ nifiꞌi nihapifi nila aeꞌ.” ");
INSERT INTO aoj_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Eaꞌ aman anamba saꞌunai nameꞌ basef ifimba owaꞌ, nomonas ananisi aꞌ iwanis eaꞌ nandambema megahaihailana nafeꞌ. Deiꞌ main, anen hiahaom hiamunai. ");
INSERT INTO aoj_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Eaꞌ Jisas naꞌipa alipumi ananimi naꞌamba naꞌi, “Aeꞌ aꞌipipa endilisi, epes isimba ugai moni hianaisi, sandaꞌam dandaꞌ ahifim aꞌowaꞌ ma sofeꞌ sogawis nomona maol Godi nope Dembinai nugumafias. Atona atin sefeꞌ suwis. ");
INSERT INTO aoj_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Aeꞌ aꞌi iꞌipipa wapani, Anin mafin luꞌunai kamel nogawis bolotaf nil sogosambala luwagufeli, anamba ila ma nogawis. Apaꞌ amam nematawa hiahaom hiamisi sofeꞌ sogawis nomona maol Godi, sondaꞌam dandaꞌ ahifim aꞌowaꞌ ma sofeꞌ sogawis. Maol inimba ahifim aꞌowaꞌ nikilaꞌ maol kamel nogawis bolotaf nili.” ");
INSERT INTO aoj_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Eaꞌ alipumi ananimi mameꞌ basef ifimba owaꞌ, amom agogolalasom kwapeteꞌ endilisi. Eaꞌ maꞌi, “Iꞌi naꞌambaiai, anaf God nuwambilai epes mamahisa sotanimai sope andeandeꞌ lifilafi? Owaꞌatin.” ");
INSERT INTO aoj_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Eaꞌ Jisas nosaniga natiti amom naꞌipam naꞌi, “Hiahaom epes owaꞌ laꞌifisa sondaꞌamia, amamba God atona banagonai ma nondaꞌam. Anen banagonai ma nondaꞌ hiahaom hiami hiꞌigalam.” ");
INSERT INTO aoj_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Anen naꞌias naꞌamba, eaꞌ Pita nagwamana basef naꞌipana naꞌi, “Nemeꞌ, afaꞌ eaꞌ wakwaha hiahaom afaꞌimi hiami, eaꞌ deiꞌ wafiꞌi wahapifa basef ineꞌifi wailina. Afaꞌ atiasi ofaꞌ hiahawes mais?” ");
INSERT INTO aoj_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Eaꞌ Jisas naꞌipam naꞌi, “Aeꞌ aꞌipipa endilisi ipaꞌ. Owagama nemaf afamba fegataga ma hiahaom hiami mogataga dambaim wapani, afamba aeꞌ ataga epen egefaꞌ alop epesi, efaꞌ banagami mogogalaꞌi etoma sia king aeꞌani. Nemaf afamba ipaꞌ amam aeꞌipai eaꞌ pagail aeꞌi atiasi ipaꞌ 12-pelaipa petoma siaifah fasimi amom dembami kingi 12-pelaim, eaꞌ pewawaloga misiꞌah 12-pelaih amam nematawa apeꞌisi Israel. ");
INSERT INTO aoj_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Eaꞌ epes ami ukup pegapoma aeꞌ ma sokwaha ifagw gwoloma sahin owan ahasas mamasas a batawisas soloma aofah mais asasisii, anaf asofaꞌ hiahaom timbi tambel hiami aꞌowaꞌ, mikilaꞌ mogwa fowaꞌimi atapim. Eaꞌ anaf asofaꞌ ambal namili sogape andeandeꞌ lifilafi. ");
INSERT INTO aoj_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Apaꞌ epes hiasi deiꞌ sataga sagaliꞌi agof fagatomasi, anaf agof akas asotaga sigiꞌ. Apaꞌ epes isimba sataga sagagiꞌi anaf aꞌ agof fotomas sotaga siliꞌ.” ");
INSERT INTO aoj_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Ahoꞌ, epes sogawis nomona maol Godi nope Dembinai nugumafias siꞌi anona aman nagagoma itap luꞌwapi ananipi. Aꞌi owaꞌ ma lala kuhimbita atota owaꞌa, anen nafeꞌma nugufaꞌi anom amam mondaꞌ maol aof afamba ananifi nagawa saꞌutip mandelef wainilifip. ");
INSERT INTO aoj_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Anen nafeꞌ naꞌi naloma anom mandaꞌ maoli eaꞌ nalomam nembel atembela otamba atiasi mogofaꞌambai, mofaꞌ wan kina atona atina nemaf afamba. Eaꞌ nasapaꞌam mafeꞌ mandaꞌ maol aof ananifi. ");
INSERT INTO aoj_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","“Eaꞌ anen nape ma awin nandagiai nape siꞌi 9 klok, anen a nafeꞌ owaꞌ nati anom amam ataꞌ tol malutu dowaf anamba mondowaꞌanima magapoma. ");
INSERT INTO aoj_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Eaꞌ naꞌipam naꞌi, ‘Ipaꞌ wapani foꞌo pendaꞌ maol aof aeꞌafi ma egaseꞌepa otamba bendendaepa bendahama waf buꞌwafi.’ ");
INSERT INTO aoj_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Eaꞌ amom aꞌ mafeꞌ. “Ama aꞌi owaꞌ awin nandasapaꞌ 12 klok anen nafeꞌ wapani eaꞌ nandaꞌas naꞌamba atin siꞌi dokoꞌ nandaꞌas. “Ama awin nendembaꞌa 3 klok, nafeꞌ nandaꞌas wapani siꞌi dokoꞌ nandaꞌas. ");
INSERT INTO aoj_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","“Eaꞌ ma wambomota 5 klok main, aꞌ nafeꞌ nati anom ataꞌ malutu dowaf. Eaꞌ naꞌipam naꞌi, ‘Deiꞌ maina ipaꞌ ataꞌ tol pagalutu dowaf naꞌaꞌe nemaf afaꞌe laof?’ ");
INSERT INTO aoj_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","“Eaꞌ maꞌipana maꞌi, ‘Ina anona aman nasoꞌafa maol afaꞌ, owaꞌatin.’ Anen naꞌipam naꞌi, ‘Ipaꞌ wapani foꞌo pendaꞌ maol aof afamba.’ ");
INSERT INTO aoj_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Eaꞌ wambomota felefeleꞌma owamb aman anamba nugumafi aofi nafiꞌi naꞌipa aman nugumafi amom mandaꞌ maoli naꞌi, ‘Inaꞌ fala mandaꞌ maoli amamba hiami eaꞌ neseꞌama moni amom. Inaꞌ niliꞌ nesoꞌ amom amamba magiꞌ magatagai, neseꞌaman nefeꞌ nefeꞌ netagama amam amamba maliꞌ mataga mandaꞌ maoli.’ ");
INSERT INTO aoj_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","“Eaꞌ amam amamba mataga mandaꞌ maol wambomota 5 kloki, mataga mofaꞌ wan kina atona atin. ");
INSERT INTO aoj_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Eaꞌ amam amamba maliꞌ mosafel kuhimbita mandaꞌ maoli, mafiꞌi ukup pandandaꞌ paꞌi atiasi amom aꞌ mofaꞌ moni luꞌwani mikilaꞌ anom. Owaꞌ, owaꞌatin. Amom wapani mofaꞌ wan kina naꞌamba atin. ");
INSERT INTO aoj_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Eaꞌ mandaꞌ megahaha aman anamba nugumafi aof afambai. ");
INSERT INTO aoj_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","“Eaꞌ maꞌias naꞌamba maꞌi, ‘Amom amamba magiꞌ magatagai, amom mafiꞌi mandaꞌ maol nogota bandata siꞌi awa atitin, owaꞌ inaꞌ aꞌ nasoꞌama moni inimba naꞌamba atin siꞌi afaꞌ ogofaꞌani. Apaꞌ afaꞌ waliꞌ wandaꞌ maol luꞌunai endilisi ma nemaf laufi, eaꞌ owaf nahanahafa.’ ");
INSERT INTO aoj_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“Amom maꞌias naꞌamba ma eaꞌ, anen nagwamana basef anona aman amamunai naꞌipana naꞌamba naꞌi, ‘Alipunai, aeꞌ ina andaꞌena awena, owaꞌ. Afaꞌ biafa waliꞌ waꞌias eaꞌ nomonas atifisa pegefaꞌ wan kina atin. ");
INSERT INTO aoj_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Inaꞌ faꞌa moni ineꞌini eaꞌ foꞌo. Otamba aeꞌ agaseꞌenamba ineꞌi, eaꞌ ikwaf afamba atef aeꞌ aꞌ eseꞌanamba aman anamba nagiꞌ nafiꞌi nandaꞌ maoli, pefaꞌamba dondoꞌ atin. ");
INSERT INTO aoj_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Aeꞌ andaꞌ maol siꞌi okom aeꞌami magaꞌiana moni aeꞌani. Naꞌamba andeandeꞌ, waf usiꞌifi. Aeꞌ andaꞌ waf buꞌwafi ma igimafi amom magiꞌ magafiꞌi wambomotai. Naꞌamba deiꞌ inaꞌ kowalena ma otamba amamimbai?’ ");
INSERT INTO aoj_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","“Anaf naꞌamba atin, epes isimba deiꞌ sataga sagagiꞌi agof akasi aꞌ agof fotomas sotaga siliꞌ, apaꞌ epes isimba sataga sagaliꞌi agof fagatomasi, anaf agof akas asotaga sigiꞌ.” ");
INSERT INTO aoj_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Eaꞌ Jisas naꞌi nondowasaꞌ Jerusalem. Anen naoꞌwa alipumi ananimi atom mafeꞌ. Amom ataꞌ mafeꞌ atin ufiaꞌw owaꞌ, naꞌipam naꞌi, ");
INSERT INTO aoj_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Pemeꞌ. Deiꞌ afaꞌ eaꞌ ondowasaꞌ Jerusalem. Aeꞌ ataga epen egefaꞌ alop epesi, atiasi anona aman nondaꞌe efeꞌma amom pris dembami moloma amom dembami magawalipasa muꞌuli Godi, eaꞌ mondaꞌ kotimi aꞌ miꞌi basef mondameꞌmaefa mohe egagaꞌ. ");
INSERT INTO aoj_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Eaꞌ mondaꞌe efeꞌma esis sogolalama Godi ma sondaꞌ salamala aeꞌ sondaꞌe findiwae ma basef awafi sehe egagaꞌ lawag usiꞌigai tiꞌwanaegai. Ama nimaguf bif hiꞌilif anef fegafeꞌma wanifi, God aꞌ nosaꞌme itanima esafel wapani.” ");
INSERT INTO aoj_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Nemaf afamba Sebedi wauluꞌmana maꞌma Jamesi Joni kwaoꞌwai nogaopaꞌw akwaꞌumi biam safiꞌmai Jisas. Eaꞌ kwindiwa nembawa kotawa itapa kugaꞌipana anif basef. ");
INSERT INTO aoj_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Eaꞌ Jisas nahaliꞌakw naꞌi, “Inaꞌ naꞌi aeꞌ endaꞌmena main?” Eaꞌ kwaꞌipana kwaꞌi, “Inaꞌ niꞌi anaf owagama negataga dembinai, anamba inaꞌ nagalaꞌambemagoma, nemaf afamba aeꞌ aꞌi nogaope amamba aeꞌami biam mope dembem felefeleꞌma inaꞌ, anona nil waꞌol egawama, aꞌ anona nil waꞌol daꞌasaigilima.” ");
INSERT INTO aoj_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Akoꞌw kwaꞌias naꞌambama, eaꞌ Jisas nagwamaꞌw naꞌipa amom naꞌi, “Ipaꞌ ina pagawa andeandeꞌma hiahawes ipaꞌ pagahaliꞌimasi, owaꞌ! Ipaꞌ banagepama pagaꞌ embela kap apamba deiꞌ aeꞌ egaꞌ embelapi, aꞌa owaꞌ?” Eaꞌ magwamana maꞌipana maꞌi, “Afaꞌ ila laꞌififai.” ");
INSERT INTO aoj_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Eaꞌ Jisas naꞌipam naꞌi, “Endilisi, ipaꞌ bipa atiasi peaꞌ embela kap apamba aeꞌ egaꞌ embelapi. Apaꞌ pegape lagol kwahisigili o gagaili aeꞌagufi, isimba ina maol aeꞌani, owaꞌ. Ahame atona niꞌi esis isimba nandandepas eaꞌi daoꞌ esis atis sope lagof kwahisigili gagaili aeꞌagufi.” ");
INSERT INTO aoj_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Eaꞌ alipumi duꞌwanim ilifunamaim mameꞌ amom biam maꞌias naꞌamba, mandaꞌ megahaha amom sahomana owamana. ");
INSERT INTO aoj_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Owaꞌ Jisas nofalai amom mafiꞌmai anen, aꞌ naꞌipam naꞌi, “Ipaꞌ pagawa, anom king magape dembami ma isimba sogolalama Godi, amom mape ilifa esis aꞌowaꞌ mandaꞌmas dondog mandaꞌas kwapeteꞌas. Eaꞌ amom dembami mape banagem aꞌowaꞌ ma mandaꞌ esis amam nematawa sagaila malogof amamugufi. ");
INSERT INTO aoj_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Apaꞌ waf afambai ina aꞌ fepoma ipaꞌ, hapaifi. Aman ami aꞌ nogape dembinai ma ipeꞌi, anen ataꞌ niliꞌ nope siꞌi nandaꞌ maola ipaꞌ hipaii. ");
INSERT INTO aoj_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Eaꞌ aman ami niꞌi nogataga dembinai ma ipeꞌi, anen ataꞌ niliꞌ nope siꞌi agol akani nandaꞌ maol nagape lafela hiasii.” ");
INSERT INTO aoj_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Aeꞌ ataga epen egefaꞌ alop epesi, aeꞌ wapani naꞌamba atin. Ina afiꞌi ma esis sondaꞌme maola sogatopalope, owaꞌ. Aeꞌ afiꞌi endaꞌ maol egatapalopa ipaꞌ hipai ma waf awafi fagawasiꞌipai. Afiꞌi ma sehe egaꞌ etala ipaꞌ peloma epes hiasi igatagwahipama waf awafi ipeꞌifi.” ");
INSERT INTO aoj_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Eaꞌ Jisas naloma alipumi ananimi makwaha wambel ambalemba Jeriko maꞌi mefeꞌ atin owaꞌ, amam nematawa hiasi sagiꞌma anen safeꞌ. ");
INSERT INTO aoj_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Eaꞌ amam biam naep pagasoꞌami tol mape felefeleꞌma ufiaꞌw. Eaꞌ mameꞌ basef saꞌi Jisas nafiꞌi eaꞌ mofalana mehip maꞌi, “Dembinai, inaꞌ akunamana Deviti, niti afaꞌ uwahipifa!” ");
INSERT INTO aoj_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Eaꞌ esis amam nematawa hiasi sinifalom saꞌi mosopama malogof. Owaꞌ owaꞌatin, amom mofalana mehip aꞌowaꞌ maꞌi, “Dembinai inaꞌ akunamana Deviti, niti afaꞌ uwahipifa!” ");
INSERT INTO aoj_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Eaꞌ Jisas nalutu nofala amom biam naꞌi, “Ipaꞌ bipa paꞌi aeꞌ endaꞌmepa main?” ");
INSERT INTO aoj_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Eaꞌ amom maꞌipana maꞌi, “Dembinai, afaꞌ waꞌi inaꞌ newalamafa naep afaꞌipi ma ugati andeandeꞌ.” ");
INSERT INTO aoj_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Eaꞌ Jisas nati amom owahipim nasa lagof ananigufi naep amamipi, eaꞌ deiꞌ atef amom biam mati andeandeꞌ wapani, aꞌ magiꞌma Jisas mafeꞌ. ");
INSERT INTO aoj_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Eaꞌ amom mafeꞌ mataga felefeleꞌma Jerusalem, mataga Betfagai felefeleꞌma halafuta Oliv. Eaꞌ Jisas nasapaꞌ alipumi ananimi biam naꞌipam naꞌi. ");
INSERT INTO aoj_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","“Ipaꞌ bipa pefeꞌ piwis wambel bambalimba bagape gani waꞌili felefeleꞌma naꞌai. Eaꞌ apiti anona mafin donki saꞌunai esis sandolona nail naloma nogani ananinai malutu. Ipaꞌ petagwahom eaꞌ pefaꞌam pifiꞌmai aeꞌ. ");
INSERT INTO aoj_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Iꞌi anin epen niꞌi nigahaliꞌipa ma anif basefa, piꞌipan piꞌi, ‘Dembinai afaꞌinai naꞌipafa naꞌi nondaꞌ maolanam, ama bola nosapaꞌam mutanimipai kwafalis.’” ");
INSERT INTO aoj_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Hiahawes isimba amom mogofaꞌai donki aꞌ sataga dindiꞌi dondoꞌ sagiꞌma siꞌi basef ifimba fowaꞌ anona aman profet Aisaia nagaꞌiefi, anen nagaꞌi naꞌamba naꞌi, ");
INSERT INTO aoj_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Ipaꞌ piꞌipa epes sagape Saioni piꞌi, ‘Ipaꞌ piti, deiꞌ king dembinai ipeꞌinai anaf nifiꞌmai ipaꞌ. Anen nandaꞌ waf saꞌumbilifii, eaꞌ notoma donki nogani nofaꞌana nifiꞌi.’” ");
INSERT INTO aoj_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Eaꞌ alipumi amamba biam ananimi mafeꞌ eaꞌ mandaꞌas siꞌi dokoꞌ nagaꞌipamas. ");
INSERT INTO aoj_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Amom mofaꞌ donki anamba nalomai nogani mafiꞌmai Jisas, mawamona sagegw amamugwi gwatoma ilifa donki amamba biam. Eaꞌ Jisas nandagia natoma donki amamba. ");
INSERT INTO aoj_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Eaꞌ amam nematawa hiasi sandombamana sagegw ufiaꞌw, sasaꞌma agol ananigili luꞌwagol. Anis satopaꞌi apulita lawah hogotawa felefeleꞌi sasoꞌwiam ufiaꞌw sofaloꞌmaꞌw. ");
INSERT INTO aoj_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Eaꞌ esis amam nematawa hiasi saliꞌ sagiꞌ safela aoꞌaligil naꞌamba saꞌi, “Hosana. Apaꞌ mandanifal endilisi ma inaꞌ. Inaꞌ akunamana Deviti! Apaꞌ maꞌi God nofaloꞌma inaꞌ nagafiꞌi agol ananigilii neseꞌena banagami ma nendaꞌ maol ananini. Apaꞌ mandanifal endilisi ma dembinai God nagape ilifi.” ");
INSERT INTO aoj_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Nemaf afamba Jisas nafeꞌ nawis wambel ambalemba Jerusalem, eaꞌ amam nematawa hiasi sosafel gogolalasis kwapeteꞌ eaꞌ soga saꞌi mehip sandahaliꞌma saꞌi, “Aman anamba anen mamahonama?” ");
INSERT INTO aoj_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Eaꞌ esis amam nematawa safeꞌ sagalomanai sandagalamana saꞌi, “Aman anamba anen Dembinai profet Jisas, aman nagape anambel wambel Nasareti bagape anep itap Galili.” ");
INSERT INTO aoj_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Eaꞌ Jisas nawis ipat luꞌunai Godi naliꞌamona esis hiasi sandaꞌ bisnisi saloma isimba sagatalom ipat anamba nomoni. Anom mati otamba anisi eaꞌ mindisilaꞌmamba. Eaꞌ Jisas nambema tebolifah amamisi nakoloꞌwas. Anis sandaꞌ bisnisa sogatala amiguf maꞌunamb. Eaꞌ nambema siaifah asasisi nakoloꞌwas wapani. ");
INSERT INTO aoj_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Eaꞌ naꞌipas naꞌi, “Basef fagape Baibeli God naꞌi, ‘Ipat aeꞌanai nondapoma epes hiasi sifiꞌi sopaona sondabeten sogahaliꞌ aeꞌ. Apaꞌ owaꞌ, pandaꞌana nataga siꞌi sandambahoꞌ sandaꞌ wala.” ");
INSERT INTO aoj_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Jisas ataꞌ napani ipat anamba luꞌunai nomon owaꞌ sofaꞌmani epes isimba naep pagasoꞌasi a boꞌwagah maim mogokwasi safiꞌmanai, eaꞌ nandaꞌas boꞌwes. ");
INSERT INTO aoj_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Owaꞌ amom pris dembami maloma anom dembami magawalipasa muꞌuli Godi mati anen nandaꞌ maol banagani fasini, eaꞌ mameꞌ esis awasi sondagalama anen gani ipat luꞌunai nomon saꞌi, “Apaꞌ maꞌi God aꞌ nondatopalopa Dembinai apeꞌinai akunamana Deviti!” Eaꞌ amom deiꞌ ukup awep kwapeteꞌa anen. ");
INSERT INTO aoj_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Eaꞌ mahaliꞌana maꞌi, “Inaꞌ aꞌ negawa basef kofagefa?” Jisas naꞌipam naꞌi, “Ahoꞌ, aeꞌ egawef.” Eaꞌ naꞌipam naꞌi, “Ipaꞌ pitalif eaꞌ basef ifimba fagail Baibeli pagawef. Basef ifimba fowaꞌifi fagaꞌi naꞌamba faꞌi, God, ‘Inaꞌ anaf niwalipa awasi saꞌwisi soloma isimba ataꞌ agunifisi sagaꞌ nomambeh atembihi, eaꞌ sosaꞌma agol ineꞌigili.’” ");
INSERT INTO aoj_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Eaꞌ anen nakwaha taun inimba, nawisi andoꞌ nafeꞌ nape anembel wambel Betani owamb ambamba. ");
INSERT INTO aoj_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Ama wafilu kuhimbita atota Jisas nosafel notanima nafeꞌ taun inimba, eaꞌ nolomahana. ");
INSERT INTO aoj_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Eaꞌ nati anoga lawag fik gotawa ufiaꞌw eaꞌ nafeꞌ natologa. Apaꞌ ina nati anip saꞌutip pailaga, owaꞌatin. Apul atom. Eaꞌ naꞌipaga naꞌi, “Inaꞌ ina ataꞌ anip saꞌutip pilina wapani. Eaꞌ owaꞌatin endilisi.” Eaꞌ kwafalis atis lawag agamba bowaga eaꞌ aliga hiꞌalaga. ");
INSERT INTO aoj_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Eaꞌ amom alipumi ananimi mati lawag agamba aliga, gogolalasom kwapeteꞌ. Eaꞌ maꞌi, “Deiꞌ maina lawag agamba fik bowaga eaꞌ aliga kwafalis atis?” ");
INSERT INTO aoj_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Eaꞌ Jisas nagwamama basef amom naꞌipam naꞌi, “Aeꞌ aꞌipipa endilisi. Iꞌi ipaꞌ pihapifi endilisi, ma ipaꞌ ina bimbiafip pipaipa, daoꞌ atiasi eaꞌ pendaꞌas siꞌi aeꞌ andaꞌasa lawag agamba fik. Eaꞌ ipaꞌ ina pendaꞌ isimba atis, owaꞌatin. Iꞌi ipaꞌ piꞌipa halafuta tatumba piꞌi, ‘Inaꞌ dagia nefeꞌ newala naoh,’ atiasi atemeꞌef tilif siꞌi ipaꞌ pagaꞌias. ");
INSERT INTO aoj_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Iꞌi ipaꞌ pihapilif endilisi ma pendabetena, hiahawes isimba ipaꞌ pandabetena paꞌi pegefaꞌasi atiasi ipaꞌ aꞌ pefaꞌas.” ");
INSERT INTO aoj_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Eaꞌ Jisas notanima nafeꞌ nawis ipat luꞌunai Godi nape nawalipasa basef esis amam nematawa siꞌi dondol nagawalipas. Eaꞌ amom pris dembami maloma agufumi Judai mafiꞌmai anen mahaliꞌana maꞌi, “Ami naꞌipina deiꞌ nape dembinai nandaꞌ maol inimba?” ");
INSERT INTO aoj_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Eaꞌ Jisas nagwamam basef naꞌi, “Aeꞌ wapani aꞌi ihaliꞌipa ma anif basefa ipaꞌ ataꞌ piliꞌ piꞌipif aeꞌ ma bola igaꞌipipa ami naꞌipi ape dembinai andaꞌ maol inimba. ");
INSERT INTO aoj_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Aman anamba Jon nagapisiꞌas embeli, ami naꞌipana ma nandaꞌ maol inimba? God nagape heveni naꞌipana nandaꞌan aꞌa anin epen itapani naꞌipana?” Eaꞌ mameꞌ basef ifimba mandaꞌipama maꞌi, “Afaꞌ iꞌi ugaꞌi, ‘God nagape heveni nagaꞌipana,’ atiasi anen aꞌ niꞌi, ‘Deiꞌ maina ipaꞌ owaꞌ pagahapifanaea?’ ");
INSERT INTO aoj_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Apaꞌ afaꞌ iꞌi ugaꞌi, ‘Anin epen itapani naꞌipana,’ naꞌamba esis amam nematawa aꞌ sohafa. Afaꞌ ombal mahafama esis. Deiꞌ main, esis hiasi saꞌi Jon anona profet dembinai.” ");
INSERT INTO aoj_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Eaꞌ magwamana basef Jisas maꞌi, “Afaꞌ owaꞌ ogawama.” Jisas naꞌipam naꞌi, “Eaꞌ naꞌamba atin aeꞌ ina iꞌipipa ma ami naseꞌe banagami naꞌipi andaꞌ maol inimba aeꞌani, owaꞌ.” ");
INSERT INTO aoj_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","“Apaꞌ ipaꞌ ukup pape paꞌimama? Anona aman nogaopana biam. Anen nafeꞌma anona naꞌipana naꞌi, ‘Nogame aeꞌinai, deiꞌ inaꞌ foꞌo nendaꞌ maola aof aeꞌafi egawa mandelef wainilifa.’ ");
INSERT INTO aoj_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Owaꞌ nogamana nagwamana naꞌipana naꞌi, ‘Aeꞌ andaiwaꞌ.’ Aꞌi owaꞌ main owaꞌ, nambema nembel aꞌ nafeꞌ. ");
INSERT INTO aoj_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Eaꞌ nafeꞌ naꞌipa anona wapani naꞌipana naꞌamba atin siꞌi dokoꞌ naliꞌ nagaꞌi. Owaꞌ nagwamana basef naꞌi, ‘Ahoꞌ, ahame.’ Apaꞌ anen ina nagiꞌma basef ananifi nafeꞌ, owaꞌatin. ");
INSERT INTO aoj_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","“Eaꞌ deiꞌ nogaopana amamba biam ananimi mamahonama nagiꞌma basef ahamanai?” “Amom maꞌi, “Nagaliꞌi.” Eaꞌ Jisas naꞌipam naꞌi, “Aeꞌ aꞌipipa endilisi, amam amamba mogofaꞌ takisi mandaꞌ waf awafii maloma nematawa wandaꞌ waf awafi wandaꞌ soꞌa wauli esis eaꞌ sefeꞌ suwis nomona maol Godi nope Dembinai nugumafias siliꞌa ipaꞌ. ");
INSERT INTO aoj_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Ipaꞌ pagawa aman anamba Jon nagapisiꞌas embeli. Anen naliꞌ nafiꞌmai ipaꞌ eaꞌ nihimbaꞌmepa wafa ufiaꞌw usiꞌiꞌwi, apaꞌ ipaꞌ owaꞌ pihapifanaea. Apaꞌ epes isimba awasisi anom mogofaꞌasa takisi maloma anowa nematawa wandaꞌ waf awafi soꞌa wauli esis eaꞌ sahapifana. Ipaꞌ pati esis sagahapifana naꞌambai, apaꞌ ipaꞌ ina pambema opalef pakwaha waf awafi pahapifana, owaꞌatin. ");
INSERT INTO aoj_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“Ipaꞌ pemeꞌ anif basef waminif atini. Anona aman dembinai nandaꞌ anof aof nagawa waina nahefagomaf. Aof afamba nomon anen nandaꞌ anona tang notawa ma sogafaꞌasa saꞌutip ipimba wainip, eaꞌ nalaꞌ anota ipat lautai totawa ma sope sugumafiagon. Eaꞌ nakwahomam aof afamba anom amam maꞌi mondaꞌ maolafa bisnisi. Eaꞌ nafeꞌ napani anambel wambel lauguni. ");
INSERT INTO aoj_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Ama nogota saꞌutip pagailatai, nasapaꞌ anom mandaꞌ maola anini mafeꞌ ma amom mandaꞌ maol aof ananifii. Anen naꞌi amom mosoꞌana anip saꞌutip gwaꞌaipi aof afamba. ");
INSERT INTO aoj_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Eaꞌ amom amamba mandaꞌ maol aofi mofaꞌ amam amamba kofagonama aofi naspaꞌam magafiꞌii mombaloꞌam maham, anona mahana afuna endilisi, anona makwaha otamba mahana, apaꞌ anona mahana dowaf aꞌ nafaꞌ nafeꞌ. ");
INSERT INTO aoj_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Eaꞌ anen kofagonama aofi nasapaꞌ anom hiami daiam mafeꞌ wapani. Apaꞌ amom amamba mandaꞌ maol mandaꞌas naꞌamba atina amom siꞌi maliꞌ magafiꞌii. ");
INSERT INTO aoj_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Aꞌi owaꞌ nagiꞌ nasapaꞌ nogamana ananinai nafeꞌma amom mandaꞌ maol aofi. Eaꞌ anen naꞌias naꞌi, ‘Atiasi ila, amom aꞌ memeꞌ malogol nogame aeꞌanai.’ ");
INSERT INTO aoj_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","“Owaꞌ owaꞌatin, amom mati nogamana ananinai nafiꞌi, mandaꞌipama atin maꞌi, ‘Aman nanumba owagama nogofaꞌ hiahaom hiami ahamanai. Awi, aꞌ ohana ma afuna ma afaꞌ atofa ogofaꞌ aof afaꞌe.’ ");
INSERT INTO aoj_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Eaꞌ mombaloꞌana mofaꞌana mawisi aof andoꞌefa mahana afuna. ");
INSERT INTO aoj_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","“Nemaf afamba aman kofagonama aof afambai nogafiꞌi nondaꞌ maina amom?” ");
INSERT INTO aoj_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Eaꞌ amom magwamana maꞌipana maꞌi, “Namanani anen nondaꞌmam waf awafi endilisi ma amam amamba awasimi noham mogaꞌ. Eaꞌ nosoꞌasa aof afamba fefeꞌma anis epes daias sumafiaf, ama nogota gwaꞌaisi sogail owaꞌ esis a sosoꞌana anis gwaꞌaisi anen.” ");
INSERT INTO aoj_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Eaꞌ Jisas naꞌipas naꞌi, “Ipaꞌ patalifa basef Godi pagawef eaꞌ. Basef Baibeli fagaꞌi naꞌamba faꞌi, ‘Otam amamba magalaꞌ ifagwi mogelefatami deiꞌ mataga mape otam banagami mape magaliꞌi mogombaloꞌ ipati. Dembinai God nandaꞌ amamba mataga, apaꞌ matolom fasifasim aꞌowaꞌ.’ ");
INSERT INTO aoj_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“Eaꞌ aeꞌ deiꞌ aꞌipipa. God atiasi aꞌ nelefata basefa waf buꞌwafi anamba anen nagalaꞌambemagoma ma ipaꞌ, a nosoꞌasam anis epes atiasi sombaleꞌef sondaꞌ waf buꞌwafi. ");
INSERT INTO aoj_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Eaꞌ epes mamahisa kwahogalas sogowa otam anambai, atiasi esis pepeꞌetas. Apaꞌ iꞌi otam anamba nowa nogosaliꞌas, aꞌ loloweas siꞌi sopof atof.” ");
INSERT INTO aoj_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Eaꞌ amom pris dembami maloma dembami amom Judai Farisi mameꞌ basef ifimba waminif atini Jisas nagaꞌiefi maꞌi owaꞌ, anen nondolaꞌwaifa amom naꞌi basef ifimba. ");
INSERT INTO aoj_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Eaꞌ maꞌi mombaloꞌana owaꞌ ombal bahama esis amam nematawa. Esis hiasi sogawana saꞌi Jisas anona profet. ");
INSERT INTO aoj_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Eaꞌ Jisas nandaꞌ anif basef waminif atin wapani naꞌi, ");
INSERT INTO aoj_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Epes sogawis nomona maol Godi nope Dembinai nugumafias siꞌi anona king dembinai itapnai. Nogamana ananinai naꞌi nogaoꞌwa akoꞌw, eaꞌ king anamba nandaꞌ anis gwaꞌaisi luꞌwasi. ");
INSERT INTO aoj_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Ama nemaf afamba sogaꞌasafi anen nasapaꞌ amam amamba mandaꞌ maola anini mafeꞌ mofalai epes isimba fowaꞌ nogofalasi ma sogafiꞌmai gwaꞌaisi isimba. Owaꞌ sandaiwaꞌma sogafiꞌi. ");
INSERT INTO aoj_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","“Eaꞌ anen nasapaꞌ anom wapani mandaꞌ maola anini motambel mafeꞌ, eaꞌ naꞌipam naꞌi, ‘Ipaꞌ foꞌmago epes isimba aeꞌ eaꞌ andandepas sagapani eaꞌ piꞌipas naꞌamba piꞌi, “Pemeꞌ, aeꞌ andandomba gwaꞌaimi aeꞌami eaꞌ. Mafis bulmakau suwafumi a mafis amamba luꞌwami aeꞌami, apaꞌ maham. Eaꞌ hiahaom hiami mandandombol maꞌoh eaꞌ. Ipaꞌ pifiꞌmai gwaꞌaisi isimba endaꞌasa nogame nogasoꞌ akoꞌwi.”’ ");
INSERT INTO aoj_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","“Owaꞌ amom ukup iwanipa momeꞌefa mogafeꞌ eaꞌ mandambema mandafeꞌ daindai ma maol amamini. Anona nafeꞌ aof, anona nafeꞌma bisnis ananisi. ");
INSERT INTO aoj_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Apaꞌ amom magapani mombaloꞌ amamba mandaꞌ maola kingi mandaꞌam kwapeteꞌam maham afum. ");
INSERT INTO aoj_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Eaꞌ king anamba nembel wandafuna nasapaꞌ soldia ananimi mafeꞌ maha amom mandaꞌ maola anini afum hiꞌalam. Eaꞌ makata maofa wambel amamimbili wapani. ");
INSERT INTO aoj_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Eaꞌ king naꞌipa amom mandaꞌ maoli naꞌi, ‘Gwaꞌaisi endaꞌasa nogame nosoꞌ akoꞌwa sogaꞌasi eaꞌ sandandombol saꞌoh, apaꞌ epes isimba aeꞌ igifalasi, ina sandaꞌ waf andeandeꞌma sogafiꞌi, owaꞌ. ");
INSERT INTO aoj_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Naꞌamba deiꞌ ipaꞌ pefeꞌ ufiawa awamba hiawai dawalegefa pigati isimba epes hiasi piꞌipas pefalas sifiꞌmai gwaꞌaisi isimba luꞌwasi dasoꞌamaisi.’ ");
INSERT INTO aoj_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Anen naꞌias naꞌamba ma main, amom mandaꞌ maoli mafeꞌagon gani gani ufiawa dawalegef matamai epes isimba magatilisi, epes buꞌwasi saloma awasisi. Eaꞌ safiꞌi sape ipat atamba sondasoꞌama ma aꞌ siꞌita kwaef endilisi. ");
INSERT INTO aoj_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Esis sape eaꞌ dembinai king nawis nomona nigatilis. Eaꞌ nati anin epen atitin, ina nala klos sagalasa nemaf afamba dasoꞌamaifii, owaꞌ. ");
INSERT INTO aoj_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Eaꞌ king naꞌipana naꞌi, ‘Alipunai, deiꞌ maina inaꞌ owaꞌ nila klos isimba sandasoꞌamaisi nifiꞌi niwisi naꞌaea?’ Owaꞌ, anen ina naꞌi anif basef, owaꞌatin. ");
INSERT INTO aoj_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","“Eaꞌ king naꞌipa amom mandaꞌ maoli naꞌi, ‘Ipaꞌ piwasiꞌ lagof boꞌwagaha epen inimba pikwahin nefeꞌ niwis nepe akot andoꞌ. Akot atamba atiasi anin nelef nendaꞌ nalelef tilili talalaꞌ kwapeteꞌ nepe.’” ");
INSERT INTO aoj_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Eaꞌ Jisas naꞌipas naꞌi, “Ahoꞌ, God nogofala epes hiasi naꞌamba atin siꞌi king anamba nandaꞌas. Anen nofala hiasi, apaꞌ owaꞌ nandandepa atona atin sufiꞌi suwis sope sogalomana.” ");
INSERT INTO aoj_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Eaꞌ amom dembami Farisi mafeꞌ mandaꞌ basef maꞌif mandameꞌmaefa mogowaꞌ Jisas. Amom maꞌi memeꞌ anif basef ananifi owaꞌ andeandeꞌia ma mondaꞌmana basef mogowaꞌana siꞌi sogapaloꞌ agof anembeh. ");
INSERT INTO aoj_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Eaꞌ masapaꞌ alipumi magaila amomi maloma amam amamba anep miniꞌap Heroti amom mafeꞌma Jisas maꞌi, “Dembinai Tisa, afaꞌ ogawena, inaꞌ aman nagaꞌi endilisii. Ina ombel magahinai, owaꞌ. Owaꞌ nigaꞌipasa anif basef isimba anis agof luꞌwagufisia a anif basef daifa isimba agof akasi falafisia, owaꞌatin. Inaꞌ nagaꞌipas basef atifif endilisifi atif Godi amam nematawa hiasi dondoꞌ atin hiꞌagalasi. ");
INSERT INTO aoj_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Eaꞌ daoꞌ inaꞌ niꞌipafa. Deiꞌ inaꞌ okom mandandaꞌ maꞌimama? Muꞌuli apeꞌini naꞌi andeandeꞌma apaꞌ mogasoꞌana takis Sisar gavman dembinai esis Romi aꞌa owaꞌ?” ");
INSERT INTO aoj_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Owaꞌ Jisas nogawa eaꞌ ma waf awafi amamifi eaꞌ naꞌi, “Ipaꞌ amam pagaꞌi malogof biagufi, deiꞌ maina ipaꞌ pagagwamba aeꞌ? ");
INSERT INTO aoj_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Ipaꞌ himbaꞌme anin moni takisini ma ataꞌ itilin.” Eaꞌ mofaꞌmanai anin moni ma natilin ");
INSERT INTO aoj_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","nahaliꞌam naꞌi, “Ambal laloma agol isimba sagaili amisi?” ");
INSERT INTO aoj_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Eaꞌ maꞌi, “Isimba Sisari gavman dembinai.” Eaꞌ nagwamam naꞌipam naꞌi, “Daoꞌ hiahawes dembinai Sisari, isimba peseꞌanas Sisar. Apaꞌ hiahawes Godi, peseꞌanas God.” ");
INSERT INTO aoj_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Amom mameꞌanama basef ifimba eaꞌ gogolalasom kwapeteꞌam makwahana aꞌ mafeꞌ. ");
INSERT INTO aoj_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Nemaf afamba atef anom amam anep miniꞌap Sadyusi, mafiꞌmai Jisas. Amom miniꞌap apamba magahapifa sagagaꞌi ina atiasi sotanima sosafel wapani, owaꞌatin. Eaꞌ amom mafeꞌ mahaliꞌ Jisas ");
INSERT INTO aoj_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","maꞌi, “Dembinai Tisa, Moses naꞌi, ‘Iꞌi anona aman nogaꞌ ma anen awasi akana, eaꞌ owamana nosoꞌ wauluꞌmana ananiꞌwi nola anis awasi ma sogahaꞌofana.’ ");
INSERT INTO aoj_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Eaꞌ fowaꞌ anom amam apeꞌimi ambep atetep mape laꞌafena apaꞌ, amom 7-pelaim. Nagaliꞌi sahomam nasoꞌakw awani akaꞌw nagaꞌ, nakwahoꞌw kwape. Eaꞌ owamana nasoꞌakw nagaꞌ nakwahoꞌw kwapani awani akaꞌw. ");
INSERT INTO aoj_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","“Eaꞌ owamana nandatuꞌunai wapani nandaꞌas naꞌamba atin, eaꞌ anona nandatuꞌumi nasoꞌakw mandaꞌas naꞌamba atin mafeꞌ mafeꞌma matagama owagufunai akutainai. ");
INSERT INTO aoj_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Amom amamba ambipim eaꞌ mandagaꞌ atin hiꞌandalam. Ama main, nemataꞌw wauluꞌmam kwagiꞌmam kwagiꞌ kwagaꞌ. ");
INSERT INTO aoj_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Anaf esis sagagaꞌi sogosafel wapani, nemataꞌw akwamba kwagasoꞌ amom 7-pelaimi anaf mamahonama nosoꞌakw? Amom 7-pelaim aꞌ masoꞌakw atin hiꞌalam.” ");
INSERT INTO aoj_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Eaꞌ Jisas nagwamam basef amom naꞌi, “Ipaꞌ owaꞌ pegawa basef Baibel nagaꞌiefia, eaꞌ owaꞌ pagawa banagami Godia. Eaꞌ ipaꞌ deiꞌ ina paꞌi basef andeandeꞌ, owaꞌatin. ");
INSERT INTO aoj_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Nemaf afamba sagagaꞌi sokwaha wandelef sotanima sogosafel wapani, amam nematawa ina ataꞌ sondasoꞌama wapani, aꞌ owaꞌatin. Sope dowaf siꞌi ensel magape heveni. ");
INSERT INTO aoj_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Apaꞌ basef ifimba esis amam nematawa sagagaꞌi sogosafel wapani, ipaꞌ patalifa basef ifimba God naꞌif fagape Baibeli eaꞌ. Anen nagaꞌipipa naꞌamba naꞌi, ");
INSERT INTO aoj_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Aeꞌ God Abrahami, Aisaki a Jekopi.’ Basef ifimba faꞌi God ina Dembinai ma epes isimba sagagaꞌii, owaꞌatin. Anen God epes isimba ambal lapais sagape namisii.” ");
INSERT INTO aoj_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Esis amam nematawa sameꞌ naꞌamba sosafel gogolalasisa basef ananifi. ");
INSERT INTO aoj_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Jisas aꞌ nasopama malogofa amam amamba dembami Sadyusi ma basef ifimba. Naꞌamba anom amam dembami Farisi mameꞌ basef ifimba a mandakolasi mafiꞌi felefeleꞌma anen. ");
INSERT INTO aoj_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Eaꞌ anona nagaloma amomi nogogawa muꞌuli Godi naꞌi nogwamba Jisasa nigaꞌi anif basef owaꞌ andeandeꞌa ma nondaꞌmana basef sogowaꞌana siꞌi sogapaloꞌ agof anembeh. Eaꞌ nahaliꞌana naꞌi, ");
INSERT INTO aoj_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Dembinai Tisa, muꞌuli Godi mamahina luꞌwin nikilaꞌ muꞌuli daian hiani nape nagaliꞌi?” ");
INSERT INTO aoj_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Eaꞌ Jisas naꞌipana naꞌi, “Nomonas ipeꞌisi sehafel Dembinai God ipeꞌinai sisilana naꞌamba. Ukup ipeꞌipi pipilana hiꞌindalep, peseꞌana ambagufi nelelemb ipeꞌisi pendasoꞌanas hiꞌindalasa Dembinai God atona. ");
INSERT INTO aoj_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","39","Muꞌuli inimba luꞌwani, nagaliꞌ endilisii. Eaꞌ muꞌuli nagagiꞌi inimba, ‘Ipaꞌ ukup pipila anis epes sagape felefeleꞌma ipeꞌi, siꞌi ukup pagapagaila ipaꞌ atipa.’ ");
INSERT INTO aoj_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Basef kofagefa ma muꞌuli hiani Godi faloma basef amom profet mandaꞌafi hiafi hiꞌalef fape nomona muꞌuli inimba biafin.” ");
INSERT INTO aoj_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Amom Farisi ataꞌ munduwaꞌanima malutu atin, Jisas nahaliꞌam ");
INSERT INTO aoj_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","naꞌi, “Ipaꞌ ukup pandandaꞌ paꞌimama ma Krais anen God nandandepana eaꞌ ma nosapaꞌana nogafiꞌii? Anen nogama amii?” Eaꞌ maꞌipana maꞌi, “Devit nogamana.” ");
INSERT INTO aoj_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Eaꞌ nahaliꞌam naꞌi, “Deiꞌ maina Ambal buꞌunai Godi nagasaꞌma nomonas Deviti ma nagaꞌi Krais anen Dembinai? Devit fowaꞌ naꞌi, ");
INSERT INTO aoj_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Dembinai God naꞌipa Dembinai aeꞌani naꞌi, “Inaꞌ nepe lagol kwahisigili aeꞌagili atapina nefeꞌ netagama anaf aeꞌ endaꞌ bousi ineꞌisi sogafeꞌ lafela boꞌwagah ineꞌigahi.”’ ");
INSERT INTO aoj_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Devit fowaꞌ nofala Krais naꞌi Dembinai. Isimba atis deiꞌ Krais ina aman atona falafunai, owaꞌ. Anen Dembinai.” ");
INSERT INTO aoj_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Eaꞌ ina anona aman laꞌifina ma nogagwamana basef Jisas, owaꞌatin. Aꞌi owaꞌ nemaf afamba owaꞌ, amom hiami ombel mahama mogahaliꞌanama anif basef wapani. Owaꞌatin nafiꞌi nafiꞌi nataga deiꞌ wapani nafeꞌ atin. ");
INSERT INTO aoj_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Aꞌi owaꞌ main, Jisas nasoꞌasa basef esis amam nematawa saloma amom alipumi 12-pelaim ananimi. ");
INSERT INTO aoj_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","Naꞌias naꞌamba naꞌi, “Amom dembami magawalipasa muꞌuli Godi maloma dembami amamba Farisi amom mahaꞌofa Mosasa magawalipasa muꞌuli Godi banagambel. ");
INSERT INTO aoj_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Andeandeꞌma pigaila basef hiafi amom magaꞌipipafi, apaꞌ ipaꞌ ina pendaꞌ waf amom mandaꞌafi, owaꞌ hapaifi. Deiꞌ main, amom maꞌipasa basef hiafi, apaꞌ amom ina mailif, owaꞌatin. ");
INSERT INTO aoj_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Amom mogowatania basef amamifi magawalipasefa sigailif siꞌi basef wafifi analef aolef wafilifi luꞌwalifi mawamonalef fagatoma ikaguf asasifi, apaꞌ amom ina matopalopepa mofaꞌalef kwasala ma lagof amamugufi, owaꞌatin. ");
INSERT INTO aoj_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Hiahaom hiami mandaꞌami mandaꞌam dowafa epes sotolom siganifelom. Ahoꞌ, amom mala latif luꞌunai nail lagufi balagah amamisi ma mandaꞌ beten, eaꞌ mandaꞌ sosaf launai nail sagegw amamugwi daꞌmalifigwa. ");
INSERT INTO aoj_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Amom ukup paꞌi siaifah isimba sotawa sagaliꞌi atis dembami atom magapoma, ma afamba sandaꞌ gwaꞌaisi luꞌwasi aꞌa anamba ifagw luꞌwagwi esis Juda dondol sandakolasugwi. ");
INSERT INTO aoj_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Amom maꞌi hiasi sotoloma sondalalamam sogasaꞌma agof amamugufi anamba sandakolas sagapoma ma maꞌi sofalam sondaꞌi amom, ‘Dembami Tisa’. ");
INSERT INTO aoj_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Apaꞌ anis epes ina sofala ipaꞌ siꞌi ipaꞌ Dembipai, owaꞌ. Deiꞌ main, ipaꞌ tisa dembinai ipeꞌinai atotona, eaꞌ ipaꞌ hipai pepe siꞌi sahin owan wambota atota. ");
INSERT INTO aoj_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Ipaꞌ ina pefala anin epen nagape itap apaꞌe piꞌi ahamepa ipeꞌinai, owaꞌatin. Deiꞌ main, aman anamba atotona anen ahamepa ipeꞌinai, nagape heveni. ");
INSERT INTO aoj_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Eaꞌ esis ina sofalepa siꞌi dembipai tisa, owaꞌ. Deiꞌ main, Dembinai tisa ipeꞌinai Krais atona, God nandandepana nasapaꞌana nagafiꞌii. ");
INSERT INTO aoj_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Apaꞌ aman ami atiasi nogataga dembinai ipeꞌinai, deiꞌ ataꞌ niliꞌ nope nondaꞌ maol nope lafela ipaꞌ. ");
INSERT INTO aoj_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Eaꞌ naꞌamba atin, epen ami negasaꞌma agol ananigili atogili, epen inimba anaf agol akan. Apaꞌ epen ami nendaꞌ agol ananigili gogafeꞌ lafili, anaf anin nefaꞌ agol luꞌwagili.” ");
INSERT INTO aoj_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Ipaꞌ amam dembipai pagawalipasa muꞌuli Godi paloma Farisi, aeꞌ ati uwahipipa ma akafimi luꞌwami anaf mogatagamepa! Ipaꞌ amam malogof biagufipai! Ipaꞌ pewalo uta ma nogohnaep esis amam nematawai ma ina atiasi suwis nomona maol Godi nope Dembinai numafias, owaꞌatin. Deiꞌ main, ipaꞌ ina pafeꞌ pawis nomon, eaꞌ esis amam nematawa saꞌi sofeꞌ sogawisi, isimba ipaꞌ pasopamas ufiaꞌwa sofeꞌ sogawis nomon. ");
INSERT INTO aoj_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Ipaꞌ amam dembipai pagawalipasa muꞌuli Godii paloma Farisi, aeꞌ ati uwahipipa ma akafimi luꞌwami atiasi mogatagamepa! Ipaꞌ malogof biagufipai. Ipaꞌ pawis ifagw agwamba nematawa alifiwaii, pawis pandaꞌ wala hiahawes awousi. Eaꞌ pasafel palutu pandabeten launai atona ma pagambahoꞌ waf awafi ipeꞌifi. Pandaꞌam naꞌamba pandabeten launai dowadowafa esis sigaꞌi ipaꞌ buꞌupai. Anaf God nowaloga epes hiasi. Anis epes daias owaꞌ sondaꞌ waf awafi naꞌambaia anaf sofaꞌ akafimi kwasakwasala, apaꞌ ipaꞌ aꞌ pefaꞌ nimanimi luꞌwami endilisi aꞌowaꞌ. ");
INSERT INTO aoj_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Ipaꞌ amam dembipai pagawalipasa muꞌuli Godii paloma Farisi, aeꞌ ati uwahipipa ma akafimi luꞌwami anaf mogatagamepa! Ipaꞌ malogof biagufipai! Ipaꞌ pafeꞌagon hiꞌagalagini naoh a itap walemb hiagoma, pigifaꞌi anin epena negataga alipini ipeꞌini nigaila basef ipeꞌifii. Anin eaꞌ nataga alipini ipeꞌini, eaꞌ ipaꞌ pandaꞌ anin awen aꞌowaꞌ nikilaꞌ ipaꞌ naꞌamba. Ipaꞌ aupai ma pagafeꞌ wambel awambili hel nif fagandifi fagapoma. Apaꞌ ipaꞌ pandaꞌ anin nandaꞌ waf awafi aꞌowaꞌ fandahama atiasi negafeꞌ wambel ambalemba awambili. ");
INSERT INTO aoj_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Aeꞌ ati uwahipipa ma akafimi luꞌwami anaf mogatagamepa! Ipaꞌ naep pagasiꞌipai paꞌi pihimbaꞌmasa ufiaꞌw anis epes. Ipaꞌ pagawalipas naꞌamba paꞌi, ‘Iꞌi epen nigaꞌi agola ipat anamba luꞌunai Godi sandaꞌ lotuwani ma nigaꞌi endilisi gani ilifi, isimba falafisi. Apaꞌ anin nigaꞌi agola gol amamba fasimi sogofaloꞌma ipat anamba ma nigaꞌi endilisi ilifi, daoꞌ aꞌ nendaꞌas nindaila basef siꞌi nagaꞌi.’ ");
INSERT INTO aoj_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","“Ipaꞌ ukup magahipai eaꞌ naep pagasiꞌipai! Maim daꞌim mape luꞌum mikilaꞌ? Gol amamba sogofaloꞌma ipat anamba amom luꞌum aꞌa, ipat anamba buꞌunai nandaꞌ gol amamba mataga boꞌoma naep Godi? Eaꞌ deiꞌ ipat anamba atona nikilaꞌ gol. ");
INSERT INTO aoj_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Eaꞌ ipaꞌ pagawalipas wapani pagaꞌi, ‘Iꞌi epen ami nigaꞌi belita sofaꞌ mafis sagasoꞌ Godani endilisi ilifi, amamba falafumi. Apaꞌ epen ami nigaꞌi ofa mafis sagatoma belita ilifi ma nigaꞌi ilifi, daoꞌ anin aꞌ nindagiꞌmas siꞌi nagaꞌias.’ ");
INSERT INTO aoj_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","“Ipaꞌ naep pagasiꞌipai! Hiahawes mais sape luꞌwasi? Ofa mafis sape luꞌwis aꞌa belita tandaꞌ ofa inimbai nataga boꞌwena naep Godi, deiꞌ nataga luꞌwin? Eaꞌ deiꞌ belita tikilaꞌ ofa. ");
INSERT INTO aoj_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Isimba atis deiꞌ epen ami nigaꞌi agol belitai ma nigaꞌi endilisi ilifi, anin newaꞌ banaga basef ifimba ma hiahawes sagatoma belita ilifi saloma belita wapani. ");
INSERT INTO aoj_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Eaꞌ epen ami nigaꞌi agol ipat luꞌunai Godi ma nigaꞌi endilisi ilifi, anin newaꞌ banaga basef ananifi ma ipat anamba naloma anen nagape ipat anambai. ");
INSERT INTO aoj_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Eaꞌ epen ami nigaꞌi heven ilifa negewaꞌ banaga basef ananifi, anin naꞌi newaꞌ banaga basef ananifi ma sia buꞌwani Godi naloma aman anamba nagatoma sia inimbai. ");
INSERT INTO aoj_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Ipaꞌ amam dembipai pagawalipasa muꞌuli Godii paloma Farisi, aeꞌ ati uwahipipa ma akafimi luꞌwami anaf mogatagamepa! Ipaꞌ amam malogof biagufipai! Ipaꞌ pandawaloga nambawai lombo maloma akwal lalilali hiali pasoꞌana duꞌwanil ilifunamail God. Pandaꞌas naꞌamba ma akwal alamba hiali agofula alamba min, dil, kumin. Apaꞌ ipaꞌ aꞌ pindihiꞌama basef amamba hiami luꞌuma basef muꞌuli God nagaꞌiefi ma waf usiꞌifi ma pegatopalopa epes, pigati esis uwahipis, pendaꞌ hiahaom andeandeꞌ datima ma waf endilisifi. Waf afamba hiafi feloma waf pindilali pegasoꞌana hiahawes mais Godafi, afamba pekolefaf pihapilaf atin pilaf. ");
INSERT INTO aoj_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Ipaꞌ naep pagasiꞌipai, paꞌi pihimbaꞌmasa ufiaꞌw anis epes! Ipaꞌ pandaꞌ maola pigisiaꞌma afiꞌawa isimba saꞌwisi sagail malepi nembaꞌwi, apaꞌ mafin anamba luꞌunai kamel eaꞌ pewaloꞌana nalomam. ");
INSERT INTO aoj_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Ipaꞌ amam dembipai pagawalipasa muꞌuli Godii paloma Farisi, aeꞌ ati uwahipipa ma akafimi luꞌwami anaf mogatagamepa! Ipaꞌ amam malogof biagufipai! Ipaꞌ pandombasa kapi plet andoꞌesa atis hililiꞌ. Apaꞌ nomon owaꞌ. Ipaꞌ opalef siꞌipama waf walifi faloma waf afamba alop atopafi awafi. ");
INSERT INTO aoj_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Ipaꞌ Farisi, naep pagasiꞌipai! Ipaꞌ ataꞌ piliꞌ pendombasa kap nomonepa puliꞌ, ma atiasi andeꞌepa wapani pogataga boꞌop. ");
INSERT INTO aoj_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Ipaꞌ amam dembipai pagawalipasa muꞌuli Godii paloma Farisi, aeꞌ ati uwahipipa ma akafimi luꞌwami anaf mogatagamepa! Ipaꞌ epes malogof biagufipai! Ipaꞌ pandahama siꞌi ifagw saꞌugwi sagawa belatagwa sandaꞌ pen afitinai saofam. Eaꞌ andeꞌetama boꞌota ma sagatolota, apaꞌ nomonetama siꞌigina bihitagof epes sagagaꞌii maloma hiahaom awasimi alogw magami siꞌimagon. ");
INSERT INTO aoj_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Ipaꞌ pape naꞌamba atin. Epes esis sati alop ipeꞌipi andoꞌ saꞌi ipaꞌ pandaꞌ waf usiꞌifii. Apaꞌ nomon waf aunai basoꞌamunai ma malogof biagufi pandaꞌ simbisambala muꞌuli Godi amambai mape siꞌima ipaꞌ. ");
INSERT INTO aoj_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Ipaꞌ amam dembipai pagawalipasa muꞌuli Godii paloma Farisi, aeꞌ ati uwahipipa ma akafimi luꞌwami anaf mogatagamepa! Ipaꞌ amam pagaꞌi malogof biagufi! Ipaꞌ pefaloꞌma matmat amom profet magagaꞌi taloma wandelefa epes isimba sape hililiꞌ sagagaꞌi. ");
INSERT INTO aoj_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Eaꞌ ipaꞌ paꞌi, ‘Iꞌi afaꞌ fowaꞌ ope siꞌi akusafa afaꞌisiai, afaꞌ ina otopalopa esis oha amom profet afum, owaꞌ.’ ");
INSERT INTO aoj_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Ama basef ifimba atif ipaꞌ pagawalapafi kofagefa ipeꞌifi atif, paꞌi ipaꞌ epes miniꞌap apamba pagiꞌ pagatagai saha profet magagaꞌi. ");
INSERT INTO aoj_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Eaꞌ ipaꞌ aꞌ piwatani waf afamba awafi esis akusipai hiꞌindalaf! ");
INSERT INTO aoj_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","“Ipaꞌ siꞌi uguf, awasi pagataga uguf awagufi fagahasi! Kota basef luꞌwami Godi nowaꞌepa niliꞌamepa pepe wambel awambili hel. Deiꞌ pendaꞌas piꞌimama ma anaf pegefaꞌma kot atamba? Owaꞌatin endilisi. ");
INSERT INTO aoj_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Apaꞌ deiꞌ ipaꞌ pemeꞌ. Aeꞌ asapaꞌo anom profet molomago anom amam nomonas fasisimi moloma anom gawaimi ma Baibeli amom mofoꞌo motagamepa. Atiasi ipaꞌ peha anom mogaꞌ, eaꞌ pendola anom lawah hindisilaꞌmai, anom pepe pegahom nomon ifagw pandakolasugwi. Eaꞌ ipaꞌ pendaꞌam tofalam anembel wambel taun luꞌwina eaꞌ petofam mofaꞌ mefeꞌ anin taun daian eaꞌ petofam pelam atin pefeꞌ. Ipaꞌ atiasi pendaꞌ waf awafi afamba. ");
INSERT INTO aoj_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Eaꞌ deiꞌ epes isimba sagape hililiꞌi ma anis sahas sagagaꞌi, kofagema amamba hiami atiasi aꞌ mopoma ipaꞌ. Ahoꞌ, nagaliꞌi Abel anen aman nagape hililiꞌi aꞌ nafiꞌi nafiꞌi natagama aman akutainai profet Sakaraia, Berekia nogamana, anamba akusipa sahana afuna laꞌafena ipat luꞌunai Godi naloma belita saofa mafis sagasoꞌ Goda. Amamba kofagema atiasi aꞌ mila ipaꞌ atipa. ");
INSERT INTO aoj_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Aeꞌ aꞌipipa endilisi ipaꞌ. Hiahaom awami akafimi kofagema atiasi aꞌ motagama miniꞌap amam nematawa isimba deiꞌ pagapani. ");
INSERT INTO aoj_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“O ipaꞌ Jerusalem, Jerusalem, ipaꞌ pagaha amom profet afumi, pakwaha otamba pagaha amom God nasapaꞌam magafeꞌma ipeꞌi, lifilafi aeꞌ aꞌi ekolasa ipaꞌ epes hipai siꞌi awata numaꞌitai towaꞌani nogagwi takolasagw gopasol gwagail bihinagof atatigufi. Owaꞌ owaꞌatin, ipaꞌ pandaiwaꞌ. ");
INSERT INTO aoj_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Ipaꞌ pemeꞌ! Deiꞌ ipat buꞌutai a wambel ipeꞌimbili atiasi wafita totawa dowaf. ");
INSERT INTO aoj_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Aeꞌ aꞌipipa, ipaꞌ atiasi ina petolowe wapani ma anaf pigaꞌi, ‘Apaꞌ maꞌi God nofaloꞌma aman anamba nagafiꞌi agol Dembinaii ma nondaꞌana sonogahana.’” ");
INSERT INTO aoj_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Jisas nakwaha ipat luꞌunai Godi nafeꞌ atin, amom alipumi ananimi mafiꞌmai anen. Amom maꞌi mihimbaꞌmana ifagw luꞌwagwi lotugwi. ");
INSERT INTO aoj_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Owaꞌ Jisas nagwamam naꞌipam naꞌi, “Ipaꞌ pati ifagw amamba luꞌwami aꞌa? Aeꞌ aꞌipipa endilisi, anaf ina atiasi anemba otamba bendatomama atin banagemba bepe, owaꞌatin. Asugulatam sowalom hiꞌilam mofeꞌ moꞌoh atona atin.” ");
INSERT INTO aoj_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Jisas tol nape halafuta atamba Oliv, eaꞌ alipumi ananimi atom mafiꞌmai anen maꞌipana maꞌi, “Inaꞌ niꞌipafa hiahaom amamba nambaiꞌ motaga. Ametal mail liliꞌ lotaga ma afaꞌ ogogawa inaꞌ naꞌi netanima nigafiꞌi ma itap anaꞌe higiligalana?” ");
INSERT INTO aoj_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Eaꞌ Jisas nagwamama anif basef laufi naꞌi, “Ipaꞌ solawaipa. Naꞌamba anin epen aꞌ nembasoꞌmepa. ");
INSERT INTO aoj_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Deiꞌ main, amam hiami anef nemaf mifiꞌi mombasoꞌmepa miꞌi agol aeꞌagili miꞌi, ‘Aeꞌ maꞌuwi aeꞌ Krais, God nandandepe nasapaꞌe agafiꞌii.’ Eaꞌ mombasoꞌma amam nematawa hiasi someꞌ basef amamifi siꞌi endilisifi silif. ");
INSERT INTO aoj_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Anef nemaf pemeꞌ amalemba sondaꞌ wandaf a anis sondaha basefa wandaf siꞌipipaf, ipaꞌ ina ombal mehepa, owaꞌi. Hiahaom amamba atiasi mogatagai, apaꞌ nemaf akutaifi ataꞌ otaꞌ. ");
INSERT INTO aoj_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Anis epes sagape anamba itap luꞌwagoma sofela wandaf sopaꞌ soloma esis sagape anep itap daiapi. Anona dembinai king nosafel noꞌwa anis walemb hielimbi ananisi sopaꞌ soloma anona dembinai king daiana noꞌwa ananisi analemb walembi. Analemb walemb nolom mohas sope, eaꞌ analemb walemb hiagoma atona atin itap bolatin nope. ");
INSERT INTO aoj_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Hiahaom amamba hiami amom ataꞌ muliꞌ motaga siꞌi akafimi maliꞌ magatagama nemataꞌw kwaꞌi kogola awani. ");
INSERT INTO aoj_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Nemaf afamba esis sofaꞌepa ma sogaseꞌepa akafimi nimanimi, eaꞌ sehepa pegaꞌ. Epes hiasi walemb hiagoma nelelemb numbutima ipaꞌ kwapeteꞌ endilisi. Esis sati ipaꞌ pagaila basef aeꞌafii, naꞌamba deiꞌ sahepa. ");
INSERT INTO aoj_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Nemaf afamba amam nematawa hiasi sokwaha hapif asasini, eaꞌ sondawawalapa atin sosoꞌasas sefeꞌma bousi sohas, eaꞌ epes isimba ukup awepisi wapani. ");
INSERT INTO aoj_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Eaꞌ amam amamba hiami mombasoꞌam mugaꞌi amom profeti mosafel mufiꞌi mombasoꞌma amam nematawa hiasi. ");
INSERT INTO aoj_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Waf awafi atiasi aꞌ nosafel luꞌuna, naꞌamba amam nematawa hiasi asokwaha waf afamba ukup pigapigaila anis daidaias pigaꞌi uwahipis. ");
INSERT INTO aoj_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Apaꞌ epen ami nihapifi banagen nilutu negatagama nemaf akutaifii, inimba atiasi God nuwambilan nokwahoman waf awafi ananifi nitanimai nepe andeandeꞌ. ");
INSERT INTO aoj_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Eaꞌ atiasi esis siꞌipasa basef ifimba buꞌwafi Godima epes hiasi sogawis nomona maol ananini nope Dembinai nugumafias. Esis siꞌipas ganimba itap hiagoma hiꞌilagon ama amam nematawa hiasi ganimba walemb hielimbi ataꞌ siliꞌ someꞌef. Ama main owaꞌ, nemaf akutaifi aꞌ fetaga. ");
INSERT INTO aoj_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Anef nemaf ipaꞌ piti hiahaom awami mogahambombaga hiahaom buꞌwamii motaga siꞌi fowaꞌ gani profet Daniel nagaꞌi basef fagail Baibeli fagaꞌi. Hiahaom amamba motaga mope anamba boꞌwagoma ipat luꞌunai Godi nomon. (Epen ami nigatalifa basef ifimbai anin aꞌ okom mondapomef andeandeꞌ.) ");
INSERT INTO aoj_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Nemaf afamba amam nematawa sagape itap luꞌwapi Judiai sofaꞌ sefeꞌ sondowasaꞌo halafutagw. ");
INSERT INTO aoj_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","A epen ami nagape ipat andoꞌi felefeleꞌi ina ataꞌ netanima nefeꞌ niwis nefaꞌi hiahawes ananisi ipat nomon, owaꞌi. ");
INSERT INTO aoj_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Epen ami nigaili aofi, ina ataꞌ netanima nefeꞌ wambel nefaꞌ saket main ananisi, owaꞌi. ");
INSERT INTO aoj_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Nematawa opafuwai waloma awamba awasi ataꞌ sagaꞌ nomagof atogufi, aeꞌ aꞌi awo uwahipiwa endilisi ma nogota atamba ogameꞌ akafimi luꞌwami. ");
INSERT INTO aoj_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Ipaꞌ pendabetena ipaꞌ ina apefaꞌ pefeꞌ nogota atamba fufini asaf sogatagama aꞌa nemaf afamba sabat sagapoma nomaꞌwafi, owaꞌ. ");
INSERT INTO aoj_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Nogota atamba akafimi mugatagai luꞌwami endilisi. Fowaꞌ dambadamba itap pagataga nafiꞌi nafiꞌi nataga deiꞌ nimanimi awami amambai fowaꞌ ina anom naꞌambaimi mataga, owaꞌatin. Eaꞌ anaf wapani owaꞌ anom nimanimi amambai motagaia, owaꞌatin. ");
INSERT INTO aoj_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Iꞌi God owaꞌ nondaꞌ nimaguf fefeꞌ bandefa, atiasi amam nematawa hiasi hiꞌilas higiligalasi. Owaꞌ owaꞌatin. God okom mapoma epes isimba anen nogosahoꞌas eaꞌi deiꞌ nahagasa nogota atamba bandata. ");
INSERT INTO aoj_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Nemaf afamba fegataga ma iꞌi anis epes siꞌipipa sigaꞌi, ‘Ipaꞌ piti Krais God nasapaꞌana nagafiꞌii anen nape naꞌa, o nani nape gani,’ ipaꞌ ina pihapifas, owaꞌ. ");
INSERT INTO aoj_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Nemaf afamba anom amam mombasoꞌam mugaꞌi amom Kraisi a amom profeti, aꞌ motaga mondaꞌ ametal banagani naninani mondaꞌ banagami hiami siꞌi God nandaꞌami. Endilisi iꞌi amom banagema, aꞌ mombasoꞌma amam nematawa God nogosahoꞌas eaꞌi mohambombagas. Apaꞌ owaꞌ owaꞌatin. ");
INSERT INTO aoj_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Pemeꞌ, aeꞌ eaꞌ aꞌipipa hiahawes isimba deiꞌ ataꞌ owaꞌ sogatagaia. ");
INSERT INTO aoj_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Ama epes ami siꞌipipa sigaꞌi, ‘Ipaꞌ piti, anen nani nape gani epes akagoma wafigima, ipaꞌ ina pemeꞌas pefeꞌagon, owaꞌ. Apaꞌ iꞌi epes ami sigaꞌi, ‘Ipaꞌ piti nani nape ipat tati nomon’, ipaꞌ ina pihapifas, owaꞌi. ");
INSERT INTO aoj_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Ipaꞌ pegawa otaga holagala, holala natagai gani awin nagatafima eaꞌ nogalaꞌ nafeꞌ anamba hiagoma awin negewalama. Aeꞌ ataga epen egefaꞌ alop epesi, afamba aeꞌ itanima igafiꞌii, endaꞌam naꞌamba atin hiasi sotolowe. ");
INSERT INTO aoj_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Mamahagoma alop sagagaꞌi pogaꞌoma, eaꞌ naꞌamba atogon anaf komemb mefeꞌ munduwaꞌanimama. ");
INSERT INTO aoj_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Akafimi nimanimi hiami ma nogota atamba hiꞌilam eaꞌ, kwafalis atis awin alipini aꞌ netaga owamb, eaꞌ owambini ina ataꞌ negalaꞌ, aꞌowaꞌ. Eaꞌ ondowa mowai otaga ilif, hiahaom hiami banagami magape otagai eaꞌ bol atin mope. ");
INSERT INTO aoj_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","“Aeꞌ ataga epen egefaꞌ alop epesi. Nemaf afamba ametal aeꞌani netaga gani otaga ilif, amam nematawa hiasi sagape itap hiagomai aꞌ selef. Eaꞌ siti aeꞌ eloma ilagw otaga ilif ifiꞌi eloma hiahaom mogogalaꞌi fasimi Godi moloma banagami ananimi. ");
INSERT INTO aoj_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Eaꞌ alof luꞌunai nogal mehip, esapaꞌ amom ensel aeꞌami mefeꞌ itap hiagoma awin natafima negewalama waꞌowaꞌol anamba biafigin biafigin mefeꞌagon hiꞌilagon ganimba itapi otaga safeꞌ sogotambela. Atiasi ensel amamba mofeꞌ mofaꞌai esis amam nematawa God nogasahoꞌas eaꞌ ananisii sondakolas atogon. ");
INSERT INTO aoj_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Ipaꞌ nomonas sondandaꞌma anif basef waminif atina ilaof. Ipaꞌ piti ilaof nogonafa ma basowa, pegawa nogota atamba nelemb eaꞌ felefeleꞌma sogaof. ");
INSERT INTO aoj_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Eaꞌ naꞌamba atin anaf piti hiahaom amamba aliꞌ agaꞌipipami aꞌ motaga hiꞌigalam, ipaꞌ pegawa aeꞌ afiꞌi alutu felefeleꞌma uta. Ina ataꞌ nogota laota, owaꞌ. ");
INSERT INTO aoj_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","“Aeꞌ aꞌipipa endilisi, amam nematawa deiꞌ ataꞌ pagapani ina atiasi pegaꞌ ulal, ataꞌ owaꞌ, ipaꞌ piti hiahaom amamba hiami motaga hiꞌigalam. ");
INSERT INTO aoj_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Otaga noloma itap hiagoma anaf aꞌ higililam, apaꞌ basef aeꞌafi ina higililif, owaꞌatin endilisi. Fegape atapif lifilafii. ");
INSERT INTO aoj_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","37","“Aeꞌ ataga epen egefaꞌ alop epesi aꞌipipa. Owaꞌ anin epen negawa nemaf aꞌa nogota atamba aeꞌ igafiꞌatai. Amom ensel magape ilifi wapani ina mogawa. Aeꞌ nogamana Godi wapani ina egawa, owaꞌ. Ahame atona nagape ilifi anen atotona negawa nemaf afamba. Waf fowaꞌ sandaꞌaf nogota atamba Noa nagapautai, eaꞌ naꞌamba atin siꞌi anaf esis sondaꞌaf nemaf afambai felefeleꞌma ifiꞌi egataga itap apaꞌe. ");
INSERT INTO aoj_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Fowaꞌ embel luꞌwami ataꞌ owaꞌ motagaia, nogota atamba esis sape saꞌ gwaꞌaisi saꞌ embel amam nematawa sindikikilaꞌma sandasoꞌama atin safeꞌ safeꞌ sataga nemaf afamba Noa nafeꞌ nagawis galahoꞌw. ");
INSERT INTO aoj_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Amam nematawa isimba ina sogawa nemaf afamba, owaꞌatin. Esis ukup masoꞌas sandape naꞌamba atin safeꞌ satagama afamba embel luꞌwami mataga magaha esis amam nematawa hiasi mambahoꞌwas hiꞌagalas. Eaꞌ anaf naꞌamba atina nemaf afamba aeꞌ itanima igafiꞌi. ");
INSERT INTO aoj_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Afamba amam biam mondaoꞌoma mondaꞌ maol mogail aofi, God aꞌ nofaꞌ anona, anona nokwahona nil. ");
INSERT INTO aoj_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Eaꞌ anowa nematawa biawa ondaꞌ maola plaua ondaꞌ breti, atiasi God nofaꞌ anoꞌw kofeꞌ nokwaha anoꞌw kope. ");
INSERT INTO aoj_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“Eaꞌ ipaꞌ aꞌ solawaipa andeandeꞌ. Ipaꞌ ina pegawa nambaiꞌ dembinai ipeꞌinai nogafiꞌi, owaꞌatin. ");
INSERT INTO aoj_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Ipaꞌ ukup pepoma anif basef waminif atini. Iꞌi ahama ipati niliꞌ nogawa owamb nogota mamahotama nandaꞌ wali nogafiꞌatai, ama silisilawi numafiata nogape, nandaꞌ wali ina atiasi nifiꞌi nupisila ipat ananitai nuwis nomon, owaꞌatin. ");
INSERT INTO aoj_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Eaꞌ ipaꞌ wapani silisilawi pendape. Deiꞌ main? Aeꞌ ataga epen egefaꞌ alop epesi, ifiꞌi anef nemaf ipaꞌ ina atiasi pegawa piꞌi ifiꞌi ulal nemaf afamba, owaꞌ.” ");
INSERT INTO aoj_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Ipaꞌ hipai pendaꞌ waf buꞌwafi siꞌi anamba nugumafi amom mandaꞌ maoli okom buꞌwami mapaona nandaꞌ maol andeandeꞌ datimai. Aman anamba dembinai ananinai nandandepana ma nugumafi ananimi mandaꞌ maoli ma nogasoꞌama gwaꞌaisi amom nogota dondoꞌatai. ");
INSERT INTO aoj_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Anafa dembinai ananinai notanima nogafiꞌi, ma niti aman anamba nandaꞌ maol andeandeꞌ, daoꞌ aman anamba sonohana. ");
INSERT INTO aoj_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Aeꞌ aꞌipipa endilisi. Dembinai ananinai anaf nondaꞌana nope dambena nugumafi hiahaom hiami ananimi hiꞌigalam. ");
INSERT INTO aoj_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Apaꞌ iꞌi aman anamba nondaꞌ waf awafi okom magapoma opaf ananifi atofi aꞌ niꞌi, ‘Dembinai aeꞌanai ina atiasi nifiꞌi ulal, owaꞌatin.’ ");
INSERT INTO aoj_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Ama anen noha amom mandaꞌ maol atini neaꞌ gwaꞌaisi embel noloma amam amamba mandaꞌ spaki. ");
INSERT INTO aoj_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Eaꞌ Dembinai ananinai atiasi notanima nifiꞌi anef nemaf, apaꞌ aman anamba ina atiasi niꞌi Dembinai nifiꞌi ulal, ataꞌ owaꞌ. Dembinai nogafiꞌi nifiꞌi nogota atamba anen okom mogasoꞌanatama. ");
INSERT INTO aoj_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Eaꞌ aꞌ nohana niliꞌamonana nefeꞌ nope noloma epes isimba sagambasoꞌami malogof biagufisi. Wambel anamba awagoma selef sondaꞌ nalelef tilili talalaꞌ kwapeteꞌ sope. ");
INSERT INTO aoj_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“Anef nogota atamba epes sogawis nomona maol Godi nope Dembinai nugumafias siꞌi anif basef waminif atina nematawa ilufunamaiwa. Anona aman naꞌi nogasoꞌ anoꞌw nemataꞌwi, nafeꞌ napani ma notanima nogafiꞌi. Eaꞌ nematawa awamba aiawaiwai osafel ofaꞌ lambeh handandawa wafeꞌ waꞌi olaoma aman anamba ufiaꞌw ofaꞌana nifiꞌi. ");
INSERT INTO aoj_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Wanowa biawa gawa akawai apaꞌ wanowa biawa ogogawai. ");
INSERT INTO aoj_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Awamba gawa akawai ofaꞌ lambeh halomawa wafiꞌi, apaꞌ awo ina ofaꞌai kerosin atifin nalomawa, owaꞌ. ");
INSERT INTO aoj_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Apaꞌ awamba gawaiwai owala kerosin batowagof ofaꞌan atifin naloma lambeh awoumbihi ofaꞌas atifis wafiꞌi. ");
INSERT INTO aoj_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Aman anamba ina deiꞌ nafiꞌi ulal, ataꞌ owaꞌ. Eaꞌ awo hiawai naep nimanip ambeh hahawa aꞌ waꞌoh. ");
INSERT INTO aoj_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Waꞌoh wafeꞌ wafeꞌ ma aꞌi owaꞌ amanota laꞌafitama aꞌ wameꞌ anef maf fataga faꞌi, ‘Deiꞌ aman nagasoꞌ akoꞌwi nafiꞌi. Ipaꞌ pefeꞌ petolona ufiaꞌw pefaꞌana pifiꞌi.’ ");
INSERT INTO aoj_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Eaꞌ nematawa awamba osafel, wandondomba lambeh awoumbihi ma ogafeꞌ. ");
INSERT INTO aoj_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Apaꞌ nematawa awamba gawa akawai wandaila awamba gawaiwai waꞌipawa waꞌi, ‘Ipaꞌ ataꞌ peseꞌapa kerosin duꞌwanin. Lambeh apeꞌimbihi haꞌi a fegandaꞌambeh.’ ");
INSERT INTO aoj_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Owaꞌ awo waꞌipawa waꞌi, ‘Ahaeꞌ owaꞌatin. Kerosin owaꞌ hiana dondoꞌma apaꞌa, owaꞌ. Ipaꞌ foꞌo petala anin ipeꞌini.’ ");
INSERT INTO aoj_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","“Eaꞌ awo ataꞌ wafeꞌ watala kerosin wagailii, aman anamba nogasoꞌ nemataꞌwi aꞌ nafiꞌi. Eaꞌ nematawa awamba wandaꞌas dumbili dombol wagapani, aꞌ wawis ipat nomon walomana saꞌ gwaꞌaisi luꞌwasi ma aman nagasoꞌ akoꞌwi, eaꞌ uta aꞌ tasoꞌ. ");
INSERT INTO aoj_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Eaꞌ awamba wafeꞌ wagatala kerosini otanima wafiꞌi wagiꞌ wataga, eaꞌ walutu ofalana waꞌi, ‘Dembinai, dembinai, inaꞌ usiꞌmapai uta.’ ");
INSERT INTO aoj_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","“Owaꞌ anen nagwamawai basef naꞌi, ‘Aeꞌ aꞌipipa endilisi, aeꞌ owaꞌ egawepaia.’ ");
INSERT INTO aoj_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Eaꞌ Jisas naꞌi anif basef wapani naꞌi, “Deiꞌ eaꞌ naꞌamba atin, ipaꞌ solawaipa andeandeꞌ. Deiꞌ main, ipaꞌ ina pegawa nambaiꞌ aeꞌ igafiꞌi.” ");
INSERT INTO aoj_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Nemaf afamba aeꞌ itanima igafiꞌafii epes sogawis nomona maol Godi nope Dembinai nugumafias sope naꞌamba atin siꞌi anif basef waminif atina anona aman naꞌi nogafeꞌ anagoni. Anen nofalai amom amamba mandaꞌ maola anini mafiꞌi, aꞌ nasoꞌama hiahawes lagof amamugufi. ");
INSERT INTO aoj_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Anen okom mapoma waf amamifi faloma gawa amamini atona atin, eaꞌ nawalogamam moni amom. Anona nasoꞌana hiani aꞌowaꞌ 5,000 kina, anona nasoꞌana hiani kwasakwasala 2,000 kina, anona nasoꞌana kwasalaꞌin 1,000 kina. Anen nandaꞌmamas naꞌamba ma main, aꞌ nafeꞌ. ");
INSERT INTO aoj_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Eaꞌ aman anamba nogofaꞌ 5,000 kinai nandaꞌ maola nogombamai inimba dembinai nagasoꞌanani, ma nogofaꞌ 5,000 kina wamani wapani. ");
INSERT INTO aoj_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Eaꞌ aman anamba nogofaꞌ 2,000 kinai wapani nandaꞌ maol nombaman aꞌ nofaꞌ anin 2,000 kina wamani wapani naloma fowaꞌini. ");
INSERT INTO aoj_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Apaꞌ aman anamba nogofaꞌ 1,000 kinai owaꞌ nofaꞌan nafeꞌ nalaꞌagon nawa moni inimba dembinai ananinai nambahoꞌwan nape itap. ");
INSERT INTO aoj_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Ama nogota laota tafeꞌma main, dembinai amamunai notanima nafiꞌi. Eaꞌ naꞌi ataꞌ niꞌi basef andeandeꞌ noloma amom nogawa moni inimba anen nagasoꞌamani. ");
INSERT INTO aoj_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Eaꞌ aman anamba nogofaꞌ 5,000 kinai nafiꞌi eaꞌ nofaꞌai 5,000 kina inimba anen nandaꞌ maol nogofaꞌani wapani a naꞌipa dembinai ananinai naꞌi, ‘Dembinai, inaꞌ naseꞌe 5,000 kina atin, apaꞌ deiꞌ inaꞌ niti aeꞌ andaꞌ maola moni inimba deiꞌ efaꞌ 5,000 kina wamani wapani.’ ");
INSERT INTO aoj_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","“Eaꞌ dembinai naꞌipana naꞌi, ‘Inaꞌ aman buꞌunai nandaꞌ maol andeandeꞌ datima. Deiꞌ fowaꞌ inaꞌ nimafi hiahawes saꞌwisi andeandeꞌ datima. Deiꞌ endaꞌena nimafi hiahawes luꞌwasi. Inaꞌ nifiꞌi nendagala neloma dembinai ineꞌinai.’ ");
INSERT INTO aoj_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Eaꞌ aman anamba nogofaꞌ 2,000 kinai nafiꞌi aꞌ naꞌi, ‘Dembinai, inaꞌ niti. Inaꞌ naseꞌe 2,000 kina atin, owaꞌ, deiꞌ andaꞌ maola moni inimba, deiꞌ ifaꞌai 2,000 kina wamani wapani.’ ");
INSERT INTO aoj_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","“Eaꞌ dembinai naꞌipana naꞌi, ‘Inaꞌ aman buꞌunai nandaꞌ maol andeandeꞌ datimai. Fowaꞌ inaꞌ nimafi hiahawes saꞌwisi andeandeꞌ datima. Deiꞌ endaꞌena nimafi hiahawes luꞌwasi. Inaꞌ fiꞌi nendagala neloma Dembinai ineꞌinai.’ ");
INSERT INTO aoj_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Eaꞌ aman anamba nogofaꞌ 1,000 kinai anen wapani nafiꞌi naꞌipa dembinai ananinai naꞌi, ‘Dembinai, aeꞌ egawa inaꞌ aman dindinapinai nagalaꞌambema hiahawes nagaꞌi ineꞌisi atisi. Aof anona aman nagawasafi afamba inaꞌ nafeꞌ nalaꞌasaf. Eaꞌ anep itap anona aman nogowaha olembepi, inaꞌ nafiꞌi nalas. ");
INSERT INTO aoj_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Aeꞌ nomonas sapoma inaꞌ. Eaꞌ aeꞌ ombal bahe ma inaꞌ, deiꞌ afeꞌ alaꞌagon ambahoꞌ 1,000 kina ineꞌini nape itap. Isimba hiahawes ineꞌisi eaꞌ inaꞌ tanima dofaꞌaso.’ ");
INSERT INTO aoj_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“Eaꞌ dembinai ananinai nagwamana basef naꞌipana naꞌi, ‘Inaꞌ nandaꞌ maoli, inaꞌ aman awinai endilisi. Inaꞌ alaꞌuta nagahinai. Endilisi inaꞌ aꞌ negawa aeꞌ alaꞌ gwaꞌaisi anona aman nagawas aof ananifii, a afeꞌ agatopaꞌ wit anep itap anona amani. ");
INSERT INTO aoj_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Iꞌi naꞌambaiai, deiꞌ nefaꞌan negambeꞌan benga aeꞌ itanima ifiꞌi efaꞌan negaloma anin wamani wapani. ");
INSERT INTO aoj_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","“Eaꞌ ipaꞌ dalombana 1,000 kina aman anamba peseꞌanan nefeꞌma aman nanumba nogofaꞌ moni 10,000 kinai. ");
INSERT INTO aoj_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Deiꞌ main? Epes ami sagahapila hiahawesi isimba atiasi sofaꞌ anis wamasi wapani ma hiahawes asasisi sogataga hias. Apaꞌ epen ami owaꞌ nigahapila hiahawesia eaꞌ hiahawes anin nagahapilasi, isimba atiasi endalombanas anin. ");
INSERT INTO aoj_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Aman anamba wafinai ipaꞌ pekwahona nefeꞌ nuwis andoꞌ akotigima endilisi. Wambel anamba awagoma selef sondaꞌ nalelef tilili talalaꞌ kwapeteꞌ sope.” ");
INSERT INTO aoj_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Anaf aeꞌ ataga epen egefaꞌ alop epesi ifiꞌi ilumai glori mogogalaꞌi aeꞌami, eaꞌ amom ensel hiami molome mifiꞌi. Ama nemaf afamba aeꞌ epe etoma sia luꞌunai aeꞌani ma mogogalaꞌi magafiꞌi heveni. ");
INSERT INTO aoj_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Eaꞌ amam nematawa hiasi sifiꞌi hiꞌilas sope nogohnaep aeꞌasi. Eaꞌ aeꞌ inifaꞌas endaꞌas sope misiꞌah biah, siꞌi aman nugumafi sipsipi nanifaꞌ sipsip pagafeꞌ anagon, meme magafeꞌ anagon. ");
INSERT INTO aoj_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Eaꞌ endaꞌ epes aꞌ sefeꞌ sulutu waꞌol lagol kwahisigili aeꞌagili siꞌi sipsip, apaꞌ epes isimba God nondaiwaꞌmasi sulutu waꞌol lagol egawama siꞌi meme. ");
INSERT INTO aoj_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","“Eaꞌ aeꞌ dembiwai king iꞌipa esis isimba sagape lagol kwahisigilii iꞌi, ‘Ipaꞌ ahame aeꞌanai nofaloꞌmepa ma sonogahipai, ipaꞌ piwis anamba anen nagalaꞌambemagoma pefaꞌ hiahaom amamba ipeꞌimi fowaꞌ itap owaꞌ ataꞌ petagaia nandondombam magapomipai. ");
INSERT INTO aoj_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Deiꞌ main, ipaꞌ fowaꞌ pati aeꞌ nolomahe ape ipaꞌ paseꞌe gwaꞌaisi. A pati iap paseꞌe, paseꞌe embel aꞌ embel. Aeꞌ agafiꞌi anambel wambili ipaꞌ pefaꞌe pafeꞌ ifagw ipeꞌigwi. ");
INSERT INTO aoj_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Eaꞌ aeꞌ luwaguf mais ake, ipaꞌ paseꞌeas andaꞌas eaꞌ awasiwi ipaꞌ pimafi andeandeꞌ. Aeꞌ ape andaꞌ kalabus, ipaꞌ pafoꞌo patolowe.’ ");
INSERT INTO aoj_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Eaꞌ esis isimba sagape hililiꞌi atiasi sogwa basef ananifi siꞌi, ‘Dembinai, deiꞌ nemaf mamahefa apaꞌ mati inaꞌ nolomahena maseꞌena gwaꞌaisi inaꞌ? Aꞌ anef nemaf inaꞌ iap paseꞌena apaꞌ maseꞌena embel? ");
INSERT INTO aoj_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Eaꞌ nogota mamahotama apaꞌ matilina siꞌi anambel wambelinai apaꞌ mofaꞌena mafiꞌi ifagw apeꞌigwi? Eaꞌ nemaf mamahefa apaꞌ matilina lowaf akena, maseꞌena lowaf? ");
INSERT INTO aoj_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Eaꞌ nemaf mamahefa mati awasina nape kalabus mafeꞌ magatilina?’ ");
INSERT INTO aoj_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","“Eaꞌ aeꞌ dembiwai king egwamasa basef iꞌi, Aeꞌ aꞌipipa endilisi! Maol buꞌwani mamahina ipaꞌ pandaꞌana pagatopalopa esis sahin owan aeꞌasi falafisi agof akasi, inimbai ipaꞌ ina pandaꞌmasan esis atis, owaꞌ. Pandaꞌmean aeꞌ wapani. ");
INSERT INTO aoj_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Eaꞌ aeꞌ iꞌipa esis sagalutu waꞌol lagol igawamai wapani iꞌi, Ipaꞌ delefata pekwaha aeꞌ foꞌo. God nandaiwaꞌmepa naꞌi ipaꞌ epes awipai. Ipaꞌ foꞌo wambel awambili nif luꞌwafi fagapoma. Nif ifimba ahame nandaꞌef fandandombol fapoma aman aunai Satan naloma ensel ananimi. ");
INSERT INTO aoj_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Deiꞌ main, ipaꞌ fowaꞌ ina pandaꞌ waf buꞌwafi, owaꞌatin. Aeꞌ nolomahe agape, ipaꞌ ina paseꞌe gwaꞌaisi, owaꞌ. Eaꞌ aeꞌ iap pagaseꞌema embel, ipaꞌ ina paseꞌe embel aꞌ embel, owaꞌ. ");
INSERT INTO aoj_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Eaꞌ aeꞌ siꞌi epen anagon lauguniwai, apaꞌ ipaꞌ owaꞌ pefaꞌe pefeꞌ ifagw ipeꞌigwia, owaꞌ. Eaꞌ lowaf ake ipaꞌ ina paseꞌe lowaf, aeꞌ awasiwi, ape andaꞌ kalabus apaꞌ ipaꞌ ina pafoꞌo patolowe, owaꞌatin. ");
INSERT INTO aoj_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Eaꞌ esis wapani aꞌ sogwa basef sohaliꞌana siꞌi, ‘Dembinai, deiꞌ nemaf mamahefa apaꞌ mati inaꞌ gwaꞌaisi embel akana nolomahena, a inaꞌ epen anagon lauguninai, a inaꞌ lowaf akana awasina a nape nandaꞌ kalabus, eaꞌ apaꞌ owaꞌ mofoꞌo motopalopenaea?’ ");
INSERT INTO aoj_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","“Eaꞌ aeꞌ aꞌ egwamasa basef esis iꞌi, Aeꞌ aꞌipipa endilisi, waf maif owaꞌ pendaꞌafa anin epen inimba falafuna agol akania, isimba eaꞌ naꞌamba atin ina pandaꞌmeaf aeꞌ wapani, owaꞌatin. ");
INSERT INTO aoj_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Eaꞌ amam nematawa isimba sofeꞌ sofaꞌ hiahaom awami akafimi magape atapim lifilafii. Apaꞌ epes isimba buꞌwasi anaf sofaꞌ ambal namili aꞌ sofeꞌ sope anamba sogape boꞌwes lifilafima.” ");
INSERT INTO aoj_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Jisas nawalipasa basef ifimba laufi ma hiꞌalef, ama nogota atamba anen naꞌipa alipumi ananimi naꞌi, ");
INSERT INTO aoj_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Ipaꞌ pegawa, nimaguf bif dowaf ataꞌ fapoma nemaf afamba ma sogaꞌ gwaꞌaisi luꞌwasi saꞌi Pasova afegataga. Atiasi nemaf afamba anona aman nowalapa aeꞌ ataga epen egefaꞌ alop epesi ma anom amam boumi mogandele lawag usiꞌigai tiꞌwanaegai mohe egagaꞌ.” ");
INSERT INTO aoj_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Nemaf afamba amom pris dembami maloma agufumi esis Judai munduwaꞌanima mape ipat Kaiafasi, anen pris dembinai nape nagaliꞌma pris hiamii. ");
INSERT INTO aoj_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Eaꞌ maꞌi basef mandameꞌmaefa mondaꞌ uhuf mefeꞌma mombaloꞌ Jisas mohana nogagaꞌ. ");
INSERT INTO aoj_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Owaꞌ amom mandaiwaꞌma mogombaloꞌana nemaf afamba sandaꞌ gwaꞌaisi isimba luꞌwasiafi. Naꞌamba epes hiasi ukup awep eaꞌ sohafel sondaꞌ wandaf. ");
INSERT INTO aoj_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Nemaf afamba Jisas nafeꞌ Betani nape ipat anona aman Saimoni, fowaꞌ aowas aunai nandaꞌ alop ananipi pagambuꞌwi, apaꞌ deiꞌ amboꞌona. ");
INSERT INTO aoj_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Eaꞌ anoꞌw nemataꞌw kwafiꞌmai anen kwahapila anol botol sandaꞌal siꞌi otami, embel sanda alogw fasigwi gwagaꞌani sagatalin otamba luꞌumbai nala botol alamba. Eaꞌ kwakoloꞌw sanda inimba newala balaga Jisasi ma tebol anen nagatomama. ");
INSERT INTO aoj_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Amom alipumi ananimi mati naꞌamba, ukup amamipi awep aꞌowaꞌ. Eaꞌ maꞌi, “Deiꞌ maina akoꞌw kwagahambombaga sanda inimba nagafeꞌ dowaf? ");
INSERT INTO aoj_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Iꞌi afaꞌ ofaꞌana anis epes sotalin moni hiani ma afaꞌ ofaꞌan ogasoꞌ epes isimba kwahusa gwaꞌaisi mainai, daoꞌ andeandeꞌ. Apaꞌ owaꞌ, owaꞌatin.” ");
INSERT INTO aoj_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Eaꞌ Jisas nogawa ukup amamipi, naꞌipam naꞌi, “Deiꞌ maina ipaꞌ ukup awasip pagapoma nemataꞌw akwamba? Owaꞌi. Akoꞌw kwandaꞌ waf afamba fasifima aeꞌ. ");
INSERT INTO aoj_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Isimba kwahusa gwaꞌaisi maini sape salomepa nimaguf hiafi. Apaꞌ aeꞌ ina ataꞌ elomepa egape nimaguf hiafi, owaꞌatin. ");
INSERT INTO aoj_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Nemataꞌw akwamba kwakoloꞌwa sanda inimba ma alop aeꞌapi, kwandaꞌ isimba kwindilaꞌwaifa felefeleꞌma esis sogawe matmat. ");
INSERT INTO aoj_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Endilisi aeꞌ aꞌipipa, ganimba itap walemb hiagoma anaf sigaꞌipasa basef buꞌwafi aeꞌafi, siꞌipasa basef akoꞌufi wapani ma ukup pegapoma waf buꞌwafi akoꞌw kwandaꞌmeafi.” ");
INSERT INTO aoj_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Nogota atamba anona amom alipumi Jisasi 12-pelaim, aman anamba Judas Keriotinai aꞌ nafeꞌma amom pris hiami dembami. ");
INSERT INTO aoj_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Eaꞌ nahaliꞌam naꞌi, “Ipaꞌ paꞌi peseꞌe main petalowe ma igihimbaꞌmepana?” Eaꞌ amom matalifa moni silva 30-pelain aꞌ masoꞌana. ");
INSERT INTO aoj_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Aꞌi owaꞌ nogota atamba atota nandaꞌas atapina nalaꞌ nolaoma anoꞌw ufiaꞌwa nigihimbaꞌmama Jisas amoma mogombaloꞌana. ");
INSERT INTO aoj_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Nemaf afamba saliꞌ sagaꞌ anis gwaꞌaisi sagaꞌi Pasovai esis saꞌ bret atamba owaꞌ togatef luꞌutaia eaꞌ amom alipumi ananimi mafiꞌmai anen mahaliꞌana maꞌi, “Inaꞌ naꞌi afaꞌ ofeꞌ ondondomba ipat anima ma inaꞌ negaꞌ gwaꞌaisi isimba?” ");
INSERT INTO aoj_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Eaꞌ naꞌi, “Ipaꞌ pefeꞌ taun, pefeꞌma anona aman piꞌipana piꞌi, ‘Dembinai Tisa naꞌi, “Nemaf dondoꞌafi God nandandepamiefi eaꞌ felefeleꞌ. Aeꞌ aꞌi eaꞌ Pasova inimba eloma alipumi aeꞌami ope ipat ineꞌitai.’” ");
INSERT INTO aoj_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Eaꞌ amom alipumi ananimi mandaꞌas naꞌamba atin siꞌi anen nagaꞌipam eaꞌ mandaꞌ gwaꞌaisi Pasovai dumbili dombol. ");
INSERT INTO aoj_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Aꞌi owaꞌ owamb anen nape naꞌ gwaꞌaisi tebol naloma alipumi ananimi 12-pelaim. ");
INSERT INTO aoj_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Eaꞌ amom mape maꞌ gwaꞌaisi atin owaꞌ, Jisas naꞌipam naꞌi, “Aeꞌ aꞌipipa endilisi, anona afaꞌinai atiasi aꞌ nefeꞌ nihimbaꞌma amom boumi ma aeꞌ egapoma.” ");
INSERT INTO aoj_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Eaꞌ ukup amamipi nimanip aꞌowaꞌ, mosafel mahaliꞌana atona atin maꞌi, “Dembinai, aeꞌ aꞌa ami?” ");
INSERT INTO aoj_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Owaꞌ anen nagwamama basef naꞌi, “Aman anamba deiꞌaol nalome wahapila bret wagalata disi, anen eaꞌ maꞌuna, anamba atiasi nogawalapa aeꞌi. ");
INSERT INTO aoj_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Ahoꞌ, aeꞌ ataga epen egefaꞌ alop epesi, atiasi anis epes sehe egagaꞌ siꞌi Buk Baibel nagaꞌiasa aeꞌ. Apaꞌ aman anamba nogawalapa aeꞌ ma boumii, anen uwahipina endilisi. Atiasi hiahaom awami endilisi aꞌ motagamana. Fowaꞌ maꞌmana owaꞌ ataꞌ kolanai, daoꞌ aꞌ andeandeꞌ. Ama anen ina aꞌ notagama hiahaom akafimi amamba awami. Owaꞌ, aꞌ owaꞌatin.” ");
INSERT INTO aoj_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Eaꞌ aman anamba Judas nogawalapa Jisasa bousii anen anagwa basefa Jisas naꞌi, “Dembinai Tisa, aeꞌ aꞌias aꞌa owaꞌatin?” Jisas nagwamana basef naꞌi, “Inaꞌ atina naꞌiam.” ");
INSERT INTO aoj_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Jisas nalomam ataꞌ mape maꞌ gwaꞌaisi atin, ama main, nasaꞌma anota bret, nandabeten nanifela God, nawalota nasoꞌam naꞌipam naꞌi, “Ipaꞌ saꞌmata peaꞌata. Bret atamba alop aeꞌapi.” ");
INSERT INTO aoj_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Eaꞌ nasaꞌmai anop kap embel wain bagalapi nanifela God, nasoꞌam naꞌipam naꞌi, “Ipaꞌ hipai gwaꞌembel atin. ");
INSERT INTO aoj_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Embel ambalemba esimbel aeꞌambeli bewaꞌ banaga basef ifimba God nagalaꞌ lapafi dambaifi. Esimbel ambalemba aeꞌ ekoloꞌwambela God nokwahomasa waf awafi epes hiasii okom mogasoꞌanaf. ");
INSERT INTO aoj_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Aeꞌ aꞌipipa, ina ataꞌ itanima iaꞌ wainimbel wapani, owaꞌ. Aeꞌ efeꞌ etaga anamba ahame nagalaꞌambemagoma, daoꞌ aꞌ iaꞌ anin wain dambaini elomepa anamba. ");
INSERT INTO aoj_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Amom mandaꞌ anof awaf eaꞌ, mawisi aꞌ mafeꞌ mondowasaꞌ halafuta Oliv. ");
INSERT INTO aoj_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Jisas naꞌipam naꞌi, “Atiasi owamb ambaꞌe pindaiwaꞌma pagahapifi a pekwahowe. Deiꞌ main, fowaꞌ gani Baibel nagaꞌi naꞌamba naꞌi, God naꞌi, ‘Anaf owagama gani, aeꞌ eha aman anamba nugumafi sipsipi nogaꞌ. Eaꞌ sipsip amamba atiasi aꞌ mofaꞌ mefeꞌ atona biana.’ ");
INSERT INTO aoj_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","“Apaꞌ owaꞌ owaꞌatin, atiasi aeꞌ itanima asafel wapani aꞌ iliꞌipa efeꞌ itap luꞌupa Galili.” ");
INSERT INTO aoj_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Eaꞌ Pita nagwa basef naꞌamba naꞌi, “Iꞌi anom owaꞌ mohapifina banagema ma miꞌi mokwahena, hapaimi, ihapifina banagewe ina atiasi ikwahina, owaꞌatin.” ");
INSERT INTO aoj_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Eaꞌ Jisas nagwamana basef naꞌi, “Aeꞌ aꞌipina endilisi, atiasi owamb ambaꞌe awata ataꞌ owaꞌ totaea, inaꞌ aꞌ nendehaliꞌmi niꞌias wanif niꞌi, ‘Aeꞌ owaꞌ egawa Jisasa.’” ");
INSERT INTO aoj_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Eaꞌ Pita naꞌipana naꞌi, “Owaꞌatin. Esis soha afaꞌ biafa ogaꞌ atin. Aeꞌ ina aꞌ indahaliꞌmina, owaꞌatin endilisi.” Eaꞌ alipumi hiami Jisasi maꞌias naꞌamba atin hiꞌalam. ");
INSERT INTO aoj_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Jisas naoꞌwa alipumi ananimi mafeꞌ atin anagon Getsemani lawah oliv hogotawama. Eaꞌ naꞌipam naꞌi, “Ipaꞌ pepe naꞌa, aeꞌ efeꞌ gani waꞌol endabeten.” ");
INSERT INTO aoj_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Eaꞌ anen naoꞌwa Pita naloma Sebedi nogaopana Jemsi Jon aꞌ mafeꞌ. Eaꞌ nameꞌ opaf ananifi aꞌ nimanif kwapeteꞌ endilisi. ");
INSERT INTO aoj_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Eaꞌ naꞌipam naꞌi, “Nembel aeꞌambili nimanimbil aꞌowaꞌ, ma aeꞌ egagaꞌ. Ipaꞌ pepe naꞌa silisilawi pepe pesase ma igitanimai.” ");
INSERT INTO aoj_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Eaꞌ anen nandambema nafeꞌ kwasakwasala, aꞌ nowa nambeꞌ opaf notawa nandabeten naꞌi, “O ahame aeꞌinai, iꞌi inaꞌ nigaꞌi awima, daoꞌ nekwahome kap apamba. Apaꞌ owaꞌ, inaꞌ nindaila okom ineꞌimi atom, aeꞌ owaꞌ.” ");
INSERT INTO aoj_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Nahaliꞌana eaꞌ, nosafel notanima nafeꞌma alipumi ananimi magapoma, owaꞌ nati amom aꞌ maꞌoh magaꞌ mafeꞌ. Eaꞌ nofala Pita naꞌi, “Ipaꞌ banagepa pepe pesasa aeꞌ aꞌa owaꞌ? Nogota aꞌipipa aꞌi pepe pegasasa aeꞌ ina laota, owaꞌ. Nogota bandata siꞌi aua atitin. ");
INSERT INTO aoj_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Ipaꞌ solawaipa pepe pendabeten. Naꞌamba hiahaom mogogwambipai aꞌ motagama ipaꞌ. Endilisi ambagof ipeꞌigufi faꞌi awima pendabeten, apaꞌ alop owaꞌ banagepa, alaꞌuta tahepa.” ");
INSERT INTO aoj_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Eaꞌ anen notanima nafeꞌma bif nandabeten naꞌi, “Ahame aeꞌinai, iꞌi kap apamba owaꞌ anoꞌw ufiaꞌwa aeꞌ indihiꞌamapa, eaꞌ hapaimi, aeꞌ eaꞌ endefaꞌap. Ina nindaila okom ineꞌimi atom.” ");
INSERT INTO aoj_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Anen nahaliꞌana eaꞌ nandambemef notanima nafiꞌi bif magapoma nati amom ataꞌ maꞌoh atin, naep amamipi nimanip. ");
INSERT INTO aoj_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Eaꞌ nakwahom notanima nafeꞌ nandabeten wapanima aꞌ wanif. Beten inimba atin dokoꞌ naliꞌ nandaꞌani, atin notanima nandaꞌan wapani. ");
INSERT INTO aoj_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Ama main, notanima nafiꞌmai amom magapoma naꞌipam naꞌi, “Ipaꞌ ataꞌ papoma nomaꞌw paꞌoh atin aꞌa? Pemeꞌ! Nogota aeꞌatai atataga. Deiꞌ nemaf afaꞌe anona aman aunai aꞌ nifiꞌi nulumai anom amam awami mufiꞌi mowa aeꞌ, ataga epen egefaꞌ alop epesi. ");
INSERT INTO aoj_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Safel! Aꞌ ofeꞌ uti aman anamba nigihimbaꞌmama aeꞌi deiꞌ aꞌ nafiꞌi.” ");
INSERT INTO aoj_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Jisas ataꞌ nalutu naꞌipam atin, owaꞌ anona aman nafiꞌi. Aman anamba Judas, anona amom 12-pelaim Jisasi. Anen nafiꞌi nalomai amam hiami mahapila bainagwi belep. Amom pris dembami malumai amom agufumi dembami esis Judai masapaꞌam mafiꞌi. ");
INSERT INTO aoj_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Eaꞌ aman anamba nogawalapa Jisasi, aꞌ naliꞌ naꞌipam nandaꞌ ametal nihimbaꞌmaman naꞌi, “Atiasi ipaꞌ piti aeꞌ igasisiꞌa dalogwanai, aman anamba eaꞌ maꞌuna Jisas. Ipaꞌ pihapilana pembaloꞌana tatalaꞌina.” ");
INSERT INTO aoj_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Eaꞌ anen nafeꞌma Jisas kwafalis naꞌi, “Owamb buꞌwambi, Dembinai.” Eaꞌ nasisiꞌ dalogwana. ");
INSERT INTO aoj_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Eaꞌ Jisas naꞌipana naꞌi, “O alipunai, hiahawes inaꞌ nafiꞌi ma naꞌi nendaꞌasi, awi inaꞌ daꞌas kwafalis.” Eaꞌ amom mafiꞌi felefeleꞌma anen mowasaꞌ lagof mahapilana sisihina. ");
INSERT INTO aoj_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Eaꞌ anona aman nape nagaloma Jisasi, nala lagol nagiai bainat ananitai naha anona aman nandaꞌmana maola pris dembinai nape nagaliꞌma pris hiamii, eaꞌ natopaꞌ aliga ananigai peleꞌataga gowa. ");
INSERT INTO aoj_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Owaꞌ Jisas naꞌipana naꞌi, “Sapaꞌ bainat tofeꞌ tope tagapoma. Amom hiami mogapaꞌ bainagwi, atiasi bainagw goham mogaꞌ. ");
INSERT INTO aoj_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Inaꞌ negawa banagami Ahamai aꞌa owaꞌ? Iꞌi aeꞌ ihaliꞌana ai, anen nasoꞌai ensel ananimi hiami aꞌowaꞌ kwafalis atis, mikilaꞌ misiꞌah ahamba soldia 12-pelaih. Apaꞌ owaꞌ, owaꞌatin. ");
INSERT INTO aoj_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Aeꞌ iꞌi endaꞌ waf afamba ai, atiasi basef ifimba fowaꞌ God naꞌif fagape buk Baibeli ina atiasi fetaga alihif dondoꞌma esis sifiꞌi sogombaleꞌe, owaꞌatin.” ");
INSERT INTO aoj_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Eaꞌ Jisas naꞌipa esis amam nematawa hiasi naꞌi, “Ipaꞌ pefaꞌi bainagwi belep pafiꞌi siꞌi pafiꞌi paꞌi pegewaꞌ anona aman aunai napaꞌ nagaloma gavmani aꞌa? Nimaguf hiafi aeꞌ ape alomepa ipat luꞌunai Godi awalapa basef buꞌwafi esis amam nematawa hiasi, apaꞌ ipaꞌ owaꞌ pembaleꞌea. ");
INSERT INTO aoj_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Apaꞌ deiꞌ hiahaom amamba ipaꞌ pandaꞌami mataga dondoꞌma basef ifimba fowaꞌ God naꞌipa amom profet mandaꞌef fagail buki aꞌ fataga endilisi.” Eaꞌ alipumi ananimi hiami makwahona mafaꞌ mafeꞌ hiꞌalam. ");
INSERT INTO aoj_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Amom amamba mogombaloꞌ Jisasi mofaꞌana mafeꞌ ipat anona pris dembinai nape nagaliꞌma pris hiamii Kaiafas. Eaꞌ amom dembami magawalipasa muꞌuli Godi maloma agufumi esis Judai mundowaꞌanima mape. ");
INSERT INTO aoj_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Apaꞌ Pita ina nalomam nafeꞌ atef owaꞌ. Anen nagigiꞌmam nafeꞌ nataga indalelemb nawis ipat dembinai prisi nafeꞌ nape naloma amom polisman mapoma nif. Anen naꞌi nope niti atiasi main netaga. ");
INSERT INTO aoj_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Eaꞌ amom pris dembami maloma amom dembami Juda mugumafi koti, amom hiami maꞌi molaoma anis epesa sombasoꞌma Jisas sosapagana ma anif basefa mohana nogagaꞌ. ");
INSERT INTO aoj_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Eaꞌ epes hiasi sataga saꞌi basef basoꞌafi fafeꞌma anen. Apaꞌ esis ina satagama anif basef endilisifi kofagefa ma mohana nogagaꞌ, owaꞌ. Aꞌi owaꞌ main, anom amam biam mataga ");
INSERT INTO aoj_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","maꞌi, “Aman anamba naꞌi anif basef naꞌi, ‘Aeꞌ laꞌifiwai ma igugulata ipat luꞌunai Godi ma itanima egalaꞌana wapani nimaguf wanif dowaf.’” ");
INSERT INTO aoj_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Eaꞌ pris anamba dembinai nalutu nahaliꞌ Jisas naꞌamba naꞌi, “Inaꞌ negwa basef ifimba aꞌa owaꞌ? Deiꞌ maina amom magaꞌipina basef naꞌamba?” ");
INSERT INTO aoj_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Owaꞌ Jisas ina naꞌi anif basef, owaꞌatin. Eaꞌ pris anamba naꞌipana naꞌi, “Aeꞌ aꞌipina endilisi ma agol Dembinai Godi nagape lifilafii, inaꞌ kipa apaꞌ. Inaꞌ Krais Nogama Godi nandandepena nasapaꞌena nagafiꞌii, aꞌa owaꞌ?” ");
INSERT INTO aoj_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Eaꞌ Jisas naꞌi, “Ipaꞌ paꞌias eaꞌ maꞌwis. Apaꞌ aeꞌ aꞌipipa, anaf owagama ipaꞌ piti aeꞌ ataga epen egefaꞌ alop epesi, epe lagol kwahisigili Godi banagewe. Epe otaga ilif itanima ifiꞌi petolowe.” ");
INSERT INTO aoj_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Jisas naꞌias naꞌamba owaꞌ pris anamba aꞌ okom wandafuna eaꞌ nahapeꞌ klos amamba anen nagalami naꞌias naꞌi, “Anen aꞌ nandaꞌ dembinai God findiwana ma basef awafi! Apaꞌ ina ataꞌ mofalai anis wapani sifiꞌi siꞌi anif basefa anen, owaꞌatin. Anen naꞌipana basef awafi God, eaꞌ ifimba deiꞌ pameꞌanamef eaꞌ. ");
INSERT INTO aoj_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Ipaꞌ ukup pape paꞌimama?” Amom hiami magwamana maꞌi, “Anen nandaꞌ waf awafi eaꞌ andeandeꞌma aꞌ nogaꞌo.” ");
INSERT INTO aoj_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Eaꞌ amom misiꞌwafa amaga Jisasi mahana. Anom mopagamana aomb masopamana naep ananipi maꞌi, “Inaꞌ Krais God nasapaꞌena nagafiꞌii, ");
INSERT INTO aoj_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","inaꞌ aꞌ niꞌi basef siꞌi anona profet nagaꞌiefi newalapa ami nagahinai.” ");
INSERT INTO aoj_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Pita tol nape indalelemb nomon nape ipat andeꞌetama. Eaꞌ anoꞌw nemataꞌw kwandaꞌ maoli kwafiꞌi felefeleꞌ ma anen eaꞌ kwaꞌipana kwaꞌi, “Inaꞌ wapani nape nagaloma Jisas ganimba itap luꞌupa Galilii.” ");
INSERT INTO aoj_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Owaꞌ Pita nandahaliꞌ naꞌi owaꞌ ma naep isimba hiasii naꞌi, “Aeꞌ ina egawa basef ifimba inaꞌ nagaꞌiefi, owaꞌatin.” ");
INSERT INTO aoj_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Eaꞌ nafeꞌ nalutu indalelemb nomon felefeleꞌma uta, anoꞌw nemataꞌw kwatolona wapani kwaꞌipa esis amam nematawa sagape felefeleꞌi kwaꞌi, “Aman anamba anen nape nagaloma Jisas Nasaretinaii.” ");
INSERT INTO aoj_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Owaꞌ Pita nandahaliꞌma basef wapani eaꞌ naꞌi, “Endilisi ilif, aeꞌ ina egawa aman anamba.” ");
INSERT INTO aoj_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Aꞌi owaꞌ main, owaꞌ anom amam malutu mafiꞌi maꞌipa Pita maꞌi, “Endilisi atis, inaꞌ aman miniꞌap amamipi. Diga ineꞌigai gawalapena alihina.” ");
INSERT INTO aoj_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","“Eaꞌ deiꞌ Pita nosafel naꞌi basef nagaꞌif banagafi naꞌi “Endilisi gani ilif, aeꞌ ina egawa aman anamba ipaꞌ deiꞌ pagaꞌinai, owaꞌ atin endilisi.” Anen naꞌias eaꞌ, owaꞌ, awata atata. ");
INSERT INTO aoj_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Eaꞌ Pita aꞌ okom mandandaꞌ ma basef nambatiꞌ Jisas naꞌipanaef, nagaꞌi, “Awata owaꞌ ataꞌ totaea, inaꞌ atiasi inaꞌ aꞌ nembasoꞌmas niꞌias wanif niꞌi, ‘Inaꞌ owaꞌ negawea.’” Eaꞌ Pita nawisi nafeꞌ andoꞌ nalef mehip aꞌowaꞌ. ");
INSERT INTO aoj_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Aꞌi owaꞌ lala kuhimbita amom pris hiami dembami maloma agufumi esis Judai maꞌi basef mandameꞌmaefa moha Jisas nogagaꞌ. ");
INSERT INTO aoj_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Amom mowaꞌana mofaꞌana mafeꞌ masoꞌ gavman dembinai Pailat. ");
INSERT INTO aoj_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Deiꞌ aman anamba Judas nagawalapa Jisasa amom boumi nati amom mandaꞌ basef mapaꞌaga Jisasa nogagaꞌ. Eaꞌ nati amom mapaꞌagana mandaꞌ hiahawes isimba, eaꞌ nofaꞌ nimanimi luꞌwami aꞌowaꞌ. Eaꞌ deiꞌ anen notanima nowambela moni silva inimba 30-pelain nafeꞌma amom pris amamba dembami maloma agufumi esis Judai. ");
INSERT INTO aoj_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Eaꞌ naꞌi, “Aeꞌ andaꞌ waf awafi awalapa aman anamba buꞌunai, owaꞌ nondaꞌ waf awafia atiasi aꞌ nogaꞌ.” Owaꞌ amom maꞌi, “Amamba ina kofagema afaꞌimi, owaꞌ. Amamba eaꞌ kofagema ineꞌimi atom.” ");
INSERT INTO aoj_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Eaꞌ Judas nakwaha moni silva inimba ipat luꞌunai Godi nomon, nafeꞌ anagon nandaha nail mandof eaꞌ aꞌ afuna. ");
INSERT INTO aoj_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Amom pris amamba dembami mofaꞌ moni inimba maꞌi, “Moni inimba anin nagatala aman anamba afaꞌ wahana nogagaꞌi. Eaꞌ afaꞌ ina ombeꞌ moni inimba neloma moni nagaꞌoh ipat luꞌunai Godi, owaꞌi.” ");
INSERT INTO aoj_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Eaꞌ amom maꞌi anif basef mandameꞌmaef, ama moni inimba mandaꞌan matala anep itapa anona aman nagalaꞌ malihi. Eaꞌ mofaꞌ itap apamba ma mondaꞌ matmata sogawa epes isimba lauginisi safiꞌi salomas sape sagagaꞌi. ");
INSERT INTO aoj_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Eaꞌ deiꞌ sofala agilipa saꞌi, “Itap esimbel bagatalipi.” Deiꞌ agol agalemba ma itap apamba ataꞌ gape atapigil. ");
INSERT INTO aoj_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Eaꞌ anif basef fowaꞌ gani God nigihimbaꞌmanaef anona aman profet Jeremaia nandaꞌafi ifimba deiꞌ aꞌ fataga alihif fandawalap. Basef ifimba fagaꞌias naꞌamba faꞌi, “Amom mofaꞌ otamba silva 30-pelaimba, esis Juda asandandepamba ma aman anambai. ");
INSERT INTO aoj_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Eaꞌ moni inimba satala anep itapa anona aman nagalaꞌ malihi, siꞌi Dembinai nagaꞌipa aeꞌ dindinip.” ");
INSERT INTO aoj_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Amom mofaꞌ Jisas mafeꞌ nalutu nogohnaep dembinai gavman Pailati, eaꞌ Pailat nahaliꞌana naꞌi, “Inaꞌ king dembinai Judai aꞌa owaꞌ?” Eaꞌ Jisas nagwamana basef naꞌi, “Basef ifimba inaꞌ nagaꞌiefi endilisifi.” ");
INSERT INTO aoj_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Eaꞌ amom pris amamba dembami maloma agufumi esis Judai masapagana ma basef hiafi, apaꞌ anen ina nagwamam anif basef, owaꞌ. ");
INSERT INTO aoj_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Eaꞌ Pailat nahaliꞌana naꞌi, “Inaꞌ nameꞌ basef ifimba hiafi esis sandaꞌmena kotefi, aꞌa owaꞌ?” ");
INSERT INTO aoj_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Owaꞌ Jisas ina nagwamana basef Pailat, owaꞌatin. Eaꞌ dembinai gavman gogolalasona kwapeteꞌ. ");
INSERT INTO aoj_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Nogota atamba gavman anamba dembinai waf ananifi naꞌamba. Afagof danda ma nemaf afamba buꞌwafi esis sandaꞌ anis gwaꞌaisi luꞌwasiafi, anen a nakwahowa anin epen nandaꞌ kalabusi nafeꞌ wahifin. Epen mamahina esis amam nematawa hiasi sandandepani, dembinai gavman naꞌi ahoꞌ nakwahin nafeꞌma esis wahifin. ");
INSERT INTO aoj_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Nemaf afamba anona aman aunai nape nandaꞌ kalabus, agilinama Barabas. Aman anamba nandaꞌ waf awafi endilisi. ");
INSERT INTO aoj_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","18","Eaꞌ esis amam nematawa sunduwaꞌanima salutu. Pailat nogawa amom dembami esis Judai kowalama epes hiasi sagaila basef Jisasi ukup aom atom mapomana deiꞌ mandaꞌ kotimana. Isimba atis deiꞌ nahaliꞌas naꞌi, “Ipaꞌ paꞌi aeꞌ ekwaha ami nekwaha kalabus nefeꞌmago ipaꞌ? Ekwaha Barabas aꞌa Jisas, esis sagaꞌi Krais dembinai?” ");
INSERT INTO aoj_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Eaꞌ Pailat nape ipat atamba sandakolas sandaꞌ kota, eaꞌ wauluꞌmana ananiꞌwi kwasapaꞌ basef fafiꞌmai anen kwaꞌi, “Inaꞌ owaꞌi aꞌ nendaꞌ anin mae awanima aman anamba fasinaia, owaꞌi. Aeꞌ dokoꞌ aꞌoh owamb andondoꞌah atolona eaꞌ efaꞌ akafimi ma anen.” ");
INSERT INTO aoj_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Apaꞌ amom pris amamba dembami maloma anom agufumi esis Judai masaꞌma nomonas esis amam nematawai ma sohaliꞌ Pailata nogakwahowa Barabas, a soha Jisas nogagaꞌ. ");
INSERT INTO aoj_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Eaꞌ dembinai Pailat naꞌipas wapani naꞌi, “Amam amamba biam, ipaꞌ paꞌi aeꞌ ekwaha ami nefeꞌmago ipaꞌ?” Eaꞌ saꞌipana saꞌi, “Barabas.” ");
INSERT INTO aoj_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Eaꞌ Pailat nahaliꞌas naꞌi, “Deiꞌ ipaꞌ paꞌi aeꞌ endaꞌmana main aman anamba Jisas pagaꞌi Kraisi?” Esis hiasi nahaliꞌas saꞌi “Dolana nil lawag usiꞌigai tiꞌwanaegai!” ");
INSERT INTO aoj_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Eaꞌ Pailat nahaliꞌas naꞌi, “Deiꞌ main? Anen nandaꞌ waf maif awafi?” Owaꞌ esis gigal saꞌoh saꞌi mehip saꞌi, “Dolana lawag hana afuna!” ");
INSERT INTO aoj_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Eaꞌ Pailat aꞌ nogawa basef ananifi ina banagefa nogapaꞌagas, owaꞌ. Naꞌamba asondaꞌ wandaf luꞌwafi. Eaꞌ Pailat nolai anambel embel nasaꞌopa lagof ananigufi ma naep esis amam nematawai nindihimbaꞌ naꞌias naꞌi, “Aeꞌ kofagema owaꞌatina egaha aman anamba nogagaꞌ. Maol ipeꞌini atin,” ");
INSERT INTO aoj_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Eaꞌ amam nematawa hiasi sagwa basef saꞌi, “Eaꞌ kofagema amamba aꞌ mondafiꞌmai apaꞌ moloma awasi apeꞌisi.” ");
INSERT INTO aoj_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Eaꞌ Pailat nakwahowa Barabas nafeꞌma esis. Eaꞌ naꞌipa amom soldia ma mogopagaha Jisas mofaꞌana mefeꞌ mogandolana lawag usiꞌigai tiꞌwanaegai. ");
INSERT INTO aoj_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Eaꞌ amom soldia mofaꞌ Jisas mawisi ipat amom gavmani luꞌutai. Eaꞌ mofala anom soldia hiami mafiꞌi munduwaꞌanima ma anen. ");
INSERT INTO aoj_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Eaꞌ mowalia luwaguf maim ananimi malamana anota saket akwahitai. ");
INSERT INTO aoj_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Eaꞌ mowaloꞌmana anof mandof higatagufi, malaꞌwatefaf siꞌi hat mowaloꞌmanana balaga ananigai. Eaꞌ masoꞌana anota alifita nahapilata lagol ananigili. Amom mindiwa nembawa motawa felefeleꞌma anen, mandaꞌ salamal lahana maꞌi basef findiwaifi ma anen maꞌi, “Nemaf buꞌwafi, inaꞌ king dembinai esis Judai!” ");
INSERT INTO aoj_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Eaꞌ misiꞌwafana mandalombana alifita atamba mopagahona balaga ananigai. ");
INSERT INTO aoj_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Mandaꞌana findiwana ma eaꞌ, mowalimana saket atamba, malamana klos mais ananisi a mofaꞌana mafeꞌma mogandolana lawag usiꞌigai tiꞌwanaegai. ");
INSERT INTO aoj_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Amom mosafel mafeꞌ owaꞌ mati anona aman Saimon Sairiniinai. Eaꞌ amom soldia masasapaꞌana ma notopalopa Jisas nogofaꞌ lawag ananigai. ");
INSERT INTO aoj_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Eaꞌ mafeꞌ mataga anagon agiligima Golgota. Apaꞌ deiꞌ mambemefagol maꞌi, Pipitagol Balagaigil. ");
INSERT INTO aoj_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Eaꞌ masoꞌana anambel embel wainimbel mandaꞌ marasin numbutinai nalomambela neaꞌ embel begahagofa akep luꞌwami. Anen ataꞌ nameꞌ embel atin, owaꞌ, nandaiwaꞌmambel. ");
INSERT INTO aoj_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Amom mandolana lawag usiꞌigai tiꞌwanaegai eaꞌ, mandaꞌ satu ma luwaguf maim ananimi ma ami nigikilaꞌi mofaꞌef mondondamef atona atin. ");
INSERT INTO aoj_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Amom tol mape anamba mumafiana. ");
INSERT INTO aoj_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Eaꞌ mandaꞌ anif basef fail lawag ilifugama felefeleꞌma balaga ananigai. Basef ifimba kotefi Pailat nandaꞌafi fagaꞌias naꞌamba faꞌi, “AMAN ANAMBA ANEN JISAS, DEMBINAI ESIS JUDAI.” ");
INSERT INTO aoj_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Felefeleꞌma Jisas nagaima amom soldia mandola anom biam mandaꞌ waf awafii mandaꞌ wali. Amom mandola Jisas nail laꞌafen, eaꞌ mandola amom biam mail waꞌowaꞌol. ");
INSERT INTO aoj_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Eaꞌ anis amam nematawa safiꞌi kilikilaꞌ sagaili esis sandaꞌ salamala anen, sapapati balagah saꞌias naꞌamba ");
INSERT INTO aoj_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","saꞌi, “Awi, inaꞌ aman nigugulata ipat anamba Godi, ma netanima negasaꞌmana nimaguf wanifi, deiꞌ netopalopa inaꞌ. Iꞌi inaꞌ nogama Godiai, nendatagwah nisilaꞌi.” ");
INSERT INTO aoj_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Eaꞌ amom pris dembami maloma amom dembami magawalipasa muꞌuli Godi maloma amom agufumi esis Judai wapani, hiami malomam mandaꞌana findiwana maꞌi, ");
INSERT INTO aoj_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Anen nandatopalopa anis daindaias apaꞌ deiꞌ ina natopalopa anen, owaꞌatin. Anen dembinai king esis Israeli. Eaꞌ daoꞌ deiꞌ nondatagwah lawag ilif nisilaꞌi ma apaꞌ motolona mogahapifana. ");
INSERT INTO aoj_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Anen nahapifa God naꞌias naꞌi, ‘Aeꞌ Nogama Godi.’ Eaꞌ daoꞌ, iꞌi God okom mimila anen ai, anen nondatopalopana.” ");
INSERT INTO aoj_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Eaꞌ amom amamba biam mandaꞌ wali sandolam magalumanai mandaꞌana findiwana siꞌi amom agufumi maliꞌ mandaꞌmanam. ");
INSERT INTO aoj_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Awin aꞌi owaꞌ nandasapaꞌ akot luꞌunai aꞌ nataga dogw naofana itap hiagoma esis Judai akotigin nape nafeꞌ nafeꞌ nataga awin nandambema nagape gani 3 klok wambomota. Eaꞌ nataga negalaꞌ wapani. ");
INSERT INTO aoj_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Felefeleꞌma awin nandambema 3 klok, Jisas noga naꞌi mehip naꞌi, “Eloi, Eloi, lema sabaktani?” Apaꞌ mambemef maꞌias naꞌamba maꞌi, “God aeꞌinai, God aeꞌinai, deiꞌ maina inaꞌ nagakwahowe?” ");
INSERT INTO aoj_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Eaꞌ anis epes salutu felefeleꞌ sameꞌ anen naꞌias naꞌamba saꞌi, “Anen nofala anona profet Elaija.” ");
INSERT INTO aoj_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Eaꞌ anona aman nasagih nafeꞌ kwafalis nofaꞌ anom mosong magape naohi nalam mowala embel wainimbel numbutimbeli nagiam nasapaꞌam anagol bagol nandowam mafeꞌma Jisas nogaꞌ embel. ");
INSERT INTO aoj_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Owaꞌ anis salutu saꞌi, “Ataꞌ otaꞌ kwahowana, ma ataꞌ muti atiasi Elaija nifiꞌi notagwahona, aꞌa owaꞌ?” ");
INSERT INTO aoj_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Eaꞌ Jisas nandaꞌas goꞌala mehip aꞌowaꞌ wapani eaꞌ ambal ananili aꞌ landahiꞌ lafeꞌana. ");
INSERT INTO aoj_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Owaꞌ anef lowaf luꞌwafi siꞌi utai fegetaol ipat Godi luꞌunai nomoni, palalaf gani ilif fewala itap fataga biafif. Eaꞌ itap bol atin nape otamba luꞌwami pepeꞌam. ");
INSERT INTO aoj_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Eaꞌ anamba sagawa epes sagagaꞌima matmat mandawisiꞌ eaꞌ amam nematawa hiasi Godi fowaꞌ sagagaꞌi sosafel wapani. ");
INSERT INTO aoj_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Esis sokwaha matmat afamba Jisas nogosafel wapani, sofeꞌ sogawis Jerusalem, wambel sandandepambela sondaꞌ maol Godima. Eaꞌ epes hiasi asatilis. ");
INSERT INTO aoj_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Kepten anamba dembinai nugumafi soldia hiamii naloma amom soldia mape mugumafi Jisasi mati hiahaom amamba. Nogota atamba mati hiahaom mataga itap bol atin nape, ombal maham aꞌowaꞌ maꞌi, “Endilisi atis, aman anamba Nogamana Godi.” ");
INSERT INTO aoj_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Nematawa hiawai wagagiꞌma Jisasi wakwaha itap apamba luꞌupa Galili wafiꞌi wagatopalopanai awo walutuwi laogon watologon. ");
INSERT INTO aoj_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Anoꞌw Maria Makdalaiꞌwi. Anoꞌw agol atogol Maria, kogola Jemsi Josepi. Eaꞌ anoꞌw kogola amam biam Sebedi nogaopana. ");
INSERT INTO aoj_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Aꞌi owaꞌ wambomota anona aman Arimateainai hiahaom hiamunai agilinama Josep anen alipunai nagaila Jisasi aꞌ nafiꞌi. ");
INSERT INTO aoj_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Nafeꞌma Pailat nahaliꞌana ma nofaꞌi alop Jisasi nogawana. Eaꞌ Pailat naꞌipa amoma mogasoꞌana. ");
INSERT INTO aoj_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Josep nofaꞌap eaꞌ nandaꞌ lowaf namifi afitifi. ");
INSERT INTO aoj_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Eaꞌ naolaꞌana nawis matmat ananitai dambaitai, fowaꞌ nagwasana nagawis anom otam luꞌunai. Eaꞌ deiꞌ nambema anona otam luꞌunai nafeꞌ nowalo uta matmat atamba. Anen nandaꞌas naꞌamba ma main, aꞌ nafeꞌ. ");
INSERT INTO aoj_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Eaꞌ Maria Makdalaiꞌwi kwaloma anoꞌw awo agol atogol, awo biawa wape waꞌol felefeleꞌ watologon. ");
INSERT INTO aoj_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Ama aꞌi owaꞌ wafilu nemaf sagandomba hiahawes gwaꞌaisi maisafi afamba fafeꞌma eaꞌ, amom pris dembami maloma amom Farisi dembami mafeꞌ malagama Pailat. ");
INSERT INTO aoj_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Eaꞌ maꞌipana maꞌi, “Dembinai, afaꞌ aꞌ ukup papoma anif basef aman anamba nagambasoꞌami nagaꞌiefi fowaꞌ anen ataꞌ nagape. Anen nagaꞌias naꞌamba naꞌi, ‘Nimaguf wanif aꞌ fefeꞌma hiꞌilif owaꞌ, aeꞌ aꞌ itanima esafel wapani.’ ");
INSERT INTO aoj_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Isimba atis deiꞌ inaꞌ aꞌ niꞌipam mumafi matmat atamba andeandeꞌma nimaguf wanif ataꞌ ahiꞌilif. Naꞌamba amom alipumi ananimi aꞌ mifiꞌi mokwalopana aꞌ mofaꞌana mefeꞌ miꞌipa esis amam nematawa miꞌi, ‘Anen notanima nosafel matmat wapani.’ Eaꞌ basoꞌam anamba deiꞌinai aꞌ luꞌuna nikilaꞌ nagaliꞌi.” ");
INSERT INTO aoj_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Eaꞌ Pailat naꞌipam naꞌi, “Ipaꞌ peꞌwa anom soldia pefeꞌ pewalo uta matmat atamba sisihita, siꞌi ukup ipeꞌipi pagaꞌias dondoꞌma gawa ipeꞌini.” ");
INSERT INTO aoj_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Eaꞌ amom mafeꞌ mowalowa matmat sisihita eaꞌ mandaꞌima uta masahoꞌmata mandaꞌ anin ametal banagani ma epes ina a suwalin suwis. Eaꞌ maꞌipa anom soldia mape mumafiagon. ");
INSERT INTO aoj_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Nemaf afamba esis Juda sagapoma nomaꞌwafi sabat fafeꞌma hiꞌalaf, eaꞌ sande nemaf fagaliꞌma wiki, kuhumbita atota felefeleꞌma awin nigatafi, nematawa awamba biawa Maria Makdalaiꞌwi kwaloma anoꞌw agol atogol wafiꞌi ma ugati matmat. ");
INSERT INTO aoj_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Eaꞌ kwafalis atis imauna luꞌunai nasol mehip. Eaꞌ anona ensel Dembinaii nisilaꞌi gani heven, aꞌ nafeꞌ nelefata owap apamba pegewalo utai nafeꞌ naꞌoh waꞌol a tol natomana. ");
INSERT INTO aoj_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Amaga ananigai a gogalaꞌ aꞌowaꞌ siꞌi otaga peleꞌalama nogogalaꞌ luꞌwaguf maim ananimi afitim aꞌowaꞌ siꞌi ais mandati. ");
INSERT INTO aoj_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Eaꞌ amam amamba soldia mugumafi matmati aꞌ ombal maham kwapeteꞌ aꞌowaꞌ ambombol atin maꞌoh itap siꞌi sagagaꞌi. ");
INSERT INTO aoj_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Owaꞌ ensel anamba naꞌipa awo biawa naꞌi, “Ipaꞌ bipa ina ombal mehepa, owaꞌi. Aeꞌ egawa ipaꞌ pafiꞌi paꞌi pelaoma Jisas, aman anamba esis sagandolana lawag usiꞌigai tiꞌwanaegai. ");
INSERT INTO aoj_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Anen ina ataꞌ nape naꞌa, owaꞌ. Anen aꞌ notanima nosafel eaꞌ siꞌi fowaꞌ nagaꞌipipa! Ipaꞌ fiꞌi ma ataꞌ piti naꞌa nagaꞌoma. Deiꞌ aꞌ wafigin nape. ");
INSERT INTO aoj_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Deiꞌ ipaꞌ foꞌo kwafalis piꞌipa alipumi ananimi piꞌi, ‘Anen nosafel wapani eaꞌ. Pemeꞌ. Anen aꞌ naliꞌipa nafeꞌ itap apamba Galili. Ipaꞌ foꞌo petolonago ganimba.’ Basef aeꞌafi eaꞌ ifimba.” ");
INSERT INTO aoj_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Eaꞌ awo ombal magahawai deiꞌ eaꞌ sonahawa wapani, kwafalis atis wakwaha matmat wasagih wafeꞌma ugaꞌipa amom alipumi ananimi. ");
INSERT INTO aoj_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Owaꞌ Jisas nati awo ufiaꞌw nandaꞌmawa gude naꞌi, “Nemaf buꞌwafi endilisi.” Eaꞌ awo wafeꞌ felefeleꞌma anen wahapila boꞌwagah ananigahi ma ondaꞌ lotuma anen. ");
INSERT INTO aoj_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Owaꞌ Jisas naꞌipawa naꞌi, “Ipaꞌ ina aꞌ ombal mehepa, owaꞌi. Ipaꞌ bipa pefeꞌ piꞌipa amom owape aeꞌami mofoꞌo Galili. Bola motolowe ganimba.” ");
INSERT INTO aoj_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Nematawa awamba biawa ataꞌ wafeꞌ atin, anom soldia mugumafi matmati aꞌ mafeꞌ mawis taun maꞌipa amom pris dembami ma hiahaom amamba magatagai. ");
INSERT INTO aoj_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Eaꞌ pris amamba maloma agufumi esis Judai maꞌi anif basef mandameꞌmaef eaꞌ masoꞌama anin moni hiani nafeꞌma soldia anamba ");
INSERT INTO aoj_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","maꞌipam maꞌi, “Ipaꞌ pigaꞌias naꞌamba piꞌi, ‘Owamb afaꞌ wagaꞌihi, amom alipumi ananimi mafiꞌi makwalopana mofaꞌana.’ ");
INSERT INTO aoj_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Ama gavman dembinai nemeꞌ basefana, daoꞌ afaꞌ aꞌ ondaꞌ okom ananimi awanema ipaꞌ basef akepa.” ");
INSERT INTO aoj_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Eaꞌ amom soldia mofaꞌ moni inimba mameꞌ basef amamifi aꞌ magiꞌmif. Eaꞌ basef ifimba ma hiahawes isimba eaꞌ fafeꞌagon hiꞌalagon walemb esis Judai, eaꞌ ataꞌ saꞌiif atin fafiꞌi fatagama deiꞌ saꞌif atapif. ");
INSERT INTO aoj_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Eaꞌ amom alipumi 11-pelaim mafeꞌ Galili mataga halafuta atamba Jisas naliꞌ naꞌipam mogafeꞌma. ");
INSERT INTO aoj_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Eaꞌ mati Jisas masaꞌma agol ananigili manifelona. Apaꞌ anom aꞌ nomonas bimbiafis sapaom. ");
INSERT INTO aoj_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Eaꞌ Jisas nafiꞌi felefeleꞌma amom naꞌipam naꞌi, “God aꞌ naseꞌepam eaꞌ banagami ilifami itapami. ");
INSERT INTO aoj_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Naꞌamba deiꞌ ipaꞌ pefeꞌ piwalipa amam nematawa ma basef fasifi aeꞌafi, pendaꞌas sotaga alipisi ma sigaila basef aeꞌafi datima eaꞌ pipisiꞌas embela agol Ahamai goloma aeꞌagili foloma Ambal buꞌunai Ananili. ");
INSERT INTO aoj_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Eaꞌ piwalipasa sogagiꞌma basef buꞌwafi hiafi aeꞌafi agawalipipaef dindinipi. Endilisi atis, aeꞌ ape alomepa ma nimaguf hiafi danda, a pefeꞌ pefeꞌ ma nemaf akutaifi nogota hiꞌigalata.” Basef eaꞌ maꞌuf. ");
INSERT INTO aoj_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","2","Basef ifimba buꞌwafima Jisas Krais, Nogamana Godi. Basef ifimba fandasefel fataga siꞌi anona profet fowaꞌinai Aisaia nandaꞌef fagail buki. Aisaia naꞌi basef ifimba naꞌamba, God naꞌi, “Inaꞌ nemeꞌ. Owagama aeꞌ esapaꞌ anona aman nogofaꞌo basef aeꞌafii niliꞌ nofeꞌma inaꞌ nondondomba ufiaꞌw ineꞌikwi. ");
INSERT INTO aoj_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Anep itap wafigima fataupigima malogol anona amani, anaf niꞌi basef naꞌamba niꞌi, ‘Ipaꞌ pendondomba ufiaꞌw Dembinaii kondafeꞌ usiꞌiꞌw. Ufiawa ananiwai kondafeꞌ hililiꞌi.’” ");
INSERT INTO aoj_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Jon nagapisiꞌas embeli nafeꞌ anagon wafigima fataupigima nawalapa basefa amam nematawa hiasi naꞌipas naꞌi, “Ipaꞌ pewaꞌ alafugaha waf awafi pembema nelelemba God pefaꞌ baptaisa God nogakwaha waf awafi ipeꞌifi okom mogasoꞌanaf. ");
INSERT INTO aoj_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Eaꞌ esis hiasi sagape anep itap luꞌupa Judiai saloma amam nematawa hiasi sagape Jerusalami safiꞌmai Jon saꞌi semeꞌ basef ananifi. Eaꞌ sawalapa waf awafi esis sandaꞌafi, Jon napisiꞌas walemb Jordan. ");
INSERT INTO aoj_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Anen nala anom klos sandaꞌ auf anom mafis luꞌwami kameli sandaꞌam, eaꞌ nowahoꞌ let sandaꞌ agwahup mafisina sandaꞌanai, nagundisam. Gwaꞌaisi nagaꞌasi naꞌ gwamuꞌwis saloma aupimbel alupumi. ");
INSERT INTO aoj_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Anen nawalapa basef naꞌi, “Anona aman atiasi nigiꞌ nugafiꞌii, anan banagonai nikilaꞌ aeꞌ. Aeꞌ ina aman buꞌuwai ma egatagwaha mandalefa su ananimi, owaꞌ. ");
INSERT INTO aoj_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Aeꞌ ipisiꞌipa embel atembal, apaꞌ anen owaꞌ. Anen atiasi neseꞌepa Ambal buꞌunai Godi nogape opalef ipeꞌilifi nomon.” ");
INSERT INTO aoj_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Afamba Jisas nakwaha Nasaret anep itap luꞌupa Galili aꞌ nafiꞌi. Jon napisiꞌana walemb Jordan. ");
INSERT INTO aoj_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Jisas nakwaha embel walemb nandagiai atin, owaꞌ nati heven nandawisiꞌ alihina, ma anen, nati Ambal buꞌunai Godi nafiꞌmai anen siꞌi amil alamba apaꞌ magaꞌi maꞌunai nufiaꞌ nisilaꞌmai anen. ");
INSERT INTO aoj_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Eaꞌ anagol malogol gaꞌi gatagai heven gaꞌi anif basef gaꞌi, “Inaꞌ Nogame aeꞌinai. Aeꞌ okom mohafel maimailina aꞌowaꞌ. Eaꞌ okom aeꞌami boꞌoma inaꞌ.” ");
INSERT INTO aoj_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","13","Eaꞌ Ambal buꞌunai Godi nofaꞌ Jisas nafeꞌ anagon fataupigima mafis atom alupumi magalutuma nimaguf 40-pelaif, awin siꞌini duꞌwanini. Owaꞌ Satan nafiꞌi nagwambana. Ma eaꞌ, amom ensel mafiꞌi mumafi Jisas matopalopana. ");
INSERT INTO aoj_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Afamba amom mandaꞌ Jon nandaꞌ kalabus, Jisas aꞌ nafeꞌ itap luꞌupa Galili nandaꞌ maol nawalapa basef buꞌwafi Godi naꞌipasef ");
INSERT INTO aoj_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","naꞌi, “Nemaf afamba felefeleꞌ afetaga ma epes hiasi sogawis nomona maol Godi nope Dembinai nugumafias. Naꞌamba ipaꞌ deiꞌ pendewaꞌ alafugaha waf awafi pembema nelelemb pihapifa basef ifimba buꞌwafi.” ");
INSERT INTO aoj_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Jisas naila akata nafeꞌ atin dumb luꞌwambi Galili, nati amam biam Saimon naloma owamana Andru. Amom mala anembeh mowafa agof mandaꞌ bisnis. ");
INSERT INTO aoj_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Eaꞌ Jisas natolom naꞌipam naꞌi, “Ipaꞌ pifiꞌi pihapila basef aeꞌafi pila aeꞌ. Fowaꞌ ipaꞌ pewafa agof, apaꞌ deiꞌ ihimbaꞌmepa pefeꞌ pigaꞌipa anis epes pefaꞌasi sogaila aeꞌ.” ");
INSERT INTO aoj_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Eaꞌ mameꞌana makwaha anembeh haꞌoh, amom mailana aꞌ mafeꞌ. ");
INSERT INTO aoj_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Eaꞌ nindikiꞌah nafoꞌo felefeleꞌ akata nati Jems naloma owamana Jon, Sebedi nogaopana. Amom biam matoma bot mape mosambala anembeh amamimbihi. ");
INSERT INTO aoj_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Owaꞌ Jisas natolom nofalam kwafalis mameꞌana. Eaꞌ mohafel kwafalis makwaha ahamam naloma anom mandaꞌ maola anini mape bot, amom biam maila Jisas mafeꞌ. ");
INSERT INTO aoj_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Jisas naloma alipumi ananimi Jemsi Jon, Saimoni Andru mafeꞌ Kaperneam mape. Nemaf afamba esis Juda sagapoma nomaꞌwafi sabat, Jisas naoꞌwam mafeꞌ mawis ipat Juda sandakolasatai eaꞌ naꞌipasa basef amam nematawa. ");
INSERT INTO aoj_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Esis sameꞌ basef ananifi eaꞌ gogolalasis kwapeteꞌ endilisi. Anen ina nawalipas siꞌi amam falafumi magaꞌipas, owaꞌ. Anen naꞌipas dindinip siꞌi anona agilinai nagaꞌipas. Amom magawalipasa muꞌuli Godi ina mawalipas naꞌamba siꞌi anen, owaꞌ. ");
INSERT INTO aoj_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Afamba anona aman nape nalomas ipat atamba, ambal aunai napaona eaꞌ kwafalis atin ambal anamba noga naꞌi mehip naꞌi, ");
INSERT INTO aoj_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“O Jisas inaꞌ Nasaretinai, inaꞌ nafiꞌi naꞌi nendaꞌ maina apaꞌ? Nafiꞌi ma negahambombagapa? Aeꞌ egawena inaꞌ aman buꞌunai hililiꞌi Godi.” ");
INSERT INTO aoj_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Eaꞌ Jisas ninifalom naꞌi, “Inaꞌ ambalip awinai, sopama malogol kwahowa aman anamba foꞌo.” ");
INSERT INTO aoj_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Eaꞌ ambal anamba aunai nakotoꞌ anen kwapeteꞌ nandaꞌam goꞌala mehip nakwahona nawisi nafeꞌ. ");
INSERT INTO aoj_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Eaꞌ amam nematawa hiasi gogolalasis sandakotoꞌma eaꞌ sandaꞌipama saꞌi, “Amamba main daꞌim? Ifimba anif basef dambaifi? Anen natofa ambagof awami naꞌipam siꞌi anona aman banagonai. Hiahaom amamba hiami maloma ambagof awami wapani mameꞌ basefana makwaha epes mafaꞌ mafeꞌ.” ");
INSERT INTO aoj_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Eaꞌ basef ifimba ma maol Jisas nandaꞌani fafeꞌagon hiꞌalagon walemb hiagoma bagape nomona itap apamba luꞌupa Galili. ");
INSERT INTO aoj_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Jisas naloma alipumi biamibiam ananimi mosafel makwaha ipat Juda sandakolasatai eaꞌ usiꞌim mafeꞌ wambel Saimoni Andrui eaꞌ mawis ipat amamutai. Jemsi Jon wapani mafeꞌ malomam. ");
INSERT INTO aoj_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Eaꞌ esis saꞌipa Jisasa Saimon nandagiꞌmoꞌwi awasiꞌw kwaꞌoh, alop akwaꞌupi nifip. ");
INSERT INTO aoj_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Eaꞌ nafeꞌma akoꞌw nahapila lagol akwaꞌugili nasaꞌmaꞌw. Eaꞌ aowas inimba nakwahoꞌw nafeꞌ amboꞌokw, kwandaꞌmasas gwaꞌaisi esis. ");
INSERT INTO aoj_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Aꞌi owaꞌ wambomota awin newala nasoꞌ, esis sofaꞌai isimba aowas nandaꞌasi saloma anis ambagof awami magapaisi safiꞌmai Jisas. ");
INSERT INTO aoj_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Eaꞌ esis hiasi sagape taun inimbai safiꞌi salutu felefeleꞌma uta ipat siliꞌak. ");
INSERT INTO aoj_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Eaꞌ Jisas nandaꞌ amam nematawa hiasi aowas naninani nandaꞌasi boꞌwes, natofamasa anom ambagof awami magapaisi eaꞌ sataga boꞌwes. Ambagof awami mogawa Jisas anen nogamana Godi. Naꞌamba nasopama malogof ambagof amambai afasopam beꞌ mape. ");
INSERT INTO aoj_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Wafilu kuhimbita atota akot ataꞌ tail, Jisas nosafel nakwaha ipat atamba nagapoma. Anen atona nosafel nafeꞌ anamba wafigima eaꞌ nape nandaꞌ betena God. ");
INSERT INTO aoj_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Saimon naloma anom alipumi ananimi mosafel matimana owaꞌ, eaꞌ molaomana magiꞌmana mafeꞌ. ");
INSERT INTO aoj_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Molaomana mafeꞌma matolona maꞌipana maꞌi, “Epes hiasi solaomena.” ");
INSERT INTO aoj_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Jisas nagwamam naꞌipam naꞌi, “Ataꞌ diamaso, afaꞌ ataꞌ ofeꞌ analemb walemb daialemb hiagoma bagape felefeleꞌi. Aeꞌ ataꞌ iꞌipasa basef buꞌwafi esis. Maol inimba atin aeꞌ deiꞌ afiꞌi.” ");
INSERT INTO aoj_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Eaꞌ nasoꞌasa basef nafeꞌagon hiꞌalagon walemb hiagoma agol luꞌwagoma Galili, nasoꞌasa basef buꞌwafi nomon ifagw Juda sandakolasugwi natofamas ambagof awami magape anis epesi mandahiꞌ mawisi mafeꞌ. ");
INSERT INTO aoj_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Owaꞌ anona aman aowas aunai nandaꞌ alop ananipi pagambuꞌwi, nafiꞌi felefeleꞌma Jisas nindiwa nembawa notawa naꞌipana dindinip naꞌi, “Iꞌi inaꞌ niꞌi ahoꞌ netopalope ma egataga boꞌowe.” ");
INSERT INTO aoj_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Eaꞌ Jisas nati anen uwahipina nando lagola nasagol anen naꞌi, “Aeꞌ aꞌi ahoꞌma inaꞌ negataga boꞌwena.” ");
INSERT INTO aoj_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Eaꞌ deiꞌ atef aowas anamba nandaꞌ alop pagambuꞌwi nakwahona eaꞌ boꞌona. ");
INSERT INTO aoj_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Jisas nasapaꞌana kwafalis naꞌipana dindinip ");
INSERT INTO aoj_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","naꞌi, “Inaꞌ aꞌ nefeꞌ niꞌipa anin epen niꞌi aeꞌ andaꞌena boꞌwena, owaꞌi. Inaꞌ foꞌo nihimbaꞌma alop ineꞌipi ma aman anamba pris. Eaꞌ neseꞌana hiahaom amamba anen nondolalima God eaꞌ inaꞌ ninifelona ma nagataga boꞌwena siꞌi muꞌuli anan nagasoꞌ Mosesani nagaꞌi. Ama amam nematawa hiasi sitilina sogogawa aowas ineꞌini ahiꞌalan.” ");
INSERT INTO aoj_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Owaꞌ owaꞌatin. Aman anamba naꞌipasam mafeꞌagon hiꞌalagon amam nematawa hiasi sogawa amamba ma anen nagataga boꞌona. Eaꞌ Jisas ina nafeꞌ nawis anambel wambel ma naep hiasii, owaꞌ. Naꞌamba hiasi sifiꞌi sososopamana. Eaꞌ ina nawis anambel wambel luꞌwambili, owaꞌ. Atapina nape anamba wafigima atogon. Bola esis amam nematawa sagape ganiganii safiꞌmai anen. ");
INSERT INTO aoj_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Anif nimaguf fafeꞌma main, Jisas notanima nafeꞌ Kaperneam. Eaꞌ esis sameꞌ basefa anen a nafiꞌi nape ipat. ");
INSERT INTO aoj_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Amam nematawa hiasi sandakolas ipat atamba nagapautai asiꞌita dogw. Naꞌamba uta owaꞌ anagon nogal kwasakwasala ma sofeꞌ sogawisa. Eaꞌ nawalipasa basef ifimba buꞌwafi. ");
INSERT INTO aoj_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Owaꞌ anom amam biamibiam mandaꞌ belita malai aman anamba lagufi boꞌwagah sandahapimanai mofaꞌana maꞌi mofeꞌma Jisas. ");
INSERT INTO aoj_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Owaꞌ ipat asiꞌitama amam nematawa hiasi salutu siliꞌak, eaꞌ ina anagona mofaꞌana muwis mogafeꞌ felefeleꞌma Jisas, owaꞌatin. Eaꞌ malota ipat ilif andeꞌetama mapisila bogwan ilif mapa belita malaꞌana nowalai nomon Jisas nagalutuma. ");
INSERT INTO aoj_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Nogota atamba Jisas nati amom aꞌ nogawa amom mahapifana maꞌi anen banagonai ma nogatopalopa aman anamba aowas nandaꞌanai. Eaꞌ naꞌipa aman anamba naꞌi, “Inaꞌ epen aeꞌinai. Waf awafi inaꞌ nandaꞌafi aeꞌ akwahomenaf hiꞌalaf.” ");
INSERT INTO aoj_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Eaꞌ anom dembami magawalipasa muꞌuli Godi mape mameꞌana. Nelelemb amamilimbi awalemba basef ananifi. Naꞌamba amom nomonas salasafeꞌ maꞌi, ");
INSERT INTO aoj_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Deiꞌ maina Jisas nagaꞌias naꞌamba? Anen nandaꞌ God findiwana. Owaꞌ atina anona aman laꞌifinaima nogakwaha waf awafia. Maol inimba God atona nandaꞌani.” ");
INSERT INTO aoj_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Jisas nogawa nomonas isimbai amamisi eaꞌ naꞌipam naꞌi, “Deiꞌ maina nomonas ipeꞌisi sagape naꞌamba?” ");
INSERT INTO aoj_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Deiꞌ hiahaom maim ipaꞌ paꞌi ahifima aeꞌ? Aeꞌ banagiwai ma iꞌipa aowas nandaꞌanai igaꞌi, ‘Aeꞌ ekwahomana waf awafi anen nandaꞌafi, aꞌa iꞌipana igaꞌi nosaꞌma alahis ananisi nosafel nogafeꞌ. Basef ifimba ma nogasaꞌma alahis ananisi paꞌi amamba ahifima aeꞌ. ");
INSERT INTO aoj_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Aeꞌ aꞌi ipaꞌ pegawa aeꞌ ataga epen egefaꞌ alop epesi, laꞌifiwai ma egakwaha waf awafi hiafi amam nematawa sagape itapi sandaꞌafi. Aeꞌ aꞌi ihimbaꞌmepa aeꞌ laꞌifiwai ma endaꞌ hiahaom amamba.” ");
INSERT INTO aoj_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","Eaꞌ naꞌipana naꞌi, “Aeꞌ aꞌipina, inaꞌ safel saꞌma alahis ineꞌisi foꞌo ipat ineꞌitai.” ");
INSERT INTO aoj_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Eaꞌ esis salutu satolona sati anen kwafalis nosafel nasaꞌma alahis nagaꞌihisi aꞌ nafeꞌ. Eaꞌ amam nematawa hiasi gogolalasis kwapeteꞌas, safela agol Godi luꞌwagol saꞌi, “Fowaꞌ apaꞌ ina mati anom siꞌi naꞌamba, owaꞌatin.” ");
INSERT INTO aoj_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Jisas notanima naila akata nafeꞌ dumb luꞌwambi agilimba Galilii. Amam nematawa hiasi safiꞌmai anen naꞌipasa basef buꞌwafi. ");
INSERT INTO aoj_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Jisas nosafel nafeꞌ owaꞌ, nati anona aman Livai, Alfius nogamana nape ipat sogofaꞌ takisa. Aman anamba nogofaꞌasa takisa amam nematawa hiasii. Jisas nofalana naꞌi, “Inaꞌ fiꞌi nila aeꞌ.’ Eaꞌ nosafel nafeꞌ nailana. ");
INSERT INTO aoj_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Jisas naloma alipumi ananimi maꞌ gwaꞌaisi ipat Livaii maloma amam hiami awami. Anom mogofaꞌ takisi, anom mandaꞌ waf awafii maloma Jisas maꞌ gwaꞌaisi. Amam amambai ina mahapifa Jisas, owaꞌ. Mailana dowaf. ");
INSERT INTO aoj_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Eaꞌ amom dembami magawalipasa muꞌuli Godi amom Farisi mati Jisas naꞌ gwaꞌaisi naloma amam awami maloma amam amamba mogofaꞌ takisi. Eaꞌ mahaliꞌ alipumi ananimi maꞌi, “Deiꞌ maina dembinai tisa nape naloma amom mogofaꞌ takisi maloma amam amamba mandaꞌ waf awafii magaꞌ gwaꞌaisi atogon?” ");
INSERT INTO aoj_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Eaꞌ Jisas nameꞌam naꞌamba naꞌipam naꞌi, “Isimba aowas akasi ina sofeꞌma dokta, owaꞌ. Esis buꞌwasi. Apaꞌ isimba aowas nandaꞌasi atis daoꞌ, safeꞌma dokta. Aeꞌ ina afiꞌi ma egefala epes isimba buꞌwasi sagape hililiꞌi, owaꞌ. Aeꞌ afiꞌi ma egefala isimba sandaꞌ waf awafii.” ");
INSERT INTO aoj_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Anef nemaf amam amamba alipumi Joni maloma anom dembami Farisi mololama gwaꞌaisi ma mondabeten buꞌwani. Eaꞌ anom amam daiam mafiꞌi maꞌipa Jisas maꞌi, “Deiꞌ maina amom alipumi Joni maloma amom Farisi mololama gwaꞌaisi ma mandabeten, apaꞌ ineꞌimi owaꞌ mololama gwaꞌaisia?” ");
INSERT INTO aoj_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Eaꞌ Jisas nagwamam naꞌi basef waminif atin naꞌi, “Iꞌi anis sondaꞌ anis gwaꞌaisi luꞌwasi ma anis aman nemataꞌw bias sondasoꞌamai, ipaꞌ paꞌi esis alipisi atiasi sololama gwaꞌaisi isimba? Owaꞌatin endilisi. Nemaf afamba esis bias sondasoꞌama, alipisi asasisi sonohas seaꞌ gwaꞌaisi solomas. ");
INSERT INTO aoj_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Apaꞌ anafa anis daias sofaꞌ aman anamba nagasoꞌ nemataꞌwi nogafeꞌ laogon daoꞌ, esis sololama gwaꞌaisi, apaꞌ deiꞌ ataꞌ owaꞌatin.” ");
INSERT INTO aoj_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Eaꞌ Jisas nandaꞌ anif basef waminif atina luwaguf naꞌi, “Ina andeandeꞌma pegatopaꞌ lowaf namifi pesambalef fegaloma anef lowaf apifi, owaꞌ. Iꞌi pendaꞌas naꞌamba, atiasi lowaf afamba namifi fendatagwah fehapeꞌ apifi bolotaf aꞌ notaga luꞌuna.” ");
INSERT INTO aoj_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Eaꞌ naꞌi anif wapani naꞌi, “Apaꞌ ina anin epen nakoloꞌwa embel wain dambaini bewala agwahup apinai memeina siꞌi botol, owaꞌatin. Iꞌi anin nendaꞌam naꞌamba, embel wain netef hian, nohapeꞌ agwahup anamba pepeꞌetana wain koloꞌolam awasim hiꞌilam. Naꞌambai owaꞌ. Anin nakoloꞌan agwahup dambainai atona.” ");
INSERT INTO aoj_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Anef nemaf Juda sagapoma nomaꞌwafi saꞌi sabat, Jisas nafeꞌ nawis anof aof sagawa witafi siꞌi raisi. Eaꞌ alipumi ananimi mafeꞌ malomana mosaga anom wit magaufi maꞌam. ");
INSERT INTO aoj_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Eaꞌ anom dembami Farisi maꞌipa Jisas maꞌi, “Nemeꞌ. Alipumi ineꞌimi mandaꞌas naꞌamba ma main? Amom mosambala muꞌuli ma nemaf afamba magapoma nomaꞌwafi sabat.” ");
INSERT INTO aoj_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Eaꞌ Jisas naꞌipa amom Farisi naꞌi, “Ipaꞌ pegawa basef fagape Baibeli ma waf fowaꞌ dembinai king Devit nandaꞌafi. Afamba Devit naloma alipumi ananimi gwaꞌaisi akam nolom magaham. Ipaꞌ pegawa basef ifimba eaꞌ. ");
INSERT INTO aoj_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Nemaf afamba Abiatar nape dembinai pris nagaliꞌma amom prisi, Devit nolom mahana nawis ipat Godi naꞌ bret atamba mondolalima Godatai. Muꞌuli apeꞌini luꞌwani naꞌi amom pris atom meaꞌata. Anis daias owaꞌi. Apaꞌ Devit ina nagiꞌma muꞌuli inimba, owaꞌ. Anen naꞌata nandaꞌata nasoꞌ alipumi ananimi maꞌata atin.” ");
INSERT INTO aoj_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Eaꞌ Jisas naꞌipam wapani naꞌi, “God naliꞌ nandaꞌ epes eaꞌ nagiꞌ naꞌipasa nemaf sagapoma nomaꞌwafi sabata nogatopalopas. Ina nandaꞌ epesa sogaila basefa sabat, owaꞌ. Naꞌamba alipumi aeꞌami mogosaga witi ina mandaꞌ waf awafi, owaꞌ. ");
INSERT INTO aoj_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Aeꞌ atowe ataga epen egefaꞌ alop epesi ape dembiwai ma hiahaom hiami. Eaꞌ ape dembiwai ma nemaf afamba sabata igaꞌipipa maol main andeandeꞌma pigaila basef pendaꞌan nemaf afamba.” ");
INSERT INTO aoj_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Anef nemaf Jisas nafeꞌ nawis ipat esis Juda sandakolasatai, nati anona aman lagol awagilinai nape. ");
INSERT INTO aoj_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Eaꞌ anis salaꞌ solaoma basef kwamaifi ma sosapagana sondaꞌmana kot. Eaꞌ satolona naep paipailana ma siti nondaꞌ aman anamba boꞌona nemaf afamba sagapoma nomaꞌwafi aꞌa owaꞌ? ");
INSERT INTO aoj_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Eaꞌ anen naꞌipa aman anamba lagol awagilinai naꞌi, “Inaꞌ lutu laꞌafena naep hiasii.” ");
INSERT INTO aoj_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Eaꞌ Jisas nahaliꞌas naꞌi “Muꞌuli luꞌwani apeꞌini naꞌias naꞌimama? Apaꞌ mondaꞌ waf fasifi nemaf afamba sagapoma nomaꞌwafi aꞌa mondaꞌ waf awafi? Apaꞌ mondaꞌasa motopalopa esis sogape andeandeꞌ aꞌa mohambombagas sogagaꞌ?” Owaꞌ esis ina saꞌi anif basef, owaꞌ. ");
INSERT INTO aoj_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Jisas nasaꞌma naep natilis tulif owaꞌ, nogawa esis opalef masoꞌ sandaiwaꞌma sogameꞌ basef. Naꞌamba okom ananimi wandafuma esis. Eaꞌ nati esis uwahipis, naꞌipa aman anamba lagol awagilinai naꞌi, “Dowa lagol ineꞌigili.” Eaꞌ nandowagol gataga boꞌwagol wapani. ");
INSERT INTO aoj_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Eaꞌ amom dembami Farisi mosafel mafeꞌ maloma anom amam miniꞌap Heroti, maꞌi basef mandameꞌmaefa moha Jisas nogagaꞌ. ");
INSERT INTO aoj_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Jisas naloma alipumi ananimi makwaha wambel ambalemba mafeꞌ dumb luꞌwambi Galili. Eaꞌ amam nematawa hiasi safiꞌi walemb hiagoma Galili safeꞌ sagiꞌmana. ");
INSERT INTO aoj_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Esis safiꞌi hiagoma. Anis safiꞌi walemb hiagoma Judia, anis safiꞌi Jerusalem, anis safiꞌi itap luꞌupa Idumea, eaꞌ anis sagape walemb Jordan gani waꞌili saloma anis sagafiꞌi walemb bielimbi Tairi Saidoni, esis hiasi safiꞌmai anen. Sameꞌ basefa hiahaom Jisas nandaꞌami, naꞌamba safiꞌmai anen. ");
INSERT INTO aoj_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Eaꞌ Jisas naꞌipa alipumi ananimi naꞌi, “Amam nematawa hiasi sape. Naꞌamba aꞌ sofafaꞌasowe. Anota bot tola tosasae ma ilita egatoma.” ");
INSERT INTO aoj_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Eaꞌ sogawa anen naliꞌ nandaꞌ epes hiasi aowas nandaꞌasi sagataga buꞌwasi. Eaꞌ isimba aowas nandaꞌasi sandaꞌ bambasiꞌma atin safeꞌma anen sahapilana ma sogataga boꞌwes. ");
INSERT INTO aoj_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Ambagof awami magape epesi mati anen mogawana, eaꞌ mowa maꞌoh felefeleꞌma anen opafunama, eaꞌ mofalana maꞌi, “Inaꞌ nogamana Godi.” Nogota mamahotama ma nemaf afamba atef magatolona mandaꞌmanam naꞌamba atin. ");
INSERT INTO aoj_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Eaꞌ naꞌipa ambagof awami dindinipa amom ina mowalapa anen miꞌipasana miꞌi anen nogamana Godi, owaꞌi. ");
INSERT INTO aoj_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Jisas nafeꞌ nondowasaꞌ halafuta, nofala amam amamba anen okom magaꞌiami mafiꞌmai anen. ");
INSERT INTO aoj_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Eaꞌ nandandepa amom 12-pelaima mope mogalomana atapima, nosapaꞌam mefeꞌ mogowalapa basef. ");
INSERT INTO aoj_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Naꞌipam nasoꞌama banagami ma mogatofa ambagof awami magape epesi. ");
INSERT INTO aoj_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Amom 12-pelaim nandandepami, agofuma amamba. Saimon agol waꞌagol Pita, ");
INSERT INTO aoj_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","eaꞌ Jems nogama Sebedi, naloma owamana Jon, nasoꞌama agof waꞌagof Boanesis. Agol agalemba kofagogola naꞌamba, nogaopa otaga diwagalai. ");
INSERT INTO aoj_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Eaꞌ Andru, Filip, Bartolomyu, Matyu, Tomas, a Jems nogama Alfiusi, a Tadiusi Saimon. Aman anamba Saimon anen miniꞌap Seloti. ");
INSERT INTO aoj_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Eaꞌ Judas Keriotinai aman anamba nafeꞌ nagawalapa Jisasa bousii. ");
INSERT INTO aoj_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Jisas nafeꞌ ipat eaꞌ esis hiasi safiꞌi wapani. Eaꞌ naloma alipumi ananimi ina ataꞌ maꞌ gwaꞌaisi, owaꞌ. ");
INSERT INTO aoj_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Esis wambota Jisasi sameꞌ basef ifimba ma anen naloma alipumi ina maꞌ gwaꞌaisi, safiꞌi saꞌi soꞌwana. Eaꞌ saꞌi, “Anen ambagof awami mandaꞌana deiꞌ nahaga nagaol.” ");
INSERT INTO aoj_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Anom dembami magawalipasa muꞌuli Godi mapani Jerusalem mulianai mambasoꞌam maꞌi, Jisas natofa ambagof awami ma banagami anona ambal aunai mamana agilinama Bielsebul. ");
INSERT INTO aoj_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Eaꞌ Jisas nofalai amom mafiꞌi malutu felefeleꞌma anen naꞌi anif basef waminif atina amom naꞌi, “Satan ina notofa anen atona, owaꞌatin. ");
INSERT INTO aoj_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Iꞌi anis analemb walemb hiagoma esis atis sondatopaꞌ biafisa sogapaꞌ, ina atiasi banages, owaꞌatin. Esis sandawal biafis aꞌ owaꞌ banagesa. ");
INSERT INTO aoj_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Iꞌi anis anota wambota sagape ipat atototai sondawal miniꞌap biafipa sogapaꞌ, esis eaꞌ sandatopaꞌ biafis, ina atiasi sope banages, aꞌ owaꞌatin. Eaꞌ sandawal biafis. ");
INSERT INTO aoj_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Iꞌi wambota Satani sondawal biafis sogapaꞌ atiasi wambota ananitai banages siꞌimama? Owaꞌatin. Satan wapani ina banagona, aꞌ owaꞌatin.” ");
INSERT INTO aoj_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“Anona aman ina banagona nefeꞌ nuwis ipat anona aman banagonai nagapautai dowaf nondaꞌ wala hiahaom ananimi, owaꞌ. Anen ataꞌ niliꞌ nombaloꞌana ma nowaꞌana sisihina daoꞌ, anen banagona nuwis nondaꞌ wal nogofaꞌi hiahaom magaꞌoh ipat aman anambai.” ");
INSERT INTO aoj_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","30","Amom magawalipasa muꞌuli Godii mambasoꞌam mandaꞌ findiwama Ambal buꞌunai Godi maꞌi, “Anona ambal aunai natopalopa Jisas nandaꞌ maol ananini.” Eaꞌ Jisas naꞌipam naꞌi, “Endilisi atis aeꞌ aꞌipipa, atiasi God nokwaha waf awafi fafifafi hiafi feloma basef findiwaifi hiafi amam nematawa sandaꞌafi hiꞌilaf. Apaꞌ epen ami nendaꞌ basef findiwaefa Ambal buꞌunai Godi, God atiasi owaꞌatin endilisi ma nogakwaha findiwa anamba aunai ma epen inimbaia, owaꞌatin. Findiwa aunai atapina nopain deiꞌ nefeꞌ anaf wapani, atapina nope.” ");
INSERT INTO aoj_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Afamba Jisas naloma hiasi sape salomana ipat nomon. Eaꞌ maꞌmana kwaloma owapana ananimi safiꞌi sataga salutu ipat andoꞌ. Nomon asiꞌigina epes. Eaꞌ salutu andoꞌ saꞌipa anis sawis saꞌipana saꞌi Jisas nuwisi andoꞌ nefeꞌma esis. ");
INSERT INTO aoj_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Eaꞌ isimba hiasi sape sagalomanai saꞌipana saꞌi, “Inaꞌ nemeꞌ, maꞌmena ineꞌikwi kwaloma owapena ineꞌimi salutu andoꞌ saꞌi solomena siꞌi.” ");
INSERT INTO aoj_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Eaꞌ nagwamasa basef naꞌipas naꞌamba naꞌi, “Maꞌmai owape aeꞌasi ami?” ");
INSERT INTO aoj_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Anen nati esis amam nematawa sape sagalipana naꞌipas naꞌi, “Piti maꞌmai kwaloma owape aeꞌasi isimba. ");
INSERT INTO aoj_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Epes mamahisa sigaila okom Godii ma sondaꞌ waf ananifii, isimba maꞌme owape hanitiame aeꞌasi.” ");
INSERT INTO aoj_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","3","Anef Jisas nasefela maol wapani nandaꞌan nawalipa amam nematawa hiasi felefeleꞌma dumb luꞌwambi Galili. Eaꞌ esis safiꞌi salipana sape. Eaꞌ nalota natoma anota bot tagala embel dumb ambambai, apaꞌ esis sape akata felefeleꞌma embel. Eaꞌ nasoꞌasa basef hiafi waminif atin naꞌipas naꞌamba naꞌi, “Ipaꞌ pemeꞌ! Anona aman nafeꞌ nowaha olemb witimb siꞌi raisi anof aof. ");
INSERT INTO aoj_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Anen nowahemb nafeꞌ, anemb bewa ufiaꞌw sagafeꞌma eaꞌ amiguf fufiaꞌ fafiꞌi faꞌamb. ");
INSERT INTO aoj_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","6","Anemb bewa itap otambaipa, itap ina luꞌup, owaꞌ. Kwasalaꞌup patoma ilif atogon owaꞌ pewala awina, eaꞌ batagai kwafalis apaꞌ masilimb ina bewafa bewala itap atep, owaꞌ. Aꞌi owaꞌ awin natafi ma owaf faluwi fahamb, otamba begaꞌefamb alimb. ");
INSERT INTO aoj_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Anemb bewala laꞌafena mandelef wandafumi mataga malomam maofana wit, eaꞌ ina malo andeandeꞌ mail mola gwaꞌaimi, owaꞌ. ");
INSERT INTO aoj_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Eaꞌ anemb bewa itap buꞌwapi, eaꞌ bataga luꞌumb, bail bela gwaꞌaisi. Anona nola 30-pelaimb, anona 60 apaꞌ anona nola 100-pelaimb.” ");
INSERT INTO aoj_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Eaꞌ Jisas naꞌipas naꞌi, “Ipaꞌ aligah hagagalipai ma pagameꞌ basef ifimbai, pemeꞌef andeandeꞌ ukup pendapomef.” ");
INSERT INTO aoj_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Aꞌi owaꞌ maina Jisas atona nape, alipumi 12-pelaim ananimi maloma anis sape sagalomanai safiꞌi sahaliꞌana ma basef ifimba waminif atini. ");
INSERT INTO aoj_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Eaꞌ nagwamama basef naꞌi, “God eaꞌ nihimbaꞌmepa basef kofagefa fape fandambahiꞌi ma epes sogawis nomona maol buꞌwani ananini nope Dembinai nugumafias. Deiꞌ God eaꞌ nihimbaꞌmepa basef ifimba kofagefa alihif. Ipaꞌ pameꞌef pegawef eaꞌ. Apaꞌ esis isimba sogolalama Godi, owaꞌatin. Esis sameꞌ basef waminif atini atif. ");
INSERT INTO aoj_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Ama anif basef fagape Baibeli fandawalap faꞌias fagaꞌi, ‘Esis anaf sotologon, apaꞌ ina siti anin mae, owaꞌ. Eaꞌ esis sogahembeꞌ semeꞌ basef, apaꞌ ina sogawa kofagefa, owaꞌatin. Ama esis ina sogawa basef kofagefa sombema nelelemba egakwaha waf awafi asasifi, owaꞌatin.’” ");
INSERT INTO aoj_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Jisas nahaliꞌ esis naꞌi, “Ipaꞌ owaꞌ pegawa basef ifimba waminif atin dokoꞌ agaꞌipipafia? Atiasi ipaꞌ pelafa basef waminif atini hiꞌilif piꞌimama? ");
INSERT INTO aoj_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Deiꞌ aman anamba nogowaha olemb gwaꞌaimbii, anen siꞌi anona nagaꞌipasa basef Godii. ");
INSERT INTO aoj_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Eaꞌ olemb ambamba begewa ufiaꞌwi siꞌi anis sagameꞌ basefi, owaꞌ, Satan nafiꞌi nelefata basef ifimba God nagasoꞌasef nelelemb asasilimbi. ");
INSERT INTO aoj_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Apaꞌ anemb bewa bafeꞌ anagon otambaigimai, ambamba siꞌi anis epes sameꞌ basef Godi sofaꞌef kwafalis sandagalamef. ");
INSERT INTO aoj_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Apaꞌ isimba siꞌi masilimb owaꞌ bewafa begewala itap awinia. Esis sahapilif nogota bandata ma aꞌi owaꞌ, anis amam nematawa sandaiwaꞌma sagahapifa basef Godi sandaꞌas findiwas sahas sandaꞌmasa waf awafi eaꞌ kwafalis atis sandahagas sakwaha sagahapifa Godi. ");
INSERT INTO aoj_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Anemb begewala mandelef wandafumi laꞌafini, ambamba siꞌi anis sameꞌ basef sailif safeꞌ, ");
INSERT INTO aoj_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","aꞌi owaꞌ hiahaom nimanimi maloma hiahaom esis satolom kowagalasami basoꞌami maloma moni uga maina esis saꞌi sogofaꞌami hiami magape itapanai, amambai mataga maofana basef Godi. Eaꞌ ina sahapifif sandaꞌ waf buꞌwafi banages, owaꞌatin. A sowa siꞌi gwaꞌaisi owaꞌ sogalo andeandeꞌia. ");
INSERT INTO aoj_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Apaꞌ anemb begawa itap fasipai siꞌi epes isimba sameꞌ basef buꞌwafi sofaꞌef sahapilif sandaꞌ waf fasifii. Anis siꞌi begela 30-pelaisi, apaꞌ anis siꞌi begela 60-pelaisi, apaꞌ anis siꞌi begela 100-pelais hiasi. ");
INSERT INTO aoj_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Jisas naꞌipas nandaꞌ basef waminif atin naꞌi, “Aꞌi epes sakata lambeh sopaloꞌambeh haꞌoh belitagw lafelagwa aꞌa sopaloꞌambeh handambahoꞌ baket? Owaꞌatin. Esis sawamonambeh belitagw ilif. ");
INSERT INTO aoj_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Hiahaom mape mandambahiꞌi, anaf motaga alihigima hiasi sotolom sogawam. Apaꞌ hiahaom hiami ataꞌ sambahoꞌwam magaꞌihi, anaf motaga mondawalap, hiasi sogawam. ");
INSERT INTO aoj_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Ipaꞌ aligah hagagalipai pagameꞌ basefi, ipaꞌ pendameꞌef andeandeꞌ.” ");
INSERT INTO aoj_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Eaꞌ naꞌipam wapani naꞌi, “Basef ipaꞌ pagameꞌafi, ifimba aꞌ pendegawef andeandeꞌ. Basef mamahifa faloma waf maif ipaꞌ pandaꞌmasaf anis daiasi, ikwaf afamba atef anaf God nogwamepaf ipaꞌ, eaꞌ nowatanimipa anom wapani. ");
INSERT INTO aoj_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Epes ami sagahapila basef Godii, atiasi God nowatanimasef wapani. Apaꞌ isimba owaꞌ sogahapilifia, atiasi basef kwawiaꞌwif ifimba esis sogahapilafi, God aꞌ nondalombasef esis eaꞌ sope dowaf.” ");
INSERT INTO aoj_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Jisas naꞌipas basef waminif atin naꞌi, “Epes sogawis nomona maol Godi nope Dembinai nugumafias, amamba siꞌi anif basef waminif atin deiꞌ aeꞌ igaꞌipipafi. Anona aman nowaha olemb gwaꞌaimbi aof ananifi. ");
INSERT INTO aoj_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Eaꞌ nafiꞌi nape baop naꞌoh owambeh hiembihi, nape nimaguf hiafi safeꞌ apaꞌ olemb ambamba nagawambi bataga balo luꞌwimb baꞌimama? Anen ina nogawa bagataga bataga baꞌimama, owaꞌatin. ");
INSERT INTO aoj_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Itap atep pandaꞌ olemb ambamba bataga balo bela gwaꞌaisi sailamb. Dokoꞌ ataꞌ soh atoh haliꞌ, aꞌi owaꞌ main, afis sataga eaꞌ gwaꞌaisi sandandaꞌ luꞌwis sail. ");
INSERT INTO aoj_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Eaꞌ satagama aꞌi owaꞌ luꞌwis, afis andeandeꞌ asaof. Nemaf afamba sagalaꞌ gwaꞌaisiefi fataga, aman anamba nandaꞌ maol naloma nagwatop.” ");
INSERT INTO aoj_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Jisas naꞌias wapani naꞌi, “Epes sogawis nomona maol Godi nope Dembinai nugumafias naꞌamba atin siꞌi main? Aeꞌ indilaꞌwaifam iꞌi basef maif waminif atini? ");
INSERT INTO aoj_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Analef nalelef mastetilif saꞌusaꞌulifi siꞌi nalelef waminipilif. Ina luꞌwalef aꞌowaꞌ siꞌi saꞌutip gwaꞌaipi lawah hiagahi magawagah itapi, owaꞌ. Afalemba saꞌosaꞌolef aꞌowaꞌ. Anen nagawaf itap. ");
INSERT INTO aoj_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Nawafa main, natagai ma nagalo luꞌuna aꞌ nikilaꞌ lawah hiagahi hogotawa aofahi. Nataga lawag luꞌunai, agof fandalona fafeꞌagon ganigani. Eaꞌ amiguf fafiꞌi fala owah fandambahoꞌma owaf fatoma agufugama.” ");
INSERT INTO aoj_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Jisas naꞌipas basef waminif atin siꞌi naliꞌ nagaꞌipasafi. Naꞌipas nondolaꞌwaifa hiahawes hiasi fagiꞌma gawa asasini nafeꞌ negetambel. ");
INSERT INTO aoj_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Anen ina naꞌi anif basef alihifa esis, owaꞌ. Anen naꞌif waminif atin. Apaꞌ aꞌi owaꞌ, alipumi ananimi atom malomana mape, daoꞌ naꞌipamef alihif kofagefa waminif atini. ");
INSERT INTO aoj_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Nemaf afamba atef, wambomota felefeleꞌma owamb, Jisas naꞌipa alipumi ananimi naꞌi, “Afaꞌ aꞌ ofeꞌ dumb ambamba fisanamb.” ");
INSERT INTO aoj_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Eaꞌ amom makwaha esis amam nematawa hiasi mafeꞌ bot atamba Jisas nagatumatai mofaꞌata mafeꞌ. Anis daias sofaꞌ anogw botagw daiagw waloma bot atamba safeꞌ. ");
INSERT INTO aoj_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Eaꞌ anona fufin luꞌunai naluwi, naoh mandaꞌam lasialiꞌ mafeꞌ mawis bot nomon eaꞌ taꞌi siꞌitama embel. ");
INSERT INTO aoj_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Jisas naꞌoh nolola bot tagagiꞌma nola piloꞌ naꞌoh. Eaꞌ amom mafeꞌ minimbalona maꞌipana maꞌi, “Tisa dembinai, afaꞌ waꞌi ahigililafa, inaꞌ negawafa, aꞌa owaꞌ?” ");
INSERT INTO aoj_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Eaꞌ Jisas nosafel ninifala fufin naꞌipa embel naoh naꞌi, “Ipaꞌ eaꞌ. Fufin neloma embel ipaꞌ beꞌ pepe.” Eaꞌ fufin nowala, embel ina ataꞌ lasialiꞌ aꞌ owaꞌatin betah hililiꞌ. ");
INSERT INTO aoj_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Eaꞌ naꞌipa alipumi ananimi naꞌi, “Ipaꞌ ombel mahepama main? Ipaꞌ pihapifa basef Godi paꞌi aeꞌ banagiwai, aꞌa owaꞌ?” ");
INSERT INTO aoj_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Eaꞌ amom mati naꞌamba, ombel maham kwapeteꞌ endilisi eaꞌ mandaꞌipama maꞌi, “Anen epen ami? Naꞌipa fufini embel sameꞌana sagahapifana?” ");
INSERT INTO aoj_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Jisas naoꞌwa alipumi nafeꞌ nataga anagon waꞌol dumb ambamba itap esis Gerasai sagapoma. ");
INSERT INTO aoj_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","3","Anen nakwaha bot nisilaꞌi, kwafalis atin anona aman ambagof awami magapaunai nafiꞌmai anen. Aman anamba nape naꞌoh dondol wandelef sagawa epes sagagaꞌima nafiꞌi. Eaꞌ sen wapani ina sisihina, owaꞌ. ");
INSERT INTO aoj_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Esis saliꞌ sombaloꞌana sumafiana dondol, sandaꞌ seni hankap banagami sowaꞌana lagof boꞌwagahana lifilafi. Owaꞌ owaꞌatin. Anen nahapeꞌam atin. Owaꞌ anin epen banagena nembaloꞌana sisihina nogapea, owaꞌatin. ");
INSERT INTO aoj_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Dondol owamb alip nape nafeꞌ wandelef halafutagw, nagafeꞌ nandaꞌam wiwa nafeꞌ. Nasaꞌma otamba hikalimi natotopaꞌ alop ananipi. ");
INSERT INTO aoj_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Anen ataꞌ nati Jisas nafiꞌi laogon, nasagih nafiꞌi nindiwa nembawa notaomana. ");
INSERT INTO aoj_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Eaꞌ Jisas nogawa aman anamba ambagof awami magapaunai. Eaꞌ naꞌipam naꞌi “Ipaꞌ ambagof aupai, ipaꞌ kwahowa aman anamba.” Eaꞌ anen hogaꞌala mehip naꞌi “Jisas, inaꞌ Nogamana dembinai God nagape ilif endilisii, inaꞌ naꞌi nendaꞌ maina aeꞌ? Aeꞌ aꞌipina endilisi gani ilifa agol Godi, inaꞌ owaꞌi neseꞌe akafimia.” ");
INSERT INTO aoj_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Owaꞌ Jisas nahaliꞌana naꞌi, “Agol ineꞌigili ami?” Anen naꞌi, “Apaꞌ ambagof aupai hiapai. Deiꞌ agol apeꞌigili miniꞌap laupi.” ");
INSERT INTO aoj_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Eaꞌ nahaliꞌ Jisas dindinip naꞌi, “Inaꞌ netofafa ofaꞌ ofeꞌ anep itap lauguni, owaꞌi.” ");
INSERT INTO aoj_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Anagof bogof hiagufi falutu faꞌ gwaꞌaisi anota damota felefeleꞌ. ");
INSERT INTO aoj_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Eaꞌ ambagof amamba mofala Jisas maꞌipana dindinip maꞌi, “Inaꞌ netofafa ofeꞌ uwis ope oloma bogof gwagwafumba.” ");
INSERT INTO aoj_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Eaꞌ Jisas naꞌi ahoꞌmam, makwaha aman anamba mawisi aꞌ mafeꞌ mawisa bogof. Eaꞌ bogof agwafomba hiagufi 2000-pelaiguf fafaꞌ fafeꞌ mehip kwapeteꞌagof filiana anagon awagoma tata. Eaꞌ bogof agwafomba hiagufi fafaꞌ fafeꞌ mehip fowala taꞌalogol awagoma tata fola embel dumb afum hiꞌalam. ");
INSERT INTO aoj_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Eaꞌ amom mugumafiagufi mafaꞌ mafeꞌ maꞌipasa basef ifimba wambel luꞌwagoma amam nematawa hiasi. Eaꞌ maꞌipas anagon daiagon wapani ma hiahaom amamba amom magatulumi. ");
INSERT INTO aoj_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Eaꞌ safiꞌmai Jisas sati aman anamba fowaꞌ ambagof awami magapaunai, deiꞌ amboꞌona nomonas fasisi sapaona andeandeꞌ nowahoꞌ lowaf nape. Amam nematawa hiasi satalona ombel mahas. ");
INSERT INTO aoj_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Eaꞌ esis sagati hiahaom amambai, saꞌipa esis wambelisi ma hiahaom magataga aman anamba ambagof awami magapaunai. Eaꞌ saꞌipas hiahaom magatagama bogufi wapani. ");
INSERT INTO aoj_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Eaꞌ esis hiasi saꞌipa Jisas dindinip saꞌi nokwaha itap apamba asasima nofoꞌo anagon. ");
INSERT INTO aoj_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Eaꞌ Jisas nalota bot owaꞌ, aman anamba fowaꞌ ambagof awami magapaunai nahaliꞌ Jisas dindinip naꞌi, “Aeꞌ aꞌi efeꞌ elomena.” ");
INSERT INTO aoj_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Apaꞌ Jisas ina naꞌi ahoꞌmana, owaꞌ. Eaꞌ naꞌipana naꞌi, “Inaꞌ nefeꞌma esis wambota atota ineꞌisi niꞌipasa amamba dembinai nandaꞌmenam ineꞌi nati uwahipina ma nandaꞌena boꞌwena.” ");
INSERT INTO aoj_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Eaꞌ aman anamba nafeꞌ nawalapa basef ifimba naꞌipasef walemb ilifunamailimb Dekapolisa hiahaom Jisas nandaꞌmanami. Eaꞌ esis amam nematawa gogolalasis kwapete ukup malamafeꞌ. ");
INSERT INTO aoj_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Jisas nofaꞌ bot notanima nambo dumb ambamba nafeꞌ fisana gani waꞌol, eaꞌ amam nematawa hiasi safiꞌi sape salagamana felefeleꞌma dumb akata ");
INSERT INTO aoj_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","eaꞌ anona aman Jairus nugumafi ipat Juda sandakolasatai nafiꞌi. Anen nati Jisas, nindiwa nembawa notawa felefeleꞌma boꞌwagah Jisasi. ");
INSERT INTO aoj_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Eaꞌ naꞌipana dindinip naꞌi, “Saꞌukwi nogame aeꞌakwi afagof 12-pelaiguf fagaloꞌakwi felefeleꞌ kwaꞌi akogaꞌ. Aeꞌ aꞌi inaꞌ nefeꞌ newamona lagol ineꞌigili akoꞌwa ambal lopaoꞌw kogape namoꞌw.” ");
INSERT INTO aoj_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Jisas nalomana mafeꞌ, hiasi amam nematawa safeꞌ sagiꞌmam sandaliliꞌamona atin salutu dogw. ");
INSERT INTO aoj_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Eaꞌ anoꞌw nemataꞌw kwape kwalomas, aowas aowasini nandaꞌaꞌw kwape gamba atapiꞌw afagof 12-pelaiguf. ");
INSERT INTO aoj_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Akoꞌw kwafeꞌma dokta hiasi sasoꞌakwa akafimi, eaꞌ kwalamona moni akoꞌwini hiꞌalana kwagatala dokta isimba hiasi ma sondaꞌakw boꞌokw, owaꞌ owaꞌatin. Aowas inimba nataga luꞌwin atapin napaoꞌw. ");
INSERT INTO aoj_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Eaꞌ kwameꞌ basefa Jisas nafela anis aowas nandaꞌasi amboꞌwes. Eaꞌ kwaloma amam nematawa hiasi kwafiꞌi alafuga Jisasi kwahapila lowaf ananifi. ");
INSERT INTO aoj_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Akoꞌw okom mandandaꞌ maꞌi, “Aeꞌ egasa lagola lowaf ananifi, atiasi amboꞌowe.” ");
INSERT INTO aoj_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Eaꞌ kwafalis atin esimbel peleꞌatam eaꞌ kwameꞌ alop akwaꞌupi pataga boꞌop, aowas deiꞌ aꞌ nafeꞌ eaꞌ. ");
INSERT INTO aoj_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Eaꞌ Jisas nameꞌ alop ananipi powafa, nameꞌ anom banagami ananimi makwahona mafeꞌma mandaꞌ anin epen boꞌwen. Naꞌamba nandambema laꞌafena esis hiasi naꞌi, “Ami nasa lagola lowaf aeꞌafi?” ");
INSERT INTO aoj_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Eaꞌ alipumi ananimi maꞌipana maꞌi, “Inaꞌ natilis aꞌa owaꞌ amam nematawa isimba hiasi salutu sandaliliꞌamona atin sagalomafa? Deiꞌ maina inaꞌ ataꞌ nagaꞌi, ‘Ami nasa lagola aeꞌ?’” ");
INSERT INTO aoj_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Eaꞌ Jisas nandambema natologon naꞌi niti inimba nagahapilanai. ");
INSERT INTO aoj_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Eaꞌ nemataꞌw akwamba kogawa hiahawes isimba sagatagamaꞌwi, ombal mahaꞌw ambombol atin. Eaꞌ kwafiꞌi kwindiwa nembawa kotawa felefeleꞌma anen, kwawalapa hiahaom kwaꞌiam alihim. ");
INSERT INTO aoj_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Eaꞌ Jisas naꞌipaꞌw naꞌi, “Nemataꞌw, inaꞌ eaꞌ nahapifa aeꞌ banagiwai. Isimba atis deiꞌ andaꞌena boꞌwena. Inaꞌ foꞌo, opaf ineꞌifi fope awanef. Esimbel ineꞌimi aꞌ fataom, deiꞌ aowas ineꞌini ahiꞌalan.” ");
INSERT INTO aoj_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Jisas ataꞌ naꞌipaꞌw atin, nati anom amam makwaha ipat Jairusi aꞌ mafiꞌi maꞌipa Jairus maꞌi, “Nogamena ineꞌikwi akwagaꞌ eaꞌ. Isimba atis deiꞌ ina nendaꞌ Dembinai Tisa nofoꞌo nomaꞌw kohana, owaꞌ, hapaimi.” ");
INSERT INTO aoj_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Owaꞌ Jisas ina nowaꞌ aligah nameꞌama basef ifimba amamifi, owaꞌ. Eaꞌ naꞌipa Jairus naꞌi, “Inaꞌ ombel mogahena owaꞌi. Hapifa aeꞌ banagiwai.” ");
INSERT INTO aoj_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Eaꞌ anen ina naꞌi ahoꞌma amam nematawa hiasi sogalomana, sogawis ipat atamba, owaꞌ. Anen naoꞌwa Pitai Jems maloma Jon amom atom mawis malomana. ");
INSERT INTO aoj_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Mafeꞌ mataga ipat Jairusi, Jisas nati esis salef mehip sawa salopaꞌw kwapeteꞌas. ");
INSERT INTO aoj_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Eaꞌ nawis naꞌipas nomon naꞌi, “Deiꞌ maina ipaꞌ palef pandaꞌ kwalaꞌap luꞌunai? Awani inimba ina nagaꞌ dogw, owaꞌ. Anin naꞌoh atin.” ");
INSERT INTO aoj_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Eaꞌ esis sandaꞌ iafana kwapeteꞌas ama nagaꞌias naꞌamba. Eaꞌ nagaloꞌma esis sawisi andoꞌ. Anen naoꞌwa ahamaꞌwi maꞌmakw saloma alipumi ananimi wanom, esis atis safeꞌ sawis nomon awani inimba nagaꞌ nagaꞌoma. ");
INSERT INTO aoj_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Eaꞌ nahapila lagol akwaꞌugili naꞌipaꞌw naꞌi, “Talita kumi.” Apaꞌ mambema basef ifimba maꞌi, “Nemataꞌw saꞌukwi, aeꞌ aꞌipina, inaꞌ deiꞌ safel.” ");
INSERT INTO aoj_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Eaꞌ kwafalis atin nemataꞌw akwamba afagof 12-pelaiguf fagaloꞌakwi kosafel kwafeꞌ esis satoloꞌw, sosafel gogolalasis kwapeteꞌ. ");
INSERT INTO aoj_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Eaꞌ Jisas naꞌipas dindinipa sigaila basef ananifi naꞌi, “Ipaꞌ ina piꞌipa anin epena hiahawes isimba, owaꞌi.” Eaꞌ naꞌipa esisa sogasoꞌakw anis gwaꞌaisi kogwaꞌas. ");
INSERT INTO aoj_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Jisas nosafel nakwaha wambel ambalemba nafeꞌ wambel ananimbili kofagama Nasaret naloma alipumi ananimi. ");
INSERT INTO aoj_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Aꞌi owaꞌ nemaf sagapoma nomaꞌwafi saꞌi sabat, nafeꞌ nawis ipat Juda sandakolasatai nasoꞌasa basef Godi amam nematawa, sameꞌanamef sosafel gogolalasis saꞌi, “Aman anamba nofaꞌ basef ifimba ani? Gawa inimba nagape anini gawa mamahina? Ami natopalopana ma deiꞌ nandaꞌ banagami amamba siꞌi God nandaꞌami? ");
INSERT INTO aoj_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Apaꞌ magawa aman anamba fowaꞌ nandaꞌ kamda nagalaꞌ ifagwi. Anen Maria nogamaꞌw, nagape wambel atimbili. Anen sahoma Jemsi Joses, a Judasi Saimon. Hanitiamana ananiwai wape walomapa naꞌa.” Esis saꞌias naꞌamba opalef aꞌ awelefa anen, sowaꞌ alafugahana. ");
INSERT INTO aoj_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Eaꞌ Jisas naꞌipas naꞌi, “Anona profet agol gatomana analemb walemb daialemb, saꞌi anen dembinai sahapifana. Apaꞌ ina anagol agol gatoma gandawalapana alihigila wambel ananimbili kofagama, wambota ananisi owaꞌ. ");
INSERT INTO aoj_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Naꞌamba anen ina nandaꞌ anom banagami siꞌi God nandaꞌami wambel ambalemba, owaꞌatin. Anen nasa lagofa anis aowas nandaꞌasi atona atin nandaꞌas boꞌwes. Ina nandaꞌ hiasi naꞌamba atin, owaꞌ. Nandaꞌ isimba atis kwaiaꞌwis. ");
INSERT INTO aoj_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Amam nematawa Nasaretisi owaꞌ sohapifa Goda. Naꞌamba anen nomonas salasafeꞌmas. Jisas nakwaha wambel ananimbili Nasaret nafeꞌ naꞌipasa basef Godi amam nematawa walemb hiagoma. ");
INSERT INTO aoj_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Eaꞌ nofala alipumi ananimi 12-pelaim mafiꞌmai anen aꞌ nasoꞌama banagami ananimi ma mogatofa ambagof awami, eaꞌ nasapaꞌam mafeꞌ biam atom. ");
INSERT INTO aoj_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","9","Naꞌipam naꞌi, “Ipaꞌ ina pefaꞌ gwaꞌaisi isalef moni solomepa, owaꞌi. Ipaꞌ pela su pihapila galahitagw atogw pefeꞌ. Apaꞌ ina pefaꞌ siogw biagw atogw, owaꞌi. Pefaꞌ atona atin gondondaepa.” ");
INSERT INTO aoj_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Eaꞌ naꞌipam wapani naꞌi, “Ipaꞌ pefeꞌ pegataga anambel wambela, iꞌi anis siꞌi ahoꞌma pefeꞌ pigawis ipat asasitai, ipaꞌ pendape ipat atamba atota. Ama main pekwahota pesafel pefeꞌ. ");
INSERT INTO aoj_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Iꞌi analemb walemb owaꞌ sofaꞌepa pefeꞌ ifagw asasigwi semeꞌ basef ipeꞌifia, ipaꞌ pendaꞌas naꞌamba. Pekwaha wambel ambalemba pindilaꞌma usas itap pagail boꞌwagah ipeꞌigahi ma sitilipa sogogawa waf awafi kofagema eaꞌ asasimi atom.” ");
INSERT INTO aoj_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Eaꞌ nasapaꞌam mafeꞌ biam atom makwaha basef maꞌi, “Ipaꞌ pewaꞌ alafugaha waf awafi, pembema nelelemb pendafeꞌma God.” ");
INSERT INTO aoj_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Eaꞌ mafeꞌ matofa ambagof awami magape esisi. Eaꞌ mofaꞌ wel fasili makoloꞌwala esis aowas nandaꞌasi hiasi sataga boꞌwes. ");
INSERT INTO aoj_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Deiꞌ anona gavman king dembinai Herot nameꞌ basefa maol inimba Jisas naliꞌ nandaꞌani. Eaꞌ agol Jisasi gataga luꞌwagol gafeꞌagon hiꞌalagon. Eaꞌ anis amam nematawa saꞌi, “Jon nagapisiꞌas embeli deiꞌ nosafel wapani nape banagona nandaꞌ maol siꞌi God nandaꞌani.” ");
INSERT INTO aoj_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Owaꞌ anis daias saꞌi, “Anen profet Elija fowaꞌinai.” Apaꞌ anis saꞌi, “Anen anona profet siꞌi profet amamba fowaꞌimi.” ");
INSERT INTO aoj_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Gavman anamba king Herot nameꞌ naꞌamba eaꞌ naꞌi, “Jon fowaꞌ aeꞌ atopaꞌ bamafugana, apaꞌ owaꞌ aꞌ notanima nosafel wapani nandaꞌ maol Jisasi.” ");
INSERT INTO aoj_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Fowaꞌ Herot nasoꞌ nemataꞌw owamana Filipi agiliꞌwa Herodias. Eaꞌ sahomana Herot nolaepanaꞌw nasoꞌakw. Eaꞌ Jon nati waf afamba naꞌipana naꞌi, “Inaꞌ nasoꞌ nemataꞌw sahomenai, eaꞌ nawala muꞌuli Godi. Naꞌambai ina andeande, owaꞌ.” Eaꞌ Herot nasapaꞌ anom amam mafeꞌ mombaloꞌ Jon mofaꞌana mafeꞌ nandaꞌ kalabus. ");
INSERT INTO aoj_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","20","Eaꞌ Herodias kwameꞌ basef ifimba, okom aom endilisi ma Jon, kwaꞌi kohana afuna, apaꞌ owaꞌ, owaꞌatin. Herot anen ombal mahanama Jon eaꞌ numafiana andeandeꞌ. Isimba atis akoꞌw ina banageꞌwa kohana nogagaꞌ, owaꞌ. Herot nogawa Jon aman buꞌunai Godi. Afamba anen nagameꞌ basef Jon nagaꞌipanaefi, anen nomonas hiahawes, eaꞌ ombal mahana. Anen okom maꞌimaꞌi aꞌowaꞌ ma nogameꞌ basef ananifi. ");
INSERT INTO aoj_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Aꞌi owaꞌ main, Herodias kolaoma anoꞌw ufiaꞌw ma kohana nogagaꞌ. Eaꞌ basef fagape naꞌamba. Herot nandaꞌ anis gwaꞌaisi luꞌwasi ma okom mogapoma nemaf afamba maꞌmana kogolanafi. Anen nandaꞌ gwaꞌaisi isimba ma anom dembami magatopalopana ma maol gavmani a anom dembami daiam mugumafi amom soldiai maloma anom dembami magape walemb anamba hiagoma Galilii. ");
INSERT INTO aoj_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Eaꞌ amom dembami maloma Herot mape maꞌ gwaꞌaisi, owaꞌ anoꞌw nemataꞌw saꞌukwi aiawaiꞌwi kwawisi kwalemb nomon. Akoꞌw Herodias nogamaꞌw. Eaꞌ Herot naloma amom dembami nomonas saꞌi saꞌi akoꞌw aꞌowaꞌ. Eaꞌ naꞌipaꞌw naꞌi, “Inaꞌ naꞌi aeꞌ eseꞌena hiahawes mais? Inaꞌ niꞌipias aeꞌ ma egaseꞌenas.” ");
INSERT INTO aoj_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Herot naꞌias endilisi gani ilif naꞌi, “Iꞌi inaꞌ nihaliꞌ aeꞌ ma egaseꞌena anin maemae ineꞌma, aeꞌ egasiꞌinai. Apaꞌ inaꞌ niꞌi aeꞌ egawala hiahaom aeꞌami hiami magaꞌoh anamba agalaꞌambemagoma egaseꞌena duꞌwanima, aeꞌ aꞌi ahoꞌ. Inaꞌ duꞌwanim, aeꞌ duꞌwanim, dondaꞌam atin.” ");
INSERT INTO aoj_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Eaꞌ akoꞌw kwawisi andoꞌ kwafeꞌ kwahaliꞌ maꞌmakw akwaꞌuꞌwi kwaꞌi, “Aeꞌ atiasi iꞌipa Herot efaꞌ hiahawes mais?” Eaꞌ maꞌmakw kwaꞌipaꞌw kwaꞌi, “Inaꞌ niꞌipana niꞌi nefaꞌai balaga Jon nagapisiꞌas embeli.” ");
INSERT INTO aoj_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Eaꞌ kwandambemef kwawis nomon kwafalisa Herot kwaꞌi, “Deiꞌ atef aeꞌ aꞌi inaꞌ neha Jon nagapisiꞌas embeli nogaꞌ netopaꞌ balaga gola anota plet nefaꞌagai neseꞌe.” ");
INSERT INTO aoj_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Akoꞌw kwaꞌias naꞌamba, opaf Heroti aꞌ nimanif aꞌowaꞌ. Apaꞌ anen okom mandandaꞌ ma naꞌi basef endilisifi atif nagaꞌif banagafi eaꞌ amam nematawa isimba sape salomana sagaꞌ gwaꞌaisii sameꞌana. Eaꞌ ina ataꞌ nosambala basef akwaꞌufi, owaꞌ. ");
INSERT INTO aoj_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Kwafalis Herot nasapaꞌ anona soldia nafeꞌma noha Jon nofaꞌ balaga nogafiꞌi. Soldia anamba nafeꞌ ipat sandaꞌ kalabusa natopaꞌ bamatoꞌw Joni nofaꞌ balaga ");
INSERT INTO aoj_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","nalaga gala anota plet nofaꞌaga nafiꞌi nasoꞌ Herodias nogamaꞌw kofaꞌaga kwafeꞌ kwasoꞌ maꞌmaꞌw. ");
INSERT INTO aoj_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Eaꞌ alipumi Joni magaila basef ananifii mameꞌ basef ifimba ma anen, mafiꞌi mofaꞌ siꞌina mafeꞌ mawana matmat. Eaꞌ maꞌuf. ");
INSERT INTO aoj_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Amom aposel Jisasi deiꞌ motanima mafiꞌi mandakolas malomana. Eaꞌ mape manifa maol mafeꞌ mandaꞌani maꞌipana basef hiafi amom magaꞌipasafi hiꞌalef. ");
INSERT INTO aoj_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Eaꞌ anis amam nematawa hiasi fiꞌi feꞌ sail sandaꞌ Jisas naloma alipumi ananimi ina ataꞌ anota nogota ma amom mogaꞌ gwaꞌaisi, owaꞌ. Eaꞌ Jisas naꞌipam naꞌi, “Wale, afaꞌ atofa ofeꞌ anagon wafigima ma ataꞌ tol opoma nomaꞌw.” ");
INSERT INTO aoj_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Eaꞌ mofaꞌ bot mafeꞌ anamba wafigima epes akagoma, amom atom mafeꞌ. ");
INSERT INTO aoj_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Owaꞌ owaꞌatin. Esis amam nematawa hiasi sogawa amom magafeꞌma. Eaꞌ esis hiasi sakwaha walemb hiagoma luꞌwagoma koloꞌwalas sasagih safeꞌ anamba eaꞌ saliꞌ sataga anamba amom maꞌi mogafeꞌma. ");
INSERT INTO aoj_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Jisas nafeꞌma nisilaꞌ akata, nati esis hiasi. Natilis nati ina anona aman nape numafias, owaꞌatin. Esis sape siꞌi sipsip owaꞌ anin epen nigimafiapia, eaꞌ nati esis uwahipis nawalipasa basef buꞌwafi hiafi. ");
INSERT INTO aoj_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Ama awin aꞌi newala nasoꞌ, alipumi ananimi mafiꞌmai anen maꞌipana maꞌi, “Anaꞌe wafigima epes akagoma, awin naꞌi aꞌ newala. ");
INSERT INTO aoj_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Sapaꞌas sofoꞌo walemb aofah asasisi daindai sagape felefeleꞌi ma sogatala gwaꞌaisi mais sogaꞌas.” ");
INSERT INTO aoj_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Owaꞌ Jisas nagwamam naꞌipam, naꞌi, “Ipaꞌ atipa peseꞌas gwaꞌaisi.” Eaꞌ maꞌipana maꞌi, “Inaꞌ naꞌi afaꞌ ofeꞌ utalai bret 200 kina osoꞌosas? 200 kina otamba hiambai.” ");
INSERT INTO aoj_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Eaꞌ Jisas nahaliꞌam naꞌi, “Ipaꞌ bret maꞌufita taꞌoh? Ataꞌ foꞌo petolota.” Eaꞌ mafeꞌ matolota maꞌi, “Bret waꞌagolita taloma agof biagof saꞌoh.” ");
INSERT INTO aoj_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Eaꞌ naꞌipam naꞌi, “Ipaꞌ piꞌipa esis amam nematawa sope sofeꞌ oto otowa otalef fasilifi.” ");
INSERT INTO aoj_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Eaꞌ sape safeꞌ siꞌi amom magaꞌipas, anis sataga 100-pelais, anis 50-pelais, naꞌamba atin. ");
INSERT INTO aoj_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Eaꞌ Jisas nasaꞌma bret atamba waꞌagolita taloma agof biagof naniga nati heven nanifela God. Ama eaꞌ, nindiwata nasoꞌ alipumi ananimi mafeꞌ masoꞌ esis hiasi amam nematawa hiꞌagalas. Eaꞌ nasaꞌma agof wapani nawalogof nasoꞌam masoꞌasagof. ");
INSERT INTO aoj_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Esis saꞌas alihis andondoꞌ, ");
INSERT INTO aoj_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","alipumi ananimi matatama duꞌwaꞌwanisi sagaꞌihi, maloꞌwas folalef luꞌwalifi 12-pelailif siꞌilif kwaef. ");
INSERT INTO aoj_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Esis amam nematawa sagaꞌ gwaꞌaisi isimbai hiasi, siamba amam atom mataga 5,000-pelaim. Apaꞌ esis ina siamba awasi nematawa wapani, owaꞌ. ");
INSERT INTO aoj_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Jisas nasapaꞌ alipumi ananimi mofaꞌ bot maliꞌ mafeꞌ dumb ambamba mambo fisanamb Betsaida. Eaꞌ nasapaꞌ amam nematawa hiasi safeꞌ. ");
INSERT INTO aoj_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Nasapaꞌas sagafiꞌi, anen nandowasaꞌ halafuta nape naꞌi nondaꞌ beten. ");
INSERT INTO aoj_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Wambomota alipumi ananimi mape bot ataꞌ atapim mala dumb luꞌwambi laꞌafimba. Apaꞌ Jisas atona nalutu akata. ");
INSERT INTO aoj_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Eaꞌ nati fufin luꞌwani nalo nafiꞌi anamba amom maꞌi mogafeꞌma, eaꞌ nakotoꞌma amom mandaꞌ pul masasapaꞌ bot aꞌ numaꞌuna endilisi. Akot ataꞌ tail atin felefeleꞌma logola owaꞌ, Jisas nagiꞌmam natoma nafiꞌi embel ilifa nafeꞌma amom. Eaꞌ naꞌi nikilaꞌam nefeꞌ. ");
INSERT INTO aoj_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Owaꞌ mati anen natoma nafiꞌi embel ilif. Maꞌi owaꞌ anona gamba, eaꞌ mandaꞌas wiwa maꞌoh kwapeteꞌam. ");
INSERT INTO aoj_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Amom matolona gogolalasom. Owaꞌ Jisas nalomam naꞌi kwafalis naꞌi, “Ipaꞌ banagepa, ombel mogahepa owaꞌ. Aeꞌ atowe maꞌuwi ailipa afiꞌi.” ");
INSERT INTO aoj_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Eaꞌ nalota bot nape nalomam, deiꞌ fufin aꞌ newala opalef amamilifi gogolalasom kwapeteꞌam endilisi, eaꞌ nomonas salasafeꞌ hiahias. ");
INSERT INTO aoj_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Amom ina ataꞌ nomonas sape andeandeꞌma bret atamba Jisas nasoꞌasata esis hiasi sagaꞌatai, owaꞌ. Naꞌamba amom maꞌi anen ina banagonai. Ukup amamipi pasoꞌam. ");
INSERT INTO aoj_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Jisas naloma alipumi ananimi mowala mambo dumb ambamba mafeꞌ mataga anep itap luꞌupa Genesaret. Eaꞌ mowaꞌ bot tail, ");
INSERT INTO aoj_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","misilaꞌ mafeꞌ owaꞌ, esis kwafalis sati Jisas asagawana. ");
INSERT INTO aoj_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Eaꞌ sasagih safeꞌ anamba hiagoma ganigani. Esis sameꞌ basefa Jisas nagapoma, eaꞌ sala aowas nandaꞌasi belitagw sofaꞌas safiꞌmai anen. ");
INSERT INTO aoj_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Walemb hiagoma luꞌwagon saꞌogon, naloma anamba hiagoma Jisas nagafeꞌma, esis sambeꞌ isimba aowas nandaꞌasi saꞌoh baop laꞌafen. Eaꞌ sofala Jisas banagembela nigaꞌi ahoꞌma isimba sogahapila lowaf ananifi daꞌmalififa atef. Eaꞌ esis mamahisa sagahahapilafi sataga boꞌwes wapani. ");
INSERT INTO aoj_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Amam dembami Farisi maloma anom dembami daiam magawalipasa muꞌuli Godi amom mapani Jerusalem mafiꞌi mandakolas maloma Jisas. ");
INSERT INTO aoj_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Eaꞌ mati anom alipumi Jisasi maꞌ gwaꞌaisi owaꞌ mosaꞌopa lagof boꞌwagof meaꞌas siꞌi amom Farisi magaꞌias, owaꞌ. Eaꞌ amom Farisi maꞌi amom alipumi Jisasi lagof amamugufi aloguguf. ");
INSERT INTO aoj_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Deiꞌ main, amom Farisi maloma esis hiasi Juda hiꞌalas, sagiꞌma muꞌuli inimba esis akupasi. Iꞌi esis owaꞌ sosaꞌopa lagof andeandeꞌa, ina seaꞌ gwaꞌaisi, owaꞌ. ");
INSERT INTO aoj_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Esis sogafeꞌ maketa sotanima sogafiꞌi, ma owaꞌ sosaꞌopa lagofa, ina seaꞌ gwaꞌaisi, owaꞌ. Esis sagiꞌma muꞌuli hiani naninani sogofaꞌana akupas asasisii. Sasaꞌopa kahi sospaes, a disi belegw atis, ama sagagiꞌma muꞌuli akupasi. ");
INSERT INTO aoj_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Naꞌamba amom Farisi maloma dembami magawalipasa muꞌuli Godi mahaliꞌ Jisas maꞌi, “Deiꞌ siꞌi maina alipumi ineꞌimi owaꞌ migiꞌma muꞌuli amom akupamia? Lagof amamugufi aloguguf maꞌ gwaꞌaisi.” ");
INSERT INTO aoj_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Eaꞌ Jisas naꞌipam naꞌi, “Fowaꞌ profet Aisaia, nindilaꞌwaifa ipaꞌ endilisi, ipaꞌ pagaꞌi basefa malogof biagufii. Anen nandaꞌef andeandeꞌ dondoꞌma ipaꞌ naꞌias naꞌamba naꞌi, God naꞌi, ‘Amam nematawa isimba sasaꞌma agol aeꞌagili luꞌwagola malogof asasigufi atogof, apaꞌ opalef asasilifi fape laogona aeꞌ. Ukup asasipi ina sahapifi, owaꞌatin. ");
INSERT INTO aoj_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Esis ina sawalipasa basef aeꞌafi, owaꞌ. Sawalapa muꞌuli epes sagape itapi atin, sambasoꞌmas saꞌi, “Muꞌuli inimba basef Godi.” Eaꞌ sandaꞌ lotu sasaꞌma agol aeꞌagili dowadowaf.” ");
INSERT INTO aoj_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Jisas naꞌipam wapani naꞌi, “Ipaꞌ apakwaha muꞌuli Godi eaꞌ, deiꞌ pahapila waf epes sagape itapi atef teteleꞌif.” ");
INSERT INTO aoj_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Eaꞌ naꞌipam naꞌi, “Ipaꞌ pegegawa andeandeꞌi paꞌi pendaꞌ waf fasifi atifi, owaꞌ deiꞌ apesambala muꞌuli Godi ma pagagiꞌma waf ipeꞌifi atef. ");
INSERT INTO aoj_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Fowaꞌ gani Moses nagawalipasa muꞌuli inimba naꞌipas nagaꞌi, ‘Ipaꞌ pinifela mamasepa ipeꞌisi pihapifas petopalopas.’ Anif wapani naꞌif naꞌi, ‘Epen ami nigaꞌi basef awafima ahaman maꞌman ananisii, inimba anis daias sohan negaꞌ.’ ");
INSERT INTO aoj_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Owaꞌ ipaꞌ pambasoꞌam paꞌi anif daif naꞌamba paꞌi, Epen mamahina nindaiwaꞌma negatopalopa mamasan niꞌipas nigaꞌi, ‘Otamba mais aeꞌasi andaiwaꞌma egaseꞌepas, aeꞌ aꞌ andandepasa egasoꞌanas God.’ ");
INSERT INTO aoj_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Apaꞌ ipaꞌ Farisi paloma ipaꞌ anipa pagawalipasa muꞌuli Godi, ipaꞌ paꞌi ahoꞌma epen inimba negambasoꞌma mamasan, eaꞌ owaꞌ netopalopasa. ");
INSERT INTO aoj_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Ipaꞌ paila muꞌuli fowaꞌ gani pegefaꞌana akupipa ipeꞌimii, pandaꞌ waf afambai pesambala basef ifimba Godi naꞌi mogatopalopa mamasapa. Eaꞌ pandaꞌ waf ipeꞌifi atef luꞌufi pandaꞌ waf awafi lifilafi naꞌamba ina andeandeꞌ, owaꞌ.” ");
INSERT INTO aoj_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Jisas nofalai amam nematawa hiasi wapani naꞌipas anif basef waminif atin naꞌi, “Ipaꞌ hipai pemeꞌ basef aeꞌafi okokomef pendegawef. ");
INSERT INTO aoj_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Hiahawes gwaꞌaisi mais andoꞌasi ipaꞌ paꞌas sagawis nomoni, isimbai ina sandaꞌepa awepa, owaꞌ. Apaꞌ hiahaom magape ukup ipeꞌipi nomoni mawisi andoꞌ, amambai atom mandaꞌepa awepa. ");
INSERT INTO aoj_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Ipaꞌ aligah hagagalipai, a pendameꞌ basef ifimba.” Jisas nagaꞌipas naꞌamba, ");
INSERT INTO aoj_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","eaꞌ nakwaha amam nematawa isimba hiasi aꞌ nafeꞌ nawis ipat. Eaꞌ alipumi ananimi atom mahaliꞌana ma basef ifimba kofagefa waminif atini dokoꞌ nagaꞌipasafi. ");
INSERT INTO aoj_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","19","Eaꞌ naꞌipam naꞌi, “Aꞌi ipaꞌ owaꞌ ataꞌ pegawaea! Hiahawes gwaꞌaisi main sagape andoꞌi owaꞌ anis ipaꞌ pagaꞌasia sondaꞌepa awepaia, owaꞌatin. Gwaꞌaisi isimba saꞌas sogowala opalef nomoni a safeꞌ sakas safeꞌ sowala dowah. Eaꞌ ukup ipeꞌipi ina awep, owaꞌatin. Waf afambai magaꞌ gwaꞌaisi hiasi ina awafi, owaꞌ.” Jisas naꞌipasa basefa gwaꞌaisi sasisasi hiasi hiꞌalas buꞌwasi atis mugaꞌasi. ");
INSERT INTO aoj_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Eaꞌ naꞌipam wapani naꞌi, “Hiahaom magape ipaꞌ epesi nomoni, ukup nomonas awami maim mataga andoꞌ, amambai atom mandaꞌepa awepa. ");
INSERT INTO aoj_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Hiahaom awami magape ukup nomoni magawisii amamba. Waf naninani aunai, nomonas awami, waf sandaꞌ soꞌa waulafi, wal, soha anis sogagaꞌi, ");
INSERT INTO aoj_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","sogahambombaga waf dasoꞌamaifi, waf kowagalasafi, waf basoꞌamunai naninani aunai, duꞌwaniga, simbisambal, findiwa, sagafela agof asasigufi atogof luꞌwagof, waf gawa akanai. ");
INSERT INTO aoj_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Waf anamba naninani hianahaona aunai, anamba nape nomon ukup ipeꞌipi nawisi andoꞌ nandaꞌepa awepa.” ");
INSERT INTO aoj_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Jisas nosafel nakwaha wambel ambalemba, nafeꞌ Tair nafeꞌ nawis anota ipat. Anen nandaiwaꞌma anin epen negegawa anen nagape naꞌamba. Owaꞌ, owaꞌatin. Anen ina nandambahoꞌ. ");
INSERT INTO aoj_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Eaꞌ anoꞌw nemataꞌw kwameꞌ basefa anen nape naꞌamba. Nemataꞌw akwamba nogamaꞌw akwaꞌuꞌwi ambal aunai napaoꞌw. Eaꞌ maꞌmaꞌw kwafalis kwafiꞌmai Jisas kwindiwa nembawa kotowa felefeleꞌma boꞌwagah ananigahi. ");
INSERT INTO aoj_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Akoꞌw Finisiaiꞌwi anep itap luꞌupa Siria. Akoꞌw ina Judaiꞌwi, owaꞌ. Kwaꞌi diga Griki. Eaꞌ kwahaliꞌ Jisas dindinipa nogatofamaꞌwa ambal aunai nagape nogamaꞌw akwaꞌuꞌwii. ");
INSERT INTO aoj_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Eaꞌ naꞌipaꞌw anif basef waminif atin naꞌi, “Apaꞌ ataꞌ mosoꞌasa gwaꞌaisi awasi apeꞌisi siliꞌ. Apaꞌ ina mofaꞌ gwaꞌaisi awasi apeꞌisii mokwahis sofeꞌma nombagw, owaꞌ.” ");
INSERT INTO aoj_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Owaꞌ akoꞌw akwagwamana basef anen kwaꞌi, “Dembinai, inaꞌ naꞌi endilisi. Nombagw agogw gwafeꞌ lafela tebol gwatatama gwaꞌaisi awasii sogowa itapi gwaꞌas.” ");
INSERT INTO aoj_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Eaꞌ Jisas naꞌipaꞌw naꞌi, “Inaꞌ naꞌias naꞌamba andeandeꞌ. Eaꞌ tanima foꞌo. Ambal aunai nakwaha nogamena ineꞌikwi aꞌ nawisi nafeꞌ eaꞌ.” ");
INSERT INTO aoj_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Eaꞌ akoꞌw kotanima kwafeꞌ ipat akwaꞌutai, kwati nogamaꞌw akwoꞌukwi tol kwaꞌoh alahis, ambal aunai nakwahoꞌw aꞌ nawisi nafeꞌ eaꞌ amboꞌokw kwaꞌoh andeandeꞌ. ");
INSERT INTO aoj_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Deiꞌ Jisas nosafel nakwaha anambel wambel Tair, aꞌ nafeꞌ nawis laꞌafena wambel Saidon. Eaꞌ nakwaha Saidon nafeꞌ atin ganimba walemb ilifunamailimb Dekapolis, nataga dumb luꞌwambi Galili. ");
INSERT INTO aoj_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Eaꞌ esis saoꞌwai anona aman nafiꞌmai Jisas, aligah hasoꞌana haloma afega ananigai dindigiga. Eaꞌ ina naꞌi andeandeꞌ, owaꞌ. Naꞌamba esis sofala Jisas ma nosa lagofa anen nondaꞌana boꞌona. ");
INSERT INTO aoj_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Eaꞌ Jisas naoꞌwana amom biam mafeꞌ makwaha esis amom atom mape. Eaꞌ nasapaꞌ faguf bif ananifi fawis aligah aman anambai, waꞌowaꞌol. Eaꞌ nisiꞌwaf nasa faf afega aman anambai, ");
INSERT INTO aoj_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Jisas nosaniga nati heven, nahi okom nowafam mehip, naꞌias naꞌamba naꞌi, “Efata.” Basef kofagefa ifimba faꞌi, “Inaꞌ aligah hogal nemeꞌ niꞌi andeandeꞌ.” ");
INSERT INTO aoj_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Eaꞌ aligah a hagal, hiahaom mandaꞌ afega dindiginai ahigilalam kwafalis. Deiꞌ aꞌ naꞌi andeandeꞌ. ");
INSERT INTO aoj_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Eaꞌ Jisas naꞌipas nombombaꞌasa esis ina siꞌipasa hiahawes isimba ma anin epen. Nape naꞌipas dindinip timbi tambel. Owaꞌ, owaꞌatin. Esis sawalapam saꞌipasam timbi tambel semeꞌam. ");
INSERT INTO aoj_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Eaꞌ esis bolalas endilisi saꞌi, “Hiahaom hiami anen nandaꞌami nandaꞌam boꞌom atin. Anen nandaꞌ esis aligah hagasoꞌasi sameꞌ andeandeꞌ, esis malagof fagasoꞌasii a soga saꞌi andeandeꞌ. ");
INSERT INTO aoj_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Afamba amam nematawa hiasi sandakolas wapani saꞌi semeꞌ basef Jisasi. Eaꞌ esis gwaꞌaisi akas. Naꞌamba Jisas nofala alipumi ananimi mafiꞌi naꞌipam naꞌi, ");
INSERT INTO aoj_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","3","“Aeꞌ ati esis amam nematawa isimba uwahipis. Esis a sape salome nimaguf wanif gwaꞌaisi akas nolom mahas aꞌowaꞌ. Iꞌi aeꞌ esapaꞌas sogafeꞌ dowaf uta baop asasima, sitilif atona sowa soꞌoh sofeꞌ iaiaf. Anis safiꞌi laogoma.” ");
INSERT INTO aoj_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Eaꞌ alipumi ananimi magwamana basef maꞌi, “Anaꞌe wafigima epes akagoma. Atiasi afaꞌ ofaꞌai bret anima osoꞌ amam nematawa isimba seaꞌas? Afaꞌ bret ina hiata, owaꞌ.” ");
INSERT INTO aoj_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Eaꞌ Jisas nahaliꞌam naꞌi, “Deiꞌ ipaꞌ bret maꞌuta taꞌoh?” Amom maꞌi, “7-pelaita.” ");
INSERT INTO aoj_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Eaꞌ naꞌipa esis amam nematawa sape itap, anen nafela bret atamba 7-pelaita, nanifela God nawalota nasoꞌ alipumi ananimi ma masoꞌasata esis amam nematawa hiasi. Amom masoꞌas dondoꞌ hiꞌalas. ");
INSERT INTO aoj_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Eaꞌ amom anagof agof saꞌugufi biagof wapani faꞌoh. Eaꞌ anen nasaꞌmagof nanifela God, nasoꞌ amoma mogasoꞌasagof wapani. ");
INSERT INTO aoj_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Eaꞌ esis saꞌas, dondoꞌ alihis. Eaꞌ alipumi ananimi matatamai duꞌwaꞌwanisi sagasagaꞌihi makolasis maloꞌwas folalef luꞌwalifi 7-pelailif asiꞌilif kwaef. ");
INSERT INTO aoj_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Amam nematawa saga gwaꞌaisi isimbai sataga hiasi, 4,000-pelais. Eaꞌ Jisas nasapaꞌas safeꞌ. ");
INSERT INTO aoj_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Eaꞌ kwafalis atin anen nalota bot naloma alipumi ananimi, mafeꞌ anep itap luꞌupa Dalmanuta. ");
INSERT INTO aoj_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Eaꞌ amom Farisi mafiꞌi maꞌi basef mandahihianamaef maloma Jisas. Amom maꞌi mogwambana ma mugati anen banagona aꞌa owaꞌ. Naꞌamba mofalana maꞌi anen nondaꞌ hiahaom banagami siꞌi God nandaꞌami. Amom maꞌi anen nihimbaꞌmama anen nagape banagami Godi ma deiꞌ nandaꞌ hiahaom amamba. ");
INSERT INTO aoj_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Jisas nameꞌ ambal ananili nemanil eaꞌ naꞌi, “Deiꞌ maina ipaꞌ amam nematawa deiꞌ pagape itap apaꞌi paꞌi pefalagama paꞌi pigati anin ametal banagani? Apaꞌ aeꞌ owaꞌatina endaꞌan pigatilina, owaꞌatin.” ");
INSERT INTO aoj_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Eaꞌ nakwaha esis aꞌ notanima nalota bot nafeꞌ dumb ambamba fisanamb. ");
INSERT INTO aoj_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Amom alipumi Jisasi ukup pasoꞌama mogofaꞌ bret hiata togalomam. Amom mofaꞌ atotota tala bot ");
INSERT INTO aoj_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Eaꞌ Jisas naumbalom naꞌipam naꞌi, “Ipaꞌ pindimafuma andeandeꞌ, solawaipama yis amamba Farisii maloma yis Herotii.” ");
INSERT INTO aoj_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Eaꞌ mameꞌ anen naꞌias naꞌamba, a mandaꞌipama maꞌi, “Afaꞌ ukup pasoꞌafa bret taꞌihi deiꞌ naꞌipafa naꞌamba.” ");
INSERT INTO aoj_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Jisas nogawa basef amamifi, naꞌipam naꞌi, “Deiꞌ maina ipaꞌ pagaꞌi, ‘Ipaꞌ bret akepa?’ Aꞌi ipaꞌ ukup paseꞌepa, owaꞌ ataꞌ pegawaea? ");
INSERT INTO aoj_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Ipaꞌ naep papaipa, apaꞌ ipaꞌ owaꞌ ataꞌ piti anin maemaea. Eaꞌ aligah hapaipa, apaꞌ ipaꞌ inaꞌ pemeꞌ basef, owaꞌ. Ukup aꞌ paseꞌepa. ");
INSERT INTO aoj_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Afamba aeꞌ agawala bret 5-pelaita ma epes isimba 5000-pelais, ama duꞌwaꞌwanita tagaꞌihi patatamata paloꞌwata folalef maꞌulif siꞌlif?” Eaꞌ amom maꞌi, “12-pelailif.” ");
INSERT INTO aoj_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“Apaꞌ anef nemaf agawala bret 7-pelaita ma duꞌwaꞌwanita tagaꞌihi patatamata paloꞌwata folalef maꞌulif siꞌilif?” Eaꞌ amom maꞌi, “7-pelailif.” ");
INSERT INTO aoj_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Eaꞌ anen naꞌipam naꞌi, “Owaꞌatin. Ipaꞌ ina deiꞌ apegawa, ataꞌ owaꞌ.” ");
INSERT INTO aoj_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Amom mafeꞌ mataga Betsaida, saoꞌwamanai anona aman naep pagasoꞌanai nafiꞌmai Jisas, saꞌipana dindinipa nogasa lagol ananigili nondaꞌana boꞌona. ");
INSERT INTO aoj_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Eaꞌ nahapila lagol anen naep pagasoꞌanai, nofaꞌana nakwaha wambel nawis andoꞌ nisiꞌwafa naep ananipi, nasa lagola anen nahaliꞌana naꞌi, “Inaꞌ nati ambambasif aꞌa ataꞌ owaꞌ?” ");
INSERT INTO aoj_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Eaꞌ aman anamba natologon, naꞌi, ");
INSERT INTO aoj_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","“Aeꞌ ati anis epes apaꞌ agatilis siꞌi lawah hagafeꞌ.” Eaꞌ Jisas nasa lagol wapani, naep ananipi deiꞌ aꞌ natologon mehip naep ananipi apataga beꞌep, andeandeꞌ, nati hiahawes peleleꞌ. ");
INSERT INTO aoj_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Eaꞌ Jisas nasapaꞌana nafeꞌ ipat ananitai naꞌipana naꞌi, “Inaꞌ owaꞌi nefeꞌ niwis wambel niꞌipasa aeꞌ andaꞌena amboꞌwenaia, owaꞌi. Inaꞌ nefeꞌ usiꞌina ipat ineꞌitai.” ");
INSERT INTO aoj_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Jisas nosafel naloma alipumi ananimi mafeꞌ felefeleꞌma anambel wambel Sisaria Filipai. Amom mafeꞌma ufiaꞌw, nahaliꞌam naꞌi, “Esis amam nematawa saꞌi aeꞌ aman mamahowema?” ");
INSERT INTO aoj_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Eaꞌ amom maꞌipana maꞌi, “Anis saꞌi inaꞌ Jon, aman nagapisiꞌas embeli. Eaꞌ anis saꞌi inaꞌ Elaija. Apaꞌ anis saꞌi inaꞌ anina profet, fowaꞌinai. ");
INSERT INTO aoj_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Eaꞌ nahaliꞌam naꞌi, “Deiꞌ ipaꞌ paꞌi aeꞌ ami?” Eaꞌ Pita nagwamana naꞌipana naꞌi, “Inaꞌ Krais, God nandandepena nasapaꞌena nagafiꞌi.” ");
INSERT INTO aoj_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Eaꞌ naꞌipam dindinip naꞌi, “Ipaꞌ ina aꞌ pewalapa aeꞌ piꞌipa anis piꞌi aeꞌ Krais, owaꞌi.” ");
INSERT INTO aoj_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Eaꞌ Jisas nasefela basef ananifi nawalipam naꞌi, “Aeꞌ ataga epen egefaꞌ alop epesi, atiasi agufumi Judai moseꞌe akafimi luꞌwami. Amom moloma amom pris dembami moloma amom dembami magawalipasa muꞌuli Godii. Atiasi mondaiwaꞌme moseꞌe alafugah mohe egaꞌ ma nimaguf bif eaꞌ, fegafeꞌma wanifi aꞌ esafel wapani.” ");
INSERT INTO aoj_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Anen nawalapa basef ifimba alihifa amom. Eaꞌ Pita nofaꞌana nendelefata nasa gemba eaꞌ nagagaolana ma basef ifimba nagaꞌipasafi. ");
INSERT INTO aoj_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Owaꞌ Jisas nandambema natiti alipumi ananimi, nandaꞌ megahaha Pita naꞌi, “Inaꞌ siꞌi Satan. Deiꞌ main, inaꞌ owaꞌ okom mopoma okom Godia. Okom mandapoma nomonas epes sagape itapi atis. Delefata nefeꞌ alafuga aeꞌagai.” ");
INSERT INTO aoj_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Eaꞌ Jisas nofalai esis amam nematawa safiꞌmai anen saloma alipumi ananimi naꞌipas naꞌi, “Iꞌi anin epen niꞌi nila aeꞌ, anin ataꞌ netalogofa okom amambai ananimi atom, nefeꞌ lafel eaꞌ ina ombel mohana anis sohan negagaꞌ, owaꞌ. Aeꞌ efaꞌ akafimi ma andaꞌ maol Godi, atiasi sehe egaꞌ lawag usiꞌigai tiꞌwanaegai. Epen inimba aꞌ nendaꞌas naꞌamba atin siꞌi aeꞌ ma nigagiꞌma aeꞌ. Apaꞌ iꞌi owaꞌ, owaꞌatin. ");
INSERT INTO aoj_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Epen ami okom mopoma ambal ananili atol, niꞌi nihapilal tatalaꞌil, anaf ambal ananili higililal. Apaꞌ epen ami okom mopoma aeꞌ eloma basef buꞌwafi Godi ma nesambala ambal ananili itap apaꞌe, anaf God aꞌ nofaꞌ ambal ananili lotanimai nepe andeandeꞌ lifilafi. ");
INSERT INTO aoj_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Iꞌi epen ami nendaꞌ maol naninani negefaꞌ gwaꞌaimi uga hiahaom hiami itapami atom higiligalami, anin wapani awen higililan nelomam. Deiꞌ hiahaom amamba atiasi motopalopan miꞌimama? Owaꞌatin endilisi. ");
INSERT INTO aoj_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Epen inimba atiasi nefaꞌ hiahaom maima negatal ambal ananili ma nitanima negewambilali wapani? Owaꞌatin. ");
INSERT INTO aoj_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Aeꞌ ataga epen egefaꞌ alop epesi. Amam nematawa deiꞌisi sandaꞌ waf aunai sakwaha sagahapifa Godi. Epes isimba mamahisa ambal aola aeꞌ sondafaꞌme eloma basef aeꞌafi, anaf aeꞌ wapani ambal aola epes isimba endafaꞌmas nemaf afamba aeꞌ ifiꞌi egaloma hiahaom fasimi banagami mogogalaꞌi ahamai elomai amom ensel buꞌwami Godi wapani. ");
INSERT INTO aoj_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Jisas naꞌipa esis naꞌi, “Aeꞌ aꞌipipa endilisi ipaꞌ, anipa pagalutu naꞌaii atiasi ina pegaꞌ ulal, ataꞌ owaꞌ. Anipa apiti banagami Godi moloma anen nogape dembinai kinga epes ananisi.” ");
INSERT INTO aoj_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Aꞌi owaꞌ main, nimaguf wanif wanif fafeꞌma hiꞌalef, Jisas naoꞌwa Pita naloma Jemsi Jon naoꞌwam mondowasaꞌ anota halafuta lautai. Naoꞌwa amom atom tol mape, owaꞌ mati alop ananipi apandati naꞌa pogalaꞌ aꞌowaꞌ. ");
INSERT INTO aoj_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Luwaguf maim ananimi mataga mogalaꞌ afitim aꞌowaꞌ. Ina anona aman itapanai laꞌifina nandaꞌ luwaguf maim mataga afitim naꞌamba, owaꞌatin. ");
INSERT INTO aoj_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Eaꞌ mati amam biam fowaꞌimi, Elaija naloma Moses mataga malutu maꞌi maloma Jisas. ");
INSERT INTO aoj_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","6","Pita naloma Jemsi Jon ombel maham endilisi, eaꞌ Pita naꞌi niꞌi anif basef, owaꞌ, owaꞌatin, anen ina ataꞌ okom mapoma basef naꞌi nigaꞌiefi, aꞌ owaꞌatin. Eaꞌ naꞌias naꞌamba naꞌi, “Dembinai, afaꞌ wape naꞌaꞌe aꞌ fafas, ataꞌ olaꞌ anoh aolah wanoh hondandamepa. Inaꞌ anop, Moses anop, Elaija anop.” ");
INSERT INTO aoj_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Owaꞌ anom ilagw maofana amom. Eaꞌ anagol malogol gaꞌi gatagai ilagw amamba gaꞌi basef gaꞌi, “Anen Nogame aeꞌanai, aeꞌ okom mohafel maimailana aꞌowaꞌ. Ipaꞌ pendameꞌ basef ananifi.” ");
INSERT INTO aoj_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Alipumi Jisasi wanom matologon kwafalis ganigani, apaꞌ ina mati anin epen, owaꞌatin. Mati Jisas atona nalutu nalomam. ");
INSERT INTO aoj_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Eaꞌ amom ataꞌ makwaha halafuta mafiꞌi atin, Jisas naꞌipam dindinip naꞌi, “Ipaꞌ ina pewalapa hiahaom amamba deiꞌ pagatulumi piꞌipa anin epenam, owaꞌi. Apefeꞌ dondoꞌma nemaf afamba aeꞌ ataga epen egefaꞌ alop epesi, ma sehe egaꞌ egesafel matmat wapani, daoꞌ piꞌipas.” ");
INSERT INTO aoj_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Eaꞌ amom mahapila basef ifimba mape, mandaꞌipama maꞌi, “Basef ifimba Jisasi notanima nogosafel matmat, kofagefa fafeꞌ faꞌimama?” ");
INSERT INTO aoj_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Eaꞌ mahaliꞌ Jisas maꞌi, “Deiꞌ maina amom dembami magawalipasa muꞌuli Godi magaꞌi Elaija fowaꞌinai ataꞌ niliꞌ nogafiꞌi?” ");
INSERT INTO aoj_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Jisas nagwamam basef naꞌi, “Ahoꞌ endilisi. Elaija nifiꞌi nondondomba hiahaom hiami hiꞌigalam wapani. Apaꞌ basef fagape buk Baibeli faꞌi dembinai anaf notaga epen nogofaꞌ alop epesi nope niꞌimama? Ifimba faꞌi anen nemeꞌ akafimi luꞌwami ma esis sogowaꞌ alafugahanai. ");
INSERT INTO aoj_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Deiꞌ aꞌipipa, anona Elaija aꞌ nafiꞌi eaꞌ, apaꞌ esis sagiꞌma nomonas asasimi atom, sandaꞌmana waf awafi endilisi siꞌi anif basef fagape buk Baibeli fagaꞌias.” ");
INSERT INTO aoj_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Jisas naloma alipumi wanom mafiꞌi mati anom alipumi duꞌwanim 9-pelaim magapanii, eaꞌ mati amam nematawa hiasi salutu felefeleꞌma amom. Eaꞌ mati anom dembami magawalipasa muꞌuli Godi maꞌi basef mandahihianamaef maloma alipumi Jisasi 9-pelaim. ");
INSERT INTO aoj_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Amam nematawa isimba hiasi sati Jisas nafiꞌi, sosafel gogolalasis kwapeteꞌas, sasagih safeꞌma anen sanifelona. ");
INSERT INTO aoj_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Eaꞌ Jisas nahaliꞌ amom alipumi ananimi naꞌi, “Ipaꞌ palomam paꞌi main pandahihianaman?” ");
INSERT INTO aoj_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Eaꞌ anona aman nagape laꞌafena amam nematawai nagwamana basef Jisas naꞌi, “Dembinai tisa, awani aman aeꞌani anona ambal aunai napain, malogol gasoꞌan. Naꞌamba efaꞌan afiꞌmai inaꞌ. ");
INSERT INTO aoj_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Nimaguf ifimba hiafi ambal anamba aunai nahapilan sisihin nakwahin newa itap. Eaꞌ ofap pataga malogolan, nalelef fendetapaꞌ imun dogw, a alop ananipi dindigisip aꞌowaꞌ. Aeꞌ aꞌipa alipumi ineꞌimi aꞌi motofa ambal anamba aunai nofaꞌ nofoꞌo, apaꞌ amom owaꞌ banagema.” ");
INSERT INTO aoj_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Eaꞌ Jisas nameꞌ basef ifimba, naꞌipas naꞌi, “O, ipaꞌ amam nematawa owaꞌ pegahapifaea. Nimaguf maꞌuf aeꞌ ataꞌ epe elomepa? Nimaguf maꞌuf wapani ma egefaꞌ nimanimi ipeꞌimi? Ipaꞌ okwan nifiꞌmai aeꞌ.” ");
INSERT INTO aoj_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Eaꞌ esis saoꞌwamana awani inimba anen. Ambal anamba aunai nati Jisas, kwafalis atis nakotoꞌ anin kwapeteꞌ, nafeꞌ newa itap hota atin naꞌoh, apah afitimi ofap mataga sisih malogol ananigili. ");
INSERT INTO aoj_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Eaꞌ Jisas nahaliꞌ ahama awani inimbai naꞌi, “Nogamena ineꞌini, aowas inimba nandaꞌan nape nimaguf maꞌuf?” Anen naꞌipana naꞌi, “Fowaꞌ ataꞌ awani nape atapina naꞌamba atin. ");
INSERT INTO aoj_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Dondol ambal aunai nakwahin newala nasef nif, a newala embel naꞌi nohan afin. Apaꞌ iꞌi inaꞌ banagena ma, niti apaꞌ owahipipa netopalopapa.” ");
INSERT INTO aoj_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Eaꞌ Jisas naꞌipana naꞌi, “Deiꞌ maina inaꞌ nagahaliꞌi naꞌamba? Epen ami nigahapifi endilisii, anin banagena maol fasini naninani.” ");
INSERT INTO aoj_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Eaꞌ aman anamba naꞌipa Jisas naꞌi, “Aeꞌ ahapifina kwasakwasala. Deiꞌ netopalope ma igahapifina banagewe endilisi.” ");
INSERT INTO aoj_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Eaꞌ Jisas nati amam nematawa safiꞌi salutu salipana felefeleꞌ, naꞌipa ambal anamba aunai mehip naꞌi, “Inaꞌ ambal awasinai nagasopama aligahi malogol awani inimbai, inaꞌ lofaꞌo nekwaha awani inimba, netanima nigafiꞌmani owaꞌi.” ");
INSERT INTO aoj_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Eaꞌ ambal anamba aunai nakotoꞌan mehip hogaꞌala kwapeteꞌ nakwahowan nandahiꞌ nafeꞌ. Eaꞌ awani inimba aꞌ nandati siꞌi sagagaꞌi eaꞌ hiasi satilin saꞌias naꞌamba saꞌi, “Anin aꞌ nagaꞌ eaꞌ.” ");
INSERT INTO aoj_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Naꞌamba Jisas nahapila lagol ananigili nasoꞌman eaꞌ boꞌwen nalutu. ");
INSERT INTO aoj_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Aꞌi owaꞌ main, Jisas nafeꞌ nawis anota ipat nape naloma alipumi ananimi mape. Eaꞌ mahaliꞌana naꞌamba maꞌi, “Deiꞌ maina afaꞌ owaꞌ banagefama ogatofa ambal anamba aunaia?” ");
INSERT INTO aoj_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Jisas naꞌipam naꞌi, “Ipaꞌ pendabeten pihaliꞌ God atin, ipaꞌ aꞌ banagepa ma pegatofa ambal anambai aunai. Owaꞌ anoꞌw ufiaꞌw daiaꞌwa pegatofanaia. Beten atin.” ");
INSERT INTO aoj_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","31","Eaꞌ Jisas naoꞌwa alipumi ananimi makwaha naꞌamba magapoma mafeꞌ mataga itap apamba Galili mawis mafeꞌ anagon mape. Deiꞌ main, Jisas naꞌi nope nondambahoꞌ nolomama nogawalipama basef ananifi. Naꞌamba nandaiwaꞌma anona aman nogogawa anamba amom mafeꞌ magapoma. Anen nasoꞌama basef naꞌamba naꞌi, “Aeꞌ ataga epen egefaꞌ alop epesi, atiasi felefeleꞌ anona aman nosoꞌasa aeꞌ efeꞌma lagof amom boumi aeꞌami mehe egagaꞌ. Ama nimaguf bif hiꞌilif fegafeꞌma wanifi, aꞌ itanima esafel efaꞌ ambal wapani.” ");
INSERT INTO aoj_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Eaꞌ alipumi ananimi mameꞌ basef ifimba atif, apaꞌ amom ina mogawef, owaꞌ. Naꞌamba amom ombel mahama mogahaliꞌana ma basef ifimba kofagefa. ");
INSERT INTO aoj_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","34","Eaꞌ Jisas naloma alipumi ananimi mafeꞌ mataga Kaperneam, mafeꞌ mawis ipat nomon, Jisas nahaliꞌam naꞌi, “Ipaꞌ paꞌi basef maif, dokoꞌ wagafiꞌi ufiaꞌw?” Dokoꞌ magafiꞌi ufiaꞌw, amom maꞌi basef hiafi maꞌi atiasi ami nepe niliꞌ dembinai ma amom. Owaꞌ inaꞌ magwamana anif basef, owaꞌatin. Tol mape dowaf. ");
INSERT INTO aoj_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Eaꞌ Jisas nape itap nofala amom mafiꞌi mape felefeleꞌ naꞌipam naꞌi, “Epen ami niꞌi netaga dembinai nepe nigaliꞌi, anin ataꞌ niliꞌ netaga siꞌi nandaꞌ maola anasi, netaga falafini ma naep epesi.” ");
INSERT INTO aoj_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Eaꞌ Jisas nasoꞌmai anin awani saꞌwini nahaponan laꞌafena amom nahapilan naꞌipam naꞌi, ");
INSERT INTO aoj_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Epen ami nesoꞌ opafa negatopalopa anin awani siꞌi iniꞌi ma okom ananimi mopoma aeꞌ, anin naseꞌe opaf aeꞌ wapani natopalope. Eaꞌ epen ami negatopalopa aeꞌi, ina natopalopa aeꞌ atowe, owaꞌ. Anin natopalopa anen nasapaꞌe agafiꞌii wapani.” ");
INSERT INTO aoj_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Jon nagwa basef naꞌamba naꞌi, “Dembinai, afaꞌ wati anona aman nandaꞌ maol natofa ambagof awami ma agol ineꞌigili. Apaꞌ anen ina nagiꞌma afaꞌ owaꞌ, eaꞌ deiꞌ wasopamana.” ");
INSERT INTO aoj_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Owaꞌ Jisas naꞌipana Jon naꞌi, “Ipaꞌ ina apesopamana, owaꞌi. Epen mamahina nandaꞌ maol fasini ma agol aeꞌagili, anin ina aꞌ niꞌipasa basef awafi ma aeꞌ, owaꞌ. ");
INSERT INTO aoj_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Epen ami owaꞌ bouni afeꞌinia, inimba alipini afaꞌini. ");
INSERT INTO aoj_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Aeꞌ aꞌipipa endilisi, epen ami nitilipa niꞌi ipaꞌ epes aeꞌipai ma netopalopepa neseꞌepa anin mai saꞌwini siꞌi embel kwaiaꞌumbel peaꞌambal, owagama God nogwaman hiahaom fasimi anin. ");
INSERT INTO aoj_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Jisas naꞌipas naꞌamba naꞌi, “Iꞌi anin epen nendaꞌ anin epen saꞌwini nagahapifa aeꞌi, nefeꞌ nendaꞌ waf awafi, atiasi epen inimba nefaꞌ akafimi awami. Anis epes sofaꞌ epen inimba sondola otam luꞌunai nila biniꞌw ananiꞌwi sofaꞌan sofeꞌ solan newala naoh mami luꞌwami, ataꞌ nepe andeandeꞌ kwasakwasala. Apaꞌ iꞌi epen inimba nendaꞌ anin saꞌwini negakwaha nagahapifa aeꞌ, epen inimba atiasi nepe awen aꞌowaꞌ nikilaꞌ negewala naoh laumi. ");
INSERT INTO aoj_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Eaꞌ iꞌi lagof ipeꞌigufi fondaꞌepa pewa ma waf awafi, petopaꞌagof pekwahogof. Eaꞌ atogol atin fope, ma ambal lopaipa pegape andeandeꞌ lifilafi. Naꞌamba lagof agwafomba fandaꞌ waf awafii fope, fofaꞌepa pefeꞌ wambel awambili nif fagape lifilafima. ");
INSERT INTO aoj_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Wambel ambalemba endihip saꞌusaꞌumi namugopim atapim magape lifilafii, magagugumba epesi, eaꞌ nif ifimba wapani ina hiꞌagalafi, owaꞌatin. ");
INSERT INTO aoj_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Iꞌi boꞌwagah ipeꞌigahi hondaꞌepa pewa ma waf awafi, petopaꞌagah pekwahogah. Eaꞌ atoga atin hope, ma ambal lopaipa pegape andeandeꞌ lifilafi. Naꞌamba boꞌwagah agahemba handaꞌepa pandaꞌ waf awafii hope, hofaꞌepa pefeꞌ wambel awambili, nif fagape lifilafima. ");
INSERT INTO aoj_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Wambel ambalemba endihip saꞌusaꞌumi namugopim atapim magape lifilafii, magagugumba epesi, eaꞌ nif ifimba wapani ina hiꞌagalafi, owaꞌatin. ");
INSERT INTO aoj_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Iꞌi naep ipeꞌipi pendaꞌepa pewa ma waf awafi, pigip pikwahip. Atom atin pepe ma pegafeꞌ anamba God nagalaꞌambemagoma pegape andeandeꞌ lifilafima. Naꞌamba nam amamba mandaꞌan nandaꞌ waf awafii mope, aꞌ mofaꞌan nefeꞌ wambel awambili nif fagape lifilafiima. ");
INSERT INTO aoj_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Wambel ambalemba endihip saꞌusaꞌumi namugopim atapim magape lifilafii, magagugumba epesi, eaꞌ nif ifimba wapani ina hiꞌagalafi, owaꞌatin. ");
INSERT INTO aoj_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","50","“Anef nemaf epes hiasi hiꞌilas sogameꞌ akafimi luꞌwami siꞌi nif mondaꞌas sogape beꞌes hililiꞌ. Sol usihili fasili ma gwaꞌaimi, apaꞌ sol owaꞌ usihilia, deiꞌ atiasi pendaꞌal piꞌimama usihil wapani? Owaꞌatin. Ipaꞌ pandaꞌ sola gwaꞌaisi usihis. Eaꞌ ipaꞌ naꞌamba atin siꞌi sol usihili, opalef ipeꞌilifi atifilif pendaloma sahin owan hiasi petopalopas.” ");
INSERT INTO aoj_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Jisas nakwaha wambel ambalemba, nafeꞌ anep itap luꞌupa Judiai nambo walemb Jordan gani fisana. Eaꞌ amam nematawa hiasi safiꞌmai anen wapani, nasoꞌasa basef siꞌi dondol nagawalipas. ");
INSERT INTO aoj_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Eaꞌ anom dembami Farisi mafiꞌi mahaliꞌ Jisasa anif basef magwambana maꞌi, “Muꞌuli apeꞌini andeandeꞌma anona aman nondaiwaꞌma nemataꞌw ananiꞌwi nogaliꞌamonaꞌw aꞌa owaꞌ?” ");
INSERT INTO aoj_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Eaꞌ Jisas nagwamam basef naꞌipam naꞌi, “Moses naseꞌepa muꞌuli mamahina?” ");
INSERT INTO aoj_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Amom magwamana maꞌipana maꞌi, “Moses naꞌi ahoꞌma anona aman niꞌi nogaliꞌamona akoꞌwi, niꞌi anif basef fil okwatip nosoꞌakwap niliꞌamonaꞌw kofeꞌ.” ");
INSERT INTO aoj_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Owaꞌ Jisas naꞌipam naꞌi, “Ipaꞌ pandaꞌ duꞌwaniga, deiꞌ Moses nandaꞌmepa muꞌuli inimba. ");
INSERT INTO aoj_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Fowaꞌ gani dambadamba God nandaꞌ hiahaom hiami, ‘Nandaꞌ epes eaꞌ sataga suwafisi numaꞌisi.’ ");
INSERT INTO aoj_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","God naꞌias naꞌamba naꞌi, ‘Esis bias ina ataꞌ sope siꞌi sagape daindai, owaꞌ. Aman nokwaha mamasana ananisi nefeꞌ noloma wauluꞌmana ananiꞌwi, esis bias asope alop atotop. ");
INSERT INTO aoj_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Eaꞌ esis bias sondasoꞌama sotaga siꞌi alop atifip.’ Esis ina ataꞌ siꞌi sagape biasa sagape daindai, owaꞌ. ");
INSERT INTO aoj_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Eaꞌ hiahawes mais God aꞌ nagapeteꞌas sisihisi, isimba anin epen ina nehapeꞌas, owaꞌi.” ");
INSERT INTO aoj_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Aꞌi owaꞌ main, Jisas naoꞌwa alipumi ananimi mafeꞌ mawis mape ipat, mahaliꞌana ma waf afamba sandasoꞌamafi. ");
INSERT INTO aoj_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Jisas naꞌipam naꞌi, “Aman ami nagakwaha wauluꞌmana ananiꞌwi ma nagasoꞌ anoꞌw daiaꞌw wapanii, anen nandaꞌ waf awafi soꞌa waola nemataꞌw akwamba naliꞌ nagasoꞌakwi. ");
INSERT INTO aoj_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Eaꞌ naꞌamba atin, iꞌi nemataꞌw ami kokwaha anona kosoꞌ anona daiana, akoꞌw kwawala waf buꞌwafi kwatopaꞌ dasoꞌama kwandaꞌ waf awafi soꞌa waulafi ma anen naliꞌ nagasoꞌakwi.” ");
INSERT INTO aoj_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Eaꞌ esis saoꞌwamanai anis awasi saꞌwisi sofaꞌas safiꞌmai Jisas, saꞌi anen nosa lagofa nigaꞌipasa basef fasifi awasi isimba. Owaꞌ alipumi ananimi mandaiwaꞌma esis awasi isimba eaꞌ masopama esis sofaꞌas sogafiꞌmai anen. ");
INSERT INTO aoj_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Eaꞌ Jisas nati amom mandaꞌ waf afambai, anen aꞌ nembel awambela amom aꞌ naꞌipam, naꞌi, “Ipaꞌ kwahowa awasi isimba sifiꞌmai aeꞌ. Ipaꞌ ina pihagasis, owaꞌi. Esis amam nematawa sogawis nomona maol Godi nope Dembinai nugumafiasi sameꞌ basef ananifi sagailif siꞌi awasi isimba. ");
INSERT INTO aoj_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Aeꞌ aꞌipipa endilisi, epen ami niꞌi ahoꞌma God nope dembinaiman ama neseꞌana nembel God siꞌi awasi isimba sagaꞌi ahoꞌmana, isimba sandaꞌas naꞌambai atiasi sogawis anamba God nagalaꞌam bemagomai. Iꞌi owaꞌ, owaꞌatin.” ");
INSERT INTO aoj_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Eaꞌ anen nasaꞌma awasi isimba nahapilas satoma boꞌwagah ananigahi nasa lagof ananigufi balagah asasigahi naꞌipasa basef fasifi nowaꞌ banagas. ");
INSERT INTO aoj_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Jisas nosafel nafeꞌ, anona aman nasagih nafiꞌmai anen nindiwa nembawa notawa nahaliꞌana naꞌi, “Tisa buꞌwinai, aeꞌ atiasi endaꞌ maina egefaꞌ ambal namili egape andeandeꞌ lifilafi?” ");
INSERT INTO aoj_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Eaꞌ Jisas naꞌipana naꞌi, “Deiꞌ maina inaꞌ nagaꞌi aeꞌ buꞌuwai? God atona anen buꞌwinai. ");
INSERT INTO aoj_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Inaꞌ negawa muꞌuli God nagasoꞌ Mosesani nagaꞌi, ‘Inaꞌ owaꞌi nendaꞌ waf awafi soꞌa waulafi neha anis sogaꞌ a nendaꞌ wal, owaꞌi, inaꞌ owaꞌi nembasoꞌma anis epes daiasa, eaꞌ ina nembasoꞌam banagena ma negefaꞌ anom hiahaom anasi dowadowaf, owaꞌi. Inaꞌ nemeꞌ basef mamasinai nihapilif nilif nindimafias andeandeꞌ.” ");
INSERT INTO aoj_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Eaꞌ aman anamba naꞌipa Jisas naꞌi, “Tisa, muꞌuli inimba hiani ahapilan ailan fowaꞌ ataꞌ awani afiꞌi afiꞌi ataga deiꞌ.” ");
INSERT INTO aoj_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Eaꞌ nomonas Jisasi sohafela anen saisailana, naꞌipana naꞌi, “Inaꞌ anef waf fasifi atetef owaꞌ ataꞌ nendaꞌafa. Inaꞌ foꞌo neseꞌasa hiahaom ineꞌimi ma anis daias sotalinama nefaꞌ moni inimba nendaꞌan nesoꞌ isimba kwahusi. Nendaꞌas naꞌamba ma anaf negefaꞌ hiahawes fasisi gani ilif. Eaꞌ nifiꞌi nihapifi nila aeꞌ.” ");
INSERT INTO aoj_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Owaꞌ aman anamba hiahaom hiamunai nandaiwaꞌma nondaꞌam nogasoꞌ anis epes daias. Eaꞌ nomonas ananisi iwanis nandambema megahaihailana nafeꞌ. ");
INSERT INTO aoj_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Eaꞌ Jisas natologon ganigani naꞌipa alipumi ananimi naꞌi, “Epes isimba ugai moni hianaisi sandaꞌam da ndaꞌ ahifim aꞌowaꞌ ma sefeꞌ sogawis nomona maol Godi nope Dembinai nugumafias. Atona atin sefeꞌ suwis.” ");
INSERT INTO aoj_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Eaꞌ amom mosafel gogolalasoma basef ifimba nagaꞌipamafi. Owaꞌ Jisas nagwamama basef wapani naꞌi, “Owape aeꞌipai, ufiaꞌw kwagafeꞌ anambai ina andipaꞌwi, owaꞌ, ahifiꞌwi. ");
INSERT INTO aoj_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Anin mafin luꞌunai kamel nogawis bolotaf nil sogosambala luwagufeli, anamba ila ina ahifima aꞌowaꞌ ma nogawis. Apaꞌ amam nematawa hiahaom hiamisi iꞌi sofeꞌ sogawis nomona maol Godi, sondaꞌam da ndaꞌ ahifim aꞌowaꞌ ma sofeꞌ sogawis. Maol inimba ahifim aꞌowaꞌ nikilaꞌ maol kamel nogawis bolotaf nili.” ");
INSERT INTO aoj_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Owaꞌ alipumi ananimi mosafel gogolalasom kwapeteꞌam mandaꞌipama maꞌi, “Iꞌi naꞌambaiai, anaf God nuwambilai epes mamahisa nokwahomas waf awafi sotanimai sope andeandeꞌ lifilafi? Owaꞌatin.” ");
INSERT INTO aoj_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Eaꞌ Jisas nasaꞌma naep natiti amom naꞌipam naꞌi, “Hiahaom epes owaꞌ laꞌifisa sondaꞌamia, amamba God atona banagonai ma nondaꞌam. Anen banagonai ma nondaꞌ hiahaom hiami hiꞌigalam.” ");
INSERT INTO aoj_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Eaꞌ Pita nasefela basef naꞌipana naꞌi, “Nemeꞌ, afaꞌ wakwaha hiahaom afaꞌimi hiami, deiꞌ wafiꞌi wahapifa basef ineꞌifi wailina.” ");
INSERT INTO aoj_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","30","Eaꞌ Jisas naꞌipana naꞌi, “Ahoꞌ endilisi, aeꞌ agaꞌipipa naꞌamba aꞌi, Ipaꞌ epes ami ukup pegapoma aeꞌ eloma basef buꞌwafi Godi ma sokwaha ifagw gwoloma sahin owan ahasas mamasas a batawisas soloma aofah mais asasisi, atiasi asofaꞌ hiahawes isimba dambaisi hiasi aꞌowaꞌ, sikilaꞌ asasisi fowaꞌisi. Eaꞌ anis daias atiasi sehepa sondaꞌmepa was awafi. Apaꞌ anaf owagama nogota buꞌutai togataga, pefaꞌ ambal namili pepe andeandeꞌ lifilafi. ");
INSERT INTO aoj_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Apaꞌ epes hiasi deiꞌ sataga sagaliꞌi agof fagatomasi, anaf agof akas asotaga sigiꞌ. Apaꞌ epes isimba sataga sagagiꞌi anaf aꞌ agof fotomas sotaga siliꞌ.” ");
INSERT INTO aoj_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Esis saila ufiaꞌw safeꞌ sondowasaꞌ Jerusalem, Jisas nafeꞌ naliꞌas. Eaꞌ alipumi ananimi magiꞌmana mafeꞌ. Amom mogawa anen aꞌ nafeꞌ Jerusalem, naꞌamba deiꞌ amom agogolalasom. Esis sagagiꞌma amomi, esis wapani sogawa anen nofeꞌ Jerusalem eaꞌ ombel mahas. Eaꞌ Jisas naoꞌwa alipumi atom mafeꞌ mape anagon dei, naꞌipam hiahaom amamba atiasi mogatagamanai. ");
INSERT INTO aoj_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Naꞌipam naꞌi, “Pemeꞌ. Deiꞌ afaꞌ eaꞌ ondowasaꞌ Jerusalem. Aeꞌ ataga epen egefaꞌ alop epesi, atiasi anona aman nondaꞌe efeꞌma amom pris dembami moloma amom dembami magawalipasa muꞌuli Godi eaꞌ mondaꞌ kotimi aꞌ miꞌi basef mondameꞌmaefa mohe egagaꞌ. Eaꞌ mondaꞌe efeꞌma esis sogolalama Godi ma ");
INSERT INTO aoj_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","sondaꞌ salamala aeꞌ sondaꞌe findiwae sisisiꞌwafe sopopagahowe eaꞌ sehe egaꞌ. Ama nimaguf bif hiꞌilif, anef fefeꞌ fegataga wanifi aꞌ itanima esafel wapani.” ");
INSERT INTO aoj_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Jemsi Jon, Sebedi nogaopana mafiꞌi mahaliꞌ Jisas maꞌi, “Dembinai tisa, afaꞌ biafa waꞌi uhaliꞌina ma anif basef eaꞌ nendaꞌmafaef afaꞌ biafa.” ");
INSERT INTO aoj_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Eaꞌ Jisas nahaliꞌam naꞌi, “Ipaꞌ paꞌi endaꞌmepa main?” ");
INSERT INTO aoj_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Eaꞌ maꞌipana maꞌi, “Anaf owagama inaꞌ netaga negefaꞌ agol luꞌwagili mogogalaꞌi gani wambel Godi, nemaf afamba afaꞌ waꞌi inaꞌ nendaꞌafa ope dembefa wil olomena waꞌowaꞌol anona nil waꞌol egawama aꞌ anona nil waꞌol daꞌasaigilima.” ");
INSERT INTO aoj_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Owaꞌ Jisas naꞌipam naꞌi, “Ipaꞌ bipa ina pegawa andeandeꞌma hiahawes pagahaliꞌimasi, owaꞌ! Ipaꞌ banagepama pegaꞌ embela kap apamba deiꞌ egaꞌ embelapi, aꞌa owaꞌ?” Jisas naꞌipam naꞌamba eaꞌ naꞌipam wapani naꞌi, “Ipaꞌ bipa banagepama pegefaꞌ baptais isimba deiꞌ egefaꞌasi aꞌa owaꞌ?” ");
INSERT INTO aoj_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Eaꞌ magwamana maꞌipana maꞌi, “Afaꞌ ila laꞌififai.” Jisas naꞌipam naꞌi, “Endilisi, kap apamba deiꞌ aeꞌ egaꞌ embelapai, a saꞌof inimba atiasi egasaꞌofani siꞌi baptaisi, isimba ipaꞌ atiasi pegefaꞌasi. ");
INSERT INTO aoj_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Apaꞌ pegape lagol kwahisigili o gagaili aeꞌagufi, isimba ina maol aeꞌani, owaꞌ. God atona niꞌi esis isimba aꞌ nandandepas eaꞌi daoꞌ, esis atis sope lagof kwahisigili gagaili aeꞌagufi.” ");
INSERT INTO aoj_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Eaꞌ alipumi duꞌwanim ilifunamaim mameꞌ amom biam maꞌias naꞌamba, mandaꞌ megahaha Jemsi Jon. ");
INSERT INTO aoj_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Eaꞌ Jisas nofala amom hiami mafiꞌmai anen, naꞌipam atin naꞌi, “Ipaꞌ pegawa epes sogolalama Godi saꞌi agufumi asasimi dembami, amom mape ilifa esis aꞌowaꞌ mandaꞌmas dondog mandaꞌas kwapeteꞌas. Eaꞌ mape banagem aꞌowaꞌ mandaꞌ esis amam nematawa sogaila malogof amamugufi. ");
INSERT INTO aoj_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Apaꞌ waf afambai ina aꞌ fepoma ipaꞌ, hapaifi. Aman ami nogape dembinai ma ipeꞌi, anen ataꞌ niliꞌ nope siꞌi nandaꞌ maola ipaꞌ hipaii. ");
INSERT INTO aoj_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","45","Aeꞌ ataga epen egefaꞌ alop epesi ina afiꞌima esis sondaꞌme maola sogatopalope, owaꞌ. Aeꞌ afiꞌi endaꞌ maol egatopalopa ipaꞌ hipai ma waf awafi fagawasipai. Aeꞌ afiꞌi ma sehe egaꞌ etala ipaꞌ peloma epes hiasi igatawahipama waf awafi ipeꞌifi. Eaꞌ aman ami niꞌi nogataga dembinai ma ipeꞌi, anen ataꞌ niliꞌ nope siꞌi agol akanai nondaꞌmasa maol hiasi dowadowaf.” ");
INSERT INTO aoj_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Jisas naoꞌwa alipumi ananimi mafeꞌ mataga Jeriko. Eaꞌ maꞌi mokwaha Jeriko mefeꞌ moloma amam nematawa hiasi, mataga ufiaꞌw kwagawisi wambili, owaꞌ, anona aman naep pagasoꞌanai Bartimeas, nogama Timeusi, tol nape felefeleꞌma ufiaꞌw. Anen nape nandailasa otamba gwaꞌaisi mais sogasoꞌana. ");
INSERT INTO aoj_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Bartimeas nameꞌ basefa Jisas Nasaretinai nafiꞌi nape, eaꞌ nofalana mehip naꞌi, “Jisas, akunamana Deviti, inaꞌ niti aeꞌ uwahipiwi.” ");
INSERT INTO aoj_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Owaꞌ esis hiasi sinifalona saꞌi, “Inaꞌ sopama malogol.” Owaꞌ anen fala atin nape naꞌi, “Jisas inaꞌ akunamana Deviti, netelowe uwahipiwi.” ");
INSERT INTO aoj_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Eaꞌ Jisas nafiꞌi nalutu naꞌi, “Falana nifiꞌmai.” Eaꞌ saꞌipana saꞌi, “Nomonas banages. Safel! Jisas aꞌ nofalinai.” ");
INSERT INTO aoj_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Eaꞌ anen nakwaha saket ananitai nosafel kwafalis nafeꞌma Jisas. ");
INSERT INTO aoj_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Eaꞌ Jisas naꞌipana naꞌi, “Inaꞌ naꞌi aeꞌ endaꞌmena main?” Eaꞌ naꞌipana naꞌi, “Dembinai tisa, aeꞌ aꞌi iti andeandeꞌ wapani.” ");
INSERT INTO aoj_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Eaꞌ Jisas naꞌipana naꞌi, “Ipaꞌ foꞌo. Inaꞌ eaꞌ nahapifa aeꞌ banagiwai ma andaꞌena boꞌwena wapani.” Eaꞌ kwafalis atis naep apatiana andeandeꞌ nagiꞌma Jisas nafeꞌ ufiaꞌw. ");
INSERT INTO aoj_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Jisas naloma alipumi ananimi mafeꞌ mataga felefeleꞌma Jerusalem, eaꞌ mataga Betfagai Betani walemb ambalemba bialemb, felefeleꞌma halafuta Oliv. Eaꞌ Jisas nasapaꞌ alipumi ananimi biam ");
INSERT INTO aoj_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","naꞌipam naꞌi, “Ipaꞌ bipa pefeꞌ wambel bambalimba bagape gani waꞌili felefeleꞌma naꞌai. Pefeꞌ piwis wambel ambalemba, piti anona donki saꞌunai sandolana nail. Ina deiꞌ anona aman aꞌ natomana, ataꞌ owaꞌatin. Petagwahona pefaꞌana pifiꞌmai aeꞌ. ");
INSERT INTO aoj_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Iꞌi anin epen nigahaliꞌipa nigaꞌi, ‘Ipaꞌ pafiꞌi pandaꞌas naꞌamba ma main?’ Ipaꞌ piꞌipana piꞌi, ‘Dembinai afaꞌinai naꞌipafa naꞌi nondaꞌ maolana ma bola nosapaꞌana notanimamipai kwafalis.’” ");
INSERT INTO aoj_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","5","Eaꞌ amom biam mafeꞌ mati anona donki saꞌunai sapeteꞌana nail ipat uta andoꞌ felefeleꞌma ufiaꞌw. Amom ataꞌ matagwahona atin owaꞌ, anis salutu felefeleꞌ sahaliꞌam saꞌi, “Ipaꞌ patagwaha donki anamba ma main?” ");
INSERT INTO aoj_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Eaꞌ maꞌipas siꞌi Jisas dokoꞌ nagaꞌipam. Eaꞌ saꞌi ahoꞌma amom mogofaꞌ donki anamba. ");
INSERT INTO aoj_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Eaꞌ mofaꞌana mafiꞌmai Jisas, mawamona sagegw amamugwi gwatoma donki anamba Jisas natomagw. ");
INSERT INTO aoj_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Eaꞌ esis hiasi sandombamana sagegw ufiaꞌw. Anis satopaꞌi apulita lawah hogatawa aof felefeleꞌi sasoꞌwiam ufiaꞌw sofaloꞌmaꞌw. ");
INSERT INTO aoj_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Esis hiasi saliꞌ sagiꞌ safela aoꞌaligil naꞌamba saꞌi, “Hosana. Apaꞌ mandanifal endilisi ma inaꞌ. Apaꞌ maꞌi God nofaloꞌma inaꞌ nagafiꞌi agol ananigilii neseꞌena banagami ma nendaꞌ maol ananini. ");
INSERT INTO aoj_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Fowaꞌ gani God nandaꞌ akunamapa apeꞌinai Devit nape dembinai ma esis nugumafias. Deiꞌ awi God nondaꞌ inaꞌ andeandeꞌ, nepe Dembinai ma apaꞌ nimafiapa siꞌi Devit fowaꞌ nape dembinai nugumafias. Hosana. Apaꞌ mondafela agol Godi golota ilif endilisi.” ");
INSERT INTO aoj_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Eaꞌ Jisas nataga nawis Jerusalem nafeꞌ nawis ipat Godi luꞌunai. Nawis nati hiahaom nafeꞌma hiꞌalam, awin naꞌi aꞌ newala, naoꞌwa alipumi 12-pelaim ananimi mafeꞌ Betani. ");
INSERT INTO aoj_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Wafilu Jisas naloma alipumi ananimi mohafel makwaha Betani mafiꞌi atin, owaꞌ Jisas aꞌ nolomahana. ");
INSERT INTO aoj_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Eaꞌ nalutu nati anoga lawag agiligama fik gotawai laogon felefeleꞌ, agog aꞌ apuliga. Eaꞌ nafeꞌ felefeleꞌ nowandoꞌma saꞌutip. Apaꞌ ina nati anip pailaga, owaꞌ. Nati apul atom. Nogota gogailatai ataꞌ owaꞌ totagaea. ");
INSERT INTO aoj_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Eaꞌ Jisas naꞌipaga naꞌi, “Ina ataꞌ nil nela anip saꞌutip wapani, aꞌ owaꞌatin endilisi.” Eaꞌ alipumi ananimi mameꞌ basef ifimba nagaꞌipagaefi. ");
INSERT INTO aoj_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Jisas naloma alipumi ananimi mafeꞌ mataga Jerusalem, eaꞌ nawis ipat luꞌunai Godi naliꞌamona esis hiasi sandaꞌ bisnisi saloma isimba sagatalom ipat anamba nomoni sawisi andoꞌ. Anom amam mati otamba anisi mindisilaꞌmamba. Eaꞌ Jisas nambema tebolifah amamisi nakoloꞌwas. Anis sandaꞌ bisnisa sogatala amiguf maꞌunamb. Eaꞌ nambema siaifah asasisi nakoloꞌmasas wapani. ");
INSERT INTO aoj_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Eaꞌ nandaꞌimagon naꞌi, “Ina ataꞌ sofaꞌ anom hiahaom amamba suwisi nomon wapani ipat anamba sandakolas sagapoma, aꞌowaꞌ.” ");
INSERT INTO aoj_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Eaꞌ naꞌipas basef Godi fagail Baibeli naꞌi, “Ipat aeꞌanai nondapoma esis sagape ganimba walemb hiagomai ma sifiꞌi sopaona sondabeten sogahaliꞌi. Apaꞌ owaꞌ, aꞌ pandaꞌana nataga siꞌi sandambahoꞌ sandaꞌ wala.” ");
INSERT INTO aoj_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Amam nematawa hiasi gogolalasisa basef ananifi. Isimba atis pris amamba dembami maloma dembami mogawalipasa muꞌuli Godi aꞌ ombal bahama anen. Eaꞌ malaꞌ molaoma ufiaꞌwa mohana nogagaꞌ. ");
INSERT INTO aoj_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Aꞌi owaꞌ wambomota, Jisas naoꞌwa alipumi ananimi makwaha Jerusalem aꞌ mafeꞌ. ");
INSERT INTO aoj_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Wafilu kuhimbita atota Jisas naloma alipumi ananimi mafeꞌ mati lawag agamba fik bowaga aliga, soh haloma nombalef alim hiꞌalam. ");
INSERT INTO aoj_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Pita natologa, okom mapoma Jisas nagaꞌiefi basefa lawag agamba eaꞌ naꞌipana naꞌi, “Dembinai tisa, inaꞌ niti lawag agaꞌe nambatiꞌ inaꞌ nagaꞌipagai, aꞌ aliga hiꞌalaga.” ");
INSERT INTO aoj_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Eaꞌ Jisas nagwamama basef amom naꞌipam naꞌi, “Ipaꞌ pihapifa God. ");
INSERT INTO aoj_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Endilisi aeꞌ aꞌipipa, epen ami owaꞌ okom bimbiafim mopoina ma anin okom atifim nihapifi endilisi niꞌipa halafuta tatumba niꞌi, ‘Inaꞌ dagia aꞌ nefeꞌ newala naoh,’ endilisi God atiasi aꞌ nondaꞌam motaga siꞌi anin okom mandandaꞌ. ");
INSERT INTO aoj_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Iꞌi ipaꞌ piꞌi pendabetena anis maemaefah piꞌi pefaꞌas, ipaꞌ pihapifa God endilisi pendabeten piꞌi, ‘Ahoꞌ endilisi, afaꞌ atiasi ogofaꞌasi,’ Ma atiasi pefaꞌas siꞌi pagaꞌias. ");
INSERT INTO aoj_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Afamba ipaꞌ pilutu pendabeten, pekwahomasa waf awafi anis sandaꞌmepafi, ukup peseꞌepaf. Ama Ahamepa nagape heveni okom mogasoꞌanafa ipaꞌ wapani. ");
INSERT INTO aoj_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Apaꞌ ipaꞌ iꞌi owaꞌ ukup peseꞌepafa, Ahamepa nagape heveni ina okom mosoꞌanafa ipaꞌ, owaꞌatin.” ");
INSERT INTO aoj_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Eaꞌ Jisas naloma alipumi ananimi mafiꞌi Jerusalem wapani, eaꞌ nafeꞌ nawis ipat luꞌunai Godi sandakolasa. Anen ataꞌ nafeꞌ atin, owaꞌ pris dembami maloma anom dembami magawalipasa muꞌuli Godii maloma agufumi esis Judai mafiꞌmai anen. ");
INSERT INTO aoj_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Eaꞌ mahaliꞌana maꞌi, “Inaꞌ nefaꞌ agol maigila deiꞌ nandaꞌ waf afambai? Ami naꞌipina ma negape dembinai ma nandaꞌ maol inimba?” ");
INSERT INTO aoj_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Eaꞌ Jisas nagwamam basef naꞌi, “Aeꞌ wapani, aꞌi ihaliꞌipa ma anif basefa ipaꞌ ataꞌ piliꞌ piꞌipif aeꞌ, ma bola igaꞌipipa ami naꞌipi ape dembiwai andaꞌ maol inimba. ");
INSERT INTO aoj_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Jon nagapisiꞌ amam nematawa hiasi, ami naꞌipana napisiꞌas? God nagape heveni naꞌipana napisiꞌas aꞌa anin epen itapani naꞌipana? Ipaꞌ pegwamef piꞌipif.” ");
INSERT INTO aoj_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Eaꞌ mameꞌ basef ifimba mandaꞌipama maꞌi, “Afaꞌ ugaꞌi, ‘God nagape heveni naꞌipa Jon nagapisiꞌas,’ naꞌamba atiasi aꞌ niꞌipa afaꞌ niꞌi, ‘Deiꞌ maina ipaꞌ owaꞌ pegahapifanaia?’ ");
INSERT INTO aoj_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Apaꞌ afaꞌ ugaꞌi, ‘Anin epen itapani naꞌipana nagapisiꞌas,’ naꞌamba esis amam nematawa aꞌ sohafa.” Deiꞌ main, esis hiasi saꞌi Jon anen profet endilisinai. Amom aꞌ ombel mahama esis. ");
INSERT INTO aoj_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Eaꞌ magwamana basef maꞌi, “Afaꞌ owaꞌ ogawama.” Eaꞌ Jisas naꞌipam naꞌi, “Aeꞌ naꞌamba atin, ina iꞌipipa ami naseꞌe banagami naꞌipi andaꞌ maol inimba aeꞌani.” ");
INSERT INTO aoj_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Jisas nandaꞌ anif basef waminif atina esis naꞌi, “Anona aman nandaꞌ anof aof nagawa waina nahefagomaf. Aof afamba nomon nandaꞌ anona tang notawa ma sogafaꞌasa saꞌutip ipimba wainip. Anen nalaꞌ anota ipat lautai totawa ma sope sugumafiagon. Eaꞌ nakwahomam aof afamba anom amam maꞌi mondaꞌ maolanaf. Anen nafeꞌ napani anambel wambel lauguni. ");
INSERT INTO aoj_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Ama nogota saꞌutip pagailatai, anen kofagonama aof afambai nasapaꞌ anona nandaꞌ maoli nafeꞌ ma amom mandaꞌ maol aof ananifi. Eaꞌ naꞌi amom mosoꞌana anip saꞌutip gwaꞌaipi ma aof afamba. ");
INSERT INTO aoj_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Owaꞌ mombaloꞌana mahana maliꞌamonana notanima nafeꞌ dowaf. ");
INSERT INTO aoj_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Eaꞌ anen kofagonama aofi nasapaꞌ anona daiana nafeꞌ wapani ma mogasoꞌana anip saꞌutip. Owaꞌ mombaloꞌana wapani mahana mawala balagana mandaꞌana kwapeteꞌana. ");
INSERT INTO aoj_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Eaꞌ kofagonama aofi nasapaꞌ anona daiana nafeꞌ wapani owaꞌ, aꞌ mahana afuna, kofagonama aofi nasapaꞌ anom hiami mafeꞌ. Owaꞌ, mahami atin anom afum. ");
INSERT INTO aoj_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Aꞌi owaꞌ nagiꞌ nasapaꞌ atotona nagapani wapani. Anamba nogamana ananinai. Nomonas ananisi sohafel sagasagailanai aꞌowaꞌi. Eaꞌ nasapaꞌana nafeꞌma amom mandaꞌ maol aofi. Anen kofagonama aofi naꞌias naꞌi, ‘Atiasi ila, amom aꞌ memeꞌ malogol nogame aeꞌanai. ");
INSERT INTO aoj_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Owaꞌ amom mati anen nafiꞌi mandaꞌipama atin maꞌi, ‘Aman nanumba maꞌuna owagama nogofaꞌ hiahaom hiami ahamanai. Awi aꞌ ohana afuna, ma afaꞌ atofa ogofaꞌ aof afaꞌe.’ ");
INSERT INTO aoj_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Eaꞌ mombaloꞌana mahana afuna makwaha alop ananinai nawis naꞌoh aof andoꞌ. ");
INSERT INTO aoj_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Eaꞌ atiasi anen kofagonama aof afambai nondaꞌ maina amom? Atiasi nifiꞌi aꞌ noham aꞌ afum hiꞌilam, nosoꞌasa aof afamba fefeꞌma anis epes daias. ");
INSERT INTO aoj_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Ipaꞌ patalifa basef Godi pegawef eaꞌ. Basef Baibeli fagaꞌi naꞌamba faꞌi, ‘Otam amamba magalaꞌ ifagwi mogelefatami deiꞌ mataga mape otam banagami mape magaliꞌi mogombaloꞌ ipati. ");
INSERT INTO aoj_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Dembinai nandaꞌ amamba mataga, apaꞌ matolom fasifasim aꞌowaꞌ agogolalasapa.’” ");
INSERT INTO aoj_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Eaꞌ amom agufumi esis Judai mogawa anen naꞌi basef ifimba waminif atini nondolaꞌwaifa amom. Eaꞌ maꞌi aꞌ mombaloꞌana. Owaꞌ, ombel mahama esis amam nematawa hiasi. Eaꞌ makwahona mafeꞌ. ");
INSERT INTO aoj_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Eaꞌ amom agufumi Judai masapaꞌ anom Farisi maloma anom daiam miniꞌap Heroti mafeꞌma Jisas maꞌi memeꞌ anif basef ananifi owaꞌ andeandeꞌia ma mondaꞌmana basef mogowaꞌana siꞌi sogapaloꞌ agof anembeh. ");
INSERT INTO aoj_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Amom mafiꞌi makikipana maꞌi, “Dembinai Tisa, afaꞌ ogawena inaꞌ aman nagaꞌi endilisii. Owaꞌ nigaꞌipasa anif basef isimba anis agof luꞌwagufisia a anif basef daifa isimba agof akasi falafisia, owaꞌatin. Inaꞌ nagaꞌipasa basef endilisifi atif Godi amam nematawa hiasi dondoꞌ atin hiꞌagalafi. ");
INSERT INTO aoj_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Muꞌuli apeꞌini naꞌi andeandeꞌma apaꞌ mogasoꞌana takis Sisar gavman dembinai esis Romi, aꞌa owaꞌ?” Owaꞌ Jisas aꞌ nogawa basoꞌam amamini naꞌipam naꞌi, “Deiꞌ maina ipaꞌ pagagwamba aeꞌ? Faꞌmai anin moni atitina ataꞌ itilin.” ");
INSERT INTO aoj_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Eaꞌ mofaꞌmanani ma natilin nahaliꞌam naꞌi, “Ambal laloma agol isimba sagaili amisi?” Maꞌi, “Isimba Sisari gavman dembinai.” ");
INSERT INTO aoj_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Eaꞌ magwamam naꞌipam naꞌi, “Daoꞌ hiahawes isimba dembinai Sisari peseꞌanas Sisar. Apaꞌ hiahawes Godi, peseꞌanas God.” Eaꞌ amom gogolalasom nomonas hiahawesa anen. ");
INSERT INTO aoj_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Anom amam anep miniꞌap Sadyusi amom miniꞌap apamba maꞌi sagagaꞌi ina atiasi sotanima sosafel wapani, owaꞌatin. Eaꞌ mafiꞌmai Jisas mahaliꞌana maꞌi, ");
INSERT INTO aoj_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Dembinai Tisa, fowaꞌ Moses nandaꞌ anif basef fagail buki ma apaꞌi faꞌi, ‘Iꞌi anona aman nogaꞌ, ma anen awasi akana, wauluꞌmana ataꞌ kope, owamana ananinai aꞌ nosoꞌakw nola anis awasi ma sogahaꞌofana.’ ");
INSERT INTO aoj_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Eaꞌ amom wambota atotota 7-pelaim mape. Nagaliꞌi sahomam nasoꞌakw awani akaꞌw nagaꞌ nakwahoꞌw kwape. ");
INSERT INTO aoj_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","22","Eaꞌ owamana nagiꞌ nasoꞌakw, nagaꞌ nakwahoꞌw kwape awani akaꞌw. Eaꞌ owapam mandatuꞌumi mandaꞌas naꞌamba atin, masoꞌ nemataꞌw akwamba magaꞌ atin hiꞌalam mafeꞌ mafeꞌma matagama owagufunai akutainai. Amom amamba ambipim ina mola anis awasi, owaꞌ. Mandagaꞌ atin. Ama main, wauluꞌmam kwagiꞌ kwagaꞌ kwagiꞌmam. ");
INSERT INTO aoj_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Eaꞌ anaf esis sagagaꞌi sogosafel wapani, nemataꞌw akwamba kopoma mamahonama? Amom 7-pelaim aꞌ masoꞌakw atin hiꞌalam kwape wauluꞌmam amamuꞌwi.” ");
INSERT INTO aoj_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Eaꞌ Jisas nagwamam basef amom naꞌi, “Ipaꞌ owaꞌ pegawa basef Baibel nagaꞌiefia, eaꞌ owaꞌ pegawa banagami Godia. Ipaꞌ deiꞌ ina paꞌi basef andeandeꞌ, owaꞌatin. ");
INSERT INTO aoj_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Nemaf afamba sagagaꞌi sokwaha wandelef sogosafel wapani, amam nematawa ina ataꞌ sondasoꞌama wapani, aꞌ owaꞌatin. Sope dowaf siꞌi ensel magape heveni. ");
INSERT INTO aoj_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Basef ifimba ma sagagaꞌi sotanima sogosafel wapani, ipaꞌ patalifa basef fagail buk Baibeli, fowaꞌ God nagaꞌipanaef Mosesi. Basef ifimba faꞌi nif ileliwa wagataga ma lawag saꞌugai fagandogai. Basef ifimba God naꞌipa Moses naꞌi, ‘Aeꞌ God Abrahami, Aisaki, a Jekopi.’ ");
INSERT INTO aoj_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Basef ifimba fagaꞌi Dembinaii, anen ina God epes sagagaꞌii, owaꞌatin. Anen God epes isimba ambal lapais sagape namisi. Eaꞌ basef ipeꞌifi ina endilisifi. Ipaꞌ ina pegawef andeandeꞌ, owaꞌatin.” ");
INSERT INTO aoj_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Anona aman dembinai nagawalipasa muꞌuli Godi nafiꞌi, nameꞌ amom maꞌi maloma Jisas mandahihianama basef. Eaꞌ nameꞌ Jisas nagwamam basef buꞌwafi atif. Eaꞌ nahaliꞌana naꞌi, “Muꞌuli Godi apaꞌ magahapifani hiani. Apaꞌ muꞌuli mamahina luꞌwin nikilaꞌ muꞌuli daian hiani nape nagaliꞌi?” ");
INSERT INTO aoj_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Jisas nagwamana basef naꞌi, “Muꞌuli nagaliꞌi inimba. Ipaꞌ Israel, ipaꞌ pemeꞌ! Dembinai God apeꞌinai, anen atona Dembinai. ");
INSERT INTO aoj_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Nomonas ipeꞌisi sohafela dembinai God ipeꞌinai sisilana naꞌamba. Ukup ipeꞌipi pipilana hiꞌindalep, peseꞌana ambagufi nelelemb soloma pepel ipeꞌisi pendasoꞌanas hiꞌindalasa Dembinai God atona. ");
INSERT INTO aoj_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Eaꞌ muꞌuli nagafeꞌma bifi inimba. Ipaꞌ ukup pipila anis epes sagape felefeleꞌma ipeꞌi siꞌi ukup pagapagaila ipaꞌ atipa. Owaꞌ anin muꞌuli nikilaꞌ muꞌuli inimba biafina, owaꞌatin.” ");
INSERT INTO aoj_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Eaꞌ aman anamba naꞌipa Jisas naꞌi, “Dembinai, inaꞌ naꞌias andeandeꞌ. Ahoꞌ God atona anen Dembinai, anen atona nape. Owaꞌ anona aman nope dembinai siꞌi anona. ");
INSERT INTO aoj_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Ahoꞌ, muꞌuli luꞌwani nagaliꞌi inimba. Nomonas ipeꞌisi sohafela anen sisilana naꞌamba. Ukup ipeꞌipi pipilana hiꞌindalep, peseꞌana nelelembi gawa soloma pepel ipeꞌisi hiꞌindalas. Naꞌambai andeandeꞌ. Eaꞌ muꞌuli nagagiꞌi inimba. Ipaꞌ piti uwahipis nomonas sisila epes ami sagape felefeleꞌma ipeꞌi siꞌi ipaꞌ nomonas sagaila ipaꞌ atipa. Naꞌambai andeandeꞌ. Iꞌi apaꞌ mugaila muꞌuli inimba biafin, waf afambai buꞌwafi fikilaꞌ gwaꞌaisi mafis main mogasoꞌanas Godi ataꞌ beꞌes kwasakwasala.” ");
INSERT INTO aoj_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Jisas nameꞌ aman anamba nagwa basef siꞌi aman gawa buꞌwaninai. Eaꞌ naꞌipana naꞌi, “Inaꞌ ataꞌ nogota laota ma nigawis nomona maol Godi nope Dembinai mugumafina, owaꞌ.” Eaꞌ amom hiami ombel mahama mogahaliꞌ Jisasa anif basef wapani. ");
INSERT INTO aoj_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Jisas nape ipat luꞌunai Godi nasoꞌasa basef esis amam nematawa naꞌi, “Amom magawalipasa muꞌuli Godi maꞌi, ‘Krais, aman anamba God nandandepana nogafiꞌii, Devit akunamana. Eaꞌ maꞌi Krais aman atona dowaf itapanai. Deiꞌ maina magaꞌias naꞌamba ma Krais? ");
INSERT INTO aoj_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Ambal buꞌunai Godi nasaꞌma Devit naꞌi, ‘Dembinai God naꞌipa Dembinai aeꞌanai naꞌi, “Inaꞌ nepe lagol kwahisigili aeꞌagili atapina nefeꞌ netagama aeꞌ endaꞌ bousi ineꞌisi sogafeꞌ lafela boꞌwagah ineꞌigahi.”’ ");
INSERT INTO aoj_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Aman anamba king Devit fowaꞌ nofala Krais naꞌi Dembinai. Isimba atis deiꞌ Krais ina aman atona falafunai, owaꞌ. Anen dembinai.” Eaꞌ amam nematawa hiasi sonahasa sagameꞌ basef ananifi. ");
INSERT INTO aoj_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Jisas nawalipas naꞌipas naꞌi, “Ipaꞌ solawaipa ma amom dembami magawalipasa muꞌuli Godi. Amom maꞌi mowahoꞌ luwaguf laumi atom mondafeꞌma esis sotoloma sigaꞌi amom dembami mandaꞌ waf fasifii. Amom maꞌi mope anamba esis hiasi sandatama sagapoma ma sotoloma sondalalamam soganifelom. ");
INSERT INTO aoj_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Amam amamba ukup paꞌi mondape siaifah isimba sotawa sagaliꞌi atis, dembami atom magapoma nomon ifagw esis Juda sandakolasugwi aꞌa anamba hiasi sandakolas nimaguf ifimba sandaꞌ gwaꞌaimi luꞌwami ma hiasi sogatolom. ");
INSERT INTO aoj_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Amom magawis ifagw agwamba nematawa alifiwaii, mawis mandaꞌ wala hiahawes awousi. Eaꞌ mosafel malutu mandabeten launai dowadowafa esis sotolom sigaꞌi amom buꞌwami. Anaf God nowaloga epes hiasi. Anis epes daias owaꞌ sondaꞌ waf awafi naꞌambaia anaf sofaꞌ akafimi kwasakwasala, apaꞌ amom aꞌ mofaꞌ nimanimi aꞌowaꞌ luꞌwami endilisi.” ");
INSERT INTO aoj_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Jisas nape nomon ipat luꞌunai Godi, nape felefeleꞌma bokis moni nagalasi. Anen nape nati amam nematawa safiꞌi sagala moni negewala bokis. Amam nematawa isimba moni hianaisi sala moni hiani. ");
INSERT INTO aoj_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Apaꞌ anoꞌw nemataꞌw alifiꞌwi kwafiꞌi kwala moni saꞌwisaꞌwini biafin siꞌi 10 toea newala bokis isimba. ");
INSERT INTO aoj_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Eaꞌ nofala alipumi ananimi mafiꞌi naꞌipam naꞌi, “Aeꞌ aꞌipipa endilisi, nemataꞌw akwamba alifiꞌwi kwaꞌwaha moni luꞌwani nikilaꞌ moni hiani amam nematawa hiasi sagalani. ");
INSERT INTO aoj_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Epes isimba hiasi moni hianai naꞌomas, sala duꞌwanin atin newala bokis. Apaꞌ nemataꞌw akwamba, moni akaꞌw endilisi, akoꞌw kwala moni akoꞌuni hiꞌalan. Eaꞌ owaꞌ anin neꞌeha kogatala gwaꞌaisia, aꞌ owaꞌatin. Eaꞌ moni akoꞌwini biafin saꞌwini aꞌ nikilaꞌ moni hiani esis sagalani hiꞌalan.” ");
INSERT INTO aoj_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Jisas nape nomon ipat anamba luꞌunai Godi. Eaꞌ naꞌi nokwaha ipat anamba nuwisi andoꞌ, anona alipunai ananimi nafiꞌi naꞌipana naꞌi, “Tisa, inaꞌ niti ifagw amamba fasifasimi. Sandaꞌ otamba luꞌwami sandaꞌam suwasuwaim.” ");
INSERT INTO aoj_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Eaꞌ Jisas nagwamana naꞌipana naꞌi, “Inaꞌ nati ifagw amamba luꞌwami, aꞌa? Anaf ina anemba otamba bendatomama atin banagemba bepe, owaꞌatin. A sugulatam sowalom hiꞌilam mofeꞌ moꞌoh atona atin hiꞌilam.” ");
INSERT INTO aoj_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Jisas nape halafuta Oliv eaꞌ nati ipat luꞌunai Godi notawa doꞌwan waꞌol. Eaꞌ Pita naloma Jemsi Jon a Andru atom mafiꞌmai anen mahaliꞌana maꞌi, ");
INSERT INTO aoj_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Inaꞌ niꞌipafa hiahaom amamba nambaiꞌ motaga? Ametal mail liliꞌ lotaga ma apaꞌ mogogawa hiahaom amamba felefeleꞌma mogataga siꞌi deiꞌaol nagaꞌipafa?” ");
INSERT INTO aoj_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Eaꞌ Jisas naꞌipama basef laufi naꞌamba naꞌi, “Ipaꞌ solawaipa. Naꞌamba anin epen aꞌ nembasoꞌmepa. ");
INSERT INTO aoj_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Deiꞌ main, amam hiami anef nemaf mifiꞌi mombasoꞌmepa miꞌi agol aeꞌagili miꞌi, ‘Aeꞌ maꞌuwi aeꞌ Krais, God nandandepe nasapaꞌe agafiꞌii.’ Eaꞌ atiasi amom mombasoꞌma amam nematawa hiasi. ");
INSERT INTO aoj_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Anef nemaf pemeꞌ amalemba wandaf anis sondaha basefa wandaf siꞌipipaf, apaꞌ ipaꞌ ina ombal mehepa, owaꞌi. Hiahaom amamba atiasi mogatagai, apaꞌ nemaf akutaifi ataꞌ otaꞌ. ");
INSERT INTO aoj_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Anis epes sagape anamba itap luꞌwagoma sofela wandaf sopaꞌ soloma anis sagape anep itap daiapi. Anona dembinai king noꞌwa anis walemb hielimbi ananisi sopaꞌ soloma anona dembinai king daiana noꞌwa ananisi analemb walembi. Analemb walemb hiagoma atona atin itap bol atin nope, eaꞌ anis epes hiasi sagape analemb walembi nolomohas sope. Hiahaom amamba ataꞌ muliꞌ motaga siꞌi akafimi maliꞌ magatagama nemataꞌw kwaꞌi kogola awani. Apaꞌ akafimi anaf migiꞌ mogatagai aꞌ luꞌum aꞌowaꞌ mikilaꞌ amamba mogaliꞌi. ");
INSERT INTO aoj_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Ipaꞌ solawaipa andeandeꞌ. Anaf sondaꞌ kotimipa ma gavman dembami asasimi. Eaꞌ sehepa nomon ifagw Juda sandakolasugwi. Ipaꞌ pagameꞌ basef aeꞌafi pagaila aeꞌi isimba atis deiꞌ sondaiwaꞌmepa sondaꞌepa pilutu nogohnaep kingi moloma gavman dembami ma pegawalapa basef aeꞌafi buꞌwafi pigaꞌipasef. ");
INSERT INTO aoj_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Alipisi aeꞌasi ataꞌ siliꞌ sofeꞌ walemb hiagoma siꞌipa amam nematawa hiasi someꞌ basef buꞌwafi Godi filiꞌ. Ama main nemaf akutaifi figiꞌ fetaga. ");
INSERT INTO aoj_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Afamba esis sowalapepa sofaꞌepa pegafeꞌma kot, ipaꞌ ina ombel mehepa a piꞌi, ‘Atiasi afaꞌ wiꞌi basef maif?’ Owaꞌ. Basef hiafi God nogasiꞌipafi ma nogota atamba atota, ifimba ipaꞌ pewalapef. Ifimba ina basef ipeꞌifi atif, owaꞌ. Ambal buꞌunai Godi atona nowalapefa ipaꞌ piꞌif. ");
INSERT INTO aoj_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Anef nemaf esis atis sahin owan sondandaꞌma kot, sohas afis. Eaꞌ ahapas sondaꞌam naꞌamba atina esis nogaopas asasisi. Eaꞌ batawisas wapani sondaꞌ kotima mamasas asasisi anis sohas afis. ");
INSERT INTO aoj_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Atiasi epes hiasi walemb hiagoma nelelemb numbutima ipaꞌ kwapeteꞌ endilisi. Esis sati ipaꞌ pagaila basef aeꞌafii, naꞌamba deiꞌ sahepa. Apaꞌ epen ami nihapifi banagen nilutu negataga nemaf akutaifii, inimba atiasi God nuwambilan nokwahoman waf awafi ananifi nitanimai nepe andeandeꞌ. ");
INSERT INTO aoj_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Anef nemaf ipaꞌ piti hiahaom awami mogahambombaga hiahaom buꞌwamii motaga mogape nomon ipat luꞌunai Godi. God nandaiwaꞌ endilisi ma hiahaom amamba awami mogape nomon ipat ananinai.” (Epen ami negatalifa basef ifimbai, anin aꞌ okom mondapomef andeandeꞌ.) Eaꞌ Jisas naꞌipa alipumi ananimi wapani naꞌi, “Nemaf afamba amam nematawa sagape itap luꞌwapi Judiai sofaꞌ sefeꞌ sondowasaꞌo halafutagw. ");
INSERT INTO aoj_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Eaꞌ epen ami nagape ipat andoꞌi ina ataꞌ netanima niwis nefaꞌi hiahawes ananisi ipat nomon, owaꞌi. Anin aꞌ nefaꞌ nendafoꞌo mehip. ");
INSERT INTO aoj_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Epen ami nigail aofi, ina ataꞌ nitanima nefeꞌ wambel nefaꞌ saket main ananisi, owaꞌi. Anin aꞌ nefaꞌ nendafoꞌo mehip. ");
INSERT INTO aoj_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Nematawa opafuwai waloma awamba awasi otaꞌasi sagaꞌ nomagof atogufi, aeꞌ aꞌi awo uwahipiwa endilisi ma nogota atamba ogameꞌ akafimi luꞌwami. ");
INSERT INTO aoj_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Ipaꞌ pendabetena hiahaom amamba akafimi ina motagamepa nogota atamba fufini asaf sogatagatai. ");
INSERT INTO aoj_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Nogota atamba akafimi mugatagai luꞌwami endilisi. Fowaꞌ dambadamba itap pagataga nafiꞌi nafiꞌi natagama deiꞌ, nimanimi awami amambai ina anom naꞌambaimi mataga, owaꞌatin. Eaꞌ anaf wapani ina atiasi anom nimanimi amambai motaga, owaꞌatin. ");
INSERT INTO aoj_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Iꞌi God owaꞌ nondaꞌ nimaguf fefeꞌ bandefa, atiasi amam nematawa hiasi higiligalasi hiꞌilas. Owaꞌ owaꞌatin. Apaꞌ God okom mapoma epes isimba anen nandandepas eaꞌi, deiꞌ nahagasa nogota atamba bandata. ");
INSERT INTO aoj_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Nemaf afamba fetaga ma iꞌi anis epes siꞌipipa sigaꞌi, ‘Ipaꞌ piti Krais, God nasapaꞌana nagafiꞌii, anen nape naꞌa, o nani nape gani,’ ipaꞌ ina pihapifas, owaꞌ hapaisi. ");
INSERT INTO aoj_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Atiasi anom amam mombasoꞌam mugaꞌi amom Kraisi aꞌa mugaꞌi profeti, aꞌ motaga mondaꞌ ametal hiahaom banagami mamimami mondaꞌ banagami hiami siꞌi God nandaꞌami. Endilisi iꞌi amom banagema, aꞌ mombasoꞌma amam nematawa God nosahoꞌas eaꞌi mohambombagas. Apaꞌ owaꞌ, owaꞌatin. ");
INSERT INTO aoj_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Eaꞌ ipaꞌ aꞌ solawaipa andeandeꞌ. Aeꞌ aliꞌ aꞌipipa eaꞌ ma hiahaom amamba nimanimi akafimi anaf mugiꞌ mugatagai. ");
INSERT INTO aoj_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Akafimi nimanimi hiami ma nogota atamba hiꞌilam eaꞌ, kwafalis atis awin alipini aꞌ netaga owamb, eaꞌ owambini ina ataꞌ negalaꞌ, aꞌowaꞌ. ");
INSERT INTO aoj_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Eaꞌ ondowa mowai otaga ilif, hiahaom hiami banagami magape otagai eaꞌ bol atin mope. ");
INSERT INTO aoj_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Nogota atamba esis siti aeꞌ ataga epen egefaꞌ alop epesi eloma ilagw otaga ilif ifiꞌi eloma hiahaom mogogalaꞌi fasimi Godi moloma banagami ananimi. ");
INSERT INTO aoj_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Nogota atamba aeꞌ igafiꞌi esapaꞌ ensel amamba aeꞌami mofeꞌ itap hiagoma awin natafima negewalama lambilif anamba waꞌowaꞌol biafigin biafigin mefeꞌagon hiꞌilagon ganimba itapi otaga safeꞌ sogotambela. Atiasi ensel amamba mefeꞌ mofaꞌai esis amam nematawa God nogosahoꞌas ananisii sondakolas atogon. ");
INSERT INTO aoj_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Ipaꞌ nomonas sondandaꞌma anif basef waminif atina ilaof. Ipaꞌ piti ilaof nogonafa ma basowa, pegawa nogota atamba nelemb eaꞌ felefeleꞌma sogaof.’ ");
INSERT INTO aoj_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","“Eaꞌ naꞌamba atin anaf piti hiahaom amamba aeꞌ aliꞌ agaꞌipipami mogataga, ipaꞌ pegawa aeꞌ afiꞌi alutu felefeleꞌma uta. Ina ataꞌ nogota laota, owaꞌ. ");
INSERT INTO aoj_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Aeꞌ aꞌipipa endilisi, amam nematawa deiꞌ pagape itap apaꞌi ataꞌ pagapani ina atiasi apegaꞌ ulal, ataꞌ owaꞌ ipaꞌ piti esis eaꞌ siti hiahaom amamba motaga hiꞌigalam. ");
INSERT INTO aoj_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Otaga noloma itap hiagoma anaf aꞌ higililam hiꞌilam, apaꞌ basef aeꞌafi ina anaf higililif, owaꞌatin endilisi. Fegape atapif lifilafii. ");
INSERT INTO aoj_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Owaꞌ anin epen negawa nemaf afamba hiahaom amamba mogatagafia, owaꞌ. Amom ensel magape heveni maloma aeꞌ Nogama Godi afaꞌ wapani ina ogawaf, owaꞌ. God atona nogawa nemaf afamba. ");
INSERT INTO aoj_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Ipaꞌ ina pegawa hiahaom amamba nambaiꞌ motaga, owaꞌ. Ipaꞌ solawaipa, pindumafuma andeandeꞌ pendape. ");
INSERT INTO aoj_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Ipaꞌ pemeꞌ anif basef waminif atin deiꞌ igaꞌipipafi. Nemaf afamba siꞌi anona aman nakwaha ipat ananitai nagafeꞌ anagon. Anen nofalai amom mandaꞌ maola anini mafiꞌi nawaloga maol nagasoꞌam atona atina mugumafi hiahawes ananisi. Eaꞌ naꞌipa aman nugumafi utai ma nugumafiata andeandeꞌ. ");
INSERT INTO aoj_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Eaꞌ ipaꞌ solawaipa andeandeꞌ. Ipaꞌ ina pegawa nambaiꞌ Dembinai nugumafi ipati nugafiꞌi. Atiasi nifiꞌi wambomota aꞌa amanota aꞌa lalamota awatagw gogata, aꞌa kuhimbita atota, ipaꞌ ina pegawam, owaꞌ. ");
INSERT INTO aoj_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Naꞌamba anen nifiꞌi kwafalis atis niti ipaꞌ ataꞌ peꞌeh atin. ");
INSERT INTO aoj_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Basef ifimba aeꞌ agaseꞌepaef ipeꞌi, ifimba aeꞌ aꞌipa amam nematawa hiasi hiꞌalas. Ipaꞌ solawaipa andeandeꞌ pepe ma hiahaom aeꞌ agaꞌipipami mogataga.” ");
INSERT INTO aoj_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Anef nemaf buꞌwafi saꞌi Pasova ma esis Juda sondaꞌ anis gwaꞌaisi luꞌwasi sogaꞌ anota bret owaꞌ togatef luꞌutaia. Nimaguf bif ataꞌ fape ma nemaf afamba buꞌwafi saꞌi sogaꞌ gwaꞌaisi Pasovaefi. Afamba amom dembami magawalipasa muꞌuli Godi maloma anom pris dembami maꞌi mondaꞌ uhuf mefeꞌma mombaloꞌ Jisas mohana nogagaꞌ. ");
INSERT INTO aoj_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Amom maꞌias naꞌamba maꞌi, “Nemaf afamba sandaꞌ gwaꞌaisi luꞌwasiafi afaꞌ ina ombaloꞌana, hapainai. Naꞌamba epes hiasi ukup awep sohafel sondaꞌ wandaf.” ");
INSERT INTO aoj_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Nemaf afamba Jisas nafeꞌ Betani, nape ipat anona aman Saimoni, fowaꞌ aowas aunai nandaꞌ alop ananipi pagambuꞌwi, ma deiꞌ ambuꞌunai, Jisas ataꞌ nape naꞌ gwaꞌaisi atin, owaꞌ anoꞌw nemataꞌw kwahapila anol botol sandaꞌal siꞌi otami, sanda alogw fasigwi gwagani sagatalin otamba luꞌumbai nala botol alamba, agilina nad. Eaꞌ kopalia botol alamba kwakoloꞌwan newala balaga Jisasi. ");
INSERT INTO aoj_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Owaꞌ anis epes sape satolom saꞌi, “Deiꞌ maina kwagakoloꞌ sanda inimba dowadowaf?” Eaꞌ esis ukup numbutip kwapeteꞌ ma akoꞌw, ");
INSERT INTO aoj_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","saꞌi, “Iꞌi afaꞌ ofaꞌana anis epes sosoꞌafa moni nikilaꞌ 300 kina sotalina ofaꞌan ogasoꞌ epes isimba kwahusa gwaꞌaisi mainai, daoꞌ andeandeꞌ. Apaꞌ owaꞌ owaꞌatin.” Esis ukup numbutip aꞌowaꞌ sapoma nemataꞌw akwamba. ");
INSERT INTO aoj_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Eaꞌ Jisas naꞌipas naꞌi, “Ipaꞌ ina aꞌ ukup aoma akoꞌw, owaꞌi. Akoꞌw kwandaꞌ waf fasifima aeꞌ. ");
INSERT INTO aoj_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Isimba gwaꞌaisi main akasi lifilafi sape dowaf salomepa. Nemaf mamahefa piꞌi petopalopas pegasoꞌas moni, andeandeꞌ, peseꞌasan. Epes isimba gwaꞌasi main akasi sape salomepa nimaguf hiafi, apaꞌ aeꞌ owaꞌ. Aeꞌ ina elomepa egape nimaguf hiafi, owaꞌ. ");
INSERT INTO aoj_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Maol inimba akoꞌw kwogawan kwandaꞌani, akoꞌw kwandaꞌan. Felefeleꞌma atiasi esis sehe egagaꞌ ma sogawe matmata. Okom akoꞌumi mapoma felefeleꞌma egagaꞌ. Naꞌamba deiꞌ kofaꞌi sandaꞌ inimba kwafiꞌi kwakoloꞌwan newala balaga aeꞌagai kokoꞌwalan newala alop aeꞌapi. ");
INSERT INTO aoj_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Endilisi aeꞌ aꞌipipa, ganimba itap walemb hiagoma anaf sigaꞌipasa basef buꞌwafi Godi, siꞌipasa basef akoꞌufi wapani ma ukup pegapoma, waf buꞌwafi akoꞌw kwandaꞌmeafi.” ");
INSERT INTO aoj_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Amam amamba Jisasi 12-pelaim anona amamunai agilinama Judas Keriotinai a nafeꞌ gani amom pris dembami magapoma. Anen naꞌi niꞌipama Jisas atona nogapoma mofeꞌ mogombaloꞌana. ");
INSERT INTO aoj_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Amom mameꞌ basef ananifi sonaham endilisi. Eaꞌ maꞌi basef mandameꞌmaef naꞌamba maꞌi, “Andeandeꞌ, afaꞌ aꞌ oseꞌena anin moni.” Eaꞌ Judas naꞌi ahoꞌ aꞌ nalaꞌ nolaoma anoꞌw ufiaꞌwa nigihimbaꞌmama Jisas amoma mogombaloꞌana. ");
INSERT INTO aoj_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Nemaf afamba saliꞌ sagaꞌ gwaꞌaisi sagaꞌi Pasovai esis saꞌ bret atamba owaꞌ togatef luꞌutaia, eaꞌ saha sipsip nogami sondolalima Goda sondaꞌ gwaꞌaisi isimba. Eaꞌ alipumi Jisasi mahaliꞌana maꞌi, “Inaꞌ naꞌi afaꞌ ofeꞌ ondondomba ipat anima?” ");
INSERT INTO aoj_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","14","Eaꞌ Jisas naꞌipa ananimi biam naꞌi, “Ipaꞌ pefeꞌ piwis gani wambel luꞌwambili, piti anona aman ufiaꞌw nofaꞌ embel sospen luꞌunai. Eaꞌ pigiꞌmana pefeꞌ piwis ipat atamba anen nefeꞌ nogawisatai. Eaꞌ pihaliꞌ ahama ipat atambai piꞌi, ‘Dembinai afaꞌinai naꞌipafa naꞌi, ipat atamba esis sagaꞌohotai totawa ani? Anen naꞌi noꞌwa afaꞌ atofa alipufai ope ondaꞌ gwaꞌaisi isimba Pasova.’ ");
INSERT INTO aoj_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Eaꞌ nihimbaꞌmepa rum amamba luꞌwami mape ilif, eaꞌ sandombata tebol siaifah saꞌoh atifis. Ipaꞌ pendondombamafa gwaꞌaisi rum amamba.” ");
INSERT INTO aoj_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Eaꞌ amom mafeꞌ mawis wambel ambalemba mati hiahawes isimba siꞌi Jisas naliꞌ nagaꞌipamasi eaꞌ mandondomba gwaꞌaisi isimba Pasova. ");
INSERT INTO aoj_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Ama wambomota felefeleꞌma owamb, Jisas naloma alipumi 12-pelaim mafeꞌ mataga ipat atamba ");
INSERT INTO aoj_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","mawis ataꞌ mape maꞌ gwaꞌaisi atin, owa Jisas naꞌipam naꞌi, “Aeꞌ aꞌipipa endilisi, anona afaꞌinai deiꞌ nape nalomafa nagaꞌ gwaꞌaisii, atiasi aꞌ nefeꞌ nihimbaꞌma amom boumi ma aeꞌ egapoma.” ");
INSERT INTO aoj_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Eaꞌ amom mameꞌ naꞌamba ukup amamipi aꞌ nimanip eaꞌ mahaliꞌana atona atin maꞌi, “Aeꞌ aꞌa ami?” ");
INSERT INTO aoj_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Jisas naꞌipam naꞌi, “Anona afaꞌinai nalome aeꞌ wahapila bret wagalata disi, eaꞌ anamba atona. ");
INSERT INTO aoj_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Ahoꞌ, aeꞌ ataga epen egefaꞌ alop epesi, atiasi anis epes sehe egagaꞌ, siꞌi Buk Baibel nagaꞌiasa aeꞌ. Apaꞌ aman anamba nogawalapa aeꞌ ma boumii, anen uwahipina endilisi. Atiasi hiahaom awami endilisi aꞌ motagamana. Fowaꞌ maꞌmana owaꞌ ataꞌ kolana ai, daoꞌ aꞌ andeandeꞌ. Ama anen ina aꞌ notagama hiahaom akafimi amamba awami eaꞌ hapaimi. Owaꞌ, aꞌ owaꞌatin.” ");
INSERT INTO aoj_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Jisas nalomam ataꞌ mape maꞌ gwaꞌaisi atin, ama main, nasaꞌma anota bret, nandabeten nanifela God, nawalota nasoꞌam naꞌipam naꞌi, “Ipaꞌ saꞌmata peaꞌata. Bret atamba alop aeꞌapi.” ");
INSERT INTO aoj_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Eaꞌ nasaꞌmai anop kap embel wain bagalapi nandabeten nanifela God nasoꞌamambel amom hiami maꞌ embel atin. ");
INSERT INTO aoj_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Eaꞌ naꞌipam naꞌi, “Embel ambalemba esimbel aeꞌambeli begewaꞌ banaga basef ifimba God nagalaꞌ lapafi dambaifi. Aeꞌ ekoloꞌwambela egatopalopa amam nematawa hiasi. ");
INSERT INTO aoj_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Aeꞌ aꞌipipa endilisi, aeꞌ ina ataꞌ itanima iaꞌ embel wainimbel wapani, owaꞌ. Efeꞌ etaga anamba God nagalaꞌambemagoma daoꞌ, aꞌ iaꞌ anin wain dambaini.” ");
INSERT INTO aoj_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Amom mandaꞌ anof awaf eaꞌ mawisi aꞌ mafeꞌ mondowasaꞌ halafuta Oliv. ");
INSERT INTO aoj_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Eaꞌ Jisas naꞌipa amom alipumi naꞌi, “Fowaꞌ gani Baibel nagaꞌi naꞌamba naꞌi, God naꞌi, ‘Anaf owagama gani, aeꞌ aꞌ eha aman anamba nugumafi sipsipi nogaꞌ. Eaꞌ sipsip amamba atiasi aꞌ mofaꞌ mofeꞌ atona biana.’ Atiasi ipaꞌ a pekwaha pigahapifa aeꞌ pefaꞌ pefeꞌ atona biana, siꞌi fowaꞌ God nagaꞌias. ");
INSERT INTO aoj_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Apaꞌ owaꞌ owaꞌatin, atiasi aeꞌ itanima esafel wapani, iliꞌipa efeꞌ itap luꞌupa Galili.” ");
INSERT INTO aoj_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Eaꞌ Pita nagwamana naꞌi, “Iꞌi amom hiami ineꞌimi mogakwaha ineꞌma, hapaimi, apaꞌ aeꞌ owaꞌatin.” ");
INSERT INTO aoj_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Eaꞌ Jisas nagwamana basef naꞌi, “Aeꞌ aꞌipina endilisi, deiꞌ owamb ambaꞌe, awata ataꞌ owaꞌ tota bifa, inaꞌ aꞌ nendahaliꞌmi niꞌias wanif niꞌi, ‘Aeꞌ owaꞌ egawa Jisasa.’” ");
INSERT INTO aoj_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Owaꞌ owaꞌatin. Pita dindinapina naꞌipana banagambel naꞌi, “Owaꞌatin. Iꞌi esis sogahafa, afaꞌ biafa ogaꞌ atin. Aeꞌ ina aꞌ indahaliꞌmina, owaꞌatin endilisi.” Eaꞌ alipumi hiami Jisasi maꞌias naꞌamba atin hiꞌalam. ");
INSERT INTO aoj_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Jisas naloma alipumi ananimi mafeꞌ mataga itap Getsemani, eaꞌ naꞌipam naꞌi, “Ipaꞌ pepe naꞌa. Aeꞌ cefeꞌ gani waꞌol endabeten ihaliꞌ God.” ");
INSERT INTO aoj_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Jisas naoꞌwa Pitai Jems a Jon mafeꞌ malomana. Eaꞌ opaf Jisasi aꞌ aof kwapeteꞌaf ");
INSERT INTO aoj_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","naꞌipam naꞌi, “Nembel aeꞌambili aꞌ nimanimbil aꞌowaꞌ, ma aꞌ egagaꞌ nomonas aeꞌasi aꞌ awes endilisi. Ipaꞌ pepe naꞌa silisilawi pepe pesasae igitanimai.” ");
INSERT INTO aoj_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Eaꞌ Jisas nandambemef nafeꞌ, nambeꞌ opaf naꞌoh itap nahaliꞌ God. Naꞌi notofa hiahaom awami amamba anen atiasi nogameꞌagamami. ");
INSERT INTO aoj_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Eaꞌ nahaliꞌ God naꞌi, “O, Ahame inaꞌ banaginai ma nandaꞌ hiahaom hiami hiꞌagalami. Nekwahome kap apamba. Apaꞌ owaꞌ, inaꞌ nindaila okom ineꞌimi atom, aeꞌ owaꞌ.” ");
INSERT INTO aoj_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Anen nahaliꞌana eaꞌ, nosafel notanima nafeꞌma alipumi ananimi magapoma. Nafeꞌ natolom owaꞌ, nati amom maꞌoh magaꞌ mafeꞌ. Eaꞌ nofala Saimon Pita naꞌi, “Saimon, ipaꞌ ataꞌ owaꞌ pepea, pandaꞌoh atin aꞌamon? Deiꞌ maina ipaꞌ owaꞌ banagepama pepe pegasasa aeꞌa? Nogota ina laota ma aꞌipipa aꞌi pepe pegasasa aeꞌ, owaꞌ. Nogota bandata siꞌi awa atitin. ");
INSERT INTO aoj_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Ipaꞌ solawaipa pepe pendabeten. Naꞌamba hiahaom mogogwambipai aꞌ motagamepa. Endilisi ukup ipeꞌipi paꞌi awima pendabeten, apaꞌ alop owaꞌ banagepa, alaꞌuta tahepa, ma pendabeten pegalome.” ");
INSERT INTO aoj_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Jisas naꞌipam naꞌamba ma eaꞌ, aꞌ notanima nafeꞌ nahaliꞌ God. Nahaliꞌanama basef ifimba atif naliꞌ nagahaliꞌanamafi. ");
INSERT INTO aoj_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Nahaliꞌana eaꞌ nandambemef notanima nafiꞌi amom magapoma nati ataꞌ maꞌoh atin. Eaꞌ ninimbalom mosafel maꞌi, “Atiasi afaꞌ wiꞌipana basef maif?” Ambeh luꞌwambihi haham eaꞌ maꞌoh magaꞌ mafeꞌ. ");
INSERT INTO aoj_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Anen nandambema notanima nafeꞌ wapani nahaliꞌ God siꞌi dokoꞌ naliꞌ nagahaliꞌana bif. Eaꞌ notanima nafiꞌmai amom naꞌipam naꞌi, “Ipaꞌ papoma nomaꞌw paꞌoh atin? Deiꞌ ipaꞌ koh eaꞌ, safel. Deiꞌ nemaf afaꞌe anona aman aꞌ nifiꞌi nulumai anom amam awami mufiꞌi mowaꞌ aeꞌ ataga epen egefaꞌ alop epesi. ");
INSERT INTO aoj_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Safel! Aꞌ ofeꞌ uti aman anamba nigihimbaꞌmama aeꞌi deiꞌ aꞌ nafiꞌi.” ");
INSERT INTO aoj_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Jisas ataꞌ nalutu naꞌipam atin, owaꞌ anona aman aꞌ nafiꞌi. Aman anamba Judas anona amom 12-pelaim ananimi nafiꞌi nalumai amam hiami mahapila bainagwi belep malomana mafiꞌi. Amom pris dembami malumai agufumi dembami esis Judai masapaꞌam mafiꞌi. ");
INSERT INTO aoj_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Eaꞌ aman anamba nagawalapa Jisasi, naliꞌ naꞌipam nandaꞌ ametal nihimbaꞌmam naꞌi, “Atiasi piti aman anamba aeꞌ igasisiꞌa dalogwanai, eaꞌ Jisas anamba maꞌuna. Ipaꞌ hapilana pewaꞌana andeandeꞌ pefaꞌana pefeꞌ.” ");
INSERT INTO aoj_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Amom ataꞌ mataga atin, owaꞌ Judas nafeꞌma Jisas naꞌipana naꞌi, “Tisa dembinai.” Eaꞌ nasisiꞌ dalot Jisasi. ");
INSERT INTO aoj_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Eaꞌ amom mowasaꞌ lagof mombaloꞌ Jisas. ");
INSERT INTO aoj_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Owaꞌ anona aman nagalutu felefeleꞌma Jisasi nagiai bainat naha anona aman nandaꞌmana maola pris dembinai nape nagaliꞌma pris hiamii, natopaꞌ aliga ananigai peleꞌatowaga gowa. ");
INSERT INTO aoj_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Eaꞌ Jisas naꞌipa amom boumi naꞌi, “Ipaꞌ pefaꞌi bainagwi belep pafiꞌi paꞌi pegewaꞌ anona aman aunai nandaꞌ wal napaꞌ nagaloma gavmani aꞌa? ");
INSERT INTO aoj_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Nimaguf hiafi aeꞌ ape alomepa ipat luꞌunai Godi awalapa basef buꞌwafi ma esis aman nematawa hiasi, ipaꞌ owaꞌ pembaleꞌea. Apaꞌ deiꞌ paila basef fagape Baibeli pafiꞌi pewaꞌe siꞌi basef fowaꞌ Fagaꞌias. Aeꞌ aꞌi basef ifimba deiꞌ fetaga endilisi a fela gwaꞌaisi.” ");
INSERT INTO aoj_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Eaꞌ alipumi ananimi hiami makwahona mafaꞌ mafeꞌ hiꞌalam. ");
INSERT INTO aoj_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Anona aman saꞌunai nagiꞌma Jisas nafiꞌi nowahoꞌ anef lowaf afitifi eaꞌ amom magahapila bainagwi bilipi maꞌi mombaloꞌana. ");
INSERT INTO aoj_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Owaꞌ owaꞌatin. Anen nakwaha lowaf atef faꞌoh aꞌ nafaꞌ nafeꞌ dowaf. ");
INSERT INTO aoj_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Amom mofaꞌ Jisas mafeꞌma pris dembinai nape nagaliꞌma pris hiamii. Anen naloma amom pris dembami maloma anom dembami daiam magawalipasa muꞌuli Godi amom hiami mandakolas atogon. ");
INSERT INTO aoj_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Eaꞌ Pita ina nalomam atef nafeꞌ, owaꞌ. Anen nagigiꞌmam nafeꞌ nawis indalelemba pris anamba dembinai eaꞌ nape naloma polisman mapoma nif. ");
INSERT INTO aoj_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Eaꞌ amom pris dembami maloma anom dembami Juda hiami mugumafi koti maꞌi molaoma anis epesa sombasoꞌam sogasapaga Jisasa anif basefa, mohana nogagaꞌ. Owaꞌ, amom ina mati anif, owaꞌatin. ");
INSERT INTO aoj_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Esis hiasi sambasoꞌmana sasapagana dowaf, apaꞌ ina saꞌi endilisifi fafeꞌ atifigin, owaꞌ. Saꞌif fandafeꞌ daindai. ");
INSERT INTO aoj_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Owaꞌ amom daiam malutu masapagana mambasoꞌmana ma anif basef naꞌamba maꞌi, ");
INSERT INTO aoj_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Afaꞌ wameꞌ Jisas naꞌias naꞌamba naꞌi, ‘Ipat Godi luꞌunai epes sandaꞌanai, atiasi aeꞌ igulatana, ma nimaguf wanif aꞌ esaꞌmana notawa wapani. Apaꞌ aeꞌ ina endaꞌ lagof esaꞌmana, owaꞌ.’” ");
INSERT INTO aoj_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Eaꞌ basef ifimba amom magaꞌiefi ina maꞌi endilisifi fafeꞌ atifigin, owaꞌ. Maꞌif fandafeꞌ daindai. ");
INSERT INTO aoj_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Eaꞌ pris anamba dembinai nalutu laꞌafen nahaliꞌ Jisas naꞌamba naꞌi, “Inaꞌ negwa basef ifimba, aꞌa owaꞌ? Deiꞌ maina amom magaꞌipina basef naꞌamba?” ");
INSERT INTO aoj_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Owaꞌ, owaꞌatin. Jisas nasopama malagol nalutu. Anen ina nagwamana basef anen, owaꞌ. Naꞌamba pris anamba dembinai nahaliꞌana wapani naꞌi, “Inaꞌ Krais aman anamba God nasapaꞌena nagafiꞌii aꞌa owaꞌ? Inaꞌ Nogamana God apaꞌ mandaꞌ lotumanai, aꞌa owaꞌ?” ");
INSERT INTO aoj_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Eaꞌ Jisas naꞌi, “Endilisi aeꞌ maꞌuwi. Anaf owagama ipaꞌ apiti aeꞌ ataga epen egefaꞌ alop epesi epe lagol kwahisigili Godi banagewe epe otaga ilif itanimai ifiꞌi petolowe.” ");
INSERT INTO aoj_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Jisas naꞌias naꞌamba owaꞌ, pris anamba aꞌ okom wandafuna eaꞌ nahapeꞌ lowaf anen nagalafi naꞌias naꞌi, “Apaꞌ ina ataꞌ mofalai anis wapani sifiꞌi siꞌi anif basefa anen, owaꞌatin. ");
INSERT INTO aoj_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Anen nandaꞌ God findiwana eaꞌ ifimba apameꞌef. Deiꞌ ipaꞌ ukup pape paꞌimama?” Eaꞌ amom hiami maꞌi anif basef mandameꞌmaef maꞌi, “Anen nandaꞌ waf awafi andeandeꞌma mohana nogagaꞌ.” ");
INSERT INTO aoj_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Eaꞌ anom mosafel misisiꞌwafana masopama naep ananipi mahana maꞌipana maꞌi, “Niꞌi basef siꞌi profet newalapa wagahinai ami nahena?” Eaꞌ amom polisman mafiꞌi mahana aꞌ mofaꞌana mafeꞌ. ");
INSERT INTO aoj_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","67","Anoꞌw nemataꞌw kwandaꞌmana maol pris anamba dembinai kwafiꞌi kwati Pita napoma nif ipat andoꞌ. Eaꞌ kwalutu naep doꞌa anen, kogawana kwaꞌipana naꞌamba kwaꞌi, “Anina inaꞌ nape nagaloma Jisas Nasaretinai.” ");
INSERT INTO aoj_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Eaꞌ Pita nandahaliꞌ naꞌipaꞌw naꞌi, “Owaꞌ. Aeꞌ ina egawa basef kofagefa inaꞌ nagaꞌiefi.” Eaꞌ anen nosafel nafeꞌ felefeleꞌma indambel uta, anota awata atata. ");
INSERT INTO aoj_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Eaꞌ nemataꞌw akwamba kwatolona kwaꞌipas wapani isimba sagalutu felefeleꞌi kwaiꞌpas naꞌamba kwaꞌi, “Aman anamba wapani alipunai nagaloma Jisasi.” ");
INSERT INTO aoj_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Owaꞌ Pita naꞌias wapani naꞌi, “Aeꞌ ina egawana, aeꞌ owaꞌ.” Aꞌi owaꞌ nogota laota kwasakwasala, owaꞌ anis sagalutu felefeleꞌi saꞌipa Pita wapani saꞌi, “Endilisi, inaꞌ alipinai nagaloma amom Jisasi. Inaꞌ wapani aman Galilinai.” ");
INSERT INTO aoj_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Deiꞌ Pita nandahaliꞌ naꞌi basef banagafi naꞌi, “Endilisi ilif, aeꞌ ina egawa aman anamba ipaꞌ pagaꞌianai, owaꞌatin.” ");
INSERT INTO aoj_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Anen naꞌias eaꞌ owaꞌ, awata atata bif eaꞌ Pita aꞌ okom mandandaꞌma basef dokoꞌ Jisas naꞌipanaef owambi nagaꞌi, “Awata owaꞌ ataꞌ tota bifa, inaꞌ nembasoꞌmas niꞌias wanif niꞌi, ‘Owaꞌ negawea.’” Eaꞌ Pita okom mandandaꞌma basef ifimba eaꞌ nalef mehip. ");
INSERT INTO aoj_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Aꞌi owaꞌ kuhimbita atota amom pris dembami maloma anom dembami daiam Judai a amom dembami magawalipasa muꞌuli Godi, maloma anom Juda dembami mugumafi koti, amom hiami mandakolas maila basef atifif. Amom mowaꞌ Jisas mofaꞌana mafeꞌ masoꞌ gavman dembinai Pailat. ");
INSERT INTO aoj_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Eaꞌ Pailat nahaliꞌana naꞌi, “Inaꞌ king dembinai Judai aꞌa owaꞌ?” Jisas nagwamana basef naꞌi, “Basef ifimba inaꞌ nagaꞌiefi endilisifi.” ");
INSERT INTO aoj_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Eaꞌ amom pris dembami masapaga Jisasa basef hiafi. ");
INSERT INTO aoj_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Naꞌamba Pailat nahaliꞌana wapani naꞌi, “Inaꞌ owaꞌ negwa anif basefa? Inaꞌ nemeꞌ. Amom mandaꞌmena basef hiafi ma inaꞌ.” ");
INSERT INTO aoj_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Owaꞌ Jisas ina nagwa anif basef wapani, owaꞌ. Naꞌamba Pailat nomonas salasafeꞌ hiahias. ");
INSERT INTO aoj_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Nemaf afamba esis Juda sandaꞌ anis gwaꞌaisi luꞌwasi sagaꞌi Pasovai. Afagof danda ma nemaf afamba dandaꞌafi Pailat nandaꞌas naꞌamba. Anen nakwahowa anona nagape kalabusi nafeꞌ wahifina. Aman ami esis amam nematawa sagaꞌianai, Pailat nameꞌasa nakwahona nafeꞌmas. ");
INSERT INTO aoj_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Aꞌi owaꞌ nogota atamba anona aman nagape kalabusi agilinama Barabas. Anen nandaꞌ kalabus naloma anom amam mapaꞌ magaloma gavmani maha anis sagagaꞌi. ");
INSERT INTO aoj_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Eaꞌ esis hiasi safiꞌi salutu sofala Pailat saꞌipana saꞌi, “Inaꞌ nekwahowa anona aman nagape kalabusi nifiꞌmai apaꞌ wahifina siꞌi afagof danda nandaꞌam.” ");
INSERT INTO aoj_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Eaꞌ nagwamasa basef naꞌi, “Deiꞌ aeꞌ ekwahowa king dembinai ipaꞌ nefeꞌmago ipaꞌ, aꞌa ami?” ");
INSERT INTO aoj_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Deiꞌ main, Pailat anen nogawa amom pris dembami kowalama epes hiasi sagaila basef Jisasi ukup aom atom mapomana deiꞌ mandaꞌ kotimana. ");
INSERT INTO aoj_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Eaꞌ amom masaꞌma nomonas amam nematawa hiasi ma sogahaliꞌ Pailata nogakwaha Barabas atona nogafiꞌmai esis. ");
INSERT INTO aoj_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Eaꞌ Pailat naꞌias wapani naꞌamba naꞌi, “Atiasi ipaꞌ paꞌi aeꞌ endaꞌana iꞌimamana aman anamba ipaꞌ pegefalona pagaꞌi king dembinai esis Judai?” ");
INSERT INTO aoj_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Eaꞌ esis gigal saꞌoh mehip saꞌi, “Dolana lawag hana nogaꞌ.” ");
INSERT INTO aoj_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Eaꞌ Pailat nahaliꞌas naꞌi, “Deiꞌ main? Anen nandaꞌ waf maif awafi?” Owaꞌ esis gigal saꞌi mehip saꞌi, “Dolana lawag hana afuna!” ");
INSERT INTO aoj_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Eaꞌ Pailat naꞌi nila nomonas asasisi. Eaꞌ nakwahowa Barabas nafeꞌma esis naꞌipa amom soldia ma mogopagaha Jisas mofaꞌana mefeꞌma mogandolana lawag usiꞌigai tiꞌwanaegai. ");
INSERT INTO aoj_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Amom soldia mofaꞌ Jisas mawisi ipat gavmani luꞌutai. Eaꞌ mofala anom soldia hiami mafiꞌi munduwaꞌanima ma anen ");
INSERT INTO aoj_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","malamana saket akwahitai. Eaꞌ mofaꞌi anona mandof higatagunai manogana malaꞌwatefana siꞌi hat mowaloꞌmanana balaga ananigai. ");
INSERT INTO aoj_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Eaꞌ malutu mandaꞌana findiwana maꞌi, “Nemaf buꞌwafi, inaꞌ king dembinai esis Judai.” ");
INSERT INTO aoj_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Eaꞌ amom mahana anota alifita balaga ananigai, misisiꞌwafana mindiwa nembawa motawa masaꞌma agol ananigili dowaf. ");
INSERT INTO aoj_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Mandaꞌana findiwana ma eaꞌ, mowalimana saket atamba akwahitai, malamana lowaf ananifi mofaꞌana mafeꞌma mogandolana lawag usiꞌigai tiꞌwanaegai. ");
INSERT INTO aoj_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Amom soldia mofaꞌ Jisas mafeꞌ ataꞌ malo ufiaꞌw laꞌafen, owaꞌ matagama anona aman Saimon, nape wambel ananimbili itap luꞌupa Sairini nafiꞌi. Nogaopana ananimi biam Aleksanderi Rufus. Saimon napani alup nafiꞌi, naꞌi nefeꞌ Jerusalem. Owaꞌ amom soldia maꞌipana dindinapa nogofaꞌ lawag Jisasi. Eaꞌ masapaꞌana nofaꞌaga nafeꞌ. ");
INSERT INTO aoj_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Eaꞌ mofaꞌ Jisas mafeꞌ mataga anagon agiligima Golgota. Apaꞌ deiꞌ mambemefagol maꞌi, Pipitagol Balagaigil. ");
INSERT INTO aoj_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Eaꞌ masoꞌana anambel embel wain mambemam magaloma anona marasin agilina meri ma neaꞌ embel begahagofa akep luꞌwami. Owaꞌ anen ina naꞌi ahoꞌ naꞌam, owaꞌ. Nandaiwaꞌmam. ");
INSERT INTO aoj_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Eaꞌ mandolana lawag usiꞌigai tiꞌwanaegai ma main, mandaꞌ satu ma luwaguf maim ananimi ma ami nigikilaꞌi ma mofaꞌef mondondamef atona atin. ");
INSERT INTO aoj_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Kuhumbita awin ataꞌ natafi nainaili 9 klok, soldia mofaꞌ Jisas mafeꞌ mandolana lawag agamba. ");
INSERT INTO aoj_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Amom mofaꞌ anin pepa basef ifimba dokoꞌ amom Juda magasapaga Jisasafi Pailat nandaꞌef fagaili faꞌi, “Anamba dembinai king esis Judai.” Amom mandaꞌ basef ifimba fail balaga Jisasi lawag ilif. ");
INSERT INTO aoj_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Felefeleꞌma Jisas nagaima, amom soldia mandola anom biam mandaꞌ waf awafii mandaꞌ wali. Amom mandola Jisas nail laꞌafen, eaꞌ mandola amom biam mail waꞌowaꞌol. ");
INSERT INTO aoj_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Naꞌamba siꞌi anif basef Baibel nagaꞌiefi deiꞌ afataga alihif fandawalap. Basef ifimba fagaꞌi naꞌamba faꞌi, “Anaf esis nomonas sopoma anen noloma amom amamba mandaꞌ waf awafii.” ");
INSERT INTO aoj_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Eaꞌ anis amam nematawa safiꞌi kilikilaꞌ sagaili sandaꞌ salamala anen, sapapati balagah saꞌias naꞌamba saꞌi, “Awi, inaꞌ aman nigugulata ipat anamba dembinai Godi, ma netanima negasaꞌmana nimaguf wanifi, ");
INSERT INTO aoj_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","deiꞌ netopalopa inaꞌ nendatagwah nisilaꞌi.” ");
INSERT INTO aoj_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Eaꞌ amom pris dembami maloma amom dembami magawalipasa muꞌuli Godi hiami malomam malutu mandaꞌana findiwana maꞌi, “Anen nandatopalopa anis daindaias, apaꞌ deiꞌ ina natopalopa anen, owaꞌatin. ");
INSERT INTO aoj_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Iꞌi aman anamba Krais Dembinai esis Israeli, anen nokwaha lawag nisilaꞌi ma motolona mogahapifana.” Amom biam sandolam magaloma Jisasi wapani mandaꞌana findiwana ma basef awafi. ");
INSERT INTO aoj_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Awin nandasapaꞌ akot luꞌunai aꞌ nataga itap hiagoma esis Judai akotigin. Akot aꞌ nape nafeꞌ nafeꞌ ma awin nandambema 3 klok wambomota. Eaꞌ awin nataga negalaꞌ wapani. ");
INSERT INTO aoj_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Awin nandambema 3 klok, Jisas noga naꞌi mehip naꞌi, “Eloi, Eloi, lama sabaktani?” Apaꞌ mambemef maꞌias naꞌamba maꞌi, “God aeꞌinai, God aeꞌinai, deiꞌ maina inaꞌ nagakwahowe?” ");
INSERT INTO aoj_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Anis epes salutu felefeleꞌ sameꞌ anen naꞌias naꞌamba saꞌi, “Pemeꞌ. Anen nofala anona profet Elaija.” ");
INSERT INTO aoj_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Eaꞌ anona aman nasagih nafeꞌ nofaꞌ anom mosong magape naohi nalam mowala embel wainimbel numbutimbeli nagiam nasapaꞌam anagol bagol nandowam mafeꞌma Jisas nogaꞌ embel. Eaꞌ aman anamba naꞌipas naꞌi, “Ipaꞌ ataꞌ otaꞌ atiasi muti Elaija nifiꞌi notagwahona nisilaꞌi aꞌa owaꞌ?” ");
INSERT INTO aoj_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Eaꞌ Jisas galala mehip eaꞌ nagaꞌ dogw. ");
INSERT INTO aoj_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Eaꞌ deiꞌ anona lowaf luꞌunai siꞌi utai negetaol ipat Godi luꞌunai nomoni palalana gani ilif nowala itap nataga biafina. ");
INSERT INTO aoj_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Eaꞌ kepten anamba dembinai nugumafi soldia hiamii, nalutu felefeleꞌma Jisas nati anen nagaꞌ naꞌamba eaꞌ naꞌias naꞌi, “Endilisi atis, aman anamba nogamana Godi.” ");
INSERT INTO aoj_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Eaꞌ anowa nematawa walutuwi laogon wagatologinii awamba. Anoꞌw Maria Makdalaiꞌwi a anoꞌw agol atogol Maria maꞌma Joses naloma Jems saꞌunai aꞌ anoꞌw Salome. ");
INSERT INTO aoj_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Fowaꞌ Jisas ataꞌ nagape Galili, awo wagawagaila anini ma wagatopalopana ma anis hiahawea gwaꞌaisi mais. Anowa hiawai wapani walomana ondondowasaꞌ Jerusalem. ");
INSERT INTO aoj_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Aꞌi owaꞌ wambomota felefeleꞌma owamb, Josep Arimateainai nafiꞌi. Anen dembinai ma kot esis Judai, agol luꞌwagilinai. Nape nohafa nemaf buꞌwafi fegataga ma hiasi sogawis nomona maol Godi nope Dembinai nugumafias. Deiꞌ sandaꞌ hiahaom gwaꞌaisi mais dumbulidombola naman nemaf afamba sabat fegataga. Eaꞌ Josep nafeꞌ nawis nalutu naep Pailati. Anen ina ombal mahana, owaꞌ. Nahaliꞌana ma nofaꞌi alop Jisasi nogawana. ");
INSERT INTO aoj_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Naꞌamba Pailat agogolalasona okom maꞌi Jisas ina deiꞌ aꞌ afuna endilisi, ataꞌ owaꞌ. Eaꞌ nofala anona dembinai soldia nafiꞌi nahaliꞌana naꞌamba naꞌi, “Jisas aꞌ nagaꞌ eaꞌ aꞌa owaꞌ?” ");
INSERT INTO aoj_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Soldia anamba naꞌipana naꞌi, “Jisas aꞌ nagaꞌ endilisi eaꞌ.” Eaꞌ Pailat naꞌipa Josep naꞌi, “Daoꞌ inaꞌ nefeꞌ nefaꞌ alop Jisasi.” ");
INSERT INTO aoj_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Fowaꞌ anis sandaꞌ anota matmat sagwasa otam luꞌunai nagal nawis nomon. Eaꞌ deiꞌ Josep naꞌi nowa Jisas matmat atamba. Eaꞌ nafeꞌ notala anona lowaf afitinai nafiꞌi natagwaha alop Jisasi nisilaꞌi ma nandaꞌ lowaf anamba nowaꞌana ma eaꞌ, nasapaꞌana nawis matmat atamba nalana nomon. Eaꞌ nambema anona otam luꞌunai nafeꞌ nowalo uta matmat atamba. ");
INSERT INTO aoj_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Anowa nematawa biawa Maria Makdalaiꞌwi kwaloma Maria maꞌma Josesi, awo walutu watologon wati anamba Josep nagawa Jisasa. ");
INSERT INTO aoj_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Nemaf afamba sagapoma nomaꞌwafi afafeꞌ hiꞌalaf, Maria Makdalaiꞌwi kwaloma Maria maꞌma Jemsi waloma Salome watala anom wel alogw fasifasimi magaꞌami. Awo waꞌi ofaꞌam ofeꞌ ondisa alop Jisasi. ");
INSERT INTO aoj_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Wafilu nemaf Sande, kuhimbita atota awo ofaꞌ wel alamba wafeꞌ matmat. ");
INSERT INTO aoj_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Awo ataꞌ wafeꞌ atin ufiaꞌw, wandaꞌipama naꞌamba waꞌi, “Atiasi ami netopalopafa nelefata otam anamba nogowalo utai?” ");
INSERT INTO aoj_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Eaꞌ watologon owaꞌ, wati otam amamba luꞌunai ina ataꞌ mape mowalo uta, owaꞌ. Anin epen aꞌ nafeꞌ nawisiꞌam mafeꞌ maꞌoh waꞌol. ");
INSERT INTO aoj_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Awo wawis matmat nomon, wati anona aman saꞌunai tol nape uta waꞌol lagol kwahisigilima. Nala anona lowaf launai afitinai. Naꞌamba awo gogolalasowa kwapeteꞌ ombel mahawa. ");
INSERT INTO aoj_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Eaꞌ anen naꞌipawa naꞌamba naꞌi, “Ipaꞌ ina aꞌ ombel mehepa, owaꞌi. Aeꞌ egawepa ipaꞌ paꞌi pifiꞌi pelaoma Jisas Nasaretinai, esis sandolana nagaꞌ lawag usiꞌigai tiꞌwanaegai. Anen aꞌ notanima nosafel eaꞌ, ina ataꞌ nape naꞌa, owaꞌ. Ipaꞌ piti naꞌa sofaꞌana sawisi salana nagalama. Deiꞌ aꞌ wafigin nape. ");
INSERT INTO aoj_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Eaꞌ ipaꞌ foꞌo piꞌipa alipumi ananimi eaꞌ piꞌipa Pita nalomam naꞌamba piꞌi, ‘Jisas aꞌ naliꞌipa nafeꞌ itap apamba Galili. Ipaꞌ pefoꞌo petolona siꞌi nimbewaꞌ nagaꞌipipa.’” ");
INSERT INTO aoj_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Eaꞌ wakwaha matmat wawisi andoꞌ aꞌ wafaꞌ wafeꞌ. Awo ombel mahawa wandaꞌam bombol atin. Eaꞌ awo ina waꞌipasa basefa anis epes, owaꞌatin. ");
INSERT INTO aoj_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Jisas notanima nosafel Sande kuhimbita atona, eaꞌ naliꞌ natagama Maria Makdalaiꞌwi, fowaꞌ nagatofamaꞌwa ambagof awami 7-pelaim magapauꞌwi. ");
INSERT INTO aoj_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Akoꞌw kwafeꞌ anagon alipumi Jisasi magapoma. Nomonas amamisi nimanis aꞌowaꞌ, mape malef. ");
INSERT INTO aoj_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Eaꞌ kwaꞌipam kwaꞌi, “Aeꞌ ati Jisas aꞌ notanima nosafel wapani nape namona.” Amom mameꞌ basef ifimba akoꞌufi, apaꞌ ina mahapifaꞌw, owaꞌ. ");
INSERT INTO aoj_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Aꞌi owaꞌ main, anom alipumi Jisasi biam makwaha wambel luꞌwagoma maila ufiaꞌw kwagafeꞌ alupi mafeꞌ. Eaꞌ Jisas nandati naꞌa nafeꞌ natagamam. ");
INSERT INTO aoj_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Amom biam matolona motanima mafeꞌ mawalapa basef ifimba ma alipumi duꞌwanim magapanii, apaꞌ amom ina mahapifam, owaꞌatin. ");
INSERT INTO aoj_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Aꞌi owaꞌ main, alipumi 11-pelaim Jisasi mape maꞌ gwaꞌaisi atin, Jisas nafeꞌ natagamam. Nimbewaꞌ anis satolona notanima nogosafel wapani eaꞌ saꞌipamana, apaꞌ owaꞌ. Amom ina mahapifas maꞌi saꞌi endilisi, owaꞌ. Maꞌi owaꞌ sambasoꞌmam atin. Eaꞌ Jisas nandaꞌ megahaham. ");
INSERT INTO aoj_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Eaꞌ naꞌipam naꞌamba naꞌi, “Ipaꞌ pefeꞌ walemb hiagoma piꞌipasa basef buꞌwafi Godi ma amam nematawa hiasi hiꞌilas. ");
INSERT INTO aoj_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Epes ami sagahapifai sofaꞌ baptais, anaf God aꞌ notanima nofaꞌasi wapani eaꞌ ananisi. Apaꞌ isimba owaꞌ sogahapifaea, anaf God aꞌ nondaꞌmas kota basef luꞌwafi ma waf awafi esis sandaꞌafi. ");
INSERT INTO aoj_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","God atiasi nondaꞌ esis isimba sogahapilafi banagesa sondaꞌ anom hiahaom banagami siꞌi anen nandaꞌami. Eaꞌ sohaliꞌ aeꞌ ma esis banagesa sigaliꞌamona ambagof awami magapaisi, a siꞌi anona diga hianai dambainai. ");
INSERT INTO aoj_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Eaꞌ sohapila uguf fagahasi lagof asasimi apaꞌ ina aꞌ fohas sogaꞌ, owaꞌ. Eaꞌ sogaꞌ embel numbutimbeli wapani, esis ina aꞌ sogaꞌ, owaꞌ. Apaꞌ anis owaꞌ sogahapifaea, sogaꞌ embel ambalimbai, aꞌ sogaꞌ. Eaꞌ atiasi esis isimba sogahapifai sosa lagofa anis aowas nandaꞌasi amboꞌwes wapani.” ");
INSERT INTO aoj_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Dembinai Jisas nawalipas naꞌipas eaꞌ, God nofaꞌana nalota heven. Eaꞌ nofaꞌ agol luꞌwagili nape lagol kwahisigili Godi banagagili. ");
INSERT INTO aoj_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Eaꞌ alipumi ananimi aꞌ mafeꞌ ganimba walemba hiagoma mawalapa basef Godi. Anen nowaꞌ banagama mandaꞌ maol banagani siꞌi God nandaꞌani. Anis daias sati maol inimba saꞌi, “Endilisi atis, God natopalopama basef buꞌwafi endilisi.” Basef ifimba eaꞌ maꞌuf. ");
INSERT INTO aoj_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","O dembinai Tiofilus, fowaꞌ amam hiami mandaꞌ basef hiafi faila hiahaom hiami God nandaꞌam magataga laꞌafena afaꞌi, amom ukup patapeamb mandaꞌef fagaili. ");
INSERT INTO aoj_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Fowaꞌ dambadamba Jisas nasefela maol nandaꞌan anom alipumi ananimi mati hiahaom amamba naep amamipi deiꞌ mawalipapa basef ifimba eaꞌ anom daiam mandaꞌef fail. ");
INSERT INTO aoj_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Aeꞌ ahaliꞌ anisa maol inimba, afiꞌi afiꞌi deiꞌ andaꞌef andeandeꞌ siꞌi fowaꞌ fagataga. Anom daiam mihimbaꞌmef deiꞌ aeꞌ egawa basef kofagefa. Isimba atis deiꞌ aeꞌ ilagon andeandeꞌma endaꞌ anif basef fegafeꞌmago inaꞌ dembinai Tiofilus. ");
INSERT INTO aoj_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Andaꞌefa inaꞌ negegawa basef ifimba kofagefa esis sagawalipinafi endilisifi atif. ");
INSERT INTO aoj_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Nemaf afamba anona king Herot dembinai ma gavmani nugumafi anis epes sagape anep itap luꞌupa Judiai, anona aman pris nape, agilinama Sekaraia. Anen anep miniꞌap amom anona aman dembinai fowaꞌinai Abiya. Sekaraia wauluꞌmana Elisabet. Akoꞌw kwagataga wambota anona aman Erani. ");
INSERT INTO aoj_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Esis bias Sekaraiai Elisabet sape usiꞌisa naep Godi saila muꞌuli ananini hiani hiꞌalan. Eaꞌ saila basef Godi andeandeꞌ datima, kofagema akas. ");
INSERT INTO aoj_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Apaꞌ Elisabet asaꞌw eaꞌ esis bias awasi akas, ahages eaꞌ. ");
INSERT INTO aoj_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Nogota atamba amom miniꞌap Sekaraiai nemaf amamifi fataga ma mondaꞌ maol, eaꞌ Sekaraia nawis ipat luꞌunai Godi nandaꞌ maol nondolalima God. ");
INSERT INTO aoj_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Amom pris maila waf amamifi mandandepana ma nogawis ipat anamba nomon nogaofa hiahaom amamba nogoh alogw fasigwi gwagami. ");
INSERT INTO aoj_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Nogota atamba anen nawis nagaofam, esis amam nematawa hiasi sunduwaꞌanima sape sandabeten andoꞌ. ");
INSERT INTO aoj_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Eaꞌ Sekaraia nati anona ensel dembinai Godi nataga nalutu belita waꞌol lagol kwahisigilima. Belita atamba amom pris mondolalima Goda hiahaom amamba alogw fasigwi gwagaꞌami. ");
INSERT INTO aoj_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Eaꞌ Sekaraia natolona agogolalasana ombel mahana nomonas salasafeꞌma ensel anamba. ");
INSERT INTO aoj_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Owaꞌ ensel anamba naꞌipana naꞌamba naꞌi, “Sekaraia, ina ombel mehena, owaꞌi. God nameꞌenama beten ineꞌini eaꞌ. Wauluꞌmina ineꞌikwi Elisabet namanani akola anin awani aman ineꞌini. Eaꞌ inaꞌ nefalana agol ananigili Jon. ");
INSERT INTO aoj_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Nembel ineꞌimbili atiasi nepe andeandeꞌ sonohenama awani inimba. Eaꞌ esis amam nematawa hiasi wapani asonohasa awani inimba nagataga. ");
INSERT INTO aoj_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Deiꞌ main, anin anaf netaga dambeni agol luꞌwagili ma naep Dembinaii. Anin ina neaꞌ embel wainimbel beloma embel banagami, owaꞌatin. Anin ataꞌ nagape opaf maꞌmanai, Ambal buꞌunai Godi napain siꞌin nowaꞌ banagan. ");
INSERT INTO aoj_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Anaf anin netaga damben negambema amam nematawa hiasi Israeli ma nefaꞌas sotanimai sogafeꞌma God Dembinai asasinai. ");
INSERT INTO aoj_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Anin aꞌ niliꞌ nefeꞌma Dembinai nefaꞌ banagami Godi ma nendaꞌ maol ananini siꞌi fowaꞌ Elaija nofaꞌama nandaꞌan. Eaꞌ nembema nelelemb ahapasi befeꞌma awasi ma esis nomonas sondaima atin. Eaꞌ nembema epes isimba sogosambala basef Godii ma sogofaꞌ nomonas fasisi siꞌi epes buꞌwasi ma netopalopas nendaꞌas sondandombol sogapoma Dembinai nogafiꞌi.” ");
INSERT INTO aoj_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Eaꞌ Sekaraia nahaliꞌ ensel anamba naꞌi, “Aeꞌ atiasi iti ametal maila egegawa basef ifimba fegataga endilisi? Aeꞌ hagewe eaꞌ wauluꞌmi wapani eaꞌ hageꞌw.” ");
INSERT INTO aoj_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Eaꞌ ensel nagwamana basef naꞌi, “Aeꞌ Gebriel, agalutu naep Godi. Anen atona nasapaꞌe afiꞌi aꞌipina basef ifimba fasifi. ");
INSERT INTO aoj_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Eaꞌ inaꞌ aꞌ nameꞌ, apaꞌ inaꞌ owaꞌ nihapila basef aeꞌafia. Eaꞌ deiꞌ malogol ineꞌigili ageseꞌena, ina atiasi niꞌi, owaꞌatin. Aꞌ nefeꞌ nefeꞌ netagama hiahawes isimba aeꞌ agaꞌiasi sogataga. Basef ifimba aeꞌafi atiasi fetaga naꞌamba atin anef nemaf God nagaꞌiefi.” ");
INSERT INTO aoj_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Eaꞌ esis amam nematawa hiasi sape sohafa Sekaraia andoꞌ nomonas sandandaꞌ saꞌi, “Nogota laota main natagamana ipat luꞌunai Godi nomon?” ");
INSERT INTO aoj_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Ama nawisi andoꞌ owaꞌ, ina naꞌi anif basefa esis, owaꞌ. Naꞌamba esis sogawana saꞌi anen nati anom maefah mandati naꞌai ipat luꞌunai Godi sandaꞌ lotuma nomon. Eaꞌ anen nape nandaꞌmasa lagol atogol naꞌipasa hiahawes, apaꞌ malogol ananigili agasoꞌana gape. ");
INSERT INTO aoj_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Ama maol Sekaraiai hiꞌalan, notanima nafeꞌ wambel ananimbili. ");
INSERT INTO aoj_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Aꞌi owaꞌ main, wauluꞌmana ananiꞌwi Elisabet aꞌ opafuꞌw. Eaꞌ kwandambahoꞌ atin kwape ipat aomb wanemb biamb a kwaꞌi naꞌamba kwaꞌi, ");
INSERT INTO aoj_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Deiꞌ Dembinai okom maimaili ma nagatopalope naꞌamba. Fowaꞌ aeꞌ asawe, ambal aeꞌanai aona ma esis amam nematawa apaꞌ deiꞌ aꞌ owaꞌatin.” ");
INSERT INTO aoj_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Elisabet eaꞌ opafuꞌwa aomb wanemb biamb eaꞌ, deiꞌ anin wapani aꞌ wanemb wanemb. Deiꞌ God nasapaꞌ ensel anamba Gebriel nafeꞌ anambel wambel Nasaret bagape itap luꞌupa Galilii. ");
INSERT INTO aoj_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Wambel ambalemba anoꞌw nemataꞌw saꞌukwi aiawaiꞌwi kwape, agol akwaꞌugili Maria. Ina deiꞌ kwasoꞌ anona aman, ataꞌ owaꞌ. Deiꞌ sandandepaꞌwa kogasoꞌ anona aman agilinama Josep. Aman anamba nagataga wambota atamba akunamana dembinai Deviti. ");
INSERT INTO aoj_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Eaꞌ ensel anamba nafeꞌma akoꞌw naꞌi, “Nemaf buꞌwafi, nemataꞌw. Dembinai God okom maimailina aꞌowaꞌ. Anen nofaloꞌmena nape nalomena dondol numafina.” ");
INSERT INTO aoj_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Maria kwameꞌ basef ifimba nomonas akwaꞌusi aꞌ nimanis endilisi. Okom akwaꞌumi mandandaꞌ maꞌi, “Kofagefa faꞌi main?” ");
INSERT INTO aoj_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Eaꞌ ensel anamba naꞌipaꞌw naꞌi, “Maria, ina ombel mohena, owaꞌi. Okom Godi boꞌonama inaꞌ. ");
INSERT INTO aoj_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","32","Inaꞌ nemeꞌ. Atiasi inaꞌ upafina aꞌ nela anin awani aman. Eaꞌ nendaꞌmana agol Jisas. Anin anaf aꞌ nepe aman dembeni, sosaꞌma agol ananigili luꞌwagol. Eaꞌ siꞌi anen Nogamana God nagape ilifi. Anaf dembinai God aꞌ nondaꞌ awani inimba nepe dembinai king siꞌi fowaꞌ gani Devit nagape king. Devit anen wambota atamba deiꞌ awani inimba nagatagatai. ");
INSERT INTO aoj_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Anin anaf nepe dembinai king numafi miniꞌap Jekopi lifilafi. Anin atin nepe damben atapin lifilafi anamba anin nagalaꞌambemagoma. ");
INSERT INTO aoj_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Eaꞌ Maria kwaꞌipa ensel anamba kwaꞌi, “Amamba motaga miꞌimama? Aeꞌ ina deiꞌ asoꞌ anona aman, ataꞌ owaꞌatin.” ");
INSERT INTO aoj_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Eaꞌ ensel anamba nagwamaꞌwa basef naꞌi, “Ambal buꞌwali Godi nifiꞌmai inaꞌ, banagami God nagape ilifi mosoꞌalina. Eaꞌ deiꞌ awani inimba atiasi negalani anin boꞌwen hililiꞌi. Eaꞌ esis atiasi sosaꞌma agol ananigili luꞌwagol sofalana siꞌi anin Nogamana Godi. ");
INSERT INTO aoj_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Nemeꞌ, amaniꞌmina ineꞌikwi Elisabet akoꞌw hageꞌw eaꞌ, owaꞌ deiꞌ aꞌ opafuꞌw. Fowaꞌ esis saꞌi, ‘Akoꞌw asaꞌwi’, apaꞌ deiꞌ akoꞌw aꞌ opafuꞌw aomb wanemb wanemb akwaꞌumbi aꞌ bafeꞌ eaꞌ. ");
INSERT INTO aoj_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Owaꞌ anom maefah ahifima God nondaꞌama, owaꞌatin.” ");
INSERT INTO aoj_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Eaꞌ Maria kwagwamana kwaꞌi, “Aeꞌ ape andaꞌ maol Dembinaii. Aeꞌ aꞌi anen nondaꞌmeas siꞌi inaꞌ nagaꞌi.” Ensel anamba naꞌipaꞌw naꞌamba ma eaꞌ, nakwahoꞌw aꞌ nafeꞌ. ");
INSERT INTO aoj_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Afamba Maria kosafel kwafalis kondowasaꞌ anambel wambel bagape halafutagwi anep itap luꞌupa Judiai, ");
INSERT INTO aoj_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","kwafeꞌ kwawis ipat Sekaraiai kwandaꞌmaꞌwa nemaf buꞌwafi Elisabet. ");
INSERT INTO aoj_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Elisabet kwameꞌ Maria ataꞌ kwandaꞌmaꞌwa gude atin, awani Elisabati feteꞌ atin nape opaf akwaꞌufi nomon. Eaꞌ Ambal buꞌunai Godi siꞌinama akoꞌw, ");
INSERT INTO aoj_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","koga kwaꞌi mehip kwaꞌi, “God nofaloꞌmena nandaꞌena dagalaina endilisi. Dagala ineꞌini nikilaꞌ dagala anowa daiawa ogofaꞌani. Eaꞌ awani inimba atiasi nigalani, anin wapani God nofaloꞌman nondaꞌan sonohan. ");
INSERT INTO aoj_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Aeꞌ gogolalasowe ma God okom boꞌoma aeꞌ nandaꞌe sonagahe ma nandaꞌ inaꞌ maꞌma Dembinai aeꞌanai nagafiꞌmai aeꞌ. ");
INSERT INTO aoj_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Nemeꞌ, aligah aeꞌagahi ataꞌ hameꞌ nemaf buꞌwafi ineꞌifi atin, owaꞌ batawin nagape opaf aeꞌafii sonahan afeteꞌ atin nape. ");
INSERT INTO aoj_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Inaꞌ aꞌ dagalaina endilisi, nagahapila basef Dembinai nagaꞌipinafi atiasi aꞌ fetaga naꞌamba atin siꞌi anen naliꞌ nagaꞌipina.” ");
INSERT INTO aoj_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Eaꞌ Maria kwandaꞌ anof awaf kwaꞌi, “Aeꞌ aꞌi basefa anen Dembinai asaꞌma agol ananigili luꞌwagol. Okom aeꞌami mapoma basef ifimba ");
INSERT INTO aoj_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","ma God nofaꞌe egetanimai. Deiꞌ sonahe ma anen. ");
INSERT INTO aoj_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Deiꞌ main? Aeꞌ nemataꞌw andaꞌ maola anini, aeꞌ falafuwai, owaꞌ anen aꞌ okom mapoma aeꞌ natopalope. Ipaꞌ pemeꞌ. Deiꞌ atapiwi epe anaf owagama wapani hiasi tagahafel sogapani amam nematawa esis sofale siꞌi, ‘Dembinai God natopalope nagaseꞌe dagala.’ ");
INSERT INTO aoj_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","God banagona aꞌowaꞌ nandaꞌme hiahaom banagami ma aeꞌ eaꞌ agol ananigili luꞌwagol gape hililiꞌ atapigil. ");
INSERT INTO aoj_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Okom uwahipimi ananimi magape atapima epes mamahisa ombel mahasa saꞌi sogagiꞌma anini. Eaꞌ mape atapim maloma epes isimba eaꞌ sope naꞌamba atin deiꞌ awasi bafas ihas anaf sigiꞌ sogatagai. ");
INSERT INTO aoj_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Lagol ananigili nandaꞌ hiahaom banagami. Eaꞌ ukup asasipi sagaꞌi esis atis agof luꞌwagufi aꞌ naliꞌamonas safaꞌ safeꞌ gani gani daindaiagon. ");
INSERT INTO aoj_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Anen natalogofa amom king dembami eaꞌ nasaꞌma agofa isimba agof akasi. ");
INSERT INTO aoj_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Anen nasoꞌasa hiahaom fasimi ma isimba nolomagahasa waf fasifii, apaꞌ epes isimba hiahaom hiamisi, natofam mafeꞌ dowaf. ");
INSERT INTO aoj_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Anen okom mapoma basef fowaꞌ nalaꞌ lap nagaloma bafapapa akupapafi. Basef ifimba fowaꞌ naꞌipa Abraham naloma wambota ananisi owagama sigiꞌ sogatagai. Ama owagama nigati esis owahipisa nogatopalopas lifilafi. Anen nagatopalopa apaꞌ Israel mandaꞌ maol ananinii.” ");
INSERT INTO aoj_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Eaꞌ kwape kwaloma Elisabet aumb wanemb. Aꞌi owaꞌ main, akutanima kwafeꞌ wambel akwaꞌumbili. ");
INSERT INTO aoj_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Nemaf afamba fataga eaꞌ Elisabet kogola awani aman. ");
INSERT INTO aoj_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Esis wambel atembel ambep atep akoꞌw Elisabeti a sogawa Dembinai nati uwahipiꞌw endilisi ma kogola awani inimba. Eaꞌ esis sandagala salomaꞌw. ");
INSERT INTO aoj_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Nimaguf 7-pelaif afafeꞌ faloꞌwan eaꞌ, nemaf fagafeꞌma 8i, esis safiꞌi saꞌi siti amom mogatopaꞌmana alop ananipi, eaꞌ esis saꞌi sofalana agol Sekaraia siꞌi ahamana. ");
INSERT INTO aoj_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Owaꞌ maꞌamana kwaꞌi, “Owaꞌ. Apaꞌ mondaꞌmana anagol agol Jon.” ");
INSERT INTO aoj_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Eaꞌ esis saꞌipaꞌw saꞌi, “Owaꞌ, anis ambep ineꞌipi tagasi ina anis sandaꞌ agol agalemba Jon, owaꞌatin.” ");
INSERT INTO aoj_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Eaꞌ sandaꞌ lagof atogof sahaliꞌ ahamana saꞌi anen naꞌi nondaꞌmana agol maigil nogamana. ");
INSERT INTO aoj_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Anen nandaꞌ logof atogof naꞌipas sofaꞌai anota selet, a nondaꞌ agol nogamanai. Eaꞌ nandaꞌagol naꞌi, “Agol ananigili Jon.” Eaꞌ esis agogolalasis kwapeteꞌ. ");
INSERT INTO aoj_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Anen ataꞌ nandaꞌ agol atin owaꞌ, aꞌ noga naꞌi malogol ananigili, afega ananigai agiawi andeandeꞌ, nandagala nasaꞌma agol Godi luꞌwagol. ");
INSERT INTO aoj_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Eaꞌ hiasi esis wambel atembel ananimbili ombel mahas. Eaꞌ deiꞌ hiahawes isimba gatis safeꞌagon hiꞌalagon walemb ambalemba bagape halafutagw itap luꞌupa Judiai. ");
INSERT INTO aoj_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Eaꞌ amam nematawa hiasi sameꞌ basefa hiahawes isimbai, ukup asasipi pandandaꞌ pafeꞌ saꞌi, “Anaf awani inimba nepe niꞌimama? Anin atiasi aꞌ netaga aman dambeni endilisi.” Esis sogawa banagami Dembinaii mape malomana. ");
INSERT INTO aoj_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Awani inimba Jon ahamana Sekaraia, Ambal buꞌunai Godi nape siꞌina anen eaꞌ nawalapa basef Godi siꞌi amom profet fowaꞌ magaꞌipasef naꞌi, ");
INSERT INTO aoj_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Aeꞌ aꞌi apaꞌ mosaꞌma agol Godi Dembinai luꞌwagol, God apaꞌ Israeli anen nafiꞌi natopalopa apaꞌ amam nematawa ananipai. Eaꞌ natalepa magakwaha waf awafi apaꞌ mandaꞌafi. ");
INSERT INTO aoj_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Eaꞌ nandandepa anona aman banagonai atiasi nofaꞌapa nokwahamapa waf awafi mogotanimai. Fowaꞌ gani Devit nandaꞌ maol Godi, apaꞌ deiꞌ aman anamba nofaꞌapa mogotanimai, anen akunamana Deviti. ");
INSERT INTO aoj_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Basef ifimba siꞌi fowaꞌ gani nagawalapefa amom profet buꞌwami ananimi magaꞌif malogof amamugufi. ");
INSERT INTO aoj_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Maꞌi anaf anen nofaꞌapa mokwaha lagof esis bousi apeꞌisi soloma epes isimba ukup aom endilisi ma apeꞌi. ");
INSERT INTO aoj_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Fowaꞌ anen naꞌi anaf aꞌ niti akusapa apeꞌisi fowaꞌisi uwahipis notopalopas. Eaꞌ anen okom mopoma basef buꞌwafi fowaꞌ nagalaꞌ lapafi. Anen ina atiasi niꞌi anif daif, owaꞌ. ");
INSERT INTO aoj_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Anen naꞌi basef ifimba endilisifi atif nagaꞌif banagafi ma akunamapa apeꞌinai Abraham. Eaꞌ deiꞌ naꞌif naꞌamba atin siꞌi fowaꞌ nagaꞌias. ");
INSERT INTO aoj_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Anen naꞌi notagwahepa ma lagof esis bousi apeꞌisi ma mondaꞌmana maol ananini, apaꞌ ina aꞌ ombal mohapa, owaꞌ. ");
INSERT INTO aoj_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Apaꞌ mope itap apaꞌe mondaꞌ maol ananini nimaguf hiafi danda mofeꞌ mofeꞌ motagama mogagaꞌ. Ma nogohnaep ananisi mondaꞌ maol inimba ma waf ananifi usiꞌif hililiꞌi. ");
INSERT INTO aoj_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","“Eaꞌ inaꞌ, awani aeꞌinai, basef ineꞌifi ifimba. Anaf God aꞌ niꞌi inaꞌ profet nandaꞌ maola God nagape ilifi. Ama atiasi inaꞌ nefeꞌ nigaliꞌma Dembinai negandombamana ufiaꞌw ananiꞌwi. ");
INSERT INTO aoj_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Ama negawalipa amam nematawa ananisi nogakwahowa waf awafi asasifi. Anen nandaꞌas naꞌamba ma sogogawa anen nofaꞌ esis sogotanimai. ");
INSERT INTO aoj_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","God apeꞌinai nati esis uwahipis aꞌowaꞌ deiꞌ nakwahamasa waf awafi asasifi. Anen atiasi nosapaꞌi mogogalaꞌi magape heveni mifiꞌmai apaꞌ mope atapim. ");
INSERT INTO aoj_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Ama mogogalaꞌma epes sagape akoti, a isimba gaꞌ naꞌi nogatagamasi. Anen nisindiꞌamona apaꞌ ma mogafeꞌ ufiaꞌw opalef awanelefaꞌwi.” ");
INSERT INTO aoj_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Aꞌi owaꞌ main, awani inimba nataga luꞌwin banagona eaꞌ okom ananimi aꞌ nogawa. Anen nape itap wafigima epes akagoma nape nape ma nemaf afamba nataga nandawalap alihinama naep esis Israeli. ");
INSERT INTO aoj_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Anef nemaf anona aman gavman dembinai esis Romi Sisar Ogastus nagape, nandaꞌ anin muꞌuli gavmani naꞌamba. Anen naꞌi nofaꞌ agofa esis amam nematawa hiasi hiꞌilasa fugail buk gavmani. ");
INSERT INTO aoj_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Afamba dambadamba anen naliꞌ nogofaꞌ agof. Afamba anona aman Sairinias nagape gavman dembinai ma anep itap Siria. ");
INSERT INTO aoj_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Isimba atis amam nematawa hiasi safeꞌ wambel kofagama asasimbili ma sondaꞌ agof asasigufi. ");
INSERT INTO aoj_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Josep anona aman anamba anep ambep esimbel Deviti. Anen nakwaha Nasaret nagape anep itap luꞌupa Galilii, eaꞌ nondowasaꞌ nafeꞌ wambel Deviti Betlehem. Wambel ambalemba bagape anep itap luꞌupa Judia. ");
INSERT INTO aoj_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Eaꞌ Josep nafeꞌ naloma anoꞌw nemataꞌw Maria, esis sandandepanaꞌw saꞌi nogasoꞌakwi ma esis bias sondaꞌ agof asasigufi. Eaꞌ akoꞌw opafuꞌw. ");
INSERT INTO aoj_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Esis bias ataꞌ sapani atin wambel Betlehem, owaꞌ nemaf akoꞌw kogolanafi aꞌ fataga. ");
INSERT INTO aoj_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Eaꞌ kwaliꞌ kola awani aman akoꞌuni nagaliꞌi. Ipat esis hiasi sakolata sagapautai asiꞌita aꞌowaꞌ. Eaꞌ deiꞌ kwandaꞌ lowaf kwasalaꞌuf kwala anin naꞌoh nomon bokis gwaꞌaisi bulmakauwi sagalama. ");
INSERT INTO aoj_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Felefeleꞌma wambel ambalemba anom amam mugumafi sipsipi mape waꞌol otalef walol mogotaoma mumafi sipsip mape owamb. ");
INSERT INTO aoj_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Owaꞌ anona ensel nafiꞌi nalumai mogogalaꞌi Dembinaii, mogalaꞌ malaꞌambema amom eaꞌ ombal maham endilisi. ");
INSERT INTO aoj_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Owaꞌ, ensel anamba naꞌipam naꞌi, “Ipaꞌ ina ombal mehepa, owaꞌi. Pemeꞌ, aeꞌ ifaꞌmipai basef buꞌwafi ipaꞌ, ifimba fendaꞌ amam nematawa hiasi hiꞌilas sonogahas endilisii. ");
INSERT INTO aoj_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Deiꞌ nemaf afaꞌe anoꞌw nemataꞌw kwagape Betlehem wambel Deviti kola anin awani aman. Anen aman anamba nokwahomepa waf awafi nofaꞌepa pigitanimai. Anen Krais, God nandandepana nasapaꞌana nagafiꞌii, Dembinai. ");
INSERT INTO aoj_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Ipaꞌ pefeꞌ piti awani inimba pegegawan naꞌamba. Piti sandaꞌ lowaf kwasalaꞌuf sowaꞌan salan naꞌoh bokis isimba sagala gwaꞌaisi bulmakauwi sagalama.” ");
INSERT INTO aoj_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Ensel anamba naꞌias naꞌamba ma eaꞌ, owaꞌ kwafalis anom ensel hiami banagami misilaꞌi gani heven mataga maloma ensel anamba eaꞌ mandagala mafela agol Godi maꞌi, ");
INSERT INTO aoj_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Apaꞌ masaꞌma agol God nagape gani ilif endilisii luꞌwagol. Banagami mogogalaꞌi ananimi atom. Eaꞌ epes ami sagape itapi God okom boꞌoma esisi, nelelemb asasilimbi bepe awanelemb.” ");
INSERT INTO aoj_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Eaꞌ amom ensel makwaha amom mugumafi sipsipi motanima malota heven. Eaꞌ amom mugumafi sipsipi mandaꞌipama atin maꞌi, “Wale, ataꞌ ofeꞌ Betlehem uti hiahaom amamba Dembinai nigihimbaꞌmafami.” ");
INSERT INTO aoj_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Eaꞌ mosafel kwafalis mafeꞌ mati Maria kwaloma Josep sape. Awani salan naꞌoh bokis nomon sagala gwaꞌaisi bulmakauwi sagalama. ");
INSERT INTO aoj_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Amom matilin eaꞌ mawalapa basef ensel nagaꞌipamafi ma awani inimba. ");
INSERT INTO aoj_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Eaꞌ amam nematawa asameꞌ basef ifimba amom magaꞌiefi, esis hiasi sameꞌ basef ifimba agogolalasis eaꞌ nomonas hiahawes sapomef. ");
INSERT INTO aoj_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Apaꞌ Maria kwameꞌ basef ifimba hiafi nomonas sapomef fape okom akwaꞌumi. ");
INSERT INTO aoj_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Eaꞌ amam amamba motanima mafeꞌ masaꞌma agol Godi luꞌwagol maꞌi anen Dembinai buꞌwinai. Amom sonahama hiahaom amamba hiami mameꞌam magatulumi, aꞌ mataga siꞌi ensel magaꞌipamami. ");
INSERT INTO aoj_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Aꞌi owaꞌ nemaf fagafeꞌma 8i fataga, nemaf afamba amom maꞌi motopaꞌmana alop awani. Eaꞌ matopaꞌmana alop awani inimba amani. Eaꞌ sofalana agol Jisas siꞌi ensel naliꞌ nagaꞌipaꞌwagili nogota atamba owaꞌ ataꞌ kogofaꞌ opafa. ");
INSERT INTO aoj_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Nemaf afamba fataga eaꞌ ma esis sondaꞌ awani inimba noloma maꞌmana sondolali sondaꞌ ofa sowandoꞌ alogwa sogataga boꞌwes siꞌi basef fagail muꞌuli inimba fowaꞌ God nagasoꞌ Mosesani fagaꞌias. Eaꞌ esis mamasana saoꞌwana safeꞌ sondowasaꞌ Jerusalema sogasoꞌana awani inimba Dembinai Goda nogohnaep ananisi. ");
INSERT INTO aoj_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Esis sandaꞌas naꞌamba siꞌi basef fagape buk Baibeli fagaꞌiasa muꞌuli Dembinaii faꞌi, “Awasi amam amamba mamahoma waliꞌ dambadamba ogolami, amamba ipaꞌ pefalam piꞌi amom dembinai Godi atom.” ");
INSERT INTO aoj_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Esis bias saꞌi sondolalima God sagiꞌma basef fagail muꞌuli inimba Dembinai naꞌipa Moses nagaꞌi, “Esis bias sofaꞌ amiguf maꞌunamb biamb, aꞌa sofaꞌ mefagof saꞌugufi biagof.” Sofaꞌas sandaꞌas naꞌamba. ");
INSERT INTO aoj_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","26","Eaꞌ anona aman nagape Jerusalami agilinama Simeon. Anen nagagiꞌma waf fasifi Godi nagape hililiꞌi. Anen nape nasasa nogota atamba God nifiꞌi notopalopa esis Israel nogakwaha akafimi asasimi. Eaꞌ Ambal buꞌunai Godi nape okom ananimi nihimbaꞌmana anen ina atiasi nogaꞌ ulal, owaꞌ. Anen ataꞌ nope niti Krais, Dembinai nandandepana nosapaꞌana nogafiꞌii. ");
INSERT INTO aoj_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Ambal buꞌunai Godi nasaꞌmana nafeꞌ nawis ipat luꞌunai Godi. Eaꞌ esis mamasa Jisasi saoꞌwana safiꞌi sondolalimana siꞌi muꞌuli Godi nagaꞌias. ");
INSERT INTO aoj_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Eaꞌ Simeon nandalombasana lagof ananigufi nanifela God nasaꞌma agol ananigili luꞌwagol naꞌias naꞌamba naꞌi, ");
INSERT INTO aoj_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“O Dembinai, aeꞌ andaꞌ maola ineꞌi. Deiꞌ inaꞌ kwahowae nomonas sope saꞌombel aꞌ egaꞌ efoꞌo siꞌi basef ifimba fowaꞌ nagaꞌiefi. ");
INSERT INTO aoj_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Naep aeꞌapi atilin eaꞌ awani aman inimba inaꞌ nasapaꞌana nafiꞌi nuwambilapa nokwahomapa waf awafi mogotambilii. Naꞌamba deiꞌ inaꞌ nekwahowa aeꞌ aꞌ egaꞌ efoꞌo. ");
INSERT INTO aoj_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Inaꞌ nandaꞌ awani inimba dumbulidombola amam nematawa hiasi sogatolona. ");
INSERT INTO aoj_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Anen siꞌi anona nogogalaꞌi nogogalaꞌma epes isimba sogololama Godi nigihimbaꞌmas. Ama nondaꞌ amam nematawa ineꞌisi Israel sogofaꞌ agof luꞌwagufi.” ");
INSERT INTO aoj_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Eaꞌ mamasana Jisasi agogolalasis nomonas salasafeꞌma basef ifimba Simeon nagaꞌiefi. ");
INSERT INTO aoj_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simeon naꞌipas basef fasifi nowaꞌ banagas eaꞌ naꞌipa maꞌmana Jisasi naꞌamba naꞌi, “Inaꞌ nemeꞌ. Awani inimba God nandandepan eaꞌ ma nogohambombaga anis amam nematawa Israel sogowaꞌ alafugaha anini. Apaꞌ anis daias nofaꞌas sokwaha waf awafi sigafiꞌmai anini. Anen siꞌi anol ametal God nandaꞌali ma anis hiasi sondaꞌmana duꞌwaniga sondaiwaꞌma basef ananifii. ");
INSERT INTO aoj_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Awani inimba napoma negawalapa nomonas hiasi sape sandambahiꞌi sogataga alihis. Maria, inaꞌ atiasi aꞌ okom nimanim siꞌi anona bainat hikalinai nogatopaꞌ okom ineꞌimi.” ");
INSERT INTO aoj_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Eaꞌ anoꞌw nemataꞌw profet agiliꞌwa Ana. Ahamaꞌw akoꞌunai Fanyuel. Ambep akunamaꞌwi Aser. Akoꞌw ahageꞌw aꞌowaꞌ. Fowaꞌ kwasoꞌ aman kwalomana sape afagof 7-pelaiguf. ");
INSERT INTO aoj_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Aꞌi owaꞌ main, waulunamaꞌw aꞌ nagaꞌ. Eaꞌ kwape dowaf, kwafeꞌ kwafeꞌ deiꞌ afagof akwaꞌugufi fataga 84-pelaiguf. Akoꞌw ina kwaꞌwaha ipat luꞌunai Godi anif nimaguf, owaꞌatin. Akoꞌw kololama gwaꞌaisi kwape kwandabeten eaꞌ kwandaꞌ lotu kwahapila maol Godi kwandaꞌan kwafeꞌ owamb alip. ");
INSERT INTO aoj_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Nemaf afamba atef akoꞌw kwafiꞌi anamba Simeoni Josep Maria sagalutuma kwanifela God. Anis wapani sagalutu naꞌambai sape sogohafa nemaf afamba God nogatopalopa esis sagape Jerusalami sogape wahifis. Eaꞌ akoꞌw wapani kwaꞌipas basefa awani inimba. ");
INSERT INTO aoj_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Esis Josepi Maria sandaꞌas sagiꞌmas eaꞌ maol inimba siꞌi Dembinai fowaꞌ nagaꞌiasa muꞌuli ananini eaꞌ sotanima safeꞌ Nasaret asasima kofagama. Wambel anamba bape anagon itap luꞌupa Galili. ");
INSERT INTO aoj_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Eaꞌ awani Jisas andambena aꞌ nataga banagona ma gawa hiani luꞌwani. Eaꞌ God okom maimailana natopalopana nowaꞌ banagona. ");
INSERT INTO aoj_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Afagof danda mamasana Jisasi sondowasaꞌ safeꞌ Jerusalema esis Juda sandaꞌ gwaꞌaisi luꞌwasi sofalas sagaꞌi Pasovai. ");
INSERT INTO aoj_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Afagof Jisasi deiꞌ afataga 12-pelaiguf faloꞌwana eaꞌ saoꞌwana sondowasaꞌ Jerusalem saila waf asasifi siꞌi afagof danda sandaꞌafi. ");
INSERT INTO aoj_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Ama nimaguf ifimba Pasovaefi aꞌ fafeꞌma hiꞌalef, esis mamasana sotanima safeꞌ. Apaꞌ saꞌunai ina nafeꞌ nalomas, owaꞌ. Asakwahona napani Jerusalem. Esis ina sogawa anen napani, owaꞌ. ");
INSERT INTO aoj_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Saꞌi owaꞌ aꞌ naliꞌ nafeꞌ naloma anis daias safeꞌ. Esis asafeꞌ anef nemaf siꞌifi hiꞌalaf, eaꞌ asala naepa anen solaomana laꞌafena esis wambota atota saloma esis alipisi. ");
INSERT INTO aoj_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Esis mamasana solaomana lawa lawa sati owaꞌatin, eaꞌ sotanima safeꞌ Jerusalem solaomana. ");
INSERT INTO aoj_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Esis bias solaomana safeꞌ nimaguf wanif ahiꞌalef. Aꞌi owaꞌ main, asatolona nape nomon ipat luꞌunai Godi. Anen nape naloma amom gawaimi magawalipasa muꞌuli Godii. Nape nagahembeꞌma basef amamifi atapina eaꞌ nahaliꞌamef. ");
INSERT INTO aoj_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Amom dembami maloma esis hiasi sameꞌ basef ananifi, agogolalasisa basefi gawa ananini nagagwamama basef amom. ");
INSERT INTO aoj_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Eaꞌ mamasana satolona nape laꞌafena amom dambedambena nalomam mape eaꞌ gogolalasis kwapeteꞌ. Eaꞌ maꞌmana kwaꞌipana kwaꞌi, “Nogame, deiꞌ maina nandaꞌ isimbai ma afaꞌ? Ahamena naloma aeꞌ opalef afaꞌilifi aꞌ nimanilif aꞌowaꞌ ma ogolaomena.” ");
INSERT INTO aoj_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Eaꞌ anen nagwamas naꞌipas naꞌi, “Deiꞌ maina ipaꞌ bipa palaꞌ pelaome pagafeꞌ hiꞌagalagon? Aeꞌ deiꞌ ape andaꞌ maol ipat ahame Godi, isimba ipaꞌ pegawas aꞌa owaꞌ?” ");
INSERT INTO aoj_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Owaꞌ esis ina sogawa basef anen nagaꞌipasafi kofagefa, owaꞌatin. ");
INSERT INTO aoj_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Eaꞌ Jisas nafeꞌ naloma esis bias asiliana Nasaret, nameꞌ esis dondol naila malogof asasigufi. Eaꞌ maꞌmana ananiꞌwi okom mapoma basefa hiahawes isimba sagatagama awani akwaꞌuni fape okom akwaꞌumi. ");
INSERT INTO aoj_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Jisas eaꞌ nataga dambena. Eaꞌ gawa ananini nataga luꞌwin andeandeꞌ fasin, eaꞌ God naloma epes wapani sagatolona amboꞌona aꞌowaꞌ. ");
INSERT INTO aoj_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Anagol afagol anona gavman dembinai esis Romi Taiberius Sisar nagape dembinai ma itap luꞌupa hiagoma esis Romi afagof 14-pelaiguf hiꞌalagofa anagol wapani, gagafeꞌma 15-pelaigufi, Pontius Pailat ataꞌ nape dembinai gavmana walemb hielimbi agol Judia. Anona aman Filip nape gavman dembinai numafi itap apamba luꞌupa Ituriai Trakonitis walemb hielimbi. Eaꞌ owamana ananinai Herot ataꞌ nape dembinai numafi walemb hielimbi agol Galili. Anona aman Lisanias nape dembinai gavman numafi hiagoma agol luꞌwagola Abileneai. ");
INSERT INTO aoj_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Eaꞌ afagol agalemba atogol Anasi Kaiafas amom biam pris dembami mape magaliꞌma pris hiamii. Nogota atamba ma afagol agalemba basef Godi fafiꞌmai Jon, Sekaraia nogamana. Anen nape anep itap wafigima epes akagoma, nemaf afamba basef Godi fafiꞌmai anen. ");
INSERT INTO aoj_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Eaꞌ nafeꞌ anamba hiagoma walemb Jordan naꞌipasa basef Godi amam ne matawa. Naꞌipasa sombema nelelemb sowaꞌ alafugaha waf awafi sofaꞌ baptais embela God nokwahomasa waf awafi asasifi okom mogasoꞌanaf. ");
INSERT INTO aoj_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Anen nawalapa basef ifimba Godi siꞌi profet Aisaia fowaꞌ nawalapef nandaꞌef fagail buk Baibeli fagaꞌi, “Anep itap wafigima fataupigima, malogol anona amani anaf noga niꞌi, ‘Pendondomba ufiaꞌw Dembinaii, pendaꞌ ufiawa ofeꞌ usiꞌiwa. ");
INSERT INTO aoj_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Pesa anamba kwambiwah afogoma ma siꞌigin dondoꞌ atin, petopaꞌ halafutagw laumi bandami hiami ma mowala dondoꞌam. Dilindilaꞌma pendaꞌagon usiꞌigin. Eaꞌ ufiawa awamba wandaꞌ lotasilaꞌi sondaꞌawa andeandeꞌ. ");
INSERT INTO aoj_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Amam nematawa hiasi hiꞌilas anaf siti God nogatopalopa anis amam nematawa nofaꞌas nokwahomas waf awafi nowambelas sugutanimai.’” ");
INSERT INTO aoj_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Hiasi amam nematawa safiꞌmai Jon ama saꞌi nogapisiꞌas embel. Eaꞌ naꞌipas naꞌi, “Ipaꞌ pandaꞌ waf awafii, siꞌi batawis ul aunaii logolaipai. Ami naꞌipipa ma paꞌi pefaꞌ pefeꞌ pindihiꞌama okom wandafunai Godi anaf naꞌi nogatagama ipeꞌi? ");
INSERT INTO aoj_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Apaꞌ deiꞌ aꞌipipa aꞌi pendaꞌ waf fasifi ma pigihimbaꞌmas ipaꞌ aꞌ pambema nelelemb endilisi paila waf buꞌwafi. Ipaꞌ ina aꞌ ukup pendandaꞌ piꞌi, ‘Abraham ahamapa apeꞌinai’, naꞌamba ipaꞌ eaꞌ fasipai, owaꞌ, hapaimi. Aeꞌ aꞌipipa endilisi, God anen laꞌifinai ma nondaꞌ otamba atemba begataga epes siꞌi awasi Abrahami. ");
INSERT INTO aoj_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Tamiaꞌw akwandandombol kwaꞌoha kogatopaꞌ lawah kofagah nombalefima. Lawah mamahogaha owaꞌ hil hogola saꞌutip buꞌwapia, agahemba atiasi solagah sotopaꞌagah hefeꞌma nif.” ");
INSERT INTO aoj_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Anen naꞌias eaꞌ, esis hiasi sahaliꞌana saꞌi, “Apaꞌ atiasi mondaꞌ maina mondaꞌ waf fasifi God nagaꞌiefi?” ");
INSERT INTO aoj_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Eaꞌ Jon naꞌipas naꞌamba naꞌi, “Epen ami siaogw biagw atogwi nekwahomana anota anin siot akani, eaꞌ ami gwaꞌaisi sagaꞌomani inimba nendaꞌas newalogas wapani.” ");
INSERT INTO aoj_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Eaꞌ anom amam awami mogofaꞌ takisi mafiꞌmai Jon maꞌi nupisiꞌam embel eaꞌ mahaliꞌana maꞌi, “Dembinai, atiasi afaꞌ ondaꞌ maina ogahapila basef fasifi Godi?” ");
INSERT INTO aoj_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Anen naꞌipam naꞌi, “Ipaꞌ pefaꞌ otamba bendahama siꞌi gavman nagaꞌipipambai atemba. Ipaꞌ ina pefaꞌ anemba wapani, owaꞌi.” ");
INSERT INTO aoj_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Eaꞌ anom soldia mafiꞌi mahaliꞌana maꞌi, “Afaꞌ atiasi ondaꞌ maina ogohapila basef Godi?” Anen nagwamam naꞌipam naꞌi, “Ipaꞌ ina aꞌ pembasoꞌma epes piumbalis pendaꞌas ombel mohas pendaꞌmas kot pendelelaepasa moni asasini dowaf, owaꞌi. Nelelemb ipeꞌilimbi bendape awanelemba otamba ipeꞌimbai dondoꞌma ikwaf amom dembami mandandepafi.” ");
INSERT INTO aoj_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Eaꞌ deiꞌ nomonas esis amam nematawai mosafel banagem, eaꞌ hiasi ukup pandandaꞌma Jon saꞌi, “Jon anen Krais, maꞌuna God nandandepana nasapaꞌana nafiꞌii, aꞌa owaꞌ?” ");
INSERT INTO aoj_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Eaꞌ Jon nagwamasa basef naꞌipas naꞌi, “Aeꞌ apisiꞌipa embel atembal. Apaꞌ anona aman atiasi nigiꞌ nugafiꞌii, anen banagonai nikilaꞌ aeꞌ. Aeꞌ ina aman buꞌuwai ma egatagwaha mandelefa su ananimi, owaꞌatin. Anef nemaf anen neseꞌepa Ambal buꞌwali Godi nogape opalef ipeꞌilifi nomon eaꞌ neseꞌepa nif wapani. ");
INSERT INTO aoj_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Anen nahapila anol savol lagof ananigufi ma nigasimbaꞌ wit siꞌi rais amamba andeandeꞌ. Ama nofaꞌ wit buꞌwinai nuwis nembeꞌana ipat ananitai. Apaꞌ duꞌwaꞌwanimi awasimi nembeham nofam nif amamba luꞌwami fandom atapim magapani.” ");
INSERT INTO aoj_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Deiꞌ Jon nawalapa anif basef daif hiafi wapani ma nogasaꞌma ukup asasipi ma sondaꞌ waf buꞌwafi. Eaꞌ nawalipasa basef buꞌwafi. ");
INSERT INTO aoj_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Owaꞌ Jon nandaꞌ megahaha aman anamba Herot, gavman dembinai asasinai, ma waf awafi hiafi anen nandaꞌafi. Anen nandalombana Herodias nemataꞌw sahomana nagasoꞌakwi, eaꞌ nandaꞌ anef waf awafi hiafi wapani. ");
INSERT INTO aoj_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Deiꞌ nowatani anef wapani ma nandaꞌ Jon nandaꞌ kalabus. ");
INSERT INTO aoj_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Jon napisiꞌa amam nematawa hiasi ma eaꞌ, napisiꞌ Jisas wapani. Jisas nofaꞌ baptaisa eaꞌ, anen ataꞌ nandabeten atin owaꞌ, heven aꞌ nandawisiꞌ. ");
INSERT INTO aoj_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Eaꞌ Ambal buꞌunai Godi nisilaꞌi siꞌi amil alamba apaꞌ magaꞌi maꞌunai nufiaꞌ nisilaꞌmai anen. Eaꞌ anagol malagol gaꞌi gatagai heven gaꞌi anef basef gaꞌi, “Inaꞌ Nogame aeꞌinai endilisi. Aeꞌ okom mohafel maimailina aꞌowaꞌ. Okom aeꞌami fasima inaꞌ.” ");
INSERT INTO aoj_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Afamba Jisas nagasefela maol, afagof ananigufi fataga 30-pelaiguf. Esis amam nematawa ukup pandandaꞌ dowaf paꞌi Jisas nogama Josepi. ");
INSERT INTO aoj_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Bafapana Jisasi agufuma amamba. Josep, Heli nogamana. Eaꞌ Heli, Matat nogamana. Eaꞌ Matat, Livai nogamana. Livai, Melki nogamana. Melki, Janai nogamana. Eaꞌ Janai, Josep nogamana. ");
INSERT INTO aoj_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Josep, Matatias nogamana. Matatias, Amos nogamana. Amos, Nahum nogamana. Eaꞌ Nahum, Esli nogamana. Eaꞌ Esli, Nagai nogamana. ");
INSERT INTO aoj_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai, Mat nogamana. Mat, Matatias nogamana. Eaꞌ Matatias, Semen nogamana. Eaꞌ Semen, Josek nogamana. Josek, Joda nogamana. ");
INSERT INTO aoj_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Joda, Joanan nogamana. Joanan, Resa nogamana. Resa, Serubabel nogamana. Serubabel, Sealtiel nogamana. Sealtiel, Neri nogamana. ");
INSERT INTO aoj_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri, Melki nogamana. Melki, Adi nogamana. Adi, Kosam nogamana. Kosam, Elmadam nogamana. Elmadam, Er nogamana. ");
INSERT INTO aoj_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er, Josua nogamana. Eaꞌ Josua, Eleasar nogamana. Eaꞌ Eleasar, Jorim nogamana. Jorim, Matat nogamana. Eaꞌ Matat, Livai nogamana ");
INSERT INTO aoj_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Livai, Simeon nogamana. Eaꞌ Simeon, Juda nogamana. Juda, Josep nogamana. Eaꞌ Josep, Jonam nogamana. Jonam, Eliakim nogamana. ");
INSERT INTO aoj_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliakim, Melea nogamana. Melea, Mena nogamana. Mena, Matata nogamana. Matata, Natan nogamana. Natan, Devit nogamana. ");
INSERT INTO aoj_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Devit, Jesi nogamana. Jesi, Obet nogamana. Obet, Boas nogamana. Boas, Salmon nogamana. Salmon, Nason nogamana. ");
INSERT INTO aoj_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nason, Aminadap nogamana. Aminadap, anen Atmin nogamana. Atmin, Arni nogamana. Arni anen Hesron nogamana. Hesron, Peres nogamana. Peres, Juda nogamana. ");
INSERT INTO aoj_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Eaꞌ Juda anen Jekop nogamana. Jekop anen Aisak nogamana. Aisak, Abraham nogamana. Abraham, Tera nogamana. Tera, Nahor nogamana. ");
INSERT INTO aoj_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nahor, Seruk nogamana. Seruk, Reu nogamana. Reu, Pelek nogamana. Pelek, Eber nogamana. Eber anen Sela nogamana. ");
INSERT INTO aoj_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sela anen Kainan nogamana. Kainan, Arpaksat nogamana. Arpaksat, Siem nogamana. Siem, Noa nogamana. Noa, Lamek nogamana. ");
INSERT INTO aoj_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamek, Metusela nogamana. Eaꞌ Metusela, Enok nogamana. Enok, Jaret nogamana. Jaret, Mahalalel nogamana. Mahalalel, Kainan nogamana. ");
INSERT INTO aoj_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kainan, Enos nogamana. Enos, Set nogamana. Set, Adam nogamana. Adam, God nogamana. Bafapana Jisasi eaꞌ maꞌum. ");
INSERT INTO aoj_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Ambal buꞌunai Godi nape siꞌinama Jisas eaꞌ nakwaha walemb ambamba Jordan nandagiai notanima nafeꞌ. Eaꞌ Ambal anamba nofaꞌana nafeꞌ anagon wafigima fataupigima. ");
INSERT INTO aoj_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Jisas nape anamba nimaguf hiafi eaꞌ Satan nafiꞌi nagwambana ma nogosambala muꞌuli Godi nimaguf ifimba awin siꞌini duꞌwanini. Jisas ina naꞌ anis gwaꞌaisi nimaguf ifimba hiafi, owaꞌ. Eaꞌ aꞌ nolomahana. ");
INSERT INTO aoj_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Eaꞌ Satan naꞌipana naꞌi, “Inaꞌ naꞌi inaꞌ Nogamana Godi, deiꞌ kipa otam amamba bagaꞌoh itapi motaga siꞌi bret.” ");
INSERT INTO aoj_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Eaꞌ Jisas nagwamana basef naꞌipana naꞌi, “Baibel naꞌi bret atota ina atosoꞌasa ambagof esis epes, owaꞌatin.” ");
INSERT INTO aoj_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Eaꞌ Satan nofaꞌana nondowasaꞌ ilif nihimbaꞌmana hiahaom hiami fasimi magape itap hiagoma amom king dembami magalaꞌambemagoma. Nihimbaꞌmanagon kwafalis atis. ");
INSERT INTO aoj_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Eaꞌ naꞌipana naꞌi, “Hiahaom hiami banagami amamba amom king mugumafiami maloma hiahaom fasimi uga maina, hiahaom amamba God nagaseꞌeami. Apaꞌ deiꞌ iꞌi egasoꞌanam anin epena, aeꞌ eseꞌanam. ");
INSERT INTO aoj_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Iꞌi inaꞌ nindiwa nembawa netawa nendaꞌ lotu sonehenama aeꞌ, hiahaom amamba atiasi aꞌ ineꞌimi atom.” ");
INSERT INTO aoj_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Eaꞌ Jisas nagwamana basef naꞌipana naꞌi, “Baibel nagaꞌias naꞌamba naꞌi, ‘Ipaꞌ pendaꞌ lotuma Dembinai God atona ipeꞌinai, eaꞌ pendaꞌ maola anen atona.’” ");
INSERT INTO aoj_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Aꞌi owaꞌ main, Satan nofaꞌ Jisas nondowasaꞌ Jerusalem nahaponana nalutu ipat Godi luꞌunai ilif. Eaꞌ Satan naꞌipana naꞌi, “Inaꞌ naꞌi inaꞌ Nogamana Godi, deiꞌ netoma nindipaꞌ newa itap. ");
INSERT INTO aoj_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","11","Deiꞌ main, anif basef Godi fagail buk Baibeli fagaꞌi naꞌamba faꞌi, ‘God atiasi niꞌipa amom ensel mufiꞌi muhapilina lagof amamugufi mumafina ma otamba ina beha boꞌwagah ineꞌigahi, owaꞌ.’” ");
INSERT INTO aoj_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Eaꞌ Jisas nagwamana basef naꞌi, “Anif basef Godi wapani fagape naꞌamba faꞌi, ‘Ina pegwamba Dembinai God ipeꞌinai nondaꞌ waf awafi, owaꞌi.’” ");
INSERT INTO aoj_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Satan nandaꞌ gwamba hiani ma eaꞌ, nakwaha Jisas nafeꞌ nohafana ma anef nemaf nogagwambana wapani. ");
INSERT INTO aoj_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Banagami Ambal buꞌunai Godi mape opaf Jisasi aꞌ notanima nafeꞌ itap luꞌupa Galili. Eaꞌ sameꞌ basef gatifa anen fafeꞌagon hiꞌalagon walemb ambalemba bagape Galilii. ");
INSERT INTO aoj_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Dondol anen nandaꞌ maol nawalipasa basef Godi ifagw esis Juda sandakolasugwi. Eaꞌ hiasi amam nematawa sasaꞌma agol ananigili luꞌwagol. ");
INSERT INTO aoj_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Jisas nafeꞌ Nasaret taun inimba kofagama, fowaꞌ anen ataꞌ aonama nagapoma. Aꞌi owaꞌ nemaf afamba sabat esis Juda sagapoma nomaꞌwafi, nafeꞌ nawis ipat Juda sandakolasatai siꞌi dondol nandaꞌas. Anen nalutu natalifa basef Godi, ");
INSERT INTO aoj_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","eaꞌ sasoꞌana anin pepa launi. Pepa inimba anif basef Godi fowaꞌ profet Aisaia nandaꞌef fagailani. Anen nopalian niatifan nati basef ifimba natalifif fagaꞌi naꞌamba faꞌi, ");
INSERT INTO aoj_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Ambal buꞌunai Dembinaii nape aeꞌ. Eaꞌ nandandepe ma egawalapa basef buꞌwafima epes isimba kwahusa hiahawesi. Nasapaꞌe afiꞌi ma igawalapa basef naꞌamba igaꞌi, ‘Ipaꞌ pandaꞌ kalabusi pekwaha kalabus pefeꞌ wahifipa. Ipaꞌ epes naep pagasiꞌipai, ipaꞌ piti andeandeꞌ wapani.’ Anen nasapaꞌe afiꞌi egatopalopa isimba sogofaꞌ nimanimii sogape andeandeꞌ. ");
INSERT INTO aoj_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Eaꞌ iꞌipas basef hiasi ma nogota atamba buꞌutai ma Dembinai niti uwahipis notopalopas sogape andeandeꞌ.” ");
INSERT INTO aoj_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Eaꞌ Jisas nalaꞌwatefa pepa inimba launi nasoꞌanan anona aman nugumafi ipati anen nape. Eaꞌ amam nematawa hiasi sagape nomoni naep doꞌ anen atona. ");
INSERT INTO aoj_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Eaꞌ naꞌipas naꞌi, “Ipaꞌ aꞌ pameꞌ, aeꞌ atalifa basef Godi fowaꞌifi atin owaꞌ, deiꞌ aꞌ fataga alihif endilisi fandawalapa aeꞌ.” ");
INSERT INTO aoj_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Eaꞌ esis sasaꞌma agol ananigili luꞌwagol saꞌi anen aman buꞌunai eaꞌ gogolalasisa basef buꞌwafi fagataga malogol ananigili. Eaꞌ esis sandahaliꞌma saꞌi, “Aman anamba Josep nogamana aꞌa?” ");
INSERT INTO aoj_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Jisas naꞌipas naꞌamba naꞌi, “Endilisi atis ipaꞌ atiasi pendaꞌ basef ifimba waminif atina aeꞌ piꞌi, ‘Dokta, inaꞌ nendaꞌ alop ineꞌipi potaga boꞌop puliꞌ, eaꞌ piꞌi wapani piꞌi waf afamba naliꞌ nandaꞌaf Kaperneami, afamba apaꞌ mameꞌaf eaꞌ. Inaꞌ deiꞌ nendaꞌaf fetaga naꞌa wambel kofagama ineꞌima.’” ");
INSERT INTO aoj_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Eaꞌ anen naꞌias naꞌamba wapani naꞌi, “Aeꞌ aꞌipipa endilisi! Anona profet epes ina sasoꞌana opalef sameꞌ basef ananifi wambel kofagama, owaꞌ. ");
INSERT INTO aoj_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Aeꞌ aꞌipipa endilisi atis. Nogota atamba fowaꞌ Elaija nagapautai owaf atona nagandogwa, asaf ina ataꞌ falai afagof wanogof aomb wanemb wanemb, owaꞌatin. Eaꞌ nolom luꞌunai nataga ganimba hiagoma. Nogota atamba nematawa hiawai Israeliwai amom magaꞌ mialifawa wape. ");
INSERT INTO aoj_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Apaꞌ God ina nasapaꞌ Elaija nafeꞌma anowa awambai, owaꞌatin. Anen nasapaꞌana nafeꞌma anoꞌw nemataꞌw daiaꞌw kwagape Serafati, wambel bagape anep itap luꞌupa Saidoni. Eaꞌ akwamba atoꞌw. ");
INSERT INTO aoj_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Eaꞌ nogota atamba anona aowas aunai nataga nandaꞌ alop esis amam nematawa Israeli pagamboꞌwi. Apaꞌ ina anin epen asasini nataga boꞌwen, owaꞌatin. Anona aman daiana Naman Siriainai eaꞌ anen atona nataga boꞌona.” ");
INSERT INTO aoj_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Eaꞌ esis hiasi sape ipat atamba sameꞌ basef ifimba, aꞌ nomonas wandafum kwapeteꞌa Jisas. ");
INSERT INTO aoj_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Eaꞌ sosafel saliꞌamonana nawisi taun andoꞌ. Taun inimba asasini natoma halafuta ilif. Eaꞌ sofaꞌana safeꞌ halafuta atamba saꞌi sogwaloꞌana niliana tata. ");
INSERT INTO aoj_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Owaꞌ, anen nandaliꞌamona esis laꞌafisa aꞌ nafeꞌ. ");
INSERT INTO aoj_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Jisas niliana Kaperneam taun inimba nagape itap luꞌupa Galilii. Aꞌi owaꞌ nemaf afamba Juda sagapoma nomaꞌwafi saꞌi sabat, anen nawis nomon ipat sandakolasatai nawalipas. ");
INSERT INTO aoj_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Sameꞌana saꞌi anen nofaꞌ agol luꞌwagili deiꞌ naꞌipasa basef banagafi. Eaꞌ sosafel gogolalasis kwapeteꞌ endilisi. ");
INSERT INTO aoj_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Anona aman ambafuh mandaꞌanai nape ipat atamba, ambal aunai napaona. Anen galala mehip endilisi naꞌias naꞌi, ");
INSERT INTO aoj_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“E! Jisas inaꞌ Nasaretinai, naꞌi nifiꞌi nendaꞌ maina apaꞌ? Inaꞌ nafiꞌi ma negahambombagapa? Aeꞌ egawa inaꞌ nogama God buꞌwinai hililiꞌi.” ");
INSERT INTO aoj_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Owaꞌ Jisas ninifalona naꞌamba naꞌi, “Inaꞌ ambalip awinai sopama malogol kwaha aman anamba.” Eaꞌ ambalip anamba nakwahona nowa itap laꞌafena esis nawisi nafeꞌ, ina ataꞌ nahambombagana wapani, aꞌ owaꞌatin. ");
INSERT INTO aoj_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Esis hiasi gogolalasis sandakotoꞌma sandaꞌipama saꞌi, “Ifimba basef mamahifa? Anen natofa ambagof awami naꞌipam siꞌi anona aman banagonai. Ambagof awami mameꞌ basefa anen, makwahona mafaꞌ mafeꞌ.” ");
INSERT INTO aoj_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Eaꞌ basef ifimba nandaꞌ hiahaom amamba banagami fafeꞌagon hiꞌalagon walemb bagape naꞌambai. ");
INSERT INTO aoj_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Saimon nandagiꞌmoꞌwi aowas nandaꞌakw alop akoꞌupi nifip kwapeteꞌ. Eaꞌ Jisas nosafel nakwaha ipat atamba sandaꞌ kolasatai, nafeꞌ nawis ipat Saimoni. Eaꞌ sahaliꞌana ma nogatopalopaꞌw. ");
INSERT INTO aoj_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Eaꞌ anen nafeꞌ nalutu felefeleꞌ ma akoꞌw nataloga aowas inimba natofan nafaꞌ nakwaha akoꞌw. Eaꞌ kosafel kwafalis kwandaꞌmasa gwaꞌaisi esis. ");
INSERT INTO aoj_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Aꞌi owaꞌ awin newala nasoꞌ, esis amam nematawa sofaꞌ anis alipisi aowas hiana haona nandaꞌasi sofaꞌas safiꞌmai Jisas. Eaꞌ nasa lagofas atona atin nandaꞌas boꞌwes hiꞌalas. ");
INSERT INTO aoj_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Eaꞌ ambagof awami hiami makwaha esis hiasi mawisi mafeꞌ eaꞌ. Ambagof amamba awami mofalana higihigaꞌ maꞌoh maꞌi, “Inaꞌ nogamana Godi.” Amom mogawa anen Krais, God nandandepana nasapaꞌana nagafiꞌii. Eaꞌ Jisas ninifalom naꞌi ina ataꞌ miꞌi anif basef, owaꞌ. Mosopama malogof. ");
INSERT INTO aoj_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Aꞌi owaꞌ kuhimbita atota Jisas nakwaha wambel ambalemba nafeꞌ anagon wafigima epes akagoma. Esis safeꞌ solaomana satolona asafeꞌma anen. Esis ina saꞌi anen nokwaha esis nofeꞌ owaꞌ, saꞌi sotalifana nope atapina nolomas. ");
INSERT INTO aoj_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Owaꞌ, naꞌipas naꞌi, “Aeꞌ aꞌi ewalapa basef fasifi ma epes sogawisa maol Godi nope Dembinai nugumafias. Aꞌi ewalapa basef ifimba anagon taun hiani wapani. God nasapaꞌe afiꞌi endaꞌani maol inimba atin.” ");
INSERT INTO aoj_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Eaꞌ nafeꞌ nawalapa basef Godi ifagw esis Juda sandakolasugwi nawalapef nafeꞌ nafeꞌ atapina itap luꞌupa Judia. ");
INSERT INTO aoj_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Anef nemaf Jisas nalutu dumb Genesaret akata naloma hiasi amam nematawa salaꞌambemana sape sameꞌ basef Godi. ");
INSERT INTO aoj_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Eaꞌ nati anota bot saꞌutai biata tala embel felefeleꞌma nimbapif dumb ambamba. Eaꞌ amom mogowafa agufi mandaniꞌ mafeꞌ masaꞌopa anembeh amamimbihi. ");
INSERT INTO aoj_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Jisas nalota natoma bot Saimoni eaꞌ naꞌipana naꞌi, “Sapaꞌ bot nokwaha bandagoma nefeꞌ laogoma kwasala.” Eaꞌ Jisas natoma bot nawalipasa basef esis amam nematawa. ");
INSERT INTO aoj_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Anen nawalipasa eaꞌ naꞌipa Saimon naꞌi, “Inaꞌ sapaꞌ bot tofoꞌo dumb embel laogoma eaꞌ pela anembeh howala pewafai anogof agof.” ");
INSERT INTO aoj_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Eaꞌ Saimon nagwa basef naꞌi, “Dembinai, dokoꞌ owamb laomb afaꞌ wandaꞌ maol banagambel owaꞌ, ina wagi anol aol, owaꞌatin. Owaꞌ naꞌipa aeꞌ naꞌamba, deiꞌ ela anemb bewala.” ");
INSERT INTO aoj_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Aꞌi owaꞌ, mala anemb bewala mowafai agof hiami. Eaꞌ anemb baꞌi peleꞌetamba agof hiami aꞌowaꞌ. ");
INSERT INTO aoj_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Eaꞌ amom mowaulai alipumi amamumi magape anota boti mafiꞌi matopalopam mowafai agof malam bot biafita siꞌita, taꞌi aꞌ towala. ");
INSERT INTO aoj_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Saimon Pita nati naꞌamba, eaꞌ nindiwa nembawa natawa felefeleꞌma boꞌwagah Jisasi naꞌipana naꞌi, “O Dembinai, inaꞌ kwaha aeꞌ, afoꞌo. Aeꞌ aman auwai!” ");
INSERT INTO aoj_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Deiꞌ main, anen naloma amom magalumanai mati agof mogowafami hiami aꞌowaꞌ. Eaꞌ amom gogolalasom nomonas salasafeꞌ. ");
INSERT INTO aoj_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Nogaopana Sebedii biam Jems naloma Jon maloma Pita mandauꞌumai wapani gogolalasoma agof amamba. Eaꞌ Jisas naꞌipa Saimon naꞌi, “Inaꞌ ombal mogahena, owaꞌi. Deiꞌ atef nesafela anin maol daian nendaꞌan atapinaman nefaꞌi epes sifiꞌi sigaili.” ");
INSERT INTO aoj_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Eaꞌ amom mandaꞌ botagw gwafeꞌ bandagoma, aꞌ makwaha hiahaom amamumi hiꞌalam maꞌoh, eaꞌ mailana mafeꞌ. ");
INSERT INTO aoj_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Nogota atamba Jisas nape anin taun, anona aman nagape naꞌambai aowas aunai nandaꞌ alop ananipi hiꞌalap pagambuꞌwi. Anen nati Jisas nafiꞌi, nowafa nambeꞌ nembel itap kwafalis atis naꞌipana dindinip naꞌi, “Dembinai, iꞌi inaꞌ niꞌi ahoꞌ, nendaꞌe etaga boꞌowe.” ");
INSERT INTO aoj_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Eaꞌ Jisas nando lagol nasagol alop aman anambai naꞌipana naꞌi, “Aeꞌ aꞌi ahoꞌ ma inaꞌ negataga boꞌwena.” Eaꞌ deiꞌ atef aowas inimba aunai nandaꞌ alop pagambuꞌwi nakwahona eaꞌ boꞌona. ");
INSERT INTO aoj_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Jisas naꞌipana dindinip naꞌi, “Ina aꞌ nefeꞌ niꞌipa anin epen niꞌi aeꞌ andaꞌena boꞌwena, owaꞌi. Inaꞌ foꞌo nihimbaꞌmana alop ineꞌipi ma aman anamba pris. Eaꞌ neseꞌana hiahaom amamba anen nondolalima God eaꞌ inaꞌ ninifelona ma nagataga boꞌwena siꞌi muꞌuli ananini fowaꞌ Moses nagaꞌipasani nagaꞌi. Ama esis hiasi sogogawa aowas ineꞌini ahiꞌalan.” ");
INSERT INTO aoj_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Owaꞌ, owaꞌatin. Diga basefa hiahawes isimba Jisas nandaꞌmanas aman anambai gatis safeꞌ ganigani. Fowaꞌ ina hiasi sameꞌ basef ifimba, owaꞌ, apaꞌ deiꞌ hias aꞌowaꞌ. Isimba atis deiꞌ epes hiasi safiꞌi ma sogameꞌ anona nogatofamasa aowas asasini. ");
INSERT INTO aoj_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Apaꞌ nimaguf hiafi anen nafeꞌ anamba wafigima epes akagoma ma nape nandabeten. ");
INSERT INTO aoj_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Anef nemaf Jisas nape nawalipa esis amam nematawa eaꞌ anom dembami Farisi maloma anom dembami magawalipasa muꞌuli Godi tol mape. Anom mafiꞌi walemb hielimbi itap luꞌupa biafip Judiai Galili. Apaꞌ anom mafiꞌi Jerusalem. Eaꞌ banagami Dembinai Godi mape Jisas, ama nandaꞌ epes aowas nandaꞌasi sogohafel boꞌwes wapani. ");
INSERT INTO aoj_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Eaꞌ anom amam daiam mofaꞌ anona aman lagof boꞌwagah sagagaꞌanai, naꞌoh alihis mofaꞌana mafiꞌi. Eaꞌ maꞌi mofaꞌana mefeꞌ muwis ipat membeꞌana felefeleꞌma Jisas. ");
INSERT INTO aoj_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Owaꞌ asiꞌigina amam nematawa hiasi. Amom ina mati anoꞌw ufiaꞌwa mofaꞌ awasini mugawis nomon, owaꞌ. Eaꞌ malota ipat ilif mihianama bogwan mala aman anamba awasinai naloma alihis nowala nomon laꞌafena amam nematawa, mambeꞌana naꞌoh Jisas opafunama. ");
INSERT INTO aoj_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Nogota atamba Jisas natolom nogawa amom mahapifa maꞌi anen banagonai ma nogatopalopa aman anamba aowas nandaꞌanai. Eaꞌ naꞌipa aman anamba naꞌi, “Inaꞌ epen aeꞌinai. Waf awafi inaꞌ nandaꞌafi aeꞌ akwahomenaf hiꞌalaf okom maseꞌeaf.” ");
INSERT INTO aoj_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Eaꞌ amom dembami magawalipasa muꞌuli Godi maloma amom Farisi atom ukup atip pandandaꞌ paꞌi, “Aman anamba mamahonama nandaꞌ God findiwanai? Owaꞌatina anona aman laꞌifinama nogakwaha waf awafia. Maol inimba God atona nandaꞌani.” ");
INSERT INTO aoj_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Jisas nogawa nomonas isimbai amamisi. Eaꞌ naꞌipam naꞌi, “Deiꞌ maina nomonas ipeꞌisi sagape naꞌamba? ");
INSERT INTO aoj_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Deiꞌ hiahaom maim ipaꞌ paꞌi ahifima aeꞌ? Aeꞌ banagiwai ma iꞌipa aowas nandaꞌanai igaꞌi, Aeꞌ egakwahomana waf awafi anen nandaꞌafi aꞌa iꞌipana igaꞌi nogasaꞌma alahis ananisi nosafel nogafeꞌ. Basef ifimba ma nogasaꞌma alahis ananisi, ipaꞌ paꞌi amamba ahifima aeꞌ. ");
INSERT INTO aoj_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Aeꞌ aꞌi ipaꞌ pegawa aeꞌ ataga epen egefaꞌ alop epesi, laꞌifiwai ma egakwaha waf awafi hiafi amam nematawa sagape itapi sandaꞌafi. Aeꞌ aꞌi ihimbaꞌmepa aeꞌ laꞌifiwai ma endaꞌ hiahaom amamba. Eaꞌ anen naꞌipana naꞌi, “Aeꞌ aꞌipina endilisi, inaꞌ safel saꞌma alahis ineꞌisi nefeꞌ ipat ineꞌitai.” ");
INSERT INTO aoj_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Jisas naꞌipana atin naꞌamba, nosafel nalutu nasaꞌma alahis ananisi naep amam nematawa hiasii. Eaꞌ ataꞌ nafeꞌ atin ufiaꞌw, nandagala nafela agol Godi luꞌwagol nafeꞌ ipat ananitai. ");
INSERT INTO aoj_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Eaꞌ amam nematawa isimba hiasi gogolalasis kwapeteꞌ endilisi, ombal mahas aꞌowaꞌ safela agol Godi luꞌwagol saꞌi, “Deiꞌ apaꞌ mati anef waf dambaifi daiaf fowaꞌ owaꞌ mogatilifia.” ");
INSERT INTO aoj_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Aꞌi owaꞌ main, Jisas nosafel nafeꞌ nati anona aman nogofaꞌ takisi tol nape ipat sogofaꞌ takisa, agilinama Livai. Eaꞌ Jisas naꞌipana naꞌi, “Inaꞌ fiꞌi nila aeꞌ.” ");
INSERT INTO aoj_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Eaꞌ nosafel nailana nafeꞌ. Hiahaom hiami ananimi nakwahom maꞌoh. ");
INSERT INTO aoj_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Ama main, Livai nandaꞌ anis gwaꞌaisi luꞌwasi ipat ananitai ma noganifela Jisas. Eaꞌ amam hiami awami mogofaꞌ takisi maloma anom daiam wapani mape maꞌ gwaꞌaisi maloma amom biam. ");
INSERT INTO aoj_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Eaꞌ anom Farisi dembami maloma anom dembami magawalipasa muꞌuli Godi, amom Farisi, mape mandaꞌ megahaha amom alipumi Jisasi. Maꞌi, “Deiꞌ maina ipaꞌ pape paꞌ gwaꞌaisi pagaloma amom mogofaꞌ takisi maloma amam amamba mandaꞌ waf awafii? Naꞌambai ina andeandeꞌ, hapaimi.” ");
INSERT INTO aoj_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Owaꞌ Jisas nameꞌam naꞌipam naꞌi, “Isimba aowas akasi ina safeꞌma dokta, owaꞌ. Esis buꞌwasi. Apaꞌ isimba aowas nandaꞌasi atis, daoꞌ safeꞌma dokta. ");
INSERT INTO aoj_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Aeꞌ ina afiꞌi ma egefala epes sagape andeandeꞌi sogambema opalef, owaꞌ. Aeꞌ afiꞌi ma egefala epes sandaꞌ waf awafii atis sombema nelelemb sokwaha waf awafi sogafeꞌma God.” ");
INSERT INTO aoj_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Eaꞌ anis epes saꞌipa Jisas naꞌamba saꞌi, “Alipumi Joni maloma alipumi amom dembami Farisii ukup papoma basef Godi. Eaꞌ anif nimaguf wikifah danda amom molalama gwaꞌaisi mondabeten atin. Apaꞌ alipumi ineꞌimi owaꞌ mondaꞌ waf afambaia. Amom maꞌ gwaꞌaisi embel mais atapis dondol.” ");
INSERT INTO aoj_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Eaꞌ nagwamas naꞌi basef waminif atin naꞌi, “Iꞌi anis sondaꞌ anis gwaꞌaisi luꞌwasi ma anis aman nemataꞌw bias sondasoꞌamai, ipaꞌ ina laꞌifipama pendaꞌ esis alipisi sondowaloꞌ sondaiwaꞌma gwaꞌaisi afamba anen nagasoꞌ nemataꞌwi nape nagalomas, owaꞌatin endilisi. ");
INSERT INTO aoj_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Apaꞌ nemaf afamba anen nagasoꞌ nemataꞌwi nokwaha esis nogafeꞌ anagon lauguni, daoꞌ esis a sololama gwaꞌaisi.” ");
INSERT INTO aoj_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Eaꞌ Jisas naꞌipasa anif basef waminif atina luwaguf naꞌi, “Ina andeandeꞌma pegatopaꞌ lowaf namifi pesambalef fegaloma anef lowaf apifi, owaꞌ. Iꞌi anis sondaꞌam naꞌamba, lowaf ina atiasi findati naꞌamba atin feloma apifi, owaꞌ. Namifi aꞌ peleꞌetaf atin. ");
INSERT INTO aoj_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Apaꞌ ina anin epen nakoloꞌwa embel wain dambaini agwahup apinai memeina, owaꞌ. Iꞌi anin nendaꞌam naꞌamba, embel wain netef hian, nohapeꞌ agwahup anamba pepeꞌetana eaꞌ wain koloꞌolam awasim hiꞌilam. ");
INSERT INTO aoj_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Apaꞌ wain dambainai sakoloꞌwan agwahup dambainai atona. ");
INSERT INTO aoj_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Eaꞌ ami nogaꞌ embel wain apini anin ina atiasi nomonas siꞌi wain dambaini, owaꞌ. Anin aꞌ naꞌi, ‘Wain apini fasini nikilaꞌ dambaini.’” ");
INSERT INTO aoj_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Aꞌi owaꞌ anef nemaf Juda sagapoma nomaꞌwafi sabat, Jisas nafeꞌ anagon owaꞌ nataga anof aof sagawa witafi aꞌ nawis. Eaꞌ alipumi ananimi mafeꞌ malomana, eaꞌ mosaga anom wit magaofi mokaꞌisam lagof amamugufi maꞌam. ");
INSERT INTO aoj_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Owaꞌ anom Farisi mahaliꞌam maꞌi, “Ina pendaꞌam naꞌamba ma nemaf afaꞌe sabat magapoma nomaꞌwafi, owaꞌi. Deiꞌ maina pandaꞌam naꞌamba?” ");
INSERT INTO aoj_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Eaꞌ Jisas nagwamam naꞌipam naꞌi, “Ipaꞌ pegawa basef ifimba ma waf fowaꞌ dembinai King Devit nandaꞌafi. Afamba Devit naloma alipumi ananimi nolomagaham ");
INSERT INTO aoj_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","anen nawis ipat luꞌunai Godi nomon naꞌ bret atamba amom pris mondolali mogasoꞌ Godatai. Eaꞌ naꞌata nasoꞌ alipumi ananimi maꞌata atin. Apaꞌ muꞌuli apeꞌini naꞌi amom pris atom meaꞌata.” ");
INSERT INTO aoj_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Eaꞌ Jisas naꞌipam wapani naꞌi, “Aeꞌ ataga epen egefaꞌ alop epesi, ape Dembiwai ma nemaf afamba sabata igaꞌipipa maol main andeandeꞌma pigaila basef pendaꞌan nemaf afamba.” ");
INSERT INTO aoj_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Anef nemaf sagapoma nomaꞌwafi sabat aꞌ fataga. Jisas nafeꞌ nawis nomon ipat Juda sandakolasatai nape naꞌipasa basef esis amam nematawa. Eaꞌ anona aman nape nalomas, lagol kwahisigili ananigili awagol gagaꞌ gail. ");
INSERT INTO aoj_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Amom dembami magawalipasa muꞌuli Godi maloma anom dembami Farisi maꞌi mowandoꞌma ufiaꞌwa mogasapaga Jisasa anif basef basoꞌafi ma mondaꞌ kotimana. Eaꞌ mandaꞌana naep diꞌindiꞌana. Maꞌi mogati anen nosambala muꞌuli ma nemaf afamba sabat nondaꞌ aman anamba boꞌona aꞌa owaꞌ? ");
INSERT INTO aoj_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Owaꞌ anen aꞌ nogawa nomonas amamisi, naꞌipa aman anamba lagol awagilinai naꞌi, “Inaꞌ safel nilutu naep hiasii laꞌafena esis sogatilina.” Eaꞌ anen nosafel nalutu. ");
INSERT INTO aoj_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Eaꞌ Jisas naꞌipam naꞌi, “Aeꞌ aꞌi ihaliꞌipa ma muꞌuli apeꞌini naꞌias naꞌimama? Nemaf afaꞌe apaꞌ maꞌi mondaꞌ waf buꞌwafi aꞌa mondaꞌ waf awafi? Naꞌi apaꞌ motopalopasa sogape andeandeꞌ aꞌa mohambombagas sogagaꞌ?” ");
INSERT INTO aoj_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Eaꞌ natologon tulif amam nematawa hiasi, naꞌipa aman anamba naꞌi, “Dowa lagol ineꞌigili usiꞌigil.” Eaꞌ anen nando lagol ananigili agataga boꞌwagol wapani. ");
INSERT INTO aoj_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Owaꞌ amom Farisi nelelemb wandafum kwapeteꞌ endilisi ma anen. Eaꞌ mandaꞌipama maꞌi, “Afaꞌ atiasi ondaꞌ maina Jisas?” ");
INSERT INTO aoj_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Nemaf afamba Jisas nandowasaꞌ nafeꞌ halafutagwa nandabetena God. Eaꞌ owamb amamba laomb anen nape nandabeten nafeꞌ aꞌ lala. ");
INSERT INTO aoj_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Awin aꞌi owaꞌ natafi, anen nofala alipumi ananimi hiami mafiꞌi nandandepa 12-pelaim nahapomama agol aposel amom atom. ");
INSERT INTO aoj_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Anona Saimon, eaꞌ Jisas nandaꞌmana agol waꞌagol Pita. A Andru, owamana Saimoni. Eaꞌ Jemsi Jon. A Filipi Bartolomyu, ");
INSERT INTO aoj_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matyu naloma Tomas eaꞌ Jems nogama Alfiusi. Eaꞌ Saimon anen pati inimba Seloti. ");
INSERT INTO aoj_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Eaꞌ Judas nogamana Jemsi, a Judas Keriotinai, aman anamba nogawalapa Jisasa boumi ananimii. ");
INSERT INTO aoj_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Eaꞌ Jisas niliana naloma alipumi ananimi mafeꞌ anagon bembeꞌagoma, dokoꞌ esis alipisi hiasi ananisi safiꞌi saliꞌ sagalutuma. Eaꞌ epes hiasi safiꞌi. Anis safiꞌi walemb hiagoma anep itap luꞌupa Judia a anis safiꞌi walemb bialemb Tairi Saidon bape bagaloꞌma naohi, anis safiꞌi Jerusalem. ");
INSERT INTO aoj_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Esis safiꞌi ma sogameꞌ basef ananifi ma nogatofa aowas asasinai. Eaꞌ esis amam nematawa ambagof awami magahambombagasi safiꞌi, Jisas nandaꞌas boꞌwes wapani. ");
INSERT INTO aoj_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Banagami ananimi mafeꞌ mandaꞌ esis hiasi boꞌwes. Eaꞌ deiꞌ esis hiasi saꞌi sohahapila anen. ");
INSERT INTO aoj_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Jisas natiti amom alipumi ananimi naꞌipam naꞌi, “Ipaꞌ kwahupai otamba mais akipai, ipaꞌ pawis eaꞌ nomona maol Godi nope Dembinai nugumafipa. Isimba atis deiꞌ ipaꞌ sonahepa pandagala pape. ");
INSERT INTO aoj_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Ipaꞌ epes nolomagahipai, deiꞌ sonahepa pape andeandeꞌ. Deiꞌ main, anaf ipaꞌ peaꞌ gwaꞌaisi aꞌ alihipa. Ipaꞌ epes nelelemb nimanilimba pagalifi, deiꞌ sonahepa pape andeandeꞌ. Deiꞌ main, anaf ipaꞌ sonehepa pindaꞌiaf. ");
INSERT INTO aoj_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Aeꞌ ataga epen egefaꞌ alop epesi. Nambimb anis daias siti ipaꞌ pila aeꞌ, esis nelelemb awalemba ipaꞌ endilisi. Eaꞌ sowaꞌ alafugaha ipaꞌ sohaponamepa agof awagufi siꞌiguf waꞌagof endilisi siꞌi ipaꞌ epes aupai sindaiwaꞌmepa siliꞌamonepa. ");
INSERT INTO aoj_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Nemaf afamba esis sondaꞌepa naꞌamba, ipaꞌ a sonondahepa pilutu pialemb atin. Deiꞌ main, hiahaom hiami fasimi ipeꞌimi maꞌoh heven. Fowaꞌ akupas bafapas asasisi sandaꞌ amom profet aom naꞌamba atin. ");
INSERT INTO aoj_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Apaꞌ ipaꞌ otamba uga maim hiamipai, ipaꞌ solawaipa ma hiahaom awami akafimi mogatagamepai. Deiꞌ main, ipaꞌ deiꞌ pefaꞌam eaꞌ hiahaom mondaꞌepa dagalaipamami. ");
INSERT INTO aoj_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Ipaꞌ deiꞌ pagaꞌ gwaꞌaisi alihipai, solawaipa ma hiahaom awami akafimi. Deiꞌ main, anaf ipaꞌ aꞌ nolomehepa. Ipaꞌ deiꞌ pandaꞌiafi, ipaꞌ solawaipa ma hiahaom awami akafimi. Deiꞌ main, anaf ipaꞌ pelefa pendaꞌaga aꞌowaꞌ. ");
INSERT INTO aoj_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Ipaꞌ deiꞌ epes hiasi hiꞌalas sagafela agof ipeꞌigufi sagaꞌi ipaꞌ buꞌupai, ipaꞌ solawaipa ma hiahaom akafimi awami. Deiꞌ main, fowaꞌ akusas bafasas asasisi sagaꞌipam naꞌamba atina amom profet mambasoꞌam magaꞌipasa basef Godii. Sandaꞌmamam naꞌamba atin, safela agof amamugufi. ");
INSERT INTO aoj_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Apaꞌ ipaꞌ pagameꞌ basef aeꞌafii, ipaꞌ ukup peleleꞌ pindaila bousi ipeꞌisi, pendaꞌmasa waf buꞌwafi isimba nelelemb awalemba ipeꞌi. ");
INSERT INTO aoj_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Ipaꞌ pihaliꞌ Goda nondaꞌmas waf buꞌwafi ma epes isimba sandaꞌmepa koꞌopi. Eaꞌ pendabetena epes isimba sandaꞌepa aupai. ");
INSERT INTO aoj_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Iꞌi epen mamahina negahepa aomb waꞌoli, pendambema nehepa waꞌol wapani. Iꞌi epen mamahina nefaꞌmepa saket ipeꞌitai, ina pindaꞌimata, owaꞌi. Peseꞌanota wapani. ");
INSERT INTO aoj_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Iꞌi epen mamahina nefalepama anis maefah, ipaꞌ peseꞌanas. Eaꞌ iꞌi epen mamahina negefaꞌ hiahaom ipeꞌimi, ipaꞌ owaꞌi piꞌipana dindinipa negwamepama, owaꞌi. ");
INSERT INTO aoj_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Waf maif ipaꞌ paꞌi esis sondaꞌmepaf ipeꞌi, ipaꞌ pendaꞌmasaf naꞌamba atin. ");
INSERT INTO aoj_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Iꞌi ipaꞌ ukup pipila epes isimba ukup pagapagaila ipeꞌi, atiasi pefaꞌ hiahawes fasisi maisa waf afamba? Owaꞌatin. Epes sandaꞌ waf awafii esis sandaꞌaf naꞌamba atin. Ukup paipaila epes isimba ukup pagapagailasi. ");
INSERT INTO aoj_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Iꞌi ipaꞌ pendaꞌ waf fasifi ma isimba sandaꞌ waf fasifi atifa ipeꞌi, atiasi ami nesaꞌma agof ipeꞌigufi? Owaꞌatin. Epes isimba sandaꞌ waf awafii esis wapani sandaꞌ waf naꞌambaifi. ");
INSERT INTO aoj_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Iꞌi ipaꞌ peseꞌasa anis hiahawes epes isimba ipaꞌ pegawa esis atiasi sogogwamepasii, anaf ami nefela agof ipeꞌigufi? Bola owaꞌatin. Epes awasi wapani sagasoꞌasa anom maefah anis sandaꞌ waf awafii, ama esis sotanima sogofaꞌam naꞌamba atin mondagwama siꞌi saliꞌ sagasoꞌasam. ");
INSERT INTO aoj_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Apaꞌ ipaꞌ ukup pindapindaila bousi ipeꞌisi, pendaꞌmas waf fasifi esis peseꞌasa hiahawes. Ipaꞌ ina ataꞌ piꞌi anaf esis sogwamepas, owaꞌ. Ipaꞌ pendaꞌas naꞌamba anaf God nagape ilifi neseꞌepa hiahaom luꞌwami fasimi ma pegape awasi ananipai. Deiꞌ main, anen nagaꞌi uwahipigama esis isimba owaꞌ soganifelonaia saloma isimba sandaꞌ waf awafii. ");
INSERT INTO aoj_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Ahamepa ipeꞌinai nagaꞌi uwahipigama esis sandaꞌ waf awafii. Ipaꞌ pendaꞌas naꞌamba atin siꞌi anen nagati esis uwahipis. ");
INSERT INTO aoj_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Ipaꞌ ina aꞌ pewaloga anis epes siꞌi anona jas dembinai nagawaloga basef kot luꞌunai, owaꞌi. Ama anaf God ina nowalogepa, owaꞌ. Ipaꞌ ina aꞌ pesapaga anis epes dowaf, owaꞌi. Ama anaf God ina nosapaga ipaꞌ wapani, owaꞌ. Ipaꞌ pekwahowa waf awafi anis sandaꞌmepaf ipeꞌi. Ama anaf God nogwas nogakwahowa waf awafi ipeꞌifi. ");
INSERT INTO aoj_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Ipaꞌ peseꞌasa hiahawes anis epesa God nogaseꞌepa hiahawes ipaꞌ. Anaf anen nogaseꞌepa hiahawes hiasi siꞌisiꞌisa ipaꞌ endilisi siꞌim kwaef aꞌowaꞌ mikiꞌ. Ikwaf ipaꞌ pegasoꞌasaf anis epesi, anaf ikwaf afamba atef God neseꞌepaf ipaꞌ.” ");
INSERT INTO aoj_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Eaꞌ Jisas naꞌipasa anif basef waminif atina esis wapani naꞌi, “Aꞌi anin epen naep pagasoꞌani laꞌifinama nigihimbaꞌman ufiaꞌw anin daian naep pagasoꞌani? Owaꞌatin. Atiasi esis bias dogwas hendihandef sefeꞌ sondakolef sowala atin kwambiwag. ");
INSERT INTO aoj_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Epes sandaꞌ skul atini ina sape dambes sikilaꞌ tisa asasinai, owaꞌ. Esis sondaꞌ skula hiꞌalan, daoꞌ sotaga naꞌamba atin siꞌi tisa asasinai. ");
INSERT INTO aoj_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Deiꞌ maina ipaꞌ pagati usan saꞌusaꞌuni nagape naep sahin owan ipeꞌisii, apaꞌ ipaꞌ owaꞌ pegawa hapataf luꞌunai nagape naep ipeꞌipia? ");
INSERT INTO aoj_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Deiꞌ maina ipaꞌ ataꞌ paliꞌ paꞌipa alipisi pigaꞌi, ‘Owame, aeꞌ aꞌi igimina usan saꞌuni nagape naep ineꞌipii.’ Apaꞌ ipaꞌ hapataf luꞌunai anamba nape naep ipeꞌipi. Ipaꞌ malogof biagufipai pagambasoꞌami. Ipaꞌ ataꞌ piliꞌ pigi usan hapataf luꞌunai nagape naep ipeꞌipii, ma piti andeandeꞌ, daoꞌ aꞌ pigimana usas saꞌusi sagape naep alipisi ipeꞌisii.” ");
INSERT INTO aoj_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Lawag buꞌugai ina gola gwaꞌaisi awasi, owaꞌ. Eaꞌ naꞌamba atin lawag augai ina gola gwaꞌaisi buꞌwasi, owaꞌatin. ");
INSERT INTO aoj_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Apaꞌ mati gwaꞌaisi sagailagahi, mogawa lawah buꞌugahi augahi. Epes ina sola saꞌutip fikip usihip siꞌi ahipi anof mandof higatagufi, owaꞌatin. A ina sola saꞌutip wainip anof mandof pipiꞌambinif, isimba wapani owaꞌ. ");
INSERT INTO aoj_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Epes naꞌamba atin. Epen buꞌwani, anin nomonas fasisi sapain nembel ananimbili, eaꞌ nawalapa waf buꞌwafi. Apaꞌ epen awani waf hiafi awafi awasi hiasi fapain nembel ananimbili. Eaꞌ nawalapa waf awafi atefi. Deiꞌ main, waf maif buꞌwafi awafi fape siꞌifa nembel ananinai, afamba deiꞌ malogol gawalapafi. ");
INSERT INTO aoj_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Deiꞌ maina ipaꞌ pagaꞌi aeꞌ Dembiwai, Dembiwai, apaꞌ ipaꞌ owaꞌ pila malogol aeꞌagilia? ");
INSERT INTO aoj_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Ami nifiꞌmai aeꞌ ma nigaila malogol aeꞌagilii, deiꞌ aeꞌ indilaꞌwaifa waf ananifi ma ipaꞌ pegegawaf. ");
INSERT INTO aoj_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Epen inimba siꞌi anona aman nagalaꞌ ipati. Anen nandoma olalef fewala gani itap awin otamba mogotaoma. Eaꞌ nandaꞌ ipat tatoma ilifa otamba ambamba. Ama main, walemb nawisi embel koloꞌwalami mafeꞌ, ipat ina tandagwamba, owaꞌ. Deiꞌ main? Aman anamba nandaꞌata banagota. ");
INSERT INTO aoj_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Apaꞌ epen ami nameꞌ basef aeꞌafi owaꞌ nilifa, inimba siꞌi anona daiana nagalaꞌ ipat falafutai. Anen nandaꞌata nalaꞌata dowaf tatoma itap atep ilif. Aꞌi owaꞌ maina walemb nawisi embel mokwaefa ipat atamba kwafalis atis aꞌ tato totowata aota hiꞌalata. Eaꞌ maꞌuf.” ");
INSERT INTO aoj_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Jisas naꞌi basef ifimba laufi ma hiꞌalef, aꞌ nafeꞌ nataga anambel wambel Kaperneam. ");
INSERT INTO aoj_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Anona aman dembinai nape. Anen kepten nugumafi soldia hiami 100-pelaimi. Anona nandaꞌ maola anini aowasina felefeleꞌma nogagaꞌ. Eaꞌ kepten okom maimailana ");
INSERT INTO aoj_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","eaꞌ nameꞌ basefa Jisas nasapaꞌ anom agufumi Judai mafeꞌ mofala Jisasa nondaꞌ aman anamba boꞌona. ");
INSERT INTO aoj_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Eaꞌ mafeꞌ matagama Jisas maꞌipana dindinip maꞌi, “Kepten anamba aman buꞌunai, andeandeꞌma inaꞌ negatopalopana nendaꞌ aman nandaꞌ maola anini boꞌona. ");
INSERT INTO aoj_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Deiꞌ main, anen okom magamagaila apaꞌ Judai nalaꞌ ipat apaꞌ mandakolasatai.” ");
INSERT INTO aoj_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Eaꞌ Jisas nafeꞌ nalomam nafeꞌ nataga felefeleꞌma ipat owaꞌ, Kepten anamba nasapaꞌ anom alipumi mofaꞌai basef ananifi mafiꞌi maꞌipa Jisas naꞌamba maꞌi, “Dembinai, inaꞌ negafoꞌo owaꞌ, hapaimi. Aeꞌ ina aman buꞌuwai ma inaꞌ nefoꞌo negawis ipat aeꞌatai, owaꞌ. ");
INSERT INTO aoj_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","8","Isimba atis aeꞌ wapani ina boꞌowe ma egafeꞌmago inaꞌ, owaꞌatin. Inaꞌ nindaꞌi basef atif bola anen boꞌona. Deiꞌ main, aeꞌ ape lafela anom soldia dembami mumafi maseꞌe maol. Eaꞌ ape ilifa anom soldia aeꞌami imafiam. Igaꞌipa anona igaꞌi, ‘Inaꞌ foꞌo’, nameꞌe nafeꞌ. A igaꞌipa anona igaꞌi, ‘Inaꞌ fiꞌi’, nemeꞌe nafiꞌi. Eaꞌ igaꞌipa anamba agol akanai nandaꞌme maoli igaꞌi, ‘Inaꞌ daꞌa maol inimba’, anen nameꞌe nandaꞌan. Inaꞌ dembinai. Eaꞌ aowas inimba atiasi nemeꞌ basef ineꞌifi aꞌ nefeꞌ. Deiꞌ inaꞌ nindaꞌi atin, eaꞌ anen amboꞌona wapani.” ");
INSERT INTO aoj_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Jisas nameꞌ basef ananifi okom malamafeꞌ eaꞌ nandambema naꞌipa amam nematawa hiasi sagagiꞌma anini naꞌi, “Aeꞌ aꞌipipa, soldia dembinai anamba anen ina ipaꞌ Israelinai. Owaꞌ deiꞌ nahapifa aeꞌ. Owaꞌ anona aman Israelinai nohapifi naꞌambaea, owaꞌatin. Anen nikilaꞌ ipaꞌ Israela nagahapifi banagambel.” ");
INSERT INTO aoj_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Eaꞌ amom amamba kepten nasapaꞌam magafiꞌii motanima mafeꞌ ipat mati aman anamba nandaꞌ maola kepteni boꞌona eaꞌ. ");
INSERT INTO aoj_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Aꞌi owaꞌ main, Jisas nafeꞌ anambel wambel Nen. Alipumi ananimi maloma anis amam nematawa hiasi safeꞌ salomana. ");
INSERT INTO aoj_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Anen nafeꞌ felefeleꞌma uta sagawis wambel ambalembama, owaꞌ nati anis sofaꞌ anin awani nagagaꞌi safiꞌi saꞌi sowan. Awani inimba nagagaꞌi maꞌman alifiꞌwi. Akoꞌw kola anin atin, waulunamaꞌw aꞌ nagaꞌ. Eaꞌ esis amam nematawa hiasi sagape wambel ambalembai safiꞌi salumai akoꞌw. ");
INSERT INTO aoj_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Dembinai nati akoꞌw, okom ananimi maꞌi uwahipiꞌw eaꞌ naꞌipaꞌw naꞌi, “Inaꞌ negalef owaꞌi.” ");
INSERT INTO aoj_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Ama main, anen nafeꞌ felefeleꞌ nasa lagola bokis sagalanasi. Eaꞌ amom mogofaꞌai bokis isimbai tol malutu. Eaꞌ Jisas naꞌi, “Awani, inaꞌ nemeꞌ! Aeꞌ aꞌipina, inaꞌ safel.” ");
INSERT INTO aoj_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","16","Awani inimba nagagaꞌ eaꞌi nesafel nape naꞌi. Eaꞌ Jisas nasoꞌakwan maꞌman ananiꞌwi. Naꞌamba esis ombal mahas aꞌowaꞌ safela agol Godi saꞌi, “Anona aman profet dembinai nataga eaꞌ laꞌafena apaꞌ. God nafiꞌi ma nogatopalopa amam nematawa ananipai.” ");
INSERT INTO aoj_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Eaꞌ basef ifimba ma maol Jisasi fafeꞌagon hiꞌalagon anamba itap luꞌupa Judia eaꞌ anamba hiagoma wapani. ");
INSERT INTO aoj_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Alipumi Joni maꞌipana hiahaom amamba banagami Jisas nandaꞌami. Eaꞌ Jon nofala alipumi biam ananimi ");
INSERT INTO aoj_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","nasapaꞌam mafeꞌ mahaliꞌ Dembinai Jisas maꞌi, “Inaꞌ aman maꞌwina aꞌ nafiꞌi, eaꞌ aꞌa ataꞌ mope mohafa anona daiana?” ");
INSERT INTO aoj_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Alipumi amamba biam Joni matagama Jisas eaꞌ maꞌi, “Jon nagapisiꞌas embeli nasapaꞌ afaꞌ biafa wafiꞌmai inaꞌ, anen naꞌi nogawa, ‘Inaꞌ aman maꞌwina nafiꞌi, aꞌa ataꞌ mope mohafa anona daiana?’” ");
INSERT INTO aoj_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Nemaf afamba atef Jisas nandaꞌ amam nematawa aowas hiana haona nandaꞌasi sataga boꞌwes. Anen natofamasa ambagof awami magapaisi. Hiasi naep pagasoꞌasi nandaꞌmasep patimas andeandeꞌ. ");
INSERT INTO aoj_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Eaꞌ Jisas nagwamama basef naꞌi, “Ipaꞌ pitanima pefeꞌ piꞌipa Jona hiahawes isimba deiꞌ patilis pagameꞌasi. Isimba naep pagasoꞌasi asati wapani, boꞌwagah awamisi safeꞌ andeandeꞌ. Isimba aowas aunai nandaꞌ alop asasipi pagambuꞌwi amboꞌwes, aligah hagasoꞌasi sameꞌ basef andeandeꞌ, sagagaꞌi sotanima sosafel wapani a kwahusi sameꞌ basef buꞌwafi Godi. ");
INSERT INTO aoj_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Epes mamahisa ukup atifip sagahapifai, isimba asonohas andeandeꞌ.” ");
INSERT INTO aoj_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Amom biam mogofaꞌi basefa Joni aꞌ motanima mafeꞌ. Eaꞌ Jisas naꞌipa esis amam nematawa ma Jon naꞌi, “Fowaꞌ ipaꞌ pafeꞌ anep itap fataupigima wafigima pafeꞌ pati main? Pafeꞌma pagati anona aman pupulinai siꞌi anota elifita fufin naolata tagalimbi? Owaꞌatin. ");
INSERT INTO aoj_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Aꞌa pafeꞌ pati main? Pafeꞌ pati anona aman nagala klos fasimi atumii? Owaꞌatin. Epes isimba sogatala hiahaom buꞌwami atumi ma moni hianai sagala klos fasimi atumi, epes isimba sagape ifagw buꞌwagwi atogw amom king dembami magapaugwi. ");
INSERT INTO aoj_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Apaꞌ ipaꞌ deiꞌ pafeꞌ pati main? Pafeꞌ pati anona aman profet? Endilisi aeꞌ aꞌipipa, anen profet dembinai nikilaꞌ profet hiami hiꞌalam. ");
INSERT INTO aoj_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Aman anamba eaꞌ maꞌuna anen atona siꞌi basef fagape Baibeli naꞌiasa God fowaꞌ naꞌias nagaꞌi, ‘Inaꞌ nemeꞌ, anaf aeꞌ esapaꞌ aman nogofaꞌo basef aeꞌafii niliꞌ nefeꞌma inaꞌ nondondomba ufiaꞌw ineꞌikwi.’ ");
INSERT INTO aoj_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Aeꞌ aꞌipipa, Jon dambena nikilaꞌ amam hiami ma itap apaꞌe. Apaꞌ epen ami deiꞌ nigawis nomona maol Godi nope dembinai nugumafian, inimba dambeni nikilaꞌ Jon. Iꞌi epen inimba agol akani ma wambota Godi, anin wapani deiꞌ nape dambeni nikilaꞌana.” ");
INSERT INTO aoj_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Eaꞌ amom mogofaꞌ takis mogambasoꞌmasi maloma epes hiasi sagameꞌ basef Jisasi esis saꞌi, “Ahoꞌ, waf Godi andeandeꞌ.” Deiꞌ main, Jon atona nagapisiꞌasi. ");
INSERT INTO aoj_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Apaꞌ amom Farisi maloma anom magawalipasa muꞌuli Godi ina mofaꞌ baptaisa Jon, owaꞌ. Amom mandaꞌas naꞌamba deiꞌ mandambema mowaꞌ alafugaha ufiaꞌw fasiꞌwi God nigihimbaꞌmamaꞌwi. ");
INSERT INTO aoj_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Eaꞌ Jisas naꞌi, “Atiasi aeꞌ indilaꞌwaifa ipaꞌ amam nematawa deiꞌ pagape itapi iꞌimama? Aeꞌ iꞌipipa basef maif waminif atina pegegawa waf ipeꞌifi? ");
INSERT INTO aoj_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Ipaꞌ pape siꞌi anis awasi sandakolas sagapoma sofala anis awasi daias sagaꞌi, ‘Apaꞌ mandagala mufapula batagwa ipaꞌ, apaꞌ ipaꞌ ina palemb. Apaꞌ mandaꞌ awalef siꞌi sagatala fawiagof malef mindiwagef, apaꞌ ipaꞌ owaꞌ pelefa.’ ");
INSERT INTO aoj_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","“Aman anamba Jon nagapisiꞌas embeli nafiꞌi, ina naꞌ gwaꞌaisii embel wain, owaꞌatin. Eaꞌ paꞌi ambal aunai napaona. ");
INSERT INTO aoj_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Deiꞌ aeꞌ ataga epen egefaꞌ alop epesi afiꞌi aꞌ gwaꞌaisi saloma embel wain, eaꞌ patolowe paꞌi, ‘Piti anen aman nagaꞌ waliꞌita hiatai, nagaꞌ embel wain hiani endilisii. Anen alipunai ma amom mogofaꞌ takisi magambasoꞌmasi maloma amam mandaꞌ waf awafii!’ ");
INSERT INTO aoj_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Apaꞌ epes ami sigaila gawa fasini Godi, esis hiasi saꞌi, ‘Gawa inimba anin buꞌwani!’” ");
INSERT INTO aoj_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Anona aman Farisi nahaliꞌ Jisasa nifiꞌi neaꞌ gwaꞌaisi nogalomana. Eaꞌ nafeꞌ ipat atamba Farisii nalomana maꞌ gwaꞌaisi. ");
INSERT INTO aoj_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Eaꞌ anoꞌw nemataꞌw kwagape taun inimbai kwandaꞌ waf awafii. Akoꞌw kwameꞌ basefa Jisas naꞌ gwaꞌaisi ipat atamba. Eaꞌ kofaꞌ anol botol fasili siꞌi otam embel sanda alogw fasigwi gwagani kwafiꞌi. ");
INSERT INTO aoj_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Eaꞌ kwawis kwafeꞌ kwalutu alafuga Jisasi felefeleꞌma boꞌwagah ananigahi kwalef. Eaꞌ embif akwaꞌufi faluwi fewala boꞌwagah Jisasi eaꞌ kwandaꞌ auf balagaifi kopatiꞌ embif akwaꞌufi, kwape kwasisiꞌ boꞌwagah ananigahi kwandaꞌ lotumana. Eaꞌ kwakoloꞌ sanda inimba boꞌwagah ananigahi. ");
INSERT INTO aoj_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Eaꞌ Farisi anamba nahaliꞌ Jisas nagafiꞌii nati isimba, nomonas ananisi sandandaꞌ saꞌi, “Iꞌi aman anamba endilisi anen profetai, aꞌ nogawa nemataꞌw akwamba kwagahapila anini, nogawa waf akwaꞌufi. Deiꞌ main? Akoꞌw kwandaꞌ waf awafii.” ");
INSERT INTO aoj_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Eaꞌ Jisas nagwamana nomonas isimba Farisi anamba naꞌipana naꞌi, “Saimon, aeꞌ aꞌi iꞌipina anif basef.” Eaꞌ Saimon naꞌi, “Tisa, inaꞌ walapa basef ineꞌifi.” ");
INSERT INTO aoj_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Jisas naꞌi, “Amam biam anof wiaf fapoma amoma anona aman otamba hiamunai. Anona nowaola wiafa 100 kina apaꞌ anona 10 kina atin. ");
INSERT INTO aoj_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Ama main, amom biam ina laꞌifima mogogwa wiaf afamba, owaꞌ. Eaꞌ deiꞌ aman anamba okom masoꞌana wiaf afamba amom biami nakwahomamaf. Eaꞌ amom biam atiasi ami okom mimila anen aꞌowaꞌ nikilaꞌ anona?” ");
INSERT INTO aoj_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Saimon nagwa basef naꞌamba naꞌi, “Aeꞌ aꞌi aman anamba nagasoꞌana wiaf luꞌwafii 100 kinai.” Jisas naꞌi, “Inaꞌ nawalogef andeandeꞌ.” ");
INSERT INTO aoj_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Eaꞌ nandambema naꞌipa Saimon naꞌi, “Inaꞌ niti nemataꞌw akwaꞌe? Aeꞌ afiꞌi awisi ipat ineꞌitai. Inaꞌ owaꞌ neseꞌe embel esaꞌopa boꞌwagah aeꞌagahia, owaꞌatin. Apaꞌ nemataꞌw akwamba kwasaꞌopa boꞌwagah aeꞌagahi ma embif fagaluwi naep akwaꞌupii. Eaꞌ kopatiꞌif balaga akwaꞌugai. ");
INSERT INTO aoj_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Inaꞌ owaꞌ nisisiꞌ aeꞌa. Apaꞌ dokoꞌ aeꞌ afiꞌi awisi atin, akoꞌw kwape kwasisiꞌ boꞌwagah aeꞌagahi atapiꞌw kwape kwafiꞌi kwataga deiꞌ. ");
INSERT INTO aoj_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Inaꞌ owaꞌ nendaꞌ wel nefame balaga aeꞌagaia. Apaꞌ akoꞌw kwaofame boꞌwagah aeꞌagahi embel sanda. ");
INSERT INTO aoj_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Naꞌamba deiꞌ aeꞌ aꞌipina. Akoꞌw okom maimaila aeꞌ aꞌowaꞌ. Waf afamba okom magamagaila aeꞌafi fihimbaꞌmapa waf awafi akwaꞌufi hiafi akwahomaꞌwaf hiꞌalaf. Epen ami God nokwahoman waf awafi ananifi kwasalaꞌuf okom mosoꞌanaf, epen inimba anin atiasi okom mimila God kwasakwasala.” ");
INSERT INTO aoj_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Eaꞌ Jisas naꞌipa nemataꞌw akwamba naꞌi, “Aeꞌ akwahomena waf awafi ineꞌifi okom maseꞌeaf.” ");
INSERT INTO aoj_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Eaꞌ amom mape maꞌ gwaꞌaisi magalumanai mape ukup talambi mandaꞌipama maꞌi, “Aman anamba anen mamahonama naꞌi atiasi banagonama nogakwaha waf awafii?” ");
INSERT INTO aoj_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Jisas naꞌipa nemataꞌw akwamba naꞌi, “Inaꞌ nahapifa aeꞌ banagiwai. Isimba atis God nakwahomena waf awafi ineꞌifi nowambelena nitanimai nepe andeandeꞌ. Inaꞌ foꞌo, eaꞌ nembel ineꞌimbili bepe awanembel.” ");
INSERT INTO aoj_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Aꞌi owaꞌ main, Jisas nafeꞌ walemb hielimbi nasoꞌasa basef buꞌwafi amam nematawa sagape taun inimbai walemb hiagomai. Naꞌipasa basef ifimba buꞌwafi ma atiasi sogawis nomona maol Godi nope dembinai nugumafias. Alipumi ananimi maloma ");
INSERT INTO aoj_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","anowa nematawa safeꞌ salomana. Nematawa awamba fowaꞌ aowas nandaꞌawa Jisas natofamawa ambagof awami nandaꞌawa boꞌowa. Anoꞌw Maria sofalaꞌw saꞌi Makdalaiꞌwi, fowaꞌ nagatofamaꞌwa ambagof awami 7-pelaim magapauꞌwi. ");
INSERT INTO aoj_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Eaꞌ anoꞌw Joana nemataꞌw anona aman nugumafi ipat Heroti, agol ananigili Susa. Aꞌ anoꞌw Susana kwaloma anowa nematawa hiawai daiawa wapani wafeꞌ walomana. Awo watopalopa anen naloma alipumi ananimi ma otamba gwaꞌaisi mais awausi. ");
INSERT INTO aoj_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Esis amam nematawa hiasi safiꞌi taun hiagoma, safiꞌi sandakolas safiꞌmai Jisas. Eaꞌ anen nasoꞌasa basef waminif atin naꞌamba naꞌi, ");
INSERT INTO aoj_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Anona aman nafeꞌ nowaha olemb witimb siꞌi raisi anof aof. Nowahemb nafeꞌ, anemb bewa ufiaꞌw sagafeꞌma. Anis epes safeꞌ safafaꞌasemb eaꞌ amiguf fufiaꞌ fafiꞌi faꞌamb. ");
INSERT INTO aoj_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Anemb bewa anagon otambaigima. Eaꞌ bataga apaꞌ itap owaꞌ embelepa. Gagalisimb eaꞌ alimb. ");
INSERT INTO aoj_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Anemb bewala laꞌafena mandelef wandafumi mataga malomam maofana wit, eaꞌ amom ina mail mola gwaꞌaimi, owaꞌ. ");
INSERT INTO aoj_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Eaꞌ anemb bewa begafeꞌ itap fasipai eaꞌ bataga balo bail bela gwaꞌaisi. Olemb ambamba atona bataga balo bail bela gwaꞌaisi hiasi 100-pelais atis.” Jisas naꞌias naꞌamba ma eaꞌ, naꞌipas mehip naꞌi, “Ipaꞌ aligah hagagalipai ma pegameꞌ basef ifimbai, pendameꞌef andeandeꞌ ukup pendapomef.” ");
INSERT INTO aoj_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Ama main amom alipumi Jisasi mahaliꞌanama basef kofagefa waminif atini. ");
INSERT INTO aoj_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Eaꞌ nagwamama basef naꞌi, “God eaꞌ nihimbaꞌmepa basef kofagefa fape fandambahiꞌi ma ipaꞌ pigawis nomona maol ananini nope Dembinai nugumafipa. Apaꞌ anis daias owaꞌ. God ina nihimbaꞌmas basef ifimba kofagefa, owaꞌ. Ama esis ina semeꞌ basef ifimba alihif, owaꞌ. Semeꞌ basef waminif atini atifa atiasi sotologon, apaꞌ ina siti anis maefah, owaꞌ. Eaꞌ sogahembeꞌ semeꞌ basef, apaꞌ ina sogawa kofagefa, owaꞌatin.” ");
INSERT INTO aoj_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Basef waminif atini kofagefa naꞌamba. Olemb ambamba siꞌi basef Godi. ");
INSERT INTO aoj_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Anemb begewala ufiaꞌwi ambamba siꞌi epes sameꞌ basef, owaꞌ Satan nafiꞌi nelefata basef ifimba fagape nelelemb asasilimbi ma esis ina sahapifa God nakwahomas waf awafi sagape andeandeꞌ, owaꞌatin. ");
INSERT INTO aoj_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Anemb bewa bafeꞌ anagon otambaigimai, ambamba siꞌi anis epes sameꞌ basef Godi eaꞌ sofaꞌef sandagalamef. Apaꞌ isimba siꞌi masilimb owaꞌ bendala begewala itap awinia. Esis sahapilif nogota bandata ma aꞌi owaꞌ, Satan nagwambasa sondaꞌ waf awafi eaꞌ sandahagas sakwaha sagahapifa God. ");
INSERT INTO aoj_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Anemb begewala mandelef wandafumi laꞌafini, ambamba siꞌi anis sameꞌ basef sailif safeꞌ ama main owaꞌ, anom nimanimi mamimami maloma moni main a anom dagala maim itapami, hiahaom amamba masoꞌala esis. Eaꞌ ina sahapilif sandaꞌ waf buꞌwafi banages, owaꞌatin. A sowa siꞌi gwaꞌaisi owaꞌ sogalo andeandeꞌia. ");
INSERT INTO aoj_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Apaꞌ olemb ambamba begewala itap fasipai, ambamba siꞌi anis sameꞌ basef sahapilif tatalaꞌif. Nelelemb asasilimbi fasilimba sagameꞌ basef Godi sogailif. Esis sape banages sandaꞌ waf fasifi banagef, isimba sape siꞌi olemb bataga balo bail begela gwaꞌaisi andeandeꞌi.” ");
INSERT INTO aoj_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Epes ina sakata lambeh sopaloꞌambeh haꞌoh lafelagwa baketia o belitagw lafelagwa, owaꞌatin. Esis sawamonambeh hatoma belita ilifa epes isimba suwisi sigati nogogalaꞌ. ");
INSERT INTO aoj_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Hiahaom mape mandambahiꞌi anaf motaga alihigima hiasi sotolom sogawam. Apaꞌ hiahaom hiami ataꞌ sambahoꞌwam magaꞌihi, anaf aꞌ motaga mondawalap, hiasi sogawam. ");
INSERT INTO aoj_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Eaꞌ ipaꞌ solawaipa pendameꞌ basef andeandeꞌ. Epes ami sogahapila basef Godii, atiasi God aꞌ nowatanimasef wapani. Apaꞌ isimba owaꞌ sogahapilifia, atiasi basef kwawiaꞌwif ifimba esis sogahapilafi, God aꞌ nondalombasef esis sope dowaf.” ");
INSERT INTO aoj_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Nemaf afamba maꞌmana Jisasi kwaoꞌwa owapana safiꞌmai anen. Owaꞌ amam nematawa hiasi sandakolasi siliꞌamana, eaꞌ esis ina safeꞌ felefeleꞌma anen, owaꞌ. ");
INSERT INTO aoj_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Eaꞌ anis epes sape sagalomanai saꞌipana saꞌi, “Inaꞌ nemeꞌ, maꞌmena ineꞌikwi kwaloma anom owapena ineꞌimi safiꞌi salutu andoꞌ, saꞌi solomena siꞌi.” ");
INSERT INTO aoj_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Eaꞌ nagwamasa basef isimba hiasi naꞌipas naꞌi, “Esis amam nematawa isimba sogameꞌ basef Godii sogailafi, isimba maꞌme sahin owan aeꞌasi.” ");
INSERT INTO aoj_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Anef nemaf Jisas naoꞌwa alipumi ananimi malota anota bot. Eaꞌ anen naꞌipam naꞌi, “Afaꞌ ofeꞌ dumb ambamba fisanamb.” Eaꞌ amom malota bot mafeꞌ. ");
INSERT INTO aoj_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Bot atamba tafeꞌ atin, Jisas ambehahana naꞌoh nolola. Ama main, anona fufin luꞌunai naluwi dumb ambamba, embel koloꞌwalam mawisi bot nomon taꞌi asiꞌita ma embel felefeleꞌma mogowala. ");
INSERT INTO aoj_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Eaꞌ mafeꞌ minimbalona maꞌipana maꞌi, “Dembinai, afaꞌ waꞌi ahigililafa.” Anen nosafel ninifala fufini embel. Eaꞌ fufin nowala embel ina ataꞌ lasialiꞌ aꞌowaꞌ, betah hililiꞌ. ");
INSERT INTO aoj_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Eaꞌ Jisas naꞌipam naꞌi, “Hapif ipeꞌinai nape ani?” Amom ombal maham ukup hiahawep. Eaꞌ mandaꞌipama maꞌi, “Anen epen ami? Naꞌipa fufini embel sameꞌana sagahapifana.” ");
INSERT INTO aoj_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Aꞌi owaꞌ main, Jisas naloma alipumi mafeꞌ mataga anagon esis Gegesa sagapoma, anamba nape waꞌol dumb fisanamb itap apamba Galili. ");
INSERT INTO aoj_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Eaꞌ Jisas nakwaha bot nisilaꞌ nafeꞌ akata, anona aman nagape taun inimbai nafiꞌmai anen. Anom ambagof awami mapaona. Anen ina nowahoꞌ anef lowaf nape andeandeꞌ anota ipat, owaꞌatin. Fowaꞌ anen aona nape atapina nafiꞌi nafiꞌi nataga deiꞌ. Nape nafeꞌ wandelef matmati atom. ");
INSERT INTO aoj_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","29","Anona ambal aunai nahapilana tatalaꞌina. Esis sombaloꞌana sumafiana dondol sandaꞌ seni hankap sowaꞌana lagof boꞌwagah, owaꞌ, owaꞌatin. Nahapeꞌam atin. Eaꞌ ambal anamba aunai nofaꞌana nafeꞌ anamba epes akagoma. Aman anamba nafiꞌi nati Jisas, goꞌala nalef nafiꞌi nindiwa nembawa notawa felefeleꞌma boꞌwagah ananigahi. Eaꞌ Jisas naꞌipana dindinip naꞌi. “Inaꞌ ambal aunai kwaha aman anamba foꞌo.” Eaꞌ nofalana mehip aꞌowaꞌ naꞌi, “Jisas, inaꞌ Nogamana dembinai God nagape ilif endilisii, inaꞌ naꞌi nendaꞌ maina aeꞌ? Aeꞌ aꞌipina endilisi gani ilifa agol Godi, inaꞌ owaꞌi neseꞌe akafimia.” ");
INSERT INTO aoj_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Aꞌi owaꞌ main, Jisas nahaliꞌana naꞌi, “Agol ineꞌigili ami?” Anen naꞌi, “Agol aeꞌagili ambagof hiami.” Deiꞌ main, ambagof awami hiami mafeꞌ mawisana. ");
INSERT INTO aoj_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Eaꞌ ambagof amamba gigal maꞌoh banagambel mofala Jisas atapim maꞌi, “Inaꞌ owaꞌi netofafa ofeꞌ owala nowaga launai owaꞌ nowala nogotambilia.” ");
INSERT INTO aoj_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Anamba anogof bogof hiagufi falutu faꞌ gwaꞌaisi anota damota felefeleꞌ. Eaꞌ ambagof awami mofala Jisas dindinip maꞌi, “Inaꞌ niꞌi ahoꞌma afaꞌ ofeꞌ uwis bogof gwagwafumba!” Eaꞌ naꞌi ahoꞌmam, ");
INSERT INTO aoj_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","makwaha aman anamba mawisi aꞌ mafeꞌ mawisa bogof. Eaꞌ bogof agwafomba hiagufi mafaꞌ mafeꞌ mehip mowala taꞌalogol awagoma tata, mowala embel dumb afum hiꞌalam. ");
INSERT INTO aoj_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Eaꞌ amom mugumafiagufi mati hiahaom magatagama bogof agwafumbai, mafaꞌ mafeꞌ maꞌipasa hiahaom amamba amom magatulumi amam nematawa sagape tauni sagail aofah felefeleꞌi wapani. ");
INSERT INTO aoj_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Eaꞌ esis safeꞌma sigati hiahaom amambai. Safiꞌmai Jisas sati aman anamba fowaꞌ ambagof awami magapaunai deiꞌ makwahona eaꞌ amboꞌona nomonas fasisi sapaona andeandeꞌ nowahoꞌ lowaf tol nape felefeleꞌma boꞌwagah Jisasi. Esis sati amamba aꞌ ombal mahas. ");
INSERT INTO aoj_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Eaꞌ epes isimba sagati hiahawes isimbai, saꞌipas saꞌi waf Jisas nandaꞌafa aman anamba fowaꞌ ambagof awami magapaunai deiꞌ amboꞌona wapani. ");
INSERT INTO aoj_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Eaꞌ epes hiasi sagape anamba Gegesai ombal mahas aꞌowaꞌ saꞌipa Jisas saꞌi, “Inaꞌ nekwaha apaꞌ a foꞌo.” Eaꞌ Jisas nalota anota bot notanima nafeꞌ. ");
INSERT INTO aoj_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Aman anamba fowaꞌ ambagof awami magapaunai nahaliꞌ Jisas dindinip naꞌi, “Aeꞌ aꞌi efeꞌ elomena.” Owaꞌ Jisas nasapaꞌana naꞌi, ");
INSERT INTO aoj_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Inaꞌ tanima foꞌo wambel ineꞌimbili, newalapa basefa hiahaom hiami God nandaꞌmenam ineꞌi.” Eaꞌ aman anamba nafeꞌ nawalapa basefa hiahaom amamba ma amam nematawa hiasi sagape taun inimbai hiꞌalasa hiahaom Jisas nandaꞌmanam anini. ");
INSERT INTO aoj_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Jisas notanima nafiꞌi, anis amam nematawa hiasi sape sohafana. Eaꞌ sandaꞌmana nemaf buꞌwafi sandagalama nagafiꞌi. ");
INSERT INTO aoj_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","42","Ama main, anona aman nataga agilinama Jairus. Anen nugumafi ipat esis Juda sandakolasatai. Nogamana nemataꞌw atotoꞌw afagof akwaꞌugufi 12-pelaiguf felefeleꞌ kwaꞌi kogaꞌ. Eaꞌ nindiwa nembawa notawa felefeleꞌma boꞌwagah Jisasi, nahaliꞌana dindinip naꞌi, “Inaꞌ nifiꞌi ipat aeꞌatai.” Jisas nafeꞌ esis amam nematawa hiasi safeꞌ salipana dogw. ");
INSERT INTO aoj_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Anen ataꞌ nafeꞌ atin, owaꞌ, anoꞌw nemataꞌw kwafiꞌi felefeleꞌma alafuga ananigai. Aowas awasini nandaꞌakwa kwape gamba atapiꞌw afagof 12-pelaiguf. Otamba akoꞌumbai basa bewala hiꞌalambama kwagatala dokta hiami, apaꞌ ina anom laꞌifima mondaꞌakw kogataga boꞌokw, owaꞌatin. ");
INSERT INTO aoj_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Eaꞌ kwafeꞌ kwasa lagola saket Jisasi daꞌmalifitama. Kwandaꞌas naꞌamba, kwafalis atin esimbel aꞌ masoꞌ, eaꞌ ina ataꞌ maluwi wapani, aꞌ owaꞌatin. ");
INSERT INTO aoj_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Eaꞌ Jisas nahaliꞌas naꞌi, “Ami nasa lagola aeꞌ?” Eaꞌ esis hiasi saꞌi atin atin saꞌi, “Aeꞌ owaꞌ.” Eaꞌ Pita naꞌi, “Dembinai, epes hiasi isimba salutu salipina, esis safeꞌ gol inaꞌ.” ");
INSERT INTO aoj_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Owaꞌ Jisas naꞌipas naꞌi, “Aeꞌ ameꞌ banagami aeꞌami makwahowe mafeꞌma mondaꞌ anin epen boꞌwen. Aeꞌ egawa anin epen nasa lagol alop aeꞌapi.” ");
INSERT INTO aoj_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Eaꞌ nemataꞌw akwamba kogawa akoꞌw ina atiasi kondambahoꞌw ma anen, owaꞌ. Naꞌamba akoꞌw bolalaꞌw kwafiꞌi kowafa kotawa itap felefeleꞌma boꞌwagah ananigahi ma naep amam nematawa hiasii. Eaꞌ kwawalapa basef kofagefa akwaꞌufi ma deiꞌ kwagasa lagola anen. Eaꞌ kwaꞌi, “Aowas aeꞌani ahiꞌalan kwafalis atetef.” ");
INSERT INTO aoj_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Jisas naꞌipaꞌw naꞌi, “Nogame, deiꞌ inaꞌ eaꞌ nahapifa aeꞌ banagiwai. Isimba atis deiꞌ andaꞌena boꞌwena. Inaꞌ foꞌo opaf ineꞌifi fope awanef.” ");
INSERT INTO aoj_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Anen ataꞌ naꞌi atin owaꞌ, anona aman nakwaha ipat Jairusi nafiꞌi naꞌipa Jairus naꞌamba naꞌi, “Nogamena ineꞌikwi a kwagaꞌ eaꞌ. Naꞌamba ina nendaꞌ Dembinai Tisa nofoꞌo nomaꞌw kohana, owaꞌ, hapaimi.” ");
INSERT INTO aoj_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Owaꞌ Jisas nameꞌas naꞌipa Jairus naꞌi, “Inaꞌ ombal mehena, owaꞌi. Inaꞌ nihapifi atin, ama atiasi nogamena ineꞌikwi kogosafel wapani.” ");
INSERT INTO aoj_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","52","Eaꞌ Jisas nafeꞌ nataga ipat Jairusi apaꞌ ina naꞌi ahoꞌma amam nematawa hiasi suwis ipat sogalomana, owaꞌ. Naoꞌwa Pitai Jon Jems atom maloma maꞌmaꞌwi ahamaꞌw atis safeꞌ sawis salomana. Esis amam nematawa hiasi sape salef sandaꞌagamaꞌw aꞌowaꞌ. Owaꞌ Jisas naꞌipas naꞌi, “Ipaꞌ ina pelef, owaꞌi. Tol pepe. Akoꞌw ina kwagaꞌ dogw, owaꞌ. Kwaꞌoh atin.” ");
INSERT INTO aoj_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Eaꞌ esis sandaꞌiafana kwapeteꞌ. Esis sogawa akoꞌw kwagaꞌ endilisi. ");
INSERT INTO aoj_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Owaꞌ Jisas nahapila lagol akwaꞌugili nofalaꞌw naꞌi, “Saꞌukwi, inaꞌ safel.” ");
INSERT INTO aoj_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Eaꞌ ambal akwaꞌuli lotanima lafiꞌi lawisaꞌw wapani kosafel kwafalis. Eaꞌ Jisas naꞌipa esis mamasaꞌw naꞌi, “Ipaꞌ soꞌakwa anis gwaꞌaisi.” ");
INSERT INTO aoj_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Eaꞌ sati isimba, agogolalasis endilisi nomonas salasafeꞌ. Naꞌamba Jisas naꞌipas dindinipa sogagiꞌma basef ananifi naꞌi, “Ipaꞌ ina piꞌipa anin epena hiahawes isimba, owaꞌi.” ");
INSERT INTO aoj_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Nemaf afamba Jisas nofalai alipumi 12-pelaim ananimi mandakolas mafiꞌi nasoꞌam agol luꞌwagili nowaꞌ banagama mogatofa ambagof hiami awami mogatofa aowas hianai naninani nogafeꞌ. ");
INSERT INTO aoj_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Eaꞌ nasapaꞌam mafeꞌ maꞌipas basefa epes sogawis nomona maol Godi nope Dembinai nugumafias eaꞌ mandaꞌ awasisi boꞌwes. ");
INSERT INTO aoj_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Anen naꞌipam naꞌi, “Ipaꞌ ina pefaꞌ anis maefah galahitagwi isalef gwaꞌaisi moni, owaꞌi, hapaisi. Ipaꞌ ina pefaꞌ siagw biagw atogw, owaꞌ. Pefaꞌ atota atin. ");
INSERT INTO aoj_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Iꞌi pefeꞌ pigawis anota ipat, ipaꞌ pepe ipat atamba atota. Ama main, pekwaha wambel ambalemba apefeꞌ. ");
INSERT INTO aoj_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Apaꞌ iꞌi esis owaꞌ sofaꞌepa pegafeꞌ ifagw asasigwia, daoꞌ ipaꞌ pekwaha wambel ambalemba pindilaꞌma usas itap pagail boꞌwagah ipeꞌigahi ma esis sitilipa sogogawa waf awafi asasifi kofagema asasimi atom.” ");
INSERT INTO aoj_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Eaꞌ alipumi Jisasi makwaha anamba magapoma mafeꞌ walemb anamba hiagoma maꞌipasa basef buꞌwafi Godi. Eaꞌ matopalopa epes aowas nandaꞌasi sagape walemb hiagomai mandaꞌas boꞌwes wapani. ");
INSERT INTO aoj_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Gavman dembinai king Herot nugumafi itap luꞌupa Galili nameꞌ basefa hiahawes isimba hiasi sataga, apa ina nogawas andeandeꞌ eaꞌ nomonas salasafeꞌ. Deiꞌ main, anis epes saꞌi, “Jon aꞌ notanima nosafel matmat wapani.” ");
INSERT INTO aoj_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Apaꞌ anis saꞌi anif basefa Elaija profet fowaꞌinai saꞌi, “Anen nosafel wapani.” Eaꞌ anis saꞌi, “Anona aman profet fowaꞌinai notanima nosafel wapani.” ");
INSERT INTO aoj_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Apaꞌ Herot naꞌi, “Jon aeꞌ atopaꞌ biniꞌwana eaꞌ. Apaꞌ aman anamba agameꞌ basefanai, anen mamahonama?” Nape atapina naꞌi niti Jisas. ");
INSERT INTO aoj_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Aposel alipumi Jisasi motanima mafiꞌi maꞌipa Jisasa hiahawes maol amom mandaꞌani. Eaꞌ anen naoꞌwam makwaha anis epes daias, amom atom mafeꞌ anin taun Betsaida. ");
INSERT INTO aoj_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Aꞌi owaꞌ main, esis sogawa anamba nagapoma sagiꞌmana safeꞌ. Safiꞌmai anen, nandaꞌmas nemaf buꞌwafi nandagalama esis sagafiꞌi. Eaꞌ nawalipas basefa esis sogawis nomona maol Godi nope Dembinai nugumafias. Eaꞌ nandaꞌ epes aowas nandaꞌasi asataga boꞌwes. ");
INSERT INTO aoj_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Ama wambomota awin newala, alipumi ananimi 12-pelaim mafiꞌmai anen maꞌipana maꞌi, “Inaꞌ nesapaꞌ amam nematawa isimba sofoꞌo walemb aofah sagape felefeleꞌi ma sogolaoma ifagwi gwaꞌaisi. Deiꞌ main, anaꞌe afaꞌ wagapoma wafigima epes akagoma.” ");
INSERT INTO aoj_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Owaꞌ Jisas nagwamam naꞌipam naꞌi, “Ipaꞌ atipa peseꞌas gwaꞌaisi.” Eaꞌ amom maꞌi, “Afaꞌ gwaꞌaisi owaꞌ hiasa. Bret waꞌagolita taloma agof biagof eaꞌ isimba atis saꞌoh. Apaꞌ inaꞌ naꞌi afaꞌ ofeꞌ utalai gwaꞌaisi ma amam nematawa isimba hiasi?” ");
INSERT INTO aoj_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Amam atom hiami 5,000-pelaim mape. Apaꞌ Jisas naꞌipa alipumi ananimi naꞌi, “Ipaꞌ piꞌipa esis sondakolas sope oto otowa sotagama misiꞌah waꞌagilih atoh.” ");
INSERT INTO aoj_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Eaꞌ mandaꞌ amam nematawa hiasi sape. ");
INSERT INTO aoj_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Jisas nasaꞌma bret atamba waꞌagolita taloma agof biagof, naniga nati heven ilif nanifela God. Eaꞌ nawalota nasoꞌ alipumi ananimi masoꞌ esis amam nematawa hiasi hiꞌagalas. ");
INSERT INTO aoj_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Saꞌas alihis andondoꞌ, alipumi ananimi matatama duꞌwaꞌwanisi sagasagaꞌihi maloꞌwas folalef luꞌwalifi 12-pelailif siꞌilif kwaef. ");
INSERT INTO aoj_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Anef nemaf Jisas atotona nape nandabeten, alipumi ananimi mape malomana nahaliꞌam naꞌi, “Esis amam nematawa saꞌi aeꞌ aman mamahowema?” ");
INSERT INTO aoj_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Owaꞌ amom magwa basef naꞌamba maꞌi, “Anis saꞌi inaꞌ Jon aman nagapisiꞌas embeli. Apa anis saꞌi inaꞌ anona profet daiana fowaꞌinai netanima nesafel wapani, a anis saꞌi inaꞌ Elaija.” ");
INSERT INTO aoj_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Eaꞌ nahaliꞌam naꞌi, “Deiꞌ ipaꞌ paꞌi aeꞌ ami?” Pita nagwa basef naꞌi, “Inaꞌ Krais, God nandandepena nasapaꞌena nagafiꞌii.” ");
INSERT INTO aoj_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Jisas naꞌipam basef banagafi naꞌi amom ina miꞌipasa basef ifimba anis daias miꞌi anen Krais, owaꞌi. ");
INSERT INTO aoj_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Eaꞌ naꞌi, “Aeꞌ ataga epen egefaꞌ alop epesi atiasi efaꞌ akafimi hiami ma anom agufumi dembami moloma anom dembami pris a anom dembami magawalipasa muꞌuli Godi atiasi mowaꞌ alafugaha aeꞌ, mohe egaꞌ. Apaꞌ nimaguf bif hiꞌilif anef fegafeꞌma wanifi, God aꞌ nosaꞌme itanima esafel wapani.” ");
INSERT INTO aoj_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Eaꞌ naꞌipa alipumi ananimi naꞌi, “Aeꞌ efaꞌ akafimi andaꞌ maol Godi sehe egaꞌ lawag usiꞌigai tiꞌwanaegai. Iꞌi anin epen niꞌi nila aeꞌ, anin nendaꞌas naꞌamba atin siꞌi aeꞌ atapin nimaguf danda ma nigaili. Eaꞌ netalogofa okom ananimi ma maol main anin naꞌi nendaꞌani. ");
INSERT INTO aoj_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Deiꞌ main, epen ami okom mopoma ambal ananili atol, niꞌi nihapilal tatalaꞌil, anaf ambal ananili higililal. Apaꞌ ami okom mopoma aeꞌ ma nesambala ambal ananili itap apaꞌe, anaf ambal ananili God nofaꞌal lotanimai nepe andeandeꞌ lifilafi. ");
INSERT INTO aoj_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Iꞌi epen ami nendaꞌ maol naninani ma negefaꞌ gwaꞌaimi uga hiahaom hiami itapami atom higiligalami, anin wapani awen higililan nelomam. Deiꞌ bola hiahaom amamba atiasi motopalopan miꞌimama? Owaꞌatin endilisi. ");
INSERT INTO aoj_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Aeꞌ ataga epen egefaꞌ alop epesi. Iꞌi epen ami ambal aola aeꞌ nendafaꞌme eloma basef aeꞌafi, aeꞌ wapani ambal aola epen inimba endafaꞌman nemaf afamba aeꞌ ifiꞌi egaloma hiahaom fasimi banagami mogogalaꞌi aeꞌami, elomai mogogalaꞌi Godi a amom ensel hililiꞌi wapani. ");
INSERT INTO aoj_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Aeꞌ aꞌipipa endilisi, anipa pagalutu naꞌai atiasi ina pegaꞌ ulal, ataꞌ owaꞌ. Anipa atiasi apiti God nogape dembinai ma epes ananisi.” ");
INSERT INTO aoj_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Jisas naꞌipasa basef ifimba ma eaꞌ, nimaguf ifimba 8-pelaif fafeꞌma eaꞌ, anen naoꞌwa Pita naloma Jemsi Jon, naoꞌwam mondowasaꞌ anota halafuta ma nondabeten. ");
INSERT INTO aoj_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Anen nape nandabeten atin, amaga ananigai agataga gandati naꞌa, eaꞌ luwaguf nagalami aꞌ mataga afitim aꞌowaꞌ mogalaꞌ. ");
INSERT INTO aoj_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","31","Eaꞌ amam biam fowaꞌimi Mosesi Elaija mataga maloma mogogalaꞌi banagami ilifami eaꞌ malutu maꞌi malomana. Amom maꞌi ma atiasi Jisas aꞌ nigaila okom Godi ma nokwaha itap apaꞌe nogagaꞌ gani Jerusalem. ");
INSERT INTO aoj_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Pita naloma alipumi biam Jisasi amom naep nimanip aꞌowaꞌ maꞌi moꞌoh atin. Owaꞌ mosafel mati mogogalaꞌi Jisasi maloma amam amamba biam malutu magalumanai. ");
INSERT INTO aoj_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Amom biam maꞌi mokwaha Jisas mefeꞌ, owaꞌ Pita naꞌipana naꞌi, “Dembinai, afaꞌ wape naꞌaꞌe aꞌ fafas. Afaꞌ olaꞌ anoh aolah wanoh hondandamepa. Inaꞌ anop, Moses anop Elaija anop.” Pita ina nogawa andeandeꞌma nagaꞌi basef ifimba. ");
INSERT INTO aoj_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Anen ataꞌ naꞌi basef atin, anom ilagw maofana amom miliꞌamam aꞌ ombal maham. ");
INSERT INTO aoj_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Eaꞌ anagol malogol gaꞌi gatagai ilagw nomon gaꞌi, “Anamba anen Nogame aeꞌanai. Aeꞌ andandepana eaꞌ. Ipaꞌ pendameꞌ basef ananifi.” ");
INSERT INTO aoj_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Malogol agalemba gaꞌi eaꞌ, amom mati Jisas atona nalutu. Eaꞌ amom malogof fasoꞌ, ina maꞌipa anis epesa hiahaom amamba magatulumi, owaꞌ. ");
INSERT INTO aoj_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Ama naman amom makwaha halafuta atamba miliana, eaꞌ anis amam nematawa hiasi safiꞌi sowandoꞌma Jisas ufiaꞌw. ");
INSERT INTO aoj_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Anona aman nagalutu laꞌafena esisi naꞌi, “Dembinai, aeꞌ ahaliꞌina dindinip aꞌi, inaꞌ niti nogame aeꞌanai uwahipina. Eaꞌ anen atotona. ");
INSERT INTO aoj_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Anona ambal aunai nahapilana sisihina, eaꞌ kwafalis anen hogaꞌala kwapeteꞌ. Eaꞌ ambal anamba aunai naolana kwapeteꞌ endilisi, ofap nataga sisih malogol ananigili. Ambal anamba nahambombagana alop ananipi endilisi, eaꞌ ina nakwahona, owaꞌatin. Napaona atapina. ");
INSERT INTO aoj_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Eaꞌ aeꞌ deiꞌ ahaliꞌ alipumi ineꞌimi ma mogatofa ambal anamba aunai. Owaꞌ, amom ina laꞌifim.” ");
INSERT INTO aoj_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Jisas nagwa basef naꞌipas dindinip nasaꞌma ukup asasipi naꞌi, “O, ipaꞌ amam nematawa deiꞌ pagape itapi, owaꞌ pigahapifaia, nelelemb ipeꞌilimbi owaꞌ bepe andeandeꞌa. Nimaguf maꞌuf aeꞌ ataꞌ epe elomepa wapani ma egefaꞌ nimanimi ipeꞌimi? Ipaꞌ okwan nifiꞌmai aeꞌ.” ");
INSERT INTO aoj_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Nogamana ataꞌ nafiꞌi atin, owaꞌ ambal anamba aunai naolana nafeꞌ nowa itap nakotoꞌana kwapeteꞌ endilisi. Owaꞌ Jisas ninifala ambal aunai nandaꞌ aman anamba saꞌunai boꞌona eaꞌ nasoꞌanana notanima nafeꞌma ahamana ananinai. ");
INSERT INTO aoj_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Isimba atis deiꞌ amam nematawa hiasi sati banagami luꞌwami Godi agogolalasis kwapeteꞌ endilisi. Esis ataꞌ nomonas salasafeꞌ hiahias atina hiahaom amamba anen nandaꞌami, owaꞌ Jisas naꞌipa alipumi ananimi naꞌamba naꞌi, ");
INSERT INTO aoj_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Ipaꞌ pembeꞌ aligah andeandeꞌma basef deiꞌ aeꞌ igaꞌipipafi. Aeꞌ ataga epen egefaꞌ alop epesi atiasi felefeleꞌ anona aman nosoꞌasa aeꞌ efeꞌma lagof amom boumi aeꞌami.” ");
INSERT INTO aoj_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Eaꞌ amom alipumi mameꞌ basef ifimba atif, apaꞌ ina mogawa kofagefa, owaꞌ. Ataꞌ fandambahoꞌma amom. Eaꞌ amom ombal mahama mogahaliꞌana ma basef ifimba kofagefa.” ");
INSERT INTO aoj_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Eaꞌ alipumi Jisasi maꞌi anif basef mafitapef maꞌi ami nepe dembinai amamunai. ");
INSERT INTO aoj_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Owaꞌ Jisas nogawa nomonas isimbai sagape nelelemb amamilimb, eaꞌ nasaꞌmai anin awani saꞌwini nafiꞌi nalutu nalomana. ");
INSERT INTO aoj_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Eaꞌ naꞌipam naꞌi, “Epen ami nesoꞌ opafa negatopalopa anin awani siꞌi iniꞌi ma okom ananimi mopoma aeꞌ, anin naseꞌe opaf aeꞌ wapani natopalope. Eaꞌ epen ami negatopalopa aeꞌi, anin natopalopa anen nasapaꞌe agafiꞌii wapani. Deiꞌ main? Epen ami nepe agol akana laꞌafena ipaꞌ hipai, anin nape dembeni naliꞌma ipaꞌ.” ");
INSERT INTO aoj_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Eaꞌ Jon nagwa basef naꞌamba naꞌi, “Dembinai, afaꞌ wati anona aman nandaꞌ maol natofa ambagof awami ma agol ineꞌigili. Anen ina nagiꞌmafa. Eaꞌ deiꞌ wasopamana.” ");
INSERT INTO aoj_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Owaꞌ Jisas naꞌipana naꞌi, “Ipaꞌ ina apesopamana, owaꞌi. Deiꞌ main? Epen ami ina bouni ipeꞌini, inimba alipini ipeꞌini.” ");
INSERT INTO aoj_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Nogota God naꞌi nofaꞌ Jisas nogalota heven tafiꞌi felefeleꞌ, eaꞌ Jisas okom banagem naꞌi aꞌ nefeꞌ Jerusalem. ");
INSERT INTO aoj_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Eaꞌ nasapaꞌ anom amam maliꞌ mofaꞌ basef ananifi mafeꞌ. Mafeꞌ mawis anambel wambel esis Samariai ma mogandondomba hiahawes ananisi. ");
INSERT INTO aoj_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Owaꞌ, esis wambel ambalemba sowaꞌ alafugaha Jisas sandaiwaꞌma sofaꞌana sogafeꞌ ipat asasitai. Deiꞌ main? Esis sogawa anen naꞌi nefeꞌ Jerusalem. ");
INSERT INTO aoj_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Eaꞌ alipumi amamba biam ananimi Jemsi Jon mati waf afamba maꞌipana maꞌi, “Dembinai, inaꞌ naꞌi afaꞌ ofalai nif fagandifi fisilaꞌi hevena fegando epes isimba?” ");
INSERT INTO aoj_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Owaꞌ Jisas nandambema ninifala amom biam. ");
INSERT INTO aoj_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Eaꞌ mafeꞌ anambel wambel daiambel. ");
INSERT INTO aoj_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Amom ataꞌ mafeꞌ ufiaꞌw atin, owaꞌ anona aman naꞌipana naꞌi, “Aeꞌ aꞌi efeꞌ elomena. Eaꞌ ofeꞌ atin anamba hiagoma inaꞌ naꞌi negafeꞌma.” ");
INSERT INTO aoj_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Owaꞌ Jisas nagwamana naꞌipana naꞌi, “Nombagw alupugwi bologwalefa itap apaꞌe wambel agwagumbili. Amiguf wapani fufiaꞌ fagafeꞌ ilifi falaꞌ owah fapaoh gani ilif, apaꞌ aeꞌ owaꞌatin. Aeꞌ ataga epen egefaꞌ alop epesi wambel ake ma eꞌeh egalo balaga aeꞌagai.” ");
INSERT INTO aoj_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Eaꞌ naꞌipa anona aman daiana naꞌi, “Inaꞌ nifiꞌi nila aeꞌ.” Owaꞌ anen naꞌi, “Aeꞌ aꞌi ataꞌ epe imafi ahame ataꞌ etopalopana ma nogaꞌ iwana nogapani ifiꞌi ilina.” ");
INSERT INTO aoj_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Eaꞌ Jisas naꞌipana naꞌi, “Hapaimi, esis sagagaꞌi sondawago esis atis isimba sagagaꞌi. Apaꞌ inaꞌ foꞌo newalapa basefa epes sogawis nomona maol Godi nope Dembinai nugumafias.” ");
INSERT INTO aoj_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Eaꞌ anona aman daiana naꞌipana naꞌi, “Dembinai, aeꞌ aꞌi ilina. Apaꞌ inaꞌ ataꞌ niꞌi ahoꞌma aeꞌ efeꞌma esis wambota aeꞌatai inifelis iꞌi nemaf buꞌwafi ma esis siliꞌ?” ");
INSERT INTO aoj_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Owaꞌ Jisas naꞌipana naꞌi, “Epen ami nesafel niliꞌ nendaꞌ maol aofi ma nendambema niti alafuga ma negakwaha maol ananini, anin ina laꞌifina nendaꞌ maola niꞌipas sogawis nomona maol Godi, owaꞌatin.” ");
INSERT INTO aoj_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Ama main, Dembinai nandandepa anom alipumi ananimi 72-pelaim nasapaꞌam mafeꞌ mandahoꞌma biam atom maliꞌana mafeꞌ. Anen nasapaꞌam mafeꞌ taun walemb hiagoma anen naꞌi nogafeꞌagoma. ");
INSERT INTO aoj_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Eaꞌ naꞌipam naꞌi, “Ipaꞌ piti aofah hiagahi gwaꞌaimi hiami aꞌ maof eaꞌ, apaꞌ epes sandaꞌ maoli owaꞌ hiasa, kwasalaꞌwis. Eaꞌ ipaꞌ pendaꞌ betena pihaliꞌ dembinai kofagonama aofi. Pihaliꞌana ma nogosapaꞌi epes hiasi sofeꞌ sondaꞌ maola sola gwaꞌaimi ananimi sogambeꞌam atifigin. ");
INSERT INTO aoj_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Ipaꞌ foꞌo. Pemeꞌ, aeꞌ asapaꞌ ipaꞌ pefeꞌ siꞌi mafis sipsip laꞌafena nombagw alupugwi. ");
INSERT INTO aoj_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Ipaꞌ ina pefaꞌ paos manisi soloma brasbeli su, owaꞌi. Ipaꞌ ina pendaꞌmasa nimaguf buꞌwafi anis amam nematawa ufiawa, owaꞌi. Pefeꞌ kwafalis. ");
INSERT INTO aoj_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Iꞌi ipaꞌ pefeꞌ pigawis anota ipata, ataꞌ piliꞌ piꞌias naꞌamba piꞌi, afaꞌ waꞌi God nondaꞌ opalef ipaꞌ hipai pagape ipat atambai fepe awanelef. ");
INSERT INTO aoj_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Ama iꞌi anin epen opaf awanafi nepe ipat atamba, eaꞌ basef buꞌwafi ipeꞌifi fepoma epen inimba. Apaꞌ iꞌi owaꞌ, hapaimi, basef ifimba buꞌwafi fitanimai fepemepa atapif. ");
INSERT INTO aoj_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Ipaꞌ pendape ipat atamba atota. Ina pepe pefeꞌ ifagw gwagwigwagwi, owaꞌi. Pepe ipat atamba atotota peaꞌ gwaꞌaisi embel esis sagasiꞌipasi. Deiꞌ main, amom mandaꞌ maoli andeandeꞌma mogofaꞌ otamba ma maol amamini. ");
INSERT INTO aoj_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Iꞌi ipaꞌ pefeꞌ pigawis anin taun ama esis sofaꞌepa pegafeꞌ ifagw asasigwi, ipaꞌ pefaꞌ gwaꞌaisi esis sagatambeꞌmepas ipeꞌi. ");
INSERT INTO aoj_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Eaꞌ pendaꞌ isimba aowas nandaꞌasi boꞌwes wambel ambalemba. Eaꞌ piꞌipa esis piꞌi, ‘Nemaf afamba felefeleꞌma fegataga ma ipaꞌ pigawis nomona maol Godi nope Dembinai nugumafipa.’ ");
INSERT INTO aoj_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Apaꞌ ipaꞌ iꞌi pefeꞌ piwis anin taun, ama esis owaꞌ sofaꞌepa pefeꞌ ifagw asasigwia, ipaꞌ pefeꞌ pilutu ufiawa taun inimba piꞌi, ");
INSERT INTO aoj_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Itap duꞌwaꞌwanipi ma taun inimba ipeꞌini paila boꞌwagah afaꞌigahi, apaꞌ afaꞌ upatiꞌap pitanima pefeꞌmago ipaꞌ. Ama ipaꞌ ukup pendandaꞌ pegawa basef ifimba andeandeꞌ. Nemaf afataga felefeleꞌ ma epes sogawis nomona maol Godi, owaꞌ, ipaꞌ pandaiwaꞌ.’ ");
INSERT INTO aoj_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Deiꞌ aeꞌ aꞌipipa, nemaf afamba luꞌwafi God nogawaloga epesafi anen anaf niti esis fowaꞌ sagape Sodomi uwahipis kwasakwasala. Apa epes isimba wambel ambalembaisi anen ina niti uwahipis, owaꞌ. Akafimi luꞌwami awami endilisii anaf aꞌ motagamas.” ");
INSERT INTO aoj_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Aeꞌ ati ipaꞌ Korasinipai paloma Betsaida owahipipa aꞌowaꞌ! Nimanimi akafimi luꞌwami atiasi aꞌ motagamepa. Epes isimba fowaꞌ gani sandaꞌ waf awafii sagape walemb ambalemba bialembi Tairi Saidoni, esis ina sati anin maol buꞌwani banagani siꞌi deiꞌ andaꞌam walemb ipeꞌilimbi, owaꞌ. Iꞌi esis isimba Tairi Saidon siti maol inimba ai, esis sowahoꞌ begah pepeꞌagatami siꞌi luwaguf tol sope nif agambeh. Ama sigihimbaꞌma anis epes esis eaꞌ sambema nelelemb endilisi safeꞌma God. Apaꞌ owaꞌ, owaꞌatin. ");
INSERT INTO aoj_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Nemaf afamba God nogawaloga epesafi, niti esis fowaꞌ sagape Tairi Saidoni uwahipis kwasakwasala. Apaꞌ ipaꞌ anen ina niti uwahipipa, owaꞌ. Anaf pefaꞌ akafimi luꞌwami awami endilisi. ");
INSERT INTO aoj_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Eaꞌ ipaꞌ Kaperneam, anaf esis sosaꞌma agof ipeꞌigufi folota ilif? Owaꞌatin. Anaf God nokwahepa pefeꞌ pewala wambel awambili hel.” ");
INSERT INTO aoj_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Eaꞌ naꞌipa alipumi ananimi naꞌi, “Epen ami negameꞌ malogof ipeꞌigufii, anin nameꞌ malogol aeꞌagili wapani. Apaꞌ epen ami neseꞌepa alafugah ipaꞌ, anin naseꞌe alafuga aeꞌ eaꞌ nasoꞌana alafuga anen nasapaꞌe agafiꞌii wapani.” ");
INSERT INTO aoj_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Aꞌi owaꞌ main, amom amamba mafeꞌ mandaꞌ maoli 72-pelaim motanima mafiꞌi sonaham endilisi maꞌi, “Dembinai, afaꞌ wahapila agol ineꞌigili, ambagof awami mameꞌ basef afaꞌifi.” ");
INSERT INTO aoj_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","19","Eaꞌ anen naꞌipam naꞌi, “Aeꞌ ati Satan aꞌ nowai heven siꞌi otaga holala ma diwagala. Pemeꞌ, aeꞌ eaꞌ aseꞌepa banagami ipaꞌ ma atiasi laꞌifipa pegefaꞌasa uguf awagufi wandafugufi foloma awisuguf. Ama laꞌifipa pegapaꞌaga banagami hiami aman bounai aunai ipeꞌinai. Eaꞌ ina atiasi anin mae atitin nehambombagepa, owaꞌatin. ");
INSERT INTO aoj_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Apaꞌ ipaꞌ ina pendagalama ambagof awami magameꞌ basef ipeꞌifi, owaꞌi. Ipaꞌ sonendahepa ma God nandaꞌ agof ipeꞌigufi fail buk ananiꞌwi gani heven.” ");
INSERT INTO aoj_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Nogota atamba atota Ambal buꞌunai Godi nawalapa dagala nembel Jisasi eaꞌ naꞌi, “O ahame, inaꞌ Dembinai ma ilifi itapi. Aeꞌ asaꞌma agol ineꞌigili anifelina. Deiꞌ main? Inaꞌ nambahoꞌ hiahaom amamba ma esis epes gawaisi sogofaꞌ gawa luꞌwanii, eaꞌ nambemam nihimbaꞌmasam epes isimba gawa akasi falafisi. Ahoꞌ ahame, okom ineꞌimi magaꞌi, eaꞌ amamba atom. ");
INSERT INTO aoj_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","“Ahame aeꞌanai nandaꞌ hiahaom hiami hiꞌalam mape lagol aeꞌagili. Ina anin epen negawa aeꞌ Nogamana Godi, owaꞌatin. Anen atona nogawe. Eaꞌ owaꞌ anin epen negawa ahamea, owaꞌatin. Aeꞌ Nogamana ananiwai atowe egawana. Aeꞌ aloma epes isimba mamahisa igihimbaꞌmasa isimba wapani, esis atis sogawana.” ");
INSERT INTO aoj_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Eaꞌ anen nandambema nati amom alipumi ananimi atom mape malomana naꞌipam naꞌi, “Epes sagati hiahaom ipaꞌ pagatulumi esis sonahas. ");
INSERT INTO aoj_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Deiꞌ main? Fowaꞌ amom king dembami hiami maloma amom profet hiami maꞌi miti hiahaom amamba deiꞌ ipaꞌ pagatulumi. Apaꞌ owaꞌ, owaꞌatin. Ukup amamipi paꞌipaꞌi aꞌowaꞌ ma maꞌi mogameꞌ basef ifimba ipaꞌ pagameꞌafi, apaꞌ owaꞌ, owaꞌatin. Amom ina mameꞌef matolom.” ");
INSERT INTO aoj_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Anona aman gawainai nagawalipasa muꞌuli Godii nosafel naꞌi nogwamba Jisas nememeꞌmana. Eaꞌ naꞌipana naꞌi, “Dembinai, aeꞌ endaꞌ maina atiasi egefaꞌ ambal namili egape andeandeꞌ lifilafi?” ");
INSERT INTO aoj_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Jisas naꞌipana naꞌi, “Basef maif fapoma muꞌuli Godi? Inaꞌ natalifif naꞌimama?” ");
INSERT INTO aoj_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Owaꞌ anen nagwamana basef naꞌi, “Nomonas ipeꞌisi sehafela dembinai God ipeꞌinai sisilana naꞌamba. Ukup ipeꞌipi pipilana hiꞌindalep, peseꞌana ambagufi nelelemb soloma pepel ipeꞌisi pendasoꞌanas hiꞌindalasa dembinai God atona. Eaꞌ ukup pipila anis epes sagape felefeleꞌma ipeꞌi siꞌi ukup pagapagaila ipaꞌ atipa.” ");
INSERT INTO aoj_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Jisas naꞌipana naꞌi, “Isimba inaꞌ nagwa basef usiꞌif. Inaꞌ nendaꞌas naꞌamba ma atiasi negape ambal namili dondol lifilafi.” ");
INSERT INTO aoj_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Aman anamba naꞌi nondandaꞌ agol ananigili atogol gondape boꞌwagol. Eaꞌ naꞌipa Jisas naꞌi, “Epes sagape felefeleꞌma aeꞌi, esis ami?” ");
INSERT INTO aoj_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Eaꞌ Jisas nagwamana anif basef naꞌi, “Anona aman nakwaha Jerusalem nafeꞌ niliana Jeriko. Eaꞌ anom mandaꞌ wali matolona ufiaꞌw, mandolaepana hiahaom hiami luwaguf maim ananimi mahana kwapeteꞌ. Amom mandaꞌam naꞌamba makwahona mafeꞌ. Anen nandati siꞌi nagagaꞌi. ");
INSERT INTO aoj_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Nemaf afamba anona aman pris naila ufiaꞌw akwamba nafeꞌ. Owaꞌ nati aman anamba, nindihiꞌamana naila ufiaꞌw waꞌakw nafeꞌ. ");
INSERT INTO aoj_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Ama main, anona aman wambota Livaii naila ufiaꞌw akwamba nafiꞌi wapani. Nafiꞌi nati aman anamba owaꞌ, nindihiꞌamana naila ufiaꞌw waꞌol atogon nafeꞌ. ");
INSERT INTO aoj_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Owaꞌ, anona aman Samariainai naila ufiaꞌw akwamba nafiꞌi natagama aman anamba. Anen natolona nati owahipina endilisi. ");
INSERT INTO aoj_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Eaꞌ nafeꞌ felefeleꞌma anen nakoloꞌwa wel marasin naloma embel waina melegw ananigwi, eaꞌ nowaꞌmanagw. Eaꞌ nasaꞌmana nawamonana natoma donki ananini nofaꞌana nafeꞌ nahaponana nape ipat esis fiꞌifeꞌ sagapautai eaꞌ naꞌipa aman nugumafi ipati ma nugumafiana andeandeꞌ. ");
INSERT INTO aoj_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Ama wafilu anen nasoꞌana 2 kina aman nugumafi ipat atambai naꞌipana naꞌi, ‘Inaꞌ nimafi aman anamba andeandeꞌ. Ama iꞌi anin moni ineꞌini nesa negewalama anona, anef itanimai egwamenan.’” ");
INSERT INTO aoj_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Jisas naꞌipana basef ifimba eaꞌ nahaliꞌana naꞌi, “Deiꞌ inaꞌ okom mapomas naꞌimama? Amam wanom maila ufiaꞌw magafiꞌii, amom ami nandaꞌas siꞌi aman nagape felefeleꞌma aman anamba amam awami magahanai?” ");
INSERT INTO aoj_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Eaꞌ nagwamana naꞌipana naꞌi, “Aman anamba Samariainai nati anen uwahipina natopalopana.” Eaꞌ Jisas naꞌipana naꞌi, “Inaꞌ foꞌo nendaꞌam naꞌamba atin.” ");
INSERT INTO aoj_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Jisas naloma alipumi ananimi mafeꞌ ufiaꞌw, eaꞌ nataga anambel wambel nafeꞌ nawis. Eaꞌ anoꞌw nemataꞌw agiliꞌwa Marta kofaꞌana kwafeꞌ ipat akwaꞌutai. ");
INSERT INTO aoj_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Owamaꞌw akwaꞌuꞌwi agiliꞌwa Maria. Maria kwafiꞌi kwape felefeleꞌma boꞌwagah Dembinai, kwameꞌ basef ananifi. ");
INSERT INTO aoj_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Apaꞌ Marta kwandaꞌ maol hiani ma kwagandondomba gwaꞌaimi. Nomonas akwaꞌusi sandapoma mamimami. Eaꞌ kwafeꞌma Jisas kwaꞌipana kwaꞌi, “Dembinai, inaꞌ netelowe uwahipiwi. Owame aeꞌakwi kwaꞌwaha aeꞌ atowe andaꞌ maola agandondomba gwaꞌaisi. Inaꞌ kipaꞌw kufiꞌi kotopalope.” ");
INSERT INTO aoj_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Owaꞌ Dembinai nagwamaꞌwa basef naꞌi, “Marta, Marta, inaꞌ okom mandapoma mamimami ma nembel ineꞌimbili nafeꞌ aona ma hiahaom hiami. ");
INSERT INTO aoj_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Apaꞌ hiahawes fasisi atifis inaꞌ ataꞌ akena. Maria kwaꞌi kofaꞌ hiahawes isimba fasisi sikilaꞌ anis daias. Ina anin epen laꞌifinama negelefata hiahawes isimba buꞌwasi ma akoꞌw, owaꞌ.” ");
INSERT INTO aoj_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Anef nemaf Jisas nandabeten nape anagon. Aꞌi owaꞌ nandabetena hiꞌalan, anona alipunai ananinai naꞌipana naꞌi, “Dembinai, inaꞌ nihimbaꞌmafa ondabeten siꞌi fowaꞌ Jon nigihimbaꞌma alipumi ananimi.” ");
INSERT INTO aoj_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Eaꞌ naꞌipam naꞌi, “Afamba ipaꞌ piꞌi pendabeten, ipaꞌ pigaꞌias naꞌamba piꞌi, Ahamapa, apaꞌ maꞌi agol ineꞌigili gondape hililiꞌ ma hiasi sogasaꞌma agol ineꞌigili luꞌwagol. Maꞌi nemaf afamba buꞌwafi fifiꞌi ma epes hiasi sogawis nomona maol ineꞌini nepe Dembinai nugumafias. ");
INSERT INTO aoj_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Deiꞌ inaꞌ neseꞌapa gwaꞌaisi sondahama nemaf afaꞌe. ");
INSERT INTO aoj_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Inaꞌ nekwahomapa waf awafi apeꞌifi okom moseꞌenaf. Deiꞌ main? Apaꞌ wapani makwahomasa waf awafi anis sandaꞌmapafi ukup pasoꞌapaf. Inaꞌ owaꞌi neꞌwapa mefeꞌma hiahaom ahifimi mogogwamba apeꞌia.” ");
INSERT INTO aoj_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Eaꞌ naꞌipam anif basef waminif atin naꞌi, “Iꞌi anona aman alipunai ipeꞌinai nefeꞌ nigaꞌipa alipunai ananinai owamb amanota nigaꞌi, ‘O alipunai, inaꞌ seꞌe bret wanifita ");
INSERT INTO aoj_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","ma igimafi alipunai aeꞌanai nafiꞌi natagama aeꞌ, apaꞌ aeꞌ gwaꞌaisi ake ma igimafiana.’ ");
INSERT INTO aoj_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Owaꞌ, aman anamba napani ipat nomon nagwai basef naꞌipana naꞌi, ‘Aeꞌ andaiwaꞌma negaseꞌe nomaꞌw aeꞌ, owaꞌ. Aeꞌ awasi saꞌoh eaꞌ aoꞌwas maꞌoh alahis. Aeꞌ ina laꞌifiwi ma esafel egaseꞌena gwaꞌaisi, owaꞌ.’ Deiꞌ nondaꞌas niꞌimama? ");
INSERT INTO aoj_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Aeꞌ aꞌipipa, aman ipat atambainai ina okom mapomana naꞌi aman anamba alipunai ananinai ma nosafel nogasoꞌan gwaꞌaisi, owaꞌatin. Anen okom iwanima nagameꞌ aman anamba falafala atapina nagapomana. Isimba atis deiꞌ nosafel nasoꞌana hiahaom hiami anen waowaolomi. ");
INSERT INTO aoj_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“Deiꞌ aeꞌ aꞌipipa, ipaꞌ pihaliꞌ Goda, atiasi nogaseꞌepa hiahawes. Isimba ipaꞌ pala pilaomasi, atiasi aꞌ pitilis. Ipaꞌ peha uta, atiasi God nuwisiꞌmipata ipaꞌ. ");
INSERT INTO aoj_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Deiꞌ main, epes ami sogahaliꞌ Godi, sofaꞌ maefah. Epen ami nela negelaoma hiahawesi, atiasi higatilisi. Eaꞌ epen ami negaha utai, atiasi God nuwisiꞌmanata anin. ");
INSERT INTO aoj_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","“Iꞌi anin awani nigahaliꞌ ahaman ananini nogasoꞌan anol aol, anen ina atiasi nosoꞌan anol ul awali, owaꞌatin. ");
INSERT INTO aoj_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Iꞌi awani nihaliꞌ ahamana nogasoꞌana anomb kohomb, atiasi nosoꞌan anol aunil awali? Isimba wapani, owaꞌatin. ");
INSERT INTO aoj_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Eaꞌ ipaꞌ amam nematawa aupai pagasoꞌasa hiahawes fasisi atisa awasi ipeꞌisii, ahamepa ipeꞌinai nagape heveni anen wapani atiasi nosoꞌasa Ambal buꞌwinai ananinai isimba sagahaliꞌanai.” ");
INSERT INTO aoj_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Jisas anona ambal aunai nape nagasopama malogol anona amani. Nafaꞌ nafeꞌ, eaꞌ aman anamba amboꞌona noga naꞌi. Eaꞌ esis amam nematawa hiasi ukup hiahawep papoma isimba. ");
INSERT INTO aoj_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Owaꞌ anis epes saꞌi, “Anen natofa ambagof awami ma banagami anona ambal aunai mamana agilinama Belsebul.” ");
INSERT INTO aoj_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Apaꞌ anis epes saꞌi sogwambana sofalana saꞌi anen ataꞌ nondaꞌ anin maol banagani nagafiꞌi heveni ma sitilin sogogawa endilisi God natopalopana nasapaꞌana nagafiꞌii. ");
INSERT INTO aoj_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Owaꞌ anen nogawa ukup asasipi naꞌipas naꞌi, “Iꞌi anis epes hiasi sagape itap luꞌupa anin kantri sondatopaꞌ biafis sogapaꞌ, ina atiasi banages, owaꞌ. Iꞌi anis epes wambota atota sondatopaꞌ biafisa sogapaꞌ, esis ina atiasi banages sopaꞌ, owaꞌatin. ");
INSERT INTO aoj_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Iꞌi wambota Satani sondawal biafis sogapaꞌ, atiasi wambota atamba atotota banages sopaꞌ siꞌimama? Owaꞌatin. Ipaꞌ paꞌi aeꞌ atofa ambagof awami ma banagami ambal aunai mamana Belsebul. Naꞌamba aeꞌ deiꞌ aꞌipipa basef ifimba. ");
INSERT INTO aoj_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Iꞌi endilisi aeꞌ atofa ambagof awami ma banagami Belsebuliai, deiꞌ ami newaꞌ banaga alipumi ipeꞌimi motofa ambagof awami? Owaꞌatin. Eaꞌ deiꞌ alipumi ipeꞌimi mihimbaꞌmepa basef ifimba ipeꞌifi owaꞌ endilisifia. ");
INSERT INTO aoj_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Banagami Godi atom matopalopa aeꞌ atofa ambagof awami. Eaꞌ deiꞌ ipaꞌ pegawa nemaf afamba epes sogawis nomona maol Godi nope Dembinai nugumafias afataga ma ipaꞌ eaꞌ.” ");
INSERT INTO aoj_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Eaꞌ Jisas naꞌipas anif basef waminif atin naꞌi, “Iꞌi anona aman banagonai nohapila wambawa maim banagona nogapoma ipat ananitai andeandeꞌ, hiahawes ananisi hiasi sope andeandeꞌ. ");
INSERT INTO aoj_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Apaꞌ iꞌi anona aman banagona aꞌowaꞌi nigikilaꞌ aman nanumba ma anen notaga dindinapina nifiꞌi nondaꞌ wandaf nolomana nondolaepana wambawa maim aman anamba nagawamona okomami, daoꞌ aꞌ nofaꞌ hiahaom ananimi nowalogam mefeꞌma anom amam daiam. ");
INSERT INTO aoj_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Epen ami owaꞌ alipini aeꞌani owaꞌ nepe atapin negaloma aeꞌia, anin bouni aeꞌani. Eaꞌ epen ami owaꞌ nekolasa sipsip pogaloma aeꞌapia, inimba nagatofa sipsip pafaꞌ pagafeꞌ atona bianai. ");
INSERT INTO aoj_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Nemaf afamba anona ambal aunai nakwaha anin epen nawisi nagafiꞌi, anen nafeꞌ anamba fatauguma nolaoma anagon naꞌi nogapoma nomaꞌwa. Nolaomagona owaꞌ niti anagona, eaꞌ niꞌi, ‘Aeꞌ itanima efeꞌ ipat fowaꞌ agapautai.’ ");
INSERT INTO aoj_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Eaꞌ nafiꞌi nati ipat atamba asambehata andeandeꞌ sofaloꞌmata tape. ");
INSERT INTO aoj_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Eaꞌ notanima nafeꞌ naoꞌwai ambagof deiagof awagufi 7-pelaiguf wapani mafiꞌi mawis mape ipat atamba. Ambagof amamba awami aꞌowaꞌ mandaꞌ waf awafii fikilaꞌ waf awafi fowaꞌ naliꞌ nandaꞌafi. Fowaꞌ epen inimba ataꞌ nape awen kwasakwasala, apaꞌ deiꞌ nape awen nikilaꞌ endilisi poe fowaꞌ naliꞌ nagapaini.” ");
INSERT INTO aoj_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Jisas ataꞌ naꞌi basef ifimba atin owaꞌ, anis epes hiasi safiꞌi salipana. Eaꞌ anoꞌw nemataꞌw kwape laꞌafena esis kwaꞌi naꞌamba kwaꞌi, “Nemataꞌw akwamba fowaꞌ kogolaena ma kwagaseꞌena nomambeh ineꞌi, akoꞌw kwandagala.” ");
INSERT INTO aoj_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Owaꞌ Jisas naꞌi, “Owaꞌatin. Ipaꞌ amam nematawa pagameꞌ basef Godi ma pagagiꞌmafi, ipaꞌ pandagala eaꞌ.” ");
INSERT INTO aoj_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Amam nematawa hiasi safiꞌi sandakolasi sape, Jisas naꞌipas naꞌi, “Ipaꞌ amam nematawa deiꞌ pagape itap apaꞌi, ipaꞌ epes aupai. Deiꞌ pefalagama paꞌi pigati anin ametal banagani. Apaꞌ aeꞌ owaꞌatina endaꞌan pigatilina, owaꞌatin. Ametal inimba fowaꞌ God nigihimbaꞌmanan Jonai atin atiasi ihimbaꞌmepan ipaꞌ. ");
INSERT INTO aoj_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Anona profet Jonai nataga siꞌi anin ametal nihimbaꞌma esis amam nematawa Ninivaisi. Eaꞌ naꞌamba atina aeꞌ ataga epen egefaꞌ alop epesi ataga ape siꞌi anin ametal Godi ma ipaꞌ amam nematawa pagape nogota ataꞌi. ");
INSERT INTO aoj_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Anaf God nogawaloga epesafi, nemaf afamba anoꞌw nemataꞌw kwin dembeꞌwi kwagapani gani waꞌol awin negembaꞌmai kosafel koloma ipaꞌ pagape naꞌai kolaꞌ basef fitanima filipa kwiꞌi ipaꞌ aupai. Deiꞌ main, kwin akwamba kwapani gani itap pafeꞌ pegetambela, eaꞌ kwafiꞌi kwame basefa gawa luꞌwani dembinai king Solomon nagawalipasani. Apaꞌ deiꞌ anona nigikilaꞌ Solomoni nape naꞌaꞌe. ");
INSERT INTO aoj_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Afamba God nogawaloga esis amam nematawafi esis epes Ninivaisi sosafel solaꞌ basef fitanima filipa ma waf awafi ipaꞌ pandaꞌafi. Deiꞌ main? Esis Ninive sameꞌ basef Godi Jona nagaꞌipasafi, eaꞌ sambema nelelemb sakwaha waf awafi safeꞌma God. Apaꞌ deiꞌ anona aman nigikilaꞌ Jonai nape naꞌaꞌe. ");
INSERT INTO aoj_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Epes ina sokata lambeh nomon ifagw sosapaꞌam sombahoꞌam mofeꞌ lafela maloh, owaꞌatin. Esis sakatambeh hatoma belitagw ilifa suwis sogati haugun. ");
INSERT INTO aoj_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Naep nomon ukup ipeꞌipi siꞌi lama alop siꞌip ipeꞌipi. Iꞌi ukup ipeꞌipi beꞌep pepe, alop siꞌip ipeꞌipi pogalaꞌ hiꞌilap. Apaꞌ iꞌi ukup ipeꞌipi awasip, atiasi alop ipeꞌipi hiꞌilap eaꞌ akutina. ");
INSERT INTO aoj_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Deiꞌ ipaꞌ solawaipa andeandeꞌ. Naꞌamba nogogalaꞌi nagape nomona ipeꞌi aꞌ akotina. ");
INSERT INTO aoj_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Iꞌi alop ipeꞌipi pogalaꞌ hiꞌilap, ina anagon kwaiaꞌagon akotigin, owaꞌ. Eaꞌ atiasi alop ipeꞌipi pogalaꞌ hiꞌilap aꞌowaꞌ siꞌi lambeh hatoma hogalaꞌ hogahihimipa. ");
INSERT INTO aoj_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Jisas nandaꞌ basef ifimba ma main, anona aman dembinai Farisi nofalana naꞌi nifiꞌi neaꞌ gwaꞌaisi nolomana. Eaꞌ Jisas nafeꞌ nawis nomon ipat natoma tebol. ");
INSERT INTO aoj_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Farisi anamba nati anen nafeꞌ nape naꞌ gwaꞌaisi owaꞌ nosaꞌopa lagof fuliꞌ siꞌi waf amom Farisi magagiꞌmafia. Eaꞌ anen okom hiahaom mapoma waf afamba. ");
INSERT INTO aoj_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Owaꞌ Dembinai naꞌipana naꞌi, “Ipaꞌ Farisi, ipaꞌ pandombasa kapi plet andeꞌesa atis hililiꞌ. Apaꞌ nomon owaꞌ. Ipaꞌ opalef nomon siꞌipama waf walifi faloma anef waf awafi daiaf wapani. ");
INSERT INTO aoj_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Ipaꞌ epes ukup pagahipai. Aeꞌ aꞌipipa endilisi, God nandaꞌ hiahaom andeꞌema, nomonema wapani. ");
INSERT INTO aoj_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Apaꞌ hiahaom magala nomon kahi plegw ipeꞌisii, amamba ipaꞌ pendaꞌam peseꞌ epes kwahusi petopalopas. Iꞌi ipaꞌ pendaꞌas naꞌamba, atiasi hiahawes hiasi ipeꞌisi ambeꞌes hililiꞌ. ");
INSERT INTO aoj_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Ipaꞌ Farisi uwahipipa ma akafimi atiasi mogatagamipai. Ipaꞌ pandawaloga nambawai lombo maloma akwal lalilali hiali pasoꞌana duꞌwanil ilifunamail God. Apaꞌ ipaꞌ aꞌ pindihiꞌama waf buꞌwafi usiꞌifi ukup pagapagaila Godafi ukup paseꞌepaf fape. Waf afamba feloma waf pindalali pegasoꞌana hiahawes mais Godafi, afamba pekolefaf pihapilaf atin pilaf. ");
INSERT INTO aoj_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Ipaꞌ Farisi, aeꞌ aꞌi uwahipipama akafimi nimanimi luꞌwami anaf mogatagamipai! Ukup ipeꞌipi pasaꞌmepa paꞌi pendape nogohnaep epesi nomon ifagw pandakolasugwi ma esis amam nematawa sondagalaipa sondaꞌmepa nemaf buꞌwafi ipaꞌ anamba epes hiasi sandatama sagapoma. ");
INSERT INTO aoj_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","“Aeꞌ aꞌi uwahipipa endilisi ma nimanimi akafimi anaf mogatagamipai! Ipaꞌ siꞌi matmat tape tandambahoꞌ itap nomoni epes ina sogawata, owaꞌ, esis satoma safeꞌ ilif andeꞌetama.” ");
INSERT INTO aoj_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Anona aman nagawalipasa muꞌuli Godi nagwamana basef naꞌi, “Dembinai, inaꞌ naꞌias naꞌamba, nasapagafa naꞌi afaꞌ wapani epes aufai.” ");
INSERT INTO aoj_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Eaꞌ Jisas nagwamana basef naꞌi, “Ipaꞌ amam dembipai pagawalipasa muꞌuli Godii, aeꞌ aꞌi owahipigama ipaꞌ wapani ma akafimi nimanimi luꞌwami anaf mogatagamepa. Ipaꞌ pandaꞌ hiahaom nimanimi matoma magapaiꞌ esis amam nematawai, nomaꞌw nagahasi. Apaꞌ ipaꞌ owaꞌ petopalopas pefaꞌ nimanimi amamba lagof ipeꞌigufia, owaꞌatin endilisi. ");
INSERT INTO aoj_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","“Aeꞌ aꞌi uwahipipama nimanimi akafimi luꞌwami anaf mogatagamepa! Esis aꞌmes ipeꞌisi saha amom profet magaꞌ, eaꞌ ipaꞌ pefaloꞌma matmat amamutai. ");
INSERT INTO aoj_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Waf afambai fawalapa basef alihif faꞌi ipaꞌ paꞌi ahoꞌma esis saha amom profet fowaꞌimi magagaꞌ. Eaꞌ deiꞌ pefaloꞌma matmat amamutai, ");
INSERT INTO aoj_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","pandaꞌas naꞌamba siꞌi anif basef fagail anoꞌw buk saꞌukwi sagaꞌi gawa Godi faꞌi, ‘Anaf aeꞌ esapaꞌ anom profet moloma aposel mefeꞌmago esis, asoha anom mogaꞌ eaꞌ anom sondaꞌam kwapeteꞌam.’ ");
INSERT INTO aoj_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Eaꞌ deiꞌ amam nematawa nogota ataꞌisi, anaf God nosoꞌas nimanimi ma kofagema amamba sagaha profet hiami afum hiꞌagalam fowaꞌ gani dambadamba God nandaꞌ ilif itap eaꞌ nafiꞌi nataga nogota ataꞌe. ");
INSERT INTO aoj_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Nagaliꞌi Abel nafiꞌi natagama profet Sekaraia sahana afuna laꞌafena ipat luꞌunai Godi naloma belita saofa mafis sagasoꞌ Goda. Amamba kofagema atiasi mila ipaꞌ atipa deiꞌ pagape itap apaꞌi. ");
INSERT INTO aoj_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Ipaꞌ amam gawaipai pegegawa muꞌuli Godi, aeꞌ aꞌi uwahipipa ma nimanimi akafimi luꞌwami anaf mogatagamipai. Ipaꞌ aꞌ pelefata ki inimba pegefaꞌ gawani. Ipaꞌ atipa ina pawisiꞌ uta pawis nomon, owaꞌ. Ipaꞌ pahefa ufiaꞌwa anis saꞌi sogawis nomoni.” ");
INSERT INTO aoj_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Eaꞌ nakwaha ipat atamba nawis andoꞌ, amom dembami magawalipasa muꞌuli Godi maloma amom Farisi aꞌ wandafum kwapeteꞌam aꞌowaꞌ ma mogasapagana basef anen. Amom maꞌi mogwamba malogol ananigili ma basef fafifafi. ");
INSERT INTO aoj_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Amom mape matiti anen atapim maꞌi momeꞌ anen nogaꞌi anif basef fegataga malogol ananigili ma mondaꞌmana kot. ");
INSERT INTO aoj_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Anis amam nematawa hiasi aꞌowaꞌ safiꞌi sunduwaꞌanima dogw endilisi sandafafaꞌasanima atin boꞌwagah asasigahi. Eaꞌ Jisas naliꞌ naꞌipa alipumi ananimi naꞌi, “Ipaꞌ pindimafuma andeandeꞌma yis amom Farisii. Basef kofagefa ma yis isimba faꞌi waf basoꞌafi magaꞌi malogof biagufi. ");
INSERT INTO aoj_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Hiahaom mape mandambahiꞌi, anef nemaf aꞌ motaga alihim alihigima. Hiahaom mandagigil magapani, anef nemaf epes sogawa amamba. ");
INSERT INTO aoj_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Eaꞌ basef hiafi ipaꞌ pandaꞌef akoti atiasi semeꞌef alip. Eaꞌ basef ipaꞌ hikihikaꞌ atin pandaꞌef ifagw nomoni, atiasi sotoma ifagw andoꞌ sowalapef fefeꞌ. ");
INSERT INTO aoj_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Ipaꞌ alipipai aeꞌipai, aeꞌ aꞌipipa naꞌamba. Ipaꞌ owaꞌi ombel mehepama anom amam moha alop atop pogagaꞌia ma anaf amom ina laꞌifima mondaꞌ anin mae wapani, owaꞌatin. ");
INSERT INTO aoj_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Apaꞌ aeꞌ ataꞌ iꞌipipa aman ipaꞌ ombal begahepamanai. Anamba nohepa pegagaꞌi, eaꞌ anaf wapani banagonai ma nogakwahipa pegafeꞌ wambel awambili hel. Ahoꞌ, aeꞌ aꞌipipa, ipaꞌ aꞌ ombal begahepamanai, aman anamba atona. ");
INSERT INTO aoj_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“Ipaꞌ pegawa, epes satala amiguf saꞌusi wanis bias otamba 2 toea. Apaꞌ God ina okom masoꞌana anin amil saꞌuni naꞌambaini, owaꞌ. ");
INSERT INTO aoj_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Endilisi, anen niamba awif hiafi fagala balagah ipeꞌigahi dondoꞌ hiꞌalef. Eaꞌ ipaꞌ owaꞌi ombal mehepaea. Anen okom mapoma ipaꞌ apikilaꞌ amiguf hiagufi agwafomba saꞌugufi. ");
INSERT INTO aoj_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Aeꞌ aꞌipipa, aeꞌ ataga epen egefaꞌ alop epesi. Epen ami newalapa agol aeꞌagili ma amam nematawa hiasi, anaf aeꞌ ewalapa agol epen inimbai ma naep amom ensel Godi. ");
INSERT INTO aoj_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Apaꞌ epen ami negaseꞌe alafuga aeꞌi naep amam nematawai, bola aeꞌ eseꞌan alafuga anin naep amom ensel Godi. ");
INSERT INTO aoj_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Epen ami nendaꞌ anif basef awafi findiwaefa aeꞌ ataga epen egefaꞌ alop epesi, bola God aꞌ nokwahomana awami amamba ananimi. Apaꞌ epen ami nendaꞌ basef findiwaefa Ambal buꞌunai Godi, anaf God owaꞌatin endilisi ma nogakwaha findiwa anamba aunai ma epen inimbaia. ");
INSERT INTO aoj_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Nemaf afamba atiasi esis sofaꞌ ipaꞌ pefeꞌ pigawis ifagw amamba esis Juda sandakolasugwi aꞌa sofaꞌepa pegafeꞌma naep amom agufumi sondaꞌmepa kot, ipaꞌ ina ombal behepa, owaꞌi. Ipaꞌ ina apiꞌi, ‘Atiasi apaꞌ mogwa basef miꞌimama? Atiasi mondaꞌ basef maif?’ Owaꞌi. ");
INSERT INTO aoj_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Deiꞌ main, nogota atamba atota Ambal buꞌunai Godi nihimbaꞌmepa basef maif atiasi pegagwaefi.” ");
INSERT INTO aoj_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Anona aman atotona ma amam nematawa hiasi anen naꞌipa Jisas naꞌamba naꞌi, “Dembinai, aeꞌ aꞌi inaꞌ niꞌipa sahome aeꞌanai nowaloga hiahaom amamba ahamafai neseꞌe waꞌam.” ");
INSERT INTO aoj_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Owaꞌ Jisas naꞌipana naꞌi, “Aeꞌ andaiwaꞌ! Ami nandandepa aeꞌ ma epe igahihiꞌa ipaꞌ egawalogepa hiahawesa ipaꞌ? Owaꞌatin.” ");
INSERT INTO aoj_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Eaꞌ anen naꞌipas naꞌi, “Ipaꞌ solawaipa andeandeꞌma ipaꞌ ina kowolepama anom hiahaom. Epen hiahaom hiamin aꞌowaꞌi, ina nefaꞌ ambal namili ma hiahaom amamba ananimi, owaꞌatin.” ");
INSERT INTO aoj_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Eaꞌ nasoꞌasa anif basef waminif atin naꞌi, “Aof anona aman otamba hiambainai fola gwaꞌaisi hiasi. ");
INSERT INTO aoj_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Aman anamba okom mandapoma nembel ananimbili atembel naꞌi, ‘Deiꞌ aeꞌ ataꞌ endaꞌas iꞌimama? Aeꞌ ifagw ake ma etama gwaꞌaisi aeꞌasi hiasi imbilas sogaꞌome.’ ");
INSERT INTO aoj_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","“Eaꞌ naꞌi, ‘Aeꞌ endaꞌas naꞌamba. Igulata ifagw aeꞌagwi aꞌ ilaꞌ dambaigwi luꞌwagwi gwikilaꞌ fowaꞌigwi. Ama atiasi ikolasai gwaꞌasi wit hianai noloma hiahaom hiami fasimi aeꞌami mogaꞌoh ifagw agwamba. ");
INSERT INTO aoj_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Eaꞌ iꞌipa aeꞌ iꞌi, “Aeꞌ egape andeandeꞌi. Hiahaom hiami fasimi mope mondahama afagof hiagufi. Eaꞌ deiꞌ epoma nomaꞌw eaꞌ gwaꞌaisii embel sonehe endape.”’ ");
INSERT INTO aoj_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","“Owaꞌ God naꞌipana naꞌi, ‘Inaꞌ aman owaꞌ negegawa andeandeꞌia. Deiꞌ owamb ambaꞌe aeꞌ igi ambal ineꞌili aꞌ negaꞌ. Eaꞌ hiahaom amamba hiami inaꞌ nandaꞌam nandondombam magaꞌihi, amamba atiasi ami nefaꞌam?’ ");
INSERT INTO aoj_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","“Amamba naꞌamba atin siꞌi epes satama hiahaom hiami asasimi atom sagambilami. Esis hiahawes akasa naep Godi.” ");
INSERT INTO aoj_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Eaꞌ Jisas naꞌipa alipumi ananimi naꞌi, “Aeꞌ aꞌipipa, ipaꞌ ina nomonas solasefeꞌ hiahiasa ambagof ipeꞌigufi eaꞌ piꞌi, ‘Apaꞌ ataꞌ meaꞌ main?’ Owaꞌi. Ipaꞌ ina nomonas solasefeꞌ hiahiasa alop ipeꞌipi piꞌi, ‘Atiasi apaꞌ mondaꞌ main mombahoꞌ alop apeꞌipi?’ Owaꞌi. ");
INSERT INTO aoj_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Deiꞌ main, ambagof afof ina gwaꞌaisi atis. Eaꞌ alop ina luwaguf atif, owaꞌatin. ");
INSERT INTO aoj_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Ipaꞌ ukup pepoma amiguf. Afof owaꞌ fowa gwaꞌaisi wita, owaꞌ fotama gwaꞌaisi fimbilasa. Afof ifagw akagofa fotama gwaꞌaisi sogaꞌoh. God atona nasoꞌagof waliꞌita. Apaꞌ ipaꞌ epes pikilaꞌ amiguf agwafomba endilisi. ");
INSERT INTO aoj_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Ipaꞌ atiasi ami laꞌifin nomonas solasefeꞌ lawisa nigiwatania anef nemaf wapani ma ambal ananili logape nogota laota wapani? Owaꞌatin. ");
INSERT INTO aoj_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Iꞌi ipaꞌ owaꞌ laꞌifipama pendaꞌ anis maefah saꞌusaꞌusi naꞌambaea, deiꞌ maina ipaꞌ ataꞌ nomonas salasagafeꞌ hiahiasa anom maefah mamimami daiam? ");
INSERT INTO aoj_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“Ipaꞌ ataꞌ ukup pepoma afis. Esis ina sandaꞌ maol ina sandaꞌ luwaguf mais, owaꞌatin. Apaꞌ aeꞌ aꞌipipa, fowaꞌ anona aman hiahaom hiamunai Solomon nandaꞌ sosaf hianai ma luwaguf ananimi, owaꞌ sosaf ananifi ina fasif siꞌi afis isimba, owaꞌatin. ");
INSERT INTO aoj_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Ahoꞌ, otalef afalemba deiꞌ ataꞌ fetawa aof ama naman atef sotopaꞌalef sokwahelef fefeꞌ nif. Otalef afalemba falafilifi God nofaloꞌmalef. Apaꞌ ipaꞌ amam nematawa pikilaꞌ otalef afalemba. Eaꞌ deiꞌ ipaꞌ pagahapifa basef Godi kwasakwasalai, ipaꞌ pendegawa endilisi anen nugumafipa andeandeꞌ wapanii. ");
INSERT INTO aoj_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Eaꞌ ipaꞌ ina nomonas solasefeꞌ hiahias piꞌi, ‘Atiasi meaꞌ gwaꞌaisi embel mais?’ Owaꞌi. Ipaꞌ ina nomonas iwanis solasefeꞌma hiahawes isimbai, owaꞌ. ");
INSERT INTO aoj_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Epes sagape itapi sogolalama Godi esis ukup malamondafeꞌ aꞌowaꞌ ma sogolaoma hiahaom amambai hiami. Apaꞌ ahamepa ipeꞌinai nagape heveni anen nogawa eaꞌ hiahawes mamahisa akipai. ");
INSERT INTO aoj_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Apaꞌ ipaꞌ ataꞌ ukup piliꞌ pelapelaoma waf usiꞌifi buꞌwafi feloma pigawis nomona maol Godi nope Dembinai nugumafipa piliꞌ, daoꞌ aꞌ neseꞌepa hiahawes isimba ipaꞌ wapani. ");
INSERT INTO aoj_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Ipaꞌ epes siꞌi miniꞌap bandapi sipsipi, ipaꞌ ina ombel behepa, owaꞌi. Ahamepa ipeꞌinai okom boꞌoma ipaꞌ pefeꞌ pigawis nomona maol ananini ma nope Dembinai nugumafipa. ");
INSERT INTO aoj_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Ipaꞌ peseꞌasa hiahaom hiami ipeꞌimi ma anis epes daias sotalomipam, eaꞌ pefaꞌ otamba pewalogamba pesoꞌ isimba kwahusi petopalopas. Ipaꞌ pendaꞌ maol pelaoma paos otambaisi anaf owaꞌ foloꞌogolasia. Ipaꞌ pekolasa otamba uga maim hiahaom fasimi atom heven anaf owaꞌ higiligalamia. Anamba epes isimba sandaꞌ wali ina safeꞌ felefeleꞌ, totoloh mais owaꞌ sohambombaga maefaha, owaꞌ. ");
INSERT INTO aoj_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Deiꞌ main, wambel mamahembela hiahawes fasisi ipeꞌisi sagaꞌoma, anamba atogon anaf ukup ipeꞌipi wapani pegapoma. ");
INSERT INTO aoj_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Ipaꞌ pendaꞌ luwaguf ipeꞌifi bandef, a pewahoꞌ legw, eaꞌ pekata lambeh pendondombol silisilawi pepe. ");
INSERT INTO aoj_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Ipaꞌ pendape siꞌi epes sape sagasasa aman dembinai asasinai naꞌi nokwaha gwaꞌaisi luꞌwasi sandasoꞌamai notanima nogafiꞌi. Iꞌi nifiꞌi noha uta ipat ananitai, esis suwisiꞌmanota kwafalis. ");
INSERT INTO aoj_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Andeandeꞌma amom mandaꞌ maoli silisilawi mope mugati dembinai amamunai nifiꞌi notoloma sonogaham. Aeꞌ aꞌipipa endilisi, atiasi dembinai niliꞌ nowahoꞌ lowaf bandaf nowahoꞌ let, ama nondaꞌmam gwaꞌaisi. Eaꞌ niꞌipam motoma tebol anen nifiꞌi nogasoꞌama gwaꞌaisi. ");
INSERT INTO aoj_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Anen nifiꞌi amanota laꞌafitama aꞌa noloma awatagw guliꞌ gugatai, aꞌa nogota mamahotama, ma niti amom silisilawi mogapoma, sonoham. ");
INSERT INTO aoj_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","“Ipaꞌ ukup pepoma anif basef waminif atini. Iꞌi ahama ipati niliꞌ nogawa nogota nandaꞌ wali nogafiꞌatai ma silisilawi nogape, nandaꞌ wali ina atiasi nifiꞌi nupisila ipat ananitai nuwis nomon, owaꞌatin. ");
INSERT INTO aoj_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Ipaꞌ wapani silisilawi pendape. Deiꞌ main? Aeꞌ ataga epen egefaꞌ alop epesi, ifiꞌi anef nemaf ipaꞌ ina atiasi pegawa piꞌi ifiꞌi ulal nemaf afamba, owaꞌ.” ");
INSERT INTO aoj_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Eaꞌ Pita naꞌi, “Dembinai, basef ifimba waminif atini inaꞌ nasoꞌafaef afaꞌ atofa, aꞌa esis amam nematawa hiasi wapani?” ");
INSERT INTO aoj_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Eaꞌ Dembinai naꞌi, “Ipaꞌ hipai pendaꞌ waf buꞌwafi siꞌi anamba nugumafi amom mandaꞌ maoli okom buꞌwami mapaona nandaꞌ maol andeandeꞌ datimai. Aman anamba dembinai ananinai nandandepana ma nugumafi ananimi mandaꞌ maoli ma nogasoꞌama gwaꞌaisi amom nogota dondoꞌatai. ");
INSERT INTO aoj_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Anaf dembinai ananinai notanima nogafiꞌi ma niti aman anamba nandaꞌ maol andeandeꞌ, daoꞌ aman anamba sonohana. ");
INSERT INTO aoj_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Aeꞌ aꞌipipa endilisi, dembinai ananinai anaf nondandepana nope dambena nugumafi hiahaom hiami ananimi hiꞌigalam. ");
INSERT INTO aoj_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Apaꞌ iꞌi aman anamba okom magapoma opaf ananifi atof aꞌ niꞌi, ‘Dembinai aeꞌanai ina atiasi nifiꞌi ulal, owaꞌatin.’ Ama anen nosafel noha anis amam nematawa sandaꞌ maoli, nondaꞌ gwaꞌaisi embel da gwaꞌ nondaꞌ spak nogape. ");
INSERT INTO aoj_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Anen iꞌi nondaꞌas naꞌamba ma, Dembinai ananinai atiasi notanima nifiꞌi anef nemaf apaꞌ aman anamba ina atiasi niꞌi Dembinai nifiꞌi ulal, ataꞌ owaꞌ. Dembinai nogafiꞌi nifiꞌi nogota atamba anen okom mogasoꞌanatama. Nifiꞌi nohambombaga aman anamba endilisi, eaꞌ nondaꞌana nope noloma epes owaꞌ sohahapifa Godi sagapoma. ");
INSERT INTO aoj_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Epen mamahina nandaꞌ maola anini, anin negawa eaꞌ ma okom dembinai ananinai, apaꞌ anin owaꞌ nendondomba hiahawes nila nomonas dembinaiia, anaf dembinai nohan mehip aꞌowaꞌ. ");
INSERT INTO aoj_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Apaꞌ epen mamahina nandaꞌ maoli owaꞌ negawa okom dembinai ananinaia ma nendaꞌ waf fendahama afamba negefaꞌ akafimiafi, atiasi dembinai nohan saꞌombel. Eaꞌ epes mamahisa anis daias sogasoꞌasa hiahaom hiami sasoꞌas sugumafiami, anaf epes isimba siꞌipas sogwamasam wapani mikilaꞌ fowaꞌ saliꞌ sagasoꞌasami. ");
INSERT INTO aoj_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Aeꞌ afiꞌi ma egawahoꞌ nif itap apaꞌe eaꞌ aꞌi nif ifimba deiꞌ aꞌ fendandif luꞌuf. Owaꞌ, ataꞌ owaꞌ. ");
INSERT INTO aoj_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Eaꞌ aeꞌ okom maꞌi efaꞌ anin saꞌof. Deiꞌ aeꞌ owaꞌ ataꞌ efaꞌana, nembel aeꞌambili nimanimbil endilisi. ");
INSERT INTO aoj_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Ipaꞌ paꞌi aeꞌ afiꞌi ma igahagofa wandaf hiafi fogagaꞌ itap ama hiasi sogape opalef awanelef? Owaꞌatin. Aeꞌ aꞌipipa, aeꞌ afiꞌi ma egawala miniꞌap esis amam nematawa. ");
INSERT INTO aoj_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Ama deiꞌ, a anaf wapani epes wanis bias sogape ipat atotota wambota atototai asondatopaꞌ biefis. Wanis soloma bias sifitap eaꞌ bias sofala wanis siꞌi bousi eaꞌ naꞌamba atin. ");
INSERT INTO aoj_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Atiasi esis sondatopaꞌ, anona aman noloma ahamana ananinai mondatopaꞌ biafim, eaꞌ anoꞌw nemataꞌw koloma maꞌmaꞌw ondatopaꞌ biafiwa, eaꞌ mefiꞌmaꞌw akoꞌukwi koloma maꞌmaꞌw kwandagiꞌmoꞌwi ondatopaꞌ biafiwa. Esis atiasi sondatopaꞌ naꞌamba.” ");
INSERT INTO aoj_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Jisas naꞌipa esis amam nematawa wapani naꞌi, “Ipaꞌ pagati otaga gogatafi gani awin negewalama, kwafalis ipaꞌ pegawa paꞌi, ‘Asaf faꞌi afelai.’ Eaꞌ asaf afalai, endilisi. ");
INSERT INTO aoj_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Ipaꞌ pati fufin banagani nagafiꞌi awin nagatopaꞌima nagataga, ipaꞌ pegawa paꞌi, ‘Atiasi owaf aꞌ nuluwi banagona.’ Endilisi atis, faluwi banagef naꞌamba atin. ");
INSERT INTO aoj_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Ipaꞌ epes pagaꞌi malogof biagufi! Ipaꞌ pati ametal hiani ilifani itapani andeandeꞌ, apaꞌ deiꞌ ipaꞌ owaꞌ pegawa ametal nogota ataꞌili andeandeꞌa.” ");
INSERT INTO aoj_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Deiꞌ maina ipaꞌ owaꞌ pegegawa andeandeꞌma pegawaloga waf usiꞌifi? Endilisi, ipaꞌ pegawaf aꞌ pendawalogaf andeandeꞌ. ");
INSERT INTO aoj_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Afamba ipaꞌ pefeꞌ pegaloma epen inimba naꞌi nendakotimipai, ipaꞌ ataꞌ pefeꞌ pigail ufiaꞌw, nogota atamba atota penandona basef ifimba peloman. Naꞌamba anin aꞌ nendaꞌ ipaꞌ pepe pendaꞌ kot. Eaꞌ nandaꞌ koti nosoꞌama ipaꞌ pefeꞌma amom polisman aꞌ mondaꞌepa pendaꞌ kalabus. ");
INSERT INTO aoj_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Aeꞌ aꞌipipa, ipaꞌ ina atiasi pekwaha ipat atamba sandaꞌ kalabusatai ulal, owaꞌ. Ama pegwa hiahaom luꞌwami saꞌumi ma wiaf ipeꞌifi hiꞌilaf daoꞌ, a pefeꞌ.” ");
INSERT INTO aoj_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Nemaf afamba atef anis epes sape saꞌipa Jisasa anis epes Galilisii. Nogota atamba esis sape sondolali ma God sandaꞌ ofa atin, gavman dembinai Pailat nahas sagaꞌ. ");
INSERT INTO aoj_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Eaꞌ Jisas nagwamasa basef naꞌi, “Ipaꞌ ukup pandandaꞌmas paꞌi epes isimba Galilisi sagagaꞌi, asikilaꞌ anis epes Galiliisi daias sandaꞌ waf awafi, ama kofagema amamba atom deiꞌ sofaꞌ nimanimi sagaꞌ? Owaꞌatin. ");
INSERT INTO aoj_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Aeꞌ aꞌipipas usiꞌis. Owaꞌatin endilisi! Iꞌi ipaꞌ owaꞌ pembema nelelemba waf awafi ipeꞌifia, anaf ipaꞌ hipai pegaꞌ higililipa naꞌamba atin siꞌi esis. ");
INSERT INTO aoj_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Deiꞌ siꞌi maina anis epes isimba 18-pelais wambel Siloam ipat lautai tato tasindifasa afis hiꞌagalas, isimba ipaꞌ paꞌi waf awafi asasifi afikilaꞌ waf awafi isimba anis daias sagape Jerusalami? ");
INSERT INTO aoj_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Owaꞌatin. Ipaꞌ owaꞌ pembema nelelemba hiahaom awami ipeꞌimia, anaf ipaꞌ hipai apegaꞌ naꞌamba atin siꞌi esis. ");
INSERT INTO aoj_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Eaꞌ Jisas nawalapa anif basef waminif atini naꞌi, “Anona aman nawa anoga lawag fik aof ananifi nagawa waina, ama main nafiꞌi nowandoꞌma saꞌutipa lawag agamba, owaꞌ owaꞌatin. ");
INSERT INTO aoj_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Eaꞌ naꞌipa anen nandaꞌ maol aof afambai naꞌi, ‘Nemeꞌ. Afagof wanogof aeꞌ afiꞌi ilaoma saꞌutip lawag agamba fik, owaꞌ owaꞌatin. Naꞌamba deiꞌ inaꞌ laga. Deiꞌ maina gotawa gogofaꞌ ifat atota itap dowadowaf?’ ");
INSERT INTO aoj_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Eaꞌ anen nandaꞌ maol aofi nagwamana basef naꞌipana naꞌi, ‘Dembinai, inaꞌ ataꞌ kwahowaga gope afagol agaleꞌe atogol. Ama ataꞌ ilaꞌ itap peloma omba bulmakaum isimbeꞌaga. ");
INSERT INTO aoj_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Ama iti atiasi gil gola saꞌutip afagol agaleꞌe aꞌa owaꞌ, iꞌi owaꞌ, daoꞌ inaꞌ aꞌ nelaga.’” ");
INSERT INTO aoj_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Nemaf afamba sagapoma nomaꞌwafi Jisas naꞌipasa basef esis amam nematawa anota ipat Juda sandakolasatai nomon. ");
INSERT INTO aoj_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Eaꞌ anoꞌw nemataꞌw ambal aunai nagapauꞌwi kwape, ambal anamba aunai nasoꞌakw aowas akoꞌw nandaꞌaꞌw nape afagof 18-pelaiguf eaꞌ alafuga akwaꞌugai gondalaꞌakw, ina kosafel kwalutu andeandeꞌ, owaꞌatin. ");
INSERT INTO aoj_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Jisas natoloꞌw nofalaꞌw kwafiꞌi naꞌipaꞌw naꞌi, “Nemataꞌw, aeꞌ aꞌ atofa aowas ineꞌini eaꞌ nape wahifina.” ");
INSERT INTO aoj_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Anen nasa lagol ananigili nemataꞌw akwamba eaꞌ kwafalis atis kwalutu usiꞌikw. Eaꞌ kwasaꞌma agol Godi luꞌwagol. ");
INSERT INTO aoj_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Owaꞌ aman anamba dembinai nugumafi ipat lotuwi nembel wandafimbila Jisas nandaꞌaꞌw boꞌokw nemaf afamba sagapoma nomaꞌwafi. Eaꞌ anen naꞌipa esis amam nematawa naꞌi, “Nimaguf ifimba wanif wanif maolifi. Eaꞌ deiꞌ ipaꞌ piꞌi aman anamba notofamepa aowas ipeꞌini, andeandeꞌma pigafiꞌi nemaf maolifi. Apaꞌ ipaꞌ ina pifiꞌmai maol inimba ma nemaf magapoma nomaꞌwafi, owaꞌi.” ");
INSERT INTO aoj_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Eaꞌ Dembinai nagwamana basef naꞌi, “Ipaꞌ amam pagaꞌi malogof biagufi! Peme! Nemaf magapoma nomaꞌwafi ipaꞌ hipai pafeꞌ ifagw bulmakauwi ma pagatagwaha bulmakau maloma donki ipeꞌimi paoꞌwam mafeꞌ magaꞌ embel. ");
INSERT INTO aoj_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Apaꞌ nemataꞌw akwamba akoꞌw kwagataga ambep Abrahami, owaꞌ Satan aꞌ nahipaꞌw sisihiꞌw kwape afagof 18-pelaiguf. Eaꞌ deiꞌ nemaf afamba magapoma nomaꞌwafi aeꞌ aꞌi etagwaha mandof fogowaꞌaꞌwi ma kogape wahifiꞌw.” ");
INSERT INTO aoj_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Jisas naꞌias naꞌamba, nandaꞌ esis bousi ananisi ambagof aom kwapeteꞌ. Apaꞌ amam nematawa hiasi asonahas endilisi ma hiahaom buꞌwami banagami hiami anen nandaꞌami. ");
INSERT INTO aoj_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Eaꞌ Jisas naꞌias wapani naꞌi, “Epes sogawis nomona maol Godi nope Dembinai nugumafias siꞌi main? Aeꞌ indilaꞌwaifam iꞌimama? ");
INSERT INTO aoj_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Amamba siꞌi analef nalelef saꞌusaꞌulifi apaꞌ mofalas magaꞌi masteti. Anona aman nofaꞌ nalelef afalemba nawalef aof ananifi. Aꞌi owaꞌ main, mataga malo siꞌi lawah luꞌugahi eaꞌ amiguf fafiꞌi falaꞌ owah fatoma agufugaha.” ");
INSERT INTO aoj_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Eaꞌ Jisas naꞌias wapani naꞌi, “Aeꞌ aꞌi indilaꞌwaifa epes sogawis nomona maol Godi iꞌimama? ");
INSERT INTO aoj_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Aeꞌ indilaꞌwaifama, anis yis anoꞌw nemataꞌw kofaꞌas kwambemas saloma plaua hiami magala dram luꞌwamii. Aꞌi owaꞌ main, aꞌ matef luꞌum.” ");
INSERT INTO aoj_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Jisas nafeꞌ walemb hiagoma luꞌwagoma saꞌogoma bagape felefeleꞌma ufiaꞌw kwagafeꞌ Jerusalami nandaꞌ maol nawalipa esis amam nematawa, eaꞌ nafeꞌ okom maꞌi nefeꞌ Jerusalem eaꞌ nafeꞌ. ");
INSERT INTO aoj_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Owaꞌ anona aman naꞌipana naꞌi, “Dembinai, aeꞌ aꞌi ihaliꞌina ma epes isimba anaf God nofaꞌas sogotanimai. Isimba hiasi aꞌa kwaiaꞌwis?” Eaꞌ Jisas naꞌipas naꞌi, ");
INSERT INTO aoj_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Ipaꞌ pewaꞌ banaga bihitagof ipeꞌigufi banagagof endilisi, pefeꞌ pigawis uta saꞌusaꞌutai. Deiꞌ main, epes hiasi atiasi siꞌi suwis nomon, apaꞌ owaꞌ laꞌifisa. ");
INSERT INTO aoj_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Atiasi ahama ipati nosafel nowalowa uta ipat atamba. Eaꞌ ipaꞌ pifiꞌi pilutu peha uta andoꞌ falafala naꞌamba piꞌi, ‘Dembinai, usiꞌmapai uta.’ “Eaꞌ nogwai basefa ipaꞌ niꞌias niꞌi, ‘Ipaꞌ animaipai? Aeꞌ owaꞌ egawepaea.’ ");
INSERT INTO aoj_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Eaꞌ piꞌipana piꞌi, ‘Apaꞌ mape maꞌ gwaꞌaisi embel magalomena, nalutu nawalapa basef nagaꞌipapa walemb apeꞌilimbi.’ ");
INSERT INTO aoj_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Owaꞌ anen nogwa basef niꞌi, ‘Ipaꞌ animaipai? Aeꞌ owaꞌ egawepaea. Ipaꞌ pandaꞌ waf awafii, ipaꞌ hipai delefata hiꞌilipa pekwaha aeꞌ.’ ");
INSERT INTO aoj_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","“Anaf ipaꞌ piti Abrahami Aisak Jekop moloma profet amamba hiami hiꞌilam mope anamba God nagalaꞌambemagoma nomon, apaꞌ ipaꞌ owaꞌ. Ipaꞌ nogaloꞌmepa pepe andoꞌ. Anamba pelef pendaꞌ nalelef tilili talalaꞌ kwapeteꞌ pepe. ");
INSERT INTO aoj_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Eaꞌ esis amam nematawa sifiꞌi gani awin nagatafima nogowalama noloma anamba waꞌowaꞌol esis a sope seaꞌ gwaꞌaisi anamba God nagalaꞌambemagoma. ");
INSERT INTO aoj_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Ahoꞌ endilisi, anis epes deiꞌ sataga sagagiꞌi agof akasi, anaf aꞌ agof fotomas sotaga siliꞌ. Apaꞌ anis deiꞌ sataga sagaliꞌi agof fagatomasi anaf agof akas asotaga sigiꞌ.” ");
INSERT INTO aoj_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Nogota atamba atota anom amam Farisi mafiꞌmai Jisas maꞌipana maꞌi, “Inaꞌ nekwaha wambel ambaleꞌe foꞌo anagon. Deiꞌ main, Herot naꞌi nehena negaꞌ.” ");
INSERT INTO aoj_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Jisas naꞌipam naꞌi, “Ipaꞌ foꞌo piꞌipa aman anamba nandaꞌ uhufi siꞌi nombat aluputai piꞌipana piꞌi, ‘Deiꞌ a naman wapani aeꞌ ambagof amamba awami magape epesi, eaꞌ endaꞌ esis epes awasisi boꞌwes. Iꞌi owaꞌ nemaf fegafeꞌma wanifi hiꞌilaf, imbifa maol aeꞌani hiꞌilan.’ Ipaꞌ pigaꞌipana naꞌamba. ");
INSERT INTO aoj_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Apaꞌ deiꞌ naman bimb aeꞌ efeꞌ endaꞌ maol inimba. Ina andeandeꞌma esis soha anona profet nogagaꞌ anambel wambel daiambel, owaꞌatin. Sohana nogaꞌ Jerusalem atogon. ");
INSERT INTO aoj_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“O ipaꞌ Jerusalem, Jerusalem, ipaꞌ pagaha amom profet afumi, pakwaha otamba pagaha amom God nasapaꞌam magafeꞌma ipeꞌi, lifilafi aeꞌ aꞌi ekolasa ipaꞌ epes hipai siꞌi awata numaꞌitai towaꞌani nogagwi takolasagw gopasol gwagail bihinagof atatigufi. Owaꞌ owaꞌatin, ipaꞌ pandaiwaꞌ. ");
INSERT INTO aoj_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Ipaꞌ pemeꞌ! Deiꞌ ipat buꞌutai a wambel ipeꞌimbili atiasi wafita totawa dowaf. Aeꞌ aꞌipipa, ipaꞌ ina atiasi petolowe wapani ma anaf pigaꞌi, ‘Apaꞌ maꞌi God nofaloꞌma aman anamba nagafiꞌi agol Dembinaii ma nogasoꞌana banagami ananimi.’” ");
INSERT INTO aoj_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Anef nemaf esis Juda sagapoma nomaꞌwafi Jisas nafeꞌ naloma anona aman Farisi naꞌ gwaꞌaisi ipat ananitai. Eaꞌ esis sandaꞌana naep diꞌindiꞌana endilisi. ");
INSERT INTO aoj_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Anona aman lagufi boꞌwagah sagalotawana kwapeteꞌi nape Jisas nogohnaepinama. ");
INSERT INTO aoj_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Eaꞌ Jisas nati aman anamba, nahaliꞌ amom dembami magawalipasa muꞌuli Godi maloma amom Farisi naꞌi, “Aꞌi afaꞌ ondaꞌ aman aowas nandaꞌanai boꞌona nemaf afamba magapoma nomaꞌwafi, aꞌa owaꞌ?” ");
INSERT INTO aoj_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Owaꞌ amom masopama malogof. Eaꞌ nofaꞌ aman anamba nandaꞌana boꞌona nasapaꞌana nafeꞌ. ");
INSERT INTO aoj_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Eaꞌ Jisas nahaliꞌam naꞌi, “Iꞌi anona aman ipeꞌinai awani ananini aꞌa anona bulmakau ananisi sogowala hul embelili nemaf afamba sagapoma nomaꞌwafi, aꞌi aman anamba ahama isimbai nefeꞌ nigiasi kwafalis nemaf afamba aꞌa owaꞌ? Endilisi, nefeꞌ nigagiasii.” ");
INSERT INTO aoj_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Eaꞌ amom ina laꞌifima mogogwa basef ifimba, owaꞌatin. ");
INSERT INTO aoj_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Jisas nati esis safiꞌmai gwaꞌaisi isimba saꞌi sope siaifah buꞌwasi satawa sagaliꞌi boꞌwagoma atogini. Eaꞌ naꞌipasa basef waminif atin naꞌi, ");
INSERT INTO aoj_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Iꞌi anona aman nogofalepama anis gwaꞌaisi luꞌwasi sondaꞌasa aman nogasoꞌ nemataꞌwi ma pegafeꞌ, ipaꞌ owaꞌi pefeꞌ petoma piliꞌ siaifah fasisi amom dembami atom magatomasia, owaꞌi. Naꞌamba aman anamba nofoꞌo nofalai anona aman agol luꞌwagilinai gikilaꞌ agol ineꞌigili. ");
INSERT INTO aoj_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Ama aman anamba nofalena nifiꞌi niꞌipina niꞌi, ‘Inaꞌ kwahomana sia inimba buꞌwani aman anaꞌe.’ Nondaꞌas naꞌamba, inaꞌ ambal aona aꞌowaꞌ. Eaꞌ nondaꞌena nefeꞌ nepe nigiꞌi endilisi alafugah. ");
INSERT INTO aoj_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Apaꞌ iꞌi anona aman nogofala inaꞌ nefeꞌ nelomana negaꞌ gwaꞌaisi, inaꞌ nefeꞌ nepe nigiꞌi alafugah endilisi. Inaꞌ nendaꞌas naꞌamba ma atiasi nofalena nigaꞌi, ‘Alipunai, inaꞌ nifiꞌi nepe niliꞌ boꞌogoma!’ Anen nondaꞌas naꞌamba, daoꞌ atiasi nefaꞌ agol luꞌwagili ma naep epes isimba hiasi saꞌ gwaꞌaisi sagalominai. ");
INSERT INTO aoj_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Deiꞌ main, epen mamahina negasaꞌma agol ananigili atigili, God nondaꞌan nisilaꞌ. Apaꞌ epen mamahina nendaꞌ agol ananigili gigisilaꞌi, anaf God nosaꞌma agola anin.” ");
INSERT INTO aoj_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Eaꞌ Jisas naꞌipa aman anamba nagafeꞌma gwaꞌaisi isimbai nahaliꞌana naꞌi, “Iꞌi inaꞌ nendaꞌ anis gwaꞌaisi luꞌwasi aꞌa saꞌusi, inaꞌ owaꞌi nefala alipisi soloma sahin owan wambota ineꞌisi a inaꞌ wambel atembel hiahaom hiamisi, owaꞌi. Iꞌi nendaꞌas naꞌamba, anef esis sogofalena ma nefeꞌ neaꞌ gwaꞌaisi ifagw asasigwi, eaꞌ sogwamena gwaꞌaisi ineꞌisi. Owaꞌ. ");
INSERT INTO aoj_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Inaꞌ iꞌi nendaꞌ gwaꞌaisi luꞌwasi, nefala isimba awapisi kwahusa hiahaomi, boꞌwagah aogahisi naep pagasoꞌasi. ");
INSERT INTO aoj_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Epes isimba ina laꞌifisa sogogwamena gwaꞌaisi inaꞌ, owaꞌ. Iꞌi inaꞌ nendaꞌas naꞌamba, nendagala nepe andeandeꞌ. Eaꞌ anaf God nogwamena hiahawes isimba buꞌwasi ma nemaf afamba epes isimba sandaꞌ waf buꞌwafi sagagaꞌi sogosafel wapani.” ");
INSERT INTO aoj_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Anona aman asasinai nagape laꞌafena esis saꞌ gwaꞌaisi sagalomanai nameꞌ basef ifimba, naꞌipa Jisas naꞌi, “Epen ami nepe negaꞌ gwaꞌaisi luꞌwasi anamba God nagalaꞌambemagomai, anin sowenondahan.” ");
INSERT INTO aoj_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Eaꞌ Jisas naꞌipana basef waminif atin naꞌi, “Anona aman naꞌi nondaꞌ anis gwaꞌaisi luꞌwasi. Eaꞌ nofalai epes hiasi safiꞌmai gwaꞌaisi isimba. ");
INSERT INTO aoj_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Nemaf dondoꞌafi endilisi ma gwaꞌaisi isimba fataga, eaꞌ nasapaꞌ anona nandaꞌ maola anini nafeꞌ naꞌipa epes isimba fowaꞌ nogofalasi. Eaꞌ naꞌipas naꞌi, ‘Ipaꞌ fiꞌi. Hiahaom hiami mandandombol mape eaꞌ.’ ");
INSERT INTO aoj_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","“Owaꞌ epes isimba hiasi atona atin sosafel saꞌi basef saꞌi esis ina sofeꞌ, owaꞌ. Anona aman naꞌipana naꞌi, ‘Aeꞌ andaiwaꞌma egafoꞌo. Ataꞌ efeꞌ itipaꞌma aof aeꞌafi.’ ");
INSERT INTO aoj_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","“Eaꞌ anona naꞌipana naꞌi, ‘Aeꞌ atala bulmakau ilifunamaima mondaꞌ maol mogawala itap, eaꞌ deiꞌ efeꞌ egwambam endondomam. Eaꞌ aeꞌ ina efoꞌo.’ ");
INSERT INTO aoj_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","“Owaꞌ anona daiana naꞌi, ‘Deiꞌ atef aeꞌ asoꞌ nemataꞌw. Naꞌamba aeꞌ ina efoꞌo, owaꞌ.’ ");
INSERT INTO aoj_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Aman anamba nandaꞌ maola anini notanima nafeꞌ naꞌipa dembinai ananinai ma isimba. Eaꞌ anen ahama ipati nembel wandafuna eaꞌ naꞌipa nandaꞌmana maol ananinii naꞌi, ‘Inaꞌ kwafalis foꞌo ufiawa hiawai luꞌuwama saoꞌwama ma taun inimba eaꞌ nefaꞌai isimba falafalafisi, lagof awagufi, alop awasipisi, naep pagasoꞌasi, boꞌwagah aogahisi inaꞌ neꞌwasi sifiꞌi suwisi nomon ipat aeꞌatai.’ ");
INSERT INTO aoj_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","“Aꞌi owaꞌ main, aman anamba nandaꞌ maoli naꞌi, ‘Dembinai, aeꞌ aila basef ineꞌifi eaꞌ, apaꞌ owaꞌ ati ipat ina deiꞌ siꞌita, ataꞌ owaꞌ. Anis siaifah ataꞌ wafis sotawa dowaf. Ipat ina deiꞌ siꞌita, ataꞌ owaꞌ.’ ");
INSERT INTO aoj_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","“Eaꞌ dembinai naꞌipana naꞌi, ‘Inaꞌ foꞌo ufiawa hiawai luꞌuwama nila indalelemb nefeꞌ aofah eaꞌ nehendeꞌai esis amam nematawa sifiꞌi suwisi nomon ipat aeꞌatai ma siꞌita. ");
INSERT INTO aoj_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Aeꞌ aꞌipina endilisi, epes isimba hiasi fowaꞌ aeꞌ egefalasi, esis owaꞌatin endilisi ma sogofaꞌ gwaꞌaisi aeꞌasia.’” ");
INSERT INTO aoj_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Miniꞌap laupi amam nematawa safiꞌi saloma Jisas, eaꞌ nandambema naꞌipas naꞌi, ");
INSERT INTO aoj_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Epen ami nifiꞌmai aeꞌ, ma anin owaꞌ nesambala mamasan wauluꞌman batawis ananisi soloma sahin owan wambota ananisi, eaꞌ ambal ananili wapani, anin ina atiasi nepe banagen miniꞌap aeꞌapi nepe alipini aeꞌani, owaꞌ. ");
INSERT INTO aoj_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Aeꞌ efaꞌ akafimi andaꞌ maol Godi sehe egaꞌ lawag usiꞌigai tiꞌwanaegai. Epen ami owaꞌ nendaꞌas naꞌamba atin siꞌi aeꞌ ma nigailima, epen inimba ina laꞌifin netaga alipini aeꞌani, owaꞌatin. ");
INSERT INTO aoj_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Anin epen ipeꞌini iꞌi nendaꞌ anota ipat luꞌutai togalota ilif, anin nendaꞌas niꞌimama? Anin ataꞌ nope nomonas talambi niliꞌ ma negawa andeandeꞌ otamba ambamba ipatimbai. Atiasi otamba ananimbai bendahama ipat atamba hiꞌigalata aꞌa owaꞌ? ");
INSERT INTO aoj_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Apaꞌ iꞌi owaꞌatina nendaꞌ isimbai sogaliꞌa, ma niliꞌ nondaꞌ simen atina owaꞌ nondaꞌ ipat atamba hiꞌilataea. Atiasi epes hiasi sagatolotai siꞌi basef sondaꞌiꞌipama aman anamba sondaꞌ findiwana ");
INSERT INTO aoj_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","siꞌias siꞌi, ‘Epen inimba nasefela ipat atamba, apaꞌ anin owaꞌ laꞌifin nimbifataea.’ ");
INSERT INTO aoj_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Anif basef daif wapani ifimba. Iꞌi anona aman dembinai king niꞌi nofeꞌ nopaꞌ nogaloma anona king daiana, anen ataꞌ nope okom mondandaꞌmas andeandeꞌ. Soldia ananimi misiꞌah ilifunamaih dowaf, apaꞌ king anamba nagagiꞌi anen nifiꞌi noloma soldia ananimi misiꞌah 20-pelaih hiami. Eaꞌ king anamba nagaliꞌi naꞌi ataꞌ niliꞌ nogawa naꞌamba. Anen atiasi nopaꞌ nogaloma king anamba nagagiꞌi laꞌifinama nogaliꞌamonas aꞌa owaꞌ? ");
INSERT INTO aoj_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Anen nondaꞌas naꞌamba ma nogogawa anen ina laꞌifina, daoꞌ boumi ananimi ataꞌ mili laogon, aꞌ niliꞌ nosapaꞌ anom amam mofeꞌma anen mofalana mondaꞌipama basef miꞌi wandaf hapaifi. ");
INSERT INTO aoj_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Eaꞌ ipaꞌ naꞌamba atin. Ipaꞌ epen ami owaꞌatina negewaꞌ alafuga ma hiahawes ananisi ma negesambalisa, anin ina atiasi laꞌifina negape alipini miniꞌap aeꞌapi, owaꞌatin. ");
INSERT INTO aoj_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Ipaꞌ pegawa sol alol fasili. Apaꞌ iꞌi sol alamba aꞌ lumbula usihila aꞌ akal, owaꞌatin. Atiasi ipaꞌ pendaꞌal piꞌimama usihil wapani? Owaꞌatin. ");
INSERT INTO aoj_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Sol alamba ina andeandeꞌ boꞌola apaꞌ mondaꞌal aofah, aꞌa mokwahol logaloma omba bulmakaum, owaꞌatin. Apaꞌ melefatam mokwahom atin. Epen ami aligah hagalina nagameꞌ basefi, anin aꞌ nindailif.” ");
INSERT INTO aoj_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Epes hiasi saloma anom amam mandaꞌ waf awafi mogofaꞌ takisi saloma anis epes sandaꞌ waf awafii safiꞌi felefeleꞌma Jisas sameꞌ basefa ananifi. ");
INSERT INTO aoj_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Eaꞌ anom dembami Farisi maloma amom dembami magawalipasa muꞌuli Godi mandaꞌ megahahama anen maꞌi, “Aman anamba nandaloma epes isimba sandaꞌ waf awafii nofalas alipisi nalomas nandaꞌ gwaꞌaisi.” ");
INSERT INTO aoj_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Owaꞌ Jisas nasoꞌama basef ifimba waminif atin naꞌipam naꞌi, ");
INSERT INTO aoj_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Iꞌi anona aman ipeꞌinai numafi anop sipsip 100-pelaip ama anop atotop higililap, aman anamba ataꞌ nokwaha sipsip apamba 99-pelaip pulutu peaꞌ gwaꞌaisi anagon, anen ataꞌ nefeꞌ nolaꞌ nolaoma anona higilagalanai. Nolaomana nafeꞌ nafeꞌ natolona nasaꞌmana ");
INSERT INTO aoj_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","nowandefana ikaf ananifi, sonahanamana nofaꞌana nafiꞌi. ");
INSERT INTO aoj_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Nafiꞌi nataga ipat ananitai, nofalai esis alipisi ananisi saloma esis anen wambel atembel sandakolas atogon. Eaꞌ naꞌipas naꞌi, ‘Ipaꞌ pendagala peloma aeꞌ! Anona sipsip aeꞌanai higilalana, owaꞌ aeꞌ afaꞌ elaomana itanima ifaꞌanai eaꞌ.’” ");
INSERT INTO aoj_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Deiꞌ Jisas naꞌipas naꞌi, “Aeꞌ aꞌipipa eaꞌ naꞌamba atina esis amam nematawa sagape heveni sandagala kwasakwasala ma epes isimba 99-pelais amboꞌwes, ina sandaꞌ waf awafi ma sotanima sogambema nelelemb, owaꞌ. Apaꞌ iꞌi anin epen nendaꞌ waf awafii niꞌi negambema nembel, atiasi esis sagape heveni sondagala aꞌowaꞌ ma anin. ");
INSERT INTO aoj_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Iꞌi anoꞌw nemataꞌw anin moni ilifunamain siliva anin atitin higiligalan, atiasi kondaꞌ maina kolaoman kogatilin? Akoꞌw kokata lam kombehagon ipat nomon kolaoman andeandeꞌ hiꞌilagon kofeꞌ kofeꞌ ma kogatilin. ");
INSERT INTO aoj_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Akoꞌw kwatilin eaꞌ, kofala esis alipisi wambel akwaꞌumbili sondakolasi eaꞌ kwiꞌipas kwiꞌi, ‘Ipaꞌ pendagala peloma aeꞌ! Anin moni aeꞌani higilalan, owaꞌ deiꞌ elaoman afeꞌ atilin itanima ifaꞌani eaꞌ.’ ");
INSERT INTO aoj_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Deiꞌ aeꞌ aꞌipipa eaꞌ naꞌamba atin siꞌi amom ensel Godi sonogahama anin epen nandaꞌ waf awafii nembema nembel negafeꞌma God.” ");
INSERT INTO aoj_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Eaꞌ Jisas naꞌipam wapani naꞌi, “Anona aman nogaopana biam. ");
INSERT INTO aoj_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Aonama nafeꞌ naꞌipa ahamana ananinai naꞌi, ‘Ahame, aeꞌ okom mapoma otamba mais hiahawes afaꞌ ogafaꞌasi ma nemaf inaꞌ negagaꞌ. Deiꞌ aeꞌ aꞌi efaꞌ duꞌwanis aeꞌasi. Inaꞌ niwalis biafis newalogamafas afaꞌ biafa. Aeꞌ aꞌi inaꞌ neseꞌeas deiꞌ.’ Eaꞌ ahamam nawaloga hiahawes hiasi ananisi safeꞌma amom nogaopana biam. ");
INSERT INTO aoj_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","“Eaꞌ aꞌi owaꞌ main, ina ataꞌ nogota laota aonama nakolasa hiahawes hiasi ananisi nafeꞌ napani anambel wambel lauguni eaꞌ nalalamona hiahaom hiami ananimi ma waf naninani aunai anen nagiꞌma okom ananimi maꞌiama nandaꞌami. Eaꞌ otamba ananimbai hiꞌalamba ma waf awafi. ");
INSERT INTO aoj_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Anen nandaꞌ otamba ananimbai ma hiꞌalamba, aꞌi owaꞌ main, nogota nolom luꞌunai nagahasatama nataga itap apamba hiagoma hiꞌalagon. Eaꞌ anen hiahawes akana nape wahifina. ");
INSERT INTO aoj_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Anen nafeꞌ nandaꞌ maola anona aman itap apambainai. Aman anamba nasapaꞌana nafeꞌ itap ananipi ma nugumafi bogof ananigufi. ");
INSERT INTO aoj_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Bogof afamba faꞌ saꞌutip lawahip, eaꞌ anen wapani naꞌi neaꞌ saꞌutip ipimba ma opaf ananifi. Anen ina anis sasoꞌana gwaꞌaisi, owaꞌ. ");
INSERT INTO aoj_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Aꞌi owaꞌ main, okom ananimi mogawa andeandeꞌ eaꞌ naꞌias naꞌi, ‘Amam hiami mandaꞌ maola ahame aeꞌanai amom gwaꞌaisi hiasi aꞌowaꞌ. Apaꞌ aeꞌ ape naꞌaꞌe ameꞌaga endilisi ma nolomagahe. ");
INSERT INTO aoj_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Hapaimi, aeꞌ atiasi esafel efeꞌma ahame aeꞌanai. Eaꞌ iꞌipana iꞌi, “Ahame, aeꞌ andaꞌ waf awafi ma God inaꞌ wapani. ");
INSERT INTO aoj_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Deiꞌ aeꞌ ina aman buꞌuwai ma inaꞌ negefala aeꞌ nogamena ineꞌiwai, owaꞌ. Inaꞌ nendaꞌe epe siꞌi anona nandaꞌmena maoli.”’ ");
INSERT INTO aoj_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","“Eaꞌ nosafel nafeꞌma ahamana. Owaꞌ anen ataꞌ naili laogon ahamana natolona, nomonas saisailana nasagih nafeꞌ nahapila nogamana ananinai nombaloꞌana nasisiꞌ malogol ananigili. ");
INSERT INTO aoj_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Eaꞌ nogamana naꞌipana naꞌi, ‘Ahame, aeꞌ eaꞌ andaꞌ waf awafi ma God inaꞌ wapani. Aeꞌ ina ataꞌ aman buꞌuwai ma inaꞌ negefala aeꞌ nigaꞌi nogamena ineꞌiwai, owaꞌatin.’ ");
INSERT INTO aoj_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","“Owaꞌ ahamana naꞌipa amom mandaꞌ maola anini naꞌi, ‘Ipaꞌ faꞌai lowaf fasifi laufi namifi aeꞌafi pefaꞌaf pifiꞌi ulal pewahoꞌmanaf anen. Eaꞌ pelamana anin ring faf ananifi, pelamana su boꞌwagah ananigahi. ");
INSERT INTO aoj_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Faꞌai bulmakau noganai anamba luꞌunai gigititiꞌi pehana ma apaꞌ meaꞌana mondagalamana. ");
INSERT INTO aoj_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Deiꞌ main, nogame anamba aeꞌanai dolomana siꞌi nagagaꞌ eaꞌi, owaꞌ deiꞌ ambal lapaona wapani. Anen higilalana eaꞌ, apaꞌ deiꞌ owaꞌ matolona wapani.’ Eaꞌ esis sandagala. ");
INSERT INTO aoj_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Apaꞌ nogamana ananinai dembinai naili aof. Ama main, anen nafiꞌi nataga felefeleꞌma ipat, owaꞌ nameꞌ amalemba sandaꞌ musik sagalemb. ");
INSERT INTO aoj_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","“Eaꞌ nofala anona nandaꞌ maoli nahaliꞌana naꞌi, ‘Esis sandaꞌ main?’ ");
INSERT INTO aoj_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","“Eaꞌ anen nandaꞌ maoli naꞌipana naꞌi, ‘Owamena ineꞌinai notanima nafiꞌi, eaꞌ ahamena ineꞌinai nandagalamana, naꞌamba deiꞌ naha anona bulmakau luꞌunai. Deiꞌ main, anen notanimai ina ataꞌ nape aona, owaꞌ. Nape andeandeꞌ.’ ");
INSERT INTO aoj_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","“Owaꞌ nogamana ananinai dembinai okom numbutim eaꞌ nandaiwaꞌma nogawis nomon. Eaꞌ ahamana nawisi andoꞌ naꞌipana dindina nogawis nomon, apaꞌ owaꞌ. ");
INSERT INTO aoj_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Anen nagwamana basef ahamana naꞌi, ‘Afagof hiagufi aeꞌ ahapila maol ineꞌini siꞌi agol ake andaꞌ maol dowafi. Aeꞌ ina esambala basef muꞌuli ineꞌini anef atetef, owaꞌ. Apaꞌ inaꞌ owaꞌ neseꞌe anin mae saꞌwini dowaf siꞌi meme nogani ma endagala eloma alipisi aeꞌasia, owaꞌatin. ");
INSERT INTO aoj_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Apaꞌ awani anamba ineꞌinai anen nalalamona hiahaom hiami ineꞌimi eaꞌ ma awo nematawa gembaiwai. Eaꞌ deiꞌ notanimai, inaꞌ okom mapomana deiꞌ nahamana bulmakau anamba anen.’ ");
INSERT INTO aoj_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","“Eaꞌ ahamana naꞌipana naꞌi, ‘Nogame, dondol lifilafi afaꞌ biafa wagape atogini. Eaꞌ hiahawes aeꞌasi isimba ineꞌisi atis. ");
INSERT INTO aoj_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Apaꞌ deiꞌ afaꞌ ondagala, eaꞌ nelelemb afaꞌilimbi boꞌwalemb. Deiꞌ main, owamena anamba ineꞌinai fowaꞌ nafeꞌ lauguni siꞌi nagagaꞌi, owaꞌ deiꞌ nafiꞌi nataga ambal lapaona wapani. Anen higilagalanai, owaꞌ deiꞌ afaꞌ watolona wapani.’” ");
INSERT INTO aoj_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Jisas naꞌipa alipumi ananimi naꞌi, “Anona aman hiahaom hiamunai naoꞌwa anona ananinai nugumafi maol ananinii nape. Eaꞌ anis safiꞌmai aman anamba hiahaom hiamunai sasapaga anen nandaꞌmana maoli ma basef saꞌi, ‘Nugumafi maol ineꞌinii anen nakwaha otamba hiambai ineꞌimbai bafeꞌ dowaf.’ ");
INSERT INTO aoj_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","“Eaꞌ nofala aman anamba nugumafi maoli nafiꞌi naꞌipana naꞌi, ‘Deiꞌ maina basef ifimba aeꞌ agameꞌasefa ineꞌi? Inaꞌ nefeꞌ niamba hiahawes aeꞌasi sagape lagol ineꞌigili newalapas. Ina ataꞌ nepe nimafi maol aeꞌani wapani, aꞌowaꞌ.’ ");
INSERT INTO aoj_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","“Eaꞌ nugumafi maoli nomonas salasafeꞌ ma nembel ananimbili naꞌi, ‘Aeꞌ atiasi ataꞌ endaꞌas iꞌimama? Dembinai naꞌi niliꞌamone ma epe igimafi maol deiꞌ. Aeꞌ ina laꞌifiwi ma egawala itap. Eaꞌ ambal aola indaila anis epesa gwaꞌaisi mais. ");
INSERT INTO aoj_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Owaꞌ aeꞌ nomonas sandandaꞌma anis hiahawes eaꞌ ma endaꞌasa atiasi epes sofaꞌe efeꞌ ifagw asasigwi ma nemaf afamba dembinai nigaliꞌamone ma maol inimba deiꞌ andaꞌani.’ ");
INSERT INTO aoj_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","“Eaꞌ nofala amom hiami atona atin wialef figataomami mafiꞌmai anen. Anona aman naliꞌ nafiꞌmanai nahaliꞌana naꞌi, ‘Inaꞌ wialef maꞌulif fapoma dembinai aeꞌanai?’ ");
INSERT INTO aoj_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","“Eaꞌ anen naꞌi, ‘Darep wel luꞌwapi 100-pelaip.’ Eaꞌ naꞌipana naꞌi, ‘Inaꞌ kwafalis nepe niti tiketa wiaf nendaꞌ amefa darep 50-pelaip atip fil.’ ");
INSERT INTO aoj_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Ama main, anona nataga nahaliꞌana naꞌi, ‘Wialef ineꞌimi maꞌufim?’ “Anen naꞌi, ‘Begah witigah 100-pelaigah.’ “Eaꞌ naꞌipana naꞌi, ‘Inaꞌ nefaꞌ tiket atamba wiaf ineꞌifi fagailatai eaꞌ nendaꞌ 80-pelaigah.’ ");
INSERT INTO aoj_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Eaꞌ aman dembinai nasaꞌma agola aman anamba aunai nugumafi maoli. Deiꞌ main, anen nandaꞌ waf gawaifi siꞌi aman nomonas sagapaunai. Epes ukup asasipi pagapagaila hiahawes mais sagape itap apaꞌii esis sandaꞌ maola waf gawaifi siꞌi epes nomonas sagapaisi sikilaꞌ epes sagape nogogalaꞌmai owaꞌ sogogawa andeandeꞌia.” ");
INSERT INTO aoj_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Eaꞌ Jisas naꞌi, “Aeꞌ aꞌipipa ma moni uga maim magaꞌoh itap apaꞌii, ipaꞌ pendaꞌ anis amam nematawa sotaga alipisi ipeꞌisi. Ama main, iꞌi nemaf esis sogahapila uga moniafi hiꞌigalaf, daoꞌ atiasi God niꞌi ahoꞌma nofaꞌepa pefeꞌ ifagw pegape andeandeꞌ lifilafiagwi. ");
INSERT INTO aoj_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Ami nimafi hiahawes saꞌwisi andeandeꞌ datima, anaf nimafi hiahawes luꞌwasi andeandeꞌ wapani. Apaꞌ epen ami nembasoꞌam, owaꞌ nendaꞌ maol andeandeꞌma hiahawes saꞌwisaꞌwisia, anaf anin ina nendaꞌ hiahawes luꞌwasi andeandeꞌ wapani, owaꞌatin. ");
INSERT INTO aoj_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Ipaꞌ iꞌi owaꞌ pimafi moni uga maim magape itap apaꞌea, anaf ami neseꞌepa hiahawes buꞌwasi endilisi pigimafias? Owaꞌatin endilisi. ");
INSERT INTO aoj_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Ipaꞌ iꞌi owaꞌ pimafi hiahawes anis epesia, ami neseꞌepa hiahawes ipeꞌisi atis pimafias? Owaꞌatin. ");
INSERT INTO aoj_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Ina anin epen nandaꞌ maoli laꞌifin nihapila maol biafina amam dembami biam, owaꞌatin. Naꞌamba okom mila anona, anona aꞌ nesambalona. Eaꞌ naꞌamba atin ipaꞌ ina aꞌ laꞌifipa pepe lafela God noloma ugai moni wapani, owaꞌ.” ");
INSERT INTO aoj_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Ama amom Farisi magameꞌ basef ifimba hiafi Jisas nagaꞌiefi, amom mandaꞌmana waꞌap anen. Deiꞌ main, amom ukup pagapagaila moni atini. ");
INSERT INTO aoj_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Owaꞌ anen naꞌipam naꞌi, “Ipaꞌ pandaꞌ ipaꞌ patagama epes sandaꞌ waf usiꞌifi ma nogohnaep epesi. Apaꞌ God nogawa ukup ipeꞌimi nomon. Hiahaom epes sagasaꞌma agofami sagatalom otamba hiambaii, amamba falafumi atoma naep Godi. ");
INSERT INTO aoj_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Basef amom profet magawalipasafi basefa fagail muꞌuli God nagasoꞌ Mosesani ifimba amom mawalipasef atapif fape mafiꞌi metambel nogota Jon nagatagatai. Apaꞌ nogota atamba Joni tafiꞌi tataga deiꞌ basef fasifi ma epes sogawis nomona maol Godi nope Dembinai nugumafias, ifimba fape fafeꞌ fataga walemb hiagoma. Eaꞌ epes hiasi hiꞌalas dindinapis sandaꞌ maol luꞌwani aꞌowaꞌ ma sofeꞌ sogawis nomona maol inimba Godi. ");
INSERT INTO aoj_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Anif basef duꞌwanifa amef saꞌusaꞌufi feloma anif basef bandafi fagail nomona buk muꞌuli Godi ina anaf fefeꞌ higililif lamonef hiꞌilif, owaꞌatin. Fepe atapif fikilaꞌ itapi otaga anaf higiligalasi. ");
INSERT INTO aoj_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Aman ami nagakwaha wauluꞌmana ananiꞌwi ma nogasoꞌ anoꞌw daiaꞌw wapanii, anen nandaꞌ soꞌa waola nemataꞌw akwamba naliꞌ nagasoꞌakwi. Eaꞌ aman ami nasoꞌ anoꞌw nemataꞌw fowaꞌ anona aman nagaliꞌamonaꞌwi aman anamba nagiꞌ nagasoꞌakwi wapani nandaꞌ waf awafi soꞌa waola nemataꞌw akwamba. ");
INSERT INTO aoj_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“Anona aman hiahaom hiamunai nape. Dondol anen nala siaogw fasifasigwi atogw a luwaguf buꞌwafi sagatalif otamba hiambaii. Eaꞌ nimaguf hiafi dondol nondofaꞌ gwaꞌaisi buꞌwasi atis nandape andeandeꞌ aꞌowaꞌ. ");
INSERT INTO aoj_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Apaꞌ felefeleꞌma ipat ananitai anona aman kwahunai nandailasa gwaꞌaisi moni maisi nape, agilinama Lasarus. Alop ananipi siꞌipa ilambeh. ");
INSERT INTO aoj_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Anis epes sofaꞌana safiꞌi naꞌoh felefeleꞌma ipat aman anambai. Anen naꞌi notatama gwaꞌaisi duꞌwaꞌwanisi sowa sagaꞌoh tebol lafelena aman anamba hiahaom hiamunai ma ataꞌ neaꞌas nogasoꞌ opaf. Eaꞌ anogw nombagw gwafiꞌi gwapaloꞌmana ilambeh ananimi afegah agwagugahi. ");
INSERT INTO aoj_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Aꞌi owaꞌ main, aman anamba falafunai nagaꞌ, eaꞌ anom ensel mofaꞌana mafeꞌ mahaponana nape wambel buꞌwambili felefeleꞌma Abraham. Eaꞌ aman anamba hiahaom hiamunai anen wapani nagaꞌ, sawana. ");
INSERT INTO aoj_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Owaꞌ nafeꞌ wambel awambili hel nofaꞌ akef luꞌwami. Eaꞌ natologon nafeꞌ ilif, nati Abraham napani laogon aꞌowaꞌ, Lasarus nape nalomana. ");
INSERT INTO aoj_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Eaꞌ nofalana naꞌi, ‘Ahame Abraham, inaꞌ niti uwahipiwi nesapaꞌ Lasarus nufiꞌi nola faf ananifi duꞌwanif embel nupihiꞌmi afega aeꞌagai kwasakwasala. Aeꞌ ameꞌ akafimi awami endilisi ma nif ifiꞌi.’ ");
INSERT INTO aoj_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“Owaꞌ Abraham naꞌipana naꞌi, ‘Nogame, inaꞌ okom mondandaꞌma fowaꞌ ataꞌ nagape namina itap nefaꞌ hiahaom fasimi atom. Apaꞌ Lasarus nofaꞌ hiahaom hiami awami. Owaꞌ deiꞌ wambel ambaleꞌe nembel ananimbili bape fasimbil, apaꞌ inaꞌ nefaꞌ akafimi awami. ");
INSERT INTO aoj_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Eaꞌ anis maefah wapani sape. Laꞌafena apaꞌ maloma ipaꞌ God nandaꞌ anona kwambiwag luꞌunai. Naꞌamba epes sagape naꞌai ma saꞌi sotopaꞌ kwambiwag anamba sogafoꞌo ma ipaꞌ, esis ina laꞌifis. Eaꞌ epes sagapani naꞌambai, esis ina laꞌifisa sotopaꞌi kwambiwag sigafiꞌmai apaꞌ, owaꞌatin.’ ");
INSERT INTO aoj_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“Eaꞌ aman anamba naꞌi, ‘Ahame daoꞌ. Aeꞌ aꞌi inaꞌ nesapaꞌo Lasarus notanima nofoꞌo ipat ahame aeꞌanai. ");
INSERT INTO aoj_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Aeꞌ anom owape wanom biam mapani. Ama Lasarus niꞌipama banagafi amom. Naꞌamba amom wapani mufiꞌi wambel ambaleꞌe mofaꞌ akafimi luꞌwami.’ ");
INSERT INTO aoj_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","“Owaꞌ Abraham naꞌipana naꞌi, ‘Owaꞌ. Owapena ineꞌimi mondameꞌago basefa Moses noloma amom profet fetopalopam. Amom mondameꞌago basef fafimba.’ ");
INSERT INTO aoj_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","“Eaꞌ naꞌipana naꞌi, ‘Ahame Abraham, owaꞌatin. Ina atiasi momeꞌam, owaꞌ. Apaꞌ iꞌi anin epen nagagaꞌi nesafel wandofa negafeꞌma amom, daoꞌ bola memeꞌan mombema nelelemb.’ ");
INSERT INTO aoj_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","“Owaꞌ Abraham naꞌipana naꞌi, ‘Owaꞌatina mogameꞌ basefa Moses noloma amom profetia, eaꞌ atiasi anin epen nagagaꞌi nitanima negesafel wandof, amom ina atiasi mohapifa inimba wapani, owaꞌatin.’” ");
INSERT INTO aoj_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Jisas naꞌipa alipumi ananimi naꞌi, “Endilisi hiahaom amamba mogogwambipai ma pendaꞌ waf awafii. Endilisi hiahaom amamba atiasi mogatagai, apaꞌ epes ami sondaꞌ hiahaom amamba awami mogatagai, aeꞌ ati esis uwahipis endilisi. Deiꞌ main, esis anaf semeꞌ akafimi nimanimi luꞌwami. ");
INSERT INTO aoj_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Iꞌi anis epes sofaꞌ epen inimba sondola otam luꞌunai nila biniꞌw ananiꞌwi sofaꞌan sofeꞌ solan negewala naoh mami luꞌwami ma afinai, anin ataꞌ nepe andeandeꞌ kwasakwasala. Apaꞌ owaꞌ owaꞌatin. Iꞌi epen inimba nendaꞌ anin saꞌuni negakwaha nigahapifa aeꞌa, epen inimba atiasi nepe awen aꞌowaꞌ nikilaꞌ negewala naoh afinai. ");
INSERT INTO aoj_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Ipaꞌ solawaipa andeandeꞌ. Iꞌi owamepa ipeꞌinai nondaꞌ waf awafi ma, piꞌipana basef dindinipa nogakwahef. Ama iꞌi anen nogambema nembela, ipaꞌ ukup peseꞌepa waf awafi ananifi. ");
INSERT INTO aoj_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Apaꞌ iꞌi anen nondaꞌmepa waf awafi ipaꞌ lifilafi nil 7-pelaifa nemaf atetef, ama anen netanima nifiꞌmai ipaꞌ ma nohotagw agwamba 7-pelaigw niꞌi, ‘Aeꞌ aꞌ ambema nembel’, eaꞌ daoꞌ ipaꞌ ukup aꞌ peseꞌepa waf awafi ananifi.” ");
INSERT INTO aoj_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Amom aposel Jisasi maꞌipa Dembinai amamunai maꞌi, “Inaꞌ nendaꞌ afaꞌ ohapifina banagefa ukilaꞌ waliꞌ wagahapifina.” ");
INSERT INTO aoj_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Eaꞌ Dembinai naꞌipam naꞌi, “Iꞌi hapif ipeꞌini nendahama siꞌi nalelef saꞌwisaꞌwisi mastetilif lawag, daoꞌ atiasi ipaꞌ piꞌipa lawag gagumba saꞌutip pagailagai pigaꞌi, ‘Inaꞌ dagia neloma kofaga nefeꞌ newala naoh embel nomon,’ eaꞌ agog aꞌ gigiꞌma basef ipeꞌifi.” ");
INSERT INTO aoj_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Iꞌi anona aman ipeꞌinai nofaꞌ anona aman daiana nondaꞌ maola anen nowala itap aof aꞌa numafi sipsip, ama main notanimai nifiꞌi ipat, eaꞌ atiasi dembinai nugumafi anini niꞌipana niꞌi, ‘Inaꞌ fiꞌi kwafalis nepe neaꞌ waliꞌita’? Owaꞌatin. ");
INSERT INTO aoj_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Atiasi aꞌ niꞌipana niꞌi, ‘Inaꞌ nendondomba gwaꞌaisi aeꞌasi, newahoꞌ let, nendome gwaꞌaisi aeꞌ niliꞌ nefaꞌas nifiꞌi. Ma iliꞌ iaꞌasa main, inaꞌ nigiꞌ neaꞌ ineꞌisi.’ ");
INSERT INTO aoj_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","“Eaꞌ atiasi anen aꞌ ninifela aman anamba nandaꞌmana maoli ma nogaila malogol ananigili? Owaꞌatin. ");
INSERT INTO aoj_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Eaꞌ ipaꞌ wapani naꞌamba atin. Iꞌi ipaꞌ pendaꞌ hiahawes hiasi hiꞌilas siꞌi God nagaꞌipipa, daoꞌ ipaꞌ piꞌi basef piꞌi, ‘Afaꞌ wandaꞌ maoli awasifai. Hiahawes afaꞌ wandaꞌasi, isimba maol afaꞌini atin.’” ");
INSERT INTO aoj_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Eaꞌ Jisas naila ufiaꞌw nafeꞌ Jerusalem, nafeꞌ laꞌafena itap luꞌupa biafip Samariai Galili. ");
INSERT INTO aoj_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Anen nataga anambel wambel, owaꞌ amam ilifunamaim aowas aunai nandaꞌ alop amamipi pagamboꞌwi mafiꞌi ufiaꞌw ataꞌ malutuwi laogon, ");
INSERT INTO aoj_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","mofalana mehip maꞌi, “Jisas, Dembinai, inaꞌ niꞌi uwahipigama afaꞌ!” ");
INSERT INTO aoj_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Eaꞌ Jisas natolom naꞌipam naꞌi, “Ipaꞌ foꞌo pihimbaꞌmam alop ipeꞌipi ma amom pris.” Eaꞌ amom ataꞌ mafeꞌ atin owaꞌ, alop amamipi pataga boꞌop. ");
INSERT INTO aoj_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Anona aman amamunai nati alop ananipi boꞌop, notanima nafeꞌ noga naꞌi mehip nafela agol Godi. ");
INSERT INTO aoj_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Eaꞌ nasisil nowafa notawa itap felefeleꞌma boꞌwagah Jisasi nanifelona. Anen ina Judainai, owaꞌ. Anen Samariainai. ");
INSERT INTO aoj_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Eaꞌ Jisas natolona naꞌi, “Aeꞌ aꞌi owaꞌ ipaꞌ ilifunamaipa ambeꞌepa atin. Deiꞌ 9-pelaim amuma? ");
INSERT INTO aoj_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Owaꞌ anom motanima mifiꞌi mefela agol Godia? Aman anamba anagon daiagininai, anen atotona.” ");
INSERT INTO aoj_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Eaꞌ Jisas naꞌipana naꞌi, “Inaꞌ safel foꞌo. Inaꞌ nahapifa aeꞌ, isimba atis deiꞌ nataga boꞌwena wapani.” ");
INSERT INTO aoj_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Anom dembami Farisi mahaliꞌ Jisas maꞌi, “Nogota mamahotama nemaf afamba buꞌwafi fetaga ma apaꞌ mugawis nomona maol Godi nope Dembinai nugumafiapa?” Anen nagwamam basef amom naꞌi, “Amamba esis ina sotolom naep, owaꞌ. ");
INSERT INTO aoj_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Esis ina atiasi siꞌi, ‘Piti, amamba mape naꞌa, aꞌa mape gani, owaꞌatin. Pemeꞌ! Amamba mape opalef ipeꞌilifi nomon eaꞌ.” ");
INSERT INTO aoj_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Jisas naꞌipa alipumi ananimi naꞌi, “Anef nemaf dondoꞌafi fegataga, nelelemb ipeꞌilimbi belef endilisi piꞌi, ‘Apaꞌ maꞌi aman anamba notaga epen nogofaꞌ alop epesi ataꞌ nifiꞌi notaga ulala ataꞌ motolona kwasakwasala.’ Apaꞌ owaꞌ, owaꞌatin. Ipaꞌ ina petolowe, owaꞌ. ");
INSERT INTO aoj_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Eaꞌ atiasi anis epes siꞌipipa siꞌi, ‘Piti nani nape gani,’ anis siꞌi ‘Piti anen nape naꞌaꞌe.’ Apaꞌ ipaꞌ ina pemeꞌas pigiꞌmas, owaꞌ hapaisi. ");
INSERT INTO aoj_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","26","Ipaꞌ pegawa peleꞌala ma otaga bendagala holagala nafeꞌagon hiꞌalagon. Eaꞌ aeꞌ ataga epen egefaꞌ alop epesi, atiasi endaꞌam naꞌamba atina anaf aeꞌ egataga. Apaꞌ aeꞌ ataꞌ iliꞌ efaꞌ akafimi hiami ma epes nogota ataꞌisi deiꞌ sogowaꞌ alafugahai. Waf fowaꞌ sandaꞌafa nogota atamba Noa nagapautai, eaꞌ naꞌamba atin siꞌi anaf esis sondaꞌaf nemaf afamba felefeleꞌma ifiꞌi egataga itap apaꞌe. ");
INSERT INTO aoj_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Saꞌ gwaꞌaisi, saꞌ embel, amam nematawa sindikikilaꞌma sandasoꞌama atin safeꞌ safeꞌ sataga nemaf afamba Noa nafeꞌ nagawis galahoꞌw. Eaꞌ embel luꞌwami mataga maha esis amam nematawa hiasi afis hiꞌalas. ");
INSERT INTO aoj_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","“Esis sandaꞌ waf naꞌamba atin siꞌi nogota atamba Lot nagapautai wapani. Saꞌ gwaꞌaisi, saꞌ embel satala hiahawes sasoꞌasas safeꞌma anis satalis, sawa hiahawes aofah, salaꞌ ifagw. ");
INSERT INTO aoj_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Owaꞌ Lot nakwaha Sodom nafeꞌ, ma nemaf afamba atef nif faloma otamba salfa fagandumi mowai heven siꞌi asaf fagalai eaꞌ mahambombaga amam nematawa hiasi sagaꞌ hiꞌalas. ");
INSERT INTO aoj_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","“Eaꞌ anaf naꞌamba atina nemaf aeꞌ ataga epen egefaꞌ alop epesii igatagaefi. ");
INSERT INTO aoj_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Nemaf afamba epen ami nagape ipat andoꞌi felefeleꞌi, ina ataꞌ netanima nuwis nefaꞌai hiahawes ananisi ipat nomon, owaꞌi. Eaꞌ naꞌamba atin epen nigaili aofi, ina ataꞌ netanima nefeꞌ ipat, owaꞌi. ");
INSERT INTO aoj_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","“Ipaꞌ nomonas sondandaꞌma Lot wauluꞌmana. ");
INSERT INTO aoj_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Epen ami niꞌi nelaꞌambema ambal ananili siꞌil daoꞌ, ambal ananili anaf higililal. Apaꞌ ami iꞌi nelelama ambal ananili, anaf ambal ananili lope andeandeꞌ atapil lifilafi. ");
INSERT INTO aoj_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Endilisi aeꞌ aꞌipipa, nemaf afamba owamb amam biam moꞌoh ipat belita atotota, God nofaꞌ anona, anona nokwahona nope. ");
INSERT INTO aoj_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Anowa nematawa biawa ondaꞌ maola plaua ondaꞌ breti, atiasi God nofaꞌ anoꞌw, nokwaha anoꞌw kope. ");
INSERT INTO aoj_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Amam biam mogail aofi, atiasi God nofaꞌ anona, nokwaha anona nope.” ");
INSERT INTO aoj_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Alipumi ananimi mameꞌ basef ifimba maꞌi, “Dembinai, amamba anaf motaga ani?” Eaꞌ Jisas naꞌipam naꞌi, “Mamahagoma alop sagagaꞌi pogaꞌoma, eaꞌ naꞌamba atogon atiasi komemb mufiꞌi munduwaꞌanimama.” ");
INSERT INTO aoj_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Jisas nasoꞌam basef wamon atin alipumi ananimi ma nigihimbaꞌmam mondabeten nimaguf danda ma amom ina alaꞌuta toham ukup iwanip, owaꞌi. ");
INSERT INTO aoj_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Anen naꞌias naꞌi, “Anona dembinai jas nogonandona basefi, nape anin taun. Anen ina ombal bahana ma dembinai God, ina nomonas sapoma anis epes wapani, owaꞌ. ");
INSERT INTO aoj_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","“Anoꞌw nemataꞌw waulunamaꞌw nagagaꞌaꞌwi kwape taun inimba. Dondol akoꞌw kwafiꞌmai jas anamba kwaꞌipana kwaꞌi, ‘Bousi aeꞌasi saꞌi sohambombaga aeꞌ. Inaꞌ ataꞌ netopalope ma kot.’ ");
INSERT INTO aoj_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","“Jas anamba naliꞌ nandaiwaꞌma nogatopalopaꞌw. Aꞌi owaꞌ main, okom ananimi maꞌi, ‘Aeꞌ ina ombal bahema God a ukup epesi. ");
INSERT INTO aoj_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Apaꞌ nemataꞌw akwamba alifiꞌwi kwaseꞌe numaꞌumi aeꞌ. Eaꞌ hapaimi, ataꞌ etopalopago akoꞌw ulala kot. Naꞌamba kufiꞌi lifilafi kondaꞌ okom molowe.’” ");
INSERT INTO aoj_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Eaꞌ Dembinai naꞌipam naꞌi, “Ipaꞌ pemeꞌ basefa jas anamba aunai. ");
INSERT INTO aoj_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Epes isimba God nandandepas eaꞌ ananisii, esis salef sakokona lifilafi owamb alip. Deiꞌ God notopalopasa kot aꞌa owaꞌ? Ahoꞌ, nogatopalopasi. Anen ina niꞌipas fafifafi, owaꞌatin. ");
INSERT INTO aoj_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Aeꞌ aꞌipipa endilisi, atiasi nogatopalopas kwafalisi. Aeꞌ ataga epen egefaꞌ alop epesi. Apaꞌ anaf aeꞌ igafiꞌi, nemaf afamba iti amam nematawa itapipai pihapifi, aꞌa owaꞌatin?” ");
INSERT INTO aoj_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Anis epes ukup pandapoma esis atis saꞌi esis epes fasisi sandaꞌ waf buꞌwafi, eaꞌ saꞌi anis daias awasisi. Epes isimba Jisas nasoꞌasa basef waminif atin naꞌi, ");
INSERT INTO aoj_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Anom amam biam maꞌi mofeꞌ mondabeten ipat luꞌunai Godi. Anona Farisi, anona aman aunai nogofaꞌ takisi. ");
INSERT INTO aoj_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Farisi anamba nalutu okom mandapoma anen atona nandabeten naꞌamba naꞌi, ‘Aeꞌ anifelina God, ama aeꞌ ina siꞌi anis epes daias awasisi. Esis sambasoꞌmas sogofaꞌ uga mais anis daiasi, sandaꞌ waf awafii, sagatopaꞌ muꞌuli ineꞌini ma sandaꞌ waf awafi soꞌa waulafi. Aeꞌ ina andaꞌam siꞌi esis, owaꞌatin. Aeꞌ anifelina ma aeꞌ ina siꞌi aman nanumba aunai nogofaꞌ takisi. ");
INSERT INTO aoj_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Wikifah hiagahi aeꞌ akwaha gwaꞌaisi nimaguf bifa andabeten. Eaꞌ hiahawes hiasi aeꞌ egefaꞌasi, awala duꞌwanis ilifunamaisa aseꞌenas inaꞌ.’” ");
INSERT INTO aoj_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","14","“Apaꞌ aman anamba nogofaꞌ takisi nalutuwi laogon nandaiwaꞌma niniga negati heven, owaꞌ. Naha mafata ananitai atapita naꞌi, ‘O God, aeꞌ aman andaꞌ waf awafii, inaꞌ niti aeꞌ owahipiwi netopalope.’ Eaꞌ notanima nafeꞌ ipat ananitai. Aeꞌ aꞌipipa endilisi, aman anamba nogofaꞌ takisi naꞌias naꞌamba, anen boꞌona ma naep Godi. Apaꞌ aman anamba naliꞌ nandabetani, owaꞌ. Deiꞌ main, epen ami negasaꞌma agol ananigili atigili, atiasi God nondaꞌ agol ananigili gowala. Apaꞌ epen ami nendaꞌ agol gigisilaꞌi, bola God nosaꞌma agol ananigili luꞌwagol.” ");
INSERT INTO aoj_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Esis saoꞌwamanai anis awasi saꞌwisi sofaꞌas safiꞌmai Jisas, saꞌi anen nosa lagofa nofaloꞌmasa nondaꞌas sonogahas. Owaꞌ, alipumi ananimi mati isimba mandaiwaꞌma awasi isimba eaꞌ masopama esis sofaꞌas sogafiꞌmai anen. ");
INSERT INTO aoj_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Eaꞌ Jisas nofala awasi isimba safiꞌi felefeleꞌma anen eaꞌ naꞌipam naꞌi, “Ipaꞌ kwahowa awasi isimba sifiꞌmai aeꞌ. Owaꞌi piliꞌamasa. Deiꞌ main, esis amam nematawa sogawis nomona maol Godi nope Dembinai nugumafias anaf sefeꞌ anen nagalaꞌambemagomai, esis sameꞌ basef ananifi sagailif siꞌi awasi isimba. ");
INSERT INTO aoj_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Aeꞌ aꞌipipa endilisi. Epen ami niꞌi ahoꞌma God nope Dembinai ma anina neseꞌana nembel God siꞌi awasi isimba sagaꞌi ahoꞌmana, isimba sandaꞌas naꞌambai atiasi sogawis anamba God nagalaꞌambemagomai. Iꞌi owaꞌ, owaꞌatin.” ");
INSERT INTO aoj_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Anona agilinai Judainai nahaliꞌ Jisas naꞌi, “Tisa buꞌwinai, aeꞌ atiasi endaꞌ maina egefaꞌ ambal namili egape andeandeꞌ lifilafi?” ");
INSERT INTO aoj_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Eaꞌ Jisas naꞌipana naꞌi, “Deiꞌ maina nagaꞌi aeꞌ buꞌuwai? God atona buꞌunai. ");
INSERT INTO aoj_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Inaꞌ negawa muꞌuli God nagasoꞌ Mosesani nagaꞌi, ‘Inaꞌ owaꞌi nendaꞌ waf awafi soꞌa waulafia, ina neha anis epes sogaꞌ nendaꞌ wal, owaꞌi, inaꞌ owaꞌi nembasoꞌma anis epes daiasa, inaꞌ nemeꞌ basef mamasinai nihapilif nilif eaꞌ nindimafias andeandeꞌ.” ");
INSERT INTO aoj_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Eaꞌ naꞌipana naꞌi, “Muꞌuli inimba hiani ahapilan ailan fowaꞌ ataꞌ saꞌowe afiꞌi afiꞌi ataga deiꞌ.” ");
INSERT INTO aoj_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Eaꞌ Jisas nameꞌ basef ifimba naꞌipana naꞌi, “Inaꞌ anef waf fasifi atetef owaꞌ ataꞌ nendaꞌafa. Inaꞌ foꞌo neseꞌasa hiahaom ineꞌimi hiꞌindalama anis daias sotalinama nefaꞌ moni inimba nendaꞌan nesoꞌ isimba kwahusi. Nendaꞌas naꞌamba ma anaf negefaꞌ hiahawes fasisi gani heven. Eaꞌ nifiꞌi nihapifi nila aeꞌ.” ");
INSERT INTO aoj_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Owaꞌ anen nameꞌ basef ifimba, nembel ananimbili nimanimbil aꞌowaꞌ. Anen agilinai hiahaom hiamunai. Naꞌamba deiꞌ anen nembel nimanimbil. ");
INSERT INTO aoj_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Eaꞌ Jisas natolona naꞌi, “Epes isimba ugai moni hianaisi, sandaꞌam dandaꞌ ahifim aꞌowaꞌ ma sogafeꞌ anamba God nagalaꞌambemagoma. Atona atin sefeꞌ. ");
INSERT INTO aoj_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Anin mafin luꞌunai kamel nogawis bolotaf nil sogosambala luwagufeli, anamba ila ina ahifim aꞌowaꞌ ma nogawis. Apaꞌ amam nematawa hiahaom hiamisi iꞌi sogafeꞌ anamba, sondaꞌam dandaꞌ ahifim aꞌowaꞌ ma sogafeꞌ. Maol inimba ahifim aꞌowaꞌ nikilaꞌ maol kamel nogawis bolotaf nili.” ");
INSERT INTO aoj_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Epes isimba sameꞌ naꞌamba saꞌi, “Iꞌi naꞌambaiai, anaf God nuwambilai epes mamahisa sotanimai sope andeandeꞌ lifilafi? Owaꞌatin.” ");
INSERT INTO aoj_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Jisas naꞌipas naꞌi, “Hiahaom epes owaꞌ laꞌifisa sondaꞌamia, amamba God atona banagonai ma nondaꞌam.” ");
INSERT INTO aoj_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Eaꞌ Pita naꞌipana naꞌi, “Nemeꞌ, afaꞌ eaꞌ wakwaha hiahaom afaꞌii hiami eaꞌ deiꞌ wafiꞌi wahapifa basef ineꞌifi wailina.” ");
INSERT INTO aoj_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Jisas naꞌipas naꞌi, “Aeꞌ aꞌipipa endilisi, ipaꞌ epen ami nekwaha ipat toloma akoꞌw awasi sahin owan ahasan mamasan ananisi, ma nendaꞌ maola epes hiasi sogawis nomona maol Godi nope Dembinai nugumafias, ");
INSERT INTO aoj_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","anef nemaf God nogwaman hiahaom hiami mikilaꞌ amamba naliꞌ nagalamonomi. Anaf owagama nogota buꞌutai togataga, epen inimba aꞌ nofaꞌ ambal namili ma negape andeandeꞌ lifilafi.” ");
INSERT INTO aoj_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Eaꞌ Jisas naoꞌwa alipumi ananimi 12-pelaim naꞌipam naꞌi, “Pemeꞌ, deiꞌ afaꞌ eaꞌ ondowasaꞌ Jerusalem. Ama basef ifimba hiafi amom profet fowaꞌ mandaꞌef fagail buki fagaꞌi aeꞌ ataga epen egefaꞌ alop epesi fetaga alihif fendawalap hiꞌigalef. ");
INSERT INTO aoj_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Atiasi amom mondaꞌe efeꞌma anis epes sogolalama Godi. Eaꞌ sondaꞌ waꞌap sondaꞌe findiwae sehe sondaꞌme waf awafi sisisiꞌwafe ");
INSERT INTO aoj_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","a sopopagahowe sehe egaꞌ. Ama nimaguf bif hiꞌilif, ama anef fegafeꞌma wanifi, owaꞌ, aꞌ itanima esafel wapani.” ");
INSERT INTO aoj_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Apaꞌ amom alipumi ananimi ina mogawa basef ifimba, owaꞌ. Basef kofagefa fagaꞌias ataꞌ fandambahoꞌma amom, eaꞌ ina ukup pandandaꞌmas andeandeꞌma hiahawes Jisas naꞌi nondaꞌasi, owaꞌatin. ");
INSERT INTO aoj_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Jisas nafeꞌ nataga felefeleꞌma anambel wambel Jeriko, eaꞌ anona aman naep pagasoꞌanai nape ufiaꞌw waꞌakw dawalegef nandailasa gwaꞌaisi moni mais. ");
INSERT INTO aoj_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Owaꞌ nameꞌ esis hiasi safiꞌi sikilaꞌana safeꞌ, nahaliꞌas naꞌi, “Esis sandaꞌ main notaga?” ");
INSERT INTO aoj_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Eaꞌ saꞌipana saꞌi, “Jisas Nasaretinai anamba deiꞌ nafiꞌi nikilaꞌena nafeꞌ.” ");
INSERT INTO aoj_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Eaꞌ nofalana naꞌi, “Jisas, inaꞌ Devit akunamana, niti aeꞌ owahipiwi!” ");
INSERT INTO aoj_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Epes isimba saliꞌ sagafiꞌi sinifalona naꞌamba saꞌi, “Inaꞌ sopama malogol!” Owaꞌ anen fala atin nape naꞌi, “Inaꞌ Devit akunamana, niti aeꞌ owahipiwi” ");
INSERT INTO aoj_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Eaꞌ Jisas nafiꞌi nalutu naꞌipas naꞌi, “Daꞌana nifiꞌmai aeꞌ.” Anen nafeꞌ felefeleꞌ, Jisas nahaliꞌana naꞌi, ");
INSERT INTO aoj_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Inaꞌ naꞌi aeꞌ endaꞌmena main?” Eaꞌ naꞌipana naꞌi, “Dembinai, aeꞌ aꞌi iti andeandeꞌ wapani.” ");
INSERT INTO aoj_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Eaꞌ Jisas naꞌipana naꞌi, “Naep ineꞌipi piti. Inaꞌ nahapifa aeꞌ banagena. Isimba atis deiꞌ nataga boꞌwena wapani.” ");
INSERT INTO aoj_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Eaꞌ kwafalis atis naep apatiana andeandeꞌ, nagiꞌma Jisas nafeꞌ ufiaꞌw nasaꞌma agol Godi. Eaꞌ esis amam nematawa sati isimba sasaꞌma agol Godi wapani. ");
INSERT INTO aoj_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Jisas nafeꞌ nawis anambel wambel Jeriko, naꞌi nefeꞌ. ");
INSERT INTO aoj_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Owaꞌ anona aman hiahaom hiamunai nape, agol ananigili Sakius anen agilinai ma amam amamba mogofaꞌ takisi. ");
INSERT INTO aoj_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Anen naꞌi niti Jisasa nogogawana anen mamahonama. Owaꞌ amam nematawa wambelisi hiasi salutu siliꞌak. Sakius anen bandabandana, eaꞌ ina nati Jisas, owaꞌ. ");
INSERT INTO aoj_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Eaꞌ nasagih naliꞌ nafeꞌ nalota natoma anoga lawag fik ama niti Jisas nogafiꞌi. ");
INSERT INTO aoj_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Jisas nataga anamba nosaniga nati ilif naꞌipana naꞌi, “Sakius, deiꞌ aeꞌ efeꞌ epe ipat ineꞌitai. Inaꞌ silaꞌi kwafalis.” ");
INSERT INTO aoj_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Eaꞌ nisilaꞌi kwafalis nembel ananimbili sonahambel, nofaꞌ Jisas nafeꞌ ipat ananitai. ");
INSERT INTO aoj_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Eaꞌ esis amam nematawa sati isimba, ukup numbutip saꞌi basef wandafifi saꞌi, “Anen nafeꞌ nape ipat anona aman nandaꞌ waf awafii.” ");
INSERT INTO aoj_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Apaꞌ Sakius nosafel nalutu naꞌipa Dembinai naꞌi, “Dembinai, inaꞌ nemeꞌ. Deiꞌ aeꞌ aꞌi ewala hiahaom hiami aeꞌami laꞌafen dondoꞌ atin, eaꞌ eseꞌas duꞌwanim isimba kwahusi. Iꞌi aeꞌ embasoꞌma anin epena ekwalopa maefah ananimi, atiasi aeꞌ egwamana hiami bifibif.” ");
INSERT INTO aoj_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Eaꞌ Jisas naꞌipana naꞌi, “Deiꞌ God nowambilai amam nematawa sagape ipat ataꞌii nokwahomas waf awafi sotanimai eaꞌ. Deiꞌ main, aman anamba wapani nataga akunamana Abrahami. ");
INSERT INTO aoj_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Aeꞌ ataga epen egefaꞌ alop epesi, aeꞌ afiꞌi ma elaoma epes higilagalasi iwambilas sokwaha waf awafi sogotanimai.” ");
INSERT INTO aoj_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Esis sameꞌ basef ifimba, eaꞌ Jisas naꞌipas naꞌi anif basef waminif atin wapani. Deiꞌ main, anen nape felefeleꞌma Jerusalem, eaꞌ esis ukup pandandaꞌ paꞌi epes hiasi siti God deiꞌ atef notaga nope Dembinai nugumafias. Eaꞌ naꞌi basef ifimba waminif atin ");
INSERT INTO aoj_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","naꞌi, “Anona aman dembinai naꞌi nefeꞌ anambel wambel lauguni ma esis sondaꞌana nogape king dembinai. Anef anen notanima nifiꞌi. ");
INSERT INTO aoj_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Eaꞌ nofalai anom amam ilifunamaim mandaꞌ maol ananinii, eaꞌ natambeꞌ moni 20 kina nandahama amom. Eaꞌ naꞌipam naꞌi, ‘Ipaꞌ pendaꞌ maol pembama moni inimba pefeꞌ petagama aeꞌ itanima igafiꞌi.’ ");
INSERT INTO aoj_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","“Apaꞌ owaꞌ esis wambel atembel aman anambai ukup aoma anen endilisi. Eaꞌ nafeꞌ sasapaꞌ anom amam magiꞌmana mafeꞌ maꞌi, ‘Apaꞌ mandaiwaꞌma inaꞌ negape king dembinai ma apaꞌ.’ ");
INSERT INTO aoj_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Owaꞌ owaꞌatin. Esis sandaꞌana nataga nape king dembinai ama main, notanima nafiꞌi. Eaꞌ naꞌi, ‘Falai amom amamba mandaꞌ maoli fowaꞌ aeꞌ agasoꞌam monii. Aeꞌ aꞌi ataꞌ egawa moni wamani maꞌufin amom hiami atona atin mogofaꞌani.’ ");
INSERT INTO aoj_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","“Eaꞌ nagaliꞌi nafiꞌi naꞌipana naꞌi, ‘Dembinai, aeꞌ andaꞌ maola 20 kina inimba ineꞌini embaman deiꞌ efaꞌai 200 kina wamani.’ ");
INSERT INTO aoj_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","“Eaꞌ dembinai naꞌipana naꞌi, ‘Inaꞌ nandaꞌ maol andeandeꞌ datimai. Inaꞌ eaꞌ nimafi moni inimba kwasalaꞌwin andeandeꞌ. Deiꞌ eaꞌ eseꞌena agol luꞌwagili inaꞌ ma nigimafi taun luꞌwagoma ilifunamaigin.’ ");
INSERT INTO aoj_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","“Eaꞌ anona nagafeꞌma biami nafiꞌi naꞌipana naꞌi, ‘Dembinai, aeꞌ andaꞌ maola 20 kina iniꞌi deiꞌ eaꞌ itanima ifaꞌai 100 kina wapani.’ ");
INSERT INTO aoj_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","“Eaꞌ dembinai naꞌipana naꞌi, ‘Aeꞌ endaꞌena nimafi taun wambel luꞌwambili wanifin biafin.’ ");
INSERT INTO aoj_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Eaꞌ anona nagagiꞌi nafiꞌi wapani naꞌipana naꞌi, ‘Dembinai, 20 kina ineꞌini iniꞌi. Aeꞌ ewaꞌan anip hankisip ambeꞌan naꞌoh. ");
INSERT INTO aoj_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Aeꞌ egawa inaꞌ aman dindinapinai. Anis maefah anis epes sambeꞌas sagaꞌihi, isimba inaꞌ nefaꞌas. Gwaꞌaisi anin epen daian nagawasi, isimba inaꞌ nagalaꞌasi. Naꞌamba aeꞌ ombal mahe ma inaꞌ. Eaꞌ deiꞌ ambahoꞌwa moni inimba naꞌomena.’ ");
INSERT INTO aoj_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","“Owaꞌ dembinai naꞌipana naꞌi, ‘Inaꞌ nandaꞌ maoli, inaꞌ epen awinai nandaꞌ duꞌwanigai. Basef ineꞌifi atif fawalogena. Deiꞌ inaꞌ negawa aeꞌ aman dindinapiwai agalaꞌ gwaꞌaisi anona aman nagawasi. ");
INSERT INTO aoj_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Iꞌi inaꞌ negawa naꞌambaiai, deiꞌ nefaꞌan negambeꞌan benga aeꞌ itanima ifiꞌi efaꞌan negaloma anin wamani wapani.’ ");
INSERT INTO aoj_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","“Eaꞌ naꞌipa esis sagalutu naꞌamba felefeleꞌi naꞌi, ‘Ipaꞌ dalombana 20 kina aman anamba peseꞌanan aman nanumba nogofaꞌ moni 200 kinai.’ ");
INSERT INTO aoj_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","“Owaꞌ esis saꞌipana saꞌi, ‘Dembinai, anen nofaꞌ bitigwif ilifunamaif 200 kina eaꞌ.’ ");
INSERT INTO aoj_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","“Owaꞌ anen naꞌi, ‘Aeꞌ aꞌipipa, epes ami sogahapila hiahawesi isimba atiasi eseꞌas anis hiahawes wapani esis. Apaꞌ epen ami owaꞌ nigahapila hiahawesia, eaꞌ hiahawes saꞌwisaꞌwisi anin nagahapilasi, isimba atiasi endalombanas anin. ");
INSERT INTO aoj_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Owaꞌ isimba esis bousi aeꞌasi, sandaiwaꞌma aeꞌ egape dembiwai king asasiwai igimafias, ipaꞌ faꞌas fiꞌi naꞌa pehas sogaꞌ naep aeꞌapi.’” ");
INSERT INTO aoj_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Jisas naꞌi basef ifimba eaꞌ naliꞌ nafeꞌ naila ufiaꞌw kwagafeꞌ Jerusalami nondowasaꞌ. ");
INSERT INTO aoj_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Eaꞌ nataga Betfagai Betani walemb ambalemba felefeleꞌma halafuta atamba Oliv eaꞌ nasapaꞌ alipumi ananimi biam maliꞌ mafeꞌ ");
INSERT INTO aoj_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","naꞌipam naꞌi, “Ipaꞌ bipa pefeꞌ wambel bambalimba bagape gani waꞌili felefeleꞌma naꞌai. Pefeꞌ piwis apiti anona mafin donki ataꞌ saꞌunai esis sandolona nail. Ina deiꞌ anin epen natomana, ataꞌ owaꞌatin. Petagwahona pefaꞌana pifiꞌmai aeꞌ. ");
INSERT INTO aoj_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Iꞌi anin epen nihaliꞌipa nigaꞌi, ‘Deiꞌ pagatagwahona ma main?’ Eaꞌ pegwaman piꞌipan piꞌi, ‘Dembinai afaꞌinai naꞌipafa naꞌi nondaꞌ maola.’” ");
INSERT INTO aoj_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Jisas nasapaꞌ amom biam mafeꞌ mati hiahawes isimba naꞌamba atin siꞌi dokoꞌ nagaꞌipam. ");
INSERT INTO aoj_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Eaꞌ matagwaha mandofa donki anamba saꞌunai. Matagwahona atin owaꞌ, amom mugumafi donki anambai maꞌipam maꞌi, “Deiꞌ maina ipaꞌ pagatagwaha donki anamba?” ");
INSERT INTO aoj_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Amom maꞌipam maꞌi, “Dembinai naꞌi nondaꞌ anin maola.” ");
INSERT INTO aoj_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Eaꞌ amom mofaꞌ donki anamba mafiꞌmai Jisas mawamona sagegw amamugwi gwatoma ilifa donki anamba. ");
INSERT INTO aoj_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Eaꞌ matopalopa Jisas nalota natoma donki anamba nafeꞌ, eaꞌ esis amam nematawa saꞌi sosaꞌma agol ananigili luꞌwagol. Eaꞌ deiꞌ sandombamana sagegw sasoꞌwiam ufiaꞌw sofaloꞌmaꞌw. ");
INSERT INTO aoj_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Anen nafiꞌi eaꞌ felefeleꞌ ma ufiaꞌw kogilianai halafuta Olivi. Alipisi ananisi hiasi eaꞌ sandagala, ukup papomai hiahaom amamba banagami fowaꞌ nandaꞌami. Eaꞌ lilililif saꞌoh mehip, sasaꞌma agol Godi luꞌwagol. ");
INSERT INTO aoj_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Saꞌias naꞌamba saꞌi, “Apaꞌ mosaꞌma agola God nagape ilifi luꞌwagol, mogogalaꞌi mapoma anen atona. Maꞌi anen nofaloꞌma inaꞌ dembinai king nagafiꞌi agol ananigilii neseꞌena banagami ma nendaꞌ maol ananini. Esis sagape heveni opalef awanelef.” ");
INSERT INTO aoj_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Owaꞌ anom dembami Farisi mape maloma epes hiasi maꞌipa Jisas maꞌi, “Dembinai Tisa, inaꞌ ninifala alipisi ineꞌisi ma ataꞌ sosopama malogof.” ");
INSERT INTO aoj_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Jisas nagwamam basef naꞌi, “Aeꞌ aꞌipipa endilisi, iꞌi esis sogasopama malogof, atiasi eaꞌ otamba atom magaꞌoh itapi mope miꞌi gigal mehip.” ");
INSERT INTO aoj_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Jisas nataga felefeleꞌ ma Jerusalem natologon nalopagon. Nalopa esis amam nematawa taun inimbaisi. ");
INSERT INTO aoj_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Eaꞌ naꞌi, “Iꞌi deiꞌ nemaf afaꞌe atef ipaꞌ pegawa basef kofagefa ma pegape opalef awanelefai, daoꞌ isimba atiasi andeandeꞌ. Apaꞌ owaꞌ, owaꞌatin. Basef ifimba ataꞌ fandambahoꞌ, deiꞌ ipaꞌ owaꞌ ataꞌ pegawefa. ");
INSERT INTO aoj_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Anafa anef nemaf fetaga, eaꞌ atiasi bousi ipeꞌisi sifiꞌi solaꞌ indalelemb sondaꞌ wandaf soganogama ipaꞌ. Eaꞌ siliꞌama ipaꞌ endilisi ma anamba hiagoma. ");
INSERT INTO aoj_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Eaꞌ sehepa sohambombagepa endilisi, peloma awasi ipeꞌisi sagape nomona wambel ipeꞌimbili. Esis sohambombaga wambel awagon hiꞌilagon endilisi, eaꞌ ina atiasi otamba sagalaꞌ ifagwambai bendatomama atin atapimba bepe, owaꞌ. A sugulatam moꞌoh daindai. Deiꞌ main? Ipaꞌ owaꞌ pegawa nemaf deiꞌ God nogafiꞌafii ma nefaꞌepa pitanimai pegape andeandeꞌa.” ");
INSERT INTO aoj_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Eaꞌ Jisas nosafel nawis ipat luꞌunai Godi eaꞌ naliꞌamona amom amamba mandaꞌ bisnisi mandaꞌ maola magatala hiahawes ipat anamba nomoni. ");
INSERT INTO aoj_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Anen naꞌipam naꞌi, “Basef fagape Baibeli, God naꞌi, ‘Ipat aeꞌanai nondapoma esis sifiꞌi sopaona sondabeten sogahaliꞌ aeꞌ.’ Apaꞌ owaꞌ, pandaꞌana nataga siꞌi sandambahoꞌ sandaꞌ wala.” ");
INSERT INTO aoj_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Nimaguf hiafi Jisas nawalipasa basef ipat anamba nomon. Eaꞌ amom pris dembami maloma anom agufumi Judai maloma anom dembami magawalipasa muꞌuli Godi malaꞌ molaoma ufiaꞌwa mohana nogagaꞌ. ");
INSERT INTO aoj_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Owaꞌ esis amam nematawa hiasi dindinapis aꞌowaꞌ ma sagameꞌ basef ananifi. Naꞌamba amom ina mati anoꞌw ufiaꞌwa mogahana, owaꞌatin. ");
INSERT INTO aoj_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Anef nemaf Jisas nape nasoꞌasa basef amam nematawa ipat luꞌunai Godi nomon, nawalapa basef buꞌwafi Godi. Owaꞌ amom pris dembami maloma anom dembami daiam magawalipasa muꞌuli Godi maloma agufumi amom Judai mafiꞌmai anen. ");
INSERT INTO aoj_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Eaꞌ mahaliꞌana maꞌi, “Inaꞌ niꞌipafa. Inaꞌ nandaꞌ maol inimba ma banagami amimi? Ami naꞌipina deiꞌ nape dembinai nandaꞌ maol inimba?” ");
INSERT INTO aoj_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Jisas nagwamama basef naꞌi, “Aeꞌ wapani aꞌi ihaliꞌipama anif basef, piꞌipif. ");
INSERT INTO aoj_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Maol Joni nagapisiꞌ amam nematawa embeli, God nagape heveni naꞌipana napisiꞌas aꞌa anin epen itapani naꞌipana?” ");
INSERT INTO aoj_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Owaꞌ amom mameꞌ basef ifimba mandaꞌipama maꞌi, “Afaꞌ iꞌi ugaꞌi, ‘God nagape heveni nagaꞌipa Jon nagapisiꞌasi’, naꞌamba atiasi anen aꞌ niꞌi, ‘Deiꞌ maina ipaꞌ owaꞌ pegahapifanaea?’ ");
INSERT INTO aoj_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Apaꞌ afaꞌ iꞌi ugaꞌi, ‘Anin epen nagape itapani nagaꞌipana’, naꞌamba esis amam nematawa hiasi aꞌ sohafa. Deiꞌ main, hiasi saꞌi Jon anona profet.” ");
INSERT INTO aoj_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Eaꞌ magwamana basef Jisas maꞌi, “Afaꞌ owaꞌ ogawama.” ");
INSERT INTO aoj_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Eaꞌ Jisas naꞌipam naꞌi, “Eaꞌ naꞌamba atin aeꞌ ina iꞌipipa ma ami naseꞌe banagami naꞌipi andaꞌ maol inimba aeꞌani, owaꞌ.” ");
INSERT INTO aoj_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Jisas naꞌipasa basef ifimba waminif atini esis amam nematawa naꞌi, “Anona aman nandaꞌ anof aof nagawa waina. Eaꞌ nakwahomam aof afamba anom amam maꞌi mondaꞌ maolafa bisnisi. Eaꞌ nafeꞌ napani nogota lautai anambel wambel lauguni. ");
INSERT INTO aoj_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Ama nogota saꞌutip pagailatai, anen kofagonama aof afambai nasapaꞌ anona nandaꞌ maoli nafeꞌma amom mandaꞌ maol aof ananifii. Anen naꞌi amom mosoꞌana anip saꞌutip gwaꞌaipi ma aof afamba. Owaꞌ amom mahana maliꞌamonana notanima nafeꞌ dowaf. ");
INSERT INTO aoj_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Eaꞌ kofagonama aofi nasapaꞌ anona daiana nafeꞌ wapani ma amom, owaꞌ mahana wapani mandaꞌana aona matofana nafeꞌ dowaf. ");
INSERT INTO aoj_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Eaꞌ nasapaꞌ anona daiana nagafeꞌma wanifi. Owaꞌ amom mahana makwahona nawis naꞌoh andoꞌ. ");
INSERT INTO aoj_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","“Eaꞌ anen kofagonama aofi naꞌi, ‘Aeꞌ ataꞌ endaꞌ main? Nogame aeꞌinai aman, aeꞌ okom magamagailanai, aꞌ esapaꞌana nofoꞌo. Atiasi memeꞌ malogol ananigili aꞌa owaꞌ?’ ");
INSERT INTO aoj_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","“Eaꞌ amom mati nogamana nafiꞌi, mandaꞌipama atin maꞌi, ‘Aman anamba anaf nanumba owagama nogofaꞌ hiahaom hiami ahamanai. Awi, aꞌ ohana ma afaꞌ atofa ogofaꞌ aof afaꞌe.’ ");
INSERT INTO aoj_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Eaꞌ mahana makwahona mawisi aof andeꞌefa, mahana afuna. Eaꞌ atiasi kofagonama aof afambai nondaꞌ maina amom? ");
INSERT INTO aoj_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Atiasi nifiꞌi noham afum hiꞌilam, nosoꞌasa aof afamba fefeꞌma anis epes daias.” Esis sameꞌ basef ifimba saꞌi, “Waf afamba awafi endilisi. Afaꞌ wandaiwaꞌmafi.” ");
INSERT INTO aoj_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Owaꞌ Jisas natiti esis naꞌipas naꞌi, “Daoꞌ, eaꞌ naꞌamba atin siꞌi basef ifimba fagape Baibeli fagaꞌi, ‘Otam amamba amom mandaꞌ maoli magaliꞌamonami, deiꞌ aꞌ mataga luꞌum mombaloꞌ ipat atamba.’ Basef ifimba kofagefa faꞌi main? ");
INSERT INTO aoj_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Epes mamahisa kwahogalas sogowa otam anambai, atiasi a pepeꞌetas hiꞌilas. Apaꞌ iꞌi otam anamba nowa nogasaliꞌas, aꞌ loloweas siꞌi sopof atof.” ");
INSERT INTO aoj_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Eaꞌ amom dembami magawalipasa muꞌuli Godi maloma amom pris dembami mameꞌ basef ifimba waminif atini Jisas nagaꞌiefi, maꞌi owaꞌ anen nondolaꞌwaifa amom. Eaꞌ deiꞌ atef maꞌi mohapila Jisas mowaꞌana. Apaꞌ owaꞌ, ombal bahama esis amam nematawa. ");
INSERT INTO aoj_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Eaꞌ mandaꞌana naep diꞌindiꞌana ma mombaloꞌana mogofaꞌana. Eaꞌ masoꞌam anemba otamba anom amam masapaꞌam mafiꞌi magatolonai. Amam amamba mandaꞌ uhuf mambasoꞌam maꞌi amom mandaꞌ waf endilisifii. Apaꞌ owaꞌ amom maꞌi mombaloꞌ Jisasa anif basef nagaꞌiefi ma mosoꞌ anen nogafeꞌma gavman dembinai ma nondaꞌ kotimana. ");
INSERT INTO aoj_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Eaꞌ mahaliꞌ Jisas maꞌi, “Tisa dembinai, apaꞌ mogawena basef ineꞌifi buꞌwafi atif nagaꞌipasef esis amam nematawai. Inaꞌ naꞌi basef atififa epes isimba hiasi agufisi saloma isimba agof akasi naꞌamba atin hiꞌalas. Inaꞌ naꞌipas basef faloma waf buꞌwasi Godi endilisi ma epes hiasi. ");
INSERT INTO aoj_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Muꞌuli apeꞌini naꞌias naꞌimama? Apaꞌ mogasoꞌana takis Sisar gavman dembinai esis Romi aꞌa owaꞌ?” ");
INSERT INTO aoj_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Apaꞌ Jisas nogawa eaꞌ ma basoꞌam amamunai. Eaꞌ naꞌipam naꞌi, ");
INSERT INTO aoj_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Ipaꞌ pihimbaꞌme anin moni ma ataꞌ itilin. Ambal laloma agol isimba sagaili amisi?” Eaꞌ maꞌi, “Isimba gavman dembinai Sisari.” ");
INSERT INTO aoj_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Eaꞌ nagwamam naꞌipam naꞌi, “Daoꞌ, hiahawes dembinai Sisari, isimba peseꞌanas Sisar. Apaꞌ hiahawes Godi, peseꞌanas God.” ");
INSERT INTO aoj_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Eaꞌ amom ina laꞌifima mogombaloꞌana ma anif basefa naep esis amam nematawa hiasii, owaꞌatin. Amom nomonas sape salasafeꞌma basef ifimba nagaꞌipamafi, eaꞌ masopama malogof tol mape. ");
INSERT INTO aoj_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Anom anep miniꞌap Sadyusi mafiꞌmai Jisas. Amom miniꞌap apamba mahapila basef ifimba maꞌi sagagaꞌi ina atiasi sotanima sosafel wapani, owaꞌatin. ");
INSERT INTO aoj_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Eaꞌ mahaliꞌana maꞌi, “Dembinai tisa, fowaꞌ Moses nandaꞌ anif basef fail buki ma apaꞌ faꞌi, ‘Iꞌi anona aman nogaꞌ ma anen awasi akana, wauluꞌmana ataꞌ kope owamana ananinai aꞌ nosoꞌakwa nola anis awasi sogahaꞌofana.’ ");
INSERT INTO aoj_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Anaf nemaf anom wambota atotota 7-pelaim mape. Nagaliꞌi sahomam nasoꞌakw awani akaꞌw nagaꞌ nakwahoꞌw kwape. ");
INSERT INTO aoj_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Eaꞌ owamana nandatuꞌunai nafelaꞌw nasoꞌakw. ");
INSERT INTO aoj_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Eaꞌ owamana nandatuꞌunai wapani nandaꞌas naꞌamba atin, eaꞌ anona nandatuꞌumi nasoꞌakw mandaꞌas naꞌamba atin mafeꞌ matagama owagufunai akutainai. Amom amamba ambipim 7-pelaim ina mola anis awasi, owaꞌ mandagaꞌ atin. ");
INSERT INTO aoj_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Ama main, nemataꞌw wauluꞌmam kwagiꞌmam kwagiꞌ kwagaꞌ. ");
INSERT INTO aoj_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Eaꞌ anaf esis sagagaꞌi sogosafel wapani, nemataꞌw akwamba kope nemataꞌw amiꞌwi? Amom 7-pelaim aꞌ masoꞌakw kwape wauluꞌmam amamuꞌwi.” ");
INSERT INTO aoj_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Eaꞌ Jisas naꞌipam naꞌi, “Amam nematawa nogota ataꞌaisi deiꞌ sandasoꞌama. ");
INSERT INTO aoj_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Apaꞌ epes mamahisa God naꞌi andeandeꞌma sotanima sogosafel wapanima sogape namisi nemaf afamba, ina sondasoꞌama, aꞌ owaꞌatin. ");
INSERT INTO aoj_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Esis ina sogaꞌ wapani, owaꞌ. A sope siꞌi amom ensel Godi. God nosaꞌmas sosafel wapani wandof. Eaꞌ asope awasi ananisi. ");
INSERT INTO aoj_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Basef ifimba ma esis sagagaꞌi sotanima sogosafel wapani, ifimba fowaꞌ Moses nihimbaꞌmepaef nif ileliwa wataga lawag saꞌugai fagandogai, faꞌi anen nofala Dembinai naꞌi God Abrahami, God Aisaki, a God Jekopi. ");
INSERT INTO aoj_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Apaꞌ God ina Dembinai ma epes isimba sagagaꞌii, owaꞌatin. Anen Dembinai ma epes isimba sagape namisii. Deiꞌ main, epes hiasi sape namisa naep Godi hiꞌalas.” ");
INSERT INTO aoj_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","40","Jisas naꞌias naꞌamba, amom dembami magawalipasa muꞌuli Godi ombel mahama mogahaliꞌana ma anif basef wapani. Eaꞌ anom magwamana basef maꞌi, “Dembinai Tisa, inaꞌ naꞌias andeandeꞌ.” ");
INSERT INTO aoj_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Aꞌi owaꞌ main, Jisas naꞌipam naꞌi, “Amom maꞌi Krais, Devit akunamana God nasapaꞌana nagafiꞌii. Maꞌi Krais aman atona dowaf falafunai siꞌi epes sagape itapi. Deiꞌ maina amom magaꞌias naꞌamba ma Krais? ");
INSERT INTO aoj_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Buk akwamba Sami Devit nagaꞌi naꞌamba naꞌi, ‘Dembinai God naꞌipa Dembinai aeꞌanai naꞌi, “Inaꞌ nepe lagol kwahisigili aeꞌagili, ");
INSERT INTO aoj_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","atapina nefeꞌ netagama anaf aeꞌ endaꞌ bousi ineꞌisi sogafeꞌ lafelena siꞌi sia boꞌwagah ineꞌigahi hogataoma.”’ ");
INSERT INTO aoj_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Devit fowaꞌ nofala Krais naꞌi anen Dembinai. Isimba atis Krais ina aman atona falafunai, owaꞌ. Anen Dembinai.” ");
INSERT INTO aoj_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Amam nematawa hiasi ataꞌ sape sameꞌ basef ifimba atin, Jisas naꞌipa alipumi ananimi naꞌi, ");
INSERT INTO aoj_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Ipaꞌ silisilawi pepoma amam amamba dembami magawalipasa muꞌuli Godi. Amom maꞌi mondawisa luwagwif fasifi atif mondafeꞌ, siꞌi dembami atom mandawisafi. Maꞌi anis epes daias sotolom sondalalamam sondaꞌmam nemaf buꞌwafi siganifelom anamba luꞌwagoma ma naep hiasi sandatama sagapoma ma sogasaꞌma agof amamugufi luꞌwagof. Eaꞌ amom ukup paꞌi siaifah isimba sotawa sagaliꞌi atis, dembami atom magapoma, nomon ifagw esis Juda hiasi sandakolasugwi aꞌa anamba hiasi sandakolas nimaguf ifimba sandaꞌ gwaꞌaimi luꞌwami. ");
INSERT INTO aoj_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Amam amamba magawis ifagw agwamba nematawa alifiwaii, mandaꞌ wala hiahawes awousi. Eaꞌ mandabeten launai atona dowadowafa esis sotolom sigaꞌi amom buꞌwami. Anaf God nowaloga epes hiasi. Anis epes daias owaꞌ sondaꞌ waf awafi naꞌambaia anaf sofaꞌ akafimi kwasakwasala, apaꞌ amom mofaꞌ nimanimi awami luꞌwami endilisi aꞌowaꞌ.” ");
INSERT INTO aoj_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Jisas nape ipat luꞌunai Godi natologon tulif nati anis epes moni hianaisi sakwaha moni newala bokis moni nagalasi ma sogasoꞌ God. ");
INSERT INTO aoj_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Eaꞌ nati anoꞌw nemataꞌw alifiꞌwi kwala moni saꞌwini siꞌi 2 toea newala bokis isimba. ");
INSERT INTO aoj_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Eaꞌ naꞌi, “Aeꞌ aꞌipipa endilisi, nemataꞌw akwamba alifiꞌwi kwaꞌwaha moni luꞌwani nikilaꞌ otamba hiambai esis amam nematawa hiasi sagalambai. ");
INSERT INTO aoj_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Epes isimba hiasi moni hianai naꞌomas sakwaha duꞌwanin atin newala bokis. Apaꞌ nemataꞌw akwamba moni akaꞌw endilisi kwaꞌwaha moni akoꞌwini hiꞌalan. Eaꞌ owaꞌ anin neꞌeha kogatala gwaꞌaisia, aꞌ owaꞌatin. Eaꞌ moni akoꞌwini biafin saꞌwini aꞌ nikilaꞌ moni hiani esis sagalani.” ");
INSERT INTO aoj_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Anom alipumi Jisasi maꞌi basefa ipat luꞌunai Godi maꞌi, “Esis sofaloꞌma ipat anamba otamba fasifasimi hiahaom fasimi esis amam nematawa sagasoꞌanam Godi.” Eaꞌ Jisas naꞌi, ");
INSERT INTO aoj_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Hiahaom amamba deiꞌ pagatulumi, anef nemaf dondoꞌafi fegataga, ina atiasi anemba otamba bendatomama atin banagemba bepe, owaꞌatin. Asugulatam sowalom hiꞌilam mofeꞌ moꞌoh atona atin hiꞌilam.” ");
INSERT INTO aoj_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Eaꞌ mahaliꞌana maꞌi, “Dembinai Tisa, nemaf mamahefa amamba motaga? Ametal mamahina niliꞌ netaga ma afaꞌ ogogawa amamba felefeleꞌ mogataga?” ");
INSERT INTO aoj_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Jisas naꞌi, “Ipaꞌ sisilawe pendape. Naꞌamba anis epes sombasoꞌmepa. Epes hiasi atiasi sifiꞌi siꞌi agol aeꞌagili siꞌi, ‘Aeꞌ eaꞌ maꞌuwi.’ Eaꞌ anis siꞌi, ‘Deiꞌ nemaf eaꞌ fafiꞌi felefeleꞌ eaꞌ.’ Apaꞌ kwawiaꞌ, ipaꞌ ina pefeꞌ pila esis, owaꞌi. ");
INSERT INTO aoj_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Anef nemaf pemeꞌasa basefa wandaf luꞌwafi hiafi eaꞌ anis siꞌi sondaiwaꞌma amom gavman dembami mumafias sondaꞌ wandaf. Nemaf afamba ipaꞌ ina ombal mehepa, owaꞌi. Hiahaom amamba ataꞌ miliꞌ motaga, apaꞌ nemaf akutaifi ina fetaga kwafalis, ataꞌ owaꞌ.” ");
INSERT INTO aoj_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Eaꞌ naꞌipam naꞌi, “Anis epes sagape anip itap daiapi sofela wandaf sopaꞌ soloma esis sagape anep itap daiapi. Anona aman dembinai king noꞌwa anis walemb hielimbi ananisi sopaꞌ soloma anona dembinai king daiana noꞌwa ananisi analemb walembi. ");
INSERT INTO aoj_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Anaf imauna luꞌwani aꞌ notaga itap hiagoma. Anagon daiagon nolom luꞌuna notagamas, eaꞌ aowas luꞌunai notaga walemb hiagoma. Esis atiasi siti gani ilif ametal luꞌunai nogatagama hiahaom mamimami mondaꞌ epes ombel mogahahas endilisii. ");
INSERT INTO aoj_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Apaꞌ hiahaom amamba hiami ina aꞌ motaga ulal, ataꞌ owaꞌ. Esis asiliꞌ sombaloꞌ ipaꞌ pahapifi pagaila basef aeꞌafii. Eaꞌ sondaꞌepa kwapeteꞌepa sohambombagepa. Sondaꞌmepa kot nomon ifagw esis Juda sandakolasugwi sondaꞌepa pendaꞌ kalabus. Eaꞌ sofaꞌepa pefeꞌ sohaponepa pilutu nogohnaep amom king moloma gavman dembami. ");
INSERT INTO aoj_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Sondaꞌmepa waf afambai siꞌi anoꞌw ufiaꞌwa pewalapa basef buꞌwafi pigaꞌipasef. ");
INSERT INTO aoj_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Eaꞌ ipaꞌ pihapila nomonas ipeꞌisi sope banages, ama ipaꞌ ina ukup pepoma anif basef piꞌi pegagwamasef ulal, owaꞌi. ");
INSERT INTO aoj_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Deiꞌ main, atiasi aeꞌ atowe endaꞌ basef fepe malogof ipeꞌigufi eseꞌepa gawa fasini ma bousi isimba ipeꞌisi ina aꞌ laꞌifisa sogagwa basef ifimba aeꞌ igasiꞌipafi, owaꞌ. ");
INSERT INTO aoj_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Ahasepa mamasepa sahin owan ambeh esimbel atis ipeꞌisi soloma alipisi, esis wapani atiasi sowalapepa ma bousi ipeꞌisi. Eaꞌ asoha anipa pegaꞌ. ");
INSERT INTO aoj_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Atiasi epes hiasi walemb hiagoma nelelemb numbutima ipaꞌ kwapeteꞌ endilisi. Esis sati ipaꞌ pagaila basef aeꞌafii, naꞌamba deiꞌ sahepa. ");
INSERT INTO aoj_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Apaꞌ ipaꞌ ina atiasi pegaꞌ, owaꞌatin. Ina anef awif atetef fagape balagah ipeꞌigahii higililif, owaꞌatin. ");
INSERT INTO aoj_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Ipaꞌ pepe banagepa ma anaf pegefaꞌ ambal namili.” ");
INSERT INTO aoj_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Nemaf afamba ipaꞌ pigati soldia hiami esis bousii sifiꞌi sogonauliꞌ Jerusalemafi, ipaꞌ aꞌ pegawa atiasi felefeleꞌma taun inimba luꞌwani negataga awen. ");
INSERT INTO aoj_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Nemaf afamba amam nematawa sogape itap luꞌwapi Judiai sofaꞌ sefeꞌ sondowasaꞌo halafutagw. Eaꞌ esis amam nematawa sagape nomona Jerusalemi sokwaha wambel ambalemba sofaꞌ sondafoꞌo laogon. Eaꞌ isimba sagape aofah wambel ambalembai, ina ataꞌ sofeꞌ suwis, owaꞌ. ");
INSERT INTO aoj_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Deiꞌ main, nemaf afamba God aꞌ nogwamasa awami isimba sondaꞌ waf awafii siꞌi basef hiafi fagail buk Baibeli fendawalap alihif hiꞌigalef. ");
INSERT INTO aoj_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Nematawa opafuwai waloma awamba awasi otaꞌasi ataꞌ sagaꞌ nomagof atogufi, aeꞌ aꞌi awo uwahipiwa endilisi ma nogota atamba ogameꞌ akafimi luꞌwami. Nimanimi amamba aꞌ luꞌum aꞌowaꞌ motaga itap apaꞌe ma nembel wandafunai Godi atiasi nogafeꞌma epes isimba. ");
INSERT INTO aoj_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Anis, bainagw mohas sogaꞌ. Anis, bousi sondaꞌ kalabusimas sofaꞌas sefeꞌ sope itap apaꞌe hiagoma hiꞌilagon. Eaꞌ epes isimba sogolalama Godi aꞌ sotaga sofaꞌasa wambel ambalemba Jerusalem boꞌwagah asasigahi sumafiagon. Eaꞌ sope atapis sofeꞌ naꞌamba atina nemaf God nandandepafi ma nogota asasitai hiꞌigalata. ");
INSERT INTO aoj_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Atiasi ametal hianai notagama awin alipini owambini neloma ondowa. Ama itap apaꞌe amam nematawa hiasi sagape anep itap luꞌupai bololas endilisi. Esis ombal mohas kwapeteꞌ ma naoh luꞌwami mohafel luꞌum mutuwi mondaꞌam lilatin eaꞌ sowa solopam. ");
INSERT INTO aoj_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Eaꞌ ondowa maim magape gani ilifi mondakotoꞌ bolatin fiꞌifeꞌ mope. Eaꞌ esis amam nematawa hiasi ombal mohas kwapeteꞌ sowa soꞌoh itap siꞌi sagagaꞌi. Esis ukup pepoma hiahaom amamba maꞌi mogataga itap apaꞌe. ");
INSERT INTO aoj_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","“Aeꞌ ataga epen egefaꞌ alop epesi. Nogota atamba asiti aeꞌ iloma ilagw otaga ilif ifiꞌi iloma hiahaom mogogalaꞌi fasimi Godi moloma banagami ananimi. ");
INSERT INTO aoj_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Anef iꞌi hiahaom amamba mogataga, nemaf afamba ipaꞌ pilutu pesaniga pesaꞌma balagah ipeꞌigahi. Deiꞌ main, nemaf afamba felefeleꞌma fegataga God nogatagwahepa ma waf awafi ipeꞌifi nofaꞌepa pigatanimai.” ");
INSERT INTO aoj_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Jisas naꞌipasa basef waminif atin naꞌi, “Ipaꞌ piti lawag agamba fik goloma lawah hiagahi wapani. ");
INSERT INTO aoj_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Ipaꞌ piti ilaof nogonafa ma basowa, pegawa nogota atamba nelemb eaꞌ felefeleꞌma sogaof. ");
INSERT INTO aoj_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Eaꞌ naꞌamba atin, iꞌi ipaꞌ piti hiahaom amamba aeꞌ aliꞌ agaꞌipipami mogataga, ipaꞌ pegawa nemaf afamba God nope Dembinai nugumafi epes hiasi ananisi felefeleꞌma fegataga. ");
INSERT INTO aoj_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“Aeꞌ aꞌipipa endilisi, amam nematawa deiꞌ ataꞌ pagapani ina atiasi pegaꞌ ulal, ataꞌ owaꞌ, ipaꞌ eaꞌ piti hiahaom amamba hiami mogataga hiꞌigalam. ");
INSERT INTO aoj_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Otaga noloma itap hiagoma anaf aꞌ higililam hiꞌilam, apaꞌ basef aeꞌafi ina higililif, owaꞌatin endilisi. Fegape atapif lifilafii. Amom alipumi Jisasi solawaim andeandeꞌma mindihiꞌama waf hiafi awafi. ");
INSERT INTO aoj_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Aeꞌ ataga epen egefaꞌ alop epesi. Ipaꞌ solawaipa andeandeꞌma nemaf aeꞌ, igafiꞌafii. Naꞌamba pendaꞌ waf awafi pegalaga alop atopafi, peaꞌ embel banagami atom hiami aꞌ nomonas solasefeꞌ ma nimanimi mamimami itapami atom. Iꞌi waf afambai fisiꞌalipa hiꞌigalipa, atiasi nemaf afamba aeꞌ igafiꞌafii fetagamepa kwafalis atis siꞌi sakwaha wambawa sagaha mafis. ");
INSERT INTO aoj_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Nemaf afamba fegataga ma amam nematawa sagape itap hiagomai ganigani eaꞌ naꞌamba atin siꞌi wambawa ogofaꞌ mafis. ");
INSERT INTO aoj_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Dondol ufilu wafilu silisilawi pendape ma ina pendaꞌ waf awafi afambai, owaꞌ. Pepe pendabeten lifilafi ma God nogaseꞌepa pepel pigalutu banagepama pindihiꞌama hiahaom amambai maꞌi mogatagamipai. Ama pigalutu banagepa ma aeꞌ ataga epen egefaꞌ alop epesi inifaꞌepa egawalogepa.” ");
INSERT INTO aoj_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Nimaguf hiafi dondol Jisas nape atapina nawalipa esis amam nematawa ipat luꞌunai Godi nomon, apaꞌ owamb aꞌ nafeꞌ naꞌihi halafuta atamba Oliv. ");
INSERT INTO aoj_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Eaꞌ amam nematawa hiasi sosafel kuhukuhumbita atota safiꞌmai anona sogameꞌ basef ananifi ipat luꞌunai Godi atapis dondol. ");
INSERT INTO aoj_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Felefeleꞌ ma nemaf sondaꞌ gwaꞌaisi luꞌwasi esis Juda sogaꞌ bret owaꞌ togatef luꞌutaia. Sofalaf saꞌi nemaf buꞌwafi Pasova felefeleꞌ ma fegataga. ");
INSERT INTO aoj_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Amom pris dembami maloma dembami amamba magawalipasa muꞌuli Godi ombal mahama esis amam nematawa. Eaꞌ maꞌi, “Atiasi afaꞌ oha Jisas wiꞌimama?” ");
INSERT INTO aoj_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Eaꞌ Satan nawis nembel Judasi Keriotinai. Anen amom 12-pelaim alipumi Jisasi. ");
INSERT INTO aoj_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Anen nafeꞌma anom pris dembami maloma anom plisman dembami mape ipat luꞌunai Godi. Amom amamba maꞌi basef mandameꞌmaefa Judas nolaoma ufiaꞌwa nosoꞌama Jisas nogafeꞌ lagof amamugufi. ");
INSERT INTO aoj_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Eaꞌ sonaham maꞌi basef mandameꞌmaefa mogasoꞌana anemba otamba Judas. ");
INSERT INTO aoj_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Eaꞌ anen naꞌi ahoꞌma basef amamifi, aꞌ nalaꞌ nolaoma anoꞌw ufiaꞌwa nigihimbaꞌmama Jisas amoma mogombaloꞌana. Anen nape ma anef nemaf kwahufi ma owaꞌ anis amam nematawa sope soglomanafia. ");
INSERT INTO aoj_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Nemaf afamba fataga esis Juda saꞌi sondaꞌ anis gwaꞌaisi luꞌwasi seaꞌ anota bret owaꞌ togatifia. Afamba saꞌi soha anom sipsip hiami nogami ma sondaꞌ gwaꞌaisi isimba Pasova. ");
INSERT INTO aoj_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Jisas nasapaꞌ Pitai Jon naꞌipam naꞌi, “Ipaꞌ bipa pefeꞌ pendondombamafa gwaꞌaisi isimba Pasova ma afaꞌ ogwaꞌas.” ");
INSERT INTO aoj_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Eaꞌ amom mahaliꞌana maꞌi, “Inaꞌ naꞌi afaꞌ ofeꞌ ondondomba ipat anima?” ");
INSERT INTO aoj_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Eaꞌ naꞌipam naꞌi, “Pemeꞌ, ipaꞌ pefeꞌ piwis gani wambel luꞌwambili, atiasi piti anona aman nofaꞌ embel sospen luꞌunai nitilipa ufiaꞌw. Eaꞌ pigiꞌmana pefeꞌ piwis ipat atamba anen nefeꞌ nogawisatai. ");
INSERT INTO aoj_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Eaꞌ pihaliꞌ ahama ipat atambai piꞌi, ‘Dembinai afaꞌinai naꞌipafa naꞌi, ipat atamba esis sagaꞌohotai totawa ani? Anen naꞌi noꞌwa afaꞌ atofa alipufai ope ondaꞌ gwaꞌaisi isimba luꞌwasi Pasova.’ ");
INSERT INTO aoj_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Eaꞌ anen nihimbaꞌmepa rum amamba luꞌwami mape ilif, tebol siaifah saꞌoh atifis. Ipaꞌ pendondomba gwaꞌaisi rum amamba.” ");
INSERT INTO aoj_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Eaꞌ amom mafeꞌ mati hiahawes isimba naꞌamba atin siꞌi Jisas naliꞌ nagaꞌipamas eaꞌ mandondomba gwaꞌaisi isimba Pasova. ");
INSERT INTO aoj_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Nogota atataga ma sogaꞌ gwaꞌaisi isimba luꞌwasi Pasova, Jisas naoꞌwa alipumi ananimi mafiꞌi mape, anen nafeꞌ nape felefeleꞌma tebol ");
INSERT INTO aoj_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","naꞌipam naꞌi, “Aeꞌ aꞌi ataꞌ eaꞌ gwaꞌaisi isimba Pasova elomepa uliꞌ, ma bola efaꞌ akafimi luꞌwami. ");
INSERT INTO aoj_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Aeꞌ aꞌipipa endilisi, aeꞌ ina ataꞌ eaꞌ gwaꞌaisi isimba Pasova wapani, owaꞌ. Apaꞌ anef nemaf basefa gwaꞌaisi isimba Pasova kofagefa fetaga fendawalap alihif anamba God nagalaꞌambemagoma, daoꞌ eaꞌas wapani.” ");
INSERT INTO aoj_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Eaꞌ anen nasaꞌmai anop kap embel wain bagalapi nanifela God naꞌi, “Ipaꞌ saꞌma gwaꞌaisi isimba pendandamas. ");
INSERT INTO aoj_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Aeꞌ aꞌipipa, deiꞌ aꞌ anaf wapani aeꞌ ina atiasi iaꞌ embel wainimbel elomepa, owaꞌ. Ama anaf God nope Dembinai nugumafi epes hiasi soloma hiahaom hiami hiꞌigalam, daoꞌ aeꞌ aꞌ eaꞌ embel wain inimba wapani elomepa.” ");
INSERT INTO aoj_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Eaꞌ anen nafelai bret nanifela God nawalota nasoꞌam naꞌi, “Bret atamba alop aeꞌapi. Aeꞌ aseꞌepata ma egatopalopepa. Pendaꞌas atapisa ukup pegapoma aeꞌ.” ");
INSERT INTO aoj_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Amom maꞌasa hiꞌalas, aꞌi owaꞌ main, eaꞌ nandaꞌas naꞌamba atina anop kap embel wainimbel bagalapi, naꞌi, “Wain embel ambalemba amamba esimbel aeꞌambeli bewaꞌ banaga basef God nagalaꞌ lapafi dambaifi. Esimbel ambalemba aeꞌ ekoloꞌwambela egatopalopepa. ");
INSERT INTO aoj_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Apaꞌ ipaꞌ piti aman anamba naꞌi nogawalapa aeꞌ ma amom boumi aeꞌamii, nape naꞌ gwaꞌaisi nalome tebol iniꞌi. ");
INSERT INTO aoj_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Ahoꞌ, aeꞌ ataga epen egefaꞌ alop epesi, atiasi egaꞌ siꞌi ufiaꞌw fowaꞌ gani God nandandepaꞌwi. Apaꞌ aman anamba nogawalape ma amom boumii, aeꞌ ati uwahipina aꞌowaꞌ. Deiꞌ main, nimanimi akafimi luꞌwami aꞌ motagamana.” ");
INSERT INTO aoj_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Anen naꞌias naꞌamba, alipumi ananimi atom mandahahaliꞌma maꞌi, “Epen afaꞌini ami atiasi nendaꞌ waf afambai?” ");
INSERT INTO aoj_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Amom alipumi Jisasi maꞌi anif basef mafitapef maꞌi, “Ami nepe dambeni afaꞌini?” ");
INSERT INTO aoj_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Eaꞌ Jisas naꞌipam naꞌi, “Amom king dembami esis hiasi sagape anep itap luꞌupai, mape dembami asasimi mandaꞌas kwapeteꞌas. Amom banagami mumafi esis banagambel, eaꞌ maꞌi esis sofalam agof fasigufi siꞌi mandaꞌ waf fasifi mogatopalopasi. ");
INSERT INTO aoj_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Apaꞌ ipaꞌ ina pendaꞌas naꞌamba, owaꞌi. Aman ami niꞌi nogape aꞌ dembinai ma ipeꞌi, anen ataꞌ nope siꞌi amamba agof akami siꞌi isimba sandaꞌ maoli ma sogatopalopepa. ");
INSERT INTO aoj_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Epen ami dambeni nikilaꞌ anis daias? Epen natoma nagaꞌ gwaꞌaisi teboli aꞌa epen nandaꞌ gwaꞌaisi nefaꞌas nagafiꞌmanaii? Apaꞌ aeꞌ ape laꞌafena ipaꞌ siꞌi nandaꞌ maoli ma egatopalopepa. ");
INSERT INTO aoj_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Fowaꞌ hiahaom amamba magagwamba aeꞌi, nimaguf ifimba ipaꞌ pape pagalome, ipaꞌ ina pakwahowe, owaꞌatin. ");
INSERT INTO aoj_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Ahame aeꞌanai naseꞌe agol luꞌwagili naꞌipi ape dembiwai, eaꞌ naꞌamba atin aeꞌ eseꞌepa agof luꞌwagufi iꞌipipa pepe dembipai king. ");
INSERT INTO aoj_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Nemaf afamba ipaꞌ aꞌ pepe dembipai king peloma aeꞌ peaꞌ gwaꞌaisi embel pelome tebol aeꞌani anamba God nagalaꞌambemagoma. Eaꞌ pepe siaifah fasimi amom dembami kingi, pewawaloga misiꞌah 12-pelaih amam nematawa apeꞌisi Israel.” ");
INSERT INTO aoj_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Eaꞌ Jisas naꞌi, “Saimon, Saimon, inaꞌ nemeꞌ. God naꞌi ahoꞌma Satan nogwamba ipaꞌ ma pendaꞌ waf awafi siꞌi sogogakisa rais ama buꞌwami mafeꞌ anagon awami magafeꞌ anagon daiagon. ");
INSERT INTO aoj_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Apaꞌ owaꞌ atin. Aeꞌ andabetena egatopalopena ma banagena nigahapifa aeꞌ atapina. Atiasi nembema nembel newaꞌ banaga owapena ineꞌimi.” ");
INSERT INTO aoj_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Owaꞌ Pita nagwamana naꞌipana naꞌi, “Dembinai, aeꞌ eaꞌ andaꞌas dumbulidombola elomena ogafeꞌ kalabus. Aeꞌ andaꞌas dumbulidombola egaꞌ egalomena wapani.” ");
INSERT INTO aoj_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Eaꞌ Jisas nagwamana basef naꞌi, “Pita, aeꞌ aꞌipina endilisi! Atiasi owamb ambaꞌe awata ataꞌ owaꞌ totaea, inaꞌ aꞌ nendahaliꞌmi niꞌias wanif niꞌi, ‘Aeꞌ owaꞌ egawa Jisasa.’” ");
INSERT INTO aoj_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Eaꞌ Jisas naꞌipa amom naꞌi, “Fowaꞌ aeꞌ asapaꞌepa pandailagof pagafeꞌ, ipaꞌ ina pefaꞌ paos monisi saloma brasbeli su, owaꞌ. Pafeꞌ dowaf. Nemaf afamba anis hiahawes akepa aꞌa owaꞌ?” Amom magwas maꞌi, “Owaꞌatin.” ");
INSERT INTO aoj_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Eaꞌ Jisas naꞌipam naꞌamba naꞌi, “Apaꞌ deiꞌ aman ami paos monisi sagaꞌomanai anen aꞌ nofaꞌas. Eaꞌ brasbel wapani naꞌamba atin. Aman bainat akanai anen nosoꞌasa saket ananitai anis sotalota, notala anota bainat. ");
INSERT INTO aoj_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","“Deiꞌ main, anif basefa aeꞌ felefeleꞌma fetaga fendawalap. Anif basef fagail Buk Baibeli fowaꞌ fagaꞌias naꞌamba faꞌi, ‘Esis nomonas sondandaꞌme siꞌi aeꞌ aman auwai atowe.’ Aeꞌ aꞌipipa endilisi! Basef ifimba felefeleꞌ fetaga endilisi ma nimanimi akafimi waf awafi atiasi mogataga ma aeꞌi.” ");
INSERT INTO aoj_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Eaꞌ alipumi ananimi maꞌi, “Dembinai, inaꞌ niti. Afaꞌ bainagw biagw agwaꞌe.” Eaꞌ nagwamam naꞌipam naꞌi, “Eaꞌ amamba.” ");
INSERT INTO aoj_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Eaꞌ Jisas nakwaha taun nawis andoꞌ aꞌ nafeꞌ halafuta Oliv, siꞌi dondol nandaꞌas. Eaꞌ alipumi ananimi magiꞌmana mafeꞌ. ");
INSERT INTO aoj_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Anen nataga naꞌamba naꞌipam naꞌi, “Ipaꞌ pendabetena hiahaom nogagwamba ipeꞌi ina aꞌ motagamepa, owaꞌ.” ");
INSERT INTO aoj_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Eaꞌ nakwaha amom nindisiꞌah nafoꞌo kwasakwasala, nogota bandata siꞌi aman nakwaha anom otam mafeꞌ mogatambela. Eaꞌ nindiwa nembawa notawa nandabeten naꞌi, ");
INSERT INTO aoj_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Ahame, iꞌi inaꞌ nigaꞌi awima, daoꞌ nekwahome kap apamba. Apaꞌ owaꞌ, inaꞌ nindaila okom ineꞌimi atom, aeꞌ owaꞌ.” ");
INSERT INTO aoj_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Eaꞌ anona ensel nafiꞌi heven nowaꞌ banagona. ");
INSERT INTO aoj_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Jisas nameꞌagama nimanimi akafimi eaꞌ aom endilisi, eaꞌ nandabeten banagambel aꞌowaꞌ, agwah mandona siꞌi esimbel magalo itap. ");
INSERT INTO aoj_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Anen nandabeten eaꞌ nosafel nafeꞌma alipumi ananimi. Owaꞌ nati amom ukup iwanipi pandaꞌam maꞌoh atin. ");
INSERT INTO aoj_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Eaꞌ naꞌi, “Deiꞌ maina ipaꞌ pagaꞌoh? Ipaꞌ safel pendabeten. Naꞌamba hiahaom mogogwambipai aꞌ mifiꞌi motagamepa.” ");
INSERT INTO aoj_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Jisas ataꞌ naꞌi atin, owaꞌ amam miniꞌap launai aꞌ mafiꞌi. Aman anamba sofalana saꞌi Judas, anen alipunai amom 12-pelaim Jisasi, nafiꞌi naliꞌai amom. Anen nafiꞌi felefeleꞌma Jisasa nogasisiꞌ dalogw ananigwi. ");
INSERT INTO aoj_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Owaꞌ Jisas naꞌipana naꞌi, “Judas, aeꞌ ataga epen egefaꞌ alop epesi. Inaꞌ nasisiꞌi nihimbaꞌma amom boumi aeꞌami, aꞌa?” ");
INSERT INTO aoj_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Alipumi ananimi mape malomana mati amom boumi Jisasi maꞌi mohana eaꞌ mahaliꞌ Jisas maꞌi, “Dembinai, inaꞌ naꞌi afaꞌ oham bainagw?” ");
INSERT INTO aoj_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Owaꞌ anona amom alipumi ananimi naha anona aman nandaꞌmana maola pris dembinai nape nagaliꞌma pris hiamii eaꞌ natopaꞌ aliga kwahisigai peleꞌataga gowa. ");
INSERT INTO aoj_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Owaꞌ Jisas nataloga amom naꞌi, “Kwaha waf afambai, eaꞌ hapaifi.” Eaꞌ Jisas nasa lagol aliga aman anambai, gataga boꞌoga wapani. ");
INSERT INTO aoj_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Eaꞌ Jisas naꞌipa agufumi maloma amom pris dembami maloma amom dembami mugumafi polisman hiamii ipat luꞌunai Godi, mafiꞌi maꞌi mogombaloꞌanai. Naꞌi, “Ipaꞌ pefaꞌi bainagwi belep pafiꞌi siꞌi paꞌi pegewaꞌ anona aman nandaꞌ wali aꞌa? ");
INSERT INTO aoj_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Nimaguf hiafi dondol aeꞌ ape alomepa ipat luꞌunai Godi awalapa basef buꞌwafi ma esis amam nematawa hiasi apaꞌ ipaꞌ owaꞌ Pembaleꞌea. Apaꞌ deiꞌ nogota ataꞌe aꞌ nemaf ipeꞌifi. Deiꞌ banagami owamb akuti aꞌ mikilaꞌ.” ");
INSERT INTO aoj_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Jisas naꞌiasa eaꞌ amom mahapilana mofaꞌana mafeꞌ mawis ipat pris dembinaii. Apaꞌ Pita ina nalomam nafeꞌ atef, owaꞌ, nagigiꞌmam nafeꞌ nail laogon. ");
INSERT INTO aoj_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Esis sakata nif indalelemb ambalemba nomon ipat tagapoma mapomef. Eaꞌ Pita nape nalomam. ");
INSERT INTO aoj_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Anoꞌw nemataꞌw kwandaꞌ maoli kwati anen napoma nif. Eaꞌ kwatotolona kwaꞌi, “Aman anamba wapani anen nape nagaloma Jisasi.” ");
INSERT INTO aoj_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Apaꞌ Pita naꞌi, “Ahaeꞌ, aeꞌ owaꞌ.” Anen naꞌi, “Nemataꞌw, aeꞌ ina egawa anen, owaꞌ.” ");
INSERT INTO aoj_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Aꞌi owaꞌ nogota laota kwasala, anona aman nati Pita naꞌi, “Inaꞌ wapani inaꞌ aman miniꞌap amamipi.” Owaꞌ Pita naꞌi, “Ahaeꞌ, aeꞌ owaꞌ.” ");
INSERT INTO aoj_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Aꞌi nogota laota kwasakwasala tafeꞌ owaꞌ, anona aman daiana naꞌi banagambel naꞌi, “Endilisi atis, aman anamba wapani nape nagaloma anini. Deiꞌ main, anen wapani Galilinai atona.” ");
INSERT INTO aoj_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Owaꞌ Pita nagwamana basef naꞌi, “Ahaeꞌ, aeꞌ owaꞌ egawa basef ifimba ineꞌifia.” Anen ataꞌ naꞌias naꞌamba atin, owaꞌ awata aꞌ tata. ");
INSERT INTO aoj_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Eaꞌ Dembinai nandambema aꞌ natiti Pita, owaꞌ okom Pitai mandandaꞌ ma basef ifimba dokoꞌ Dembinai naꞌipanafi nagaꞌi, “Owamb ambaꞌe awata ataꞌ owaꞌ totaea, inaꞌ atiasi aꞌ nembasoꞌmas niꞌias wanif niꞌi, ‘Inaꞌ owaꞌ negawea.’” ");
INSERT INTO aoj_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Eaꞌ Pita nawisi nafeꞌ andoꞌ nalef mehip. ");
INSERT INTO aoj_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Amom mugumafi Jisasi mandaꞌ anen findiwana mahana. ");
INSERT INTO aoj_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Amom mapeteꞌ anef lowaf mambahoꞌmana naep mahaliꞌana maꞌi, “Inaꞌ niꞌi basef profeti newalapa ami nagahinai.” ");
INSERT INTO aoj_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Eaꞌ mandaꞌ basef hiafi daif awafi wapani ma anen. ");
INSERT INTO aoj_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Ama awin natafi amom agufumi dembami esis Judai maloma amom pris dembami maloma anom dembami magawalipasa muꞌuli Godi, amom hiami mondowaꞌanima mape. Eaꞌ mofaꞌ Jisas mafiꞌmai amom mahaliꞌana maꞌi, ");
INSERT INTO aoj_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","“Inaꞌ niꞌipafa. Inaꞌ Krais, God nandandepena nasapaꞌena nagafiꞌii aꞌa owaꞌ?” Eaꞌ nagwamam naꞌipam naꞌi, “Iꞌi aeꞌ igaꞌipipa, ina atiasi pihapifi. ");
INSERT INTO aoj_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Eaꞌ iꞌi igahaliꞌipa ma anif basef, ipaꞌ ina pegwa basef aeꞌafi, owaꞌ. ");
INSERT INTO aoj_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Eaꞌ deiꞌ aꞌ anaf gani owagama wapani aeꞌ ataga epen egefaꞌ alop epesi egape waꞌol lagol kwahisigili Godi banagagili.” ");
INSERT INTO aoj_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Eaꞌ amom hiami maꞌi, “Deiꞌ inaꞌ aꞌ God Nogamana aꞌamon?” Anen nagwamama basef naꞌi, “Ipaꞌ paꞌias eaꞌ maꞌwis.” ");
INSERT INTO aoj_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Eaꞌ amom maꞌi, “Afaꞌ waꞌi ataꞌ omeꞌ basef mamahifa wapani? Owaꞌ. Malogol ananigili atogol eaꞌ gaꞌi basef ifimba afaꞌ wameꞌef eaꞌ.” ");
INSERT INTO aoj_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Eaꞌ amom dembami hiami mosafel mofaꞌ Jisas mafeꞌma dembinai gavman Pailat. ");
INSERT INTO aoj_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Eaꞌ maꞌi masapagana mandaꞌmana basef maꞌi, “Afaꞌ wati aman anamba nandaꞌ waf awafi nasaꞌma ukup epes hiasii ma sondaꞌ wandaf sogaloma gavman. Anen nandaiwaꞌma mogasoꞌana takis gavman dembinai Sisar eaꞌ naꞌipapa naꞌi anen atona anona dembinai king Krais.” ");
INSERT INTO aoj_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Eaꞌ Pailat nahaliꞌana naꞌi, “Inaꞌ king dembinai Judai aꞌa owaꞌ?” Eaꞌ Jisas nagwamana basef naꞌi, “Basef ifimba inaꞌ nagaꞌiefi endilisifi.” ");
INSERT INTO aoj_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Eaꞌ Pailat naꞌipa amom pris dembami maloma esis amam nematawa hiasi naꞌi, “Aeꞌ ina ati anis maefah awasi, owaꞌ. Ina ati anef waf awafima aman anamba endaꞌmana anif basef, owaꞌ.” ");
INSERT INTO aoj_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Owaꞌ amom mandaꞌmana basef Jisasi maꞌipana banagambel maꞌi, “Anen nasoꞌasa basef esis amam nematawa hiasi sosafel banages saꞌi sondaꞌ wandafa ganimba walemb hielimbi Judia. Anen nandaꞌi maol gani itap luꞌupa Galili eaꞌ nafiꞌi nataga naꞌa.” ");
INSERT INTO aoj_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pailat nameꞌ basef ifimba sagaꞌifa anini ma nandaꞌ maol nagafeꞌagon hiꞌalagon anamba hiagoma itap apamba Galili eaꞌ nahaliꞌ amom naꞌi, “Aman anamba anen Galilinai aꞌa?” ");
INSERT INTO aoj_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Amom maꞌipana eaꞌ nogawa Jisas anen Galilinai gavman dembinai Herot nugumafiagoma. Eaꞌ Pailat nasapaꞌana nafeꞌma Herot. Nogota atamba Herot ataꞌ napani Jerusalem. ");
INSERT INTO aoj_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Herot nati Jisas asonahanamana aꞌowaꞌ. Anen nameꞌ basefa anen nogota lautai, eaꞌ naꞌi notolona. Anen nameꞌ basefa maol Jisas nandaꞌani eaꞌ naꞌi Jisas ataꞌ nondaꞌ anom banagami siꞌi God nandaꞌami ma ataꞌ notolom. ");
INSERT INTO aoj_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Eaꞌ Herot nahaliꞌanama hiahaom hiami. Apaꞌ Jisas ina nagwamana anif basef anen, owaꞌ. ");
INSERT INTO aoj_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Amom pris dembami maloma amom dembami magawalipasa muꞌuli Godi mafiꞌi malutu felefeleꞌ mandaꞌmana kot masapagana banagambel aꞌowaꞌ. ");
INSERT INTO aoj_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Eaꞌ Herot naoꞌwa amom soldia ananimi mandaꞌ Jisas findiwana ma basef awafi. Eaꞌ mofaꞌai anef lowaf fasifi mowahoꞌmanaf masapaꞌana notanima nafeꞌma Pailat. ");
INSERT INTO aoj_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Fowaꞌ Herot naloma Pailat mandaꞌ migimigahi, apaꞌ deiꞌ nemaf afamba aꞌ alipumi mandandomboma atogon. ");
INSERT INTO aoj_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Eaꞌ Pailat nofalai amom pris dembami maloma agufumi esis Judai maloma esis amam nematawa hiasi safiꞌi sandakolas. ");
INSERT INTO aoj_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Eaꞌ naꞌipas naꞌi, “Ipaꞌ faꞌai aman anamba paꞌi nasaꞌma ukup epes hiasii nahambombagasa sandaꞌ wandafi fiꞌmai aeꞌ. Dokoꞌ ahaliꞌana ma hiahawes isimba ma nogohnaep ipeꞌisi aꞌ pameꞌ. Aeꞌ ina ati anom maefah awami ma aman anamba ma hiahawes isimba ipaꞌ pandaꞌ basefasi, owaꞌ. ");
INSERT INTO aoj_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Dembinai gavman Herot wapani naꞌamba atin. Deiꞌ main, anen nasapaꞌana notanima nafiꞌmai apaꞌ. Ipaꞌ pegawa aman anamba ina nandaꞌ anin mae awani ma apaꞌ mohana nogagaꞌ, owaꞌatin. ");
INSERT INTO aoj_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Atiasi ehana atin ekwahona nefeꞌ wahifina.” ");
INSERT INTO aoj_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Apaꞌ waf esis Judai fagape naꞌamba. Afagof danda nemaf afamba sandaꞌ gwaꞌaisi isimba luꞌwasi Pasova gavman dembinai Pailat natagwahowa anona nandaꞌ kalabusi nafeꞌ wahifina ma esis. ");
INSERT INTO aoj_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Eaꞌ esis amam nematawa hiasi gigal saꞌoh naꞌamba saꞌi, “Ha aman anamba ma aꞌ nogaꞌ, eaꞌ tagwaha Barabas nifiꞌmai apaꞌ.” ");
INSERT INTO aoj_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Aman anamba Barabas anen napaꞌ nagaloma amom gavmani ma taun inimba luꞌwani eaꞌ naha epes hiasi sagaꞌ. Eaꞌ deiꞌ sandaꞌana nandaꞌ kalabus. ");
INSERT INTO aoj_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pailat naꞌi nokwahowa Jisas nefeꞌ wahifina, eaꞌ nahaliꞌas wapani. ");
INSERT INTO aoj_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Owaꞌ, soga saꞌi mehip saꞌi, “Hana nogaꞌ, hana nogaꞌ lawag usiꞌigai tiꞌwanaegai.” ");
INSERT INTO aoj_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Eaꞌ Pailat notambel nahaliꞌas wanif wapani naꞌi, “Deiꞌ nandaꞌ waf maif awafi? Aeꞌ ina ati anef waf awafi kofagefa fapoma aman anamba ma apaꞌ mohana nogagaꞌ, owaꞌatin. Aeꞌ iꞌipa amom soldia mopopagahana eaꞌ ekwahona nefeꞌ wahifina.” ");
INSERT INTO aoj_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Apaꞌ owaꞌ owaꞌatin, esis gigal saꞌoh mehip saꞌi anen nohana nondagaꞌ lawag usiꞌigai tiꞌwanaegai. Eaꞌ basef asasifi fapaꞌaga basef Pailati. ");
INSERT INTO aoj_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Eaꞌ Pailat nasopama malogol ananigili naila nomonas asasisi. ");
INSERT INTO aoj_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Aman anamba nandaꞌ wandaf nagaloma gavmani naha anis sagagaꞌi, sandaꞌana nape nandaꞌ kalabus, Pailat nakwahona nafeꞌmas wahifina. Esis saꞌipa Pailat saꞌi anen notanima nokwahona kalabus nifiꞌmai esis wapani, eaꞌ nagiꞌma nomonas asasisi nakwahona nafeꞌmas wahifina nasoꞌasa Jisas nafeꞌma esisa amom soldia mofaꞌana mofeꞌ mogahana. ");
INSERT INTO aoj_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Amom soldia mofaꞌ Jisas mafeꞌ eaꞌ mati anona aman Saimon, anen anop nomopunai anep itap Sairininai, napani alup nafiꞌi naꞌi nofeꞌ nuwis wambel taun luꞌwagoma. Eaꞌ molaepana masasapaꞌana nowandefa lawag agamba usiꞌigai tiꞌwanaegai ikaf ananifi nofaꞌaga nigiꞌma Jisas nogafeꞌ. ");
INSERT INTO aoj_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Eaꞌ anis amam nematawa hiasi safeꞌ sagiꞌmana a anowa nematawa wapani wafeꞌ walef windiwagef waꞌi uwahipigai ma anen. ");
INSERT INTO aoj_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Owaꞌ Jisas nandambema naꞌipawa naꞌi, “Ipaꞌ nematawa Jerusalamipai, ipaꞌ ina pelopa aeꞌ, owaꞌ. Ipaꞌ pendalopa ipaꞌ peloma awasi ipeꞌisi, andeandeꞌ. ");
INSERT INTO aoj_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Deiꞌ main, anef nemaf fegataga anis epes eaꞌ siꞌi, ‘Awo nematawa owaꞌ ataꞌ ogola awasia, eaꞌ awamba owaꞌ ogasoꞌ nomambeha awasia, awamba atiasi ope andeandeꞌ sonohawa.’ ");
INSERT INTO aoj_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Nemaf afamba esis asiꞌipa halafutagw siꞌi, ‘Ipaꞌ piwai pipaiꞌapa peseꞌalepa!’ Eaꞌ esis siꞌipa damotagw siꞌi, ‘Ipaꞌ soꞌalepa.’ ");
INSERT INTO aoj_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Deiꞌ esis sandaꞌ waf awafi ma lawag namugai. Apaꞌ atiasi lawag agamba gogataga aliaga, gope giꞌimama? ");
INSERT INTO aoj_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Eaꞌ amom soldia mofaꞌ amam biam mandaꞌ waf awafii maꞌi moham mogaꞌ moloma Jisas. ");
INSERT INTO aoj_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Eaꞌ safeꞌ sataga anagon sofalagon sagaꞌi Pipitagol Balagaigil. Anamba amom soldia magandola Jisas lawag usiꞌigai tiꞌwanaegaima. Eaꞌ mandola anom biam mandaꞌ waf awafii mandaꞌ wali mandolam mail waꞌowaꞌol Jisas nail laꞌafen. ");
INSERT INTO aoj_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Eaꞌ Jisas naꞌipa God naꞌi, “Ahame, inaꞌ nekwahowa waf awafi amom mandaꞌmeaf aeꞌi, okom moseꞌenaf. Amom ina mogawa andeandeꞌ hiahaom amamba mandaꞌmeam aeꞌi, owaꞌ.” Eaꞌ mandaꞌ satu ma luwaguf maim ananimi ma ami nigikilaꞌi mofaꞌef mondondamef atona atin. ");
INSERT INTO aoj_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Eaꞌ esis amam nematawa salutu sape satolona sameꞌ amom agufumi esis Judai mandaꞌ salamalana mandaꞌiafana maꞌi, “Anen nandatopalopa anis daias. Apaꞌ endilisi anen Krais God nogosahoꞌanaiai, ataꞌ notopalopa anen atona nondatagwah nisilaꞌi.” ");
INSERT INTO aoj_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Amom soldia wapani mandaꞌ salamalana mandaꞌiafana. Eaꞌ mafiꞌi felefeleꞌma anen maꞌi mosoꞌana anambel embel wainimbel numbutimbeli. ");
INSERT INTO aoj_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Eaꞌ maꞌipana maꞌi, “Iꞌi endilisi inaꞌ dembinai king Judaiai, daoꞌ inaꞌ ataꞌ netopalopa inaꞌ atina.” ");
INSERT INTO aoj_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Anif basef fagail lawag agamba ilifa balaga ananigaii fagaꞌias faꞌi, “AMAN ANAMBA DEMBINAI KING ESIS JUDAI.” ");
INSERT INTO aoj_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Eaꞌ anona aman nandaꞌ waf awafii nagail waꞌili naꞌi basef awafima Jisas naꞌi, “Inaꞌ Krais endilisiai, inaꞌ ataꞌ netopalopa inaꞌ niliꞌ eaꞌ netopalopafa wapani.” ");
INSERT INTO aoj_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Owaꞌ anona nagail waꞌili nagagaolana naꞌi, “Inaꞌ nefaꞌ akafimi naꞌamba atin siꞌi aman anamba. Inaꞌ owaꞌ ombal mohenama Goda? ");
INSERT INTO aoj_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Amom soldia maha afaꞌ ogaꞌ andeandeꞌ wandahama waf awafi afaꞌ wandaꞌafi. Apaꞌ aman anamba ina nandaꞌ waf awafi, owaꞌatin.” ");
INSERT INTO aoj_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Eaꞌ nandambema naꞌipa Jisas naꞌi, “Jisas, anaf inaꞌ negataga dembinai king, nemaf afamba inaꞌ okom mondandaꞌma aeꞌ.” ");
INSERT INTO aoj_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Eaꞌ Jisas naꞌipana naꞌi, “Aeꞌ aꞌipina endilisi, inaꞌ deiꞌ aꞌ nepe nelome wambel buꞌwambili Paradais.” ");
INSERT INTO aoj_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Awin aꞌi owaꞌ nandasapaꞌ, akot luꞌunai aꞌ nataga dogw naofana itap hiagoma esis Judai nape nafeꞌ nafeꞌ nataga awin nandambema nagape gani 3 klok wambomota. Eaꞌ nataga negalaꞌ wapani. ");
INSERT INTO aoj_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Eaꞌ anona lowaf luꞌunai siꞌi utai nagail ipat Godi luꞌunai nomoni palalana hiꞌalana nandawal nataga biafina. ");
INSERT INTO aoj_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Eaꞌ Jisas galala mehip naꞌi, “Ahame aeꞌinai, aeꞌ aꞌ eseꞌenago ambal aeꞌali lofoꞌo lagol ineꞌigili.” Anen naꞌias naꞌambama eaꞌ, nagaꞌ dogw. ");
INSERT INTO aoj_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Eaꞌ kepten nugumafi amom soldiai nalutu nati hiahaom amamba eaꞌ nasaꞌma agol Godi naꞌi, “Endilisi atis, aman anamba buꞌunai.” ");
INSERT INTO aoj_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Eaꞌ amam nematawa isimba hiasi safiꞌi sandakolasa sagati hiahaom amamba magatagai, satolom eaꞌ saha mefetagw asasigwi sindihihimbaꞌ nomonas asasisi iwanis aꞌowaꞌ eaꞌ sotanima safeꞌ. ");
INSERT INTO aoj_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Esis alipisi hiasi Jisasi saloma anowa nematawa wagafiꞌi itap luꞌupa Galilii wagiꞌma Jisas wafiꞌi, esis salutu laogon felefeleꞌ sati hiahaom amamba. ");
INSERT INTO aoj_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Anona aman agilinama Josep anen Arimateainai itap luꞌupa Judia. Anen aman buꞌunai, kaunsel dembinai ma amom mugumafi esis Juda hiasii. ");
INSERT INTO aoj_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Anen ina naꞌi ahoꞌma amom dembami Juda moha Jisas nogagaꞌ, owaꞌatin. Anen nape nahafa nemaf buꞌwafi fegataga ma epes hiasi sogawis nomona maol Godi nope Dembinai nugumafias. ");
INSERT INTO aoj_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Aman anamba nafeꞌma Pailat nahaliꞌana ma nogofaꞌi alop Jisasi nogawana. ");
INSERT INTO aoj_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Eaꞌ nafeꞌ natagwaha alop Jisasi nisilaꞌi, nandaꞌ anef lowaf afitifi nopaloꞌana ma nombafana, nasapaꞌana nawis matmat atamba nalana nomon. Matmat atamba sagwasota tawis anona otam luꞌunai. Fowaꞌ esis ina deiꞌ sawa anin epenagon, ataꞌ owaꞌ atin. ");
INSERT INTO aoj_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Nemaf afamba saꞌi sogowandoꞌma hiahawesafi nemaf sagapoma nomaꞌwafi saꞌi sabat felefeleꞌma fegataga. ");
INSERT INTO aoj_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Nematawa awamba Galiliwai waloma Jisas wagafiꞌii, awo dokoꞌ wagiꞌma Josep waliꞌ wafeꞌ wati matmat atamba. Eaꞌ wati nomon naꞌamba Josep nagawa Jisasa. ");
INSERT INTO aoj_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Watolona eaꞌ otanima wafeꞌ ifagw awaugwi, wandondomba wel laloma hiahawes alogw fasigwi gwagasi ma bimb ofaꞌas ofeꞌ matmat ogandisa alop Jisasi. Nemaf afamba sabat fataga, wapoma nomaꞌw siꞌi muꞌuli Godi nagaꞌi. ");
INSERT INTO aoj_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Ama main wafilu nemaf afamba sande fagaliꞌma wik agambai kuhumbita atota awo osafel wafeꞌ matmat. Agufuwama awamba. Maria Makdalaiꞌwi kwaloma anoꞌw awo agol atogol Maria maꞌmana Jemsi waloma Joana eaꞌ waloma anowa daiawa wapani. Eaꞌ ofaꞌ wel mais alogw fasigwi gwagasi awo waliꞌ wagandondombasi, ofaꞌas wafeꞌ matmat. ");
INSERT INTO aoj_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Eaꞌ watologon owaꞌ, wati otam anamba ina ataꞌ mape mowalo uta, owaꞌ. Anin epen aꞌ nafeꞌ nawisiꞌam mafeꞌ maꞌoh waꞌoh. ");
INSERT INTO aoj_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Eaꞌ wawis nomon apaꞌ awo ina wati Jisas, owaꞌatin. ");
INSERT INTO aoj_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Eaꞌ awo nomonas salasafeꞌ hiahiasa isimba. Owaꞌ kwafalis atis wati anom amam biam malutu felefeleꞌ luwaguf amamifi mogalaꞌ aꞌowaꞌ. ");
INSERT INTO aoj_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Eaꞌ awo ombal mahawa aꞌowaꞌ windiwa balagah wati itap. Owaꞌ amom maꞌipawa maꞌi, “Ipaꞌ pafiꞌi pelaoma aman anamba ambal lagapaunai ma naꞌa epes sagagaꞌi ma main? Anen ina ataꞌ nape naꞌa, owaꞌ. Aꞌ nosafel eaꞌ! ");
INSERT INTO aoj_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Ipaꞌ ukup pendapoma basef ifimba fowaꞌ naliꞌ nagaꞌipipafi. Nemaf afamba ataꞌ nape nagalomepa ganimba itap apamba Galili naꞌipipa naꞌi, ");
INSERT INTO aoj_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","‘Aeꞌ ataga epen egefaꞌ alop epesi. Esis atiasi seseꞌe efeꞌma amom mandaꞌ waf awafii, mondele lawag usiꞌigai tiꞌwanaegai. Ma nimaguf bif hiꞌilif, anef wapani aꞌ itanima esafel.’” ");
INSERT INTO aoj_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Eaꞌ awo ukup pandandaꞌma basef ifimba fowaꞌ nagaꞌiefi. ");
INSERT INTO aoj_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Eaꞌ wakwaha matmat otanima wafeꞌ waꞌipa amom alipumi ananimi 11-pelaim maloma anis alipisi hiasi ananisi wapani ma hiahawes isimba. ");
INSERT INTO aoj_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Nematawa awamba wanowa Maria Makdalaiꞌwi kwaloma Joanai anoꞌw Maria Jems maꞌmana. Awo wape waloma anowa daiawa waꞌipa amom aposel 11-pelaim. ");
INSERT INTO aoj_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Owaꞌ amom maꞌi awo wambasoꞌmam waꞌi basef gawa akafi, owaꞌ mohapifawaia. ");
INSERT INTO aoj_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Apaꞌ Pita nosafel nasagih nafeꞌ matmat nasisil nati nomon owaꞌ, nati luwaguf mogowaꞌanami atom maꞌoh. Eaꞌ notanima nafeꞌ ipat nomonas salasafeꞌma hiahawes isimba sagatagai. ");
INSERT INTO aoj_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Nemaf afamba anom amam biam alipumi Jisasi mosafel aꞌ mafeꞌ anambel wambel saꞌumbili felefeleꞌ agilimbila Emeus. Ufiaꞌw akwamba kwaꞌwaha Jerusalem kwagafeꞌ Emeusi nohotagw 7-pelaigw, 14 kilomita. ");
INSERT INTO aoj_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Amom mafeꞌ eaꞌ manifa hiahawes isimba deiꞌ sagatagai. ");
INSERT INTO aoj_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Amom maꞌias mandahahaliꞌmas mafeꞌ, eaꞌ Jisas nataga felefeleꞌ nafeꞌ nalomam. ");
INSERT INTO aoj_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Apaꞌ naep amamipi walufip, ina mati Jisas mogawana, owaꞌatin. ");
INSERT INTO aoj_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Eaꞌ naꞌipam naꞌi, “Ipaꞌ bipa paꞌi main pafeꞌ?” Nahaliꞌam naꞌamba, ukup amamipi iwaiwanip malutu. ");
INSERT INTO aoj_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Eaꞌ anona amom biam Kliopas nagwamana basef naꞌi, “Epes hiasi sagape Jerusalami sati hiahaom amamba magataga nemaf afaꞌii sogawam. Apaꞌ inaꞌ atina owaꞌ negawaia.” ");
INSERT INTO aoj_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Anen naꞌias naꞌamba, Jisas nahaliꞌam naꞌi, “Main daꞌim?” Eaꞌ maꞌipana maꞌi, “Hiahaom amamba magatagama Jisas Nasaretinai. Anen dembinai profet nagaꞌipa esis amam nematawa basef fasifi banagafi. Anen banagonai ma nawalipasa basef ifimba nandaꞌ maol banagani ma naep Godi naloma epes wapani. ");
INSERT INTO aoj_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Eaꞌ amom pris dembami maloma agufumi dembami apeꞌimi masoꞌamana nafeꞌma amom gavman dembami. Eaꞌ amom gavman maꞌi basefa mohana nogagaꞌ. Eaꞌ mandolana lawag usiꞌigai tiꞌwanaegai. ");
INSERT INTO aoj_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Apaꞌ fowaꞌ afaꞌ ukup paꞌi endilisi waꞌi, ‘Aman anamba nogatagwaha apaꞌ Israel mogape wahifipai.’ Ahoꞌ, eaꞌ anif basef wapani. Hiahaom amamba mataga eaꞌ nemaf deiꞌifi fagafeꞌ wanifi. ");
INSERT INTO aoj_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Deiꞌ anowa nematawa afaꞌiwai miniꞌap atep wandaꞌafa gogolalasofa kwapeteꞌ. Kuhimbita atota osafel wafeꞌ matmat, ");
INSERT INTO aoj_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","apaꞌ awo ina wati Jisas, owaꞌatin. Eaꞌ otanima waꞌias waꞌi, ‘Afaꞌ wati anom ensel siꞌi waꞌoh wandandaꞌah watolom maꞌipafa maꞌi. “Anen nosafel nape namona.”’ ");
INSERT INTO aoj_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","“Eaꞌ anom amam afaꞌimi mafeꞌ matmat mati hiahawes naꞌamba atin siꞌi awo wagaꞌias. Apaꞌ anen ina matolona, owaꞌatin.” ");
INSERT INTO aoj_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Eaꞌ Jisas naꞌipam naꞌi, “O, ipaꞌ bipa nomonas akipai. Ukup ipeꞌimi eaꞌ maseꞌepa, ina pahapifa basef amom profeti kwafalis, owaꞌ. ");
INSERT INTO aoj_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Krais anen ataꞌ niliꞌ nofaꞌ akafimi ma main, aꞌ nofaꞌ banagami mogogalaꞌi ananimi migiꞌ. Deiꞌ maina ipaꞌ owaꞌ pegegawaea?” ");
INSERT INTO aoj_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Eaꞌ naliꞌ nasefela basef hiafi Baibelifi amom profet maloma Moses mandaꞌafi nawalipamef. Naꞌipam basef ifimba hiafi fagaꞌi anini nawalipamef kofagefa hiꞌalef. ");
INSERT INTO aoj_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Amom mafeꞌ mataga felefeleꞌma wambel ambalemba maꞌi mogafeꞌma. Eaꞌ Jisas naꞌi ataꞌ nofeꞌ atin, ");
INSERT INTO aoj_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","owaꞌ matalifana maꞌi, “Inaꞌ nepe nelomafa. Awin eaꞌ newala felefeleꞌma owamb.” Eaꞌ nawis nape nalomam. ");
INSERT INTO aoj_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Amom maꞌi meaꞌ gwaꞌaisi, anen nape nalomam nasaꞌma bret nanifela God nawalota nasoꞌamata. ");
INSERT INTO aoj_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Anen nandaꞌasa amom naꞌamba naep amamipi peleꞌatep deiꞌ eaꞌ mogawana. Eaꞌ nosafel nafeꞌ nakwaha amom dolomana. ");
INSERT INTO aoj_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Eaꞌ maꞌi, “Afaꞌ wagafiꞌi ufiaꞌw ukup afaꞌipi eaꞌ pehafel endilisi ma anen nawalapa basef fagape Baibel nagaꞌipafaef nogota atamba.” ");
INSERT INTO aoj_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Amom maꞌias naꞌamba owaꞌ, nogota atamba atota mosafel aꞌ motanima mafeꞌ Jerusalem. Eaꞌ mati alipumi 11-pelaim Jisasi maloma anis alipisi amamisi amamisi sandatama sape. ");
INSERT INTO aoj_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Eaꞌ saꞌipa amom biam saꞌi, “Endilisi atis Dembinai aꞌ notanima nosafel! Saimon natolona eaꞌ.” ");
INSERT INTO aoj_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Eaꞌ amom biam maꞌipasa hiahawes dokoꞌ magatilis ufiaꞌwi. Maꞌipasas maꞌi, “Anen nalomafa wape nawala bret watolona eaꞌ ogawana.” ");
INSERT INTO aoj_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Esis ataꞌ saꞌi basef ifimba atin, owaꞌ Jisas aꞌ nalutu laꞌafena esis naꞌipas naꞌi, “Aeꞌ aꞌi opalef ipeꞌilifi fepe awanelef.” ");
INSERT INTO aoj_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Eaꞌ satolona sosafel gogolalasis kwapeteꞌ aꞌ ombal mahas. Esis saꞌi owaꞌ sati anona gamba. ");
INSERT INTO aoj_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Eaꞌ naꞌipas naꞌi, “Ipaꞌ gogolalasipa kwapeteꞌ ma main? Deiꞌ maina ukup ipeꞌipi palapagafeꞌ? ");
INSERT INTO aoj_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Ipaꞌ piti lagufi boꞌwagah aeꞌasi. Aeꞌ atowe eaꞌ maꞌuwi ape siꞌiwi. Ipaꞌ pesa lagofa aeꞌ pemeꞌe. Gambefah ina alopi bihitagof mapais siꞌi pagati magape alop aeꞌapii, owaꞌatin.” ");
INSERT INTO aoj_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Anen naꞌias naꞌamba ma eaꞌ, nihimbaꞌmasa lagof boꞌwagah ananisi. ");
INSERT INTO aoj_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Eaꞌ sonahasa anen. Apaꞌ esis gogolalasis kwapeteꞌ nomonas sape hiahawes, owaꞌ ataꞌ sohapifanaia. Eaꞌ nahaliꞌas naꞌi, “Ipaꞌ anis gwaꞌaisi aꞌa owaꞌ?” ");
INSERT INTO aoj_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Eaꞌ sasoꞌana anol aol duꞌwanil sagaofali. ");
INSERT INTO aoj_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Nandalombasal naꞌal ama nogohnaep asasisi. ");
INSERT INTO aoj_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Eaꞌ naꞌipas naꞌi, “Fowaꞌ aeꞌ ataꞌ ape agalomepa, aꞌipipa eaꞌ ma basef hiafi fagail buk Baibeli ma muꞌuli God nagasoꞌ Mosesani. Buk akwamba amom profeti faloma buk Sami, basef ifimba hiafi fagaꞌi aeꞌi. Basef ifimba hiafi deiꞌ fataga endilisi fandawalap hiꞌalef.” ");
INSERT INTO aoj_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Anen nihimbaꞌmas andeandeꞌma ukup asasipi ma sogogawa basef fagail Buk Baibeli. ");
INSERT INTO aoj_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Eaꞌ naꞌipas naꞌi, “Fowaꞌ amom mandaꞌ basef ifimba fagail buk Baibeli faꞌi Krais aꞌ nondameꞌ akafimi sohana nogaꞌ ma nimaguf bif hiꞌilif anef fegafeꞌma wanifi, daoꞌ notanima nosafel matmat wapani. ");
INSERT INTO aoj_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Ama agol ananigili atiasi alipisi ananisi siliꞌ sowalapa basef Jerusalem eaꞌ siꞌipasef amam nematawa hiasi hiꞌilas sagape walemb hiagomai ma sembema nelelemba God nokwahomasa awami asasimi okom mogasoꞌanam. ");
INSERT INTO aoj_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Ipaꞌ apati hiahaom amamba magatagamai ma atiasi pigaꞌipa hiasi. ");
INSERT INTO aoj_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Ipaꞌ peme! Anom hiahaom banagami fowaꞌ Ahame naꞌiam endilisi naꞌi nogasiꞌipami felefeleꞌ mifiꞌmipai. Ipaꞌ pendape atapipa taun inimba pefeꞌma petaga nemaf afamba banagami mugisilaꞌi heven ilifi mogafiꞌmai ipaꞌ.” ");
INSERT INTO aoj_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Jisas naoꞌwa esis amam nematawa hiasi safeꞌ sataga felefeleꞌma Betani eaꞌ nasaꞌma lagof falota nofaloꞌmasa nogowaꞌ banagas. ");
INSERT INTO aoj_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Anen ataꞌ naꞌipasa atin, God aꞌ nagiana nakwaha esis nalota heven. ");
INSERT INTO aoj_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Eaꞌ sanifelona sandaꞌ lotumana eaꞌ sandagala aꞌowaꞌ sotanima safeꞌ Jerusalem sandagala atapis sape. ");
INSERT INTO aoj_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Eaꞌ dondol sagape ipat luꞌunai Godi safela agol ananigili luꞌwagol endilisi. Eaꞌ maꞌuf. ");
INSERT INTO aoj_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Fowaꞌ gani dambadamba anif Basef epen nape. Eaꞌ Basef epen anamba nape naloma God. Eaꞌ epen anamba agilinama Basef anen atona God. ");
INSERT INTO aoj_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Fowaꞌ dambadamba epen anamba agilinama Basef naloma God nape. ");
INSERT INTO aoj_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Anen nandaꞌ hiahaom hiami. Owaꞌ anin mae atitin netaga anoꞌw ufiaꞌwa, owaꞌatin. Hiahaom magatagai hiami anen atona nandaꞌam mataga. ");
INSERT INTO aoj_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Ambal namili lagapaunai lape epen anamba eaꞌ ambal alol logogalaꞌma esis epesi. ");
INSERT INTO aoj_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Mogogalaꞌi amamba mogogalaꞌma akuti. Eaꞌ akot ina taofana anen, owaꞌ atin endilisi. Anen nogogalaꞌma esis amam nematawa hiasii, anen eaꞌ nafiꞌi itap apaꞌe ma deiꞌ nogota ataꞌe. ");
INSERT INTO aoj_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Anona aman daiana nataga, agilinama Jon, God nasapaꞌana nagafiꞌii. ");
INSERT INTO aoj_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Anen nafiꞌi ma nogowalapa basef. Deiꞌ nawalapa basefa nogogalaꞌi anamba ma epes hiasi sogameꞌ basef ananifi sogahapifana. ");
INSERT INTO aoj_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Jon nawalapa basef ifimba naꞌi anen ina nagwapin inimba nigigalaꞌi, owaꞌ. Anen naliꞌ nafiꞌima nogawalapa basef alihifa nagwapin anamba endilisinai nogogalaꞌi. ");
INSERT INTO aoj_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Nagwapin anamba nogogalaꞌ endilisii, anen nogogalaꞌma esis amam nematawa hiasii, eaꞌ nafiꞌi itap apaꞌe ma deiꞌ nogota ataꞌe. ");
INSERT INTO aoj_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Fowaꞌ gani anen nandaꞌ itap apaꞌe pataga, deiꞌ nafiꞌi nape itap apaꞌe. Apaꞌ esis amam nematawa sagape itap apaꞌii ina sogawana, owaꞌ. ");
INSERT INTO aoj_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Anen nafiꞌi nataga kofagama itap luꞌupa esis Juda, owaꞌ esis miniꞌap ananisi ina sogawana saꞌi ahoꞌ sofaꞌana sahapifana, owaꞌatin. ");
INSERT INTO aoj_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Apaꞌ esis mamahisa sogawana siꞌi ahoꞌ sogahapifanai, nosoꞌasa anin ametala sogataga awasi Godi. ");
INSERT INTO aoj_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Esis ina sataga awasi Godi ma waf buꞌwafi mamasas sogolasi, owaꞌatin. Esis ina sataga awasi Godi siꞌi ukup mamasas paꞌi ma sogolas, owaꞌatin. God atona nandaꞌas sataga awasi ananisi. ");
INSERT INTO aoj_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Basef fataga epen eaꞌ nape laꞌafena afaꞌ, eaꞌ wati glori mogogalaꞌi banagami ananimi. Glori amamba mogogalaꞌi banagami nogamanai atom, ahamana nasapaꞌana nagafiꞌii. Anen natopalopapa dowaf nowaꞌ banagapa ma nigihimbaꞌmapa waf endilisifi fape siꞌifa anen. ");
INSERT INTO aoj_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Jon nawalapa basefa anen naꞌamba naꞌi, “Anen aman anamba fowaꞌ aꞌipipana agaꞌi. Aman nigiꞌma aeꞌ nogafiꞌii, anen nape nagaliꞌma aeꞌi. Anen fowaꞌinai nagapan naꞌambai, nape naliꞌma aeꞌ.” ");
INSERT INTO aoj_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Apaꞌ hiapai mofaꞌ hiahawes fasisi sagape siꞌisa anini. Waf afamba natopalopapa dowaf nogowaꞌ banagapa nandaꞌas sandape naꞌamba atin nimaguf hiafi. ");
INSERT INTO aoj_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","God nasoꞌana muꞌuli ananini Mosesa nagawalipapa. Apaꞌ Jisas Krais natopalopapa dowafa waf endilisifi. ");
INSERT INTO aoj_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Owaꞌ anona aman atotona niliꞌ niti God kwasakwasalaia, owaꞌatin endilisi. Nogamana anamba Godi atotona nape felefeleꞌ endilisi naloma anen ahamana eaꞌ nawalapa basef kofagefa ma apaꞌ nihimbaꞌmapa God. ");
INSERT INTO aoj_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Anom amam dembami Judaimi mapani Jerusalem masapaꞌi anom amam mafeꞌ mahaliꞌ Jon. Anom pris maloma anom Livai mugumafi ipat Godii, amom mapani Jerusalem mafiꞌi mahaliꞌ Jon maꞌi, “Inaꞌ aman mamahinama?” ");
INSERT INTO aoj_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Eaꞌ Jon ina nambahoꞌ basef, owaꞌ. Anen nagwamam nawalapa basef naꞌipam naꞌi, “Aeꞌ ina Krais God nandandepe nasapaꞌe agafiꞌii, owaꞌ.” ");
INSERT INTO aoj_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Eaꞌ mahaliꞌana maꞌi, “Deiꞌ ina anina profet fowaꞌinai agilinama Elaija?” Owaꞌ anen naꞌi, “Aeꞌ owaꞌ.” Eaꞌ maꞌi, “Deiꞌ inaꞌ aman anamba profet apaꞌ mape mogohafanai?” Owaꞌ nagwamama basef naꞌi, “Owaꞌ.” ");
INSERT INTO aoj_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Eaꞌ maꞌipana maꞌi, “Deiꞌ inaꞌ ami? Ama afaꞌ utanima ofeꞌ ugaꞌipa dembami masapaꞌafa wagafiꞌii. Inaꞌ naꞌi inaꞌ atina naꞌi basef maif, inaꞌ ami?” ");
INSERT INTO aoj_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Eaꞌ Jon nagwa basef siꞌi fowaꞌ profet Aisaia nagaꞌi naꞌi, “Aeꞌ anagol malogol dowaf goga gaꞌi anep itap fataupigima gagaꞌias naꞌamba gaꞌi, ‘Pendomba ufiaꞌw Dembinaii!’ ");
INSERT INTO aoj_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","25","Eaꞌ amom Farisi dembami Judai masapaꞌam mafiꞌi mogahaliꞌ anini mahaliꞌana maꞌi, “Inaꞌ Krais God nandandepena nasapaꞌena nagafiꞌii aꞌa, inaꞌ Elaija aꞌa, inaꞌ anona profet dembinai? Iꞌi inaꞌ owaꞌ Kraisa, a owaꞌ Ilaijaia, anona profeta, deiꞌ inaꞌ napisiꞌasa main?” Jon nagwamam naꞌipam naꞌi, ");
INSERT INTO aoj_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","“Aeꞌ agapisiꞌas embel atembeli, apaꞌ anona aman anamba nape laꞌafena ipaꞌ, ipaꞌ ina pegawana. ");
INSERT INTO aoj_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Aman anamba nagiꞌma aeꞌ nagafiꞌii. Aeꞌ ina amboꞌowe aꞌowaꞌ egatagwaha mandalefa su ananimi, owaꞌatin. Anen dembinai aꞌowaꞌ, nikilaꞌ aeꞌ.” ");
INSERT INTO aoj_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Basef ifimba fataga anambel wambel Betani walemb Jordan fisanamb, Jon nagapisiꞌ esis amam nematawama. ");
INSERT INTO aoj_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Wafilu owaꞌ, Jon nati Jisas nafiꞌmai anen naꞌipas naꞌamba naꞌi, “Ipaꞌ piti aman anamba anen siꞌi mafin sipsip noganai Godi, anamba esis sandaꞌ ofa anai. Anen siꞌi sipsip nogakwaha waf awafi esis amam nematawa hiasi sagape itapi sandaꞌafi. ");
INSERT INTO aoj_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Anen maꞌuna apamba eaꞌ nafiꞌi. Anamba fowaꞌ aeꞌ aꞌipipa agaꞌi, ‘Anona aman nigiꞌma aeꞌ nogafiꞌii, anen nagaliꞌma aeꞌi. Anen aꞌ naliꞌ nape apaꞌ aeꞌ selai agiꞌ ataga.’ ");
INSERT INTO aoj_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Aeꞌ ina aꞌ egawa anen epen mamahonama, ataꞌ owaꞌatin. Aeꞌ afiꞌi apisiꞌipa embela egawalapa aman anamba dembinai ma apaꞌ amam nematawa Israel.” ");
INSERT INTO aoj_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Eaꞌ Jon nawalapa basef alihif naꞌi, “Aeꞌ eaꞌ ati Ambal buꞌunai Godi nakwaha heven nisilaꞌi siꞌi amil alamba apaꞌ magaꞌi maꞌunai nisilaꞌi eaꞌ nafeꞌ nape nomona anen. ");
INSERT INTO aoj_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Aeꞌ ina egawa anen, owaꞌ. Apaꞌ God nasapaꞌe afiꞌi ma igapisiꞌas embel eaꞌ naꞌipi naꞌi, ‘Inaꞌ niti Ambal buꞌunai Aeꞌanai nisilaꞌo ma nogapaunai aman anamba, eaꞌ maꞌuna eaꞌ aman anamba. Anen atiasi nogasoꞌas Ambal Aeꞌanai buꞌunai nogape opalef asasilifi nomoni.’ ");
INSERT INTO aoj_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Aeꞌ eaꞌ atolona endilisi awalapa basef alihifa anen aꞌif aꞌi, Anamba anen Nogamana Godi endilisi.” ");
INSERT INTO aoj_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Aꞌi owaꞌ wafilu Jon a nafeꞌ nalutu wapani naꞌamba eaꞌ alipumi ananimi biam malomana mape. ");
INSERT INTO aoj_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Eaꞌ nati Jisas nafoꞌo, naꞌipa alipumi ananimi nihimbaꞌmama Jisas naꞌi, “Piti, anen siꞌi sipsip noganai Godi.” ");
INSERT INTO aoj_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Eaꞌ alipumi ananimi mameꞌ naꞌipas naꞌamba, maila Jisas. ");
INSERT INTO aoj_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Jisas nandambema owaꞌ nati amom mailana naꞌipam naꞌi, “Ipaꞌ paꞌi pifiꞌi pelaoma main?” Owaꞌ maꞌipana maꞌi, “Rabai, inaꞌ nagapoma ipat ati?” Agol agalemba “Rabai” apaꞌ mombomagol miꞌi, “Dembinai Tisa.” ");
INSERT INTO aoj_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Eaꞌ anen naꞌipam naꞌi, “Ipaꞌ fiꞌi ma ataꞌ petologon.” Eaꞌ mafeꞌ ipat anen nagapautai. Nemaf afamba atef wambomota awin nandambema napani gani waꞌol 4 klok, eaꞌ malomana mapani. ");
INSERT INTO aoj_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Amom mameꞌ basef ifimba Jisasi Jon nagaꞌiefi mailana. Amom agufuma Andrui Saimon Pita, amom atom sahomana owamana. ");
INSERT INTO aoj_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Andru aꞌ ataꞌ usiꞌina notanima naliꞌ nafeꞌ nowandoꞌma Saimon, ama niꞌipana nigaꞌi, “Afaꞌ wati Dembinai Mesaia eaꞌ.” Apaꞌ deiꞌ mambema agol agalemba Mesaia maꞌi Krais, God nandandepana nasapaꞌana nagafiꞌii. ");
INSERT INTO aoj_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Eaꞌ Andru naoꞌwa Saimon nafiꞌmai Jisas natolona naꞌi, “Inaꞌ Saimon nogama Joni. Anaf agol ineꞌigili aꞌ nendefala Sifas.” Agol kofagogola agalemba “Pita” gaꞌi otam. ");
INSERT INTO aoj_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Wafilu wapani Jisas naꞌi nefeꞌ itap apamba luꞌupa Galili. Eaꞌ nowandoꞌma Filip natolona naꞌipana naꞌi, “Inaꞌ fiꞌi nigiꞌma basef aeꞌafi nila aeꞌ.” ");
INSERT INTO aoj_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Filip nafiꞌi wambel ambalemba atembel Pitai Andru magafiꞌima, Betsaida. ");
INSERT INTO aoj_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Eaꞌ Filip nafeꞌ nolaoma Nataniel naꞌipana naꞌi, “Aman anamba fowaꞌ Moses nandaꞌ basefa muꞌuli God nagaꞌianai, eaꞌ amom profet wapani mandaꞌ basef magaꞌianai, aman anamba maꞌuna afaꞌ eaꞌ watolona. Anen aman Nasaretinai, Josep nogamana.” ");
INSERT INTO aoj_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Eaꞌ nahaliꞌ Filip naꞌi, “Deiꞌ anis hiahawes fasisi sataga safiꞌi Nasaret?” Filip naꞌipana naꞌi, “Inaꞌ fiꞌi netelona.” ");
INSERT INTO aoj_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Eaꞌ Jisas nati Nataniel nafiꞌmai anen naꞌipana naꞌi, “Niti aman anamba Israelinai endilisi, aman buꞌunai. Anen owaꞌ nigaꞌi anif basef basoꞌasefia.” ");
INSERT INTO aoj_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Eaꞌ Nataniel naꞌipana naꞌi, “Deiꞌ inaꞌ negawe naꞌimama?” Eaꞌ Jisas nagwamana naꞌipana naꞌi, “Dokoꞌ Filip ina deiꞌ nofalena, ataꞌ owaꞌatin, aeꞌ aliꞌ atilina nagape lawag fik kofagegama. Nogota atamba atilina.” ");
INSERT INTO aoj_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Nataniel nagwamana naꞌi, “Tisa Dembinai, inaꞌ Nogamana Godi endilisi. Inaꞌ dembinai King apaꞌ Israeli.” ");
INSERT INTO aoj_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Eaꞌ Jisas nagwa basef naꞌi, “Aeꞌ dokoꞌ eaꞌ aliꞌ atilina egawena nagape lawag kofagegama. Isimba atis deiꞌ inaꞌ nahapifi. Endilisi anaf inaꞌ aꞌ niti anom hiahaom banagami mikilaꞌ deiꞌ atilina nagape laogon.” ");
INSERT INTO aoj_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Eaꞌ Jisas naꞌipana wapani naꞌi, “Aeꞌ aꞌipipa endilisi atis, anaf ipaꞌ piti heven nundausiꞌ nogal eaꞌ amom ensel Godi lota silaꞌmima aeꞌ ataga epen egefaꞌ alop epesi.” ");
INSERT INTO aoj_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Anef nemaf fagafeꞌma wanifi anona aman nasoꞌ anoꞌw nemataꞌw wambel ambalemba Kana bagape itap apamba luꞌupa Galilii. Eaꞌ maꞌmama Jisasi kwape ipat atamba sandasoꞌamatai. ");
INSERT INTO aoj_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Esis sofala Jisas naloma alipumi ananimi wapani mafiꞌi mati dasoꞌama inimba. ");
INSERT INTO aoj_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Aꞌi owaꞌ main embel wain ahiꞌalan. Eaꞌ maꞌmana Jisasi kwafiꞌi kwaꞌipana kwaꞌi, “Esis embel wain aꞌ akas.” ");
INSERT INTO aoj_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Eaꞌ Jisas naꞌipaꞌw naꞌi, “Maꞌme, maol inimba ina aeꞌani. Eaꞌ ina maol ineꞌini, owaꞌ. Nogota aeꞌatai ina deiꞌ tataga, ataꞌ owaꞌ.” ");
INSERT INTO aoj_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Eaꞌ kwaꞌipa amom mandaꞌ maola anen nogasoꞌ nemataꞌwi kwaꞌi, “Iꞌi anen nigaꞌipipa anif basefa, ipaꞌ pihapifana.” ");
INSERT INTO aoj_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Anom maloh luꞌwami maꞌoh ama esis Juda saila muꞌuli Godi sagasaꞌofami. Maloh amamba wanom wanom sandaꞌ otamba sandaꞌami siꞌi dram luꞌwami 44 galon. ");
INSERT INTO aoj_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Jisas naꞌipa amom mandaꞌ maol naꞌi, “Ipaꞌ pilai embel pekoloꞌwam maloh amamba ma siꞌim kwaef endilisi.” Eaꞌ amom molam siꞌim siꞌi anen nagaꞌipam. ");
INSERT INTO aoj_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Eaꞌ naꞌipam naꞌi, “Deiꞌ koloꞌ duꞌwanimbel pefaꞌambel pefeꞌ peseꞌanam aman nugumafi gwaꞌaisii.” Eaꞌ mofaꞌmana embel mafeꞌ. ");
INSERT INTO aoj_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Dembinai nugumafi gwaꞌaisii embel ambalemba nameꞌambel owaꞌ, eaꞌ bataga fasimbel siꞌi wain, apaꞌ anen ina nogawa embel ambalemba amom mogofaꞌambelima, owaꞌatin. Apaꞌ amom mandaꞌ maola anini mogawambel. Amom molai embel atembel wafimbili. Eaꞌ anen dembinai nofala aman anamba nagasoꞌ nemataꞌwi ");
INSERT INTO aoj_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","nahaliꞌana naꞌi, “Epes hiasi ataꞌ saliꞌ sasoꞌasa wain inimba buꞌwani naliꞌ saꞌana eaꞌ sagiꞌ sofaꞌmasi wain inimba awasin kwasakwasalai. Apaꞌ inaꞌ owaꞌatin. Inaꞌ nambahoꞌwa wain inimba buꞌwani naꞌihi deiꞌaol nagiꞌ nofaꞌan nafiꞌi.” ");
INSERT INTO aoj_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Amamba ametal banagami magaliꞌi siꞌi God nandaꞌami, dambadamba Jisas nandaꞌam Kana itap apamba luꞌupa Galili. Anen nihimbaꞌma esisa glori ananimi banagami mogogalaꞌi. Eaꞌ amom alipumi ananimi mahapifana. ");
INSERT INTO aoj_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Isimba hiꞌalasa main, Jisas naloma alipumi ananimi miliana Kaperneam maloma maꞌmana ananiꞌwi kwaloma owapana ananimi wapani eaꞌ sape naꞌamba anif nimaguf. ");
INSERT INTO aoj_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Nemaf afamba Pasovaefi felefeleꞌma fegataga, Jisas nondowasaꞌ Jerusalem. ");
INSERT INTO aoj_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Eaꞌ nawis ipat luꞌunai Godi nomon nati epes satama mafis amamba sipsip bulmakau amiguf maꞌunamb eaꞌ anis satalom otamba sindisilaꞌmamba. ");
INSERT INTO aoj_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Eaꞌ Jisas nasaꞌma anof mandof strin nandaꞌaf nandaꞌ anep wip siꞌi bumbulita. Eaꞌ nopagaha epes isimba natofas natofamasa hiahaom amamba asasimi sipsipi bulmakau wapani mawis mafeꞌ andoꞌ. Eaꞌ nugulatamasa otamba moni esis sindisilaꞌmanai nakwahona, nambema tebol asasimi nakoloꞌmasom. ");
INSERT INTO aoj_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Eaꞌ naꞌipa amam amamba magatala amigufi naꞌi, “Ipaꞌ faꞌa hiahaom amamba foꞌo.” ");
INSERT INTO aoj_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Eaꞌ alipumi ananimi ukup pandandaꞌma anif basef fagape Baibeli faꞌias fagaꞌi, “Aeꞌ okom mohafel aꞌowaꞌ ma endaꞌ maol banagambel endilisi ma igimafi ipat ineꞌinai nogape andeandeꞌ.” ");
INSERT INTO aoj_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Owaꞌ amom Juda mati anen nandaꞌam naꞌamba, maꞌipana maꞌi, “Inaꞌ ataꞌ nihimbaꞌmafa anol ametala hiahaom banagami siꞌi God nandaꞌami ma ogogawa inaꞌ agol luꞌwagilinai ma nandaꞌam naꞌamba ma afaꞌ.” ");
INSERT INTO aoj_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Eaꞌ Jisas nagwamama basef naꞌi, “Ipaꞌ daꞌa ipat anamba luꞌunai Godi awasina, atiasi aeꞌ itanima ilaꞌana nogotawa wapani nimaguf wanif dowaf.” ");
INSERT INTO aoj_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Eaꞌ amom Juda maꞌipana maꞌi, “Ipat anamba sandaꞌana salaꞌana afagof hiagufi 46-pelaiguf, apaꞌ owaꞌ inaꞌ naꞌi nimaguf wanif dowaf nelaꞌana notawa wapani aꞌamon?” ");
INSERT INTO aoj_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Apaꞌ ipat anamba Jisas nagaꞌianai ina naꞌi ipat anamba endilisinai luꞌunai Godi, owaꞌ. Anen naꞌi alop ananipi. ");
INSERT INTO aoj_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Ma anaf God nosaꞌmana wapani nowaga sogawanama, nogota atamba amom alipumi ananimi aꞌ ukup popoma basef ifimba ananifi fowaꞌ nagaꞌiefi. Eaꞌ deiꞌ aꞌ mahapifa basef ifimba fagape Baibeli faloma basef ifimba Jisas fowaꞌ nagaꞌiefi. ");
INSERT INTO aoj_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Jisas nape Jerusalem ama nimaguf ifimba Pasovaefi, esis amam nematawa hiasi sati maol anen nandaꞌani banagani. Eaꞌ sahapifa agol ananigili. ");
INSERT INTO aoj_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Apaꞌ Jisas nogawa epes hiasi hiꞌalas. Naꞌamba anen ina nahapifas, owaꞌ. ");
INSERT INTO aoj_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Anen ina gawa akanai ma anis daias sogaꞌipana ma waf epesi, owaꞌatin. Anen aꞌ nogawa epes hiasi hiꞌalas eaꞌ nogawa ukupi opalef asasisi. ");
INSERT INTO aoj_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Anona aman agilinama Nikodemus, anen Farisi agol luꞌwagili ma esis Juda. ");
INSERT INTO aoj_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Anamb owamb nafiꞌmai Jisas naꞌipana naꞌi, “Tisa Dembinai, apaꞌ mogawa inaꞌ, God nasapaꞌena nafiꞌi siꞌi dembinai Tisa. Iꞌi owaꞌ God nope noloma anin epena, anin ina laꞌifina nendaꞌ maol inimba banagani inaꞌ nandaꞌani, owaꞌatin.” ");
INSERT INTO aoj_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Eaꞌ Jisas nagwamana basef naꞌi, “Aeꞌ aꞌipina endilisi atis, epen ami iꞌi owaꞌ God nolan netaga dambaina, anin ina atiasi nuwis nomona maol Godi nope Dembinai nugumafian, owaꞌatin.” ");
INSERT INTO aoj_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nikodemus nahaliꞌana naꞌi, “Deiꞌ isimba eaꞌ hagasi sondaꞌam siꞌimama ma solas sogataga dambais wapani? A sotanima sundawis nelelemb mamamasi aꞌamon, ama bola otanima olasi wapani?” ");
INSERT INTO aoj_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Owaꞌ Jisas nagwamana naꞌipana naꞌi, “Ambal buꞌunai Godi laꞌifina nolan negataga dambain. Aeꞌ aꞌipina endilisi, iꞌi owaꞌ Ambal Godi nolana dambaina embela, ina atiasi laꞌifin nuwis nomona maol Godi, owaꞌatin. Apaꞌ iꞌi Ambal Godi nogolan dambaina, daoꞌ. Anin ilama nogawis nomona maol ananini. ");
INSERT INTO aoj_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Hiahaom magataga alop atopi, amamba alop atopumi siꞌi anoꞌw nemataꞌw kogola awani. Apaꞌ hiahaom Ambal Godi nogolami, amamba mataga siꞌi ambal buꞌunai. ");
INSERT INTO aoj_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Ina aꞌ nomonas hiahawesa agaꞌipina naꞌamba agaꞌi pegataga dambaipa wapani siꞌi epes sogolaipa, owaꞌi. ");
INSERT INTO aoj_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Fufin nagaluwi nandagiꞌma anin siꞌi nalo nagafeꞌ ganigani. Inaꞌ nameꞌ amalemb magalaꞌan, apaꞌ ina negawa anamba anin nalo nagafiꞌima ma aꞌ nalo nagafeꞌma, owaꞌatin. Epes hiasi Ambal buꞌunai Godi nolasa sagataga dambaisi, esis eaꞌ sataga naꞌamba atin.” ");
INSERT INTO aoj_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Eaꞌ Nikodemus nagwamana naꞌi, “Hiahawes isimba atiasi sotaga sondowalap siꞌimama?” ");
INSERT INTO aoj_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Jisas nagwamana naꞌi, “Deiꞌ siꞌi main? Inaꞌ Tisa dembinai esis Judai, owaꞌ inaꞌ owaꞌ ataꞌ negawa chiahawes isimbaia? ");
INSERT INTO aoj_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Endilisi atis aeꞌ aꞌipina apaꞌ maꞌi hiahawes apaꞌ mogogawasi, eaꞌ mawalapa hiahawes isimba aꞌ magatilisi. Apaꞌ owaꞌ ipaꞌ pewaꞌ alafugaha basef ifimba afaꞌ wagawalapafi. ");
INSERT INTO aoj_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Aeꞌ aꞌipipa hiahawes isimba itapasi, apaꞌ ipaꞌ ina pegawam pahapifam, owaꞌ. Iꞌi aeꞌ igaꞌipipa hiahaom ilifami, atiasi ipaꞌ pegawa pihapifam piꞌimama? Owaꞌatin. ");
INSERT INTO aoj_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Ina anona aman itapanai nalota gani heven, owaꞌ. Aeꞌ atowe. Aeꞌ ataga epen egefaꞌ alop epesi eaꞌ aeꞌ atowe akwaha heven isilaꞌi, eaꞌ maꞌuwi. ");
INSERT INTO aoj_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Fowaꞌ gani aman anamba Moses nasaꞌma anal ul nandaꞌ kapa nandaꞌali lail anoga lawag ilif. Nandaꞌam anamba wafigima fataupigima. Amamba eaꞌ naꞌamba atina atiasi sefela aeꞌ ataga epen egefaꞌ alop epesi sendele igail anoga lawag ilif. ");
INSERT INTO aoj_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Ama epes mamahisa isimba sogahapifa aeꞌi, atiasi sofaꞌ ambal namili sogape andeandeꞌ lifilafi. ");
INSERT INTO aoj_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Ahoꞌ endilisi, God nogamana aman ananinai atotona nape. Owaꞌ, owaꞌatin. Anen okom maimaila amam nematawa hiapai magape itapi hiꞌalapa. Eaꞌ nasoꞌapai Nogamana ananinai atotona ma epes ami sogahapifanai sogape andeandeꞌ, ina sogaꞌma waf awafi, owaꞌatin. Sofaꞌ ambal namili sope andeandeꞌ lifilafi. ");
INSERT INTO aoj_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","God ina nasapaꞌ Nogamana ananinai nafiꞌi itap apaꞌe ma nondaꞌ kotimapa, owaꞌatin. Anen nasapaꞌana nafiꞌi ma nimbimai epes hiapai magape itapi nokwahomapa waf awafi mogafiꞌmai anen. ");
INSERT INTO aoj_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Epen ami nigahapifa anini, anin atiasi basef akana kot luꞌutai. Apaꞌ epen ami owaꞌ nigahapifanaia, epen inimba aꞌ lamonan higililan eaꞌ ma kot anamba luꞌunai aunai. Deiꞌ main? Anin nandaiwaꞌma nigahapifa Nogamana atotona Godi, naꞌamba epes isimbai aꞌ lamonas hiꞌilas. ");
INSERT INTO aoj_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Basef kofagefa ma kot luꞌunai anamba naꞌamba. Mogogalaꞌi aꞌ mafiꞌi mataga itap apaꞌe eaꞌ, owaꞌ esis ukup pandaꞌi waf atona anamba itapanai siꞌi owambi, sandaiwaꞌma mogogalaꞌi amamba. Deiꞌ maina esis sandaiwaꞌ? Esis sandaꞌ waf awafi naꞌamba deiꞌ sandaiwaꞌ. ");
INSERT INTO aoj_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Epes ami sandaꞌ waf awafii, sogowaꞌ alafugaha mogogalaꞌii, esis sandaiwaꞌma waf awafi asasifi fendawalap. Eaꞌ deiꞌ ombal mahas sandaiwaꞌ. ");
INSERT INTO aoj_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Epen ami nandaꞌ waf endilisifi, anaf anin negatagama mogogalaꞌi. Ma anis epes daias sitilin sogogawa anin nape sisihin atapina God nandaꞌ maol ananini. ");
INSERT INTO aoj_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Basef ifimba hiꞌalefa main, Jisas naloma alipumi ananimi aꞌ mafeꞌ itap luꞌupa Judia. Eaꞌ nape nalomam napisiꞌ esis amam nematawa. ");
INSERT INTO aoj_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Apaꞌ Jon nape wambel ambalemba Inon felefeleꞌma anambel wambel Selim. Anamba walemb luꞌwambi begetaha, esis amam nematawa hiasi safiꞌi naꞌamba, anen napisiꞌas. ");
INSERT INTO aoj_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Nemaf afamba dembinai King Herot ina deiꞌ nandaꞌ Jon nandaꞌ kalabus, ataꞌ owaꞌ, ");
INSERT INTO aoj_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","amom alipumi Joni maꞌi anif basef fape laꞌafena amom maloma anona aman Judainai. Amom maꞌi basefa waf afamba esis Juda sasaꞌof sogowandoꞌ alogwa ma sogape boꞌwesa naep Godi. ");
INSERT INTO aoj_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Eaꞌ alipumi Joni mafeꞌma anen maꞌipana maꞌi, “Dembinai Tisa, aman fowaꞌ nape nagaloma inaꞌ gani waꞌol walemb Jordani ma inaꞌ nagawalapa basef nagaꞌifanai, aman anamba deiꞌ amam nematawa hiasi safeꞌma anen napisiꞌas embel.” ");
INSERT INTO aoj_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Jon naꞌipam naꞌi, “Iꞌi God nagape heveni owaꞌ nosoꞌan anis maefah anin epena, epen inimba ina aꞌ laꞌifin nendaꞌ anin maol, owaꞌatin. ");
INSERT INTO aoj_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Ipaꞌ apegawa basef ifimba fowaꞌ aeꞌ agaꞌiefi aꞌi aeꞌ ina Krais, God nandandepe nasapaꞌe agafiꞌii, owaꞌ. Apaꞌ God nasapaꞌe aliꞌ afiꞌmai Krais. ");
INSERT INTO aoj_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Iꞌi anona aman nogasoꞌ anoꞌw nemataꞌwi, nemataꞌw akwamba eaꞌ ananiꞌwi nagasoꞌakwi. Eaꞌ alipunai aman anambai sonahana nalutu nameꞌ aman anamba deiꞌ nagasoꞌakwi nagafiꞌi. Deiꞌ naꞌamba atina aeꞌ sonahe aꞌowaꞌ ma okom aeꞌami, andagalama Dembinai Jisas. ");
INSERT INTO aoj_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Agol ananigili luꞌwagol, apaꞌ agol aeꞌagili aꞌ gowala gofeꞌ saꞌogol.” ");
INSERT INTO aoj_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Aman nagafiꞌi ilifi anen nape ilifa hiahaom hiami. Apaꞌ aman nagataga itapi anen itapanai nagaꞌi basef itapafi atifi. Apaꞌ aman nagafiꞌi heveni anen nape ilifa hiahaom hiami. ");
INSERT INTO aoj_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Anen naꞌi basef nawalapa hiahawes hiasi natilis nagameꞌas eaꞌi. Apaꞌ ina anin epen nemeꞌ basef ifimba anen nagaꞌiefi, owaꞌatin. ");
INSERT INTO aoj_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Epen ami nameꞌ basef ananifi ma nigailafi, anin naꞌi ahoꞌma basef ifimba nihimbaꞌmasaf alihif God anen nagaꞌi basef endilisifi atifi. ");
INSERT INTO aoj_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Aman anamba God nasapaꞌana nagafiꞌii anen nawalapa basef Godi. Eaꞌ God nasoꞌana Ambal buꞌunai ananinai nape siꞌinama anen. ");
INSERT INTO aoj_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Ahamana God okom maimaila Nogamana eaꞌ nasoꞌana hiahaom hiami hiꞌalama lagof ananigufi. ");
INSERT INTO aoj_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Epen ami nagahapifa Nogamana ananinai, epen inimba deiꞌ aꞌ nefaꞌ ambal namilima negape andeandeꞌ lifilafi dondol. Apaꞌ epen ami newaꞌ alafugama Nogamana ananinai, inimba ina atiasi nefaꞌ ambal namili, owaꞌatin. Anaf nembel wandafunai Godi aꞌ nopoman. ");
INSERT INTO aoj_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Nemaf afamba amom Farisi dembami Judai mameꞌ anif basef naꞌamba faꞌi, “Jisas napisiꞌ alipisi hiasi nikilaꞌ isimba Jon nagapisiꞌasi.” ");
INSERT INTO aoj_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Apaꞌ Jisas ina napisiꞌas, owaꞌ. Amom alipumi ananimi atom mapisiꞌas. ");
INSERT INTO aoj_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Jisas eaꞌ nogawa amom Farisi mameꞌ basef ifimba. Eaꞌ anen nakwaha itap apamba Judia notanima nafeꞌ itap luꞌupa Galili wapani. ");
INSERT INTO aoj_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Ufiaꞌw akwamba anen nailaꞌw nagafiꞌi, kwafeꞌ laꞌafena itap luꞌupa Samaria. ");
INSERT INTO aoj_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Eaꞌ nafeꞌ nataga anambel wambel nagape Samariai taun inimba agiligima saꞌi Sikar. Anamba nape felefeleꞌma Jekop fowaꞌ nagasoꞌanap nogamana ananinai Josepa. ");
INSERT INTO aoj_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Ifata sogola embelatai fowaꞌ Jekop nagandowatai tape wambel ambalemba. Nogota atamba nemaf awin nandasapaꞌ. Jisas nafiꞌi laogon naꞌamba napoma nomaꞌw ifata atamba sagaꞌ embela. ");
INSERT INTO aoj_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Eaꞌ anoꞌw nemataꞌw Samariaiꞌwi kwafiꞌi kwaꞌi kola embel, owaꞌ Jisas natoloꞌw aꞌ nahaliꞌakwa kogasoꞌana anambel embel. ");
INSERT INTO aoj_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Apaꞌ alipumi ananimi mafeꞌ wambel luꞌwambili ma mogatalai gwaꞌaisi. ");
INSERT INTO aoj_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Eaꞌ nemataꞌw akwamba kwaꞌipana kwaꞌi, “Inaꞌ Judainai, ina apaꞌ atepa, owaꞌatin. Aeꞌ nemataꞌw Samariaiwai. Deiꞌ maina inaꞌ nagahaliꞌima embel, ‘Isiꞌina embel negaꞌ embel?’” Esis Juda ina sagaloma esis Samaria atogini, owaꞌatin. Esis naumbih. ");
INSERT INTO aoj_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Eaꞌ Jisas nagwamaꞌwa basef akoꞌw naꞌi, “Iꞌi inaꞌ okom mopaina ma negawa anin mae fasifasini God naꞌi nogasiꞌinaniai, inaꞌ aꞌ negawa aman anamba nagahaliꞌinai ma embeli, inaꞌ nihaliꞌanama anambel embel ambal namili lagapaimbeli anen aꞌ neseꞌenambel.” ");
INSERT INTO aoj_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Eaꞌ kwaꞌipana kwaꞌi, “Aman Dembinai, ifata anaꞌe launai nowala gani awin. Inaꞌ baket akena ma negela embel. Deiꞌ inaꞌ nilai embel ambalemba ambal namili lagapaimbeli anima? ");
INSERT INTO aoj_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Akunamapa apeꞌinai Jekop naꞌ embelata naoꞌwa nogaopana ananisi saloma mafis bulmakau sipsip maim asasimi saꞌambelata. Deiꞌ eaꞌ nakwahota tapoma apaꞌ. Aꞌi inaꞌ nikilaꞌ anen ama negeseꞌapa embel ambal namili lagapaimbeli?” ");
INSERT INTO aoj_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Jisas nagwamaꞌwa basef naꞌi, “Epes mamahisa sogaꞌ embel ambalembai, bola iap peseꞌas wapani. ");
INSERT INTO aoj_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Apaꞌ epen ami negaꞌ embel ambalemba aeꞌ aꞌi igasoꞌanambeli, anin ina atiasi iap peseꞌan wapani ma nimaguf hiafi dondol negape, owaꞌatin. Embel ambalemba aeꞌ agasoꞌanambeli atiasi begataga siꞌi embel bagataga dowafi bambul atapimbel bagapani ma nomon opaf ananifi nefaꞌ ambal namili negape andeandeꞌ lifilafi.” ");
INSERT INTO aoj_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Eaꞌ kwaꞌipana kwaꞌi, “Dembinai, inaꞌ seꞌe embel ambalemba ma aeꞌ ina ataꞌ iap peseꞌe itanima ifiꞌi naꞌa ma egela embel wapani, owaꞌ.” ");
INSERT INTO aoj_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Eaꞌ Jisas naꞌipaꞌw naꞌi, “Inaꞌ foꞌo falai waulunamena niliꞌ eaꞌ pitanima pifiꞌi naꞌa.” ");
INSERT INTO aoj_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Eaꞌ kwagwamana basef kwaꞌi, “Aeꞌ aman ake.” Jisas naꞌipaꞌw naꞌi, “Inaꞌ naꞌi inaꞌ aman akena, isimba inaꞌ naꞌi endilisi atis. ");
INSERT INTO aoj_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Deiꞌ main? Inaꞌ fowaꞌ amam ineꞌimi wanom biam. Apaꞌ aman anamba deiꞌ inaꞌ nape nagalomanai anamba ina aman ineꞌinai, owaꞌ. Basef ifimba ineꞌifi endilisifi.” ");
INSERT INTO aoj_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","20","Eaꞌ kwaꞌipana kwaꞌi, “Aman Dembinai, deiꞌ aeꞌ egawaena, inaꞌ anina profet. Esis aꞌmes bafas apeꞌisi safeꞌ sogonaloꞌma halafuta anamba sandaꞌ lotuma. Eaꞌ ipaꞌ Juda paꞌi wambel esis sandaꞌ lotuwagoma anamba napani Jerusalem.” ");
INSERT INTO aoj_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Eaꞌ Jisas naꞌipaꞌw naꞌi, “Nemataꞌw, inaꞌ nindahapifa aeꞌ. Anef nemaf fegataga ipaꞌ ina atiasi pefeꞌ pendaꞌ lotuma Ahame halafuta atamba, a pendaꞌ lotumana Jerusalem atogon, owaꞌatin. ");
INSERT INTO aoj_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Ipaꞌ pandaꞌ lotuma hiahawes ipaꞌ owaꞌ pegegawasia. Apaꞌ Juda mandaꞌ lotuma hiahawes apaꞌ mogogawasi. Basef kofagefa ma apaꞌ mandaꞌ lotu ifimba. God nowambilai amam nematawa ma nogakwaha waf awafi esis sandaꞌafi, amamba matagama apaꞌ Juda atepa. ");
INSERT INTO aoj_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Nemaf afamba faꞌi figatagai, deiꞌ fataga eaꞌ ma amam nematawa mamahisa sandaꞌ lotu endilisii aꞌ sondandaꞌ lotuma Ahamapa Goda Ambal buꞌunai ananinai noloma waf buꞌwafi endilisifi. Anen nowandoꞌma amam nematawa naꞌambaisi ma sondaꞌ lotumana. ");
INSERT INTO aoj_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","God anen ambal. Naꞌamba amam nematawa mamahisa siꞌi sondaꞌ lotumana endilisii, esis aꞌ sondandaꞌ lotumana andeandeꞌma ukup peloma ambagof asasimi ma waf endilisifi.” ");
INSERT INTO aoj_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Nemataꞌw akwamba kwagwamana basef kwaꞌi, “Aeꞌ egawa aman anamba Mesaia sofalana sagaꞌi Kraisi, God nandandepana nosapaꞌana nugafiꞌii. Afamba anen nugafiꞌi, nowalapam niꞌipapa hiahaom hiami.” ");
INSERT INTO aoj_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Eaꞌ Jisas naꞌipaꞌw naꞌi, “Aeꞌ eaꞌ maꞌuwi, deiꞌ aꞌi alomena.” ");
INSERT INTO aoj_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Anen naꞌipa akoꞌw naꞌamba, owaꞌ alipumi ananimi motanima mafiꞌi. Eaꞌ amom aꞌ nomonas hiahawesa anen naloma nemataꞌw akwamba nalutu nagaꞌi. Apaꞌ amom ina anona nahaliꞌana naꞌi, “Inaꞌ naꞌi nefaꞌ main? Ama deiꞌ nalomaꞌw nagaꞌi?” Owaꞌ. ");
INSERT INTO aoj_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Ama main, nemataꞌw akwamba kwaꞌwaha baket kogola embelatai taꞌoh, kotanima kwafeꞌ taun wambel luꞌwambili. Eaꞌ kwaꞌipa esis kwaꞌi, ");
INSERT INTO aoj_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Ipaꞌ pifiꞌi piti anona aman nawalapai hiahaom hiami fowaꞌ aeꞌ andaꞌami naꞌipiam hiꞌalam. Anen Krais aꞌamon?” Eaꞌ esis sameꞌ naꞌamba, ");
INSERT INTO aoj_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","sakwaha wambel safiꞌi sati Jisas. ");
INSERT INTO aoj_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Owaꞌ alipumi ananimi maꞌipana dindinip maꞌi, “Inaꞌ ataꞌ neaꞌ gwaꞌaisi.” ");
INSERT INTO aoj_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Owaꞌ anen naꞌipam naꞌi, “Aeꞌ anis gwaꞌaisi saꞌoh, isimba ipaꞌ owaꞌ pegawasa.” ");
INSERT INTO aoj_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Eaꞌ alipumi ananimi atom mape manifas maꞌi, “Aꞌ anis sofaꞌmanai anis gwaꞌaisi aꞌa?” ");
INSERT INTO aoj_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Ama main Jisas nawalapef naꞌipam naꞌi, “Gwaꞌaisi aeꞌasi isimba. God nasapaꞌe afiꞌi. Deiꞌ aeꞌ aꞌi indaila okom ananimi atom endaꞌ maol ananini atin efeꞌ imbifan hiꞌindalan. Maol inimba siꞌi gwaꞌaisi aeꞌasi. ");
INSERT INTO aoj_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Ipaꞌ pagaꞌias paꞌi, aomb biambibiamb ataꞌ bape ma nogota atamba gwaꞌaisi sogaofatai togataga. Apaꞌ deiꞌ aeꞌ aꞌipipa, ipaꞌ ataꞌ saꞌma naep petologon aof tulif. Gwaꞌaimi maof eaꞌ ma sogalaꞌam. ");
INSERT INTO aoj_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Epen ami negalaꞌ gwaꞌaisii, anin nefaꞌ otamba ma maol inimba nandaꞌani. Eaꞌ nakolasa gwaꞌaisi isimba ambal namili lagapaisi sogape lifilafi. Eaꞌ epes isimba sagawasi saloma anis daias sagalaꞌasi sokolata sondagala atin. ");
INSERT INTO aoj_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Naꞌamba deiꞌ basef gawaifi ifimba afataga endilisifi atif, ‘Anin epen nawasogon aof afamba, eaꞌ anin daian nafeꞌ nalaꞌas.’ ");
INSERT INTO aoj_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Aeꞌ asapaꞌ ipaꞌ pafeꞌma pegalaꞌi gwaꞌaisi aof afamba fowaꞌ ipaꞌ owaꞌ pendaꞌ maolanafia. Anis epes sandaꞌ maola aof afamba, eaꞌ ipaꞌ pefaꞌ gwaꞌaisi dowafa esis daias sandaꞌas sagawasi.” ");
INSERT INTO aoj_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Akoꞌw dokoꞌ kwaꞌi Jisas nawalapa hiahaom akoꞌw fowaꞌ kwandaꞌami, nawalapam naꞌipaꞌwam alihim. Eaꞌ esis Samaria amam nematawa hiasi sagape taun inimbai sameꞌ basefa akoꞌw asahapifana. ");
INSERT INTO aoj_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Eaꞌ esis safiꞌmai anen sahaliꞌana dindinip saꞌi ataꞌ nope nogaloma esis. Eaꞌ napani nimaguf bif nalomas wambel ambalemba. ");
INSERT INTO aoj_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Eaꞌ epes hiasi wapani wambel ambalembaisi sameꞌ basef ananifi sahapilif. ");
INSERT INTO aoj_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Eaꞌ saꞌipa akoꞌw saꞌi, “Deiꞌ apaꞌ ina mameꞌ basef ineꞌifi atif mahapilif, owaꞌatin. Apaꞌ mameꞌ basef aman anambai aꞌ mogawa anen atona nowambilai amam nematawa hiasi itapasi mokwaha waf awafi asasifi sogotanimai.” ");
INSERT INTO aoj_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Nimaguf ifimba bif hiꞌalef, Jisas nakwaha wambel ambalemba aꞌ nafeꞌ itap luꞌupa Galili. ");
INSERT INTO aoj_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Fowaꞌ jisas anen atona nawalapa basef naꞌif naꞌi, “Anona profet ina anagol agol gatoma gandawalapana alihigila wambel kofagama ananima, owaꞌ.” ");
INSERT INTO aoj_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Eaꞌ deiꞌ nafeꞌ nataga itap apamba Galili, eaꞌ esis asonahasa anen nagafiꞌi. Deiꞌ main, esis fowaꞌ safeꞌ Jerusalema nemaf buꞌwafi Pasovaefi eaꞌ satolom sogawa hiahaom hiami anen nandaꞌam nemaf afambai. ");
INSERT INTO aoj_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","47","Anen notanima nafeꞌ wapani nataga anambel wambel Kana itap luꞌupa Galili. Wambel ambalemba fowaꞌ nambema embel bagataga siꞌi waina. Eaꞌ anona agilinai nandaꞌ maola dembinai kingi, nogamana ananinai aowas nandaꞌana naꞌoh anambel wambel Kaperneam felefeleꞌma aꞌ nogagaꞌ. Apaꞌ agilinai anamba nape Kana nameꞌ basefa Jisas nakwaha itap luꞌupa Judia nafiꞌi Galili, eaꞌ nafeꞌma Jisas nahaliꞌana dindinipa nefeꞌ nondaꞌ nogamana ananinai boꞌona. ");
INSERT INTO aoj_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Eaꞌ Jisas naꞌipana naꞌi, “Iꞌi ipaꞌ hipai pigati banagami mamimami siꞌi God nandaꞌamima, ipaꞌ pihapifi. Iꞌi owaꞌ, owaꞌatin.” ");
INSERT INTO aoj_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Eaꞌ anen nandaꞌ maola dembinai kingi naꞌipana naꞌi, “Dembinai, inaꞌ lianai kwafalis. Naꞌamba nogame aeꞌanai aꞌ nogaꞌ.” Eaꞌ Jisas naꞌipana naꞌi, “Inaꞌ foꞌo. Nogamena ineꞌinai atiasi aꞌ nope namona ambal lopaona.” ");
INSERT INTO aoj_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","51","Eaꞌ aman anamba nahapifa basef Jisasi aꞌ nafeꞌ. Anen ataꞌ nafeꞌ atin ufiaꞌw owaꞌ, amom mandaꞌmana maoli mafiꞌi matolona ufiaꞌw maꞌipana maꞌi, “Nogamena ineꞌinai ambal lapaona aꞌ nosafel nape.” ");
INSERT INTO aoj_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Eaꞌ nahaliꞌama nogota mamahotama nogamana ananinai nosafel boꞌona kwasakwasala. Eaꞌ maꞌi, “Nambatiꞌ awin nendembaꞌa aowas alop nifipini nakwahona eaꞌ hiꞌalan.” ");
INSERT INTO aoj_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Eaꞌ ahama awani inimbai aꞌ nogawa nambatiꞌ nogota atamba atota Jisas naꞌipana naꞌi, “Nogamena ineꞌinai ambal lopain nepe.” Eaꞌ nahapifa Jisas naloma esis amam nematawa ananisi wapani. ");
INSERT INTO aoj_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Fowaꞌ Jisas nakwaha itap luꞌupa Judia aꞌ nafeꞌ nataga itap luꞌupa Galili, eaꞌ deiꞌ nandaꞌ ametal inimba banagani. Ametal inimba nagafeꞌma bifi nandaꞌ awani inimba boꞌwen. ");
INSERT INTO aoj_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Jisas nape Galili ma main, anef nemaf esis Juda sogaꞌ gwaꞌaisi luꞌwasiafi eaꞌ fataga. Eaꞌ anen nondowasaꞌ Jerusalem. ");
INSERT INTO aoj_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Wambel ambalemba nomon felefeleꞌma uta luꞌutai sipsip magawisatai anamba anemb dumb saꞌusaꞌumbi betahagon. Agilimba esis sofalamb diga Hibrui saꞌi Betesda. Dumb ambamba ambugufimba waꞌowaꞌol salaꞌ ifagw sandaꞌ ilalef wanelef bialef fape. ");
INSERT INTO aoj_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Ilalef afalemba epes isimba hiasi aowas nandaꞌasi sape saloma isimba naep pagasoꞌasi saloma boꞌwagahi lagof sagaꞌ sagailasi. Esis sape sasasa embel pindawianama atina bendaꞌas daꞌinda. ");
INSERT INTO aoj_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Anif nimaguf anona ensel Dembinai Godi nakwehef nowala dumb ambamba nandaꞌ embel bandaꞌas wianaiwiana eaꞌ, daoꞌ. Epen ami aowas nandaꞌani niliꞌ nefeꞌ newala embel aꞌ netaga boꞌwen wapani. ");
INSERT INTO aoj_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Anona aman nape aowas luꞌunai nandaꞌana nape afagof hiagufi 38-pelaiguf. ");
INSERT INTO aoj_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Eaꞌ Jisas natolona tol naꞌoh eaꞌ nogawa aman anamba awasina naꞌoh nogota laota aꞌowaꞌ. Naꞌamba nahaliꞌana naꞌi, “Inaꞌ naꞌi atiasi alop ineꞌipi potaga boꞌop, aꞌa owaꞌ?” ");
INSERT INTO aoj_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Eaꞌ nagwamana basef naꞌi, “Aman dembinai, nemaf afamba embel bandaꞌas wianaiwiana ina anis epes sasaꞌme salae ewala embel, owaꞌatin. Aeꞌ atowe andaꞌam aꞌi efeꞌ owaꞌa, anis daias saliꞌ sowala sikilaꞌe.” ");
INSERT INTO aoj_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Eaꞌ Jisas naꞌipana naꞌi, “Inaꞌ safel dasaꞌma nilutu nefaꞌ alahis ineꞌisi aꞌ nilutu nefeꞌ.” ");
INSERT INTO aoj_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Eaꞌ kwafalis atis alop ananipi eaꞌ pataga boꞌop andeandeꞌ. Naꞌamba anen boꞌona nosafel nalutu nasaꞌma alahis ananisi eaꞌ nafeꞌ. ");
INSERT INTO aoj_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Eaꞌ amom dembami esis Judai mati aman anamba aunai nasaꞌma alahis ananisi nofaꞌas nalutu nafeꞌ naep amamipi nemaf afamba sabat nomaꞌwafi. Eaꞌ maꞌipana maꞌi, “Deiꞌ nemaf apaꞌ magapoma nomaꞌwafi, muꞌuli apeꞌini naꞌi owaꞌi ma inaꞌ nesaꞌma alahis nefaꞌas negafeꞌa, owaꞌi.” ");
INSERT INTO aoj_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Owaꞌ anen nagwamama basef naꞌi, “Aman anamba nandaꞌe buꞌuwai anen naꞌipi naꞌi, ‘Saꞌma alahis ineꞌisi aꞌ nefaꞌas nefeꞌ.’” ");
INSERT INTO aoj_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Eaꞌ mahaliꞌana maꞌi, “Aman mamahonama naꞌipina naꞌi, ‘Inaꞌ saꞌma alahis ineꞌisi nefaꞌas nefeꞌ?’” ");
INSERT INTO aoj_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Apaꞌ aman anamba ina nogawa anen nandaꞌana buꞌunai, owaꞌatin. Deiꞌ main? Jisas nafeꞌ nandambahoꞌ naloma amam nematawa hiasi wambel ambalembaisi. ");
INSERT INTO aoj_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Ama main Jisas natolona ipat luꞌunai Godi naꞌipana naꞌi, “Nemeꞌ! Deiꞌ inaꞌ amboꞌwena eaꞌ. Eaꞌ inaꞌ owaꞌi nitanima nefeꞌ nendaꞌ waf awafi wapania, owaꞌ. Naꞌamba hiahaom awami endilisi aꞌ motagamena. ");
INSERT INTO aoj_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Eaꞌ nafeꞌ naꞌipa amom Juda naꞌi, “Aman anamba nandaꞌe buꞌuwai anen Jisas.” ");
INSERT INTO aoj_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Eaꞌ deiꞌ amom Juda ukup numbutipa anen nandaꞌ aman anamba awasinai nosafel nofaꞌ alahis nagaꞌihisi nagafeꞌ nemaf afamba sagapoma nomaꞌwafi. Eaꞌ deiꞌ mosafel mandaꞌmana waf awafi mowandoꞌmana ma mogahana. ");
INSERT INTO aoj_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Eaꞌ Jisas nagwamama basef amom naꞌi, “Ahame aeꞌanai nandaꞌ maol nafiꞌi notambel deiꞌ nemaf afaꞌe sabat wapani. Eaꞌ aeꞌ wapani andaꞌ maol siꞌi anen.” ");
INSERT INTO aoj_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Owaꞌ amom Juda ukup pandaꞌi atin aꞌowaꞌ maꞌi mohana nogagaꞌ. Amom maꞌi anen nosambala basefa muꞌuli ma nemaf afamba sagapoma nomaꞌwafi. Eaꞌ Jisas naꞌias wapani naꞌi God anen ahamana ananinai endilisi. Eaꞌ amom maꞌi anen naꞌi aꞌ notaga nope naꞌamba atin siꞌi God. Isimba atis deiꞌ mandaiwaꞌmana. ");
INSERT INTO aoj_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Eaꞌ Jisas nagwamama basef amom naꞌi, “Aeꞌ aꞌi endilisi atis aꞌipipa. Aeꞌ Nogamana Godi ina laꞌifiwai ma endaꞌ anis maefaha okom aeꞌami atom, owaꞌatin. Aeꞌ andaꞌ hiahawes isimba ati ahame nandaꞌasi, eaꞌ isimba atis. Deiꞌ main, hiahaom hiami ahame nandaꞌami, amamba aeꞌ Nogamana wapani deiꞌ andaꞌam. ");
INSERT INTO aoj_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Ahame aeꞌanai aꞌ okom maimaila aeꞌ Nogamana aꞌowaꞌ nihimbaꞌme hiahaom hiami anen nandaꞌami. Ma anaf nigihimbaꞌme anin maol luꞌwani nikilaꞌ amamba. Naꞌamba atiasi ipaꞌ aꞌ gogololasipa kwapeteꞌ ma maol inimba luꞌwani. ");
INSERT INTO aoj_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Ahame nagasaꞌma esis sagagaꞌi sogosafel wapani ma nogasoꞌas ambal namili. Eaꞌ deiꞌ naꞌamba atin Nogamana ananiwai wapani aeꞌ asoꞌas ambal namili epes aeꞌ okom magaꞌiasi. ");
INSERT INTO aoj_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Ahame God ina nagawaloga anin epeni siꞌi sandaꞌmas koti sandaꞌas, owaꞌ. Maol hiani ma nondaꞌmasa kot, aꞌ naseꞌean aeꞌ Nogamana hiꞌalan. ");
INSERT INTO aoj_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Ama deiꞌ esis amam nematawa hiasi sasaꞌma agol aeꞌ Nogamanai luꞌwagol siꞌi sagasaꞌma agol ahamai luꞌwagol. Epen mamahina owaꞌ negasaꞌma agol aeꞌ Nogamanai luꞌwagola, epen inimba anin ina nasaꞌma agol ahamai God nasapaꞌ aeꞌ agafiꞌii luꞌwagol, owaꞌatin. ");
INSERT INTO aoj_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Endilisi atis aeꞌ aꞌipipa. Epen ami nemeꞌ basef aeꞌafi ma nihapifa anen nasapaꞌ aeꞌ agafiꞌii, epen inimba anin ina aꞌ nefaꞌ basef luꞌwafi ma kot, owaꞌatin. Anin aꞌ nefaꞌ ambal namili nikilaꞌ gaꞌ. ");
INSERT INTO aoj_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Endilisi atis aeꞌ aꞌipipa, nemaf afamba faꞌi figatagai, deiꞌ fataga eaꞌ ma esis sagagaꞌi atiasi sogameꞌ lagol aeꞌagili Nogamana Godi. Epes ami sogameꞌ aeꞌi, atiasi asofaꞌ ambal namili ma sogape boꞌwes endilisi. ");
INSERT INTO aoj_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Ambal namili lape ahame atona. Eaꞌ nowaꞌ banaga aeꞌ Nogamana ananiwai eaꞌ aeꞌ wapani naꞌamba atin siꞌi anen ahame, ambal namili lapauwai, ");
INSERT INTO aoj_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","aeꞌ ataga epen egefaꞌ alop epesi. Naꞌamba God naseꞌe agola hiahaom banagami ma egawaloga epesa kot basef luꞌwafi. ");
INSERT INTO aoj_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","29","Ipaꞌ ina aꞌ ukup hiahawep pepoma amamba, owaꞌi. Nemaf dondoꞌafi fiꞌi fegataga amam nematawa hiasi sagaꞌ sawas sagape wandelefi anaf someꞌ malogol aeꞌagili sosafel sokwaha wandelef suwisi andoꞌ. Eaꞌ epes ami sandaꞌ waf fasifii, anaf sosafel wapani sofaꞌ ambal namili sope namis. Apaꞌ epes mamahisa sandaꞌ waf awafii, anaf sotanima sosafel sefeꞌ sulutu sondaꞌ basef luꞌwafi ma kot.” ");
INSERT INTO aoj_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Eaꞌ Jisas naꞌias naꞌi, “Aeꞌ ina andaꞌ anin mae ma okom aeꞌami atom, owaꞌ. Basef aeꞌ agameꞌefa ahamai, ifimba atif ailif awalapefa esisa kot. Eaꞌ basef ifimba ma kot aeꞌatai ifimba usiꞌif andeandeꞌ. Aeꞌ ina andaꞌama agaila nomonas aeꞌasi atis, owaꞌatin. Aeꞌ andaꞌ maol aila okom aman anamba nasapaꞌe agafiꞌii. ");
INSERT INTO aoj_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Iꞌi aeꞌ atowe ewalapa basefa aeꞌ atowe ai, naꞌamba ipaꞌ apiꞌi basef ifimba aeꞌ agaꞌiefi ina endilisifi. Owaꞌatin. Piꞌi basef basoꞌaifi. ");
INSERT INTO aoj_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Anen nape deiꞌ, nawalapa basefa aeꞌ. Naꞌamba aeꞌ deiꞌ egawa basef ifimba fagaꞌiasa aeꞌi endilisifi atif. ");
INSERT INTO aoj_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Fowaꞌ ipaꞌ pasapaꞌ basef fafeꞌmago Jon. Anen nawalapa basef endilisifi ma aeꞌ eaꞌ. ");
INSERT INTO aoj_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Naꞌamba deiꞌ aeꞌ ina efala anis epes itapasi ma sowalapa basefa aeꞌ sogatopalope, owaꞌatin. Aeꞌ aꞌi God nuwambilipai nokwahomepa waf awafi pitanima pifiꞌmai anen. Eaꞌ deiꞌ aꞌi basef ifimba. ");
INSERT INTO aoj_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Aman anamba Jon siꞌi anin nagwapina nogogalaꞌma amam nematawa. Eaꞌ ukup ipeꞌipi paꞌi ahoꞌma ipaꞌ pendagala nogota atamba kwaiaꞌuta ma mogogalaꞌi amamba Joni. ");
INSERT INTO aoj_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Hiahaom amamba maol banagani ahame naseꞌean naꞌi imafian endaꞌan hiꞌigalani, inimba atin aeꞌ deiꞌ andaꞌan. Inimba maol banagani nikilaꞌ maol Joni nagawalapa basef kofagefa ma aeꞌi. Eaꞌ maol inimba aeꞌ andaꞌani nihimbaꞌma esis amam nematawa sogogawa Ahame nasapaꞌe deiꞌ afiꞌi. ");
INSERT INTO aoj_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Eaꞌ Ahame nasapaꞌe agafiꞌii, anen atona nawalapa basef kofagefa ma aeꞌ. Apaꞌ fowaꞌ gani pafiꞌi pataga deiꞌ ipaꞌ ina pati nogohnaep ananisi a pameꞌ amalemba malogol ananigili, owaꞌatin endilisi. Eaꞌ ipaꞌ ina pati amaga ananigai, owaꞌ. ");
INSERT INTO aoj_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Eaꞌ basef ananifi wapani ifimba ina fape ukup ipeꞌipi, owaꞌatin. Deiꞌ main, ipaꞌ owaꞌ pihapifa aeꞌ God nasapaꞌe agafiꞌiia. ");
INSERT INTO aoj_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Ukup ipeꞌipi pandandaꞌ pagaꞌi basef ifimba fagape Buk Baibeli fagaseꞌepa ambal namili ipeꞌi ma pegape andeandeꞌ lifilafi. Eaꞌ pati basef ifimba pegawa eaꞌ pandaꞌ maol pewandoꞌma basef ifimba hiafi. Deiꞌ basef ifimba atif Baibelifi faꞌi aeꞌ fawalape. Owaꞌ, owaꞌatin. ");
INSERT INTO aoj_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Ipaꞌ pandaiwama pifiꞌmai aeꞌ pefaꞌ ambal namili pegape andeandeꞌ lifilafi. ");
INSERT INTO aoj_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Aeꞌ ina okom maꞌi epes itapasi sogasaꞌma agol aeꞌagili luꞌwagol, owaꞌ. ");
INSERT INTO aoj_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Apaꞌ aeꞌ eaꞌ egawa ukup ipeꞌipi ina paipaila God, owaꞌatin. ");
INSERT INTO aoj_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Aeꞌ afiꞌi agol ahame aeꞌanai, apaꞌ ipaꞌ ina paseꞌe opalef aeꞌ, owaꞌatin. Apaꞌ anaf anona aman daiana nogafiꞌi ma agol ananigili atogili, ipaꞌ aꞌ piꞌi ahoꞌ peseꞌana opalef anen. ");
INSERT INTO aoj_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Ukup ipeꞌipi paꞌi pendefaꞌ agof luꞌwagufi ma sahopepa owapepa ipeꞌimi atom. Apaꞌ God owaꞌatin. Deiꞌ ipaꞌ atiasi pihapifi piꞌimama? Owaꞌatin. ");
INSERT INTO aoj_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Ipaꞌ ina aꞌ ukup pendandaꞌ piꞌi atiasi aeꞌ endaꞌ kotimipa ma Ahame God, owaꞌatin. Aman nondaꞌ kotima ipeꞌi, anen Moses, aman anamba ipaꞌ paꞌi atiasi nogatopalopipai. ");
INSERT INTO aoj_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Ipaꞌ iꞌi pihapifa basef ananifi, eaꞌ pihapifa basef aeꞌafi wapani. Deiꞌ main, anen atona nandaꞌ basef ifimba ma aeꞌ fail Buk Baibel. ");
INSERT INTO aoj_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Apaꞌ ipaꞌ owaꞌ pihapifa basef anen nandaꞌafi ma aeꞌa, owaꞌ. Atiasi ipaꞌ pihapifa basef aeꞌafi piꞌimama? Owaꞌatin.” ");
INSERT INTO aoj_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Jisas nandaꞌ basef ifimba ma main, aꞌ nafeꞌ nambo dumb ambamba Galili fisanamb. Dumb ambamba saꞌi Taiberias. ");
INSERT INTO aoj_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Eaꞌ amam nematawa hiasi safiꞌmai anen. Deiꞌ main, esis sati hiahaom amamba banagami anen nandaꞌam naꞌambai ma nandaꞌ isimba aowas naninani nandaꞌasi sagataga boꞌwes. Eaꞌ sailana. ");
INSERT INTO aoj_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","4","Nemaf afamba luꞌwafi sandaꞌ gwaꞌaisiafi sagaꞌi Pasovaefi felefeleꞌ ma fegataga. Eaꞌ nondowasaꞌ halafuta atamba naoꞌwa alipumi anan mape. ");
INSERT INTO aoj_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Jisas natologon ganigani nati amam nematawa hiasi safiꞌmai anen. Eaꞌ naꞌipa Filip naꞌi, “Afaꞌ ataꞌ otala bret ani ma ogasoꞌ amam nematawa isimba sogaꞌata?” ");
INSERT INTO aoj_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Apaꞌ Jisas nagwambana naꞌias naꞌamba. Anen nogawas eaꞌ hiahawes anen naꞌi nondaꞌasi. ");
INSERT INTO aoj_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Eaꞌ Filip nagwamana basef naꞌi, “Afaꞌ iꞌi ogatala bret 200 kina, ina atiasi dondoꞌma epes isimba hiasi seaꞌata kwasakwasala, owaꞌatin.” ");
INSERT INTO aoj_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Eaꞌ anona amom alipumi Jisasi Andru, Saimon Pita sahomana, naꞌipa Jisas naꞌi, ");
INSERT INTO aoj_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Anona aman saꞌunai nahapila anis gwaꞌaisi bret saꞌusaꞌutai waꞌagolita taloma agof saꞌugufi biagof nape naꞌa. Apaꞌ isimba ina atiasi dondoꞌma epes isimba hiasi, owaꞌatin.” ");
INSERT INTO aoj_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Anamba otalef fasilifi fagapoma. Eaꞌ Jisas naꞌipa alipumi naꞌi, “Kipa esis amam nematawa hiasi sope itap.” Eaꞌ amam atom mataga 5,000-pelaim mape otalef itap. ");
INSERT INTO aoj_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Eaꞌ Jisas nafela bret atamba nanifela God ama eaꞌ, nasoꞌasata esis sagape itapi. Eaꞌ nandaꞌas naꞌamba atina agof wapani. Nasoꞌasas saꞌas alihis dindiꞌi dondoꞌ siꞌi dokoꞌ nolomagahas. ");
INSERT INTO aoj_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Saꞌas alihis eaꞌ, anen naꞌipa alipumi ananimi naꞌi, “Ipaꞌ petatama duꞌwawanis sagasagaꞌihi. Naꞌamba soꞌoh sowala dowadowaf.” ");
INSERT INTO aoj_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Esis saꞌas safeꞌ owaꞌ duꞌwanis saꞌoh. Ama main, alipumi mafeꞌ matatama duꞌwaꞌwanisi maloꞌwas folalef luꞌwalifi 12-pelailifa bret atamba. ");
INSERT INTO aoj_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Eaꞌ esis amam nematawa sati ametal inimba ma hiahaom banagami amamba Jisas nandaꞌami saꞌias saꞌi, “Endilisi atis, anen aman profet anamba nagafiꞌi itap apai.” ");
INSERT INTO aoj_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Eaꞌ Jisas nogawa ukup asasipi saꞌi sufiꞌi sohapilana sondaꞌana notaga nope siꞌi anona dembinai kinga nugumafias. Owaꞌ, anen atona notanima nondowasaꞌ halafuta ilif. ");
INSERT INTO aoj_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Aꞌi owaꞌ wambomota felefeleꞌma owamb, alipumi Jisasi ");
INSERT INTO aoj_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","malota bot mafeꞌ dumb ambamba maꞌi mombo Kaperneam. Eaꞌ owamb basoꞌam laꞌafen, apaꞌ Jisas ina deiꞌ nafiꞌi natagamam, ataꞌ owaꞌatin. ");
INSERT INTO aoj_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Eaꞌ fufin banagonai naluwi, naoh amohafel mandaꞌam fetawa lasialiꞌ aꞌowaꞌ. ");
INSERT INTO aoj_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Amom mandaꞌ pul mafeꞌ nogota lautai siꞌi nohotagw wanogw, owaꞌ mati Jisas analutu nafiꞌi embel ilif dumb ambamba nafiꞌi nataga felefeleꞌma bot tagafeꞌma. Eaꞌ amom ombel maham aꞌowaꞌ. ");
INSERT INTO aoj_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Owaꞌ Jisas naꞌipam naꞌi, “Ipaꞌ banagepa, ombal mogahepa owaꞌ. Aeꞌ atowe maꞌuwi ailipa afiꞌi. Ipaꞌ ina aꞌ ombel mehepa, owaꞌi.” ");
INSERT INTO aoj_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Eaꞌ maꞌi ahoꞌma nondagiai bot. Eaꞌ bot atafeꞌ kwafalis tataga tol anamba amom maꞌi mogafeꞌma. ");
INSERT INTO aoj_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Esis amam nematawa hiasi nambatiꞌ sagapani dumb fisanai, esis sogawa eaꞌ saꞌi, “Nambatiꞌ alipumi ananimi atom malota bot atamba aꞌ mafeꞌ. Apaꞌ anen ina nafeꞌ nalomam, owaꞌatin. Ina aꞌ anota bot tail taloma atamba, owaꞌ. Atotota tala.” ");
INSERT INTO aoj_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Eaꞌ anogw botagw wapani Taibiriasigwi gwafiꞌi felefeleꞌma naꞌamba anen nape nanifela God nagasoꞌas gwaꞌaisima. ");
INSERT INTO aoj_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Esis amam nematawa sati Jisas naloma alipumi ananimi amom ina ataꞌ mape, owaꞌ. Eaꞌ safeꞌ salota anogw botagw safeꞌ Kaperneam solaoma Jisas. ");
INSERT INTO aoj_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Esis solaomana ma satolona gani waꞌol dumb ambamba fisanamb, saꞌipana saꞌi, “Dembinai Tisa, inaꞌ nambaiꞌ nafiꞌi naꞌa?” ");
INSERT INTO aoj_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Owaꞌ Jisas nagwamasa basef naꞌi, “Aeꞌ aꞌipipa endilisi, ipaꞌ ina ukup pandandaꞌma banagami aeꞌ andaꞌami deiꞌ pafiꞌi paꞌi petolowe, owaꞌatin. Ipaꞌ ukup papoma bret atota pagaꞌatai ma nelelemb ipeꞌilimbi siꞌilimb, isimba atis deiꞌ palaꞌ pelaome pafiꞌi. ");
INSERT INTO aoj_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Ipaꞌ ina aꞌ pendaꞌ maola pegefaꞌ gwaꞌaisi isimba awasi foloꞌogolasi, owaꞌi. Ipaꞌ aꞌ pendandaꞌ maola gwaꞌaisi buꞌwasi sagaꞌasa sogape beꞌes andeandeꞌ lifilafii. Gwaꞌaisi isimba ambal namili lagape lifilafii. Gwaꞌaisi isimbai aeꞌ ataga epen egefaꞌ alop epesi, aeꞌ atowe atiasi eseꞌepas ipaꞌ. God aꞌ naseꞌe agola nandandepe eaꞌ ma endaꞌ maol inimba luꞌwani.” ");
INSERT INTO aoj_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Eaꞌ sahaliꞌana saꞌi “Deiꞌ apaꞌ mondaꞌ maol main ataꞌ niliꞌma mondaꞌ maol Godi?” ");
INSERT INTO aoj_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Eaꞌ Jisas nagwamasa basef naꞌi, “Maol Godi naꞌamba. Ipaꞌ pihapifa aeꞌ, God nasapaꞌe agafiꞌii.” ");
INSERT INTO aoj_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Eaꞌ esis saꞌipana saꞌi, “Inaꞌ nihimbaꞌmapa hiahaom maim banagami ma apaꞌ mitilina mogahapifina? Inaꞌ nandaꞌ maol main? ");
INSERT INTO aoj_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Aꞌmesapa apeꞌisi fowaꞌ saꞌ anis gwaꞌaisi agilisa saꞌi mana ma itap apamba wafigima fataupigima siꞌi basef fagape Baibeli faꞌias fagaꞌi, ‘Anen nasoꞌasai gwaꞌaisi sagafiꞌi heveni saꞌas.’” ");
INSERT INTO aoj_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Eaꞌ Jisas naꞌipas naꞌi, “Endilisi atis aeꞌ aꞌipipa, Moses ina naseꞌepa gwaꞌaisi isimba sagafiꞌi heveni, owaꞌatin. Ahame aeꞌanai atona nasiꞌipai gwaꞌaisi isimba endilisisi. ");
INSERT INTO aoj_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Gwaꞌaisi isimba God nagasiꞌipasi isimba aeꞌ akwaha ilif isilaꞌi ma agasoꞌasa ambal namili esis amam nematawa hiasi sagape itapi.” ");
INSERT INTO aoj_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Eaꞌ saꞌipana saꞌi, “Dembinai, deiꞌ inaꞌ neseꞌapa gwaꞌaisi isimba atapis sope lifilafi.” ");
INSERT INTO aoj_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Eaꞌ Jisas naꞌipas naꞌi, “Aeꞌ atowe aeꞌ gwaꞌaisi bret ambal namili buꞌwali lagapauwai. Epen ami nigafiꞌmai aeꞌi ina atiasi nolomohan, a epen mamahina nigahapifa aeꞌi, anin ina atiasi iap peseꞌan wapani ma embel, owaꞌatin. ");
INSERT INTO aoj_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Aeꞌ aꞌipipa, ipaꞌ patolowe eaꞌ apaꞌ ipaꞌ ina pahapifa basef buꞌwafi aeꞌafi, owaꞌ. ");
INSERT INTO aoj_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Epes mamahisa ahame nagaseꞌeas aeꞌi, isimba atis asifiꞌmai aeꞌ. Epen ami niꞌi nigafiꞌmai aeꞌi, aeꞌ ina atiasi iliꞌamonan, owaꞌatin endilisi. ");
INSERT INTO aoj_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Aeꞌ ina akwaha heven isilaꞌi ma igaila okom aeꞌami atom, owaꞌatin. Aeꞌ afiꞌima igaila basefa okom ananimi nasapaꞌe agafiꞌii. ");
INSERT INTO aoj_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Okom aman anamba nasapaꞌe agafiꞌii magape naꞌamba. Esis amam nematawa hiasi anen aꞌ nagaseꞌeas aeꞌi, aeꞌ ina ekwaha anin atitin nepe higililan lamonan, owaꞌatin. Aeꞌ egasaꞌmas wapani nemaf akutaifi. ");
INSERT INTO aoj_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Okom ahame aeꞌanai magape naꞌamba. Amam nematawa hiasi mamahisa siti aeꞌ ma sogameꞌ basef aeꞌafii ma sogahapifai, esis isimba atiasi sofaꞌ ambal namili sogape andeandeꞌ lifilafii. Eaꞌ esaꞌmas wapani nemaf akutaifi.” ");
INSERT INTO aoj_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Eaꞌ anen naꞌi, “Aeꞌ atowe gwaꞌaisi akwaha heven agafiꞌii.” Anen naꞌias naꞌamba, owaꞌ esis Juda sandaꞌ megahahana saꞌi basef hiafi ma anen. ");
INSERT INTO aoj_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Esis saꞌias naꞌamba saꞌi, “Deiꞌ siꞌi main? Aman anamba Jisas anen Josep nogamana. Ahamanai maꞌmana ananisi apaꞌ mogawas. Deiꞌ maina anen nagaꞌi, ‘Aeꞌ akwaha heven isilaꞌi?’” ");
INSERT INTO aoj_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Jisas nagwamasa basef esis naꞌi, “Ipaꞌ ina aꞌ piꞌi basef hiahaof laꞌafena ipaꞌ. ");
INSERT INTO aoj_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Anin epen ina laꞌifina anin atin nigafiꞌmai aeꞌ dowaf, owaꞌatin. Ahame nasapaꞌe deiꞌ afiꞌi, anen iꞌi nogasaꞌma nomonas anin epeni, daoꞌ. Epen inimba atiasi aꞌ nifiꞌmai aeꞌ, eaꞌ anaf aeꞌ esaꞌman wapani nemaf akutaifi. ");
INSERT INTO aoj_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Basef amom profet magaꞌiefi fagape Buk Baibeli fagaꞌi naꞌamba faꞌi, ‘God anaf nuwalipa amam nematawa hiasi.’ Amam nematawa hiasi hiꞌilas sogameꞌ basef ahame aeꞌanai ma sogogawa anini, esis isimba sogafiꞌmai aeꞌi. ");
INSERT INTO aoj_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","“Ina anin epen atitin nati ahame, owaꞌ. Fowaꞌ aeꞌ ape agaloma Goda agafiꞌii, eaꞌ aeꞌ atowe atolona. ");
INSERT INTO aoj_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Aeꞌ aꞌipipa endilisi atis. Epen ami nemeꞌ basef aeꞌafi nihapifi, anin deiꞌ nefaꞌ ambal namili nepe andeandeꞌ lifilafi. ");
INSERT INTO aoj_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Aeꞌ gwaꞌaisi bret ambal namili lagapauwai. ");
INSERT INTO aoj_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Fowaꞌ aꞌmesepa ipeꞌisi saꞌ gwaꞌaisi isimba mana itap anamba wafigima fataupigima, deiꞌ asagaꞌ safeꞌ eaꞌ. ");
INSERT INTO aoj_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Apaꞌ gwaꞌaisi isimba deiꞌ sakwaha heven sagafiꞌi isimba naꞌamba. Iꞌi epen ami negaꞌasi, anin ina atiasi aꞌ negaꞌ, owaꞌatin. Nepe atapin. ");
INSERT INTO aoj_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Aeꞌ gwaꞌaisi ambal namili lagapauwai akwaha heven nepe andeandeꞌ lifilafi. Gwaꞌaisi isimba aeꞌ atiasi igasiꞌinasi, isimba alop aeꞌapi eseꞌ amam nematawa itapasi ma sogofaꞌ ambal namili sogape andeandeꞌ lifilafi.” ");
INSERT INTO aoj_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Eaꞌ amom dembami Juda maꞌi basef mehip mandahihianama Jisas laꞌafena amom atom maꞌi, “Deiꞌ siꞌi maina aman anamba naꞌi nogasoꞌapa alop ananipi apaꞌ mogaꞌap?” ");
INSERT INTO aoj_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Eaꞌ Jisas naꞌipam naꞌi, “Aeꞌ aꞌipipa endilisi atis, aeꞌ ataga epen egefaꞌ alop epesi. Iꞌi ipaꞌ pindaiwaꞌma pegaꞌ alopi esimbel aeꞌasima, ipaꞌ ina atiasi pefaꞌ ambal namili, owaꞌatin. ");
INSERT INTO aoj_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Epen ami negaꞌ alopi esimbel aeꞌasii, inimba deiꞌ aꞌ nefaꞌ ambal namili negape andeandeꞌ lifilafi dondoli eaꞌ esaꞌman wapani nemaf akutaifi. ");
INSERT INTO aoj_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Deiꞌ main? Alop aeꞌapi siꞌi gwaꞌaisi endilisisi, eaꞌ esimbel aeꞌambeli endilisimbeli ma sogaꞌas. ");
INSERT INTO aoj_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Epen ami negaꞌ alopi asimbel aeꞌasii, anin aꞌ nepe sisihin neloma aeꞌ, eaꞌ aeꞌ epe sisihiwi eloman. ");
INSERT INTO aoj_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Ahame ambal namili lagapaunai nasapaꞌe sisihiwi afiꞌi, eaꞌ aeꞌ deiꞌ ape ambal namili ahamai. Eaꞌ naꞌamba atina epen ami negaꞌ alop aeꞌapii, anin atiasi aꞌ nefaꞌ ambal namili ma banagami aeꞌami. ");
INSERT INTO aoj_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Gwaꞌaisi isimba sakwaha heven sigisilaꞌi, isimba ina saꞌata ma eaꞌ sagasagafiꞌi, owaꞌatin. Epen mamahina negaꞌ gwaꞌaisi isimbai, anin atiasi aꞌ nefaꞌ ambal namili ma negape lifilafi dondoli.” ");
INSERT INTO aoj_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Jisas naꞌipam naꞌamba, nawalipam nomon ipat esis Juda sandakolasatai wambel Kaperneam. ");
INSERT INTO aoj_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Anis alipisi Jisasi hiasi sameꞌ basef ifimba eaꞌ saꞌi, “Basef ifimba ahihifa apaꞌ. Atiasi ami nilif? Owaꞌ owaꞌatin.” ");
INSERT INTO aoj_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Jisas nogawa alipisi ananisi sandaꞌ migimigah. Eaꞌ naꞌipas naꞌi, “Basef ifimba faꞌi fehambombaga ukup ipeꞌipi aꞌa? ");
INSERT INTO aoj_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Iꞌi ipaꞌ piti aeꞌ ataga epen egefaꞌ alop epesi itanima ilita gani ilif fowaꞌ agapanima, atiasi agogolalasipa kwapeteꞌepa. ");
INSERT INTO aoj_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Ambal buꞌunai Godi atiasi neseꞌepa ambal namili pepe andeandeꞌ lifilafi dondol. Apaꞌ wafi gawa epesi atis ina asotopalopepa, owaꞌatin. Basef ifimba atif aeꞌ agaꞌiefi, ifimba ambal namili lagapaifi fegape andeandeꞌ lifilafii. ");
INSERT INTO aoj_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Apaꞌ anipa ina pahapifa basef aeꞌafi, owaꞌ.” Deiꞌ main? Jisas fowaꞌ nogawa ami owaꞌ nogahapifanaia ma atiasi niꞌipa boumi nigihimbaꞌmama anen nagapoma. ");
INSERT INTO aoj_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Eaꞌ naꞌipas wapani naꞌi, “Aeꞌ aꞌipipa ma ami nigafiꞌmai aeꞌi, ahame aeꞌanai aꞌ notopalopan nohondoꞌani. Iꞌi owaꞌ, owaꞌatin. Ina anis sifiꞌmai aeꞌ dowaf, owaꞌ. Ahame atona notopalopas nofaꞌasi, daoꞌ andeandeꞌ.” ");
INSERT INTO aoj_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Eaꞌ deiꞌ anis alipisi ananisi hiasi asakwahona sotanima safeꞌ daindai, ina ataꞌ sape salomana wapani, aꞌowaꞌ. ");
INSERT INTO aoj_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Eaꞌ Jisas nahaliꞌ alipumi ananimi 12-pelaim naꞌi, “Ipaꞌ wapani paꞌi pekwaha aeꞌ pitanima pefeꞌ, aꞌamon?” ");
INSERT INTO aoj_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Owaꞌ Saimon Pita nagwamana basef naꞌi, “Dembinai, afaꞌ okwaha inaꞌ ofeꞌ ugiꞌma ami? Basef ineꞌifi atif faꞌipafa ma ogape ambal namili andeandeꞌ lifilafi. ");
INSERT INTO aoj_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Afaꞌ wahapifina ogawa endilisi inaꞌ aman Godi buꞌwinai hililiꞌi, nasapaꞌena nagafiꞌii.” ");
INSERT INTO aoj_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Jisas nagwamama basef naꞌipam naꞌi, “Aeꞌ andandepa ipaꞌ 12-pelaipa eaꞌ aeꞌipai owaꞌ anona ipeꞌinai ambal aunai.” ");
INSERT INTO aoj_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Jisas naꞌi anona amamunai amom 12-pelaim agilinama Judas, anen Saimon Keriotinai nogamana. ");
INSERT INTO aoj_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Ama main, Jisas nafeꞌ nolalona walemb hiagoma itap luꞌupa Galili. Anom Juda dembami asasimi magape Judai maꞌi mohana nogaꞌ. Naꞌamba anen ina ataꞌ nape itap asasipi, owaꞌ. Anen nape Galili atogon. ");
INSERT INTO aoj_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Eaꞌ felefeleꞌ ma anef nemaf esis Juda sandaꞌ anis gwaꞌaisi luꞌwasi ma ukup pegapoma esis sondolalima God. Eaꞌ salaꞌ aolah saꞌuhi sapaoha sandaꞌ gwaꞌaisi isimba. ");
INSERT INTO aoj_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Eaꞌ owapana Jisasi maꞌipana maꞌi, “Inaꞌ nekwaha naꞌaꞌe aꞌ nefeꞌ itap luꞌupa Judia, ma alipisi sigati maol banagani ineꞌini siꞌi God nandaꞌani. ");
INSERT INTO aoj_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Iꞌi anona aman niꞌi epes hiasi sogogawa maol ananini, anen ina nondambahoꞌ nondaꞌan, owaꞌ. Inaꞌ eaꞌ naꞌamba atin, nekwaha wambel ineꞌimbili nefeꞌma epes hiasi sitilina sigati maol ineꞌini ma sogasaꞌma agol ineꞌigili luꞌwagol.” ");
INSERT INTO aoj_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Owapana ananimi wapani amom ina mahapifana, owaꞌ. Eaꞌ deiꞌ maꞌipana basef ifimbai. ");
INSERT INTO aoj_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Eaꞌ Jisas naꞌipam naꞌi, “Nimaguf hiafi ipeꞌifi atif, apaꞌ nemaf aeꞌafi dondoꞌafi ina deiꞌ afataga, ataꞌ owaꞌ. Nogota aeꞌatai totaga daoꞌ, aꞌ efeꞌ Jerusalem. ");
INSERT INTO aoj_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Aeꞌ awalapa waf awafi esis sagape itapi sandaꞌafi. Eaꞌ deiꞌ esis ukup awepa aeꞌ. Apaꞌ esis ina laꞌifisa ukup awepa ipaꞌ, owaꞌatin. ");
INSERT INTO aoj_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Ipaꞌ piliꞌ pendowasaꞌ pefeꞌma gwaꞌaisi isimba. Aeꞌ otaꞌ. Deiꞌ aeꞌ ina aꞌ endowasaꞌ, ataꞌ owaꞌ. Deiꞌ main, nogota aeꞌatai ataꞌ owaꞌ totagaia.” ");
INSERT INTO aoj_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Anen naꞌipam naꞌamba ma eaꞌ, ataꞌ napani Galili. ");
INSERT INTO aoj_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Eaꞌ owapana Jisasi mondowasaꞌ mafeꞌ Jerusalem ma gwaꞌaisi isimba luꞌwasi. Amom maliꞌ mafeꞌ, anen wapani nagiꞌmam nondowasaꞌma gwaꞌaisi isimba. Apaꞌ anen ina nafeꞌ nandawalap, owaꞌatin. Anen nandambahoꞌ atin nafeꞌ. ");
INSERT INTO aoj_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Anamba sandaꞌ gwaꞌaisi amom dembami Juda mape naep petaoma Jisas. Eaꞌ mahaliꞌ esis maꞌi, “Aman anamba nape ani?” ");
INSERT INTO aoj_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Amam nematawa hiasi esis atis sandaꞌipama anen saꞌosaꞌombel saꞌi, “Anen aman buꞌunai.” Apaꞌ anis saꞌi, “Owaꞌ, anen nagambasoꞌma epes hiasii.” ");
INSERT INTO aoj_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Apaꞌ ina anin epen nawalapa basef naꞌif alihifa Jisas, owaꞌatin. Deiꞌ main, esis hiasi ombel mahasa amom agufumi esis Judai. ");
INSERT INTO aoj_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Nemaf afamba esis ataꞌ sape sandaꞌ gwaꞌaisi isimba atin, Jisas nafiꞌi nawis ipat luꞌunai Godi nawalipasa basef esis. ");
INSERT INTO aoj_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Amom agufumi Judai bombolalasom aꞌowaꞌ mahaliꞌas maꞌi, “Ami nasoꞌana gawa inimba?’ ");
INSERT INTO aoj_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Eaꞌ Jisas nagwamam naꞌipam naꞌi, “Gawa inimba ina gawa aeꞌani, owaꞌ. Gawa anona amani nasapaꞌe agafiꞌii. ");
INSERT INTO aoj_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Iꞌi anin epen okom miꞌi nendaꞌ maol Godi siꞌi anen nagaꞌiani, atiasi epen inimba aꞌ negawa basef aeꞌ agawalipasafi fataga God aꞌa fataga aeꞌ atowe. ");
INSERT INTO aoj_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Ami nigaꞌipasa gawa ananini atini, anin naꞌi esis sogasaꞌma agol ananigili luꞌwagol. Apaꞌ ami niꞌi nendaꞌ maola negasaꞌma agol anen nasapaꞌe agafiꞌii, anin epen boꞌwen hililiꞌi. Anin naꞌi basef endilisifi atif. ");
INSERT INTO aoj_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Moses naseꞌepa muꞌuli Godi ipaꞌ, apaꞌ owaꞌ anin epen nila muꞌuli inimbaia, owaꞌatin. Deiꞌ maina ipaꞌ paꞌi pehe egagaꞌ?” ");
INSERT INTO aoj_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Eaꞌ esis amam nematawa hiasi sagwamana basef saꞌipana saꞌi, “Ambal aunai napaina. Deiꞌ inaꞌ naꞌi, ami naꞌi nehena negaꞌ?” ");
INSERT INTO aoj_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Jisas naꞌipas naꞌi, “Aeꞌ andaꞌ anom hiahaom banagami atifim. Eaꞌ deiꞌ ipaꞌ gogolalasipa. ");
INSERT INTO aoj_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Apaꞌ ipaꞌ patopaꞌmam alop nogaopepa ipeꞌimi nemaf afamba sabat sagapoma nomaꞌwafi. Deiꞌ main? Ipaꞌ pagiꞌma muꞌuli inimba fowaꞌ God nagasoꞌ Mosesani. Moses atona ina naliꞌ nandaꞌ waf afamba owaꞌ. Dambadamba waf afamba faliꞌ fapoma amom agufumi Judai fowaꞌimi magaliꞌi. ");
INSERT INTO aoj_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Ipaꞌ patopaꞌmam alop nogaopepa nemaf afamba sabat ama ipaꞌ ina pewala muꞌuli inimba God nagasoꞌ Mosesani. Naꞌamba ipaꞌ paꞌi andeandeꞌma pagatopaꞌmam alop nogaopepai. Deiꞌ maina ipaꞌ ukup numbutipa aeꞌ ma andaꞌ anona aman boꞌona andeandeꞌ nemaf afamba sabat? ");
INSERT INTO aoj_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Ipaꞌ owaꞌi pewaloga hiahawes pendaꞌas hiꞌihiꞌas naep atip dowafa, owaꞌ. Ipaꞌ pewalogas ukup ipeꞌipi ma waf usiꞌifi atefa pegegawa waf asasifi beꞌef aꞌa awef.” ");
INSERT INTO aoj_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Anis Juda sagape Jerusalemi sameꞌ basef ifimba ananifi sahaliꞌas saꞌi, “Anen eaꞌ maꞌuna anamba dembami apeꞌimi maꞌi mohana nogagaꞌi, aꞌa owaꞌ? ");
INSERT INTO aoj_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Anen nape nawalipasa basef alihigima apaꞌ amom agufumi ina magwamana anif basef, owaꞌ. Isimba endilisi aꞌamon? Amom mogawa aman anamba Krais, God nandandepana nasapaꞌana nagafiꞌii, aꞌa owaꞌ? ");
INSERT INTO aoj_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Apaꞌ mogawa aman anamba nataga itap apeꞌipi. Apaꞌ anaf owagama Krais nogafiꞌi, ina anin epen negawa Krais anaf nogatagama, owaꞌ.” ");
INSERT INTO aoj_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Eaꞌ Jisas ataꞌ nape ipat luꞌunai Godi nawalipas naꞌi mehip naꞌi, “Ipaꞌ pegawa aeꞌ endilisi apegawa aeꞌ agatagama wambel kofagama. Apaꞌ aeꞌ ina afiꞌi dowaf aila okom aeꞌami atom, owaꞌ. Anen nasapaꞌe agafiꞌii endilisinai. Ipaꞌ ina pegawana, owaꞌ. ");
INSERT INTO aoj_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Apaꞌ aeꞌ egawana. Deiꞌ main, fowaꞌ aeꞌ alomana wape atogon eaꞌ anen nasapaꞌe afiꞌi.” ");
INSERT INTO aoj_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Esis sameꞌ basef ifimba ananifi, opalef awalefa anen saꞌi sofaꞌana sondaꞌmana basef sondaꞌ kotimana, owaꞌ owaꞌatin. Deiꞌ main, nemaf afamba nogagaꞌafi ina fataga, ataꞌ owaꞌ. ");
INSERT INTO aoj_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Epes hiasi sameꞌanana dowaf apaꞌ anis sahapifana saꞌi, “Nemaf afamba Krais nondaꞌ maol banagani. Maol Kraisi aꞌ nikilaꞌ maol aman anamba nandaꞌani?” ");
INSERT INTO aoj_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Amom Farisi mameꞌ esis amam nematawa hiasi saꞌi basef fafifafi ma Jisas. Eaꞌ amom pris dembami maloma amom Farisi masapaꞌ anom plisman amamumi mafiꞌi mogowaꞌana. ");
INSERT INTO aoj_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Eaꞌ Jisas naꞌipas naꞌi, “Aeꞌ ina ataꞌ elomepa epe nogota laota, owaꞌatin. Aeꞌ epe nogota bandata eaꞌ itanima efeꞌma anen nasapaꞌe agafiꞌii. ");
INSERT INTO aoj_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Ipaꞌ atiasi pelaoma aeꞌ pefeꞌ, owaꞌatin. Gani aeꞌ atiasi igapanima, ipaꞌ ina laꞌifipa pefeꞌagono, owaꞌ.” ");
INSERT INTO aoj_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Eaꞌ amom Juda atom mandaꞌipama maꞌi, “Aman anamba naꞌi nefeꞌ anima ma afaꞌ ogolaomana? Anen atiasi nefeꞌma esis Juda afaꞌisi saloma Grik aꞌamon? ");
INSERT INTO aoj_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Eaꞌ naꞌi, ‘Ipaꞌ pewandoꞌma aeꞌ apaꞌ ina atiasi petolowe, owaꞌ.’ Eaꞌ naꞌias wapani naꞌi, ‘Ipaꞌ ina laꞌifipa piti aeꞌ egapoma, owaꞌ.’ Basef ifimba kofagefa mamahifa?” ");
INSERT INTO aoj_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Owaꞌ nemaf afamba akutaifi luꞌwafi ma esis Juda sondaꞌ gwaꞌaisi isimba, Jisas nalutu naꞌi dindinip naꞌi, “Epen ami iap peseꞌan nifiꞌmai aeꞌ neaꞌ embel. ");
INSERT INTO aoj_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Epen ami nihapifa aeꞌ siꞌi basef fagail Buk Baibeli faꞌias fagaꞌi, ‘Ami nigahapifa aeꞌi, atiasi embel ambal namili lagapaimbeli bitagai okom ananimi nomon a koloꞌ atin biwisi andoꞌ.’” ");
INSERT INTO aoj_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Basef Jisasi kofagefa faꞌi Ambal buꞌunai Godi anaf nope nogaloma esis sogahapifanai ukup asasipi nomon. Nemaf afamba Ambal buꞌunai Godi inaꞌ deiꞌ nawis anis epes sagahapifanai, ataꞌ owaꞌ. Deiꞌ main, Jisas ataꞌ owaꞌ nogaꞌ nosafel wapani nofaꞌ agol luꞌwagilima mogogalaꞌi ananimia, ataꞌ owaꞌ. ");
INSERT INTO aoj_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Eaꞌ anis amam nematawa sameꞌ basef ifimba saꞌi, “Endilisi, aman anamba anen dembinai Profet apaꞌ mape mogahafanai.” ");
INSERT INTO aoj_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Apaꞌ anis daias saꞌi, “Deiꞌ Krais nataga itap luꞌupa Galili, aꞌa owaꞌ? Owaꞌatin. ");
INSERT INTO aoj_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Basef fagail Baibeli fagaꞌi naꞌamba faꞌi, ‘Krais owagama notaga wambota Deviti wambel Betlehem, Devit fowaꞌ nagapoma.’” ");
INSERT INTO aoj_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Eaꞌ esis amam nematawa sandawal miniꞌap biafipa Jisas. Anis saꞌi anen Krais, apaꞌ anis saꞌi, “Owaꞌ.” ");
INSERT INTO aoj_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Eaꞌ anis saꞌi sofaꞌana nefeꞌma kot, apaꞌ owaꞌ. Ina anis sando lagof sahapilana, owaꞌ. ");
INSERT INTO aoj_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Eaꞌ plisman amamba motanima mafeꞌma amom pris dembami maloma amom dembami Farisi magapoma. Eaꞌ dembami amamba mahaliꞌ plisman maꞌi, “Deiꞌ maina ipaꞌ owaꞌ pewaꞌ Jisas pefaꞌana pifiꞌia?” ");
INSERT INTO aoj_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Owaꞌ amom maꞌi, “Fowaꞌ gani nafiꞌi nafiꞌi nataga deiꞌ owaꞌ anin epen newalapa basef siꞌi anen nagaꞌiefia, owaꞌ.” ");
INSERT INTO aoj_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Amom Farisi magwamama basef maꞌi, “Anen nambasoꞌmepa wapani, aꞌamon? ");
INSERT INTO aoj_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","49","Ina anona dembinai aꞌa anona Farisi nahapifana, owaꞌatin. Apaꞌ amam nematawa isimba hiasi, ina sogawa muꞌuli Godi, owaꞌ. Isimba atis anaf God nogwamasa waf awafi esis sandaꞌafi.” ");
INSERT INTO aoj_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","51","Nikodemas fowaꞌ nagafeꞌma Jisasi, anen dembinai naloma amom dembami Farisi, nahaliꞌam naꞌi, “Afaꞌ andeandeꞌma ondaꞌ waf awafi ma aman anamba aꞌa owaꞌatin? Muꞌuli afaꞌini nagaꞌi naꞌamba naꞌi, afaꞌ uliꞌ uhaliꞌana ma ogogawa waf ananifi feloma maol ananini, ma main daoꞌ, afaꞌ aꞌ wiꞌi anif basef.” ");
INSERT INTO aoj_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","53","Amom maꞌipana maꞌi, “Inaꞌ wapani Galilinai aꞌa? Owaꞌatin. Inaꞌ ataꞌ niti basef fagail Buk Baibeli eaꞌ nitalifif. Ama atiasi negegawa ina anona profet nataga itap luꞌupa Galili, owaꞌatin.” ");
INSERT INTO aoj_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Amam amamba hiami mafeꞌ ifagw amamigwi, apaꞌ Jisas nondowasaꞌ nafeꞌ halafuta Oliv. ");
INSERT INTO aoj_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Eaꞌ aꞌi owaꞌ kuhumbita atota notanima nafeꞌ ipat luꞌunai Godi. Esis amam nematawa hiasi safiꞌmai anen eaꞌ nape nawalipasa basef. ");
INSERT INTO aoj_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Eaꞌ amom dembami magawalipasa muꞌuli Godi maloma amom Farisi mati anoꞌw nemataꞌw kwandaꞌ soꞌa waol kwaloma anona aman kwaꞌoh maoꞌwakw mafiꞌi. Eaꞌ maꞌipaꞌw kwalutu laꞌafena amom hiami matoloꞌw. ");
INSERT INTO aoj_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Eaꞌ maꞌipa Jisas maꞌi, “Dembinai tisa, nemataꞌw akwamba afaꞌ watoloꞌw kwaloma anona aman kwandaꞌ soꞌa waola waf awafi. ");
INSERT INTO aoj_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Muꞌuli God nagasoꞌ Mosesani naꞌipafa naꞌi afaꞌ okwaha otamba oha nematawa wandaꞌ waf afambai ogagaꞌ. Inaꞌ okom mape maꞌimama?” ");
INSERT INTO aoj_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Amom maꞌi mogwambana iꞌi anen owaꞌ nogwamoma basef andeandeꞌa, mondaꞌ kotimana. Owaꞌ, Jisas nasisil notawa nandaꞌ faf ananifi nandaꞌ anif basef fail itap. ");
INSERT INTO aoj_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Amom malutu mahaliꞌana ma basef hiafi, eaꞌ nosafel nalutu naꞌipam naꞌi, “Ipaꞌ ami owaꞌ pendaꞌ waf awafia, ipaꞌ piliꞌ pekwaha otam peha akoꞌw.” ");
INSERT INTO aoj_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","9","Eaꞌ anen nasisil wapani nandaꞌ anif basef fail itap. Amom mati basef ifimba matalifif, eaꞌ mandaumb atona atin motanima mafeꞌ. Amom hagami maliꞌ mafeꞌ eaꞌ saꞌumi magiꞌ mafeꞌ. Mafeꞌ atona atin makwaha akoꞌw kwaloma Jisas atis sape. ");
INSERT INTO aoj_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Eaꞌ Jisas nosafel nalutu nahaliꞌakw naꞌi, “Deiꞌ amam amamba mape ani? Owaꞌ anona aman niꞌi nondaꞌ kotima inaꞌa?” ");
INSERT INTO aoj_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Akoꞌw kwaꞌipana kwaꞌi, “Dembinai, owaꞌ. Aꞌ mafeꞌ hiꞌalam.” Eaꞌ naꞌipaꞌw naꞌi, “Aeꞌ naꞌamba atin siꞌi amom. Aeꞌ ina andaꞌ kotimina, owaꞌ. Inaꞌ foꞌo, apaꞌ ina netanima nendaꞌ waf awafi wapani, owaꞌi.” ");
INSERT INTO aoj_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Eaꞌ Jisas naꞌipa amam nematawa wapani naꞌi, “Aeꞌ siꞌi mogogalaꞌi fasimi egalaꞌma ipaꞌ hipai pagape itapi. Epen ami nila aeꞌ anin ina atiasi nefeꞌ akota ufiaꞌw ananiꞌwi, owaꞌ. Anin nepe nogogalaꞌi ambal namili lopain.” ");
INSERT INTO aoj_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Amom dembami Farisi maꞌipana maꞌi, “Deiꞌ inaꞌ nandaꞌi basefa inaꞌ atina. Naꞌamba afaꞌ ina ohapifina, owaꞌ. Basef ineꞌifi ina endilisifi, owaꞌatin.” ");
INSERT INTO aoj_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Jisas nagwamam basef naꞌi, “Aeꞌ aꞌipasa basefa aeꞌ. Eaꞌ deiꞌ basef ifimba aeꞌafi endilisifi atif. Deiꞌ main, aeꞌ aꞌ egawa aeꞌ ataga agafiꞌima eaꞌ egawa anamba anaf egafeꞌma. Apaꞌ ipaꞌ ina pegawa anamba aeꞌ ataga agafiꞌima, anaf egafeꞌma, owaꞌ. ");
INSERT INTO aoj_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Ipaꞌ pawaloga epes siꞌi epes sagape itapi sagawalogas. Apaꞌ aeꞌ owaꞌ. Aeꞌ ina ewaloga anin epen, owaꞌ. ");
INSERT INTO aoj_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Iꞌi aeꞌ egawaloga anis epes, aeꞌ ewalogas andeandeꞌ endilisi. Deiꞌ main? Ina aeꞌ atowe ape, owaꞌ. Aeꞌ ape aloma ahame nasapaꞌe agafiꞌii. Naꞌamba afaꞌ biafa wawalogas andeandeꞌ endilisi. ");
INSERT INTO aoj_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Anif basef fagail muꞌuli ipeꞌini faꞌi, ‘Iꞌi anom amam biam mugaꞌi basef atifif, basef ifimba amamifi endilisifi atif.’ ");
INSERT INTO aoj_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Basef ifimba ma aeꞌ afaꞌ biafa waꞌif, aeꞌ aloma Ahame aeꞌanai nasapaꞌe agafiꞌii.” ");
INSERT INTO aoj_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Eaꞌ amom mahaliꞌana maꞌi, “Ahamena ineꞌinai nape ani?” Jisas nagwamamef naꞌi, “Ipaꞌ ina pegawa aeꞌ, eaꞌ ipaꞌ inaꞌ pegawa ahame aeꞌanai wapani. Iꞌi ipaꞌ pegawa aeꞌai, ipaꞌ pegawa ahame aeꞌanai wapani. Owaꞌ owaꞌatin.” ");
INSERT INTO aoj_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Jisas ataꞌ nawalapa basef ananifi nomon ipat luꞌunai Godi ma rum sagambeꞌ otamba moni sandaꞌ ofaeni nagaꞌoma. Apaꞌ ina anona aman nafeꞌ nombaloꞌana nofaꞌana ma kot, owaꞌ. Deiꞌ main, nogota ananitai ataꞌ owaꞌ totagaia. ");
INSERT INTO aoj_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Jisas naꞌipam wapani naꞌi, “Aeꞌ aꞌ efeꞌ. Apaꞌ ipaꞌ ina atiasi petolowe, owaꞌ. Ipaꞌ atiasi pepe a pegaꞌ ma waf awafi ipeꞌifi. Deiꞌ main, anamba aeꞌ egafeꞌma, ipaꞌ ina atiasi laꞌifipa pefeꞌagono, owaꞌ.” ");
INSERT INTO aoj_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Eaꞌ amom Juda mandaꞌipama maꞌi, “Anen naꞌi nefeꞌ ani, ma afaꞌ ina laꞌififa ogafeꞌa? Deiꞌ maina anen nagaꞌi naꞌamba? Anen naꞌi nondaha anen atona aꞌa?” ");
INSERT INTO aoj_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Eaꞌ Jisas nagwamam naꞌi, “Ipaꞌ pagape itapi. Apaꞌ aeꞌ agape ilifi. Walemb ipeꞌilimbi itap apaꞌe, apaꞌ aeꞌ owaꞌ. ");
INSERT INTO aoj_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Aeꞌ aꞌipipa eaꞌ. Atiasi ipaꞌ pegaꞌ waf awafi ipeꞌifi ataꞌ atapif fipaipa. Iꞌi ipaꞌ owaꞌ pihapifa aeꞌ, aman God nasapaꞌe agafiꞌiia, atiasi ipaꞌ pegagaꞌ waf awafi ipeꞌifi atapif fepaipa.” ");
INSERT INTO aoj_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","26","Amom mahaliꞌana maꞌi, “Inaꞌ aman mamahinama?” Owaꞌ Jisas nagwamamef naꞌi, “Siꞌi fowaꞌ agaꞌipipa. Aeꞌ laꞌifiwai ma igaꞌipipa basef hiafi ipaꞌ ma endaꞌ kotimipa ma basef hiafi ifimba agaꞌipipafi. Apaꞌ anen nasapaꞌe agafiꞌii, anen endilisinai. Basef ananifi aeꞌ ameꞌef eaꞌ aꞌipipaef ipaꞌ pagape itapi.” ");
INSERT INTO aoj_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Amom ina mogawa anen nagaꞌipama ahamana ananinai, owaꞌ. ");
INSERT INTO aoj_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Eaꞌ Jisas naꞌipam naꞌi, “Namanani ipaꞌ pesaꞌma anen nataga epen nogofaꞌ alop epesi pendelona nil lawag usiꞌigai tiꞌwaenagai ilif. Nemaf afamba aꞌ pegawa basef ifimba faꞌi aeꞌ atowe eaꞌ maꞌuwi siꞌi aliꞌ agaꞌipipa. Eaꞌ pegawa aeꞌ ina andaꞌ maol aeꞌ atowe agaꞌiani, owaꞌ. Basef Ahame nagawalipiefi, ifimba atif aꞌif aꞌipipaef. ");
INSERT INTO aoj_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Anen nasapaꞌe agafiꞌii nape nalome. Anen ina nakwahowe aeꞌ atowe ape, owaꞌ. Deiꞌ main, dondol aeꞌ andaꞌ maol okom ananimi magaꞌiani.” ");
INSERT INTO aoj_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Jisas ataꞌ naꞌipam atin, owaꞌ hiasi sahapifana. ");
INSERT INTO aoj_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Eaꞌ Jisas naꞌipa esis Juda sagahapifanai naꞌi, “Iꞌi ipaꞌ pihapifa basef aeꞌafi pigiꞌmif, ipaꞌ alipipai endilisi. ");
INSERT INTO aoj_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Eaꞌ ipaꞌ atiasi pegawa basef endilisifi eaꞌ ifimba atif fetagwahepa pepe wahifipa.” ");
INSERT INTO aoj_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Owaꞌ esis sagwamana basef saꞌi, “Apaꞌ akupana Abrahami. Apaꞌ ina agof akapa mape lafela anis epes, owaꞌatin. Deiꞌ maina inaꞌ naꞌipapa nagaꞌi basef endilisifi fatagwahepa magape wahifipa?” ");
INSERT INTO aoj_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Jisas nagwamas basef naꞌi, “Endilisi aeꞌ aꞌipipa, epen ami nape nandaꞌ waf awafii, waf afambai fewaꞌan siꞌi agol akani nagape lafela anis epesi. ");
INSERT INTO aoj_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Epen inimba agol akani ina nape andeandeꞌ ipat nomon dondol, owaꞌ. Apaꞌ Nogamana endilisi daoꞌ. Anen nape ipat atamba nomon dondol. ");
INSERT INTO aoj_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Iꞌi aeꞌ Nogamana ananiwai etagwahipa pandaꞌ waf awafi fagawasiꞌipa sisihipai, atiasi pepe andeandeꞌ wahifipa endilisi. ");
INSERT INTO aoj_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Aeꞌ egawa ipaꞌ wambota Abrahami. Apaꞌ ipaꞌ paꞌi pehe egaꞌ. Deiꞌ main, basef ifimba aeꞌafi ina fape nomonas ipeꞌisi, owaꞌ. ");
INSERT INTO aoj_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Aeꞌ awalapa basef ifimba gawaifi ma hiahawes aeꞌ aloma ahame aeꞌanai wagatilisi, eaꞌ aꞌipipa basef ifimba, apaꞌ owaꞌ ipaꞌ pandaꞌam siꞌi pagameꞌ ahamepa ipeꞌinai nagaꞌipipa.” ");
INSERT INTO aoj_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","40","Esis Juda sagwamana basef saꞌi, “Ahamapa apeꞌinai Abraham.” Eaꞌ Jisas naꞌi, “Iꞌi ipaꞌ Abraham batawisanaiai, ipaꞌ aꞌ pendaꞌ maol Abrahami. Owaꞌ, owaꞌatin. Ipaꞌ paꞌi dindinipa pehe egagaꞌ. Aeꞌ aꞌipipa basef endilisifi atif ameꞌ God nagaꞌipiefi. Abraham ina nandaꞌ waf afambai siꞌi ipaꞌ paꞌi pehe egagaꞌ, owaꞌatin. ");
INSERT INTO aoj_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Ipaꞌ pandaꞌ waf ahamepa ipeꞌinai nandaꞌafi.” Esis sagwamana basef saꞌi, “Mamamapa apeꞌiwai ina wandaꞌ soꞌa waol olapa, owaꞌ. Ahamapa apeꞌinai God atotona.” ");
INSERT INTO aoj_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Jisas naꞌipas naꞌi, “Iꞌi God ahamepa ipeꞌinaiai, ukup ipeꞌipi pipila aeꞌ. Ina aeꞌ atowe ela okom afiꞌi, owaꞌatin. Ahame nasapaꞌe afiꞌi ape naꞌa. ");
INSERT INTO aoj_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Deiꞌ maina ipaꞌ owaꞌ pemeꞌ basef aeꞌafia? Ipaꞌ ina laꞌifipama pegameꞌ basef aeꞌ agaꞌiefi, owaꞌ. ");
INSERT INTO aoj_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","“Ipaꞌ siꞌi ahamepa ipeꞌinai nagaꞌiani. Fowaꞌ dambadamba nafiꞌi nafiꞌi nataga deiꞌ, anen naha epes sagagaꞌi, eaꞌ nowaꞌ alafugama basef endilisifi. Nomonas ananisi ina sapoma basef endilisifi, owaꞌ. Anen nambasoꞌmas nimaguf hiafi dondol lifilafi. Basef basoꞌaifi anen nagaꞌiefi, ifimba ananifi atif fagataga okom ananimi atumi. ");
INSERT INTO aoj_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Apaꞌ aeꞌ aꞌipipa basef endilisifi atif. Isimba atis deiꞌ pandaiwaꞌma pigahapifi. ");
INSERT INTO aoj_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Ipaꞌ epen mamahina nagape laꞌafena ipeꞌi banagena negawalapa anef waf awafi atetef aeꞌ andaꞌafi? Owaꞌatin. Apaꞌ iꞌi aeꞌ igaꞌipipa basef endilisifi, deiꞌ maina ipaꞌ owaꞌ pihapifia? ");
INSERT INTO aoj_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Epes Godi sameꞌ basef ananifi. Apaꞌ ipaꞌ ina epes Godi, owaꞌ. Ipaꞌ anipa daipa. Naꞌamba ipaꞌ owaꞌ pemeꞌ basef ananifia.” ");
INSERT INTO aoj_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Esis Juda sagwamana basef saꞌi, “Apaꞌ maꞌi endilisi inaꞌ Samariainai bounai apeꞌinai eaꞌ ambal aunai napaina.” ");
INSERT INTO aoj_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Jisas naꞌi, “Aeꞌ ambal aunai owaꞌatin. Apaꞌ aeꞌ asaꞌma agol Ahame aeꞌanai eaꞌ ipaꞌ pataloga agol aeꞌagili. ");
INSERT INTO aoj_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Aeꞌ ina andaꞌ maola anis sogasaꞌma agol aeꞌigili luꞌwagol, owaꞌ. Apaꞌ anona dembinai nandaꞌ maol inimba, ma anis daias sogasaꞌma agol aeꞌagili, dembinai anamba Ahame nape jasa aeꞌ. ");
INSERT INTO aoj_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Aeꞌ aꞌipipa basef endilisifi atif. Epen ami nihapifa basef aeꞌafi nilif, anin ina atiasi negaꞌ, owaꞌ. Aꞌ nepe lifilafi dondol.” ");
INSERT INTO aoj_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Esis Juda sameꞌ basef ifimba saꞌi, “Deiꞌ apaꞌ magawa inaꞌ ambal aunai nape nomonas ineꞌisi. Abraham fowaꞌ aꞌ nagaꞌ eaꞌ amom profet fowaꞌimi wapani aꞌ magaꞌ. Owaꞌ inaꞌ naꞌi, epen ami nihapifa basef ineꞌifi anin ina negaꞌ, owaꞌ.” ");
INSERT INTO aoj_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Eaꞌ sahaliꞌana wapani saꞌi, “Inaꞌ aꞌ nikilaꞌ ahamapa apeꞌinai Abraham? Anen nagaꞌ eaꞌ amom profet wapani aꞌ magaꞌ. Apaꞌ inaꞌ naꞌi inaꞌ atina aman mamahinama? ");
INSERT INTO aoj_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","55","Jisas nagwa basef naꞌamba naꞌi, “Iꞌi aeꞌ esaꞌma agol aeꞌagili luꞌwagilai, agol aeꞌagili wafigil siꞌi basef wafifi. Apaꞌ Ahame ipaꞌ pagaꞌi God ipeꞌinai, anen nasaꞌma agol aeꞌigili luꞌwagol. Apaꞌ ipaꞌ ina pegawana, owaꞌ. Aeꞌ atowe egawana. Iꞌi aeꞌ iꞌi owaꞌ igawanaia, aeꞌ agaꞌi basef basoꞌami siꞌi ipaꞌ pagambasoꞌam. Owaꞌ owaꞌatin. Aeꞌ egawana aila basef ananifi. ");
INSERT INTO aoj_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","“Abraham akunamepa ipeꞌinai, anen aꞌ nandagala ma nogati nogota aeꞌatai owagama togataga, siꞌi nagati aeꞌ ma sonagahana endilisi.” ");
INSERT INTO aoj_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Esis Juda saꞌipana saꞌi, “Afagof ineꞌigufi ataꞌ owaꞌ 50-pelaigufa, inaꞌ naꞌi aꞌ nati Abraham?” ");
INSERT INTO aoj_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Jisas nagwamas naꞌipas naꞌi, “Aeꞌ aꞌipipa endilisi, fowaꞌ gani Abraham maꞌmana ataꞌ owaꞌ kolanaea, aeꞌ aliꞌ ape.” ");
INSERT INTO aoj_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Eaꞌ esis sameꞌ basef ananifi, eaꞌ amom Juda mafeꞌ masaꞌmai otamba maꞌi mokwahemba mohana owaꞌ, Jisas nandambahoꞌ nawisi nakwaha ipat luꞌunai Godi nafeꞌ. ");
INSERT INTO aoj_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Jisas nafeꞌ ufiaꞌw eaꞌ nati anona aman naep pagasoꞌanai. Fowaꞌ maꞌmana kogolana naep pasoꞌana nape naꞌamba atin atapina. ");
INSERT INTO aoj_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Alipumi ananimi mahaliꞌana maꞌi, “Dembinai tisa, deiꞌ maina aman anamba naep pagasoꞌana? Anen nandaꞌ waf awafi aꞌa esis mamasana sandaꞌ waf awafi solana?” ");
INSERT INTO aoj_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Jisas naꞌipam naꞌi, “Kofagema ma anen naep pagasoꞌana ina mamasana sandaꞌ waf awafi aꞌa anen nandaꞌ waf awafi, owaꞌ. Anen naep pasoꞌana ma maol Godi negataga luꞌwin. Isimba atis deiꞌ naep pasoꞌana. ");
INSERT INTO aoj_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Deiꞌ eaꞌ alip, nogota apaꞌ mondaꞌ maola anen nasapaꞌe agafiꞌii. Owamb bogataga ina atiasi anis epes sondaꞌ maol, owaꞌatin. ");
INSERT INTO aoj_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Aeꞌ ataꞌ egape itap apaꞌe ipeꞌipi, aeꞌ siꞌi nagwapin nogogalaꞌi ipeꞌiwai ipaꞌ hipai pagape itapi.” ");
INSERT INTO aoj_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Jisas naꞌipam naꞌamba, eaꞌ nisiꞌwafa apah itap nagwindisah haloma itap. Eaꞌ nasomana naep aman anamba. ");
INSERT INTO aoj_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Eaꞌ naꞌipana naꞌi, “Inaꞌ nefeꞌ nesaꞌopa naep embel dumb amamba Siloam.” Basef kofagefa ma agol agalemba ifimba faꞌi, nasapaꞌana. Eaꞌ aman anamba nafeꞌ nasaꞌopa naep ananipi, ma ataꞌ notanimai atin owaꞌ, naep patiana andeandeꞌ boꞌona. ");
INSERT INTO aoj_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Esis wambel atembel saloma anis fowaꞌ sati anen nagape ufiaꞌw nandailasa otamba gwaꞌaisi maini sahaliꞌas saꞌi, “Anen aman anamba maꞌuna fowaꞌ nape ufiaꞌw nandailasa gwaꞌaisii?” ");
INSERT INTO aoj_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Eaꞌ anis saꞌi, “Anen maꞌuna.” Apaꞌ anis saꞌi, “Owaꞌ. Anona daiana anamba. Apa amaga ananigai siꞌi anen.” Apaꞌ aman anamba fowaꞌ naep pagasoꞌanai naꞌi, “Aeꞌ maꞌuwi.” ");
INSERT INTO aoj_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Eaꞌ esis sahaliꞌana saꞌi, “Inaꞌ nandaꞌ maina deiꞌ nagati andeandeꞌ?” ");
INSERT INTO aoj_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Anen nagwamas naꞌi, “Anona aman agol ananigili Jisas nandaꞌ itap paloma apah ananihi nambemam nandaꞌmeam naep aeꞌapi. Eaꞌ naꞌipi naꞌi, ‘Inaꞌ nefeꞌ nesaꞌof dumb Siloam.’ Eaꞌ afaꞌ asaꞌof eaꞌ naep apati.” ");
INSERT INTO aoj_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Eaꞌ sahaliꞌana saꞌi, “Aman anamba nape ani?” Eaꞌ naꞌipas naꞌi, “Aeꞌ ina egawa nagapoma, owaꞌ.” ");
INSERT INTO aoj_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Esis saoꞌwa aman anamba fowaꞌ naep pagasoꞌanai safeꞌma amom dembami Farisi. ");
INSERT INTO aoj_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Nemaf afamba esis sagapoma nomaꞌwafi sabat, afamba atef Jisas nandaꞌ itap Paloma apah nambemam nandaꞌmanam naep ananipi, eaꞌ naep patiana. ");
INSERT INTO aoj_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Eaꞌ amom Farisi mahaliꞌana wapani maꞌi, “Anen nandaꞌmena maina deiꞌ naep pagati?” Aman anamba nagwamam naꞌi, “Anen nandaꞌ itap paloma apah ananihi nandaꞌmeam naep aeꞌapi, eaꞌ afaꞌ asaꞌopa naep eaꞌ deiꞌ apati.” ");
INSERT INTO aoj_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Eaꞌ anom Farisi maꞌi, “Aman anamba ina nagiꞌma muꞌuli ma nemaf afamba sabat, owaꞌ. Eaꞌ anen ina aman Godi, owaꞌatin.” Owaꞌ anom Farisi daiam maꞌi, “Anona aman nandaꞌ waf awafii ina laꞌifina nondaꞌ maol banagani siꞌi God nandaꞌani, owaꞌatin.” Eaꞌ amom Farisi mandawal biafim. ");
INSERT INTO aoj_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Eaꞌ mahaliꞌ aman anamba fowaꞌ naep pagasoꞌanai maꞌi, “Inaꞌ negawana naꞌimama? Waf ananifi mamahefa? Aman anamba nandaꞌ naep ineꞌipi pagatii.” Aman anamba naꞌi, “Anen anona profet.” ");
INSERT INTO aoj_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Endilisi aman anamba fowaꞌ naep pagasoꞌanai deiꞌ patiana. Apaꞌ amom dembami esis Judai ina mahapifana maꞌi endilisi, owaꞌ. Eaꞌ mofalai mamasana ananisi safiꞌi mahaliꞌas. ");
INSERT INTO aoj_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Eaꞌ mahaliꞌas maꞌi, “Aman anamba nogamepa ipeꞌinai aꞌa owaꞌ? Aman anamba ipaꞌ paꞌi naep ananipi pagasoꞌanai fowaꞌ maꞌmana kogolana? Deiꞌ anen nati andeandeꞌ naꞌimama?” ");
INSERT INTO aoj_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Esis mamasana sagwamam basef saꞌi, “Afaꞌ ogawa anen nogamafa afaꞌinai. Eaꞌ ogawa fowaꞌ maꞌmana kogolana naep pasoꞌana. ");
INSERT INTO aoj_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Apaꞌ afaꞌ ina ogawa deiꞌ anen nagati, nati andeandeꞌ naꞌimama. Ami nandaꞌ naep ananipi patiana, afaꞌ ina ogawa. Anen dambena eaꞌ, afaꞌ waꞌi ipaꞌ pihaliꞌana nondaꞌipipa.” ");
INSERT INTO aoj_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Esis mamasana ananisi ombal mahasa amom agufumi Judai. Eaꞌ deiꞌ saꞌias naꞌamba. Deiꞌ main, amom agufumi maꞌi basef eaꞌ maꞌi, epen ami niꞌi basefa Jisas nigaꞌi anen Kraisi, amom aꞌ miliꞌamonana ipat esis Juda sandakolasatai ma ina nendaꞌ lotu nelomas wapani, owaꞌ. ");
INSERT INTO aoj_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Amom maꞌias naꞌamba deiꞌ mamasana ananisi ombal mahas saꞌi, “Anen dambena eaꞌ. Pihaliꞌana nondaꞌipipa.” ");
INSERT INTO aoj_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Amom mofalai aman anamba wapani maꞌipana maꞌi, “Inaꞌ niꞌi basef endilisifi atif, God natilina. Afaꞌ ogawa aman anamba Jisas, anen aman aunai.” ");
INSERT INTO aoj_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Anen nagwamam naꞌi, “Aeꞌ ina egawa waf ananifi awafi, aꞌa owaꞌ. Apaꞌ aeꞌ egawa endilisi atis, fowaꞌ naep aeꞌapi paseꞌe apaꞌ deiꞌ owaꞌ, ati andeandeꞌ.” ");
INSERT INTO aoj_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Eaꞌ mahaliꞌana maꞌi, “Anen nandaꞌmena maina deiꞌ nandaꞌ naep ineꞌipi pagati?” ");
INSERT INTO aoj_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Anen nagwamamef naꞌi, “Dokoꞌ aeꞌ aꞌipipa eaꞌ, apaꞌ ipaꞌ ina pameꞌe, owaꞌ. Deiꞌ maina paꞌi pegameꞌ basef ifimba wapani? Ipaꞌ wapani paꞌi petaga alipipai ananipai pilana?” ");
INSERT INTO aoj_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Owaꞌ amom maꞌi basef wandafifi ma anen maꞌi, “Inaꞌ aman alipunai ananinai. Apaꞌ afaꞌ alipufai Mosesi. ");
INSERT INTO aoj_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Afaꞌ ogawa God fowaꞌ naꞌipa Moses eaꞌ apaꞌ aman anamba afaꞌ ina ogawa waf kofagefa ananifi anen nataga ani?” ");
INSERT INTO aoj_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Anen nagwamamef naꞌi, “Amamba hiahaom maim? Ipaꞌ ina pegawa anen nataga ani, apaꞌ anen nandaꞌ naep aeꞌapi pati. ");
INSERT INTO aoj_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Apaꞌ mogawa God ina nameꞌ esis sandaꞌ waf awafii, owaꞌ. Anen nameꞌ epen ami nandaꞌ maol ananini nagasaꞌma agol ananigili ma negameꞌ basef ananifi. ");
INSERT INTO aoj_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Fowaꞌ gani nafiꞌi nafiꞌi nataga deiꞌ ina anif basef faꞌi anona aman maꞌmana kolana eaꞌ nataga naep pasoꞌana ma anef nemaf anona aman daiana nondaꞌ naep pigatiana, owaꞌatin. ");
INSERT INTO aoj_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Iꞌi aman anamba ina aman Godiai, anen ina atiasi nondaꞌ anis maefah, owaꞌ, owaꞌatin. Anen aman Godi.” ");
INSERT INTO aoj_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Amom magwamana basef maꞌi, “Endilisi, fowaꞌ maꞌmena kogolaena inaꞌ nandaꞌ waf awafi atef. Eaꞌ ina aꞌ niwalipafa, owaꞌi.” Eaꞌ amom maliꞌamonana ipat atamba esis Juda sandakolasatai ina ataꞌ nolomas nondaꞌ lotu wapani, aꞌ owaꞌ. ");
INSERT INTO aoj_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Eaꞌ Jisas nameꞌ basefa amom maliꞌamonana nape andoꞌ nowandoꞌmana natolona nahaliꞌana naꞌi, “Inaꞌ nahapifa aman anamba nataga epen nogofaꞌ alop epesi, aꞌa owaꞌ?” ");
INSERT INTO aoj_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Aman anamba nahaliꞌana naꞌi, “Dembinai, aman anamba ami? Niꞌipiana ma igahapifana.” ");
INSERT INTO aoj_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Eaꞌ Jisas naꞌipana naꞌi, “Deiꞌ inaꞌ natolona eaꞌ. Anen epen anamba deiꞌ naꞌi nagalomanai.” ");
INSERT INTO aoj_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Eaꞌ naꞌi, “Dembinai, deiꞌ ahapifina.” Naꞌias naꞌamba eaꞌ, nindiwa nembawa notawa itap nanifelona nasaꞌma agol ananigili. ");
INSERT INTO aoj_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Jisas naꞌi, “Aeꞌ afiꞌi itap apaꞌe ma ewaloga epes hiasi hiꞌigalas. Ama esis naep pagasoꞌasi atiasi sogati andeandeꞌ a isimba naep pagatiasi eaꞌ naep peseꞌas.” ");
INSERT INTO aoj_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Anom Farisi mape malomana mameꞌ basef ifimba mahaliꞌana maꞌi, “Ifimba basef maif? Inaꞌ naꞌi afaꞌ naep pasoꞌafa wapani aꞌamon?” ");
INSERT INTO aoj_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Jisas naꞌipam naꞌi, “Iꞌi ipaꞌ naep peseꞌepa ai, ipaꞌ waf awafi akepa. Apaꞌ owaꞌ, owaꞌatin. Ipaꞌ apaꞌi, ‘Afaꞌ wagatii.’ Naꞌamba waf awafi ipeꞌifi ataꞌ fapomepa.” ");
INSERT INTO aoj_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Jisas naꞌi, “Endilisi aeꞌ aꞌipipa, epen ami owaꞌ nusiꞌ uta indalelemb sipsipia ma anin nelota niwisi anagon daiagona, epen inimba nandaꞌ wali. ");
INSERT INTO aoj_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Apaꞌ epen inimba usiꞌini nigawisi utai, anin nigimafi sipsipi. ");
INSERT INTO aoj_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Aman nugumafi utai nawisiꞌman uta ma nugumafi sipsip. Amom sipsip mameꞌ malogol ananigili. Nofala agofa sipsip ananimi, eaꞌ naoꞌwam mawisi andoꞌ. ");
INSERT INTO aoj_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Naoꞌwa sipsip ananimi hiami mawisi andoꞌ hiꞌalam eaꞌ naliꞌ nafeꞌ, amom magiꞌmana. Deiꞌ main? Amom mogawa malogol ananigili. ");
INSERT INTO aoj_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Apaꞌ sipsip ina magiꞌma anona daiana, owaꞌ. Naꞌamba mondafaꞌmana aꞌ mofaꞌ mefeꞌ atona biana. Deiꞌ main? Amom ina mogawa malogol ananigili, owaꞌ.? ");
INSERT INTO aoj_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Eaꞌ Jisas naꞌipasa basef waminif atin naꞌamba, apaꞌ esis ina sogawa basef kofagefa, owaꞌatin. ");
INSERT INTO aoj_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Eaꞌ Jisas naꞌipas wapani naꞌi, “Endilisi aeꞌ aꞌipipa, aeꞌ siꞌi uta sipsip mugawisatai. ");
INSERT INTO aoj_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Amom fowaꞌ mugumafi sipsipi, hiami mandaꞌ wali apaꞌ sipsip ina mameꞌ malogof amamugufi, owaꞌ. ");
INSERT INTO aoj_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Aeꞌ siꞌi uta, epen ami niwisi aeꞌ nomon, God nuwambilai anin nokwahoman waf awafi nepe andeandeꞌ. Anin nifiꞌi niwisi niwis nepe netaga nefeꞌ nefaꞌ gwaꞌaisi buꞌwasi. ");
INSERT INTO aoj_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Amom mandaꞌ wali mafiꞌi ma mondaꞌ wal mohas sogaꞌ mogahambombagas. Apaꞌ aeꞌ afiꞌi ma ipaꞌ pegape andeandeꞌ ambal lopaipa endilisi aꞌowaꞌ. ");
INSERT INTO aoj_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Aeꞌ aman buꞌuwai igimafi sipsipi, aꞌi ahoꞌ ma egagaꞌ ma egatopalopa sipsip igimafiami. ");
INSERT INTO aoj_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Iꞌi anona aman nondaꞌ kontrak dowafi ma nugumafi sipsip amambai, anen okom miꞌi nogofaꞌ otamba atembai, anen ina atiasi numafi sipsip andeandeꞌ, owaꞌ. Anen ina aman endilisi nugumafi sipsipi, owaꞌ. Eaꞌ nemaf mamahefa niti nombagw gwagail alupi gugafiꞌi, aꞌ ombal mohana nokwaha sipsip atom mulutu nofaꞌ nefeꞌ. Eaꞌ nombagw agwamba guwis goha sipsip mofaꞌ mefeꞌ atona biana. ");
INSERT INTO aoj_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Aman anamba nandaꞌ maola otamba atembai, anen nandaiwaꞌma nugumafi sipsip amamba andeandeꞌ, owaꞌ. Eaꞌ atiasi niti nombagw agwamba aꞌ ombal mohana nofaꞌ nefeꞌ. ");
INSERT INTO aoj_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","“Aeꞌ aman buꞌuwai igimafi sipsip andeandeꞌi. Aeꞌ egawa sipsip aeꞌami a sipsip mogawa aeꞌ wapani. ");
INSERT INTO aoj_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Eaꞌ naꞌamba atin ahame aeꞌanai nogawa aeꞌ, aeꞌ egawa anen. Aeꞌ aꞌi ahoꞌma egaꞌ egatopalopa sipsip aeꞌami. ");
INSERT INTO aoj_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Aeꞌ anom sipsip daiam malutumi. Apaꞌ amom ina malutu nomon indalelemb ambalemba, owaꞌ. Amom magalutu indalelemb anagon daiagini. Aeꞌ okom maꞌiam aꞌowaꞌ anef nemaf aꞌ efaꞌam mifiꞌi memeꞌ malogol aeꞌigili ekolasom mulutu indalelemb atelemb aeꞌ atowe imafiam. ");
INSERT INTO aoj_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Aeꞌ aꞌi ahoꞌma egagaꞌ ma atiasi esafel egape namowe wapani. Isimba atis ahame aeꞌanai okom maimaili aꞌowaꞌ. ");
INSERT INTO aoj_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Ina anona aman noha ambal aeꞌali egaꞌ, owaꞌatin. Okom aeꞌami atom maꞌi ahoꞌma atiasi egagaꞌ. Aeꞌ efaꞌ agol luꞌwagili ma egaꞌ egesafel wapani. Agol agalemba ahame atona naseꞌeagol.” ");
INSERT INTO aoj_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","20","Esis Juda sameꞌ basef ifimba eaꞌ esis sandatopaꞌ biafis. Hiasi saꞌi, “Ambagof awami mapaona eaꞌ nahaga nagaol aꞌowaꞌ. Deiꞌ maina ipaꞌ pagameꞌ malogol ananigili?” ");
INSERT INTO aoj_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Apaꞌ anis daias saꞌi, “Anona aman ambagof awami magapaunai ina naꞌi anif basef siꞌi anen nagaꞌiefi, owaꞌ. Anona aman ambagof awami magapaunai ai, ina laꞌifinama nondaꞌ aman anamba naep pagasoꞌanai nogati wapani, owaꞌatin.” ");
INSERT INTO aoj_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","23","Nogota atamba asaf atef fagalatama esis Juda sandaꞌ anis gwaꞌaisi luꞌwasi ma ukup pagapoma fowaꞌ gani sagawisi ipat Godi. Eaꞌ Jisas nafeꞌ nomon ipat luꞌunai Godi ilafunama saleꞌw fowaꞌ Solomon nandaꞌakwi. ");
INSERT INTO aoj_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Eaꞌ amom Juda mafiꞌi malutu malipana maꞌi, “Nimaguf mamahifa inaꞌ nendaꞌ opalef afaꞌilifi fetaga nomonas biafis? Iꞌi inaꞌ Kraisai, niꞌipafa basef alihif.” ");
INSERT INTO aoj_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Jisas nagwamam naꞌi, “Aeꞌ aꞌipipa eaꞌ, apaꞌ ipaꞌ ina ukup pehafel pahapifi, owaꞌ. Aeꞌ andaꞌ hiahaom banagami ma agol ahamai, amamba mihimbaꞌmepa aeꞌ epen mamahowema. ");
INSERT INTO aoj_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Apaꞌ ipaꞌ ina sipsip aeꞌipai, owaꞌ. Ipaꞌ anipa daipa. Naꞌamba deiꞌ ipaꞌ ina pahapifa aeꞌ, owaꞌ. ");
INSERT INTO aoj_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Sipsip aeꞌami mameꞌ malogol aeꞌagili eaꞌ egawam mameꞌ basef aeꞌafi maili. ");
INSERT INTO aoj_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Aeꞌ egasoꞌam ambal namili ma mogape andeandeꞌ dondol lifilafi. Amom ina mogaꞌ, owaꞌatin. Ina anin epen laꞌifina netagwahom lagof aeꞌagufi negefaꞌam, owaꞌatin endilisi. Amom mope lagof aeꞌagufi atapim dondol lifilafi. ");
INSERT INTO aoj_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","“Ahame aeꞌanai naseꞌe epes isimba aeꞌasi. Ina anin epen atiasi laꞌifina nitagwahis lagol ahamai negefaꞌas, owaꞌatin. Deiꞌ main, ahame aeꞌanai banagonai aꞌowaꞌ nikilaꞌ epes hiasi hiꞌalas. ");
INSERT INTO aoj_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Aeꞌ aloma ahame, afaꞌ biafa wape atotofa.” ");
INSERT INTO aoj_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Eaꞌ amom Juda mafeꞌ mofaꞌi otamba wapani maꞌi mokwahemba mohana afuna. ");
INSERT INTO aoj_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Apa Jisas naꞌipam naꞌi, “Aeꞌ ihimbaꞌmepa maol buꞌwani hiami nagataga Ahamai eaꞌ patilin. Apaꞌ ukup ipeꞌipi papoma maol mamahina andaꞌani ma deiꞌ paꞌi pekwaha otamba pegahe?” ");
INSERT INTO aoj_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Amam Juda magwamana maꞌi, “Afaꞌ ina wakwaha otamba waꞌi ohena ma anin maol buꞌwani, owaꞌ. Inaꞌ aman falafunai nandaꞌ findiwa, naꞌi inaꞌ atina God. Eaꞌ afaꞌ waꞌi ohena otamba.” ");
INSERT INTO aoj_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Jisas nagwamam naꞌi, “Anif basef fagail muꞌuli ipeꞌini faꞌias faꞌi, ‘Aeꞌ aꞌipipa eaꞌ aꞌi, ipaꞌ siꞌi anom god daiam.’ ");
INSERT INTO aoj_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","36","Fowaꞌ basef Godi fafeꞌma epes isimba faꞌi, ‘God naꞌi ipaꞌ siꞌi anom god daiam.’ Basef ifimba ina fenalo, owaꞌ. Fape atapif fandawalap endilisi. Ahame aeꞌanai atona nosaheꞌe nandaꞌe ape hililiꞌ ananiwai atowe nasapaꞌe afiꞌi itap apaꞌe endaꞌ maol ananini. Eaꞌ aꞌi aeꞌ Nogamana ananiwai. Deiꞌ maina ipaꞌ pagaꞌi, aeꞌ andaꞌ God findiwana?’ ");
INSERT INTO aoj_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Iꞌi aeꞌ ina andaꞌ maol Ahame aeꞌanaiai, daoꞌ andeandeꞌma ipaꞌ pindaiwaꞌ ma pigahapifi. ");
INSERT INTO aoj_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Apaꞌ aeꞌ andaꞌ maol ananini ma iꞌi ipaꞌ owaꞌ pihapifia, hapaimi. Ipaꞌ piti maol atin aeꞌani pegawa Ahame nape nalome, aeꞌ ape alomana.” ");
INSERT INTO aoj_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Eaꞌ amom maꞌi mombaloꞌana ma mogowaꞌana. Owaꞌ, owaꞌatin. Anen nakwaha amom aꞌ nafeꞌ. ");
INSERT INTO aoj_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Jisas notanima natopaꞌ walemb Jordan nambo fisana nafeꞌ nataga anamba fowaꞌ dambadamba Jon nagapisiꞌasa nape naꞌamba. ");
INSERT INTO aoj_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Eaꞌ amam nematawa hiasi safiꞌmai anen. Esis saꞌi, “Jon owaꞌ nondaꞌ anin maol banagania, apaꞌ basef ananifi hiafi nagaꞌifa Jisasi, ifimba endilisifi atif.” ");
INSERT INTO aoj_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Eaꞌ amam nematawa hiasi sahapifa Jisas naꞌamba. ");
INSERT INTO aoj_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","2","Anona aman aowas nandaꞌanai agol ananigili Lasarus. Anen naloma hanitiamana ananiwai biawa, Maria kwaloma Marta sape wambel ambalemba Betani. Maria akwamba fowaꞌ kwagakoloꞌwa sanda balaga Dembinaii ma kwandaꞌ auf balaga akoꞌugai kwagandisamana boꞌwagah ananigahi. ");
INSERT INTO aoj_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Eaꞌ awo wasapaꞌ basef fafeꞌma Jisas waꞌi, “Dembinai, aman anamba inaꞌ okom magamagailanai aꞌ awasina naꞌoh.” ");
INSERT INTO aoj_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Eaꞌ Jisas nameꞌ basef ifimba naꞌi, “Aowas inimba ina natagamana ma nogagaꞌ, owaꞌ. Aowas inimba natagamana ma esis sogasaꞌma agol aeꞌ Nogamana Godi, a sogasaꞌma agol ananigili wapani.” ");
INSERT INTO aoj_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Eaꞌ Jisas okom maimaila Marta kwaloma owamaꞌw Maria waloma Lasarus. ");
INSERT INTO aoj_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Anen nameꞌ basefa Lasarus awasina, apaꞌ anen ataꞌ napani nimaguf bif wapani wambel ambalemba nagapanima. ");
INSERT INTO aoj_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Nimaguf bif fafeꞌma eaꞌ, naꞌipa alipumi ananimi naꞌi, “Afaꞌ deiꞌ aꞌ otanima ofeꞌ itap luꞌupa Judia.” ");
INSERT INTO aoj_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Eaꞌ alipumi ananimi magwamana maꞌi, “Dembinai tisa, nimbewaꞌ esis Juda saꞌi sokwaha otamba sehena afina, apaꞌ deiꞌ inaꞌ naꞌi netanima nefeꞌ anamba wapani, aꞌamon?” ");
INSERT INTO aoj_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Eaꞌ Jisas nagwamam naꞌi, “Nemaf atetef awa 12-pelain nape. Epen ami nagafeꞌ alipi anin ina newa, owaꞌ. Deiꞌ main, anin nati hauguma itap apaꞌe howalagon nafeꞌ andeandeꞌ. ");
INSERT INTO aoj_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Apaꞌ iꞌi anin negafeꞌ owambi, atiasi aꞌ newa. Deiꞌ main? Anin nagwapin nogogalaꞌi akan.” ");
INSERT INTO aoj_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Jisas naꞌipam naꞌamba ma eaꞌ, naꞌipam wapani naꞌi, “Alipunai afaꞌinai Lasarus anen naꞌoh. Aeꞌ atiasi efeꞌ ganimba itap Judia ma iginimbalona.” ");
INSERT INTO aoj_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Eaꞌ alipumi ananimi magwamana basef maꞌi, “Dembinai, iꞌi anen noꞌoh atinai, daoꞌ atiasi amboꞌona.” ");
INSERT INTO aoj_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Dokoꞌ Jisas naliꞌ nagaꞌipam naꞌi Lasarus nagaꞌoh, faꞌi Lasarus aꞌ nagaꞌ endilisi. Apaꞌ alipumi ananimi ukup paꞌi anen ataꞌ naꞌoh dowaf. ");
INSERT INTO aoj_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Deiꞌ Jisas naꞌipam alihif naꞌi, “Lasarus aꞌ nagaꞌ eaꞌ endilisi. ");
INSERT INTO aoj_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Aeꞌ sonahe ma aeꞌ ina alomana wape atogon nemaf anen nagagaꞌafi. Ama ipaꞌ atiasi pigahapifa aeꞌ. Deiꞌ afaꞌ ofeꞌma anen.” ");
INSERT INTO aoj_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Eaꞌ Tomas agol waꞌagol Didimas naꞌipa alipumi Jisasi daiam naꞌi, “Afaꞌ ofeꞌ wapani ma ogaꞌ ogaloma anen.” ");
INSERT INTO aoj_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Lasarus nagaꞌ aꞌ sawana. Nimaguf bifibif fafeꞌ eaꞌ, Jisas aꞌ nafiꞌi nataga. Anan nogawa Lasarus sawana nape wandof nimaguf bifibif. ");
INSERT INTO aoj_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","19","Wambel ambalemba Betani bape felefeleꞌma Jerusalem, siꞌi kilomita wanifin. Eaꞌ amom Juda hiami mafiꞌi ma mondaꞌ opalef hanitiamana biawa Martai Maria fegape saꞌumbela anen hanitinamawa nagagaꞌ. ");
INSERT INTO aoj_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Marta kwameꞌ basefa Jisas nafiꞌi atin, kwafeꞌ kowandoꞌmana ufiaꞌw, apaꞌ Maria ataꞌ kwapani ipat. ");
INSERT INTO aoj_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Eaꞌ Marta kwafeꞌma Jisas kwaꞌipana kwaꞌi, “Dembinai, iꞌi inaꞌ nepe naꞌaꞌe ai, hanitiname aeꞌanai ina nogaꞌ, owaꞌatin.” ");
INSERT INTO aoj_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Owaꞌ akoꞌw kwaꞌipana wapani kwaꞌi, “Aeꞌ egawa inaꞌ nigahaliꞌ Goda hiahawes mais, anen nogasiꞌinasi.” ");
INSERT INTO aoj_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Eaꞌ Jisas naꞌipaꞌw naꞌi, “Hanitinamena atiasi nogosafel wapanii.” ");
INSERT INTO aoj_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Eaꞌ Marta kwagwamana kwaꞌi, “Aeꞌ egawa anen anaf aꞌ nosafel wapani nemaf akutaifi afamba epes hiasi sagagaꞌi sogosafel wapaniefi.” ");
INSERT INTO aoj_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Eaꞌ Jisas naꞌipaꞌw naꞌi, “Kofagama epes sogosafel wapani ma sogofaꞌ ambal namili, aeꞌ atowe. Epen ami nihapifa aeꞌ, atiasi negaꞌ eaꞌ nesafel wapani nefaꞌ ambal namili nepe andeandeꞌ. ");
INSERT INTO aoj_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Epen ami ataꞌ nape namina nigahapifa aeꞌi, anin nepe andeandeꞌ. Ina negaꞌ wapani, owaꞌatin. Nepe lifilafi dondol. Inaꞌ nahapila basef ifimba, aꞌa owaꞌ?” ");
INSERT INTO aoj_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Eaꞌ kwaꞌipana kwaꞌi, “Ahoꞌ dembinai, aeꞌ ahapifa inaꞌ Krais, God nandandepena nasapaꞌena nagafiꞌii. Inaꞌ Nogamana ananinai, fowaꞌ anen naꞌi nigafiꞌi itap apaꞌi.” ");
INSERT INTO aoj_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Akoꞌw kwaꞌipana naꞌamba, kotanima kwafeꞌma owamaꞌw Maria kwaꞌipaꞌw saꞌosaꞌombel kwaꞌi, “Dembinai Tisa aꞌ nafiꞌi nataga nofalena.” ");
INSERT INTO aoj_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Maria kwameꞌ basef ifimba atin, kosafel kwafalis kwafeꞌmana. ");
INSERT INTO aoj_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Jisas ina deiꞌ nawisi wambel luꞌwambela laꞌafen, owaꞌ. Afaꞌ naili wambel diꞌimbili dokoꞌ Marta kwagatolonama. ");
INSERT INTO aoj_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Amom Juda mape maloma Maria nomon ipat awoutai maꞌi mowaꞌ banaga nomonas akoꞌusi ma sogape banages. Eaꞌ amom mati Maria kwasafel kwafalis kwafeꞌ. Amom ukup paꞌi owaꞌ akoꞌw kofeꞌ wandofa kogalopana. Eaꞌ magimaꞌw mafeꞌ. ");
INSERT INTO aoj_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Eaꞌ Maria kwafeꞌma anamba Jisas nagapoma kwatolona kundiwa nembawa felefeleꞌma boꞌwagah ananigahi kwaꞌipana kwaꞌi, “Dembinai, iꞌi inaꞌ nepe nelomapa ai, hanitiname aeꞌanai ina nogaꞌ, owaꞌatin. Apaꞌ owaꞌ napani laogon deiꞌ anen nagaꞌ.” ");
INSERT INTO aoj_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Jisas nati akoꞌw kwape kwalef atin eaꞌ nati amom Juda mafiꞌi malomaꞌw malef wapani. Eaꞌ nati esis uwahipis opaf ananifi aꞌ aof aꞌowaꞌ naꞌi aꞌ nelef atin. ");
INSERT INTO aoj_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Eaꞌ nahaliꞌas naꞌi, “Ipaꞌ pawana ani?” Eaꞌ esis saꞌipana saꞌi, “Dembinai, fiꞌi netelogon.” ");
INSERT INTO aoj_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Owaꞌ aꞌ nalef. ");
INSERT INTO aoj_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Amom Juda mati anen nalef naꞌamba maꞌi, “Ipaꞌ petolona! Anen okom maimailana aꞌowaꞌ.” ");
INSERT INTO aoj_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Apeꞌ anom maꞌi, “Aman anamba maꞌuna nandaꞌ aman anamba naep pagasoꞌanai ma deiꞌ pagatianai. Anen laꞌifinai ma fowaꞌ aꞌ niliꞌ nifiꞌi ma notopalopa aman anamba ai, deiꞌ aꞌ nope aꞌa nogaꞌ?” ");
INSERT INTO aoj_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Eaꞌ Jisas opaf nimanif endilisi nafeꞌ nataga wandof afamba luꞌwafi sagwasogon nagawis nomon otam luꞌunai. Eaꞌ sandaꞌ anona owap luꞌunai sowalo uta. ");
INSERT INTO aoj_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Eaꞌ naꞌipas naꞌi, “Ipaꞌ lefata owap anamba nogowalo utai.” Eaꞌ Marta hanitiꞌma aman anamba nagagaꞌi kwaꞌi, “Dembinai, anen aꞌ nape nimaguf bifibif eaꞌ. Deiꞌ alogw awami aꞌ mana.” ");
INSERT INTO aoj_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Owaꞌ Jisas naꞌipaꞌw naꞌi, “Fowaꞌ aliꞌ aꞌipina deiꞌ iꞌipina wapani, iꞌi inaꞌ nihapifa aeꞌ, atiasi niti mogogalaꞌi banagami Godi.” ");
INSERT INTO aoj_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","42","Eaꞌ esis selefata owap anamba eaꞌ Jisas naniga nati ilif naꞌi, “Ahame, aeꞌ anifelina ma nagameꞌe. Aeꞌ egawa inaꞌ nameꞌe lifilafi apaꞌ aeꞌ aꞌias naꞌamba ma esis amam nematawa sagalutu naꞌai sogahapifa aeꞌ, inaꞌ nasapaꞌe agafiꞌii.” ");
INSERT INTO aoj_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Jisas nandabeten naꞌamba eaꞌ, nofalana mehip naꞌi, “Lasarus, safel niwisi andoꞌ.” ");
INSERT INTO aoj_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Eaꞌ aman anamba nasafel nawisi andoꞌ. Apaꞌ boꞌwagah haloma lagof amaga ananimi sandaꞌ lowaf sombafana. Eaꞌ Jisas naꞌipas naꞌi, “Ipaꞌ tagwahomana luwaguf amamba eaꞌ pekwahona nefeꞌ wahifina.” ");
INSERT INTO aoj_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Amom Juda hiami mafiꞌi mati Maria malomaꞌw malef, eaꞌ mati amamba Jisas nandaꞌami. Eaꞌ aꞌ mahapifana. ");
INSERT INTO aoj_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Apaꞌ anom mafeꞌma amom dembami Farisi maꞌipama amamba Jisas nandaꞌami. ");
INSERT INTO aoj_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Eaꞌ amom pris dembami maloma amom Farisi hiami mofala anom dembami mafiꞌi mandakolasa mondaꞌ kot. Eaꞌ maꞌi, “Afaꞌ atiasi ondaꞌ maina aman anamba nandaꞌ maol banaganii? ");
INSERT INTO aoj_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Iꞌi ope ogatotolona ma nondaꞌ maol inimba, atiasi hiasi asohapifana hiꞌilas. Eaꞌ amom Rom atiasi mifiꞌi mohambombaga ipat luꞌunai Godi noloma apaꞌ Juda hiapai wapani.” ");
INSERT INTO aoj_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Eaꞌ anona aman agilinai Judai agol Kaiafas, anen dembinai pris nape nagaliꞌma pris hiamii ma afagol agalemba naꞌipam naꞌi, “Ipaꞌ ina pegawa anis hiahawes, owaꞌatin. ");
INSERT INTO aoj_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Ipaꞌ ina deiꞌ pegawa anif basef, owaꞌ. Iꞌi aman atotona nogagaꞌma amam nematawa hiasi, naꞌambai aꞌ andeandeꞌma ipaꞌ. Afaꞌ wandaiwaꞌ ma esis sogahambombaga apaꞌ Juda. Naꞌamba miniꞌap apeꞌipi Judai aꞌ lamonap.” ");
INSERT INTO aoj_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Anen ina naꞌi basef ifimba ma okom ananimi atom, owaꞌatin. Anen nape pris dembinai afagol agalemba. Eaꞌ naꞌi basef Ambal buꞌunai Godi nagaꞌipanaefi siꞌi profet naꞌi Jisas aꞌ nondagaꞌ ma nogatopalopa esis Juda hiasi. ");
INSERT INTO aoj_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Kaiafas naꞌi Jisas ina aꞌ nogaꞌ notopalopa esis Juda atis, owaꞌatin. Anen nogaꞌ ma nogatopalopa epes Godi hiasi sapesasa sagafeꞌ itap hiagomai hiꞌilas nuwambilasi nondaꞌas sogataga miniꞌap atetep. ");
INSERT INTO aoj_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Nemaf afamba atef amom agufumi Judai aꞌ maliꞌ maꞌi basef mandameꞌmaefa moha Jisas nogagaꞌ. ");
INSERT INTO aoj_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Eaꞌ Jisas ina ataꞌ nafeꞌ alihina anamba esis Juda sagapoma, aꞌ owaꞌ. Anen nafeꞌ nandambahoꞌ atin felefeleꞌma anamba wafigima fataupigima ma wambel ambalemba Ifraim. Nape naꞌamba naloma alipumi ananimi. ");
INSERT INTO aoj_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Ina nogota laota ma esis Juda sogaꞌ gwaꞌaisi luꞌwasi sagaꞌi Pasovai, owaꞌ. Eaꞌ esis Juda hiasi sakwaha walemb asasilimbi aꞌ safeꞌ Jerusalem atogon. Safeꞌma sigaila basef Godi fowaꞌifi sosaꞌof sotofa alogwa sogandondomba alop asasipi ma God negati esis boꞌwes hililiꞌ ma sogaꞌ gwaꞌaisi isimba. ");
INSERT INTO aoj_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Esis sape ipat luꞌunai Godi nomon sowandoꞌma Jisas eaꞌ sahaliꞌas saꞌi, “Ipaꞌ ukup pape paꞌimama? Anen atiasi nifiꞌmai gwaꞌaisi isimba aꞌa owaꞌ?” ");
INSERT INTO aoj_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Eaꞌ amom pris dembami maloma amom Farisi hiami maꞌias dindinip maꞌi, “Epen ami negawa Jisas nagapoma niꞌipafa ofeꞌ ombaloꞌana ma ondaꞌmana basef.” ");
INSERT INTO aoj_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Nimaguf wanif wanif ataꞌ fapoma esis Juda sondaꞌ gwaꞌaisi isimba luꞌwasi Pasova. Nemaf afamba Jisas aꞌ nataga wambel Betani, alipunai Lasarus nagapoma. Fowaꞌ nagaꞌma Jisas nasaꞌmana nogosafel wapanii. ");
INSERT INTO aoj_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Eaꞌ sandaꞌmana gwaꞌaisi Jisas. Marta kwandaꞌ gwaꞌaisi, apaꞌ Lasarus nape nalomas sape saꞌ gwaꞌaisi saloma Jisas. ");
INSERT INTO aoj_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Eaꞌ Maria kwahapila anop kap siꞌipa sanda buꞌwani agilina nad sagatalin otamba hiambaii. Eaꞌ kwahapilan kwakoloꞌwan kwandisamana boꞌwagah Jisasi kwandaꞌ auf balaga akoꞌugai kopatiꞌmanan. Eaꞌ ipat atamba asiꞌitama alogw buꞌwagwi ma sanda inimbai. ");
INSERT INTO aoj_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Apaꞌ anona alipunai Jisasi Judas Keriotinai kowalana ma sanda inimba nandaiwaꞌma kwakoloꞌwan kwagasapelin. Aman anamba atiasi aꞌ nogowalapa Jisas nigaꞌipa amom boumianai. ");
INSERT INTO aoj_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","Eaꞌ Judas naꞌipas naꞌi, “Iꞌi afaꞌ ofaꞌ sanda inimba anis epes sosoꞌafa moni 300 kina sotalina ofaꞌan ogasoꞌ epes isimba kwahusa gwaꞌaisi mainai, daoꞌ andeandeꞌ. Apaꞌ owaꞌ, owaꞌatin.” ");
INSERT INTO aoj_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Apaꞌ Judas okom ananimi ina maꞌi notopalopa isimba kwahusa hiahawesi, owaꞌatin. Anen naꞌias naꞌamba ma nondaꞌ wal nogofaꞌamba. Deiꞌ main, anen nugumafi bokis isimba Jisas naloma alipumi ananimi mala otamba amamimbai bagalasi ma dondol nandaꞌ wala anemba. Eaꞌ Jisas nagwamana basef naꞌi, ");
INSERT INTO aoj_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","8","“Ipaꞌ owaꞌi piꞌipaꞌw basef ifimbaia, owaꞌi. Andeandeꞌma akoꞌw kwagakoloꞌwa sanda inimba ma atiasi nemaf afamba sehe igagaꞌafi ma sogawe. Isimba kwahusa gwaꞌaisi maini sape salomepa nimaguf hiafi. Apaꞌ aeꞌ ina epe egalomepa nogota lautai, owaꞌ.” ");
INSERT INTO aoj_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Esis Juda hiasi sameꞌ basefa Jisas nape Betani. Eaꞌ safiꞌi saꞌi sotolona eaꞌ saꞌi siti Lasarus wapani, nimbewaꞌ nagaꞌma Jisas nasaꞌmana nogosafel wapanii. ");
INSERT INTO aoj_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Eaꞌ amom pris dembami maꞌi basef mandameꞌmaefa moha Lasarus nogagaꞌ wapani. ");
INSERT INTO aoj_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Deiꞌ main, anis Juda hiasi sati Lasarus notanima nosafel ambal lapaona. Isimba atis deiꞌ sakwaha amom dembami Juda asafeꞌ saila Jisas sahapifana. ");
INSERT INTO aoj_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Wafilu epes hiasi safiꞌmai gwaꞌaisi isimba Pasova, sameꞌ basefa Jisas ataꞌ nafiꞌi atin Jerusalem. ");
INSERT INTO aoj_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Eaꞌ satopaꞌ agof lawahiguf apilugufa sahapilagof safiꞌi satagamana ufiaꞌw. Eaꞌ soga saꞌi mehip saꞌi, “Hosana. Apaꞌ mandanifal endilisi ma inaꞌ. Apaꞌ maꞌi God nofaloꞌma inaꞌ nagafiꞌi agol ananigilii neseꞌena banagami ma nendaꞌ maol ananini. Inaꞌ king dembinai apaꞌ Israeli.” ");
INSERT INTO aoj_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","15","Eaꞌ Jisas nowandoꞌma donki atitin saꞌuni natilin nandagala natoman nafeꞌ siꞌi fowaꞌ anif basef Godi fagail Buk Baibeli fagaꞌi, “Ipaꞌ wambel Saion, ipaꞌ ina ombal mehepa, owaꞌi. Dembinai king ipeꞌinai anaf notoma donki noganai nofaꞌana nifiꞌi.” ");
INSERT INTO aoj_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Nemaf afamba alipumi Jisasi ina mogawa basef ifimba kofagefa fagaꞌi Jisasi, owaꞌatin. Ama nogota atamba Jisas nogaꞌ ma nosafel wapani notanima nogalota ilif, daoꞌ amom aꞌ mogawa basef ifimba fagaꞌi anini. Eaꞌ ukup pepoma amamba epes isimba sandaꞌmanam anini wapani. ");
INSERT INTO aoj_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Anis epes saliꞌ sati Jisas nogofala aman anamba nagagaꞌi Lasarus napani matmat nogosafel wapani. Eaꞌ saꞌipa hiasi ma basef ifimba Lasarasi. ");
INSERT INTO aoj_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Eaꞌ epes hiasi sameꞌ basefa Jisas nandaꞌ hiahaom banagami siꞌi God nandaꞌami. Eaꞌ deiꞌ safeꞌ satolona. ");
INSERT INTO aoj_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Eaꞌ amom Farisi mandaꞌipama maꞌi, “Maol afaꞌini ina laꞌifin, owaꞌ. Afaꞌ agof akafa. Piti amam nematawa hiasi safiꞌmai anen atona hiꞌalas.” ");
INSERT INTO aoj_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Epes hiasi safeꞌ Jerusalem ama gwaꞌaisi isimba luꞌwasi sondaꞌ lotuma God. Eaꞌ anom Grik wapani mafeꞌ malomas. ");
INSERT INTO aoj_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Anona aman alipunai Jisasi Filip anen Betsaidainai itap luꞌupa Galili. Amom Grik mafiꞌmai gwaꞌaisi isimba eaꞌ mafiꞌmai Filip maꞌipana maꞌi, “Dembinai, afaꞌ waꞌi uti Jisas.” ");
INSERT INTO aoj_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Filip nafeꞌ naꞌipa Andru, amom biam mafeꞌ maꞌipa Jisas. ");
INSERT INTO aoj_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Eaꞌ Jisas nagwamam naꞌipam naꞌi, “Aeꞌ ataga epen egefaꞌ alop epesi aꞌ afiꞌi. Nogota atamba anis asasaꞌma agol aeꞌagili luꞌwagol. ");
INSERT INTO aoj_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Aeꞌ aꞌipipa basef endilisifi, iꞌi olemb witimb owaꞌ bewa itap nomona, olemb ambamba bepe atifimb. Apaꞌ iꞌi bewa begewala itap nomon, daoꞌ ambamba ambetaga belo bil hiambi. ");
INSERT INTO aoj_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Epen ami okom mopoma ambal ananili atol niꞌi nihapilal tatalaꞌil, anaf ambal ananili higililal. Apaꞌ epen ami okom mopoma aeꞌ ma nesambala ambal ananili itap apaꞌe, anaf God aꞌ nofaꞌal lotanimai nepe andeandeꞌ lifilafi. ");
INSERT INTO aoj_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Epen ami niꞌi nendaꞌ maol aeꞌanii, anin aꞌ nindaila aeꞌ. Mamahagoma aeꞌ egapoma, inimba nandaꞌ maola aeꞌi anin negapoma anamba. Eaꞌ epen ami nendaꞌ maol aeꞌanii, Ahame aeꞌanai atiasi nosaꞌma agol ananigili. ");
INSERT INTO aoj_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Eaꞌ Jisas naꞌipas wapani naꞌi, “Deiꞌ opaf aeꞌafi bolalaf afataga aof. Aeꞌ basef owaꞌatina igaꞌif. Atiasi aeꞌ aꞌ iꞌi, ‘Ahame, inaꞌ liꞌamona akafimi amamba maꞌi mogatagama aeꞌ deiꞌi aꞌa?’ Owaꞌatin. Aeꞌ afiꞌi nogota ataꞌe ape itap apaꞌe ma maol inimba atin aeꞌ endaꞌana sehe egagaꞌ. ");
INSERT INTO aoj_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Ahame, inaꞌ nendaꞌama epes hiasi sogasaꞌma agol ineꞌigili luꞌwagol.” Eaꞌ anogol malogol gaꞌi gatagai heven gaꞌi, “Aeꞌ andaꞌama sogasaꞌma agol aeꞌagili gogataga luꞌwagol, owaꞌ atiasi endaꞌagol gotaga luꞌwagol wapani.” ");
INSERT INTO aoj_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Eaꞌ anis amam nematawa hiasi salutu sagameꞌ malogol agalembai saꞌi, “Owaꞌ, otaga diwala.” Apaꞌ anis saꞌi, “Anona ensel naꞌipana anif basef.” ");
INSERT INTO aoj_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Eaꞌ Jisas naꞌi, “Malogol agalemba ina gaꞌi ma gogatopalopa aeꞌ, owaꞌ. Agalemba gaꞌi ma gogatopalopa ipaꞌ. ");
INSERT INTO aoj_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Deiꞌ Ahame God aꞌ nawaloga wafa amam nematawa hiasi sagape itap apai eaꞌ natofa dembinai nugumafi itap apai. ");
INSERT INTO aoj_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Atiasi esis sendele il atin lawag usiꞌigai tiꞌwanaegai ilifa atiasi ihindiꞌai esis amam nematawa hiasi sifiꞌmai aeꞌ hiꞌigalas.” ");
INSERT INTO aoj_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Jisas naꞌipas naꞌamba ma nigihimbaꞌmas sogogawa ufiaꞌw anen atiasi nogagaꞌakwi. ");
INSERT INTO aoj_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Eaꞌ esis sagwamana saꞌi, “Muꞌuli apeꞌini nagaꞌi naꞌamba naꞌi, Krais anen nogape lifilafi dondoli. Deiꞌ maina inaꞌ nagaꞌi, ‘Anen nataga epen nogofaꞌ alop epesi atiasi sogandolona lawag usiꞌigai tiꞌwanaegai ilif?’ Dembinai nataga epen nogofaꞌ alop epesi, anen epen mamahonama?” ");
INSERT INTO aoj_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Eaꞌ Jisas nagwamasa basef naꞌi, “Nogota ataꞌ bandata ma nagwapin nogalaꞌ nogalomepa. Deiꞌ ipaꞌ aꞌ pendafeꞌ hauguma. Naꞌamba owamb botagamepa. Epen ami negafeꞌ owambi, anin ina negawa anamba negafeꞌma, owaꞌ. ");
INSERT INTO aoj_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Aeꞌ ape siꞌi nagwapin ipeꞌini. Ipaꞌ pindahapifa nagwapin inimba ma pegataga awasi nagwapin nogogalaꞌi.” Jisas naꞌipas eaꞌ, nakwaha esis aꞌ nafeꞌ nandambahoꞌmas. ");
INSERT INTO aoj_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Jisas aꞌ nandaꞌ maol banagani hiani, siꞌi God nandaꞌani esis satilin. Apaꞌ esis ina sahapifana, owaꞌ. ");
INSERT INTO aoj_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Siꞌi basef ifimba fowaꞌ profet Aisaia nandaꞌafi fagaꞌias deiꞌ fataga fandawalap faꞌi, “Anaf epes ami sohapila basef afaꞌifi? Esis sogati banagami Godi esis mamahisa? Owaꞌatin.” ");
INSERT INTO aoj_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","40","Esis ina laꞌifisa sogahapifa Jisas. Deiꞌ main, profet anamba Aisaia nandaꞌ anif basef Godi wapani fagaꞌias naꞌamba faꞌi, “Anen nandaꞌ naep asasipi apasoꞌas nandaꞌ ukup asasipi pasoꞌ ma ina atiasi sotologon eaꞌ ukup asasipi wapani ina atiasi sogawa ma sogambema nelelemba aeꞌ endaꞌas boꞌwes, owaꞌatin.” ");
INSERT INTO aoj_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Fowaꞌ Aisaia nati banagami mogogalaꞌi Jisasi eaꞌ naꞌias naꞌamba ma anen atona. ");
INSERT INTO aoj_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Amom agufumi hiami aꞌ mahapifa Jisas. Apaꞌ owaꞌ, amom ombal bahama amom Farisi dembami. Eaꞌ amom ina mawalapa basef maꞌipasef alihif, owaꞌ. Ombal bahama amom Farisi mogaliꞌamonama ina ataꞌ moloma esis Juda mondaꞌ lotu wapani, owaꞌ. ");
INSERT INTO aoj_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Amom agufumi amamba ukup paꞌi esis aꞌowaꞌ ma sogasaꞌma agof amamugufi atogof luꞌwagof. Apaꞌ amom ina ukup paꞌi God nosaꞌma agof amamugufi, owaꞌatin. ");
INSERT INTO aoj_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Eaꞌ Jisas naꞌipas dindinip naꞌi, “Epen nigahapifa aeꞌi, anin ina nahapifa aeꞌ atowe, owaꞌ. Anin nahapifa anen nasapaꞌe agafiꞌii wapani. ");
INSERT INTO aoj_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Epen ami niti aeꞌ anin nati anen nasapaꞌe agafiꞌii wapani. ");
INSERT INTO aoj_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Aeꞌ afiꞌi itap apaꞌe siꞌi anin nagwapin ama epen ami nigahapifai, anin ina aꞌ nepe owamb, owaꞌatin. ");
INSERT INTO aoj_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Epen ami nemeꞌ basef aeꞌafi ma owaꞌ nihapifif nilifa, aeꞌ ina anaf ewaloga anin, owaꞌ. Deiꞌ main? Aeꞌ ina afiꞌi itap apaꞌe ma egawaloga epes sagape itapi, owaꞌatin. Aeꞌ afiꞌi ma iwambilas sogotanimai. ");
INSERT INTO aoj_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Epen ami negaseꞌe alafuga aeꞌi ma anin owaꞌ nihapifa aeꞌa, anaf anona dembinai jas aꞌ nowaloga anin. Nemaf afamba akutaifi basef ifimba atif aeꞌ agaꞌiefi ifimba fendaꞌ anin aꞌ fewawalogon. ");
INSERT INTO aoj_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Deiꞌ main? Aeꞌ ina aꞌi anif basefa okom aeꞌami atom magaꞌiefi, owaꞌ. Ahame aeꞌanai atona naꞌipi basef ifimba dindinipa igaꞌipasef. Eaꞌ anen nasapaꞌe afiꞌi aꞌif siꞌi okom ananimi magaꞌiefi. ");
INSERT INTO aoj_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Aeꞌ egawa basef ananifi fawalapa ambal namili ma ipaꞌ pegape andeandeꞌ lifilafi. Naꞌamba basef aeꞌ agaꞌipasafi eaꞌ ifimba atif siꞌi Ahame nagaꞌipiefi.” ");
INSERT INTO aoj_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Nemaf afamba luꞌwafi esis Juda sogaꞌ gwaꞌaisi isimba Pasova owaꞌ ataꞌ fetagaea. Jisas nogawa nogota ananitai aꞌ tataga ma nogakwaha itap apaꞌe nogafeꞌma Ahamana. Eaꞌ okom ananimi maimaila epes ananisi sagape itapi aꞌowaꞌ. Naꞌamba deiꞌ nihimbaꞌmasa okom ananimi luꞌwami magamagaila esisi. ");
INSERT INTO aoj_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Eaꞌ wambomota anen naloma alipumi mape maꞌ gwaꞌaisi isimba. Eaꞌ Saimon nogamana Judas Keriotinai nalomam mape. Owaꞌ aman aunai Satan aꞌ naliꞌ nasoꞌma nomonas Judasi ma nefeꞌ nigihimbaꞌma boumi ma Jisas nogapoma. ");
INSERT INTO aoj_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Eaꞌ Jisas nogawa Ahamana nandaꞌ anen banagona ma hiahaom hiami. Eaꞌ nogawa anen nape naloma God nafiꞌi eaꞌ atiasi aꞌ notanima nefeꞌmana wapani. ");
INSERT INTO aoj_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Eaꞌ nosafel natagwaha siot lautai ananitai nowahaꞌ anin taul. ");
INSERT INTO aoj_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Eaꞌ nakoloꞌ embel anis dis nafeꞌ notawa nasaꞌopamam boꞌwagah amom alipumi ananimi eaꞌ nandaꞌ taul alamba nogowahaꞌali nopatiꞌmamagah. ");
INSERT INTO aoj_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Nasaꞌopamagah nafeꞌ, natagama Saimon Pita. Owaꞌ Pita naꞌipana naꞌi, “Dembinai, negesaꞌopame boꞌwagah aeꞌagahi, owaꞌ.” ");
INSERT INTO aoj_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Eaꞌ Jisas nagwamana naꞌi, “Inaꞌ owaꞌ negawa maol inimba aeꞌ deiꞌ endaꞌania. Apaꞌ anaf daoꞌ, inaꞌ negawan.” ");
INSERT INTO aoj_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Eaꞌ Pita naꞌipa Jisas naꞌi, “Owaꞌ. Inaꞌ owaꞌi nesaꞌopa boꞌwagah aeꞌagahia, owaꞌ.” Owaꞌ Jisas nagwamana naꞌi, “Iꞌi aeꞌ owaꞌ esaꞌopamena boꞌwagah ineꞌigahia, ina atiasi nepe alipunai aeꞌinai, owaꞌatin.” ");
INSERT INTO aoj_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Eaꞌ Saimon Pita nagwamana naꞌi, “Dembinai, ina negesaꞌopame boꞌwagah atagah, owaꞌ. Nesaꞌope hiꞌili lagof balaga wapani sotaga beꞌes.” ");
INSERT INTO aoj_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Eaꞌ Jisas nagwamana naꞌi, “Epen ami nagasaꞌof eaꞌi, anin ina atiasi nesaꞌof wapani, owaꞌ. Anin boꞌwen eaꞌ. Ipaꞌ hipai ipaꞌ beꞌepa hililiꞌ, apaꞌ anona ipeꞌinai atotona ataꞌ owaꞌ boꞌona hililiꞌa.” ");
INSERT INTO aoj_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Deiꞌ main? Anen aꞌ nogawa ami atiasi nefeꞌ nigaꞌipa boumi ananimi ma nigihimbaꞌmama nogapomai. Eaꞌ naꞌipam naꞌi, “Ipaꞌ hipai ambeꞌepa hililiꞌ, apaꞌ anona ipeꞌinai atotona ataꞌ owaꞌ buꞌunaia.” ");
INSERT INTO aoj_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Anen nasaꞌopamam boꞌwagah amamugahi eaꞌ, nala siot ananitai nafeꞌ natoma felefeleꞌma tebol. Eaꞌ nahaliꞌam naꞌi, “Ipaꞌ pegawa maol inimba aeꞌ andaꞌmepani aꞌa owaꞌ? ");
INSERT INTO aoj_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Ipaꞌ pefale tisa aꞌa Dembiwai, naꞌamba andeandeꞌ. Aeꞌ eaꞌ maꞌuwi, basef ifimba endilisifi atif. ");
INSERT INTO aoj_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Aeꞌ Dembiwai ipeꞌiwai a tisa ipeꞌiwai. Aeꞌ dokoꞌ asaꞌopa boꞌwagah ipeꞌigahi. Eaꞌ ipaꞌ wapani aꞌ pendasaꞌopa boꞌwagah ipeꞌigahi atona atin. ");
INSERT INTO aoj_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Aeꞌ eaꞌ ihimbaꞌmepa waf afamba aeꞌafi. Ipaꞌ pendaꞌam naꞌamba atin siꞌi aeꞌ andaꞌam. ");
INSERT INTO aoj_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Deiꞌ aeꞌ aꞌipipa basef endilisifi atif. Epen inimba agol akani nandaꞌ maol dowadowafi, anin ina nape ilifa dembinai ananinai, owaꞌ. Eaꞌ anona dembinai nasapaꞌ anin nagafiꞌi, inimba ina nikilaꞌ dembinai anamba ananinai, owaꞌ. ");
INSERT INTO aoj_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","“Deiꞌ ipaꞌ pegawa waf afamba eaꞌ. Iꞌi pigiꞌmaf andeandeꞌ, daoꞌ a pendagala. ");
INSERT INTO aoj_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Aeꞌ basef ake ma ipaꞌ hipai pefeꞌ pewalapa basef pigaꞌipa boumi ma aeꞌ, owaꞌ. Aeꞌ egawepa andandepepa eaꞌ. Apaꞌ basef Godi fagail buk Baibeli atiasi fetaga endilisi ma anen nogawalapa aeꞌ ma boumii. Basef ifimba fagaꞌi naꞌamba faꞌi, ‘Aman anamba nogaꞌ gwaꞌaisi nugalumai atiasi nigi boꞌwaga egimugama nofaꞌasa aeꞌ.’ ");
INSERT INTO aoj_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","“Aeꞌ deiꞌ ape aꞌipipa basef ifimba ma waf afamba ina deiꞌ fataga, ataꞌ owaꞌatin. Ama atiasi fetaga fendawalap, daoꞌ ipaꞌ pihapifa aeꞌ eaꞌ maꞌuwi. ");
INSERT INTO aoj_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Aeꞌ aꞌipipa basef endilisi, epen ami negasoꞌan nembel anin epen aeꞌ agasapaꞌani, anin naseꞌe nembel aeꞌ. Eaꞌ epen ami negaseꞌe nembel aeꞌi, anin nasoꞌana nembel Ahame aeꞌanai wapani nasapaꞌe agafiꞌii.” ");
INSERT INTO aoj_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Jisas naꞌipam basef ifimba eaꞌ, okom ananimi nimanim aꞌowaꞌ. Eaꞌ naꞌipam naꞌi, “Aeꞌ aꞌipipa endilisi, anona afaꞌinai atiasi nefeꞌ nihimbaꞌma boumi ma aeꞌ egapoma.” ");
INSERT INTO aoj_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Eaꞌ alipumi ananimi mandaꞌ tima atin tol mape. Amom ina mogawa Jisas naꞌi ami. ");
INSERT INTO aoj_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Aeꞌ alipuwai Jisasi, anen okom magamagailai ape felefeleꞌ ma anen. ");
INSERT INTO aoj_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Eaꞌ Saimon Pita nandaꞌ balaga naꞌipi naꞌi, “Inaꞌ haliꞌago anen naꞌi ami.” ");
INSERT INTO aoj_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Eaꞌ aeꞌ indikiꞌah afeꞌ felefeleꞌma Jisas ahaliꞌana aꞌi, “Dembinai, inaꞌ naꞌi ami?” ");
INSERT INTO aoj_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Jisas nagwame naꞌi, “Aeꞌ atiasi ila bret nembaꞌw egasoꞌanotai, aman anamba eaꞌ maꞌuna anen.” Eaꞌ nala bret nembaꞌw nasoꞌ Judas Keriotinai Saimon nogamana. ");
INSERT INTO aoj_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Eaꞌ ataꞌ nahapila bret atin, owaꞌ aman aunai Satan aꞌ nawisana nembel ananimbili nomon. Eaꞌ Jisas naꞌipana naꞌi, “Maol inaꞌ naꞌi nendaꞌani daꞌan kwafalis.” ");
INSERT INTO aoj_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Apaꞌ afaꞌ alipufai Jisasi wape wagaꞌ gwaꞌaisii, afaꞌ ina ogawa basef Jisasi kofagefa, owaꞌ. ");
INSERT INTO aoj_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Judas nugumafi otamba afaꞌimbai. Naꞌamba anom alipumi Jisasi ukup pandandaꞌ paꞌi Jisas naꞌipana ma nefeꞌ nogotala anis gwaꞌaisi ma nondaꞌ gwaꞌaisi isimba aꞌa naꞌipana naꞌi nosoꞌasa anemba otamba isimba kwahusi. ");
INSERT INTO aoj_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Eaꞌ Judas ataꞌ nahapila bret atin, nafeꞌ nawis andoꞌ kwafalis. Eaꞌ owamb akot atowafai. ");
INSERT INTO aoj_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Eaꞌ Judas ataꞌ nafeꞌ atin nagawis andoꞌi, Jisas naꞌipam naꞌi, “Deiꞌ esis asosaꞌma agol aeꞌagili ataga epen egefaꞌ alop epesi luꞌwagol. Eaꞌ sosaꞌma agol Ahame Godi ma maol aeꞌ andaꞌani wapani. ");
INSERT INTO aoj_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Isimba atis Ahame God wapani nosaꞌma agol aeꞌagili luꞌwagol deiꞌ atefa maol anen nandaꞌani. ");
INSERT INTO aoj_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Ipaꞌ saꞌupai, aeꞌ elomepa ope nogota bandata aꞌ efeꞌ. Ipaꞌ atiasi pewandoꞌme apaꞌ ina atiasi petolowe, owaꞌ. Anamba aeꞌ egafeꞌma, ipaꞌ ina laꞌifipama atiasi pegafeꞌagono, owa. Basef ifimba atif fowaꞌ agaꞌipa amom Judafi, deiꞌ aꞌipipaef wapani. ");
INSERT INTO aoj_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Deiꞌ aseꞌepa muꞌuli aeꞌani dambaini ma ipaꞌ ukup pindaima atin siꞌi okom aeꞌami magamagaila ipaꞌ. Eaꞌ naꞌamba atin, ukup ipeꞌipi pindaima atin. ");
INSERT INTO aoj_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Iꞌi ukup ipeꞌipi pindaima atin, atiasi epes hiasi sogawa ipaꞌ alipipai aeꞌipai.” ");
INSERT INTO aoj_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Eaꞌ Saimon Pita nahaliꞌana naꞌi, “Dembinai, inaꞌ aꞌ nefeꞌ ani?” Jisas nagwamana naꞌi, “Anamba deiꞌ aeꞌ egafeꞌma, ina atiasi nigiꞌmi nefeꞌagono, owaꞌ. Apaꞌ anaf owagama daoꞌ, inaꞌ aꞌ nigiꞌmi nefoꞌo.” ");
INSERT INTO aoj_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Eaꞌ Pita nahaliꞌana naꞌi, “Dembinai, deiꞌ maina aeꞌ ina laꞌifiwi ma deiꞌ igagiꞌmina? Aeꞌ aꞌi ahoꞌma egaꞌ egalomena.” ");
INSERT INTO aoj_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Eaꞌ Jisas nagwamana basef naꞌi, “Inaꞌ naꞌi ahoꞌ endilisi ma negaꞌ negaloma aeꞌ aꞌamon? Aeꞌ aꞌipina endilisi, atiasi owamb ambaꞌe awata owaꞌ ataꞌ totaea, inaꞌ aꞌ nendahaliꞌmi niꞌias wanif niꞌi, ‘Aeꞌ owaꞌ egawa Jisasa.’” ");
INSERT INTO aoj_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Jisas naꞌipafa naꞌi, “Nelelemb ipeꞌilimbi ina besafel nimanilimb aꞌowaꞌ, owaꞌi. Ipaꞌ pindahapifa God, pihapifa aeꞌ wapani. ");
INSERT INTO aoj_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Ipat Ahame aeꞌanai alihinai satopaꞌ ilalef hielifi fape fandandapa. Iꞌi owaꞌai, fowaꞌ aeꞌ iꞌipipa. Apaꞌ owaꞌ, endilisi atis aeꞌ aꞌ efeꞌ endondomba wambel ipeꞌimbili. ");
INSERT INTO aoj_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Aeꞌ iꞌi efeꞌma egandomba wambel ipeꞌimbilima owagama itanimai efaꞌepa pefeꞌ pepe pelome. Eaꞌ anamba aeꞌ egapoma, ipaꞌ wapani pepe anamba atogon pelome. ");
INSERT INTO aoj_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Eaꞌ ipaꞌ aꞌ pegawa ufiaꞌw aeꞌ igafeꞌakwi ma wambel ambalemba.” ");
INSERT INTO aoj_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Tomas nahaliꞌana naꞌi, “Dembinai, afaꞌ owaꞌ ogawaia inaꞌ nefeꞌ ani? Afaꞌ ina ogawa ufiaꞌw akwamba inaꞌ naꞌi negafeꞌakwi.” ");
INSERT INTO aoj_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Eaꞌ Jisas naꞌipana naꞌi, “Aeꞌ atowe ufiaꞌw kofagewe ma basef endilisifi feloma ambal namili. Owaꞌ anin epen laꞌifina nefeꞌ negatagama Ahame anoꞌw ufiaꞌwa, owaꞌatin. Eaꞌ aeꞌ atowe. ");
INSERT INTO aoj_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Iꞌi ipaꞌ pegawa aeꞌ, Pegawa Ahame aeꞌanai wapani. Eaꞌ deiꞌ apatolona. Deiꞌ atef ipaꞌ patolona pegawana.” ");
INSERT INTO aoj_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Filip naꞌipana nahaliꞌana naꞌi, “Dembinai, inaꞌ himbaꞌmafa Ahamena ineꞌinai afaꞌ ma isimba eaꞌ sondahama afaꞌ.” ");
INSERT INTO aoj_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Eaꞌ Jisas naꞌipana naꞌi, “Filip, nogota eaꞌ lautai ape agalomepa, inaꞌ owaꞌ ataꞌ negawa eaꞌ? Epen ami nagati aeꞌ eaꞌi, anin aꞌ nati Ahame aeꞌanai wapani. Deiꞌ maina inaꞌ ataꞌ nagaꞌi, aeꞌ igihimbaꞌmepa Ahame ipaꞌ?’ ");
INSERT INTO aoj_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Inaꞌ nahapifa aeꞌ ma negawa aeꞌ aloma Ahame afaꞌ atotofa, aeꞌ ape anen, anen nape aeꞌ, aꞌa owaꞌ? Basef aeꞌ agasiꞌipafi, ifimba aeꞌ ina andaꞌef okom aeꞌami atom, owaꞌ. Ahame nape aeꞌ eaꞌ anen atona nandaꞌ maol ananini hiani. ");
INSERT INTO aoj_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Ipaꞌ pindahapifa basef ifimba. Aeꞌ ape Ahame, Ahame nape aeꞌ. Iꞌi owaꞌma, ipaꞌ ukup pendapoma maol banagani hiani andaꞌani. Ipaꞌ piti maol inimba, pindahapifi. ");
INSERT INTO aoj_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","“Basef endilisifi atif deiꞌ aꞌipipa. Epen ami nigahapifa aeꞌi, maol hiani deiꞌ andaꞌani, anin wapani atiasi nendaꞌan. Ama anaf nendaꞌ maol luꞌwani aꞌowaꞌ nikilaꞌ maol aeꞌani. Deiꞌ main? Aeꞌ efeꞌma Ahame. ");
INSERT INTO aoj_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Hiahawes hiasi ipaꞌ pendabeten pigahaliꞌanasa agol aeꞌagilii, atiasi aeꞌ indaꞌasi. Ama Ahame a nogofaꞌ agol luꞌwagilima maol aeꞌ Nogamana ananiwai atiasi indaꞌani. ");
INSERT INTO aoj_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Hiahawes ipaꞌ pigahaliꞌ aeꞌmasi ma agol aeꞌagili, pihapifi endilisi, daoꞌ atiasi indaꞌasi. ");
INSERT INTO aoj_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Iꞌi ipaꞌ ukup piꞌi aeꞌ endilisi, daoꞌ ipaꞌ pindagiꞌma muꞌuli aeꞌani andeandeꞌ. ");
INSERT INTO aoj_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Ama atiasi ihaliꞌ Ahame, ma nogasiꞌipai anona notopalopepa nogowaꞌ banagaipai. Anen nope nogaloma ipaꞌ lifilafi dondoli. ");
INSERT INTO aoj_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Anamba Ambal buꞌunai Godi nagaꞌi basef endilisifii. Esis amam nematawa sagaila waf itapafi ina atiasi sotolona sogawana sofaꞌana, owaꞌ. Apaꞌ ipaꞌ pegawana eaꞌ nape nalomepa, eaꞌ atiasi aꞌ nuwis nope nomon opalef ipeꞌilimbi. ");
INSERT INTO aoj_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Aeꞌ ina aꞌ ikwahipa tol pepe dowaf, siꞌi awasi isimba alifisi ahasas mamasas akasi, owaꞌatin. Atiasi aeꞌ igafiꞌmipai. ");
INSERT INTO aoj_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Nogota kwaiaꞌuta esis amam nematawa sagaila waf itapafii ina atiasi sotolowe wapani, owaꞌ. Apaꞌ ipaꞌ pigatolowai. Aeꞌ ape namowe ambal namili, eaꞌ naꞌamba atin ipaꞌ pepe namipa ambal namili wapani. ");
INSERT INTO aoj_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Ama nemaf afamba ipaꞌ apegawa aeꞌ ape Ahame, ape nomona ipaꞌ, ipaꞌ pape aeꞌ. ");
INSERT INTO aoj_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Epen ami negefaꞌ muꞌuli aeꞌani nigiꞌmana nigailan andeandeꞌi, anin aꞌ okom maimaila aeꞌ endilisi. Atiasi Ahame aeꞌanai okom mila anin. Eaꞌ aeꞌ wapani okom mimilan anin eaꞌ etaga endawalapa anin alihiwi.” ");
INSERT INTO aoj_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Jisas naꞌias naꞌamba, eaꞌ anona Judas ina anamba Keriotinai, owaꞌ, anona daiana, naꞌipa Jisas naꞌi, “Dembinai, deiꞌ maina inaꞌ naꞌi nigihimbaꞌmafa inaꞌ netaga nendawalap alihinama afaꞌ, inaꞌ owaꞌ nihimbaꞌmasa inaꞌ alihinama esis sagaila waf itapafia?” ");
INSERT INTO aoj_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Jisas nagwamana basef naꞌi, “Iꞌi epen okom mugaꞌi aeꞌ endilisii, anin atiasi nila basef aeꞌafi andeandeꞌ. Eaꞌ Ahame aeꞌanai atiasi okom mimila anin. Eaꞌ afaꞌ biafa ufiꞌmai anin ope oloman lifilafi. ");
INSERT INTO aoj_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Epen nandaiwaꞌma aeꞌ endilisii, anin ina atiasi nila basef aeꞌafi andeandeꞌ, owaꞌ. Eaꞌ basef ifimba ipaꞌ pagameꞌafi, ifimba ina aeꞌafi, owaꞌ. Ifimba basef Ahame Godi nasapaꞌe agafiꞌii. ");
INSERT INTO aoj_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Aeꞌ ataꞌ ape atapiwi alomepa aꞌipipa basef ifimba. ");
INSERT INTO aoj_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Apaꞌ anen notopalopepa ma nogowaꞌ banagaipai, anen Ambal buꞌunai Godi. Anamba Ahame atiasi nosapaꞌana nugafiꞌi agol aeꞌagili. Eaꞌ nowalipipa ma hiahawes hiasi, nosaꞌma nomonas ipeꞌisi ma ukup pegapoma basef hiafi wapani agasiꞌipafi. ");
INSERT INTO aoj_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Aeꞌ aꞌi ikwahipa. Apaꞌ aeꞌ ina endaꞌepa ombal behepa ukup iwaiwanip pepe siꞌi amam nematawa sagaila waf itapafi sandaꞌas, owaꞌ. Aeꞌ aꞌ endaꞌepa pepe ukup awanep endilisi ma ukup ipeꞌipi ina atiasi pesafel awep, owaꞌ. Eaꞌ ina ombal mehepa, owaꞌ. ");
INSERT INTO aoj_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Ipaꞌ pameꞌef eaꞌ basef ifimba agasiꞌipafi. Aeꞌ ikwahipa efeꞌ. Bola itanimaimipai. Iꞌi ipaꞌ ukup pila aeꞌ endilisi, eaꞌ ipaꞌ asonendahepa ma aeꞌ egafeꞌma Ahame. Deiꞌ main? Ahame anen dembinai nikilaꞌ aeꞌ. ");
INSERT INTO aoj_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Hiahawes isimba ina deiꞌ asataga, ataꞌ owaꞌ. Apaꞌ aeꞌ aliꞌ aꞌipipas eaꞌ ma nemaf afamba hiahawes isimba sogatagama ipaꞌ pegawas pigahapifa aeꞌ. ");
INSERT INTO aoj_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Aeꞌ ina atiasi endaꞌ basef hiafi elomepa, aꞌowaꞌ. Deiꞌ main? Aman dembinai aunai nugumafi itap apaꞌii anamba deiꞌ aꞌ nafiꞌi. Anen ina atiasi laꞌifinama nondaꞌme anis maefah, owaꞌatin. ");
INSERT INTO aoj_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Apaꞌ aeꞌ aꞌi esis amam nematawa sagaila waf itapafi sondogawa aeꞌ okom maimaila Ahame endilisi eaꞌ deiꞌ andaꞌas naꞌamba atin siꞌi anen nandaꞌipi. Naꞌamba deiꞌ afaꞌ aꞌ ofeꞌ. ");
INSERT INTO aoj_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","“Aeꞌ siꞌi lawag siꞌiga endilisi. Ahame aeꞌanai anen siꞌi ahama aof afamba sagawa lawah saꞌutip gwaꞌaipi pagailagahi. ");
INSERT INTO aoj_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Agof hiagufi saꞌutip owaꞌ pigailagufia, agwafomba Ahame natopaꞌagof nelefatagof. Apaꞌ anagof agof fail fogola gwaꞌaisii agwafomba anen nandombagof natopaꞌagof nahagasogof ama atiasi fogape boꞌogof fil fogola gwaꞌaisi hiasi andeandeꞌ. ");
INSERT INTO aoj_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Basef ifimba aeꞌ agasiꞌipafi fandaꞌepa pataga beꞌepa hililiꞌ eaꞌ. ");
INSERT INTO aoj_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Ipaꞌ pendape aeꞌ siꞌi aeꞌ agape ipaꞌ. Iꞌi agof atogof wafiguf, ina atiasi saꞌutip pilagof, owaꞌ. Iꞌi agof owaꞌ fondala sisihiguf lawag siꞌigaea, afof ina atiasi folo andeandeꞌ, fil fola gwaꞌaisi, owaꞌ. Eaꞌ naꞌamba atin siꞌi ipaꞌ. Iꞌi ipaꞌ owaꞌ pepe peloma aeꞌa, ipaꞌ wapani ina atiasi pela anis gwaꞌaisi, owaꞌatin. ");
INSERT INTO aoj_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Aeꞌ siꞌi lawag siꞌiga. Ipaꞌ siꞌi agofugama. Epen negape aeꞌi ma aeꞌ egape anini, atiasi negela gwaꞌaisi hiasii. Iꞌi ipaꞌ pekwaha aeꞌ, ipaꞌ atipa ina atiasi pendaꞌ anis maefah, owaꞌatin. ");
INSERT INTO aoj_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","“Iꞌi anin epen owaꞌ nepe aeꞌa, atiasi esis siliꞌamonan siꞌi sagatopaꞌ agof namugufi ma aliguf. Ama satamagof sowaꞌaniagof a sogaofagof nif. ");
INSERT INTO aoj_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Iꞌi ipaꞌ pepe aeꞌ ma basef aeꞌafi fepe nomona ipaꞌ, ipaꞌ pihaliꞌ aeꞌ ma basef maif pendahama ukup ipeꞌipi pagaꞌias, daoꞌ atiasi hiahawes isimba sotagamepa naꞌamba atin. ");
INSERT INTO aoj_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Iꞌi ipaꞌ pela gwaꞌaisi hiasi, Ahame aeꞌanai nofaꞌ agol luꞌwagili. Ama atiasi pegataga alipipai aeꞌipai. ");
INSERT INTO aoj_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Ahame okom maimaila aeꞌ, eaꞌ naꞌamba atin aeꞌ okom maimailipa. Dondol ipaꞌ pendape okom aeꞌami laꞌafima ma pegegawa okom aeꞌami peleleꞌ mailipa aꞌowaꞌ. ");
INSERT INTO aoj_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Iꞌi ipaꞌ pila muꞌuli aeꞌani andeandeꞌ, atiasi apepe okom aeꞌami laꞌafima nomon siꞌi aeꞌ agaila muꞌuli ahamai andeandeꞌma agape okom ananimi laꞌafima nomon. ");
INSERT INTO aoj_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Aeꞌ aꞌipipa basef ifimba ma aꞌi dagala aeꞌani inimba nepe nelomepa aeꞌ dagala ipeꞌini aꞌ nepe siꞌina nelelemb ipeꞌilimbi. ");
INSERT INTO aoj_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Muꞌuli aeꞌani inimba. Ipaꞌ ukup pindaima atina sahin owan ipeꞌisi endilisi siꞌi aeꞌ okom magamagailipa. ");
INSERT INTO aoj_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Iꞌi anin epen nekwaha ambal ananili atol negaꞌ netopalopa esis alipisi atis, waf afambai afikilaꞌ waf afamba anin epen daian nandaꞌafi. ");
INSERT INTO aoj_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Ipaꞌ pila muꞌuli agaꞌipipani andeandeꞌ, daoꞌ ipaꞌ alipipai aeꞌipai. ");
INSERT INTO aoj_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Epen agol akani dembinai ananinai ina naꞌipan basef alihifa maol anen nandaꞌani, owaꞌatin. Apaꞌ aeꞌ aꞌipipa basef hiafi Ahame aeꞌanai nagaꞌipiefi. Naꞌamba deiꞌ aeꞌ ina efalepa epes falafipai agof akipai, owaꞌ. Aeꞌ efalepa alipipai. ");
INSERT INTO aoj_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Ipaꞌ ina paliꞌ pandandepa aeꞌ ipeꞌiwai, owaꞌ. Aeꞌ aliꞌ andandepepa eaꞌ aeꞌipai. Eaꞌ andaꞌepa pandaꞌ maol buꞌwani. Ama pefeꞌ pendaꞌ maol buꞌwani siꞌi lawah hogola gwaꞌaisi ma maol buꞌwani ipeꞌini negape andeandeꞌ. Ama iꞌi ipaꞌ pendabeten pihaliꞌ Ahame ma anis hiahawesa agol aeꞌigili, anen nogasiꞌipasi. ");
INSERT INTO aoj_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Aeꞌ aseꞌepa muꞌuli ipaꞌ naꞌamba. Ipaꞌ ukup pindandaima atin endilisi ma sahin owan ipeꞌisi. ");
INSERT INTO aoj_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Iꞌi esis amam nematawa sagaila waf itapafi siꞌi sofala ipaꞌ boupai daoꞌ, ipaꞌ pendegawa esis fowaꞌ saliꞌ sofala aeꞌ bouwai. ");
INSERT INTO aoj_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Iꞌi aꞌ endilisi ipaꞌ epes itapipaiai, esis sagaila waf itapafi aꞌ ukup pipilipa siꞌi ipaꞌ miniꞌap asasipai atipa. Apaꞌ owaꞌ, ipaꞌ ina epes itap apaꞌipai, owaꞌatin. Aeꞌ esaheꞌepa eaꞌ ma pegakwaha waf itapafi. Eaꞌ deiꞌ esis sagaila waf itapafi sofalepa boupai. ");
INSERT INTO aoj_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","“Ipaꞌ ukup pendapoma basef ifimba aeꞌ agasiꞌipafi andeandeꞌ. Epen inimba agol akani nandaꞌ maol dowadowafi, anin ina nape ilifa dembinai ananinai, owaꞌ. Aeꞌ eaꞌ saliꞌ sandaꞌme waf awafi, eaꞌ atiasi esis sondaꞌmepa waf awafi, sondaꞌepa awepa wapani. Esis iꞌi sigiꞌma basef aeꞌafiai, daoꞌ atiasi esis sigiꞌma basef ipeꞌifi wapani. Owaꞌ, owaꞌatin. ");
INSERT INTO aoj_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Esis ina sogawa Ahame nasapaꞌe agafiꞌii, owaꞌ. Ipaꞌ ukup pagapoma agol aeꞌagili, eaꞌ aeꞌipai. Eaꞌ esis sagaila waf esis itapafi asondaꞌ hiahaom awami hiami ma ipaꞌ. ");
INSERT INTO aoj_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Iꞌi endilisi aeꞌ owaꞌ ifiꞌi iꞌipasa basef ifimba ai, esis waf awafi akas. Apaꞌ owaꞌ, owaꞌatin. Deiꞌ esis owaꞌ anoꞌw ufiaꞌwa sogombahoꞌ waf awafi asasifia, owaꞌatin. ");
INSERT INTO aoj_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Epen negefala aeꞌ bouwai, anin nefala Ahame aeꞌanai bounai wapani. ");
INSERT INTO aoj_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Esis sagaila waf itapafi ina sati anona aman nandaꞌ maol nandahama maol aeꞌ andaꞌani, owaꞌ. Iꞌi endilisi aeꞌ owaꞌ endaꞌ maol inimbaea, esis waf awafi akas. Apaꞌ deiꞌ sati maol banagani aeꞌani eaꞌ, owaꞌ, asowaꞌ alafugaha aeꞌ ukup awepa aeꞌ aloma Ahame aeꞌanai wapani. ");
INSERT INTO aoj_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Apaꞌ waf afamba asasifi afamba eaꞌ fafeꞌ dondoꞌma anif basef ifimba fagail muꞌuli esis Judai faꞌi, ‘Esis ukup awepa aeꞌ dowadowaf. Aeꞌ basef kofagefa ake.’ ");
INSERT INTO aoj_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Apaꞌ anen natopalopepa nogowaꞌ banagaipai, anen napani naloma Ahame. Eaꞌ aeꞌ esapaꞌana nifiꞌmai ipaꞌ. Anen Ambal buꞌunai nawalapa basef nagaꞌi endilisii. Anamba nafiꞌi ma nogawalapa basefa aeꞌ. ");
INSERT INTO aoj_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Eaꞌ ipaꞌ wapani atiasi piꞌi basef pewalapefa esis. Deiꞌ main, ipaꞌ fowaꞌ dambadamba pati asefela maol andaꞌan paloma pape atapipa pafiꞌi pataga deiꞌ.” ");
INSERT INTO aoj_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Eaꞌ Jisas naꞌipam wapani naꞌi, “Aeꞌ deiꞌ aꞌipipa basef ifimba hiꞌalef eaꞌ ma ipaꞌ ina pekwaha pagahapifa aeꞌ, owaꞌi. ");
INSERT INTO aoj_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Atiasi esis siliꞌamonipai ifagw esis Juda sandakolasugwi. Anef nemaf atiasi fegataga ma epes ami sehepa pegagaꞌ, esis atiasi ukup pendandaꞌ siꞌi sandaꞌ maol fasini Godi. Apaꞌ owaꞌatin. ");
INSERT INTO aoj_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Fowaꞌ esis ina sogawa Ahame naloma aeꞌ wapani, owa. Naꞌamba esis atiasi sondaꞌ waf afambai. ");
INSERT INTO aoj_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Apaꞌ deiꞌ aꞌipipa eaꞌ ma hiahawes isimba. Ama nogota atiasi togataga ma esis sondaꞌepa naꞌamba, ipaꞌ ukup pendandaꞌma basef ifimba deiꞌ agaꞌipipafi. ");
INSERT INTO aoj_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","“Fowaꞌ aeꞌ ape agalomepa aeꞌ ina aꞌipipa ma hiahawes isimba, owaꞌ. Apaꞌ deiꞌ eaꞌ efeꞌma anen anamba nasapaꞌe agafiꞌii. Ina anona aman ipeꞌinai nahaliꞌi naꞌi, ‘Inaꞌ nefeꞌ ani?’ Owaꞌatin. ");
INSERT INTO aoj_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Aeꞌ andaꞌ basef ifimba eaꞌ ma ipaꞌ. Eaꞌ deiꞌ nelelemb ipeꞌilimbi nimanilimb aꞌowaꞌ. ");
INSERT INTO aoj_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Apaꞌ aeꞌ aꞌipipa basef endilisifi. Aeꞌ ekwahipa efeꞌ ma etopalopepa pegape andeandeꞌ. Iꞌi aeꞌ owaꞌ ma igafeꞌai, deiꞌ Spirit Ambal Godi Nogowaꞌ banagaipai, ina atiasi nifiꞌmai ipaꞌ, owaꞌatin. Apaꞌ iꞌi aeꞌ egafeꞌ, daoꞌ, atiasi esapaꞌana nifiꞌmai ipaꞌ. ");
INSERT INTO aoj_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Nemaf afamba nugafiꞌi, aꞌ nihimbaꞌma esis amam nematawa sagaila waf itapafi ma sogogawa basef kofagefa ma waf wanifif afamba. Waf awafi feloma waf usiꞌifi feloma basefa God nondakotimas. ");
INSERT INTO aoj_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Waf awafi kofagefa asasifi naꞌamba. Esis ina sohapifa aeꞌ, owaꞌatin. ");
INSERT INTO aoj_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Waf kofagefa usiꞌifi naꞌamba. Aeꞌ efeꞌma Ahame eaꞌ atiasi ipaꞌ ina petolowe wapani, owaꞌ. ");
INSERT INTO aoj_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Basef kofagefa ma kot ifimba. Aman dembinai aunai ma epes sagape itap apaꞌi, anen eaꞌ gasopana ma kot atamba ma basef luꞌwafi God deiꞌ nandaꞌmanatai. ");
INSERT INTO aoj_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Aeꞌ basef hiafi aꞌowaꞌ ma aꞌi igaꞌipipafi, apaꞌ ipaꞌ ina laꞌifipama pegefaꞌef deiꞌ, owaꞌ. ");
INSERT INTO aoj_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Nemaf afamba Spirit Ambal Godi nagaꞌi basef endilisifii nugafiꞌi, aꞌ nisindiꞌamonepa ma basef hiafi endilisifi. Anen ina aꞌ nowalapa basef nomonas ananisi atis, owaꞌatin. Basef nagameꞌef eaꞌi, ifimba atif nowalapef niꞌif. Ama atiasi nogaꞌipipa hiahaom amamba maꞌi anaf migiꞌ mogatagai. ");
INSERT INTO aoj_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Eaꞌ nofaꞌ basef aeꞌafi nowalapefa ipaꞌ ma nogowalapa agol aeꞌagili. ");
INSERT INTO aoj_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Hiahaom hiami, amamba aeꞌami. Eaꞌ deiꞌ aeꞌ aꞌias aꞌi. Atiasi nofaꞌ basef aeꞌafi niꞌif nowalapefa ipaꞌ. ");
INSERT INTO aoj_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“Nogota kwaiaꞌuta ipaꞌ ina atiasi petolowe wapani, owaꞌ. Ama nogota bandata kwasakwasala owaꞌ, ipaꞌ apetelowe wapani.” ");
INSERT INTO aoj_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Anom alipumi ananimi, amom atom mandaꞌipama maꞌi naꞌamba maꞌi, “Basef maif kofagefa ifimba anen nagaꞌipafaef afaꞌi? Anen naꞌi, nogota kwaiaꞌuta, afaꞌ ina atiasi otolona, ma main owaꞌ, aꞌ otolona wapani. Naꞌi nogafeꞌma ahamana. Afaꞌ ina ogawa basef ifimba kofagefa, owaꞌ.” ");
INSERT INTO aoj_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Eaꞌ amom maꞌias wapani maꞌi, “Nogota atamba kwaiaꞌuta anen nagaꞌiatai, isimba hiahawes mais? Afaꞌ ina ogawa basef ifimba nagaꞌif naꞌambai, owaꞌ.” ");
INSERT INTO aoj_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Owaꞌ Jisas aꞌ nogawa amom maꞌi mogahaliꞌana, eaꞌ naꞌipam naꞌi, “Aꞌi ipaꞌ pandahaliꞌma basef ifimba kofagefa aeꞌ agaꞌiefi. Aeꞌ agaꞌif naꞌamba. Nogota kwaiaꞌuta atiasi ipaꞌ ina petolowe, owaꞌ. Ama owaꞌ nogota laota kwasakwasala, owaꞌ a petolowe wapani. ");
INSERT INTO aoj_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Endilisi atis aeꞌ aꞌipipa. Ipaꞌ atiasi pelef mehip aꞌowaꞌ eaꞌ pelef pindiwagef endilisi. Apaꞌ esis amam nematawa sagaila waf itapafi atiasi sondagala. Apaꞌ ipaꞌ aꞌ nelelemb nimanilimb. Owaꞌ, owaꞌatin. Nelelemb ipeꞌilimbi nimanilimbi atiasi bendambema betaga pendagala endilisi. ");
INSERT INTO aoj_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Nemataꞌw opafuꞌwi ma kwaꞌi kogola awanii akoꞌw kwameꞌ akafimi kogawa nogota akwaꞌuta ma kogola awani atataga. Naꞌamba opaf akwaꞌufi aꞌ nimanif. Akoꞌw kolana eaꞌ, akoꞌw ina ataꞌ okom mandandaꞌma akafimi amamba wapani, owaꞌatin. Akoꞌw eaꞌ kwandagala atin kwapoma awani nataga nape itap eaꞌ. ");
INSERT INTO aoj_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Ipaꞌ naꞌamba atin, deiꞌ ipaꞌ nelelemb nimanilimb. Atiasi aeꞌ itilipa wapani, owaꞌ nelelemb ipeꞌilimbi asonohalemb. Ina anin epen laꞌifina negalamona dagala inimba ipeꞌini, owaꞌatin. ");
INSERT INTO aoj_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Atiasi nemaf afamba ipaꞌ ina pihaliꞌi ma anin mae atitin, owaꞌ. Apaꞌ deiꞌ aeꞌ aꞌipipa basef endilisifi ipaꞌ. Iꞌi ipaꞌ pihaliꞌ Ahame ma maefah maisa agol aeꞌagili daoꞌ, atiasi neseꞌepas. ");
INSERT INTO aoj_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Fowaꞌ ipaꞌ ina pahaliꞌi ma pegefaꞌ anis maefaha agol aeꞌagili, owaꞌ. Deiꞌ pihaliꞌimas, atiasi pegefaꞌasi ma nelelemb ipeꞌilimbi asonogahepa endilisi. ");
INSERT INTO aoj_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Aeꞌ deiꞌ andaꞌ basef ifimba waminif atina ipaꞌ. Apaꞌ aeꞌ ina atiasi ataꞌ iꞌipipa basef waminif atin, owaꞌ. Nemaf afamba aeꞌ ewalapef alihif iꞌipipaef ipaꞌ ma Ahame. ");
INSERT INTO aoj_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Ama nemaf afamba atiasi ipaꞌ pihaliꞌ Ahame ma agol aeꞌagili. Aeꞌ ina ataꞌ iꞌipipa naꞌamba iꞌi aeꞌ atowe atiasi ihaliꞌana ma nogatopalopepa, owaꞌatin. ");
INSERT INTO aoj_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Ahame atona okom maimailipa aꞌowaꞌ. Deiꞌ main, ipaꞌ ukup paipaila aeꞌ aꞌowaꞌ, eaꞌ ipaꞌ pahapifi pegawa aeꞌ ape aloma God afiꞌi. ");
INSERT INTO aoj_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Fowaꞌ aeꞌ ape aloma Ahame eaꞌ akwahona afiꞌi itap apaꞌe eaꞌ. Deiꞌ aeꞌ aꞌi ekwaha itap aꞌ itanima efeꞌma anen.” ");
INSERT INTO aoj_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Alipumi ananimi maꞌi, “Ahoꞌ, deiꞌ inaꞌ naꞌipafas alihis, ina ataꞌ naꞌi basef waminif atin, owaꞌ. ");
INSERT INTO aoj_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Deiꞌ afaꞌ ogawa ina ataꞌ nape nasasa anin epen nihaliꞌina niliꞌ, owaꞌatin. Inaꞌ negawa hiahaom hiami eaꞌ. Isimba atis deiꞌ afaꞌ wahapifa inaꞌ nape naloma God nafiꞌi.” ");
INSERT INTO aoj_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Jisas nagwamam basef naꞌipam naꞌi, “Ipaꞌ deiꞌ pahapifa aeꞌ aꞌamon? ");
INSERT INTO aoj_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Ipaꞌ pemeꞌ. Deiꞌ nogota eaꞌ felefeleꞌ, ahoꞌ atataga eaꞌ ma atiasi sotofa ipaꞌ hipai atona biana pefeꞌ walemb ipeꞌilimbi. Eaꞌ pekwaha aeꞌ atowe epe. Apaꞌ ina aeꞌ atowe epe, owaꞌatin. Ahame nape nalome. ");
INSERT INTO aoj_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Aeꞌ aꞌi atiasi ipaꞌ pepe pelome nelelemb pepe saꞌombel. Eaꞌ deiꞌ aꞌipipa basef ifimba. Itap apaꞌe ipaꞌ atiasi pemeꞌ nelelemb nimanilimb. Apaꞌ nelelemb ipeꞌilimbi atiasi ambetaga banagelemb. Deiꞌ main, aeꞌ atalogofa waf itapafi a ikilaꞌaf eaꞌ.” ");
INSERT INTO aoj_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Jisas naꞌi basef naꞌamba ma eaꞌ, aꞌ naniga nati heven nandabeten naꞌi, “Ahame, nogota atataga eaꞌ. Inaꞌ neseꞌe agol luꞌwagili aeꞌ Nogamena ineꞌiwai, ma atiasi laꞌifiwi ma egasaꞌma agol ineꞌigili luꞌwagol. ");
INSERT INTO aoj_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Deiꞌ main? Inaꞌ nesaheꞌe eaꞌ ma epe Dembiwai iliꞌma epes hiꞌigalas egasoꞌas ambal namili epes isimba hiasi inaꞌ nagasiꞌiesi. Ambal alamba sogape andeandeꞌ lifilafi dondoli. ");
INSERT INTO aoj_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Ambal lagape andeandeꞌ lifilafii kofagefa ifimba. Esis sogawa inaꞌ atina God endilisinai, sogawa endilisi aeꞌ Jisas Krais, inaꞌ nasapaꞌe agafiꞌii. ");
INSERT INTO aoj_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","“Maol inimba inaꞌ nasapaꞌe afiꞌi ma endaꞌani, aeꞌ andaꞌan ambifan eaꞌ. Eaꞌ deiꞌ asaꞌma agol ineꞌigili luꞌwagola nogohnaep esis amam nematawa itapasi. ");
INSERT INTO aoj_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Ahame, fowaꞌ itap owaꞌ ataꞌ pitagaia aeꞌ ape alomena efaꞌ agol luꞌwagili eaꞌ. Deiꞌ nendaseꞌe agol agalemba luꞌwagili siꞌi fowaꞌ. ");
INSERT INTO aoj_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Aeꞌ awalapa agol ineꞌigili eaꞌ aꞌipa esis epes isimba inaꞌ nagaseꞌeas aeꞌi ma itap apaꞌe. Isimba epes ineꞌisi nagaseꞌeas aeꞌ eaꞌi. Esis saila basef ineꞌifi andeandeꞌ. ");
INSERT INTO aoj_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Deiꞌ asogawa hiahaom hiami inaꞌ nagaseꞌeam aeꞌ eaꞌi, amamba mafiꞌi inaꞌ atina. ");
INSERT INTO aoj_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Basef hiafi inaꞌ nagaseꞌef eaꞌi, ifimba aeꞌ aꞌipasef eaꞌ, sofaꞌefa sogogawa endilisi fowaꞌ aeꞌ ape alomena afiꞌi. Eaꞌ sahapila basef ifimba inaꞌ nasapaꞌe agafiꞌii. ");
INSERT INTO aoj_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“Deiꞌ aeꞌ andabetena egatopalopa isimba. Aeꞌ ina andabetena egatopalopa esis amam nematawa sagaila waf itapafi, owaꞌ. Aeꞌ andaꞌ betena egatopalopa isimba inaꞌ nagaseꞌeas aeꞌi. Deiꞌ main? Isimba esis ineꞌisi siꞌisi. ");
INSERT INTO aoj_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Eaꞌ epes aeꞌasi, isimba ineꞌisi. Epes hiasi ineꞌisi hiꞌilas isimba aeꞌasi. Eaꞌ esis sasaꞌma agol aeꞌagili. ");
INSERT INTO aoj_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Deiꞌ aeꞌ ina ataꞌ epe itap apaꞌe wapani, owaꞌ. Apaꞌ esis sope itap apaꞌe. Aeꞌ eaꞌ efeꞌmago inaꞌ. Ahame beꞌena hililiꞌi, inaꞌ nimafi esisa atiasi sogape banagesa banagami ineꞌimi, banagami amamba inaꞌ eaꞌ nagaseꞌeam aeꞌi. Ma esis sogape wambota atotota siꞌi afaꞌ biafa wagape atotofa. ");
INSERT INTO aoj_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Nogota atamba aeꞌ ape agaloma esis, aeꞌ imafias sape banagami ineꞌimi, banagami amamba inaꞌ eaꞌ nagaseꞌeam aeꞌi. Aeꞌ imafias andeandeꞌ eaꞌ ina anin atitin higilalan, owaꞌ. Aman higiligalanai, eaꞌ anen atona atiasi nogafeꞌ wambel awambili, ma basef ineꞌifi fagail buk Baibeli fetaga endilisi fendawalap. ");
INSERT INTO aoj_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Aeꞌ deiꞌ ataꞌ ape itap apaꞌe aꞌi basef ifimba ma dagala aeꞌani negape siꞌina nelelemb asasilimbi. Eaꞌ deiꞌ aꞌ efeꞌmago inaꞌ. ");
INSERT INTO aoj_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","“Basef ineꞌifi, aeꞌ asoꞌasef eaꞌ. Esis amam nematawa asofala esis bousi sandaꞌas awes. Deiꞌ main? Esis ina sagiꞌma waf itap apaꞌifi siꞌi aeꞌ wapani ina itap apaꞌiwai, owaꞌ. ");
INSERT INTO aoj_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Aeꞌ ina andabeten ahaliꞌina ma negelefata esis itap apaꞌe, owaꞌatin. Aeꞌ andabetena inaꞌ nigimafiasa aman aunai ina nohambombagas, owaꞌatin. ");
INSERT INTO aoj_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Esis ina sagiꞌma waf itap apaꞌifi siꞌi aeꞌ wapani ina itap apaꞌiwai, owaꞌ. ");
INSERT INTO aoj_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Basef ineꞌifi ifimba endilisifi. Inaꞌ nendaꞌ esis sondataga ineꞌisi atis boꞌwes hililiꞌma basef ifimba. ");
INSERT INTO aoj_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Fowaꞌ inaꞌ nasapaꞌe afiꞌi ape laꞌafena esis amam nematawa sagaila waf itapafi. Deiꞌ naꞌamba atin aeꞌ wapani eaꞌ asapaꞌ esis aeꞌasi sofeꞌ laꞌafena esis isimba itapasi. ");
INSERT INTO aoj_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Aeꞌ aseꞌena aeꞌ inaꞌ eaꞌ ineꞌiwai atowe ma etopalopa esis wapani sogataga boꞌwes hililiꞌ ineꞌisi atis. ");
INSERT INTO aoj_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Apaꞌ aeꞌ ina andabetena egatopalopa esis isimba atis, owaꞌatin. Aeꞌ andabetena egatopalopa epes isimba anaf sogameꞌ basefa esisi ma sogahapifa aeꞌi. ");
INSERT INTO aoj_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Ahame, aeꞌ andabetena esis isimba hiasi asondape ukup atifip siꞌi inaꞌ Ahame nape nagalome a aeꞌ ape agalomena. Eaꞌ naꞌamba atin, andaꞌ betena esis sogape afaꞌ biafa. Ama amam nematawa sagaila waf itapafi sogahapifa inaꞌ atina aꞌ nasapaꞌe agafiꞌii. ");
INSERT INTO aoj_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Fowaꞌ inaꞌ nasaꞌma agol aeꞌagili luꞌwagol eaꞌ deiꞌ asaꞌma agof asasigufi luꞌwagofa sogape nembel atotombel siꞌi afaꞌ biafa wagape. ");
INSERT INTO aoj_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Inaꞌ nape nalome a aeꞌ anaf epe eloma esis, aeꞌ, eaꞌ naꞌamba atin aeꞌ okom maꞌi esis asondataga nembel atotombel endilisi. Ama esis amam nematawa itapasi sogogawa inaꞌ nasapaꞌe afiꞌi, eaꞌ inaꞌ okom maimailas aꞌowaꞌ siꞌi okom magamagaila aeꞌ aꞌowaꞌ. ");
INSERT INTO aoj_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Ahame, aeꞌ okom maꞌi esis amam nematawa inaꞌ nagaseꞌeas aeꞌi sope solome wambel ambalemba. Aeꞌ okom maꞌi esis siti hiahaom banagami fasimi mogogalaꞌi aeꞌami, mogogalaꞌi amamba inaꞌ nagaseꞌeam aeꞌi. Fowaꞌ itap ataꞌ owaꞌ petagaea, nogota atamba inaꞌ okom maila aeꞌ. Eaꞌ naseꞌe mogogalaꞌi amamba. ");
INSERT INTO aoj_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Ahame usiꞌinai hililiꞌi, esis amam nematawa sagaila waf itapafi ina sogawa inaꞌ. Apaꞌ aeꞌ egawena. Eaꞌ esis isimba alipisi sogawa inaꞌ nasapaꞌe afiꞌi. ");
INSERT INTO aoj_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Aeꞌ aꞌ awalapa agol ineꞌigili ma esis. Eaꞌ aeꞌ atiasi endawalapagol atin atapigil. Ama esis sogofaꞌ waf afamba ukup pindaima atinafi ma anis daindaias wapani siꞌi inaꞌ okom magamagaila aeꞌ ma aeꞌ egape nomona esis.” ");
INSERT INTO aoj_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Jisas nandabeten nahaliꞌ Ahamana eaꞌ, naloma alipumi ananimi aꞌ mafeꞌ mowala mambo walemb Kidron fisanamb lawah oliv hogotaoma. Naoꞌwam mafeꞌ anamba. ");
INSERT INTO aoj_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Anen Judas aꞌ nogawa anamba ma atiasi nefeꞌ nigihimbaꞌma boumi ma Jisas. Deiꞌ main? Nimaguf hiafi dondol Jisas naoꞌwam mandakolas magapoma anamba. ");
INSERT INTO aoj_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Eaꞌ Judas nafiꞌi naoꞌwa anom soldia maloma anom plisman amom pris maloma amom Farisi masapaꞌam magafiꞌi. Amom mahapila bagah nagwahis lambeh maloma hiahaom sagapaꞌami mofaꞌam atin mafiꞌi anamba. ");
INSERT INTO aoj_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Eaꞌ Jisas nogawa hiahaom hiami atiasi mogatagamanai. Eaꞌ nafeꞌ nahaliꞌam naꞌi, “Ipaꞌ pewandoꞌma ami?” ");
INSERT INTO aoj_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Eaꞌ magwamana maꞌipana maꞌi, “Jisas Nasaretinai.” Eaꞌ Jisas naꞌi, “Aeꞌ maꞌuwi.” Owaꞌ Judas naꞌi nigihimbaꞌmam Jisasi, anen nalutu nalomam wapani. ");
INSERT INTO aoj_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Jisas ataꞌ naꞌipam atin naꞌi, “Aeꞌ maꞌuwi.” Owaꞌ aꞌ mandahagas mowa motawa itap. ");
INSERT INTO aoj_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Eaꞌ Jisas nahaliꞌam wapani naꞌi, “Ipaꞌ pewandoꞌma ami?” Eaꞌ maꞌi, “Jisas Nasaretinai.” ");
INSERT INTO aoj_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Jisas naꞌi, “Dokoꞌ aeꞌ aꞌipipa aꞌi aeꞌ eaꞌ maꞌuwi. Iꞌi ipaꞌ pewandoꞌma aeꞌ, pihapili pekwahogo amom amamba mofoꞌo wahifim.” ");
INSERT INTO aoj_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Jisas deiꞌ naꞌipam naꞌamba nagiꞌma basef ifimba fowaꞌ nagaꞌiefi ma fegataga endilisi. Basef ifimba fagaꞌi naꞌamba faꞌi, “Amam amamba fowaꞌ inaꞌ nagaseꞌeami, ina anona atotona higililana, owaꞌ.” ");
INSERT INTO aoj_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Eaꞌ Saimon Pita nahapila anota bainat nagiatai naha anona aman Malkas nandaꞌmana maola pris dembinai nape nagaliꞌma pris hiamii. Eaꞌ natopaꞌ aliga kwahisigai ananigai gowa. ");
INSERT INTO aoj_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Eaꞌ Jisas naꞌipa Pita dindinip naꞌi, “Inaꞌ tanima la bainat nowala let. Aeꞌ aꞌ iaꞌ embela kap Ahame nagasiꞌiapi.” ");
INSERT INTO aoj_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Eaꞌ amom soldia maloma dembinai amamunai maloma amom plisman Judai hiami mombaloꞌ Jisas mandaꞌ mandof mowaꞌ lagofana. ");
INSERT INTO aoj_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Eaꞌ maoꞌwana naliꞌ nafeꞌ ma Anas, Kaiafas fafomana. Afagol agalemba, Kaiafas dembinai pris nape nagaliꞌma pris hiamii. ");
INSERT INTO aoj_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Kaiafas naliꞌ nagaꞌipa amom agufumi Juda nagaꞌi, “Iꞌi anona aman nogaꞌ ma apaꞌ Juda hiapai, waf afambai andeandeꞌ, waf buꞌwafi.” ");
INSERT INTO aoj_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Eaꞌ Saimon Pita naloma aeꞌ alipuwai Jisasi wagiꞌma Jisas wafiꞌi. Pris anamba dembinai nogawa aeꞌ. Eaꞌ awis aloma Jisas ipat nomon. ");
INSERT INTO aoj_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Apaꞌ Pita tol nalutu uta indalelemb andoꞌ. Aeꞌ itanima awisi andoꞌ aꞌipa anoꞌw nemataꞌw kugumafi utai eaꞌ aoꞌwa Pita wawis nomon. ");
INSERT INTO aoj_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Eaꞌ nemataꞌw kugumafi utai kwaꞌipa Pita kwaꞌi, “Inaꞌ wapani alipunai aman anambai, aꞌa owaꞌ?” Owaꞌ anen nagwamaꞌwa basef naꞌi, “Aeꞌ owaꞌ.” ");
INSERT INTO aoj_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Amom mandaꞌ maola pris anamba dembinai maloma anom plisman amom hiami nomanamb bam makata nif aꞌ malutumif fahiꞌam. Eaꞌ Pita wapani nalomam nalutumif. ");
INSERT INTO aoj_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Eaꞌ pris anamba dembinai nahaliꞌ Jisas ipat nomon. Nahaliꞌana ma alipumi ananimi maloma basef anen nagawalipasafi. ");
INSERT INTO aoj_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Owaꞌ Jisas nagwamana naꞌi, “Aeꞌ awalipasa basef aeꞌafi alihigima ma epes hiasi itapasi. Aeꞌ awalipas nomon ifagw esis Juda sandakolasugwi nimaguf hiafi dondol. Eaꞌ awalipas ipat luꞌunai Godi wapani, ipat anamba esis Juda hiasi sandakolasanai. Basef aeꞌ agaꞌiefi ina fandambahoꞌ, owaꞌatin. ");
INSERT INTO aoj_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Deiꞌ maina inaꞌ nagahaliꞌ aeꞌ? Deiꞌ nigahaliꞌ esis sagameꞌ basef agawalipasafi. Esis sogawef.” ");
INSERT INTO aoj_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Jisas naꞌi basef ifimba atin, owaꞌ anona plisman nalutu felefeleꞌ naha amaga lagol ananigili naꞌipa Jisas dindinip naꞌi, “Inaꞌ owaꞌi negwamana basef ifimba dembinai prisa.” ");
INSERT INTO aoj_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Eaꞌ Jisas nagwamana basef naꞌi, “Iꞌi aeꞌ iꞌi anif basef awafi, daoꞌ inaꞌ niꞌipa amom hiami naꞌamba. Apaꞌ owaꞌatin. Aeꞌ igaꞌi basef endilisifi, deiꞌ nahe ma main?” ");
INSERT INTO aoj_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Mandelef ataꞌ fapomana atin lagof Jisasi, eaꞌ Anas nasapaꞌana nafeꞌma pris anamba dembinai Kaiafas. ");
INSERT INTO aoj_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Saimon Pita tol nalutuma nif fahiꞌana, eaꞌ saꞌipana saꞌi, “Aꞌi inaꞌ alipunai ananinai?” Owaꞌ anen naꞌi, “Ahaeꞌ, aeꞌ owaꞌ.” ");
INSERT INTO aoj_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Eaꞌ anona aman nape felefeleꞌma Pita. Anen nandaꞌ maola pris anamba dembinai. Anen amom atom wambota atota aman anamba dokoꞌ Pita nahana nagatalisa nagakwalisa aliganai. Eaꞌ naꞌipa Pita naꞌi, “Endilisi atis, aeꞌ ati inaꞌ nape nagaloma Jisasi ganimba lawah oliv hogatawama.” ");
INSERT INTO aoj_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Eaꞌ Pita nandahaliꞌ naꞌi wapani naꞌi, “Aeꞌ owaꞌ.” Anen ataꞌ naꞌi atin, owaꞌ, awata atata. ");
INSERT INTO aoj_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Ama kuhimbita atota amom matagwaha Jisas makwaha ipat Kaiafasi, mofaꞌana mafeꞌ ipat gavman dembinai. Eaꞌ amom Juda ina mafeꞌ mawis ipat atamba, owaꞌ. Amom maꞌi, “Naꞌamba aꞌ mofaꞌ alogw awagwi eaꞌ ina atiasi meaꞌ gwaꞌaisi luꞌwasi Pasova, owaꞌatin.” ");
INSERT INTO aoj_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Amom ukup pandandaꞌ naꞌamba eaꞌ tol malutu andoꞌ Pailat nafiꞌmai amom naꞌi, “Ipaꞌ paꞌi pendaꞌmana kot aman anamba ma main?” ");
INSERT INTO aoj_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Amom magwamana basef maꞌi, “Iꞌi aman anamba owaꞌ nondaꞌ waf awafia, apaꞌ ina aꞌ mofaꞌana nifiꞌmai inaꞌ.” ");
INSERT INTO aoj_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Eaꞌ Pailat naꞌipam naꞌi, “Ipaꞌ atipa pefaꞌana pendaꞌ kotimana nondahama muꞌuli ipeꞌini atin. Apaꞌ aeꞌ owaꞌ, andaiwaꞌ.” Eaꞌ amom Juda magwamana maꞌi, “Muꞌuli ipaꞌ Romi naꞌi owaꞌi ma mogaha anin epen negagaꞌ, owaꞌatin endilisi.” ");
INSERT INTO aoj_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Hiahawes isimba amom Juda mandaꞌasi ina sataga dowaf, owaꞌatin. Isimba sataga sagiꞌma basef ifimba Jisas naliꞌ nagaꞌiefi afegataga endilisi. Deiꞌ main? Anen naliꞌ naꞌi, “Atiasi esis sehe egaꞌ lawag usiꞌigai tiꞌwanaegai.” ");
INSERT INTO aoj_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Eaꞌ gavman dembinai Pailat netanima nawis ipat luꞌutai gavmani nomon. Eaꞌ nofala Jisas nafiꞌi nahaliꞌana naꞌi, “Inaꞌ king dembinai esis Judai?” ");
INSERT INTO aoj_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Jisas nahaliꞌana naꞌi, “Basef ifimba fataga okom ineꞌimi atom aꞌa anis daias saꞌipinaefa aeꞌ?” ");
INSERT INTO aoj_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Eaꞌ Pailat nagwamana basef naꞌi, “Inaꞌ okom maꞌi aeꞌ wapani aeꞌ Judaiwai? Owaꞌatin. Epes ineꞌisi saloma amom pris dembami, esis atis sombaloꞌena sowaꞌena nafiꞌmai aeꞌ. Inaꞌ nandaꞌ waf maif?” ");
INSERT INTO aoj_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Eaꞌ Jisas naꞌi, “Aeꞌ ina Judaiwai king igimafi epes itapasi, owaꞌatin. Iꞌi aeꞌ epe dembiwai king itap apaꞌiai, alipumi aeꞌami mandaꞌ maola aeꞌi motopalope mopaꞌ ma Juda ina laꞌifisa sogombaleꞌe. Apaꞌ owaꞌ, owaꞌatin. ");
INSERT INTO aoj_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Eaꞌ Pailat naꞌi, “Naꞌamba inaꞌ anina king dembinai.” Jisas nagwamana basef naꞌi, “Inaꞌ naꞌi aeꞌ anawe dembiwai king. Basef ifimba endilisifi. Maꞌme kolae ma egape king dembiwai. Aeꞌ afiꞌi itap apaꞌe ma igawalipasa basef endilisifi. Epen ami nendaꞌ waf endilisifi, inimba negameꞌ basef aeꞌafii.” ");
INSERT INTO aoj_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Eaꞌ Pailat nahaliꞌana naꞌi, “Basef ifimba endilisifi, basef maif?” Pailat naꞌias naꞌamba eaꞌ notanima nawis andoꞌ esis Juda sagapoma naꞌipas naꞌi, “Aeꞌ ina ati anis maefah awasi ma anen, owaꞌ. Ina ati anef waf awafi ma endaꞌmana anif basef, owaꞌ. ");
INSERT INTO aoj_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Apaꞌ waf ipaꞌ Juda, ma pandaꞌ gwaꞌaisi luꞌwasi Pasova, aeꞌ akwaha anin epen nandaꞌ kalabusi nafeꞌmago ipaꞌ. Deiꞌ ipaꞌ paꞌi aeꞌ ekwaha king dembinai ipaꞌ Judai nefeꞌmago ipaꞌ, aꞌa ami?” ");
INSERT INTO aoj_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Eaꞌ esis sagwamana basef dindinip saꞌi, “Owaꞌatin, anen owaꞌ. Inaꞌ nekwaha Barabas nifiꞌmai apaꞌ.” Aman anamba Barabas anen nandaꞌ walii naha epes sagagaꞌi. ");
INSERT INTO aoj_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Eaꞌ gavman dembinai Pailat naoꞌwa Jisas nafeꞌ naꞌipa amom soldia mopagahona. ");
INSERT INTO aoj_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","3","Mapagahona ma eaꞌ, malaꞌwatefa anof mandof higatagufi siꞌi anota hat mowaloꞌmanota balaga ananigai, malamana anef lowaf akwahifi. Eaꞌ timbi tambel mafeꞌma anen maꞌipana maꞌi, “Nemaf buꞌwafi, inaꞌ dembinai king Judai.” Amom mandaꞌ salomala anen mandaꞌana findiwana naꞌamba, mahana amaga ananigai. ");
INSERT INTO aoj_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Eaꞌ Pailat nawis andoꞌ wapani naꞌipa esis Juda naꞌi, “Ipaꞌ pemeꞌ! Aeꞌ aoꞌwana nafiꞌmai ipaꞌ ma pegegawa aeꞌ ina ati anis maefah awasi, owaꞌ. Ina ati anef waf awafi ma anen endaꞌmana anif basef, owaꞌ.” ");
INSERT INTO aoj_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Eaꞌ Jisas aꞌ nawis andoꞌ. Hat atamba mandaꞌ mandof higatagufi magalaꞌwatefaf siꞌi hati fapomana balaga ananigai eaꞌ lowaf akwahifi fapomana. Eaꞌ Pailat naꞌipas naꞌi, “Ipaꞌ piti aman anaꞌe.” ");
INSERT INTO aoj_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Eaꞌ amom pris dembami maloma plisman amamumi ataꞌ matolona atin, maꞌias dindinip mehip aꞌowaꞌ maꞌi, “Dolana nil lawag usiꞌigai tiꞌwanaegai!” Eaꞌ Pailat nagwamama basef naꞌi, “Ipaꞌ atipa faꞌana dolanago. Apaꞌ aeꞌ owaꞌ, aeꞌ ina ati anef waf awafi anen nandaꞌafi ma endaꞌ kotimana, owaꞌatin.” ");
INSERT INTO aoj_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Eaꞌ amom Juda magwamana basef maꞌi, “Anen nagaꞌi anen Nogamana Godi. Eaꞌ muꞌuli apeꞌini naꞌi anen aꞌ nondagaꞌ.” ");
INSERT INTO aoj_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Fowaꞌ Pailat ombal mahana kwasakwasala apaꞌ deiꞌ owaꞌ, nameꞌ basef ifimba atif, ombal aꞌ luꞌum mahana aꞌowaꞌ. ");
INSERT INTO aoj_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Eaꞌ nawis nomon ipat atamba nahaliꞌ Jisas naꞌi, “Inaꞌ nataga nafiꞌi ani?” Apaꞌ Jisas ina nagwamana anif basef, owaꞌ. ");
INSERT INTO aoj_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Eaꞌ Pailat naꞌipana naꞌi, “Inaꞌ nandaiwaꞌma nigaꞌipi anif basef? Inaꞌ negawa aeꞌ, aꞌa owaꞌ? Aeꞌ banagiwai ma ekwaha inaꞌ negafeꞌ dowaf aꞌa iꞌipas sehena negagaꞌ lawag usiꞌigai tiꞌwanaegai.” ");
INSERT INTO aoj_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Eaꞌ Jisas nagwamana basef naꞌi, “Iꞌi God nagape ilifi owaꞌ neseꞌena banagami inaꞌa, inaꞌ atina ina banagena ma negatalogofa aeꞌ, owaꞌ. Iꞌi nehe egaꞌ, waf afamba awafi. Apaꞌ amom amamba mofaꞌe agafiꞌmai ineꞌi, waf amamifi awafi luꞌuf aꞌowaꞌ, fikilaꞌ waf awafi ineꞌifi.” ");
INSERT INTO aoj_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Pailat nameꞌ basef ifimba atin, eaꞌ naꞌi notagwaha Jisas nefeꞌ wahifina. Owaꞌ esis Juda sofalana mehip saꞌi, “Iꞌi inaꞌ netagwaha aman anamba nefeꞌ wahifina, ina alipunai ma Sisar gavman dembinai esis Romi, owaꞌ. Epen ami naꞌi anin atin king dambeni anin bouni Sisari.” ");
INSERT INTO aoj_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Pailat nameꞌ basef ifimba atin, nofaꞌi Jisas nawisi nataga andoꞌ eaꞌ nape anin sia amom dembami jas magapoma. Anamba saꞌi ufiaꞌw otamba atembaiꞌwi. Ufiaꞌw akwamba diga Hibrui saꞌi Gabata. ");
INSERT INTO aoj_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Nemaf afamba esis Juda sape sandondomba gwaꞌaisi ma naman sondaꞌ gwaꞌaisi luꞌwasi Pasova. Eaꞌ awin aꞌ nandasapaꞌ nape 12 klok. Owaꞌ Pailat naꞌipa esis Juda naꞌi, “Piti dembinai king ipeꞌinai nalutu naꞌaꞌe.” ");
INSERT INTO aoj_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Owaꞌ esis Juda saꞌipana mehip saꞌi, “Faꞌana, faꞌana, nendelana lawag usiꞌigai tiꞌwanaegai.” Eaꞌ Pailat nahaliꞌas naꞌi, “Ipaꞌ paꞌi aeꞌ endela king dembinai ipeꞌinai lawag aꞌa owaꞌ?” Eaꞌ amom pris dembami magwamana basef maꞌi, “Apaꞌ owaꞌ anona dembinai kinga, Sisar atona anen dembinai king apeꞌinai.” ");
INSERT INTO aoj_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Eaꞌ Pailat nakwahomasa Jisas esis Juda ma sogandolona lawag usiꞌigai tiꞌwanaegai. ");
INSERT INTO aoj_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Eaꞌ amom soldia mowaꞌ Jisas mofaꞌana mafeꞌ. Jisas atotona nofaꞌ lawag ananigai aꞌ nafeꞌ nakwaha wambel luꞌwambili nawis andoꞌ nafeꞌ nataga anagon agiligima Pipitagol Balagaigil. Diga Hibrui saꞌi Golgota. ");
INSERT INTO aoj_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Anamba amom mowaꞌana lawag usiꞌigai tiꞌwanaegai naloma anom amam biam. Anona nail waꞌol, anona nail waꞌol, eaꞌ Jisas nail laꞌafen. ");
INSERT INTO aoj_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Gavman Dembinai Pailat nandaꞌ anif basef nofaꞌef nandaꞌef fail lawag agamba ilif. Basef fagaꞌias naꞌamba faꞌi, “Jisas Nasaretinai, anen Dembinai King esis Judai.” ");
INSERT INTO aoj_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Esis Juda hiasi sati basef ifimba satalifif. Deiꞌ main, anamba amom magandola Jisasa nape felefeleꞌ Jerusalem. Eaꞌ basef faꞌi diga wanifiga. Diga Hibrui, Latini, a diga Griki. ");
INSERT INTO aoj_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Amom pris dembami esis Judai maꞌipa Pailat maꞌi, “Inaꞌ owaꞌi nendaꞌ basef ifimba niꞌi, ‘Dembinai King esis Judaia’, hapaifi. Inaꞌ nendaꞌ basef niꞌi, ‘Anen naꞌi, Aeꞌ Dembiwai King esis Judai.’” ");
INSERT INTO aoj_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Eaꞌ Pailat nagwamam naꞌi, “Basef aeꞌ andaꞌef eaꞌi fendape atapif.” ");
INSERT INTO aoj_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Amom soldia mandola Jisas eaꞌ, mofaꞌ luwaguf ananifi matambeꞌef biafigin biafigina mondandama aolef mofaꞌalef fendandamam. Eaꞌ mofaꞌ siot ananitai wapani. Siot atamba esis ina sosambalota, owaꞌ. Sandaꞌata tape siꞌita ilif tafeꞌ tataga owin. ");
INSERT INTO aoj_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Amom mandaꞌipama maꞌi, “Afaꞌ ina owala siot atamba, owaꞌi. Afaꞌ ondaꞌ pilai satu ma ami nigikilaꞌi nefaꞌata.” Amom maꞌias naꞌamba maila anif basef fowaꞌifi fagape Buk Baibeli afataga fandawalap endilisi. Basef ifimba fagaꞌi naꞌamba faꞌi, “Amom matambeꞌ luwaguf aeꞌafi fafeꞌma amom atona atin eaꞌ mandaꞌ satu ma ami nigikilaꞌi nefaꞌef.” Eaꞌ amom soldia mandaꞌas naꞌamba atin. ");
INSERT INTO aoj_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","26","Maꞌma Jisasi kwaloma owamaꞌw akoꞌukwi waloma anoꞌw nemataꞌw Maria kwagasoꞌ Klopasi waloma Maria Makdalaiꞌwi awo biawai biawa walutu felefeleꞌma lawag Jisas nagailagai. Eaꞌ Jisas nati maꞌmana ananiꞌwi kwaloma aeꞌ ananiwai okom magamagailai, afaꞌ biafa walutu felefeleꞌma anen. Eaꞌ naꞌipa maꞌmana naꞌi, “Maꞌme, aman anamba nogamena ineꞌinai.” ");
INSERT INTO aoj_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Eaꞌ naꞌipa aeꞌ alipuwai ananiwai naꞌi, “Nemataꞌw akwamba maꞌmena ineꞌikwi.” Nogota atamba aeꞌ efaꞌakw kwafeꞌ ipat aeꞌatai ma igimafiaꞌw dondol atapiꞌw. ");
INSERT INTO aoj_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Aꞌi owaꞌ main, Jisas nogawa maol hiani ananini ahiꞌalan, eaꞌ okom maꞌi anif basef fagape Buk Baibeli fetaga fendawalap. Eaꞌ naꞌi, “Aeꞌ iap paseꞌema embel.” Anen naꞌias naꞌamba nagiꞌma basef ifimba Baibelifi. ");
INSERT INTO aoj_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Eaꞌ anol botol siꞌila embel wain numbutimbeli baꞌoh. Eaꞌ amom mofaꞌ anom mosong mowala wain embel ambalemba magiam masapaꞌam anogol bagol mofaꞌam mandomanam malogol Jisasi ma nogaꞌ embel. ");
INSERT INTO aoj_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Anen naꞌ wain embel ambalemba eaꞌ naꞌi, “Maol inimba ahiꞌalan.” Eaꞌ nindiwa balaga ambal aꞌ landahiꞌ lafeꞌana nagaꞌ dogw. ");
INSERT INTO aoj_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Nemaf afamba esis Juda sape sandondomba gwaꞌaisi maisa naman sondaꞌ gwaꞌaisi luꞌwasi Pasova. Nemaf afamba deiꞌifi sabat luꞌwafi fikilaꞌ sabat anif nimaguf hiafi. Eaꞌ amom Juda mandaiwaꞌ ma amom wanom migail atapim lawah agahemba nemaf afamba luꞌwafi. Eaꞌ mafeꞌ mahaliꞌ Pailata amom soldia mugundiwa boꞌwagah amamugahi ma mogagaꞌ ulala motagwahom mugisilaꞌi. ");
INSERT INTO aoj_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Eaꞌ amom soldia mafeꞌ anamba maham magaila. Eaꞌ mati anona nagail waꞌili mindiwa boꞌwagahana aꞌ nagaꞌ. Eaꞌ mafeꞌma anona waꞌol mundiwa boꞌwagahana. ");
INSERT INTO aoj_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Eaꞌ mafeꞌ ma Jisas nagaila, owaꞌ mati anen aꞌ nagaꞌ dogw endilisi. Eaꞌ amom ina mindiwa boꞌwagah ananigahi, owaꞌ. ");
INSERT INTO aoj_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Eaꞌ anona soldia nandaꞌ wambaꞌw napisila lambeh Jisasi waꞌol. Eaꞌ kwafalis atis esimbel baloma embel maluwi. ");
INSERT INTO aoj_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Aeꞌ ati amamba naep aeꞌapi aꞌipipa basef ifimba. Eaꞌ basef ifimba aeꞌafi endilisifi atif. Aeꞌ egawa basef ifimba agaꞌipipafi endilisifi aꞌipipa ma ipaꞌ wapani pigahapifif. ");
INSERT INTO aoj_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","37","Fowaꞌ basef fagail Buk Baibeli faꞌias naꞌamba faꞌi, “Owagama bihitagof ananigufi ina totoweagof, owaꞌatin.” Eaꞌ anif wapani faꞌias naꞌamba faꞌi, “Owagama esis siti aman anamba sagapisilana wambaꞌwi.” Amom soldia mandaꞌam naꞌamba maila basef ifimba atif fagail Buk Baibeli fataga fandawalap endilisi. ");
INSERT INTO aoj_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Josep Arimateainai anen alipunai Jisasi, apaꞌ anen ombal mahana ma amom Juda. Eaꞌ nahapifana nomonas atis sape sandambahoꞌ. Aꞌi owaꞌ main, anen nafeꞌ nahaliꞌ Pailata alop Jisasi, Eaꞌ Pailat naꞌi ahoꞌ, aꞌ nafeꞌ nofaꞌap nafeꞌ. ");
INSERT INTO aoj_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","40","Anen Josep nafeꞌ naloma Nikodemus, anamba fowaꞌ nafeꞌ nagati Jisas anomb owambi. Anen nofaꞌi anin marasin buꞌwani sandaꞌan ifat lawahi, agilima mer naloma alos. Marasin inimba hiani nimanin aꞌowaꞌ, 75 paun. Eaꞌ amom biam mafeꞌ mofaꞌ alop Jisasi mandaꞌ luwaguf afitifi faloma marasin inimba mombafana, maila waf esis Judai. ");
INSERT INTO aoj_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Felefeleꞌma anamba magandola Jisasa anof aof fape. Aof afamba anona bolotaf nagal siꞌi matmat dambaitai nape. Anamba esis ina deiꞌ sawa anin epenagon, ataꞌ owaꞌatin. ");
INSERT INTO aoj_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Matmat atamba tape felefeleꞌ. Nemaf afamba nemaf esis Juda saꞌi sogowandoꞌma hiahawesafi, ma nemaf sagapoma nomaꞌwafi saꞌi sabat felefeleꞌma fegataga. Eaꞌ mofaꞌ alop Jisasi mawana matmat atamba. ");
INSERT INTO aoj_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Akot ataꞌ tail, felefeleꞌma kuhumbita nemaf Sande Maria Makdalaiꞌwi kosafel kwafeꞌ matmat. Eaꞌ kwati otam ina ataꞌ masopama uta matmati, owaꞌatin. Anin epen nelefatam aꞌ mafeꞌ maꞌoh waꞌol. ");
INSERT INTO aoj_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Eaꞌ kotanima kwasagih kwafiꞌmai aeꞌi Saimon Pita wagapoma, aeꞌ alipuwai Jisasi okom magamagailai. Eaꞌ kwaꞌipafa kwaꞌi, “Anis safeꞌ sofaꞌ Dembinai nakwaha matmat asafeꞌ. Eaꞌ afaꞌ ina ogawana safeꞌ sambeꞌana anima.” ");
INSERT INTO aoj_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","4","Eaꞌ eaꞌ aloma Pita wasagih wafeꞌ wataga matmat atamba. Wasagih wafeꞌ, apaꞌ aeꞌ ikilaꞌ Pita aliꞌ afaꞌ ataga matmat atamba. ");
INSERT INTO aoj_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Eaꞌ indiwa nembawa etawa ati luwaguf atif faꞌoh nomon apaꞌ ina awis nomon, owaꞌ. ");
INSERT INTO aoj_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","7","Owaꞌ Saimon Pita nagiꞌmi nafiꞌi nataga eaꞌ nawis matmat bolotaf nomon. Eaꞌ nati luwaguf mogowaꞌanami atom maꞌoh, maloma anef lowaf mandaꞌaf mogowaꞌ balagonafi. Lowaf afamba sindiwaf sambeꞌaf faꞌoh anagon daiagon. Apaꞌ luwaguf ifimba anif faꞌoh dei. ");
INSERT INTO aoj_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Eaꞌ aeꞌ aliꞌ agafeꞌ matmat atambai agiꞌmana awis nomon ati hiahawes isimba aꞌ ahapifana. ");
INSERT INTO aoj_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Nogota atamba afaꞌ ina ogawa basef fagail Buk Baibeli fagaꞌi Jisas nogaꞌ notanima nogosafel wapani, owaꞌ. ");
INSERT INTO aoj_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Eaꞌ afaꞌ biafa utanima wafeꞌ ipat. ");
INSERT INTO aoj_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Apaꞌ Maria atoꞌw kwalutu kwalopana matmat andoꞌ. Kwalutu kwalopana atin, kwasisil kwati bolotaf matmat nomon, ");
INSERT INTO aoj_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","akwati ensel biam mala luwaguf afitimi mape anamba alop Jisasi dokoꞌ pagaꞌoma. Amom biam anona nape balaga Jisasi gagafeꞌma, anona boꞌwagah hagafeꞌma. ");
INSERT INTO aoj_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Eaꞌ mahaliꞌakw maꞌi, “Inaꞌ nalopa main?” Eaꞌ akoꞌw kwagwamam basef kwaꞌi, “Anis asofaꞌ Dembinai aeꞌanai safeꞌ eaꞌ ina egawa anamba safeꞌ sagambeꞌanama, owaꞌatin.” ");
INSERT INTO aoj_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Kwaꞌipam basef ifimba ma eaꞌ, kwandambema owaꞌ kwati Jisas nalutu nalomaꞌw. Apaꞌ ina kogawa anen kwaꞌi Jisas, owaꞌ. ");
INSERT INTO aoj_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Eaꞌ Jisas nahaliꞌakw naꞌi, “Nemataꞌw, deiꞌ maina inaꞌ nagalef? Inaꞌ newandoꞌma ami?” Akoꞌw okom maꞌi owaꞌ anona nandaꞌ maol aofi. Eaꞌ kwaꞌipana kwaꞌi, “Dembinai, iꞌi inaꞌ negefaꞌanama, niꞌipi anamba nefaꞌana nafeꞌ nagambeꞌanama?” ");
INSERT INTO aoj_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Eaꞌ Jisas naꞌipaꞌw naꞌi, “Maria.” Eaꞌ kwandambema kwati anen kwaipana diga Hibrui kwaꞌi, “Rabonai.” Basef kofagefa faꞌi Dembinai Tisa. ");
INSERT INTO aoj_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Eaꞌ anen Jisas naꞌi, “Ina nigahapila alop aeꞌapi, owaꞌi. Deiꞌ main? Aeꞌ ina deiꞌ aꞌ itanima afeꞌma Ahame gani ilif ataꞌ owaꞌ. Inaꞌ nefeꞌma owape aeꞌami niꞌipam niꞌi, Aeꞌ aꞌ itanima ilita ilifa Ahame aeꞌanai a Ahamepa ipeꞌinai, efeꞌma God Dembinai aeꞌanai, a God Dembinai ipeꞌinai.” ");
INSERT INTO aoj_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Eaꞌ akoꞌw kwafeꞌma alipumi ananimi magapoma kwaꞌipam kwaꞌi, “Aeꞌ ati Dembinai eaꞌ!” Eaꞌ kwaꞌipama basef ifimba anen nagaꞌipaꞌwafi. ");
INSERT INTO aoj_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Nemaf afamba Sande owamb, afaꞌ alipufai Jisasi wandakolas ondotowalo wape anota ipat nomon. Afaꞌ ombal mahafama amom dembami esis Judai. Owaꞌ Jisas nafiꞌi nalutu nalomafa naꞌipafa naꞌi, “Nelelemb ipeꞌilimbi bepe saꞌombel.” ");
INSERT INTO aoj_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Naꞌipafa basef ifimba eaꞌ, nihimbaꞌmafa lagufi lambeh ananisi. Eaꞌ afaꞌ wati Dembinai afaꞌinai eaꞌ, asonahafama anen aꞌowaꞌ. ");
INSERT INTO aoj_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Eaꞌ naꞌipafa wapani naꞌi, “Aeꞌ aꞌi nelelemb ipeꞌilimbi bepe awanalemb. Aeꞌ deiꞌ aꞌi esapaꞌepa pefeꞌ piꞌipasa basef Godi siꞌi Ahame nasapaꞌe afiꞌi agaꞌipipa.” ");
INSERT INTO aoj_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Naꞌipafa ifimba ma eaꞌ, aꞌ naomafa ambip naꞌipafa naꞌi, “Ipaꞌ pefaꞌ Ambal buꞌunai Godi. ");
INSERT INTO aoj_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Ama iꞌi pegakwaha waf awafi epen ami nandaꞌafi, God wapani aꞌ nokwahomanaf okom mosoꞌanaf. Apaꞌ iꞌi ipaꞌ owaꞌ pekwaha waf afamba awafia, God wapani ina atiasi nokwahef okom mosoꞌanaf, owaꞌatin.” ");
INSERT INTO aoj_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Anona ma afaꞌ 12-pelaifa alipufai Jisasi, Tomas agol waꞌagol Didimas. Kofagogola saꞌi maꞌmam kofolam atifi. Nemaf afamba Jisas nafiꞌi nagatolofa, Tomas ina nape nalomafa, owaꞌ. ");
INSERT INTO aoj_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Eaꞌ anom alipumi ananimi mafeꞌ maꞌipana maꞌi, “Afaꞌ wati Dembinai afaꞌinai eaꞌ.” Owaꞌ Tomas naꞌipam naꞌi, “Iꞌi aeꞌ owaꞌ ataꞌ iti melegwa lagof ananigufi sagahana nigufa, ma esa faf aeꞌafi ma niguf fagawisa eaꞌ esapaꞌ lagol aeꞌagili guwis nomon lambeh ananimbihi, daoꞌ ihapifana. Apaꞌ iꞌi owaꞌ, owaꞌatin.” ");
INSERT INTO aoj_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Nimaguf 8-pelaif fefeꞌma eaꞌ, afaꞌ wape anota ipat nomon, ondotowalo wape. Afamba Tomas wapani nape nalomafa. Owaꞌ Jisas nawisi nalutu nalomafa naꞌipaf naꞌi, “Nelelemb ipeꞌilimbi bepe awanelemb.” ");
INSERT INTO aoj_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Eaꞌ naꞌipa Tomas naꞌi, “Dowa faf ineꞌifi fifiꞌi naꞌa. Eaꞌ niti lagof aeꞌagufi. Nesapaꞌ lagol ineꞌigili guwisi lambeh aeꞌambihi nomon. Ina okom bimbiafim mopaina, owaꞌi. Nindahapifi endilisi.” ");
INSERT INTO aoj_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Eaꞌ Tomas naꞌipana naꞌi, “O, Dembinai aeꞌinai, God aeꞌinai.” ");
INSERT INTO aoj_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Eaꞌ Jisas naꞌipana naꞌi, “Inaꞌ natolowe eaꞌ, deiꞌ nahapifi. Apaꞌ epes ami owaꞌ sogatolowaia, sahapifi sonahas endilisi.” ");
INSERT INTO aoj_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Jisas nandaꞌ hiahaom hiami banagami daiam siꞌi God nandaꞌami ma nogohnaep alipufai ananifai. Basefa hiahaom amamba ina andaꞌef hiꞌalef fape buk akwaꞌe, owaꞌ. ");
INSERT INTO aoj_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Andaꞌ basef ifimba doꞌwanif atifa hiahaom amamba ma ipaꞌ pigahapifa Jisas anen Nogamana Godi, anen Krais, God nandandepana nasapaꞌana nagafiꞌii. Ma pihapifa agol ananigili pefaꞌ ambal namili pegape namipa dondol lifilafi. ");
INSERT INTO aoj_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","2","Jisas nagaꞌ nosafel wapani ma eaꞌ, alipufai ananifai aꞌ watolona wapani nimaguf bif. Aꞌi owaꞌ main, wagiꞌ watolona wapani. Basef fagaꞌias naꞌamba. Jisas nafeꞌma afaꞌ gani dumb luꞌwambi Taiberias. Anofa afaꞌ ondowaꞌanima atogon wagapani afamba. Saimon Pita, Tomas agol waꞌagol Didimas maloma Nataniel, anen Kenainai, itap luꞌupa Galili. Amom maloma nogaopana biam Sebedii maloma amom biam daiam Jisasi ondowaꞌanima wape atogon. ");
INSERT INTO aoj_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Eaꞌ Saimon Pita naꞌipafa naꞌi, “Aeꞌ aꞌi efeꞌ igi agof.” Eaꞌ afaꞌ waꞌi, “Olomena ofeꞌ atin.” Eaꞌ wafeꞌ walota anota bot wafeꞌ waꞌi ugi agof wafeꞌ wandaꞌam owamb ambamba laomb dandaꞌ apaꞌ afaꞌ ina wagi anol aol, owaꞌatin. ");
INSERT INTO aoj_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Wafilu kuhimbita atota Jisas nafeꞌ nalutu dumb ambamba akata apaꞌ afaꞌ ina ogawa waꞌi anen Jisas, owaꞌ. ");
INSERT INTO aoj_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Eaꞌ nofalafa naꞌi, “Awami saꞌupai, ipaꞌ pagi anogof agof aꞌa owaꞌ?” Eaꞌ wagwamana basef waꞌi, “Owaꞌatin.” ");
INSERT INTO aoj_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Eaꞌ naꞌipafa naꞌi, “Ipaꞌ ataꞌ pela anemb bewala bot atamba waꞌol lagol kwahisigilima. Eaꞌ atiasi apiti anogof agof.” Eaꞌ afaꞌ waꞌi ola anemb owaꞌ, owafai agof hiami. Eaꞌ ina laꞌififa ogagiai anemb bilitai begatoma bot nomon, owaꞌatin. Deiꞌ main? Agof hiami aꞌowaꞌ mala anemba namba asiꞌina. ");
INSERT INTO aoj_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Aeꞌ alipuwai Jisasi okom magamagailai, aꞌipa Pita aꞌi, “Nanumba Dembinai afaꞌinai.” Saimon Pita dokoꞌ natagwaha saket ananitai taꞌoh eaꞌ nandaꞌ maol owaꞌ, nameꞌ basef ifimba nala saket wapani nandaꞌ kopiꞌ nowala embel dumb nopaul nafeꞌ embel. ");
INSERT INTO aoj_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Eaꞌ afaꞌ daiafa watoma bot wagiꞌmana wagiai anemb siꞌinama agof. Afaꞌ ina wail laogona akata, owaꞌ. Siꞌi 100 mita. ");
INSERT INTO aoj_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Wafeꞌ wataga akata, wati anif nif fandif eaꞌ wati anagof agof fasef nif faloma anota bret. ");
INSERT INTO aoj_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Eaꞌ Jisas naꞌipafa naꞌi, “Ipaꞌ faꞌi anagof agof dokoꞌ pagagiagufi.” ");
INSERT INTO aoj_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Eaꞌ Saimon Pita nalota bot atamba nagiai anemb bafiꞌi akata. Anemb ambamba siꞌimba agof luꞌwagufi atogof 153-pelaiguf. Apaꞌ anemb ina peleꞌatamb, owaꞌatin. ");
INSERT INTO aoj_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Eaꞌ Jisas naꞌipafa naꞌi, “Ipaꞌ fiꞌi ma ataꞌ peaꞌ gwaꞌaisi.” Apaꞌ afaꞌ ina anona banagona ma nohaliꞌana nigaꞌi, “Inaꞌ ami?” Owaꞌatin. Deiꞌ main, afaꞌ ogawa anen Dembinai afaꞌinai. ");
INSERT INTO aoj_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Jisas nafiꞌi nofaꞌ bret nasoꞌafa, a agof wapani naꞌamba atin. ");
INSERT INTO aoj_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Fowaꞌ Jisas nogosafel wapani, naliꞌ nafeꞌma afaꞌ alipufai ananifai watolona nimaguf bif. Aꞌi owaꞌ main, deiꞌ watolona wapani aꞌ wanif. ");
INSERT INTO aoj_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Afaꞌ waꞌ gwaꞌaisi ma eaꞌ, Jisas naꞌipa Saimon Pita naꞌi, “Saimon nogama Joni, inaꞌ okom maimaili aꞌowaꞌ nikilaꞌ anom alipumi amamba daiam, aꞌa owaꞌ?” Eaꞌ anen naꞌi, “Ahoꞌ, Dembinai. Inaꞌ negawa aeꞌ okom maimailina.” Eaꞌ Jisas naꞌipana naꞌi, “Inaꞌ neseꞌama gwaꞌaisi sipsip nogami aeꞌami.” ");
INSERT INTO aoj_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Eaꞌ Jisas nahaliꞌana wapani naꞌi, “Saimon nogama Joni, inaꞌ okom maimaili endilisi, aꞌa owaꞌ?” Eaꞌ nagwamana basef naꞌi, “Ahoꞌ, Dembinai. Inaꞌ negawa aeꞌ okom maimailina.” Eaꞌ Jisas naꞌipana naꞌi, “Inaꞌ nimafi sipsip aeꞌami.” ");
INSERT INTO aoj_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Jisas naliꞌ nahaliꞌana bif eaꞌ deiꞌ nahaliꞌana wapani aꞌ wanif naꞌi, “Saimon nogama Joni, inaꞌ okom maimaili aꞌa owaꞌ?” Eaꞌ Pita okom iwanim naꞌipana naꞌi, “Dembinai, inaꞌ negawa hiahaom hiami. Inaꞌ negawa aeꞌ okom maimailina.” Eaꞌ Jisas naꞌipana naꞌi, “Inaꞌ neseꞌama gwaꞌaisi sipsip aeꞌami. ");
INSERT INTO aoj_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Endilisi aeꞌ aꞌipina, fowaꞌ inaꞌ ataꞌ saꞌwina, inaꞌ nowahoꞌ let eaꞌ nafeꞌ mamahagoma nomonas ineꞌisi saꞌi negafeꞌma. Apaꞌ owagama inaꞌ negatagama hagena, inaꞌ atiasi nendowa logof ineꞌigufi ma anom amam daiam mowahoꞌmena let mohapilina nefeꞌ anamba inaꞌ nindaiwaꞌmagoma.” ");
INSERT INTO aoj_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Jisas naꞌipana naꞌamba ma nigihimbaꞌmam ufiaꞌw ma soha Pita nogagaꞌ ma epes hiasi sogasaꞌma agol Godi luꞌwagol. Eaꞌ deiꞌ Jisas naꞌipana naꞌi, “Nila aeꞌ.” ");
INSERT INTO aoj_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Eaꞌ Pita nandambema nati aeꞌ, alipuwai Jisas okom magamagailai, agiꞌmam afiꞌi. Aeꞌ maꞌuwi fowaꞌ afaꞌ wape waꞌ gwaꞌaisi ma indisiꞌah felefeleꞌma Jisas ahaliꞌana agaꞌi, “Dembinai, atiasi ami niꞌipa boumi ma nigihimbaꞌmama inaꞌ negapoma?” ");
INSERT INTO aoj_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Eaꞌ Pita natiti aeꞌ, nahaliꞌ Jisas naꞌi, “Dembinai, aman anamba anaf nope niꞌimama?” ");
INSERT INTO aoj_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Eaꞌ Jisas nagwamana basef naꞌi, “Iꞌi aeꞌ iꞌi anen aꞌ nope ambal lopaona nope nefeꞌ nefeꞌ afamba aeꞌ igitanimai, isimba ina maol ineꞌini, owaꞌatin. Inaꞌ nila aeꞌ.” ");
INSERT INTO aoj_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Eaꞌ basef basoꞌafi wafifi ifimba fafeꞌma afaꞌ alipufai Jisasi faꞌias naꞌamba faꞌi, “Aman anamba anaf ina nogaꞌ, owaꞌ.” Apaꞌ Jisas ina naꞌipafa basef ifimba esis sagaꞌiefi, owaꞌ. Basef ifimba kwamaifi. Jisas naꞌi basef ifimba atif naꞌi, “Iꞌi aeꞌ iꞌi anen nope nefeꞌ nefeꞌ ma nemaf aeꞌ igitanimai, isimba ina maol ineꞌini, owaꞌatin.” ");
INSERT INTO aoj_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Aman anamba alipunai Jisasi eaꞌ aeꞌ maꞌuwi. Aeꞌ aꞌipipa basef ifimba ma hiahaom amamba Jisas nandaꞌami deiꞌ andaꞌam magail buk akwaꞌi. Apaꞌ Kristen mogawa basef ifimba endilisifi atif aeꞌ andaꞌafi. ");
INSERT INTO aoj_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Jisas nandaꞌ anin maol hiani daian wapani. Iꞌi anis epes sondaꞌ basefa maol Jisasi hiꞌilan filai, aeꞌ aꞌi itap anamba hiagoma owaꞌ anagona buk hianai nogaꞌoha, owaꞌatin. Asiꞌigin dog. Basef eaꞌ maꞌuf. ");
INSERT INTO aoj_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","O, alipunai Tiofilus, buk akwamba fowaꞌ aeꞌ andaꞌakwi andaꞌ basefa hiahaom hiami Jisas nandaꞌami nagawalipa esis amam nematawa ");
INSERT INTO aoj_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","ma dambadamba naliꞌ nandaꞌam eaꞌ mafiꞌi matagama nemaf afamba God nofaꞌana nagalota gani heven. Fowaꞌ Jisas owaꞌ ataꞌ nolota hevena, anen naliꞌ nasoꞌama basef ifimba naꞌipam dindinipa maol amom aposel amamba anen nandandepami. Anen nasoꞌama maol inimba amoma banagami amamba Ambal buꞌunai Godi. ");
INSERT INTO aoj_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Fowaꞌ saha Jisas nofaꞌ akafimi nagaꞌ eaꞌ, notanima nosafel wapani nafeꞌ natagama alipumi ananimi. Eaꞌ nape awin siꞌini duꞌwanini nandaꞌ hiahaom hiami banagami ma nihimbaꞌmam mogogawa endilisi anen nofaꞌ ambal namili nape namona. Nimaguf ifimba anen nawalipama epes hiasi sogawis nomona maol Godi nope Dembinai nugumafias. ");
INSERT INTO aoj_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Anen ataꞌ nape nagalomam naꞌipam dindinip naꞌi, “Ipaꞌ deiꞌ ina pekwaha Jerusalem ulal, owaꞌi. Pepe pehafa hiahaom amamba Ahame naꞌi endilisi atis nogasiꞌipami. Amamba fowaꞌ aeꞌ agaꞌipipami. ");
INSERT INTO aoj_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Fowaꞌ Jon naliꞌ napisiꞌ amam nematawa hiasi embel. Apaꞌ ipaꞌ atiasi apefaꞌ Ambal buꞌunai Godi nuwisipa. Ina atiasi nogota laota tefeꞌ, ataꞌ bandata ipaꞌ aꞌ pefaꞌ Ambal anamba nuwis nope nolomepa. ");
INSERT INTO aoj_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Nemaf afamba amom alipumi Jisasi mandakolas atogon mahaliꞌana maꞌi, “Dembinai, aꞌi atiasi nogota ataꞌe inaꞌ nendaꞌ apaꞌ mofaꞌ agol luꞌwagili ma mogaliꞌamona esis bousi ma apaꞌ atepa apeꞌilimbi aꞌa owaꞌ?” ");
INSERT INTO aoj_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Eaꞌ anen naꞌipam naꞌi, “Amamba ina hiahaom ipeꞌimi ma pegegawa nogota ma nimaguf Ahame nandandepafi, owaꞌ. Anen atona numafi amamba. ");
INSERT INTO aoj_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Apaꞌ basef ipeꞌifi ifimba. Atiasi Ambal buꞌunai Godi nifiꞌmai ipaꞌ, nemaf afamba pefaꞌ banagami ma main, daoꞌ apewalapa basef aeꞌafi Jerusalem eaꞌ ganimba hiagoma agol Judia aꞌ ganimba itap luꞌupa Samaria, eaꞌ pefeꞌ anamba itap walemb hiagoma hiꞌilagon.” ");
INSERT INTO aoj_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Jisas naꞌi basef ifimba hiꞌalef, esis ataꞌ salutu sagatologini atin, owaꞌ sati anen nandagia nakwaha itap nalota ilif. Eaꞌ anom ilagw mofaꞌana mafeꞌ eaꞌ ina satolona wapani, owaꞌatin. ");
INSERT INTO aoj_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Anen nafeꞌ eaꞌ, esis ataꞌ salutu satologon atin ilif otaga owaꞌ anom amam biam magala klos afitimii mondokwama mataga malomas malutu. ");
INSERT INTO aoj_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Eaꞌ maꞌipas maꞌi, “Ipaꞌ amam nematawa Galilipai, ipaꞌ ina pilutu pititi otaga ilif, owaꞌ. Jisas anamba deiꞌ God nofaꞌana nakwahepa eaꞌ nofaꞌana nalota heven. Anaf notanima nogafiꞌi pegatolona naꞌamba atin siꞌi deiꞌ palutu patolona nagalota heven.” ");
INSERT INTO aoj_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Eaꞌ esis sakwaha halafuta atamba Oliv, sotanima safeꞌ Jerusalem. Halafuta atamba ina laogona Jerusalem, owaꞌ, felefeleꞌ nogota atotota kilomita atitin siꞌi esis Juda sefeꞌ sifiꞌi nemaf afamba sabat sagapoma nomaꞌwafi. ");
INSERT INTO aoj_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Esis sotanima safiꞌi Jerusalem, safeꞌ sawis ipat eaꞌ safeꞌ salota sape ipat ilif esis sagapoma. Agof amamugufi agwafomba. Pita naloma Jemsi Jon a Andru a Filip naloma Tomasi Bartolomyu Matyu eaꞌ Jems, Alfius nogamana, a Judas, Jems nogamana eaꞌ Saimon anap miniꞌap Seloti. ");
INSERT INTO aoj_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Amom alipumi Jisasi mandakolas nimaguf hiafi lifilafi ma mandaꞌ beten maloma anowa nematawa saloma akoꞌw Maria Jisas maꞌmana saloma owapana Jisasi wapani. Esis hiasi sape sandabeten atogon. ");
INSERT INTO aoj_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Aꞌi owaꞌ, anef nemaf esis Kristen 120-pelais hiasi sandakolas sape eaꞌ Pita nosafel nalutu naꞌi, ");
INSERT INTO aoj_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Sahin owan aeꞌipai, anif basef fagail buk Baibeli fowaꞌ Ambal buꞌunai Godi nagawalapefa malogol dembinai king Deviti faꞌias naꞌamba. Naꞌi aman anamba Judas owagama nondaꞌ waf awafi ma nigihimbaꞌmama Jisas boumi. Ufiaꞌw ina kwasoꞌ, owaꞌ. Kwagala basef ifimba fegataga alihif. God atona naꞌi, deiꞌ basef ifimba fataga fandawalap. Fowaꞌ Judas ina deiꞌ nandaꞌ waf awafi nawalapa Jisasa amom, ataꞌ owaꞌ, nogota atamba ");
INSERT INTO aoj_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","anen alipunai afaꞌinai nandaꞌ maol nagaloma afaꞌi.” ");
INSERT INTO aoj_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","“Moni Judas nogofaꞌana waf afamba awafi ananifii aꞌ natala anep itap. Anen nafeꞌ itap apamba nowa laꞌafinama peꞌana nembel koloꞌwalanai hiꞌalana aꞌ afuna. ");
INSERT INTO aoj_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Eaꞌ epes hiasi sagape Jerusalami asogawa isimba. Eaꞌ diga asasigai sofala anamba agiligima saꞌi Akeldama. Apaꞌ maꞌi itap apamba esimbel koloꞌwalambel begetawapi.” ");
INSERT INTO aoj_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Deiꞌ main, Pita nagaꞌi basef ifimba fagape Buk Baibel Sami naꞌi, “‘Ipat ananitai atot tondape wafita dowaf. Ina anona aman nopaota, owaꞌatin.’ Eaꞌ anin Sam naꞌi anif basef wapani naꞌamba naꞌi, ‘Anona aman anaf aꞌ nohoꞌofana nofaꞌ maol ananini.’ ");
INSERT INTO aoj_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","“Eaꞌ deiꞌ apaꞌ aꞌ mondandepa anona aman apeꞌinai nohoꞌofanago ma mogawalipas basef ifimba Jisas notanima nogosafel wapani. Apaꞌ aꞌ mondandepa anona ma amom amamba mape magaloma apeꞌi ma afamba Dembinai Jisas nape nagalomapa. Afamba Jon nagawalipasa basef Godi nagapisiꞌ amam nematawa nafiꞌi nafiꞌi nataga ma nemaf God nofaꞌ Jisas nalota heven nagakwahepa.” ");
INSERT INTO aoj_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Pita naꞌias naꞌamba ma main, esis Kristen asandandepa amam biam. Anona Josep, agol waꞌagol Barsabas, eaꞌ agol waꞌagol wapani saꞌi Jastus. Eaꞌ anona Matias. ");
INSERT INTO aoj_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Eaꞌ esis sandabeten naꞌamba saꞌi, “Dembinai, inaꞌ negawa ukup epes hiasii hiꞌalep. Inaꞌ nendandepa amam amamba biam nihimbaꞌmapa aman mamahonama ");
INSERT INTO aoj_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","nogofaꞌ maol aposel nogahaꞌofa aman anamba Judas. Anen aꞌ nakwaha maol inimba nafeꞌ wambel awambili ma negawamana waf awafi.” ");
INSERT INTO aoj_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Eaꞌ esis sandaꞌ agof amom biami fail otamba biamba. Eaꞌ sala otamba ambamba bala anep malep siꞌi tin sakotoꞌwamba sati otam maliꞌ magatagai agol Matiasi. Eaꞌ sagawa God nandandepa Matias. Eaꞌ sandaꞌ anen nandaꞌ maol naloma amom aposel 11-pelaima mondaꞌ maol Godi. ");
INSERT INTO aoj_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Nemaf afamba luꞌwafi Pentikos afagataga, esis hiasi sagahapifanai sandakolas sape ipat atotota. ");
INSERT INTO aoj_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Aꞌi owaꞌ main, owaꞌ sameꞌ anom amalemb luꞌwami mandaꞌam mafiꞌi heven. Amalemb amamba mandameꞌ siꞌi fufin banagonai nagaluwi eaꞌ ipat atamba esis sagapautai asiꞌitama amalemb amamba. ");
INSERT INTO aoj_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Eaꞌ sati anogah afegah hogala siꞌi nif ileliwa pepaꞌatawa wafeꞌ watoma esis hiasi atona atin hiꞌalas. ");
INSERT INTO aoj_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Eaꞌ Ambal buꞌunai Godi nape siꞌinama esis atona atin hiꞌalas, saꞌi basef Godi ma diga naninani analemb walembi. Ambal anamba nandaꞌam mataga malogof asasigufi. ");
INSERT INTO aoj_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Anis Juda safiꞌi sape Jerusalem, sandaꞌ lotuma Godi, safiꞌi sandanda misiꞌah hiahi ganimba itap hiagoma. ");
INSERT INTO aoj_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Esis hiasi sameꞌ amalemb amamba eaꞌ anis amam nematawa hiasi daias safiꞌi sunduwaꞌanima sape. Eaꞌ epes isimba hiasi atona atin sameꞌ esis sagahapifanai eaꞌ saꞌi basef Godi ma diga naninani analemb walembi. Eaꞌ sosafel gogolalasis kwapeteꞌ aꞌowaꞌ ma sagameꞌ diga asasigai. ");
INSERT INTO aoj_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Esis sosafel gogolalasis kwapeteꞌ aꞌ nomonas salasafeꞌ hiahias. Eaꞌ saꞌias saꞌi, “Amom amamba Galilimi, owaꞌ aꞌ maꞌi diga apeꞌigai atona atini. ");
INSERT INTO aoj_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Deiꞌ maina apaꞌ hiapai atona atin magameꞌ amom magaꞌi diga apeꞌigai dondoꞌ siꞌi apaꞌ magameꞌagama mamasapa apeꞌisi? Apaꞌ mafiꞌi itap apamba hiapi luꞌupa agufipa apamba. ");
INSERT INTO aoj_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","10","Partiai Midia a Elam eaꞌ Judiai Kapadosia paloma Pontusi Esia a Frigia Pamfiliai Isip eaꞌ apaꞌ anep itap luꞌupa Mesopotamia eaꞌ esis ganimba Libiama felefeleꞌma wambel Sairini. Eaꞌ anepa apaꞌ wambel Rom mafiꞌi mape naꞌa. ");
INSERT INTO aoj_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Apaꞌ Juda maloma anis epes daias maila waf esis Juda sandaꞌ lotuwafi eaꞌ apaꞌ itap luꞌupa kofagama Kriti Arebia, apaꞌ hiapai mameꞌ amom mawalapa basefa hiahaom banagami maol Godi ma diga apeꞌigai hiagai.” ");
INSERT INTO aoj_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Eaꞌ hiasi sosafel gogolalasis kwapeteꞌ, esis nomonas sape hiahias. Esis atis sandahaliꞌma saꞌi, “Hiahawes isimba sandandaꞌ saꞌimama?” ");
INSERT INTO aoj_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Owaꞌ anis sandaꞌ iafam saꞌi, “Amom maꞌ embel wain dambaini eaꞌ mahaga magaol deiꞌ maꞌi basef naꞌambaifi.” ");
INSERT INTO aoj_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Aꞌi owaꞌ main, Pita nosafel nalutu naloma amom aposel 11-pelaim eaꞌ noga naꞌi banagambel nawalapa basefa esis amam nematawa hiasi naꞌi, “Ipaꞌ Juda alipipai paloma ipaꞌ amam nematawa hipai pafiꞌi pagape Jerusalami, ipaꞌ pembeꞌ aligaha basef aeꞌafi, ma pegegawa hiahawes isimba. ");
INSERT INTO aoj_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Ipaꞌ paꞌi amam amamba mandaꞌ spak, owaꞌatin. Deiꞌ ataꞌ kuhimbita awin ataꞌ natafi atin nainail siꞌi 9 klok. ");
INSERT INTO aoj_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Apaꞌ hiahaom amamba mataga siꞌi anona profet Joel fowaꞌ nagaꞌi, ");
INSERT INTO aoj_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","God naꞌi, ‘Felefeleꞌma nemaf akutaifi Aeꞌ eseꞌas Ambal buꞌunai aeꞌanai nope amam nematawa hiasi. Eaꞌ esaꞌma esis batawisipa ipeꞌisi asowalapa basef siꞌi amom profet magaꞌif. Eaꞌ ihimbaꞌma amam saꞌumi ipeꞌimi waf buꞌwafi aeꞌafi ma mope naep peseꞌam mogatolomi, eaꞌ eseꞌama koh dondoꞌah amom hagami ipeꞌmi ma igihimbaꞌmam waf aeꞌafi. ");
INSERT INTO aoj_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Ahoꞌ, nemaf afamba atiasi aeꞌ eseꞌasa Ambal buꞌunai aeꞌanai nope esis amam nematawa aeꞌasi sandaꞌ maola aeꞌi nosaꞌmas sowalapa basef aeꞌafi. ");
INSERT INTO aoj_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Eaꞌ endaꞌ anef waf daiaf fetaga gani otaga ilif, endaꞌ hiahaom banagami motaga naꞌaꞌe itap owin. Amamba naꞌamba. Endaꞌ nogoh hiagwi otaga, endaꞌ esimbel, nif fagandifi. ");
INSERT INTO aoj_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Eaꞌ embema awin alipini netaga owamb owambini netaga akwahin siꞌi esimbel. Ama iꞌi owaꞌ main, owaꞌ nemaf Dembinaii aꞌ fetaga. Nemaf afamba ananifi luꞌwafi endilisi aꞌowaꞌ. ");
INSERT INTO aoj_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Felefeleꞌma nemaf afamba epes ami sogofala agol Dembinai, bola nemeꞌas nofaꞌas nokwahomas waf awafi sotanimai sope epes ananisi.’” ");
INSERT INTO aoj_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Eaꞌ Pita naꞌipas wapani naꞌi, “Ipaꞌ epes Israelipai, ipaꞌ pemeꞌ anif basef deiꞌ igaꞌipipa aman anamba Jisas Nasaratinai. Ipaꞌ pegawa eaꞌ ma maol inimba banagani naloma banagami amamba God nandaꞌam laꞌafena ipeꞌi ma lagol aman anambai. Amamba mihimbaꞌmepa andeandeꞌ aman anamba God nasapaꞌana nagafiꞌii. ");
INSERT INTO aoj_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Fowaꞌ gani God nogawa eaꞌ okom mandandaꞌ naꞌamba ma nondaꞌ aman anamba nefeꞌ nogape lagof ipeꞌigufi. Eaꞌ epes isimba sogombaloꞌ muꞌuli Godii satopalopa ipaꞌ pembaloꞌana pandolana nail lawag usiꞌigai tiꞌwanaegai eaꞌ pahana nagaꞌ. ");
INSERT INTO aoj_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Apaꞌ owaꞌ, owaꞌatin. God notanima nasaꞌmana wapani aꞌ nakwaha akafimi ma gaꞌ ananimi. Deiꞌ main, gaꞌ inimba ina banagen aꞌowaꞌ ma nihapilana nogape, owaꞌatin. ");
INSERT INTO aoj_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","“Ahoꞌ, fowaꞌ gani Devit nagaꞌi basefa Jisas naꞌi, ‘Aeꞌ ati Dembinai aeꞌanai nape nalome waꞌol lagol aeꞌagili kwahisigilima dondol lifilafi. Eaꞌ anis epes ina sandaꞌme anom nimanimi akafimi, owaꞌ. ");
INSERT INTO aoj_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Isimba atis deiꞌ okom aeꞌami sonaham eaꞌ afega aeꞌagai gandagala. Aeꞌ epen falafuwai igagaꞌi, atiasi epe ehafa anona nogatopalope. ");
INSERT INTO aoj_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Deiꞌ main, atiasi ina nekwaha ambal aeꞌali aꞌ lofeꞌ lope anamba epes sagagaꞌi sagapoma, owaꞌatin. Eaꞌ ina atiasi nekwahowa alop aman anamba buꞌwinai hililiꞌi nandaꞌ maol ineꞌi foloꞌolap, owaꞌatin. ");
INSERT INTO aoj_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Inaꞌ eaꞌ nihimbaꞌme ufiawa wafeꞌ wagatagama waf ambal namilifi. Inaꞌ nape nalome sonahe endilisi.’” ");
INSERT INTO aoj_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Eaꞌ Pita naꞌipas wapani naꞌi, “Ipaꞌ sahope owape aeꞌipai, deiꞌ aeꞌ aꞌi ewalapa basef iꞌipipaef wal atina aman anamba akunamapa apeꞌinai Devit. Anen fowaꞌ nagaꞌ sawana, deiꞌ wandof ananifi ataꞌ fape laꞌafena apaꞌ atapif. Basef ifimba Devit ina naꞌifa anen atona, owaꞌatin. ");
INSERT INTO aoj_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Apaꞌ aman anamba Devit anen profet eaꞌ nogawa God naꞌi basef banagafi naꞌi endilisi ilif naꞌamba ma anaf nondaꞌ bafamana Deviti notaga nogape dembinai king siꞌi Devit nagape king. ");
INSERT INTO aoj_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Fowaꞌ Devit ataꞌ nagape, aꞌ nogawa eaꞌ amamba God naꞌi nondaꞌami. Naꞌamba deiꞌ anen naꞌi Dembinai Krais anaf nogaꞌ notanima nosafel wapani. Anen naꞌias eaꞌ naꞌi, ‘Anaf God ina nokwaha anen nope anamba sagagaꞌi sagapoma wandelef alop ananipi foloꞌolap, owaꞌ.’ ");
INSERT INTO aoj_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Aman anamba anen Jisas God eaꞌ nasaꞌmana notanima nosafel wapani. Eaꞌ afaꞌ hiafai aꞌ wati amamba deiꞌ waꞌiam. ");
INSERT INTO aoj_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Deiꞌ God nasaꞌmana nosafel nalota gani ilif eaꞌ nape lagol kwahisigili Godi. Anen aꞌ nofaꞌ Ambal buꞌunai Godi eaꞌ ma Ahamana, siꞌi fowaꞌ Ahamana nagaꞌipana naꞌi nogasoꞌana. Isimba atis deiꞌ Jisas nasoꞌasam esis hiahaom amamba patolom pagameꞌam eaꞌi. ");
INSERT INTO aoj_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Deiꞌ main, Devit ina aꞌ nalota heven, owaꞌ. Apaꞌ anen fowaꞌ naꞌias basefa naꞌi, ‘Dembinai naꞌipa Dembinai aeꞌanai naꞌamba naꞌi, “Inaꞌ nepe lagol kwahisigili aeꞌagili ma nepe dembinai negaloma aeꞌ. ");
INSERT INTO aoj_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","Iꞌi owaꞌ main, endaꞌ bousi ineꞌisi sefeꞌ lafela inaꞌ nikilaꞌas.”’ ");
INSERT INTO aoj_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Eaꞌ deiꞌ Pita naꞌias naꞌamba naꞌi, “Deiꞌ apaꞌ Israel mondagawa isimba andeandeꞌ. Aman anamba Jisas ipaꞌ pagandolana lawag usiꞌigai tiꞌwanaegai pahana nagagaꞌi, deiꞌ God nandaꞌana nataga nape Dembinai anen Krais, God nandandepana nasapaꞌana nagafiꞌii.” ");
INSERT INTO aoj_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Esis sameꞌ basef ifimba owaꞌ, faha nelelemb asasilimbi aꞌowaꞌ. Eaꞌ saꞌipa Pita naloma amom aposel daiam saꞌi, “Ipaꞌ sahopapa, deiꞌ apaꞌ eaꞌ mondaꞌ maina mogape andeandeꞌ?” ");
INSERT INTO aoj_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Eaꞌ Pita naꞌipas naꞌi, “Ipaꞌ hipai pekwaha waf awafi pendembema nelelemba God eaꞌ ipaꞌ hipai atona atin pefaꞌ baptaisa agol Dembinai Jisas Kraisi ma nogakwaha waf awafi ipeꞌifi. Ipaꞌ pendaꞌas naꞌamba, atiasi God neseꞌepa Ambal buꞌunai Ananinai nuwisipa. ");
INSERT INTO aoj_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Fowaꞌ God naꞌi basef endilisifi banagafi naꞌi neseꞌepa Ambal buꞌunai Ananinai nuwisipa peloma awasi ipeꞌisi soloma esis isimba amam nematawa hiasi ataꞌ sagapani laugunii anaf sigiꞌ sogatagai. Ahoꞌ God Dembinai apeꞌinai naꞌias eaꞌ ma nogasoꞌas Ambal buꞌunai Ananinai nuwis epes isimba mamahisa anaf nogofalasi.” ");
INSERT INTO aoj_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Pita ina naꞌipasa basef ifimba atif, owaꞌ. Naꞌipasa anif basef hiafi dindinipa nogafela ukup asasipi naꞌi, “Ipaꞌ solawaipa andeandeꞌ. Naꞌamba apefaꞌ nimanimi akafimi luꞌwami peloma amam nematawa deiꞌisi sandaꞌ waf awafii.” ");
INSERT INTO aoj_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Eaꞌ esis isimba eaꞌ sagameꞌ basef Pitai endilisii ma sagahapilafi, esis eaꞌ sofaꞌ baptais. Nemaf afamba God nowatani miniꞌap asasipi apataga laop eaꞌ 3,000-pelais sataga Kristen, eaꞌ sape saloma esis isimba amam nematawa sagahapifanai. ");
INSERT INTO aoj_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Amam nematawa isimba sagataga Kristen dambaisi esis banages aꞌowaꞌ ma sagameꞌ basef amom aposel magawalipasafi asandatopalopa atina anis sahin owan sape atogon atin saꞌ gwaꞌaisi sandabeten sahaliꞌ God atogon atin. ");
INSERT INTO aoj_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Nimaguf hiafi God nandaꞌ ametal luꞌunai ma hiahaom banagami hiami magatagama lagof amom aposeli. Eaꞌ amam nematawa hiasi aꞌ ombal luꞌwami mahas atapis nimaguf hiafi. ");
INSERT INTO aoj_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Eaꞌ esis hiasi hiꞌalas sagahapifa Kraisi sandakolas sape atogon atin sindihimbaꞌ opalef asasilifi aꞌ atifilif. Eaꞌ sagawa hiahawes asasisi gwaꞌaisi uga main hiasi, ina ataꞌ esis atona atini, owaꞌ. Hiahaom amamba hiami hiꞌalam esis hiasii sagahapifanai. ");
INSERT INTO aoj_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Eaꞌ esis anis sagahapifanai sasoꞌasa itap asasipi anis paloma anis hiahawes asasisi safeꞌma anis epes daindaias satalamasas. Eaꞌ sofaꞌ otamba ma hiahawes isimba satambeꞌamba sandaꞌamba sasoꞌ epes isimba gwaꞌaisi mais akasi. ");
INSERT INTO aoj_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Eaꞌ esis hiasi nembel atembel eaꞌ nimaguf danda safeꞌ ipat luꞌunai Godi. Eaꞌ sakolata safeꞌ saꞌ gwaꞌaisi ifagw asasigwi. Esis sonahasa sogasoꞌas gwaꞌaisi ma sogatopalopa anis daias eaꞌ sonahasa sakolata sagaꞌ gwaꞌaisi atogon. ");
INSERT INTO aoj_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Lifilafi esis sasaꞌma agol Godi luꞌwagol, eaꞌ opalef esis amam nematawa hiasii sagape andoꞌi boꞌwalefa esis Kristen ama nimaguf hiafi. Eaꞌ Dembinai nandaꞌ maol nimaguf danda ma nogofaꞌ anis amam nematawa sakwaha waf awafi ma sagafiꞌmai anen, nowatani miniꞌap isimba sagahapifanai. ");
INSERT INTO aoj_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Nogota atamba esis Kristen sandabetenatai, Pita naloma Jon mafeꞌ ipat luꞌunai Godi maꞌi mondabeten. Nemaf afamba eaꞌ wambomota 3 klok. ");
INSERT INTO aoj_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Eaꞌ anona aman boꞌwagah hondolaꞌanai nape anamba, maꞌmana ananiꞌwi fowaꞌ kogolana nape atapina. Dondol esis sandaꞌana sofaꞌana sahaponana nape ipat luꞌunai Godi andoꞌ felefeleꞌma uta sagaꞌi fasitai. Ma nondailasa moni gwaꞌaisi maisa esis amam nematawa sawis sagafeꞌma lotuwi. ");
INSERT INTO aoj_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Aman anamba nati Pitai Jon maꞌi mofeꞌ mugawis ipat atamba, nahaliꞌ amom biama mogasoꞌana anemba otamba anen. ");
INSERT INTO aoj_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Owaꞌ Pitai Jon matiti anen dindinip, Pita naꞌi, “Inaꞌ ataꞌ niti afaꞌ biafa.” ");
INSERT INTO aoj_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Eaꞌ nandambema nati amom, okom mandandaꞌ naꞌi owaꞌ mosoꞌana anis maefah. ");
INSERT INTO aoj_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Owaꞌ Pita naꞌi, “Aeꞌ moni ake, apaꞌ hiahawes buꞌwasi aꞌi atiasi igasiꞌinasi isimba. Aeꞌ aꞌi banagami Jisas Krais Nasaratinai atom aꞌipina, deiꞌ safel aꞌ nilutu nefeꞌ.” ");
INSERT INTO aoj_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Eaꞌ nahapila lagol kwahisigili aman anamba aunaii, nasaꞌmana. Eaꞌ kwafalis atis boꞌwagah haloma nembawai haꞌwalelef ananisi banages sataga boꞌwes. ");
INSERT INTO aoj_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Eaꞌ anen felalana nosafel nalutu eaꞌ nalutu nafeꞌ. Eaꞌ nalomom mafeꞌ mawis ipat luꞌunai Godi nomon nandagala kwapiꞌ atin nalutu nalemb nafeꞌ nasaꞌma agol Godi luꞌwagol. ");
INSERT INTO aoj_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Eaꞌ esis amam nematawa hiasi sati anen nafeꞌ nasaꞌma agol Godi, ");
INSERT INTO aoj_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","eaꞌ sogawana saꞌi anen maꞌuna aman anamba boꞌwagoh hondolaꞌanai, fowaꞌ nagape dondol uta atamba sagaꞌi fasitai ipat Godi luꞌunai nape nandailasa moni maisi. Esis sati anen boꞌona sosafel gogolalasis kwapeteꞌ ukup pape hiahaop. ");
INSERT INTO aoj_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","12","Aman anamba nandagala ma nagataga boꞌona eaꞌ esis sasagih safiꞌi ma sogatolona ilaf afamba sagaꞌi ilaf Solomoni. Pita nati isimba, naꞌipa esis naꞌi, “Ipaꞌ epes Israel, deiꞌ maina nomonas hiahawes sagapoma amamba? Deiꞌ maina ipaꞌ pagatiti afaꞌ biafa? Paꞌi banagami afaꞌimi maloma waf usiꞌifi afaꞌisi atis sandaꞌ aman anamba nataga boꞌona nosafel nafeꞌ? Owaꞌatin endilisi. ");
INSERT INTO aoj_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","God anamba bafapapa apeꞌimi Abraham naloma Aisaki Jekop mandaꞌ lotumanai, anen atona nandaꞌana nataga boꞌona nasaꞌma agol Jisasi, nandaꞌ maola anini. Anen eaꞌ aman anamba atona ipaꞌ pandaiwaꞌmana pagasoꞌamana amom agufumi gavmani. Dembinai Pailat naꞌi notagwahona nogafiꞌi, owaꞌ owaꞌatin. Ipaꞌ pandaiwaꞌmana pewaꞌ alafugahana. ");
INSERT INTO aoj_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Ipaꞌ pewa alafugaha aman anamba nandaꞌ maol Godi atin, usiꞌina endilisii. Eaꞌ pefala Pailat dindinipa anona aman awasinai naha anis epes sagagaꞌi, eaꞌ nakwahomepanai. ");
INSERT INTO aoj_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Apaꞌ aman buꞌunai kofagonama nogofaꞌapa mogafeꞌ ufiaꞌw ambal namiliꞌwi, anamba eaꞌ pahana nagaꞌ. Owaꞌ God nasaꞌmana nosafel matmat wapani eaꞌ afaꞌ biafa wape amam ananifai ogawalapa basefa isimba, wati anen nagape namona endilisi. ");
INSERT INTO aoj_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Eaꞌ afaꞌ biafa wahapifa Jisas. Anen atona nafela hapif afaꞌini, banagami ananimi mandaꞌ aman anamba boꞌona naep ipeꞌipi hipai. Banagami Jisasi atom deiꞌ mowaꞌ banaga aman anamba, patolona pegegawanai. ");
INSERT INTO aoj_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Endilisi, alipipai, aeꞌ egawa, ipaꞌ ina pegawa andeandeꞌma deiꞌ pandaꞌ waf afambai awafi ma Jisas, owaꞌ. Amom agufumi ipeꞌimi wapani amom naꞌamba atin. ");
INSERT INTO aoj_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Fowaꞌ God nawalapa basefa amom profet hiamii, ma Krais, God nasapaꞌana nagafiꞌii. Basef ifimba faꞌi Krais aꞌ nogameꞌ akafimi. Eaꞌ waf afamba deiꞌ ipaꞌ pandaꞌafi, afamba fandahama basef ifimba amamifi fataga fandawalap endilisi. ");
INSERT INTO aoj_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","“Deiꞌ ipaꞌ ataꞌ pekwaha nomonas amambai awami ipeꞌimi, pembema nelelemba Goda nogakwahomepa waf awafi ipeꞌifi ma nondaꞌepa pegataga beꞌepa. ");
INSERT INTO aoj_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Ipaꞌ iꞌi pendaꞌas naꞌamba, atiasi Dembinai God neseꞌepa banagami namumi ma ambagof ipeꞌigufi. Ama atiasi nogasapaꞌ Krais nogafiꞌmai ipaꞌ. Aman anamba fowaꞌ God nandandepana ma ipaꞌ eaꞌi, anen Jisas. ");
INSERT INTO aoj_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Deiꞌ napani heven nosasa nemaf afamba God nondaꞌ hiahaom hiami mogataga dambaim wapani. Siꞌi fowaꞌ nagaꞌifa ipeꞌi ma amom profet ananimi boꞌom hililiꞌi. ");
INSERT INTO aoj_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Siꞌi Moses nagaꞌi Jisas naꞌamba naꞌi, ‘God Dembinai ipeꞌinai, atiasi aꞌ nofaꞌ anona sahomepa ipeꞌinai, nondaꞌana nope profet siꞌi aeꞌ. Ipaꞌ pemeꞌ basef ananifi hiafi hiꞌindalef. ");
INSERT INTO aoj_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Eaꞌ epes ami sondaiwaꞌma sogameꞌ basefa profet anambai, esis ina ataꞌ sope miniꞌap apamba epes Godi, owaꞌ. Atiasi nohas sogaꞌ.’ ");
INSERT INTO aoj_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","“Eaꞌ amom profet amamba hiami, Samyuel naloma amom profet mataga magagiꞌma anini, hiami maꞌiasa deiꞌ nimaguf ifiꞌi. ");
INSERT INTO aoj_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Basef endilisifi atif God nagaꞌifa ipeꞌi ma amom profet, deiꞌ fape ma fagatopalopa ipaꞌ wapani. Fowaꞌ God nalaꞌ lapa basef banagafi ma bafasepa ipeꞌisi. Deiꞌ basef ifimba fape endilisi ma fagatopalopa ipaꞌ wapani. Fowaꞌ anen naꞌipa Abrahama anaf Jisas nogataga naꞌi, ‘Anaf owagama bafasena ineꞌisi aeꞌ egatopalopa esis misiꞌah amam nematawa hiasi hiꞌilasa sogape andeandeꞌ itap hiagoma.’ ");
INSERT INTO aoj_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Eaꞌ God a nandandepa anen nandaꞌ maol ananinii, nasapana naliꞌ nafiꞌmai ipaꞌ ma nofaloꞌmepa natopalopepa nandaꞌepa pambema nelelemb atona atina pagakwaha waf aunai ipeꞌinai.” ");
INSERT INTO aoj_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Pitai Jon ataꞌ maꞌi maloma esis amam nematawa atin, anom pris maloma kepten nugumafi ipat luꞌunai Godi maloma anom Sadyusi mafiꞌi. ");
INSERT INTO aoj_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Amom mogawa amom biam mawalapa basef maꞌipasa Jisas notanima nogosafel matmat wapani. Eaꞌ maꞌi esis hiasi sogagaꞌi atiasi sogosafel wapani. Amom dembami maꞌi basef ifimba amam biam magaꞌiefi ina endilisifi. Naꞌamba amom mandaiwaꞌ aꞌ mandaꞌ megahoham. ");
INSERT INTO aoj_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Eaꞌ deiꞌ amom mafiꞌi mombaloꞌ amom biam wambomota awin nandambema. Eaꞌ mandaꞌam mandaꞌ kalabus owamb ambamba masasa wafilu kuhimbita. ");
INSERT INTO aoj_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Esis amam nematawa hiasi sameꞌ basef ifimba Jisas nogosafel nowaga wapani sahapifana. Isimba atis deiꞌ esis sagahapifanai sataga hias, amom atom mataga felefeleꞌma 5 tausen (5,000). Apaꞌ ina siamba awasi nematawa, owaꞌ. ");
INSERT INTO aoj_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Nemaf fagagiꞌi amom dembami asasimi maloma agufumi maloma amom dembami magawalipasa muꞌuli Godi, aꞌ mandakolas Jerusalem. ");
INSERT INTO aoj_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Dembinai pris Anas, nape nagaliꞌma pris hiamii, naloma Kaiafas, a Jon, Aleksander eaꞌ anom daiam wapani wambota Anasi, mafiꞌi hiꞌalam mandakolas maloma amom dembami. ");
INSERT INTO aoj_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Eaꞌ amom amamba hiami mandaꞌ amom aposel biam malutu nogohnaep amamisi mahaliꞌam dindinip maꞌi, “Ipaꞌ pefaꞌ banagami mamahoma paꞌi agol maigila deiꞌ pandaꞌ hiahawes isimba? Kias!” ");
INSERT INTO aoj_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Eaꞌ Ambal buꞌunai Godi nape siꞌina Pita nowaꞌ banagona naꞌipam naꞌi, “Ipaꞌ Israel amam dembipai a ipaꞌ agufipai, ");
INSERT INTO aoj_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","ipaꞌ deiꞌ pahaliꞌ afaꞌ biafa ma wandaꞌ waf buꞌwafi wagatopalopa aman anamba boꞌwagah aogahinai. Ipaꞌ paꞌi pegawa anen nataga boꞌona naꞌimama. ");
INSERT INTO aoj_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Iꞌi aꞌ naꞌamba ma, daoꞌ. Ipaꞌ hipai aꞌ pendegawa, esis miniꞌap Israel hiasi wapani asondogawa, ma banagami agol Jisas Krais Nasaratinaii atogol deiꞌ alop aman anambai banagep amboꞌona nosafel nagalutu naep ipeꞌipi. Ipaꞌ pandola Jisas lawag usiꞌigai tiꞌwanaegai pahana afuna, apaꞌ deiꞌ God nasaꞌmana nosafili matmat wapani. ");
INSERT INTO aoj_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","“Basef ifimba fagail Buk Baibeli ma aman anamba faꞌi, ‘Otam amamba ipaꞌ pagalaꞌ ifagwi pandaiwaꞌmam pelefatam magaꞌihi, deiꞌ aꞌ mandambema mataga mape maliꞌ mowaꞌ banaga ipat atamba.’ ");
INSERT INTO aoj_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Ina anin epen daian laꞌifin niwambilapa mutanimai, owaꞌatin. Eaꞌ anen atona. Ama ganimba itap hiagoma, fowaꞌ deiꞌ wapani God ina nawalapa agola anona aman daiana ma notopalopapa nokwaha waf awafi nowambilapai ma mogape andeandeꞌ, owaꞌatin. Eaꞌ anen atona.” ");
INSERT INTO aoj_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Amom agufumi mati Pitai Jon malutu banagem maꞌi basef ifimba. Eaꞌ agufumi mogawa amom biam ina mandaꞌ skuli, owaꞌ. Amom lolaimi atom. Eaꞌ amom agufumi ukup pehafel kwapeteꞌ nomonas hiahawesa amom. Eaꞌ mogawa amom biam maꞌi fowaꞌ mape magaloma Jisasi. ");
INSERT INTO aoj_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Owaꞌ agufumi mati aman anamba boꞌwagah hondolaꞌanai nataga boꞌona, nalutu naloma Pitai Jon. Eaꞌ amom ina maꞌi anif basef magwamamef amom biam, owaꞌatin. ");
INSERT INTO aoj_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Eaꞌ maꞌipa amom biama mokwaha ipat atamba mandakolasatai aꞌ muwis andoꞌ. Amom biam magawis andoꞌi, amom maꞌi basef mandameꞌmaef maꞌi, ");
INSERT INTO aoj_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","“Afaꞌ atiasi ataꞌ ondaꞌ amam amamba biam wiꞌimama ma ogasopama malogofam. Deiꞌ main, amom mandaꞌ maol banagani siꞌi God nandaꞌani, eaꞌ epes hiasi sagape Jerusalami sogawam. Afaꞌ ina laꞌififa ma ombasoꞌmas ugaꞌi, ‘Amom ina mandaꞌ maol inimba’, owaꞌatin. ");
INSERT INTO aoj_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Afaꞌ aꞌ ondaꞌi basef banagafi ma amom biam ina ataꞌ miꞌipasa basef wapani anis daiasa agol agalemba, owaꞌ. Naꞌamba basef ifimba aꞌ fefeꞌagon hiꞌilagona esis amam nematawa hiasi.” ");
INSERT INTO aoj_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Eaꞌ agufumi motanima mofala amom biam mawisi wapani maꞌipam dindinip maꞌi, “Ipaꞌ bipa ina ataꞌ piꞌipasa basef ifimba kwasakwasala ma agol Jisasi, ina ataꞌ piwalipasa agol Jisasi ma anis amam nematawa, owaꞌi.” ");
INSERT INTO aoj_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Owaꞌ Pita naloma Jon magwa basef maꞌi, “Iꞌi afaꞌ okwaha basef Godi ma ogagiꞌma basef ipeꞌifi, naꞌambai andeandeꞌma naep Godi aꞌa owaꞌ? Ipaꞌ ataꞌ ukup pendandaꞌma isimba pegawas pewalogas. ");
INSERT INTO aoj_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Apaꞌ afaꞌ biafa ina aꞌ osopama malogof, owaꞌatin. Afaꞌ ogawalapa basef hiafi ma hiahawes watilis wagameꞌasi.” ");
INSERT INTO aoj_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","22","Eaꞌ agufumi mowatania anif basef banagafi maꞌipamef amom biama mogasopama malogof, eaꞌ makwahom mafeꞌ. Esis hiasi sasaꞌma agol Godi luꞌwagol ma hiahaom amamba sati amom biam mandaꞌami. Naꞌamba agufumi ina mati anif basef kofagefa ma mogasoꞌama akafimi amom, owaꞌatin. Aman anamba amom biam mandaꞌ maol banagani ma buꞌunai, aowas ananini natagamana nape atapin nogota lautai afagof 40-pelaiguf. ");
INSERT INTO aoj_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Agufumi Judai matagwaha amom biam motanima mafeꞌma esis sagahapifanai, eaꞌ maꞌipasa basef hiafi amom pris dembami maloma agufumi magaꞌipamafi. ");
INSERT INTO aoj_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Esis sameꞌef eaꞌ, hiasi aꞌ nembel atotombel sandabeten sasaꞌma agol Godi naꞌamba saꞌi, “Dembinai, inaꞌ nagahapila ilif itapi, inaꞌ aꞌ nandaꞌ itap otaga, a naoh a hiahaom amamba hiami magapaumi. ");
INSERT INTO aoj_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Fowaꞌ gani inaꞌ nandaꞌ akunamapa apeꞌinai Devit naꞌi basef. Anen nandaꞌ maol ineꞌini eaꞌ Ambal buꞌunai ineꞌinai nasaꞌmana nahaliꞌas naꞌi, ‘Deiꞌ maina esis owaꞌ Judaisia ukup wandafip aꞌowaꞌ? Deiꞌ maina esis miniꞌap epes ukup awep aꞌowaꞌ ma Dembinai? Owaꞌ owaꞌatin. Esis ina laꞌifis, owaꞌ. ");
INSERT INTO aoj_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Amom dembami king ganimba itap hiagoma mandandombol maloma amom agufumi mandatama mape atogon mandaꞌ wandafa mogatalogofa Dembinai God noloma Krais Dembinai nasapaꞌana nagafiꞌii. Owaꞌ, owaꞌatin, ina laꞌifim.’ ");
INSERT INTO aoj_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","“Herot naloma Pontius Pailat maloma anis epes ina Judaisi saloma esis Israel saila basef ifimba Deviti aꞌ sakolata wambel ambalemba atembela sogapaꞌaga Jisas aman anamba boꞌona hililiꞌi nandaꞌ maol ineꞌinii, fowaꞌ inaꞌ nandandepana eaꞌi. ");
INSERT INTO aoj_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Esis sandakolas atogona sondaꞌ hiahaom hiami siꞌi fowaꞌ inaꞌ banagena okom ineꞌimi maꞌi mogataga. ");
INSERT INTO aoj_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Dembinai, inaꞌ okom mondapoma basef hiafi wandafifi esis sagaꞌiefi, eaꞌ nendatopalopa afaꞌ wandaꞌ maola ineꞌi. Ama afaꞌ banagefa endilisi ogawalapa basef ineꞌifi, ma afaꞌ ina ombal mohafa, owaꞌatin. ");
INSERT INTO aoj_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Inaꞌ newamona lagof ineꞌigufi nihimbaꞌma esis inaꞌ banagonai ma negatopalopa esis awasisi sogataga boꞌwes wapani. Eaꞌ nendaꞌ hiahaom banagami mamimami ma agol Jisasi, anen boꞌona hililiꞌi nandaꞌmena maoli.” ");
INSERT INTO aoj_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Esis sandabetena eaꞌ, sameꞌ ipat atamba sandabetenatai bolalata. Eaꞌ Ambal buꞌunai Godi siꞌinama esis, eaꞌ sawalapa basef Godi banagambel, esis ina ombal mahasa amom agufumi esis Judai, owaꞌatin. ");
INSERT INTO aoj_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Epes hiasi sagahapifanai nembel atembel, eaꞌ nomonas atifis. Ina anin epen atitin nati anis hiahawes atitis ananisi naꞌi, “Hiahawes isimba aeꞌasi atis.” Owaꞌatin. Hiahawes hiasi asasisi, isimba esis hiasii atis. ");
INSERT INTO aoj_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Amom aposel mawalapa basef maꞌipasefa Jisas Dembinai apeꞌinai notanima nogosafel, eaꞌ basef amamifi banagef aꞌowaꞌ. Eaꞌ okom Godi nagatopalopa esis dowafi aꞌ luꞌuna aꞌowaꞌ ma epes isimba hiasi sagahapifanai. ");
INSERT INTO aoj_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Esis sandatopalopa atin. Naꞌamba ina anin epen atitin laꞌafena esis hiahawes gwaꞌaisi main akan, owaꞌatin. Esis hiasi kofagesa itapi ifagwi, esis sasoꞌasas anis daias satalis sasoꞌasa otamba. Eaꞌ sofaꞌai otamba ambamba safiꞌi, ");
INSERT INTO aoj_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","sasoꞌamamba amom aposel. Eaꞌ amom mandaꞌamba masoꞌ isimba gwaꞌaisi mais akasi. ");
INSERT INTO aoj_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Eaꞌ anona aman buꞌunai agol ananigili Josep amom aposel mandaꞌmana anagol agol Barnabas. Agol agalemba kofagogola naꞌamba, “Epen nogowaꞌ banaga ukup epesi.” Anen anona Livai, aman anamba anin ailan Saiprusinai. ");
INSERT INTO aoj_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Anen nasoꞌasa itap ananipi anis epes satalep sasoꞌana otamba nofaꞌamba nafiꞌi nasoꞌamamba amom aposel ma mogatopalopa anis gwaꞌaisi mais akasi. ");
INSERT INTO aoj_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Anona aman agilinama Ananaias, anen nape naloma wauluꞌmana ananiꞌwi Sapaira. Anen nasoꞌasa anep itap asasipi anis epes satalep. ");
INSERT INTO aoj_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Eaꞌ nofaꞌ otamba duꞌwanimba atemba nasoꞌamamba aposel, duꞌwanimba baꞌoma esis. Anen nambasoꞌma amom naꞌi otamba eaꞌ maꞌumba nasoꞌamamba siꞌimba. Wauluꞌmana wapani kogawa isimba. ");
INSERT INTO aoj_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Eaꞌ Pita naꞌipana naꞌi, “Ananaias, inaꞌ naꞌi ahoꞌma Satan nafiꞌi nawis nape siꞌina ma nembel ineꞌimbili ma deiꞌ nagambasoꞌma Ambal buꞌunai Godi nagambahoꞌ otamba duꞌwanimba ma itap apamba? ");
INSERT INTO aoj_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Fowaꞌ esis ataꞌ owaꞌ sotala itapa, nogota atamba ataꞌ itap ineꞌipi atep. Ama deiꞌ satalep eaꞌ, otamba ineꞌimbai nimafiamba. Deiꞌ maina inaꞌ okom mandandaꞌma waf afambai awafi ma nembel ineꞌimbili? Ina nambasoꞌma apaꞌ epes atepa, owaꞌ. Inaꞌ nambasoꞌma God.” ");
INSERT INTO aoj_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Ananaias nameꞌ basef ifimba, nowa itap aꞌ afuna. Eaꞌ esis sameꞌ basef ifimba ma nagagaꞌ, ombel mahas kwapeteꞌ aꞌowaꞌ. ");
INSERT INTO aoj_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Eaꞌ anom amam saꞌumi mafiꞌi mofaꞌ alop ananipi mowaꞌap lowaf mofaꞌana mafeꞌ mawana. ");
INSERT INTO aoj_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Ama nogota bandata kwasakwasala awa wanifin aꞌ nafeꞌma main, akoꞌw wauluꞌmana kwafiꞌi kwawisi. Akoꞌw ina kogawa hiahawes sagatagama anini, owaꞌ. ");
INSERT INTO aoj_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Eaꞌ Pita naꞌipaꞌw naꞌi, “Ipaꞌ pegefaꞌani moni eaꞌ inimba nandahama itap apamba eaꞌ maꞌwin, aꞌa owaꞌ?” Akoꞌw kwambasoꞌmana kwaꞌi, “Ahoꞌ! Maꞌwin inimba atin.” ");
INSERT INTO aoj_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Eaꞌ Pita naꞌipaꞌw naꞌi, “Deiꞌ maina ipaꞌ bipa paꞌi basef basoꞌafi pandameꞌmaefa pagagwamba Ambal buꞌunai Dembinaii? Nemeꞌ! Amam amamba ataꞌ mofaꞌ waulunamena ineꞌinai mafeꞌ mawana, amamba mafiꞌi malutu uta. Atiasi mofaꞌ inaꞌ wapani nigiꞌmana nefeꞌ!” ");
INSERT INTO aoj_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Eaꞌ kwafalis atis akoꞌw kowa itap felefeleꞌma boꞌwagah Pitai afuꞌw. Eaꞌ amom saꞌumi mawisi nomon mati akoꞌw afuꞌw, aꞌ mofaꞌakw mafeꞌ mawaꞌw felefeleꞌma waulunamaꞌw akwaꞌunai. ");
INSERT INTO aoj_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Eaꞌ esis Kristen hiasi saloma esis amam nematawa sagameꞌ basefa hiahaom amambai, aꞌ ombel mahas kwapeteꞌ! ");
INSERT INTO aoj_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Amom aposel mandaꞌ hiahaom banagami mamimami hiami laꞌafena esis amam nematawa. Eaꞌ epes isimba hiasi sogahapifanai hiꞌalas aꞌ nembel atembel sandakolas sape atogon ilaf ipat Solomoni felefeleꞌma ipat luꞌunai Godi. ");
INSERT INTO aoj_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Anis amam nematawa hiasi ombel mahas, eaꞌ ina safiꞌi sandakolas salomas, owaꞌ. Apaꞌ isimba sagape andoꞌi sasaꞌma agof esis Kristeni saꞌi esis epes buꞌwasi. ");
INSERT INTO aoj_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Eaꞌ anis amam nematawa hiasi sahapifa Dembinai, eaꞌ safiꞌi timbi tambel sawisa miniꞌap ananipi atapis sape. ");
INSERT INTO aoj_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Esis saloma anis daias wapani sati banagami amamba amom aposel mandaꞌami. Eaꞌ sofaꞌ awasisi safiꞌi sambeꞌas saꞌoh andoꞌ ufiawa, salas belitagw gwagwigwagwi sofaꞌas safiꞌi. Esis ukup paꞌi, iꞌi Pita ina nefeꞌma esisa, eaꞌ hapaimi. Andeandeꞌma owaf fendaꞌ ambal ananili atol lefeꞌ lumbisilaꞌas. ");
INSERT INTO aoj_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Eaꞌ esis amam nematawa hiasi walemb hielimbi bagape felefeleꞌma Jerusalami wapani safiꞌi sandakolas salomas. Esis sofaꞌai awasisi safiꞌi salumai epes isimba ambagof awami mapais magahambombagasi. Eaꞌ epes isimba hiasi sataga boꞌwes hiꞌalas wapani. ");
INSERT INTO aoj_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Eaꞌ pris dembinai nape nagaliꞌma pris hiamii naloma amom amamba hiami alipumi ananimi Sadyusi anep miniꞌap, amom kowalam aꞌowaꞌ ma maol buꞌwani amom aposel mandaꞌani. Deiꞌ main amom mati esis hiasi saila basef amamifi. ");
INSERT INTO aoj_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Isimba atis deiꞌ amom mosafel mombaloꞌ amom aposel masoꞌam kalabus luꞌwami. ");
INSERT INTO aoj_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Ama aꞌi owamb, owaꞌ anona ensel Dembinaii nafiꞌi nawisiꞌ uta luꞌutai indalelemba kalabus eaꞌ nafelai amom aposel mawisi andoꞌ naꞌi, ");
INSERT INTO aoj_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Ipaꞌ foꞌo pilutu ipat Godi luꞌunai nomon pewalapa basefa amam nematawa hiasi ma waf hiafi dambaifi ma ambal namili.” ");
INSERT INTO aoj_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Eaꞌ amom aposel mameꞌ basef ifimba, kuhimbita mafeꞌ ipat Godi luꞌunai maꞌipa esis amam nematawa. Pris anamba dembinai naloma amom alipumi ananimi mafiꞌi mofalai agufumi hiami Israeli mafiꞌi mandakolas atogon. Eaꞌ masapaꞌ basef fafeꞌ ipat sandaꞌ kalabusa, mofaꞌai amom aposel mugafiꞌi. ");
INSERT INTO aoj_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Eaꞌ amom plisman mafeꞌ ipat sandaꞌ kalabusa, owaꞌ ina mati amom aposel, owaꞌatin. Eaꞌ motanima mafeꞌ maꞌipa amom dembami maꞌi, ");
INSERT INTO aoj_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Afaꞌ wati uta ipat kalabusi sowalowata sisihita, eaꞌ amom plisman mugumafiatai malutu mumafi utagw hiagwi andeandeꞌ. Afaꞌ wawisiꞌ uta wawis nomon, apaꞌ afaꞌ ina wati anin epen atitin nape nomon, owaꞌatin.” ");
INSERT INTO aoj_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Eaꞌ kepten nugumafi ipat Godi naloma amom pris dembami memeꞌ basef ifimba eaꞌ nomonas salasafeꞌ hiahias maꞌi, “Maim amamba atiasi deiꞌ mogatagai?” ");
INSERT INTO aoj_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Amom mape nomonas salasafeꞌma isimba owaꞌ, anona aman nafiꞌi nataga naꞌipam naꞌi, “Pemeꞌ, amam amamba ipaꞌ pandaꞌam magape kalabusi deiꞌ malutu ipat Godi nomon maꞌipasa basef esis amam nematawa.” ");
INSERT INTO aoj_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Eaꞌ kepten naloma amom plisman mafeꞌ mufaꞌi amom aposel mafiꞌi. Apaꞌ amom ina maham, owaꞌatin. Amom ombel maham maꞌi, “Naꞌamba esis amam nematawa asokwaha otamba sohafa.” ");
INSERT INTO aoj_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Amom mofaꞌai amom aposel malutu nogohnaep amom dembami esis Judai laꞌafen. Eaꞌ pris anamba dembinai naꞌipam naꞌi, ");
INSERT INTO aoj_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Afaꞌ waꞌipipa basef banagafi waꞌi, ipaꞌ ina pewalapa basef piꞌipasef amam nematawa ma agol agalemba, owaꞌi. Apaꞌ owaꞌ, ipaꞌ pandaꞌ basef ifimba fape fafeꞌagon hiꞌalagon Jerusalem asiꞌigina basef ipeꞌifi. Eaꞌ paꞌi basef pasapagafa paꞌi kofagema afaꞌimi, afaꞌ waha aman anamba nagaꞌ.” ");
INSERT INTO aoj_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Owaꞌ Pita naloma amom aposel magwa basef maꞌipam maꞌi, “Afaꞌ ina ugiꞌma basef epesi, owaꞌ. Afaꞌ undagiꞌma basef Godi atif. ");
INSERT INTO aoj_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Ipaꞌ pandola Jisas lawag usiꞌigai tiꞌwanaegai eaꞌ pahana nagaꞌ. Owaꞌ, God anamba bafapapa apaꞌ Juda mandaꞌ lotumanai aꞌ nasaꞌmana nosafel wapani wandof. ");
INSERT INTO aoj_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Eaꞌ God nofaꞌana nalota ilif nahaponana nape lagol kwahisigili ananigili. Eaꞌ nape agilinai ma notopalopa apaꞌ Israel hiapai, nofaꞌapa mutanimai membema nelelemba opalefa nogakwaha waf awafi apeꞌifi okom mogosoꞌanaf. ");
INSERT INTO aoj_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Fowaꞌ deiꞌ wapani afaꞌ waloma Ambal buꞌunai Godi wagawalapa basefa hiahawes isimba hiasi afaꞌ watilis ogogawasi. God nasoꞌasa Ambal buꞌunai ananinai eaꞌ ma amam nematawa sagaila basef ananifii.” ");
INSERT INTO aoj_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Amom mameꞌ basef ifimba, aꞌ ukup wandafip kwapeteꞌ endilisi maꞌi moha amom aposel mogaꞌ. ");
INSERT INTO aoj_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Owaꞌ anona dembinai nalutu laꞌafena amom dembami esis Judai, anen Farisi agilinama Gameliel. Anen dembinai tisa ma muꞌuli Godi, eaꞌ esis amam nematawa saganifela agol ananigili. Naꞌipa amoma mogakwaha amom aposel mugawis andoꞌ kwasakwasala. ");
INSERT INTO aoj_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Eaꞌ naꞌipa amom dembami Juda naꞌi, “Ipaꞌ amam Israelipai, ipaꞌ iꞌi pendaꞌ anis maemaefaha amom amamba ma, ipaꞌ ataꞌ ukup pendandaꞌ andeandeꞌ piliꞌ. ");
INSERT INTO aoj_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Ipaꞌ pegawa eaꞌ nogota tatumba fowaꞌ, anona aman Teudas nosafel naꞌi, ‘Aeꞌ aman dembiwai, agiliwai.’ Eaꞌ amam hiami felefeleꞌ ma 400-pelaim mafeꞌ mailana. Owaꞌ anis epes sahana nagaꞌ, eaꞌ amam magahapifanai mafaꞌ mafeꞌ atona biana. Eaꞌ maol amamini aꞌ newala dowaf. ");
INSERT INTO aoj_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","“Aꞌi owaꞌ maina nogota atamba gavman nogofaꞌasa agof esis amam nematawa hiasii, anona Judas daiana Galilinai nosafel nambemefa ukup anis epes hiasi. Eaꞌ safeꞌ sailana safela wandaf sapaꞌ saloma gavman saꞌi siliꞌamonana. Owaꞌ sahana nagaꞌ wapani, eaꞌ epes isimba hiasi sagahapifanai safaꞌ safeꞌ atona biana hiꞌalas. ");
INSERT INTO aoj_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Naꞌamba deiꞌ aeꞌ aꞌipipa, ipaꞌ ombel mondahepama amam amamba, eaꞌ pekwahom mopano. Iꞌi amom mondaꞌ maola epes atisai, atiasi maol inimba awasin newala siꞌi maol amom biam dokoꞌ aliꞌ agaꞌipipami. ");
INSERT INTO aoj_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Apaꞌ iꞌi God atona nowaꞌ banaga amoma basef ifimba kofagefa ai, ipaꞌ ina daoꞌ atiasi laꞌifipama pegasopama amom, owaꞌatin. Naꞌamba ipaꞌ apepaꞌ peloma God!” ");
INSERT INTO aoj_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Eaꞌ amom dembami maila basef Gamelieli maꞌi, “Afaꞌ oham atin dowaf.” Eaꞌ mofala amom aposel mafiꞌi, maꞌipa amom plismana mogaham. Eaꞌ maꞌipam dindinip maꞌi, “Ipaꞌ ina ataꞌ piꞌi basef ifimba ma agol Jisasi wapani, owaꞌi.” Eaꞌ makwaha amom aꞌ mafeꞌ. ");
INSERT INTO aoj_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Eaꞌ amom aposel makwaha amom dembami Juda aꞌ mafeꞌ mawis andoꞌ. Mandagala God nati amom ila ma mogofaꞌ akafimi nimanimi ma agol Jisasi. ");
INSERT INTO aoj_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Amom ina makwaha maol inimba magawalipasa basef buꞌwafi ma Jisas anen Krais, God nandandepana nasapaꞌana nagafiꞌii, owaꞌatin. Nimaguf danda amom mandaꞌ maol mawalipa esis amam nematawa hiasi ipat Godi luꞌunai, ifagw asasigwi wapani. ");
INSERT INTO aoj_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Nogota atamba esis alipisi sagaila Jisasi sataga hias aꞌowaꞌ. Esis Juda hiasi apaꞌ anis sagaꞌi diga Griki safitap saloma anis Juda sagaꞌi diga Hibrui eaꞌ saꞌi, “Nimaguf hiafi ipaꞌ pagatopalopa esis amam nematawa isimba gwaꞌaisi main akasi, apaꞌ anowa nematawa alifiwai apeꞌiwai owaꞌ.” ");
INSERT INTO aoj_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Amom aposel 12-pelaim mati nimanimi amamba aꞌ mofalai esis alipisi isimba hiasi safiꞌi maꞌipas maꞌi, “Iꞌi afaꞌ okwaha maol inimba ogawalipasa basef Godi ma ogatambeꞌ gwaꞌaisi, naꞌambai ina andeandeꞌ, owaꞌatin. ");
INSERT INTO aoj_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Ipaꞌ Kristen alipipai, ipaꞌ ataꞌ pewandoꞌma anom amam 7-pelaim laꞌafena ipaꞌ magape andeandeꞌma naep esis amam nematawai, Ambal buꞌunai Godi nagape siꞌinami nomonas buꞌwasi sagapaumi. Ama afaꞌ ondaꞌam mopoma mugumafi maol inimba. ");
INSERT INTO aoj_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Apaꞌ afaꞌ opoma ondabeten atin a ogaꞌipasa basef Godi amam nematawa ogatopalopas.” ");
INSERT INTO aoj_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Amam nematawa hiasi ukup paꞌi basef ifimba. Eaꞌ sandandepa Stiven, anen nagahapifa Jisasi ma Ambal buꞌunai Godi nagape siꞌinanai. Eaꞌ sandandepa Filip naloma Prokoras, a Nikanon naloma Timon maloma Parmenas Nikolas. Aman anamba Nikolas Antiokinai, fowaꞌ nafiꞌi naila waf esis Judai. ");
INSERT INTO aoj_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Eaꞌ esis hiasi sandaꞌ amam amamba malutu felefeleꞌma nogohnaep amom aposeli mawamona lagofa amom mandaꞌmam betena mondaꞌ maol inimba. ");
INSERT INTO aoj_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Eaꞌ basef Godi fandasauliꞌ fafeꞌ. Amam nematawa hiasi sagape Jerusalami aꞌ sataga alipisi sahapifa Jisas. Owaꞌ pris amamba hiami wapani mahapifa Jisas mailana. ");
INSERT INTO aoj_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","God natopalopa Stiven nowaꞌ banagona, nandaꞌ banagami mamimami luꞌwami laꞌafena esis amam nematawa. ");
INSERT INTO aoj_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Eaꞌ anom amam mosafel maꞌi basef mandahihianamaef maloma Stiven. Amom anom amam Juda mandaꞌ anin lotu daiani, esis saꞌi ipat mandaꞌ lotuwatai agol naꞌamba. Amom fowaꞌ mandaꞌ maol mape sisihima anis daias apaꞌ deiꞌ mape wahifim. Amom walemb Sairini naloma Aleksandriai ma anep itap luꞌupa daiap Silisiai Esia. ");
INSERT INTO aoj_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Ambal buꞌunai Godi nasoꞌana gawa fasini Stiven. Eaꞌ amom ina laꞌifima miꞌi basef migikilaꞌana, owaꞌatin. ");
INSERT INTO aoj_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Eaꞌ mandaꞌ anef waf basoꞌaifi ma mogaha Stiven. Eaꞌ mofaꞌi anom amam maꞌi basef maꞌi, “Afaꞌ wameꞌ anen naꞌi basef nandaꞌ Moses findiwana naloma Goda basef amamifi.” ");
INSERT INTO aoj_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Eaꞌ amom masaꞌmai nelelemb esis amam nematawai saloma amom agufumi asasimi maloma amom dembami magawalipasa muꞌuli Godi. Eaꞌ esis safeꞌma Stiven sombaloꞌana sofaꞌana safeꞌma amom dembami Juda. ");
INSERT INTO aoj_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Eaꞌ sandaꞌ anom amam malutu ma mogasapagana anif basef basoꞌaifi. Amam amamba maꞌi, “Dondol lifilafi aman anamba nagaꞌi basef awafi ma ipat luꞌunai Godi apaꞌ mandaꞌ lotuma naloma muꞌuli fowaꞌ God nagaꞌipa Mosesani. ");
INSERT INTO aoj_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Apaꞌ mameꞌ anen naꞌi, ‘Aman anamba Jisas Nasaratinai atiasi nohambombaga ipat anamba apaꞌ mandaꞌ lotuma aꞌ nondaꞌ anef waf dambaifi fehaꞌofa waf hiafi fowaꞌ Moses nagaꞌipapaf apeꞌi.’” ");
INSERT INTO aoj_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Eaꞌ amom hiami mandakolasi hiꞌalam naep doꞌ matiti Stiven eaꞌ mati amaga ananigai aꞌ gogalaꞌ gataga siꞌi amaga anona enseli. ");
INSERT INTO aoj_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Eaꞌ pris dembinai nape nagaliꞌma pris hiamii nahaliꞌ Stiven naꞌi, “Basef ifimba endilisi aꞌa owaꞌ?” ");
INSERT INTO aoj_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Eaꞌ Stiven naꞌipam basef laufi naꞌi, “Ipaꞌ sahin owan, a ipaꞌ ahape, ipaꞌ pemeꞌ aeꞌ. Fowaꞌ bafamapa apeꞌinai Abraham nagape itap luꞌupa Mesopotamia ina deiꞌ aꞌ nafeꞌ wambel Haran, ama nogota atamba God Dembinai nogogalaꞌi aꞌ natagamana. ");
INSERT INTO aoj_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Eaꞌ God naꞌipana naꞌi, ‘Inaꞌ nekwaha wambel itap ineꞌisi peloma sahin owan ineꞌisi aꞌ nefeꞌ anagon lauguni nepe anep itap aeꞌ aꞌi igihimbaꞌmenap ineꞌi.’ ");
INSERT INTO aoj_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","“Eaꞌ deiꞌ Abraham nakwaha itap luꞌupa Kaldia aꞌ nafeꞌ nafeꞌ nataga nape wambel Haran. Ama main, ahamana ananinai nagaꞌ, eaꞌ God nasapaꞌana nafiꞌi nape itap apaꞌe deiꞌ apaꞌ magapaipi. ");
INSERT INTO aoj_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","God ina deiꞌ nasoꞌana itap apamba Abraham ma nogahapilap siꞌip, ataꞌ owaꞌatin. Itap apamba anep kwaiaꞌup wapani siꞌi apop kwasala mendeꞌ, owaꞌatin. Apaꞌ God naꞌi basef endilisi atifa anaf owagama, daoꞌ anen aꞌ nosoꞌana itap apamba anona nohapilap nogaloma esis bafasana ananisi anaf sigiꞌ sogatagai sogahapilap. Nogota atamba Abraham awani ataꞌ akana God nagaꞌipana basef ifimba. ");
INSERT INTO aoj_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Naꞌipana naꞌi, ‘Miniꞌap awasi ineꞌisi anaf sope itap esis miniꞌap anis epes daiasi. Eaꞌ miniꞌap epes isimba anis daiasi anaf sondaꞌ miniꞌap awasi ineꞌisi sondaꞌ maol numaꞌuni agof akas sope lafela esis eaꞌ sondaꞌas kwapeteꞌas sope sofeꞌ sotaga nogota lautai afagof 400-pelaiguf. ");
INSERT INTO aoj_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Apaꞌ anaf owagama aeꞌ egwamasa waf awafi esis. Ama anaf wapani esis miniꞌap awasi ineꞌisi sogakwaha itap apamba sufiꞌi sope sondaꞌ lotuma aeꞌ itap apaꞌe.’” ");
INSERT INTO aoj_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","“Eaꞌ God naꞌi Abraham atiasi notopaꞌ alopa nogaila basef banagafi God naliꞌ nalaꞌ lap nagalomana afi. Ama main, Abraham nameꞌ basef ifimba nailif natopaꞌ alop ananipi anola Aisak nogamana ananinai ma nimaguf 8-pelaif falaꞌana, aꞌ natopaꞌmana alop ananipi wapani. Ama main, Aisak nataga ahama Jekopi, eaꞌ Jekop aꞌ ahama bafapapa amamba 12-pelaim. ");
INSERT INTO aoj_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Amom bafapapa 11-pelaim kowalama owamam Josep. Naꞌamba maliꞌamonana anop nomop daias satalona ma agol akana nondaꞌ maol nogape lafela esis. Eaꞌ sofaꞌana safeꞌ itap luꞌupa Isip. Apaꞌ owaꞌ God nape nalomana. ");
INSERT INTO aoj_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Anen natopalopana natalogofa nimanimi hiami ananimi nape wahifina. Ama nemaf afamba anen naꞌi basef nagaloma dembinai king Isipinai Fero, God nasoꞌana gawa fasini naꞌi basef nalomana ma nandaꞌ king Fero okom magailana. Eaꞌ deiꞌ king anamba nandaꞌana nataga nape dembinai gavmana itap apamba Isip eaꞌ numafi hiahaom hiami ma ipat anen kingi. ");
INSERT INTO aoj_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","“Aꞌi owaꞌ main, nolom luꞌunai nataga itap apamba Isip anamba hiagoma nafeꞌagon hiꞌalagon nafeꞌ nataga itap luꞌupa Kainan wapani, eaꞌ esis satagama nimanimi luꞌwami. Eaꞌ esis bafasapa apeꞌisi sagape Kenani ina ataꞌ sofaꞌ anis gwaꞌaisi, owaꞌatin. ");
INSERT INTO aoj_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Owaꞌ Jekop Josep ahamana aꞌ nameꞌ basef saꞌi gwaꞌaisi saꞌoh itap apamba Isip. Eaꞌ nasapaꞌ amom bafapapa apeꞌimi maliꞌ mafeꞌ dambadamba. ");
INSERT INTO aoj_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Ama main, magiꞌ motanima mafeꞌma bif, eaꞌ Josep naꞌipa amom sahopana naꞌamba naꞌi, ‘Aeꞌ Josep.’ Eaꞌ deiꞌ king aꞌ nogawa amom wambota Josepi mafiꞌi. ");
INSERT INTO aoj_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","“Eaꞌ Josep nasapaꞌ basef fafeꞌ nofalai ahamana Jekop nokwaha Kainan nigiꞌmana nogafiꞌi Isip, noloma esis wambota ananisi hiasi sataga 75-pelais. ");
INSERT INTO aoj_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Naꞌamba Jekop niliana itap apamba Isip naloma bafapapa apeꞌimi ma main, amom aꞌ magaꞌ. ");
INSERT INTO aoj_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Amom magaꞌ eaꞌ, sofaꞌam sotanima safeꞌ wambel Sekem sawam matmat atamba fowaꞌ Abraham nowasaꞌ otamba nagatalagoma ma awasi Hemoi. ");
INSERT INTO aoj_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Nemaf afamba God naꞌi endilisi ma nondaꞌ hiahawes isimba. Fowaꞌ anen nagaꞌipa Ebrahama anen atiasi nondaꞌasi, nogota atamba felefeleꞌ deiꞌ tataga. Eaꞌ esis miniꞌap apeꞌipi Israel asataga luꞌwis eaꞌ amam nematawa aꞌ hias aꞌowaꞌ sape itap hiagoma Isip. ");
INSERT INTO aoj_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Eaꞌ anona aman dambainai nataga dembinai king, apaꞌ anen ina nogawa naꞌi fowaꞌ Josep nagape dembinai ma Isip, owaꞌ. ");
INSERT INTO aoj_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","King anamba nambasoꞌmas nandaꞌmasa waf a maol numaꞌuni ma miniꞌap esis apeꞌisi. Anen nandaꞌ waf awafi ma esis bafasapa apeꞌisi, anen aꞌ banagona endilisi naꞌi esis sokwaha awasi asasisi sope andoꞌ ma aꞌ afis. ");
INSERT INTO aoj_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Nogota atamba Moses maꞌmana kolana. Anen awani fasinai aꞌowaꞌ. Eaꞌ mamasana sumafiana andeandeꞌ ipat asasitai ma aomb wanemb. ");
INSERT INTO aoj_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Ama main, sofaꞌana safeꞌ sambahoꞌwana naꞌoh alop andoꞌ. Owaꞌ dembinai king Fero nogamana kwafiꞌi kwatolona kofaꞌana kwalagana siꞌi nogamaꞌw akwaꞌunai siꞌina. ");
INSERT INTO aoj_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Eaꞌ Moses nandaꞌ skul nalafa gawa hiani esis Isipi eaꞌ anen aꞌ aman dembinai nandaꞌ maol banagani nagaꞌi banagafi ma semeꞌef sagagiꞌmif. ");
INSERT INTO aoj_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Moses aꞌi owaꞌ nape ma dambena ma afagof 40-pelaiguf eaꞌ, aꞌ okom mandandaꞌma esis wambota ananisi Israel eaꞌ nafeꞌ natilis. ");
INSERT INTO aoj_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Nati anona Isipinai nahambombaga anona Israelinai aꞌowaꞌ. Eaꞌ Moses natopalopa Israelinai naha aman anamba Isipinai afuna. ");
INSERT INTO aoj_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Eaꞌ anen nomonas sandandaꞌ saꞌi, epes aeꞌasi atiasi siꞌi naꞌamba siꞌi, ‘God aꞌ natopalopa apaꞌ ma lagof Mosesi ma notagwahepa mugape wahifipa.’ Owaꞌ owaꞌatin. Esis ukup ina pandandaꞌ naꞌamba, owaꞌ. ");
INSERT INTO aoj_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","“Aꞌi owaꞌ wafilu, Moses notanima nafeꞌ natilis wapani owaꞌ nati anom biam amom atom Israel mapaꞌ wapani. Eaꞌ naꞌi nohagofa amom biam nohapeꞌam eaꞌ naꞌipam naꞌi, ‘Ipaꞌ atipa sahomana owamana pendaꞌas naꞌamba, owaꞌi. Deiꞌ maina ipaꞌ pagahambombaga ipaꞌ atipa?’ ");
INSERT INTO aoj_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","“Owaꞌ, aman anamba naliꞌ nagahambombaga anini nambasiꞌ Moses naꞌipana naꞌi, ‘Ami naꞌipina ma negape dembinai ma negawaloga afaꞌ? ");
INSERT INTO aoj_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Aꞌi inaꞌ naꞌi nehe siꞌi nambatiꞌ nagaha aman anamba Isipinai nagagaꞌ?’ ");
INSERT INTO aoj_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Anen naꞌias naꞌamba owaꞌ, Moses ombel mahana nafaꞌ nafeꞌ. Nafeꞌ nape anep itap luꞌupa Midian laogoma. Ama main, nasoꞌ nemataꞌw nola awasi bias. ");
INSERT INTO aoj_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Ama afagof 40-pelaiguf fafeꞌma hiꞌalagof, owaꞌ anona ensel Dembinaii natagamana itap wafigima epes akagoma felefeleꞌma halaf Sainai. Ensel nape nomona nif ileliwa fandom magatagai anoga lawag saꞌugai. ");
INSERT INTO aoj_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Eaꞌ Moses natolom aꞌ nomonas hiahawes sandandaꞌma amamba magataga ma anini. Eaꞌ nafeꞌ felefeleꞌma nagatolom andeandeꞌ, owaꞌ Dembinai naꞌipana naꞌi, ");
INSERT INTO aoj_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Aeꞌ God amom bafapena ineꞌimi mandaꞌ lotumai. Aeꞌ God Abrahami Aisak Jekop fowaꞌ mandaꞌ lotumai.’ Eaꞌ Moses bolalana ombel mahana ma nogatologon. ");
INSERT INTO aoj_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","“Eaꞌ Dembinai naꞌipana naꞌi, ‘Tagwaha su magape boꞌwagah ineꞌigahii. Itap apaꞌe inaꞌ deiꞌ nagalutuma itap aeꞌapi hililiꞌi. ");
INSERT INTO aoj_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Aeꞌ ati esis miniꞌap amam nematawa aeꞌasi sagameꞌ akafimi luꞌwami itap apamba Isip. Aeꞌ ameꞌ lef asasinai eaꞌ, deiꞌ aꞌ isilaꞌi ma etopalopasa egelefata nimanimi amamba asasimi. Naꞌamba deiꞌ inaꞌ eaꞌ safel. Aeꞌ aꞌi esapaꞌena netanima nefeꞌ Isip.’ ");
INSERT INTO aoj_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“Moses aman anamba fowaꞌ sosambalona sagaꞌi, ‘Ami naꞌi inaꞌ nepe dembinai ma negawalogapa?’ Deiꞌ aman anamba atona God nasapaꞌana nafeꞌ siꞌi dembinai ma nugumafias nowambilasi nofaꞌas sogotanimai. God nowaꞌ banagona ma anamba ensel natagamana nalomana nagaꞌi ma lawag agamba saꞌugai. ");
INSERT INTO aoj_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Moses eaꞌ naoꞌwas safeꞌ sakwaha Isip, nandaꞌ maol naninani banagani siꞌi God nandaꞌani ma itap luꞌupa Isip a naoh embel akwahimi eaꞌ anamba itap wafigima epes akagoma, ma afagof agwafomba 40-pelaiguf. ");
INSERT INTO aoj_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Moses aman anamba maꞌuna anen naꞌipa esis Israel nagaꞌi, ‘Atiasi owagama God nosapaꞌ anona sahomepa ipeꞌinai nondaꞌana nope profet siꞌi Aeꞌ.’ ");
INSERT INTO aoj_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Ama aꞌi owaꞌ, esis Israel safeꞌ sandakolas anamba wafigima fataupigima Moses aman anamba atona nape nagaloma esisi. Anen nape naloma bafapapa apeꞌimi wapani. Anona ensel nape naloma Moses nasoꞌana basef Godi halafuta atamba Sainai eaꞌ Moses nasoꞌapa basef ifimba ambal namilifi apaꞌ. ");
INSERT INTO aoj_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Apaꞌ bafasapa apeꞌisi sandaiwaꞌma sogameꞌ basef ananifi, owaꞌ. Esis sosambalona eaꞌ sandaꞌagama anamba fowaꞌ sagapanima Isip ukup paipailagon. ");
INSERT INTO aoj_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Eaꞌ saꞌipa aman anamba Eran saꞌi, ‘Aman anamba Moses nofaꞌapai Isip magafiꞌii, apaꞌ ina mogawana nafeꞌ nasa natawa ani? Eaꞌ inaꞌ daꞌmapa anona god basoꞌamunai apeꞌinai ma anen nope nogaloma apaꞌ.’ ");
INSERT INTO aoj_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Nemaf afamba esis sandaꞌ anona bulmakau eaꞌ sondolalima god anamba basoꞌamunai. Eaꞌ sandagala ma god anamba sandaꞌana lagof asasigufi atugufi. ");
INSERT INTO aoj_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Eaꞌ dembinai God nasoꞌasa alafuga esis nakwaha esisa sondaꞌ lotu sogafela agofa awin owambini alipini neloma ondowa siꞌi basef fagape buk profeti fagail buk Baibeli faꞌias fagaꞌi, ‘Ipaꞌ epes Israel, ipaꞌ paha bulmakau maloma sipsip pendalali ma aeꞌ pagape anamba wafigima epes akagoma afagof 40-pelaiguf, aꞌa? Owaꞌatin! ");
INSERT INTO aoj_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Ipaꞌ pefaꞌ ipat selitai pandaꞌ lotuma Molokatai, eaꞌ pefaꞌata taloma ametal siꞌi ondoꞌw god basoꞌamunai Refani, ambagof awami amamba hiami ipaꞌ pandaꞌama pandaꞌ lotumami. Naꞌamba atiasi aeꞌ aꞌ iliꞌamonepa pefeꞌ pepe lauguni peloma wambel Babilon gani waꞌol.’ ");
INSERT INTO aoj_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“Fowaꞌ bafasapa apeꞌisi sape anamba wafigima epes akagoma, nogota atamba sowalo sel siꞌi ipat sandaꞌ lotu. Ipat atamba tihimbaꞌmapa atamba God nagapautai. Ipat atamba God nagaꞌipasa basef ananifima. Esis sandaꞌ ipat lotu inimba sel nandahama ikwaf afamba God nigihimbaꞌmanaf Mosesi. God naꞌipana ma nondaꞌaf eaꞌ naꞌamba atin. ");
INSERT INTO aoj_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Ama main, amom bafapapa apeꞌimi mafiꞌi maloma Josua ma mogofaꞌ itap esis anis epes miniꞌap daiapi. Eaꞌ God naliꞌamona esisa nogohnaep esis bafasapa apeꞌisi. Ama nemaf afamba sofaꞌai ipat atamba selitai, eaꞌ sandaꞌata totawa naꞌa atapita tape nafiꞌi nafiꞌi nogota Devit nagape dembinai king. ");
INSERT INTO aoj_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Devit nandaꞌ waf buꞌwafi ma God natopalopana nogowaꞌ banagona. Eaꞌ nandabetena Goda anen naꞌi nogalaꞌ anota ipat buꞌutai ma God anamba fowaꞌ Jekop nandaꞌ lotumanai. ");
INSERT INTO aoj_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Apaꞌ owaꞌ, nogamana Solomon nandaꞌ ipat anamba luꞌunai Godi nalaꞌana. ");
INSERT INTO aoj_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Owaꞌ owa atin. God dembinai endilisinai, ina nagape ifagw agwamba epes sagalaꞌagw lagof asasigufii, owaꞌatin. Basef ifimba fagail Buk Baibeli siꞌi anona profet nagaꞌif, ");
INSERT INTO aoj_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","“Dembinai nagaꞌi naꞌamba naꞌi, “Heven siꞌi sia aeꞌ agapaini a itap apaꞌe aeꞌ ahaponai boꞌwagah hagatomama. Ipat mamahotama atiasi ipaꞌ pelaꞌmeata aeꞌ? Owaꞌatin. Atiasi aeꞌ epoma nomaꞌw anima? Owaꞌatin. ");
INSERT INTO aoj_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Lagof aeꞌagufi atogof andaꞌ hiahaom amamba hiami hiꞌalam,’ ");
INSERT INTO aoj_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","“Ipaꞌ epes pandaꞌ duꞌwanigai. Ipaꞌ epes pegelelama basef Godi siꞌi anis daias owaꞌ sogogawa Godia. Ipaꞌ pandaiwaꞌ ma pegameꞌ basef Godi ma nelelembi aligah ipeꞌisi. Dondol ipaꞌ pegesambala Ambal buꞌunai Godi. Ipaꞌ pandaꞌam naꞌamba atin siꞌi fowaꞌ aꞌmesepa ipeꞌisi sandaꞌam. ");
INSERT INTO aoj_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Amom profet hiami fowaꞌ magapani esis akusipa ipeꞌisi sandaꞌ waf awafima amom hiami hiꞌalam saham sandaꞌam aom. Saha amom profet magaꞌipasa aman buꞌunai hililiꞌi anaf nogafiꞌii. Eaꞌ deiꞌ ipaꞌ pawalapana ma amom boumi mahana nagaꞌ eaꞌ. ");
INSERT INTO aoj_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Fowaꞌ God naseꞌepa muꞌuli ananini ipaꞌ. Eaꞌ amom ensel atom maꞌipipa muꞌuli inimba, apaꞌ owaꞌ ipaꞌ ina pemeꞌan pagiꞌman, owaꞌatin.” ");
INSERT INTO aoj_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Amom mameꞌ basef ifimba faha nelelemb amamilimbi endilisi aꞌowaꞌ. Amom nalelef finditapa imunam dogw ukup wandafum endilisi ma Stiven. ");
INSERT INTO aoj_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Apaꞌ Ambal buꞌunai Godi nape siꞌinama anen, naniga nati heven naep doꞌ endilisi. Nati banagami mogogalaꞌi Godi eaꞌ nati Jisas nalutu waꞌol lagol kwahisigili Godi. ");
INSERT INTO aoj_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Eaꞌ Stiven naꞌipam naꞌi, “Pemeꞌ! Aeꞌ ati heven aꞌ nandawisiꞌ eaꞌ Dembinai nataga epen nogofaꞌ alop epesi nalutu waꞌol lagol kwahisigili Godi.” ");
INSERT INTO aoj_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Eaꞌ amom gigal maꞌoh mehip aꞌowaꞌ, masopama aligah amamigahi mandaiwaꞌma mogameꞌ basef ifimba. Eaꞌ mosafel masagih mafeꞌ atef mombaloꞌ Stiven. ");
INSERT INTO aoj_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Eaꞌ maliꞌamonana nakwaha wambel nawis nalutu wambel andoꞌ. Amom dokoꞌ maliꞌ magasapaganama basefi mowalia siaogw amamugwi mambeꞌagw gwaꞌoh felefeleꞌma anona aman saꞌunai nagalutuma agilinama Sol. Mowaliagw gwaꞌoha mokwaha otamba mehip mogaha Stiven. ");
INSERT INTO aoj_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Makwaha otamba mahana atin owaꞌ, nandabeten naꞌamba naꞌi, “O Dembinai Jisas, inaꞌ faꞌago ambal aeꞌali!” ");
INSERT INTO aoj_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Eaꞌ nindiwa nembawa notawa naꞌi mehip naꞌi, “O Dembinai, inaꞌ owaꞌi negwamama waf anamba aunai amoma, owaꞌi.” Stiven naꞌias naꞌamba, aꞌ nagaꞌ. ");
INSERT INTO aoj_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Eaꞌ Sol nomonas atifis naloma amom magaha Stiven nagagaꞌi. Nogota atamba esis amam nematawa sandaiwaꞌma esis Kristen sagape Jerusalami, sahas sasoꞌas akafimi nimanimi luꞌwami. Eaꞌ isimba atis deiꞌ esis sagahapifanai asafaꞌ safeꞌagon hiꞌalagon atona biana ma anamba itap luꞌupa Judiai Samaria. Apaꞌ amom aposel atom ataꞌ mapani atapim Jerusalem. ");
INSERT INTO aoj_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Anom amam magaila waf Godi andeandeꞌi mofaꞌ Stiven mawana, mandaꞌ lef luꞌwani ma anen. ");
INSERT INTO aoj_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Apaꞌ Sol nandaꞌ maol naꞌi nohambombaga esis Kristen. Anen nafeꞌ nawis ifagw hiagwi atona atin nofaꞌai amam nematawa hiasi sagahapifanai. Eaꞌ nahondoꞌas nofaꞌas nafeꞌ nandaꞌas sandaꞌ kalabus. ");
INSERT INTO aoj_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Esis Kristen safaꞌ safeꞌagon hiꞌalagon walemb hielimbi analemb daindaialemb sawalapa basef buꞌwafi Godi saꞌipasef. ");
INSERT INTO aoj_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Eaꞌ Filip nowala nafeꞌ anambel wambel itap luꞌupa Samaria nawalipasa basef buꞌwafi naꞌi Jisas anen Krais, God nandandepana nasapaꞌana nagafiꞌii. ");
INSERT INTO aoj_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Amam nematawa hiasi sameꞌ basefa anen asati banagami anen nandaꞌami eaꞌ sagahembeꞌ andeandeꞌma basef ananifi. ");
INSERT INTO aoj_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Banagami amamba naꞌamba. Amam nematawa hiasi ambagof awami magapaisi, ambagof amamba mandaꞌam wiwa maꞌoh kwapeteꞌ endilisi aꞌ makwaha esis mawisi mafaꞌ mafeꞌ. Eaꞌ epes isimba lagof boꞌwagah awamisi, anis isimba bihitagof fofowagalamasi, esis hiasi asataga boꞌwes wapani. ");
INSERT INTO aoj_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Eaꞌ deiꞌ esis wambel ambalemba sofaꞌ dagala luꞌwani. ");
INSERT INTO aoj_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Eaꞌ anona aman nape agilinama Saimon. Aman anamba fowaꞌ nandaꞌ naohi ufiali nape atapina nafiꞌi nataga deiꞌ nemaf afamba. Eaꞌ nandaꞌ ukup esis amam nematawa Samariaisi a malamafeꞌ hiahiam aꞌowaꞌ. Aman anamba naꞌias naꞌi, “Aeꞌ aman dembiwai.” ");
INSERT INTO aoj_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Eaꞌ esis amam nematawa hiasi agof akasi a agufisi, esis hiasi hiꞌalas sandahembeꞌma naꞌamba atina sagameꞌ basef Saimoni. Saꞌias saꞌi, “Aman anamba anen nofaꞌ banagami amamba dembinai Godi sofalam sagaꞌi banagami luꞌwamii.” ");
INSERT INTO aoj_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Eaꞌ esis banagesa sagameꞌ basef ananifi. Deiꞌ main, nimaguf hiafi anen nandaꞌ waf fafifafi hiafi banagafi koꞌop ufial eaꞌ satelef aꞌ nomonas salasafeꞌ hiahias. ");
INSERT INTO aoj_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Eaꞌ Filip nawalipasa basef buꞌwafi esis hiasi. Nawalipasa agol Jisas Kraisi ma sogawis nomona maol Godi nope Dembinai nugumafias. Eaꞌ sahapifa basef ifimba sofaꞌ baptais. ");
INSERT INTO aoj_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Eaꞌ aman anamba Saimon wapani nahapifa Jisas aꞌ nofaꞌ baptais nape naloma Filip. Anen nati Filip nandaꞌ ametal banagonai naninani siꞌi God nandaꞌani, eaꞌ aꞌ okom hiahaom mapaona. ");
INSERT INTO aoj_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Amom aposel magape Jerusalami mameꞌ basefa esis Samaria asofaꞌ basef Godi. Naꞌamba masapaꞌ Pitai Jon mafeꞌma esis. ");
INSERT INTO aoj_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Amom biam miliana mandabetena Goda nogatopalopa esisa sogofaꞌ Ambal buꞌunai Godi. ");
INSERT INTO aoj_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Deiꞌ main, Ambal Godi ina deiꞌ nawisa esis, ataꞌ owaꞌatin. Esis sofaꞌ baptais atisa agol Jisasi atogol. ");
INSERT INTO aoj_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Eaꞌ amom biam mawamona lagofa esis eaꞌ sofaꞌ Ambal buꞌunai Godi. ");
INSERT INTO aoj_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Eaꞌ Saimon nati amom aposel biam mawamona lagof atogofa esis sofaꞌ Ambal Godi. Naꞌamba anen nofaꞌ moni ananini nafiꞌmai amom naꞌipam naꞌi, ");
INSERT INTO aoj_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","“Ipaꞌ bipa peseꞌe banagami amamba aeꞌ wapani ma aeꞌ iꞌi egawamona lagofa anin epena, negefaꞌ Ambal buꞌunai Godi.” ");
INSERT INTO aoj_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Owaꞌ Pita naꞌipana naꞌi, “Hiahaom fasimi God nagasoꞌasam dowaf siꞌi preseni, amamba inaꞌ okom mandandaꞌ naꞌi ilama negatalom otamba ineꞌimbai? Owaꞌatin. Aeꞌ aꞌi otamba ineꞌimbai beloma inaꞌ pefeꞌ wambel awambili hel. ");
INSERT INTO aoj_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Inaꞌ owaꞌ boꞌwenama nigawisa maol inimba Godi afaꞌ wandaꞌania, owaꞌatin endilisi! Deiꞌ main, okom ineꞌinai ina usiꞌinama naep Godi, owaꞌatin. ");
INSERT INTO aoj_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Inaꞌ newaꞌ alafugama waf afamba awafi ineꞌifi nembema nembel nefeꞌma God. Eaꞌ nendabetena Dembinai ma nokwaha kofagema amamba ma okom ineꞌimi magapoma waf awafii. ");
INSERT INTO aoj_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Deiꞌ main, aeꞌ ati inaꞌ kowalena aꞌowaꞌ ma presen hiahaom fasimi God nagasoꞌapami. Eaꞌ nembel ineꞌimbili awambela isimba, waf afamba awafi afewaꞌena atapif nape siꞌi kalabus.” ");
INSERT INTO aoj_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Eaꞌ Saimon nagwa basef naꞌi, “Ipaꞌ bipa pendabetena Dembinai ma anen nogatopalopa aeꞌ. Ama hiahaom amamba ipaꞌ pagaꞌiami ina aꞌ motagame, owa!” ");
INSERT INTO aoj_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Eaꞌ amom biam maꞌipasa basef Dembinai Jisas Kraisi esis amam nematawa. Ama main, motanima mondowasaꞌ Jerusalem. Magafeꞌ ufiaꞌw, mawalapa basef buꞌwafi Godi walemb hielimbi esis Samaria. ");
INSERT INTO aoj_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Eaꞌ anona ensel Dembinaii naꞌipa Filip naꞌi, “Inaꞌ nendendombola negafeꞌ gani waꞌol awin natopaꞌ negembaꞌma, ma ufiaꞌw kwaꞌwaha Jerusalem kwiliana kwagafeꞌ Gasama. Ufiaꞌw akwamba fowaꞌ esis sagafeꞌakwi. Deiꞌ aꞌ owaꞌ. Ufiaꞌw akwamba kwape anamba wafigima fataupigima.” ");
INSERT INTO aoj_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Eaꞌ Filip nosafel aꞌ nafeꞌ. Eaꞌ natagama anona aman Itiopiainai ufiaꞌw akwamba. Anen aman dembinai nugumafi otamba hiambai ma kwin akwamba dembeꞌwi gavman kugumafi esis walemb hiagoma Itiopiai, sofalaꞌw sagaꞌi Kandesi. Aman anamba nimbewaꞌ nafiꞌi Jerusalema nandaꞌ lotu, ");
INSERT INTO aoj_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","deiꞌ naꞌi notanima nefeꞌ. Anen natoma karis ananimi siꞌi wilkar eaꞌ natoma nati basef fagail buk Baibeli fowaꞌ profet Aisaia nandaꞌafi aꞌ nafeꞌ. ");
INSERT INTO aoj_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Eaꞌ Ambal buꞌunai Godi naꞌipa Filip naꞌi, “Inaꞌ foꞌo felefeleꞌma aman anamba nefeꞌ neloma wilkar nanimba.” ");
INSERT INTO aoj_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Eaꞌ Filip nasagih nafeꞌ felefeleꞌma anen, aꞌ nameꞌ aman anamba natalifa basef ifimba Aisaia nandaꞌafi. Eaꞌ Filip nahaliꞌana naꞌi, “Inaꞌ negawa basef ifimba kofagefa deiꞌ natalifif nagafiꞌii, aꞌa owaꞌ?” ");
INSERT INTO aoj_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Eaꞌ aman anamba nagwa basef naꞌi, “Iꞌi anin epen owaꞌ nihimbaꞌmefa, deiꞌ egawa basef ifimba iꞌimama?” Eaꞌ naꞌipa Filip naꞌi, “Inaꞌ lotai netoma neloma aeꞌ.” ");
INSERT INTO aoj_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Basef ifimba duꞌwanif Godi anen nagatalififi fagaꞌiasa Jisas faꞌi, “Esis saoꞌwana nafeꞌ siꞌi sipsip ama saꞌi sohana nogagaꞌ. Anen siꞌi sipsip noganai esis sahapilana sagatopaꞌmana auf ananimi, anen ina nandaꞌam feꞌ atin naꞌoh, owaꞌatin. Eaꞌ naꞌamba atina aman anamba, ina malogol gagalana, owaꞌatin. ");
INSERT INTO aoj_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Esis sapaꞌagana endilisi eaꞌ ina sandaꞌmana kota basef usiꞌifi, owaꞌ. Anen awasi akana ma anis sitilis soganifa basefas. Deiꞌ main, sahana nagaꞌ sagia ambal ananili ma ina ataꞌ nope itap wapani, aꞌowaꞌ.” ");
INSERT INTO aoj_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Eaꞌ aman anamba dembinai nugumafi maola kwini naꞌipa Filip naꞌi, “Aeꞌ aꞌi ihaliꞌina. Profet anamba naꞌi ami ma deiꞌ nandaꞌ basef ifimba? Naꞌifa anen atona aꞌa naꞌifa anin epen daian?” ");
INSERT INTO aoj_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Eaꞌ Filip naꞌi basef nawalapefa aman anamba. Nasumbai basef ifimba duꞌwanif Godi aman anamba nagaꞌiefi fafeꞌ fafeꞌ eaꞌ nawalapai basef buꞌwafi Jisasi. ");
INSERT INTO aoj_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Amom biam maꞌi mafeꞌ owaꞌ, matagama anemb walemb. Eaꞌ aman anamba naꞌipa Filip naꞌi, “Niti walemb ambamba betah. Deiꞌ ataꞌ main nape niliꞌama aeꞌ egefaꞌ baptais?” ");
INSERT INTO aoj_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Eaꞌ Filip naꞌi, “Iꞌi inaꞌ nihapifana endilisi ma nembel ineꞌimbili, inaꞌ daoꞌ ila.” Eaꞌ nagwamana basef naꞌi, “Aeꞌ ahapifa Jisas Krais anen nogamana Godi.” ");
INSERT INTO aoj_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Eaꞌ naꞌias a main, wilkar negetawai, Filip naloma aman anamba dembinai misilaꞌ mafeꞌ mowala walemb. Eaꞌ Filip napisiꞌana. ");
INSERT INTO aoj_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Eaꞌ amom biam makwaha walemb mandagiai wataꞌita, kwafalis atis Ambal buꞌunai Dembinaii nofaꞌ Filip aꞌ nafeꞌ. Eaꞌ aman anamba dembinai ina ataꞌ natolona wapani, aꞌowaꞌ, dolomana. Eaꞌ anen sonahana nandagala naila ufiaꞌw ananiꞌwi nafeꞌ. ");
INSERT INTO aoj_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Apaꞌ Filip nafeꞌ nataga Asdot. Anen nafeꞌ taun anamba hiagoma ganigani nawalapa basef buꞌwafi Jisasi. Ama main, notanima nafeꞌ nataga wambel Sisaria. ");
INSERT INTO aoj_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Fowaꞌ basef ifimba ataꞌ owaꞌ fetagaea, nogota atamba Sol nandaꞌam naꞌamba. Anen naꞌias banagambel aꞌowaꞌ ma nogahambombaga esis alipisi sagaila Dembinaii nohas sogagaꞌ. Eaꞌ nafeꞌma pris dembinai nape nagaliꞌma pris hiamii. ");
INSERT INTO aoj_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","Naꞌipana eaꞌ pris anamba nandaꞌ basefa pas safeꞌma agufumi hiami mugumafi ifagw esis Juda sandakolasugwi wambel Damaskusi. Eaꞌ nasoꞌana pasa basef ifimba Sol. Fagaꞌias naꞌamba faꞌi, “Iꞌi Sol nogati anis amam nematawa sigaila ufiaꞌw akwamba dambaiꞌwi sogape Damaskusi, nondaꞌ kalabusimas nihapilas nofaꞌas sifiꞌi Jerusalem.” ");
INSERT INTO aoj_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Eaꞌ Sol nafeꞌ nataga felefeleꞌma Damaskus owaꞌ, kwafalis atis anom mogogalaꞌi mafiꞌi misilaꞌi heven aꞌ mogalaꞌma anen aꞌowaꞌ. ");
INSERT INTO aoj_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Eaꞌ nowai nafeꞌ naꞌoh itap eaꞌ nameꞌ anagol malogol gaꞌipana gaꞌi, “Sol, Sol, deiꞌ maina inaꞌ nandaꞌ maola nagahambombaga aeꞌ?” ");
INSERT INTO aoj_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Eaꞌ Sol nahaliꞌana naꞌi, “Dembinai, inaꞌ ami?” Eaꞌ malagol agalemba gaꞌi, “Aeꞌ Jisas inaꞌ nandaꞌ maol nagahambombagai. ");
INSERT INTO aoj_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Deiꞌ inaꞌ safel aꞌ nefeꞌ niwis wambel luꞌwambili. Bola anona aman niꞌipina hiahawes inaꞌ atiasi nendaꞌasi.” ");
INSERT INTO aoj_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Eaꞌ amom mafeꞌ magaloma Soli mameꞌ malogol agalemba apaꞌ ina laꞌifima mogaꞌi anif basef, owaꞌ. Tol malutu dowaf. Mameꞌ malogol gagaꞌi, apaꞌ ina mati anin epen, owaꞌatin. ");
INSERT INTO aoj_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Eaꞌ Sol nosafel naꞌi niti, owaꞌ owaꞌatin. Nati akot atona. Eaꞌ amom mahapila lagof ananigufi mofaꞌana mafeꞌ mawis Damaskus. ");
INSERT INTO aoj_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Anen nati akot atona nape nimaguf wanif eaꞌ ina naꞌ waliꞌita o embel mais, owaꞌatin. ");
INSERT INTO aoj_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Eaꞌ anona alipunai nagaila Jisasi nape naꞌamba Damaskus, agilinama Ananaias. Eaꞌ naꞌoh nandondoꞌah, nati Dembinai nofalana naꞌipana naꞌi, “Ananaias!” Eaꞌ anan noga naꞌi, “Dembinai, aeꞌ ape naꞌa.” ");
INSERT INTO aoj_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Eaꞌ Dembinai naꞌipana naꞌi, “Inaꞌ safel foꞌo ufiaꞌw akwamba sagaꞌi usiꞌiꞌwi. Nefeꞌ ipat Judasi a niti anona aman Tarsusinai, agilinama Sol. Deiꞌ nape nandabeten. ");
INSERT INTO aoj_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Sol naꞌoh nandondoꞌah aꞌ nati anona aman agilinama Ananaias atiasi nifiꞌi nuwisi nowamona lagofa anona nondaꞌ naep pigati andeandeꞌ wapani.” ");
INSERT INTO aoj_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Eaꞌ Ananaias nagwa basef naꞌi, “Dembinai, aeꞌ ameꞌ basef hiafi ma aman anamba, waf awafi hiafi anen nandaꞌafa esis amam nematawa ineꞌisi gani Jerusalem. ");
INSERT INTO aoj_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Anen nofaꞌ agol banagagili eaꞌ ma amom pris dembami ma nogombaloꞌ amam nematawa sandabetena agol ineꞌigilii wambel ambaleꞌe ma nondaꞌ kalabusimas.” ");
INSERT INTO aoj_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Owaꞌ Dembinai naꞌipana nasapaꞌana naꞌi, “Inaꞌ foꞌo. Aman anamba atiasi nondaꞌ maol aeꞌani. Aeꞌ andandepana eaꞌ ma nefeꞌ nigaꞌipasa basefa agol aeꞌagili anis amam nematawa owaꞌ Judaisia soloma amom dembami king asasimi moloma esis Israel wapani. ");
INSERT INTO aoj_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Atiasi aeꞌ ihimbaꞌmana akafimi mamimami hiami moloma nimanimi ma nogawalapa agol aeꞌagili. Naꞌamba inaꞌ deiꞌ foꞌo netelona.” ");
INSERT INTO aoj_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Eaꞌ Ananaias nafeꞌ nawis ipat nomon nasa lagofa Sol naꞌi, “Sahome Sol, Dembinai Jisas natagamena ufiaꞌw nogota atamba inaꞌ nagafiꞌi naꞌaꞌe. Deiꞌ nasapaꞌe afiꞌmai inaꞌ aꞌ nigati andeandeꞌ wapani ma Ambal buꞌunai Godi nogape siꞌinama inaꞌ.” ");
INSERT INTO aoj_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Eaꞌ hiahaom mape magasopama naep Soli siꞌi dunduwif agufumi, aꞌ mandafi kwafalis atis makwaha naep Soli mowa. Eaꞌ naep ananipi pati wapani, nosafel nofaꞌ baptais. ");
INSERT INTO aoj_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Ama main, naꞌ gwaꞌaisi banagona wapani. Sol nape anif nimaguf naloma amom alipumi magaila Jisasi Damaskus. ");
INSERT INTO aoj_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Eaꞌ nafeꞌ kwafalis ifagw hiagwi esis Juda sandakolasugwi nawalapa basef Jisasi naꞌi, “Jisas anen nogamana Godi.” ");
INSERT INTO aoj_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Epes hiasi sameꞌ basef ananifi eaꞌ sosafel gogolalasis kwapeteꞌ saꞌi, “Aman anamba nagahambombaga amam nematawa sogofala agol agalembai ma wambel Jerusalem. Eaꞌ deiꞌ nafiꞌi naꞌa ma nogowaꞌ esis nondaꞌ kalabusimas nofaꞌas sogafeꞌma amom pris dembami. Eaꞌ maꞌuna aman anamba atona.” ");
INSERT INTO aoj_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Apaꞌ banagami Soli aꞌ mataga banagem aꞌowaꞌ ma basef nagawalipasafi. Eaꞌ esis Juda sagape Damaskusi sameꞌ basefa anen. Esis ina laꞌifisa sogwa anif basef sigaꞌipanaef, owaꞌatin. Anen banagona nihimbaꞌmas endilisi naꞌi, “Jisas anen Krais, God nandandepana nasapaꞌana nagafiꞌii.” ");
INSERT INTO aoj_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Nimaguf hiafi fafeꞌma eaꞌ, amom Juda mandanif eaꞌ maꞌi basef mandameꞌmaefa moha Sol nogagaꞌ. ");
INSERT INTO aoj_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Apaꞌ Sol nameꞌ basef ifimba amamifi. Eaꞌ amom Juda hiami mape mumafi utagw hiagwi ma taun inimba owamb alip wapani ma maꞌi moha Sol nogagaꞌ. ");
INSERT INTO aoj_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Owaꞌ amom alipumi Soli mofaꞌana owamb mafeꞌ malota indalelemb otamba. Eaꞌ malana nape anona folaf luꞌunai, mapana mandelef malana nisilaꞌ indalelemb andoꞌ. ");
INSERT INTO aoj_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Ama main, Sol nafeꞌ Jerusalem eaꞌ naꞌi nondakolas nogaloma esis alipisi sagaila Jisasi. Apaꞌ owaꞌ, esis hiasi ombel mahasana. Eaꞌ esis ina sagahapifana saꞌi anen alipunai nagaila Jisasi, ataꞌ owaꞌ. ");
INSERT INTO aoj_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Aꞌi owaꞌ, Barnabas naoꞌwana mafeꞌma amom aposel owaꞌ naꞌipama Sol nagati Dembinai ufiaꞌw ma Dembinai nagasoꞌana basef anen. Eaꞌ Barnabas naꞌipam naꞌi anen nawalapa basef naꞌipasefa agol Jisasi banagambel Damaskus, deiꞌ anen ina ataꞌ ombel mahana, owaꞌ. ");
INSERT INTO aoj_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Eaꞌ deiꞌ asogawa anen wambota atota Jisasi nalomas nape laꞌafena esis. Anen nandaꞌ maol banagambel, nafeꞌ Jerusalem anamba hiagoma nawalapa basefa agol dembinaii. Anen ina ombel mahana, owaꞌatin. ");
INSERT INTO aoj_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Nandaꞌ maol naꞌipasa basef naloma amom Juda mogagawa diga Griki eaꞌ naꞌi basef napaꞌ nalomam. Apaꞌ amom mandaiwaꞌma basef ananifi molaoma ufiaꞌwa mohana nogagaꞌ. ");
INSERT INTO aoj_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Ama amom Kristen sahin owan mogawa isimba, eaꞌ mofaꞌ Sol mafeꞌ miliana Sisaria. Eaꞌ masapaꞌana nafeꞌ nape wambel Tarsus. ");
INSERT INTO aoj_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Deiꞌ esis amam nematawa Kristen sagape anamba itap apamba luꞌupa hiagoma Judiai Galili a Samaria sape opalef awanelef sape andeandeꞌ wandaf mais aꞌ owaꞌatin eaꞌ esis Kristen sape banages. Esis sape lafela Dembinai eaꞌ Ambal buꞌunai Godi nowaꞌ banaga opalef asasilifi. Eaꞌ esis miniꞌap Kristen apataga loup. ");
INSERT INTO aoj_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Pita nafeꞌ walemb anamba hiagoma eaꞌ niliana nafeꞌ taun inimba Lida wapani nape naloma esis amam nematawa Godi sagape wambel ambalembai. ");
INSERT INTO aoj_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Eaꞌ nati anona aman Inas. Alop bihitagof ananisi aꞌ sagaꞌana, tol naꞌoh nala alahis atis nape nogota laota afagof 8-pelaiguf. ");
INSERT INTO aoj_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Eaꞌ Pita naꞌipana naꞌi, “Inas, deiꞌ Jisas Krais aꞌ nandaꞌena boꞌwena wapani. Inaꞌ safel nendondomba alahis ineꞌisi andeandeꞌ.” Pita naꞌipana eaꞌ deiꞌ atef nosafel. ");
INSERT INTO aoj_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Eaꞌ epes hiasi walemb ambalemba bialemb Lidai Saron satolona sambema nelelemb safeꞌma Dembinai. ");
INSERT INTO aoj_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Anembel wambel Jopa anoꞌw nemataꞌw kwagaila Jisasi kwape, agol akwaꞌugili Tabita. Diga esis Griki sofalaꞌw saꞌi Dokas agol anin mafini saꞌi dia. Dondol lifilafi akoꞌw kwandaꞌ waf buꞌwafi ma kwagatopalopa esis amam nematawa kwahusi ma gwaꞌaisi mais. ");
INSERT INTO aoj_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Nemaf afamba awasiꞌw aꞌ kwagaꞌ. Eaꞌ sasaꞌopa alop akwaꞌupi ma sogawaꞌw. Eaꞌ sofaꞌakw sambeꞌakw kwaꞌoh rum ilifami. ");
INSERT INTO aoj_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Wambel Lida nape felefeleꞌ ma Jopa. Eaꞌ esis alipisi sagaila Jisasi sameꞌ basefa Pita nape Lida, sasapaꞌ amam biam mafeꞌma anen mahaliꞌana naꞌamba maꞌi, “Inaꞌ nifiꞌmai afaꞌ. Nigaꞌi otaꞌ otaꞌ owaꞌ.” ");
INSERT INTO aoj_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Eaꞌ Pita nosafel nafeꞌ nalomam, eaꞌ mafeꞌ mataga mofaꞌana mafeꞌ rum amamba ilif akoꞌw kwagaꞌoma. Nematawa hiawai alifiwai wafiꞌi walutu felefeleꞌma Pita wape walef. Eaꞌ wihimbaꞌmana klos sagegw maim akoꞌw Dokas kwandaꞌmasami dokoꞌ ataꞌ kwape kwagalomawa. ");
INSERT INTO aoj_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Eaꞌ Pita nagaloꞌma esis amam nematawa sawisi andoꞌ, nindiwa nembawa notawa nandabeten. Eaꞌ nambema amaga ananigai gafeꞌma alop nemataꞌwi naꞌi, “Tabita, inaꞌ safel.” Eaꞌ akoꞌw naep pati kwati Pita, akosafel kwape. ");
INSERT INTO aoj_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Eaꞌ Pita nahapila lagol akwaꞌugili nasaꞌmaꞌw kwalutu. Eaꞌ nofalai esis amam nematawa sagahapifa Godi saloma nematawa awamba alifiwai, nasoꞌawa akoꞌw kotanima kwafeꞌmawa. ");
INSERT INTO aoj_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Basef ifimba fafeꞌ anamba hiagoma wambel Jopa eaꞌ esis amam nematawa hiasi sameꞌef sahapifa Dembinai. ");
INSERT INTO aoj_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Pita nape wambel ambalemba Jopa nimaguf hiafi. Anen nape naloma anona aman nagandondomba agwafih bulmakaumi agol ananigili Saimon. ");
INSERT INTO aoj_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Anona aman nagape Sisariai agilinama Konilias, anen agilinai kepten nugumafi soldia 100-pelaimi. Amom miniꞌap soldia amamba sagaꞌi agol soldia Italimi. ");
INSERT INTO aoj_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Anen aman nandaꞌ lotuwi naloma hiasi ananisi sagape ipat atotai sandaꞌ lotu ma God. Anen nagasoꞌas moni mais hiasi ma nagatopalopa esis Juda isimba kwahusi otamba mais akasi. Eaꞌ dondol nandabetena God. ");
INSERT INTO aoj_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Anef nemaf wambomota awin nendembaꞌa 3 klok, anen nati anom maefah siꞌi naꞌoh nandondoꞌah aꞌ mataga alihim aꞌowaꞌ. Nati anona ensel Godi nafiꞌmai anen naꞌipana naꞌi, “Konilias.” ");
INSERT INTO aoj_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Eaꞌ Konilias natolona, aꞌ ombel mahana aꞌowaꞌ naꞌi, “Dembinai, inaꞌ naꞌi main?” Eaꞌ ensel naꞌipana naꞌi, “God aꞌ nameꞌ beten ineꞌini eaꞌ, okom maꞌi waf inaꞌ nandaꞌafa nagasoꞌas moni mais nagatopalopa amam nematawa hiahawes akasi. Eaꞌ God ataꞌ okom mapomas atin sape. ");
INSERT INTO aoj_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Deiꞌ inaꞌ nesapaꞌ anom amam mofoꞌo Jopa mowandoꞌma anona aman agilinama Saimon agol waꞌagol Pita. Mofalana nifiꞌi. ");
INSERT INTO aoj_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Aman anamba nape ipat anona Saimoni, anen nagandondomba agwafih bulmakaumi. Ipat ananitai totawa felefeleꞌma naoh gwafeꞌ gogotambela.” ");
INSERT INTO aoj_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Ensel naꞌipa Konilias eaꞌ, aꞌ nafeꞌ. Eaꞌ Konilias nofalai amam biam ananimi mandaꞌmana maoli maloma anona soldia. Soldia anamba nandaꞌ lotu dondoli nape nandaꞌ maola Koniliasi. ");
INSERT INTO aoj_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Eaꞌ Konilias naꞌipa amam amamba wanom andeandeꞌma basef ifimba hiꞌalef, eaꞌ nasapaꞌam mafeꞌ wambel ambalemba Jopa. ");
INSERT INTO aoj_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Eaꞌ amom wanom mosafel mafeꞌ maꞌoh ufiaꞌw. Ama lala mosafel mafeꞌ mataga felefeleꞌma Jopa. Nogota atamba awin nandasapaꞌ Pita aꞌ nalota natoma ipat andoꞌ ilifa nondabeten. ");
INSERT INTO aoj_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Eaꞌ nolomahana naꞌi neaꞌ gwaꞌaisi, apaꞌ esis ataꞌ sandaꞌas atin, eaꞌ anom maefah matagamana siꞌi koh dondoꞌah. ");
INSERT INTO aoj_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Nati otaga ilif aꞌ nandawisiꞌ eaꞌ anona maena siꞌi lowaf luꞌunai endilisi nisilaꞌi ilif nowalai. Anom maefah mahapila daꞌmalififa biafigin biafigin malana nisilaꞌi. ");
INSERT INTO aoj_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Hiahaom magala lowaf anamba nomoni, mafis hiahaom hiami, amiguf hiagof haogof fagail alupi, faloma uguf mamimami hiami. ");
INSERT INTO aoj_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Eaꞌ anagol malogol gaꞌipa Pita gaꞌi, “Pita, inaꞌ safel neha mafis neaꞌam.” ");
INSERT INTO aoj_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Owaꞌ Pita naꞌipana naꞌi, “Dembinai, aeꞌ owaꞌi endilisi. Aeꞌ ina eaꞌ anis mafis apaꞌ Juda magaꞌi awasisi, owaꞌ.” ");
INSERT INTO aoj_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Eaꞌ malogol agalemba gaꞌipana wapani gaꞌi, “Hiahaom God nagaꞌi buꞌwami, amamba ina niꞌi awami, owaꞌi.” ");
INSERT INTO aoj_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Amamba matagamana wanif naꞌamba, ma main, kwafalis aꞌ motanima malota otaga heven wapani. ");
INSERT INTO aoj_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Eaꞌ Pita okom malamafeꞌma hiahawes isimba naꞌi, “Koh dondoꞌah inimba aeꞌ agatulumi kofagema mamahoma?” Anen okom mandandaꞌ naꞌamba atapina nape owaꞌ, amam amamba Konilias nasapaꞌam magafiꞌii aꞌ mataga mahaliꞌasa ipat Saimon nagapautai. Eaꞌ mogawata, mafiꞌi malutu utaitama. ");
INSERT INTO aoj_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Eaꞌ mofalana maꞌi, “Saimon agol waꞌagol Pita, anen nape naꞌa aꞌa owaꞌ?” ");
INSERT INTO aoj_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Pita ataꞌ nape okom mandandaꞌma hiahawes isimba owaꞌ, Ambal buꞌunai Godi naꞌipana naꞌi, “Nemeꞌ! Amam amamba wanom maꞌi molaoma inaꞌ. ");
INSERT INTO aoj_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Inaꞌ safel nisilaꞌ eaꞌ nefeꞌ nelomom. Inaꞌ owaꞌi okom mope hiahaoma, owaꞌ. Deiꞌ main, aeꞌ atowe asapaꞌam mafiꞌi.” ");
INSERT INTO aoj_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Eaꞌ Pita nisilaꞌma amom amamba naꞌipam naꞌi, “Aman anamba ipaꞌ paꞌi pigalaomanai aeꞌ eaꞌ maꞌuwi. Ipaꞌ pafiꞌmai main?” ");
INSERT INTO aoj_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Eaꞌ maꞌipana maꞌi, “Konilias anen kepten dembinai nugumafi soldia 100-pelaim hiamii, nasapaꞌafa wafiꞌi. Anen nagape hililiꞌi nandaꞌ lotuma Godi. Esis Juda hiasi sagaꞌi, ‘Anen aman buꞌunai.’ Anona ensel Godi naꞌipana ma nofalena negafeꞌ ipat ananitai, ma ataꞌ nogameꞌ anif basef ineꞌifi.” ");
INSERT INTO aoj_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Eaꞌ Pita naꞌipam aꞌ mawis ipat nomon, naoꞌwam numafiam mape owamb ambamba. Wafilu nosafel aꞌ nafeꞌ nalomam. Anom amam Kristen Jopaimi mafeꞌ malomana. ");
INSERT INTO aoj_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Amom mosafel mafeꞌ maꞌoh owamb atotomb ufiaꞌw, eaꞌ mafeꞌ mataga Sisaria. Eaꞌ Konilias nape nasasa amom. Anen naliꞌ nofalai esis wambota atis ananisi saloma alipisi ananisi endilisi sunduwaꞌanima sape. ");
INSERT INTO aoj_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Eaꞌ Pita nafiꞌi naꞌi aꞌ nuwisi ipat owaꞌ, Konilias nafiꞌi natagamana nindiwa nembawa felefeleꞌma boꞌwagah Pitai nandaꞌ lotu nasaꞌma agol ananigili. ");
INSERT INTO aoj_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Owaꞌ Pita nasaꞌmana naꞌipana naꞌi, “Inaꞌ safel. Aeꞌ wapani epen atowe siꞌi inaꞌ.” ");
INSERT INTO aoj_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Eaꞌ Pita naloma Konilias maꞌi, aꞌ mawis ipat nomon, nati amam nematawa hiasi sandakolas sape. ");
INSERT INTO aoj_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Eaꞌ Pita naꞌipas naꞌi, “Ipaꞌ pegawa eaꞌ muꞌuli apaꞌ Judai maꞌi owaꞌatin endilisi ma apaꞌ mefeꞌ mugawis ifagw aꞌa mope mogaloma anis epes daias owaꞌ Judaisia, owaꞌ. Apaꞌ God aꞌ nihimbaꞌme ma anis epes owaꞌ Judaisia siꞌi ipaꞌ naꞌa naꞌipi naꞌi, ‘Ina nendafaꞌma anin epen niꞌi anin nandaꞌ waf awafii, owaꞌi.’ ");
INSERT INTO aoj_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Eaꞌ aeꞌ ina esambala basef ifimba God nagaꞌipiefi, owaꞌ. Eaꞌ ameꞌ fala ipeꞌini afiꞌi. Deiꞌ aꞌi ihaliꞌipa, “Ipaꞌ pefale afiꞌi ma main?” ");
INSERT INTO aoj_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Eaꞌ Konilias nagwamana naꞌi, “Hiahawes sagatagama aeꞌi ma deiꞌ nimaguf aꞌ wanif fafeꞌ eaꞌ, isimba naꞌamba. Aeꞌ ape andabeten ipat aeꞌatai, nogota awin newala nagape owambuguma 3 klok. Nogota eaꞌ naꞌamba atin siꞌi deiꞌ. Andabeten ape owaꞌ, ati anona aman nalutu felefeleꞌma amaga aeꞌagai, luwaguf maim ananimi aꞌ mombal mataga magalaꞌ aꞌowaꞌ. ");
INSERT INTO aoj_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Eaꞌ nofale naꞌi, ‘Konilias, God nameꞌ beten ineꞌini eaꞌ, okom mapoma hiahawes hiasi ineꞌisi nasoꞌasas nagatopalopa esis isimba hiahawes akasi. ");
INSERT INTO aoj_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Eaꞌ inaꞌ nesapaꞌ anom amam mofeꞌ Jopa mofalai Saimon agol waꞌagol Pita. Aman anamba nape naloma anona Saimon ipat ananitai, nagandondomba agwafih bulmakaumi. Anen nape felefeleꞌma naoh gwafeꞌ gogotambela.’ ");
INSERT INTO aoj_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Eaꞌ deiꞌ aeꞌ kwafalis asapaꞌ anom amam mafeꞌmago inaꞌ eaꞌ deiꞌ inaꞌ nandaꞌ waf fasifi aꞌ nafiꞌi. Deiꞌ apaꞌ hiapai mafiꞌi mape naꞌa ma naep Godi ma mogameꞌ basef hiafi Dembinai nagaseꞌenaef ineꞌi ma nigaꞌipapaef.” ");
INSERT INTO aoj_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Eaꞌ Pita naꞌias naꞌi, “Endilisi atis, deiꞌ aeꞌ egawa okom Godi anen ina okom maꞌi wambota miniꞌap esis Judai atis, owaꞌatin. ");
INSERT INTO aoj_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Anen okom maimaila epes mamahisa sandaꞌ lotuma anini sandaꞌ waf fasifii. ");
INSERT INTO aoj_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Ipaꞌ aꞌ pegawa basef ifimba God naꞌif fagafeꞌma apaꞌ miniꞌap Israeli. Anen nawalapa basef buꞌwafi Jisas Kraisi, anen Dembinai ma epes hiasii nandaꞌapa mataga nembel atifimbil maloma God opalef fepe saꞌumbel fegalomana. ");
INSERT INTO aoj_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Ipaꞌ aꞌ pegawa, fowaꞌ Jon nawalapa basefa esis sogombema opalefa waf awafi ma sogofaꞌ baptais, nogota atamba basef fafeꞌ itap luꞌupa Galili eaꞌ fataga anamba walemb hielimbi agol Judia. ");
INSERT INTO aoj_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Basef ifimba, basef Jisas Nasaratinai. God aꞌ nandandepana naꞌamba. Anen nasoꞌana Ambal buꞌunai Godi naloma banagami luꞌwami. Eaꞌ nafeꞌ walemb hiagoma ganigani natopalopa esis amam nematawa. Eaꞌ deiꞌ God nape nalomana nandaꞌ epes hiasi Satan nagahambombagasi amboꞌwes wapani. ");
INSERT INTO aoj_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","“Eaꞌ aeꞌ afiꞌi aloma amom wanom afaꞌ wagawalapa basefa hiahaom amamba banagami anen nandaꞌam gani Jerusalemi naloma analemb walemb daialemb hielimbi apaꞌ Juda magapoma. Eaꞌ esis sandolona lawag sahana nagaꞌ ma waf afamba. ");
INSERT INTO aoj_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Ama nimaguf bif hiꞌalef eaꞌ fagafeꞌma wanifi God nasaꞌmana nosafel wapani nawalapana alihina. ");
INSERT INTO aoj_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","God ina nihimbaꞌmasana Juda hiasi hiꞌalas satolona, owaꞌ. Nihimbaꞌma afaꞌ atofa fowaꞌ God nandandepafa ma ogawalapa basef ananifii. Anen notanima nosafel matmat wapani eaꞌ waꞌ gwaꞌaisi walomana. ");
INSERT INTO aoj_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Anen naꞌipafa dindinipa ugaꞌipa esis amam nematawa ogawalapa basef alihif naꞌamba. God nandandepa aman anamba eaꞌ ma anaf nogape aman nondaꞌmasa kota epes isimba sagape namisi soloma isimba sagagaꞌ eaꞌi. ");
INSERT INTO aoj_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Amom profet hiami maꞌiasa anen naꞌamba maꞌi, ‘Banagami ma agol ananigili atogol God nakwaha waf awafi esis amam nematawa hiasi sagahapifanai.’” ");
INSERT INTO aoj_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Pita ataꞌ naꞌi basef ifimba atin owaꞌ, Ambal buꞌunai Godi nisilaꞌi ma amam nematawa hiasi sagameꞌ basef Godi nawisas. ");
INSERT INTO aoj_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Amam amamba Judaimi magahapifi mafiꞌi magalumai Pitai mosafel gogolalasom kwapeteꞌ ma mati God nagasoꞌas Ambal buꞌunai ananinai dowaf siꞌi presena esis amam nematawa owaꞌ Judaisia wapani. ");
INSERT INTO aoj_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Amom Juda mameꞌ esis saꞌi anoga diga naninani sasaꞌma agol Godi eaꞌ amom gogolalasom kwapeteꞌ. Eaꞌ Pita naꞌi, ");
INSERT INTO aoj_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Ina anin epen laꞌifina nindaiwaꞌma sogapisiꞌ amam nematawa isimba embel, owaꞌatin. Esis aꞌ sofaꞌ Ambal buꞌunai Godi naꞌamba atin siꞌi apaꞌ.” ");
INSERT INTO aoj_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Eaꞌ naꞌipa esis dindinip naꞌi, “Ipaꞌ pefaꞌ baptaisa agol Jisas Kraisi.” Eaꞌ saꞌipana saꞌi, “Inaꞌ ataꞌ nepe nelomapa anif nimaguf wapani.” ");
INSERT INTO aoj_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Eaꞌ amom aposel maloma esis sahin owan sagahapifanai sagape anamba Judia hiagomai sameꞌ basef ifimba ma anis amam nematawa owaꞌ Judaisia wapani sofaꞌ basef Godi sagahapilif. ");
INSERT INTO aoj_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Eaꞌ Pita notanima nondowasaꞌ Jerusalem, owaꞌ anis epes Juda sagahapifa basef Godi sape. Esis sahapila waf fowaꞌifi dindinip saꞌi esis hiasi sagahapifanai sondagiꞌma muꞌuli esis Judai ma mogatopaꞌ alop amamipi. Eaꞌ sololaꞌagomana dindinipa basef ananifi ");
INSERT INTO aoj_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","saꞌipana saꞌi, “Inaꞌ aꞌ nafeꞌ nawis ifagw amam amamba owaꞌ Juda mogatopaꞌ alopia naꞌ gwaꞌaisi nalomam.” ");
INSERT INTO aoj_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Owaꞌ Pita naꞌipasa basef laufi ma hiahawes hiasi sagatagai. Naliꞌ naꞌipasa basef dambadamba fagaliꞌi nailif nafeꞌ nafeꞌ nambif. Eaꞌ na