﻿USE sofia;
DROP TABLE IF EXISTS sofia.aoi_vpl;
CREATE TABLE aoi_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES aoi_vpl WRITE;
INSERT INTO aoi_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Adinu...ba-wiya arakburakba-kiya-wiya nakine-ka Neningikarrawara ni-ngekburakama amurndakenena angalya arrawa iya amurndakangaba angalya karrawara. Umba adinuba-wiya n-aburradadangu-wiya nakina, ni-ngekburaka-manja enena angalya, ");
INSERT INTO aoi_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","akini-yada ngawa akungwa-wiye-ka nuw-ambilyuma. Akina akungwa na-wurumbijuwamurra umba nara ebina akwala yakwujina kuw-ambilya. Nara ambaka ebina ariba umba akungwa-wiya yimbukwa akina nuw-ambilyuma akwa na-larrumur•dinume-ka akina ngawa. Wuburra laka numu-ngwurrumur•dinama mibina medirra alyarrngwalyilya arrawa, ne-yamama akina. Umba ngalaja amawurrina Neningikarrawara-langwa na-lyikbinuma akina karrawara-langwiya akungwa-manja-da. ");
INSERT INTO aoi_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Eneja nakina Neningikarrawara ni-yengbinuma arakba ayakwa. “Aki-larradiya,” ni-yama nakina. Ngalaja kembirra alarradada na-jadinga arakba akina-da. ");
INSERT INTO aoi_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Biya nakina Neningikarrawara n-andeya akena ni-rringka akina alarradada akwulyubene-ka. Biya kembirra n-eyebijebaka arakba nakina alakina-kiya alarradada akwa ngawa alarrumur•da. ");
INSERT INTO aoi_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Biya kembirra nakina ni-yengbija alarradada “Meningilida” umba ngalaja alarrumur•da “Alyarrngwalyilya”. Biya na-lyarrngwalyilyada arakba akina. Bi...ya meningadinuba-wiya marringa numi-jerrida arakba makina-da. Biya kembirra ne-kbada arakba. Wurdarriya-wiya akina. ");
INSERT INTO aoi_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Biya ngarningka nakina Neningikarrawara ni-yengbina ayakwa. “Aki-yebijebakaja akungwa ngala amungukungwa, ekuwarra karrawaru-wa, umba ngalaja ekuwarra arrawa-manja,” ni-yama nakina. ");
INSERT INTO aoi_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Biya kembirra n-eyebijebaka ebina akungwa eningarrawa-langwa iya eningikarrawara-langwa kajungwa aringbirra angalya kuw-ambilyi-yada wilyarra. ");
INSERT INTO aoi_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Biya ni-yengbijuwa nakina Neningikarrawara akina aringbirra angalya “Angubina.” Biya na-lyarrngwalyilyada arakba akina. Bi...ya mambilyuma marringa numi-jerrida arakba malakina-da. Biya kembirra ne-kbada arakba. Wurdarriya-wiya akina. ");
INSERT INTO aoi_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Biya ngarningka kembirra nakina Neningikarrawara ni-yengbina ayakwa. “Akungwa aku-murndukwuna awurrakawura-murra,” ni-yama, “kajungwa kuw-abilyerrikajungwuni-yada ajiringka,” ni-yama nakina. Kembirra na-murndukwunuma arakba akina akungwa. Umba ngalaja ajiringka nuw-abilyerrikajungwunuma akina. ");
INSERT INTO aoi_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Biya nakina Neningikarrawara ni-yengbijuwa akina ajiringka “Ariba.” Umba akina akungwa ebina nawurra-murndukwunuma numa-yengbijuwa “Makarda” nakina. Biya kembirra n-andeya nakina akena ni-rringka ariba akwa ngawa makarda alirrakukwulyubena-kiye-ka alakina-da. ");
INSERT INTO aoi_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Biya ngarningka kembirra nakina Neningikarrawara ni-yengbina ayakwa. “Ariba ak-arrangbina eka eminiminingka akwa ngawa amarda eminiminingka,” ni-yama nakina. “Akina amarda kuw-arrangbinama amadidira amaninga umba ngalajukwaba eka eminiminingka kuw-arrangbinama amamamuwa amaninga,” ni-yama nakina. ");
INSERT INTO aoi_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Ngalaja kembirra akina ariba nuw-arrangbama arakba eka-murriya akwa ngawa amarda-murriya. Biya nakina Neningikarrawara n-andeya akena ni-rringke-ka amurndakakina eka-murriya akwa ngawa amarda-murriya awurrakukwulyubene-ka. ");
INSERT INTO aoi_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Biya na-lyarrngwalyilyada arakba akina. Bi...ya mabiyakarbiya marringa numi-jerrida arakba makina-da. Biya kembirra ne-kbada arakba. Wurdarriya-wiya akina. ");
INSERT INTO aoi_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","15","Biya ngarningka kembirra nakina Neningikarrawara ni-yengbina ayakwa. “Aki-jadiya aki-larradiya angubina-manja alarradada,” ni-yama. “Aki-larrkabarrakajiya enena-manja angalya, kajungwa meyebijebi-yada malakina-kiya meningilida akwa ngawa meningalyarrngwalyilya akwa kajungwa meyebijebi-yada meningilida mababurna-langwa. Kumi-yuweyinama malakina-kiya meningilida akwa ngawa meningalyarrngwalyilya muwilyuwilyaba-wiya mamurndakakina. Akwa ngarningka aki-larrkabarrakajiya enena-manja angalya, kajungwa eyebijebi-yada akilarrkumamarika akwa ngawa akilarrkinungkwura. Ke-yuweyinama alakina-kiya akilarrkumamarika akwa akilarrkinungkwura awilyuwilyaba-wiya ngawa amurndakakina ngalajukwaba,” ni-yama nakina Neningikarrawara. ");
INSERT INTO aoi_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","18","Biya kembirra nakine-ka Neningikarrawara nilirraki-ngekburakama ambilyuma-kiya alarradada adirrungwarna-kiya. Numa-ngekburakama mamawura akwa num-akumarnuma makina karrawara angubina-manja, kajungwa kumu-larrkabarrirrakini-yada makina enena-manja angalya akwa kumu-bungkawadini-yada meningilida-manja makina. Biya kembirra nakina ni-ngekburakama yakina yimawura akwa n-akumarnuma ngalajukwaba yakina angubina-manja kajungwa kinu-bungkawadini-yada yakina meningalyarrngwalyilya-manja. Biya ngarningka nanga-ngekburakama duwurrakwulyumide-ka dakilyingajanga nakina. Nilirraki-ngekburakama nakina alakina-kiya alarradada adirrungwarna-kiya kajungwa eyebijebi-yada alarradada-langwa iya alarrumur•da-langwa. Biya kembirra n-andeya nakina akena numa-rringka mamawura iya yimawura iya dakilyingajanga-murriya awurrakukwulyubene-ka akina. ");
INSERT INTO aoi_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Biya na-lyarrngwalyilyada arakba akina. Bi...ya mabiyarbuwa marringa numi-jerrida arakba makina-da. Biya kembirra ne-kbada arakba. Wurdarriya-wiya akina. ");
INSERT INTO aoi_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Biya ngarningka kembirra nakina Neningikarrawara ni-yengbina ayakwa. “Akwalya ababurna eminiminingka aki-lyangburrukwajiya makarda,” ni-yama. “Umba ngalaja abalkaya angubina-manja wurrajija ab-angkirreyina,” ni-yama nakina. ");
INSERT INTO aoi_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Kembirra ni-ngekburakama nakina adidirrungwarna akwurrangina iya dinungkwulangwa iya alyakilya-murriya, akwa ngarningka akwala engka iya engka akwalya ebina na-lyangburrukwajuwama makarda. Akwa ngarningka wurrajija-murriya aburrajukwaba neni-ngekburakama nakina. Biya n-andeya nakina Neningikarrawara akena ni-rringka amurndakakina awurrakukwulyubene-ka akina. ");
INSERT INTO aoi_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Biya ni-yengbinuma ayakwa eningaba nakina Neningikarrawara akwalya-murriya-manja akwa wurrajija-murriya-manja. Ni-yama akwalyu-wa, “Wurr-arrangbijeyina akwa wurruma-lyangburrukwajiya makarda,” ni-yama. Umba ni-yama wurrajija-wa, “Nungkwurrajukwaba wurr-ababurnadina,” ni-yama nakina. ");
INSERT INTO aoi_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Biya na-lyarrngwalyilyada arakba akina. Bi...ya mamangbala marringa numi-jerrida arakba makina-da. Biya kembirra ne-kbada arakba. Wurdarriya-wiya akina. ");
INSERT INTO aoi_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Biya ngarningka kembirra nakina Neningikarrawara ni-yengbina ayakwa. “Aki-jadijiya ajiringka yiminiminingka yinungungwangba iya yingarna-murriya, yadidirrungwarna akwa ngawa ngalajukwaba yiyukwayuwa,” ni-yama nakina. ");
INSERT INTO aoi_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Kembirra ni-ngekburakama nakina yiminiminingka yinungungwangba iya yingarna-murriya, yukwala yadidirrungwarna umba yukwala yiyukwayuwa. Biya kembirra n-andeya nakina akena ni-rringka yimurndakakina yinungungwangba-murriya yukukwulyubene-ka yakina-da. ");
INSERT INTO aoi_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Biya ngarningka kembirra nakina Neningikarrawara ni-yengbina ayakwa. “Ngakwurruwe-ka ngarna aka-ngekburakinama warnumamalya,” ni-yama. “Umba ngakwurruwa wuburra ke-yaminama wurrakina. Akwa ka-bungkawadinama wurrakina akwalya-murriya-manja iya wurrajija-murriya-manja iya yinungungwangba-murriya-manja akwa yingarna-murriya-manja wurrakina warnumamalya,” ni-yama Neningikarrawara nakina-da. ");
INSERT INTO aoi_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Biya kembirra arakba neni-ngekburakama nakina warnumamalya. Neni-ngekburakama wurrakina warnumamalya wuburra enuwa Neningikarrawara. Nenungkwarba akwa didarringka nenilirraki-ngekburakama nakina. ");
INSERT INTO aoi_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Biya kembirra ni-yengbinuma nakina akwala ayakwa eningaba. Ni-yama aburruwa-wa, “Wurr-arrangbina wurriyukwayuwa, akwa kembirra ambaka-murra aburrajukwaba kuw-arrangbijeyina, kajungwa kuw-ambilyi-yada angalya-manja akwa ka-bungkawadini-yada ebina-manja angalya wurrakina,” ni-yama nakina. “Yiku-bungkawadinama kirrakina akwalya-manja iya wurrajija-manja akwa yinungungwangba-manja kirrakina. ");
INSERT INTO aoi_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","“Ngarramini-ngekburakama ngayuwa engka iya engka aninga-murriya, ebina amadidira nuw-arrangbinama amarda, akwa ngarningka ebina amaninga nuw-arrangbinama eka yik-alyubarini-yada kirrakina. ");
INSERT INTO aoi_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Umba ngayuwa ningenu-kwama amarda yinungungwangba-murriya akwa ngarningka wurrajija-murriya aburra-langwi-yada aninga,” ni-yama Neningikarrawara. ");
INSERT INTO aoi_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Biya n-andeya nakina Neningikarrawara akena ni-rringka amurndakakina ni-ngekburakama nakina eninginingaba akukwulyubene-ka akina. Biya na-lyarrngwalyilyada arakba akina-da. Bi...ya mamangbala muwilyaba marringa numi-jerrida arakba makina-da. Biya ngarningka ne-kbada arakba. Wurdarriya-wiya akina-da. ");
INSERT INTO aoi_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Ebina-langwiya Neningikarrawara ni-ngekburakama nakina enena angalya iya angubina iya angkwulyumida-langwa amurndakibina enena-manja angalya iya angubina-manja akwa makarda-manja nuw-ambilyama akina. Akwa kembirra ni-jerrukwama arakba nakina ena-langwa warka. ");
INSERT INTO aoi_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Mamangbala muwilyaba mamawura nu-war•danguma warka ena-langwa n-aburradadangu-mulangwiya yanda-langwa ni-jerrukwama amurndakakina n-andabukwama. Biya kembirra nu-ngwanjuma nakina warka-langwa arakba-da. ");
INSERT INTO aoi_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Kembirra ni-yama nakina, “Memema mamangbala-manja mambilyuma mamawura ningu-ngwanjinama arakba ningena. Meminingka kembirra mamawura memema, akwa meyebijeba mukwala-langwa mamawura kum-ambilyama makina, ningu-ngwanju-mubaba ngayuwa aduwaba warka-langwa. Mukwurdukwurda memema mamawura nganyangwa arakba-da,” ni-yama Neningikarrawara nakina-da. ");
INSERT INTO aoi_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Ebina-langwiya nakina Neningikarrawara ni-ngekburakama ababurna-langwa angalya-da. Adinuba-wiya ni-ngekburaka-manja Yaweya Neningikarrawara ababurna-langwa angalya, ");
INSERT INTO aoi_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","nara ambaka ebina amarda ariba-manja akwa nara ambaka amadidira ka-lingbijangina. Akwa nara ambaka kini-ngekburaka nakina yelyukwa yiniki-larri-yada ajiringka-wa. Akwa ngarningka nara wurribina warnumamalya warniki-lungkuwabiji-yada eka iya amarda. ");
INSERT INTO aoi_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Umba ngalaja akungwa na-jijadanguma ajiringka-langwa na-warumajungwunuma akwa na-ngambajuwamurra ababurna-langwa angalya akina-da. ");
INSERT INTO aoi_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Bi...ya kembirra Yaweya Neningikarrawara nu-manga arakba nakina akwala ajiringka akwa neni-ngekburaka nakina nuwilyaba nenungkwarba ebina-langwa ngawa ajiringka. Kembirra nenuminu-bukwa ena-langwa arrirra emindu-wa nakina-langwu-wa nenungkwarba, kajungwa nenik-enibudi-yada nakina. Kembirra eneja nakina nenungkwarba n-enibuduma arakba-da. ");
INSERT INTO aoi_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Eneja kembirra nakina Yaweya Neningikarrawara ni-lungkuwabijuwama eka iya amarda awilyaba-manja angalya emikirra Yidina. Alyengmilyengma-langwa nuw-ambilyumurra akina angalya. Biya kembirra Yaweya Neningikarrawara nen-akumarna nakina yakwujina nibina nenungkwarba neni-ngekburakama. ");
INSERT INTO aoi_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Akwulyubene-ka akina angalya mena nakina Neningikarrawara ni-lungkuwabijuwame-ka eminiminingka iya eminiminingka eka eninginingabe-ka akirringkangena-langwa akina, akwa nawurrak-arrangbeyinuma aninga eningaba enikalyubara. Umba awurruwurrakuwilyarra amurndakakina eka eninganinga iya amarda, ni-lungkuwabijuwama nakina Neningikarrawara awilyaba eka akwanenibika-langwa akwa ngarningka awilyaba eka akwaneningmika-langwa ebina narraku-kwunama akwaneningmika eningaba-langwa akwa awurrariya-langwa warnumamalya-manja akina-da. ");
INSERT INTO aoi_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Umba ngalaja awilyabe-ka adalyuma na-kwularrinuma akina Yidina-manja akwa na-ngambajuwamurra ajiringka yakwujina. Kemba na-kwularrinuma akina erribaja angwurra biya nuw-eyebijebakajungwunuma arngkabiyarbuwa-ma. ");
INSERT INTO aoi_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Awilyaba Bijena emikirra akina adalyuma ebina na-kwularrinumurra akina-langwiya angalya emikirra Yebila. ");
INSERT INTO aoi_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","Umba akina-manja ngawa angalya Yebila akukwulyubene-ka angwarnda akawulda-murra nuw-ambilyumurra akina yakwujina ajiringka-manja arrawa, akwa ngawa eminiminingke-ka angwarnda alarrngekburna-wiya akwa ngalajukwaba bungabungwa akwulyubena ebina ne-kirruwanjuma eningaba nuw-ambilyumurra yakwujina akina. ");
INSERT INTO aoi_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Umba ngalaja awilyaba engka adalyuma emikirra Kiyena ebina na-kwularrinuma akina-langwiya angalya emikirra Kwuja. ");
INSERT INTO aoi_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Akwa ngarningka awilyaba engka adalyuma emikirra Dakirija ebina na-kwularrinuma alyengmilyengmu-wa akina-langwiya angalya emikirra Ajiriya akwa erribaja angwurra. Akwa ngarningka awilyaba engka adalyuma emikirra akina Yiburadija. Abiyarbuwa adalyuma amurndakakina. ");
INSERT INTO aoi_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Nakine-ka Yaweya Neningikarrawara nen-akumarnuma nibina nenungkwarba yakwujina ebina-manja ngawa angalya Yidina, kajungwa neniki-lungkuwabiji-yada aninga akwa nenik-akwurraji-yada akina angalya nakina. ");
INSERT INTO aoi_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Biya kembirra ni-yama nakina enuwa-wa, “K-alyubariname-ka ningkakina aninga eningerribirra-langwa eka,” ni-yama. ");
INSERT INTO aoi_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","“Akena awilyaba-langwa wulkwa eka nare-ka alyubaruma ngala-langwa aninga. Enena eka narraku-kwunama akwaneningmika eningaba-langwa akwa awurrariya-langwa warnumamalya-manja, akwa nare-ka alyubaruma angala-langwa aninga. Umba k-alyubarina-manja nungkuwa akina aninga kembirra ki-jungwunama ningkakina akini-yada ngawa-da,” ni-yama Yaweya Neningikarrawara enuwa-wa-da. ");
INSERT INTO aoi_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Biya kembirra ni-yama ngarningka nakina Yaweya Neningikarrawara, “Awurrariye-ka akina nenik-ambilyinga-langwa naka nenungkwarba nakwukawura,” ni-yama. “Ngayuwa kinumini-ngekburakinamurra kembirra wurruwilyaba warnikumamurikaja ena-langwi-yada, kajungwa warniki-yakaji-yada wurrakina,” ni-yama nakina. ");
INSERT INTO aoi_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Biya kembirra nu-manga Yaweya Neningikarrawara akwala ajiringka akwa ni-ngekburaka nakina yinungungwangba-murriya akwa wurrajija-murriya ebina-langwa ajiringka. Biya nu-wilyaka yakina yinungungwangba-murriya akwa ngawa wurrajija-murriya nibinu-wa nenungkwarba, kajungwa kinumurndaki-yengbijuwi-yada nakina yinungungwangba yinimikirra akwa wurrajija. ");
INSERT INTO aoi_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Kembirra eneja nakina nenungkwarba nu-kwama yimurndakakina yinungungwangba yinimikirra akwa wurrajija warnimikirra, akena nara wurribina warningaba warnikumamurikaja ena-langwa. ");
INSERT INTO aoi_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Eneja kembirra Yaweya Neningikarrawara nenu-mungkwulija nakina nenungkwarba akwa n-ar•de-ka marringa nakina nu-mungkwulinga. Umba nu-mungkwulu-wiya ngawa nakina, eneja Yaweya Neningikarrawara numa-manga muwilyaba memirrkwura ena-langwa akwa neni-dida nenumadangkwa. ");
INSERT INTO aoi_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Biya nanga-ngekburaka didarringka memirrkwura-langwa akwa nanga-lyilyanga dakina enuwa-wa. ");
INSERT INTO aoi_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Eneja nenungkwarba ni-yama, “Wa! Warne-ka warnumamalya arakba wuburra ngayuwa-da. Nganyangwa adidira ngaluwa-manja arakba akina, akwa nganyangwa amadangkwa ngaluwa-manja kajukwaba ngawa-da. Nakine-ka Yaweya Neningikarrawara nanga-ngekburakama daka dadumamalya memirrkwura-langwa ningenungkwarba-langwa aduwaba, kembirra dadimikirra ‘Didarringka nganyangwa’ dakina-da,” ni-yama nakina nenungkwarba-da. ");
INSERT INTO aoi_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Kembirra akina-langwa-bina neningerribirra nenungkwarba kenilirraki-lalikinama nakina nungwenikba akwa ngawa dirndenikba kajungwa keni-yakeyini-yada dadingiyenikba-manja, akwa kembirra wunuwilyaba-ma ngawa wunenumadangkwa-kiya wunalakina-da. ");
INSERT INTO aoi_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Umba nakine-ka nenungkwarba akwa dakina didarringka wuneyebirra-kiya wunalakina-da, akena nara keni-yeliyanga-da. ");
INSERT INTO aoi_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Ni-ngekburaka-manja Yaweya Neningikarrawara yababurna-langwa yinungungwangba-murriya, kembirra yuwilyaba yingarna yakina yakakirume-ka yiniki-kadiki-yada warnumamalyu-wa. Yakine-ka yakakiruma angwurra yababurna-manja yukwala yinungungwangba-murriya. Biya ni-likena yakina yingarna dibinu-wa didarringka akwa ni-yengbina ayakwa ngaluwa-wa. “Kada, Neningikarrawara ni-yamama nungkwurnuwa-wa nakina, ‘Nara alyubaruma amaninga amamamuwa amurndakenena-langwa eka,’ ni-yamama nakina? Jerriya amandangwa ni-yengbinuma nakina akina ayakwa?” ni-yama yakina yingarna ngaluwa-wa. ");
INSERT INTO aoi_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","“Nara,” ngalaja yingi-yama dakina didarringka. “Yikin-alyubarinama yinalakena amaninga amamamuwa amurndakenena-langwa eka. ");
INSERT INTO aoi_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","Akena nara alyubaruma yinalakena wulkwa amaninga awilyaba-langwa ememeka ebina nuw-arndurrkwarjiya-murrilangwa akina awurruwurrakuwilyarra. Umba yirrenu-makama nakina Neningikarrawara yinuwa-wa, ‘Nare-ka alyubaruma a-lyingama amamamuwa angaba-langwa eka,’ ni-yamama nakina. Yikini-lyingina-manja akina yinalakena, kembirra yikini-jungwunama-da,” yingi-yama dakina didarringka yakinu-wa yingarna-da. ");
INSERT INTO aoi_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Eneja ni-yama yakina yingarna, “Nare-ka. Ekalya akina ayakwa. Nara kinalakina a-jungwuma,” ni-yama yakina. ");
INSERT INTO aoi_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","“Eneja nakina Neningikarrawara ni-yengbinuma akina ayakwa nungkwurnuwa-wa mena neningma-baba nakina yikin-alyubarina-manja kinalakina akina amaninga, kembirra Neningikarrawara wuburra yikini-yaminame-ka kinalakina-da, akwa yikin-eningmidinama ebina eningaba akwa awurrariya arakba-da,” ni-yama yakina yingarna-da. ");
INSERT INTO aoi_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Umba ngalaja didarringka ying-andeya akena yingi-rringka akina eka akwulyubena. Kembirra yingi-lyangkiyama dakina, “Eningabe-ka k-alyubarina-mulangwa ngayuwa enena amaninga. Akwa ngarningka eningaba akina aringkawi-yada ngayuwa-da,” yingi-lyangkiyama dakina. Biya kembirra yingi-rndirrka, ying-alyubarina akwa yinginu-kwa ekuwarra neningiyadikba-wa-da. Enejukwaba kembirra n-alyubarina nakina-da. ");
INSERT INTO aoi_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Biya nen-eyijinu-mulangwa wunalakina akina amaninga kembirra warenja-bawiya numu-ngwur•dangma menba iya mangma aburna-langwa. Akwa neni-lyandarrkena arakba wuneyebirra-kiya wunalakina-da. Biya kembirra nenuma-warrka arakba mukwala mamawarruwalya manyungwunya akwa nen-awiyebeyina makina wunalakina-da. ");
INSERT INTO aoi_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Bi...ya num-awiyebu-manja mamawura nen-engkirrika wunalakina Yaweya Neningikarrawara nubukwaya ni-likenuma nakina akinu-wa angalya, akwa nen-abuwarrkajungwa arakba wunalakina neni-didirrakajungwuma eka-manja nakina-langwa. ");
INSERT INTO aoi_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Umba eneja nakina Yaweya Neningikarrawara n-ardanga nakina nibinu-wa nenungkwarba. “Ningkangamba?” ni-yama. ");
INSERT INTO aoi_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Eneja ni-yama nakina nenungkwarba, “Ning-engkirrikama ngayuwa nungkwa-langwa ayakwa akwa ning-akbar•duma, kembirra ning-abuwarrkajungwuma, mena ningeyebirra-baba ningena,” ni-yama nakina. ");
INSERT INTO aoi_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Eneja ni-yama Neningikarrawara enuwa-wa, “Angkaburra bu-makama ningkakina nungkuwa ningkeyebirra?” ni-yama. “Ningk-alyubarinuma ebina amaninga yirra-maka-murrada ngayuwa nara alyubaruma nungkuwa-na?” ni-yama. ");
INSERT INTO aoi_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Eneja ni-yama nakina nenungkwarba, “Daka didarringka yu-kwama ngayuwa-manja, ngaluwe-ka ngu-kwama ebina aninga akwa ning-alyubarinuma akina.” ");
INSERT INTO aoi_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Kembirra eneja nakina Yaweya Neningikarrawara ni-yama dibinu-wa didarringka, “Miyambena-burra ningki-yamama ningkakina akina?” ni-yama. Ngalaja yingi-yama, “Yibina yingarna nginu-kwudirrkame-ka ngini-kadikama yakina akwa kembirra ning-alyubarinuma ngayuwa,” yingi-yama dakina-da. ");
INSERT INTO aoi_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Eneja nakina Yaweya Neningikarrawara ni-yama yibinu-wa yingarna, “Akine-ka ningki-yama-mulangwa ningkakina aduwaba, kembirra ki-lyandiname-ka angwurra ningkakina,” ni-yama. “Nara ngayuwa e-kbajuma yukwala yinungungwangba, umba yirre-kbajinama aduwaba ningkakina ningkuwilyaba ngayuwa-da. Kembirra aduwaba-langwa nungkwaja ki-rrekburruwarnama mulkwa-murra, akwa k-alyubarinama ajiringka-da, yanda-langwa ki-jungwunama ningkakina-da. ");
INSERT INTO aoi_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","“Nungkuwa akwa ngawa daka didarringka yikingu-wirrikbeyiname-ka kirringalakina. Nganja ningena k-akumurnama nungkwurrunguwa-manja akuwurruwirrikbaja. Aburraja kembirra ngala-langwa wurriyukwayuwa akwa ngawa nungkwa-langwa ka-wirrikbeyinama warningangkawura ngawa wurrakina-da. Ngala-langwa wurriyukwayuwa karri-lyangburrenama aringka nungkwa-langwa-da, umba nungkwaja nungkuwa k-anginama amulurrngwa alika aburra-langwa-da,” ni-yama Yaweya Neningikarrawara yakinu-wa yingarna. ");
INSERT INTO aoi_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Biya kembirra Yaweya Neningikarrawara ni-yengbina nakina akwala ayakwa engbuda dibinu-wa didarringka ngalajukwaba. Ni-yama nakina, “Ku-mambakina-manja nungkuwa wurrangariya, kembirra k-arrkwujeyinama ningkakina. Umba ngayuwe-ka k-arumurrkwunama akwulyandilyanda nungkwa-langwa akwa ngarningka k-arrkwujeyinama nungkuwa akini-yada ngawa k-arrangbina-manja ningkakina wurrangariya nungkwa-langwa. Mame-ka ningkakina k-arrkwujeyinama umba kini-ngayindenama ngawa ningkakina nenungkwarba nungkwa-langwa. Umba eneja nakine-ka nenungkwarba nungkwa-langwa kinu-bungkawadinama nungkuwa-manja-da,” ni-yama Yaweya Neningikarrawara dakinu-wa didarringka nakina-da. ");
INSERT INTO aoi_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Biya kembirra ni-yengbina Yaweya Neningikarrawara akwala ayakwa nibinu-wa nenungkwarba enejukwaba. “Nungkuwa ningkingamin-engkirrikenuma ayakwa dadingiyena-langwa akwa ningk-alyubarinuma ebina aninga ngarra-maka-murrada ngayuwa nungkwurrunguwa nara alyubaruma akina,” ni-yama nakina. “Akina-murrada-bina ningi-kbajinama ngayuwa ajiringka aduwaba. Kuw-arriyadiname-ka akina. Umba ku-war•denama ngawa nungkuwa ningkeningangkawura, kajungwa ka-lungkuwarrini-yada aninga nungkwa-langwa. ");
INSERT INTO aoi_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Kuw-arrangbiname-ka ngalaja ajiringka amarda amurndakibina awurruwurrariya akwa akwurrirra-murriya. Nungkwaja kembirra eningerriberriba amaninga k-aburangkinama engku-wa iya engku-wa angalya ningkakina-da. ");
INSERT INTO aoi_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Aruma warka ku-war•denama nungkuwa yanda-langwa kumi-jadena-manja mukwena nungkwa-langwa-langwa ningkenumadangkwa. Arume-ka warka ku-war•denama ningkakina kajungwa kuw-arrangbini-yada ajiringka aninga nungkwa-langwa-da. Ki-yaminjaminama ngawa ningkakina yanda-langwa ki-jungwunama ningkakina-da akwa ki-lawurradinama ajiringka-wa-da. Umba kabu-rungkwabiname-ka ningkakina ningkenumadangkwa ajiringka-wa. Ajiringka-langwa yirra-ngekburakama ngayuwa ningkakina, kembirra nungkuwa k-ajiringkadinama ngarningka ningkakina-da,” ni-yama Yaweya Neningikarrawara enuwa-wa-da. ");
INSERT INTO aoi_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Eneja nakina nenungkwarba nenimikirra Eduma nakina, akwa nanga-yengbija arakba dadingiyenikba dadimikirra Yiba, mena dirndarringba-baba dakina wurrababurna-langwa warnumamalya. Akina ekirra ne-yaminama “warniba.” ");
INSERT INTO aoi_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Eneja kembirra Yaweya Neningikarrawara nenumini-ngekburaka dumbala yinungungwangba-langwa yinumakwulya Eduma-langwa akwa ngawa dadingiyenikba-langwa, akwa nenilirraku-kwa dakina dumbala wunenik-awiyebi-yada wunalakina-kiya nakina-da. ");
INSERT INTO aoi_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Biya kembirra Yaweya Neningikarrawara ni-lyangkiyama nakina, “Naka arakba nenungkwarba ngakwurruwa wuburra kini-yaminame-ka nakina-da. Akwa ngarningka neningma arakba nakina ebina eningaba akwa awurrariya. Nara kembirra alyubaruma nakina amaninga ebina-langwa eka akwanenibika, nari-yada neningangkawura ambilyuma neniba nakina-da,” ni-lyangkiyama Yaweya Neningikarrawara nakina-da. ");
INSERT INTO aoi_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Biya kembirra nakina Yaweya Neningikarrawara nenilirraki-larrka arakba nibina nenungkwarba akwa ngawa dibina didarringka nenilirraki-jadijuwa wunalakina ebina-langwa angalya emikirra Yidina. Biya ni-yama nakina Edumu-wa, “Ningu-manguma ngayuwa akwala ajiringka akwa yirra-ngekburakama nungkuwa akina-langwa,” ni-yama. “Kembirra aduwaba-langwa ku-war•denama ningkakina warka ajiringka-manja nungkuwa,” ni-yama nakina nakinu-wa nenungkwarba. ");
INSERT INTO aoi_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Biya kembirra nenilirraki-jadijuwa-mulangwa wunalakina, nen-akumarnuma Yaweya Neningikarrawara ena-langwa warnikumamurikaja warnimikirra jerubima Yidina-manja alyengmilyengma-langwa nakina akwa n-akumarnuma ngarningka yakwujina kaliwanga angwura-murra ebina ne-ngengkilyuwakenuma angerriba iya yenjerra. N-akumarnuma Yaweya Neningikarrawara akina kajungwa nari-yada warningerribirra warnumamalya a-likama yenjerrikina nuw-arndurrkwarjeyu-murruwa ebina eka akwanenibika. Kembirra n-anjimangwukwama arakba akine-ka angalya nakina-da. ");
INSERT INTO aoi_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Nakine-ka Eduma akwa ena-langwa dadingiyenikba Yiba neni-yakeyinumurra nenu-mungkwulumurra arakba wunalakina. Bi...ya arakba dakina kembirra dadingiyenikba yingu-mambakinuma. Biya kembirra arakba Yiba yinginumin-arrangba nangariya Eduma-langwa dakina. Biya yingi-yama, “Nakine-ka Yaweya nginu-mamurikajuwame-ka ngayuwa, kembirra arakba ningen-arrangbama naka nangariya-da,” yingi-yama dakina. Biya nakina neningadinuba-wiya niyukwujiya ngala-langwa yingini-yengbijuwama dakina nenimikirra Keyina. Umba akina ekirra ne-yaminama “ningenu-manguma.” ");
INSERT INTO aoi_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Bi...ya kembirra ambaka-murra ngarningka nuwilyaba yingin-arrangba, akwa yingini-yengbijuwa nakina Ebula. Aburnaja kembirra arakba wunalakina wunambilyuma. N-arumidinu-manja nakina Ebula kembirra nuwurrak-embirrajuwama arakba jiba-manja. Umba eneja Keyina ni-lungkuwabijuwama nakina eka iya amarda eninganinga. ");
INSERT INTO aoi_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Biya kembirra nenu-kwama akwala aninga ni-lungkuwabijuwa-mulangwa angerriba Yaweyu-wa. ");
INSERT INTO aoi_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Umba eneja nakina neningarija-langwa nenikumarnjenikba Ebula ebina nuw-arrangbama eningadinuba-wiya angariya jiba nu-wardanga akina. Biya eningaba-dangwa amalya nenu-kwama nakina Yaweyu-wa. Kembirra eneja nakina Yaweya nenu-werrungwur•danguma nakina-manja Ebula, akwa akina-manja ngarningka amalya. ");
INSERT INTO aoi_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","Umba nu-waranguma nakina Keyina-manja akwa ngawa ena-langwa aninga nenu-kwa-mulangwa enuwa-wa. Kembirra eneja nakina Keyina n-awinyambade-ka akwa n-arrirriyada nenumukwurra. ");
INSERT INTO aoi_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Eneja ni-yama Yaweya enuwa-wa, “Miyambena-burra nungkuwa ningk-awinyambadinama? Akwa ningk-arrirriyadinama ningkenumukwurra?” ni-yama. ");
INSERT INTO aoi_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","“Nungkuwa ki-yamina-manja eningaba, kembirra ku-marngkinama ningkakina. Akena nara-manja ningkakina e-yamama eningaba kembirra akine-ka wuburra laka wurruwilyaba wurruwurrariya wurramukwa na-rarrkajungwunama wurrakina kab-adawarrkini-yada nungkuwa aduwaba. Bu-ngayindenama wurrakina ka-bungkawadinama nungkuwa-manja, akena nungkuwe-ka arrkala ku-bungkawadinama wurrakina-manja wurramukwa ningkakina-da,” ni-yama Yaweya Keyinu-wa-da. ");
INSERT INTO aoi_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Eneja ni-yama nakina Keyina nenikumarnjenikba-wa, “Kwa, yi-likaja angerriba erriberriba-wa,” ni-yama. Biya neni-likena arakba wunalakina erriberriba-wa. Biya yakwujina ngawa Keyina nakina nenu-wardanga arakba nakina-manja nenikumarnjenikba. Nenu-wardanga arakba nakina akwa ni-jungwa arakba-da. ");
INSERT INTO aoi_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Kembirra eneja Yaweya ni-yama nakinu-wa Keyina, “Nangamba nenikumarnjena?” Eneja ni-yama, “Kada! Ningeningbala. Mena kin-akukwurrajinama ngayuwa nakina nenikumarnjarrka-manja-baba ngawa?” ni-yama. ");
INSERT INTO aoi_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Umba ni-yama Yaweya enuwa-wa, “Miyambena-burra nakina ningkenu-wardanga? Awurrariye-ka akina. Nganja ningena ningeningma nungkuwa ningkenu-wardanguma, ninguma-rringkina-mubaba ngayuwa ena-langwa merra ajiringka-manja. Ningkenu-wardangu-mulangwa nakina akine-ka wuburra laka n-ardirdenama nakina ngayuwa-wa kajungwa yibamini-lawurrakajini-yada ngayuwa nungkuwa-wa akwa ka-ngajini-yada ningkakina nungkwamba-langwa. ");
INSERT INTO aoi_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Kembirra ngayuwa aduwaba yirre-kbajinama ningkakina. Nungkwaja kembirra ningkakina nara a-lungkuwabijuma ngarningka aninga, mena akina ajiringka ne-bekinuma arakba makina merra. ");
INSERT INTO aoi_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Umba ki-lungkuwabijina-manja kembirra ngarningka ningkakina eningerribirra amarda, nara kembirra arrangbama aninga, nuw-arriyadinu-mubaba ajiringka. Biya kembirre-ka ningkakina ki-likajama arakba yada-da, angerriba iya angerriba arakba ku-marrawarnama. Biya arakba kembirra ningkakina ningkeningangalya-ma ningkakina-da,” ni-yama Yaweya Keyinu-wa-da. ");
INSERT INTO aoi_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","14","Eneja ni-yama Keyina, “Awurrariye-ka akina ningku-minangkirreyinama ngayuwa enena-langwa angalya akwa nungkuwa-langwa. Ningki-yama-mulangwa akina ayakwa, kembirra ngayuwe-ka k-arrkwujeyinama angwurra. Kembirra ku-marrawarnama ningena aduwaba-langwa ningeningangalya-ma. Umba aburraja wurribina warningerribirra kembirra kab-akburrangina-manja ngayuwa kabu-ngajinama-da,” ni-yama Keyina Yaweyu-wa-da. ");
INSERT INTO aoi_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Akena eneja Yaweya ni-yama, “Nara. Kemba kabu-ngajina-manja wurrakina wurruwilyuwilyaba nungkuwa-manja, ngayuwa-dangwa kembirra ki-yaminame-ka kajungwa wurrukwala warnumamalya kabumini-lawurrakajini-yada nungkwa-langwa akwa karra-ngajini-yada wurrumangbala wurrambilyuma,” ni-yama. Biya nakina Yaweya ni-jirrkumarnuma nakina-manja Keyina nari-yada warnumamalya a-ngajuma Keyina-manja. Kembirra nenu-madumurrukwama nakina wurrakinu-wa warnumamalya nakina-langwa Keyina. ");
INSERT INTO aoi_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Umba Keyina nakina neni-lalika arakba Yaweya akwa ni-likenuma. Akwa n-ambilyuma eminingka-manja angalya emikirra “Akumarrawarna” angalya. Alyengmilyengma-langwa akina angalya Yidina-langwa-da. ");
INSERT INTO aoi_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Bi...ya Keyina akwa ena-langwa dadingiyenikba nen-arrangba arakba niyukwujiya nakina nenimikirra Yinakwa. Biya nakina Keyina ni-likirakama arakba ababurne-ka alikira. Biya ni-yengbijuwama nakina akina angalya emikirra wuburra ena-langwa-langwa nenikuwenikba-langwa ekirra akina. ");
INSERT INTO aoi_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Bi...ya Keyina-langwa nenikuwenikba Yinakwa enamba-langwa n-akumajungwunuma nenikuwenikba biya neni-yengbijuwama nakina nangariya nenimikirra Yirada. Bi...ya enamba-langwa Yirada n-akumajungwunuma nakina nenikuwenikba. Biya nenimikirra nakina Miyijeyela. Bi...ya enamba-langwa nakina Miyijeyela n-akumajungwunuma nenikuwenikba. Biya nenimikirra nakina Midijeyela. Bi...ya enamba-langwa Midijeyela n-akumajungwunuma nakina nenikuwenikba. Biya nenimikirra nakina Lameka. ");
INSERT INTO aoi_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Bi...ya nakine-ka Lameka wurringambilyuma-kiya wurradingabulena, duwilyaba Ada umba duwilyaba Jila. ");
INSERT INTO aoi_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Ngalaja Ada dakina arakba yingin-arrangbama nangariya akwa yingini-yengbijuwama nenimikirra Jabala. Umba akina ekirra Jabala ne-yaminama “nenik-arrikuwaraki-yada.” Umba nu-wilyarridinu-manja eneja nakina Jabala neningadinuba-wiya nakina numirarringba warnumamalya-langwa wurribina narr-akukwurrajuwa-mulangwa narr-arrikukuwaraka-mulangwa wurrakina jiba-manja iya bulukwa-murriya-manja. Akwa ngarningka enuwa akwa ena-langwa warnumamalya nuw-ambilyumurra wurrakina warningadinuba-wiya akalikwa-murra-manja alikira ebina narri-likiraka-murrumanja. ");
INSERT INTO aoi_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Umba eneja nenikumarnjenikba nenimikirra Jubala nakina mena akina ekirra Jubala ne-yaminama “akumalyumalyangka eningemeba.” Neningadinuba-wiya numirarringba nakina warnumamalya-langwa wurribina na-malyangkenu-mulangwa narru-warrijuwa-mulangwa wurrakina ebina akumalyumalyangka eningemeba. ");
INSERT INTO aoi_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Umba ngalaja Jila, dibina dadingarija-langwa dadingiyenikba Lameka-langwa, yingin-arrangbama nangariya nenimikirra Dubala Keyina. Umba eneja n-arumidinu-manja Dubala Keyina nu-war•dangumurra nakina numurndaki-ngekburakamurra ababurna angandingandinga bangkilya-murriya, amurndakibina ekikingkarrnga-langwa akwa ngawa akumungkumungkada-langwa akwa ngarningka akadabaja-langwa. Nuwurraki-ngekburakama akina didija-langwa. Umba ena-langwe-ka dadiyamarnjenikba dakina dadimikirra Neyama. ");
INSERT INTO aoi_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Eneja Lameka ni-yama nakina wurringalakina-kiya-wa wurringidarringka-kiya, “Wayi! Wurring-engkirrikiya-langwa, Ada akwa Jila. Ngayuwe-ka ningena ningenu-wardangumurra nuwilyaba nenungkwarba mena adinuba-wiya enuwa ngini-ngaja-mubaba. ");
INSERT INTO aoi_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Kenu-wardangu-manja warningerribirra warnumamalya Keyina-manja, kembirra ka-jungwunuma wurrumangbala wurrambilyuma warnumamalya. Umba kabu-wardena-manja wurrukwala ngayuwa-manja, kembirra aburraja 77 warnumamalya aburramba-langwa ka-jungweyinama wurrakina-da,” ni-yama Lameka arakba-da. ");
INSERT INTO aoi_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Nakine-ka Eduma akwa dadingiyenikba Yiba nen-arrangbama ngarningka nuwilyaba nangariya. Ni-rukwularrinu-mulangwa nakina, dirndenikba Yiba yingi-yama, “Neningikarrawara ngarningka nginu-kwama naka niyukwujiya. Nuwilyaba naburraka ni-jungwuma nakina mena nenu-wardangu-mubaba nakina Keyina. Kembirra nenaka kinuma-menama ena-langwa mamurukwa,” yingi-yama. Biya kembirra yingini-yengbijuwama Jeda, mena akina ekirra Jeda ne-yaminama “nginu-kwama.” ");
INSERT INTO aoi_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Kembirra n-arumidinu-manja nakina Jeda, n-akumajungwuma nakina nenikuwenikba. Biya nenimikirra nakina Yinaja. Umba akini-yada wurrumurndakakine-ka warnumamalya narr-aburradadangumurra warningadinuba-wiya narri-yengbijuwama Yaweya-langwa ekirra akwurdukwurda neni-yangmarngkwajuwa-manja nakina. ");
INSERT INTO aoi_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","2","Eneja neni-ngekburaka-manja Neningikarrawara warnumamalya, neni-ngekburakama wurrakina wuburra enuwa Neningikarrawara. Nenungkwarba akwa didarringka nenilirraki-ngekburakama nakina. Biya kembirra ni-yengbinuma nakina eningaba ayakwa aburnuwa-wa akwa ni-yama, “Yikini-yengbijajungwunama ‘kinenumamalya-kiya’ kinalakina.” Kembirra amurndakenena ekirra Eduma-langwa-langwa wurrumirumirena warnikinikaduwa-langwa. ");
INSERT INTO aoi_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Nakine-ka Eduma 130 mamarika iya yinungkwura n-ambilyuma nakina, biya nenikuwenikba enuwa wuburra n-akumajungwunuma nakina. Neni-yengbijuwama nakina Jeda. ");
INSERT INTO aoi_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Bi...ya ngarningka 800 mamarika iya yinungkwura n-ambilyuma nakina akwa wurrukwala ngarningka wurriyukwayuwa ena-langwa n-akumajungwunuma. ");
INSERT INTO aoi_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Biya n-ambilyu-manja nakina 930 mamarika iya yinungkwura kembirra ni-jungwuma arakba-da. ");
INSERT INTO aoi_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Eneja kembirra n-ambilyu-manja nakina Jeda 105 mamarika iya yinungkwura n-akumajungwunuma arakba nakina nenikuwenikba nenimikirra Yinaja. ");
INSERT INTO aoi_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Bi...ya ngarningka 807 mamarika iya yinungkwura n-ambilyuma nakina akwa wurrukwala ngarningka wurriyukwayuwa ena-langwa n-akumajungwunuma. ");
INSERT INTO aoi_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Biya n-ambilyu-manja nakina 912 mamarika iya yinungkwura kembirra ni-jungwuma arakba-da. ");
INSERT INTO aoi_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Eneja kembirra n-ambilyu-manja nakina Yinaja 90 mamarika iya yinungkwura n-akumajungwunuma arakba nakina nenikuwenikba nenimikirra Kenena. ");
INSERT INTO aoi_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Bi...ya ngarningka 815 mamarika iya yinungkwura n-ambilyuma nakina akwa wurrukwala ngarningka wurriyukwayuwa ena-langwa n-akumajungwunuma. ");
INSERT INTO aoi_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Biya n-ambilyu-manja nakina 905 mamarika iya yinungkwura ni-jungwuma arakba-da. ");
INSERT INTO aoi_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Eneja kembirra n-ambilyu-manja nakina Kenena 70 mamarika iya yinungkwura n-akumajungwunuma arakba nakina nenikuwenikba nenimikirra Meyilelela. ");
INSERT INTO aoi_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Bi...ya ngarningka 840 mamarika iya yinungkwura n-ambilyuma nakina akwa wurrukwala ngarningka wurriyukwayuwa ena-langwa n-akumajungwunuma. ");
INSERT INTO aoi_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Biya n-ambilyu-manja nakina 910 mamarika iya yinungkwura ni-jungwuma arakba-da. ");
INSERT INTO aoi_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Eneja kembirra n-ambilyu-manja nakina Meyilelela 65 mamarika iya yinungkwura n-akumajungwunuma arakba nakina nenikuwenikba nenimikirra Jereda. ");
INSERT INTO aoi_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Bi...ya ngarningka 830 mamarika iya yinungkwura n-ambilyuma nakina akwa wurrukwala ngarningka wurriyukwayuwa ena-langwa n-akumajungwunuma. ");
INSERT INTO aoi_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Biya n-ambilyu-manja nakina 895 mamarika iya yinungkwura ni-jungwuma arakba-da. ");
INSERT INTO aoi_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Eneja kembirra n-ambilyu-manja nakina Jereda 162 mamarika iya yinungkwura n-akumajungwunuma arakba nakina nenikuwenikba nenimikirra Yinakwa. ");
INSERT INTO aoi_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Bi...ya ngarningka 800 mamarika iya yinungkwura n-ambilyuma nakina akwa wurrukwala ngarningka wurriyukwayuwa ena-langwa n-akumajungwunuma. ");
INSERT INTO aoi_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Biya n-ambilyu-manja nakina 962 mamarika iya yinungkwura ni-jungwuma arakba-da. ");
INSERT INTO aoi_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Eneja kembirra n-ambilyu-manja nakina Yinakwa 65 mamarika iya yinungkwura n-akumajungwunuma arakba nakina nenikuwenikba nenimikirra Midijela. ");
INSERT INTO aoi_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","24","Biya kembirra Yinakwa akwa ngawa Neningikarrawara wunalakina neni-yakeyinumurra arakba wunalakina-da. Bi...ya wurrukwala ngarningka wurriyukwayuwa n-akumajungwunuma nakina Yinakwa. Biya n-ambilyu-manja nakina 365 mamarika iya yinungkwura, kembirra ni-lyumaduma nakina. Eneja Neningikarrawara nenu-manguma kembirra-da. ");
INSERT INTO aoi_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Eneja kembirra n-ambilyu-manja Yinakwa-langwa nenikuwenikba nakina Midijela 187 mamarika iya yinungkwura, n-akumajungwunuma arakba nakina nenikuwenikba nenimikirra Lameka. ");
INSERT INTO aoi_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Bi...ya ngarningka 782 mamarika iya yinungkwura n-ambilyuma nakina akwa wurrukwala ngarningka wurriyukwayuwa ena-langwa n-akumajungwunuma. ");
INSERT INTO aoi_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Biya n-ambilyu-manja nakina 969 mamarika iya yinungkwura ni-jungwuma arakba-da. ");
INSERT INTO aoi_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Eneja kembirra n-ambilyu-manja nakina Lameka 182 mamarika iya yinungkwura n-akumajungwunuma arakba nakina nenikuwenikba. ");
INSERT INTO aoi_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Biya ni-yama, “Yaweya nakina ni-kbajame-ka akina ajiringka. Kembirra ngalaja nuw-arriyaduma akina. Umba naka niyukwujiya kin-arumidina-manja akenu-werringekburakinama akwa kini-yukwujiyakinama nakina ebina aruma warka ngarrababurna-langwa ngarnumamalya,” ni-yama Lameka nakina-da. Kembirra neni-yengbijuwama nakina niyukwujiya ena-langwa nenimikirra Nawa, mena akina ekirra Nawa ne-yaminama “akenu-werringekburakinama.” ");
INSERT INTO aoi_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Bi...ya ngarningka 595 mamarika iya yinungkwura n-ambilyuma Lameka akwa wurrukwala ngarningka wurriyukwayuwa ena-langwa n-akumajungwunuma nakina. ");
INSERT INTO aoi_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Biya n-ambilyu-manja nakina 777 mamarika iya yinungkwura ni-jungwuma arakba-da. ");
INSERT INTO aoi_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Eneja kembirra n-ambilyu-manja nakina Nawa 500 mamarika iya yinungkwura n-akumajungwunuma arakba wurriyukwayuwa ena-langwa. Neningadinuba-wiya nenimikirra Jema, neninguwilyarra nenimikirra Jebeda, umba neningarija-langwa nenimikirra Yema. ");
INSERT INTO aoi_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","2","Wurrumurndakakine-ka warnumamalya nuw-ababurnadinuma arakba wurrakina akwa nuw-errbalinuma eminingka-manja iya eminingka-manja angalya. Kembirra aburraja wurrukwala warninikuwena Neningikarrawara-langwa na-likenuma nuw-ambilyu-murruwa wurrakina warnumamalya. Biya narrawurraki-rringka-manja wurrumurndakakina warnumamalya, narra-rringkama wurradidiyara wurrukukwulyubene-ka wurrakina. Biya kembirra narra-manguma aburra-langwi-yada wurridarringka. ");
INSERT INTO aoi_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","4","Aburraja kembirra wurradidirrungwarna warnumamalya wurrumumirajirrirre-ka namurndak-ambilyuma arakba. Wurriyukwayuwa akwa wurrumirumirarrngwa wurrumurndakakina-langwa warninikuwena Neningikarrawara-langwa akwa ngawa wurradidingiyarrngwa-langwa wurrakina-da. Wurrarrubude-ka wurrakina, kembirra aburraja wurruminukwala narra-yarrumurnduwarnuma wurrakina-langwa-da. Eneja nakina Yaweya ni-yama, “Nara ngayuwa a-ngayinduma aduwaba warningerribirra warnumamalya ambilyuma warningangkawura. Umba kuw-eniyuwangkwudinama wurrakina biya ka-jungweyinama, warnumamalya-baba wurrakina-da. Kembirra aduwaba-langwa kuw-ambilyamurra wurrakina 120 mamarika iya yinungkwura akwa akina-bina ngawa-da.” ");
INSERT INTO aoi_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Kembirra nenumurndaki-rringka-manja Yaweya warningerribirre-ka warnumamalya, nare-ka, aburraja wurruwurruwurrariya-wiye-ka wurrilyengma wurrakina wurrababurna-langwa. Nuw-engkingkirrikenume-ka wurrumurndakakina awurruwurrariya-we-ka ngawa. ");
INSERT INTO aoi_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Eneja ni-yama nakina Yaweya, “Karukwa, nara-maka warna ka-ngekburaka, nara-maka enena-manja angalya k-akumarna,” ni-yama. ");
INSERT INTO aoi_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Biya ngarningka ni-yama nakina, “Wurrumurndakenene-ka warnumamalya warna ka-ngajinama ka-jungweyinama. Ningarra-ngekburakama akena amandangwa ka-jungwajinama wurrakina ka-jungweyinama ningena-da. Akwa ngarningka yinungungwangba-murriya iya wurrajija-murriya aburrajukwaba ka-jungwajinama ngayuwa-da. Karukwa, nara-maka ka-ngekburaka,” ni-yama Yaweya nakina-da. ");
INSERT INTO aoi_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Akena nenu-werrungwur•dangume-ka Nawa-manja nakina-da. ");
INSERT INTO aoi_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","10","Enene-ka arakba alawudawarra Nawa-langwa. Eneja nakina wurrabiyakarbiya warninikuwena, umba warnimikirra Jema iya Yema akwa Jebeda. Neningabe-ka nakina nenungkwarba n-ambambilyumurra. Nikikamarra awurrariya. Nare-ka wurribina warningaba umba enuwa yimbukwa. Biya nakina Nawa neni-yakeyinuma Neningikarrawara-manja-da. ");
INSERT INTO aoi_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Aburraja wurrukwale-ka warnumamalya wurruwurrariya-wiye-ka wurrababurna-langwa. Biya wurrumurndakakina na-ngajingajeyinume-ka arngkababurna-langwa wurrumurndakakina warnumamalya. ");
INSERT INTO aoi_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Eneja Neningikarrawara angaluba n-andeyuma akena nenuwurraki-rringkama wurrumurndakakina warnumamalya. Wurruwurrariya-wiye-ka ngawa wurrilyengma wurrakina-da. ");
INSERT INTO aoi_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Biya ni-yama Neningikarrawara Nawu-wa, “Ngayuwa ningena arakba wurrumurndakeyina warnumamalya kawurraki-jungwajinama wurrababurna-langwa mena namurndak-arriyakajungwunuma ababurna-langwa awurruwurrariya. ");
INSERT INTO aoi_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Kembirra yirra-ngayindenama nungkuwa kuma-ngekburakinama mijiyanga. Mini-ngekburakajungwuna makina yininginingaba-murra yimundungwa. Biya kuma-ngekburakina-manja makina, ababurna angalya ki-ngekburakinamurra makina-manja mijiyanga. Biya kum-akumurne-ka minyadirra eka-manja arrawa-langwiya akwa ngawa ngarningka errekba-langwiya nari-yada awiyebuma akungwa mijiyangu-wa. ");
INSERT INTO aoi_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Kuma-ngekburakinama makina milingajirrirre-ka, angaluba amarra-langwa akwa ngawa ngarningka angerriba mamudakbu-wa 133 metres. Akwa kuma-ngekburakiname-ka makina mamakwulyumide-ka angalya, ningkekalyarra-langwa akwa ningkekbuda-wa 22 metres. Akwa ajiringka-langwa akwa angerriba karrawaru-wa ngarningka 13 metres kuma-ngekburakinama makina. ");
INSERT INTO aoi_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Akwa meningikarrawara ngarningka kuma-ngekburakinama. Akwa meningikarrawara-manja arrawa-langwiya eyukwujiya ki-lalikinama angwurn•dikirra 44 centimetres. Akwa ki-ngekburakinama angalya angwurrkabiyakarbiya akwa ke-yuweyinama karrawaru-wa. Akwa akawiyuwiyeba akididijungwa ngarningka k-akumurna. ");
INSERT INTO aoi_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","“Nganja ningena ki-larrkajama akungwa enenu-wa ajiringka, kajungwa awurrakibina yelakwa kuw-ambilya-murrumurra kamurndaku-wurrileni-yada. Kembirra akwala awurrakakina kawurraki-jungweyinama umba nungkwaja ningkena ningkeniba k-ambilyama. ");
INSERT INTO aoi_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Nganja ki-yarrkakumurnama ngayuwa ayakwa eningarumuruma nungkwa-langwi-yada akwa nara ngayuwa a-yarrkuwarrukwajuma. Nungkwaja kembirra ku-menama nungkwamba-langwa enena ayakwa nungkwa-langwi-yada akina. “Biya kembirra yik-awiyebenama nungkuwa iya nungkwa-langwa dadingiyena mijiyangu-wa akwa nungkwa-langwa nenikuwena-murriya iya wurradidingiyarrngwa. ");
INSERT INTO aoi_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","20","Kinuwurraku-warakinama nungkwa-langwu-wa mijiyanga yiminiminingka yinungungwangba akwa ngawa wurriminiminingka wurrajija. Biya yuwurrakibina-langwa yinungungwangba-murriya iya wurrajija-murriya yuwilyuwilyaba-wiya ngawa yinungkwarba akwa yuwilyuwilyaba-wiya ngawa yidarringka kinu-menama kin-arrikuwarakinama arrawu-wa kajungwa warniba kawurrak-ambilyi-yada. ");
INSERT INTO aoi_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Biya ku-wilyakiname-ka aninga, engka iya engka aninga nungkwurra-langwi-yada akwa ngawa yuwurrakakina-langwi-yada yinungungwangba-murriya akwa wurruwurrakakina-langwi-yada wurrajija-murriya,” ni-yama nakina Neningikarrawara Nawu-wa-da. ");
INSERT INTO aoi_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Eneja Nawa ni-yamame-ka yakwujina makina-manja mijiyanga ebina-langwiya ayakwa nenu-maka-murrilangwiya Neningikarrawara amurndakibina-langwiya ni-ngayindangu-murrilangwiya-da. ");
INSERT INTO aoi_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Kembirra eneja nakina Yaweya ni-yama Nawu-wa, “Likajama arakba mijiyangu-wa nungkuwa akwa nungkwa-langwa warnumamalya. Ngayuwa ningeningma nungkuwa yimbukwa aduwaba ningk-ambilyame-ka amurndakeyina-manja angalya ningkuwerrikidirrbura ningkuwilyaba-ma. ");
INSERT INTO aoi_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Kin-arrikawiyebajina yimurndakukwala yinungungwangba-murriya makinu-wa mijiyanga. Biya yimurndakukwala yik-alyubarina-murruwiya kirrakina karnumamalya kinu-mena, kin-arrikawiyebajina yimangbala yambilyuma yinungkwarba umba ngarningka yimangbala yambilyuma yidarringka kin-arrikawiyebajina. Akwa yuwurrakukwala yukwurdukwurda ngarningka kembirra kin-arrikawiyebajina yakina yibina nara alyubaruma nungkwurruwa. Yuwurrakakina-langwa yuwilyaba-ma yidarringka kinu-mena akwa yinungkwarba. ");
INSERT INTO aoi_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Akwa ngarningka warnungkwarba ka-mena wurrajija wurrumangbala wurrambilyuma akwa ngarningka wurridarringka ka-mena wurrumangbala wurrambilyuma. Biya yuwurrakakina kinuwurraku-warakina yinungungwangba-murriya akwa wurrajija-murriya kajungwa eniba kuw-ambilyi-yada aduwaba, kajungwa ngarningka kuw-arrangbijeyini-yada enena-manja angalya ngarningka ambaka-murri-yada-da. ");
INSERT INTO aoi_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","“Mamangbala-manja mambilyuma marringa nganja ningena kini-larrkajama yelyukwa. Ngalaja yakina ngawa yelyukwa kini-larrinama yanda-langwa arngkabiyarbuwa-ma arngkumemberrkwa marringa iya mamawura. Yakina ngawa kini-larrinama yelyukwa. Kembirra amurndakibina ngayuwa yelakwa ningi-ngekburakama enena-manja angalya, wurrajija-murriya, yinungungwangba-murriya akwa ngarningka warnumamalya, yakine-ka yelyukwa kawurraki-jungwajinama,” ni-yama Yaweya Nawu-wa-da. ");
INSERT INTO aoi_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Kembirra eneja Nawa ni-yamama ebina Yaweya nenu-makama, ni-yamama nakina ababurna-langwa-da. ");
INSERT INTO aoi_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Akini-yada ni-larrinu-manja yiningadinuba-wiya yelyukwa yakina, nakine-ka Nawa n-ambilyuma arakba 600 mamarika iya yinungkwura. ");
INSERT INTO aoi_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","N-awiyebenuma nakina arrawa makinu-wa mijiyanga, Nawa iya dadingiyenikba iya warninikuwena akwa ngawa wurradidingiyarrngwa. Nuw-awiyebeyinuma wurrakina kajungwa warniba kuw-ambilyi-yada. ");
INSERT INTO aoi_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Yuwurrakakine-ka yababurna-langwa yinungungwangba-murriya yinungkinungkwarba akwa yididarringka akwa wurrajija-murriya warnungkinungkwarba akwa wurrididarringka aburrajukwaba nawurrak-awiyebeyinuma arakba arrawa makinu-wa mijiyanga. Amurndakibina enikalyelyubara iya ebina akwurdukwurda nawurrak-awiyebenuma-da. ");
INSERT INTO aoi_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","Nuw-awiyebeyinume-ka ebina-langwiya ayakwa nenu-maka-murrilangwiya Neningikarrawara Nawa-manja. ");
INSERT INTO aoi_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Bi...ya nuw-embimbirrarina ngawa wurrakinu...wa, bi...ya arakba mamangbala mambilyuma marringa. Kembirra ngalaja yiningadinuba-wiya yelyukwa ni-larrina arakba ajiringka-manja yakina-da. ");
INSERT INTO aoi_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Umba eneja Nawa neniyuwangkwe-ka nakina. N-ambilyume-ka 600 mamarika iya yinungkwura arakba nakina. Ngalaja yuwilyaba yimawura nu-wurdanguma arakba yakina. Biya yirmbulirra arakba yakina. Kembirra ngalaje-ka akungwa angaluba arrawa-langwa ajiringka-langwa amukwa-langwa nuw-aburrumbijanginuma adirrungwarne-ka akungwa akina. Akwa ngarningka angaluba angubina na-ngwurrkbalijajungwunuma akina. Umba karrawara-langwa ni-larrinuma yelyukwa yadirrungwarna yakina-da. ");
INSERT INTO aoi_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Yakine-ka ngawa ni-larrilarrinuma yakina yelyukwa umba nara kinu-ngwanjina. Arngkabiyarbuwa-me-ka arngkumemberrkwa marringa iya mamawura ni-larrilarrinuma yiningangkawura yakina-da. ");
INSERT INTO aoi_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Umba mibina-manja ngawa mamawura, yiningadinuba-wiya yelyukwa ni-larrinu-manja yakina, nuw-awiyebena aburraja Nawa iya dadingiyenikba iya warninikuwena, Jema, Yema iya Jebeda, akwa wurradidingiyarrngwa. Nuw-awiyebeyinume-ka mibinu-wa mijiyanga narruma-ngekburaka-murruwa. ");
INSERT INTO aoi_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Yuwurrakababurne-ka yakina yinungungwangba akwa wurrajija ebina erriberriba waka nuw-ambilyuma umba ebina waka warnumamalya narr-akwurrajuwa-murrumurra namurndak-awiyebeyinuma ngalajukwaba mijiyangu-wa waka yarumuruma akwa yiyukwayuwa. ");
INSERT INTO aoi_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Yinungkwarba akwa yidarringka yambambilyuma-wiya yiningerribirra yibina ni-ngengkuwanginuma yakina nuwurraku-warakama makinu-wa mijiyanga Nawa. ");
INSERT INTO aoi_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Ebina nenu-makama Neningikarrawara Nawa-manja ni-yamama arakba nakina-da. Kembirra arakba makina mijiyanga Yaweya numa-didumurra-da. Ni-didumurra arakba akawiyuwiyeba akina-da. Aburraja Nawa-murriya arrawa arakba makina-manja mijiyanga. ");
INSERT INTO aoi_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Kembirra arakba ngalaja yakina yelyukwa ni-larrinuma angalube-ka karrawara-langwa arngkabiyarbuwa-ma arngkumemberrkwa marringa iya mamawura. Akwa ngarningka akungwa wake-ka arrawa-langwa ajiringka-langwa na-bulbeyinuma akina. Na-wurumbijuwame-ka ebina angalya. Biya nuw-arumidinume-ka ngawa na-diduminuma akina akungwa yanda-langwa numi-yirrmanguma mijiyanga makina. ");
INSERT INTO aoi_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Akine-ka akungwa nuw-arumurumidinume-ka na-ngwujungwujiradinumurra akina, yanda-langwe-ka numu-warrinuma erribirra makina mijiyanga. Na-wilyakama akungwa angerriba iya angerriba makina. ");
INSERT INTO aoi_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Biya akine-ka akungwa nuw-arumurumidinumurre-ka yanda-langwa yilingajirrirra yinijirra akwa angakarjiyinga angalya adidirrungwarna mama amakwulyumide-ka akina na-wurumbijuwama akina akungwa. ");
INSERT INTO aoi_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Akine-ka ngawa ne-yaminjamama nuw-arumurumidinumurre-ka akina yanda-langwe-ka amakwulyumida na-wurumbijuwama angakarjiyinga-manja angalya karrawara 7 metres arakba akina-da. Umba yakwujina na-ngwanjumurra akungwa arakba-da. ");
INSERT INTO aoi_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Awurrakibine-ka aburraja awurrakukwala, yinungungwangba-murriya, wurrajija-murriya akwa ngarningka warnumamalya, nawurraki-jungweyinumurra awurrakakine-ka ababurna-langwa. ");
INSERT INTO aoi_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Awurrakibina ariba-manja nuw-ambambilyu-murruwiya, awurrakibina na-ngengkuwanginu-murruwiya, nawurraki-jungweyinuma ababurna-langwa-da. ");
INSERT INTO aoi_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Nakine-ka eneja Yaweya nuwurraki-jungwajuwama awurrakakina ababurna-langwa-da. Umba eneja yimbukwa Nawa iya wurruwurrakibina ena-langwa dadingiyenikba iya warninikuwena iya wurradidingiyarrngwa akwa yinungungwangba-murriya yuwurrakibina nawurrak-awiyebeyinuma mijiyangu-wa wurrakina yimbukwa warniba nuw-ambilyuma makina-manja mijiyanga. ");
INSERT INTO aoi_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Bi...ya ngalaja ngawa akungwa amakwulyumida angalya nuw-ambilyumurra yanda-langwa yimangbala yimawura nu-wurduwurdanguma yakina-da. ");
INSERT INTO aoi_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Eneja Neningikarrawara nara nakina kini-yakuwabijuwa Nawa akwa yuwurrakibina yinungungwangba-murriya, wurrajija-murriya mibina-manja mijiyanga. Biya arakba arrirra ni-larrkama nakina Neningikarrawara kajungwa ke-ngburingkadini-yada akungwa akwa ka-larrini-yada akina. ");
INSERT INTO aoi_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Umba ngalaja ebina na-bulbeyinumurra angaluba ajiringka-langwa akina arakba na-didijungwuma akwa angubina ngarningka na-didijungwuma nari-yada kini-ngkilarrina arakba yelyukwa. ");
INSERT INTO aoi_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Bi...ya arakba akina akungwa kembirra na-larrilarrina, na-larrilarrina, na-larrilarrina akina, yanda-langwa yuwurrakibina yimangbala yimawura nu-wurduwurdanguma arakba. ");
INSERT INTO aoi_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Ngalaja kembirra yimawura arakba yirmbulirra ngarningka. Kembirra angakarjiyinga-manje-ka ngalaja makina num-ambarringama arakba mijiyanga. Emikirra angalya Arareda. ");
INSERT INTO aoi_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Akine-ka ngawa kembirra akungwa na-larrilarrinuma ngawa na-larrilarrinuma akina. Biya ngarningka yambilyuma yimawura nu-wurduwurdanguma arakba. Biya yinikaduwa yimawura arakba yakina. Ngalaja kembirra amurndakibine-ka alingilingajirrirra angalya nuw-ambijangeyinumurra arakba akungwa-langwa na-wurumbijuwa-murrada. ");
INSERT INTO aoi_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Ngalaja kembirra arngkabiyarbuwa-murra arakba arngkumemberrkwa marringa iya mamawura numu-rukwurukwulyuwakenuma. Eneja kembirra n-ambijangajuwama arakba nakina edirra Nawa makina-langwa mijiyanga. ");
INSERT INTO aoi_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","Biya nakina ni-larrkama edirra-langwa yuwilyaba yingwa-da. Umba yakina ngawa n-angkarrinume-ka ni-rukwurukwulyuwakenumurra. Nara kini-lawurradina umba ni-rukwulyuwakenumurra yakina yanda-langwa na-jerridinumurra akina akungwa eningangkawura-da. ");
INSERT INTO aoi_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Kembirra n-embirrarinu-manja yakinu-wa yingwa nakina Nawa, ngarningka arakba n-ambijangajuwa edirra biya ngalamba-langwa darrawurukukwa dakina nanga-larrka arakba dakina, ka-jerridinu-murrikbe-ka akina akungwa. ");
INSERT INTO aoi_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Nanga-larrka dakina akena ngalaja yingu-marrawarne-ka. Angalya akungwa-wiye-ka ambaka akina. Kembirra yingi-rukwurukwulyuwakena biya yingi-lawurradina mijiyangu-wa, nara-baba ebina angalya ngala-langwa dadik-ambarri-yada dakina-da. Biya ni-lawulawaja ayarrka nakina Nawa akwa nanga-rndarrka edirra-langwa akwa nanga-lawurrakajuwa arakba dakina-da. ");
INSERT INTO aoi_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Bi...ya n-embirrarina ngarningka mamangbala mambilyuma marringa nakina Nawa-da. Biya kembirra arakba dibina-murrada darrawurukukwa nanga-larrka ngarningka-da. ");
INSERT INTO aoi_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Kembirra num-awiyebu-manja arakba mamawura biya dubukwaya dakina, ngarningka yingi-lawurradina enuwa-wa. Biya yingu-wilyakama amarda akina makinu-wa mijiyanga. Eningabe-ka engkalye-ka amangwurrajija akina. Eneja Nawa arakba kembirra neningma nakina-da akina arakba akungwa nare-ka ebina-da. ");
INSERT INTO aoi_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Biya ngarningka ambaka n-embirrarinuma mamangbala mambilyuma marringa nakina yakwujina Nawa-da. Biya dakina-murrada ngawa nanga-larrkama ngarningka. Nanga-larrkama dakina akena nara ngalaja kingi-lawurradina enuwa-wa-da. ");
INSERT INTO aoi_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Ebina-wiya makine-ka mijiyanga num-ambarringama makina. Kembirra yimangbale-ka yimawura nu-wurduwurdanguma yakina. Kembirra na-jerridinumurra arakba akina akungwa. Biya yinikaduwe-ka arakba yimawura yakina. Umba eneja Nawa neniyuwangkwa arakba nakina. 601 mamarika iya yinungkwura n-ambilyumurra nakina arakba. Biya kembirra numa-ngwur•dangmajuwama arakba nakina mibina meningikarrawara mijiyanga-da. Biya n-andeyumurra yadikina angerriba akinu-wa angalya akena ne-ngburingkaduma arakba-da. ");
INSERT INTO aoi_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Ngalaja kembirra yambilyuma yimawura nu-wurduwurdanga yakina. Kembirra nara-wiya yinikaduwa yimawura akine-ka angalya namurndaki-ngburingkade-ka arakba. ");
INSERT INTO aoi_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Eneja kembirra arakba Neningikarrawara ni-yama nakina Nawu-wa, ");
INSERT INTO aoi_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“Likaja arakba makina-langwa mijiyanga,” ni-yama. “Jadena, nungkuwa iya dadingiyena iya nungkwa-langwa nenikuwena-murriya akwa wurradidingiyarrngwa. ");
INSERT INTO aoi_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Akwa wurrumurndakakina wurrajija-murriya yinungungwangba-murriya abi-jadena arakba aburrajukwaba,” ni-yama Neningikarrawara. “Wunuwurraku-warakine-ka yada yimurndakeyina yinungungwangba-murriya akwa wurrajija-murriya, kajungwa kuw-arrikarrangbijeyini-yade-ka arakba ngarningka, akwa kuw-ambilyi-yada eminingka-manja iya eminingka-manja angalya,” ni-yama. ");
INSERT INTO aoi_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Eneja kembirra ni-jadinga arakba nakina Nawa-da akwa ena-langwa warnumamalya mibina-langwa mijiyanga-da. ");
INSERT INTO aoi_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Ngalajukwaba nuwurraki-jadangumurra arakba yimurndakibina yinungungwangba nuwurraki-darrbukwajungwunumurra, akwa wurrajija-murriya aburrajukwaba nawurraki-jadanguma nawurraki-darrbukwajungwunumurra-da. ");
INSERT INTO aoi_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Kembirra Nawa nuwurra-murndukwamurra angwarnda akwa nuwurrak-arjiyajuwamurra akina akwa ni-ngekburaka alda kajungwa neniki-daki-yada yinungungwangba Yaweya-langwa. Biya yinungungwangba-murriya yuwilyuwilyaba-wiya nu-manguma, akwa wurrajija wurruwilyuwilyaba-wiya nenu-manguma ebina enikalyelyubara-murruwiya. Biya nara kini-ringandanga umba engkinyungwurra ngawa ni-dakama nakina amurndakakina akina-manja angwarnda. Nakina nuwurraki-dakama akina angerriba Yaweyu-wa akwa neni-yangmarngkwajuwame-ka nakina Yaweya. ");
INSERT INTO aoi_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Eneja Yaweya ni-kirruwanju-manja awurrakakina ni-daka-mulangwa nakina Nawa, ni-yangmarngkwune-ka nakina-da. Biya ni-lyangkiyama arakba nakina Yaweya, “Akina-be-ka ngawa. Nara ngarningka ningena e-yamama e-kbajuma enena ajiringka kuw-arriyakajungwuna-mulangwa warnumamalya awurrariya-langwa. Ningeningme-ka ningena wurrumurndakeyina warnumamalya wurriyukwayuwa-wiye-ka warne-ka ngawa wurruwurrariya. Ebina nuw-engkingkirrikajamurra, na-likajama aburra-langwu-wa mangma, awurrariye-ka akina. Akena nara arakba ningena a-jungwajuma ebina enena-manja angalya kamurndak-ambilyama. Nara arakba ngarningka e-yamama ningena. ");
INSERT INTO aoi_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","“Enena-bina arakba kembirra-da. Aburraja warnumamalya karri-lungkuwabijini-yada aninga-murriya arakba ngarningka enena-manja angalya, akwa karruwurrak-arrangbini-yada ebina-murrada aninga. Ngalaja enena-bina akilarrkardidarra akwa ngawa akilarrkumurndada ke-yuweyinamurra akina-da, yanda-langwa ka-jerridina-manja amurndakenena angalya akina-da. Enena-bina ngawa alyarrngwalyilya akwa meningilida ke-yuweyinamurra ke-yaminjaminamurra ngalajukwaba ngawa-da,” ni-yama Yaweya Nawu-wa-da. ");
INSERT INTO aoi_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Biya kembirra Neningikarrawara ni-yengbinuma eningaba ayakwa nakina-manja Nawa akwa ena-langwa-manja warninikuwena, akwa ni-yama aburruwa-wa, “Wurrababurne-ka wurriyukwayuwa k-akumajungwunama ningkakina kajungwa kuw-ambilyi-yada nungkwa-langwa numirena-murriya warnikinikaduwa ababurna-manja angalya wurrakina-da. ");
INSERT INTO aoi_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Ngalaja yuwurrakeyine-ka yinungungwangba-murriya iya wurrajija-murriya akwa akwalya-murriya kamurndak-akbar•denama nungkwurruwa-langwa. Umba nungkwurraja kirrakina yiku-bungkawadinama amurndakakina-manja. ");
INSERT INTO aoi_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Biya yik-alyubarinama arakba warna wurrajija akwa yinungungwangba-murriya akwa akwalya. Ebina-wiya ngarra-kwama nganja amarda-murriya aningi-yada yik-alyubarini-yada. Umba yimurndakenena yinungungwangba-murriya iya wurrajija-murriya akwa akwalya-murriya ngarra-kwunamurra ngayuwa aduwaba kajungwa yik-alyubarini-yada ababurna-langwa aninga iya akwalya. ");
INSERT INTO aoi_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Akena kum-ambilya-manja ambaka merra makina yakwujina yakina-manja yinungungwangba-murriya, kembirra nara nungkwurraja alyubaruma amadangkwa. Nare-ka kirrakina alyubaruma akina, mena akwanenibike-ka nuw-ambilya-mubaba merra-manja akina. ");
INSERT INTO aoi_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","“Umba kirruwilyaba yiki-lamukwarridina-manja wurruwilyaba-manja warnumamalya, kembirra wurrukwala warnumamalya aburramba-langwa yikabu-banijumindename-ka wurrakina. Umba ngarningka yiningerribirra yinungungwangba-murriya yibina yabarda awinyamba yikenu-wardena-manja karnumamalya-manja, ngayuwe-ka kamini-lawurrakajinama yakina nungkwurra-langwa, akwa kini-jungwajinama ngayuwa yakina yabubarda-da. ");
INSERT INTO aoi_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Ngayuwa ngarra-ngekburakama karne-ka karnumamalya wuburra ngayuwa Ningeningikarrawara. Akina-langwa kirruwilyaba karnumamalya yiki-lamukwarridina-manja wurruwilyaba-manja warnumamalya biya ka-jungwuna-manja wurrakina, kembirra aburraja wurrakina warnumamalya yikabi-ngajinama kirrakina-manja-da. ");
INSERT INTO aoi_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","“Umba nungkwurraja wurrababurna wurriyukwayuwa yik-akumajungwunama kirrakina kajungwa nungkwurra-langwa wurrumirumirenungwa warnikinikaduwa kuw-ambilyi-yada eminingka-manja iya eminingka-manja angalya wurrakina,” ni-yama Neningikarrawara Nawu-wa akwa ena-langwu-wa warninikuwena. ");
INSERT INTO aoi_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Biya ngarningka ni-yama Neningikarrawara aburruwa-wa, ");
INSERT INTO aoi_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“Ngayuwa ningena aduwaba ki-yarrkakumurnama arakba ayakwa eningarumuruma nungkwurra-langwa. Ngalaja akine-ka ayakwa nungkwurra-langwi-yada iya nungkwurra-langwi-yada wurrumirumirenungwa warnikinikaduwa-langwi-yada. ");
INSERT INTO aoi_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","Amandangwa nungkwurra-langwi-yada kirrababurna-langwa akina akwa ngarningka amurndakibina-langwa yelakwa nawurrak-ambilya-murrilangwa aduwaba ne-ngengkuwangina-murrilangwa, amurndakibina-langwa kirruwurraki-jadijuwa-mulangwa mijiyanga-langwa nungkwurruwa. ");
INSERT INTO aoi_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Amurndakeyina-bina ayakwa eningarumuruma aduwaba ngarra-makinama nganja. W-engkirrikiya! Aduwaba-langwa nara ngarningka amurndakibina ningi-yamama enena-manja angalya nara arakba ningena e-yamama. Nara ningena a-larrkama arakba yamakwulyumida yelyukwa, akwa nara a-lyurrkwuma a-wurumbijuma amurndakenena angalya ababurna-langwa akungwa-murra akwa nara a-jungwajuma wurrababurna-langwa warnumamalya iya wurrajija iya akwalya akwa ngawa yinungungwangba-murriya. ");
INSERT INTO aoi_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","13","“Ngayuwa kembirra ningena arakba ka-wilyakajinama kirrakina nganyangwa ayakwa eningarumuruma nara amurndakakina a-yarrkuwarrukwajuma. Akine-ka ngawa ke-yaminama eningangkawura nungkwurra-langwi-yada akwa amurndakibina-langwa ne-ngengkuwangina-murrilangwa ababurna-langwa. Ningena kembirra kamin-akumurnama karnumamalya-langwa daka duwurruwilya angubina-manja. Nungkwurraja kembirra yikinga-rringkina-manja daka karna karnumamalya yiki-yakuwerribikajama nganyangwu-wa ayakwa eningarumuruma-wa. Kembirra ambaka-murra aburraja wurriyukwayuwa nungkwurra-langwa karringa-rringkinama dakina akwa ngawa aburra-langwa wurriyukwayuwa aburrajukwaba. Karringa-rringkina-manja dakina wurrakina ke-yakuwerribikajama nganyangwu-wa ayakwa eningarumuruma-wa. Ngalaja duwurruwilya kingi-jirrkumakajungwunama dakina. ");
INSERT INTO aoi_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Kembirra ku-wurumbijina-manja ngayuwa angubina, akwa king-akumurna-manja dakina duwurruwilya angubina-manja, ");
INSERT INTO aoi_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","kembirra ki-yakuwerribikajama ngayuwa nganjukwaba nganyangwu-wa ayakwa ngarra-makina-murruwa nungkwurruwa-wa aduwaba. Akwa nganyangwa ngarningka ayakwa enena yinungungwangba-murriya-langwa iya wurrajija-murriya-langwa amurndakibina nawurrak-ambilya-mulangwa enena-manja angalya aduwaba. Ngayuwa ningena ngarra-makinama aduwaba, nara ngarningka a-wurriluma amurndakakina-da. ");
INSERT INTO aoi_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","17","“Kembirra yikinga-rringkina-manja nungkwurruwa dakina duwurruwilya angakuba angubina-manja, nganjukwaba kembirra kinga-rringkina-manja ki-yakuwerribikajama nganyangwu-wa ayakwa eningarumuruma-wa eningangkawura. Kembirra ngayuwa akina ki-yamina-manja, ngalaja duwurruwilya kingi-jirrkumakajungwunama dakina enena ayakwa eningarumuruma nganyangwa nara a-yarrkuwarrukwajuma akina. Nare-ka a-yarrkuwarrukwajuma akina umba eningangkawura kuw-ambilyamurra akina nungkwurra-langwi-yada aduwaba. Kuw-ambilyamurra akina nungkwurra-langwi-yada iya wurrababurna-langwi-yada warnumamalya iya ababurna-langwi-yada akwalya-murriya iya yababurna-langwi-yada yinungungwangba-murriya akwa ngawa wurrababurna-langwi-yada wurrajija-murriya,” ni-yama Neningikarrawara Nawu-wa akwa ena-langwu-wa warninikuwena nakina-da. ");
INSERT INTO aoi_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Aburrubukwurraja wurrabiyakarbiya warninikuwena Nawa-langwa nabuk-awiyebeyinuma mijiyangu-wa akwa nabuki-jadanguma wurrubukalakina makina-langwa mijiyanga. Biya warnimikirra Jema iya Yema akwa Jebeda. Yeme-ka nakina nungwenikba Kenina-langwa. ");
INSERT INTO aoi_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Umba wurrumurndakeyine-ka Nawa-langwa warninikuwena nuw-ambilyumurra warningadinuba-wiya warnumamalya na-jerridu-manja ebina akungwa amakwulyumida. ");
INSERT INTO aoi_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Eneja Nawa ni-lungkuwabijuwama aninga-murriya, akwa nakina-bina neningadinuba-wiya ni-lungkuwabijuwama nakina akwurena-da. ");
INSERT INTO aoi_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Biya kembirra ni-ngekburakama akina akwurena-langwa amalyirra. Biya Nawa akwa ena-langwa warnumamalya wurrakina ne-bekeyinuma akina amalyirra. Biya arngkawura ni-bekinume-ka nakina Nawa akina akwurena-langwa amalyirra ni-ngekburaka-mulangwa, biya nu-bungwurride-ka nakina. Biya nakina Nawa nang-aburawaka dumbala ena-langwa akwa nu-mungkwulinga neyebirra ena-langwa-manja nanga-likiraka-murrumanja kalikwa nakina-da. ");
INSERT INTO aoi_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Eneja nenikuwenikba Yema nibina nungwenikba Kenina-langwa nubukwaya ni-likena nakinu-wa nungwenikba, biya neni-rringke-ka nabalmungkwur•da nakina. Biya ni-likena nakina akwa nenilirraku-maka ena-langwu-wa wunambilyuma nawenikba-kiya. ");
INSERT INTO aoi_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Umba aburnaja wunalakina Nawa-langwa wunaruma-murrikiya-dangwa warnikuwabulena-kiya neninga-wilyakama wunalakina dumbala enuwa-wa. Biya nening-alyilyadijuwama mirirrba-langwiya akwa kembirra neni-likenuma mirirrba-ma nungwarringba-wa nibina nu-kukwunumurrkwulu-murruwa. Biya nenu-wurumbijuwama dakina dumbala enuwa-manja nara-baba keni-ngayindanga keni-rringka nakina neyebirra-da. Biya nening-akumarnu-mulangwa kembirra dumbala nungwarringba-manja neni-likena arakba wunalakina-da. ");
INSERT INTO aoi_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Eneja kembirra Nawa n-eningabada arakba nakina. Akwa ni-likena akwa nare-ka, nu-werrikawinyambadinume-ka arrawa yukwudukwuda-manja nakina, n-engkirrikenu-mulangwa ni-yama-mulangwa ena-langwa niyukwujiya-da nenikuwenikba-da. ");
INSERT INTO aoi_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","Biya nakina Nawa arakba neni-kbajama Yemu-wa-da akwa ena-langwu-wa wurrumirumirena warnikinikaduwa-wa-da. Biya ni-yama nakina kembirra, “Ningene-ka ningeni-kbajinama Keninu-wa. Kembirra yadikina ena-langwa wurrarrkwurrkuwena ka-bungkawadinama enuwa-manja. ");
INSERT INTO aoi_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Umba nganja ningena ningeni-yangmarngkwajinama Yaweya nibina Neningikarrawara Jema-langwa. Eneja nakina Jema kinu-bungkawadinamurra Kenina-manja. ");
INSERT INTO aoi_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Kembirra eneja nakina-manja Jebeda kenu-kwunamurra wurrababurna wurriyukwayuwa Neningikarrawara, akwa kuw-ababurnadinama wurrakina. Akwa ngarningka wurrumirumirena Jebeda-langwa kawurrak-ambilyama wurrakina Jema-langwa-manja warnumamalya wurruwurrakawura-murra. Kembirra Jebeda kinu-bungkawadinama enejukwaba Kenina-manja,” ni-yama Nawa. Umba akina ekirra Jebeda ne-yaminama “kuw-ababurnadinama.” ");
INSERT INTO aoi_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Biya akina kembirra na-jerridu-manja ebina akungwa adirrungwarna-dangwa kembirra arakba nakina Nawa n-ambilyumurra 350 mamarika iya yinungkwura ngarningka. ");
INSERT INTO aoi_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Biya n-ambilyu-manja 950 mamarika iya yinungkwura nakina ni-jungwuma arakba-da. ");
INSERT INTO aoi_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Amurndakenena ekirra nuw-arrikarrijajungwunama akina Nawa-langwa wurrumirumirena warnikinikaduwa-langwa. Nawa-langwa warninikuwena wurrabiyakarbiya nabuk-ambilyumurra wurrubukalakina Jema iya Yema akwa Jebeda. Biya kembirra na-jerridu-manja ebina akungwa amakwulyumida ababurna-langwa wurrubukalakina kembirra nabuk-akumajungwunuma arakba warninikuwarrngwa. ");
INSERT INTO aoi_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Aburraja kembirra warna Jebeda-langwa warninikuwena. Warnimikirra wurrakina Kawuma iya Mekeka iya Madaya iya Jabana iya Dubala iya Mejeka akwa ngawa Diraja. ");
INSERT INTO aoi_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Akwa warna ngarningka warninikuwena naruma-langwa Kawuma-langwa. Warnimikirra wurrakina Ajikeneja iya Ribada akwa ngawa Dakarma. ");
INSERT INTO aoi_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Akwa warna ngarningka warninikuwena nenikumarnjenikba-langwa Jabana-langwa. Warnimikirra wurrakina Elija iya Beyina iya Jaburija akwa ngawa Rawuda. ");
INSERT INTO aoi_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Kembirra aburraja wurrumirumirarrngwa wurrakina-langwa Elija-murriya-langwa nuw-errbalinuma arakba wurrumurndakakina mijiyelyu-wa iya ayangkiyangkidarrbu-wa. Umba kembirra wurreyebijeba arakba nuw-ambilyuma wurrumurndakakina wurrilyimberrkwulyumida, wurrilyimberrkuwarra awilyaba-manja angalya umba wurrilyimberrkuwarra ngarningka awilyaba-manja angalya. Wurrumineyebijeba ayakwa ne-yengbeyinuma wurrakina. Wurreyebijeba nawurrak-ambilyumurra wurrumurndakakina akena nuwilyaba-me-ka ngawa neningadinuba-wiya numirarringba Jebeda nakina-da. ");
INSERT INTO aoi_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Umba warna wurruwurrakuwarra warninikuwena Yema-langwa. Nakine-ka Yema nenikumarnjenikba Jebeda-langwa nakina. Warnimikirra warninikuwena Yema-langwa wurrakina Kwuja iya Yijiba iya Libiya akwa ngawa Kenina. ");
INSERT INTO aoi_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Akwa warna warninikuwena naruma-langwa Kwuja. Warnimikirra wurrakina Juba iya Yebila iya Jabuda iya Rama akwa ngawa Jabudeka. Umba Rama-langwa warnikuwabulena-kiya wunenimikirra Juba akwa Didena wunalakina. ");
INSERT INTO aoi_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Umba nuwilyaba ngarningka nenikuwenikba Kwuja-langwa n-ambilyumurra nakina enejukwaba. Nenimikirra nakina Nimurada. Nakine-ka Nimurada neningadinuba-wiya nu-bungkawadinuma wurrukwala-manja warnumamalya wurriminiminingka-manja. Nara ena-langwa-manja wulkwa warnumamalya kinu-bungkawadina nakina umba wurriminingka-manja ngarningka warnumamalya nu-bungkawadinuma nakina. ");
INSERT INTO aoi_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Eneja Yaweya nenu-mamurikajuwama nakina Nimurada-manja. Kembirra nakina Nimurada nabarde-ka nenungkwarba nenik-aburangka wurrajija iya yinungungwangba-murriya. Aminakina-langwa aburraja wurrukwala warnumamalya na-makijeyinama aduwaba wurrakina, “Yaweya kenu-mamurikajinama nungkuwa nungkwajukwaba, kajungwa ningkabarda k-ambilyi-yada nungkuwa ningkakina, wuburra laka arakba-wiya nabarda yinungungwangba-murriya n-ambilyuma Nimurada nakina-da,” ne-yaminama na-makijeyinamurra ayakwa warningaduwaba warnumamalya wurrakina-da. ");
INSERT INTO aoi_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Nakine-ka Nimurada ni-lyingama adinuba-wiya abukalakina angalya emikirra Babulena iya Ereka akwa Akada. Abukalakina angalya nuw-ambilyuma aringbirra-manja angalya emikirra Babuleniya. ");
INSERT INTO aoi_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Biya kembirra akina-langwa angalya Babuleniya-langwa ni-likenuma nakina Nimurada eminingku-wa angalya emikirra Ajiriya. Umba yakwujina ngawa aburraja ena-langwa warnikuminuwar•duwar•da narri-likirakama ababurne-ka alikira. Narri-likilikirakamurra amurndakakina yanda-langwa abiyarbuwa angalya aminababurna alikira nuw-arjeyuma abukalakina, emikirra Niniba iya Riyabadira iya Kela ");
INSERT INTO aoi_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","akwa Rejena. Awilyaba angalya Niniba nuw-ambilyuma alalubaja umba awilyaba angalya Kela adadibina. Ngalaja Rejena wilyarra. Umba akina angalya Kela amakwulyumide-ka angalya akina. ");
INSERT INTO aoi_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Umba eneja Yema-langwa nenikuwenikba Yijiba nenu-wilyakama nakina wurrumangbala wurrambilyuma warninikuwena. Warnimikirra wurrakina Lidiya iya Anama iya Liyaba iya Nabuda ");
INSERT INTO aoi_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","iya Badirija iya Kajila akwa ngawa Kabudawa wurrakina. Nakine-ka Kabudawa, nibina niyukwujiya-dangwa nenikuwenikba Yijiba-langwa, neningadinuba-wiya numirarringba nakina WarninguBilijiya-langwa warnumamalya. Aburraja wurrumirumirena warnikinikaduwa Yijiba-langwa narra-wilyakama wurrakina warnimikirra Lidiya-langwa akwa ena-langwa-langwa wurrarrkwurrkuwena. ");
INSERT INTO aoi_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Eneja Yema-langwa nenikuwenikba Kenina nenu-wilyakama nakina wunambilyuma warnikuwabulena wunenimikirra Jayidina, nibina naruma-dangwa, akwa Yeda. ");
INSERT INTO aoi_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","Umba aburraja wurrukwala ngarningka warninikuwena Kenina-langwa nuw-ambilyumurra wurrakina. Kembirra nakine-ka Kenina neningadinuba-wiya numirarringba wurrababurna-langwa warnumamalya nakina. Wurrumurndakenena warnimikirra: WarningiJebija iya WarningAmawa iya WarningiKikaja ");
INSERT INTO aoi_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","iya WarningiYiba iya WarningArika iya WarningiJeyina ");
INSERT INTO aoi_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","iya WarningArbada iya WarningiJemara akwa ngawa WarningiYamada. Wurrumurndakenene-ka warnumamalya nawurrak-errbalinuma, yanda-langwa wurreyebijeba arakba nuw-ambilyuma wurrumurndakakina wurrilyimberrkwulyumida, wurrilyimberrkuwarra awilyaba-manja angalya akwa wurrilyimberrkuwarra ngarningka awilyaba-manja angalya. ");
INSERT INTO aoi_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","Umba aburra-langwe-ka angalya awilyaba-murra ngawa aruma ekirra Kenina amurndakakina ababurna-langwa. Kembirra akina angalya emikirra Kenina amakwulyumida angalya aringbirra akina. Biya amurndakakina ngawa angalya amurndakibina Kenina-manja ngawa nuw-ambilyumurra akina na-likenuma nuw-errbalinuma amurndakakina Jayidina-langwa akwa engku-wa angerriba nuw-angkarrinu-murruwa arrirra dalada yanda-langwa Kera, ebina nuw-ambilyuma angalya akwudangwa Kajaya. Akwa na-likenuma ngarningka amurndakakina angalya aburra-langwa angerriba engku-wa alyengmilyengmu-wa yanda-langwa Jaduma iya Kamara iya Aduma akwa ngawa Jebawuma, ebina nuw-ambilyuma akwudangwa Leja akina. ");
INSERT INTO aoi_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Umba wurrumurndakibina warnumamalya wurreyebijeba arakba nuw-ambilyuma wurrilyimberrkwulyumida, wurrilyimberrkuwarra awilyaba-manja angalya umba wurrilyimberrkuwarra ngarningka awilyaba-manja angalya. Wurrumineyebijeba ayakwa ne-yengbeyinuma wurrakina. Wurreyebijebe-ka nawurrak-ambilyumurra wurrumurndakakina warnumamalya akena nuwilyaba-murra ngawa neningadinuba-wiya numirarringba Yema nakina-da. ");
INSERT INTO aoi_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Umba eneja nakina Jema, nibina Nawa-langwa nenikuwenikba naruma-dangwa, n-ambilyumurra neningadinuba-wiya nenumamalya WurriYiburuwa-langwa warnumamalya nakina. ");
INSERT INTO aoi_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Warne-ka Jema-langwa wurruwurrakuwarra warninikuwena. Warnimikirra wurrakina Elama iya Ajura iya Arbakijada iya Luda akwa ngawa Arama. ");
INSERT INTO aoi_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Akwa ngarningka warna Arama-langwa warninikuwena. Warnimikirra wurrakina Wija iya Wula iya Keda akwa Mejeka. ");
INSERT INTO aoi_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Umba Arbakijada-langwa nenikuwenikba Jela nakina. Akwa Jela-langwa nenikuwenikba Ebera nakina. ");
INSERT INTO aoi_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Kembirra Ebera nenu-wilyakama nakina wunambilyuma warnikuwabulena. Nuwilyaba Beleka nakina. N-ambilyu-wiya nakina nenungkwarba aburraja wurrababurna-langwa warnumamalya nuw-errbalinumurra wurrakina. Kembirra aminakina-langwa neni-yengbijuwama nakina Beleka nenimikirra, mena akina ekirra Beleka ne-yaminama “nuw-errbalinuma.” Umba narrkuwenikba Beleka-langwa Jakidena nakina. ");
INSERT INTO aoi_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Akwa warna warninikuwena Jakidena-langwa. Warnimikirra Almadada iya Jeleba iya Yajarmabeda iya Jera ");
INSERT INTO aoi_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","iya Yadarama iya Wijala iya Dikila ");
INSERT INTO aoi_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","iya Abala iya Abimeyela iya Juba ");
INSERT INTO aoi_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","iya Abura iya Yebila akwa ngawa Jawubaba. Wurrumurndakenene-ka warninikuwena Jakidena-langwa-da. ");
INSERT INTO aoi_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Umba amurndakakina angalya wurrumurndakakina-langwa warnumamalya na-likenuma Meja-langwa akwa angerriba Jubara-wa nuw-ambilyu-murruwa angalya angakarjiyinga alyengmilyengma-langwa. ");
INSERT INTO aoi_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Umba wurrumurndakakina warnumamalya wurreyebijeba arakba nuw-ambilyumurra wurrilyimberrkwulyumida, wurrilyimberrkuwarra awilyaba-manja angalya umba wurrilyimberrkuwarra ngarningka awilyaba-manja angalya. Wurrumineyebijeba ayakwa ne-yengbeyinuma wurrakina. Wurreyebijeba nawurrak-ambilyumurra wurrakina akena nuwilyaba-murra ngawa neningadinuba-wiya numirarringba Jeme-ka nakina-da. ");
INSERT INTO aoi_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Wurrumurndakakine-ka wurruwurrakwulyumida warnumamalya Nawa-langwa wurrumirumirena warnikinikaduwa wurrakina-da. Narruma-manguma wurrakina mamurukwa Nawa-langwa-langwa warninikuwena yanda-langwa wurrilyimberrkwulyumide-ka wurrilyimberrkeyebijeba iya wurrilyimberrkeyebijeba warnumamalya nuw-ambilyuma wurrakina arakba. Na-walyerre-ka ebina akungwa amakwulyumida, kembirra wurrumurndakakina ngawa warnumamalya wurrilyimberrkwulyumida nawurraki-yebijebakajungwunuma wurrilyimberrkuwarra iya wurrilyimberrkuwarra warnumamalya ababurna-manja angalya wurrakina-da. ");
INSERT INTO aoi_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Biya adinuba-wiye-ka wurruwurrakakina warnumamalya wurribina nuw-ambilyu-murrumurra akini-yada nuw-ambilyumurra engka-manja iya engka-manja angalya, umba awilyaba-me-ka ngawa ayakwa ne-yengbeyinuma wurrakina. ");
INSERT INTO aoi_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Umba alyengmilyengma-langwa ngawa nuw-ambilyumurra. Biya kembirra arakba na-marrawarnuma nawurraki-likenuma wurrakina. Biya arakba narruwurrak-akburrangarna angakbilyuwalya angalya emikirra Babuleniya. Biya yakwujina arakba kembirra nawurrak-ambilyuma wurrakina-da. ");
INSERT INTO aoi_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Biya arakba kembirra wurruwurrakakina warnumamalya na-lyelyimbukweyinuma warniki-ngekburaki-yade-ka alikira. Ne-yama, “Ngarri-ngekburakina alikira amilyumilyinja-murra,” ne-yama. Kembirra narri-ngambajuwama akina amilyumilyinja akungwa-ma. Kembirra narri-ngekburakama akina akwa narr-akumarnuma mardidarra-manja mamawura, ka-dakini-yada akwurraki-yada yanda-langwa akina na-kwurrakidinume-ka. Akwa ngarningka minyadirra makina narruma-wilyakama wurrakina. Biya narr-akumarnuma amurndakakina amilyumilyinja awilyuwilyaba-wiya, akwa ngawa minyadirra ngarningka narrum-akumarnuma wilyarra, kajungwa kuw-abalkayukwuni-yada arrubuda amurndakakina alikira. Biya kembirra narri-ngekburakama wurrakina alikira aburra-langwa amilyumilyinja-murra akina-da. ");
INSERT INTO aoi_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Biya nawurraki-yama wurrakina, “Kwa, ngarri-ngekburakina ababurna alikira. Umba awilyaba akina aki-ngekburakinama, akine-ka alingajirrirra aki-ngekburakinama. Nara amurndakeyina wuburra alikira e-yamama umba jujuje-ka alingajirrirra aki-ngekburakinama,” wurrakina nawurraki-yama. “Enene-ka ngarri-ngayindenama aki-ngekburakinama alingajirrirre-ka, kajungwe-ka angubina-manja kuw-akburrangini-yada akina,” ne-yama. Biya nawurraki-yama wurrakina, “Ngarruwurrakeyine-ka aduwaba ngarri-ngayindenama ngarringbudi-yade-ka ngarna aku-wilyakijeyini-yada, akwa ngarningka aka-wilyakajini-yada ngakwurra-langwa-manja wurrumirumirarrka ngarna ngarrumirumirarrngwa ngarrabarda warka akwa aringkawa. Ngarri-yaminamurra enena aduwaba kajungwa nari-yada angerriba iya angerriba awurra-murrkwuluma ngarruwurrakeyina, umba akuwurrak-ambilyi-yada ngawa awilyaba-murra-manja angalya,” ne-yama. ");
INSERT INTO aoi_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Biya arakba wurrumurndakakina warnumamalya narri-ngekburakama ababurna eyukwayuwa alikira akwa ngawa akina awilyaba alingajirrirra-dangwa alikira. Eneja kembirra ni-dirrirnda angaluba nakina Yaweya kajungwa kenuwurraki-rringkini-yada wurruwurrakakinu-wa. ");
INSERT INTO aoi_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","“Warne-ka wurruwilyaba-ma warnumamalya,” ni-yama, “akwa awilyaba-me-ka ayakwa warna ne-yengbinama,” ni-yama. “Wurrumurndakeyina adinuba-wiya enena alikira narri-ngekburakama. Akwa adinuba ngarningka awurrakibine-ka ngarningka akwala ke-yaminame-ka awurrakakina ngawa. Engka iya engke-ka ke-yaminama eningerribirra karri-ngayindena-manja,” ni-yama. ");
INSERT INTO aoi_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Biya nakina Yaweya ni-yama ngarningka, “Ngakwurruwa kembirra aki-likajamurra arakba ngarna aki-dirrirndama akaminu-kuwarrukwajini-yada ayakwa aburra-langwa, nari-yada kembirra amin-engkirrikajajuma wurrumurndakakina,” ni-yama nakina Yaweya. ");
INSERT INTO aoi_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Biya nakina Yaweya arakbe-ka ni-dirrirnda akwa nenumini-kuwarrukwaja aburra-langwa ayakwa akwa angerriba iya angerribe-ka nenuwurraki-larrkena wurrakina akina-manja angalya. Biya na-ngwanja kembirra wurrumurndakakina warnumamalya, nara karri-ngekburaka amurndakakina alikira-da. ");
INSERT INTO aoi_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Akine-ka angalya narri-yengbijuwama Babulena, mena yakwujina Yaweya nenuminu-kuwarrukwajuwa-mubaba nakina ayakwa, akwa akina ekirra Babulena ne-yamina-mubaba “nu-kuwarrukwajuwama ayakwa.” Biya kembirra Yaweya nenuwurraki-larrkenumurra wurrumurndakakina warnumamalya yadikina engku-wa iya engku-wa angalya nakina-da. Kembirra aburraja na-ngwarndirriyinuma arakba wurrakina-da. ");
INSERT INTO aoi_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Amurndakenena akwala ayakwa Jema-langwa-langwa wurrumirumirena warnikinikaduwa. Na-jerridu-mulangwa ebina akungwa amakwulyumida, kembirra mambilyuma mamarika numu-ngwingbijanguma iya yambilyuma yinungkwura nu-ngwingbijanguma. Kembirra arakba nakina Jema 100 mamarika iya yinungkwura n-ambilyuma nakina, biya n-akumajungwunuma arakba nakina nenikuwenikba nenimikirra Arbakijada. ");
INSERT INTO aoi_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Bi...ya ngarningka 500 mamarika iya yinungkwura n-ambilyuma nakina akwa wurrukwala ngarningka wurriyukwayuwa ena-langwa n-akumajungwunuma. ");
INSERT INTO aoi_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Eneja kembirra n-ambilyu-manja nakina Arbakijada 35 mamarika iya yinungkwura, n-akumajungwunuma arakba nakina nenikuwenikba nenimikirra Jela. ");
INSERT INTO aoi_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Bi...ya ngarningka 403 mamarika iya yinungkwura n-ambilyuma nakina akwa wurrukwala ngarningka wurriyukwayuwa ena-langwa n-akumajungwunuma. ");
INSERT INTO aoi_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Eneja kembirra n-ambilyu-manja nakina Jela 30 mamarika iya yinungkwura, n-akumajungwunuma arakba nakina nenikuwenikba nenimikirra Ebera. ");
INSERT INTO aoi_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Bi...ya ngarningka 403 mamarika iya yinungkwura n-ambilyuma nakina akwa wurrukwala ngarningka wurriyukwayuwa ena-langwa n-akumajungwunuma. ");
INSERT INTO aoi_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Eneja kembirra n-ambilyu-manja nakina Ebera 34 mamarika iya yinungkwura, n-akumajungwunuma arakba nakina nenikuwenikba nenimikirra Beleka. ");
INSERT INTO aoi_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Bi...ya ngarningka 430 mamarika iya yinungkwura n-ambilyuma nakina akwa wurrukwala ngarningka wurriyukwayuwa ena-langwa n-akumajungwunuma. ");
INSERT INTO aoi_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Eneja kembirra n-ambilyu-manja nakina Beleka 30 mamarika iya yinungkwura, n-akumajungwunuma arakba nakina nenikuwenikba nenimikirra Riyuwa. ");
INSERT INTO aoi_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Bi...ya ngarningka 209 mamarika iya yinungkwura n-ambilyuma nakina akwa wurrukwala ngarningka wurriyukwayuwa ena-langwa n-akumajungwunuma. ");
INSERT INTO aoi_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Eneja kembirra n-ambilyu-manja nakina Riyuwa 32 mamarika iya yinungkwura, n-akumajungwunuma arakba nakina nenikuwenikba nenimikirra Jerukwa. ");
INSERT INTO aoi_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Bi...ya ngarningka 207 mamarika iya yinungkwura n-ambilyuma nakina akwa wurrukwala ngarningka wurriyukwayuwa ena-langwa n-akumajungwunuma. ");
INSERT INTO aoi_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Eneja kembirra n-ambilyu-manja nakina Jerukwa 30 mamarika iya yinungkwura, n-akumajungwunuma arakba nakina nenikuwenikba nenimikirra Neyawa. ");
INSERT INTO aoi_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Bi...ya ngarningka 200 mamarika iya yinungkwura n-ambilyuma nakina akwa wurrukwala ngarningka wurriyukwayuwa ena-langwa n-akumajungwunuma. ");
INSERT INTO aoi_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Eneja kembirra n-ambilyu-manja nakina Neyawa 29 mamarika iya yinungkwura, n-akumajungwunuma arakba nakina nenikuwenikba nenimikirra Dera. ");
INSERT INTO aoi_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Bi...ya ngarningka 119 mamarika iya yinungkwura n-ambilyuma nakina akwa wurrukwala ngarningka wurriyukwayuwa ena-langwa n-akumajungwunuma. ");
INSERT INTO aoi_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Eneja kembirra n-ambilyu-mulangwa 70 mamarika iya yinungkwura nakina Dera, n-akumajungwunuma arakba nakina wurrabiyakarbiya warninikuwena warnimikirra Aburema iya Neyawa akwa Yerena. ");
INSERT INTO aoi_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Warna wurriyukwayuwa Dera-langwa. Wurrabiyakarbiya warninikuwena ena-langwa, warnimikirra Aburema iya Neyawa akwa Yerena. Akwa Yerena-langwa nenikuwenikba Lada. ");
INSERT INTO aoi_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Bi...ya Yerena ni-jungwa nakina ena-langwa-manja angalya ni-rukwularru-murrumanja, emikirra Wura. Akine-ka angalya Wura akina-manja aringbirra angalya emikirra Babuleniya. Kembirra yakwujina ngawa ni-jungwuma nakina Yerena n-ambilyu-wiya nungwenikba Dera neniba ambaka. ");
INSERT INTO aoi_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Umba ngalaja Aburema-langwa dadingiyenikba Jeraya dakina, dibina dadiyamarnjenikba umba diminingka dirndadikba. Ne-yaminjamama wurrakina warnumamalya akina-manja angalya akini-yada. Umba Neyawa-langwa dadingiyenibka Milka dakina, dibina dadiyawenikba Yerena-langwa. Eneja nuwilyaba ningka nenikuwenikba Yerena-langwa nakina nenimikirra Yijika. ");
INSERT INTO aoi_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Akena dakine-ka Jeraya duburubura ngawa dadingarijira-ma dakina. ");
INSERT INTO aoi_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Bi...ya kembirra ni-likena arakba nenu-wilyaka nakina Dera nenikuwenikba Aburema akwa numirenikba Lada, nibina ni-jungwu-mulangwa nungwenikba Yerena, akwa ngarningka darngkiyenikba Jeraya, dibina dadingiyenikba Aburema-langwa, akwa narri-lalika arakba akina angalya Wura warniki-liki-yada wurrakina aringbirru-wa angalya emikirra Kenina. Biya na-likena arakba wurrakina-da. Bi...ya narr-akburranga wurrakina akina angalya emikirra Yerena. Aruma angalya aminababurna alikira iya warnumamalya akina. Akwa nuw-ambilyuma yakwujina arakba-da. ");
INSERT INTO aoi_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Kembirra yakwujina ngawa akina-manja angalya ni-jungwa arakba Aburema-langwa nungwenikba, nibina neniyuwangkwa Dera. 205 mamarika iya yinungkwura nakina n-ambilyuma biya ni-jungwa akina-manja angalya-da. ");
INSERT INTO aoi_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Bi...ya eneja Yaweya ni-yama nakina Aburemu-wa, “Wu-lalikina arakba enena angalya nungkwa-langwa iya nungwena-langwa. Akwa wurrawurraki-lalikina arakba wurrumurndakenena warnumamalya nungkwa-langwa enena-manja angalya. Biya ki-likaja arakba angabu-wa angalya eminingku-wa yiba-wilyakajina-murruwa ningkakina,” ni-yama Yaweya Aburemu-wa. ");
INSERT INTO aoi_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Biya nenu-makama ngarningka enena ayakwa enuwa-wa akwa ni-yama, “Yiba-kwunama ngayuwa wurrababurne-ka numirena-murriya warnikinikaduwa. Wurrakine-ka kuw-ababurnadinama yanda-langwa wurrilyimberrkwulyumide-ka wurrilyimberrkuwilyaba warnumamalya kuw-ambilyamurra wurrakina. Umba ngayuwa ki-yaminama eningaba nungkuwa-manja akwa kembirra ningkumikbiyiya ningkakina yanda-langwa wurrababurna warnumamalya kuw-eningmidinama ningkenimikirra nungkwa-langwa. Ngayuwa ki-yaminama akina kajungwa nungkwamba-langwa ki-yamini-yada ningkakina eningaba wurrukwala-manja warnumamalya. ");
INSERT INTO aoi_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","“Aburraja wurrukwala warnumamalya ke-yengbinama eningaba ayakwa nungkwa-langwa-langwa. Kembirra ngayamba-langwa arrkala eningaba ayakwa ki-yengbini-yada wurrumurndakakinu-wa warnumamalya. Umba aburraja warningerribirra warnumamalya kabi-kbajina-manja nungkuwa-wa, kembirra ngayamba-langwa ke-kbajinama wurrumurndakakinu-wa warnumamalya. Biya ki-yaminama ngayuwa eningaba wurruwurrakwulyumida-manja warnumamalya engkalina-langwa iya engkalina-langwa angalya, wuburra laka ningi-yaminama eningaba aduwaba nungkuwa-manja,” ni-yama nakina Yaweya Aburemu-wa-da. ");
INSERT INTO aoi_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Bi...ya eneja Aburema neniyuwangkwa arakba, 75 mamarika iya yinungkwura n-ambilyumurra nakina. Biya ni-lalika ebina angalya aminababurna alikira iya warnumamalya Yerena akwa ni-likena eminingku-wa angalya aringbirru-wa Kenina, mena-baba Yaweya adinuba-wiya nenu-makamurra neniki-lika-langwa yenjerrikina akinu-wa angalya nakina. Umba eneja nenikuwenikba Lada ni-likenumurra nakina Aburema-manja. Nakine-ka Lada-langwa nungwenikba wunadiyerra-manja Aburema. ");
INSERT INTO aoi_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Biya nanga-wilyakama Aburema dadingiyenikba Jeraya akwa ngarningka nenikuwenikba Lada nenu-wilyakamurra. Akwa ngarningka wurrababurna-langwa warnungkwarba iya wurridarringka wurribina na-mungkwuluma ena-langwa-manja angalya akwa nenuminu-war•duwar•danguma ena-langwa warka aburrajukwaba nenu-wilyakamurra. Narri-larrngkajikamurra wurrakina ababurna-langwa amurndakijika iya angwarnda amurndakibina narru-manguma nuw-ambilyu-wiya wurrakina Yerena-manja, akwa namurndaki-likenuma arakba-da. Namurndak-alilikenu...wa. Ne-yar•da arakba wurrakina ebina-manja angalya Kenina aringbirra-manja. ");
INSERT INTO aoi_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Akini-yada kembirra akina-manja ngawa angalya, aburraja wurrakina warnumamalya warnimikirra WarningiKenina nawurrak-ambilyuma ngawa wurrakina. Kembirra yakwujina ngawa Kenina-manja ngalaja akwurdukwurda eka aburra-langwa amalawudawarra nuw-alkayanguma engka-manja iya engka-manja angalya. Yakwujina ngawa wurrakina WarningiKenina warnumamalya ne-yengbinumurra ayakwa wurrakina aburra-langwu-wa amalawudawarra eka. Aburraja kembirra Aburema-murriya namurndak-ambilyumurra wurrakina Kenina-manja. Biya namurndaki-likenuma engku-wa iya engku-wa angalya yakwujina ngawa yanda-langwa narr-akburrangama angakingakarjiyinga angalya. Akina-manja ngawa angalya ngalaja awilyaba-ma akina eka akwurdukwurda nuw-arndurrkwarjeyumurra engemba-manja Mawura, akwudangwa angalya aminababurna alikira iya warnumamalya emikirra Jekema. ");
INSERT INTO aoi_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Eneja kembirra Yaweya n-abilyerrikajungwunuma Aburema-manja ebina-manja akwurdukwurda eka akwa ni-yama enuwa-wa, “Enena-bina angalya aringbirra ngayuwa ka-kwunama nungkwa-langwu-wa numirena-murriya warnikinikaduwa-wa,” ni-yama nakina nenu-maka Aburema-manja. Kembirra yakwujina ngawa numurndaku-manga eneja Aburema angwarnda arumuruma, akwa nuwurrak-arjiyajuwa amurndakakina akwa ni-ngekburaka arakba alda Yaweya-langwa, kajungwa neniku-buriyami-yada nakina Yaweyu-wa yakwujina. Akwa neni-yangmarngkwajuwa nakina enuwa-wa arakba-da. ");
INSERT INTO aoi_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Yadikina kembirra namurndaki-likena arakba wurrakina Aburema-murriya nuw-angkarrinu-murruwa arrirra dalada, akwa kembirra narri-ngekburakama angalya yakwujina angakingakarjiyinga-kba. Awilyaba angalya emikirra Bedela nuw-ambilyumurra akwaburrangarna umba ngalaja Aya alyengmilyengma-langwa akina. Alakina-kiya angalya aminababurna alikira iya warnumamalya. Biya yakwujina arakba wilyarra nakina Aburema ni-ngekburaka alda ebina wuburra ngawa. Numurndaku-manga akwala angwarnda arumuruma akwa nuwurrak-arjiyajuwa akina yakwujina ngawa akwa ni-ngekburaka arakba alda kajungwa neniku-buriyami-yada nakina Yaweyu-wa. Akwa neni-yangmarngkwajuwa nakina enuwa-wa-da. ");
INSERT INTO aoi_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Kenina-manja ngawa nawurrak-ambilyumurra warnumangalya Aburema-murriya akena narru-makirukbijangajuwama wurrakina angalya angerriba iya angerriba nuw-angkarrinu-murruwa arrirra dalada wurrakina-da. ");
INSERT INTO aoi_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Akena akina-manja angalya Kenina ngalaja eyukwujiya aninga nuw-ambilyuma awurrariya-baba angalya. Kembirra Aburema-murriya narri-lalika wurrakina Kenina akwa namurndaki-likena angerriba Yijibu-wa, kajungwa kuw-ambilyi-yada yakwujina aduwaya, nara-wiya ebina aninga ambaka Kenina-manja. ");
INSERT INTO aoi_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Biya narr-akburranga-manja wurrakina akina angalya Yijiba, nara-wiya karri-jibukwa akina-manja angalya, ni-yengbina nakina Aburema ayakwa dadingiyenikba-manja Jeraya. Ni-yama nakina, “Ningkene-ka ningkukwulyubena ningkidarringka. ");
INSERT INTO aoi_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Kabu-rringkina-manja nungkuwa WarningiYijiba warnumamalya, ka-lyangkiyaminama wurrakina, ‘Aburema-langwa dadingiyenikba dakina-na?’ ke-yaminama wurrakina. Kembirra dukwa kabu-ngajina wurrakina ngayuwa-manja-da. Umba nungkwaja k-ambilya ningkeniba ningkakina. ");
INSERT INTO aoi_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Kembirra ningkena ka-makinama wurrumurndakakina-manja warnumamalya, ‘Ngayuwa ningena Aburema-langwa ningadiyamarnjenikba,’ ki-yaminama ningkakina ka-makinama. Kembirra aburraja kabu-lalikinama ningeniba k-ambilyi-yada. Kembirra ka-marngkirradinama ngayuwa-manja,” ni-yama nakina Aburema Jerayu-wa. ");
INSERT INTO aoi_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Kembirra narri-lalika-manja Kenina akwa nuw-awiyebeyinu-manja Yijibu-wa wurrakina, aburraja wurrumurndakakina WarningiYijiba warnumamalya narringa-rringkama dakina didarringka dukwulyubena amandangwa. ");
INSERT INTO aoi_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Umba akina-manja ngawa angalya Yijiba eneja naruma nubungkawa n-ambilyumurra nakina. Ni-lyingame-ka ababurna-langwa angalya yakwujina Yijiba-manja. Aburraja wurrukwala warnungkwarba wurribina nenuminu-war•duwar•danguma warka ena-langwa-manja alikira nenu-makama wurrakina nakina-manja dakina-langwa dadingiyenikba dukwulyubena Aburema-langwa. Kembirra wurrakina warnikuminuwar•duwar•da ena-langwa narringa-lyilyanguma Jeraya enuwa-wa ena-langwu-wa alikira. ");
INSERT INTO aoi_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Kembirra dukwulyubena-baba dakina, eneja nakina nubungkawa nu-marngkirradinuma Aburema-manja akwa nenu-kwama warnikuminuwar•duwar•da ena-langwi-yada akwa ngawa ababurna jiba iya nenukwuda iya bulukwa iya dangki akwa ngawa kamila. ");
INSERT INTO aoi_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Umba eneja nakina Yaweya nu-warangume-ka nakina Jeraya dadik-ambilyinga-langwa yakwujina nibina-manja nubungkawa ena-langwa-manja alikira, akwa ni-larrkenuma nakina angbilyuwa engbingbuda enuwa-wa akwa ngawa ena-langwu-wa warnumamalya nuw-ambilyu-murruwa ena-langwa-manja angalya. ");
INSERT INTO aoi_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Kembirra eneja nakina nubungkawa nen-ardijuwa Aburema enuwa-wa. Ni-yama nakina, “Ningki-yamarrkame-ka ningkakina ngayuwa-manja? Miyambena-burra nara yiku-maka daka dadingiyena nungkwa-langwa Jeraya? ");
INSERT INTO aoi_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Ningki-yama-mubaba ningkakina, ‘Dadiyamarnjarrka daka didarringka,’ kembirra aminakina-langwa ninginga-manguma dadingiyarrki-yada daka. Awurrariye-ka akina yi-kadika-mulangwa. Nga-mena kembirra daka dadingiyena nungkwa-langwa akwa jeyi, wurringi-likaja arakba engku-wa ngayuwa-langwa,” ni-yama nakina nubungkawa Aburemu-wa. ");
INSERT INTO aoi_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Kembirra nenu-maka nakina ena-langwa-manja warnikuminuwar•duwar•da, “Wurrawurraki-larrkiya arakba wunalakena wunenumamalya-kiya yadada,” ni-yama. Kembirra narra-manga arakba Aburema-murriya akwa narra-wilyakama Yijiba-langwa engku-wa-da, Aburema iya wurrababurna-langwa warnumamalya ena-langwa akwa ngawa ababurna amurndakijika amurndakibina aburra-langwa-da. ");
INSERT INTO aoi_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Bi...ya aburraja Aburema-murriya nawurraki-lawurradinuma arakba Yijiba-langwa wurrakina akwa nawurraki-likenumurra Keninu-wa nuw-angkarrinu-murruwa akina arrirra dirrumala. Nanga-wilyakama Aburema dadingiyenikba akwa nenu-wilyakama warnumamalya ena-langwa akwa ngarningka wurribina nenuminu-war•duwar•danguma warka ena-langwa aburrajukwaba wurrakina nenu-wilyakama. Akwa amurndakijika-murriya ebina aburra-langwa narruwurraku-wilyakama wurrakina. Akwa ni-likenuma enejukwaba Lada nakina aburruwa. ");
INSERT INTO aoi_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","5","Nakina Aburema numinababurne-ka amurndakijika-murriya akwa ngawa ababurna jiba iya nenukwuda iya bulukwa akwa awurrakwulyumide-ka angwarnda amamamuwa ajilba-murra akwa akawulda-murra nakina. Enejukwaba Lada numinababurne-ka amurndakijika-murriya nakina, ababurna jiba iya nenukwuda iya bulukwa ngalajukwaba. Kembirra nuwurraku-wilyakama Lada amurndakakina akwa ngawa warnumamalya ena-langwa nenu-wilyakama, akwa ngarningka wurribina nenuminu-war•duwar•danguma warka ena-langwa nenu-wilyakama nakina-da. Kembirra nawurraki-likenuma arakba wurrakina Aburema-murriya akwa Lada-murriya engku-wa iya engku-wa angalya. Namurndaki-likenuma angerriba nuw-ambilyu-murruwa Bedela akina, yanda-langwa namurndaki-yar•danguma wurrakina angalya-manja wilyarra Bedela akwa ebina Aya. Biya yakwujina ngawa na-mungkwuluma wurrakina, na-mungkwulu-murrumanja arakba-wiya wurrakina, akwa Aburema ni-ngekburaka-murrumanja nakina arakba-wiya alda, ebina angwarnda-murra. Biya kembirra yakwujina ngawa Aburema neni-yangmarngkwajuwama Yaweyu-wa nakina-da. ");
INSERT INTO aoi_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","7","Kembirra aburrajukwaba yakwujina wurrukwala warnumamalya wurruminakina angalya nuw-ambilyumurra ngawa wurrakina akina-manja angalya. WarningiKenina warnumamalya iya WarninguBerija warnumamalya wurrakina. Kembirra yakwujina ngawa nuw-ambilyumurra aburraja Aburema-murriya. Nawurrak-ambilyumurre-ka bi...ya ne-yarrakeyinume-ka akina amarda-murriya akwa angalya wunalakina-kiya-langwa wunambilyuma-kiya-langwa, Aburema-langwa akwa Lada-langwa, mena awurrakwulyumida-babe-ka jiba-murriya aburna-langwa. Kembirra aburraja ne-beyinuma arakba awinyamba wurrakina Aburema-langwa warnungkwarba wurribina narr-akwurrajuwa-murrumurra jiba-murriya, akwa Lada-langwa, ne-beyinuma arakba wurrakina-da. Narri-ngirrajuwama akungwa iya aninga amarda. Ne-beyinuma wurrakina akina-manja angalya Kenina-da. ");
INSERT INTO aoi_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Eneja kembirra Aburema ni-yama nakina Ladu-wa, “Yalakene-ka yenukwa-manja ngarruwurrakawura-murre-ka ngarna. Nara aburraja e-bibanjuma awinyamba yakwa-langwa warnungkwarba, nganyangwa warnungkwarba akwa nungkwa-langwa, nara a-wirrikbajajuma warna. ");
INSERT INTO aoi_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Yakwaja kembirra arakba y-aburrakuwurriyinama yalakena yi-likajama. Nungkuwa wi-yengbijina ebina angalya arakba ningki-ngayindenama, kajungwa ki-likaji-yada nungkuwa, umba nganjukwaba kembirra ki-likaji-yada arakba eminingku-wa angalya, yeyebijeba yak-ambilyi-yada,” ni-yama nakina Aburema Ladu-wa-da. ");
INSERT INTO aoi_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","13","Eneja Lada kembirra n-andeya angerriba nakina akena ni-rringka ekbilyuwalya angalya nuw-ambilyu-murrumanja adirrungwarna adalyuma emikirra Jardina. Eningabe-ka angalya akina. Umba akina adalyuma na-likenumurra angerriba akinu-wa angalya emikirra Jawa. Ababurne-ka akina akungwa iya eka akwa amarda, wuburra laka ebina angalya Yaweya ni-ngekburakama nakina emikirra Yidina, akwa ngalajukwaba wuburra ne-yamama akina adalyuma Yijiba-manja. Kembirra Lada nakina ni-ngayindanguma akina angalya aringbirra emikirra Jardina ena-langwi-yada angalya. Akwa ni-likena arakba nakina yenjerrikina akinu-wa angalya alyengmu-wa. Kembirra nen-aburrakuwurriyinuma arakba wunalakina-da. Umba eneja Aburema n-ambilyuma nakina yakwujina ngawa ebina-manja angalya Kenina. Eneja nakina Lada ni-ngekburakama angalya arakba engemba-manja Jaduma akwudangwa. Akine-ka angalya Jaduma aminababurna alikira iya warnumamalya. Umba aburraja wurrakina warnumamalya WarningiJaduma wurruwurrariye-ka wurruminakina angalya. Nara kenumini-yarrkuwaraka ayakwa Yaweya-langwa akwa nuw-arriyakajungwunuma awurruwurrariya-langwa wurrakina ngawa-da. Akena yakwujina ngawa nuw-ambilyuma aburraja Lada-murriya, nara-wiya nakina Yaweya kinu-burrijuwa alakina-kiya angalya aruma-murrikiya Jaduma akwa ngawa Kamara-da. ");
INSERT INTO aoi_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Kembirra Lada nakina ni-likenu-mulangwa arakba, eneja kembirra Yaweya ni-yama nakina Aburemu-wa, “Ningkakina ningk-arjiya-mulangwa yadikina andiya angerriba iya yenjerra. Ambaka-langwa ningkakina k-andiyama, ");
INSERT INTO aoi_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","mena ngayuwa ningena yiba-kwunama enena angalya aringbirra nungkuwa-wa akwa nungkwa-langwu-wa wurriyukwayuwa. Amurndakenena angalya ningki-rringkinama ababurna-langwa kembirra nungkwa-langwa-wiya arakba akina eningangkawura ngawa-da. ");
INSERT INTO aoi_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Akwa ngarningka yiba-kwunama wurrababurna warnikinikaduwa numirena-murriya nungkwa-langwa. Aburraja ka-wurramur•dinama wurrakina wuburra laka ajiringka. ");
INSERT INTO aoi_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Kembirra jeyi, likaja akwa kumurndaki-rringkina akina angalya angkwulyumida-langwa, mena ngayuwa-baba ningena yiba-kwunama amurndakenena angalya nungkuwa-wa,” ni-yama nakina Yaweya Aburemu-wa. ");
INSERT INTO aoi_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Eneja kembirra nakina Aburema ni-likena eminingku-wa angalya akwa ni-ngekburaka angalya enikaduwa Yebirena-manja. Yakwujina ngawa n-ambilyuma arakba akwudangwa amurndakibina eka akwurdukwurda nuwilyaba-langwa nenungkwarba nenimikirra Mamura. Kembirra yakwujina ngawa ni-ngekburakama alda nakina Aburema angwarnda-murra kajungwa neniku-buriyami-yada Yaweyu-wa. Akwa kembirra neni-yangmarngkwajuwa enuwa-wa nakina-da. ");
INSERT INTO aoi_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","9","Eneja nuwilyaba nenungkwarba nenimikirra Kedaleyuma ningbuda n-ambilyumurra nubungkawa ena-langwa-manja angalya engemba Elama. Biya nakina Kedaleyuma nu-bungkawadinuma ngarningka wurrukwala-manja wurrububungkawa wurrumangbala-manja. Warnimikirra wurrakina Bera iya Birija iya Jina iya Jemeba akwa ngawa nuwilyaba nubungkawa akina-manja angalya emikirra Bela. Akena akina angalya aminambilyuma-kiya ekirra, Bela akwa ngawa Jawa. Nakine-ka Bera nubungkawa ena-langwa-manja angalya Jaduma, umba eneja nakina Birija nubungkawa ena-langwa-manja angalya Kamara, umba eneja nakina Jina nubungkawa ena-langwa-manja angalya Aduma, umba eneja nakina Jemeba nubungkawa ena-langwa-manja angalya Jebawuma nakina. Umba nibina Kedaleyuma nu-bungkawadinuma nakina nenungkwurakba wurrakina-manja wurrububungkawa wurrumangbala. Mememberrkwa-manja mambilyuma mamarika iya yinungkwura nu-bungkawadinuma nakina Kedaleyuma wurrakina-manja wurrububungkawa wurrumangbala akwa ngawa aburra-langwa-manja warnumamalya wurrababurna-manja. Kembirra mingka-manja mamarika wurrakine-ka wurrumangbala wurrububungkawa na-lyangkuwerribikajungwunuma nari-yada arakba amin-engkirrikuma Kedaleyuma-wa. Kembirra mingka-manja mamarika eneja Kedaleyuma nakina nenu-wilyakama ena-langwa wurrawinyamba warnungkwarba engembu-wa Ajerada-Karneyimu-wa. Aburrubukwurrajukwaba wurrubukabiyakarbiya wurrubukubungkawa narra-wilyakama aburrubukwurra-langwa wurrawinyamba warnungkwarba akinu-wa angalya kajungwa warniku-mamurikaji-yada wurrakina Kedaleyuma-manja. Wurrubukalakina wurrubukubungkawa wurrubukenimikirra Amirabela iya Ariyakwa akwa Didala. Nakine-ka Amirabela nubungkawa ena-langwa-manja angalya Babuleniya, umba eneja Ariyakwa nubungkawa nakina ena-langwa-manja angalya Elajara, umba eneja Didala nubungkawa nakina ena-langwa-manja angalya Kawiyima. Aburraja wurrababurne-ka wurrawinyamba wurrakina-langwa wurrubukubungkawa wurrubukabiyarbuwa, Kedaleyuma-langwa iya Amirabela-langwa iya Ariyakwa-langwa akwa Didala-langwa. Na-mamurikeyinume-ka wurruwurrakakina akwa na-wardiyinuma wurrakinu-wa warnumamalya warnimikirra WarningiRebeyima engemba-manja Ajerada-Karneyima. Na-wardiyinuma wurrakinu-wa, biya yadikina kembirra nawurraki-likenuma ngawa engembu-wa Yemu-wa akwa na-wardiyinuma yakwujina wurrukwalu-wa warnumamalya warnimikirra WarningiJijima wurrakina. Biya kembirra yadikina nawurraki-likenuma ngawa ekburriyalkwu-wa emikirra Kiriyadeyuma akwa ngarningka ngawa na-wardiyinuma yakwujina wurruwurrakukwalu-wa warnumamalya warnimikirra WarningEmima. Narra-jungwajuwame-ka wurrakina wurrababurna warnumamalya, WarningiRebeyima-manja iya WarningiJijima-manja akwa WarningEmima-manja warnumamalya. Biya kembirra yadikina nabuki-likenuma wurrubukalakina wurrubukabiyarbuwa wurrubukubungkawa iya aburrubukwurra-langwa warnungkwarba ebinu-wa angalya emikirra Yiduma. Aminababurna angakingakarjiyinga akina angalya. Yakwujina ngawa kembirra na-ngajeyinuma wurrakina wurrukwalu-wa warnumamalya warnimikirra WarningiYari. Narra-jungwajuwama wurrababurna warnumamalya akwa kembirra narra-larrmanguma wurrukwala. Na-minangkirreyinuma wurrakina ngawa bi...ya yanda-langwa Elbarena angalya. Akine-ka angalya akilarrkbidjina alarrkingburingka-manja nuw-ambilyuma. Biya kembirra yadikina nawurraki-lyangkarrngajungwunuma wurrakina akwa ngarningka ngawa nawurraki-lawurradinuma engembu-wa angalya Kedeja. Akini-yada akina angalya Enumijibada emikirra adinuba-wiya, umba kembirra aduwaba Kedeja arakba akina emikirra. Wurringbingbude-ka ngawa namurndaki-likenume-ka. Biya narruwurraku-murrakajuwa ababurna-langwa angalya wurrumurndakibina-langwa warnumamalya WarningAmaleka. Biya kembirra ngarningka ngawa na-ngajeyinuma wurrukwalu-wa warnumamalya WarningAmawu-wa wurribina nuw-ambilyu-murruwa engemba-manja angalya Yajijena-Damara akina. Na-wardiyinuma wurrakinu-wa akwa narra-jungwajuwama wurrababurna warnumamalya. Aburraja kembirra wurrububungkawa wurrumangbala Jaduma-langwa iya Kamara-langwa iya Aduma-langwa iya Jebawuma-langwa akwa Bela-langwa narrawurra-murndukwama arakba aburra-langwa wurrawinyamba warnungkwarba ekbilyuwalya-manja angalya emikirra Jidima. Narrawurra-murndukwama wurrakina kajungwa warniku-wardi-yada wurrubukalekbinu-wa wurrubukubungkawa wurrubukabiyarbuwa Elama-langwa iya Kawiyima-langwa iya Babuleniya-langwa akwa Elajara-langwa. Akini-yada ngawa nara ambaka makarda mibina yakwujina umba aduwaba-manji-kba makarda makina. Memikirra makina “Menikijijungwa Makarda.” ");
INSERT INTO aoi_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Umba akina-manja ngawa angalya ekbilyuwalya ngalaja ababurna edirra aminyadirra-murra wuburra amilyumilyinja nuw-ambilyumurra akina. Kembirra wunalakina wunambilyuma-langwa wunubungkawa-kiya, nuwilyaba nibina Jaduma-langwa nubungkawa umba nuwilyaba nibina Kamara-langwa nubungkawa, kwureya nen-angkirreyinuma wunalakina wuneniki-lyumadi-yada akina-langwa awinyamba. Akena neni-lyikarrkburrukwunuma wunalakina angerriba memedirru-wa minyadirra akwa nenu-kwulyanguma. Umba aburrubukwurraja wurrubukabiyakarbiya-langwa wurrubukubungkawa wurrubukalakina nabuk-angkirreyinuma nabuki-lyumadinuma angakarjiyinga-wa angalya-da. ");
INSERT INTO aoi_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","12","Kembirra aburrubukwurraja wurrubukalekbina wurrubukabiyarbuwa wurrubukubungkawa Elama-langwa iya Kawiyima-langwa iya Babuleniya-langwa akwa Elajara-langwa nabuki-likenuma wurrubukalakina alakina-kiya-wa angalya Jaduma-wa iya Kamaru-wa wurrakina. Nabuki-likenuma wurrubukalakina iya aburrubukwurra-langwa warnungkwarba aburruwa akwa narra-manguma wurrakina wurrababurna-langwa WarningiJaduma warnumamalya iya WarningiKamara warnumamalya. Akwa kembirra narruwurraku-manguma ebina aninga iya akwala amurndakijika ababurna-langwa alakina-kiya-langwa angalya. Eneja nakina Lada, nibina nenikuwenikba Aburema-langwa, n-ambilyuma ebina-manja ngawa angalya Jaduma. Biya kembirra nenu-manguma nakina akwa narru-manguma ngarningka ena-langwa amurndakijika-murriya. Biya narruwurraki-lalikama arakba alakina-kiya angalya. ");
INSERT INTO aoi_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Eneja nuwilyaba nenumamalya ni-lyumadinuma nakina Kedaleyuma-murriya-langwa akwa ni-likenuma Aburemu-wa, nibinu-wa NiYiburuwa, mena nakine-ka Aburema nungwenikba Lada-langwa. Nakina Aburema n-ambilyumurra akwudangwa ebina-manja angalya nuw-ambilyu-murrumanja amurndakibina akwurdukwurda eka Mamura-langwa. Umba eneja Mamura NeningAmawa nenumamalya nakina. Enuwa akwa ngawa wunalakina ena-langwa narrkuwenikba-kiya Ejikala iya Anira aburrubukwurruwa-murra nabuki-yakiyakeyinuma wurrubukalakina aburrubukwurruwa nakina Aburema. Kembirra eneja ni-lyumadu-mudangwa nibina nenumamalya nen-akburrangama arakba nakina-manja Aburema akwa nenu-makama nakina enuwa-manja akina ayakwa nenu-mangu-mulangwa wurruwurrakibina warnumamalya nenikuwenikba Lada-da. ");
INSERT INTO aoi_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Eneja n-eningmidu-manja nakina Aburema nenu-mangu-mulangwa Kedaleyuma-murriya ena-langwa nenikuwenikba Lada, kembirra nenuwurrak-ardijuwa nakina wurrumurndakakina wurrawinyamba ena-langwa, 318 warnungkwarba. Kembirra Aburema akwa ngawa ena-langwa warnungkwarba ne-yuweyinuma wurrakina Kedaleyuma-murriya-manja akwa aburra-langwa-manja warnungkwarba engku-wa yanda-langwa akina-manja angalya aminababurna alikira iya warnumamalya emikirra Dena. ");
INSERT INTO aoi_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Biya kembirra Aburema nenuwurrak-errbalijuwa wurrumurndakakina warnungkwarba ena-langwa wurrawinyamba, wurrukwala yadada umba wurrukwala angaluba. Kembirra na-ngajeyinuma Kedaleyuma-murriya-manja akwa aburra-langwa-manja warnungkwarba alyarrngwalyilya. Biya nakina Aburema akwa ena-langwa wurrawinyamba warnungkwarba narra-jungwajuwama wurrababurna warnungkwarba wurrawinyamba Kedaleyuma-murriya-langwa, umba narra-larrmanguma wurrukwala yanda-langwa akina-manja angalya emikirra Yawuba. Akine-ka angalya Yawuba nuw-ambilyuma akina Damajija-manja alarrkuwarra-langwa. ");
INSERT INTO aoi_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Kembirra narruwurra-murrakajuwa wurrakina amurndakibina amurndakijika narruwurraku-manguma adinuba-wiya Kedaleyuma-murriya alakina-kiya-langwa angalya Jaduma akwa Kamara. Kembirra Aburema nakina neni-lawurrakajuwa angalyu-wa ena-langwa nenikuwenikba Lada akwa ngawa amurndakibina amurndakijika ena-langwa. Akwa ngarningka nenuwurraki-lawurrakajuwa wurrumurndakibina wurrididarringka akwa ngawa wurrukwala warnumamalya wurribina narra-manguma Kedaleyuma-murriya alakina-kiya-langwa angalya Jaduma akwa Kamara. Neni-lawurrakajuwama wurrakina ena-langwu-wa angalya-da. ");
INSERT INTO aoi_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Kembirra ni-lawurradinu-manja nakina Aburema ena-langwu-wa angalya na-ngajeyinu-mulangwa wurrumurndakibina Kedaleyuma-murriya, eneja nubungkawa Jaduma-langwa nenu-kwurukwa ni-likena nakinu-wa. Biya nen-akburranganja wunalakina ekbilyuwalya-manja angalya emikirra Jebeya. Aminambilyuma ekirra akina angalya, awilyaba Jebeya umba awilyaba ngarningka “Nubungkawa-langwa Angalya” akina. ");
INSERT INTO aoi_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Enejukwaba nuwilyaba nenungkwarba Malkijideka nenimikirra ni-likenumurra nakina Aburemu-wa. Nakine-ka nenungkwarba nubungkawa Jalema-langwa akwa ngarningka NuMinida nenungkwarba n-ambilyumurra. NuMinida nakina Neningikarrawara-langwa umba eneja nakina Neningikarrawara naruma numikbiyiya-dangwa. Eneja nu-wilyakame-ka nakina amalyirra akwurena-langwa akwa ngawa damba Aburemu-wa-da. ");
INSERT INTO aoi_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Kembirra ni-yengbina Malkijideka nakina ayakwa Neningikarrawaru-wa. Ni-yama, “Nungkuwa ningkakina Ningkeningikarrawara ningkibina ningkaruma ningkumikbiyiya-dangwa. Ningkakina-bina ningki-ngekburakama angubina iya ababurna-langwa angalya-da. Yamina eningaba Aburema-manja. ");
INSERT INTO aoi_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Ningken-akwurrajuwama nakina-manja, ningkenu-mamurikajuwama akwa kembirra eneja neni-larrmanguma nu-minangkirrajuma nakina wurrumurndakibina wurrawinyamba warnungkwarba wurrababurna-langwa. Kembirra aminakina-langwa yirruwa ke-yangmarngkwajinama nungkuwa-wa aduwaba,” ni-yama nakina Malkijideka Neningikarrawaru-wa. Eneja kembirra Aburema nenu-kwa ababurna eninginingaba amurndakijika enuwa-wa. Ni-larrngkwaburranga Aburema ababurna-langwa eningerribirra amurndakibina nenu-murrakajuwama nakina ni-larrngkilawurrakajuwama Kedaleyuma-murriya-langwa akwa nu-murnduwarnuma akina kajungwa neniku-kwi-yada akwala Malkijideku-wa. Ni-larrmburranguma arngkumemberrkwa amurndakijika akwa kembirra nenu-kwama alarrngkuwilyaba Malkijideku-wa umba amangbala abiyarbuwa nu-minambilyuma. Umba ememberrkwa bulukwa nu-murnduwarnuma akwa nenu-kwama awilyaba. Biya ni-yaminjamama ngawa nenu-kukwame-ka amukwiyadakina ababurna-da. ");
INSERT INTO aoi_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Kembirra ni-yama eneja nakina nubungkawa Jaduma-langwa Aburemu-wa, “W-akwurrajina ababurna-langwa amurndakijika amurndakenena nungkwa-langwi-yada umba yimini-lawurrakajina wurrumurndakenena nganyangwa warnumamalya,” ni-yama. ");
INSERT INTO aoi_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","23","Ni-yama eneja Aburema enuwa-wa, “Nara ningena akwurrajuma nungkwa-langwa amurndakijika. Nara a-manguma duwilyuwilyaba dadumakirnda akwa awilyuwilyaba amakirnda eningalika. Enena ayakwa yirra-makinama nungkuwa-wa akwa ngawa ningi-yengbijinama ekirra Yaweya-langwa. Nakina-bina ni-ngekburakama angubina akwa ababurna-langwa angalya. Enena kembirra ayakwa yirra-makinama nungkuwa-wa kajungwa kin-engkirrikaji-yada Yaweya, nibina naruma numikbiyiya-dangwa Neningikarrawara nakina, akwa nara ngayuwa a-yarrkuwarrukwajuma enena ayakwa nganyangwa. Kembirra nare-ka nungkwaja e-yamama, ‘Ngayuwe-ka ningena ningenu-mamurikajuwama Aburema. Kembirra aminakina-langwa numinababurna amurndakijika nakina-da,’ nara e-yamama ningkakina. ");
INSERT INTO aoi_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Nganja ningena nara a-rndirrkama akwala amurndakijika nganyangwi-yada. Umba nganyangwa warnungkwarba nuw-alyubarinuma arakba wurrakina aninga, kembirra akine-ka yimbukwa yirra-langwa, nara akwala. Umba wurra-larrkiya warna warnungkwarba Anira iya Ejikala akwa Mamura, aburru-murnduwarna akina amurndakijika akwa karrubuku-wilyakina aburrubukwurra-langwi-yada-da,” ni-yama Aburema nakinu-wa nubungkawa NeningiJaduma-da. ");
INSERT INTO aoi_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Bi...ya kembirra n-ambilyu-manja nakina Aburema arrawa ena-langwa-manja kalikwa, nenu-marngkirringkama nakina Yaweya akwa n-engkirrikenuma ayakwa ni-yengbinuma enuwa-wa. Eneja ni-yama Yaweya, “Nara akbar•duma. Nganja ningena yiba-didirrakinama nungkuwa awurruwurrariya-langwa kajungwa ningkingkinyungwurra k-ambilyi-yada ningkakina, akwa ngawa yiba-kwunama ngayuwa eninginingaba-wiya,” ni-yama Yaweya enuwa-wa. ");
INSERT INTO aoi_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Eneja ni-yama Aburema, “Ningkubungkawa Yaweya, miyambena-burra yiku-kwunama eninginingaba ngayuwa-wa? Nara wurribina wurriyukwayuwa nganyangwa. Nuwilyaba-ma wulkwa nenungkwarba nenimikirra Eliyeyija wuburra laka nenikuwarrka nganyangwa, mama nginuminu-war•denama warka nakina. Umba angalya ena-langwa Damajija akina. ");
INSERT INTO aoi_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Akena nungkwaja nara yiku-kwa wurriyukwayuwa ngayuwa-wa. Kembirra ki-jungwa-manja ngayuwa, nakine-ka Eliyeyija kinu-menama amurndakijika nganyangwa-da,” ni-yama Aburema-da. ");
INSERT INTO aoi_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Biya kembirra n-engkirrika nakina Aburema Yaweya ni-yengbinuma ayakwa ngarningka enuwa-wa. Ni-yama eneja Yaweya, “Kwuja! Nara nakina Eliyeyija a-manguma amurndakijika nungkwa-langwa ki-jungwa-manja nungkuwa. Umba ambaka-murra ningkakina k-akumajungwunama amandangwa nenikuwena. Kembirra nakina-bina nenikuwena kinu-menama amurndakijika nungkwa-langwa ki-jungwa-manja nungkuwa,” ni-yama Yaweya Aburemu-wa. ");
INSERT INTO aoi_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Kembirra Yaweya nenu-wilyaka Aburema errekbu-wa akwa ni-yama enuwa-wa, “Ngwundikadiya angubinu-wa karrawaru-wa, akwa yindukwureya nga-murnduwarna dumurndakangaba dakilyingajanga,” ni-yama. “Nungkwa-langwe-ka warnikinikaduwa numirena-murriya kuw-ababurnadinama wurrakina. Wurruwurrakwulyumide-ka wuburra dumurndakangaba dakilyingajanga duwurrakwulyumida ke-yaminama wurrakina aburrajukwaba-da,” ni-yama nakina Yaweya Aburemu-wa-da. ");
INSERT INTO aoi_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Nakine-ka nu-werrikambilyuma Aburema Yaweyu-wa. Kembirra akina-langwa arrkala nakina Yaweya nenu-werrungwur•danguma Aburemu-wa-da. ");
INSERT INTO aoi_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Kembirra ni-yama nakina Yaweya Aburemu-wa, “Ningene-ka ngayuwa Yaweya, ningibina yirra-wilyakama ningkakina engemba-langwa Wura-langwa ebina-langwa angalya aringbirra-langwa emikirra Babuleniya. Yirra-wilyakama nungkuwa yangkwurrangwa kajungwa ningeniku-kwi-yada enena angalya nungkwa-langwa,” ni-yama. ");
INSERT INTO aoi_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Eneja ni-yama Aburema, “Ningkubungkawa Yaweya, ki-yamarrkinama ngayuwa k-eningmidinama enena angalya nganyangwa?” ni-yama. ");
INSERT INTO aoi_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Eneja ni-yama nakina Yaweya Aburemu-wa, “Yi-yikaja awilyaba bulukwa iya nenukwuda adarringka-kiya akwa ngawa enungkwarba jiba, amurndakibina mabiyakarbiya mamarika iya yinungkwura nuw-ambilyuma. Akwa ngarningka yi-yikaja duwilyaba darrawurukukwa akwa duwilyaba dakwurakburakba,” ni-yama Yaweya enuwa-wa. ");
INSERT INTO aoi_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Eneja Aburema ni-likena, numurndak-angkarna amurndakakina, biya neni-yikena kembirra Neningikarrawaru-wa arakba. Kembirra nu-wardanga, numurnda-ngkingkarrngarna amurndakakina wilyarra, akwa n-akumarna amurndakibina amadangkwa ajiringka-manja, akwala yada-langwa-langwa, umba akwala angalaluba. Ngalaja kembirra na-kwurukweyinuma amurndakakina awurruwurrakidirrbura. Akena nara wurrajija keni-ngkarrngarna nakina. ");
INSERT INTO aoi_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Kembirra aburraja wurriminingka wurrukwala wurrajija wurradidirrungwarna wuburra yukwurrijija na-dirrirnda angaluba amurndakakinu-wa amadangkwa, akena eneja Aburema nu-minangkirraja nakina wurrakina wurrajija-da. ");
INSERT INTO aoi_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Kembirra numa-merrkilarrinu-manja mamawura nakina Aburema nu-mungkwulinga arakba marringa madirrungwarna. Kembirra nu-mungkwulu-wiya nakina Aburema nu-minjirrkakbar•de-ka angwurra nakina-da. ");
INSERT INTO aoi_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","16","Eneja kembirra Yaweya ni-yama nakina enuwa-wa, “Nungkuwa ningkakina k-ambilyama yanda-langwa k-eniyuwangkwudinama akwa nungkwabakiya-ba ki-jungwunama ningkakina ningkumurndamurndirra. Kembirra ki-jungwa-manja nungkuwa, aburraja wurrukwala warnumamalya kabu-rungkwabinama ningkakina,” ni-yama Yaweya. “Ki-jungwa-manja nungkuwa, kembirra aburraja nungkwa-langwa numirena-murriya warnikinikaduwa ka-likajama wurrakina eng...ku-we-ka angalya alarrkingku-wa. Akwa kuw-ambilyame-ka yakwujina wurruminjirrkingka wurrakina. Aburraja wurrububardijena warnumamalya wurruminakina angalya karra-menama nungkwa-langwa warnikinikaduwa numirena-murriya akwa karra-war•dikiname-ka aruma warka wurrakina-manja yakwujina-da,” ni-yama nakina Yaweya Aburemu-wa. Biya ni-yama ngarningka, “Kuw-ambambilyama kembirra wurrakina nungkwa-langwa numirena-murriya warnikinikaduwa yakwujina akina-manja ngawa angalya yanda-langwa 400 mamarika iya yinungkwura kini-jerridina-manja yakina, mena nara-baba ambaka ningena a-minangkirrajuma wurrumurndakenena warningiyelakwa warnumamalya WarningAmawa. Wurruwurrariye-ka nuw-ambilyama aduwaba wurrumurndakenena warnumamalya WarningAmawa, akena kuw-arriyadinama ambaka-murrumurra angwurre-ka wurrakina. Kembirra akini-yada ngawa kuw-arriyadina-mulangwa wurrakina, ngayuwe-ka ningena ka-banijumindenama, ku-minangkirreyinama wurrakina-da. Kembirra ngayuwa ningena k-awinyambadinama wurrumurndakibinu-wa wurrububardijena warnumamalya ebina-manja angalya alarrkingka-manja. Umba aburraja numirena-murriya warnikinikaduwa karri-lalikinama akina angalya akwa ka-lawurradinama yangkwurrangwa. Umba ka-jadena-manja akina-langwa angalya alarrkingka-langwa wurrakina numirena-murriya warnikinikaduwa, karri-larrngkuwarakinama ababurna amurndakijika-murriya iya yababurna yinungungwangba-murriya akwa ababurna angwarnda-murriya awurrakwulyumida aburruwa-manja. Wurruminababurne-ka kembirra wurrakina-da,” ni-yama Yaweya nakina Aburemu-wa-da. ");
INSERT INTO aoi_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Kembirra ngalaja arakba mamawura numa-merrkawiyeba makina akwa na-larrumur•da arakba. Kembirra adirrariyaba ngalaja amarnina nuw-angmakwulalinga adingira-murra-manja bajikala nuw-abilyerrikajungwa akina, akwa nuw-angkarrkarjeya angwarra ngala-langwa. Akwa ngalaja na-jadinga akina angwura nuw-abarrirrakina wuburra yinumukwa yimundungwa. Nalirraki-likena alakina angwura-kiya wilyarra n-akumarnu-murrumanja Aburema amurndakibina amadangkwa ajiringka-manja. ");
INSERT INTO aoi_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Kembirra akini-yada ngawa eneja nakina Yaweya ni-yarrkakumarnuma eningarumuruma ayakwa Aburema-langwi-yada. Umba Aburema enamba-langwa nu-manga akina ayakwa ena-langwi-yada. Ni-yama Yaweya enuwa-wa, “Amurndakenena ayakwa nganyangwa, akwa nara a-yarrkuwarrukwajuma ningena. Enene-ka angalya aringbirra amandangwa ka-kwunama nungkwa-langwu-wa numirena-murriya warnikinikaduwa-wa. Wurrakine-ka na-likajama enena angalya Yijiba-langwa akwa engku-wa angerriba angabu-wa adirrungwarna adalyuma emikirra Yiburadija. ");
INSERT INTO aoi_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","Aduwaba aburraja wurrumurndakenena warnumamalya nuw-ambilyama wurrabalija wurruminenena angalya. Akwala angalya WarningiKena-langwa warnumamalya, iya akwala angalya WarningiKenija-langwa warnumamalya, iya akwala angalya WarningiKadumana-langwa warnumamalya, ");
INSERT INTO aoi_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","iya akwala angalya WarningiYida-langwa warnumamalya, iya akwala angalya WarninguBerija-langwa warnumamalya, umba akwala angalya WarningiRebeyima-langwa angalya akina. ");
INSERT INTO aoi_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","Akwa ngarningka amurndakenena akwala angalya WarningAmawa-langwa warnumamalya aduwaba, iya akwala angalya WarningiKenina-langwa, iya akwala WarningiKikaja-langwa umba akwala ngarningka WarningiJebija-langwa warnumamalya akina. Amurndakenene-ka angalya aburra-langwa ababurna-langwa ka-kwunama ngayuwa amandangwa nungkwa-langwu-wa numirena-murriya warnikinikaduwa-wa-da,” ni-yama nakina Yaweya Aburemu-wa-da. ");
INSERT INTO aoi_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Yakwujina ngawa eneja Aburema n-ambilyuma Kenina-manja angalya. N-ambilyumurra nakina mememberrkwa mamarika iya yinungkwura, akena ngalaja dadingiyenikba Jeraya duburubura ngawa dadingarijira-ma. Ebina-wiya dakina Jeraya nanga-mangumurra Yijiba-langwa duwilyaba dadiyara dadimikirra Yeka. Eneja neningiyadikba nu-beyindanguma ngala-langwa-langwa warnumamalya dadikuminu-war•di-yada warka Jeraya-langwa. ");
INSERT INTO aoi_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Ngalaja Jeraya kembirra yingi-yama neningiyadikba-wa, “Nakine-ka Yaweya nara kenu-kwa-langwa wurriyukwayuwa ngayuwa-wa, umba nungkwaja nga-mena daka dadiyara wurringi-yakeyina wurringu-mungkwula,” yingi-yama. “Nganyangwi-yada kembirra wurrangariya ka-rukwamalyeni-yada karring-arrangbina-manja dakina,” yingi-yama Jeraya Aburemu-wa yinginu-makama. Eneja kembirra Aburema ni-lyangkuwama nakina. ");
INSERT INTO aoi_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Biya kembirra Jeraya yinginu-kwa arakba dakina dadiyara neningiyadikba-wa-da ena-langwi-yada didarringka-da. ");
INSERT INTO aoi_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Biya kembirra arakba wunalakina neni-yakeyina dakina Yeka-da. Bi...ya yinginuminu-mambakinuma arakba dakina wurrangariya Aburema-langwa. Yingu-ngkweningabakajungwuna dakina Jerayu-wa-da. Biya yingi-yama Yeka dakinu-wa Jeraya, “Ningene-ka arakba ningeningaba ngaya,” yingi-yama, “ningenuminu-mambakina-mubaba arakba ningena wurrangariya Aburema-langwa,” yingi-yama dakina Jerayu-wa-da. ");
INSERT INTO aoi_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Ngalaja yingi-yama Jeraya neningiyadikba-wa, “Nguminu-mambakina-mubaba wurrangariya nungkwa-langwa, kembirra yingu-ngkweningabakajungwunama dakina ngayuwa-wa,” yingi-yama. “Ngayabakiya-ba ningena yirra-makama nungkuwa ningkeniki-rndirrka dakina didarringka,” yingi-yama. “Akena yingu-ngkweningabakajungwunamurra daka yingu-mambakina-mulangwa wurrangariya. Yingi-yengbiyengbeyinamurra ngayuwa-wa ayakwa awurruwurrariya, akwa yingi-yaminjaminamurra ngawa daka arngkababurna-langwa,” yingi-yama dakina Jeraya. “Yimiyambena-kiya yeningaba-kiya, nungkuwa yinda ngayuwa? En-engkirrikaja kembirra Yaweya nakina-da,” yingi-yama Jeraya dakina Aburemu-wa-da. ");
INSERT INTO aoi_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Eneja Aburema ni-yama, “Nungkwa-langwa-bina daka didarringka-da, akwa nungkwa-langwa-bina warka nguminu-war•duwar•denama-da. Nungkuwa-bina ningkinga-war•dikinama ningkakina-da, kembirra ki-yaminama ningkakina nungkwabakiya-ba dakina-manja didarringka,” ni-yama Aburema ngaluwa-wa. Kembirra akini-yada ngawa ngalaja dakina Jeraya dubardijene-ka nanga-rinjirinjarrkama dakinu-wa Yeka. Nanga-larrkbarjanguma eka-murra ebina ayakwa yingi-yengbeyinu-mulangwa awurrariya ngaluwa-wa. Ngalaja kembirra yingi-lyumada arakba Yeka dakina-da. ");
INSERT INTO aoi_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Kembirra yingi-lyumada arakba Yeka. Yingi-likenumurra engku-wa angalya engburingka-wa nara-murruwa warnumamalya kuw-ambambilya. Yinguma-yuwarnuma mamurukwa mibina numu-likenumurra angerriba akinu-wa angalya emikirra Jura. Ying-alilikena dakina ngawu...wa, yanda-langwa ying-akburranga arakba lukwakwa emedirra akungwa. Akina-manja ngawa angalya eneja nakina nenikumamurikaja Yaweya-langwa nang-akburranga yakwujina-da. ");
INSERT INTO aoi_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Biya ni-yama nakina Yeka-wa, “Ningkena-bina ningkidarringka ningkibina ningkingaminu-war•duwar•danguma warka Jeraya-langwa-na?” ni-yama nakina. “Ningki-yaminjamarrkinama ningkena yelakwa? Ngamba-langwa ningkena ningki-likenuma akwa ngambu-wa ningki-likajama ningkena?” ni-yama. Ngalaja Yeka yingi-yama enuwa-wa, “Ningene-ka ningi-lyumaduma Jeraya-langwa.” ");
INSERT INTO aoi_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Eneja ni-yama nakina ngaluwa-wa, “Jeyi! Lawurradina Jerayu-wa akwa kingaminu-war•dena warka ngala-langwa, mena ngu-mangu-murrada nungkuwa ngala-langwi-yada ningkakina. ");
INSERT INTO aoi_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Umba ngayuwe-ka ningena yiba-kwunama wurrababurna warnikinikaduwa ambinya nungkwa-langwa. Kembirra aburraja ka-wurramur•dinama wurrakina. ");
INSERT INTO aoi_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Nungkwaja kin-arrangbinama nenungkwarba niyukwujiya nungkwa-langwa akwa kini-yengbijinama nenimikirra Yijumeyila, mena ngayuwa ning-engkirrikenu-mubaba aduwaba nungkwa-langwa angwada ningku-ngwadinuma ningkakina,” ni-yama nakina Yeka-wa. Akine-ka ekirra Yijumeyila ne-yaminama “Neningikarrawara n-engkirrikajama.” ");
INSERT INTO aoi_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Biya ni-yama ngarningka nakina nenikumamurikaja ngaluwa-wa, “Nakine-ka naburrena nungkwa-langwa warningerriberriba wuburra kini-yaminama nakina. Akwa ken-awinyambakinama nakina awinyamba warningerribirra-manja warnumamalya. Aburrajukwaba kembirra arrkala ke-yaminama enuwa-wa-da. Kin-ambilyama nakina nakwukawura wurreyebijeba wurrumurndakakina-langwa warnumamalya ena-langwa-langwa-da,” ni-yama nakina nenikumamurikaja Yaweya-langwa Yeka-wa-da. ");
INSERT INTO aoi_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","“Wa!” yingi-lyangkiyama ngalaja Yeka. “Nare-ka nakina Yaweya-langwa nenikumamurikaja. Nakina-bina ningeni-rringkama Yaweya yimbukwa umba nara wurrukwala. Nganyangwa-murra menba ningeni-rringkama akena ningena ngawa ningeniba ning-ambilyama ngayuwa-da,” yingi-yama. Biya kembirra ni-yengbinu-mulangwa Yaweya ngaluwa-wa yingini-yengbijuwama nakina “Neningikarrawara Nibina Ngini-rringkinama Ngayuwa.” ");
INSERT INTO aoi_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Kembirra duminakina-langwa-manja ayakwa aburarrka, ebina emedirra akungwa aburraja wurrukwala narri-yengbijuwama wurrakina aduwaba “Numinakina Emedirra Akungwa Neniba Nakina akwa Ngini-rringkinama Ngayuwa.” Umba akine-ka emedirra akungwa nuw-ambilyumurra akina wilyarra Kedeja-langwa akwa ngawa Bereda-langwa. ");
INSERT INTO aoi_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Ngalaja kembirra dakina Yeka yingi-lawurradina arakba Jerayu-wa akwa yakwujina yinginumin-arrangba nangariya Aburema-langwa dakina-da. Eneja Aburema neni-yengbijuwa nakina nangariya nenikuwenikba Yijumeyila-da. ");
INSERT INTO aoi_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Biya ni-rukwularru-manja nakina nangariya, nakine-ka Aburema n-ambilyuma 86 mamarika iya yinungkwura. Neniyuwangkwe-ka arakba n-ambilyumurra akina-manja angalya-da. ");
INSERT INTO aoi_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Aburema arakba nakina n-ambilyuma 99 mamarika iya yinungkwura. Kembirra arakba eneja nakina Yaweya n-abilyerrikajungwunuma enuwa-manja akwa ni-yama, “Ngayuwe-ka ningena Ningeningikarrawara ningarrubuda-dangwa, akwa nungkuwa yikumini-yarrkuwarakinama ngawa nganyangwa ayakwa,” ni-yama nakina. “Akwa ki-yaminjaminama ngawa eningaba-wiya arngkababurna-langwa,” ni-yama nakina. ");
INSERT INTO aoi_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","“Yalakena yi-yarrkakumurnama aduwaba eningarumuruma ayakwa yididirrbura, akwa nara a-yarrkuwarrukwajuma ngarningka. Enena ngawa arakba ayakwa eningarumuruma ningi-yarrkakumurnama ngayuwa nungkwa-langwa kajungwa kuw-ambilyi-yada akina eningangkawura-da. Yiba-kwunamurra wurrababurna numirena-murriya warnikinikaduwa nungkwa-langwi-yada,” ni-yama Yaweya Aburemu-wa. ");
INSERT INTO aoi_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Eneja nakina Aburema n-abuluwendinga arakba akwa n-engmudirruwajungwa nenumukwurra angerriba ajiringka-wa kajungwa neniki-yangmarngkwaji-yada nakina Neningikarrawaru-wa. Eneja ni-yama ngarningka Neningikarrawara Aburemu-wa, ");
INSERT INTO aoi_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“Enena ayakwa eningarumuruma yirra-wekbilyenama nungkwa-langwi-yada akwa nara a-yarrkuwarrukwajuma ningena. Yirra-makinama amandangwa ningena ningkakina-bina ngawa ningkuwilyaba-ma ningkeningadinuba-wiya ningkumirarringba wurrilyimberrkwulyumida-langwa warnumamalya wurrilyimberrkeyebijeba iya wurrilyimberrkeyebijeba. ");
INSERT INTO aoi_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Biya aduwaba-langwa arakba nara nungkwa-langwa ekirra Aburema umba arakba Aburiyama ningkakina ningkenimikirra. Enena ekirra enikaduwa yirra-kwunama nganja nungkuwa-wa mena-baba ningkumirarringba ningkeningadinuba-wiya ki-yengbijajungwunama nungkuwa wurrilyimberrkwulyumida-langwa warnumamalya wurrilyimberrkeyebijeba iya wurrilyimberrkeyebijeba,” ni-yama Neningikarrawara Aburemu-wa. Akine-ka ayakwa ni-yengbinuma nakina, mena akina ekirra Aburema ne-yaminama “numirarringba numikbiyiya,” umba ngalaja ekirra Aburiyama ne-yaminama “numirarringba wurrababurna-langwa warnumamalya.” ");
INSERT INTO aoi_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Biya kembirra ni-yama ngarningka Neningikarrawara Aburiyamu-wa, “Yiba-kwunama ngayuwa wurrababurne-ka warnikinikaduwa numirena-murriya nungkuwa-wa. Aburraja wurrukwala wurrububungkawa wurrakina ka-bungkawadinama aburra-langwa-manja angalya. Wurrakine-ka nungkwa-langwa kuw-ababurnadinama warnikinikaduwa numirena-murriya ka-wurrakwulyumidadinama yanda-langwa wurrilyimberrkwulyumida warnumamalya wurrilyimberrkeyebijeba iya wurrilyimberrkeyebijeba kuw-ambilyama wurrumurndakakina arakba-da. ");
INSERT INTO aoi_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","“Nare-ka nganja ningena a-yarrkuwarrukwajuma enena eningarumuruma ayakwa ningi-yarrkakumurnama aduwaba. Umba eningangkawura ngawa kuw-ambilyama nungkwa-langwi-yada akwa ngawa nungkwa-langwi-yada numirena-murriya warnikinikaduwa aburrajukwaba. Ningene-ka nungkwa-langwa Ningeningikarrawara aduwaba akwa ngawa ningeningangkawura ngawa-da, akwa ngarningka nungkwa-langwa-langwa numirena-murriya warnikinikaduwa-langwa-da. ");
INSERT INTO aoi_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Ningkakine-ka ningk-ambilyamurra enena-manja angalya aduwaba ningkuminjirrkingka ningkakina. Akena yiba-kwunama enena ngawa angalya nungkuwa-wa akwa ngawa nungkwa-langwu-wa numirena-murriya warnikinikaduwa. Enene-ka angalya wurrukwala-langwa aduwaba ena, umba nungkwurra-langwa kuw-ambilyamurra akina ambaka-murra. Enena ngawa aringbirra angalya Kenina nungkwa-langwa-langwa numirena-murriya warnikinikaduwa-langwa eningangkawura-da. Kembirra ngayuwe-ka ningena aburra-langwa Ningeningikarrawara ningeningangkawura-da,” ni-yama nakina Neningikarrawara Aburiyamu-wa. ");
INSERT INTO aoi_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Biya ngarningka ni-yama nakina Neningikarrawara enuwa-wa, “Nungkuwa ningkena ki-yarrkilyinginama ki-yarrkilalikinama enena eningarumuruma ayakwa ningi-yarrkakumarnuma ngayuwa nungkuwa-langwi-yada aduwaba. Akwa nare-ka a-yarrkuwarrukwajuma nungkuwa akwa numirena-murriya warnikinikaduwa nungkwa-langwa aburrajukwaba. ");
INSERT INTO aoi_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Nungkwamba-langwa ki-yarrkakumurnama nungkwa-langwa eningarumuruma ayakwa akwa ka-ringandenama ka-mukaduwamurrikinama ningkakina nungkwa-langwa warnungkwarba wurrababurna-langwa. Akwa ngarningka aburrajukwaba nungkwa-langwa numirena-murriya warnikinikaduwa ke-yaminama ngawa wurrakina, karra-mukaduwamurrikinama aburra-langwa warnungkwarba wurrababurna-langwa. Yikumurndaki-yarrkuwilyakinama enena eningarumuruma ayakwa kirrababurna-langwa. ");
INSERT INTO aoi_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","12","Aduwaba-langwa yika-mukaduwamurrikinama wurriyukwayuwa warnungkwarba wurribina ka-rukwularrina-manja mamangbala mabiyakarbiya-manja mamawura. Nara wulkwa nungkwa-langwa yimbukwa warnumamalya umba aburraja wurribina ningkarra-manguma ningku-beyindanguma warnumamalya kabuminu-war•deni-yada warka nungkwa-langwa, ke-yaminama aburrajukwaba wurrakina. Karra-mukaduwamurrikinama aburra-langwa warnungkwarba wurriyukwayuwa aburrajukwaba. Mama na-rukwularrinuma nungkwa-langwa-manja angalya akwa ngarningka eminingka-manja angalya, ke-yaminjaminama ngawa wurrakina akina. Kembirra ki-yamina-manja nungkuwa akina, aburraja wurrababurna-langwa warnumamalya kuw-eningmidinama wurrakina yalakena nungkuwa akwa ngayuwa yi-yarrkakumarnuma enena eningarumuruma ayakwa yididirrbura yalakena aduwaba-da,” ni-yama Neningikarrawara Aburiyamu-wa. ");
INSERT INTO aoi_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Biya ngarningka ni-yama nakina enuwa-wa, “Nara wurrukwala wulkwa a-mukaduwamurrikama nungkwa-langwa warnumamalya umba wurrababurna-langwa warnungkwarba ka-mukaduwamurrikinama ngawa ningkakina. Kembirra yiki-yamina-manja nungkwurruwa kirrakina akina, akine-ka ka-jirrkumakajungwunama enena ayakwa eningarumuruma yi-yarrkakumarnuma yalakena yakuwa yididirrbura akwa nara a-yarrkuwarrukwajuma akina umba eningangkawura kuw-ambilyamurra. ");
INSERT INTO aoi_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Aburraja kembirra wurribina warnungkwarba nara-murrumurra karra-mukaduwamurrika, kembirra nare-ka arakba nganyangwa warnumamalya wurrakina, mena nara-baba ebina ayakwa eningarumuruma karri-yarrkilyinga wurrakina-da,” ni-yama nakina Neningikarrawara Aburiyamu-wa. ");
INSERT INTO aoi_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Biya ngarningka ni-yengbinuma Neningikarrawara enena ayakwa Aburiyamu-wa. “Nara arakba ningkena e-yengbijuma dakina dadingiyena dadimikirra Jeraya, umba aduwaba-langwa arakba kinga-yengbijinama Jera. ");
INSERT INTO aoi_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Ningena nganja ki-yaminama eningaba ngaluwa-manja. Yiba-kwunamurra kembirra nenikuwena ningkena, akwa naka nenikuwena nungkwa-langwa kembirra Jera-langwa naburradikba. Ngayuwe-ka ki-yaminama eningaba Jera-manja. Ngalaja dakina duminjarringba dadingadinuba-wiya king-ambilyama wurrilyimberrkwulyumida-langwa warnumamalya wurrilyimberrkeyebijeba iya wurrilyimberrkeyebijeba. Kembirra aburraja wurrukwala warnikabijada warnikinikaduwa ngala-langwa wurrakina wurrububungkawa ka-bungkawadinama aburra-langwa-manja angalya-da,” ni-yama Neningikarrawara Aburiyamu-wa-da. ");
INSERT INTO aoi_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Eneja Aburiyama kembirra n-abuluwendinga n-engmudirruwajungwa angerriba nenumukwurra ajiringka-wa kajungwa neniki-yangmarngkwaji-yada Neningikarrawaru-wa. Akena ni-jungwa amarngka, mena-baba ni-lyangkiyama nakina, “Ki-yamarrkama k-akumajungwunama wurrangariya 100 mamarika-manja iya yinungkwura-manja ningena? Akwa ngarningka kingi-yamarrkama daka Jera karring-arrangbama wurrangariya 90 mamarika-manja iya yinungkwura-manja arakba? Dadiyuwangkwe-ka arakba daka!” ni-lyangkiyama Aburiyama. ");
INSERT INTO aoi_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Biya ni-yama arakba nakina Neningikarrawaru-wa, “Miyambena-burra nara Yijumeyila a-manguma amurndakijika-murriya nganyangwa ki-jungwa-manja?” ni-yama nakina. ");
INSERT INTO aoi_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Eneja Neningikarrawara ni-yama, “Ngarra! Dake-ka dadingiyena Jera kangumin-arrangbinama ningkena nangariya nungkwa-langwa-da! Akwa kembirra kini-yengbijinama ningkena nenimikirra Ajika,” ni-yama. Akine-ka ayakwa ni-yengbinuma Neningikarrawara mena akina ekirra Ajika ne-yaminama “nu-marngkinama.” Biya kembirra ni-yama ngarningka Neningikarrawara, “Ngalaja ebina ayakwa eningarumuruma ningi-yarrkakumarnuma ngayuwa aduwaba kembirra ena-langwa enejukwaba akina, akwa nara kembirra akina a-yarrkuwarrukwajuma. Akina ngawa eningarumuruma ayakwa kuw-ambilyama eningangkawura, ena-langwi-yada akwa ngawa ena-langwa-langwa wurrumirumirena warnikinikaduwa eningangkawura. ");
INSERT INTO aoi_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Umba ebina ayakwa yi-yengkilabenuma Yijumeyila-langwa ning-engkirrikenuma. Akwa kembirra nganja ningena ki-yaminama eningaba enuwa-manja, akwa kembirra kinu-kwunama wurrababurna wurriyukwayuwa akwa ngawa wurrababurna wurrumirumirena warnikinikaduwa ena-langwa. Aburraja kembirra ena-langwa warninikuwena wurrumemberrkwa wurrambilyuma wurrububungkawa wurrakina ka-bungkawadinama aburra-langwa-manja angalya wurrakina. Ena-langwa wurrumirumirena warnikinikaduwa wurrababurna kuw-ambilyama wurrilyimberrkwulyumida wurrilyimberrkuwilyaba warnumamalya wurrakina-da. ");
INSERT INTO aoi_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","“Umba nakina Ajika ngalaja Jera kingin-arrangbinamurra nakina mingka-manja mamarika. Kembirra ebina ayakwa eningarumuruma yi-yarrkakumarnuma yalakena aduwaba, akina ki-yarrkilyinginama ngawa nganja enamba-langwi-yada Ajika yimbukwa-da,” ni-yama Neningikarrawara Aburiyamu-wa-da. ");
INSERT INTO aoi_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Biya ni-jerrukwa-manja ayakwa nakina Neningikarrawara neni-lalika arakba Aburiyama-da. ");
INSERT INTO aoi_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Kembirra makini-yada ngawa mamawura eneja nakina Aburiyama nenumini-yarrkuwarakama ayakwa Neningikarrawara-langwa. Biya kembirra arakba neni-ringandanga nenu-mukaduwamurrika nakina nenikuwenikba Yijumeyila-manja, akwa ngawa wurrababurna-manja warnungkwarba wurribina nuw-ambilyu-murrumanja ena-langwa-manja angalya. Nenu-mukaduwamurrikama nakina ena-langwa warnikuminuwar•duwar•da wurribina nu-beyindanguma nakina, akwa ngawa wurribina nawurraki-rukwularrinuma ena-langwa-manja angalya akwa ngawa wurrababurna-langwa wurriyukwayuwa ena-langwa-langwa warnikuminuwar•duwar•da aburrajukwaba nakina-da. ");
INSERT INTO aoi_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Biya Aburiyama arakba nakina 99 mamarika iya yinungkwura n-ambilyuma akini-yada ngawa nenu-mukaduwamurrika-manja wurrakina enuwa-manja, ");
INSERT INTO aoi_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","umba eneja nenikuwenikba Yijumeyila nakina mememberrkwa mabiyakarbiya mamarika iya yinungkwura n-ambilyuma. ");
INSERT INTO aoi_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Wunalakina ngawa narralirraku-mukaduwamurrikama muwilyaba-murra-manja mamawura wunididirrbura-da. ");
INSERT INTO aoi_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","Akwa ngarningka aburraja wurrumurndakibina warnungkwarba nuw-ambilyu-murrumurra Aburiyama-manja akwa nenuminu-war•duwar•danguma warka ena-langwa narra-mukaduwamurrikama aburrajukwaba makina-manja ngawa mamawura wurrididirrbura-da. ");
INSERT INTO aoi_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Nakina Aburiyama n-ambilyuma amurndakibina-manja eka akwurdukwurda nuw-arndurrkwarjeyinu-murrumanja Mamura-langwa-manja angalya. Yakwujina ngawa eneja Yaweya nakina ngarningka ni-jadingama arakba enuwa-manja. Memerrkuwilyarra-manja mamawura nakina Aburiyama n-angmakwulaluma mamukwudidikajungwa-langwa-manja kalikwa. ");
INSERT INTO aoi_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Biya n-andiyinga akena neni-rringka wurrabiyakarbiya warnungkwarba nabuk-alkilkayanguma yakwujina. Biya nu-warumajungwa nakina Aburiyama warenja-bawiya akwa n-angkarra aburrubukwurruwa-wa nenu-wengmanga. Akwa n-abuluwendinga n-engmudirruwajungwa nenumukwurra ajiringka-wa, mena akini-yada ne-yaminjamama akina ne-yar•dangu-manja wurruminjirrkingka warnumamalya aburra-langwa-manja angalya. ");
INSERT INTO aoi_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","Biya ni-yama Aburiyama wurrubukalakinu-wa, “Yelakwa ambaka wurrubuk-ambilya, nara a-likama,” ni-yama nakina. “K-embirrajinama kirrubukalakina ngayuwa,” ni-yama. ");
INSERT INTO aoi_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","“Ng-akarrnga-langwa ambaka akungwa kajungwa yikubuk-ajirreni-yada alika. Ene-ka eningaba alungkuwarruwalya eka. Kwa, wurrubuk-angmakayiya-langwa yelakwa,” ni-yama nakina. “Wurrubuku-ngwanja-langwa aduwaya-wiya. ");
INSERT INTO aoi_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Nganja ke-yikajama aninga yangkwurrangwa yikubuk-alyubarini-yada kajungwa yikubuki-likaja-manja ngarningka kirrarrubudi-yada nungkwurrubukwurruwa. Ningene-ka ningi-lyelyingminama kirri-likenu-mulangwa karna nganyangwu-wa angalya, kemba k-embirrajinama karna ambaka,” ni-yama Aburiyama. “Yawa,” nabuki-yama. “Akine-ka eningaba ningkakina ningki-yaminama yirruwa-manja,” ne-yama. ");
INSERT INTO aoi_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Kembirra Aburiyama nakina n-enjirrikaja n-angkarra arrawu-wa Jera-wa akwa nanga-maka, “Warenja, wu-miya aruma aninga ebina eningaba-dangwa, wu-ngwurrungkwa damba,” ni-yama ngaluwa-wa. ");
INSERT INTO aoi_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Biya ngarningka n-angkarra nakina errekbu-wa, akwa nuwurrak-erruwarna bulukwa eyukwayuwa engmurra-murrikba eningaba warnik-alyubari-yada, akwa nenu-kwa ena-langwa-manja nenungkwarba nibina nenuminu-war•duwar•dangu-murrumanja. Eneja kembirra ni-ngaja nakina nenungkwarba akwa ni-daka akina-da. Ngalaja kembirra na-dadina akina amadangkwa biya yanda-langwa na-walyuwada. ");
INSERT INTO aoi_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Biya kembirra nu-manga Aburiyama akina amadangkwa awalyuwa, akwa ngawa milka, akwa ngawa mamalya, akwa ngawa aninga, akwa neni-yikena wurrubukalekbinu-wa wurrubukenungkwarba-da. Ebina-manja eka awarruwalya enuwa nen-embirrajuwama enabakiya-ba wurrubukalakina nabuk-alyubarinu-wiya aninga yakwujina-da. ");
INSERT INTO aoi_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Biya nabuki-yama Aburiyamu-wa, “Dangamba nungkwa-langwa dadingiyena Jera?” ne-yama. Ni-yama Aburiyama, “Dangaba arrawa.” ");
INSERT INTO aoi_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Umba nuwilyaba nenungkwarba Yaweya nakina. Biya ni-yama nakina Aburiyamu-wa, “Yimangbala yabiyarbuwa-manja yimawura yangkwurrangwa ki-lawurradinama ningena. Kembirra ngalaja dakina dadingiyena kingin-arrangbinama nangariya,” ni-yama. Ngalaja dakina Jera ying-ambilyuma enuwa-manja akwaburrangarna. Kalikwa-manja arrawa yingamu-didirrakama mamukwudidikajungwa. Akena ying-engkirrikenuma dakina akinu-wa ayakwa na-lyelyimbukweyinu-murruwa Aburiyama iya wurrubukalakina wurrubukenungkwarba. ");
INSERT INTO aoi_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Wunalakine-ka Aburiyama akwa dadingiyenikba nen-eniyuwangkwudinume-ka wunalakina-da. Neniyuwangkwa arakba nakina. Ngalajukwaba Jera dadiyuwangkwa arakba dakina, akwa numi-jerriduma arakba menikakbuburranga ngala-langwa-da. ");
INSERT INTO aoi_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Biya kembirra dakina Jera yingu-marngka amurama-langwiya. Akwa yingi-lyangkiyama, “Ki-yamarrkamurra kembirra ningena k-arrangbama wurrangariya? Ningadiyuwangkwa-manje-ka ningena ningu-murndakayuwayida-manja arakba-na! Ki-yamarrkama ningena?” yingi-yama. “Nganyangwe-ka neningiyarrka neniyuwangkwa arakba naka-da. Yikini-yamarrkama yik-arrangbama wurrangariya?” yingi-yama. ");
INSERT INTO aoi_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Eneja ni-yama nakina Yaweya Aburiyamu-wa, “Miyambena-burra dadingiyena yingu-marngkinuma dakina amarngka? Miyambena-burra dakina yingi-yamama, ‘Ningena amandangwa k-arrangbiname-ka wurrangariya? Ningadiyuwangkwa-manja?’ yingi-yamama dakina. ");
INSERT INTO aoi_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Ngayuwe-ka ningena Yaweya ningibina ki-yamina-mulangwa eningerribirra ababurna-langwa. Arakba ningi-yamama ningi-yengbinuma ngayuwa enena ayakwa, ‘Yimangbala yabiyarbuwa-manja yimawura ki-lawurradinama ningena ngayuwa. Kembirra akini-yada ngawa ngalaja Jera kingin-arrangbinama nangariya,’ ningi-yamama ngayuwa-da,” ni-yama nakina Yaweya Aburiyamu-wa-da. ");
INSERT INTO aoi_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Ngalaja Jera ying-engkirrika akina ayakwa arrawa-langwa ni-yengbinuma Yaweya. Biya ying-akbar•de-ka dakina, akwa yingi-yama, “Nara ngaya ku-marngkina-da,” yingi-yama dakina-da. Eneja Yaweya ni-yama nakina, “Yawe-ka. Amandangwe-ka ningku-marngkinuma ningkakina-da,” ni-yama nakina Yaweya-da. ");
INSERT INTO aoi_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Kembirra aburrubukwurraja wurrubukalakina wurrubukabiyakarbiya wurrubukenungkwarba nabuki-lalika arakba Aburiyama-langwa angalya. Umba enejukwaba Aburiyama ni-likenuma ngawa aburrubukwurruwa-manja neni-yakijajuwama. Biya nabuki-likena arakba wurrubukalakina akwa nabuku-wurdanga karrawaru-wa angakarjiyinga-wa angalya akwa narrubuki-rringkama angaluba karrawara-langwa angerriba arrawu-wa Jaduma-wa. ");
INSERT INTO aoi_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Biya kembirra nakine-ka Yaweya ni-lyangkiyama, “Kinu-makinama ngayuwa naka-manja nenungkwarba ki-yamina-mulangwa ngayuwa arija-langwa. Nare-ka ngayuwa a-yarrkabuwarrkuma enena ayakwa nganyangwa Aburiyama-langwa umba k-abilyerrikinama ki-yengbinama akina enuwa-manja aduwaba. ");
INSERT INTO aoi_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Aburraja ena-langwa wurrumirumirena warnikinikaduwa wurrababurna kuw-ababurnadiname-ka yanda-langwa wurrilyimberrkuwilyaba wurrilyimberrkwulyumida warnumamalya wurringbingbuda kuw-ambilyama wurrakina. Ngayuwe-ka ki-yaminama eningaba wurruwurrakwulyumida-manja warnumamalya engkalina-langwa iya engkalina-langwa angalya, wuburra laka ningi-yaminama ngayuwa eningaba enuwa-manja. ");
INSERT INTO aoi_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Naka Aburiyama ningu-wekbalyinuma arakba ngayuwa kajungwa kenu-makini-yada nakina ena-langwu-wa warninikuwena akwa kajungwa aburramba-langwa kabumini-yarrkuwarakini-yada nganyangwa ayakwa aburrajukwaba. Kembirra karra-makinama wurrakina aburramba-langwa aburra-langwa-manja warninikuwarrngwa kajungwa aburrajukwaba kabumini-yarrkuwarakini-yada nganyangwa ayakwa akwa ke-yamini-yada ebina eningaba akwa adirrngekburna. Kembirra kabumini-yarrkuwarakina-manja wurrakina warnumamalya nganyangwa ayakwa ki-yaminame-ka ngayuwa eningaba aburruwa-manja amurndakibina-langwiya eningarumuruma ayakwa ababurna-langwiya ningi-yarrkakumarnu-murrilangwiya ngayuwa Aburiyama-manja aduwaba,” ni-yama ni-lyangkiyama Yaweya. ");
INSERT INTO aoi_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Biya kembirra nakina Yaweya ni-yengbina arakba ayakwa Aburiyamu-wa. Ni-yama, “Bu-makama wurrumurndakangaba warnumamalya WarningiJaduma akwa ngawa WarningiKamara wurruwurrariye-ka wurrilyengma wurrakina. Amandangwa awurruwurrariye-ka ne-yaminjamama warningangkawura. ");
INSERT INTO aoi_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Kembirra kwureya ngi-likajama ngi-dirrirndama ningena akwa ka-rringkinama wurrakina alyangmandukwuna-murrikbe-ka akina ayakwa ning-engkirrikenuma,” ni-yama nakina Yaweya Aburiyamu-wa. ");
INSERT INTO aoi_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Kembirra aburnaja wunambilyuma wunalakina neni-likena neni-dirrirnduma arakba angadingidirra-wa akwa neni-likena erribaja angwurra angerriba Jaduma-wa. Umba eneja Yaweya n-ambilyuma yakwujina akina-manja angakarjiyinga angalya Aburiyama-manja ngawa. ");
INSERT INTO aoi_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Eneja kembirra nakina Aburiyama neni-yendabenuma Yaweyu-wa. Ni-yama, “Jerriya, ningkena amandangwa ka-ngajinama wurrumurndakangaba wurruwurrariya warnumamalya akwa ngawa warninginingaba aburrajukwaba? ");
INSERT INTO aoi_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Dukwa warningaba kuw-ambilya akina-manja angalya arngkumangbala-ma arngkumemberrkwa warnumamalya dukwa-da. Jerriya ka-ngajinama wurrumurndakakina warnumamalya wurrababurna-langwa? Dukwa ki-lalikina akina angalya kajungwa kuw-ambilyi-yada wurringkinyungwurra wurrumurndakakina warninginingaba warnumamalya, dukwa-da. ");
INSERT INTO aoi_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Nare-ka ningkakina a-ngajuma wurrababurna-langwa waka warninginingaba waka wurruwurrariya. Nare-ka. Nare-ka ningkakina-da. Nara ningkakina a-larrkbarjuma warninginingaba warnumamalya. Ningkakina-bina ka-labaja-mulangwa warnumamalya wurrababurna-langwa-da. Kembirra nungkuwa ki-yaminama ebina adirrngekburna ningkakina-da,” ni-yama Aburiyama Yaweyu-wa. ");
INSERT INTO aoi_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Eneja ni-yama Yaweya, “K-akburrangina-manja ngayuwa wurrakina arngkumangbala-ma arngkumemberrkwa wurrumurndakakina warnumamalya warningaba Jaduma-manja aduwaba, kembirra kamini-lalikinama akina angalya aburra-langwa,” ni-yama. ");
INSERT INTO aoi_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Enamba-langwa Aburiyama kembirra ni-yengbina ayakwa nakina. Ni-yama, “Ningumarngba ningena, Bungkawa, umba yimini-lalika-langwa ngi-yengba-langwa ngayuwa angwurra akwala ayakwa. Ningene-ka yande-ka ningiyukwujiya ningenumamalya. Ningeningeningaba-me-ka ningena ningeniki-yengba-langwa ayakwa nungkuwa-wa. ");
INSERT INTO aoi_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Umba arngkabiyarbuwa-ma arngkumemberrkwa warnumamalya akwa ngawa wurrumangbala yimbukwa warninginingaba dukwa wurrakina-da. Kembirra nara-manja ngarningka wurrumangbala warningaba aburrajukwaba, dukwa ningkakina ki-ngajinama ababurna angalya-da?” ni-yama. Kembirra ni-lawurrakaja arakba Yaweya ayakwa Aburiyamu-wa. “Nara. Nara kembirra ningena a-ngajuma akina angalya aduwaba,” ni-yama. ");
INSERT INTO aoi_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Ngarningka nakina ni-yengbina Aburiyama ayakwa. Ni-yama, “Dukwa arngkabiyarbuwa-ma arngkumemberrkwa warnumamalya warninginingaba wulkwa wurrakina. Kembirra ki-yamarrkinama ningkakina?” ni-yama. Eneja ni-yama Yaweya, “Nara kembirra ningena a-ngajuma akina angalya aduwaba,” ni-yama. ");
INSERT INTO aoi_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Enamba-langwa Aburiyama ni-yama, “Marrakba. Nara awinyambaduma, Bungkawa, umba ngi-yengba-langwa ngayuwa ngawa angwurra ningena. Dukwa arngkabiyakarbiya-ma arngkumemberrkwa warnumamalya warninginingaba wulkwa wurrakina. Kembirra ki-yamarrkinama ningkakina?” ni-yama. Eneja ni-yama Yaweya, “Nara kembirra a-ngajuma ngayuwa akina angalya aduwaba,” ni-yama. ");
INSERT INTO aoi_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Enamba-langwa ni-yama Aburiyama, “Ningumarngba ningena ngawa ningi-yengbinama ayakwa nungkuwa-wa, Bungkawa, umba yimini-lalika-langwa ngi-yengba-langwa angwurra ngawa. Dukwa arngkambilyuma-ma arngkumemberrkwa warnumamalya warninginingaba wulkwa wurrakina. Kembirra ki-yamarrkama ningkakina?” ni-yama. Eneja ni-yama Yaweya, “Nara kembirra a-ngajuma ngayuwa akina angalya aduwaba.” ");
INSERT INTO aoi_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Enamba-langwa ni-yama Aburiyama, “Marrakba. Nara awinyambaduma, Bungkawa, umba ngi-yengbinama ngayuwa arngkawura ngawa-da. Dukwe-ka wurrumemberrkwa wulkwa warninginingaba warnumamalya wurrakina-da. Kembirra ki-yamarrkama ningkakina-da?” ni-yama Aburiyama Yaweyu-wa. Eneja ni-yama Yaweya, “Wurrumemberrkwa warnumamalya warninginingaba kuw-ambilya-manja, kemba nara ningena a-ngajuma akina angalya-da.” ");
INSERT INTO aoi_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Kembirra ni-jerrukwa Yaweya ayakwa akwa ni-likena arakba neni-lalikama Aburiyama nakina-da. Eneja Aburiyama kembirra ni-lawurradina arakba angalyu-wa-da. ");
INSERT INTO aoi_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Aburnaja wunalakina-kiya wunenikumamurikaja Yaweya-langwa neni-dirrirnduma ebina-langwa angalya na-ngakarjeyu-mulangwa akwa neni-likenuma ngawa wunalakina neni-dirrirnduma angerriba Jaduma-wa. Nen-alilikenuma ngawa wunalakina bi...ya yanda-langwa nume-merrkawiyebu-manja mamawura neni-yar•duma wunalakina yakwujina. Nakina eneja Lada ni-rrakirrakarjeyuma na-ngwur•dangminu-murrumanja akawiyuwiyeba. Biya neni-rringka-manja wunalakina wunambilyuma wunenungkwarba-kiya wunalabukwaya neni-likenuma, nu-warumajungwa nakina akwa ni-likena nenuminu-wengkarrngarnuma. Biya n-abuluwendinga nakina wunalakina-kiya-manja mena ne-yaminjamama ngawa warningakwujina warnumamalya akini-yada ngawa ne-yar•dangu-manja wurruminjirrkingka warnumamalya aburra-langwa-manja angalya. ");
INSERT INTO aoi_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","Ni-yama nakina wunalakina-kiya-wa, “Ngayuwa yelakwa ng-ambilyama kajungwa kalirrak-akwurrajini-yada nungkwurnuwa. Kwa, wuni-likaja nganyangwu-wa angalya. Yikin-ajirrena nungkwurna-langwa alika akwa yikin-ambilya aduwaba muwilyaba marringa ngayuwa-manja. Kembirra wurdarriya-wiya yikinu-mirajangina akwa yikini-likaja kinalakina,” ni-yama. Aburnaja neni-yama wunalakina, “Nara. Yinalakena ngawa yin-ambilyama yelakwa mamurukwa-manja.” ");
INSERT INTO aoi_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Eneja Lada neni-yendabenuma ngawa niyirrbiyirrba. Kembirra arakba-langwa neni-lyangkuwama wunalakina akwa nabuki-likena kembirra ena-langwu-wa angalya. Biya Lada nenu-maka ena-langwa-manja warnikuminuwar•duwar•da kajungwa warniki-daki-yada damba akwa warnikumin-akumi-yada akwala aninga wunalakina-langwa wunenungkwarba-kiya. Biya na-walyuwa-manja akina damba kembirra nen-alyubarina arakba wunalakina. ");
INSERT INTO aoi_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Akena nara-wiya kenu-mungkwula wunalakina wunenungkwarba-kiya, aburraja wurrababurna-langwa wurruminakina WarningiJaduma warnungkwarba namurndaki-likenuma akinu-wa alikira Lada-langwu-wa. Narri-rukwulyuwakajuwama wurrumurndakakina ena-langwa alikira, waka wurrarumuruma warnungkwarba umba waka wurriyukwayuwa wurrakina. ");
INSERT INTO aoi_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Biya namurndak-ardanga wurrakina Ladu-wa. Ne-yama, “Wunalangamba wunalekbina wunenungkwarba-kiya nen-ambilyuma nungkuwa-manja?” ne-yama. “Wurralirraku-wilyakina yangkwurrangwa yirruwa-wa. Yirra-ngayindename-ka wunalakina yiku-mungkwulama,” ne-yama. Akena wurruminakina WarningiJaduma warnungkwarba narralirraki-ngayindangume-ka wunalakina warniki-yami-yada awurrariya aburnuwa-manja. ");
INSERT INTO aoi_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Eneja ni-likena Lada errekbu-wa ni-jadanga akwa ngawa ni-didanga akididijungwa. ");
INSERT INTO aoi_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","Ni-yama nakina aburruwa-wa, “Nganyangwa karnumamalya kirrakina-da. Ngakwurruwa-murra, nare-ka nungkwurraja e-yamama akina awurrariya. ");
INSERT INTO aoi_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Wurringambilyuma dadiyawarrka-kiya ningarralirraku-wilyakinama nganyangwa. Akena wurringalakine-ka wurringadiyara-kiya wurringikikamarra-kiya ambaka karnungkwarba. Kembirra ngarralirraku-wilyakinama nganja wurringalakena yangkwurrangwa nungkwurruwa-wa. Kembirra yiki-yaminama kirrakina wurringalakina-kiya-manja ebina yiki-ngayindenama erribirra akena nare-ka warna a-rndirrkama wunalakena wunenumamalya-kiya. Warne-ka nuw-ambilyama nganyangwa-manja angalya akwa kembirra ningarr-akwurrajinama-da,” ni-yama Lada wurrumurndakakinu-wa warnungkwarba-da. ");
INSERT INTO aoi_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Umba aburraja warnungkwarba ne-yama enuwa-wa, “Berra, yama yirruwa-langwa. Ningkakine-ka ningkuminjirrkingka, nara ningkena a-makuma yirruwa-wa yirri-yamina-mulangwa. Yama yirruwa-langwa. Nara-manja, yiki-yaminama angwurra awurrariya nungkuwa-manja-da,” ne-yama. Biya neni-rndirrka nakina Lada akwa angerriba neni-jira alikira-wa. Nawurraki-rnjirrkwuna wurrakina akwudangwu-wa kajungwa warniki-ngkarrngi-yada ebina akungwur•dungwur•dangma. ");
INSERT INTO aoi_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Akena aburnaja wunalakina wunambilyuma wunenungkwarba-kiya neni-lawulawaja ayarrka aburna-langwa, neni-rndirrka wunalakina Lada-manja akwa ngawa nen-arrka arrawu-wa alikira-wa akwa neni-dida akina akididijungwa-da. ");
INSERT INTO aoi_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Akwa wurrumurndakibina errekba-manja nuw-alkayanguma warnungkwarba narra-mimbakama wunalakina kajungwa nari-yada kuw-andeya menba karri-rringka karr-akburrangarna akungwur•dungwur•dangma wurrakina-da. ");
INSERT INTO aoi_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","13","Biya kembirra neni-yama wunalakina Ladu-wa, “Nakine-ka Yaweya n-engkirrikenuma nakina ayakwa warningiyelakwa-langwa warnumamalya wurruwurrariya-langwa wurrilyengma. Kembirra yirreni-larrkama yinuwa yangkwurrangwa yineniki-ngaji-yada ena angalya. Ka-wilyakina-manja kembirra nungkwaja nungkwa-langwa warnumamalya enena-manja angalya, kembirra ka-mena wurrakina akwa ka-jadijina enena-langwa angalya mena yinuwa amandangwa yikini-ngajinama enena angalya-da,” neni-yama Ladu-wa. ");
INSERT INTO aoi_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Eneja kembirra Lada ni-likena wunalekbina-kiya-wa wunenungkwarba-kiya wuneniki-yar•di-yada wurradiyawabulena ena-langwa. Ni-yama wunalakina-kiya-wa, “Wuni-jadiya warenja, wuni-lalika ena angalya mena Yaweya kini-ngajiname-ka ena angalya,” ni-yama. Akena awurrumalya-bu wunalakina neni-yama akwa kembirra nara ken-engkirrikena akinu-wa ayakwa. ");
INSERT INTO aoi_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Bi...ya ne-kbada arakba. Aburnaja kembirra wunalekbina Yaweya-langwa wunenikumamurikaja nenu-maka wunalakina Ladu-wa kajungwa warenja-bawiyi-yada kini-jadanga. “Warenja!” neni-yama. “Wurra-mena dadingiyena akwa dadiyawena-kiya akwa yikubuki-jadena warenja, kajungwa yikini-ngajina-manja yinuwa ena angalya nari-yada a-jungwuma,” neni-yama. ");
INSERT INTO aoi_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Umba eneje-ka Lada n-ambudidinuma. Akena eneja nakina Yaweya n-errukwulina Ladu-wa. Umba aburnaja wunalakina wunenungkwarba-kiya nenumini-rndarrka ayarrka nakina-manja Lada akwa ngawa dadingiyenikba-manja akwa ngawa wurringalakina wurradiyawabulena akwa neni-jadijuwa arakba wurrakina Jaduma-langwa-da. ");
INSERT INTO aoi_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Kembirra nuwilyaba nenikumamurikaja Yaweya-langwa ni-yama nakina aburruwa-wa, “Warenje-ka! Wurr-angkirreyina akwa nara errikerruma. Nara kirrakina a-ngwanjuma enena-manja angalya ekbilyuwalya, umba wurr-angkirreyina amurndakangaba-wa angakarjiyinga angalya kajungwa nari-yada a-jungwuma,” ni-yama. ");
INSERT INTO aoi_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","19","Eneja ni-yama Lada, “Nare-ka. Engku-we-ka amurndakangaba angakarjiyinga angalya. Nara yarna akburranguma-da. Nungkwaja ningk-errukwulume-ka ngayuwa-wa. Ningku-marngkirradinuma arakba ngayuwa-manja akwa y-enibikama. Umba nara yirraja akburranguma amurndakangaba angalya awilyikerra-babe-ka, umba wilyarra ki-jungwunama ningeningangkawura. ");
INSERT INTO aoi_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Kwujukwuja! Andiya angerriba amurndakangaba-wa ambawura alikira awarrngkakwudangwa. Yi-larrkaja akinu-wa ngi-likaja. Andiya angerriba akwa wu-rringkina akina angalya eyukwujiya. Ki-likaja-manja ngayuwa akinu-wa ningingkinyungwurra k-ambilyama yakwujina,” ni-yama nakina Lada. ");
INSERT INTO aoi_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Eneja ni-yama nakina nenikumamurikaja, “Yawa. Nara a-ngajuma angaba angalya, umba likaja kembirra akinu-wa. ");
INSERT INTO aoi_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Angkarrina warenja. Nara ambaka nganja a-ngajuma angaba angalya yanda-langwa ki-yar•diyama nungkuwa yakwujina akina-manja angalya eyukwujiya,” ni-yama. Kembirra aburraja narri-yengbijuwama warnumamalya akina angalya emikirra Jawa, mena akina ekirra Jawa ne-yama-mubaba “eyukwujiya,” akwa Lada ni-yama-mubaba nakina, “Eyukwujiya akina angalya.” ");
INSERT INTO aoi_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Aburrubukwurraja Lada nakina akwa ngawa ena-langwa wurrambawura warnumamalya nabuk-enjirrikeyinuma nabuki-likenuma ngawa akinu-wa angalya. Ngalaja makina mamawura nume-merrkuwurdanguma arngkidarrba. Kembirra Lada-murriya narrubuk-akburranga arakba akina angalya Jawa. ");
INSERT INTO aoi_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Kembirra adirrariyaba eneja nakina Yaweya ni-larrija akina arakba angwura alingena-ma alekbina-kiya-wa angalya Jaduma akwa Kamara. ");
INSERT INTO aoi_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Nilirraki-ngajama alakina angalya-kiya akwa ngarningka amurndakibina angalya ekbilyuwalya nuw-ambilyu-murrumurra akwudangwa alakina-manja angalya. Aburrajukwaba warnumamalya wurribina nuw-ambilyu-murrumurra alakina-kiya-manja angalya na-jungweyinuma wurrakina-da. Ebina ngarningka na-lungkuwarreyinuma eka iya eningerribirra amarda na-jungweyinuma ngalajukwaba akina. ");
INSERT INTO aoi_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Ngalaja dadingiyenikba Lada-langwa ying-errikerra dakina akena yingi-jungwa arakba. Ngalaja ebina angwura alingena-ma yingaku-wurumbija yingaku-kwurrakika dakina-da yanda-langwa wuburra angwarnda yingi-yama arakba-da. ");
INSERT INTO aoi_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Bi...ya mingka-manja meninguwurdarriya-wiya mamawura nu-mirajanga nakina eneja Aburiyama akwa ni-likena ebinu-wa angalya neni-lyelyimbukweyinu-murruwa ebina-wiya aburnuwa Yaweya. Ni-likenuma nakina n-enjirrikeyinuma angerriba angakarjiyinga-wa, nu-wurdanguma karrawaru-wa ");
INSERT INTO aoi_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","akwa kembirra n-andeyuma nakina angerriba arrawu-wa angadingidirra-wa. N-andeyuma alakina-kiya-wa angalya Jaduma akwa ngawa Kamara akwa ababurna-langwu-wa angalya ekbilyuwalyu-wa, akena ni-rringkama nakina angwarra nuw-angkarrkayanguma akina. Angwarra-wiye-ka akina amakwulyumida angalya. Na-wurumbijuwame-ka angwarra akina-manja angalya angwura-wiya. ");
INSERT INTO aoi_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Eneja Neningikarrawara ni-ngajama akina-manja angalya Jaduma n-ambilyu-murrumanja adinuba-wiya nakina Lada akwa ngawa Kamara-manja. Akena ni-yakuwerribikinuma nakina Aburiyamu-wa akwa neni-larrkama nakina Lada ni-lyumaduma ebinu-wa angalya Jawa ningkinyungwurri-yada nakina-da. ");
INSERT INTO aoi_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Eneje-ka Lada n-akbar•danguma akwa nara kini-ngayindanga kin-ambilya yakwujina Jawa-manja. Kembirra nenilirraku-wilyaka wurradiyawabulena engku-wa angakarjiyinga-wa angalya akwa yakwujina ngawa nabuki-yakeyinuma wurrubukalakina medirra-manja arrawa. ");
INSERT INTO aoi_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Kembirra diyabadikba nanga-maka dadiyamarnjadikba-wa. “Nungwarrke-ka naka n-eniyuwangkidinama arakba,” yingi-yama. “Akwa nara wurribina warnungkwarba enena-manja angalya neningiyarrka-murriya yakuwa-langwa-da kajungwa wurriyukwayuwa yenik-arrangbi-yada yakuwa yalakena-da. ");
INSERT INTO aoi_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Umba kwa, yeni-bekajina amalyirra akwurena-langwa naka nungwarrka kajungwa kinu-bungwurridini-yada akwa yaku-mungkwuli-yada enuwa-manja yakuwa akwa yakeni-ngbadikini-yada,” yingi-yama dakina daruma-dangwa dadiyamarnjadikba-wa. ");
INSERT INTO aoi_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Kembirra makini-yada ngawa meningalyarrngwalyilya marringa narringini-bekajuwama amalyirra akwurena-langwa. Eneja kembirra ni-bibekinu...wa yanda-langwa nu-bungwurriduma nakina. Umba kembirra daruma-dangwa dadiyawenikba yingu-mungkwula arakba nungwadikba-manja dakina. Akena eneja nu-bungwurridinu-mubaba nakina kembirra nu-ngwarndirrijungwunuma nakina-da. ");
INSERT INTO aoi_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Biya mingka-manja mamawura nanga-maka daruma-dangwa dadiyamarnjadikba-manja, “Yarrungkwa ngayuwe-ka ningu-mungkwuluma arakba nungwarrka-manja ningena. Kembirra yakinu-bungwurrukwunama ngarningka yalakena aduwaba naka-da. Umba nungkwamba-langwa ningkena ku-mungkwulama enuwa-manja memema-manja meningalyarrngwalyilya marringa-da,” yingi-yama. “Kembirra yakeni-ngbadikini-yada yalakena nungwarrka-da,” yingi-yama daruma-dangwa dadiyawenikba Lada-langwa dadiyamarnjadikba-wa-da. ");
INSERT INTO aoi_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Biya kembirra makina-manja ngawa meningalyarrngwalyilya marringa narringini-bekajuwama wurringalakina ngarningka amalyirra akwurena-langwa yanda-langwa nu-bungwurridinuma nakina. Kembirra diyukwujiya-dangwa dadiyawenikba Lada-langwa yingu-mungkwuluma nungwadikba-manja ngalamba-langwa. Akena eneja nubungwurra ngawa nakina akwa nu-ngwarndirrijungwunuma. ");
INSERT INTO aoi_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Bi...ya akina-langwa nenilirraki-ngbadikama Lada wurringalakina-kiya wurradiyawabulena nakina-da. ");
INSERT INTO aoi_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","38","Bi...ya kembirra ngalaja daruma-dangwa yingin-arrangbama arakba nangariya akwa yingini-yengbijuwama nenimikirra Mawaba, mena akina ekirra Mawaba ne-yaminama “nungwarrka-langwa.” Umba ngalajukwaba dijira-dangwa yingin-arrangbama nangariya akwa yingini-yengbijuwama nenimikirra Benami, mena akina ekirra Benami ne-yaminama “nganyangwa-langwa warnumamalya.” Aburnaja nenu-wilyarridinu-manja wunalakina, Mawaba numirarrngba neningadinuba-wiya WarninguMawaba-langwa warnumamalya nakina, umba Benami numirarrngba neningadinuba-wiya WarningAmana-langwa warnumamalya nakina-da. ");
INSERT INTO aoi_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Aburraja wurrakina Aburiyama-murriya narri-lalikama arakba akina angalya emikirra Mamura akwa na-likenumurra eminingku-wa angalya nuw-angkarrinu-murruwa arrirra dalada. Akwa nuw-ambilyuma wurrakina wilyarra nuw-ambilyu-murrumanja yalina iya yalina angalya umba Kenina-manja ngawa. Awilyaba angalya aminababurna alikira iya warnumamalya emikirra Kedeja akina umba awilyaba alarrkingburingka angalya emikirra akina Jura. Bi...ya ambaka-murra narri-lalikama wurrakina akina angalya Kenina umba na-likenuma angerriba nuw-angkarrinu-murruwa arrirra dirrumala Bilijiya-wa. Biya engemba-manja Kera-manja na-ngwanjinuma arakba wurrakina. ");
INSERT INTO aoi_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Biya n-ambilyu-manja nakina Aburiyama yakwujina ngawa akina-manja angalya Kera-manja nenumurndaku-makama nakina wurrakina-manja warningakwujina warnumamalya, “Daka didarringka Jera dadiyumarnjarrka nganyangwa daka-da,” ni-yama nakina. Umba ngalaje-ka dadiyumarnjenikba-murrada adinuba-wiya Jera ena-langwa kembirra nang-adingamurrikama arakba dadingiyenikba dakina-da. Akina ne-yaminjamamurra arakba-kiya akina-manja angalya. Akina-manja ngawa angalya Kera eneja nubungkawe-ka nakina ni-lyingama akina angalya. Nenimikirra Abimileka. Biya neni-larrkama nakina Abimileka wurrukwala warnumamalya ena-langwa angerriba Jera-wa kajungwa karringa-wilyakini-yada dakina enuwa-wa ena-langwi-yada dadingiyenikba. ");
INSERT INTO aoi_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Biya muwilyaba-manja meningilyarrngwalyilya marringa nakina Abimileka ni-lyangburarrkinuma akwulyangburarrka. Eneja nakina Neningikarrawara ni-jadingama akwa ni-yama enuwa-wa, “Nungkuwe-ka ningkena ki-jungwunama mena ningkinga-manguma daka didarringka akena dadingadinakba arakba dadinungkwarba-ma daka-da,” ni-yama nakina. ");
INSERT INTO aoi_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Akini-yada ngawa ngalaja ying-ambilyumurra dakina Jera Abimileka-langwa-manja alikira, akena eneja nara ngawa ambaka kini-yar•danga dakina-manja. Ni-yama nakina Abimileka Neningikarrawaru-wa, “Nara ningena ki-yama awurruwurrariya,” ni-yama. “Miyambena-burra kembirra yiki-ngajinama ngayuwa akwa nganyangwa warnumamalya? ");
INSERT INTO aoi_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Aburiyama nakina enabakiya-ba ni-yamama, ‘Daka didarringka nganyangwa dadiyumarnjarrka dakina,’ ni-yamama nakina. Ngalajukwaba yingi-yamama ngawa, ‘Nganyangwa naka nawarrka nakina,’ yingi-yamama. Kembirra akine-ka ningi-yamama ngayuwa eningabe-ka akina-da. Nare-ka ningena ki-yama awurruwurrariya-da,” ni-yama Abimileka Neningikarrawaru-wa. ");
INSERT INTO aoi_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Akina-manja ngawa akwulyangburarrka eneja ni-yama ngarningka Neningikarrawara enuwa-wa, “Yawa, ningeningme-ka akina,” ni-yama. “Nara akina nungkwa-langwa awurrariya. Kembirra akina-langwa nganja yirra-lyangmurukwama nungkuwa akwa nara ki-yama nungkuwa awurruwurrariya nganyangwa akwa ngala-langwa. Akwa nara kembirra ningkakina kinga-lyinga. ");
INSERT INTO aoi_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Umba kembirra nu-kwa daka didarringka neningiyadikba-wa. NuBurabude-ka nakina akwa kembirra kenuminu-buriyaminama nungkwa-langwa nari-yada a-jungwuma nungkuwa. Umba yirra-madumurrukwunama ningkena, nara-manja amini-lawurrakajuma ningkakina dakina didarringka neningiyadikba-wa, kembirra ki-jungwunama ningkakina nungkuwa akwa nungkwa-langwa warnumamalya wurrababurna-langwa aburrajukwaba-da,” ni-yama nakina Neningikarrawara Abimileku-wa-da. ");
INSERT INTO aoi_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Kembirra mingka-manja meninguwurdarriya-wiya mamawura eneja nakina Abimileka nu-mirajanga akwa nenumurndak-ardijuwa nakina ena-langwa wurrarumuruma warnikuminuwar•duwar•da wurrababurna-langwa, akwa nenu-makama akina-langwa akwulyangburarrka. Aburraje-ka wurrakina na-minjirrkakbar•danguma angwurra akina-langwa. ");
INSERT INTO aoi_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Eneja kembirra arakba nakina Abimileka nen-ardijuwa Aburiyama enuwa-wa. Ni-yama nakina, “Ningki-yamarrkama yirruwa-manja ningkakina? Amiyambene-ka awurrariya nganja ningi-yamama nungkuwa-manja-burra kembirra enena awurrariya yirrumini-larrkama nungkuwa ngayuwa-wa akwa nganyangwu-wa warnumamalya? Akine-ka awurrariya ningki-yamama amandangwa. Nara-make-ka warningerribirra warnumamalya e-yamame-ka ngayuwa-manja amukwiyadakina. ");
INSERT INTO aoi_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Miyambena-burra ningki-yamama akina?” ni-yama. ");
INSERT INTO aoi_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Eneja ni-yama Aburiyama, “Ningi-lyangkiyama-bu, ‘Nara wurribina wurrukwala warningiyelakwa amini-yarrkuwarakama Neningikarrawara-langwa ayakwa.’ Ngaya-bu ningi-lyangkiyamama, ‘Warnumamalya warningiyelakwa kabu-wardanga-bu,’ ningi-yamama, ‘kajungwa kabuminu-mangi-yada dadingiyarrka.’ ");
INSERT INTO aoi_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Dake-ka amandangwa nganyangwe-ka dadiyumarnjarrka. Dadiyawenikbe-ka nungwarrka-langwa, akena nara daburradikba dakina dirndirrka-langwa. Akwa kembirra ninginga-manguma nganyangwi-yada dadingiyarrka. ");
INSERT INTO aoi_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Kembirra ngini-larrka-manja Neningikarrawara ngayuwa nungwarrka-langwa-langwa angalya eminiminingku-wa angalya, ninginga-makama ngayuwa ngaluwa-wa ena ayakwa. Ningi-yamama ngayuwa ngaluwa-wa, ‘Ki-yamina ningkakina warnumamalya-manja, Nawarrka naka, ki-yamina. Kembirra k-eningmidinama ngayuwa ki-lyelyingmina-mulangwa ningkakina amandangwa ngayuwa-manja,’ nganja ningi-yamama ngaluwa-wa-da,” ni-yama nakina Aburiyama Abimileku-wa. ");
INSERT INTO aoi_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Kembirra eneja nakina Abimileka nenu-kwa Aburiyamu-wa dakina Jera. Akwa ngarningka nenu-kwa jiba iya bulukwa akwa ngarningka wurrukwala warnikuminuwar•duwar•da. ");
INSERT INTO aoi_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Ni-yama nakina Abimileka Aburiyamu-wa, “Enene-ka nganyangwa angalya angkwulyumida k-ambilya-mulangwa ningkena erribirra enena-manja angalya,” ni-yama nakina Aburiyamu-wa. ");
INSERT INTO aoi_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Umba ngarningka ni-yama nakina Abimileka Jera-wa, “Ningenu-kwunama ningena aduwaba nawenu-wa ababurne-ka angwarnda ajilba-murra 1,000. Kembirra aburraja nungkwa-langwa warnumamalya kuw-eningmidiname-ka wurrakina nara nungkuwa ki-yama awurrariya ningkakina-da,” ni-yama nakina Abimileka Jera-wa-da. ");
INSERT INTO aoi_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","18","Amurndakibina-langwa na-ngekburakajungwunu-mulangwa Jera-manja, dadingiyenikba Aburiyama-langwa-manja, kembirra aburraja wurrababurna-langwe-ka wurridarringka Abimileka-langwa-manja alikira nara arakba ka-mambakina wurrakina wurriyukwayuwa. Nare-ka ka-mambakina wurriyukwayuwa mena Yaweya nenu-ngwanjaju-mubaba wurrakina. Nenu-ngwanjajume-ka nakina amurndakakina-langwa na-ngekburakajungwunu-mulangwa Jera-manja akina. Kembirra nu-buriyamina eneja nakina Aburiyama Abimileka-langwa Neningikarrawaru-wa. Eneja kembirra Neningikarrawara nen-eningabaka kembirra nakina-manja Abimileka akwa ngawa dadingiyenikba-manja akwa ngawa warnikuminuwar•duwar•da-manja wurridarringka ngarningka, kajungwa karr-arrangbini-yada ngarningka wurriyukwayuwa-da. ");
INSERT INTO aoi_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Biya nakine-ka Yaweya ni-yarrkilalikama ena-langwa ayakwa ebina ni-yarrkakumarnuma ebina-wiya Jera-wa akwa nu-marngkirradinuma dakina-manja. ");
INSERT INTO aoi_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Ngalaja arakba dakina yingu-mambakinuma wurrangariya akwa kembirra yinginumin-arrangbama nangariya Aburiyama-langwa, mame-ka nakina n-eniyuwangkwudinuma arakba. Kembirra ebina ayakwa Neningikarrawara ni-yengbinuma adinuba-wiya Aburiyama-manja neniki-rukwularra-langwa Ajika na-lyangmandukwunadinuma akina ayakwa-da. ");
INSERT INTO aoi_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","5","Nakine-ka Aburiyama 100 mamarika iya yinungkwura n-ambilyumurra. Kembirra arakba nakina ni-rukwularruma nenikuwenikba. Biya nakina neniyuwangkwa neni-yengbijuwama nenimikirra Ajika. Biya kembirra n-ambilyu-manja niyukwujiya mamangbala mabiyakarbiya mamawura arakba, nungwenikba neni-ringandanga nenu-mukaduwamurrika nakina mena-baba Neningikarrawara nenu-makama Aburiyama-manja. ");
INSERT INTO aoi_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Ngalaja yingi-yama dangariya-minjena, “Yiningabe-ka nganyangwa yukwudukwuda, mena nakina Neningikarrawara ngini-yekirrerrika-mubaba, akwa ngawa ngini-ngengmarngkajuwa-mubaba nakina,” yingi-yama. “Kembirra aburraja wurrukwala kuw-engkirrikaja-manja warnumamalya enena ayakwa nganyangwa-langwa ningen-arrangba-mulangwa nangariya, wurrakina ka-jungweyinama amarngka yirruwa yirrididirrbura-da. ");
INSERT INTO aoi_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Ebina-wiya, nara wurruwilyuwilyaba warnumamalya ke-yama enena ayakwa neningiyarrku-wa, ‘Dadingiyene-ka kinginu-ngwunjikinama nangariya ngala-langwa,’ nara ke-yama wurrakina. Akena nganja ningenumin-arrangbame-ka nakina nangariya akini-yada ngawa n-eniyuwangkwudinu-manja arakba nakina-da,” yingi-yama Jera-da. ");
INSERT INTO aoi_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Eneja nakina niyukwujiya n-arumidinuma arakba, biya n-akakirumadinuma aninga nenik-alyubara. Kembirra eneja nakina nungwenikba ni-yama, “Naka arakba nenikuwarrka n-alyubarinama aninga, kembirra ngayuwa ningena ke-yengkilabajama wurrababurna warnumamalya kuw-alyubarinama aninga yelakwa nganyangwa-manja angalya,” ni-yama. Kembirra Aburiyama akwa ena-langwa warnumamalya nawurra-murndukwunuma wurrakina, ne-yebukeyinuma ababurna aninga wurruwurrakawura-ma wurrakina-da. ");
INSERT INTO aoi_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Arngkawura Jera-langwa naburradikba Ajika nenu-malyangkeyinuma abadakalya wunalakina Yijumeyila-manja. Umba ngalaja dakina Yijumeyila-langwa dirndenikba dibina Yeka DadingiYijiba nangaminu-war•duwar•danguma warka Jera-langwa. Nenu-malyangkeyinu-manja wunalakina, ngalaja dadiyuwangkwa Jera yingini-rringka Yijumeyila neni-rinjarrkama Ajika-wa. ");
INSERT INTO aoi_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Biya yingi-yama dakina dadiyuwangkwa neningiyadikba-wa, “Minangkirraja arakba daka didarringka dibina yingu-war•duwar•denama yakwa-langwa warka akwa ngawa ngala-langwa naburradikba, abuni-likaja yadada,” yingi-yama Aburiyamu-wa dadingiyenikba. “Ki-jungwuna-manja ningkakina, nara a-manguma awilyuwilyaba amurndakijika nungkwa-langwa nakina naburradikba daka-langwa, umba nganyangwe-ka naburraka kinu-menama nakina ababurna-langwa amurndakakina amurndakijika nungkwa-langwa-da,” yingi-yama dakina-da. ");
INSERT INTO aoi_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Eneja n-engkirrika-manja enena ayakwa neniyuwangkwa, nu-werrikawarriyade-ka nakina-da, mena-baba Yijumeyila nakina enejukwaba ena-langwa nenikuwenikba-da. ");
INSERT INTO aoi_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Umba eneja nakina Neningikarrawara ni-yama Aburiyamu-wa, “Nara a-werrikawarriyaduma nakina-langwa nenjarrngalyilya, akwa dakina-langwa didarringka dibina kirranguminu-war•duwar•dena-mulangwa warka nungkwurringa-langwa. Nakine-ka Ajika numirarringba kin-ambilyama nakina wurrumurndakibina-langwa warnumamalya yirra-maka-mulangwa ngayuwa nungkuwa-manja. Kembirra ebina ayakwa Jera ngu-makama nungkuwa-manja kalirraki-larrkaja-mulangwa nungkuwa wunalakina Yeka akwa ngawa Yijumeyila engku-wa angalya, kembirra kingamin-engkirrikajama ayakwa ngala-langwa ningkakina. ");
INSERT INTO aoi_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Umba ngarningka kinu-kwunama ngayuwa wurrababurne-ka wurriyukwayuwa enejukwaba nibina Yeka-langwa naburradikba, kajungwa kembirra kuw-ababurnadini-yada wurriyukwayuwa ena-langwa akwa wurrilyimberrkwulyumidi-yada wurrilyimberrkuwilyaba wurrakina warnumamalya. Nakina enejukwaba nungkwa-langwa nenikuwena-da,” ni-yama Neningikarrawara Aburiyamu-wa. ");
INSERT INTO aoi_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Kembirra mingka-manja meninguwurdarriya-wiya mamawura eneja nakina Aburiyama nu-mirajanga akwa nanga-kwa aninga Yeka akwa akungwa. Akina-manja angalya aburraja narru-manguma wurrumurndakakina warnumamalya bulukwa-langwa amakwulya akwa ngawa narru-warrkama wuburra beka akungwi-yada. Kembirra amakwulya-murra akungwa ying-angbakuwurrinuma ngalaja Yeka amurn•da-manja lukwakwi-yada wuneniki-beki-yada wunalakina. Eneja kembirra Aburiyama neni-larrka Yijumeyila dirndenikba-wa akwa arakba neni-likena wunalakina kembirra-da. Nenilirraki-larrka neniyuwangkwa wunalakina engku-wa akina-langwa angalya-da. Nen-alilikenu...wa. Alarrkingburingka-manja angalya emikirra Biyajiba. Biya yakwujina ngawa wunalakina nenu-marrawarnumurra arakba. ");
INSERT INTO aoi_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Neni-bekeyina ebina akungwa nenu-wilyakama akwa neni-likena wunalakina ngawa bi...ya na-jerrida arakba akungwa akina-da. Biya nu-kwunumurrkwulinga nenjarrngalyilya eyukwujiya-manja eka amawarruwalya umba ngalaja yingini-lalika yakwujina dirndenikba ");
INSERT INTO aoi_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","akwa yingi-lika arngkidarrba. Biya ying-ambarringa, yingu-ngwadungwadina arakba dakina. Yingi-yama, “Nara ningena a-ngayinduma a-rringkama nganyangwa naburraka a-jungwuma,” yingi-yama. Enejukwaba nenjarrngalyilya nu-ngwadinuma nakina-da. ");
INSERT INTO aoi_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Eneja kembirra Neningikarrawara n-engkirrika nakina ena-langwa angwada. Eneja nuwilyaba nenikumamurikaja Neningikarrawara-langwa ni-yengbinuma nakina ayakwa angubina-langwa dirndenikba-wa. Biya ni-yama, “Miyambena-burra ningkakina ningku-werrikawarriyadinama? Nare-ka akbar•duma. Nakine-ka Neningikarrawara n-engkirrikenuma angwada naburrena-langwa. ");
INSERT INTO aoi_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Warumajungwa, likaja akwa kini-rndarrkajiya ayarrka-manja akwa kinu-mirajangajiya akwa kini-yengminjaka kini-rungekburaka nari-yada a-ngwaduma,” ni-yama nakina Yeka-wa. “Ambaka-murrumurra kinu-wilyarridina-manja nakina, ngayuwa kembirra kinu-kwunama wurrababurne-ka wurriyukwayuwa ena-langwa akwa ngawa wurrababurne-ka wurrumirumirena warnikinikaduwa. Kembirra wurrilyimberrkuwilyaba wurrilyimberrkwulyumida warnumamalya kuw-ambilyama wurrakina-da,” ni-yama nakina nenikumamurikaja Neningikarrawara-langwa Yeka-wa-da. ");
INSERT INTO aoi_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Umba eneja arakba nakina Neningikarrawara nangaminu-ngwur•dangmaja menba dakina-langwa didarringka akwa ying-andiyinga akena yingi-rringka akina akungwa emedirra. Biya yingi-lika akwa yingi-lyangburrukwajuwa akungwa ebina bulukwa-langwa-manja amakwulya akwa kembirra yinginu-kwa akungwa ngala-langwa naburradikba. Kembirra ni-bekina-da. ");
INSERT INTO aoi_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Umba eneja nakina Neningikarrawara n-ambilyuma akwudangwa nenjarrngalyilya-manja. Bi...ya n-arumidinuma nakina umba Neningikarrawara n-ambilyumurra ngawa enuwa-manja akwudangwa. Biya ni-likenuma arakba nakina Yijumeyila akinu-wa angalya emikirra Barena akwa n-ambilyumurra yakwujina. Umba akina angalya ngalajukwaba alarrkingburingka nuw-ambilyuma. Nabarde-ka nakina Yijumeyila nenik-aburangka wurrajija iya yinungungwangba-murriya. ");
INSERT INTO aoi_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Bi...ya ngalaja yinginumin-akburrangama dirndenikba duwilyaba dadiyara DadingiYijiba ena-langwi-yada dadingiyenikba. Kembirra neni-yakeyinuma arakba dakina didarringka-da. ");
INSERT INTO aoi_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Arngkawura eneja nakine-ka Abimileka, nibina nubungkawa Kera-langwa, ni-likena Aburiyamu-wa, aburnuwa Bikala. Nakine-ka Bikala nu-bungkawadinuma wurrawinyamba-manja warnungkwarba Abimileka-langwa-manja. Eneja ni-yama nakina Abimileka Aburiyamu-wa, “Neningikarraware-ka n-ambilyama nungkuwa-manja neningangkawura. ");
INSERT INTO aoi_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Kembirra yirra-ngayindenama yak-ambilyama yakuwa-murra. Nungkwaja kembirra yimini-yarrkakumurna ayakwa nari-yada e-kadikama ngayuwa akwa ngawa nganyangwa wurriyukwayuwa akwa ngawa nganyangwa-manja numirarrka-murriya warnikinikaduwa aburrajukwaba. Yi-maka kembirra enena-wiya kajungwa Neningikarrawara kin-engkirrikaji-yada ayakwa nungkwa-langwa, akwa nara a-yarrkuwarrukwajuma akina. Ngayuwe-ka ningena ningi-yamama eningaba nungkuwa-manja, umba yi-makina arrkala ki-yamini-yada nungkwajukwaba eningaba ngayuwa-manja akwa ngawa wurrumurndakeyina-manja warnumamalya enena-manja angalya ningk-ambilya-murrumanja nungkuwa aduwaba,” ni-yama Abimileka. ");
INSERT INTO aoi_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Eneja Aburiyama kembirra ni-lyangkuwama akwa ni-yama, “Yawa. Eningabe-ka akina, kembirra yakuwa yalakena yakuwa-murra aduwaba-langwa akwa arngkawura,” ni-yama. ");
INSERT INTO aoi_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Biya kembirra Aburiyama ni-yama ngarningka Abimileku-wa, “Wurrukwale-ka warnikuminuwar•duwar•da nungkwa-langwa buminu-manguma awilyaba emedirra akungwa nganyangwa,” ni-yama. ");
INSERT INTO aoi_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Eneja ni-yama Abimileka, “Ningeningbala akina. Nara yiku-maka adinuba-wiya aminakina-langwa, umba aduwaba-manji-kba ning-engkirrikajama ningena. Dukwa angkaburra narru-manguma?” ni-yama. ");
INSERT INTO aoi_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Eneja kembirra arakba Aburiyama nenu-kwa akwala jiba akwa bulukwa Abimileku-wa, akwa akina-murra neni-yarrkakumarna ayakwa wunalakina. ");
INSERT INTO aoi_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Biya kembirra Aburiyama nu-manga ngarningka amangbala ambilyuma eyukwayuwa jiba ena-langwa. ");
INSERT INTO aoi_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Eneja ni-yama Abimileka, “Miyambena-burra ningki-yama akina?” ni-yama. ");
INSERT INTO aoi_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Eneja ni-yama Aburiyama, “Wu-mena amurndakeyina amangbala ambilyuma eyukwayuwa jiba nungkwa-langwi-yada. Kembirra ku-mena-manja akina, ki-yaminama kembirra nungkuwa arija-langwa, ‘Aburiyama-bina nu-mungkadinuma enuwa akina emedirra akungwa,’ ki-yaminama ningkakina-da.” Yadikina kembirra eneja nakina Abimileka nu-manguma amurndakakina amangbala ambilyuma jiba eyukwayuwa ena-langwi-yada-da. ");
INSERT INTO aoi_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Kembirra aburraja narri-yengbijuwama warnumamalya akina angalya emikirra Biyajiba, mena yakwujina-baba wunalakina-kiya neni-yarrkakumarnu-mubaba akina ayakwa emedirra-langwa akungwa. Umba akina ekirra Biyajiba ne-yaminama “emedirra akungwa ebina-manja neni-yarrkakumarnu-murrumanja ayakwa.” ");
INSERT INTO aoi_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Kembirra aburnaja wunalakina Abimileka akwa ngawa Bikala neni-lawurradina arakba aburna-langwu-wa angalya Bilijiya-wa. ");
INSERT INTO aoi_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Umba eneja nakina Aburiyama n-ambilyumurra aduwaya yakwujina ngawa Biyajiba-manja. Biya kembirra ni-lungkuwabijuwa nakina awilyaba eka yakwujina. Akina eka ni-lungkuwabijuwama emikirra damarija. Kembirra Aburiyama neni-yangmarngkwajuwa Yaweya nibina Neningikarrawara neningangkawura nakina. ");
INSERT INTO aoi_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Biya kembirra ni-lungkuwabijuwa-mulangwa nakina Aburiyama ebina eka akwa neni-yangmarngkwajuwa-mulangwa Yaweyu-wa nakina, ni-lalika arakba akina angalya Biyajiba umba ni-likena arija-langwa nakina enejukwaba Bilijiya-wa. Biya yakwujina ngawa n-ambilyuma nakina neningamiyerra Bilijiya-manja-da. ");
INSERT INTO aoi_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Bi...ya kembirra eneja Neningikarrawara neni-labenumurra nakina Aburiyama-manja, kenumini-yarrkuwaraka-murrikba ena-langwa ayakwa. Biya kembirra n-ardanga nakina, “Aburiyama...yi!” Eneja neniyuwangkwa ni-yama, “Ningena...wu!” ");
INSERT INTO aoi_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Enamba-langwa ni-yengbina Neningikarrawara ayakwa Aburiyamu-wa akwa ni-yama, “Nu-wilyakina nakina nenikuwena nuwilyaba-ma nungkwa-langwa,” ni-yama, “nibina ningki-lyelyingminama angwurre-ka, akwa wuni-likaja akinu-wa angalya emikirra Maraya. Biya kembirra yikini-yar•diya-manja kinalakina yakwujina yiba-wilyakajinamurra ngayuwa ningkena yaruma yinijirra. Biya yakwujina ngawa yakina-manja yinijirra kinu-wardenama nenikuwena ningkakina, akwa kini-dakinamurra-da, akwa yiku-kwunamurra ngawa kembirra ngayuwa-wa-da,” ni-yama Neningikarrawara Aburiyamu-wa-da. ");
INSERT INTO aoi_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Kembirra mingka-manja meninguwurdarriya-wiya mamawura eneja nakina neniyuwangkwa Aburiyama nu-mirajanga akwa ni-ridanga angwura akwa n-akumarna dangki-manja akwa nenilirrak-ardija ena-langwu-wa wunenungkwarba-kiya, wunalekbina nenuminu-war•duwar•dangumurra warka, akwa nenikuwenikba ngarningka Ajika. Biya nabuki-likena arakba wurrubukalakina ebinu-wa angalya Neningikarrawara nenu-maka-murruwa Aburiyama-manja. ");
INSERT INTO aoi_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Nabuk-alilikenu...wa. Biya mabiyakarbiya-manja mamawura n-andeya nakina neniyuwangkwa akena ni-rringka arakba yakina yinijirra engku-wa ni-rribiyanguma ambaka awilyikerra. ");
INSERT INTO aoi_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Biya kembirra neniyuwangkwa ni-yama wunalakina-kiya-wa wunenungkwarba-kiya, “Yelakwa wun-ambilya adinakba akwa daka ngarningka dangki. Umba yinaja yinalakena yinuwa naka nenjarrngalyilya yini-likajama angerriba, kajungwa yikini-yangmarngkwajini-yada Neningikarrawara. Kembirra ngarningka yinalakena yikini-lawurradinama yangkwurrangwa nungkwurnuwa-wa,” ni-yama. ");
INSERT INTO aoi_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Biya kembirra arakba neniyuwangkwa ni-rndirrka amabungwunyirra eka angwuri-yada akwa nenu-kwa akina nenikuwenikba-wa. Kembirra eneja ni-ngabukweyina nakina Ajika. Umba neniyuwangkwa nu-wilyakama lyelyinga akwa ngawa amukwa angwura eniba neniki-liraki-yada nakina, biya neni-likena arakba. Biya neni-likenu-manja ngawa lukwakwa wunalakina, ");
INSERT INTO aoi_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Ajika ni-yama nungwenikba-wa, “Ngangwa!” Kembirra eneja nungwenikba ni-yama, “Miyambena?” “Ena amabungwunyirra eka akwa amukwa angwura umba angamba kembirra jiba eyukwujiya ningkeniki-daki-yada nungkuwa?” ni-yama nakina nenjarrngalyilya. ");
INSERT INTO aoi_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Eneja ni-yama Aburiyama, “Neningikarrawara enabakiya-ba yikenu-kwunama jiba.” Neni-likena wunalakina, ");
INSERT INTO aoi_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","bi...ya angakuba nen-akburranga arakba angalya ebina-langwa nenu-maka-murrilangwa Neningikarrawara adinuba-wiya Aburiyama-manja. Kembirra nakina neniyuwangkwa nu-manga akwala arumuruma angwarnda akwa nuwurrak-arjiyajuwa aldi-yada. Kembirra ni-lyakakumarna angwura karrawara. Akwa neni-rndarrka arakba nenikuwenikba, nen-ararika, akwa karrawara arakba angwura-manja nen-akumarna nakina-da. ");
INSERT INTO aoi_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Biya ni-rndarrka ebina lyelyinga neniyuwangkwa-da. Ni-ngkajika nakina nenik-ar•darri-yada nenikuwenikba-manja, ");
INSERT INTO aoi_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","akena eneja nenikumamurikaja Yaweya-langwa n-ardanga angaluba angubina-langwa enuwa-wa-da. Ni-yama, “Aburiyama...yi!” Eneja Aburiyama ni-yama, “Miyambena?” ");
INSERT INTO aoi_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Enamba-langwa ni-yama nakina nenikumamurikaja Yaweya-langwa, “Nara ar•darruma nakina!” ni-yama. “Ningeningma arakba ningkakina ningki-yarrkuwarakinama Neningikarrawara-langwa ayakwa, mena nara-baba kinu-marrukwa nungkwa-langwa nenikuwena nuwilyaba-ma enuwa-langwa-da,” ni-yama nakina nenikumamurikaja Yaweya-langwa. ");
INSERT INTO aoi_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Eneja kembirra nakina Aburiyama n-errikerra n-andiyinga nakina akena ni-rringka akina enungkwarba jiba. Na-rndirrkama akwurrirra ngala-langwa-manja karndirra. Biya kembirra Aburiyama ni-lika akinu-wa, nu-manga akina akwa ngawa nu-wardanga akwa n-akumarna ebina-manja angwura karrawara. Akina kembirra ni-dakama nenu-kwamurra Neningikarrawaru-wa-da, umba nenikuwenikba nara kenu-kwa-da. ");
INSERT INTO aoi_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Biya nakina Aburiyama ni-yengbijuwa akina angalya “Yaweya Nginu-kukwuna-murrumanja Eningaba-wiya.” Kembirra aduwaba ngawa aburraja wurruminakina angalya warnumamalya ne-yaminjaminama, “Ena-langwa-manja yinijirra Yaweya nenu-kukwunama ena-langwa warnumamalya eninginingaba-wiya,” ne-yaminjaminama wurruminakina angalya warnumamalya aduwaba. ");
INSERT INTO aoi_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Eneja kembirra nibina nenikumamurikaja Yaweya-langwa n-ardanga ngarningka angaluba karrawara-langwa Aburiyamu-wa. ");
INSERT INTO aoi_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","“W-engkirraja enenu-wa ayakwa Yaweya-langwu-wa,” ni-yama. “Ni-yame-ka nakina Yaweya, ‘Ningena ngayuwa ningi-yarrkakumurnama enena ayakwa akwa ningi-yengbijajungwunama ningenimikirra kajungwa engbudi-yada ayakwa akwa nara ngayuwa a-yarrkuwarrukwajuma akina. Ningena ngayuwa ki-yaminama eningaba nungkuwa-manja, mena nara-baba ningkakina kinu-marrukwa nungkwa-langwa nenikuwena nuwilyaba-murra ngayuwa-langwa. Yirra-makinama enena ayakwa ngayuwa nungkuwa-wa akwa nare-ka ngayuwa a-yarrkuwarrukwajuma akina. ");
INSERT INTO aoi_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","Yiba-kwunamurra amandangwa wurrababurna numirena-murriya warnikinikaduwa. Wuburra dakilyingajanga duwurrakwulyumida karrawara ningkinga-rringkinama, ke-yaminama aburrajukwaba wurrakina wurruwurrakwulyumida. Akwa wuburra ajiringka ababurna mijiyelya-manja nuw-ambilyama, wurruwurrakwulyumide-ka ke-yaminama wurrakina-da. Umba ka-wardiyiname-ka nungkwa-langwa numirena-murriya wurrumurndakakina-manja warnumamalya engka-manja iya engka-manja angalya akwa kembirra ka-bungkawadinama arakba wurrakina-manja-da. ");
INSERT INTO aoi_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","“‘Aburraja wurruwurrakwulyumida-langwa warnumamalya kembirra engkalina-langwa iya engkalina-langwa angalya kabi-yengkilabajama ngayuwa. Ke-yaminama wurrakina ngayuwa-wa, Yamina eningaba yirruwa-manja yirrajukwaba wuburra laka ningki-yamama Aburiyama-langwa-manja wurrumirumirena warnikinikaduwa-manja, ke-yaminama. Akina-bina ka-ngekburakajungwunamurra-da, mena-baba yimini-yarrkuwarakama ayakwa nganyangwa aduwaba-da,’ ni-yama Yaweya nakina-da,” ni-yama nenu-makama nakina nenikumamurikaja Yaweya-langwa Aburiyamu-wa-da. ");
INSERT INTO aoi_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Aburnaja kembirra Aburiyama akwa Ajika neni-lawurradina wunalakina wunalekbina-kiya-wa wunenungkwarba-kiya nenilirraki-lalika-murruwa adinakba. Biya yadikina kembirra nabuki-lawurradina arakba angalyu-wa-da Bilijiya-wa-da. Bi...ya kembirra ambaka-murra narrumurndaki-lalikama Aburiyama-murriya akina angalya Bilijiya, umba narru-makirukbijangajuwama wurrakina angerriba Biyajiba-wa-da. Akwa yakwujina ngawa nawurrak-ambilyumurra wurrakina arakba-da. ");
INSERT INTO aoi_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","23","Biya ambaka-murra n-engkirrikenuma Aburiyama ayakwa Neyawa-langwa nenikumarnjenikba-langwa. Eneja nakina Neyawa n-ambilyuma ebina-manja angalya n-ambilyu-murrumanja Aburiyama adinuba-wiya nara-wiya kini-likena nakina Keninu-wa. Umba ngalaja Neyawa-langwa dadingiyenikba Milka dakina dadimikirra. Akwa kembirra wurrumangbala wurrabiyakarbiya wurriyukwayuwa wunalakina-kiya-langwa warnungkwarba-wiya nuw-ambilyumurra. Neningadinuba-wiya nenimikirra Wija akwa warnikumarnjena Baja iya Kemuwela, nibina nungwenikba Arama-langwa nakina, iya Kejeda iya Yajawa iya Bildaja iya Jidilaba akwa ngawa Beduwela. Umba ngalaja duwilyaba dadiyawenikba Beduwela-langwa dadimikirra Ribeka dakina. ");
INSERT INTO aoi_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Umba ngarningka duwilyaba dadikuminuwar•duwar•da Neyawa-langwa ngalajukwaba dadingiyenikba dadimikirra Ruma. Akwa Neyawa-langwa akwa Ruma-langwa warninikuwena wunalakina-kiya-langwa nuw-ambilyumurra warnimikirra Deba iya Kayama iya Dayaja akwa ngawa Mayaka wurrubukalakina-da. ");
INSERT INTO aoi_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Ngalaja dakina Jera ying-ambilyuma 127 mamarika iya yinungkwura arakba, ");
INSERT INTO aoi_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","biya yingi-jungwa dakina Kenina-manja ebina-manja angalya aminababurna alikira iya warnumamalya emikirra Yebirena. Eneja kembirra nakina neningiyadikba nu-ngwadinuma akwa nu-werrikawarriyadinume-ka nakina dadingiyenikba-wa. ");
INSERT INTO aoi_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Kembirra arakba nakina Aburiyama nanga-lalika dakina dadingiyenikba dadumadangkwa akwa ni-likena arakba kajungwa warniki-lyelyimbukwaji-yada ayakwa wurrumurndakakina-manja WarningiYida-manja warnumamalya nakina yakwujina ngawa Yebirena-manja. Biya nen-akburranga wurrakina warnumamalya akina-manja angalya adaka ayakwi-yada, nuw-angmakayanguma akawiyuwiyeba-manja nawurruwurra-murndukwunu-murrumanja warnumamalya wurrakina. Kembirra Aburiyama ni-yama nakina wurrakinu-wa warnumamalya, ");
INSERT INTO aoi_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“Ngayuwe-ka ningena ninguminjirrkingka,” ni-yama. “Eminingka-langwa angalya ningena ningi-likenuma yangkwurrangwa akena ning-ambilyama erribirra ningena yelakwa nungkwurruwa-manja aduwaba. Yirru-kwuna kembirra angalya ku-beyindeni-yada ningena, kajungwa kinga-rungkwabini-yada ngayuwa dadingiyarrka nganyangwa,” ni-yama. ");
INSERT INTO aoi_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Aburraja ne-yama, ");
INSERT INTO aoi_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“Yirrumin-engkirrikaja enena ayakwa yirra-langwa. Wuburre-ka ngarra-rringkinama yarna nungkuwa ningkaruma ningkubungkawa. Kembirra jeyi, wu-rringkina amurndakenena angalya yirra-langwa. Biya ki-rringkina-manja eningaba angalya kemba yakwujina kinga-rungkwabinama dadingiyena,” ne-yama. “Yarne-ka yarningerribirra yarnumamalya nara yarna a-marrukwama yirra-langwa angalya,” ne-yama. “Mama, kinga-rungkwabinama nungkwa-langwa dadingiyena erribirra,” ne-yama. ");
INSERT INTO aoi_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Eneja kembirra Aburiyama n-abuluwendinga mena ne-yaminjama-murrubaba warningakwujina warnumamalya wurruminjirrkingka-manja warnumamalya wurruwurrakuwilyarra. ");
INSERT INTO aoi_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","“Eningaba akina ayakwa nungkwurra-langwa,” ni-yama nakina, “kinga-rungkwabina-mulangwa ngayuwa nganyangwa dadingiyarrka yelakwa. Kembirra yikumini-yengkilabaja nangaba Ebirena, Jawura-langwa nenikuwenikba. ");
INSERT INTO aoi_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","Yikini-yengkilabaja makina-langwa medirra ku-beyindeni-yada ngayuwa memikirra Makbela. Makine-ka medirra num-ambilyama ena-langwa-manja angalya akwudangwa aburrakadabuda. Yikini-yengkilabajama enuwa-wa kajungwa ku-beyindeni-yada makina ngayuwa akwa kinu-kwuni-yada ngayuwa engkwulyumida angwarnda enuwa-manja. Nganja ku-beyindenama yelakwa ngayuwa yiki-rringkina-murrumanja kirrumurndakeyina karnumamalya. Kembirra nganyangwi-yada makina medirra kajungwa kamurndak-akumurni-yada nganyangwa warnumamalya warninikijungwa makina-manja,” ni-yama nakina Aburiyama wurrumurndakakinu-wa warnumamalya. ");
INSERT INTO aoi_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","11","Eneja nakine-ka Ebirena n-angmakwulaluma yakwujina wurrumurndakakina-manja warnumamalya WarningiYida-manja. Ni-yama nakina, “Engkirraja ena ayakwa nganyangwa. Yiba-kwunama angaba angalya erribirra nganyangwa engkwulyumida nungkawa-wa, akwa ngarningka mibina medirra num-ambilyama akina-manja angalya. Yiba-kwunama angaba angalya aduwaba nuw-engkirrikaja-murrumanja nganyangwa warnumamalya, kajungwa kembirra king-akumurni-yada nungkwa-langwa dadingiyena ningkakina-da,” ni-yama nakina Ebirena. Umba aburraja wurrababurna-langwa warnumamalya warningakwujina nuw-engkirrikenuma ena-langwa ayakwa. ");
INSERT INTO aoi_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Akena Aburiyama eneja n-abuluwendinga ngarningka wurrumurndakakinu-wa warnumamalya WarningiYidu-wa. ");
INSERT INTO aoi_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","Kembirra ni-yengbina nakina ayakwa enamba-langwa Ebirenu-wa, kajungwa wurrababurna-langwa warnumamalya warnik-engkirriki-yada. Ni-yama nakina, “Erriminja-langwa ambaka, umba engkirrikiya-langwa. Ena nungkwa-langwa angalya engkwulyumida ku-beyindenama nganja ningena. Ena wu-mena angwarnda yirra-kwunama, kembirra king-akumurni-yada dadingiyarrka nganyangwa yakwujina,” ni-yama Aburiyama. ");
INSERT INTO aoi_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Enamba-langwa Ebirena ni-lawurrakaja ayakwa enuwa-wa. Ni-yama, ");
INSERT INTO aoi_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","“Adirrngekburne-ka ena angwarnda akina-langwa angalya 400 angwarnda yimbukwa. Kembirra yakuwa yalakena nara arakba a-lyelyimbukwajuma ngarningka akina-langwa umba king-akumurna yakwujina dakina dadingiyena nungkwa-langwa,” ni-yama nakina Ebirena-da. ");
INSERT INTO aoi_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Eneja kembirra Aburiyama ni-lyangkuwama nakina akwa arakba nu-murnduwarna angwarnda neniku-kwi-yada, ebina angwarnda ni-yengbijuwama Ebirena, nuw-engkirrikenu-murrumanja wurrakina warnumamalya. Kembirra n-akumarna nakina Aburiyama 400 angwarnda adirrngekburna. Ni-dirrburakama akina angwarnda kajungwa engkwulyumidi-yada ngawa akina-da. ");
INSERT INTO aoi_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Yadikina-bu Aburiyama ni-yamama nu-beyindanguma nakina akina angalya Ebirena-langwa Makbela-manja. Akina angalya akwudangwa Mamura-langwa angalya. Umba nu-beyindangumurra nakina Aburiyama akwa ngawa amarda-murriya akwa ngawa eka ababurna-langwa akwa ngawa ngarningka medirra-da. ");
INSERT INTO aoi_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","Aburraja wurrumurndakakina warnumamalya yakwujina nuw-ambilyu-murrumurra nuw-engkirrikenuma wurrakina akina ayakwa ni-yamama ni-yengbinuma Aburiyama. Kembirra wurrumurndakakina warnumamalya warningma arakba akina angalya Aburiyama-langwa akina-da. ");
INSERT INTO aoi_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Kembirra nakine-ka Aburiyama nang-akumarna arakba dadingiyenikba Jera makina-manja medirra akina-manja angalya Kenina. ");
INSERT INTO aoi_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Akina angalya WarningiYida-langwa-langwa warnumamalya adinuba-wiya, kembirra Aburiyama-langwa arakba-da akwa medirra-da, kajungwa nenik-akumi-yada ena-langwa warnumamalya warninikijungwa yakwujina nakina-da. ");
INSERT INTO aoi_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Bi...ya nakine-ka Aburiyama neniyerringke-ka arakba. Umba eneja nakina Yaweya ni-yamama arngkababurna-langwa eningaba nakina-manja. ");
INSERT INTO aoi_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Kembirra ni-yengbina nakina ayakwa Aburiyama ena-langwu-wa nenikuminuwar•duwar•da naruma-wa nibina nuwurrak-akwurrajuwa-murruwa ena-langwa amurndakijika ababurna-langwa. “W-akuma nungkwa-langwa ayarrka yelakwa arrawa makarra-manja,” ni-yama. ");
INSERT INTO aoi_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","“Ngayuwa yirra-ngayindenama ki-yarrkakumurnama enena ayakwa akwa nara nungkwaja a-yarrkuwarrukwajuma akina. Akwa ki-yengbijinama ngarningka ningkakina ekirra Yaweya-langwa. Nakine-ka Yaweya Neningikarraware-ka nakina nibina-murrada ni-ngekburaka-murrada angubina akwa ngawa ababurna-langwa angalya. Yirra-ngayindenama ningkena nungkuwa ki-yarrkakumurnama ayakwa nari-yada aminu-manguma warningerribirra wurradidiyara Ajika-langwi-yada dadingiyenikba enena-langwa angalya Kenina. ");
INSERT INTO aoi_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Umba kinuminu-menama ningkakina duwilyaba dadiyara nganyangwa-langwa warnumamalya. Yirra-ngayindenama nungkuwa ki-lawurradinama angerriba ebinu-wa angalya ngayuwa ningi-rukwularrinu-murruwa. Akwa kembirra kinuminu-mename-ka nungkuwa duwilyaba dadiyara nenikuwarrka-langwa akina-langwa angalya,” ni-yama Aburiyama ena-langwu-wa nenikuminuwar•duwar•da. ");
INSERT INTO aoi_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Eneja ni-yama nakina nenungkwarba, “Dukwe-ka dakina kingu-wariyama nara a-likama yangkwurrangwa-da. Umba kini-larrkiya nungkwa-langwa nenikuwena akinu-wa angalya kin-ambilyi-yada yakwujina?” ni-yama nenikuminuwar•duwar•da Aburiyamu-wa. ");
INSERT INTO aoi_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","“Nare-ka!” eneja ni-yama Aburiyama. “Awurrariya akina. Nara a-larrkama ningkakina nenikuwarrka angerriba akinu-wa angalya. ");
INSERT INTO aoi_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Arakba-wiya eneja Yaweya nakina nginu-wilyakama ngayuwa yangkwurrangwa angaluba nungwarrka-langwa-langwa angalya akwa nganyangwa-langwa warnumamalya. Nakine-ka Yaweya Neningikarrawara nakina, nibina ni-ngekburaka-murrada ababurna-langwa angalya angubina-manja. Akwa nakina-bina ni-yarrkakumarnuma ayakwa nganyangwa. Ni-yamama nakina ngayuwa-wa, ‘Enena aringbirra angalya yiba-kwunama ngayuwa nungkuwa-wa akwa ngawa nungkwa-langwu-wa numirena-murriya warnikinikaduwa-wa,’ ni-yamama nakina Yaweya ngayuwa-wa. Akwa nakina-bina keni-larrkajama ena-langwa nenikumamurikaja adinakba kajungwa kenu-mamurikajini-yada nungkuwa kinuminu-meni-yada angaluba duwilyaba dadiyara nganyangwa-langwa nenikuwarrka. ");
INSERT INTO aoi_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Umba kingu-wariya-manja dakina dadiyara, akwa nara-manja a-likama dakina nungkuwa-manja, kembirra enena-langwa ayakwa yib-enjungwurrenama ngayuwa-da. Akena nare-ka a-larrkama naka nganyangwa nenikuwarrka akinu-wa angalya,” ni-yama Aburiyama ena-langwu-wa nenikuminuwar•duwar•da. ");
INSERT INTO aoi_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Kembirra eneja nakina nenikuminuwar•duwar•da n-akuma ena-langwa ayarrka Aburiyama-langwa-manja makarra arrawa akwa ni-yarrkakumarna ebina ayakwa kini-yamina-mulangwa nakina ababurna-langwa ebina-langwiya ayakwa ni-yengbinu-mulangwiya Aburiyama-da. ");
INSERT INTO aoi_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Biya kembirra nakina nenikuminuwar•duwar•da nuwurra-murndukwa ememberrkwa kamila Aburiyama-langwa akwa nuwurraku-wurdijuwa ababurna eninginingaba amurndakijika Aburiyama-langwa. Kembirra ni-lalika akina angalya akwa ni-likena arakba nuw-angkarrinu-murruwa arrirra dirrumala. N-alilikenume-ka nakinu...wa yanda-langwa ni-yar•da engemba-manja Mejubudamiya. Ni-likenuma nakina ngawu...wa, yanda-langwa n-akburrangama angalya aminuwurrakwulyumide-ka alikira iya warnumamalya ebina-manja n-ambilyu-murrumanja adinuba-wiya nenikumarnjenikba Aburiyama-langwa nenimikirra Neyawa. ");
INSERT INTO aoi_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Nara nakina kin-awiyebena ambaka arrawu-wa umba numurndaku-ngwanjajuma amurndakakina kamila errekba-manja ngawa emedirra-manja akungwa. Numurndak-ambarrija amurndakakina kembirra kamila akwa nu-ngwanja n-embirrarina ambaka. Biya na-larruwurada arakba. Akini-yada ngawa aburraja wurruminakina angalya wurradidiyara nawurrak-alilikenuma yenjerrikina akinu-wa emedirra akungwa. ");
INSERT INTO aoi_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Kembirra nu-buriyamina arakba nakina nenikuminuwar•duwar•da Yaweyu-wa. Ni-yama, “Marrakba, ningkakine-ka Yaweya ningkibina-murrada Ningkeningikarrawara nganyangwa-langwa nubungkawa Aburiyama ningkakina, yi-mamurikajiya-langwa aduwaba akwa numini-yarrkilyingina ebina ayakwa ningki-yarrkakumarnuma ebina-wiya ningkakina nganyangwa-langwa nubungkawa. ");
INSERT INTO aoi_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Kwuja! Ningena ngayuwa enena-manja emedirra akungwa ning-abalkayukwunama. Umba aburraja wurrukwala wurradidiyara wurruminenena angalya adinuba ka-likajama yangkwurrangwa akungwa-wa. ");
INSERT INTO aoi_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Nganja kembirra ki-yengbinama ayakwa duwilyaba-manja dadiyara ningena. Ki-yaminama ngayuwa ngaluwa-wa, ‘Yimini-larrijiya-langwa nungkwa-langwa meningamilyumilyinja menarlamba akwa yi-bekajiya-langwa akungwa,’ ngayuwa ki-yaminama. Kingi-yamina-manja dakina ngayuwa-wa, ‘Yawa, bekina nungkuwa. Akwa ngarningka kembirra kumin-akarrnginama ngayuwa akungwa amurndakenena-langwa nungkwa-langwa-langwa kamila,’ kingi-yamina-manja dakina amurndakenena ayakwa ngayuwa-wa, kembirra dakina-bina ninginga-ngayindenama nungkuwa ningku-wekbalyinuma arakba adinakba Ajika-langwi-yada didarringka-da. Kembirra ningeningma ngayuwa ningkenumini-yarrkilalikama ngawa ebina ayakwa ningki-yarrkakumarnuma Aburiyama-langwa-da,” ni-yama nakina nenikuminuwar•duwar•da Aburiyama-langwa Yaweyu-wa-da. ");
INSERT INTO aoi_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Umba nu-buburiyaminu-wiya ngawa nakina yingi-yar•da ngalaja dakina dadiyara dadimikirra Ribeka. Yingi-ngabukweyinuma dakina meningamilyumilyinja menarlamba ngala-langwa-manja amurn•da. Dakine-ka dadiyawenikba Beduwela-langwa. Umba Beduwela-langwa nungwenikba nenimikirra Neyawa Aburiyama-langwa nenikumarnjenikba nakina. Umba ngalaja dirndenikba Beduwela-langwa dadimikirra Milka. ");
INSERT INTO aoi_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Dakine-ka Ribeka dukwulyubene-ka dadiyara. Dikikamarra ambaka warnungkwarba. Biya yingi-likena dakina angerriba angadingidirra-wa akungwa emedirra. Yingi-dirrirnda arrawu-wa, yinguma-lyangburrukwajuwa mibina menarlamba akwa yingu-wurdinga karrawaru-wa. ");
INSERT INTO aoi_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Eneja nenikuminuwar•duwar•da n-angkarra nanga-wengma ngaluwa-wa. “Marrakba, yu-kwa-langwa nganja akungwa,” ni-yama. ");
INSERT INTO aoi_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","“Wiya, kembirra bekina,” yingi-yama ngalaja. Warenja-bawiya yinguma-larrija mibina menarlamba akwa yinginumini-rrakilyinga akwa ni-bekina-da. ");
INSERT INTO aoi_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Ni-jerrukwa-manja nakina akungwa yingi-yama enuwa-wa, “Akwa ngarningka kumin-akarrnginama akungwa amurndakangaba-langwa kamila nungkwa-langwa-langwa, yanda-langwa kuw-abadinama.” ");
INSERT INTO aoi_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Biya warenja-bawiya yinguma-jiraba yinguma-radebirraka mibina menarlamba ebinu-wa angarumungkwa angwarnda nuw-ambilyu-murruwa akwudangwa emedirra akungwa kajungwa warniki-bekaji-yada warningerribirra warnumamalya aburra-langwa bulukwa-murriya iya kamila-murriya yakwujina. Akwa ngarningka ying-angkarra emedirra-wa akwa ying-akarrngarna ngarningka akungwa amurndakibina-langwi-yada kamila ena-langwi-yada. Yingi-yaminjama ngawa dakina yanda-langwa nuw-abaduma amurndakakina kamila ababurna-langwa. ");
INSERT INTO aoi_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Eneja nakina nenikuminuwar•duwar•da Aburiyama-langwa nanga-rringkama ngawa ngaluwa-wa akena nara kini-yengbina nakina eyukwayuwa ayakwa. N-embimbirrarinuma nakina ngawa kenuminu-wekbalyinu-murrikba Yaweya dakina dadiyara Ajika-langwi-yada dadingiyenikba. ");
INSERT INTO aoi_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Biya na-jerrukwa-manja amurndakibina kamila akungwa, nakina nenungkwarba kembirra nanga-kwama dakina-manja dadiyara akwala amurndakijika alarrngekburna. Adinuba-wiya nangamin-akumarna dakina ngala-langwa-manja eminda akina errumungkwa na-ngekburakajungwunuma akawulda-ma. Akwa ngarningka nangamin-akumarna ambilyuma aruma-kiya ngala-langwa-manja ayarrka. ");
INSERT INTO aoi_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Biya ni-yama nakina, “Numiyambena nungkwa-langwa nungwena? Akina angalya nungwena-langwa-manja alikira ningenik-ambilyingi-yada ngayuwa mema-manja marringa akwa ngawa warna warnungkwarba nganyangwa?” ni-yama dakinu-wa. ");
INSERT INTO aoi_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","“Nganyangwa nungwarrka nenimikirra Beduwela,” yingi-yama ngalaja. “Akwa nungwenikba ena-langwa Neyawa umba dirndenikba Milka. ");
INSERT INTO aoi_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Ababurne-ka amarda nungkwa-langwa-langwa kamila akwa ngarningka ababurna angalya karnik-ambilyingi-yada nungkwurruwa,” yingi-yama. ");
INSERT INTO aoi_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Kembirra eneja nakina nenikuminuwar•duwar•da Aburiyama-langwa n-abuluwendinga arakba n-engmidirruwajungwa nenumukwurra ajiringka-wa akwa neni-yangmarngkwajuwamurra Yaweyu-wa. ");
INSERT INTO aoi_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","Ni-yama nakina Yaweyu-wa, “Nungkuwe-ka Yaweya Ningkeningikarrawara ningkakina Aburiyama-langwa. Yirre-yangmarngkwajinama nungkuwa-wa mena nungkwa-langwe-ka ayakwa ningki-yarrkakumarnuma Aburiyama-langwa adinakba ningkenumini-yarrkilalika-mubaba akina. Akwa kembirra yu-wilyakama ngayuwa aduwaba dirrbura Aburiyama-langwu-wa warnumamalya-da,” ni-yama nakina-da. ");
INSERT INTO aoi_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Umba ngalaja ying-angkarra dakina dadiyara nungwadikba-langwu-wa angalya nanga-maka dirndadikba-manja ababurna ne-yama-mulangwa. ");
INSERT INTO aoi_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","30","Eneja Ribeka-langwa narrkuwadikba Lebina ni-rringka ebina errumungkwa ngala-langwa-manja eminda akwa ayarrka akwa n-engkirrika ayakwa dakina yingi-yengbinuma dirndadikba-manja. Biya n-angkarra errekbu-wa akwa ni-likena ebinu-wa emedirra akungwa n-ambilyu-murruwa nakina nenikuminuwar•duwar•da. Eneja nakina nu-kuwarjeyuma ngawa akwudangwa emedirra-manja nuw-ambilyu-murrumanja ena-langwa kamila. ");
INSERT INTO aoi_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Kembirra eneja nakina Lebina ni-yama, “Kwa, likaja nganyangwu-wa angalya. Eneja Yaweya nakina nginu-werrungwur•denama nungkuwa-manja. Nare-ka ambilyuma yelakwa, umba kwa. Akine-ka angalya nungkwa-langwa akwa ngawa nungkwa-langwa-langwa warnungkwarba nganyangwa-manja alikira, akwa akina ngarningka angalya kamila-langwa ngalajukwaba,” ni-yama. ");
INSERT INTO aoi_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Biya kembirra Lebina akwa nakina nenikuminuwar•duwar•da Aburiyama-langwa akwa ngawa ena-langwa warnungkwarba na-likena arakba Lebina-langwu-wa angalya. Biya numurndaku-manga Lebina amurndakijika kamila-langwa akwa numurndaku-kwa amarda enik-alyubari-yada amurndakakina. Biya kembirra nenumin-akarrngarna akungwa nakina-langwa nenikuminuwar•duwar•da Aburiyama-langwa-langwa akwa ngawa wurrumurndakakina-langwa warnungkwarba ena-langwa-langwa kajungwa warnik-ajarri-yada alika. ");
INSERT INTO aoi_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Umba aburraja Lebina-langwa warnikuminuwar•duwar•da narramini-dakama aninga akwa narre-yikenuma aburruwa-wa. Eneja ni-yama Aburiyama-langwa nenikuminuwar•duwar•da Lebinu-wa, “Nara ngarna alyubaruma ambaka aninga. Umba adinuba-wiya ayakwa ki-yengbinama ngayuwa.” Eneja ni-yama Lebina, “Yengbina kembirra.” ");
INSERT INTO aoi_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Enamba-langwa kembirra nenikuminuwar•duwar•da Aburiyama-langwa nenilirraku-makama Lebinu-wa akwa Beduwelu-wa ena-langwa-langwa nubungkawa. Ni-yama, “Ngayuwe-ka ningena Aburiyama-langwa ningenikuminuwar•duwar•da. ");
INSERT INTO aoi_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Nakine-ka Yaweya ni-yamama eningaba nganyangwa-manja nubungkawa Aburiyama. Kembirra aduwaba nakina numinababurne-ka amurndakijika-murriya. Nenu-kwama Yaweya jiba iya nenukwuda iya bulukwa iya kamila akwa dangki. Akwa ngarningka nenu-kwama awurrakwulyumida angwarnda amamamuwa amurndakibina akawulda-murra iya ajilba-murra akina. Akwa ngarningka nenu-kwama warnikuminuwar•duwar•da warnungkwarba iya wurridarringka kenuminu-war•deni-yada ena-langwa. ");
INSERT INTO aoi_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Umba nganyangwa-langwa nubungkawa dadingiyenikba Jera ying-adiyuwangkwudinu-manja yinginumin-arrangbama nenikuwenikba arakba dakina. Nganyangwe-ka nubungkawa nenumurndaku-kwama ababurna-langwa ena-langwa ebina nu-wilyakama nenikuwenikba-manja,” ni-yama nenikuminuwar•duwar•da Beduwela-kiya-wa. ");
INSERT INTO aoi_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Biya ngarningka ni-yama, “Biya nginu-makama nakina ningeniki-yarrkakumi-yada ayakwa kajungwa kinumin-engkirrikaji-yada ngayuwa ena-langwa ayakwa. Ni-yamama, ‘Nara aminu-manguma warningerribirra wurradidiyara enena-langwa angalya Kenina nenikuwarrka-langwi-yada dadingiyenikba, ");
INSERT INTO aoi_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","umba ki-likaja nungwarrka-langwu-wa warnumamalya akwa kinuminu-mena duwilyaba dadingakwujina dadiyara nenikuwarrka-langwi-yada,’ ni-yamama nakina Aburiyama ngayuwa-wa. ");
INSERT INTO aoi_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Nganja ningi-yamama, ‘Umba dakina dadiyara nara-manja ngi-likama ngayuwa-manja, kembirra ki-yamarrkinama ngayuwa?’ ningi-yamama. ");
INSERT INTO aoi_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Enamba-langwa Aburiyama ni-yamama ngayuwa-wa, ‘Yaweya nakina-bina kenu-mamurikajinama, nibina ningenumini-yarrkuwarakinama ena-langwa ayakwa aduwaba ngawa wuburra arakba-wiya. Keni-larrkajama nakina nuwilyaba nenikumamurikaja ena-langwa nungkuwa-wa, kajungwa kenu-mamurikajini-yada nungkuwa-manja kenu-wilyakajini-yada nungkuwa ningkakina-da. Kinuminu-mename-ka dadiyara nenikuwarrka-langwi-yada nganyangwa-langwa warnumamalya. ");
INSERT INTO aoi_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Umba ki-likaja-manja ningkakina nganyangwu-wa warnumamalya akwa ka-warena-manja wurrakina akwa ki-lyangkirerrmina-manja ningkakina, nganja kembirra ngayuwa yib-enjungwurrenama ebina-langwa ayakwa ki-lawurradina-mulangwa ningkakina ningkeningiyanda,’ ni-yamama Aburiyama ngayuwa-wa,” ni-yama nenikuminuwar•duwar•da Beduwela-kiya-wa. ");
INSERT INTO aoi_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","Biya ngarningka ni-yama, “Kembirra ningi-yar•du-manja nganja enena-manja angalya aduwaba akwa ning-embirrarinu-manja ebina-manja emedirra akungwa, kembirra ningu-buriyaminuma ngayuwa Yaweyu-wa. Ningi-yamama ngayuwa enuwa-wa, ‘Yaweya, ningkibina Ningkeningikarrawara nganyangwa-langwa nubungkawa Aburiyama-langwa, yi-mamurikajiya-langwa ena-manja angalya, yu-wilyakajiya-langwa dibina dadiyara aduwaba. ");
INSERT INTO aoi_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Kwuja! Ningena ngayuwa ning-abalkayukwunama yelakwa enena-manja ngawa emedirra akungwa. Umba kingi-likaja-manja duwilyaba dadiyara yangkwurrangwa akungwa-wa, kembirra ki-yaminama ngayuwa ngaluwa-wa, Yi-bekajiya-langwa akungwa nungkwa-langwa-langwa menarlamba? ");
INSERT INTO aoi_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","Kembirra kingi-lyangkuwamina-manja dakina dadiyara akwa ngarningka kingi-yamina-manja dakina ngayuwa-wa, Kumin-akarrnginama akungwa nungkwa-langwa-langwa kamila, kembirra ninginga-ngayindenama dakina-bina ningku-wekbalyinuma ningkakina dadingiyenikba Aburiyama-langwa-langwa nenikuwenikba-da,’ ningi-yamama ngayuwa Yaweyu-wa-da,” ni-yama nenikuminuwar•duwar•da Beduwela-kiya-wa. ");
INSERT INTO aoi_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Biya ngarningka ni-yama, “Umba ningakina ningu-buriyaminuma ngayuwa arrawa nganyangwa-murra mangma ningeningayakwa-ma. Kembirra akina-wiya ningu-buriyaminu-wiya ngawa, yingi-yar•da ngalaja Ribeka yingi-ngabukweyinuma dakina menarlamba ngala-langwa-manja amurn•da. Yingi-dirrirnda emedirra-wa akungwa-wa, umba ningi-yamama ngayuwa ngaluwa-wa, ‘Yu-kwa-langwa akungwa.’ ");
INSERT INTO aoi_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Warenja-bawiya yinguma-larrija menarlamba ngala-langwa-langwa amurn•da akwa yingi-yamama ngayuwa-wa, ‘Beka-langwa, umba kumin-akarrnginama ngarningka akungwa nungkwa-langwa-langwa kamila.’ Kembirra ningi-bekina arakba ngayuwa, umba yingumin-akarrngarna akungwa kamila-langwa. ");
INSERT INTO aoi_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Umba ningi-yamama ngayuwa, ‘Numiyambena nungwena?’ Ngalaja yingi-yamama, ‘Nungwarrka nenimikirra Beduwela umba nungwenikba ena-langwa Neyawa nakina akwa dirndenikba dadimikirra Milka.’ Nganja kembirra ningingamin-akumarna errumungkwa ngala-langwa, awilyaba eyukwujiya eminda-manja umba ambilyuma aruma-kiya ngarningka ayarrka-manja. ");
INSERT INTO aoi_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Biya ning-abuluwendinga arakba ngayuwa ningeni-yangmarngkwajuwama Yaweyu-wa. Ngayuwa ningeni-yangmarngkwajuwama Yaweya nibina Neningikarrawara nganyangwa-langwa nubungkawa Aburiyama. Nakina-bina Yaweya nginu-wilyakama ngayuwa dirrbura yangkwurrangwa. Nginu-wilyakama nungkuwa-wa, Beduwela, ningkibina Aburiyama-langwa ningkenumamalya, akwa ngawa nungkwa-langwu-wa dadiyawena, kajungwa king-ambilyi-yada dakina dadingiyenikba Aburiyama-langwa-langwa nenikuwenikba. ");
INSERT INTO aoi_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Nungkwaja kembirra ki-yamina-manja adirrbura-wiya nganyangwa-manja nubungkawa akwa eningaba ki-yamina-manja enuwa-manja, kembirra yi-makina. Umba nara-manja e-yamama ningkakina eningaba enuwa-manja, kembirra yi-makina ngarningka. Kembirra nganja ningeningma ngayuwa ki-yamina-mulangwa ngayuwa,” ni-yama nakina nenungkwarba Aburiyama-langwa Beduwela-kiya-wa-da. ");
INSERT INTO aoi_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Kembirra aburnaja wunalakina Lebina akwa Beduwela neni-yama enuwa-wa, “Amurndakakina yirru-maka-mulangwa ningkakina aduwaba ni-yamama Yaweya enabakiya-ba akina ababurna-langwa. Kembirra nara yirraja a-lyangkuwamama akwa a-lyangkirerrmama. ");
INSERT INTO aoi_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Umba daka Ribeka. Nga-wilyakina akwa likaja, kajungwa nenikuwenikba nungkwa-langwa-langwa nubungkawa kininga-meni-yada daka, mena nakina Yaweya enabakiya-ba ni-lyangkuwerribikajungwunuma akinu-wa-da,” neni-yama wunalakina Lebina akwa Beduwela-da. ");
INSERT INTO aoi_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Eneja n-engkirrika-manja nenikuminuwar•duwar•da Aburiyama-langwa amurndakakina ayakwa, kembirra n-abuluwendinga nakina akwa neni-yangmarngkwajuwama Yaweyu-wa. ");
INSERT INTO aoi_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Kembirra nanga-larrngkuwaraka dumbala-murriya akwa errumungkwa-murriya ebina na-ngekburakajungwunuma ajilba-ma akwa akawulda-ma akwa ngawa akwala ngarningka amurndakijika alarrngekburna akwa nangamurndaku-kwama Ribeka-wa. Akwa ngarningka nenu-kwama alarrngekburna amurndakijika aminarumuruma angwarnda narrkuwadikba-wa akwa dirndadikba-wa. ");
INSERT INTO aoi_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Biya kembirra nakina nenikuminuwar•duwar•da Aburiyama-langwa akwa ena-langwa warnungkwarba nuw-alyubarinuma arakba ebina aninga akwa ne-bekinuma akubibeka. Biya na-mungkwuluma wurrakina yakwujina Beduwela-langwa-manja angalya muwilyaba marringa. Biya mingka-manja meninguwurdarriya-wiya mamawura kembirra nu-mirajanga nakina nenikuminuwar•duwar•da Aburiyama-langwa akwa ni-yama Ribeka-langwu-wa warnumamalya, “Yirri-larrkiya arakba ngi-lawurradina nganyangwu-wa nubungkawa,” ni-yama. ");
INSERT INTO aoi_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Aburnaja neni-yama Ribeka-langwa narrkuwadikba akwa dirndadikba wunalakina, “Ang-ambilya-langwa ambaka daka aduwaya, dukwa mamangbala mambilyuma marringa, dukwa mememberrkwa marringa. Kembirra yikinga-larrkiyama daka,” neni-yama wunalakina enuwa-wa. ");
INSERT INTO aoi_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Eneja ni-yama nakina nenikuminuwar•duwar•da, “Nare-ka a-murndurrkwama ngayuwa. Eneja nakina Yaweya nginu-mamurikajuwama ningena, nginu-wilyakajuwama daka dadiyara, kembirra yirri-larrkaja arakba yirri-lawurradina yirra-langwu-wa nubungkawa,” ni-yama. ");
INSERT INTO aoi_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Aburnaja neni-yama, “Ngarring-ardijiya-langwa kwureya kingi-yamina-murrikba dakina,” neni-yama. ");
INSERT INTO aoi_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Kembirra narring-ardijuwa dakina Ribeka akwa neni-yama ngaluwa-wa, “Ningki-ngayindena ki-likaja nenaka-manja nenungkwarba?” neni-yama. “Yawu,” yingi-yama ngalaja. ");
INSERT INTO aoi_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Aburnaja kembirra wunalakina neninga-larrka Ribeka dadiki-liki-yada Aburiyama-langwa-manja nenikuminuwar•duwar•da akwa ena-langwa-manja warnungkwarba. Akwa ngarningka neninga-larrka duwilyaba dadiyuwangkwa, dibina dadikuminuwar•duwar•da Ribeka-langwa dakina, ngalajukwaba. ");
INSERT INTO aoi_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Akwa neni-yengbinuma eningaba ayakwa Ribeka-wa lukwuniyawa. Neni-yama, “Ningkakina ningkuminjarringba ningkeningadinuba-wiya k-ambilya wurruwurrakwulyumida-langwa warnumamalya. Aburraja nenikabijena-murriya warnikinikaduwa nungkwa-langwa ab-ambilya wurringbuda wurrakina. Ka-wardiyina-manja wurrakina wurrukwala-manja warnumamalya, kembirra nungkwa-langwa nenikabijena-murriya warnikinikaduwa ka-bungkawadina wurrakina-manja warnumamalya-da,” neni-yama wunalakina Ribeka-wa-da. ");
INSERT INTO aoi_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Ngalaja kembirra Ribeka akwa ngarningka ngala-langwa warnikuminuwar•duwar•da wurradidiyara akwa dibina dadiyuwangkwa narri-larrngmurndukwa aburra-langwa amurndakijika akwa narringawurraku-wurdijuwa kamila-manja. Kembirra na-likena arakba Aburiyama-langwa-manja warnikuminuwar•duwar•da-da. ");
INSERT INTO aoi_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Na-likenume-ka wurrakinu...wa yanda-langwa narr-akburranga ebina angalya Kenina. Kembirra nuw-alilikenuma ngawa wurrakina nuw-angkarrinu-murruwa arrirra dalada. Eneja nakine-ka Ajika n-ambilyumurra yakwujina Kenina-manja. Engburingka-manja angalya n-ambilyumurra nakina ebina-manja emedirra emikirra “Numinakina Emedirra Akungwa Neniba akwa Ngini-rringkinama Ngayuwa.” ");
INSERT INTO aoi_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Biya num-awiyebu-manja mamawura ni-jadanguma nakina ena-langwa-langwa kalikwa akwa nu-murndakilikenu-manja nakina n-andeya akena ni-rringka kamila abukwaya nawurraki-likenuma. ");
INSERT INTO aoi_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Ngalaja dakina Ribeka yingini-rringka-manja nakina Ajika yingu-kuwabijanga ngala-langwa-langwa kamila ");
INSERT INTO aoi_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","akwa yingi-yama Aburiyama-langwu-wa nenikuminuwar•duwar•da, “Numiyambena nangaba nenungkwarba ni-likajama yangkwurrangwa ngakwurruwa-wa?” yingi-yama. Eneja ni-yama, “Nganyangwe-ka nakina nubungkawa,” ni-yama. Kembirra nanga-rndirrka dumbala akwa yingu-wurumbijajungwa ying-abuwarrkajungwa dadumukwurra. ");
INSERT INTO aoi_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Biya kembirra nenu-maka nakina nenikuminuwar•duwar•da Ajiku-wa ababurna-langwa ngawa ni-yamama akina. ");
INSERT INTO aoi_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Eneja Ajika nang-awiyebajuwa kembirra Ribeka ena-langwa-manja kalikwa. Dakine-ka kalikwa dirndenikba-langwa Jera-langwa adinuba-wiya. Kembirra dadingiyenikba arakba Ribeka dakina-da. Ajike-ka nakina ni-lyelyingminuma dakina-manja umba ngalaja yinginu-werringekburakama nakina nara-manja dibina dirndenikba, yingi-jungwu-mubaba arakba dakina-da. ");
INSERT INTO aoi_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Eneja nakina Aburiyama nanga-wilyakama duwilyaba ngarningka dadingiyenikba. Dadimikirra Kedira. ");
INSERT INTO aoi_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Warna kembirra warnimikirra wurriyukwayuwa wurribina Kedira yinginumin-arrangbama Aburiyama-langwa dakina. Warnimikirra Jimirena iya Jakijena iya Midena iya Midiyena iya Yijibeka akwa ngawa Juwa. ");
INSERT INTO aoi_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Nakine-ka Jakijena, nibina naburradikba Kedira-langwa, nungwenikba nakina wunalakina-kiya-langwa Juba akwa Didena. Aburraja Didena-langwa wurrumirumirena warnikinikaduwa nuw-ababurnadinuma wurruwurrakwulyumida wurrakina yanda-langwa wurrilyimberrkabiyakarbiya warnumamalya arakba. Umba warnimikirra wurrakina WarningAjuruma warnumamalya iya WarningiLidijima warnumamalya akwa ngawa WarningiLiyumima warnumamalya. ");
INSERT INTO aoi_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Umba eneja Midiyena, nibina Kedira-langwa enejukwaba naburradikba, n-akumajungwunuma nakina wurrumangbala warninikuwena. Warnimikirra wurrakina Ebaya iya Ebera iya Yenakwa iya Abuda akwa ngawa Eldaya. Umba dakine-ka Kedira duminjarringba dadingadinuba-wiya wurrumurndakakina-langwa warnumamalya wurrababurna-langwa. ");
INSERT INTO aoi_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","6","Neniba-wiya ngawa eneja nakina Aburiyama, nenu-kwama akwala amurndakijika-murriya ena-langwu-wa warninikuwena Yeka-langwu-wa akwa ngawa Kedira-langwu-wa wurrabuburarrngwa. Biya neni-larrkama nakina wurrumurndakakina warninikuwena wurrababurna-langwa engku-wa nuw-errbalinuma Ajika-langwa. Neni-larrkame-ka nakina alyengma-wa angalya kajungwa yakwujina ngawa kuw-ambilyi-yada wurrakina warningangkawura-da. Biya kembirra ni-yama nakina Aburiyama, “Ki-jungwuna-manja ngayuwa kembirra ababurna-langwa bulukwa iya jiba iya nenukwuda iya kamila iya dangki iya ababurna-langwa amamamuwa ajilba-ma iya akawulda-ma akwa ngawa ababurna-langwa amurndakijika nganyangwa kuw-ambilyama Ajika-langwa amurndakakina-da,” ni-yama nakina-da. ");
INSERT INTO aoi_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Nakine-ka Aburiyama n-ambilyumurra 175 mamarika iya yinungkwura-da. ");
INSERT INTO aoi_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","Meningaba-wiya mamurndakakina mamarika iya yinungkwura n-ambilyumurra. Biya ni-jungwa arakba nakina-da. ");
INSERT INTO aoi_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Kembirra aburnaja wunalakina ena-langwa warnikuwabulena Ajika akwa Yijumeyila nen-akumarnumurra nenumadangkwa nakina mibina-manja medirra memikirra Makbela. Num-ambilyuma makina Mamura-langwa-manja angalya akwudangwa. Umba akine-ka angalya adinuba-wiya Ebirena-langwa akina. Umba eneja Ebirena-langwa nungwenikba nenimikirra Jawura NeningiYida nenumamalya nakina. ");
INSERT INTO aoi_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","Makine-ka medirra nu-beyindanguma Aburiyama wurrumurndakibina-langwa warnumamalya WarningiYida-langwa. Aburraja aburna-langwa wunenumadangkwa-kiya narr-akumarnuma wurrakina Aburiyama-langwa iya Jera-langwa makina-manja ngawa muwilyaba-ma medirra arakba-da. ");
INSERT INTO aoi_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Kembirra ni-jungwu-mulangwa nakina Aburiyama eneja Neningikarrawara nakina ni-yamama eningaba Ajika-manja nenikuwenikba-manja. Nakine-ka eneja Ajika n-ambilyumurra akwudangwa ebina-manja emedirra emikirra “Numinakina Emedirra Akungwa Neniba akwa Ngini-rringkinama Ngayuwa.” Biya yakwujina ngawa n-ambilyumurra Ajika nakina-da. ");
INSERT INTO aoi_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Eneja nakina Yijumeyila neningadinuba-wiya nenikuwenikba Aburiyama-langwa. Umba dirndenikba Yeka, dibina dadikuminuwar•duwar•da Jera-langwa DadingiYijiba dakina. ");
INSERT INTO aoi_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Kembirra Yijumeyila n-akumajungwunuma nakina wurrumemberrkwa wurrambilyuma warninikuwena ena-langwa. Neningadinuba-wiya nenimikirra Nubeyada nakina. Umba ngarningka wurrukwala warnimikirra wurrakina Kedara iya Adubela iya Mibijama ");
INSERT INTO aoi_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","iya Mijuma iya Duma iya Maja ");
INSERT INTO aoi_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","iya Yadada iya Dema iya Jedira akwa ngawa Nabija. Umba neningarija-langwa nenimikirra Keduma nakina. ");
INSERT INTO aoi_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Wurrumurndakakine-ka warnungkwarba wurrumemberrkwa wurrambilyuma nuw-ambilyuma wurrumirumirena warningadinuba-wiya wurrilyimberrkeyebijeba-langwa iya wurrilyimberrkeyebijeba-langwa warnumamalya wurrakina. Umba aburra-langwa angalya waka aminambawura alikira waka eningerriberriba na-wilyakama ekirra aburra-langwa-da. ");
INSERT INTO aoi_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Bi...ya eneja nungwarringba Yijumeyila neniyuwangkwe-ka arakba. Umba n-ambilyu-manja 137 mamarika iya yinungkwura kembirra ni-jungwa arakba nakina-da. ");
INSERT INTO aoi_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Aburraja wurrumurndakibina wurrumirumirena warnikinikaduwa Yijumeyila-langwa nuw-ambilyuma wurrakina akina-manja angalya wilyarra Yebila akwa ngawa Jura. Akine-ka angalya aburra-langwa. Umba na-likenu-manja aburraja warnumamalya Yijiba-langwa akwa engku-wa angerriba Ajiriya-wa wurrakina, kembirra narri-larrkuwarrukwama aburra-langwa angalya wilyarra. Umba wurreyebijebe-ka wurrakina Yijumeyila-langwa warnumamalya nuw-ambilyumurra Ajika-langwa-langwa warnumamalya akwa ngawa wurrukwala-langwa-langwa wurrumirumirena Aburiyama-langwa wurrakina-da. narri-larrkuwarrukwama aburra-langwa angalya wilyarra. Umba wurreyebijebe-ka wurrakina Yijumeyila-langwa warnumamalya nuw-ambilyumurra Ajika-langwa-langwa warnumamalya akwa ngawa wurrukwala-langwa-langwa wurrumirumirena Aburiyama-langwa wurrakina-da. ");
INSERT INTO aoi_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Enena alawudawarra Aburiyama-langwa-langwa nenikuwenikba Ajika. ");
INSERT INTO aoi_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Ajika nakina arngkabiyarbuwa-ma arngkumemberrkwa mamarika iya yinungkwura, kembirra nanga-manga nakina Ribeka dadingiyenikbi-yada. Umba ngalaja Ribeka dadiyawenikba Beduwela-langwa dakina. Umba NeningArama nakina Beduwela akwa ena-langwa angalya Mejubudamiya. Umba Ribeka-langwa narrkuwadikba nakina Lebina. ");
INSERT INTO aoi_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Eneja nakina Ajika nangaminu-buriyaminuma Yaweyu-wa wurrangariyi-yada nara-baba wurribina wurriyukwayuwa Ribeka-langwa. Kembirra eneja Yaweya n-engkirrikena nakina ena-langwa ayakwa. Ngalaja kembirra Ribeka yingu-mambakinuma arakba wurrangariya, ");
INSERT INTO aoi_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","akwa dadingma dakina wurrambilyuma-kiya wurrangariya ngala-langwa. Aburnaja kembirra nara-wiya keni-rukwularrina neni-jiriyinuma wunalakina arrawa. Ngalaja yingi-yama Ribeka, “Karukwa, ningi-yamarrkama ningena-burra?” yingi-yama. Kembirra dakina yingini-yengkilabena Yaweyu-wa wurriyukwayuwa-langwa. ");
INSERT INTO aoi_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Eneja nakina Yaweya ni-yama ngaluwa-wa, “Wunumilyengma-kiya nungkuwa-manja arrawa nen-ambilyama wunalakina wunenumamalya-kiya. Kembirra wunambilyuma wurrumirumirarrngwa wunalakina ken-ambilyama wurrilyimberrkambilyuma-langwa warnumamalya. Kembirra aburraja wurrumurndakakina warnumamalya aburna-langwa ke-kuwurriyinama wurrakina akwa kuw-errbalinama. Nuwilyaba ningbuda nakina nuwilyaba-manja. Kembirra numangaruma-dangwa nawenikba kenumin-engkirrikajama nenikumarnjenikba-wa,” ni-yama Yaweya Ribeka-wa. ");
INSERT INTO aoi_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Biya neni-rukwularra wunalakina wuniyukwujiya-kiya arakba. ");
INSERT INTO aoi_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Neningadinuba-wiya numilyingarradada nakina akwa ayama-wiya, akwa neni-yengbijuwama nakina nenimikirra Yijawa, mena akina ekirra Yijawa ne-yaminama “ayama-wiya.” ");
INSERT INTO aoi_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Kembirra enamba-langwa neningarija-langwa ni-rukwularru-manja nakina ni-lyingama angwurra amulurrngwa-manja alika neningadinuba-wiya-langwa. Kembirra neni-yengbijuwama nakina nenimikirra Jekaba, mena akina ekirra Jekaba ne-yaminama “ni-lyinginama amulurrngwa-manja alika.” Akena aburraja warnumamalya narra-yarrumurnduwarna-manja ayakwa warningerribirra-langwa akwa ne-yamina-manja, “Naka nenumamalya ni-lyinginama amulurrngwa-manja alika,” kembirra akina ayakwa aburra-langwa ne-yaminama, “Naka nenumamalya neni-kadikinama wurrukwala-manja.” Umba neni-rukwularrinu-manja wunalakina eneja nungwarringba Ajika n-ambilyumurra nakina arngkumemberrkwa-ma arngkumangbala arngkuwilyaba mamarika iya yinungkwura arakba. ");
INSERT INTO aoi_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Bi...ya nen-arumidinuma aburnaja wunalakina. Kembirra Yijawa nabarda yinungungwangba-murriya neniku-ngurrkwa-langwa akwa ni-lyelyingminuma erriberriba-wa nenik-alilika. Umba Jekaba ninyarrngwa nakina akwa ni-lyelyingminuma nenik-ambilyinga awilyaba-murra-manja angalya. ");
INSERT INTO aoi_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Kembirra eneja nakina nungwenikba ni-lyelyingminuma Yijawa-manja angwurra mena ni-lyelyingminuma nenik-alyubari-yada yakina yinungungwangba nu-wardangu-mulangwa Yijawa. Ngalaja Ribeka yingi-lyelyingminuma dakina Jekaba-manja. ");
INSERT INTO aoi_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Eneja kembirra arngkawura Jekaba ni-ngarngkwudakama nakina amalyirra amaninga amadidira-langwa. Umba eneja nakina Yijawa ni-lawurradinuma nakina nu-ngurrkwenu-mulangwa. Biya nu-mureyanga nakina. ");
INSERT INTO aoi_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Ni-yama Jekabu-wa nenikumarnjenikba-wa, “Ningu-mureyenama angwurra ningena. Yu-kwa-langwa nganja akwala aninga amalyirra amilyingarradada,” ni-yama. Kembirra aminakina-langwa Yijawa nu-wilyakama nakina ambilyuma ekirra. Awilyaba Yijawa akina umba awilyaba ngarningka Yiduma, mena akina ekirra Yiduma ne-yaminama “amilyingarradada.” ");
INSERT INTO aoi_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Eneja ni-yama, “Yawa, yiba-kwunama ningena,” ni-yama Jekaba, “umba yiku-makinama ngayuwa ningena ningumilyengma wuburra ningenungkwulyuba akwa nara arakba nungkuwa,” ni-yama. ");
INSERT INTO aoi_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Enamba-langwa ni-yama Yijawa, “Mama! Ki-jungwunama ningena ningu-mureyena-baba, kembirra ki-yamina-manja ngayuwa ningumilyengma-dangwa amiyambena eningaba nganyangwa?” ni-yama. ");
INSERT INTO aoi_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Enamba-langwa Jekaba ni-yama, “Yirra-ngayindenama ningkakina ki-yarrkakumurnama enena ayakwa akwa nara a-yarrkuwarrukwajuma. Ki-yarrkakumurnama ayakwa kajungwa ngayuwa-bina ki-yamini-yada kembirra ningumilyengma wuburra ningenungkwulyuba arakba-da,” ni-yama. Kembirra eneja ni-lyangkuwama nakina Yijawa, ni-yarrkakumarna akina ayakwa nakina-da. ");
INSERT INTO aoi_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Kembirra nakina Jekaba nenu-kwa damba akwa akwala amalyirra ni-ngarngkwudaka-mulangwa. Kembirra Yijawa n-alyubarina arakba akina damba akwa ni-bekina amalyirra akina, akwa nu-warumajungwa ni-likena. Akwa ni-lyangkiyama, “Mama nakina-da! Numilyengma kembirra-da,” ni-lyangkiyama Yijawa nakina-da. ");
INSERT INTO aoi_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Arakburakba-kiya-wiya n-ambilyu-wiya Aburiyama Kenina-manja angalya nakina, ne-yukwujiyadinuma aninga, biya ni-likenuma nakina Aburiyama Yijibu-wa. Kembirra aduwaba ngarningka n-ambilyu-manja enamba-langwa nenikuwenikba Ajika akina-manja ngawa angalya Kenina ne-yukwujiyadinuma ngarningka nuw-ambawuradinuma aninga wuburra ebina-wiya. Kembirra ni-likena nakina Ajika akwaburrangarnu-wa Kera-wa. Akine-ka angalya Kera WarninguBilijiya-langwa warnumamalya akina, akwa nubungkawa aburra-langwa Abimileka nakina. Kembirra ni-likena nakina eneja Ajika enuwa-wa. ");
INSERT INTO aoi_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Eneja kembirra Yaweya ni-jadinga nakina Ajika-manja akwa ni-yama enuwa-wa, “Nara a-likama Yijibu-wa,” ni-yama, “umba engkirraja nganyangwu-wa ayakwa. Ambilya ngawa enena-manja angalya,” ni-yama. ");
INSERT INTO aoi_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","“K-ambilya-manja ningkena yelakwa ngawa kembirra k-ambilyama ningena akwudangwa nungkuwa-manja akwa ki-yaminama eningaba ningena nungkuwa-manja,” ni-yama Yaweya Ajiku-wa. “Yiba-kwunama ngayuwa amurndakenena angalya nungkwa-langwi-yada akwa ngawa warnikinikaduwa-langwi-yada numirena-murriya. Ngayuwa ki-yarrkilalikinama ngawa ayakwa ebina ningi-yarrkakumarnuma arakba-wiya nungwena-langwa Aburiyama-langwa. ");
INSERT INTO aoi_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Yiba-kwunama wurruwurrakwulyumida numirena-murriya warnikinikaduwa. Wuburra dakilyingajanga duwurrakwulyumida karrawara ningkinga-rringkinama, ke-yaminama aburrajukwaba wurrakina wurruwurrakwulyumida akwa ka-kwuname-ka ngayuwa amurndakenena angalya ababurna-langwa aburruwa-wa. Kembirra aburraja wurrababurna-langwa warnumamalya wurriminiminingka kabi-yendabajama wurrakina ngayuwa-wa akwa ke-yaminama, ‘Wu-ngekburakina eningaba yirruwa-manja, wuburra laka ningki-yamamurra Ajika-langwa-manja wurrumirumirena warnikinikaduwa,’ ke-yaminama wurrakina. ");
INSERT INTO aoi_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","Ki-yaminame-ka ngayuwa eningaba nungkuwa-manja mena Aburiyama nakina nara-baba kini-yarrkuwurranga ayakwa nganyangwa umba nginumini-yarrkuwarakama ababurna-langwa ayakwa eningarumuruma nganyangwa,” ni-yama nakina Yaweya nenu-maka Ajiku-wa. ");
INSERT INTO aoi_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Kembirra yakwujina-wiya n-ambilyuma Ajika arakba Kera-manja. ");
INSERT INTO aoi_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Umba aburraja wurrukwala wurruminakina angalya warnungkwarba neni-yendabenuma Ajiku-wa Ribeka-langwa dadingiyenikba-langwa. Eneja ni-yama, “Dadiyamarnjarrka daka-da,” ni-yama aburruwa-wa. Nara nakina kini-ngayindanga kininga-yengbijuwa dadingiyenikba, mena n-akbar•danguma warniku-warda-langwa nakina wurrumurndakakina warnungkwarba wurruminakina angalya, kajungwa Ribeka karringa-mangi-yada wurrakina. Dadingabe-ka dakina dadumukwurra akwa aminakina-langwa narringa-ngayindanguma. ");
INSERT INTO aoi_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Bi...ya ambaka-murra eneja nakina Nubungkawa Abimileka n-andirrarina ena-langwa-langwa alikira akena nenilirraki-rringkama wunalakina-kiya Ajika akwa ngawa Ribeka. Nenilirraki-rringka-manja Abimileka wunalakina wuburra wuneninga-manja neni-yamama wunalakina-da. ");
INSERT INTO aoi_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Biya nen-ardijuwa nakina Ajiku-wa neniki-liki-yada enuwa-wa. Ni-yama Nubungkawa Abimileka Ajiku-wa, “Nungkwa-langwa dadingiyena daka-na!” ni-yama. “Miyambena-burra ningkarra-makama warnumamalya-manja, ‘Dadiyamarnjarrka daka-da,’ ningki-yamama ningkakina?” ni-yama nakina Nubungkawa-da. Ajika eneja ni-yama, “Ngaya-bu ningi-lyangkiyamama, ‘Warnumamalya warningiyelakwa kabu-wardanga-bu,’ ningi-yamama, ‘kajungwa kabu-mangi-yada dadingiyarrka,’ ningi-lyangkiyamama,” ni-yama nakina Ajika. ");
INSERT INTO aoi_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Ni-yama enamba-langwa nakina Abimileka, “Ningki-yamarrkama-burra? Yirri-kadika yirruwa-manja-na!” ni-yama. “Aburraja warningerribirra warnungkwarba nganyangwa ka-mungkwulama dadingiyena-manja. Akine-ka awurrariya nungkwa-langwa akina, nara yirra-langwa,” ni-yama. ");
INSERT INTO aoi_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Biya nakina Abimileka nenu-madumurrukwama wurrababurna-manja warnumamalya ena-langwa-manja akwa ni-yama aburruwa-wa, “Nungkwurraja karningerribirra karnumamalya yiki-yamina-manja awurrariya nenaka-manja nenungkwarba akwa ngawa dadingiyenikba-manja, yiki-jungwunama kirrakina-da. Nganja ka-makinama nganyangwa wurrawinyamba warnungkwarba kembirra yikabu-wardenama kirrakina aminakina-langwa awurrariya-da,” ni-yama nakina nubungkawa-da. ");
INSERT INTO aoi_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Kembirra eneja Ajika nakina n-ambilyuma ngawa yakwujina akwa ni-lungkuwabijuwama amamamuwa aningi-yada. Bi...ya kembirra mibina-manja ngawa mamarika nuwurra-murndukwama nakina awurrakwulyumide-ka aninga. Nu-manguma nakina awurrakwulyumida aninga mena nakina Yaweya ni-yama-mubaba eningaba enuwa-manja. ");
INSERT INTO aoi_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","N-ambambilya yakwujina bi...ya yanda-langwa numin-ababurnadinuma arakba aninga-murriya iya amurndakijika-murriya nakina, mena Yaweya nenu-mamurikajuwa-mubaba nakina neningangkawura. ");
INSERT INTO aoi_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Ababurne-ka jiba iya bulukwa ena-langwa. Aburrajukwaba wurrababurna warnikuminuwar•duwar•da ena-langwa. Kembirra arakba aburraja wurrumurndakibina WarninguBilijiya warnumamalya ne-yakwujaminuma wurrakina Ajika-langwa. ");
INSERT INTO aoi_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Kembirra narr-ekirrembama ajiringka ababurna-manja emedirra akungwa. Arakba-wiya neniba-wiya ngawa nungwenikba Aburiyama, aburraja Aburiyama-langwa warnikuminuwar•duwar•da na-mungkadinuma amurndakakina adinuba-wiya. Kembirra Ajika-langwa enamba-langwa arakba amurndakakina emedirra akungwa aduwaba-da. ");
INSERT INTO aoi_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Eneja kembirra ni-yama Abimileka Ajiku-wa, “Jeyi! Likaja arakba,” ni-yama. “Wu-lalika ena angalya yirra-langwa. Ningkakine-ka ningkingbuda ningkenumamalya yirruwa-manja angwurra aduwaba,” ni-yama. ");
INSERT INTO aoi_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Eneja kembirra Ajika nu-warumajungwa akwa nu-makilalika akina angalya akwa aburruwa ena-langwa warnumamalya. Namurndaki-likenuma ekbilyuwalyu-wa angalya akwudangwa Kera. Narri-ngekburakama arakba angalya, kembirra yakwujina ngawa nuw-ambilyumurra wurrakina-da. ");
INSERT INTO aoi_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Biya na-mungkadinuma ngarningka wurrakina Ajika akwa ena-langwa warnungkwarba emedirra akungwa amurndakibina-murrada nungwenikba-langwa warnikuminuwar•duwar•da na-mungkadinu-murrada adinuba-wiya. Eneja nakina Aburiyama ni-yengbijuwama emikirra emedirra amurndakakina. Akena ni-jungwu-mulangwa nakina kembirra aburraja wurrumurndakibina WarninguBilijiya warnumamalya narr-ekirrembama ajiringka amurndakakina. Kembirra enamba-langwa nakina Ajika ni-yengbijuwama arija-langwa ebina-murrada emikirra emedirra nakina-da. ");
INSERT INTO aoi_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Kembirra arakba aburraja Ajika-langwa warnikuminuwar•duwar•da na-mungkadinuma wurrakina ekbilyuwalya-manja angalya edirra biya narr-akburranga kembirra akungwa. ");
INSERT INTO aoi_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Akena aburraja wurruminakina angalya warnungkwarba wurribina narr-embimbirrajuwama jiba aburra-langwa ne-beyinuma wurrakina awinyamba Ajika-langwa-manja warnungkwarba narr-embimbirrajuwa-murrumanja jiba ena-langwa. Ne-yama, “Ene-ka akungwa yirra-langwa,” ne-yama. Kembirra eneja nakina Ajika ni-yengbijuwama akina emedirra akungwa “Nebeyinumurrumanja” emikirra akina. ");
INSERT INTO aoi_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Aburraja kembirra Ajika-langwa warnikuminuwar•duwar•da na-mungkadina engka emedirra akungwa, akena aburraja wurruminakina angalya warnungkwarba akwa ngawa Ajika-langwa warnungkwarba ne-kuwurriyinuma ne-beyinuma awinyamba akina-langwa emedirra ngarningka-da. Kembirra Ajika “Nawirrikbeyinumurrumanja” emikirra ni-yengbijuwama emedirra akungwa akina-da. ");
INSERT INTO aoi_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Kembirra na-warumajungwa arakba Ajika-murriya akwa narru-makirukbijangajuwa angalya akwa na-mungkadina ngarningka emedirra akungwa akena nara arakba ke-beyina awinyamba. Ni-yama nakina Ajika, “Yaweya nakina ngarrenu-kwama enena angalya ngakwurra-langwi-yada akwa kembirra amurndangekburna arakba *ka-ngwur•denama *ka-wuldinama ke-yaminama yelakwa ngakwurra-langwa enena-manja angalya. Enene-ka emedirra akungwa emikirra ‘Ngarrenukwamurrumanja angalya’ akina-da,” ni-yama Ajika-da. ");
INSERT INTO aoi_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Biya kembirra Ajika-murriya narri-lalikama arakba akina angalya umba namurndaki-likena akinu-wa angalya angerriba Biyajibu-wa. ");
INSERT INTO aoi_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Kembirra makina-manja ngawa meningalyarrngwalyilya eneja nakina Yaweya ni-jadinga yakwujina Ajika-manja. Ni-yama Yaweya enuwa-wa, “Ningene-ka Ningeningikarrawara nungwena-langwa Aburiyama-langwa,” ni-yama. “Nara akbar•duma mena k-ambilyama ngawa ningena akwudangwa nungkuwa-manja. Ki-yaminama eningaba nungkuwa-manja, yiba-kwunama numirena-murriya warnikinikaduwa wurrababurna, ebina-langwiya ayakwa ningi-yarrkakumarnu-mulangwiya arakba-wiya-da Aburiyama-langwi-yada-da. Nakina-bina Aburiyama nenikuminuwar•duwar•da nganyangwa akwa ningenu-kwama akina eningarumuruma ayakwa ngayuwa-da,” ni-yama Yaweya Ajiku-wa-da. ");
INSERT INTO aoi_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Eneja kembirra ni-ngekburakama nakina Ajika alda angwarnda-murra yakwujina ngawa akwa neni-yangmarngkwajuwama arakba nakina Yaweyu-wa. Kembirra ni-ngekburaka yakwujina angalya ena-langwa. Aburraja kembirra ena-langwa warnikuminuwar•duwar•da na-mungkadina emedirra ngarningka akungwa yakwujina-da. ");
INSERT INTO aoi_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","N-ambilyu-wiya Ajika yakwujina Biyajiba-manja, eneja nibina Nubungkawa Abimileka ni-likena ena-langwa-langwa angalya angaluba Kera-langwa yenjerrikina Ajiku-wa. Akwa wunambilyuma wunenungkwarba-kiya nenilirraku-wilyakama nakina. Nuwilyaba Bikala, nibina nu-bungkawadinuma nakina ena-langwa-manja wurrawinyamba, umba nuwilyaba ena-langwa nenikuminuwar•duwar•da Ayijada, nibina nenu-mamurikajuwama Abimileka-manja kajungwa Abimileka kin-eningmidini-yada akwiyamangena-langwa nakina. ");
INSERT INTO aoi_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Eneja ni-yama Ajika aburrubukwurruwa-wa, “Miyambena-burra kirrubuki-likena yangkwurrangwa ngayuwa-wa aduwaba?” ni-yama. “Yirr-awinyambaka-murrada kirrubukalakena ngayuwa-manja adinuba-wiya kirru-minangkirraja-murrada nungkwurra-langwa-langwa angalya ningena-da,” ni-yama Ajika. ");
INSERT INTO aoi_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Aburrubukwurraja nabuki-yama, “Yarningma yarna aduwaba n-ambilyama Yaweya nungkuwa-manja. Ngarra-ngayindenama aki-yarrkakumurnama ngakwurruwa ayakwa akwa nara a-yarrkuwarrukwajuma. Kembirra nungkwaja nungkuwa k-akumurnama ayakwa ");
INSERT INTO aoi_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","kajungwa nari-yada e-yamama nungkuwa akwa ngawa nungkwa-langwa warnumamalya awurrariya yirruwa-manja. Yarna yirra nara yiki-yama awurrariya nungkwurruwa-manja ebina-wiya. Yirr-errukwulinuma nungkwurruwa-manja. Nara aku-wardiyina awinyamba umba wulkwa ngarra-larrkama nungkuwa akwa nungkwa-langwa warnumamalya engku-wa yirra-langwa-langwa angalya. Kembirra nungkwurraja kirri-likenuma kirrakina yilyurrkwa-murra yukwudukwuda. Yirraja yirrakakiruma yarna Yaweya ni-yamama nakina eningaba nungkwurruwa-manja,” nabuki-yama wurrubukalakina Ajiku-wa. ");
INSERT INTO aoi_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Kembirra eneja nakina Ajika ni-larrngkwaburranga aninga ababurna aburrubukwurra-langwa biya nabuk-eyijina aninga akwa nabuki-bekeyina akubibeka. ");
INSERT INTO aoi_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Biya nabuku-mungkwula arakba. Biya mingka-manja meninguwurdarriya-wiya mamawura wunalakina Abimileka akwa ngawa Ajika nenu-mirajanga akwa neni-lyelyimbukweyina ayakwa. Kembirra wunalakina-kiya neni-yarrkakumarna ayakwa nari-yada awinyambakajuma akwa nari-yada a-yarrkuwarrukwajuma akina ayakwa. Adinuba-wiya nuwilyaba n-akumarnuma ayakwa kembirra nuwilyaba enamba-langwa. Biya kembirra Ajika ni-yama, “Jeyi! Wurrubuki-likaja arakba angalyu-wa.” Biya Ajika n-ambilya yakwujina ena-langwa-manja angalya umba aburrubukwurraja Abimileka akwa ena-langwa wunenikuminuwar•duwar•da-kiya nabuki-lawurradina arakba wurrubukalakina aburrubukwurra-langwu-wa angalya Kera-wa. Kembirra aburruwa-murra wurrakina arakba-da. ");
INSERT INTO aoi_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Kembirra makini-yada ngawa mamawura aburraja Ajika-langwa warnikuminuwar•duwar•da na-lawurradina wurrakina angalyu-wa na-mungkadinu-mulangwa emedirra-langwa akungwa. Ne-yama, “Akungwa yirr-akburrangama yarna.” ");
INSERT INTO aoi_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Ni-yama eneja Ajika, “Aki-yengbijinama emikirra emedirra akungwa Biyajiba,” ni-yama. Akina ekirra Biyajiba ne-yaminama “emedirra akungwa ngarri-yarrkakumarnu-murrumanja ayakwa.” Kembirra akina angalya Biyajiba ebina-manja n-ambilyu-murrumanja Ajika na-manguma ekirra ngala-langwa akina-langwa emedirra akungwa-da. ");
INSERT INTO aoi_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Eneja Ajika-langwa nenikuwenikba Yijawa n-ambilyu-manja nakina arngkabiyarbuwa-ma arngkumemberrkwa mamarika iya yinungkwura, kembirra nenu-manguma nakina wurringambilyuma-kiya wurringadiyara-kiya ena-langwi-yada wurradingabulena-kiya. WurringadingiYida-kiya wurringalakina. Duwilyaba dibina dadiyawenikba Biyeri-langwa dadimikirra Judida dakina, umba duwilyaba ngalaja dibina dadiyawenikba Elena-langwa dadimikirra Bajumada dakina. ");
INSERT INTO aoi_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Akena wurringalakina-kiya wurringidarringka-kiya narralirraku-werrikawarriyakame-ka wunalakina Ajika akwa Ribeka-da. ");
INSERT INTO aoi_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","N-eniyerringkaduma eneja Ajika nakina akwa nimimbe-ka arakba. Biya nen-ardijuwa kembirra nenikuwenikba neningadinuba-wiya Yijawa akwa ni-yama enuwa-wa, “Nenukwa-yi!” ni-yama. Eneja ni-yama, “Miyambena?” ");
INSERT INTO aoi_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Enamba-langwa ni-yama Ajika, “Yi-rringkina ningena ning-eniyerringkaduma arakba. Dukwa arakba ningena adinuba ki-jungwunama. ");
INSERT INTO aoi_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Kembirra wu-miya arakba enungkwa nungkwa-langwa akwa likaja erriberriba-wa yimin-aburangkina yinungungwangbu-wa. Kinu-wardena yuwilyaba, kini-lawurrakajina yangkwurrangwa ");
INSERT INTO aoi_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","akwa kini-dakina yukwurara nganyangwa k-alyubarini-yada. Kwa, kinu-wilyakina yukwala yangkwurrangwa nganyangwi-yada. Kemba k-alyubarini-yada ngayuwa akwa ki-yengbini-yada kemba eningaba ayakwa eningilyamarmba nungkuwa-wa. Ningi-ngayindenama ngayuwa ki-yengbinama akina ayakwa nganyangwa nungkuwa-wa nara-wiya a-jungwuma,” ni-yama Ajika Yijawu-wa. ");
INSERT INTO aoi_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Akena ngalaja Ribeka ying-engkirrikena akina ayakwa ni-yengbinuma Ajika Yijawa-manja. Umba eneja ni-likena arakba naburradikba naruma-dangwa yinungungwangbu-wa n-aburangkama. ");
INSERT INTO aoi_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Ngalaja kembirra yingi-yama Jekabu-wa, “Ning-engkirrikenuma ningena nungwena ni-yengbinuma ena ayakwa Yijawu-wa. ");
INSERT INTO aoi_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","Ni-yamama nakina, ‘Yiki-yikaja yinungungwangba akwa yikumini-dakina ki-jeni-yada ngayuwa. Kembirra ki-yengbinama eningaba ayakwa nganyangwa ebina eningilyamarmba nara-wiya a-jungwuma ningena, kin-engkirrikaja-murrumanja Yaweya,’ ni-yamama nungwena nenu-makama nawena-manja,” yingi-yama Ribeka Jekabu-wa. ");
INSERT INTO aoi_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Biya yingi-yama ngarningka enuwa-wa, “Kwuja, naburra, yimin-engkirrikaja ambaka-langwa nganyangwu-wa ayakwa. ");
INSERT INTO aoi_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Jeyi! Likaja ngakwurra-langwu-wa nenukwuda, aburangkina ambilyuma-kiya angariya engmurra-kiya. Ku-wilyakina yangkwurrangwa ngayuwa-wa. Kemba nganja ningena ki-dakinama. Eningaba ki-dakinama wuburra laka ni-lyelyingminama nungwena akwurara amadangkwa. ");
INSERT INTO aoi_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Kemba nungkwaja ku-wilyakinama nungkuwa akina amadangkwa nungwenu-wa. Kembirra kini-yengbinama nakina eningaba ayakwa ena-langwa ebina eningilyamarmba nungkuwa-wa nara-wiya a-jungwuma nakina,” yingi-yama Ribeka Jekabu-wa. ");
INSERT INTO aoi_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Eneja Jekaba ni-yama dirndenikba-wa, “Ningkeningma nawarrka nu-wilyakinama ababurna ayama. Nara ebina ayama nganyangwa-manja ayarrka. Ayama-wiya nakina akena nara nganja ebina. ");
INSERT INTO aoi_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Dukwa nungwarrka keni-lyinga-manja ngayuwa kembirra kin-eningmidinama ngayuwa nungwarrka-da. Kembirra neningma nakina nara Yijawa ningakina umba kini-kadikinama ngayuwa-da. Akina-langwa kembirra nara a-manguma ebina eningilyamarmba ayakwa umba ki-kbajajungwunama ngayuwa,” ni-yama Jekaba-da. ");
INSERT INTO aoi_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Ngalaja yingi-yama dirndenikba, “Ki-kbajajungwuna-manja nungkuwa ningkakina, kembirra nara nungkwa-langwa awurrariya a-ngekburakajungwuma umba ki-kbajajungwunama ngayuwa akina-da. Yirra-makinama ngayuwa ningkakina, umba ku-wilyakina yangkwurrangwa nenukwuda ambilyuma-kiya,” yingi-yama. ");
INSERT INTO aoi_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Eneja kembirra ni-likena nakina Jekaba biya nu-manga ambilyuma nenukwuda akwa nu-wilyaka biya nanga-kwa dirndenikba-wa. Kembirra yingi-daka eningaba wuburra laka ni-lyelyingminuma neningiyadikba akwurara. ");
INSERT INTO aoi_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Biya yingi-likena nanga-manga dumbala dadingaba Yijawa-langwa yinginu-kwa Jekaba-manja akwa n-awiyebena. ");
INSERT INTO aoi_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Kembirra ying-akumarna amakwulya nenukwuda-langwa ebina nu-wardangu-mulangwa Jekaba ena-langwa-manja ayarrka akwa ngawa memirrma-manja ying-akumarna ngarningka. ");
INSERT INTO aoi_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Kembirra na-walyuwa-manja akina amadangkwa yinginu-kwa akina akwa ngawa aninga damba yingi-daka-mulangwa yinginu-kwa. ");
INSERT INTO aoi_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Kembirra enamba-langwa arakba Jekaba ni-likena nakina nungwenikba-wa nu-wilyakama alakina-kiya amadangkwa akwa aninga. Ni-yama nakina Jekaba, “Ngangwa!” ni-yama. “Miyambena?” ni-yama eneja nungwenikba. “Ningkumiyambena ningkakina ningkenikuwarrka?” ");
INSERT INTO aoi_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Eneja ni-yama Jekaba, “Ngayuwe-ka ningena ningenikuwena ningumilyengma ningenungkwulyuba Yijawa. Ebina yi-makama nungkuwa, ningi-yamama arakba. Mirajanga-langwa alyubarina-langwa ena amadangkwa. Ena ningu-wilyakama kajungwa ki-yengbini-yada nungkwa-langwa eningaba ayakwa ebina eningilyamarmba ngayuwa-wa,” ni-yama. ");
INSERT INTO aoi_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Eneja ni-yama neniyerringka, “Nenukwa, ningki-yamarrkama ningkena ningken-akburrangarnuma warenja-bawiya yaka yinungungwangba?” ni-yama. Enamba-langwa ni-yama Jekaba, “Yaweya, nibina Neningikarrawara nungkwa-langwa, nginu-mamurikajuwama nakina kembirra ningen-akburrangarnuma yinungungwangba warenja-bawiya,” ni-yama. ");
INSERT INTO aoi_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Eneja ni-yama Ajika, “Kwa yangkwurrangwa-wiya akwudangwa. Kwureya ka-lyinga-langwa. Ningkakina jerriya amandangwa Yijawa?” ni-yama. ");
INSERT INTO aoi_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Jekaba n-akwudangwukajungwa ena-langwu-wa nungwenikba, kembirra eneja Ajika neni-lyinga. Ni-yama kembirra, “Ningki-yengbina-manja ningkakina ena ayakwa wuburra Jekaba ningki-yaminama akena wuburra Yijawa ne-yaminama ayarrka nungkwa-langwa,” ni-yama. ");
INSERT INTO aoi_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Ajike-ka nakina nenu-ngwarndirranguma Jekaba mena-baba amakwulya-wiya nenukwuda-langwa ayarrka ena-langwa. Wuburra Yijawa-langwa akina ayarrka-da. Neniki-yengbi-yada nakina Ajika ebina ayakwa eningilyamarmba ena-langwa Jekabu-wa ");
INSERT INTO aoi_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","akena ngarningka ni-yama nakina enuwa-wa, “Amandangwa jerriya ningkakina Yijawa?” ni-yama. “Yawa,” eneja ni-yama Jekaba. ");
INSERT INTO aoi_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Enamba-langwa ni-yama Ajika, “Yu-kwa akina ningku-wilyakama amadangkwa. K-alyubarinama adinuba-wiya ningena kembirra ki-yengbinama nganyangwa eningaba ayakwa eningilyamarmba arija-langwa nungkuwa-wa,” ni-yama. Kembirra nenu-kwa Jekaba amadangkwa nungwenikba-wa akwa n-alyubarina. Biya n-angkarna nakina Jekaba akubibeka akwurena-langwa amalyirra akwa ni-bekina nungwenikba. ");
INSERT INTO aoi_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Kembirra ni-yama nungwenikba, “Kwa yangkwurrangwa-wiya yiki-lawurangkini-yada, nenukwa,” ni-yama. ");
INSERT INTO aoi_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Eneja Jekaba ni-rnjirrkwa akwudangwa neniki-lawurangki-yada nungwenikba-wa akena eneja nungwenikba nanga-kirruwanja dumbala Yijawa-langwa dibina n-awiyebenuma Jekaba. Biya kembirra arakba ni-yengbina nakina ebina eningaba ayakwa eningilyamarmba. Ni-yama, “Ningkeningabe-ka ningki-ngbajama ningkenikuwarrka, wuburra laka na-kirruwanjama eningaba akina ajiringka, ebina Yaweya ni-ngekburakama eningaba. ");
INSERT INTO aoi_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Eneja Neningikarrawara kenu-kwuna nungkuwa-wa amidikbalya angubina-langwa. Kembirra ngalaja ka-lungkuwarrina amarda-murriya nungkwa-langwa kajungwa ku-meni-yada aninga-murriya ababurna. Kenu-kwuna ngarningka Neningikarrawara ababurna-langwa amadidira amaninga akwa ngawa ababurna amalyirra akwurena-langwa. ");
INSERT INTO aoi_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Umba aburraja wurruwurrakwulyumida warnumamalya wurriminiminingka kabuminu-war•dena nungkwa-langwa warka. Akwa abi-yamina wurrakina nungkuwa-wa, ‘Ningkaruma ningkenumamalya ningkakina,’ abi-yamina, akwa ab-abuluwendiye-ka nungkuwa-manja wurrakina. Nungkwaje-ka ningkakina ku-bungkawadina nungkwa-langwa-manja warnumamalya kuw-ambilya-murrumanja nungkwa-langwa-manja angalya. Aburramba-langwa ab-abuluwendiya nungkuwa-manja aburrajukwaba. Umba aburraja warningerribirra warnumamalya kabi-kbajina-manja nungkuwa kembirra abi-kbajajungwuna aburruwa aburrajukwaba. Umba ke-yengbina-manja wurrakina eningaba ayakwa nungkuwa-wa, kembirra eningaba abi-ngekburakajajungwuna aburra-langwa aburrajukwaba-da,” ni-yama Ajika Jekabu-wa-da. ");
INSERT INTO aoi_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Kembirra ni-jerrukwama Ajika ena-langwa eningaba ayakwa ebina eningilyamarmba. Eneja kembirra Jekaba neni-lalika arakba nakina nungwenikba-da. Akini-yada ngawa ni-lawurradina eneja Yijawa nawenikba Jekaba-langwa nu-wilyakama yinungungwangba ni-ngaja-mulangwa. ");
INSERT INTO aoi_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Biya ni-dakama enejukwaba yakina yukwurari-yada yinumadangkwa. Biya ni-lyilyanga arakba yukwala yinumadangkwa ni-daka-mulangwa nungwenikba-wa akwa ni-yama, “Ngangwa, yi-yengkilabenuma yinungungwangba akwalya-na? Yaka arakba. Mirajanga-langwa alyubarina-langwa ena amadangkwa. Kembirra yiku-kukwuna eningaba ayakwa eningilyamarmba ngayuwa-wa nungkwa-langwa,” ni-yama. ");
INSERT INTO aoi_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Eneja Ajika ni-yama, “Ningkumiyambena ningkakina?” Enamba-langwa kembirra Yijawa ni-yama, “Ngayuwe-ka ningena ningenikuwena-da ningumilyengma ningenungkwulyuba ngayuwa Yijawa-da,” ni-yama. ");
INSERT INTO aoi_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Kembirra ni-nyakawarriyade-ka eneja neniyuwangkwa Ajika akwa nu-murndumurndaburridanga nakina-da. Ni-yama, “Wurruwilyaba warnumamalya nenu-wardanguma yinungungwangba akwa bi-yikenuma amadangkwa ngayuwa-wa adinuba-wiya nara-wiya ningkibina nungkwaja. Biya ning-alyubarinuma akwa ningarra-kwama akina ayakwa nganyangwa eningilyamarmba arakba-da. Nare-ka ngayuwa a-lawurrakajuma akina ayakwa, umba eningangkawura aburra-langwa ngawa akina-da. Wurrumiyambena wurribina warnumamalya dukwa-da?” ni-yama. ");
INSERT INTO aoi_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Umba eneja nakina Yijawa n-engkirrika-manja akina arakba ayakwa nenak-ar•darra awinyamba. Nu-warduwardemina akwa ni-yama, “Marrakba, ngangwa, yu-kwa-langwa nganjukwaba eningilyamarmba ayakwa eningaba,” ni-yama. ");
INSERT INTO aoi_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Eneja ni-yama Ajika, “Nenikumarnjena ni-likenuma yangkwurrangwa biya ngini-kadikama. Kemba ningenu-kwama arakba nganyangwa ayakwa eningaba ebina eningilyamarmba enuwa-manja. Akina nungkwa-langwa-maka mena ningkumilyengma ningkenungkwulyuba ningkakina akena enuwa-manja arakba nenikumarnjena-manja akina-da,” ni-yama. ");
INSERT INTO aoi_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Enamba-langwa ni-yama Yijawa, “Ningumilyengma ningenungkwulyube-ka ningenikuwena ngayuwe-ka ningena, akena ebina-wiya ngini-kadikama, kembirra wuburra numilyengma nenungkwulyuba nenikuwena enuwa nakina arakba-da. Akwa ena ngarningka aduwaba. Ngayuwa-maka yiku-kwa-maka ebina eningilyamarmba ayakwa eningaba nungkwa-langwa, akena nu-manguma nakina akina ayakwa. Karukwa, ena-langwa arakba akina ayakwa-da. Arngkambilyume-ka ngini-kadikama nakina-da. Amandangwa nenimikirra Jekaba. Marrakba, akina awilyaba ngarningka ayakwa eningaba nganyangwa?” ni-yama Yijawa. Umba akina ekirra Jekaba ne-yaminama “neni-kadikinama wurrukwala-manja.” ");
INSERT INTO aoi_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Eneja ni-yama Ajika, “Ningenu-bungkawakama arakba nakina nungkuwa-manja ngayuwa-da,” ni-yama. “Ningenu-makama nakina ena-langwa warnumamalya kenuminu-war•dena-mulangwa warka ena-langwa. Ningenu-makama ababurna amadidira eninganinga iya amalyirra akwurena-langwa kuw-ambilya-mulangwa ena-langwa. Nara arakba, nenukwa, na-jerriduma ayakwa-da, kembirra nara ebina nungkwa-langwa-da,” ni-yama neniyuwangkwa. ");
INSERT INTO aoi_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Umba neni-yengkiyengkilabena ngawa eneja Yijawa niyirrbiyirrba nakina. “Awilyaba-ma wulkwa akina ayakwa eningaba-na? Umba akina ngarningka eningaba ayakwa nganyangwi-yada? Yu-kwa-langwa marrakba eningaba ayakwa nganjukwaba,” ni-yama. Biya ni-nyakawarriyada akwa nu-ngwadinuma arakba Yijawa. ");
INSERT INTO aoi_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Eneja ni-yama Ajika, “Nara a-larruma amidikbalya angubina-langwa nungkwa-langwu-wa ajiringka. Akwa eninginingaba-ma ajiringka nungkwa-langwa. ");
INSERT INTO aoi_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Umba ningkumarngba awinyamba-langwa k-ambilyama. Aduwaya-wiya kinuminu-war•denama ningkakina nenikumarnjena. Kembirra arija-langwa ki-lyumadinama ningkakina kajungwa nari-yada a-bungkawaduma nakina nungkuwa-manja arakba-da,” ni-yama Ajika nakina-da. ");
INSERT INTO aoi_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Eneja kembirra nakina Yijawa nenu-wirrikbame-ka nenikumarnjenikba Jekabu-wa, mena nungwenikba nenu-kwa-mubaba eningilyamarmba ayakwa eningaba ena-langwa. Ni-yame-ka Yijawa, “Ambaka arngkidarrba nungwarrka kini-jungwunama. Kembirra kini-jungwuna-mulangwa nakina akini-yada ngawa kinu-wardenama nakina nenikumarnjarrka ngayuwa-da,” ni-yama. ");
INSERT INTO aoi_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Umba ngalaja Ribeka ying-engkirrika akina ayakwa. Biya yingin-ardija ngaluwa-wa Jekaba akwa yingi-yama, “Kwuja, naburra. Nawena ngini-ngayindenama kenumini-lawurrakajinama nakina awurrariya nungkwa-langwa akwa kenu-wardenama nungkuwa akina-langwa ningki-yama-mulangwa ningkakina. ");
INSERT INTO aoi_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Engkirraja! Jeyi, likaja Yerenu-wa nganyangwu-wa nawarrka Lebinu-wa, ");
INSERT INTO aoi_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","45","akwa k-ambilya yakwujina enuwa-manja aduwaya-wiya. Eneja kembirra ambaka-murra arija-langwa kini-yakuwabijiyama nawena ebina ningki-yama-mulangwa nungkuwa akwa kinu-werrikuwarruwalyadinama arakba nakina. Akini-yada ngawa ka-larrkiyama ningena wurrukwala nungkuwa-wa biya kabu-lawurrakajinama yangkwurrangwa. Nara-manja a-likama nungkuwa engku-wa, dukwa kinalakina-kiya yikini-jungweyinama muwilyaba-manja ngawa marringa. Biya kembirra nara kinalekbina kinenungkwarba-kiya nganyangwa,” yingi-yama Ribeka Jekabu-wa. ");
INSERT INTO aoi_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Kembirra yingi-likena dakina neningiyadikba-wa Ajiku-wa. Yingi-yama, “Wurrumurndakenena warningiyelakwa wurridarringka nenu-manguma Yijawa ena-langwi-yada wurradidingiyena nare-ka warna ngakwurra-langwa warnumamalya, umba WarningiYida wurridarringka wurrakina. Nganja ning-erriburandiname-ka wurrakina-langwa. Umba kenu-mena-manja enejukwaba Jekaba wurramukwiyadakena ngawa wurridarringka ena-langwi-yada, kembirra amiyambena eningaba nganyangwa?” yingi-yama dakina Ribeka Ajiku-wa-da. ");
INSERT INTO aoi_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Eneja kembirra neniyuwangkwa Ajika nen-ardijuwa Jekaba akwa ni-yama, “Ngeniyerriya, nara a-manguma DadingiKenina didarringka nungkwa-langwi-yada dadingiyena. ");
INSERT INTO aoi_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Umba likaja kembirra akinu-wa emikirra angalya Mejubudamiya nungkwa-langwu-wa nanganjaminjena Beduwela. Biya kinga-mena duwilyaba dadiyara dadingakwujina, dibina Lebina-langwa dadiyawenikba nebena-langwa. ");
INSERT INTO aoi_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Eni-yamina eningaba nungkuwa-manja eneja Neningikarrawara nibina ningbuda-dangwa. Akwa eni-yamina eningaba nungkwa-langwa-manja dadingiyena ngalajukwaba. Akwa kembirra eni-yamina kenu-kwuna nungkuwa-wa wurrababurna wurriyukwayuwa, kajungwa ningkumirarringbi-yada ningkakina wurrilyimberrkwulyumida warnumamalya wurrilyimberrkeyebijeba iya wurrilyimberrkeyebijeba. ");
INSERT INTO aoi_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Eni-yamina eningaba nungkuwa-manja akwa ngarningka numirena-murriya-manja warnikinikaduwa-manja wuburra laka adinuba-wiya ni-yamama nakina Aburiyama-manja. Umba ki-lyingina ningkakina enena angalya ebina nenu-kwamurra Neningikarrawara adinuba-wiya Aburiyama-manja. Ki-lyingina nungkwa-langwi-yada enena angalya ebina-manja ningk-arumidinu-murrumanja akwa ningk-ambilya-murrumanja aduwaba ningkakina-da,” ni-yama Ajika nakina Jekabu-wa-da. ");
INSERT INTO aoi_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Biya kembirra Ajika neni-larrka arakba nakina Jekaba engku-wa angerriba Mejubudamiya-wa n-ambilyu-murruwa nebenikba Lebina. Nakine-ka Lebina nenikuwenikba Beduwela-langwa. Umba eneja Beduwela NeningArama nenumamalya nakina. Umba Lebina ngarningka narrkuwadikba nakina Ribeka-langwa. Umba ngalaja Ribeka dirndarringba Jekaba-langwa iya Yijawa-langwa dakina-da. ");
INSERT INTO aoi_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Eneja kembirra nakine-ka Yijawa n-engkirrika nakina ni-yengbinu-mulangwa Ajika ebina eningilyamarmba ayakwa eningaba Jekabu-wa akwa neni-larrka-mulangwa nakina Jekaba engku-wa Mejubudamiya-wa, kajungwa nenik-aburangki-yada yakwujina duwilyaba dadiyara ena-langwi-yada dadingiyenikba. Akwa neningma ngarningka Ajika-langwa ayakwa ebina nenu-maka-mulangwa Jekabu-wa ni-yengbinu-mulangwa nakina ena-langwa eningaba ayakwa. Eneja ni-yamama nakina, “Nare-ka a-manguma DadingiKenina dadiyara nungkwa-langwi-yada dadingiyena,” ni-yamama neniyuwangkwa Ajika Jekabu-wa-da. ");
INSERT INTO aoi_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","Akwa Yijawa neningma ngarningka nakina Jekaba nenumin-engkirrikenuma nungwenikba-wa akwa dirndenikba-wa akwa ni-likenuma arakba nakina engku-wa Mejubudamiya-wa. ");
INSERT INTO aoi_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Kembirra yadikina Yijawa ni-lyangkumakajungwunuma nungwenikba nara kenumini-ngayindanga wurridarringka WarningiKenina. ");
INSERT INTO aoi_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Kembirra ni-likenuma arakba Yijawa nakina Yijumeyilu-wa kajungwa kininga-meni-yada nakina duwilyaba dadiyara ena-langwa-langwa ngawa warnumamalya ena-langwi-yada dadingiyenikba. Umba eneja Yijumeyila nakina nenikuwenikba Aburiyama-langwa. Kembirra nanga-manguma Yijawa Yijumeyila-langwa dadiyawenikba ena-langwi-yada dadingiyenikba. Dadimikirra dakina Mayalada umba narrkuwadikba Nubeyada nenimikirra nakina. ");
INSERT INTO aoi_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Eneja kembirra nakina Jekaba ni-lalikama akina angalya Biyajiba kajungwa neniki-liki-yada nakina Yerenu-wa. Kembirra ni-likena arakba nakina. ");
INSERT INTO aoi_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Ni-likena ngawa nakina bi...ya num-awiyebu-manja mamawura nu-ngwanja arakba akwa ni-ngekburaka ena-langwa angalya meningalyarrngwalyilyi-yada marringa. Biya nu-kwunumurrkwulinga marringi-yada umba ni-lyangkilyangkirakajungwa angwarnda-murra. Biya nu-mungkwulinga. ");
INSERT INTO aoi_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Kembirra ni-lyangburarrkina arakba akwulyangburarrka. Enena kembirra akwulyangburarrka ena-langwa. Ni-rringkama yakina yerrerra yilingajirra nu-wurdanguma ajiringka-langwa karrawaru-wa yanda-langwa Neningikarrawara-langwu-wa angalya. Kembirra aburraja wurrukwala warnikumamurikaja Neningikarrawara-langwa na-wurdanguma na-dirrirndumurra yakina-manja yerrerra. ");
INSERT INTO aoi_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Kembirra eneja Yaweya n-arjeyumurra akwudangwa Jekaba-manja. Biya ni-yama enuwa-wa, “Ngayuwe-ka ningena Yaweya, Ningeningikarrawara Aburiyama-langwa akwa ngawa Ajika-langwa,” ni-yama. “Yiba-kwunama ngayuwa enena angalya ebina-manja ningku-kwunumurrkwulu-murrumanja ningkakina nungkwa-langwi-yada akwa numirena-murriya warnikinikaduwi-yada,” ni-yama Yaweya Jekabu-wa. ");
INSERT INTO aoi_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","“Wurrakine-ka numirena-murriya warnikinikaduwa nungkwa-langwa kuw-ababurnadinama wuburra laka ajiringka eyukwayuwa ababurna akina. Karri-lyinginama wurrakina enena angalya akwa karr-arumurrkinama akina angerriba iya angerriba aburra-langwi-yada angalya. Ki-yaminame-ka ngayuwa eningaba wurruwurrakwulyumida-manja warnumamalya engkalina-langwa iya engkalina-langwa angalya wuburra laka ningi-yaminama eningaba aduwaba nungkuwa-manja akwa ambaka numirena-murriya-manja. ");
INSERT INTO aoi_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","K-ambilyame-ka ngayuwa akwudangwa nungkuwa-manja akwa yiba-ngwurenama ningkakina ababurna-manja angalya k-ambilya-murrumanja nungkuwa. Kembirra arija-langwa yiba-lawurrakajinama ngayuwa ningkakina ambaka ngarningka enenu-wa angalya. Nare-ka ngayuwa a-lalikama nungkuwa umba ki-jerrukwunama ababurna-langwa yirra-makama arakba ngayuwa nungkuwa-manja,” ni-yama Yaweya Jekabu-wa-da. ");
INSERT INTO aoi_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Kembirra nu-mirajanga arakba eneja Jekaba akwa ni-lyelyimbukwajungwuna nakina. Ni-yama, “Yaweya naka yelakwa enena-manja angalya ningeningbala-na!” ni-yama. ");
INSERT INTO aoi_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Biya n-akbar•da akwa ni-yama, “Enene-ka angalya angkakbar•duwar•da amarngilyarra! Neningikarrawara-langwa-bina ena angalya dukwa-da. Enena-bina na-ngwurrkbalinama akawiyuwiyeba karrawaru-wa Neningikarrawara-langwu-wa angalya-da,” ni-yama nakina-da. ");
INSERT INTO aoi_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Biya kembirra mingka-manja meninguwurdarriya-wiya mamawura Jekaba nu-mirajanga nakina akwa nu-manga angwarnda ebina nu-mingekirakirakajungwunuma aringka-manja akwa n-arjiyajuwa akina yakwujina kajungwa wurrukwala warnumamalya warningmi-yada Yaweya n-abilyerrikajungwunuma nakina yakwujina. Kembirra ni-jiraba amalyirra aliba akina-manja angwarnda kajungwa Neningikarrawara-langwi-yada akina arakba. ");
INSERT INTO aoi_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Biya ni-yengbijuwama angalya Bedela, mena akina ekirra Bedela ne-yaminama “alikira Neningikarrawara-langwa.” Akena ngalaja angalya aminababurna alikira iya warnumamalya ebina akwudangwa nuw-ambilyumurra akina emikirra adinuba-wiya Luja. ");
INSERT INTO aoi_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Biya kembirra nakina Jekaba ni-yarrkakumarna ayakwa Yaweya-langwa. Ni-yama enuwa-wa, “K-ambilya-manja ningkakina ngayuwa-manja akwudangwa akwa yiku-ngwurena-manja lukwakwa ningkakina akwa yiku-kwuna-manja aninga-murriya akwa dumbala-murriya ngayuwa-wa, ");
INSERT INTO aoi_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","biya ki-lawurradina-manja ngayuwa nungwarrka-langwu-wa angalya ningingkinyungwurra, kembirra nungkuwa Yaweya nganyangwa Ningkeningikarrawara ningkakina-da,” ni-yama Jekaba nakina Yaweyu-wa. ");
INSERT INTO aoi_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Biya ni-yama ngarningka enuwa-wa, “Enene-ka angwarnda yelakwa ning-arjiyajuwama ngayuwa aduwaba kajungwa ki-yakuwerribikini-yada ngayuwa nungkuwa-wa. Kembirra enena-manja-bina angalya aburraja warnumamalya kabi-yangmarngkwajini-yada wurrakina nungkuwa-wa. Umba yiku-kwuna-manja ningkakina ememberrkwa bulukwa ngayuwa-wa kembirra ki-lawurrakajinama ngayuwa awilyaba nungkuwa-wa yiba-kwunama. Akwa yiku-kwuna-manja nungkuwa eningerribirra ememberrkwa ngayuwa-wa, kembirra ki-lawurrakajini-yada ngayuwa awilyaba-ma ngawa nungkuwa-wa. Ki-yaminjaminama ngawa arngkababurna-langwa ngayuwa-da,” ni-yama Jekaba nakina Yaweyu-wa-da. ");
INSERT INTO aoi_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Biya kembirra Jekaba nu-warumajungwa akwa nu-makirukbijangajuwa angalya akwa ni-likena alyengmu-wa. N-alilikenu...wa. ");
INSERT INTO aoi_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","3","Biya akwudangwa arakba nebenikba-langwa angalya. Biya neningbala-wiya emedirra akungwa adirrariyaba n-akburranga nakina erriberriba-manja ngawa. Aburraja wurruminakina angalya warnikakukwurrajungwa jiba warnumamalya narru-wilyuwilyakama aburra-langwa jiba yenjerrikina akungwa-wa. Mababurna-langwa meningilarruwura mamawura narru-wilyuwilyakama amurndakakina akinu-wa emedirra akungwa akena namin-akwurrajeyinuma wurrakina. Narruwurra-murndukwama ababurna-langwa jiba adinuba-wiya biya kembirra arija-langwa narri-rnjirrkwajuwama adirrungwarna angwarnda ebina na-didanguma edirra. Biya narr-akarrngarnuma akungwa, narri-lyangburrukwajuwama akungwa amurndakakina angarumungkwa angwarnda ebina nuw-ambilyuma akwudangwa akwa narri-bekajuwama amurndakibina jiba. Kembirra ne-bekeyinu-mulangwa jiba akungwa narruwurraki-didanguma emedirra arakba ebina-murra angwarnda. Ne-yaminjamama wurruminakina angalya warnumamalya warningangkawura wurrakina. Ni-yar•du-manja arakba nakina Jekaba yakwujina emedirra-manja akungwa ngalaja jiba akwudangwa nuw-angmungmakayanguma akina. Awurrakabiyakarbiya jiba amurndakakina akena na-didijungwunuma ambaka emedirra akungwa. ");
INSERT INTO aoi_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Kembirra Jekaba ni-yama nakina wurrukwalu-wa warnikakukwurrajungwa jiba, “Ngamba-langwa karna?” ni-yama. “Yerena-langwa,” aburraja ne-yama. ");
INSERT INTO aoi_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","“Karningma Lebina numirenikba Neyawa-langwa?” ni-yama eneja Jekaba. Ne-yama aburraja, “Yawu.” ");
INSERT INTO aoi_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","“Neningaba nakina?” ni-yama enamba-langwa. “Neningaba,” aburraja ne-yama. “Kwuja! Dubukwaya dadiyawenikba Rejila, dibina ying-akwurrajinama jiba ena-langwa. Yingu-wilyakinama jiba akungwa-wa,” ne-yama. ");
INSERT INTO aoi_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Ni-yama eneja Jekaba aburruwa-wa, “Maruma ambaka mamawura, kembirra nara ambaka karna awiyebajuma jiba nungkwurra-langwa arrawu-wa. Mena-burra nara e-bekajuma jiba akwa a-lawurrakajuma ngarningka amardu-wa?” ni-yama. ");
INSERT INTO aoi_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Aburraja ne-yama, “Nara. Yirr-ambilyama ambaka yirr-embirrarinama akwalu-wa jiba. Nara yarna a-rnjirrkwajuma angwarnda yanda-langwa kamurndaki-yar•diyama ababurna-langwa jiba. Kamurndaki-yar•diya-manja kembirra akina, yiki-rnjirrkwajinama yarna angaba angwarnda, akwa yiki-bekajinama jiba akungwa-da,” ne-yama. ");
INSERT INTO aoi_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Na-lyelyimbukweyinu-wiya ngawa Jekaba akwa wurrumurndakakina warnumamalya, ngalaja Rejila yingi-yar•da yakwujina yingu-wilyakama jiba nungwadikba-langwa. ");
INSERT INTO aoi_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Umba nanga-rringka-manja eneja nakina Jekaba Rejila akwa nebenikba-langwa jiba, ni-likena nakina emedirra-wa akungwa. Ni-rnjirrkwaja ebina angwarnda akwa ni-bekajuwa akungwa amurndakakina jiba. ");
INSERT INTO aoi_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Biya nanga-lawurangka Rejila akwa nu-ngwadina angwada niyekirrerra-baba nakina. ");
INSERT INTO aoi_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Ni-yama ngaluwa-wa, “Ngayuwe-ka ningena nungwena-langwa ningaburrenikba. Dirndirrka Ribeka nganyangwa,” ni-yama. Kembirra ngalaja Rejila ying-angkarra yingi-lawurrada angalyu-wa akwa yinginu-maka nungwadikba Lebinu-wa. ");
INSERT INTO aoi_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","N-engkirrika-manja eneja nakina Lebina ayakwa naburrenikba-langwa Jekaba-langwa, n-angkarrina nakina akwa nenu-kwurukwa naburrenikba-wa. Nen-akburranga-manja nen-engkarrnga neni-lawurangka akwa nenu-wilyaka angalyu-wa, nen-awiyebajuwa alikira-wa. Kembirra eneja nakina Jekaba nenu-maka Lebinu-wa amurndakibina-langwa ne-yama-mulangwa akina. ");
INSERT INTO aoi_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Ni-yama eneja Lebina, “Yawe-ka, ningkena nganyangwa ningkenumamalya-da,” ni-yama. Kembirra eneja Jekaba n-ambilyuma nakina yakwujina yuwilyaba yimawura-da. Bi...ya ni-jerridu-manja yimawura, ");
INSERT INTO aoi_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","eneja nakina Lebina ni-yama Jekabu-wa, “Nare-ka aminu-war•duma ningkakina erribirra warka nganyangwa, nganyangwa-baba ningkaburraka. Amiyambena kembirra angwarnda yiba-kwunama?” ni-yama. ");
INSERT INTO aoi_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Umba Lebina-langwa wurringambilyuma wurradingabulena, duwilyaba daruma-dangwa dadimikirra Liya umba duwilyaba diyukwujiya dadimikirra Rejila dakina. ");
INSERT INTO aoi_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Dakine-ka Liya meningaba menba ngala-langwa umba ngalaja Rejila dadingaba dadumebinga. Dukwulyubene-ka dakina-da. ");
INSERT INTO aoi_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Eneja nakine-ka Jekaba ni-lyelyingminuma Rejila, nanga-ngayindanguma. Kembirra ni-yama Lebinu-wa, “Yibaminu-war•denama ngayuwa warka nungkwa-langwa mamangbala mambilyuma mamarika iya yinungkwura, kemba yiku-kwuna Rejila nganyangwi-yada dadingiyarrka,” ni-yama. ");
INSERT INTO aoi_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Eneja ni-yama Lebina, “Nara wurrukwala-manja a-ngayinduma a-kwama dakina umba nungkuwa-manja yiba-kwunama. Eningaba akina. Ambilya kembirra ngayuwa-manja,” ni-yama. ");
INSERT INTO aoi_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Eneja kembirra Jekaba n-ambilyuma nakina nu-war•danguma warka yakwujina Lebina-manja. N-ambambilyu...wa. Mamangbale-ka mambilyuma mamarika iya yinungkwura n-ambilyumurra nu-war•duwar•dangumurra nakina kajungwa kininga-meni-yada Rejila dadingiyenikbi-yada. Nu-war•duwar•danga ngawu...wa, akena arngkidarrba ni-lyangkiyama nakina mena nanga-ngayindangu-mubabe-ka angwurra dakina Rejila-da. ");
INSERT INTO aoi_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Biya kembirra arakba Jekaba nenu-makama ayakwa Lebina-manja akwa ni-yama, “Mamangbala mambilyuma mamarika iya yinungkwura numi-jerriduma akwa ni-jerriduma arakba,” ni-yama. “Yu-kwune-ka dadiyawena nungkwa-langwa,” ni-yama. ");
INSERT INTO aoi_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Kembirra ababurna aninga ni-larrngkwaburranga eneja nakina Lebina akwa warnumamalya nenu-murndukwama warnik-alyubari-yada aninga enuwa-manja. Aburraja nawurraki-likena kembirra enuwa-wa aninga-wa wurrakina. ");
INSERT INTO aoi_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Akena makini-yada ngawa meningalyarrngwalyilya marringa eneja Lebina nara kininga-lyilyanga Rejila Jekabu-wa umba nanga-lyilyanga nakina ena-langwa dadiyawenikba dumilyengma Liya-da. Kembirra aburnaja arakba Jekaba akwa Liya nenu-mungkwula wunalakina-da. ");
INSERT INTO aoi_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Kembirra eneja nakina Lebina nanga-kwama dadikuminuwar•duwar•da didarringka ena-langwa dadimikirra Jilba dadiyawenikba-wa Liya-wa kajungwa kingingaminu-war•deni-yada warka ngala-langwa. ");
INSERT INTO aoi_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Akena neningbale-ka Jekaba Liya-manja nu-mungkwuluma alyarrngwalyilya umba mingka-manja kembirra neningma arakba. Kembirra ni-likena Lebinu-wa. Ni-yama, “Ningki-yamarrkamurra-burra ngayuwa-manja?” ni-yama. “Ningu-war•danguma aruma warka kajungwa kinga-mangi-yada Rejila akena yi-kadikama ngayuwa ningkakina-da,” ni-yama nakina Jekaba. ");
INSERT INTO aoi_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Eneja ni-yama Lebina, “Nara ambaka a-kwama ngayuwa diyukwujiya-dangwa Rejila umba daruma-dangwa adinuba-wiya Liya nungkwa-langwa arakba mena yirri-yaminjaminama yarna yarnumamalya yirra-langwa-manja angalya. ");
INSERT INTO aoi_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Ambaka embirrarina-langwa. Mamangbala mambilyuma mamawura yikingi-yakeyinama Liya-manja kuw-ambilya-manja warna warnumamalya ngakwurra-langwa yelakwa ngakwurruwa. Yikuminu-war•dena-manja ningkakina warka ambaka mamangbala mambilyuma ngarningka mamarika iya yinungkwura, kembirra arija-langwa yiba-kwunama daka Rejila nungkuwa-wa,” ni-yama Lebina. ");
INSERT INTO aoi_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Eneja Jekaba ni-lyangkuwama nakina. Biya neni-yakeyina arakba ngarningka wunalakina Jekaba iya Liya mamangbala mambilyuma mamawura. Bi...ya kembirra arija-langwa eneja nakina Lebina nenu-kwa arakba Rejila Jekabu-wa dadingiyenikbi-yada. ");
INSERT INTO aoi_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Akwa nanga-kwama nakina dadikuminuwar•duwar•da didarringka ena-langwa dadimikirra Bilya dadiyawenikba-wa Rejilu-wa kajungwa kingingaminu-war•deni-yada warka ngala-langwa. ");
INSERT INTO aoi_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Kembirra aburnaja arakba Jekaba akwa Rejila nenu-mungkwula wunalakina. Umba Jekaba ni-lyelyingminuma Liya-manja yandiyanda umba Rejila-manja ni-lyelyingminuma angwurre-ka nakina-da. Biya nenuminu-war•duwar•danguma ngarningka Lebina-langwa warka mamangbala mambilyuma mamarika iya yinungkwura arakba-da. ");
INSERT INTO aoi_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Eneja nakina Yaweya neni-rringka nakine-ka Jekaba ni-lyelyingminuma Rejila angwurra, kembirra nanga-kwama wurriyukwayuwa Liya-manja umba ngalaja Rejila dadingarijira-ma ambaka duburubura ngawa ying-ambilyuma. ");
INSERT INTO aoi_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Umba ngalaja Liya yingu-mambakinuma wurrangariya ngala-langwi-yada. Biya kembirra yingin-arrangba niyukwujiya. Yingi-yama, “Yaweya ni-rringkama arakba awerrikawarriya nganyangwa. Kembirra neningiyarrka kini-lyelyingminama ngayuwa arakba-da,” yingi-yama. Aminakina-langwa Liya yingini-yengbijuwama Rubina nenimikirra, mena akina ekirra Rubina ne-yaminama “kwuja, naka nenungkwarba.” ");
INSERT INTO aoi_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Biya yingu-mambakinuma Liya ngarningka wurrangariya. Kembirra yingin-arrangba niyukwujiya ngarningka naburradikba. Yingi-yama, “Yaweya nginu-kwama naka naburraka, mena n-engkirrikenu-mubaba nakina nara ngayuwa-manja a-lyelyingmama neningiyarrka,” yingi-yama. Biya aminakina-langwa Liya yingini-yengbijuwama Jimiyina nenimikirra, mena akina ekirra Jimiyina ne-yaminama “nibina n-engkirrikama.” ");
INSERT INTO aoi_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Biya yingu-mambakinuma Liya ngarningka wurrangariya. Kembirra arakba ngarningka yingin-arrangba niyukwujiya naburradikba. Yingi-yama, “Arakba wurrabiyakarbiya wurriyukwayuwa warnungkwarba ningenumin-arrangbama neningiyarrka,” yingi-yama. “Nara kembirra nakina a-larrkama ngayuwa engku-wa umba ngayuwa-manja ngawa angwurra kini-lyinginama,” yingi-yama Liya. Kembirra aminakina-langwa yingini-yengbijuwama Libaya nenimikirra, mena akina ekirra Libaya ne-yaminama “nanga-lyinginama.” ");
INSERT INTO aoi_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Biya yingu-mambakinuma Liya ngarningka wurrangariya. Kembirra yingin-arrangba ngarningka niyukwujiya naburradikba. Yingi-yama, “Enena-manja arakba kini-yangmarngkwajinama ngayuwa Yaweyu-wa,” yingi-yama. Kembirra aminakina-langwa Liya yingini-yengbijuwama Juda nenimikirra, mena akina ekirra Juda ne-yaminama “kini-yangmarngkwajinama.” Biya kembirra nara arakba karring-arrangba wurriyukwayuwa Liya dakina-da. ");
INSERT INTO aoi_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Nare-ka wurribina wurriyukwayuwa Rejila-langwa, umba duburubura ngawa ying-ambilyumurra dakina. Kembirra yingi-yakwujaminuma dakina diyabadikba-wa Liya-wa. Biya kembirra yingi-yama dakina Jekabu-wa, “Nara-manja nungkuwa a-kwama wurriyukwayuwa ngayuwa-wa kembirra ki-jungwunama,” yingi-yama. ");
INSERT INTO aoi_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Kembirra eneja Jekaba n-awinyambade-ka nakina ngaluwa-wa. Ni-yama, “Neningikarraware-ka nakina-bina-baba-da ngini-lyangmurukwuna-mubaba ningkakina, kembirra nara ningkena arrangbama wurrangariya-da. Nare-ka ngayuwa ningena Ningeningikarrawara,” ni-yama Jekaba. ");
INSERT INTO aoi_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Ngalamba-langwa yingi-yama Rejila dakina, “Daka Bilya dadikuminuwar•duwar•da nganyangwa. Yikingu-mungkwula kirringalakina, kajungwa wurriyukwayuwa kangumin-arrangbini-yada nganyangwa. Kemba wurrababurna wurriyukwayuwa naburraka-murriya akwa nenikabijarrka-murriya nganyangwa,” yingi-yama Rejila. ");
INSERT INTO aoi_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Kembirra yinginu-kwa Bilya Jekabu-wa ena-langwi-yada dadingiyenikba. Eneja kembirra nu-mungkwuluma ngaluwa-manja nakina Jekaba. ");
INSERT INTO aoi_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Kembirra arakba ngalaja Bilya dakina yingu-mambakinuma wurrangariya. Kembirra yinginumin-arrangba arakba dakina nenikuwenikba Jekaba-langwa. ");
INSERT INTO aoi_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Ngalaja yingi-yama Rejila, “Neningikarraware-ka nakina ni-lyangkuwerribikajungwunuma yalakena-kiya-langwa yenumamalya-kiya akwa nginu-werrungwur•denama ningena-da. N-engkirrikenume-ka nganyangwa ayakwa ebina ningi-yengbinuma ningeni-yengkilabenuma, biya nginu-kwama kembirra naburraka-da,” yingi-yama dakina. Yadikina kembirra nenimikirra yingini-yengbijuwama Dena, mena akina ekirra Dena ne-yaminama “ni-lyangkuwerribikajungwunuma.” ");
INSERT INTO aoi_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Kembirra ngalaja dakina Bilya yingu-mambakinuma ngarningka wurrangariya. Kembirra yinginumin-arrangba arakba dakina nenikuwenikba Jekaba-langwa. ");
INSERT INTO aoi_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Yingi-yama ngalaja Rejila, “Yirringuwa yirringi-kuwurriyinuma diyabarrka akena ngayuwa angwurra ningarrubuda.” Biya nenimikirra yingini-yengbijuwama Rejila Nabudali, mena akina ekirra Nabudali ne-yaminama “yirringi-kuwurriyinuma.” ");
INSERT INTO aoi_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Ngalaja Liya dadingma arakba nari-yada arrangbama wurrangariya biya yinginu-kwama Jilba dadikuminuwar•duwar•da ngala-langwa Jekabu-wa ena-langwi-yada didarringka. ");
INSERT INTO aoi_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Kembirra yinginumin-arrangba ngalaja Jilba nenikuwenikba Jekaba-langwa. ");
INSERT INTO aoi_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Yingi-yama ngalaja Liya, “Eningaba na-ngekburakajungwuma nganyangwa,” yingi-yama. Yadikina yingini-yengbijuwama Keda nenimikirra, mena akina ekirra Keda ne-yaminama “eningaba na-ngekburakajungwuma.” ");
INSERT INTO aoi_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Kembirra nuwilyaba ngarningka nenikuwenikba Jekaba-langwa yinginumin-arrangba ngalaja dakina Jilba. ");
INSERT INTO aoi_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Yingi-yama ngalaja Liya, “Ningu-werrikilyelyingminama ningena ngayuwa. Aburraja wurridarringke-ka ke-yaminama wurrakina, ‘Diyekirrerra daka didarringka-da,’ ke-yaminama ngayuwa-langwa-da.” Yadikina yingini-yengbijuwama Ajera nenimikirra, mena akina ekirra Ajera ne-yaminama “akwiyekirrerra.” ");
INSERT INTO aoi_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Kembirra narruwurra-murndukwa-manja wurruminakina angalya warnumamalya amarda aninga-ma ebina narri-lungkuwabijuwa-mulangwa wurrakina, akini-yada ngawa eneja nakina Rubina num-akburranga nakina mamaninga memikirra mendireka yakwujina na-war•duwar•dangu-murrumanja. Numa-manga mukwala biya numa-wilyaka makina dirndenikba-wa Liya-wa. Akena ngalaja Rejila yingi-yama dakina Liya-wa, “Yu-kwa-langwa nganja mukwala mendireka num-akburrangarnuma naburrena,” yingi-yama. ");
INSERT INTO aoi_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Ngalaja yingi-yama Liya, “Yiminu-wilyakama arakba nakina nganyangwa neningiyarrka-na! Umba dukwa yibaminu-wilyakinama kemba ngalajukwaba mendireka naburraka-langwa dukwa-da?” yingi-yama. Umba ngalaja yingi-yama Rejila, “Yiku-kwa-manja ngayuwa-wa mukwala mendireka, kembirra ningkakina yikinu-mungkwulama kinalakina yakwa-langwa neningiyarrka memema-manja marringa,” yingi-yama. Akina-manje-ka angalya na-lyangkiyamama wurruminakina angalya kuw-alyubarina-manja wurridarringka makina mamaninga mendireka kembirra ka-mambakinama wurrakina wurrangariya. ");
INSERT INTO aoi_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Num-awiyebu-manja mamawura, ni-lawurradu-manja angaluba Jekaba na-lungkuwarrinu-mulangwa ebina amarda amaninga, ngalaja Liya yinginuminu-wengkarrngarna yingi-likena. Kembirra yingi-yama enuwa-wa, “Yaku-mungkwulama yakuwa, yaki-yakeyinama aduwaba,” yingi-yama. “Ngayuwa ninginga-kwama mukwala mendireka Rejilu-wa aduwaba. Kembirra mendireka-murra ningu-beyindanguma nungkuwa ningkakina-da,” yingi-yama Liya Jekabu-wa-da. Kembirra makina-manja ngawa meningalyarrngwalyilya marringa nenu-mungkwula arakba aburnuwa Liya akwa Jekaba wunalakina-da. ");
INSERT INTO aoi_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Eneja nakine-ka Neningikarrawara nangamin-engkirrikenuma ayakwa Liya-langwa yingini-yengkilabenuma ebina. Biya kembirra arakba yingu-mambakinuma wurrangariya. Biya arakba Jekaba-langwa nenikuwenikba ngarningka yingin-arrangba dakina Liya. Wurrumangbala warnungkwarba arakba ngala-langwa warijira. ");
INSERT INTO aoi_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Yingi-yama, “Ngayuwa-manje-ka Neningikarrawara nu-marngkirradinuma arakba mena dadikuminuwar•duwar•da nganyangwa ningenu-kwa-mubaba neningiyarrku-wa,” yingi-yama Liya. Kembirra nenimikirra yingini-yengbijuwama dakina Yijakara, mena akina ekirra Yijakara ne-yaminama “ningu-beyindanguma nakina.” ");
INSERT INTO aoi_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Biya kembirra arakba ngarningka yingu-mambakinuma Liya wurrangariya. Kembirra yinginumin-arrangba niyukwujiya Jekaba-langwa. Wurrumangbala wurruwilyaba wurrabuburrada ngala-langwa arakba. ");
INSERT INTO aoi_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Yingi-yama, “Neningikarraware-ka nginu-kwama naka niyukwujiya neningilarrngekburna. Kembirra kenu-werrungwur•denama ngayuwa neningiyarrka, mena wurrumangbala wurruwilyaba warninikuwena ningenumin-arrangbama arakba ngayuwa,” yingi-yama. Kembirra nenimikirra yingini-yengbijuwama Jebulina, mena akina ekirra Jebulina ne-yaminama “nginu-werrungwur•danguma.” ");
INSERT INTO aoi_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Bi...ya ambaka-murra nang-arrangbama Liya daburradikba biya nanga-yengbijuwama Dayina dadimikirra. ");
INSERT INTO aoi_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Umba eneja nakine-ka Neningikarrawara nara kini-yakuwabija Rejila umba ni-yakuwerribikama ngaluwa-wa akwa ebinu-wa ayakwa yingu-buriyama-murruwa dakina, akwa nanga-kwama wurrangariya ngaluwa-wa. ");
INSERT INTO aoi_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Ngalaja arakba Rejila yingu-mambakinuma ngalajukwaba wurrangariya. Kembirra yingin-arrangba naburradikba. Yingi-yama, “Ningi-yeliyangume-ka ningena akena nara arakba ngi-yeliyuma ngayuwa aduwaba mena Neningikarrawara-baba nginu-kwama naka nangariya nganyangwa. ");
INSERT INTO aoi_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Dukwa Yaweya kenu-kwunama ngayuwa naburraka ngarningka nuwilyaba dukwa-da,” yingi-yama dakina Rejila. Kembirra nenimikirra yingini-yengbijuwama Jawijiba, mena akina ekirra Jawijiba ne-yaminama “nuwilyaba ngarningka kenu-kwunama.” ");
INSERT INTO aoi_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Ni-rukwularru-mulangwa nangariya Jawijiba eneja kembirra nakina Jekaba ni-yama Lebinu-wa, “Ngi-likaja arakba yi-larrkiya,” ni-yama, “kajungwa ki-lawurradini-yada arakba ngayuwa nganyangwu-wa angalya. ");
INSERT INTO aoi_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Ningu-war•danguma warka nungkwa-langwa, kemba yiku-kwuna dadingiyarrka-murriya akwa nganyangwa wurriyukwayuwa yiki-likaji-yada yirrababurna-langwa. Arume-ka warka yirraminu-war•danguma ningkeningme-ka,” ni-yama. ");
INSERT INTO aoi_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Eneja Lebina ni-yama, “Yirra-ngayindenama nungkuwa k-ambilyama. Ning-aburangkama ngayuwa, kembirra ning-eningmidinume-ka Yaweya ni-yamama eningaba ngayuwa-manja mena nungkuwa ningk-ambilyuma yelakwa ngayuwa-manja. ");
INSERT INTO aoi_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Yiminu-war•dangu-mulangwa warka nganyangwa, kembirra wi-yengbijina arakba angwarnda kajungwa yiba-kwuni-yada. Ambarrngarna angwarnda ningki-ngayindena nungkuwa?” ni-yama. ");
INSERT INTO aoi_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Eneja Jekaba ni-yama, “Ningkakakiruma ngayuwa alyangmandukwuna warka yirraminu-war•danguma nungkwa-langwa. Yirramin-akwurrajuwama jiba iya nenukwuda nungkwa-langwa ambaka-langwa. ");
INSERT INTO aoi_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Nara-wiya ki-likena ngayuwa yangkwurrangwa nungkuwa-wa ambawura jiba iya nenukwuda nungkwa-langwa umba aduwaba ababurna arakba. Eneja Yaweya ni-yamama eningaba nungkuwa-manja ababurna-manja angalya nungkwa-langwa-manja ningi-likenu-murrumanja ngayuwa. Umba aduwaba-langwa ngayuwa ningi-ngayindenama ku-war•denama nganyangwa warka,” ni-yama Jekaba. ");
INSERT INTO aoi_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","33","“Kemba amiyambena ngayuwa yiba-kwunama nungkuwa-wa?” eneja ni-yama Lebina. Ni-yama Jekaba, “Nare-ka ningena a-ngayinduma angwarnda. Ngi-likajama ningena ngayuwa biya ku-menama eyukwayuwa jiba amurndakibina amurrumurrijungwa akwa ngarningka ku-menama eyukwayuwa nenukwuda akuminjiminjidadijungwa. Amurndakakina ku-wilyakinama, umba nara akwala. Aduwaba-langwa k-eningmidinama ningkakina ningilyangmandukwuna-murrikba ngayuwa. K-andiya-manja ningkakina akwa ki-rringkina-manja nganyangwa nenukwuda eningakuminjiminjidadijungwa-ma akwa jiba eningumurrijungwa-ma, kembirra ningkeningma ningkakina k-angmadama amurndakakina. Ki-lyangkuwamina-manja ningkakina ki-yamina-manja, ‘Eningaba akina,’ kembirra ngayuwa k-akwurrajinama ngawa jiba iya nenukwuda nungkwa-langwa,” ni-yama Jekaba Lebinu-wa. ");
INSERT INTO aoi_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","“Yawa,” eneja ni-yama Lebina. “Akina-bina eningaba-da.” ");
INSERT INTO aoi_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Akena makini-yada ngawa mamawura Lebina nu-manga enungkwarba nenukwuda akerrikirrikarrngajungwa akwa akuminjiminjidadijungwa akwa ngawa adarringka amurndakibina akuminjiminjidadijungwa akwa ngawa awarrngkukwulyadada akwala. Ngalajukwaba amurrumurrijungwa jiba nu-manguma nakina. Kembirra nenu-kwa nakina warninikuwenu-wa kajungwa karr-embirrajini-yada amurndakakina. ");
INSERT INTO aoi_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Biya Lebina-murriya neni-lalika arakba Jekaba wurrakina, narru-wilyakama jiba iya nenukwuda Lebina-langwa, biya engku-we-ka na-likenuma arakba. Bi...ya mabiyakarbiya-manja marringa narri-ngekburaka angalya aburra-langwa akwa yakwujina ngawa nuw-ambilyuma-da. Umba eneja akwala jiba iya nenukwuda n-embirrajuwama Jekaba nakina ngawa-da. ");
INSERT INTO aoi_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Biya kembirra Jekaba n-arndurrkwarrngarna amawarruwalya eka engkalya biya n-alkuwayijuwa akwala amakwulya kajungwa kini-rringkini-yada ebina arrawa-dangwa akwulyadada. Kembirra ni-rringka-manja nakina amurndakakina wuburra akerrikirrikarrngajungwa ne-yamama akina. ");
INSERT INTO aoi_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","40","Biya nu-wilyakama nakina amurndakakina amawarruwalya eka emedirra-wa akungwa ni-bekajuwa-murruwa nakina amurndakibina jiba iya nenukwuda ena-langwa. Akwa n-arjiyajuwama amurndakakina amawarruwalya eka amurndakibina-manja angarumungkwa angwarnda eningakungwa arrawa, kajungwa ka-likaja-manja amurndakakina akungwa-wa, kembirra kuw-arndurrkwarjiyi-yada akina arrangmarra-langwa jiba-langwa-langwa akwa ngawa nenukwuda-langwa-langwa. Yakwujina ngawa n-akumarnuma Jekaba mena amurndakakina enungkwarba akwa adarringka na-rndirrkeyinuma yakwujina akungwa-manja. Kembirra na-rndirrkeyinu-manja akina, ngalaja amawarruwalya eka nuw-arndurrkwarjeyuma arrangmarra-langwa amurndakakina-langwa-langwa. Kembirra ngarningka ngalaja nuw-andiyinga amurndakakina enungkwarba akwa adarringka angerriba Lebina-langwu-wa jiba iya nenukwuda ebina amurrijungwu-wa akwa akerrikirrikarrngajungwu-wa, ebina nu-mangu-murruwa adinuba-wiya Lebina. Na-rndirrkeyinu-manja akina arrangmarra-langwa-langwa amawarruwalya eka, kembirra ambaka-murra angaringariya nuw-arrangbama akerrikirrikarrngajungwa akwa ngawa akuminjiminjidadijungwa akina. Umba eneja eyukwayuwa angaringariya eyebijeba n-akumarnuma nakina. Akwa ena-langwa jiba iya nenukwuda ababurna-langwa n-akwurrajuwama nakina Jekaba awurrakawura-ma awilyaba-manja angalya, umba amurndakibina Lebina-langwa n-akwurrajuwama nakina eyebijeba ngawa engka-manja angalya-da. ");
INSERT INTO aoi_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Biya akini-yada ngawa na-rndirrkeyinu-manja jiba iya nenukwuda ebina engmurra-murruwiya, n-akumarnuma Jekaba ebina amawarruwalya eka arrangmarra-langwa amurndakakina-langwa-langwa jiba iya nenukwuda kajungwa ka-rndirrkeyini-yada yakwujina amawarruwalya-manja eka akina. ");
INSERT INTO aoi_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Akena nara kin-arndurrkwarjiyajuwa ebina amawarruwalya eka yakwujina angarumungkwa-manja angwarnda eningakungwa amurndakayuwaya-langwa ebina jiba iya nenukwuda. Yadikina adinuba ngalaja Lebina-langwa jiba iya nenukwuda amurndakayuwaya-wiya akina umba Jekaba-langwa engmingmurra-murruwiya akina-da. ");
INSERT INTO aoi_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Yadikina eneja Jekaba nakina arakba numinababurne-ka jiba iya nenukwuda iya kamila iya dangki iya warnikuminuwar•duwar•da warnumamalya nakina-da. ");
INSERT INTO aoi_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Bi...ya kembirra n-engkirrikama Jekaba ayakwa Lebina-langwa warninikuwena nenumini-lyelyimbukweyinuma neni-yarrumurnduwarnuma ena-langwa-langwa wurrakina. Ne-yama, “Jekabe-ka nakina ni-larrngkuwilyakama ababurna-langwe-ka amurndakijika ngakwurra-langwa-langwa nungwanyungwa. Numinababurne-ka amurndakijika nakina aduwaba, umba nungwanyungwa-langwa adinuba-wiya ababurna-langwa akina-da,” ne-yama. ");
INSERT INTO aoi_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Akwa ngarningka Jekaba neni-rringkama nakina Lebina nara kenu-werrikumarrngbijuwa nibina ni-yaminjama-murrada adinuba-wiya. ");
INSERT INTO aoi_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Kembirra ni-yama eneja Yaweya enuwa-wa, “Jeyi! Lawurradina nungwena-langwu-wa angalya akwa nungkwa-langwu-wa warnumamalya. Nganja nungkuwa-manja ki-likajama ngayuwa,” ni-yama. ");
INSERT INTO aoi_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Eneja kembirra Jekaba ni-larrka ayakwa wurringalakina-kiya-wa wurringidarringka-kiya-wa Rejilu-wa akwa Liya-wa biya narringi-likena akwa narringin-akburranga nakina ebina-manja angalya nuw-ambilyu-murrumanja ena-langwa jiba iya nenukwuda-murriya. ");
INSERT INTO aoi_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Ni-yama Jekaba wurringalakina-kiya-wa, “Ngayuwa ningenu-mumiringkama nungkwurringa-langwa nungwenungwa nara kenu-werrikumarrngbijuwa wuburra adinuba-wiya nginu-werrikumarrngbijuwa nakina. Akena eneja nungwarrka-langwa Neningikarrawara ngayuwa-manja n-ambilyumurra nakina yanda-langwa aduwaba akwa ngayuwa-manja n-ambilyama nakina ngawa. ");
INSERT INTO aoi_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Ningenuminu-war•dangume-ka ngayuwa eningaba warka nungwenungwa-langwa nungkwurrunguwa kirringakakiruma-kiya, ");
INSERT INTO aoi_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","akena eneja nginu-mungkwurrkabuwarrkama ngayuwa-manja. Kenu-beyindangi-yada akena arngkumemberrkwa-murra nu-warrukwama akina-da. Umba eneja Neningikarrawara neni-lyangmurukwama Lebina akwa nara kembirra ken-arriyaka ngayuwa nakina-da. ");
INSERT INTO aoi_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Akwali-yada ni-yamama Lebina, ‘Amurndakibina nenukwuda akuminjiminjidadijungwa yiba-kwunama nungkuwa-wa.’ Kembirra ngalaja ababurna-langwa nenukwuda nuw-arrangbama angaringariya akuminjiminjidadijungwa akina-da. Umba akwali-yada ni-yamama nakina, ‘Akerrikirrikarrngajungwa nungkwa-langwa akina.’ Kembirra ngalaja ababurna-langwa nenukwuda nuw-arrangbama angaringariya akerrikirrikarrngajungwa akina-da. ");
INSERT INTO aoi_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Eneja Neningikarrawara nenuminu-wilyakama nenukwuda-murriya nungkwurringa-langwa-langwa nungwenungwa biya nginu-kwama ngayuwa-wa,” ni-yama Jekaba. ");
INSERT INTO aoi_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","Biya ngarningka ni-yama, “Namurndaki-rndarrkeyinu-manja nenukwuda nganja ningi-lyangburarrkinuma ngayuwa akini-yada. Ningi-rringkama nenukwuda enungkwarba ebina na-rndirrkeyinuma adarringka-manja akerrikirrikarrngajungwa akwa akuminjiminjidadijungwa amurndakakina. ");
INSERT INTO aoi_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Eneja Neningikarrawara-langwa nenikumamurikaja ni-yengbinuma akwulyangburarrka-murra ngayuwa-wa. Ni-yama, ‘Wayi, Jekaba...wa!’ Nganja, ‘Miyambena?’ ningi-yama. ");
INSERT INTO aoi_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Eneja ni-yama, ‘Engkirraja enenu-wa ayakwa Neningikarrawara-langwu-wa. Ni-yama nakina Neningikarrawara, Ababurna-langwa nenukwuda enungkwarba ebina na-rndirrkeyinama akerrikirrikarrngajungwa akwa akuminjiminjidadijungwa amurndakakina. Ngayuwa ningi-ngekburakinama akina mena ningeni-rringka-mubaba Lebina ni-yaminjamama nakina awurruwurrariya nungkuwa-manja-da, ni-yama. ");
INSERT INTO aoi_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Ngayuwe-ka ningena Ningeningikarrawara ningibina ningi-jadanguma nungkuwa-manja ningk-ambilyu-wiya ningkakina Bedela-manja. Akina-manja angalya Bedela, nungkwaja ningk-arjiyajuwama awilyaba-ma angwarnda biya ningki-jirabama amalyirra aliba-langwa akina-manja angwarnda kajungwa akwurdukwurdi-yada akina akwa ningki-yarrkakumarnuma ayakwa nganyangwi-yada yakwujina. Kembirra lawurradina arakba nungkwa-langwu-wa angalya ningki-rukwularru-murruwa, ni-yama Neningikarrawara nakina-da,’ ni-yama nginu-makama ngayuwa-wa nakina nenikumamurikaja Neningikarrawara-langwa,” ni-yama nakina Jekaba wurringalakina-kiya-wa Rejilu-wa akwa ngawa Liya-wa. ");
INSERT INTO aoi_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Aburringaja kembirra wurringalakina wurringidarringka-kiya narringi-yama Jekabu-wa, “Kini-jungwa-manja yirringa-langwa nungwarrka nara arakba ebina yirringa-langwa yiku-mangbilyerrma yelakwa ena-langwa-manja angalya. ");
INSERT INTO aoi_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Eneja nakina ni-yaminama yirringalakena-kiya-manja wuburra laka kini-yaminama nakina wurrukwala-manja warnumamalya wurruminjirrkingka-manja. Arakba-wiya nungkuwa yirru-mangu-manja yirringuwa, nu-manguma nakina nungkwa-langwa angwarnda. Umba ni-jerrukwama arakba akina angwarnda ningkenu-kwama nungkuwa, nara ebina ena-langwa-da. ");
INSERT INTO aoi_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Ngalaja ababurna-langwa amurndakibina Neningikarrawara nenuminu-manguma nungwarrka-langwa yirringa-langwa arakba akina-da akwa yirringa-langwa-langwa wurriyukwayuwa aburrajukwaba. Nungkwaja kembirra ki-yaminama ebina-langwiya Neningikarrawara nginu-maka-murrilangwiya-da,” narringi-yama wurringalakina. ");
INSERT INTO aoi_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","18","Eneja kembirra arakba nuwurraki-larrngkwaburranga Jekaba ena-langwa amurndakijika kajungwa neniki-lawurradi-yada nakina nungwenikba-wa Keninu-wa. Neni-njawudanguma nakina kamila-langwa-manja mirirrba wurriyukwayuwa ena-langwa akwa ngawa dadingiyenikba-kiya aburringajukwaba. Numurndaki-larrka jiba iya nenukwuda nawurraki-lyengmanguma arakba akwa ngawa amurndakijika-murriya amurndakibina nu-manguma nakina akina-manja angalya Mejubudamiya. ");
INSERT INTO aoi_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Ebina-wiya eneja Lebina ni-likenuma ni-ngkarrngarnuma amangwurrajija jiba-langwa nakina. Kembirra nara-wiya nibina, ngalaja Rejila ying-angmaduma nungwadikba-langwa akiringiringanda alawudawarra-murra. ");
INSERT INTO aoi_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Eneja Jekaba nara kenu-maka Lebina-manja neniki-lika-langwa umba nenu-mungkwurrkabuwarrkama nakina. ");
INSERT INTO aoi_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Numurndaku-manga ababurna-langwa ena-langwa-murruwiya biya warenja-bawiya na-likena arakba enuwa akwa ena-langwa warnumamalya wurrakina-da. Na-likena bi...ya narri-yakuwarrukwama adalyuma emikirra Yiburadija akwa na-likena engembu-wa Kiliyada angakarjiyinga-wa angalya. ");
INSERT INTO aoi_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Bi...ya mabiyakarbiya marringa numu-likenuma. Aburraja kembirra wurrukwala warnumamalya nenu-makama Lebina-manja ni-lyumadu-mulangwa arakba nakina Jekaba. ");
INSERT INTO aoi_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Eneja nenu-wilyaka kembirra Lebina ena-langwa warnumamalya, biya neni-larrmanguma arija-langwa Jekabu-wa. Neni-larrmanga nakina mamangbala mambilyuma marringa yanda-langwa nen-akburranga nakina Kiliyada-manja angakarjiyinga-manja angalya ");
INSERT INTO aoi_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","25","n-akumarnu-murrumanja Jekaba angalya adinakba. Biya n-akumarnuma Lebina angalya ena-langwa enejukwaba yakwujina enuwa akwa ena-langwa warnumamalya. Biya makina-manja ngawa meningalyarrngwalyilya ni-lyangburarrkinuma Lebina akwulyangburarrka. Eneja ni-likena Neningikarrawara akwulyangburarrka-murra enuwa-wa akwa ni-yama, “Nara e-yengbuma awurruwurrariya ayakwa Jekabu-wa,” ni-yama Neningikarrawara enuwa-wa-da. ");
INSERT INTO aoi_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Kembirra mingka-manja mamawura eneja nakina Lebina ni-likenuma Jekabu-wa. Ni-yama, “Miyambena-burra yi-mungkwurrkabuwarrkama ngayuwa akwa ningkarra-wilyakama dadiyawarrka-kiya, wuburra laka awinyamba-manja karra-wilyakinama warnumamalya wurridarringka wurrukwala-langwa wurrakina-da? ");
INSERT INTO aoi_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Miyambena-burra yi-mungkwurrkabuwarrkama akwa ningki-lyumaduma? Nara yiku-maka ayakwa. Yiku-maka-manja, kembirra yiba-larrkenuma ningkakina ningkiyekirrerra emeba-murra akwa akumalyumalyangka-ma-da ningkakina-da. ");
INSERT INTO aoi_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Nare-ka ningena ka-lawurangka-langwa niyarrungwarrka-murriya akwa dadiyawarrka-kiya lukwuniyawa-da, mena yi-lyangmurukwama ningkakina-da. Akine-ka enubuwakida nungkwa-langwa waka. ");
INSERT INTO aoi_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Ki-ngayindena-manja ngayuwa ki-yamina-manja awurrariya nungkuwa-manja, amandangwa kembirra ki-yaminama-da. Akena alyarrngwalyilya eneja Neningikarrawara nungkwa-langwa-langwa nungwena ni-yengbinuma ngayuwa-manja ayakwa akwulyangburarrka-murra. Nginu-madumurrukwama nakina. Nginu-makama nari-yada e-yengbuma awurrariya ayakwa nungkuwa-manja. ");
INSERT INTO aoi_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Ningeningma ngayuwa ningki-larrkuwerribikamurra ningkeningangkawura ningkeniki-lawurrada-langwa nungkwa-langwu-wa angalya. Aminakina-langwa ningki-lalikama nganyangwa angalya akena ningk-angmadumurra akiringiringanda amalawudawarra amurndakijika nganyangwa-na! Miyambena-burra yimin-angmaduma akina nganyangwa?” ni-yama Lebina Jekabu-wa. ");
INSERT INTO aoi_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Eneja ni-yama Jekaba, “Ning-akbar•duma, mena ning-engkirrikenuma ngayuwa yiku-murrakajuwa-mubaba wurringalakena nungkwa-langwa dadiyawena-kiya. ");
INSERT INTO aoi_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Umba k-akburranga-manja nungkuwa amalawudawarra nungkwa-langwa yelakwa yarnumamalya-manja kemba wurrakina warnumamalya ka-jungwunama wurrakina-da. Andiya eningerribirra nungkwa-langwa biya ku-wilyakina kembirra, kajungwa yakwa-langwa warnumamalya kabu-rringkini-yada,” ni-yama Jekaba. Akena neningbale-ka nakina dibina dadingiyenikba Rejila ying-angmaduma amurndakibina akiringiringanda amalawudawarra amurndakijika Lebina-langwa. ");
INSERT INTO aoi_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Eneja Lebina ni-likenuma Jekaba-langwu-wa kalikwa n-aburangkeyinuma yakwujina adinuba-wiya nakina, biya Liya-langwa-manja, biya Bilya-kiya-langwa-manja kalikwa, akena nara kin-akburrangarna. Biya arija-langwa ni-likena Rejila-langwu-wa kalikwa. ");
INSERT INTO aoi_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Ebina-wiya ngalaja Rejila yingu-manguma akwa ying-akumarnuma amurndakibina beka-manja mibina meningikamila-langwa-manja akwa ying-angmakwulaluma karrawara makina-manja beka ngala-langwa-manja kalikwa arrawa. Eneja kembirra Lebina n-aburangkama erribirra yakwujina akena nara kin-akburrangarna. ");
INSERT INTO aoi_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Umba Rejila yingi-yama nungwadikba-wa, “Nara awinyambaduma ngayuwa-wa, mena nara a-mirajanguma ngayuwa, mena merra-baba aduwaba ningena,” yingi-yama. Eneja Lebina n-abuburangkama ngawa nakina-da akena nara amalawudawarra ena-langwa kin-akburrangarna-da. ");
INSERT INTO aoi_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Eneja kembirra n-awinyambada arakba Jekaba. “Amiyambena-burra awurrariya ningi-yamama ngayuwa? Amiyambena-burra ayakwa arumuruma ningi-yarrkuwurranguma akwa yimin-aburangkama? ");
INSERT INTO aoi_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Ningk-aburangkama arakba nganyangwa-manja amurndakijika ababurna-manja, kembirra amiyambena yelakwa ningk-akburrangarna amurndakijika nungkwa-langwa? Yelakwa w-akuma akina kajungwa nungkwa-langwa warnumamalya karri-rringkini-yada akina akwa nganyangwa warnumamalya karri-rringkini-yada aburrajukwaba. Kwureya yakabu-rringkinama yakuwa yalakena yimiyambena-murrikba yeningaba, akwa yimiyambena-murrikba yuwurrariya, nungkuwa yinda ngayuwa. ");
INSERT INTO aoi_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","“Ning-ambambilyuma ngayuwa nungkuwa-manja ningeningangkawura mememberrkwa iya mememberrkwa mamarika iya yinungkwura. Yirramin-akwurrajuwama jiba iya nenukwuda nungkwa-langwa akwa nara ka-milyirrkilarrina eyukwayuwa akina. Nare-ka ningena k-alyubarina awilyuwilyaba enungkwarba jiba nungkwa-langwa-da. ");
INSERT INTO aoi_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Aba alyilyarra na-wardanguma amurndakibina jiba nungkwa-langwa kembirra ngayuwa yirra-kwama akwala nganyangwa akina-da. Nara ku-wilyaka akina nungkuwa-wa yiba-wilyakajuwa kajungwa ningkeningmi-yada nara ngayuwa-baba umba alyilyarra-baba akina, nara ki-yaminjama. Yi-makama ena ayakwa ngayuwa-manja. Ningki-yamama ningkakina, ‘Kuw-angmada-manja wurrukwala jiba iya nenukwuda nganyangwa waka meningilida umba waka meningalyarrngwalyilya, kembirra yiku-kwunama ningkakina akwala nungkwa-langwa ngayuwa-wa-da,’ ningki-yamama ningkakina-da. ");
INSERT INTO aoi_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Kembirra arngkababurna-langwa nganja ning-ardadinume-ka mardidarra ngayuwa meningilida umba alyarrngwalyilya ningu-murndadinume-ka ngayuwa-da. Nara ku-mungkwula umba ningu-mirakwulaluma ngawa-da. ");
INSERT INTO aoi_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","“Ningi-yaminjamama ningeningangkawura ngawa ning-ambilyu-wiya ngayuwa nungkuwa-manja. Mememberrkwa mabiyarbuwa mamarika iya yinungkwura yirraminu-war•danguma kajungwa yiku-kwi-yada dadiyawena-kiya. Kembirra arija-langwa mamangbala muwilyaba mamarika iya yinungkwura ngarningka yirraminu-war•danguma kajungwa yiku-kwi-yada jiba iya nenukwuda nungkwa-langwa. Akena nungkwaja yiminu-warrukwame-ka angwarnda nganyangwa arngkumemberrkwa-murra. ");
INSERT INTO aoi_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Nara-maka Neningikarrawara ngayuwa-manja kin-ambilya kembirra yiki-larrkenu-maka ningeningiyanda. Akena eneja Neningikarrawara nibina nungwarrka-murriya-langwa, nibina Aburiyama-langwa iya Ajika-langwa, ni-rringkama awerrikawarriya nganyangwa akwa ngawa ni-rringkama warka nganyangwa. Biya alyarrngwalyilya ni-lyangkuwerribikajungwunuma nakina yakuwa-langwa-da,” ni-yama Jekaba Lebinu-wa nakina-da. ");
INSERT INTO aoi_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Eneja ni-yama Lebina Jekabu-wa, “Wurringalakena dadiyawarrka-kiya akwa aburringa-langwa wurriyukwayuwa aburrajukwaba nganyangwa warna. Ngalajukwaba amurndakenena jiba iya nenukwuda nganyangwa akina. Eningerribirra ningki-rringkinama ababurna-langwa nganyangwa. Akena ningi-lyangmuridinama nganja ningena. Nare-ka embirrajuma ningena wurringalakena akwa aburringa-langwa wurriyukwayuwa, ");
INSERT INTO aoi_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","kembirra yaki-yarrkakumurnama ayakwa yakwa-langwa. Kembirra y-akumurna yakuwa angwarnda yu-murndukwuna yelakwa nari-yada e-yakuwabijuma ayakwa yakwa-langwa,” ni-yama. ");
INSERT INTO aoi_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Eneja kembirra Jekaba n-angkarna nakina awilyaba-ma ngawa angwarnda akwa n-arjiyajuwa yakwujina eningilyamarmbi-yada angwarnda kajungwa nari-yada e-yakuwabijuma ayakwa wunalakina-kiya. ");
INSERT INTO aoi_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Biya nenu-maka warnungkwarba ena-langwa-manja akwa narr-angkarna akwala aburrajukwaba akwa narr-arrngmurndukwa. Biya ne-yebukeyina aninga yakwujina angwarnda-manja. ");
INSERT INTO aoi_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Biya ni-yengbijuwama Jekaba emikirra angwarnda Kaleda umba eneja Lebina ni-yengbijuwama akina angwarnda emikirra Jeka Jeyadida, mena alakina-kiya ekirra ne-yaminama “angwarnda ngarniki-yakuwerribika-langwa.” ");
INSERT INTO aoi_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Ni-yama Lebina Jekabu-wa, “Amurndakenene-ka angwarnda aduwaba kajungwa yaki-yakuwerribikini-yada ayakwa yakwa-langwa ambaka-murra,” ni-yama. Yadikina akina angalya emikirra Kaleda. ");
INSERT INTO aoi_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Biya ni-yama ngarningka Lebina, “Yaweya yakenilirraki-rringkina yalakena mama yeyebijeba,” ni-yama. Kembirra aminakina-langwa ayakwa Lebina-langwa-langwa awilyaba emikirra ngarningka angalya-langwa Mijiba, mena akina ekirra Mijiba ne-yaminama “yakenilirraki-rringkina-murrumanja.” ");
INSERT INTO aoi_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Ni-yama ngarningka Lebina, “Ki-yamina-manja nungkuwa awurrariya wurringalakina-kiya-manja ningkakina akwa ka-mena-manja wurrukwala ngarningka wurridarringka dadingiyena-murriyi-yada, mama ningeningbala-wiya ngayuwa, ningkeningma nungkuwa Neningikarrawara yakeni-rringkinama yalakena. ");
INSERT INTO aoi_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","52","Kwuja! Yimini-rringka-langwa amurndakenena angwarnda nganyangwa ninguwurra-murndukwa-mulangwa yelakwa yakuwa-manja wilyarra akwa ngawa enena awilyaba-ma eningilyamarmba angwarnda ning-arjiyajuwa-mulangwa ngayuwa yaki-yakuwerribikaji-yada yakuwa. Ningena nara a-langarngkuwarrukwama amurndakenena angwarnda ningu-murndukwa-mulangwa ningena. Nara kembirra ngayuwa a-warduma nungkuwa-manja ningena-da. Nungkwajukwaba nara ningkakina a-langarngkuwarrukwama amurndakenena angwarnda ninguwurra-murndukwa-mulangwa ngayuwa aduwaba akwa ngarningka nara a-langarngkuwarrukwama enena awilyaba-ma angwarnda eningilyamarmba ngalajukwaba. Nara kembirra ningkakina a-warduma ngayuwa-manja-da. ");
INSERT INTO aoi_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Eneja nakina Neningikarrawara Aburiyama-langwa nibina-murrada ngarningka Neyawa-langwa kini-lyangkuwerribikajungwunama nakina yakuwa-langwa-da,” ni-yama Lebina Jekabu-wa. Eneja kembirra Jekaba ni-yarrkakumarna ayakwa nari-yada a-yarrkuwarrukwajuma amurndakakina ayakwa Lebina-langwa. Akina ayakwa ni-yarrkakumarnuma akwa neni-yengbijuwama nenimikirra Neningikarrawara, nibina-murrada nungwenikba Ajika neni-yangmarngkwajuwa-mulangwa nakina. ");
INSERT INTO aoi_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Biya nu-wardanga bulukwa akwa ni-daka angwura-manja yakwujina alingajirrirra-manja angakarjiyinga-manja angalya. Neningikarrawara-langwa ni-dakama akina. Biya nen-ardijuwa warnumamalya ena-langwa akwa ne-yebukeyinuma wurrakina. Biya nuw-eyijinu-mulangwa kembirra nuw-ambilyuma yakwujina meningalyarrngwalyilya marringa akina-manja ngawa angakarjiyinga-manja angalya. ");
INSERT INTO aoi_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Kembirra mingka-manja meninguwurdarriya-wiya mamawura nu-mirajangu-manja eneja nakina Lebina, neni-lawurangka nakina lukwuniyawa wurriyarrngwiyarrngwena akwa nenilirraki-lawurangka dadiyawenikba-kiya. Biya ni-likena arakba ni-lawurradina angalyu-wa nakina-da. ");
INSERT INTO aoi_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Enejukwaba Jekaba ni-lalika angalya ebina kajungwa neniki-lawurradi-yada nakina nungwenikba-wa. Biya ni-likena nakina lukwakwa ngawu...wa. Aburraja kembirra wurrukwala warnikumamurikaja Neningikarrawara-langwa nen-akburranga nakina. ");
INSERT INTO aoi_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Umba neni-rringka-manja Jekaba wurrakina warnikumamurikaja Neningikarrawara-langwa, ni-yama nakina, “Neningikarrawara-langwa angalya ena-da,” ni-yama nakina. Biya yadikina ni-yengbijuwa angalya emikirra Meyeneyuma mena akina ekirra Meyeneyuma ne-yaminama “ambilyuma angalya.” ");
INSERT INTO aoi_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Biya kembirra neni-larrka nakina arakba wurrukwala warnungkwarba na-lyengmanguma narru-wilyakama ayakwa ena-langwa nawenikba-wa Yijawa. Aburraja nen-akburranga arakba nakina Yijawa wurrakina akina-manja aringbirra angalya Yiduma. ");
INSERT INTO aoi_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Akwa ne-yama enuwa-wa, “Nenikumarnjena Jekabe-ka nubukwaya arija-langwa nakina akwa kenumin-engkirrikaji-yada ayakwa nungkwa-langwa. N-ambambilyuma nebena-manja Lebina-manja ena-langwa-manja angalya nenungkwurakbe-ka. ");
INSERT INTO aoi_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Akwa nu-wilyakinama aduwaba bulukwa iya dangki iya jiba iya nenukwuda akwa ngarningka warnikuminuwar•duwar•da ena-langwa. Ngini-ngayindenama nungkuwa ki-lyelyingminama ningkakina kini-rringkina-mulangwa nakina,” ne-yama wurrumurndakakina warnungkwarba Yijawu-wa. ");
INSERT INTO aoi_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Biya kembirra na-lawurradina wurrakina Jekabu-wa akwa ne-yama enuwa-wa, “Yirri-likenuma yarna nawenu-wa akena nubukwaya ni-likajama arakba nakina kajungwa yikin-akburrangeyini-yada. Wurrababurne-ka warnungkwarba enuwa-manja 400,” ne-yama wurrakina Jekabu-wa. ");
INSERT INTO aoi_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Eneja Jekaba n-akbar•de-ka akina-langwa ayakwa akwa nu-werrikawarriyada arakba nakina. Kembirra nen-eyebijebakama warnumamalya ena-langwa wurruwurrakambilyuma. Kembirra ngalajukwaba n-eyebijebakama jiba iya nenukwuda iya kamila akwa ngawa bulukwa ena-langwa awurrakambilyuma. ");
INSERT INTO aoi_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Ni-lyangkiyama nakina, “Yijawa ka-wardiyina-manja awinyamba wurruwurrakuwilyaba-manja kembirra wurrukwala ka-lyumadinama wurringkinyungwurra,” ni-lyangkiyama nakina Jekaba. ");
INSERT INTO aoi_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Biya nu-buriyamina Jekaba Neningikarrawaru-wa. Ni-yama, “Ningkakine-ka Ningkeningikarrawara numirarrka-langwa Aburiyama-langwa akwa ngawa nungwarrka-langwa Ajika-langwa. Engkirraja-langwa kembirra ngayuwa-wa. Ningi-lawurradinama ngayuwa aduwaba nungwarrka-langwu-wa angalya akwa ngawa nganyangwu-wa warnumamalya, mena yi-maka-mubaba nungkuwa, Yaweya. Yi-makame-ka eningaba ngayuwa-manja ki-yamina-mulangwa nungkuwa. ");
INSERT INTO aoi_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Biya nara yiki-lalika ningkeningangkawura ning-ambilyu-wiya ngayuwa Mejubudamiya-manja umba ningku-marngkirradinuma ngayuwa-manje-ka. Akena nganja nara ki-yama eningerribirra eningaba nungkwa-langwa. Ningi-yakuwarrukwa-manja EningiJardina Adalyuma adinuba-wiya, nara ebina nganyangwa umba wulkwa arnduwarra. Akena yu-kwama arakba ababurna eninginingaba nganyangwa. Kembirra aduwaba wurruwurrakambilyuma warna nganyangwa akwa ngawa awurrakambilyuma amurndakenena nganyangwa. ");
INSERT INTO aoi_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Marrakba, yi-mamurikajina-langwa ngarningka aduwaba, nari-yada a-ngajuma nawarrka Yijawa ngayuwa-manja,” ni-yama Jekaba Neningikarrawaru-wa. Biya ni-yama ngarningka enuwa-wa, “Ning-akbar•dename-ka ngayuwa angwurra. Ning-akbar•denama ngayuwa neniki-lika-langwa Yijawa nakina neniku-wardi-yada awinyamba yirruwa-manja akwa neniki-ngaji-yada yirruwa yirrababurna-langwa, yirrababurna-langwa yarnungkwarba akwa ngarningka wurridarringka akwa wurriyukwayuwa aburrajukwaba. ");
INSERT INTO aoi_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Nungkwaja ningki-yarrkakumarnuma ayakwa kajungwa eningaba ngayuwa-manja ki-yamini-yada nungkuwa, akwa ngawa k-akumajungwuni-yada ngayuwa wurrababurna wurriyukwayuwa nganyangwa. Yi-makama kuw-arrangbijeyina-mulangwa aburra-langwa wurriyukwayuwa kuw-ababurnadina-murruwa wurrakina. Aburraja ka-wurramur•dinama wurrakina wuburra laka ajiringka ababurna mijiyelya-manja. Nara kembirra nungkwaja e-yakuwabijuma ebina ningki-yarrkakumarnumurra ayakwa-da,” ni-yama Jekaba Neningikarrawaru-wa. ");
INSERT INTO aoi_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Biya Jekaba n-ambilya akina-manja angalya alyarrngwalyilya. Wurdarriya-wiya kembirra nu-murndukwama akwa nu-murnduwarnuma nenukwuda-murriya ena-langwa neniku-kwi-yada nawenikba-wa Yijawa. ");
INSERT INTO aoi_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","Ngalaja 200 nenukwuda adarringka-wiya akwa 20 enungkwarba-wiya, iya 200 jiba adarringka-wiya akwa 20 enungkwarba-wiya, ");
INSERT INTO aoi_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","iya 30 kamila adarringka-wiya akwa eyukwayuwa ngala-langwa, iya 40 bulukwa adarringka-wiya akwa 10 enungkwarba-wiya, akwa ngawa 20 dangki didarringka-wiya akwa 10 dadinungkwarba-wiya. ");
INSERT INTO aoi_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","N-eyebijebakame-ka nakina amurndakakina awurrakumangbala, ngala waka nenukwuda-wiya, ngalajukwaba waka jiba-wiya, ngalajukwaba kamila-wiya, ngalajukwaba bulukwa-wiya akwa ngalajukwaba waka dangki-wiya. Biya nenu-makama warnikuminuwar•duwar•da wurrumangbala karr-akwurrajini-yada amurndakakina. Ni-yama wurrumurndakakinu-wa warnikuminuwar•duwar•da ena-langwu-wa, “Yiki-likaja arakba yiki-lyengmena. Awurrakuwilyaba adinuba-wiya ka-likajama biya ambaka-murra awurrakuwilyaba ka-likajama ke-yuweyinama akina.” ");
INSERT INTO aoi_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Biya ni-yama nakina neningadinuba-wiyu-wa nenikuminuwar•duwar•da, “Yijawa nawarrka nganyangwa kin-akburranga-manja ningkakina, kini-yaminama nakina nungkuwa-wa, ‘Numiyambena nubungkawa nungkwa-langwa?’ kini-yaminama, ‘Akwa ngambu-wa ki-likajama? Akwa angkaburra-langwa amurndakenena nenukwuda-murriya?’ kini-yaminama nawarrka. ");
INSERT INTO aoi_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","Kembirra nungkwamba-langwa ki-yaminama nungkuwa enuwa-wa, ‘Jekaba-langwa amurndakenena. Nakina kenumin-engkirrikaji-yada ayakwa nungkwa-langwa akwa ni-larrkama amurndakenena nungkwa-langwi-yada. Nakine-ka nubukwaya arija-langwa ni-likajama,’ kinu-makinama nungkuwa kembirra Yijawu-wa,” ni-yama Jekaba ena-langwu-wa nenikuminuwar•duwar•da. ");
INSERT INTO aoi_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Biya nenu-makama nakina ena-langwa-manja warnikuminuwar•duwar•da wurrababurna-manja narr-akwurrajuwa-murrumanja jiba-murriya, nenu-makama wurrididirrbura ngawa ebina-murrada ayakwa kajungwa warniki-yami-yada wurrakina aburrajukwaba Yijawu-wa. Ni-yama aburruwa-wa, “Yikin-akburrangina-manja Yijawa kembirra yiki-yaminama enuwa-wa enena ayakwa, ");
INSERT INTO aoi_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","‘Yawa, Jekabe-ka kenumin-engkirrikaji-yada ayakwa nungkwa-langwa akwa ni-likajama nubukwaya arija-langwa nakina,’ yiki-yaminama kirrakina,” ni-yama Jekaba aburruwa-wa. Umba ni-lyangkiyamama nakina, “Adinuba-wiya kinu-menama nawarrka amurndakenena nenukwuda-murriya. Kembirra arija-langwa ken-akburranginama nakina ngayuwa. Dukwa akina-langwa ningenu-kwa-mulangwa amurndakakina kenumini-yakuwabijinama ngayuwa-da,” ni-lyangkiyamama Jekaba nakina. ");
INSERT INTO aoi_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Biya kembirra neni-larrkama arakba nakina Jekaba wurrumurndakibina warnikuminuwar•duwar•da, na-lyengmanguma narru-wilyakama nenukwuda-murriya. Umba n-ambilyuma nakina yakwujina ngawa. Biya na-lyarrngwalyilyada arakba akina-da. ");
INSERT INTO aoi_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","23","Biya makina-manja ngawa meningalyarrngwalyilya Jekaba nu-mirajanga nakina akwa nenilirraki-larrkama wurradingabulena Rejila akwa ngawa Liya narringi-yakuwarrukwama adalyuma emikirra Jabakwa. Akwa ngawa wurringambilyuma wurradingabulena wurringadikuminuwar•duwar•da-kiya wurringadimikirra-kiya Bilya akwa ngawa Jilba aburringajukwaba nenilirraki-larrkama narringi-yakuwarrukwama, akwa ngawa wurrababurna-langwa wurriyukwayuwa ena-langwa. Akwa ngawa ababurna-langwa amurndakijika ena-langwa ni-larrkenuma adinakba. ");
INSERT INTO aoi_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Umba nakwukawura n-ambilyuma nakina. Eneja nuwilyaba nenumamalya ni-likenuma alyarrngwalyilya ngawa Jekabu-wa akwa arakba nenu-kuwurriyinuma wunalakina ayarrka-murra. Neni-yaminjama wunalakina ngawa nenu-kuwurriyinuma ngawu...wa. Biya akwudangwa arakba ne-kbadanga. ");
INSERT INTO aoi_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Biya neni-rringka-manja nakina nenumamalya nakina Jekaba nara kinu-murndakayuwayanga, kembirra nen-angkarrbaja arringka-manja. Umba ngalaja amanjenjinyirra arringka Jekaba-langwa na-lalikajuma arakba, nuw-arriyaduma akina-da. ");
INSERT INTO aoi_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Biya ni-yama nakina nenumamalya Jekabu-wa, “Yi-larrkiya arakba! Adinuba ena ke-kbadiyama,” ni-yama. Umba ni-yama Jekaba, “Ki-yengbina-manja ningkakina eningaba ayakwa ngayuwa-wa, kembirra yiba-larrkiyama ngayuwa ningkena-da,” ni-yama nakina Jekaba enuwa-wa-da. ");
INSERT INTO aoi_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Eneja ni-yama nakina nenumamalya, “Ningkumiyambena ningkena ningkenimikirra?” “Ngayuwa ningena Jekaba,” ni-yama eneja. ");
INSERT INTO aoi_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Eneja ni-yama nakina nenumamalya, “Nara arakba ngi-yengbijuma Jekaba ningkenimikirra, umba enikaduwa arakba ekirra Yijireyila nungkwa-langwa aduwaba. Ningkarra-wilyakajuwama warnumamalya-manja ningkarrubude-ka ningkakina Neningikarrawara-manja. Akwa ngarningka ningkarra-wilyakajuwama warnumamalya-manja ningkarrubude-ka ningkakina warnumamalya-manja ngarningka ngawa. Kembirra akina-langwa Yijireyila arakba ningkakina ningkenimikirra aduwaba-langwa,” ni-yama nakina. Ni-yengbinuma akina ayakwa mena akina ekirra Yijireyila ne-yaminama “nenu-kuwurriyinu-murrumanja nakina akwa Neningikarrawara.” ");
INSERT INTO aoi_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Eneja kembirra ni-yama Jekaba, “Yi-maka-langwa nungkwa-langwa ekirra.” Umba ni-yama, “Miyambena-burra nungkuwa ningki-ngayindenama nganyangwa ekirra k-eningmidinama?” ni-yama. Kembirra nenu-maka Jekaba-manja eningaba ayakwa kajungwa eningaba ka-ngekburakajungwuni-yada arija-langwa ena-langwa. ");
INSERT INTO aoi_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Kembirra ni-likenu-mulangwa nakina nenumamalya engku-wa eneja nakina Jekaba ni-yakuwerribika arakba nakina. Ni-lyangkiyama, “Amandangwa. Nakina-bina Neningikarrawara enuwa-na!” ni-yama nakina. “Ningeni-rringkama nenumukwurra akena ningena ngawa ningeniba ngayuwa-da.” Kembirra ni-yengbijuwama angalya akina Buniyela mena akina ekirra Buniyela ne-yaminamurra “Neningikarrawara-langwa nenumukwurra.” ");
INSERT INTO aoi_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Biya numa-merrkambijanginu-manja ngawa mamawura, kembirra Jekaba ni-lalika arakba nakina akina angalya biya ni-yakuwarrukwa arakba akina Adalyuma EningiJabakwa. Akena n-arnduwarrikinuma arakba nakina, mena n-angkarrkarrkwujeyinuma arringka-manja-baba. ");
INSERT INTO aoi_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Akwa aduwaba ngawa WarningiYijireyila warnumamalya kuw-alyubarina-manja amadangkwa wurrakina, nara alyubaruma yeyerra arringka-langwa bulukwa-murriya-langwa, mena-baba nibina nenumamalya neni-ngaja-mubaba Jekaba arringka-manja-da. ");
INSERT INTO aoi_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","2","Akini-yada ngawa mibina-manja mamawura Jekaba neni-rringka nubukwaya Yijawa ni-likenuma enuwa-wa akwa ngarningka wurruwurrakwulyumida warnungkwarba 400 enuwa-manja. Kembirra nenilirraku-makama Jekaba wurringalakina-kiya Bilya akwa Jilba. Kembirra aburringaja narrawurra-murndukwama wurriyukwayuwa aburringa-langwa akwa nuw-alkayanguma na-lyengmanguma. Eneja kembirra nanga-makama Liya-manja. Kembirra ngalamba-langwa narringa-murndukwama wurriyukwayuwa ngala-langwa biya ngaluwa akwa wurriyukwayuwa ngala-langwa nuw-alkayanguma akwaburrangarna. Ngarningka nanga-makama Rejila-manja. Kembirra aburnaja wunalakina Rejila akwa ngawa naburradikba Jawijiba arija-langwa nen-alkayanguma akwaburrangarna. ");
INSERT INTO aoi_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Eneja kembirra ni-likena Jekaba nakina Yijawu-wa akwudangwa akwa n-abuluwendinga ajiringka-manja kajungwa nawenikba nakakirumi-yada kenumin-engkirrikaji-yada nakina enuwa-wa. Arngkumangbala-murra akwa arngkambilyume-ka n-abuluwendingama nakina. ");
INSERT INTO aoi_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Akena eneja nakina Yijawa n-angkarra Jekabu-wa nenu-kwurukwa akwa nen-engkarrnga akwa neni-lawurangka. Biya nenu-ngwadijeyinuma ngawa wunalakina neni-kbarrngajeyinu-mubaba angwurra. ");
INSERT INTO aoi_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Biya Yijawa n-andeya akena neni-rringka wurrumurndakakina wurriyukwayuwa akwa wurrirndirndarrngwa. Ni-yama, “Wurrumiyambena warna warnumamalya?” Eneja ni-yama Jekaba, “Neningikarraware-ka nu-marngkirradinuma ngayuwa-manja akwa nginu-kwama wurrumurndakenena wurriyukwayuwa-da.” ");
INSERT INTO aoi_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Kembirra aburringaja Bilya akwa Jilba narring-akwudangwukajungwa akwa ngawa wurriyukwayuwa aburringa-langwa, akwa nuw-abuluwendijeyinuma aburrajukwaba Yijawa-manja. ");
INSERT INTO aoi_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Kembirra ngalaja Liya ying-akwudangwukajungwa akwa ngawa wurriyukwayuwa ngala-langwa, akwa nuw-abuluwendijeyinuma aburrajukwaba. Kembirra aburnamba-langwa arija-langwa Jawijiba akwa Rejila nen-akwudangwukajungwa wunalakina akwa nen-abuluwendijeyinuma Yijawa-manja aburnajukwaba wunalakina-da. ");
INSERT INTO aoi_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Eneja nakina Yijawa ni-yama, “Amurndakakina bulukwa-murriya ningi-rringkama lukwakwa ke-yamarrkinama akina?” ni-yama. Enamba-langwa ni-yama Jekaba, “Ngeniyerriya, kada akine-ka nungkwa-langwi-yada-da. Yirra-ngayindanguma ningkakina ki-yekirrerridini-yada.” ");
INSERT INTO aoi_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Eneja ni-yama Yijawa, “Ababurne-ka arakba ena ngaya, nenikama. Umba minambilya akina nungkwaja nungkwa-langwi-yada,” ni-yama. ");
INSERT INTO aoi_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","11","Umba ni-yama ngarningka Jekaba, “Yirramini-ngayindenama amandangwa ku-wilyakini-yada nungkuwa, mena ningk-errukwulinu-mubaba ngayuwa-manja. Nare-ka ningkakina k-awinyambadina yiki-larrkena engku-wa. Umba ningkeningabe-ka ngawa ningenikumarnjena-manja. Yirra-rringkina-manja ningkenumukwurra ningkakina, akine-ka wuburra laka ningeni-rringkinama Neningikarrawara-langwa nenumukwurra arakba ngayuwa. Eneja Neningikarraware-ka nu-marngkirradinuma nakina ngayuwa-manja akwa nginu-kwama ababurna-langwa eningerribirra ningi-ngayindanguma ebina,” ni-yama Jekaba. Kembirra arakba-langwa amurndakakina numurndaku-manguma eneja nakina Yijawa ena-langwi-yada arakba-da. ");
INSERT INTO aoi_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Biya ni-yama Yijawa Jekabu-wa, “Kwa, arakba yi-likaja. Ngayuwa adinuba-wiya ngi-lyengmenama ningena,” ni-yama. ");
INSERT INTO aoi_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Eneja ni-yama Jekaba, “Ningkeningme-ka ningkakina nungkuwa wurriyukwayuwa nganyangwa warningingbuda-ma warna. Umba k-embirrajinama ngayuwa jiba iya bulukwa akwa eyukwayuwa. Ngayuwa k-enjirrikina-manja amurndakakina muwilyaba-manja ngawa marringa ngalaja kamurndaki-jungwunama ababurna-langwa akina-da. ");
INSERT INTO aoi_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Likaja arakba lyengmena. Nganja k-aburrakiyuwarnama arija-langwa. Ki-likajama ambaka-langwa k-embirrajinama bulukwa-murriya akwa wurriyukwayuwa nganyangwa yanda-langwa yik-akburranginama ningkakina Yiduma-manja,” ni-yama Jekaba. ");
INSERT INTO aoi_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Eneja ni-yama Yijawa, “Kembirra kamurndaki-lalikinama ngayuwa wurrukwala warnungkwarba yelakwa nungkuwa-manja.” “Miyambena-burra?” ni-yama eneja Jekaba. “Yirra-ngayindenama ningkakina ki-yekirrerridini-yada,” ni-yama. ");
INSERT INTO aoi_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Kembirra akini-yada ngawa ni-lalikama eneja Yijawa akina angalya neniki-lawurradi-yada Yidumu-wa. ");
INSERT INTO aoi_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Umba eneja Jekaba ni-likena nakina eminingku-wa angalya. N-alilikenu...wa. Biya Jakida-manja ni-yar•da arakba. Biya ni-likirakama alikira ena-langwa yakwujina umba amiyerriya ni-ngekburakama bulukwa-langwa. Biya ni-yengbijuwama angalya emikirra Jakida, mena akina ekirra Jakida ne-yaminama “amiyerriya.” ");
INSERT INTO aoi_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Bi...ya ambaka-murra ni-lalika Jekaba akina angalya akwa ni-likena engku-wa angwurra Jekemu-wa. E...ngka-langwe-ka angalya Mejubudamiya-langwa ni-likenuma nakina ningkinyungwurra ngawa yanda-langwa ni-yar•duma Kenina-manja. Biya Jekema-manja akwudangwa ni-ngekburakama angalya. Umba akine-ka angalya Jekema aminababurna alikira iya warnumamalya akina. ");
INSERT INTO aoi_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Biya Jekaba nu-manga nakina angalya ena-langwa angwarnda-murra. Nenu-kwama 100 angwarnda amamuwa ajilba-murra WarningiYamawa warnumamalya. Umba nakine-ka Yamawa nungwenikba Jekema-langwa nakina. ");
INSERT INTO aoi_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Kembirra nuwurrak-arjiyajuwa angwarnda aldi-yada ni-ngekburakama akina Neningikarrawara-langwa. Biya ni-yengbijuwama akina alda emikirra “Neningikarrawara Nibina WarningiYijireyila-langwa Warnumamalya” nakina-da. ");
INSERT INTO aoi_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Arngkawura ngalaja yingi-likena Dayina dakina, dibina dadiyawarringba daburrarringba Jekaba-langwa akwa ngawa Liya-langwa, narringa-ngarranguma wurrukwala wurridarringka WarningiKenina dakina-da. ");
INSERT INTO aoi_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Yakwujina eneja nuwilyaba nenungkwarba nanga-rringkama dakina. Nenimikirra Jekema. Umba nungwenikba Yamawa NeningiYiba nakina. Nubungkawe-ka Yamawa akina-manja angalya. Umba nenikuwenikba Jekema nanga-rringka Dayina akwa nanga-manga, biya nanga-wilyaka erriberriba-wa akwa nang-engkarrnga yakwujina. ");
INSERT INTO aoi_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Nanga-rringkama nakina dadingabe-ka akwa ni-lyelyingminuma dakina akwa eningaba ayakwa ni-yengbinuma ngaluwa-manja. ");
INSERT INTO aoi_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Biya kembirra nenu-makama nungwenikba-wa, “Yiminu-mena dakina dadiyara nganyangwi-yada dadingiyarrka,” ni-yama. ");
INSERT INTO aoi_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Kembirra eneja Jekaba n-engkirrika nakina ayakwa ebina-langwa ni-yama-mulangwa Jekema dadiyawenikba-manja akena nara kuw-ambilya yakwujina enuwa-manja warninikuwena. Nuw-ambilyuma angakuba-wiya bulukwa-murriya-manja wurrakina. Kembirra n-embirrarinuma Jekaba warniki-lawurradi-yada wurrakina. Kaba ngawa n-ambilyuma nakina-da. ");
INSERT INTO aoi_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","7","Na-lawurradinu-manja angalyu-wa warninikuwena Jekaba-langwa aburnaja Jekema akwa nungwenikba Yamawa neni-likena yenjerrikina ayakwi-yada wunalakina. Kembirra arakba aburraja Jekaba-langwa warninikuwena nuw-engkirrika-manja akina ayakwa narrak-ar•darre-ka awinyamba. Ne-yama, “Awurruwurrariye-ka ni-yamama nakina nenumamalya-da,” ne-yama. “Yirreni-yelijuma nakina yirrababurna-langwa yarnumamalya YarningiYijireyila nanga-mangu-mulangwa erribirra nakina Jekaba-langwa dadiyawenikba-da,” ne-yama wurrakina. ");
INSERT INTO aoi_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Umba eneja Yamawa nungwenikba Jekema-langwa ni-yama Jekabu-wa, “Nenikuwarrke-ka ni-lyelyingminama dadiyawenu-wa, kemba kinu-kwuna nakina?” ni-yama. ");
INSERT INTO aoi_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","“Yak-akumurnama ayakwa yalakena aduwaba. Yiku-kwunama kirrakina wurradidiyawenungwa nungkwurra-langwa, kembirra yirramba-langwa ka-kwunama yirra-langwa dadiyawarrka-murriya nungkwurruwa-wa. ");
INSERT INTO aoi_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Kembirra yik-ambilyama kirrakina yirra-langwa-manja angalya ngarruwurrakawura-ma. Yiki-ngayindena-manja, kembirra yik-ambilyama eningerribirra-manja angalya kirrakina. Eningerribirre-ka warka yik-akburranginama kirrakina kajungwa yiku-meni-yada aninga-murriya. Akwa ngarningka nungkwurra-langwa angalya yiku-beyindenama akina,” ni-yama Yamawa. ");
INSERT INTO aoi_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","12","Eneja Jekema ni-yengbinuma enamba-langwa ayakwa Dayina-langwu-wa nungwadikba akwa ngala-langwu-wa wurrawuwada. Ni-yama, “Marrakba, wurr-errukwuliya-langwa nganja ningena. Yirru-makina ayakwa. Eningerribirra amurndakijika kirri-ngayindenama kirrakina ka-kwunama akina. Yiki-lyangkuwamina-manja yikingi-yakeyina-manja yirringalakena kembirra ka-kwunama ningena ngayuwa angwarnda iya amurndakijika nungkwurruwa-wa-da,” ni-yama Jekema. ");
INSERT INTO aoi_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Akena aburraja Jekaba-langwa warninikuwena neni-kadikama Jekema-manja akwa nungwenikba-manja ni-yama-mulangwa Jekema nakina. ");
INSERT INTO aoi_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","Ne-yama, “Nara-manja a-ringandijungwuma a-mukaduwamurrikajungwuma ningkakina kembirra nara a-kwama yarna dadiyamarnjarrka yirra-langwa nungkuwa-wa. Yiki-yeliyename-ka. ");
INSERT INTO aoi_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Umba yiku-mukaduwamurrikajungwuna-manja nungkurnuwa akwa nungkwurna-langwa warnungkwarba wurrababurna-langwa kajungwa yirruwa wuburra yiki-yamini-yada kirrakina, kembirra yirruwa ka-kwunama daka dadiyamarnjarrka nungkuwa-wa-da. ");
INSERT INTO aoi_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Ka-kwunama yirra-langwa dadiyawarrka-murriya nungkwurruwa-wa, kembirra nungkwurramba-langwa yiku-kwunama nungkwurra-langwa wurradidiyawenungwa yirruwa-wa. Yik-ambilyame-ka yarna yelakwa kembirra ngarruwurrakawura-ma ngawa-da. ");
INSERT INTO aoi_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Akena nara-manja a-lyangkuwamama a-ringandijungwuma karna kirrababurna-langwa karnungkwarba kembirra yiking-angkirnama arakba dadiyamarnjarrka akwa yiki-lalikinama yarna enena angalya nungkwurra-langwa-da,” ne-yama. ");
INSERT INTO aoi_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Eningabe-ka akina ayakwa ebina nen-engkirrikama Jekema akwa nungwenikba wunalakina. ");
INSERT INTO aoi_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Kembirra nara kin-ambudidina Jekema umba ni-yama nakina ebina-langwiya ayakwa ngawa-da mena ni-lyelyingminuma dakina Dayina-baba-da. Jekeme-ka nakina numikbiyiya-dangwa naruma ena-langwa-manja warnumamalya. ");
INSERT INTO aoi_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Biya kembirra neni-likena wunalakina Yamawa akwa nenikuwenikba Jekema akawiyuwiyebu-wa ebinu-wa adaku-wa angalya akwulyelyimbukwaju-wa ayakwi-yada wunalakina. Biya nenu-makama wurruminakina angalya. ");
INSERT INTO aoi_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","“Warne-ka warnungkwarba wurrumilyukwa na-werrikumarrngbijeyinama,” ne-yama. “Ab-ambilya yelakwa ngakwurra-langwa-manja angalya ngakwurruwa akwa abu-likaja erribirra enena-manja angalya. Adirrungwarna ena angalya ngakwurra-langwa, kembirra aburra-langwa aburrajukwaba ena angalya-da. Ngarra-mena aburra-langwa wurradidiyawarrngwa umba ngarra-kwuna kembirra arrkala wurradidiyawarrka ngakwurra-langwa aburra-langwi-yada wurradidingiyarrngwa. ");
INSERT INTO aoi_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Umba aburraja wurrumurndakenena warnumamalya ngarrabu-ngayindenama ngakwurruwa aku-mukaduwamurrikajungwunama ngarnungkwarba, wuburra ne-yaminjaminama wurrakina. Nara-manja, kembirra nara a-lyangkuwamama wurrakina akwa nara yelakwa ambilyuma ngakwurruwa ngarruwurrakawura-ma ngarna-da. ");
INSERT INTO aoi_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Yelakwa kuw-ambilya-manja wurrakina ngarruwurrakawura-ma, kembirra ngakwurra-langwi-yada arakba ababurna-langwa jiba-murriya iya amurndakijika-murriya narri-larrngkuwilyakamurra yangkwurrangwa akina-da. Kembirra aka-makina wurrakina kuw-ambilyama yelakwa-da,” neni-yama Jekema akwa nungwenikba. ");
INSERT INTO aoi_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Aburraja wurrababurna-langwe-ka warnungkwarba wurruminakina angalya namurndaki-yama, “Eningabe-ka ayakwa akina,” na-makijeyinuma wurrakina. Biya kembirra na-mukaduwamurrikajeyina arakba wurrababurna-langwa warnungkwarba. ");
INSERT INTO aoi_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","26","Bi...ya mabiyakarbiya-manja marringa nuw-arrkwujeyinu-wiya ambaka wurrakina warnungkwarba, aburnaja kembirra Jekaba-langwa wunambilyuma warnikuwabulena Jimiyina akwa Libaya, Dayina-langwa nawadikba-kiya, nenu-wilyaka kaliwanga, nen-ajabangwuna, kembirra nen-awiyebena arumu-wa angalya amurama-langwiya. Kembirra narra-wardanguma wunalakina Yamawa akwa nenikuwenikba Jekema akwa ngawa wurrababurna-langwa warnungkwarba. Kembirra narringa-jadijuwa wunalakina Dayina Jekema-langwa-langwa alikira akwa nabuki-lyumada arakba-da. ");
INSERT INTO aoi_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Kembirra narra-wardangu-mulangwa wunalakina wurrababurna-manja warnungkwarba, aburraja Jekaba-langwa wurrukwala warninikuwena namurndaki-likena narrumurndaku-manga eningerribirra amurndakijika-murriya akwa narru-wilyakama aburra-langwi-yada. Kembirra yadikina narramini-lawurrakajuwa awurrariya narringa-yeliju-mubaba dadiyamarnjarringba. ");
INSERT INTO aoi_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Narru-manguma jiba iya nenukwuda iya bulukwa iya dangki akwa ngawa amurndakijika, ababurna-langwa amurndakibina nuw-ambilyu-murrumurra angalya-manja arrawa, akwa ngawa amurndakibina nuw-ambilyu-murrumurra erriberriba-manja. ");
INSERT INTO aoi_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Ababurna-langwa alarrngekburna narru-mangume-ka. Akwa wurrababurna-langwa wurridarringka akwa ngawa wurriyukwayuwa aburra-langwa narra-manguma. Akwa ngarningka eningerribirra alikira-langwa narru-mangume-ka wurrakina-da. ");
INSERT INTO aoi_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Umba eneja Jekaba ni-yama nakina wunalakina-kiya-wa Jimiyina akwa Libayu-wa, “Nungkwurnuwa yirrumini-ngekburakama awurrariya nganyangwa. Aduwaba-langwa aburraja warna WarningiKenina warnumamalya kabu-wirrikbiname-ka ngayuwa-wa. Aburrajukwaba WarninguBereja warnumamalya akwa ngawa warningerribirra warnumamalya enena-manja angalya kabu-wirrikbiname-ka,” ni-yama. “Wurrambawura wulkwa warna warnungkwarba nganyangwa-da. Kembirra wurruwurrakakina ke-yakeyina-manja kajungwa kab-awinyambakini-yada ngayuwa-manja, kemba akabu-jerrukwuname-ka ngakwurruwa-da,” ni-yama. ");
INSERT INTO aoi_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Aburnaja neni-yama wunalakina, “Nara amini-ngayinduma yinalakena dadiyamarnjarrka dakina e-yelijuma erribirra wurrakina-da, akwa aminakina-langwa yini-yamama yinalakina-da,” neni-yama Jekabu-wa nenu-maka-da. ");
INSERT INTO aoi_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Eneja nakina Neningikarrawara ni-yama Jekabu-wa, “Likaja arakba ena-wiya Bedelu-wa akwa k-ambilya yakwujina. Yakwujina ki-yar•diya-manja nungkuwa, kembirra ki-ngekburakinama alda nganyangwi-yada. Ngayuwe-ka ningena Ningeningikarrawara ningibina ningi-jadanguma nungkuwa-manja akini-yada ngawa ningki-lyumadu-manja nungkuwa nawena-langwa Yijawa-langwa,” ni-yama. ");
INSERT INTO aoi_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Eneja kembirra Jekaba ni-yengbinuma amurndakenena ayakwa ena-langwa-manja warnumamalya akwa ngawa wurrukwala-manja warnumamalya wurribina nuw-ambilyu-murrumanja enuwa-manja wurrakina. Ni-yama, “Wurru-wurriya akina akiringiringanda amalawudawarra amurndakijika nungkwurra-langwa, ebina kirru-manguma wurrukwala-langwa warnumamalya. W-ajarrijungwuna arakba, kembirra yik-awiyebena dumungkwur•da dumbala. ");
INSERT INTO aoi_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Aki-lalikinama ena angalya aki-likaji-yada Bedelu-wa. Yakwujina ki-ngekburakinama ngayuwa alda Neningikarrawara-langwa. Nakina-bina-da nginu-mamurikajuwama ngayuwa ningu-werrikawarriyadinu-manja ningibina. Ngayuwa-manja ngawa-da ni-likenuma Neningikarrawara-da amurndakibinu-wa angalya ngayuwa ningi-likenu-murruwa-da,” ni-yama Jekaba. ");
INSERT INTO aoi_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Kembirra aburraja nenu-kwa wurrakina Jekaba-manja amalawudawarra ababurna-langwa akwa ngawa amurndakijika eningumada-langwa amurndakibina nuw-awiyebeyinuma wurrakina mada-manja. Umba Jekaba nu-mungkadina edirra biya numurndaku-wurranga arrawu-wa ababurna-langwa biya ni-rungkwaba arakba arrawa akina. Ngalaja ebina edirra nu-mungkadinuma nakina Jekema-manja akwudangwa nuw-ambilyuma akina, ebina-manja akwurdukwurda eka arrawa. ");
INSERT INTO aoi_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Kembirra arakba aburraja Jekaba akwa warninikuwena ena-langwa nawurraki-likena wurrakina. Umba aburraja wurrababurna-langwa warnumamalya Jekema-manja iya akwala-manja angalya akwudangwa nawurrak-akbar•da wurrakina akwa na-waranguma wurrakina nara karra-larrmanga-da. ");
INSERT INTO aoi_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Aburraja kembirra Jekaba-murriya nuw-alilikenu...wa. Biya arakba Luja-manja nawurrak-ambarringa yakwujina. Akine-ka angalya Kenina-manja nuw-ambilyuma akena aduwaba ngarri-yengbijinama Bedela akina. ");
INSERT INTO aoi_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Biya ni-ngekburaka yakwujina alda angwarnda-murra. Biya ni-yengbijuwama angalya emikirra “Neningikarrawara NeninguBedela.” Nu-kwama akina emikirra mena arakba-wiya nakina Neningikarrawara n-abilyerrikajungwu-mubaba yakwujina enuwa-manja akini-yada ngawa ni-lyumadu-manja nawenikba-langwa nakina. ");
INSERT INTO aoi_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Ngalaja yingi-jungwa arakba Ribeka-langwa dadikuminuwar•duwar•da didarringka dadimikirra Debura. Aburraja kembirra narringa-wilyaka dadikijungwa adirrungwarnu-wa eka nuw-angkarrinu-murruwa arrirra dalada biya narringa-yindirruwarna dakina akina-manja eka arrawa. Biya akina eka Bedela-manja akwudangwa narri-yengbijuwama “Eka Nangwadeyinumurrumanja” emikirra. ");
INSERT INTO aoi_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Yakwujina ngawa Bedela-manja, ni-lawurradinu-mulangwa nakina Jekaba angaluba Mejibudamiya-langwa, eneja Neningikarrawara ni-jadinga nakina ngarningka enuwa-manja. Biya ni-yengbina eningaba ayakwa eningilyamarmba enuwa-wa. ");
INSERT INTO aoi_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Ni-yama Neningikarrawara nakina enuwa-wa, “Nungkuwa ningkena ningkenimikirra Jekaba umba aduwaba-langwa Yijireyila ngarningka ekirra nungkwa-langwa akina-da,” ni-yama nakina. Nenu-kwame-ka nakina enena ekirra enikaduwa Jekaba-manja ");
INSERT INTO aoi_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","biya ni-yama enuwa-wa, “Ngayuwe-ka ningena Ningeningikarrawara ningingbuda-dangwa. Nungkwaja ka-wilyakina ningkakina wurrababurna numirena-murriya warnikinikaduwa. Aburraja wurrakina kuw-ababurnadinama akwa ka-wurrakwulyumidadinama wurrilyimberrkwulyumida warnumamalya wurrilyimberrkeyebijeba iya wurrilyimberrkeyebijeba kuw-ambilya-murruwa arakba wurrumurndakakina. Umba aburraja wurrukwala wurrububungkawa wurrakina ka-bungkawadinama aburra-langwa-manja angalya. ");
INSERT INTO aoi_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Umba nganja yiba-kwunama angalya ebina ningenu-kwama adinuba-wiya Aburiyama-manja biya kembirra enamba-langwa Ajika-manja. Nungkuwa-manja yiba-kwunama aduwaba akwa ngawa warnikinikaduwa-manja numirena-murriya aburramba-langwa,” ni-yama Neningikarrawara Jekaba-manja-da. ");
INSERT INTO aoi_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Biya neni-lalika arakba-da. ");
INSERT INTO aoi_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Eneja kembirra Jekaba n-arjiyajuwa awilyaba-ma angwarnda kajungwa neniki-yakuwerribiki-yada nakina Neningikarrawara-langwa ayakwa. N-arjiyajuwama akina ebina-manja ngawa angalya Neningikarrawara ni-yengbinu-murrumanja enuwa-wa. Biya ni-jirabama amalyirra akwurena-langwa akwa ngawa aliba-langwa amalyirra yakwujina akina-manja angwarnda kajungwa akwurdukwurdi-yada ngawa akina-da. ");
INSERT INTO aoi_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Biya ni-yengbijuwama nakina akina angalya Bedela, mena akina ekirra Bedela ne-yaminama “alikira Neningikarrawara-langwa.” ");
INSERT INTO aoi_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Biya kembirra Jekaba akwa ena-langwa warnumamalya narri-lalikama akina angalya Bedela warniki-liki-yada wurrakina nuw-angkarrinu-murruwa arrirra dalada engembu-wa Eburadu-wa. Akena, nara-wiya karr-akburrangarna Eburada, ngalaja yingu-werribikajungwa arakba Rejila. Kembirra nuw-ambarringa arakba wurrakina wilyarra. Umba ying-arrkwujeyina angwurra dakina Rejila. ");
INSERT INTO aoi_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Ngalaja duwilyaba dadikuminuwar•duwar•da didarringka nanga-mamurikajuwa dakina. Akena ying-arrkwujeyina ngawa dakina Rejila angwurra. Kembirra dakina didarringka yingi-yama ngaluwa-wa, “Nara akbar•duma. Mungkwa-ba ngarningka naka niyukwujiya nenungkwarba,” yingi-yama. ");
INSERT INTO aoi_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Akena dadiki-jungwangeni-yada arakba dakina Rejila. Biya yingi-ngengkuwanginu-manja dakina eningilukwuniyawa arrirra yingini-yengbijuwama Benani nenimikirra, mena akina ekirra Benani ne-yaminama “naburraka nganyangwa-langwa awerrikawarriya.” Umba eneja nakina Jekaba neni-yengbijuwama nenikuwenikba Benjimina, mena akina ekirra Benjimina ne-yaminama “eningaba kenak-akburranginama nenikuwarrka.” ");
INSERT INTO aoi_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Kembirra yingi-jungwu-mulangwa dakina Rejila aburraja narringa-yindirruwarna dakina mulikarrkbidjina mamurukwa mibina numu-likajama angerriba Eburadu-wa. Adinuba-wiya Eburada narri-yengbijuwama emikirra angalya akina, umba narri-kuwarrukwajuwama emikirra, kembirra arakba Bediliyema akina emikirra angalya aduwaba. ");
INSERT INTO aoi_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Umba dibina narringa-yindirruwarnu-murrumanja eneja nakina Jekaba n-arjiyajuwa awilyaba-ma angwarnda yakwujina kajungwa kini-yakuwerribikaji-yada ngaluwa-wa. Kembirra akina ngawa aduwaba-da. ");
INSERT INTO aoi_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Biya kembirra Jekaba-murriya narru-makilalika akina angalya arakba umba na-likena engembu-wa Ederu-wa. Akina-manja angalya Edera ngalaja awilyaba-ma alikira alingajirrirra nuw-arjeyuma yakwujina. Biya narruwurraki-ngekburakama arakba aburra-langwa angalya alalubaja wurrakina-da. ");
INSERT INTO aoi_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Kembirra nuw-ambilyu-wiya Jekaba-murriya yakwujina, eneja nenikuwenikba Rubina nanga-rndarrka dadikuminuwar•duwar•da didarringka nungwenikba-langwa dibina Bilya. Eneja kembirra n-engkirrika nungwenikba ayakwa akina-langwa biya n-awinyambade-ka nakina-da. Umba aburraja wurrumemberrkwa wurrambilyuma warninikuwena Jekaba-langwa wurrakina n-akumakajungwunuma nakina. ");
INSERT INTO aoi_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Biya Liya-langwa wurrabuburrada warnimikirra Rubina, naruma-dangwa nenikuwenikba Jekaba-langwa, iya Jimiyina iya Libaya iya Juda iya Yijakara akwa ngawa Jebulina. ");
INSERT INTO aoi_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Umba aburnaja Rejila-langwa wunenimikirra-kiya Jawijiba iya Benjimina. ");
INSERT INTO aoi_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Umba aburnaja Rejila-langwa-langwa dadikuminuwar•duwar•da Bilya-langwa wunenimikirra-kiya Dena iya Nabudali. ");
INSERT INTO aoi_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Akwa ngawa wunalekbina Liya-langwa-langwa dadikuminuwar•duwar•da Jilba-langwa wunenimikirra-kiya aburnajukwaba Keda iya Ajera. Na-rukwurukwularreyinuma wurrakina warninikuwena Jekaba-langwa Mejubudamiya-manja ngawa wurrababurna-langwa-da. ");
INSERT INTO aoi_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Biya Jekaba-murriya nawurraki-likena arakba Ajiku-wa ebinu-wa angalya n-ambilyu-murruwa adinuba-wiya Aburiyama umba kembirra enamba-langwa nenikuwenikba Ajika. Emikirra angalya Mamura. Umba akwudangwa nuw-ambilyumurra engemba Yebirena. Biya yakwujina Ajika-manja ngawa nuw-ambilyuma arakba wurrakina. ");
INSERT INTO aoi_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","29","Umba nakine-ka Ajika n-eniyerringkadinuma arakba. Biya n-ambilyu-manja nakina Ajika 180 mamarika iya yinungkwura kembirra ni-jungwa. Aburnaja kembirra wunalakina warnikuwabulena Yijawa akwa ngawa Jekaba neni-yindirruwarnuma nakina-da. ");
INSERT INTO aoi_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Amurndakenena ekirra nuw-arrikarrijajungwunama Yijawa-langwa-langwa warninikuwena. Ambilyuma ekirra ena-langwa, awilyaba Yijawa umba awilyaba engka Yiduma akina. ");
INSERT INTO aoi_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Nenu-manguma nakina Yijawa wurridarringka WarningiKenina ena-langwi-yada wurradidingiyena. Duwilyaba dadingiyenikba ena-langwa dadimikirra Ada, dibina dadiyawenikba Elena-langwa. Nakine-ka Elena NeningiYida nenumamalya. Umba duwilyaba dingka dadingiyenikba Yijawa-langwa Awalibama dakina. Umba Awalibama dadiyawenikba Anaya-langwa dakina, umba numiradikba Jibiyena NeningiYiba nenumamalya nakina. ");
INSERT INTO aoi_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","Umba ngalaja duwilyaba dingka dadingiyenikba Yijawa-langwa dadimikirra Bajumada. Umba dakina Bajumada dadiyawenikba Yijumeyila-langwa umba darrkuwenikba Nubeyada-langwa dakina. ");
INSERT INTO aoi_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Ngalaja Ada yinginumin-arrangbama Yijawa-langwa nenikuwenikba nuwilyaba-ma Elibaja. Umba ngalaja Bajumada yinginumin-arrangbama nenikuwenikba Yijawa-langwa nuwilyaba-ma nenimikirra Ruwela. ");
INSERT INTO aoi_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Umba ngalaja Awalibama yinginumin-arrangbama wurrabiyakarbiya warninikuwena Yijawa-langwa. Wurrubukalakina warnimikirra Jeyija iya Jalama akwa ngawa Kawura. Wurrakine-ka warninikuwena Yijawa-langwa na-rukwularreyinuma Kenina-manja angalya wurrakina-da. ");
INSERT INTO aoi_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Eneja kembirra Yijawa ni-likena arakba nakina eminingku-wa angalya. Nenu-wilyakama nakina wurradidingiyena ena-langwa iya warninikuwena iya wurradidiyawena ena-langwa akwa aburrajukwaba wurrumurndakibina warnumamalya nuw-ambilyu-murrumurra enuwa-manja. Akwa nu-wilyakama ngarningka bulukwa-murriya iya amurndakijika-murriya amurndakibina nu-manguma nakina Kenina-manja. Ni-likenuma nakina engku-wa kajungwa wuneyebijebi-yada Jekaba-langwa kin-ambilyi-yada nakina, ");
INSERT INTO aoi_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","mena eyukwujiya-baba angalya wunalakina-kiya-langwa Yijawa-langwa iya Jekaba-langwa, akwa ababurna-baba bulukwa-murriya aburna-langwa-da. ");
INSERT INTO aoi_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Kembirra ni-likenuma nakina Yijawa Yidumu-wa, biya yakwujina angakingakarjiyinga-manja angalya n-ambilyuma-da ena-langwa warnumamalya aburruwa-da. ");
INSERT INTO aoi_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Nenungkwulyube-ka nakina Yijawa WarningiYiduma-langwa warnumamalya. Umba amurndakenena ekirra nuw-arrikarrijajungwunama ena-langwa-langwa wurrumirumirena warnikinikaduwa-langwa. ");
INSERT INTO aoi_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","14","Wurrumurndakeyena warninikuwena wurrumangbala Yijawa-langwa. Nuwilyaba nenimikirra Elibaja naburradikba Ada-langwa, umba nuwilyaba nenimikirra Ruwela naburradikba Bajumada-langwa, umba wurrabiyakarbiya wurrabuburrada Awalibama-langwa warnimikirra Jeyija iya Jalama akwa Kawura. Umba eneja nungwadikba Awalibama-langwa nenimikirra Anaya, umba eneja numiradikba nenimikirra Jibiyena. Umba wurrumurndakeyena warninikuwena wurrumangbala wurruwilyaba Elibaja-langwa warnimikirra Demena iya Awuma iya Jubawa iya Kadama iya Keneja akwa Amaleka. Umba Amaleka-langwa dirndenikba dadimikirra Dimina. Umba wurrumurndakeyena warninikuwena wurrubukabiyarbuwa Ruwela-langwa warnimikirra Neyada iya Jera iya Jama akwa Mija. ");
INSERT INTO aoi_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Eneja Yijawa nakina nenungkwulyuba wurruwurrakwulyumida-langwa warnumamalya. Eneja nenikuwenikba Elibaja nibina naruma-dangwa nungwarringbe-ka nakina warna-langwa wurrububungkawa. Warnimikirra wurrakina Demena iya Awuma iya Jubawa iya Keneja ");
INSERT INTO aoi_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","iya Kadama akwa Amaleka wurrakina-da. Umba ngalaja duminjarringba aburra-langwa Ada, dibina dadingiyenikba Yijawa-langwa dakina-da. ");
INSERT INTO aoi_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Umba Yijawa-langwa nenikuwenikba Ruwela nungwarringba nakina warna-langwa wurrubukubungkawa. Warnimikirra wurrubukalakina Neyada iya Jera iya Jama akwa Mija. Umba ngalaja duminjarringba aburrubukwurra-langwa Bajumada, dibina dadingiyenikba Yijawa-langwa dakina-da. ");
INSERT INTO aoi_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Umba Yijawa-langwa warninikuwena Jeyija iya Jalama akwa Kawura wurrubukalakina wurrubukubungkawa aburrubukwurrajukwaba. Umba ngalaja dirndarringba aburrubukwurra-langwa Awalibama, dibina dadingiyenikba Yijawa-langwa umba dadiyawenikba Anaya-langwa dakina-da. ");
INSERT INTO aoi_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Umba wurrumurndakakina kembirra warninikuwena akwa wurrumirumirena Yijawa-langwa wurrububungkawe-ka wurrakina wurrilyimberrkwulyumida-langwa warnumamalya, umba wurrilyimberrkeyebijeba iya wurrilyimberrkeyebijeba wurrakina-da. ");
INSERT INTO aoi_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Eneja nakina Jeyira NeningiYari nakina. Umba ena-langwa warninikuwena nuw-ambilyumurra wurrakina angakingakarjiyinga-manja angalya Yiduma. Warna warnimikirra aburra-langwa. Naruma-dangwa Ladena nakina iya Jawubala iya Jibiyena iya Anaya ");
INSERT INTO aoi_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","iya Dijina iya Ejera umba neningarija-langwa nakina Dijena. Warne-ka warninikuwena Jeyira-langwa wurrububungkawa WarningiYari-langwa warnumamalya Yiduma-manja angalya wurrakina-da. ");
INSERT INTO aoi_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Umba wunalakena wunambilyuma warnikuwabulena Ladena-langwa wunenimikirra-kiya Yari akwa ngawa Yemena. Ngalaja Ladena-langwa darrkuwenikba dadimikirra Dimina dakina-da. ");
INSERT INTO aoi_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Umba wurrumurndakeyena warninikuwena wurrumangbala Jawubala-langwa warnimikirra Albana iya Meniyada iya Ebela iya Jubawa akwa Awanama wurrakina-da. ");
INSERT INTO aoi_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Umba wunalakena wunambilyuma warnikuwabulena Jibiyena-langwa wunenimikirra Ayiya akwa ngawa Anaya. Umba Anaye-ka nakina-bina nenungkwarba n-akburrangama amukwa akungwa ardidarra akina-manja angalya nara-murrumanja warnumamalya kuw-ambilya. N-akburrangama akina nangawurrak-embirrajuwa-murrumanja nakina dangki nungwenikba-langwa-da. ");
INSERT INTO aoi_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Umba naka nenikuwenikba Anaya-langwa nenimikirra Dijina umba dadiyawenikba dadimikirra Awalibama. ");
INSERT INTO aoi_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Umba wurrubukalakena wurrubukabiyarbuwa warninikuwena Dijina-langwa warnimikirra Yemidena iya Ejibena iya Yidirena akwa Kerena. ");
INSERT INTO aoi_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Umba warna warninikuwena wurrubukabiyakarbiya Ejera-langwa. Warnimikirra Bilyena iya Jayabana akwa Akana wurrubukalakina-da. ");
INSERT INTO aoi_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Umba wunalakena wunambilyuma warnikuwabulena Dijena-langwa. Wunenimikirra Wija iya Arena wunalakina-da. ");
INSERT INTO aoi_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","30","Umba warne-ka warnungkwarba wurrububungkawa WarningiYari-langwa warnumamalya, Ladena iya Jawubala iya Jibiyena iya Anaya iya Dijina iya Ejera akwa ngawa Dijena. Nuw-ambilyuma wurrakina akina-manja angalya aringbirra-manja Yiduma. Umba wurreyebijeba na-bungkawadinuma aburra-langwa-manja warnumamalya wurrakina-da. ");
INSERT INTO aoi_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Nara-wiya wurribina wurrububungkawa wurrarumuruma Yijireyila-manja, aburraja kembirra warna wurrububungkawa wurrarumuruma namurndaku-bungkawadinuma wurrakina WarningiYiduma-manja warnumamalya akwa ne-yuweyinuma wurrakina. ");
INSERT INTO aoi_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Neningadinuba-wiya Bela, nenikuwenikba Biyawa-langwa, nu-bungkawadinuma nakina Yiduma-manja. Umba ena-langwa angalya aminababurna alikira iya warnumamalya Dinyaba akina. ");
INSERT INTO aoi_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Ni-jungwunu-mulangwa Bela, enamba-langwa kembirra Jawubaba, nenikuwenikba Jera-langwa, numa-manguma ena-langwa mamurukwa. Umba ena-langwa angalya Bajiraya akina. ");
INSERT INTO aoi_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Ni-jungwunu-mulangwa Jawubaba, enamba-langwa kembirra Yajama NeningiDemena numa-manguma ena-langwa mamurukwa akwa nu-bungkawadinuma nakina. ");
INSERT INTO aoi_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Ni-jungwunu-mulangwa Yajama, enamba-langwa kembirra Yadada, nenikuwenikba Budada-langwa, nu-bungkawadinuma nakina. Umba ena-langwa angalya aminababurna alikira iya warnumamalya Abuda akina. Umba na-wardiyinu-manja Yadada akwa WarninguMidiyena warnumamalya akina-manja angalya Mawaba, aburraja Yadada-langwa warnungkwarba wurrawinyamba na-minangkirraja wurrumurndakakina WarninguMidiyena warnumamalya wurrakina. ");
INSERT INTO aoi_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Ni-jungwunu-mulangwa Yadada, enamba-langwa kembirra Jamula NeninguMajireka nu-bungkawadinuma nakina. ");
INSERT INTO aoi_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Ni-jungwunu-mulangwa Jamula, enamba-langwa kembirra Jawula nu-bungkawadinuma nakina. Ena-langwa angalya Riyabada adalyuma-manja nuw-ambilyumurra akina. ");
INSERT INTO aoi_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Ni-jungwunu-mulangwa Jawula, enamba-langwa kembirra Bali-Yenana, nenikuwenikba Akbawa-langwa, nu-bungkawadinuma nakina. ");
INSERT INTO aoi_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Ni-jungwunu-mulangwa Bali-Yenana, enamba-langwa kembirra Yadada NeninguBawa nu-bungkawadinuma nakina. Ngalaja Yadada-langwa dadingiyenikba dadimikirra Miyedabela. Umba eneja nungwadikba ngala-langwa Madireda, umba eneja numiradikba nenimikirra Mejeyeba nakina. ");
INSERT INTO aoi_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Eneja nenungkwulyube-ka nakina Yijawa wurrababurna-langwa WarningiYiduma warnumamalya. Umba wurrumurndakenena wurrububungkawa aburra-langwa, warnimikirra Dimina iya Alba iya Jededa ");
INSERT INTO aoi_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","iya Awalibama iya Ela iya Binana ");
INSERT INTO aoi_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","iya Keneja iya Demena iya Mibijara ");
INSERT INTO aoi_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","iya Makidiyela akwa ngawa Yirama. Umba aburra-langwa angalya ne-yengbijajungwunuma amurndakakina aburra-langwa-langwiya ekirra amamalya-langwiya akina-da. ");
INSERT INTO aoi_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Eneje-ka Jekaba nakina n-ambilyumurra yakwujina ngawa Kenina-manja angalya n-ambilyu-murrumanja nungwenikba adinuba-wiya nakina. ");
INSERT INTO aoi_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Enena kembirra alawudawarra ena-langwa-langwa warnumamalya. Eneje-ka nakina Jawijiba mememberrkwa mamangbala mambilyuma mamarika iya yinungkwura n-ambilyumurra arakba. Kembirra Jawijiba akwa ena-langwa wurrukwala wurrarrkwurrkuwena narr-embirrajuwama wurrakina jiba iya nenukwuda nungwarringba-langwa. Umba aburringaja wurrumurndakakina-langwa wurrirndirndarrngwa Bilya akwa Jilba, Jekaba-langwa wurradingabulena-kiya wurringalakina. Kembirra ena-langwa wurrarrkwurrkuwena nuw-arriyakajungwunu-manja awurruwurrariya-langwa, eneja ni-likenuma Jawijiba nakina Jekabu-wa akwa nenu-makama nungwenikba-manja akina-langwa awurrariya. ");
INSERT INTO aoi_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Umba eneja Jawijiba-langwa nungwenikba Jekaba Jawijiba-manja angwurra nakina ni-lyelyingminuma, mena ni-rukwularruma nakina n-eniyuwangkwudinu-manja nungwenikba. Kembirra Jekaba nakina nenuminu-warrkame-ka dukwulyubena dilingajirrirra dumbala Jawijiba-langwa. ");
INSERT INTO aoi_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Akena aburraja neni-rringkama wurrakina wurrarrkwurrkuwena nungwarringba nakina angwurra ni-lyelyingminuma Jawijiba-manja, kembirra nenu-wirrikbama wurrakina angwurra Jawijibu-wa. Nara arakba ke-yengbina amarngkuwarruwalya ayakwa enuwa-wa-da. ");
INSERT INTO aoi_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Muwilyaba-manja meningalyarrngwalyilya marringa eneja nakina Jawijiba ni-lyangburarrkinuma akwulyangburarrka. Kembirra nenuwurraku-makama wurrarrkwurrkuwena-manja akina-langwa akwulyangburarrka. Akena aminakina-langwa angwurra ngawa nenu-wirrikbama aburraja wurrakina kembirra ngarningka-da. ");
INSERT INTO aoi_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Eneja ni-yama nakina Jawijiba aburruwa-wa, “W-engkirraja-langwa enena akwulyangburarrka ningi-lyangburarrkinuma ngayuwa,” ni-yama. ");
INSERT INTO aoi_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","“Ngarrakine-ka ngarrababurna-langwa ngarruwurraku-war•danguma warka errekba-manja. Ngarruwurraki-lamiranguma arakba merra-ma eninganinga amarda ebina ngarri-ngkarrngarnuma adinuba-wiya. Akena adirrariyaba ngalaja nganyangwa amarda akina na-kuwarjiyingama umba nungkwurra-langwa na-ngwurrkwarrngarnuma nganyangwa-manja. Kembirra amurndakakina nungkwurra-langwa nawurrak-abuluwenduma umba nganyangwa eyirrbiyirrba ngawa na-kuwarjeyuma akina-da. Nawurrak-abuluwenduma akina nungkwurra-langwa mena eningma nganyangwa amarda aruma akina amikbiyiya alyengma-da,” ni-yama Jawijiba nakina-da. ");
INSERT INTO aoi_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Aburraja wurrarrkwurrkuwena ne-yama wurrakina enuwa-wa, “Kembirra ningki-lyangkiyaminama ningkakina ku-bungkawadinama yirruwa-manja-na!” ne-yama. Kembirra ngarningka ngawa wurrakina nenu-wirrikbama angwurra akina-langwa akwulyangburarrka akwa warningma-baba wurrakina ni-likenuma nakina nenikumarnjarringba nungwarringba-wa akwa nenu-makama nakina-manja ebina-langwa awurrariya nuw-arriyakajungwunu-mulangwa. ");
INSERT INTO aoi_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Bi...ya ambaka-murra ngarningka eneja ni-lyangburarrkinuma nakina Jawijiba, akwa nenuwurraku-makama ngarningka wurrakinu-wa wurrarrkwurrkuwena. “Ngarningke-ka ningena ningi-lyangburarrkinuma awilyaba akwulyangburarrka,” ni-yama. “Ngalaja mamawura akwa ngawa yimawura akwa dakilyingajanga dumemberrkwa duwilyaba nawurrak-abuluwenduma akina ngayuwa-manja,” ni-yama. ");
INSERT INTO aoi_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Akwa ngarningka nenu-makama ngawa nungwenikba-manja nakina-da. Eneja nakine-ka nungwenikba n-awinyambada arakba nenikuwenikba-manja. “Amiyambene-ka akina akwulyangburarrka ningki-lyangburarrkinuma?” ni-yama nakina. “Ningki-lyangkiyaminama ningkakina ngayuwa iya dirndena akwa narrkuwena-murriya yiki-likajama yarna yik-abuluwendama nungkuwa-manja-na?” ni-yama. ");
INSERT INTO aoi_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Kembirra aburraja wurrumurndakakine-ka wurrarrkwurrkuwena namurndaki-yakwujaminuma enuwa-langwa umba eneja nungwenikba n-engkirrikenuma ngawa alakina-kiya-wa akwulyangburarrka nakina-da. ");
INSERT INTO aoi_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Akini-yada ngawa Jekaba akwa ena-langwa warninikuwena nuw-ambilyumurra wurrakina ekbilyuwalya-manja angalya emikirra Yebirena. Biya Jawijiba-langwa wurrarrkwurrkuwena na-likenuma wurrakina Jekemu-wa. Yakwujina narruwurrak-akwurrajuwama nungwarringba-langwa jiba iya nenukwuda. ");
INSERT INTO aoi_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Eneja kembirra nungwenikba nenu-maka nakina Jawijiba-manja, “Ki-likajama ningkena nungkwajukwaba Jekemu-wa. Wurrakina narrkuwena-murriya narruwurrak-akwurrajinama jiba iya nenukwuda yakwujina,” ni-yama. Eneja ni-yama Jawijiba, “Yawa, ki-likajama ningena.” ");
INSERT INTO aoi_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Eneja ni-yama Jekaba, “Ki-likajama ningkena. Kamurndaki-ngarrenama narrkuwena-murriya warningaba-murrikba akwa amurndakakina jiba iya nenukwuda eningaba-murrikba. Akwa ki-lawurradina-manja yangkwurrangwa, kwa yiku-makina.” Biya nakina Jekaba neni-larrkama nakina Jawijiba. Eneja kembirra ni-likenuma nakina Jekemu-wa. ");
INSERT INTO aoi_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","Biya nu-marrawarnume-ka n-abuburangkeyinuma ngawa wurrarrkwurrkuwenu-wa. Eneja nuwilyaba nenumamalya neni-rringkama nakina akwa kembirra ni-yama, “Miyambenu-wa ningkena ningk-aburangkeyinama?” ni-yama nakina. ");
INSERT INTO aoi_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","“Ningene-ka ning-aburangkeyinama nganyangwu-wa nawarrka-murriya,” ni-yama eneja Jawijiba. “Wurrakine-ka narruwurrak-akwurrajinama jiba iya nenukwuda aburra-langwa. Nungkwaja ningkeningma-manja ningkakina angalya ebina-manja nuw-ambilya-murrumanja wurrumurndakakina, aba yiku-makina,” ni-yama. ");
INSERT INTO aoi_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","“Yawa,” ni-yama eneja. “Yelakwe-ka warna akena arakba na-likena. Nganja ning-engkirrikenuma wurrakina na-lyelyimbukweyinuma yelakwa warniki-liki-yada engembu-wa Dawudinu-wa,” ni-yama. Kembirra enejukwaba Jawijiba ni-likena nakina Dawudinu-wa-da. Biya kembirra nenuwurrak-akburranga wurrakina ena-langwa wurrarrkwurrkuwena yakwujina ngawa. ");
INSERT INTO aoi_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Umba ni-likenu-wiya nakina ambaka awilyikerra, aburraja nuw-andeya wurrakina akena neni-rringka ni-likenuma nubukwaya awilyikerra-langwiya. Kembirra wurrakina na-lyangkuwerribikajungwunuma adinakba neniku-wardi-yada nakina nenikumarnjarringba. ");
INSERT INTO aoi_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Biya na-makijeyina wurrakina. “Nubukwaye-ka nibina nakwulyangburarrka-ma nenumamalya,” namurndaki-yama. ");
INSERT INTO aoi_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","“Kwa kembirra, ngeni-ngajina nakina akwa ak-errikbina nenumadangkwa engburingka-wa emedirra,” ne-yama. “Kembirra aka-makinama ngarna warnumamalya-manja nenu-wardangu-mulangwa yiningerriberriba yiningbala,” ne-yama wurrakina. “Kembirra ak-eningmidinama ngarna ena-langwa-langwa akwulyangburarrka amandangwa-murrikba akina,” ne-yama wurrakina-da. ");
INSERT INTO aoi_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Akena eneja nibina naruma-dangwa ena-langwa nawenikba n-engkirrikena ayakwa aburra-langwa akwa neni-ngayindanguma nakina Jawijiba neniba nenik-ambilyinga. Nenimikirra Rubina nakina. Ni-yama wurrukwalu-wa, “Nara ngarna a-ngajuma naka ");
INSERT INTO aoi_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","a-lyandijuma umba ngenu-mena akwa ngarr-errikbina enenu-wa engburingka emedirra. Akini-lalikinama kembirra enena-manja angalya nara-murrumanja warnumamalya-da,” ni-yama nakina. Akena ni-lyangkiyama nakina, “Ningene-ka kinu-menama naka ambaka arija-langwa-da enena-langwa engburingka emedirra-da. Kembirra kini-lawurrakajinama nungwenikba-wa-da,” ni-yama nakina Rubina-da. ");
INSERT INTO aoi_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Eneja kembirra Jawijiba nakina nubukwaya ni-likena n-akwudangwukajungwa akwa nen-akburranga wurrarrkwurrkuwena-manja. Umba aburraja nenu-murrakajuwa wurrakina dibina dumbala dilingajirrirra dukwulyubena ena-langwa ");
INSERT INTO aoi_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","akwa neni-rndarrka nakina akwa nuw-errikba angerriba ebinu-wa engburingka emedirra-da. ");
INSERT INTO aoi_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Kembirra nuw-angmakayanga arakba wurrakina akwa ne-yebukeyina aninga wurrakina-da. Biya ne-yebukeyinu-wiya ngawa wurrakina aninga, narrawurraki-rringka wurrubukwaya wurrukwala WarningiYijumeyila warnumamalya na-likenuma erribaba. Wurrakine-ka na-likenuma angaluba engemba-langwa Kiliyada-langwa akwa angwurra ka-likajama angerriba Yijibu-wa. Kamila-ma na-likenuma akwa narruwurraku-warakama bungabungwa amalyirra iya amangwarra-murriya akwa amukwarnjirrema Yijibu-wa, kajungwa warniku-kwi-yada amurndakakina wurruminakina-manja angalya, warniki-rndirrki-yada angwarnda. ");
INSERT INTO aoi_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","27","Akena eneja nuwilyaba narrkuwarringba nenimikirra Juda ni-yengbina nakina ayakwa wurrumurndakakina-manja wurrarrkwurrkuwena. “Wayi!” ni-yama. “Ngarra-kwuna naka Jawijiba wurrumurndakangaba-manja warnumamalya kajungwa aka-yukwamajini-yada angwarnda. Akini-ngajina-manja naka kembirra nara ngarna a-manguma angwarnda-da. Kembirra mena-burra naka akini-ngajina akwa akin-abuwarrkina nenumadangkwa? Nake-ka ngakwurra-langwa nenikumarnjarrka,” ni-yama Juda nakina-da. Aburraja na-lyangkuwama-da. ");
INSERT INTO aoi_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Aburraja kembirra ne-yar•da arakba wurrumurndakakina WarningiYijumeyila warnumamalya nuw-embirrarinu-murrumanja Juda-murriya. Umba wurrumurndakakine-ka warnumamalya wurruminambilyuma ekirra wurrakina. WarningiYijumeyila warnimikirra akwa ngawa WarninguMidiyena warnimikirra warnumamalya wurrakina. Aburraja kembirra Juda-murriya na-likena ebinu-wa engburingka emedirra, nen-ambijangajuwa nakina Jawijiba akwa narra-kwa nakina wurrumurndakakinu-wa warnumamalya. Kembirra aburraja arrkala narra-kwama arngkumemberrkwa-ma arngkambilyuma angwarnda wurrakina nakina-murrada. Biya wurrumurndakakina warnumamalya nenu-wilyakama nakina Jawijiba engku-wa Yijibu-wa arakba wurrakina-da. ");
INSERT INTO aoi_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","30","Akena wurrarrkwurrkuwena narra-kwa-manja Jawijiba wurrumurndakakinu-wa warnumamalya, eneja Rubina nara nibina kin-ambilya yakwujina. Biya kembirra ni-lawurradina nakina aburruwa-wa akwa ni-likena ebinu-wa engburingka emedirra. N-andeya nakina akena nara nibina Jawijiba keni-rringka kin-ambilya yakwujina akina-manja engburingka emedirra. Nakine-ka nangamurndaku-kuwarranguma ena-langwa dumbala dibina n-awiyebenuma mena nu-werrikawarriyadume-ka angwurra. “Nare-ka nibina enena-manja emedirra-da!” ni-yama. “Ki-yamarrkiname-ka kembirra ningena ngayuwa?” ni-yama. ");
INSERT INTO aoi_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Aburraja kembirra wurrakina wurrarrkwurrkuwena narru-wardanga nenukwuda akwa kembirra narruma-manga wurrakina merra akina-langwa nenukwuda akwa ngawa narring-enjalkingambajuwa dibina dumbala Jawijiba-langwa mibina-murra merra-da. ");
INSERT INTO aoi_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Bi...ya kembirra na-lawurradina arakba wurrakina angalyu-wa akwa narringa-lawurrakajuwa dibina dumerra-ma dumbala nungwarringba-wa. “Daka yirring-akburrangama dumbala. Jerriya daka Jawijiba-langwa dumbala?” ne-yama wurrakina-da. ");
INSERT INTO aoi_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Eneja kembirra nakina Jekaba nanga-rringka dakina akwa nanga-miringka Jawijiba-langwa dakina dumbala. “Yawa, ena-langwe-ka daka. Nenu-wardangume-ka kembirra yiningerriberriba yiningbala-da,” ni-yama nakina neniyuwangkwa. “Nenu-kuwarranguma arakba nakina-da,” ni-yama. ");
INSERT INTO aoi_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Nu-werrikawarriyadinume-ka nakina biya nangamurndaku-kuwarranguma dumbala dibina n-awiyebenuma. Kembirra n-awiyebena duwurrariya dumbala dibina narringa-warrkama amangwurrajija nenukwuda-langwa-murra. Ni-jakawaranguma ngawa nenikuwenikba-wa nenungkwurakba. ");
INSERT INTO aoi_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Nakinu-wa arakba na-likenuma aburraja ena-langwa warninikuwena iya wurradidiyawena neni-yekirrerrikama kwureya akena nara wurrakina keni-ngengmarngkajuwa. Eneja ni-yama, “Ki-likaja-manja ngayuwa warninikijungwa-langwu-wa angalya, ngarningka ngawa ki-jakawarenama ningeningangkawura ngawa-da,” ni-yama nakina. Kembirra ni-jakawarangume-ka nakina neniyuwangkwa niyirrbiyirrba ngawa-da. ");
INSERT INTO aoi_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Aburraja wurrumurndakibina WarninguMidiyena warnungkwarba ne-beyindangu-mulangwa nibina Jawijiba kembirra nenu-wilyakama nakina Yijibu-wa. Akina-manja angalya Yijiba n-ambilyume-ka eneja nuwilyaba naruma nubungkawa nibina ni-lyingama akina angalya aringbirra Yijiba. Umba nuw-ambilyuma ngarningka aburrajukwaba wurrababurna wurrububungkawa wurriyukwayuwa ena-langwa wurruminakina ngawa angalya. Aburraja kembirra wurrumurndakibina warnungkwarba nenu-wilyaka-murruwiya Jawijiba Yijibu-wa nenu-kwama nakina nuwilyabu-wa nubungkawa niyukwujiya-wa nenimikirra Badiba. Kembirra arrkala nenu-kwama eneja nakina Badiba angwarnda nakina-murrada wurrumurndakakinu-wa warnungkwarba. Nakine-ka Badiba nu-bungkawadinuma nakina wurrawinyamba-manja narr-akukwurrajuwa-murrumanja alikira naruma-langwa nubungkawa. ");
INSERT INTO aoi_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Akini-yada ngawa eneja nakina Juda neni-lalikama arakba ena-langwa wurrarrkwurrkuwena akwa ni-likenumurra nakina nuwilyabu-wa nenungkwarba Yira nenimikirra, kajungwa nenik-ambilyingi-yada nakina enuwa-manja ena-langwa-manja angalya emikirra Adilama. Wunalakina-kiya Juda akwa Yira aburnuwa-murra wunalakina. ");
INSERT INTO aoi_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Biya yakwujina akina-manja ngawa angalya nakina Juda nang-akburrangarna duwilyaba dadiyara dibina DadingiKenina. Umba eneja nungwadikba nenimikirra Juwa. Eneja kembirra nanga-manga arakba nakina Juda dakina dadiyara ena-langwi-yada dadingiyenikba. ");
INSERT INTO aoi_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Ngalaja kembirra yinginumin-arrangba arakba dakina nangariya ena-langwa. Kembirra eneja nungwenikba neni-yengbijuwamurra nakina niyukwujiya Era. ");
INSERT INTO aoi_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Ambaka-murra kembirra ngarningka yingu-mambakinuma dakina akwa yinginumin-arrangbama ngarningka nangariya Juda-langwa akwa yingini-yengbijuwama nakina Anana. ");
INSERT INTO aoi_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Bi...ya kembirra ambaka-murra ngarningka yinginumin-arrangbama nangariya nibina yingini-yengbijuwama Jela nakina. Akena ni-rukwularrinu-manja nakina numurrkbalya eneja n-ambilyumurra nungwenikba Juda eminingka-manja angalya emikirra Akijiba. ");
INSERT INTO aoi_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Eneja kembirra n-arumidinumurra Era nibina naruma-dangwa nenikuwenikba Juda-langwa nakina. Kembirra nanga-manga eneja nungwenikba duwilyaba dadiyara dadimikirra Damara nenikuwenikba-langwi-yada dadingiyenikba. ");
INSERT INTO aoi_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Akena nuwurrariye-ka eneja nakina Era. Ni-yaminjamama nakina awurruwurrariya ngawa. Eneja kembirra Yaweya nu-wara arakba nakina amurndakakina awurruwurrariya akwa neni-jungwajuwama arakba nakina nenumamalya-da. ");
INSERT INTO aoi_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Eneja kembirra nungwenikba Juda ni-yengbinuma nakina ayakwa Era-langwa-manja nenikumarnjenikba nibina nenimikirra Anana. Ni-yama nakina Juda enuwa-wa, “Ni-jungwuma arakba nawena, umba jeyi, likaja arakba dibinu-wa dadingiyenikba dingaya, akwa yikingu-mungkwula yakwujina, kajungwa kinumin-akumajungwuni-yada nungkuwa wurriyukwayuwa ena-langwi-yada. Kembirra nungkuwa ningkakina kinumin-arumurrkwuni-yada wurrakina wurriyukwayuwa ena-langwi-yada,” ni-yama Juda nenikuwenikba-wa Ananu-wa. ");
INSERT INTO aoi_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Akena eneja nakine-ka Anana ni-lyangkumakajungwunuma. “K-akumajungwuna-manja ngayuwa wurriyukwayuwa daka-manja dingaya,” ni-yama, “kembirra nara nganyangwa wurrakina umba nenikijungwa-langwa kuw-ambilyamurra wurrakina-da,” ni-yama Anana nakina. Kembirra ni-likenu-manja dibinu-wa dingaya akwa nenu-mungkwulu-manja wunalakina, nare-ka keni-ngayindanga nakina wurriyukwayuwa nawenikba-langwa. Kembirra numa-kwularrijuwa mamungwurra ena-langwa ajiringka-wa nakina akwa nara kembirra kininga-ngbadika dakina-manja dingaya Damara-da. ");
INSERT INTO aoi_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Akena eneja nakine-ka Yaweya nu-wara akina, akwa kembirra neni-jungwajuma enejukwaba Anana wuburra adinuba-wiya neni-jungwajuwama nakina nawenikba Era. ");
INSERT INTO aoi_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Eneja kembirra nuwilyaba-ma yimbukwa nenikuwenikba Juda-langwa arakba. Wunambilyuma neni-jungweyinuma arakba, umba nuwilyaba-ma wulkwa n-ambilyuma neniba ngawa nakina. Aminakina-langwa n-akbar•danguma eneja nakina Juda kini-jungwuna-mulangwa nenikuwenikba Jela, wuburra wunalakina-kiya warnikuwabulena-kiya wunaruma-kiya neni-jungweyinuma. Biya kembirra ni-yengbina Juda ayakwa dibina-manja dingaya darngkiyenikba dadimikirra Damara. Ni-yama nakina ngaluwa-wa, “Jeyi! Likaja arakba nungwena-langwu-wa alikira akwa k-ambilya yakwujina ningkingaya ngawa,” ni-yama. “Umba kin-arumida-manja nenikuwarrka niyukwujiya nibina nenimikirra Jela, kembirra ambaka-murra yikini-yakeyinama kinalakina,” ni-yama Juda. Kembirra ngalaja yingi-lawurradina Damara dakwukawura arakba nungwadikba-langwu-wa angalya-da. ");
INSERT INTO aoi_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Ambaka-murra dadingiyenikba Juda-langwa yingi-jungwuma dakina ngalajukwaba. Eneja kembirra nu-werrikawarriyadume-ka nakina Juda, akwa n-ambilyumurra awilyaba-manja ngawa angalya. Biya kembirra ni-jadanga arakba nakina. Biya ni-lyangkuwerribikajungwunuma neniki-liki-yada angerriba eminingku-wa angalya emikirra Dimina, mena ena-langwa jiba nuw-ambilyu-mubaba yakwujina akina-manja angalya. Kembirra ni-likena arakba nakina akwa ngawa nibina Yira enejukwaba mena aburnuwa-murra-baba wunalakina. ");
INSERT INTO aoi_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Aburraja kembirra wurrukwala warnumamalya ne-yama wurrakina Damara-wa, “Nubukwaye-ka narngkiyena Juda. Ni-likajama nakina Dimina-wa kajungwa neniki-ngkarrngi-yada amangwurrajija ena-langwa-langwa jiba,” ne-yama wurrakina. ");
INSERT INTO aoi_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Ngalaja Damara dadingme-ka dakina nibina Jela nenikuwenikba niyukwujiya-dangwa Juda-langwa n-arumidinuma arakba nakina. Umba eneja nakina Juda nara ngawa kininga-kwa nakina ngaluwa-wa ngala-langwi-yada neningiyadikba. Nare-ka nakina Juda kini-yarrkiyuwarna ayakwa ena-langwa. Umba ngalaja Damara ying-awiyuwiyebenuma ngawa dadingingaya-langwa dumbala. Biya kembirra nang-aburawaka arakba dakina umba ying-awiyebena diminingka dumbala, akwa ying-awiyebenuma ngarningka dumbala dadiki-lyawurumba. Biya yingi-likena dakina engembu-wa Eneyimu-wa akwa ying-ambarringa arakba akawiyuwiyeba-manja akwudangwa. Ngalaje-ka akina angalya Eneyima nuw-ambilyumurra mibina-manja ngawa mamurukwa numu-likenu-murrumanja Dimina-wa. ");
INSERT INTO aoi_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Bi...ya kembirra yakwujina ngawa eneja nanga-rringkama arakba Juda nakina. Ni-lyangkiyame-ka nakina duwurrariya-bu didarringka dakina, dibina yingu-mungkumungkwulume-ka warningerribirra-manja warnungkwarba akwa yingi-ngbijanginumurra wurringku-wa iya wurringku-wa warnungkwarba dakina-da, mena ying-awiyebenuma dibina dumbala dadiki-lyawurumba dakina-da. Aburraja ne-yaminjamama wurramukwiyadebina wurruwurrariya wurrididarringka wurruminakina angalya wurrakina-da. ");
INSERT INTO aoi_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Aminakina-langwa kembirra neningbale-ka eneja Juda darngkiyenikba Damara dakina-da. Biya ni-likena nakina Juda ngaluwa-wa ying-ambarringu-murruwa dakina mulikarrkbidjina-manja mamurukwa. Ni-yama nakina, “Kwa. Ambarrngarna angwarnda ningki-ngayindena ningkakina?” ni-yama. Umba ngalaja yingi-yama, “Amiyambena yiku-kwunama nungkuwa?” ");
INSERT INTO aoi_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Ni-yama eneja, “Ki-larrkajama ningena arija-langwa angariya nenukwuda.” “Yawa,” yingi-yama. “Umba yu-kwa-langwa enena-wiya awilyaba eyukwujiya eningerribirra nungkwa-langwa-langwa kajungwa ku-wilyakini-yada ngayuwa yiku-kwuna-murruwa ebina nenukwuda, nari-yada e-yakuwabijuma ningkakina,” yingi-yama Damara. ");
INSERT INTO aoi_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","“Amiyambena kembirra eningaduwaya yiba-kwunama aduwaba?” ni-yama eneja. Yingi-yama ngalaja, “Angaba amakirnda nungkwa-langwa ebina emikirra-murra, akwa ngawa eka arnduwarra ebina ningku-wilyakinama ningkakina,” yingi-yama. Eneja nanga-kwa kembirra arakba nakina alakina-kiya ambilyuma. Biya nenu-mungkwula wunalakina arakba-da akwa nanga-ngbadika dakina-manja-da. ");
INSERT INTO aoi_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Ngalaja kembirra arakba yingi-lawurradina angalyu-wa dakina Damara. Biya nang-aburawaka dakina dibina dumbala dadiki-lyawurumba, akwa ying-awiyebena ngarningka dumbala dadingingaya-langwa arakba-da. ");
INSERT INTO aoi_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Eneja kembirra nakina Juda nenu-kwa awilyaba angariya nenukwuda nibinu-wa nenungkwarba aburnuwa-murru-wa Yira. Ni-yama nakina enuwa-wa, “Nga-yikaja ena dibinu-wa didarringka akwa yimin-angkirna ebina eka akwa ngawa amakirnda ebina emikirra-murra ninginga-kwama ebina-wiya,” ni-yama. Kembirra eneja ni-likena Yira ebinu-wa angalya Eneyima, akena nara kining-akburrangarna dibina didarringka. ");
INSERT INTO aoi_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Ni-yama kembirra nakina Yira wurrukwalu-wa warnungkwarba wurruminakinu-wa angalya, “Dangamba dibina didarringka duwurrariya dibina ying-angmakwulaluma mulikarrkbidjina-manja mamurukwa?” ni-yama. Aburraja ne-yama, “Nara wurribina kuw-ambambilya wurruwurrariya wurridarringka ena-manja angalya wurribina na-mungkumungkwuluma warningerribirra-manja warnungkwarba. Akwa nare-ka wurribina yelakwa aduwaba-da,” ne-yama. ");
INSERT INTO aoi_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Kembirra eneja nakina aburnuwa-murra Juda ni-lawurradina arakba enuwa-wa, akwa ni-yama, “Nare-ka king-akburrangarna dibina didarringka-da,” ni-yama. “Aburraja wurrumurndakakina wurruminakina angalya bu-makama, ‘Nare-ka wurribina wurramukwiyadakina wurridarringka wurruwurrariya ena-manja angalya-da,’ namurndaki-yama wurrakina-da,” ni-yama Yira nenu-maka Juda-wa. ");
INSERT INTO aoi_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Eneja ni-yama Juda, “Akumurndak-ambilya kembirra ngaluwa-manja ebina amurndakijika, mena nara yakuwa a-ngayinduma a-rinjarrkuma wurrukwala warnumamalya yakuwa-wa-da. Ningi-ngayindanguma ningeniku-kwi-yada nenukwuda ngaluwa-manja akena nara ningkakina king-akburrangarna-da,” ni-yama Juda nakina-da. ");
INSERT INTO aoi_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Bi...ya ngalaja yabiyakarbiya yimawura nu-merrkijerriduma arakba yakina. Aburraja kembirra wurrukwala warnumamalya ne-yama wurrakina Juda-manja, “Nungkwa-langwe-ka darngkiyena duwurrariye-ka dakina-da. Yingu-mungkwulijeyinuma erribirra dakina, biya arakba yingi-ngbadinamurra dakina-da,” ne-yama wurrakina-da. Ni-yama eneja Juda, “Wurringa-wilyakina kembirra angwura-wa akwa yikinga-dakina kingi-jungwuna,” ni-yama. ");
INSERT INTO aoi_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Aburraja kembirra narringa-wilyaka warniki-daki-yada dakina akena ngalaja yingi-larrkena ena-langwa amurndakijika wilyarra-langwa narngkiyadikba-wa. Akwa enena ayakwa ngarningka yingi-larrkenuma dakina enuwa-wa. Yingi-yama, “Ningu-mambakinama aduwaba wurrangariya akena nungkwaja alakena-kiya amurndakijika yimini-rringka-langwa,” yingi-yama. “Angkaburra-langwa dukwa ena?” yingi-yama dakina. “Alakena-kiya amurndakijika nginu-kwama ngayuwa-wa eneja nakina nenungkwarba nibina ngini-ngbadikama ngayuwa-da,” yingi-yama Damara-da. ");
INSERT INTO aoi_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Eneja Juda nakina ni-rringka-manja alakina-kiya amurndakijika, kembirra ni-yama, “Nganyangwa amandangwa ena-da. Nara kinga-kwa nenikuwarrka Jela dakina didarringka-da. Kinga-kwa-maka nenikuwarrka ngaluwa-wa akena nara kinga-kwa. Nganyangwe-ka kembirra awurrariya akina. Nara ngala-langwa,” ni-yama nakina. Biya nara arakba ngarningka kenu-mungkwula wunalakina Juda akwa Damara-da. ");
INSERT INTO aoi_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Bi...ya akwudangwa arakba aburraja warniki-rukwularri-yada wurrangariya Damara-langwa akena wurrambilyume-ka wurrangariya-kiya ngala-langwa. ");
INSERT INTO aoi_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Ngalaja kembirra yingu-werribikajungwa arakba dakina. Biya wurruwilyaba narri-jadijuwama ayarrka. Ngalaja dibina didarringka nanga-mamurikajuwama Damara-manja yingi-rndarrka ayarrka ebina akwa yingi-lamiranga dumilyingarradada-murra dadumakirnda, kajungwa dadingmi-yada arija-langwa warningadinuba-wiya wurrakina. Biya yingi-yama, “Warna-bina na-rukwularruma adinuba-wiya-da,” yingi-yama dakina-da. ");
INSERT INTO aoi_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Akena eneja n-awiyebajuwa arakba ayarrka nakina numurrkbalya. Umba eneja ningka-dangwa ni-jadanga ni-rukwularrinuma adinuba-wiya nakina-da. Kembirra dibina didarringka yingi-yama enuwa-wa, “Wa! Ningkabakiya-be-ka ningki-jadanguma-na!” yingi-yama. Kembirra aburraja neni-yengbijuwama nakina Bereja, mena akina ekirra Bereja ne-yaminama “enabakiya-ba ni-jadanguma.” ");
INSERT INTO aoi_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Kembirra ni-rukwularruma arakba eneja nenikumarnjenikba neningarija-langwa, nanga-wilyakamurra dibina dadumakirnda. Aburraja kembirra neni-yengbijuwama nakina Jera, mena akina ekirra Jera ne-yaminama “dumilyingarradada.” ");
INSERT INTO aoi_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Ebina-manja angalya aringbirra-manja emikirra Yijiba n-ambilyumurra arakba eneja nakina Jawijiba. N-ambilyumurra nakina Yijiba-manja mena wurrumurndakibina-baba WarningiYijumeyila warnumamalya nenu-wilyakama nakina yenjerrikina akwa nenu-kwama nuwilyabu-wa nenungkwarba nenimikirra Badiba. Kembirra eneja nakina Badiba nenu-kwama arrkala angwarnda nakina-murrada wurrumurndakibinu-wa WarningiYijumeyila warnumamalya. Nakine-ka Badiba nenuminu-war•duwar•danguma warka naruma-langwa nubungkawa, akwa nu-bungkawadinuma nakina wurrawinyamba-manja narr-akukwurrajuwa-murrumanja alikira naruma-langwa nubungkawa. ");
INSERT INTO aoi_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Kembirra eneja nakina Jawijiba n-ambilyumurra yakwujina ngawa Badiba-langwa-manja alikira, akwa nenuminu-war•dangumurra nakina warka Badiba-langwa. Umba eneja Yaweya n-ambilyumurra nakina Jawijiba-manja akwa nenumini-yaminjamama ngawa eningaba-wiya Jawijiba-manja nakina. ");
INSERT INTO aoi_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Kembirra eneja Badiba ni-lyandarrkenuma Yaweya Jawijiba-manja n-ambilyuma nakina akwa nenu-mamurikajuwama nakina-manja Jawijiba neningangkawura neniku-war•di-yada warka eningaba. ");
INSERT INTO aoi_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Biya kembirra arakba nenu-werrungwur•dangume-ka nakina Badiba Jawijiba-manja akwa nen-akumarnuma nakina nubungkawa ena-langwa-manja alikira akwa ena-langwa-manja amurndakijika ababurna-manja. ");
INSERT INTO aoi_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Yadikina akina-murrada ngawa n-aburradadu-mulangwa nakina Jawijiba nenuminu-war•dangu-mulangwa warka Badiba-langwa, eneja nakina Yaweya ni-yamama eningaba Badiba-manja akwa ena-langwa-manja warnumamalya. Ni-yamame-ka Yaweya eningaba aburruwa-manja mena Jawijiba n-ambilyumurra nakina yakwujina Badiba-langwa-manja alikira. Eningaba warka nu-war•duwar•danguma eneja nakina Jawijiba akwa *namurndaku-wulduma *namurndaku-ngwur•duma eningaba ababurna-langwa Badiba-langwa-manja alikira arrawa akwa ngawa ena-langwa-manja ajiringka errekba-manja ngarningka. ");
INSERT INTO aoi_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","7","Nakine-ka Jawijiba neni-kalyikama angwurra Badiba-manja. Eneja kembirra nakina Badiba nenu-kwama ababurna-langwa amurndakijika ena-langwa Jawijiba-manja kajungwa nenik-akwurraji-yada nakina amurndakakina-da. Biya kembirra arakba nara nakina kin-engkirrikena Badiba ena-langwu-wa amurndakijika, umba ena-langwu-wa aninga wulkwa n-engkirrikenumurra nakina-da. Bi...ya kembirra ngalaja dadingiyenikba Badiba-langwa yingini-rringkame-ka dakina nukwulyubene-ka Jawijiba. Nenumebinga neningaba ningbuda akwa nenumukwurra neningaba, akwa yingini-ngayindanguma kenu-mungkwuluma aburnuwa. Yingini-yengkilabena dakina ");
INSERT INTO aoi_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","akena eneja nu-ware-ka nakina-da. “Nare-ka,” ni-yama nakina Jawijiba ngaluwa-wa. “Kwuja, nubungkawa nganyangwa, nibina neningiyena, nara nakina engkirrikuma eningerribirru-wa amurndakijika ena-langwa enena-manja alikira ena-langwa, mena ningenena-baba ngayuwa yelakwa. Ngin-akumarnuma nakina ngayuwa ningubungkawa angkwulyumida-manja amurndakijika ena-langwa. ");
INSERT INTO aoi_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Ningene-ka ningenikuminuwar•duwar•da ena-langwa, akena ningubungkawa ngayuwa wuburra enuwa yelakwa enena-manja alikira. Nara ebina kini-lyingilyinga amurndakijika ena-langwa wulkwa nungkuwa ena-langwa ningkadingiyenikba. Ningene-ka ningu-warenama awurruwurrariya akwa nara kembirra arriyakajungwuma ngayuwa Yaweya-langwa,” ni-yama nakina Jawijiba dibinu-wa didarringka Badiba-langwa-da. ");
INSERT INTO aoi_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Akena ngalaja dakina ngawa yingini-yengkiyengkilabenuma adadinuba diyirrbiyirrba ngawa. Umba eneja nu-wara ngawa akwa nara kenu-mungkwula wunalakina-da. ");
INSERT INTO aoi_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Bi...ya arngkawura nakina Jawijiba n-awiyebena alikira-wa warki-yada, akena nara wurribina wurrukwala warnikuminuwar•duwar•da yakwujina. Nakwukawure-ka nu-war•danguma nakina warka. ");
INSERT INTO aoi_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","13","Kembirra ngalaja dibina didarringka Badiba-langwa nanga-rndarrka dumbala Jawijiba-langwa akwa yingi-yama enuwa-wa, “Kwa, yakuwa yi-mungkwula.” Akena ni-lyumada eneja, n-angkarra errekbu-wa umba nanga-lalika nakina ena-langwa dumbala ngala-langwa-manja ayarrka. Kembirra nanga-rringka-manja dakina dumbala Jawijiba-langwa ngala-langwa-manja ayarrka, ");
INSERT INTO aoi_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","ying-ardanga dakina ngala-langwu-wa warnikuminuwar•duwar•da warnumamalya. Biya, “Yimini-rringka-langwa daka dumbala,” yingi-yama. “Neningiyarrka nen-awiyebajuwama naka NiYiburuwa nenungkwarba enenu-wa alikira akwa ngarreni-yelijinama nakina ngakwurruwa aduwaba,” yingi-yama. “N-awiyebene-ka nganyangwu-wa angalya akwa ngini-ngayindanguma ngayuwa nakina, akena ningu-warduwardeminuma angwurra nganja-da. ");
INSERT INTO aoi_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Eneja n-engkirrika ningu-warduwardeminuma ngayuwa, biya nanga-lalika daka dumbala ngayuwa-manja-da, akwa n-angkarra errekbu-wa-da,” yingi-yama dakina didarringka Badiba-langwa ngala-langwu-wa warnikuminuwar•duwar•da warnumamalya-da. ");
INSERT INTO aoi_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Biya nanga-wilyaka ngawa dibina dumbala Jawijiba-langwa yanda-langwa ni-yar•da arakba neningiyadikba nakina yakwujina. ");
INSERT INTO aoi_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Biya kembirra yinginu-makama ebina-murrada ngawa ayakwa. Yingi-yama enuwa-wa, “Nake-ka NiYiburuwa nenikuminuwar•duwar•da ningkenu-wilyakama nungkuwa yangkwurrangwa n-awiyebenume-ka nakina nganyangwu-wa angalya akwa ngini-yelijuma ningena ngayuwa. ");
INSERT INTO aoi_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Nganja ningu-warduwardeminuma ngayuwa, kembirra juj n-angkarra eneja nakina ni-jadinga errekbu-wa umba nanga-lalikama daka dumbala ena-langwa ngayuwa-manja-da,” yingi-yama dakina-da. ");
INSERT INTO aoi_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Nenak-ar•darre-ka awinyamba eneja kembirra neningiyadikba, nibina Jawijiba-langwa nubungkawa Badiba, n-engkirrikenu-mulangwa akina ayakwa dadingiyenikba-langwa. ");
INSERT INTO aoi_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Biya nenu-maka ena-langwa-manja warnungkwarba warnik-engkarrngi-yada wurrakina Jawijiba-manja. Aburraja kembirra nen-akumarna nakina angerriba nubungkawa-langwu-wa akididijungwa. Kembirra yakwujina ngawa n-ambilyuma eneja nakina Jawijiba arakba-da. ");
INSERT INTO aoi_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Umba eneja nakine-ka Yaweya n-ambilyumurra yakwujina Jawijiba-manja ngawa akwa nu-marngkirradinuma nakina-manja. Eneja nibina nenikakukwurrajungwa akididijungwa nenu-werrungwur•danguma nakina-manja Jawijiba. ");
INSERT INTO aoi_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Biya nen-akumarnuma nakina Jawijiba nubungkawa wurrababurna-manja wurrukwala warnungkwarba wurribina na-didijungwunu-murrumanja aburrajukwaba yakwujina ebina-manja ngawa akididijungwa. ");
INSERT INTO aoi_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Kembirra amurndangekburna ena-langwa warka nu-war•danguma eneja nakina Jawijiba. Umba eneja kembirra nenikakukwurrajungwa nenungkwarba nara arakba kin-engkirrikena akinu-wa warka, mena nakina Yaweya Jawijiba-manja n-ambilyu-murrubaba akwa nenu-mamurikajuwa-murrubaba enuwa-manja ngawa. Kembirra yadikina *na-wuldinume-ka *na-ngwur•dangume-ka ngawa eningangkawura ababurna-langwa Jawijiba-langwa-da. ");
INSERT INTO aoi_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","2","Bi...ya kembirra eneja naruma nubungkawa nibina nu-bungkawadinuma ababurna-manja angalya Yijiba n-awinyambadinume-ka nakina wunambilyuma-wa ena-langwu-wa wunenikuminuwar•duwar•da-kiya wunenungkwarba-kiya. Nuwilyaba nuwurrak-akwurrajuwama nakina ena-langwa akubibeka. Nu-war•danguma nakina warka amalyirra akwurena-langwa-manja. Umba eneja nuwilyaba numurndaki-dakama eminiminingka aninga nubungkawa-langwa-manja angalya. ");
INSERT INTO aoi_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","Akena eneja nakina naruma nubungkawa nen-awiyebajuwama akididijungwa-manja wunalakina, mena nenilirraku-wirrikba-mubaba wunalakina-kiya-wa. Aburnaja kembirra nen-ambilyuma wunalakina alikira-manja nibina-langwa-manja nenikakukwurrajungwa akididijungwa, ebina-manja ngawa alikira n-ambilyu-murrumanja adinakba enejukwaba Jawijiba nakina. ");
INSERT INTO aoi_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Eneja kembirra nakina nenikakukwurrajungwa akididijungwa nenu-kwama Jawijiba wunalakina-kiya-wa wunenungkwarba-kiya kajungwa neniku-war•di-yada nakina Jawijiba warka aburna-langwa yakwujina. Aburnaja nen-ambilyuma yakwujina wunalakina ngawu...wa. ");
INSERT INTO aoi_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Biya muwilyaba-manja ngawa meningalyarrngwalyilya marringa yakwujina akididijungwa-manja arrawa wunalakina wunenungkwarba-kiya neni-lyangburarrkinuma akwulyangburarrka. Biya alakina akwulyangburarrka muwilyaba-murra-manja ngawa meningalyarrngwalyilya marringa neni-lyangburarrkinuma akena eminingka-kiya alakina akwulyangburarrka-kiya-da. ");
INSERT INTO aoi_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Wurdarriya-wiya eneja Jawijiba ni-likena nakina wunalakina-kiya-wa. Nenilirraki-rringka-manja nakina wunalakina kembirra neningma nakina nen-ambilyume-ka wunuwerrikawarriya-kiye-ka arakba. ");
INSERT INTO aoi_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Ni-yama nakina Jawijiba, “Kini-yamarrkama-burra kembirra kinuwerrikawarriya aduwaba?” ni-yama. ");
INSERT INTO aoi_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Neni-yama aburnaja, “Yinalakene-ka yini-lyangburarrkinuma akwulyangburarrka yineyebijeba, akena nara wurribina wurruwilyuwilyaba yelakwa amin-abilyerrikama yinuwa-manja alakena-kiya akwulyangburarrka,” neni-yama wunalakina. Ni-yama eneja Jawijiba, “Neningikarraware-ka yimbukwa kin-abilyerrikinama nakina warnumamalya-manja akwulyangburarrka umba nara wurrukwala. Umba yirru-makina nungkwurna-langwa akwulyangburarrka,” ni-yama. ");
INSERT INTO aoi_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Eneja kembirra nibina n-akwurrajuwa-mudangwa akubibeka nubungkawa-langwa ni-yama nakina, “Nganyangwa-manje-ka akwulyangburarrka ningi-rringkama awilyaba akwurena ");
INSERT INTO aoi_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","abiyakarbiya-ma amakirnda. Adinuba-wiya ningi-rringkama ngayuwa amarda. Kembirra warenja-bawiya ngarningka ngalaja amawalyuwa na-jadingama. Ngarningka kembirra amaninga na-walyuwama akina. ");
INSERT INTO aoi_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Nganja ninguma-lyingama ngayuwa menarlamba nganyangwa-langwa nubungkawa ayarrka-manja. Kembirra ning-arrangbama amurndakakina akwurena akwa ningi-likakbama amalyirra makinu-wa menarlamba akwa ningenu-kwama-da,” ni-yame-ka nakina nenikakukwurrajungwa akubibeka. ");
INSERT INTO aoi_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Ni-yama eneja Jawijiba enuwa-wa, “Yiba-makinama ngayuwa akina-langwa,” ni-yama. “Akine-ka abiyakarbiya amakirnda ne-yaminama akina mabiyakarbiya marringa. ");
INSERT INTO aoi_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Kembirra mabiyakarbiya-manja ngawa marringa eneja keni-jadijinama nungkwa-langwa nubungkawa ningkakina. Akwa kenumini-yakuwabijinama nakina ebina awurrariya ningki-yama-mulangwa, akwa kembirra nungkwaja kinuminu-war•denama ngarningka ningkakina ena-langwa warka wuburra adinuba-wiya ningkenuminu-war•danguma ningkakina. K-akwurrajinama ngarningka akubibeka ena-langwa akwa kinu-kwunama amalyirra akwurena-langwa ngarningka. ");
INSERT INTO aoi_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Akena *ka-wuldina-manja *ka-ngwur•dena-manja eningaba ngawa nungkwa-langwa, kembirra nare-ka e-yakuwabijuma ngayuwa. Umba yikumini-yengbina ayakwa kinu-makina nungkwa-langwa nubungkawa ngayuwa-langwa, kajungwa keni-jadijini-yada nakina ngayuwa nganjukwaba enena-langwa akididijungwa. ");
INSERT INTO aoi_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Ningene-ka bu-manguma aburraja wurruwurrariya warnumamalya. Bi-lyumadikama angaluba nganyangwa-langwa angalya akwa ngawa nganyangwa-langwa WurriYiburuwa warnumamalya. Kajukwaba enena-manja ngawa angalya Yijiba nare-ka nganja ningena k-arriyakajungwuna awurrariya-langwa-da. Nara-maka kembirra kab-awiyebajuwa ngayuwa enena-manja akididijungwa-da,” ni-yama nakina Jawijiba nibinu-wa nenikuminuwar•duwar•da-da. ");
INSERT INTO aoi_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Umba eneja nibina nenikididaka nenungkwarba aninga n-engkirrika-manja nakina nuwilyaba-langwa ebina akwulyangburarrka eningaba akina, enamba-langwa kembirra ni-yengbina nakina Jawijibu-wa ayakwa. Biya ni-yama nakina, “Nganjukwabe-ka ningi-lyangburarrkinuma akwulyangburarrka,” ni-yama. “Ningene-ka ningi-ngabukweyinumurra abiyakarbiya eninganinga-langwa alabura nganyangwa-manja aringka. ");
INSERT INTO aoi_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Umba eningikarrawara-manja alabura ngalaja eminiminingke-ka aninga nuw-ambilyumurra ningenumini-daka-mulangwa ngayuwa nganyangwa-langwa nubungkawa. Akena aburraja wurrajija nuw-alyubarinuma wurrakina-da,” ni-yama nakina nenikididaka aninga-da. ");
INSERT INTO aoi_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Eneja ni-yama nakina Jawijiba enuwa-wa, “Yiba-makinama ningena kembirra nungkwa-langwa-langwa akwulyangburarrka. Akine-ka abiyakarbiya alabura ne-yaminama akina mabiyakarbiya mamawura. ");
INSERT INTO aoi_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Kembirra mabiyakarbiya-manja ngawa mamawura eneja nakina nubungkawa nungkwa-langwa keni-jadijiname-ka nungkuwa nungkwajukwaba. Akena aburraja kabumini-ngkarrnginame-ka nungkwa-langwa memirrma! Kembirra nakine-ka nubungkawa nungkwa-langwa kenu-makinama ena-langwa-manja wurrawinyamba warnik-alyadiji-yade-ka ningkakina ningkenumadangkwa eka-manja. Aburraja kembirra wurrajija kuw-alyubarinama ningkenumadangkwa wurrakina-da,” ni-yama nakina Jawijiba nibinu-wa nenikididaka aninga-da. ");
INSERT INTO aoi_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Bi...ya kembirra mabiyakarbiya arakba mamawura numi-jerriduma makina. Eneja kembirra nakina nubungkawa naruma-dangwa nen-ardijuwa arakba wurrababurna-langwa ena-langwa wurrububungkawa wurriyukwayuwa ena-langwu-wa alikira aningi-yada warnik-alyubara, kajungwa warniki-yakuwerribiki-yada mibina mamawura ni-rukwularrinu-mulangwa nakina nubungkawa. Biya nenilirraki-jadijuwa nakina wunalekbina wunenungkwarba-kiya ebina-langwa akididijungwa akwa nenilirrak-ardijuwa wunalakina enuwa-wa. Kembirra aburnaja neni-likena enuwa-wa wunalakina akwa nen-alkayanga yakwujina enuwa-manja akwa wurrumurndakibina-manja ngawa wurriyukwayuwa wurrububungkawa ena-langwa-manja. ");
INSERT INTO aoi_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Kembirra nibina n-akukwurrajuwama akubibeka ena-langwa nenu-kwama eneja nakina arakba nubungkawa ebina-murrada warka nu-war•duwar•dangu-murrada adinuba-wiya nakina. ");
INSERT INTO aoi_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Umba neni-jungwajuwama nakina nibina nenikididaka nenungkwarba aninga. Nenu-makama ena-langwa-manja wurrawinyamba akwa aburraja nenumini-ngkarrngarnuma wurrakina ena-langwa memirrma-da. Kembirra ababurna-langwa ne-yamama akina ebina-langwiya ngawa ayakwa ni-yengbinu-mulangwiya adinuba-wiya Jawijiba-da. ");
INSERT INTO aoi_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Akena eneja nibina nenikuminuwar•duwar•da n-akukwurrajuwama akubibeka ena-langwa-langwa nubungkawa nare-ka nakina kin-engkirrikena Jawijibu-wa-da, umba numurndaki-yakuwabijuwama arakba-da. ");
INSERT INTO aoi_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Bi...ya mambilyuma arakba mamarika iya yinungkwura nilirraki-jerridu-manja, eneja kembirra nibina naruma nubungkawa ni-lyangburarrkinuma nakina akwulyangburarrka. Umba ena-langwa-manja akwulyangburarrka nu-kuwarjeyumurra nakina adalyuma-manja ena-langwa-manja angalya. Emikirra adalyuma Nayila akina. ");
INSERT INTO aoi_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","Biya ni-rringkame-ka nakina amangbala ambilyuma bulukwa nawurrak-ambijanginuma akina akungwa-langwa. Ngalaja engmurra-wiya akwulyarrinja-wiya amurndakakina. Nawurraki-riberrkinuma akwa kembirra ne-yebukeyinuma arakba akina amarda akwiyakbidjina akungwa. ");
INSERT INTO aoi_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Kembirra arngkidarrba-langwiya amangbala ambilyuma ngarningka nawurrak-ambijanga ngalajukwaba. Umba akine-ka bulukwa amurndakilarrkbulala-wiye-ka akwa amirajamiyama-wiya akina. Nawurraki-riberrkinuma akina akwa nawurrak-alkayanguma ariba-manja amurndakibina-manja akwala bulukwa. ");
INSERT INTO aoi_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Kembirra akine-ka bulukwa amurndakilarrkbulala nuw-alyubarinume-ka ebina-manja engmurra-dangwa-da. Kembirra akina-bu ngawa-da. Aba nu-mirajanga arakba eneja nakina nubungkawa-da. ");
INSERT INTO aoi_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Biya kembirra nu-mungkwulinga ngarningka nakina akena ni-lyangburarrkina ngarningka ngawa akwulyangburarrka. Umba ena-langwa-manja akwulyangburarrka ni-rringkama nakina amamuwa amaninga amarda-murra. Awilyaba-murra-manje-ka ememiyeja amarda ni-rringkama nakina amangbala ambilyuma amamuwa amaninga. Ngalaja engmurre-ka amurndakakina akwa na-walyuwunumurra arakba akina. ");
INSERT INTO aoi_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Kembirra ngarningka amamuwa amaninga na-lingbijanginuma amangbala ambilyuma ngalajukwaba akina-da. Akena akine-ka amaninga amurndajamiyama eningaruma-ma, mena mamarika ne-ngburingkakama akina. ");
INSERT INTO aoi_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Kembirra akine-ka amaninga amurndakilarrkbulala-dangwa na-ngir•danguma na-janguma arakba akina engmurra-manja-da. Kembirra akina-bu ngawa akwulyangburarrka-da. Eneja nu-mirajanga arakba nakina naruma nubungkawa akwa ni-lyandarrkenuma akwulyangburarrka ni-lyangburarrkinuma nakina-da. ");
INSERT INTO aoi_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Bi...ya ne-kbadinga arakba akina. Kembirra nakine-ka naruma nubungkawa nu-werrikawarriyadinuma nakina alakina-kiya-wa akwulyangburarrka. Kembirra mamawura-manja nen-ardijuwa nakina wurrababurna wurrarumuruma wurraringkiringkawa wurribina nuw-ambilyu-murrumurra ena-langwa-manja angalya Yijiba. Biya nenu-makama nakina ena-langwa-langwa akwulyangburarrka-da. Akena nara wurruwilyuwilyaba kenumin-abilyerrika alakina-kiya akwulyangburarrka ena-langwa-da. ");
INSERT INTO aoi_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Eneja kembirra ena-langwa nenikuminuwar•duwar•da nibina n-akukwurrajuwama akubibeka ena-langwa ni-yengbinuma nakina ayakwa enuwa-wa. “Wa! Ningi-yakuwabijuwa awilyaba ayakwa,” ni-yama. ");
INSERT INTO aoi_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","“Ebina-wiya y-awinyambakama ningkakina ngayuwa-manja akwa ngawa nakina-manja nenikuminuwar•duwar•da nungkwa-langwa nibina ni-daka-murrumanja aninga nungkwa-langwa enejukwaba. Biya ningkakina kembirra yirrilirrak-awiyebajuwama yinuwa akididijungwa-manja arrawa. Akwa yinaja yin-ambilyumurra yakwujina kembirra nubungkawa-langwa-manja alikira. Eneje-ka nakina nubungkawa nu-bungkawadinuma wurrawinyamba-manja warnungkwarba narr-akukwurrajina-murrumanja nungkwa-langwa alikira. ");
INSERT INTO aoi_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","12","Kembirra yakwujina ngawa yirrubuk-ambilyuma yinuwa akwa ngawa nuwilyaba nenungkwarba neningengka-langwa angalya. Nakine-ka nenungkwarba NiYiburuwa nakina. Akwa nenuminu-war•duwar•danguma warka nakina-langwa nubungkawa. Yakwujina ngawa yinaja kembirra yinuwa yinenikuminuwar•duwar•da-kiya nungkwa-langwa yini-lyangburarrkinuma yinalakina akwulyangburarrka muwilyaba-manja ngawa meningalyarrngwalyilya marringa. Akena eminingka-kiya alakina akwulyangburarrka yina-langwa. Biya kembirra yinuwa yinu-makama arakba yina-langwa akwulyangburarrka nibinu-wa NiYiburuwa nenungkwarba. Umba eneja nakine-ka nenungkwarba yirrenumin-abilyerrikame-ka alakina-kiya akwulyangburarrka yina-langwa-da. ");
INSERT INTO aoi_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","“Kembirra ambaka-murra arija-langwa ne-yamame-ka ngalaja akina ababurna-langwa ni-yama-murrada adinuba-wiya nakina nenungkwarba yinuwa-wa. Nungkuwa nungkwaja yi-jadijuwame-ka ngayuwa ningi-didijungwunu-murrada ebina-langwa akididijungwa. Akwa y-awiyebajuwama ngayuwa ningkakina nungkwa-langwa-manja angalya kajungwa ningeniku-war•di-yada warka nungkwa-langwa, ebina-wiya wuburra ningu-war•danguma ngayuwa adinuba-wiya. Akena nibine-ka ningka-dangwa nenikuminuwar•duwar•da nungkwa-langwa ningkeni-ngajama ningkakina-da,” ni-yama nakina nenikuminuwar•duwar•da ena-langwu-wa nubungkawa-da. ");
INSERT INTO aoi_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Eneja kembirra nakina naruma nubungkawa neni-larrka arakba wurrukwala warnungkwarba ena-langwa ebinu-wa akididijungwa kajungwa warniki-jadiji-yada nakina Jawijiba yadikina. Kembirra aburraja warenja-bawiya neni-jadijuwa arakba nakina Jawijiba. Eneja Jawijiba nu-wurranguma nakina ayama akwa n-awiyebenuma dumbala dadingaba-langwa akwa ni-likenuma nibinu-wa naruma nubungkawa. ");
INSERT INTO aoi_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Ni-yama eneja naruma nubungkawa Jawijibu-wa, “Ngayuwe-ka ningena ningi-lyangburarrkinuma akwulyangburarrka. Akena nara aburraja wurribina warnumamalya amin-abilyerrikama akina. Umba bu-makama ayakwa nungkwa-langwa-langwa. Nganyangwa nenikuminuwar•duwar•da ni-yama ngayuwa-wa, ‘Jawijibe-ka nakina nakakiruma nenik-abilyerrika-langwa nakina akwulyangburarrka wurrukwala-langwa warnumamalya,’ ni-yama nakina,” ni-yama nakina naruma nubungkawa Jawijibu-wa. ");
INSERT INTO aoi_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Umba eneja ni-yama Jawijiba, “Nare-ka ningena ngayuwa amin-abilyerrikama akina,” ni-yama. “Umba eneja nakina Neningikarrawara kenumin-abilyerrikinama akina nungkuwa-manja kajungwa ningkiyekirrerri-yada ningkakina,” ni-yama nenu-maka Jawijiba enuwa-wa. ");
INSERT INTO aoi_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Eneja ni-yama nakina naruma nubungkawa, “Ebina-manje-ka akwulyangburarrka nganyangwa ningu-kuwarjeyuma ngayuwa akwudangwa adalyuma-manja. Emikirra adalyuma Nayila akina. ");
INSERT INTO aoi_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","Biya ningi-rringkama ngayuwa amangbala ambilyuma bulukwa nuw-ambijanginuma akina akungwa-langwa. Umba ngalaja akwulyarrinja-wiya engmurra-wiya akina. Biya nawurraki-riberrkinuma akina akwa ne-yebukeyinuma amarda yakwujina akwiyakbidjina akungwa. ");
INSERT INTO aoi_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Kembirra arakba ngarningka amangbala ambilyuma bulukwa ngalajukwaba nuw-ambijanginuma akungwa-langwa akina. Akena alarrkbularrkbulale-ka angwurra akina bulukwa. Nara ambaka ngayuwa ningena ki-rringka-langwa amukwiyadakina bulukwa alarrkbularrkbulala-dangwa ababurna-manja angalya Yijiba-manja umba enena-manji-kba akwulyangburarrka ningi-rringkama arakba ningena-da. ");
INSERT INTO aoi_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Ngalaje-ka akina bulukwa alarrkbulala-dangwa nuw-alyubarinuma ebina-manja engmurra. ");
INSERT INTO aoi_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Akena nare-ka akina ke-ngmurridina nuw-eyijinu-mulangwa ebina bulukwa engmurra-wiya. Umba alarrkbulala ngawa nuw-ambilyumurra akina wuburra adinuba-wiya-da. Kembirra nganja ningu-mirajanga arakba-da,” ni-yama nakina naruma nubungkawa Jawijibu-wa. ");
INSERT INTO aoi_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Biya ni-yama ngarningka, “Kembirra enena ngarningka ningi-lyangburarrkinuma ngayuwa akwulyangburarrka. Akwa ningi-rringkama ngayuwa amaninga amarda-murra. Umba ningi-rringkama amangbala ambilyuma amamuwa amaninga awilyaba-murra-manja ngawa ememiyeja akena engmurra-wiya ngalaja akina. Na-walyuwinume-ka akina. ");
INSERT INTO aoi_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Ngalaja kembirra amangbala ambilyuma ngarningka amamuwa na-lingbijanginuma arakba akina. Akena alarrkbularrkbulala-wiya akina amamuwa, mena ne-ngburingkakama makina mamarika. ");
INSERT INTO aoi_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Umba akine-ka amamuwa eningeningaba-ma-dangwa na-ngir•dangume-ka na-jangume-ka ebina-manja engmurra-manja-dangwa akina. Akina ngawa. Kembirra ningarra-makama ngayuwa nganyangwa-manja wurrarumuruma wurraringkiringkawa-manja. Akena nara aburraja wurribina wurruwilyuwilyaba kabumin-abilyerrika alekbina-kiya akwulyangburarrka nganyangwa-kiya,” ni-yama nakina naruma nubungkawa Jawijibu-wa-da. ");
INSERT INTO aoi_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Eneja Jawijiba ni-yama nakina enuwa-wa, “Alakine-ka akwulyangburarrka-kiya nungkwa-langwa alirrakididirrbura ngawa. Umba eneja Neningikarrawara nginu-makama nakina nungkuwa-manja adinakba kini-yamina-mulangwa ambaka-murra. ");
INSERT INTO aoi_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","“Akine-ka amangbala ambilyuma bulukwa engmurra-wiya ne-yaminama akina wuburra mamangbala mambilyuma mamarika iya yinungkwura. Umba ngalaja amaninga engmurra-wiya ne-yaminama ngarningka ngalajukwaba wuburra mamangbala mambilyuma mamarika iya yinungkwura. Umba alakine-ka akwulyangburarrka awilyaba-murra ngawa akina. ");
INSERT INTO aoi_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Umba ngalaja amangbala ambilyuma bulukwa alarrkbularrkbulala-dangwa, amurndakibina ne-ngbijeyinu-murrumurra arija-langwa akungwa-langwa, akwa ngarningka amurndakibina amangbala ambilyuma amamuwa aninga amurndakilarrkbularrkbulala ngalajukwaba, ebina ne-ngburingkadinuma nuw-angkarrinu-mulangwa engburingka arrirra, ne-yaminama akina wuburra mamangbala mambilyuma mamarika iya yinungkwura. Umba akini-yada nare-ka yibina yelyukwa a-larruma-da akwa kembirra ngarningka nare-ka ebina amarda amaninga a-lungkuwarruma akina-da,” ni-yama Jawijiba nakinu-wa naruma nubungkawa. ");
INSERT INTO aoi_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Biya kembirra ni-yama ngarningka, “Yirra-maka-murrada ngayuwa nungkuwa-manja arakba ayakwa, eneja nakina Neningikarrawara nginu-mukangbijuwama nungkuwa-manja akwulyangburarrka-murra adinakba ebina neniki-yama-langwa nakina arija-langwa. ");
INSERT INTO aoi_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Adinuba-wiya ngalaja mubukwaye-ka kumu-likajama mamangbala mambilyuma mamarika meninginingaba-wiya iya yinungkwura yininginingaba-wiya. Kembirra akini-yada ngalaja ababurna aninga kuw-ambilyama amurndakenena-manja angalya ababurna-manja yelakwa Yijiba-manja. ");
INSERT INTO aoi_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","31","Kembirra arija-langwa ambaka-murra ngalaja mubukwaye-ka kumu-likajama mamangbala mambilyuma mamarika muwurruwurrariya-wiya iya yinungkwura yuwurruwurrariya-wiya. Umba akini-yada nare-ka yibina yelyukwa a-larruma yakina akwa ngarningka nare-ka ebina amarda amaninga a-lungkuwarruma akina ngalajukwaba. Akini-yada ngawa aburraja kembirra wurrumurndakenena warnumamalya kamurndaki-yakuwabijinama akina ababurna aninga eninginingaba enena-manja angalya Yijiba. Kamurndaki-yakuwabijiname-ka wurrakina mena amurndakenene-ka angalya kamurndak-arriyadina-mubaba akina-da. ");
INSERT INTO aoi_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","“Nungkuwe-ka ningkakina ningki-lyangburarrkinuma arngkambilyuma-ma, mena Neningikarrawara ni-lyangkuwerribikajungwunuma nakina, akwa arngkidarrba-langwiya kini-yaminame-ka nakina Neningikarrawara amurndakakina ababurna-langwa-da,” ni-yama Jawijiba nakinu-wa naruma nubungkawa. ");
INSERT INTO aoi_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","Biya ni-yama nakina ngarningka enuwa-wa, “Kembirra nungkuwa ku-wekbalyinama ningkakina nuwilyaba nenungkwarba aringkawa. Akwa kin-akumurnama nakina nubungkawa kajungwa kinu-bungkawadini-yada amurndakenena-manja angalya Yijiba-manja. ");
INSERT INTO aoi_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","36","Akwa ngarningka ka-menama ningkakina wurrukwala warnikuminuwar•duwar•da kajungwa kenu-mamurikajini-yada wurrakina enuwa-manja. Kembirra mamurndakibina-manja ngawa mamangbala mambilyuma mamarika meningaba-wiya iya yinungkwura yiningaba-wiya, kuw-ambilyama ngalaja akina ababurna aninga Yijiba-manja. Kembirra karr-awiyebajinama aburraja wurrakina akwala aninga eninganinga-langwa-manja alikira. Kum-ambilya-manja mamangbala beka maninga-murra makina, kuw-alyubarinama warningerribirra warnumamalya mabiyarbuwa umba karrum-awiyebajinama muwilyaba maninga-murra beka wurrakina arrawu-wa eninganinga-langwu-wa alikira. Nungkwaja ningkakina ka-makinama wurrumurndakibina-manja warnikuminuwar•duwar•da kajungwa karri-larrngkwaburreni-yada ababurna aninga amurndakibina-manja angalya aminababurna-manja alikira. Ka-makinama ngarningka wurrakina-manja kajungwa karr-akukwurrajini-yada ebina aninga nari-yada wurrukwala warnumamalya ngi-rndirrkama akina, umba engkinyungwurra ngawa kuw-ambilyi-yada akina ambaka-murri-yada. Kembirra kumu-likaja-manja yimurndakibina yimangbala yambilyuma yinungkwura yuwurrariya-wiya enena-manja angalya Yijiba kembirra kuw-ambilyama ngawa akina aninga kajungwa wurrababurna-langwa warnumamalya kuw-alyubarini-yada akina. Nare-ka aburraja a-mureyama wurrakina umba kuw-alyubarinama akina-da. Kembirra nare-ka a-jungwuma wurrakina umba warniba ngawa kuw-ambilyama-da,” ni-yama Jawijiba nakinu-wa naruma nubungkawa-da. ");
INSERT INTO aoi_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Eneja nakina naruma nubungkawa akwa ngawa ena-langwa wurriyukwayuwa wurrububungkawa na-lyelyingminuma wurrakina ebina ayakwa ni-yengbinu-mulangwa nakina Jawijiba. ");
INSERT INTO aoi_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Biya kembirra nakina naruma nubungkawa ni-yama ena-langwu-wa wurriyukwayuwa wurrububungkawa, “Nare-ka akburranguma ngarna warningerribirra warnungkwarba warningaba wuburra naka Jawijiba, mena Neningikarrawara-langwa amawurrina nuw-ambilya-mubaba akina enuwa-manja,” ni-yama nakina aburruwa-wa. ");
INSERT INTO aoi_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Biya kembirra ni-yama nakina arakba Jawijibu-wa, “Nakine-ka Neningikarrawara nginumin-abilyerrikama ena ababurna-langwa nungkuwa-manja. Kembirra aminakina-langwa nganja ningeningma ngayuwa nare-ka wurribina warnungkwarba wurraringkawa wuburra nungkuwa ningkakina. ");
INSERT INTO aoi_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Kembirra ngayuwa yiba-bungkawakinama ningkakina enena-manja angalya nganyangwa. Aburraja wurrababurna-langwa warnumamalya nganyangwa kabumin-engkirrikajama arakba wurrakina nungkwa-langwu-wa ayakwa. Nganje-ka ngayuwa ningubungkawa ningaruma akwa ningi-lyinginama ababurna-langwa angalya Yijiba-manja. Umba yik-aburrakiyuwarnama ningkakina ngayuwa-manja akwudangwa, kajungwa kabumin-engkirrikaji-yada nungkwa-langwu-wa ayakwa nungkwajukwaba. ");
INSERT INTO aoi_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Aduwabe-ka ngayuwa yiba-bungkawakinama ningkakina ningkubungkawa ababurna-manja angalya Yijiba-da,” ni-yama nakina naruma nubungkawa Jawijibu-wa-da. ");
INSERT INTO aoi_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Biya kembirra nakina naruma nubungkawa n-aburawaka nakina ebina eyukwujiya errumungkwa ena-langwa-langwa amamuwa ayarrka, ebina na-wilyakama akina ekirra ena-langwa. Akwa n-akumarna akina Jawijiba-langwa-manja amamuwa ayarrka. Akwa nen-awiyebaja arakba dadingaba dumbala dukwulyubena Jawijiba-manja akwa ngawa n-akumarna alarrngekburna arnarrirnarra akawulda-murra ena-langwa-manja memirrma. ");
INSERT INTO aoi_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Kembirra ngarningka nenu-kwama nakina muwilyaba makangkidikarra mibina yingum-arrkirrkirnama jarrangwa, kajungwa neniki-rijawudi-yada nakina Jawijiba. Meningabe-ka makina akwa nubungkawa-langwa wuburra numi-yamama ngawa makina-da. Biya kembirra nakina naruma nubungkawa ni-yengbina ngarningka ayakwa nakinu-wa Jawijiba. Ni-yama nakina, “Ki-rijawudiyina-manja nungkuwa mibina-manja ngawa makangkidikarra, kembirra aburraja warnikuminuwar•duwar•da nganyangwa ka-lyengmenama wurrakina, ka-likajama mamurukwa-langwiya akwa kuw-ardenama wurrakina. ‘Erribaja-wiya karna karnumamalya!’ ke-yaminama wurrakina. ‘Wurrumurndaki-rungwudarra nubukwaya nubungkawa!’ ke-yaminama wurrakina-da. ");
INSERT INTO aoi_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","“Ngayuwe-ka ningubungkawa ningaruma-dangwa ningena. Aburraja kembirra wurrababurna-langwa warnumamalya WarningiYijiba bumin-engkirrikajame-ka nganyangwu-wa ayakwa. Akwa enena ayakwa ningarra-makama ngayuwa aburruwa-wa. Ningi-yamama, ‘Kirrababurna-langwa karnumamalya ababurna-manja angalya Yijiba yik-engkirrikajama ngawa Jawijiba-langwu-wa ayakwa. Akwa yiki-likajama kirrakina enuwa-wa kajungwa yikini-yendabaji-yada enuwa-wa nara-wiya e-yamama eningerribirra akina kirrakina karnumamalya-da,’ ningi-yamama ngayuwa wurrababurna-manja warnumamalya amurndakenena-manja angalya Yijiba-da,” ni-yama nakina naruma nubungkawa Jawijibu-wa-da. ");
INSERT INTO aoi_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","47","Biya kembirra nakina naruma nubungkawa nenu-kwa Jawijiba-manja enikaduwa ekirra EningiYijiba. Akine-ka ekirra Jebineda Baneya akina. Akwa ngarningka nenu-kwa nakina duwilyaba dadiyara dadimikirra Ajineda ena-langwi-yada dadingiyenikba. Ngalaja dadiyawenikba dakina nuwilyaba-langwa nenungkwarba nenimikirra Badibera nakina. Umba eneja nakina Badibera NuMinida nenungkwarba WarningiYijiba-langwa warnumamalya nakina. Umba ena-langwa angalya aminababurna alikira iya warnumamalya emikirra Yeliyabulija akina. Eneja Jawijibe-ka nakina n-ambilyumurra mamarika iya yinungkwura arngkabiyakarbiya-ma arngkumemberrkwa. Biya n-aburradada arakba nakina ebina warka nenu-kwama naruma nubungkawa. Kembirra arakba makina-manja mamangbala mambilyuma mamarika iya yinungkwura ngalaja na-lungkuwarringinuma ababurna amarda amaninga, ni-yama-murrada nakina Jawijiba nibina-manja naruma nubungkawa. Biya ni-lalika Jawijiba nubungkawa-langwa angalya akwa ni-likena nakina angerriba iya angerriba Yijiba-manja. ");
INSERT INTO aoi_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Ni-likenuma nakina amurndakakinu-wa angalya aminuwurrakwulyumida alikira iya warnumamalya akwa nenu-makama nakina wurrumurndakakina-manja wurruminakina angalya warnumamalya warniki-yama-langwa. Kembirra ababurna-manja angalya aminuwurrakwulyumida alikira aburraja wurruminakina angalya warnumamalya narruwurra-murndukwama amadidira amaninga aburra-langwa ebina narri-lungkuwabijuwa-mulangwa engka-manja iya engka-manja angalya akwudangwa, akwa narri-larrngkwaburranguma akina ababurna aninga arumuruma-manja alikira eninganinga yakwujina aburra-langwa-manja angalya. ");
INSERT INTO aoi_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Ababurne-ka aninga akwa nare-ka kembirra eneja Jawijiba kinu-murnduwarna arakba akina, mena-baba ababurne-ka akina wuburra ajiringka ebina mijiyelya-manja-da. ");
INSERT INTO aoi_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","52","Bi...ya kembirra akini-yada na-lungkuwarringinu-manja ngawa ababurna amarda amaninga yakwujina akina-manja angalya Yijiba, ngalaja Ajineda yinginumin-arrangbama dakina nenikuwenikba Jawijiba-langwa. Kembirra eneja ni-yama nungwenikba Jawijiba, “Neningikarrawara nakina nginu-mamurikajuwame-ka ngayuwa-manja, kembirra ningi-yakuwabijuwama arakba ababurna-langwa awerrikawarriya amurndakibina na-likenuma ngayuwa-wa akwa ningi-yakuwabijuwama ngarningka nganyangwa warnumamalya aburrajukwaba,” ni-yama nakina. Kembirra neni-yengbijuwama nakina neningadinuba-wiya nenikuwenikba Muneja nenimikirra, mena akina ekirra Muneja ne-yaminama “ningi-yakuwabijuma.” Bi...ya ambaka-murra na-lungkuwarringinu-manja ngawa ababurna aninga yakwujina Yijiba-manja akina, ngalaja Ajineda yinginumin-arrangbama dakina nuwilyaba ngarningka nenikuwenikba Jawijiba-langwa. Kembirra eneja ni-yama Jawijiba, “Neningikarraware-ka nakina nginu-kwama warijira enena-manja ngawa angalya na-likenu-murrumanja ababurne-ka awurruwurrariya ngayuwa-wa,” ni-yama nakina. Kembirra neni-yengbijuwama nakina niyukwujiya Yibureyima nenimikirra, mena akina ekirra Yibureyima ne-yaminama “nginu-kwama warijira.” ");
INSERT INTO aoi_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Bi...ya ngalaja mamurndakakina mamangbala mambilyuma mamarika meninginingaba iya yinungkwura yininginingaba numurndaki-yuweyinuma Yijiba-manja. ");
INSERT INTO aoi_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","Kembirra arakba mamangbala mambilyuma mamarika muwurruwurrariya ngalamba-langwa iya yinungkwura yuwurruwurrariya numurndaki-yuweyinuma, ni-yama-murrada adinuba-wiya nakina Jawijiba. Nara arakba ka-lungkuwarringina aninga akwa murumureya nuw-ambilyuma aburraja warnumamalya ababurna-manja angalya. Wulkwa Yijiba-manja awilyaba akina aninga nuw-ambilyumurra ngawa aburra-langwa-manja alikira eninganinga. ");
INSERT INTO aoi_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","56","Ngalaja num-arriyadinuma angwurra ngawa mamurndakakina mamarika iya yinungkwura ababurna-manja angalya Yijiba. Aburraja kembirra arakba WarningiYijiba warnumamalya namurndaku-mureyanguma akwa namurndaki-likenuma arakba wurrakina narumu-wa nubungkawa. Neni-yukwamajuwama aninga-wa, akena eneja naruma nubungkawa ni-yama aburruwa-wa, “Wurri-likaja angerriba Jawijibu-wa akwa wunumin-engkirrikaja ena-langwa ayakwa,” ni-yama. Kembirra aburraja namurndaki-likenuma wurrakina Jawijibu-wa. Kembirra eneja Jawijiba nakina nu-ngwurrkbalijuwama arakba amurndakibina alikira eninganinga akwa nenu-kwama ebina aninga WarningiYijibu-wa warnumamalya. Kembirra aburraja arrkala nenu-kwama angwarnda Jawijiba-manja. ");
INSERT INTO aoi_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Aburraja wurrababurna warnumamalya engka-langwa angalya namurndaki-likenuma Yijibu-wa warniki-beyindi-yada aninga, mena muwurrariya-babe-ka mamarika iya yinungkwura ababurna-manja angalya-da. ");
INSERT INTO aoi_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","5","Yande-ka eyukwujiye-ka aninga akina Kenina-manja nuw-ambilyu-murrumanja Jekaba akwa ena-langwa warnumamalya. Aburraja murumureya nuw-ambilyume-ka. Biya n-engkirrika-manja nakina Jekaba akina ababurna aninga Yijiba-manja, kembirra ni-yama ena-langwu-wa warninikuwena, “Kwurruwa-yi! Kirri-yaminjamarrkinama kirrakina kirri-lyelyelyimbukweyinama? Wurri-likaja-langwa Yijibu-wa. Aba bu-makame-ka ayakwa ningena ababurne-ka aninga akina-manja angalya,” ni-yama. “Yiki-likaja yenjerrikina akwa yiku-beyindena aninga kajungwa nari-yada murumureya a-jungwajuma ngakwurruwa,” ni-yama. Aburraja Jawijiba-langwa wurrarrkwurrkuwena wurrumemberrkwa kembirra na-likenuma yenjerrikina akinu-wa angalya Yijibu-wa aburruwa wurrukwala warnumamalya, kajungwa warniku-beyindi-yada aninga. Umba eneja aburra-langwa nenikumarnjarringba Benjimina n-ambilyuma nakina angalya-manja. Nara nakina keni-larrkena eneja nungwenikba wurrarrkwurrkuwena-manja kini-likena, mena ni-lyelyingminu-mubaba angwurra nakina niyukwujiya naburradikba Rejila-langwa, akwa n-engkirrikenu-mubaba nakina neniyuwangkwa kenak-arriyakama awurrariya. Kembirra nara keni-larrkena kini-likena engku-wa niyukwujiya Benjimina-da. ");
INSERT INTO aoi_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Akini-yada ngawa eneja Jawijibe-ka nakina nubungkawa Yijiba-manja adinakba. Umba aburraja wurrababurne-ka warnumamalya nawurraki-likenumurra ababurna-langwa angalya yenjerrikina enuwa-wa, kajungwa warniku-beyindi-yada aninga. Aburrajukwaba ngawa ena-langwa wurrarrkwurrkuwena na-likenuma wurrakina yenjerrikina enuwa-wa akwa namurndak-abuluwendijeyinuma enuwa-manja nuw-engmudirruwajungwunuma warnumukwurra ajiringka-manja. Namurndak-abuluwendijeyinu-manja wurrakina, nenu-wilyakajuwama nakinu-wa warningma wurrakina narume-ka nakina numikbiyiya nilyengma. ");
INSERT INTO aoi_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","8","Umba neni-rringkama eneja nakina Jawijiba wurrumurndakakina akwa nenu-mumiringkama nakina. Akena warningbale-ka aburraja wurrakina nakina Jawijiba-da. Nen-angungwarndirrangume-ka. Eneja nakina n-eningbalikajungwunuma wurrakina akwa ni-yengbinume-ka nakina ayarrkardidarra-murra ayakwa-da. “Ngamba-langwa karna?” ni-yama. “Angaluba yarna Kenina-langwa yirri-likenuma yiku-beyindeni-yada aninga,” ne-yama aburraja. ");
INSERT INTO aoi_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Eneja kembirra Jawijiba n-engkirrikenume-ka nakina alekbina-kiya-wa akwulyangburarrka arakba-wiya adinuba-wiya ni-lyangburarrkinu-murruwa aburruwa-langwa. “Kirri-likenume-ka karna yangkwurrangwa kajungwa yik-aburangkini-yada kwureya yiku-mekbalyini-yada yika-rringkini-yada wurrumurndakayuwaya-murrikba yirra-langwa warnumamalya amurndakenena-manja angalya Yijiba akwa awinyamba yiki-ngekburakini-yada kirrakina,” ni-yama. ");
INSERT INTO aoi_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","“Nare-ka,” ne-yama aburraja. “Yarningerribirre-ka yarna yarnumamalya akwa yarningma nungkuwa ningkaruma ningkubungkawa ningkakina. Yirri-likenuma yarna yangkwurrangwa yarniku-beyindi-yada aninga, nara akwala. ");
INSERT INTO aoi_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Yarne-ka yirrumangadiyerra-manja-wiya yarningabe-ka yarnumamalya yarna yirrilyangmandukwuna, akwa nare-ka yarna a-ngayinduma a-mekbalyuma angalya,” ne-yama wurrakina. ");
INSERT INTO aoi_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Eneja Jawijiba ni-yama, “Nara, kirri-likenume-ka karna yangkwurrangwa-da kirramurndaki-rringkama warna warnumamalya wurrumurndakayuwaya-murrikba-da,” ni-yama. ");
INSERT INTO aoi_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Aburraja ne-yama, “Bungkawa, adinuba-wiya yirrumemberrkwa yirrambilyuma yarna yirrumangadiyerra-manja. Yarna ngawa yarninikuwena nuwilyaba-ma-langwa nungwarrka, akina-manja angalya Kenina. Akena nuwilyaba nakina ni-jungwuma umba niyukwujiya-dangwa nangaba-wiya n-ambilyama nungwarrka-manja,” ne-yama. ");
INSERT INTO aoi_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","“Nare-ka. Ning-engkirrikajama ngawa karne-ka kirri-likenuma kirru-mekbalyinuma enenu-wa angalya-da,” ni-yama eneja. ");
INSERT INTO aoi_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","16","“Akwa k-engkirrikajama ngawa akina yanda-langwa k-eningmidinama ningena kwureya yiku-makina-murrikba alyangmandukwuna ayakwa,” ni-yama. “Kembirra ki-dirrukweyinama ayakwa nungkwurruwa-wa. Yelakwa ngawa ka-didenama karna akididijungwa-manja. Umba kirruwilyaba karna yiki-lawurradinama angalyu-wa yikin-angkirnama nenikumarnjenungwu-wa yangkwurrangwa. Nara-manja kirrakina a-wilyakama nakina yangkwurrangwa ngayuwa-wa, kembirra nganja ki-lyangkuwerribikajungwunama ngayuwa kirri-likenuma karna yangkwurrangwa kirru-mekbalyinuma. Nara karna kirrukwala a-lawurrakajuma ngayuwa ambaka angalyu-wa yanda-langwa nakina nenikumarnjenungwa kini-yar•denama yelakwa. Ningena ena ayakwa ningi-yengbinama nungkwurruwa-wa aduwaba akwa ningi-yengbijinama ekirra naruma-langwa nubungkawa. Nakine-ka nubungkawa ni-lyinginama amurndakenena angalya ababurna-langwa Yijiba, akwa ningi-yengbijinama ena-langwa ekirra kajungwa engbudi-yada ena ayakwa nganyangwa,” ni-yama. ");
INSERT INTO aoi_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Kembirra nen-akumarnuma wurrakina akididijungwa-manja. Akwa aburraja na-mungkwuluma yakwujina arrawa mabiyakarbiya marringa. ");
INSERT INTO aoi_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Mabiyakarbiya-manja ngawa mamawura eneja Jawijiba kembirra ni-yama nakina wurrumurndakakinu-wa warnungkwarba, “Ningene-ka ningeni-yangmarngkwajinama Neningikarrawara akwa nara ngayuwa a-ngayinduma ngi-jungwuma karna karnumamalya. Kembirra nungkwurraja yikinu-wilyakina-manja nenikumarnjenungwa yangkwurrangwa karniba yik-ambilyama. ");
INSERT INTO aoi_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Kembirra nganja ka-larrkajama kirrukwala ningena, umba kirruwilyaba karna yik-ambilyama yelakwa enena-manja akididijungwa kajungwa k-eningmidini-yada ngayuwa kirrilyangmandukwuna karnungkwarba kirrakina. Umba kirrukwala yiki-lawurradina angalyu-wa, aninga yiku-wilyakina ebina kirru-manguma, kajungwa nari-yada nungkwurra-langwa warnumamalya a-murumureyuma warningangkawura wurrakina. ");
INSERT INTO aoi_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Kembirra yiki-lawurradina yikinu-wilyakina nungkwurra-langwa nenikumarnjenungwa yangkwurrangwa ngayuwa-wa. Kembirra nganja k-eningmidinama ngayuwa alyangmandukwuna ayakwa kirri-yengbinuma aduwaba ngayuwa-wa. Akwa nara kemba a-ngajuma kirrakina,” ni-yama Jawijiba aburruwa-wa. Aburraja namurndaki-lyangkuwama akwa ne-yama Jawijibu-wa, “Yiki-yaminama yarna ebina yirra-makama,” ne-yama. ");
INSERT INTO aoi_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Kembirra na-makijeyinuma wurrakina. “Yawe-ka,” ne-yama. “Ngarne-ka ngarri-didijungwunuma akididijungwa-manja mena ngarru-makwunu-mubaba nenikumarnjanyungwa ngakwurra-langwa wurrumurndakibinu-wa warnumamalya. Nara ngarna ak-engkirrikena ena-langwa ayakwa nu-werrikawarriyadinu-mulangwa nakina akwa nu-warduwardeminu-mulangwa, akwa ngarreni-yendabenu-mulangwa ngarribina akinu-mamurikajuwi-yada nakina. Akina-langwa-bina kemba ngarna ngarri-didijungwunuma-da,” ne-yama wurrakina-da. ");
INSERT INTO aoi_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Kembirra Rubina nakina ni-yengbinuma ayakwa wurrumurndakakina-manja wurrarrkwurrkuwena ena-langwa. Ni-yama, “Kirribina-bina ngarra-makama nara-maka akini-ngajuwa nakina, akena nara yik-engkirrikena ayakwa nganyangwa. Akina-langwa-bina kembirra enena awurrariya na-likenuma ngakwurruwa-wa-da,” ni-yama nakina Rubina. ");
INSERT INTO aoi_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Umba eneja Jawijibe-ka nakina neningma amurndakakina ayakwa ne-yengbinuma wurrakina. Akena aburraja warningbale-ka wurrakina, mena nara-baba kini-yengbina ena-langwa-murra ayakwa umba wulkwa EningiYijiba-murra ayakwa ni-yengbinuma nakina. Aburraja wurrukwala nenumini-yarrkuwarrukwajuwama ayakwa ena-langwa kajungwa warnik-engkirriki-yada wurrakina. ");
INSERT INTO aoi_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Umba eneja Jawijiba nakina arakba akwudangwa kinu-ngwadinuma, akena nara keni-ngayindanga nakina keni-rringka wurrarrkwurrkuwena kinu-ngwadina akwa ni-jadinga aduwaya akina-langwa angalya nuw-ambilyu-murrilangwa. Biya ngarningka ni-ngayindangu-manja nakina neniki-yengba ayakwa ni-lawurradinuma aburruwa-wa. Kembirra nakina nu-wekbalyinuma Jimiyina neniki-didiki-yada nakina alikira-manja arrawa akwa nenu-makama wurrukwala-manja ena-langwa warnikuminuwar•duwar•da, umba aburraja nen-ararikama nakina yakwujina ngawa wurrarrkwurrkuwena nuw-ambilyu-murrumanja wurrakina-da. ");
INSERT INTO aoi_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Eneja Jawijiba nakina ni-yama nenu-makama ena-langwu-wa warnikuminuwar•duwar•da, “Wurramini-lyangburrukwajina madidirrungwarna beka meninganinga, kajungwa warniki-lawurrakaji-yada warna warnungkwarba angalyu-wa. Akwa wurramini-lawurrakajiya ebina angwarnda aburra-langwa beku-wa muwilyuwilyaba-wiyu-wa wurramin-awiyebajiya. Akwa wurra-kwuna ngarningka aninga kajungwa kuw-alyubarini-yada lukwakwa,” ni-yama Jawijiba. Aburraja wurrumurndakakina ena-langwa warnikuminuwar•duwar•da kembirra na-likena akwa ne-yamama akina nenu-maka-murrilangwiya Jawijiba. ");
INSERT INTO aoi_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Umba kembirra aburraja Jawijiba-langwa wurrarrkwurrkuwena narruma-larrnjawudanga mamurndakakina beka dakina-manja dangki. Biya narri-lalika kembirra arakba akina angalya Jawijiba-langwa warniki-lawurradi-yada Keninu-wa. ");
INSERT INTO aoi_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Biya na-likena ngawa wurrakina bi...ya yanda-langwa numu-merrkawiyebuma mamawura akwa na-lyarrngwalyilyaduma. Kembirra nuwilyaba nakina num-ambijangaja beka ena-langwa neniku-kwi-yada aninga dakina dangki. Akena n-akburrange-ka akina angwarnda makina-manja ngawa beka memedirra. ");
INSERT INTO aoi_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Biya nenuwurrak-ardija nakina ena-langwu-wa wurrarrkwurrkuwena akwa ni-yama, “Ene-ka nganyangwa angwarnda memema-manja beka-da. Aburraja bumini-lawurrakajuwame-ka ngayuwa-wa-da!” ni-yama. Kembirra aminakina-langwa nuw-arndirndaduma na-minjirrkakbar•dume-ka wurrakina. Akwa nawurraki-yendabijeyinuma wurrakina akwa ne-yama, “Ni-yamarrkame-ka nakina Neningikarrawara ngakwurruwa-manja-bina?” ne-yama wurrakina-da. ");
INSERT INTO aoi_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Nawurrak-alilikenume-ka ngawa wurrakina bi...ya yanda-langwa nawurraki-yar•duma wurrakina Kenina-manja. Biya na-likenuma angalyu-wa wurrakina, akwa nenu-makama nungwarringba-manja amurndakibina ne-yama-mulangwa akina. Ne-yama wurrakina, ");
INSERT INTO aoi_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","“Nakine-ka nubungkawa nibina yirrenu-kwama aninga ni-yengbinume-ka nakina ayakwa ayarrkardidarra yirruwa-wa. Ni-yamama nakina, ‘Dangbe-ka yarna yirri-likenumurra yenjerrikina kajungwa yarniki-rringki-yada akina angalya aburra-langwa, akwa yarnik-eningmidi-yada wurrarrubuda-murrikba akwa wurrumurndakayuwaya-murrikba warningakwujina warnumamalya,’ ni-yamama nakina. ");
INSERT INTO aoi_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","“Umba yirraja yarna, ‘Nara a-mekbalyuma angalya-da,’ yirri-yamama enuwa-wa. ‘Umba yirrilyangmandukwuna-wiya yarna yarnungkwarba-da. ");
INSERT INTO aoi_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Yirruwe-ka yarna yirrumemberrkwa yirrambilyuma yirrarrkwurrkuwena yirr-ambilyumurra. Nuwilyaba-murra ngawa nungwarrka yirra-langwa. Umba eneja nuwilyaba ni-jungwuma nenikumarnjarrka nakina. Umba eneja nuwilyaba nijira-dangwa nungwarrka-manja ngawa nakina Kenina-manja angalya,’ yirri-yamama. ");
INSERT INTO aoi_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","“Eneja nenungkwarba ni-yamama nakina, ‘Ki-dirrukweyini-yada ngayuwa ayakwa nungkwurruwa-wa kajungwa k-eningmidini-yada ngayuwa kirrilyangmandukwuna-murrikba karnungkwarba kirrakina. Kembirra kirruwilyabe-ka karna yik-ambilyama ngayuwa-manja yelakwa. Umba kirrukwala yiki-likajama karna yiku-wilyakinama aninga nungkwurra-langwu-wa warnumamalya nari-yada murumureya a-jungwajuma wurrakina. ");
INSERT INTO aoi_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Biya yiki-lawurradinama yangkwurrangwa, yikinu-wilyakinama nenikumarnjenungwa nungkwurra-langwa nibina niyukwujiya-dangwa. Yikinu-wilyakina-manja nakina ngayuwa-wa kembirra nganja k-eningmidinama ngayuwa kirrilyangmandukwuna karnumamalya kirrakina-da. Kembirra ngayuwa kamini-lawurrakajinama naka nenungkwarba nungkwurruwa-wa. Nungkwurraja kembirra yiki-ngayindena-manja kirrakina enena-manja ngawa angalya yik-ambilyamurra. Yik-ambilyamurra akwa yikumurndaki-likajama erribirra yelakwa enena-manja angalya,’ ni-yamama nakina nubungkwa yirruwa-manja,” namurndaki-yama wurrumurndakakina wurrarrkwurrkuwena neniyuwangkwu-wa Jekabu-wa-da. ");
INSERT INTO aoi_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Biya kembirra narrumamurndaku-ngwur•dangmajuwa aburra-langwa beka akena mamurndakakina-manja ngawa beka muwilyuwilyaba-wiya-manja narrumurndak-akburrangarna ebina-murrada angwarnda narra-kwa-murrada WarningiYijiba-manja warnumamalya. Akine-ka angwarnda narri-rringka-manja wurrumurndakakina akwa enejukwaba nungwarringba na-minjirrkakbar•dume-ka wurrakina-da. ");
INSERT INTO aoi_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Ni-yama nakina Jekaba, “Ena-bina kirri-yama-mulangwa nungkwurruwa-da. Kembirra akina-langwa kawurraki-lyumadinama aburraja wurrababurna-langwa nganyangwa warijira. Jawijiba arakba nara nibina-da. Enejukwaba Jimiyina nara nibina. Kembirra ngarningka kini-ngayindenama enejukwaba Benjimina yikinu-wilyakinama kirrakina engku-wa ngayuwa-langwa. Karne-ka yirru-werrikawarriyakinama ngayuwa angwurra,” ni-yama Jekaba nakina-da. ");
INSERT INTO aoi_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Rubina eneja ni-yama nakina nungwenikba-wa, “Ngayuwa ningena kin-akwurrajinama nakina Benjimina,” ni-yama. “Nara-manja amini-lawurrakajuma nakina nungkuwa-wa, kemba ningkakine-ka ka-wardenama wunambilyuma nenikuwarrka-kiya-da. Akena amandangwa ningena kini-lawurrakajinama ngayuwa,” ni-yama nakina Rubina-da. ");
INSERT INTO aoi_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Eneja Jekaba ni-yama, “Nara naka nenikuwarrka nganyangwa Benjimina ngi-larrkama mena nawenikba ni-jungwu-mubaba-da. Nakina-bina nuwilyaba-ma n-ambilyama arakba-da niyukwujiya-da. Ningene-ka ningeniyuwangkwa arakba. Umba kenak-akburranga-manja awurrariya ena-langwa lukwakwa, kembirra ningena ki-jungwuma-da. Nungkwurraja yiku-wurrariyakinama kirrakina ngayuwa-da akwa yiki-jungwajinama ngayuwa ningeniyuwangkwa-da,” ni-yama nakina Jekaba-da. ");
INSERT INTO aoi_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","2","Aburraja wurrumurndakakina wurrarrkwurrkuwena nuw-ambilyuma Kenina-manja nungwarringba-manja wurrakina akena aninge-ka akina na-warrngkijerridinuma arakba. Eneja Jekaba akwa ena-langwa warninikuwena ebina aninga angaluba narru-wilyakama wurrumurndakakina wurrarrkwurrkuwena nuw-alyubarinuma ababurna-langwa amurndakakina. Murumureye-ka namurndak-ambilyuma warningangkawura-da. Biya kembirra nakina Jekaba ni-yama arakba warninikuwenu-wa, “Wurri-lawurradina-langwa ngarningka Yijibu-wa akwa wurru-beyindena-langwa aninga ambawura ngakwurraja,” ni-yama. ");
INSERT INTO aoi_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Akena eneja nakina Juda ni-yama ena-langwu-wa nungwenikba, “Numinakine-ka angalya nubungkawa nare-ka nakina awiyebajuma yirruwa-da yanda-langwa yikinu-wilyakinama nenikumarnjarrka. Akina-bina yirrenu-makama-da. ");
INSERT INTO aoi_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Benjimina nakina kini-larrkaja-manja nungkuwa yirruwa-manja yirraja kemba yarna yiku-beyindenama aninga. ");
INSERT INTO aoi_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Umba nara-manja nungkuwa ngi-larrkama, nara kemba yarna ngi-likama-da. Eneja nakina nenumamalya yirrenu-makama nara yarna a-rringkama, wulkwa yirruwa-manja enejukwaba nenikumarnjarrka kini-likaja-manja-da,” ni-yama Juda nungwenikba-wa-da. ");
INSERT INTO aoi_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Eneja Jekaba ni-yama, “Mena-burra kinu-maka naka-langwa nenikumarnjenungwa? Akina-langwa-bina mijawara ngumu-wardanguma aduwaba-da. Nara-maka yikinu-maka kirrakina-da,” ni-yama Jekaba. ");
INSERT INTO aoi_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Aburraja kembirra warninikuwena arakba nenu-makama, “Akena niyirrbiyirrbe-ka ngawa nakina yirreni-yendabenuma yirra-langwa-langwa warnumamalya akwa ni-yamama, ‘Jerriya neniba ngawa nungwenungwa? Umba kinu-wilyakina ngarningka nenikumarnjenungwa yakwujina?’ Kembirra akina-langwa ni-yama-mulangwa yirraja yinu-makama akina-da. Yarningbale-ka yarna yikenu-maka nakina yarniku-wilyaka-langwa nenikumarnjarrka yirruwa,” ne-yama. ");
INSERT INTO aoi_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Juda ni-yama, “Ni-larrkiya eni-likaja ngayuwa-manja, kemba yiki-likajama yarna enena-wiya. Kembirra yiki-likaja-manja yarna, nare-ka murumureya a-jungwajuma ngakwurruwa akwa ngakwurra-langwa wurriyukwayuwa. ");
INSERT INTO aoi_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Ngayuwa-bina kin-akwurrajinama naka-da. Nara-manja ngayuwa a-lawurrakajuma naka ningkinyungwurra, kemba nungkwaja ningkakina yiki-lekbajama ngayuwa-wa. ");
INSERT INTO aoi_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Nara-manja yarna yik-embirrarina amiyerra kemba arngkambilyuma-ma arakba yiki-likenuma Yijiba-langwa yarna-da,” ni-yama Juda nungwenikba-wa. ");
INSERT INTO aoi_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Eneja Jekaba ni-yama nakina, “Nara-manja naka Benjimina ngi-likama, nara ngarna akburranguma aninga. Wunu-wilyakina kembirra wurri-likaja. Akwa yiku-wilyakina akwala eninginingaba amurndakijika yadada aminenena-langwa angalya ngakwurra-langwa, kajungwa yikinu-kwuni-yada nubungkawa. Yiku-wilyakina amukwarnjirrema eyukwujiya iya yilyakwa yiyukwujiya iya bungabungwa akwa amadidira amaninga. ");
INSERT INTO aoi_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Akwa yiku-wilyakina angwarnda wuburra ebina kirru-wilyakama ngarningka arngkambilyuma-ma. Yikamini-lawurrakajina kirrakina ebina narr-akumarnuma nungkwurra-langwa-manja beka. Dukwa aburraja na-lekbijungwuma-da. ");
INSERT INTO aoi_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Kembirra yiki-lawurradina warenja-bawiya nakinu-wa nenungkwarba, Benjimina yikinu-wilyakina. ");
INSERT INTO aoi_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Nganja ningena ningu-buriyaminama Neningikarrawaru-wa, kajungwa nakina nenungkwarba kin-errukwulini-yada nungkwurruwa-wa akwa keni-larrkaji-yada wunalakina Jimiyina akwa ngawa Benjimina keni-lawurradini-yada nungkwurruwa-manja. Dukwa nara aburnaja wunalakina ngi-lawurraduma, akena nara-manja a-likama Benjimina, nare-ka ngarningka nungkwurraja akburranguma aninga-da,” ni-yama nakina neniyuwangkwa-da. ");
INSERT INTO aoi_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Aburraja kembirra wurrumurndakakina wurrumangadiyerra-manja na-likenuma na-lawurradinuma Yijibu-wa Benjimina aburruwa. Narru-wilyakama angwarnda wuburra adinuba-wiya, akena arngkambilyuma-ma narru-wilyakama. Akwa ngarningka amurndakijika warniku-kwi-yada nubungkawa narru-wilyakama Kenina-langwa. Biya na-likena arakba-da. Nawurrak-alilikenu...wa. Yijiba-manja ne-yar•da. Biya Jawijibu-wa arakba na-likenuma. ");
INSERT INTO aoi_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Kembirra eneja nakina Jawijiba neni-rringkama wurrakina akena Benjimine-ka aburruwa-manja nakina. Biya nen-ardijuwa ena-langwu-wa nenikuminuwar•duwar•da nenu-war•dika-murruwa wurrukwala-manja warnikuminuwar•duwar•da ena-langwa-manja alikira. Biya ni-yama, “Wurra-wilyakina wurrumurndakeyina warnumamalya nganyangwu-wa alikira,” ni-yama. “Kuw-alyubarinama wurrakina ngayuwa-manja memerrkuwilyarra mamawura. Nungkwurraja kemba yiki-ngajina bulukwa, yiki-dakina akwa akwala aninga yiku-mena, yiki-larrngkwaburrena adinakba,” ni-yama nakina Jawijiba. ");
INSERT INTO aoi_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Kembirra eneja nakina nenikuminuwar•duwar•da nenu-wilyakama arakba wurrakina ni-yama-murrada Jawijiba ena-langwu-wa alikira. ");
INSERT INTO aoi_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Akena aburraja na-minjirrkakbar•danguma wurrakina mena nenu-wilyakama nakina Jawijiba-langwu-wa alikira. Na-lyangkiyama-bu wurrakina, “Nenaka ngarrenu-wilyakinama yenjerra ebina-langwa angwarnda-da beka-manja narri-lawurrakajuwa-murrilangwa adinuba-wiya-na! Kembirra dukwa akabu-menama warenja-bawiya-da akabu-ngajinama wurrakina akwa akabu-murrakajinama ngakwurra-langwa dangki-da. Kembirra ngarna akabu-menama ena-langwi-yada ngarnikuminuwar•duwar•da ngarningangkawura-da,” na-lyangkiyama-bu wurrakina-da. ");
INSERT INTO aoi_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Kembirra narr-akburranga-manja akawiyuwiyeba Jawijiba-langwa-manja alikira, ne-yama wurrakina nakinu-wa nenikuminuwar•duwar•da, ");
INSERT INTO aoi_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","“Marrakba. Engkirrikiya-langwa yirruwa-wa. Yarne-ka yirri-likenuma ebina-wiya yangkwurrangwa yarniku-beyindi-yada aninga. ");
INSERT INTO aoi_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","22","Yirri-likenu-manja kembirra angalyu-wa wilyarra yirr-ambarringu-manja alyarrngwalyilya yirruma-ngwur•dangmajuwama yirra-langwa beka. Kembirra yirruma-ngwur•dangmajuwa-manja makina, yirra-langwa-manja memedirra beka yirri-rringkama yirrakina angwarnda ebina ngarra-kwama adinuba-wiya aninga-langwa. Dukwa angkaburra narr-akumarnuma akina angwarnda yakwujina? Yarningbale-ka yarna. Kembirra yarna ngarningka yangkwurrangwa yirri-lawurrakajuwama ababurna-langwa arakba ebina angwarnda akwa ngarningka angwurra ababurna angwarnda yirru-wilyakama yarniku-beyindi-yada enikaduwa aninga,” ne-yama wurrakina Jawijiba-langwu-wa nenikuminuwar•duwar•da. ");
INSERT INTO aoi_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Akena eneja ni-yama nakina aburruwa-wa, “Nara engkirrikuma akinu-wa. Nare-ka akbar•duma. Dukwa eneja nakina kirrenumin-akumarnuma akina angwarnda Neningikarrawara, nibina-murrada kini-yangmarngkwajinama nungkwurruwa akwa nungwenungwa-da. Yawa, ningu-mangume-ka nganja akina angwarnda adinuba-wiya aninga-langwa,” ni-yama. Kembirra ni-likena nakina akididijungwu-wa akwa nenu-manguma Jimiyina akwa nenu-wilyakama arakba nakina wurrarrkwurrkuwenu-wa-da. ");
INSERT INTO aoi_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Biya kembirra nakina nenikuminuwar•duwar•da nen-awiyebajuwa arakba wurrakina arrawu-wa Jawijiba-langwu-wa alikira akwa nenu-kwa akungwa warnik-ajarri-yada alika. Akwa nanga-kwa aninga aburra-langwa dangki. ");
INSERT INTO aoi_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","26","Akwa nenu-maka wurrakina warnik-alyubara-langwa aninga Jawijiba-manja. Aburraja kembirra narri-larrngkwaburranga adinakba wurrakina amurndakibina amurndakijika narru-wilyakama Kenina-langwa kajungwa warniku-kwi-yada nakinu-wa Jawijiba. Kembirra memerrkuwilyarra-manja mamawura ni-yar•da arakba eneja nakina Jawijiba yakwujina. Aburraja kembirra narr-awiyebajuwa amurndakibina amurndakijika alikira-wa akwa nenu-kwa wurrakina Jawijiba-manja akwa ngawa nawurrak-abuluwendinga nuw-engmudirruwajungwunuma warnumukwurra ajiringka-manja enuwa-manja. ");
INSERT INTO aoi_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Kembirra eneja ni-yama nakina, “Laka, karningaba? Ebina-wiya yirru-makama nungkwurra-langwa-langwa nungwenungwa. Laka, nakina neningaba? Nakina neningaba ngawa akwa neniba n-ambilya?” ni-yama. ");
INSERT INTO aoi_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Aburraja ne-yama, “Yirra-langwa nungwarrka nenibe-ka nakina ngawa akwa neningaba,” ne-yama. Akwa ngarningka wurrakina nuw-abuluwendinga enuwa-manja, mena nubungkawa nakina-baba. ");
INSERT INTO aoi_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Eneja Jawijiba n-andiyinga akena neni-rringka nakina nenikumarnjenikba Benjimina nibina naburradikba dirndenikba-langwa. Ni-yama, “Naka-bina nibina yirru-makama niyukwujiya nenikumarnjenungwa nungkwurra-langwa-na?” Kembirra ni-yama nakina Benjiminu-wa, “Ngeniyerriya nungkuwa. Enu-marngkirradina Neningikarrawara nungkuwa-manja,” ni-yama. ");
INSERT INTO aoi_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Jawijibe-ka nakina neni-kbarrngajume-ka neni-rringka-mulangwa nenikumarnjenikba Benjimina. Akwudangwe-ka ne-yar•danguma angwada. Kembirra ni-lalika akina angalya warenja-bawiye-ka akwa ni-lika ena-langwu-wa angalya akwa nu-ngwadina yakwujina. ");
INSERT INTO aoi_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Kembirra n-ajarrijajungwunuma nenumukwurra nu-mungkwur•dinuma angwada nakina akwa ngarningka ni-lawurrada nu-mungbudirrkajungwuna. Akwa nenu-maka nakina wurrukwala-manja warnikuminuwar•duwar•da warniku-wilyaki-yada aninga yenjerrikina. ");
INSERT INTO aoi_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Nakine-ka Jawijiba n-enjawurikajungwuma, nakwukawura ni-rrakarjeyuma awilyaba-manja debula umba aburraja waka engka-langwa-langwa wurrakina nuw-angmakayanguma wurrarrkwurrkuwena. Aburrajukwaba wurrakina wurrukwala wurruminakina angalya WarningiYijiba warnumamalya nuw-alyubarinuma aninga yakwujina. Wurreyebijeba aburrajukwaba mena na-waranguma wurrakina nara kuw-ambarrina wurruminjirrkingka-manja warnumamalya. ");
INSERT INTO aoi_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Umba aburraja wurrakine-ka wurrarrkwurrkuwena nuw-angmakayanguma akwudangwa Jawijiba-manja na-kwurukweyinuma, narra-maka-mubaba adinakba-kiya wurrakina warnik-ambarringa-langwa. Kembirra Rubina adinuba-wiya n-ambarringa mena-baba neningadinuba-wiya naruma nakina, kembirra Jimiyina-murriya, kembirra arija-langwa Benjimina niyukwujiya-dangwa n-ambarringa. Nuw-angmakayanguma wurruwurrangekburne-ka, naruma-dangwa adinuba-wiya akwa jujuj angerriba niyukwujiya-wa. Umba narri-rringka-manja akina kembirra ne-yakikbijangeyinume-ka wurrakina-da. ");
INSERT INTO aoi_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Eneja kembirra Jawijiba nenu-kwama akina aninga ena-langwa-manja warnikuminuwar•duwar•da umba aburraja narri-lyilyanguma ena-langwu-wa wurrarrkwurrkuwena. Akena Jawijiba nakina nenu-kwama angwurra ababurna aninga Benjimina-manja. Arngkumangbala-me-ka aninga Benjimina-langwa-da. Aburraja kembirra nuw-alyubarinuma wurrakina akwa ngawa akubibeka ne-bekeyinuma yanda-langwa nawurraku-bungwurridinuma wurrakina-da. ");
INSERT INTO aoi_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Kembirra narri-jerrukwa-mulangwa aninga, eneja Jawijiba nakina nen-ardijuwa ena-langwu-wa nenikuminuwar•duwar•da nibina nenu-war•dika-murruwa wurrukwala warnikuminuwar•duwar•da ena-langwa-manja alikira. Akwa ni-yama nakina enuwa-wa, “Wurramini-lyangburrukwajina mababurna-langwa beka meninganinga,” ni-yama nakina. “Akwa yikamini-lawurrakajina akina ngarningka angwarnda mamurndakakina-manja beka memedirra muwilyuwilyaba-wiya-manja. ");
INSERT INTO aoi_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Akwa kum-akumurna ngarningka nganyangwa menarlamba meningilyamarmba mijilba-murra yakwujina nenikumarnjarringba-langwa-manja beka memedirra,” ni-yama Jawijiba. Kembirra eneja nakina nenikuminuwar•duwar•da ni-likena akwa ni-yamama akina nenu-maka-murrilangwiya Jawijiba. ");
INSERT INTO aoi_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Mingka-manja meninguwurdarriya-wiya mamawura eneja Jawijiba nu-mirajanga akwa neni-larrka wurrakina warnungkwarba akwa aburra-langwa dangki. Aburraja kembirra na-likena arakba. ");
INSERT INTO aoi_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Akena na-likenu-manja wurrakina arngkidarrba-langwiya, ni-yengbina eneja nakina Jawijiba nibina-manja nenikuminuwar•duwar•da ena-langwa. “Jeyi warenja!” ni-yama nakina. “Wurra-larrmiya wurrakina warnungkwarba. K-akburranga-manja wurrakina, ena ayakwa ka-makina. ‘Kirri-yamarrkama karna nganyangwa-manja nubungkawa?’ ki-yama. ‘Neningabe-ka nakina nungkwurruwa-manja akena nungkwurraja kinumini-lawurrakajuwama awurrariya enuwa-wa. ");
INSERT INTO aoi_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Mena-burra kirr-angmaduma kirrakina mibina menarlamba meningilyamarmba ena-langwa wuburra mungkwabukwaba numi-yamama? Nara ngarrukwala ngarningerribirra ngarnumamalya e-bekuma makina-langwa, wulkwa enuwa yimbukwa nabalija-baba. Kini-ngayindangu-manja nenik-eningmida-langwa warnumamalya-langwa ne-yama-mulangwa wurrakina, kembirra makina-bina kinuma-manguma kenamu-wilyakajuwi-yada. Karne-ka kirri-yamama awurrariya!’ ki-yamina,” ni-yama Jawijiba nenu-makama ena-langwa-manja nenikuminuwar•duwar•da kajungwa neniki-yengbi-yada nakina ena-langwa ayakwa wurrakinu-wa wurrarrkwurrkuwena. ");
INSERT INTO aoi_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Eneja kembirra nakina nenikuminuwar•duwar•da ni-likena akwa nen-akburranga wurrakina. Kembirra arakba nenu-maka wurrakina-manja Jawijiba-langwa ayakwa. ");
INSERT INTO aoi_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Aburraja ne-yama wurrakina enuwa-wa, “Mena-burra ningki-yamina ena ayakwa? Nare-ka yirraja yarna yik-angmada menarlamba nubungkawa-langwa. ");
INSERT INTO aoi_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Nungkwaja ningkeningma ningkakina akena yirri-lawurrakajuwama angwarnda Kenina-langwa yangkwurrangwa ebina yirr-akburrangarnuma yirra-langwa-manja beka. Mena-burra yirraja yarna yik-angmadiya alarrngekburna angwarnda ajilba-murra iya akawulda-murra akwa eningerribirra amurndakijika alarrngekburna nungkwa-langwa-langwa nubungkawa? ");
INSERT INTO aoi_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Nungkwaja kum-akburranga-manja ningkakina makina menarlamba yirruwilyaba-manja, kembirra ningkakina kini-ngajinama nakina nenungkwarba. Kemba yirrumurndakenena yirrukwala aduwaba nungkwa-langwa yarnikuminuwar•duwar•da yirrababurna-langwa,” ne-yama wurrakina nakinu-wa nenikuminuwar•duwar•da Jawijiba-langwa. ");
INSERT INTO aoi_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Ni-yama kembirra enamba-langwa nakina, “Eningabe-ka akina ayakwa kirri-yengbinama, akena kirribina yikuma-wilyaka-manja menarlamba kemba kirrakina karnikuminuwar•duwar•da nganyangwa kirruwilyaba-ma yik-ambilyama-da. Umba kirrukwala karningaba yiki-likajama erribirra kirrakina angalyu-wa-da,” ni-yama. ");
INSERT INTO aoi_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Kembirra warenja-bawiya aburraja wurrakina narruma-larrijuwa dangki-langwa beka akwa narrumamurndaku-ngwur•dangmajuwa. ");
INSERT INTO aoi_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Eneja n-andeya numurndamurndirra ambaka-langwa nakina mamurndakakina-manja beka. Adinuba-wiya nakina n-aburradaduma n-aburangkama naruma-langwa-manja beka, Rubina-langwa-manja. Kembirra nuwilyaba-langwa-manja ngarningka nenikumarnjenikba akwa ngarningka nuwilyaba-langwa-manja n-aburangkama. N-aburangkeyina nakina yanda-langwa nenikumarnjarringba-langwa-manja beka num-akburranga mibina menarlamba-da, Benjimina-langwa-manja beka makina-da. ");
INSERT INTO aoi_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Aburraja wurrakina wurrarrkwurrkuwena narringamurndaku-kuwarranga aburra-langwa dumbala mena na-werrikawarriyadinu-murrubaba angwurra. Akwa narrumamurndaki-larrnjawudanga beka aburra-langwa ngarningka dangki-wa akwa na-lawurradina wurrakina ebinu-wa angalya nuw-ambilyu-murruwa awurrakwulyumida alikira iya warnumamalya arakba-da. ");
INSERT INTO aoi_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Eneja nakina Jawijiba n-ambilyuma ngawa ena-langwa-manja alikira. Aburraja kembirra ne-yar•da arakba yakwujina wurrarrkwurrkuwena wurrakina akwa nuw-abuluwenduma enuwa-manja nuw-engmudirruwajungwunuma warnumukwurra ajiringka-manja. ");
INSERT INTO aoi_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Biya, “Miyambena-burra kirri-yamama akina?” ni-yama Jawijiba aburruwa-wa. “Karningbala-burra kirrakina ngayuwa ningubungkawa? Ningeningme-ka amurndakibina nuw-abuwarrkajungwunama wurrukwala-langwa warnumamalya, akwa kembirra ningeningma amurndakakina eningerribirra kirri-yama-mulangwa kirrakina,” ni-yama nakina. ");
INSERT INTO aoi_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Eneja ni-yama Juda, “Karukwa. Nara ebina ayakwa yarniki-yengba-langwa nungkuwa-wa. Eneja Neningikarrawara nakina nginu-wilyakajuwama awurrariya yirra-langwa akena nara yirraja yarna a-wilyakajuma nungkuwa-manja yarna yarningaba yarnumamalya. Kembirra yirrumurndakeyina aduwaba yirrababurna-langwa nungkwa-langwa yarnikuminuwar•duwar•da arakba, umba nara nuwilyaba nakina nibina numa-manguma makina menarlamba umba yirrababurna-langwa,” ni-yama nakina Juda. ");
INSERT INTO aoi_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Eneja Jawijiba ni-yama, “A•a! Awurrariye-ka akina. Wurribina wulkwa narruma-wilyakama menarlamba nganyangwa wurrakina yimbukwa nganyangwa warnikuminuwar•duwar•da. Kirrukwala kirrakina yiki-lawurradinama kirringkinyungwurra nungwenungwa-wa,” ni-yama. ");
INSERT INTO aoi_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Kembirra eneja nakina Juda ni-likena Jawijibu-wa akwudangwu-wa akwa ni-yama, “Yimini-lalika-langwa ngi-yengba-langwa ambaka,” ni-yama. “Nare-ka awinyambaduma ngayuwa-wa. Ningkakina ningki-yaminama wuburra naruma nubungkawa nibina ni-lyinginama amurndakenena angalya ababurna-langwa Yijiba-manja-da. ");
INSERT INTO aoi_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Ningkakina ningki-yamama, ‘Jerriya neniba ngawa nungwenungwa? Umba kinu-wilyakina ngarningka nenikumarnjenungwa yakwujina?’ ningki-yamama yirruwa-wa-da. ");
INSERT INTO aoi_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Yirraja kembirra yirra-makama yirribina yirra-langwa-langwa nungwarrka akwa nenikumarnjarrka-langwa. Nakine-ka ni-rukwularruma neniyerringka-manja arakba nungwarrka-da. Naka-langwa nawenikba nara nibina, naka yimbukwa neniba ngawa aduwaba duwilyaba-ma-langwa dirndarringba-da. Umba ni-lyelyingminame-ka eneja nungwenikba nakina angwurra-da. ");
INSERT INTO aoi_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Nungkwaja yirru-makama yarniku-wilyaka nakina yangkwurrangwa ningkeni-ngayindangu-mubaba nungkuwa ningkakina ningkeniki-rringki-yada. ");
INSERT INTO aoi_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Akena yirraja yirri-yamama yirribina, ‘Nara nakina a-lalikama nungwenikba, mena keni-lalika-manja nakina kemba nungwenikba kini-jungwu-mubaba-da,’ yirri-yamama. ");
INSERT INTO aoi_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Ningki-yamama kemba nungkwaja, ‘Nara-manja nakina nungkwurra-langwa nenikumarnjenungwa a-wilyakama yangkwurrangwa, kemba nara ngarningka awiyebajuma kirrakina enenu-wa alikira nganyangwu-wa-da,’ ningki-yamama ningkakina-da. ");
INSERT INTO aoi_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","“Yirraja kembirra yirri-lawurradinu-manja nungwarrku-wa akina ayakwa nungkwa-langwa yinu-makama nakina-da. ");
INSERT INTO aoi_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","“Bi...ya arakba-langwa eneja yirrenu-makama yirra-langwa nungwarrka yarniki-lawurradi-yada yangkwurrangwa Yijibu-wa yarniku-beyindi-yada ngarningka akwala aninga. ");
INSERT INTO aoi_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Akena yirraja yinu-maka nakina, ‘Nare-ka. Nara-manja a-likama yirra-langwa nenikumarnjarrka yirruwa-manja, nara kembirra yarna ngi-rringkama nubungkawa. Yiki-likajama yarna wulkwa kini-likaja-manja nenikumarnjarrka enejukwaba yirruwa-manja,’ yirri-yamama-da. ");
INSERT INTO aoi_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Eneja ni-yama nungwarrka yirruwa-wa, ‘Karningma kirrakina nganyangwa dadingiyarrka Rejila narringalirraku-wilyakama wulkwa wunambilyuma wuniyukwujiya-kiya. ");
INSERT INTO aoi_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Nara arakba nibina nuwilyaba. Dukwa ngalaja yiningbala arakba yakina nenu-wardanguma-da. Eneja ni-likenuma nakina engku-wa akena nara kini-lawurradina-da. ");
INSERT INTO aoi_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Kembirra yikinu-wilyakina-manja naka nenikuwarrka aduwaba akwa ke-yama-manja awurrariya enuwa-manja, kembirra nganja ningena ki-jungwunama-da. Nungkwurraja yiku-wurrariyakinama kirrakina ngayuwa-da akwa ki-jungwunama ngayuwa ningeniyuwangkwa-da.’ Akina-bina eneja nganyangwa nungwarrka yirrenu-makama-da,” ni-yama nakina Juda Jawijibu-wa. ");
INSERT INTO aoi_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","31","Biya ngarningka ni-yama Juda, “Kembirra ki-lawurradina-manja nungwarrku-wa, nara-manja a-wilyakama nenikumarnjarrka, kembirra nakina nungwarrka kini-jungwuma-da. Kini-jungwunama neningangkawura nara-manja a-rringkama nakina niyukwujiya a-likama yirruwa-manja-da. Nakina ni-lyelyingminame-ka angwurra nakina-manja. Neniyuwangkwa-baba nakina, ngalaja kembirra kenamu-wardena-manja makina mijawara kenami-jungwajiyama makina mijawara nakina-da. ");
INSERT INTO aoi_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","“Akwa ngarningka nganja ningenu-makama nungwarrka-manja ngayuwa-bina kin-akwurrajina-mulangwa akwa kini-lawurrakajina-mulangwa nakina enuwa-wa-da. Ningi-yamama, ‘Nara-manja ngayuwa a-lawurrakajuma nakina ningkinyungwurra, kemba ningkakina yiki-lekbajama ngayuwa-wa ningkeningangkawura,’ ningi-yamama nungwarrku-wa. ");
INSERT INTO aoi_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Marrakba, ni-larrkaja naka eni-likaja wurrumurndakakina-manja wurrukwala wurrarrkwurrkuwena. Umba ngayuwa nganja yelakwa ningenikuminuwar•duwar•da nungkwa-langwa. ");
INSERT INTO aoi_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Nara-manja a-lawurrakajuma naka nungwarrku-wa ningena, nare-ka a-lawurraduma-da. Nara-manja naka nenikumarnjarrka nganyangwa a-lawurraduma enuwa-wa eneja kembirra nungwarrka kini-jungwunama nakina-da. Nara kembirra a-ngayinduma akina ningena nganja a-rringkama-da,” ni-yama nakina Juda Jawijibu-wa-da. ");
INSERT INTO aoi_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Eneja nakine-ka Jawijiba nara nakina amiyerra kinu-mungbudirrkajungwuna wurrakina-manja warnikuminuwar•duwar•da ena-langwa. Kembirra nenu-maka aburruwa-wa, “Wurri-jadiya-langwa errekbu-wa,” ni-yama. Aburraja kembirra na-jadinga wurrakina. Akwa kembirra nara wurribina wurrukwala yakwujina akini-yada ngawa nenu-maka-manja akina ayakwa enuwa-langwa akwa ni-yama-manja wurrarrkwurrkuwenu-wa, “Ngayuwe-ka ningena ningarrkuwenungwa Jawijiba.” ");
INSERT INTO aoi_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Akena nara kini-lyinga angwada ena-langwa umba nu-ngwadina angwurre-ka. Aburraja wurribina ena-langwa warnikuminuwar•duwar•da nuw-engkirrikenuma wurrakina errekba-langwa ni-ringirriyadinuma nakina. Wurrukwala kembirra wurrakina narri-lyilyanguma akina ayakwa nu-ngwadinu-mulangwa nakina naruma-wa nubungkawa ni-lyinga-murruwa ababurna-langwa angalya Yijiba-manja. ");
INSERT INTO aoi_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Eneja Jawijiba nakina ni-yama wurrarrkwurrkuwenu-wa, “Ngayuwe-ka ningena ningarrkuwenungwa Jawijiba. Nungwarrka nakina neniba?” ni-yama. Aburraja wurrarrkwurrkuwena nuw-engkirrika-manja nakina enuwa narrkuwarringba, nawurrak-akbar•duma wurrakina. Nara kembirra ke-yengbeyina ayakwa. ");
INSERT INTO aoi_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Eneja Jawijiba ni-yama nakina, “Kwa, wurri-likaja yangkwurrangwa akwudangwu-wa,” ni-yama. Nuw-akwudangwukajungwuna aburraja. Kembirra ni-yama nakina, “Ngayuwe-ka ningena nungkwurra-langwa ningarrkuwenungwa Jawijiba, ningibina kirra-kwa-murrada wurrukwalu-wa warnumamalya. Kembirra kirrabu-kwama angwarnda akwa bu-wilyakama yangkwurrangwa enenu-wa angalya Yijibu-wa. ");
INSERT INTO aoi_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Nare-ka nungkwurraja a-werrikawarriyaduma a-lekbijajuma kirra-kwa-mulangwa karna ngayuwa wurrukwalu-wa warnumamalya. Neningikarrawara-bina ngini-larrkama ningeniki-lika-langwa ningena yangkwurrangwa-da. Nginu-wilyakama adinakba yangkwurrangwa kajungwa ken-enibikini-yada wurrababurna warnumamalya nakina-da. ");
INSERT INTO aoi_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Mambilyuma arakba wulkwa mamarika iya yinungkwura ngalaja eyukwujiya ena aninga, umba mamangbala mamarika iya yinungkwura yubukwaya ngarningka ni-likaja-wiya eyukwujiya kuw-ambilyama aninga. Akini-yade-ka ngawa nare-ka aburraja amaninga-ma amarda a-lungkuwarrijuma warnumamalya mamurndakakina-manja mamarika iya yinungkwura. ");
INSERT INTO aoi_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","“Ningene-ka nginu-wilyakama eneja Neningikarrawara adinakba yangkwurrangwa kajungwa ka-mamurikajini-yada karna nari-yada murumureya a-jungwajuma nungkwurruwa akwa ngawa nungkwurra-langwa wurriyukwayuwa, akwa kajungwa yiki-jungwuna-manja nungkwurruwa kuw-ambilyi-yada numirena-murriya arija-langwa. ");
INSERT INTO aoi_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Nare-ka nungkwurraja yiki-larrkena yangkwurrangwa ngayuwa, umba eneja Neningikarrawara nakina nginu-wilyakama yenjerra-da. Ngayuwe-ka ningena nginu-bungkawakama Neningikarrawara ningubungkawa ningaruma-dangwa. Kembirra nganja ningu-bungkawadinama ngayuwa wurrababurna-langwa-manja wurriyukwayuwa wurrububungkawa amurndakenena-manja angalya. Wuburra nibina naruma-dangwa nubungkawa nganjukwaba ningu-bungkawadiname-ka ngayuwa amurndakeyina-manja arakba ababurna angalya enena-manja Yijiba. ");
INSERT INTO aoi_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","“Ena-wiya arakba wurri-likaja nungwarrku-wa akwa yikinu-makina enena ayakwa nganyangwa. Yiki-yamina, ‘Neningikarrawara nen-akumarnuma nenikuwena Jawijiba nubungkawa ababurna-langwa-manja angalya Yijiba-manja. Kembirra nungkwaja nara ambudiduma umba likaja warenja enuwa-wa, ");
INSERT INTO aoi_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","nungkuwa akwa ngawa nungkwurra-langwa wurriyukwayuwa akwa ngawa nungkwurra-langwa numirena-murriya aburrajukwaba. Yikuwurraku-warakina ngawa nungkwurra-langwa jiba iya nenukwuda iya bulukwa akwa ababurna-langwa amurndakijika nungkwurra-langwa angerriba enuwa-wa Yijibu-wa. Yakwujina kirrakina yik-ambilyama Yijiba-manja engemba-manja Kawijina. ");
INSERT INTO aoi_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Kembirra yik-ambilyama akwudangwa enuwa-manja kajungwa yiken-akwurrajini-yada nakina. Ngalaja akine-ka aninga kuw-ambilyama eyukwujiya mamangbala-manja ngarningka mamarika iya yinungkwura. Nara eneja a-ngayinduma murumureya a-jungwajuma nungkwurruwa iya nungkwurra-langwa warnumamalya akwa nungkwurra-langwa bulukwa-murriya,’ yiki-yamina kirrakina,” ni-yama Jawijiba. Akina-bu ayakwa nenu-makama nakina Jawijiba wurrarrkwurrkuwena-manja warniki-lawurrakaji-yada wurrakina ayakwa nungwarringba-wa-da. ");
INSERT INTO aoi_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Kembirra ni-yama ngarningka aburruwa-wa, “Kirrumurndakeyine-ka yirri-rringkinama ningena amandangwa nungkwurra-langwe-ka ningenikumarnjenungwa Jawijiba. Nungkwajukwaba Benjimina yi-rringkinama ningena Jawijiba. ");
INSERT INTO aoi_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Yikinu-makina nungwarrka ningena ningubungkawa enena-manja Yijiba, akwa yikinu-makina amurndakenena kirri-rringkinama ababurna-langwa aduwaba, akwa yikinu-wilyakina kwa yangkwurrangwa warenja,” ni-yama Jawijiba nakina ena-langwu-wa wurrarrkwurrkuwena-da. ");
INSERT INTO aoi_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Biya kembirra nen-engkarrnga nakina Jawijiba Benjimina-manja akwa nu-ngwadina arakba nakina. Enejukwaba nakina Benjimina enamba-langwa nu-ngwadina. ");
INSERT INTO aoi_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Kembirra Jawijiba nenumurndak-engkarrnga wurrababurna-langwa wurrarrkwurrkuwena-manja akwa ngawa nenumurndaki-lawurangka wurrakina angwada-murra nakina. Na-jerridu-manja akina angwada kembirra wurrumurndakakina wurrarrkwurrkuwena na-lyelyimbukweyinumurra Jawijiba-manja arakba. ");
INSERT INTO aoi_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Eneja kembirra nakina nubungkawa naruma-dangwa n-engkirrika-manja akina ayakwa ne-yar•du-mulangwa wurrakina wurrarrkwurrkuwena Jawijiba-langwa Yijiba-manja, ni-lyelyingmame-ka nakina. Akwa ngawa ena-langwa wurriyukwayuwa wurrububungkawa na-lyelyingmeyinuma aburrajukwaba wurrakina. ");
INSERT INTO aoi_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Ni-yama nakina naruma nubungkawa Jawijibu-wa, “Wurra-makina nungkwa-langwu-wa narrkuwena-murriya karri-larrnjawudena wurrakina aburra-langwa amurndakijika dangki-manja, akwa ka-lawurradina angerriba Keninu-wa. ");
INSERT INTO aoi_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","Akwa wurra-makina kenu-wilyakina nungwena akwa ngawa aburra-langwa wurradidingiyarrngwa akwa wurriyukwayuwa aburra-langwa yangkwurrangwa enenu-wa angalya. Ningene-ka ka-kwunama angalya eningaba-dangwa yelakwa Yijiba-manja aburra-langwi-yada akina-da. Ababurne-ka kembirra aninga aburraja kuw-alyubarinama. Nare-ka wurrakina a-jerrukwama akina aninga,” ni-yama nakina naruma nubungkawa Jawijibu-wa. ");
INSERT INTO aoi_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Akwa ngarningka nenu-maka nakina Jawijibu-wa warniku-wilyaki-yada wurrakina wurrarrkwurrkuwena mukwala marumuruma makangkidikarra mibina na-wilyuwilyakinama amurndakijika angerriba iya angerriba makina. Ni-yama nakina, “Angum-arrkirna jarrangwa mamurndakakina meyebirra angerriba Keninu-wa, kajungwa ka-lawurradina-manja Yijibu-wa wurradidingiyarrngwa akwa wurriyukwayuwa narrkuwena-murriya-langwa kembirra karrawurra-jawudeni-yada makina-manja. Akwa wurra-makina kenu-wilyakina ngarningka nungwena yangkwurrangwa Yijibu-wa aburruwa,” ni-yama nakina naruma nubungkawa Jawijibu-wa. ");
INSERT INTO aoi_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Biya ni-yama ngarningka enuwa-wa, “Wurra-makina nungkwa-langwu-wa narrkuwena-murriya, ‘Mama yiki-lalikina-manja ababurna-langwa amurndakijika nungkwurra-langwa yakwujina Kenina-manja, mena ababurne-ka amurndakijika eninginingaba yelakwa nungkwurra-langwa akina,’ ki-yamina ningkakina aburruwa-wa,” ni-yama nakina Jawijibu-wa-da. ");
INSERT INTO aoi_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Aburraja kembirra Jekaba-langwa warninikuwena narri-larrnjawudanga arakba wurrakina aburra-langwa amurndakijika aburra-langwa-manja dangki. Eneja nakina Jawijiba ni-yamama nakina nubungkawa-langwiya ayakwa akwa nenu-kwama ena-langwa-manja wurrarrkwurrkuwena mamurndakibina makangkidikarra akwa ngawa aninga warnik-alyubari-yada lukwakwa wurrakina. ");
INSERT INTO aoi_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Akwa nenu-kwama ngarningka nakina Jawijiba dadikaduwa dumbala wurruwilyuwilyaba-wiya-manja kajungwa warnik-awiyebi-yada. Umba Benjimina-manja yimbukwa nenu-kwama nakina dumangbala dumbala akwa ngawa 300 angwarnda ajilba-murra. ");
INSERT INTO aoi_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Akwa ni-larrkenuma nakina Jawijiba ababurne-ka amurndakijika eninginingaba EningiYijiba nungwenikba-wa. Aburraja narri-larrnjawudanguma kembirra amurndakakina dumemberrkwa-manja dangki. Akwa ngarningka dukwala-manja dumemberrkwa dangki narri-larrnjawudanguma wurrakina ababurne-ka aninga eminiminingka warnik-alyubari-yada wurrumurndakakina warnumamalya wurrababurna ka-lawurradina-manja wurrakina wurrarrkwurrkuwena karra-wilyakina-manja aburra-langwa wurradidingiyarrngwa iya aburra-langwa wurriyukwayuwa akwa nungwarringba angaluba Kenina-langwa akwa Yijibu-wa n-ambilyu-murruwa Jawijiba nakina. ");
INSERT INTO aoi_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Umba lukwuniyawa nara-wiya ka-likena wurrakina wurrarrkwurrkuwena, ni-yama nakina Jawijiba aburruwa-wa, “Nare-ka a-wurruwirrikbajuma lukwakwa,” ni-yama nakina. Kembirra neni-larrka arakba wurrakina. ");
INSERT INTO aoi_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Aburraja kembirra na-likena arakba, narri-lalika akina Yijiba umba na-lawurradina Keninu-wa-da. Bi...ya yakwujina Kenina-manja ne-yar•da arakba wurrakina. Biya na-lawurradinuma aburra-langwu-wa angalya akwa ngawa nungwarringba-wa Jekabu-wa. ");
INSERT INTO aoi_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Biya ne-yama wurrakina nungwarringba-wa, “Jawijibe-ka nakina neniba ngawa aduwaba! Akwa ni-lyinginama nakina ababurna angalya Yijiba-manja,” ne-yama. Akena eneja Jekaba n-arndirndade-ka akwa nenu-minikalyika nakina ebina ayakwa aburra-langwa ne-yengbeyinuma wurrakina enuwa-wa. ");
INSERT INTO aoi_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Umba nenu-makama wurrakina nungwarringba-wa ababurna-langwa ayakwa Jawijiba-langwa. Akwa nenu-wilyakajuwama enuwa-wa mamurndakibina makangkidikarra nenu-kwama Jawijiba kajungwa neniki-liki-yada enuwa akwa ngawa ena-langwa wurrukwala warnumamalya aburrajukwaba Yijibu-wa. Eneja kembirra nungwarringba nu-werringekburada arakba nakina n-engkirrikenu-mulangwa aburra-langwa ayakwa akwa ni-rringka-mulangwa amurndakibina ababurna-langwa. ");
INSERT INTO aoi_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Biya kembirra ni-yama nakina Jekaba warninikuwenu-wa, “Nganyangwa nenikuwarrka Jawijiba neniba ngawa nakina-da. Eningabe-ka akina. Akwa ningi-ngayindename-ka ki-likajama kini-rringkinama nakina ki-jungwuna-murruwa ngayuwa ningena-da,” ni-yama nakina Jekaba-da. ");
INSERT INTO aoi_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Biya kembirra nakina Jekaba akwa ngawa ena-langwa warnumamalya narruwurra-murndukwama aburra-langwa amurndakijika warniki-liki-yada wurrakina angerriba Yijibu-wa. Namurndaki-likenuma akena adinuba-wiya engembu-wa Biyajiba-wa namurndaki-likenuma. Biya yakwujina Jekaba nakina nenumini-daka bulukwa-murriya Neningikarrawara-langwa. Nakine-ka Neningikarrawara nibina-murrada nungwenikba-langwa Ajika-langwa. ");
INSERT INTO aoi_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Biya kembirra makina-manja ngawa meningalyarrngwalyilya Jekaba nenu-marngkirringkama Neningikarrawara nakina-da. Eneja Neningikarrawara n-ardanga enuwa-wa akwa ni-yama, “Nungkuwa Jekaba!” Eneja ni-yama Jekaba, “Miyambena?” ");
INSERT INTO aoi_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Eneja kembirra ni-yama Neningikarrawara Jekabu-wa arakba, “Ngayuwa Ningeningikarrawara ningena nungwena-langwa. Nara akbar•duma, umba likaja Yijibu-wa. Yiba-kwunama ningkena wurrababurne-ka numirena-murriya warnikinikaduwa nungkwa-langwa akina-manja angalya. Aburraja wurrakina kuw-ababurnadinama yanda-langwa wurrilyimberrkwulyumide-ka wurrilyimberrkuwilyaba warnumamalya ke-yaminama. ");
INSERT INTO aoi_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Umba ngayuwa ki-likajama ningena yakuwa Yijibu-wa. Kembirra ki-jungwa-manja ningkakina yakwujina, eneja nakine-ka Jawijiba kin-ambilyama ngawa nungkuwa-manja akwudangwa. Kembirra arija-langwa ambaka-murrumurra nganja kawurraki-lawurrakajinama ngayuwa nungkwa-langwa numirena-murriya warnikinikaduwa enenu-wa angalya,” ni-yama nakina Neningikarrawara Jekabu-wa-da. ");
INSERT INTO aoi_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Aburraja kembirra arakba Jekaba-langwa warninikuwena nen-akumarna nungwarringba iya aburra-langwa wurriyukwayuwa akwa wurradidingiyarrngwa mamurndakibina-manja ngawa makangkidikarra numa-larrkenu-murrumanja Jekabu-wa adinuba-wiya nibina nubungkawa naruma-dangwa NeningiYijiba. Biya narri-lalika arakba wurrakina Biyajiba ");
INSERT INTO aoi_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","7","kajungwa warniki-liki-yada Yijibu-wa. Umba narruwurraku-warakama aburra-langwa bulukwa-murriya akwa ngawa ababurna-langwa amurndakijika amurndakibina narru-manguma wurrakina nuw-ambilyu-wiya yakwujina Kenina-manja. Umba Jekaba nakina nenuwurraku-warakama ena-langwa warninikuwena iya dadiyawenikba akwa warnungkwarba iya wurridarringka wurrumirumirena enuwa-manja. ");
INSERT INTO aoi_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Eneja nenikuwenikba Jekaba-langwa nibina numilyengma Rubina ni-likenuma nakina enuwa-manja Yijibu-wa ");
INSERT INTO aoi_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","akwa ngawa ena-langwa wurrabiyarbuwa warninikuwena aburrubukwurrajukwaba. Warnimikirra wurrubukalakina Yenakwa iya Balu iya Yejirena akwa ngawa Karmi. ");
INSERT INTO aoi_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Aburrajukwaba Jimiyina akwa ngawa ena-langwa wurrumangbala wurruwilyaba warninikuwena na-likenuma wurrakina. Warnimikirra wurrakina Jemuwela iya Jamina iya Awada iya Jakina iya Jawura akwa ngawa Jawula. Umba Jawula-langwa dirndenikba DadingiKenina didarringka dakina. ");
INSERT INTO aoi_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Aburrubukwurrajukwaba Libaya akwa ngawa ena-langwa wurrabiyakarbiya warninikuwena nabuki-likenuma. Warnimikirra wurrubukalakina Kijena iya Kiyada akwa ngawa Marari. ");
INSERT INTO aoi_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Aburrubukwurrajukwaba Juda akwa ngawa ena-langwa wurrabiyakarbiya warninikuwena nabuki-likenuma. Warnimikirra wurrubukalakina Jela iya Bereja akwa ngawa Jera. Umba wunambilyuma warnikuwabulena Juda-langwa wunenimikirra Era iya Anana neni-jungweyinuma adinuba-wiya Kenina-manja ngawa wunalakina. Umba aburnaja Bereja-langwa warnikuwabulena wunenimikirra Yejirena iya Yamula aburnajukwaba neni-likenuma wunalakina Yijibu-wa. ");
INSERT INTO aoi_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Aburrajukwaba Yijakara akwa ngawa ena-langwa wurrabiyarbuwa warninikuwena na-likenuma wurrakina. Warnimikirra wurrubukalakina Dawula iya Buwa iya Jejuba akwa ngawa Jimirena. ");
INSERT INTO aoi_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Aburrubukwurrajukwaba Jebulina akwa ngawa ena-langwa wurrabiyakarbiya warninikuwena nabuki-likenuma. Warnimikirra wurrubukalakina Jereda iya Elena akwa ngawa Jaliyela. ");
INSERT INTO aoi_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Wurrumurndakakina wurrumangbala wurruwilyaba warninikuwena Jekaba-langwa yinginumin-arrangbama Liya n-ambilyu-wiya nakina Jekaba Mejubudamiya-manja. Umba ngalaja dadiyawenikba Jekaba-langwa dadimikirra Dayina yingi-rukwularruma ngalajukwaba yakwujina Mejubudamiya-manja. Dirndadikba ngalajukwaba Liya dakina. Kembirra wurrababurna-langwa wurrumurndakakina Liya-langwa wurrabuburrada iya wurrumurndakakina warnikabijada iya wurrebulada akwa ngawa daburradikba Dayina 33 warnumamalya wurrakina-da. ");
INSERT INTO aoi_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Aburrajukwaba Keda akwa ngawa ena-langwa wurrumangbala wurrambilyuma warninikuwena namurndaki-likenuma Yijibu-wa. Warnimikirra wurrakina Jebena iya Yaki iya Juni iya Ejibena iya Eri iya Arada akwa ngawa Areli. ");
INSERT INTO aoi_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Aburrajukwaba Ajera akwa ngawa ena-langwa wurrabiyarbuwa warninikuwena iya darrkuwarringba dadimikirra Jera namurndaki-likenuma wurrakina. Warnimikirra wurrubukalakina Yimina iya Yijibaya iya Yijibi akwa ngawa Beraya. Umba Beraya-langwa warnikuwabulena wunenimikirra Yebera iya Malkiyela aburnajukwaba neni-likenuma wunalakina. ");
INSERT INTO aoi_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Kembirra arakba wunalakina naburradikba-kiya Jilba-langwa iya warnikabijada akwa ngawa wurrebulada 16 warnumamalya wurrakina. Umba dakine-ka Jilba dadikuminuwar•duwar•da dakina, dibina Liya-langwa nungwadikba Lebina nanga-kwama dadiyawenikba-manja Liya-manja. ");
INSERT INTO aoi_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Umba ngalaja dakina Rejila dadingiyenikba Jekaba-langwa yinginumin-arrangbama wunambilyuma warnikuwabulena wunenimikirra Jawijiba iya Benjimina. ");
INSERT INTO aoi_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Ngalaja kembirra n-ambilyu-wiya Jawijiba yakwujina Yijiba-manja dadingiyenikba Ajineda narring-arrangbama dakina wunambilyuma warnikuwabulena wunenimikirra Muneja iya Yibureyima. Umba nakina nungwadikba Ajineda-langwa Badibera nakina. NuMinida nenungkwarba nakina WarningiYijiba-langwa warnumamalya, umba ena-langwa angalya Yeliyabulija akina. ");
INSERT INTO aoi_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Aburrajukwaba Benjimina-langwa warninikuwena wurrumemberrkwa namurndaki-likenuma nungwarringba-manja Yijibu-wa. Warnimikirra wurrakina Bela iya Beka iya Ajibela iya Kera iya Neyumena iya Yiyeya iya Rawija iya Mabima iya Wubuma akwa ngawa Arda. ");
INSERT INTO aoi_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Kembirra arakba wunalakina naburradikba-kiya akwa wurrumurndakakina warnikabijada Rejila-langwa wurrumemberrkwa akwa wurrabiyarbuwa warnumamalya wurrakina-da. ");
INSERT INTO aoi_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Aburnajukwaba Dena akwa ngawa nenikuwenikba nenimikirra Wujima neni-likenuma wunalakina Yijibu-wa. ");
INSERT INTO aoi_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Aburrajukwaba Nabudali akwa ngawa ena-langwa wurrubukarbiyarbuwa warninikuwena na-likenuma. Warnimikirra wurrubukalakina Jajiyela iya Kwuni iya Jejera akwa ngawa Jilema. ");
INSERT INTO aoi_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Kembirra arakba wunalakina wunambilyuma naburradikba Bilya-langwa akwa warnikabijada ngala-langwa wurrumangbala wurrambilyuma warnumamalya wurrakina. Umba dakine-ka Bilya dadikuminuwar•duwar•da dakina, dibina Rejila-langwa nungwadikba Lebina nanga-kwama dadiyawenikba-manja Rejila-manja. ");
INSERT INTO aoi_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Umba wurrababurna-langwa wurrumurndakakina wurrumirumirena Jekaba-langwa namurndaki-likenu-murrumurra Yijibu-wa 66-eka warnumamalya wurrakina-da. Akwa ngawa aburrajukwaba wurrarngkirngkiyena Jekaba-langwa nawurraki-likenumurra-da. ");
INSERT INTO aoi_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Umba nara-wiya ka-likena Jekaba-murriya Yijibu-wa wurrakina, eneja Jawijiba n-akumajungwunuma nakina wunambilyuma nenikuwenikba-kiya. Kembirra akini-yada n-ambilyu-wiya ngawa neniyuwangkwa Jekaba Yijiba-manja nakina, enuwa akwa ena-langwa warnumamalya wurribina nuw-ambilyu-murrumurra akina-manja ngawa angalya Yijiba 70-eka warnumamalya wurrakina-da. ");
INSERT INTO aoi_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Kembirra nakina Jekaba akwa wurrababurna-langwa ena-langwa warnumamalya narri-lalika aburra-langwa angalya Kenina akwa nawurraki-likena Jawijibu-wa Yijibu-wa. Biya kembirra Jekaba neni-larrka nenikuwenikba Juda ni-lyengmanga nakina adinakba kajungwa neniki-yarrkuwilyaki-yada Jekaba-langwa ayakwa Jawijibu-wa. Eneja kembirra Juda ni-lyengmanga ni-likena arakba nakina-da. Bi...ya ni-yar•da Yijiba-manja akwa ni-likena angwurra ngawa Jawijibu-wa. Biya ni-yama nakina enuwa-wa, “Nubukwaya arakba nungwarrka, umba nungkwaja likaja engembu-wa Kawijina-wa, kajungwa yikin-akburrangeyini-yada nakina yakwujina,” ni-yama. Aburraja Jekaba-murriya nawurraki-likena ngawu...wa. Bi...ya nawurraki-yar•da aburrajukwaba Yijiba-manja akwa nawurraki-likena Kawijina-wa. ");
INSERT INTO aoi_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Umba eneja nakina Jawijiba ni-njawudija ena-langwa-manja makangkidikarra meningaba-dangwa jarrangwa yingum-arrkirrkarnu-murrumanja akwa ni-likena nakina angerriba Kawijina-wa nenuminu-wengkarrngarna nungwenikba-wa. N-alilikenu...wa. Biya ni-yar•da arakba nakina nuw-ambilyu-murrumanja Jekaba-murriya Kawijina-manja. Biya nu-kuwabijanga mibina-langwa makangkidikarra akwa n-angkarra nen-engkarrnga nungwenikba-manja akwa nu-ngwadina neningamiyerra. Nu-ngwadungwadina nakinu...wa. Biya kembirra ni-yengminjada ni-jerrukwa arakba ebina angwada-da. ");
INSERT INTO aoi_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Eneja ni-yama Jekaba Jawijibu-wa, “Ningkena yirra-rringkama arakba nganyangwa-murra menba, akwa ningeningma arakba ningkeniba ngawa ningkena. Kembirra ningeniki-jungwangeni-yada ngayuwa arakba-da,” ni-yama. ");
INSERT INTO aoi_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Umba eneja ni-yengbina Jawijiba ayakwa ena-langwu-wa wurrarrkwurrkuwena iya nungwenikba-wa akwa ngawa wurrumurndakibinu-wa warnumamalya ena-langwu-wa nawurraki-yar•dangu-murruwa nungwenikba-manja. “Ningi-likajama ningena narumu-wa nubungkawa,” ni-yama. “Kembirra kinu-makinama ningena nungkwurruwa-langwa karnumamalya nganyangwa kirri-likenu-mulangwa karna Kenina-langwa ngayuwa-wa aduwaba. ");
INSERT INTO aoi_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Kembirra ki-yaminama ngayuwa enuwa-wa, ‘Warne-ka narrkuwarrka-murriya nganyangwa narruwurraku-wilyakama ababurna-langwa jiba iya bulukwa aburra-langwa Kenina-langwa yangkwurrangwa aduwaba, kajungwa karruwurrak-akukwurrajini-yada enena-manja angalya amurndakakina. Warnikakukwurrajungwe-ka jiba-murriya wurrakina warnungkwarba. Akwa ngarningka ababurna-langwa amurndakijika aburra-langwa narru-wilyakama yenjerra enenu-wa angalya aduwaba-da,’ ki-yaminama ngayuwa narumu-wa nubungkawa-da. ");
INSERT INTO aoi_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","“Umba yiken-ardijina-manja nakina nubungkawa nungkwurruwa-wa, akwa yikeni-yengkilabaja-manja nakina nungkwurra-langwa-langwa warka, ");
INSERT INTO aoi_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","yikinu-makina kembirra ebina-murrada ngawa ayakwa enuwa-wa kirrakina. Akwa yiki-yamina ngarningka, ‘Yirra-langwe-ka wurrumirumiranyungwa wurrarumuruma narr-akukwurrajuwamurra jiba iya bulukwa warningangkawura. Akwa yirramba-langwa yarna yarnumamalya yirr-akukwurrajinama ngawa jiba iya bulukwa yirrajukwaba. Yirri-yaminjamama akina yirriyukwayuwa-wiya yanda-langwa aduwaba,’ yiki-yaminama karna nakinu-wa naruma nubungkawa. Umba kin-engkirrikaja-manja eneja akina ayakwa nungkwurra-langwa, kembirra nara nakina a-waruma umba yikeni-lalikinama nakina enena-manja aringbirra angalya Kawijina kirr-ambilya-murrumanja karna aduwaba,” ni-yama Jawijiba, nenu-maka nakina ena-langwa-manja warnumamalya. Amurndakenena ayakwa ni-yengbinuma nakina Jawijiba mena-baba neningma na-warena-mulangwa WarningiYijiba warnumamalya ebina warka akwa na-warena-mulangwa ngarningka warnumamalya narr-akukwurrajina-murrumurra jiba iya bulukwa wurrakina-da. ");
INSERT INTO aoi_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Biya kembirra Jawijiba nenu-manga wurrumangbala wurrarrkwurrkuwena akwa na-likena arakba naruma-langwu-wa nubungkawa angalya. Nuw-alilikenu...wa. Biya ne-yar•da arakba naruma-langwa-manja nubungkawa angalya akwa ni-yama Jawijiba enuwa-wa, “Nganyangwa nungwarrka akwa narrkuwarrka-murriya nawurraki-likenuma wurrakina angaluba yirra-langwa-langwa angalya Kenina yangkwurrangwa. Akwa narruwurraku-warakama wurrakina aburra-langwa jiba-murriya akwa ngawa aburra-langwa amurndakijika-murriya. Wurrangaba-wiya kembirra, ne-yar•duma Kawijina-manja arakba wurrakina,” ni-yama Jawijiba. ");
INSERT INTO aoi_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","“Umba warnarna wurrukwala ningarra-wilyakama wurrambawura yangkwurrangwa ngayuwa-manja,” ni-yama. ");
INSERT INTO aoi_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Eneja kembirra ni-yama naruma nubungkawa aburruwa-wa, “Amiyambene-ka warka kirru-war•duwar•denama karna?” ni-yama. Aburraja ne-yama, “Yarne-ka yirr-akukwurrajinama jiba-murriya, wuburra arakburakba-kiya yirra-langwa wurrarumuruma wurrumirumiranyungwa ne-yaminjamamurra aburrajukwaba wurrakina. ");
INSERT INTO aoi_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Yarna kembirra yirri-likenuma yarnik-ambilyingi-yada enena-manja angalya, mena eyukwujiye-ka aninga yakwujina Kenina-manja akwa nara ebina amarda yirra-langwa-langwa jiba-murriya. Ngarra-marrakbakinama kembirra nungkuwa-wa kajungwa yiku-kwuni-yada nungkuwa ayakwa yarnik-ambilyingi-yada yarna angaba-manja angalya aringbirra-manja Kawijina,” ne-yama. ");
INSERT INTO aoi_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Ni-yama eneja nakina naruma nubungkawa Jawijibu-wa, “Wurrumurndakakina nungkwa-langwa narrkuwena-murriya akwa nungwena nawurraki-yar•duma arakba, ");
INSERT INTO aoi_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","kembirra amurndakenena angalya Yijiba aburra-langwa aduwaba. Ab-ambilya kembirra akina-manja angalya Kawijina, ebina eningaba-langwa-langwa angalya Yijiba. Umba wurrakina-manja wurrabarda warka warnungkwarba, kembirra kabumin-akwurrajinama akwala jiba-murriya wurrakina,” ni-yama nakina Jawijibu-wa. ");
INSERT INTO aoi_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Eneja kembirra nakina Jawijiba ni-lawurradina nungwenikba-wa nen-angkarna nakina akwa nenu-wilyaka enejukwaba narumu-wa nubungkawa. Eneja kembirra nakina Jekaba n-akwudangwukajungwunuma enuwa-wa akwudangwu-wa akwa ni-yama, “Eni-yamina Neningikarrawara eningaba nungkuwa-manja.” ");
INSERT INTO aoi_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Eneja ni-yama naruma nubungkawa Jekabu-wa, “Mambarrngarna mamarika iya yinungkwura ningkena ningk-ambilyuma?” ni-yama. ");
INSERT INTO aoi_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Eneja ni-yama Jekaba, “Ningene-ka ningu-marrawarnuma engku-wa iya engku-wa angalya 130 mamarika iya yinungkwura. Ningi-yaminjamame-ka ngawa yanda-langwa aduwaba. Umba muwurruwurrariya-wiya mamurndakakina mamarika iya yinungkwura ning-ambilyuma yambawura. Nare-ka wuburra nganyangwa numirarrka-murriya ki-yama k-ambilya ningakina. Nganyangwa numirarrka-murriya nuw-ambilyumurra mababurne-ka meninginingaba-wiya mamarika iya yinungkwura akwa engku-wa iya engku-wa angalya na-marrawarnuma wurrumurndakakina,” ni-yama nakina Jekaba nakinu-wa naruma nubungkawa-da. ");
INSERT INTO aoi_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Biya kembirra nara-wiya Jekaba keni-lalika nakina naruma nubungkawa ni-yama ngarningka enuwa-wa, “Eni-yamina Neningikarrawara eningaba nungkuwa-manja,” ni-yama. Biya ni-yengbinu-mulangwa nakina lukwuniyawa akina ayakwa, ni-likena arakba neni-lalika nakina naruma nubungkawa-da. ");
INSERT INTO aoi_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","12","Eneja kembirra nakina Jawijiba nenu-kwa angalya eningaba-langwa-langwa nungwenikba-wa iya wurrarrkwurrkuwenu-wa, ebina-langwiya ayakwa nenu-maka-mulangwiya adinuba-wiya naruma nubungkawa enuwa-manja. Akine-ka angalya eningaba akwudangwa nuw-ambilyumurra angalya aminuwurrakwulyumida alikira iya warnumamalya emikirra Ramijeja. Akwa nenu-kwama nakina ngarningka aninga nungwenikba-wa iya ena-langwu-wa wurrarrkwurrkuwena akwa wurrababurna-langwu-wa warnumamalya nungwenikba-langwu-wa, wurrarumuruma-langwa akwa angerriba arrawu-wa wurriyukwayuwa-wa. Nakina-bina Jawijiba nenu-mamurikajuwama wurrumurndakakina ena-langwa warnumamalya yakwujina Yijiba-manja, kajungwa warnik-ambarringi-yada arakba warningaba wurrakina awilyaba-manja-da. ");
INSERT INTO aoi_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Akini-yada ngawa nare-ka ebina aninga, mena muwurrariya-wiya ngawa mamurndakakina mamarika iya yinungkwura. Umba aburraja wurruminakina angalya warnumamalya wurribina nuw-ambilyu-murrumurra Yijiba-manja akwa ngawa Kenina-manja namurndaku-mureyanguma akwa namurndak-ayuwayanguma angwurra wurrakina-da. ");
INSERT INTO aoi_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Biya nawurraki-likenuma wurrakina engka-langwa iya engka-langwa angalya Jawijibu-wa akwa nenu-kwama wurrakina angwarnda enuwa-wa kajungwa neniku-kwi-yada nakina arrkala aninga. Kembirra nakina eneja Jawijiba nenu-kwama aninga ebina narr-akumarnuma WarningiYijiba warnumamalya adinakba eninganinga-langwa-manja alikira ebina-wiya nuw-ambilyu-wiya aruma aninga Yijiba-manja. Biya nu-wilyakama nakina ebina angwarnda nu-mangu-mulangwa aburra-langwa angerriba naruma-langwu-wa nubungkawa angalya. ");
INSERT INTO aoi_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Ne-yaminjamama wurrakina ngawu...wa. Bi...ya akine-ka angwarnda na-jerriduma arakba ababurna-manja angalya Yijiba akwa Kenina-manja. Aburraja kembirra wurrumurndakibina WarningiYijiba warnumamalya nawurraki-likenuma Jawijibu-wa akwa neni-yukwamajuwama aninga-wa. “Yirru-kwuname-ka aninga,” namurndaki-yamama. “Nara yarna ambambilyuma murumureya akwa a-jungwuma. Angwarnde-ka yirra-langwa na-jerriduma arakba akina, kembirra yirru-mamurikajina yirraja aduwaba,” ne-yama. ");
INSERT INTO aoi_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Eneja ni-yama nakina Jawijiba aburruwa-wa, “Wurrumurndaku-wilyakina kembirra yangkwurrangwa nungkwurra-langwa jarrangwa-murriya iya jiba-murriya. Nara ebina angwarnda nungkwurra-langwa. Kembirra aminakina-langwa yirru-kwuna amurndakakina kajungwa ka-kwuni-yada ngayuwa aninga nungkwurruwa-wa,” ni-yama nakina Jawijiba. ");
INSERT INTO aoi_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Kembirra narruwurraku-warakama aburra-langwa jarrangwa-murriya iya jiba-murriya enuwa-wa akwa kembirra nenu-kwama nakina arrkala aninga-da. Makini-yada ngawa mamarika nakina Jawijiba nenu-kukwama aninga. Aburraja kembirra nenu-kwama dumurndakibina jarrangwa iya jiba iya nenukwuda iya bulukwa akwa ngawa dangki aburra-langwa. Ne-yaminjamama ngawa wurrakina enuwa-wa-da. ");
INSERT INTO aoi_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Bi...ya mingki-yada ngarningka mamarika nawurraki-likenuma wurrakina WarningiYijiba warnumamalya Jawijibu-wa akwa ne-yengbinuma ayakwa enuwa-wa. “Yirra-langwe-ka angwarnda yirrumini-jerridume-ka yarna arakba,” ne-yama. “Akwa ngarningka yirra-langwe-ka bulukwa-murriya nungkwa-langwa kembirra amurndakakina arakba aduwaba. Nare-ka yarna abuwarrkama enena ayakwa umba amandangwa ngarra-makinama. Nara ebina yarna ngu-wilyakama awilyuwilyaba yarniku-kwi-yada nungkuwa-wa. Enena awilyaba yirra-langwa yarnumadangkwa akwa yirra-langwa angalya-da. ");
INSERT INTO aoi_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Nara a-lalikama umba yirru-mamurikajina yirraja, marrakba, nari-yada a-jungwuma yarna. Nara kajukwaba a-lalikama enena yirra-langwa angalya eyebirra. Beyindena yirruwa akwa ngawa yirra-langwa angalya, akwa kembirra yirru-kwuna aninga aduwaba. Kembirra yirraja yarna yirruwa naruma-langwa nubungkawa yarnumamalya yarnikuminuwar•duwar•da arakba akwa ngarningka amurndakenena angalya yirra-langwa ena-langwa amurndakenena kajukwaba arakba-da. Yirru-kwuna nungkwaja kembirra aninga aduwaba kajungwa nari-yada a-jungwuma umba yarniba yik-ambilyi-yada ngawa. Akwa ngarningka akwala amadidira yirru-kwuna kajungwa yiki-lungkuwabijini-yada amaninga amarda yirra-langwa-manja ajiringka, kajungwa nari-yada arakba ambilyuma eyebirra akina,” ne-yama wurrakina WarningiYijiba warnumamalya Jawijibu-wa-da. ");
INSERT INTO aoi_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Kembirra eneja nakina Jawijiba nenuminu-beyindanguma amurndakibina angalya nuw-ambilyu-murrumurra Yijiba-manja naruma-langwa nubungkawa. Umba mamurndakibina mamarika iya yinungkwura yuwurruwurrariye-ka yakina ngawa. Aburraja kembirra wurrumurndakibina WarningiYijiba warnumamalya wurruwilyuwilyaba-wiya na-makwunuma ebina angalya aburra-langwa aburra-langwu-wa naruma nubungkawa, yanda-langwa amurndakibina kembirra angalya ababurna-langwa ena-langwa arakba-da. ");
INSERT INTO aoi_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Eneja Jawijiba nakina nu-beyindanguma warnumamalya WarningiYijiba wurrababurna-langwa kajungwa warnikuminuwar•duwar•da naruma-langwa nubungkawa kuw-ambilyi-yada arakba wurrakina. ");
INSERT INTO aoi_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Akena nara angalya kinu-beyindanga nakina WurruMinida-langwa warnungkwarba yimbukwa. Aburraja wurribina WurruMinida warnungkwarba nara ka-makwuna ebina aburra-langwa angalya, mena nakina naruma nubungkawa nenu-kwama angwarnda warniku-beyinda-langwa wurrakina yimbukwa aninga umba nara wurrukwalu-wa kenu-kwa nakina. ");
INSERT INTO aoi_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Eneja kembirra ni-yama nakina Jawijiba WarningiYijibu-wa warnumamalya, “Kwuja!” ni-yama. “Ningenuminu-beyindanguma naruma-langwa nubungkawa nungkwurruwa karnumamalya akwa ngawa nungkwurra-langwa angalya. Wiya, amurndakenena kembirra nungkwurra-langwa amadidira kajungwa yiki-lungkuwabijini-yada ngarningka. ");
INSERT INTO aoi_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Arija-langwa kembirra ka-lungkuwarreyina-manja amurndakakina amaninga akwa yiku-mena-manja, kembirra nungkwurraja yikinu-kwuna akwala nubungkawu-wa kirrakina. Yikuma-mena-manja mamangbala beka kirrakina, kembirra muwilyaba yikinu-kwuna kirrakina enuwa-wa. Umba akwala yiku-minambilya akina nungkwurra-langwi-yada yik-alyubarini-yada nungkwurruwa iya nungkwurra-langwa warnumamalya. Akwa ngarningka yik-akumurna adinakba akwala kajungwa yiki-lungkuwabijini-yada ngarningka arija-langwa akina,” ni-yama nakina Jawijiba wurrumurndakakinu-wa warnumamalya-da. ");
INSERT INTO aoi_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Aburraja ne-yama enuwa-wa, “Yirr-enibikama nungkuwa yarna yarnumamalya, akwa ningki-yamama ngarningka eningaba yirruwa-manja. Kembirra yirraja yarna arakba naruma-langwa nubungkawa yarnikuminuwar•duwar•da yarnumamalya-da,” namurndaki-yama wurrakina-da. ");
INSERT INTO aoi_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Eneja kembirra nakina Jawijiba ni-yarrkakumarna ayakwa WarningiYijiba-langwa warnumamalya amurndakakina-langwa angalya aburra-langwa-langwa. Ni-yama nakina nenu-makama wurrababurna-manja warnumamalya nuw-ambilyu-murrumanja yakwujina Yijiba-manja, “Mababurna-langwa mamarika yikuwurra-murndukwuna-manja ebina amaninga yiki-lungkuwabijinamurra kirrakina, kembirra akwala yikinu-kwunama narumu-wa nubungkawa. Yikuma-wilyakina-manja mamangbala beka maninga-ma, kembirra yikinu-kwunama muwilyaba ena-langwi-yada. Akwa ngarningka yikuma-wilyakina-manja mememberrkwa beka maninga-ma, kembirra yikinu-kwunama mambilyuma ena-langwi-yada makina. Yiki-yaminjaminama ngawa kirrakina mababurna-langwa mamarika yikuwurra-murndukwuna-manja nungkwurra-langwa amaninga,” ni-yama Jawijiba nakina-da. Akwa enena ayakwa Jawijiba-langwa nuw-ambilyama ngawa aduwaba-da. Ababurna-langwa angalya Yijiba-manja naruma-langwa nubungkawa amurndakakina-da. Wulkwa WurruMinida warnungkwarba yimbukwa nara kenu-kwa aburra-langwa angalya narumu-wa nubungkawa-da. ");
INSERT INTO aoi_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Aburraja wurrumurndakibine-ka warnumamalya WarningiYijireyila kembirra nawurrak-ambilyuma yakwujina ngawa Kawijina-manja akina-manja angalya Yijiba. Ne-yaminjamamurra nuw-ambambilyumurra warningaba ngawa, yanda-langwa namin-ababurnadinume-ka aninga iya amurndakijika iya jiba-murriya akwa angwarnda wurrakina-da. Akwa ngarningka wurrababurna arakba wurriyukwayuwa narra-wilyakamurra wurrakina warnumamalya WarningiYijireyila-da. ");
INSERT INTO aoi_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Umba Jekaba n-ambilyuma nakina yakwujina 17 mamarika iya yinungkwura. Umba neniyuwangkwe-ka arakba nakina, mena n-ambilyumurra 147 mamarika iya yinungkwura. ");
INSERT INTO aoi_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Kembirra neniki-jungwangena arngkidarrba nakina akwa nen-ardijuwa nenikuwenikba-wa Jawijiba. Eneja Jawijiba ni-likena nakina nungwenikba-wa Jekabu-wa. Eneja ni-yama Jekaba enuwa-wa, “W-akuma nungkwa-langwa ayarrka malakena-kiya-manja nganyangwa makarra wilyarra, kajungwa ki-yarrkakumurni-yada ningkakina ayakwa akwa nari-yada a-yarrkuwarrukwajuma akina. Akwa yi-makina arakba amandangwa nari-yada a-rungkwabuma nganyangwa ningenumadangkwa yelakwa enena-manja angalya Yijiba. ");
INSERT INTO aoi_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Yirra-ngayindenama ningkena nungkuwa yiku-rungkwabini-yada ngayuwa ebina-manja ngawa angalya nawurraki-rungkwabajungwunu-murrumanja nungwarrka iya numirarrka-murriya aburrajukwaba. Nungkwaja kembirra yiku-wilyakinama ngayuwa yadada angerriba akinu-wa angalya Keninu-wa-da,” ni-yama nakina Jekaba Jawijibu-wa-da. Eneja ni-yama Jawijiba, “Yawa. K-engkirrikajama ningena ngayuwa nungkwa-langwu-wa ayakwa,” ni-yama. ");
INSERT INTO aoi_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Eneja ni-yama Jekaba, “Ki-yarrkakumurna ayakwa akwa nara a-yarrkuwarrukwajuma.” “Amandangwa,” eneja ni-yama Jawijiba, akwa n-akumarna ena-langwa ayarrka nungwenikba-langwa-manja makarra wilyarra akwa ni-yama, “Ningi-yarrkakumurnama enena ayakwa. Ki-jungwa-manja ningkakina, kembirra yiba-wilyakinama ningkena Keninu-wa akwa yiba-rungkwabinama yakwujina-da,” ni-yama nakina Jawijiba nungwenikba-wa-da. Kembirra n-engkirrika-manja eneja Jekaba akina ayakwa nenikuwenikba-langwa, kembirra neni-yangmarngkwajuwa arakba Neningikarrawaru-wa, nu-murrkwulinga-murrumanja ena-langwa-manja ngawa mamukumungkwulinga-manja nakina-da. ");
INSERT INTO aoi_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Bi...ya aburraja wurrukwala nenu-makama arakba Jawijiba-manja n-angbilyuwadu-mulangwa ena-langwa nungwenikba. Eneja kembirra nenilirraku-manga Jawijiba ena-langwa warnikuwabulena wunenimikirra-kiya Muneja iya Yibureyima, akwa nabuki-likena wurrubukalakina angerriba Jekaba-langwu-wa angalya kajungwa warniki-ngarri-yada enuwa-wa. ");
INSERT INTO aoi_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Biya nabuki-yar•da wurrubukalakina Jekaba-langwa-manja angalya, akwa kembirra aburraja wurrukwala nenu-makama arakba Jekaba-manja ni-likenu-mulangwa nenikuwenikba yenjerrikina kajungwa neniki-rringki-yada nakina. Eneja nakine-ka neniyuwangkwa nu-murndakayuwayanguma arakba. Akena neni-rringka-manja nakina nenikuwenikba Jawijiba ni-rrakarjiyinga nakina nu-murrkwulu-mulangwa ena-langwa-manja mamukumungkwulinga. ");
INSERT INTO aoi_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Ni-yama nakina Jekaba nenikuwenikba-wa, “Arakba-wiya Neningikarrawara nibina narrubuda nilyengma n-abilyerrikajungwunuma nakina ngayuwa-manja ning-ambilyu-wiya Kenina-manja. Nakine-ka Neningikarrawara ni-yengbinuma eningaba ayakwa ngayuwa-manja ebina-manja ngawa angalya Luja, ");
INSERT INTO aoi_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","akwa ni-yama, ‘Yiba-kwunama ningena wurrababurna wurriyukwayuwa nungkwa-langwa, kajungwa ka-wurrakwulyumidadini-yada nungkwa-langwa numirena-murriya warnikinikaduwa yanda-langwa kuw-ambilyame-ka wurrilyimberrkwulyumida warnumamalya wurrilyimberrkeyebijeba iya wurrilyimberrkeyebijeba wurrakina. Umba ka-kwunama enena angalya wurrumurndakakinu-wa warnikinikaduwa numirena-murriya aburra-langwi-yada akina eningangkawura,’ ni-yama nakina Neningikarrawara ngayuwa-wa-da,” ni-yama Jekaba Jawijibu-wa nakina. Akena akine-ka angalya Luja ngala-langwa emikirra Bedela aduwaba. ");
INSERT INTO aoi_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Biya ni-yama nakina ngarningka enuwa-wa, “Umba wunalakina nungkwa-langwa nenikuwena-kiya Yibureyima akwa Muneja nganyangwe-ka wunalakina. Neni-rukwularrinuma yelakwa enena-manja ngawa angalya Yijiba nara-wiya ki-yar•danga ngayuwa. Umba wunalakina-kiya wuburre-ka Rubina iya Jimiyina nganyangwa-kiya nenikuwarrka-kiya neni-yaminama wunalakina Yibureyima akwa Muneja. ");
INSERT INTO aoi_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Ka-wilyakina-manja ningkakina wurrukwala ngarningka nenikuwena-murriya, nara arakba nganyangwa wurrakina. Wulkwa Yibureyima-kiya nganyangwa wunalakina. Kembirra ki-jungwa-manja ngayuwa wunalakina nenikuwena-kiya nungkwa-langwa Yibureyima iya Muneja wuneningadinuba-wiya kenu-menama akwala amurndakijika nganyangwa. Wurrukwala nenikuwena-murriya ka-wilyakina-manja ningkakina arija-langwa nare-ka a-manguma wurrakina. Wulkwa karra-kwuna-manja arija-langwa wunalakina Yibureyima-kiya karru-menama wurrakina-da,” ni-yama nakina Jekaba Jawijibu-wa. ");
INSERT INTO aoi_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Biya ni-yama ngarningka neniyuwangkwa Jekaba Jawijibu-wa, “Ngayuwa ningi-yaminama enena, mena dirndena Rejila dadingilarrngekburna dadingiyarrka nganyangwa dakina. Kembirra yingi-jungwu-manja dakina arakba-wiya ningu-werrikawarriyadinume-ka nganja ningakina. Ngalaja yingi-jungwuma dakina Kenina-manja ebina-manja ngawa angalya akwudangwa Eburada akini-yada ngawa ningi-lawurradinu-manja ningakina lukwakwa Mejubudamiya-langwa. Umba ninginga-rungkwabama dakina ajiringka-manja mibina-manja ngawa mamurukwa akwudangwa numu-likenu-murrumanja Eburadu-wa makina-da,” ni-yama Jekaba nakina Jawijibu-wa nenikuwenikba-wa. Akena akine-ka angalya emikirra ngala-langwa Eburada adinuba-wiya umba emikirra Bediliyema akina aduwaba. ");
INSERT INTO aoi_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Biya neni-rringka-manja nakina Jekaba wunalakina-kiya-wa Yibureyima akwa Muneju-wa, ni-yama nakina Jawijibu-wa, “Wunumiyambena-kiya wunalakena wunenungkwarba-kiya?” ni-yama nakina. ");
INSERT INTO aoi_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Eneja ni-yama Jawijiba, “Nganyangwe-ka wunalakena nenikuwarrka-kiya, nginu-kwa-mulangwa Neningikarrawara yelakwa enena-manja angalya Yijiba,” ni-yama. Eneja ni-yama Jekaba, “Wurralirraku-wilyaka yangkwurrangwa ngayuwa-wa kajungwa ki-yengbi-yada ngayuwa ayakwa nganyangwa eningaba eningilyamarmba aburnuwa-wa,” ni-yama. ");
INSERT INTO aoi_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Ngalaja menba neniyuwangkwa-langwa muwurrariye-ka makina muwarrngkabiyiya. Nara nakina kin-andeya angwurra mena n-eniyuwangkidinu-mubaba arakba nakina. Kembirra eneja nakina Jawijiba nenilirraku-wilyaka wunalakina Yibureyima akwa Muneja neniyuwangkwu-wa akwudangwu-wa. Umba nakine-ka neniyuwangkwa nenilirrak-engkarrnga akwa nenilirraki-lawurangka wunalakina-manja-da. ");
INSERT INTO aoi_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Ni-yama nakina Jekaba Jawijibu-wa, “Ningi-lyangkiyama-bu ngayuwa nara-bu yiba-rringka nungkuwa. Akena eneja nakina Neningikarrawara ngini-larrkama ningeniki-rringka nungkwa-langwa wuniyukwujiya-kiya,” ni-yama. ");
INSERT INTO aoi_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Kembirra eneja Jawijiba nenilirraki-rndirrka wunalakina nungwenikba-langwa akwa n-abuluwendinga nungwenikba-manja akwa n-engmudirruwajungwa nenumukwurra ajiringka-manja nakina. ");
INSERT INTO aoi_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Biya kembirra ni-yama nakina Jawijiba ena-langwu-wa warnikuwabulena, “Yibureyima, jeyi likaja, nginakilarrina neniyuwangkwa-manja nekalyarra-langwa. Umba nungkwaja, Muneja, yadada likaja nekbudu-wa,” ni-yama. Aburnaja neni-likena neni-nginakilarrina yalina iya yalina neniyuwangkwa-manja. ");
INSERT INTO aoi_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Akena eneja neniyuwangkwa Jekaba ni-lawulawaja akwa ni-kilyangbaka ayarrka ena-langwa, akwa nekbuda-langwa n-akumarna Yibureyima-langwa-manja aringka, mame-ka nakina niyukwujiya. Umba nekalyarra-langwa n-akumarna nakina Muneja-manja, nibina numangaruma-manja. ");
INSERT INTO aoi_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Kembirra ni-yengbina arakba nakina neniyuwangkwa ena-langwa eningaba ayakwa eningilyamarmba nenikuwenikba-wa Jawijibu-wa akwa ni-yama, “Nganyangwa numirarrka Aburiyama iya nungwarrka Ajika nenumini-yarrkuwarakama wunalakina Neningikarrawara-langwa ayakwa. Eneja nibina-murrada Neningikarrawara ngin-akukwurrajuwama ngayuwa ningiyukwujiya-wiya yanda-langwa ning-eniyuwangkwudinuma arakba ngayuwa aduwaba. Kembirra eni-yamina arakba eningaba nibina-murrada Neningikarrawara wunalakena-manja wunenjarrngalyilya-kiya. ");
INSERT INTO aoi_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","Eneja Neningikarrawara-langwa nenikumamurikaja ngini-didirrakama ngayuwa awurrariya-langwa, kembirra eni-yamina nakina eningaba wunalakena-manja enejukwaba. Ngalaja nganyangwa ekirra ak-ambilya akina wunalakena-kiya-manja wunenjarrngalyilya-kiya, akwa ngarningka numirarrka-langwa ekirra iya nungwarrka-langwa ekirra ngalajukwaba. Kembirra aburnaja ken-akumajungwuni-yada wunalakena aburna-langwa wurriyukwayuwa wurrababurna akwa ngawa wurrumirumirarrngwa aburna-langwa wurrababurna aburrajukwaba,” ni-yama nakina Jekaba-da ena-langwu-wa nenikuwenikba Jawijibu-wa-da. ");
INSERT INTO aoi_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Umba eneja nakina Jawijiba nu-werrikawarriyade-ka nakina nungwenikba ni-kilyangbaka-mulangwa ena-langwa ayarrka ekbuda Yibureyima-langwa-manja aringka. Kembirra nenumini-rndirrka Jawijiba ayarrka nungwenikba-langwa kajungwa kinu-kuwarrukwajuwi-yada Yibureyima-langwa-langwa aringka angerriba Muneja-langwu-wa. ");
INSERT INTO aoi_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Akwa ni-yama nakina nungwenikba-wa, “Nara akina e-yamama. Naka-bina naruma numilyengma-da. Umba w-akuma nungkwa-langwa ekbuda ayarrka naka-manja,” ni-yama. ");
INSERT INTO aoi_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Eneja ni-lyangkilyuwaka nungwenikba. “Ningeningme-ka ningena,” ni-yama. “Muneja-langwa wurrumirumirena warnikinikaduwa wurrilyimberrkwulyumida wurrilyimberrkuwilyaba kuw-ambilyame-ka wurrakina aburrajukwaba. Umba nenikumarnjenikbe-ka nakina angwurre-ka kin-ambilyama naruma-da, akwa ena-langwa wurrumirumirena warnikinikaduwa ka-wurrakwulyumidadinama wurrakina yanda-langwa kuw-ambilyame-ka wurrilyimberrkwulyumida warnumamalya wurrilyimberrkeyebijeba iya wurrilyimberrkeyebijeba wurrakina-da,” ni-yama nakina. ");
INSERT INTO aoi_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Kembirra akwala ngarningka ayakwa eningaba eningilyamarmba ni-yengbinuma Jekaba wunalakina-kiya-wa Yibureyima-kiya. Ni-yama nakina, “Keni-yengbina-manja warningerribirra WarningiYijireyila warnumamalya eningaba ayakwa wurrukwala-manja warnumamalya aburra-langwa, kembirra karri-yengbijinama wurrakina nungkwurna-langwa ekirra. Akwa ke-yaminama wurrakina, ‘Eni-yamina Neningikarrawara eningaba nungkuwa-manja aduwaba, wuburra laka arakba-wiya ni-yamama nakina eningaba wunalakina-kiya-manja Yibureyima-manja akwa Muneja-manja,’ ke-yaminama wurrakina-da,” ni-yama nakina Jekaba. Umba ni-yengbinu-manja amurndakakina ayakwa neni-lyengmajuwama nakina Jekaba neningadinuba-wiya Yibureyima, umba Muneja nen-arijikama nakina-da. ");
INSERT INTO aoi_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Biya ni-yama nakina Jekaba nenikuwenikba-wa Jawijibu-wa, “Yi-rringkiname-ka ningena ki-jungwunama arngkidarrba ningena. Umba eneja Neningikarrawara kin-ambilyama nakina nungkwurruwa-manja akwa yikeni-lawurrakajinama kirrakina akinu-wa angalya nuw-ambilyu-murruwa arakba-wiya nungkwurra-langwa wurrumirumirenungwa. ");
INSERT INTO aoi_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Nganja yirra-kwunama ngayuwa Jekema angalya ebina angakarjiyinga nungkwa-langwi-yada. Nara a-kwama akina angalya eningaba nungkwa-langwu-wa narrkuwena-murriya umba yirra-kwunama akina nungkuwa-wa. Arakba-wiya ngayuwa ningarra-murrakajuwama awinyamba-ma akina angalya WarningAmara-langwa warnumamalya. Umba aduwaba nungkwa-langwa arakba akina angalya-da,” ni-yama Jekaba Jawijibu-wa nakina-da. ");
INSERT INTO aoi_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Biya kembirra nakina Jekaba nenuwurrak-ardijuwa ena-langwu-wa warninikuwena akwa ni-yama, “Kwa, wurruwurraki-likaja ngayuwa-wa akwa wurruwurra-murndukwa yelakwa ngayuwa-manja akwudangwa, kajungwa ki-yengbini-yada ayakwa nungkwurruwa-wa,” ni-yama nakina. “Ngayuwa kawurraku-makinama ayakwa ka-ngekburakajungwuna-mulangwa arija-langwa nungkwurra-langwi-yada iya nungkwurra-langwi-yada wurriyukwayuwa iya nungkwurra-langwi-yada wurrumirumirenungwa akwa aburra-langwi-yada wurriyukwayuwa aburrajukwaba akina,” ni-yama neniyuwangkwa Jekaba. ");
INSERT INTO aoi_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Nakina neniyuwangkwa Jekaba nu-wilyakamurra ambilyuma ekirra. Awilyaba ekirra Jekaba akina, umba awilyaba ngarningka nenu-kwama Neningikarrawara aruma ekirra Yijireyila akina. Biya ni-yama nakina warninikuwenu-wa, “Wurruwurra-murndukwuna kajungwa yik-engkirrikaji-yada enena ayakwa nganyangwa. W-engkirrikiya ningungwenungwu-wa Yijireyilu-wa,” ni-yama. Kembirra ni-yengbinuma arakba nakina aburruwa-wa wurruwilyuwilyaba-wiyu-wa amurndakenena ayakwa eningarija-langwa kini-jungwunu-wa nakina. ");
INSERT INTO aoi_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Ni-yama nakina adinuba-wiya Rubinu-wa, “Ningkena Rubina ningkumilyengma ningkenungkwulyuba ningkenikuwarrka. Ningki-rukwularru-manja ningkakina kembirra aburraja warningma arakba warnumamalya ningingbuda ningenungkwarba ningena ngayuwa-da. Umba nungkwaja ningkarrubuda angwurra wurrumurndakenena-manja narrkuwena-murriya ningk-ambilyamurra ningkenikuwarrka aduwaba. ");
INSERT INTO aoi_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Akena nungkuwa yimini-yamama awurrariya ningku-mungkwulu-mubaba nganyangwa-manja dadikuminuwar•duwar•da didarringka. Akwa nare-ka k-errukwulina ngayuwa-wa nungkwa-langwu-wa ningungwena. Nungkuwe-ka ningkena wuburra laka yaruma yelyukwa yibina nare-ka ngarna a-bungkawakama, mena nare-ka warningerribirra warnumamalya a-bungkawakama ningkakina ningkenumamalya nungkwajukwaba-da. Kembirra akina-langwa awurrariya ningki-yama-mulangwa ningkakina, nare-ka arakba ningkakina ambilyuma ningkaruma wurrumurndakenena-manja narrkuwena-murriya-da, umba ningkiyukwujiya k-ambilyama ningkeningangkawura ningkakina-da,” ni-yama Jekaba Rubinu-wa. ");
INSERT INTO aoi_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","Biya kembirra ni-yengbina Jekaba amurndakenena ayakwa wunalakina-kiya-wa warnikuwabulena-kiya Jimiyinu-wa iya Libayu-wa. Ni-yama nakina, “Kinalakena Jimiyina akwa Libaya duwilyaba-mulangwa dirndenungwa. Umba nungkwurnaja arakba kinu-wilyakinama kaliwanga engbudi-yada awinyamba. ");
INSERT INTO aoi_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Akena nara nganja ningena e-yakajuma nungkwurnuwa-manja yikini-lyelyimbukweyina-manja kinalakina amurama-langwiya. Nare-ka ningena ambarruma ayakwi-yada nungkwurnuwa-manja, mena kin-awinyambadinu-manja kinalakena kinadiyerra-manja kirra-wardanguma wurrukwala warnungkwarba, akwa ngarningka akwala bulukwa kini-rrengmurnirnakwama abadakalya-manja. ");
INSERT INTO aoi_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Kembirra awurruwurrariya ka-ngekburakajungwunama nungkwurna-langwa akina, mena kini-ngayindenama ngawa kinalakina awinyamba akwa kinu-werrikardadinama ngawa kinalakina-da. Kinubardijena-kiye-ka ngawa kinalakena kinenungkwarba-kiya-da. Ningene-ka kembirra k-errbalijinama nungkwurna-langwa warnumamalya angerriba iya angerriba WarningiYijireyila-manja warnumamalya wurruwurrakuwilyarra-da,” ni-yama Jekaba wunalakina-kiya-wa Jimiyinu-wa iya Libayu-wa. ");
INSERT INTO aoi_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","Biya kembirra ni-yengbina Jekaba amurndakenena ayakwa nenikuwenikba-wa Juda. “Nungkwaja Juda,” ni-yama, “aburraja nungkwa-langwa narrkuwena-murriya kabi-yangmarngkwajinama ningkakina. Ka-likajama kuw-abuluwendama nungkuwa-manja wurrakina, mena ningkingbuda-baba ningkakina-da. Nungkwaja ka-rndirrkinama wurrukwala-manja warnumamalya kabu-wirrikbina-murrumanja ningkakina. Ka-majinginama wurrakina ayarrka-murra yambiya-manja ningkakina-da. ");
INSERT INTO aoi_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Ningkakine-ka wuburra yiningerriberriba yiningbala ningki-yaminama aduwaba-da. Yakine-ka yiningbala kini-lawurradinama ena-langwu-wa medirra ka-wardena-mulangwa yukwala yinungungwangba. Kini-lawulawajinama ena-langwa alika yibina kin-errikerrikarrngina-mulangwa akwa kinu-mungkwulama yakina. Akwa akini-yada nare-ka ngarna a-mirajangajuma yakina, mena yabarda awinyamba yakina-da. ");
INSERT INTO aoi_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Nungkwaja nungkuwa Juda ku-bungkawadinama ambaka-murra ningkena. Aburrajukwaba numirena-murriya warnikinikaduwa ka-bungkawadinama. Ke-yaminjaminama yanda-langwa nubungkawa naruma-dangwa kini-yar•denama nakina enena-manja angalya. Umba aburraja wurruwurrakwulyumida warnumamalya engka-langwa iya engka-langwa angalya ka-likajama wurrakina enuwa-wa, karru-wilyakinama ababurna amurndakijika kajungwa kenu-kwuni-yada enuwa-wa. Akwa ngarningka kuw-abuluwendama enuwa-manja wurrakina mena warningma wurrakina naruma nakina-da. ");
INSERT INTO aoi_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Nungkwaja ki-yaminama ningkakina wuburra laka nuwilyaba nenumamalya numinababurna akwurena eninginingaba. Amurndakakina akwurena ena-langwa kuw-arumidinama. Umba eneja kining-ararikinama ena-langwa diyukwujiya dangki akinu-wa ememeka akwurena eningaba-dangwu-wa. Akwa kining-ajirrenama ena-langwa dumbala akwurena-langwa-murra amalyirra, mena ababurna-baba amalyirra akwurena-langwa akina-da. ");
INSERT INTO aoi_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Umba ngalaja ena-langwa menba kum-abiyidinama makina kini-bekina-mulangwa amalyirra akwurena-langwa. Akwa ngarningka ena-langwa akarrnga ka-kwulyarriyiname-ka akwulyadada kini-bekina-mulangwa nakina milka-da,” ni-yama Jekaba nenikuwenikba-wa Juda. ");
INSERT INTO aoi_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","Biya kembirra ni-yengbina Jekaba amurndakenena ayakwa nenikuwenikba-wa Jebulina. “Jebulina,” ni-yama, “nungkwaje-ka k-ambilyama akwudangwa makarda-manja ningkakina. Akine-ka angalya nungkwa-langwa ka-lawurradinama Jayidina-langwa angalya. Ngalaja mijiyanga kumu-likajama kum-awiyebenama ngala-langwu-wa abalmungwur•da-da,” ni-yama Jekaba nenikuwenikba-wa Jebulina. ");
INSERT INTO aoi_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","Biya kembirra ni-yengbina Jekaba amurndakenena ayakwa nenikuwenikba-wa Yijakara. Ni-yama, “Umba ningkakine-ka nungkwaja Yijakara ki-yaminama wuburra duwilyaba dangki yingu-warenama warka. Dakine-ka dangki yingu-kuwamurrkwulama wilyarra umba ngalaja beka mambilyuma yalina iya yalina yingamu-wilyarrakinama makina, mena nara-baba dakina a-ngayinduma a-wilyakama malakina beka ngala-langwa-manja mirirrba-da. ");
INSERT INTO aoi_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Akena kingu-mirajanginama akwa kinguma-wilyakinama malekbina beka-kiya ngala-langwa-manja mirirrba, mena eningaba-baba angalya akina-da. Umba dakine-ka wuburra dangki nungkwaja ki-yaminama ningkakina kaminu-war•denama warka wurrukwala-langwa ningkakina-da,” ni-yama Jekaba ena-langwu-wa nenikuwenikba Yijakara. ");
INSERT INTO aoi_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","Biya kembirra ni-yengbina Jekaba amurndakenena ayakwa nenikuwenikba-wa Dena. Ni-yama, “Umba nungkwaje-ka ningkakina Dena ki-lyangkuwerribikajungwunama nungkwa-langwa-langwa warnumamalya warningaba-murrikba akwa wurruwurrariya-murrikba wurrakina. Umba nungkwa-langwa warnumamalya aburrajukwaba ne-yaminama WarningiYijireyila warnumamalya. ");
INSERT INTO aoi_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Umba nungkwaja ki-rarrkajungwunama ningkakina adinakba mamurukwa-manja, wuburra laka yibina yingarna n-abuwarrkajungwunama amarda-manja akwa n-anginama amulurrngwa jarrangwa-langwa-manja alika, kajungwa warnumamalya ka-wurdena-manja karrawara jarrangwa-manja kembirra ke-ngkilarrini-yada mirirrba-ma ajiringka-wa wurrakina-da,” ni-yama Jekaba nenikuwenikba-wa Dena. ");
INSERT INTO aoi_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","Biya kembirra ni-yengbina Jekaba amurndakenena ayakwa Neningikarrawaru-wa. Ni-yama nakina, “Ningene-ka ning-embirrarinama nungkuwa-wa Yaweya, kajungwa yiku-ngwureni-yada ningkakina ngayuwa-manja,” ni-yama Jekaba. ");
INSERT INTO aoi_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","Biya kembirra ni-yengbina Jekaba amurndakenena ayakwa nenikuwenikba-wa Keda. Ni-yama, “Wurrukwale-ka wurrengkengmina warnumamalya kabu-wardenama nungkuwa, akena nungkwaja nungkuwa ku-minangkirreyinama wurrakina-da,” ni-yama Jekaba nenikuwenikba-wa Keda. ");
INSERT INTO aoi_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","Biya kembirra ni-yengbina Jekaba amurndakenena ayakwa nenikuwenikba-wa Ajera. Ni-yama, “Umba nungkwaja nungkuwa Ajera, ngalaja nungkwa-langwa angalya kuw-arrangbinama ababurna aninga eningaba. Eningabe-ka akina kin-alyubarina-mulangwa nubungkawa naruma-dangwa-da,” ni-yama Jekaba nenikuwenikba-wa Ajera. ");
INSERT INTO aoi_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","Biya kembirra ni-yengbina Jekaba amurndakenena ayakwa nenikuwenikba-wa Nabudali. Ni-yama, “Umba nungkwaja Nabudali ki-yaminama ningkakina wuburra laka duwilyaba bambi dibina ying-angkarrinama erribirra angerriba iya angerriba, akwa nang-arrangbinama dangariya diyukwayuwa deninginingaba-da,” ni-yama Jekaba nenikuwenikba-wa Nabudali. ");
INSERT INTO aoi_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","Biya kembirra ni-yengbina Jekaba amurndakenena ayakwa nenikuwenikba-wa Jawijiba. Ni-yama, “Umba nungkwaja Jawijiba ki-yaminama wuburra laka eningaba eka ebina nuw-arndurrkwarjiyama amukwa-manja akungwa. Na-mungkuwarruwalyadinama akwa nuw-arrangbinama ababurna amaninga. ");
INSERT INTO aoi_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Aburraja wurrawinyamba warnungkwarba bu-wirrikbama angwurra nungkuwa-manja. Akwa nuw-alilikenuma nungkuwa-wa awinyambu-wa narruma-wilyakama maminjirrada akwa bu-ngajingajama ningkakina-da. ");
INSERT INTO aoi_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Bu-larrmanguma wurrakina menungkwa-murra, akena ngalaja nungkwa-langwa ayarrka nare-ka ka-murndaburridanga akina. Kembirra nungkwaje-ka ningkingbuda angwurra ningkakina ningk-arjeyuma aburruwa-manja-da. Ningkingbude-ka ningk-arjeyuma mena nganyangwa Neningikarrawara nginu-ngwurangu-mubaba nungkuwa-manja. Eneja nakina Neningikarrawara nganyangwa ningbude-ka nilyengma, nibina ngini-ngbudirrkama ngayuwa, akwa ngin-akwurrajuwama ngayuwa-manja. ");
INSERT INTO aoi_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Amandangwa nakina-bina nganyangwa Neningikarrawara nginu-ngwungwurenama ningkakina. Nakina-bina nganyangwa Neningikarrawara narrubuda nilyengma nakina akwa ni-yaminama eningaba nungkuwa-manja. Nginu-kukwunama yelyukwa angubina-langwa akwa ngawa akungwa ajiringka-langwa arrawa-langwa nginu-kukwunama. Akwa nginu-kukwunama nakina ababurne-ka bulukwa iya wurriyukwayuwa. ");
INSERT INTO aoi_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Nakine-ka nginu-kukwunama ababurne-ka aninga eminiminingka ningkenik-alyubara-langwa akwa ngawa amawalyuwa eninginingaba ningkeniki-rringka-langwa akina. Akwa nginu-kukwunama ngarningka eninginingaba angakingakarjiyinga-langwa angalya. Umba nganja ngayuwa ningeni-yendabajame-ka Neningikarrawaru-wa kajungwa kini-yamini-yada nakina amurndakenena eninginingaba nungkuwa-manja ningkenikuwarrka. Ningkakina-bina eneja nu-wekbalyinuma nakina akwa nginu-miningkakama wurrumurndakeyina-langwa wurrukwala narrkuwena-murriya, ngin-eyebijebakama nakina-da,” ni-yama neniyuwangkwa Jekaba nenikuwenikba-wa Jawijiba. ");
INSERT INTO aoi_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Biya kembirra ni-yengbina Jekaba amurndakenena ayakwa neningarija-langwu-wa nenikuwenikba Benjiminu-wa. Ni-yama, “Umba nungkwaja ningkakina ki-yaminama wuburra yinungwenimbaluba yibina ni-jungwunama yakina murumureya. Yakine-ka yinungwenimbaluba nu-wardenama yukwala yinungungwangba akwa n-alyubarinama yakina. Umba nungkwaja ningki-likajama wurdarriya-wiya awinyambu-wa ningkakina akwa ningkarra-wardenama warnumamalya-manja akwa ningkarra-murrakajinama aburra-langwa amurndakijika. Biya kum-awiyeba-manja mamawura nungkuwa akwa nungkwa-langwa warnumamalya yiki-larrmburrenama amurndakakina,” ni-yama Jekaba neningarija-langwu-wa nenikuwenikba Benjiminu-wa nakina. ");
INSERT INTO aoi_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Wurrumurndakenena-bina wurrumemberrkwa wurrambilyuma warnumamalya WarningiYijireyila wurrilyimberrkingka-langwa iya wurrilyimberrkingka-langwa. Akwa amurndakenena ayakwa eningarija-langwa ni-yengbinuma nungwarringba Jekaba warninikuwenu-wa nakina. Umba eminiminingka ayakwa ni-yengbinuma nakina wurrumurndakakina-manja warnungkwarba wurruwilyuwilyaba-wiya-manja. ");
INSERT INTO aoi_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","30","Kembirra nakina Jekaba nenu-makama wurrumurndakakinu-wa warninikuwena warniki-yami-yada wurrakina arija-langwa. Akwa ni-yama, “Ki-jungwuname-ka ningena arngkidarrba arakba. Ki-likajama ningena nungwarrka-langwu-wa warnumamalya. Nungkwurraja kembirra yiki-rungkwabinama karna ningenumadangkwa nungwarrka-murriya-manja. Yik-akumurnama ngayuwa mibina-manja ngawa medirra Makbela-manja. Umba nuw-ambilyama Makbela Mamura-manja akwudangwa yakwujina Kenina-manja angalya akina. Karningme-ka makina medirra mibina num-ambilyama Ebirena-langwa-manja ajiringka. Nakine-ka Ebirena NeningiYida nenumamalya nakina. Umba eneja nakina Aburiyama nu-beyindanguma akina ajiringka ena-langwa akwa ngawa makina medirra ena-langwa, kajungwa ken-akumurni-yada makina-manja medirra ena-langwa warnumamalya warninikijungwa nakina. ");
INSERT INTO aoi_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Umba makina-manja ngawa medirra aburraja narralirrak-akumarnuma wunalakina Aburiyama iya dadingiyenikba Jera yakwujina. Bi...ya narralirrak-akumarnuma ngarningka Ajika iya dadingiyenikba Ribeka aburnajukwaba yakwujina. Nganjukwaba ninging-akumarnuma Liya makina-manja ngawa medirra. Yawe-ka. ");
INSERT INTO aoi_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Nungkwurraja kembirra ngayuwa yik-akumurnama kirrakina nganjukwaba yakwujina makina-manja ngawa medirra, nu-beyindangu-murrumanja adinuba-wiya Aburiyama nakina-da,” ni-yama nakina Jekaba warninikuwenu-wa. ");
INSERT INTO aoi_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Biya ni-jerrukwa-mulangwa nakina amurndakakina ayakwa ena-langwa eningarija-langwa warninikuwena-manja, nu-kwunumurrkwulijajungwa nakina akwa nu-werrikarrnga arakba-da. ");
INSERT INTO aoi_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Eneja nakina Jawijiba neni-rringka-manja nungwenikba ni-jungwuma, n-akumajungwume-ka nakina nungwenikba-wa akwa neni-lawurangkama akwa nu-ngwadinume-ka angwurra. ");
INSERT INTO aoi_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Kembirra arakba ni-yama nakina ena-langwu-wa warnikuminuwar•duwar•da, “Wurr-angkirna bungabungwa amalyirra akwa ngawa engburingka amangwarra akwa yik-akumurna nungwarrka-langwa-manja nenumadangkwa,” ni-yama. Aburraja narr-angkarna akwa narr-akumarna Jekaba-langwa-manja nenumadangkwa kajungwa nari-yada ngu-minjirrkirruwanjuma nakina, mena akini-yada wurrumurndakibina-baba WarningiYijiba warnumamalya ne-yaminjamama akina. ");
INSERT INTO aoi_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Ne-yaminjamama ngawa arngkababurna-langwa umba aburraja na-jijakawaranguma wurrakina WarningiYijiba warnumamalya. Bi...ya arngkabiyarbuwa-ma arngkumemberrkwa marringa numi-jerriduma makina akwa narri-jerrukwama arakba ebina bungabungwa wurrakina warnikuminuwar•duwar•da. Umba kembirra ngarningka na-jijakawaranguma wurrumurndakakina WarningiYijiba warnumamalya yuwilyaba yimawura. ");
INSERT INTO aoi_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Kembirra narri-jerrukwama arakba akina awerrikawarriya. Eneja kembirra nakina Jawijiba ni-yama naruma-langwu-wa nubungkawa wurrububungkawa wurriyukwayuwa, “Yikinu-makina enena ayakwa nganyangwa naruma-manja nubungkawa. Yiki-yamina karna, ");
INSERT INTO aoi_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","‘Nara-wiya kinu-werrikarrngina nganyangwa nungwarrka enena ayakwa ni-yengbinuma nakina ngayuwa-manja. Ni-yama nakina, Ki-jungwunama arngkidarrba ningena. Umba nungkwaja yiki-lyilyena angerriba Keninu-wa akwa yiku-rungkwabina ningenumadangkwa mibina-manja ngawa medirra nungwarrka-langwa-manja num-ambilya-murrumanja adinakba makina yakwujina. Yiminu-wilyakina ngawa enena ayakwa nganyangwa akwa nara e-yakuwabijuma, ni-yama nungwarrka ngayuwa-wa. Nungkwaja kembirra yi-larrkaja ngeni-lyilyena arakba makinu-wa medirra. Kembirra nganja ki-lawurradinama ngayuwa ngarningka yangkwurrangwa,’ yiki-yamina karna nubungkawa-manja, yikuminu-makina nganyangwa ayakwa,” ni-yama nakina Jawijiba nubungkawa-langwu-wa warnikuminuwar•duwar•da. ");
INSERT INTO aoi_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Aburraja narru-wilyakama Jawijiba-langwa ayakwa narumu-wa nubungkawa. Enamba-langwa kembirra nakina naruma nubungkawa ni-lawurrakaja ayakwa Jawijibu-wa akwa ni-yama, “Likaja nu-wilyakina nungkwa-langwa nungwena mibinu-wa medirra, nginu-maka-mulangwiya nungwena nungkuwa-wa,” ni-yama nakina naruma nubungkawa, ni-larrkama ayakwa Jawijibu-wa nakina. ");
INSERT INTO aoi_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Eneja kembirra arakba nakina Jawijiba ni-likenuma neni-lyilyanguma nenumadangkwa nungwenikba-langwa angerriba Keninu-wa mibinu-wa medirra. Aburraja naruma-langwa nubungkawa-langwa wurriyukwayuwa wurrububungkawa nawurraki-likenuma wurrababurna-langwa Keninu-wa akwa ngawa wurrababurna-langwa wurrarumuruma WarningiYijiba warnumamalya aburrajukwaba nawurraki-likenuma. ");
INSERT INTO aoi_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","Akwa Jawijiba-langwa wunambilyuma warnikuwabulena akwa aburna-langwa wurradidingiyarrngwa akwa ngawa aburna-langwa wurriyukwayuwa nawurraki-likenuma wurrakina. Akwa ngawa wurrarrkwurrkuwena Jawijiba-langwa nawurraki-likenuma akwa aburra-langwa warnumamalya aburrajukwaba. Wurribina wurruwarrngkiyukwayuwa nawurraki-likenuma wurrakina umba wurriyukwayuwa-murrumurra wulkwa nuw-ambilyumurra angalya-manja yakwujina Kawijina-manja wurrakina. Akwa ngarningka ngalaja jiba iya nenukwuda akwa bulukwa nuw-ambilyumurra angalya-manja Kawijina-manja akina. ");
INSERT INTO aoi_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Umba wurrukwala warnungkwarba na-njawudiyinuma wurrakina jarrangwa-manja umba aburraja wurrukwala na-wurdanguma makangkidikarra-manja mibina yingum-arrkirrkarnu-murrumanja jarrangwa. Wurruwurrakwulyumide-ka warnumamalya namurndaki-likenumurra wurrakina Jawijiba-manja angerriba Keninu-wa-da. ");
INSERT INTO aoi_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Nawurraki-likenumurra wurrumurndakakina ngawu...wa. Engku-we-ka nawurraki-likenuma yanda-langwa narr-akburrangarna angalya emikirra Adada. Ngalaja alyengmilyengma-langwa nuw-ambilyumurra akina angalya umba akwaburrangarna-langwa nuw-ambilyumurra akina akungwa adalyuma emikirra Jardina. Umba aburraja wurruminakina angalya warnumamalya na-war•danguma warka yakwujina eninganinga-manja amadidira. Kembirra yakwujina ngawa aburraja na-ngwanjuma Jawijiba-murriya wurrakina akwa na-ngwadeyinuma aruma angwada. Na-jijakawaranguma warningamiyerre-ka. Nuw-ambukambarrinuma angwada-manja na-ngwadungwadeyinuma ngawa wurrakina yakwujina mamangbala mambilyuma marringa. ");
INSERT INTO aoi_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Umba aburraja wurruminakina angalya WarningiKenina warnumamalya narramurndaki-rringkama Jawijiba-murriya-wa na-ngwadungwadeyinu-murruwa yakwujina Adada-manja angalya wurrakina. Biya namurndaki-yama, “Wa! Wurrumurndakangabe-ka WarningiYijiba warnumamalya nuw-angmakayenama ngawa angwada-manja wurrakina-na!” namurndaki-yama. Kembirra narri-yengbijuwamurra akina angalya Ebula Mijirayima emikirra akina, mena akina ekirra ne-yaminama “WarningiYijiba warnumamalya na-ngwadungwadeyinuma wurrakina.” ");
INSERT INTO aoi_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Aburraja kembirra Jawijiba-murriya narruwurraki-lalika akina angalya akwa nawurrak-alilikena angwurra ngawa. Biya narri-yakuwarrukwa ebina adalyuma akungwa emikirra Jardina akwa nawurrak-alilikena Kenina-manja yanda-langwa namurndaki-yar•da arakba ebina-manja angalya Makbela wurrakina-da. Biya yakwujina ngawa Makbela-manja wurrakina warninikuwena Jekaba-langwa ne-yamama ababurna-langwa ebina-langwiya nenu-maka-murrilangwiya nungwarringba adinuba-wiya neniba-wiya nakina. ");
INSERT INTO aoi_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Nen-akumarna ena-langwa nenumadangkwa yakwujina ngawa Makbela-manja mibina-manja medirra nuw-ambilyu-murrumanja Mamura-manja akwudangwa. Adinuba-wiya makina medirra Ebirena-langwa, umba nakina Ebirena NeningiYida nenumamalya nakina. Kembirra arakba-wiya eneja Aburiyama nu-beyindanguma nakina Ebirena-langwa angalya akwa mibina medirra akina-manja ngawa angalya. Nu-beyindanguma makina kajungwa nenik-akumi-yada yakwujina warnumadangkwa ena-langwa warnumamalya wurrakina. ");
INSERT INTO aoi_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Eneja kembirra nakina Jawijiba nen-akumarnu-mulangwa nungwenikba yakwujina ni-lawurradina nakina arakba Yijibu-wa. Enuwa iya wurrarrkwurrkuwena akwa ngawa wurrumurndakibina nawurraki-likenu-murrumurra enuwa-manja namurndaki-lawurradina arakba Yijibu-wa wurrakina-da. ");
INSERT INTO aoi_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Biya kembirra ni-jungwu-mulangwa nungwarringba Jekaba, wurrumurndakakina wurrarrkwurrkuwena Jawijiba-langwa na-lyelyimbukweyinumurra Jawijiba-langwa-langwa arakba. Ne-yama wurrakina, “Jawijibe-ka nakina dukwa ngarrenu-wirrikbinama ngawa-da. Akwa ni-lyangkuwerribikajungwunama nakina akenumini-lawurrakajini-yada awurrariya ngakwurramba-langwa dukwa-da, mena ngarri-yamama awurrariya enuwa-manja adinuba-wiya ngarrakina-da. Kembirra aki-yamarrkinama ngarna?” ne-yama wurrakina. ");
INSERT INTO aoi_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Kembirra narri-larrka wurrakina ayakwa Jawijibu-wa. Ne-yama, “Nara-wiya kinu-werrikarrngina ngakwurra-langwa nungwarrka, ");
INSERT INTO aoi_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","yirrenu-makama nakina yarniki-yengkilabi-yada nungkuwa-wa kajungwa yikumini-yakuwabijini-yada ebina awurrariya yirri-yama-mulangwa nungkuwa-manja yirrakina. Yirraja yarna yarnikuminuwar•duwar•da nungwarrka-langwa-langwa Neningikarrawara. Nungkwaja kembirra marrakba, yirrumini-yakuwabijina akina aduwaba,” ne-yama wurrakina, narri-larrka ayakwa Jawijibu-wa. Umba eneja n-engkirrika-manja akina ayakwa Jawijiba kembirra nu-ngwadina nakina angwada-da. ");
INSERT INTO aoi_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Aburraja kembirra wurrumurndakakina wurrarrkwurrkuwena na-likenumurra aburrabakiya-ba Jawijibu-wa akwa nuw-abuluwenduma enuwa-manja. Biya ne-yama wurrakina, “Yarna-bina nungkwa-langwa yarnikuminuwar•duwar•da-da,” ne-yama wurrakina. ");
INSERT INTO aoi_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Eneja nakina Jawijiba ni-yama aburruwa-wa, “Nara akbar•duma. Nare-ka ningena e-yamama wuburra Neningikarrawara ni-yaminama nakina. ");
INSERT INTO aoi_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Arakba-wiya nungkwurraja kirrakina kirri-lyangkuwerribikajungwunuma awurrariya nganyangwa. Akena eneja Neningikarrawara nakina ni-kuwarrukwajuwama akina awurrariya eningabu-wa, kajungwa nakina Neningikarrawara ken-enibikini-yada wurrababurna warnumamalya. Kwuja, warniba arakba wurrakina aduwaba amurndakibina-langwa ne-yama-mulangwa arakba-wiya. ");
INSERT INTO aoi_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Kembirra nara akbar•duma, mena ngayuwa k-akwurrajinama nungkwurruwa iya nungkwurra-langwa wurriyukwayuwa,” ni-yama nakina Jawijiba ena-langwu-wa wurrarrkwurrkuwena. Kembirra akina-murra ayarrkuwarruwalya ayakwa neni-ngbudirrkama nakina Jawijiba ena-langwa wurrarrkwurrkuwena. Aburraja kembirra yiningaba yukwudukwuda nuw-ambilyuma arakba wurrakina-da. ");
INSERT INTO aoi_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Bi...ya eneja Jawijiba n-ambilyumurra Yijiba-manja nakina neningangkawura, enuwa iya ena-langwa warnumamalya wurrababurna-langwa aburrajukwaba. N-ambambilyumurra yakwujina ngawa nakina yanda-langwa n-eniyuwangkwudinuma arakba. Umba 110 mamarika iya yinungkwura n-ambilyumurra arakba nakina. ");
INSERT INTO aoi_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Akwa neniba-wiya ngawa nakina neni-rringkama wurriyukwayuwa nenikuwenikba-langwa Yibureyima-langwa. Aburrajukwaba neni-rringkama nakina ngarningka Yibureyima-langwa wurrumirumirena. Akwa ngarningka neni-rringkama nakina wurriyukwayuwa numirenikba-langwa Makira-langwa. Umba Makira-langwa nungwenikba Muneja nakina, nibina naruma-dangwa nenikuwenikba Jawijiba-langwa. ");
INSERT INTO aoi_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Biya kembirra kini-jungwunu-murruwa nakina, ni-yengbina ayakwa wurrarrkwurrkuwenu-wa. Ni-yama, “Ki-jungwunama arakbe-ka ningena, umba eneja Neningikarrawara yiken-akwurrajinama nakina nungkwurruwa-manja. Akwa yikenu-wilyakinama kirrakina enena-langwa angalya angerriba ebinu-wa angalya nenu-maka-murruwa adinuba-wiya Aburiyama-manja. Nenumini-yarrkakumarnuma amurndakakina ayakwa akina-langwa angalya Aburiyama-manja iya Ajika-manja akwa ngawa Jekaba-manja,” ni-yama nakina Jawijiba. ");
INSERT INTO aoi_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Biya kembirra ni-yama ngarningka ena-langwu-wa wurrarrkwurrkuwena, “Ngarra-ngayindenama karna yiki-yarrkakumurnama enena ayakwa aduwaba akwa nara a-yarrkuwarrukwajuma. Yikenu-wilyakina-manja nakina Neningikarrawara akinu-wa angalya, nungkwurraja kembirra yiku-wilyakina kirrakina nganyangwa ningenumadangkwa nungkwurruwa-manja,” ni-yama nakina. Aburraja kembirra neni-yarrkakumarna arakba akina ayakwa-da. ");
INSERT INTO aoi_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Eneja Jawijiba kembirra nakina ni-jungwa arakba yakwujina ngawa Yijiba-manja. Mababurne-ka mamarika iya yinungkwura 110 n-ambilyumurra nakina akwa ni-jungwa arakba. Aburraja kembirra ena-langwa warnumamalya narr-akumarnuma bungabungwa amalyirra akwa ngawa engburingka amangwarra ena-langwa-manja nenumadangkwa. Biya kembirra nen-akumarnuma arakba nenumadangkwa bada-manja wurrakina-da. Ena ngawa-da. ");
INSERT INTO aoi_vpl VALUES ("JH1_1","033_1_1","JON","1","1","1","Nakine-ka Jawuna nenikuwenikba Amideya-langwa nakina. Eneja Yaweya ni-yengbinuma ayakwa enuwa-wa ");
INSERT INTO aoi_vpl VALUES ("JH1_2","033_1_2","JON","1","2","2","akwa ni-yama, “Jeyi! Likaja arakba engembu-wa Niniba-wa. Arume-ka akina angalya akwa aminuwurrakwulyumida alikira iya warnumamalya. Ki-likaja nungkuwa yikumini-yengbina nganyangwa ayakwa wurrumurndakakinu-wa warnumamalya wurruminakina angalya yakwujina Niniba-manja. Akwa ki-yama, ‘Yaweya n-awinyambadume-ka nakina nungkwurruwa-wa mena neningme-ka nakina karniniyerriya karnumamalya kirrakina-da,’ ki-yamina ka-makina nungkuwa wurrumurndakakina-manja warnumamalya,” ni-yama nakina Yaweya Jawuna-wa. ");
INSERT INTO aoi_vpl VALUES ("JH1_3","033_1_3","JON","1","3","3","Eneja Jawuna nara kin-engkirrikena nakina akinu-wa ayakwa Yaweya ni-yengbinu-murruwa enuwa-wa. Nara kembirra kini-likena angerriba alyengmu-wa Niniba-wa, umba ni-lyangkarrngajungwa nakina mingku-wa mamurukwa, ni-ngayindangu-mubaba neniki-lyumadi-yada Yaweya-langwa. Biya ni-dirrirnda nakina angerriba mijiyelyu-wa memikirra Jawuba makina. N-alilikenu...wa. Yakwujina mijiyelya-manja ni-yar•da. N-andeya nakina akena numa-rringka muwilyaba mijiyanga yakwujina num-ambilyuwar•dumurra. Mamuki-liki-yada makina engku-wa akwaburrangarnu-wa engembu-wa Beyinu-wa. Biya kembirra ni-likena arakba nakina Jawuna akwa neni-yendabena numinakinu-wa mijiyanga nubungkawa neniki-liki-yada nakina makina-manja ngawa mijiyanga Beyinu-wa, akwa nenu-kwa angwarnda yakwujina. Ni-lyumadinume-ka nakina Jawuna Yaweya-langwa. Kembirra Jawuna akwa ngawa wurrumurndakakina wurrukwala warningumijiyanga warnungkwarba nawurra-jawudiyina arakba mijiyangu-wa. Biya namurndaki-likena arakba wurrakina-da. ");
INSERT INTO aoi_vpl VALUES ("JH1_4","033_1_4","JON","1","4","5","Umba eneja Jawuna ni-dirrirnda arakba akwa n-awiyeba memedirru-wa mijiyanga akwa nu-mungkwulinga marringa arakba nakina-da. Num-angkidikarrina ngalaja makina mijiyangu...wa. Maburrungkuwilyarra. Akena eneja nakina Yaweya neningma nakina Jawuna ni-rijawudiyinuma makina-manja ngawa mijiyanga, akwa kembirra ni-larrka engbude-ka arrirra makinu-wa makarda. Akine-ka wiyerrirda na-wardanga arakba makina mijiyanga maburrungkuwilyarra. Ngalaja madidirrungwarna arakba makarda numu-warumajungwuna makina. Adinuba ka-burrijuwame-ka makina mijiyanga-da. Aburraja wurrumurndakibina warnungkwarba wurruminakina mijiyanga namurndak-akbar•de-ka wurrakina, akwa nuw-ardanga wurruwilyuwilyaba-wiya aburra-langwu-wa amalawudawarra, kajungwa karraku-mamurikajini-yada akwa karrak-enibikini-yada wurrakina. Akena eyirrbiyirrba ngawa ngalaja arrirra nuw-angkarrinuma nuw-arrubudidinuma iya miyirrbiyirrba ngawa makarda numu-warumajungwunuma maruma. Kembirra aburraja warnungkwarba narrumurndaku-manga ababurna adidirrungwarna bada iya aninga-murriya akwa nuw-errikbeyina amurndakakina angerriba makardu-wa narrum-ekilyarrbakama mibina mijiyanga-da. ");
INSERT INTO aoi_vpl VALUES ("JH1_6","033_1_6","JON","1","6","6","Eneja kembirra numinibina nubungkawa mijiyanga ni-likena arakba nakina, n-awiyebena arrawu-wa, biya nen-akburranga nakina Jawuna nu-mungkumungkwuluma yakwujina marringa. Biya ni-yama, “Mirajanga!” ni-yama. “Ningki-yaminjamarrkinama ningkena yelakwa ningku-mungkumungkwulama? Mirajanga,” ni-yama. “Nungkwajukwaba ku-buriyaminama nungkwa-langwu-wa amalawudawarra. Dukwa kuw-errukwuliyama akina ngakwurruwa? Dukwa nara a-jungwajuma akina umba akak-enibikinama ngakwurruwa?” ni-yama nakina nubungkawa numinakina mijiyanga Jawuna-wa. Biya yadikina neni-jadinga wunalakina errekbu-wa angerriba wurrukwalu-wa warnungkwarba. ");
INSERT INTO aoi_vpl VALUES ("JH1_7","033_1_7","JON","1","7","7","Aburraja namurndaki-yama, “Ngarru-malyangkeyina akumalyangka kajungwa ngarningmi-yada ngarna nakina nenungkwarba nibina ni-ngekburakama awurrariya yelakwa,” ne-yama. “Dukwa numiyambena nenungkwarba ni-yamama yelakwa awurrariya? Nakina-langwa-bina ena wiyerrirda ngarraku-wardenama ena-da,” ne-yama. Biya kembirra na-malyangkeyina arakba akina akumalyangka-da. Biya narr-akburranga Jawuna-langwa ekirra wurrakina-da. ");
INSERT INTO aoi_vpl VALUES ("JH1_8","033_1_8","JON","1","8","8","Biya ne-yama wurrakina Jawuna-wa, “Yirru-makina kembirra! Ningkena-bina ningki-yamama awurrariya-na?” ne-yama. “Ningki-yaminjamarrkinama ningkena yelakwa memema-manja mijiyanga? Umba amiyambena angalya nungkwa-langwa? Angamba-langwa angalya ningki-likenuma ningkena?” ne-yama wurrakina Jawuna-wa. ");
INSERT INTO aoi_vpl VALUES ("JH1_9","033_1_9","JON","1","9","9","“Ngayuwe-ka ningena NingiYiburuwa ningenumamalya,” ni-yama eneja. “Ningeni-yangmarngkwajinama ngayuwa Yaweya Neningikarrawara, nibina n-ambilyamurra ena-langwa-manja angalya abalkaya. Meme-ka makarda numa-ngekburakama nakina akwa ngawa ababurna-langwa angalya ariba-manja ngalajukwaba ni-ngekburakama nakina. ");
INSERT INTO aoi_vpl VALUES ("JH1_10","033_1_10","JON","1","10","10","Akena nganja ngayuwa ningi-lyumadumurra Yaweya-langwa. Kembirra aminakina-langwa ena ngarrak-akburrangama wiyerrirda,” ni-yama nakina Jawuna. Aburraja nuw-engkirrika-manja akina ayakwa Jawuna ni-yengbinuma nakina, namurndak-akbar•da angwurra wurrumurndakakina warnungkwarba wurruminakina mijiyanga akina-langwa ayakwa. Akwa ne-yama, “Akine-ka awurrariya ningki-yamama ningkakina,” ne-yama. ");
INSERT INTO aoi_vpl VALUES ("JH1_11","033_1_11","JON","1","11","11","Ngalaje-ka arrirra iya makarda angwurra numu-ngakbudidina mamakwulyumida miyirrbiyirrba ngawa. Kembirra aburraja wurrumurndakakina warnungkwarba ne-yama Jawuna-wa, “Yiki-yamarrkinama yarna nungkuwa-manja kajungwa kuw-erriminji-yada enena wiyerrirda?” ne-yama. ");
INSERT INTO aoi_vpl VALUES ("JH1_12","033_1_12","JON","1","12","12","“Yirru-kuwakuwurriya angerriba makardu-wa,” ni-yama eneja Jawuna, “kajungwa enena arrirra akwa memema makarda kamurndak-erriminjini-yada,” ni-yama nakina. “Ningeningme-ka ningena ngayuwa-baba ningi-yarrkuwurrangu-mubaba Neningikarrawara-langwa ayakwa akwa kembirra enena ngarraku-wardenama wiyerrirda,” ni-yama Jawuna. ");
INSERT INTO aoi_vpl VALUES ("JH1_13","033_1_13","JON","1","13","13","Akena aburraja wurrumurndakakina warningumijiyanga warnungkwarba nara kenumin-engkirrikena akinu-wa ayakwa ni-yengbinu-murruwa Jawuna. Wurriyirrbiyirrba ngawa namurndaku-mideyina angwurra angerriba ariba-wa wurrakina, akena na-lyangmuride-ka. Nara karr-akburrangarna angalya. Angwurra ngawa ngalaja arrirra nuw-angkarrina nuw-arumidina akwa makarda makina numu-warumajungwuna mamakwulyumida ngawa-da. ");
INSERT INTO aoi_vpl VALUES ("JH1_14","033_1_14","JON","1","14","14","Kembirra nuw-ardanga arakba Yaweyu-wa wurrumurndakakina warnungkwarba wurruminakina mijiyanga. “Yaweya!” ne-yama. “Yikinu-wardena-manja naka nenungkwarba nare-ka ningkena a-jungwajuma yirruwa,” ne-yama wurrakina Yaweyu-wa. “Yarningme-ka yarna nungkuwa-bina ena ningki-larrkamurra wiyerrirda yangkwurrangwa-da,” ne-yama wurrakina-da. ");
INSERT INTO aoi_vpl VALUES ("JH1_15","033_1_15","JON","1","15","15","Kembirra neni-rndirrka Jawuna neni-ngkajika akwa nenu-kuwakuwurra wurrakina angerriba makardu-wa. Ngalaja akina-wiya ngawa nuw-ar•darra akina wiyerrirda. Nara arakba kuw-angkarrina. Num-erriminja ngalajukwaba makarda, numi-lyurrkwuda makina-da. Nara ngarningka arakba kumu-warumajungwuna-da. Milyurrkwa arakba kembirra makina makarda-da. ");
INSERT INTO aoi_vpl VALUES ("JH1_16","033_1_16","JON","1","16","16","Kembirra wurrumurndakakina warnungkwarba warningumijiyanga narruma-rringka-manja makina makarda numi-lyurrkwuduma, namurndak-akbar•da angwurra wurrakina Yaweya-langwa. Akwa kembirra narru-manga awilyaba jiba akwa nenuminu-wardanga Yaweya-langwi-yada akina. Biya ne-yama enuwa-wa, “Yarningma yarna nungkuwa Yaweya ningkakina ningkingbuda angwurra,” ne-yama. “Kembirra yiki-yar•diya-manja ngarningka yarna angalya-manja kaminu-wardenama ngarningka awilyaba jiba akwa ke-yangmarngkwajinama nungkuwa-wa yarningangkawura, mena yarningma yarna arakba nungkuwa ningkingbuda angwurra ningkakina-da,” ne-yama wurrakina-da. ");
INSERT INTO aoi_vpl VALUES ("JH1_17","033_1_17","JON","1","17","17","Umba ngalaja akina akwalya amakwulyumida nuw-ambilyuma arrawa makina-manja ngawa makarda. Eneja nakina ni-yengbina Yaweya akinu-wa amakwulyumida akwalya akwa ni-yama, “Jeyi! Likaja angerriba ni-rukwungir•diya nangaba nenungkwarba,” ni-yama nakina akinu-wa akwalya. Kembirra ngalaja akwalya nuw-angkarra akwa nenaki-rukwungir•da angerriba arrawu-wa mulkwu-wa nakina Jawuna. Kembirra yakwujina ngawa akwalya-langwa-manja mulkwa eneja Jawuna n-ambilyuma arakba mabiyakarbiya mamawura akwa marringa nakina-da. ");
INSERT INTO aoi_vpl VALUES ("JH2_1","033_2_1","JON","2","1","1","Biya Jawuna nu-buriyamina nakina Yaweyu-wa ena-langwu-wa Nubungkawa akuwakarrawa-langwa akwalya. Biya ni-yama, ");
INSERT INTO aoi_vpl VALUES ("JH2_2","033_2_2","JON","2","2","2","“Ningu-werrikawarriyadinuma ngayuwa mena ku-wurrilangu-bu ningi-lyangkiyama, akwa kembirra ning-ardanguma ngayuwa nungkuwa-wa kajungwa ningkeniku-mamurikaji-yada ngayuwa ningkakina. Nungkwaja yimin-engkirrikama nganyangwa ayakwa. Ning-ambilyu-manja ngayuwa makarda-manja mijirrkarrawa warninikijungwa-langwa-manja angalya, ning-ardanguma ngayuwa nungkuwa-wa akwa yimin-engkirrikama ayakwa nganyangwa. ");
INSERT INTO aoi_vpl VALUES ("JH2_3","033_2_3","JON","2","3","3","Yu-wurrume-ka mijirrkarrawu-wa ngawa meningarrawu-wa makarda. Ngumu-wurumbijuwama ngalaja makarda akwa karrikarrawara numu-warumajungwunuma mamakwulyumide-ka. ");
INSERT INTO aoi_vpl VALUES ("JH2_4","033_2_4","JON","2","4","4","Ningku-minangkirrajuma-bu arngkawura ningkakina ningi-lyangkiyama, akwa nara-bu arakba a-rringkama ngayuwa nungkwa-langwa akwurdukwurda angalya Jirujalema-manja. ");
INSERT INTO aoi_vpl VALUES ("JH2_5","033_2_5","JON","2","5","5","Makarde-ka ngumu-wurumbijuwama ningenumamalya ngumi-yikarrngajuwama, nara ki-ngengkuwangina. Umba ngalaja mamungwulya namurndak-ararikama nganyangwa-manja aringka. ");
INSERT INTO aoi_vpl VALUES ("JH2_6","033_2_6","JON","2","6","6","Ningi-likenume-ka ngumu-wilyakama makarda mijirrkarrawu-wa. Ngumu-wilyuwilyakama ngawu...wa. Ningakina ningi-likenuma ngawa ningi-dirrirnduma angerriba mijirrkarrawu-wa makarda. Ningi-yaminjamama ning-alilikenuma bi...ya yanda-langwa angakuba arrawa yakwujina ning-ambarringama. Akine-ka angalya warninikijungwa-langwa. Akena nara a-lawurraduma akina-langwa angalya yirribina yiki-jungwuna-murrada. Akena nungkwaja Yaweya nganyangwa Ningkubungkawa yi-lawurrakajuwama ningeniba makina-langwa makarda mijirrkarrawa-langwa. ");
INSERT INTO aoi_vpl VALUES ("JH2_7","033_2_7","JON","2","7","7","Nganja arakba ningu-werribikajungwunuma ningeniki-jungwangeni-yada akena ning-ardanguma nungkuwa-wa ningakina. Umba nungkwaja yimin-engkirrikama akina ayakwa nganyangwa nungkwa-langwa-langwa akwurdukwurda angalya Jirujalema-langwa. ");
INSERT INTO aoi_vpl VALUES ("JH2_8","033_2_8","JON","2","8","8","Aburraja wurribina nuw-engkingkirrikajama alarrngkilarrngkawarriya-wa amurndakijika alawudawarra-murruwa nara wurrakina e-yangmarngkwajuma nungkuwa-wa. ");
INSERT INTO aoi_vpl VALUES ("JH2_9","033_2_9","JON","2","9","9","Umba nganja ningena ngayuwa ku-mebinama emeba nungkuwa-wa akwa yiba-yangmarngkwajinama. Ningi-yamama ngayuwa yibaminu-wardenama jiba nungkwa-langwi-yada, kembirra ku-wardenama akina amandangwa ngayuwa, kajungwa ningkeningmi-yada nungkuwa yibamini-yarrkuwarakinama nungkwa-langwa ayakwa ningeningangkawura. Nungkwaja Yaweya nungkuwa yimbukwa ningkakina yik-enibikinama yarna yarnumamalya,” ni-yama nakina Jawuna Yaweyu-wa ena-langwu-wa Nubungkawa. ");
INSERT INTO aoi_vpl VALUES ("JH2_10","033_2_10","JON","2","10","10","Eneja kembirra arakba Yaweya ni-yengbina ayakwa nakina akwalyu-wa. “Jeyi, likaja!” ni-yama. “Nu-wilyakina nakina Jawuna marndakalyu-wa akwa yakwujina kin-errekbijina,” ni-yama nakina Yaweya akwalyu-wa nu-maka. Ngalaja akwalya kembirra yadikina na-likena arakba. Nuw-alilikenu...wa. Yakwujina marndakalya-manja. Akwa nenak-errekbijuwa arakba nakina Jawuna marndakalya-manja. Eneja kembirra nakina Jawuna nu-warumajungwa akwa ni-likena, ni-riberrkina arakba ariba-wa nakina-da. ");
INSERT INTO aoi_vpl VALUES ("JH3_1","033_3_1","JON","3","1","1","Ngarningka arngkuwilyaba ni-yengbina eneja nakina Yaweya nenu-maka Jawuna-manja. ");
INSERT INTO aoi_vpl VALUES ("JH3_2","033_3_2","JON","3","2","2","“Jeyi! Likaja Niniba-wa ebinu-wa aruma angalya aminuwurrakwulyumida-murruwa alikira iya warnumamalya,” ni-yama. “Akwa ka-makina ebina ayakwa yirra-makama adinuba-wiya wurrumurndakakinu-wa warnumamalya wurruminakinu-wa angalya,” ni-yama nakina. ");
INSERT INTO aoi_vpl VALUES ("JH3_3","033_3_3","JON","3","3","3","Eneja kembirra Jawuna nenumini-yarrkuwaraka Yaweya-langwa ayakwa ni-yengbinumurra nakina enuwa-wa akwa ni-likena arakba nakina Niniba-wa-da. N-alilikenu...wa. Kembirra ni-yar•da arakba nakina Jawuna Niniba-manja. Akine-ka Niniba amakwulyumide-ka angalya akina. Wurruwurrakwulyumide-ka warnumamalya iya alikira. Warnumamalya na-likenu-manja yenjerrikina akinu-wa angalya wurrakina, akwa narri-rijakba-manja akina angalya, kembirra na-likenume-ka mamurukwa-langwiya mabiyakarbiya-manja mamawura wurrakina. ");
INSERT INTO aoi_vpl VALUES ("JH3_4","033_3_4","JON","3","4","4","Eneja Jawuna nakina arakba ni-likena mamurukwa-langwiya akina-manja angalya-da. N-alilikenu...wa. Num-awiyeba mamawura. Biya kembirra arakba ni-yengbina ayakwa nakina, kajungwa warnik-engkirriki-yada wurrababurna warnumamalya wurruminakina angalya. N-ardangume-ka nakina angwurra, ni-yangkarjiyajungwunuma. “Kwurruwa-yi! W-engkirrikiya enenu-wa ayakwa ningi-yengbina-murruwa ngayuwa,” ni-yama nakina Jawuna nenu-maka wurrumurndakakina warnumamalya. “Kirrababurna-langwa karnumamalya w-engkirraja. Arngkabiyarbuwa-ma arngkumemberrkwa mamawura eneja Neningikarrawara kini-dirrirndama, kini-likajama enenu-wa angalya. Yikenu-wardenama nungkwurruwa akwa kinu-burrijinama alikira nungkwurra-langwa amurndakenena. W-engkirraja enenu-wa ayakwa kembirra ningi-yengbina-murruwa ngayuwa aduwaba,” ni-yama nakina Jawuna nenu-maka wurrumurndakakina-manja warnumamalya WarningiNiniba. ");
INSERT INTO aoi_vpl VALUES ("JH3_5","033_3_5","JON","3","5","5","Aburraja wurrumurndakakina warnumamalya wurruminakina angalya Niniba nawurrak-engkirrikenume-ka akina Neningikarrawara-langwa ayakwa ni-yengbinuma Jawuna. Kembirra warningma arakba wurrakina Jawuna ni-larrkbularrkbakama, alyangmandukwuna akina ayakwa amandangwa ni-yengbinuma. Kembirra namurndaki-lyangkuwerribikajungwunuma wurrakina nari-yada alyubaruma aninga wurrababurna-langwa warnumamalya warningakwujina. Kembirra wurrababurna-langwa warnumamalya narringamurndak-aburawakama arakba dibina dumbala aburra-langwa. Umba narringa-manguma duwurruwurrariya dumbala dibina narringa-ngekburakama nenukwuda-langwa-murra amangwurrajija akwa nuw-awiyebeyinuma arakba dumurndakakina. Akina-manja angalya ne-yaminjamama wurrakina, kajungwa neningmi-yada Neningikarrawara narri-larrngkuwurranguma alarrngkilarrngkawarriya umba nenumini-yarrkuwarakama Neningikarrawara-langwa ayakwa wurrakina arakba. Kembirra wurrababurna-langwa wurrarumuruma akwa wurriyukwayuwa warnumamalya aburrajukwaba namurndak-awiyebeyinuma dumurndakakina dumbala duwurruwurrariya. ");
INSERT INTO aoi_vpl VALUES ("JH3_6","033_3_6","JON","3","6","6","Enejukwaba nakina nubungkawa nibina naruma-dangwa numinakina angalya n-engkirrika ebina ayakwa Neningikarrawara-langwa. Biya nu-warumajungwa ena-langwa-langwa akangmakwulalinga. Nang-enjungwurranga dibina deningaba dumbala n-awiyebenuma, umba n-awiyebena duwurrariya-langwa dumbala nakina. Biya ni-jadinga errekbu-wa akwa n-ambarringa ajiringka-manja amarnina-manja. ");
INSERT INTO aoi_vpl VALUES ("JH3_7","033_3_7","JON","3","7","7","Ni-yarrkilarrka nakina nubungkawa ayakwa wurrababurnu-wa warnumamalya wurruminakinu-wa angalya Niniba. Ni-yama, “Enena ayakwa ningaruma-langwa ningubungkawa ninguminenena-langwa angalya akwa wurrububungkawa nganyangwa-langwa. Nara kirruwilyuwilyaba karnumamalya alyubaruma aduwaba aninga akwa a-bekuma akungwa kirrababurna-langwa karnumamalya enena-manja angalya. Ngalajukwaba bulukwa iya jiba nara alyubaruma aninga akwa a-bekuma akungwa. ");
INSERT INTO aoi_vpl VALUES ("JH3_8","033_3_8","JON","3","8","8","Kirrangkwulyumida-langwa karnumamalya yik-awiyebenama duwurruwurrariya dumbala, umba ngalajukwaba bulukwa. Akwa kirrababurna-langwa karnumamalya yiku-buriyaminama Neningikarrawaru-wa akwa yiki-larrngkuwurrenama alarrngkilarrngkawarriya amurndakibina kirri-yama-mulangwa. ");
INSERT INTO aoi_vpl VALUES ("JH3_9","033_3_9","JON","3","9","9","Eneja Neningikarrawara kinuma-kuwarrukwajinama dukwa mangma ena-langwa nari-yada awinyambaduma nakina ngakwurruwa-wa, akwa kembirra nari-yada a-jungwuma ngakwurruwa dukwa-da,” ni-yama nakina nubungkawa numinakina angalya, ni-yarrkilarrkama ayakwa ena-langwu-wa warnumamalya-da. ");
INSERT INTO aoi_vpl VALUES ("JH3_10","033_3_10","JON","3","10","10","Eneja Neningikarrawara n-andeya nakina angaluba karrawara-langwa akena neni-rringka wurrumurndakakina warnumamalya narri-larrngkuwurrangu-mulangwa ebina arakba awurruwurrariya umba nenumini-yarrkuwaraka-mulangwa ena-langwa ayakwa. Kembirra numa-kuwarrukwajuma mangma ena-langwa akwa nara kenu-wardanga wurrumurndakakina warnumamalya wurruminakina angalya Niniba, ni-yama-murrada neniku-warda wurrakina nakina-da. ");
INSERT INTO aoi_vpl VALUES ("JH4_1","033_4_1","JON","4","1","1","Eneja Jawuna nu-werrikawarriyade-ka arakba nakina, akwa n-awinyambada mena nara-baba Yaweya kenu-wardanga wurrumurndakibina warnumamalya WarningiNiniba ni-yama-murrada nakina neniku-warda. ");
INSERT INTO aoi_vpl VALUES ("JH4_2","033_4_2","JON","4","2","2","Biya nu-buriyamina akwa ni-yama nakina Jawuna Yaweyu-wa, “Ningeningma ngayuwa angakuba ning-ambilyu-wiya ningibina angalya-manja ambaka, yi-maka-wiya ayakwa adinuba-wiya, ningeningme-ka ki-yamina-mulangwa ningkakina. Karri-larrngkuwurrena-manja wurrumurndakibina warnumamalya alarrngkilarrngkawarriya ebina ne-yamama, kembirra ningeningme-ka kamini-yakuwabijinama nungkuwa. Akina-langwa-bina ningi-ngayindanguma ningi-lyumadinuma Beyinu-wa,” ni-yama nakina Jawuna. “Ningeningme-ka ngayuwa nungkuwa ningkuminababurna akwulyelyingma iya akwerrukwula. Akwa ningkumarngkuwurrumalya ningkumarngkirra ningkakina ningkeningangkawura. Akwa ningkeniki-kuwarrukwaji-yada mangma nungkwa-langwa nari-yada a-banijuminduma warnumamalya. Ningkeniki-yaminjama nungkuwa akina. ");
INSERT INTO aoi_vpl VALUES ("JH4_3","033_4_3","JON","4","3","3","Nganja ningena arakba kembirra ningi-ngayindenama nari-yada ningeniba ambilyuma umba ki-jungwuni-yada. Kembirra yi-larrkaja ngi-jungwuna,” ni-yama Jawuna Yaweyu-wa. ");
INSERT INTO aoi_vpl VALUES ("JH4_4","033_4_4","JON","4","4","4","Eneja ni-yama Yaweya Jawuna-wa, “Mena-burra ningkakina ningku-werrikawinyambadinama? Nara-maka ningkakina k-awinyambadina-da,” ni-yama Yaweya Jawuna-wa. ");
INSERT INTO aoi_vpl VALUES ("JH4_5","033_4_5","JON","4","5","5","Eneja Jawuna ni-jadinga arakba akina-langwa adirrungwarna angalya akwa ni-likena alyengmu-wa. N-ambarringa. Biya yakwujina arakba ni-ngekburaka eyukwujiya amiyerriya awarruwalya nenik-angmakwulalingi-yada. Biya n-embimbirrarinuma nakina Jawuna kinu-wardanga-murrikba Yaweya akina angalya. ");
INSERT INTO aoi_vpl VALUES ("JH4_6","033_4_6","JON","4","6","6","Umba eneja Yaweya Neningikarrawara ni-lungkuwabijuwa amarda alyarrngwalyilya nenik-angmakwulalingi-yada nakina Jawuna awarruwalya-manja. Eneja ni-lyelyingme-ka nakina Jawuna. Kembirra akina-manja awarruwalya nirungekburna n-ambilyuma arakba nakina. N-ambambilyu...wa. Biya num-awiyebena mamawura. Kembirra alyarrngwalyilya nu-mungkwulinga nakina marringa. ");
INSERT INTO aoi_vpl VALUES ("JH4_7","033_4_7","JON","4","7","7","Biya memerrkingka-manja ne-kbadinga arakba akina. Kembirra angaluba eneja nakina Neningikarrawara ni-larrka yinikarrbiyama ebinu-wa awarruwalya. Ngalaja n-alyubarina yakina arakba ebina amarda nenumini-lungkuwabijuwa-murrada Neningikarrawara awarruwalyi-yada Jawuna-langwi-yada-da. Ngalaja kembirra akina amarda na-lingbijungwa arakba-da. ");
INSERT INTO aoi_vpl VALUES ("JH4_8","033_4_8","JON","4","8","8","Biya num-ambijanga arakba mamawura, biya numu-wurduwurdanga karrawaru-wa makina. Umba eneja Neningikarrawara nakina ni-larrka arrirra ardidarra alyengma-langwa. Bi...ya mamawura makina nenamu-daka-mulangwa aringka-manja eneja nu-mingekilyuwake-ka arakba nakina Jawuna. Ni-yama kembirra nakina, “Ningene-ka arakba kembirra ningi-ngayindenama nari-yada ningeniba ambilyuma umba ki-jungwuni-yada,” ni-yama. ");
INSERT INTO aoi_vpl VALUES ("JH4_9","033_4_9","JON","4","9","9","Eneja arakba ni-yama nakina Neningikarrawara enuwa-wa, “Mena-burra ningkakina ebina-langwa amarda ningk-awinyambadinama? Nara-maka ningkakina akina-langwa amarda k-awinyambadina-da!” ni-yama nakina Neningikarrawara Jawuna-wa-da. Eneja ni-yama Jawuna, “Yawu, amandangwa ningena k-awinyambadinama akina-langwa amarda-da. Ningene-ka amandangwa ning-awinyambadinama arakba-da. Karukwe-ka ki-jungwunuma!” ni-yama nakina Jawuna Neningikarrawaru-wa-da. ");
INSERT INTO aoi_vpl VALUES ("JH4_10","033_4_10","JON","4","10","10","Eneja ni-yama nakina Yaweya nenu-maka nakinu-wa Jawuna, “Arngkawura-me-ka na-lungkuwarrinuma akina amarda umba mingka-manja marringa na-jungwunuma. Nara nungkuwa ki-lungkuwabijuwa akina akena yanda ningk-errukwulinama akinu-wa amarda-na! ");
INSERT INTO aoi_vpl VALUES ("JH4_11","033_4_11","JON","4","11","11","Nganjukwaba ningena ngayuwa ning-errukwulinama angwurre-ka wurrumurndakibinu-wa warnumamalya WarningiNiniba. Akina-manja ngawa angalya wurruwurrakwulyumide-ka warnumamalya wurrakina nawurrak-ambilyama. Aburrajukwaba wurruwurrakwulyumida wurrakina wurriyukwayuwa. Wurrakine-ka wurriyukwayuwa wurrikikamarra awurruwurrariya. Ngalajukwaba ababurna bulukwa-murriya akina-manja angalya nuw-ambilyamurra. Aminakina-langwa kembirra wurrumurndakakina warnumamalya nara ka-wardanga ngayuwa-da,” ni-yama Yaweya Jawuna-manja-da. Ena-bu ngawa-da. ");
INSERT INTO aoi_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Ngayuwe-ka ningena Luka ningenimikirra. Ning-arrikarrenama ngayuwa enena-manja jurra aduwaba kajungwa ki-larrkaji-yada ena nungkuwa-wa Diyabulaja. Ningkeningme-ka ningkakina wurrababurna warnumamalya narr-arrikarrangu-mulangwa arakba ayakwa akwala-manja jurra. Narr-arrikarranguma wurrakina ni-yama-mulangwa Jesus n-ambilyu-wiya yirruwa-manja nakina enena-manja angalya. ");
INSERT INTO aoi_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Akena nara keni-rringka wurrakina Jesus aburra-langwa-murra menba. Umba aburraja wurrababurna warnumamalya neni-rringkama Jesus n-aburradadangu-mulangwa nakina ena-langwa warka yanda-langwa ni-jerrukwama ebina warka nenu-kwamurra Neningikarrawara. Neni-rringkama wurrakina biya narr-eningmikama wurrumurndakibina warnumamalya kajungwa warnik-arrikarri-yada jurra-manja amurndakibina-langwiya ayakwa nuw-engkirrikenu-mulangwiya wurrakina. Akwa wurrumurndakibina-murrada narri-rringka-murrada warnumamalya yirrabu-makama ababurna-langwa yirruwa-manja yirrajukwaba-da. ");
INSERT INTO aoi_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Kwuja, Bungkawa, nganja ning-akakirumakajungwunuma arakba ningena amurndakibina ni-yama-mulangwa Jesus n-aburradadangu-mulangwa ebina warka ena-langwa yanda-langwa ni-lawurradinuma nakina Nungwenikba-wa. Angwurra ning-akakirumakajungwunuma ngayuwa nari-yada e-yakuwabijuma. Kembirra ningi-lyangkuwerribikajungwunuma arakba ngayuwa, ningenik-arrikarri-yada nganjukwaba amurndakenena akwala ayakwa, kajungwa ki-larrkaji-yada ngayuwa nganyangwa ayakwa nungkuwa-wa. Yirra-ngayindename-ka ngayuwa yiba-makinama nungkuwa-manja ababurna-langwa eningadinuba-wiya-langwa yanda-langwa angerriba eningarija-langwu-wa, ");
INSERT INTO aoi_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","kajungwa nari-yada a-kwiyerrbuma nungkuwa, umba warenja-bawiya ku-miringkini-yada amurndakibina ne-yama-mulangwa ningkakina. Akwa ngarningka yiba-makinama ngayuwa kajungwa k-eningmidini-yada ningkakina ebina-murrada ayakwa wurrukwala warnumamalya b-akakirumakama arakba wurrakina nungkuwa-manja alyangmandukwuna-wiya akina-bina ayakwa-da. ");
INSERT INTO aoi_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Arakba-wiya n-ambilyu-wiya nubungkawa Yerida Judiya-manja nakina, nuw-ambilyumurra wurrababurne-ka warnungkwarba WurruMinida. Ne-yengbijajungwunuma wurrakina warnimikirra warningarakburakba-kiya-langwa warnungkwarba WurruMinida. Umba wurrukwala ne-yengbijajungwunuma WarningAbija warnumamalya wurrakina. Enejukwaba nuwilyaba nenumamalya nenimikirra Jekaraya ni-yengbijajungwunuma nakina Abija-langwiya ekirra. Ngalaja dadingiyenikba ena-langwa Lijibida dakina, umba ngala-langwa nungwadikba enejukwaba NuMinida nenungkwarba nakina. ");
INSERT INTO aoi_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Wuneningabe-ka wunalakina-kiya Jekaraya akwa Lijibida wunenumamalya-kiya, akwa nenumini-yarrkuwarakama ababurna-langwa ayakwa Nubungkawa-langwa Neningikarrawara-langwa. Kembirra eneja Neningikarraware-ka nakina nenilirraki-rringkama wuneningaba-kiya ngawa. Neni-yaminjamamurra wunalakina, nenumini-yarrkiyarrkuwarakama ayakwa Neningikarrawara-langwa ngawu...wa. ");
INSERT INTO aoi_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Biya nen-eniyuwangkwudinuma arakba wunalakina. Biya narra-ngayindanguma warijira akena nara ngawa-da. Wuneningarijira-ma nen-ambilyuma, mena duburubura-baba Lijibida dakina-da. ");
INSERT INTO aoi_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","9","Biya kembirra arngkawura nakina Jekaraya nu-war•danguma warka Neningikarrawara-langwa-manja angalya Jirujalema-manja. Aburraja wurrababurna-langwa WurruMinida warnungkwarba na-war•danguma wurrakina warka yakwujina, akena na-warruwarrukweyinuma wurrakina. Adinuba-wiya wurrukwala na-war•danguma warka yakwujina, kembirra aburramba-langwa wurrukwala-langwa. Biya kembirra arakba WarningAbija warnungkwarba na-war•danguma warka aburramba-langwa yakwujina Neningikarrawara-langwa-manja alikira wurrakina. Eminiminingke-ka warka na-war•dangumurra. Umba mababurna-langwa mamawura nuwilyaba NuMinida nenungkwarba ni-dakamurra nakina amukwarnjirrema wuburra, kajungwa ngala-langwa angwarra kuw-angkarrkarjeyi-yada. Eningabe-ka ne-ngbajama akina. Ni-dakama akina mena arakburakba-kiya-wiya Neningikarrawara nenu-makamurra wurrakina WurruMinida warnungkwarba warniki-yaminjami-yada akina ena-langwi-yada. Umba na-wekbalyinu-manja wurrakina wurribina warnungkwarba akina-langwa warka, adinuba-wiya narr-arrikarranguma wurrababurna-langwa warnimikirra jurra-manja. Erribirra narr-arrikarranguma. Kembirra na-warruwarrukweyinuma narri-dakama akina amukwarnjirrema ebina-langwiya jurra. Kembirra arakba Jekaraya ni-dakama akina enamba-langwa nakina ebina-manja alikira WurruMinida warnungkwarba wulkwa nuw-awiyebeyinu-murrumanja wurrakina, umba nara-murrumanja wurrukwala warnumamalya. ");
INSERT INTO aoi_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Ni-daka-manja Jekaraya akina, nakwukawura n-ambilyuma nakina alikira-manja arrawa. Umba aburraja warnumamalya wurribina na-likenu-murrumurra Neningikarrawara-langwu-wa angalya errekba-manja-wiya nuw-arjeyuma wurrakina akwa na-buriyaminuma Neningikarrawaru-wa yakwujina. ");
INSERT INTO aoi_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Akena n-ambilyu-manja nakina nakwukawura arrawa-manja, eneja nuwilyaba nenikumamurikaja Nubungkawa Neningikarrawara-langwa ni-jadinga n-abilyerrikajungwunuma enuwa-manja nakina. Eneja Jekaraya neni-rringkama nakina n-arjeyuma ebina-manja bada emikirra alda ni-daka-murrumanja nakina ebina amukwarnjirrema. Ekbuda-langwa-langwa alda n-arjeyuma nakina nenikumamurikaja Neningikarrawara-langwa. ");
INSERT INTO aoi_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Eneja n-arndirndade-ka Jekaraya akwa n-akbar•da angwurra nakina-da. ");
INSERT INTO aoi_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Eneja kembirra nenikumamurikaja Neningikarrawara-langwa ni-yama enuwa-wa, “Nara akbar•duma, Jekaraya,” ni-yama. “Ningku-buriyaminuma ningkakina Neningikarrawaru-wa akwa eneja n-engkirrikenuma nakina ayakwa nungkwa-langwa. Kembirra ambaka-murra ngalaja dadingiyena kangumin-arrangbinama nangariya nungkwa-langwa. Nungkwaja kembirra kini-yengbijinama niyukwujiya ningkakina nenimikirra Janjana. ");
INSERT INTO aoi_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Biya ki-yekirrerridinama angwurra ningkakina nginu-kwa-mulangwa Neningikarrawara nenikuwena-da. Aburraja wurrababurna warnumamalya ke-yekirrerridinama aburrajukwaba kini-rukwularrina-mulangwa nakina niyukwujiya nungkwa-langwa-da,” ni-yama nakina nenikumamurikaja Neningikarrawara-langwa Jekarayu-wa. ");
INSERT INTO aoi_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Biya ni-yama ngarningka, “Nenikuwene-ka naruma nenungkwarba numikbiyiya kin-ambilyama nakina. Amandangwa eneja Nubungkawa Neningikarrawara kini-yaminama, ‘Narume-ka nakina.’ Umba kin-arumidina-manja nakina, nara e-bekuma amalyirra akwurena-langwa. Nara e-bekuma ngalajukwaba akubibeka engbuda, ebina karraku-bungwurrukwunama warnumamalya. Umba ngalaja Amawurrina akwurdukwurda Neningikarrawara-langwa kenaki-lyangburrukwajinama nakina akwa kenaku-war•dikinama nakina-manja. Kenaku-war•dikinama kinu-rukwularrina-manja nakina, akwa enuwa-manja ngawa kuw-ambilyama eningangkawura akina-da. ");
INSERT INTO aoi_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","“Nakina-bina nenungkwarba kenu-wilyuwilyakajinama warnumamalya-manja Neningikarrawara-langwa-langwa. Akini-yada aburraja wurrababurne-ka WarningiYijireyila warnumamalya karri-larrngkuwurrenama awurruwurrariya akwa ke-yaminama eningaba kuw-engkirrikaja-mulangwa ena-langwa ayakwa. Kenumini-yarrkuwarakiname-ka ayakwa Nubungkawa-langwa aburra-langwa-langwa Neningikarrawara, wuburra laka arakburakba-kiya-wiya ne-yaminjamama wurrumirumirarrngwa aburra-langwa wurrakina-da,” ni-yama nakina nenikumamurikaja Neningikarrawara-langwa. ");
INSERT INTO aoi_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","“Yawe-ka,” ni-yama ngarningka Jekarayu-wa nakina. “Nenikuwena kini-lyengmenama nakina, umba eneja Nubungkawa kin-arijidinama arija-langwa. Narrubude-ka amandangwa kin-ambilyama nenikuwena. Ngalaja Amawurrina Neningikarrawara-langwa, ebina-murrada nenaki-ngbudirrka-murrada Eliya arakburakba-kiya-wiya, kenaki-ngbudirrkinama enejukwaba nenikuwena. Aburraja wurrungungwarrngwa ka-lyelyingminama karr-akwurrajinama ngarningka wurriyukwayuwa aburra-langwa kuw-engkirrikaja-mulangwa wurrakina ena-langwa ayakwa. Aburrajukwaba warnumamalya wurribina nara amini-yarrkuwarakama Neningikarrawara-langwa ayakwa wurrakina ke-kuwarrukwajungwunama akwa karruma-dirrburakinama aburra-langwa mangma kuw-engkirrikaja-mulangwa ena-langwa ayakwa. Kembirra kenumini-yarrkuwarakinama wurrakina Neningikarrawara-langwa ayakwa, wuburra laka wurrukwala warnumamalya wurruwerrikidirrbura aburrajukwaba ne-yaminama wurrakina. Kembirra wurrababurna wurramukwiyadakina warnumamalya kuw-embirrarinama wurrakina kajungwa warniki-rringki-yada ebina kini-yamina-mulangwa Nubungkawa Neningikarrawara. Biya kuw-engkirrikajama enuwa-wa, nuw-engkirrikenu-mulangwa adinuba-wiya ayakwa nenikuwena-langwa-da,” ni-yama nakina nenikumamurikaja Neningikarrawara-langwa nenu-maka Jekarayu-wa-da. ");
INSERT INTO aoi_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Eneja ni-yama Jekaraya enuwa-wa, “Ki-yamarrkinama ngayuwa k-eningmidinama akina ayakwa alyangmandukwuna? Ningeniyuwangkwe-ka arakba ningena. Ngalajukwaba dadingiyarrka dadiyuwangkwe-ka arakba. Yikingi-yamarrkiname-ka kembirra yirringalakena?” ni-yama. ");
INSERT INTO aoi_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Eneja kembirra nakina nenikumamurikaja Neningikarrawara-langwa ni-yama, “Ningenimikirra Keburiyela. Neningikarrawara-langwa ningenikumamurikaja ningena, akwa ning-arjiyajinama enuwa-manja akwudangwa ningeningangkawura. Eneja ngini-larrkama nakina ngayuwa nungkuwa-wa kajungwa yiba-makini-yada nungkuwa-manja enena ayakwa eningaba. ");
INSERT INTO aoi_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Akena yi-minikalyika-mubaba ningkakina, kembirra ningkeningayakwa-ma k-ambilyama ningkakina-da, akwa nara e-yengbuma ayakwa yanda-langwa kini-rukwularrina-manja nangariya nungkwa-langwa-da. Yi-minikalyikama akena ke-yaminama amandangwa enena yirra-makinama aduwaba. Ngalaja dadingiyena kangumin-arrangbinama amandangwa nenikuwena dakina-da. Akina-bu ngawa-da,” ni-yama nakina nenikumamurikaja Neningikarrawara-langwa Jekarayu-wa biya ni-likena arakba-da. ");
INSERT INTO aoi_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Umba n-ambudidinu-manja nakina Jekaraya arrawa, aburraja warnumamalya nuw-embirrarinuma errekba-manja ngawa wurrakina. Namurndak-embirrarinu...wa. Biya ne-yama wurrakina, “Miyambena-burra nara a-jaduma warenja umba n-ambudida nakina?” ne-yamama na-lyangkumakajungwunuma wurrakina. “Nenungkwurakbe-ka arrawa-manja nakina-da,” namurndaki-yama. ");
INSERT INTO aoi_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Kembirra arakba-langwa ni-jadinga eneja Jekaraya nakina akena nara kini-yengbina ayakwa. Nu-warrijuwama wulkwa ayarrka. Umba na-lyangkumakajungwunuma wurrumurndakakina warnumamalya, “Dukwa Neningikarrawara nenu-marngkirringkama nakina-da,” namurndaki-yama wurrakina-da. ");
INSERT INTO aoi_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Bi...ya kembirra arakba neniyuwangkwa Jekaraya ni-jerrukwama ebina warka nu-war•dangu-mulangwa Neningikarrawara-langwa-manja angalya. Biya ni-lalikama arakba Jirujalema umba ni-lawurradinuma ena-langwu-wa angalya, akwa n-ambilyuma arakba yakwujina. ");
INSERT INTO aoi_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Biya yimangbala yimawura nu-wurdanguma yakinu...wa. Akena ngalaja dakina Lijibida nara kingi-likena nuw-ambilyu-murruwa warnumamalya umba ying-abuwarrkajungwunuma alikira-manja arrawa ngawa. Kembirra yinginuminu-mambakinuma arakba dakina wurrangariya Jekaraya-langwa. ");
INSERT INTO aoi_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Yingi-yama kembirra dakina, “Nubungkawa Neningikarrawara nu-marngkirradinuma nakina ngayuwa-manja mena ningi-yeliyangu-mubaba ebina-wiya ningeningarijira-mulangwa ning-ambilyuma. Akena nara arakba e-yeliyuma aduwaba ningena-da,” yingi-yama dakina-da. ");
INSERT INTO aoi_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Bi...ya yuwilyaba-manja yimawura, eneja nakina nenikumamurikaja Neningikarrawara-langwa nibina-murrada nenimikirra Keburiyela ni-likenumurra nakina akinu-wa angalya Keliliya emikirra Nejirida. ");
INSERT INTO aoi_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Eneja neni-larrkama Neningikarrawara duwilyabu-wa dadiyara dadimikirra Meri. Dadiki-yar•di-yada ngalaja dakina nuwilyaba nenungkwarba nenimikirra Jawijiba, akena nara ambaka keni-yakeyina wunalakina. Eneja numirenikba neningarakburakba-kiya Jawijiba-langwa Nubungkawa Deyibida nakina. ");
INSERT INTO aoi_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Eneja ni-yama Keburiyela Meri-wa, “Ngeniyerriya, Nubungkawa Neningikarrawara nginu-werrungwur•denama amandangwa nungkuwa-manja. Nungkuwa-manja n-ambilyame-ka,” ni-yama nakina. ");
INSERT INTO aoi_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Ngalaja Meri yingu-werrikawarriyadinume-ka ying-engkirrikenu-mulangwa amurndakakina ayakwa. Yingi-lyangkiyama, “Ne-yamarrkama ena ayakwa? Miyambena-burra nginu-makama enena?” yingi-lyangkiyama. ");
INSERT INTO aoi_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Eneja Keburiyela ni-yama ngaluwa-wa, “Nara akbar•duma, mena Neningikarrawara nginu-werrungwur•dena-mubaba nungkuwa-manja. ");
INSERT INTO aoi_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Ku-mambakinama ningkakina nangariya, kembirra kin-arrangbinama akwa kini-yengbijinama Jesus. ");
INSERT INTO aoi_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Kin-arumidina-manja nakina, naruma numikbiyiya-dangwa nubungkawa kin-ambilyama. Aburraja warnumamalya ke-yaminama, ‘Nenikuwenikba nakina Neningikarrawara-langwa umba nakine-ka Neningikarrawara naruma numikbiyiya-dangwa nakina,’ ke-yaminama wurrakina. Eneja Nubungkawa Neningikarrawara kenu-bungkawakinama nakina. Eneja kembirra kinu-bungkawadinama nakina wuburra laka numirenikba neningarakburakba-kiya Nubungkawa Deyibida nu-bungkawadinuma nakina arakba-wiya. ");
INSERT INTO aoi_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Akwa niyirrbiyirrba ngawa kinu-bungkawadinama nakina warnikinikaduwa-manja wurrumirumirena Jekaba-langwa neningangkawura nakina-da,” ni-yama Keburiyela Meri-wa. ");
INSERT INTO aoi_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Ngalaja yingi-yama Meri, “Nara ambaka ku-mungkwula-langwa ngayuwa warnungkwarba-manja, umba ki-yamarrkinama kin-arrangbinama nangariya?” yingi-yama. ");
INSERT INTO aoi_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Eneja ni-yama Keburiyela, “Neningikarrawara-langwa Amawurrina ebina engbuda ka-likajama kaki-lyinginama ningkakina, bi...ya kembirra ambaka-murra ku-mambakinama wurrangariya ningkakina-da. Kembirra aminakina-langwa aburraja warnumamalya ke-yaminama, ‘Naka niyukwujiya Nenikuwenikba Neningikarrawara-langwa nukwurdukwurda naka-da,’ ke-yaminama wurrakina. ");
INSERT INTO aoi_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","“Kwuja, ngalajukwaba Lijibida kirringuminuwilyaba-ma kirringalakina wurrumirumirenungwa yingu-mambakinama arakba wurrangariya. Mama dadiyuwangkwa arakba dakina umba kingin-arrangbinama nangariya. Duburubura ying-ambilyuma dadinungkwurakba dakina, akena yingu-mambakinuma wurrangariya yuwilyaba arakba yimawura dakina-da. ");
INSERT INTO aoi_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Amandangwa eneja kini-lyangkuwerribikajungwuna-manja Neningikarrawara neniki-yama-langwa eningerribirra, kemba kini-yaminama amandangwa nakina-da,” ni-yama Keburiyela Meri-wa-da. ");
INSERT INTO aoi_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Ngalaja yingi-yama Meri enuwa-wa, “Ning-engkirrikame-ka ayakwa nungkwa-langwa akwa ningenikuminuwar•duwar•de-ka ningena Nubungkawa-langwa Neningikarrawara, kembirra nara ningena a-waruma,” yingi-yama. Eneja kembirra nenikumamurikaja Neningikarrawara-langwa nanga-lalika Meri arakba-da. ");
INSERT INTO aoi_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","40","Umba ngalaja nanga-ngayindanguma Meri dadiki-ngarri-yada dakinu-wa Lijibida akina-wiya. Kembirra yingi-lalika dakina Nejirida arakba umba yingi-likena warenja-bawiya yadikina engku-wa nuw-angkarrinu-murruwa arrirra dalada. Yingu-wurdanguma Judiya-wa ababurna-murruwa angalya angakarjiyinga. Akina-manja angalya Judiya yingu-wurduwurdanguma ngawa angakarjiyinga, yanda-langwa ying-akburranga angalya ebina-manja n-ambilyu-murrumanja Jekaraya. Biya yingi-yar•da arakba ena-langwa-manja alikira. Ying-awiyeba dakina biya narringi-lyelyimbukweyina yakwujina arrawa Lijibida aburrunguwa. Yingi-yama Meri ngaluwa-wa, “Laka, ningkeningaba? En-ambilya Neningikarrawara nungkuwa-manja,” yingi-yama. ");
INSERT INTO aoi_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Ying-engkirrika-manja Lijibida amurndakakina ayakwa, kembirra nibina nangariya ngala-langwa eneja nu-warrinuma arakba ngala-langwa-manja mulkwa. Akini-yada ngawa ngalaja Amawurrina Neningikarrawara-langwa yingaki-lyangburrukwajuwa yingaku-war•dikama Lijibida-manja arakba akina-da. ");
INSERT INTO aoi_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Kembirra yingi-yengbinuma yingi-yangkarjiyajungwunuma ayakwa mena yingi-yangmarngkwunu-mubaba dakina. Akwa yingi-yama Meri-wa, “Neningikarrawara nginu-werrungwur•denama nungkuwa-manja akwa nu-wekbalyinuma ningkakina. Kembirra nungkwaja ningkaruma arakba ningkidarringka ningkilyengma aduwaba ningkakina. Umba ngarningka kenu-werrungwur•denama eneja Neningikarrawara nangariya-manja enejukwaba. ");
INSERT INTO aoi_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Nungkuwe-ka ningkirndenikba ningkakina nganyangwa-langwa Nubungkawa, akena ningki-likenume-ka yangkwurrangwa-da ngayuwa-wa aduwaba-da,” yingi-yama Lijibida. ");
INSERT INTO aoi_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","“Ning-engkirrika-manja ngayuwa ayakwa nungkwa-langwa,” yingi-yama dakina Lijibida, “kembirra aburraja wurrangariya nganyangwa na-warrinuma mulkwa-manja nu-ngwurrkbalinuma yukwudukwuda aburra-langwa. ");
INSERT INTO aoi_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Eningabe-ka ka-ngekburakajungwunama nungkwa-langwa ningk-eningmidinu-mulangwa ayakwa Neningikarrawara-langwa alyangmandukwune-ka, akwa ningku-werrikambilya-mulangwa enuwa-manja, mena-baba ababurna-langwa nginu-makama Nubungkawa Neningikarrawara nungkuwa-manja ke-yaminama akina amandangwa-da,” nanga-makama dakina Lijibida Meri-wa-da. ");
INSERT INTO aoi_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Yingi-yama arakba ngalaja Meri, “Yawe-ka. Ningeni-yangmarngkwajiname-ka amandangwa Nubungkawa Neningikarrawara ningeningangkawura. ");
INSERT INTO aoi_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Nakina-bina ngin-enibikinama ngayuwa kembirra ningu-werrikilyelyingmajungwunama angwurra. ");
INSERT INTO aoi_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Mama ningiyukwujiya ningeningerribirra ningenumamalya; umba ngin-akwurrajuwama nakina ngayuwa-manja. Ningenikuminuwar•duwar•da wulkwa ena-langwa umba nara akwala. Aduwaba-langwa aburraja wurrababurna-langwa warnumamalya ke-yaminame-ka, ‘Nubungkawa Neningikarrawara ni-yamama eningaba nakina ngaluwa-manja,’ ke-yaminama wurrakina. ");
INSERT INTO aoi_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Ke-yengbinama enena ayakwa nganyangwa-langwa wurrakina mena Neningikarrawara narrubuda-baba nilyengma nakina, akwa arrubuda nginumini-ngekburakama nganyangwa. Narrubude-ka nakina akwa akwurdukwurda ekirra ena-langwa. ");
INSERT INTO aoi_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Neningikarrawara nakina n-errukwulinuma ngakwurra-langwa warnumamalya warningarakburakba-kiya-manja yanda-langwa aduwaba. Akwa kin-errukwulinama nakina ngakwurra-langwa wurriyukwayuwa akwa ngarningka aburra-langwa-manja wurriyukwayuwa aburrajukwaba. Kin-errukwulinama ngarrababurna-langwa ngarnumamalya ngarribina akinumini-yarrkuwarakina-murrumurra ena-langwa ayakwa. ");
INSERT INTO aoi_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Akena wurribina na-ngkweningabakajungwunu-murrumurra akwa namin-engkingkirrajajungwunu-murrumurra warnumamalya nu-minangkirreyinuma Neningikarrawara wurrakina ni-lawulawaja-mulangwa nakina arrubuda ayarrka ena-langwa. ");
INSERT INTO aoi_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Nenu-wurranguma nakina wurrububungkawa wurribina na-ngkweningabakajungwunu-murrumurra wurrakina, akena nen-akumarnuma nenu-bungkawakama nakina warningerribirra warnumamalya wurriyukwayuwa-da. ");
INSERT INTO aoi_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Nenu-kwama nakina Neningikarrawara aninga wurribina na-mureyangu-murrumurra warnumamalya, akena wurrukwala neni-larrkenuma engku-wa eyebirra ayarrka wurribina wurruminababurna angwarnda iya amurndakijika. ");
INSERT INTO aoi_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Arakburakba-kiya-wiya nenu-makama nakina Neningikarrawara ngakwurra-langwa-manja wurrumirumiranyungwa kenu-mamurikajina-mulangwa wurrakina-manja akwa ngarningka akenu-mamurikajina-mulangwa ngakwurruwa-manja aduwaba. Nara nakina Neningikarrawara kini-yakuwabijuwa amurndakakina ayakwa ena-langwa, umba ni-likenuma nakina yangkwurrangwa aduwaba kajungwa neniku-mamurikaji-yada ngakwurruwa ena-langwa NgarningiYijireyila ngarnumamalya. ");
INSERT INTO aoi_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Akwa ni-yakuwerribikinuma nakina amurndakakinu-wa ena-langwa ayakwa eningarakburakba-kiya-wa akwa n-errukwulinuma Aburiyama-manja. Akwa aduwaba ngarningka n-errukwulinama ngawa ngakwurruwa ngakwurrajukwaba, akwa kin-errukwulinama nakina aburramba-langwa wurriyukwayuwa ngakwurra-langwa akwa wurrumirumiranyungwa warnikinikaduwa aburrajukwaba. Kini-yaminjaminama ngawa neningangkawura Neningikarrawara nakina-da,” yingi-yama Meri-da. ");
INSERT INTO aoi_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Biya dakina Meri ying-ambilyumurra Lijibida-manja yabiyakarbiya yimawura. Biya kembirra yingi-lawurradinuma dakina angalyu-wa Nejiridu-wa arakba-da. ");
INSERT INTO aoi_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Biya numu-darrbudinuma arakba mamawura dadik-arrangba-wa ngalaja Lijibida wurrangariya ngala-langwa. Kembirra yingin-arrangba arakba nangariya. Diyekirrerre-ka arakba kembirra dakina. ");
INSERT INTO aoi_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Aburraja warnumamalya ngala-langwa wurriyabiyabada akwa ngawa wurrukwala warnumamalya wurribina nuw-ambilyu-murrumurra akwudangwa ngaluwa-manja nuw-engkirrikama ayakwa ngala-langwa-langwa. Nuw-eningmidinuma Nubungkawa Neningikarrawara nu-marngkirradinu-mulangwa nakina ngaluwa-manja. Biya aburrajukwaba namurndaki-yekirrerridinuma kembirra wurrakina-da. ");
INSERT INTO aoi_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Bi...ya mamangbala mabiyakarbiya arakba mamawura numu-rukwulyuwakenuma makina. Aburraja kembirra neni-ringandanga nenu-mukaduwamurrikama nakina numurrkbalya. Umba wurrukwala warningakwujina warnumamalya neni-ngayindanguma keni-yengbijuwama niyukwujiya Jekaraya nenimikirra, ebina-murrada ngawa ekirra nungwenikba-langwa. ");
INSERT INTO aoi_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Akena ngalaja yingu-waranga dakina dirndenikba. “Nare-ka-da. Umba Janjana nenimikirra nakina-da,” yingi-yama Lijibida dakina-da. ");
INSERT INTO aoi_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Aburraja ne-yama, “Nara wurribina warnumamalya nungkwurna-langwa warnimikirra Janjana.” ");
INSERT INTO aoi_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Kembirra nuw-andeya wurrakina Jekarayu-wa akwa neni-yendabena ayarrka-murra. Neni-ngayindanguma wurrakina nakina-bina neniki-yengbiji-yada ekirra-da. ");
INSERT INTO aoi_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Enamba-langwa Jekaraya neni-yendabena arrkala ayarrka-murra amurndakijika eningakarrikarra. Kembirra nenu-kwa aburraja wurrakina. Kembirra n-arrikarranga arakba nakina amurndakenena ayakwa. “Amandangwa Janjana nenimikirra.” Biya “Wa!” kembirra namurndaki-yama. ");
INSERT INTO aoi_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Akena arngkawura-wiya n-arrikarrangu-wiya Jekaraya ekirra, kembirra ni-yengbina arakba nakina ayakwa-da. Biya neni-yangmarngkwajuwa Neningikarrawaru-wa-da. ");
INSERT INTO aoi_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Akini-yada ngawa aburraja wurrumurndakakina warnumamalya warningakwujina nuw-akbar•danguma angwurra. Aburraja wurrukwala warnumamalya wurribina nuw-ambilyu-murrumurra Jekaraya-langwa-manja angalya akwudangwa nuw-akbar•danguma angwurra aburrajukwaba. Biya nenumurndaku-makama wurrukwala-manja warnumamalya engka-manja iya engka-manja angalya akina-langwa ne-yama-murrilangwa, yanda-langwa wurrababurna-langwa warnumamalya akina-manja angalya angakingakarjiyinga Judiya nuw-engkirrikenuma arakba akina ayakwa. ");
INSERT INTO aoi_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Nara ke-yakuwabijuwa umba narru-wilyakama ngawa aburra-langwa-manja mangma-da. Biya namurndaki-yama, “Kin-arumidina-manja naka niyukwujiya kini-yamarrkiname-ka? Numiyambene-ka nenungkwarba kin-ambilyama naka-da?” namurndaki-yama. Warningma wurrakina amandangwa nen-akwurrajuwa-mulangwa Nubungkawa Neningikarrawara nakina-manja niyukwujiya-da. ");
INSERT INTO aoi_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Ngalaja kembirra Neningikarrawara-langwa Amawurrina akwurdukwurda nenaki-lyangburrukwajuwama nungwenikba-manja Jekaraya nenaku-war•dikama akina. Eneja kembirra ni-yengbinuma Jekaraya amurndakenena ayakwa Neningikarrawara-langwa nakina. ");
INSERT INTO aoi_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Ngeni-yangmarngkwajina ngarna Nubungkawa, nibina-murrada Neningikarrawara NgarningiYijireyila-langwa ngarnumamalya, mena ni-yar•duma ngarruwurrakuwilyarra arakba nakina-baba. Eneja ngarrenu-mamurikajuwama ngakwurruwa ena-langwa ngarnumamalya akwa ngarren-enjungwurranguma arakba nakina. ");
INSERT INTO aoi_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Akwa ngarrenu-kwama Nubungkawa narrubuda ngakwurra-langwa. Umba eneja Deyibida-langwa numirenikba nenikaduwa nakina. Nakine-ka Nubungkawa aken-enibikinama nakina ngakwurruwa. ");
INSERT INTO aoi_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Arakburakba-kiya-wiya eneja Neningikarrawara ni-yarrkakumarnuma ayakwa ena-langwa-manja ngarnumamalya. Umba aburraja ena-langwa warnikumakumaka ayakwa ngarrabumini-yarrkilalikama wurrakina akina ayakwa ena-langwa ngakwurra-langwi-yada arija-langwa. ");
INSERT INTO aoi_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Nenu-makama eneja Neningikarrawara ngakwurra-langwa-manja wurrumirumiranyungwa warningarakburakba-kiya aken-enibikina-mulangwa nakina amandangwa ngakwurruwa, akwa aken-enjungwurrena-mulangwa nakina wurrukwala-langwa warnumamalya wurribina ngarrabu-wirrikbina-murrilangwa akwa ngarrabumini-ngekbungekburakina-murrilangwa awurruwurrariya ngakwurra-langwa. ");
INSERT INTO aoi_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Nenu-makama Neningikarrawara ngakwurra-langwa-manja wurrumirumiranyungwa kin-errukwulina-mulangwa aburruwa akwa ngawa ngakwurruwa ngakwurrajukwaba aduwaba. Akwa nenu-makama nakina ngarningka aburruwa-wa kin-engkingkirrikaja-mulangwa amurndakibinu-wa ayakwa eningarumuruma ena-langwu-wa. ");
INSERT INTO aoi_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Ni-yengbinuma nakina Neningikarrawara ayakwa arrubuda ngakwurra-langwa-manja numiranyungwa Aburiyama-manja. ");
INSERT INTO aoi_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Nenu-makama enuwa-manja aken-enjungwurrena-mulangwa ngakwurruwa wurribina-langwa warnumamalya ngarrabu-wirrikbina-mulangwa ngakwurruwa, kajungwa nari-yada ngarna akbar•duma umba akinuminu-war•deni-yada Neningikarrawara, ");
INSERT INTO aoi_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","akwa kajungwa ak-ambilyi-yada ena-langwa ngarnumamalya, akwa aki-likaji-yada ngarna ena-langwa-manja mamurukwa meningaba-manja, ngarruwerrikidirrbura ngarningangkawura ngarna-da,” ni-yama Jekaraya nakina-da. ");
INSERT INTO aoi_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Biya kembirra ni-yengbina arakba Jekaraya amurndakenena akwala ayakwa niyukwujiya-wa Janjana. “Umba nungkwaja, aburraja warnumamalya kabi-yengbijinama wurrakina Neningikarrawara-langwa ningkenikumakumaka ayakwa ningkakina, mena ka-makina-mubaba nungkuwa ningkakina ayakwa Neningikarrawara-langwa aburruwa-manja. Naruma numikbiyiya-dangwa eneja nakina Neningikarrawara. Bi...ya nungkwaja k-arumidina-manja ningkakina ki-lyengmename-ka. Ki-lyengmenama nungkuwa kajungwa kinumini-ngekburakini-yada ningkakina mamurukwa Nubungkawa-langwa. ");
INSERT INTO aoi_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","K-eningmikinama ningkakina warnumamalya-manja Neningikarrawara ken-enibikina-mulangwa wurrakina mena kenumini-yakuwabijina-mubaba nakina awurruwurrariya aburra-langwa. ");
INSERT INTO aoi_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","79","Ngakwurraja aduwaba ngarnumamalya ngarri-yaminama ngarna wuburra laka alarrumur•da-manja ngarr-ambilyama ngarna akwa ngarr-akbar•denama akwijungwa-langwa. Akena eneja Neningikarrawara ngakwurra-langwa numarngkirre-ka nakina nilyengma akwa n-errukwulinama ngakwurruwa. Wuburra laka ne-kbadena-manja akina, kini-larrkabarrakajinama angalya nakina Neningikarrawara. Akwa keni-larrkajama nakina yangkwurrangwa nibina ni-yama-murrada neniki-larrka, nibina akenumini-larrkabarrakajinama angalya, nibina aken-enibikinama ngakwurruwa ngarnumamalya. Akini-yada kembirra meningilida wuburra ke-yaminama akina. Aki-likaja-manja ngakwurraja meningilida akuma-rringkinama mamurukwa ngarniki-liki-yada. Eneja kembirra Nubungkawa akenu-wilyakajinama kajungwa aki-likaji-yada Neningikarrawara-langwa-manja mamurukwa meningaba-manja ngarrakina. Akenu-wilyakajinama nakina kajungwa ngarriyekirrerra ngarruwurrangekburna ak-ambilyi-yada ngakwurruwa yilyurrkwa-murra yukwudukwuda yarna-da. Akina ngawa,” ni-yama Jekaraya nakina-da. ");
INSERT INTO aoi_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Bi...ya eneja niyukwujiya Janjana n-arumidinuma nakina akwa n-eningmidinuma Neningikarrawara-langwa akwa nenumini-yarrkuwarakama Neningikarrawara-langwa ayakwa nakina. Bi...ya n-ambilyumurra nara-murrumanja alikira. N-ambambilyumu...wa. Bi...ya arakba-langwa ni-jadanguma n-abilyerrikajungwunuma nakina WarningiYijireyila-manja warnumamalya. Aburraja kembirra ena-langwa warnumamalya neni-rringkama arakba-da. ");
INSERT INTO aoi_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Akini-yada kembirra engka-manja angalya emikirra Rawuma eneja nubungkawa naruma n-ambilyumurra. Nenimikirra Akwajija. Narrubude-ka nubungkawa nakina. Biya ni-lyingama ababurna-manja angalya eminiminingka akwa nu-bungkawadinuma wurrababurna-manja warnumamalya wurriminiminingka. Biya ni-lyangkuwerribikajungwunuma arakba nakine-ka nubungkawa Akwajija neniku-murnduwi-yada ekirra wurrababurna-langwa warnumamalya amurndakibina-manja angalya ababurna-manja. ");
INSERT INTO aoi_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Aburraja kembirra wurrababurna-langwa wurrakina wurrububungkawa wurriyukwayuwa ena-langwa narrawurra-murnduwarnuma arakba wurrumurndakibina warnumamalya. Umba eneja nuwilyaba nubungkawa niyukwujiya nenimikirra Kwariniyija nu-bungkawadinuma nakina engemba-manja angalya Jiriya-manja. ");
INSERT INTO aoi_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Aburraja kembirra wurrababurna-langwe-ka warnumamalya namurndaki-likenuma wurrakina aburra-langwu-wa angalya. Namurndaki-likenuma angerriba aburra-langwu-wa angalya kajungwa warnik-arrikarri-yada wurrakina ekirra aburra-langwa yakwujina jurra-manja. ");
INSERT INTO aoi_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","5","Eneja kembirra Jawijiba ni-lalikama nakina ebina angalya Keliliya emikirra Nejirida umba ni-likenuma enejukwaba ena-langwu-wa angalya aburnuwa dadingiyenikba Meri. Akena wurrangariya yingu-mambakinuma dakina Meri. Biya neni-likenuma wunalakina Judiya-wa Jawijiba-langwu-wa angalya emikirra Bediliyema. Akine-ka Bediliyema ena-langwa angalya akina, mena ena-langwa wurrumirumirena warningarakburakba-kiya wurruminakina angalya wurrakina-baba. Arakburakba-kiya-wiya eneja nuwilyaba nubungkawa nenimikirra Deyibida numinakina-langwa mamurukwa enejukwaba nakina. Umba Jawijiba kembirra ni-likenuma Keliliya-langwa yadikina Bediliyemu-wa, aburnuwa Meri, wunenik-arrikarri-yada ekirra aburna-langwa yakwujina akina-manja angalya. ");
INSERT INTO aoi_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","7","Nen-alilikenu...wa. Yakwujina neni-yar•da wunalakina Bediliyema-manja. Dadik-arrangbi-yada wurrangariya arakba dakina Meri, akena nara ebina angalya aburna-langwa arumuruma-manja alikira. Kembirra eyukwujiya-manja alikira bulukwa-murriya-langwa-manja nen-ambilyuma wunalakina-kiya. Biya yakwujina ngawa Bediliyema-manja yingin-arrangba Meri nenungkwarba ngala-langwa numilyengma. Biya yinginu-wurumbijuwa ngala-langwa nangariya numurrkbalya dumbala-murra akwa yingin-akumarna bulukwa-murriya-langwa-manja bada eninganinga-langwa-manja-da. ");
INSERT INTO aoi_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Kembirra akini-yada ngawa awilyaba-manja angalya Bediliyema-manja akwudangwa, aburraja wurrukwala warnungkwarba narr-akukwurrajuwama jiba aburra-langwa. Nuw-ambilyumurra wurrakina jiba-manja, narr-akukwurrajuwama ngawa alyarrngwalyilya. ");
INSERT INTO aoi_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Eneja kembirra Nubungkawa Neningikarrawara neni-larrka arakba nakina nuwilyaba nenikumamurikaja ena-langwa angaluba angubina-langwa, nibina ni-jadinga-murrada wurrakina-murrumanja. Biya nakina Neningikarrawara ni-larrkabarrakajuwa ebina angalya-da. Aburraja kembirra nuw-akbar•da angwurra wurrumurndakakina warnungkwarba-da. ");
INSERT INTO aoi_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Eneja nakina nenikumamurikaja Neningikarrawara-langwa ni-yama aburruwa-wa, “Nara akbar•duma kirrakina umba w-engkirrikiya-langwa enena ayakwa ngarra-makinama, mena ningi-likenumurra ngayuwa yangkwurrangwa nungkwurruwa-wa kajungwa ka-makini-yada ayakwa eningaba. Yik-engkirrikaja-manja kirrakina enena ayakwa eningaba, akwa wurruminukwala-langwa warnumamalya kuw-engkirrikaja-manja wurrakina aburrajukwaba, kembirra kirrangkwulyumida-langwa karnumamalya kinu-ngwurrkbalinama yukwudukwuda nungkwurra-langwa-da. ");
INSERT INTO aoi_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","“Memema-manja ngawa mamawura Deyibida-langwa-manja angalya ni-rukwularruma arakba eneja nuwilyaba niyukwujiya. Arakburakba-kiya-wiya eneja Neningikarrawara nenu-makama nakina nungkwurra-langwa-manja wurrarumuruma keni-larrkaja-mulangwa nakina nungkwurruwa-wa ena-langwa NuMejaya. Kembirra naka arakba nibina-murrada ni-rukwularruma arakba NuMejaya-da. Nubungkawa nakina n-ambilyama. Kembirra yiken-enibikinama kirrakina karnumamalya-da. ");
INSERT INTO aoi_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","“Nungkwurraja yikin-akburranginamurra numurrkbalya niyukwujiya dumbala-murra bada-manja, nara aruma-manja alikira umba eyukwujiya-manja alikira, bulukwa-murriya-langwa-manja. Yikin-akburrangina-manja kembirra nakina, yik-eningmidinama arakba enena ayakwa alyangmandukwuna ngawa ena-da,” ni-yama nakina nenikumamurikaja Neningikarrawara-langwa wurrumurndakibinu-wa warnungkwarba-da. ");
INSERT INTO aoi_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Aburraja kembirra wurrakina warnungkwarba narra-rringka arakba wurrababurne-ka warnikumamurikaja Neningikarrawara-langwa. Akini-yada ngawa aburraja nawurraki-jadingama wurrakina adirrariyaba angubina-langwa. Kembirra na-mebeyina emeba, neni-yangmarngkwajuwa Neningikarrawaru-wa wurrakina. ");
INSERT INTO aoi_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","Biya namurndaki-yama, “Ngeni-yangmarngkwajinama ngarna Neningikarrawara nibina n-ambilyamurra ena-langwa-manja angalya abalkaya. Nakine-ka nenu-werrungwur•denama wurrakina warnumamalya nenumini-yarrkuwarakina-murrumurra ena-langwa ayakwa. Aburraja kembirra ka-likajamurra yilyurrkwa-murra yukwudukwuda wurrakina-da,” namurndaki-yama wurrumurndakakina warnikumamurikaja Neningikarrawara-langwa-da. ");
INSERT INTO aoi_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Biya nawurraki-likena erribaja, namurndaki-lawurradinuma Neningikarrawara-langwu-wa angalya arakba-da. Aburraja kembirra wurribina warnungkwarba na-makijeyina ayakwa, biya ne-yama, “Kwa, ngarri-likaja arakba Bediliyemu-wa kajungwa akini-rringkini-yada ngarna nangariya ngarrenu-maka-murrilangwa Nubungkawa Neningikarrawara,” ne-yama. ");
INSERT INTO aoi_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Biya na-likena, nuw-enjirrikeyina arakba wurrakina-da. Nuw-alilikenu...wa. Bediliyema-manja. Biya narralirrak-akburranga yakwujina wunalekbina Jawijiba akwa Meri, akwa neni-rringka nangariya nu-kukwunumurrkwuluma bada-manja, bulukwa-murriya-langwa-manja angalya. ");
INSERT INTO aoi_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Kembirra narralirraku-maka wunalakina-kiya-manja amurndakibina ayakwa nibina nenikumamurikaja Neningikarrawara-langwa ni-yengbinu-mulangwa nakina-langwa nangariya. ");
INSERT INTO aoi_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Biya kembirra narra-maka wurrakina wurrukwala-manja warnumamalya aburrajukwaba nangariya-langwa. Aburraja nawurrak-engkirrika-manja akina ayakwa namurndaki-yakikbijangeyina angwurra arakba wurrakina. ");
INSERT INTO aoi_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Umba ngalaja Meri yingu-wilyakama dakina amurndakibina ayakwa ngala-langwa-manja aringka akwa ying-engkingkirrikenuma ngawa amurndakakinu-wa. ");
INSERT INTO aoi_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Aburraja kembirra wurrumurndakibina warnungkwarba na-lawurradina aburra-langwu-wa jiba. Neni-yangmarngkwajuwama Neningikarrawara, eningaba-wiya-baba narri-rringkama akwa nuw-engkirrikenuma wurrakina. Narr-akburrangame-ka ebina-langwiya ngawa ayakwa nenu-maka-mulangwiya Neningikarrawara-langwa nenikumamurikaja-da. ");
INSERT INTO aoi_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Bi...ya mamangbala mabiyakarbiya-manja mamawura aburraja neni-ringandanguma nenu-mukaduwamurrikama nibina niyukwujiya, akwa neni-yengbijuwama nakina Jesus. Akina ekirra ebina-murrada neni-yengbijuwa-murrada nenikumamurikaja Neningikarrawara-langwa nara-wiya kingu-mambakina dirndenikba-da. ");
INSERT INTO aoi_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","24","Aburrubukwurraja ngawa Jawijiba akwa Meri akwa nangariya Jesus nabuk-ambilyumurra wurrubukalakina Bediliyema-manja. Ngalaja yuwilyaba yimawura nu-merrkbijanga arakba yakina akina-manja angalya. Akwa kembirra neni-likena arakba Jawijiba akwa Meri Jirujalemu-wa, nenu-wilyakama nangariya. Nabuk-alilikenu...wa. Jirujalema-manja nabuki-yar•da. Biya neni-likena arakba wunalakina Jawijiba akwa Meri Neningikarrawara-langwu-wa angalya kajungwa wuneniku-kwi-yada aburna-langwa nangariya Nubungkawu-wa Neningikarrawara akwa kajungwa keni-yamini-yada yakwujina amurndakibina-langwiya ayakwa eningarumuruma-langwiya nenu-kwa-mulangwiya Mawijija WarningiYijireyila-manja warnumamalya arakburakba-kiya-wiya. Adinuba-wiya eneja Nubungkawa Neningikarrawara nenu-makamurra nakina Mawijija-manja, umba kembirra enamba-langwa Mawijija nenu-makamurra nakina wurrumurndakibina-manja warnumamalya ebina-murrada ngawa ayakwa Neningikarrawara-langwa. Ni-yamama Nubungkawa Neningikarrawara, “Wurrababurna-langwa nungkwurra-langwa wurrumilyengma wurriyukwayuwa warnungkwarba nganyangwa wurrakina,” ni-yamama nakina. Akwa enena ngarningka ayakwa ni-yamama Nubungkawa Neningikarrawara, “Dibine-ka didarringka, karring-arrangbina-manja wurrangariya dakina, kinginga-menamurra dambilyuma darrawurukukwa, akena nara-manja dibina darrawurukukwa aba dakwurakburakba. Kingi-likajamurra Neningikarrawara-langwu-wa angalya akwa kinginu-kwunama NuMinidu-wa nenungkwarba. Kingi-yaminama dakina enuwa-wa, ‘Neningikarrawara-langwa dalakena-kiya,’ kingi-yaminama. Kembirra nakina nenungkwarba NuMinida kiningalirraku-wardenama dalakina darrawurukukwa-kiya,” ni-yamama Nubungkawa Neningikarrawara. Akwa akina kembirra ngalaja Meri yingi-yamamurra yakwujina ngawa Neningikarrawara-langwa-manja angalya kajungwa diyadi-yada arakba dakina. ");
INSERT INTO aoi_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Akina-manja ngawa angalya Jirujalema eneja nuwilyaba neniyerringka n-ambilyumurra nenimikirra Jimiyina. Nakina neniyerringka neningabe-ka, n-engkingkirrikenume-ka Neningikarrawara-langwu-wa ayakwa. Akwa n-embimbirrarinumurra nakina NuMejayu-wa, mena nakina NuMejaya nenik-enjungwurri-yada ena-langwa warnumamalya WarningiYijireyila. Ngalaja Neningikarrawara-langwa Amawurrina akwurdukwurda nuw-ambilyumurra nakina-manja neniyerringka. ");
INSERT INTO aoi_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Ebina-wiya ne-yengbina ayakwa akina Amawurrina enuwa-manja akwa ne-yamama, “Nare-ka a-jungwuma ningkakina yanda-langwa kini-rringkinama nungkuwa nibina nenumamalya Nubungkawa Neningikarrawara neniki-larrka nakina yangkwurrangwa nenimikirra NuMejaya,” ne-yamama akina Amawurrina akwurdukwurda Neningikarrawara-langwa Jimiyinu-wa-da. ");
INSERT INTO aoi_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Biya ne-yama arakba akina Amawurrina Jimiyinu-wa, “Likaja arakba Neningikarrawara-langwu-wa angalya,” ne-yama akina. Eneja kembirra ni-likena arakba yenjerrikina nakina neniyerringka. Umba n-ambilyu-wiya nakina Neningikarrawara-langwa-manja angalya, aburnaja Jawijiba akwa Meri wunalakina neni-yar•duma yakwujina. Umba kembirra nakina neniyerringka Jimiyina nenilirrak-akburrangama wunalakina yakwujina. ");
INSERT INTO aoi_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Biya kembirra neni-rndarrka niyukwujiya nangariya ena-langwa-manja ayarrka akwa nenu-kwiyukwiyuma. Biya neni-yangmarngkwajuwa nakina Neningikarrawaru-wa akwa ni-yama enuwa-wa, ");
INSERT INTO aoi_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Bungkawa, yirraminu-war•dangumurra warka nungkwa-langwa arakba, akwa ningi-jerrukwama akina. Umba kembirra yi-larrkaja arakba ngu-ngwanjina. Ngi-likaja-langwa ngayuwa enena-langwa angalya yilyurrkwa-murra yukwudukwuda, mena alyangmandukwuna-wiya-baba ayakwa nungkwa-langwa. ");
INSERT INTO aoi_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Yi-larrkaja ngayuwa aduwaba mena ningeni-rringka-mubaba nibina nenumamalya yirrumini-larrkama nungkuwa yirra-langwa yarnik-enibiki-yada yirrababurna-langwa yarnumamalya nungkwa-langwa. Nganyangwa-murra menba ningeni-rringkama ngayuwa aduwaba. ");
INSERT INTO aoi_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Umba ningkeni-larrkama nakina yangkwurrangwa kajungwa wurrababurna-langwa warnumamalya ababurna-manja angalya keni-rringkini-yada nakina aburrajukwaba wurrakina. ");
INSERT INTO aoi_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Nakine-ka wuburra akilarrkabarrirraka kini-yaminama. Biya kenu-wilyakajinama nakina warnumamalya-manja wurribina nuw-ambilya-murrumanja eminingka-manja iya eminingka-manja angalya ebina ka-ngayindena-mulangwa nungkuwa warniki-yami-yada wurrakina. Aburraja wurrumurndakakina warnumamalya karri-rringkina-manja ebina akilarrkabarrirraka, yikabi-yangmarngkwajinama kembirra yirruwa nungkwa-langwa yarnumamalya YarningiYijireyila-da,” ni-yama nakina Jimiyina Neningikarrawaru-wa-da. ");
INSERT INTO aoi_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Aburnaja Meri akwa Jawijiba neni-yakikbijangeyina angwurra wunalakina akina-langwa ayakwa ni-yengbinu-mulangwa nakina neniyerringka nangariya-langwa. ");
INSERT INTO aoi_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Eneja kembirra ni-yengbina arakba nakina neniyerringka akwala ngarningka ayakwa Neningikarrawaru-wa. Neni-yendabena Neningikarrawara kajungwa kini-yamini-yada eningaba wurrubukalakina-manja Jawijiba akwa Meri akwa Jesus. Kembirra nakina Jimiyina ni-yengbina arakba ayakwa Jesus-langwu-wa dirndenikba ngalajukwaba. Ni-yama nakina, “Nubungkawa Neningikarraware-ka nakina nu-wekbalyinuma naka nangariya akwa neni-larrkama enenu-wa angalya kajungwa ngarrukwala NgarningiYijireyila ngarnumamalya aki-jungweyini-yada ngarna, umba ngarrukwala ak-enibikajungwuni-yada. Kin-arumidina-manja nakina, kenu-wilyakajinama warnumamalya-manja ebina kini-yamina-mulangwa Neningikarrawara. Akena aburraja wurrababurne-ka warnumamalya ka-warename-ka nakina. ");
INSERT INTO aoi_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Akini-yada kembirra wurrumurndakakina warnumamalya wurribina ka-warena-murrumurra Neningikarrawara nara arakba abuwarrkama ebina karru-wilyakinama aburra-langwa-manja mangma. Umba nungkwaja ningkirndenikba ningkuwerrikawarriye-ka k-ambilyama ningkakina, wuburra laka lyelyinga angandinga kaku-werridadenama nungkwa-langwa-manja yukwudukwuda akina-da,” ni-yama Jimiyina Meri-wa-da. ");
INSERT INTO aoi_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","37","Umba ngalaja duwilyaba dadiyuwangkwa dadimikirra Ena ying-ambilyumurra dakina akina-manja ngawa angalya Neningikarrawara-langwa Jirujalema-manja. Akwa narringa-makumakama warnumamalya-manja yakwujina Neningikarrawara-langwa ayakwa. Umba eneja nungwadikba ngala-langwa Benyuwela wurruwurrakuwilyaba-langwa warnumamalya warnimikirra Ajera. Dakine-ka dadiyuwangkwa 84 mamarika iya yinungkwura ying-ambilyumurra arakba. Arakba-wiya neni-yakeyinumurra wunalakina neningiyadikba mamangbala mambilyuma mamarika iya yinungkwura biya ni-jungwuma nakina neningiyadikba ngala-langwa. Kembirra dadinungkwurakba arakba ying-ambilyumurra dingaya dakina. Dakine-ka dadiyuwangkwa nara kingi-lalika Neningikarrawara-langwa angalya umba meningilida iya alyarrngwalyilya yingini-yangmarngkwajuwama dakina Neningikarrawara. Akwali-yada ying-alyubarinumurra aninga akena akwali-yada nara king-alyubarina aninga umba murumureya ngawa ying-ambilyumurra, yimbukwa yingi-yengbiyengbinuma ayakwa Neningikarrawaru-wa dakina. ");
INSERT INTO aoi_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Biya nabuk-ambilyu-wiya ambaka Jawijiba akwa Meri akwa Jesus yakwujina Neningikarrawara-langwa-manja angalya Jirujalema-manja wurrubukalakina, dibina-murrada dadiyuwangkwa yingi-likenuma dakina nabuk-ambilyu-murruwa wurrubukalakina. Biya yingini-rringka-manja nakina nangariya, kembirra yingini-yangmarngkwajuwa arakba dakina Neningikarrawaru-wa ni-rukwularrinu-mulangwa nakina niyukwujiya. Kembirra yadikina yingi-yengbina arakba dakina ayakwa ena-langwa-langwa. Narringa-makumakamurra dakina ena-langwa-langwa warnumamalya-manja wurrumurndakibina nuw-embimbirrarinu-murrumanja wurrakina Neningikarrawara ken-enjungwurrena-murruwa nakina WarningiJirujalema warnumamalya. ");
INSERT INTO aoi_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Aburnaja Jawijiba akwa Meri neni-jerrukwama arakba amurndakibina neni-yama-mulangwa wunalakina Neningikarrawara-langwa-manja angalya Jirujalema-manja, nenumini-yarrkuwarakinu-mulangwa Neningikarrawara-langwu-wa ayakwa eningarumuruma-wa. Biya nabuki-lawurradina arakba wurrubukalakina Keliliyu-wa aburrubukwurra-langwu-wa angalya emikirra Nejirida. ");
INSERT INTO aoi_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Yakwujina kembirra akina-manja ngawa angalya n-arumidinumurra niyukwujiya Jesus nakina. Ambaka-langwa n-arumidinuma, ni-ngbudidinuma akwa num-arrubudidinuma ena-langwa mangma. Eneja Neningikarrawara nenu-werrungwur•dangume-ka nakina-manja akwa nu-manjikbudanguma ngawa neningangkawura enuwa-manja-da. ");
INSERT INTO aoi_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Aburraja wurruwurrakwulyumide-ka warnumamalya WarningiYijireyila nawurraki-likenuma Jirujalemu-wa wurrakina arngkababurna-langwa na-jerridinu-manja akilarrkumurndada yakwujina. Namurndaki-likenumurra kajungwa warnik-ambarringi-yada wurrakina Akwurungkuwarrukwa yakwujina. Aburnajukwaba ngawa Jawijiba akwa Meri nen-alilikenuma Jirujalemu-wa akinu-wa wunalakina. ");
INSERT INTO aoi_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Bi...ya n-ambilyumurra arakba eneja Jesus mememberrkwa mambilyuma mamarika iya yinungkwura. Kembirra enejukwaba nenu-wilyakamurra wunalakina Jawijiba akwa Meri Jirujalemu-wa Akwurungkuwarrukwu-wa wunalakina. Biya kembirra nabuki-likena nabuk-ambarringa wurrubukalakina Akwurungkuwarrukwa akwa ngawa wurruwurrakwulyumida WarningiJudiya warnumamalya aburrajukwaba. ");
INSERT INTO aoi_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Biya na-jerridu-manja Akwurungkuwarrukwa ebina, neni-lalika Jawijiba akwa Meri Jirujalema umba neni-lawurradinuma wunalakina angalyu-wa Nejiridu-wa. Aburrajukwaba wurrababurne-ka ngawa warnumamalya aburra-langwa namurndaki-likenuma aburruwa wurrakina. Umba eneja nakina Jesus n-ambilya ngawa yakwujina Jirujalema-manja. Akena wuneningbala-kiya wunalakina Jawijiba akwa Meri n-ambilyumurra nakina Jesus yakwujina-wiya. ");
INSERT INTO aoi_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Wurrukwala-manji-kba ni-likenume-ka nakina, neni-lyangkiyamamurra wunalakina. Biya nen-alilikenuma wunalakina memerrkuwilyaba mamawura, biya nen-andeya akena nara nibina Jesus kini-likena aburruwa-manja. Biya kembirra narramurndaki-yendabena wurrumurndakibina warnumamalya yakwujina aburruwa na-likenuma keni-rringka-murrikba Jesus. ");
INSERT INTO aoi_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Akena aburraja nara keni-rringka umba nuw-edirremeyina wurrakina-da. Kembirra wunalakina Jawijiba akwa Meri nen-abuburangkeyinu...wa. Nara ken-akburrangarna. Nenu-mungkwula. Wurdarriya-wiya. Akwa neni-lawurradina kembirra Jirujalemu-wa. Nen-alilikenu...wa. Yakwujina. Na-larrumur•da. Nenu-mungkwula. Wurdarriya-wiya. Kembirra nen-abuburangkeyina akina-manja angalya Jirujalema. Yakwujina mamurukwa-manja iya alikira-manja nen-aburangkeyinuma. ");
INSERT INTO aoi_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Biya kembirra neni-lawurrada wunalakina Neningikarrawara-langwu-wa angalya. Biya nen-akburranga arakba nakina Jesus wunalakina yakwujina ngawa Neningikarrawara-langwa-manja angalya-da. Eneja Jesus n-ambilyumurra nakina yakwujina ngawa, n-angmungmakwulaluma aburruwa warnikakakirumaka warnungkwarba Mawijija-langwa ayakwa. Na-lyelyimbukweyinuma wurrakina. Umba Jesus n-engkirrikenumurra ayakwa aburra-langwa akwa ngarningka neni-yendabenuma ayakwa nakina Jesus wurrumurndakakinu-wa warnikakakirumaka warnungkwarba. ");
INSERT INTO aoi_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Aburrajukwaba arrkala neni-yendabenumurra Jesus-uwa ayakwa. Biya nuw-engkirrikenu-manja wurrakina ayakwa ena-langwa, wurrababurna-langwa warnumamalya yakwujina nawurraki-yakikbijangeyinume-ka wurrakina akina-langwa ayakwa ni-yengbinu-murrilangwa Jesus, aringkawa-baba nakina akwa eningaba-baba ayakwa ni-lawurrakajuwama aburruwa-wa-da. ");
INSERT INTO aoi_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Aburnajukwaba Jawijiba akwa Meri neni-yakikbijangeyina angwurra wunalakina neni-rringka-mulangwa nakina n-angmungmakwulaluma wurrumurndakakina-manja warnikakakirumaka. Biya dirndenikba yingi-yama enuwa-wa, “Naburra, miyambena-burra nara ki-likena nungkuwa yinuwa-manja? Ngayuwa akwa nungwena yinu-mukwunakeyinumurra nungkuwa-wa yinalakena yin-abuburangkeyinuma nungkuwa-wa-da,” yingi-yama Meri-da. ");
INSERT INTO aoi_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Eneja ni-yama, “Miyambena-burra kin-aburangkeyinumurra kinalakina engka-manja angalya amurndakakina-manja? Yangkwurrangwa-maka adinuba-wiya yikini-likenumurra kinalakina. Yirrumin-aburangkama akena kineningbala-burra kinalakina ningi-lyangmurukweyinamurra ngayuwa yelakwa Nungwarrka-langwa-manja alikira?” ni-yama nakina Jesus-da. ");
INSERT INTO aoi_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Akena nara aburnaja kenu-mumiringka akina ayakwa ni-yengbinumurra nakina-da. ");
INSERT INTO aoi_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Eneja kembirra nu-warumajungwa arakba nakina Jesus akwa ni-lalika Jirujalema umba ni-lawurradina angalyu-wa Nejiridu-wa, aburrubukwurruwa Jawijiba akwa Meri. Biya yadikina-langwa Jesus nenumin-engkirrikenuma neningangkawura wunalakina-kiya-langwu-wa ayakwa yakwujina. Ngalaja Meri ying-engkingkirrikenuma dakina ngawa amurndakibinu-wa yingi-rringka-murruwa akwa ngawa ying-engkirrikenu-murruwa, yingu-wilyakama ngawa ngala-langwa-manja mangma-da. ");
INSERT INTO aoi_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Bi...ya eneja arakba Jesus n-arumidinuma. Mangma ena-langwa numu-ringbirradinuma makina. Eneja Neningikarrawara nenu-werrungwur•danguma enuwa-wa. Aburrajukwaba warnumamalya nenu-werrungwur•danguma enuwa-manja ngawa-da. ");
INSERT INTO aoi_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Akini-yada ngawa eneja nuwilyaba ningka nubungkawa naruma nenimikirra Daburiyeja n-ambilyumurra nakina Rawuma-manja. Nu-bungkawadinuma wurruwurrakwulyumida-manja warnumamalya engka-manja iya engka-manja angalya. Nu-bungkawadinumurra nakina nenungkwurakba, mememberrkwa mamangbala mamarika iya yinungkwura nu-bungkawadinuma. Umba eneja nuwilyaba niyukwujiya nubungkawa nenimikirra Bandiyija Balida nu-bungkawadinuma nakina wurrababurna-manja warnumamalya wurruminakina angalya Judiya. Umba eneja nuwilyaba ningka nenungkwarba nenimikirra Yerida nu-bungkawadinuma nakina wurrababurna-manja warnumamalya Keliliya-manja. Umba eneja nenikumarnjenikba Yerida-langwa nenimikirra Biliba nu-bungkawadinuma nakina alakina-kiya-manja angalya emikirra Yidiriya akwa ngawa Dirakinada-manja. Alakina-kiya angalya nuw-ambilyuma akwudangwa Keliliya. Umba ngarningka eneja nuwilyaba ningka nenungkwarba nenimikirra Leyijeniya nu-bungkawadinuma nakina warnumamalya-manja eminingka-manja angalya emikirra Abuleniya. ");
INSERT INTO aoi_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Akini-yada ngawa na-bungkawadinu-manja wurrumurndakakina wurrububungkawa amurndakakina-manja angalya eminiminingka, kembirra aburnaja wunambilyuma wunubungkawa-kiya wunaruma WunuMinida nen-ambilyumurra wunalakina Jirujalema-manja. Wunenimikirra wunalakina Enija akwa Kayubaja. Akini-yada ngawa eneja Jekaraya-langwa nenikuwenikba Janjana, nibina-murrada yirra-maka-murrada arakba ngayuwa, n-ambilyumurra nakina nara-murrumanja alikira. Engburingke-ka angalya. N-ambambilyumurra nakina ngawa yanda-langwa yakwujina ngawa ni-yengbinuma eneja Neningikarrawara amurndakenena ayakwa enuwa-wa. Eneja ni-yama Neningikarrawara, “Wurra-makina nungkwa-langwa-manja warnumamalya kabumini-yarrkuwarakina-mulangwa wurrakina nganyangwu-wa ayakwa arakba,” ni-yama. ");
INSERT INTO aoi_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","N-engkirrikenu-manja Janjana Neningikarrawara-langwa ayakwa, kembirra ni-dirrirnduma arakba adalyuma-wa nakina. Emikirra adalyuma Jardina. Biya engku-wa iya engku-wa angalya adalyuma-manja akwudangwa ni-likenumurra nakina nen-akakirumakamurra Neningikarrawara-langwa ayakwa warnumamalya-manja yakwujina. Ni-yama nakina aburruwa-wa, “Wurri-larrngkuwurriya arakba alarrngkilarrngkawarriya amurndakibina kirri-yama-murrilangwa, umba wunumini-yarrkuwarakina Neningikarrawara-langwa ayakwa arakba. Nganja kembirra ngayuwa ka-mingekingambajini-yada kirrakina, kajungwa wurrababurna-langwa warnumamalya kuw-eningmidini-yada wurrakina yikinumini-yarrkuwarakina-mulangwa Neningikarrawara-langwa ayakwa arakba kirrakina-da. Umba eneja Neningikarrawara yikenumini-yakuwabijiname-ka nakina amurndakibina awurruwurrariya kirri-yama-mulangwa-da,” ni-yama Janjana wurrumurndakibinu-wa warnumamalya-da. ");
INSERT INTO aoi_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Umba arakburakba-kiya-wiya eneja nuwilyaba nenungkwarba nenimikirra Ajaya n-ambilyuma nakina. Nenikumakumaka ayakwa nenumamalya Neningikarrawara-langwa nakina. Ni-yamama nakina Ajaya, “Nuwilyaba nenumamalya n-ardirdenama nakina alarrkingburingka-langwa angalya, nara-murrilangwa alikira. Enena kembirra ayakwa ena-langwa: ‘Nungkwurraja karna karnumamalya wurruma-ngekburakina arakba mamurukwa Nubungkawa-langwa. Mulikarrkidirrbure-ka yikuma-ngekburakinamurra mamurukwa kirrakina kajungwa neniki-liki-yada nakina makina-manja. ");
INSERT INTO aoi_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Wurri-lyangburrukwajina arakba ababurna-langwa angwurn•dikirra akwa ngarningka wurri-ngakburrukwajina angakarjiyinga angalya ababurna-langwa kajungwa angakbilyuwalyi-yada akina. Akwa mibina mamurukwa mulikarrkiyangkwuruwura yikuma-likarrkidirrburakinama kirrakina, umba mibina mulikarrmilumila yikume-kbilyuwalyakinama makina-da. ");
INSERT INTO aoi_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Aburraja warnumamalya kamurndak-eningmidiname-ka wurrakina Neningikarrawara ken-enibikina-mulangwa warnumamalya nakina-da!’ ni-yame-ka nakina nenumamalya.” Akina-bina ayakwa ni-yamama nakina Ajaya arakburakba-kiya-wiya. Umba amurndakakina ayakwa ena-langwa nuw-arrikarrijungwunuma Neningikarrawara-langwa-manja jurra. Nakina-bina Janjana nibina-murrada ngarraku-maka-mulangwa amurndakakina ayakwa. ");
INSERT INTO aoi_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Aburraja kembirra wurruwurrakwulyumida warnumamalya namurndaki-likenuma Janjanu-wa mena neni-ngayindangu-mubaba nakina neniku-mingekingambaji-yada wurrakina akina-manja akungwa. Akena ni-yama nakina aburruwa-wa, “Karniniyerriye-ka karna karnumamalya! Kirruwurrariya yingarna wuburra! Nara kirrakina a-lyumaduma akini-yada ngawa yikenu-banijumindena-manja Neningikarrawara nungkwurruwa-na! ");
INSERT INTO aoi_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","“Yikini-ngayindena-manja amandangwa Neningikarrawara nakina yiken-enibikinama nungkwurruwa karnumamalya, kembirra yiki-dirrburakajungwunama kirrakina aduwaba. Eningaba yiki-yaminama wuburra laka eka eningaba ebina nuw-arrangbinamurra amaninga eningaba. Eningaba yiki-yaminama kajungwa warnumamalya kuw-eningmidini-yada kirri-larrngkuwurrangu-mulangwa alarrngkawarriya. Umba nare-ka a-lyangkuwerribikajungwuma kirrakina, ‘Ngarningaba ngarna mena Aburiyama-baba numiranyungwa ngakwurra-langwa neningadinuba-wiya nakina.’ Nara e-yamama akina ayakwa umba w-engkirrikiya enenu-wa ayakwa ngarra-makina-murruwa aduwaba. Kini-ngayindena-manja eneja Neningikarrawara, kinu-kuwarrukwajinama nakina angwarnda amurndakenena nawurraku-murrkwulijeyina-murrumurra yelakwa ajiringka-manja akina. Amurndakakina-langwa-bina angwarnda kenumini-ngekburakinama nakina Neningikarrawara warijira-da Aburiyama-langwa-da. ");
INSERT INTO aoi_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","“W-engkirrikiya! Neningikarrawara kini-lyangkuwerribikajungwunama nakina karnumamalya-langwa karningaba-murrikba akwa kirruwurrariya-murrikba kirrakina. Nakine-ka Neningikarrawara nu-war•denama ena-langwa warka wuburra laka nuwilyaba nenungkwarba ni-ridenama eka bangkilya-murra. Nakine-ka ni-ridenama ababurna-langwa eka eningeningaba-ma amurndakibina nara arrangbama aninga eningaba, akwa ni-ngkarrnginama amurndakakina eka eningeningaba-ma arrawa-langwa amukayerra-langwa. Akwa ngarningka nu-wurrenama amurndakakina angwura-wa ni-dakinama-da. Nakine-ka wuburra nenungkwarba kini-yaminama eneja Neningikarrawara akwa neniku-war•di-yada arakba nakina ena-langwa warka,” ni-yama Janjana wurrumurndakibinu-wa warnumamalya-da. ");
INSERT INTO aoi_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Aburraja kembirra namurndaki-yama, “Kardi! Yiki-yamarrkiname-ka yarna yarnumamalya?” ");
INSERT INTO aoi_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Eneja kembirra ni-yama Janjana aburruwa-wa, “Ka-makinama ngayuwa akwa enena yiki-yaminamurra nungkwurraja karna. Kirruwilyaba karnumamalya yikinga-wilyakina-manja dambilyuma dumbala dadingikarrawara karnik-awiyebi-yada kirrakina, kembirra yikinu-kwunamurra kirrakina duwilyaba nibinu-wa neningidumbala-murruwa nenumamalya. Umba kirruwilyaba yiku-wilyakina-manja aninga karnik-alyubari-yada kirrakina, yik-awurikeyinamurra kembirra akina aninga nibinu-wa neninganinga-murruwa nenumamalya,” ni-yama Janjana wurrumurndakakinu-wa warnumamalya. ");
INSERT INTO aoi_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Bi...ya aburraja kembirra wurrukwala warnumamalya narraminu-war•dangu-murrumurra warka WarningiRawuma wurrububungkawa namurndaki-likenumurra Janjanu-wa. Narruwurra-murndukwama angwarnda warnumamalya-langwa kajungwa warniku-kwi-yada akina WarningiRawumu-wa wurrububungkawa. Aburrajukwaba nawurraki-likenumurra Janjanu-wa kajungwa kenu-mingekingambajuwi-yada nakina aburruwa-manja. Biya namurndaki-yama wurrakina enuwa-wa, “Bungkawa, yirraja yiki-yamarrkinama yarna yarnumamalya?” ");
INSERT INTO aoi_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Eneja ni-yama Janjana, “Yikuwurra-murndukwuna-manja angwarnda, yiku-murnduwarnama akina wulkwa ebina bu-maka-mulangwa umba nara akwala,” ni-yama Janjana. ");
INSERT INTO aoi_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Aburraja wurrawinyamba warnungkwarba ne-yama enuwa-wa, “Umba yirraja, yiki-yamarrkinama yarna yarnumamalya?” Eneja ni-yama Janjana, “Kirrakine-ka kirr-akbar•duwakinama warnumamalya, kirra-ngajinama kajungwa yikabu-kwuni-yada angwarnda aburra-langwa. Akwa ngarningka kirra-lekbajamurra erribirra warningaba warnumamalya awurrariya-langwa, akena nara aburraja ke-yaminjamina akina umba warninguwurrariya-ma wurrakine-ka-da. Awurrariya akina, kembirra nara arakba e-yamama. Mama eyukwujiya angwarnda yiku-menamurra warka-langwa, nara a-ngwurrmiluma akina-langwa angwarnda eyukwujiya-langwa,” ni-yama Janjana wurrumurndakakina-manja warnungkwarba wurrawinyamba nakina-da. ");
INSERT INTO aoi_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Akini-yada ngawa aburraja wurrababurne-ka warnumamalya na-minandabumeyinumurra nawurraki-yendabijajungwunuma wurrakina nuw-engkirrikenu-mulangwa ayakwa Janjana-langwa. Biya kembirra namurndaki-lyangkiyama wurrakina, “Dukwa naka Janjana nibina-murrada nenungkwarba nenimikirra NuMejaya, nibina Neningikarrawara ni-yama-murrada neniki-larrka nakina yangkwurrangwa. Dukwa naka, dukwa nara-da,” namurndaki-lyangkiyama wurrakina-da. ");
INSERT INTO aoi_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Eneja kembirra Janjana ni-yama nakina aburruwa-wa, “Ngayuwe-ka ningena ngarra-mingekingambajinama kirrakina akungwa-murra aduwaba, umba nara akwala. Umba eneja nuwilyaba ningka nenungkwarba nubukwaya kini-likajama nakina arija-langwa. Naruma nilyengma nakina angwurra ngayuwa-manja. Nganja ki-yakuwerribikaja-manja ngayuwa ena-langwa-langwa, kembirra ningeningma ngayuwa ningiyukwujiya ningeningerribirra. Ngayuwe-ka ningeningeningaba-ma ningeniku-war•dinga-langwa ena-langwa warka akwa ningenik-aburawaka-langwa eningalika ena-langwa. Eneja kembirra kini-yar•diya-manja nakina nenungkwarba enena-manja angalya, kini-yaminama wuburra laka yikenu-mingekingambajinama Neningikarrawara-langwa-murra Amawurrina akwurdukwurda-murra akwa ngarningka angwura-murra nakina-da. ");
INSERT INTO aoi_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Nakine-ka nenungkwarba neniki-lyangkuwerribikajungwi-yada arakba karnumamalya-langwa karningaba-murrikba akwa kirruwurrariya-murrikba kirrakina. Akwa nenik-eyebijebaki-yada arakba nakina karnumamalya wuburra laka nuwilyaba nenumamalya ni-yaminama n-eyebijebakinama amadidira amaninga akwa amarda. Nakine-ka nuwurra-murndukwunama amurndakakina amadidira amaninga ena-langwu-wa alikira eninganinga-wa. Umba amarda awurrariya ni-dakinamurra angwura-wa nakina. Akine-ka wuburra ke-yaminama, akini-yada ngawa kini-likaja-manja yangkwurrangwa nenungkwarba nibina-langwa ngarra-maka-murrilangwa ngayuwa. Akena ngalaja akina angwura ena-langwa nara e-kakbujungwuma akina umba eningangkawura ka-dadinama-da,” ni-yama Janjana wurrumurndakibinu-wa warnumamalya-da. ");
INSERT INTO aoi_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Ni-yengbinume-ka nakina Janjana ababurne-ka ayakwa eminiminingka wurrumurndakakina-manja warnumamalya. Nenu-makama nakina eningaba ayakwa Neningikarrawara-langwa-langwa akwa nenu-werrikijiranguma angwurra wurrakina, kajungwa karri-larrngkuwurreni-yada alarrngkilarrngkawarriya umba kenumini-yarrkuwarakini-yada Neningikarrawara-langwa ayakwa wurrakina-da. ");
INSERT INTO aoi_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Biya ni-yengbinuma Janjana arrubuda ayakwa Yerida-manja enejukwaba. Nakine-ka Yerida nibina-murrada yirra-maka-murrada arakba ngayuwa nubungkawa Keliliya-langwa. Neni-lekbenumurra nakina mena nanga-manguma nenikumarnjenikba-langwa didarringka dadimikirra Yeridiyeja. Nanga-manguma dakina ena-langwi-yada dadingiyenikba, nara-wiya ambaka kini-jungwuna ngala-langwa neningiyadikba Biliba. Ababurne-ka eminiminingka awurruwurrariya ni-yamama ngarningka Yerida nakina. Aminakina-langwa eneja Janjana ni-yaminjamama nakina enuwa-wa, “Ningkuwurrariye-ka ningkilyengma ningkenumamalya,” ni-yama. ");
INSERT INTO aoi_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Akena eneja Yerida n-arriyakajungwunuma ngarningka awurrariya-wa. Ni-yama nakina ena-langwu-wa wurrawinyamba warnungkwarba, “Wunu-mena nakina Janjana akwa wuni-didena arakba akididijungwa-manja,” ni-yama. Kembirra nenu-manguma aburraja wurrakina akwa neni-didanga nakina-da. ");
INSERT INTO aoi_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Nara-wiya Janjana kini-didikajungwuna akididijungwa-manja nakina, eneja Jesus ni-likenuma Janjanu-wa. Eneja nenu-mingekingambajuwama Janjana Jesus-manja enamba-langwa arija-langwa. Umba nenu-mingekingambajuwa-mulangwa Janjana Jesus-manja, nu-buriyamina kembirra arakba Jesus Neningikarrawaru-wa. Umba nu-buriyaminu-wiya ngawa nakina Jesus, eneja Neningikarrawara nu-ngwurrkbalijuwama nakina angubina, ");
INSERT INTO aoi_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","akwa ni-larrkamurra nakina ena-langwa Amawurrina akwurdukwurda enuwa-wa. Akine-ka Amawurrina na-larrinuma angaluba Jesus-uwa. Darrawurukukwa wuburra akina, biya nuw-ambarringa enuwa-manja-da. Biya kembirra ne-yengbina arakba amayakwa angaluba karrawara-langwa akina. Ne-yama, “Ningkenikuwarrka nganyangwa ningkakina, ningkibina ningi-lyelyingminama ngayuwa akwa yirra-werrungwur•denama ningkakina-da,” ne-yama akina amayakwa-da. ");
INSERT INTO aoi_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","N-aburradadu-manja eneja nakina Jesus ena-langwa warka n-ambilyumurra arngkabiyakarbiya-ma arngkumemberrkwa mamarika iya yinungkwura nakina. Na-lyelyimbukweyinu-manja aburraja warnumamalya enuwa-langwa, ne-yama wurrakina, “Jesus-langwa nungwenikba Jawijiba nakina.” Akena Jawijibe-ka nen-arumurrkama wulkwa nakina Jesus. Umba Jawijiba-langwa nungwenikba nenimikirra Yileya nakina. ");
INSERT INTO aoi_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Umba Yileya-langwa nungwenikba Mededa nakina. Umba Mededa-langwa nungwenikba Libaya nakina. Umba Libaya-langwa nungwenikba Melkiya nakina. Umba Melkiya-langwa nungwenikba Jeneya nakina. Umba Jeneya-langwa nungwenikba Jawijiba nakina. ");
INSERT INTO aoi_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Umba Jawijiba-langwa nungwenikba Medidaya nakina. Umba Medidaya-langwa nungwenikba Emaja nakina. Umba Emaja-langwa nungwenikba Neyuma nakina. Umba Neyuma-langwa nungwenikba Ejiliya nakina. Umba Ejiliya-langwa nungwenikba Nakaya nakina. ");
INSERT INTO aoi_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Umba Nakaya-langwa nungwenikba Mayada nakina. Umba Mayada-langwa nungwenikba Medidaya nakina. Umba Medidaya-langwa nungwenikba Jemeyina nakina. Umba Jemeyina-langwa nungwenikba Jawijeka nakina. Umba Jawijeka-langwa nungwenikba Jawuda nakina. ");
INSERT INTO aoi_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Umba Jawuda-langwa nungwenikba Jawenina nakina. Umba Jawenina-langwa nungwenikba Reja nakina. Umba Reja-langwa nungwenikba Jarababela nakina. Umba Jarababela-langwa nungwenikba Jiyeldiyela nakina. Umba Jiyeldiyela-langwa nungwenikba Neraya nakina. ");
INSERT INTO aoi_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Umba Neraya-langwa nungwenikba Melkiya nakina. Umba Melkiya-langwa nungwenikba Adiya nakina. Umba Adiya-langwa nungwenikba Kawijama nakina. Umba Kawijama-langwa nungwenikba Elmadama nakina. Umba Elmadama-langwa nungwenikba Era nakina. ");
INSERT INTO aoi_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Umba Era-langwa nungwenikba Jajuwa nakina. Umba Jajuwa-langwa nungwenikba Eliyeyija nakina. Umba Eliyeyija-langwa nungwenikba Jawuruma nakina. Umba Jawuruma-langwa nungwenikba Mededa nakina. Umba Mededa-langwa nungwenikba Libaya nakina. ");
INSERT INTO aoi_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Umba Libaya-langwa nungwenikba Jimiyina nakina. Umba Jimiyina-langwa nungwenikba Juda nakina. Umba Juda-langwa nungwenikba Jawijiba nakina. Umba Jawijiba-langwa nungwenikba Jawunama nakina. Umba Jawunama-langwa nungwenikba Eliyakima nakina. ");
INSERT INTO aoi_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Umba Eliyakima-langwa nungwenikba Meliya nakina. Umba Meliya-langwa nungwenikba Mena nakina. Umba Mena-langwa nungwenikba Mededa nakina. Umba Mededa-langwa nungwenikba Nedina nakina. Umba Nedina-langwa nungwenikba Deyibida nakina. ");
INSERT INTO aoi_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Umba Deyibida-langwa nungwenikba Jeji nakina. Umba Jeji-langwa nungwenikba Abeda nakina. Umba Abeda-langwa nungwenikba Baweja nakina. Umba Baweja-langwa nungwenikba Jala nakina. Umba Jala-langwa nungwenikba Najena nakina. ");
INSERT INTO aoi_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Umba Najena-langwa nungwenikba Aminadaba nakina. Umba Aminadaba-langwa nungwenikba Adumina nakina. Umba Adumina-langwa nungwenikba Arni nakina. Umba Arni-langwa nungwenikba Yejirena nakina. Umba Yejirena-langwa nungwenikba Bereja nakina. Umba Bereja-langwa nungwenikba Juda nakina. ");
INSERT INTO aoi_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Umba Juda-langwa nungwenikba Jekaba nakina. Umba Jekaba-langwa nungwenikba Ajika nakina. Umba Ajika-langwa nungwenikba Aburiyama nakina. Umba Aburiyama-langwa nungwenikba Dera nakina. Umba Dera-langwa nungwenikba Neyawa nakina. ");
INSERT INTO aoi_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Umba Neyawa-langwa nungwenikba Jerukwa nakina. Umba Jerukwa-langwa nungwenikba Riyuwa nakina. Umba Riyuwa-langwa nungwenikba Beleka nakina. Umba Beleka-langwa nungwenikba Ebera nakina. Umba Ebera-langwa nungwenikba Jela nakina. ");
INSERT INTO aoi_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Umba Jela-langwa nungwenikba Keyinena nakina. Umba Keyinena-langwa nungwenikba Arbakijada nakina. Umba Arbakijada-langwa nungwenikba Jema nakina. Umba Jema-langwa nungwenikba Nawa nakina. Umba Nawa-langwa nungwenikba Lameka nakina. ");
INSERT INTO aoi_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Umba Lameka-langwa nungwenikba Midijela nakina. Umba Midijela-langwa nungwenikba Yinakwa nakina. Umba Yinakwa-langwa nungwenikba Jereda nakina. Umba Jereda-langwa nungwenikba Meyilelela nakina. Umba Meyilelela-langwa nungwenikba Kenena nakina. ");
INSERT INTO aoi_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Umba Kenena-langwa nungwenikba Yinaja nakina. Umba Yinaja-langwa nungwenikba Jeda nakina. Umba Jeda-langwa nungwenikba Eduma nakina. Umba Eduma-langwa nungwenikba Neningikarrawara nakina-da. ");
INSERT INTO aoi_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Eneja kembirra Jesus ni-lalikamurra arakba nakina ebina adalyuma EningiJardina. Ngalaja Neningikarrawara-langwa Amawurrina akwurdukwurda nenaki-lyangburrukwajuwama enuwa-manja. Biya ni-likena arakba nakina umba lukwakwa ngalaja Amawurrina Neningikarrawara-langwa nenaku-war•dikama akwa nenaku-wilyakama angerriba alarrkingburingka-wa angalya nara-murruwa alikira iya warnumamalya. ");
INSERT INTO aoi_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Umba eneja nakina Namukwa ni-likena Jesus-uwa akwa nenu-kwudirrka awurrariya-wa. Arngkabiyarbuwa-ma arngkumemberrkwa mamawura ni-yaminjamama nakina ngawa nenu-kwukwudirrkama Jesus awurrariya-wa n-ambilyu-wiya Jesus yakwujina nakwukawura. Eneja kembirra nu-mureyanguma angwurra nakina Jesus akwa ni-ngayindanguma arakba aninga, nara-baba kini-janga aninga n-ambilyu-manja nakina alarrkingburingka-manja angalya. ");
INSERT INTO aoi_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Eneja kembirra ni-yama enuwa-wa Namukwa, “Ningkakine-ka Neningikarrawara-langwa Ningkenikuwenikba-na? Kemba wu-warrukwajiya enena angwarnda kajungwa damba ka-ngekburakajungwuni-yada akina,” ni-yama. ");
INSERT INTO aoi_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Ni-yama Jesus enamba-langwa, “Neningikarrawara-langwa-manja jurra amurndakenena ayakwa nuw-arrikarrijungwunuma. Ne-yaminama, ‘Aninga yimbukwa nara akina enibikama warnumamalya wurrakina-da,’ ne-yaminama akina ayakwa-da,” ni-yama nakina Jesus-da. ");
INSERT INTO aoi_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Eneja kembirra arakba Namukwa nenu-wilyakamurra nakina Jesus karrawaru-wa angakarjiyinga-wa angalya. Biya warenja-bawiya nenu-wilyakajuwama nakina ababurna-langwa angalya amurndakibina-manja warnumamalya nuw-ambilyu-murrumanja wurrakina. Angerriba iya angerriba alyengma-langwa-langwa akwa engku-wa akwaburrangarnu-wa nenu-wilyakajuwama nakina Namukwa angalya Jesus-manja. ");
INSERT INTO aoi_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Biya ni-yama, “Yiba-kwunama ababurna-langwa eninginingaba amurndakangaba-manja angalya ababurna, akwa yiba-bungkawakinama amurndakangaba-manja ababurna-manja angalya. Nganyangwe-ka amurndakibina angalya iya amurndakijika ningki-rringkinama. Nganja ningubungkawa amandangwa ningena. Kembirra ki-ngayindena-manja ngayuwa, dukwa yiba-kwunamurra, dukwa ka-kwunama ngayuwa wurrukwala warnumamalya. ");
INSERT INTO aoi_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Umba yiki-yangmarngkwajina-manja ngayuwa ningkakina, kembirra ababurna-langwa amurndakakina nungkwa-langwa arakba-da,” ni-yama Namukwa Jesus-uwa-da. ");
INSERT INTO aoi_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Ni-yama Jesus enamba-langwa, “Arakburakba-kiya-wiya Mawijija nenu-makama amurndakenena ayakwa Neningikarrawara-langwa-manja warnumamalya. Ni-yamama, ‘Ningkakine-ka kini-yangmarngkwajinama Nubungkawa nibina nungkwa-langwa Neningikarrawara nakina, akwa kinuminu-war•denama wulkwa warka ena-langwa umba nara wurrukwala-langwa,’ ni-yamama nakina-da,” ni-yama Jesus Namukwu-wa-da. ");
INSERT INTO aoi_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Eneja kembirra nenu-wilyakamurra arakba Namukwa Jesus Neningikarrawara-langwu-wa angalya Jirujalemu-wa. Umba ngalaja na-ngwurrkwarrngajungwunuma akina angalya arumuruma-murra angwarnda. Biya nenu-wurdijuwama nakina Namukwa Jesus karrawara amurndakakina-manja angwarnda. Kembirra nen-andiyinga arakba wunalakina-kiya angerriba engku-wa ajiringka-wa. Ni-yama Namukwa Jesus-uwa, “Ningkakine-ka Neningikarrawara-langwa Ningkenikuwenikba-na? Kembirra ki-kbilyajajungwunama ningkakina arrawu-wa ajiringka-wa. ");
INSERT INTO aoi_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Neningikarrawara-langwa-manja jurra nuw-arrikarrijungwunuma amurndakenena ayakwa. Ne-yaminama, ‘Neningikarrawara kenu-makinama warnikumamurikaja ena-langwa akwa aburraja kab-akwurrajinama ningkakina. ");
INSERT INTO aoi_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Kabi-ngkajikinama ayarrka-murra wurrakina nari-yada a-ngajuma angwarnda nungkwa-langwa-manja alika,’ ne-yaminama akina ayakwa-da,” ni-yama Namukwa Jesus-uwa-da. ");
INSERT INTO aoi_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Ni-yama Jesus enamba-langwa Namukwu-wa, “Neningikarrawara-langwa-manja jurra nuw-arrikarrijungwunuma amurndakenena ayakwa ngalajukwaba. Ne-yaminama, ‘Nara kirrakina a-labuma Neningikarrawara neniki-yama-langwa ebina yikini-ngayindena-mulangwa,’ ne-yaminama akina,” ni-yama Jesus Namukwu-wa-da. ");
INSERT INTO aoi_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Eneja kembirra ni-yaminjamama nenu-kwukwudirrkama Namukwa Jesus-manja ngawu...wa. Bi...ya ni-yengminjada arakba nakina. Nara arakba kenu-kwudirrka, umba neni-lalika arakba nakina Jesus aduwaya yanda-langwa arngkingku-wa-da. ");
INSERT INTO aoi_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Eneja kembirra Jesus ni-lalika arakba akina angalya alarrkingburingka eningalikira-ma. Biya ni-lawurradina arakba nakina ebinu-wa aringbirra angalya Keliliyu-wa. N-alilikenu...wa. Biya ni-yar•da arakba Keliliya-manja. Umba ngalaja Neningikarrawara-langwa Amawurrina akwurdukwurda nenaki-ngbudirrkamurra akwa nenaku-war•dikama nakina-manja. Aburraja kembirra wurrababurna-langwa WarningiKeliliya warnumamalya narri-yarrumurnduwarnumurra ayakwa Jesus-langwa-langwa wurrakina. ");
INSERT INTO aoi_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Umba ni-likenu-manja nakina Jesus engku-wa iya engku-wa angalya nen-akakirumakama warnumamalya-manja Neningikarrawara-langwa ayakwa. Nen-akakirumakama nakina amurndakakina-manja alikira Neningikarrawara-langwa-manja emikirra jinikakwa. Aburraja wurrumurndakakina warnumamalya wurrababurna-langwa nenumurndaki-yangmarngkwajuwama Jesus-uwa arakba wurrakina-da. ");
INSERT INTO aoi_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Eneja kembirra Jesus ni-likena Nejiridu-wa, n-arumidinu-murruwa nakina. Biya makina-manja mamawura memikirra Jebuda ni-likena nakina jinikakwu-wa, mena akina ni-yaminjama-mubaba nakina Jesus ababurna-langwa Jebuda. Biya nawurrak-ambarringa-manja warnumamalya yakwujina jinikakwa-manja arrawa, Jesus n-arjiyinga. Biya ni-likena nakina amarru-wa kajungwa kini-ridimindeni-yada nakina Neningikarrawara-langwa ayakwa, ebina nuw-arrikarrijungwunuma jurra-manja, kajungwa kuw-engkirrikaji-yada wurrumurndakibina warnumamalya. ");
INSERT INTO aoi_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Eneja nuwilyaba nenikuminuwar•duwar•da nenu-kwa Jesus awilyaba jurra ebina nuw-ararikajungwunuma ebina-manja nuw-arrikarrijungwunu-murrumanja Ajaya-langwa ayakwa. Nakine-ka Ajaya nenikumakumaka ayakwa Neningikarrawara-langwa. Umba n-ambilyumurra nakina arakburakba-kiya-wiya. Eneja kembirra n-aburawaka Jesus ebina jurra, biya n-aburangka akwala ayakwa ni-ngayindanguma. Biya n-akburrangu-manja akina, ni-ridimindanga arakba nakina amurndakenena ayakwa wurrumurndakibina-manja warnumamalya. ");
INSERT INTO aoi_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Ni-yama Jesus, “Amawurrina Nubungkawa Neningikarrawara-langwa ngayuwa-manja nuw-ambilyama akina aduwaba. Ku-war•dikinama akina Amawurrina ngayuwa-manja, mena Neningikarrawara nu-wekbalyinu-mubaba ngayuwa. Nu-wekbalyinuma ngayuwa kajungwa ka-makini-yada ngayuwa ayakwa eningaba ena-langwa warningalyingmalyingma-wa warnumamalya. Neningikarrawara ngini-larrkama ngayuwa yangkwurrangwa kajungwa ka-makini-yada ngayuwa na-didijungwuna-murruwa warnumamalya keni-jadijina-murrilangwa Neningikarrawara wurrakina. Akwa ngarningka ngini-larrkama nakina yangkwurrangwa kajungwa ka-makini-yada ngayuwa wurrumimbumimbu-wa warnumamalya ayakwa kuw-andiya-mulangwa ngarningka menba wurrakina. Akwa ngarningka ngini-larrkama yangkwurrangwa nakina kajungwa k-enjungwurreni-yada ngayuwa warnumamalya, karramini-ngekburakina-mulangwa wurrukwala warnumamalya awurruwurrariya aburra-langwa. ");
INSERT INTO aoi_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Akwa ngarningka ngini-larrkama ngayuwa kajungwa ka-makini-yada warnumamalyu-wa ken-enibikina-mulangwa Nubungkawa Neningikarrawara ena-langwa warnumamalya aduwaba. Ena ngawa,” ni-yama Jesus. ");
INSERT INTO aoi_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Amurndakakina ayakwa ni-ridimindanga nakina Jesus. Biya ni-didanga n-aburamukwa ebina jurra, ni-lawurrakajuwa nibina nenikuminuwar•duwar•da nenu-kwamurra adinuba-wiya enuwa-wa, biya n-ambarringa nakina ayakwi-yada. Aburraja wurrababurna-langwa warnumamalya ebina-manja alikira neni-rruburringkama arakba wurrakina. ");
INSERT INTO aoi_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Umba ni-yama Jesus aburruwa-wa, “Aduwabe-ka amurndakakina ayakwa ningi-ridimindanguma ngayuwa, ebina nuw-arrikarrijungwunuma Neningikarrawara-langwa-manja jurra, na-lyangmandukwunadinume-ka akina, kirr-engkirrikenu-manja kirrakina karnumamalya memema-manja mamawura-da,” ni-yama Jesus nakina-da. ");
INSERT INTO aoi_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Aburraja wurrababurna-langwa warnumamalya nuw-engkirrikenu-murrumurra ayakwa Jesus-langwa na-makijeyina arakba ayakwa ena-langwa-langwa. “Eningaba amandangwa ayakwa ena-langwa,” namurndaki-yama, “akena Jawijiba-langwa nenikuwenikba nenaka-na?” ne-yama wurrakina. ");
INSERT INTO aoi_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Eneja ni-yama Jesus, “Ningeningma ngayuwa ayakwa yiki-yengbinama karna ngayuwa-wa. Yiki-yengbijinama amurndakenena ayakwa eningarakburakba-kiya. ‘Nungkwaje-ka ningkakina,’ yiki-yaminama ngayuwa-wa, ‘ningkakakiruma k-eningabakina-mulangwa warnumamalya, kembirra k-eningabakajungwuna nungkwabakiya-ba ningkakina-da,’ yiki-yaminama karna. Akwa ngarningka yiku-makinama nungkwurruwa ningeniki-yama-langwa ngayuwa yelakwa enena-manja angalya nganyangwa-manja ebina ningi-yamamurra Kabuniyuma-manja, kirr-engkirrikenu-mubaba karna ebina ningi-yamamurra yakwujina ngayuwa. ");
INSERT INTO aoi_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Akena nganja ngarra-makinama amandangwa enena. Nuwilyaba NuBurabuda, nibina nenikumakumaka Neningikarrawara-langwa ayakwa, kini-yengbina-manja nakina ayakwa ena-langwu-wa warnumamalya ena-langwa-manja angalya, kembirra aburraja ena-langwa warnumamalya nare-ka engkirrikuma wurrakina enuwa-wa,” ni-yama Jesus wurrumurndakibinu-wa warnumamalya. ");
INSERT INTO aoi_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Biya ni-yama ngarningka, “W-engkirraja enena ayakwa ningi-yengbinama nungkwurruwa-wa. Wi-yakuwerribikina Eliya-langwa. Arakburakba-kiya-wiya nakine-ka Eliya n-ambilyumurra Yijireyila-manja. Akini-yada ngalaja nara yibina yelyukwa kini-larrina ena-langwa-manja angalya. Abiyakarbiya-manja akilarrkelyukwa nara yibina yelyukwa. Nara kembirra ngalaja aninga ka-lungkuwarrina. Aburraje-ka murumureya nuw-ambilyumurra wurruminakina angalya warnumamalya. Umba wurrababurna wurridarringka wurringayingaya yakwujina nawurrak-ambilyuma akina-manja angalya. ");
INSERT INTO aoi_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Akena nara eneja Neningikarrawara keni-larrka Eliya wurruwurrakakinu-wa wurridarringka wurribina nuw-ambilyu-murruwa ena-langwa-manja angalya. Nara, umba neni-larrkama Neningikarrawara nakina Eliya eminingku-wa angalya Jayidinu-wa. Eneja kembirra ni-likena nakina angerriba Jayidinu-wa. Kembirra nanga-mamurikajuwama nakina duwilyaba dingaya yakwujina engemba-manja Jarubuda. ");
INSERT INTO aoi_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","“Akwa wi-yakuwerribikina ngarningka ningka-langwu-wa NuBurabuda Eliju-wa. Enejukwaba n-ambilyumurra nakina arakburakba-kiya-wiya Yijireyila-manja. Umba akini-yada ena-langwa-manja angalya aburraja wurrababurne-ka warnumamalya nuw-arrirreyinuma awurrakwulyumida amarmarra wurrakina. Akena nara eneja Elija kenuminu-mungkwur•danga warnumakwulya wurrumurndakakina-langwa warnumamalya ena-langwa. Nara, umba nenuminu-mungkwur•danga nenumakwulya Neyumena. Niminingka nakina Neyumena umba ena-langwa angalya Jiriya. Wi-yakuwerribikine-ka kembirra wunalakina-kiya-wa WunuBurabuda-kiya kirrakina-da,” ni-yama nakina Jesus wurruwurrakibinu-wa warnumamalya ebina-manja alikira jinikakwa-manja-da. ");
INSERT INTO aoi_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Aburraja kembirra awinyamba narrak-ar•darra wurrumurndakakina warnumamalya nuw-engkirrikenu-mulangwa ayakwa Jesus-langwa. Na-werrikardadinuma wurrakina angwurra, ");
INSERT INTO aoi_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","biya namurndaku-warumajungwa, neni-rndarrka nakina Jesus, neni-jadijuwa alikira-langwa, biya nenu-wilyaka yadikina errekbu-wa kajungwa warniki-lyikarrkuwurri-yada nakina abalkaya-langwa angakarjiyinga-langwa angalya arrawu-wa wurrakina-da. ");
INSERT INTO aoi_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Akena eneja Jesus ni-likena wurrilyimbilyimberrkuwilyarra-langwiya nakina, biya neni-lalika wurrumurndakakina warnumamalya arakba nakina-da. ");
INSERT INTO aoi_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Biya kembirra ni-likenumurra nakina Jesus engembu-wa Kabuniyumu-wa. Akine-ka angalya Kabuniyuma aminababurna alikira iya warnumamalya Keliliya-manja nuw-ambilyumurra. Biya Jebuda-manja ni-likenumurra Jesus jinikakwu-wa, nenu-wilyakajuwamurra nakina wurruminakina angalya warnumamalya Neningikarrawara-langwa ayakwa. ");
INSERT INTO aoi_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Aburraja wurrumurndakakina wurrababurna-langwa warnumamalya nuw-engkirrikenu-manja Jesus-langwa ayakwa, nawurraki-yakikbijangeyinume-ka wurrakina. Nawurraki-yakikbijangeyinuma wurrakina ni-yengbinu-mulangwa Jesus ayakwa engbingbuda-da, wuburra ne-yengbinama ayakwa wurrububungkawa-da. ");
INSERT INTO aoi_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Akina-manja angalya Kabuniyuma-manja n-ambilyumurra eneja nuwilyaba nenungkwarba, umba aburraja nuw-awiyebenuma wurruwilyaba wurramukwa wurruwurrariya enuwa-manja arrawa. Enejukwaba ni-likenuma jinikakwu-wa nakina nenungkwarba. Biya yakwujina jinikakwa-manja nu-warduwardemina angwurra nakina. ");
INSERT INTO aoi_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Kardi!” ni-yama. “Yi-lalika! Miyambena-burra ningki-likenuma yirruwa-wa nungkuwa ningkakina Jesus NingkeningiNejirida? Ningki-likenuma yangkwurrangwa ningkeniku-wardi-yada yirruwa-na! Ningeningme-ka nungkuwa ngayuwa. Ningkakine-ka ningkenumamalya ningkibina Neningikarrawara ngini-larrkama yangkwurrangwa-da!” ni-yama nakina. ");
INSERT INTO aoi_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Eneja Jesus ni-yama, “Wurri-yengminjada! Umba wurri-jadiya arakba enena-wiya nenaka-langwa nenungkwarba,” ni-yama. Aburraja wurrakina wurramukwa neni-kbilyaja nakina nenungkwarba ajiringka-wa wurruwurrakuwilyarra warnumamalya, akena nara kenu-wardanga nakina umba na-jadinga enuwa-langwa. ");
INSERT INTO aoi_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Aburraja wurrababurna-langwa warnumamalya yakwujina jinikakwa-manja namurndaki-yakikbijangeyine-ka. Biya na-makijeyinumurra wurrakina ayakwa. “Amiyambene-ka ayakwa amurndakeyena?” nawurraki-yama wurrakina. “Engbuda ayakwa ni-yengbinamurra naka nenungkwarba-na? Wuburre-ka naruma nubungkawa nu-bungkawadinama nakina wurramukwa-manja. Aburraja kembirra warna nenumin-engkirrikajama wurramukwa ena-langwa ayakwa-da akwa na-jadenama nenaka-langwa nenungkwarba-da,” ne-yama wurrakina. ");
INSERT INTO aoi_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Biya wurrumurndakakina warnumamalya arakba na-lawurradina aburra-langwu-wa angalya. Biya kembirra na-makijeyinumurra wurrakina Jesus-langwa-langwa, akwa narra-makamurra enuwa-langwa wurrukwala-manja warnumamalya yanda-langwa engka-manja iya engka-manja angalya Kabuniyuma-manja akwudangwa wurrababurne-ka warnumamalya namurndak-engkirrikenuma akina ayakwa ni-yama-murrilangwa Jesus, akwa nawurraku-makumakijeyinuma ngawa aburrajukwaba Jesus-langwa-da. ");
INSERT INTO aoi_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Kembirra enejukwaba Jesus ni-lalikamurra nakina ebina jinikakwa umba ni-likenuma numinakinu-wa alikira nenungkwarba nenimikirra Jayumuna. Biya n-awiyebena Jesus alikira-manja akwa nang-akburranga nakina duwilyaba didarringka arrawa dangbilyuwa-ma. Ngalaja Jayumuna-langwa dadijenikba dakina. Yingu-murrkumurrkwuluma yakwujina yingu-murndakardadinumurra angwurra dakina. Aburraja ngala-langwa warnumamalya nenu-makamurra Jesus-manja ngaluwa-langwa ying-angbilyuwadinu-mulangwa, kajungwa kining-eningabakini-yada nakina dakina-manja didarringka. ");
INSERT INTO aoi_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Eneja Jesus ni-lika yingu-murrkwulu-murruwa dakina, akwa n-arjiyinga akwudangwa ngaluwa-manja akwa ni-yengbina akwala ayakwa engbingbuda. “Nga-lalika arakba,” ni-yama akinu-wa angbilyuwa. Ngalaja kembirra akina-wiya yingu-warruwalyada arakba-da. Arngkawura-wiya ying-adingabada ying-ardadinu-murrada akwa yingu-mirajanga dakina. Biya narringamini-daka dakina aninga arakba-da. ");
INSERT INTO aoi_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Ngalaja kembirra num-awiyeba arakba mamawura. Aburraja kembirra wurrababurna warnumamalya namurndaki-likenumurra Jesus-uwa wurrakina. Narra-wilyakama enuwa-wa aburra-langwa warnumamalya wurrangbangbilyuwa-murra. Ababurne-ka angbilyuwa eminiminingka wurrakina narru-wilyakama. Umba eneja Jesus ni-lawulawaja ayarrka ena-langwa, neni-lyingama wurruwilyuwilyaba-wiya-manja akwa nenuwurrak-eningabakama wurrumurndakakina warnumamalya wurrababurna-langwa amurndakakina-langwa angbilyuwa-da. ");
INSERT INTO aoi_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Aburrajukwaba wurruwurrariya wurramukwa nuw-ambilyuma wurrababurna-manja warnumamalya, akena na-jadanguma narra-lalikama arakba wurrakina. Namurndaku-warduwardemina wurrakina akwa ne-yama Jesus-uwa, “Neningikarrawara-langwa Ningkenikuwenikba ningkakina-na!” Umba Jesus ni-yengbina ayakwa arrubuda aburruwa-wa. Nenuwurraki-yengminjakama wurrakina, warningma-baba Jesus NuMejaya nakina, nibina-murrada Neningikarrawara neni-larrka-murrada enenu-wa angalya-da. ");
INSERT INTO aoi_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Mingka-manja mamawura ne-kbadangu-manja akina, eneja Jesus ni-lalika Kabuniyuma umba ni-likena nakina nakwukawura nara-murruwa warnumamalya. Akena aburraja wurrumurndakibina warnumamalya nuw-aburangkeyinuma enuwa-wa arakba. Nuw-abuburangkeyinume-ka wurrumurndakakina. Biya nen-akburranga arakba. Neni-ngayindangumurra wurrakina nenik-ambilyingi-yada aburruwa-manja nakina Jesus. ");
INSERT INTO aoi_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Akena eneja ni-yama Jesus aburruwa-wa, “Ki-likajame-ka ningena akwalu-wa angalya eminiminingku-wa kajungwa ka-makini-yada ngayuwa wurrumurndakakina-manja warnumamalya aburrajukwaba eningaba ayakwa. Ka-makinamurra kinu-bungkawadina-mulangwa Neningikarrawara warnumamalya-manja. Ka-makinama akina ayakwa mena Neningikarrawara ngini-larrka-mubaba ngayuwa yangkwurrangwa kajungwa ka-makini-yada wurrababurna-manja warnumamalya wurriminiminingka kinu-bungkawadina-mulangwa nakina,” ni-yama Jesus aburruwa-wa-da. ");
INSERT INTO aoi_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Kembirra arakba neni-lalikama Jesus wurrumurndakibina warnumamalya umba ni-likenuma angerriba angalyu-wa iya angalyu-wa. Ni-likenumurra Neningikarrawara-langwu-wa alikira jinikakwu-wa biya yakwujina ni-yengbinuma nakina ayakwa Neningikarrawara-langwa, nenu-makamurra warnumamalya-manja nakina-da. ");
INSERT INTO aoi_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Arngkawura Jesus nakina n-arjijeyumurra mijiyelya-manja akina-manja angalya emikirra Kenejireda. Aruma akungwa nuw-ambilyuma yakwujina akina-manja angalya. Awilyaba-murra angalya akina umba aminambilyuma emikirra, alakina Kenejireda akwa ngawa Keliliya. Aburraja warnumamalya wurrakina yenjerrikina nawurraki-likenumurra Jesus-uwa warnik-engkirriki-yada ayakwa Neningikarrawara-langwa. Akena wurruwurrakwulyumide-ka yakwujina warnumamalya akwa kembirra nawurraki-jijiriyinumurra wurrakina. ");
INSERT INTO aoi_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Eneja Jesus numa-rringka mambilyuma-kiya mijiyanga numa-mundirruwajungwunuma yakwujina. Aburraja wurruminakina mijiyanga narruma-lalikama malakina umba narrum-ajirrangumurra mamurndakibina mukayuwa-ma merra makirndirndirrka akwalya. ");
INSERT INTO aoi_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Umba Jesus ni-rijawudija nakina muwilyaba-manja mijiyanga Jayumuna-langwa-manja, akwa ni-yama enuwa-wa, “Ma-jiriya-langwa angerriba arngkidarrba awarrngkungwarbu-wa akungwa,” ni-yama Jesus Jayumunu-wa. Eneja Jayumuna numa-jira kembirra makina mijiyanga-da. Akwa ngalaja numi-lyikbina arngkidarrba erribaja awarrngkungwarbu-wa-da. Eneja kembirra Jesus n-ambarringa arakba nakina mijiyanga-manja akwa ni-yengbina ayakwa wurrumurndakibinu-wa warnumamalya nuw-ambilyu-murruwa ariba-manja. Nen-akakirumakama nakina Neningikarrawara-langwa ayakwa. ");
INSERT INTO aoi_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Biya ni-jerrukwa-manja nakina ayakwa Jesus, ni-yama nakina Jayumunu-wa, “Ma-jiriya mema mijiyanga angerriba angwarbu-wa, kajungwa nungkuwa akwa nungkwa-langwa warnungkwarba yikuma-larrijini-yada mema mukayuwa, kembirra yiku-meni-yada akwalya,” ni-yama. ");
INSERT INTO aoi_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Eneja Jayumuna ni-yama Jesus-uwa, “Bungkawa, yarne-ka yirr-abuburangkeyinumurra alyarrngwalyilya akwalyu-wa akena nara yiku-manga yik-akburrangarna aduwaba. Mama, yikumini-ngayindena-manja nungkuwa ngayuwa, kuma-larrijinama kembirra mamurndakenena mukayuwa-da,” ni-yama Jayumuna Jesus-uwa-da. ");
INSERT INTO aoi_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Kembirra narruma-larrija mamurndakakina mukayuwa arakba-da. Ngalaja kembirra awurrakwulyumide-ka akwalya namurndak-awiyebena arakba mamurndakakina-manja mukayuwa, akena arngkidarrba kumi-ngkarrnginume-ka makina. ");
INSERT INTO aoi_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Biya kembirra narr-ardijuwa ayarrka-ma wurrakina wurribinu-wa warnungkwarba na-rijawudiyinu-murruwa mingka-manja mijiyanga, mena wurrumurndakakina warnungkwarba malakina-kiya-manja mijiyanga na-rijawudiyinuma warnubiyakaja wurrakina-baba. Kembirra Jayumuna-murriya narra-ngayindanguma wurrakina warniku-mamurikaji-yada warnik-arrki-yada amurndakibina akwalya narru-mangumurra mukayuwa-ma merra. Aburraja kembirra na-mideyina aburruwa-wa-da akwa narra-mamurikajuwa narrumamurndak-arrkarna mamurndakibina mukayuwa-ma merra-da. Biya malekbina-kiya mijiyanga narruma-lyangburrukwajuwa amurndakibina akwalya akwa arngkidarrba kumu-ngwardinumurra akwa kumu-wurrilanguma makina. ");
INSERT INTO aoi_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Eneja Jayumuna Bida ni-rringka-manja amurndakakina akwalya akwa numa-rringka-manja malakina mijiyanga-kiya kumu-ngwardinuma arngkidarrba, ni-nginakilarra nakina yina-ma alyengma-langwa Jesus n-arjeyu-murrumanja. Biya ni-yama, “Jeyi! Likaja yadada ngayuwa-langwa, Bungkawa, mena-baba ningena ninguwurrariye-ka,” ni-yama nakina Bida Jesus-uwa, ");
INSERT INTO aoi_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","mena ni-yakikbijangu-mubaba ni-rringka-murrilangwa amurndakibina akwalya awurrakwulyumida. Aburrajukwaba wurrumurndakibina warnungkwarba na-rijawudiyinuma yakwujina Jayumuna Bida-langwa-manja mijiyanga ne-yakikbijangeyinume-ka wurrakina amurndakibina-langwa akwalya narru-mangu-murrilangwa. ");
INSERT INTO aoi_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Aburnajukwaba Jaminja akwa Janjana neni-rijawudiyinumurra mingka-manja mijiyanga neni-yakikbijanginuma wunalakina-da. Wunalakina wunenungkwarba-kiya Jebediya-langwa nenikuwenikba-kiya. Jayumuna Bida-langwa warnubiyakaja wunalakina ne-yakiyakeyinuma-da. Eneja kembirra Jesus ni-yama nakina Jayumunu-wa, “Nara akbar•duma, umba aduwaba-langwa ka-wilyakinama nungkuwa warnumamalya ngayuwa-wa, wuburra laka aduwaba ningku-wilyakinama akwalya ariba-wa-da,” ni-yama Jesus-da. ");
INSERT INTO aoi_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Aburraja kembirra narrumalirraku-mundirruwa mijiyanga malekbina mijiyelya-manja akwa narruma-lalika yakwujina akwa akwala-langwa amurndakijika aburra-langwa, akwa kembirra neni-yuwarna Jesus-uwa arakba wurrakina-da. ");
INSERT INTO aoi_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Arngkawura eneja Jesus n-ambilyumurra nakina awilyaba-manja angalya n-ambilyu-murrumanja nuwilyaba nenungkwarba nibina n-arrirreyinuma awurrakwulyumida amarmarra ena-langwa-manja nenumakwulya. Arrubude-ka angbilyuwa akina. Eneja kembirra neni-rringka-manja nakina Jesus, n-abuluwendingama nakina nenungkwarba n-engmidirruwajungwunuma nenumukwurra ajiringka-wa akwa nenu-marrakbakama nakina Jesus-uwa akwa ni-yama, “Ningkubungkawa ningkukwulyubena,” ni-yama. “Ki-ngayindena-manja ningkakina ningkeningma yiku-mungkwur•denama ningenumakwulya,” ni-yama nakina Jesus-uwa. ");
INSERT INTO aoi_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Eneja kembirra Jesus ni-lawulawaja ayarrka ena-langwa akwa nenu-minjirrkilyinga arakba nakina nenungkwarba. Biya ni-yama, “Yirra-ngayindenama ningena yib-eningabakinamurra-da, kembirra nungkwaja ningkumungkwur•da ningkenumakwulya k-ambilyama ningkakina-da,” ni-yama Jesus. Kembirra arngkawura-wiya ayakwa ni-yengbinu-wiya nakina, akini-yada ngawa ne-jerrida arakba ngalaja amurndakibina amarmarra ena-langwa-da. ");
INSERT INTO aoi_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Biya ni-yama Jesus enuwa-wa, “Nara a-makama wurrukwala-manja warnumamalya ningk-eningabadu-mulangwa, umba jeyi, likaja ena-wiya dirrbura NuMinida-wa nenungkwarba. Kembirra nakine-ka keni-rringkinama ningkakina, biya kini-yaminama nungkuwa-wa, ‘Ningk-eningabaduma arakba,’ kini-yaminama nakina nenungkwarba NuMinida. Nungkwaja kembirra ambaka kinu-kwunama nungkuwa wurrambilyuma wurrajija kajungwa nenikuminu-wardi-yada nakina, ebina-langwiya ayakwa ni-yengbinu-mulangwiya Mawijija arakburakba-kiya-wiya. Kembirra aburramba-langwa wurrangkwulyumida-langwa warnumamalya kuw-eningmidinamurra nungkuwa ningk-eningabadu-murrilangwa akwa ningkuminjirrkinyungwurra arakba ningkakina-da,” ni-yama Jesus nakinu-wa nenungkwarba-da. ");
INSERT INTO aoi_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Akena eneja ni-yarrkbalijuwama nakina akina ayakwa ni-yama-mulangwa Jesus. Ngalaja kembirra nuw-errbalinuma akina ayakwa angwurra angalyu-wa iya angalyu-wa-da. Aburraja kembirra wurruwurrakwulyumida-langwe-ka warnumamalya nawurraki-likenumurra Jesus-uwa. Nawurraki-likenuma wurrakina kajungwa kuw-engkirrikaji-yada ayakwa ena-langwa akwa ngawa kenumurndak-eningabakini-yada nakina Jesus wurrakina warnumamalya wurribina wurrangbangbilyuwa-murrumurra angbilyuwa-langwa. ");
INSERT INTO aoi_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Akena adadinuba ngawa ni-likenuma eneja Jesus nakwukawura nara-murruwa warnumamalya, akwa nu-buriyaminumurra yakwujina Neningikarrawaru-wa nakina. ");
INSERT INTO aoi_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Arngkawura Jesus n-ambilyumurra nakina nuwilyaba-manja nenungkwarba ena-langwa-manja alikira. N-ambilyu-manja nakina yakwujina ngawa akina-manja alikira, aburraja wurrukwala warnumamalya na-likenuma yenjerrikina enuwa-wa. Umba Jesus nen-akakirumakama nakina wurrakina-manja warnumamalya Neningikarrawara-langwa-langwa. Aburrajukwaba na-likenuma Jesus-uwa wurrukwala WarningiJudiya warnungkwarba warnimikirra WurruBarija akwa ngawa wurrukwala warnikakakirumaka warnungkwarba ayakwa eningarumuruma Mawijija-langwa. Wurrakine-ka warnungkwarba na-likenumurra engka-langwa iya engka-langwa angalya Judiya-langwa akwa ngarningka Keliliya-langwa. Wurrukwala aburrajukwaba Jirujalema-langwa na-likenuma. Biya nuw-ambarringa ebina-manja alikira n-ambilyu-murrumanja Jesus nakina. Umba ngalaja Amawurrina Nubungkawa Neningikarrawara-langwa Jesus-manja nuw-ambilyumurra akina akwa nenaki-ngbudirrkama. Eneja nen-eningabakama kembirra Jesus wurrangbangbilyuwa-ma warnumamalya yakwujina alikira-manja arrawa. ");
INSERT INTO aoi_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Aburraja wurrukwala warnungkwarba na-likenumurra akinu-wa alikira, neni-lyilyanguma nuwilyaba nirrengmurnirna nenungkwarba. Neni-ngkajikamurra nakina, nenu-wilyakama akumurrkumurrkwulinga-murra, mena nara-baba kin-alilikena yeya, nara kinu-warruwarrina nakina-baba. Numurndakayuwaya neningangkawura n-ambilyumurra nakina. Kembirra ebina-manja alikira nuw-aburangkama angalya wurrakina warnungkwarba kajungwa warnik-awiyebi-yada akwa warnik-akumi-yada nibina nirrengmurnirna akwudangwa Jesus-manja. Nuw-aburangkeyinu...wa. ");
INSERT INTO aoi_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Akena nara karr-akburrangarna angwurn•dikirra, nara kuw-awiyebeyina arrawu-wa mena wurrababurna-baba warnumamalya nuw-ambilyuma yakwujina. Biya kembirra na-wurdanga wurrakina karrawaru-wa errekba-langwiya, nenu-wilyakamurra ngawa neni-ngkajikama nakina nirrengmurnirna. Biya yakwujina ngawa alikira-manja karrawara narru-ngwurrkbalijuwa wurrakina eningikarrawara edirri-yada. Biya neni-larrija merra-murra nibina nenungkwarba nirrengmurnirna yadikina akina-langwa edirra. Neni-larrija, biya ajiringka-manja nuw-ambarringa ebina akumurrkumurrkwulinga wurruwurrakuwilyarra warnumamalya-da. Aburnaja kembirra arakba nakina nirrengmurnirna akwa Jesus nenu-kwurukweyinuma wunalakina-da. ");
INSERT INTO aoi_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Umba wurrakine-ka warnungkwarba wurribina nenu-wilyakama nakina nirrengmurnirna Jesus-uwa na-werrikambilyumurra wurrakina Jesus-manja akwa warningma Jesus ken-eningabakina-mulangwa nakina-manja. Eneja Jesus neningma mangma aburra-langwa akwa ni-yama nakina nibinu-wa nirrengmurnirna, “Nungkuwa, ababurna-langwa awurruwurrariya ningki-yama-murrilangwa ningkakina ningkumini-lyurrkwajungwunuma arakba akina. Kembirra eneja Neningikarrawara nara nakina engkirrikuma arakba akinu-wa aduwaba-da,” ni-yama Jesus enuwa-wa-da. ");
INSERT INTO aoi_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Aburraja warnungkwarba warnikakakirumaka ayakwa eningarumuruma Mawijija-langwa akwa ngawa wurribina WurruBarija warnungkwarba na-lyangkiyama wurrakina, “Numiyambene-ka naka nenungkwarba? Ni-ngayindenama kini-yaminama Neningikarrawara wuburra naka-na? Eneja Neningikarrawara nuwilyaba akenumini-yakuwabijinama awurruwurrariya ngakwurra-langwa, nara wurrukwala amini-yakuwabijuma-da,” ne-yama wurrakina-da. ");
INSERT INTO aoi_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Neningma eneja Jesus aburra-langwa mangma, biya ni-yama aburruwa-wa, “Miyambena-burra kirr-engkirrikajamurra karna amukwiyadakinu-wa? ");
INSERT INTO aoi_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Nungkwaja ningkakina kinu-makina dukwa enena ayakwa naka-manja nenungkwarba, ‘Nginumini-yakuwabijuwama Neningikarrawara awurruwurrariya ningki-yama-murrilangwa ningkakina.’ Nare-ka ningkakina-da! Umba kinu-makina dukwa enena engka ayakwa enuwa-wa, ‘Laka! Mirajanga, akwa wu-warrijiya alika nungkwa-langwa.’ Nare-ka ningkakina-da! Ningki-lyangmuridiname-ka akwa nara e-yengbuma alakena-kiya ayakwa ningkabakiya-ba naka-manja nenungkwarba ningkakina-da. ");
INSERT INTO aoi_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Umba nganje-ka ningena, ningibina-murrada ningi-rukwularrinuma enena-manja angalya, eneja Neningikarrawara nginu-makama ngayuwa-manja kamini-yakuwabijina-mulangwa awurruwurrariya karnumamalya-langwa ngayuwa. Nganja kembirra kamin-abilyerrikinama aduwaba alyangmandukwuna akina ayakwa Neningikarrawara nginu-makama nakina ngayuwa-manja-da,” ni-yama Jesus wurrumurndakibinu-wa warnumamalya-da. Biya kembirra Jesus ni-yengbina arakba nakina akwala ayakwa nakinu-wa nenungkwarba nirrengmurnirnu-wa. Ni-yama, “Nungkwaja, mirajanga! Wu-larrngkumiya ena akumurrkumurrkwulinga nungkwa-langwa umba likaja lawurradina angalyu-wa,” ni-yama Jesus enuwa-wa-da. ");
INSERT INTO aoi_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Kembirra arngkawura-wiya eneja nu-mirajanga, ni-larrngkumanga ebina akumurrkumurrkwulinga ena-langwa. Aburraja wurrababurna-langwa warnumamalya yakwujina neni-rringkama n-arjeyuma arakba. Umba ni-jadinga nakina alikira-langwa errekbu-wa, nu-wilyakama ebina akumurrkumurrkwulinga ena-langwa-da. Biya ni-lawurradina arakba angalyu-wa, neni-yangmarngkwajuwamurra Neningikarrawaru-wa lukwakwa-da. ");
INSERT INTO aoi_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Aburraja wurrababurna-langwa warnumamalya yakwujina namurndaki-yakikbijangeyinume-ka akwa namurndak-akbar•dangumurra akina-langwa wurrakina. Biya neni-yangmarngkwajuwamurra arakba aburrajukwaba Neningikarrawaru-wa. Biya namurndaku-makijeyinumurra ayakwa. Ne-yama, “Amandangwe-ka, ngarri-rringkama eningaba ngakwurra-langwa-murra menba aduwaba-da,” ne-yama na-makijeyinuma wurrumurndakakina warnumamalya-da. ");
INSERT INTO aoi_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Eneja kembirra nen-eningabaka-mulangwa Jesus nibina nirrengmurnirna nenungkwarba akwa nenumini-yakuwabijuwa-mulangwa awurruwurrariya ena-langwa, ni-jadanga nakina ebina-langwa alikira. Biya ni-likenu-manja nakina lukwakwa Jesus, nen-akburranga nakina nuwilyaba nenungkwarba nenimikirra Libaya. Numinambilyuma ekirra nakina, Libaya akwa ngawa Meduwa. Umba nakina Libaya nenuminu-war•duwar•danguma warka wurrububungkawa WarningiRawuma. Ngalaja eyukwujiya alikira warka-langwa nuw-arjeyumurra akina ena-langwa mulikarrkbidjina mamurukwa. Kembirra nakina Libaya nuwurra-murndukwamurra angwarnda warnumamalya-langwa, akini-yada ngawa na-likenu-manja wurrakina mamurukwa-langwiya. Narri-yarruwarnu-manja akina alikira eyukwujiya, kembirra nenuminu-mangumurra angwarnda aburra-langwa kajungwa neniku-kwi-yada akina WarningiRawumu-wa wurrububungkawa. Ni-likenu-manja eneja Jesus mibina-langwiya ngawa mamurukwa, neni-rringka nakina Libaya n-angmakwulaluma ebina-manja eyukwujiya alikira arrawa. Biya Jesus ni-yama enuwa-wa, “Kwa, yi-yuwarna ngayuwa-manja,” ni-yama Jesus nakina-da. ");
INSERT INTO aoi_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Eneja kembirra Libaya n-arjiyinga akwa ni-jadinga errekbu-wa. Biya ni-likena arakba neni-yuwarna Jesus-manja. Ni-lalikame-ka ebina warka nu-war•duwar•dangumurra, kajungwa ken-aburrakiyuwarni-yada nakina Jesus-manja-da. Biya neni-likena arakba wunalakina-da. ");
INSERT INTO aoi_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Biya nakine-ka Libaya nenikaburrakiyuwa nenikaduwa Jesus-langwa arakba, akwa nenumini-dakama aninga Jesus-langwa ena-langwa-manja alikira. Arume-ka aninga ni-dakamurra. Kembirra na-walyuwa-manja akina, aburraja Jesus akwa ena-langwa wurrukwala warnikabuburrakiyuwa akwa wurrababurne-ka warnumamalya namurndaki-likenumurra Libaya-langwu-wa alikira wurrakina. Wurrukwala wurrababurna wurrumurndakakina warnumamalya na-war•duwar•danguma aburrajukwaba warka angwarnda-manja, wurrididirrbura Libaya adinuba-wiya, nara-wiya kini-likena nakina Jesus-uwa. Umba wurrukwala wurriminiminingka. Biya ne-yebukeyina arakba wurrakina ebina aninga-da. ");
INSERT INTO aoi_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Aburraja wurrukwala warnungkwarba WurruBarija akwa ngawa wurrukwala warnungkwarba warnikakakirumaka ayakwa eningarumuruma Mawijija-langwa warningma wurrakina ni-likenu-mulangwa Jesus Libaya-langwu-wa alikira. Biya kembirra na-ngwurriyengbeyinuma wurrakina ayakwa akwa ne-yama Jesus-langwu-wa warnikabuburrakiyuwa, “Miyambena-burra kirri-yebukeyinama aninga akwa kirri-bekeyinama akubibeka nakina-langwa-manja nenungkwarba alikira? Kirri-yebukeyinama karna akwa wurribina narruwurra-murndukwuna-murrumurra angwarnda wurrukwala-langwa warnumamalya-da. Wurruwurrariya-manja warnumamalya kirri-yebukeyinamurra karna-da!” ne-yama wurrakina-da. ");
INSERT INTO aoi_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Eneja Jesus n-engkirrika-manja nakina aburra-langwa ayakwa, ni-yama aburruwa-wa, “Wurrangbangbilyuwa-me-ka warnumamalya kuw-aburangkinamurra wurrakina nuwilyabu-wa nenungkwarba kajungwa ken-eningabakini-yada nakina angbilyuwa-langwa wurrakina. Umba aburraja wurringbingbuda warnumamalya nare-ka aburangkuma namukwiyadakinu-wa nenungkwarba wurrakina. ");
INSERT INTO aoi_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Umba nganja ningi-likenuma yangkwurrangwa kajungwa ka-dirrburakini-yada ngayuwa wurruwurrariya warnumamalya, kajungwa nari-yada wurrakina arriyakajungwuma awurruwurrariya-langwa umba kenumini-yarrkuwarakini-yada Neningikarrawara-langwu-wa ayakwa wurrakina-da. Ke-yamina-manja warnumamalya, ‘Nara arriyakajungwuma awurrariya-langwa ngayuwa umba ningena ngawa ningeningaba,’ kembirra nare-ka ngayuwa a-dirrburakuma wurramukwiyadakina warnumamalya, umba wurruwurrariya yimbukwa warnumamalya ka-dirrburakinama wulkwa ngayuwa-da,” ni-yama nakina Jesus wurrumurndakibinu-wa WurruBarija akwa ngawa wurrumurndakibinu-wa warnikakakirumaka ayakwa eningarumuruma Mawijija-langwa-da. ");
INSERT INTO aoi_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Aburraja kembirra wurrukwala warnumamalya ne-yama wurrakina Jesus-uwa, “Ningkeningma wurrumurndakibina warnikabuburrakiyuwa Janjana-langwa ne-yaminjaminama. Adadinube-ka murumureya na-likajama wurrakina, kajungwa ka-buriyamini-yada wurrakina Neningikarrawaru-wa. Aburrajukwaba warnikabuburrakiyuwa WurruBarija-langwa ne-yaminamurra wurrakina akina. Akena aburraja warnikabuburrakiyuwa nungkwa-langwa nara wurrakina e-yamama akina, umba erribirra nuw-alyubarinama aninga akwa ne-bekeyinama akubibeka wurrakina,” ne-yama wurrumurndakakina warnumamalya Jesus-uwa. ");
INSERT INTO aoi_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Eneja Jesus ni-yama aburruwa-wa, “W-engkirrikiya enena ayakwa. Kini-yar•diya-manja nuwilyaba nenungkwarba didarringka ena-langwa, kembirra wurrababurne-ka warnumamalya kawurra-murndukwunama wurrakina aburnuwa-manja kajungwa wurriyekirrerri-yada wurruwurrakawura-ma wurrakina. Akwa aninga eningaba ke-yebukeyinama. Kembirra nare-ka nungkuwa e-yengbuma enena ayakwa aburruwa-wa, ‘Nara alyubaruma enena aninga umba murumureya yiki-likajama.’ Nare-ka! Nara nungkuwa e-yengbuma amukwiyadakina ayakwa aburruwa-wa, mena wurrumurndakakina warnumamalya narri-ngayindena-mubaba ke-yebukeyinama ebina aninga eningaba, kin-ambilya-manja ambaka nibina nenumamalya aburra-langwa aburruwa-manja. ");
INSERT INTO aoi_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Ambaka arija-langwa, dukwa aburraja wurrukwala wurruwurrariya warnungkwarba kenu-wilyakinama engku-wa nibina ni-yar•danguma dadingiyenikba. Kembirra akini-yada wulkwa aburraja wurrumurndakibina warnumamalya ena-langwa ka-werrikawarriyadinama wurrakina-da. Karri-ngayindename-ka ka-ngwanjinama aninga-langwa, akwa ka-likajama murumureya wurrakina arakba-da,” ni-yama Jesus wurrumurndakibinu-wa warnumamalya. Umba n-engkirrikenuma nakina Jesus ena-langwa-langwa akwa ngawa ena-langwa-langwa warnikabuburrakiyuwa-da. ");
INSERT INTO aoi_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Biya kembirra Jesus nenu-makamurra enena eyukwujiya alawudawarra dumbala-langwa aburruwa-manja. Ni-yama nakina, “Nara ngarna e-ngkarrnguma ambilyumakuma dumbala dadikaduwa, kajungwa ngarniku-warrki-yada dikuwarra diyukwujiya dumbala dadingaba dingku-wa dumbala dadinungkwurakbu-wa. Nara akina e-yamama, nari-yada arriyakuma dibina dumbala dadikaduwa. Aki-yamina-manja akina, kembirra dibina dumbala dadikaduwa-dangwa kingu-kuwarrinama akwa ngawa diminingka dakina dadinungkwurakba-langwa dumbala arakba-da,” ni-yama Jesus wurrumurndakibinu-wa warnumamalya. ");
INSERT INTO aoi_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Biya kembirra enena engka ayakwa nenu-makamurra Jesus aburruwa-manja. Ni-yengbinuma nakina alawudawarra akwurena-langwa ebina warnumamalya narr-akbijuwa-mulangwa ke-bekini-yada ngala-langwa amalyirra wurrakina. Narri-jirabama wurrakina amalyirra akwurena-langwa amakwulya-murru-wa budila. Narri-lyangburrukwajuwama akina amakwulya amalyirra-ma akwa narri-lalikama akina ambaki-yada, kajungwa ke-bekini-yada arija-langwa ebina amalyirra-da. Kembirra akine-ka amalyirra amakwulya-manja nuw-ambambilyumurra ngawa yanda-langwa na-rrangkuwanginume-ka akina amalyirra. Aminakina-langwa narri-jirabama warnumamalya enikaduwa amalyirra engbudu-wa amakwulya enikaduwa-wa. Umba ka-rrangkuwangina-manja ebina amalyirra, kembirra ngalaja amakwulya ka-rrangkuwanginama ngalajukwaba akina. Kembirra ni-yama Jesus, “Nare-ka ngarrakina a-jirabuma enikaduwa amalyirra enungkwurakbu-wa amakwulya ebina na-rrangkuwanginu-murruwa arakba. Aki-yamina-manja akina, kembirra ka-rrangkuwangina-manja ebina amalyirra, kuw-akbalbarrinama-da ebina amakwulya-da, akwa ka-kwularrinama ebina amalyirra ajiringka-wa-da. ");
INSERT INTO aoi_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Nara kembirra e-yamama ngarnumamalya akina, umba enikaduwa amalyirra ngarri-jirabinama enikaduwa-wa amakwulya budila-da,” ni-yama nakina Jesus wurrumurndakibinu-wa warnumamalya-da. ");
INSERT INTO aoi_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Biya kembirra enena engka alawudawarra amalyirra-langwa nenu-makama Jesus aburruwa-manja. Ni-yama nakina, “Ebina amalyirra ngarra-maka-mulangwa ngayuwa, warnumamalya narri-lalalikinama akina kuw-enungkwurakbadina-murruwa. Na-warenama e-bekuma enikaduwa-wiya umba enungkwurakba-manja akina ne-bekinama. Kembirra ne-bekinu-mulangwa warnumamalya amalyirra enungkwurakba, na-warename-ka ebina enikaduwa-langwa. Ke-yaminamurra wurrakina, ‘Enungkwurakba-dangwa eningaba,’ ke-yaminamurra,” ni-yama Jesus, nenu-makama wurrumurndakibina-manja warnumamalya. Ni-yengbinu-manja nakina alawudawarra dumbala-langwa akwa ngawa amalyirra-langwa ni-yakuwerribikinuma nakina Jesus warnumamalya-langwa. Keni-yuwarna-manja enuwa-manja wurrakina, kembirra nare-ka a-likama wurrakina wurrumarngkambilyuma-da. ");
INSERT INTO aoi_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Ngalaja mamangbala mambilyuma mamawura makina memikirra Jebuda. Makina-manja mamawura aburraja wurrumurndakibina warnumamalya WarningiJudiya na-ngwanjinumurra wurrakina warka-langwa. Mababurna-langwa Jebuda ne-yaminjamama wurrakina WarningiJudiya warnumamalya. Nara ka-war•danga wurrakina warka, umba na-likenumurra Neningikarrawara-langwu-wa alikira jinikakwu-wa. Akwa neni-yangmarngkwajuwamurra yakwujina Neningikarrawara. Muwilyaba-manja Jebuda eneja nakina Jesus akwa ena-langwa warnikabuburrakiyuwa nawurraki-likenumurra yeya wurrakina. Biya nawurraki-likenuma wurrakina amarda-langwiya amaninga-langwiya. Awalyuwa arakba akina amaninga. Biya Jesus-langwa warnikabuburrakiyuwa narr-arrangbama lukwakwa akwala amadidira akwa ayarrka-murra na-mambajinuma akina. Kembirra awurrariya amarda narru-wurrangumurra umba amadidira eninginingaba nuw-alyubarinuma-da, na-ngwujalangumurra wurrakina-da. ");
INSERT INTO aoi_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Aburraja wurrukwala WurruBarija warnumamalya narra-rringkama wurrakina narr-arrangbama nuw-alyubarinuma akina aninga. Biya ne-yama aburruwa-wa, “Kirri-yamarrkiname-ka karna? Ngakwurra-langwa ayakwa eningarumuruma ngarraku-makinama akina, ‘Nara karningerribirra karnumamalya a-war•duma warka Jebuda-manja,’ ne-yaminama akina. Umba nungkwurraja karnumamalya kirru-war•denama karna warka yelakwa Jebuda-manja kirrakina-da. Kembirra kirri-yarrkuwurranguma arakba karna ebina ayakwa eningarumuruma-na? Awurrariye-ka enena kirri-yaminama kirrakina-da,” ne-yama wurrakina WurruBarija Jesus-langwu-wa warnikabuburrakiyuwa-da. ");
INSERT INTO aoi_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Eneja Jesus ni-yama aburrawa-wa, “Karningma ebina Deyibida ni-yama-murrilangwa arakburakba-kiya-wiya, nara-wiya kinu-bungkawadina nakina. Nu-mureyangumurra nakina akwa wurrukwala warnungkwarba ena-langwa. ");
INSERT INTO aoi_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Kembirra n-awiyebena nakina Deyibida Neningikarrawara-langwa-manja kalikwa. Biya nu-manga aninga damba akwa n-alyubarina. Biya nenu-kwa ekuwarra ena-langwu-wa warnungkwarba. Aburrajukwaba kembirra nuw-alyubarina-da. Mama akwurdukwurda akina, umba nuw-alyubarinuma wurrakina-da. Nara warningerribirra kuw-alyelyubarina warnumamalya akina aninga umba aburraja WurruMinida warnungkwarba yimbukwa nuw-alyelyubarinuma wulkwa-da. Akena eneja Deyibida n-alyubarinuma ebina aninga akwurdukwurda-da,” ni-yama Jesus wurrumurndakibina-manja WurruBarija warnungkwarba-da. ");
INSERT INTO aoi_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Biya ni-yama ngarningka aburruwa-wa nakina, “Ngayuwe-ka ningena, ningibina-murrada ningi-rukwularrinuma enena-manja angalya, Ningubungkawe-ka ngayuwa Jebuda-langwa ningena-da,” ni-yama Jesus-da. ");
INSERT INTO aoi_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Bi...ya meminingka-manja Jebuda ni-likenuma Jesus jinikakwu-wa. N-awiyebenuma nakina alikira-manja arrawa biya nen-akakirumakama yakwujina Neningikarrawara-langwa ayakwa wurrukwala-manja warnumamalya. Enejukwaba nuwilyaba nenungkwarba numinirrengmurnirna ayarrka n-angmakwulalumurra nakina yakwujina. Nara kinu-warrijuwa nakina ayarrka nekbuda-langwa-langwa. Eningangkawura na-murndakayuwayanguma akina. ");
INSERT INTO aoi_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Ebina-manja ngawa jinikakwa aburraja wurrukwala warnungkwarba warnikakakirumaka Mawijija-langwa ayakwa eningarumuruma nuw-ambilyumurra yakwujina akwa ngawa wurrukwala WurruBarija warnumamalya aburrajukwaba. Neni-rruburringkama wurrakina angwurra ngawa Jesus-uwa. Nuw-andeyuma enuwa-wa kenumin-eningabakina-murrikba nakina Jesus ayarrka nibina-langwa nenungkwarba, mena neni-ngayindanguma wurrakina warniki-lekbi-yada Jesus awurrariya-langwa. Kini-ngekburakina-manja Jesus ebina ayarrka akini-yada ngawa Jebuda-manja, kembirra keni-lekbajama Jesus-uwa wurrakina. Ke-yaminama enuwa-wa, “Awurrariye-ka akina mena aduwaba Jebuda-baba ena-da,” ke-yaminama wurrakina enuwa-wa-da. ");
INSERT INTO aoi_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Akena neningma eneja Jesus mangma aburra-langwa akwa ni-yama nakina nibinu-wa nenungkwarba, “Kwa, mirajanga, akwa likaja yangkwurrangwa amarru-wa,” ni-yama. Eneja kembirra nu-mirajanga, ni-lika nakina amarru-wa akwa n-arjiyingama Jesus-manja akwudangwa. ");
INSERT INTO aoi_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Umba kembirra ni-yama nakina Jesus wurrumurndakibinu-wa warnumamalya yakwujina nuw-angmakayanguma jinikakwa-manja arrawa, “Yirru-makina arakba,” ni-yama. “Ke-yamarrkinama ayakwa eningarumuruma Mawijija-langwa ngarniki-yama-langwa ngarna? Aki-yaminama ngakwurruwa eningaba Jebuda-manja yinda awurrariya? Umba ak-enibikinama ngarna warnumamalya yinda aka-jungwajinama?” ni-yama nakina Jesus aburruwa-wa. ");
INSERT INTO aoi_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Ni-yengbinuma Jesus amurndakakina ayakwa biya neni-rringkama nakina wurrumurndakibinu-wa warnumamalya wurruwilyuwilyaba-wiya-wa. Biya ni-yama nakina nibinu-wa nenungkwarba, “Wu-lawulawajiya ayarrka nungkwa-langwa,” ni-yama. Eneja kembirra nakina nenungkwarba ni-lawulawaja arakba ayarrka ena-langwa-da. Arrengmurnirna-murrada akena ne-ngbudida arakba-da. ");
INSERT INTO aoi_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Aburraja wurrakina awinyamba narrak-ar•darra wurrumurndakibina warnungkwarba warnikakakirumaka akwa aburrajukwaba WurruBarija warnungkwarba wurrakina. Na-lyelyimbukweyinumurra biya, “Aki-yamarrkinamurra ngarna naka-manja nenungkwarba?” ne-yama wurrakina-da. ");
INSERT INTO aoi_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Akini-yada kembirra eneja Jesus nu-wurdanguma angakarjiyinga-wa angalya nakwukawura, kajungwa kinu-buriyamini-yada nakina Neningikarrawaru-wa yakwujina. Nu-buburiyaminu...wa. Na-larrumur•da arakba. Nu-buburiyamina nakina ngawu...wa. Marngkirngkuwilyarra arakba. Ni-yaminjama ngawa nakina yanda-langwa ne-kbadanguma arakba akina. ");
INSERT INTO aoi_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Buwa-wiya. Kembirra nen-ardijuwa Jesus ena-langwa warnikabuburrakiyuwa enuwa-wa. Biya nu-wekbalyinuma nakina wurrumemberrkwa wurrambilyuma warnungkwarba. Biya neni-yengbijuwama nakina warnikilarrkilarrka warnungkwarba wurrakina, mena-baba ena-langwa warnikuminuwar•duwar•da wurrumurndakakina arakba, akwa ambaka-murra keni-larrkaja-mubaba nakina angerriba iya angerriba warniku-maki-yada wurrakina warnumamalya-manja Neningikarrawara-langwa-langwa. ");
INSERT INTO aoi_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Warna warnimikirra Jayumuna, nibina Jesus neni-yengbijuwama Bida, iya nenikumarnjenikba Endiruwa, iya Jaminja iya Janjana iya Biliba iya Badalameya ");
INSERT INTO aoi_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","iya Meduwa iya Damija iya Jaminja, nibina nenikuwenikba Albiyija-langwa nakina, akwa ngawa nuwilyaba ningka Jayumuna. Umba naka nenungkwarba Jayumuna akwa wurrukwala warnumamalya ena-langwa WarningiJudiya nuw-awinyambadinume-ka angwurra wurrakina mena WarningiRawuma warnumamalya narri-lyinga-mubaba aburra-langwa angalya Judiya. Aminakina-langwa kembirra ne-yengbijajungwunumurra wurrakina Jelada. Akina ekirra aburra-langwa. ");
INSERT INTO aoi_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Akwa wunambilyuma wunenungkwarba-kiya aburnajukwaba nu-wekbalyinuma Jesus wunenimikirra-kiya Judija. Nuwilyaba nenikuwenikba Jaminja-langwa nakina umba ningka-langwa Judija nenimikirra Yijikariyada, nibina kenu-wilyakinama wurrukwala wurrububungkawa Jesus-uwa kajungwa kenu-meni-yada nakina. ");
INSERT INTO aoi_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Biya kembirra Jesus akwa ngawa wurrumurndakibina warnungkwarba warnimikirra warnikilarrkilarrka akwa ngawa ena-langwa wurrukwala warnikabuburrakiyuwa nawurraki-dirrirnduma wurrakina yadikina karrawara-langwa angakbilyuwalyu-wa angalya. Biya nuw-akburranganja yakwujina wurrababurne-ka warnumamalya wurribina Jesus-langwa warnikabuburrakiyuwa aburrajukwaba wurrakina. Akwa ngarningka wurrababurne-ka warnumamalya wurriminiminingka aburrajukwaba nawurraki-likenumurra yenjerrikina eminiminingka-langwa angalya. Nawurraki-likenumurra engka-langwa iya engka-langwa angalya Judiya-langwa akwa ngawa Jirujalema-langwa. Akwa ngawa Daya-langwa akwa Jayidina-langwa namurndaki-likenumurra wurrukwala. Alakina-kiya angalya Daya akwa Jayidina alarrkumijiyelya-manja nuw-ambilyumurra alakina. ");
INSERT INTO aoi_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Nawurraki-likenume-ka wurrakina engka-langwa iya engka-langwa angalya nawurra-murndukwunuma kajungwa warnik-engkirriki-yada Jesus-langwu-wa ayakwa, akwa ngawa nenik-eningabaki-yada nakina Jesus wurribina wurrangbangbilyuwa-murra warnumamalya. Umba n-arjiyinga eneja Jesus yakwujina ebina-manja ngawa angalya angakbilyuwalya-manja. Ni-yengbinuma nakina aburruwa-manja ayakwa akwa ngarningka nen-eningabakamurra wurrakina angbilyuwa-langwa. Umba aburraja wurrukwala wurrumurndakakina na-werrikangbilyuwadinuma mena wurramukwa wurruwurrariya nuw-ambilyu-mubaba aburruwa-manja. Eneja Jesus kembirra nenumurndaki-jadijuwama wurrakina wurramukwa aburruwa-langwa. ");
INSERT INTO aoi_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Umba wurrababurna-langwa warnumamalya nenuwurraki-ngayindanguma kuw-akwudangwukajungwuni-yada Jesus-uwa kajungwa warniki-lyingi-yada nakina-manja wurrakina-da, mena nakina Neningikarrawara neni-ngbudirrkama Jesus-manja-da. Kembirra nen-eningabakama nakina wurrumurndakakina warnumamalya wurrababurna-langwa-da. ");
INSERT INTO aoi_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Biya kembirra Jesus nenuwurraki-rringkama nakina ena-langwu-wa warnikabuburrakiyuwa akwa ni-yengbinuma aburruwa-manja amurndakenena ayakwa nuw-engkirrikenu-murrumanja aburrajukwaba wurrukwala warnumamalya. Ni-yama Jesus, “Karningalyingmalyingma kirribina karnumamalya, eningabe-ka ka-ngekburakajungwunama nungkwurra-langwa, mena Neningikarrawara nu-bungkawadina-mubaba arakba nungkwurruwa-manja nakina. ");
INSERT INTO aoi_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Umba nungkwurraja kirru-mureyena-murrumurra aduwaba karnumamalya, eningabe-ka ka-ngekburakajungwunama nungkwurra-langwa nungkwurrajukwaba akina. Ambaka-murrumurra yiki-ladenama kirrakina. Umba nungkwurraja kirru-ngwadeyina-murrumurra aduwaba karnumamalya, eningabe-ka ka-ngekburakajungwunama nungkwurra-langwa nungkwurrajukwaba akina. Ambaka-murrumurra yiku-marngkinama kirrakina-da. ");
INSERT INTO aoi_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","“Mama wurrukwala warnumamalya yikabu-wirrikbinama wurrakina, umba eneja Neningikarrawara neningabe-ka nungkwurruwa-manja. Yikabu-wirrikbinama wurrakina, ka-warenama nungkwurruwa, akwa ke-yengbinama wurrakina ayarrkiyarrkawarriya ayakwa nungkwurruwa-wa akwa ke-yaminama nungkwurruwa-wa, ‘Karniniyerriya kirrakina karnumamalya,’ ke-yaminama wurrakina. Ke-yaminame-ka akina mena kirru-werrikambilya-mubaba nungkwurruwa karnumamalya ngayuwa-manja, ningibina-murrada ningi-rukwularrinuma enena-manja angalya. Mama akina umba nakine-ka Neningikarrawara neningabe-ka nungkwurruwa-manja. ");
INSERT INTO aoi_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Aburrajukwaba arakburakba-kiya-wiya aburra-langwa wurrumirumirarrngwa warningarakburakba-kiya narra-wirrikbama WurruBurabudu-wa warnumamalya wurribina nenumini-yengbiyengbinu-murruwa ayakwa Neningikarrawara-langwa wurrakina. Kembirra aduwaba yikabu-wirrikbina-manja warnumamalya warningaduwaba nungkwurruwa-wa, nungkwurraja yiku-werrikilyelyingmajungwunama kirrakina. Kini-ngwurrkbalinama yukwudukwuda nungkwurra-langwa mena Neningikarrawara yikenu-kwunama eninginingaba ena-langwa, akini-yada ngawa yiki-likaja-manja kirrakina ena-langwu-wa angalya eningabu-wa. ");
INSERT INTO aoi_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“Umba nungkwurraja kirruminababurna angwarnda iya amurndakijika, ka-ngekburakajungwuname-ka awurruwurrariya nungkwurra-langwa, mena kirru-wilyakiname-ka akina arakba alarrngekburna eninginingaba nungkwurra-langwa aduwaba. Kembirra nara akwala a-manguma nungkwurruwa. ");
INSERT INTO aoi_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Umba nungkwurraja kirri-ladena-murrumurra aduwaba karnumamalya, ka-ngekburakajungwuname-ka awurruwurrariya nungkwurra-langwa nungkwurrajukwaba. Ambaka-murrumurra yiku-mureyenama kirrakina. Umba nungkwurraja kirru-marngkina-murrumurra karnumamalya enubuwakida amarngka aduwaba, ka-ngekburakajungwuname-ka awurruwurrariya nungkwurra-langwa nungkwurrajukwaba. Ambaka-murrumurra yiki-jakawarenama-da yiku-ngwadeyinama kirrakina-da.” ");
INSERT INTO aoi_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","“Umba ke-yengbina-manja wurrababurna-langwa warnumamalya ayakwa eninginingaba nungkwurra-langwa-langwa, kembirra awurruwurrariye-ka ka-ngekburakajungwunama nungkwurra-langwa. Aburrajukwaba arakburakba-kiya-wiya aburra-langwa wurrumirumirarrngwa warningarakburakba-kiya ne-yaminjamamurra amukwiyadakina ayakwa wurrikikalyu-wa WurruBurabuda warnumamalya. Wurrumurndakakine-ka ngawa WurruBurabuda nara karra-makumaka warnumamalya-manja Neningikarrawara-langwa ayakwa, umba aburra-langwa ayakwa amurndakibina ekikalya-wiya ne-yengbinumurra wurrumurndakakinu-wa warnumamalya. Umba aburraja wurrababurna warnumamalya warningarakburakba-kiya-wiya ne-yengbiyengbeyinuma wurrakina eninginingaba ayakwa aburra-langwa-langwa. Kembirra aduwaba ke-yengbina-manja warnumamalya eninginingaba ayakwa nungkwurra-langwa-langwa, awurruwurrariye-ka ka-ngekburakajungwunama akina nungkwurra-langwa-da,” ni-yama Jesus ena-langwu-wa warnikabuburrakiyuwa nakina-da. ");
INSERT INTO aoi_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“W-engkirrikiya,” ni-yama ngarningka Jesus ena-langwu-wa warnikabuburrakiyuwa. “Enena ayakwa ngarra-makinama nungkwurruwa-manja, kirribina kirr-engkirrikaja-murrumanja ngayuwa-wa angwurra aduwaba mena-baba nungkwurra-langwa mada numu-ngwur•dangmina-mubaba amandangwa. Nungkwaja ki-lyelyingminame-ka ningkakina warnumamalya wurribina kabu-wirrikbina-murrumurra nungkuwa-wa. Ki-yaminame-ka eningaba wurrumurndakakina-manja warnumamalya. ");
INSERT INTO aoi_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Kabi-kbajina-manja wurrukwala warnumamalya nungkuwa, kembirra arrkala nungkwamba-langwa kini-yengkilabajama Neningikarrawaru-wa, kajungwa kini-yamini-yada nakina eningaba aburra-langwa. Umba wurrukwala wurrumarngilyarra warnumamalya kabu-larrkbarjena-manja ningkakina, akwa ke-yengbina-manja wurrakina ayakwa ayarrkawarriya nungkuwa-wa, kembirra arrkala nungkwamba-langwa kini-yengkilabajama Neningikarrawaru-wa, kajungwa kenu-mamurikajini-yada nakina aburruwa-manja. ");
INSERT INTO aoi_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","“Umba nuwilyaba nenumamalya keni-larrkbarjiya-manja ningkakina awilyaba-langwa amungkwurra, nara a-ngwanjajuma nakina, umba mama kini-lalikina keni-larrkbarjena nakina nungkuwa-manja ningkikuwarra-langwa ningkenumungkwurra. Umba kenu-murrakajiya-manja nuwilyaba nenumamalya dumbala nungkwa-langwa dibina dadikawiyeba dadingikarrawara, nara a-ngwanjajuma nakina nungkuwa, umba ngarningka kininga-mena dibina dumbala nungkwa-langwa dadikawiyeba dadingarrawa ngalajukwaba-da. ");
INSERT INTO aoi_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","“Umba kabi-yendabaja-manja warningerribirra warnumamalya nungkwa-langwa amurndakijika, kembirra nungkwaja ka-kwunama. Umba wurribina kabu-murrakajiya-manja amurndakijika nungkwa-langwa, kembirra nara a-larrngkilawurrakajuma amurndakakina. Mama nara a-lawurrakajuma amurndakakina wurrakina. ");
INSERT INTO aoi_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Umba nungkwaja ku-marngkirradiname-ka ningkakina wurrukwala-manja warnumamalya, wuburra laka ningkarra-ngayindenama wurrakina ka-marngkirradinama aburramba-langwa nungkuwa-manja-da. ");
INSERT INTO aoi_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Laka nara ningkakina a-lyelyingmama wurrababurna-manja warnumamalya umba ningki-lyelyingminama warnumamalya wulkwa wurribina na-lyelyingmina-murrumurra nungkuwa-manja? Eneja kembirra Neningikarrawara nara nakina e-yamama enena ayakwa nungkuwa-wa, ‘Yirra-werrungwur•denama ngayuwa nungkuwa-manja.’ Nara nakina e-yamama akina ayakwa nungkuwa-wa, mena aburrajukwaba wurruwurrariya warnumamalya na-lyelyingmajeyinama wurrakina. Na-lyelyingminama wurrakina warnumamalya wurribina aburramba-langwa na-lyelyingmina-murrumurra aburruwa-manja-da. ");
INSERT INTO aoi_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","“Umba laka nara ningkakina a-marngkirraduma wurrababurna-manja warnumamalya umba ki-yaminama nungkuwa eningaba warnumamalya-manja wulkwa wurribina ne-yamina-murrumanja nungkuwa-manja? Eneja kembirra Neningikarrawara nara e-yamama enena ayakwa nungkuwa-wa, ‘Yirra-werrungwur•denama ngayuwa nungkuwa-manja.’ Nare-ka, mena aburrajukwaba wurruwurrariya warnumamalya ne-yamina-mubaba wurrakina eningaba warnumamalya-manja wurribina ne-yamina-murrumanja aburramba-langwa eningaba aburruwa-manja. ");
INSERT INTO aoi_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","“Dukwa nungkwaja ka-kwunama amurndakijika nungkwa-langwa wurrukwala-manja warnumamalya warnik-akwurraji-yada akina aduwaya wurrakina warnumamalya. Akena nara wurrababurna-manja warnumamalya a-kwama nungkuwa nungkwa-langwa amurndakijika eningaduwaya, umba wurrumurndakibina-manja wulkwa warnumamalya wurribina kabumini-lawurrakajina-murrumanja wurrakina arija-langwa amurndakibina amurndakijika nungkwa-langwa. Eneja kembirra nakina Neningikarrawara nara e-yamama enena ayakwa nungkuwa-wa, ‘Yirra-werrungwur•denama ngayuwa nungkuwa-manja.’ Nare-ka, mena aburrajukwaba wurruwurrariya warnumamalya na-kweyina-murrubaba eningaduwaya, kajungwa ambaka-murra karru-meni-yada wurrakina adidirrbura-wiya. ");
INSERT INTO aoi_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","“Nungkwaje-ka ki-lyelyingminama wurrumurndakibina warnumamalya wurribina kabu-wirrikbina-murrumurra nungkuwa-wa. Ki-yaminame-ka ningkakina eningaba aburruwa-manja. Akwa ka-kwunama amurndakijika nungkwa-langwa aduwaya aburruwa-wa, akwa nara engkirrikuma ningkakina warniki-lawurrakaja-langwa wurrakina amurndakibina amurndakijika nungkwa-langwa. Ki-yamina-manja nungkuwa akina, kembirra eneja Neningikarrawara kini-yaminama eningaba nakina angwurra nungkuwa-manja, akwa Neningikarrawara-langwa ningkenumamalya k-ambilyama ningkakina. Nakine-ka naruma numikbiyiya-dangwa Neningikarrawara. Kembirra Neningikarrawara wuburra ki-yaminama ningkakina, mena nu-marngkirradina-mubaba nakina wurruwurrariya-manja warnumamalya. Mama nara engkirrikuma wurrakina wurrukwalu-wa warnumamalya, mama namin-engkingkirrajajungwunama wurrakina, umba nu-marngkirradiname-ka amandangwa aburruwa-manja nakina. ");
INSERT INTO aoi_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Nakine-ka Nungwanyungwa n-errukwulinama amandangwa ngarnumamalya-manja. Kembirra nungkwurrajukwaba yik-errukwulinama kirrakina wurriminiminingka-manja warnumamalya kirrakina-da,” ni-yama Jesus ena-langwu-wa warnikabuburrakiyuwa-da. ");
INSERT INTO aoi_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Biya ni-yama Jesus ngarningka ena-langwu-wa warnikabuburrakiyuwa, “Nare-ka a-lyangkuwerribikajungwuma warnumamalya-langwa warningaba-murrikba akwa wurruwurrariya-murrikba wurrakina. Eneja kembirra Neningikarrawara nara a-lyangkuwerribikajungwuma nakina nungkwa-langwa-langwa, ningkeningaba-murrikba akwa ningkuwurrariya-murrikba ningkakina. Akwa nara ngarningka a-lekbuma warnumamalya-manja. Eneja kembirra Neningikarrawara nara nakina a-lekbuma nungkuwa ningkakina. Umba nungkwaja kamini-yakuwabijinama ningkakina awurruwurrariya wurrukwala-langwa. Kembirra enejukwaba Neningikarrawara kenumini-yakuwabijinama nakina awurruwurrariya nungkwa-langwa-da. ");
INSERT INTO aoi_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","“Umba nungkwaja ka-kwunama eninginingaba-wiya wurrukwala-manja warnumamalya. Eneja kembirra Neningikarrawara kenu-kwunama eninginingaba-wiya nungkuwa-manja. Nakine-ka Neningikarrawara numekba nilyengma, akwa kenu-kukwunama eningaba neningangkawura. Kenu-wekbilyenama nungkuwa-manja akwa nara a-ngwanjuma. Kini-yaminama Neningikarrawara wuburra laka nuwilyaba nenumamalya ni-jirabinama nakina yinumalyirra yilyakwa nungkwa-langwu-wa bajikala. Nara a-ngwanjuma nakina umba ni-jirabinama yakina kini-lyangburrukwuna-murruwa yibina nungkwa-langwa-manja bajikala-da. Enejukwaba nakina Neningikarrawara nara a-ngwanjuma umba kenu-wekbilyenama ngawa eninginingaba-wiya nungkuwa-manja neningangkawura. Umba nungkuwa ka-kwuna-manja eningaba wurrukwala-manja warnumamalya ningkumekba-manja ningkakina, kembirra enamba-langwa nakina Neningikarrawara kenu-kwunama eningaba nungkuwa-manja-da,” ni-yama Jesus nakina-da. ");
INSERT INTO aoi_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Amurndakakina-bina ayakwa ni-yengbinuma Jesus, nenu-makama nakina ena-langwa-manja warnikabuburrakiyuwa. Biya kembirra enena alawudawarra nenu-makama arakba nakina wurrimimbimimba-langwa akwa warnikakakirumaka-langwa warnumamalya. Ni-yama Jesus aburruwa-wa, “Wi-yakuwerribikina wurrimimbimimba-langwa warnumamalya. Kenilirraki-ngayindena-manja wunambilyuma-kiya wunimimba-kiya keni-likaja-manja yeya, nare-ka wunalakina arndawarakajajuma a-wilyakajajuma-da. Kenilirraki-larra-maka edirra-wa-da. ");
INSERT INTO aoi_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","“Aburnajukwaba wunambilyuma-kiya wunenumamalya-kiya wunalekbina wunikikamarra-kiya nare-ka akakirumakajajuma wunalakina. Umba eneja nuwilyaba nenikakakirumaka kenu-wilyakajinama ningka-langwa nenumamalya niyukwujiya, mena nakakiruma-baba nakina angwurra. Eneja niyukwujiya-dangwa ni-ngayindijungwunuma enejukwaba aringkawi-yada nakina. Kembirra kin-akakirumakajungwunama nakina angwurra. Kin-engkirrikajama angwurra ayakwa ena-langwa-langwa bungkawa. Kin-engkingkirrikajama ngawa mababurna-langwa marringa, kini-yamina-murruwa nakina ababurna-langwa nibina nubungkawa nakakiruma. Kembirra akini-yada ngawa arija-langwa wunalakina-kiya kenilirrak-eningmidinama wunididirrbura-kiya-da,” ni-yama Jesus ena-langwu-wa warnikabuburrakiyuwa-da. ");
INSERT INTO aoi_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Biya ngarningka ni-yengbina nakina Jesus ayakwa, nenu-makama angwurra wurrumurndakibinu-wa warnikabuburrakiyuwa. Ni-yama, “Nungkwaja ningku-werrikawarriyadinama ningkakina ebina-langwa eyukwujiya ajiringka nenikumarnjena-langwa-manja menba. Miyambena-burra ningku-werrikawarriyadinama akina-langwa, akena nara engkirrikuma nungkuwa arumu-wa eka nungkwa-langwa-manja menba? ");
INSERT INTO aoi_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Nungkwaja nara e-yamama nenikumarnjenu-wa, ‘Ngeniyerriya, nenikama, ngu-miya-langwa akina ajiringka nungkwa-langwa-langwa menba.’ Nara e-yamama akina, mena nara-baba ningkakina a-rringkama ebina eka adirrungwarna-dangwa nungkwa-langwa-manja menba. Ka-ngayindenama ningkakina wurrukwala warnumamalya ke-yaminama, ‘Ningkeningabe-ka ningkakina,’ akena ningkuwurrariya nungkuwa. Adinuba-wiya ki-ngkarbajinama eka nungkwa-langwa-langwa menba, kajungwa ki-rringkini-yada angwurra ningkenik-ambijangaji-yada ebina ajiringka eyukwujiya menba-langwa nenikumarnjena-langwa ningkakina-da,” ni-yama nakina Jesus ena-langwu-wa warnikabuburrakiyuwa-da. ");
INSERT INTO aoi_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Biya ni-yama nakina Jesus aburruwa-wa ngarningka, “W-engkirrikiya-langwa enena alawudawarra ka-makinama. Ka-makinama alawudawarra eka-langwa nuw-arrangbina-mulangwa amaninga amamamuwa. Awilyaba eka eninganinga eningaba-dangwa nuw-arrangbinama akina amaninga amamamuwa ngala-langwa enikalyelyubara eningaba. Akena ebina-murrada awilyaba-ma eka eningaba nara arrangbama amaninga amamamuwa awurrariya ebina nara ngakwurruwa alyubaruma. Akwa ngalaja eka awurrariya-dangwa nara arrangbama akina amaninga amamamuwa eningaba enikalyelyubara. ");
INSERT INTO aoi_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","“Aki-rringkina-manja ngakwurraja amaninga amamamuwa eka-manja, ngarningma ngarrakina akina eka eningaba-murrikba akwa ngawa awurrariya-murrikba, mena ngarningma-baba ngala-langwa amaninga amamamuwa ebina nuw-arrangbinama. Kembirra akuma-ngayindena-manja ngarrakina manyungwunya ak-alyubarini-yada, nara a-likama ngarna akwurrirra-wa, umba manyungwunyu-wa aki-likajama akum-arrangbinama-da. Akwa ngarningka, aki-ngayindena-manja akwurena ak-alyubarini-yada ngarrakina, nara a-likama yimirriru-wa umba akwurenu-wa aki-likajama ak-arrangbinama-da. ");
INSERT INTO aoi_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","“Amandangwa eningaba eka nuw-arrangbinama akina amaninga amamamuwa eninginingaba-wiya, umba awurrariya eka nuw-arrangbinama akina amaninga amamamuwa awurruwurrariya-wiya. Umba eneja nuwilyaba nenungkwarba neningaba kini-yaminjamina-manja eningaba-wiya nakina, akine-ka wuburra eka eningaba kini-yaminama nakina, mena nara-baba engkirrikuma nakina awurrariya-wa umba kin-engkingkirrikaja-mubaba ngawa eningabu-wa. Umba eneja nuwurrariya nenungkwarba kini-yaminjaminama awurrariya-wiya, mena n-engkingkirrikaja-mubaba ngawa awurrariya-wa angwurra nakina. Umba ngalaja ayakwa ngakwurra-langwa ebina ka-jadenama edirra-langwa aki-yengbina-mulangwa ayakwa ngarrakina, adinuba-wiya nuw-ambilyumurra akina ngakwurra-langwa-manja mangma iya yukwudukwuda-manja-da,” ni-yama Jesus ena-langwu-wa warnikabuburrakiyuwa-da. ");
INSERT INTO aoi_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Biya kembirra ni-yama ngarningka Jesus aburruwa-wa, “Kirri-yaminjaminama ngawa kirrakina ngayuwa-wa, ‘Bungkawa, Bungkawa,’ kirri-yaminjaminama. Miyambena-burra yirri-yengbijinama ngayuwa Ningubungkawa ningena kirrakina, akena yirrumini-yarrkuwurrenama ayakwa nganyangwa? ");
INSERT INTO aoi_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Kirruwilyaba karnumamalya nara-manja amini-yarrkuwurruma akina ayakwa nganyangwa umba yiki-likaja-manja ngayuwa-wa akwa yikumini-yarrkuwarakina-manja nganyangwa ayakwa, kirrumiyambene-ka kembirra kirrakina karnumamalya? Ka-makinama ngayuwa. ");
INSERT INTO aoi_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","“Kirrakine-ka karnumamalya wuburre-ka nuwilyaba nenungkwarba ni-likirakama nakina alikira ena-langwa. Nakine-ka nu-mungkadinumurra adinuba-wiya angwujirira edirra ajiringka-manja. Nu-mungkumungkadinumurra nakina yanda-langwa n-akburrangarnuma akwurraka angwarnda. Biya kembirra ni-likirakamurra arakba nakina alikira ena-langwa ebina-manja ngawa angwarnda akwurraka kajungwa engbudi-yada ebina alikira. Bi...ya kembirra ngalaja akungwa na-didumina adirrungwarna. Biya na-wardanguma angwurra akina akungwa akina-manja alikira, akena nara ke-kbilyajanga akina. Akwurrake-ka ngawa nuw-arjeyumurra akina, mena eningaba-baba warka nu-war•danguma nibina nenungkwarba. Eningabe-ka engbuda alikira ni-likirakamurra nakina-da. ");
INSERT INTO aoi_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","“Umba kirruwilyaba karnumamalya yik-engkirrikaja-manja ayakwa nganyangwa kirrakina, akena yikumini-yarrkuwurrena-manja akina ayakwa nganyangwa, kirrumiyambene-ka kembirra kirrakina karnumamalya? Ka-makinama arakba ngayuwa. Kirrakine-ka karnumamalya wuburre-ka nuwilyaba ningka nenungkwarba ni-likirakama nakina ena-langwa alikira enejukwaba. Akena erribirra ajiringka-manja ngawa ni-likirakama akina. Nara kinu-mungkadina edirra adinuba-wiya nakina akwa nara kini-likiraka alikira ena-langwa akwurraka-manja angwarnda. Bi...ya kembirra ngalaja akungwa na-didumina adirrungwarna. Biya na-wardanguma angwurra alikira-manja akwa warenja-bawiya ne-kbilyajanguma akina. Kembirra arngkawura-murra ngawa na-jerridinuma-da,” ni-yama Jesus ena-langwu-wa warnikabuburrakiyuwa-da. ");
INSERT INTO aoi_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Eneja Jesus ni-jerrukwama amurndakibina ayakwa ni-yengbinu-mulangwa wurrumurndakibina-manja warnumamalya, biya kembirra ni-likena arakba nakina engembu-wa Kabuniyumu-wa. ");
INSERT INTO aoi_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Yakwujina akina-manja ngawa angalya Kabuniyuma n-ambilyumurra eneja nuwilyaba nubungkawa wurrawinyamba-langwa. NeningiRawume-ka nakina. Biya nakina nubungkawa nu-bungkawadinuma wurrababurna-manja warnungkwarba wurrawinyamba. Aburrajukwaba WarningiRawuma wurrakina. Kembirra nakina nubungkawa aburra-langwa nu-werrikawarriyadinuma mena-baba nuwilyaba nenikuminuwar•duwar•da ena-langwa n-angbilyuwadinuma aruma ajungwa akwa ni-lyelyingminu-mubaba nakina-manja akwa arngkidarrba kini-jungwunu-mubaba nakina. ");
INSERT INTO aoi_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Biya nubungkawa nakina n-engkirrikenuma ayakwa wurrukwala-langwa warnumamalya na-makijeyinu-mulangwa Jesus-langwa. Biya kembirra ni-yama nakina wurrukwalu-wa wurrarumuruma warnungkwarba WarningiJudiya-wa, “Jeyi! Wurri-likaja angerriba Jesus-uwa. Wurri-yarrkuwilyakina enena ayakwa enuwa-wa akwa yikinu-makina kini-likaji-yada nakina warenja-bawiya yangkwurrangwa nganyangwu-wa alikira kajungwa ken-enibikini-yada nenikuminuwar•duwar•da nganyangwa,” ni-yama nakina wurrumurndakibinu-wa wurrarumuruma WarningiJudiya-wa. ");
INSERT INTO aoi_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Aburraja kembirra na-likena arakba wurrakina warnungkwarba wurrarumuruma Jesus-uwa. Biya ne-yama enuwa-wa, “Nuwilyaba nubungkawa NeningiRawuma ngini-ngayindenama nungkuwa ki-likajama kin-eningabakinama ena-langwa nenikuminuwar•duwar•da angbilyuwa-langwa. ");
INSERT INTO aoi_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Nakine-ka nubungkawa neningaba nakina akwa ni-lyelyingminama ngakwurruwa NgarningiJudiya ngarnumamalya. Ngarrenumini-likirakama arakba alikira Neningikarrawara-langwa enena-manja angalya. Amandangwa neningabe-ka nakina nenumamalya. Kembirra ngarri-likaja enena-wiya,” ne-yama wurrumurndakibina wurrarumuruma Jesus-uwa. ");
INSERT INTO aoi_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Biya namurndaki-likenuma arakba wurrakina wurrarumuruma akwa ngawa wurrababurna warnumamalya Jesus aburruwa. Nuw-alilikenu...wa. Ngalaja nuw-akwudangwudina arakba alikira nibina-langwa nubungkawa NeningiRawuma, akena aburraja wurrubukwaya wurrukwala warnumamalya ena-langwa nenumini-yarrkuwilyakama ayakwa Jesus-uwa. “Bungkawa, arjiyinga-langwa yakwujina,” ne-yama. “Nara arakba a-likama. Yirrenu-makama nibina nubungkawa wurrawinyamba-langwa, ‘Jeyi! Wurri-likaja Jesus-uwa. Yikinu-makina nari-yada a-likama awiyebuma nakina nganyangwu-wa alikira, mena naruma-baba nubungkawa nakina Jesus, umba ningiyukwujiye-ka ningena ngayuwa. ");
INSERT INTO aoi_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Akwa aminakina-langwa nara ngarningka a-likama nganja enuwa-wa. Umba eni-yengbina wulkwa ayakwa nakina, kajungwa nganyangwa nenikuminuwar•duwar•da kin-eningabadini-yada arakba,’ ni-yama nakina nubungkawa NeningiRawuma yirruwa-manja. ");
INSERT INTO aoi_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Akwa enena engka ayakwa yirrenu-makama nakina. ‘Ngayuwe-ka ningena ningubungkawa,’ ni-yama nakina, ‘akena ningenumin-engkirrikajame-ka nganjukwaba nganyangwu-wa nubungkawa. Aburrajukwaba wurrawinyamba nganyangwa wurribina-manja ningu-bungkawadinama ngayuwa nuw-engkirrikajame-ka ayakwa nganyangwa. Ki-yamina-manja ngayuwa warningerribirra-wa warnungkwarba nganyangwu-wa, Jeyi! Likaja nungkuwa angerriba, kembirra warenja-bawiya kini-likajama nakina angerriba. Umba ki-yamina-manja ngayuwa ningku-wa nenungkwarba, Kwa yangkwurrangwa ngayuwa-wa, kembirra warenja-bawiya kini-likajama ngayuwa-wa nakina. Umba ki-yamina-manja ngayuwa nganyangwu-wa nenikuminuwar•duwar•da, War•dena ena warka! Kembirra amandangwa kinu-war•denama nakina-da nganyangwa-langwiya ayakwa-da,’ ni-yame-ka nakina nubungkawa NeningiRawuma yirruwa-manja,” ne-yama wurrumurndakibina warnumamalya ena-langwa Jesus-uwa. ");
INSERT INTO aoi_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Kembirra eneja Jesus ni-yakikbijanginume-ka nakina amurndakakina-langwa ayakwa, biya ni-nyakuwarrukwajungwa akwa ni-yengbina ayakwa wurrumurndakibina-manja wurrababurna warnumamalya wurribina neni-yuwarnu-murrumanja enuwa-manja. Ni-yama Jesus aburruwa-wa, “Nara ambaka ngayuwa k-akburrangarna karningerribirra karnumamalya kirribina yiku-werrikambilya-murrumurra angwurra ngayuwa-manja. Nara kirruwilyuwilyaba karnumamalya enena-manja angalya Yijireyila-manja a-werrikambilyuma angwurra ngayuwa-manja, umba eneja NeningiRawuma nenumamalya nu-werrikambilyama amandangwa ngayuwa-manja angwurra nakina,” ni-yama nakina Jesus wurrumurndakibinu-wa wurruwurrakwulyumida warnumamalya. ");
INSERT INTO aoi_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Aburraja kembirra wurrumurndakibina warnungkwarba namurndaki-lawurradina arakba nibinu-wa nubungkawa NeningiRawuma. Biya ne-yar•da wurrakina ena-langwa-manja alikira. Akwa neni-rringka nibina n-angbilyuwadinuma nenikuminuwar•duwar•da ena-langwa n-eningabaduma kemba nakina arakba-da. ");
INSERT INTO aoi_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Eneja kembirra ni-likenuma Jesus engembu-wa Neyina, ena-langwa warnikabuburrakiyuwa aburruwa. Aburraja wurrukwala wurruwurrakwulyumida warnumamalya namurndaki-likenuma wurruwurrakawura-ma Jesus-manja. Nawurrak-alilikenu...wa. ");
INSERT INTO aoi_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Ngalaja nuw-akwudangwudina arakba akina angalya Neyina aminababurna alikira iya warnumamalya. Kembirra ne-yar•da arakba Jesus-murriya akawiyuwiyeba-manja akwudangwa. Akini-yada ngawa aburraja wurrukwala warnumamalya na-jadanga errekbu-wa. Nenu-wilyakama nuwilyaba nenikijungwa nenungkwarba warniki-rungkwabi-yada nakina. Ngalaja dirndenikba dingaya dakina, akena nara arakba wurriyukwayuwa ngala-langwa, mena nuwilyaba-ma yimbukwa naburradikba nakina. Biya yingi-jadanga Neyina-langwa ngaluwa akwa wurruwurrakwulyumida warnumamalya. ");
INSERT INTO aoi_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Eneja Nubungkawa Jesus nanga-rringka-manja nakina, n-errukwulinuma dakinu-wa dingaya. Biya ni-yama ngaluwa-wa, “Nara a-ngwaduma.” ");
INSERT INTO aoi_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Kembirra n-akwudangwukajungwa Jesus nakinu-wa nenikijungwa nenungkwarba arakba. Biya n-akumarna nakina ayarrka ena-langwa bada-manja. Aburraja warnungkwarba wurribina nenu-wilyakama nibina nenikijungwa nenumamalya nuw-alkayinga nuw-erriminja wurrakina arakba. Kembirra ni-yengbina nakina Jesus ayakwa nibinu-wa ni-jungwu-murruwa. “Nungkuwa! Mirajanga!” ni-yama. ");
INSERT INTO aoi_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Eneja ni-rrakarjiyinga arakba nakina nenungkwarba ni-jungwu-murrada. Biya ni-yengbina nakina ayakwa-da. Kembirra Jesus nanga-kwa dirndenikba-wa arakba-da. ");
INSERT INTO aoi_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Aburraja wurrumurndakakina warnumamalya nawurrak-akbar•de-ka angwurra wurrakina. Biya neni-yangmarngkwajuwa Neningikarrawaru-wa. Akwa na-makijeyina ayakwa. “Naka nenungkwarba ni-yengbinamurra ayakwa Neningikarrawara-langwa,” ne-yama. “Narume-ka NuBurabuda nakina. Eneja Neningikarrawara nakina ni-likenuma yangkwurrangwa kajungwa aken-enibikini-yada ngakwurruwa ena-langwa ngarnumamalya,” namurndaki-yama wurrakina. ");
INSERT INTO aoi_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Biya ebina-manja aringbirra angalya Judiya namurndaku-makijeyinuma warnumamalya ebina-langwa Jesus ni-yama-mulangwa nakina. Akwa ngarningka ababurna-manja angalya Judiya-manja akwudangwa, aburrajukwaba warnumamalya namurndaku-makijeyinuma akina-langwa-da. ");
INSERT INTO aoi_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Kembirra arakba warnikabuburrakiyuwa Janjana-langwa aburrajukwaba nuw-engkirrikenuma amurndakibina ababurna-langwa ne-yama-mulangwa. Akwa nenu-makama Janjana-manja. Eneja kembirra nen-ardijuwama nakina Janjana enuwa-wa wunambilyuma-kiya ena-langwa wunenikaburrakiyuwa-kiya. ");
INSERT INTO aoi_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Ni-yama aburnuwa-wa, “Nungkwurnuwa, jeyi! Wuni-likaja angerriba Nubungkawa Jesus-uwa,” ni-yama, “yikumini-yengbini-yada enena ayakwa enuwa-wa. Yikini-yama, ‘Ningkumiyambena ningkenumamalya ningkakina?’ yikini-yamina. ‘Yirrenu-makama Janjana nuwilyaba-langwa naruma nenumamalya neniki-lika-langwa yangkwurrangwa. Dukwa nungkuwa ningkena-da. Umba dukwa yik-embirrarinama yarna ningka nenumamalya yelakwa kini-yar•dena-murruwa-da. Umba nungkwaja, ningkumiyambena ningkenumamalya ningkena?’ yikini-yamina Jesus-uwa kinalakina,” ni-yama Janjana wunalakina-kiya-wa. ");
INSERT INTO aoi_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Aburnaja neni-likena arakba-da. Nen-alilikenu...wa. Nen-akburranga arakba Jesus. Biya neni-yama, “Yinenumamalya-kiya Janjana Nenikumingekingambaja-langwa yinalakena. Yirrenu-makama nakina nuwilyaba-langwa naruma nenumamalya nibina neniki-lika-langwa enenu-wa angalya. Ningkakine-ka dukwa kembirra yirrenu-maka-mulangwa ayakwa Janjana-da. Nara-manja nungkuwa, kembirra yik-embirrarinama yarna ningku-wa nenumamalya dukwa-da. Ni-ngayindenama Janjana kin-eningmidinama nungkuwa-langwa. Yirru-makina kembirra. Ningkumiyambena ningkenumamalya ningkakina?” neni-yama Jesus-uwa wunalakina-kiya. ");
INSERT INTO aoi_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Akini-yada ngawa eneja Jesus nen-eningabakama wurrababurna warnumamalya wurrangbangbilyuwa-murra. Aruma ajungwa narraku-wardanguma wurrukwala, umba aburraja wurrakina wurrukwala narra-wilyakama wurruwurrariya wurramukwa aburruwa-manja, umba aburraja wurrukwala wurrimimbimimba wurrakina. Kembirra nakine-ka Jesus nen-eningabakama wurrakina eningerribirra-langwa angbilyuwa akwa namurndak-eningabadinuma arakba wurrakina-da. ");
INSERT INTO aoi_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Kembirra ni-yama Jesus wunalekbina-kiya-wa wunenikaburrakiyuwa Janjana-langwa, “Jeyi! Wuni-lawurradina Janjanu-wa,” ni-yama. “Yikinu-makina ababurna-langwa kini-rringka-mulangwa kinalakina nungkwurna-langwa-murra menba aduwaba. Akwa yikinu-makina ababurna-langwa ayakwa kin-engkirrikenu-mulangwa kinalakina memema-manja mamawura. Wurribina wurrimimbimimba-murrada warnumamalya adinuba-wiya nuw-andiyama arakba. Wurribina wurrirrengmurrengmurnirna-murrada warnumamalya na-likajama yiningaba arakba yeya. Aburrajukwaba wurramarmarra-murrada warnumamalya amungkwur•da arakba aburra-langwa amakwulya. Aburrajukwaba wurrambambuma-murrada warnumamalya nuw-engkirrikajama arakba ayakwa. Aburrajukwaba warnumamalya na-jungwunu-murrada warniba arakba. Akwa enena engka. Aburraja warningalyingmalyingma warnumamalya nuw-engkirrikajama arakba ayakwa eningaba Neningikarrawara-langwa-langwa. ");
INSERT INTO aoi_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Amandangwa eneja Neningikarrawara neningabe-ka nakina warningerribirra-manja warnumamalya wurribina nara a-minikalyikuma nganyangwa-langwa,” ni-yama Jesus wunalekbina-kiya-wa wunenikaburrakiyuwa Janjana-langwa. ");
INSERT INTO aoi_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Aburnaja neni-lalika arakba Jesus wunalakina-kiya akwa neni-lawurradina Janjanu-wa. Eneja kembirra Jesus ni-yengbina akwala ayakwa Janjana-langwa-langwa wurrumurndakibina-manja wurruwurrakwulyumida warnumamalya. Ni-yama nakina, “Kirri-likenu-manja nungkwurruwa engku-wa alarrkingburingka-wa angalya nara-murruwa alikira, numiyambenu-we-ka nenungkwarba kirr-aburangkama kirrakina? Kirri-likenuma dukwa kirr-andeyuma nenungkwarba nilyangkadawa, nibina numa-warrukwajinama mangma erribirra? Dukwa nenungkwarba kirr-aburangkama amarda wuburra, ebina na-warrijinama arrirra angerriba iya angerriba? ");
INSERT INTO aoi_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Dukwa kirr-aburangkama kirrakina nenungkwarba nibina n-awiyuwiyebenama dukukwulyubena dumbala akwa n-alyelyubarinama eningaba aninga akwa nu-murrkumurrkwulama mamurrkbalya-manja mamukumungkwulinga? Namukwiyadakine-ka nenungkwarba kirr-andeyuma dukwa-da. Nare-ka. Namukwiyadakina nenungkwarba nara erribirra ambilyuma alarrkingburingka-manja angalya umba alikira-manje-ka n-ambilyama, wuburra wurrububungkawa-langwa-manja alikira nakine-ka-da,” ni-yama Jesus wurrumurndakibina-manja warnumamalya. ");
INSERT INTO aoi_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","“Yirru-maka,” ni-yama ngarningka Jesus wurrakina-manja. “Kirr-aburangkama NuBurabuda nenumamalya kirrakina-da, nibina nenu-makumakinama Neningikarrawara-langwa ayakwa warnumamalyu-wa-na! Yawe-ka, nakina-bina-da! Kirri-likenuma kirr-aburangkama NuBurabuda nenumamalya akwa kin-akburrangama arakba nakina. Umba nakine-ka NuBurabuda nenikiyarrkuwilyaka ayakwa Neningikarrawara-langwa ngarningka nakina. ");
INSERT INTO aoi_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Ka-makinama nganja ningena, kembirra w-engkirrikiya-langwa angwurra amurndakenenu-wa ayakwa nuw-arrikarrijungwunu-murruwa Neningikarrawara-langwa-manja jurra. Ngarraku-makinama ayakwa Janjana-langwa-langwa. Ni-yamama Neningikarrawara arakburakba-kiya-wiya, ‘Ngayuwe-ka ningena kini-larrkajama nganyangwa nenikiyarrkuwilyaka ayakwa nenumamalya, kajungwa kenumini-ngekburakini-yada mamurukwa nungkwa-langwa ningkeniki-liki-yada nungkuwa. Kini-lyengmenama nakina umba k-arijidinama ningkakina arija-langwa,’ ni-yamama Neningikarrawara. Kembirra arakba nakina-bina Janjana-da, ni-lyengmanguma nakina-da,” ni-yama Jesus wurrumurndakibinu-wa warnumamalya. ");
INSERT INTO aoi_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","“Amandangwa,” ni-yama ngarningka Jesus. “Naruma ngawa nenumamalya nakina Janjana-da. Arakburakba-kiya-wiya-langwa yanda-langwa aduwaba nara wurribina wurrukwala warnumamalya wurraruma wuburra enuwa. Umba nungkwurraja kirriyukwujiya-dangwa karnumamalya, kirr-engingmidina-manja Neningikarrawara nu-bungkawadina-mulangwa nakina, kembirra kirrarume-ka Janjana-manja angwurra kirrakina. Kirr-eningmidina-manja Neningikarrawara nu-bungkawadina-mulangwa nakina, kembirra eneja Neningikarrawara kini-yaminama nakina nungkwurra-langwa-langwa, ‘Naka nenungkwarba naruma, amandangwa naruma Janjana-manja angwurra,’ kini-yaminama Neningikarrawara-da,” ni-yama Jesus wurrumurndakibinu-wa wurruwurrakwulyumida warnumamalya-da. ");
INSERT INTO aoi_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Aburraja wurrumurndakakina warnumamalya wurrababurna-langwa namurndak-engkirrikenuma akina ayakwa Jesus-langwa. Akwa ngawa aburraja wurrukwala warnungkwarba narraminu-war•dangu-murrumurra warka WarningiRawuma-langwa akwa narraminu-murndukwa-murrumurra angwarnda warnumamalya-langwa aburrajukwaba nuw-engkirrikenuma akina Jesus-langwa ayakwa wurrakina akwa neni-yangmarngkwajuwama Neningikarrawaru-wa. Wurrumurndakakine-ka wurrababurna warnumamalya nuw-engkirrikenuma ebina-wiya adinu...ba-wiya ebina ayakwa Janjana-langwa. Kembirra nenumini-yarrkuwarakama wurrakina Neningikarrawara-langwa ayakwa akwa kembirra eneja Janjana nenu-mingekingambajuwama wurrakina. Kembirra aduwaba nuw-engkirrikenuma Jesus-langwa ayakwa wurrakina-da. ");
INSERT INTO aoi_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Umba aburraja WurruBarija warnumamalya akwa ngawa warnikakakirumaka ayakwa eningarumuruma Mawijija-langwa nara wurrakina kenumini-yarrkuwaraka Neningikarrawara-langwa ayakwa. Kembirra nara Janjana kenu-mingekingambajuwa wurrakina, mena namurndaku-warangu-mubaba-da. ");
INSERT INTO aoi_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Eneja kembirra ni-yama Jesus wurrumurndakibinu-wa wurruwurrakwulyumida warnumamalya, “Karnumamalya kirribina kirr-ambilyama enena-manja angalya aduwaba, kirrumiyambene-ka karna? ");
INSERT INTO aoi_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Wurriyukwayuwe-ka wuburra kirrakina-da, wurribina nuw-angmakayenama wurrakina namurndaki-likaja-murrumanja wurrababurna warnumamalya, namurndaku-warrukweyina-murrumanja wurrakina angerriba iya angerriba. Umba wurrukwala wurriyukwayuwa nuw-ardenama wurrukwalu-wa. Ne-yaminama, ‘Yarna ngarraminu-mebinuma eninginingaba emeba kajungwa ke-yekirrerrikini-yada nungkwurruwa. Akena nara nungkwurraja yiki-lukweyina kirrakina-da. Biya kembirra yirru-mebinuma emeba eningamukwa akwa yirru-ngwadinuma yarna awurrumalya. Akena nara yiku-ngwadeyina nungkwurramba-langwa kirrakina-da,’ ne-yaminama wurrukwala wurriyukwayuwa wurrukwalu-wa wurrakina-da. Kembirra wurriyukwayuwa wuburra yiki-yaminama nungkwurraja karna karnumamalya karningaduwaba-da, mena kirru-waranguma adinuba-wiya Janjana, akwa kirru-warenama ngarningka ngayuwa nganjukwaba aduwaba kirrakina-da. ");
INSERT INTO aoi_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","“Amandangwa,” ni-yama Jesus, “ebina-wiya ni-likenu-manja Janjana Nenikumingekingambaja yangkwurrangwa, kini-rringkama nakina mamawura iya marringa. Adadinuba nara nakina kin-alyubarina aninga, umba murumureya n-ambambilyuma neni-yangmarngkwajuwama Neningikarrawaru-wa nakina. Akwa nara amalyirra kini-bekina nakina akwurena-langwa. Nungkwurraja kini-rringkama nakina, akwa kirri-yamama, ‘Kardi! Wurramukwa-dangwa naka-manja nenungkwarba nuw-ambilyama,’ kirri-yamama-da. ");
INSERT INTO aoi_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Kembirra nganja, ningibina-murrada ningi-rukwularrinuma enena-manja angalya, ningi-yar•duma arakba arija-langwa ngayuwa. Nungkwurraja yirri-rringkinama ngayuwa ning-alyubarinama aninga iya ningi-bekinama akwurena-langwa amalyirra. Kembirra kirri-yaminama, ‘Kardi! Nake-ka nenungkwarba numungwur•dangme-ka. N-alyelyubarinama naka akwa ngawa ni-bibekinama akwurena-langwa amalyirra naka-da. Akwa ngarningka namurndaki-yakeyinama enuwa akwa warnungkwarba wurribina narruwurra-murndukwunama angwarnda wurrukwala-langwa akwa ngawa warnumamalya wurruwurrariya aburrajukwaba-da,’ kirri-yaminama-da. Amukwiyadakina ayakwa kirri-yengbiyengbinama nganyangwa-langwa-da. Adinuba-wiya kirru-waranguma Janjana, umba aduwaba kirru-warenama ngayuwa nganjukwaba-da. ");
INSERT INTO aoi_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","“Aburraja warnumamalya wurribina nenumini-yarrkuwarakinama ayakwa Neningikarrawara-langwa narra-wilyakajinama wurrukwala-manja warnumamalya ayakwa ni-yengbinu-mulangwa Neningikarrawara alyangmilyangmandukwuna-wiya amurndakakina-da,” ni-yama Jesus wurrumurndakibinu-wa warnumamalya-da. ");
INSERT INTO aoi_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Bi...ya eneja nuwilyaba NuBarija nenumamalya nen-ardijuwama Jesus ena-langwu-wa alikira aningi-yada. Nakina NuBarija nenimikirra Jayumuna. Ni-likena eneja Jesus ena-langwu-wa alikira, n-awiyebena, akwa n-ambarringa biya n-alyubarina arakba aninga enuwa-manja yakwujina. ");
INSERT INTO aoi_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Akina-manja ngawa angalya aminababurna alikira ying-ambilyuma ngalaja dakina duwilyaba didarringka duwurrariya. Dadinungkwurakba ngawa duwurrariya ying-ambambilyuma dakina. Umba dadingma Jesus n-alyubarinuma aninga Jayumuna-langwa-manja alikira. Kembirra yingu-manga bungabungwa akwulyubena ebina yingu-beyindanguma aminaruma angwarnda eyukwujiya-ma budila. Eningabe-ka amalyirra akina akwa eningaba budila angwarnda-ma akwulyadada-ma. Yingu-manga akina biya yingu-wilyaka Jayumuna-langwu-wa alikira. Yingi-yar•da, biya ying-awiyebena ngalajukwaba. ");
INSERT INTO aoi_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Eneja Jesus n-angmungmakwulaluma nakina umba n-arndadadilyuma. Umba dakina didarringka ying-akwudangwukajungwuna enuwa-wa, ying-arjijeya akwaburrangarna ena-langwa-manja alika akwudangwa. Ying-arjijeya, biya yingu-ngwadina dakina didarringka, umba ngala-langwa angwada ne-ngkalyikama alika Jesus-langwa na-kwularrinu-mulangwa ngala-langwa-langwa menba. Biya kembirra arakba ying-abuluwendinga yingi-ngburingkakama alika Jesus-langwa ngala-langwa-murra mamungba. Biya yingi-lawurangka arakba alika ena-langwa-da. Akwa amalyirra ebina yingu-wilyakama eningaba yingi-jiraba budila-langwa Jesus-langwa-manja alika arakba-da. Eningabe-ka na-kirruwanjuma. Dakine-ka didarringka yingi-yamama akina mena-baba yingi-lyelyingminuma Jesus-da, akwa yingini-ngayindanguma Jesus neningmi-yada nakina yingi-lyelyingminu-mulangwa dakina-da. ");
INSERT INTO aoi_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Eneja NuBarija numinakina alikira nanga-rringkama ebina yingi-yamama dakina, biya ni-lyangkiyama, “Numiyambene-ka naka nenungkwarba? NuBurabuda-manja nenungkwarba amandangwa naka, kin-eningmidinuma kembirra daka-langwa didarringka-da! Kin-eningmidinuma duwurrariya dilyengma daka didarringka dibina yingini-lyinginama-da,” ni-lyangkiyama nakina NuBarija. ");
INSERT INTO aoi_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Eneja Jesus ni-yama enuwa-wa, “Jayumuna, yiba-makinama eyukwujiya alawudawarra,” ni-yama. Ni-yama eneja Jayumuna, “Yi-makina kembirra, Bungkawa.” Eneja kembirra nakina Jesus nenu-makama enena alawudawarra. ");
INSERT INTO aoi_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Nuwilyaba nenungkwarba numinababurna angwarnda nenu-kwama ena-langwa angwarnda wurrukwalu-wa warnumamalya wurribina warningalyingmalyingma-wa. Nara erribirra kenu-kwa umba ambaka-murra aburraja kenumini-lawurrakajinama arija-langwa wurrakina. Arngkababurna-langwa ni-yaminjamama nakina. Biya nenu-kwa nuwilyaba nenungkwarba eningaduwaya angwarnda aruma, 500 ajilba-murra-da. Umba nenu-kwa ningka nenungkwarba 50-da. Bi...ya numi-jerrida arakba mamawura wuneniki-lawurrakaji-yada wunalakina wunenungkwarba-kiya ebina angwarnda. ");
INSERT INTO aoi_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Akena wuneningangwarnda-ma wunalakina-kiya-da. Nara kenu-wilyaka ebina angwarnda wuneniki-lawurrakaji-yada-da. Bi...ya eneja n-embimbirrarinu-mulangwa nakina nenungkwarba nenungkwurakba, nenu-maka arakba wunalakina-kiya-wa, “Mama arakba akina. Nara a-lawurrakajuma ngayuwa-wa, mena kineningangwarnda-ma-baba kinalakina. Kamini-yakuwabijinama akina-langwa angwarnda,” ni-yama nakina. Ena ngawa. “Yi-makina kembirra ningkakina Jayumuna,” ni-yama Jesus enuwa-wa, “numiyambene-ka nenungkwarba kinu-warrngkilyelyingminama nakina-manja nenumamalya umba numiyambena kini-lyelyingminama angwurra?” ni-yama Jesus Jayumunu-wa. ");
INSERT INTO aoi_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Eneja ni-yama Jayumuna, “Ngaya ningi-yaminama nibina nenungkwarba kini-lawurrakajini-yada aruma angwarnda enuwa-wa kini-lyelyingminama angwurra nakina, mena aruma-baba angwarnda nenumini-yakuwabijuwama nakina-da,” ni-yama Jayumuna-da. “Nakina-bina-da,” ni-yama Jesus. ");
INSERT INTO aoi_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Biya ni-nyakuwarrukwajungwa arakba nakina dibinu-wa didarringka, akwa ni-yama ngarningka Jayumunu-wa, “Nga-rringka daka didarringka,” ni-yama. “Ningena ngayuwa ning-awiyebenu-manja enenu-wa alikira nungkwa-langwu-wa, nara yiku-kwa akungwa alika-langwa. Nara nungkuwa yikumin-ajirranga alika, umba ngalaja daka didarringka ngumin-ajirranguma alika nganyangwa ngala-langwa-murra angwada, akwa yingi-ngburingkakama ngala-langwa-murra mamungba. ");
INSERT INTO aoi_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Ning-awiyebu-manja ngayuwa nungkwa-langwa-manja alikira, nara nungkwaja yiki-lawurangka ngayuwa. Umba ngalaja daka didarringka arngkababurna ngumini-lawurangkama alika nganyangwa, yingi-lyelyingminu-mubaba ngayuwa. ");
INSERT INTO aoi_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Nara nungkwaja yikumini-jiraba aliba-langwa amalyirra nganyangwa-manja aringka, kajungwa warningmi-yada warnumamalya ningki-yekirrerridinu-mulangwa nungkuwa ningi-yar•du-mulangwa ngayuwa nungkwa-langwa-manja alikira. Umba ngalaja daka didarringka yingu-beyindangume-ka amalyirra aminaruma angwarnda ebina ne-ngbajama eningaba biya ngumini-jirabama alika-manja. ");
INSERT INTO aoi_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Dadingma daka duwurrariya dilyengma mena ababurne-ka awurruwurrariya yingi-yama-mubaba arakba daka. Umba eneja Neningikarrawara nangamini-yakuwabijuwama arakba amurndakakina awurruwurrariya yingi-yama-mulangwa daka-da. Kembirra aminakina-langwa ngalamba-langwa yingi-lyelyingminama angwurra ngayuwa-da. Umba kenumini-yakuwabijina-manja adinakba-kiya Neningikarrawara nuwilyaba nenumamalya ambawura awurruwurrariya, kembirra nakina-bina kinu-warrngkilyelyingminama ngayuwa-da,” ni-yama Jesus Jayumunu-wa-da. ");
INSERT INTO aoi_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Biya kembirra ni-yama nakina Jesus dibinu-wa didarringka, “Eningerribirre-ka awurruwurrariya ningki-yama-mulangwa ningkakina ningkumini-lyurrkwajungwunuma arakba ababurna-langwa,” ni-yama Jesus. ");
INSERT INTO aoi_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Aburraja warnumamalya wurribina ne-yebukeyinu-murrumurra aninga Jayumuna-langwa-manja alikira na-lyangkumakajungwunuma wurrakina, “Numiyambene-ka naka nenungkwarba nenumini-lyurrkwunama awurruwurrariya warnumamalya-langwa? Eneja Neningikarrawara yimbukwa nuwilyaba-ma kini-yengbinama amukwiyadakina ayakwa ngarnumamalyu-wa, umba nara naka,” na-lyangkumakajungwunuma wurrumurndakakina warnumamalya-da. ");
INSERT INTO aoi_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Eneja Jesus ni-yama kembirra dibinu-wa didarringka, “Ningku-werrikambilyu-mulangwa ngayuwa-manja ningkakina, kembirra yirr-enibikama ngayuwa ningkakina arakba. Umba jeyi, likaja arakba yiningaba-murra yukwudukwuda,” ni-yama Jesus ngaluwa-wa-da. Ngalaja kembirra yingi-likena arakba yiningaba-murra yilyurrkwa-murra yukwudukwuda dakina-da. ");
INSERT INTO aoi_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Bi...ya eneja Jesus ni-likenuma arakba nakina angerriba iya angerriba engku-wa iya engku-wa angalya. Ni-likenuma kembirra akwalu-wa angalya aminababurnu-wa alikira iya warnumamalya akwa akwalu-wa ngarningka angalya aminambawuru-wa alikira nakina. Biya amurndakakina-manja angalya ababurna-langwa nenu-makama warningakwujina warnumamalya eninginingaba ayakwa kinu-bungkawadina-mulangwa Neningikarrawara ena-langwa-manja warnumamalya. Aburrajukwaba wurrumurndakibina wurrumemberrkwa wurrambilyuma warnikabuburrakiyuwa ena-langwa nawurraki-likenuma enuwa-manja wurrakina-da. ");
INSERT INTO aoi_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Ebina-wiya ngawa nakine-ka Jesus neni-jadijuwama wurruwurrariya wurramukwa wurrukwala-langwa wurridarringka. Umba nen-eningabakama wurrukwala angbilyuwa-langwa nakina. Arngkawura neni-jadijuwama Jesus wurrumangbala wurrambilyuma wurramukwa wurruwurrariya duwilyaba-langwa didarringka dadimikirra Meri. Aburraja narringa-yengbijuwama dakina Meri DadinguMakidala, mena ngala-langwa angalya Makidala akina-baba. Kembirra wurrumurndakakine-ka wurridarringka namurndaki-likenuma aburrajukwaba Jesus-manja wurrakina. ");
INSERT INTO aoi_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Ngalajukwaba duwilyaba dingka didarringka yingi-likenuma dadimikirra Jawena. Umba eneja ngala-langwa neningiyadikba nenimikirra Juja. Naruma nakina nenungkwarba nibina nenuminu-war•duwar•danguma warka Nubungkawa-langwa Yerida. Akwa ngawa ngalajukwaba yingi-likenuma duwilyaba dingka didarringka dadimikirra Jujena. Wurrumurndakakine-ka wurrababurna wurridarringka nawurraki-likenuma Jesus-manja akwa ena-langwa-manja warnikabuburrakiyuwa. Narru-wilyakame-ka aninga iya angwarnda aburra-langwa, kajungwa warnik-akwurraji-yada wurrumurndakakina-manja warnungkwarba, akwa warniku-kwi-yada aninga-da. ");
INSERT INTO aoi_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Aburraja wurrababurne-ka warnumamalya nawurraki-likenume-ka wurrakina akini-yada ngawa Jesus-uwa engka-langwa iya engka-langwa angalya. Biya kembirra wurruwurrakwulyumida warnumamalya nawurra-murndukwunuma arakba Jesus-manja. Eneja nenu-makama nakina Jesus enena alawudawarra aburruwa-wa. ");
INSERT INTO aoi_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","Nuwilyaba nenungkwarba numinakina angalya ni-lyangkuwerribikajungwunuma nakina neniki-lungkuwabiji-yada akina amadidira amaninga eyukwayuwa. Nakina nenungkwarba n-akumarnuma amadidira amaninga embimbirrkaluwa ena-langwa-manja beka, biya ni-likena arakba. Biya ni-likenu-manja lukwakwa nakina ena-langwa-manja angalya n-errikbeyinuma arakba amurndakakina amadidira ajiringka-wa. Erribirra numurndak-arrijakama angerriba iya angerriba, ka-lungkuwarrini-yada akina aninga. N-errikbeyinu-manja lukwakwa amurndakakina amadidira, ngalaja akwala ne-ngkilarreyinuma mamurukwa-manja. Kembirra arngkidarrba-langwiya aburraja warnumamalya na-likenu-manja wurrakina narr-embirrkingalyilyakama ebina amadidira amaninga. Kembirra aburraja wurrajija nuw-angkirreyinuma akwa narr-embirrkumanguma, akwa nuw-alyubarinuma amurndakibina embimbirrkamamuwa amaninga. ");
INSERT INTO aoi_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Umba ngalaja amadidira akwala ne-ngkilarreyinuma akina amurndurrkangwarnda-manja ajiringka. Kembirra na-lingbijangeyinu-manja amurndakakina na-lungkwardadinuma akina engburingka-baba ajiringka. ");
INSERT INTO aoi_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Umba ngalaja akwala ne-ngkilarreyinuma akwurrirra-langwa-manja angalya awurruwurrakuwilyarra. Ngalaja kembirra amurndakakina akwurrirra akwa ngawa ebina amaninga amarda na-lingbijanginuma aburrunguwa alirrakidirrbura. Kembirra akwurrirra akwa ngawa akina amaninga amarda na-lungkuwarreyinuma adidirrbura. Akena angwurra akwurrirra na-lungkuwarrinuma warenja, akwa kembirra naminu-mar•danguma angalya. Ngalaja kembirra ebina amaninga amarda nara ka-lungkuwarrina angwurra, akwa nara kuw-arrangba aninga. ");
INSERT INTO aoi_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Umba ngalaja akwala amadidira ne-ngkilarreyinuma eningabu-wa ajiringka. Kembirra na-lingbijanginuma akwa na-lungkuwarreyinuma. Biya kembirra nuw-arrangbama arakba aninga ababurna akine-ka-da. Ena-bu ngawa alawudawarra-da. Ene-ka alawudawarra nakina Jesus nenu-makama wurrumurndakibina-manja warnumamalya. Biya kembirra nenu-makama arakba nakina enena engbuda eningarija-langwa ayakwa aburruwa-wa. “Yiki-yakuwerribikinama ambaka-langwa akinu-wa alawudawarra ngarra-maka-murruwa,” ni-yama Jesus. “Umba yik-awiyebajina-manja akina nungkwurra-langwu-wa mada, nara kembirra a-jadijuma mungarrkuwarru-wa mada akwa a-lyikbijuma akina ayakwa umba yiki-yakuwerribikaja ngawa ambaka-langwa amurndakakinu-wa,” ni-yama Jesus nenu-makama wurrumurndakibina-manja warnumamalya-da. ");
INSERT INTO aoi_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Aburraja Jesus-langwa warnikabuburrakiyuwa namurndaki-yama wurrakina enuwa-wa, “Ne-yamarrkiname-ka enena alawudawarra?” ne-yama. ");
INSERT INTO aoi_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Kembirra ni-yama Jesus aburruwa-wa, “Akine-ka ayakwa Neningikarrawara-langwa kinu-bungkawadina-mulangwa nakina nuw-abuwarrkajungwunuma adinuba-wiya akina. Umba kirrenu-mukangbijuwama eneja Neningikarrawara arakba nungkwurruwa-manja. Umba aburraja wurrukwala warnumamalya kuw-engkirrikajama ayakwa alawudawarra-murra. Mama wurrakina kuw-andiyama akena nara wurrakina a-rringkama-da, akwa mama kuw-engkirrikajama akena nara akburranguma wurrakina-da,” ni-yama Jesus ena-langwu-wa warnikabuburrakiyuwa-da. ");
INSERT INTO aoi_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Biya neni-dirrburakama arakba Jesus ena-langwu-wa warnikabuburrakiyuwa ebina-langwa alawudawarra. Ni-yama, “Amurndakibina eyukwayuwa amaninga amadidira Neningikarrawara-langwa wuburra ayakwa ke-yaminama akina. ");
INSERT INTO aoi_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Umba aburraja wurrukwala warnumamalya kuw-engkirrikajama ayakwa Neningikarrawara-langwa, akena eneja nakina Namukwa kini-likajama akwa kenu-murrakajinama amurndakibina Neningikarrawara-langwa ayakwa aburra-langwa-langwa mangma. Kembirra ke-yaminama wurrakina warnumamalya wuburra amurndakibina amadidira amaninga ne-ngkilarreyinuma mamurukwa-manja. Umba eneja Namukwa kini-yaminama nakina wurrajija wuburra wurribina narru-menama amurndakibina amadidira. Kenu-murrakajinama Namukwa ayakwa Neningikarrawara-langwa wurrumurndakibina-langwa warnumamalya kajungwa nari-yada eningmiduma wurrakina ebina ayakwa eningaba akwa nari-yada a-werrikambilyuma Neningikarrawara-manja, akwa nari-yada Neningikarrawara enibikama wurrakina-da. ");
INSERT INTO aoi_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","“Aburraja wurrukwala warnumamalya kuw-engkirrikajama aburrajukwaba Neningikarrawara-langwa ayakwa akwa ke-yekirrerridinama, karru-menama akina ayakwa aburra-langwu-wa mangma. Akena nara ngalaja ambilyuma akina ayakwa amiyerra aburruwa-manja. Ka-werrikambilyama wurrakina aduwaya-wiya Neningikarrawaru-wa. Akena Namukwa keni-labaja-manja wurrakina-manja warnumamalya kembirra nara arakba a-werrikambilyuma wurrakina Neningikarrawara-manja. Wurrakine-ka kembirra warnumamalya ke-yaminama wuburra amurndakibina amadidira ne-ngkilarreyinuma amurndurrkangwarnda-manja ajiringka. ");
INSERT INTO aoi_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","“Aburraja wurrukwala warnumamalya kuw-engkirrikajama ayakwa Neningikarrawara-langwa aburrajukwaba wurrakina, akena ka-werrikawarriyadiname-ka awinyamba-langwa wurrakina akwa kuw-engkingkirrikajama angwarndu-wa iya amurndakijiku-wa akwa abadakalyu-wa. Ngalaja amukwiyadakina ka-likajama angwurra aburra-langwu-wa mangma, akwa ka-jadijinama ayakwa Neningikarrawara-langwa aburra-langwa-langwa mada. Wurrakine-ka warnumamalya ke-yaminama kembirra wuburra amurndakibina amadidira ne-ngkilarreyinuma akwurrirra-manja akwa na-lingbijangeyinuma, biya na-lungkuwarreyinuma akwa nuw-arrangbama aninga, akena nara ka-walyuwadina akina. ");
INSERT INTO aoi_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","“Aburraja wurrukwala warnumamalya kuw-engkirrikajama ayakwa Neningikarrawara-langwa akwa karru-menama karri-lyinginama akina warningamiyerra. Kenumini-yarrkiyarrkuwarakinama wurrakina Neningikarrawara-langwa ayakwa wurriyirrbiyirrba ngawa akwa ke-yaminjaminama eningaba wurrakina warningangkawura. Ke-yaminama kembirra wurrakina warnumamalya wuburra amurndakibina amadidira ne-ngkilarreyinuma eningaba-manja ajiringka akwa na-lungkuwarreyinuma yanda-langwa nuw-arrangbama eningaba aninga akina-da,” ni-yama Jesus ena-langwu-wa warnikabuburrakiyuwa-da. ");
INSERT INTO aoi_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Biya kembirra Jesus ni-yengbina ngarningka ayakwa ena-langwa-manja warnikabuburrakiyuwa akwa wurrukwala-manja warnumamalya aburrajukwaba. Nenu-makama alawudawarra bajananga-langwa. Ni-yama nakina, “Yakuwa yak-abarrakajina-manja bajananga alikira-manja arrawa, yak-akumurnama akina karrawara, kajungwa karri-rringkini-yada warnumamalya eningaba alarradada amungkwurrkbuda. Yak-abarrakajina-manja akina bajananga yalakena nare-ka abuwarrkama akina. Nara akumama yalakena bajikala karrawara akina-manja bajananga akwa ngarningka nara awiyebajuma akina mamukumungkwulinga-manja arrawa. Umba karrawara yak-akumurnama, kajungwa ka-larrkabarrakajini-yada angalya akina bajananga. Kembirra aburraja wurrukwala warnumamalya kuw-awiyebena-manja arrawu-wa alikira-wa karri-rringkinama akina alarradada wurrakina-da,” ni-yama Jesus wurrumurndakibina-manja warnumamalya-da. ");
INSERT INTO aoi_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Biya ni-yama ngarningka nakina Jesus, “Ebina nuw-abuwarrkajungwunama adinuba-wiya aduwaba kuw-abilyerrikajungwunama akina arija-langwa. ");
INSERT INTO aoi_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Kembirra nungkwurraja yik-engkirrikajame-ka ambaka-langwa kirrakina nganyangwu-wa ayakwa aduwaba. Nara amini-yarrkuwurruma umba yikumini-yarrkuwarakinama angwurra ngawa. “Karningerribirre-ka karnumamalya nara-manja amini-yarrkuwurruma nganyangwa ayakwa umba yik-engkirrikaja-manja akina angwurra kirrakina, kembirra yiki-yarrkuwarakinama amurndakibina ayakwa nungkwurra-langwa-manja mangma ngawa. Kembirra nganja ngayuwa ka-mamurikajinama nungkwurruwa-manja kajungwa yik-eningmidini-yada angwurra kirrakina. Umba kirruwilyaba karnumamalya yiki-lyangkiyamina-manja kirrakina, ‘Ningeningma amurndakakina ayakwa,’ akena nara-manja engkirrikuma angwurra kirrakina, umba yikumini-yarrkuwurrena-manja ayakwa nganyangwa, nare-ka ngayuwa a-mamurikajuma kirrakina. Nungkwurraja kembirra yiki-yakuwabijiname-ka kirrakina amurndakibina ayakwa nganyangwa. Aminakina-langwa kembirra yik-engkirrikajame-ka ambaka-langwa nganyangwu-wa ayakwa aduwaba kirrakina-da,” ni-yama Jesus wurrumurndakibinu-wa warnumamalya-da. ");
INSERT INTO aoi_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Bi...ya aburraja Jesus-langwa dirndenikba akwa ngawa warnikukumarnjena ena-langwa na-likenuma wurrakina ebinu-wa alikira Jesus n-ambilyu-murruwa nakina, akena nara kuw-akwudangwukajungwuna wurrakina enuwa-wa mena wurrababurna-baba warnumamalya nuw-ambilyuma yakwujina arrawa. ");
INSERT INTO aoi_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Aburraja nenu-makama kembirra wurrukwala warnumamalya Jesus-manja, “Daka arakba dirndena akwa nenikumarnjena-murriya,” ne-yama wurrakina. “Errekba-manja ngawa nuw-alkayenama warna, umba bu-ngayindenama nungkuwa,” ne-yama-da. ");
INSERT INTO aoi_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Eneja Jesus ni-yama wurrumurndakakinu-wa warnumamalya wurrababurnu-wa, “Daka dirndirrka akwa ngawa narrkuwarrka-murriya arakba-na? Nganja ninginga-yengbijinama dirndirrka dadingerribirra akwa narrkuwarrka-murriya wurribina nara a-yarrkuwurruma Neningikarrawara-langwa ayakwa umba nuw-engkingkirrikajama akina,” ni-yama Jesus aburruwa-wa. ");
INSERT INTO aoi_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Bi...ya arngkawura Jesus ni-likena nakina awurukwu-wa na-kuwabalinu-murruwa adirrungwarna enuwa akwa ena-langwa warnikabuburrakiyuwa. Biya nawurraki-rijawudiyinuma mijiyanga-manja. Ni-yama Jesus, “Nga-likaja arakba, ngarr-aburrungkuwarrukwuna enena akungwa,” ni-yama. Biya narring-arjiyajuwa dumbala wurrakina biya na-likena arakba-da. ");
INSERT INTO aoi_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Ngalaja makina mijiyanga num-angkidikarrinu...wa. Eneja kembirra Jesus nu-mungkwulinga. Ngalaja kembirra adirrariyaba aruma arrirra narrak-akburranga, narraku-wardanga arakba wurrakina. Na-warumajungwunuma arrubude-ka. Ngalajukwaba akungwa na-warumajungwunuma, na-rrangkuwanginuma adirrungwarna, na-ngakarjeyuma akwa nuw-awiyebeyinuma memedirra-wa mijiyanga. Nuw-awiyebeyinuma akwa na-lyangburrukwajuwame-ka makina-manja mijiyanga-da. Kembirra arngkidarrba ka-ngwardinume-ka wurrakina-da. ");
INSERT INTO aoi_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Kembirra aburraja warnikabuburrakiyuwa Jesus-langwa na-lika akwa nenu-mirajangajuwa Jesus-manja. “Bungkawa! Bungkawa!” ne-yama. “Adinuba aku-lkuwarriname-ka ngarna, umba mirajanga!” ne-yama. Eneja Jesus nu-mirajanga, biya ni-yengba ayakwa engbuda akinu-wa arrirra akwa akungwa-wa. “W-erriminja!” ni-yama. Ngalaja kembirra nuw-ar•darra ebina arrirra akwa na-lyurrkwuda arakba akungwa ngalajukwaba-da. ");
INSERT INTO aoi_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Biya Jesus ni-yama ena-langwu-wa warnikabuburrakiyuwa, “Miyambena-burra nungkwurruwa nara a-werrikambilyuma ngayuwa-wa?” ni-yama. Aburraja nawurraki-yakikbijangeyina angwurra wurrakina. Nuw-akbar•dange-ka. “Numiyambena-burra naka nenungkwarba?” ne-yama na-makijeyinuma wurrakina. “Ni-yengbinama ayakwa arrirra-wa akwa akungwa-wa nakina, biya nenakumin-engkirrikajama ngalajukwaba enuwa-wa-da!” ne-yama wurrakina warnikabuburrakiyuwa Jesus-langwa-da. ");
INSERT INTO aoi_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Kembirra Jesus akwa ngawa ena-langwa warnikabuburrakiyuwa narr-aburrungkuwarrukwama arakba akungwa warniki-liki-yada wurrakina aburrungkuwarru-wa engembu-wa Kiraju-wa. Akine-ka angalya aringbirra emikirra Kiraja nuw-ambilyuma aburrungkuwarra akungwa umba Keliliya aburrungkiladada ngalaja nuw-ambilyuma akina. Biya ne-yar•da arakba wurrakina Kiraja-manja. ");
INSERT INTO aoi_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","29","Kembirra ni-rukbijangu-manja Jesus mijiyanga-langwa ariba-wa, eneja nuwilyaba nenungkwarba nubukwaya ni-likena nenu-kwurukwa enuwa-wa. Nakina nenungkwarba numinakina angalya Kiraja, umba nenu-wilyakama enuwa-manja wurrababurne-ka wurramukwa wurruwurrariya. Warningarakba-kiye-ka wurrumurndakakina wurramukwa namurndak-ambilyuma enuwa-manja. Arngkababurna-langwa nen-engkengkarrngarnuma nakina-manja. Aburraja kembirra warnumamalya ena-langwa nen-ararikama nakina ayarrka-manja akwa alika-manja didija-murra. Akena ni-ngkingkarrngarnuma alakina-kiya didija. Aburraja wurramukwa wurruwurrariya neni-yakiyakarnuma arakba engku-wa nara-murruwa alikira iya warnumamalya. Nara dumbala kin-awiyuwiyebena umba neyebirra nakina n-alilikenuma. Nara kin-ambilya arakba angalya-manja umba n-ambilyumurra nakina nara-murrumanja alikira iya warnumamalya. Medirra-manja ngawa nu-mungkumungkwuluma narr-akakumarnu-murrumanja warninikijungwa warnumamalya. Umba n-akwudangwukajungwunu-manja nakina nenungkwarba Jesus-uwa, eneja Jesus ni-yengbina nakina ayakwa wurrumurndakibinu-wa wurramukwa. “Wurri-jadiya!” ni-yama. Akena eneja nenungkwarba ni-likilalinga akwa n-abuluwendingama alyengmilyengma-langwa Jesus-manja. Biya angwurra n-ardanga nakina. “Jesus, Ningkenikuwenikba Neningikarrawara-langwa, ki-yamarrkinama nungkuwa ngayuwa-manja? Nara a-larrkbarjuma ngayuwa umba yi-lalika!” ni-yama. ");
INSERT INTO aoi_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Eneja Jesus ni-yama, “Ningkumiyambena ningkenimikirra?” “Ningene-ka ningenimikirra ngayuwa ‘Ningababurna,’” ni-yama eneja, mena wurrababurna-baba wurramukwa wurruwurrariya nawurrak-awiyebenuma arrawa enuwa-manja. ");
INSERT INTO aoi_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Aburraja wurruwurrariya wurramukwa ne-yama Jesus-uwa, “Marrakba, nara a-larrkuma yirruwa engku-wa, nara a-diduma yarna awurrariya-manja angalya!” ne-yama wurrakina. ");
INSERT INTO aoi_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Umba akina-manja ngawa angalya akwudangwa ngalaja nuw-ambilyuma ababurne-ka bikibiki. Ne-yebiyebukeyinuma aninga angakarjiyinga-manja angalya karrawara amurndakakina. Kembirra wurrumurndakibina wurramukwa ne-yama Jesus-uwa, “Marrakba, yirri-larrkiya amurndakangabu-wa bikibiki,” ne-yama wurrakina wurramukwa Jesus-uwa. Eneja kembirra Jesus ni-lyangkuwama nakina-da. ");
INSERT INTO aoi_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Aburraja kembirra wurrumurndakakina wurramukwa nawurraki-jadinga nakina-langwa nenungkwarba akwa nawurraki-likena amurndakibinu-wa bikibiki. Nuw-awiyebaja arakba arrawa bikibiki-manja-da. Ngalaja bikibiki nuw-angkirreyina angwurra arakba. Nawurraki-dirrirnda angadingidirra-wa angalya akwa arakba namurndaku-ngwur•dirruwajungwa akungwa-manja akwa na-jungweyina-da. ");
INSERT INTO aoi_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Aburraja warnungkwarba wurribina narr-embimbirrajuwa-murrumurra bikibiki narri-rringkamurra nuw-angkirreyinuma akungwa-wa akwa na-ngwur•dirruwajungwunuma akina akungwa-manja akwa na-jungweyinuma. Kembirra nuw-angkirreyina wurrakina akwa narra-maka wurrukwala-manja warnumamalya wurribina nuw-ambilyu-murrumanja angalya-manja aminababurna-murrumanja alikira akwa ngawa nuw-ambilyu-murrumanja wurreyebijeba ambumbawura-manja alikira. ");
INSERT INTO aoi_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Aburraja kembirra wurrababurne-ka warnumamamalya namurndaki-likenuma ebinu-wa angalya bikibiki na-jungweyinu-murruwa. Biya namurndaki-yar•da arakba Jesus-manja akwa nen-akburranga nibina yakwujina nenungkwarba nen-angmungmakayanguma Jesus aburnuwa. Nakine-ka nibina-murrada nenungkwarba n-eningabaduma akena n-awiyebenuma arakba dumbala nakina akwa n-engkirrikenuma Jesus-langwa ayakwa, mena-baba meningaba arakba mangma ena-langwa. Aburraja warnumamalya namurndak-akbar•danguma. ");
INSERT INTO aoi_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Umba aburraja wurribina narr-embimbirrajuwama bikibiki, akwa narri-rringkamurra amurndakibina bikibiki na-jungweyinuma akina, narra-maka wurrumurndakakina-manja warnumamalya n-eningabadu-mulangwa nibina nenungkwarba. Narra-makama ayakwa Jesus nen-eningabaka-mulangwa nakina-da. ");
INSERT INTO aoi_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Kembirra wurrababurne-ka wurruminakina angalya WarningiKiraja warnumamalya ne-yama Jesus-uwa, “Wu-lalika enena angalya yirra-langwa akwa likaja engku-wa,” ne-yama, mena-baba nuw-akbar•danguma angwurra wurrumurndakakina warnumamalya wurrababurna-langwa. Kembirra eneja Jesus ni-rijawudija mijiyanga-manja neniki-liki-yada nakina. ");
INSERT INTO aoi_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Akena eneja nakina nenungkwarba nibina n-eningabaduma arakba ni-likena Jesus-uwa akwa nen-ambudirrka. “Marrakba,” ni-yama, “yakuwa?” Jesus eneja neni-larrkama angalyu-wa akwa ni-yama enuwa-wa, ");
INSERT INTO aoi_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Jeyi! Likaja nungkwa-langwu-wa angalya akwa wurra-makina wurrukwala-manja warnumamalya Neningikarrawara ngin-eningabaka-mulangwa,” ni-yama Jesus. Eneja nakina nenungkwarba ni-likena arakba nenumurndaku-maka WarningiKiraja-manja warnumamalya Jesus nen-eningabaka-mulangwa nakina. Ni-likenuma ngawa mababurna-manja mamurukwa awilyuwilyaba-wiya-wa alikira akwa yanda-langwa wurrababurna-langwa WarningiKiraja warnumamalya warningma arakba ayakwa ena-langwa. Umba eneja Jesus akwa ena-langwa warnikabuburrakiyuwa narri-lalika akina angalya akwa na-likena arakba-da. ");
INSERT INTO aoi_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Biya Jesus akwa ena-langwa warnikabuburrakiyuwa narr-aburrungkuwarrukwama ngarningka akungwa akwa na-lawurradinuma Kiraja-langwa angerriba Keliliyu-wa. Aburraja warnumamalya wurruminakina angalya Keliliya nuw-embimbirrarinuma ngawa Jesus-uwa warnungkwurakba. Ni-yar•du-manja kembirra nakina Jesus, na-lyelyingmeyinuma wurrakina neni-rringka-mulangwa. ");
INSERT INTO aoi_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Eneja nubukwaya ni-likena nuwilyaba nenungkwarba nenimikirra Jaraja. Nubungkawa nakina jinikakwa-langwa. Biya n-abuluwendinga Jesus-langwa-manja alika akwa nenu-marrakbakama Jesus-uwa akwa ni-yama, “Marrakba, kwa, likaja nganyangwu-wa alikira,” ni-yama, ");
INSERT INTO aoi_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","“mena nganyangwa dadiyawarrka ying-angbilyuwadinu-mubaba ajungwa akwa dambawura-murra-baba dakina. Mememberrkwa mambilyuma mamarika iya yinungkwura ying-ambilyuma dakina akena dadiki-jungwangene-ka arakba,” ni-yama. Eneja kembirra Jesus ni-likena nakina aburnuwa Jaraja ena-langwu-wa alikira. Aburraja wurrababurne-ka warnumamalya namurndaki-likenuma Jesus-manja aburrajukwaba akinu-wa alikira. Akwudangwa Jesus-manja namurndaki-likenuma wurrakina, namurndaki-lyibilyidanguma wurrumurndakakina, nenu-kwurdakama Jesus-manja lukwakwa. ");
INSERT INTO aoi_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Ngalaja duwilyaba didarringka yingi-likenuma aburruwa-manja. Angbilyuwa dakina dadinungkwurakba. Mememberrkwa mambilyuma mamarika iya yinungkwura yingi-jungwunuma angbilyuwa dakina, mena-baba merra ngala-langwa numu-kwularrinuma miyirrbiyirrba ngawa. Aburraja wurrababurna warnumamalya narringa-mamurikajuwama dakina akina-langwa angbilyuwa akena nara ngalaja king-adingabadina dakina. ");
INSERT INTO aoi_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Biya wurrumurndakibina-manja warnumamalya yingi-likenuma dakina mamurukwa-langwiya, biya ying-akwudangwukajungwa Jesus-uwa akwaburrangarna-langwa, akwa yinginumin-anjalkilyingama dibina dumbala Jesus-langwa dadumakirnda-manja ying-anjaljalangu-murrumanja. Akwa kembirra arngkawura-wiya ngalaja merra ngala-langwa numu-ngwanja, nara arakba kumu-kwularrina. ");
INSERT INTO aoi_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Eneja Jesus ni-yama wurrumurndakibinu-wa warnumamalya, “Angkaburra bi-lyingama?” ni-yama. Aburraja wurrababurna-langwa warnumamalya nuw-edirremeyina. Eneja Bida ni-yama, “Bungkawa, wurrababurne-ka warna warnumamalya nungkuwa-manja akwudangwa bu-minjirrarjinama,” ni-yama. ");
INSERT INTO aoi_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Umba eneja Jesus ni-yama, “Wurruwilyaba warnumamalya bi-lyingama. Ningeningma nganja mena-baba akwala amawurrina nganyangwa na-likenuma ngayuwa-langwa wurrakinu-wa,” ni-yama. ");
INSERT INTO aoi_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Ngalaja dibina didarringka dadingma nara king-abuwarrkajungwuna. Yingu-murndaburrirridanga dubukwaya yingi-likena alyengmilyengmu-wa, biya ying-abuluwendingama ying-engmudirruwajungwunuma dadumukwurra ajiringka-manja n-arjeyu-murrumanja Jesus. Biya yingi-yengbina ayakwa Jesus-uwa, kajungwa warnik-engkirriki-yada aburrajukwaba warnumamalya ayakwa ngala-langwa. Kembirra yinginu-maka dakina Jesus-manja yingini-lyinga-mulangwa nakina, mena-baba angbilyuwa dakina, akwa ying-adingabadu-mulangwa arakba dakina arngkawura-wiya yingini-lyinga-manja Jesus. ");
INSERT INTO aoi_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Eneja ni-yama nakina Jesus ngaluwa-wa, “Ngeniyerriya nungkuwa, nara a-werrikawarriyaduma. Ningku-werrikambilyuma ngayuwa-manja ningkakina, kembirra aminakina-langwa ningk-adingabaduma arakba. Jeyi! Likaja yiningaba-murra yukwudukwuda,” ni-yama. ");
INSERT INTO aoi_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Ni-yengbinu-manja Jesus ayakwa ngaluwa-wa, eneja nubukwaya ni-likena nuwilyaba nenungkwarba Jaraja-langwa-langwa alikira. Biya ni-yama Jaraju-wa, “Dadiyawena nungkwa-langwa arakba yingi-jungwuma adinuba. Mama arakba, ni-lalika naka nubungkawa, nara a-likama nakina nungkwa-langwu-wa alikira,” ni-yama. ");
INSERT INTO aoi_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Umba eneja Jesus n-engkirrika akina ayakwa akwa ni-yama Jaraju-wa, “Nara akbar•duma, umba eningmidina amandangwa dakina king-adingabadinama,” ni-yama. ");
INSERT INTO aoi_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Biya Jesus akwa wurrababurna-langwa warnumamalya na-likena ngawa wurriyirrbiyirrba Jaraja-langwu-wa alikira, biya ne-yar•da arakba wurrakina. Biya Jesus nen-awiyebaja Bida iya Jaminja iya Janjana iya Jaraja akwa ngalajukwaba dadingiyenikba Jaraja-langwa alikira-wa arrawu-wa, umba nara wurrukwala warnumamalya ken-awiyebajuwa nakina. Ni-yama Jesus wurrumurndakibinu-wa warnumamalya, “Nara awiyebuma kirrukwala arrawu-wa umba yelakwa wurr-ambilya errekba-manja-wiya,” ni-yama. ");
INSERT INTO aoi_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Aburraja wurrababurna-langwa warnumamalya akina-manja angalya na-ngwadeyinume-ka namurndaki-ringirriyadinume-ka wurrakina warnumamalya dibina-langwa dadiyara. Umba ni-yama Jesus aburruwa-wa, “Nara a-ngwaduma mena nara kingi-jungwuna dadingangkawura dakina, umba yanda yingu-mungkwulingame-ka marringa daka aduwaya,” ni-yama Jesus-da. ");
INSERT INTO aoi_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Umba aburraja warnumamalya nenu-wurrumalyakama nakinu-wa Jesus, mena warningma-baba dakina amandangwa yingi-jungwuma. ");
INSERT INTO aoi_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Akena eneja Jesus n-awiyeba arrawu-wa akwa ni-rndarrka ayarrka ngala-langwa akwa n-ardinga ngaluwa-wa. “Mirajanga!” ni-yama. ");
INSERT INTO aoi_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Ngalaja ngala-langwa amawurrina na-lawurradina ngaluwa-wa, ying-enibuda arakba dakina-da yingi-jungwu-murrada-da. Arngkawura-wiya ngawa yingu-mirajanga-da. Umba Jesus nenu-maka ngala-langwu-wa warnumamalya. “Wurringa-kwuna aninga king-alyubarini-yada arakba,” ni-yama nakina-da. ");
INSERT INTO aoi_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Aburnaja nungwadikba akwa dirndadikba neni-yakikbijangeyine-ka ying-enibudu-mulangwa dakina diyukwujiya. Eneja Jesus ni-yama wunalakina-kiya-wa, “Nara a-makuma wurrukwala-manja warnumamalya ninging-enibika-mulangwa daka ngayuwa,” ni-yama Jesus wunalakina-kiya-wa nakina-da. ");
INSERT INTO aoi_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Biya kembirra Jesus nenuwurra-murndukwama arakba ena-langwa warnikabuburrakiyuwa wurrumemberrkwa wurrambilyuma akwa nenu-kwama ena-langwa amawurrina kajungwa wurringbudi-yada wurrakina. Ni-yama Jesus aburruwa-wa, “Ngayuwa ke-ngbudirrkinama kirrakina, kajungwa yika-jadijini-yada wurramukwa warnumamalya-langwa akwa yikamurndak-eningabakini-yada angbilyuwa-langwa warnumamalya,” ni-yama Jesus aburruwa-wa. ");
INSERT INTO aoi_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","“Kembirra jeyi!” ni-yama. “Wurri-likaja arakba angerriba. Yika-makina wurrababurna-manja warnumamalya kinu-bungkawadina-mulangwa Neningikarrawara. Akwa ngarningka yik-eningabakini-yada warningerribirra wurrangbangbilyuwa-murra warnumamalya angbilyuwa-langwa. ");
INSERT INTO aoi_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Wurri-likaja arakba, akena nara a-wilyakama amurndakijika. Arnduwarra nara a-wilyakama iya kayuwa iya aninga akwa angwarnda nara a-wilyakama. Akwa duwilyaba-ma ngawa dumbala dadingikarrawara yik-awiyebenama, umba nara a-wilyakama dukwala. ");
INSERT INTO aoi_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","“Biya kembirra yiki-yar•diya-manja kirrakina awilyaba-manja angalya, akwa yikab-ardijina-manja wurrukwala warnumamalya akwa yikab-awiyebajina-manja kirrakina alikira-wa wurrakina, kembirra yakwujina ngawa yiku-mungkwula marringa. Awilyaba-manja ngawa alikira yiku-mungkwula yanda-langwa yiki-lalikina-manja akina angalya aburra-langwa. ");
INSERT INTO aoi_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Umba yiki-yar•diya-manja eningerribirra-manja angalya akwa ka-warena-manja nungkwurruwa wurruminibina angalya warnumamalya, kembirra yiki-lalikinama akina angalya aburra-langwa. Akwa yiki-jadena-manja nungkwurruwa akina-langwa angalya, yiku-wurrena ajiringka ebina kuw-ar•dirrenama nungkwurra-langwa eningalika. Yiku-wurrenama akina kajungwa wurrumurndakibina warnumamalya warningmi-yada wurrakina yika-lalikinama kirrakina karningangkawura arakba. Yika-wilyakajinama nungkwurruwa wurrumurndakakina-manja warnumamalya ka-warena-mulangwa nungkwurruwa wurrakina akwa ka-warena-mulangwa Neningikarrawara enejukwaba,” ni-yama Jesus ena-langwu-wa warnikabuburrakiyuwa. ");
INSERT INTO aoi_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Aburraja namurndaki-likenuma arakba wurrakina engku-wa iya engku-wa angalya warniku-maki-yada wurrakina warnikabuburrakiyuwa wurrumurndakakina-manja warnumamalya eningaba ayakwa Neningikarrawara-langwa-langwa, akwa warnik-eningabaki-yada warnumamalya wurribina wurrangbangbilyuwa-murra-da. ");
INSERT INTO aoi_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Bi...ya eneja Yerida, nibina nu-bungkawadinuma akina-manja angalya Keliliya, n-engkirrikenuma nakina ayakwa warnumamalya na-lyelyimbukweyinuma wurrakina Jesus-langwa. Wurrakine-ka na-makijeyinuma amurndakibina-langwa ni-yama-mulangwa Jesus akwa ngawa amurndakibina-langwa ayakwa ni-yengbinu-mulangwa nakina warnumamalya-manja. Umba nakina Yerida nara kinu-mumiringka ayakwa ebina ne-yengbeyinuma, mena wurrukwala-baba ne-yamama, “Janjana Nenikumingekingambaja n-enibuduma ni-jungwu-murrada nakina-da.” ");
INSERT INTO aoi_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Umba aburraja ne-yamama wurrukwala, “Eliye-ka dukwa nakina ni-yar•duma yelakwa.” Umba aburraja ne-yamama wurrukwala, “Nuwilyaba NuBurabuda nibina ni-jungwu-murrada arakburakba-kiya-wiya naka-bina dukwa-da n-enibuduma-da.” ");
INSERT INTO aoi_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Nara kinu-mumiringka eneja Yerida n-engkirrikenu-mulangwa akina ayakwa ne-yengbeyinuma na-lyelyimbukweyinuma wurrakina. Umba ni-lyangkiyama nakina, “Ne-yamarrkiname-ka amurndakakina ayakwa? Ningenu-makama nuwilyaba-manja nawinyamba nganyangwa akwa eneja nenumini-ngkarrngarnuma aringka Janjana-langwa arakba-da! Numiyambena-langwa nenungkwarba kembirra na-lyelyimbukweyinama wurrakina?” ni-yama nakina Yerida ni-lyangkumakajungwunuma-da. Kembirra neni-ngayindanguma angwurra nenumin-aburangkama neniki-rringki-yada Jesus ena-langwa-murra menba-da. ");
INSERT INTO aoi_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Aburraja kembirra namurndaki-lawurradina arakba wurrumurndakibina warnikilarrkilarrka warnungkwarba Jesus-langwa enuwa-wa. Biya nenu-maka wurrakina Jesus-manja ababurna-langwa ne-yama-mulangwa amurndakakina. Eneja kembirra Jesus nenu-wilyaka wurrakina angerriba engembu-wa Bejeda. Nenu-wilyakama wurrumurndakakina wulkwa, umba nara wurrukwala kenu-wilyaka nakina Jesus. ");
INSERT INTO aoi_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Aburraja wurrukwala warnumamalya nuw-engkirrikama ayakwa nakina Jesus ni-likenu-mulangwa angerriba Bejedu-wa akwa nuw-arijidinuma enuwa-wa wurrakina arija-langwa. Kembirra wurrakina nen-akburranga arakba nakina wilyarra. Eneja Jesus nara kinu-minangkirreyina wurrakina umba ni-yengbina ayakwa aburruwa-manja kinu-bungkawadina-mulangwa Neningikarrawara, akwa nenumurndak-eningabaka nakina wurribina wurrangbangbilyuwa-murra warnumamalya. ");
INSERT INTO aoi_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Kembirra na-larruwurada arakba, numa-merrimerrkbalina mamawura. Aburraja wurrumurndakibina warnikabuburrakiyuwa wurrumemberrkwa wurrambilyuma Jesus-langwa na-likena enuwa-wa. Ne-yama, “Ene-ka angalya eningalikira-ma. Kembirra wurra-larrkaja arakba wurrumurndakenena warnumamalya. Abu-likaja arakba kajungwa kuw-alyubarini-yada aninga akwa ka-mungkwuli-yada marringa amurndakeyina-manja angalya yenjerra,” ne-yama. ");
INSERT INTO aoi_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Eneja Jesus ni-yama aburruwa-wa, “Nungkwurruwe-ka-dangwa wurra-kwuna aninga kuw-alyubarini-yada warna warnumamalya,” ni-yama. Aburraja ne-yama, “Yarne-ka yirru-wilyakinama amangbala damba akwa ambilyuma akwalya umba nara akwala ebina-da. Nare-ka yarna a-kwama wurrumurndakeyina wurruwurrakwulyumida warnumamalya enena aninga-da. Dukwa yirrumini-ngayindenama nungkuwa yarna yiki-likajama yiku-beyindenama aninga wurrumurndakeyina-langwa wurruwurrakwulyumida warnumamalya-da?” ne-yama. ");
INSERT INTO aoi_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Aburraja wurrakina warnumamalya yakwujina nuw-ambilyuma wurruwurrakwulyumide-ka na-lyimberrumur•dinumurra, 5,000 warnungkwarba akwa ngawa wurridarringka akwa wurriyukwayuwa aburra-langwa aburrajukwaba. Eneja kembirra ni-yama Jesus ena-langwu-wa warnikabuburrakiyuwa, “Wurr-ambarrijina ab-angmakayena ajiringka-manja. Abuwurra-murndukwuna 50 yelakwa, 50 angakuba, umba 50 yada-langwa-langwa. Abi-yamina ngawa wurrumurndakenena warnumamalya wurruwurrakwulyumida-langwa,” ni-yama Jesus. ");
INSERT INTO aoi_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Kembirra aburraja warnikabuburrakiyuwa ena-langwa narra-maka wurrumurndakibina-manja warnumamalya ebina-langwiya ayakwa Jesus-langwa. Akwa kembirra aburraja nuw-alambarringa arakba wurrakina wurrababurna-langwa-da. ");
INSERT INTO aoi_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Eneja kembirra Jesus ni-rndirrka ebina amangbala damba akwa ambilyuma akwalya. Akwa nu-ngwundikadinga, angubina-wa n-andeya, akwa neni-yangmarngkwajuwa Neningikarrawara nenu-kwa-mulangwa nakina ebina damba iya akwalya wurrakina-manja. Biya numurndaku-kuwarranga kembirra ebina eyukwayuwa-wiya-da. Akwa nenu-kwa akina damba iya akwalya ena-langwu-wa warnikabuburrakiyuwa, kajungwa aburramba-langwa warniku-kwi-yada akina wurrumurndakibinu-wa warnumamalya-da. ");
INSERT INTO aoi_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Aburraja ne-yebukeyina arakba-da akwa namurndaki-ladinga wurrababurna-langwa-da. Ngalaja yakwujina adirrungwarna angarumungkwa alabura nuw-ambilyuma akina. Kembirra wurrumurndakibina warnumamalya narruwurra-murndukwama amurndakibina eyukwayuwa aninga narri-lalika-mulangwa nuw-eyijinu-murrada wurrakina. Aburraja Jesus-langwa warnikabuburrakiyuwa narr-akumarnuma amurndakakina ebina-manja adirrungwarna angarumungkwa alabura akina aninga. Kembirra ememberrkwa ambilyuma angarumungkwa alabura adidirrungwarna na-lyangburrukwunuma-da. ");
INSERT INTO aoi_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Bi...ya arngkawura eneja Jesus nakina nakwukawura n-ambilyuma akwa nu-buriyaminuma Neningikarrawaru-wa. Aburraja wurrubukwaya na-likena arakba enuwa-wa ena-langwa warnikabuburrakiyuwa. Umba Jesus ni-yama aburruwa-wa, “Na-lyelyimbukweyinu-manja warnumamalya, ningumiyambena ningena ne-yamama wurrakina?” ni-yama. ");
INSERT INTO aoi_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Aburraja ne-yama wurrakina Jesus-uwa, “Wurrukwala warnumamalya ne-yamama, ‘Nakine-ka Janjana, nibina Nenikumingekingambaja-da.’ Umba aburraja wurrukwala ne-yamama wurrakina, ‘Eliye-ka nakina-da.’ Aburraja wurrukwala ne-yamama, ‘Nuwilyabe-ka NuBurabuda nenungkwarba neningarakba-kiya n-enibuduma arakba nakina-da,’” ne-yama. ");
INSERT INTO aoi_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","“Umba nungkwurraja?” ni-yama eneja Jesus aburruwa-wa. “Ningumiyambena ngayuwa kirri-yaminama?” ni-yama. Eneja Bida ni-lawurrakaja ayakwa. “Nungkuwe-ka ningkubungkawa ningkibina Neningikarrawara ni-yengbinu-mulangwa nakina arakburakba-kiya-wiya,” ni-yama. “Ni-yamama nakina Neningikarrawara, ‘Ngayuwe-ka ningena ningeniki-larrka nuwilyaba nenumamalya kajungwa ken-enibikini-yada nakina nganyangwa warnumamalya,’ ni-yamama. Kembirra nungkuwa-bina ningkakina ningkenumamalya ningkenimikirra NingkuMejaya-da,” ni-yama Bida nakina-da. ");
INSERT INTO aoi_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Eneja ni-yama Jesus ena-langwu-wa warnikabuburrakiyuwa, “Nare-ka a-makama warningerribirra-manja warnumamalya ebina Bida ni-yengbinu-mulangwa ayakwa ngayuwa-langwa. ");
INSERT INTO aoi_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Ngayuwe-ka ningena, ningibina-murrada ningi-rukwularrinuma enena-manja angalya, ki-lyandiname-ka angwurra ningena-da. Aburraja wurrarumuruma ngakwurra-langwa akwa ngawa WurruMinida wurrarumuruma ka-warename-ka wurrakina ngayuwa. Aburraja warnikakakirumaka Mawijija-langwa eningarumuruma ayakwa aburrajukwaba ka-warename-ka ngayuwa-da. Kabu-wardenama ningena akena k-enibudinama mabiyakarbiya-manja mamawura ngayuwa-da,” ni-yama Jesus ena-langwu-wa warnikabuburrakiyuwa-da. ");
INSERT INTO aoi_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Kembirra Jesus ni-yengbina ngarningka ayakwa ena-langwu-wa warnikabuburrakiyuwa wurrababurnu-wa. “Kwurruwa-yi!” ni-yama. “W-engkirraja enenu-wa ayakwa ningi-yengbina-murruwa. Karningerribirra karnumamalya yiki-ngayindena-manja yiki-yuwarna-manja ngayuwa-manja, kembirra yiki-yakuwabijina amurndakibina amurndakijika-murriya kirri-ngayindenama umba yiki-lyangkiyamina, ‘Nare-ka! Nara a-ngayinduma amurndakakina arakba,’ yiki-lyangkiyamina kirrakina,” ni-yama Jesus. “Mababurna-langwa marringa nara a-waruma kirrakina karniki-lika-langwa eningerribirru-wa angalya ki-likaja-murruwa ngayuwa. Ngayuwa wuburra yiki-yaminama, mama yiki-lyandinama kirrakina, wuburra laka ki-lyandinama ngayuwa eka-manja ka-mambalina-murrumanja. ");
INSERT INTO aoi_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Nara amin-engkirrikajajungwuma nungkwurra-langwa-langwa, mena-baba yikumin-engkirrikajajungwuna-manja kirrakina, yiku-milkikajungwuna-manja akwa yik-engkingkirrikaja-manja karnik-ambilyinga-langwa karniba karningangkawura, kembirra yiki-jungwunama kirrakina-da. Umba nungkwaja nara-manja a-marrukwajungwuma, mama kabu-wardena-manja wurrukwala warnumamalya nungkuwa-manja, umba yiki-yuwarna-manja ngayuwa-manja akwudangwa, kembirra k-enibudinama ningkeningangkawura ningkakina-da. ");
INSERT INTO aoi_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Umba nungkwaja ku-wilyakina-manja ababurna-langwa eningerribirra amurndakijika eminiminingka amurndakibina ningki-ngayindena-mulangwa, mama k-ambilyama ningkubungkawa ningkaruma ningkilyengma enena-manja angalya, akena nara-manja ebina amamalya akwanenibika nungkwa-langwa, amiyambena kembirra eningaba nungkwa-langwa? Nare-ka ebina eningaba nungkwa-langwa-da! ");
INSERT INTO aoi_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","“Umba karningerribirra karnumamalya yiki-yeliyena-manja aduwaba ngayuwa-langwa akwa ngawa nganyangwa-langwa ayakwa, kembirra ngayamba-langwa kamini-yeliyenama nganjukwaba nungkwurruwa-langwa. Ngayuwa, ningibina-murrada ningi-rukwularrinuma enena-manja angalya, kamini-yeliyenama nungkwurruwa-langwa akini-yada ngawa ki-lawurradina-manja ngayuwa yangkwurrangwa. Ki-lawurradina-manja ngayuwa yangkwurrangwa ku-kwulyadenama ningena ngayabakiya-ba. Akwa ku-kwulyadenama ngarningka Nungwarrka-langwu-ma alarradada. Akwa aburrajukwaba warnikumamurikaja Neningikarrawara-langwa ka-kwulyadenama wurrakina. ");
INSERT INTO aoi_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","“W-engkirraja enena ayakwa ngarra-makinama ningi-larrkbularrkbakinama. Karne-ka kirrukwala karnumamalya yelakwa nara a-jungwuma kirrakina yanda-langwa yikini-rringkina-manja Neningikarrawara kinu-bungkawadina-manja nakina kirrababurna-manja karnumamalya ababurna-langwa angalya,” ni-yama Jesus wurrumurndakibinu-wa warnumamalya-da. ");
INSERT INTO aoi_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Bi...ya ngalaja mamangbala mambilyuma mamawura numu-likenuma makina. Biya kembirra Jesus nenu-wilyakama Bida iya Janjana akwa Jaminja, kembirra nabuki-likenuma nabuku-wurdanguma wurrubukalakina angakarjiyinga-wa angalya, kajungwa kinu-buriyamini-yada nakina Jesus Neningikarrawaru-wa yakwujina. Biya nabuku-wurdanga wurrubukalakina karrawaru-wa. Kembirra arakba nu-buriyaminuma Jesus Neningikarrawaru-wa. ");
INSERT INTO aoi_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","32","Umba aburrubukwurraja Bida iya Janjana akwa Jaminja narrubukuma-ngayindanguma marringa. Akwa nabuku-mungkwulinga maruma marringa wurrubukalakina. Eneja kembirra nu-buriyaminu-wiya nakina Jesus, ni-miningkadinume-ka nenumukwurra. Ngalaja dibina dumbala ena-langwa n-awiyebenuma nakina yingu-kwulyarriyinume-ka arakba dakina. Yingu-kwulyadanguma dukwulyadade-ka wuburra amangwurrajija amarrirla-langwa dakina. Aburnaja kembirra wunambilyuma-kiya wunenungkwarba-kiya neni-jadinga adirrariyaba yakwujina. Biya nabuki-lyelyimbukweyinuma arakba yakwujina aburrubukwurruwa Jesus. Wunalakina wunenungkwarba-kiya wunenimikirra-kiya nuwilyaba nubungkawa Mawijija nakina umba nuwilyaba Eliya, NuBurabuda nenungkwarba nakina. Arakburakba-kiya-wiya neni-jungweyinu-murrada wunalakina, akena Jesus-manja arakba yakwujina wunalakina-da. Akwa nenu-kwulyarriyinume-ka aburnajukwaba wunalakina-kiya. Biya nabuki-lyelyimbukweyinuma wurrubukalakina neniki-jungwa-langwa Jesus Jirujalema-manja. Neniki-jungwi-yada Jesus nakina mena Neningikarrawara ni-lyangkuwerribikajungwunuma akina arakburakba-kiya-wiya. Kembirra aburrubukwurraja Bida iya Janjana akwa Jaminja nabuku-mirajanga arakba, akwa neni-rringka Jesus nu-kwulyarriyinuma nakina. Akwa narralirraki-rringka ngarningka wunalakina wunenungkwarba-kiya Jesus-manja akwudangwa nen-alkayanguma. ");
INSERT INTO aoi_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Aburnaja wuneniki-liki-yada wunalakina wunenungkwarba-kiya Jesus-langwa arakba. Eneja ni-yama Bida Jesus-uwa, “Bungkawa,” ni-yama, “eningabe-ka ena yirrubuk-ambilyama yarna yelakwa-da. Kembirra kamini-ngekburakiname-ka abiyakarbiya amiyerriya, awilyaba nungkwa-langwa, awilyaba Mawijija-langwa umba awilyaba Eliya-langwa-da,” ni-yama nakina Bida. Akena erribirra ni-yengbinuma nakina Bida, mena nara-baba angwurra kin-engkirrikena akinu-wa ayakwa ena-langwa. ");
INSERT INTO aoi_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Awilyaba-wiya ayakwa ni-yengbinu-wiya Bida, ngalaja angubina na-jadinga narrakuwurraku-wurumbija wurrakina-manja yakwujina karrawara angakarjiyinga-manja angalya. Aburrubukwurraja nabuk-akbar•da wurrubukalakina Bida iya Janjana akwa Jaminja narrakuwurraku-wurumbiju-mulangwa akina angubina aburrubukwurruwa-manja akwa ngawa Jesus-manja akwa ngawa wunalakina-manja Mawijija-manja akwa Eliya-manja aburnajukwaba akina-da. ");
INSERT INTO aoi_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Biya nuw-engkirrika arakba amayakwa ne-yengbinuma angaluba angubina-langwa. Ne-yama ngalaja, “Naka Nenikuwarrka nganyangwa, nibina ningu-wekbalyinuma. W-engkirraja enuwa-wa,” ne-yama akina amayakwa. ");
INSERT INTO aoi_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Kembirra ne-yengbinu-mulangwa akina amayakwa, aburrubukwurraja wurrubukalekbina Bida iya Janjana akwa Jaminja neni-rringka Jesus nakwukawura arakba nakina-da. Nara wurribina wurrukwala umba Jesus enuwa yimbukwa neni-rringkama nakwukawura arakba-da. Akena nara karra-maka wurrubukalakina wurrukwala-manja warnumamalya ebina-langwa narri-rringka-mulangwa, umba nabuki-yengminjadinuma, nara ayakwa kabuki-yengbina wurrubukalakina ngawa-da. ");
INSERT INTO aoi_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Biya mingka-manja mamawura Jesus akwa wurrubukalekbina ena-langwa wurrubukabiyakarbiya warnikabuburrakiyuwa nabuki-dirrirnduma arakba ebina-langwa angakarjiyinga. Aburraja wurrababurne-ka warnumamalya nuw-akburranganja wurrakina yakwujina arrawa. ");
INSERT INTO aoi_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Eneja nuwilyaba nenungkwarba n-ardanga nakina Jesus-uwa akwa ni-yama, “Bungkawa, yimini-rringka-langwa naka nenikuwarrka nambawura-murra. ");
INSERT INTO aoi_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Aburraja wurruwilyaba wurruwurrariya wurramukwa nenu-mumenama nakina arngkababurna-langwa. Na-warduwardeminame-ka wurrakina wurramukwa akwa nenu-murndakuwarrijinama nenumadangkwa niyukwujiya-langwa angerriba iya angerriba, kembirra alyukwalya na-jadenama edirra-langwa ena-langwa-langwa. Wurrakine-ka wurramukwa nara a-lalikama naka niyukwujiya umba neni-lyandikiname-ka naka. ");
INSERT INTO aoi_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Nganja ningarra-yendabenuma warnikabuburrakiyuwa nungkwa-langwa karra-jadijuwi-yada wurrakina wurramukwa, akena nara aburraja karra-jadijuwa-da,” ni-yama nibina nungwenikba Jesus-uwa-da. ");
INSERT INTO aoi_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Eneja ni-yama Jesus wurrumurndakibinu-wa warnumamalya, “Karukwa, mukwurrake-ka mangma kirruma-wilyakinama ngawa karna karnumamalya, kembirra nara ambaka a-werrikambilyuma kirrakina ngayuwa-manja. Ngayuwe-ka ningena ning-erriburandiname-ka nungkwurruwa-wa. Ngambi-yade-ka ka-lalikinama ngayuwa nungkwurruwa karnumamalya?” ni-yama Jesus. Biya kembirra ni-yama nakina nibinu-wa nenungkwarba, “Kwa, nu-wilyakina nenikuwena yangkwurrangwa,” ni-yama. ");
INSERT INTO aoi_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Aburnaja neni-likena wunalakina Jesus-uwa akena lukwakwa aburraja wurribina wurramukwa neni-kbilyajanga nakina niyukwujiya ajiringka-wa, akwa nenu-murndakuwarrijuwa nenumadangkwa ena-langwa angerriba iya angerriba. Eneja ni-yengbina nakina Jesus ayakwa wurrakinu-wa wurramukwa. “Jadiya nakina-langwa niyukwujiya,” ni-yama. Ni-yengbinu-wiya nakina Jesus akina ayakwa wurrakinu-wa wurramukwa, kembirra eneja n-eningabaduma arakba nakina niyukwujiya. Kembirra Jesus ni-yama nungwenikba-wa, “Naka arakba nenikuwena n-eningabaduma,” ni-yama. ");
INSERT INTO aoi_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Aburraja wurrababurna-langwa warnumamalya ebina-manja angalya ne-yakikbijangeyinuma angwurra mena Neningikarrawara narrubuda amandangwa nakina-baba-da. Na-makijeyinu-wiya ngawa wurrumurndakibina warnumamalya ababurna-langwa eninginingaba ni-yama-mulangwa Jesus, eneja ni-yengbina nakina Jesus ayakwa ena-langwu-wa warnikabuburrakiyuwa. ");
INSERT INTO aoi_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“W-engkirraja ambaka-langwa enenu-wa ayakwa ka-makina-murruwa ngayuwa nungkwurruwa-wa,” ni-yama. “Yik-awiyebajina-manja enena ayakwa muwilyabu-wa mada, nara a-jadijuma mungarrkuwarru-wa, umba yiku-wilyakinama akina ngawa. Ngayuwe-ka ningena ning-ambilyama ningibina-murrada ningi-rukwularrinuma enena-manja angalya, akena aburraja wurrukwala warnungkwarba kabu-menama, kabu-wilyakinama wurrububungkawu-wa,” ni-yama Jesus aburruwa-wa. ");
INSERT INTO aoi_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Akena aburraja warnikabuburrakiyuwa Jesus-langwa nara karru-mumiringka akina ayakwa ena-langwa wurrakina. Akine-ka ayakwa nuw-abuwarrkajungwunuma kajungwa nari-yada a-mumiringkama wurrakina warnungkwarba. Kembirra nare-ka ke-yama keni-yengkilabena wurrakina, “Ne-yamarrkama ebina ayakwa ningki-yengbinuma?” nara ke-yama keni-yengkilabena, mena namurndak-akbar•danguma angwurra wurrakina-baba-da. ");
INSERT INTO aoi_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Biya kembirra wurrumurndakakina warnikabuburrakiyuwa Jesus-langwa namurndaku-merribeyinuma akwa ne-yama, “Ngarrumiyambena ngarraruma ngarrukwala-manja angwurra? Umba ngarrumiyambena aku-bungkawadinama ngarrukwala-manja ngarnungkwarba?” ne-yama. ");
INSERT INTO aoi_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Eneja Jesus neningma nakina aburra-langwa mangma akwa nen-ardijuwa nuwilyaba niyukwujiya enuwa-wa. Nen-arjiyajuwama nakina enuwa-manja nurukwuwarra-langwa, ");
INSERT INTO aoi_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","akwa ni-yama ena-langwu-wa warnikabuburrakiyuwa, “Karningerribirra karnumamalya yikumin-engkirrikaja-manja ngayuwa-wa akwa yiki-lyelyingmina-manja naka niyukwujiya, kembirra yiki-lyelyingminama kirrakina ngarningka ngayuwa nganjukwaba. Akwa karningerribirra karnumamalya yiki-lyelyingmina-manja ngayuwa, kembirra yiki-lyelyingminama ngarningka Neningikarrawara enejukwaba, nibina ngini-larrkama ngayuwa yangkwurrangwa nungkwurruwa-wa. Kirruwilyaba karnumamalya nara-manja a-ngkweningabakajungwuma kirrakina umba yikaminu-war•dena-manja wurrukwala-langwa warka, kembirra eneja nakina Neningikarrawara kini-yaminama nungkwurruwa-wa, ‘Ningkaruma ningkenumamalya,’ kini-yaminama nakina-da,” ni-yama nakina Jesus aburruwa-wa. ");
INSERT INTO aoi_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Eneja kembirra Janjana ni-yama Jesus-uwa, “Bungkawa,” ni-yama, “yini-rringkama yarna nuwilyaba nenungkwarba neni-jadijuwama wurruwurrariya wurramukwa warnumamalya-langwa. Umba eneja ni-yengbijuwama nakina ekirra nungkwa-langwa. Kembirra yinu-ngwanjajuma mena nara-baba nakina ngakwurra-langwa nenumamalya,” ni-yama Janjana nakina-da. ");
INSERT INTO aoi_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Umba eneja nakina Jesus ni-yengbina ayakwa Janjanu-wa akwa ngarningka ena-langwu-wa wurrukwala warnikabuburrakiyuwa. “A•a, nara a-ngwanjajuma nakina,” ni-yama. “Nara a-ngwanjajuma mena nakina nenumamalya, nibina nara a-waruma nungkwurruwa-manja, kirrenu-mamurikajinama nungkwurruwa nakina-da,” ni-yama Jesus aburruwa-wa-da. ");
INSERT INTO aoi_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Bi...ya ni-lyangkuwerribikajungwunuma arakba nakina Jesus kini-likaji-yada dirrbura Jirujalemu-wa kajungwa nari-yada ambudiduma amiyerra nakina. Num-ambawuradinuma arakba ngalaja mamawura neniki-lawurrada-langwa Jesus Neningikarrawara-langwu-wa angalya abalkayu-wa. ");
INSERT INTO aoi_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Neni-larrkenuma kembirra Jesus wurrukwala warnungkwarba awilyabu-wa angalya aminambawura-murruwa alikira. Akine-ka angalya nuw-ambilyuma Jameriya-manja mibina-manja mamurukwa numu-likenu-murrumanja Jirujalemu-wa makina. Neni-larrkenuma nakina Jesus kajungwa warnik-aburangki-yada wurrakina angalya adinakba nenik-ambilyingi-yada wilyarra nakina. Aburraja na-lyengmanguma wurrakina adinakba umba Jesus akwa ena-langwa warnikabuburrakiyuwa nuw-arijidinuma wurrumurndakakina arija-langwa-da. Bi...ya aburraja ne-yar•da arakba wurrakina warnungkwarba akina-manja angalya aminambawura alikira. Akwa narre-yengkilabena wurrakina warningakwujina warnumamalya alikiri-yada Jesus-langwi-yada akwa ngawa ena-langwi-yada warnikabuburrakiyuwa kajungwa warnik-ambilyingi-yada aduwaya wurrakina yakwujina. ");
INSERT INTO aoi_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Akena aburraja wurruminakina angalya WarningiJameriya warnumamalya namurndaku-waranguma nara ambilyuma Jesus aburra-langwa-manja angalya. Namurndaku-waranguma wurrumurndakakina warnumamalya mena narra-wirrikba-mubaba angwurra warningerribirra-manja WarningiJudiya warnumamalya. Akwa ngarningka warningma wurrakina kini-likajama nakina Jesus Jirujalemu-wa kajungwa nenik-ambarringi-yada nakina Akwurungkuwarrukwa yakwujina-da. ");
INSERT INTO aoi_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Bi...ya aburraja nuw-akburranganja-manja ngarningka wurribina warnungkwarba akwa Jesus akwa ena-langwa warnikabuburrakiyuwa, nenu-makama wurrakina Jesus-manja ebina ayakwa na-warangu-mulangwa Jesus wurrumurndakibina WarningiJameriya warnumamalya. Aburnaja kembirra Jaminja akwa Janjana neni-yama Jesus-uwa arakba, “Bungkawa,” neni-yama, “dukwa ningkakina yirri-ngayindenama yarna yikini-yengkilabajama Neningikarrawaru-wa kajungwa kini-larrkaji-yada nakina angwura angubina-langwa karraki-dakini-yada wurrumurndakeyena WarningiJameriya warnumamalya-da?” neni-yama wunalakina-da. ");
INSERT INTO aoi_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Eneja Jesus ni-yama wunalakina-kiya-wa wunenungkwarba-kiya, “Nare-ka e-yengbuma nungkwurnuwa amukwiyadakina ayakwa kinalakina-da,” ni-yama nakina. ");
INSERT INTO aoi_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Kembirra nara ka-ngwanjina wurrakina Jesus akwa ngawa ena-langwa warnikabuburrakiyuwa akina-manja angalya, umba wurrarrijinungkwa ngawa angwurra namurndaki-likenuma eminingku-wa angalya-da. ");
INSERT INTO aoi_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Biya Jesus akwa ena-langwa warnikabuburrakiyuwa na-likenu-manja lukwakwa wurrakina nuw-akburranganja nuwilyaba nenungkwarba. Eneja ni-yama nakina Jesus-uwa, “Nganjukwaba ki-likajama nungkuwa-manja,” ni-yama. “Yiba-yibiyuwarnama ngawa ngayuwa ababurnu-wa angalya ki-likaja-murruwa nungkuwa ningkakina-da,” ni-yama nakina. ");
INSERT INTO aoi_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Eneja ni-yama Jesus enuwa-wa, “Kwuja, akine-ka warningenimbaluba-langwa edirra aburra-langwa akwa ngawa wurrajija-langwa miyerriya aburra-langwa aburrajukwaba makina. Akena nara ebina angalya nganyangwa-da. Ngayuwe-ka ningena ning-ambilyama ningibina-murrada ningi-rukwularrinuma enena-manja angalya, akena nara ebina angalya nganyangwa kajungwa ningeniku-mungkwulingi-yada ningingkinyungwurra wurrumurndakibina wuburra warningenimbaluba akwa wurrajija wurribina na-mungkwulijeyinama wurringkinyungwurra wurrakina-da,” ni-yama Jesus nibinu-wa nenungkwarba nakina-da. ");
INSERT INTO aoi_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Bi...ya nuw-akburranganja Jesus akwa ena-langwa warnikabuburrakiyuwa nuwilyaba ngarningka nenungkwarba ni-likenuma mamurukwa-langwiya. Biya Jesus ni-yama enuwa-wa, “Kwa, likaja yakuwa, yi-yuwarna ngayuwa-manja,” ni-yama. Eneja nenungkwarba ni-yama, “Nara ambaka, Bungkawa,” ni-yama. “Ngi-likaja-langwa adinuba-wiya angalyu-wa, mena nungwarrka nganyangwa ni-jungwuma arakba. Kini-rungkwabinama adinuba-wiya nenumadangkwa ajiringka-manja, kembirra arija-langwa ki-likajama yiba-yuwarnama ngayuwa nungkuwa-manja,” ni-yama. ");
INSERT INTO aoi_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Eneja ni-yama Jesus enuwa-wa, “Aburraja warnumamalya wurribina nara a-likama Neningikarrawara-langwa-manja mamurukwa aburra-rungkwabina warninikijungwa warnumadangkwa aburra-langwa, mena na-likaja-mubaba aburrajukwaba warninikijungwa wuburra wurrakina. Umba nungkwaja, jeyi, likaja arakba, umba ka-makina warnumamalya-manja, ‘Neningikarrawara kinu-bungkawadini-yada nakina kirrababurna-manja karnumamalya ababurna-langwa angalya,’ ki-yaminama nungkuwa ningkakina-da,” ni-yama Jesus enuwa-wa-da. ");
INSERT INTO aoi_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Eneja nuwilyaba ningka nenungkwarba ni-yama Jesus-uwa, “Bungkawa,” ni-yama, “ningena ngayuwa yiba-yuwarnama nungkuwa-manja, umba adinuba-wiya ngi-likiya-langwa angalyu-wa ngayuwa ka-makini-yada nganyangwa-manja warnumamalya yiba-yuwarna-mulangwa ngayuwa nungkuwa-manja,” ni-yama nakina. ");
INSERT INTO aoi_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Eneja kembirra Jesus ni-yama enuwa-wa, “Nungkwaja yiki-yuwarna-manja ngayuwa-manja, kembirra nara ningkakina errikerruma. K-errikerrina-manja nungkuwa, kembirra ki-yaminama ningkakina nuwilyaba wuburra nenungkwarba ni-ngadingkarrijinama ajiringka. Kin-errikerrina-manja akwaburrangarnu-wa nakina, nara kembirra dirrbura a-likama, umba angerriba iya angerriba kini-likajama kini-yangkwuruwudinama nakina-da. Nakina wuburra nenungkwarba ki-yaminama nungkwaja yimini-yarrkuwarakina-mulangwa aduwaya nganyangwa ayakwa akena yi-lalikina-mulangwa ngayuwa-da. Nare-ka Neningikarrawara a-bungkawaduma kirramukwiyadakina-manja karnumamalya nakina-da,” ni-yama Jesus enuwa-wa-da. ");
INSERT INTO aoi_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Bi...ya Nubungkawa Jesus nu-wekbalyinuma nakina wurrukwala ngarningka warnumamalya. Ni-lyangkuwerribikajungwunuma neniki-liki-yada ababurnu-wa angalya nuw-ambilyu-murruwa alikira iya warnumamalya. Nu-wekbalyinuma nakina 70 warnumamalya kajungwa ka-lyengmeni-yada wurrakina wurrambambilyuma-wiya angerriba iya angerriba amurndakakinu-wa angalya umba kuw-arijidini-yada Jesus akwa ena-langwa warnikabuburrakiyuwa wurrumemberrkwa wurrambilyuma ambaka-murra wurrakina-da. ");
INSERT INTO aoi_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Ni-yengbina kembirra Jesus amurndakenena ayakwa lukwuniyawa aburruwa-wa nara-wiya ka-likena engku-wa. “W-engkirrikiya,” ni-yama Jesus. “Adinuba Neningikarrawara kinu-bungkawadinama nakina. Aburraja warnumamalya warnik-engkirriki-yada wurrababurna Neningikarrawara-langwa ayakwa arakba wurrakina. Kembirra kuw-engkirrikaja-manja nara wurrakina a-waruma ena-langwa ayakwa umba kenumin-engkirrikajama enuwa-wa. Akena nungkwurraja kirribina kinuminu-war•denama Neningikarrawara-langwa warka aduwaba kirrambawure-ka kirrakina-da. Kembirra wuni-yengkilabaja Nubungkawa Neningikarrawara kajungwa keni-larrkaji-yada nakina wurrababurna warnikuminuwar•duwar•da ena-langwa kajungwa kenu-makini-yada ena-langwa ayakwa wurrababurna-manja warnumamalya nakina-da. ");
INSERT INTO aoi_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","“W-engkirrikiya,” ni-yama ngarningka Jesus. “Kuw-akburranganja-manja warningenimbaluba ebina eyukwujiya jiba, enijiyangme-ka awinyamba akina jiba eyukwujiya, wurrabarda-baba awinyamba wurrakina warningenimbaluba. Umba nganja ngarra-larrkajama nungkwurruwa aduwaba akwa akine-ka wuburra eyukwujiya jiba yiki-yaminama kirrakina karnumamalya. Yik-akburrangeyinama kirrakina warnumamalya wurribina wurrabarda awinyamba wurrakina-da.” ");
INSERT INTO aoi_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","5","Biya Jesus ni-yama ngarningka, “Nare-ka a-wilyakama angwarnda iya beka meninganinga akwa eningalika nungkwurruwa-manja, umba erribirra yiki-likaja. Biya yika-rringkina-manja wurrukwala warnumamalya mamurukwa-manja, nara ambudiduma a-lyelyimbukwajuma lukwakwa umba dirrbura yiki-likaja kirrakina ngawa. “Kembirra yikini-yar•diya-manja kinalekbina kinambilyuma-kiya kinenumamalya-kiya awilyaba-manja angalya akwa yikin-awiyebena-manja arrawu-wa alikira-wa kinalakina, adinuba-wiya yikini-yengbina enena ayakwa wurruminakinu-wa alikira. Yikini-yama kinalakina, ‘Yilyurrkwa yukwudukwuda wurr-ambilya,’ yikini-yamina aburruwa-wa. ");
INSERT INTO aoi_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Umba akina-manja alikira kin-ambilya-manja nuwilyaba nenumamalya nibina keni-ngayindenama nakina Neningikarrawara kenumini-lyurrkwakinama yukwudukwuda ena-langwa, kembirra eneja Neningikarrawara kenumini-lyurrkwakinama amandangwa yukwudukwuda ena-langwa. Umba ka-warena-manja wurruminakina alikira warnumamalya nara-manja amini-lyurrkwakama Neningikarrawara yukwudukwuda aburra-langwa, kembirra ngalaja ebina ayakwa nungkwurna-langwa nara akina amini-lyurrkwakama yukwudukwuda aburra-langwa. Umba akine-ka ayakwa nungkwurna-langwa kuw-ambilyama ngawa nungkwurnuwa-manja. ");
INSERT INTO aoi_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Umba yakwujina ngawa ebina-manja alikira yikinu-mungkwula kinalakina. Akwa yikin-alyubarina aninga aburra-langwa akwa yikini-bekina akubibeka yakwujina aburra-langwa. Yiki-yaminjaminama ngawa kirrakina karnumamalya mena yikabu-kwuna-manja wurrakina warnumamalya aninga karnikuminuwar•duwar•da karnumamalya eningaba akina. Nara a-rnjirrkwuma engku-wa iya engku-wa alikira, umba awilyuwilyaba-wiya-manja yik-ambilyama ngawa-da.” ");
INSERT INTO aoi_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Biya Jesus ni-yama ngarningka, “Yikini-likaja-manja nungkwurnuwa eningerribirru-wa angalya,” ni-yama, “akena nara-manja a-waruma kinalakina wurruminakina angalya warnumamalya, kembirra yikin-alyubarina ebina aninga yikabu-kwunama wurrakina, ");
INSERT INTO aoi_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","akwa yik-eningabakina wurrangbangbilyuwa-ma warnumamalya aburra-langwa. Yik-eningabakina warnumamalya angbilyuwa-langwa, akwa yikini-yengbina nungkwurnuwa enena ayakwa wurrumurndakakina-manja wurrababurna-manja warnumamalya. ‘Aduwaba,’ yikini-yamina, ‘yik-eningmidinama kirrakina kinu-bungkawadina-mulangwa Neningikarrawara adinuba nakina-da,’ yikini-yamina kinalakina aburruwa-wa.” ");
INSERT INTO aoi_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Biya Jesus ni-yama ngarningka, “Yikini-likaja-manja kinalakina eningerribirru-wa angalya,” ni-yama, “akena ka-warena-manja kinalakina wurruminakina angalya warnumamalya, kembirra yikini-rijakbina akina angalya aburra-langwa akwa yikini-yengbina lukwakwa enena ayakwa aburruwa-wa. ");
INSERT INTO aoi_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","Yikini-yamina, ‘Enena ajiringka nungkwurra-langwa-manja angalya ebina nuw-ar•dirrenama yina-langwa-manja alika yikinu-wurrenama arakba yinalakena,’ yikini-yamina. ‘Yinuwa yikinu-wurrenama akina kajungwa karningmi-yada yinuwa yinalakena ngarra-lekbajama nungkwurruwa-wa, mena kirru-warangu-mubaba aduwaba ayakwa Neningikarrawara-langwa. Umba w-engkirraja angwurra enenu-wa ayakwa nungkwurraja karnumamalya enena-manja angalya. Aduwabe-ka yik-eningmidinama kirrakina kinu-bungkawadina-mulangwa Neningikarrawara adinuba nakina!’ yikini-yamina kinalakina-kiya aburruwa-wa-da. ");
INSERT INTO aoi_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","“Amandangwa, ngarra-makinama,” ni-yama ngarningka Jesus, “Neningikarrawara keni-lekbajame-ka wurrumurndakakinu-wa warnumamalya meningarija-langwa-manja mamawura. Akini-yada ngawa kini-lyangkuwerribikajungwunama nakina karnumamalya-langwa, karningaba-murrikba akwa kirruwurrariya-murrikba. Nakine-ka keni-lekbajama aburrajukwaba wurrumurndakibinu-wa warnumamalya wurruwurrariya WarningiJaduma, kembirra akini-yada ngawa ka-lyandiname-ka wurrakina warnumamalya. Akena keni-lekbajama nakine-ka Neningikarrawara angwurra wurrumurndakibina warnumamalya wurribina ka-warenama nungkwurra-langwa ayakwa aduwaba, akwa ka-lyandiname-ka angwurra wurrakine-ka-da!” ni-yama Jesus, nenu-makama wurrumurndakibina-manja warnumamalya 70-da. ");
INSERT INTO aoi_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Biya kembirra Jesus ni-yama nakina, “Nungkwurraja karnumamalya KarningiKarajina akwa ngawa KarninguBejeda yiki-yamarrkiname-ka kirrakina?” ni-yama. “Eneja Neningikarrawara yikenumini-ngekburakinama awerrikawarriya awurrariya nungkwurra-langwi-yada. Kirrakine-ka kirri-rringkama arakba engbingbuda amurndakibina Neningikarrawara ni-yama-mulangwa nakina nungkwurra-langwa-manja angalya aduwaba, akena nara yiki-larrngkuwurranga alarrngkilarrngkawarriya kirrakina akwa nara yikinumini-yarrkuwaraka ayakwa Neningikarrawara-langwa-da.” Biya Jesus ni-yama ngarningka, “Aburraja arakburakba-kiya-wiya warnumamalya WarningiDaya akwa WarningiJayidina wurruwurrariya wurrakina nuw-ambilyuma. Wurruwurrariya wurrilyengme-ka. Akena nara wurrakina karri-rringka engbingbuda amurndakakibina ni-yama-mulangwa Neningikarrawara nungkwurra-langwa-manja angalya. Karri-rringka-manja wurrakina ebina eningaba engbingbuda Neningikarrawara-langwa, kembirra karru-wurranguma wurrakina awurruwurrariya umba kenumini-yarrkuwarakama arakba Neningikarrawara-langwa ayakwa wurrakina. Warenja-bawiya kuw-awiyebeyinuma duwurruwurrariya dumbala dibina narringa-ngekburakama nenukwuda-langwu-ma amangwurrajija, akwa kuw-ambarrinuma ajiringka-manja amarnina-manja. Akine-ka ke-yamama wurrakina kajungwa neningmi-yada Neningikarrawara narri-larrngkuwurrangu-mulangwa alarrngkilarrngkawarriya umba nenumini-yarrkuwarakinuma Neningikarrawara-langwa ayakwa arakba wurrakina-da,” ni-yama nakina. ");
INSERT INTO aoi_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Biya Jesus ni-yama ngarningka, “Meningarija-langwa-manja mamawura eneja Neningikarrawara keni-lekbajama amandangwa wurrumurndakibina warnumamalya WarningiDaya-manja akwa ngawa WarningiJayidina-manja, wurruwurrariya-baba wurrakina. Umba yikeni-lekbajama nakina angwurra kirrakina karnumamalya KarningiKarajina akwa KarninguBejeda kirru-warangu-mulangwa nungkwurrajukwaba Neningikarrawara-langwa ayakwa aduwaba. ");
INSERT INTO aoi_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","“Umba nungkwurraja karnumamalya KarningiKabuniyuma,” ni-yama Jesus. “Kirri-lyangkuwerribikajungwunuma Neningikarrawara yikenu-wilyakina-mulangwa kirrakina ena-langwu-wa angalya eningaba-na! Akena nare-ka-da! Nakine-ka yikeni-larrkajama kirrakina awurrariya-wa angalya kirru-warangu-mulangwa ena-langwa ayakwa aduwaba-da!” ni-yama Jesus. ");
INSERT INTO aoi_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Biya kembirra ni-yama Jesus nenu-makama wurrumurndakibina-manja 70 warnumamalya, “Amandangwa,” ni-yama, “warningerribirra warnumamalya kuw-engkirrikaja-manja ayakwa nungkwurra-langwa, akine-ka wuburra laka kuw-engkirrikajama ayakwa nganyangwa. Umba ka-warena-manja nungkwurruwa wurrakina, akine-ka wuburra laka ka-warenama ngayuwa nganjukwaba. Akwa ka-warena-manja ngayuwa wurrakina warnumamalya, ka-warenama enejukwaba nibina ngini-larrkama ngayuwa yangkwurrangwa-da,” ni-yama Jesus aburruwa-wa. Aburraja kembirra namurndaki-likenuma arakba wurrakina akwa na-war•danguma ebina warka nenu-kwama Jesus aburruwa-da. ");
INSERT INTO aoi_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Bi...ya kembirra wurrumurndakibina 70 warnumamalya namurndaki-lawurradinuma arakba Jesus-uwa wurrakina. Wurriyekirrerre-ka wurrumurndakakina warnumamalya. Biya namurndaki-yama Jesus-uwa, “Bungkawa,” ne-yama, “wurruwurrariye-ka wurramukwa na-jadanguma warnumamalya-langwa. Yirri-yengbijuwa-manja ekirra nungkwa-langwa wurrumurndakibinu-wa wurramukwa, yirrabumin-engkirrikenuma yirra-langwa ayakwa,” namurndaki-yama wurrumurndakakina warnumamalya Jesus-uwa. ");
INSERT INTO aoi_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Eneja ni-yama Jesus, “Ngayuwa ningena ningeni-rruburringkama Namukwa, nibina nubungkawa wurruwurrariya-langwa wurramukwa. Biya ningeni-rringkama ni-ngkilarruma nakina angubina-langwa. Warenja-bawiya arrawu-wa ni-larruma nakina, wuburra laka yibilyibilya yibina ni-ngarningmindenama ni-larrinama warenja-bawiya ajiringka-wa yakina-da. ");
INSERT INTO aoi_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","“W-engkirrikiya-langwa!” ni-yama Jesus ngarningka aburruwa-wa. “Ngayuwa ngarre-ngbudirrkama kirrakina karnumamalya kajungwa karniku-bungkawadi-yada Namukwa-manja akwa ngarningka ena-langwa-manja wurruwurrariya wurramukwa wurrababurna-manja. Yiki-likaja-manja kirrakina yikini-ngalyilyakina-manja yingarna, nara ngalaja anguma nungkwurruwa-manja yakina. Akwa ngarningka yikuma-ngalyilyakina-manja merribura, nara ar•darruma makina nungkwurruwa-manja. Amandangwa eneja narrubude-ka nibina Namukwa akena nganja ngayuwa ngarre-ngbudirrkama angwurra kirrakina. Kembirra nara nakina amini-ngekburakuma awurrariya nungkwurra-langwa-da.” ");
INSERT INTO aoi_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Biya kembirra Jesus ni-yama ngarningka aburruwa-wa, “Nungkwurraja aduwaba kirru-werrikilyelyingmajungwunama kirrakina kirru-bungkawadina-mulangwa wurramukwa-manja. Eningaba akina. Umba angwurra yiku-werrikilyelyingmajungwunama karna mena Neningikarrawara-langwa karnumamalya kirrakina-da. Ngalaja ekirra nungkwurra-langwa nuw-arrikarrijungwunuma arakba. Akwa eneja Neningikarrawara nu-wilyakinama ngawa amurndakakina ekirra nungkwurra-langwa ena-langwa-manja angalya abalkaya-da,” ni-yama Jesus wurrumurndakibinu-wa warnumamalya-da. ");
INSERT INTO aoi_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Akini-yada ngawa ngalaja Amawurrina Neningikarrawara-langwa nenaki-yekirrerrikama angwurra nakina Jesus. Eneja ni-yama Neningikarrawaru-wa, “Ngeniyerriya Ngangwa, ningku-bungkawadinama abalkaya angubina-manja ningkakina, akwa ngarningka yelakwa enena-manja angalya ningku-bungkawadinama,” ni-yama Jesus. “Nganja yirre-yangmarngkwajinama ningkakina mena ningkarra-wilyakajuwa-mubaba wurrumurndakenena-manja warnumamalya ningku-bungkawadina-mulangwa aduwaba. Nara nungkwaja kenu-maka aringkawa-manja warnumamalya, umba wurrumurndakenena-manja wulkwa warnumamalya ningkarra-makama ningkakina-da. Amandangwa yirre-yangmarngkwajinama ngayuwa, mena ningkumarngkirra ningkakina akwa ningki-lyangkuwerribikajungwunuma akina-da,” ni-yama Jesus Neningikarrawaru-wa nakina-da. ");
INSERT INTO aoi_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Biya kembirra ni-yengbina Jesus amurndakenena ayakwa wurrababurnu-wa warnumamalya. Ni-yama nakina, “Nungwarrke-ka nginu-kwama nakina ababurna-langwa ngayuwa-manja,” ni-yama. “Kirrumiyambene-ka karnumamalya kirrakakiruma amandangwa ngayuwa Ningenikuwenikba? Nara-da. Eneja Nungwarrka enuwa yimbukwa nakakiruma ngayuwa-da. Umba kirrumiyambene-ka karnumamalya kirrakakiruma amandangwa Nungwarrka? Nara-da. Ngayuwe-ka ningena Ningenikuwenikba ningakakiruma nakina-da. Umba yika-ngayindena-manja ngayuwa ka-wilyakajinama kirrakina-manja, kembirra kirrukwala karnumamalya nungkwurrajukwaba yik-eningmidinama Nungwarrka,” ni-yama Jesus wurrumurndakakinu-wa warnumamalya wurrababurnu-wa-da. ");
INSERT INTO aoi_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Biya kembirra ni-nyakuwarrukwajungwa Jesus, ni-yengbina ngarningka amurndakenena akwala ayakwa ena-langwu-wa warnikabuburrakiyuwa nara-murrumanja kuw-engkirrikena wurrukwala warnumamalya. Ni-yama nakina, “Neningikarrawara nukwulyubene-ka nakina nungkwurruwa-manja,” ni-yama, “mena kirri-rringkama nungkwurra-langwa-murra menba arumuruma engbingbuda ningi-yama-mulangwa ngayuwa. ");
INSERT INTO aoi_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Arakburakba-kiya-wiya aburraja WurruBurabuda warnumamalya akwa ngawa wurrububungkawa warningarakba-kiya nuw-ambilyumurra wurrakina. Narri-ngayindangume-ka karri-rringkama amurndakibina kirri-rringkinama karna karnumamalya aduwaba akwa ngawa kuw-engkirrikenuma ayakwa amurndakibina kirr-engkirrikajama karna aduwaba. Amandangwa narri-ngayindanguma, akena nara karri-rringka kuw-engkirrikena wurrakina-da,” ni-yama Jesus ena-langwu-wa warnikabuburrakiyuwa-da. ");
INSERT INTO aoi_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Bi...ya nuw-angmungmakayangu-manja wurrakina Jesus akwa ngawa wurrukwala warnumamalya, na-lyelyimbukweyinu-manja wurrakina, eneja nuwilyaba nenikakakirumaka ayakwa Mawijija-langwa eningarumuruma nu-warumajungwa nakina ayakwi-yada. Neni-ngayindanguma neniki-kadiki-yada Jesus, kembirra neni-yendabenuma nakina. “Bungkawa,” ni-yama nakina Jesus-uwa, “ki-yamarrkinama ngayuwa nari-yada a-jungwuma amawurrina nganyangwa umba ningeniba k-ambilyi-yada ningeningangkawura?” ni-yama. ");
INSERT INTO aoi_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Eneja ni-yama Jesus, “Ki-ridimindena-manja nungkuwa amurndakibina ayakwa Mawijija-langwa eningarumuruma, amiyambena kembirra ayakwa kaku-makinama akina ningkeniki-yama-langwa nungkuwa?” ni-yama Jesus enuwa-wa. ");
INSERT INTO aoi_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Enamba-langwa nenungkwarba nenumini-lawurrakaja ayakwa ebina Mawijija-langwa Jesus-uwa akwa ni-yama, “Ni-yamama nakina Mawijija, ‘Ki-lyelyingminama Nubungkawa nungkwa-langwa Neningikarrawara amandangwa. Ku-mirajangina-manja nungkuwa akwa ngawa ku-mungkwula-manja ki-yakuwerribikajama enuwa-wa ningkeningangkawura ningkakina,’ ni-yamama nakina. Akwa ngarningka ni-yamama, ‘Ki-lyelyingminama nungkwa-langwa nenumamalya wuburra laka ningki-lyelyingmajungwunama nungkuwa,’ ni-yamama Mawijija,” ni-yama nakina nenungkwarba Jesus-uwa. ");
INSERT INTO aoi_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Ni-yama eneja Jesus enuwa-wa, “Akina-bina-da. Nungkuwa amandangwa yu-kwama ayakwa adirrbura. Ki-yaminjaminama nungkuwa akina. Kembirra ngalaja amawurrina nungkwa-langwa nara a-jungwuma, umba eniba kuw-ambilyama eningangkawura,” ni-yama Jesus. ");
INSERT INTO aoi_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Umba eneja nakina nenungkwarba neni-ngayindanguma ngawa neniki-kadiki-yada Jesus, kembirra ni-yama, “Wurrumiyambena kembirra warnumamalya nganyangwa ki-lyelyingminama?” ni-yama nakina nenungkwarba. ");
INSERT INTO aoi_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Eneja Jesus nenu-maka arakba nakina enena alawudawarra. Nuwilyaba NeningiJudiya nenungkwarba ni-likenuma nakina Jirujalema-langwa akwa ni-dirrirnduma Jerika-wa. Umba ni-likenu-manja nakina mamurukwa-langwiya, aburraja wurrukwala wurrengkengmina nen-akburranga. Biya nenu-wardanga akwa nenu-murrakajuwa dumbala iya angwarnda akwa amurndakijika ena-langwa, akwa arngkidarrba neniki-jungwangena neni-lalika arakba akwa na-likena-da. Umba yakwujina ngawa eneja nu-murrkumurrkwuluma nakina ajiringka-manja-da. ");
INSERT INTO aoi_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Bi...ya eneja nuwilyaba NuMinida nenungkwarba nubukwaya ni-likena enejukwaba mibina-manja ngawa mamurukwa. Neni-rringka nakina akena nara kenu-mamurikajuwa nakina-manja umba numa-likarrkuwakika akwa narrijinungkwa ni-likena ni-dirrirnduma arakba. ");
INSERT INTO aoi_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Bi...ya eneja nuwilyaba ngarningka nenungkwarba, nibina nu-war•duwar•danguma warka Neningikarrawara-langwa-manja angalya Jirujalema-manja, nubukwaya ngawa ni-likenuma enejukwaba mibina-manja ngawa mamurukwa. Biya n-akwudangwukajungwa akwa neni-rringka, akena neni-lalika-da. Enejukwaba nara kenu-mamurikajuwa nakina-manja nenungkwarba-da, umba numa-likarrkuwakika akwa narrijinungkwa ni-likena ni-dirrirnduma arakba nakina-da. ");
INSERT INTO aoi_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Bi...ya enamba-langwa nuwilyaba nenungkwarba ni-likenuma enejukwaba makina-manja ngawa mamurukwa. Akena nakine-ka nenungkwarba NeningiJameriya nenumamalya nakina. Umba aburraja WarningiJudiya warnumamalya narra-wirrikbame-ka angwurra WarningiJameriya-manja warnumamalya wurrakina. Biya nen-akburranga arakba nakina nenungkwarba nibina arngkidarrba neniki-jungwangena. Biya neni-rringka akena n-errukwula nakina. ");
INSERT INTO aoi_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Nara keni-lalika umba ni-likena dirrbura enuwa-wa. Biya nenumini-jirabama mamalyirra mirrijina akwa ngawa amalyirra akwurena-langwa ebina-manja amarmarra ka-warruwalyi-yada. Kembirra nenumini-lamiranguma dumbala-murra. Biya kembirra neni-njawudanga arakba ena-langwa-manja dangki akwa neni-likena wunalakina arakba-da. Nen-alilikenu...wa. Biya alikira-manja neni-yar•da arakba wunalakina. Akine-ka alikira akumungkumungkwulinga wurrababurna-langwa warnumamalya. Biya nakina NeningiJameriya nenungkwarba nen-embirrajuwama muwilyaba marringa nibina nenungkwarba nenikijungwangena yakwujina akina-manja alikira. ");
INSERT INTO aoi_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Biya wurdarriya-wiya nenu-kwama angwarnda numinakina-manja alikira, kajungwa nenik-akwurraji-yada nibina nenikijungwangena nenungkwarba. Akwa nenu-makama enuwa-wa, “Yimin-akwurrajina naka,” ni-yama nakina NeningiJameriya nenungkwarba. “Ningi-likajama ningena, umba wiya, angwarnda. Ngarningka ki-ngayindena-manja nungkuwa, yiba-kwunama ningena yangkwurrangwa-murruwa ki-lawurradina-manja ngayuwa,” ni-yama nakina. Biya ni-likena arakba-da. Ena-bu ngawa alawudawarra-da. ");
INSERT INTO aoi_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Akine-ka alawudawarra Jesus nenu-makama nibinu-wa nenumamalya nenikumakumaka ayakwa Mawijija-langwa eningarumuruma. Biya kembirra ni-yama Jesus enuwa-wa, “Wurrakina-murruwiya-bina-da wurrabiyakarbiya warnumamalya-da,” ni-yama. “Umba wurrumiyambena kembirra warnungkwarba nenu-mamurikajuwama nakina nenungkwarba nenu-wardangu-mulangwa wurrakina wurrengkengmina, wuburra laka nungkuwa ningkarra-mamurikajinama nungkwa-langwa-manja warnumamalya?” ni-yama nakina Jesus-da. ");
INSERT INTO aoi_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Eneja ni-yama, “Nakina-bina nenungkwarba nibina n-errukwulinuma nenikijungwangena nenungkwarba,” ni-yama. Eneja kembirra Jesus ni-yama enuwa-wa, “Jeyi! Likaja ki-yamini-yada nakina wuburra nenungkwarba nungkwajukwaba,” ni-yama Jesus enuwa-wa-da. ");
INSERT INTO aoi_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Bi...ya Jesus akwa ena-langwa warnikabuburrakiyuwa ne-yar•da arakba awilyaba-manja angalya aminambawura-manja alikira iya warnumamalya. Emikirra angalya Bediniya. Yakwujina ngalaja ying-ambilyuma duwilyaba didarringka dadimikirra Mada, ngaluwa akwa ngawa ngala-langwa warnumamalya. Umba Jesus akwa ena-langwa warnikabuburrakiyuwa na-likena ngala-langwu-wa alikira. Dakine-ka Mada narring-awiyebajuwa wurrakina, kajungwa kuw-alyubarini-yada aninga akwa ngawa ke-bekini-yada akubibeka. Aburraja nuw-awiyebeyina arrawa, nuw-ambarringa akwa na-lyelyimbukweyina wurrakina ayakwa, umba Mada narringamini-dakama aninga aburra-langwa. ");
INSERT INTO aoi_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Ngalaja dadiyamarnjadikba Mada-langwa dadimikirra Meri. Ying-ambarringa dakina Jesus-manja akwudangwa, biya ying-engkirrikenuma ayakwa ena-langwa. Ying-angmungmakwulaluma ngawa dakinu...wa. ");
INSERT INTO aoi_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Akena ngalaja Mada dakwukawura yingu-war•danguma warka aruma. Yingi-lyangmurukweyinuma, akwa nara king-erriminjina. Biya dakina Mada yingu-werrikawarriyadina warka-langwa arakba akwa yingi-likena Jesus-uwa. Yingi-yama dakina enuwa-wa, “Bungkawa, ningi-lyangmurukweyinama ngayuwa, mena dadiyamarnjarrka nara a-mamurikajuma nganja daka,” yingi-yama. “Awurrariye-ka ena ningu-war•denama ningakwukawura ngayuwa-na? Kembirra nga-makina kajungwa kangu-mamurikajini-yada ngayuwa,” yingi-yama Mada Jesus-uwa. ");
INSERT INTO aoi_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Eneja Jesus ni-yama ngaluwa-wa, “Amandangwa, ningku-werrikawarriyadiname-ka, ngeniyerriya, ababurna-langwa, amukwiyadakina-langwa aninga-murriya-langwa. ");
INSERT INTO aoi_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Akena enena awilyaba eningaba ningki-ngayindenama: k-engkirrikajama ayakwa nganyangwa ningkakina. Ngalaja dakaka dadiyamarnjena ying-angmakwulalama ying-engkirrikajama ngayuwa-wa. Eningaba kembirra ngala-langwa. Ena yingi-ngayindenama akwa yingi-lyangkuwerribikajungwunuma dakina eningabi-yada. Kembirra nara nganja a-minangkirrajuma daka-da. Ang-angmakwulala ngawa, ang-engkirrikaja ayakwa nganyangwa-da,” ni-yama Jesus Mada-wa nakina-da. ");
INSERT INTO aoi_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Arngkuwilyaba Jesus nu-buriyaminuma nakina Neningikarrawaru-wa. Kembirra ni-jerrukwa-manja ebina ayakwa, eneja nuwilyaba nenikaburrakiyuwa ena-langwa ni-yama enuwa-wa, “Bungkawa,” ni-yama, “yirru-wilyakajina yirraja ayakwa kajungwa yirrajukwaba yiku-buriyamini-yada Neningikarrawaru-wa. Yirru-wilyakajina yirraja wuburra laka Janjana nenu-wilyakajuwama ena-langwa-manja warnikabuburrakiyuwa,” ni-yama nakina Jesus-uwa. ");
INSERT INTO aoi_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Eneja Jesus ni-yama ena-langwu-wa warnikabuburrakiyuwa, “Yiku-buriyamina-manja Neningikarrawaru-wa kirrakina, kembirra amurndakenena ayakwa yiki-yengbinama: ‘Ningkungwanyungwa,’ yiki-yaminama, ‘yirru-mamurikajina yirruwa yiki-yengbini-yada eningaba-wiya nungkwa-langwa-langwa ningkenimikirra, mena akwurdukwurda-baba akina ekirra nungkwa-langwa. Umba bungkawadina-langwa yirruwa-manja nungkuwa. ");
INSERT INTO aoi_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Akwa yiku-kwuna aninga yirraja mababurna-langwa mamawura. ");
INSERT INTO aoi_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Akwa yirrumini-yakuwabijina awurruwurrariya amurndakibina yirri-yama-mulangwa, mena yirrajukwaba yirramini-yakuwabijinama awurruwurrariya wurrukwala-langwa warnumamalya amurndakibina yirrabumini-ngekburakama wurrakina. Akwa yirri-ngbudirrkina awurrariya-langwa yirruwa,’ yiki-yaminama kirrakina-da,” ni-yama nakina Jesus ena-langwu-wa warnikabuburrakiyuwa-da. ");
INSERT INTO aoi_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Biya nenu-makama nakina enena alawudawarra aburruwa-manja. Nuwilyaba nenungkwarba ni-likenuma ena-langwu-wa nenumamalya marngkirngkuwilyarra aningi-yada. Biya ni-yama nakina enuwa-wa, “Yu-kwa-langwa nganja aninga, ");
INSERT INTO aoi_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","mena nuwilyaba nenumamalya nganyangwa ni-yar•duma adinuba engka-langwa. Akena nara ebina aninga ningena, kemba yu-kwa-langwa,” ni-yama nibina nenungkwarba numinakinu-wa alikira-da. ");
INSERT INTO aoi_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Kembirra eneja numinakina alikira ni-lawurrakaja enena ayakwa arrawa-langwa ena-langwa-langwa alikira, “Jeyi, likaja!” ni-yama. “Nara a-mirajangajuma ngayuwa mena na-didijungwu-mubaba akwurraka ena alikira nganyangwa akwa warna wurriyukwayuwa nganyangwa namurndaku-mungkwulijajuma arakba. Kemba nara nganja a-mirajanguma a-kwama aninga ngayuwa nungkuwa-wa-da,” ni-yama nakina. Ni-lawurrakaja ena ayakwa arrawa-langwa, ");
INSERT INTO aoi_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","akena mama ena-langwa nenumamalya n-arjijeyuma errekba-manja ngawa, nare-ka nakina kinu-mirajangina nakina-da. Eneja n-ardirdanguma ngawa nakina errekba-langwa. Eneja kembirra arakba-langwa nu-mirajanga nakina nenungkwarba numinakina alikira, mena n-ardirdanguma nibina ena-langwa nenumamalya-baba-da. Nu-mirajanga nakina biya nenu-kwa ebina aninga ni-ngayindanguma. Ena-bu ngawa alawudawarra-da. ");
INSERT INTO aoi_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Jesus nakina nenu-makama ebina alawudawarra ena-langwa-manja warnikabuburrakiyuwa. Biya ni-yama nakina aburruwa-wa, “W-engkirraja ebinu-wa ayakwa ngarra-maka-murruwa nibina-langwa nenungkwarba. Wuni-yendabaja kembirra Neningikarrawaru-wa yikenu-kwuni-yada nakina ebina kirri-ngayindenama. Kembirra eneja yikenu-kwunama akina. Wurr-andiya angwurra, akwa yik-akburranginama kirrakina ebina kirr-andiyama. Yiki-ringbajenama akina-manja akawiyuwiyeba. Kembirra eneja Neningikarrawara yikenuminu-ngwurrkbalijinama akina akawiyuwiyeba-da. ");
INSERT INTO aoi_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Karningerribirra karnumamalya yikini-yendabaja-manja enuwa-wa, kembirra Neningikarraware-ka nakina yikenu-kwunama ebina kirri-ngayindenama. Akwa ngarningka yik-andiya-manja karningerribirra karnumamalya ebina kirri-ngayindanguma, kembirra yik-akburranginame-ka kirrakina-da. Akwa ngarningka yiki-ringbajena-manja karningerribirra karnumamalya akawiyuwiyeba-manja, kembirra Neningikarraware-ka nakina yikenuminu-ngwurrkbalijinama kirrakina akawiyuwiyeba-da. ");
INSERT INTO aoi_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","“Umba engkirraja enenu-wa ayakwa, nungkuwa ningkungwarringba wurriyukwayuwa-langwa,” ni-yama Jesus. “Kini-yamina-manja nenikuwena nungkuwa-wa, ‘Ngangwa, yu-kwa-langwa akwalya,’ kemba kinu-kwunama enuwa-wa yuwurrariya yingarna yibina nara ngarna alyubaruma-na? Nare-ka ningkakina-da! ");
INSERT INTO aoi_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Umba kini-yamina-manja nakina nenikuwena, ‘Ngangwa, yu-kwa-langwa nganja yinumamuwa,’ kinu-kwunama kembirra enuwa-wa merribura-na? Nara-da. Nare-ka ningkakina-da! ");
INSERT INTO aoi_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","“Karningme-ka karna kirrungwarringba yika-kwuna-mulangwa ababurna-langwa eninginingaba nungkwurra-langwu-wa wurriyikwayuwa. Mama kirruwurrariya, umba karningme-ka kirrakina. Umba eneja Neningikarrawara Nungwenungwa nungkwurra-langwa enejukwaba neningma angwurra nakina akwa kenu-kwunama Amawurrina akwurdukwurda ena-langwa wurribinu-wa warnumamalya keni-yendabaja-murruwa-da,” ni-yama Jesus ena-langwu-wa warnikabuburrakiyuwa-da. ");
INSERT INTO aoi_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Bi...ya Jesus neni-rringkama nuwilyaba nenungkwarba neningayakwa-ma. Nakine-ka nara kini-yengbina ayakwa mena wurruwurrariya-baba wurramukwa nuw-awiyebuma enuwa-manja. Umba neni-jadijuwama Jesus wurrakina wurramukwa enuwa-langwa. Eneja kembirra nenungkwarba ni-yengbina arakba ayakwa. Aburraja nuw-engkirrikenu-manja ayakwa ena-langwa wurrababurna warnumamalya wurribina nuw-ambilyu-murrumurra yakwujina, namurndaki-yakikbijangeyinume-ka wurrakina. ");
INSERT INTO aoi_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Wurrukwala warnumamalya na-makijeyinuma wurrakina. Namurndaki-yama, “Nakine-ka Namukwa nibina nenimikirra Biyeljibula, nibina wurramukwa-langwa nubungkawa, neni-ngbudirrkiname-ka nakina-bina Jesus-na? Amandangwa Biyeljibula neni-ngbudirrkinama nakina akwa neni-jadijinama Jesus wurruwurrariya wurramukwa warnumamalya-langwa-na?” namurndaki-yama wurrakina. ");
INSERT INTO aoi_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Umba wurrukwala warnumamalya narri-ngayindanguma warniki-labi-yada Jesus wurrakina. Biya ne-yama enuwa-wa, “Wu-ngekburakina engbingbuda ebina nara warnumamalya a-ngekburakuma wurrakina, kajungwa yarningmi-yada yarna nungkuwa ningki-likenuma Neningikarrawara-langwa ningkakina-da,” ne-yama wurrakina. ");
INSERT INTO aoi_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Akena eneja Jesus neningma nakina aburra-langwa mangma akwa ni-yama aburruwa-wa, “W-engkirrkiya-langwa,” ni-yama. “Namukwa nara a-mamurikajuma nakina karnumamalya-manja karniki-yama-langwa eningaba. Yika-jadijiya-manja karnumamalya wurruwurrariya wurramukwa wurrukwala-langwa wurrakina, nare-ka kembirra e-ngbudirrkama Namukwa kirrakina-manja. Nungkwurraja yiku-wardiyina-manja kirruwurrakawura-ma karnumamalya, kirrukwala yadada umba kirrukwala angaluba, kemba yiki-yamarrkinama kirrakina? Nara arakba kirruwurrakawura-ma ambilyuma kirrakina umba kirruwurrakeyebijeba ngawa yik-ambilyama-da. ");
INSERT INTO aoi_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Umba ka-wardiyina-manja aburraja wurruwurrakawura-ma wurruwurrariya wurramukwa, kembirra ke-yamarrkinama wurrakina? Nare-ka arakba wurruwurrakawura-ma ambilyuma wurrakina umba wurruwurrakeyebijeba ngawa kuw-ambilyama aburrajukwaba. “Umba nungkwurraja kirri-yamama karna karnumamalya ena ayakwa nganyangwa-langwa, ‘Namukwa neni-ngbudirrkinama nakina neniki-jadiji-yada wurruwurrariya wurramukwa warnumamalya-langwa,’ kirri-yamama kirrakina. Akena nare-ka. ");
INSERT INTO aoi_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Ka-jadijiya-manja ngayuwa wurramukwa warnumamalya-langwa ngini-ngbudirrkina-mulangwa Biyeljibula ngayuwa-manja, kemba yirru-makina arakba, ke-yamarrkinama warnikabuburrakiyuwa nungkwurra-langwa? Ke-yamarrkinama wurrakina warniki-jadiji-yada wurruwurrariya wurramukwa warnumamalya-langwa? Warningma wurrakina nare-ka Biyeljibula e-ngbudirrkama wurrakina-manja. Kembirra warningma wurrakina ekikalya ayakwa kirri-yengbinama nganyangwa-langwa kirrakina-da. ");
INSERT INTO aoi_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","“Nare-ka ningena. Eneja Neningikarraware-ka nakina ngini-ngbudurrkinama ngayuwa kajungwa ena-langwa-murra Amawurrina wulkwa ka-jadijini-yada wurruwurrariya wurramukwa warnumamalya-langwa ngayuwa-da. Kembirra ka-jadijina-manja ngayuwa wurrakina Neningikarrawara-langwa-murra Amawurrina, karningma karna Nubungkawa Neningikarrawara nu-bungkawadiname-ka enena-manja angalya arakba amandangwa nakina-da,” ni-yama Jesus wurrumurndakibinu-wa warnumamalya-da. ");
INSERT INTO aoi_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Biya enena ngarningka ayakwa nenu-makama nakina Jesus. “W-engkirrikiya enenu-wa ayakwa nuwilyaba-langwa nenungkwarba ningbuda,” ni-yama. “Kin-embirrajina-manja nakina nenungkwarba ena-langwa alikira, ngalaja akina eningawinyamba amurndakijika ena-langwa kuw-ambilyame-ka akwudangwa enuwa-manja eningangkawura. Kemba nare-ka a-murrakajuma aburraja wurrukwala warnumamalya ebina amurndakijika iya aninga akwa dumbala ena-langwa. Ngalaja engkinyungwurra ngawa kuw-ambilyama akina. ");
INSERT INTO aoi_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Umba eneja kini-likaja-manja ena-langwu-wa alikira nakina nuwilyaba nenumamalya, nibina ningbuda enuwa-manja angwurra, kemba kenu-wardiyiname-ka wunalakina. Biya nakina ningbuda-dangwa nenumamalya kini-likajama angwurra nakina-da. Kemba kenu-murrakajiname-ka amurndakijika iya aninga akwa dumbala ena-langwa numinakina-langwa alikira. Akwa kenu-murrakajiname-ka ngarningka amurndakibina amurndakijika eningawinyamba ena-langwa, ebina nenaki-kalyikama numinakina alikira-da. Biya keni-larrmburrenama amurndakibina amurndakijika wurringku-wa iya wurringku-wa warnumamalya,” ni-yama Jesus wurrumurndakibinu-wa warnumamalya. ");
INSERT INTO aoi_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Biya ni-yama ngarningka Jesus, “Karningerribirra karnumamalya nara-manja aminu-war•duma warka nganyangwa, yik-awinyambakinama kembirra ngayuwa-manja kirrakina. Umba karningerribirra karnumamalya nara-manja a-murndukwajuma kirrakina wurrukwala warnumamalya ngayuwa-wa, kirru-minangkirreyinama kembirra engku-wa wurrumurndakibina wurrukwala warnumamalya-da,” ni-yama Jesus wurrumurndakibinu-wa warnumamalya. ");
INSERT INTO aoi_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Biya ni-yama Jesus, “Ka-jadena-manja wurruwilyaba wurruwurrariya wurramukwa nuwilyaba-langwa nenungkwarba, kembirra ka-likajama wurrakina engku-wa alarrkingburingka-wa kuw-aburangkinama angalya ka-ngwanjini-yada. Nara-manja akburranguma eningaba angalya aburra-langwi-yada, kembirra ka-makijajungwunama ka-lyangkiyaminama wurrakina, ‘Ki-lawurradinama arakba ngayuwa ebinu-wa angalya ning-ambilyu-murruwa adinuba-wiya,’ ke-yaminama wurrakina wurramukwa. ");
INSERT INTO aoi_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","“Kembirra ka-lawurradinama arakba, biya karri-rringkinama ebina angalya amungkwur•da alarrngekburna. ");
INSERT INTO aoi_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Biya kembirra ka-likajama kuw-aburangkinama wurrukwalu-wa wurramukwa, akwa karra-wilyakinama wurrumangbala wurrambilyuma wurramukwa akinu-wa angalya. Akena aburraja wurrumurndakakina wurramukwa wurruwurrariye-ka, amandangwa wurruwurrariya warningadinuba-wiya-manja angwurra. Biya kembirra kuw-awiyebenama wurrakina akwa yakwujina ngawa kuw-ambilyamurra wurruwurrakawura-ma nibina-manja nenungkwarba warningangkawura wurrakina. Kembirra nakine-ka nenungkwarba kin-arriyadiname-ka angwurra, ka-lawurradina-mulangwa wurribina warningadinuba-wiya wurramukwa, wurrukwala wurringka wurramukwa aburruwa. Adinuba-wiya n-arriyaduma nakina akena angwurra ngawa kin-arriyadinama nakina-da,” ni-yama Jesus wurrumurndakibinu-wa warnumamalya nakina. ");
INSERT INTO aoi_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Kembirra ni-jerrukwa-manja Jesus amurndakakina ayakwa, ngalaja duwilyaba didarringka yakwujina wurrumurndakibina-manja warnumamalya ying-ardinga dakina. Yingi-yama dakina Jesus-uwa, “Diyekirrerre-ka didarringka dibina ng-arrangbama ngu-ngwunjikama ningkakina,” yingi-yama dakina. ");
INSERT INTO aoi_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Eneja ni-yama Jesus, “Mungkwe-ka dakina, akena amandangwa aburraja wurriyekirrerra angwurra wurribina nuw-engkirrikaja-murrumurra Neningikarrawara-langwa ayakwa akwa nenumini-yarrkuwarakina-murrumurra akina ayakwa ena-langwa-da!” ni-yama Jesus ngaluwa-wa-da. ");
INSERT INTO aoi_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","30","Aburraja kembirra wurrumurndakibina warnumamalya nuw-engkirrikenu-murrumurra Jesus-uwa nuw-ababurndadinuma wurrakina, biya nawurraki-lyibilyidanguma arakba. Kembirra ni-yama eneja Jesus aburruwa-wa, “Karniniyerriya karnumamalya karna aduwaba! Kirri-ngayindenama karniki-rringki-yada eminiminingka engbingbuda amurndakibina nara e-yamama warnumamalya, akena nara a-rringkama kirrakina. Ngayuwe-ka, ningibina-murrada ningi-rukwularrinuma enena-manja angalya, Jawuna wuburra ningi-yaminama ningena. Nakine-ka Jawuna n-ambilyuma ebina-manja akwalya mabiyakarbiya mamawura akena neniba ngawa ni-jadanguma nakina. Aminakina-langwa kembirra aburraja wurrumurndakibina warnumamalya wurruminakina angalya Niniba nuw-eningmidinuma wurrakina Neningikarrawara neni-larrkama Jawuna aburruwa-wa-da. Akine-ka wuburra yikenu-wilyakajinama eneja Neningikarrawara kirrakina-manja karnumamalya ngini-larrka-mulangwa ngayuwa nungkwurruwa-wa umba nara akwala-da,” ni-yama Jesus wurrumurndakibinu-wa warnumamalya. ");
INSERT INTO aoi_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Biya kembirra ni-yama nakina aburruwa-wa ngarningka, “Ambaka-murrumurra meningarija-langwa-manja mamawura, Neningikarrawara nakina kini-lyangkuwerribikajungwunama warnumamalya-langwa, warningaba-murrikba akwa wurruwurrariya-murrikba. Akini-yada ngawa ngalaja king-arjiyama dibina dubungkawa duminakina angalya Jiba. King-arjiyama dakina akwa yikangi-lekbajama nungkwurruwa-wa karnumamalya kirribina kirr-ambilya-murrumurra ena-manja angalya aduwaba. Arakburakba-kiya-wiya yingi-likenuma dakina engka-langwa eminingka-langwa angalya kajungwa dadik-engkirriki-yada ayakwa Nubungkawa-langwa Jalumuna-langwa. Arrubude-ka ayakwa ni-yengbinuma eneja Jalumuna, aringkawa-baba nakina, akwa ying-engkirrikenuma dakina amurndakakinu-wa ayakwa. Kembirra yikangi-lekbajama nungkwurruwa-wa dakina-da. Yikangi-lekbajama dakina mena nuwilyaba-baba nenumamalya nibina naruma-dangwa n-ambilyama nakina yelakwa nungkwurruwa-manja aduwaba. Akena nungkwurraja karnumamalya nare-ka engkirrikuma ena-langwu-wa ayakwa aduwaba kirrakina-da. ");
INSERT INTO aoi_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","“Kembirra ngarningka akini-yada meningarija-langwa-manja ngawa mamawura aburraja wurrumurndakibina WarningiNiniba warnumamalya kuw-arjiyama aburrajukwaba kajungwa warniki-lekbi-yada nungkwurruwa-wa karnumamalya. Yikabu-lekbajama wurrakina mena narrume-kuwarrukwajuwa-mubaba mangma aburra-langwa nuw-engkirrikenu-mulangwa ayakwa Jawuna-langwa. Narrume-kuwarrukwajuwama mangma wurrumurndakibina warnumamalya, narru-wurranguma awurruwurrariya umba nenumini-yarrkuwarakama wurrakina ayakwa Neningikarrawara-langwa arakba. Arrubuda ayakwa ni-yengbinuma eneja Jawuna, umba amurndakenena ayakwa kirr-engkirrikajama karna aduwaba arrubuda-dangwa angwurra ena-da. Akena nara nungkwurraja engkirrikuma kirrakina-da,” ni-yama Jesus wurrumurndakibina-manja warnumamalya. ");
INSERT INTO aoi_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Biya enena ayakwa bajananga-langwa nenu-makama Jesus wurrumurndakibinu-wa warnumamalya. Ni-yama nakina, “Yakuwa yalakena yak-abarrakajina-manja bajananga alikira-manja arrawa, nare-ka abuwarrkama akina. Nare-ka yalakena akumama akina bajikala-manja arrawa umba yak-akumurnama akina karrawara kajungwa karri-rringkini-yada wurrukwala warnumamalya eningaba alarradada. ");
INSERT INTO aoi_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Nara-manja ebina bajananga alikira-manja arrawa alyarrngwalyilya kembirra nara yalakena a-rringkama angalya. Akwa nara-manja mibina menba yakwa-langwa kembirra nara yalakena a-rringkama angalya. Akwa muwurrariya menba yakuma-wilyakina-manja kembirra alarrumur•da-manja ngawa yak-ambilyama yalakena. Umba yakuma-wilyakina-manja meningaba menba kembirra engku-wa yaki-rringkinama yalakena. ");
INSERT INTO aoi_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Kembirra yiki-rringkajungwunama karna karnumamalya kajungwa nari-yada a-rringkama awurrariya-wa umba eningabu-wa yiki-rringkini-yada kirrakina-da. ");
INSERT INTO aoi_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Kembirra nara-manja a-rringkama awurrariya-wa umba yiki-rringkina-manja eningabu-wa karningangkawura, kembirra ababurna-langwa nungkwurra-langwa *ka-wuldinama *ka-ngwur•denama akina eningangkawura ngawa, wuburra laka kirr-ambilyama alikira-manja ebina na-lyangburrukwuna-murrumanja alarradada akina-da,” ni-yama Jesus wurrumurndakibinu-wa warnumamalya. ");
INSERT INTO aoi_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Ni-jerrukwa-mulangwa Jesus amurndakibina ayakwa, kembirra eneja nuwilyaba nenungkwarba, nibina NuBarija, ni-yama nakina enuwa-wa, “Yi-likaja arakba nganyangwu-wa angalya aningi-yada,” ni-yama. Biya neni-likena arakba wunalakina NuBarija-langwu-wa alikira, akwa wurrukwala warnungkwarba aburruwa. Biya n-ambarringa nakina Jesus aningi-yada arakba, akena nara nakina kini-jiraba akungwa adinuba-wiya ena-langwa-manja ayarrka. ");
INSERT INTO aoi_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Eneja NuBarija nenungkwarba nenu-miringkama nakina Jesus-uwa nara kin-ajirranga ena-langwa ayarrka umba n-ambarringa warenja-bawiya aningi-yada nakina. Biya ni-yakikbijanguma NuBarija nakina-da. ");
INSERT INTO aoi_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Eneja kembirra ni-yama nakina Nubungkawa Jesus enuwa-wa, “KirruBarija karnumamalya kirr-ajirrename-ka nungkwurra-langwa ayarrka. Akina kirri-yaminjaminama eningarumuruma-langwiya ayakwa nungkwurra-langwa, akena nara kirrakina a-mungkwur•duma mangma iya yukwudukwuda nungkwurra-langwa. Kirrumungwur•dangma kirrakina karnumamalya kirribina kirra-murrakajinama ababurna eningerribirra warnumamalya-langwa mena muwurrariya-baba mangma iya yukwudukwuda kirruma-wilyakinama kirrakina. Amandangwa kirri-yaminama nuwilyaba wuburra nenumamalya nenubuwakida, nibina n-ajirrenama ambaka-langwa ena-langwa bajikala errekba-langwiya, akena nara ajarruma akina arrawa-langwiya,” ni-yama Jesus nibina-manja NuBarija nenungkwarba. ");
INSERT INTO aoi_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Biya ni-yama ngarningka nakina Jesus, “Karninubuwakida karnumamalya. Eneja Neningikarrawara ni-ngekburakama nakina ababurna-langwa ebina ngarri-rringkinama aduwaba ngarna, eningerrekba akwa ngawa eningarrawa ngalajukwaba ni-ngekburakama nakina. ");
INSERT INTO aoi_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Nungkwurraja kembirra ena yiki-yamina kirrakina karnumamalya kajungwa yikuma-wilyakini-yada mamungkwur•da mangma meningaba. Yika-kwuna nungkwurra-langwa amurndakijika wurrukwalu-wa warnumamalya warningalyingmalyingma-wa. Yiku-marngkirradinama aburruwa-manja kirrakina-da. ");
INSERT INTO aoi_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Amandangwe-ka awurrariya ka-ngekburakajungwunama nungkwurra-langwa KirruBarija-langwa karnumamalya! Nare-ka kirrakina engkirrikuma karniki-yama-langwa eningaba wurrukwala-manja. Akwa ngarningka nare-ka engkirrikuma Neningikarrawaru-wa, akwa nara a-lyelyingmama enuwa-wa kirrakina karnumamalya. Umba amarda enikalyubara eyukwayuwa, amurndakibina ka-kwurarikinama aninga nungkwurra-langwa, kirru-murnduwarnama amurndakakina awilyuwilyaba-wiya, kajungwa yikinu-kwuni-yada awilyaba Neningikarrawaru-wa umba yiku-wilyakini-yada kirrakina amangbala abiyarbuwa nungkwurra-langwi-yada. Eningaba akina akena nara e-yakuwabijuma karniki-yama-langwa eningaba wurrukwala-manja-da akwa ngarningka karniki-lyelyingma-langwa Neningikarrawaru-wa kirrakina-da. ");
INSERT INTO aoi_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Amandangwe-ka awurrariya ka-ngekburakajungwunama akina nungkwurra-langwa KirruBarija-langwa karnumamalya! Kirru-ngkweningabakajungwuname-ka. Kirri-likaja-manja kirrakina jinikakwu-wa kirru-mar•denama kirrakina angalya eningaba karnik-ambarringi-yada yakwujina. Akwa kirri-likaja-manja kirrakina wurrababurnu-wa warnumamalya kirri-lyelyingminame-ka ayakwa aburra-langwa ne-yengbina-mulangwa eninginingaba-wiya wurrakina ayakwa nungkwurruwa-wa,” ni-yama Jesus nibinu-wa NuBarija nenungkwarba. ");
INSERT INTO aoi_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","“Yawe-ka,” ni-yama ngarningka Jesus. “Awurrariye-ka ka-ngekburakajungwunama nungkwurra-langwa! Kirrumiyambene-ka karnumamalya karna? Ka-makinama ngayuwa. Kirrakine-ka karnumamalya awilyaba wuburra angalya ebina-manja narra-rungkwaba-murrumanja warninikijungwa warnumadangkwa. Akena akine-ka angalya nuw-abuwarrkajungwunama. Aburraja kemba ka-likaja-manja warnumamalya yenjerrikina, karri-ngalyilyakinama akina-manja angalya. Warningbale-ka nuw-ambilya-mulangwa arrawa wurrumurndakibina wurrimingma warnumadangkwa. Amandangwa akine-ka wuburra angalya kirrakina-da, mena warningbala-baba wurrakina wurrukwala warnumamalya nungkwurra-langwa mangma muwurrariya mibina num-abuwarrkajungwunama makina-da,” ni-yama Jesus nibinu-wa nenungkwarba NuBariju-wa-da. ");
INSERT INTO aoi_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Eneja kembirra nuwilyaba nenikakakirumaka Mawijija-langwa ayakwa eningarumuruma ni-yengbinuma nakina ayakwa Jesus-uwa. “Bungkawa,” ni-yama, “ningki-yaminama ningkakina kembirra yirruwa-wa, ‘Karniniyerriya karnumamalya karna nungkwurrajukwaba,’ ningki-yaminama-na?” ni-yama nakina nenikakakirumaka nenungkwarba. ");
INSERT INTO aoi_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Eneja ni-yama Jesus nakinu-wa, “Awurrariye-ka ka-ngekburakajungwunama nungkwurra-langwa nungkwurrajukwaba akina, mena kirra-makina-mubaba wurrukwala-manja warnumamalya warniki-yama-langwa eminiminingka, akena nara karna a-mamurikajuma wurrakina-manja kirrakina-da. Kirri-yaminama wurrububungkawa wuburra wurribina narra-kwunama warnikuminuwar•duwar•da engkubarrngwarrngwa amurndakijika warniku-wilyaki-yada akena nara a-mamurikajuma wurrakina-manja-da. ");
INSERT INTO aoi_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","“Yawe-ka,” ni-yama ngarningka Jesus. “Awurrariye-ka ka-ngekburakajungwunama akina nungkwurra-langwa! Arakburakba-kiya-wiya aburraja wurrumirumirenungwa nungkwurra-langwa narra-wardanguma wurrakina WurruBuburabuda warnungkwarba Neningikarrawara-langwa. Narra-wardanguma wurrakina mena na-warangu-mubaba Neningikarrawara-langwa ayakwa. Kembirra aduwaba ngarningka nungkwurraja karnumamalya kirri-likirakama akukwulyubena eyukwayuwa alikira karrawara narra-rungkwaba-murrumanja wurrakina warnumadangkwa wurrumurndakibina-langwa WurruBuburabuda arrawa. ");
INSERT INTO aoi_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Kirri-likirakama amurndakakina alikira akukwulyubena kajungwa warnik-engkirriki-yada wurrakina warnumamalya kirri-lyelyingmina-mulangwa kirrakina ayakwa WurruBuburabuda-langwa. Akena nara karna a-lyelyingmama aburra-langwu-wa ayakwa, umba kirri-lyelyingminama kirrakina ne-yama-mulangwa wurrumirumirenungwa narra-wardangu-mulangwa wurrumurndakibina WurruBuburabuda Neningikarrawara-langwa. Kirri-lyelyingminama narra-wardangu-mulangwa wurrakina mena nungkwurrajukwaba kirru-warangu-mubaba Neningikarrawara-langwa ayakwa aduwaba. ");
INSERT INTO aoi_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Akina-langwa-bina eneja ni-yengbinuma enena ayakwa nakina Neningikarrawara nibina nakakiruma ababurna-langwa. Ni-yamama nakina, ‘Ka-larrkajama ngayuwa wurrukwala warnikumakumaka warnumamalya akwa ngawa warnikiyarrkuwilyaka warnumamalya ayakwa nganyangwu-wa warnumamalya. Akena wurrumurndakakine-ka warnumamalya nganyangwa karra-jungwajinama wurrukwala umba karramini-ngekburakinama awinyamba wurrukwala-langwa,’ ni-yamama Neningikarrawara. ");
INSERT INTO aoi_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","“Kembirra yikeni-lekbajama nakina Neningikarrawara nungkwurruwa karnumamalya karningaduwaba. Yikeni-lekbajama akwa yikeni-larrkbarjenama nungkwurruwa narra-jungwajuwa-mulangwa wurrumirumirenungwa nungkwurra-langwa arakburakba-kiya-wiya wurrumurndakibina WurruBuburabuda ena-langwa wurrababurna-langwa. ");
INSERT INTO aoi_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Adinuba-wiya arakburakba-kiya eneja Keyina nenu-wardanguma nakina nenikumarnjenikba Ebula. Bi...ya na-lamulamukwarridinuma aburraja ngawa wurrakina warnumamalya wurrababurna-manja Neningikarrawara-langwa-manja WurruBuburabuda warnungkwarba. Ne-yaminjamama ngawa wurrakina yanda-langwa Jekaraya n-ambilyuma nakina. Jekaraya nu-war•danguma warka Neningikarrawara-langwa-manja angalya Jirujalema-manja. Umba yakwujina ngawa neni-jungwajuma nakina-da, akwudangwa ebina alda akwa ebina alikira akwurdukwurda-da. Amandangwa nganja ningi-larrkbularrkbakinama ngayuwa. Eneja Neningikarrawara yikeni-lekbajama nakina karnumamalya karningaduwaba akwa yikeni-larrkbarjename-ka na-lamukwarridinu-mulangwa wurrumirumirenungwa warningarakburakba-kiya ena-langwa-manja WurruBuburabuda wurrababurna-manja wurrakina-da,” ni-yama Jesus wurrumurndakibinu-wa warnikakakirumaka Mawijija-langwa ayakwa eningarumuruma. ");
INSERT INTO aoi_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Biya kembirra ngarningka Jesus ni-yama aburruwa-wa, “Karnikakakirumaka Mawijija-langwa ayakwa karnungkwarba, awurrariye-ka ka-ngekburakajungwunama akina nungkwurra-langwa! Awurrariye-ka ka-ngekburakajungwunama, mena warnumamalya narri-ngayindena-mubaba wurrakina aduwaba kuw-akakirumadini-yada Neningikarrawara-langwa ayakwa, akena nungkwurraja kirr-abuwarrkinama ayakwa ena-langwa aburruwa-manja kirrakina-da. Nara karna a-ngayinduma akina ayakwa akwa ngarningka nara a-makama wurrukwala-manja warnumamalya kirrakina-da. Aminakina-langwa ka-ngekburakajungwunama akina awurrariya nungkwurra-langwa-da,” ni-yama Jesus wurrumurndakakina-manja warnikakakirumaka ayakwa Mawijija-langwa-da. ");
INSERT INTO aoi_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Biya kembirra ni-lalika arakba nakina Jesus ebina alikira nibina-langwa NuBarija nenungkwarba. Yadikina aburraja wurrumurndakibina warnikakakirumaka ayakwa eningarumuruma Mawijija-langwa akwa ngawa wurrumurndakibina WurruBarija warnumamalya aburrajukwaba ne-yengbeyinuma arakba ayakwa ayarrkiyarrkawarriya Jesus-langwa. Biya ne-yengbiyengbeyinumurre-ka ngawa wurrumurndakakina warningangkawura ayarrkiyarrkawarriya ayakwa enuwa-wa. Akwa neni-yengkilabenuma wurrakina ababurne-ka ayakwa eminiminingka enuwa-manja. Neni-yengkiyengkilabenuma ayakwa, ");
INSERT INTO aoi_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","mena neni-ngayindanguma wurrakina warniki-kadiki-yada nakinu-wa Jesus kajungwa neniki-yengbi-yada ayakwa awurrariya. Neni-ngayindanguma warniki-lekbi-yada enuwa-wa wurrakina akena nare-ka kini-yengbina ayakwa ayarrkawarriya nakina Jesus-da. ");
INSERT INTO aoi_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Akini-yada ngawa aburraja wurruwurrakwulyumide-ka warnumamalya nawurra-murndukwunuma Jesus-manja wurrakina. Nawurraki-lyibilyidanguma akwudangwa akwa nawurraki-ngalyilyakijeyinuma wurrumurndakakina warnumamalya mena wurruwurrakwulyumida-baba wurrakina. Eneja kembirra arakba Jesus ni-yengbina nakina ayakwa ena-langwu-wa warnikabuburrakiyuwa akwa ni-yama, “Wurrakine-ka WurruBarija warnungkwarba narramini-ngayindenama wurrukwala warnumamalya ke-yaminama wurrakina, ‘Warningabe-ka wurrumurndakakina WurruBarija warnumamalya.’ Akena wurruwurrariya wurrakina, akwa narrum-abuwarrkinama mangma aburra-langwa wurrukwala-langwa warnumamalya. Nungkwurraja kembirra nara e-yamama wurrumurndakakina wuburra warnungkwarba, ");
INSERT INTO aoi_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","mena eningerribirra ebina nuw-abuwarrkajungwunama aduwaba kuw-abilyerrikajungwunama ambaka-murra akina. ");
INSERT INTO aoi_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Ababurna-langwa ayakwa amurndakibina ningki-yengbinuma nungkuwa ningkakina alarrumur•da-manja, kuw-engkirrikajame-ka aburraja warningerribirra warnumamalya alarradada-manja. Akwa ngarningka ababurna-langwa ayakwa amurndakibina ningki-yengbinuma ningkakina amurama alikira-manja arrawa, kuw-engkirrikajame-ka warningerribirra warnumamalya amurndakakinu-wa ayakwa nungkwa-langwu-wa-da, wuburra laka ningk-ardanguma angwurra ningkakina-da,” ni-yama Jesus ena-langwu-wa warnikabuburrakiyuwa. ");
INSERT INTO aoi_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Amandangwa, kirribina ngakwurruwa-murrumurra,” ni-yama ngarningka Jesus aburruwa-wa, “nare-ka akbar•duma warnumamalya-langwa wurribina wurrabarda awinyamba. Dukwa wurrakine-ka kabu-wardena kabi-jungwajina ningkakina-da. Akena kabu-wardena-manja ningkenumadangkwa akwa ki-jungwuna-manja ningkakina, nara arakba ebina akwala awurrariya nungkwa-langwa warniki-yama-langwa wurrakina-da. ");
INSERT INTO aoi_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Umba nganja yiba-wilyakajinama ngayuwa nibina nenumamalya ken-akbar•dijinama angwurra ningkakina. Nungkwaja k-akbar•denama ningkakina Neningikarrawara-langwa, mena narrubuda-baba nakina amandangwa. Eneja keni-ngayindena-manja nakina, kenu-wardenama nakina ningkenumadangkwa akwa ki-jungwunama, akwa ngarningka nakina kenu-wurrenama ningkenumawurrina awurrariya-wa angalya angwura-murru-wa. Kembirra yakwujina ngawa k-ambilyama ningkeningangkawura-da. Yawe-ka, yirra-madumurrukwunama ngayuwa nungkuwa-manja. Nakina-langwa-bina nenumamalya k-akbar•denama angwurra ningkakina, mena narrubuda-baba nakina-da,” ni-yama Jesus ena-langwu-wa warnikabuburrakiyuwa-da. ");
INSERT INTO aoi_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Biya ni-yengbina ngarningka enena ayakwa nakina Jesus ena-langwa-manja warnikabuburrakiyuwa. “Narrubuda Neningikarrawara nakina akwa ken-embirrajinama nungkuwa-manja,” ni-yama. “Dukwa kirruwilyaba karnumamalya yiku-beyindenama kirrakina wurrumangbala wurriyukwayuwa wurrajija eyu...kwujiya-murra angwarnda-da. Umba eneja Neningikarrawara nakina nen-embirrajinama warningerribirra wurrajija wurrakina wurrababurna-langwa. Nara nakina e-yakuwabijuma a-ngwarndirruma wurruwilyuwilyaba umba nen-embirrajinama wurrakina-manja ngawa. ");
INSERT INTO aoi_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Neningikarrawara nen-embirrajinama wurriyukwayuwa wurrajija, akwa ken-embirrajinama nungkuwa-manja nungkwajukwaba akwa nara nakina e-yakuwabijuma. Neningme-ka nakina mamungba nungkwa-langwa. Numa-murnduwarnama arakba makina mamungba muwurrakwulyumida nungkwa-langwa. Neningma nakina! Nare-ka kembirra nungkwaja akbar•duma, mena Neningikarrawara nen-akwurrajinama nakina wurriyukwayuwa wurrajija, akwa ngin-akwurrajinama angwurra amandangwa nungkuwa-manja nungkwajukwaba ningkenumamalya-manja. Ngin-akwurrajiname-ka nungkuwa-manja mena ena-langwa-baba ningkakina-da,” ni-yama Jesus ena-langwu-wa warnikabuburrakiyuwa-da. ");
INSERT INTO aoi_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Biya ni-yama ngarningka Jesus, “Kirruwilyabe-ka karnumamalya yiki-yamina-manja nakina wurrakinu-wa wurrukwala warnumamalya, ‘Ngayuwe-ka ningena Jesus Christ-langwa ningenumamalya,’ yiki-yamina-manja kirrakina akina ayakwa, kembirra nganja ngayamba-langwa ki-yaminama enena ayakwa. Ngayuwe-ka ningena, ningibina-murrada ningi-rukwularrinuma enena-manja angalya, ki-yaminama nganjukwaba, ‘Nungkwaja ningkakina nganyangwa ningkenumamalya-da.’ Enena ayakwa ki-yengbinama ngayuwa kajungwa warnikumamurikaja Neningikarrawara-langwa kuw-engkirrikaji-yada wurrakina ena-langwa-manja angalya abalkaya-da. ");
INSERT INTO aoi_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","“Umba kirruwilyaba karnumamalya yiki-yamina-manja wurrukwalu-wa warnumamalya, ‘Ngayuwe-ka ningena ningeningbala Jesus Christ,’ yiki-yamina-manja kirrakina akina ayakwa, yik-eningbalikajungwuna-manja kirrakina ngayuwa-langwa, kembirra nganja ngayamba-langwa ki-yaminama enena ayakwa. ‘Nganjukwaba ningeningbala ningkakina, nara nganyangwa ningkakina-da,’ ki-yaminama. Enena ayakwa ki-yengbinama ngayuwa kajungwa warnikumamurikaja Neningikarrawara-langwa kuw-engkirrikaji-yada wurrakina aburrajukwaba ena-langwa-manja angalya abalkaya-da. ");
INSERT INTO aoi_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“Umba karningerribirra karnumamalya yiki-yengbina-manja ayakwa awurruwurrariya ningibina-langwa ningi-rukwularrinu-mulangwa enena-manja angalya, kembirra eneja Neningikarrawara yikenumini-yakuwabijinama nakina ayakwa nungkwurra-langwa. Umba yiki-yengbina-manja kirrakina ayakwa awurruwurrariya Amawurrina-langwa Akwurdukwurda Neningikarrawara-langwa-langwa, nara kembirra Neningikarrawara amini-yakuwabijuma amurndakakina ayakwa awurruwurrariya nungkwurra-langwa-da,” ni-yama Jesus ena-langwu-wa warnikabuburrakiyuwa-da. ");
INSERT INTO aoi_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Biya ni-yama ngarningka Jesus aburruwa-wa, “Kabu-mena-manja ningkakina wurruwurrariya warnungkwarba akwa kabu-wilyakina-manja ningkakina jinikakwu-wa wurrakinu-wa wurrububungkawa warningijinikakwa, akwa ngawa wurrukwalu-wa wurrububungkawa wurriminingku-wa aburrajukwaba, nare-ka a-werrikawarriyaduma ayakwa-langwa. Akwa nara a-lyangkiyamama, ‘Karukwa, ki-yamarrkinama ki-yengbinama ayakwa? Amiyambene-ka ayakwa ki-lawurrakajinama ngayuwa wurrububungkawu-wa, kajungwa nari-yada a-warduma a-diduma ngayuwa aduwaba?’ Nare-ka a-lyangkiyamama akina, a-werrikawarriyaduma akina-langwa ayakwa, ");
INSERT INTO aoi_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","mena akini-yada ngawa Amawurrina Akwurdukwurda Neningikarrawara-langwa kaku-wilyakajina-mubaba ayakwa adirrbura ningkeniki-yengba-langwa ningkakina,” ni-yama Jesus ena-langwu-wa warnikabuburrakiyuwa-da. ");
INSERT INTO aoi_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Eneja kembirra nuwilyaba nenungkwarba, nibina yakwujina ngawa n-ambilyuma wurrumurndakakina-manja warnumamalya wurruwurrakuwilyarra, ni-yengbinuma nakina ayakwa Jesus-uwa. Biya ni-yama, “Bungkawa,” ni-yama, “nawarrka nara a-ngayinduma nakina ngu-kwama ngayuwa-wa akwala angwarnda. Ni-jungwuma arakba yina-langwa nungwarrka, kembirra yikini-larrmburrenama yinalakena angwarnda iya amurndakijika akwa angalya nungwarrka-langwa, ekuwarra nawarrka-langwa umba ekuwarra nganyangwa. Umba nungkwaja ningkakina yiminu-makina-langwa nganyangwa nawarrka kajungwa kenu-kwuni-yada nganja akwala amurndakijika nganyangwa ngayuwa-wa,” ni-yama nakina nenungkwarba Jesus-uwa. ");
INSERT INTO aoi_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Eneja ni-yama Jesus, “Kada. Nara wurribina warningerribirra warnumamalya kabu-kwa amukwiyadakina warka ngayuwa-wa. Nara nganja a-lyangkuwerribikajungwuma ningena akina-langwa. Nara kembirra a-makama ngayuwa nawena-manja ningena-da,” ni-yama Jesus enuwa-wa-da. ");
INSERT INTO aoi_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Biya kembirra Jesus ni-yengbinuma nakina ayakwa wurrumurndakakina-manja ngawa warnumamalya wurrababurna-manja yakwujina. Ni-yama, “W-engkirrikiya-langwa! Nare-ka a-mungwur•dangmaduma akwa a-mar•dumar•duma eningerribirra amurndakijika wurrukwala-langwa. Nare-ka e-yamama akina. Mama kirruminababurne-ka amurndakijika-murriya kirrakina, akena nare-ka akina a-kwama amamalya akwanenibika eningaba nungkwurra-langwa-da. Kembirra wurri-rringkajungwunama aduwaba-da,” ni-yama Jesus wurrumurndakakinu-wa warnumamalya. ");
INSERT INTO aoi_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Kembirra arakba enena alawudawarra nenu-makama nakina aburruwa-wa. Nuwilyaba nenungkwarba n-ambilyumurra numinababurne-ka angwarnda iya aninga akwa amurndakijika. Biya nu-war•danguma nakina mababurna-langwa mamawura warka ena-langwa. Ni-lungkuwabijuwamurra nakina ababurna aninga amarda-murra. Nu-war•duwar•dangu...wa. Ngalaja ababurne-ka amarda-murra amaninga na-lungkuwarreyinuma ena-langwa-manja angalya mena eningaba-baba ajiringka akina. ");
INSERT INTO aoi_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Bi...ya numa-war•dikama nakina mangma ena-langwa, kembirra ni-yakuwerribikinuma arakba. Biya ni-lyangkiyama nakina, “Nara ebina angalya ningenik-akumi-yada enena aninga awurrakwulyumida-da, mena ababurne-ka ena aninga nganyangwa-da. Ki-yamarrkinama kemba ningena? ");
INSERT INTO aoi_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Wa! Ku-wurrenama ngayuwa amurndakenena alikira eninganinga eyukwayuwa, umba ki-likirakinama akwala alikira ningena adidirrungwarna-langwa. Kemba arakba ki-larrngkwaburrenama ababurna-langwa aninga iya amurndakijika nganyangwa enikinikaduwa-manja alikira adidirrungwarna-manja-da. ");
INSERT INTO aoi_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Biya kembirra arakba ki-lyangkumakajungwunama ngayuwa, ‘Enena kembirra laka ababurna eninginingaba-wiya nganyangwa arakba,’ ki-yaminama. ‘Kembirra nara arakba a-war•duma ningena warka umba ku-ngwanjinama ningena warka-langwa ningeningangkawura ngayuwa-da. K-alyubarinama aruma aninga akwa ki-bekinama aruma akubibeka ningeningangkawura-da. Ningiyekirrerre-ka k-ambilyama ngayuwa-da!’” ni-yama nu-makajungwunuma nakina nenungkwarba. Akina ayakwa ni-lyangkumakajungwunuma nakina nenungkwarba. ");
INSERT INTO aoi_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Umba eneja Neningikarrawara ni-yengbina nakina ayakwa enuwa-wa. Ni-yama, “Ningkenubuwakide-ka ningkakina ningkenumamalya! Mema-manja marringa ki-jungwunama ningkeningangkawura. Ningki-larrngkwaburranguma ningkakina ababurna aninga-murriya nungkwa-langwi-yada aduwaba. Umba ki-jungwa-manja ningkakina, angkaburra karru-menama amurndakenena aninga iya angwarnda akwa amurndakijika nungkwa-langwa? Nare-ka ningkakina a-wilyakama nungkuwa-manja amurndakakina ababurna-langwa nungkwa-langwa, umba aburraja wurrukwala warnumamalya karru-menama ababurna-langwa nungkwa-langwa-da,” ni-yama nakina Neningikarrawara enuwa-wa. Ena ngawa alawudawarra-da. ");
INSERT INTO aoi_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Biya ni-jerrukwa-mulangwa nakina Jesus akina alawudawarra, ni-yama nakina wurrumurndakakinu-wa warnumamalya, “Akina wuburra ke-yaminama wurrababurna-langwa warnumamalya wurribina narri-larrngkwaburrenama aduwaba alarrngkababurna amukwiyadakina aburra-langwi-yada, akena nara ebina eningaba aburra-langwa warniku-wilyakaja-langwa wurrakina Neningikarrawaru-wa-da,” ni-yama Jesus wurrumurndakakinu-wa warnumamalya. ");
INSERT INTO aoi_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Kembirra ni-yengbinuma nakina Jesus akwala ayakwa ena-langwu-wa warnikabuburrakiyuwa. Ni-yama nakina, “Ngarra-makama arakba kirruminababurna-langwa amurndakijika-murriya ngayuwa. Ningi-yamama, ‘Nara amurndakakina amurndakijika a-kwama amamalya eningaba nungkwurra-langwa,’ ningi-yamama. Kembirra aminakina-langwa nara nungkwurraja a-werrikawarriyaduma engkirrikuma ebinu-wa aninga kirri-ngayindena-murruwa yik-ambilyi-yada karniba enena-manja angalya. Nara ngarningka engkirrikuma dibinu-wa dumbala kirringa-ngayindena-murruwa karnik-awiyeba-langwa kirrakina. ");
INSERT INTO aoi_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Kirr-akukwurrajinama kirrakina karnumadangkwa. Umba kirr-alyelyubarinama aninga kirringbudi-yada, akwa kirr-awiyuwiyebenama duwabilya dumbala yiku-wabilyadini-yada kirrakina. Umba kirrakina-bina karnumawurrina nungkwurra-langwa yik-engkingkirrikajama akwa yik-akukwurrajinama kirrakina-da. ");
INSERT INTO aoi_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","“Umba wi-yakuwerribikina kirrakina yingwu-wa,” ni-yama ngarningka Jesus. “Nara yakina a-lungkuwabijuma arrangbama amadidira amaninga. Nara ebina alikira eninganinga ena-langwa akena eneja Neningikarrawara kinu-kwunama nakina aninga ena-langwa. Kembirra yikenu-kwunama amandangwa aninga nungkwurra-langwa, mena nakina Neningikarrawara nen-akwurrajina-mubaba wurrajija akwa nungkwurruwa nungkwurrajukwaba karnumamalya kirren-akwurrajinama nakina angwurra amandangwa-da. ");
INSERT INTO aoi_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","“Yirru-makina,” ni-yama ngarningka Jesus. “Yiku-werrikawarriyadina-manja kirrakina karnik-ambilyinga-langwa karniba amiyerra enena-manja angalya, kembirra akina-langwa yiku-werrikawarriyadina-mulangwa, dukwa yik-ambilya karna karniba mukwala mamawura amiyerra? Nare-ka. ");
INSERT INTO aoi_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Kembirra nara-manja kirrakina a-merrijirrirrakuma nungkwurra-langwa mamawura enena-manja angalya, kajungwa amiyerra angwurra yik-ambilyi-yada karniba, kembirra nare-ka a-werrikawarriyaduma aninga-langwa akwa dumbala-langwa. ");
INSERT INTO aoi_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“Umba wi-yakuwerribikaja kembirra mebinu-wa numu-lungkuwarrina-murruwa erriberriba-manja,” ni-yama nakina Jesus ngarningka. “Nara ngalaja mamurndakakina mebina a-war•duma warka amini-ngekburakuma dumbala ngala-langwa menik-awiyebi-yada makina. Arakburakba-kiya-wiya eneja Nubungkawa Jalumuna numinababurne-ka amurndakijika nakina akwa n-awiyuwiyebeyinume-ka dumbala dukukwulyubene-ka. Dakine-ka dumbala ena-langwa dukwulyubena dumurndakakina umba ngalaja mebina meningaba mukwulyubena angwurra makina mamawalyuwa. ");
INSERT INTO aoi_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Eneje-ka Neningikarrawara numa-ngekburakama makina mukwulyubena mebina akena meningaduwaya makine-ka mamawalyuwa. Muwilyaba-manja mamawura kumu-lingbadenama mukwulyubena makina, umba mingka-manja mamawura kumi-ngburingkadinama warenja-bawiya, kumi-jungwunama makina arakba. Dukwa ekalara-manja kumu-dadinama makina. Umba nungkwurraja karnumamalya nare-ka kirrakina a-werrikambilyuma Neningikarrawaru-wa, akena eneja nakina Neningikarrawara yikenu-kwunama kirrakina dumbala karnik-awiyebi-yada amandangwa-da,” ni-yama Jesus ena-langwu-wa warnikabuburrakiyuwa. ");
INSERT INTO aoi_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Biya ni-yama ngarningka nakina aburruwa-wa, “Nara kembirra a-lyangmilyangmurukwajuma a-werrikawarriyaduma aninga-langwa iya akubibeka-langwa. ");
INSERT INTO aoi_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Umba aburraja warnumamalya wurribina warningbala-murruwiya Neningikarrawara na-lyangmurukweyiname-ka aninga-manja akwa ngawa akubibeka-manja wurrakina-da. Eneja Nungwena Neningikarrawara neningme-ka ningki-ngayindena-mulangwa ningkakina aninga-murriya akwa akubibeka-murriya kajungwa k-ambilyi-yada ningkeniba aduwaba ningkakina-da. ");
INSERT INTO aoi_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Nara kembirra a-lyangmilyangmurukwajuma a-werrikawarriyaduma amukwiyadakinu-wa, umba ki-lyangmurukweyinama nungkuwa kinumin-engkirrikajama Neningikarrawaru-wa, mena nungkwa-langwa ngawa Nubungkawa nakina-baba-da. Kembirra eneja Neningikarrawara kenu-kwunama amurndakibina aninga akwa akubibeka-murriya nungkuwa-wa-da. ");
INSERT INTO aoi_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Ngeniyerriya, kirrambawura karna karnumamalya nganyangwa,” ni-yama ngarningka nakina Jesus. “Kembirra nara akbar•duma, mena Nungwenungwa kirreni-ngayindena-mubaba kinu-bungkawadinama nakina nungkwurruwa-manja. Ngarra-makama arakba nungkwurruwa-manja Neningikarrawara kirren-akwurrajina-mulangwa kirrakina aduwaba. ");
INSERT INTO aoi_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Kembirra nungkwurraja yika-kwunama amurndakijika wurrukwalu-wa warnumamalya akwa yiku-menama angwarnda akina-murrada. Kembirra yika-kwunama ebina-murrada ngawa angwarnda warningalyingmalyingma-wa warnumamalya-da aburra-langwi-yada eningangkawura akina. “Umba ki-yamina-manja nungkuwa akina, ku-menama kembirra eninginingaba-wiya nungkwa-langwa ambaka-murra Neningikarrawara-langwa-manja angalya abalkaya. Umba ngalaja amurndakakina eninginingaba-wiya alarrngekburna-wiya Neningikarrawara-langwa-manja angalya nare-ka a-jerriduma akina. Enena-manja angalya ningki-larrngkumurndukwunama ababurna amurndakijika, akena amurndakakine-ka kuw-enungkwurakbadinama kuw-arriyadinama akina. Dukwa akwala ka-lyumadinama akina. Dukwa aburraja warnumamalya wurrengkengmina kuw-angmadama akwala amurndakibina nungkwa-langwa. Dukwa aburraja wurrilukukwulyilya kuw-alyubarinama akwala wurrakina. Akena Neningikarrawara-langwa-manja angalya abalkaya nara-da. Nara angmaduma wurrengkengmina warnumamalya, akwa nara alyubaruma wurrilukukwulyilya yakwujina wurrakina-da. Ngalaja eningangkawura alarrngekburna nungkwa-langwa kuw-ambilyama akina yakwujina ngawa-da. ");
INSERT INTO aoi_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","“Neningikarrawara kinu-bungkawadina-manja nungkuwa-manja, kembirra nungkwa-langwa mada kumu-likajama ngawa enuwa-wa. Umba kumu-likaja-manja nungkwa-langwa mada amurndakijika-murriya-wa kirri-ngayindena-murruwa, nara kembirra Neningikarrawara a-bungkawaduma nakina nungkuwa-manja,” ni-yama Jesus ena-langwu-wa warnikabuburrakiyuwa. ");
INSERT INTO aoi_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","36","Biya enena engka ayakwa nenu-makama Jesus ena-langwu-wa warnikabuburrakiyuwa. “Yik-embirrarinama ngawa kirrakina ngayuwa-wa, yik-andandiyama ki-lawurradina-murruwa ningena,” ni-yama nakina. Biya nenu-makama enena alawudawarra wurrukwala-langwa warnikuminuwar•duwar•da nuw-embirrarinu-murrilangwa aburra-langwu-wa nubungkawa. Nuwilyaba n-ambilyuma nakina nubungkawa ena-langwa-manja angalya. Biya nakina nubungkawa ni-likena neni-yekirrerrikama ena-langwa nenumamalya mena nakine-ka nenumamalya nanga-mangu-murrubaba dadingiyenikba ena-langwa. Biya nakina nubungkawa akwa ngawa wurrukwala warnumamalya aburrajukwaba neni-yekirrerrikama nakina-manja nenumamalya akwa ne-yebukeyinuma aninga wurruwurrakawura-ma wurrakina. Aburraja warnikuminuwar•duwar•da nakina-langwa nubungkawa nuw-embirrarinuma angalya-manja ngawa kini-lawurradina-murruwa aburra-langwa nubungkawa. Nuw-embimbirrarinuma na-mumirakwulaluma ngawa wurrakina. Nara ka-mungkwula, nara karring-aburawaka dumbala dadingikarrawara marringi-yada umba na-mirakwulaluma ngawa. Akwa ngarningka nara karri-jungwajuwa aburra-langwa bajananga. Nuw-embimbirrarinu...wa. Kembirra arakba-langwa ni-yar•da eneja nibina nubungkawa. Aburraja nuw-engkirrikena wurrakina ni-ringbajanguma nakina akididijungwa-manja. Biya kembirra nara kuw-ambudidina umba warenja-bawiya na-warumajungwa, narru-ngwurrkbalijuwa akawiyuwiyeba akwa nen-awiyebajuwa arakba aburra-langwa nubungkawa wurrakina warnikuminuwar•duwar•da-da. ");
INSERT INTO aoi_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","38","Dukwa marngkirngkuwilyarra, dukwa nara-wiya ke-kbadanga ni-lawurradinuma eneja nakina nubungkawa akena aburraja nuw-embimbirrarinuma ngawa wurrakina-da. Ni-lyelyingminuma nakina nubungkawa nara-baba ka-mungkwula ena-langwa warnikuminuwar•duwar•da umba nuw-embimbirrarinuma ngawa wurrakina-baba. Biya nang-aburawaka ena-langwa dadingikarrawara dumbala akwa nu-manga nakina aninga akwa nen-angmakayijuwama wurrakina. Mama aburra-langwa nubungkawa nakina umba nenu-kwama arakba wurrakina. Umba ni-yekirrerriduma ngawa akwa neni-yekirrerrikama wurrakina-manja warnikuminuwar•duwar•da ena-langwa-manja aburrajukwaba-da. Neni-yekirrerrikama amandangwa nakina nubungkawa wurrakina-manja warnikuminuwar•duwar•da-da nuw-embirrarinu-mulangwa enuwa-wa wurrakina-da. Ena ngawa alawudawarra-da. ");
INSERT INTO aoi_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Akine-ka alawudawarra nenu-makama Jesus ena-langwa-manja warnikabuburrakiyuwa. Biya kembirra ni-yama nakina aburruwa-wa, “Nungkwurrajukwaba yik-embirrarinama kirrakina kirruwerringmurndirra ki-lawurradina-murruwa ngayuwa yangkwurrangwa enenu-wa angalya. Yik-embirrarinama kirrakina wurrumurndakibina wuburra warnikuminuwar•duwar•da. Akena nare-ka e-yamama wuburra nakina nabalija numinakina alikira. Nakine-ka neningbala neniki-lika-langwa nengkengmina nenungkwarba ena-langwu-wa alikira. Kin-eningmidinu-manja nakina nengkengmina-langwa neniki-lika-langwa nakina ena-langwu-wa angalya, kembirra nara-maka ken-awiyebajuwa nakina nengkengmina-na? Nare-ka. Kin-andeya-maka ngawa nakina nabalija alikira-da. ");
INSERT INTO aoi_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","“Nungkwurraja nungkwurruwa karnikabuburrakiyuwa nganyangwa yik-embirrarinama ngawa kirrakina ngayuwa-wa, mena ngayuwa, ningibina-murrada ningi-rukwularrinuma enena-manja angalya, ki-lawurradinama ngayuwa karningbala-wiya kirrakina. Ki-lawurradinama ngayuwa nara-manja andiyama karna karnumamalya-da,” ni-yama Jesus ena-langwu-wa warnikabuburrakiyuwa-da. ");
INSERT INTO aoi_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Eneja kembirra Bida ni-yama nakina Jesus-uwa, “Bungkawa, akina alawudawarra yirru-makama yirruwa-manja, yirruwa-langwa yimbukwa yinda yirrababurna-langwa?” ni-yama. ");
INSERT INTO aoi_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Eneja ni-yama Nubungkawa Jesus Bida-wa akwa ena-langwu-wa wurrukwala warnikabuburrakiyuwa, “Yi-maka-langwa. Nibina nuwilyaba nenikuminuwar•duwar•da nuwerrikidirrbura akwa aringkawa numiyambene-ka nakina? Eneja nubungkawa ena-langwa nenu-bungkawakama nakina nenikuminuwar•duwar•da nubungkawa wurrukwala-manja warnikuminuwar•duwar•da. Akwa nenu-war•duwar•dikinama arakba nakina wurrumurndakakina-manja warnungkwarba iya wurridarringka, akwa nenu-kukwunama aninga nubungakwa-langwa wurrumurndakakinu-wa warnungkwarba iya wurridarringka mababurna-langwa marringa. Kini-yamarrkinama kembirra kinu-war•denama nakina warka nara-wiya nibina nubungkawa ena-langwa? Nakine-ka nenungkwarba kinu-war•denama eningaba warka neningangkawura kini-likaja-wiya engku-wa ena-langwa nubungkawa-da. ");
INSERT INTO aoi_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","“Kembirra kini-lawurradina-manja eneja nakina nubungkawa angalyu-wa akwa keni-rringkina-manja ena-langwa nenikuminuwar•duwar•da nu-war•danguma eningaba warka, kembirra kini-lyelyingminama nakina nubungkawa-da. Akwa niyekirrerra kin-ambilyama enejukwaba nibina nenikuminuwar•duwar•da ena-langwa-da. ");
INSERT INTO aoi_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Kembirra nakine-ka nubungkawa ena-langwa kenu-bungkawakinama nakina nenikuminuwar•duwar•da ena-langwa ababurna-manja amurndakijika ena-langwa-manja-da,” ni-yama Jesus. ");
INSERT INTO aoi_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Biya ngarningka ni-yama Jesus, “Akena nibina-murrada ngawa nenikuminuwar•duwar•da dukwa kini-lyangkiyaminama nakina, ‘Nara a-lawurraduma umba n-ambudida nubungkawa-da,’ kini-yaminama. Biya arakba keni-larrkbarjenama nakina wurrumurndakibina-manja warnungkwarba iya wurridarringka kenu-war•dikina-murrumanja nakina. Nara arakba a-war•duma eningaba warka, umba erribirra kinu-war•denama awurrariya warka-da. Ababurne-ka aninga kin-alyubarinama nara-wiya nibina ena-langwa nubungkawa-da. Akwa kini-bekinama anija nakina, kinu-bungwurridinama-da. ");
INSERT INTO aoi_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","“Bi...ya eneja ena-langwa nubungkawa kini-lawurradinama nakina arakba-da. Kini-yar•denama warenja-bawiya, nara-manja engkirrikuma nibina nenikuminuwar•duwar•da neniki-lawurrada-langwa nakina nubungkawa ena-langwa. Kembirra nakina nubungkawa kini-yamarrkinama dukwa ena-langwa-manja nenikuminuwar•duwar•da? Amandangwa kembirra kenu-wardenama nakina-da wuburra laka warnumamalya aburrajukwaba narra-wardenama wurruwurrariya-manja warnumamalya,” ni-yama Jesus. ");
INSERT INTO aoi_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Akwa ena engka,” ni-yama ngarningka Jesus. “Nuwilyaba nenikuminuwar•duwar•da niminingka-dangwa eneja neningma nakina ababurna-langwa neniki-yama-langwa nenumini-ngayindangu-mulangwiya ngawa nibina ena-langwa nubungkawa. Akena nara nakina aminu-war•duma eningaba warka. Kembirra eneja ena-langwa nubungkawa keni-larrkbarjenama angwurra nakina ena-langwa-manja nenikuminuwar•duwar•da nuwurrariya-manja. ");
INSERT INTO aoi_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Umba eneja ningka-langwa nenikuminuwar•duwar•da neningbala nakina neniki-yama-langwa nenumini-ngayindangu-mulangwiya ena-langwi-yada nubungkawa. Enejukwaba nara nakina aminu-war•duma eningaba warka. Kembirra eneja ena-langwa nubungkawa keni-larrkbarjenama ambaka-langwa nakina ena-langwa-manja nenikuminuwar•duwar•da nuwurrariya-manja, neningbala-baba nakine-ka-da,” ni-yama nakina Jesus. Biya ni-yama ngarningka Jesus, “Kembirra yikenu-kwuna-manja Neningikarrawara aruma warka nungkwurruwa-wa, nungkwurraja yikinumin-engkirrikajame-ka kirrakina enuwa-wa akwa yikinuminu-war•denama kirrumurndamurndirra alyangmandukwuna ngawa warka. Umba yikenu-kwuna-manja Neningikarrawara nungkwurruwa-manja warka, ebina aruma angwurra, kembirra yikinumin-engkirrikajame-ka akwa yikinuminu-war•denama angwurra ngawa kirrakina-da,” ni-yama nakina Jesus Bida-wa akwa ngawa ena-langwu-wa wurrukwala warnikabuburrakiyuwa. ");
INSERT INTO aoi_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Biya ni-yengbina nakina Jesus ayakwa ena-langwa-manja warnikabuburrakiyuwa wurrababurna-manja. Ni-yama, “Ngayuwe-ka ningena ningi-likenuma enenu-wa angalya kajungwa ki-lyangkuwerribikajungwuni-yada karningaba-murrikba akwa kirruwurrariya-murrikba karna akwa ngawa warningaba-murrikba akwa wurruwurrariya-murrikba aburrajukwaba wurrababurna-langwa wurrukwala warnumamalya. Ki-yaminama ngayuwa wuburra laka ke-kilarrkajama angwura kajungwa ki-dakini-yada ngayuwa alarrngkilarrngkawarriya amurndakijika. Karukwa! Ke-kalaridinuma arakba akina angwura, ");
INSERT INTO aoi_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","akena nara ambaka e-kalariduma, mena adinuba-wiya ningeniki-lyandi-yada ngayuwa-baba-da. “Ki-lyandina-manja ngayuwa, wuburra laka ku-ngwur•dirruwajungwunama ngayuwa akarrkwujaja-manja arrawa ke-yaminama akina. Ebina-wiya nenu-mingekingambajuwa-manja Janjana nuwilyaba nenungkwarba, eneja nakina nenungkwarba nu-ngwur•dirruwajungwunuma akungwa-manja. Umba ki-lyandina-manja ngayuwa, akine-ka wuburra ke-yaminama, wuburra laka ku-ngwur•dirruwajungwunama ngayuwa akarrkwujaja-manja arrawa. Karukwa! Ningu-werrikawarriyadiname-ka ngayuwa akina-langwa akarrkwujaja. Akwa ku-werrikawarriyadinama ngawa yanda-langwa ki-jerrukwuna-manja ngayuwa akina akarrkwujaja-da,” ni-yama nakina Jesus ena-langwu-wa warnikabuburrakiyuwa. ");
INSERT INTO aoi_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Biya kembirra ngarningka Jesus ni-yama, “Kirri-yamarrkinama kirr-engkirrikajama nungkwurruwa kembirra nganyangwa-langwa? Laka ningi-likenuma ningena enenu-wa angalya kajungwa ka-marumini-yada ngayuwa warnumamalya-langwa? Nare-ka. Ningi-likenuma ngayuwa enenu-wa angalya kajungwa warnumamalya ke-beyini-yada ngawa wurrakina akwa kuw-awinyambakeyini-yada nganyangwa-langwa wurrakina. ");
INSERT INTO aoi_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","“Dukwa kuw-ambilyama aburraja wurrumangbala warnumamalya awilyaba-manja ngawa alikira. Kembirra aduwaba-langwa wurrubukalakina wurrubukabiyakarbiya karra-wirrikbinama wurrakinu-wa wurrambilyuma. ");
INSERT INTO aoi_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Dukwa wunenukwa-manja kenu-wirrikbijeyinama wunalakina-da. Umba dukwa aburringajukwaba wurringaburra-manja karringu-wirrikbajeyinama wurringalakina-da. Umba dukwa wurringadija-manja ngarningka ngawa karringu-wirrikbajeyinama aburringajukwaba-da,” ni-yama Jesus ena-langwu-wa warnikabuburrakiyuwa. ");
INSERT INTO aoi_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Biya kembirra ni-yengbinuma ngarningka nakina Jesus wurrumurndakibinu-wa warnumamalya wurrababurna-langwu-wa. Akwa ni-yama, “Yiki-rringkina-manja kirrakina angubina ka-lumur•dina-manja akina akwa ka-lukwulyuwakena-manja akina akwaburrangarna-langwa, ka-warumajungwuna-manja akina, kembirra yiku-makijeyinama akina-langwa. Biya warenja-bawiya yiki-yaminama kirrakina, ‘Yelyukwe-ka yubukwaya-da.’ Ngalaja kembirra kini-larrinama amandangwa yelyukwa adinuba. ");
INSERT INTO aoi_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Umba yik-engkirrikaja-manja ngarningka arrirra dalada kuw-angkarrina-manja akina angwurra, kembirra yiki-yaminama kirrakina, ‘Mubukwaya arakba mukwena-da,’ yiki-yaminama kirrakina-da. Biya amandangwa-da. ");
INSERT INTO aoi_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","“Karningme-ka karna yelyukwa-langwa yiki-rringkina-mulangwa angubina. Kemba miyambena-burra nara kirrakina a-miringkama ababurna-langwa Neningikarrawara ni-ngekburakina-mulangwa enena-manja angalya aduwaba? Karniniyerriya karnumamalya, kirra-ngayindenama karna wurrukwala warnumamalya ke-yaminama wurrakina nungkwurra-langwa-langwa, ‘Warningabe-ka warna warnumamalya,’ akena kirruwurrariya karnumamalya kirrakina-da,” ni-yama Jesus wurrumurndakibinu-wa warnumamalya wurrababurnu-wa-da. ");
INSERT INTO aoi_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Biya kembirra ngarningka Jesus ni-yama aburruwa-wa, “Miyambena-burra nara a-lyangkuwerribikajungwuma kirrakina nungkwurrabakiya-ba ebina eningaba karniki-yama-langwa nungkwurruwa karnumamalya? ");
INSERT INTO aoi_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Dukwa eneja nuwilyaba nenumamalya keni-lekbajama nungkuwa-wa. Kembirra kinalakina ambaka-langwa yikini-lyelyimbukweyinama akina-langwa. Dukwa kenu-wilyakinama nakina nungkuwa nubungkawu-wa akina-langwa awurrariya ningki-yama-mulangwa. Kembirra kenu-wilyakina-manja ngawa ningkakina nibina yikini-lyelyimbukweyinama lukwakwa akina-langwa kinalakina-da, nungkuwa akwa nibina ngini-lekbuma nungkuwa-wa-da. Yikini-lyelyimbukweyinama nara-wiya e-yar•duma nubungkawa-langwa-manja alikira kinalakina-da. Nara ambudiduma ningkakina, umba kini-yekirrerrikinama nibina nenumamalya ningkakina-da, kajungwa kenumini-yakuwabijini-yada nakina ebina awurrariya ningki-yama-mulangwa ningkakina-da. “Nara-manja nungkuwa e-yekirrerrikama nibina nenumamalya, nakine-ka kembirra kenu-wilyakinama dirrbura nungkuwa nubungkawu-wa ningkakina. Eneja nakina nubungkawa kini-lyangkuwerribikajungwunama karnumamalya-langwa, karningaba-murrikba akwa kirruwurrariya-murrikba. Nakine-ka kembirra nubungkawa kenu-kwunama nungkuwa nuwilyaba-manja nawinyamba nenungkwarba. Eneja kembirra nakina nawinyamba nenungkwarba ken-awiyebajinama ningkakina akididijungwa-manja, keni-didenama ningkakina-da. Kemba yakwujina ngawa nungkwaja k-ambilyama ningkeningamiyerra-da. K-ambambilyama ngawa. ");
INSERT INTO aoi_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Nara-manja ningkakina a-kwama enuwa-manja ababurna-langwa angwarnda ebina ni-ngayindenama, nara kemba a-jadijuma ningkakina mibina-langwa medirra nibina nubungkawa nakina-da. Kinu-kwuname-ka angwarnda ababurna-langwa ningkakina-da,” ni-yama Jesus wurrumurndakibinu-wa warnumamalya wurrababurnu-wa nakina-da. ");
INSERT INTO aoi_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Akini-yada ngawa aburraja wurrukwala warnumamalya nenu-makama Jesus-manja enena ayakwa ni-yama-mulangwa nubungkawa Balida. Ne-yama wurrakina enuwa-wa, “Nakine-ka Balida nenu-makama ena-langwa-manja wurrawinyamba warnungkwarba, biya narra-wardanguma wurrakina wurrukwala-manja warnungkwarba WarningiKeliliya-manja,” ne-yama. “Wurrakine-ka warnungkwarba WarningiKeliliya na-likenuma Keliliya-langwa akwa angerriba Jirujalemu-wa Neningikarrawara-langwu-wa angalya, kajungwa kenuminu-wardeni-yada jiba-murriya Neningikarrawara-langwa yakwujina. Umba yakwujina ngawa wurribina wurrawinyamba warnungkwarba narra-wardanguma wurrakina-manja warnumamalya, nenu-maka-mubaba nubungkawa Balida. Ngalaja mibina merra aburra-langwa akwa ngawa jiba-murriya-langwa numu-ngwunyurrkweyinuma makina-da,” ne-yama nenu-maka Jesus-manja wurrakina warnumamalya-da. ");
INSERT INTO aoi_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Eneja ni-yama Jesus aburruwa-wa, “Wurrumiyambena warnumamalya wurrumurndakakina? Na-jungweyinuma wurrakina wurruwurrariya-baba-na? Wurruwurrariya angwurra wurrukwala-manja warnumamalya WarningiKeliliya-na? ");
INSERT INTO aoi_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Nare-ka! Umba nungkwurraja karnumamalya, yiku-wurrenama aduwaba awurruwurrariya akwa yikinumini-yarrkuwarakinama Neningikarrawara-langwa ayakwa kirrakina. Nara-manja a-wurruma kirrakina awurruwurrariya akwa amini-yarrkuwarakama Neningikarrawara-langwa ayakwa, kembirra nungkwurrajukwaba yiki-jungwunama-da. Wuburra wurrumurndakibina WarningiKeliliya warnungkwarba yiki-yaminama kirrakina yiki-jerridinama karningangkawura. ");
INSERT INTO aoi_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","“Umba wi-yakuwerribikaja wurrumurndakibinu-wa wurrukwala warnumamalya nuw-ambilyu-murruwa Jirujalema-manja engemba angalya Jilawuma-manja. Wurrakine-ka namurndaki-jungweyinuma wurrumemberrkwa wurrumangbala wurrabiyakarbiya warnumamalya yakwujina. Ngalaja alikira na-ringkilarruma alingajirrirra akwa narraku-wardanguma wurrumurndakakina warnumamalya. Wurrumiyambena kemba wurrumurndakakina warnumamalya? Wurruwurrariya angwurra wurrakina wurrababurna-manja warnumamalya Jirujalema-manja-na? ");
INSERT INTO aoi_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Nare-ka! Umba nungkwurraja, yiku-wurrenama aduwaba awurruwurrariya akwa yikinumini-yarrkuwarakinama Neningikarrawara-langwa ayakwa. Nara-manja a-wurruma kirrakina awurruwurrariya akwa amini-yarrkuwarakama Neningikarrawara-langwa ayakwa, kembirra nungkwurrajukwaba yiki-jungwunama-da. Wurrumurndakibina wuburra warnumamalya Jirujalema-manja yiki-yaminama yiki-jerridinama karningangkawura kirrakina,” ni-yama Jesus wurrumurndakibinu-wa warnumamalya-da. ");
INSERT INTO aoi_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Biya enena kembirra alawudawarra eka-langwa nenu-makama Jesus wurrumurndakakina-manja warnumamalya. Nuwilyaba nenungkwarba numa-lungkuwabijuwama nakina muwilyaba manyungwunya ebina-manja ngawa angalya ni-lungkuwabijuwa-murrumanja nakina akwurena. Biya arngkawura ni-likenuma nakina n-aburangkama makinu-wa manyungwunya mamaninga akena nara mibina kinum-akburrangarna nakina. ");
INSERT INTO aoi_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Biya nenu-makama nakina ena-langwa-manja nenikuminuwar•duwar•da. “Kwuja,” ni-yama, “ningi-likenuma ngayuwa ebini-yada akilarrkardidarra ning-aburangkama mamaninga. Arngkabiyakarbiya-ma akilarrkardidarra arakba ning-aburangkama mamaninga mema-manja mememeka nganyangwa-manja, akena nara mibina. Na-mar•dena-mubaba ena angalya, kembirra yimini-ridena-langwa mema,” ni-yama enuwa-wa. ");
INSERT INTO aoi_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Eneja ni-yama ena-langwa nenikuminuwar•duwar•da enuwa-wa, “Ma-lalika ambaka mema awilyaba ngarningka akilarrkardidarra abukwaya. Adinuba-wiya ngu-mungkadina-langwa ajiringka, kembirra kum-akumurnama yimi bulukwa-langwa yelakwa eningabi-yada ajiringka. Kum-ambilyama ngawa mema yanda-langwa engka-manja akilarrkardidarra. ");
INSERT INTO aoi_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Kembirra kuw-arrangbina-manja mamaninga ngala-langwa, eningaba akina. Akena nara-manja arrangbama mamaninga makina, kembirra ambaka-murra yibamini-ridenama ngayuwa mema manyungwunya nungkwa-langwa,” ni-yama nakina nenikuminuwar•duwar•da, nenu-makama ena-langwa-manja nubungkawa. Ena ngawa. Enena alawudawarra nenu-makama Jesus wurrumurndakibina-manja warnumamalya. ");
INSERT INTO aoi_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","11","Ngalaja dakina duwilyaba didarringka ying-ambilyumurra, akena narringa-wilyakama wurruwilyaba wurruwurrariya wurramukwa ngaluwa-manja. Wurrakine-ka wurramukwa narring-angbilyuwakama dakina. Dadinungkwurakbe-ka angbilyuwa dakina yingaku-wardanguma, akwa nara dirrbura kingi-likena umba ying-abuluwenduma dadingangkawura ngawa. Yingi-yaminjamama ngawa dakinu...wa. Ying-abuluwenduma mememberrkwa mamangbala mabiyakarbiya mamarika iya yinungkwura. Kembirra muwilyaba-manja mukwurdukwurda mamawura Jebuda dakina yingi-likenuma akinu-wa alikira jinikakwa. Umba akini-yada ngawa eneja Jesus nenu-wilyakajuwama yakwujina nakina warnumamalya-manja jinikakwa-manja. ");
INSERT INTO aoi_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Biya nanga-rringka-manja nakina Jesus, kembirra nang-ardijuwa dadiki-liki-yada enuwa-wa. “Ngeniyerriya, ngarr-enjungwurrenama arakba ngayuwa angbilyuwa-langwa,” ni-yama nakina ngaluwa-wa. ");
INSERT INTO aoi_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Biya nanga-mingekilyinga Jesus ayarrka-murra dakina-manja didarringka, umba arngkawura-wiya ngawa ngalaja yingi-dirrburada arakba dakina-da. Biya kembirra arakba yingini-yangmarngkwajuwa Neningikarrawaru-wa dakina didarringka-da. ");
INSERT INTO aoi_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Akena eneja nubungkawa neningijinikakwa n-awinyambada nakina, mena Jebuda-manja nang-eningabaka-mubaba Jesus dakina didarringka. Biya kembirra ni-yengbina nakina nubungkawa enena ayakwa wurrumurndakibina-manja warnumamalya yakwujina. “Yaku-war•denama warka mamangbala muwilyaba-manja mamawura yalakena,” ni-yama, “akena aduwaba nare-ka a-war•duma yalakena mena Jebuda-baba ena-da,” ni-yama nakina aburruwa-wa. “Yika-ngayindena-manja karna yikab-eningabakina-manja warnumamalya angbilyuwa-langwa, nara kembirra Jebuda-manja aburangkama eningabakama warnumamalya angbilyuwa-langwa, umba yiki-likajama yangkwurrangwa mamurndakibina-manja mamawura mamangbala muwilyaba-manja kirrakina,” ni-yama nubungkawa neningijinikakwa aburruwa-wa-da. ");
INSERT INTO aoi_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Eneja Nubungkawa Jesus ni-yama enuwa-wa akwa wurrumurndakibinu-wa warnumamalya, “Karniniyerriye-ka karna kirrububungkawa,” ni-yama, “kirra-ngayindenama karna wurrukwala warnungkwarba ke-yaminama, ‘Warningabe-ka warna wurrububungkawa,’ ke-yaminama, akena kirri-kadikajungwunama kirrakina-da,” ni-yama. “Ningkeningerribirra ningkenumamalya k-aburawakinama bulukwa akwa dangki nungkwa-langwa Jebuda-manja akwa ku-wilyakinama akina akungwa-wa. ");
INSERT INTO aoi_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Ngalaja daka didarringka dadikaduwa Aburiyama-langwa dumirenikba daka-da, akena eneja Namukwa nanga-lamiranguma daka dadinungkwurakba-da. Mememberrkwa mamangbala mabiyakarbiya mamarika iya yinungkwura nara king-arjeya dirrbura daka umba aduwaba-manji-kba-da. Eningaba akina ngayuwa ninging-enjungwurrangu-mulangwa daka didarringka Jebuda-manja-na?” ni-yama nakina Jesus nibinu-wa nubungkawa neningijinikakwu-wa. ");
INSERT INTO aoi_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Umba ni-yengbinu-manja Jesus akina ayakwa, aburraja warnungkwarba yakwujina wurribina nenu-wirrikba-murrumurra Jesus-uwa wurrakina namurndakumini-yelijungwunuma, mena nen-arndirrangu-mubaba nakina Jesus wurrakina. Akena aburraja wurrababurna warnumamalya na-werrikilyelyingmajungwunuma wurrakina ni-yama-mulangwa Jesus enininginingaba-da. ");
INSERT INTO aoi_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Eneja kembirra Jesus ni-yengbinuma ngarningka ayakwa wurrumurndakibinu-wa warnumamalya nuw-ambilyu-murruwa yakwujina jinikakwa-manja. “Kini-yamarrkinama Neningikarrawara kinu-bungkawadina-manja nakina?” ni-yama. “Umba amiyambena ayakwa ka-makinama ngayuwa nungkwurruwa-manja kajungwa yik-eningmidini-yada kirrakina kinu-bungkawadina-mulangwa Neningikarrawara?” ni-yama. “Kwuja, kinu-bungkawadinama nakina adinuba-wiya wurrambawura-manja warnumamalya. Bi...ya ngarningka wurruwurrakwulyumida-manja warnumamalya kinu-bungkawadinama Neningikarrawara kembirra arakba nakina-da. ");
INSERT INTO aoi_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","21","“Kwuja, ngayuwa ka-makinama ambilyuma-kiya alawudawarra, awilyaba eka-langwa umba awilyaba damba-langwa,” ni-yama ngarningka Jesus wurrumurndakibinu-wa warnumamalya. Nuwilyabe-ka nenungkwarba nu-manguma nakina awilyaba amadidira embirrkaluwa eyukwujiye-ka akwa ni-lungkuwabijuwa akina. Ngalaja kembirra na-lungkuwarrinuma akina amadidira yanda-langwa aruma eka nuw-arjeyuma akina. Kembirra aburraja wurrajija nuw-ambarrinuma ememeka-manja akwa narruma-ngekburakama miyerriya aburra-langwa yakwujina. Umba ngarningka ngalaja duwilyaba didarringka yingu-manguma dakina akubudika iya bulawa akwa akungwa dambi-yada. E...yukwujiye-ka akubudika yingu-manguma dakina. Akena ngalaja akina akubudika eyukwujiya na-war•danguma damba-manja, yanda-langwa akina na-milyingkuwarumajungwunuma akwa na-budinuma aruma. Akina ngawa alakina-kiya alawudawarra-da. Biya ni-yama ngarningka Jesus aburruwa-wa, “Ka-makinama kembirra ngarningka ngayuwa kinu-bungkawadina-mulangwa nakina Neningikarrawara. Ke-yaminama akina wuburra laka ebina eyukwujiya amadidira na-lungkuwarrinama ajiringka-manja yanda-langwa adirrungwarna eka kembirra nuw-arjiyama akina. Akwa ke-yaminama ngarningka akina wuburra laka ebina eyukwujiya akubudika na-milyingkuwarumajinama akina damba kembirra adirrungwarna. Adinuba-wiya eneja Neningikarrawara kinu-bungkawadinama nakina wurrambawura-manja warnumamalya. Umba ambaka-murrumurra kinu-bungkawadinama Neningikarrawara wurruwurrakwulyumida-manje-ka warnumamalya arakba nakina-da,” ni-yama Jesus wurrumurndakibina-manja warnumamalya nakina-da. ");
INSERT INTO aoi_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Nakine-ka Jesus akwa ena-langwa warnikabuburrakiyuwa narruma-yuwarnuma wurrakina mibina mamurukwa numu-likenuma Jirujalemu-wa. Nawurrak-alilikenu...wa. Biya lukwakwa wurrakina na-ngwanjinuma ababurna-manja angalya, waka aminababurna-manja alikira, umba waka aminambawura-manja alikira. Biya Jesus nen-akakirumakama ayakwa yakwujina wurruminakina-manja angalya warnumamalya akwa ngawa ena-langwa-manja warnikabuburrakiyuwa aburrajukwaba. ");
INSERT INTO aoi_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Umba eneja nuwilyaba nenumamalya ni-yama Jesus-uwa, “Bungkawa, Neningikarrawara aken-enibikinama wulkwa ngarrambawura-manja ngarnumamalya?” Eneja Jesus ni-lawurrakaja enena ayakwa enuwa-wa akwa ngarningka wurrukwalu-wa warnumamalya aburrajukwaba. Ni-yama, ");
INSERT INTO aoi_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Yik-aburangkeyinama angwurra kirrakina karnumamalya karnik-awiyebi-yada Neningikarrawara-langwu-wa angalya. Yiki-yaminama wuburra laka kirr-awiyebenama alikira-manja e...yukwujiya-langwiya edirra. Kembirra yik-aburangkeyinama angwurra aduwaba mena aburrajukwaba wurrababurna warnumamalya kuw-aburangkeyinama wurrakina akinu-wa edirra warnik-awiyebi-yada, akena ka-lyangmuridinama wurrakina-da. Kembirra nungkwurraja yik-aburangkinama aduwaba angwurra kirrakina-da,” ni-yama Jesus wurrumurndakakinu-wa warnumamalya. ");
INSERT INTO aoi_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Biya ni-yama ngarningka Jesus, “Eneja numinakina angalya nabalija kinu-warumajungwunama nakina akwa kini-didenama akina akididijungwa, akwurraka ngawa kin-akumurnama. Umba nungkwurraja errekba-manja-wiya yik-arjiyama akwa yik-ardenama enuwa-wa. ‘Bungkawa,’ yiki-yaminama, ‘yirr-awiyebajiya-langwa yirraja!’ yiki-yaminama. Akena eneja numinakina angalya kini-yaminama nungkwurruwa-wa, ‘Ningeningbala ningena nungkwurruwa. Karningamba-langwa kirrakina?’ kini-yaminama nakina-da. ");
INSERT INTO aoi_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","“Umba nungkwurraja yiki-yaminama nungkwurramba-langwa enuwa-wa, ‘Kada, ngarribina ngakwurruwa ngarri-yebukeyinu-murrada aninga akwa ngarri-bekeyinu-murrada ngarruwurrakawura-ma akubibeka ngarribina-da. Umba nungkwaja yirru-wilyakajuwa-murrada ayakwa yirra-langwa-manja angalya ningkibina-da,’ yiki-yaminama kirrakina-da. ");
INSERT INTO aoi_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","“Eneja kini-yaminama ngawa, ‘Ningeningbale-ka kirrakina, kirriminiminingke-ka karnumamalya. Jeyi! Karniniyerriya karnumamalya, engku-wa wurri-likaja yadada ngayuwa-langwa!’ kini-yaminama nakina-da,” ni-yama Jesus wurrumurndakakinu-wa warnumamalya. ");
INSERT INTO aoi_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","“Errekba-manja-wiya ngawa yiku-ngwadeyinama kirrakina,” ni-yama Jesus. “Yiku-ngwadungwadeyinama yiki-ringirriyadiname-ka yika-rringkina-mulangwa kirrakina wurrubukalakina Aburiyama iya Ajika iya Jekaba akwa ngawa aburrajukwaba wurrababurna-langwa WurruBuburabuda warnumamalya Neningikarrawara-langwa ena-langwa-manja angalya. Akena nara kirrakina awiyebuma umba errekba-manja-wiya ngawa yik-ambilyama. Yiku-ngwadeyinama angwurra kirrakina mena wurrumurndakibina warnumamalya kuw-ambilyama arrawa warningadinakba nara awiyebajuma kirrakina-da. ");
INSERT INTO aoi_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Umba aburraja wurrukwala warnumamalya ka-likajama yenjerrikina alyengmilyengma-langwa akwa akwaburrangarna-langwa. Engka-langwa iya engka-langwa angalya ka-likajama wurrakina kuw-awiyebeyinama Neningikarrawara-langwa-manja angalya. Biya kamurndak-ambarrinama kamurndaki-yebukeyinama wurruwurrakawura-ma wurrumurndakibina warnumamalya, akena nungkwurraja nara-da!” ni-yama Jesus wurrumurndakakinu-wa warnumamalya. ");
INSERT INTO aoi_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Biya ni-yama ngarningka Jesus, “Wurrukwale-ka warnumamalya kuw-arijidinamurra aduwaba akena ka-lyengmename-ka akini-yada ngawa wurrakina-da. Aburraja wurrukwala ka-lyengmenama aduwaba biya kembirra ka-likajama kuw-arijidiname-ka arija-langwa akini-yada ngawa wurrakina-da,” ni-yama Jesus nenu-makama wurrumurndakibina-manja warnumamalya nakina-da. ");
INSERT INTO aoi_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Akini-yada ngawa aburraja wurrubukwaya wurrukwala WurruBarija warnumamalya na-likenuma wurrakina Jesus-uwa. Biya ne-yama, “Nara yelakwa ambilyuma amiyerra ena-manja angalya, umba jeyi, likaja yadada,” ne-yama, “mena Nubungkawa Yerida ngini-ngayindenama kenu-wardenama ningkakina,” ne-yama wurrakina-da. ");
INSERT INTO aoi_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Eneja ni-yama Jesus aburruwa-wa, “Jeyi! Wurri-likaja Yeridu-wa. Yikinu-makine-ka nganyangwa ayakwa nakina-manja nuwarnkarnyerra nenumamalya. Nganje-ka ningena ningi-lyangmurukweyinama aduwaba, akwa ngarningka arnungkwaya ki-lyangmurukweyinama ningena ngawa. Ku-war•denama ningena ka-jadijinama wurramukwa warnumamalya-langwa akwa ka-ngekburakinama warnumamalya angbilyuwa-langwa aduwaba akwa ngawa arnungkwaya. Umba mabiyakarbiya-manja mamawura ki-jerrukwunama warka nganyangwa,” ni-yama Jesus. ");
INSERT INTO aoi_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","“Akena Jirujalemu-wa ki-likajama ngayuwa,” ni-yama. “Kuma-yuwarnama mamurukwa mibina numu-likajamurra Jirujalemu-wa aduwaba, akwa arnungkwaya, akwa mingka-manja. Jirujalemu-wa ki-likajama ningena mena yirruwa YirruBurabuda yarnumamalya Neningikarrawara-langwa nara aminukwala-manja angalya a-jungwuma yirrakina umba yiki-jungweyinama ngawa yarna yakwujina Jirujalema-manja-da,” ni-yama Jesus wurrumurndakakinu-wa WurruBarija warnumamalya. ");
INSERT INTO aoi_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“Karukwa! Karnumamalya KarningiJirujalema!” ni-yama Jesus. “Neni-larrkenu-manja nakina Neningikarrawara ena-langwa warnumamalya WurruBurabuda nungkwurruwa-wa, kembirra kirr-ar•dirranguma wurrakina malarra-murra. Kirr-errikbeyinuma malarra aburra-langwu-wa warnumadangkwa yanda-langwa kirra-jungwajuwama warningangkawura wurrakina-da. Biya aduwaba kirri-yaminjaminama kirrakina ngawa-da. “Karukwa!” ni-yama Jesus. “Ngarra-ngayindanguma nganja ngayuwa kawurra-murndukwama nungkwurruwa ngayuwa-manja wuburra laka dibina dirndarringba jukwujukwa narringawurra-murndukwunama dakina wurriyukwayuwa ngala-langwa ngaluwa-manja kajungwa wurringkinyungwurri-yada ngala-langwa-manja mememiyeja wurrakina-da. Akena nungkwurraja kirru-warangume-ka kirrakina karnumamalya-da. ");
INSERT INTO aoi_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","“Kembirra eneja nakina Neningikarrawara kini-lalikinama ena-langwa angalya (Jirujalema-manja), akena nara arakba akwurrajuma akina. Nganjukwaba ka-lalikinama kirrakina karnumamalya-da. Nara amandangwa a-rringkama karna ngayuwa yanda-langwa yiki-yaminama kirrakina enena ayakwa, ‘Akini-yangmarngkwajina nibina nenungkwarba neni-larrkama Neningikarrawara yangkwurrangwa kajungwa aken-enibikini-yada ngakwurruwa ena-langwa ngarnumamalya,’ yiki-yaminama kirrakina,” ni-yama Jesus nenu-makama wurrumurndakibina-manja warnumamalya WurruBarija-da. ");
INSERT INTO aoi_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Bi...ya arngkawura Jesus ni-likenuma nakina alikira-wa nuwilyaba-langwu-wa nenungkwarba NuBarija. Narume-ka nubungkawa nakina WurruBarija-langwa warnumamalya. Biya Jesus ni-likenuma nakina ena-langwu-wa alikira Jebuda-manja nenik-alyubari-yada nakina aninga yakwujina enuwa-manja. Akena nakine-ka NuBarija nenungkwarba akwa ngawa wurrukwala warnumamalya aburrajukwaba neni-rruburringkama ngawa Jesus-uwa wurrakina. ");
INSERT INTO aoi_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Neni-rringka-manja wurrakina Jesus-uwa, eneja nuwilyaba nenungkwarba ni-likena nakina enuwa-wa. Akena namurndaki-rrangkuwanginume-ka alakba iya ayarrmurra ena-langwa. ");
INSERT INTO aoi_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Umba eneja Jesus ni-yengbina ayakwa wurrukwalu-wa warnikakakirumaka Mawijija-langwa ayakwa eningarumuruma akwa ngawa wurrukwalu-wa WurruBarija warnumamalya. Ni-yama nakina, “Karningma karna Neningikarrawara-langwa ayakwa eningarumuruma. Kembirra ne-yamarrkinama ngarraku-makinama ena? Ak-eningabakina-manja ngarna warnumamalya Jebuda-manja angbilyuwa-langwa, eningaba akina yinda awurrariya?” ni-yama Jesus. ");
INSERT INTO aoi_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Aburraja nawurraki-yengminjada wurrakina. Umba Jesus nenu-minjirrkilyinga nibina-manja nenungkwarba akwa nen-eningabakama nakina akwa neni-larrka arakba angalyu-wa-da. ");
INSERT INTO aoi_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Biya Jesus ni-yama nakina wurrumurndakibinu-wa warnumamalya, “Kini-ngkilarrina-manja nenikuwena Jebuda-manja edirra-wa, kemba ki-yamarrkinama nungkuwa ningkakina? Akwa ke-ngkilarrina-manja bulukwa nungkwa-langwa edirra-wa Jebuda-manja, ki-yamarrkinama nungkuwa ningkakina? Mama Jebuda akina, umba warenja-bawiya kin-arrkirnama nenikuwena akwa k-arrkirnama ebina bulukwa nungkwa-langwa ngalajukwaba edirra-langwa-na?” ni-yama Jesus aburruwa-wa. ");
INSERT INTO aoi_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Nara aburraja kenumini-lawurrakajuwa awilyuwilyaba ayakwa enuwa-wa umba na-rrakiyinduma ngawa wurrakina. Nawurraki-yengminjaduma ngawa wurrumurndakakina warnumamalya. ");
INSERT INTO aoi_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Eneja Jesus nenu-miringka wurrumurndakakina warnumamalya narru-mar•dumar•du-mulangwa ebina eningaba angalya warnik-ambarringi-yada, mena na-lyangkiyamama wurrakina, “Ngarrarumuruma ngarnumamalya ngawa ngarna-da.” Kembirra nakina Jesus nenuwurraki-rringka-manja wurrakina, nenu-makama arakba enena ayakwa aburruwa-wa. ");
INSERT INTO aoi_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","Ni-yama, “Ken-ardijina-manja nungkuwa ningkakina nuwilyaba nenungkwarba ena-langwu-wa alikira aningi-yada, nara kembirra nungkwaja a-mar•duma angalya eningaba-dangwa ningkenik-ambarringi-yada nungkuwa. Dukwa eneja nabalija alikira nen-ardijuwama nakina nuwilyaba naruma nenungkwarba enejukwaba aninga-wa. Akena ningkiyukwujiye-ka ningkakina umba eneja nakina naruma. ");
INSERT INTO aoi_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Nara kembirra a-mar•duma eningaba-dangwa angalya, nari-yada e-yamama nibina nabalija alikira nungkuwa-wa, ‘Jeyi! En-ambarriya-langwa naka nenungkwarba yelakwa umba erribaja-wiya ningkakina.’ Kini-yamina-manja nakina akina ayakwa nungkuwa-wa, kembirra ku-werrikiyeliyenama ningkakina akwa ki-lalikinama ebina angalya ningku-mar•dangu-mulangwa. ");
INSERT INTO aoi_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","“Nara kembirra a-mar•duma eningaba angalya umba ki-likajama k-ambarrinama awurrariya-manja angalya. Mama nara a-rungekburakajungwuma ningkakina, umba k-ambarrinama yakwujina. Kembirra eneja kin-akwudangwukajungwuna-manja nibina nabalija alikira nungkuwa-wa, kini-yaminama nakina nungkuwa-wa, ‘Ngeniyerriya, awurrariya ena angalya nungkwa-langwa. Angerriba likaja eningabu-wa angalya, rungekburakajungwuna ningkakina,’ kini-yaminama nakina nungkuwa-wa. Kini-yamina-manja akina ayakwa, kembirra ka-lyangkiyaminama aburraja wurrababurna-langwa warnumamalya yakwujina, ‘Wa! Kwuja, narume-ka nakina nenumamalya-na!’ ka-lyangkiyaminama wurrakina. ");
INSERT INTO aoi_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Amandangwa nara-manja a-ngkweningabakajungwuma ningkakina, kembirra Neningikarrawara kini-yaminama nakina nungkuwa-wa, ‘Ningkeningabe-ka ningkakina ningkenumamalya,’ kini-yaminama nakina. Akena ku-ngkweningabakajungwuna-manja ningkakina, kembirra enamba-langwa Neningikarrawara arrkala keni-lyangkiyelijinama nungkuwa-manja nakina-da,” ni-yama Jesus wurrumurndakibinu-wa warnumamalya wurrababurnu-wa-da. ");
INSERT INTO aoi_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Biya kembirra ni-yengbina Jesus akwala ayakwa nabaliju-wa alikira nenungkwarba. “Ka-murndukwajina-manja ningkakina warnumamalya kajungwa karniki-yebukaji-yada aninga nungkwa-langwa-manja alikira, kembirra nara a-murndukwama warnumamalya nungkwa-langwa, wurribina nungwena-murriya, nawena-murriya, akwa wurribina wurrukwala wurruminababurna angwarnda warnumamalya. Aburramba-langwa dukwa kab-ardijinama wurrakina ambaka-murra aburra-langwu-wa alikira aningi-yada. Umba warningerribirra-langwa warnumamalya ka-murndukwunama nungkuwa-wa,” ni-yama Jesus. ");
INSERT INTO aoi_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","“Umba wurramukwiyadakena warnumamalya warningerribirra k-ardijinama nungkuwa-wa, wurrumurndakibina warningalyingmalyingma warnumamalya, wurrirrirrengmurrengmurnirna warnumamalya akwa ngawa wurrimimbimimba warnumamalya. ");
INSERT INTO aoi_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Mama nara wurrakina ardijuma nungkuwa aningi-yada aburramba-langwa umba eningaba ka-ngekburakajungwunama nungkwa-langwa. Eneja Neningikarrawara kini-yaminama eningaba nungkuwa-manja meningarija-langwa-manja mamawura kuw-enibudina-manja ngarningka warninginingaba warnumamalya wurribina ka-jungwuna-murrada,” ni-yama Jesus enuwa-wa-da. ");
INSERT INTO aoi_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Eneja nuwilyaba nenungkwarba n-engkirrika-manja amurndakibina ayakwa yakwujina ni-yengbinu-mulangwa Jesus, ni-yama nakina, “Ke-yekirrerridiname-ka wurrakina warnumamalya kuw-alyubarina-murrumurra aninga akini-yada ngawa kinu-bungkawadina-manja Neningikarrawara nakina-da,” ni-yama nakina. ");
INSERT INTO aoi_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Eneja kembirra Jesus nenu-makama enena alawudawarra enuwa-wa. Nuwilyaba nenungkwarba n-ambilyumurra nakina. Neni-ngayindanguma nakina ena-langwa warnumamalya wurrababurna warniki-liki-yada ena-langwu-wa alikira wurrakina kajungwa warniki-yebukaji-yada aninga yakwujina enuwa-manja. Kembirra ni-larrka ayakwa aburruwa-wa adinuba-wiya warniki-liki-yada wurrumurndakakina warnumamalya. Aburraja kembirra ena-langwa warnikuminuwar•duwar•da arakba narri-dakama aninga eminiminingka. Aruma aninga eningaba akwa ngawa akwalya narri-dakama wurrakina eningaba-da. ");
INSERT INTO aoi_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Kembirra na-walyuwa-manja arakba akwalya iya aninga, eneja nakina nubungkawa neni-larrka nuwilyaba nenikuminuwar•duwar•da ena-langwa wurrumurndakibinu-wa warnumamalya, kajungwa kawurraki-likaji-yada ena-langwu-wa alikira. Eneja kembirra ni-likena arakba nakina nenikuminuwar•duwar•da. Biya ni-yama nakina wurrumurndakibina-manja warnumamalya, “Awalyuwa arakba aninga, umba kwa!” ni-yama. ");
INSERT INTO aoi_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Akena aburraja narri-lyangkilyuwakajuwama wurruwurrakidirrbura aringka aburra-langwa wurrakina-da. Ni-yama neningadinuba-wiya nenungkwarba enuwa-wa, “Kinu-makina nungkwa-langwa nubungkawa ena ayakwa nganyangwa. Ngayuwe-ka ningena ningu-beyindanguma angalya kajungwa ki-lungkuwabijini-yada amarda eninganinga nganyangwa. Akwa ningi-ngayindenama ki-likajama ngayuwa enena-wiya ki-rringkinama akina. Nara kembirra a-likama ngayuwa aduwaba-da,” ni-yama nakina. ");
INSERT INTO aoi_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Eneja ni-likena ngarningka arakba nenikuminuwar•duwar•da ningku-wa nenungkwarba. “Awalyuwa arakba aninga, umba kwa!” ni-yama. Eneja ni-yama enuwa-wa, “Kinu-makina nubungkawa nungkwa-langwa ena ayakwa nganyangwa. Ngayuwe-ka ningena ningu-beyindanguma ememberrkwa bulukwa kakuminu-war•deni-yada warka nganyangwa. Kemba ningi-ngayindenama ki-likajama ngayuwa enena-wiya ki-rringkinama amurndakakina bulukwa nganyangwa eningaba-murrikba akina. Nara kemba a-likama ngayuwa nungkwa-langwu-wa nubungkawa aduwaba,” ni-yama nakina. ");
INSERT INTO aoi_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Eneja ni-likena ngarningka nenikuminuwar•duwar•da ningku-wa nenungkwarba. “Awalyuwa arakba aninga, umba kwa!” ni-yama nakina. Eneja ni-yama enuwa-wa, “Adinube-ka ningena yirringi-yakajuma dadingiyarrka. Kembirra aminakina-langwa nara a-likama ngayuwa nungkwa-langwu-wa nubungkawa aduwaba-da,” ni-yama nakina. Eneja ni-yaminjamama ngawa nenumurndaki-yendabenuma nakina nenikuminuwar•duwar•da wurrababurnu-wa warnumamalya warniki-liki-yada wurrakina ena-langwu-wa nubungkawa aningi-yada. Akena aburraja nawurraki-waranguma nara ka-likena wurrakina. ");
INSERT INTO aoi_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Eneja kembirra ni-lawurradina arakba angalyu-wa akwa nenu-maka amurndakibina ayakwa ena-langwa-manja nubungkawa. Eneja kembirra n-awinyambade-ka nakina nubungkawa arakba amurndakibina-langwa ayakwa. Biya ni-yama nibinu-wa nenikuminuwar•duwar•da, “Jeyi! Likaja errekbu-wa mamurukwu-wa,” ni-yama. “Nara ambudiduma umba warenja likaja wurrukwalu-wa warnumamalya nuw-ambilya-murruwa enena-manja angalya. Ki-likaja maruma-langwiya mamurukwa akwa ngawa miyukwayuwa-langwiya mamurukwa. Biya k-aburangkina ningkakina warningerribirra warnumamalya, wurribina warningalyingmalyingma akwa ngawa wurrirrengmurrengmurnirna akwa ngawa wurribina wurrimimbimimba warnumamalya. Kembirra ka-wilyakina wurramukwiyadakina warnumamalya yangkwurrangwa nganyangwu-wa angalya kajungwa kuw-alyubarini-yada enena aninga,” ni-yama nakina nubungkawa nenu-makama ena-langwa-manja nenikuminuwar•duwar•da-da. ");
INSERT INTO aoi_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Eneja ni-likena arakba-da. Biya wurramukwiyadakina warnumamalya n-aburangkama nakina. Biya wurrukwala nen-akburrangarnuma nakina akwa nenu-wilyakama arakba ena-langwu-wa nubungkawa-da. Biya ni-yama ena-langwu-wa nubungkawa, “Ningarra-wilyakama wurrumurndakenena warnumamalya yangkwurrangwa akena aruma ngawa enena angalya-da,” ni-yama nakina. ");
INSERT INTO aoi_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Eneja kembirra nubungkawa ni-yama enuwa-wa, “Jeyi! Likaja mamurndakangaba-wa mamurukwa nara-murruwa alikira,” ni-yama. “K-aburangkina ningkakina yakwujina warningerribirra warnumamalya. Biya k-akburrangina-manja wurrakina ka-wilyakina yangkwurrangwa, kajungwa ena alikira nganyangwa ka-lyangburrukwuni-yada warnumamalya. Ka-warena-manja wurrakina, kembirra ki-yamina nungkuwa aburruwa-wa, ‘Yiki-likajama enena-wiya,’ ki-yamina, ‘mena nubungkawa nganyangwa nginu-maka-mubaba nakina ngayuwa-manja yiki-likaji-yada karningerribirra karnumamalya aningi-yada,’ ki-yamina nungkuwa aburruwa-wa. ");
INSERT INTO aoi_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","“Amandangwa ningi-yaminama, wurrumurndakibina warnumamalya ka-likeni-yada warningadinuba-wiya nganyangwu-wa angalya nara arakba wurrakina alyubaruma ena aninga nganyangwa,” ni-yama nakina nubungkawa ena-langwu-wa nenikuminuwar•duwar•da-da. Ena-bu ngawa-da. Enena alawudawarra nenu-makama Jesus nibinu-wa nenumamalya-da. ");
INSERT INTO aoi_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Bi...ya narruma-yuwarnuma ngawa mibina mamurukwa numu-dirrirnduma makina Jirujalemu-wa nakina Jesus akwa wurribina ena-langwa warnikabuburrakiyuwa. Aburraja wurrilyimberrkwulyumide-ka warnumamalya namurndaki-likenuma makina-manja ngawa mamurukwa aburrajukwaba wurrakina. Kembirra na-likenu-manja wurrakina lukwakwa nakine-ka Jesus nu-ngwanja akwa ni-nyakuwarrukwajungwa akwa ni-yengbina amurndakenena ayakwa wurrumurndakakinu-wa wurruwurrakwulyumida warnumamalya. ");
INSERT INTO aoi_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","Ni-yama nakina, “Kirruwilyaba karnumamalya yiki-likaja-manja ngayuwa-wa akwa yiki-lyelyingmina-manja angwurra nungwenungwa iya dirndenungwa iya dadingiyenungwa iya wurriyukwayuwa nungkwurra-langwa, akwa ngawa narrkuwena-murriya iya darrkuwena-murriya umba yiku-warrngkilyelyingmina-manja ngayuwa, nara kembirra aburrakiyuwama ngayuwa-manja kirrakina. Yiki-lyelyingminama angwurra ngayuwa-manja umba yiku-warrngkilyelyingmajungwunama kirrakina-da. ");
INSERT INTO aoi_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Akwa ki-lyelyingmajungwuna-manja ningkakina akwa ku-warena-manja ningkeniki-jungwa ngayuwa-langwa, nara kembirra aburrakiyuwama ngayuwa-manja ningkakina-da,” ni-yama Jesus nenu-makama wurrumurndakibinu-wa warnumamalya-da. ");
INSERT INTO aoi_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Biya ngarningka ni-yama nakina aburruwa-wa, “Yiki-ngayindena-manja kirrakina karniki-yuwi-yada ngayuwa-manja, kembirra yikuma-war•dikinama ambaka-langwa mangma nungkwurra-langwa,” ni-yama Jesus. “W-engkirrikiya-langwa. Ka-makinama ngayuwa ambilyuma eyukwujiya-kiya alawudawarra, awilyaba alikira-langwa umba awilyaba awinyamba-langwa,” ni-yama Jesus. Nuwilyaba nenungkwarba kini-ngayindena-manja kini-likirakina-manja nakina alikira alingajirrirra, kembirra adinuba-wiya nara-wiya aburradaduma nakina warka kinuma-war•dikinama ambaka-langwa mangma ena-langwa. Kinu-murnduwarnama angwarnda ena-langwa, aruma-murrikba akina, kajungwa arngkawura-murri-yada ngawa kini-ngekburakini-yada akina alikira. ");
INSERT INTO aoi_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Nara-manja a-murnduwama nakina angwarnda ena-langwa adinuba-wiya, kinum-akumurnama jimenda yimbukwa dukwa-da umba nara akwala-da. Kemba nara a-likirakuma akina alikira ambaka nakina-da. Kembirra aburraja wurrukwala warnumamalya keni-rinjarrkinama enuwa-wa. ");
INSERT INTO aoi_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","“Wayi!” ke-yaminama wurrakina. “Naka nenungkwarba n-aburradadanguma warka ena-langwa, akena nara nakina kini-jerrukwa-na! Ekuwarra yimbukwa wulkwa ni-likirakama, akena nara ambaka kini-jerrukwa akina-da,” ke-yaminama wurrakina-da. Ena ngawa. ");
INSERT INTO aoi_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Umba nuwilyaba eneja nubungkawa keni-ngayindena-manja nakina neniku-wardi-yada ningku-wa nubungkawa, enejukwaba kinuma-war•dikinama ambaka-langwa mangma ena-langwa. Akwa kenu-murnduwarnama nakina ena-langwa wurrawinyamba warnungkwarba nara-wiya a-likama awinyambu-wa. Dukwa wurrilyimberrkwulyumide-ka 10,000 warnungkwarba wurrawinyamba ena-langwa, umba eneja nuwilyaba-langwa nubungkawa wurrilyimberrkwulyumide-ka angwurra dukwa nakina wurrawinyamba 20,000 warnungkwarba-da. ");
INSERT INTO aoi_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Kembirra nara eneja nakina ambudiduma umba keni-larrkajama warenja-bawiya wurrukwala warnungkwarba ningku-wa nubungkawa kin-ambilya-murruwa awilyikerra nakina ambaka. Aburraja ka-likajama akwa ke-yaminama, “Amiyambena ningki-ngayindenama nungkuwa?” ke-yaminama enuwa-wa. “Umba yirraja yiki-yamarrkinama yirruwa yarnumamalya nari-yada awinyamba?” ke-yaminama wurrakina kenuminu-wilyakinama ayakwa aburra-langwa-langwa nubungkawa ningku-wa nubungkawa wurrakina-da. Ena ngawa-da. ");
INSERT INTO aoi_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Biya kembirra nenu-makama Jesus wurrumurndakibina-manja warnumamalya, “Kembirra wunalakina-kiya wuburra wunenungkwarba-kiya yiki-yaminama kirrakina nungkwurrajukwaba. Ningkakina ningkuwilyaba yiki-ngayindena-manja ningkeniki-yuwi-yada ngayuwa-manja, kembirra nara ningkakina a-waruma ningkeniki-lalika-langwa eningerribirra amurndakijika nungkwa-langwa umba kuma-war•dikinama mangma nungkwa-langwa,” ni-yama Jesus nakina-da. ");
INSERT INTO aoi_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Biya kembirra ni-yama ngarningka Jesus aburruwa-wa, “Karningme-ka karna dilingena. Dadingabe-ka dakina. Akena kingu-milyingkambumadina-manja dakina dilingena, aki-yamarrkinama ngarna kembirra kajungwa aking-eningabakini-yada dakina? Nare-ka-da. Nara ngarna eningabakama dakina dilingena dadingungwurrkwarda-ma-baba dakina, ");
INSERT INTO aoi_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","umba akinga-wurrenama dakina ngarna-da. Nara ngarna akumama dakina ajiringka-manja, mena nara-baba eningabakama dakina akina ajiringka. Akwa nara ngarningka a-ngwunyirrkwajuma bulukwa-langwa-manja yimi, mena nara-baba eningabakama dakina dilingena amarda-murriya. Nare-ka-da, duwurrariya-baba ngawa dakina dilingena-da. “Kembirra w-engkirraja angwurra amurndakakinu-wa ayakwa ngarra-maka-murruwa. Yik-awiyebajina-manja akina nungkwurra-langwu-wa mada, nara kembirra a-jadijuma mungarrkuwarru-wa mada akwa a-lyikbijuma akina ayakwa, umba yiki-yakuwerribikaja ngawa ambaka-langwa amurndakakinu-wa,” ni-yama Jesus wurrumurndakibinu-wa warnumamalya wurrilyimberrkwulyumida-da. ");
INSERT INTO aoi_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Bi...ya aburraja wurrababurne-ka warnumamalya narrumurndaki-ngayindanguma warnik-engkirriki-yada ayakwa wurrakina Jesus-langwa. Umba wurrilyimberrkuwarra warnumamalya narraminu-war•danguma warka WarningiRawuma-langwa wurrububungkawa wurrumurndakakina. Akwa narraminu-manguma angwarnda wurrukwala-langwa WarningiJudiya warnumamalya kajungwa warniku-kwi-yada akina aburra-langwu-wa wurrububungkawa. Biya nuw-akwudangwukajungwunuma Jesus-uwa wurrakina aburruwa wurrukwala ngarningka warnumamalya wurruwurrariya aburrajukwaba. ");
INSERT INTO aoi_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Akena aburraja WurruBarija warnumamalya akwa wurribina warnikakakirumaka Mawijija-langwa ayakwa eningarumuruma na-ngwurrkiyengbeyinuma wurrakina. Biya ne-yama, “Jesus-eka nakina nara a-larrkama wurruwurrariya warnumamalya engku-wa, umba nen-ardijinama wurrakina enuwa-wa akwa n-alyubarinama aninga aburruwa-manja-da,” ne-yama wurrakina. ");
INSERT INTO aoi_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Kembirra aminakina-langwa eneja Jesus nenu-makama abiyakarbiya alawudawarra wurrumurndakakina-manja warnumamalya. ");
INSERT INTO aoi_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","Nuwilyaba nenungkwarba n-akwurrajuwama nakina ababurna jiba arngkumemberrkwa-ma arngkumemberrkwa ena-langwa. Umba awilyaba na-lyumaduma akina. Kembirra kini-yamarrkinama nakina? Ngayuwe-ka kembirra arakba ngarra-makinama nungkwurruwa-wa. Kini-lalikinama amurndakibina akwala jiba ena-langwa amarda-manja umba kini-likajama nakina kin-aburangkinama ebinu-wa awilyaba jiba na-lyumadu-murruwa ena-langwa-da. Nakina ngawu...wa kin-aburangkinamu...wa, yanda-langwa kin-akburrangina-manja ebina na-lyumadu-murrada. ");
INSERT INTO aoi_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Biya kin-akburranga-manja akina, kinu-menama akwa kin-akumurnama ena-langwa-manja amurn•da. Niyekirrerre-ka arakba kembirra kinu-werrikilyelyingmajungwunama-da. ");
INSERT INTO aoi_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Kembirra kini-lawurradinama nakina angalyu-wa kini-ngabukwunama akina ena-langwa-manja amurn•da-da. Biya kenu-murndukwajinama warnumamalya ena-langwa akwa kini-yaminama aburruwa-wa, “Kwa, ngarri-yekirrerrikajungwuna-langwa arakba ngakwurruwa, mena ning-akburranga-mubaba arakba nganyangwa ebina na-lyumadu-murrada jiba,” kini-yaminama nakina-da, kenu-makinama ena-langwa-manja warnumamalya-da. Ena ngawa. ");
INSERT INTO aoi_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Biya kembirra ni-yengbina ngarningka akwala ayakwa nakina Jesus. Ni-yama, “Neningikarrawara-langwa warnikumamurikaja ke-yekirrerridinama wurrakina ena-langwa-manja angalya abalkaya, kinu-wurrena-mulangwa nuwilyaba nenumamalya awurruwurrariya amurndakibina n-arriyakajungwunu-mulangwa nakina. Umba kwuja! Neningikarrawara-langwa warnikumamurikaja ke-yekirrerridinama wurrakina wurrumurndakibina-langwa 99 warnumamalya ke-yamina-mulangwa eninginingaba wurrakina. Umba ke-yekirrerridinama angwurra wurrakina wurruwilyaba-langwa warnumamalya karru-wurrena-mulangwa awurruwurrariya amurndakibina nuw-arriyakajungwunu-mulangwa umba kenumini-yarrkuwarakina-mulangwa ayakwa Neningikarrawara-langwa wurrakina-da,” ni-yama Jesus nakina-da. ");
INSERT INTO aoi_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Biya kembirra ni-yama nakina Jesus, “W-engkirraja enenu-wa ngarningka alawudawarra,” ni-yama. Duwilyaba dakina didarringka ying-akwurrajuwama ememberrkwa angwarnda eningilyamarmba ngala-langwa. Umba nuw-embirrkilyumaduma awilyaba akina. Kingi-yamarrkinama kembirra dakina didarringka? King-aburangkinama dakina angwurra ebina ngala-langwu-wa eyukwujiya angwarnda nuw-embirrkilyumadu-murruwa. Akwa king-abarrakajinama bajananga akwa kingi-yangbarrkinama ngala-langwa-manja alikira ambaka-langwa. King-abuburangkinama ngawu...wa, yanda-langwa king-embirrkakburrangina-manja ebina nuw-embirrkilyumadu-murrada. ");
INSERT INTO aoi_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Kembirra king-akburranga-manja akina karringawurra-murndukwajinama dakina ngala-langwa warnumamalya. Kingi-yaminama aburruwa-wa, “Kwa, ngarri-yekirrerrikajungwuna-langwa aduwaba,” kingi-yaminama, “mena ngayuwa ning-akburranga-mubaba ebina angwarnda nganyangwa nuw-embirrkilyumadu-murrada,” kingi-yaminama dakina didarringka, karringa-makinama ngala-langwu-wa warnumamalya-da. Ena ngawa. ");
INSERT INTO aoi_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Biya kembirra ni-yengbina ngarningka akwala ayakwa nakina Jesus. Ni-yama, “Wuburra laka dibina didarringka kingi-yekirrerridinama, kembirra aburrajukwaba Neningikarrawara-langwa warnikumamurikaja ke-yekirrerridinama wurrakina-da. Ke-yekirrerridinama wurrakina wurruwilyaba-langwa warnumamalya karru-wurrena-mulangwa awurruwurrariya amurndakibina nuw-arriyakajungwunu-mulangwa wurrakina akwa kenumini-yarrkuwarakina-mulangwa ayakwa Neningikarrawara-langwa wurrakina-da,” ni-yama nakina Jesus. ");
INSERT INTO aoi_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Biya enena ngarningka alawudawarra nenu-makama Jesus aburruwa-wa. Nuwilyaba nakina nenungkwarba akwa wunambilyuma warnikuwabulena-kiya nabuk-ambilyuma yakwujina awilyaba-manja angalya wurrubukalakina. ");
INSERT INTO aoi_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Biya neningarija-langwa-dangwa nenikuwenikba ni-yama nungwenikba-wa, “Ngangwa,” ni-yama, “wu-murnduwarna arakba akwa wi-yebijebakina amurndakijika iya ajiringka nungkwa-langwa aduwaba kajungwa ku-meni-yada ekuwarra ngaya nganyangwa,” ni-yama. Eneja kembirra nungwenikba nu-murnduwarna nakina amurndakibina amurndakijika iya ajiringka. Nenuminilirrak-eyebijebakama arakba wunalakina-langwa wunenungkwarba-kiya, ekuwarra nawenikba-langwa umba ekuwarra nenikumarnjenikba-langwa. ");
INSERT INTO aoi_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Eneja kembirra arngkidarrba-langwiya nakina nijira-dangwa nenu-kwa ebina ajiringka ena-langwa wurrukwalu-wa warnumamalya umba nu-manga angwarnda aburruwa-langwa akina-murrada. Akwa kembirra ni-likena eminingku-wa angalya nakina-da. Biya ni-likena arakba, nu-wilyakama ena-langwa amurndakijika iya angwarnda-da. Juju...j engku-we-ka ni-likenuma nakina. N-alilikenu...wa, yanda-langwa ni-yar•da eminingka-manja angalya arakba aminababurna-manja alikira iya warnumamalya. Yakwujina n-ambilyuma nakina akena nara amurndamurndirra ambaka kinu-wilyaka ebina angwarnda, nara kin-engkirrikena nakina ambaka-murri-yada umba nu-wurrawaja ngawa warenja-bawiya akina-da. Ni-jerrukwama angkwulyumida-langwa ngawa nakina-da. ");
INSERT INTO aoi_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Nara ebina ajijira-mulangwa kinu-wilyaka ena-langwa-manja ayarrka, nu-mangbijerriduma nakina ngawa arakba-da. N-eningalyingmalyingmadume-ka nakina-da. Umba akina-manja ngawa angalya na-warrngkijerridinuma ngalaja aninga akina. Kembirra nakine-ka nenungkwarba nu-mureyanguma akwa ni-ngayindanguma kin-alyubarinuma aninga. ");
INSERT INTO aoi_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Biya arakba ni-likena nakina nuwilyaba-langwu-wa nenungkwarba angalya, neni-yendabenuma warki-yada, akwa kembirra arakba nenuminu-war•danga nakina warka. Eneja nakina neni-larrka ena-langwu-wa bikibiki nenik-akwurraji-yada amurndakakina. ");
INSERT INTO aoi_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Umba ni-ngayindanguma nenik-alyubari-yada aninga bikibiki-langwa kajungwa neniki-ladikajungwi-yada nakina nenungkwarba, mena nara kenu-kwa warnumamalya aninga. Akine-ka bikibiki-langwa aninga na-jijanguma narru-wurrangu-mulangwa ebina amakwulya narr-alkuwayijuwa-mulangwa warnumamalya amamuwa-langwa aninga warnik-alyubara-langwa. ");
INSERT INTO aoi_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Biya kembirra arakba ni-yakuwerribika nakina akwa ni-lyangkiyama, “Wurrumurndakibina warnungkwarba nenuminu-war•duwar•denama warka nungwarrka-langwa, nuw-alyubarinama arume-ka aninga aburra,” ni-yama. “Umba nganja ningena yelakwa murumureya ning-ambilyama. ");
INSERT INTO aoi_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","19","Ngi-likajama arakba ngi-lawurradina nungwarrku-wa. Ki-yaminama ngayuwa enuwa-wa, ‘Ngangwa, ningene-ka ning-arriyakajungwuma. Nara kembirra arakba wurrukwala e-yengbijuma ningena nungkwa-langwa ningenikuwena, mena nara k-engkirrikena ngayuwa ayakwa Neningikarrawaru-wa akwa nungkuwa-wa. Umba yirra-ngayindenama ningkakina ki-yaminama ngayuwa-manja wuburra laka wurrukwala-manja ningki-yaminama aduwaba warnumamalya buminu-war•duwar•dena-murrumanja nungkwa-langwa warka. Nganjukwaba ku-war•denama wuburra wurrumurndakenena warnikuminuwar•duwar•da buminu-war•denama, akena nara arakba ningenikuwena e-yamama ningena,’ ki-yaminame-ka ningena nungwarrku-wa-da,” ni-lyangkiyama nakina ni-lyangkumakajungwunuma nenungkwarba. ");
INSERT INTO aoi_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Biya kembirra nu-mirajanga nakina akwa ni-likena arakba ni-lawurradina nungwenikba-langwu-wa angalya-da. N-alilikenu...wa. Akena awilyikerra-langwiya ngawa ni-likenu-wiya nakina ambaka nenungkwarba, eneja nungwenikba neni-rringka nubukwaya ni-lawurradinuma. Neni-rringka-manja nakina ni-lawurradinu-manja nenikuwenikba, n-errukwule-ka. Biya n-angkarra nakina nenu-kwurukwa, akwa nen-engkarrnga akwa neni-lawurangka nenikuwenikba-manja-da. ");
INSERT INTO aoi_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Kembirra ni-yama eneja nenikuwenikba nungwenikba-wa, “Ngangwa, ningene-ka ning-arriyakajungwuma. Nara k-engkirrikena Neningikarrawaru-wa akwa nungkuwa-wa. Nara kembirra arakba nungkwa-langwa ningenikuwena ningena mena ninguwurrariya-baba,” ni-yama. ");
INSERT INTO aoi_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Akena eneja nungwenikba nen-ardijuwa wurrumurndakibina warnumamalya nenuminu-war•duwar•danguma, biya ni-yama aburruwa-wa, “Kwa warenja, wurringa-lyilyiya dumbala dadingaba-langwa aken-awiyebaji-yada naka,” ni-yama. “Akwa wun-awiyebajiya eyukwujiya errumungkwa amamamuwa ena-langwa-manja amamamuwa ayarrka akwa wun-awiyebajina ngarningka ebina eningalika ena-langwa-manja alika. ");
INSERT INTO aoi_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Akwa yiki-likaja yiku-mena ebina eyukwujiya bulukwa engmurra. Yiku-wardena akwa yik-aburdena akina. Kembirra ak-alyubarinama ababurna amadangkwa iya aninga ngakwurruwa aki-yekirrerrikajungwunama, ");
INSERT INTO aoi_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","mena naka nenikuwarrka nganyangwa ni-jungwu-murrada, akena aduwaba n-enibuduma arakba naka-da. Ningen-akburrangama arakba nibina ni-lyumadu-murrada-da,” ni-yama neniyuwangkwa nakina. Biya nuw-alyubarina arakba aninga wurrakina-da. ");
INSERT INTO aoi_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Akini-yada ngawa eneja nuwilyaba nenikuwenikba naruma-dangwa nu-war•danguma warka errekba-manja. Biya ni-lawurradinu-manja nakina angalyu-wa akwa n-akwudangwukajungwunu-manja alikira-wa, n-engkirrika nakina arakba akumalyumalyangka eningalukwanja na-malyangkeyinuma. ");
INSERT INTO aoi_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Biya kembirra nen-ardija nuwilyaba nenikuminuwar•duwar•da nungwenikba-langwa akwa ni-yama, “Ne-yamarrkinama wurrakina?” ni-yama nakina. ");
INSERT INTO aoi_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Eneja nibina nenikuminuwar•duwar•da ni-yama enuwa-wa, “Nungkwa-langwa nenikumarnjena ni-yar•duma naka. Kembirra eneja nungwena yirrenu-makama yarniku-warda ebina eyukwujiya bulukwa engmurra, mena ni-lawurradinu-mubaba karninikuwena ngawa neningaba nakina-da,” ni-yama. ");
INSERT INTO aoi_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Eneja kembirra naruma-dangwa nenikuwenikba nenak-ar•darra awinyamba. Nara kini-ngayindanga kin-awiyebena alikira-wa. Kembirra eneja nungwenikba ni-jadinga nakina alikira-langwa akwa ni-yama, “Nara errekba-manja ambilyuma umba kwa, awiyeba-langwa marrakba arrawu-wa,” ni-yama. ");
INSERT INTO aoi_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Akena eneja ni-yama nungwenikba-wa, “Kwuja, ngayuwa yirraminu-war•danguma warka nungkwa-langwa,” ni-yama. “Mababurne-ka mamarika iya yinungkwura ningu-war•danguma, ningu-war•duwar•denama aduwaba ngawa ningena-da, wurrumurndakenena wuburra warnumamalya buminu-war•denama aburrajukwaba nungkwa-langwa. Nara yibamini-yarrkuwurranga ebina yi-maka-mulangwa ayakwa nungkuwa, akena nara kembirra yiku-kwa awilyuwilyaba nenukwuda ngayuwa-wa-da kajungwa yarnik-alyubari-yada nganyangwa warnumamalya-da. ");
INSERT INTO aoi_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Akena naka eneja nenikuwena nungkwa-langwa ni-jerrukwama ebina angwarnda nungkwa-langwa wurruwurrariya-manja wurridarringka. Umba ni-lawurradinu-manja naka nungkwa-langwa nenikuwena angalyu-wa, kembirra nungkwaja ningkarra-makama ningkakina nungkwa-langwa-manja warnikuminuwar•duwar•da, kembirra narru-wardanguma engmurra eyukwujiya bulukwa ena-langwi-yada wurrakina-da,” ni-yama nakina nenikuwenikba nungwenikba-wa. ");
INSERT INTO aoi_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Eneja kembirra nungwenikba ni-yama enuwa-wa, “Nenukwa, ngeniyerriya,” ni-yama, “ningkene-ka ningk-ambambilyuma yelakwa ngayuwa-manja, akwa amurndakenena amurndakijika-murriya nganyangwa nungkwa-langwe-ka ababurna-langwa ena. ");
INSERT INTO aoi_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Umba ena yirr-alyubarinama yarna aninga yirri-yekirrerrikajungwunama yarna. Eningabe-ka ena mena naka nenikuwarrka nganyangwa ni-jungwu-murrada, akena aduwaba n-enibuduma arakba naka-da. Ni-lyumadu-murrada, akena ningen-akburrangama ngayuwa,” ni-yama neniyuwangkwa, nenu-makama nenikuwenikba-wa-da. Akwa ena ngawa-da. Enena abiyakarbiya alawudawarra nenu-makama Jesus wurrumurndakibinu-wa warnumamalya. ");
INSERT INTO aoi_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Biya kembirra nenu-makama Jesus ena-langwa-manja warnikabuburrakiyuwa enena alawudawarra nuwilyaba-langwa nenikuminuwar•duwar•da. Nuwilyaba n-ambilyumurra nenikuminuwar•duwar•da nakina. Umba eneja ena-langwa nubungkawa numinababurne-ka alikira iya amurndakijika akwa angwarnda nakina. Nakine-ka kembirra nenikuminuwar•duwar•da ena-langwa numurndak-akukwurrajuwama ababurna-langwa eningerribirra ena-langwa-langwa nubungkawa. Bi...ya aburraja wurrukwala warnumamalya na-likenuma nakinu-wa nubungkawa akwa ne-yamama, “Nakine-ka nenikuminuwar•duwar•da nungkwa-langwa nibina n-akwurrajinama ababurna-langwa amurndakijika nungkwa-langwa nuwurrariye-ka nenumamalya nakina,” ne-yama. “Ni-jerrukwuname-ka eningerribirra nungkwa-langwa nakina. Ku-mangbijerridinama kembirra adinuba ningkakina,” ne-yama wurrakina nenu-maka nakina-manja nubungkawa-da. ");
INSERT INTO aoi_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Eneja kembirra nubungkawa nen-ardijuwa nibinu-wa arakba nenikuminuwar•duwar•da. Nakine-ka ni-likena kembirra enuwa-wa. Umba ni-yama nakina nubungkawa ena-langwu-wa nenikuminuwar•duwar•da, “Amiyambena ena ayakwa bu-makama warnumamalya nungkuwa-langwa?” ni-yama. “Yirra-ngayindenama nungkuwa ku-murnduwarnama aduwaba ababurna-langwa angwarnda nganyangwa. Akwa yikumin-arrikarrenama jurra-manja akina ababurna-langwa akwa yiku-kwunama akina jurra ngayuwa-wa, mena nara-baba arakba aminu-war•duma ningkena warka nganyangwa yelakwa,” ni-yama nakina nubungkawa enuwa-wa. ");
INSERT INTO aoi_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Umba eneja nakina nenikuminuwar•duwar•da ni-lyangkumakajungwunuma arakba. “Karukwa!” ni-yama. “Ki-yamarrkiname-ka ningena aduwaba? Nubungkawa nganyangwa nu-warenama ngayuwa. Nara kembirra arakba aminu-war•duma ningena warka ena-langwa-da. Ningeningarrubuda-me-ka ningena ningeniku-mungkada-langwa edirra-da. Akwa nara e-yukwamajuma erribirra angwarnda iya aninga warningerribirru-wa warnumamalya, ki-yeliyena-mubaba kembirra ningena ngayuwa akina-langwa-da. ");
INSERT INTO aoi_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Wa! Ningeningma kembirra arakba ningeniki-yama-langwa ngayuwa kajungwa nari-yada a-waruma wurrukwala warnumamalya ngayuwa-da. Kembirra ki-jadena-manja ngayuwa nubungkawa-langwa-langwa alikira, aburraja kab-awiyebajinama ambaka-murra ngayuwa wurrakina warnumamalya aburra-langwu-wa alikira-da,” ni-yama ni-lyangkumakajungwunuma nakina nenikuminuwar•duwar•da-da. ");
INSERT INTO aoi_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Biya nen-ardijuwama nakina kembirra wurrumurndakibina warnumamalya warniku-kwi-yada angwarnda iya aninga ena-langwu-wa nubungkawa. Wurruwilyuwilyaba-wiya nen-ardijuwama nakina enuwa-wa wurrumurndakakina warnumamalya wurrababurna-langwa. Biya ni-yama nakina nuwilyabu-wa, “Ambarrngarna aninga ningkeniku-kwi-yada ningkena nubungkawa nganyangwa?” ni-yama. ");
INSERT INTO aoi_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Eneja ni-yama, “Kinu-kwuname-ka ningena arngkumemberrkwa-ma arngkumemberrkwa budila enuwa-wa aliba-langwa amalyirra,” ni-yama. Kembirra eneja ni-yama nakina nenikuminuwar•duwar•da enuwa-wa, “A•a! Wu-miya ena jurra nungkwa-langwa. Ambarriya akwa wu-warrukwajiya ena ekirra. Nara arngkumemberrkwa-ma arngkumemberrkwa umba arngkumangbala-ma arngkumemberrkwa k-arrikarrenama ningkakina yelakwa-da. Biya arngkumangbala-ma arngkumemberrkwa kinu-kwunama budila enuwa-wa kembirra-da,” ni-yama nakina. ");
INSERT INTO aoi_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Umba ningka-langwa nenungkwarba ni-likenuma enamba-langwa enuwa-wa. Kembirra ni-yama eneja nakina nenikuminuwar•duwar•da, “Umba nungkwaja, ambarrngarna ningkena aninga ningkeniku-kwi-yada nubungkawa nganyangwa?” ni-yama. Eneja ni-yama, “Kinu-kwuname-ka ningena 1,000 beka amadidira-murra amaninga nungkwa-langwu-wa nubungkawa,” ni-yama. Kembirra eneja nakina nenikuminuwar•duwar•da ni-yama, “A•a! Wu-miya ena jurra nungkwa-langwa. Nara 1,000 umba 800 k-arrikarrenama ningkakina,” ni-yama nakina-da. ");
INSERT INTO aoi_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Bi...ya n-engkirrika arakba eneja nubungkawa ayakwa nakina-langwa nikalya nenikuminuwar•duwar•da ni-yama-mulangwa nakina. Biya ni-yama, “Nakakirume-ka nakina nenikuminuwar•duwar•da nganyangwa. Milyenjirre-ka mangma ena-langwa,” ni-yama nakina nubungkawa. Ena-bu ngawa-da. Biya kembirra Jesus nenu-makama ngarningka ayakwa ena-langwu-wa warnikabuburrakiyuwa akwa ni-yama nakina, “Akine-ka ni-yengbinuma nakina nubungkawa ayakwa, mena warnumamalya wurribina na-lyelyingmina-murrumurra wulkwa amurndakijika-murriya-manja na-likaja-mubaba milyenjirra-murra mangma wurrakina. Warningme-ka wurrakina *warniku-wulda-langwa *warniku-ngwur•da-langwa enena-manja angalya. Warningme-ka warniki-yama-langwa warnumamalya-manja wurribina na-lyangmurukweyina-murrumanja aburrajukwaba amurndakijika-manja umba nara akwala. Umba aburraja warnumamalya wurribina na-lyelyingmina-murrumurra Neningikarrawara-langwa-manja alarradada na-lyangmurukweyinama aburrajukwaba wurrakina enena-manja angalya akwa ngawa ngarningka amurndakibina-manja Neningikarrawara-langwa-manja ngalajukwaba-da. Kembirra enena-manja angalya narruma-wilyakinama wurrakina mangma meningilyenjirra-ma amurndakijika-langwa. Warningbala warniki-yama-langwa warnumamalya-manja wurribina na-lyangmurukweyina-murrumanja amurndakijika-murriya-manja wurrakina umba nara akwala-manja,” ni-yama Jesus ena-langwu-wa warnikabuburrakiyuwa. ");
INSERT INTO aoi_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Biya ni-yama ngarningka nakina Jesus aburruwa-wa, “Kembirra ngarra-makinama ena ayakwa nungkwurruwa-manja,” ni-yama. “Nungkwurraja yika-mamurikajinama kirrakina wurrukwala-manja warnumamalya. Yika-kwunama aninga iya amurndakijika akwa angwarnda. Ambaka-murra kembirra yiki-jungwuna-manja kirrakina, nara arakba a-ngayinduma amukwiyadakina kirrakina amurndakijika-murriya. Akini-yada ngawa eneja Neningikarrawara nakina yikenu-wilyakinama kirrakina ena-langwu-wa angalya abalkaya,” ni-yama nakina Jesus ena-langwu-wa warnikabuburrakiyuwa. ");
INSERT INTO aoi_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Biya ni-yama nakina Jesus ngarningka aburruwa-wa, “Kirruwilyaba karnumamalya yikinumin-akwurrajina-manja amurndamurndirra kirrakina eyukwujiya angwarnda ningka-langwa nenumamalya akena nara-manja amini-jerrukwama akina, kembirra ambaka-murra eneja yikenu-werrungwur•denama nungkwurruwa-manja akwa nungkwurraja yikinumin-akwurrajinama kirrakina ena-langwa adirrungwarna angwarnda-da. Akena kirrikalya-manja kirruwilyaba karnumamalya, nara-manja akwurrajuma eyukwujiya angwarnda ebina ambaka-langwa umba yikinumini-jerrukwuna-manja akina, kembirra nara nakina a-werrungwur•duma nungkwurruwa-manja akwa nara kirrakina amin-akwurrajuma aruma angwarnda ena-langwa-da. ");
INSERT INTO aoi_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Nara-manja nungkuwa akwurrajuma ningkakina angwarnda iya amurndakijika ningkumurndamurndirra enena-manja angalya, amiyambena kembirra Neningikarrawara-langwa kinumin-akwurrajinama ningkakina? Nara-da. Nare-ka a-kwama Neningikarrawara eningerribirra ena-langwa nungkuwa-manja ningkenik-akwurraji-yada ena-langwa akina-da. ");
INSERT INTO aoi_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Amurndakenene-ka amurndakijika iya angwarnda nara nungkwa-langwa akina. Umba eneja Neningikarrawara nginu-kwunama ena-langwa angwarnda iya amurndakijika-murriya eningaduwaya nungkuwa-manja. Kembirra nara-manja akwurrajuma ningkakina amurndakakina eningaduwaya enena-manja angalya, ki-yamarrkinama ningkakina ambaka-murra? Eneja kenu-kwunama ningkakina Neningikarrawara eningaba ebina ena-langwa eningangkawura ena-langwa-manja angalya abalkaya-na? Nare-ka nakina-da,” ni-yama Jesus ena-langwu-wa warnikabuburrakiyuwa-da. ");
INSERT INTO aoi_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Biya ni-yama ngarningka nakina aburruwa-wa, “Neningerribirra nenikuminuwar•duwar•da nare-ka nakina aminu-war•duma warka wunalekbina-kiya-langwa wunubungkawa-kiya-langwa wunambilyuma. Dukwa kini-lyelyingminama nuwilyaba-manja nubungkawa, kinu-werrikambilyama enuwa-manja, umba dukwa kenu-wirrikbinama nakina ningka-manja akwa nara kembirra akwurrajuma angwurra nakina-manja-da. Akine-ka ngarra-makama mena-baba ka-bungkawadina-manja akina angwarnda nungkwurruwa-manja, kembirra Neningikarrawara nara a-bungkawaduma nakina nungkwurruwa-manja-da,” ni-yama Jesus nenu-maka ena-langwa-manja warnikabuburrakiyuwa nakina-da. ");
INSERT INTO aoi_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Aburraja wurrukwala WurruBarija warnumamalya aburrajukwaba nuw-engkirrikenuma amurndakibina ayakwa Jesus-langwa. Kembirra nenu-marngkajuwama enuwa-wa mena na-lyelyingminu-mubaba angwurra angwarnda. ");
INSERT INTO aoi_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Eneja Jesus ni-yama aburruwa-wa, “Kirrakina-bina kirra-ngayindenama warnumamalya ke-yamina-mulangwa-da, ‘Karningabe-ka KirruBarija kirrakina karnumamalya, kirruwerrikidirrbure-ka kirrakina-da.’ Akina kirri-ngayindenama akena eneja Neningikarrawara neningma nakina mangma iya yukwudukwuda nungkwurra-langwa. Neningma angwurra nungkwurruwa-manja karnumamalya. Nara a-lyangkuwerribikajungwuma nakina wuburra kirrukwala karnumamalya kirri-lyangkuwerribikajungwunama kirrakina-da. Yiki-yamina-manja karnumamalya, ‘Eningaba akina,’ dukwa Neningikarrawara kini-yaminama arrkala, ‘Awurrariya akina,’ kini-yaminama dukwa nakina-da,” ni-yama Jesus nenu-maka WurruBarija-manja-da. ");
INSERT INTO aoi_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Biya ngarningka ni-yama kembirra Jesus aburruwa-wa, “Arakburakba-kiya-wiya wurribina warnikakakirumaka warnumamalya narr-akakirumakama Mawijija-langwa ayakwa eningarumuruma narra-makama wurrukwala-manja warnumamalya. Akwa narr-akakirumakama ngarningka Neningikarrawara-langwa-langwa ayakwa amurndakibina WurruBuburabuda narra-maka-mulangwa wurrakina ena-langwa-manja warnumamalya. Amurndakakina-langwiya-bina ayakwa narr-akakirumakama wurrakina warnikakakirumaka wurrukwala-manja warnumamalya wurriyirrbiyirrba ngawa-da. “Bi...ya aburraja warningaduwaba warnumamalya kembirra nuw-engkingkirrikenuma aburrajukwaba aduwaba amurndakakinu-wa-bina ngawa ayakwa wurrakina. Eneja kembirra Janjana Nenikumingekingambaja ni-yar•duma arakba enena-manja angalya. Kembirra ni-yar•dangu-mulangwa nakina Janjana, ngayamba-langwa ningarra-wilyakajuwama warnumamalya-manja eningaba ayakwa kinu-bungkawadina-mulangwa Neningikarrawara nakina. Kembirra aduwaba aburraja wurrababurna-langwe-ka warnumamalya neni-ngayindenama angwurra wurrakina kinu-bungkawadina-mulangwa Neningikarrawara nakina aburruwa-manja. ");
INSERT INTO aoi_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Nungkwurraja kirri-yaminama karna karnumamalya, ‘Nare-ka a-jerriduma amurndakakina angalya abalkaya akwa amurndakenena angalya arrawa ngalajukwaba,’ kirri-yaminama. Umba amurndakibina ayakwa eningarumuruma Mawijija-langwa ngalajukwaba nare-ka a-jerriduma akina. Akena ngarra-makinama nganja ngayuwa, amurndakibina angalya abalkaya iya amurndakenena angalya arrawa dukwa ka-jerridinama akina umba amurndakibina ayakwa eningarumuruma Mawijija-langwa nare-ka a-jerriduma akina. Nara ngawa awilyuwilyaba a-jerriduma akina-da. ");
INSERT INTO aoi_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Arakburakba-kiya-wiya nenu-kwa-manja eneja Neningikarrawara enena ena-langwa ayakwa eningarumuruma nakina-manja Mawijija, ni-yamama nakina Neningikarrawara, ‘Nuwilyaba nenungkwarba kininga-lalikina-manja dadingiyenikba ena-langwa, umba kininga-mena-manja dingka-manja didarringka, kembirra wunalakina-kiya ngawa keni-rndirndirrkeyinama arakba. Akwa ngarningka nuwilyaba nenungkwarba kininga-lalikina-manja dadingiyenikba ena-langwa, akwa kembirra eneja ningka-dangwa nenungkwarba kininga-mena-manja dakina, kembirra nakine-ka nenungkwarba akwa ngawa dakina didarringka aburnajukwaba keni-rndirndirrkeyinama arakba wunalakina-da,’ ni-yamama Neningikarrawara,” ni-yama Jesus wurrumurndakibina-manja WurruBarija warnungkwarba-da. ");
INSERT INTO aoi_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Biya kembirra arakba nenu-makama enena alawudawarra nakina Jesus wurrumurndakakina-manja WurruBarija warnumamalya. Nuwilyaba naruma nenumamalya n-ambilyuma nakina awilyaba-manja angalya. Numinababurne-ka nakina amurndakijika iya angwarnda akwa aninga-murriya. Akwa n-awiyuwiyebenuma dumbala dukukwulyubena dibina nu-beyindanguma duminaruma angwarnda. Akwa n-alyelyubarinuma aninga eninginingaba-wiya mababurna-langwa mamawura iya marringa nakina-da. ");
INSERT INTO aoi_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Eneja nuwilyaba nenungkwarba n-ambilyuma nakina yakwujina enejukwaba ebina-manja ngawa angalya. Nenimikirra nakina Lajirida. Nakine-ka nenungkwarba neningalyingmalyingme-ka. Awurrakwulyumide-ka amarmarra n-arrirreyinuma ena-langwa-manja nenumadangkwa. Aburraja wurrukwala warnumamalya ena-langwa neni-lyilyanguma nakina nibina-langwu-wa naruma nenumamalya alikira. Neni-lyilyanguma wurrakina akwa neni-lalikama nen-angmakwulalijuwama nakina akawiyuwiyeba-manja akwudangwa. ");
INSERT INTO aoi_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","N-alyubarinu-manja nibina naruma nenumamalya ebina aninga, kembirra ngalaja eyukwayuwa aninga n-alyubarinu-mulangwa nakina ne-ngkilarreyinuma akina ajiringka-wa. Eneja nakina Lajirida ni-ngayindanguma ebina aninga ne-ngkilarreyinu-mulangwa nenik-alyubari-yada akina. Aburraja wurruwarda na-likenuma enuwa-wa akwa narri-ngbijuwama amarmarra amurndakibina ena-langwa-da. ");
INSERT INTO aoi_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Bi...ya kembirra nakine-ka neningalyingmalyingma nenungkwarba ni-jungwa arakba. Umba aburraja Neningikarrawara-langwa warnikumamurikaja neni-ngkajika wurrakina nibina ni-jungwuma, akwa nenu-wilyakama karrawaru-wa Neningikarrawara-langwu-wa angalya n-ambilyu-murruwa Aburiyama, kajungwa kin-ambilyi-yada ngawa enuwa-manja yakwujina akwudangwa. Bi...ya kembirra eneja nibina nenumamalya numinababurna amurndakijika iya aninga ni-jungwa enejukwaba nakina. Aburraja neni-rungkwaba nenumadangkwa ajiringka-manja arakba-da. ");
INSERT INTO aoi_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Umba ni-likena arakba kembirra awurrariya-wa angalya warninikijungwa-langwu-wa nakina. Akena akina-manja ngawa angalya warninikijungwa-langwa-manja, n-arrkwujeyinuma nakina nenumamalya, ni-lyandinume-ka angwurra nakina-da. Biya nu-ngwundikadinga akwa nenilirraki-rringka wunalakina Aburiyama akwa Lajirida. Umba awilyikerra ngawa angalya aburnaja wunalakina nen-ambilyumurra-da. ");
INSERT INTO aoi_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Eneja kembirra n-ardanga nakina nenumamalya Aburiyamu-wa. “Namira...wu!” ni-yama. “Errukwuliya-langwa nganja akwa ni-larrkiya-langwa Lajirida ngayuwa-wa yangkwurrangwa, kajungwa kin-akumi-yada ayarrka amamuwa ena-langwa akungwa-manja akwa kinu-murndadiki-yada alyelyikba nganyangwa. Marrakba! Karukwa! Ningi-lyandiname-ka ningena enena-manja angalya angwura-wiya,” ni-yama nakina nenumamalya Aburiyamu-wa-da. ");
INSERT INTO aoi_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Akena eneja ni-yama Aburiyama, “Engkirrikiya, namira,” ni-yama. “Ningk-ambilyu-wiya ningkeniba nungkuwa ningkakina, ningku-wilyakama ababurna amurndakijika iya aninga. Eneja naka Lajirida nara ebina amurndakijika iya aninga kinu-wilyaka enuwa-manja, neningalyingmalyingma neningangkawura n-ambilyuma nakina. Umba aduwaba kembirra niyekirrerra arakba naka yelakwa, umba nungkwaja ningkakina yakwujina ningk-arrkwujeyinama ngawa, ningki-lyandinama ningkeningangkawura. ");
INSERT INTO aoi_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Umba ngarningka ngalaja akina laka edirra angwujirira angwurn•dikirra nuw-ambilyama wilyarra, kajungwa wurribina karri-ngayindena-manja warniki-lika-langwa yadada nungkuwa-wa nari-yada wurrakina a-likama-da. Akwa nara warningerribirra yadikina ningk-ambilya-mulangwa ningkakina a-kuwabijanguma yangkwurrangwa yirruwa-wa-da,” ni-yama Aburiyama enuwa-wa-da. ");
INSERT INTO aoi_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Eneja kembirra ni-yama nibina nenumamalya, “Aburiyama, marrakba, namira, ni-larrkiya-langwa kembirra Lajirida nungwarrka-langwu-wa angalya,” ni-yama. ");
INSERT INTO aoi_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","“Aburraja wurrakina yakwujina wurrumangbala nganyangwa narrkuwarrka-murriya nuw-ambilyama. Eni-likaja nakina abunu-makina abunu-madumurrukwuna, kajungwa nari-yada a-likama wurrakina enenu-wa awurrariya angalya akwulyandilyandu-wa, wuburra laka ngayuwa ningi-likenuma yangkwurrangwa enenu-wa angalya,” ni-yama nakina nenumamalya Aburiyamu-wa-da. ");
INSERT INTO aoi_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Eneja Aburiyama ni-yama enuwa-wa, “Nungkwa-langwa narrkuwena-murriya narru-wilyakinama wurrumurndakakina akina ayakwa Mawijija-langwa akwa ngawa WurruBuburabuda-langwa,” ni-yama. “Ab-engkirrikaja kembirra wurrakina amurndakakinu-wa ayakwa aburra-langwu-wa. Narra-madumurrukwa-mulangwa arakba, kembirra abarramin-engkirrikaja wurrakinu-wa akina ayakwa,” ni-yama Aburiyama enuwa-wa-da. ");
INSERT INTO aoi_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Eneja kembirra nenumamalya ni-yama, “Nare-ka, namira,” ni-yama nakina. “Ka-jungwuna-manja wurruwilyaba warnumamalya biya kembirra kuw-enibudina-manja wurrakina akwa ka-likaja-manja aburruwa-wa, kembirra kuw-engkirrikajame-ka amandangwa wurrakina akina ayakwa-da. Kembirra arakba wurrakina karru-wurrenama awurruwurrariya umba kuw-engkirrikajama arakba eninginingaba-wiya-da,” ni-yama nakina nenumamalya Aburiyamu-wa. ");
INSERT INTO aoi_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Eneja ni-yama Aburiyama, “Nara-manja wurrakina engkirrikuma Mawijija-langwu-wa ayakwa akwa WurruBuburabuda-langwu-wa, nara kembirra wurrakina engkirrikuma aduwaba wurrukwalu-wa warnumamalya. Kwuja! Kini-jungwuna-manja nuwilyaba nenumamalya biya kin-enibudina-manja nakina akwa kini-likaja-manja nakina yadada aburruwa-wa, kenu-madumurrukwuna-manja nakina wurrakina-manja, nare-ka wurrakina engkirrikuma ena-langwu-wa ayakwa,” ni-yama Aburiyama nibinu-wa nenumamalya-da. Ena ngawa-da. Enena alawudawarra nakina Jesus nenu-makama wurrumurndakibina-manja WurruBarija warnumamalya-da. ");
INSERT INTO aoi_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Biya kembirra Jesus ni-yengbinuma nakina ayakwa ena-langwu-wa warnikabuburrakiyuwa. “Wurrukwala warnumamalya yikabu-kwudirrkiname-ka amandangwa nungkwurruwa-manja awurrariya-wa wurrakina,” ni-yama Jesus aburruwa-wa. “Akena nara nungkwurraja karna a-ngwanjajuma wurrakina. Kembirra yiki-yamina-manja akina awurrariya, ka-ngekburakajungwunama ngalaja awurrariya nungkwurra-langwa ambaka-murra. ");
INSERT INTO aoi_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Umba yika-kwudirrkina-manja wurrukwala warnumamalya awurrariya-wa akwa ke-yamina-manja akina awurrariya, kembirra aminakina-langwa ka-ngekburakajungwunama awurrariya angwurra nungkwurra-langwa ambaka-murra. ");
INSERT INTO aoi_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Nungkwurraja kembirra yiki-rringkajungwunama angwurra kirrakina kajungwa nari-yada a-kwudirrkama wurrukwala warnumamalya awurrariya-wa,” ni-yama Jesus ena-langwu-wa warnikabuburrakiyuwa-da. Biya ni-yama ngarningka nakina Jesus aburruwa-wa, “Kini-yamina-manja nenikumarnjena awurrariya nungkuwa-manja, kembirra nungkwamba-langwa kinu-makinama enuwa-wa ebina-langwa awurrariya ni-yama-mulangwa nakina nungkuwa-manja. Umba kin-engkirrikaja-manja nakina nenikumarnjena ayakwa nungkwa-langwa akwa kinuma-warrukwajina-manja mangma ena-langwa, kembirra arrkala kinumini-yakuwabijinama ningkakina-da. ");
INSERT INTO aoi_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Umba kini-yamina-manja ngawa nakina, kini-ngekbungekburakina-manja nakina awurruwurrariya nungkuwa-manja neningangkawura, kembirra nungkwaja arrkala kinumini-yakuwabijinama ngawa ningkakina ningkeningangkawura-da. Dukwa arngkababurna kini-yaminjaminama nakina nungkuwa-wa, ‘Marrakba, yimini-yakuwabijiya-langwa nganja akina.’ Dukwa arngkumangbala arngkambilyuma kini-yaminama nakina akina ayakwa nungkuwa-wa muwilyaba-murra-manja ngawa mamawura. Kembirra nungkwamba-langwa kinumini-yakuwabijinama ningkakina amurndakibina ena-langwa awurruwurrariya, mama amangbala ambilyuma akina-da,” ni-yama Jesus ena-langwu-wa warnikabuburrakiyuwa-da. ");
INSERT INTO aoi_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Aburraja kembirra Jesus-langwa warnikilarrkilarrka warnungkwarba ne-yama wurrakina enuwa-wa, “Bungkawa, yirri-ngayindenama yarna yiku-werrikambilyama angwurra nungkuwa-manja,” ne-yama wurrakina. “Yirru-mamurikajina yirraja kajungwa nari-yada a-minikalyikama nungkuwa, umba yiku-werrikambilyi-yada ngawa nungkuwa-manja yarningangkawura,” ne-yama wurrakina. ");
INSERT INTO aoi_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Eneja ni-yama Nubungkawa Jesus aburruwa-wa, “Nara ambaka karna a-werrikambilyuma ngayuwa-manja-na!” ni-yama. “Ku-werrikambilya-manja ngawa ningkakina ngayuwa-manja, mame-ka ku-warrngkuwerrikambilya-manja ningkakina ngayuwa-manja, ki-yengbinamurra kembirra enena ayakwa ningkakina. Ki-yaminama enenu-wa eka, ‘Warumajungwa, umba jeyi, likaja angerriba makardu-wa. Biya kembirra yakwujina k-akumurna amukayerra nungkwa-langwa kuw-arjiyi-yada makarda-manja,’ ki-yamina ningkakina-da. Umba ngalaja enena eka kakumin-engkirrikajame-ka ayakwa nungkwa-langwa akina-da,” ni-yama Jesus ena-langwu-wa warnungkwarba warnikilarrkilarrka nakina-da. ");
INSERT INTO aoi_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Biya ni-yama ngarningka nakina Jesus aburruwa-wa, “Awurmurra kirruwilyaba karnumamalya yikini-larrkajama nungkwurra-langwa nenikuminuwar•duwar•da errekbu-wa warki-yada. Dukwa kinu-mungkadinama nakina ajiringka-da, dukwa jiba-manja kin-akwurrajinama-da. Biya kembirra larruwura kini-lawurradinama awurmurra nakina alikira-wa. Nara kembirra e-yamama kirrakina enuwa-wa, ‘Kwa, warenja, ambarriya-langwa yelakwa ng-angkirna-wiya ngayuwa aninga nungkwa-langwa k-alyubarini-yada.’ Nare-ka e-yamama nungkwurruwa enena ayakwa nungkwurra-langwu-wa nenikuminuwar•duwar•da kirrakina-da. ");
INSERT INTO aoi_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Nare-ka! Kirrubungkawa ena-langwa kirrakina. Kembirra yiki-yaminama kirrakina enuwa-wa, ‘Yimini-dakina aninga nganyangwa. Kembirra k-awiyebenama ningkakina dadingaba-langwa dumbala akwa ku-wilyakinama ebina aninga ningki-daka-mulangwa yangkwurrangwa ngayuwa-wa, kajungwa k-alyubarini-yada ngayuwa akina aninga, akwa ki-bekini-yada akubibeka. Kembirra arija-langwa nungkwamba-langwa ki-jenama aninga nungkwa-langwa-da,’ yiki-yaminama nungkwurra-langwu-wa nenikuminuwar•duwar•da kirrakina-da. ");
INSERT INTO aoi_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","“Nara ningkakina e-yangmarngkwajuma nungkwa-langwu-wa nenikuminuwar•duwar•da nginuminu-war•dangu-mulangwa nungkwa-langwa warka, nginumin-engkirrikenu-mulangwa ayakwa nungkwa-langwa ningkibina ningkubungkawa ena-langwa. Nare-ka-da! ");
INSERT INTO aoi_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Kembirra nungkwurrajukwaba kirrakina yiki-lyangkumakajungwunama enena ayakwa. ‘Ngarningerribirre-ka yanda ngarna. Ngarnikuminuwar•duwar•da wulkwa ngarri-yaminama, akwa ngarningaruma-ma,’ yiki-lyangkiyaminama kirrakina. Umba yiki-jerrukwuna-manja kirrakina ababurna-langwa ebina Neningikarrawara kirrenu-maka-mulangwa karniki-yama-langwa, kembirra yiki-lyangkumakajungwunama enena ayakwa. ‘Mama akina, ngarru-war•danguma ngakwurra-langwa warka, umba nara akwala,’ yiki-lyangkiyaminama kirrakina-da,” ni-yama nakina Jesus ena-langwu-wa warnikilarrkilarrka warnungkwarba nakina-da. ");
INSERT INTO aoi_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Bi...ya na-likenuma ngawa wurrakina Jesus akwa ena-langwa warnikabuburrakiyuwa mibina-langwiya ngawa mamurukwa numu-likenu-mulangwiya Jirujalemu-wa makina. Na-likenu-manja wurrakina, ngalaja akina angalya Keliliya ekalyarra-langwa nuw-ambilyuma, umba ngalaja Jameriya ekbuda-langwa nuw-ambilyuma akina. Nuw-alilikenu...wa. ");
INSERT INTO aoi_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Biya ne-yar•danga arakba wurrakina angalya-manja aminambawura-manja alikira iya warnumamalya. Yakwujina ngawa nara-wiya kuw-awiyebena akinu-wa angalya, aburraja wurrumemberrkwa warnungkwarba nenu-kwurukwa wurrakina Jesus-uwa arakba-da. Wurrakine-ka warnungkwarba nuw-alkilkayanguma ambaka awilyikerra, mena nuw-arrirreyinuma awurrakwulyumida amarmarra wurrakina-baba. ");
INSERT INTO aoi_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Biya nuw-ardanga Jesus-uwa. “Jesus...ayi!” ne-yama wurrakina. “Bungkawa...yi, errukwuliya-langwa yirraja...wu!” ne-yama wurrakina warnungkwarba, nuw-ardanguma engka-langwa Jesus-uwa. ");
INSERT INTO aoi_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Eneja Jesus neni-rringka wurrakina, akwa n-ardanguma nakina engka-langwa aburruwa-wa akwa ni-yama, “Jeyi! Wurri-likaja kembirra arakba Neningikarrawara-langwu-wa alikira...wu, kajungwa yikabu-rringkini-yada yakwujina WurruMinida warnungkwarba...wu! Akwa yikabumini-rringkini-yada nungkwurra-langwa karnumakwulya...wu!” ni-yama nakina Jesus. Kembirra na-likena arakba aburraja wurrakina wurrumemberrkwa warnungkwarba angerriba Neningikarrawara-langwu-wa alikira. Biya na-likenu-manja ngawa mamurukwa-langwiya, na-mungkwur•dadinuma lukwakwa warnumakwulya wurrakina-da. ");
INSERT INTO aoi_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","16","Umba kembirra nuwilyaba nenungkwarba ni-rringkajungwa nakina n-eningabaduma arakba, akwa ni-lawurrada dirrbura Jesus-uwa. Niminingke-ka nenungkwarba, NeningiJameriya nakina. Biya ni-yangkarjiyajungwunuma nakina neni-yangmarngkwajuwama Neningikarrawaru-wa. “Neningabe-ka Nubungkawa Neningikarrawara!” ni-yama. Biya n-abuluwendinga n-engmudirruwajungwa nenumukwurra nakina ajiringka-wa akwudangwa Jesus-langwa-manja alika, akwa ni-yama nakina Jesus-uwa, “Ngeniyerriya, yiminu-mungkwur•dangu-murrada nganyangwa ningenumakwulya!” ni-yama nakina-da. ");
INSERT INTO aoi_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Eneja ni-yama Jesus, “Wurrumemberrkwa warnungkwarba ningarra-mungkwur•danguma warnumakwulya ngayuwa, akena wurrangamba wurrukwala wurrumangbala wurrabiyarbuwa? ");
INSERT INTO aoi_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Miyambena-burra naka nenungkwarba niminingka ni-lawurradinuma nuwilyaba-ma nakwukawura ngayuwa-wa akwa neni-yangmarngkwajuwama nakina yimbukwa Neningikarrawara?” ni-yama Jesus. ");
INSERT INTO aoi_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Biya ni-yama nakina Jesus nakinu-wa nenungkwarba, “Mirajanga!” ni-yama. “Jeyi! Likaja arakba. Nara yiku-minikalyika ayakwa nganyangwa, umba ningk-eningmidinuma ngayuwa ka-mungkwur•dena-mulangwa warningerribirra-langwa warnumamalya. Kembirra akina-langwa ningk-eningabaduma arakba ningkakina-da,” ni-yama Jesus nakinu-wa niminingka nenumamalya NeningiJameriya-wa-da. ");
INSERT INTO aoi_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Bi...ya aburraja wurrukwala WurruBarija warnungkwarba neni-yendabena wurrakina Jesus-uwa. “Ngambi-yada-burra Neningikarrawara kinu-bungkawadinama nakina ngarrababurna-manja ngarnumamalya?” ne-yama. Eneja ni-yama Jesus, “Kinu-bungkawadina-manja Neningikarrawara, nara kirrakina a-rringkama menba-murra kinu-bungakwadina-mulangwa nakina. ");
INSERT INTO aoi_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Akwa nara e-yamama amukwiyadakena ayakwa, ‘Kwuja! Naka-bina!’ akwa ngawa, ‘Nangaba!’ nare-ka e-yamama kirrakina. Ngarra-makinama ngayuwa ningena, Neningikarrawara kinu-bungkawadinama nakina akini-yada ngawa yikinumini-yarrkuwarakina-manja kirrakina ayakwa karnumamalya ena-langwa nungkwurra-langwa-manja mangma iya yukwudukwuda,” ni-yama Jesus wurrumurndakakinu-wa WurruBarija warnungkwarba-da. ");
INSERT INTO aoi_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Biya kembirra ni-yama nakina Jesus ena-langwu-wa warnikabuburrakiyuwa, “Arngkingka-manja yiki-ngayindenama kirrakina karniki-rringki-yada ngayuwa ki-lawurradina-mulangwa yangkwurrangwa ngayuwa, ningibina-murrada ningi-rukwularrinuma enena-manja angalya. Yiki-ngayindenama karniki-rringki-yada ngayuwa aduwaya, wulkwa muwilyaba-ma ngawa mamawura, akena nara a-rringkama kirrakina ngayuwa-da. ");
INSERT INTO aoi_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","“Aburraja kirrabu-makinama wurrukwala warnumamalya, ‘Kwuja! Nangaba!’ umba aburraja wurrukwala, ‘Naka-da!’ Akena nungkwurraja nara engkirrikuma aburruwa-wa, e-yuwama aburruwa-manja. ");
INSERT INTO aoi_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Nare-ka engkirrikuma aburruwa-wa, mena ki-lawurradina-manja ngayuwa, kembirra wurrababurna-langwe-ka warnumamalya kabu-rringkinama ngayuwa-wa. Wuburra laka yibina yibilyibilya kini-ngarningmindena-manja yakina, kembirra yikini-rringkina-manja kirrakina kini-larrkabarrakajinama angalya yakina angerriba iya angerriba, yakine-ka wuburra ki-lawurradinama nganja ningena. Aburraja kembirra kabu-rringkinama wurrababurna-langwa warnumamalya ngayuwa, ningibina-murrada ningi-rukwularrinuma enena-manja angalya. Kabu-rringkiname-ka aburra-langwa-murra menba wurrakina. ");
INSERT INTO aoi_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Akena adinuba-wiya nganja ki-lyandinama ningena ngayuwa angwurra, ka-warena-mulangwa ngayuwa warna warnumamalya warningaduwaba,” ni-yama Jesus nakina-da. ");
INSERT INTO aoi_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","27","Biya ni-yama ngarningka nakina Jesus, “Arakburakba-kiya-wiya, n-ambilyu-wiya nakina Nawa, aburraja wurrakina warnumamalya namin-engkingkirrikajajungwunuma ngawa warningangkawura. Ne-yaminjamama na-jijanguma aninga, ne-bibekinuma wurrakina akubibeka. Akwa ne-yakiyakeyinuma warnungkwarba iya wurridarringka, nuw-ambambilyuma ngawa. Ne-yaminjamama wurriyirrbiyirrba ngawa-da. “Bi...ya eneja ni-jerrukwama ebina arakba warka nu-war•dangu-mulangwa nakina Nawa, numa-ngekburaka-mulangwa num-ar•dirrangu-mulangwa mibina mijiyanga memikirra arka. Kembirra n-awiyebenuma nakina akwa ena-langwa wurrukwala warnumamalya aburruwa. Kembirra ni-larrinuma ngalaja yibina yelyukwa. Umba nawurraki-jungweyinuma wurrumurndakibina warnumamalya wurruwurrakwulyumida. Wurrababurna-langwa na-jungweyinuma. Wulkwa eneja Nawa neniba n-ambilyuma nakina akwa ngawa ena-langwa warnumamalya. Kembirra akine-ka wuburra, ke-yaminama warnumamalya aburrajukwaba ki-lawurradina-manja ngayuwa, ningibina-murrada ningi-rukwularrinuma enena-manja angalya. Kamin-engkingkirrikajajungwunama aburrajukwaba wurrakina ngawa-da. ");
INSERT INTO aoi_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","“Akwa ngarningka arakburakba-kiya-wiya, n-ambilyu-wiya nakina Lada, aburraja WarningiJaduma warnumamalya namin-engkingkirrikajajungwunuma warningangkawura wurrakina aburrajukwaba. Ne-yaminjamama na-jijanguma aninga akwa ngawa ne-bibekinuma akubibeka. Namurndaku-beyindanguma akwa ngawa narri-lungkuwabijuwama amamarda aninga, akwa narri-ngekburakama alikira. Ne-yaminjamama wurriyirrbiyirrba ngawa wurrakinu...wa. ");
INSERT INTO aoi_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Akena ni-lalika-manja nakina Lada ebina angalya Jaduma, mibina-manja ngawa mamawura, eneja Neningikarrawara ni-larrkama angwura angubina-langwa ajiringka-wa. Ngalaja nawurraki-kalaridinuma akwa nawurraki-jungweyinuma wurrumurndakibine-ka WarningiJaduma warnumamalya. Wurrababurna-langwa na-jungweyinuma wurrakina, umba yimbukwa Lada neniba n-ambilyuma nakina. ");
INSERT INTO aoi_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Kembirra akine-ka wuburra, aburrajukwaba ke-yaminama warnumamalya, akini-yada ngawa k-abilyerrikajungwuna-manja ngayuwa, ningibina-murrada ningi-rukwularrinuma enena-manja angalya. Aburrajukwaba kamin-engkirrikajajungwunama wurrakina ngawa-da. ");
INSERT INTO aoi_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“Akini-yade-ka ngawa, eneja kin-ambilya-manja nuwilyaba nenungkwarba ena-langwa-manja alikira karrawara ekbilyuwalya-manja, nara nakina a-dirrirnduma akwa awiyebuma arrawu-wa angkama amurndakijika ena-langwa. Umba enejukwaba ningka-langwa nenungkwarba kinu-war•dena-manja warka errekba-manja, nara nakina errikerruma akwa a-lawurraduma angalyu-wa. ");
INSERT INTO aoi_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Nungkwurraja yik-eningmidinama karna yingi-yama-mulangwa ying-errikerrinu-mulangwa dibina dadingiyenibka Lada-langwa. Kembirra yiki-yakuwerribikinama ambaka-langwa ngaluwa-wa kirrakina-da. ");
INSERT INTO aoi_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","“Umba eneja nuwilyaba nenungkwarba nibina kini-lyelyingmajungwunama kini-ngayindena-manja ababurna-langwa amurndakijika enena-manja angalya umba kinu-warena-manja Neningikarrawara, kembirra kini-jungwunama neningangkawura nakina-da. Umba nibine-ka eneja nenungkwarba nara-manja a-waruma neniki-jungwangena-langwa umba ken-aburrakiyuwarna-manja ngayuwa-manja nakina, neniba kin-ambilyama neningangkawura nakina-da,” ni-yama Jesus ena-langwu-wa warnikabuburrakiyuwa-da. ");
INSERT INTO aoi_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Biya kembirra ngarningka ni-yama nakina Jesus, “Ngarra-makinama ningena ngayuwa,” ni-yama nakina, “akini-yada ngawa aburraja wurrambilyuma warnumamalya-kiya ka-mungkwula-manja marringa wurrakina muwilyaba-murra-manja ngawa mamukumungkwulinga alyarrngwalyilya, kembirra aburraja Neningikarrawara-langwa warnikumamurikaja ka-wekbalyinama wurrakina wurruwilyaba-ma ngawa, umba karra-lalikinama wurrakina wurruwilyaba-ma-da. ");
INSERT INTO aoi_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","36","Umba aburringaja wurringambilyuma wurringidarringka-kiya karringu-war•dena-manja warka wurringalakina akwa karringu-mamurikajeyina-manja karringi-rungkwulena-manja ebina amadidira, kembirra aburraja Neningikarrawara-langwa warnikumamurikaja ka-wekbalyinama wurrakina wurruwilyaba ngawa wurridarringka, umba karra-lalikinama wurrakina wurruwilyaba-ma-da,” ni-yama Jesus ena-langwu-wa warnikabuburrakiyuwa nakina-da. ");
INSERT INTO aoi_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Aburraja ne-yama wurrakina, “Bungkawa,” ne-yama, “nga-manja ke-yaminama akina?” Eneja Jesus nenumini-lawurrakajuwa nakina enena ayakwa ena-langwu-wa warnikabuburrakiyuwa. Akwa ni-yama nakina, “Ka-murrkwulijeyina-manja warnumadangkwa warninikijungwa ajiringka-manja, kembirra yakwujina akina-manja ngawa angalya yikini-rringkinama yukwurrijija-murriya kinuwurra-murndukwunama yakina-da,” ni-yama nakina Jesus ena-langwu-wa warnikabuburrakiyuwa-da. ");
INSERT INTO aoi_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Biya kembirra nenu-makama Jesus enena alawudawarra ena-langwa-manja warnikabuburrakiyuwa, kajungwa warningmi-yada ngawa wurrakina ka-buriyamina-mulangwa ngawa mababurna-langwa marringa akwa kembirra nari-yada a-werrikilyangmuriduma a-werrikungwanjuma wurrakina. ");
INSERT INTO aoi_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Nuwilyaba nubungkawa n-ambilyuma nakina. Biya ni-lyangkuwerribikajungwunuma nakina warnumamalya-langwa warningaba-murrikba akwa wurruwurrariya-murrikba, mena ena-langwa warka akina. Akena nara nakina kenumin-engkirrikena Neningikarrawaru-wa iya warnumamalyu-wa. ");
INSERT INTO aoi_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","4","Ngalaja duwilyaba didarringka duminakina angalya yingi-likenuma enuwa-wa. Dingaya dakina. “Marrakba,” yingi-yama, “yi-mamurikajiya-langwa nganja, mena nuwilyaba nenungkwarba nginumini-ngekburaka-mubaba awurrariya nganyangwa. Kemba ki-lyangkuwerribikajungwunama nungkwaja ningkakina yinalakena-langwa yinenumamalya-kiya, akwa yikumini-yengbinama ayakwa nungkuwa nganyangwa enuwa-wa nuwarnkarnyerra-baba nakina-da,” yingi-yama dakina. Akena eneja nubungkawa nu-waranguma akwa n-ambudidina neningamiyerra nakina, akwa nara kininga-mamurikajuwa kembirra dakina dingaya. Umba ngalaja ying-alilikenuma ngawa diyirrbiyirrba enuwa-wa. Yingi-yaminjamama dakina ngawa-da. Eneja nubungkawa nu-waranguma kembirra dakina ngawa. Bi...ya arakba-langwa ni-lyangkiyama nakina kembirra, “Nara engkirrikuma ningena ngayuwa Neningikarrawaru-wa iya warnumamalyu-wa akena, ");
INSERT INTO aoi_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","daka-langwa dingaya ningu-warenama ning-erriburandiname-ka. Aminakina-langwa kemba kinga-mamurikajinama ningena ngayuwa. Nara-manja a-lyangkuwerribikajungwuma ningena ngala-langwa-langwa eningaba, ngalaja kembirra king-alilikajama ngawa dakina ngayuwa-wa diyirrbiyirrba ngawa-da. Kembirra nganja k-erriburandinama ngayuwa angwurra-da,” ni-yama arakba nakina nubungkawa, ni-lyangkumakajungwunuma-da. Enena ngawa-da. ");
INSERT INTO aoi_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Enene-ka alawudawarra Nubungkawa Jesus nenu-makama ena-langwa-manja warnikabuburrakiyuwa. Biya kembirra ni-yama nakina aburruwa-wa, “Yiki-yakuwerribikinama karna nakina-langwa nubungkawa ngarra-maka-mulangwa,” ni-yama. “Arakba-langwa kembirra eneja nanga-mamurikajuwama dakina-manja dingaya, mama nakina nuwurrariya. ");
INSERT INTO aoi_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Umba eneja nakina Neningikarrawara n-engkingkirrikajama ayakwa ena-langwa-langwa karnumamalya akwa kirren-akukwurrajinama nungkwurruwa-manja. Kembirra yik-ardirdena-manja kirrakina enuwa-wa meningilida iya alyarrngwalyilya, kin-engkirrikajama nakina akwa kini-lyangkuwerribikajungwunama nungkwurra-langwa-langwa eningaba. Yikenumin-akwurrajinama karnumamalya kirribina nu-wekbalyinuma nakina ena-langwi-yada karnumamalya kirrakina. Nara nakina ambudirrkajungwuma, ");
INSERT INTO aoi_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","umba yikenu-mamurikajinama kirrumurndakakina warenja-bawiya-da. Amandangwa nganja ki-lawurradinama yangkwurrangwa ngayuwa, ningibina-murrada ningi-rukwularrinuma enena-manja angalya. Dukwe-ka aburraja kuw-embirrarina warnumamalya ngayuwa-wa, akwa ka-werrikambilya ngawa ngayuwa-wa, dukwa nara-da,” ni-yama Nubungkawa Jesus ena-langwa-manja warnikabuburrakiyuwa nakina-da. ");
INSERT INTO aoi_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Enena ngarningka awilyaba alawudawarra Jesus-langwa. Nenu-makama nakina enena alawudawarra wurrukwalu-wa warnumamalya wurribina na-ngkweningabakajungwunu-murruwa. Wurrakine-ka ne-yaminjamama wurrukwalu-wa warnumamalya, “Yirre-ka yarningaba-wiya yarna yarnumamalya umba nungkwurraja kirruwurrariya kirrakina-da,” ne-yama wurrakina warnumamalya-da. Kembirra aminakina-langwa nenu-makama Jesus enena alawudawarra. ");
INSERT INTO aoi_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Wunambilyuma wunenungkwarba-kiya nen-ambilyumurra Jirujalema-manja wunalakina. Nuwilyaba NuBarija nenumamalya nakina, umba nuwilyaba nenuminu-war•danguma warka WarningiRawuma-langwa wurrububungkawa akwa nuwurra-murndukwama nakina angwarnda warnumamalya-langwa. Biya neni-likenuma wunalakina-kiya Neningikarrawara-langwu-wa angalya kajungwa yakwujina wuneniku-buriyami-yada Neningikarrawaru-wa wunalakina. ");
INSERT INTO aoi_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Nakine-ka NuBarija nenumamalya n-awiyeba akinu-wa angalya biya nu-kuwarjeyuma nakwukawura ngawa, nu-buriyaminuma Neningikarrawaru-wa yakwujina. Biya “Ningkeningikarrawara,” ni-yama, “yirre-yangmarngkwajinama nungkuwa-wa, mena nara-baba e-yamama ngayuwa wuburra wurrukwala warnumamalya ne-yaminjaminama wurrakina aduwaba. Nuw-angmadame-ka wurrakina angwarnda iya amurndakijika-murriya wurrukwala-langwa warnumamalya, akwa wurrumungwur•dangma wurrakina. Warniniyerriye-ka warnumamalya akwa na-rndirndirrkeyinama erribirra warningerribirra-manja wurridarringka. Nara nganja wurrumurndakakina wuburra warnumamalya e-yamama ningena. Akwa ngarningka nangaba wuburra nenungkwarba nuwurrariya nibina nenuminu-war•denama WarningiRawuma-langwa, nara ningena e-yamama enuwa wuburra ningena ningenumamalya ngayuwa. ");
INSERT INTO aoi_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Ngayuwe-ka ningena k-ambilyama murumureya muwilyaba-manja mamawura akwa mingka-manja ababurna-langwa wika, kajungwa yiba-yangmarngkwajini-yada ngayuwa nungkuwa-wa. Akwa ena ngarningka. Ku-mena-manja ngayuwa angwarnda nganyangwa, ku-murnduwarnama akina akwa yiba-kwunama awilyaba akina nungkuwa-wa umba amangbala abiyarbuwa ku-minambilyama ningeningangkawura-da,” ni-yama nakina NuBarija nenumamalya Neningikarrawaru-wa nakina-da. ");
INSERT INTO aoi_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Eneja ningka-langwa nenungkwarba nara kin-akwudangwukajungwuna nakina warnumamalyu-wa umba nu-kuwarjeyuma nakwukawura engka-langwa-langwa. Nu-buriyaminu-manja nakina, nara kinu-ngwundikadina angubina-wa umba nu-wardijungwunuma yukwudukwuda-manja, mena ni-lyangkiyeliyangu-mubaba nakina. Ni-yama, “Ningkeningikarrawara, ninguwurrariye-ka ngayuwa, umba errukwuliya-langwa nganja ningena,” ni-yama nakina. Ena ngawa. ");
INSERT INTO aoi_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Biya nenu-maka-mulangwa nakina Jesus enena alawudawarra wurrumurndakibina-manja warnumamalya, kembirra ni-yama aburruwa-wa, “Amandangwa eneja Neningikarrawara nara kenu-werrungwur•danga nakina nibina-manja NuBarija nenumamalya umba nenu-werrungwur•dangume-ka nakina-manja nenikumurndumurndukwa angwarnda nenungkwarba. Kembirra nara-manja a-ngkweningabakajungwuma kirrakina, kembirra Neningikarrawara enamba-langwa kini-yaminama nakina nungkwurruwa-wa, ‘Ningkarume-ka ningkakina ningkenumamalya,’ kini-yaminama nakina-da. Umba karningerribirra karnumamalya yiku-ngkweningabakajungwuna-manja kirrakina, kembirra Neningikarrawara enamba-langwa keni-yengkiyelijinama nungkwurruwa-wa nakina-da,” ni-yama Jesus wurrumurndakibinu-wa warnumamalya-da. ");
INSERT INTO aoi_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Aburraja kembirra wurrukwala warnumamalya narra-lyilyanguma wurriyukwayuwa aburra-langwa Jesus-uwa kajungwa neniku-minjirrkilyingi-yada Jesus wurrakina-manja wurriyukwayuwa. Umba aburraja warnikabuburrakiyuwa Jesus-langwa narra-rringkama wurrakina warnumamalya namurndaki-likenuma enuwa-wa. Biya na-ngwurrkiyengbeyinuma ayakwa aburruwa-wa mena na-warangu-mubaba warniki-lika-langwa wurrumurndakakina wurriyukwayuwa Jesus-uwa-da. ");
INSERT INTO aoi_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Akena eneja Jesus nen-ardijuwa nakina wurrumurndakakinu-wa wurriyukwayuwa warniki-liki-yada enuwa-wa. Ni-yama kembirra nakina ena-langwu-wa warnikabuburrakiyuwa, “Nara kirrakina a-murndurrkwama wurrakina umba wurra-lalikina, abu-likaja wurriyukwayuwa ngayuwa-wa,” ni-yama. “W-engkirrikiya! Yiki-likaja-manja karningerribirra karnumamalya Neningikarrawaru-wa wuburra laka wurrumurndakenena wurriyukwayuwa na-likenuma aduwaba ngayuwa-wa, kembirra yik-eningmidinama kirrakina Neningikarraware-ka nakina nu-bungkawadina-mulangwa arakba nungkwurruwa-manja. ");
INSERT INTO aoi_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Akena karningerribirra karnumamalya nara-manja a-werrikambilyuma kirrakina Neningikarrawaru-wa, karningbala kembirra kirrakina kinu-bungkawadina-mulangwa Neningikarrawara nungkwurruwa-manja. Umba yiku-werrikambilyame-ka kirrakina Neningikarrawaru-wa nungkwurrajukwaba, wuburra laka wurrumurndakenena wurriyukwayuwa na-werrikambilyama Neningikarrawaru-wa-da,” ni-yama Jesus ena-langwu-wa warnikabuburrakiyuwa-da. ");
INSERT INTO aoi_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Bi...ya eneja nuwilyaba nubungkawa NeningiJudiya nubukwaya ni-likena nakina Jesus-uwa. Akwa ni-yama, “Ningkeningaba ningkenikakakirumaka, yi-makina, ki-yamarrkinama ngayuwa kajungwa k-ambilyi-yada ngayuwa ningeniba ningeningangkawura?” ni-yama nakina Jesus-uwa. ");
INSERT INTO aoi_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Eneja ni-yama Jesus, “Miyambena-burra ningki-yaminama ngayuwa-wa, ‘Ningkeningaba?’ Nara wurribina warnumamalya warningaba-da. Wulkwa Neningikarrawara nuwilyaba-ma neningabe-ka nakina-da. ");
INSERT INTO aoi_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Ningkeningma Neningikarrawara-langwa ayakwa eningarumuruma. Ngarraku-makinama akina ayakwa ngakwurruwa-wa nari-yada a-rndirndirrkajuma ngarna, akwa nari-yada a-lamukwarriduma ngarna, akwa nari-yada angmaduma, akwa nari-yada amini-kikaduma ayakwa wurrukwala-langwa warnumamalya, umba aka-werrikiyangmarngkwajini-yada ngarna wurrungungwanyungwa iya wurrirndirndanyungwa ngakwurra-langwa-da,” ni-yama Jesus enuwa-wa. ");
INSERT INTO aoi_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Eneja ni-yama nakina nenungkwarba kembirra Jesus-uwa, “Yawe-ka,” ni-yama. “Ningeningma ngayuwa. Ningu-wilyakama amurndakakina ayakwa ningiyukwujiya-wiya ngayuwa, biya ningi-yarrkiyarrkuwarakama akina ningeningangkawura yanda-langwa aduwaba-da,” ni-yama. ");
INSERT INTO aoi_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","N-engkirrika-manja eneja Jesus amurndakakina ayakwa, kembirra ni-yama nakina enuwa-wa, “Ena engka awilyaba ki-yaminama ningkena,” ni-yama nakina. “Ka-kwunama angwarnda nungkwa-langwa warningalyingmalyingma-wa warnumamalya. Adinuba-wiya ki-lyilyenama nungkwa-langwa amurndakijika wurrukwalu-wa warnumamalya, biya ku-warrukwajinama amurndakakina amurndakijika angwarndu-wa. Biya kembirra akine-ka angwarnda ningku-manguma nungkuwa warnumamalya-langwa ka-kwunama ningkakina angkwulyumida-langwa akina wurrukwalu-wa warnumamalya wurribina warningalyingmalyingma-wa. Ki-yamina-manja akina nungkuwa ningkakina, kembirra ambaka-murrumurra eneja Neningikarrawara kenu-kwunama nungkuwa-manja ababurna eninginingaba ena-langwa-manja angalya abalkaya. Ki-yaminame-ka adinuba-wiya akina yirra-maka-mulangwa, kembirra arija-langwa ki-lawurradinama nungkuwa ngayuwa-wa akwa yiki-yuwarnama ngayuwa-manja ningkakina-da,” ni-yama Jesus nakinu-wa nenungkwarba. ");
INSERT INTO aoi_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Eneja n-engkirrika-manja nakina nenungkwarba amurndakakina ayakwa Jesus-langwa, nu-werrikawarriyada arakba. Numinababurne-ka angwarnda iya amurndakijika-murriya nakina-baba, kembirra n-arrirriyade-ka nenumukwurra arakba-da. ");
INSERT INTO aoi_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Umba eneja neni-rringka nakinu-wa nenungkwarba nakina Jesus nu-werrikawarriyadu-mulangwa akwa ni-yama, “Ke-yamarrkiname-ka warnumamalya wurruminababurna angwarnda iya amurndakijika? Ke-yamarrkinama warnik-awiyeba-langwa wurrakina Neningikarrawara-langwu-wa angalya abalkaya? ");
INSERT INTO aoi_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Eneja nuwilyaba nenumamalya, nibina numinababurne-ka angwarnda iya amurndakijika, nara warenja-bawiya a-werrikambilyuma Neningikarrawara-manja nakina. Akwa nara ngarningka warenja-bawiya awiyebuma nakina Neningikarrawara-langwu-wa angalya abalkaya. Yi-makina enena. Ngalaja duwilyaba kamila dibina daruma-dangwa kingi-rukawiyebena dakina e...yukwujiya-langwa edirra-na? Nare-ka-da! Nare-ka a-rukawiyebuma dakina. Umba eneja nenumamalya numinababurna angwarnda iya amurndakijika kin-awiyebenama nakina warenja-bawiya Neningikarrawara-langwu-wa angalya abalkaya-na? Nare-ka-da! Nara nakina awiyebuma-da,” ni-yama Jesus nakinu-wa nenungkwarba. ");
INSERT INTO aoi_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Aburraja wurrukwala warnumamalya nuw-engkirrikenu-mulangwa amurndakakina ayakwa Jesus-langwa ne-yakikbijangeyinuma wurrakina. Biya ne-yama, “Wurrumiyambene-ka kembirra warnumamalya ken-enibikinama eneja nakina Neningikarrawara wurrakina?” ne-yama. ");
INSERT INTO aoi_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Ni-yama kembirra eneja nakina Jesus, “Kini-yaminame-ka Neningikarrawara ababurna-langwa nakina. Aburraja na-lyangmuridinama warnumamalya akena nakina Neningikarrawara nara-da,” ni-yama nakina. ");
INSERT INTO aoi_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Eneja kembirra ni-yama Bida, “Umba yirraja yirruwa yarna yirri-lalikama ababurna-langwa yirra-langwa, akwa nungkuwa-wa ngarre-yuwarnuma,” ni-yama nakina Bida Jesus-uwa. ");
INSERT INTO aoi_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Eneja ni-yama Jesus Bida-wa akwa ngawa wurrumurndakibinu-wa warnumamalya wurrababurnu-wa aburrajukwaba, “Mungkwa-da!” ni-yama. “Umba nungkwurraja kirruwilyaba karnumamalya dukwa yiki-lalikinama kirrakina alikira nungkwurra-langwa iya nungwenungwa iya dirndenungwa iya nawenungwa iya dadingiyenungwa akwa wurriyukwayuwa nungkwurra-langwa aburrajukwaba. Yiki-lalikinama kirrakina ababurna-langwa nungkwurra-langwa kajungwa Neningikarrawara kinu-bungkawadini-yada nungkwurruwa-manja nakina. ");
INSERT INTO aoi_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","Yiki-lalikina-manja kirrakina ababurna nungkwurra-langwa, kembirra eneja Neningikarrawara yikenumini-lawurrakajinama nakina ababurna nungkwurruwa-wa. Kembirra nungkwurraja yiku-mename-ka kirrakina eningaba ababurna angwurra enena-manja angalya. Akwa ngarningka yiki-jungwuna-manja kirrakina, yiki-likajama Neningikarrawara-langwu-wa angalya abalkayu-wa akwa yik-ambilyama yakwujina karningangkawura-da,” ni-yama nakina Jesus wurrumurndakakinu-wa warnumamalya-da. ");
INSERT INTO aoi_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Bi...ya Jesus nenu-wilyakama arakba nakina ena-langwa warnikabuburrakiyuwa wurrumemberrkwa wurrambilyuma nara-murruwa wurrukwala warnumamalya. Biya ni-yengbinuma amurndakenena ayakwa aburruwa-manja. Ni-yama nakina, “W-engkirraja ena ayakwa nganyangwa,” ni-yama. “Ngarri-likajama arakba ngarna angerriba Jirujalemu-wa. Arakburakba-kiya-wiya aburraja wurrumurndakibina WurruBuburabuda warnumamalya ne-yengbinuma ayakwa ngayuwa-langwa, ningibina ningi-rukwularru-mulangwa enena-manja angalya. Kembirra ngalaja ayakwa aburra-langwa nuw-arrikarrijungwunuma jurra-manja akina. Kembirra amurndakakina ababurna-langwa ne-yengbinu-mulangwa wurrakina adinuba-wiya ka-ngekburakajungwunama akina yakwujina Jirujalema-manja-da. ");
INSERT INTO aoi_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","“Umba aburraja wurrukwala warnungkwarba yakwujina Jirujalema-manja kabu-wilyakinama ngayuwa WarningiJudiya-murru-wa warnumamalya. Aburraja kembirra wurrumurndakakina warnumamalya kabu-wurrumalyakinama, kabu-rinjarrkinama akwa kabu-kwurarrkinama ngayuwa-manja wurrakina-da. ");
INSERT INTO aoi_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Biya kembirra kabu-larrkbarjenama ngayuwa akwa ngawa kabi-jungwajinama-da. Akena mabiyakarbiya-manja mamawura ku-mirajanginama ngayuwa ki-jungwuna-mulangwa-da,” ni-yama Jesus. ");
INSERT INTO aoi_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Akena aburraja wurrumurndakibina warnikabuburrakiyuwa Jesus-langwa nara karru-mumiringka ena-langwa ayakwa. Nuw-engkirrikenuma mada-murra wurrakina akena nawurraki-lyumadinuma amurndakakina ayakwa mena warningbala-wiya-baba ambaka wurrakina-da. ");
INSERT INTO aoi_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Biya kembirra narruma-yuwarnuma ngawa wurrakina Jesus-murriya mibina mamurukwa numu-likenuma makina Jirujalemu-wa. Namurndak-alilikenu...wa. Biya nuw-akwudangwukajungwa wurrakina Jerika-manja arakba. Umba eneja nuwilyaba nenungkwarba nimimba n-angmungmakwulaluma nakina yakwujina mulikarrkbidjina-manja mamurukwa. Kembirra wurrukwala warnumamalya na-likenu-manja neni-yarruwarnu-manja wurrakina nakina-manja nimimba, neni-yukwamajuwama nakina angwarnda aburruwa-wa. ");
INSERT INTO aoi_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","N-engkirrika-manja nakina nimimba wurrumurndakibina wurrababurna warnumamalya wurrarrijinungkwa nawurraki-likenuma, neni-yendabena kembirra wurrukwalu-wa warnumamalya. “Ne-yamarrkinama wurrakina angakuba?” ni-yama nakina. ");
INSERT INTO aoi_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Aburraja ne-yama, “Jesus NeningiNejirida naka-da akwa ni-likajama memema-langwiya mamurukwa-da.” ");
INSERT INTO aoi_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Eneja kembirra nakina n-ardanga nimimba Jesus-uwa. “Jesus...ayi!” ni-yama. “Ningkumirenikba Deyibida-langwa, errukwuliya-langwa nganja ningena...wu!” ni-yama. ");
INSERT INTO aoi_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Aburraja na-lyengmanguma wurribina warnumamalya na-ngwurrkiyengbeyinuma enuwa-wa. “Yengminjada!” ne-yamama wurrakina. Akena ngarningka ngawa n-ardanga eneja nakina angwurra Jesus-uwa. “Ningkumirenikba Deyibida-langwa...wu!” ni-yama. “Errukwuliya-langwa nganja...wu!” ni-yama. ");
INSERT INTO aoi_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Eneja kembirra n-arjiyinga Jesus, akwa nenu-maka wurrukwala-manja warnungkwarba. “Wunu-wilyakina nangaba yangkwurrangwa ngayuwa-wa,” ni-yama. Aburraja wurrukwala nenu-wilyaka kembirra nakina Jesus-uwa arakba-da. Umba ni-yama nakina Jesus enuwa-wa, ");
INSERT INTO aoi_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Ki-yamarrkinamurra ngayuwa nungkuwa-manja ningena yi-ngayinduma?” ni-yama. Eneja ni-yama, “Bungkawa, ningi-ngayindenama ningena k-andiyama ngarningka,” ni-yama. ");
INSERT INTO aoi_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Kembirra ni-yama arakba eneja nakina Jesus nimimbu-wa, “Andiya kembirra arakba! Nara yiku-minikalyika nungkuwa umba ningk-eningmidinuma ngayuwa yib-eningabakina-mulangwa ningkakina. Kembirra aminakina-langwa ningk-eningabaduma arakba-da,” ni-yama Jesus enuwa-wa-da. ");
INSERT INTO aoi_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Arngkawura-wiya ngawa eneja nenungkwarba n-andiyinga arakba nimimba-murrada nakina. Biya neni-yuwarna Jesus-manja, akwa neni-yangmarngkwajuwama Neningikarrawaru-wa nakina. Umba aburraja wurrababurna-langwa warnumamalya yakwujina nuw-ambilyuma neni-rringkama nakina n-andeyuma arakba menba, akwa neni-yangmarngkwajuwama aburrajukwaba Neningikarrawaru-wa wurrakina-da. ");
INSERT INTO aoi_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Biya Jerika-manja arakba wurrakina namurndaki-yar•duma Jesus-murriya. Akena nara ka-ngwanjina wurrakina yakwujina umba dirrbura namurndaki-likenuma narruwurraku-warrukwama alikira. ");
INSERT INTO aoi_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Umba eneja n-ambilyuma nakina yakwujina nuwilyaba nenungkwarba nenimikirra Jekiyija. Numinababurne-ka angwarnda iya amurndakijika nakina. Niyukwujiya nubungkawa nakina umba nenuminu-war•danguma warka WarningiRawuma-langwa wurrububungkawa. Nuwurra-murndukwama angwarnda warnumamalya-langwa kajungwa neniku-kwi-yada akina ena-langwu-wa wurrububungkawa. ");
INSERT INTO aoi_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Nakina Jekiyija neningma arakba Jesus-murriya wurrubukwaya namurndaki-likenuma wurrakina. Akwa neni-ngayindanguma neniki-rringki-yada nenumukwurra Jesus-langwa, mena neningbala-baba nakina. Akena nirukwudarrbe-ka nakina nenungkwarba, akwa aburrajukwaba wurrababurne-ka warnumamalya mamurukwa-manja na-murndukwunuma akwa nawurraki-lyibilyidanguma wurrakina. ");
INSERT INTO aoi_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Nakine-ka kembirra ni-lyengmanga arakba, n-angkarra eningabu-wa eka akuwurduwurdu-wa. Biya nu-wurdanga arakba nakina karrawaru-wa eku-wa kajungwa nenik-andiyingi-yada Jesus-uwa kinu-warrukwuna-murruwa akina eka-da. ");
INSERT INTO aoi_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Eneja kembirra n-akwudangwukajungwunumurra arakba Jesus ebinu-wa eka n-ambilyu-murruwa Jekiyija. Biya n-andiyinga nakina Jesus karrawaru-wa enuwa-wa. Ni-yama nakina Jekiyiju-wa, “Dirrirndiya warenja enena-wiya mena-baba ki-likajama ningena nungkwa-langwu-wa alikira aduwaba,” ni-yama. ");
INSERT INTO aoi_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Kembirra warenja-bawiya ni-dirrirndinga eneja Jekiyija ajiringka-wa biya nenu-wilyaka Jesus ena-langwu-wa alikira. Niyekirrerre-ka arakba nakina nenungkwarba nen-awiyebajuwa Jesus ena-langwa-manja alikira. ");
INSERT INTO aoi_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Umba aburraja wurrukwala warnumamalya neni-rringka Jesus ni-likenuma nakina Jekiyija-langwu-wa alikira akwa na-ngwurrkiyengbeyinuma wurrakina. “Nuwurrariye-ka nakina Jekiyija akena Jesus ni-likenuma ena-langwu-wa alikira-da!” ne-yama wurrakina. ");
INSERT INTO aoi_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Eneja Jekiyija n-arjiyinga akwa ni-yama nakina Nubungkawu-wa Jesus, “Ningkubungkawa,” ni-yama, “ka-kwunama ngayuwa ababurna amurndakijika nganyangwa warningalyingmalyingma-wa warnumamalya. Ekuwarra ku-minambilyama nganyangwa umba ekuwarra ka-kwunama aburruwa-wa. Umba ebina angwarnda ningu-manguma ngayuwa wurrukwala-langwa warnumamalya ningarra-kadika-mulangwa, kembirra kamini-lawurrakajinama arakba ababurna, arngkabiyarbuwa-ma ebina ningu-manguma kamini-lawurrakajinama akina ngayuwa-da,” ni-yama nakina Jekiyija-da. ");
INSERT INTO aoi_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Eneja ni-yama Jesus, “Aduwaba memema-manja mamawura eneja Neningikarrawara nen-enibikama nakina warna warnumamalya enena-manja alikira. Nake-ka nenungkwarba n-ambilyama nenikaduwa numirenikba Aburiyama-langwa. ");
INSERT INTO aoi_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Umba ngayuwa, ningibina-murrada ningi-rukwularrinuma enena-manja angalya, ningi-likenuma yangkwurrangwa enenu-wa angalya kajungwa k-aburangkini-yada wurribina na-lyumadinu-murrada warnumamalya akwa k-enibikini-yada ngayuwa wurrakina-da,” ni-yama Jesus Jekiyiju-wa-da. ");
INSERT INTO aoi_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Aburraja wurrumurndakibina warnumamalya Jekiyija-langwa-manja alikira nuw-engkirrikenu-manja ayakwa Jesus-langwa, na-lyangkiyama wurrakina, “Adinube-ka Neningikarrawara kinu-bungkawadinama nakina enena-manja angalya.” Akine-ka na-lyangkiyamama mena nakina Jesus Jirujalema-manja akwudangwa n-ambilyu-mubaba arakba. ");
INSERT INTO aoi_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Kembirra nenu-makama arakba nakina Jesus enena alawudawarra aburruwa-wa. Nuwilyaba naruma nenungkwarba n-ambilyumurra nakina. Neniki-liki-yada engku-wa eminingku-wa angalya kajungwa nakina nubungkawa naruma-dangwa neningakwujina kenu-bungkawakini-yada nakina nenungkwarba nubungkawa wurrababurna-manja warnumamalya ena-langwa-manja angalya. Kembirra yadikina neniki-lawurrada nakina ena-langwu-wa angalya naruma arakba nubungkawa. ");
INSERT INTO aoi_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Akena nara-wiya kini-likena nakina engku-wa, nen-ardijuwama lukwuniyawa ena-langwa wurrumemberrkwa warnikuminuwar•duwar•da enuwa-wa. Biya nenu-kwama angwarnda aburruwa-wa wurruwilyuwilyaba-wiya-manja nakina. “Ki-likajama ningena,” ni-yama nakina aburruwa-wa. “Nara-wiya ningibina, yikuminu-war•denama enena warka nganyangwa. Yikumin-arumurrkinama ngawa enena angwarnda nganyangwa. Kembirra akine-ka angwarnda nganyangwa kuw-arumidinama ngawa ki-lawurradina-manja ngayuwa yangkwurrangwa,” ni-yama nakina nenungkwarba ena-langwu-wa warnikuminuwar•duwar•da. Biya ni-likena nakina arakba-da. ");
INSERT INTO aoi_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Akena aburraja wurruminibina angalya warnumamalya nenu-wirrikbama angwurra nakina-manja nenungkwarba. Kembirra narra-larrkenuma wurrukwala warnungkwarba arakba nibinu-wa nubungkawa naruma. Aburraja na-likena wurrakina biya ne-yama enuwa-wa, “Yarne-ka yirrababurna-langwa yarnumamalya yirru-warenama nakina nenungkwarba, nara a-bungkawaduma nakina yirruwa-manja yirrababurna-manja,” ne-yama. ");
INSERT INTO aoi_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Akena eneja nubungkawa naruma-dangwa nara kenumin-engkirrikena akina ayakwa aburra-langwa. Aburraja kembirra na-lawurradina arakba yadikina angalyu-wa wurrakina-da. Bi...ya arakba-langwa enejukwaba ni-lawurradina nakina angalyu-wa nenungkwarba, nibina-murrada nenu-kwa-murrada angwarnda ena-langwa-manja warnikuminuwar•duwar•da. Narume-ka nubungkawa arakba nakina wurrababurna-manja wurruminibina-langwa-manja angalya warnumamalya. Biya kembirra nen-ardijuwa nakina wurrumurndakibina warnikuminuwar•duwar•da ena-langwa wurruwilyuwilyaba-wiya enuwa-wa, ni-ngayindangu-mubaba ayakwa ebina-langwa angwarnda. ");
INSERT INTO aoi_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Eneja kembirra neningadinuba-wiya ni-likena nenikuminuwar•duwar•da enuwa-wa. “Bungkawa,” ni-yama, “yu-kwama awilyaba-ma ngawa angwarnda nara-wiya ki-likena nungkuwa engku-wa, umba ememberrkwa arakba amurndakakenena aduwaba-da,” ni-yama nakina. ");
INSERT INTO aoi_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Eneja kembirra ni-yama nakina nubungkawa enuwa-wa, “Wa! Eningabe-ka! Eningaba warka yiminu-war•danguma, kirrinjeya! Kembirra yiba-kwunama aruma warka mena yirra-werrungwur•dangu-mubaba ngayuwa eyukwujiya-langwa warka yiminu-war•dangu-mulangwa nganyangwa. Ku-bungkawadinama arakba ningkakina ememberrkwa-manja angalya aminababurna-manja alikira iya warnumamalya,” ni-yama nakina nubungkawa ena-langwu-wa nenikuminuwar•duwar•da. ");
INSERT INTO aoi_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Kembirra ngarningka ningka-langwa enejukwaba ni-likena nenikuminuwar•duwar•da enuwa-wa. “Bungkawa,” ni-yama, “ebina-wiya yu-kwama ngayuwa-manja awilyaba angwarnda, umba amangbala arakba amurndakenena nungkwa-langwa aduwaba-da,” ni-yama. ");
INSERT INTO aoi_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Kembirra ni-yama eneja nakina nubungkawa enuwa-wa, “Kembirra ku-bungkawadinama arakba ningkakina amangbala-manja angalya aminababurna-manja alikira iya warnumamalya,” ni-yama. ");
INSERT INTO aoi_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Kembirra ngarningka ngawa ningka-langwa nenikuminuwar•duwar•da ni-likena enejukwaba enuwa-wa. “Bungkawa,” ni-yama, “wiya, ena arakba angwarnda nungkwa-langwa yu-kwa-murrada ebina. Ebina-wiya ning-abuwarrkama ngayuwa dumbala-ma. ");
INSERT INTO aoi_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Ning-akbar•duma nungkuwa-langwa, ningeningma-baba ngayuwa ningkilyangkarnyerra-baba ningkakina ningkenumamalya. Ningku-mumenama ebina aburra-langwa akwa ningk-arrangbinama ebina amaninga narri-lungkuwabijuwamurra wurrukwala-langwa warnumamalya. Akina-langwa kembirra yirraminu-wilyakama ena angwarnda nungkwa-langwa engkinyungwurra ngawa-da,” ni-yama nakina nenikuminuwar•duwar•da ena-langwu-wa nubungkawa-da. ");
INSERT INTO aoi_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Kembirra eneja ni-yama arakba nakina nubungkawa enuwa-wa, “Ningkuwurrariye-ka ningkakina. Yirr-arndirrename-ka ningkakina warka-langwa. Ngayuwa yiba-lekbajama ningkakina amurndakakina-murra ayakwa ningki-yengbinu-mulangwa ningkabakiya-ba. Ningki-yamama dangba nungkuwa ngayuwa-wa, ‘Ningkeningma nungkuwa ningilyangkarnyerra ningubungkawa ningena, ningibina ningu-mumenama ebina aburra-langwa akwa ning-arrangbinama amaninga aburra-langwa,’ ningki-yamama ningkakina ngayuwa-wa. ");
INSERT INTO aoi_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Kembirra miyambena-burra nara ka-kwa ena angwarnda nganyangwa wurrukwalu-wa warnungkwarba na-war•duwar•dena-murruwa warka angwarnda-manja? Ka-kwa-manja nungkuwa ebina-wiya nganyangwa angwarnda aburruwa-wa, kemba ku-manguma ngayuwa aduwaba ebina-murrada angwarnda akwa ngawa akwala ngarningka ngayuwa-da,” ni-yama nakina nubungkawa ena-langwu-wa nenikuminuwar•duwar•da-da. ");
INSERT INTO aoi_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Biya kembirra nenu-maka nakina wurrukwala-manja warnikuminuwar•duwar•da, “Wunu-murrakajiya arakba akina angwarnda, umba yikinu-kwuna akina nibinu-wa nu-wilyakina-murruwa ememberrkwa angwarnda nakina,” ni-yama nakina nubungkawa-da. ");
INSERT INTO aoi_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Aburraja ne-yama, “A•a! Ememberrkwa arakba akina ena-langwa-da!” ne-yama wurrakina. ");
INSERT INTO aoi_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Eneja kembirra ni-yama nakina nubungkawa aburruwa-wa, “Mama akina-da. Umba kinu-kwuna-manja ngayuwa nuwilyaba nenumamalya eyukwujiya warka nganyangwa, akwa kenuminu-war•dena-manja nakina eningaba warka akwa kin-aburrakijerrukwuna-manja akina, kembirra ngayuwa kinu-kwunama aruma warka ngarningka enuwa-wa. Umba kinu-kwuna-manja ngayuwa nuwilyaba nenumamalya eyukwujiya warka nganyangwa akena nara-manja a-jerrukwama akina, kembirra kinu-makinama ngayuwa nakina-manja kini-lalikina-mulangwa nakina arakba akina warka. Kembirra ngayuwa kinu-kwunama ebina-murrada warka ningku-wa nenungkwarba kajungwa nenikuminu-war•di-yada nganyangwa akina warka enamba-langwa-da. ");
INSERT INTO aoi_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","“Wurribina-murrada warnumamalya bumurndaku-wirrikba-murrada ngayuwa-wa, akwa namurndaku-warangu-murrada ngayuwa aburra-langwi-yada ningubungkawa, yika-wilyakinama wurrakina yangkwurrangwa ngayuwa-wa. Akwa yika-wardenama kirrakina yelakwa kajungwa ka-rringkini-yada ngayuwa ka-jungwuna-manja wurrakina,” ni-yama nakina nubungkawa-da. Ena ngawa-da. Ni-jerrukwa-mulangwa akina Jesus alawudawarra, kembirra ni-jadinga nakina Jekiyija-langwa-langwa alikira akwa ni-lalika arakba ebina angalya Jerika-da. ");
INSERT INTO aoi_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Biya ni-likena arakba Jesus num-aburrakiyuwarna ngawa mibina mamurukwa numu-wurdanguma Jirujalemu-wa, aburruwa warnikabuburrakiyuwa ena-langwa. ");
INSERT INTO aoi_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Bi...ya nuw-akwudangwudina ngalaja ambilyuma arakba angalya eyukwujiya-kiya emikirra Bebaja akwa Bediniya. Alakina-kiya nuw-ambilyuma angakarjiyinga-manja narri-lungkuwabijuwa-murrumanja eninganinga eka emikirra aliba. Aminakina-langwa emikirra angalya Alibumanja akina. ");
INSERT INTO aoi_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Biya ni-yama Jesus wunalakina-kiya-wa ena-langwa wunenikaburrakiyuwa, “Jeyi!” ni-yama. “Wuni-likaja amurndakangaba-wa alikira. Yakwujina kinalakina yikining-akburranginama diyukwujiya dangki dadinungkwarba. Nara ambaka warnumamalya ka-wurdanga-langwa ngala-langwa-manja mirirrba. Ying-ararikajungwunama dakina akena yikining-aburawakina dakina akwa yikininga-wilyakina yangkwurrangwa ngayuwa-wa. ");
INSERT INTO aoi_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Umba wurruminakina angalya warnumamalya yikabi-yengkilabaja-manja wurrakina, ‘Miyambena-burra kinalakena kining-aburawakinama dakina?’ kembirra yikini-yamina aburruwa-wa, ‘Nubungkawe-ka nanga-ngayinduma daka dangki,’ yikini-yamina kinalakina,” ni-yama Jesus wunalakina-kiya-wa. ");
INSERT INTO aoi_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Kembirra aburnaja neni-likena arakba wunalakina akwa nening-akburranga dibina dangki ebina-langwiya ayakwa ni-yengbinu-mulangwiya Jesus. ");
INSERT INTO aoi_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Nening-aburawaka-manja dakina dangki wunalakina wunenungkwarba-kiya, aburraja ne-yama wurruminakina dangki wunalakina-kiya-wa, “Miyambena-burra kinalakina kining-enjungwurrenama dakina dangki yirra-langwa?” ne-yama. ");
INSERT INTO aoi_vpl VALUES ("LK19_34","072_19_34","LUK","19","