﻿USE sofia;
DROP TABLE IF EXISTS sofia.any_vpl;
CREATE TABLE any_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES any_vpl WRITE;
INSERT INTO any_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Ɛ 'nwun Zozi Kilisi anan-mɔ dunman'n, ɔ bɔ yɩ́ bʋ *Abalahamʋn ɛlɔ dede ɔ sɩn belemgbin *Davidi ɛlɔ nán ɔ'a tʋ Zozi. ");
INSERT INTO any_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abalahamʋn wʋlɩ Izakɩ, nán Izakɩ a wʋ Zʋakɔbʋ, Zʋakɔbʋ a wʋ Zuda nʋn yɩ́ nianman'n-mɔ, ");
INSERT INTO any_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Zuda a wʋ Falɛsɩ nʋn Zala. Bɛ́ nin y'ɔ le Tamaa. Falɛsɩ a wʋ Ɛsɩlɔmʋn, Ɛsɩlɔmʋn a wʋ Alamʋn, ");
INSERT INTO any_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Alamʋn a wʋ Aminnandabʋ, Aminnandabʋ a wʋ Naasʋn, Naasʋn a wʋ Salɩmʋn, ");
INSERT INTO any_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salɩmʋn a wʋ Boozɩ. Yɩ́ nin y'ɔ le Lahabʋ. Boozɩ a wʋ Obɛdɩ. Yɩ́ nin y'ɔ le Lutʋ. Obɛdɩ a wʋ Zese, ");
INSERT INTO any_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Zese a wʋ Davidi, Davidi a wʋ Salomʋn. Yɩ́ nin'n tɩ Uli ayɩ daba. ");
INSERT INTO any_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salomʋn a wʋ Oloboamʋn, Oloboamʋn a wʋ Abia, Abia a wʋ Asafʋ, ");
INSERT INTO any_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asafʋ a wʋ Zozafatɩ, Zozafatɩ a wʋ Zolamʋn, Zolamʋn a wʋ Oziasɩ, ");
INSERT INTO any_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Oziasɩ a wʋ Zoatamʋn, Zoatamʋn a wʋ Akazɩ, Akazɩ a wʋ Ezekiazɩ, ");
INSERT INTO any_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ezekiazɩ a wʋ Manase, Manase a wʋ Amʋn, Amʋn a wʋ Zoziasɩ, ");
INSERT INTO any_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Zoziasɩ a wʋ Zekonia nʋn yɩ́ nianman'n-mɔ. Mɛlɛ sɔ nɩn anun yɛ̂ bɛ hyɩlɩ Izalayɛ amma'n-mɔ hɔlɩ Babilɔnʋn ɔ. ");
INSERT INTO any_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Mɔ bɛ hɔlɩ Babilɔnʋn'n, nán Zekonia a wʋ Salatiɛ, Salatiɛ a wʋ Zolobabɛlɩ, ");
INSERT INTO any_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zolobabɛlɩ a wʋ Abiwudi, Abiwudi a wʋ Eliakimʋn, Eliakimʋn a wʋ Azɔɔ, ");
INSERT INTO any_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azɔɔ a wʋ Sadɔkɩ, Sadɔkɩ a wʋ Akimʋn, Akimʋn a wʋ Eliwudɩ, ");
INSERT INTO any_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliwudɩ a wʋ Eleazaa, Eleazaa a wʋ Matan, Matan a wʋ Zʋakɔbʋ, ");
INSERT INTO any_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Zʋakɔbʋ a wʋ Zozɛfʋ. Yɩ́ yɩ y'ɔ le Mali. Mali sɔ'n, yɩ́ yɛ̂ ɔ wʋlɩ Zozi mɔ bɛ fɛlɛ yɩ́ *Kilisi nɩn ɔ. ");
INSERT INTO any_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Kɛ ɔ fi Abalahamʋn bɛlɛ sʋ dede m'ɔ kɔ ju Davidi bɛlɛ sʋ'n, bɛ tɩ sɩɛ bulu nʋn nnan, yɛ̂ ɔ fi Davidi bɛlɛ sʋ dede m'ɔ kɔ ju mɛlɛ mɔ bɛ hyɩlɩ Izalayɛ amma'n-mɔ bɛ hɔlɩ Babilɔnʋn'n, bɛ tɩ sɩɛ bulu nʋn nnan biekun, ɛsɛ dede m'ɔ kɔ ju Kilisi nɩn awɔlɛ'n, bɛ tɩ sɩɛ bulu nʋn nnan. ");
INSERT INTO any_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Ɛ 'nwun kɛ ɔ kpɩnlɩn yɔlɩ mɔ bɛ wʋlɩ Zozi Kilisi'n. Anɩn Mali m'ɔ tɩ yɩ́ nin'n, ɔ nʋn Zozɛfʋ b'a ja bɛ́ nwʋn. Nan asannan nán Zozɛfʋ a fa Mali atɔnvɔlɛ'n, Wawɛ Nwannzan-nwannzan'n tunmin'n kɔ man Mali kɔ nwʋnnzɛ. ");
INSERT INTO any_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Zozɛfʋ m'ɔ tɩ yɩ́ hun'n tɩ sʋanlan sɛsɛ. Yɛ̂ kɛmɔ ɔ ngulo man kɛ ɔ bɔ Mali anwʋn ɛjɔlɛ ɔ kele menian'n-mɔ, ɔ fualɩ kɛ ɔ nʋn yɩ́ bɛ 'tɩtɩ nvɩalɩɛ nun. ");
INSERT INTO any_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Kɛmɔ anɩn ajʋnlɩn sɔ'n wɔ yɩ́ ti anun'n, yɛ́ Mɩn bɔfʋɛ'n kʋn kɔ a kɔ hɩn yɩ́ ɛlalɩɛ. Yɩ́ nwan: “Belemgbin *Davidi anʋnman Zozɛfʋ, n'ɛ hyʋhyʋɩn wɔ́ bʋ asɩ, fa Mali sie wɔ́ nwʋn kɛ wɔ́ yɩ. Ɔ sanlɩn kɛ baa'n m'ɔ lɛ nwʋnnzɛ yɩ́'n fi Wawɛ Nwannzan-nwannzan'n. ");
INSERT INTO any_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Ɔ 'ba wʋ baa belenzua kʋn. Baa sɔ'n, ɛ 'ba tʋn yɩ́ Zozi, yɩ́ dein yɛ̂ ɔ 'ba le yɩ́ menian'n-mɔ fi bɛ́ ɛtɛ nɩn anun ɔ.” ");
INSERT INTO any_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Ɛhɩ kʋalaatin walɩ maan ɛjɔlɛ'n mɔ yɛ́ Mɩn manlɩn yɩ́ kpɔmanfʋɛ'n hanlɩn'n kpɩnlɩn sʋ. Yɩ́ nwan: ");
INSERT INTO any_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Nɩan, talua muan'n 'ba nwʋnnzɛ, ɔ 'ba wʋ baa belenzua kʋn. Baa sɔ'n, bɛ 'ba fɛlɛ yɩ́ Emannuɛ. (Emannuɛ, yɩ́ bʋ y'ɔ le kɛ Nyanmɩan nʋn yɛ́ tɩ.) ");
INSERT INTO any_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Mɔ Zozɛfʋ fi nafɛlɛ nɩn anun tinngelɩ'n, ɔ yɔlɩ like'n mɔ yɛ́ Mɩn bɔfʋɛ'n helelɩ yɩ́'n. Ɔ sɔlɩ Mali nun ɔ falɩ yɩ́ kacili yɩ́ yɩ. ");
INSERT INTO any_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Nan kʋsʋ ɔ nʋn yɩ́ b'a nna man dede Mali wʋlɩ yɩ́ wa belenzua'n nán ɔ'a tʋn yɩ́ Zozi. ");
INSERT INTO any_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Bɛ wʋlɩ Zozi Zude mân nɩn anun kulo'n mɔ bɛ fɛlɛ yɩ́ Betelehɛmʋn nɩn asʋ. Mɛlɛ sɔ'n, anɩn belemgbin *Elɔdɩ y'ɔ sie Zude mân nɩn ɔ. Mɔ bɛ wʋlɩ Zozi'n, ngɛlɛfʋɛ'n-mɔ mɔ bɛ nɩan nzalama'n, bɛ fi lɩka mɔ sɛnzɛ'n fite'n, bɛ walɩ Zoluzalɛmʋn ɛbɛlɛ. ");
INSERT INTO any_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Mɔ bɛ juli ɛbɛlɛ'n, nán b'a bisa menian'n-mɔ kɛ: “Zufʋ'n-mɔ belemgbin'n mɔ b'a wʋ yɩ́'n, ɔ wɔ nin? Y'a nwun yɩ́ nzalama'n sɛnzɛ afitelɩɛ ɛlɔ, yɛ walɩ kɛ yɛ 'ba a sʋ yɩ́.” ");
INSERT INTO any_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Mɔ belemgbin Elɔdɩ ɔ nʋn Zoluzalɛmʋn kulo nɩn asʋ menian'n-mɔ kʋalaa tɩlɩ ɛjɔlɛ sɔ'n, bɛ́ nwʋn wʋsʋlɩ bɛ́. ");
INSERT INTO any_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Belemgbin Elɔdɩ kɔ yia Nyanmɩan *tɛɛyɩfʋɛ mgbain'n-mɔ kʋalaatin, ɔ nʋn *mala nɩn asʋ mgbain'n-mɔ nán ɔ'a bisa bɛ́ lɩka m'ɔ sɛ kɛ bɛ wʋ *Kilisi'n. ");
INSERT INTO any_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Bɛ́ nwan: “Ɔ sɛ kɛ bɛ wʋ yɩ́ Betelehɛmʋn, Zude mân nɩn anun. Ɔ sanlɩn kɛ ɛjɔlɛ mɔ Nyanmɩan kpɔmanfʋɛ'n hɛlɛlɩ'n y'ɔ le kɛ: ");
INSERT INTO any_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Ɛmɔ Betelehɛmʋn amma mɔ ɛmɔ wɔ Zude mân nɩn anun'n, ɛmɔ kulo'n tɩ man kulo kaan wɔ Zude kulo mgbili'n-mɔ afian. Ɔ sanlɩn kɛ bɛ 'ba wʋ sʋanlan kʋn bɛ tʋ ɛmɔ anun. Sʋanlan sɔ'n yɛ̂ ɔ 'ba nɩan Izalayɛ amma'n-mɔ mɔ bɛ tɩ mɩ́n dɩɛ nɩn asʋ kɛ bʋa ɛnɩanfʋɛ nɩan yɩ́ mmʋa'n-mɔ asʋ'n.” ");
INSERT INTO any_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Mɔ belemgbin Elɔdɩ tɩlɩ ɛjɔlɛ sɔ'n, ɔ kɔ fɛlɛ ngɛlɛfʋɛ'n-mɔ nvɩalɩɛ nun ɔ kɔ bisa bɛ́ mɛlɛ kpa bɔkɔɔ mɔ nzalama'n fitelɩ'n. ");
INSERT INTO any_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Ɛhɩ anzin, ɔ kɔ sʋan bɛ́ Betelehɛmʋn ɛlɔ, yɩ́ nwan: “Ɛmɔ hɔ́ Betelehɛmʋn ɛlɔ, nán bɛ hɔ́ kpʋ́nndɛ batʋnman sɔ'n kpa. Sɛ ɛmɔ nwun yɩ́ a, bɛ mán mɩ́n nzʋ tɩ́, maan mɩ́n kʋsʋ n gɔ́ n zʋ́ yɩ́ bie.” ");
INSERT INTO any_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Mɔ belemgbin Elɔdɩ hanlɩn sɔ helelɩ bɛ́ yuelɩ'n yɛ̂ bɛ hɔlɩ ɔ. Mɔ bɛ 'kɔ'n, bɛ 'nɩan an, anɩn nzalama'n mɔ bɛ nwunlin yɩ́ sɛnzɛ afitelɩɛ ɛlɔ'n li bɛ́ nyunnun. Ɔ li bɛ́ nyunnun dede m'ɔ juli sua'n mɔ batʋnman kaan'n wɔ nun nɩn ati sʋ'n, ɔ kɔ jinlan. ");
INSERT INTO any_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Nzalama sɔ'n mɔ bɛ nwunlin yɩ́'n man bɛ kɔ li fɛ kpili kpa. ");
INSERT INTO any_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Bɛ kɔ wʋlʋ sua nɩn anun bɛ kɔ nwun batʋnman'n ɔ nʋn yɩ́ nin Mali. Bɛ kɔ kʋtʋ bɛ kɔ sʋ batʋnman'n. Mɔ bɛ sʋlɩ yɩ́ yuelɩ'n, bɛ kɔ tutulu bɛ́ bɔ́lɛ'n-mɔ anun. Bɛ kɔ fa ninnge nsan mɔ yɩ́ nwʋn cian kpa'n bɛ kɔ fi yɩ́ ata. Kʋn tɩ esika ɛmanlan. Kʋn tɩ *ansan mɔ bɛ yala yɩ́ a, ɔ ban fanlan. Yɛ̂ kʋn kʋsʋ tɩ minli mɔ bɛ fa bɛ yɔ ayile anaan anatɩlɩ. ");
INSERT INTO any_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Ɛhɩ anzin, Nyanmɩan kɔ hɩn bɛ́ ɛlalɩɛ kɛ nán bɛ sa bɛ́ nzin bɛ sɩn belemgbin Elɔdɩ anwʋn ɛlɔ kʋ́n. Ɔ man bɛ sɩnlɩn lɩka fʋfɔlɛ bɛ hɔlɩ bɛ́ kulo. ");
INSERT INTO any_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Mɔ ngɛlɛfʋɛ'n-mɔ hɔlɩ'n, yɛ́ Mɩn bɔfʋɛ'n kʋn kɔ a kɔ hɩn Zozɛfʋ ɛlalɩɛ, yɩ́ nwan: “Zozɛfʋ, jasʋ fa batʋnman'n nʋn yɩ́ nin nwanndi kɔ tanlan Ezipiti mân nɩn anun ɛlɔ. Sɛ n ganlɩn n gelelɩ man wɔ́ kɛ ɛ sá bála a, n'ɛ ba. Ɔ sanlɩn kɛ, belemgbin Elɔdɩ 'kpʋnndɛ kɛ ɔ kun batʋnman'n.” ");
INSERT INTO any_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Kɔngɔɛ sɔ nɩn ala, Zozɛfʋ kɔ fa batʋnman'n nʋn yɩ́ nin, bɛ kɔ nwanndi bɛ kɔ hɔ Ezipiti. ");
INSERT INTO any_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Bɛ wɔ ɛlɔ dede belemgbin Elɔdɩ wuli nán b'a sa b'a a. Yɩ́ sɔ'n, ɛjɔlɛ'n mɔ Nyanmɩan manlɩn kpɔmanfʋɛ'n hanlɩn yɩ́ daba nɩn a kpɩn sʋ. Yɩ́ nwan: M'an han m'an hele mɩ́n wa'n kɛ ɔ fi Ezipiti ɔ jásʋ. ");
INSERT INTO any_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Mɔ belemgbin Elɔdɩ nwunlin kɛ ngɛlɛfʋɛ'n-mɔ a laka yɩ́'n, ɔ fɛlɩ ɛya kpa. Ɔ tɩtɩlɩ cɩan'n mɔ ngɛlɛfʋɛ'n-mɔ nwunlin nzalama'n dede a, anɩn ɔ'a nwun kɛ batʋnman'n ka kaan di afʋɛ nnyuan. Yɩ́ ti, ɔ kɔ sʋan yɩ́ nzalafʋ'n-mɔ Betelehɛmʋn nʋn kulo'n-mɔ kʋalaa mɔ bɛ mantan mantan yɩ́'n-mɔ asʋ kɛ bɛ hɔ́ hún mmatʋnman mmelenzua mɔ b'a li afʋɛ nnyuan'n, ɔ nʋn bɛ́ mɔ bɛ lili man afʋɛ nnyuan'n kʋalaatin. ");
INSERT INTO any_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Kɛ ɔ yɔlɩ mɔ Nyanmɩan kpɔmanfʋɛ Zolomin ɛjɔlɛ'n m'ɔ hanlɩn'n kpɩnlɩn sʋ nɩn anɩn. Yɩ́ nwan: ");
INSERT INTO any_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Bɛ tɩlɩ ɛtɩan nʋn esuan nʋn awɔ́lɛ mgbili Lama kulo nɩn asʋ. Lasɛɛ yɛ̂ anɩn ɔ lɛ sun yɩ́ mma'n-mɔ ɔ. Ɔ ngulo man kɛ bɛ kpata yɩ́, ɔ sanlɩn kɛ yɩ́ mma'n-mɔ a wu. ");
INSERT INTO any_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Mɔ belemgbin Elɔdɩ wuli'n, yɛ́ Mɩn bɔfʋɛ'n kʋn walɩ hɩnlɩn Zozɛfʋ ɛlalɩɛ Ezipiti mân nun. ");
INSERT INTO any_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Yɩ́ nwan: “Zozɛfʋ, jasʋ fa batʋnman'n nʋn yɩ́ nin sa kɔ Izalayɛ mân nɩn anun. Ɔ sanlɩn kɛ, bɛ́ mɔ anɩn bɛ lɛ kpʋnndɛ batʋnman'n bɛ kun yɩ́'n, b'a yue wu.” ");
INSERT INTO any_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Ɛhɩ a, Zozɛfʋ kɔ jasʋ ɔ kɔ fa batʋnman'n nʋn yɩ́ nin, bɛ kɔ sa kɔ hɔ Izalayɛ mân nɩn anun. ");
INSERT INTO any_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Mɔ Zozɛfʋ juli ɛbɛlɛ m'ɔ tɩlɩ kɛ Aakelawusi a li yɩ́ sɩ Elɔdɩ aja ɔ'a kaci Zude belemgbin'n, ɔ sulolɩ ɛbɛlɛ lɩka sɔ nɩn anun ɛtanlan. Ɛlalɩɛ nun, mɔ Nyanmɩan helelɩ yɩ́ atɩn m'ɔ di kɛ ɔ sɩn sʋ'n, Zozɛfʋ bɔlɩ yɩ́ ti Galile mân nɩn anun. ");
INSERT INTO any_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","M'ɔ hɔlɩ juli ɛlɔ'n, ɔ tanlanlɩn kulo'n mɔ bɛ fɛlɛ yɩ́ Nazalɛtɩ nɩn asʋ. Ɔ man ɛjɔlɛ'n mɔ Nyanmɩan mgbɔmanfʋɛ'n-mɔ hanlɩn nɩn a kpɩn sʋ. Bɛ́ nwan: Bɛ 'ba fɛlɛ yɩ́ Nazalɛtɩ sʋanlan. ");
INSERT INTO any_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Mɛlɛ sɔ nɩn anun, sʋanlan kʋn kɔ fite Zude mân nɩn anun ɛwâ nɩn anun. Sʋanlan sɔ'n, bɛ fɛlɛ yɩ́ *Zʋan Batisi. Ɔ kan Nyanmɩan Anʋan Ɛjɔlɛ'n ɔ kele menian'n-mɔ. ");
INSERT INTO any_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Ɔ kan kɛ: “Ɛmɔ nún bɛ́ nwʋn bɛ yáci bɛ́ abalabɔ ɛtɛ'n. Ɔ sanlɩn kɛ Anwunno Belemgbin elie mɛlɛ nɩn a kpunnge.” ");
INSERT INTO any_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Zʋan sɔ'n yɛ̂ Nyanmɩan kpɔmanfʋɛ *Ezayi hanlɩn yɩ́ ɛjɔlɛ daba kɛ: Sʋanlan bie lɛ tɩan ɛwâ nɩn anun ɛlɔ kɛ: Ɛmɔ sésie yɛ́ Mɩn atɩn'n, bɛ mán ɔ tɩ́nngɛ fɔ́ʋ́n! ");
INSERT INTO any_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Zʋan taladɩɛ'n m'ɔ wula'n, bɛ le sʋamo enyuan yɛ̂ b'a nwʋn ɔ, yɛ̂ naan kpolo bɛlɛtɩ hyɩ yɩ́ afian. Tɛtɛbʋabʋa nʋn wɛ yɛ̂ ɔ di ɔ. ");
INSERT INTO any_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Zoluzalɛmʋn menian nʋn Zude mân nɩn anun menian, ɔ nʋn bɛ́ mɔ bɛ́ kulo'n-mɔ mantan asue Zuludɩn'n, bɛ ba Zʋan anwʋn ɛbɛlɛ. ");
INSERT INTO any_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Bɛ kan bɛ́ ɛtɛ'n kʋalaa menian'n-mɔ anyunnun bɛ man Zʋan sɔnɩn bɛ́ asue Zuludɩn nɩn anun. ");
INSERT INTO any_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Mɔ Zʋan nwunlin kɛ *Falisifʋɛ nʋn *Sadusifʋɛ'n-mɔ dɔʋn lɛ ba maan ɔ sɔnɩn bɛ́'n, yɩ́ nwan: “Ati anun ɛtɛ mma kɛ owo! Nwan yɛ̂ ɔ selɩ ɛmɔ kɛ ɛsɔnɩan nɩn ala kʋala kɛ ɔ de bɛ́ fi Nyanmɩan sikpɛ nɩn anwʋn ɔ? ");
INSERT INTO any_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Yɩ́ ti, ɛmɔ yɔ́ nyɔlɩɛ m'ɔ kele kɛ ɛmɔ a kaci bɛ́ abalabɔ ɛtɛ'n b'a fa bɛ́ nwʋn b'a man Nyanmɩan. ");
INSERT INTO any_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Nan nán bɛ se bɛ́ nwʋn kɛ: ‘Yɛ́ sɩ y'ɔ le *Abalahamʋn, yɩ́ ti Nyanmɩan ngʋala man yɛ́ like fɩ́ɩ́ yɔ.’ Afɩ mɩɩn kan mɩn kele ɛmɔ kɛ Nyanmɩan kʋala kɛ ɔ fa nyɔbʋɛ ɛhɩ-mɔ kaci Abalahamʋn amma. ");
INSERT INTO any_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","B'a si akunman nɩn a yue. Baka biala m'ɔ nzu man mma kpa'n, bɛ 'kpɛ bɛ tʋ sɩ̂n nɩn anun. ");
INSERT INTO any_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“Mɩ́n dɩɛ, mɩɩn fa nzue mɩn sɔnɩn ɛmɔ m'ɔ kele kɛ ɛmɔ a kaci bɛ́ abalabɔ'n. Nan sʋanlan'n m'ɔ fi mɩ́n nzin ɔ lɛ ba'n, ɔ le tunmin tala mɩ́n. Mɩn nzɛ nvata man kɛ mɩn nyannjɩ yɩ́ ja mgbabʋa nyanman'n bɔbɔ mgban ɔ. Yɩ́ dɩɛ, ɔ 'ba fa Wawɛ Nwannzan-nwannzan'n nʋn sɩ̂n ɔ sɔnɩn ɛmɔ. ");
INSERT INTO any_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Ɔ le yɩ́ huhuamʋa'n yɩ́ sa nun, ɔ 'ba huhu *bele mma kpa'n ɔ fa sie yɩ́ esie nɩn anun, nan ɔ ju ewula'n gua sɩ̂n'n m'ɔ nnun man lé nɩn anun.” ");
INSERT INTO any_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Mɛlɛ sɔ nɩn anun, Zozi fi Galile mân nɩn anun ɔ walɩ asue Zuludɩn nɩn anʋan Zʋan anwʋn ɛbɛlɛ kɛ ɔ sɔ́nɩn yɩ́. ");
INSERT INTO any_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Zʋan a nne a ndʋ man nun, yɩ́ nwan: “Mɩ́n yɛ̂ ɔ fata kɛ m ba wɔ́ nwʋn m man ɛ sɔnɩn mɩ́n ɔ. Nan wɔ́ dɩɛ, wɔ́ lɩlɩ yɛ̂ ɛ lɛ ba maan mɩn sɔnɩn wɔ́ ɔ!” ");
INSERT INTO any_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Mɔ Zʋan anʋan tɔlɩ'n, Zozi nwan: “Dɔɛ mɔ yɛ wɔ nun'n, tie nán sɔnɩn mɩ́n. Ɔ sanlɩn kɛ, ɛbɛlɛ nɩn anun yɛ̂ yɛ 'ba yɔ like m'ɔ tɩ sɛsɛ wɔ Nyanmɩan anyunnun ɔ.” Ɛhɩ a, Zʋan kɔ tie ɔ kɔ sɔnɩn Zozi. ");
INSERT INTO any_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Mɔ Zozi fi asue nɩn anun ɔ 'fite'n, anwunno kɔ buke. Zozi 'nɩan an, anɩn Nyanmɩan Wawɛ'n lɛ ju ɔ ba yɩ́ nwʋn kɛ abubule. ");
INSERT INTO any_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Ɛbɛlɛ ala, anɩɛ kʋn kɔ te anwunno ɛlɔ kɛ: “Sʋanlan ɛhɩ tɩ mɩ́n ehulo Baa, m'an fa mɩ́n lʋa'n kʋalaa m'an wula yɩ́ nun.” ");
INSERT INTO any_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Ɛhɩ anzin, Nyanmɩan Wawɛ'n kɔ fa Zozi asue Zuludɩn nɩn anʋan ɔ nʋn yɩ́ kɔ hɔ ɛwâ nɩn anun. Ɛbɛlɛ, Abɔnsanmʋn kɔ sɔ yɩ́ kɔ nɩan. ");
INSERT INTO any_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Zozi kɔ hyɩ ɛhɔɛ kɔngɔɛ nʋn eyua dede cɩan abulanan. Mɔ cɩan abulanan'n sɩnlɩn'n nán ɛhɔɛ a hun yɩ́. ");
INSERT INTO any_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Abɔnsanmʋn kɔ kpʋ yɩ́. Yɩ́ nwan: “Sɛ Nyanmɩan Awa y'ɔ le wɔ́ sakpa a, anɩn kan kele nyɔbʋɛ ɛhɩ-mɔ maan bɛ káci kpaʋn.” ");
INSERT INTO any_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Mɔ Abɔnsanmʋn hanlɩn sɔ'n, Zozi nwan: “B'a hɛlɛ wɔ Ɛhɛlɛ Ɛjɔlɛ nɩn anun kɛ: Nán kpaʋn ala yɛ̂ sʋanlan di a, ɔ nyan ngʋan ɔ. Nan ɛjɔlɛ biala m'ɔ fi Nyanmɩan anʋan kɔ fite'n, ɔ man sʋanlan nyan ngʋan.” ");
INSERT INTO any_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Ɛhɩ a, Abɔnsanmʋn nʋn yɩ́ kɔ hɔ Zoluzalɛmʋn m'ɔ tɩ kulo nwannzan-nwannzan nɩn asʋ, ɔ kɔ fa yɩ́ kɔ sie Nyanmɩan awulo nɩn anun sua nɩn ati sʋ anwunno. ");
INSERT INTO any_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Yɩ́ nwan: “Sɛ Nyanmɩan Awa y'ɔ le wɔ́ sakpa a, anɩn kulu tɔ asɩ. Afɩ b'a hɛlɛ wɔ Ɛhɛlɛ Ɛjɔlɛ nɩn anun kɛ: Wɔ́ dunman nun, Nyanmɩan 'ba man yɩ́ mmɔfʋɛ'n-mɔ atɩn kɛ bɛ sɔ́ wɔ́ bɛ́ sa nun nán wɔ́ ja a mgbula man ɛbʋɛ.” ");
INSERT INTO any_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Mɔ Abɔnsanmʋn hanlɩn sɔ'n, Zozi nwan: “B'a hɛlɛ wɔ Ɛhɛlɛ Ɛjɔlɛ nɩn anun kɛ: N'ɛ sɔ yɛ́ Mɩn m'ɔ tɩ wɔ́ Nyanmɩan'n nɩan.” ");
INSERT INTO any_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Ɛsɛ Abɔnsanmʋn kɔ fa Zozi kɔ hɔ bʋka kannganlaun kpa kʋn asʋ. Ɔ kɔ yɩ mân nɩn anun mmelemgbin mân'n-mɔ kʋalaa nʋn bɛ́ anunminnyanmʋn'n ɔ kɔ hele yɩ́. ");
INSERT INTO any_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Yɩ́ nwan: “Sɛ ɛ tu tɔ mɩ́n ja nun ɛ sʋ mɩ́n an, mɩn 'fa ɛhɩ kʋalaa mɩn man wɔ́.” ");
INSERT INTO any_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Ɛhɩ a, Zozi nwan: “*Satan, kɔ! Ɔ sanlɩn kɛ b'a hɛlɛ wɔ Ɛhɛlɛ Ɛjɔlɛ nɩn anun kɛ: Yɛ́ Mɩn m'ɔ tɩ wɔ́ Nyanmɩan'n, yɩ́ ngʋnmɩn cein y'ɔ di kɛ ɛ sʋ yɩ́ ɔ.” ");
INSERT INTO any_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Mɔ Zozi hanlɩn ɛhɩ'n, afɩ Abɔnsanmʋn kɔ yaci yɩ́. Nyanmɩansʋ mmɔfʋɛ'n-mɔ kɔ a Zozi anwʋn ɛbɛlɛ, bɛ kɔ bʋka yɩ́. ");
INSERT INTO any_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Ɛhɩ, Zozi 'tie a, b'a tʋ Zʋan fiadɩ. Zozi kɔ hɔ Galile mân nɩn anun ɛlɔ. ");
INSERT INTO any_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Ɔ'a ndanlan man Nazalɛtɩ kulo nɩn asʋ. Nan ɔ hɔlɩ tanlanlɩn kulo'n mɔ bɛ fɛlɛ yɩ́ Kapɛɛnawɔmʋn nɩn asʋ. Kulo sɔ'n wɔ Galile asue nɩn anʋan, Zabulʋn nʋn Nɛfʋtali etin dɩɛ nɩn asʋ. ");
INSERT INTO any_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Ɔ yɔlɩ sɔ maan ɛjɔlɛ'n mɔ Nyanmɩan kpɔmanfʋɛ *Ezayi hanlɩn yɩ́ daba'n kpɩnlɩn sʋ. Yɩ́ nwan: ");
INSERT INTO any_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Zabulʋn nʋn Nɛfʋtali amma nʋn bɛ́ mɔ bɛ wɔ Asue Kpili nɩn anʋan ɛlɔ dede ɔ kɔ ju asue Zuludɩn nɩn anzin ɛlɔ ebue kʋn, ɔ nʋn bɛ́ mɔ bɛ wɔ Galile mân nɩn anun mɔ bɛ́ dɔʋn bɛ tɩ man Zufʋ'n, ");
INSERT INTO any_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","menian sɔ'n-mɔ mɔ bɛ gua awosin nɩn anun'n, bɛ 'ba nwun kanlannɩɛ kpili kpa kʋn! Yɛ̂ m'ɔ tʋ de bɛ́ mɔ bɛ gua ewue mân tuun nɩn anun'n, kanlannɩɛ'n 'ba ta lɩka sɔ'n! ");
INSERT INTO any_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Ɔ fi mɛlɛ sɔ'n yɛ̂ Zozi bɔlɩ Nyanmɩan junman nɩn abʋ ɔ. Yɩ́ nwan: “Ɛmɔ nún bɛ́ nwʋn bɛ yáci bɛ́ abalabɔ ɛtɛ'n. Ɔ sanlɩn kɛ Anwunno Belemgbin elie mɛlɛ nɩn a kpunnge!” ");
INSERT INTO any_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Mɔ Zozi 'sɩn Galile asue nɩn anʋan'n, ɔ kɔ nwun anianman nnyuan. Kʋn li Simʋn, bɛ fɛlɛ yɩ́ biekun Pɩɛlɩ, ɔ nʋn yɩ́ nianman Andele. Anɩn bɛ lɛ gua dada, ɔ sanlɩn kɛ bɛ tɩ asufuɛ. ");
INSERT INTO any_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Zozi kɔ han kɔ hele bɛ́ kɛ: “Ɛmɔ bála bɛ sí mɩ́n sʋ, nán mɩn 'ba man ɛmɔ fɛfɛlɛ menian bɛ man mɩ́n.” ");
INSERT INTO any_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Kɛ Zozi anʋan 'tɔ ala, bɛ kɔ yaci bɛ́ dada'n-mɔ ɛbɛlɛ bɛ kɔ si yɩ́ sʋ. ");
INSERT INTO any_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Zozi fi ɛbɛlɛ ɔ kɔ hɔ yɩ́ nyunnun kaan, ɔ 'tʋ yɩ́ nyɩn an, ɔ kɔ nwun anianman nnyuan mmiekun-mɔ. Bɛ tɩ Zebede amma. Kʋn li Zʋakɩ yɛ̂ kʋn kʋsʋ li Zʋan. Anɩn bɛ nʋn bɛ́ sɩ Zebede bɛ gua ɛlɛɛ nɩn anun, bɛ lɛ kpʋnmgba bɛ́ dada'n-mɔ anun. Zozi kɔ fɛlɛ bɛ́. ");
INSERT INTO any_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Ɛbɛlɛ ala, bɛ kɔ yaci bɛ́ sɩ Zebede nʋn ɛlɛɛ nɩn ɛbɛlɛ bɛ kɔ si Zozi sʋ. ");
INSERT INTO any_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Ɛhɩ, Zozi nanndɩ Galile mân'n lɩka kʋalaatin. Ɔ kekele menian'n-mɔ Nyanmɩan Anʋan Ɛjɔlɛ'n Zufʋ'n-mɔ asɔnɩn sua'n-mɔ anun. Ɔ bɔ Nyanmɩan Belemgbin Mân nɩn anwʋn Ɛjɔlɛkpa'n ɔ kele bɛ́, ɛsɛ menian mɔ ewue ngacile ngacile kʋalaa lɛ kun bɛ́, ɔ nʋn bɛ́ kʋalaa mɔ b'a bubu'n, ɔ man bɛ́ nwʋn sa. ");
INSERT INTO any_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Ɛhɩka ati, Zozi dunman'n kɔ fa Sili mân bɔndɩn'n. Bɛ fa bɛ́ mɔ ewue ngacile ngacile kʋalaa lɛ kun bɛ́'n bɛ bɛlɛ Zozi: bɛ́ mɔ bɛ́ nwʋn fʋfʋ bɛ́ o, bɛ́ mɔ wawɛ ɛtɛ'n-mɔ wɔ bɛ́ nun o, bɛ́ mɔ bɛ tɔ mgbutie o, ɔ nʋn bɛ́ mɔ b'a bubu o, ɔ man bɛ́ kʋalaa bɛ́ nwʋn sa. ");
INSERT INTO any_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Menian dɔʋn kpa si yɩ́ sʋ. Mmie-mɔ fi Galile, mmie-mɔ fi mân'n mɔ bɛ fɛlɛ yɩ́ Kulo Bulu nɩn anun, mmie-mɔ fi Zoluzalɛmʋn kulo nɩn asʋ ɔ nʋn Zude mân nun ɔ nʋn mân'n m'ɔ wɔ asue Zuludɩn nɩn anzin ɛlɔ nɩn anun. ");
INSERT INTO any_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Mɔ Zozi nwunlin meninsʋnman'n, ɔ kɔ fʋ bʋka kʋn asʋ, ɔ kɔ tanlan asɩ. Yɩ́ menian'n-mɔ kɔ kpʋ yɩ́, ");
INSERT INTO any_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","ɔ kɔ hehele bɛ́ Nyanmɩan ninnge. Yɩ́ nwan: ");
INSERT INTO any_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Nyila hán bɛ́ mɔ bɛ sɩ yɩ́ fɔ́ʋ́n kɛ Nyanmɩan anyunnun bɛ tɩ wawɛ nun ehianfʋɛ'n. Ɔ sanlɩn kɛ Anwunno Belemgbin Mân'n tɩ bɛ́ dɩɛ. ");
INSERT INTO any_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","“Nyila hán bɛ́ mɔ bɛ́ lʋa a bɔ bɛ́ nwʋn'n. Ɔ sanlɩn kɛ Nyanmɩan 'ba cɩcɩ bɛ́ lʋa. ");
INSERT INTO any_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","“Nyila hán bɛ́ mɔ bɛ bɛbɛlɛ bɛ́ nwʋn asɩ'n. Ɔ sanlɩn kɛ Nyanmɩan 'ba fa asɩɛ'n sie bɛ́ ajâ. ");
INSERT INTO any_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","“Nyila hán bɛ́ mɔ bɛ yɔ biala bɛ bu mân'n sɛsɛ kɛ Nyanmɩan lɛ kpʋnndɛ yɩ́'n. Ɔ sanlɩn kɛ Nyanmɩan 'ba man bɛ́ yɩ́ nwʋn anwʋnsɛlɛ kpa. ");
INSERT INTO any_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","“Nyila hán bɛ́ mɔ bɛ nwun bɛ́ manngʋn'n-mɔ anwʋn anwunnvoe'n. Ɔ sanlɩn kɛ Nyanmɩan kʋsʋ 'ba nwun bɛ́ nwʋn anwunnvoe. ");
INSERT INTO any_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","“Nyila hán bɛ́ mɔ bɛ fa bɛ́ ahʋnlɩn'n kʋalaa bɛ kulo Nyanmɩan bɛ yɔ like m'ɔ kulo'n. Ɔ sanlɩn kɛ bɛ 'ba nwun Nyanmɩan. ");
INSERT INTO any_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","“Nyila hán bɛ́ mɔ bɛ man bɛ́ manngʋn-mɔ tanlan anzʋnunjɔ nun'n. Ɔ sanlɩn kɛ Nyanmɩan 'ba fa bɛ́ yɔ yɩ́ mma. ");
INSERT INTO any_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","“Nyila hán bɛ́ mɔ bɛ bu mân'n sɛsɛ kɛ Nyanmɩan lɛ kpʋnndɛ'n mɔ yɩ́ ti bɛ lɛ kele bɛ́ yalɛ'n. Ɔ sanlɩn kɛ Anwunno Belemgbin Mân'n tɩ bɛ́ dɩɛ. ");
INSERT INTO any_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Nyila hán ɛmɔ mɔ bɛ tɩ mɩ́n menian'n. Mɛlɛ mɔ menian'n-mɔ 'kpɛ ɛmɔ nzʋba, bɛ kele ɛmɔ ahʋlʋwa ɛsɛ bɛ kpɛ ɛsʋan ngacile biala bɛ tʋ ɛmɔ abʋ'n, ");
INSERT INTO any_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","ɛmɔ lí fɛ, bɛ mán bɛ́ nwʋn tɛ́ bɛ́! Ɔ sanlɩn kɛ nyanmɩansʋ ɛlɔ, ɛmɔ ahatua'n tɩ kpili kpa. Asannan nán b'a wʋ ɛmɔ'n, ahʋlʋwa'n mɔ bɛ helelɩ mgbɔmanfʋɛ'n-mɔ daba'n, yɩ́ kʋnmgba nɩn ala yɛ̂ bɛ 'kele ɛmɔ kʋsʋ ɔ. ");
INSERT INTO any_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Asɩɛ nɩn asʋ ɛwa, ɛmɔ tɩ kɛ njɩn m'ɔ man like nzɛcɩ man ɔ. Nan sɛ njɩn'n ta a, bɛ 'yɔ sɛ nán b'a man ɔ'a yɔ kalʋ-kalʋ biekun? Bɛ ngʋala man yɩ́ like fɩ́ɩ́ kʋ́n yɔ. Asɩ ala yɛ̂ bɛ ju bɛ gua bɛ man menian'n-mɔ tetia sʋ ɔ. ");
INSERT INTO any_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Eyuadɩ nɩn anun, ɛmɔ tɩ kɛ kanlannɩɛ. Kulo mɔ bɛ kɔ si yɩ́ bʋka sʋ'n, kulo sɔ'n, ɔ nvɩa man. ");
INSERT INTO any_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Sɛ bɛ sɔ kanlannɩɛ a, bɛ nva man like bɛ mmutu man sʋ. Nan bɛ sɔ bɛ sie like sʋ anwunno sua nɩn anun maan ɔ ta bɛ́ kʋalaa bɛ nwun asɩ. ");
INSERT INTO any_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Menian'n-mɔ anyunnun, ɔ di kɛ ɛmɔ ta kɛ kanlannɩɛ maan bɛ nwun ɛmɔ nyɔlɩɛ kpa'n nán b'a yɩ ɛmɔ Asɩ m'ɔ wɔ anwunno nɩn ayɛ. ");
INSERT INTO any_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Nán bɛ jʋnlɩn kɛ m'an a *Moyizɩ mala'n nʋn mgbɔmanfʋɛ'n-mɔ ngehele nɩn abʋsʋ enunnuan. Nán yɩ́ enunnuan ati yɛ̂ m malɩ ɔ. Nan m malɩ kɛ mɩn 'ba maan ɔ kpɩn sʋ. ");
INSERT INTO any_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Mɩɩn kan yɩ́ ananhɔlɛ mɩn kele ɛmɔ kɛ mɛlɛ mɔ anwunno nʋn asɩ tɛ wɔ ɛbɛlɛ'n, bɛ mgbɔcɩ man abesede nzɔlɛ'n m'ɔ tɩ kaan tala nzɔlɛ'n-mɔ kʋalaatin m'ɔ wɔ mala nɩn anun'n, anaan nun ɛjɔlɛ kpɔlɛ kaan sʋa bɛ ndʋ man. Ɔ 'ka ɛbɛlɛ sɔ dede ɔ kɔ ju mân nɩn ayuelɩɛ. ");
INSERT INTO any_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Yɩ́ sɔ ati, sʋanlan m'ɔ kɔ tʋn mala'n nunhan m'ɔ tɩ kaan ɔ tala bɛ́ kʋalaa'n, nán sɛ ɔ kele menian'n-mɔ kɛ bɛ nɩ́an yɩ́ dɩɛ nɩn asʋ bɛ yɔ́ bie a, sʋanlan sɔ'n, ɔ 'kaci kaan ɔ tala Anwunno Belemgbin Mân nɩn anun menian'n-mɔ kʋalaatin. Sʋanlan kʋsʋ m'ɔ di mala nɩn asʋ, mɔ ɛsɛ ɔ kele menian'n-mɔ maan bɛ di sʋ'n, sʋanlan sɔ'n, ɔ 'kaci sʋanlan kpili wɔ Anwunno Belemgbin Mân nɩn anun. ");
INSERT INTO any_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Mɩɩn kan mɩn kele ɛmɔ kɛ, sɛ ɛmɔ a mmɔ man bala kpa m'ɔ sɔ Nyanmɩan anyɩn b'a ndala man *mala nɩn asʋ mgbain'n-mɔ nʋn *Falisifʋɛ'n-mɔ a, Nyanmɩan ngɔ man man ɛmɔ atɩn maan bɛ ngɔ wʋlʋ man yɩ́ mân nɩn anun ɛlɔ. ");
INSERT INTO any_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Ɛmɔ tɩlɩ kɛ bɛ hanlɩn bɛ helelɩ ɛmɔ anan-mɔ kɛ: Ɛ ngɔ li man awue, yɩ́ ti, sʋanlan m'ɔ kɔ li awue'n, bɛ sánman yɩ́ bɛ mán kpain'n m'ɔ di ɛjɔlɛ'n. ");
INSERT INTO any_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Nan mɩ́n dɩɛ, mɩ́n nwan: Sʋanlan m'ɔ kɔ fɛ yɩ́ manngʋn anwʋn ɛya'n, ɔ fata nzanman. M'ɔ kɔ se yɩ́ manngʋn kɛ: ‘Laka!’ (Ɔ tɩ *ebele anɩɛ, yɩ́ bʋ y'ɔ le ‘ati to’), sʋanlan sɔ'n, ɔ fata ahɩnlɩnnvie. Yɛ̂ sʋanlan m'ɔ kɔ se yɩ́ manngʋn kɛ: ‘Sɛnvʋɛ!’, yɩ́ kʋsʋ ɔ fata kɛ bɛ tʋ yɩ́ sɩ̂n'n m'ɔ le man ayuelɩɛ nɩn anun. ");
INSERT INTO any_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","“Yɩ́ sɔ ati, sɛ ɛ 'fa like kɔ man Nyanmɩan, sɛ ɛ ju Nyanmɩan awulo nɩn anun lɩka mɔ bɛ yɩ tɛɛ'n nán ɛ kacɩ kɛ a se wɔ́ manngʋn bie sa a, ");
INSERT INTO any_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","anɩn wɔ́ like'n mɔ ɛ 'fa man Nyanmɩan'n, yaci yɩ́ ɛbɛlɛ, kɔ tʋa wɔ́ manngʋn'n bɛ sésie bɛ́ afian, nán afɩ a sa a fa wɔ́ like nɩn a man Nyanmɩan. ");
INSERT INTO any_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Sɛ sʋanlan bie kɔ sanman wɔ́, mɔ ɛmɔ kɔ fa atɩn'n mɔ bɛ lɛ kɔ'n, ɛbɛlɛ ala, tʋa yɩ́, ɛmɔ sésie ɛjɔlɛ sɔ'n bɛtɛɛ sʋ, nán ɔ'a nva man wɔ́ ɔ'a mman man kpain'n m'ɔ di ɛjɔlɛ'n, nán yɩ́ kʋsʋ ɔ'a nva man wɔ́ ɔ'a mman man nzalafʋ'n, nán b'a ndʋ man wɔ́ fiadɩ. ");
INSERT INTO any_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Nɩan, mɩɩn kan yɩ́ ananhɔlɛ mɩn kele wɔ́ kɛ sɛ ɛ yuelɩ man yɩ́ kalɛ'n kʋalaatin tua a, sɛ yɩ́ babulu kʋn bɔbɔ ka wɔ́ sʋ a, ɛ fi fiadɩ sua nɩn anun ɛ ngɔ fite man lé. ");
INSERT INTO any_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Bɛ hanlɩn bɛ helelɩ yɛ́ nan-mɔ kɛ: Ɛ ngɔ tʋn man ajaa. ");
INSERT INTO any_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Nan mɩ́n dɩɛ, mɩɩn kan mɩn kele ɛmɔ kɛ sʋanlan m'ɔ kɔ hulo balasua m'ɔ tɩ man yɩ́ yɩ mɔ yɩ́ nwʋn nna ajʋnlɩn kɔ a yɩ́ ti anun'n, sʋanlan sɔ'n, anɩn ɔ'a tʋn ajaa yɩ́ ahʋnlɩn nɩn anun dada angʋnmɩn. ");
INSERT INTO any_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Sɛ wɔ́ nyɩn fama'n yɛ̂ ɔ cʋɩn wɔ́ kɔ ɛtɛ nɩn anun an, tu yɩ́ tʋ mʋa. Sɛ ɛ minlin wɔ́ nwʋnnaan'n lɩka bie nán ɛ nyan ngʋan an, ɔ tɩ kpa ɔ tala kɛ wɔ́ munmuan'n kʋalaa kɔ hɔ sɩ̂n'n m'ɔ le man ayuelɩɛ nɩn anun. ");
INSERT INTO any_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Sɛ wɔ́ sa fama'n yɛ̂ ɔ cʋɩn wɔ́ kɔ ɛtɛ nɩn anun an, kpɛ tʋ mʋa. Sɛ ɛ kpɛ wɔ́ sa'n kʋn nán ɛ nyan ngʋan an, ɔ tɩ kpa ɔ tala kɛ ɛ kɔ fa yɩ́ nnyuan'n ɛ kɔ hɔ sɩ̂n'n m'ɔ le man ayuelɩɛ nɩn anun. ");
INSERT INTO any_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Ɛsɛ bɛ hanlɩn bɛ helelɩ yɛ́ nan-mɔ kɛ: Sɛ sʋanlan kʋn kulo kɛ ɔ yila yɩ́ yɩ a, anɩn ɔ hɛ́lɛ kalata m'ɔ kele kɛ b'a yila'n ɔ fá mán yɩ́. ");
INSERT INTO any_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Nan mɩ́n dɩɛ, mɩ́n nwan: Belenzua kʋn mɔ yɩ́ yɩ a mmɔ man bian, sɛ ɔ yila yɩ́ maan belenzua fʋfɔlɛ ja yɩ́ a, anɩn ɔ'a man balasua nɩn a tʋn ajaa. Yɛ̂ sʋanlan kʋsʋ m'ɔ kɔ ja balasua mɔ yɩ́ hun a yila yɩ́'n, anɩn sʋanlan sɔ nɩn a tʋn ajaa. ");
INSERT INTO any_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Ɛmɔ tɩlɩ kɛ bɛ hanlɩn bɛ helelɩ yɛ́ nan-mɔ kɛ: Like mɔ ɛ kɔ han ndâ wɔ Nyanmɩan anyunnun kɛ ɛ 'yɔ'n, n'ɛ kpɔ ndâ'n, nan yɔ like sɔ'n sakpa. ");
INSERT INTO any_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Mɩ́n dɩɛ, mɩɩn kan mɩn kele ɛmɔ kɛ nán bɛ kan ndâ bɔbɔ fɩ́ɩ́. Nán bɛ kan ndâ bɛ fa anwunno nɩn adanzɩɛ, ɔ sanlɩn kɛ ɛlɔ yɛ̂ Nyanmɩan belemgbin bia'n wɔ ɔ. ");
INSERT INTO any_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Nán bɛ kan ndâ bɛ fa asɩɛ nɩn adanzɩɛ, ɔ sanlɩn kɛ asɩɛ'n tɩ Nyanmɩan bia m'ɔ sesie yɩ́ ja sʋ ɔ. Nán bɛ kan ndâ bɛ fa Zoluzalɛmʋn kulo nɩn adanzɩɛ, ɔ sanlɩn kɛ ɛbɛlɛ tɩ Nannan Nyanmɩan Kpili kulo. ");
INSERT INTO any_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Nán bɛ kan ndâ bɛ fa sʋanlan ati nɩn adanzɩɛ, ɔ sanlɩn kɛ ɛmɔ ngʋala man kɛ bɛ man bɛ́ ti enyuan kʋnmgba cein fi fufue anaan bile. ");
INSERT INTO any_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Ɛmɔ hán yɩ́ tika kɛ: ‘Yuo’ anaan ‘Cɛcɛ.’ Yɩ́ nzin dɩɛ'n kʋalaa mɔ bɛ kan bɛ gua sʋ'n, ɔ fi Abɔnsanmʋn ɛlɔ. ");
INSERT INTO any_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Ɛsɛ bɛ hanlɩn bɛ helelɩ yɛ́ nan-mɔ kɛ: Sɛ sʋanlan bɔ wɔ́ nyɩn kʋn an, bɔ yɩ́ dɩɛ'n bie sie yɩ́ bʋsʋ. Sɛ sʋanlan tu wɔ́ je kʋn an, tu yɩ́ dɩɛ'n bie sie yɩ́ bʋsʋ. ");
INSERT INTO any_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Nan mɩ́n dɩɛ, mɩɩn kan mɩn kele ɛmɔ kɛ sɛ sʋanlan yɔ ɛmɔ ɛtɛ a, nán bɛ yɔ bie bɛ sie yɩ́ bʋsʋ. Sɛ sʋanlan kpacɩ wɔ́ nyɩn fama nɩn asʋ a, kaci bɛ̂'n maan ɔ kpácɩ sʋ. ");
INSERT INTO any_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Sɛ sʋanlan bie sanman wɔ́ nán yɩ́ nwan ɔ 'de wɔ́ taladɩɛ'n mɔ ɛ wula yɩ́ bʋ nɩn an, fa mɔ ɛ wula yɩ́ sʋ'n kʋsʋ bʋka sʋ man yɩ́. ");
INSERT INTO any_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Sɛ mân mgbain'n-mɔ bie fa yɩ́ ninnge tinndin wɔ́ kɛ ɛ sʋ́a ɛ hɔ́ sóman yɩ́ atɩn cilo kʋn an, kɔ dede ju cilo nnyuan. ");
INSERT INTO any_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Sʋanlan sɛlɛ wɔ́ like a, fa man yɩ́. Sɛ sʋanlan kulo kɛ ɔ fɛ wɔ́ like a, n'ɛ yɔ yɩ́ abɔlɛ. ");
INSERT INTO any_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Ɛmɔ tɩlɩ kɛ bɛ́ nwan: Kulo wɔ́ manngʋn, nán kpɔ sʋanlan m'ɔ kpɔ wɔ́'n. ");
INSERT INTO any_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Nan mɩ́n dɩɛ mɩɩn kan mɩn kele ɛmɔ kɛ ɛmɔ húlo bɛ́ mɔ bɛ kpɔ ɛmɔ'n. Ɛmɔ sɛ́lɛ Nyanmɩan bɛ mán bɛ́ mɔ bɛ kele ɛmɔ ahʋlʋwa'n, ");
INSERT INTO any_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","nán ɛmɔ a kaci ɛmɔ Asɩ'n m'ɔ wɔ anwunno nɩn amma. Afɩ Nyanmɩan man eyua'n fi ɔ man meninkpa'n-mɔ nʋn ɛtɛfʋɛ'n-mɔ kʋalaatin. Ɔ man esue'n tɔ ɔ man bɛ́ mɔ bɛ bɔ bala kpa ɔ nʋn bɛ́ mɔ bɛ yɔ ɛtɛ'n. ");
INSERT INTO any_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Sɛ bɛ́ mɔ bɛ kulo ɛmɔ nɩn ala yɛ̂ ɛmɔ kulo bɛ́ a, anɩn nzu nvasʋɛ dɩɛ yɛ̂ ɛmɔ nyan yɩ́ wɔ Nyanmɩan ɛlɔ ɔ? Ɛtɛfʋɛ kɛ bɛ́ mɔ bɛ dide ajule'n, kɛ bɛ́ kʋsʋ bɛ yɔ yɩ́ nɩn ala anɩn. ");
INSERT INTO any_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Sɛ ɛmɔ anianman'n-mɔ ala yɛ̂ ɛmɔ bisa bɛ́ ahɩn an, anɩn nzu like kpili dɩɛ yɛ̂ ɛmɔ a yɔ ɔ? Bɛ́ mɔ bɛ nne man Nyanmɩan bɛ nni man'n, kɛ bɛ́ kʋsʋ bɛ yɔ yɩ́ nɩn ala anɩn. ");
INSERT INTO any_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Yɩ́ sɔ ati, kɛmɔ ɛmɔ Asɩ m'ɔ wɔ anwunno'n tɩ sʋanlan kpa'n, ɛmɔ kʋsʋ káci meninkpa. ");
INSERT INTO any_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Ɛmɔ nɩ́an bɛ́ nwʋn kpa! Nán bɛ yɔ ninnge mɔ Nyanmɩan kulo'n bagua nɩn anun maan menian'n-mɔ kʋalaa nwun ɛmɔ. Sɛ ɛmɔ yɔ yɩ́ sɔ a, ɛmɔ nnyan man ɛmɔ Asɩ m'ɔ wɔ anwunno nɩn asa nun like fɩ́ɩ́. ");
INSERT INTO any_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Yɩ́ sɔ ati, sɛ ɛ 'man ehianfʋɛ'n-mɔ esika a, n'ɛ bɔ wɔ́ nwʋn kpayɛ kɛ apoo mma'n-mɔ yɔ yɩ́ Zufʋ'n-mɔ asɔnɩn sua'n-mɔ anun'n ɔ nʋn gua'n-mɔ asʋ'n. Bɛ yɔ sɔ bɛ man menian'n-mɔ fʋa bɛ́. Mɩɩn kan yɩ́ ananhɔlɛ mɩn kele ɛmɔ kɛ bɛ́ ahatua dɩɛ nɩn ala y'ɔ le bɛ́ dunman'n mɔ bɛ lɛ bɔ'n. ");
INSERT INTO any_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Nan wɔ́ dɩɛ, sɛ ɛ 'fa esika ɛ man ehianfʋɛ'n-mɔ a, n'ɛ man wɔ́ manngʋn'n muonun mɔ ɛ nʋn yɩ́ nanndɩ'n nwun nun. ");
INSERT INTO any_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Man wɔ́ acɛdɩɛ sɔ'n há nvɩalɩɛ nun. Ɛbɛlɛ nɩn anun yɛ̂ Nyanmɩan m'ɔ tɩ wɔ́ Sɩ m'ɔ nwun mɔ a yɔ yɩ́ nvɩalɩɛ nun'n, ɔ 'man ɛ nyan yɩ́ nwʋn ahatua ɔ. ");
INSERT INTO any_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Sɛ ɛmɔ 'yɔ asɔnɩn an, nán bɛ yɔ kɛ apoo mma'n-mɔ yɔ yɩ́'n. Bɛ kulo nzisi ejinlan bɛ yɔ asɔnɩn Zufʋ'n-mɔ asɔnɩn sua'n-mɔ anun nʋn gua'n-mɔ ayialɩɛ nɩn asʋ maan menian'n-mɔ kʋalaa nwun bɛ́. Mɩɩn kan yɩ́ ananhɔlɛ mɩn kele ɛmɔ kɛ b'a nyan bɛ́ ahatua'n dada angʋnmɩn. ");
INSERT INTO any_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Nan wɔ́ dɩɛ, sɛ ɛ 'yɔ asɔnɩn an, wʋlʋ wɔ́ sua nɩn anun, nyin wɔ́ nzin anʋan, nán sɛlɛ wɔ́ Sɩ m'ɔ wɔ wɔ́ lɩka mɔ ɛ fɩa'n. Yɛ̂ wɔ́ Sɩ m'ɔ nwun like mɔ ɛ lɛ yɔ yɩ́ nvɩalɩɛ nun'n, ɔ 'ba man ɛ nyan yɩ́ nwʋn ahatua. ");
INSERT INTO any_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Sɛ ɛmɔ 'yɔ asɔnɩn an, nán bɛ kan ndɩnndɩɩn kɛ bɛ́ mɔ bɛ nzʋ man Nyanmɩan'n yɔ yɩ́'n. Bɛ jʋnlɩn kɛ bɛ 'kan yɩ́ nwala nwala nán Nyanmɩan a tɩ. ");
INSERT INTO any_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Nán bɛ yɔ kɛ bɛ́, ɔ sanlɩn kɛ, Nyanmɩan m'ɔ tɩ ɛmɔ Asɩ'n, like mɔ ɛmɔ kɔ hian yɩ́ nwʋn'n, ɔ di mʋa ɔ nwun yɩ́ kʋalaaka nán ɛmɔ a sɛlɛ yɩ́ like sɔ'n. ");
INSERT INTO any_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","“Nan ɛ 'nwun kɛ ɛmɔ kpɩ́n bɛ yɔ́ asɔnɩn'n: Yɛ́ Sɩ mɔ ɛ wɔ anwunno, man yɛ fá anyɩnnzɔ yɛ bɔ́ wɔ́ dunman nwannzan-nwannzan'n. ");
INSERT INTO any_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Man wɔ́ belemgbin elie mɛlɛ'n jú. Man yɛ yɔ́ wɔ́ kunnun like asɩɛ nɩn asʋ ɛwa kɛ bɛ yɔ yɩ́ wɔ nyanmɩansʋ ɛlɔ'n. ");
INSERT INTO any_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Man yɛ́ ɛnɛ cɩan nɩn anwʋn alɩɛ. ");
INSERT INTO any_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Fa yɛ́ ɛtɛ'n-mɔ ce yɛ́ kɛ yɛ́ kʋsʋ yɛ fa yɛ ce bɛ́ mɔ bɛ fʋn yɛ́'n. ");
INSERT INTO any_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","N'ɛ yaci Abɔnsanmʋn maan ɔ laka yɛ́, nan de yɛ́ fi yɩ́ sa nun. Ɔ sanlɩn kɛ belemgbin elie'n, ɔ nʋn tunmin'n, ɔ nʋn anunminnyanmʋn'n, ɔ tɩ wɔ́ dɩɛ daa. Amɩn. ");
INSERT INTO any_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Afɩ sɛ ɛmɔ yaci bɛ́ manngʋn'n-mɔ ɛtɛ'n-mɔ ce bɛ́ sakpa a, ɛmɔ Asɩ m'ɔ wɔ nyanmɩansʋ'n, ɔ 'fa ɛmɔ kʋsʋ dɩɛ'n-mɔ ɔ ce ɛmɔ. ");
INSERT INTO any_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Nan sɛ ɛmɔ nva man bɛ́ manngʋn'n-mɔ ɛtɛ dɩɛ'n-mɔ nje man bɛ́ a, ɛmɔ Asɩ'n kʋsʋ ngɔ fa man ɛmɔ ɛtɛ dɩɛ'n-mɔ ɔ ngɔ hye man ɛmɔ. ");
INSERT INTO any_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Sɛ ɛmɔ lɛ di abuala a, nán bɛ yɔ bɛ́ nyunnun koun-koun kɛ apoo mma'n-mɔ yɔ yɩ́'n. Bɛ yɔ bɛ́ nyɩn nɩn anun koun-koun bɛ man menian'n-mɔ kʋalaa nwun kɛ bɛ lɛ di abuala. Mɩɩn kan yɩ́ ananhɔlɛ mɩn kele ɛmɔ kɛ b'a nyan bɛ́ ahatua'n dada angʋnmɩn. ");
INSERT INTO any_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Nan wɔ́ dɩɛ, mɛlɛ mɔ ɛ lɛ di abuala'n, nwunnzin wɔ́ nyunnun, toli wɔ́ ti nɩn anun, ");
INSERT INTO any_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","nán menian'n-mɔ a nnwun man kɛ ɛ lɛ di abuala. Wɔ́ Sɩ'n m'ɔ wɔ nvɩalɩɛ nun'n, yɩ́ ngʋnmɩn cein ɔ kɔ nwun yɩ́. Yɛ̂ wɔ́ Sɩ'n m'ɔ nwun mɔ ɛ lɛ yɔ yɩ́ nvɩalɩɛ nun'n, ɔ 'ba man ɛ nyan yɩ́ nwʋn ahatua. ");
INSERT INTO any_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Nán bɛ kpʋ́nndɛ mân ɛhɩ anun anwʋndɩɛ'n. Mân ɛhɩ anun ɛwa, ngakʋba di, ngannɔlɛ kan yɩ́, awofʋɛ'n-mɔ bubu anʋan bɛ wua. ");
INSERT INTO any_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Nan bɛ kpʋnndɛ nyanmɩansʋ anwʋndɩɛ dɩɛ'n. Nyanmɩansʋ, ngakʋba nnʋn man ɛlɔ bɛ nni man, ngannɔlɛ nnʋn man ɛlɔ, awofʋɛ nnʋn man ɛlɔ nán b'a bubu anʋan b'a wua. ");
INSERT INTO any_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Ɔ sanlɩn kɛ lɩka mɔ wɔ́ anwʋndɩɛ'n wɔ'n, ɛbɛlɛ kʋsʋ yɛ̂ wɔ́ ahʋnlɩn'n wɔ ɔ. ");
INSERT INTO any_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Bɛ́ nyɩn'n tɩ kɛ anwʋnnaan nɩn asʋ kanlannɩɛ: sɛ wɔ́ nyɩn'n tɩ kpa a, wɔ́ nwʋnnaan'n lɩka kʋalaatin wɔ jawe nun. ");
INSERT INTO any_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Nan sɛ wɔ́ nyɩn'n sin an, anɩn wɔ́ nwʋnnaan'n lɩka kʋalaatin wɔ awosin nun. Sɛ kanlannɩɛ'n m'ɔ wɔ wɔ́ nun'n tɩ awosin an, nwun yɩ́ kɛ awosin'n mɔ ɛ wɔ nun'n tɩ awosin kpili kpa. ");
INSERT INTO any_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Sʋanlan kʋn ngʋala man kɛ ɔ sʋ mɩnlɩan nnyuan. Sɛ ɔ sʋ mɩnlɩan nnyuan an, ɔ 'kpɔ kʋn nán ɔ kulo kʋn. Yɩ́ nyɩn 'sɔ kʋn yɛ́ ɔ 'tu yɩ́ nyɩn sa kʋn. Ɛmɔ ngʋala man kɛ bɛ ka sʋ bɛ sʋ Nyanmɩan nán b'a sʋ esika. ");
INSERT INTO any_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Yɩ́ sɔ ati, mɩɩn kan mɩn kele ɛmɔ kɛ: Nán bɛ susu alɩɛ mɔ ɛmɔ 'di nɩn anwʋn, ɔ nʋn nzue mɔ ɛmɔ 'nʋn nɩn anwʋn. Ɛsɛ nán bɛ susu taladɩɛ mɔ ɛmɔ 'wula nɩn anwʋn. Asʋ ngʋan'n tɩ man kpa ndala man alɩɛ nɩn ɔ? Yɛ̂ anwʋnnaan'n ndala man taladɩɛ nɩn ɔ? ");
INSERT INTO any_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Ɛmɔ nɩ́an nnʋnman'n-mɔ. Bɛ nnua man like fɩ́ɩ́, bɛ ngɔ man ebo sʋ bɛ nva man alɩɛ fɩ́ɩ́, bɛ nva man alɩɛ bɛ nzie man, nan kʋsʋ ɛmɔ Asɩ m'ɔ wɔ anwunno'n, ɔ gua bɛ́ nʋan alɩɛ! Ɛmɔ anwʋn cian kpa tala nnʋnman'n-mɔ. ");
INSERT INTO any_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Ɛmɔ anun benin yɛ̂ ɔ kʋala ɔ susu yɩ́ ngʋan nɩn anwʋn dede ɔ gua sʋ bie ɔ? ");
INSERT INTO any_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Nán nzukɛ ati yɛ̂ ɛmɔ di taladɩɛ mɔ ɛmɔ 'wula nɩn anwʋn yalɛ ɔ? Ɛmɔ nɩ́an kɛ ebo nɩn anun ndile'n-mɔ mɔ bɛ le ndetele'n-mɔ kpɩn fifi'n. Bɛ nni man junman, bɛ nnwʋn man taladɩɛ. ");
INSERT INTO any_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Nan kʋsʋ mɩɩn kan mɩn kele ɛmɔ kɛ belemgbin Salomʋn muonun nʋn yɩ́ anyanbɛnwʋn'n m'ɔ nyanlɩn yɩ́'n, taladɩɛ m'ɔ tɩ kanlanman kɛ ndetele'n-mɔ'n, ɔ'a nwula man bie lé. ");
INSERT INTO any_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Ndile'n-mɔ mɔ bɛ wɔ ebo nɩn anun ɛnɛ, mɔ ɛhɩnman bɛ 'ju bɛ́ bɛ gua sɩ̂n nun'n, sɛ Nyanmɩan sesie bɛ́ sʋa, ɔ yɔ sɛ mɔ ɔ ngɔ nɩan man ɛmɔ ɔ ngɔ tala man bɛ́ ɔ? Ɛmɔ dedi'n tɩ kaan! ");
INSERT INTO any_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Yɩ́ sɔ ati, nán bɛ di yalɛ bɛ kan kɛ: Nzukɛ yɛ̂ yɛ 'di ɔ? Nzukɛ yɛ̂ yɛ 'nʋn ɔ? Taladɩɛ benin yɛ̂ yɛ 'wula ɔ? ");
INSERT INTO any_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Bɛ́ mɔ bɛ nzʋ man Nyanmɩan'n, bɛ́ yɛ̂ cɩan daa bɛ susu ninnge ɛhɩ-mɔ anwʋn ɔ. Nan ɛmɔ Asɩ'n m'ɔ wɔ anwunno'n, ɔ sɩ kɛ ɛmɔ a hian ninnge sɔ'n-mɔ anwʋn. ");
INSERT INTO any_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Yɩ́ ti, ɛmɔ lí mʋa bɛ kpʋ́nndɛ Nyanmɩan Belemgbin Mân'n, ɔ nʋn asɩtanlan'n m'ɔ sɔ Nyanmɩan anyɩn'n, nán Nyanmɩan 'ba fa ninnge'n kʋalaa m'ɔ ka'n ce ɛmɔ. ");
INSERT INTO any_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Yɩ́ sɔ ati, nán bɛ jʋnlɩn ɛhɩnman alɩ́ɛ dɩɛ nɩn anwʋn. Alɩ́ɛ'n muonun yɛ̂ ɔ 'di ɛjɔlɛ'n m'ɔ kɔ a nun nɩn ɔ. Nunhan ɛjɔlɛ'n kʋalaa tɩ yɩ́ ɛjɔlɛ. ");
INSERT INTO any_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Nán bɛ bua bɛ́ manngʋn'n-mɔ ndɛɛ nán Nyanmɩan kʋsʋ a mmua man ɛmɔ ndɛɛ. ");
INSERT INTO any_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Ɔ sanlɩn kɛ, kɛ ɛmɔ kɔ kpɩn kɔ bua menian'n-mɔ ndɛɛ'n yɛ̂ Nyanmɩan kʋsʋ 'nɩan sʋ ɔ bua ɛmɔ ndɛɛ ɔ. Ɛsɛ kɛ ɛmɔ kɔ kpɩn kɔ susu kɔ man bɛ́ manngʋn'n-mɔ'n yɛ̂ Nyanmɩan 'nɩan sʋ ɔ susu man ɛmɔ ɔ. ");
INSERT INTO any_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","“Ɔ yɔ sɛ mɔ tabua munmuin kaan'n m'ɔ la wɔ́ manngʋn nɩn anyɩn nɩn asʋ'n yɛ̂ ɛ nwun yɩ́, nan kʋsʋ ɛ nnwun man tabua ebue'n m'ɔ la wɔ́ nyɩn dɩɛ nɩn asʋ'n? ");
INSERT INTO any_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Ɔ yɔ sɛ mɔ ɛ kʋala ɛ se wɔ́ manngʋn kɛ: ‘Jinlan maan n yɩ́ tabua munmuin'n m'ɔ la wɔ́ nyɩn nɩn asʋ'n’, kʋsʋ anɩn tabua ebue kʋn la wɔ́ nyɩn dɩɛ nɩn asʋ. ");
INSERT INTO any_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Ɛ bɔ wɔ́ nwʋn apoo, di mʋa yɩ tabua ebue'n m'ɔ la wɔ́ nyɩn nɩn asʋ'n, nán a nwun asɩ a yɩ tabua munmuin kaan'n m'ɔ la wɔ́ manngʋn nɩn anyɩn nɩn asʋ'n. ");
INSERT INTO any_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Like m'ɔ tɩ nwannzan-nwannzan'n, nán bɛ fa bɛ man njʋa'n-mɔ di. Sɛ ɛmɔ fa man bɛ́ a, bɛ 'kpɛ bɛ́ nyɩn bɛ sosua ɛmɔ nun. Nán bɛ ju bɛ́ kɔmɩn afile'n-mɔ bɛ gua mgbolike'n-mɔ anyunnun. Sɛ ɛmɔ ju bɛ́ kɔmɩn afile'n-mɔ bɛ gua mgbolike'n-mɔ anyunnun an, bɛ 'tetia sʋ. ");
INSERT INTO any_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Ɛmɔ sɛ́lɛ nán b'a fa b'a man ɛmɔ. Ɛmɔ kpʋ́nndɛ nán b'a nwun yɩ́. Ɛmɔ bɔ́ anʋan'n nán b'a tike. ");
INSERT INTO any_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Ɔ sanlɩn kɛ sʋanlan biala m'ɔ kɔ sɛlɛ like'n, bɛ 'fa bɛ man yɩ́. ");
INSERT INTO any_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Sʋanlan m'ɔ kɔ kpʋnndɛ'n, ɔ 'nwun yɩ́. Sʋanlan m'ɔ kɔ bɔ anʋan'n, bɛ 'tike. Ɛmɔ anun benin yɛ̂ sɛ yɩ́ wa sɛlɛ yɩ́ kpaʋn an, ɔ fa ɛbʋɛ man yɩ́ ɔ? ");
INSERT INTO any_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Anaan sɛ ɔ sɛlɛ yɩ́ ejue kʋn an, ɔ fa owo man yɩ́ ɔ? ");
INSERT INTO any_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Ɛmɔ mɔ bɛ tɩ ɛtɛfʋɛ'n, ɛmɔ sɩ ninnge mgbakpa fa man bɛ́ mma'n-mɔ. Ɔ yɔ sɛ mɔ ɛmɔ Asɩ'n m'ɔ wɔ anwunno'n, sɛ sʋanlan sɛlɛ yɩ́ like a, ɔ nva man like kpa ɔ mman man yɩ́ ɔ? ");
INSERT INTO any_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Like mɔ *Moyizɩ mala'n nʋn Nyanmɩan mgbɔmanfʋɛ'n-mɔ kalata'n kele'n y'ɔ le kɛ: Like kʋalaa mɔ ɛmɔ kulo kɛ ɛmɔ amanngʋn'n-mɔ yɔ́ mán ɛmɔ'n, ɛmɔ kʋsʋ yɔ́ like sɔ'n bie mán bɛ́. ");
INSERT INTO any_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Ɛmɔ wʋ́lʋ anʋan fɩtɩɩ nɩn anun. Afɩ anʋan tɛtɛlɛ'n ɔ nʋn akpɔ fanvalaʋn'n, bɛ kele ewue atɩn. Ɛbɛlɛ yɛ̂ menian dɔʋn kpa sɩn ɔ. ");
INSERT INTO any_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Nan anʋan fɩtɩɩ'n nʋn akpɔ bɔhyʋɩ'n, bɛ kele ngʋan atɩn. Bɛ́ mɔ bɛ nwun yɩ́ bɛ sɩn sʋ'n, b'a nzʋn man. ");
INSERT INTO any_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Ɛmɔ nɩ́an bɛ́ nwʋn kpa wɔ ato mgbɔmanfʋɛ'n-mɔ anwʋn. Bɛ fa bʋa kpolo bɛ wula bɛ ba ɛmɔ anwʋn. Nan bɛ́ kunnun an, bɛ tɩ kɛ bedi aminlefʋɛ kpa. ");
INSERT INTO any_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Bɛ́ nyɔlɩɛ'n-mɔ anun yɛ̂ ɛmɔ 'ba fa nwun bɛ́ ɔ. Bɛ ndɩ man divɩn mma ndile mmowe sʋ, yɛ̂ bɛ ndɩ man *figi mma eminlan mmowe sʋ. ");
INSERT INTO any_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Baka kpa biala su mma kpa. Yɛ̂ baka ɛtɛ kʋsʋ biala su mma ɛtɛ. ");
INSERT INTO any_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Baka kpa kʋn ngʋala man kɛ ɔ su mma ɛtɛ. Yɛ̂ baka ɛtɛ kʋsʋ kʋn ngʋala man kɛ ɔ su mma kpa. ");
INSERT INTO any_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Baka biala m'ɔ nzu man mma kpa'n, bɛ 'kpɛ bɛ tʋ sɩ̂n nɩn anun. ");
INSERT INTO any_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Ɛhɩka ati, ɔ fi bɛ́ nyɔlɩɛ nɩn anwʋn, ɛmɔ 'ba nwun ato mgbɔmanfʋɛ'n-mɔ angʋnmɩn. ");
INSERT INTO any_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Nán bɛ́ kʋalaa mɔ bɛ fɛlɛ mɩ́n: ‘Yɛ́ Mɩn, yɛ́ Mɩn’ yɛ̂ bɛ 'kɔ Anwunno Belemgbin Mân nɩn anun ɔ. Nan bɛ́ mɔ bɛ yɔ mɩ́n Sɩ m'ɔ wɔ anwunno nɩn akunnun like'n, bɛ́ ala yɛ̂ bɛ 'kɔ ɛlɔ ɔ. ");
INSERT INTO any_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Mân'n ndɛɛ ebua cɩan'n ju a, menian dɔʋn kpa 'ba se mɩ́n kɛ: ‘Yɛ́ Mɩn, yɛ́ Mɩn, wɔ́ dunman nun, yɛ lili Nyanmɩan kpɔman, yɛ fʋanlɩn wawɛ ɛtɛ'n-mɔ. Ɛsɛ wɔ́ dunman nun, yɛ yɔlɩ asinbɛnwʋn ninnge dɔʋn!’ ");
INSERT INTO any_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Ɛbɛlɛ nɩn anun yɛ̂ mɩn 'ba han mɩn kele bɛ́ kɛ: Cɩan bie lé mɩn nzɩ man ɛmɔ. Ɛmɔ hɔ́ mʋa, ɛmɔ mɔ ɛtɛ yɛ̂ bɛ yɔ'n.” ");
INSERT INTO any_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Ɛsɛ Zozi nwan: “Ɛhɩka ati, sʋanlan m'ɔ kɔ tɩ ɛjɔlɛ'n mɔ m'an han m'an hele ɛmɔ'n, sɛ ɔ nanndɩ sʋ a, anɩn ɔ tɩ kɛ bɛngɛlɛfʋɛ mɔ ɔ'a si yɩ́ sua nɩn ɛbʋɛ sʋ. ");
INSERT INTO any_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Esue nɩn a tɔ dede ɔ'a bu asɩ, anwʋnman nɩn a tu sɛlɛ kpa a si sua'n, nan kʋsʋ kɛmɔ ɔ jin ɛbʋɛ nɩn asʋ'n, ɔ man ɔ'a mmu man. ");
INSERT INTO any_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Nan sʋanlan biala m'ɔ kɔ tɩ ɛjɔlɛ'n mɔ m'an han mɔ ɔ'a nnanndɩ man sʋ'n, anɩn ɔ tɩ kɛ sʋanlan m'ɔ nzɩ man ngɛlɛ, mɔ ɔ'a si yɩ́ sua nɩn anyʋan nɩn asʋ. ");
INSERT INTO any_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Esue nɩn a tɔ dede ɔ'a bu asɩ, anwʋnman nɩn a tu sɛlɛ kpa a si sua sɔ'n. Ɔ'a bubu ɔ'a gua bɔkɔɔ.” ");
INSERT INTO any_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Mɔ Zozi hehelelɩ bɛ́ Nyanmɩan ninnge sɔ'n-mɔ dede mɔ yɩ́ nʋan tɔlɩ'n, kɛ ɔ kpɩn kekele menian'n-mɔ ninnge'n, ɔ sin bɛ́ nwʋn kpili sʋnman. ");
INSERT INTO any_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Ɔ sanlɩn kɛ yɩ́ ngehele'n nʋn *mala nɩn asʋ mgbain'n-mɔ dɩɛ'n tɩ man kʋn. Nan ɔ kekele bɛ́ tunmin sʋ. ");
INSERT INTO any_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Mɔ Zozi fi bʋka nɩn asʋ ɔ juli'n, menian dɔʋn sili yɩ́ sʋ. ");
INSERT INTO any_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Mɛlɛ sɔ nɩn anun, kokobefʋɛ kʋn kɔ kpunnge Zozi, ɔ kɔ tu kɔ tɔ yɩ́ ja nun, yɩ́ nwan: “Yɛ́ Mɩn, sɛ ɛ kulo a, ɛ kʋala kɛ ɛ man mɩ́n nwʋn sa.” ");
INSERT INTO any_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Ɔ hanlɩn sɔ a, Zozi kɔ tɩnngɛ yɩ́ sa'n ɔ kɔ han yɩ́. Yɩ́ nwan: “Yuo o, mɩn kulo, tɩ akpɔlɛ.” Ɛbɛlɛ ala, kokobefʋɛ nɩn anwʋn kɔ sa. ");
INSERT INTO any_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Mɔ yɩ́ nwʋn salɩ'n, Zozi kɔ han kɔ hele yɩ́ kɛ: “N'ɛ kan kele sʋanlan fɩ́ɩ́, nan kɔ fa wɔ́ nwʋn kele Nyanmɩan *tɛɛyɩfʋɛ'n. Sɛ ɔ nwun wɔ́ yue a, yɩ tɛɛ'n mɔ Moyizɩ helelɩ'n, nán man bɛ nwún yɩ́ kɛ wɔ́ nwʋn a sa.” ");
INSERT INTO any_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Mɔ Zozi juli Kapɛɛnawɔmʋn mɔ ɔ 'wʋlʋ kulo nɩn anun'n, *Lɔmʋn nzalafʋ kpain'n kʋn kɔ a yɩ́ nwʋn ɛbɛlɛ ");
INSERT INTO any_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","ɔ kɔ han kɔ hele yɩ́ kɛ: “Yɛ́ Mɩn, mɩ́n akʋa'n lɛ wu kpa. Ɔ'a bubu ɔ la awulo ɛlɔ. Yɩ́ ti, mɩn 'sɛlɛ wɔ́ kɛ ɛ mán yɩ́ nwʋn sá.” ");
INSERT INTO any_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Mɔ nzalafʋ'n hanlɩn sɔ'n, Zozi nwan: “Mɩn 'ba hɔ mɩn man yɩ́ nwʋn sa.” ");
INSERT INTO any_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Ɔ nʋn Zozi anʋan mɔ ɔ 'tɔ'n, nzalafʋ kpain'n nwan: “Mɩ́n Mɩn, mɩn nzɛ nvata man kɛ ɛ ba mɩ́n awulo ɛlɔ ɔ. Nan wɔ́ lɩlɩ kan ɛjɔlɛ kpɔlɛ kʋnmgba cein, nán mɩ́n akʋa nɩn anwʋn 'ba sa. ");
INSERT INTO any_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","N ne mɩ́n nyunnun mgbain mɔ bɛ sie mɩ́n yɛ̂ mɩ́n kʋsʋ mɩn sie mɩ́n nzalafʋ'n-mɔ. Sɛ mɩn se bɛ́ nunhan kʋn kɛ: ‘Kɔ!’ a, ɔ kɔ. Sɛ mɩn se fʋfɔlɛ kɛ: ‘Bala ɛwa!’ a, ɔ ba. Sɛ mɩn se mɩ́n akʋa'n kʋsʋ kɛ: ‘Yɔ like sʋa!’ a, ɔ yɔ.” ");
INSERT INTO any_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Mɔ Zozi tɩlɩ nzalafʋ kpain sɔ nɩn anʋan nun ɛjɔlɛ'n, ɔ sinlin yɩ́ nwʋn. Ɔ kɔ han kɔ hele bɛ́ mɔ bɛ si yɩ́ sʋ'n kɛ: “Mɩɩn kan yɩ́ ananhɔlɛ mɩn kele ɛmɔ kɛ Izalayɛ mân nɩn anun ɛwa, sʋanlan m'ɔ le dedi kpili kpa kɛ bian ɛhɩ'n, n nwunlin man yɩ́ nwʋn sʋ. ");
INSERT INTO any_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Mɩɩn kan mɩn kele ɛmɔ kɛ menian dɔʋn kpa fi sɛnzɛ afitelɩɛ, ɔ nʋn sɛnzɛ atɔlɩɛ, bɛ 'ba a Anwunno Belemgbin Mân nɩn anun, bɛ nʋn Abalahamʋn, Izakɩ, nʋn Zʋakɔbʋ bɛ 'ba tʋ asaa. ");
INSERT INTO any_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Nan bɛ́ mɔ yɛ̂ ɔ sɛ kɛ ahan bɛ kɔ Anwunno Belemgbin Mân nɩn anun'n, bɛ 'ju bɛ́ bɛ gua gua nɩn asʋ awosin nɩn anun. Ɛbɛlɛ, bɛ 'sun, ɛsɛ bɛ 'kʋan bɛ́ je'n.” ");
INSERT INTO any_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Ɛhɩ, Zozi kɔ han kɔ hele nzalafʋ kpain'n kɛ: “Kɔ wɔ́ awulo, wɔ́ dedi'n mán wɔ́ sa hán mɔ ɛ lɛ kpʋnndɛ'n.” Mɛlɛ sɔ nɩn ala, nzalafʋ kpain nɩn akʋa nɩn anwʋn kɔ sa. ");
INSERT INTO any_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Ɛhɩ anzin, Zozi kɔ hɔ Pɩɛlɩ awulo ɛlɔ. Ɔ 'kɔ a ju a, anɩn ebunnun a hyɩ Pɩɛlɩ asebala'n, ɔ la ɛbɛlɛ. ");
INSERT INTO any_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Zozi kɔ han Pɩɛlɩ asebala nɩn asa'n, ebunnun'n fi yɩ́ nwʋn kɔ tu. Ɔ kɔ jasʋ, ɔ kɔ kpʋnndɛ like kɔ man Zozi kɔ li. ");
INSERT INTO any_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Mɔ alɩ́ɛ'n tɔlɩ nun'n, bɛ falɩ menian dɔʋn kpa mɔ wawɛ ɛtɛ wɔ bɛ́ nun bɛ bɛlɛlɩ Zozi. Zozi le yɩ́ Nʋan Ɛjɔlɛ'n ɔ kɔ fʋan wawɛ ɛtɛ'n-mɔ maan bɛ fi menian'n-mɔ anun bɛ kɔ tu. Ɛsɛ ɔ kɔ man nwuluwafʋɛ'n-mɔ kʋalaa anwʋn kɔ sa. ");
INSERT INTO any_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Ɔ yɔlɩ sɔ maan ɛjɔlɛ'n mɔ Nyanmɩan kpɔmanfʋɛ *Ezayi hanlɩn'n kpɩnlɩn sʋ. Yɩ́ nwan: Ɔ'a fa yɛ́ nwʋn ewue'n ɔ'a man yɛ́ nwʋn a sa. ");
INSERT INTO any_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Ɛhɩ, menian dɔʋn kpa walɩ yialɩ Zozi anwʋn ɛbɛlɛ. M'ɔ nwunlin yɩ́ sɔ'n, ɔ kɔ han kɔ hele yɩ́ menian'n-mɔ kɛ bɛ mán bɛ kpɛ́ asue'n bɛ hɔ́ yɩ́ nzin ɛlɔ ebue kʋn. ");
INSERT INTO any_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Mala nɩn asʋ kpain'n kʋn kpunngelɩ yɩ́ nwʋn ɛbɛlɛ a, yɩ́ nwan: “Kpain, lɩka biala mɔ ɛ 'kɔ'n, mɩn 'kɔ bie.” ");
INSERT INTO any_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Mɔ hanlɩn sɔ'n, Zozi nwan: “Naan'n-mɔ le bɛ́ bɔɛ, nnʋnman'n-mɔ kʋsʋ le bɛ́ sâ mɔ bɛ da nun ɔ. Nan *Mân Baa'n le man lɩka m'ɔ da de yɩ́ ɛnwʋnmɩan ɔ.” ");
INSERT INTO any_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Yɩ́ menian'n-mɔ anun kʋn kʋsʋ kɔ se yɩ́ kɛ: “Yɛ́ Mɩn, man mɩ́n atɩn maan n gɔ́ n zíe mɩ́n sɩ kʋalaaka nán m'an a.” ");
INSERT INTO any_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Ɔ hanlɩn sɔ a, Zozi nwan: “Si mɩ́n sʋ nán yaci ewue mma maan bɛ síe bɛ́ mɔ b'a wu'n-mɔ.” ");
INSERT INTO any_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Ɛhɩ anzin, Zozi nʋn yɩ́ menian'n-mɔ fʋlɩ ɛlɛɛ nɩn anun. ");
INSERT INTO any_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Kaan cɛ, anwʋnman kpili kʋn nʋn asutue kɔ tu kɔ si bɛ́. Mgbaha'n kɔ bɔ nzue kɔ gua ɛlɛɛ nɩn anun dede ɔ ka m'ɔ nʋan ɔ. Nan ɔ 'ba yɔ sɔ'n, anɩn Zozi la ɛlɛɛ nɩn anun ɔ lɛ dafɩ. ");
INSERT INTO any_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Yɩ́ menian'n-mɔ kɔ hɔ kɔ tinnge yɩ́. Bɛ́ nwan: “Yɛ́ mɩn, de yɛ́ nán yɛ lɛ wu!” ");
INSERT INTO any_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Zozi nwan: “Nzukɛ ati yɛ̂ ɛmɔ sulo sʋa'n? Ɛmɔ le man dedi ɔ?” M'ɔ hanlɩn sɔ yuelɩ'n, ɔ kɔ jasʋ ɔ kɔ jʋjɔ aminle sʋ ɔ kɔ hele anwʋnman'n nʋn asue'n. Ɛbɛlɛ ala, anwʋnman kɔ gua asɩ, asue kʋsʋ kɔ gua asɩ. Yɩ́ kʋalaa kɔ yɔ diin. ");
INSERT INTO any_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Ɛjɔlɛ'n sinlin bɛ́ kʋalaa bɛ́ nwʋn. Bɛ́ nwan: “Sʋanlan benin y'ɔ le ɛhɩ? Ɔ jʋjɔ kele anwʋnman nʋn asue bɔbɔ a, bɛ man yɩ́ anyɩnnzɔ!” ");
INSERT INTO any_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Mɔ Zozi kpɛlɩ asue'n ɔ hɔlɩ juli yɩ́ nzin ɛlɔ'n, Gadala mân nɩn anun, mmelenzua nnyuan fi asielɩɛ nɩn asʋ bɛ kɔ fite fite. Bɛ kɔ a Zozi atɩn ɛkpa. Menian sɔ'n-mɔ, wawɛ ɛtɛ wɔ bɛ́ nun. Bɛ́ nwʋn esulo kpa, ɔ man sʋanlan fɩ́ɩ́ ngʋala man atɩn'n mɔ bɛ wɔ sʋ nɩn asʋ sɩn. ");
INSERT INTO any_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Mɔ bɛ walɩ juli Zozi anyunnun ɛbɛlɛ'n, bɛ kɔ tɛtɩan nun. Bɛ́ nwan: “Nyanmɩan Awa, nzu ɔ? Ɛ se yɛ́ sɛ? Asʋ a a ɛwa kɛ ɛ 'ba tua yɛ́ ɛtɛ nɩn anwʋn kalɛ kʋalaaka nán ndɛɛ ebua cɩan nɩn a ju ɔ?” ");
INSERT INTO any_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Ɔ 'ba yɔ sɔ'n, anɩn mgbolike fatule kpili kʋn wɔ mʋa kaan bɛ lɛ didi. ");
INSERT INTO any_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Wawɛ ɛtɛ'n-mɔ kɔ sɛlɛ Zozi, bɛ kɔ han bɛ kɔ hele yɩ́ kɛ: “Sɛ ɛ 'fʋan yɛ́ a, man yɛ́ atɩn maan yɛ hɔ́ wʋ́lʋ mgbolike ɛhɩ-mɔ anun.” ");
INSERT INTO any_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Zozi nwan: “Ɛmɔ hɔ́!” Wawɛ ɛtɛ'n-mɔ kɔ fite bɛ kɔ hɔ kɔ wʋlʋ mgbolike'n-mɔ anun. Ɛbɛlɛ ala, mgbolike fatule'n kʋalaa fi bʋka nɩn asʋ bɛ le ɛnwanndie bɛ kɔ hɔ kɔ gua asue nɩn anun bɛ kɔ nʋan. ");
INSERT INTO any_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Menian'n-mɔ mɔ bɛ nɩan mgbolike'n-mɔ asʋ'n kɔ nwanndi bɛ kɔ hɔ kulo, bɛ kɔ han like'n mɔ ɔ'a yɔ mgbolike'n-mɔ, ɔ nʋn menian'n-mɔ mɔ wawɛ ɛtɛ wɔ bɛ́ nun nɩn anwʋn ɛjɔlɛ bɛ kɔ hele menian'n-mɔ. ");
INSERT INTO any_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Mɔ kulo nɩn asʋ menian'n-mɔ kʋalaa tɩlɩ ɛjɔlɛ sɔ'n, bɛ kɔ kpʋ Zozi. Mɔ bɛ nwunlin yɩ́'n, bɛ kɔ sɛlɛ yɩ́ kɛ ɔ fi bɛ́ mân nɩn anun ɔ jásʋ. ");
INSERT INTO any_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","M'ɔ yɔlɩ sɔ'n, Zozi kɔ fʋ ɛlɛɛ nɩn anun, ɔ kɔ kpɛ asue'n ɔ kɔ sa kɔ hɔ yɩ́ kulo nɩn asʋ. ");
INSERT INTO any_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Ɔ juli ɛbɛlɛ a, bɛ kɔ sʋa bubuluwafʋɛ kʋn nʋn yɩ́ ɛbɛɛ'n kʋalaa bɛ kɔ bɛlɛ yɩ́. Mɔ Zozi nwunlin kɛ menian sɔ'n-mɔ le dedi'n, ɔ kɔ se bubuluwafʋɛ'n kɛ: “Mɩ́n wa, gua wɔ́ ahʋnlɩn asɩ. Nyanmɩan a fa wɔ́ ɛtɛ nɩn a hye wɔ́.” ");
INSERT INTO any_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Anɩn *mala nɩn asʋ mgbain'n mmie-mɔ wɔ ɛbɛlɛ. Bɛ kɔ han yɩ́ bɛ́ ti anun kɛ: “Sʋanlan ɛhɩ a jʋjɔ a tia Nyanmɩan.” ");
INSERT INTO any_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Zozi nwunlin bɛ́ ajʋnlɩn'n. Yɩ́ nwan: “Nzukɛ ati yɛ̂ ɛmɔ le ajʋnlɩn nvuin sʋa-mɔ ɛmɔ ati anun ɔ? ");
INSERT INTO any_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Sɛ mɩn se kɛ: ‘B'a fa wɔ́ ɛtɛ'n b'a hye wɔ́’ a, ɛmɔ nnwun man nun. Nan sɛ mɩn se kɛ: ‘Jasʋ nanndɩ’, nán ɔ yɔ sɔ a, ");
INSERT INTO any_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","anɩn ɛmɔ a nwun yɩ́ kɛ *Mân Baa'n le tunmin asɩɛ nɩn asʋ ɛwa, ɔ fa ɛtɛ ce.” Ɛhɩ a, ɔ se bubuluwafʋɛ'n kɛ: “Jasʋ, fa wɔ́ ɛbɛɛ'n kɔ wɔ́ awulo!” ");
INSERT INTO any_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Zozi hanlɩn sɔ ala, sʋanlan'n kɔ jasʋ ɔ kɔ hɔ yɩ́ awulo. ");
INSERT INTO any_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Mɔ meninsʋnman'n nwunlin yɩ́ sɔ'n, esulo hanlɩn bɛ́. Bɛ́ kɔ la Nyanmɩan asɩ, ɔ sanlɩn kɛ ɔ'a fa tunmin sʋa ɔ'a man kulo menian'n-mɔ. ");
INSERT INTO any_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Ɛhɩ anzin, Zozi fi ɛbɛlɛ ɔ kɔ hɔ. Mɔ ɔ 'sɩn kɔ'n, ɔ kɔ nwun kɛ bian kʋn tɩ lɩka mɔ bɛ dide ajule'n. Bian sɔ'n, bɛ fɛlɛ yɩ́ Matie. Zozi nwan: “Matie, si mɩ́n sʋ!” Ɔ hanlɩn sɔ a, Matie kɔ jasʋ kɔ si yɩ́ sʋ. ");
INSERT INTO any_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Ɛlɛhʋn kʋn Matie kɔ fɛlɛ Zozi alɩɛ. Mɛlɛ m'ɔ nʋn yɩ́ menian'n-mɔ bɛ gua tɔbɩlɩ nɩn anwʋn bɛ 'didi'n, bɛ́ dɔʋn mɔ bɛ dide ajule'n, nʋn menian mɔ bɛ́ asɩtanlan'n tɩ man kpa'n kɔ a kɔ tɛtanlan tɔbɩlɩ nɩn anwʋn bie. ");
INSERT INTO any_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Nan mɔ *Falisifʋɛ'n-mɔ nwunlin yɩ́ sɔ'n, bɛ kɔ bisa Zozi menian'n-mɔ kɛ: “Nzukɛ ati yɛ̂ ɛmɔ amɩn'n nʋn bɛ́ mɔ bɛ dide ajule, ɔ nʋn menian mɔ bɛ́ asɩtanlan tɩ man kpa'n yɛ̂ bɛ lɛ didi'n?” ");
INSERT INTO any_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Mɔ Zozi tɩlɩ ɛjɔlɛ sɔ'n, yɩ́ nwan: “Bɛ́ mɔ bɛ ndɩ man akpɔlɛ'n yɛ̂ bɛ kpʋnndɛ ayile ɛyɔlɛfʋɛ ɔ, nan nán bɛ́ mɔ bɛ tɩ akpɔlɛ nɩn ɔ. ");
INSERT INTO any_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Ɛhɛlɛ Ɛjɔlɛ'n lɩka mɔ b'a hɛlɛ yɩ́ kɛ Nyanmɩan nwan: Mɩn kulo kɛ menian'n-mɔ nwun anwunnvoe bɛ́ afian ɔ tala tɛɛ ɛyɩɛ nɩn anwʋn ninnge'n mɔ bɛ yɔ bɛ man mɩ́n'n. Ɛjɔlɛ sɔ'n, ɛmɔ hɔ́ súan nán bɛ tɩ́ yɩ́ bʋ kpa.” Mɔ Zozi hanlɩn sɔ'n, ɛsɛ yɩ́ nwan: “Nán sɛsɛfʋɛ'n-mɔ ati yɛ̂ m malɩ ɔ, nan ɛtɛfʋɛ'n-mɔ ati ɔ.” ");
INSERT INTO any_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Ɛhɩ, Zʋan menian'n-mɔ walɩ tʋlɩ Zozi a, bɛ́ nwan: “Yɛ nʋn *Falisifʋɛ'n-mɔ yɛ di abuala titi. Nan nzukɛ ati yɛ̂ wɔ́ menian dɩɛ'n-mɔ nni man abuala'n bie'n?” ");
INSERT INTO any_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Mɔ bɛ bisalɩ kosuan sɔ'n, Zozi kɔ bua bɛ́ kɛ: “Mɛlɛ mɔ atɔnvɔlɛ bian'n nʋn yɩ́ manngʋn-mɔ gua atɔnvɔlɛ nɩn abʋ'n, ɛmɔ jʋnlɩn kɛ menian sɔ'n-mɔ alʋa 'bɔ bɛ́ nwʋn? Cɛcɛ, bɛ́ lʋa mmɔ man bɛ́ nwʋn. Nan cɩan mɔ bɛ kɔ le atɔnvɔlɛ bian'n fi bɛ́ sa nun'n, ɛbɛlɛ nɩn anun yɛ̂ bɛ 'di abuala ɔ. ");
INSERT INTO any_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Sʋanlan fɩ́ɩ́ nva man ndafuin fʋfɔlɛ nda man ɛtanlan daba nun. Sɛ ɔ yɔ yɩ́ sɔ a, ndafuin fʋfɔlɛ'n 'sua ɛtanlan daba'n biekun. Sian anɩn yɩ́ bɔɛ nɩn a yɔ kpili a tala daba dɩɛ'n. ");
INSERT INTO any_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Bɛ nva man nzan fʋfɔlɛ bɛ ngua man kpolo kotoku daba nun. Sɛ bɛ yɔ yɩ́ sɔ a, kpolo kotoku'n 'sua ɔ sɛcɩ yɛ̂ nzan'n kʋsʋ 'butu. Nan nzan fʋfɔlɛ'n, bɛ gua yɩ́ kpolo kotoku fʋfɔlɛ nun. Yɩ́ dɩɛ anɩn kpolo kotoku o, nzan o, bɛ kʋala yɩ́ kʋalaa fa sie.” ");
INSERT INTO any_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Anɩn Zozi anʋan wɔ sʋ ɔ tɛ kan ɛjɔlɛ ɔ tɛ kele bɛ́. Zufʋ'n-mɔ kpain'n kʋn walɩ a, ɔ kɔ kʋtʋ Zozi anyunnun ɛbɛlɛ, yɩ́ nwan: “Mɩ́n wa balasua nɩn a wu kɩkaala. Yɩ́ ti, bala nán fa wɔ́ sa fua yɩ́ nwʋn maan ɔ hɩ́n.” ");
INSERT INTO any_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Bian'n hanlɩn sɔ a, Zozi nʋn yɩ́ menian'n-mɔ kɔ jasʋ bɛ kɔ si yɩ́ sʋ. ");
INSERT INTO any_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Mɔ bɛ 'kɔ'n, anɩn balasua kʋn wɔ menian'n-mɔ anun, ɔ li Zozi anzin. Moja a tu balasua sɔ'n dede afʋɛ bulu nʋn nnyuan. Ɔ kɔ hyʋɩn kɔ kpunnge Zozi, ɔ kɔ han yɩ́ taladɩɛ nɩn anʋan'n. ");
INSERT INTO any_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Ɔ sanlɩn kɛ yɩ́ kunnun ɛlɔ, yɩ́ nwan: “Sɛ mɩn nyan yɩ́ taladɩɛ'n bɔbɔ mɩn kan yɩ́ a, mɩ́n nwʋn 'sa.” ");
INSERT INTO any_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Zozi tʋlɩ yɩ́ nyɩn yɩ́ nzin m'ɔ nwunlin bala'n, yɩ́ nwan: “Mɩ́n wa balasua, gua wɔ́ ahʋnlɩn asɩ, nán wɔ́ dedi nɩn a man wɔ́ nwʋn a sa.” Ɛbɛlɛ ala, bala nɩn anwʋn kɔ sa. ");
INSERT INTO any_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Mɔ Zozi juli Zufʋ kpain nɩn awulo ɛbɛlɛ m'ɔ nwunlin abile mma'n-mɔ nʋn awɔ́lɛ mma'n-mɔ'n, yɩ́ nwan: ");
INSERT INTO any_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","“Ɛmɔ fi ɛwa bɛ fíte, nán batʋnman'n wuli man, ɔ lɛ dafɩ.” Zozi hanlɩn sɔ a, menian'n-mɔ kɔ tu kɔ gua bɛ kɔ sɩlɩ yɩ́. ");
INSERT INTO any_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Mɔ bɛ manlɩn menian'n-mɔ fitelɩ yuelɩ'n, Zozi kɔ wʋlʋ sua nɩn anun ɛlɔ, ɔ kɔ sɔ talua kaan nɩn asa, talua'n kɔ jasʋ. ");
INSERT INTO any_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Mɔ talua'n jasʋlɩ'n, ɛjɔlɛ sɔ'n hɔlɩ dede ɔ juli mân sɔ'n lɩka kʋalaatin. ");
INSERT INTO any_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Ɛhɩ, Zozi fi ɛbɛlɛ hɔlɩ, nan mɛlɛ mɔ ɔ 'kpɛ nun sɩn'n, anyɩnsinlinwafʋɛ nnyuan kɔ si yɩ́ sʋ, bɛ le ɛtɛtɩan. Bɛ́ nwan: “Belemgbin *Davidi awa, nwun yɛ́ nwʋn anwunnvoe!” ");
INSERT INTO any_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Mɔ Zozi juli yɩ́ awulo'n, anyɩnsinlinwafʋɛ'n-mɔ kɔ kpunnge yɩ́ nwʋn ɛbɛlɛ, nán ɔ'a bisa bɛ́ kɛ: “Asʋ ɛmɔ de di kɛ mɩn kʋala mɩn man ɛmɔ anwʋn sa ɔ?” Mɔ Zozi bisalɩ bɛ́ kosuan sɔ'n, bɛ́ nwan: “Yuo o! Yɛ́ Mɩn, ɛ kʋala yɩ́ yɔ.” ");
INSERT INTO any_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Ɛhɩ a, Zozi kɔ fua bɛ́ nyɩn'n, yɩ́ nwan: “Ɛmɔ dedi nɩn anwʋn, man ɔ yɔ́ sɔ mán ɛmɔ!” ");
INSERT INTO any_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Ɛbɛlɛ ala, bɛ́ nyɩn'n-mɔ kɔ tike tike. Zozi kɔ jʋjɔ aminle sʋ kɔ hele bɛ́, yɩ́ nwan: “Ɛmɔ tíe yɩ́ kpa, nán bɛ man sʋanlan fɩ́ɩ́ anzʋ tɩ.” ");
INSERT INTO any_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Nan mɔ anyɩnsinlinwafʋɛ nnyuan sɔ'n fi ɛbɛlɛ hɔlɩ'n, bɛ kɔ bɔ Zozi anwʋn ɛjɔlɛ ɛbɛlɛ mân sɔ nɩn anun lɩka kʋalaatin. ");
INSERT INTO any_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Anyɩnsinlinwafʋɛ'n-mɔ hɔlɩ ala, bɛ kɔ fa sʋanlan kʋn bɛ kɔ bɛlɛ Zozi. Sʋanlan sɔ'n, wawɛ ɛtɛ wɔ yɩ́ nun, ɔ man ɔ ngʋala man jʋjɔ. ");
INSERT INTO any_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Mɔ Zozi tuli wawɛ ɛtɛ'n, sʋanlan'n kɔ jʋjɔ. Ɔ sinlin menian'n-mɔ anwʋn. Bɛ́ nwan: “Yɛ nwunlin man like sʋa bie lé Izalayɛ mân nɩn anun!” ");
INSERT INTO any_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Nan mɔ *Falisifʋɛ'n-mɔ nwunlin yɩ́ sɔ'n, bɛ́ nwan: “Wawɛ ɛtɛ'n-mɔ kpain'n y'ɔ man yɩ́ tunmin m'ɔ fa tu wawɛ ɛtɛ'n-mɔ ɔ.” ");
INSERT INTO any_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Zozi nanndɩlɩ kulo mgbili'n-mɔ ɔ nʋn ngangan'n-mɔ asʋ, ɔ hehelɩ menian'n-mɔ ninnge Zufʋ'n-mɔ asɔnɩn sua'n-mɔ anun. Ɔ bɔlɩ Ɛjɔlɛkpa'n m'ɔ tʋ de Anwunno Belemgbin Mân'n ɔ helelɩ bɛ́. Bɛ́ mɔ ewue ngacile ngacile kʋalaa wɔ bɛ́ nwʋn'n, Zozi manlɩn bɛ́ nwʋn salɩ. ");
INSERT INTO any_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Mɔ Zozi nwunlin meninsʋnman'n, bɛ́ nwʋn yɔlɩ yɩ́ anwunnvoe. Ɔ sanlɩn kɛ b'a fɛ, ɛsɛ bɛ́ nwʋn a bubu bɛ́. Bɛ tɩ kɛ mmʋa mɔ bɛ le man bʋa ɛnɩanfʋɛ ɔ. ");
INSERT INTO any_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Ɛhɩ a, ɔ kɔ han kɔ hele yɩ́ menian'n-mɔ kɛ: “Ebo'n tɩ kpili, nan kʋsʋ ajunmanfʋ'n-mɔ a nzʋn man. ");
INSERT INTO any_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Yɩ́ ti, ɛmɔ sɛ́lɛ ebo nɩn asʋ mɩnlɩan'n maan ɔ gúa ajunmanfʋ dɔʋn yɩ́ ebo nɩn asʋ.” ");
INSERT INTO any_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Mɔ Zozi hanlɩn sɔ yuelɩ'n, ɔ kɔ fɛlɛ yɩ́ menian bulu nʋn nnyuan'n, ɔ kɔ man bɛ́ tunmin mɔ bɛ kʋala yɩ́ fa tu wawɛ ɛtɛ'n-mɔ. Ɛsɛ bɛ́ mɔ ewue ngacile ngacile kʋalaa wɔ bɛ́ nwʋn'n, bɛ kʋala kɛ bɛ man bɛ́ nwʋn sa. ");
INSERT INTO any_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Ɛ 'nwun Zozi mmɔfʋɛ bulu nʋn nnyuan'n dunman: m'ɔ li mʋa'n y'ɔ le Simʋn mɔ bɛ fɛlɛ yɩ́ Pɩɛlɩ'n, ɔ nʋn yɩ́ nianman Andele, Zebede awa Zʋakɩ nʋn yɩ́ nianman Zʋan, ");
INSERT INTO any_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Filipʋ, Baatelemin, Toma, Matie m'ɔ dide ajule'n, Alɩfe awa Zʋakɩ, Tade, ");
INSERT INTO any_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simʋn m'ɔ kpʋnndɛ yɩ́ mân'n fanwʋndi'n yɛ̂ Zudasɩ Isikaliɔtɩ mɔ ɔ 'yɩ Zozi man yɩ́ mgbɔfʋɛ'n-mɔ. ");
INSERT INTO any_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Menian bulu nʋn nnyuan'n mɔ Zozi sʋanlɩn bɛ́ nɩn anɩn. Asannan nán ɔ'a sʋan bɛ́'n, afʋtu m'ɔ tuli bɛ́ nɩn ahɩ, yɩ́ nwan: “Bɛ́ mɔ bɛ tɩ man Zufʋ'n, nán bɛ kɔ bɛ́ nwʋn, ɛsɛ nán bɛ kɔ Samali kulo'n-mɔ asʋ. ");
INSERT INTO any_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Nan ɛmɔ hɔ́ Izalayɛ amma'n-mɔ anwʋn. Afɩ bɛ tɩ kɛ mmʋa mɔ b'a minlin ɔ. ");
INSERT INTO any_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Ɛmɔ 'kɔ a, ɛmɔ hán héle menian'n-mɔ kɛ Anwunno Belemgbin elie mɛlɛ nɩn a kpunnge. ");
INSERT INTO any_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Ɛmɔ mán nwuluwafʋɛ'n-mɔ anwʋn sá, bɛ́ mɔ yɛ̂ b'a wu'n, man bɛ fi ewe nun bɛ jásʋ, ɛmɔ tɩ́ kokobefʋɛ'n-mɔ anwʋn, bɛ tú wawɛ ɛtɛ'n-mɔ. Nán bɛ de bɛ́ like fɩ́ɩ́, nan bɛ yɔ́ bɛ hyé bɛ́, ɔ sanlɩn kɛ Nyanmɩan a fa tunmin sɔ nɩn a hye ɛmɔ. ");
INSERT INTO any_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Sɛ ɛmɔ 'kɔ a, nán bɛ fa esika fɩ́ɩ́ bɛ sa bɛ́ nwʋn. ");
INSERT INTO any_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Nán bɛ fa bɔ́lɛ, nán bɛ fa taladɩɛ nnyuan, nán bɛ fa mgbabʋa kʋ́n, ɛsɛ nán bɛ fa kpɔman kʋ́n bɛ sa bɛ́ nwʋn. Ɔ sanlɩn kɛ sʋanlan m'ɔ di junman'n, ɔ sɛ kɛ ɔ nyan yɩ́ nʋan nun alɩɛ m'ɔ fata ɔ. ");
INSERT INTO any_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Kulo biala mɔ ɛmɔ kɔ hɔ sʋ'n, sɛ ɔ tɩ kpili o, sɛ ɔ tɩ kaan o, ɛmɔ bísa bísa, sʋanlan m'ɔ kulo kɛ ɔ sike ɛmɔ'n, ɛmɔ tánlan yɩ́ awulo ɛbɛlɛ dede ɔ jú cɩan mɔ ɛmɔ fi kulo sɔ nɩn asʋ bɛ 'jasʋ'n. ");
INSERT INTO any_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Awulo mɔ ɛmɔ kɔ wʋlʋ nun'n, ɛmɔ bísa bɛ́ ahɩn. ");
INSERT INTO any_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Sɛ awulo sɔ nɩn anun menian'n-mɔ sɔ ɛmɔ nun kanlanman an, ɛmɔ mán ɛmɔ alʋacɩcɩɛ'n há awulo sɔ nɩn anun. Nan sɛ b'a nzɔ man ɛmɔ nun an, ɛmɔ alʋacɩcɩɛ'n há ɛmɔ asa nun. ");
INSERT INTO any_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Sɛ b'a nzɔ man ɛmɔ nun b'a ndie man ɛmɔ ɛjɔlɛ nɩn an, ɛmɔ bɔ́ bɛ́ mgbabʋa'n-mɔ abʋ nvutule'n bɛ gúa ɛbɛlɛ bɛ hɔ́. ");
INSERT INTO any_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Mɩɩn kan yɩ́ ananhɔlɛ mɩn kele ɛmɔ kɛ ndɛɛ ebua cɩan nɩn anun, kulo sɔ nɩn asʋ menian'n-mɔ, yalɛ mɔ bɛ 'nwun yɩ́'n, ɔ 'tala Sodɔmʋn nʋn Gomɔɔ kulo'n-mɔ asʋ menian'n-mɔ dɩɛ'n. ");
INSERT INTO any_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Ɛmɔ nɩ́an, mɩɩn sʋan ɛmɔ kɛ mmʋa wɔ bedi'n-mɔ afian. Ɛhɩka ati, ɛmɔ nɩ́an bɛ́ nwʋn ye kɛ owo-mɔ, ɛsɛ ɛmɔ yɔ́ mɛlɛhʋandɩ kɛ abubule'n-mɔ. ");
INSERT INTO any_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Ɛmɔ nɩ́an bɛ́ nwʋn wɔ menian'n-mɔ dunman nun. Ɔ sanlɩn kɛ bɛ 'ba fa ɛmɔ bɛ kɔ bɛ́ mɔ bɛ di ɛjɔlɛ nɩn aja sʋ. Bɛ 'fin ɛmɔ mgbele bɛ́ Nyanmɩan sua'n-mɔ anun. ");
INSERT INTO any_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Mɩ́n dunman nun, bɛ 'ba fa ɛmɔ bɛ kɔ mân mgbain'n-mɔ nʋn mmelemgbin'n-mɔ aja sʋ maan ɛmɔ di mɩ́n nwʋn adanzɩɛ bɛ kele bɛ́ ɔ nʋn bɛ́ mɔ bɛ tɩ man Zufʋ'n. ");
INSERT INTO any_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Sɛ bɛ nʋn ɛmɔ kɔ bɛ́ mɔ bɛ di ɛjɔlɛ nɩn aja sʋ a, mɔ ɛmɔ 'ba han'n, nán bɛ susu yɩ́ nwʋn, ɛsɛ nán bɛ susu kɛ ɛmɔ 'kpɩn kan ɛjɔlɛ'n. Ɔ sanlɩn kɛ ɛjɔlɛ m'ɔ di mɔ ɛmɔ kan'n 'ba tɔ ɛmɔ anʋan anun tɛmʋn sɔ'n. ");
INSERT INTO any_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Ɛjɔlɛ'n mɔ ɛmɔ 'ba han'n, ɔ fi man ɛmɔ muonun, nan ɛmɔ Asɩ'n Wawɛ'n yɛ̂ ɔ 'fa ɛjɔlɛ sɔ'n wula ɛmɔ anʋan ɔ. ");
INSERT INTO any_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Menian mmie-mɔ 'ba yɩ bɛ́ nianman'n-mɔ man maan bɛ kun bɛ́. Sɩɛ mmie-mɔ kʋsʋ 'ba yɩ bɛ́ mma'n-mɔ man maan bɛ kun bɛ́. Mma mmie-mɔ kʋsʋ 'ba jasʋ bɛ́ sɩ-mɔ akɔmɩn anun maan bɛ kun bɛ́. ");
INSERT INTO any_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Mɩ́n dunman nun, menian'n-mɔ kʋalaa 'fa ɛmɔ anwʋn ɛkpɔ. Nan sʋanlan m'ɔ kɔ jinlan yɩ́ ja nun kpunndiin dede ɔ kɔ ju yɩ́ ayuelɩɛ'n, sʋanlan sɔ'n, ɔ 'nyan yɩ́ ti. ");
INSERT INTO any_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Kulo mɔ ɛmɔ kɔ hɔ sʋ mɔ bɛ lɛ kele ɛmɔ ahʋlʋwa'n, ɛmɔ nwánndi bɛ hɔ́ fʋfɔlɛ asʋ. Mɩɩn kan yɩ́ ananhɔlɛ mɩn kele ɛmɔ kɛ ɛmɔ ngɔ yue man Izalayɛ kulo'n-mɔ kʋalaa asʋ kpanza nán *Mân Baa nɩn a a. ");
INSERT INTO any_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Sʋanlan mɔ bɛ lɛ kele yɩ́ like'n, ɔ ndala man sʋanlan'n m'ɔ lɛ kele yɩ́'n. Akʋa'n kʋsʋ ndala man yɩ́ mɩn'n. ");
INSERT INTO any_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","M'ɔ cian'n, y'ɔ le kɛ sʋanlan'n mɔ bɛ lɛ kele yɩ́ like'n, ɔ káci kɛ sʋanlan'n m'ɔ lɛ kele yɩ́ like'n. Yɛ̂ akʋa'n kʋsʋ, ɔ káci kɛ yɩ́ mɩn'n. Sɛ bɛ lɛ fɛlɛ awulo kpain'n muonun *Bɛlɩzebulu a, nán awulo nɩn anun menian'n-mɔ yɛ̂ bɛ ngɔ fɛlɛ bɛ́ kɛ bɛ kulo ɔ! ");
INSERT INTO any_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Ɛmɔ nán bɛ sulo kulo menian'n-mɔ. Afɩ yɩ́ kʋalaa mɔ bɛ kɔ fɩa bɛ kɔ yɔ'n, bɛ 'nwun yɩ́. Yɛ̂ ɛjɔlɛ mɔ bɛ kɔ li yɩ́ nvɩalɩɛ nun'n kʋsʋ 'fite. ");
INSERT INTO any_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Mɔ mɩɩn kan mɩn kele ɛmɔ kɔngɔɛ'n, ɛmɔ hán yɩ́ eyua. Ɛjɔlɛ mɔ bɛ kɔ han bɛ kɔ hele ɛmɔ asulo nun'n, ɛmɔ fʋ́ jínlan anwunno bɛ hán. ");
INSERT INTO any_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Ɛmɔ nán bɛ sulo menian'n-mɔ mɔ bɛ kun anwʋnnaan'n kʋsʋ bɛ ngʋala man wawɛ'n kun'n. Nan ɛmɔ súlo Nyanmɩan mɔ kʋala kɛ ɔ man anwʋnnaan'n nʋn wawɛ'n wu sɩ̂n'n m'ɔ le man ayuelɩɛ nɩn anun'n. ");
INSERT INTO any_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Asʋ bɛ ndɔnɩn man nnʋnman atulufia nganngan nnyuan gua dufule ɔ? Nan kʋsʋ bɛ nnyan man bɛ́ bɛ ngun man bɛ́ mgban. Nunhan kʋn mɔ bɛ kɔ nyan yɩ́ bɛ kɔ hun yɩ́'n, anɩn Nyanmɩan muonun a man yɩ́ nwʋn atɩn. ");
INSERT INTO any_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Nan ɛmɔ dɩɛ, ɛmɔ ati enyuan'n muonun, Nyanmɩan sɩ yɩ́ nʋan. ");
INSERT INTO any_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Nán man ɛmɔ sulo like fɩ́ɩ́. Ɔ sanlɩn kɛ ɛmɔ anwʋn cian kpa tala atulufia dɔʋn kpa. ");
INSERT INTO any_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Ɛhɩka ati, sʋanlan m'ɔ kɔ han yɩ́ menian'n-mɔ anyunnun kɛ ɔ tɩ mɩ́n dɩɛ'n, mɩ́n kʋsʋ mɩn 'kan yɩ́ mɩ́n Sɩ m'ɔ wɔ anwunno nɩn anyunnun kɛ sʋanlan sɔ'n tɩ mɩ́n dɩɛ. ");
INSERT INTO any_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Nan sɛ sʋanlan kʋn kan yɩ́ menian'n-mɔ anyunnun kɛ ɔ nzɩ man mɩ́n an, mɩ́n kʋsʋ mɩn 'kan yɩ́ mɩ́n Sɩ m'ɔ wɔ anwunno nɩn anyunnun kɛ mɩn nzɩ man sʋanlan sɔ'n! ");
INSERT INTO any_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Nán man ɛmɔ jʋnlɩn kɛ m malɩ mân nɩn anzʋnunjɔ ɛman. Nán anzʋnunjɔ yɛ̂ n valɩ malɩ ɔ, nan ɛlɔɛ ɔ. ");
INSERT INTO any_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","M malɩ baa'n nʋn yɩ́ sɩ bɛ́ afian ɛsɛcɩɛ. M malɩ nian'n nʋn yɩ́ wa balasua nɩn afian ɛsɛcɩɛ. Ɛsɛ kʋsʋ m malɩ ahelenian'n-mɔ afian ɛsɛcɩɛ. ");
INSERT INTO any_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Awulo kʋn anun menian'n-mɔ 'kpɔ bɛ́ nwʋn. ");
INSERT INTO any_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Sʋanlan m'ɔ kulo yɩ́ sɩ anaan yɩ́ nin tala mɩ́n'n, sʋanlan sɔ'n, anɩn ɔ tɩ man mɩ́n dɩɛ. Sʋanlan kʋsʋ m'ɔ kulo yɩ́ wa belenzua anaan yɩ́ wa balasua tala mɩ́n'n, sʋanlan sɔ'n kʋsʋ, anɩn ɔ tɩ man mɩ́n dɩɛ. ");
INSERT INTO any_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Sʋanlan mɔ ɔ'a nva man yɩ́ kʋlʋwa'n ɔ'a ndʋ man yɩ́ kɔmɩn sʋ, ɔ'a nzi man mɩ́n sʋ'n, sʋanlan sɔ'n, ɔ tɩ man mɩ́n dɩɛ. ");
INSERT INTO any_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Sʋanlan m'ɔ kulo kɛ ɔ kpʋnndɛ yɩ́ ngʋan'n, sʋanlan sɔ'n, ɔ 'minlin yɩ́ ngʋan'n. Nan sʋanlan mɔ mɩ́n dunman nun ɔ kɔ minlin yɩ́ ngʋan'n, ɔ 'nyan ngʋan. ");
INSERT INTO any_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Sʋanlan m'ɔ kɔ sɔ ɛmɔ nun'n, anɩn mɩ́n yɛ̂ ɔ'a sɔ mɩ́n nun ɔ. M'ɔ kɔ sɔ mɩ́n nun'n, anɩn sʋanlan'n m'ɔ sʋanlɩn mɩ́n'n nun yɛ̂ ɔ'a sɔ ɔ. ");
INSERT INTO any_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Sʋanlan m'ɔ kɔ sɔ Nyanmɩan kpɔmanfʋɛ kʋn nun kɛ bɛ sɔ bɛ́ nun'n, kpɔmanfʋɛ ahatua yɛ ɔ 'nyan yɩ́ ɔ. Sʋanlan kʋsʋ m'ɔ kɔ sɔ sɛsɛfʋɛ kʋn nun kɛ bɛ sɔ bɛ nun'n, sɛsɛfʋɛ ahatua yɛ̂ ɔ 'nyan yɩ́ ɔ. ");
INSERT INTO any_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Mɩɩn kan yɩ́ ananhɔlɛ mɩn kele ɛmɔ kɛ: sʋanlan m'ɔ kɔ man mmatʋnman ɛhɩ-mɔ anun kʋn nzue fɔlɔlɔ mgban nganlannzan kʋn kɔ nʋn, ɔ sanlɩn kɛ ɔ tɩ mɩ́n sʋanlan'n, sʋanlan sɔ'n, ɔ 'nyan yɩ́ nwʋn ahatua.” ");
INSERT INTO any_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Mɔ Zozi yuelɩ ɛjɔlɛ sɔ'n-mɔ kan kele yɩ́ menian bulu nʋn nnyuan'n, ɔ kɔ hɔ kɔ hehele Nyanmɩan Anʋan Ɛjɔlɛ nɩn ɛbɛlɛ kulo kulo'n-mɔ asʋ. ");
INSERT INTO any_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Tɛmʋn sɔ'n, anɩn b'a tʋ Zʋan fiadɩ. M'ɔ tɩlɩ junman'n mɔ Kilisi lɛ di nɩn angan'n, ɔ kɔ sʋan yɩ́ menian'n mmie-mɔ yɩ́ nwʋn ɛlɔ. ");
INSERT INTO any_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Bɛ hɔlɩ juli Zozi anwʋn ɛlɔ a, bɛ́ nwan: “Yɛ́ Mɩn, sʋanlan'n mɔ Zʋan hanlɩn yɩ́ ɛjɔlɛ kɛ ɔ 'ba'n y'ɔ le wɔ́ anaan sʋanlan sɔ'n tɛ wɔ sian ɔ?” ");
INSERT INTO any_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Zozi kɔ bua bɛ́ kɛ: “Ɛhɩ mɔ ɛmɔ a tɩ'n, ɔ nʋn mɔ ɛmɔ a nwun yɩ́'n, bɛ hɔ́ bɔ́ nun amannɩɛ bɛ héle Zʋan. ");
INSERT INTO any_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Anyɩnsinlinwafʋɛ'n-mɔ nwun asɩ. Bubuluwafʋɛ'n-mɔ nanndɩ. Kokobefʋɛ'n-mɔ anwʋn a sa. Anzʋtiliwafʋɛ'n-mɔ tɩ ɛjɔlɛ. Ewue mma'n-mɔ fi ewue nun b'a tinnge. Ɛjɔlɛkpa'n kʋsʋ, bɛ lɛ bɔ bɛ kele ehianfʋɛ'n-mɔ. ");
INSERT INTO any_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Nyila hán sʋanlan m'ɔ kɔ tila yɩ́ dedi'n m'ɔ le yɩ́ mɩ́n nwʋn nɩn anun'n.” ");
INSERT INTO any_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Mɔ Zʋan menian'n-mɔ salɩ hɔlɩ'n, Zozi kɔ han Zʋan anwʋn ɛjɔlɛ kɔ hele menian'n-mɔ. Yɩ́ nwan: “Nzukɛ yɛ̂ ɛmɔ hɔlɩ yɩ́ ɛnɩan ɛwâ nɩn anun ɛlɔ'n? Ndɛɛ mɔ anwʋnman'n lɛ fita yɩ́ ɔ? ");
INSERT INTO any_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Anaan nzu like dɩɛ yɛ̂ ɛmɔ hɔlɩ yɩ́ ɛnɩan ɔ? Ɛmɔ hɔlɩ nɩanlɩn sʋanlan m'ɔ wula taladɩɛ kanlanman ɔ? Nan bɛ́ mɔ bɛ wula taladɩɛ nganlanman nganlanman'n, bɛ gua mmelemgbin'n-mɔ awulo. ");
INSERT INTO any_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Anɩn nzu lɩlɩ yɛ̂ ɛmɔ hɔlɩ yɩ́ ɛnɩan'n? Nyanmɩan kpɔmanfʋɛ kʋn ɔ? Sakpa, mɩɩn kan mɩn kele ɛmɔ kɛ ɔ tala Nyanmɩan kpɔmanfʋɛ bɔbɔ. ");
INSERT INTO any_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Ɔ sanlɩn kɛ Zʋan yɛ̂ Ɛhɛlɛ Ɛjɔlɛ'n kan yɩ́ ɛjɔlɛ kɛ Nyanmɩan nwan: Nɩan, mɩɩn sʋan sʋanlan kʋn wɔ́ nyunnun maan ɔ di mʋa ɔ sesie wɔ́ atɩn'n. ");
INSERT INTO any_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","“Mɩɩn kan yɩ́ ananhɔlɛ mɩn kele ɛmɔ kɛ mân ɛhɩ anun, bɛ wʋlɩ man sʋanlan bie m'ɔ tɩ kpili tala Zʋan ɔ. Nan kʋsʋ sʋanlan m'ɔ tɩ kaan Anwunno Belemgbin Mân nɩn anun'n, ɔ tɩ kpili tala Zʋan. ");
INSERT INTO any_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Ɔ fi mɛlɛ mɔ Zʋan mantanlɩn Nyanmɩan Anʋan Ɛjɔlɛ nɩn ɛhan dede m'ɔ ju ɛnɛ'n, Anwunno Belemgbin Mân'n lɛ tɛlɛ anwʋnsɛlɛ sʋ kpa. Nan ati anun ɛtɛ mma'n-mɔ a fa yɩ́ nwʋn ɛkpɔ kpa. ");
INSERT INTO any_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Nyanmɩan mgbɔmanfʋɛ'n-mɔ kʋalaa nʋn Moyizɩ mala'n, bɛ hanlɩn Anwunno Belemgbin Mân nɩn anwʋn ɛjɔlɛ dede ɔ juli Zʋan mɛlɛ sʋ. ");
INSERT INTO any_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Ɛmɔ lé li kɛ *Eli mɔ bɛ hanlɩn yɩ́ ɛwalɛ nɩn anwʋn ɛjɔlɛ'n y'ɔ le Zʋan. ");
INSERT INTO any_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Sʋanlan m'ɔ sɩ fasie'n, ɔ fá sie! ");
INSERT INTO any_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Nwan yɛ̂ n vá ajulisʋ menian'n-mɔ n zú yɩ́ ɔ? Bɛ tɩ kɛ mmatʋnman nganngan-mɔ mɔ bɛ tɩtɩ gua nɩn asʋ bɛ lɛ tɩan bɛ se bɛ́ manngʋn ɛhɩnlɩn-mɔ kɛ: ");
INSERT INTO any_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Y'a bɔ abile dede ɛmɔ a nzi man. Y'a tʋ ejue y'a bɔ ɛmɔ yalɛ sʋ, kʋsʋ ɛmɔ a nzɩsa man bɛ́ sa b'a ngua man bɛ́ ti b'a nzun man.’ ");
INSERT INTO any_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","“Afɩ Zʋan walɩ a, ɔ'a nni man yɩ́ nʋan nun ɛsɛ ɔ'a nnʋn man nzan. Menian'n-mɔ nwan: ‘Wawɛ ɛtɛ wɔ yɩ́ nun.’ ");
INSERT INTO any_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","*Mân Baa'n walɩ a, ɔ didi, ɔ nʋn nzan, ɛsɛ menian'n-mɔ nwan: ‘Bɛ nɩ́an, sʋanlan ɛhɩ dɩɛ, yɩ́ junman nɩn ala y'ɔ le alɩɛ elie nʋn nzan ɛnʋan. Yɩ́ manngʋn y'ɔ le bɛ́ mɔ bɛ dide ajule'n, ɔ nʋn ɛtɛfʋɛ'n-mɔ’. Nan mɔ Nyanmɩan a yɔ'n kele kɛ ɔ tɩ sɛsɛ sakpa.” ");
INSERT INTO any_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Kulo'n-mɔ mɔ Zozi yɔlɩ asinbɛnwʋn ninnge dɔʋn sʋ, mɔ ɛbɛlɛ menian'n-mɔ a nnun man bɛ́ nwʋn b'a ngaci man bɛ́ abalabɔ'n, Zozi tuli bɛ́ nyunnun. ");
INSERT INTO any_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Ɛmɔ Kolazɩn amma, munnzue hán ɛmɔ! Ɛmɔ Bɛtɩsayida amma, munnzue hán ɛmɔ! Afɩ sɛ ɔ tɩ kɛ asinbɛnwʋn ninnge'n-mɔ mɔ n yɔlɩ yɩ́ ɛmɔ afian'n, n yɔlɩ yɩ́ Tii nʋn Sidʋn kulo'n-mɔ asʋ a, ahan ndɛ-ndɛ kpa ɛbɛlɛ menian'n-mɔ wulalɩ kotoku bɛ bɔlɩ nzʋan bɛ helelɩ kɛ b'a nun bɛ́ nwʋn b'a kaci bɛ́ abalabɔ'n. ");
INSERT INTO any_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Ɛhɩka ati, mɩɩn kan mɩn kele ɛmɔ kɛ ndɛɛ ebua cɩan nɩn anun, yalɛ mɔ ɛmɔ 'nwun yɩ́'n, ɔ 'tala Tii nʋn Sidʋn menian'n-mɔ dɩɛ'n. ");
INSERT INTO any_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Ɛmɔ Kapɛɛnawɔmʋn amma, ɛmɔ kʋsʋ jʋnlɩn kɛ ɛmɔ 'kuku bɛ́ nwʋn sʋ dede bɛ nʋn Nyanmɩan sɛ ɔ? Bɛ 'kan ɛmɔ asɩ dede ɛmɔ kɔ sɩ̂n m'ɔ le man ayuelɩɛ nɩn anun. Afɩ sɛ ɔ tɩ kɛ asinbɛnwʋn ninnge'n mɔ n yɔlɩ yɩ́ ɛmɔ afian ɛbɛlɛ'n, n yɔlɩ yɩ́ Sodɔmʋn an, ahan ɛnɛ nʋn ɛnɛ, kulo sɔ'n tɛ wɔ ɛbɛlɛ. ");
INSERT INTO any_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Ɛhɩka ati, mɩɩn kan mɩn kele ɛmɔ kɛ ndɛɛ ebua cɩan nɩn anun, yalɛ mɔ ɛmɔ 'nwun yɩ́'n, ɔ 'tala Sodɔmʋn dɩɛ'n.” ");
INSERT INTO any_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Mɛlɛ sɔ nɩn anun, Zozi kukuli yɩ́ nʋan sʋ a, yɩ́ nwan: “Mɩ́n Sɩ, wɔ́ mɔ ɛ tɩ anwunno nʋn asɩɛ nɩn asʋ Mɩnlɩan'n, mɩn 'da wɔ́ asɩ. Ɔ sanlɩn kɛ a fa ninnge ɛhɩ-mɔ a fɩa ngɛlɛfʋɛ'n-mɔ, ɔ nʋn menian'n-mɔ mɔ bɛ sɩ ninnge dɔʋn'n, yɛ̂ a yɩ a hele mmatʋnman'n-mɔ. ");
INSERT INTO any_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Fɔ́ʋ́n, mɩ́n Sɩ, mɩn 'da wɔ́ asɩ, ɔ sanlɩn kɛ wɔ́ muonun ɛ hulolɩ yɩ́ sɔ. ");
INSERT INTO any_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","“Mɩ́n Sɩ a fa ninnge'n kʋalaa a wula mɩ́n sa nun. Sɛ nán Sɩɛ nɩn an, sʋanlan fɩ́ɩ́ nzɩ man Baa'n. Yɛ̂ sɛ nán Baa'n nʋn menian'n-mɔ mɔ Baa'n kulo kɛ ɔ yɩ Sɩɛ'n kele bɛ́ a, sʋanlan fɩ́ɩ́ nzɩ man Sɩɛ'n. ");
INSERT INTO any_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Ɛmɔ mɔ bɛ sʋ ninnge nʋnnɔɛ mɔ b'a fɛ'n, ɛmɔ bála mɩ́n nwʋn nán mɩn 'ba sike ɛmɔ maan bɛ de bɛ́ ɛnwʋnmɩan. ");
INSERT INTO any_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Ɛmɔ sɔ́ mɩ́n ngehele nɩn anun nán ɛmɔ mán n gékele bɛ́ ninnge. Ɔ sanlɩn kɛ n dɩ sʋanlan bɛtɛɛ, mɩ́n ti anun tɩ man ɛtɛ, nán mɩn 'ba man ɛmɔ de bɛ́ ɛnwʋnmɩan. ");
INSERT INTO any_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Mɩ́n ngehele'n mɔ mɩɩn kekele ɛmɔ'n, ɔ nyɔ man sɩ, ninnge'n mɔ mɩɩn kekele ɛmɔ'n, ɔ tɩ fɔtɩlɩfɔ”. ");
INSERT INTO any_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Ɛhɩ anzin, *ɛnwʋnmɩan ele cɩan kʋn, Zozi nʋn yɩ́ menian'n-mɔ kɔ kpɛ nun *bele ebo kʋn asʋ. Anɩn ɛhɔɛ lɛ kun yɩ́ menian'n-mɔ, nán b'a tɩtɩ bele'n bie b'a li. ");
INSERT INTO any_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Mɔ *Falisifʋɛ'n-mɔ nwunlin yɩ́ sɔ'n, bɛ kɔ han bɛ kɔ hele Zozi kɛ: “Nɩan, like mɔ yɛ́ mala'n tua yɛ́ kɛ nán yɛ yɔ yɩ́ ɛnwʋnmɩan ele cɩan'n, wɔ́ menian'n-mɔ yɔ.” ");
INSERT INTO any_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Ɛhɩ a, Zozi nwan: “Mɔ ɛhɔɛ hunlin *Davidi nʋn yɩ́ menian'n-mɔ'n, like'n mɔ bɛ yɔlɩ mɔ b'a hɛlɛ'n, ɛmɔ kɩnngalɩ man yɩ́ lé ɔ? ");
INSERT INTO any_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Ɔ nʋn yɩ́ menian'n-mɔ bɛ wʋlʋlɩ Nyanmɩan sua nɩn anun. Kpaʋn'n-mɔ mɔ b'a fa b'a man Nyanmɩan, mɔ yɛ́ mala'n kele kɛ sʋanlan fɩ́ɩ́ n'ɔ di bie kɛ Nyanmɩan *tɛɛyɩfʋɛ'n-mɔ ala'n, bɛ lili kpaʋn sɔ'n-mɔ. ");
INSERT INTO any_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Asʋ ɛmɔ kɩnngalɩ man yɩ́ Moyizɩ mala nɩn anun lé kɛ tɛɛyɩfʋɛ'n-mɔ mɔ bɛ di junman ɛnwʋnmɩan ele cɩan'n Nyanmɩan awulo nɩn anun'n, bɛ tʋn mala'n, kʋsʋ bɛ mmu man bɛ́ kɛ bɛ yɔ ɛtɛ ɔ? ");
INSERT INTO any_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Nan mɩɩn kan mɩn kele ɛmɔ kɛ sʋanlan kʋn wɔ ɛwa, ɔ tɩ kpili tala Nyanmɩan awulo'n. ");
INSERT INTO any_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Nyanmɩan hanlɩn kɛ: Mɩn kulo kɛ menian'n-mɔ nwun anwunnvoe bɛ́ afian ɔ tala tɛɛ ɛyɩɛ nɩn anwʋn ninnge'n mɔ bɛ yɔ bɛ man mɩ́n'n. Sɛ ɔ tɩ kɛ ɛmɔ tɩ ɛjɔlɛ ɛhɩ abʋ a, ahan ɛmɔ mmua man menian'n-mɔ kpɔfʋndɛɛ. ");
INSERT INTO any_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Ɔ sanlɩn kɛ *Mân Baa'n y'ɔ sie ɛnwʋnmɩan ele cɩan nɩn ɔ.” ");
INSERT INTO any_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Bɛ hanlɩn ɛhɩ m'ɔ yuelɩ'n, Zozi fi ɛbɛlɛ yɩ́ nʋan y'ɔ le bɛ́ asɔnɩn sua nɩn anun. ");
INSERT INTO any_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Anɩn bian kʋn wɔ asɔnɩn sua nɩn anun, yɩ́ sa kʋn a jɔ. Bɛ́ mɔ bɛ wɔ ɛbɛlɛ'n, bɛ kɔ bisa Zozi kɛ: “Asʋ yɛ́ mala'n kele kɛ yɛ mán wuluwafʋɛ bie anwʋn sá *ɛnwʋnmɩan ele cɩan nɩn ɔ?” Bɛ lɛ bisa yɩ́ sɔ bɛ nɩan m'ɔ kɔ bua'n, nán b'a jinlan sʋ b'a se kɛ ɔ'a tʋn mala. ");
INSERT INTO any_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Ɛhɩ a, Zozi nwan: “Sɛ ɛmɔ anun bie le yɩ́ bʋa kʋn nán sɛ ɔ tɔ kunman nun ɛnwʋnmɩan ele cɩan nɩn an, asʋ ɔ ngɔ ju man kunman nɩn anun ɔ ngɔ yɩ man yɩ́ ɔ? ");
INSERT INTO any_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Sʋanlan anwʋn cian tala bʋa! Yɩ́ ti, yɛ̂ mala'n kele kɛ ɛnwʋnmɩan ele cɩan'n, yɛ yɔ́ sʋanlan ye.” ");
INSERT INTO any_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Zozi kacili yɩ́ nyɩn wuluwafʋɛ nɩn anwʋn ɛlɔ a, yɩ́ nwan: “Tɩnngɛ wɔ́ sa nɩn anun.” Bian'n 'tɩnngɛ yɩ́ sa nɩn anun an, asaa kɔ tɩnngɛ fɔ́ʋ́n kɛ nunhan kʋn'n. ");
INSERT INTO any_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Mɔ Falisifʋɛ'n-mɔ nwunlin mɔ Zozi a yɔ'n, bɛ kɔ hɔ yɩ́ ti ahuan, bɛ lɛ kpʋnndɛ atɩn mɔ bɛ sɩn sʋ a, bɛ kɔ nyan yɩ́ bɛ kɔ hun yɩ́'n. ");
INSERT INTO any_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Mɔ Zozi tɩlɩ kɛ bɛ lɛ kpʋnndɛ yɩ́ bɛ kun yɩ́'n, ɔ fi ɛbɛlɛ lɩka sɔ'n ɔ jasʋlɩ. Mɔ ɔ 'kɔ'n, menian dɔʋn kpa sili yɩ́ sʋ. Ɔ manlɩn nwuluwafʋɛ'n-mɔ kʋalaa anwʋn salɩ. ");
INSERT INTO any_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Nan kʋsʋ ɔ totualɩ bɛ́ kɛ nán bɛ kɔ bɔ yɩ́ nwʋn kpayɛ kɛ yɩ́ yɛ̂ ɔ'a man b'a tɩ akpɔlɛ ɔ. ");
INSERT INTO any_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Ɔ man Nyanmɩan kpɔmanfʋɛ *Ezayi ɛjɔlɛ'n m'ɔ hanlɩn'n kpɩnlɩn sʋ. Ɔ hanlɩn kɛ Nyanmɩan nwan: ");
INSERT INTO any_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Nɩan, mɩ́n akʋa'n mɔ m'an yɩ yɩ́'n, mɩn kulo yɩ́ m'an fa mɩ́n lʋa'n kʋalaa m'an wula yɩ́ nun. Mɩn 'fa mɩ́n Wawɛ'n mɩn wula yɩ́ nun, ɔ 'kan mɩ́n ndɛɛ ebua nɩn anwʋn ɛjɔlɛ ɔ kele mân mân'n-mɔ. ");
INSERT INTO any_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Ɔ nʋn sʋanlan fɩ́ɩ́ bɛ ngɔ su man akpʋlʋwa lé, ɔ ngɔ tɛtɩan man lé, bɛ ngɔ tɩ man yɩ́ ngan gua sʋ lé. ");
INSERT INTO any_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Ndɛɛ'n mɔ ɔ'a bɩlɩ'n, ɔ mmu man nun, kanlannɩɛ mʋnnzʋn-mʋnnzʋn'n, ɔ nnuan man yɩ́. Ɔ 'yɔ sɔ dede ɔ man ananhɔlɛ'n di kunnunmun. ");
INSERT INTO any_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Mân mân'n-mɔ kʋalaa 'ba susu bɛ́ ti bɛ gua yɩ́ sʋ. ");
INSERT INTO any_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Ɛhɩ, bɛ kɔ fa sʋanlan kʋn bɛ kɔ bɛlɛ Zozi. Sʋanlan sɔ'n, wawɛ ɛtɛ wɔ yɩ́ nun, ɔ'a man yɩ́ nyɩn nɩn a sin ɛsɛ ɔ a tɔ amunle. Zozi kɔ man sʋanlan sɔ'n kɔ jʋjɔ ɛsɛ ɔ kɔ nwun asɩ. ");
INSERT INTO any_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Ɛjɔlɛ'n sinlin menian'n-mɔ kʋalaa anwʋn, bɛ́ nwan: “Asʋ nán belemgbin *Davidi anʋnman nɩn an?” ");
INSERT INTO any_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Nan mɔ *Falisifʋɛ'n-mɔ tɩlɩ ɛjɔlɛ sɔ'n, bɛ́ nwan: “*Bɛlɩzebulu m'ɔ tɩ mmɔnsanmʋn'n-mɔ kpain'n, yɩ́ yɛ̂ ɔ'a man sʋanlan ɛhɩ tunmin m'ɔ fa fʋan wawɛ ɛtɛ'n-mɔ ɔ.” ");
INSERT INTO any_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Kɛmɔ anɩn Zozi sɩ ajʋnlɩn'n m'ɔ wɔ bɛ́ ti nɩn anun'n, ɔ kɔ han kɔ hele bɛ́ kɛ: “Belemgbin mân kʋn mɔ nun menian'n-mɔ kpɛ bɛ́ nyɩn bɛ kʋn ɛlɔɛ'n, mân sɔ'n bɔ. Kulo kʋn, anaan afilie kʋn mɔ nun menian'n-mɔ kpɛ bɛ́ nyɩn bɛ kʋn ɛlɔɛ'n, kulo sɔ'n, anaan afilie sɔ nɩn abʋsʋ bɔ. ");
INSERT INTO any_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Sɛ *Satan fʋan m'ɔ tɩ yɩ́ dɩɛ nɩn an, anɩn ɔ nʋn yɩ́ nwʋn lɛ kʋn, ɔ 'yɔ sɛ nán yɩ́ mân nɩn a hɔ yɩ́ nyunnun? ");
INSERT INTO any_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Sɛ ɛmɔ jʋnlɩn kɛ Belɩzebulu yɛ̂ ɔ man mɩ́n tunmin maan mɩn fa mɩn fʋan wawɛ ɛtɛ'n-mɔ a, anɩn ɛmɔ menian'n-mɔ dɩɛ, nwan yɛ̂ ɔ man bɛ́ tunmin maan bɛ fʋan wawɛ ɛtɛ'n-mɔ ɔ? Ɛmɔ menian'n-mɔ kele kɛ ɛmɔ di fʋɔ. ");
INSERT INTO any_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Nan sɛ Nyanmɩan Wawɛ'n yɛ̂ mɩn fa mɩn fʋan wawɛ ɛtɛ'n-mɔ a, anɩn ɔ kele kɛ Nyanmɩan Belemgbin elie mɛlɛ nɩn a tʋ ɛmɔ. ");
INSERT INTO any_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Sʋanlan mɔ yɩ́ nwʋn yɔ sɩ kpa'n, sʋanlan fɩ́ɩ́ ngʋala man kɛ ɔ kɔ wʋlʋ yɩ́ sua nɩn anun ɔ wua yɩ́ ninnge nɩn ɔ. Sannan ɔ 'di mʋa ɔ cɩcɩ yɩ́ kʋalaaka nán ɔ'a hʋala yɩ́ wua. ");
INSERT INTO any_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Sʋanlan m'ɔ tɩ man mɩ́n dɩɛ'n, anɩn ɔ kpɔ mɩ́n. Sʋanlan kʋsʋ m'ɔ nʋn mɩn ngohuan man ninnge'n-mɔ anʋan'n, sʋanlan sɔ'n, anɩn ɔ bɔ bɛ́ asanndɩɛ. ");
INSERT INTO any_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Yɩ́ sɔ ati, mɩɩn kan mɩn kele ɛmɔ kɛ: Ɛtɛ biala mɔ sʋanlan kɔ yɔ'n, ɔ nʋn ɛjɔlɛ ɛtɛ biala mɔ sʋanlan kɔ han'n, Nyanmɩan kʋala kɛ ɔ fa yɩ́ nwʋn sa ɔ ce yɩ́. Nan sʋanlan m'ɔ kɔ han ɛjɔlɛ ɛtɛ kɔ tia Wawɛ Nwannzan-nwannzan'n, Nyanmɩan nva man yɩ́ ɛtɛ'n ɔ nje man yɩ́ lé. ");
INSERT INTO any_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Sʋanlan biala m'ɔ kɔ han ɛjɔlɛ kɔ tia mân Baa'n, Nyanmɩan 'fa yɩ́ nwʋn sa ɔ ce yɩ́. Nan sʋanlan biala m'ɔ kɔ han ɛjɔlɛ ɛtɛ ɔ kɔ tia Wawɛ Nwannzan-nwannzan'n, Nyanmɩan nva man yɩ́ ɛtɛ'n ɔ nje man yɩ́ mɛlɛ ɛhɩ anun ɔ nʋn mɛlɛ'n m'ɔ lɛ ba nɩn anun.” ");
INSERT INTO any_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Baka kpa nɩn asʋ yɛ̂ bɛ tɩ mma kpa nɩn ɔ. Baka ɛtɛ nɩn asʋ kʋsʋ yɛ̂ bɛ tɩ mma ɛtɛ nɩn ɔ. Ɔ sanlɩn kɛ baka kʋn m'ɔ jin'n, sɛ ɔ tɩ kpa o, sɛ ɔ tɩ ɛtɛ o, yɩ́ mma m'ɔ kɔ su'n yɛ̂ bɛ fa bɛ nwun yɩ́ ɔ. ");
INSERT INTO any_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Ati anun ɛtɛ mma kɛ owo, ɔ 'yɔ sɛ nán ɛmɔ a han ɛjɔlɛ kpa? Afɩ ɛjɔlɛ m'ɔ wɔ ahʋnlɩn nɩn anun'n, y'ɔ fite bɛ́ nʋan ɔ. ");
INSERT INTO any_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Sʋanlan mɔ yɩ́ ti anun tɩ kpa'n, ɛjɔlɛ m'ɔ tɩ kpa'n yɛ̂ ɔ fi yɩ́ nʋan fite ɔ. Sʋanlan kʋsʋ mɔ yɩ́ ti anun tɩ ɛtɛ'n, ɛjɔlɛ ɛtɛ yɛ̂ ɔ fi yɩ́ nʋan fite ɔ. ");
INSERT INTO any_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Mɩɩn kan mɩn kele ɛmɔ kɛ: Ndɛɛ ebua cɩan nɩn anun, mgban-mgban ɛjɔlɛ'n mɔ menian'n-mɔ hanlɩn'n, bɛ 'nwun yɩ́ nwʋn ɛjɔlɛ. ");
INSERT INTO any_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Afɩ ɛjɔlɛ m'ɔ fi wɔ́ nʋan kɔ fite'n, yɩ́ nwʋn yɛ̂ bɛ 'nɩan bɛ bua wɔ́ ndɛɛ ɔ.” ");
INSERT INTO any_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Mɔ Zozi hanlɩn sɔ yuelɩ'n, *mala nɩn asʋ mgbain'n mmie-mɔ nʋn *Falisifʋɛ'n mmie-mɔ kɔ han kɔ hele Zozi kɛ: “Kpain, yɛ kulo kɛ ɛ yɔ asinbɛnwʋn like kʋn maan yɛ nɩan.” ");
INSERT INTO any_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Ɛhɩ a, Zozi nwan: “Ajulisʋ menian ɛtɛfʋɛ ɛhɩ-mɔ mɔ bɛ nzʋ man Nyanmɩan ananhɔlɛ nun'n lɛ kpʋnndɛ asinbɛnwʋn like bɛ nɩan. Bɛ nyɔ man asinbɛnwʋn like fɩ́ɩ́ kʋ́n bɛ ngele man bɛ́ kɛ Nyanmɩan kpɔmanfʋɛ Zonasɩ dɩɛ nɩn ala. ");
INSERT INTO any_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Afɩ kɛmɔ Zonasɩ lili cɩan nsan ejue kpili nɩn akunnun'n, yɩ́ sɔ kʋsʋ ala, *Mân Baa'n 'ba li cɩan nsan asɩɛ nɩn abʋ. ");
INSERT INTO any_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Ndɛɛ ebua cɩan nɩn anun, Ninninvʋ amma'n-mɔ 'bu ajulisʋ menian'n-mɔ fʋɔ. Ɔ sanlɩn kɛ mɔ Ninninvʋ kulo nɩn asʋ amma'n-mɔ tɩlɩ Nyanmɩan Anʋan Ɛjɔlɛ'n mɔ Zonasɩ hanlɩn'n, bɛ nunlin bɛ́ nwʋn bɛ kacili bɛ́ abalabɔ'n. Nan sʋanlan kʋn wɔ ɛwa, ɔ tɩ kpili tala Zonasɩ. ");
INSERT INTO any_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Ndɛɛ ebua cɩan nɩn anun, balasua'n m'ɔ tɩ Saba mân nɩn asʋ belemgbin'n, ɔ 'bu ajulisʋ menian'n-mɔ fʋɔ. Ɔ sanlɩn kɛ yɩ́ m'ɔ fi mʋa'n, ɔ walɩ tielɩ Salomʋn bɛngɛlɛfʋɛ ɛjɔlɛ'n m'ɔ kan'n. Nan kʋsʋ sʋanlan kʋn wɔ ɛwa, ɔ tɩ kpili tala Salomʋn. ");
INSERT INTO any_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Mɛlɛ mɔ wawɛ ɛtɛ kʋn fi sʋanlan kʋn anun kɔ fite'n, ɔ kɔ kpʋnndɛ lɩka wʋwʋsɩɩ'n-mɔ ɔ tanlan de yɩ́ ɛnwʋnmɩan. ");
INSERT INTO any_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Sɛ ɔ kpʋnndɛ nán ɔ'a nnyan man bie a, anɩn yɩ́ nwan: ‘Man n zá mɩ́n nzin n gɔ́ mɩ́n lɩka daba'n mɔ n vi n jasʋlɩ'n.’ Sɛ ɔ sa ba nán ɔ nwun kɛ sua'n tɩ to, b'a kpɔkpʋan nun b'a sesie nun kanlanman kpa a, ");
INSERT INTO any_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","ɔ sa yɩ́ nzin ɔ kɔ kpʋnndɛ yɩ́ manngʋn nsʋ mɔ bɛ́ ti anun tɩ ɛtɛ kpa bɛ tala yɩ́ ɔ. Ɔ nʋn bɛ ba a tanlan ɛbɛlɛ. Sian dɩɛ, sʋanlan sɔ'n, ɛsɛcɩɛ m'ɔ kɔ sɛcɩ'n, ɔ tala daba'n. Kɛ ajulisʋ menian ɛtɛfʋɛ ɛhɩ-mɔ asɩtanlan'n 'yɔ yɩ́ nɩn ala anɩn.” ");
INSERT INTO any_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Zozi anʋan a ndɔ man, yɩ́ nianman'n-mɔ nʋn yɩ́ nin bɛ kɔ a. Anɩn bɛ jijin gua nɩn asʋ bɛ 'kpʋnndɛ atɩn bɛ kan ɛjɔlɛ bɛ kele yɩ́. ");
INSERT INTO any_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Sʋanlan kʋn kɔ han kɔ hele yɩ́ kɛ: “Nɩan, wɔ́ nin nʋn wɔ́ nianman'n-mɔ jijin gua sʋ ɛlɔ bɛ 'kpʋnndɛ kɛ bɛ kan ɛjɔlɛ bɛ kele wɔ́.” ");
INSERT INTO any_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Zozi kɔ bua sʋanlan sɔ'n kɛ: “Mɩ́n nin'n y'ɔ le nwan, yɛ̂ mɩn nianman'n-mɔ y'ɔ le nwan-mɔ?” ");
INSERT INTO any_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Nan ɔ tɩnngɛlɩ yɩ́ sa yɩ́ menian'n-mɔ anwʋn an, yɩ́ nwan: “Ɛmɔ nɩ́an, mɩ́n nin nʋn mɩ́n nianman'n-mɔ, bɛ́ yɛ̂ bɛ gugua ɛwa nɩn ɔ. ");
INSERT INTO any_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Ɔ sanlɩn kɛ sʋanlan m'ɔ yɔ mɩ́n Sɩ'n m'ɔ wɔ anwunno ɛlɔ nɩn akunnun like'n, sʋanlan sɔ'n tɩ mɩ́n nianman belenzua, ɔ tɩ mɩ́n nianman balasua, ɔ tɩ mɩ́n nin.” ");
INSERT INTO any_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Cɩan sɔ'n, Zozi fi yɩ́ awulo ɛbɛlɛ ɔ kɔ hɔ asue nɩn anʋan ɛlɔ. Ɔ kɔ tanlan asɩ, ɔ kɔ hehele menian'n-mɔ Nyanmɩan ninnge. ");
INSERT INTO any_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Meninsʋnman kɔ a yɩ́ nwʋn ɛbɛlɛ. Ɔ kɔ kpati kɔ fʋ kɔ tanlan ɛlɛɛ kʋn anun asue nɩn anyɩnsʋ yɛ̂ meninsʋnman'n jijin asue nɩn anʋan. ");
INSERT INTO any_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Ɔ kɔ hehele bɛ́ ninnge dɔʋn kpa anyɩnndala nun, yɩ́ nwan: “Sʋanlan kʋn hɔlɩ yɩ́ *bele mma egua. ");
INSERT INTO any_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Mɛlɛ mɔ ɔ 'gua'n, bie kɔ gua atɩn nɩn anʋan, nnʋnman'n-mɔ kɔ a kɔ suso kɔ li. ");
INSERT INTO any_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Bie kʋsʋ kɔ gua nyɔbʋɛ nɩn asʋ. Ɛbɛlɛ ngɛtɩɛ nɩn a nzʋn man. Ɔ kɔ fifi ndɛ-ndɛ. Ɔ sanlɩn kɛ ɔ'a ngɔ man asɩɛ bʋ. ");
INSERT INTO any_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Nan mɔ eyua'n fili'n, ɔ kɔ yala, afɩ ɔ'a nzɔ man ndɩan. ");
INSERT INTO any_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Bie kʋsʋ kɔ gua eminlan mmowe nɩn anun. Ɔ kɔ fifi. Eminlan mmowe'n kɔ fʋ kɔ gua sʋ. ");
INSERT INTO any_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Nan bie kʋsʋ kɔ gua asɩɛ kpa nɩn asʋ, ɔ kɔ fifi. Ɔ kɔ su mma. Bie kɔ su mma ɛya kʋn, bie mma abulasian, bie kʋsʋ mma abulasan.” ");
INSERT INTO any_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Zozi kɔ han kɔ tʋ sʋ kɛ: “Sʋanlan m'ɔ sɩ fasie'n, ɔ fá síe!” ");
INSERT INTO any_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Ɛhɩ, Zozi menian'n-mɔ kpunngelɩ yɩ́ a, bɛ́ nwan: “Nzukɛ ati yɛ̂ ɛ 'kan ɛjɔlɛ kele menian'n-mɔ a, ɛ bu yɩ́ anyɩnndala nun ɔ?” ");
INSERT INTO any_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Zozi kɔ bua bɛ́ kɛ: “Nyanmɩan Belemgbin Mân nɩn anun nvɩalɩɛ ninnge'n-mɔ, ɛmɔ sɩ yɩ́ nwʋn ɛjɔlɛ. Nan bɛ́ dɩɛ, bɛ nzɩ man yɩ́ nwʋn ɛjɔlɛ. ");
INSERT INTO any_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Ɔ sanlɩn kɛ sʋanlan m'ɔ le bie'n, bɛ 'gua sʋ maan ɔ sʋn. Nan sʋanlan m'ɔ le man bie'n, kaan'n muonun m'ɔ le yɩ́'n, bɛ 'tʋa yɩ́ bɛ de. ");
INSERT INTO any_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Ɛhɩka ati yɛ̂ mɩn 'kan ɛjɔlɛ mɩn kele bɛ́ a, mɩn bu yɩ́ anyɩnndala nun ɔ. Afɩ bɛ́ nyɩn tua yɩ́, kʋsʋ bɛ nnwun man yɩ́. Bɛ tɩ, kʋsʋ bɛ ndie man nán b'a tɩ yɩ́ bʋ. ");
INSERT INTO any_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Ɔ man bɛ́ nwʋn ɛjɔlɛ'n mɔ *Ezayi hanlɩn'n kpɩnlɩn sʋ. Nyanmɩan nanndɩlɩ Ezayi sʋ ɔ hanlɩn kɛ: Ɛmɔ 'ba tie yɩ́ kpa, kʋsʋ ɛmɔ ngɔ tɩ man yɩ́ bʋ. Ɛmɔ 'ba nɩan yɩ́ kpa, kʋsʋ ɛmɔ ngɔ nwun man yɩ́. ");
INSERT INTO any_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Ɔ sanlɩn kɛ menian sɔ'n-mɔ a sʋlʋ. B'a totua bɛ́ nzʋ'n b'a momuan bɛ́ nyɩn'n. Yɩ́ dɩɛ, anɩn bɛ nnwun man asɩ, ɛsɛ bɛ́ nzʋ'n ndɩ man ɛjɔlɛ. Bɛ nza bɛ mma man mɩ́n nwʋn nán m'an man bɛ́ nwʋn a sa. ");
INSERT INTO any_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“Nan ɛmɔ dɩɛ, nyila hán ɛmɔ. Ɔ sanlɩn kɛ ɛmɔ anyɩn'n nwun asɩ, ɛsɛ ɛmɔ anzʋ'n tɩ ɛjɔlɛ. ");
INSERT INTO any_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Nan mɩɩn kan yɩ́ ananhɔlɛ mɩn kele ɛmɔ kɛ: Nyanmɩan mgbɔmanfʋɛ dɔʋn kpa, nʋn Nyanmɩan menian dɔʋn kpa, bɛ hulolɩ kɛ ahan bɛ nwun mɔ ɛmɔ lɛ nɩan'n, nan kʋsʋ b'a nnwun man yɩ́. Ɛsɛ bɛ hulolɩ kɛ ahan bɛ tɩ mɔ ɛmɔ lɛ tie'n, nan kʋsʋ b'a ndɩ man.” ");
INSERT INTO any_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Ɛhɩ, Zozi nwan: “Ɛmɔ tíe, sʋanlan'n m'ɔ gua *bele nɩn anwʋn anyɩnndala nɩn abʋ'n y'ɔ le kɛ: ");
INSERT INTO any_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Mɛlɛ mɔ sʋanlan kʋn kɔ tɩ Anwunno Belemgbin Mân nɩn anwʋn ɛjɔlɛ m'ɔ ndɩ man yɩ́ bʋ'n, anɩn sʋanlan sɔ'n tɩ kɛ bele mma'n m'ɔ gualɩ atɩn nɩn anʋan'n. Ɛjɔlɛ'n mɔ ɔ'a tɩ'n, Abɔnsanmʋn ba ɔ yɩ fi yɩ́ ti anun. ");
INSERT INTO any_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Bele mma'n m'ɔ gualɩ lɩka mɔ nyɔbʋɛ'n wɔ'n y'ɔ le sʋanlan ɛhɩ m'ɔ tɩ Anwunno Belemgbin Mân nɩn anwʋn ɛjɔlɛ nɩn an, ɔ le fɛ elie ɔ ka ɛbɛlɛ ɔ sɔ nun'n. ");
INSERT INTO any_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Sʋanlan sɔ'n mman man ɛjɔlɛ'n nzɔ man ndɩan yɩ́ nun. Ɔ de di mɛlɛ kaan bie. Ɛjɔlɛ sɔ'n dunman nun, sɛ bɛ kele yɩ́ ahʋlʋwa anaan ɔ nwun yalɛ kaan ala a, anɩn yɩ́ eyue ɔ. ");
INSERT INTO any_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","M'ɔ gualɩ eminlan mmowe nɩn anun'n y'ɔ le sʋanlan ɛhɩ m'ɔ tɩ Anwunno Belemgbin Mân nɩn anwʋn ɛjɔlɛ'n, nan kʋsʋ eyuadɩ nɩn anun ninnge'n-mɔ anwʋn nzusue'n nʋn anyɩnbʋlʋ anyanbɛnwʋn'n cɩcɩ ɛjɔlɛ sɔ'n. Ɔ man ɔ nzu man mma. ");
INSERT INTO any_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","M'ɔ gualɩ asɩɛ kpa nɩn asʋ'n y'ɔ le sʋanlan ɛhɩ m'ɔ tɩ Anwunno Belemgbin Mân nɩn anwʋn ɛjɔlɛ nɩn an, ɔ tɩ yɩ́ bʋ'n. Ɔ su mma. Bie su ɛya kʋn, bie su abulasian, bie kʋsʋ su abulasan.” ");
INSERT INTO any_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Ɛhɩ anzin, Zozi kɔ bu anyɩnndala kʋn biekun kɔ hele bɛ́. Yɩ́ nwan: “Ɛ 'nwun like mɔ Anwunno Belemgbin Mân'n soman yɩ́'n: Ɔ soman sʋanlan kʋn mɔ ɔ'a gua *bele yɩ́ ebo nɩn asʋ ɔ. ");
INSERT INTO any_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Nan kɔngɔɛ mɔ menian'n-mɔ kʋalaa yuelɩ dɩda'n, yɩ́ kpɔfʋɛ kʋn kɔ a kɔ lolua ndile ɛtɛ bele nɩn anun, cuein yɛ̂ ɔ hɔlɩ ɔ. ");
INSERT INTO any_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Bele'n fifili dede mɔ ɔ 'ju yɩ́ esúe tɛmʋn'n, ndile ɛtɛ'n kɔ fa ebo'n. ");
INSERT INTO any_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","“Sʋanlan'n m'ɔ le ebo nɩn ajunmanfʋ'n-mɔ walɩ tʋlɩ yɩ́, bɛ́ nwan: ‘Yɛ́ Mɩn, bele yɛ̂ ɛ lualɩ ɔ. Nan ndile ɛtɛ'n mɔ ɔ'a fifi nun'n, ɔ fi nin?’ ");
INSERT INTO any_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","“Mɩnlɩan'n nwan: ‘Kpɔfʋɛ bie yɛ̂ ɔ'a li junman sɔ nɩn ɔ.’ “Ɛhɩ a, ajunmanfʋ'n-mɔ kɔ bisa yɩ́ kɛ: ‘Ɛ kulo kɛ yɛ hɔ́ tútu ndile ɛtɛ nɩn ɔ?’ ");
INSERT INTO any_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","“Mɩnlɩan'n nwan: ‘Cɛcɛ, sɛ ɛmɔ tutu a, bɛ 'ba tutu bele'n bɛ bʋka sʋ. ");
INSERT INTO any_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Nan ɛmɔ mán ɔ há nun dede ɔ jú bele nɩn ɛtɩɛ tɛmʋn. Sɛ ɔ ju yɩ́ ɛtɩɛ tɛmʋn an, mɩn 'kan mɩn kele bɛ́ mɔ bɛ 'tɩ'n kɛ: Ɛmɔ lí mʋa bɛ tútu ndile ɛtɛ nɩn abʋ bɛ cɩ́cɩ yɩ́ bɔ́lɛ bɔ́lɛ bɛ tʋ́ nun sɩ̂n bɛ yála yɩ́. Sian'n, ɛmɔ tɩ́ bele'n bɛ hɔ́ wúla yɩ́ mɩ́n ésie nɩn anun.’” ");
INSERT INTO any_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Zozi kɔ bu anyɩnndala biekun kɔ hele bɛ́, yɩ́ nwan: “Anwunno Belemgbin Mân'n, ɔ tɩ kɛ muntadɩ baa mɔ sʋanlan a fa a hɔ a lua yɩ́ ebo sʋ ɔ. ");
INSERT INTO any_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Ninnge mma'n mɔ bɛ dua'n, yɩ́ y'ɔ tɩ bɛ́ nunhan kaan kpa nɩn ɔ. Nan kʋsʋ sɛ ɔ fifi a, ɔ nyin tala ninnge mma'n-mɔ kʋalaatin. Ɔ kaci dukpa nnʋnman'n-mɔ ba bɛ nwʋn bɛ́ sâ yɩ́ sa mma'n-mɔ asʋ.” ");
INSERT INTO any_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Zozi kɔ bu anyɩnndala kʋn biekun kɔ hele bɛ́. Yɩ́ nwan: “Anwunno Belemgbin Mân'n tɩ kɛ balasua kʋn mɔ ɔ'a fa fali ayile ɔ'a fɔtɔ fali cilo abulaa nʋn nnun ɔ. Ɔ wɔ ɛbɛlɛ dede fali nɩn a tu.” ");
INSERT INTO any_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Ɛjɔlɛ ɛhɩ kʋalaa mɔ ɔ 'kan kele menian'n-mɔ'n, ɔ bu yɩ́ anyɩnndala nun. Sɛ ɔ'a mmun man anyɩnndala a, ɔ ngan man ɛjɔlɛ'n ɔ ngele man bɛ́. ");
INSERT INTO any_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Ɛhɩ m'ɔ yɔlɩ'n manlɩn ɛjɔlɛ'n mɔ Nyanmɩan kpɔmanfʋɛ'n hanlɩn'n kpɩnlɩn sʋ. Nyanmɩan manlɩn kpɔmanfʋɛ'n hanlɩn kɛ: Mɩn 'bu anyɩnndala nán m'an han ɛjɔlɛ'n m'an hele bɛ́. Sunmin kɛ bɛ bɔlɩ mân'n, ninnge m'ɔ wɔ nvɩalɩɛ nun'n, mɩn 'bɔ yɩ́ nwʋn ɛjɔlɛ. ");
INSERT INTO any_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Mɔ Zozi hanlɩn sɔ yuelɩ'n, ɔ gualɩ meninsʋnman nɩn atɩn yɛ̂ ɔ hɔlɩ awulo ɔ. Yɩ́ menian'n-mɔ kpunngelɩ yɩ́ a, bɛ́ nwan: “Tu ndile ɛtɛ'n m'ɔ fifi ebo nɩn asʋ nɩn anwʋn anyɩnndala nɩn abʋ kele yɛ́.” ");
INSERT INTO any_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Zozi nwan: “Sʋanlan'n m'ɔ le gua *bele mma kpa'n y'ɔ le *Mân Baa'n. ");
INSERT INTO any_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Ebo'n y'ɔ le mân'n. Bele mma kpa'n y'ɔ le bɛ́ mɔ bɛ́ tɩ Anwunno Belemgbin Mân nɩn anun menian'n. Ndile ɛtɛ'n, y'ɔ le bɛ́ mɔ bɛ tɩ Abɔnsanmʋn menian'n. ");
INSERT INTO any_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Kpɔfʋɛ'n mɔ ɔ'a lua ndile ɛtɛ'n y'ɔ le Abɔnsanmʋn. Bele mma nɩn ɛtɩɛ tɛmʋn'n y'ɔ le mân nɩn ayuelɩɛ nun, yɛ̂ bɛ́ mɔ bɛ 'tɩ ebo'n y'ɔ le nyanmɩansʋ mmɔfʋɛ'n-mɔ. ");
INSERT INTO any_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","“Kɛmɔ bɛ tutu ndile ɛtɛ nɩan an, bɛ gua yɩ́ sɩ̂n nɩn anun'n, sɛ mân nɩn ayuelɩɛ'n ju a, kɛ bɛ 'yɔ yɩ́ nɩn anɩn. ");
INSERT INTO any_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Mân Baa'n 'sʋan yɩ́ nyanmɩansʋ mmɔfʋɛ'n-mɔ maan bɛ yɩ bɛ́ kʋalaa mɔ bɛ man ɛhɩnlɩn-mɔ tɔ ɛtɛ nɩn anun ɔ nʋn bɛ́ mɔ bɛ yɔ ɛtɛ'n fi yɩ́ Belemgbin Mân nɩn anun. ");
INSERT INTO any_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Bɛ yɩ bɛ́ a, bɛ 'gua bɛ́ sɩ̂n gɔhɩɩn nɩn anun. Ɛbɛlɛ yɛ̂ bɛ 'sun bɛ kʋan bɛ́ je nɩn ɔ. ");
INSERT INTO any_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Nan menian mɔ bɛ́ nyɩn sɔ Nyanmɩan'n, bɛ 'ta bɛ́ Sɩ Belemgbin Mân nɩn anun kɛ sɛnzɛ m'ɔ lɛ ta ɔ. M'ɔ sɩ fasie'n, ɔ fá sie!” ");
INSERT INTO any_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Ɛhɩ, Zozi nwan: “Anwunno Belemgbin Mân'n tɩ kɛ esika kɔkɔlɛ m'ɔ fɩa ebo kʋn asʋ. Sʋanlan m'ɔ kɔ fite sʋ'n, yɩ́ kʋsʋ ɔ fa fɩa biekun. Ɔ di fɛ, ɔ tɔnɩn yɩ́ nwʋn ninnge'n kʋalaatin ɔ to ebo sɔ'n. ");
INSERT INTO any_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Ɛsɛ Anwunno Belemgbin Mân'n tɩ kɛ watafʋɛ kʋn m'ɔ lɛ kpʋnndɛ afile nganlanman to ɔ. ");
INSERT INTO any_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Mɛlɛ m'ɔ kɔ nwun kʋn m'ɔ tɩ kpa'n, ɔ kɔ tɔnɩn yɩ́ nwʋn ninnge'n kʋalaatin ɔ to afile sɔ'n. ");
INSERT INTO any_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Ɛsɛ Anwunno Belemgbin Mân'n tɩ kɛ dada mɔ bɛ gua yɩ́ jenvie nɩn anun ɔ. Ejue ngacile kʋalaa wʋlʋ nun. ");
INSERT INTO any_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Ɔ yi a, bɛ hyʋhyʋɩn gua fie bɛ tanlan asɩ bɛ kpa ejue'n-mɔ anun. Bɛ gua mgbakpa'n-mɔ ece nun yɛ̂ ɛtɛ ɛtɛ'n-mɔ, bɛ ju bɛ gua. ");
INSERT INTO any_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Mân nɩn ayuelɩɛ nun kɛ ɔ 'ba yɔ yɩ́ nɩn anɩn. Nyanmɩansʋ mmɔfʋɛ'n-mɔ 'ba sie menin mgbakpa'n-mɔ ebue kʋn ");
INSERT INTO any_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","bɛ gua ɛtɛfʋɛ'n-mɔ sɩ̂n gɔhɩɩn nɩn anun. Ɛbɛlɛ yɛ̂ bɛ 'sun bɛ kʋan bɛ́ je nɩn ɔ.” ");
INSERT INTO any_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Zozi kɔ bisa yɩ́ menian'n-mɔ kɛ: “Asʋ ɛmɔ a tɩ ɛjɔlɛ ɛhɩ-mɔ abʋ ɔ?” Bɛ́ nwan: “Yuo o!” ");
INSERT INTO any_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Ɛhɩ a, Zozi nwan: “Ɛhɩka ati, mala nɩn asʋ kpain biala m'ɔ kɔ kaci Anwunno Belemgbin Mân nɩn anun sʋanlan'n, anwʋndɩɛ'n m'ɔ nyan yɩ́'n, ninnge nvʋfɔlɛ wɔ nun yɛ̂ nnaba kʋsʋ wɔ nun.” ");
INSERT INTO any_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Mɔ Zozi yuelɩ anyɩnndala ɛhɩ-mɔ bubu'n, ɔ fi ɛbɛlɛ ");
INSERT INTO any_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","ɔ kɔ hɔ kulo'n mɔ bɛ talɩ yɩ́ nɩn asʋ. Ɔ kɔ wʋlʋ asɔnɩn sua nɩn anun ɔ kɔ hehele ɛbɛlɛ menian'n-mɔ ninnge, ɛjɔlɛ'n kɔ sin bɛ́ kʋalaa mɔ bɛ wɔ ɛbɛlɛ nɩn anwʋn kpa. Bɛ́ nwan: “Ɔ nyanlin ngɛlɛ ɛhɩ nin? Tunmin benin yɛ̂ ɔ fa yɔ asinbɛnwʋn ninnge ɛhɩ-mɔ ɔ? ");
INSERT INTO any_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Nán junnvʋɛ nɩn awa belenzua nɩn ɔ? Nán yɩ́ nin y'ɔ le Mali ɔ? Nán yɩ́ nianman mmelenzua'n-mɔ y'ɔ le Zʋakɩ, Zozɛfʋ, Simʋn nʋn Zudɩ ɔ? ");
INSERT INTO any_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Yɩ́ nianman mmalasua'n-mɔ kʋalaa, bɛ nnʋn man yɛ́ yɛ̂ ɔ gua ɛwa ɔ? Ɔ nʋn tunmin ɛhɩ kʋalaa fi nin?” ");
INSERT INTO any_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Ajʋnlɩn sɔ'n m'ɔ wɔ bɛ́ ti anun'n maan b'a nnwun man asɩ b'a nne man Zozi b'a nni man. Ɛhɩ a, Zozi kɔ han kɔ hele bɛ́ kɛ: “Nyanmɩan kpɔmanfʋɛ kʋn, yɩ́ kulo nɩn asʋ nʋn yɩ́ afilie nɩn anun menian'n-mɔ mmu man yɩ́ like.” ");
INSERT INTO any_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Dedi'n mɔ ɛbɛlɛ menian'n-mɔ le man yɩ́ nɩn ati, Zozi a nyɔ man asinbɛnwʋn ninnge dɔʋn. ");
INSERT INTO any_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Tɛmʋn sɔ'n, anɩn belemgbin *Elɔdɩ Antɩpasɩ tɩ Galile mân nɩn asʋ belemgbin. M'ɔ tɩlɩ Zozi angan'n, ");
INSERT INTO any_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","ɔ kɔ han kɔ hele yɩ́ ngʋa'n-mɔ kɛ: “Zʋan Batisi dein y'ɔ fi ewue nun ɔ'a tinnge nɩn ɔ! Ɛhɩka ati yɛ̂ ɔ le tunmin ɔ yɔ asinbɛnwʋn ninnge ɔ.” ");
INSERT INTO any_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Belemgbin Elɔdɩ hanlɩn sɔ, ɔ sanlɩn kɛ yɩ́ nianman belenzua'n mɔ bɛ fɛlɛ yɩ́ Filipʋ nɩn ayɩ'n m'ɔ li Elodiadɩ'n dunman nun, ɔ kɔ man bɛ kɔ hyɩ Zʋan, bɛ kɔ cɩcɩ yɩ́ ɛsɛ bɛ kɔ tʋ yɩ́ fiadɩ. ");
INSERT INTO any_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Afɩ Zʋan kɔ han kɔ hele belemgbin Elɔdɩ kɛ: “Nannan, Nyanmɩan mala'n mman man wɔ́ atɩn kɛ ɛ fá Elodiadɩ já.” ");
INSERT INTO any_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Ɛjɔlɛ'n mɔ Zʋan hanlɩn nɩn anwʋn, belemgbin Elɔdɩ kulo kɛ ɔ man bɛ kun yɩ́. Nan kʋsʋ ɔ sulo Zufʋ'n-mɔ. Afɩ bɛ́ kʋalaa, bɛ bu Zʋan kɛ Nyanmɩan kpɔmanfʋɛ. ");
INSERT INTO any_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Nan ɔ wɔ ɛbɛlɛ dede mɔ belemgbin Elɔdɩ awɔlɛ cɩan nɩn anwʋn fɛtɩ'n mɔ bɛ di yɩ́ afʋɛ nʋan'n juli'n, Elodiadɩ awa balasua'n kɔ si abile menian'n-mɔ anyunnun ɛbɛlɛ. Ɔ kɔ yɔ belemgbin Elɔdɩ ɛnyɩnmɩn sʋnman ");
INSERT INTO any_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","dede ɔ kɔ han ndâ kɛ like biala m'ɔ kulo'n, sɛ ɔ bisa a, ɔ 'fa man yɩ́. ");
INSERT INTO any_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Talua'n kɔ li yɩ́ nin anʋan ɛjɔlɛ nɩn asʋ. Ɔ kɔ han kɔ hele belemgbin Elɔdɩ kɛ: “Baba, fa Zʋan ati'n tʋ apawa nun man mɩ́n kɩkaala!” ");
INSERT INTO any_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Mɔ belemgbin Elɔdɩ tɩlɩ yɩ́ sɔ'n, yɩ́ lʋa kɔ bɔ yɩ́ nwʋn. Nan kʋsʋ ndâ'n m'ɔ hanlɩn yɩ́ mgbain'n-mɔ anyunnun ɛbɛlɛ nɩn ati, ɔ kɔ man atɩn kɛ bɛ fá Zʋan ati'n bɛ bɛ́lɛ talua'n. ");
INSERT INTO any_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Ɛhɩ, ɔ kɔ sʋan sʋanlan kɛ ɔ hɔ́ fiadɩ sua nɩn anun ɔ kpɛ́ Zʋan ati'n. ");
INSERT INTO any_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Sʋanlan'n kɔ hɔ kɔ kpɛ Zʋan ati'n ɔ kɔ tʋ yɩ́ apawa nun kɔ bɛlɛ talua'n. Talua'n kʋsʋ kɔ hɔ kɔ fa kɔ man yɩ́ nin. ");
INSERT INTO any_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Mɔ Zʋan menian'n-mɔ tɩlɩ yɩ́ sɔ'n, bɛ walɩ falɩ yɩ́ fuin'n bɛ hɔlɩ sielɩ yɩ́. Mɔ bɛ sielɩ yɩ́ yuelɩ'n, bɛ hɔlɩ bɔlɩ nun amannɩɛ bɛ helelɩ Zozi. ");
INSERT INTO any_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Mɔ Zozi tɩlɩ amannɩɛ sɔ'n, ɔ fʋlɩ ɛlɛɛ kʋn anun ɔ hɔlɩ lɩka kʋn. Lɩka sɔ'n, sʋanlan fɩ́ɩ́ nnʋn man ɛbɛlɛ. Nan mɔ menian'n-mɔ tɩlɩ yɩ́ sɔ'n, bɛ fi kulo kulo'n-mɔ asʋ bɛ kɔ fa asue nɩn anʋan atɩn'n bɛ kɔ si Zozi sʋ. ");
INSERT INTO any_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Mɔ Zozi fi ɛlɛɛ nɩn anun 'ju'n, ɔ 'tʋ yɩ́ nyɩn an, menian ngʋnmɩn. Bɛ́ nwʋn kɔ yɔ yɩ́ anwunnvoe, ɛsɛ ɔ kɔ man nwuluwafʋɛ'n-mɔ anwʋn kɔ sa. ");
INSERT INTO any_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Mɔ alɩ́ɛ'n yɔlɩ nɔsʋba'n, yɩ́ menian'n-mɔ kɔ hyʋɩn kɔ kpunnge yɩ́. Bɛ́ nwan: “Alɩ́ɛ a yue yɔ ɛsɛ ɛwa lika'n tɩ yɩ́ nwʋn. Yɩ́ ti, man bɛ́ atɩn maan bɛ hɔ́ kulo'n-mɔ asʋ bɛ hɔ́ tó like bɛ lí.” ");
INSERT INTO any_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Zozi kɔ bua bɛ kɛ: “Ɔ tɩ man cɩnnjɩn kɛ bɛ hɔ́. Nan ɛmɔ muonun mán bɛ́ like bɛ lí.” ");
INSERT INTO any_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Yɩ́ menian'n-mɔ nwan: “Kpaʋn nnun ala ɔ nʋn ejue nnyuan yɛ̂ yɛ le yɩ́ ɛwa ɔ.” ");
INSERT INTO any_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Zozi nwan: “Ɛmɔ fá bɛ bɛ́lɛ mɩ́n.” ");
INSERT INTO any_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","M'ɔ hanlɩn sɔ yuelɩ'n, ɔ kɔ man meninsʋnman nɩn atɩn kɛ bɛ tɛ́tanlan ndile nɩn asʋ. Ɛhɩ anzin, ɔ kɔ fa kpaʋn nnun'n nʋn ejue nnyuan'n ɔ kɔ tʋ yɩ́ nyɩn anwunno ɔ kɔ la Nyanmɩan asɩ. M'ɔ lalɩ Nyanmɩan asɩ yuelɩ'n, ɔ kɔ bubu kpaʋn'n-mɔ anun ɔ kɔ fa kɔ man yɩ́ menian'n-mɔ. Yɩ́ menian'n-mɔ kʋsʋ kɔ hye kɔ man meninsʋnman'n. ");
INSERT INTO any_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Bɛ́ nun kʋn biala kɔ li dede yɩ́ kʋ kɔ yi. Kpaʋn'n m'ɔ halɩ'n, Zozi menian'n-mɔ kɔ sɩsa. Ɔ yi ece mma bulu nʋn nnyuan. ");
INSERT INTO any_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Bɛ́ mɔ bɛ lili like'n tɩ kɔ yɔ akpɩɩ nnun, b'a nga man mmalasua'n-mɔ nʋn mmatʋnman'n-mɔ bie. ");
INSERT INTO any_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Ɛhɩ, menian'n-mɔ yuelɩ like di ɛbɛlɛ ala a, Zozi kɔ man yɩ́ menian'n-mɔ kɔ fʋ ɛlɛɛ nɩn anun. Ɔ kɔ han kɔ hele bɛ́ kɛ bɛ kpɛ́ asue'n bɛ lí mʋa ebue kʋn ɛlɔ nán ɔ 'gua meninsʋnman nɩn atɩn. ");
INSERT INTO any_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","M'ɔ gualɩ bɛ́ atɩn yuelɩ'n, ɔ kɔ fʋ bʋka kʋn asʋ, ɔ kɔ hɔ asɔnɩn ɛyɔlɛ ahanmɩan. Mɔ alɩ́ɛ sanlɩn'n, yɩ́ ngʋnmɩn cein yɛ̂ anɩn ɔ wɔ ɛbɛlɛ ɔ. ");
INSERT INTO any_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Ɔ 'ba yɔ sɔ'n, anɩn Zozi menian'n-mɔ ɛlɛɛ'n la bunman sʋ. Asutue'n bɔ mgbaha ɔ tu si ɛlɛɛ'n. ");
INSERT INTO any_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Mɔ ɔ 'kɔ alɩbahɩan'n, Zozi nanndɩ asue nɩn anyɩnsʋ ɔ lɛ kpʋ yɩ́ menian'n-mɔ. ");
INSERT INTO any_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Mɔ bɛ nwunlin kɛ ɔ nanndɩ asue nɩn anyɩnsʋ'n, esulo kɔ han bɛ́. Bɛ́ nwan: “Ɛnwʋnmɩn aho! Ɛnwʋnmɩn aho!” Kɛmɔ anɩn bɛ sulo nɩn ati, bɛ lɛ tɛtɩan. ");
INSERT INTO any_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Nan bɛ 'tɛtɩan nɩn ala, Zozi nwan: “Ɛmɔ sɔ́ bɛ́ ahʋnlɩn nán mɩ́n ɔ. Nán bɛ sulo!” ");
INSERT INTO any_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Ɛhɩ a, Pɩɛlɩ nwan: “Yɛ́ Mɩn, sɛ wɔ́ sakpa a, man n nánndɩ asue nɩn anyɩnsʋ m gbʋ́ wɔ́.” ");
INSERT INTO any_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Mɔ Pɩɛlɩ hanlɩn sɔ'n, Zozi nwan: “Bala!” Pɩɛlɩ fi ɛlɛɛ nɩn anun ɔ kɔ ju, ɔ lɛ kpʋ Zozi. ");
INSERT INTO any_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Nan m'ɔ nwunlin kɛ asutue'n tɩ kpili'n, esulo kɔ han yɩ́. Ɛsɛ kɛmɔ anɩn ɔ lɛ nʋan'n, ɔ kɔ tɩan. Yɩ́ nwan: “Yɛ́ Mɩn, de mɩ́n!” ");
INSERT INTO any_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Ɛbɛlɛ ala, Zozi kɔ tʋ yɩ́ sa ɔ kɔ sɔ yɩ́ nun yɛ̂ yɩ́ nwan: “Pɩɛlɩ, wɔ́ dedi'n tɩ kaan o! Ɔ yɔ sɛ mɔ a nnyan man dedi'n?” ");
INSERT INTO any_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Mɔ Zozi hanlɩn sɔ yuelɩ'n, ɔ nʋn Pɩɛlɩ bɛ kɔ fʋ ɛlɛɛ nɩn anun yɛ̂ asutue'n gualɩ asɩ ɔ. ");
INSERT INTO any_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Bɛ́ bʋ nga'n mɔ bɛ́ gua ɛlɛɛ nɩn anun'n kɔ a kɔ kʋtʋ kʋtʋ Zozi anyunnun ɛbɛlɛ. Bɛ́ nwan: “Fɔ́ʋ́n, Nyanmɩan Awa'n y'ɔ le wɔ́!” ");
INSERT INTO any_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Bɛ kpɛlɩ asue'n nán b'a si asɩ Zenezalɛtɩ etin nɩn asʋ. ");
INSERT INTO any_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Ɛbɛlɛ menian'n-mɔ nwunlin Zozi nzɔlɛ. Bɛ hɔlɩ lɩka kʋalaatin bɛ kɔ hɔ kɔ bɔ kpayɛ kɛ Zozi a ju ɛbɛlɛ. Bɛ kɔ sʋa nwuluwafʋɛ'n-mɔ kʋalaatin bɛ kɔ bɛlɛ yɩ́. ");
INSERT INTO any_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Bɛ kɔ sɛlɛ Zozi kɛ ɔ mán bɛ́ atɩn maan bɛ hán yɩ́ taladɩɛ nɩn anʋan nɩn ala. Bɛ́ kʋalaa mɔ bɛ hanlɩn yɩ́ taladɩɛ nɩn anʋan'n, bɛ́ nwʋn salɩ kpa bɔkɔɔ. ");
INSERT INTO any_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Tɛmʋn sɔ'n, *Falisifʋɛ nʋn *mala nɩn asʋ mgbain mmie-mɔ fi Zoluzalɛmʋn bɛ kɔ a kɔ tʋ Zozi ɛbɛlɛ, bɛ́ nwan: ");
INSERT INTO any_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Yɛ́ nan-mɔ mala'n kele yɛ́ kɛ sɛ yɛ 'di like a, yɛ nwúnnzin yɛ́ sa nɩn anun. Nan nzukɛ ati yɛ̂ wɔ́ menian dɩɛ'n-mɔ nni man ɛjɔlɛ sɔ nɩn asʋ ɔ? Sɛ bɛ 'di like a, bɛ nnwunnzin man bɛ́ sa'n-mɔ anun.” ");
INSERT INTO any_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Zozi kɔ bua bɛ́ kɛ: “Nán ɛmɔ lɩlɩ, nzukɛ ati yɛ̂ ɛmɔ di bɛ́ muonun bɛ́ mala'n-mɔ asʋ bɛ yaci Nyanmɩan dɩɛ nɩn ɔ? ");
INSERT INTO any_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Afɩ Nyanmɩan a han kɛ: Man wɔ́ nyɩn sɔ́ wɔ́ sɩ nʋn wɔ́ nin. Ɛsɛ yɩ́ nwan: Sʋanlan m'ɔ kɔ han ɛjɔlɛ ɛtɛ kɔ tia yɩ́ sɩ anaan yɩ́ nin'n, sʋanlan sɔ'n, ɔ sɛ kɛ bɛ kun yɩ́. ");
INSERT INTO any_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Nan ɛmɔ dɩɛ, ɛmɔ kan kele menian'n-mɔ kɛ, sɛ sʋanlan kʋn se yɩ́ sɩ anaan yɩ́ nin kɛ: ‘Like'n m'ɔ di mɔ mɩn fa mɩn bʋka wɔ́'n, mɩɩn fa mɩn man Nyanmɩan’, anɩn sʋanlan sɔ'n, ɔ nzɩ man yɩ́ sɩ anaan yɩ́ nin ɛjɔlɛ nun kʋ́n. ");
INSERT INTO any_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Kɛ ɛmɔ yɔ mɔ ɛmɔ bɔ Nyanmɩan Anʋan Ɛjɔlɛ nɩn abʋsʋ nán ɛmɔ muonun a li bɛ́ ngehele nɩn asʋ nɩn anɩn. ");
INSERT INTO any_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Apoo mma, *Ezayi ɛjɔlɛ'n m'ɔ hanlɩn wɔ ɛmɔ anwʋn'n, yɩ́ ɛhan sʋ ɔ. Nyanmɩan nanndɩlɩ Ezayi sʋ ɔ hanlɩn kɛ: ");
INSERT INTO any_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Menian ɛhɩ-mɔ, bɛ le bɛ́ nʋan tuin mgban yɛ̂ bɛ yɩ mɩ́n ayɛ ɔ, nan bɛ́ ahʋnlɩn'n nnʋn man mɩ́n sʋ. ");
INSERT INTO any_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Bɛ́ asɔnɩn'n mɔ bɛ yɔ'n tɩ mgban. Ɔ sanlɩn kɛ kulo menian mala yɛ̂ bɛ kekele ɔ, nan nán mɩ́n dɩɛ'n-mɔ ɔ.” ");
INSERT INTO any_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Ɛhɩ anzin, Zozi kɔ fɛlɛ meninsʋnman'n, yɩ́ nwan: “Ɛmɔ yɔ́ anzʋɛ bɛ tíe ɛjɔlɛ ɛhɩ kpa. ");
INSERT INTO any_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Nán like mɔ sʋanlan di'n y'ɔ gua yɩ́ nwʋn efian ɔ, nan ɛjɔlɛ m'ɔ fi yɩ́ nʋan kɔ fite'n y'ɔ gua yɩ́ nwʋn efian ɔ.” ");
INSERT INTO any_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Ɛhɩ, yɩ́ menian'n-mɔ kɔ hyʋɩn kɔ kpunnge yɩ́, bɛ́ nwan: “Asʋ ɛ sɩ kɛ ɛjɔlɛ'n mɔ a han nɩn a wʋlʋ Falisifʋɛ'n-mɔ ɔ?” ");
INSERT INTO any_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Bɛ hanlɩn sɔ a, Zozi nwan: “Baka biala mɔ nán mɩ́n Sɩ'n m'ɔ wɔ anwunno'n yɛ̂ ɔ lualɩ'n, baka sɔ'n, bɛ 'tu yɩ́ bɛ tʋ. ");
INSERT INTO any_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Nán bɛ tɛ bɛ́ sʋ, nan bɛ tɩ kɛ anyɩnsinlinwafʋɛ-mɔ! Sɛ anyɩnsinlinwafʋɛ kʋn di yɩ́ manngʋn anyɩnsinlinwafʋɛ taataa a, bɛ́ munnyuan bɛ 'gua kunman nun.” ");
INSERT INTO any_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Pɩɛlɩ kukuli yɩ́ nʋan sʋ a, yɩ́ nwan: “Tu anyɩnndala ɛhɩ abʋ kele yɛ́.” ");
INSERT INTO any_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Zozi nwan: “Ɛmɔ kʋsʋ ngʋala ndɩ man ɛjɔlɛ bʋ ɔ? ");
INSERT INTO any_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Ɛmɔ nzɩ man kɛ like mɔ sʋanlan kɔ li'n, ɔ kɔ yɩ́ kunnun, ɔ wɔ ɛbɛlɛ dede ɛsɛ ɔ fite ɔ? ");
INSERT INTO any_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Nan ɛjɔlɛ m'ɔ fi sʋanlan anʋan kɔ fite'n fi yɩ́ ahʋnlɩn nɩn anun. Yɩ́ y'ɔ gua yɩ́ nwʋn efian ɔ. ");
INSERT INTO any_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Ɔ sanlɩn kɛ ajʋnlɩn ɛtɛ m'ɔ man bɛ di awue, bɛ tʋn ajaa, bɛ bɔ danga, bɛ wua, bɛ di adanzɩyua ɔ nʋn menian anwʋn ɛjɔlɛ ɛtɛ ɛhan, ninnge sɔ'n fi bɛ́ ahʋnlɩn nun. ");
INSERT INTO any_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Ɛhɩ y'ɔ gua sʋanlan anwʋn efian ɔ. Nan sɛ sʋanlan 'di like nan ɔ'a nnwunnzin man yɩ́ sa nun an, ɔ ngua man yɩ́ nwʋn efian.” ");
INSERT INTO any_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Ɛhɩ anzin, Zozi fi ɛbɛlɛ yɩ́ nʋan y'ɔ le kulo'n-mɔ mɔ bɛ fɛlɛ bɛ́ Tii nʋn Sidʋn etin dɩɛ nɩn asʋ. ");
INSERT INTO any_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Mɔ Zozi juli ɛbɛlɛ'n, Kanaân balasua kʋn m'ɔ tɩ mân sɔ nɩn anun'n, ɔ kɔ a Zozi anwʋn ɛbɛlɛ, ɔ kɔ tɩan nun. Yɩ́ nwan: “Yɛ́ Mɩn, belemgbin *Davidi Awa, nwun mɩ́n nwʋn anwunnvoe! Wawɛ ɛtɛ bie wɔ mɩ́n wa talua nɩn anun. Ɔ kele yɩ́ yalɛ sʋnman.” ");
INSERT INTO any_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Balasua sɔ'n hanlɩn sɔ a, Zozi ngɔ bua man ɛjɔlɛ kpɔlɛ kʋ́n. Yɩ́ menian'n-mɔ kɔ hyʋɩn kɔ kpunnge yɩ́, bɛ́ nwan: “Ɔ le ɛtɩan ɔ si yɛ́ sʋ. Yɩ́ ti, bua yɩ́ bie maan ɔ hɔ́.” ");
INSERT INTO any_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Mɔ bɛ hanlɩn sɔ'n, Zozi nwan: “Izalayɛ amma'n-mɔ mɔ bɛ tɩ kɛ mmʋa mɔ b'a minlin'n, bɛ́ ti yɛ̂ m malɩ ɔ.” ");
INSERT INTO any_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Nan m'ɔ hanlɩn sɔ'n, balasua'n kɔ a kɔ kʋtʋ yɩ́ nyunnun ɛbɛlɛ, yɩ́ nwan: “Yɛ́ Mɩn, nwun mɩ́n nwʋn anwunnvoe, de mɩ́n!” ");
INSERT INTO any_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Zozi kɔ han kɔ hele yɩ́ kɛ: “Ɔ tɩ man kpa kɛ bɛ fa mmatʋnman'n-mɔ alɩɛ'n bɛ man njʋa mma'n-mɔ di ɔ.” ");
INSERT INTO any_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Mɔ Zozi hanlɩn sɔ'n, balasua'n nwan: “Ɔ tɩ ananhɔlɛ, yɛ́ Mɩn. Nan kʋsʋ njʋa mma'n-mɔ sɩsa alɩɛ nɩn abʋ mgbʋkpʋlʋka'n m'ɔ kɔ gua bɛ́ mɩ́n'n-mɔ tɔbɩlɩ nɩn abʋ'n bɛ di.” ");
INSERT INTO any_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Ɛhɩ a, Zozi kɔ bua yɩ́ kɛ: “Balasua, wɔ́ dedi'n tɩ kpili! Mɔ ɛ lɛ kpʋnndɛ'n, ɔ yɔ́ sɔ man wɔ́.” Mɛlɛ sɔ nɩn ala, yɛ̂ yɩ wa balasua nɩn anwʋn salɩ ɔ. ");
INSERT INTO any_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Zozi fi ɛlɔ ɔ kɔ sa kɔ a Galile asue nɩn anʋan. Ɔ kɔ fʋ kɔ tanlan bʋka kʋn asʋ. ");
INSERT INTO any_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Meninsʋnman kɔ a yɩ́ nwʋn ɛbɛlɛ. Bɛ 'ba a, bɛ nʋn bɛ́ mɔ bɛ tia bɛ tɔ sʋ, anyɩnsinlinwafʋɛ, amunlefʋɛ, bubuluwafʋɛ ɔ nʋn nwuluwafʋɛ dɔʋn kpa. Bɛ falɩ bɛ́ bɛ walɩ Zozi aja sʋ nán ɔ'a man bɛ́ kʋalaa bɛ́ nwʋn a sa. ");
INSERT INTO any_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Mɔ menian'n-mɔ nwunlin kɛ amunlefʋɛ'n-mɔ lɛ jʋjɔ, bubuluwafʋɛ'n-mɔ lɛ nanndɩ, bɛ́ mɔ bɛ tia bɛ tɔ sʋ'n, bɛ lɛ nanndɩ kpa, anyɩnsinlinwafʋɛ'n-mɔ anyɩn'n-mɔ a tike tike'n, ɔ sinlin bɛ́ nwʋn, bɛ kɔ yɩ́ Izalayɛ Nyanmɩan nɩn ayɛ. ");
INSERT INTO any_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Zozi fɛlɛlɩ yɩ́ menian'n-mɔ, yɩ́ nwan: “Meninsʋnman ɛhɩ-mɔ nʋn yɛ wɔ ɛwa yɩ́ cɩan nsan ahɩ. Bɛ le man like fɩ́ɩ́ kʋ́n mɔ bɛ di ɔ. Bɛ́ nwʋn yɔ mɩ́n koun. Mɩn ngulo man kɛ mɩn yaci bɛ́ m man bɛ fa bɛ́ kunnun bɛ kɔ. Sɛ mɩn yɔ yɩ́ sɔ a, bɛ 'gɔlɔ atunnun.” ");
INSERT INTO any_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Mɔ Zozi hanlɩn sɔ'n, yɩ́ menian'n-mɔ kɔ bisa yɩ́ kɛ: “Ebo ɛhɩ anun, ninhan yɛ̂ yɛ 'nyan like m'ɔ sa menian nwala ɛhɩ di ɔ?” ");
INSERT INTO any_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Zozi kɔ bisa bɛ́ kɛ: “Ɛmɔ le kpaʋn nyɛ?” Bɛ́ nwan: “Yɛ le kpaʋn nsʋ, nʋn ejue nganngan bie.” ");
INSERT INTO any_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Ɛhɩ a, Zozi kɔ man meninsʋnman'n kɔ tɛtanlan asɩ. ");
INSERT INTO any_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Mɔ bɛ tɛtanlanlɩn asɩ yuelɩ'n, ɔ kɔ fa kpaʋn nsʋ'n nʋn ejue'n-mɔ ɔ kɔ la Nyanmɩan asɩ. Ɔ kɔ bubu nun ɔ kɔ man yɩ́ menian'n-mɔ kɛ bɛ hyé bɛ mán bɛ́. ");
INSERT INTO any_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Bɛ́ kʋalaa bɛ kɔ li dede bɛ́ kʋ kɔ yi. Yɩ́ menian'n-mɔ kɔ sɩsa yɩ́ bʋ'n m'ɔ halɩ'n, ɔ tɩ ece mma nsʋ. ");
INSERT INTO any_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Bɛ́ mɔ bɛ lili'n, bɛ tɩ menian akpɩɩ nnan, b'a nga man mmalasua'n-mɔ nʋn mmatʋnman'n-mɔ bie. ");
INSERT INTO any_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","M'ɔ gualɩ meninsʋnman nɩn atɩn yuelɩ'n, ɔ fʋlɩ ɛlɛɛ nɩn anun, ɔ hɔlɩ Magadan mân nɩn anun. ");
INSERT INTO any_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Ɛhɩ, *Falisifʋɛ'n-mɔ nʋn *Sadusifʋɛ'n-mɔ kɔ kpʋ Zozi, afɩ bɛ kulo kɛ bɛ sɔ yɩ́ bɛ nɩan. Bɛ kɔ han bɛ kɔ hele yɩ́ kɛ ɔ yɔ́ asinbɛnwʋn like kʋn maan bɛ nwún kɛ yɩ́ tunmin'n m'ɔ le yɩ́'n fi Nyanmɩan ɛlɔ. ");
INSERT INTO any_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Mɔ bɛ hanlɩn sɔ'n, Zozi nwan: “Nɔsʋba mɔ nyanmɩan nɩn anyunnun kɔ bʋlʋ'n, anɩn ɛmɔ nwan eyua'n 'ba fi ɛhɩnman. ");
INSERT INTO any_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Ngɛlɛmɔ kʋsʋ mɔ nyanmɩan nɩn anyunnun kɔ lu'n, anɩn ɛmɔ nwan esue'n 'ba tɔ. Ɛmɔ sɩ nyanmɩan nɩn anyunnun ninnge'n-mɔ nzɔlɛ, nan kʋsʋ ɛmɔ nzɩ man mɛlɛ'n mɔ yɛ wɔ nun'n nzɔlɛ. ");
INSERT INTO any_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Ajulisʋ menian ati anun ɛtɛ mɔ bɛ nnanndɩ man fɔ́ʋ́n wɔ Nyanmɩan anyunnun'n, bɛ lɛ kpʋnndɛ asinbɛnwʋn like bɛ nɩan. Sɛ nán asinbɛnwʋn like'n mɔ Nyanmɩan yɔlɩ manlɩn Zonasɩ nɩn an, bɛ nyɔ man nzɔlɛ kʋ́n bɛ ngele man bɛ́. Mɔ Zozi hanlɩn sɔ yuelɩ'n, ɔ yacili bɛ́ ɛbɛlɛ ɔ hɔlɩ.” ");
INSERT INTO any_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Mɔ Zozi menian'n-mɔ 'kpɛ asue'n bɛ kɔ yɩ́ nzin ɛlɔ'n, bɛ́ lʋa kɔ fi b'a nva man kpaʋn. ");
INSERT INTO any_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Zozi kɔ se bɛ́ kɛ: “Ɛmɔ nɩ́an bɛ́ nwʋn kpa wɔ *Falisifʋɛ'n-mɔ nʋn *Sadusifʋɛ'n-mɔ fali ayile nɩn anwʋn.” ");
INSERT INTO any_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Mɔ menian'n-mɔ tɩlɩ yɩ́ sɔ'n, bɛ kɔ han yɩ́ bɛ́ afian ɛlɔ kɛ: “Kpaʋn'n mɔ y'a nva man'n, yɩ́ ti y'ɔ man ɔ lɛ kan sɔ ɔ.” ");
INSERT INTO any_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Ɛjɔlɛ'n kɔ tɔ Zozi anzʋ nun, yɩ́ nwan: “Nzukɛ ati yɛ̂ ɛmɔ lɛ kan kɛ kɛmɔ y'a nva man kpaʋn'n, yɩ́ ti yɛ̂ ɔ lɛ kan sɔ ɔ? Ɛmɔ dedi'n tɩ kaan o! ");
INSERT INTO any_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Ɛmɔ tɩlɩ man ɛjɔlɛ nɩn abʋ ɔ? Ɛmɔ ngacɩ man kpaʋn nnun'n mɔ n valɩ m manlɩn menian akpɩɩ nnun'n lili nɩn ɔ? Ɛsɛ m'ɔ halɩ yɩ́ bʋ'n, ece nyɛ yɛ̂ ɛmɔ sɩsalɩ ɔ? ");
INSERT INTO any_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Ɛsɛ kpaʋn nsʋ'n kʋsʋ mɔ n valɩ m manlɩn menian akpɩɩ nnan'n lili'n, m'ɔ halɩ yɩ́ bʋ'n, ece nyɛ yɛ̂ ɛmɔ sɩsalɩ ɔ? ");
INSERT INTO any_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Ɔ yɔ sɛ mɔ ɛmɔ ndɩ man yɩ́ bʋ kɛ nán kpaʋn anwʋn ɛjɔlɛ yɛ̂ mɩɩn kan mɩn kele ɛmɔ'n? Nan mɩ́n nwan: Ɛmɔ nɩ́an bɛ́ nwʋn kpa wɔ *Falisifʋɛ'n-mɔ nʋn *Sadusifʋɛ'n-mɔ fali ayile nɩn anwʋn.” ");
INSERT INTO any_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","M'ɔ yɔlɩ sɔ'n, yɩ́ menian'n-mɔ kɔ tɩ yɩ́ bʋ kɛ nán ayile'n mɔ bɛ fa bɛ fɔtɔ fali nɩn anwʋn ɛjɔlɛ y'ɔ lɛ kan ɔ. Nan Falisifʋɛ'n-mɔ nʋn Sadusifʋɛ'n-mɔ like'n mɔ bɛ kekele nɩn anwʋn ɛjɔlɛ yɛ̂ anɩn ɔ lɛ kan ɔ. ");
INSERT INTO any_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Ɛhɩ anzin, Zozi hɔlɩ Sezale etin dɩɛ nɩn asʋ Filipʋ mân nɩn anun ɛlɔ. M'ɔ nʋn yɩ́ menian'n-mɔ juli ɛlɔ'n, ɔ kɔ bisa bɛ́ kɛ: “Menian'n-mɔ nwan sʋanlan benin y'ɔ le *Mân Baa'n?” ");
INSERT INTO any_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Kosuan sɔ'n mɔ Zozi bisalɩ nɩn anwʋn, bɛ́ nwan: “Mmie-mɔ nwan Zʋan Batisi y'ɔ le wɔ́, mmie-mɔ nwan *Eli y'ɔ le wɔ́, mmie-mɔ nwan Zolomin y'ɔ le wɔ́ anaan Nyanmɩan mgbɔmanfʋɛ'n-mɔ, bɛ́ bie y'ɔ le wɔ́.” ");
INSERT INTO any_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Zozi nwan: “Nan ɛmɔ lɩlɩ, ɛmɔ jʋnlɩn kɛ nwan sʋanlan dɩɛ y'ɔ le mɩ́n?” ");
INSERT INTO any_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simʋn Pɩɛlɩ nwan: “Kilisi'n, Izalayɛ Ngʋandefʋɛ'n y'ɔ le wɔ́. Ɛ tɩ Tɩasɩfʋɛ Nyanmɩan nɩn Awa.” ");
INSERT INTO any_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Ɛhɩ a, Zozi nwan: “Zonasɩ awa Simʋn, nyila hán wɔ́. Ɔ sanlɩn kɛ nán kulo sʋanlan yɛ̂ ɔ'a man a nwun yɩ́ sɔ ɔ. Nan mɩ́n Sɩ m'ɔ wɔ anwunno ɛlɔ'n yɛ̂ ɔ'a man a nwun yɩ́ ɔ. ");
INSERT INTO any_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Mɩ́n kʋsʋ mɩɩn kan mɩn kele wɔ́ kɛ ɛ li Pɩɛlɩ (yɩ́ bʋ y'ɔ le kɛ ɛbʋɛ). Ɛbʋɛ sɔ nɩn asʋ yɛ̂ mɩn 'si mɩ́n Asɔnɩn nɩn ɔ. Ewue muonun tunmin'n m'ɔ le yɩ́'n ngʋala man like fɩ́ɩ́ yɔ yɩ́ nyunnun. ");
INSERT INTO any_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Mɩn 'fa Anwunno Belemgbin Mân nɩn anʋan sannvɛ'n mɩn wula wɔ́ sa nun. Sʋanlan biala mɔ asɩɛ nɩn asʋ ɛwa ɛ kɔ tike anʋan'n kɔ man yɩ́'n, anɩn b'a tike b'a man yɩ́ anwunno ɛlɔ. Yɛ̂ sʋanlan biala kʋsʋ mɔ asɩɛ nɩn asʋ ɛwa a ndike man anʋan nɩn a mman man yɩ́'n, anɩn b'a ndike b'a mman man yɩ́ anwunno ɛlɔ.” ");
INSERT INTO any_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Mɔ Zozi hanlɩn sɔ yuelɩ'n, ɔ totualɩ yɩ́ menian'n-mɔ kɛ nán bɛ kan bɛ kele sʋanlan kɛ Kilisi'n, Izalayɛ Ngʋandefʋɛ'n y'ɔ le yɩ́. ");
INSERT INTO any_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Ɔ fi cɩan sɔ'n m'ɔ kɔ'n, Zozi kɔ bɔ yɩ́ bʋ, ɔ kɔ han kɔ hele yɩ́ menian'n-mɔ kɛ: “Ɔ sɛ kɛ n gɔ́ Zoluzalɛmʋn. N gɔ́ n nwún yalɛ Zufʋ mgbain'n-mɔ, ɔ nʋn Nyanmɩan *tɛɛyɩfʋɛ mgbain'n-mɔ nʋn *mala nɩn asʋ mgbain'n-mɔ asa nun. Bɛ 'ba hun mɩ́n, nan yɩ́ cɩan nsan nɩn asʋ, n vi ewue nun mɩn 'tinnge.” ");
INSERT INTO any_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Ɛhɩ, Pɩɛlɩ kɔ fa yɩ́ kɔ hɔ ahanmɩan, ɔ kɔ tu yɩ́ nyunnun. Yɩ́ nwan: “Yɛ́ Mɩn, Nyanmɩan kpála gúa! Like fɩ́ɩ́ ngɔ tʋ man wɔ́.” ");
INSERT INTO any_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Mɔ Pɩɛlɩ hanlɩn sɔ'n, Zozi kɔ kpɛ yɩ́ nyɩn ɔ kɔ se yɩ́ kɛ: “Satan, fi mɩ́n nwʋn ɛwa kɔ mʋa. Ɛ 'totua mɩ́n atɩn, afɩ nán Nyanmɩan ajʋnlɩn yɛ̂ ɛ le yɩ́ ɔ, nan kulo menian'n-mɔ ajʋnlɩn yɛ̂ ɛ le yɩ́ ɔ.” ");
INSERT INTO any_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Ɛhɩ anzin, Zozi kɔ han kɔ hele yɩ́ menian'n-mɔ kɛ: “Sʋanlan m'ɔ kulo kɛ ɔ si mɩ́n sʋ'n, n'ɔ susu yɩ́ sʋanlan baka nɩn anwʋn. Ɔ fá yɩ́ kʋlʋwa'n ɔ tʋ́ yɩ́ kɔmɩn sʋ, nán ɔ sí mɩ́n sʋ. ");
INSERT INTO any_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Ɔ sanlɩn kɛ sʋanlan m'ɔ kulo kɛ ɔ kpʋnndɛ yɩ́ ngʋan'n, ɔ 'minlin yɩ́ ngʋan sɔ'n. Nan sʋanlan m'ɔ kɔ si mɩ́n sʋ dede ɔ kɔ wu mɩ́n dunman nun'n, sʋanlan sɔ'n 'nyan ngʋan. ");
INSERT INTO any_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Sɛ sʋanlan kʋn nyan asɩɛ asʋ ɛwa ninnge'n kʋalaa nan sɛ ɔ minlin yɩ́ ngʋan nɩn an, anɩn nzu nvasʋɛ dɩɛ yɛ̂ ɔ 'nyan yɩ́ sʋ ɔ? Nzu like dɩɛ yɛ̂ sʋanlan kʋn kʋala kɛ ɔ yɔ ɔ de yɩ́ ngʋan ɔ? ");
INSERT INTO any_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","*Mân Baa'n fi yɩ́ Sɩ anunminnyanmʋn nɩn anun ɔ nʋn nyanmɩansʋ mmɔfʋɛ'n-mɔ 'ba a. Sɛ ɔ ba a, ɔ 'nɩan sʋanlan kʋn biala junman'n m'ɔ lili nɩn anwʋn ɔ tua yɩ́ kalɛ. ");
INSERT INTO any_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Mɩɩn kan yɩ́ ananhɔlɛ mɩn kele ɛmɔ kɛ: bɛ́ mɔ b'a yia ɛwa'n, mmie-mɔ ngɔ wu man, bɛ 'ba nwun Mân Baa'n kɛ ɔ lɛ ba ɔ di belemgbin.” ");
INSERT INTO any_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Ɛhɩ anzin cɩan nsian, Zozi kɔ fa Pɩɛlɩ, Zʋakɩ nʋn yɩ́ nianman Zʋan. Ɔ nʋn bɛ́ menian nsan nɩn ala bɛ kɔ tɩ bɛ́ nwʋn bʋka kannganlaun kʋn asʋ. ");
INSERT INTO any_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Ɛbɛlɛ, Zozi kɔ kaci bɛ́ nyɩnsʋ. Yɩ́ nyɩn nɩn anun kɔ ta kɛ sɛnzɛ, yɩ́ taladɩɛ'n m'ɔ wula'n kɔ yɔ fufue hyɩɛɩn hyɩɛɩn kpa kɛ kanlannɩɛ. ");
INSERT INTO any_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Zozi menian nsan'n 'nɩan an, anɩn Moyizɩ nʋn Eli nʋn Zozi bɛ lɛ jʋjɔ. ");
INSERT INTO any_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Mɔ Pɩɛlɩ nwunlin yɩ́ sɔ'n, ɔ kɔ han kɔ hele Zozi kɛ: “Yɛ́ Mɩn, ɔ tɩ kpa kɛ yɛ wɔ ɛwa. Sɛ ɛ kulo a, mɩn 'bɔ *tantɩ nsan. Wɔ́ dɩɛ kʋn, Moyizɩ dɩɛ kʋn yɛ̂ Eli kʋsʋ dɩɛ kʋn.” ");
INSERT INTO any_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Anɩn Pɩɛlɩ anʋan wɔ sʋ ɔ tɛ jʋjɔ, bɔlɛ́'n tɩ kɛ kanlannɩɛ, ɔ kɔ a kɔ hala bɛ́ sʋ. Bɔlɛ́ nɩn anun, anɩɛ kʋn kɔ te, yɩ́ nwan: “Sʋanlan ɛhɩ tɩ mɩ́n ehulo Baa. M'an fa mɩ́n lʋa'n kʋalaa m'an wula yɩ́ nun. Ɛmɔ tíe yɩ́!” ");
INSERT INTO any_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Mɔ yɩ́ menian'n-mɔ tɩlɩ anɩɛ sɔ'n, esulo kpili kpa kɔ han bɛ́ dede bɛ kɔ butu butu bɛ́ nyɩn asɩ. ");
INSERT INTO any_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Zozi kɔ a kɔ kpusu kpusu bɛ́, yɩ́ nwan: “Nán bɛ sulo, bɛ jásʋ.” ");
INSERT INTO any_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Bɛ 'kuku bɛ́ ti sʋ a, sʋanlan fɩ́ɩ́ nnʋn man ɛbɛlɛ kɛ Zozi angʋnmɩn ala. ");
INSERT INTO any_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Mɔ bɛ fi bʋka nɩn asʋ bɛ 'ju'n, Zozi kɔ han kɔ hele bɛ́ kɛ: “Like mɔ ɛmɔ a nwun yɩ́'n, nán bɛ kan bɛ kele sʋanlan fɩ́ɩ́ dede ɔ 'ju cɩan mɔ Mân Baa'n fi ewue nun ɔ kɔ tinnge'n.” ");
INSERT INTO any_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Mɔ Zozi hanlɩn sɔ yuelɩ'n, yɩ́ menian'n-mɔ kɔ bisa yɩ́ kɛ: “Ɔ yɔ sɛ mɔ *mala nɩn asʋ mgbain'n-mɔ kan kɛ Eli yɛ̂ ɔ 'di mʋa ba'n?” ");
INSERT INTO any_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Zozi nwan: “Ɔ tɩ sɔ, Eli 'di mʋa ba ɔ sesie ninnge'n kʋalaa kpɛ kpɛ. ");
INSERT INTO any_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Nan kʋsʋ mɩɩn kan mɩn kele ɛmɔ kɛ Eli a a dada angʋnmɩn. Menian'n-mɔ a nnwun man yɩ́ nzɔlɛ, bɛ yɔlɩ yɩ́ kɛ bɛ́ kunnun kulo. Mân Baa'n muonun, kɛ bɛ 'ba hele yɩ́ yalɛ nɩn anɩn.” ");
INSERT INTO any_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Yɩ́ menian'n-mɔ tɩlɩ yɩ́ bʋ kɛ Zʋan Batisi yɛ̂ anɩn ɔ lɛ kan yɩ́ nwʋn ɛjɔlɛ nɩn ɔ. ");
INSERT INTO any_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Mɔ bɛ walɩ dede bɛ juli meninsʋnman nɩn anwʋn ɛbɛlɛ'n, bian kʋn kɔ a kɔ kʋtʋ Zozi anyunnun, yɩ́ nwan: ");
INSERT INTO any_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“Yɛ́ Mɩ́n, nwun mɩ́n wa belenzua nɩn anwʋn anwunnvoe. Ɔ kpɛ, ɔ lɛ nwun yalɛ sʋnman, ɔ tɔ sɩ̂n nun, bie kʋsʋ a, ɔ tɔ asue nun. ");
INSERT INTO any_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","M'an fa yɩ́ m'an bɛlɛ wɔ́ menian'n-mɔ, nan b'a ngʋala man like fɩ́ɩ́ yɔ man yɩ́.” ");
INSERT INTO any_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Zozi nwan: “Ati anun ɛtɛ mma mɔ bɛ nne man Nyanmɩan bɛ nni man, mɩn nʋn ɛmɔ yɛ tánlan ɛwa dede ɔ hɔ́ jú mɛlɛ benin nán ɛmɔ a nyan dedi? N díla mɩ́n ahʋnlɩn n zʋ́ ɛmɔ dede ɔ jú mɛlɛ benin? Bɛ fá batʋnman'n bɛ bɛ́lɛ mɩ́n ɛwa.” ");
INSERT INTO any_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Bɛ kɔ fa batʋnman'n bɛ kɔ bɛlɛ Zozi. Ɔ kɔ jʋjɔ aminle sʋ ɔ kɔ hele wawɛ ɛtɛ'n. Ɔ fi yɩ́ nun kɔ fite. Ɛbɛlɛ ala, batʋnman nɩn anwʋn kɔ sa. ");
INSERT INTO any_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","M'ɔ yɔlɩ sɔ'n, Zozi menian'n-mɔ kɔ fa bɛ́ ti bɛ kɔ bɔ yɩ́ nwʋn, bɛ́ nwan: “Nzukɛ ati yɛ̂ y'a ngʋala man wawɛ ɛtɛ ɛhɩ tu'n?” ");
INSERT INTO any_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Zozi nwan: “Ɛmɔ a ngʋala man yɩ́ tu, ɔ sanlɩn kɛ ɛmɔ dedi'n tɩ kaan sʋnman. Mɩɩn kan yɩ́ ananhɔlɛ mɩn kele ɛmɔ kɛ sɛ ɛmɔ le dedi mɔ yɩ́ kpili ju kɛ muntadɩ baa a, ɛmɔ se bʋka ɛhɩ kɛ: ‘Bʋka, fi ɛwa tu kɔ ɛlɔ’ a, ɔ 'tu kɔ. Like fɩ́ɩ́ nnʋn man ɛbɛlɛ mɔ ɛmɔ ngɔ hʋala man yɩ́ yɔ ɔ.  ");
INSERT INTO any_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Nan m'ɔ tɩ kɛ wawɛ ɛtɛ ɛhɩ sʋa'n, mmʋtʋɛ ɛyɔlɛ nʋn abuala yɛ̂ bɛ fa bɛ tu yɩ́ ɔ.” ");
INSERT INTO any_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Ɛhɩ, anɩn bɛ́ kʋalaa bɛ wɔ Galile mân nɩn anun ɛlɔ. Ɛlɛhʋn kʋn Zozi kɔ fa kɔ tʋ bɛ́ nyunnun kɛ: “Bɛ 'ba yɩ *Mân Baa'n bɛ man menian'n-mɔ ");
INSERT INTO any_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","maan bɛ kun yɩ́. Sɛ ɔ wu a, yɩ́ cɩan nsan nɩn asʋ, ɔ fi ewue nun ɔ 'tinnge.” Yɩ́ ɛjɔlɛ sɔ'n manlɩn yɩ́ menian'n-mɔ anwʋn bubuli bɛ́ kpa. ");
INSERT INTO any_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Mɔ bɛ juli Kapɛɛnawɔmʋn'n, bɛ́ mɔ bɛ dide asɔnɩn sua nɩn anwʋn ajule'n kɔ a kɔ tʋ Pɩɛlɩ, bɛ́ nwan: “Ɛmɔ amɩn'n muonun, ɔ ndua man asɔnɩn sua nɩn anwʋn ajule'n bie ɔ?” ");
INSERT INTO any_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Pɩɛlɩ nwan: “Ɔ tua bie.” Mɔ Pɩɛlɩ bualɩ bɛ́ yuelɩ'n, ɔ kɔ wʋlʋ sua nɩn anun. Ɔ nʋn mɔ ɔ 'wʋlʋ sua nɩn anun'n, Zozi kɔ li mʋa kɔ bisa yɩ́ kɛ: “Simʋn, ɔ tɩ sɛ wɔ́ ɛlɔ? Mân ɛhɩ anun, nwan-mɔ y'ɔ di kɛ bɛ tua ajule bɛ man mmelemgbin'n-mɔ ɔ? Bɛ́ mɔ bɛ le bɛ́ kulo nɩn naan, nyɔfʋɛ'n-mɔ ɔ?” ");
INSERT INTO any_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Pɩɛlɩ nwan: “Nyɔfʋɛ'n-mɔ yɛ̂ bɛ tua ɔ.” Ɛhɩ a, Zozi nwan: “Bɛ́ mɔ bɛ le bɛ́ kulo'n, bɛ ndua man bie. ");
INSERT INTO any_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Nan kʋsʋ kɛmɔ yɛ ngulo man kɛ yɛ dɔ bɛ́ ngasi'n, yɩ́ ti kɔ asue nɩn anʋan ɛlɔ kɔ tʋ kʋba. Ejue mɔ ɛ kɔ li mʋa kɔ hyɩ yɩ́'n, tɛlɛ yɩ́ nʋan nɩn anun. Ɛ 'ba nwun kɛ esika wɔ nun, ɔ sa mɩ́n nʋn wɔ́ yɛ́ ajule'n tua. Fa kɔ tua.” ");
INSERT INTO any_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Mɛlɛ sɔ'n, Zozi menian'n-mɔ walɩ yɩ́ nwʋn ɛbɛlɛ, bɛ kɔ bisa yɩ́ kɛ: “Yɛ́ Mɩn, Anwunno Belemgbin Mân nɩn anun, nwan sʋanlan dɩɛ y'ɔ tɩ kpili tala bɛ́ kʋalaa ɔ?” ");
INSERT INTO any_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Mɔ bɛ bisalɩ kosuan sɔ'n, Zozi kɔ fɛlɛ batʋnman kaan kʋn, ɔ kɔ fa yɩ́ kɔ sie bɛ́ afian ɛbɛlɛ. ");
INSERT INTO any_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Yɛ̂ yɩ́ nwan: “Mɩɩn kan yɩ́ ananhɔlɛ mɩn kele ɛmɔ kɛ sɛ ɛmɔ a ngaci man ɛmɔ abalabɔ'n, b'a nyɔ man kɛ mmatʋnman nganngan an, ɛmɔ ngɔ man Anwunno Belemgbin Mân nɩn anun ɛlɔ bie. ");
INSERT INTO any_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Sʋanlan m'ɔ kɔ bɛbɛlɛ yɩ́ nwʋn asɩ dede ɔ kɔ kaci kɛ batʋnman ɛhɩ'n, yɩ́ y'ɔ tɩ kpili Anwunno Belemgbin Mân nɩn anun ɛlɔ ɔ. ");
INSERT INTO any_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Mɩ́n dunman nun, sʋanlan m'ɔ kɔ le batʋnman kʋn m'ɔ tɩ kɛ ɛhɩ'n, anɩn mɩ́n muonun yɛ̂ ɔ'a le mɩ́n ɔ. ");
INSERT INTO any_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Mmatʋnman ɛhɩ-mɔ mɔ bɛ de mɩ́n bɛ di'n, sʋanlan m'ɔ kɔ man bɛ́ nun kʋn kɔ tɔ ɛtɛ nɩn anun'n, sʋanlan sɔ'n, ɔ di kɛ bɛ fa ɛbʋɛ kpili kpa bɛ mɩnnda yɩ́ kɔmɩn bɛ ju yɩ́ bɛ tʋ jenvie nɩn anun. ");
INSERT INTO any_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Mân nɩn a fa munnzue kɛ nun yɛ̂ ninnge m'ɔ man sʋanlan tɔ ɛtɛ nɩn anun'n wɔ ɔ. Ninnge sɔ'n-mɔ wɔ ɛbɛlɛ daa. Nan munnzue hán sʋanlan ɛhɩ m'ɔ man ɛhɩnlɩn-mɔ tɔ ninnge ɛtɛ sɔ'n-mɔ anun'n. ");
INSERT INTO any_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Yɩ́ ti, sɛ wɔ́ sa kʋn anaan wɔ́ ja kʋn y'ɔ man ɛ tɔ ɛtɛ nɩn anun an, anɩn ko tʋ mʋa. Afɩ sɛ ɔ ka wɔ́ sa kʋn anaan wɔ́ ja kʋn nán ɛ nyan ngʋan nɩn an, ɔ tɩ kpa tala kɛ ɛ kɔ fa wɔ́ sa nnyuan'n, anaan wɔ́ ja nnyuan nɩn ɛ kɔ hɔ sɩ̂n'n m'ɔ nnun man lé nɩn anun'n. ");
INSERT INTO any_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Sɛ wɔ́ nyɩn kʋn y'ɔ man ɛ tɔ ɛtɛ nɩn anun an, anɩn tu tʋ mʋa. Afɩ sɛ ɔ ka wɔ́ nyɩn kʋn nán ɛ nyan ngʋan nɩn an, ɔ tɩ kpa tala kɛ ɛ kɔ fa wɔ́ nyɩn nnyuan nɩn ɛ kɔ hɔ sɩ̂n'n m'ɔ nnun man lé nɩn anun'n. ");
INSERT INTO any_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Ɛmɔ síe bɛ́ nwʋn ye nán b'a ndʋtʋ man mmatʋnman ɛhɩ-mɔ anun bie anyunnun ngɛsɛlɛ. Afɩ mɩɩn kan mɩn kele ɛmɔ kɛ nyanmɩansʋ ɛlɔ, bɛ́ mmɔfʋɛ'n-mɔ jijin mɩ́n Sɩ m'ɔ wɔ anwunno nɩn anyunnun ɛbɛlɛ cɩan daa.  ");
INSERT INTO any_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Ɔ sanlɩn kɛ, Mân Baa'n walɩ kɛ ɔ 'ba kpʋnndɛ bɛ́ mɔ b'a minlin'n nán ɔ de bɛ́ ngʋan. ");
INSERT INTO any_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Sɛ sʋanlan kʋn le yɩ́ mmʋa ɛya, nán sɛ nunhan kʋn minlin an, asʋ ɔ nyaci man abulahʋanlan nʋn ngʋanlan nɩn ɛbɛlɛ, ɔ ngɔ mgbʋnndɛ man kʋn'n mɔ ɔ'a minlin nɩn ɔ? ");
INSERT INTO any_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Mɩɩn kan mɩn kele ɛmɔ kɛ sɛ ɔ nwun yɩ́ a, yɩ́ nwʋn fɛ'n m'ɔ kɔ li'n, ɔ tala mmʋa abulahʋanlan nʋn ngʋanlan'n mɔ b'a mminlin man'n. ");
INSERT INTO any_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Ɛmɔ Asɩ'n m'ɔ wɔ anwunno'n, kɛ ɔ tɩ yɩ́ nɩn ala anɩn. Ɔ ngulo man kɛ mmatʋnman ɛhɩ-mɔ bie minlin. ");
INSERT INTO any_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Sɛ wɔ́ nianman bie yɔ wɔ́ ɛtɛ a, kɔ tʋ yɩ́, fɛlɛ yɩ́ ahanmɩan kan kele yɩ́. Sɛ ɔ nwun yɩ́ ananhɔlɛ a, anɩn wɔ́ sa a han wɔ́ nianman'n. ");
INSERT INTO any_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Sɛ ɛ kan nán ɔ'a ndɛ man wɔ́ sʋ a, fɛlɛ sʋanlan kʋn anaan menian nnyuan ɛmɔ hɔ́ sésie ɛjɔlɛ'n maan bɛ lí nun adanzɩɛ. Ɔ sanlɩn kɛ menian nnyuan anaan menian nsan anʋan ɛjɔlɛ'n yɛ̂ bɛ bu yɩ́ ananhɔlɛ ɔ. ");
INSERT INTO any_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Nan sɛ bɛ kan nán ɔ'a ndie man an, bɔ asɔnɩn mma'n-mɔ amannɩɛ. Sɛ bɛ́ kʋsʋ bɛ kan nán ɔ'a ndie man an, bu yɩ́ kɛ ɔ tɩ sʋanlan m'ɔ nzɩ man Nyanmɩan mɔ yɩ́ ti tɩ ɛtɛ kɛ Zufʋ m'ɔ dide ajule man Lɔmʋn amma'n-mɔ'n. ");
INSERT INTO any_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Mɩɩn kan yɩ́ ananhɔlɛ mɩn kele ɛmɔ kɛ, sʋanlan biala mɔ asɩɛ nɩn asʋ ɛwa ɔ kɔ li yɩ́ ɛtɛ nɩn ananhɔlɛ, m'ɔ kɔ yaci kɔ gua, mɔ ɛmɔ kɔ sɔ yɩ́ nun'n, anɩn b'a sɔ yɩ́ nun anwunno ɛlɔ. Yɛ̂ sʋanlan biala kʋsʋ mɔ asɩɛ nɩn asʋ ɛwa ɔ'a nni man yɩ́ ɛtɛ nɩn ananhɔlɛ, mɔ ɔ'a nyaci ɔ'a ngua man, mɔ ɛmɔ a nzɔ man yɩ́ nun'n, anɩn b'a nzɔ man yɩ́ nun anwunno ɛlɔ. ");
INSERT INTO any_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Ɛsɛ mɩɩn kan yɩ́ ananhɔlɛ mɩn kele ɛmɔ kɛ, asɩɛ nɩn asʋ ɛwa, sɛ menian nnyuan anʋan sɛ bɛ́ nwʋn bɛ bisa like biala wɔ bɛ́ mmʋtʋɛ nɩn anun an, mɩ́n Sɩ m'ɔ wɔ anwunno ɛlɔ'n 'fa man bɛ́. ");
INSERT INTO any_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Ɔ sanlɩn kɛ lɩka biala mɔ menian nnyuan anaan nsan kɔ yia wɔ mɩ́n dunman nun'n, n wɔ bɛ́ afian ɛbɛlɛ.” ");
INSERT INTO any_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Mɔ Zozi hanlɩn sɔ yuelɩ'n, Pɩɛlɩ kɔ hyʋɩn kɔ mantan yɩ́ ɔ kɔ bisa yɩ́ kɛ: “Yɛ́ Mɩn, sɛ mɩ́n nianman bie di mɩ́n nwʋn ɛjɔlɛ ɛtɛ a, anɩn n yáci yɩ́ nwʋn sa n jé yɩ́ fâ nyɛ? N yáci yɩ́ nwʋn sa n jé yɩ́ dede fâ nsʋ ɔ?” ");
INSERT INTO any_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Zozi nwan: “Cɛcɛ, m'an nze man wɔ́ kɛ ɛ fá yɩ́ nwʋn sa ɛ hyé yɩ́ fâ nsʋ, nan fa yɩ́ nwʋn sa ce yɩ́ fâ abulasʋ nʋn nsʋ. ");
INSERT INTO any_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“Ɛhɩ ati, ɛ 'nwun like mɔ Anwunno Belemgbin Mân'n soman yɩ́'n. Belemgbin kʋn nwan ɔ 'dide yɩ́ esika'n kʋalaa mɔ yɩ́ ngʋa'n-mɔ tua yɩ́'n. ");
INSERT INTO any_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Kɛ ɔ bɔlɩ yɩ́ bʋ mɔ ɔ 'tɩtɩ mgbʋndan'n, bɛ nʋn yɩ́ ngʋa'n-mɔ anun kʋn kɔ a, ɔ tua yɩ́ kotoku akpɩɩ kɔ yɔ nyɛ. ");
INSERT INTO any_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Akʋa sɔ'n le man like fɩ́ɩ́ m'ɔ fa tua kalɛ nɩn ɔ. Yɩ́ mɩn'n kɔ man atɩn kɛ bɛ tɔ́nɩn yɩ́ nʋn yɩ́ yɩ, nʋn yɩ́ mma'n-mɔ nʋn bɛ́ nwʋn ninnge'n kʋalaatin bɛ fá bɛ túa kalɛ'n. ");
INSERT INTO any_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","“Mɔ yɩ́ mɩn'n hanlɩn sɔ'n, akʋa'n kɔ tu kɔ tɔ yɩ́ ja nun ɔ kɔ bʋtʋ yɩ́ nwʋn ɔ kɔ hele yɩ́ kɛ: ‘Mɩ́n mɩn, si abʋtalɛ, nán wɔ́ esika'n, m 'ba tua yɩ́ kʋalaa mɩn man wɔ́.’ ");
INSERT INTO any_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Akʋa'n hanlɩn ɛhɩ a, yɩ́ mɩn'n kɔ nwun yɩ́ nwʋn anwunnvoe, ɔ kɔ fa kalɛ'n ɔ kɔ hye yɩ́ ɔ kɔ yaci yɩ́ maan ɔ kɔ hɔ. ");
INSERT INTO any_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Akʋa'n fi ɛbɛlɛ ɔ kɔ fite. Mɔ ɔ 'kɔ'n, ɔ nʋn yɩ́ manngʋn kʋn m'ɔ nʋn yɩ́ di junman lɩka kʋn'n kɔ yia. Yɩ́ manngʋn sɔ'n tua yɩ́ esika kaan bie. Ɔ kɔ sɔ yɩ́ konvin ɔ kɔ mian. Yɩ́ nwan: ‘Tua mɩ́n esika'n man mɩ́n!’ ");
INSERT INTO any_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","“Yɩ́ manngʋn'n kɔ tu kɔ tɔ yɩ́ ja nun ɔ kɔ bʋtʋ yɩ́ nwʋn ɔ kɔ hele yɩ́ kɛ: ‘Anianman, si abʋtalɛ, nán wɔ́ esika'n, mɩn 'ba tua mɩn man wɔ́.’ ");
INSERT INTO any_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","“Ɔ hanlɩn ɛhɩ a, akʋa'n ngɔ tie man, ɔ kɔ man bɛ kɔ hyɩ yɩ́ manngʋn'n bɛ kɔ tʋ yɩ́ fiadɩ dede ɔ kɔ ju cɩan mɔ ɔ kɔ tua yɩ́ kalɛ'n. ");
INSERT INTO any_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Mɔ ngʋa ɛhɩnlɩn-mɔ nwunlin yɩ́ nyɔlɩɛ sɔ'n, bɛ́ nwʋn kɔ bubu bɛ́, bɛ kɔ hɔ kɔ han kɔ hele bɛ́ mɩn'n. ");
INSERT INTO any_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","“Nan mɔ mɩnlɩan'n tɩlɩ ɛjɔlɛ sɔ'n, ɔ kɔ man bɛ kɔ fɛlɛ akʋa sɔ'n, ɔ kɔ han kɔ hele yɩ́ kɛ: ‘Akʋa ati anun ɛtɛ! M'an fa wɔ́ kalɛ'n kʋalaa m'an hye wɔ́. Ɔ sanlɩn kɛ a bʋtʋ wɔ́ nwʋn a hele mɩ́n. ");
INSERT INTO any_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Kɛ n nwunlin wɔ́ nwʋn anwunnvoe'n, wɔ́ kʋsʋ ɔ di kɛ ɛ nwun wɔ́ manngʋn nɩn anwʋn anwunnvoe.’ ");
INSERT INTO any_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Belemgbin'n kɔ fɛ ɛya kpa, ɔ kɔ tʋ akʋa'n kʋsʋ fiadɩ dede ɔ kɔ ju cɩan m'ɔ kɔ tua yɩ́ kalɛ'n.” ");
INSERT INTO any_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Zozi kɔ han kɔ tʋ sʋ kɛ: “Sɛ sʋanlan di ɛmɔ anwʋn ɛjɔlɛ ɛtɛ nán ɛmɔ a nyɩ man bɛ́ kunnun b'a nyaci man yɩ́ nwʋn sa b'a nje man yɩ́ a, mɩ́n Sɩ'n kʋsʋ m'ɔ wɔ anwunno'n nyaci man ɛmɔ anwʋn sa ɔ nje man ɛmɔ.” ");
INSERT INTO any_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Mɔ Zozi yuelɩ yɩ́ ɛjɔlɛ sɔ'n-mɔ kan'n, ɔ fi Galile mân nɩn anun ɛbɛlɛ ɔ kɔ hɔ Zude mân nɩn anun, asue Zuludɩn nɩn anzin ɛlɔ ebue kʋn. ");
INSERT INTO any_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Meninsʋnman sili yɩ́ sʋ. Bɛ 'ba a, bɛ nʋn nwuluwafʋɛ. Zozi manlɩn bɛ́ nwuluwafʋɛ'n-mɔ anwʋn salɩ. ");
INSERT INTO any_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Anɩn *Falisifʋɛ mmie-mɔ wɔ meninsʋnman nɩn anun. Bɛ kɔ kpunnge Zozi anwʋn ɛbɛlɛ. Kɛmɔ bɛ kulo kɛ bɛ sua yɩ́ ngaa nɩn ati, bɛ kɔ bisa yɩ́ kɛ: “Kpain, asʋ yɛ́ mala'n man atɩn kɛ belenzua kʋn kʋala kɛ ɔ sɩn atɩn ngacile biala asʋ ɔ yila yɩ́ yɩ ɔ?” ");
INSERT INTO any_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Bɛ bisalɩ sɔ a, Zozi nwan: “Asʋ ɛmɔ kɩnngalɩ man yɩ́ Ɛhɛlɛ Ɛjɔlɛ nɩn anun lé kɛ abʋbɔ nɩn anun, Bɔfʋɛ'n bɔlɩ belenzua nʋn balasua. ");
INSERT INTO any_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","M'ɔ bɔlɩ bɛ́ yuelɩ'n, yɩ́ nwan: Ɛhɩka ati, belenzua'n fi yɩ́ sɩ nʋn yɩ́ nin abʋ anwʋn 'ba jasʋ. Ɔ 'fa yɩ́ nwʋn bɔ yɩ́ yɩ, nán bɛ́ munnyuan'n bɛ yɔ sʋanlan munmuan kʋn. ");
INSERT INTO any_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Yɩ́ sɔ ɛhɩ, anɩn bɛ tɩ man menian nnyuan kʋ́n, nan b'a yɔ sʋanlan munmuan kʋn. Like mɔ Nyanmɩan kɔ han kɔ bɔ nun'n, kulo sʋanlan n'ɔ tɩ nun.” ");
INSERT INTO any_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Mɔ Zozi hanlɩn sɔ'n, Falisifʋɛ'n-mɔ kɔ bisa yɩ́ kɛ: “Anɩn ɔ yɔ sɛ mɔ Moyizɩ manlɩn atɩn kɛ belenzua hɛ́lɛ eyila kalata ɔ mán yɩ́ yɩ nán ɔ yíla yɩ́'n?” ");
INSERT INTO any_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Zozi nwan: “Moyizɩ manlɩn atɩn kɛ ɛmɔ yíla bɛ́ yɩ-mɔ. Ɔ sanlɩn kɛ ɛmɔ ati anun tɩ ɛtɛ. Nan abʋbɔ nɩn anun'n, anɩn ɔ tɩ man sɔ. ");
INSERT INTO any_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Mɩɩn kan mɩn kele ɛmɔ kɛ sʋanlan mɔ yɩ́ yɩ a mmɔ man bian m'ɔ kɔ yila yɩ́ ɔ kɔ ja balasua fʋfɔlɛ'n, sʋanlan sɔ'n, anɩn ɔ'a tʋn ajaa.” ");
INSERT INTO any_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Mɔ Zozi menian'n-mɔ tɩlɩ ɛjɔlɛ sɔ'n, bɛ́ nwan: “Sɛ eyila nɩn anwʋn ɛjɔlɛ'n tɩ sʋa a, anɩn ɔ tɩ kpa kɛ bɛ nja man bɛ́ nwʋn.” ");
INSERT INTO any_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Mɔ bɛ hanlɩn sɔ'n, Zozi nwan: “Nán menian'n-mɔ kʋalaa yɛ̂ bɛ tɩ ɛjɔlɛ sɔ nɩn abʋ ɔ. Nan bɛ́ mɔ Nyanmɩan a man bɛ́ yɩ́ nwʋn tunmin'n yɛ̂ bɛ kʋala bɛ tɩ yɩ́ bʋ ɔ. ");
INSERT INTO any_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Ninnge dɔʋn wɔ ɛbɛlɛ, ɔ jɩjɩ melenzua'n mmie-mɔ, ɔ man bɛ ngʋala man bala ja. Mmie-mɔ wɔ ɛbɛlɛ, bɛ 'wʋ bɛ́ a, anɩn bɛ́ nwʋn tɩ man kpa. Mmie-mɔ kʋsʋ wɔ ɛbɛlɛ, bɛ sa bɛ́. Mmie-mɔ kʋsʋ wɔ ɛbɛlɛ, Anwunno Belemgbin Mân'n dunman nun, bɛ nja man bala. Sʋanlan m'ɔ sɩ fasie'n, ɔ fá síe!” ");
INSERT INTO any_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Mɔ Zozi hanlɩn sɔ yuelɩ'n, menian mmie-mɔ falɩ mmatʋnman nganngan bɛ bɛlɛlɩ yɩ́ kɛ ɔ fá yɩ́ sa ɔ fúa bɛ́ nwʋn nán ɔ yéyila bɛ́ sʋ. Nan mɔ yɩ́ menian'n-mɔ nwunlin yɩ́ sɔ'n, bɛ jʋjɔlɩ bɛ́. ");
INSERT INTO any_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Ɛhɩ a, Zozi nwan: “Nán bɛ totua mmatʋnman'n-mɔ atɩn, bɛ yáci bɛ́ maan bɛ bála mɩ́n nwʋn. Ɔ sanlɩn kɛ Anwunno Belemgbin Mân'n, bɛ́ mɔ bɛ tɩ kɛ mmatʋnman ɛhɩ-mɔ'n y'ɔ tɩ bɛ́ dɩɛ ɔ.” ");
INSERT INTO any_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Zozi falɩ yɩ́ sa'n-mɔ fualɩ bɛ́ nwʋn yuelɩ, yɩ́ nzin y'ɔ fi ɛbɛlɛ ɔ hɔlɩ ɔ. ");
INSERT INTO any_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Ɛhɩ, sʋanlan kʋn walɩ tʋlɩ Zozi, yɩ́ nwan: “Ngehelefʋɛ, nzu like dɩɛ kpa yɛ̂ n yɔ́ nán m'an nyan ngʋan m'ɔ le man ayuelɩɛ nɩn ɔ?” ");
INSERT INTO any_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","M'ɔ hanlɩn sɔ'n, Zozi kɔ bisa yɩ́ kɛ: “Nzukɛ ati yɛ̂ ɛ lɛ bisa mɩ́n like m'ɔ tɩ kpa nɩn anwʋn ɛjɔlɛ ɔ? Nyanmɩan angʋnmɩn cein y'ɔ tɩ kpa ɔ. Sɛ ɛ kulo kɛ ɛ nyan ngʋan m'ɔ le man ayuelɩɛ nɩn an, anɩn di mala'n-mɔ asʋ.” ");
INSERT INTO any_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Kpafɛlɛ'n kɔ bisa Zozi kɛ: “Anɩn mala benin-mɔ?” Ɛhɩ a, Zozi kɔ bua yɩ́ kɛ: “N'ɛ kun sʋanlan, n'ɛ tʋn ajaa, n'ɛ wua, n'ɛ di ato ɛ tʋ wɔ́ manngʋn bie abʋ, ");
INSERT INTO any_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","man wɔ́ nyɩn sɔ́ wɔ́ sɩ nʋn wɔ́ nin, afɩ kulo wɔ́ manngʋn kɛ wɔ́ muonun wɔ́ nwʋn.” ");
INSERT INTO any_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Mɔ Zozi hanlɩn sɔ'n, kpafɛlɛ'n nwan: “M'an li mala ɛhɩ-mɔ kʋalaa asʋ. Nan nzukɛ like dɩɛ biekun y'ɔ sɛ kɛ n yɔ́ ɔ?” ");
INSERT INTO any_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Zozi nwan: “Sɛ ɛ kulo kɛ ɛ yue kpa yɔ bɔkɔɔ a, anɩn kɔ tɔnɩn wɔ́ ninnge'n kʋalaa mɔ ɛ le yɩ́'n. Esika'n mɔ ɛ kɔ nyan yɩ́'n, fa man ehianfʋɛ'n-mɔ, nán ɛ 'ba nyan anwʋndɩɛ dɔʋn anwunno ɛlɔ. Sɛ ɛ yɔ yɩ́ sɔ yue a, bala nán si mɩ́n sʋ.” ");
INSERT INTO any_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Kpafɛlɛ sɔ'n kʋsʋ a nyan yɩ́ nwʋn kpa. Nan m'ɔ tɩlɩ ɛjɔlɛ'n mɔ Zozi hanlɩn helelɩ yɩ́'n, yɩ́ lʋa bɔlɩ yɩ́ nwʋn ɔ kɔ hɔ. ");
INSERT INTO any_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Ɛhɩ, Zozi kɔ han kɔ hele yɩ́ menian'n-mɔ kɛ: “Mɩɩn kan yɩ́ ananhɔlɛ mɩn kele ɛmɔ kɛ sʋanlan m'ɔ kɔ nyan yɩ́ nwʋn'n, Anwunno Belemgbin Mân nɩn anun ɛlɔ ɛwʋlʋɛ yɔ sɩ kpa man yɩ́. ");
INSERT INTO any_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Ɛsɛ mɩɩn kan mɩn kele ɛmɔ biekun kɛ: ɔ yɔ sɩ man naan kpili'n mɔ bɛ fɛlɛ yɩ́ sʋamo'n kɛ ɔ wʋ́lʋ dɔlɔwa bɔɛ nun. Nan ɔ yɔ sɩ kpa man esikafʋɛ kʋn kɛ ɔ wʋ́lʋ Nyanmɩan Belemgbin Mân nɩn anun.” ");
INSERT INTO any_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Mɔ yɩ́ menian'n-mɔ tɩlɩ ɛjɔlɛ sɔ'n, ɔ sinlin bɛ́ nwʋn kpa. Bɛ́ nwan: “Sɛ ɔ tɩ sɔ a, anɩn nwan sʋanlan dɩɛ yɛ̂ ɔ kʋala Anwunno Belemgbin Mân nɩn anun kɔ ɔ?” ");
INSERT INTO any_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Zozi nɩanlɩn bɛ́ dede a, yɩ́ nwan: “Ɔ yɔ sɩ man menian'n-mɔ, nan ɔ nyɔ sɩ mman man Nyanmɩan.” ");
INSERT INTO any_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Ɛhɩ, Pɩɛlɩ kɔ jasʋ, yɩ́ nwan: “Yɛ́ mɔ y'a yaci yɛ́ ninnge'n kʋalaatin mɔ yɛ si wɔ́ sʋ'n, anɩn yɛ́ kʋsʋ yɛ́ dɩɛ tɩ sɛ?” ");
INSERT INTO any_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Zozi nwan: “Mɩɩn kan yɩ́ ananhɔlɛ mɩn kele ɛmɔ kɛ mɛlɛ mɔ *Mân Baa'n 'ba tanlan yɩ́ anunminnyanmʋn belemgbin bia nɩn asʋ mân fʋfɔlɛ nɩn anun'n, ɛmɔ menian bulu nʋn nnyuan'n mɔ ɛmɔ si mɩ́n sʋ'n, ɛmɔ 'ba tanlan belemgbin bia sʋ bɛ bua Izalayɛ nvilie bulu nʋn nnyuan'n ndɛɛ. ");
INSERT INTO any_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Ɛsɛ sʋanlan biala mɔ mɩ́n ti, ɔ kɔ yaci yɩ́ awulo, yɩ́ nianman mmelenzua anaan mmalasua, yɩ́ sɩ anaan yɩ́ nin, yɩ́ mma, anaan yɩ́ ebo, ɔ 'nyan yɩ́ nwʋn sʋ fâ ɛya, ɛsɛ ɔ 'nyan nyanmɩansʋ ngʋan m'ɔ le man ayuelɩɛ'n. ");
INSERT INTO any_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Nan kʋsʋ, bɛ́ mɔ kɩkaala bɛ li mʋa'n, bɛ́ dɔʋn bɛ 'ba ha sian. Yɛ̂ bɛ́ dɔʋn kʋsʋ mɔ bɛ halɩ sian'n, bɛ 'ba li mʋa. ");
INSERT INTO any_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Ɛ 'nwun like mɔ Anwunno Belemgbin Mân'n soman yɩ́'n: Ɛlɛhʋn kʋn mɩnlɩan kʋn kɔ jasʋ ngɛlɛmɔ tutun kpa, ɔ 'kɔ a kpʋnndɛ menian maan bɛ di junman yɩ́ divɩn ebo nɩn asʋ. ");
INSERT INTO any_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Bɛ́ m'ɔ nwunlin bɛ́'n, ɔ nʋn bɛ́ kɔ li cɩan kʋn junman nɩn anwʋn gua. Y'ɔ nʋn bɛ́ hɔlɩ yɩ́ divɩn ebo nɩn asʋ ɔ. ");
INSERT INTO any_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","“Ngɛlɛmɔ dɔɛ ngʋanlan ɔ kɔ fite gua nɩn asʋ ɛlɔ biekun. Ɔ 'nɩan an, menian mmiekun-mɔ gugua gua nɩn asʋ, bɛ le man junman bɛ nni man. ");
INSERT INTO any_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Ɔ kɔ han kɔ hele bɛ́ kɛ: ‘Ɛmɔ kʋsʋ hɔ́ lí junman mɩ́n ebo nɩn asʋ nán yɩ́ nwʋn ahatua m'ɔ sɛ fata'n, mɩ́n 'fa mɩn man ɛmɔ.’ ");
INSERT INTO any_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","“Ɔ hanlɩn an, menian'n-mɔ kɔ tie bɛ kɔ hɔ junman nɩn elie yɩ́ ebo nɩn asʋ. Sɛnzɛjinlan nʋn nɔsʋba dɔɛ nsan, bian'n kɔ fite biekun, ɔ kɔ nwun menian mmiekun-mɔ nán ɔ'a fa bɛ́. ");
INSERT INTO any_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Mɔ bɛ 'kɔ a bɔ nɔsʋba dɔɛ nnun'n, ɔ kɔ nwun mmiekun-mɔ gua nɩn asʋ, nán ɔ'a bisa bɛ́ kɛ: ‘Nzukɛ ati yɛ̂ ɛmɔ gua ɛwa mgban sʋa mɔ ɛmɔ nni man junman fɩ́ɩ́'n?’ ");
INSERT INTO any_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","“Bɛ́ nwan: ‘Sʋanlan manlɩn man yɛ́ junman ti ɔ.’ “Bian'n nwan: ‘O, anɩn ɛmɔ hɔ́ lí junman mɩ́n divɩn ebo nɩn asʋ.’ ");
INSERT INTO any_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Nɔsʋba mɔ bɛ kpɔnzʋlɩ'n, ɔ kɔ fɛlɛ kpain'n m'ɔ nɩan yɩ́ junman nɩn asʋ'n, yɩ́ nwan: ‘Fɛfɛlɛ kpafʋ'n-mɔ kʋalaatin nán tua bɛ́ esika'n man bɛ́. Ɛ 'tua, di mʋa bɔ yɩ́ bʋ bɛ́ mɔ n valɩ bɛ́ nɔsʋba nun'n dede nán ɔ'a tʋ bɛ́ mɔ n valɩ bɛ́ ngɛlɛmɔ nun'n.’ ");
INSERT INTO any_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","“Bɛ kɔ fɛfɛlɛ bɛ́ mɔ bɛ falɩ bɛ́ dɔɛ nnun'n, bɛ kɔ tua bɛ́ cɩan kʋn junman esika'n bɛ kɔ man bɛ́. ");
INSERT INTO any_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Mɔ bɛ́ mɔ bɛ lili mʋa bɛ falɩ bɛ́'n 'de bɛ́ esika dɩɛ'n, bɛ jʋnlɩn kɛ ɔ 'ba hɔ yɩ́ nyunnun tala dɔɛ nnun mma'n-mɔ dɩɛ'n. Ɔ'a nyɔ man sɔ, nan cɩan kʋn junman esika nɩn ala yɛ̂ bɛ tualɩ manlɩn bɛ́ ɔ. ");
INSERT INTO any_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Bɛ 'de bɛ́ esika nɩn an, anɩn bɛ lɛ jʋjɔ bian'n bɛ́ konvin abʋ. ");
INSERT INTO any_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Bɛ́ nwan: ‘Kpafʋ ɛhɩ-mɔ mɔ b'a li junman dɔhyʋɩlɩ kʋnmgba'n, esika'n mɔ a tua bɛ́'n nʋn yɛ́ dɩɛ'n sɛ, yɛ́ mɔ yɛ jin eyua heleman ɛhɩ anun y'a li junman dede alɩɛ nɩn a fa a san'n!’ ");
INSERT INTO any_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“Mɔ bɛ jʋjɔlɩ sɔ'n nán bian nɩn a tua a se bɛ́ nunhan kʋn kɛ: ‘Mɩ́n manngʋn, m'an nnaka man wɔ́ o. Nán cɩan kʋn junman gua'n mɔ yɛ́ nʋan sɛlɩ yɩ́ nwʋn'n yɛ̂ m'an tua m'an man wɔ́ nɩn ɔ? ");
INSERT INTO any_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Fa wɔ́ esika'n nán kɔ. Cɩan kʋn junman esika'n mɔ mɩɩn fa mɩn man wɔ́'n, yɩ́ kʋnmgba'n yɛ̂ mɩn 'fa mɩn man bɛ́ mɔ n valɩ bɛ́ dɔɛ nnun nɩn ɔ. ");
INSERT INTO any_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Mɩ́n esika ɔ, kɛ mɩn kulo kɛ mɩn yɔ yɩ́'n yɛ̂ mɩn yɔ ɔ. Anaan kɛmɔ m'an yɔ sian mma'n-mɔ kpa'n, ɔ yɔ wɔ́ ɛya ɔ?’” ");
INSERT INTO any_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Ɛhɩ, Zozi kɔ han kɔ tʋ sʋ kɛ: “Bɛ́ mɔ bɛ li sian'n, bɛ 'di mʋa yɛ̂ bɛ́ mɔ bɛ li mʋa'n, bɛ 'di sian.” ");
INSERT INTO any_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Ɛhɩ anzin, mɔ Zozi 'kɔ Zoluzalɛmʋn'n, atunnun, ɔ kɔ fɛlɛ yɩ́ menian bulu nʋn nnyuan nɩn ahanmɩan, ɔ kɔ han kɔ hele bɛ́ kɛ: ");
INSERT INTO any_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Ɛmɔ tíe, yɛ lɛ kɔ Zoluzalɛmʋn. Sɛ yɛ ju ɛlɔ a, bɛ 'ba yɩ *Mân Baa'n bɛ man Nyanmɩan *tɛɛyɩfʋɛ mgbain'n-mɔ, ɔ nʋn *mala nɩn asʋ mgbain'n-mɔ maan bɛ kun yɩ́. ");
INSERT INTO any_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Bɛ 'fa yɩ́ bɛ man bɛ́ mɔ bɛ tɩ man Zufʋ'n maan bɛ gʋlʋ yɩ́ nwʋn, bɛ fin yɩ́ mgbele bɛ bʋbɔ yɩ́ kʋlʋwa nɩn asʋ. Ɔ wu a, yɩ́ cɩan nsan nɩn asʋ, ɔ 'tinnge.” ");
INSERT INTO any_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Ɛhɩ, Zebede amma'n-mɔ anin nʋn bɛ́ walɩ Zozi anwʋn ɛbɛlɛ. Ɔ kɔ kʋtʋ yɩ́ nyunnun ɔ kɔ sɛlɛ yɩ́ kɛ ɔ yɔ́ like kʋn mán yɩ́. ");
INSERT INTO any_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Zozi kɔ bisa yɩ́ kɛ: “Nzukɛ yɛ̂ ɛ kulo kɛ n yɔ́ m mán wɔ́ ɔ?” Balasua'n nwan: “Mɩ́n mma nnyuan ɛhɩ-mɔ mɔ bɛ wɔ ɛwa'n, cɩan mɔ ɛ kɔ kaci belemgbin'n, man kʋn tánlan wɔ́ sa fama sʋ, man kʋn'n kʋsʋ tánlan wɔ́ sa bɛ̂ sʋ.” ");
INSERT INTO any_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Mɔ balasua'n hanlɩn ɛhɩ'n, Zozi nwan: “Like'n mɔ ɛmɔ lɛ kpʋnndɛ'n, ɛmɔ nzɩ man. Asʋ kangɔ'n mɔ mɩn 'ba nʋn nun'n, ɛmɔ kɔ hʋala nun nʋn ɔ?” Bɛ́ nwan: “Yuo, yɛ kɔ hʋala nun nʋn.” ");
INSERT INTO any_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Zozi nwan: “Ɔ tɩ ananhɔlɛ kɛ ɛmɔ 'ba nʋn mɩ́n kangɔ nɩn anun, nan kʋsʋ m'ɔ tɩ mɩ́n fama sʋ, anaan mɩ́n bɛ̂ sʋ ɛtanlan'n, nán mɩ́n yɛ̂ mɩn fa menian'n-mɔ mɩn sie ɛbɛlɛ ɔ. Nan bɛ́ mɔ mɩ́n Sɩ a sesie a man bɛ́'n yɛ̂ ɔ 'fa bɛ́ sie ɛbɛlɛ ɔ.” ");
INSERT INTO any_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Mɔ yɩ́ menian bulu ɛhɩnlɩn-mɔ tɩlɩ ɛjɔlɛ sɔ'n, bɛ fɛlɩ anianman nnyuan nɩn anwʋn ɛya. ");
INSERT INTO any_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Ɛhɩ, Zozi kɔ fɛlɛ bɛ́ kʋalaatin ɔ kɔ han kɔ hele bɛ́ kɛ: “Ɛmɔ sɩ kɛ mân nɩn anun mmelemgbin'n-mɔ, ɔ nʋn bɛ́ mgbain'n-mɔ, bɛ kele bɛ́ menian'n-mɔ yalɛ bɛ sisi bɛ́. ");
INSERT INTO any_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Nan ɛmɔ afian ɛwa dɩɛ, ɔ tɩ man sɔ. Ɛmɔ afian, m'ɔ kulo kɛ ɔ kaci kpain'n, ɔ káci ɛmɔ akʋa. ");
INSERT INTO any_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Ɛmɔ nunhan m'ɔ kulo kɛ ɔ di ɛmɔ anyunnun'n, ɔ yɔ́ ɛmɔ kanga. ");
INSERT INTO any_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Ɛhɩ ati, *Mân Baa'n, ɔ'a mma man kɛ ɔ 'ba maan bɛ sʋ yɩ́, nan yɩ́ muonun ɔ walɩ menian'n-mɔ ɛsʋ́ɛ nán ɔ'a fa yɩ́ ngʋan'n ɔ'a le menian dɔʋn ati.” ");
INSERT INTO any_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Mɔ bɛ fi Zeliko kulo nɩn anun bɛ 'fite'n, menian dɔʋn kpa sili bɛ́ sʋ. ");
INSERT INTO any_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Anɩn anyɩnsinlinwafʋɛ nnyuan gua atɩn nɩn anʋan ɛbɛlɛ. Mɔ bɛ tɩlɩ kɛ Zozi lɛ sɩn'n, bɛ kɔ tɩan nun, bɛ́ nwan: “Yɛ́ Mɩn, belemgbin *Davidi Awa, nwun yɛ́ nwʋn anwunnvoe!” ");
INSERT INTO any_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Menian'n-mɔ kɔ totua bɛ́ kɛ bɛ múan bɛ́ nʋan. Bɛ 'totua bɛ́ a, anɩn bɛlɛ mɔ bɛ lɛ tɩan nun kpa, bɛ́ nwan: “Yɛ́ Mɩn, belemgbin Davidi Awa, nwun yɛ́ nwʋn anwunnvoe!” ");
INSERT INTO any_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Zozi kɔ jinlan ɔ kɔ fɛlɛ bɛ́, ɔ kɔ bisa bɛ́ kɛ: “Nzu yɛ̂ ɛmɔ kulo kɛ n yɔ́ m mán ɛmɔ ɔ?” ");
INSERT INTO any_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Bɛ́ nwan: “Yɛ́ Mɩn, yɔ maan yɛ nwún asɩ.” ");
INSERT INTO any_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Bɛ́ nwʋn kɔ yɔ Zozi koun. Ɔ kɔ fa yɩ́ sa'n kɔ fua bɛ́ nyɩn'n. Ɛbɛlɛ ala, bɛ kɔ nwun asɩ yɛ̂ bɛ sili yɩ́ sʋ ɔ. ");
INSERT INTO any_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Zozi nʋn yɩ́ menian'n-mɔ, bɛ kɔ a dede bɛ kɔ ju kulo'n mɔ bɛ fɛlɛ yɩ́ Bɛtɩfaze nɩn asʋ. Kulo sɔ'n mantan Zoluzalɛmʋn. Bɛ kɔ bɔ nun *Olivʋ bʋka nɩn asʋ. Ɛbɛlɛ, Zozi kɔ sʋan yɩ́ menian'n-mɔ anun nnyuan, ");
INSERT INTO any_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","yɩ́ nwan: “Ɛmɔ hɔ́ kulo'n m'ɔ wɔ ɛmɔ anyunnun ɛlɔ nɩn asʋ. Mɔ ɛmɔ 'fite kulo nɩn asʋ ɛbɛlɛ ala'n, ɛmɔ 'ba nwun kɛ afunlunmun bɩlɩɛ kʋn nʋn yɩ́ wa mɩnnda ɛbɛlɛ. Ɛmɔ nyánnjɩ bɛ́ bɛ bɛ́lɛ mɩ́n. ");
INSERT INTO any_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Sɛ sʋanlan bie bisa ɛmɔ ɛjɔlɛ a, ɛmɔ hán kɛ: ‘Yɛ́ Mɩn a hian yɩ́ nwʋn.’ Ɛmɔ kan sɔ a, bɛ 'ba yaci ɛmɔ maan bɛ fa bɛ́ bɛ ba.” ");
INSERT INTO any_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Ɔ man ɛjɔlɛ'n mɔ Nyanmɩan kpɔmanfʋɛ'n hanlɩn'n kpɩnlɩn sʋ: ");
INSERT INTO any_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Nyanmɩan nwan: Kan kele Siʋn amma'n-mɔ, ɛmɔ nɩ́an, ɛmɔ belemgbin'n tɩ afunlunmun sʋ. Yɩ́ ahʋnlɩn la asɩ ɔ lɛ ba ɛmɔ anwʋn ɛlɔ ɔ tɩ afunlunmun baa kʋn asʋ. ");
INSERT INTO any_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Mɔ Zozi manlɩn bɛ́ ngalɩɛ sɔ'n yuelɩ'n, yɛ̂ yɩ́ menian nnyuan'n hɔlɩ ɔ. Like'n mɔ Zozi helelɩ bɛ́ kɛ bɛ yɔ́'n, bɛ yɔlɩ. ");
INSERT INTO any_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Bɛ kɔ fa afunlunmun'n nʋn yɩ́ wa'n bɛ kɔ a. Bɛ kɔ yɩyɩ bɛ́ taladɩɛ'n-mɔ bɛ kɔ gua bɛ́ sʋ, yɛ̂ Zozi fʋlɩ tanlanlɩn afunlunmun baa nɩn asʋ ɔ. ");
INSERT INTO any_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Menian dɔʋn kpa kɔ yɩyɩ bɛ́ taladɩɛ'n bɛ kɔ sɩsɛ yɩ́ atɩn nɩn anun. Mmie-mɔ kʋsʋ kɔ kpɩkpɛ aye malɛ bɛ kɔ sɩsɛ yɩ́ atɩn nɩn anun. ");
INSERT INTO any_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Bɛ́ mɔ bɛ li bɛ́ nyunnun'n ɔ nʋn bɛ́ mɔ bɛ li Zozi anzin'n kɔ bɔ kɔ sulo. Bɛ́ nwan: “Hozanna! Nyila hán belemgbin *Davidi Awa'n! Nyila hán sʋanlan ɛhɩ m'ɔ lɛ ba wɔ yɛ́ Mɩn dunman nun'n! Hozanna! Nyila hán Nannan Nyanmɩan m'ɔ wɔ anwunno anwunno ɛlɔ'n!” ");
INSERT INTO any_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Mɔ Zozi 'wʋlʋ Zoluzalɛmʋn kulo nɩn anun'n, kulo bɔndɩn'n kɔ kpusu. Menian'n-mɔ kɔ bisa kɛ: “Nwan sʋanlan dɩɛ ɔ?” ");
INSERT INTO any_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Meninsʋnman'n nwan: “Nyanmɩan kpɔmanfʋɛ Zozi m'ɔ fi Galile kulo'n mɔ bɛ fɛlɛ yɩ́ Nazalɛtɩ nɩn asʋ nɩn ɔ.” ");
INSERT INTO any_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Zozi kɔ wʋlʋ Nyanmɩan awulo nɩn anun, ɔ kɔ fʋan bɛ́ kʋalaa mɔ bɛ lɛ di gua nun'n. Ɔ kɔ han bɛ́ mɔ bɛ kaci esika'n tɔbɩlɩ'n-mɔ kɔ gua. Bɛ mɔ bɛ lɛ tɔnɩn mɔlɔnʋnman'n, ɔ kɔ han bɛ́ bia'n-mɔ kɔ gua. ");
INSERT INTO any_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","M'ɔ hanlɩn bɛ́ ninnge'n-mɔ gualɩ yuelɩ'n, yɩ́ nwan: “Nyanmɩan Anʋan Ɛjɔlɛ'n lɛ kele kɛ: Bɛ 'ba fɛlɛ mɩ́n sua'n mmʋtʋɛ sua. Nan ɛmɔ dɩɛ, ɛmɔ a fa a kaci awue sua!” ");
INSERT INTO any_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Anyɩnsinlinwafʋɛ, ɔ nʋn bɛ́ mɔ bɛ tia bɛ tɔ sʋ'n mmie-mɔ kɔ a Nyanmɩan awulo nɩn anun, Zozi anwʋn ɛbɛlɛ. Zozi kɔ man bɛ́ nwʋn kɔ sa. ");
INSERT INTO any_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Nan mɔ Nyanmɩan *tɛɛyɩfʋɛ'n-mɔ, ɔ nʋn *mala nɩn asʋ mgbain'n-mɔ nwunlin asinbɛnwʋn ninnge'n mɔ Zozi yɔlɩ'n, ɔ nʋn mmatʋnman'n-mɔ mɔ anɩn bɛ lɛ tɩan Nyanmɩan awulo nɩn anun bɛ́ kan kɛ: “Anunminnyanmʋn hán belemgbin *Davidi Awa'n!”, Zozi anwʋn kɔ yɔ bɛ́ ɛya. ");
INSERT INTO any_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Ɛhɩ, bɛ kɔ bisa Zozi kɛ: “Asʋ ɛ tɩ ɛjɔlɛ'n mɔ bɛ lɛ kan'n?” Zozi nwan: “Yuo o. Ɛhɛlɛ Ɛjɔlɛ nwan: A fa ayɛ ɛyɩɛ nɩn a wula mmatʋnman'n-mɔ nʋn adɔman'n-mɔ anʋan. Ɛjɔlɛ sɔ'n-mɔ, asʋ ɛmɔ kɩnngalɩ man yɩ́ lé ɔ?” ");
INSERT INTO any_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","M'ɔ hanlɩn sɔ yuelɩ'n, ɔ kɔ yaci bɛ́ ɛbɛlɛ ɔ fi kulo nɩn anun ɔ kɔ fite ɔ kɔ hɔ kɔ la Betanin kulo nɩn asʋ. ");
INSERT INTO any_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Alɩ́ɛ hɩnlɩn mɔ Zozi 'sa ba Zoluzalɛmʋn'n, ɛhɔɛ kɔ hun yɩ́. ");
INSERT INTO any_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Ɔ kɔ nwun *figi baka kʋn atɩn nɩn anʋan, ɔ kɔ hɔ yɩ́ bʋ. Ɔ juli ɛbɛlɛ a, nyâ ngʋnmɩn, ɔ ngɔ nyan baa sʋ. Ɛhɩ, ɔ kɔ se figi baka'n kɛ: “Ɔ fi ɛnɛ m'ɔ kɔ'n, ɛ nzu man baa fɩ́ɩ́ kʋ́n lé.” Ɛbɛlɛ ala, figi baka'n kɔ yue yʋɩ bɔkɔɔ. ");
INSERT INTO any_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Mɔ yɩ́ menian'n-mɔ nwunlin yɩ́ sɔ'n, ɔ sinlin bɛ́ nwʋn. Bɛ kɔ bisa Zozi kɛ: “Nan ɔ yɔ sɛ mɔ figi baka nɩn a yue yʋɩ kɩkaala'n?” ");
INSERT INTO any_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Zozi nwan: “Mɩɩn kan yɩ́ ananhɔlɛ mɩn kele ɛmɔ kɛ sɛ ɛmɔ le dedi mɔ ɛmɔ dedi'n jin yɩ́ ja nun'n, mɔ m'an yɔ figi baka ɛhɩ'n, ɛmɔ 'ba hʋala yɩ́ yɔ, ɛsɛ bɔbɔ sɛ ɛmɔ se bʋka ɛhɩ kɛ: ‘Tu wɔ́ bʋ ɛwa, tutu kɔ tɔ jenvie nɩn anun’ an, ɔ 'kɔ. ");
INSERT INTO any_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Sɛ ɛmɔ le dedi a, like biala mɔ ɛmɔ kɔ bisa yɩ́ mmʋtʋɛ nɩn anun'n, ɛmɔ asa 'kan yɩ́.” ");
INSERT INTO any_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Zozi kɔ wʋlʋ Nyanmɩan awulo nɩn anun, ɔ kɔ hehele menian'n-mɔ Nyanmɩan Anʋan Ɛjɔlɛ'n. Nyanmɩan *tɛɛyɩfʋɛ mgbain'n-mɔ nʋn Zufʋ mgbain'n-mɔ kpʋlɩ Zozi, bɛ́ nwan: “Tunmin benin yɛ̂ ɛ le yɩ́ ɛ yɔ ninnge sʋa-mɔ ɔ? Nwan sʋanlan dɩɛ y'ɔ manlɩn wɔ́ yɩ́ nwʋn atɩn ɔ?” ");
INSERT INTO any_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Zozi nwan: “Mɩn 'bisa ɛmɔ kosuan kʋn. Sɛ ɛmɔ tu yɩ́ nʋan an, mɩ́n kʋsʋ mɩn 'kele ɛmɔ sʋanlan'n m'ɔ man mɩ́n tunmin maan mɩn yɔ ninnge sʋa-mɔ'n. ");
INSERT INTO any_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Nyanmɩan y'ɔ sʋanlɩn Zʋan kɛ ɔ sɔ́nɩn menian'n-mɔ ɔ, anaan kulo menian'n-mɔ yɛ̂ bɛ sʋanlɩn yɩ́ ɔ?” Mɔ Zozi bisalɩ bɛ́ kosuan sɔ'n, akpʋlʋwa tɔlɩ bɛ́ afian ɛlɔ. Bɛ́ nwan: “Sɛ yɛ kan kɛ Nyanmɩan yɛ̂ ɔ sʋanlɩn yɩ́ a, ɔ 'ba bisa yɛ́ kɛ: ‘Nan nzukɛ ati yɛ̂ ɛmɔ a nne man yɩ́ b'a nni man'n?’ ");
INSERT INTO any_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Nan sɛ yɛ kan kɛ: ‘Menian'n-mɔ yɛ̂ bɛ sʋanlan yɩ́’ a, meninsʋnman'n 'fɛ yɛ́ nwʋn ɛya. Afɩ bɛ́ kʋalaa bɛ de bɛ di kɛ Zʋan tɩ Nyanmɩan kpɔmanfʋɛ.” ");
INSERT INTO any_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Ɛhɩ a, bɛ kɔ bua Zozi kɛ: “Yɛ nzɩ man.” Zozi kʋsʋ nwan: “Sɛ ɛmɔ nzɩ man an, mɩ́n kʋsʋ mɩn ngan man sʋanlan'n m'ɔ man mɩ́n tunmin maan mɩn yɔ ninnge sɔ'n-mɔ'n mɩn ngele man ɛmɔ.” ");
INSERT INTO any_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Ɛsɛ Zozi nwan: “Ɛmɔ tíe. Anɩn bian kʋn le yɩ́ mma nnyuan. Cɩan kʋn, ɔ kɔ han kɔ hele nunhan kpain'n kɛ: ‘Mɩ́n wa, ɛnɛ, kɔ divɩn ebo nɩn asʋ ɛlɔ kɔ li junman.’ ");
INSERT INTO any_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","“Batʋnman'n tua se yɩ́ sɩ kɛ: ‘Mɩn ngɔ man.’ Ɔ tɩ ɛbɛlɛ dede yɩ́ nzin hyɛlɩ, ɔ kɔ jasʋ ɔ kɔ hɔ ebo nɩn asʋ. ");
INSERT INTO any_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","“Sɩɛ'n kɔ han ɛjɔlɛ kʋnmgba sɔ'n ɔ kɔ hele yɩ́ wa kutua'n. Ɔ hanlɩn an, yɩ́ wa'n nwan: ‘Baba, m'an tɩ, mɩn 'kɔ.’ Baa'n ngɔ hɔ man ebo nɩn asʋ. ");
INSERT INTO any_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","“Anɩn mmatʋnman nnyuan'n, benin y'ɔ yɔlɩ yɩ́ sɩ ehulo like ɔ?” Bɛ́ nwan: “Nunhan kpain nɩn ɔ.” Ɛhɩ, Zozi nwan: “Mɩɩn kan yɩ́ ananhɔlɛ mɩn kele ɛmɔ kɛ, bɛ́ mɔ bɛ dide ajule'n, ɔ nʋn tutu'n-mɔ, bɛ 'di mʋa ɛmɔ anyunnun Nyanmɩan Belemgbin Mân nɩn anun ɛlɔ. ");
INSERT INTO any_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Ɔ sanlɩn kɛ Zʋan walɩ, ɔ helelɩ ɛmɔ atɩn kpa'n, nan ɛmɔ a nva man sʋ. Nan bɛ́ mɔ bɛ dide ajule'n, ɔ nʋn tutu'n-mɔ, bɛ́ dɩɛ, bɛ lelɩ yɩ́ bɛ lili. Ɛmɔ a nwun kɛ menian sɔ'n-mɔ kʋalaa a le yɩ́ a li. Nan ɛmɔ dɩɛ, ɛmɔ a nnun man bɛ́ nwʋn b'a ngaci man bɛ́ abalabɔ'n, b'a nne man yɩ́ b'a nni man.” ");
INSERT INTO any_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“Ɛmɔ tíe anyɩnndala kʋn biekun. Anɩn bian kʋn le yɩ́ divɩn ebo. Ɔ kɔ le yɩ́ nwʋn. Ɔ kɔ fun kunman kʋn m'ɔ hyuhyuin yɩ́ nzan'n gua nun ɔ. Ɔ kɔ si sua hyilili kʋn sʋ. Sua sɔ'n tɩ kannganlaun. Bɛ fʋ sʋ bɛ sisa ebo'n. M'ɔ yuelɩ'n, ɔ kɔ fa ebo'n kɔ wula kpafʋ-mɔ asa nun. Yɛ̂ ɔ hɔlɩ yɩ́ atɩn ɔ. ");
INSERT INTO any_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Ɔ wɔ ɛbɛlɛ dede mɔ divɩn nɩn ɛtɩɛ'n tɛmʋn juli'n, bian'n kɔ sʋan yɩ́ ngʋa'n-mɔ kɛ bɛ hɔ́ kpafʋ'n-mɔ anwʋn ɛlɔ, bɛ hɔ́ lé yɩ́ dɩɛ'n bɛ bɛ́lɛ yɩ́. ");
INSERT INTO any_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","“Kpafʋ'n-mɔ kɔ hyɩ bian'n ngʋa'n-mɔ bɛ kɔ bʋ kʋn, bɛ kɔ hun kʋn, bɛ kɔ tʋtʋ nunhan kʋn kʋsʋ ɛbʋɛ bɛ kɔ hun yɩ́. ");
INSERT INTO any_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Ɛsɛ bian'n kɔ sʋan yɩ́ ngʋa'n mmiekun-mɔ dɔʋn bɛ talalɩ alimʋa dɩɛ'n-mɔ. Ɛsɛ kpafʋ-mɔ kɔ yɔ bɛ́ kɛ bɛ yɔlɩ ɛhɩnlɩn-mɔ'n. ");
INSERT INTO any_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Sian dɩɛ, bian'n kɔ sʋan yɩ́ muonun yɩ́ wa'n bɛ́ nwʋn ɛlɔ. Yɩ́ nwan: ‘Kɛmɔ ɔ tɩ mɩ́n kunnun baa'n, mɩn de mɩn di kɛ bɛ 'ba man yɩ́ anyɩnnzɔ.’ ");
INSERT INTO any_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","“Nan mɛlɛ mɔ bɛ nwunlin bian nɩn awa'n, bɛ́ nwan: ‘Bɛ nɩ́an, bian ɛhɩ m'ɔ lɛ ba'n, cɩan bie dede yɩ́ dein yɛ̂ ɔ 'di ajâ'n ɔ fa ebo nɩn ɔ. Yɩ́ ti, bɛ mán yɛ hún yɩ́ yɛ fá ebo'n.’ ");
INSERT INTO any_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Ɛhɩ a, bɛ kɔ hyɩ bian nɩn awa'n bɛ nʋn yɩ́ kɔ hɔ ebo nɩn anʋan ɛlɔ bɛ kɔ hun yɩ́. ");
INSERT INTO any_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","“Nan sɛ bian'n m'ɔ le ebo'n ba a, kpafʋ sɔ'n-mɔ, nzu yɛ̂ ɛmɔ de di kɛ ɔ 'yɔ bɛ́ ɔ?” ");
INSERT INTO any_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Bɛ́ nwan: “Ɔ nnwun man bɛ́ nwʋn anwunnvoe, ɔ 'kun kpafʋ ati anun ɛtɛ sɔ'n-mɔ ɔ fa yɩ́ ebo'n wula menian nvʋfɔlɛ asa nun. Tɛmʋn'n ju nán bɛ 'tɩ ebo nɩn an, anɩn bɛ yɩ yɩ́ dɩɛ bɛ bɛlɛ yɩ́.” ");
INSERT INTO any_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Zozi nwan: “Ɛhɛlɛ Ɛjɔlɛ nɩn anun ɛjɔlɛ kpɔlɛ ɛhɩ, asʋ ɛmɔ kɩnngalɩ man yɩ́ lé ɔ? Ɛbʋɛ'n mɔ bɛ́ mɔ bɛ lɛ si sua nɩn a ju a tʋ'n, yɩ́ yɛ̂ ɔ'a kaci ayialɩɛ nɩn asʋ ɛbʋɛ cɩnnjɩn kpa nɩn ɔ. Like mɔ yɛ́ Mɩn a yɔ nɩn anɩn. Ɔ tɩ ɛnyɩnmɩan like wɔ yɛ́ nyɩnsʋ!” ");
INSERT INTO any_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Zozi kɔ han kɔ tʋ sʋ kɛ: “Ɛhɩ ati, mɩɩn kan mɩn kele ɛmɔ kɛ Nyanmɩan Belemgbin Mân'n, bɛ 'tʋa ɛmɔ bɛ de bɛ man menian mɔ b'a nun bɛ́ nwʋn mɔ bɛ bɔ bala m'ɔ sɔ Nyanmɩan anyɩn'n.  ");
INSERT INTO any_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Sʋanlan biala m'ɔ kɔ tɔ ɛbʋɛ sɔ nɩn asʋ'n, yɩ́ nun 'tɩtɩ. Sʋanlan kʋsʋ mɔ ɛbʋɛ sɔ'n kɔ tɔ yɩ́ sʋ'n, ɔ 'nunkun yɩ́.” ");
INSERT INTO any_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Mɔ Zozi buli anyɩnndala sɔ'n, Nyanmɩan *tɛɛyɩfʋɛ mgbain'n-mɔ nʋn *Falisifʋɛ'n-mɔ nwunlin kɛ bɛ́ nwʋn ɛjɔlɛ yɛ̂ Zozi lɛ kan ɔ. ");
INSERT INTO any_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Ɛhɩ ati, bɛ kpʋnndɛlɩ atɩn mɔ bɛ 'sɩn sʋ bɛ cɩ yɩ́. Nan kʋsʋ, meninsʋnman'n dunman nun, bɛ sulo, bɛ kɔ yaci bɛ kɔ hɔ. Ɔ sanlɩn kɛ menian'n-mɔ bu Zozi kɛ Nyanmɩan kpɔmanfʋɛ. ");
INSERT INTO any_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Zozi buli anyɩnndala mmiekun-mɔ dɔʋn ɔ helelɩ bɛ́. Yɩ́ nwan: ");
INSERT INTO any_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Anwunno Belemgbin Mân'n tɩ kɛ belemgbin kʋn m'ɔ lɛ man yɩ́ wa belenzua kʋn fa yɩ́ yɩ atɔnvɔlɛ ɔ. ");
INSERT INTO any_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Ɔ kɔ sʋan yɩ́ ngʋa'n-mɔ kɛ bɛ hɔ́ fɛ́lɛ bɛ́ m'ɔ tʋlɩ yɩ́ sa fɛlɛlɩ bɛ́'n kɛ b'a sesie alɩɛ nɩn a yue. Bɛ hɔlɩ fɛlɛlɩ bɛ́ a, menian sɔ'n-mɔ fɩ́ɩ́ ngɔ a man. ");
INSERT INTO any_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","“Ɔ kɔ sʋan yɩ́ ngʋa'n mmiekun-mɔ, yɩ́ nʋan la bɛ́ nʋan nun, yɩ́ nwan: ‘Ɛmɔ sé bɛ́ kɛ: M'an hun mɩ́n nnalɛ'n-mɔ nʋn naan'n-mɔ mɔ b'a lɔ kpa'n. M'an sesie alɩɛ nɩn a yue. Yɩ́ ti, ɛmɔ bála atɔnvɔlɛ nɩn abʋ.’ ");
INSERT INTO any_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","“Bɛ hɔlɩ fɛlɛlɩ bɛ́ a, menian sɔ'n-mɔ ngɔ kpinlin belemgbin anwʋn. Ɛhɩ jasʋ a, ɔ lɛ kɔ yɩ́ ebolo, ɛhɩ jasʋ a, ɔ lɛ kɔ a tɔnɩn yɩ́ ninnge. ");
INSERT INTO any_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Mmie-mɔ kʋsʋ kɔ sɔ ngʋa'n-mɔ bɛ kɔ hele bɛ́ yalɛ dede bɛ kɔ hun bɛ́. ");
INSERT INTO any_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Mɔ belemgbin'n tɩlɩ ɛjɔlɛ sɔ'n, ɔ kɔ fɛ ɛya. Ɔ kɔ sʋan yɩ́ nzalafʋ'n-mɔ kɛ bɛ hɔ́ hún kodiawu sɔ'n-mɔ ɛsɛ bɛ yála bɛ́ kulo'n. ");
INSERT INTO any_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","“Mɔ ɛhɩ tɩlɩ yɩ́ nwʋn'n, ɔ kɔ han kɔ hele yɩ́ ngʋa'n-mɔ kɛ: ‘Atɔnvɔlɛ alɩɛ nɩn a bɩn. Nan bɛ́ mɔ n vɛlɛlɩ bɛ́'n, bɛ́ fɩ́ɩ́ b'a mma man. ");
INSERT INTO any_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Yɩ́ ti, ɛmɔ hɔ́ gua nɩn asʋ ɛlɔ, sʋanlan biala mɔ ɛmɔ kɔ nwun yɩ́'n, ɛmɔ fɛ́lɛ yɩ́.’ ");
INSERT INTO any_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Ngʋa'n-mɔ kɔ hɔ gua nɩn asʋ. Bɛ́ kʋalaa mɔ bɛ nʋn bɛ́ yialɩ'n, ati anun ɛtɛ o, ati anun kpa o, bɛ kɔ fɛlɛ bɛ́ dede atɔnvɔlɛ sua'n kɔ yi tɛkɛɛ. ");
INSERT INTO any_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Belemgbin'n kɔ wʋlʋ sua nɩn anun, ɔ kɔ nɛnɩan bɛ́ mɔ bɛ gugua tɔbɩlɩ nɩn anwʋn bɛ lɛ didi'n. Ɔ 'nɩan an, anɩn sʋanlan kʋn tɩ ɛbɛlɛ. Sʋanlan sɔ'n wula man atɔnvɔlɛ taladɩɛ'n bie. ");
INSERT INTO any_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Belemgbin'n kɔ bisa yɩ́ kɛ: ‘Mɩ́n manngʋn, ɛ yɔlɩ sɛ mɔ ɛ wʋlʋlɩ ɛwa, kʋsʋ afɩ ɛ wula man atɔnvɔlɛ taladɩɛ'n bie'n?’ Bian'n ngɔ hʋala man ɛjɔlɛ fɩ́ɩ́ kan. ");
INSERT INTO any_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","“Ɛhɩ, belemgbin'n kɔ han kɔ hele yɩ́ ngʋa'n-mɔ kɛ: ‘Ɛmɔ cɩ́cɩ yɩ́ ja'n nʋn yɩ́ sa'n-mɔ bɛ tʋ́ yɩ́ awosin nɩn anun ɛlɔ gua nɩn asʋ. Ɛlɔ yɛ̂ ɔ 'sun ɛsɛ ɔ 'kʋan yɩ́ je nɩn ɔ.’” ");
INSERT INTO any_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Zozi kɔ han kɔ tʋ sʋ kɛ: “B'a fɛlɛ menian dɔʋn, nan kʋsʋ kaan bie yɛ̂ bɛ 'fa bɛ́ ɔ.” ");
INSERT INTO any_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Ɛhɩ, *Falisifʋɛ'n-mɔ hɔlɩ yialɩ bɛ kpʋnndɛlɩ kosuan mɔ sɛ bɛ bisa Zozi a, ɔ kʋala kɛ ɔ fʋn ɔ tɔ bɛ́ ngaa nɩn anun'n. ");
INSERT INTO any_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Bɛ kɔ sʋan bɛ́ menian'n mmie-mɔ, ɔ nʋn belemgbin *Elɔdɩ menian dɩɛ'n mmie-mɔ Zozi anwʋn ɛlɔ, kɛ bɛ hɔ́ bisa yɩ́ kɛ: “Kpain, yɛ sɩ kɛ wɔ́ dɩɛ ɛ kan ananhɔlɛ. Like mɔ Nyanmɩan kulo kɛ sʋanlan yɔ'n, ɛ kele yɩ́ ananhɔlɛ. Ajʋnlɩn mɔ menian'n-mɔ kɔ fa'n, ɛ nzulo man yɩ́ nzin. Afɩ ɛ nnɩan man sʋanlan nyunnun ɛ mmua man yɩ́ ndɛɛ. ");
INSERT INTO any_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Yɩ́ ti, wɔ́ dɩɛ m'ɔ wɔ wɔ́ ti anun'n, kan maan yɛ tɩ́. Asʋ yɛ́ mala'n kele kɛ yɛ túa ajule anaan nán yɛ tua yɛ man belemgbin Sezaa ɔ?” ");
INSERT INTO any_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Nan mɔ Zozi nwunlin bɛ́ ajʋnlɩn ɛtɛ'n, ɔ kɔ bisa bɛ́ kɛ: “Apoo mma, nzukɛ ati yɛ̂ ɛmɔ lɛ sɔ mɩ́n nɩan ɔ? ");
INSERT INTO any_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Esika'n mɔ ɛmɔ fa tua Sezaa ajule'n, ɛmɔ fá bie bɛ mán n nɩ́an.” Bɛ kɔ fa kʋn bɛ kɔ bɛlɛ yɩ́. ");
INSERT INTO any_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Bɛ nʋn yɩ́ walɩ a, yɩ́ nwan: “Nwan nvoninnin ɔ nʋn nwan dunman dɩɛ yɛ̂ ɔ wɔ sʋ ɔ?” ");
INSERT INTO any_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Bɛ́ nwan: “Belemgbin Sezaa ɔ.” Ɛhɩ a, Zozi nwan: “Like m'ɔ tɩ́ Sezaa dɩɛ'n, ɛmɔ fá mán Sezaa yɛ̂ m'ɔ tɩ Nyanmɩan kʋsʋ dɩɛ'n, ɛmɔ fá mán Nyanmɩan.” ");
INSERT INTO any_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Zozi mmua sɔ'n mɔ bɛ tɩlɩ'n sinlin bɛ́ nwʋn. Bɛ yacili yɩ́ ɛbɛlɛ yɛ̂ bɛ hɔlɩ ɔ. ");
INSERT INTO any_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Cɩan kʋnmgba sɔ'n, *Sadusifʋɛ'n-mɔ mɔ bɛ́ nwan ewuetinnge nnʋn man ɛbɛlɛ'n, bɛ́ mmie-mɔ kɔ a Zozi anwʋn ɛbɛlɛ. Bɛ kɔ bisa yɩ́ kosuan kɛ: ");
INSERT INTO any_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Kpain, ɛ 'nwun ɛjɔlɛ mɔ Moyizɩ a han'n: ‘Sɛ belenzua kʋn ja bala nán ɔ nʋn yɩ́ b'a nwʋ man baa fɩ́ɩ́ dede nán belenzua'n wu a, yɩ́ nianman'n di kɛ ɔ ja bala'n, nán ɔ nʋn yɩ́ wʋ baa bɛ man yɩ́ nianman'n mɔ ɔ'a wu'n.’ ");
INSERT INTO any_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Ɛhɩ, anɩn anianman nsʋ wɔ yɛ́ afian ɛwa. Nunhan kpain'n jalɩ balasua kʋn, ɔ nʋn yɩ́ a nwʋ man baa fɩ́ɩ́ dede ɔ kɔ wu. Yɩ́ nzin baa'n kɔ ja balasua sɔ'n. ");
INSERT INTO any_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Yɩ́ kʋsʋ ɔ nʋn yɩ́ b'a nwʋ man baa fɩ́ɩ́ dede ɔ kɔ wu, yɩ́ nzin baa dɩɛ'n kɔ fa bala'n. Ɔ nʋn yɩ́ b'a nwʋ man baa fɩ́ɩ́ dede yɩ́ kʋsʋ ɔ kɔ wu. Bɛ le yɩ́ sɔ dede bɛ́ menian nsʋ'n kʋalaa bɛ kɔ ja balasua kʋnmgba'n dede ɔ kɔ yia. Bɛ́ fɩ́ɩ́ bɛ nʋn yɩ́ a nwʋ man baa dede bɛ́ kʋalaa bɛ́ kɔ yue wu. ");
INSERT INTO any_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Yɩ́ nzin, balasua'n kʋsʋ kɔ wu. ");
INSERT INTO any_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Ewuetinnge cɩan'n, bɛ́ menian nsʋ'n, nunhan benin yɛ̂ balasua'n tɩ yɩ́ dɩɛ ɔ? Afɩ bɛ́ kʋalaa b'a ja yɩ́ bie.” ");
INSERT INTO any_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Bɛ́ kosuan sɔ nɩn anwʋn, Zozi kɔ bua bɛ́ kɛ: “Ɛmɔ a fʋn, ɔ sanlɩn kɛ ɛmɔ nzɩ man Ɛhɛlɛ Ɛjɔlɛ'n nʋn Nyanmɩan tunmin'n. ");
INSERT INTO any_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Afɩ ewuetinnge cɩan'n, mmelenzua'n-mɔ ngɔ ja man mmalasua kʋ́n, mmalasua'n-mɔ kʋsʋ ngɔ ja man mmelenzua kʋ́n. Nan bɛ́ kʋalaa bɛ 'kaci kɛ nyanmɩansʋ mmɔfʋɛ'n-mɔ. ");
INSERT INTO any_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Ewuetinnge nɩn anwʋn ɛjɔlɛ'n mɔ Nyanmɩan Kpili hanlɩn helelɩ ɛmɔ'n, ɛmɔ kɩnngalɩ man yɩ́ lé ɔ? Ɔ hanlɩn kɛ: ");
INSERT INTO any_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Abalahamʋn nʋn Izakɩ nʋn Zʋakɔbʋ, bɛ́ Nyanmɩan'n y'ɔ le mɩ́n. Ngʋan mma'n-mɔ, bɛ́ Nyanmɩan'n y'ɔ le yɩ́, nan ɔ tɩ man ewue mma Nyanmɩan.” ");
INSERT INTO any_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Mɔ meninsʋnman'n tɩlɩ Zozi ngehele sɔ'n, ɔ sinlin bɛ́ nwʋn. ");
INSERT INTO any_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Mɔ *Falisifʋɛ'n-mɔ tɩlɩ kɛ Zozi a hʋala *Sadusifʋɛ'n-mɔ'n, bɛ kɔ yia ɛbɛlɛ. ");
INSERT INTO any_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Bɛ́ nunhan kʋn tɩ *mala nɩn asʋ kpain. Ɔ kulo kɛ ɔ sɔ Zozi nɩan. Ɔ kɔ bisa yɩ́ kɛ: ");
INSERT INTO any_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Kpain, mala'n nunhan benin y'ɔ tɩ kpili tala bɛ́ kʋalaa ɔ?” ");
INSERT INTO any_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Zozi kɔ bua yɩ́ kɛ: “Fa wɔ́ ahʋnlɩn'n kʋalaa, ɔ nʋn wɔ́ ɛkala'n kʋalaa, ɔ nʋn wɔ́ ajʋnlɩn'n kʋalaa kulo wɔ́ Mɩn Nyanmɩan. ");
INSERT INTO any_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Mala m'ɔ li mʋa m'ɔ tɩ kpili tala bɛ́ kʋalaa nɩn anɩn. ");
INSERT INTO any_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","M'ɔ tian yɩ́ nnyuan, m'ɔ nʋn alimʋa dɩɛ'n tɩ kʋn'n, y'ɔ le ɛhɩ: Ɔ di kɛ ɛ kulo wɔ́ manngʋn kɛ wɔ́ muonun wɔ́ nwʋn. ");
INSERT INTO any_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Mala nnyuan ɛhɩ asʋ yɛ̂ Moyizɩ nʋn Nyanmɩan mgbɔmanfʋɛ'n-mɔ ngehele'n kʋalaa jin ɔ.” ");
INSERT INTO any_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Anɩn *Falisifʋɛ'n-mɔ ati a yia. Zozi kɔ bisa bɛ́ kosuan kɛ: ");
INSERT INTO any_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Ɛmɔ jʋnlɩn kɛ nwan y'ɔ le *Kilisi'n? Ɔ tɩ nwan awa?” Bɛ kɔ bua yɩ́ kɛ: “Ɔ tɩ belemgbin *Davidi awa.” ");
INSERT INTO any_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Zozi nwan: “Nan anɩn ɔ yɔ sɛ mɔ Wawɛ Nwannzan-nwannzan'n manlɩn Davidi fɛlɛlɩ yɩ́ ‘mɩ́n Mɩn'n’? Afɩ Davidi nwan: ");
INSERT INTO any_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Yɛ́ Mɩn a han a hele mɩ́n Mɩn kɛ: Tanlan mɩ́n fama sʋ, nán mɩn 'ba fa wɔ́ mgbɔfʋɛ'n-mɔ mɩn gua wɔ́ ja abʋ. ");
INSERT INTO any_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Sɛ Davidi fɛlɛ yɩ́ ‘mɩ́n Mɩn’ an, anɩn ɔ yɔ sɛ mɔ ɛsɛ Kilisi'n tɩ Davidi awa'n?” ");
INSERT INTO any_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Sʋanlan fɩ́ɩ́ a ngʋala man ɛjɔlɛ kpɔlɛ kʋn bua. Ɔ fi ɛbɛlɛ, sʋanlan fɩ́ɩ́ a ngʋala man Zozi kosuan fɩ́ɩ́ kʋ́n bisa. ");
INSERT INTO any_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Ɛhɩ, Zozi kɔ han kɔ hele meninsʋnman'n nʋn yɩ́ menian'n-mɔ kɛ: ");
INSERT INTO any_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“*Mala nɩn asʋ mgbain'n-mɔ nʋn *Falisifʋɛ'n-mɔ yɛ̂ bɛ tu *Moyizɩ mala nɩn abʋ bɛ kele menian'n-mɔ ɔ. ");
INSERT INTO any_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Ɛmɔ mán bɛ́ nyɩn sɔ́ bɛ́. Like biala mɔ bɛ kɔ hele kɛ ɛmɔ yɔ́'n, ɛmɔ yɔ́. Nan kʋsʋ nán bɛ nɩan bɛ́ nyɔlɩɛ dɩɛ nɩn asʋ bɛ yɔ bie. Ɔ sanlɩn kɛ mala'n mɔ bɛ́ muonun bɛ kele'n, bɛ nni man sʋ. ");
INSERT INTO any_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Bɛ cɩcɩ ninnge nʋnnɔɛ bɛ sʋa menian'n-mɔ, nan kʋsʋ bɛ́ muonun bɛ nva man bɛ́ sa bɛtɩa kʋn bɛ mmʋka man bɛ́. ");
INSERT INTO any_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Bɛ yɔ bɛ́ ninnge dɩɛ'n-mɔ kʋalaa maan menian'n-mɔ nwun bɛ́ nzɔlɛ. Bɛ yɩyɩ Ɛhɛlɛ Ɛjɔlɛ nɩn anun ɛjɔlɛ'n dɔʋn bɛ bɔ yɩ́ kɛ sɛbɛ ndɛtɛlɛ ndɛtɛlɛ bɛ bʋbɔ bɛ́ nwʋnman nɩn asʋ anaan bɛ́ sa. Bɛ yɔ bɛ́ taladɩɛ'n-mɔ anʋan mgbɛsɛ-mgbɛsɛ'n-mɔ ndɩnndɩɩn kpa. ");
INSERT INTO any_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Sɛ menian'n-mɔ yia nán bɛ 'di like a, bɛ́ dɩɛ, menian mgbili mgbili'n-mɔ lɩka'n yɛ̂ bɛ kpʋnndɛ bɛ tanlan ɔ. Nyanmɩan sua nɩn anun bia'n-mɔ m'ɔ jijin bɛ́ nyunnun'n, sʋ yɛ̂ bɛ kulo kɛ bɛ tanlan ɔ. ");
INSERT INTO any_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Bɛ kulo kɛ sɛ menian'n-mɔ yia bagua nun nán sɛ bɛ 'bisa bɛ́ ahɩn an, bɛ kʋ́tʋ, ɛsɛ bɛ fɛ́lɛ bɛ́ ‘mɩnlɩan’. ");
INSERT INTO any_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Ɛmɔ dɩɛ, nán bɛ man sʋanlan fɩ́ɩ́ fɛlɛ ɛmɔ ‘Mɩnlɩan’. Ɔ sanlɩn kɛ ɛmɔ kʋalaa tɩ anianman, ɛsɛ ɛmɔ kʋalaa Amɩn'n tɩ baa kʋnmgba. ");
INSERT INTO any_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Asɩɛ nɩn asʋ ɛwa, nán bɛ fɛlɛ sʋanlan fɩ́ɩ́ ‘Sɩɛ’. Ɔ sanlɩn kɛ Sɩɛ kʋnmgba cein'n mɔ ɛmɔ le yɩ́'n, y'ɔ le nunhan'n m'ɔ wɔ anwunno ɛlɔ'n. ");
INSERT INTO any_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Nán bɛ man sʋanlan fɩ́ɩ́ fɛlɛ ɛmɔ ‘Kpain’. Ɔ sanlɩn kɛ ɛmɔ Kpain'n tɩ baa kʋnmgba cein, y'ɔ le Kilisi. ");
INSERT INTO any_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Sʋanlan m'ɔ tɩ kpili wɔ ɛmɔ afian'n, ɔ di kɛ ɔ yɔ ɛmɔ akʋa. ");
INSERT INTO any_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Sʋanlan m'ɔ kɔ man yɩ́ nwʋn sʋ'n, bɛ 'kan yɩ́ asɩ, nan m'ɔ kɔ han yɩ́ nwʋn asɩ'n, bɛ 'man yɩ́ sʋ. ");
INSERT INTO any_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Ɛmɔ *mala nɩn asʋ mgbain'n-mɔ nʋn ɛmɔ *Falisifʋɛ'n-mɔ, apoo mma, munnzue hán ɛmɔ! Ɛmɔ ngulo man kɛ ɛmɔ kɔ Anwunno Belemgbin Mân nɩn anun, nan kʋsʋ menian mɔ bɛ kulo kɛ bɛ kɔ nun'n, ɛmɔ totua bɛ́ atɩn.  ");
INSERT INTO any_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","“Ɛmɔ mala nɩn asʋ mgbain'n-mɔ nʋn ɛmɔ Falisifʋɛ'n-mɔ, apoo mma, munnzue hán ɛmɔ! Ɛmɔ tʋa kunlannvʋɛ mmalasua'n-mɔ bɛ de bɛ́ ninnge'n kʋalaatin nán ɛmɔ a kpɛ bɛ́ nyɩn b'a yɔ asɔnɩn ndɩnndɩɩn maan menian'n-mɔ nwun kɛ ɛmɔ tɩ kpa. Ɛmɔ nyɔlɩɛ sɔ nɩn anwʋn kalɛ mɔ Nyanmɩan 'ba tua ɛmɔ'n, ɔ tɩ man nzɛmɩndɛ. ");
INSERT INTO any_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Ɛmɔ mala nɩn asʋ mgbain'n-mɔ nʋn ɛmɔ Falisifʋɛ'n-mɔ, apoo mma, munnzue hán ɛmɔ. Ɛmɔ nanndɩ asɩɛ'n lɩka kʋalaatin nʋn jenvie nɩn anyɩnsʋ bɛ kpʋnndɛ sʋanlan maan ɔ kaci yɩ́ nwʋn kɛ Zufʋ'n-mɔ. Ɛmɔ nyan yɩ́ yue a, ɛmɔ man ɔ kaci sɩ̂n'n m'ɔ nnun man lé nɩn anun sʋanlan fâ nnyuan tala ɛmɔ. ");
INSERT INTO any_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Anyɩnsinlinwafʋɛ mɔ bɛ kekele menian atɩn, munnzue hán ɛmɔ! Ɛmɔ nwan: ‘Sɛ sʋanlan kʋn kan asɔnɩn sua nɩn ati a, anɩn ɔ'a nyɔ man like fɩ́ɩ́. Nan sɛ ɔ kan esika kɔkɔlɛ'n m'ɔ wɔ nun nɩn ati a, bɛlɛ mɔ anɩn ɔ'a han ndâ ɔ.’ ");
INSERT INTO any_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Ngʋasɩafʋɛ anyɩnsinlinwafʋɛ! Esika kɔkɔlɛ'n nʋn Nyanmɩan sua'n m'ɔ man esika kɔkɔlɛ'n yɔ nwannzan-nwannzan'n, benin y'ɔ tɩ cɩnnjɩn kpa ɔ? ");
INSERT INTO any_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Ɛsɛ ɛmɔ nwan: ‘Sɛ sʋanlan kʋn kan *tɛɛyɩɛ mʋcɩa nɩn ati a, anɩn ɔ'a nyɔ man like fɩ́ɩ́. Nan sɛ ɔ kan afɔlɩɛ'n m'ɔ wɔ tɛɛyɩɛ mʋcɩa nɩn asʋ nɩn an, bɛlɛ mɔ anɩn ɔ'a han ndâ ɔ.’ ");
INSERT INTO any_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Anyɩnsinlinwafʋɛ! Tɛɛyɩɛ mʋcɩa'n nʋn sʋ ninnge'n mɔ tɛɛyɩɛ mʋcɩa'n man ɔ yɔ nwannzan-nwannzan'n, benin y'ɔ tɩ cɩnnjɩn kpa ɔ? ");
INSERT INTO any_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Sʋanlan m'ɔ kɔ han tɛɛyɩɛ mʋcɩa'n, anɩn ɔ'a han yɩ́ nʋn sʋ ninnge'n kʋalaatin. ");
INSERT INTO any_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Sʋanlan m'ɔ kɔ han Nyanmɩan sua'n, anɩn ɔ'a han yɩ́ nʋn sʋanlan'n m'ɔ wɔ nun nɩn ati. ");
INSERT INTO any_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Sʋanlan m'ɔ kɔ han Nyanmɩan belemgbin bia'n m'ɔ wɔ nyanmɩansʋ'n, anɩn ɔ'a han Nyanmɩan m'ɔ tɩ sʋ nɩn ati ɔ'a bʋka sʋ. ");
INSERT INTO any_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Ɛmɔ mala nɩn asʋ mgbain'n-mɔ nʋn ɛmɔ Falisifʋɛ'n-mɔ, apoo mma, munnzue hán ɛmɔ! Mmaka mma kɛ mantɩ, anɛtɩ nʋn kunmɩn'n, ɛmɔ bu nun bulu, bɛ tu kʋn bɛ man Nyanmɩan. Nan kʋsʋ mân sɛsɛ ebue'n, anwunnvoe enwuan'n nʋn ananhɔlɛ elie'n m'ɔ tɩ mala nɩn anwʋn like cɩnnjɩn'n, ɛmɔ bubu bɛ́ nyɩn bɛ gua sʋ. Like m'ɔ sɛ kɛ ɛmɔ yɔ́ nɩn anɩn. Ɛsɛ ɔ nni man kɛ ɛmɔ bubu bɛ́ nyɩn bɛ gua yɩ́ bʋ nga nɩn asʋ. ");
INSERT INTO any_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Anyɩnsinlinwafʋɛ mɔ bɛ kekele menian atɩn! Ɛmɔ sɩan nzue nɩn asʋ bɛ yɩ nun kakʋba kaan'n mɔ la nun'n, nan kʋsʋ ɛmɔ mɩn naan kpili'n mɔ bɛ fɛlɛ yɩ́ sʋamo'n! Ɛmɔ mian bɛ́ nyɩn bɛ di bɛ́ mala nganngan'n-mɔ kʋalaatin asʋ, nan kʋsʋ ɛmɔ nni Nyanmɩan dɩɛ'n-mɔ asʋ. ");
INSERT INTO any_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Ɛmɔ mala nɩn asʋ mgbain'n-mɔ nʋn ɛmɔ Falisifʋɛ'n-mɔ, apoo mma, munnzue hán ɛmɔ! Ɛmɔ nwunnzin kangɔ'n nʋn talie nɩn anzin'n, nan kʋsʋ yɩ́ kunnun tɩ awue nʋn ati anun ɛtɛ ninnge ngʋnmɩn. ");
INSERT INTO any_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Falisifʋɛ anyɩnsinlinwafʋɛ, di mʋa nwunnzin kangɔ'n nʋn talie nɩn akunnun nán a nwunnzin yɩ́ nzin'n kʋsʋ. ");
INSERT INTO any_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Ɛmɔ mala nɩn asʋ mgbain'n-mɔ nʋn ɛmɔ Falisifʋɛ'n-mɔ, apoo mma, munnzue hán ɛmɔ! Ɛmɔ soman tomo mɔ b'a han yɩ́ ayile fufue kanlanman ɔ. Nan kʋsʋ yɩ́ kʋ nɩn anun tɩ mmowe ngʋnmɩn nʋn ninnge kpɔlɔlɩwa ngacile kʋalaatin. ");
INSERT INTO any_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Kɛ ɛmɔ kʋsʋ tɩ yɩ́ nɩn anɩn. Menian'n-mɔ nwun ɛmɔ a, bɛ bu ɛmɔ meninkpa. Nan kʋsʋ apoo mma y'ɔ le ɛmɔ, ajʋnlɩn ɛtɛ ɛtɛ ngʋnmɩn wɔ ɛmɔ ati anun. ");
INSERT INTO any_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Ɛmɔ *mala nɩn asʋ mgbain'n-mɔ, nʋn ɛmɔ *Falisifʋɛ'n-mɔ, apoo mma, munnzue hán ɛmɔ! Nyanmɩan mgbɔmanfʋɛ'n-mɔ mɔ bɛ kɔ wu'n, ɛmɔ tʋ bɛ́ tomo kanlanman kpa. ");
INSERT INTO any_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Ɛmɔ nwan: ‘Sɛ ɔ tɩ kɛ yɛ́ nan-mɔ bɛlɛ sʋ anɩn yɛ wɔ ɛbɛlɛ a, ahan yɛ́ nʋn bɛ́, yɛ́ bʋ a nyɔ man kʋ́n y'a ngun man Nyanmɩan mgbɔmanfʋɛ'n-mɔ.’ ");
INSERT INTO any_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Ɛmɔ muonun di ɛmɔ anwʋn adanzɩɛ kɛ bɛ́ mɔ bɛ hunlin Nyanmɩan mgbɔmanfʋɛ'n-mɔ, bɛ́ bʋsʋ menian y'ɔ le ɛmɔ. ");
INSERT INTO any_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Sɛ ɔ tɩ sɔ a, anɩn like mɔ ɛmɔ anan-mɔ bɔlɩ yɩ́ bʋ'n, ɛmɔ gúa yɩ́ bʋ! ");
INSERT INTO any_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","“Ati ɛtɛ mma kɛ owo! Ɔ yɔ sɛ mɔ ɛmɔ jʋnlɩn kɛ ɛmɔ ati ngɔ ha man sɩ̂n'n m'ɔ le man ayuelɩɛ nɩn anun ɔ? ");
INSERT INTO any_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Ɛhɩka ati, ɛmɔ tíe. Mɩn 'ba sʋan Nyanmɩan mgbɔmanfʋɛ'n-mɔ, bɛngɛlɛfʋɛ'n-mɔ, nʋn mala nɩn asʋ mgbain-mɔ ɛmɔ anwʋn ɛlɔ. Ɛmɔ 'ba hun mmie-mɔ, bɛ bʋbɔ mmie-mɔ kʋlʋwa sʋ, bɛ fin mmie-mɔ mgbele Zufʋ'n-mɔ asɔnɩn sua'n-mɔ anun, bɛ kele bɛ́ ahʋlʋwa kulo'n-mɔ asʋ. ");
INSERT INTO any_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Ɔ bɔ yɩ́ bʋ sɛsɛfʋɛ Abɛlɩ ehuan'n mɔ bɛ hunlin yɩ́ nɩn asʋ dede ɔ kɔ ju Balasi awa Zakali mɔ bɛ lili yɩ́ awue Nyanmɩan sua'n nʋn tɛɛyɩɛ mʋcɩa nɩn afian'n, bɛ́ mɔ b'a nyɔ man ɛtɛ fɩ́ɩ́ mɔ bɛ hunlin bɛ́'n, bɛ́ awue elie nɩn anwʋn jɔwɔlɛ'n kʋalaa kpolo ɛmɔ ati. ");
INSERT INTO any_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Mɩɩn kan yɩ́ ananhɔlɛ mɩn kele ɛmɔ kɛ menian sɔ'n-mɔ kʋalaatin mɔ bɛ lili bɛ́ awue bɛ hunlin bɛ́'n, bɛ́ ewue nɩn anwʋn jɔwɔlɛ'n 'kpolo ajulisʋ menian ɛhɩ-mɔ ati.” ");
INSERT INTO any_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Ɛhɩ, Zozi nwan: “Zoluzalɛmʋn, Zoluzalɛmʋn, wɔ́ mɔ ɛ kun Nyanmɩan mgbɔmanfʋɛ'n-mɔ ɛ tʋtʋ ɛbʋɛ ɛ kun bɛ́ mɔ Nyanmɩan kɔ sʋan bɛ́ wɔ́ nwʋn'n, n gulolɩ yɩ́ sʋnman kɛ mɩn kokuan wɔ́ mma'n-mɔ anʋan mɩ́n nwʋn kɛ akɔ ɛta kokuan yɩ́ mma'n-mɔ anʋan yɩ́ ndɛba'n-mɔ abʋ'n, nan kʋsʋ ɛmɔ a ndie man! ");
INSERT INTO any_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Ɛmɔ nɩ́an, ɛmɔ awulo'n lɛ ba ha to kpa bɔkɔɔ. ");
INSERT INTO any_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Afɩ mɩɩn kan mɩn kele ɛmɔ kɛ ɛmɔ ngɔ nwun man mɩ́n nwʋn kʋ́n lé dede ɔ 'ju cɩan mɔ ɛmɔ 'se kɛ: ‘Nyila hán sʋanlan'n m'ɔ lɛ ba wɔ yɛ́ Mɩn dunman nun'n.’” ");
INSERT INTO any_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Zozi fi Nyanmɩan awulo nɩn anun ɔ kɔ fite. M'ɔ 'kɔ'n, yɩ́ menian'n-mɔ kɔ kpunnge yɩ́ kɛ ɔ tʋ́ yɩ́ nyɩn ɔ nɩ́an Nyanmɩan awulo nɩn anun sua'n-mɔ. ");
INSERT INTO any_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Ɛhɩ, Zozi nwan: “Ɛhɩ kʋalaa mɔ ɛmɔ nwun yɩ́ ɛwa'n, mɩɩn kan yɩ́ ananhɔlɛ mɩn kele ɛmɔ kɛ bɛ 'ba bubu yɩ́ bɛ gua. Ɛbʋɛ baa kʋn ngɔ tanlan man yɩ́ manngʋn asʋ.” ");
INSERT INTO any_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Zozi kɔ hɔ kɔ tanlan asɩ *Olivʋ bʋka nɩn asʋ. Yɩ́ menian'n-mɔ kɔ a yɩ́ nwʋn ɛbɛlɛ, nán b'a bisa yɩ́ kɛ: “Anɩn cɩan benin yɛ̂ nyɔbʋɛ sɔ'n-mɔ 'kan gua asɩ ɔ? Wɔ́ ɛwalɛ cɩan nɩn anwʋn nzɔlɛ'n y'ɔ le benin? Mân'n kʋsʋ ayuelɩɛ cɩan'n y'ɔ le benin? Kan kele yɛ́.” ");
INSERT INTO any_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Zozi nwan: “Ɛmɔ nɩ́an bɛ́ nwʋn kpa nán sʋanlan fɩ́ɩ́ a nnaka man ɛmɔ. ");
INSERT INTO any_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Ɔ sanlɩn kɛ menian dɔʋn kpa, bɛ 'ba nanndɩ mɩ́n dunman nɩn asʋ nán bɛ́ nun kʋn biala 'ba se kɛ: ‘*Kilisi'n, Belemgbin Ngʋandefʋɛ'n, y'ɔ le mɩ́n.’ Bɛ 'laka menian dɔʋn. ");
INSERT INTO any_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Ɛmɔ 'ba tɩ kɛ menian'n-mɔ lɛ kan ɛlɔɛ ɛjɔlɛ ɛmɔ anwʋn ɛbɛlɛ ala, ɛsɛ bɛ 'ba han bɛ kele ɛmɔ kɛ mmie-mɔ lɛ kʋn mʋa ɛlɔ. Nán bɛ man bɛ́ kunnun tɩtɩ bɛ́, ɔ sanlɩn kɛ ɔ sɛ kɛ ɔ yɔ́ sɔ, kʋsʋ anɩn nán mân nɩn ayuelɩɛ nɩn anɩn. ");
INSERT INTO any_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Mân kʋn 'ba jasʋ ɔ nʋn mân kʋn bɛ kʋn ɛlɔɛ. Belemgbin mân kʋn 'ba jasʋ ɔ nʋn belemgbin mân kʋn bɛ kʋn ɛlɔɛ. Ɛhɔɛ 'ba kpɩn eyuadɩ'n lɩka mmie-mɔ, ɛsɛ asɩɛ'n 'ba kpusu wɔ lɩka ngacile dɔʋn. ");
INSERT INTO any_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Ɛhɩka kʋalaa, ɔ tɩ kɛ balasua m'ɔ kɔ fʋ awɔlɛ sʋ yalɛ'n m'ɔ di mʋa ɔ nwun yɩ́'n. ");
INSERT INTO any_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Ɛhɩ, menian'n-mɔ 'ba yɩ ɛmɔ man maan bɛ kele ɛmɔ ahʋlʋwa ɛsɛ bɛ 'kun ɛmɔ. Mɩ́n dunman nun, menian'n-mɔ kʋalaa 'ba kpɔ ɛmɔ. ");
INSERT INTO any_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Nan mɛlɛ sɔ'n, menian dɔʋn kpa 'ba yaci bɛ́ dedi'n mɔ bɛ le yɩ́'n bɛ tʋ. Bɛ 'laka bɛ́ nwʋn ɛsɛ bɛ 'kpɔ bɛ́ nwʋn. ");
INSERT INTO any_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Ato mgbɔmanfʋɛ dɔʋn 'ba fite fite bɛ laka menian dɔʋn. ");
INSERT INTO any_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Ɛtɛ ɛyɔlɛ'n 'ba fa mân'n lɩka kʋalaatin dede ɔ man menian dɔʋn kpa mɔ bɛ le ehulo'n, bɛ 'yaci bɛ́ ehulo'n bɛ tʋ. ");
INSERT INTO any_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Nan sʋanlan m'ɔ kɔ tila yɩ́ ahʋnlɩn dede ɔ kɔ ju yɩ́ ayuelɩɛ'n, sʋanlan sɔ'n 'nyan yɩ́ ti. ");
INSERT INTO any_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Anwunno Belemgbin Mân nɩn anwʋn Ɛjɔlɛkpa ɛhɩ, bɛ 'bɔ yɩ́ asɩɛ'n lɩka kʋalaatin bɛ man mân nɩn anun menian'n-mɔ kʋalaa di yɩ́ nwʋn adanzɩɛ, kʋalaaka nán mân nɩn ayuelɩɛ cɩan nɩn a ju. ");
INSERT INTO any_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Ɛmɔ 'ba nwun like ɛtɛ kpili'n m'ɔ bɔ alʋa mɔ Nyanmɩan kpɔmanfʋɛ Danɩɛ hanlɩn yɩ́ nwʋn ɛjɔlɛ'n kɛ bɛ 'ba sie yɩ́ lɩka nwannzan-nwannzan nɩn anun. (Sʋanlan m'ɔ lɛ kɩnnga Danɩɛ ɛjɔlɛ sɔ'n, ɔ kɩ́nnga nán ɔ tɩ yɩ́ bʋ kpa.) ");
INSERT INTO any_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Yɩ́ ti, bɛ́ mɔ bɛ wɔ Zude mân nɩn anun'n, bɛ nwánndi bɛ hɔ́ mmʋka'n-mɔ asʋ. ");
INSERT INTO any_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Sʋanlan m'ɔ kɔ fʋ yɩ́ sua nɩn ati sʋ'n, n'ɔ ju kɔ yɩ́ sua nɩn anun, ɔ fa like. ");
INSERT INTO any_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Sʋanlan m'ɔ kɔ hɔ ebolo'n, n'ɔ sa ba fa taladɩɛ. ");
INSERT INTO any_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Mɛlɛ sɔ nɩn anun, mmalasua'n-mɔ mɔ bɛ lɛ nwʋnnzɛ'n, ɔ nʋn bɛ́ mɔ bɛ lɛ nʋan mma'n, bɛ́ yakɔ! ");
INSERT INTO any_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Ɛmɔ sɛ́lɛ Nyanmɩan kpa nán ɛmɔ ɛnwanndie cɩan nɩn a nyia man fɔsɩɛ nun, anaan ɛnwʋnmɩan ele cɩan. ");
INSERT INTO any_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Ɔ sanlɩn kɛ yalɛ'n mɔ ɔ 'ba a tɛmʋn sɔ nɩn anun'n, yɩ́ esulo mɔ ɔ 'ba yɔ'n, kɛ bɛ bɔlɩ mân'n dede m'ɔ ju ɛnɛ'n, yɩ́ nwʋn sʋ yalɛ walɩ man lé, yɛ̂ yɩ́ nwʋn sʋ yalɛ ngɔ a man kʋ́n lé. ");
INSERT INTO any_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Sɛ Nyanmɩan muonun a mgbɛ man tɛmʋn sɔ nɩn asʋ a, sʋanlan fɩ́ɩ́ nnyan man yɩ́ ti. Nan yɩ́ menian'n-mɔ mɔ ɔ'a kpa bɛ́ ɔ'a yɔ yɩ́ dɩɛ'n-mɔ dunman nun, ɔ'a kpɛ cɩan sɔ'n-mɔ asʋ. ");
INSERT INTO any_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Mɛlɛ sɔ nɩn anun, sɛ sʋanlan bie se ɛmɔ kɛ: ‘Ɛmɔ nɩ́an, Kilisi'n wɔ ɛwa!’ anaan ‘Ɔ wɔ ɛlɔ!’ a, nán bɛ de bɛ di. ");
INSERT INTO any_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Ɔ sanlɩn kɛ ato Kilisi-mɔ ɔ nʋn ato mgbɔmanfʋɛ-mɔ 'ba fite fite, bɛ 'ba yɔ asinbɛnwʋn ninnge mgbili mgbili ɔ nʋn nzɔlɛ bɛ laka menian. Sɛ bɔbɔ bɛ kʋala menian'n-mɔ mɔ Nyanmɩan a kpa bɛ́ a yɔ yɩ́ dɩɛ'n-mɔ laka a, bɛ 'laka bɛ́. ");
INSERT INTO any_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Ɛjɔlɛ nɩn ahɩ! M'an kannzʋ ɛmɔ! ");
INSERT INTO any_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Sɛ bɛ kan bɛ kele ɛmɔ kɛ: ‘Ɛmɔ nɩ́an, ɔ wɔ ɛwâ nɩn anun ɛlɔ’ a, nán bɛ kɔ ɛlɔ. Sɛ kʋsʋ bɛ kan bɛ kele ɛmɔ kɛ: ‘Bɛ nɩ́an, ɔ fɩa ɛwa’ a, nán bɛ de bɛ di. ");
INSERT INTO any_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Kɛ nyanmɩan'n kpɛ mɩaɩn sɛnzɛ afitelɩɛ ɔ kɔ tɔ sɛnzɛ atɔlɩɛ'n, Mân Baa'n kʋsʋ ɛwalɛ'n 'ba yɔ sɔ. ");
INSERT INTO any_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Lɩka mɔ fuin'n la'n, ɛbɛlɛ yɛ̂ ɛkpɔtɛ'n-mɔ yia ɔ. ");
INSERT INTO any_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Yalɛ mɛlɛ'n sɩn ala, sɛnzɛ'n 'ba lu tuun. Sala'n ngɔ ta man kʋ́n. Nzalama'n-mɔ fi anwunno bɛ 'ba tutu bɛ gua asɩ. Nyanmɩansʋ ɛlɔ ninnge mgbili'n-mɔ kʋalaa 'ba kpusu. ");
INSERT INTO any_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Ɛbɛlɛ nɩn anun, Mân Baa nɩn ɛwalɛ nzɔlɛ'n 'ba fite nyanmɩan nɩn anyunnun. Asɩɛ nɩn asʋ nvilie'n-mɔ kʋalaa 'ba sun bɛ yɩ awɔ́lɛ, bɛ 'ba nwun Mân Baa'n kɛ ɔ wɔ bɔlɛ́ nɩn anun ɔ fi anwunno ɔ lɛ ba wɔ tunmin kpili kpa ɔ nʋn anunminnyanmʋn nun. ");
INSERT INTO any_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Mɔ kɔnɔtɩ kpili'n kɔ te'n, Mân Baa'n 'ba sʋan yɩ́ mmɔfʋɛ'n-mɔ mɔ bɛ wɔ anwunno ɛlɔ nɩn asɩɛ'n lɩka kʋalaatin. Ɔ 'man bɛ kokuan menian'n-mɔ mɔ ɔ'a kpa bɛ́ ɔ'a yɔ yɩ́ dɩɛ'n-mɔ anʋan. ");
INSERT INTO any_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Ɛmɔ nɩ́an *figi baka'n kɛ ɔ kpɩn tɩ yɩ́'n nán ɛmɔ tɩ́ yɩ́ bʋ. Mɛlɛ mɔ ɛmɔ kɔ nwun kɛ asa mma a fifi yɩ́ nwʋn mɔ yɩ́ nyâ'n lɛ wula'n, anɩn ɛmɔ sɩ kɛ ɔ ka kaan su. ");
INSERT INTO any_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Ɛmɔ kʋsʋ, mɛlɛ mɔ ɛmɔ kɔ nwun ɛhɩ kʋalaa'n, anɩn ɛmɔ sɩ kɛ Mân Baa nɩn ɛwalɛ nɩn a ju a yue ɔ'a mantan ɛmɔ kʋkʋ. ");
INSERT INTO any_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Mɩɩn kan yɩ́ ananhɔlɛ mɩn kele ɛmɔ kɛ ajulisʋ menian ɛhɩ-mɔ ngɔ yue man wu nán ninnge sɔ'n-mɔ tɛmʋn a ju. ");
INSERT INTO any_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Anwunno nʋn asɩ 'ba kpɛ nun sɩn, nan mɩ́n Nʋan Ɛjɔlɛ'n dɩɛ, ɔ mgbɛ man nun lé. ");
INSERT INTO any_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“M'ɔ tʋ de cɩan'n, anaan dɔɛ'n, sʋanlan fɩ́ɩ́ nzɩ man. Anwunno ɛlɔ mmɔfʋɛ'n-mɔ o, Mân Baa nɩn o, bɛ́ fɩ́ɩ́ bɛ nzɩ man. Nan Sɩɛ nɩn angʋnmɩn y'ɔ sɩ ɔ. ");
INSERT INTO any_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Nowe bɛlɛ sʋ, ɛjɔlɛ'n m'ɔ walɩ'n, yɩ́ kʋnmgba nɩn ala yɛ̂ ɔ 'ba a Mân Baa nɩn ɛwalɛ nun ɔ. ");
INSERT INTO any_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Nowe bɛlɛ sʋ, asannan nán esue kpili'n m'ɔ nʋanlɩn mân nɩn a tɔ'n, anɩn menian'n-mɔ lɛ didi, bɛ lɛ nʋn nzan, bɛ lɛ ja bɛ́ nwʋn, bɛ lɛ fa bɛ́ mma mmalasua'n-mɔ atɔnvɔlɛ, dede ɔ juli mɛlɛ mɔ Nowe fʋlɩ meli nɩn anun'n. ");
INSERT INTO any_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Bɛ gua ɛbɛlɛ, ɛjɔlɛ fɩ́ɩ́ a nvalɩ bɛ́ nwʋn, dede esue kpili'n kɔ tɔ, bɛ́ kʋalaa bɛ kɔ nʋan. Mân Baa'n kʋsʋ ɛwalɛ nun, kɛ ɛjɔlɛ'n 'ba yɔ yɩ́ nɩn ala anɩn. ");
INSERT INTO any_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Mɛlɛ sɔ nɩn anun, mmelenzua nnyuan mɔ bɛ kɔ hɔ ebolo bɛ lɛ di junman lɩka kʋn'n, bɛ 'fa kʋn bɛ yaci kʋn. ");
INSERT INTO any_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Mmalasua nnyuan mɔ bɛ lɛ futu *bele bɛ yɩ yɩ́ fali'n, bɛ 'fa kʋn bɛ yaci kʋn. ");
INSERT INTO any_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“Yɩ́ sɔ ati, ɛmɔ tánlan bɛ sísa, ɔ sanlɩn kɛ, ɛmɔ nzɩ man cɩan'n mɔ bɛ́ Mɩn 'ba ɔ. ");
INSERT INTO any_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Ɛmɔ nwún yɩ́ kɛ awulo kpain'n, sɛ ɔ sɩ dɔɛ'n mɔ alɩ́ɛ san an, awofʋɛ'n ba ɔ wua yɩ́ a, ahan ɔ 'tanlan asɩ ɔ sisa, ɔ nyaci man yɩ́ maan ɔ nwʋlʋ man yɩ́ sua nɩn anun. ");
INSERT INTO any_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Ɛhɩ ati, ɛmɔ kʋsʋ, ɛmɔ bɔ́bʋa bɛ́ nwʋn, ɔ sanlɩn kɛ, Mân Baa'n 'ba a dɔɛ mɔ ɛmɔ nzusu man nɩn asʋ. ");
INSERT INTO any_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Akʋa ngɛlɛfʋɛ ananhɔlɛfʋɛ'n, y'ɔ le nwan? Y'ɔ le akʋa'n mɔ yɩ́ mɩn a fa junman a wula yɩ́ sa nun kɛ ɔ nɩ́an yɩ́ ngʋa ɛhɩnlɩnka-mɔ asʋ, ɔ mán bɛ́ alɩɛ mɛlɛ mɔ dɔɛ'n kɔ ju'n. ");
INSERT INTO any_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Nyila hán akʋa sɔ'n mɔ yɩ́ mɩn 'sa ba a, ɔ 'ba tʋ yɩ́ junman nɩn asʋ'n! ");
INSERT INTO any_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Mɩɩn kan yɩ́ ananhɔlɛ mɩn kele ɛmɔ kɛ, akʋa sɔ'n, yɩ́ mɩn'n 'fa yɩ́ ninnge'n kʋalaatin wula yɩ́ sa nun. ");
INSERT INTO any_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Nan sɛ akʋa sɔ'n tɩ sʋanlan ɛtɛ a, ɔ 'kan yɩ́ ti anun kɛ: ‘Mɩ́n mɩn nnyan walɩ man.’ ");
INSERT INTO any_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Ɔ 'tɩ tɔ yɩ́ manngʋn'n-mɔ mɔ ɔ nʋn bɛ di junman nɩn anwʋn ɔ bili bɛ́, ɔ nʋn kɔnʋnmɩnnzan'n-mɔ bɛ 'didi ɛsɛ bɛ 'nʋn nzan. ");
INSERT INTO any_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Cɩan m'ɔ njʋnlɩn man yɩ́ nwʋn ɔ nʋn dɔɛ m'ɔ nzusu man'n, yɛ̂ yɩ́ mɩn'n 'ba a ɔ. ");
INSERT INTO any_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Ɔ 'kele akʋa sɔ'n yalɛ kpa, ɔ 'yɔ yɩ kɛ bɛ yɔ apoo mma-mɔ'n. Ɛbɛlɛ nɩn anun, ɔ 'ba sun ɛsɛ ɔ 'kʋan yɩ́ je'n. ");
INSERT INTO any_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“Ɛhɩ, Anwunno Belemgbin Mân nɩn anwʋn ɛjɔlɛ'n, ɔ soman ndalie bulu mɔ b'a fa bɛ́ nganlannɩɛ'n-mɔ b'a tetila, bɛ lɛ kɔ a kpa atɔnvɔlɛ bian kʋn atɩn. ");
INSERT INTO any_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Bɛ́ nunhan nnun tɩ ngʋasɩafʋɛ yɛ̂ nnun kʋsʋ tɩ bɛngɛlɛfʋɛ. ");
INSERT INTO any_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Ngʋasɩafʋɛ'n-mɔ kɔ fa bɛ́ nganlannɩɛ'n-mɔ, bɛ ngɔ fa man ngo bɛ ngɔ sa man bɛ́ nwʋn. ");
INSERT INTO any_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Nan bɛngɛlɛfʋɛ nnun nɩn an, bɛ kɔ fa bɛ́ nganlannɩɛ'n-mɔ ɔ nʋn ngo ɛsɛ̂ nun bɛ kɔ sa bɛ́ nwʋn. ");
INSERT INTO any_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Atɔnvɔlɛ bian'n kɔ hyɛ kpa, ɔ mma man. Nafɛlɛ kɔ hun ndalie bulu'n bɛ kɔ lafɩ lafɩ. ");
INSERT INTO any_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Mɔ alɩ́ɛ'n buli nun'n, bɛ 'tie a, anɩn sʋanlan bie lɛ tɩan, yɩ́ nwan: ‘Ɛ 'nwun atɔnvɔlɛ bian'n! Bɛ fíte bɛ hɔ́ kpá yɩ́ atɩn!’ ");
INSERT INTO any_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","“Ɛbɛlɛ ala, ndalie bulu'n kɔ jasʋ jasʋ, bɛ yɔ bɛ́ nganlannɩɛ'n-mɔ kpa. ");
INSERT INTO any_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Ngʋasɩafʋɛ'n-mɔ kɔ se bɛngɛlɛfʋɛ'n-mɔ kɛ: ‘Ɛmɔ mán yɛ́ bɛ́ ngo'n kaan, nán yɛ́ nganlannɩɛ'n-mɔ lɛ nun.’ ");
INSERT INTO any_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","“Bɛngɛlɛfʋɛ'n-mɔ kɔ bua bɛ́ kɛ: ‘Cɛcɛ, ɛmɔ ngɔ nyan man yɩ́, ɔ sanlɩn kɛ, ɔ nza man yɛ́ nʋn ɛmɔ. Ɛmɔ hɔ́ bɛ́ mɔ bɛ tɔnɩn yɩ́'n-mɔ ɛlɔ, bɛ hɔ́ tó bɛ́ dɩɛ.’ ");
INSERT INTO any_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","“Kɛ bɛ hɔlɩ ngo atoe nɩn ala, atɔnvɔlɛ bian'n kɔ a. Bɛngɛlɛfʋɛ nnun'n, mɔ b'a sesie bɛ́ nwʋn a yue'n, bɛ nʋn yɩ́ kɔ wʋlʋ lɩka mɔ bɛ lɛ fa atɔnvɔlɛ'n, nán b'a tʋ anʋan nɩn anun. ");
INSERT INTO any_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Ɔ hyɛlɩ kaan, mmalasua ɛhɩnlɩn-mɔ kɔ a, bɛ lɛ tɩan, bɛ́ nwan: ‘Yɛmɩnlɩn, yɛmɩnlɩn, tike anʋan'n!’ ");
INSERT INTO any_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","“Atɔnvɔlɛ bian'n nwan: ‘Mɩɩn kan yɩ́ ananhɔlɛ mɩn kele ɛmɔ kɛ mɩn nzɩ man ɛmɔ.’” ");
INSERT INTO any_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Ɛhɩ, Zozi kɔ han kɔ tʋ sʋ kɛ: “Yɩ́ sɔ ati, ɛmɔ sísa, ɔ sanlɩn kɛ ɛmɔ nzɩ man cɩan'n, anaan dɔɛ'n.” ");
INSERT INTO any_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Anwunno Belemgbin Mân'n soman bian kʋn m'ɔ lɛ ba tu atɩn. Ɔ kɔ fɛfɛlɛ yɩ́ ngʋa'n-mɔ ɔ kɔ fa yɩ́ esika'n kɔ wowula bɛ́ sa nun. ");
INSERT INTO any_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Ɔ kɔ man kʋn esika kɔkɔlɛ mma ɛya nnun, ɔ'a man kʋn kʋsʋ ɛya nnyuan, ɔ'a man kʋn biekun kʋsʋ ɛya kʋn. Bɛ́ nun kʋn biala anwʋnsɛlɛ'n m'ɔ fa di yɩ́ junman'n, yɩ́ nwʋn esika yɛ̂ ɔ falɩ manlɩn yɩ́, yɛ̂ ɔ hɔlɩ ɔ. ");
INSERT INTO any_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Akʋa'n mɔ yɩ́ mɩn'n manlɩn yɩ́ esika kɔkɔlɛ mma ɛya nnun'n, ɔ kɔ fa kɔ si kongo, ɔ kɔ nyan sʋ nvasʋɛ ɛya nnun. ");
INSERT INTO any_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Nunhan'n mɔ bɛ manlɩn yɩ́ ɛya nnyuan'n, yɩ́ kʋsʋ ɔ kɔ fa kɔ si kongo, ɔ kɔ nyan sʋ nvasʋɛ ɛya nnyuan. ");
INSERT INTO any_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Nunhan'n mɔ bɛ manlɩn yɩ́ ɛya kʋn'n, ɔ kɔ hɔ kɔ fun kunman ɔ kɔ fa yɩ́ mɩn esika'n kɔ fɩa. ");
INSERT INTO any_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Bɛ wɔ ɛbɛlɛ dede ɔ hyɛlɩ kpa, bɛ́ mɩn'n kɔ a, ɔ kɔ fɛfɛlɛ bɛ́ kɛ esika'n m'ɔ falɩ manlɩn bɛ́'n, bɛ bála a bu yɩ́ mgbʋnndan. ");
INSERT INTO any_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Akʋa'n mɔ bɛ manlɩn yɩ́ esika kɔkɔlɛ mma ɛya nnun'n kɔ fa ɛya nnun biekun kɔ a, yɩ́ nwan: ‘Mɩ́n mɩn, ɛ manlɩn mɩ́n esika kɔkɔlɛ mma ɛya nnun. Nɩan, m'an nyan sʋ ɛya nnun biekun, ɛ 'nwun yɩ́.’ ");
INSERT INTO any_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","“Yɩ́ mɩn'n nwan: ‘Akʋa kpa, mo! Ɛ tɩ ananhɔlɛfʋɛ kpa. Like kaan ɛhɩ mɔ m'an fa m'an man wɔ́'n, a yɔ yɩ́ kpa. Yɩ́ ti, mɩn 'fa ninnge dɔʋn mɩn wula wɔ́ sa nun. Bala tanlan mɩ́n nwʋn ɛwa maan yɛ lí fɛ.’ ");
INSERT INTO any_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Akʋa'n mɔ bɛ manlɩn yɩ́ esika kɔkɔlɛ mma ɛya nnyuan'n kʋsʋ kɔ a, yɩ́ nwan: ‘Mɩ́n mɩn, esika kɔkɔlɛ mma ɛya nnyuan'n mɔ ɛ falɩ manlɩn mɩ́n'n, m'an nyan sʋ ɛya nnyuan biekun, ɛ 'nwun yɩ́.’ ");
INSERT INTO any_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","“Yɩ́ mɩn'n nwan: ‘Akʋa kpa, mo! Ɛ tɩ ananhɔlɛfʋɛ kpa. Like kaan ɛhɩ mɔ m'an fa m'an man wɔ́'n, a yɔ yɩ́ kpa. Yɩ́ ti, mɩn 'fa ninnge dɔʋn mɩn wula wɔ́ sa nun. Bala tanlan mɩ́n nwʋn ɛwa maan yɛ lí fɛ.’ ");
INSERT INTO any_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Yɩ́ nzin, akʋa'n mɔ bɛ manlɩn yɩ́ esika kɔkɔlɛ mma ɛya kʋn'n kʋsʋ kɔ a yɩ́ dɩɛ. Yɩ́ nwan: ‘Mɩ́n mɩn, mɩn sɩ kɛ ɛ tɩ sʋanlan mɔ wɔ́ ɛjɔlɛ yɔ sɩ kpa. Ɛ man ngʋa'n-mɔ di junman mgban nán wɔ́ lɩlɩ a nyan sʋ nvasʋɛ'n. ");
INSERT INTO any_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Esulo hanlɩn mɩ́n, n gɔ n vunlin wɔ́ esika'n n wulalɩ asɩɛ bʋ. Ɛ 'nwun wɔ́ esika'n, de wɔ́ like.’ ");
INSERT INTO any_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“Yɩ́ mɩn'n nwan: ‘Akʋa ati anun ɛtɛ ɛfʋanfʋɛ, ɛ sɩ kɛ mɩn man ɛmɔ di junman mgban mɩn nyan sʋ nvasʋɛ'n. ");
INSERT INTO any_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Ahan ɛ falɩ mɩn esika'n manlɩn bankɩ mma'n-mɔ sielɩ. Yɩ́ dɩɛ n vi ɛlɔ mɩn ba a, anɩn mɩn yɩ mɩ́n esika'n nʋn yɩ́ ngua nun'n. ");
INSERT INTO any_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Yɩ́ ti, ɛmɔ tʋ́a yɩ́ bɛ lé esika kɔkɔlɛ mma ɛya kʋn'n m'ɔ wɔ yɩ́ sa nun'n, bɛ fá bɛ mán akʋa'n m'ɔ le akpɩɩ kʋn'n. ");
INSERT INTO any_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Ɔ sanlɩn kɛ sʋanlan m'ɔ le bie'n, bɛ 'man yɩ́ dɔʋn biekun. Nan sʋanlan kʋsʋ m'ɔ le man fɩ́ɩ́'n, bɛ 'tʋa yɩ́ bɛ de kaan'n m'ɔ le'n. ");
INSERT INTO any_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Nán akʋa mgban ɛhɩ, bɛ jú yɩ́ bɛ tʋ́ awosin nɩn anun ɛlɔ. Ɛbɛlɛ yɛ̂ ɔ 'sun ɛsɛ ɔ 'kʋan yɩ́ je nɩn ɔ.’ ");
INSERT INTO any_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Mɛlɛ mɔ *Mân Baa'n ba a anunminnyanmʋn nɩn anun'n ɔ nʋn nyanmɩansʋ mmɔfʋɛ'n-mɔ kʋalaatin'n, ɔ 'tanlan yɩ́ anunminnyanmʋn belemgbin bia nɩn asʋ. ");
INSERT INTO any_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Asɩɛ nɩn asʋ menian'n-mɔ kʋalaa 'ba yia yɩ́ nyunnun ɛbɛlɛ. Ɔ 'kpa bɛ́ nun kɛ bʋa ɛnɩanfʋɛ'n kpa yɩ́ mmʋa'n ɔ sie bɛ́ ngʋnmɩn ɛsɛ ɔ sie yɩ́ esile'n-mɔ kʋsʋ angʋnmɩn'n. ");
INSERT INTO any_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Ɔ 'fa mmʋa'n-mɔ sie yɩ́ sa fama sʋ, ɔ 'fa esile'n-mɔ kʋsʋ sie yɩ́ sa bɛ̂ sʋ. ");
INSERT INTO any_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","“Ɛhɩ anzin, belemgbin'n 'ba se bɛ́ mɔ bɛ wɔ yɩ́ sa fama sʋ'n kɛ: ‘Ɛmɔ mɔ mɩ́n Sɩ a yeyila bɛ́'n, ɛmɔ bála a fa Anwunno Belemgbin Mân'n. Nyanmɩan a fa a sie ɛmɔ ajâ. Ɔ sesielɩ manlɩn ɛmɔ sunmin kɛ ɔ bɔlɩ mân'n. ");
INSERT INTO any_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Ɔ sanlɩn kɛ mɛlɛ mɔ anɩn ɛhɔɛ lɛ kun mɩ́n'n, ɛmɔ manlɩn mɩ́n like n nili. Mɔ nzuhoe 'kun mɩ́n'n, ɛmɔ manlɩn mɩ́n nzue n nʋnlɩn. Mɔ m malɩ ɛyɛfʋɛ ɛmɔ kulo nɩn asʋ'n, ɛmɔ sikelɩ mɩ́n. ");
INSERT INTO any_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Mɔ anɩn mɩ́n nwʋn gua sʋ'n, ɛmɔ manlɩn mɩ́n taladɩɛ n wulalɩ, mɔ anɩn mɩn ndɩ man akpɔlɛ'n, ɛmɔ walɩ bɛ nɩanlɩn mɩ́n bʋsʋ. Mɔ anɩn n na fiadɩ'n, ɛmɔ walɩ nɩanlɩn mɩ́n bʋ sʋ.’ ");
INSERT INTO any_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Ɛhɩ, sɛsɛfʋɛ'n-mɔ 'ba bisa yɩ́ kɛ: ‘Yɛ Mɩn, cɩan benin yɛ̂ yɛ nwunlin wɔ́ kɛ ɛhɔɛ lɛ kun wɔ́ mɔ yɛ manlɩn wɔ́ like lili ɔ? Anaan cɩan benin yɛ̂ yɛ nwunlin wɔ́ kɛ nzuhoe lɛ kun wɔ́ mɔ yɛ manlɩn wɔ́ nzue nʋnlɩn ɔ? ");
INSERT INTO any_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Cɩan benin yɛ̂ ɛ walɩ ɛyɛfʋɛ yɛ́ kulo nɩn asʋ mɔ yɛ sikelɩ wɔ́ ɔ, anaan cɩan benin yɛ̂ yɛ nwunlin kɛ wɔ́ nwʋn gua sʋ mɔ yɛ manlɩn wɔ́ taladɩɛ wulalɩ ɔ? ");
INSERT INTO any_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Cɩan benin yɛ̂ yɛ nwunlin kɛ ɛ ndɩ man akpɔlɛ anaan ɛ la fiadɩ mɔ yɛ nɩanlɩn wɔ́ bʋsʋ ɔ?’ ");
INSERT INTO any_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","“Belemgbin'n 'ba se bɛ́ kɛ: ‘Mɩɩn kan yɩ́ ananhɔlɛ mɩn kele ɛmɔ kɛ yɩ́ kʋalaa mɔ ɛmɔ yɔlɩ manlɩn mɩ́n nianman-mɔ nunhan kutua'n bie'n, mɩ́n yɛ̂ ɛmɔ yɔlɩ manlɩn mɩ́n ɔ.’ ");
INSERT INTO any_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Nan afɩ belemgbin'n 'ba se bɛ́ mɔ bɛ gua yɩ́ sa bɛ̂ sʋ'n kɛ: ‘Ɛmɔ mɔ b'a fa munnzue'n, ɛmɔ jásʋ mɩ́n nwʋn ɛwa. Ɛmɔ hɔ́ sɩ̂n'n m'ɔ nnun man lé, mɔ b'a sesie b'a man Abɔnsanmʋn nʋn yɩ́ mmɔfʋɛ'n-mɔ nɩn anun. ");
INSERT INTO any_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Ɔ sanlɩn kɛ mɛlɛ mɔ anɩn ɛhɔɛ lɛ kun mɩ́n'n, ɛmɔ a mman man mɩ́n like m'an nni man. Mɔ nzuhoe 'kun mɩ́n'n, ɛmɔ a mman man mɩ́n nzue m'an nnʋn man. ");
INSERT INTO any_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Mɔ m malɩ ɛyɛfʋɛ ɛmɔ kulo nɩn asʋ'n, ɛmɔ a nzike man mɩ́n. Mɔ anɩn mɩ́n nwʋn gua sʋ'n, ɛmɔ a mman man mɩ́n taladɩɛ m'an nwula man. Mɔ n vʋkɛlɩ'n, ɛsɛ mɔ bɛ tʋlɩ mɩ́n fiadɩ'n, ɛmɔ a nnɩan man mɩ́n bʋsʋ.’ ");
INSERT INTO any_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Ɛhɩ, bɛ́ nwan: ‘Yɛ́ Mɩn, cɩan benin yɛ̂ yɛ nwunlin wɔ́ kɛ ɛhɔɛ lɛ kun wɔ́ mɔ y'a mman man wɔ́ like a nni man ɔ? Anaan cɩan benin yɛ̂ yɛ nwunlin kɛ nzuhoe lɛ kun wɔ́ mɔ y'a mman wɔ́ nzue a nnʋn man ɔ? Cɩan benin yɛ̂ ɛ walɩ ɛyɛfʋɛ yɛ́ kulo nɩn asʋ mɔ y'a nzike man wɔ́ ɔ? Anaan cɩan benin yɛ̂ yɛ nwunlin kɛ wɔ́ nwʋn gua sʋ mɔ y'a mman man wɔ́ taladɩɛ a nwula man ɔ? Cɩan benin yɛ̂ ɛ fʋkɛlɩ anaan bɛ tʋlɩ wɔ́ fiadɩ mɔ y'a nnɩan man wɔ́ bʋsʋ ɔ?’ ");
INSERT INTO any_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","“Belemgbin'n 'ba bua bɛ́ kɛ: ‘Mɩɩn kan yɩ́ ananhɔlɛ mɩn kele ɛmɔ kɛ yɩ́ kʋalaa mɔ ɛmɔ a nyɔ a mman man mɩ́n nianman ngutua ɛhɩ-mɔ anun kʋn bie'n, anɩn mɩ́n yɛ̂ ɛmɔ a nyɔ a mman man mɩ́n ɔ.’ ");
INSERT INTO any_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","“Menian sɔ'n-mɔ, bɛ 'kɔ lɩka mɔ yalɛ elie'n le man ayuelɩɛ'n. Nan sɛsɛfʋɛ'n-mɔ dɩɛ, bɛ 'nyan nyanmɩansʋ ngʋan m'ɔ le man ayuelɩɛ'n.” ");
INSERT INTO any_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Ɛhɩ, Zozi hanlɩn ɛjɔlɛ sɔ'n-mɔ dede m'ɔ yuelɩ'n, ɔ selɩ yɩ́ menian'n-mɔ kɛ: ");
INSERT INTO any_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","Ɛmɔ sɩ kɛ ɔ ka cɩan nnyuan nán b'a li *Pakɩ fɛtɩ'n. Mân Baa'n, bɛ 'ba yɩ yɩ́ bɛ man menian'n-mɔ bʋbɔ yɩ́ kʋlʋwa sʋ. ");
INSERT INTO any_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Ɔ 'ba yɔ sɔ'n, Nyanmɩan *tɛɛyɩfʋɛ mgbain'n-mɔ, ɔ nʋn Zufʋ mgbain'n-mɔ kɔ yia Nyanmɩan tɛɛyɩfʋɛ kpain kpa'n mɔ bɛ fɛlɛ yɩ́ Kayifʋ nɩn awulo ɛlɔ. ");
INSERT INTO any_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Anɩn bɛ lɛ jʋnlɩn jʋnlɩn atɩn mɔ bɛ 'sɩn sʋ bɛ cɩ Zozi bɛ kun yɩ́ nvɩalɩɛ nun nɩn anwʋn. ");
INSERT INTO any_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Bɛ́ nwan: “Ɔ tɩ man kpa kɛ yɛ cɩ yɩ́ fɛtɩ nɩn anun. Sɛ yɛ cɩ yɩ́ fɛtɩ nɩn anun an, menian'n-mɔ kʋalaa 'ba jasʋ yɛ́ kɔmɩn anun.” ");
INSERT INTO any_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Anɩn Zozi wɔ Betanin, bian kʋn awulo. Bian sɔ'n li Simʋn, ɔ tɩ kokobefʋɛ daba. ");
INSERT INTO any_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Balasua kʋn kɔ a Zozi anwʋn ɛbɛlɛ, ɔ le anantɩlɩ bondoman kʋn yɩ́ sa nun. Anantɩlɩ sɔ'n gua yɔ sɩ kpa. Mɛlɛ mɔ bɛ gua tɔbɩlɩ nɩn anwʋn bɛ 'di like'n, balasua'n kɔ kaci anatɩlɩ'n kɔ gua Zozi ati nɩn asʋ. ");
INSERT INTO any_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Mɔ yɩ́ menian'n-mɔ nwunlin yɩ́ sɔ'n, ɔ yɔlɩ bɛ́ ɛya, bɛ́ nwan: “Anatɩlɩ ɛhɩ ɛsɛcɩɛ dɩɛ abʋ y'ɔ le benin? ");
INSERT INTO any_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Bɛ kʋala kɛ bɛ tɔnɩn yɩ́, bɛ fa yɩ́ esika'n bɛ man ehianfʋɛ'n-mɔ.” ");
INSERT INTO any_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Bɛ hanlɩn sɔ mɔ Zozi tɩlɩ'n, yɩ́ nwan: “Nzukɛ ati yɛ̂ ɛmɔ lɛ jɩjɩ balasua sɔ nɩn ɔ? Like kpa yɛ̂ ɔ'a yɔ ɔ'a man mɩ́n ɔ. ");
INSERT INTO any_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Afɩ ehianfʋɛ'n-mɔ dɩɛ, ɛmɔ nʋn bɛ́ gua ɛwa cɩan daa. Nan mɩ́n dɩɛ, mɩn nʋn ɛmɔ tɩ man ɛwa dahuu. ");
INSERT INTO any_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Anatɩlɩ ɛhɩ mɔ ɔ'a tutu ɔ'a gua mɩ́n nwʋn'n, mɩ́n fuin nɩn esesie y'ɔ lɛ sesie ɔ. ");
INSERT INTO any_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Mɩɩn kan yɩ́ ananhɔlɛ mɩn kele ɛmɔ kɛ eyuadɩ nɩn anun lɩka biala mɔ bɛ 'bɔ Ɛjɔlɛkpa'n, bɛ 'kan like mɔ balasua ɛhɩ a yɔ a man mɩ́n nɩn anwʋn ɛjɔlɛ bɛ fa bɛ kacɩ yɩ́.” ");
INSERT INTO any_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Ɛhɩ, Zozi menian bulu nʋn nnyuan'n, bɛ́ nunhan kʋn'n mɔ bɛ fɛlɛ yɩ́ Zudasɩ Isikaliɔtɩ'n, ɔ hɔlɩ tʋlɩ Nyanmɩan *tɛɛyɩfʋɛ mgbain'n-mɔ a, ");
INSERT INTO any_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","yɩ́ nwan: “Sɛ mɩn yɩ Zozi mɩn man ɛmɔ a, nzu like dɩɛ yɛ̂ ɛmɔ 'fa man mɩ́n ɔ?” Ɛbɛlɛ ala, bɛ kɔ ha jɛtɛ fufue mma abulasan bɛ kɔ wula yɩ́ sa nun. ");
INSERT INTO any_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Ɔ fi tɛmʋn sɔ'n, Zudasɩ kɔ kpʋnndɛ atɩn mɔ ɔ 'sɩn sʋ ɔ yɩ Zozi man bɛ́'n. ");
INSERT INTO any_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Kpaʋn'n mɔ bɛ nwula man nun fali ayile'n, yɩ́ fɛtɩ cɩan'n m'ɔ li mʋa nɩn anun, Zozi menian'n-mɔ walɩ yɩ́ nwʋn ɛbɛlɛ a, bɛ́ nwan: “Ninhan yɛ̂ ɛ kulo kɛ yɛ hɔ́ tʋ́n *Pakɩ alɩɛ nɩn ɔ?” ");
INSERT INTO any_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Mɔ bɛ bisalɩ kosuan sɔ'n, Zozi nwan: “Ɛmɔ hɔ́ kulo ɛlɔ, sʋanlan sʋa awulo, bɛ se yɩ́ kɛ: ‘Yɛ́ Mɩn nwan: Mɩ́n mɛlɛ nɩn a ju, wɔ́ awulo ɛwa yɛ̂ mɩn nʋn mɩ́n menian'n-mɔ yɛ 'di Pakɩ alɩɛ nɩn ɔ.’” ");
INSERT INTO any_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Zozi menian'n-mɔ yɔlɩ m'ɔ helelɩ bɛ́ kɛ bɛ yɔ́'n bɛ tʋnlɩn Pakɩ alɩɛ'n. ");
INSERT INTO any_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Nɔsʋba, Zozi nʋn yɩ́ menian bulu nʋn nnyuan'n kɔ tɛtanlan tɔbɩlɩ nɩn anwʋn. ");
INSERT INTO any_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Nán mɔ bɛ 'di like'n, Zozi nwan: “Mɩɩn kan yɩ́ ananhɔlɛ mɩn kele ɛmɔ kɛ, ɛmɔ nunhan kʋn 'ba yɩ mɩ́n man.” ");
INSERT INTO any_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Mɔ Zozi hanlɩn sɔ'n, yɩ́ menian'n-mɔ alʋa kɔ bɔ bɛ́ nwʋn kpa. Bɛ́ nun kʋn biala nwan: “Yɛ́ Mɩn, nán mɩ́n ɔ.” ");
INSERT INTO any_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Zozi nwan: “Sʋanlan'n m'ɔ nʋn mɩ́n yɛ́ sa wɔ talie nɩn anun'n, yɩ́ yɛ̂ ɔ 'yɩ mɩ́n man ɔ. ");
INSERT INTO any_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","*Mân Baa'n, ɔ 'ba wu kɛ bɛ hɛlɛlɩ yɩ́ nwʋn ɛjɔlɛ'n wɔ Ɛhɛlɛ Ɛjɔlɛ'n nɩn anun'n. Nan sʋanlan'n mɔ ɔ 'yɩ yɩ́ man'n, munnzue hán yɩ́! Ɔ tɩ kpa kɛ ahan b'a nwʋ man sʋanlan sɔ'n bɔbɔ.” ");
INSERT INTO any_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Zudasɩ mɔ ɔ 'yɩ yɩ́ man'n nwan: “*Labi, nán mɩ́n ɔ. Sɛ ato e.” Zozi nwan: “Wɔ́ muonun, ɛ sɩ kɛ wɔ́ ɔ.” ");
INSERT INTO any_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Mɔ bɛ 'di like'n, Zozi kɔ fa kpaʋn, m'ɔ lalɩ Nyanmɩan asɩ yuelɩ'n, ɔ kɔ bubu nun ɔ kɔ man yɩ́ menian'n-mɔ. Yɩ́ nwan: “Ɛmɔ lé kpaʋn ɛhɩ bɛ lí, ɔ tɩ mɩ́n nwʋnnaan.” ");
INSERT INTO any_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Yɩ́ nzin, ɔ kɔ fa divɩn kangɔ kʋn, m'ɔ lalɩ Nyanmɩan asɩ yuelɩ'n, ɔ kɔ fa ɔ kɔ man yɩ́ menian'n-mɔ. Yɩ́ nwan: “Ɛmɔ kʋalaa nʋ́n. ");
INSERT INTO any_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Ɔ sanlɩn kɛ nzan ɛhɩ tɩ mɩ́n moja ɔ di Nyanmɩan nyɩhyɛ'n m'ɔ nʋn ɛmɔ lɛ di nɩn ajinlanmun. Moja sɔ nɩn a butu a man menian dɔʋn a nyan ɛtɛ face. ");
INSERT INTO any_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Mɩɩn kan mɩn kele ɛmɔ kɛ ɔ fi ɛnɛ m'ɔ kɔ'n, mɩn nʋn ɛmɔ yɛ lɛ mma nnʋn man divɩn ɛhɩ fɩ́ɩ́ kʋ́n. Mɩn nʋn ɛmɔ yɛ 'nʋn divɩn fʋfɔlɛ'n mɩ́n Sɩ Belemgbin Mân nɩn anun ɛlɔ.” ");
INSERT INTO any_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Mɔ Zozi hanlɩn sɔ yuelɩ'n, bɛ kɔ tʋ ejue. Bɛ fi ɛbɛlɛ bɛ́ nʋan y'ɔ le *Olivʋ bʋka nɩn asʋ. ");
INSERT INTO any_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Mɔ bɛ hɔlɩ juli Olivʋ bʋka nɩn asʋ ɛlɔ'n, Zozi nwan: “Ɛnɛ kɔngɔɛ muonun, ɛmɔ kʋalaa 'ba nwanndi mɩ́n, ɔ ka mɩ́n ngʋnmɩn. Ɔ sanlɩn kɛ, b'a hɛlɛ wɔ Ɛhɛlɛ Ɛjɔlɛ nɩn anun kɛ: Mɩn 'ba hun bʋa ɛnɩanfʋɛ'n. Yɩ́ mmʋa'n-mɔ kʋalaa 'ba bɔ asanndɩɛ. ");
INSERT INTO any_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Nan sɛ mɩn wu mɩn tinnge a, mɩn 'di mʋa ɛmɔ anyunnun Galile mân nɩn anun ɛlɔ.” ");
INSERT INTO any_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Pɩɛlɩ jasʋlɩ a, yɩ́ nwan: “Sɛ bɛ́ kʋalaa bɛ nwanndi wɔ́ a, mɩ́n kʋnmgba cein dɩɛ mɩn nnwanndi man wɔ́ lé.” ");
INSERT INTO any_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Mɔ Pɩɛlɩ anʋan tɔlɩ'n, Zozi nwan: “Mɩɩn kan yɩ́ ananhɔlɛ mɩn kele wɔ́ kɛ ɛnɛ kɔngɔɛ muonun, ɔ nʋn dee mɔ akɔ'n 'bɔ kokolokoo'n, ɛ 'kan yɩ́ ngʋkʋn kpɛ̂ nsan kɛ ɛ nzɩ man mɩ́n.” ");
INSERT INTO any_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Pɩɛlɩ nwan: “Sɛ ɔ di mɔ mɩn nʋn wɔ́ wu bɔbɔ a, mɩn ngan man sɔ lé.” Yɩ́ menian'n-mɔ kʋalaa kɔ han sɔ bie. ");
INSERT INTO any_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","M'ɔ yɔlɩ sɔ'n, Zozi nʋn yɩ́ menian'n-mɔ hɔlɩ juli lɩka kʋn *Olivʋ bʋka nɩn asʋ. Bɛ fɛlɛ lɩka sɔ'n Gɛtɩsemanne (yɩ́ bʋ y'ɔ le kɛ lɩka mɔ bɛ yɩ ngo). Mɔ bɛ juli ɛbɛlɛ'n, Zozi nwan: “Ɛmɔ tánlan ɛwa nán mɩn 'tɩ mɩ́n nwʋn kaan mɩn yɔ asɔnɩn.” ");
INSERT INTO any_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Mɔ ɔ 'kɔ'n, ɔ nʋn Pɩɛlɩ nʋn Zebede amma nnyuan'n yɛ̂ bɛ hɔlɩ ɔ. Anwʋnmmubue nʋn alʋabɔ kɔ han Zozi. ");
INSERT INTO any_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Ɔ kɔ han kɔ hele bɛ́ kɛ: “Ewue nɩn a man mɩ́n lʋa a bɔ mɩ́n nwʋn sʋnman. Ɛmɔ nʋn mɩ́n tánlan ɛwa, nán bɛ sísa!” ");
INSERT INTO any_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Zozi hɔlɩ yɩ́ nyunnun mʋa kaan an, ɔ kɔ butu yɩ́ nyɩn asɩ ɔ kɔ yɔ asɔnɩn. Yɩ́ nwan: “Mɩ́n Sɩ, sɛ ɛ kʋala kɛ ɛ kpala ewue nyinlinlin ɛhɩ gua a, anɩn kpala gua! N'ɛ man mɩn nʋn ewue kangɔ nɩn anun. Nan kʋsʋ like biala anun, yɔ mɔ ɛ kulo'n nan n'ɛ yɔ mɔ mɩn kulo'n.” ");
INSERT INTO any_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","M'ɔ yɔlɩ asɔnɩn'n yuelɩ'n, ɔ kɔ sa kɔ a yɩ́ menian nsan'n-mɔ anwʋn ɛbɛlɛ. Ɔ 'ba ju a, anɩn bɛ lɛ dafɩ. Zozi kɔ fɛlɛ Pɩɛlɩ, yɩ́ nwan: “Ɛmɔ a ngʋala man mɩ́n nʋn asɩ tanlan dɔhyʋɩlɩ kʋnmgba cein? ");
INSERT INTO any_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Nán bɛ dafɩ, bɛ tánlan asɩ bɛ yɔ́ asɔnɩn, nán Abɔnsanmʋn a nzɔ man ɛmɔ a nnɩan man. Ɔ wɔ ɛmɔ ahʋnlɩn nɩn anun kɛ ɛmɔ 'yɔ, nan kʋsʋ anwʋnnaan'n le man anwʋnsɛlɛ.” ");
INSERT INTO any_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Mɔ Zozi hanlɩn sɔ'n, ɔ kɔ yaci bɛ́ ɛbɛlɛ ɔ kɔ hɔ asɔnɩn ɛyɔlɛ biekun. Yɩ́ nwan: “Mɩ́n Sɩ, sɛ m'an nnʋn man ewue kangɔ ɛhɩ anun nán ɔ nyɔ man ye a, anɩn man n nʋ́n nun kɛ ɛ kulo'n.” ");
INSERT INTO any_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Zozi kɔ sa kɔ a. Ɔ 'ba ju a, anɩn yɩ́ menian'n-mɔ lɛ dafɩ kpa. Ɔ sanlɩn kɛ anɩn nafɛlɛ nɩn a bʋ bɛ́. ");
INSERT INTO any_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Yɩ́ kpɛ̂ nsan nɩn asʋ, Zozi kɔ yaci bɛ́ ɛbɛlɛ ɔ kɔ hɔ asɔnɩn kʋnmgba nɩn ɛyɔlɛ biekun. ");
INSERT INTO any_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","M'ɔ yɔlɩ asɔnɩn yuelɩ'n, ɔ kɔ sa kɔ a yɩ́ menian'n-mɔ anwʋn ɛbɛlɛ, nán ɔ'a bisa bɛ́ kɛ: “Ɛmɔ tɛ dafɩ bɛ tɛ de bɛ́ ɛnwʋnmɩan? Ɛmɔ nɩ́an, dɔɛ'n mɔ bɛ 'fa bɛ yɩ Mân Baa'n bɛ man ɛtɛfʋɛ'n-mɔ nɩn a ju. ");
INSERT INTO any_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Ɛmɔ jásʋ bɛ mán yɛ hɔ́. Ɛmɔ nɩ́an, sʋanlan'n mɔ ɔ 'ba yɩ mɩ́n man'n, ɔ'a ju ɛwa.” ");
INSERT INTO any_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Zozi anʋan ngɔ tɔ man, yɩ́ menian bulu nʋn nnyuan nɩn anun kʋn'n mɔ bɛ fɛlɛ yɩ́ Zudasɩ'n kɔ fite ɛbɛlɛ. Ɔ 'ba a, menian dɔʋn si yɩ́ sʋ. Bɛ lile dadɩɛ nʋn koloman. Menian sɔ'n-mɔ, Nyanmɩan *tɛɛyɩfʋɛ mgbain'n-mɔ nʋn Zufʋ mgbain'n-mɔ yɛ̂ bɛ sʋanlɩn bɛ́ ɔ. ");
INSERT INTO any_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Mɔ bɛ 'ba'n, Zudasɩ mɔ ɔ 'yɩ Zozi man'n kɔ hele bɛ́ nzɔlɛ kʋn. Yɩ́ nwan: “Sʋanlan'n mɔ n gɔ tɔ yɩ́ nun'n, anɩn ɛmɔ sɩ kɛ yɩ́ dein ɔ. Ɛmɔ hyɩ́ yɩ́.” ");
INSERT INTO any_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Mɔ Zudasɩ juli ɛbɛlɛ nɩn ala, ɔ kɔ kpunnge Zozi. Yɩ́ nwan: “*Labi, anun o.” M'ɔ hanlɩn sɔ'n, ɔ'a tɔ Zozi nun. ");
INSERT INTO any_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Zozi nwan: “Mɩ́n manngʋn, like mɔ ɛ walɩ yɩ́ ɛyɔlɛ'n, yɔ.” Ɛbɛlɛ ala, menian'n-mɔ kɔ tɩ kɔ gua Zozi sʋ bɛ kɔ hyɩ yɩ́. ");
INSERT INTO any_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Bɛ́ mɔ anɩn bɛ nʋn Zozi wɔ ɛbɛlɛ nɩn anun kʋn kɔ hyʋɩn yɩ́ dadɩɛ'n, ɔ kɔ kpɛ Nyanmɩan *tɛɛyɩfʋɛ kpain nɩn akʋa nɩn anzʋ'n. ");
INSERT INTO any_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","M'ɔ kpɛlɩ yɩ́ nzʋ'n, Zozi nwan: “Fa wɔ́ dadɩɛ'n wula yɩ́ bʋa nɩn anun. Ɔ sanlɩn kɛ bɛ́ mɔ bɛ fa dadɩɛ bɛ kʋn'n, dadɩɛ yɛ̂ ɔ 'kun bɛ́ ɔ. ");
INSERT INTO any_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Ɛ nzɩ man kɛ sɛ mɩn se mɩ́n Sɩ kɛ ɔ bɛ́lɛ mɩ́n nyanmɩansʋ mmɔfʋɛ akpɩɩ akpɩɩ maan bɛ sísa mɩ́n an, ɔ 'yɔ yɩ́ kɩkaala ɔ? ");
INSERT INTO any_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Sɛ mɩn yɔ yɩ́ sɔ a, ɔ 'yɔ sɛ nán Nyanmɩan Anʋan Ɛjɔlɛ nɩn a kpɩn sʋ? Mɔ Ɛhɛlɛ Ɛjɔlɛ nɩn a han'n, ɔ di kɛ ɔ yɔ sɔ.” ");
INSERT INTO any_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","M'ɔ yɔlɩ sɔ yuelɩ'n, Zozi kɔ han kɔ hele meninsʋnman'n kɛ: “Ɛmɔ 'ba hyɩ mɩ́n an, anɩn ɛmɔ le dadɩɛ nʋn koloman kɛ kodiawu y'ɔ le mɩ́n. Kɛmɔ cɩan daa n dɩ asɩ Nyanmɩan awulo nɩn anun mɩn kekele menian'n-mɔ ninnge'n, nzukɛ ati yɛ̂ ɛmɔ a njɩ man mɩ́n ɔ?” ");
INSERT INTO any_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Nan yɩ́ kʋalaa a yɔ sɔ, ɔ'a man ɛjɔlɛ'n mɔ Nyanmɩan mgbɔmanfʋɛ'n-mɔ hanlɩn m'ɔ wɔ Ɛhɛlɛ Ɛjɔlɛ nɩn anun nɩn a kpɩn sʋ. Mɛlɛ sɔ nɩn anun, Zozi menian'n-mɔ kʋalaa yacili yɩ́ ɛbɛlɛ bɛ nwanndili. ");
INSERT INTO any_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Bɛ́ mɔ bɛ hyɩlɩ Zozi'n, bɛ nʋn yɩ́ hɔlɩ Nyanmɩan *tɛɛyɩfʋɛ kpain'n mɔ bɛ fɛlɛ yɩ́ *Kayifʋ nɩn awulo. Ɛbɛlɛ yɛ̂ *mala nɩn asʋ mgbain'n-mɔ nʋn Zufʋ mgbain'n-mɔ hɔlɩ yialɩ ɔ. ");
INSERT INTO any_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Mɔ bɛ 'kɔ'n, anɩn Pɩɛlɩ lɛ di Zozi fannvanndʋ dede bɛ juli Nyanmɩan tɛɛyɩfʋɛ kpain nɩn awulo. Pɩɛlɩ kɔ wʋlʋ awulo nɩn anun, ɔ kɔ tanlan nzalafʋ'n-mɔ anwʋn ɛbɛlɛ, ɔ 'nɩan kɛ ɛjɔlɛ sɔ'n 'ba kpɩn gua yɩ́ bʋ'n. ");
INSERT INTO any_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Nyanmɩan tɛɛyɩfʋɛ mgbain'n-mɔ nʋn menian'n-mɔ kʋalaa mɔ bɛ di ɛjɔlɛ'n kɔ kpʋnndɛ atɩn mɔ bɛ 'sɩn sʋ bɛ tʋn Zozi ɛsʋan bɛ kun yɩ́. ");
INSERT INTO any_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Bɛ kpʋnndɛlɩ, kʋsʋ bɛ ngɔ nyan man bie sunnzun mɔ adanzɩyua dɔʋn tʋnlɩn yɩ́ ɛsʋan ɔ. Yɩ́ bɛ-yue-asɩɛ, menian nnyuan walɩ a, bɛ́ nwan: ");
INSERT INTO any_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","“Bian ɛhɩ a han kɛ: ‘Mɩn kʋala kɛ mɩn bu Nyanmɩan sua'n mɩn fa cɩan nsan mɩn si.’” ");
INSERT INTO any_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Mɔ menian'n-mɔ hanlɩn sɔ'n, Nyanmɩan tɛɛyɩfʋɛ kpain'n kɔ jasʋ, ɔ kɔ bisa Zozi kɛ: “Ɛjɔlɛ'n mɔ bɛ lɛ kan bɛ gua wɔ́ nwʋn'n, ɛ mmua man bie ɔ?” ");
INSERT INTO any_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Zozi ngɔ tɛ man yɩ́ sʋ. Nyanmɩan tɛɛyɩfʋɛ kpain'n kɔ han kɔ hele yɩ́ kɛ: “Mɩn kan Tɩasɩfʋɛ Nyanmɩan nɩn ati, sɛ Kilisi'n m'ɔ tɩ Nyanmɩan Awa'n y'ɔ le wɔ́ a, anɩn kan maan yɛ tɩ́!” ");
INSERT INTO any_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Zozi kɔ bua yɩ́ kɛ: “Yɛ̂ wɔ́ nʋan wɔ sʋ ɛ lɛ kan nɩn ɔ. Nan mɩɩn kan mɩn kele ɛmɔ kɛ ɛnɛ m'ɔ kɔ'n, ɛmɔ 'ba nwun yɩ́ kɛ *Mân Baa'n tɩ Nyanmɩan tunminfʋɛ'n fama sʋ. Ɛsɛ ɛmɔ 'ba nwun yɩ́ kɛ ɔ fi anwunno ɛlɔ bɔlɛ́ nɩn anun ɔ lɛ ba.” ");
INSERT INTO any_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Mɔ Nyanmɩan tɛɛyɩfʋɛ kpain'n tɩlɩ ɛjɔlɛ sɔ'n Zozi anʋan nun'n, ɔ kɔ sɔ taladɩɛ'n mɔ yɩ́ muonun ɔ wula'n ɔ kɔ sosua nun. Yɩ́ nwan: “Sian dɩɛ, yɛ mgbʋnndɛ man adanzɩɛ kʋ́n! Afɩ ɛmɔ kʋalaa a tɩ kɛ ɔ'a han ɛjɔlɛ ɛtɛ ɔ'a tia Nyanmɩan! ");
INSERT INTO any_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Nan ɛmɔ nwan nzɛ?” Bɛ́ kʋalaa bɛ́ nwan: “Ɔ fata kɛ bɛ kun yɩ́.” ");
INSERT INTO any_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Ɛhɩ, bɛ kɔ tʋtʋ Zozi anyunnun ngɛsɛlɛ, ɛsɛ bɛ kɔ tʋtʋ yɩ́ kɔtɔlɛ. Mmie-mɔ fɩa yɩ́ nyɩn bɛ kpaci yɩ́ nyɩn nɩn asʋ, ");
INSERT INTO any_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","anɩn bɛ́ nwan: “Wɔ́ mɔ ɛ tɩ Kilisi'n, kele yɛ́ sʋanlan'n mɔ ɔ'a kpaci wɔ́ nyɩn nɩn asʋ'n!” ");
INSERT INTO any_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Ɔ 'ba yɔ sɔ'n, anɩn Pɩɛlɩ tɩ awulo nɩn abʋ ɛlɔ. Nyanmɩan *tɛɛyɩfʋɛ kpain nɩn afanɩan kʋn kɔ a Pɩɛlɩ anwʋn ɛbɛlɛ, yɩ́ nwan: “Wɔ́ kʋsʋ wɔ́, anɩn ɛ si Zozi m'ɔ fi Galile mân nɩn anun nɩn asʋ bie.” ");
INSERT INTO any_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","M'ɔ hanlɩn sɔ'n, Pɩɛlɩ suli akpʋlʋwa bɛ́ kʋalaa bɛ́ nyunnun ɛbɛlɛ. Yɩ́ nwan: “Sʋanlan'n mɔ ɛ lɛ kan yɩ́ ɛjɔlɛ'n, mɩn nzɩ man yɩ́.” ");
INSERT INTO any_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Ɛhɩ, ɔ fi ɛbɛlɛ ɔ kɔ jasʋ ɔ kɔ hɔ kɔ jinlan awulo nɩn anʋan nɩn anun ɛlɔ. Afanɩan kʋn biekun kɔ nwun yɩ́. Ɔ kɔ han kɔ hele bɛ́ mɔ bɛ gua ɛbɛlɛ'n kɛ: “Zozi m'ɔ fi Nazalɛtɩ'n, anɩn bian ɛhɩ si yɩ́ sʋ bie.” ");
INSERT INTO any_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Ɛhɩ, Pɩɛlɩ nwan: “Mɩn kan ndâ kɛ mɩ́n dɩɛ, mɩn nzɩ man sʋanlan sɔ'n!” ");
INSERT INTO any_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Ɔ hyɛlɩ kaan an, bɛ́ mɔ bɛ gua ɛbɛlɛ'n kɔ kpunnge Pɩɛlɩ, bɛ́ nwan: “Ɔ tɩ ananhɔlɛ, ɛ wɔ menian sɔ'n-mɔ anun bie. Ɔ sanlɩn kɛ wɔ́ ɛjʋjɔlɛ'n kele lɩka mɔ ɛ fi'n.” ");
INSERT INTO any_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Ɛhɩ, Pɩɛlɩ nwan: “Mɩn kan ndâ kɛ mɩn nzɩ man sʋanlan sɔ'n! Sɛ ato yɛ̂ mɩɩn di a, Nyanmɩan Kpili túa mɩ́n yɩ́ nwʋn kalɛ!” Kɛ ɔ 'kan sɔ nɩn ala, kokolokoo! Akɔ'n kɔ bɔ. ");
INSERT INTO any_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Pɩɛlɩ ati kɔ kacɩ ɛjɔlɛ'n mɔ Zozi hanlɩn helelɩ yɩ́'n. Zozi nwan: “Ɔ nʋn dede mɔ akɔ'n 'bɔ'n, ɛ 'kan yɩ́ ngʋkʋn kpɛ̂ nsan kɛ ɛ nzɩ man mɩ́n.” M'ɔ yɔlɩ sɔ'n, Pɩɛlɩ fitelɩ ɔ sunlin sɛlɛ kpa. ");
INSERT INTO any_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Mɔ alɩ́ɛ'n hɩnlɩn'n, Nyanmɩan *tɛɛyɩfʋɛ mgbain'n-mɔ nʋn Zufʋ mgbain'n-mɔ kʋalaa anʋan sɛlɩ bɛ́ nwʋn kɛ bɛ 'kun Zozi. ");
INSERT INTO any_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Bɛ kɔ man bɛ kɔ cɩcɩ Zozi. Bɛ kɔ fa yɩ́ bɛ kɔ hɔ kɔ wula *Lɔmʋn kʋnmanna nɩn asa nun. Kʋnmanna sɔ'n, bɛ fɛlɛ yɩ́ *Pilatɩ. ");
INSERT INTO any_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Mɔ Zudasɩ m'ɔ yɩlɩ Zozi manlɩn'n nwunlin kɛ bɛ lɛ ba hun Zozi'n, ɔ kɔ li yɩ́ nwʋn yalɛ kpa. Jɛtɛ fufue mma abulasan'n mɔ Nyanmɩan *tɛɛyɩfʋɛ mgbain'n-mɔ nʋn Zufʋ mgbain'n-mɔ falɩ manlɩn yɩ́'n, ɔ kɔ fa ɔ kɔ sa kɔ bɛlɛ bɛ́. ");
INSERT INTO any_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Yɩ́ nwan: “M'an yɔ ɛtɛ, ɔ sanlɩn kɛ m'an tʋn sʋanlan ɛsʋan maan b'a hun yɩ́.” Mɔ Zudasɩ hanlɩn sɔ'n, bɛ́ nwan: “Ɔ nvalɩ man yɛ́ nwʋn. Wɔ́ ngʋnmɩn wɔ́ ɛjɔlɛ ɔ!” ");
INSERT INTO any_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Zudasɩ kɔ ju esika'n kɔ gua Nyanmɩan sua nɩn anun ɛbɛlɛ ɔ kɔ hɔ kɔ bɔ yɩ́ kɔmɩn. ");
INSERT INTO any_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Nyanmɩan tɛɛyɩfʋɛ mgbain'n-mɔ kɔ sɩsa esika'n. Bɛ́ nwan: “Yɛ́ mala'n mman man yɛ́ atɩn kɛ yɛ fá esika sɔ'n yɛ gúa asɔnɩn esika nɩn anun. Ɔ sanlɩn kɛ sʋanlan moja esika ɔ.” ");
INSERT INTO any_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Bɛ hanlɩn sɔ mɔ bɛ́ kʋalaa bɛ́ nʋan sɛlɩ yɩ́ nwʋn'n, bɛ falɩ esika sɔ'n bɛ tolɩ sʋanlan'n m'ɔ nwʋn ninnge nɩn ebo'n. Bɛ falɩ asɩɛ sɔ'n bɛ yɔlɩ nyɔfʋɛ asielɩɛ. ");
INSERT INTO any_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Ɛhɩ ati, ɛnɛ nʋn ɛnɛ, bɛ tɛ fɛlɛ lɩka sɔ'n “Moja Ebo”. ");
INSERT INTO any_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Ɔ man ɛjɔlɛ'n mɔ Nyanmɩan falɩ wulalɩ kpɔmanfʋɛ Zolomin anʋan'n kpɩnlɩn sʋ. Kpɔmanfʋɛ Zolomin nwan: Jɛtɛ fufue mma abulasan, esika mɔ Izalayɛ amma'n-mɔ anʋan sɛlɩ yɩ́ nwʋn bɛ falɩ bɛ lili yɩ́ gua nɩn anɩn. ");
INSERT INTO any_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Esika sɔ'n b'a fa b'a to sʋanlan'n m'ɔ nwʋn ninnge nɩn ebo'n kɛ yɛ́ Mɩn hanlɩn helelɩ mɩ́n'n. ");
INSERT INTO any_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Bɛ falɩ Zozi bɛ hɔlɩ kʋnmanna nɩn aja sʋ. Ɔ kɔ bisa Zozi kɛ: “Zufʋ'n-mɔ belemgbin'n y'ɔ le wɔ́ ɔ?” Zozi nwan: “Yɛ̂ wɔ́ nʋan wɔ sʋ ɛ lɛ kan nɩn ɔ.” ");
INSERT INTO any_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Nan mɔ Nyanmɩan *tɛɛyɩfʋɛ mgbain'n-mɔ nʋn Zufʋ mgbain'n-mɔ 'tʋn Zozi ɛsʋan'n, Zozi ngɔ tɛ man bɛ́ sʋ. ");
INSERT INTO any_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Ɛhɩ, Pilatɩ nwan: “Ɛsʋan nwala ɛhɩ mɔ bɛ lɛ tʋn wɔ́'n, ɛ ndɩ man ɔ?” ");
INSERT INTO any_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Zozi ngɔ bua ɛjɔlɛ kpɔlɛ kʋn sʋa. M'ɔ man ɛjɔlɛ'n sinlin kʋnmanna nɩn anwʋn kpili nɩn anɩn. ");
INSERT INTO any_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Bɛ 'di *Pakɩ fɛtɩ biala a, sʋanlan mɔ bɛ kɔ tʋ yɩ́ fiadɩ mɔ menian'n-mɔ kulo kɛ bɛ yaci yɩ́'n, kʋnmanna'n yaci sʋanlan sɔ'n. ");
INSERT INTO any_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Ɔ 'ba yɔ sɔ'n, anɩn bian kʋn la fiadɩ. Bɛ fɛlɛ bian sɔ'n Balabasɩ. Yɩ́ nwʋn yɔ esulo kpa, ɛsɛ bɛ́ kʋalaa bɛ sɩ yɩ́. ");
INSERT INTO any_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Pilatɩ kɔ bisa menian'n-mɔ mɔ b'a yia ɛbɛlɛ'n kɛ: “Balabasɩ nʋn Zozi mɔ bɛ fɛlɛ yɩ́ Kilisi'n, bɛ́ nunhan benin yɛ̂ ɛmɔ kulo kɛ n yáci yɩ́ ɔ?” ");
INSERT INTO any_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Ɔ kɔ bisa bɛ́ sɔ, afɩ ɔ sɩ yɩ́ fɔ́ʋ́n kɛ bɛ kpɔ Zozi, yɩ́ ti yɛ̂ b'a hyɩ yɩ́ b'a man yɩ́ ɔ. ");
INSERT INTO any_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Anɩn Pilatɩ tɩ lɩka mɔ bɛ di ɛjɔlɛ'n, yɩ́ yɩ falɩ ngalɩɛ hɔlɩ manlɩn yɩ́ kɛ: “N'ɛ fa wɔ́ ɛjɔlɛ tʋ sʋanlan sɔ nɩn anwʋn, ɔ tɩ sɛsɛfʋɛ. Yɩ́ dunman nun, ɛnɛ kɔngɔɛ n jɩnlɩn ɛlalɩɛ ɛtɛ ɛtɛ.” ");
INSERT INTO any_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Tɛmʋn sɔ'n, anɩn Nyanmɩan *tɛɛyɩfʋɛ mgbain'n-mɔ nʋn Zufʋ mgbain'n-mɔ lɛ wowula meninsʋnman nɩn abʋ kɛ bɛ hán maan ɔ yáci Balabasɩ nán bɛ hún Zozi. ");
INSERT INTO any_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Kʋnmanna'n kɔ bisa bɛ́ biekun kɛ: “Bɛ́ menian nnyuan'n, benin yɛ̂ ɛmɔ kulo kɛ n yáci yɩ́ ɔ?” Bɛ́ kʋalaa bɛ́ nwan: “Yaci Balabasɩ!” ");
INSERT INTO any_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pilatɩ kɔ bisa bɛ́ kɛ: “Anɩn Zozi mɔ bɛ fɛlɛ yɩ́ Kilisi'n, n yɔ́ yɩ́ sɛ?” Bɛ́ kʋalaa bɛ́ nwan: “Bʋbɔ yɩ́ kʋlʋwa sʋ!” ");
INSERT INTO any_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Pilatɩ kɔ bisa bɛ́ kɛ: “Nzukɛ ɛtɛ dɩɛ yɛ̂ ɔ'a yɔ ɔ?” Bɛ́ kʋalaa bɛ kɔ tɛtɩan sɛlɛ kpa bɛ́ nwan: “Bʋbɔ yɩ́ kʋlʋwa sʋ!” ");
INSERT INTO any_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Anɩn menian'n-mɔ lɛ tɛtɩan sʋnman. Pilatɩ nɩan an, ɔ ngʋala man like fɩ́ɩ́ kʋ́n yɔ. Ɔ kɔ jasʋ ɔ kɔ fa nzue ɔ kɔ nwunnzin yɩ́ sa menian'n-mɔ kʋalaa anyunnun ɛbɛlɛ. Yɩ́ nwan: “Sʋanlan ɛhɩ ewue'n, mɩ́n nwʋn nnʋn man nun, m'an yɩ mɩ́n sa nun! Ɛmɔ angʋnmɩn, bɛ́ ɛjɔlɛ ɔ!” ");
INSERT INTO any_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Bɛ́ kʋalaa bɛ́ nwan: “Yuo o! Yɛ́ nʋn yɛ́ mma'n-mɔ, man yɩ́ ewue nɩn anwʋn ɛjɔlɛ kpólo yɛ́!” ");
INSERT INTO any_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Ɛhɩ, Pilatɩ kɔ yaci Balabasɩ. Ɔ kɔ man bɛ kɔ fin Zozi mgbele. Mɔ bɛ finlin yɩ́ yuelɩ'n, ɔ yɩlɩ yɩ́ manlɩn maan bɛ bʋbɔlɩ yɩ́ kʋlʋwa sʋ. ");
INSERT INTO any_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Pilatɩ nzalafʋ'n-mɔ falɩ Zozi hɔlɩ yɩ́ awulo ɛlɔ. Bɛ kɔ yia nzalafʋɛ'n-mɔ kʋalaa Zozi anwʋn ɛbɛlɛ. ");
INSERT INTO any_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Bɛ kɔ yɩ yɩ́ taladɩɛ'n m'ɔ wula'n, bɛ kɔ fa taladɩɛ kɔkɔlɛ bɛ kɔ wula yɩ́. ");
INSERT INTO any_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Bɛ kɔ nwʋn mmowe abotile bɛ kɔ bɔ yɩ́ ti. Bɛ kɔ fa ndɛɛ kpɔman bɛ kɔ wula yɩ́ sa fama nɩn anun. Mɔ bɛ yɔlɩ sɔ yuelɩ'n, bɛ kɔ kʋtʋ yɩ́ nyunnun ɛbɛlɛ bɛ kɔ yɛyala yɩ́ nwʋn. Bɛ́ nwan: “Zufʋ'n-mɔ belemgbin, ahɩn o!” ");
INSERT INTO any_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Bɛ kɔ tʋtʋ yɩ́ nwʋn ngɛsɛlɛ. Bɛ kɔ tʋa yɩ́ bɛ kɔ le kpɔman'n m'ɔ le'n bɛ kɔ fa bɛ kɔ fifin yɩ́ tin nɩn anun. ");
INSERT INTO any_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Bɛ yɛyalalɩ yɩ́ nwʋn dede mɔ bɛ́ kunnun jɔlɩ'n, bɛ kɔ yɩ́ taladɩɛ kɔkɔlɛ'n mɔ bɛ falɩ bɛ wulalɩ yɩ́'n. Bɛ kɔ fa yɩ́ muonun yɩ́ taladɩɛ dɩɛ'n bɛ kɔ wula yɩ́ yɛ̂ bɛ nʋn yɩ́ hɔlɩ bɛ bʋbɔlɩ yɩ́ kʋlʋwa sʋ ɔ. ");
INSERT INTO any_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Mɔ bɛ fi kulo nɩn anun bɛ 'fite'n, bɛ nʋn bian kʋn kɔ yia. Bian sɔ'n, bɛ fɛlɛ yɩ́ Simʋn. Ɔ fi kulo'n mɔ bɛ fɛlɛ yɩ́ Silɛnɩn nɩn asʋ. Bɛ kɔ hyɩ yɩ́ bɛ kɔ fa Zozi kʋlʋwa'n bɛ kɔ sʋa yɩ́. ");
INSERT INTO any_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Bɛ hɔlɩ dede bɛ juli lɩka kʋn. Lɩka sɔ'n, bɛ fɛlɛ yɩ́ Gɔlʋgota. Gɔlʋgota'n, yɩ́ bʋ y'ɔ le kɛ tile kangɔ lɩka. ");
INSERT INTO any_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Ɛbɛlɛ, bɛ kɔ fa divɩn bɛ kɔ man Zozi kɛ ɔ nʋ́n. Divɩn sɔ'n, bɛ gualɩ nun ayile m'ɔ nʋn an, ɔ nnwun man yalɛ'n sʋnman. Ɔ bɔlɩ sʋ, nan ɔ'a ngulo kɛ ɔ nʋn. ");
INSERT INTO any_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Mɔ bɛ bʋbɔlɩ yɩ́ kʋlʋwa nɩn asʋ yuelɩ'n, bɛ kɔ hyʋɩn tondo bɛ kɔ hye yɩ́ taladɩɛ'n-mɔ bɛ kɔ fa. ");
INSERT INTO any_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Ɛsɛ bɛ kɔ tɛtanlan yɩ́ nwʋn ɛbɛlɛ bɛ kɔ sisa yɩ́. ");
INSERT INTO any_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Like mɔ yɩ́ ti yɛ̂ bɛ lɛ kun yɩ́'n, b'a hɛlɛ b'a bɔ yɩ́ ti sʋ ɛbɛlɛ kɛ: “Sʋanlan ɛhɩ li Zozi. Ɔ tɩ Zufʋ'n-mɔ belemgbin.” ");
INSERT INTO any_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Bɛ kɔ bʋbɔ kodiawu nnyuan kʋsʋ kʋlʋwa sʋ Zozi anwʋn ɛbɛlɛ. Kʋn wɔ yɩ́ sa fama sʋ yɛ̂ kʋn kʋsʋ wɔ yɩ́ sa bɛ̂ sʋ. ");
INSERT INTO any_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Bɛ́ mɔ bɛ 'sɩn ɛbɛlɛ'n, bɛ kɔsɔ kɔsɔ bɛ́ ti, anɩn bɛ lɛ kpɛ yɩ́ nzʋba. ");
INSERT INTO any_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Bɛ́ nwan: “Wɔ́ mɔ wɔ́ nwan ɛ 'bu asɔnɩn sua'n, nán ɛ fa cɩan nsan ɛ si yɩ́ fʋfɔlɛ'n, de wɔ́ nwʋn e! Sɛ wɔ́ nwan ɛ tɩ Nyanmɩan Awa sakpa a, fi kʋlʋwa nɩn asʋ ju!” ");
INSERT INTO any_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","*Tɛɛyɩfʋɛ mgbain'n-mɔ, nʋn *mala nɩn asʋ mgbain'n-mɔ nʋn Zufʋ mgbain'n-mɔ kʋsʋ kɔ gʋlʋ yɩ́ nwʋn. ");
INSERT INTO any_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Bɛ́ nwan: “Ɔ'a le menian'n-mɔ ngʋan, kʋsʋ yɩ́ muonun ɔ ngʋala man yɩ́ nwʋn ngʋan de! Sɛ ɔ tɩ Izalayɛ belemgbin sakpa a, anɩn ɔ fi kʋlʋwa nɩn asʋ ɔ jú kɩkaala, nán yɛ 'ba le yɩ́ yɛ di. ");
INSERT INTO any_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Ɔ'a susu yɩ́ ti ɔ'a gua Nyanmɩan asʋ. Yɩ́ nwan: ‘Nyanmɩan Awa y'ɔ le mɩ́n’. Sɛ Nyanmɩan kulo yɩ́ a, anɩn ɔ lé yɩ́ ti kɩkaala!” ");
INSERT INTO any_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Kodiawu'n-mɔ kʋsʋ mɔ b'a bʋbɔ bɛ́ kʋlʋwa sʋ Zozi anwʋn ɛbɛlɛ'n kpɛlɩ yɩ́ nzʋba bie. ");
INSERT INTO any_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Mɔ sɛnzɛ'n jinlanlɩn bɛ́ ti afian'n, awosin wulalɩ mân nɩn anun lɩka kʋalaa dede ɔ juli nɔsʋba dɔɛ nsan. ");
INSERT INTO any_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Mɔ bɛ 'kɔ a bɔ dɔɛ nsan'n, Zozi kɔ tɩan nun sɛlɛ kpa. Yɩ́ nwan: “Eli, Eli, lama sabakɩtanin?” Ɛjɔlɛ sɔ'n, yɩ́ bʋ y'ɔ le kɛ “Mɩ́n Nyanmɩan, mɩ́n Nyanmɩan, nzukɛ ati yɛ̂ a yɩ mɩ́n ɔ?” ");
INSERT INTO any_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Mɔ bɛ́ mɔ bɛ jijin ɛbɛlɛ'n mmie-mɔ tɩlɩ yɩ́ ngan'n, bɛ́ nwan: “Ɔ lɛ fɛlɛ Eli!” ");
INSERT INTO any_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Ɛbɛlɛ ala, bɛ́ nunhan kʋn kɔ nwanndi ɔ kɔ hɔ kɔ fa eminlan ɔ kɔ bɔ divɩn nyinnyanlɩnwa anun. Ɔ kɔ fa kɔ san baka kʋn ati ɔ kɔ tɩnngɛ yɩ́ Zozi anʋan kɛ ɔ nʋ́n. ");
INSERT INTO any_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Nan ɛhɩnlɩn-mɔ nwan: “Jinlan maan yɛ nɩ́an sɛ Eli kɔ a kɔ le yɩ́ a!” ");
INSERT INTO any_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Zozi kɔ tɩan nun sɛlɛ kpa biekun, ɔ kɔ ha nun. ");
INSERT INTO any_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Mɛlɛ sɔ'n, mgbɛnun ɛtanlan'n m'ɔ ja asɔnɩn sua nɩn anun'n kɔ sua yɩ́ anwunno dede ɔ kɔ ju yɩ́ asɩ. Asɩɛ'n kɔ kpusu, nyɔbʋɛ mgbili'n-mɔ anun kɔ kpacɩ kpacɩ. ");
INSERT INTO any_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Sɛka'n-mɔ asʋ kɔ tike tike. Nyanmɩan anwʋntɩɛ mma'n-mɔ dɔʋn mɔ bɛ wuli'n kɔ tinnge tinnge. ");
INSERT INTO any_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Mɔ Zozi fi ewue nun tinngelɩ'n, bɛ́ kʋalaa mɔ bɛ fi sɛka'n-mɔ anun bɛ fitelɩ'n, bɛ hɔlɩ kulo kpili nwannzan-nwannzan nɩn asʋ bɛ yɩlɩ bɛ́ nwʋn bɛ helelɩ menian dɔʋn kpa. ");
INSERT INTO any_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Mɔ nzalafʋ kpain'n nʋn yɩ́ nzalafʋ'n-mɔ mɔ bɛ́ nʋn yɩ́ lɛ sisa Zozi'n nwunlin kɛ asɩɛ nɩn a kpusu nʋn yɩ́ nzin ɛjɔlɛ'n, esulo hanlɩn bɛ́ sɛlɛ kpa. Bɛ́ nwan: “Kannzʋ ɔ tɩ Nyanmɩan Awa sakpa!” ");
INSERT INTO any_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Anɩn mmalasua dɔʋn kpa kʋsʋ wɔ ɛbɛlɛ, bɛ jin mʋa bɛ lɛ nɩan Zozi. Bɛ́ yɛ̂ bɛ sili Zozi sʋ sunmin Galile mân nɩn anun bɛ sʋlɩ yɩ́ ɔ. ");
INSERT INTO any_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Mali m'ɔ fi Magɩdala'n, ɔ nʋn Zʋakɩ nʋn Zozɛfʋ anin Mali, ɔ nʋn Zebede amma'n-mɔ anin dɩɛ'n wɔ mmalasua sɔ'n-mɔ anun bie. ");
INSERT INTO any_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Mɔ alɩ́ɛ'n 'kɔ yɩ́ nɔsʋba nun'n, esikafʋɛ bian kʋn kɔ a kɔ ju ɛbɛlɛ. Bian sɔ'n, bɛ fɛlɛ yɩ́ Zozɛfʋ, ɔ tɩ Zozi sʋanlan'n kʋn. Ɔ fi Alimate kulo nɩn asʋ. ");
INSERT INTO any_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Ɔ kɔ hɔ kɔ tʋ Pilatɩ ɔ kɔ sɛlɛ yɩ́ kɛ ɔ 'fa Zozi fuin'n ɔ 'kɔ a sie yɩ́. Ɛhɩ, Pilatɩ kɔ man atɩn kɛ bɛ fá bɛ mán yɩ́. ");
INSERT INTO any_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Ɔ kɔ le fuin'n ɔ kɔ fa kisaan fʋfɔlɛ kʋn ɔ kɔ fʋfɔ yɩ́ nwʋn. ");
INSERT INTO any_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Yɩ́ muonun yɩ́ sɛka mɔ ɔ'a man b'a kpɛ yɩ́ ɛbʋta kʋn anun'n, ɔ kɔ sie Zozi nun. M'ɔ sielɩ yɩ́ yuelɩ'n, ɔ kunndolɩ ɛbʋɛ kpili kʋn ɔ nyinlin sɛka nɩn anʋan'n yɛ̂ ɔ salɩ hɔlɩ ɔ. ");
INSERT INTO any_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Anɩn Mali m'ɔ fi Magɩdala'n, ɔ nʋn Mali kʋn'n bɛ wɔ ɛbɛlɛ. Bɛ tɩtɩ asɩ sɛka nɩn anyunnun. ");
INSERT INTO any_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Zufʋ'n-mɔ bɔbʋalɩ bɛ́ nwʋn bɛ sielɩ. Mɔ yɩ́ alɩ́ɛ hɩnlɩn m'ɔ tɩ ɛnwʋnmɩan ele cɩan'n, Nyanmɩan *tɛɛyɩfʋɛ mgbain'n-mɔ nʋn *Falisifʋɛ'n-mɔ kɔ hɔ kɔ tʋ Pilatɩ. Bɛ́ nwan: ");
INSERT INTO any_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","“Nannan, akʋa atofʋɛ sɔ nɩn ɛjɔlɛ kʋn mɔ anɩn yɩ́ nyɩn wɔ sʋ m'ɔ hanlɩn'n, yɛ́ ti a kpɩn sʋ. Yɩ́ nwan: ‘Sɛ mɩn wu a, yɩ́ cɩan nsan, mɩn 'tinnge.’ ");
INSERT INTO any_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Yɩ́ ti, man atɩn maan bɛ hɔ́ sísa sɛka'n dede cɩan nsan. Ɔ'a nyɔ man sɔ a, yɩ́ menian'n-mɔ 'kɔ a sa yɩ́ bɛ laka menian'n-mɔ kɛ: ‘Ɔ fi ewue nun ɔ'a tinnge!’ Afɩ, sian ato mɔ bɛ 'di'n, ɔ 'tala daba dɩɛ'n.” ");
INSERT INTO any_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Ɛhɩ, Pilatɩ nwan: “Ɛ 'nwun nzalafʋ, Ɛmɔ fá bɛ́ hɔ́, maan bɛ hɔ́ sísa yɩ́ kɛ mɔ ɛmɔ kulo ɔ.” ");
INSERT INTO any_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Bɛ nʋn bɛ́ kɔ hɔ, bɛ kɔ nwun kɛ sɛka nɩn anʋan'n nyin kanlanman kpa. Bɛ kɔ sie sʋ nzɔlɛ, bɛ kɔ yaci nzalafʋ'n-mɔ ɛbɛlɛ kɛ bɛ sísa yɩ́. ");
INSERT INTO any_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Mɔ *ɛnwʋnmɩan ele cɩan'n sɩnlɩn'n, mɔlɛ'n ngɛlɛmɔ, Mali m'ɔ fi Magɩdala'n, ɔ nʋn Mali kʋn'n kɔ a kɔ nɩan sɛka'n. ");
INSERT INTO any_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Kʋnmgba ala, asɩɛ'n kɔ kpusu sɛlɛ kpa. Yɛ́ Mɩn bɔfʋɛ'n kʋn fi anwunno ɔ kɔ ju. Ɔ kɔ kunndo ɛbʋɛ'n m'ɔ nyin sɛka nɩn anʋan'n ɔ kɔ tʋ yɩ́ ahanmɩan ɔ kɔ fʋ ɔ kɔ tanlan sʋ. ");
INSERT INTO any_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Bɔfʋɛ nɩn anwʋn'n ta sʋa mɩaɩn mɩaɩn kɛ nyanmɩan'n m'ɔ kpɛ mɩaɩn mɩaɩn'n. Yɩ́ taladɩɛ'n tɩ fufue hyɩɛɩn hyɩɛɩn kpa. ");
INSERT INTO any_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Esulo kɔ han nzalafʋ'n-mɔ kpa dede bɛ́ nwʋn kɔ wʋsʋ bɛ́, bɛ gugua kɛ menian mɔ b'a wu ɔ. ");
INSERT INTO any_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Bɔfʋɛ'n kɔ han kɔ hele mmalasua'n-mɔ kɛ: “Nán bɛ sulo. Afɩ mɩn sɩ kɛ ɛmɔ lɛ kpʋnndɛ Zozi, sʋanlan'n mɔ bɛ bʋbɔlɩ yɩ́ kʋlʋwa nɩn asʋ'n. ");
INSERT INTO any_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Ɔ nnʋn man ɛwa. Ɔ fi ewue nun ɔ'a tinnge kɛ ɔ kpɩnlɩn hanlɩn yɩ́'n. Ɛmɔ bála bɛ nɩ́an lɩka mɔ anɩn ɔ la'n. ");
INSERT INTO any_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Ɛmɔ hɔ́ ndɛ-ndɛ bɛ hán héle yɩ́ menian'n-mɔ kɛ ɔ fi ewue nun ɔ'a tinnge. Sian dɩɛ, ɔ lɛ kɔ a nwʋnndɛ ɛmɔ Galile mân nɩn anun. Ɛlɔ yɛ̂ ɛmɔ 'nwun yɩ́ ɔ. Ngalɩɛ'n mɔ mɩ́n nwan mɩn 'kan mɩn kele ɛmɔ nɩn anɩn.” ");
INSERT INTO any_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Mɔ mmalasua'n-mɔ fi sɛka nɩn asʋ bɛ 'kɔ'n, esulo nʋn fɛ elie kpili kpa hanlɩn bɛ́. Bɛ le ɛnwanndie bɛ lɛ kɔ a han bɛ kele Zozi menian'n-mɔ. ");
INSERT INTO any_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Kʋnmgba ala, bɛ nʋn Zozi kɔ yia nun. Zozi nwan: “M mo ahɩn, m mo ahɩn o!” Mɔ Zozi bisalɩ bɛ́ ahɩn yuelɩ'n, bɛ kɔ kpunnge yɩ́ bɛ kɔ sɔ yɩ́ ja nɩn anun, bɛ kɔ kʋtʋ yɩ́ nyunnun ɛbɛlɛ bɛ kɔ sʋ yɩ́. ");
INSERT INTO any_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Ɛhɩ, Zozi kɔ se bɛ́ kɛ: “Nán bɛ sulo. Ɛmɔ hɔ́ hán héle mɩ́n nianman'n-mɔ kɛ bɛ hɔ́ Galile mân nɩn anun ɛlɔ. Ɛbɛlɛ yɛ̂ bɛ 'nwun mɩ́n ɔ.” ");
INSERT INTO any_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Mɔ anɩn mmalasua'n-mɔ aja wɔ atunnun'n, nzalafʋ'n-mɔ mɔ bɛ lɛ sisa sɛka'n, mmie-mɔ kɔ sa kɔ hɔ kulo. Bɛ kɔ hɔ kɔ bɔ ɛjɔlɛ'n m'ɔ walɩ nɩn anun amannɩɛ bɛ kɔ hele Nyanmɩan *tɛɛyɩfʋɛ mgbain'n-mɔ. ");
INSERT INTO any_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Nyanmɩan tɛɛyɩfʋɛ mgbain'n-mɔ nʋn Zufʋ mgbain'n-mɔ kɔ yia. Mɔ bɛ́ nʋan sɛlɩ bɛ́ nwʋn yuelɩ'n, bɛ kɔ man nzalafʋ'n-mɔ esika dɔʋn kpa. ");
INSERT INTO any_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Ɛsɛ bɛ́ nwan: “Sɛ bɛ bisa ɛmɔ a, ɛmɔ hán kɛ kɔngɔɛ mɔ ɛmɔ 'dafɩ'n, yɩ́ menian'n-mɔ a a a sa yɩ́ a hɔ. ");
INSERT INTO any_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Sɛ kʋnmanna'n tɩ a, yɛ 'tʋ yɩ́ akɔbɛ nán ɛmɔ ati a nga man nun.” ");
INSERT INTO any_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Nzalafʋ'n-mɔ lelɩ esika'n, bɛ hanlɩn yɩ́ kɛ Nyanmɩan tɛɛyɩfʋɛ mgbain'n-mɔ hanlɩn helelɩ bɛ́ nɩn ala. Ɛnɛ nʋn ɛnɛ, Zufʋ'n-mɔ tɛ kan ɛjɔlɛ sɔ'n. ");
INSERT INTO any_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Ɛhɩ, Zozi menian bulu nʋn kʋn'n hɔlɩ Galile mân nɩn anun ɛlɔ bʋka'n mɔ Zozi helelɩ bɛ́ nɩn asʋ. ");
INSERT INTO any_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Mɔ bɛ nwunlin yɩ́'n, bɛ kʋtʋlɩ bɛ sʋlɩ yɩ́. Nan kʋsʋ bɛ́ mmie-mɔ a nne a nni man. ");
INSERT INTO any_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Zozi kɔ kpunnge bɛ́, ɔ kɔ han kɔ hele bɛ kɛ: “B'a fa anwunno ɛlɔ nʋn asɩ ɛwa tunmin'n kʋalaa b'a wula mɩ́n sa nun. ");
INSERT INTO any_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Ɛhɩka ati, ɛmɔ hɔ́ mân nɩn anun menian'n-mɔ kʋalaa anwʋn, ɛmɔ mán bɛ káci mɩ́n menian. Ɛmɔ sɔ́nɩn bɛ́ wɔ Sɩɛ nʋn Baa, ɔ nʋn Wawɛ Nwannzan-nwannzan'n dunman nun. ");
INSERT INTO any_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Ninnge'n kʋalaa mɔ m'an han m'an hele ɛmɔ'n, ɛmɔ héhele bɛ́ maan bɛ yɔ́. Ɛsɛ ɛmɔ nwún yɩ́ kɛ mɩn nʋn ɛmɔ san alɩhɩan biala dede ɔ kɔ ju mân nɩn ayuelɩɛ.”");
INSERT INTO any_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Ɛjɔlɛkpa'n m'ɔ tʋ de Zozi Kilisi m'ɔ tɩ Nyanmɩan Awa'n y'ɔ le ɛhɩ. ");
INSERT INTO any_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Ɛjɔlɛ sɔ'n bɔlɩ yɩ́ bʋ kɛ Nyanmɩan Kpɔmanfʋɛ Ezayi hɛlɛlɩ wɔ yɩ́ kalata nɩn anun'n. Ɔ'a hɛlɛ Zozi anwʋn ɛjɔlɛ'n kɛ Nyanmɩan nwan: Nɩan, mɩn 'sʋan mɩ́n bɔfʋɛ'n wɔ́ nyunnun mɩn 'man ɔ di mʋa ɔ sesie wɔ́ atɩn'n. ");
INSERT INTO any_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Bɔfʋɛ sɔ'n y'ɔ le sʋanlan'n m'ɔ lɛ tɩan ɛwâ nɩn anun ɛlɔ kɛ: Bɛ sésie yɛ́ Mɩn atɩn'n bɛ mán ɔ tɩ́nngɛ fɔ́ʋ́n! ");
INSERT INTO any_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Ɛhɩ, cɩan kʋn, Zʋan kɔ fite ɛwâ nɩn anun ɛlɔ. Ɔ sɔnɩn menian'n-mɔ. Ɔ tu bɛ́ fʋɔ kɛ: “Ɛmɔ nún bɛ́ nwʋn bɛ káci bɛ́ abalabɔ'n bɛ fá bɛ́ nwʋn bɛ mán Nyanmɩan maan n zɔ́nɩn ɛmɔ, nán Nyanmɩan a fa ɛmɔ ɛtɛ nɩn a hye bɛ́.” ");
INSERT INTO any_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Mɔ Zʋan hanlɩn sɔ mɔ menian'n-mɔ tɩlɩ yɩ́ ngan'n, Zude mân nɩn anun menian'n-mɔ nʋn Zoluzalɛmʋn kulo nɩn asʋ dɩɛ'n-mɔ, bɛ́ dɔʋn, bɛ kɔ hɔ yɩ́ nwʋn ɛlɔ. Bɛ kɔ han bɛ́ ɛtɛ'n bagua nɩn anun, nán Zʋan a sɔnɩn bɛ́ wɔ asue'n mɔ bɛ fɛlɛ yɩ́ Zuludɩn nɩn anun. ");
INSERT INTO any_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Taladɩɛ'n mɔ Zʋan wula'n, sʋamo enyuan yɛ̂ b'a fa b'a nwʋn ɔ. Yɩ́ bɛlɛtɩ'n tɩ naan kpolo. Alɩɛ'n m'ɔ di'n, y'ɔ le tɛtɛbʋabʋa nʋn wɛ. ");
INSERT INTO any_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Ɛ 'nwun ɛjɔlɛ'n m'ɔ kan kele menian'n-mɔ'n. Yɩ́ nwan: “Sʋanlan kʋn fi mɩ́n nzin ɔ lɛ ba, ɔ le tunmin tala mɩ́n, mɩn nzɛ nvata man kɛ mɩn kʋtʋ mɩn nyannjɩ yɩ́ ja mgbabʋa'n nyanman'n bɔbɔ mgban ɔ. ");
INSERT INTO any_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Mɩ́n dɩɛ, m'an fa nzue m'an sɔnɩn ɛmɔ, nan yɩ́ dɩɛ, ɔ 'ba fa Nyanmɩan Wawɛ'n sɔnɩn ɛmɔ.” ");
INSERT INTO any_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Mɛlɛ sɔ nɩn anun, Zozi fi Nazalɛtɩ, Galile mân nɩn anun, ɔ kɔ a kɔ tʋ Zʋan maan ɔ kɔ sɔnɩn yɩ́ asue Zuludɩn nɩn anun. ");
INSERT INTO any_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Mɔ Zozi fi asue nɩn anun ɔ 'fite'n, ɔ 'nɩan an, anɩn anwunno nɩn a buke, Wawɛ Nwannzan-nwannzan'n tɩ kɛ abubule, ɔ fi nyanmɩansʋ ɔ kɔ ju kɔ tanlan yɩ́ sʋ. ");
INSERT INTO any_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Ɛbɛlɛ ala, anɩɛ kʋn kɔ te anwunno ɛlɔ kɛ: “Ɛ tɩ mɩ́n ehulo Baa, m'an fa mɩ́n lʋa'n kʋalaa m'an wula wɔ́ nun.” ");
INSERT INTO any_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Ɛbɛlɛ ala, Wawɛ'n Nwannzan-nwannzan'n kɔ hyʋɩn Zozi kɔ hɔ ɛwâ nɩn anun ɛlɔ. ");
INSERT INTO any_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Ɔ lili ɛlɛbulanan. Ɛbɛlɛ, *Satan (mɔ yɛ fɛlɛ yɩ́ Abɔnsanmʋn'n), ɔ kɔ a kɔ sɔ yɩ́ kɔ nɩan. Anɩn Zozi wɔ ebolo naan'n-mɔ afian yɛ̂ nyanmɩansʋ mmɔfʋɛ'n-mɔ yɛ̂ bɛ bʋka yɩ́ ɔ. ");
INSERT INTO any_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Ɛhɩ mɔ bɛ hyɩlɩ Zʋan bɛ tʋlɩ yɩ́ fiadɩ'n, Zozi kɔ sa kɔ hɔ Galile mân nɩn anun ɔ 'kɔ a bɔ Nyanmɩan Ɛjɔlɛkpa'n kele bɛ́ mɔ bɛ wɔ ɛlɔ'n. ");
INSERT INTO any_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","M'ɔ juli ɛlɔ'n yɩ́ nwan: “Tɛmʋn nɩn a ju, ɔ sanlɩn kɛ Nyanmɩan Belemgbin elie mɛlɛ nɩn a kpunnge. Ɛmɔ lé Ɛjɔlɛkpa'n bɛ li nán ɛmɔ káci bɛ́ abalabɔ'n!” ");
INSERT INTO any_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Mɔ Zozi 'sɩn Galile asubula nɩn anʋan ɛbɛlɛ'n, ɔ 'nɩan an, anɩn anianman nnyuan lɛ gua bɛ́ dada. Kʋn li Simʋn yɛ̂ kʋn'n kʋsʋ li Andele. ");
INSERT INTO any_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Zozi kɔ han kɔ hele bɛ́ kɛ: “Ɛmɔ bála, bɛ sí mɩ́n sʋ, nán mɩn 'ba man ɛmɔ fɛlɛ menian bɛ man mɩ́n.” ");
INSERT INTO any_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Kɛ Zozi anʋan 'tɔ ala, bɛ kɔ yaci bɛ́ dada'n-mɔ ɛbɛlɛ, bɛ kɔ si yɩ́ sʋ. ");
INSERT INTO any_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Zozi fi ɛbɛlɛ, ɔ kɔ hɔ yɩ́ nyunnun kaan, ɔ kɔ nwun Zebede amma'n-mɔ: Zʋakɩ nʋn yɩ́ nianman Zʋan. Bɛ gua bɛ́ ɛlɛɛ nɩn anun, bɛ lɛ kpʋnmgba bɛ́ dada'n-mɔ anun. ");
INSERT INTO any_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Ɛbɛlɛ ala, Zozi kɔ fɛlɛ bɛ́. Bɛ kɔ yaci bɛ́ sɩ Zebede ɔ nʋn kpafʋ'n-mɔ ɛlɛɛ nɩn anun ɛbɛlɛ, bɛ kɔ si yɩ́ sʋ. ");
INSERT INTO any_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Bɛ fi ɛbɛlɛ, Zozi nʋn bɛ́ kɔ hɔ kulo'n mɔ bɛ fɛlɛ yɩ́ Kapɛɛnawɔmʋn nɩn asʋ. Bɛ wɔ ɛbɛlɛ dede mɔ ɛnwʋnmɩan ele cɩan'n juli'n, ɔ nʋn bɛ́ kɔ hɔ Zufʋ'n-mɔ asɔnɩn sua nɩn anun. Ɔ kɔ hehele bagua'n Nyanmɩan Anʋan Ɛjɔlɛ. ");
INSERT INTO any_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Tunmin'n m'ɔ fa kekele ninnge'n-mɔ'n sin menian'n-mɔ anwʋn. Ɔ sanlɩn kɛ ɔ ngele man yɩ́ ninnge'n-mɔ kɛ mala nɩn asʋ mgbain'n-mɔ dɩɛ'n, nan ɔ kele yɩ́ ninnge'n-mɔ tunmin sʋ. ");
INSERT INTO any_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Ɔ 'ba yɔ sɔ'n kʋsʋ, anɩn sʋanlan kʋn wɔ bɛ́ asɔnɩn sua nɩn anun ɛbɛlɛ. Sʋanlan sɔ'n, wawɛ ɛtɛ wɔ yɩ́ nun. Ɔ kɔ tɩan nun kɛ: ");
INSERT INTO any_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Zozi m'ɔ fi Nazalɛtɩ, ɛ 'se yɛ́ sɛ? Ɛ walɩ yɛ́ bʋsʋ ɛbɔ anaan? Mɩn sɩ wɔ́ bɔkɔɔ! Ɛ tɩ Nyanmɩan Sʋanlan Nwannzan-nwannzan!” ");
INSERT INTO any_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Mɔ sʋanlan'n hanlɩn sɔ'n, Zozi kɔ tɩan wawɛ ɛtɛ nɩn asʋ sɛlɛ kpa. Yɩ́ nwan: “Muan wɔ́ nʋan'n nán fi sʋanlan ɛhɩ anun fite!” ");
INSERT INTO any_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Kɛ Zozi 'kan sɔ ala, wawɛ ɛtɛ'n kɔ kpusu sʋanlan'n sɛlɛ sɛlɛ kpa, ɔ kɔ tɩan, ɔ fi yɩ́ nun kɔ fite. ");
INSERT INTO any_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Sian'n, kɛ ɔ yɔlɩ sɔ'n, esulo kɔ han bɛ́ mɔ bɛ wɔ asɔnɩn sua nɩn anun'n kʋalaatin. Bɛ lɛ bisa bisa bɛ́ nwʋn kɛ: “Nan nzu like dɩɛ ahɩ? Tunmin sʋ like ehele fʋfɔlɛ ɔ! M'ɔ kɔ han'n, wawɛ ɛtɛ'n-mɔ di sʋ, ɛsɛ bɛ man yɩ́ anyɩnnzɔ.” ");
INSERT INTO any_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Ɔ fi ɛbɛlɛ, Zozi dunman'n kɔ hɔ dede kɔ ju Galile mân'n lɩka kʋalaatin. ");
INSERT INTO any_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Mɔ Bɛ fi Nyanmɩan sua nɩn anun bɛ fitelɩ'n, ɛbɛlɛ ala, bɛ kɔ hɔ Simʋn nʋn Andele awulo. Mɔ bɛ 'kɔ'n, bɛ nʋn Zʋakɩ nʋn Zʋan yɛ̂ bɛ hɔlɩ ɔ. ");
INSERT INTO any_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Bɛ 'ju ɛbɛlɛ a, anɩn Simʋn asebala nɩn a fʋkɛ, ebunnun a hyɩ yɩ́, ɔ la. Ɛbɛlɛ ala, bɛ kɔ bɔ Zozi amannɩɛ. ");
INSERT INTO any_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Zozi kɔ hyʋɩn kɔ kpunnge yɩ́, ɔ kɔ sɔ yɩ́ sa nɩn anun ɔ kɔ jasʋ yɩ́. Ɛbɛlɛ ala, ebunnun'n fi yɩ́ nwʋn kɔ tu. Ɔ kɔ jasʋ, ɔ kɔ man bɛ́ like bɛ kɔ li. ");
INSERT INTO any_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Bɛ wɔ ɛbɛlɛ dede eyua'n tɔlɩ, mɔ mân nɩn anun 'yɔ fɔʋn'n, menian'n-mɔ kɔ sʋa nwuluwafʋɛ ngacile, nʋn bɛ́ mɔ wawɛ ɛtɛ wɔ bɛ́ nun'n, bɛ kɔ bɛlɛ Zozi. ");
INSERT INTO any_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Kulo nɩn asʋ menian'n-mɔ kʋalaa kɔ yia awulo nɩn anʋan nɩn anun. ");
INSERT INTO any_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Zozi kɔ man nwuluwafʋɛ dɔʋn anwʋn kɔ sa, ɛsɛ ɔ kɔ fʋan wawɛ ɛtɛ dɔʋn. Ɔ ngɔ man man wawɛ ɛtɛ'n bie fɩ́ɩ́ atɩn, ɔ sanlɩn kɛ wawɛ ɛtɛ'n-mɔ sɩ yɩ́ sʋanlan ɛhɔlɛ kʋn'n. ");
INSERT INTO any_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Ɛhɩ anzin, mɔ alɩ́ɛ'n 'kɔ alɩbahɩan'n, anɩn mân nɩn anun tɛ du bɔbɔ, Zozi kɔ jasʋ. Ɔ fi awulo ɛbɛlɛ kɔ fite kɔ hɔ asɔnɩn ɛyɔlɛ ahanmɩan kulo'n tiba ɛlɔ. ");
INSERT INTO any_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Mɔ Simʋn nʋn yɩ́ manngʋn'n-mɔ jasʋlɩ'n, bɛ nnwun man Zozi. Bɛ nanndɩ kulo nɩn anun bɛ lɛ kpʋnndɛ yɩ́. ");
INSERT INTO any_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Bɛ kpʋnndɛlɩ yɩ́ dede mɔ bɛ nwunlin yɩ́'n, bɛ́ nwan: “Yɛ́ Mɩn, menian'n-mɔ kʋalaa lɛ kpʋnndɛ wɔ́.” ");
INSERT INTO any_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Zozi kukuli yɩ́ nʋan sʋ a, yɩ́ nwan: “Ɛmɔ mán yɛ hɔ́ kulo'n-mɔ mɔ bɛ mantan mantan ɛwa'n-mɔ asʋ. Ɔ fata kɛ mɩn kan Nyanmɩan Anʋan Ɛjɔlɛ ɛlɔhan kʋsʋ. Ɛhɩ ati yɛ̂ ɔ man n vi kulo nɩn anun m'an fite ɔ.” ");
INSERT INTO any_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Zozi le yɩ́ sɔ dede ɔ kɔ kpanza Galile mân'n lɩka kʋalaatin. Ɔ kɔ hɔ kɔ bɔ Ɛjɔlɛkpa'n kɔ hele menian'n-mɔ wɔ Zufʋ'n-mɔ asɔnɩn sua'n-mɔ anun. Ɛsɛ ɔ kɔ fʋan wawɛ ɛtɛ'n-mɔ. ");
INSERT INTO any_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Ɛlɛhʋn kʋn, kokobefʋɛ kʋn kɔ a kɔ tʋ Zozi ɔ kɔ tu kɔ tɔ yɩ́ ja nun. Ɔ kɔ bʋtʋ yɩ́. Yɩ́ nwan: “Mɩ́n mɩn, mɩn sɩ kɛ sɛ ɛ kulo a, ɛ kʋala kɛ ɛ man mɩ́n nwʋn sa, ɛ tu mɩ́n nwʋn efian'n.” ");
INSERT INTO any_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Mɔ Zozi nwunlin yɩ́ sɔ'n, kokobefʋɛ nɩn anwʋn kɔ yɔ yɩ́ koun. Ɛbɛlɛ ala, ɔ kɔ tɩnngɛ yɩ́ sa kɔ han kokobefʋɛ'n, yɩ́ nwan: “Mɩn kulo, man wɔ́ nwʋn tɩ́!” ");
INSERT INTO any_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Mɔ Zozi hanlɩn sɔ nɩn ala, kokobe'n fi yɩ́ nwʋn kɔ tu, yɩ́ nwʋn kɔ tɩ. ");
INSERT INTO any_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Mɔ bian nɩn anwʋn salɩ yuelɩ'n, Zozi kɔ jʋjɔ aminle sʋ kɔ hele yɩ́ asannan nán ɔ'a man ɔ'a hɔ. ");
INSERT INTO any_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","Zozi nwan: “Mɔ a nwun yɩ́ ɛwa'n, n'ɛ kan nun ɛjɔlɛ fɩ́ɩ́ kele sʋanlan. Nan kɔ fa wɔ́ nwʋn kele Nyanmɩan tɛɛyɩfʋɛ'n nán yɩ wɔ́ nwʋn efian etue tɛɛ'n mɔ Moyizɩ mala'n kele'n maan bɛ nwún yɩ́ kɛ wɔ́ nwʋn a tɩ.” ");
INSERT INTO any_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Nan mɔ bian'n hɔlɩ'n, ɔ'a ngʋala man ɛjɔlɛ nɩn asʋ fɩa. Ɔ kɔ bɔ yɩ́ kpayɛ kɔ hele mân'n kʋalaa. Sian'n, kɛ ɔ yɔlɩ sɔ'n, Zozi kɔ kulo'n-mɔ asʋ a, meninsʋnman'n dunman nun, ɔ ka ahanmɩan, lɩka mɔ sʋanlan nnʋn man'n, ɛbɛlɛ yɛ̂ menian'n-mɔ fi lɩka kʋalaa bɛ ba yɩ́ nwʋn ɔ. ");
INSERT INTO any_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Ɛhɩ, ɛlɛ nnyuan kʋn sɩnlɩn, Zozi kɔ sa kɔ a Kapɛɛnawɔmʋn. M'ɔ walɩ juli ɛbɛlɛ'n, menian'n-mɔ kɔ tɩ kɛ ɔ wɔ yɩ́ awulo ɛbɛlɛ. ");
INSERT INTO any_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Menian dɔʋn kpa kɔ a kɔ yi sua'n nʋn anʋan nɩn anun dede bɛ nnwun man lɩka fɩ́ɩ́ mɔ bɛ sie bɛ́ nwʋn ɔ. Zozi kɔ han Nyanmɩan Anʋan Ɛjɔlɛ'n kɔ hele bɛ́. ");
INSERT INTO any_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Mɔ Zozi 'kan Nyanmɩan Anʋan Ɛjɔlɛ'n, menian mmie-mɔ kɔ a kɔ ju ɛbɛlɛ. Bɛ́ nunhan nnan sʋ bubuluwafʋɛ kʋn, bɛ lɛ fa yɩ́ bɛ bɛlɛ Zozi. ");
INSERT INTO any_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Eyia kpili mɔ menian'n-mɔ a yia nɩn ati, bɛ ngʋala man wuluwafʋɛ'n fa fite Zozi anyunnun. Ɛhɩ a, bɛ kɔ fʋ sua'n mɔ Zozi wɔ nun nɩn asʋ, bɛ kɔ kpɛ nun tokolo. Bɛ kɔ fa bubuluwafʋɛ'n nʋn yɩ́ ɛbɛɛ'n bɛ kɔ wula tokolo sɔ nɩn anun bɛ kɔ jula yɩ́ Zozi anyunnun ɛbɛlɛ asɩ. ");
INSERT INTO any_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Mɔ Zozi nwunlin bɛ́ dedi'n, ɔ kɔ han kɔ hele bubuluwafʋɛ'n kɛ: “Mɩ́n wa, b'a fa wɔ́ ɛtɛ'n b'a hye wɔ́.” ");
INSERT INTO any_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Mɔ Zozi 'kan ɛjɔlɛ'n kele wuluwafʋɛ'n, anɩn mala nɩn asʋ mgbain'n mmie-mɔ tɩtɩ asɩ bagua nɩn anun ɛbɛlɛ. Mgbain sɔ'n-mɔ kɔ han yɩ́ bɛ́ ti anun kɛ: ");
INSERT INTO any_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Nzukɛ ati yɛ̂ sʋanlan ɛhɩ kan ɛjɔlɛ ɛtɛ sʋa tia Nyanmɩan ɔ? Sɛ nán Nyanmɩan angʋnmɩn cein an, nwan yɛ̂ ɔ kʋala ɔ fa ɛtɛ ce ɔ?” ");
INSERT INTO any_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Ɛbɛlɛ ala, Zozi kɔ nwun bɛ́ ajʋnlɩn'n. Yɩ́ nwan: “Nzukɛ ati yɛ̂ ɛmɔ le ajʋnlɩn sʋa-mɔ ɛmɔ ati anun ɔ? Ɛmɔ jʋnlɩn kɛ mɩn ngʋala man yɩ́ yɔ ɔ? ");
INSERT INTO any_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Sɛ mɩn kan kɛ: ‘B'a fa wɔ́ ɛtɛ'n b'a hye wɔ́,’ ɛmɔ nnwun man nun. Nan sɛ mɩn kan kɛ: ‘Jasʋ fa wɔ́ ɛbɛɛ'n nanndɩ,’ nán ɔ yɔ sɔ a, ");
INSERT INTO any_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","anɩn ɛmɔ a nwun yɩ́ kɛ Mân Baa'n le tunmin asɩɛ nɩn asʋ ɛwa ɔ fa ɛtɛ'n-mɔ ce.” Ɔ kacili yɩ́ nʋan bubuluwafʋɛ nɩn anwʋn ɛlɔ a, yɩ́ nwan: ");
INSERT INTO any_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“M'an man wɔ́ atɩn, jasʋ, fa wɔ́ ɛbɛɛ'n kɔ awulo.” ");
INSERT INTO any_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Ɛbɛlɛ ala, bian'n kɔ jasʋ bɛ́ kʋalaa bɛ́ nyunnun ɛbɛlɛ. Ɔ kɔ fa yɩ́ ɛbɛɛ'n ɔ kɔ fite. Ɛjɔlɛ'n kɔ sin bɛ́ kʋalaa bɛ́ nwʋn kpa. Bɛ kɔ kannvʋ Nyanmɩan. Bɛ́ nwan: “Yɛ nwunlin man like sʋa bie lé!” ");
INSERT INTO any_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Ɛhɩ anzin, Zozi kɔ sa kɔ hɔ Galile asubula nɩn anʋan ɛlɔ biekun. Menian dɔʋn kɔ kpʋ yɩ́, ɔ kɔ hehele bɛ́ ninnge. ");
INSERT INTO any_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Tɛmʋn mɔ Zozi 'sa kɔ awulo'n, ɔ 'ba ju lɩka mɔ bɛ tua ajule nɩn an, Levi m'ɔ tɩ Alɩfe awa'n tɩ ɛbɛlɛ. Ɔ lɛ dide ajule. Zozi kɔ jinlan, yɩ́ nwan: “Levi, si mɩ́n sʋ!” Ɛbɛlɛ ala, Levi kɔ jasʋ kɔ si yɩ́ sʋ. ");
INSERT INTO any_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Ɛhɩ anzin, cɩan kʋn Zozi kɔ hɔ like elie Levi awulo ɛlɔ. Mɔ ɔ 'kɔ'n, ɔ nʋn yɩ́ menian'n-mɔ nʋn menian dɔʋn mɔ bɛ dide ajule'n nʋn ɛtɛfʋɛ'n-mɔ yɛ̂ bɛ hɔlɩ ɔ. Afɩ bɛ́ mɔ bɛ si Zozi sʋ'n, bɛ sʋnlɩn. ");
INSERT INTO any_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Mɔ mala nɩn asʋ mgbain'n-mɔ mɔ bɛ wɔ Falisifʋɛ'n-mɔ fâ dɩɛ nɩn anun'n nwunlin kɛ Zozi nʋn menian ɛhɩ-mɔ kʋalaa lɛ didi'n, bɛ kɔ bisa Zozi menian'n-mɔ kɛ: “Nzukɛ ati yɛ̂ Zozi nʋn bɛ́ mɔ bɛ dide ajule'n nʋn ɛtɛfʋɛ'n-mɔ lɛ didi'n?” ");
INSERT INTO any_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Mɔ Zozi tɩlɩ ɛjɔlɛ'n mɔ bɛ lɛ kan'n, yɩ́ nwan: “Bɛ́ mɔ bɛ fʋkɛlɩ man'n, bɛ mgbʋnndɛ man ayile ɛyɔlɛfʋɛ. Nan bɛ́ mɔ b'a fʋkɛ'n yɛ̂ bɛ kpʋnndɛ ayile ɛyɔlɛfʋɛ ɔ. M'an mma man kɛ m 'ba kpʋnndɛ sɛsɛfʋɛ'n-mɔ. Nan m malɩ kɛ m 'ba kpʋnndɛ ɛtɛfʋɛ'n-mɔ.” ");
INSERT INTO any_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Cɩan kʋn, anɩn Zʋan Batisi menian'n-mɔ nʋn Falisifʋɛ'n-mɔ bɛ lɛ di abuala. Menian mmie-mɔ walɩ tʋlɩ Zozi a, bɛ kɔ bisa yɩ́ kɛ: “Nzukɛ ati yɛ̂ Zʋan menian'n-mɔ nʋn Falisifʋɛ'n-mɔ dɩɛ'n-mɔ lɛ di abuala, nan kʋsʋ wɔ́ dɩɛ'n-mɔ nni man bie ɔ?” ");
INSERT INTO any_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Ɛhɩ a, Zozi kɔ bua bɛ́ kɛ: “Ɛmɔ a nwun sʋanlan kʋn m'ɔ lɛ fa atɔnvɔlɛ m'ɔ nʋn yɩ́ manngʋn'n-mɔ b'a bua b'a la lé ɔ? Cɛcɛ, mɛlɛ mɔ atɔnvɔlɛ bian'n lɛ didi'n, yɩ́ manngʋn'n-mɔ ngʋala man kɛ bɛ bua bɛ da ɔ. ");
INSERT INTO any_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Mɛlɛ'n bie 'ba ju, bɛ 'ba yɩ atɔnvɔlɛ bian'n fi bɛ́ sa nun. Cɩan sɔ'n yɛ̂ bɛ́ kʋsʋ bɛ 'ba li abuala ɔ. ");
INSERT INTO any_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Sʋanlan fɩ́ɩ́ nva man ndafuin fʋfɔlɛ ɔ nda man ɛtanlan daba nun. Sɛ ɔ yɔ yɩ́ sɔ a, ndafuin fʋfɔlɛ'n 'sua ɛtanlan daba'n. Sian'n, yɩ́ bɔɛ'n 'yɔ kpili tala daba dɩɛ'n. ");
INSERT INTO any_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Sʋanlan fɩ́ɩ́ nva man divɩn fʋfɔlɛ ɔ ngua man naan kpolo kotoku daba nun. Sɛ ɔ yɔ yɩ́ sɔ a, kpolo'n 'sua nzan'n butu, anɩn yɩ́ munnyuan nɩn a sɛcɩ. Nan kpolo kotoku fʋfɔlɛ anun yɛ̂ bɛ gua divɩn fʋfɔlɛ ɔ.” ");
INSERT INTO any_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Ɛhɩ anzin, cɩan kʋn, *ɛnwʋnmɩan ele cɩan nɩn anun, Zozi kɔ kpɛ nun *bele ebo mmie-mɔ asʋ. Cɩan sɔ'n, yɩ́ menian'n-mɔ kɔ tɩtɩ atɩn nɩn anʋan bele'n bie kɔ li. ");
INSERT INTO any_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Ɛhɩ a, Falisifʋɛ'n-mɔ kɔ bisa Zozi kɛ: “Nɩan, nzukɛ ati yɛ̂ wɔ́ menian'n-mɔ yɔ like mɔ mala'n tua kɛ nán bɛ yɔ yɩ́ ɛnwʋnmɩan ele cɩan nɩn ɔ?” ");
INSERT INTO any_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Ɛhɩ a, Zozi kɔ bua bɛ́ kɛ: “Mɔ ɛhɔɛ hunlin Davidi nʋn yɩ́ menian'n-mɔ, mɔ anɩn bɛ le man like fɩ́ɩ́ bɛ nni man'n, like mɔ bɛ yɔlɩ'n, ɛmɔ kɩnngalɩ man yɩ́ le ɔ? ");
INSERT INTO any_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Tɛɛyɩfʋɛ kpain Abiataa mɛlɛ sʋ, ɔ'a nwʋlʋ man Nyanmɩan sua nɩn anun, kpaʋn'n mɔ b'a fa b'a man Nyanmɩan'n, ɔ a nni man bie, ɔ'a nva bie ɔ'a man yɩ́ menian'n-mɔ b'a nni man ɔ? Nan kʋsʋ kpaʋn sɔ'n, sʋanlan fɩ́ɩ́ le man atɩn kɛ ɔ di ɔ, sannan Nyanmɩan tɛɛyɩfʋɛ'n-mɔ ala yɛ̂ bɛ kʋala kɛ bɛ di ɔ.” ");
INSERT INTO any_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Zozi kɔ tʋ sʋ biekun kɛ: “Bɛ yɔlɩ ɛnwʋnmɩan ele cɩan'n bɛ manlɩn sʋanlan, nan b'a nyɔ man sʋanlan b'a mman man ɛnwʋnmɩan ele cɩan'n. ");
INSERT INTO any_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Yɩ́ sɔ ati, Mân Baa'n tɩ ɛnwʋnmɩan ele cɩan'n muonun asʋ mɩnlɩan.” ");
INSERT INTO any_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Mɔ Zozi hanlɩn sɔ yuelɩ'n, ɔ fi ɛbɛlɛ ɔ kɔ sa kɔ hɔ Zufʋ'n-mɔ asɔnɩn sua nɩn anun biekun. Ɔ 'ba yɔ sɔ'n kʋsʋ, anɩn sʋanlan kʋn wɔ asɔnɩn sua nɩn anun ɛbɛlɛ. Sʋanlan sɔ nɩn asa kʋn a jɔ. ");
INSERT INTO any_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Mɔ Zozi 'wʋlʋ asɔnɩn sua nɩn anun'n, anɩn Falisifʋɛ'n-mɔ wɔ ɛbɛlɛ. Bɛ gua ɛbɛlɛ bɛ lɛ nɩan sɛ Zozi kɔ man wuluwafʋɛ nɩn anwʋn kɔ sa ɛnwʋnmɩan ele cɩan nɩn an. Afɩ bɛ kulo kɛ bɛ tʋn yɩ́ ɛsʋan. ");
INSERT INTO any_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Mɔ Zozi nwunlin yɩ́ sɔ'n, ɔ kɔ han kɔ hele wuluwafʋɛ'n kɛ: “Njabian, jasʋ jinlan bɛ́ kʋalaa bɛ́ nyunnun ɛwa maan bɛ nwún wɔ́.” ");
INSERT INTO any_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Mɔ Zozi hanlɩn sɔ'n, bian'n kɔ jasʋ kɔ jinlan. Zozi kɔ bisa bɛ́ mɔ bɛ gua sua nɩn anun'n kɛ: “Asʋ yɛ́ mala'n man atɩn kɛ ɛnwʋnmɩan ele cɩan'n, bɛ yɔ́ sʋanlan ye anaan bɛ yɔ́ yɩ́ ɛtɛ? Bɛ lé sʋanlan ngʋan anaan bɛ hún yɩ́?” Zozi bisalɩ kosuan ɛhɩ a, bɛ ngɔ bua man yɩ́ bie. ");
INSERT INTO any_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Bɛ́ ti anun ɛtɛ'n nʋn bɛ nyɔlɩɛ sɔ nɩn anwʋn, ɛya kɔ hun Zozi ɛsɛ yɩ́ lʋa kɔ bɔ yɩ́ nwʋn. Ɛhɩ a, ɔ kɔ nɩan bɛ́ kʋalaa kɔ si kɔ yia. Ɔ kɔ han kɔ hele wuluwafʋɛ'n kɛ: “Tɩnngɛ wɔ́ sa nɩn anun.” Ɔ 'tɩnngɛ yɩ́ sa nɩn anun an, asaa kɔ yɔ kpa. ");
INSERT INTO any_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","M'ɔ yɔlɩ sɔ'n, Falisifʋɛ'n-mɔ fi asɔnɩn sua nɩn anun bɛ kɔ fite. Ɛbɛlɛ ala, bɛ kɔ hɔ bɛ kɔ nwun belemgbin Elɔdɩ asasʋ'n-mɔ anwʋn. Bɛ lɛ kpʋnndɛ atɩn mɔ bɛ 'sɩn sʋ bɛ kun Zozi. ");
INSERT INTO any_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","M'ɔ yɔlɩ sɔ'n, Zozi nʋn yɩ́ menian'n-mɔ bɛ hyʋɩnlɩn bɛ́ nzin bɛ hɔlɩ Galile asue nɩn anʋan ɛlɔ. Menian dɔʋn kɔ si yɩ́ sʋ. ");
INSERT INTO any_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Meninsʋnman'n walɩ Zozi anwʋn ɛbɛlɛ, afɩ ninnge'n-mɔ kʋalaa m'ɔ yɔlɩ'n, bɛ tɩlɩ yɩ́ ngan. Mmie-mɔ fi Galile nʋn Zude mân nɩn anun. Mmie-mɔ kʋsʋ fi Zoluzalɛmʋn kulo nɩn asʋ ɔ nʋn Idume mân nɩn anun. Dɔʋn kʋsʋ fi asue Zuludɩn nɩn anzin ebue kʋn ɛlɔ. Bɛ́ nga'n fi Tii nʋn Sidʋn kulo'n-mɔ anwʋn ɛlɔ. ");
INSERT INTO any_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Ɛhɩ a, Zozi kɔ se yɩ́ menian'n-mɔ kɛ bɛ kpʋ́nndɛ ɛlɛɛ kʋn bɛ mán yɩ́ maan ɔ tɩ́ yɩ́ nwʋn kaan, ɔ sanlɩn kɛ menian'n-mɔ a mgbunmgbun yɩ́ sʋ sʋnman. ");
INSERT INTO any_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Afɩ, kɛmɔ ɔ man nwuluwafʋɛ dɔʋn anwʋn sa'n, bɛ́ kʋalaa mɔ bɛ ndɩ man akpɔlɛ'n, bɛ kpɩlɩ bɛ kɔ kan yɩ́. ");
INSERT INTO any_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Mɛlɛ mɔ wawɛ ɛtɛ'n-mɔ kɔ nwun Zozi'n, bɛ kʋtʋ yɩ́ nyunnun, anɩn bɛ lɛ tɛtɩan nun. Bɛ́ nwan: “Ɛ tɩ Nyanmɩan Awa! Ɛ tɩ Nyanmɩan Awa!” ");
INSERT INTO any_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Nan mɔ bɛ 'kan sɔ'n, anɩn Zozi a totua bɛ́ sɛlɛ kpa nán b'a mmɔ man yɩ́ kpayɛ kɛ ɔ tɩ Nyanmɩan Awa sakpa. ");
INSERT INTO any_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Ɛhɩ anzin, Zozi fi ɛbɛlɛ, ɔ nʋn yɩ́ menian'n-mɔ bɛ kɔ hɔ kɔ fʋ bʋka kʋn asʋ. Ɔ kɔ fɛfɛlɛ bɛ́ mɔ ɔ kulo kɛ yɩ́ muonun ɔ fa bɛ́ sie yɩ́ nwʋn ɔ nʋn bɛ́ di junman'n. Bɛ́ m'ɔ fɛfɛlɛlɩ bɛ́'n fi bagua nɩn anun bɛ́ ti kɔ yia yɩ́ nwʋn ɛbɛlɛ. ");
INSERT INTO any_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Bɛ tɩ bulu nʋn nnyuan. Menian bulu nʋn nnyuan sɔ'n, bɛ wɔ Zozi asa nun. Ɔ fɛlɛ bɛ́ mmɔfʋɛ. Ɔ sʋan bɛ́ maan bɛ kɔ bɔ Ɛjɔlɛkpa'n bɛ kele menian'n-mɔ. ");
INSERT INTO any_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Ɔ kɔ man bɛ́ tunmin mɔ bɛ kʋala fa tu wawɛ ɛtɛ'n-mɔ. ");
INSERT INTO any_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Menian bulu nʋn nnyuan'n mɔ Zozi fɛlɛlɩ bɛ́ yɩ́ nwʋn ɔ manlɩn bɛ́ junman'n, bɛ́ ahɩ: Simʋn mɔ Zozi tʋnlɩn yɩ́ Pɩɛlɩ'n, ");
INSERT INTO any_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Zʋakɩ ɔ nʋn Zʋan, Zebede amma'n-mɔ (mɔ Zozi tʋnlɩn bɛ́ “Bʋanɛjɛsɩ” mɔ yɩ́ bʋ y'ɔ le kɛ menian anwʋn esulo kɛ mgbanlanlan.) ");
INSERT INTO any_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andele, Filipʋ, Baatelemin, Matie, Toma, Alɩfe awa Zʋakɩ, Tade, Simʋn m'ɔ kpʋnndɛ yɩ́ mân'n fanwʋndi'n, ");
INSERT INTO any_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","ɔ nʋn Zudasɩ Isikaliɔtɩ mɔ kasian'n, ɔ yɩlɩ Zozi manlɩn yɩ́ mgbɔfʋɛ'n-mɔ'n. ");
INSERT INTO any_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Ɛhɩ anzin, Zozi nʋn yɩ́ menian'n-mɔ fi bʋka nɩn asʋ bɛ kɔ ju bɛ kɔ hɔ awulo. Mɔ bɛ juli ɛbɛlɛ'n, meninsʋnman'n kɔ a kɔ yia awulo nɩn anun biekun. Ɔ man Zozi nʋn yɩ́ menian'n-mɔ nnyan man atɩn bɔbɔ bɛ nni man like. ");
INSERT INTO any_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Yɩ́ sɔ ɛhɩ anun, Zozi nvilie'n-mɔ tɩlɩ ɛjɔlɛ sɔ nɩn an, bɛ kɔ a yɩ́ ɛfa. Ɔ sanlɩn kɛ bɛ́ ajʋnlɩn nun an, bɛ́ nwan: “Zozi ati a sɛcɩ!” ");
INSERT INTO any_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Ɛhɩ, mala nɩn asʋ mgbain'n-mɔ fi Zoluzalɛmʋn bɛ walɩ a, bɛ́ nwan: “Bian ɛhɩ, *Bɛlɩzebulu m'ɔ tɩ mmɔnsanmʋn'n-mɔ kpain'n wɔ yɩ́ nun. Yɩ́ y'ɔ man yɩ́ anwʋnsɛlɛ m'ɔ fa tu wawɛ ɛtɛ'n-mɔ ɔ.” ");
INSERT INTO any_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Mɔ Zozi tɩlɩ ɛjɔlɛ sɔ'n, ɔ kɔ fɛlɛ bɛ́, ɔ kɔ bubu anyɩnndala-mɔ kɔ hehele bɛ́. Yɩ́ nwan: “*Satan 'yɔ sɛ nán ɔ'a hʋala Satan tu? ");
INSERT INTO any_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Sɛ belemgbin mân kʋn anun menian'n-mɔ bu bɛ́ nwʋn nun an, mân sɔ'n 'bɔ asɩ. ");
INSERT INTO any_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Ɛsɛ awulo kʋn kʋsʋ mɔ nun menian'n-mɔ nni man anʋannzɛ nan bɛ kpɔ bɛ́ nwʋn'n, awulo sɔ'n 'bɔ. ");
INSERT INTO any_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Nan sɛ Satan jasʋ yɩ́ ngʋnmɩn yɩ́ Satan yɩ́ kɔmɩn anun an, sɛ mmubue ba yɩ́ belemgbin mân nɩn anun an, yɩ́ tunmin'n nvʋ man kʋ́n. Yɩ́ mân sɔ'n 'bɔ asɩ, anɩn yɩ́ dɩɛ a yue. ");
INSERT INTO any_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Sʋanlan fɩ́ɩ́ ngʋala man kɛ ɔ wʋlʋ sʋanlan m'ɔ tɩ akpɔlɛ nɩn awulo yɩ́ nyɩnsʋ ɔ kɔ wua yɩ́, abɛlɛ m'ɔ cɩcɩlɩ man yɩ́'n. Sannan ɔ 'di mʋa ɔ cɩcɩ yɩ́ kʋalaaka nán ɔ'a hʋala ɔ'a wua yɩ́. ");
INSERT INTO any_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Mɩɩn kan yɩ́ ananhɔlɛ mɩn kele ɛmɔ kɛ bɛ 'fa menian'n-mɔ ɛtɛ'n-mɔ kʋalaa ɔ nʋn bɛ́ ɛjʋjɔlɛ ɛtɛ'n bɛ ce bɛ́. ");
INSERT INTO any_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Nan sʋanlan biala m'ɔ kɔ jʋjɔ kɔ tia Nyanmɩan Wawɛ'n, ɔ nnyan man face. Ɔ sanlɩn kɛ anɩn ɔ'a yɔ ɛtɛ m'ɔ le man ayuelɩɛ.” ");
INSERT INTO any_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Zozi hanlɩn sɔ ɛjɔlɛ'n ɔ helelɩ bɛ́, ɔ sanlɩn kɛ bɛ́ nwan: “Wawɛ ɛtɛ wɔ yɩ́ nun.” ");
INSERT INTO any_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Ɛbɛlɛ ala, yɩ́ nianman'n-mɔ nʋn bɛ́ nin kɔ ju ɛbɛlɛ. Bɛ kɔ ha ahanmɩan, bɛ kɔ yɩ sʋanlan kɛ ɔ hɔ́ fɛ́lɛ yɩ́ mán bɛ́. ");
INSERT INTO any_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Anɩn menian dɔʋn kpa tɩtɩ asɩ, b'a ta b'a si b'a yia Zozi. Bɛ kɔ han bɛ kɔ hele yɩ́ kɛ: “Nɩan, wɔ́ nin nʋn wɔ́ nianman'n-mɔ jijin ahanmɩan ɛlɔ, bɛ lɛ kpʋnndɛ wɔ́.” ");
INSERT INTO any_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Mɔ Zozi tɩlɩ ɛjɔlɛ sɔ'n, yɩ́ nwan: “Mɩ́n nin'n nʋn mɩ́n nianman'n-mɔ y'ɔ le nwan-mɔ?” ");
INSERT INTO any_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","M'ɔ hanlɩn sɔ'n, ɔ kɔ nɛnɩan bɛ́ mɔ bɛ tɩtɩ asɩ b'a ta b'a si b'a yia yɩ́'n, yɩ́ nwan: “Mɩ́n nin nʋn mɩ́n nianman'n-mɔ y'ɔ le bɛ́ mɔ bɛ gua ɛwa'n. ");
INSERT INTO any_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Ɔ sanlɩn kɛ sʋanlan biala m'ɔ yɔ mɩ́n Sɩ ehulo like'n, sʋanlan sɔ'n, ɔ tɩ mɩ́n nianman bian, ɔ tɩ mɩ́n nianman bala, ɛsɛ ɔ tɩ mɩ́n nin.” ");
INSERT INTO any_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Ɛhɩ, Zozi fi ɛbɛlɛ yɩ́ nʋan y'ɔ le Galile asue nɩn anʋan ɛlɔ biekun. Ɔ 'kɔ a hehele menian'n-mɔ Nyanmɩan Anʋan Ɛjɔlɛ'n. Menian dɔʋn kpa walɩ yialɩ yɩ́ nwʋn. Kɛmɔ menian'n-mɔ sʋnlɩn nɩn ati, ɔ kɔ fʋ kɔ tanlan ɛlɛɛ kʋn anun asue nɩn anyɩnsʋ. Meninsʋnman'n kɔ ha asue nɩn anʋan. ");
INSERT INTO any_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Zozi kɔ hehele bɛ́ ninnge dɔʋn kpa anyɩnndala nun. Mɔ ɔ 'kekele bɛ́ ninnge'n, yɩ́ nwan: ");
INSERT INTO any_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Ɛmɔ tíe! Anɩn sʋanlan kʋn wɔ ɛbɛlɛ. Cɩan kʋn, ɔ hɔlɩ kɛ ɔ 'kɔ a gua yɩ́ *bele (m'ɔ tɩ kɛ awe'n). ");
INSERT INTO any_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Nan tɛmʋn mɔ ɔ 'gua bele'n, bie kɔ gua atɩn nɩn anʋan. Nnʋnman'n-mɔ kɔ a kɔ suso kɔ li. ");
INSERT INTO any_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Bie kʋsʋ kɔ gua nyɔbʋɛ nɩn asʋ. Ɛbɛlɛ ngɛtɩɛ nɩn a nzʋn man. Ɔ kɔ fifi ndɛ-ndɛ, ɔ sanlɩn kɛ ɔ gualɩ ngɛtɩɛ kpa kaan'n m'ɔ wɔ ɛbʋɛ nɩn ati sʋ nɩn asʋ. ");
INSERT INTO any_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Nan mɔ eyua'n fili sɛlɛ'n, ɛbɛlɛ dɩɛ'n kɔ yala. Afɩ, yɩ́ ndɩan nɩn a ngɔ man asɩɛ bʋ. ");
INSERT INTO any_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Bele'n bie kɔ gua eminlan mmowe'n-mɔ anun. Eminlan mmowe sɔ'n-mɔ nʋn bele'n kɔ fifi. Nan mɔ bele'n nyinlin'n, eminlan mmowe'n-mɔ kɔ fʋ kɔ gua sʋ. Bele'n ngɔ su man mma fɩ́ɩ́. ");
INSERT INTO any_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Bie kʋsʋ kɔ gua asɩɛ kpa nɩn asʋ. Ɔ kɔ fifi, ɛsɛ ɔ kɔ hɩn, ɔ kɔ su mma. Bie kɔ su mma abulasan, bie mma abulasian, bie kʋsʋ mma ɛya.” ");
INSERT INTO any_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Zozi hanlɩn sɔ yuelɩ a, yɩ́ nwan: “Sʋanlan m'ɔ sɩ fasie'n, ɔ fá síe!” ");
INSERT INTO any_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Mɔ Zozi tɩlɩ yɩ́ nwʋn'n, like mɔ yɩ́ ti y'ɔ man ɔ bu anyɩnndala'n, bɛ́ mɔ bɛ si yɩ́ sʋ daba'n nʋn yɩ́ menian bulu nʋn nnyuan'n, bɛ kɔ bisa yɩ́ kɛ ɔ tú anyɩnndala nɩn abʋ ɔ héle bɛ́. ");
INSERT INTO any_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Ɛhɩ a, Zozi nwan: “Nyanmɩan Belemgbin Mân'n mɔ anɩn ɔ tɩ nvɩalɩɛ nun like'n, ɛmɔ dɩɛ ɛmɔ asa a han yɩ́. Nan bɛ́ mɔ bɛ wɔ gua nɩn asʋ'n, bɛ́ dɩɛ, yɩ́ kʋalaa sɩn anyɩnndala nun, ");
INSERT INTO any_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","afɩ man Bɛ nɩ́an yɩ́ kpa bɔbɔ a, bɛ nnwun man yɩ́. Ɛsɛ man bɛ tíe yɩ́ kpa bɔbɔ a, bɛ ndɩ man yɩ́ bʋ. Sɛ ɔ tɩ man sɔ a, ahan b'a kaci bɛ́ abalabɔ'n b'a fa bɛ́ nwʋn b'a man Nyanmɩan maan ɔ a fa bɛ́ ɛtɛ nɩn a hye bɛ́.” ");
INSERT INTO any_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Mɔ Zozi hanlɩn sɔ'n, ɛsɛ yɩ́ nwan: “Ɛmɔ ndɩ man anyɩnndala ɛhɩ abʋ, ɔ 'yɔ sɛ nán ɛmɔ a tɩ anyɩnndala nga'n-mɔ kʋalaa abʋ? ");
INSERT INTO any_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Sʋanlan m'ɔ lɛ gua bele'n y'ɔ le sʋanlan'n m'ɔ kan Nyanmɩan Anʋan Ɛjɔlɛ'n. ");
INSERT INTO any_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Menian mmie-mɔ tɩ kɛ atɩn nɩn anʋan'n mɔ bele'n kɔ gua'n. Menian sɔ'n-mɔ, kɛ bɛ kɔ tɩ Nyanmɩan Anʋan Ɛjɔlɛ nɩn ala, anɩn Satan a yɩ ɛjɔlɛ'n mɔ bɛ kɔ tɩ'n fi bɛ́ ahʋnlɩn nɩn anun. ");
INSERT INTO any_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Yɩ́ sɔ ala, mmie-mɔ tɩ kɛ ɛbʋta nɩn asʋ ngɛtɩɛ'n mɔ bele'n kɔ gua sʋ'n. Sɛ bɛ tɩ ɛjɔlɛ nɩn ala a, bɛ le fɛ elie kpa bɛ de ndɛ-ndɛ bɛ di. ");
INSERT INTO any_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Nan kʋsʋ, ɔ nzɔ man ndɩan bɛ́ nun. Bɛ tɩ kɛ cɩan kʋn menian. Sɛ yalɛ anaan ahʋlʋwa tʋ bɛ́ wɔ Nyanmɩan Anʋan Ɛjɔlɛ'n dunman nun an, bɛ yaci bɛ dedi'n mɔ bɛ le yɩ́'n bɛ tʋ ndɛ-ndɛ. ");
INSERT INTO any_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Mmie-mɔ kʋsʋ tɩ kɛ eminlan mmowe'n mɔ bele'n kɔ gua nun'n. Menian sɔ'n-mɔ tɩ ɛjɔlɛ'n, ");
INSERT INTO any_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","nan kʋsʋ mân ɛhɩ anun nzusue'n, anyanbɛnwʋn naka'n, ɔ nʋn anyɩnbʋlʋ ngacile'n kʋalaa kpunmgbun ɛjɔlɛ'n. Ɔ nzu man mma. ");
INSERT INTO any_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Mmie-mɔ kʋsʋ tɩ kɛ asɩɛ kpa'n mɔ bele'n kɔ gua sʋ'n. Menian sɔ'n-mɔ dɩɛ, bɛ tɩ Nyanmɩan Anʋan Ɛjɔlɛ nɩn an, bɛ de bɛ di. Bɛ nyan menian bɛ bʋka bɛ́ nwʋn sʋ. Bie nyan abulasan, bie nyan abulasian, bie kʋsʋ nyan ɛya.” ");
INSERT INTO any_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Mɔ Zozi tuli anyɩnndala sɔ nɩn abʋ yuelɩ'n, ɔ kɔ bisa bɛ́ biekun kɛ: “Asʋ sʋanlan sɔ kanlannɩɛ a, bokiti anaan sʋkpa abʋ yɛ̂ ɔ fa sie ɔ? Nán anwunno yɛ̂ bɛ fa bɛ sie ɔ? ");
INSERT INTO any_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Like biala m'ɔ fɩa'n, ɔ 'tu fite. Nvɩalɩɛ nun ɛjɔlɛ'n, ɔ 'fite jawe nun. ");
INSERT INTO any_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Sʋanlan m'ɔ sɩ fasie'n, ɔ fá sie!” ");
INSERT INTO any_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Ɛsɛ Zozi kɔ han kɔ hele bɛ́ biekun kɛ: “Ɛjɔlɛ ɛhɩ mɔ ɛmɔ a tɩ'n, ɛmɔ nɩ́an yɩ́ kpa. Sulɩɛ'n mɔ ɛmɔ fa su bɛ́ manngʋn'n-mɔ'n, yɩ́ kʋnmgba'n yɛ̂ bɛ 'fa bɛ su ɛmɔ ɔ, ɛsɛ bɔbɔ bɛ 'gua sʋ bɛ man ɛmɔ. ");
INSERT INTO any_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","M'ɔ le bie'n, bɛ 'man yɩ́ biekun. Nan m'ɔ le man bie'n, bɛ 'tʋa yɩ́ bɛ de kaan'n m'ɔ le'n.” ");
INSERT INTO any_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Ɛsɛ Zozi kɔ bu anyɩnndala kʋn biekun kɛ: “Nyanmɩan Belemgbin Mân'n, ɔ soman sʋanlan m'ɔ lɛ gua *bele yɩ́ ebo nɩn asʋ. ");
INSERT INTO any_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Sɛ ɔ dafɩ o, sɛ yɩ́ nyɩn wɔ sʋ o, Kɔngɔɛ o, eyua o, bele mma'n fifi. Kɛ ɔ kpɩn yɔ m'ɔ fifi'n, sʋanlan nzɩ man. ");
INSERT INTO any_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Asɩɛ'n muonun y'ɔ man ɔ fifi ɔ. Alimʋa nɩn anun, ɔ tɩ ndile. Yɩ́ nzin, ɔ wɔlɔ, yɩ́ ayuelɩɛ'n, ɔ tin, ɔ bʋlʋ. ");
INSERT INTO any_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Nan m'ɔ kɔ bʋlʋ'n, anɩn b'a fa dadɩɛ b'a wʋlʋ nun, afɩ anɩn yɩ́ ɛtɩɛ mɛlɛ nɩn a ju.” ");
INSERT INTO any_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Ɛhɩ anzin, Zozi kɔ han kɔ hele bɛ́ biekun kɛ: “Nzukɛ like dɩɛ yɛ̂ yɛ 'fa Nyanmɩan Belemgbin Mân'n yɛ susu yɩ́ ɔ? Anaan anyɩnndala benin yɛ̂ yɛ 'bu m'ɔ nʋn yɩ́ kɔ sʋ ɔ? ");
INSERT INTO any_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Nyanmɩan Belemgbin Mân'n soman muntadɩ baa'n mɔ bɛ dua'n. Ɔ tɩ kaan tala mmaka mma'n-mɔ mɔ bɛ dua'n kʋalaatin. ");
INSERT INTO any_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Nan mɔ bɛ kɔ lua'n, ɔ yɔ kpili tala tola nɩn anun mmaka'n-mɔ kʋalaatin. Ɔ tʋtʋ yɩ́ sa anwunno, nnʋnman'n-mɔ nwʋn bɛ́ sâ yɩ́ nyâ nɩn abʋ fɔlɔlɔ nɩn anun.” ");
INSERT INTO any_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Zozi buli anyɩnndala m'ɔ tɩ sʋa dɔʋn ɔ hanlɩn Nyanmɩan Anʋan Ɛjɔlɛ'n ɔ helelɩ bɛ́. Nunhan m'ɔ bu a, bɛ kʋala kɛ bɛ tɩ yɩ́ bʋ'n yɛ̂ ɔ bu ɔ. ");
INSERT INTO any_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Ɔ ngan man ɛjɔlɛ fɩ́ɩ́ fɔ́ʋ́n ɔ ngele man bɛ́. Yɩ́ kʋalaa m'ɔ kan'n, ɔ bu yɩ́ nwʋn anyɩnndala. M'ɔ kɔ ha yɩ́ ngʋnmɩn nʋn yɩ́ menian'n-mɔ'n, ɔ tu yɩ́ anyɩnndala'n-mɔ kʋalaa abʋ ɔ kele bɛ́. ");
INSERT INTO any_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Ɛhɩ, cɩan kʋnmgba sɔ'n nɔsʋba, Zozi kɔ han kɔ hele yɩ́ menian'n-mɔ kɛ: “Bɛ mán yɛ kpɛ́ asue'n yɛ hɔ́ yɩ́ nzin ɛlɔ.” ");
INSERT INTO any_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Mɔ Zozi hanlɩn sɔ'n, yɩ́ menian'n-mɔ tuli ɛlɛɛ'n m'ɔ tɩ nun nɩn abʋ bɛ kɔ yaci meninsʋnman nɩn ɛbɛlɛ. Anɩn ɛlɛɛ mmie-mɔ kʋsʋ sisi asue nɩn anʋan ɛbɛlɛ. ");
INSERT INTO any_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Bɛ hɔlɩ bɛ́ nyunnun kaan an, huuu, anwʋnman kpili kʋn nʋn asutue kɔ tu kɔ si bɛ́. Mgbaha'n kɔ bɔ nsue kɔ gua ɛlɛɛ nɩn anun dede ɔ ka m'ɔ nʋan ɔ. ");
INSERT INTO any_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Zozi la ɛlɛɛ nɩn abʋ ati, yɩ́ sunmin sɔ yɩ́ ti, ɔ lɛ dafɩ. Yɩ́ menian'n-mɔ kɔ tinnge yɩ́. Bɛ́ nwan: “Kpain, yɛ lɛ wu! Ɔ njian man wɔ́ ɔ?” ");
INSERT INTO any_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Zozi fi nafɛlɛ nun kɔ tinnge. Ɔ kɔ jʋjɔ aminle sʋ kɔ hele anwʋnman kpili'n. Ɛsɛ ɔ kɔ han kɔ hele asue'n kɛ: “Asue, gua diin!” Ɛbɛlɛ ala, anwʋnman kpili'n kɔ gua. Asue'n kɔ gua diin. ");
INSERT INTO any_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Mɔ asutue'n gualɩ asɩ'n, Zozi kɔ bisa yɩ́ menian'n-mɔ kɛ: “Nzukɛ ati yɛ̂ ɛmɔ man esulo kan bɛ́ ɔ? Ɔ yɔ sɛ mɔ ɛmɔ nne man mɩ́n bɛ nni man ɔ?” ");
INSERT INTO any_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Bɛ́ nwʋn ngɔmʋa kʋalaa fi bɛ́ nwʋn tuli, bɛ kɔ han yɩ́ bɛ́ afian ɛlɔ kɛ: “Sʋanlan benin y'ɔ le ɛhɩ mɔ anwʋnman bɔbɔ nʋn asutue man yɩ́ anyɩnnzɔ ɔ?” ");
INSERT INTO any_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Ɛhɩ, Zozi nʋn yɩ́ menian'n-mɔ, bɛ kpɛlɩ Galile asue'n bɛ hɔlɩ juli Zelazɩ mân nɩn anun. ");
INSERT INTO any_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Kɛ Zozi fi ɛlɛɛ nɩn anun 'ju asɩ nɩn ala, sʋanlan kʋn fi asielɩɛ nɩn asʋ kɔ a yɩ́ nwʋn ɛbɛlɛ. ");
INSERT INTO any_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Sʋanlan sɔ'n, wawɛ ɛtɛ wɔ yɩ́ nun, asielɩɛ nɩn asʋ yɛ̂ ɔ da ɔ. Sʋanlan fɩ́ɩ́ ngʋala man yɩ́ cɩ, nán b'a fa ngɔnzɔngɔnzɔ b'a bɔ yɩ́ kpaun. ");
INSERT INTO any_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Afɩ ɔ yɔ a, bɛ fa mmulalɛ anaan ngɔnzɔngɔnzɔ bɛ gua yɩ́ ja nʋn yɩ́ sa, kʋsʋ, ɔ bubu nun. Sʋanlan fɩ́ɩ́ le man anwʋnsɛlɛ m'ɔ kʋala sʋanlan sɔ'n cɩ ɔ. ");
INSERT INTO any_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Cɩan biala, kɔngɔɛ nʋn eyua, ɛ 'nwun yɩ́ a, anɩn ɔ nanndɩ asielɩɛ'n nʋn mmʋka'n-mɔ asʋ, ɔ tɛtɩan, ɔ sɩsa nyɔbʋɛ'n-mɔ ɔ bʋta bʋta yɩ́ nwʋn. ");
INSERT INTO any_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","M'ɔ nwunlin Zozi mʋa ɛlɔ'n, ɔ kɔ tutu ɛnwanndie ɔ kɔ hɔ kɔ kʋtʋ yɩ́ nyunnun ɛbɛlɛ. ");
INSERT INTO any_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Ɔ kɔ tɩan nun sɛlɛ kpa. Yɩ nwan: “Zozi, Anwunno Nyanmɩan Kpili Awa, ɛ 'se mɩ́n sɛ? Mɩn 'sɛlɛ wɔ́, nɩan wɔ́ Nyanmɩan ɛlɔ, n'ɛ se mɩ́n sa fɩ́ɩ́.” ");
INSERT INTO any_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Ɔ lɛ kan sɔ, afɩ Zozi nwan: “Wawɛ ɛtɛ, fi sʋanlan ɛhɩ nun fite.” ");
INSERT INTO any_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Zozi kɔ bisa yɩ́ kɛ: “Ɛ li sɛ?” Sʋanlan'n nwan: “Bɛ fɛlɛ mɩ́n nwala nwala, afɩ yɛ sʋnlɩn.” ");
INSERT INTO any_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ɔ kɔ bʋtʋ Zozi kɛ n'ɔ fʋan bɛ́ fi mân sɔ nɩn anun. ");
INSERT INTO any_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Lɩka mɔ bɛ jin nɩn afan nun, bʋka kʋn anwʋn ɛbɛlɛ, anɩn mgbolike fatule kʋn lɛ didi. ");
INSERT INTO any_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Wawɛ ɛtɛ'n-mɔ kɔ bʋtʋ Zozi kɛ: “Man yɛ́ atɩn maan yɛ hɔ́ wʋ́lʋ mgbolike'n-mɔ anun.” ");
INSERT INTO any_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Zozi kɔ man bɛ́ atɩn. Ɛhɩ a, wawɛ ɛtɛ'n-mɔ fi sʋanlan nɩn anun bɛ kɔ fite, bɛ kɔ hɔ kɔ wʋlʋ mgbolike'n-mɔ anun. Mgbolike fatule kɔ yɔ akpɩɩ nnyuan'n le ɛnwanndie bɛ kɔ tʋlʋ bʋka'n bɛ kɔ hɔ kɔ gua asue nɩn anun, bɛ kɔ nʋan. ");
INSERT INTO any_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Menian'n-mɔ mɔ bɛ nɩan mgbolike'n-mɔ asʋ'n kɔ nwanndi. Bɛ kɔ hɔ kɔ bɔ ɛjɔlɛ sɔ'n kpayɛ kulo, ɔ nʋn nanmue'n-mɔ asʋ. Bɛ́ mɔ bɛ tɩlɩ ɛjɔlɛ sɔ'n, bɛ walɩ nɩanlɩn kɛ ɔ kpɩnlɩn yɔlɩ yɩ́'n. ");
INSERT INTO any_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Bɛ 'ba ju Zozi anwʋn ɛbɛlɛ a, sʋanlan'n mɔ anɩn wawɛ ɛtɛ'n-mɔ wɔ yɩ́ nun nɩn anyɩnsʋ a tɩ. Ɔ wula taladɩɛ ɔ tɩ ɛbɛlɛ. Ɛjɔlɛ'n yɔlɩ bɛ́ esulo. ");
INSERT INTO any_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Kɛ ɔ kpɩnlɩn yɔlɩ mɔ wawɛ ɛtɛ'n-mɔ fi sʋanlan nɩn anun bɛ fitelɩ, mɔ bɛ hɔlɩ wʋlʋlɩ mgbolike'n-mɔ anun mɔ bɛ 'kɔ a gua asue nɩn anun, mɔ ɛsɛ bian nɩn anyɩnsʋ 'tɩ'n, bɛ́ mɔ bɛ nwunlin yɩ́ bɛ́ nyɩnsʋ'n, bɛ bɔlɩ bɛ helelɩ sian mma'n-mɔ. ");
INSERT INTO any_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Mɔ bɛ tɩlɩ yɩ́ sɔ'n, bɛ bʋtʋlɩ Zozi kɛ ɔ fi bɛ́ mân nɩn anun ɔ jásʋ. ");
INSERT INTO any_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Mɔ Zozi 'fʋ ɛlɛɛ nɩn anun'n, sʋanlan'n m'ɔ tuli wawɛ ɛtɛ'n-mɔ fi yɩ́ nun'n kɔ bʋtʋ yɩ́ kɛ ɔ 'si yɩ́ sʋ. ");
INSERT INTO any_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Ɔ hanlɩn sɔ a, Zozi ngɔ tie man. Yɩ́ nwan: “Sa kɔ wɔ́ awulo, kɔ han yɩ́ kʋalaa mɔ yɛ́ Mɩn a yɔ a man wɔ́ nʋn kɛ ɔ'a kpɩn ɔ'a nwun wɔ́ nwʋn anwunnvoe'n kele wɔ́ nvilie'n-mɔ.” ");
INSERT INTO any_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Ɛbɛlɛ ala, sʋanlan sɔ'n kɔ hɔ mân'n mɔ bɛ fɛlɛ yɩ́ Kulo Bulu nɩn anun. Ɔ kɔ hɔ kɔ bɔ mɔ Zozi yɔlɩ manlɩn yɩ́'n kpayɛ. Bɛ́ kʋalaa mɔ bɛ tɩlɩ yɩ́ ngan'n, ɔ sinlin bɛ́ nwʋn. ");
INSERT INTO any_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Ɛhɩ, Zozi fi Galile asue nɩn anzin ɔ kɔ sa kɔ a. M'ɔ walɩ juli asue nɩn anʋan ɛbɛlɛ'n, menian dɔʋn kpa walɩ yɩ́ nwʋn. ");
INSERT INTO any_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Kaan cɛ, Zufu'n-mɔ asɔnɩn sua nɩn asʋ mgbain'n-mɔ anun kʋn kɔ a kɔ ju ɛbɛlɛ. Kpain sɔ'n bɛ fɛlɛ yɩ́ Zʋayilusi. Ɔ nwunlin Zozi a, ɔ kɔ tu kɔ tɔ yɩ́ ja nun. ");
INSERT INTO any_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Ɔ kɔ bʋtʋ yɩ́, yɩ́ sa la yɩ́ sa nun, yɩ́ nwan: “Mɩ́n wa balasua'n lɛ ka nun, yɩ́ ti bala fa wɔ́ sa fua yɩ́ nwʋn maan ɔ tɩ́ akpɔlɛ ɔ nyán ngʋan.” ");
INSERT INTO any_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Bian'n hanlɩn sɔ ala, Zozi nʋn yɩ́ kɔ hɔ. Mɔ bɛ 'kɔ'n, menian dɔʋn kpa sili yɩ́ sʋ, anɩn bɛ 'kan Zozi bɛ mian bɛ́ afian. ");
INSERT INTO any_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Ɔ 'ba yɔ sɔ'n, anɩn balasua kʋn wɔ menian'n-mɔ afian ɛbɛlɛ. Moja tu balasua sɔ'n, yɩ́ afʋɛ bulu nʋn nnyuan ahɩ. ");
INSERT INTO any_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Ɔ nwunlin yalɛ dɔʋn wɔ ayile ɛyɔlɛfʋɛ sʋnman asa nun. Ɔ sɛcɩlɩ yɩ́ nwʋn esika kʋalaatin, kʋsʋ yɩ́ nwʋn a nza man. Yɩ́ ewue nɩn anyunnun ala yɛ̂ ɔ kɔ ɔ. ");
INSERT INTO any_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Ɔ tɩlɩ kɛ menian'n-mɔ lɛ kan Zozi anwʋn ɛjɔlɛ. Ɔ kɔ a kɔ wʋlʋ menian nwala'n mɔ afian, Zozi anzin ɛbɛlɛ, ɔ kɔ han yɩ́ taladɩɛ'n. ");
INSERT INTO any_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Afɩ yɩ́ nwan: “Sɛ mɩn kan yɩ́ taladɩɛ nɩn ala a, mɩ́n nwʋn 'sa.” ");
INSERT INTO any_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Ɔ hanlɩn yɩ́ a, yɩ́ moja'n m'ɔ tu yɩ́'n kɔ kpɛ. Ɛbɛlɛ ala, ɔ kɔ nwun yɩ́ kɛ yɩ́ nwʋn a sa. ");
INSERT INTO any_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Zozi kʋsʋ kɔ nwun yɩ́ ɛbɛlɛ ala kɛ anwʋnsɛlɛ kʋn fi yɩ́ nun a fite. Ɔ kɔ kpɛ yɩ́ nyɩn menian'n-mɔ afian ɛlɔ ɔ kɔ bisa kɛ: “Nwan yɛ̂ ɔ'a han mɩ́n taladɩɛ'n?” ");
INSERT INTO any_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Ɔ bisalɩ ɛhɩ a, yɩ́ menian'n-mɔ nwan: “Wɔ́ nyɩn tua kɛ menian'n-mɔ lɛ mian wɔ́, kʋsʋ anɩn ɛ lɛ bisa kɛ: Nwan yɛ̂ ɔ'a han mɩ́n ɔ?” ");
INSERT INTO any_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Ɔ kɔ nɛnɩan yɩ́ nwʋn ɛbɛlɛ menian'n-mɔ anun kɔ si kɔ yia sɛ ɔ kɔ nwun sʋanlan'n m'ɔ hanlɩn yɩ́ nɩn an. ");
INSERT INTO any_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Kɛmɔ balasua'n sɩ like m'ɔ nwunlɩn yɩ́ wɔ yɩ́ nwʋnnaan nɩn anun'n, esulo hanlɩn yɩ́ dede yɩ́ nwʋn wʋsʋlɩ yɩ́. Ɔ kɔ a kɔ tu kɔ tɔ Zozi aja nun, ɔ kɔ han ananhɔlɛ'n kʋalaa ɔ kɔ hele yɩ́. ");
INSERT INTO any_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Ɛhɩ a, Zozi nwan: “Mɩ́n wa balasua, wɔ́ dedi nɩn a le wɔ́ ngʋan. Kɔ anzʋnunjɔ nun, man wɔ́ nwʋn sá.” ");
INSERT INTO any_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Anɩn Zozi anʋan tɔlɩ man bɔbɔ, menian fi kpain Zʋayilusi awulo ɛlɔ bɛ walɩ tʋlɩ yɩ́ a, bɛ́ nwan: “Wɔ́ wa balasua nɩn a wu, nan benin anwʋn ati yɛ̂ ɛ tɛ jɩjɩ mɩnlɩan nɩn ɔ?” ");
INSERT INTO any_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Nan mɔ bɛ hanlɩn sɔ'n, Zozi ngɔ bu man yɩ́ ɛjɔlɛ. Yɩ́ nwan: “Zʋayilusi, gua wɔ́ ahʋnlɩn asɩ, nyan dedi ala.” ");
INSERT INTO any_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Zozi ngɔ man sʋanlan fɩ́ɩ́ atɩn kɛ ɔ sí yɩ́ sʋ, sannan Pɩɛlɩ nʋn Zʋakɩ nʋn yɩ́ nianman Zʋan, bɛ́ ala. ");
INSERT INTO any_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Mɔ bɛ juli Zʋayilusi awulo ɛlɔ'n, Zozi nwunlin kɛ ɛbɛlɛ asʋa yɔɔ. Menian'n-mɔ le esuan nʋn awuye ɛbɔ nʋn ɛtɛtɩan nʋn awɔ́lɛ ɛyɩɛ. ");
INSERT INTO any_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Ɔ kɔ wʋlʋ sua nɩn anun ɔ kɔ bisa bɛ́ kɛ: “Nzukɛ ati yɛ̂ ɛmɔ lɛ bɔ awuye bɛ sun sʋa ɔ? Batʋnman talua'n wuli man, nan ɔ lɛ dafɩ.” ");
INSERT INTO any_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Kɛ ɔ hanlɩn sɔ nɩn ala, menian'n-mɔ kɔ gʋlʋ yɩ́ nwʋn. Ɛhɩ a, Zozi kɔ man bɛ́ kʋalaa bɛ kɔ fite, ɔ kɔ ha sɩɛ'n nʋn nian'n, nʋn yɩ́ menian nsan'n mɔ bɛ walɩ somanlɩn yɩ́'n. Ɔ nʋn bɛ́ kɔ wʋlʋ lɩka mɔ batʋnman'n la'n. ");
INSERT INTO any_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Ɔ kɔ sɔ batʋnman nɩn asa nɩn anun, yɩ́ nwan: “Talita kunmin!” Yɩ́ bʋ y'ɔ le kɛ: “Talua kaan, mɩ́n nwan ɛ jásʋ!” ");
INSERT INTO any_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Ɛbɛlɛ ala, talua'n kɔ jasʋ kɔ nanndɩ. Mɔ ɛjɔlɛ ɛhɩ 'ba'n, anɩn talua nɩn a li afʋɛ bulu nʋn nnyuan. Mɔ menian'n-mɔ nwunlin yɩ́ sɔ'n, ɔ sinlin bɛ́ nwʋn kpa. ");
INSERT INTO any_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Ɛhɩ a, Zozi totualɩ bɛ́ kɛ nán bɛ kan ɛjɔlɛ sɔ'n bɛ kele sʋanlan fɩ́ɩ́. Ɛsɛ yɩ́ nwan: “Bɛ mán talua'n like lí.” ");
INSERT INTO any_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Ɛhɩ anzin, Zozi fi ɛbɛlɛ yɩ́ nʋan y'ɔ le yɩ́ kulo Nazalɛtɩ. Mɔ ɔ 'kɔ'n, yɩ́ menian'n-mɔ nʋn yɩ́ yɛ̂ bɛ hɔlɩ ɔ. ");
INSERT INTO any_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Mɔ ɛnwʋnmɩan ele cɩan'n juli'n, Zozi hɔlɩ Zufʋ'n-mɔ asɔnɩn sua nɩn anun ɔ hanlɩn Nyanmɩan Anʋan Ɛjɔlɛ'n ɔ helelɩ bɛ́. Anɩn menian dɔʋn wɔ sua nɩn anun. Ɛjɔlɛ mɔ Zozi hanlɩn mɔ bɛ tɩlɩ'n sinlin bɛ́ nwʋn. Bɛ kɔ bisa bisa bɛ́ nwʋn kɛ: “Nan ɔ nʋn ɛhɩ fi nin? Ninhan yɛ̂ ɔ nyanlɩn yɩ́ ngɛlɛ ɛhɩ ɔ? Ɔ yɔ sɛ mɔ ɔ yɔ asinbɛnwʋn ninnge sʋa ɔ? ");
INSERT INTO any_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Nán Mali awa'n m'ɔ di tabʋa junman nɩn ɔ? Nán yɩ́ nianman-mɔ y'ɔ le Zʋakɩ nʋn Zozʋ, nʋn Zudɩ nʋn Simʋn ɔ? Nán yɩ́ nianman mmala'n-mɔ yɛ̂ bɛ wɔ yɛ́ afian ɛwa nɩn ɔ?” Zozi ɛsɩɛ mɔ bɛ sɩ yɩ́ nɩn ati, b'a nne man yɩ́ b'a nni man. ");
INSERT INTO any_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Mɔ Zozi nwunlin yɩ́ sɔ'n, yɩ́ nwan: “Bɛ bu Nyanmɩan kpɔmanfʋɛ biala sʋanlan lɩka kʋalaa. Nan yɩ́ muonun yɩ́ kulo nɩn asʋ menian'n-mɔ nʋn yɩ́ nvilie'n-mɔ yɛ̂ bɛ mmu man yɩ́ sʋanlan ɔ.” ");
INSERT INTO any_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Kɛ ɔ yɔlɩ sɔ'n, Zozi a ngʋala man asinbɛnwʋn like fɩ́ɩ́ yɔ wɔ ɛbɛlɛ. Nwuluwafʋɛ ngʋkʋn ngʋkʋn ala yɛ̂ ɔ falɩ yɩ́ sa'n ɔ fualɩ bɛ́ nwʋn maan bɛ tɩlɩ akpɔlɛ ɔ. ");
INSERT INTO any_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Ɔ sinlin Zozi anwʋn kɛ yɩ́ kulo nɩn asʋ menian'n-mɔ nne yɩ́ bɛ nni man. Ɛhɩ anzin, Zozi kɔ hɔ Galile kulo kulo'n-mɔ asʋ ɔ kɔ han Nyanmɩan Anʋan Ɛjɔlɛ'n ɔ kɔ hele bɛ́. ");
INSERT INTO any_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Yɩ́ nzin, ɔ kɔ fɛlɛ yɩ́ menian bulu nʋn nnyuan'n ɔ kɔ sʋan bɛ́ nnyuan nnyuan. Ɔ kɔ man bɛ́ tunmin kɛ bɛ fá bɛ tú wawɛ ɛtɛ'n-mɔ. ");
INSERT INTO any_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Mɔ bɛ 'ba hɔ'n, yɩ́ nwan: “Kɛ ɛmɔ lɛ kɔ'n, nán bɛ fa like fɩ́ɩ́ bɛ sa bɛ́ nwʋn. Nán bɛ fa kpaʋn, nán bɛ fa bɔ́lɛ, nán bɛ fa esika bɛ sa bɛ́ nwʋn. Nan ɛmɔ fá bɛ́ kpɔman nɩn ala bɛ tíla. ");
INSERT INTO any_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Ɛmɔ wúla mgbabʋa, nan kʋsʋ nán bɛ wula taladɩɛ nnyuan.” ");
INSERT INTO any_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Ɔ kɔ han kɔ hele bɛ́ biekun kɛ: “Kulo biala mɔ ɛmɔ kɔ hɔ sʋ'n, awulo mɔ bɛ kɔ sike ɛmɔ nun'n, ɛmɔ tánlan nun ɛbɛlɛ dede maan ɔ jú ɛmɔ ɛhɔlɛ cɩan. ");
INSERT INTO any_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Kulo biala mɔ ɛmɔ kɔ ju sʋ, mɔ bɛ ngulo man kɛ bɛ sike ɛmɔ anaan bɛ tie ɛmɔ ɛjɔlɛ'n, ɛmɔ wʋ́sʋ bɛ́ ja nɩn abʋ anyʋan'n bɛ gúa ɛbɛlɛ bɛ hɔ́. Ɔ tɩ adanzɩɛ elie kɛ bɛ ngʋala man ɛmɔ sʋnmʋɛ bɔ.” ");
INSERT INTO any_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Ɛhɩ, Zozi menian bulu nʋn nnyuan'n hɔlɩ bɔlɩ Ɛjɔlɛkpa'n bɛ helelɩ menian'n-mɔ kɛ bɛ káci bɛ́ abalabɔ'n nán bɛ fá bɛ́ nwʋn bɛ mán Nyanmɩan. ");
INSERT INTO any_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Bɛ fʋanlɩn wawɛ ɛtɛ dɔʋn. Bɛ manlɩn nwuluwafʋɛ dɔʋn tɩlɩ akpɔlɛ. Abɛlɛ mɔ bɛ 'ba maan bɛ tɩ akpɔlɛ'n, bɛ di mʋa bɛ kpʋkpa bɛ́ *olivʋ ngɔ kʋalaaka. ");
INSERT INTO any_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Ɛhɩ, Zozi dunman'n hɔlɩ mʋa. Tɛmʋn sɔ'n, anɩn Elɔdɩ tɩ Galile mân nɩn asʋ belemgbin. Ɔ kɔ tɩ Zozi angan. Menian'n mmie-mɔ nwan: “Zʋan Batisi m'ɔ wuli'n yɛ̂ ɔ'a hɩn nɩn ɔ. Yɩ́ ti yɛ̂ ɔ man ɔ kʋala ɔ yɔ asinbɛnwʋn ninnge sʋa nɩn ɔ.” ");
INSERT INTO any_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Mmie-mɔ kʋsʋ nwan: “Nyanmɩan kpɔmanfʋɛ'n mɔ bɛ fɛlɛ yɩ́ Eli'n, yɩ́ ɔ.” Mmiekun-mɔ kʋsʋ nwan: “Nán sʋanlan ngacile ɔ, nan ɔ tɩ Nyanmɩan kpɔmanfʋɛ kɛ daba dɩɛ'n-mɔ ala.” ");
INSERT INTO any_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Nan mɔ belemgbin Elɔdɩ tɩlɩ ɛjɔlɛ sɔ'n, yɩ́ nwan: “Zʋan Batisi mɔ m man bɛ kpɛlɩ yɩ́ ti'n, yɩ́ dein yɛ̂ ɔ'a hɩn nɩn ɔ.” ");
INSERT INTO any_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Afɩ belemgbin Elɔdɩ muonun man bɛ hyɩlɩ Zʋan bɛ tʋlɩ yɩ́ fiadɩ Elodiadɩ dunman nun. Elodiadɩ tɩ Elɔdɩ anianman belenzua'n mɔ bɛ fɛlɛ yɩ́ Filipʋ nɩn ayɩ. Elɔdɩ kɔ tʋa yɩ́ kɔ le ɔ kɔ ja. ");
INSERT INTO any_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Nan mɔ Zʋan nwunlin yɩ́ sɔ'n, ɔ kɔ han kɔ hele Elɔdɩ kɛ: “Nannan, Nyanmɩan mala'n mman man wɔ́ atɩn kɛ ɛ fá wɔ́ nianman nɩn ayɩ'n já.” ");
INSERT INTO any_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Zʋan ɛjɔlɛ sɔ'n ngɔ yɔ Elodiadɩ fɛ fɩ́ɩ́. Ɔ kɔ fa Zʋan anwʋn ɛkpɔ. Ɔ kulo kɛ ɔ man bɛ kun Zʋan, kʋsʋ Elɔdɩ dunman nun, ɔ nnwun man kɛ ɔ kpɩn yɔ ɔ. ");
INSERT INTO any_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Afɩ Elɔdɩ fɛlɩ Zʋan kpa. Ɔ sɩ kɛ Zʋan tɩ sɛsɛfʋɛ ɛsɛ ɔ tɩ anwʋntɩɛ sʋanlan. Ɔ nɩan Zʋan asʋ. Mɛlɛ mɔ Zʋan hanlɩn ɛjɔlɛ'n m'ɔ tɩlɩ'n, ɛjɔlɛ sɔ'n jɩjɩlɩ yɩ́ kpa. Kʋsʋ afɩ, ɔ le fɛ elie ɔ tie ɛjɔlɛ'n mɔ Zʋan kan'n. ");
INSERT INTO any_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Yɩ́ sɔ ɛhɩ anun, bɛ wɔ ɛbɛlɛ dede cɩan kʋn, Elɔdɩ awɔlɛ cɩan nɩn anwʋn fɛtɩ mɔ bɛ di yɩ́ afʋɛ nʋan'n kɔ ju. Anɩn afɩ sian'n Elodiadɩ a nyan Zʋan anwʋn atɩn. Mɔ cɩan sɔ'n juli'n, Elɔdɩ kɔ tʋ tɔbɩlɩ kɔ yia yɩ́ abɩlɩba mgbili mgbili'n-mɔ ɔ nʋn yɩ́ nzalafʋ mgbain'n-mɔ ɔ nʋn Galile mân nɩn anun mgbain'n-mɔ yɩ́ awulo ɛbɛlɛ. ");
INSERT INTO any_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Tɛmʋn mɔ Elɔdɩ nʋn yɩ́ mgbain'n-mɔ gua tɔbɩlɩ nɩn anwʋn bɛ 'didi'n, Elodiadɩ awa balasua'n kɔ wʋlʋ lɩka mɔ bɛ gua'n, ɔ kɔ si abile maan ɔ kɔ yɔ bɛ́ kʋalaa bɛ́ ɛnyɩnmɩn. Elɔdɩ kɔ jasʋ, yɩ́ nwan: “Mɩ́n wa, nyanmɩnsɛmʋn, wɔ́ abile nɩn a yɔ mɩ́n ɛnyɩnmɩn sʋnman. Yɩ́ ti, like biala mɔ ɛ kulo'n, bisa maan n vá m mán wɔ́.” ");
INSERT INTO any_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Ɔ kɔ han ndâ kɔ tʋ sʋ kɛ: “Mɩn kan ɛwa kɛ sɛ mɩ́n belemgbin mân'n muonun ebue yɛ̂ ɛ kulo a, mɩn 'fa mɩn man wɔ́.” ");
INSERT INTO any_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Ɛhɩ a, talua'n kɔ fite kɔ hɔ kɔ tʋ yɩ́ nin. Yɩ́ nwan: “Ayia, mɩ́n sɩ nwan abile'n mɔ m'an si nɩn a yɔ yɩ́ ɛnyɩnmɩn. Ɔ'a han ndâ kɛ like biala mɔ mɩn 'kpʋnndɛ'n, ɔ 'fa man mɩ́n. Yɩ́ ti, nzu yɛ̂ n né ɔ?” Ɛbɛlɛ ala, yɩ́ nin nwan: “Kɔ se wɔ́ sɩ kɛ ɛ 'de Zʋan Batisi ati'n.” ");
INSERT INTO any_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Yɩ́ nin anʋan ngɔ tɔ man bɔbɔ, ndɛ-ndɛ talua'n kɔ hɔ kɔ tʋ yɩ́ sɩ, yɩ́ nwan: “Baba, mɩn kulo kɛ ɛ fa Zʋan Batisi ati'n tʋ apawa nun man mɩ́n kɩkaala.” ");
INSERT INTO any_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Mɔ Elɔdɩ tɩlɩ yɩ́ sɔ'n, yɩ́ lʋa kɔ bɔ yɩ́ nwʋn kpa. Nan kʋsʋ ndâ'n m'ɔ hanlɩn wɔ yɩ́ mgbain'n-mɔ anyunnun ɛbɛlɛ nɩn ati, ɔ ngɔ hʋala man yɩ́ nʋan kaci. ");
INSERT INTO any_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Ɛbɛlɛ ala, ɔ kɔ sʋan yɩ́ nzalafʋ'n-mɔ nunhan kʋn kɛ ɔ hɔ́ fiadɩ sua nɩn anun ɛlɔ, ɔ hɔ́ kpɛ́ Zʋan Batisi ati'n ɔ fá bɛ́lɛ yɩ́. ");
INSERT INTO any_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Nzalafʋ'n kɔ hɔ fiadɩ sua nɩn anun. Ɔ kɔ hɔ kɔ kpɛ Zʋan ati'n ɔ kɔ tʋ yɩ́ apawa nun ɔ kɔ bɛlɛ talua'n. Talua'n kɔ le, ɔ kɔ fa kɔ hɔ kɔ man yɩ́ nin. ");
INSERT INTO any_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Mɔ Zʋan menian'n-mɔ tɩlɩ yɩ́ sɔ'n, bɛ walɩ falɩ yɩ́ fuin'n bɛ hɔlɩ sielɩ yɩ́. ");
INSERT INTO any_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Ɛhɩ, Zozi menian bulu nʋn nnyuan'n m'ɔ sʋanlɩn bɛ́ Galile mân nɩn anun'n hɔlɩ walɩ, bɛ kɔ yia Zozi anwʋn ɛbɛlɛ. Mɔ bɛ yɔlɩ o, mɔ bɛ hehelelɩ o, bɛ kɔ bɔ yɩ́ kʋalaa anun amannɩɛ bɛ kɔ hele yɩ́. ");
INSERT INTO any_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Menian'n-mɔ mɔ bɛ ba Zozi anwʋn'n sʋnlɩn sʋnman. Mmie-mɔ lɛ ba, anɩn mmie-mɔ lɛ kɔ. Ɔ man Zozi nʋn yɩ́ mmɔfʋɛ'n-mɔ nnyan man alaje bɔbɔ mɔ bɛ fa bɛ di like ɔ. Ɛhɩ ati, Zozi kɔ han kɔ hele yɩ́ menian'n-mɔ kɛ: “Ɛmɔ mán yɛ tɩ́ yɛ́ nwʋn yɛ hɔ́ ahanmɩan, nán ɛmɔ lé bɛ́ ɛnwʋnmɩan kaan.” ");
INSERT INTO any_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Mɔ Zozi hanlɩn sɔ yuelɩ'n, bɛ kɔ hɔ kɔ fʋ ɛlɛɛ kʋn anun, bɛ kɔ hɔ ahanmɩan, lɩka mɔ sʋanlan fɩ́ɩ́ nnʋn man'n. ");
INSERT INTO any_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Mɔ bɛ 'kɔ'n, menian dɔʋn kpa nwunlin bɛ́. Bɛ kɔ fa asɩ atɩn dɩɛ'n. Bɛ fi kulo'n-mɔ kʋalaa asʋ bɛ le ɛnwanndie. Bɛ kɔ li mʋa lɩka mɔ Zozi nʋn yɩ́ menian'n-mɔ tʋlɩ bɛ́ ti'n. ");
INSERT INTO any_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Mɔ Zozi fi ɛlɛɛ nɩn anun 'ju'n, ɔ kɔ nwun menian dɔʋn kpa ɛbɛlɛ. Bɛ́ nwʋn kɔ yɔ yɩ́ anwunnvoe. Afɩ bɛ tɩ kɛ mmʋa mɔ bɛ le man ɛnɩanfʋɛ ɔ. Ɛbɛlɛ ala, ɔ kɔ hehele bɛ́ ninnge dɔʋn. ");
INSERT INTO any_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Mɔ alɩ́ɛ'n yɔlɩ bie'n, yɩ́ menian'n-mɔ kɔ kpunnge yɩ́ nwʋn ɛbɛlɛ, bɛ́ nwan: “Yɛ́ Mɩn, alɩ́ɛ'n lɛ yɔ, ɛsɛ lɩka mɔ yɛ wɔ'n kʋsʋ tɩ yɩ́ nwʋn. ");
INSERT INTO any_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Yɩ́ ti, yaci bɛ́ nun maan bɛ hɔ́ nanmue'n-mɔ nʋn kulo'n-mɔ mɔ bɛ mantan mantan ɛwa'n-mɔ asʋ bɛ hɔ́ kpʋ́nndɛ like bɛ tó bɛ lí.” ");
INSERT INTO any_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Mɔ bɛ hanlɩn ɛjɔlɛ sɔ'n, Zozi nwan: “Ɛmɔ muonun mán bɛ́ like lí.” Yɩ́ menian'n-mɔ nwan: “Nzu? Man yɛ hɔ́ tó kpaʋn bɔbɔ esika jɛtɛ ɛya nnyuan an, ɔ nza man like fɩ́ɩ́ yɔ.” ");
INSERT INTO any_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Mɔ bɛ hanlɩn sɔ'n, Zozi kɔ bisa bɛ́ kɛ: “Kpaʋn nyɛ yɛ̂ ɛmɔ le ɔ? Ɛmɔ hɔ́ nɩ́an.” Bɛ hɔlɩ bɛ walɩ a, bɛ́ nwan: “Yɛ le kpaʋn nnun nʋn ejue nnyuan.” ");
INSERT INTO any_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Mɔ bɛ hanlɩn sɔ'n, Zozi kɔ han kɔ hele bɛ́ kɛ bɛ mán meninsʋnman'n kʋalaatin tɛ́tanlan asɩ kpule kpule ndile nɩn asʋ. ");
INSERT INTO any_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Ɛhɩ a, bɛ kɔ tɛtanlan asɩ kpule ɛya ɛya, ɔ nʋn kpule abulanun abulanun. ");
INSERT INTO any_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Mɔ bɛ tanlanlɩn asɩ yuelɩ'n, Zozi kɔ le kpaʋn nnun'n, ɔ nʋn ejue nnyuan'n. Ɔ kɔ tʋ yɩ́ nyɩn anwunno, ɔ kɔ la Nyanmɩan asɩ. Ɔ kɔ bubu kpaʋn'n-mɔ anun ɔ kɔ man yɩ́ menian'n-mɔ kɛ bɛ hyé bɛ mán meninsʋnman'n. Ɔ kɔ fa ejue nnyuan'n ɔ kɔ man bɛ́ kɛ bɛ hyé bɛ mán bɛ́ kʋalaatin. ");
INSERT INTO any_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Bɛ́ kʋalaa bɛ kɔ li dede bɛ́ kʋ kɔ yi, bie kɔ ha. ");
INSERT INTO any_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","M'ɔ halɩ'n, bɛ sɩsalɩ dede a, ɔ tɩ ece mma bulu nʋn nnyuan. Ejue'n kʋsʋ bie halɩ. ");
INSERT INTO any_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Bɛ́ mɔ bɛ lili kpaʋn sɔ'n, bɛ tɩ menian akpɩɩ nnun. B'a nga man mmalasua nʋn mmatʋnman'n-mɔ bie. ");
INSERT INTO any_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Ɛhɩ, meninsʋnman'n yuelɩ like di ɛbɛlɛ ala, Zozi kɔ han kɔ hele yɩ́ menian'n-mɔ kɛ: “Ɛmɔ fʋ́ ɛlɛɛ nɩn anun bɛ kpɛ́ asue'n bɛ lí mʋa Bɛtɩsayida ɛlɔ. Mɩn 'gua menian'n-mɔ atɩn kʋalaaka nán m'an a.” ");
INSERT INTO any_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Kɛ Zozi gualɩ menian'n-mɔ atɩn yuelɩ'n, ɔ kɔ hɔ asɔnɩn ɛyɔlɛ bʋka kʋn asʋ. ");
INSERT INTO any_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Mɔ alɩ́ɛ'n sanlɩn'n, anɩn ɛlɛɛ nɩn a ju asue nɩn afian. Zozi angʋnmɩn cein jin asɩ ɛbɛlɛ. ");
INSERT INTO any_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Ɔ 'nɩan an, anɩn yɩ́ menian'n-mɔ ngʋala man ɛlɛɛ'n kan kpa. Ɔ sanlɩn kɛ bɛ nʋn asutue nɩn a yia nun. Ɛhɩ a, alɩbahɩan dɔɛ nsan mɔ ɔ 'kɔ dɔɛ nsian'n, Zozi kɔ nanndɩ asue nɩn anyɩnsʋ ɔ kɔ kpʋ bɛ́. M'ɔ walɩ dede m'ɔ ka kaan tʋ bɛ́'n, ɔ yɔlɩ kɛ ɔ lɛ san bɛ́ nwʋn. ");
INSERT INTO any_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Nan mɔ bɛ nwunlin kɛ ɔ nanndɩ asue nɩn anyɩnsʋ'n, bɛ bu kɛ ɛnwʋnmɩn ɔ. Bɛ kɔ tɛtɩan. ");
INSERT INTO any_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Esulo hanlɩn bɛ́, ɔ sanlɩn kɛ bɛ́ kʋalaatin bɛ́ nwunlin yɩ́. Ɛbɛlɛ ala, Zozi kɔ han kɔ hele bɛ́ kɛ: “Ɛmɔ gúa bɛ́ ahʋnlɩn asɩ! Nán bɛ sulo nan mɩ́n ɔ!” ");
INSERT INTO any_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Kɛ ɔ hanlɩn sɔ mɔ ɔ 'fʋ bɛ ɛlɛɛ nɩn anun ala, asutue'n kɔ gua asɩ. Zozi nyɔlɩɛ sɔ'n kɔ sin bɛ́ nwʋn kpa. ");
INSERT INTO any_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Afɩ asinbɛnwʋn like'n mɔ Zozi falɩ kpaʋn'n yɔlɩ'n, b'a ndɩ man yɩ́ bʋ. Ɔ sanlɩn kɛ b'a nva man bɛ́ ajʋnlɩn b'a nza man sʋ. ");
INSERT INTO any_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Kɛ bɛ kpɛlɩ asue'n mɔ bɛ juli Zenezalɛtɩ mân nɩn anun'n, bɛ kɔ si asɩ, bɛ kɔ mɩnnda bɛ́ ɛlɛɛ'n. ");
INSERT INTO any_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Mɔ bɛ fi ɛlɛɛ nɩn anun bɛ juli'n, ɛbɛlɛ ala, menian'n-mɔ kɔ nwun kɛ Zozi ɔ. ");
INSERT INTO any_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Bɛ kɔ nwanndi bɛ kɔ hɔ lɩka kʋalaatin bɛ kɔ hɔ kɔ bɔ menian'n-mɔ kʋalaa amannɩɛ. Lɩka biala mɔ bɛ kɔ tɩ kɛ Zozi wɔ'n, bɛ sʋa nwuluwafʋɛ'n-mɔ ɛbɛɛ sʋ bɛ bɛlɛ yɩ́. ");
INSERT INTO any_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Lɩka biala m'ɔ kɔ hɔ'n, nanmue nun o, kulo baa asʋ o, kulo kpili asʋ o, bɛ fa nwuluwafʋɛ'n-mɔ bɛ sesie anʋan'n-mɔ anyunnun gua'n-mɔ asʋ. Bɛ sɛlɛ Zozi kɛ ɔ mán bɛ́ atɩn maan bɛ hán yɩ́ taladɩɛ nɩn anʋan nɩn ala. Sakpa, bɛ́ kʋalaa mɔ bɛ kɔ han yɩ́'n, bɛ́ nwʋn sa. ");
INSERT INTO any_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Ɛhɩ, Falisifʋɛ mmie-mɔ nʋn mala nɩn asʋ mgbain mmie-mɔ fi Zoluzalɛmʋn bɛ walɩ yialɩ Zozi anwʋn ɛbɛlɛ. ");
INSERT INTO any_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Bɛ nwunlin yɩ́ menian'n mmie-mɔ kɛ bɛ 'di like a, bɛ nnwunnzin man bɛ́ sa nɩn anun bɛ ndu man bɛ́ nwʋn efian kɛ bɛ́ mala'n kele'n. ");
INSERT INTO any_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Afɩ, Falisifʋɛ'n-mɔ nʋn Zufʋ'n-mɔ kʋalaa, bɛ di bɛ́ nan-mɔ mala sɔ nɩn asʋ kpa. Sɛ bɛ 'ba li like a, bɛ tʋ bɛ́ ahʋnlɩn asɩ bɛ nwunnzin bɛ́ sa nɩn anun kpa bɔkɔɔ. ");
INSERT INTO any_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Ɛsɛ like mɔ bɛ kɔ to yɩ́ gua nun mɔ bɛ 'ba li'n, sɛ bɛ nwunnzinlin man bɛ́ sa nɩn anun bɛ tuli man bɛ́ nwʋn efian an, bɛ nni man. Bɛ le daba mala dɔʋn mɔ bɛ di sʋ sɛlɛ kpa kɛ kangɔ nʋn bua ɔ nʋn daansɛ'n-mɔ anun enwunnzian. ");
INSERT INTO any_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Ɛhɩ a, Falisifʋɛ'n-mɔ nʋn mala nɩn asʋ mgbain'n-mɔ kɔ bisa Zozi kɛ: “Mala mɔ yɛ́ nan-mɔ a hyɩhyɛ a tʋ ɛbɛlɛ'n, nzukɛ ati yɛ̂ wɔ́ menian'n-mɔ nni man sʋ mɔ bɛ le bɛ́ sa nɩn anun efian'n bɛ lɛ didi'n?” ");
INSERT INTO any_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Mɔ Zozi tɩlɩ bɛ́ kosuan sɔ'n, yɩ́ nwan: “Apoo mma, ɛmɔ anwʋn ɛjɔlɛ'n mɔ Nyanmɩan kpɔmanfʋɛ Ezayi hanlɩn yɩ́ daba'n tɩ ananhɔlɛ. Ezayi hɛlɛlɩ yɩ́ kɛ: Menian ɛhɩ-mɔ le bɛ́ nʋan tuin mgban yɛ̂ bɛ yɩ mɩ́n ayɛ ɔ, nan bɛ́ ahʋnlɩn'n nnʋn man mɩ́n sʋ. ");
INSERT INTO any_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Ɛsʋɛ'n mɔ bɛ sʋ mɩ́n'n tɩ mgban. Ɔ sanlɩn kɛ kulo sʋanlan mala yɛ̂ bɛ kekele ɔ, nan nán Nyanmɩan dɩɛ nɩn ɔ.” ");
INSERT INTO any_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Zozi nwan: “Ɛmɔ nni man Nyanmɩan mala dɩɛ nɩn asʋ nan kulo menian'n-mɔ dɩɛ nɩn asʋ yɛ̂ ɛmɔ di ɔ.” ");
INSERT INTO any_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Ɛsɛ Zozi kɔ han biekun kɔ tʋ sʋ. Yɩ́ nwan: “Ɛmɔ a fa bɛ́ mala dɩɛ'n b'a nunnun Nyanmɩan dɩɛ nɩn abʋsʋ. ");
INSERT INTO any_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Ɛhɩ anwʋn, Moyizɩ hanlɩn kɛ: Man wɔ́ nyɩn sɔ́ wɔ́ sɩ nʋn wɔ́ nin. Ɛsɛ ɔ hanlɩn yɩ́ biekun kɛ: Sʋanlan m'ɔ kɔ han ɛjɔlɛ ɛtɛ kɔ tia yɩ́ sɩ nʋn yɩ́ nin'n, sʋanlan sɔ'n, ɔ fata kɛ bɛ kun yɩ́. ");
INSERT INTO any_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Nan ɛmɔ dɩɛ, ɛmɔ nwan sɛ sʋanlan kʋn kan kele yɩ́ sɩ nʋn yɩ́ nin kɛ: ‘Like mɔ n ne yɩ́ mɔ n gɔ fa n gɔ bʋka ɛmɔ'n, ɔ tɩ kɔɔban’ (yɩ́ bʋ y'ɔ le kɛ m'an fa m'an hye Nyanmɩan), ");
INSERT INTO any_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","sʋanlan sɔ'n, ɛmɔ mman man yɩ́ atɩn ɔ nyɔ man like fɩ́ɩ́ kʋ́n mman man yɩ́ sɩ nʋn yɩ́ nin. ");
INSERT INTO any_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Ɛmɔ yɔ sɔ bɛ nunnun Nyanmɩan mala nɩn abʋsʋ ɛmɔ di bɛ́ dɩɛ'n-mɔ asʋ. Ɛsɛ bɔbɔ ɛmɔ yɔ ninnge dɔʋn mmiekun-mɔ m'ɔ nvata man ɔ.” ");
INSERT INTO any_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Mɔ Zozi hanlɩn sɔ yuelɩ'n, ɔ fɛlɛlɩ meninsʋnman'n yɩ́ nwʋn biekun an, yɩ́ nwan: “Bɛ́ kʋalaa bɛ tíe mɔ mɩɩn kan'n bɛ tɩ́ yɩ́ bʋ. ");
INSERT INTO any_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Like fɩ́ɩ́ nnʋn man ɛbɛlɛ m'ɔ kan sʋanlan nʋan, ɔ man efian gua yɩ́ nwʋn ɔ. Nan ɛjɔlɛ ɛtɛ m'ɔ fi yɩ́ nʋan kɔ fite'n yɛ̂ ɔ man efian gua yɩ́ nwʋn ɔ.  ");
INSERT INTO any_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","M'ɔ sɩ fasie'n, ɔ fá síe kpa!” ");
INSERT INTO any_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","M'ɔ hanlɩn sɔ yuelɩ m'ɔ fi bagua nɩn anun ɔ fitelɩ ɔ hɔlɩ awulo'n, yɩ́ menian'n-mɔ kɔ bisa yɩ́ anyɩnndala sɔ'n m'ɔ buli nɩn abʋ. ");
INSERT INTO any_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Ɛhɩ a, Zozi kɔ bua bɛ kɛ: “Yɩ́ ti, ɛmɔ kʋsʋ nzɩ man ngɛlɛ ɔ? Ɛmɔ ndɩ man yɩ́ bʋ kɛ like biala mɔ sʋanlan kɔ li'n, ɔ ngʋala man yɩ́ nwʋn efian gua ɔ? ");
INSERT INTO any_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Ɔ sanlɩn kɛ like mɔ sʋanlan kɔ li'n, ɔ ngɔ man yɩ́ ahʋnlɩn nɩn anun. Nan ɔ kɔ yɩ́ kunnun yɛ̂ ɔ je gua.” (Ɔ nanndɩ ɛjɔlɛ ɛhɩ asʋ, Zozi kɔ hele bɛ́ kɛ like biala m'ɔ tɩ mɔ bɛ di'n, yɩ́ nwʋn tɩ.) ");
INSERT INTO any_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Ɛsɛ yɩ́ nwan: “Nan ɛjɔlɛ ɛtɛ m'ɔ fi sʋanlan ahʋnlɩn nun kɔ fite'n yɛ̂ ɔ gua yɩ́ nwʋn efian ɔ. ");
INSERT INTO any_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Afɩ sʋanlan ahʋnlɩn nɩn anun yɛ̂ ajʋnlɩn ɛtɛ'n kʋalaa fi ɔ: satɩlɩfʋɛ ɛyɔlɛ, awue, kodiawu, ");
INSERT INTO any_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","ajaa ɛtʋan, anyɩnbʋlʋ, ati anun ɛtɛ ɛyɔlɛ, nnaka, basa-basa ɛyɔlɛ, nyunnunngunlan, dunmannzɛcɩɛ, atubɛnwʋn, kʋasɩanzɛmʋn. ");
INSERT INTO any_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Ninnge ɛtɛ ɛtɛ ɛhɩ-mɔ kʋalaa m'ɔ fi sʋanlan nun fite'n, bɛ́ yɛ̂ bɛ gua yɩ́ nwʋn efian ɔ.” ");
INSERT INTO any_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Ɛhɩ anzin, Zozi anʋan y'ɔ le Silifeninsi mân nun. Lɩka m'ɔ juli'n mantan kulo kʋn. Kulo sɔ'n, bɛ fɛlɛ yɩ́ Tii. Ɔ ngulo man kɛ bɛ tɩ yɩ́ ngan. Yɩ́ ti, ɔ kɔ hɔ kɔ wʋlʋ awulo kʋn anun. Nan kʋsʋ ɔ'a ngʋala man fɩa. ");
INSERT INTO any_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Afɩ anɩn balasua kʋn wɔ ɛbɛlɛ, wawɛ ɛtɛ wɔ yɩ́ wa talua nɩn anun. Ɔ kɔ tɩ Zozi angan. Ɔ kɔ a kɔ tʋ Zozi ɔ kɔ tu kɔ tɔ yɩ́ ja nun. ");
INSERT INTO any_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Balasua sɔ'n tɩ man Zufʋ. Bɛ wʋlɩ yɩ́ Silifeninsi mân nun. Ɔ tɩ *gɛlɛkɩ. Ɔ kɔ sɛlɛ Zozi kɛ ɔ tú wawɛ ɛtɛ'n m'ɔ wɔ yɩ́ wa talua nɩn anun'n. ");
INSERT INTO any_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Mɔ bala'n hanlɩn sɔ'n, Zozi kɔ bua yɩ́ kɛ: “Nwʋnndɛ maan mmatʋnman'n-mɔ didi kʋalaaka. Afɩ, ɔ nvata man kɛ bɛ ju mmatʋnman'n-mɔ alɩɛ'n bɛ gua bɛ man njʋa'n-mɔ di ɔ.” ");
INSERT INTO any_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Zozi hanlɩn sɔ a, balasua'n nwan: “Ɔ tɩ ananhɔlɛ, yɛ́ Mɩn. Nan kʋsʋ mmatʋnman'n-mɔ alɩɛ nɩn abʋ mgbʋkpʋlʋka'n m'ɔ kɔ yɩyɩ kɔ gua tɔbɩlɩ nɩn abʋ'n yɛ̂ njʋa'n-mɔ di ɔ.” ");
INSERT INTO any_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Mɔ Zozi tɩlɩ yɩ́ mmua sɔ'n, yɩ́ nwan: “Wɔ́ nʋan ɛjɔlɛ nɩn ati, sa kɔ, nan wawɛ ɛtɛ'n fi wɔ́ wa nɩn anun ɔ'a tu.” ");
INSERT INTO any_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Sakpa kʋsʋ, balasua'n fi ɛbɛlɛ ɔ 'kɔ a ju a, yɩ́ wa'n la mgba nɩn asʋ, wawɛ ɛtɛ'n fi yɩ́ nun a tu. ");
INSERT INTO any_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Ɛhɩ anzin, Zozi fi kulo'n mɔ bɛ fɛlɛ yɩ́ Tii nɩn afan ɔ kɔ sɩn Sidʋn kulo nɩn afan, ɔ kɔ sa kɔ a Galile asue nɩn anʋan. Mɔ ɔ 'sa ba'n, ɔ kpɛlɩ nun mân'n mɔ bɛ fɛlɛ yɩ́ Kulo Bulu nɩn anun. ");
INSERT INTO any_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Ɛbɛlɛ, bɛ kɔ fa amunlefʋɛ anzʋtiliwa kʋn bɛ kɔ bɛlɛ yɩ́ kɛ ɔ fá yɩ́ sa fúa yɩ́ nwʋn maan ɔ tɩ́ akpɔlɛ. ");
INSERT INTO any_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Ɛhɩ a, Zozi kɔ fa wuluwafʋɛ'n bagua nɩn anun ɛbɛlɛ, ɔ nʋn yɩ́ kɔ hɔ ahanmɩan. Bɛ juli ɛlɔ a, ɔ kɔ fa yɩ́ sa mɛsɩka'n kɔ wula amunlefʋɛ nɩn anzʋ'n-mɔ anun kɔ yɩ. Ɛsɛ ɔ kɔ fa yɩ́ nʋan ngɛsɛlɛ'n bie kɔ han amunlefʋɛ'n tofeleman'n. ");
INSERT INTO any_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","M'ɔ yɔlɩ ɛhɩ kʋalaa yuelɩ'n, ɔ kɔ tʋ yɩ́ ti anwunno ɔ kɔ gua ɛnwʋnmɩan asɩ. Yɩ́ nwan: “Ɛfata!” Yɩ́ bʋ y'ɔ le kɛ tike! ");
INSERT INTO any_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Ɛbɛlɛ ala, yɩ́ nzʋ'n-mɔ kɔ tike tike, yɩ́ tofeleman'n kɔ nyannjɩ, ɔ kɔ jʋjɔ yuein-yuein. ");
INSERT INTO any_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Mɔ Zozi yɔlɩ asinbɛnwʋn like sɔ'n yuelɩ'n, ɔ kɔ totua bɛ́ kɛ nán bɛ kan ɛjɔlɛ sɔ'n bɛ kele sʋanlan fɩ́ɩ́. Ɔ 'totua bɛ́ a, anɩn bɛ lɛ kan bɛ kɔ. ");
INSERT INTO any_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Ɛjɔlɛ'n sinlin menian'n-mɔ anwʋn kpa. Bɛ́ nwan: “Like biala m'ɔ kɔ yɔ'n, ɔ yɔ yɩ́ kanlanman kpa! Ɔ man bɛ́ mɔ bɛ́ nzʋ a ti'n tɩ ɛjɔlɛ! Bɛ́ mɔ b'a tɔ amunle'n, ɔ man bɛ jʋjɔ!” ");
INSERT INTO any_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Mɛlɛ sɔ'n, menian dɔʋn yialɩ Zozi anwʋn ɛbɛlɛ biekun. Kɛmɔ bɛ nnyan man like fɩ́ɩ́ bɛ nni man'n, Zozi fɛlɛlɩ yɩ́ menian'n-mɔ a, yɩ́ nwan: ");
INSERT INTO any_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Menian ɛhɩ-mɔ anwʋn yɔ mɩ́n koun. Ɔ sanlɩn kɛ bɛ nʋn mɩ́n wɔ ɛwa yɩ́ cɩan nsan ahɩ, bɛ nnyan man like fɩ́ɩ́ bɛ nni man. ");
INSERT INTO any_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Sɛ mɩn man bɛ́ atɩn kɛ bɛ fá bɛ́ kunnun bɛ sá bɛ hɔ́ a, bɛ 'ba gɔlɔ atunnun. Afɩ bɛ́ nun mmie-mɔ fi mʋa.” ");
INSERT INTO any_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Mɔ Zozi hanlɩn sɔ'n, yɩ́ menian'n-mɔ kɔ bisa yɩ́ kɛ: “Ebo ɛhɩ anun ɛwa, yɛ 'yɔ sɛ nán y'a nyan like y'a man menian nwala ɛhɩ-mɔ a li?” ");
INSERT INTO any_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Zozi kɔ bisa bɛ́ kɛ: “Ɛmɔ le kpaʋn nyɛ?” Bɛ́ nwan: “Yɛ le kpaʋn nsʋ.” ");
INSERT INTO any_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Ɛhɩ a, ɔ kɔ man meninsʋnman'n kɔ tɛtanlan asɩ. Ɔ kɔ fa kpaʋn nsʋ'n, ɔ kɔ la Nyanmɩan asɩ. Ɔ kɔ bubu nun kɔ man yɩ́ menian'n-mɔ kɛ bɛ hyé bɛ mán meninsʋnman'n. Zozi menian'n-mɔ kɔ hye kɔ man bɛ́. ");
INSERT INTO any_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Ɛsɛ anɩn bɛ le ejue nganngan mmiekun-mɔ. Zozi kɔ yeyila sʋ ɔ kɔ han kɔ hele yɩ́ menian'n-mɔ kɛ bɛ hyé bɛ bʋ́ka sʋ. ");
INSERT INTO any_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Bɛ kɔ li dede bɛ́ kʋ kɔ yi. Zozi menian'n-mɔ kɔ sɩsa m'ɔ halɩ'n. Ɔ kɔ yi ece mma nsʋ. ");
INSERT INTO any_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Bɛ́ mɔ bɛ lili like'n, bɛ tɩ kɔ yɔ akpɩɩ nnan. Mɔ bɛ yuelɩ like'n di'n, Zozi kɔ man bɛ́ atɩn maan bɛ kɔ hɔ. ");
INSERT INTO any_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Ɛbɛlɛ ala, ɔ nʋn yɩ́ menian'n-mɔ, bɛ kɔ fʋ ɛlɛɛ nɩn anun bɛ kɔ hɔ mân'n mɔ bɛ fɛlɛ yɩ́ Dalɩmannunta nɩn anun. ");
INSERT INTO any_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Ɛhɩ, *Falisifʋɛ'n-mɔ kɔ a kɔ ju ɛbɛlɛ. Bɛ nʋn Zozi kɔ su akpʋlʋwa. Kɛmɔ bɛ kulo kɛ bɛ sɔ yɩ́ bɛ nɩan'n, bɛ kpʋnndɛ kɛ ɔ yɔ́ asinbɛnwʋn like kʋn m'ɔ kele kɛ yɩ́ tunmin'n fi Nyanmɩan ɛlɔ sakpa. ");
INSERT INTO any_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Zozi kɔ gua ɛnwʋnmɩan asɩ, yɩ́ nwan: “Nzukɛ ati yɛ̂ ajulisʋ menian'n-mɔ kpʋnndɛ asinbɛnwʋn ninnge ɔ? Mɩɩn kan yɩ́ ananhɔlɛ mɩn kele ɛmɔ kɛ bɛ ngɔ yɔ man asinbɛnwʋn like fɩ́ɩ́ bɛ ngɔ hele man ajulisʋ menian'n-mɔ.” ");
INSERT INTO any_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Ɔ hanlɩn sɔ yuelɩ a, ɔ kɔ yaci bɛ́ ɛbɛlɛ. Ɔ kɔ fʋ ɛlɛɛ nɩn anun, ɔ nʋn yɩ́ menian'n-mɔ, bɛ kɔ sa bɛ kɔ kpɛ asue'n bɛ kɔ hɔ yɩ́ nzin ɛlɔ. ");
INSERT INTO any_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Mɔ bɛ 'kpɛ asue'n, Zozi menian'n-mɔ alʋa kɔ fi kpaʋn mɔ bɛ 'fa bɛ sa bɛ́ nwʋn'n. Kpaʋn baa kʋnmgba yɛ̂ anɩn bɛ le yɩ́ bɛ nwʋn ɛbɛlɛ ɛlɛɛ nɩn anun ɔ. ");
INSERT INTO any_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Zozi kɔ tu bɛ́ fʋɔ kɛ: “Ɛmɔ nɩ́an bɛ́ nwʋn kpa wɔ Falisifʋɛ'n-mɔ nʋn Elɔdɩ fali ayile nɩn anwʋn.” ");
INSERT INTO any_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Zozi hanlɩn sɔ a, yɩ́ menian'n-mɔ kɔ han yɩ́ bɛ́ afian ɛlɔ kɛ kpaʋn'n mɔ b'a nva man'n, yɩ́ ti yɛ̂ ɔ man ɔ lɛ kan sɔ ɔ. ");
INSERT INTO any_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Zozi kɔ tɩ, ɔ kɔ bisa bɛ́ kɛ: “Nzukɛ ati yɛ̂ ɛmɔ lɛ kan kɛ: ‘Anɩn kpaʋn'n mɔ y'a nva man nɩn ati ɔ’? Yɩ́ ti, ɛmɔ nzɩ man fasie bɛ ndɩ man ɛjɔlɛ bʋ ɔ? Ɛmɔ ajʋnlɩn nza man ɛmɔ ɔ? ");
INSERT INTO any_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Anyɩan'n mɔ ɛmɔ le yɩ́'n, ɛmɔ nnwun man asɩ ɔ? Anzʋɛ'n mɔ ɛmɔ le yɩ́'n, ɛmɔ ndɩ man ɛjɔlɛ ɔ? Ɛmɔ ati kácɩ, ");
INSERT INTO any_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","mɛlɛ mɔ m mubuli kpaʋn nnun nɩn anun m manlɩn menian akpɩɩ nnun'n, ɛmɔ sɩsalɩ yɩ́ bʋ ece mma nyɛ?” Bɛ kɔ bua yɩ́ kɛ: “Yɛ sɩsalɩ ece mma bulu nʋn nnyuan.” ");
INSERT INTO any_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Zozi nwan: “Nán mɛlɛ mɔ m mubuli kpaʋn nsʋ nɩn anun m manlɩn menian akpɩɩ nnan'n, ɛmɔ sɩsalɩ yɩ́ bʋ ece mma nyɛ?” Bɛ́ nwan: “Yɛ sɩsalɩ ece mma nsʋ.” ");
INSERT INTO any_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Zozi kɔ bisa bɛ́ kɛ: “Yɩ́ ti, ɛjɔlɛ'n mɔ m'an han'n, ɛmɔ ndɩ man yɩ́ bʋ biekun ɔ?” ");
INSERT INTO any_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Zozi nʋn yɩ́ menian'n-mɔ, bɛ́ nʋan y'ɔ le Bɛtɩsayida. Bɛ juli ɛbɛlɛ a, menian'n-mɔ kɔ fa anyɩnsinlinwafʋɛ kʋn bɛ kɔ bɛlɛ Zozi. Bɛ kɔ sɛlɛ yɩ́ kɛ ɔ fá yɩ́ sa hán wuluwafʋɛ'n maan yɩ́ nyɩn'n tíke. ");
INSERT INTO any_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Zozi kɔ sɔ anyɩnsinlinwafʋɛ nɩn asa ɔ nʋn yɩ́ kɔ hɔ kulo'n tiba. Ɔ kɔ fa yɩ́ nʋan ngɛsɛlɛ kɔ ta wuluwafʋɛ nɩn anyɩn nɩn asʋ. Ɔ kɔ fa yɩ́ sa kɔ fua wuluwafʋɛ nɩn anyɩn'n ɔ kɔ bisa yɩ́ kɛ: “Asʋ ɛ nwun like ɔ?” ");
INSERT INTO any_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Anyɩnsinlinwafʋɛ'n kɔ tike yɩ́ nyɩn'n, yɩ́ nwan: “Mɩn nwun menian'n-mɔ, nan kʋsʋ bɛ tɩtɩ kɛ mmaka mɔ bɛ lɛ nanndɩ ɔ.” ");
INSERT INTO any_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Zozi kɔ fa yɩ́ sa kɔ fua wuluwafʋɛ nɩn anyɩn'n biekun. Mɔ Zozi yɩlɩ yɩ́ sa'n, wuluwafʋɛ'n kɔ nɩan yɩ́ nyunnun fɔ́ʋ́n. Yɩ́ nwʋn kɔ sa ɔ kɔ nwun asɩ kpa bɔkɔɔ. ");
INSERT INTO any_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Ɛhɩ a, Zozi kɔ han kɔ hele yɩ́ kɛ: “Kɔ awulo, kʋsʋ n'ɛ wʋlʋ kulo nɩn anun.” ");
INSERT INTO any_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Ɛhɩ anzin, Zozi nʋn yɩ́ menian'n-mɔ fi Bɛtɩsayida bɛ kɔ hɔ kulo'n-mɔ mɔ bɛ mantan mantan Filipʋ kulo'n mɔ bɛ fɛlɛ yɩ́ Sezale anwʋn ɛbɛlɛ'n-mɔ asʋ. ");
INSERT INTO any_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Mɔ bɛ 'kɔ'n, Zozi kɔ bisa bɛ́ kɛ: “Menian'n-mɔ, bɛ́ nwan nwan sʋanlan dɩɛ y'ɔ le mɩ́n?” Bɛ kɔ bua yɩ́ kɛ: “Mmie-mɔ nwan Zʋan Batisi y'ɔ le wɔ́, mmie-mɔ kʋsʋ nwan Eli y'ɔ le wɔ́, mmiekun-mɔ kʋsʋ nwan Nyanmɩan mgbɔmanfʋɛ'n-mɔ nunhan kʋn y'ɔ le wɔ́.” ");
INSERT INTO any_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Ɛhɩ a, Zozi kɔ bisa bɛ́ kɛ: “Nan ɛmɔ kʋsʋ lɩlɩ, ɛmɔ bu kɛ nwan y'ɔ le mɩ́n?” Pɩɛlɩ nwan: “*Kilisi'n y'ɔ le wɔ́, Izalayɛ Ngʋandefʋɛ'n.” ");
INSERT INTO any_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Mɔ Pɩɛlɩ hanlɩn sɔ'n, Zozi kɔ totua bɛ́ kpa kɛ nán bɛ kan ɛjɔlɛ sɔ'n bɛ kele sʋanlan fɩ́ɩ́. ");
INSERT INTO any_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Ɛhɩ anzin, Zozi kɔ han kɔ hele yɩ́ menian'n-mɔ kɛ: “Ɔ di kɛ mân Baa'n nwun amannɩnhunlun kpa. Izalayɛ mân nɩn asʋ mgbain'n-mɔ nʋn Nyanmɩan tɛɛyɩfʋɛ mgbain'n-mɔ nʋn mala nɩn asʋ mgbain'n-mɔ 'ba yɩ yɩ́ tʋ. Bɛ 'ba hun yɩ́. Bɛ kun yɩ́ a, yɩ́ cɩan nsan nɩn asʋ, ɔ 'tinnge.” ");
INSERT INTO any_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Zozi kɔ han yɩ́ ewue sɔ nɩn anwʋn ɛjɔlɛ yuein kɔ hele yɩ́ menian'n-mɔ. Ɛhɩ, Pɩɛlɩ kɔ fɛlɛ Zozi ahanmɩan ɔ kɔ tu yɩ́ nyunnun. ");
INSERT INTO any_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Zozi kɔ bɩlɩ yɩ́ nyɩn ɔ kɔ nɩan yɩ́ menian bʋ nga'n-mɔ. Ɔ kɔ tu Pɩɛlɩ anyunnun. Yɩ́ nwan: “Satan, fi mɩ́n nwʋn ɛwa kɔ mʋa. Wɔ́ ajʋnlɩn'n tɩ man Nyanmɩan ajʋnlɩn, nan kulo menian ajʋnlɩn yɛ̂ ɛ le yɩ́ ɔ.” ");
INSERT INTO any_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","M'ɔ yɔlɩ sɔ'n, Zozi fɛlɛlɩ meninsʋnman'n nʋn yɩ́ menian'n-mɔ a, yɩ́ nwan: “Sʋanlan m'ɔ kulo kɛ ɔ si mɩ́n sʋ'n, ɔ fá yɩ́ nwʋn yɩ́ tɛɛ, ɔ fá yɩ́ kʋlʋwa'n ɔ tʋ́ yɩ́ kɔmɩn sʋ, nán ɔ'a si mɩ́n sʋ. ");
INSERT INTO any_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Sʋanlan biala m'ɔ kulo kɛ ɔ kpʋnndɛ yɩ́ ngʋan'n, ɔ 'minlin yɩ́ ngʋan sɔ'n. Nan m'ɔ kɔ minlin yɩ́ ngʋan'n wɔ Ɛjɔlɛkpa'n nʋn mɩ́n dunman nun'n, sʋanlan sɔ'n, ɔ 'nyan ngʋan. ");
INSERT INTO any_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Sɛ sʋanlan kʋn nyan eyuadɩ nɩn anun ninnge'n kʋalaa nán ɔ minlin yɩ́ ngʋan nɩn an, anɩn nzukɛ nvasʋɛ dɩɛ yɛ̂ ɔ 'nyan yɩ́ sʋ ɔ? ");
INSERT INTO any_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Nzu like dɩɛ bɔbɔ yɛ̂ kulo sʋanlan kʋala kɛ ɔ fa kaci yɩ́ ngʋan nɩn ɔ? ");
INSERT INTO any_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Ajulisʋ ɛtɛfʋɛ menian ɛhɩ-mɔ mɔ bɛ nzulo man Nyanmɩan'n, bɛ́ afian, wɔ́ mɔ ɛ kɔ sa mɩ́n nʋn mɩ́n ɛjɔlɛ nɩn anwʋn nyian'n, *Mân Baa'n kʋsʋ, mɛlɛ m'ɔ nʋn yɩ́ nyanmɩansʋ anwʋntɩɛ mmɔfʋɛ'n-mɔ 'ba sa bɛ ba Nyanmɩan anunminnyanmʋn nɩn anun'n, wɔ́ nwʋn 'ba yɔ yɩ́ nyian.” ");
INSERT INTO any_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","M'ɔ hanlɩn sɔ yuelɩ'n, ɛsɛ ɔ kɔ han kɔ hele bɛ́ biekun kɛ: “Mɩɩn kan yɩ́ ananhɔlɛ mɩn kele ɛmɔ kɛ, ɛmɔ mɔ b'a yia ɛwa'n, ɛmɔ kʋalaa ngɔ yue man wu. Mmie-mɔ 'ba nwun kɛ Nyanmɩan Kpili lɛ di belemgbin tunmin sʋ.” ");
INSERT INTO any_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Ɛhɩ anzin cɩan nsian, Zozi kɔ fa Pɩɛlɩ nʋn Zʋakɩ nʋn Zʋan. Ɔ nʋn bɛ́ menian nsan nɩn ala bɛ kɔ tɩ bɛ́ nwʋn bʋka kannganlaun kʋn asʋ. Ɛbɛlɛ, Zozi kɔ kaci bɛ́ nyɩnsʋ. ");
INSERT INTO any_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Yɩ́ taladɩɛ'n kɔ yɔ fufue hyɩɛɩn hyɩɛɩn kpa. Yɩ́ hyɩɛɩn sɔ'n, asɩɛ ɛhɩ asʋ sʋanlan fɩ́ɩ́ ngʋala man like fɩ́ɩ́ kpʋ maan ɔ yɔ fufue dede ɔ ju yɩ́ ɔ. ");
INSERT INTO any_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Zozi menian nsan'n 'nɩan an, bɛ kɔ nwun *Eli nʋn *Moyizɩ kɛ bɛ nʋn Zozi lɛ jʋjɔ. ");
INSERT INTO any_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Pɩɛlɩ kɔ han kɔ hele Zozi kɛ: “*Labi, ɔ tɩ kpa kɛ yɛ wɔ ɛwa. Yɛ 'bɔ *tantɩ nsan, wɔ́ dɩɛ kʋn, Moyizɩ dɩɛ kʋn yɛ̂ Eli kʋsʋ dɩɛ kʋn.” ");
INSERT INTO any_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Esulo kɔ han bɛ́, Pɩɛlɩ nnwun man ɛjɔlɛ m'ɔ kan ɔ. ");
INSERT INTO any_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Bɛ jijin ɛbɛlɛ ala, bɔlɛ́ kʋn fi nyanmɩansʋ kɔ a kɔ hala Eli nʋn Moyizɩ nʋn Zozi asʋ. Bɔlɛ́ nɩn anun, anɩɛ kʋn kɔ te. Anɩɛ sɔ'n nwan: “Sʋanlan ɛhɩ tɩ mɩ́n ehulo Baa, ɛmɔ tíe yɩ́!” ");
INSERT INTO any_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Zozi menian'n-mɔ tɩlɩ anɩɛ sɔ nɩn ala, bɛ kɔ tʋtʋ bɛ́ nyɩn, bɛ ngɔ nwun sʋanlan fɩ́ɩ́ kʋ́n, Zozi angʋnmɩn cein yɛ̂ ɔ nʋn bɛ́ wɔ ɛbɛlɛ ɔ. ");
INSERT INTO any_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Nan mɔ bɛ fi bʋka nɩn asʋ bɛ 'ju'n, Zozi kɔ totua bɛ́ kɛ nán bɛ kan ɛjɔlɛ sɔ'n bɛ kele sʋanlan fɩ́ɩ́, dede ɔ jú cɩan mɔ *Mân Baa'n fi ewue nun ɔ kɔ tinnge'n. ");
INSERT INTO any_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Bɛ falɩ m'ɔ hanlɩn helelɩ bɛ́ nɩn asʋ, nan kʋsʋ bɛ lɛ bisa bisa bɛ́ nwʋn bɛ́ afian ɛlɔ kɛ: “Ɔ fi ewue nun ɔ 'tinnge'n, yɩ́ bʋ y'ɔ le benin?” ");
INSERT INTO any_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","M'ɔ yɔlɩ sɔ'n, bɛ kɔ bisa Zozi kɛ: “Nzukɛ ati yɛ̂ mala nɩn asʋ mgbain'n-mɔ nwan Eli yɛ̂ ɔ 'di mʋa ba'n?” ");
INSERT INTO any_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Zozi kɔ bua bɛ́ kɛ: “Eli 'di mʋa ba ɔ sesie ninnge'n-mɔ biekun. Nan ɔ yɔ sɛ mɔ b'a hɛlɛ yɩ́ kɛ, Mân Baa'n 'ba nwun amannɩnhunlun kpa, ɛsɛ bɛ 'kpɔ yɩ́'n? ");
INSERT INTO any_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Afɩ, mɩɩn kan mɩn kele ɛmɔ kɛ Eli a a dada angʋnmɩn. Nan menian'n-mɔ helelɩ yɩ́ yalɛ kɛ bɛ́ kunnun kulo. Kɛ Ɛhɛlɛ Ɛjɔlɛ'n hanlɩn yɩ́ nwʋn ɛjɔlɛ nɩn anɩn.” ");
INSERT INTO any_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Zozi nʋn Pɩɛlɩ nʋn Zʋan nʋn Zʋakɩ fi bʋka nɩn asʋ bɛ kɔ ju. Mɔ bɛ walɩ dede mɔ bɛ ka kaan bɛ ju Zozi menian ɛhɩnlɩn-mɔ anwʋn ɛbɛlɛ'n, bɛ kɔ nwun meninsʋnman bɛ́ nwʋn ɛbɛlɛ. Mala nɩn asʋ mgbain'n-mɔ wɔ bɛ́ nun. Bɛ kɔ fa akpʋlʋwa esue bɛ kɔ tʋa Zozi menian'n-mɔ. ");
INSERT INTO any_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Zozi kɔ li meninsʋnman'n nvu nun. Kɛ bɛ nwunlin yɩ́ nɩn ala, bɛ kɔ tutu ɛnwanndie bɛ kɔ hɔ yɩ́ atɩn ɛkpa. ");
INSERT INTO any_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Zozi kɔ bisa yɩ́ menian'n-mɔ kɛ: “Nzu anwʋn yɛ̂ ɛmɔ nʋn bɛ́ lɛ su akpʋlʋwa'n?” ");
INSERT INTO any_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","M'ɔ bisalɩ bɛ́ kosuan sɔ'n, meninsʋnman nɩn anun sʋanlan kʋn kɔ bua Zozi kɛ: “Yɛ́ Mɩn, m'an fa mɩ́n wa belenzua'n m'an bɛlɛ wɔ́. Ɔ sanlɩn kɛ wawɛ ɛtɛ wɔ yɩ́ nun. Ɔ man ɔ ngʋala man jʋjɔ. ");
INSERT INTO any_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Lɩka biala mɔ wawɛ'n kɔ tɔ yɩ́ sʋ'n, ɔ fin yɩ́ asɩ. Ɔ man ɔ cuin ngɛsɛlɛ, ɔ kʋan yɩ́ je'n, ɔ san yɩ́ ketee. M'an sɛlɛ wɔ́ menian'n-mɔ kɛ bɛ tú wawɛ ɛtɛ sɔ'n. Nan b'a mantan yɩ́ dede b'a ngʋala man yɩ́ tu.” ");
INSERT INTO any_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Zozi kɔ han kɔ hele bɛ́ kɛ: “Ɛmɔ menian ɛhɩ-mɔ, ɛmɔ le man dedi. Mɩn nʋn ɛmɔ yɛ tánlan dede ɔ hɔ́ jú mɛlɛ benin? N zʋ́ ɛmɔ dede ɔ jú tɛmʋn benin? Bɛ fá batʋnman'n bɛ bɛ́lɛ mɩ́n.” ");
INSERT INTO any_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Bɛ kɔ fa batʋnman'n bɛ kɔ bɛlɛ Zozi. Kɛmɔ batʋnman'n nwunlin yɩ́ nɩn ala, wawɛ ɛtɛ'n m'ɔ wɔ yɩ́ nun'n kɔ wʋsʋ yɩ́ sɛlɛ kpa. Batʋnman'n kɔ tɔ asɩ ɔ kɔ kunndo, yɩ́ nʋan ngɛsɛlɛ fʋkʋʋ. ");
INSERT INTO any_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Zozi kɔ bisa batʋnman nɩn asɩ'n kɛ: “Ɔ mantanlɩn yɩ́ ɛyɔlɛ'n yɩ́ cɩan nyɛ ahɩ?” Yɩ́ sɩ nwan: “Ɔ bɔlɩ yɩ́ bʋ yɩ́ mmatʋnman nun. ");
INSERT INTO any_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Cɩan bie a, wawɛ'n man ɔ tɔ sɩ̂n nun. Bie kʋsʋ a, ɔ tʋ yɩ́ asue nun kɛ ɔ 'kun yɩ́. Nan sɛ ɛ kʋala yɛ́ bʋka a, anɩn nwun yɛ́ nwʋn anwunnvoe nán bʋka yɛ́.” ");
INSERT INTO any_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Zozi kɔ se yɩ́ kɛ: “Ɛ lɛ kan kele mɩ́n kɛ: ‘Sɛ ɛ kʋala a!’ Nwun yɩ́ kɛ sʋanlan biala m'ɔ de Nyanmɩan di'n, ɔ kʋala like biala yɔ.” ");
INSERT INTO any_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Ɛbɛlɛ ala, batʋnman nɩn asɩ'n kɔ tɩan nun, yɩ́ nwan: “Mɩn de mɩn di, kʋsʋ bʋka mɩ́n nán mɩ́n dedi'n tɩ kaan sʋa!” ");
INSERT INTO any_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Meninsʋnman'n kɔ nwanndi kɔ hɔ Zozi nʋn batʋnman nɩn anwʋn ɛlɔ. Mɔ Zozi nwunlin yɩ́ sɔ'n, ɔ kɔ jʋjɔ aminle sʋ ɔ kɔ hele wawɛ ɛtɛ'n, yɩ́ nwan: “Wawɛ ɛtɛ, wɔ́ mɔ a munndun batʋnman ɛhɩ anʋan'n ɛsɛ a ti yɩ́ nzʋ'n, mɩɩn kan mɩn kele wɔ́ kɛ ɛ fi yɩ́ nun tú, ɛsɛ n'ɛ wʋlʋ yɩ́ nun kʋ́n lé!” ");
INSERT INTO any_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Wawɛ ɛtɛ'n kɔ wʋsʋ batʋnman'n sɛlɛ kpa. Ɔ kɔ tɛtɩan ɔ fi yɩ́ nun kɔ tu. Batʋnman'n tɩ kɛ ɔ'a wu. Ɔ man bɛ́ dɔʋn mɔ anɩn bɛ wɔ ɛbɛlɛ'n nwan: “Batʋnman nɩn a wu! Batʋnman nɩn a wu!” ");
INSERT INTO any_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Mɔ bɛ 'kɩkan ɛhɩ'n, Zozi kɔ sɔ batʋnman nɩn asa ɔ kɔ jasʋ yɩ́ kɔ jinlan. ");
INSERT INTO any_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Mɔ Zozi hɔlɩ awulo m'ɔ halɩ yɩ́ nʋn yɩ́ menian'n-mɔ angʋnmɩn'n, yɩ́ menian'n-mɔ kɔ bisa yɩ́ kɛ: “Nzukɛ ati yɛ̂ y'a ngʋala man wawɛ sɔ'n tu'n?” ");
INSERT INTO any_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Zozi kɔ bua bɛ́ kɛ: “Wawɛ ɛtɛ sʋa, Nyanmɩan ɛsɛlɛ yɛ̂ bɛ fa bɛ tu yɩ́ ɔ.” ");
INSERT INTO any_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Zozi nʋn yɩ́ menian'n-mɔ fi ɛbɛlɛ bɛ kɔ hɔ. Bɛ 'kɔ'n, bɛ kɔ kpɛ nun Galile mân nɩn anun. Afɩ Zozi ngulo man kɛ sʋanlan fɩ́ɩ́ nwun lɩka m'ɔ wɔ'n. ");
INSERT INTO any_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Ɔ kɔ hehele yɩ́ menian'n-mɔ ninnge, ɛsɛ ɔ kɔ han kɔ hele bɛ́ kɛ: “Bɛ 'ba hyɩ *Mân Baa'n bɛ man menian'n-mɔ kun yɩ́. Nan sɛ ɔ wu a, yɩ́ cɩan nsan nɩn asʋ, ɔ 'tinnge.” ");
INSERT INTO any_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Yɩ́ menian'n-mɔ ngɔ tɩ man ɛjɔlɛ sɔ'n m'ɔ hanlɩn nɩn abʋ. Kʋsʋ afɩ bɛ sulo bɛ ngɔ bisa man yɩ́ kosuan. ");
INSERT INTO any_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Mɔ Zozi nʋn yɩ́ menian'n-mɔ juli Kapɛɛnawɔmʋn mɔ bɛ wʋlʋlɩ awulo'n, ɔ kɔ bisa bɛ́ kɛ: “Nzu anwʋn akpʋlʋwa yɛ̂ ɛmɔ suli yɩ́ atɩn nɩn anun'n?” ");
INSERT INTO any_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","M'ɔ bisalɩ bɛ́ kosuan sɔ'n, bɛ ngɔ buke bɛ́ nʋan. Afɩ mɔ bɛ 'ba'n, akpʋlʋwa kʋn tɔlɩ bɛ́ afian. Akpʋlʋwa sɔ nɩn anwʋn, anɩn bɛ lɛ kpʋnndɛ sʋanlan m'ɔ tɩ kpili tala bɛ́ kʋalaa'n. ");
INSERT INTO any_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Ɛhɩ a, Zozi kɔ tanlan asɩ. Ɔ kɔ fɛlɛ yɩ́ menian bulu nʋn nnyuan'n ɔ kɔ han kɔ hele bɛ́ kɛ: “Sɛ sʋanlan kʋn kulo kɛ ɔ di ɛmɔ asʋ kpain an, anɩn ɔ káci ɛmɔ anun batʋnman nán ɔ sʋ́ ɛmɔ kʋalaatin.” ");
INSERT INTO any_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Mɔ Zozi hanlɩn sɔ yuelɩ'n, ɔ kɔ fa batʋnman kaan kʋn kɔ a bɛ́ afian ɛbɛlɛ. Ɔ kɔ fa yɩ́ kɔ bɔ yɩ́ nwʋn. Yɩ́ nwan: ");
INSERT INTO any_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Sʋanlan biala mɔ mɩ́n dunman nun, ɔ kɔ sɔ mmatʋnman ɛhɩ-mɔ bie anun'n, anɩn mɩ́n muonun yɛ̂ ɔ'a sɔ mɩ́n nun ɔ. Yɛ̂ sʋanlan m'ɔ kɔ sɔ mɩ́n nun'n, nán mɩ́n ngʋnmɩn yɛ̂ ɔ'a sɔ mɩn nun ɔ. Nan anɩn ɔ'a sɔ sʋanlan'n mɔ ɔ'a sʋan mɩ́n nɩn anun bie.” ");
INSERT INTO any_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Mɔ Zozi hanlɩn sɔ yuelɩ'n, Zʋan kɔ fa kɔ tʋ yɩ́ nyunnun kɛ: “Kpain, y'a nwun sʋanlan kʋn, ɔ nnʋn man yɛ́ nun bie. Ɔ fa wɔ́ dunman'n ɔ tu wawɛ ɛtɛ'n-mɔ. Yɩ́ ti, y'a totua yɩ́.” ");
INSERT INTO any_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Mɔ Zʋan anʋan tɔlɩ'n, Zozi nwan: “Nán bɛ totua yɩ́. Ɔ sanlɩn kɛ sʋanlan fɩ́ɩ́ ngʋala man kɛ ɔ fa mɩ́n dunman'n ɔ yɔ asinbɛnwʋn ninnge, nán afɩ ɔ'a han ɛjɔlɛ ɛtɛ ɔ'a tia mɩ́n. ");
INSERT INTO any_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Afɩ sʋanlan m'ɔ mgbɔ man yɛ́'n, anɩn ɔ kulo yɛ́. ");
INSERT INTO any_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Mɩɩn kan yɩ́ ananhɔlɛ mɩn kele ɛmɔ kɛ sʋanlan biala mɔ mɩ́n dunman nun, ɔ kɔ man ɛmɔ nzue nganlannzan kʋn kɔ nʋn'n, ɔ 'nyan yɩ́ nwʋn ahatua. ");
INSERT INTO any_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Mmatʋnman nganngan ɛhɩ-mɔ mɔ bɛ de mɩ́n bɛ di'n, sʋanlan m'ɔ kɔ tʋnndʋn bɛ́ nun kʋn aja nun maan ɔ kɔ tɔ ɛtɛ nɩn anun'n, ɔ tɩ kpa kɛ bɛ fa ɛbʋɛ kpili kʋn bɛ tʋ yɩ́ kɔmɩn bɛ tʋ yɩ́ jenvie nɩn anun. ");
INSERT INTO any_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Sɛ wɔ́ sa yɛ̂ ɔ lɛ jɩjɩ wɔ́ maan ɛ tɔ ɛtɛ nɩn anun an, anɩn kpɛ tʋ. Sɛ ɔ ka wɔ́ sa kʋn nán ɛ nyan ngʋan an, ɔ tɩ kpa tala kɛ ɛ le wɔ́ sa nnyuan'n ɛ kɔ hɔ sɩ̂n'n m'ɔ nnun man lé nɩn anun'n.  ");
INSERT INTO any_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Ɛlɔ ngakʋba'n-mɔ mɔ bɛ di sʋanlan'n, bɛ nwu man lé, ɛsɛ sɩ̂n'n kʋsʋ nnun man lé. ");
INSERT INTO any_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Sɛ wɔ́ ja yɛ̂ ɔ lɛ jɩjɩ wɔ́ maan ɛ tɔ ɛtɛ nɩn anun an, anɩn kpɛ tʋ. Sɛ ɔ ka wɔ́ ja kʋn nán ɛ nyan ngʋan an, ɔ tɩ kpa tala kɛ ɛ kɔ fa wɔ́ ja nnyuan'n ɛ kɔ hɔ sɩ̂n'n m'ɔ nnun man lé nɩn anun'n.  ");
INSERT INTO any_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Ɛlɔ ngakʋba'n-mɔ mɔ bɛ di sʋanlan'n, bɛ nwu man lé, ɛsɛ sɩ̂n'n kʋsʋ nnun man lé. ");
INSERT INTO any_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Sɛ wɔ́ nyɩn yɛ̂ ɔ lɛ jɩjɩ wɔ́ maan ɛ tɔ ɛtɛ nɩn anun an, anɩn tu tʋ. Sɛ ɔ ka wɔ́ nyɩn kʋn nán ɛ nyan Nyanmɩan Belemgbin Mân nɩn anun ɛlɔ ngʋan nɩn an, ɔ tɩ kpa tala kɛ ɛ kɔ fa wɔ́ nyɩn nnyuan'n ɛ kɔ hɔ sɩ̂n'n m'ɔ nnun man lé nɩn anun'n. ");
INSERT INTO any_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Ɛlɔ ngakʋba'n-mɔ mɔ bɛ di sʋanlan'n, bɛ nwu man lé, ɛsɛ sɩ̂n'n kʋsʋ nnun man lé. ");
INSERT INTO any_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Afɩ kɛ bɛ wula ninnge'n-mɔ njɩn nán b'a nzɛcɩ man'n, bɛ 'fa sɩ̂n'n kʋsʋ bɛ tɩ sʋanlan biala anwʋn. ");
INSERT INTO any_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Njɩn'n tɩ like kpa. Nan sɛ ɔ yɔ talɛ́ a, anɩn bɛ 'yɔ sɛ nán ɔ a yɔ fɛ biekun? Ɛmɔ mán njɩn tánlan ɛmɔ anun, ɛsɛ ɛmɔ nʋn ɛhɩnlɩn-mɔ tánlan anzʋnunjɔ nun.” ");
INSERT INTO any_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Ɛhɩ, Zozi nʋn yɩ́ menian'n-mɔ, bɛ fi Kapɛɛnawɔmʋn kulo nɩn asʋ ɛbɛlɛ bɛ́ nʋan y'ɔ le Zude mân nɩn anun, asue Zuludɩn nɩn anzin ɛlɔ. Mɔ bɛ juli ɛbɛlɛ'n, meninsʋnman'n kɔ a kɔ yia bɛ́ nwʋn biekun. Kɛ Zozi yɔ yɩ́ titi'n, ɔ kɔ hehele bɛ́ Nyanmɩan Anʋan Ɛjɔlɛ'n. ");
INSERT INTO any_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Anɩn Falisifʋɛ mmie-mɔ wɔ ɛbɛlɛ. Kɛmɔ bɛ kulo kɛ bɛ sɔ Zozi bɛ nɩan'n, bɛ kɔ bisa yɩ́ kɛ: “Kpain, asʋ yɛ́ mala'n man atɩn kɛ belenzua kʋn yíla yɩ́ yɩ ɔ?” ");
INSERT INTO any_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Mɔ bɛ bisalɩ kosuan sɔ'n, Zozi kʋsʋ kɔ bisa bɛ́ kɛ: “Mala benin yɛ̂ *Moyizɩ falɩ manlɩn ɛmɔ ɔ?” ");
INSERT INTO any_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Bɛ kɔ bua Zozi kɛ: “Moyizɩ a man atɩn kɛ belenzua'n hɛ́lɛ eyila kalata mán yɩ́ yɩ nán ɔ yíla yɩ́.” ");
INSERT INTO any_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Ɛhɩ a, Zozi kɔ han kɔ hele bɛ́ kɛ: “Ɛmɔ ati anun ɛtɛ nɩn ati yɛ̂ Moyizɩ falɩ mala sɔ'n manlɩn ɛmɔ ɔ. ");
INSERT INTO any_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Nan mɔ Nyanmɩan bɔlɩ mân'n, kɛ Ɛhɛlɛ Ɛjɔlɛ'n kan'n: Ɔ bɔlɩ belenzua nʋn balasua. ");
INSERT INTO any_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Ɛhɩ ati, belenzua'n fi yɩ́ sɩ nʋn yɩ́ nin abʋ anwʋn 'ba jasʋ. Ɔ 'fa yɩ́ nwʋn bɔ yɩ́ yɩ, ");
INSERT INTO any_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","nán bɛ́ munnyuan'n bɛ yɔ sʋanlan munmuan kʋn. Ɛmɔ nwún yɩ́ kɛ bɛ tɩ man menian nnyuan, nan bɛ tɩ sʋanlan kʋn. ");
INSERT INTO any_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Yɩ́ sɔ ati, like mɔ Nyanmɩan kɔ han kɔ bɔ nun'n, sʋanlan n'ɔ tɩ nun.” ");
INSERT INTO any_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Mɔ bɛ fi ɛbɛlɛ bɛ hɔlɩ awulo'n, Zozi menian'n-mɔ kɔ bisa yɩ́ kosuan ɛjɔlɛ sɔ nɩn anwʋn. ");
INSERT INTO any_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Zozi kɔ han kɔ hele bɛ́ kɛ: “Sɛ sʋanlan kʋn yila yɩ́ yɩ nán ɔ kɔ ja balasua fʋfɔlɛ a, anɩn ɔ'a tʋn ajaa wɔ daba nɩn anwʋn. ");
INSERT INTO any_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Sɛ balasua kʋn kʋsʋ yila yɩ́ hun nán ɔ kɔ ja belenzua fʋfɔlɛ a, anɩn ɔ'a tʋn ajaa.” ");
INSERT INTO any_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Mɔ Zozi hanlɩn sɔ yuelɩ'n, menian mmie-mɔ falɩ mmatʋnman bɛlɛlɩ yɩ́ kɛ ɔ yéyila bɛ́ sʋ. Nan mɔ bɛ 'fa bɛ́ bɛ bɛlɛ Zozi'n, yɩ́ menian'n-mɔ kɔ totua bɛ́ atɩn. ");
INSERT INTO any_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Mɔ Zozi nwunlin bɛ́ nyɔlɩɛ sɔ'n, ɔ kɔ fɛ ɛya. Ɔ kɔ han kɔ hele bɛ́ kɛ: “Ɛmɔ yáci mmatʋnman'n-mɔ maan bɛ bála mɩ́n nwʋn, nan nán bɛ totua bɛ́ atɩn. Ɔ sanlɩn kɛ Nyanmɩan Belemgbin Mân'n, ɔ tɩ bɛ́ mɔ bɛ tɩ kɛ mmatʋnman ɛhɩ-mɔ'n dɩɛ. ");
INSERT INTO any_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Mɩɩn kan yɩ́ ananhɔlɛ mɩn kele ɛmɔ kɛ, sʋanlan mɔ ɔ'a nzɔ man Nyanmɩan Belemgbin Mân nɩn anun kɛ batʋnman sɔ nun'n, sʋanlan sɔ'n ngɔ man Nyanmɩan lɩka ɛlɔ lé.” ");
INSERT INTO any_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","M'ɔ yɔlɩ sɔ'n, Zozi kɔ sɔ mmatʋnman'n-mɔ kɔ mantan yɩ́ nwʋn. Ɔ kɔ fa yɩ́ sa'n kɔ fofua bɛ́ sʋ ɔ kɔ yeyila bɛ́. ");
INSERT INTO any_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Mɔ Zozi yɔlɩ sɔ yuelɩ mɔ ɔ 'ba tu yɩ́ bʋ'n, sʋanlan kʋn tutuli ɛnwanndie ɔ walɩ kʋtʋlɩ yɩ́ nyunnun ɛbɛlɛ. Yɩ́ nwan: “Ngehelefʋɛ kpa, nzukɛ yɛ̂ n yɔ́ nán m'an nyan ngʋan m'ɔ le man ayuelɩɛ nɩn ɔ?” ");
INSERT INTO any_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","M'ɔ bisalɩ kosuan sɔ'n, Zozi kɔ bua yɩ́ kɛ: “Nzukɛ ati yɛ̂ ɛ fɛlɛ mɩ́n ngehelefʋɛ kpa ɔ? Sʋanlan fɩ́ɩ́ tɩ man kpa sannan Nyanmɩan Kpili angʋnmɩn cein. ");
INSERT INTO any_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Ɛ sɩ mala'n-mɔ: N'ɛ di awue, n'ɛ tʋn ajaa, n'ɛ wua like, n'ɛ di ato adanzɩɛ, n'ɛ di ndunlunmun, man wɔ́ nyɩn sɔ́ wɔ́ sɩ nʋn wɔ́ nin.” ");
INSERT INTO any_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Bian'n bualɩ yɩ́ kɛ: “Ɛhɩ kʋalaa m mantanlɩn sʋ elie mɩ́n mmatʋnman nun angʋnmɩn. N vʋnndʋnlɩn man bie fɩ́ɩ́.” ");
INSERT INTO any_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Zozi kɔ nɩan bian'n ɔ kɔ li yɩ́ nwʋn fɛ. Yɩ́ nwan: “Ɔ a ha wɔ́ like kʋn. Kɔ nán tɔnɩn wɔ́ nwʋn ninnge'n-mɔ kʋalaatin, nán fa yɩ́ esika'n man ehianfʋɛ'n-mɔ. Ɛ 'ba nyan wɔ́ nwʋn Nyanmɩan Belemgbin Mân nɩn anun. Ɛ yɔ sɔ yue a, bala, nán afɩ si mɩ́n sʋ.” ");
INSERT INTO any_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Mɔ bian'n tɩlɩ ɛjɔlɛ sɔ'n, yɩ́ ti anun kɔ sɛcɩ yɩ́ kpa. Ɔ kɔ li yalɛ kɔ hɔ, afɩ ɔ tɩ esikafʋɛ kpili kpa. ");
INSERT INTO any_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Zozi kpɛlɩ yɩ́ nyɩn ɔ nɩanlɩn yɩ́ menian'n-mɔ mɔ b'a yia yɩ́ nwʋn ɛbɛlɛ nɩn an, yɩ́ nwan: “Nyanmɩan Belemgbin Mân nɩn anun ɛwʋlʋɛ'n, ɔ yɔ sɩ man esikafʋɛ'n-mɔ!” ");
INSERT INTO any_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Mɔ Zozi hanlɩn sɔ'n, ɛjɔlɛ'n kɔ sin yɩ́ menian'n-mɔ anwʋn kpa. Ɔ kɔ se bɛ́ biekun kɛ: “Mɩ́n mma-mɔ, Nyanmɩan Belemgbin Mân nɩn anun ɛwʋlʋɛ'n yɔ sɩ! ");
INSERT INTO any_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Ɔ yɔ sɩ man naan'n mɔ bɛ fɛlɛ yɩ́ sʋamo'n kɛ ɔ wʋ́lʋ dɔlɔwa bɔɛ nun. Nan ɔ yɔ sɩ kpa man esikafʋɛ kʋn kɛ ɔ wʋ́lʋ Nyanmɩan Belemgbin Mân nɩn anun.” ");
INSERT INTO any_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Ɛjɔlɛ sɔ'n mɔ Zozi hanlɩn'n sinlin yɩ́ menian'n-mɔ anwʋn kpa biekun. Bɛ kɔ bisa bisa bɛ́ nwʋn kɛ: “Sɛ ɔ tɩ sɔ a, anɩn nwan yɛ̂ ɔ 'nyan yɩ́ ti ɔ?” ");
INSERT INTO any_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Zozi nɩanlɩn bɛ́ dede a, yɩ́ nwan: “Ɛhɩ yɔ sɩ man kulo menian'n-mɔ, nan ɔ nyɔ sɩ mman man Nyanmɩan. Nyanmɩan dɩɛ, like fɩ́ɩ́ nza man yɩ́ yɔ.” ");
INSERT INTO any_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Ɛhɩ a, Pɩɛlɩ nwan: “Nwun yɩ́ kɛ y'a yaci yɛ́ ninnge'n-mɔ kʋalaa y'a si wɔ́ sʋ.” ");
INSERT INTO any_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Mɔ Pɩɛlɩ hanlɩn sɔ'n, Zozi kɔ bua yɩ́ kɛ: “Mɩɩn kan yɩ́ ananhɔlɛ mɩn kele ɛmɔ kɛ sʋanlan mɔ mɩ́n dunman nun ɔ nʋn Ɛjɔlɛkpa'n dunman nun ɔ kɔ yaci yɩ́ awulo, yɩ́ nianman'n-mɔ, yɩ́ nin nʋn yɩ́ sɩ, yɩ́ mma, anaan yɩ́ asɩɛ'n-mɔ, ");
INSERT INTO any_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","ɔ 'nyan awulo, anianman, nian, sɩɛ, mma, asɩɛ, ɔ nʋn amannɩnhunlun mɛlɛ ɛhɩ anun, ɛsɛ mɛlɛ'n m'ɔ lɛ ba nɩn anun, ɔ 'nyan ngʋan m'ɔ le man ayuelɩɛ'n. ");
INSERT INTO any_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Alimʋa mma'n-mɔ dɔʋn 'ba li sian, yɛ̂ sian mma'n-mɔ kʋsʋ dɔʋn 'ba li mʋa.” ");
INSERT INTO any_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Mɔ Zozi hanlɩn sɔ yuelɩn'n, ɔ nʋn yɩ́ menian'n-mɔ, bɛ kɔ fa Zoluzalɛmʋn atɩn'n. Zozi li bɛ́ nyunnun. Yɩ́ menian'n-mɔ akunnun tɩtɩ bɛ́. Bɛ́ mɔ bɛ si bɛ́ sʋ'n kʋsʋ sulo. Zozi kɔ fɛlɛ yɩ́ menian bulu nʋn nnyuan nɩn ahanmɩan biekun. Ɛjɔlɛ'n mɔ ɔ 'ba tʋ yɩ́'n, ɔ kɔ han kɔ hele bɛ́. ");
INSERT INTO any_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Yɩ́ nwan “Ɛmɔ tíe, yɛ lɛ kɔ Zoluzalɛmʋn! Yɛ kɔ yɛ ju ɛlɔ a, bɛ 'ba hyɩ Mân Baa'n bɛ man Nyanmɩan tɛɛyɩfʋɛ'n-mɔ nʋn mala nɩn asʋ mgbain'n-mɔ. Yɩ́ ehuan ati, bɛ 'ba bu yɩ́ fʋɔ. Bɛ 'ba fa yɩ́ bɛ wula bɛ́ mɔ bɛ tɩ man Zufʋ'n-mɔ asa nun. ");
INSERT INTO any_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Bɛ́ kʋsʋ bɛ 'ba gʋlʋ yɩ́ nwʋn, bɛ tʋtʋ yɩ́ nyunnun ngɛsɛlɛ, bɛ fin yɩ́ mgbele nán bɛ kun yɩ́. Sɛ bɛ kun yɩ́ yue a, yɩ́ cɩan nsan nɩn asʋ, ɔ fi ewue nun ɔ 'tinnge.” ");
INSERT INTO any_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Mɔ Zozi hanlɩn sɔ yuelɩ'n, Zebede amma Zʋakɩ nʋn Zʋan kɔ kpunnge yɩ́. Bɛ́ nwan: “Yɛ́ Mɩn, yɛ kulo kɛ like'n mɔ yɛ lɛ ba bisa wɔ́'n, ɛ yɔ́ man yɛ́”. ");
INSERT INTO any_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Zozi kɔ bisa bɛ́ kɛ: “Nzu like dɩɛ yɛ̂ ɛmɔ kulo kɛ n yɔ́ m mán ɛmɔ ɔ?” ");
INSERT INTO any_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Bɛ́ nwan: “Mɛlɛ mɔ ɛ 'di wɔ́ belemgbin nɩn anunminnyanmʋn nɩn anun'n, man yɛ́ nunhan kʋn tánlan wɔ́ fama sʋ yɛ̂ kʋn kʋsʋ tánlan wɔ́ bɛ̂ sʋ.” ");
INSERT INTO any_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Bɛ hanlɩn sɔ a, Zozi nwan: “Ɛmɔ nzɩ man like'n mɔ ɛmɔ lɛ bisa'n. Asʋ amannɩnhunlun kangɔ'n mɔ mɩn 'ba nʋn nun'n, ɛmɔ kɔ hʋala nun nʋn? Anaan amannɩnhunlun ɛsɔnɩan'n mɔ bɛ 'ba sɔnɩn mɩ́n'n, ɛmɔ kɔ hʋala bie sɔnɩn?” ");
INSERT INTO any_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Bɛ́ nwan: “Yuo o, yɛ kʋala yɩ́ yɔ.” Zozi nwan: “Ɔ tɩ ananhɔlɛ kɛ kangɔ'n mɔ mɩn 'ba nʋn nun'n, ɛmɔ 'ba nʋn nun bie. Ɛsɔnɩan'n mɔ bɛ 'ba sɔnɩn mɩ́n'n, bɛ 'ba sɔnɩn ɛmɔ bie. ");
INSERT INTO any_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Nan kʋsʋ m'ɔ tɩ mɩ́n fama sʋ anaan mɩ́n bɛ̂ sʋ ɛtanlán'n, yɩ́ dɩɛ nán mɩ́n yɛ̂ mɩn man ɔ. Ɔ tɩ bɛ́ mɔ Nyanmɩan a sesie a man bɛ́'n-mɔ dɩɛ.” ");
INSERT INTO any_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Mɔ yɩ́ menian bulu'n tɩlɩ ɛjɔlɛ'n mɔ Zʋakɩ nʋn Zʋan hanlɩn'n, bɛ kɔ fɛ bɛ́ nwʋn ɛya. ");
INSERT INTO any_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Ɛhɩ a, Zozi kɔ fɛlɛ bɛ́ kʋalaatin ɔ kɔ han kɔ hele bɛ́ kɛ: “Ɛmɔ sɩ kɛ mân nɩn anun mmelemgbin'n-mɔ kele bɛ́ menian'n-mɔ ahʋlʋwa. Mgbain'n-mɔ sisi menian'n-mɔ. ");
INSERT INTO any_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Nan ɛmɔ afian ɛwa dɩɛ, ɔ tɩ man sɔ. Ɛmɔ afian, m'ɔ kulo kɛ ɔ kaci kpain'n, ɔ káci ɛmɔ akʋa. ");
INSERT INTO any_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Nunhan m'ɔ kulo kɛ ɔ di ɛmɔ anyunnun'n, ɔ yɔ́ ɛmɔ kanga. ");
INSERT INTO any_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Ɔ sanlɩn kɛ *Mân Baa'n muonun, ɔ'a mma man kɛ ɔ 'ba maan bɛ sʋ yɩ́. Nan ɔ walɩ kɛ ɔ 'ba sʋ ɔ fa yɩ́ ngʋan'n ɔ de menian dɔʋn ati.” ");
INSERT INTO any_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Ɛhɩ anzin, Zozi nʋn yɩ́ menian'n-mɔ kɔ hɔ kɔ ju kulo'n mɔ bɛ fɛlɛ yɩ́ Zoliko nɩn asʋ. Mɛlɛ mɔ Zozi nʋn yɩ́ menian'n-mɔ nʋn meninsʋnman'n fi kulo nɩn anun bɛ 'fite'n, anɩn Time awa Baatime m'ɔ tɩ anyɩnsinlinwafʋɛ'n tɩ atɩn nɩn anʋan ɛbɛlɛ. Ɔ sɛsɛlɛ esika. ");
INSERT INTO any_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","M'ɔ tɩlɩ kɛ bɛ́ nwan Zozi m'ɔ fi Nazalɛtɩ'n, ɔ kɔ tɩan nun kɛ: “Zozi, belemgbin *Davidi Awa, nwun mɩ́n nwʋn anwunnvoe!” ");
INSERT INTO any_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Menian dɔʋn kpa kɔ totua yɩ́ kɛ ɔ múan yɩ́ nʋan nɩn asʋ. Ɔ ngɔ tɛ bɛ́ sʋ. Ɔ kɔ tɩan nun sɛlɛ kpa biekun kɛ: “Zozi, belemgbin Davidi Awa, nwun mɩ́n nwʋn anwunnvoe!” ");
INSERT INTO any_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Zozi kɔ jinlan. Yɩ́ nwan: “Bɛ fɛ́lɛ yɩ́ bɛ mán ɔ bála.” Bɛ kɔ fɛlɛ anyɩnsinlinwafʋɛ'n, bɛ́ nwan: “Bɔ mɔndɩnlɩn, jasʋ nán ɔ lɛ fɛlɛ wɔ́.” ");
INSERT INTO any_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Ɛhɩ a, Baatime kɔ gua taladɩɛ'n m'ɔ fa fʋfɔ yɩ́ nwʋn nɩn asɩ. Ɔ kɔ hulu kɔ kpɩn ɔ kɔ a Zozi anwʋn ɛbɛlɛ. ");
INSERT INTO any_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Zozi kɔ bisa yɩ́ kɛ: “Nzu like dɩɛ yɛ̂ n yɔ́ m mán wɔ́ ɔ?” Anyɩnsinlinwafʋɛ'n nwan: “*Labunin, man n nwún asɩ.” ");
INSERT INTO any_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","M'ɔ hanlɩn sɔ'n, Zozi nwan: “Kɔ, wɔ́ dedi nɩn a man wɔ́ nwʋn a sa.” Ɛbɛlɛ ala, ɔ kɔ nwun asɩ. Ɔ kɔ si Zozi sʋ. ");
INSERT INTO any_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Zozi nʋn yɩ́ menian'n-mɔ kɔ a kɔ ju Bɛtɩfaze nʋn Betanin afian. Kulo sɔ'n-mɔ mantan mantan Zoluzalɛmʋn. Mɔ bɛ juli *Olivʋ bʋka nɩn anwʋn ɛbɛlɛ'n, Zozi kɔ sʋan yɩ́ menian'n-mɔ anun nnyuan, yɩ́ nwan: ");
INSERT INTO any_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","“Ɛmɔ hɔ́ kulo'n m'ɔ wɔ ɛmɔ anyunnun ɛlɔ nɩn asʋ. Mɔ ɛmɔ 'fite kulo nɩn asʋ ɛbɛlɛ ala'n, ɛmɔ 'ba nwun yɩ́ kɛ afunlunmun baa kʋn mɩnnda ɛbɛlɛ, sʋanlan fɩ́ɩ́ fʋlɩ tanlanlɩn man sʋ lé. Ɛmɔ nyánnjɩ yɩ́ bɛ bɛ́lɛ mɩ́n. ");
INSERT INTO any_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Sɛ sʋanlan bie bisa ɛmɔ kɛ nzukɛ ati yɛ̂ ɛmɔ lɛ nyannjɩ yɩ́ a, ɛmɔ sé yɩ́ kɛ: ‘Yɛ́ Mɩn a mian yɩ́ nwʋn, nan ɔ ngɔ hye man, ɔ 'ba fa sa ba.’” ");
INSERT INTO any_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","M'ɔ hanlɩn sɔ yuelɩ'n yɛ̂ yɩ́ menian nnyuan'n hɔlɩ ɔ. Bɛ 'kɔ a ju a, afunlunmun baa'n mɩnnda anʋan kʋn anun, gua nɩn asʋ. Bɛ kɔ nyannjɩ yɩ́. ");
INSERT INTO any_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Bɛ́ mɔ bɛ wɔ ɛbɛlɛ'n, bɛ́ mmie-mɔ kɔ bisa bɛ́ kɛ: “Ɛmɔ lɛ yɔ nzu? Nzu ati yɛ̂ ɛmɔ lɛ nyannjɩ afunlunmun baa'n?” ");
INSERT INTO any_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Bɛ bualɩ bɛ́ kɛ Zozi hanlɩn helelɩ bɛ́'n, yɛ̂ menian sɔ'n-mɔ yacili bɛ́ maan bɛ falɩ bɛ hɔlɩ ɔ. ");
INSERT INTO any_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Bɛ kɔ fa afunlunmun baa'n bɛ kɔ bɛlɛ Zozi, bɛ kɔ fa bɛ́ taladɩɛ'n-mɔ bɛ kɔ gua naan nɩn asʋ. Zozi kɔ fʋ kɔ tanlanlɩn sʋ. ");
INSERT INTO any_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Menian dɔʋn kɔ sɩsɛ bɛ́ ɛtanlan'n-mɔ atɩn nɩn anun. Mmie-mɔ kʋsʋ kɔ kpɩkpɛ aye malɛ bɛ kɔ sɩsɛ yɩ́ atɩn nɩn anun. ");
INSERT INTO any_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Bɛ́ mɔ bɛ li Zozi anyunnun'n ɔ nʋn bɛ́ mɔ bɛ li yɩ́ nzin'n, bɛ lɛ tɩan bɛ kan kɛ: “Hozanna! Nyila hán sʋanlan ɛhɩ m'ɔ lɛ ba wɔ yɛ́ Mɩn dunman nun'n! ");
INSERT INTO any_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Nyila hán belemgbin'n m'ɔ lɛ ba sesie yɛ́ sɩ Davidi belemgbin mân'n. Hozanna! Nyila hán yɛ́ Mɩn m'ɔ wɔ anwunno anwunno ɛlɔ'n!” ");
INSERT INTO any_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Zozi kɔ ju Zoluzalɛmʋn. Ɔ kɔ wʋlʋ Nyanmɩan sua nɩn anun. Ɔ kɔ nɛnɩan ɛbɛlɛ ninnge'n-mɔ kʋalaa kɔ yue. Ɔ nʋn yɩ́ menian bulu nʋn nnyuan'n, bɛ kɔ hɔ Betanin. Ɔ sanlɩn kɛ anɩn alɩ́ɛ lɛ yɔ. ");
INSERT INTO any_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Bɛ lalɩ alɩ́ɛ hɩnlɩn mɔ bɛ fi Betanin bɛ 'kɔ'n, ɛhɔɛ kɔ hun Zozi. ");
INSERT INTO any_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Ɔ kɔ nwun *figi baka kʋn mʋa ɛlɔ. Nyâ wɔ sʋ. Zozi kɔ hɔ yɩ́ bʋ ɔ 'kɔ a nɩan sɛ ɔ kɔ nyan figi bie kɔ li a. Ɔ 'kɔ ju a, like fɩ́ɩ́ nnʋn man sʋ, nyâ ngʋnmɩn, ɔ sanlɩn kɛ ɔ juli man figi nɩn esúe tɛmʋn. ");
INSERT INTO any_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Mɔ Zozi nwunlin yɩ́ sɔ'n, yɩ́ nwan: “Wɔ́ baka ɛhɩ, ɔ fi ɛnɛ m'ɔ kɔ'n, sʋanlan fɩ́ɩ́ ngɔ li wɔ́ sʋ baa kʋ́n lé!” M'ɔ hanlɩn sɔ'n, yɩ́ menian'n-mɔ kɔ tɩ. ");
INSERT INTO any_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Zozi nʋn yɩ́ menian'n-mɔ fi Betanin bɛ kɔ a Zoluzalɛmʋn. Zozi kɔ wʋlʋ Nyanmɩan awulo nɩn anun. Ɔ kɔ fʋan bɛ́ kʋalaa mɔ bɛ di gua awulo nɩn anun'n. Ɔ kɔ han bɛ́ mɔ bɛ kaci esika'n tɔbɩlɩ'n-mɔ kɔ gua. Bɛ́ mɔ bɛ lɛ tɔnɩn mɔlɔnʋnman'n-mɔ, ɔ kɔ han bɛ́ bia'n mɔ kɔ gua. ");
INSERT INTO any_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Ɔ'a mman man sʋanlan fɩ́ɩ́ atɩn ɔ'a nzʋa man ninnge ɔ'a nzɩn man Nyanmɩan awulo nɩn anun. ");
INSERT INTO any_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","M'ɔ yɔlɩ sɔ yuelɩ'n, ɔ kɔ hehele menian'n-mɔ ninnge. Yɩ́ nwan: “Asʋ b'a ngɛlɛ man yɩ́ kɛ Nyanmɩan nwan: Bɛ 'ba fɛlɛ mɩ́n awulo'n mân mân kʋalaa mmʋtʋɛ awulo ɔ? Nan ɔ yɔ sɛ mɔ ɛmɔ a fa a kaci ɛmɔ awue awulo'n?” ");
INSERT INTO any_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Mɔ Nyanmɩan tɛɛyɩfʋɛ'n-mɔ nʋn mala nɩn asʋ mgbain'n-mɔ tɩlɩ ɛjɔlɛ sɔ'n, ɔ ngɔ yɔ bɛ́ fɛ fɩ́ɩ́. Ɛbɛlɛ ala, bɛ kɔ kpʋnndɛ atɩn mɔ bɛ 'sɩn sʋ nán bɛ cɩ yɩ́ bɛ kun yɩ́. Nan kʋsʋ bɛ sulo yɩ́, ɔ sanlɩn kɛ yɩ́ like'n m'ɔ kele'n yɔ menian'n-mɔ mɔ b'a yia ɛbɛlɛ'n kʋalaa fɛ sʋnman. ");
INSERT INTO any_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Mɔ alɩ́ɛ'n yɔlɩ'n, Zozi nʋn yɩ́ menian'n-mɔ fi Zoluzalɛmʋn kulo nɩn anun bɛ kɔ fite. ");
INSERT INTO any_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Alɩ́ɛ hɩnlɩn mɔ bɛ 'sɩn'n, Zozi menian'n-mɔ kɔ nwun figi baka'n. Ɔ fi yɩ́ anwunno ɔ'a yʋɩ dede ɔ'a ju yɩ́ bʋ asɩ. ");
INSERT INTO any_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Ɛbɛlɛ ala, Pɩɛlɩ kɔ kacɩ ɛjɔlɛ'n mɔ Zozi hanlɩn'n. Nán ɔ'a se yɩ́ kɛ: “Yɛ́ Mɩn, nɩan kɛ figi baka'n mɔ ɛ bɔlɩ yɩ́ sasan nɩn a yue yʋɩ ɔ.” ");
INSERT INTO any_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Mɔ Pɩɛlɩ hanlɩn sɔ yuelɩ'n, Zozi kɔ se bɛ́ kɛ: “Ɛmɔ lé Nyanmɩan bɛ lí. ");
INSERT INTO any_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Mɩɩn kan yɩ́ ananhɔlɛ mɩn kele ɛmɔ kɛ sɛ sʋanlan kʋn nzu man akpʋlʋwa wɔ yɩ́ ahʋnlɩn nɩn anun, nan ɔ de di kɛ m'ɔ lɛ kan'n 'yɔ sɔ man yɩ́ a, sɛ ɔ se bʋka ɛhɩ kɛ: ‘Bʋka, fi ɛwa tutu kɔ tɔ jenvie nɩn anun’ an, bʋka'n 'tutu kɔ tɔ nun. ");
INSERT INTO any_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Yɩ́ sɔ ati, mɩɩn kan mɩn kele ɛmɔ kɛ, like biala mɔ ɛmɔ kɔ sɛlɛ wɔ Nyanmɩan ɛlɔ'n, ɛmɔ lé lí kɛ ɛmɔ asa a han yɩ́. Afɩ ɔ 'fa man ɛmɔ. ");
INSERT INTO any_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Mɛlɛ mɔ ɛmɔ jin bɛ lɛ yɔ asɔnɩn'n, sɛ sʋanlan bie anwʋn ɛjɔlɛ wɔ ɛmɔ akunnun an, ɛmɔ fá yɩ́ nwʋn sa bɛ hyé yɩ́. Nán Nyanmɩan a fa ɛmɔ anwʋn sa dɩɛ nɩn a hye ɛmɔ.  ");
INSERT INTO any_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Nan sɛ ɛmɔ a nva man yɩ́ nwʋn sa b'a nje man yɩ́ a, ɛmɔ Asɩ'n kʋsʋ m'ɔ wɔ anwunno'n nva man ɛmɔ dɩɛ'n nje man ɛmɔ.” ");
INSERT INTO any_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Zozi nʋn yɩ́ menian'n-mɔ kɔ sa kɔ hɔ Zoluzalɛmʋn ɛlɔ biekun. Mɛlɛ mɔ anɩn ɔ lɛ kpanza Nyanmɩan awulo nɩn anun'n, Nyanmɩan tɛɛyɩfʋɛ'n-mɔ, nʋn mala nɩn asʋ mgbain'n-mɔ, nʋn Zufʋ mgbain'n-mɔ kɔ a yɩ́ nwʋn ɛbɛlɛ. ");
INSERT INTO any_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Bɛ kɔ bisa yɩ́ kɛ: “Tunmin benin yɛ̂ ɛ le yɩ́ ɛ yɔ ninnge sʋa mɔ ɔ? Nwan sʋanlan dɩɛ yɛ̂ ɔ manlɩn wɔ́ atɩn kɛ ɛ yɔ́ ɔ?” ");
INSERT INTO any_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Zozi kɔ bua bɛ́ kɛ: “Mɩn 'ba bisa ɛmɔ kosuan kʋn. Sɛ ɛmɔ tu yɩ́ nʋan an, sʋanlan'n m'ɔ manlɩn mɩ́n atɩn maan mɩn yɔ ninnge'n-mɔ'n, mɩn 'kan mɩn kele ɛmɔ. ");
INSERT INTO any_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Ɛsɔnɩan'n mɔ Zʋan sɔnɩn menian'n-mɔ'n, ɔ fi Nyanmɩan ɛlɔ anaan ɔ fi kulo menian'n-mɔ ɛlɔ ɔ? Ɛmɔ búa mɩ́n bie.” ");
INSERT INTO any_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Mɔ Zozi bisalɩ bɛ́ kosuan sɔ'n, bɛ kɔ han yɩ́ bɛ́ afian ɛlɔ kɛ: “Sɛ yɛ bua yɩ́ kɛ: ‘Nyanmɩan yɛ̂ ɔ sʋanlɩn yɩ́’ a, ɔ 'ba bisa yɛ́ kɛ: ‘Anɩn nzukɛ ati yɛ̂ ɛmɔ a nne man yɩ́ ɛjɔlɛ'n b'a nni man'n?’ ");
INSERT INTO any_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Sɛ yɛ kan kɛ: ‘Menian'n-mɔ yɛ̂ bɛ sʋanlɩn yɩ́’ a, …” (Bɛ sulo bagua'n, afɩ menian'n-mɔ kʋalaa de tʋ nun kɛ Zʋan tɩ Nyanmɩan kpɔmanfʋɛ sakpa.) ");
INSERT INTO any_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Ɛhɩ a, bɛ kɔ bua Zozi kɛ: “Yɛ nzɩ man.” Zozi kʋsʋ kɔ se bɛ́ kɛ: “Mɩ́n kʋsʋ mɩn ngele man ɛmɔ sʋanlan'n m'ɔ man mɩ́n atɩn maan mɩn yɔ mɩ́n ninnge sɔ'n-mɔ'n.” ");
INSERT INTO any_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","M'ɔ yɔlɩ sɔ'n, Zozi kɔ han ɛjɔlɛ ɔ kɔ bu yɩ́ anyɩnndala nun ɔ kɔ hele bɛ́ kɛ: “Ɛhɩ bian kʋn kɔ sʋn yɩ́ divɩn ebo. Ɔ kɔ hyɩ yɩ́ nwʋn. Ɔ kɔ fun kunman kʋn m'ɔ hyuhyuin yɩ́ nzan'n gua nun ɔ. Ɔ kɔ si sua hyilili kʋn sʋ. Sua sɔ'n tɩ kannganlaun. Bɛ fʋ sʋ bɛ sisa ebo'n. ɔ kɔ fa ebo'n kɔ wula kpafʋ-mɔ asa nun. Yɛ̂ ɔ hɔlɩ yɩ́ atɩn ɔ. ");
INSERT INTO any_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Mɔ divɩn nɩn ɛtɩɛ'n tɛmʋn juli'n, bian'n sɔ'n kɔ sʋan yɩ́ ngʋa'n-mɔ anun kʋn kpafʋ'n-mɔ anwʋn ɛlɔ kɛ ɔ hɔ́ lé yɩ́ dɩɛ'n bɛ́lɛ yɩ́. ");
INSERT INTO any_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Kpafʋ'n-mɔ kɔ hyɩ akʋa'n bɛ kɔ bʋ yɩ́ dede bɛ kɔ hɩhan yɩ́ nun ɔ kɔ fa yɩ́ sa to ɔ kɔ sa kɔ hɔ. ");
INSERT INTO any_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Bian'n kɔ sʋan yɩ́ akʋa'n kʋn biekun bɛ́ nwʋn ɛlɔ. Bɛ kɔ hyɩ yɩ́ kʋsʋ bɛ kɔ tʋtʋ yɩ́ ti nɩn anun kɔtɔlɛ. Bɛ kɔ kpɩkpɛ yɩ́ nzʋba, bɛ kɔ hɩhan yɩ́ nun. ");
INSERT INTO any_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Yɩ́ kpɛ̂ nsan nɩn asʋ, bian'n kɔ sʋan yɩ́ akʋa'n kʋn biekun bɛ́ nwʋn ɛlɔ. Nan yɩ́ dɩɛ, bɛ kɔ hun yɩ́. Ɛsɛ bian'n kɔ sʋan yɩ́ ngʋa'n-mɔ dɔʋn bɛ́ nwʋn ɛlɔ biekun. Bɛ kɔ hyɩ mmie-mɔ bɛ kɔ bʋ bɛ́, bɛ kɔ hun mmie-mɔ kʋsʋ. ");
INSERT INTO any_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","“Sʋanlan mɔ ɔ'a ha bian nɩn asa nun'n y'ɔ le yɩ́ wa baa belenzua kʋnmgba cein'n. Kasian'n, ɔ kɔ sʋan baa sɔ'n m'ɔ tɩ yɩ́ ehulo baa'n. Yɩ́ nwan: ‘Kɛmɔ ɔ tɩ mɩ́n kunnun baa'n, mɩn de mɩn di kɛ bɛ 'ba man yɩ́ anyɩnnzɔ.’ ");
INSERT INTO any_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","“Nan mɛlɛ mɔ bɛ́ nyɩn bɔlɩ bian nɩn awa'n, bɛ kɔ han yɩ́ bɛ́ afian ɛlɔ kɛ: ‘Bɛ nɩ́an, yɩ́ koliaja'n yɛ̂ ɔ lɛ ba nɩn ɔ. Bɛ mán yɛ hún yɩ́, anɩn yɩ́ ajâ nɩn a yɔ yɛ́ dɩɛ.’ ");
INSERT INTO any_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","“Ɛhɩ a, bɛ kɔ sɔ yɩ́ bɛ kɔ hun yɩ́. Bɛ kɔ yɩ yɩ́ fuin nɩn ebo nɩn asʋ.” ");
INSERT INTO any_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Zozi kɔ bisa bɛ́ kɛ: “Sʋanlan'n m'ɔ le ebo'n, anɩn nzu yɛ̂ ɔ 'yɔ ɔ? Sɛ ɔ ba a, ɔ 'kun kpafʋ'n-mɔ ɔ fa yɩ́ ebo'n ɔ wula menian nvʋfɔlɛ asa nun. ");
INSERT INTO any_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Asʋ ɛmɔ kɩnngalɩ man ɛjɔlɛ ɛhɩ Ɛhɛlɛ Ɛjɔlɛ nɩn anun lé ɔ? B'a hɛlɛ yɩ́ nun kɛ: Ɛbʋɛ'n mɔ bɛ́ mɔ bɛ lɛ si sua nɩn a ju a tʋ'n, yɩ́ yɛ̂ ɔ'a kaci ayialɩɛ nɩn asʋ ɛbʋɛ'n m'ɔ le sua nɩn anun nɩn ɔ. ");
INSERT INTO any_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Ɛ 'nwun like mɔ yɛ́ Mɩn a yɔ'n, ɔ yɔ ɛnyɩnmɩn wɔ yɛ́ nyɩnsʋ.” ");
INSERT INTO any_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Zufʋ mgbain'n-mɔ kɔ nwun yɩ́ kɛ bɛ́ ti yɛ̂ Zozi a bu yɩ́ anyɩnndala sɔ nɩn ɔ. Ɛhɩ ati, bɛ kpʋnndɛlɩ atɩn mɔ bɛ 'sɩn sʋ bɛ cɩ yɩ́. Nan kʋsʋ meninsʋnman'n dunman nun, bɛ sulo. Bɛ kɔ yaci yɩ́ bɛ kɔ hɔ. ");
INSERT INTO any_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Bɛ kɔ sʋan *Falisifʋɛ'n mmie-mɔ nʋn belemgbin Elɔdɩ menian'n mmie-mɔ Zozi anwʋn ɛbɛlɛ kɛ bɛ hɔ́ tétie yɩ́ nʋan nun. ");
INSERT INTO any_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Bɛ walɩ tʋlɩ yɩ́ a, bɛ́ nwan: “Kpain, yɛ sɩ kɛ wɔ́ dɩɛ, ɛ kan ananhɔlɛ. Menian'n-mɔ ajʋnlɩn mɔ bɛ kɔ fa'n, ɛ nzulo man yɩ́ nzin. Afɩ ɛ nnɩan man sʋanlan nyunnun ɛ mmua man yɩ́ ndɛɛ. Like mɔ Nyanmɩan kulo kɛ sʋanlan yɔ́'n, ɛ kele yɩ́ ananhɔlɛ. Asʋ yɛ́ mala'n kele kɛ yɛ túa ajule yɛ mán Lɔmʋn belemgbin *Sezaa ɔ? Sɛ yɛ túa a, kan. Sɛ nán yɛ tua kʋsʋ a, kan.” ");
INSERT INTO any_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Nan Zozi nwunlin bɛ́ ajʋnlɩn'n mɔ b'a fa'n, ɔ kɔ bisa bɛ́ kɛ: “Nzukɛ ati yɛ̂ ɛmɔ lɛ tetie mɩ́n nʋan nun ɔ? Ɛmɔ fá bɛ́ esika'n kʋn bɛ mán n nɩ́an.” ");
INSERT INTO any_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Bɛ kɔ fa kʋn bɛ kɔ bɛlɛ yɩ́. Zozi kɔ bisa bɛ́ kɛ: “Nwan nvoninnin dɩɛ ɔ nʋn dunman benin yɛ̂ ɔ wɔ esika nɩn asʋ ɔ?” Bɛ́ nwan: “Belemgbin Sezaa ɔ.” ");
INSERT INTO any_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Zozi nwan: “M'ɔ tɩ Sezaa dɩɛ'n, ɛmɔ fá man yɩ́, yɛ̂ m'ɔ tɩ Nyanmɩan kʋsʋ dɩɛ'n, ɛmɔ fá man yɩ́.” Zozi mmua sɔ'n kɔ sin bɛ́ kʋalaa bɛ́ nwʋn. ");
INSERT INTO any_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Ɛhɩ anzin, *Sadusifʋɛ'n-mɔ mɔ bɛ́ nwan sʋanlan wu a, ɔ fi ewue nun ɔ ndinnge man'n, bɛ́ mmie-mɔ kɔ a Zozi anwʋn ɛbɛlɛ. Bɛ kɔ bisa yɩ́ kosuan kʋn kɛ: ");
INSERT INTO any_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Kpain, Moyizɩ a hɛlɛ a man yɛ́ kɛ: Belenzua kʋn m'ɔ nʋn yɩ́ yɩ b'a nwʋ man baa fɩ́ɩ́ dede nán sɛ ɔ wu a, yɩ́ nianman'n fá yɩ́ yɩ'n. Ɔ nʋn yɩ́ bɛ wʋ́ mma maan bɛ lí m'ɔ wuli nɩn aja nun. ");
INSERT INTO any_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Nan daba anɩn anianman mmelenzua nsʋ wɔ ɛbɛlɛ. Nunhan kpain'n jalɩ balasua kʋn. Ɔ nʋn yɩ́ b'a nwʋ man baa fɩ́ɩ́ dede ɔ wuli. ");
INSERT INTO any_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","M'ɔ tɔtʋa yɩ́'n, ɔ jalɩ balasua sɔ'n, ɔ nʋn yɩ́ b'a nwʋ man baa fɩ́ɩ́ dede ɔ wuli. Yɩ́ nsan nɩn asʋ'n, kɛ ɔ tɩ yɩ́ nɩn ala'n. ");
INSERT INTO any_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Bɛ le yɩ́ sɔ dede bɛ́ anianman nsʋ'n kʋalaa bɛ kɔ yue wu. Bɛ́ bie fɩ́ɩ́ nʋn balasua nɩn a nwʋ man baa. Balasua'n kʋsʋ kɔ wu. ");
INSERT INTO any_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Ewuetinnge cɩan'n, mɔ menian'n-mɔ kʋalaa 'ba tinnge'n, bɛ́ anianman nsʋ'n, nunhan benin yɛ̂ ɔ 'ja balasua'n biekun ɔ? Afɩ bɛ́ anianman nsʋ'n kʋalaa nunhan kʋn biala jalɩ balasua sɔ'n bie.” ");
INSERT INTO any_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Zozi kɔ bua bɛ́ kɛ: “Kɛmɔ ɛmɔ nzɩ man Nyanmɩan Anʋan Ɛjɔlɛ'n, ɔ nʋn Nyanmɩan tunmin'n, yɩ́ ti yɛ̂ ɔ man ɛmɔ a fʋn ɔ. ");
INSERT INTO any_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Ɔ sanlɩn kɛ ewuetinnge cɩan'n, mmelenzua'n-mɔ ngɔ ja man mmala. Mmala'n-mɔ kʋsʋ ngɔ ja man mmian. Bɛ 'ba kaci kɛ nyanmɩansʋ mmɔfʋɛ'n-mɔ. ");
INSERT INTO any_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","M'ɔ tɩ ewuetinnge nɩn anwʋn ɛjɔlɛ'n, ɛjɔlɛ mɔ Moyizɩ hɛlɛlɩ'n, ɛmɔ kɩnngalɩ man yɩ́ lé ɔ? Kalata'n lɛ kele kɛ anɩn sɩ̂n'n lɛ sɔ baka kaan kʋn ati sʋ. Nyanmɩan fɛlɛlɩ Moyizɩ a, yɩ́ nwan: N dɩ Abalahamʋn Nyanmɩan, Izakɩ Nyanmɩan, ɛsɛ n dɩ Zʋakɔbʋ kʋsʋ Nyanmɩan? ");
INSERT INTO any_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Ɛmɔ a fʋn bɔkɔɔ. Ɔ sanlɩn kɛ, Nyanmɩan tɩ man ewue mma'n-mɔ Nyanmɩan. Nan ɔ tɩ ngʋan mma'n-mɔ Nyanmɩan.” ");
INSERT INTO any_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Mɛlɛ mɔ *Sadusifʋɛ'n-mɔ nʋn Zozi 'jʋjɔ'n, *mala nɩn asʋ kpain'n kʋn tɩlɩ bɛ́ ngan. Kɛmɔ ɔ nwunlin kɛ Zozi a bua Sadusifʋɛ'n-mɔ kpa'n, ɔ kɔ kpʋnnge yɩ́ nwʋn ɛlɔ, yɩ́ nwan: “Mala benin yɛ̂ ɔ tɩ kpili tala mala'n-mɔ kʋalaa ɔ?” ");
INSERT INTO any_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Zozi kɔ bua yɩ́ kɛ: “Mala'n m'ɔ li mʋa'n y'ɔ le ɛhɩ: Izalayɛ amma, bɛ tíe, yɛ́ Mɩn Nyanmɩan angʋnmɩn yɛ̂ ɔ tɩ Nyanmɩan ɔ. ");
INSERT INTO any_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Fa wɔ́ ahʋnlɩn'n kʋalaa, ɔ nʋn wɔ́ ɛkala'n kʋalaa, ɔ nʋn wɔ́ ajʋnlɩn'n kʋalaa, ɔ nʋn wɔ́ anwʋnsɛlɛ'n kʋalaa kulo yɛ́ Mɩn Nyanmɩan. ");
INSERT INTO any_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","M'ɔ tian yɩ́ nnyuan'n, y'ɔ le ɛhɩ: Kulo wɔ́ manngʋn kɛ wɔ́ muonun wɔ́ nwʋn. Mala fɩ́ɩ́ nnʋn man ɛbɛlɛ m'ɔ tala mala nnyuan ɛhɩ ɔ.” ");
INSERT INTO any_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Mɔ Zozi hanlɩn ɛhɩ'n, mala nɩn asʋ kpain'n nwan: “Kpain, fɔ́ʋ́n, a han ananhɔlɛ! Nyanmɩan tɩ kʋnmgba cein, bie fɩ́ɩ́ kʋ́n nnʋn man yɩ́ nzin. ");
INSERT INTO any_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Sɛ ɛ fa wɔ́ ahʋnlɩn'n kʋalaa, ɔ nʋn wɔ́ ajʋnlɩn'n kʋalaa, ɔ nʋn wɔ́ anwʋnsɛlɛ'n kʋalaa, ɛ kulo Nyanmɩan, ɛ kulo wɔ́ manngʋn kɛ ɛ kulo wɔ́ muonun wɔ́ nwʋn nɩn an, ɔ tɩ kpa tala tɛɛ ɛyɩɛ nʋn afɔlɩɛ ngacile'n kʋalaatin.” ");
INSERT INTO any_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Bian'n kɔ bua ɛjɔlɛ'n ngɛlɛ sʋ. Yɩ́ ti, Zozi hanlɩn helelɩ yɩ́ kɛ: “A mantan Nyanmɩan Belemgbin Mân'n.” Mɔ Zozi hanlɩn sɔ'n, sʋanlan fɩ́ɩ́ a mmisa man yɩ́ kosuan fɩ́ɩ́ kʋ́n. ");
INSERT INTO any_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Anɩn Zozi wɔ Nyanmɩan awulo nɩn anun, ɔ lɛ kekele menian'n-mɔ ninnge. Ɔ kɔ bisa bɛ́ kɛ: “Ɔ yɔ sɛ mɔ *mala nɩn asʋ mgbain'n-mɔ kʋalaa kan kɛ belemgbin Davidi awa y'ɔ le *Kilisi'n? ");
INSERT INTO any_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Davidi muonun, mɔ Nyanmɩan Wawɛ'n wʋlʋlɩ yɩ́ nun'n, yɩ́ nwan: Ɛdannganman a han a hele mɩ́n Mɩn kɛ: Tanlan mɩ́n fama sʋ, nán mɩn 'ba fa wɔ́ mgbɔfʋɛ'n-mɔ mɩn gua wɔ́ ja abʋ. ");
INSERT INTO any_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Davidi muonun fɛlɛlɩ yɩ́ Mɩn. Anɩn ɔ yɔ sɛ m'ɔ kʋala kɛ ɔ yɔ yɩ́ wa'n?” Meninsʋnman'n le fɛ elie bɛ tie ɛjɔlɛ'n mɔ Zozi lɛ kan'n. ");
INSERT INTO any_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Zozi like ehehele nɩn anun, ɔ kɔ han kɔ hele meninsʋnman'n kɛ: “Ɛmɔ nɩ́an bɛ́ nwʋn kpa wɔ mala nɩn asʋ mgbain'n-mɔ anwʋn. Bɛ kulo taladɩɛ ndɩnndɩɩn ewula nanndɩ menian'n-mɔ anun. Gua nɩn asʋ, bɛ kulo kɛ menian'n-mɔ man bɛ́ anyɩnnzɔ. Bɛ 'bisa bɛ́ ahɩn an, bɛ kan kɛ: ‘Kpain, ahɩn o!’ ");
INSERT INTO any_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Sɛ menian yia nán bɛ 'didi tɔbɩlɩ'n-mɔ anwʋn an, menian mgbili mgbili lɩka yɛ̂ bɛ kpʋnndɛ ɔ. Bɛ kɔ asɔnɩn sua'n-mɔ anun an, bia'n-mɔ m'ɔ jijin bɛ́ nyunnun'n, sʋ yɛ̂ bɛ tanlan ɔ. ");
INSERT INTO any_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Bɛ kpʋkpʋ kunlannvʋɛ'n-mɔ anwʋn kpa bɔkɔɔ. Bɛ 'yɔ asɔnɩn an, bɛ yɔ mmʋtʋɛ ndɩnndɩɩn bɛ kele bɛ́ nwʋn kɛ bɛ tɩ meninkpa. Bɛ́ nyɔlɩɛ sɔ'n-mɔ anwʋn, ahatua mɔ bɛ 'ba nyan yɩ́'n, ɔ tɩ kpili sʋnman.” ");
INSERT INTO any_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Mɔ Zozi hanlɩn sɔ yuelɩ'n, ɔ kɔ tanlan asɩ Nyanmɩan awulo nɩn anun lɩka mɔ bɛ tʋ acɛdɩɛ'n. Kɛ meninsʋnman'n kpɩn tʋ esika'n, Zozi tɩ ɛbɛlɛ yɩ́ nyɩn ta bɛ́. Esikafʋɛ nwala kpa kɔ gua nun esika dɔʋn. ");
INSERT INTO any_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Kunlannvʋɛ balasua kʋn kɔ a, ɔ tɩ ehianfʋɛ kpa. Ɔ kɔ tʋ babulu ngʋkʋn ngʋkʋn nnyuan alaka nɩn anun. ");
INSERT INTO any_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Mɔ Zozi nwunlin yɩ́ sɔ'n, ɔ kɔ fɛlɛ yɩ́ menian'n-mɔ. Yɩ́ nwan: “Mɩɩn kan yɩ́ ananhɔlɛ mɩn kele ɛmɔ kɛ, ehianfʋɛ kunlannvʋɛ balasua ɛhɩ, ɔ'a tʋ esika dɔʋn ɔ'a tala bɛ́ kʋalaa mɔ b'a tʋ esika alaka nɩn anun'n. ");
INSERT INTO any_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Ɔ sanlɩn kɛ, bɛ́ kʋalaatin, esika mɔ bɛ mianlɩn man yɩ́ nwʋn'n yɛ̂ b'a fa b'a gua nun ɔ. Nan yɩ́ dɩɛ, yɩ́ ehianfʋɛ esika kaan m'ɔ le m'ɔ kɔ fa kɔ li alɩɛ'n yɛ̂ ɔ'a fa ɔ'a tʋ alaka nɩn anun nɩn ɔ.” ");
INSERT INTO any_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Mɔ Zozi fi Nyanmɩan awulo nɩn anun ɔ 'fite'n, yɩ́ menian'n-mɔ anun kʋn nwan: “Kpain, nɩan. Nyɔbʋɛ ɛhɩ-mɔ, nyanmɩnsɛmʋn, bɛ nnwun man yɩ́ nwʋn sʋ. B'a fa b'a sisi sua'n-mɔ nganlanman nganlanman sʋnman!” ");
INSERT INTO any_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Zozi kɔ se yɩ́ kɛ: “Ɛ nwun sua mgbili ɛhɩ-mɔ ɔ? Ɛbʋɛ baa kʋn ngɔ tanlan man yɩ́ mangʋn asʋ. Bɛ 'kan yɩ́ kʋalaa bɛ gua asɩ cɩan bie.” ");
INSERT INTO any_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Zozi fi ɛbɛlɛ ɔ kɔ hɔ kɔ fʋ *Olivʋ bʋka nɩn asʋ ɔ kɔ tanlan asɩ. Bʋka sɔ'n nʋn Nyanmɩan awulo nɩn anyɩn wɔ sʋ. Kɛmɔ ɔ nʋn Pɩɛlɩ nʋn Zʋan, nʋn Zʋakɩ nʋn Andele angʋnmɩn ala yɛ̂ bɛ hɔlɩ'n, bɛ kɔ bisa yɩ́ kɛ: ");
INSERT INTO any_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Anɩn cɩan benin yɛ̂ nyɔbʋɛ sɔ'n-mɔ 'kan gua asɩ ɔ, kan kele yɛ́? Sɛ mɛlɛ'n ju kʋsʋ a, nzɔlɛ benin yɛ̂ bɛ 'fa bɛ nwun yɩ́ kɛ yɩ́ ayuelɩɛ tɛmʋn a ju ɔ?” ");
INSERT INTO any_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Ɛhɩ a, Zozi kɔ sʋsɔ ɛjɔlɛ sʋ. Yɩ́ nwan: “Ɛmɔ nɩ́an bɛ́ nwʋn kpa nán abie a nnaka man ɛmɔ. ");
INSERT INTO any_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Ɔ sanlɩn kɛ menian dɔʋn 'ba nanndɩ mɩ́n dunman nɩn asʋ nan kʋn biala kan kɛ: ‘Kilisi'n, Belemgbin Ngʋandefʋɛ'n y'ɔ le mɩ́n.’ Bɛ 'kan sɔ bɛ laka menian dɔʋn. ");
INSERT INTO any_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Sɛ ɛmɔ tɩ kɛ bɛ lɛ kan ɛlɔɛ ɛjɔlɛ, anaan ɛmɔ tɩ ɛlɔɛ angan an, nán bɛ man bɛ́ lʋa bɔ bɛ́ nwʋn. Ɔ sɛ kɛ ninnge sɔ'n-mɔ jú sʋ, nan kʋsʋ anɩn ayuelɩɛ'n juli man. ");
INSERT INTO any_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Mân kʋn 'ba jasʋ ɔ nʋn mân kʋn bɛ kʋn ɛlʋɛ. Belemgbin mân kʋn 'ba jasʋ ɔ nʋn belemgbin mân kʋn bɛ kʋn ɛlʋɛ. Asɩɛ'n 'ba kpusu wɔ lɩka dɔʋn. Ɛhɔɛ 'ba kpɩn. Ɛhɩ kʋalaa 'ba yɔ kɛ awɔlɛ yalɛ nɩn abʋbɔ'n. ");
INSERT INTO any_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Ɛmɔ nɩ́an bɛ́ nwʋn kpa. Bɛ 'ba fa ɛmɔ bɛ kɔ bɛ́ mɔ bɛ di ɛjɔlɛ'n-mɔ aja sʋ. Bɛ 'ba bʋ ɛmɔ Zufʋ'n-mɔ asɔnɩn sua'n-mɔ anun. Bɛ nʋn ɛmɔ 'ba hɔ mân mgbain'n-mɔ, nʋn mmelemgbin'n-mɔ anyunnun wɔ mɩ́n dunman nun maan ɛmɔ di mɩ́n nwʋn adanzɩɛ. ");
INSERT INTO any_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Afɩ ɔ fata kɛ bɛ di mʋa bɛ bɔ Ɛjɔlɛkpa'n bɛ kele eyuadɩ nɩn anun menian'n-mɔ kʋalaatin. ");
INSERT INTO any_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","“Mɛlɛ mɔ bɛ kɔ hyɩ ɛmɔ, bɛ nʋn ɛmɔ kɔ hɔ bɛ́ mɔ bɛ di ɛjɔlɛ'n-mɔ aja sʋ'n, ɛjɔlɛ m'ɔ di mɔ ɛmɔ kan'n, nán bɛ di mʋa bɛ susu yɩ́ nwʋn. Nan ɛjɔlɛ m'ɔ kɔ tɔ ɛmɔ ati anun dɔhyʋɩlɩ sɔ nɩn anun'n, ɛmɔ hán. Ɔ sanlɩn kɛ Wawɛ Nwannzan-nwannzan'n yɛ̂ ɔ 'fa ɛjɔlɛ sɔ'n wula ɛmɔ anʋan maan ɛmɔ kan ɔ. ");
INSERT INTO any_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Anianman'n 'ba yɩ yɩ́ nianman maan bɛ kun yɩ́. Sɩɛ'n-mɔ kʋsʋ 'ba yɩ bɛ́ mma'n-mɔ maan bɛ kun bɛ́. Mma'n-mɔ kʋsʋ 'ba jasʋ bɛ́ sɩ-mɔ akɔmɩn anun maan bɛ kun bɛ́. ");
INSERT INTO any_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Mɩ́n dunman nun, menian'n-mɔ kʋalaa 'ba fa ɛmɔ anwʋn ɛkpɔ. Nan nunhan m'ɔ kɔ jinlan kpunndiin dede ɔ kɔ ju yɩ́ ayuelɩɛ'n, ɔ 'nyan yɩ́ ti. ");
INSERT INTO any_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Ɛmɔ 'ba nwun like ɛtɛ kpili'n m'ɔ bɔ alʋa m'ɔ man sʋanlan anwʋn bubu yɩ́'n kɛ ɔ jin lɩka m'ɔ nvata man kɛ ɔ jinlan'n. (Sʋanlan m'ɔ lɛ kɩnnga lɩka sɔ'n, ɔ tɩ́ yɩ́ bʋ kpa.) Tɛmʋn sɔ'n, bɛ́ mɔ bɛ wɔ Zude mân nɩn anun'n, bɛ nwánndi bɛ hɔ́ mmʋka'n-mɔ asʋ. ");
INSERT INTO any_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Sʋanlan m'ɔ kɔ fʋ yɩ́ sua nɩn ati sʋ'n, n'ɔ ju kɔ yɩ́ sua nɩn anun, ɔ fa like. ");
INSERT INTO any_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","M'ɔ kɔ hɔ ebolo'n, n'ɔ sa ba kulo, n'ɔ sa ba fa taladɩɛ. ");
INSERT INTO any_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Mɛlɛ sɔ'n, mmalasua'n-mɔ mɔ bɛ lɛ nwʋnnzɛ'n, ɔ nʋn bɛ́ mɔ bɛ lɛ nʋan mma'n, bɛ́ yakɔ! ");
INSERT INTO any_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Ɛmɔ sɛ́lɛ Nyanmɩan kɛ n'ɔ man mɛlɛ sɔ'n yia fɔsɩɛ nun. ");
INSERT INTO any_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Ɔ sanlɩn kɛ Nyanmɩan bɔlɩ mân'n dede m'ɔ ju ɛnɛ'n, bɛ nwunlin man yɩ́ nwʋn sʋ yalɛ sʋa lé. Yɛ̂ yɩ́ nwʋn sʋ yalɛ fɩ́ɩ́ ngɔ a man kʋ́n. ");
INSERT INTO any_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Sɛ yɛ́ Mɩn a mgbɛ man cɩan sɔ'n-mɔ asʋ a, sʋanlan fɩ́ɩ́ nnyan man yɩ́ ti. Nan bɛ́ mɔ ɔ'a kpa bɛ́ ɔ'a yɔ yɩ́ dɩɛ'n dunman nun, ɔ'a kpɛ cɩan sɔ'n-mɔ asʋ. ");
INSERT INTO any_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Yɩ́ ti, sɛ abie se ɛmɔ kɛ: ‘Ɛmɔ nɩ́an, Kilisi'n, Belemgbin Ngʋandefʋɛ'n, ɔ wɔ ɛwa anaan ɔ wɔ ɛlɔ’ a, nán bɛ tɛ yɩ́ sʋ. ");
INSERT INTO any_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Ato Kilisi, nʋn ato mgbɔmanfʋɛ dɔʋn 'ba fite. Bɛ 'ba yɔ nzɔlɛ nʋn asinbɛnwʋn ninnge bɛ bɔ menian'n-mɔ apoo. Ɛsɛ bɔbɔ, sɛ bɛ kʋala yɩ́ yɔ a, bɛ 'laka bɛ mɔ Nyanmɩan a kpa bɛ́ a yɔ yɩ́ dɩɛ'n-mɔ. ");
INSERT INTO any_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Nan ɛmɔ dɩɛ, m'an li mʋa m'an kannzʋ ɛmɔ! Yɩ́ ti, ɛmɔ nɩ́an bɛ́ nwʋn kpa. ");
INSERT INTO any_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Nan mɛlɛ sɔ nɩn anun, yalɛ elie mɛlɛ nɩn anzin, sɛnzɛ'n 'ba lu tuun, sala'n ngɔ ta man kʋ́n. ");
INSERT INTO any_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Nzalama'n-mɔ fi anwunno bɛ 'ba tutu bɛ gua asɩ. Anwunno ɛlɔ ninnge sɔ'n-mɔ kʋalaatin 'ba kpusu. ");
INSERT INTO any_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Ɛbɛlɛ nɩn anun, bɛ 'ba nwun Mân Baa'n, kɛ ɔ fi bɔlɛ́ nɩn anun nyanmɩansʋ ɔ lɛ ba. Ɔ le tunmin kpili kpa ɔ nʋn anunminnyanmʋn. ");
INSERT INTO any_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Tɛmʋn sɔ nɩn anun, ɔ nʋn yɩ́ nyanmɩansʋ mmɔfʋɛ'n-mɔ yɛ̂ ɔ 'ba a ɔ. Ɔ 'ba hohuan yɩ́ menian'n-mɔ mɔ bɛ wɔ asɩɛ nɩn asʋ ɛwa lɩka kʋalaa nɩn anʋan. ");
INSERT INTO any_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Ɛmɔ fá bɛ́ nyɩn bɛ tʋ́ figi baka nɩn anwʋn. Mɛlɛ mɔ ɛmɔ kɔ nwun kɛ asaa mma a fifi yɩ́ nwʋn'n, mɔ yɩ nyâ'n lɛ wula'n, anɩn ɛmɔ sɩ kɛ mɛlɛ kpa'n mɔ bɛ nyan sʋ mma nɩn a kpunnge. ");
INSERT INTO any_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Yɩ́ sʋ kʋsʋ ala, mɛlɛ mɔ ɛmɔ kɔ nwun ɛhɩ kʋalaa'n, anɩn ɛmɔ sɩ kɛ Mân Baa nɩn ɛwalɛ nɩn a ju a yue, ɔ'a mantan ɛmɔ kʋkʋ. ");
INSERT INTO any_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Mɩɩn kan yɩ́ ananhɔlɛ mɩn kele ɛmɔ kɛ ajulisʋ menian ɛhɩ-mɔ ngɔ yue man wu nán ninnge sɔ'n-mɔ tɛmʋn a ju. ");
INSERT INTO any_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Anwunno nʋn asɩ 'ba kpɛ nun, nan mɩ́n Nʋan Ɛjɔlɛ'n dɩɛ, ɔ mgbɛ man nun lé. ");
INSERT INTO any_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Nan kʋsʋ cɩan sɔ'n, anaan dɔɛ sɔ'n, yɩ́ dɩɛ, sʋanlan fɩ́ɩ́ nzɩ man. Nyanmɩansʋ mmɔfʋɛ'n-mɔ o, Nyanmɩan Awa nɩn o, bɛ́ fɩ́ɩ́ bɛ nzɩ man. Sɩɛ nɩn angʋnmɩn yɛ̂ ɔ sɩ ɔ. ");
INSERT INTO any_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Ɛmɔ nɩ́an bɛ́ nwʋn kpa, ɛmɔ tánlan bɛ sísa. Afɩ ɛmɔ nzɩ man mɛlɛ mɔ ninnge sɔ'n-mɔ kɔ a ɔ. ");
INSERT INTO any_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Ɔ tɩ kɛ sʋanlan m'ɔ lɛ kɔ atɩn, mɔ ɔ'a yaci yɩ́ awulo'n ɔ'a wula yɩ́ ngʋa'n-mɔ asa nun ɔ. Ɔ'a fa sʋanlan kʋn junman dɩɛ m'ɔ fata kɛ ɔ di'n ɔ'a man yɩ́. Ɔ fɛlɛlɩ sʋanlan'n m'ɔ sisa awulo nɩn an, yɩ́ nwan: ‘Wɔ́ dɩɛ, n'ɛ dafɩ.’ ");
INSERT INTO any_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Yɩ́ ti, ɛmɔ tánlan bɛ sísa. Afɩ ɛmɔ nzɩ man mɛlɛ mɔ sʋanlan'n m'ɔ le awulo'n kɔ a ɔ. ");
INSERT INTO any_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Sɛ ɔ 'ba nɔsʋba e, sɛ alɩmunnun e, sɛ alɩbahɩan e, sɛ ngɛlɛmɔ e, ɛmɔ nzɩ man. Afɩ, sɛ ɔ ba nvu nun, nán ɛmɔ lɛ dafɩ a, ɔ ngɔ yɔ man sɛsɛ. ");
INSERT INTO any_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Mɔ mɩɩn kan mɩn kele ɛmɔ'n, mɩɩn kan mɩn man menian'n-mɔ kʋalaatin: Ɛmɔ tánlan bɛ sísa.” ");
INSERT INTO any_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","M'ɔ ka cɩan nnyuan nán Pakɩ'n nʋn kpaʋn'n mɔ fali ayile nnʋn man nun'n fɛtɩ nɩn a ju'n, Nyanmɩan tɛɛyɩfʋɛ mgbain'n-mɔ, nʋn mala nɩn asʋ mgbain'n-mɔ kɔ kpʋnndɛ atɩn mɔ bɛ 'sɩn sʋ nán bɛ cɩ Zozi bɛ kun yɩ́. ");
INSERT INTO any_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Ɛhɩ, bɛ kɔ han yɩ́ bɛ́ afian ɛlɔ kɛ: “Nán bɛ man yɛ cɩ yɩ́ fɛtɩ nɩn anun. Sɛ yɛ cɩ yɩ́ fɛtɩ nɩn anun an, bagua'n 'ba jasʋ yɛ́ kɔmɩn anun.” ");
INSERT INTO any_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Anɩn Zozi wɔ Betanin. Ɔ kɔ sike bian kʋn awulo. Bian sɔ'n li Simʋn, ɔ tɩ kokobefʋɛ daba. Bɛ gua tɔbɩlɩ nɩn anwʋn mɔ bɛ 'di like'n, balasua kʋn kɔ a, ɔ le anatɩlɩ bondoman kʋn yɩ́ sa nun. Anatɩlɩ mɔ yɩ́ gua yɔ sɩ kpa wɔ bondoman sɔ nɩn anun. Baka'n mɔ bɛ fɛlɛ yɩ́ náá'n yɛ̂ bɛ fa bɛ yɔ anatɩlɩ sɔ nɩn ɔ. Balasua'n kɔ bo bondoman'n, ɔ kɔ kaci nun anatɩlɩ'n ɔ kɔ gua Zozi ati nɩn asʋ. ");
INSERT INTO any_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Balasua sɔ'n nyɔlɩɛ'n ngɔ yɔ man bɛ́ mɔ bɛ gua ɛbɛlɛ'n mmie-mɔ fɛ. Bɛ kɔ han yɩ́ bɛ́ afian ɛlɔ kɛ: “Anatɩlɩ ɛhɩ ɛsɛcɩɛ dɩɛ nɩn abʋ y'ɔ le benin? ");
INSERT INTO any_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Ahan bɛ kʋala kɛ bɛ tɔnɩn yɩ́ jɛtɛ fufue ɛya nsan bɛ fa yɩ́ esika'n bɛ ce ehianfʋɛ'n-mɔ!” Bɛ kɔ jʋjɔ balasua sɔ'n kpa. ");
INSERT INTO any_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Zozi nwan: “Ɛmɔ yáci yɩ́ koun. Nzukɛ ati yɛ̂ ɛmɔ lɛ di yɩ́ nwʋn yalɛ ɔ? Like kpa yɛ̂ ɔ'a yɔ ɔ'a man mɩ́n ɔ. ");
INSERT INTO any_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Ehianfʋɛ'n-mɔ dɩɛ, ɛmɔ nʋn bɛ́ gua ɛwa dahuu. Cɩan biala mɔ ɛmɔ kulo'n, ɛmɔ kʋala kɛ bɛ yɔ bɛ́ ye. Nan mɩ́n dɩɛ, ɛmɔ nʋn mɩn lɛ man ndanlanman daa. ");
INSERT INTO any_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","M'ɔ kʋala yɩ́ yɔ'n yɛ̂ ɔ'a yɔ ɔ. Ɔ'a li mʋa ɔ'a fa anatɩlɩ'n ɔ a gugua mɩ́n nwʋn. Ɔ tɩ kɛ mɩ́n esie yɛ̂ ɔ'a sie nɩn ɔ. ");
INSERT INTO any_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Mɩɩn kan yɩ́ ananhɔlɛ mɩn kele ɛmɔ kɛ eyuadɩ'n lɩka biala mɔ bɛ 'bɔ Ɛjɔlɛkpa'n, bɛ́ ti 'kacɩ balasua ɛhɩ bɛ kan like mɔ ɔ'a yɔ nɩn anwʋn ɛjɔlɛ.” ");
INSERT INTO any_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Mɔ Zozi hanlɩn sɔ yuelɩ'n, Zudasɩ Isikaliɔtɩ m'ɔ wɔ Zozi menian bulu nʋn nnyuan nɩn anun bie'n, ɔ kɔ hɔ kɔ tʋ tɛɛyɩfʋɛ mgbain'n-mɔ, kɛ ɔ 'yɩ Zozi man bɛ́. ");
INSERT INTO any_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Zudasɩ bɔlɩ bɛ́ amannɩɛ mɔ bɛ tɩlɩ ɛjɔlɛ sɔ'n, bɛ lili yɩ́ nwʋn fɛ kpa. Bɛ kɔ han bɛ kɔ hele yɩ́ kɛ sɛ ɔ man bɛ́ sa kan Zozi sakpa a, bɛ 'man yɩ́ esika. Zudasɩ kɔ kpʋnndɛ atɩn mɔ ɔ 'sɩn sʋ ɔ yɩ Zozi man'n. ");
INSERT INTO any_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Ɛhɩ, cɩan'n mɔ bɛ kun tɛɛ ɛyɩɛ bʋa'n, cɩan sɔ'n kʋnmgba yɛ̂ bɛ di kpaʋn'n mɔ fali ayile nnʋn man nun'n fɛtɩ'n, Zozi menian'n-mɔ kɔ bisa yɩ́ kɛ: “Ninhan yɛ̂ ɛ kulo kɛ yɛ hɔ́ tʋ́n *Pakɩ alɩɛ nɩn ɔ?” ");
INSERT INTO any_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Ɛhɩ a, Zozi kɔ sʋan yɩ́ menian'n-mɔ anun nnyuan, yɩ́ nwan: “Ɛmɔ hɔ́ kulo nɩn asʋ, ɛmɔ nʋn belenzua kʋn 'ba yia. Ɔ sʋ nzue awʋa kʋn anun. Ɛmɔ sí yɩ́ sʋ, ");
INSERT INTO any_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","nán lɩka m'ɔ kɔ wʋlʋ'n, ɛmɔ sé awulo nɩn asʋ mɩnlɩan'n kɛ: ‘Yɛ́ Mɩn nwan yɛ bísa wɔ́ kɛ sua'n m'ɔ nʋn yɩ́ menian'n-mɔ 'di Pakɩ'n nun'n wɔ nin?’ ");
INSERT INTO any_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Nán ɔ 'ba hele ɛmɔ dabɛlɛ kpili kʋn awaa nɩn asʋ ɛlɔ. B'a yue nun sesie. Ɛmɔ sésie Pakɩ alɩɛ nɩn ɛbɛlɛ.” ");
INSERT INTO any_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Zozi menian nnyuan'n kɔ hɔ kɔ ju kulo nɩn asʋ. Mɔ bɛ juli ɛlɔ'n, kɛ Zozi kpɩnlɩn hanlɩn yɩ'n, bɛ nwunlin yɩ́ kʋalaa sɔ. Bɛ kɔ tʋn Pakɩ alɩɛ'n bɛ kɔ sesie yɩ́ ɛbɛlɛ. ");
INSERT INTO any_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Nɔsʋba, Zozi nʋn yɩ́ menian bulu nʋn nnyuan'n, bɛ kɔ a. ");
INSERT INTO any_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Bɛ gua tɔbɩlɩ nɩn anwʋn mɔ bɛ 'didi'n, Zozi nwan: “Mɩɩn kan yɩ́ ananhɔlɛ mɩn kele ɛmɔ kɛ ɛmɔ anun kʋn m'ɔ nʋn mɩ́n lɛ didi'n, ɔ 'ba yɩ́ mɩ́n man.” ");
INSERT INTO any_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Yɩ́ menian'n-mɔ anwʋn kɔ bubu bɛ́. Bɛ́ nunhan kʋn biala nwan: “Yɛ́ Mɩn, nán mɩ́n ɔ.” ");
INSERT INTO any_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Zozi nwan: “Ɛmɔ menian bulu nʋn nnyuan'n, nunhan mɔ mɩn nʋn yɩ́ yɛ́ sa wɔ talie kʋn anun'n, yɩ́ dein ɔ. ");
INSERT INTO any_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","*Mân Baa'n 'ba wu kɛ bɛ kpɩnlɩn bɛ hanlɩn yɩ́ wɔ Ɛhɛlɛ Ɛjɔlɛ kalata nɩn anun'n. Nan sʋanlan'n mɔ ɔ 'ba yɩ yɩ́ man'n, munnzue hán yɩ́! Ɔ tɩ kpa kɛ ahan b'a nwʋ man sʋanlan sɔ'n bɔbɔ!” ");
INSERT INTO any_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Tɛmʋn mɔ bɛ 'di like'n, Zozi kɔ fa kpaʋn, ɔ kɔ la Nyanmɩan asɩ. M'ɔ lalɩ Nyanmɩan asɩ yuelɩ'n, ɔ kɔ bubu nun kɔ man yɩ́ menian'n-mɔ. Yɩ́ nwan: “Ɛmɔ lé kpaʋn ɛhɩ bɛ lí, ɔ tɩ mɩ́n nwʋnnaan.” ");
INSERT INTO any_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","M'ɔ hanlɩn sɔ yuelɩ'n, ɔ kɔ fa divɩn kangɔ kʋn. Ɔ kɔ la Nyanmɩan asɩ kɔ yue. Ɔ kɔ fa kɔ man bɛ́. Bɛ́ kʋalaa bɛ kɔ nʋn. ");
INSERT INTO any_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Yɩ́ nwan: “Nzan ɛhɩ tɩ mɩ́n moja. Ɔ di Nyanmɩan nyɩhyɛ'n m'ɔ nʋn ɛmɔ lɛ di nɩn ajinlanmun. Moja sɔ'n, b'a butu yɩ́ b'a man menian dɔʋn. ");
INSERT INTO any_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Mɩɩn kan yɩ́ ananhɔlɛ mɩn kele ɛmɔ kɛ mɩn nʋn ɛmɔ yɛ ngɔ nʋn man nzan fɩ́ɩ́ kʋ́n dede ɔ 'ju cɩan mɔ yɛ kɔ yia Nyanmɩan Belemgbin Mân nɩn anun'n yɛ̂ yɛ 'nʋn nzan fʋfɔlɛ ɔ.” ");
INSERT INTO any_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Mɔ Zozi hanlɩn sɔ yuelɩ'n, bɛ kɔ tʋ Izalayɛ ayɛ ɛyɩɛ ejue. Bɛ fi ɛbɛlɛ, bɛ kɔ fa *Olivʋ bʋka nɩn atɩn'n. ");
INSERT INTO any_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Bɛ hɔlɩ juli bʋka nɩn asʋ ɛlɔ a, Zozi nwan: “Ɛmɔ kʋala 'ba nwanndi mɩ́n. Afɩ b'a hɛlɛ yɩ́ kɛ: Mɩn 'ba hun bʋa ɛnɩanfʋɛ'n, yɩ́ mmʋa'n-mɔ kʋalaa 'ba bɔ asanndɩɛ.” ");
INSERT INTO any_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Nan Zozi selɩ bɛ́ kɛ: “Sɛ n vi ewue nun mɩn tinnge a, mɩn 'di mʋa ɛmɔ anyunnun Galile mân nɩn anun ɛlɔ.” ");
INSERT INTO any_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Pɩɛlɩ nwan: “Sɛ bɛ́ kʋalaa bɛ nwanndi wɔ́ a, mɩ́n kpʋnmgba cein dɩɛ mɩn nnwanndi man wɔ́.” ");
INSERT INTO any_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Ɛhɩ a, Zozi nwan: “Mɩɩn kan yɩ́ ananhɔlɛ mɩn kele wɔ́ kɛ, ɛnɛ kɔngɔɛ dein, ɔ nʋn dede mɔ akɔ'n 'bɔ kokolokoo fâ nnyuan'n, anɩn a han yɩ́ fâ nsan kɛ ɛ nzɩ man mɩ́n.” ");
INSERT INTO any_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","M'ɔ hanlɩn sɔ'n, Pɩɛlɩ kɔ han yɩ́ sɛlɛ kpa kɛ: “Sɛ ɔ fata kɛ mɩn nʋn wɔ́ yɛ wu bɔbɔ a, yɛ 'wu. Cɩan bie lé mɩn ngan man kɛ mɩn nzɩ man wɔ́.” Zozi menian'n-mɔ kʋalaa kɔ han sɔ. ");
INSERT INTO any_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","M'ɔ yɔlɩ sɔ'n, Zozi nʋn yɩ́ menian'n-mɔ hɔlɩ Olivʋ bʋka nɩn asʋ lɩka kʋn. Lɩka sɔ'n, bɛ fɛlɛ yɩ́ Gɛtɩsemane. Bɛ juli ɛbɛlɛ a, Zozi nwan: “Ɛmɔ tánlan ɛwa, nan mɩn 'tɩ mɩ́n nwʋn kaan mɩn yɔ asɔnɩn.” ");
INSERT INTO any_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Ɔ nʋn Pɩɛlɩ nʋn Zʋan nʋn Zʋakɩ bɛ kɔ tɩ bɛ́ nwʋn. Esulo nʋn alʋabɔ kɔ han Zozi. ");
INSERT INTO any_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Ɔ kɔ han kɔ hele yɩ́ menian nsan'n kɛ: “Ewue nɩn anwʋn alʋabɔ lɛ kun mɩ́n. Ɛmɔ tánlan ɛwa, bɛ sísa.” ");
INSERT INTO any_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","M'ɔ yɔlɩ sɔ'n, Zozi kɔ hɔ yɩ́ nyunnun kaan. Ɔ kɔ butu yɩ́ nyɩn asɩ ɔ kɔ sɛlɛ kɛ amannɩnhunlun'n m'ɔ 'ba nwun yɩ́ dɔhyʋɩlɩ sɔ nɩn anun'n, sɛ Nyanmɩan kʋala yɩ́ kpala gua a, ɔ kpála gúa. ");
INSERT INTO any_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Yɩ́ nzɛlɛ nɩn anun, yɩ́ nwan: “Aba, mɩ́n Sɩ, wɔ́ dɩɛ, like fɩ́ɩ́ nza man wɔ́ yɔ. Yɩ́ ti, amannɩnhunlun ɛhɩ mɔ mɩn 'ba nwun yɩ́'n, mɩn 'sɛlɛ wɔ́ kɛ ɛ kpála gúa. Nan kʋsʋ like biala anun, yɔ mɔ wɔ́ kunnun kulo nan n'ɛ yɔ mɔ mɩn kulo'n.” ");
INSERT INTO any_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","M'ɔ yɔlɩ sɔ'n, Zozi kɔ sa kɔ a yɩ́ menian nsan'n-mɔ anwʋn ɛbɛlɛ. Ɔ 'ba ju a, anɩn bɛ lɛ dafɩ. Ɔ fɛlɛlɩ Pɩɛlɩ a, yɩ́ nwan: “Simʋn, ɛ lɛ dafɩ? A ngʋala man asɩ tanlan dɔhyʋɩlɩ kʋnmgba cein? ");
INSERT INTO any_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Ɛmɔ tánlan asɩ bɛ yɔ́ asɔnɩn nán Abɔnsanmʋn a nzɔ man ɛmɔ a nnɩan man. Ɔ wɔ ɛmɔ ahʋnlɩn nɩn anun kɛ ɛmɔ 'yɔ, nan kʋsʋ anwʋnnaan'n le man anwʋnsɛlɛ.” ");
INSERT INTO any_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Ɔ kɔ yaci bɛ́ ɛbɛlɛ ɔ kɔ hɔ asɔnɩn ɛyɔlɛ biekun. Ɔ kɔ han ɛjɔlɛ kʋnmgba sɔ'n. ");
INSERT INTO any_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Ɛsɛ ɔ wɔ ɛlɔ dede ɔ 'ba ju a, yɩ́ menian'n-mɔ lɛ dafɩ. Bɛ ngʋala man bɛ́ nyɩn tɩ fɩ́ɩ́. Bɛ nnwun man ɛjɔlɛ mɔ bɛ kan bɛ kele yɩ́ ɔ. ");
INSERT INTO any_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","M'ɔ walɩ yɩ́ kpɛ̂ nsan nɩn asʋ'n, yɩ́ nwan: “Ɛmɔ tɛ dafɩ bɛ tɛ de bɛ́ ɛnwʋnmɩan? Ɔ'a yɔ kpa sɔ! Dɔɛ nɩn a ju. Ɛmɔ nɩ́an, bɛ 'ba yɩ *Mân Baa'n bɛ man menian ɛtɛfʋɛ'n-mɔ. ");
INSERT INTO any_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Ɛmɔ jásʋ bɛ mán yɛ hɔ́! Ɛmɔ nɩ́an, sʋanlan'n mɔ ɔ 'ba yɩ mɩ́n man'n, ɔ'a ju ɛwa.” ");
INSERT INTO any_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Zozi anʋan ngɔ tɔ man, yɩ́ menian bulu nʋn nnyuan nɩn anun kʋn'n mɔ bɛ fɛlɛ yɩ́ Zudasɩ'n kɔ fite ɛbɛlɛ. Ɔ 'ba a, menian dɔʋn si yɩ́ sʋ. Bɛ lile dadɩɛ nʋn koloman. Menian sɔ'n-mɔ, tɛɛyɩfʋɛ mgbain'n-mɔ, mala nɩn asʋ mgbain'n-mɔ nʋn Zufʋ mgbain'n-mɔ yɛ̂ bɛ sʋanlɩn bɛ́ ɔ. ");
INSERT INTO any_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Mɔ bɛ 'ba'n, Zudasɩ mɔ ɔ 'yɩ Zozi man'n kɔ hele bɛ́ nzɔlɛ kʋn. Yɩ́ nwan: “Sʋanlan'n mɔ n gɔ tɔ yɩ́ nun'n, anɩn ɛmɔ sɩ kɛ yɩ́ dein yɩ́ ɔ. Ɛmɔ hyɩ́ yɩ́. Bɛ sɔ́ yɩ́ kpa bɛ nʋn yɩ́ hɔ́.” ");
INSERT INTO any_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Mɔ Zudasɩ juli ɛbɛlɛ'n, ɔ kɔ kpunnge Zozi, yɩ́ nwan: “*Labi!” M'ɔ fɛlɛlɩ yɩ́ yuelɩ'n, ɔ kɔ tɔ yɩ́ nun. ");
INSERT INTO any_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Ɛbɛlɛ ala, menian sɔ'n-mɔ kɔ tɩ kɔ gua Zozi sʋ bɛ kɔ hyɩ yɩ́. ");
INSERT INTO any_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Nan mɔ menian sɔ'n-mɔ hyɩlɩ Zozi'n, yɩ́ menian'n-mɔ anun kʋn kɔ hyʋɩn yɩ́ dadɩɛ'n. Ɔ kɔ kpɛ Nyanmɩan tɛɛyɩfʋɛ kpain nɩn akʋa nɩn anzʋ'n. ");
INSERT INTO any_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","M'ɔ yɔlɩ sɔ'n Zozi nwan: “Nzukɛ ati yɛ̂ ɛmɔ 'ba hyɩ mɩ́n an, ɛmɔ le dadɩɛ nʋn koloman ɔ? Asʋ kodiawu y'ɔ le mɩ́n ɔ? ");
INSERT INTO any_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Cɩan daa mɩ́n nʋn ɛmɔ yɛ gua Nyanmɩan awulo nɩn anun, mɩn kekele ɛmɔ Nyanmɩan Anʋan Ɛjɔlɛ. Tɛmʋn sɔ'n, ɛmɔ ngʋala man kɛ bɛ cɩ mɩ́n. Nan ɔ sɛ kɛ ɔ yɔ́ sɔ nán ɛjɔlɛ'n mɔ Ɛhɛlɛ Ɛjɔlɛ'n hanlɩn nɩn a kpɩn sʋ.” ");
INSERT INTO any_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Ɛhɩ a, Zozi menian'n-mɔ kʋalaa kɔ yaci yɩ́ kɔ nwanndi. ");
INSERT INTO any_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Anɩn kpafɛlɛ kʋn si Zozi sʋ, kisaan ala yɛ̂ ɔ gua yɩ́ nwʋn ɔ. Bɛ kɔ hyɩ yɩ́, ");
INSERT INTO any_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","ɔ kɔ foti bɛ́ sa, ɔ kɔ yaci yɩ́ ɛtanlan nɩn ɛbɛlɛ. Ɔ kɔ fa yɩ́ nwʋn mgban ɔ kɔ nwanndi ɔ kɔ hɔ. ");
INSERT INTO any_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Bɛ nʋn Zozi kɔ hɔ Nyanmɩan *tɛɛyɩfʋɛ kpain nɩn anyunnun. Ɛbɛlɛ yɛ̂ Nyanmɩan tɛɛyɩfʋɛ mgbain'n-mɔ nʋn Zufʋ mgbain'n-mɔ, nʋn *mala nɩn asʋ mgbain'n-mɔ kʋalaa hɔlɩ yialɩ ɔ. ");
INSERT INTO any_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Pɩɛlɩ si Zozi sʋ, ɔ di yɩ́ fannvanndʋ. ɔ kɔ hɔ dede Nyanmɩan tɛɛyɩfʋɛ kpain nɩn awulo. Ɔ kɔ tanlan sɩ̂n nɩn anwʋn ɛbɛlɛ lɩka mɔ tɛɛyɩfʋɛ kpain'n nzalafʋ'n-mɔ gua'n. ");
INSERT INTO any_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Nyanmɩan tɛɛyɩfʋɛ mgbain'n-mɔ, nʋn bɛ́ kʋalaa mɔ bɛ di ɛjɔlɛ'n, bɛ kɔ kpʋnndɛ atɩn mɔ bɛ 'sɩn sʋ bɛ tʋn Zozi ɛsʋan, bɛ kun yɩ́. Bɛ kpʋnndɛlɩ, kʋsʋ bɛ ngɔ nyan man bie. ");
INSERT INTO any_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Afɩ menian mmie-mɔ dɔʋn kpa kɔ tʋn yɩ́ ɛsʋan, nan bɛ́ kʋnmgba'n b'a kpalɩ kpalɩ menian sɔ'n-mɔ abʋ. ");
INSERT INTO any_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Mmie-mɔ kɔ jasʋ, bɛ kɔ li ato bɛ kɔ tʋ Zozi abʋ. Bɛ́ nwan: ");
INSERT INTO any_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Y'a tɩ kɛ yɩ́ nwan: ‘Mɩn 'bubu Nyanmɩan awulo ɛhɩ mɔ menian'n-mɔ a si'n. Mɩn 'fa cɩan nsan mɩn si yɩ́ fʋfɔlɛ. Fʋfɔlɛ sɔ'n, nan kulo menian yɛ̂ bɛ 'si ɔ.’” ");
INSERT INTO any_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Nan ɛjɔlɛ kpɔlɛ kʋnmgba sɔ nɩn asʋ bɔbɔ, bɛ́ ngʋnmɩn, bɛ kɔ kpalɩ kpalɩ bɛ́ bʋ. ");
INSERT INTO any_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Ɛhɩ a, Nyanmɩan tɛɛyɩfʋɛ kpain'n kɔ jasʋ bɛ́ kʋalaa bɛ́ nyunnun ɛbɛlɛ, ɔ kɔ bisa Zozi kɛ: “Ɛjɔlɛ nwala ɛhɩ mɔ bɛ lɛ kan bɛ gua wɔ́ sʋ'n, ɛ mmua man bie ɔ?” ");
INSERT INTO any_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Zozi ngɔ buke yɩ́ nʋan ngɔ han ɛjɔlɛ fɩ́ɩ́. Nyanmɩan tɛɛyɩfʋɛ kpain'n kɔ bisa yɩ́ biekun kɛ: “Asʋ *Kilisi'n m'ɔ tɩ yɛ́ mân'n defʋɛ'n y'ɔ le wɔ́ ɔ? Nyanmɩan mɔ yɛ yɩ yɩ́ ayɛ'n, yɩ́ Wa y'ɔ le wɔ́ ɔ?” ");
INSERT INTO any_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","M'ɔ bisalɩ kosuan sɔ'n, Zozi nwan: “Yuo o, Kilisi'n y'ɔ le mɩ́n. Nan ɛmɔ kʋalaa bɛ 'ba nwun yɩ́ kɛ Mân Baa'n tɩ Nyanmɩan tunminfʋɛ'n yɩ́ fama sʋ. Ɛsɛ ɛmɔ 'ba nwun yɩ́ kɛ ɔ fi nyanmɩansʋ bɔlɛ́ nɩn anun ɔ lɛ ba.” ");
INSERT INTO any_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Mɔ Nyanmɩan tɛɛyɩfʋɛ kpain'n tɩlɩ yɩ́ sʋa'n, ɔ kɔ sosua yɩ́ muonun yɩ́ taladɩɛ'n m'ɔ wula nɩn anun. Yɩ́ nwan: “Yɛ mgbʋnndɛ man adanzɩɛ fɩ́ɩ́ kʋ́n. ");
INSERT INTO any_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Ɛmɔ a tɩ kɛ ɔ'a jʋjɔ ɔ'a tia Nyanmɩan, yɩ́ ti, ɛmɔ nwan nzɛ?” Bɛ́ kʋalaa bɛ́ nwan ɔ'a yɔ ɛtɛ, ɔ sɛ kɛ bɛ kun yɩ́. ");
INSERT INTO any_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Mmie-mɔ kɔ tʋtʋ yɩ́ nyunnun ngɛsɛlɛ. Bɛ kɔ fɩa yɩ́ nyɩn bɛ kɔ tʋtʋ yɩ́ kɔtɔlɛ. Bɛ́ nwan: “Kele yɛ́ sʋanlan'n mɔ ɔ'a tʋtʋ wɔ́ kɔtɔlɛ'n!” Tɛɛyɩfʋɛ kpain'n nzalafʋ'n-mɔ kɔ kpacɩ kpacɩ yɩ́ nyɩn nɩn asʋ. ");
INSERT INTO any_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Anɩn Pɩɛlɩ tɛ wɔ awulo nɩn abʋ ɛlɔ yɛ̂ Nyanmɩan tɛɛyɩfʋɛ kpain nɩn afanɩan'n-mɔ anun kʋn walɩ ɔ. ");
INSERT INTO any_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","M'ɔ nwunlin kɛ Pɩɛlɩ tɩ sɩ̂n nɩn anwʋn ɛbɛlɛ'n, ɔ kɔ nwun yɩ́ nzɔlɛ. Yɩ́ nwan: “Wɔ́ kʋsʋ wɔ́, Zozi m'ɔ fi Nazalɛtɩ'n, ɛ si yɩ́ sʋ bie.” ");
INSERT INTO any_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","M'ɔ hanlɩn sɔ'n, Pɩɛlɩ kɔ su yɩ́ akpʋlʋwa. Yɩ́ nwan: “Sʋanlan'n mɔ ɛ lɛ kan yɩ́ ɛjɔlɛ'n, mɩn nzɩ man yɩ́.” Ɛhɩ a, ɔ fi ɛbɛlɛ ɔ kɔ jasʋ, ɔ kɔ hɔ kɔ jinlan awulo nɩn anʋan nɩn anun ɛlɔ yɛ̂ akɔ'n bɔlɩ ɔ. ");
INSERT INTO any_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Mɔ afanɩan'n nwunlin yɩ́'n, ɔ kɔ han yɩ́ biekun kɔ hele bɛ́ mɔ bɛ gua ɛbɛlɛ'n kɛ: “Bian ɛhɩ, ɔ wɔ bɛ́ nun bie!” ");
INSERT INTO any_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Mɔ afanɩan'n hanlɩn sɔ'n, Pɩɛlɩ kɔ su yɩ́ akpʋlʋwa biekun. Kaan cɛ, bɛ́ mɔ bɛ wɔ ɛbɛlɛ'n kɔ han kɔ hele Pɩɛlɩ biekun kɛ: “Ɔ tɩ ananhɔlɛ, ɛ wɔ bɛ́ nun bie. Ɔ sanlɩn kɛ ɛ tɩ Galile mân nɩn anun sʋanlan.” ");
INSERT INTO any_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Ɛhɩ a, Pɩɛlɩ nwan: “Sɛ ato yɛ̂ mɩɩn di a, Nyanmɩan Kpili túa mɩ́n yɩ́ nwʋn kalɛ. Mɩn kan ndâ kɛ sʋanlan'n mɔ ɛmɔ lɛ kan yɩ́ ɛjɔlɛ'n, mɩ́n dɩɛ mɩn nzɩ man yɩ́.” ");
INSERT INTO any_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Kɛ ɔ 'kan sɔ nɩn ala, kokolokoo! Akɔ'n kɔ bɔ biekun. Pɩɛlɩ ati kɔ kacɩ ɛjɔlɛ'n mɔ Zozi hanlɩn helelɩ yɩ́'n. Zozi hanlɩn helelɩ yɩ́ kɛ: “Pɩɛlɩ, ɔ nʋn dede mɔ akɔ'n 'bɔ kpɛ̂ nnyuan'n, ɛ 'kan yɩ́ fâ nsan kɛ ɛ nzɩ man mɩ́n.” M'ɔ yɔlɩ sɔ'n, Pɩɛlɩ sunlin kpa. ");
INSERT INTO any_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Mɔ alɩ́ɛ hɩnlɩn'n, yɩ́ ngɛlɛmɔ, Nyanmɩan tɛɛyɩfʋɛ mgbain'n-mɔ, nʋn Zufʋ mgbain'n-mɔ nʋn bɛ́ mɔ bɛ di ɛjɔlɛ'n kʋalaa nʋn mala nɩn asʋ mgbain'n-mɔ, bɛ kɔ yia bɛ kɔ fa ajʋnlɩn kʋn. Mɔ bɛ cɩcɩlɩ Zozi yuelɩ'n, bɛ kɔ fa yɩ́ bɛ kɔ hɔ kɔ wula Pilatɩ asa nun. ");
INSERT INTO any_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilatɩ kɔ bisa yɩ́ kɛ: “Zufʋ'n-mɔ belemgbin'n y'ɔ le wɔ́ ɔ?” Zozi nwan: “Yɛ̂ wɔ́ nʋan wɔ sʋ ɛ lɛ kan nɩn ɔ.” ");
INSERT INTO any_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Nyanmɩan tɛɛyɩfʋɛ mgbain'n-mɔ kɔ li ato dɔʋn kɔ gua Zozi anwʋn. ");
INSERT INTO any_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Pilatɩ kɔ bisa yɩ́ biekun kɛ: “Ɛjɔlɛ nwala ɛhɩ mɔ bɛ lɛ kan bɛ gua wɔ́ sʋ'n, ɛ mmua man bie ɔ?” ");
INSERT INTO any_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Zozi ngɔ han man ɛjɔlɛ fɩ́ɩ́ kʋ́n. Yɩ́ nyɔlɩɛ sɔ'n sinlin Pilatɩ anwʋn. ");
INSERT INTO any_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Bɛ 'di *Pakɩ fɛtɩ biala a, sʋanlan mɔ bɛ kɔ tʋ yɩ́ fiadɩ mɔ menian'n-mɔ kulo kɛ bɛ yɩ yɩ́'n, Pilatɩ yɩ sʋanlan sɔ'n. ");
INSERT INTO any_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Nan mɔ bɛ hyɩlɩ Zozi'n, anɩn bian kʋn la fiadɩ. Bian sɔ'n, bɛ fɛlɛ yɩ́ Balabasɩ. Ɔ nʋn yɩ́ manngʋn mmie-mɔ bɛ jasʋlɩ bɛ mân mgbain'n-mɔ akɔmɩn anun dede bɛ hunlin nun sʋanlan kʋn. Bɛ kɔ hyɩ yɩ́ bɛ kɔ tʋ fiadɩ. ");
INSERT INTO any_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Meninsʋnman'n kɔ hɔ kɔ tʋ Pilatɩ. Bɛ kɔ sɛlɛ yɩ́ kɛ ɔ yɔ́ like'n m'ɔ yɔ man bɛ́ daa'n. ");
INSERT INTO any_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Pilatɩ kɔ bisa bɛ́ kɛ: “Ɛmɔ kulo kɛ n yáci Zufʋ'n-mɔ belemgbin nɩn ɔ?” ");
INSERT INTO any_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Pilatɩ kɔ bisa bɛ́ kosuan sɔ'n, afɩ ɔ sɩ fɔ́ʋ́n kɛ ɛkpɔ mgban yɛ̂ Nyanmɩan tɛɛyɩfʋɛ mgbain'n-mɔ kpɔ Zozi ɔ. Yɩ́ ti yɛ̂ bɛ hyɩlɩ yɩ́ ɔ. ");
INSERT INTO any_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Nyanmɩan tɛɛyɩfʋɛ mgbain'n-mɔ kɔ wowula meninsʋnman nɩn abʋ kɛ bɛ hán bɛ héle Pilatɩ maan ɔ yɩ́ Balabasɩ. ");
INSERT INTO any_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pilatɩ kɔ bisa bɛ́ biekun kɛ: “Sʋanlan'n mɔ ɛmɔ fɛlɛ yɩ́ Zufʋ'n-mɔ belemgbin'n, ɛmɔ kulo kɛ n yɔ́ yɩ́ sɛ?” ");
INSERT INTO any_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Bɛ kɔ tɩan kɔ bua Pilatɩ kɛ: “Man bɛ bʋ́bɔ yɩ́ kʋlʋwa sʋ.” ");
INSERT INTO any_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pilatɩ kɔ bisa bɛ́ biekun kɛ: “Nzukɛ ɛtɛ dɩɛ kpa bɔbɔ yɛ̂ ɔ'a yɔ ɔ?” Bɛ kɔ tɩan sɛlɛ kpa biekun kɔ bua Pilatɩ kɛ: “Man bɛ bʋ́bɔ yɩ́ kʋlʋwa sʋ.” ");
INSERT INTO any_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Kɛmɔ Pilatɩ kulo kɛ meninsʋnman nɩn akunnun jɔ'n, ɔ kɔ yɩ Balabasɩ fi fiadɩ sua nɩn anun. Ɔ kɔ man yɩ́ nzalafʋ'n-mɔ kɔ fin Zozi mgbele. Ɛsɛ ɔ kɔ fa yɩ́ kɔ wula bɛ́ sa nun kɛ bɛ bʋ́bɔ yɩ́ kʋlʋwa sʋ. ");
INSERT INTO any_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Nzalafʋ'n-mɔ nʋn Zozi kɔ hɔ kʋnmanna awulo nɩn akunnun ɛlɔ. Bɛ kɔ yia nzalafʋ'n-mɔ kʋalaatin. ");
INSERT INTO any_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Bɛ kɔ fa taladɩɛ kɔkɔlɛ bɛ kɔ wula yɩ́, ɛsɛ bɛ kɔ nwʋn mmowe abotile bɛ kɔ bɔ yɩ́ ti. ");
INSERT INTO any_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Mɔ bɛ yɔlɩ sɔ yuelɩ'n, bɛ kɔ yɔ yɩ́ like. Bɛ́ nwan: “Zufʋ'n-mɔ belemgbin, ahɩn o!” ");
INSERT INTO any_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Bɛ 'fa baka bɛ fin yɩ́ ti nɩn anun, anɩn bɛ 'tʋtʋ yɩ́ nwʋn ngɛsɛlɛ. Bɛ 'kʋtʋ anɩn bɛ 'bɛbɛlɛ bɛ́ nwʋn asɩ yɩ́ nyunnun ɛbɛlɛ. ");
INSERT INTO any_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Mɔ bɛ yɛyalalɩ yɩ́ nwʋn yuelɩ'n, bɛ kɔ yɩ taladɩɛ kɔkɔlɛ'n mɔ bɛ falɩ bɛ wulalɩ yɩ́'n. Bɛ kɔ fa yɩ́ muonun yɩ́ dɩɛ'n bɛ kɔ wula yɩ́. Bɛ nʋn yɩ́ kɔ hɔ kulo'n tiba, bɛ 'kɔ a bʋbɔ yɩ́ kʋlʋwa sʋ. ");
INSERT INTO any_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Anɩn bian kʋn fi yɩ́ ebolo ɔ lɛ ba. Bian sɔ'n bɛ fɛlɛ yɩ́ Simʋn. Ɔ fi kulo'n mɔ bɛ fɛlɛ yɩ́ Silɛnɩn nɩn asʋ. Yɩ́ mma-mɔ y'ɔ le Alɛgɩzanndɩlɩ nʋn Lufusi. Nzalafʋ'n-mɔ kɔ hyɩ yɩ́ bɛ kɔ fa Zozi kʋlʋwa'n bɛ kɔ sʋa yɩ́. ");
INSERT INTO any_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Bɛ nʋn Zozi kɔ hɔ lɩka kʋn. Bɛ fɛlɛ lɩka sɔ'n Gɔlʋgota. Gɔlʋgota'n, yɩ́ bʋ y'ɔ le kɛ “tile kangɔ lɩka”. ");
INSERT INTO any_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Nzalafʋ'n-mɔ kɔ fa divɩn bɛ kɔ man Zozi kɛ ɔ nʋ́n. Divɩn sɔ'n, bɛ gualɩ nun ayile'n mɔ bɛ fɛlɛ yɩ́ míin'n. (Míin sɔ'n, bɛ nʋn an, bɛ nnwun man yalɛ'n sʋnman.) Zozi ngɔ nʋn man. ");
INSERT INTO any_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Bɛ kɔ bʋbɔ yɩ́ kʋlʋwa sʋ. Ɛsɛ bɛ kɔ hyʋɩn tondo bɛ kɔ hye yɩ́ taladɩɛ'n-mɔ bɛ kɔ fa. ");
INSERT INTO any_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Ngɛlɛmɔ dɔɛ ngʋanlan yɛ̂ bɛ bʋbɔlɩ Zozi kʋlʋwa nɩn asʋ ɔ. ");
INSERT INTO any_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Like'n mɔ yɩ́ ti yɛ̂ bɛ lɛ kun yɩ́'n, b'a hɛlɛ b'a bɔ yɩ́ ti sʋ ɛbɛlɛ kɛ: “Zufʋ'n-mɔ belemgbin”. ");
INSERT INTO any_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Bɛ kɔ bʋbɔ kodiawu nnyuan kʋsʋ kʋlʋwa sʋ Zozi anwʋn ɛbɛlɛ. Kʋn wɔ yɩ́ sa fama sʋ, kʋn kʋsʋ wɔ yɩ́ sa bɛ̂ sʋ.  ");
INSERT INTO any_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Kɛ ɔ yɔlɩ mɔ Ɛhɛlɛ Ɛjɔlɛ'n kpɩnlɩn sʋ nɩn anɩn. Afɩ, bɛ hɛlɛlɩ yɩ́ kɛ: B'a ha yɩ́ b'a wula ɛtɛfʋɛ'n-mɔ anun. ");
INSERT INTO any_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Bɛ́ mɔ bɛ 'sɩn ɛbɛlɛ'n, bɛ kɔsɔ kɔsɔ bɛ́ ti'n, anɩn bɛ lɛ kpɛ yɩ́ nzʋba. Bɛ́ nwan: “E! Wɔ́ mɔ wɔ́ nwan ɛ 'bu Nyanmɩan awulo'n nán ɛ fa cɩan nsan ɛ si'n, ");
INSERT INTO any_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","de wɔ́ nwʋn fi kʋlʋwa nɩn asʋ ju e!” ");
INSERT INTO any_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Nyanmɩan tɛɛyɩfʋɛ mgbain'n-mɔ, nʋn mala nɩn asʋ mgbain'n-mɔ kʋsʋ kɔ gʋlʋ yɩ́ nwʋn. Bɛ́ nwan: “Ɔ'a le menian ɛhɩnlɩn-mɔ ngʋan, kʋsʋ ɔ ngʋala man yɩ́ nwʋn de. ");
INSERT INTO any_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Yɩ́ mɔ yɩ́ nwan ɔ tɩ Kilisi'n, Izalayɛ belemgbin'n, ɔ fi kʋlʋwa nɩn asʋ ɔ jú asɩ maan yɛ nwún yɩ́ e! Sɛ yɛ nwun yɩ́ a, yɛ 'de yɩ́ yɛ di.” Kodiawu nnyuan'n mɔ bɛ bʋbɔlɩ bɛ́ kʋlʋwa sʋ Zozi anwʋn ɛbɛlɛ'n kʋsʋ kɔ kpɛ yɩ́ nzʋba. ");
INSERT INTO any_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Mɔ sɛnzɛ'n jinlanlɩn bɛ́ ti afian'n, awosin kɔ wula mân'n lɩka kʋalaatin dede nɔsʋba dɔɛ nsan. ");
INSERT INTO any_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Nan mɔ dɔɛ nsan juli'n, Zozi kɔ tɩan nun sɛlɛ kpa, yɩ́ nwan: “Eloyi, Eloyi, lama sabakɩtanin?” Yɩ́ bʋ y'ɔ le kɛ: “Mɩ́n Nyanmɩan, mɩ́n Nyanmɩan, nzukɛ ati yɛ̂ a yaci mɩ́n a tʋ ɔ?” ");
INSERT INTO any_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Bɛ́ mɔ bɛ wɔ ɛbɛlɛ'n mmie-mɔ mɔ bɛ tɩlɩ yɩ́ ngan'n, bɛ́ nwan: “Ɛmɔ tíe, ɔ lɛ fɛlɛ Eli!” ");
INSERT INTO any_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Bɛ́ nunhan kʋn kɔ nwanndi ɔ kɔ hɔ kɔ fa eminlan. Ɔ kɔ bɔ yɩ́ divɩn bisii nun ɔ kɔ sinnze yɩ́ baka kʋn ati. Ɔ kɔ tɩnngɛ yɩ́ Zozi anyunnun kɛ ɔ nʋ́n. Yɩ́ nwan: “Ɛmɔ jínlan! Yɛ 'ba nɩan sɛ Eli kɔ a kɔ jula yɩ́ a!” ");
INSERT INTO any_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","M'ɔ yɔlɩ sɔ'n, Zozi kɔ tɩan nun sɛlɛ kpa, ɔ kɔ ha nun. ");
INSERT INTO any_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Mgbɛ nun ɛtanlan'n m'ɔ ja Nyanmɩan sua nɩn anun'n, ɔ kɔ bɔ yɩ́ anwunno ɔ kɔ sua sɛsɛ nnyuan dede ɔ kɔ ju yɩ́ bʋ asɩ. ");
INSERT INTO any_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Anɩn *Lɔmʋn nzalafʋ kpain nɩn anyɩn tua Zozi. M'ɔ nwunlin kɛ Zozi tɩanlɩn ɔ halɩ nun'n, yɩ́ nwan: “Ɔ tɩ ananhɔlɛ, bian ɛhɩ tɩ Nyanmɩan Awa sakpa!” ");
INSERT INTO any_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Anɩn mmalasua mmie-mɔ kʋsʋ jijin mʋa yɛ̂ bɛ lɛ nɩan Zozi ɔ. Mmalasua sɔ'n-mɔ, Mali m'ɔ fi Magɩdala'n, Zʋakɩ m'ɔ tɩ Kutua'n nʋn Zozʋ anin Mali, ɔ nʋn Salome, bɛ wɔ bɛ́ nun bie. ");
INSERT INTO any_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Mɔ anɩn Zozi wɔ Galile'n, bɛ sili yɩ́ sʋ, bɛ sʋlɩ yɩ́. Mmalasua'n-mɔ mɔ anɩn bɛ jijin ɛbɛlɛ'n, mmie-mɔ dɔʋn kʋsʋ sili Zozi sʋ bɛ walɩ Zoluzalɛmʋn. ");
INSERT INTO any_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Cɩan sɔ'n tɩ cɩan mɔ Zufʋ'n-mɔ fa bɔbʋa bɛ́ nwʋn bɛ sie ɔ. Afɩ alɩ́ɛ'n m'ɔ tɔtʋa yɩ́'n tɩ ɛnwʋnmɩan ele cɩan. Mɔ alɩ́ɛ'n 'kɔ yɩ́ nɔsʋba nun'n, ");
INSERT INTO any_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Zozɛfʋ m'ɔ fi kulo mɔ bɛ fɛlɛ yɩ́ Alimate nɩn asʋ'n kɔ a. Bɛ́ mɔ bɛ di Izalayɛ mân nɩn anun ɛjɔlɛ'n, bɛ́ bie y'ɔ le yɩ́. Menian'n-mɔ fɛlɩ yɩ́ kpa. Yɩ́ kʋsʋ ɔ lɛ nwʋnndɛ Nyanmɩan Belemgbin Mân'n. Ɔ kɔ nyan anwʋnsɛlɛ ɔ kɔ hɔ Pilatɩ anwʋn ɛlɔ. Ɔ kɔ sɛlɛ yɩ́ kɛ ɔ fá Zozi fuin'n mán yɩ́. ");
INSERT INTO any_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Ɛjɔlɛ'n kɔ sin Pilatɩ anwʋn. Afɩ ɔ njʋnlɩn man kɛ Zozi kɔ wu ndɛ-ndɛ sʋa ɔ. Ɛhɩka ati, ɔ kɔ yɩ́ sʋanlan kɔ hɔ kɔ fɛlɛ nzalafʋ'n-mɔ kpain'n ɔ kɔ bisa yɩ́ sɛ Zozi wuli ndɛ sakpa a. ");
INSERT INTO any_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Mɔ nzalafʋ kpain'n walɩ hanlɩn helelɩ yɩ́ kɛ ɔ tɩ sɔ sakpa'n, ɔ kɔ man Zozɛfʋ atɩn kɛ ɔ fá yɩ́ fuin'n. ");
INSERT INTO any_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Zozɛfʋ kɔ to kisaan. Ɔ kɔ yɩ Zozi fuin'n fi kʋlʋwa nɩn asʋ. Ɔ kɔ fa kisaan'n kɔ fʋfɔ yɩ́ nwʋn. Ɔ kɔ hɔ kɔ sie yɩ́ sɛka kʋn anun. Sɛka sɔ'n, bʋka m'ɔ tɩ ɛbʋta'n, nun yɛ̂ bɛ kotolɩ yɩ́ ɔ. Ɔ kɔ kunndo ɛbʋɛ kʋn kɔ nyin yɩ́ anʋan'n. ");
INSERT INTO any_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Mali m'ɔ fi Magɩdala'n, ɔ nʋn Zozʋ anin Mali, bɛ nwunlin lɩka mɔ bɛ sielɩ Zozi'n. ");
INSERT INTO any_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Mɔ ɛnwʋnmɩan ele cɩan'n sɩnlɩn'n, Mali m'ɔ fi Magɩdala'n, ɔ nʋn Zʋakɩ anin Mali, nʋn Salome, bɛ kɔ to alufanlan kɛ bɛ 'kɔ a fa bɛ kɔ kpʋkpa Zozi fuin'n. ");
INSERT INTO any_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Mɔlɛ'n ngɛlɛmɔ, mɔ sɛnzɛ'n 'fite'n, bɛ kɔ hɔ sɛka nɩn asʋ. ");
INSERT INTO any_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Bɛ kɔ han yɩ́ bɛ́ afian ɛlɔ kɛ: “Nwan yɛ̂ yɛ nyan yɩ́ maan ɔ kunndo ɛbʋɛ'n m'ɔ nyin sɛka nɩn anʋan'n man yɛ́ ɔ?” ");
INSERT INTO any_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Nan mɔ bɛ hanlɩn sɔ'n, bɛ 'tʋ bɛ́ nyɩn an, bɛ kɔ nwun kɛ ɛbʋɛ kpili'n m'ɔ nyin sɛka nɩn anʋan'n kisa ahanmɩan dada angʋnmɩn. ");
INSERT INTO any_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Ɛhɩ a, bɛ kɔ wʋlʋ sɛka nɩn anun. Bɛ 'nɩan an, anɩn kpafɛlɛ kʋn wula taladɩɛ fufue ɔ tɩ fama sʋ ɛbɛlɛ. Esulo kɔ han bɛ́. ");
INSERT INTO any_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Nan kpafɛlɛ'n nwan: “Nán bɛ sulo. Ɛmɔ lɛ kpʋnndɛ Zozi m'ɔ fi Nazalɛtɩ'n, mɔ bɛ bʋbɔlɩ yɩ́ kʋlʋwa sʋ'n? Ɔ'a hɩn. Ɔ nnʋn man ɛwa. Ɛmɔ nɩ́an lɩka mɔ bɛ tʋlɩ yɩ́'n. ");
INSERT INTO any_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Nan ɛmɔ hɔ́ bɔ́ yɩ́ menian'n-mɔ nʋn Pɩɛlɩ amannɩɛ kɛ ɔ lɛ di mʋa bɛ́ nyunnun Galile mân nɩn anun ɛlɔ. Kɛ ɔ hanlɩn helelɩ bɛ́'n, ɛlɔ yɛ̂ bɛ 'ba nwun yɩ́ ɔ.” ");
INSERT INTO any_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Mɔ kpafɛlɛ sɔ'n hanlɩn sɔ helelɩ bɛ́ yuelɩ'n, bɛ fi sɛka nɩn anun bɛ kɔ fite. Bɛ kɔ gua bɛ́ ja asɩ. Afɩ esulo hanlɩn bɛ́, bɛ́ nwʋn wʋsʋlɩ bɛ́ kpa. Kɛmɔ esulo hanlɩn bɛ́ nɩn ati, bɛ ngɔ han ɛjɔlɛ bɛ ngɔ hele sʋanlan fɩ́ɩ́.  ");
INSERT INTO any_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Mɔlɛ'n ngɛlɛmɔ tutun mɔ Zozi fi ewue nun tinngelɩ'n, ɔ lili mʋa ɔ yɩlɩ yɩ́ nwʋn ɔ helelɩ Mali m'ɔ fi Magɩdala'n. Mali sɔ'n, Zozi tuli yɩ́ nun wawɛ ɛtɛ nsʋ. ");
INSERT INTO any_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Ɔ kɔ hɔ kɔ bɔ amannɩɛ kɔ hele bɛ́ mɔ bɛ nʋn Zozi sanlɩn nun'n. Anɩn bɛ́ lʋa tɛ bɔ bɛ́ nwʋn bɛ tɛ sun yɩ́. ");
INSERT INTO any_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Mɔ bɛ tɩlɩ amannɩɛ'n mɔ Mali bɔlɩ helelɩ bɛ́ kɛ Zozi a tinnge nán ɔ'a nwun yɩ́'n, b'a nne b'a nni man. ");
INSERT INTO any_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Ɛhɩ anzin, Zozi kɔ yɩ yɩ́ nwʋn ngacile biekun ɔ kɔ hele yɩ́ menian'n-mɔ anun nnyuan. Menian nnyuan sɔ'n-mɔ, anɩn bɛ lɛ kɔ nanmue nun. ");
INSERT INTO any_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Bɛ kɔ sa bɛ́ nzin bɛ kɔ a kɔ bɔ ɛhɩnlɩn-mɔ amannɩɛ. Bɛ hanlɩn helelɩ bɛ́ a, bɛ ngɔ le bɛ ngɔ li man biekun. ");
INSERT INTO any_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Ɛhɩ anzin, anɩn Zozi menian bulu nʋn kʋn'n gua tɔbɩlɩ nwʋn bɛ lɛ didi. Zozi kɔ yɩ yɩ́ nwʋn ɔ kɔ hele bɛ́. Ɔ kɔ tu bɛ́ nyunnun wɔ dedi'n mɔ bɛ le man yɩ́ nʋn bɛ́ ahʋnlɩn ketee nɩn anwʋn. Ɔ sanlɩn kɛ, ɔ fi ewue nun tinngelɩ'n, amannɩɛ'n mɔ bɛ́ mɔ bɛ nwunlin yɩ́'n bɔlɩ'n, ɛhɩnlɩn-mɔ a nne b'a nni man. ");
INSERT INTO any_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Ɛhɩ, Zozi kɔ han kɔ hele bɛ́ kɛ: “Ɛmɔ hɔ́ mân'n lɩka kʋalaatin, bɛ hɔ́ bɔ́ Nyanmɩan Ɛjɔlɛkpa'n bɛ héle eyuadɩ'n. ");
INSERT INTO any_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Sʋanlan m'ɔ kɔ le kɔ li, m'ɔ kɔ man ɛmɔ kɔ sɔnɩn yɩ́'n, ɔ 'nyan yɩ́ ti. Nan sʋanlan mɔ ɔ'a nne ɔ'a nni man'n, yɩ́ ti 'ka nun. ");
INSERT INTO any_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Bɛ́ mɔ bɛ kɔ le bɛ kɔ li'n, ɛ 'nwun nyɔlɩɛ mɔ bɛ 'ba yɔ'n: Bɛ 'fʋan wawɛ ɛtɛ'n-mɔ wɔ mɩ́n dunman nun. Bɛ 'kan anɩɛ nvʋfɔlɛ-mɔ. ");
INSERT INTO any_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Sɛ bɛ sɔ owo nun o, sɛ bɛ di ayile m'ɔ kun sʋanlan bɔbɔ a, like fɩ́ɩ́ ngɔ yɔ man bɛ́. Sɛ bɛ fa bɛ́ sa bɛ fua nwuluwafʋɛ'n-mɔ anwʋn an, nwuluwafʋɛ'n-mɔ 'tɩ akpɔlɛ.” ");
INSERT INTO any_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Mɔ yɛ́ Mɩn Zozi hanlɩn ɛjɔlɛ sɔ'n-mɔ yuelɩ'n, ɔ kɔ fʋ kɔ hɔ anwunno. Ɔ kɔ hɔ kɔ tanlan Nyanmɩan Kpili fama sʋ. ");
INSERT INTO any_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Zozi menian'n-mɔ kɔ hɔ kɔ bɔ Ɛjɔlɛkpa'n lɩka kʋalaatin. Yɛ́ Mɩn kɔ jinlan bɛ́ nzin wɔ bɛ́ junman nɩn anun. Ɔ man bɛ yɔlɩ asinbɛnwʋn ninnge. Asinbɛnwʋn ninnge sɔ'n-mɔ kele kɛ bɛ́ nʋan ɛjɔlɛ'n tɩ ananhɔlɛ sakpa.");
INSERT INTO any_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Kpain Teofili, Ninnge mgbili mgbili'n mɔ Nyanmɩan a yɔ wɔ yɛ́ afian ɛwa'n, menian dɔʋn a bɔ yɩ́ bʋ bɛ lɛ kɛlɛ ɛjɔlɛ sɔ'n-mɔ. ");
INSERT INTO any_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Bɛ́ mɔ bɛ nwunlin ninnge sɔ'n-mɔ abʋbɔ nun, mɔ bɛ yɩlɩ bɛ́ kɛ bɛ hán Nyanmɩan Anʋan Ɛjɔlɛ'n, ɛjɔlɛ mɔ bɛ hanlɩn bɛ helelɩ yɛ́'n, yɩ́ fɔ́ʋ́n yɛ̂ menian'n-mɔ hɛlɛlɩ nɩn ɔ. ");
INSERT INTO any_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Yɩ́ ti, mɩ́n kʋsʋ, m'an bisa bisa nun m'an nwun yɩ́ fɔ́ʋ́n kɛ ɛjɔlɛ'n kpɩnlɩn bɔlɩ yɩ́ bʋ ngɛlɛmɔ nun'n. M'an nɩan an, anɩn Kpain, ɔ tɩ kpa kɛ mɩn kɛlɛ wɔ́ mɩn sʋsɔ sʋ mɩn kan ɛjɔlɛ sɔ'n mɩn kele wɔ́. ");
INSERT INTO any_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Mɩɩn kɛlɛ kalata ɛhɩ mɩn nwan wɔ́ maan ɛ nwun yɩ́ kɛ ɛjɔlɛ'n mɔ a tɩ'n tɩ ananhɔlɛ sakpa. ");
INSERT INTO any_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Ɛhɩ, belemgbin Elɔdɩ m'ɔ sie Zude mân'n bɛlɛ sʋ, anɩn bian kʋn wɔ ɛbɛlɛ. Bian sɔ'n, bɛ fɛlɛ yɩ́ Zakali. Ɔ tɩ Nyanmɩan tɛɛyɩfʋɛ wɔ tɛɛyɩfʋɛ Abia fâ nɩn anun. Bɛ fɛlɛ yɩ́ yɩ nɩn Elizabɛtɩ, ɔ fi Nyanmɩan tɛɛyɩfʋɛ kpain Aalʋn afilie nɩn anun. ");
INSERT INTO any_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Bɛ́ menian nnyuan'n, bɛ tɩ fɔ́ʋ́n wɔ Nyanmɩan anyunnun. Bɛ́ nyɩn sɔ Nyanmɩan. Bɛ di yɩ́ mala nɩn asʋ. ");
INSERT INTO any_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Nan kʋsʋ bɛ wʋlɩ man baa fɩ́ɩ́, ɔ sanlɩn kɛ Elizabɛtɩ tɩ mʋta, ɛsɛ bɛ́ menian nnyuan'n b'a yɔ mgbain. ");
INSERT INTO any_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Cɩan kʋn, anɩn Zakali lɛ di yɩ́ tɛɛyɩɛ junman'n wɔ Nyanmɩan anyunnun, afɩ anɩn Nyanmɩan junman elie nɩn a tʋ bɛ́ fâ dɩɛ'n. ");
INSERT INTO any_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Kɛ bɛ́ mala'n kele'n, ɔ di kɛ bɛ cʋɩn tondo nán bɛ yɩ sʋanlan'n mɔ ɔ 'yala alufanlan'n wɔ Nyanmɩan sua nɩn anun lɩka mɔ bɛ yala yɩ́'n. Bɛ hyʋɩnlɩn tondo nɩn an, bɛ kɔ yɩ Zakali. Zakali kɔ hɔ kɔ wʋlʋ Nyanmɩan sua nɩn anun, ɔ kɔ bɔ yɩ́ junman nɩn abʋ. ");
INSERT INTO any_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Mɔ ɔ 'yala alufanlan'n, anɩn menian'n-mɔ kʋalaa gua awulo ɛfan bɛ lɛ yɔ asɔnɩn bɛ man bɛ́ nwʋn. ");
INSERT INTO any_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Ɛbɛlɛ ala, yɛ́ Mɩn bɔfʋɛ'n kʋn kɔ yɩ yɩ́ nwʋn kɔ hele Zakali. Bɔfʋɛ sɔ'n jin tɔbɩlɩ'n mɔ bɛ yala alufanlan'n sʋ'n fama sʋ ɛbɛlɛ. ");
INSERT INTO any_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Mɔ Zakali nwunlin yɩ́'n, yɩ́ kunnun kɔ tɩ yɩ́, ɛsɛ esulo kɔ han yɩ́. ");
INSERT INTO any_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Bɔfʋɛ'n nwan: “Zakali, n'ɛ sulo! Nan Nyanmɩan Kpili a tie wɔ́ nzɛlɛ'n. Wɔ́ yɩ Elizabɛtɩ 'ba wʋ baa belenzua kʋn man wɔ́. Baa sɔ'n, tʋn yɩ́ Zʋan. ");
INSERT INTO any_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Ɛ 'ba li yɩ́ nwʋn fɛ kpa, menian dɔʋn kʋsʋ 'ba li yɩ́ awɔlɛ nɩn anwʋn ndutue. ");
INSERT INTO any_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Ɔ sanlɩn kɛ ɔ 'ba yɔ sʋanlan kpili wɔ yɛ́ Mɩn anyunnun. Baa sɔ'n, ɔ mma nnʋn man divɩn anaan nzan sɛlɛ ngacile biala. Bɛ 'wʋ yɩ́ a, anɩn Nyanmɩan Wawɛ Nwannzan-nwannzan wɔ yɩ́ nun kpa. ");
INSERT INTO any_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Ɔ 'cʋɩn Izalayɛ amma'n-mɔ dɔʋn ba yɛ́ Mɩn m'ɔ tɩ bɛ́ Nyanmɩan nɩn anwʋn biekun. ");
INSERT INTO any_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Ɔ le kpɔmanfʋɛ *Eli ajʋnlɩn'n nʋn yɩ́ tunmin'n, yɩ́ muonun ɔ 'di kpɔman wɔ Nyanmɩan anyunnun ɔ sesie sɩɛ'n-mɔ nʋn bɛ́ mma'n-mɔ afian. Ɔ 'man bɛ́ mɔ bɛ́ nyɩn nzɔ man Nyanmɩan'n nwun ngɛlɛ kɛ sɛsɛfʋɛ'n-mɔ. Ɔ 'man menian'n-mɔ sesie bɛ́ nwʋn bɛ nwʋnndɛ yɛ́ Mɩ́n.” ");
INSERT INTO any_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Zakali kɔ bisa bɔfʋɛ'n kɛ: “Anɩn, mɩn 'yɔ sɛ nán m'an nwun yɩ́ ananhɔlɛ. Ɔ sanlɩn kɛ mɩ́n muonun, m'an yɔ awʋlʋwa. Mɩ́n yɩ kʋsʋ a yɔ awʋlʋwa.” ");
INSERT INTO any_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Bɔfʋɛ'n nwan: “Bɛ fɛlɛ mɩ́n Gabiliyɛ. Mɩ́n yɛ̂ mɩn jinlan Nyanmɩan anyunnun mɩn sʋ yɩ́ ɔ. Ɔ'a sʋan mɩ́n kɛ m mála n gán ɛjɔlɛ fɛ ɛhɩ n géle wɔ́. ");
INSERT INTO any_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Mɛlɛ'n ju a, mɩ́n nʋan ɛjɔlɛ'n 'kpɩn sʋ. Nan kʋsʋ, kɛmɔ a nne man ɛjɔlɛ sɔ nɩn a nni man'n, ɛ 'ba tɔ amunle, ɛ ngɔ hʋala man jʋjɔ dede ɔ 'ju tɛmʋn mɔ ɛjɔlɛ'n mɔ m'an han'n kɔ kpɩn sʋ'n.” ");
INSERT INTO any_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Ɔ 'ba yɔ sɔ'n, menian'n-mɔ gua awulo ɛwa b'a nwʋnndɛ dede ɔ'a sin bɛ́ nwʋn kɛ Zakali fi Nyanmɩan sua nɩn anun nvite man ɔ. ");
INSERT INTO any_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Nan mɛlɛ mɔ afɩ Zakali fi Nyanmɩan sua nɩn anun fitelɩ'n, ɔ a ngʋala man ɛjɔlɛ kan kele bɛ́. Menian'n-mɔ kɔ nwun kɛ like a fite yɩ́ Nyanmɩan sua nɩn anun ɛlɔ. Ɔ 'kan ɛjɔlɛ'n kele bɛ́ a, ɔ le yɩ́ sa, afɩ yɩ́ nʋan a muan. ");
INSERT INTO any_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Mɔ Zakali yuelɩ Nyanmɩan awulo nɩn anun junman'n di'n, ɔ kɔ sa kɔ hɔ yɩ́ kulo. ");
INSERT INTO any_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Mɔ Zakali salɩ hɔlɩ'n, ɔ'a njɛ man biala, yɩ́ yɩ Elizabɛtɩ kɔ nwʋnnzɛ. Elizabɛtɩ kɔ fa yɩ́ nwʋn kɔ fɩa dede sala nnun. Yɩ́ nwan: ");
INSERT INTO any_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Yɛ́ Mɩn a nwun mɩ́n nwʋn anwunnvoe. Ɔ'a le mɩ́n fi anyunnunguasɩɛ'n m'ɔ kan mɩ́n wɔ menian'n-mɔ anyunnun nɩn anun.” ");
INSERT INTO any_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Mɔ Elizabɛtɩ nwʋnnzɛlɩ m'ɔ lili sala nsian'n, yɩ́ sala nsian nɩn asʋ, Nyanmɩan kɔ sʋan yɩ́ bɔfʋɛ Gabiliyɛ talua muan kʋn anwʋn Galile mân nɩn anun kulo'n kʋn asʋ. Bɛ fɛlɛ kulo sɔ'n Nazalɛtɩ. ");
INSERT INTO any_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Talua muan sɔ'n, bɛ fɛlɛ yɩ́ Mali. Yɩ́ hun y'ɔ le Zozɛfʋ m'ɔ fi belemgbin Davidi afilie nɩn anun'n. Zozɛfʋ nʋn yɩ́ lalɩ man lé. Afɩ ɔ falɩ man Mali atɔnvɔlɛ. ");
INSERT INTO any_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Bɔfʋɛ'n kɔ wʋlʋ lɩka mɔ Mali wɔ'n, yɩ́ nwan: “Mali, ahɩn o! Yɛ́ Mɩn a yeyila wɔ́ sʋ, ɔ nʋn wɔ́ tɩ.” ");
INSERT INTO any_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Ɛjɔlɛ sɔ'n kɔ man Mali ati anun kɔ yɔ yɩ́ sɩsakaa. Ɔ lɛ bisa yɩ́ nwʋn kɛ ahɩn ebisa sɔ ɛhɩ abʋ y'ɔ le benin? ");
INSERT INTO any_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Ɛhɩ a, bɔfʋɛ'n nwan: “Mali, n'ɛ sulo! Nan Nyanmɩan a yeyila wɔ́ sʋ. ");
INSERT INTO any_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Ɛ 'ba nwʋnnzɛ ɛ wʋ baa belenzua kʋn. Tʋn baa sɔ'n Zozi. ");
INSERT INTO any_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Ɔ 'ba yɔ sʋanlan kpili kpa, bɛ 'ba fɛlɛ yɩ́ Nyanmɩan Kpili m'ɔ wɔ anwunno anwunno ɛlɔ nɩn Awa. Yɛ́ Mɩn Nyanmɩan 'ba man ɔ di belemgbin kɛ yɩ́ nan Davidi. ");
INSERT INTO any_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Ɔ 'sie Izalayɛ amma'n-mɔ mɛlɛ biala. Yɩ́ mɛlɛ'n le man ayuelɩɛ.” ");
INSERT INTO any_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Mali kɔ bisa bɔfʋɛ'n kɛ: “Anɩn, ɔ 'yɔ sɛ nán ɔ'a yɔ sɔ, mɔ mɩn nzɩ man bian'n?” ");
INSERT INTO any_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Bɔfʋɛ'n nwan: “Wawɛ Nwannzan-nwannzan'n 'ba wʋlʋ wɔ́ nun yɛ̂ Nyanmɩan Kpili m'ɔ wɔ anwunno anwunno ɛlɔ'n 'ba fa yɩ́ tunmin'n butu wɔ́ sʋ. Yɩ́ sɔ ati, baa nwannzan-nwannzan'n mɔ ɛ 'ba wʋ yɩ́'n, bɛ 'ba fɛlɛ yɩ́ Nyanmɩan Awa. ");
INSERT INTO any_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Nɩan, Elizabɛtɩ m'ɔ tɩ wɔ́ abie'n, yɩ́ m'ɔ tɩ mʋta m'ɔ ngʋala man baa wʋ'n, sunnzun mɔ ɔ'a yɔ kpain, ɔ'a nwʋnnzɛ, yɩ́ sala nsian ahɩ. ");
INSERT INTO any_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Ɔ sanlɩn kɛ Nyanmɩan kʋala like biala yɔ.” ");
INSERT INTO any_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Mali nwan: “N dɩ yɛ́ Mɩn afanɩan, mɔ a han'n, man ɔ yɔ́ sɔ mán mɩ́n.” Kɛ ɔ hanlɩn sɔ yuelɩ'n yɛ̂ bɔfʋɛ'n hɔlɩ ɔ. ");
INSERT INTO any_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Ɛhɩ anzin, ɛcɩan kʋn Mali kɔ jasʋ ɔ kɔ han yɩ́ nwʋn ɔ kɔ hɔ kɔ fua Zakali nʋn Elizabɛtɩ anwʋn bɛ́ kulo nɩn asʋ. Kulo sɔ'n wɔ Zude mân nɩn anun mmʋka'n-mɔ afian. ");
INSERT INTO any_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Mɔ Mali juli ɛbɛlɛ'n, ɔ kɔ wʋlʋ bɛ́ awulo nɩn anun ɔ kɔ bisa Elizabɛtɩ ahɩn. ");
INSERT INTO any_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Mɔ Elizabɛtɩ tɩlɩ Mali ahɩn ebisa'n, baa'n m'ɔ la yɩ́ kunnun'n kɔ han yɩ́ nwʋn. Ɛbɛlɛ ala, Wawɛ Nwannzan-nwannzan'n kɔ wʋlʋ Elizabɛtɩ anun. Nán ɔ'a tɩan sɛlɛ ɔ'a se kɛ: ");
INSERT INTO any_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","“Nyanmɩan a yeyila wɔ́ sʋ a tala mmalasua'n-mɔ kʋalaatin. Yɩ́ nyila'n kan baa'n mɔ ɛ lɛ 'ba wʋ yɩ́'n. ");
INSERT INTO any_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Mɩ́n muonun, n dɩ mɩ́n dɩɛ sɛ mɔ yɛ̂ mɩ́n Mɩn anin'n ba ɔ fua mɩ́n nwʋn ɔ? ");
INSERT INTO any_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Nɩan, mɛlɛ mɔ ɛ bisalɩ mɩ́n ahɩn nɩn ala, baa'n m'ɔ la mɩ́n kunnun'n kɔ li fɛ ɔ kɔ han yɩ́ nwʋn. ");
INSERT INTO any_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Nyila hán wɔ́ Mali. Afɩ a le a li kɛ yɛ́ Mɩn Anʋan Ɛjɔlɛ'n mɔ ɔ'a han ɔ'a hele wɔ́'n 'kpɩn sʋ sakpa!” ");
INSERT INTO any_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Mali nwan: “Mɩn 'yɩ yɛ́ Mɩn ayɛ. ");
INSERT INTO any_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Mɩn di Nyanmɩan m'ɔ tɩ mɩ́n Ngʋandefʋɛ nɩn anwʋn fɛ. ");
INSERT INTO any_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Ɔ sanlɩn kɛ mɩ́n kanga nun, ɔ'a tʋ yɩ́ nyɩn mɩ́n afan ɔ'a yeyila mɩ́n sʋ. Ɔ fi ɛnɛ m'ɔ kɔ'n, menian'n-mɔ kʋalaa 'ba han kɛ Nyanmɩan a yeyila mɩ́n sakpa. ");
INSERT INTO any_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Ɔ sanlɩn kɛ Tunminfʋɛ Nyanmɩan Kpili a yɔ ninnge mgbili mgbili a man mɩ́n. Yɩ́ dunman'n tɩ nwannzan-nwannzan. ");
INSERT INTO any_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Bɛ́ mɔ bɛ man yɩ́ anyɩnnzɔ'n, ɔ 'nwun bɛ́ nwʋn anwunnvoe mɛlɛ biala anun. ");
INSERT INTO any_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Ɔ'a yɩ yɩ́ tunmin asa'n ɔ'a hele atubɛnwʋn mma'n-mɔ ɔ'a gua bɛ́ ebolo. ");
INSERT INTO any_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Ɔ'a tu mmelemgbin'n-mɔ bɛ́ bia'n-mɔ asʋ, ɔ'a man ehiannin mma'n-mɔ lɩka kpa a tanlan. ");
INSERT INTO any_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Ɔ'a man yalɛfʋɛ'n-mɔ akʋ a yi, ɔ'a fʋan esikafʋɛ'n-mɔ maan bɛ le bɛ́ sa to b'a hɔ. ");
INSERT INTO any_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Ɔ'a bʋka Izalayɛ mân'n m'ɔ sʋ yɩ́'n. Yɩ́ lʋa a nvi man ye'n ");
INSERT INTO any_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","mɔ ɔ 'yɔ Abalahamʋn nʋn yɩ́ sasʋ'n-mɔ cɩan daa'n. Ɔ sanlɩn kɛ ɔ falɩ bɔlɩ yɛ́ nan-mɔ anɔhʋba.” ");
INSERT INTO any_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Mɔ Mali hanlɩn sɔ yuelɩ'n, ɔ lili kɔ yɔ sala nsan Elizabɛtɩ anwʋn ɛbɛlɛ kʋalaaka nán ɔ'a sa ɔ'a hɔ yɩ́ kulo. ");
INSERT INTO any_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Ɔ wɔ ɛbɛlɛ dede Elizabɛtɩ cɩan kɔ ju. Ɔ 'kɔ a wʋ a, ɔ kɔ wʋ baa belenzua kʋn. ");
INSERT INTO any_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Menian mɔ bɛ nʋn bɛ́ mantan mantan sʋ'n nʋn yɩ́ nwʋn amma'n-mɔ mɔ b'a nwun junman kpili'n mɔ yɛ́ Mɩn a li a man Elizabɛtɩ'n, bɛ nʋn yɩ́ kɔ li yɩ́ nwʋn fɛ. ");
INSERT INTO any_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Mɔ Baa'n lili mɔlɛ kʋn'n, bɛ kɔ a kɔ kpɛ yɩ́ mmian nun. Bɛ́ nwan bɛ 'fa yɩ́ sɩ Zakali dunman'n bɛ tʋn yɩ́. ");
INSERT INTO any_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Yɩ́ nin nwan: “Cɛcɛ, nán bɛ fɛlɛ yɩ́ Zakali, nan ɔ li Zʋan.” ");
INSERT INTO any_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Bɛ́ nwan: “Nwan yɛ̂ ɔ li Zʋan wɔ́ afilie nɩn anun mɔ yɩ́ ti yɛ̂ bɛ 'tʋn yɩ́ sɔ'n?” ");
INSERT INTO any_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Bɛ le bɛ́ sa bɛ kɔ bisa yɩ́ sɩ kɛ: “Nan wɔ́ wa'n, wɔ́ nwan ɔ li sɛ kpa?” ");
INSERT INTO any_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Ɛbɛlɛ ala, Zakali kɔ bisa tabʋa kaan kʋn ɔ kɔ hɛlɛ sʋ kɛ: “Mɩ́n wa'n li Zʋan.” Ɛjɔlɛ sɔ'n kɔ sin bɛ́ kʋalaa bɛ́ nwʋn. ");
INSERT INTO any_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Kɛ ɔ hɛlɛlɩ yuelɩ ala, Nyanmɩan kɔ tike yɩ́ nʋan'n. Zakali kɔ kuku yɩ́ nɩn sʋ ɔ kɔ yɩ Nyanmɩan ayɛ. ");
INSERT INTO any_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Ɛbɛlɛ ala, esulo kɔ han bɛ́ mɔ bɛ nʋn Zakali mantan mantan sʋ'n, ɛbɛlɛ mân sɔ nɩn anun menian'n-mɔ kʋalaa kɔ tɩ ɛjɔlɛ sɔ'n. ");
INSERT INTO any_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Bɛ́ nun kʋn biala m'ɔ kɔ tɩ ɛjɔlɛ sɔ'n, ɔ jʋnlɩn dede a, ɔ bisa yɩ́ nwʋn kɛ: “Baa sɔ'n, nzu sʋanlan dɩɛ yɛ̂ ɔ 'kaci ɔ?” Bɛ lɛ kan sɔ, ɔ sanlɩn kɛ bɛ́ kʋalaa bɛ nwun yɩ́ kɛ yɛ́ Mɩn tunmin'n wɔ baa nɩn anun sakpa. ");
INSERT INTO any_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Mɔ Wawɛ Nwannzan-nwannzan'n wʋlʋlɩ Zʋan asɩ Zakali anun'n, ɛ 'nwun ɛjɔlɛ m'ɔ hanlɩn'n: ");
INSERT INTO any_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Bɛ mán yɛ yɩ́ yɛ́ Mɩn m'ɔ tɩ Izalayɛ amma'n-mɔ Nyanmɩan nɩn ayɛ. Ɔ sanlɩn kɛ ɔ'a nɩan yɩ́ menian'n-mɔ ɔ'a le bɛ́ ti. ");
INSERT INTO any_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Ɔ'a man ngʋandefʋɛ kpili kʋn a fite belemgbin *Davidi m'ɔ tɩ yɩ́ akʋa nɩn afilie nɩn anun. ");
INSERT INTO any_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Ɛjɔlɛ sɔ'n, ɔ lili mʋa ɔ manlɩn yɩ́ anwʋntɩɛ mgbɔmanfʋɛ'n-mɔ hanlɩn yɩ́ daba. ");
INSERT INTO any_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Ɔ bɔlɩ yɛ́ anɔhʋba kɛ ɔ 'ba le yɛ́ fi yɛ́ mgbɔfʋɛ'n-mɔ asa nun, ");
INSERT INTO any_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","ɔ 'nwun yɛ́ nan-mɔ anwʋn anwunnvoe, ɛsɛ ɔ 'kacɩ yɩ́ nyɩhyɛ nwannzan-nwannzan'n m'ɔ nʋn yɛ́ hyɩhyɛlɩ'n. ");
INSERT INTO any_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Nyanmɩan hanlɩn ndâ yɛ́ nan Abalahamʋn anyunnun kɛ ");
INSERT INTO any_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","ɔ 'de yɛ́ fi yɛ́ mgbɔfʋɛ'n-mɔ asa nun, maan yɛ sʋ yɩ́ ahʋnmɩnkan nun, ");
INSERT INTO any_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","ɛsɛ yɛ 'nanndɩ nwannzan-nwannzan yɛ yɔ like m'ɔ tɩ sɛsɛ cɩan biala wɔ yɩ́ nyunnun. ");
INSERT INTO any_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Nan wɔ́ dɩɛ, mɩ́n wa, bɛ 'ba fɛlɛ wɔ́ Nyanmɩan Kpili m'ɔ wɔ anwunno anwunno ɛlɔ'n kpɔmanfʋɛ. Ɔ sanlɩn kɛ ɛ 'ba nanndɩ yɛ́ Mɩn anyunnun nán ɛ sesie yɩ́ atɩn'n, ");
INSERT INTO any_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","ɛsɛ ɛ 'man yɩ́ menian'n-mɔ nwun yɩ́ kɛ ɔ 'ba fa bɛ́ ɛtɛ'n-mɔ ce bɛ́ ɔ de bɛ́ ngʋan. ");
INSERT INTO any_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Yɛ́ Nyanmɩan'n sɩ anwunnvoe, ɛsɛ ɔ tɩ kpa sʋnman. Ɔ 'ba man anwunno kanlannɩɛ'n ta yɛ́ nwʋn. Kanlannɩɛ sɔ'n tɩ kɛ sɛnzɛ m'ɔ lɛ fite ɔ. ");
INSERT INTO any_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Ɔ 'man ɔ ta bɛ́ mɔ bɛ tɩ awosin nɩn anun ɔ nʋn ewue asa abʋ nɩn anwʋn. Ɔ 'man ɔ kele yɛ́ atɩn'n m'ɔ man bɛ nyan alʋacɩcɩɛ'n.” ");
INSERT INTO any_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Anɩn batʋnman'n lɛ nyin ɛsɛ anɩn yɩ́ ti lɛ tin. Ɔ kɔ tanlan ɛwâ nɩn anun ɛlɔ. Ɔ wɔ ɛlɔ dede tɛmʋn'n juli ɔ bɔlɩ yɩ́ bagua nun junman nɩn abʋ Izalayɛ amma'n-mɔ afian. ");
INSERT INTO any_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Mɛlɛ sɔ nɩn anun, belemgbin kpain'n mɔ bɛ fɛlɛ yɩ́ *Sezaa Ogusɩtɩ'n kɔ man atɩn kɛ bɛ há bɛ́ kʋalaa mɔ bɛ wɔ *Lɔmʋn ɛhɩnlɩn mân nɩn anun'n. ");
INSERT INTO any_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Mɔ alimʋa menian ɛha sɔ'n 'ju sʋ'n, anɩn Kiliniusɩ tɩ kʋnmanna wɔ Sili mân nɩn anun. ");
INSERT INTO any_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Ɔ sɛ kɛ anɩn sʋanlan kʋn biala kɔ yɩ́ kulo maan bɛ kɛlɛ yɩ́ dunman. ");
INSERT INTO any_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Zozɛfʋ kʋsʋ fi Nazalɛtɩ, Galile mân nɩn anun, ɔ kɔ hɔ Zude mân nɩn anun kulo'n mɔ bɛ fɛlɛ yɩ́ Betelehɛmʋn nɩn asʋ, lɩka mɔ bɛ wʋlɩ belemgbin Davidi'n. Ɔ sanlɩn kɛ Zozɛfʋ muonun tɩ Davidi afilie nɩn anun sʋanlan. ");
INSERT INTO any_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Ɔ nʋn yɩ́ yɩ Mali bɛ 'kɔ a man bɛ kɛlɛ bɛ́ dunman. ");
INSERT INTO any_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Mɛlɛ sɔ nɩn anun, anɩn Mali lɛ nwʋnnzɛ. ");
INSERT INTO any_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Nan mɔ bɛ juli Betelehɛmʋn'n, nán yɩ́ kʋ a han yɩ́, ɔ'a wʋ. Ɔ 'wʋ yɩ́ bamuan baa nɩn an, ɔ kɔ wʋ belenzua kʋn. Ɔ kɔ fa ɛtanlan kɔ fʋfɔ yɩ́ nwʋn, ɔ kɔ la yɩ́ abalanda nɩn anun lɩka kʋn. Ɔ sanlɩn kɛ sua sɔ'n tɩ dabɛlɛ kʋn nʋn abalanda. Dabɛlɛ nɩn anun an, b'a sike sʋanlan. Abalanda nɩn an, b'a hye nun nnyuan. Ɔ le menian'n-mɔ lɩka yɛ̂ naan'n-mɔ kʋsʋ dɩɛ. Lɩka'n mɔ naan'n-mɔ didi'n, ɛbɛlɛ yɛ̂ b'a sesie adɔman'n dabɛlɛ nɩn ɔ. ");
INSERT INTO any_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Kɔngɔɛ sɔ kʋnmgba'n, anɩn mmʋa ɛnɩanfʋɛ mmie-mɔ wɔ Betelehɛmʋn anwʋn ɛbɛlɛ ebo kʋn asʋ. Menian sɔ'n-mɔ da ɛlɔ, bɛ sisa bɛ́ mmʋa'n-mɔ. ");
INSERT INTO any_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Ɛbɛlɛ ala, nyanmɩansʋ bɔfʋɛ kʋn kɔ fite bɛ́, yɛ́ Mɩn anunminnyanmʋn'n kɔ ta kɔ si kɔ yia bɛ́. Esulo kpili kpa kɔ han bɛ́. ");
INSERT INTO any_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Bɔfʋɛ'n nwan: “Nán bɛ sulo! Ɔ sanlɩn kɛ, mɩn 'ba han ɛjɔlɛ kpa kʋn mɩn kele ɛmɔ. Ɛjɔlɛ kpa sɔ'n 'ba man mân'n kʋalaa di fɛ kpa. ");
INSERT INTO any_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Ɛnɛ kɔngɔɛ, b'a wʋ Ngʋandefʋɛ'n wɔ Davidi kulo nɩn asʋ b'a man ɛmɔ. Ngʋandefʋɛ sɔ'n, y'ɔ le *Kilisi'n m'ɔ tɩ yɛ́ Mɩn'n. ");
INSERT INTO any_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Nzɔlɛ'n mɔ ɛmɔ 'fa bɛ nwun yɩ́'n, y'ɔ le ɛhɩ: Baa sɔ'n, b'a fa ɛtanlan b'a fʋfɔ yɩ́ nwʋn b'a tʋ yɩ́ abalanda nɩn anun lɩka mɔ naan'n-mɔ didi'n.” ");
INSERT INTO any_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Kɛ ɔ 'kan sɔ nɩn ala, nyanmɩansʋ mmɔfʋɛ mmiekun-mɔ dɔʋn kpa kɔ a kɔ bʋka yɩ́ sʋ, bɛ́ kʋalaa, bɛ lɛ yɩ Nyanmɩan ayɛ. ");
INSERT INTO any_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","Bɛ́ nwan: “Anunminnyanmʋn hán Nyanmɩan m'ɔ wɔ anwunno anwunno ɛlɔ'n. Ɔ kulo asɩɛ nɩn asʋ ɛwa menian'n-mɔ. Ɔ'a man bɛ́ lʋa a cɩcɩ bɛ́ nwʋn.” ");
INSERT INTO any_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Mɔ nyanmɩansʋ mmɔfʋɛ'n-mɔ hanlɩn ɛjɔlɛ sɔ'n yuelɩ mɔ bɛ salɩ fʋlɩ nyanmɩansʋ'n, mmʋa ɛnɩanfʋɛ'n-mɔ kɔ han kɔ hele bɛ́ nwʋn kɛ: “Bɛ mán yɛ hɔ́ Betelehɛmʋn, nán yɛ hɔ́ nɩ́an like'n mɔ yɛ́ Mɩn a han yɩ́ nwʋn ɛjɔlɛ a hele yɛ́'n yɛ́ nyɩnsʋ.” ");
INSERT INTO any_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Ɛbɛlɛ ala, bɛ kɔ han bɛ kɔ gua sʋ, bɛ́ nʋan y'ɔ le Betelehɛmʋn. Sakpa kʋsʋ, bɛ kɔ hɔ kɔ tʋ Mali nʋn Zozɛfʋ nʋn baa adɔman'n. Adɔman'n la abalanda nɩn anun ɛbɛlɛ, lɩka mɔ naan'n-mɔ didi'n. ");
INSERT INTO any_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Mɔ mmʋa ɛnɩanfʋɛ'n-mɔ juli ɛlɔ, mɔ bɛ nwunlin baa'n yuelɩ'n, bɛ kɔ han ɛjɔlɛ'n mɔ bɔfʋɛ'n walɩ hanlɩn yɩ́ batʋnman nɩn anwʋn'n kʋalaa kɔ hele bɛ́. ");
INSERT INTO any_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Ɛjɔlɛ sɔ'n mɔ bɛ hanlɩn'n kɔ sin menian'n-mɔ mɔ bɛ wɔ ɛbɛlɛ'n kʋalaa anwʋn. ");
INSERT INTO any_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Yɩ́ kʋalaa mɔ bɛ hanlɩn'n, Mali falɩ sielɩ yɩ́ ti anun, tɛmʋn biala ɔ jʋnlɩn yɩ́ nwʋn. ");
INSERT INTO any_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Mɔ mmʋa ɛnɩanfʋɛ'n-mɔ hanlɩn ɛjɔlɛ sɔ'n yuelɩ'n, bɛ kɔ sa bɛ kɔ hɔ. Bɛ 'kɔ a, anɩn bɛ lɛ kannvʋ Nyanmɩan bɛ yɩ yɩ́ ayɛ wɔ ɛjɔlɛ'n mɔ b'a tɩ mɔ b'a nwun yɩ́ nɩn anwʋn. Ɔ sanlɩn kɛ yɩ́ kʋalaa yɔlɩ kɛ bɔfʋɛ'n kpɩnlɩn hanlɩn helelɩ bɛ́'n. ");
INSERT INTO any_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Ɔ wɔ ɛbɛlɛ dede mɔ adɔman'n nyanlɩn mɔlɛ kʋn'n, anɩn ɔ di kɛ bɛ kpɛ yɩ́ mmian nun. Bɛ kɔ kpɛ yɩ́ mmian nun'n bɛ kɔ tʋn yɩ́ Zozi. Dunman sɔ'n, bɔfʋɛ'n lili mʋa bɔlɩ helelɩ Mali kʋalaaka nán ɔ'a nwʋnnzɛ. ");
INSERT INTO any_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Ɛhɩ anzin, mɔ Mali efian etue tɛmʋn'n juli'n, kɛ Moyizɩ mala'n kpɩn kele'n, Zozɛfʋ nʋn Mali bɛ kɔ fa baa'n kɔ hɔ Zoluzalɛmʋn. Bɛ 'kɔ a fa yɩ́ bɛ kele yɛ́ Mɩn. ");
INSERT INTO any_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Ɔ sanlɩn kɛ b'a hɛlɛ wɔ yɛ́ Mɩn mala nɩn anun kɛ: Bamuan baa belenzua biala mɔ bɛ kɔ wʋ yɩ́'n, bɛ fá yɩ́ bɛ wúla Nyanmɩan asa nun. ");
INSERT INTO any_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Bɛ kɔ yɩ Mali ati tɛɛ'n mɔ yɛ́ Mɩn mala'n kele'n kʋsʋ. Tɛɛ sɔ'n, bɛ 'yɩ a, bɛ le abubule nnyuan anaan mɔlɔnʋnman nnyuan. ");
INSERT INTO any_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Ɔ 'ba yɔ sɔ'n, anɩn bian kʋn wɔ Zoluzalɛmʋn kulo nɩn asʋ ɛbɛlɛ. Bian sɔ'n, bɛ fɛlɛ yɩ́ Simeʋn. Ɔ tɩ sʋanlan kpa ɛsɛ ɔ man Nyanmɩan anyɩnnzɔ kpa. Ɔ tɩ ɔ lɛ nwʋnndɛ sʋanlan'n mɔ ɔ 'ba ɔ de Izalayɛ ati'n. Nyanmɩan Wawɛ Nwannzan-nwannzan'n wɔ yɩ́ nun. ");
INSERT INTO any_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Wawɛ'n kɔ han kɔ hele yɩ́ kɛ ɔ 'nwun yɛ́ Mɩn Kilisi'n kʋalaaka nán ɔ'a wu. ");
INSERT INTO any_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Cɩan mɔ Zozɛfʋ nʋn Mali bɛ 'fa baa'n bɛ kele yɛ́ Mɩn kɛ mala'n kele'n, Nyanmɩan Wawɛ'n kɔ hyʋɩn Simeʋn ɔ nʋn yɩ́ kɔ a Nyanmɩan awulo nɩn anun ɛbɛlɛ. ");
INSERT INTO any_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Ɔ kɔ a kɔ tʋ bɛ́, ɔ kɔ le baa'n kɔ tʋ yɩ́ sa sʋ, ɔ kɔ la Nyanmɩan asɩ. Yɩ́ nwan: ");
INSERT INTO any_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Sian'n, yɛ́ Mɩn, wɔ́ anɔhʋba nɩn a kpɩn sʋ. Yɩ́ ti, yaci wɔ́ akʋa'n maan ɔ wú ahʋnmɩnkan nun. ");
INSERT INTO any_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Ɔ sanlɩn kɛ m'an nwun sʋanlan'n mɔ ɔ 'de yɛ́ ti'n, ");
INSERT INTO any_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","mɔ a hyɩhyɛ a sʋan yɩ́ mân'n kʋalaa anyunnun'n. ");
INSERT INTO any_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Sʋanlan sɔ'n tɩ kanlannɩɛ. Yɩ́ yɛ̂ ɔ 'ba man mân mân'n kʋalaa nwun wɔ́ ɔ. Ɛsɛ ɔ 'ba man Izalayɛ m'ɔ tɩ wɔ́ mân'n nyan anunminnyanmʋn.” ");
INSERT INTO any_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Zozi anwʋn ɛjɔlɛ'n mɔ anɩn Simeʋn lɛ kan'n kɔ sin Zozɛfʋ nʋn Mali anwʋn. ");
INSERT INTO any_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simeʋn kɔ yeyila bɛ́ sʋ. M'ɔ yeyilalɩ bɛ́ sʋ yuelɩ'n, ɔ kɔ fɛlɛ Zozi anin Mali, yɩ́ nwan: “Nɩan, baa ɛhɩ mɔ Nyanmɩan a yɩ yɩ́'n, ɔ 'ba man Izalayɛ menian dɔʋn fin asɩ, ɔ 'man dɔʋn kʋsʋ jasʋ. Ɔ tɩ nzɔlɛ, menian'n-mɔ 'ba su yɩ́ nwʋn akpʋlʋwa. ");
INSERT INTO any_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Ɔ 'ba man bɛ nwun menian dɔʋn ahʋnlɩn nɩn anun ɛjɔlɛ'n yuein. Nan wɔ́ dɩɛ, m mo, yalɛ 'ba han wɔ́ ɛkala'n kɛ sʋanlan mɔ b'a wɔ yɩ́ dadɩɛ ɔ.” ");
INSERT INTO any_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Mɛlɛ sɔ nɩn anun, anɩn Nyanmɩan kpɔmanfʋɛ balasua kʋn wɔ ɛbɛlɛ. Bɛ fɛlɛ yɩ́ Hanna. Yɩ́ sɩ y'ɔ le Fanuɛ m'ɔ fi Azɛɛ afilie nɩn anun'n. Balasua sɔ'n tɩ sʋanlan kpain kpa. Yɩ́ talua nun, ɔ jalɩ belenzua kʋn, ɔ nʋn yɩ́ bɛ lili afʋɛ nsʋ yɛ̂ belenzua sɔ'n wuli ɔ. ");
INSERT INTO any_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Kɛ ɔ yɔlɩ sɔ'n, Hanna a nja man bian kʋ́n. Ɔ wɔ ɛbɛlɛ dede ɔ lili afʋɛ abulaɔcʋɛ nʋn nnan. Bala sɔ'n kulo Nyanmɩan ɛjɔlɛ kpa. Tɛmʋn biala, kɔngɔɛ o, eyue o, ɔ wɔ Nyanmɩan awulo nɩn anun ɔ sʋ Nyanmɩan ɔ ci cɩan, ɛsɛ ɔ sɛlɛ Nyanmɩan. ");
INSERT INTO any_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Mɔ Simeʋn anʋan 'tɔ ala, Hanna kʋsʋ kɔ fite ɛbɛlɛ. Ɔ kɔ la Nyanmɩan asɩ. M'ɔ yuelɩ'n, ɔ kɔ sʋsɔ sʋ kɔ han baa nɩn anwʋn ɛjɔlɛ ɔ kɔ hele bɛ́ kʋalaa mɔ bɛ lɛ nwʋnndɛ kɛ Nyanmɩan lé Zoluzalɛmʋn amma'n-mɔ ati'n. ");
INSERT INTO any_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Mɔ Zozɛfʋ nʋn Mali yuelɩ ninnge'n mɔ yɛ́ Mɩn mala'n kele'n kʋalaa yɔ'n, bɛ kɔ sa bɛ kɔ hɔ bɛ́ kulo Nazalɛtɩ. Kulo sɔ'n wɔ Galile mân nɩn anun. ");
INSERT INTO any_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Anɩn baa'n lɛ nyin, ɔ lɛ yɔ sʋanlan. Ɔ tɩ bɛngɛlɛfʋɛ ɛsɛ anɩn Nyanmɩan lɛ yeyila yɩ́ sʋ kɔ. ");
INSERT INTO any_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Afʋɛ daa Zozi asɩ nɩn yɩ́ nin, bɛ kɔ Zoluzalɛmʋn, bɛ kɔ li Zufʋ'n-mɔ fɛtɩ'n mɔ bɛ fɛlɛ yɩ́ *Pakɩ'n. ");
INSERT INTO any_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Kɛmɔ afʋɛ daa bɛ kɔ'n, mɔ Zozi lili afʋɛ bulu nʋn nnyuan'n, bɛ nʋn yɩ́ kɔ hɔ fɛtɩ sɔ nɩn elie. ");
INSERT INTO any_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Mɔ bɛ lili fɛtɩ'n yuelɩ'n, yɩ́ sɩ nʋn yɩ́ nin kɔ sa kɔ hɔ. Zozi kɔ ha Zoluzalɛmʋn. Yɩ́ sɩ nʋn yɩ́ nin ngɔ nwun man nun. ");
INSERT INTO any_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Bɛ jʋnlɩn kɛ Zozi wɔ bɛ́ mɔ bɛ nʋn bɛ́ lɛ kɔ nɩn anun bie. Bɛ kɔ nanndɩ cɩan kʋn atɩn asannan nán b'a kpʋnndɛ yɩ́ bɛ́ nwʋn amma nʋn bɛ́ manngʋn'n-mɔ afian. ");
INSERT INTO any_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Bɛ kpʋnndɛlɩ yɩ́ dede a, bɛ ngɔ nwun man yɩ́. Bɛ kɔ sa bɛ kɔ hɔ Zoluzalɛmʋn, bɛ 'kɔ a kpʋnndɛ yɩ́. ");
INSERT INTO any_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Yɩ́ cɩan nsan nɩn asʋ, bɛ 'kɔ a ju a, anɩn Zozi tɩ Nyanmɩan awulo nɩn anun *mala nɩn asʋ mgbain'n-mɔ afian, ɔ lɛ tie bɛ́ ɔ bisa bisa bɛ́ kosuan. ");
INSERT INTO any_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Yɩ́ ngɛlɛ'n m'ɔ fa bua bɛ́ ɛjɔlɛ'n sin menian'n-mɔ kʋalaa mɔ bɛ lɛ tie yɩ́ nɩn anwʋn. ");
INSERT INTO any_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Mɔ yɩ́ sɩ nʋn yɩ́ nin nwunlin kɛ ɔ tɩ bɛ́ afian'n, ɔ sinlɩn bɛ́ nwʋn kpa. Yɩ́ nin nwan: “Mɩ́n wa, nzu ati yɛ̂ a man y'a fɛ sʋa ɔ? Mɩ́n nʋn wɔ́ sɩ y'a kpʋnndɛ wɔ́ dede yɛ́ lʋa a bɔ yɛ́ nwʋn.” ");
INSERT INTO any_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Zozi nwan: “Ɔ yɔ sɛ mɔ ɛmɔ kpʋnndɛ mɩ́n ɔ? Ɛmɔ nzɩ man kɛ ɔ fata kɛ mɩn nɩan mɩ́n Sɩ junman nɩn asʋ wɔ yɩ́ awulo nɩn anun ɔ?” ");
INSERT INTO any_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Nan mɔ Zozi hanlɩn sɔ'n, yɩ́ sɩ nʋn yɩ́ nin, b'a ndɩ man yɩ́ bʋ. ");
INSERT INTO any_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Ɛhɩ anzin, Zozi nʋn bɛ́, bɛ kɔ sa kɔ hɔ Nazalɛtɩ. Ɔ man bɛ́ anyɩnnzɔ. Mɛlɛ biala, yɩ́ nin kacɩ ɛjɔlɛ sɔ'n-mɔ kʋalaatin. ");
INSERT INTO any_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Anɩn Zozi lɛ nyin, ɔ lɛ nwun ngɛlɛ, ɛsɛ ɔ lɛ nyan ehulo wɔ Nyanmɩan nʋn menian'n-mɔ anyunnun. ");
INSERT INTO any_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Ɔ 'ba yɔ sɔ'n, anɩn *Sezaa Tibɛɛ a li *Lɔmʋn ɛhɩnlɩn mân nɩn asʋ belemgbin afʋɛ bulu nʋn nnun. Tɛmʋn sɔ'n, anɩn Pʋnsʋ *Pilatɩ tɩ kʋnmanna wɔ Zude mân nɩn anun. Anɩn *Elɔdɩ Antipasɩ tɩ belemgbin wɔ Galile mân nɩn anun. Yɩ́ nianman Filipʋ kʋsʋ tɩ belemgbin wɔ Itule nʋn Talakonitɩ mân nɩn anun yɛ̂ Lizaniyasɩ kʋsʋ tɩ belemgbin wɔ Abilɛnɩn mân nɩn anun. ");
INSERT INTO any_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","*Hannɩn nʋn *Kayifʋ kʋsʋ yɛ̂ anɩn bɛ tɩ Nyanmɩan Tɛɛyɩfʋɛ mgbain ɔ. Mɛlɛ sɔ kʋnmgba nɩn anun, Nyanmɩan kɔ fɛlɛ Zakali awa Zʋan ɛwa nɩn anun ɛlɔ. Ɔ kɔ fa yɩ́ Nʋan Ɛjɔlɛ'n ɔ kɔ wula yɩ́ nʋan. ");
INSERT INTO any_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","M'ɔ yɔlɩ sɔ'n, Zʋan kɔ jasʋ, ɔ kɔ nanndɩ nanndɩ asue Zuludɩn nɩn anʋan kulo'n-mɔ asʋ. Lɩka m'ɔ kɔ sɩn'n, ɔ kan kele menian'n-mɔ kɛ: “Ɛmɔ nʋn bɛ́ nwʋn bɛ káci bɛ́ abalabɔ'n bɛ fá bɛ́ nwʋn bɛ mán Nyanmɩan maan n zɔ́nɩn bɛ́, nán Nyanmɩan 'yaci ɛmɔ anwʋn sa ce bɛ́.” ");
INSERT INTO any_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Ɔ man ɛjɔlɛ'n mɔ Nyanmɩan kpɔmanfʋɛ Ezayi hanlɩn'n kpɩnlɩn sʋ. Ezayi hɛlɛlɩ wɔ yɩ́ kalata nɩn anun kɛ: Sʋanlan bie lɛ tɩan ɛwâ nɩn anun ɛlɔ kɛ: Ɛmɔ sésie yɛ́ Mɩn atɩn'n, bɛ mán ɔ tɩ́nngɛ fɔ́ʋ́n! ");
INSERT INTO any_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Bɛ tótua mmɔnza'n-mɔ kʋalaa bɛ tútulu kʋnngʋnlʋnman'n-mɔ nʋn mmʋka'n-mɔ kʋalaa anun bɛ tɩ́nngɛ atɩn hyɛhyɩalɩwa'n-mɔ kʋalaa bɛ tótua kunman nganngan'n kʋalaa nán bɛ tútu nyɔbʋɛ finnvelein'n kʋalaa bɛ gúa ");
INSERT INTO any_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Ɛbɛlɛ nɩn anun yɛ̂ menian'n-mɔ kʋalaa 'ba nwun kɛ Nyanmɩan kpɩn de bɛ́ ti ngʋan'n. ");
INSERT INTO any_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Anɩn Zʋan kan kele meninsʋnman'n mɔ bɛ lɛ ba yɩ́ nwʋn maan ɔ sɔnɩn bɛ́'n kɛ: “Ati anun ɛtɛ mma kɛ owo! Nwan y'ɔ selɩ ɛmɔ kɛ ɛsɔnɩan nɩn ala kʋala ɔ de bɛ́ fi Nyanmɩan sikpɛ nɩn anwʋn ɔ? ");
INSERT INTO any_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Yɩ́ ti, ɛmɔ yɔ́ nyɔlɩɛ m'ɔ kele kɛ ɛmɔ a kaci bɛ́ abalabɔ ɛtɛ'n b'a fa bɛ́ nwʋn b'a man Nyanmɩan. Nan nán bɛ se bɛ́ nwʋn kɛ: ‘Yɛ́ sɩ y'ɔ le Abalahamʋn, yɩ́ ti Nyanmɩan ngʋala man yɛ́ like fɩ́ɩ́ yɔ.’ Mɩɩn kan mɩn kele ɛmɔ kɛ, Nyanmɩan kʋala kɛ ɔ fa nyɔbʋɛ ɛhɩ-mɔ kaci Abalahamʋn amma. ");
INSERT INTO any_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","B'a si akunman nɩn a yue. Baka biala m'ɔ nzu man mma kpa'n, bɛ 'kpɛ yɩ́ bʋ bɛ tʋ sɩ̂n nɩn anun.” ");
INSERT INTO any_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","M'ɔ hanlɩn sɔ yuelɩ'n, meninsʋnman'n kɔ bisa yɩ́ kɛ: “Anɩn nzu like dɩɛ kpa yɛ̂ yɛ yɔ́ ɔ?” ");
INSERT INTO any_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Yɩ́ nwan: “Ɛmɔ anun kʋn m'ɔ le taladɩɛ nnyuan'n, ɔ fá kʋn mán m'ɔ le man bie'n, yɛ̂ nun m'ɔ le alɩɛ di'n, ɔ mán m'ɔ le man bie'n lí.” ");
INSERT INTO any_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Anɩn bɛ́ mɔ bɛ dide ajule'n, bɛ́ kʋsʋ, bɛ wɔ meninsʋnman nɩn anun, bɛ 'ba maan Zʋan sɔnɩn bɛ́. Mɔ Zʋan anʋan tɔlɩ'n, bɛ kɔ bisa yɩ́ kɛ: “Kpain, anɩn yɛ 'yɔ sɛ?” ");
INSERT INTO any_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Yɩ́ nwan: “Nán bɛ dide ajule'n bɛ man ɔ tala mɔ mala'n kele nɩn asʋ.” ");
INSERT INTO any_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Anɩn nzalafʋ mmie-mɔ kʋsʋ wɔ ɛbɛlɛ. Nan mɔ Zʋan hanlɩn sɔ'n, bɛ kɔ bisa yɩ́ kɛ: “Anɩn yɛ́ kʋsʋ, nzu yɛ̂ ɔ di kɛ yɛ yɔ́ ɔ?” Zʋan nwan: “Nán bɛ di bɛ́ tunmin nɩn anzin bɛ laka menian'n-mɔ bɛ de bɛ́ esika, nan ɛmɔ lí bɛ́ ahatua nɩn anwʋn fɛ bɛ fá yɩ́ sɔ.” ");
INSERT INTO any_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Kɛmɔ anɩn bagua'n lɛ nwʋnndɛ *Kilisi'n, Izalayɛ Belemgbin Ngʋandefʋɛ'n, bɛ́ kʋalaa bɛ jʋnlɩn kɛ Ngʋandefʋɛ sɔ'n y'ɔ le Zʋan. ");
INSERT INTO any_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Ajʋnlɩn sɔ'n m'ɔ walɩ bɛ́ ti anun nɩn ati, Zʋan kɔ se bɛ́ kʋalaa kɛ: “Mɩ́n dɩɛ n ne nzue yɛ̂ mɩn sɔnɩn ɛmɔ ɔ, nan sʋanlan kʋn m'ɔ fi mɩ́n nzin ɔ lɛ ba'n, ɔ le tunmin tala mɩ́n. N dɩ man like fɩ́ɩ́ yɩ́ nyunnun bɔbɔ nán m'an nyannjɩ yɩ́ ja mgbabʋa nyanman'n. Sʋanlan sɔ'n, ɔ 'ba fa Wawɛ Nwannzan-nwannzan'n ɔ nʋn sɩ̂n ɔ sɔnɩn ɛmɔ. ");
INSERT INTO any_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Ɔ'a sesie yɩ́ nwʋn ɔ le huhuamʋa'n yɩ́ sa nun, ɔ lɛ ba fa huhu mmaka mma kpa'n gua ahanmɩan, nán ɔ ju ewula'n gua sɩ̂n'n m'ɔ le man ayuelɩɛ nɩn anun.” ");
INSERT INTO any_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Mɔ Zʋan hanlɩn sɔ yuelɩ'n, ɔ hanlɩn ɛjɔlɛ dɔʋn mmiekun-mɔ ɔ bɔlɩ Ɛjɔlɛkpa'n ɔ helelɩ bagua'n. ");
INSERT INTO any_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Zʋan ɛjɔlɛ'n m'ɔ kan nɩn anun, ɔ kannzʋ belemgbin Elɔdɩ kɛ yɩ́ nyɔlɩɛ'n-mɔ tɩ man kpa. Ɔ sanlɩn kɛ Elodiadɩ m'ɔ tɩ yɩ́ nianman nɩn ayɩ'n, ɔ'a tʋa yɩ́ ɔ'a le ɔ'a ja, ɛsɛ ɔ'a yɔ nyɔlɩɛ ɛtɛ dɔʋn mmiekun-mɔ ɔ'a gua sʋ. ");
INSERT INTO any_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Nan ɛtɛ kʋn biekun m'ɔ yɔlɩ tʋlɩ sʋ'n, y'ɔ le Zʋan m'ɔ man bɛ tʋlɩ yɩ́ fiadɩ'n. ");
INSERT INTO any_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Zʋan sɔnɩnlɩn menian dɔʋn kpa, Zozi kʋsʋ kɔ a kɔ man ɔ kɔ sɔnɩn yɩ́. M'ɔ sɔnɩnlɩn Zozi yuelɩ'n, mɔ Zozi 'yɔ asɔnɩn'n, anwunno'n kɔ buke, ");
INSERT INTO any_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Nyanmɩan Wawɛ Nwannzan-nwannzan'n kɔ kaci yɩ́ nwʋn kɛ abubule ɔ kɔ ju kɔ tanlan yɩ́ sʋ. Ɛbɛlɛ ala, anɩɛ kʋn fi anwunno ɔ kɔ te. Yɩ́ nwan: “Ɛ tɩ mɩ́n ehulo Baa. M'an fa mɩ́n lʋa'n kʋalaa m'an wula wɔ́ nun.” ");
INSERT INTO any_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Mɔ Zozi lili kɔ yɔ afʋɛ abulasan'n yɛ̂ ɔ bɔlɩ yɩ́ junman nɩn abʋ ɔ. Bɛ́ kʋalaa bɛ jʋnlɩn kɛ yɩ́ sɩ y'ɔ le Zozɛfʋ. Zozɛfʋ sɔ'n, yɩ́ sɩ y'ɔ le Heli. Heli kʋsʋ dɩɛ y'ɔ le Matatɩ. ");
INSERT INTO any_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Matatɩ dɩɛ y'ɔ le Levi. Levi dɩɛ y'ɔ le Mɛlɛki. Mɛlɛki dɩɛ y'ɔ le Zʋannayi. Zʋannayi dɩɛ y'ɔ le Zozɛfʋ. ");
INSERT INTO any_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Zozɛfʋ dɩɛ y'ɔ le Matatiasɩ. Matatiasɩ dɩɛ y'ɔ le Amɔsʋ. Amɔsʋ dɩɛ y'ɔ le Nahumʋn. Nahumʋn dɩɛ y'ɔ le Ɛsɩli. Ɛsɩli dɩɛ y'ɔ le Nagayi. ");
INSERT INTO any_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagayi dɩɛ y'ɔ le Maatɩ. Maatɩ dɩɛ y'ɔ le Matatiasɩ. Matatiasɩ dɩɛ y'ɔ le Semeyinɩn. Semeyinɩn dɩɛ y'ɔ le Zozɛkɩ. Zozɛkɩ dɩɛ y'ɔ le Zoda. Zoda dɩɛ y'ɔ le Zoanan. ");
INSERT INTO any_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Zoanan dɩɛ y'ɔ le Eleza. Eleza dɩɛ y'ɔ le Zolobabɛlɩ. Zolobabɛlɩ dɩɛ y'ɔ le Salasiɛlɩ. Salasiɛlɩ dɩɛ y'ɔ le Neli. ");
INSERT INTO any_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neli dɩɛ y'ɔ le Mɛlɛki. Mɛlɛki dɩɛ y'ɔ le Adi. Adi dɩɛ y'ɔ le Kosamʋn. Kosamʋn dɩɛ y'ɔ le Ɛlɩmadamʋn. Ɛlɩmadamʋn dɩɛ y'ɔ le Ɛlɩ. ");
INSERT INTO any_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Ɛlɩ dɩɛ y'ɔ le Zozi. Zozi dɩɛ y'ɔ le Eliezɛlɩ. Eliezɛlɩ dɩɛ y'ɔ le Zolimʋn. Zolimʋn dɩɛ y'ɔ le Matatɩ. Matatɩ dɩɛ y'ɔ le Levi. ");
INSERT INTO any_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Levi dɩɛ y'ɔ le Simeʋn. Simeʋn dɩɛ y'ɔ le Zuda. Zuda dɩɛ y'ɔ le Zozɛfʋ. Zozɛfʋ dɩɛ y'ɔ le Zonamʋn. Zonamʋn dɩɛ y'ɔ le Eliakimʋn. Eliakimʋn dɩɛ y'ɔ le Melea. ");
INSERT INTO any_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Melea dɩɛ y'ɔ le Mena. Mena dɩɛ y'ɔ le Matata. Matata dɩɛ y'ɔ le Natan. Natan dɩɛ y'ɔ le Davidi. ");
INSERT INTO any_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Davidi dɩɛ y'ɔ le Izayi. Izayi dɩɛ y'ɔ le Zobɛdɩ. Zobɛdɩ dɩɛ y'ɔ le Bozʋ. Bozʋ dɩɛ y'ɔ le Sala. Sala dɩɛ y'ɔ le Naasʋn. ");
INSERT INTO any_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Naasʋn dɩɛ y'ɔ le Aminnandabʋ. Aminnandabʋ dɩɛ y'ɔ le Adimin. Adimin dɩɛ y'ɔ le Aani. Aani dɩɛ y'ɔ le Ɛsɩlɔmʋn. Ɛsɩlɔmʋn dɩɛ y'ɔ le Falɛsɩ. Falɛsɩ dɩɛ y'ɔ le Zuda. ");
INSERT INTO any_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Zuda dɩɛ y'ɔ le Zʋakɔbʋ. Zʋakɔbʋ dɩɛ y'ɔ le Izaakɩ. Izaakɩ dɩɛ y'ɔ le Abalahamʋn. Abalahamʋn dɩɛ y'ɔ le Tala. Tala dɩɛ y'ɔ le Nakɔɔ. ");
INSERT INTO any_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nakɔɔ dɩɛ y'ɔ le Selukɩ. Selukɩ dɩɛ y'ɔ le Alago. Alago dɩɛ y'ɔ le Falɛkɩ. Falɛkɩ dɩɛ y'ɔ le Ebɛɛ. Ebɛɛ dɩɛ y'ɔ le Sala. ");
INSERT INTO any_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sala dɩɛ y'ɔ lɛ Kayinamʋn. Kayinamʋn dɩɛ y'ɔ le Afakɩsadɩ. Afakɩsadɩ dɩɛ y'ɔ le Sɛmʋn. Sɛmʋn dɩɛ y'ɔ le Nowe. Nowe dɩɛ y'ɔ le Lamɛkɩ. ");
INSERT INTO any_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamɛkɩ dɩɛ y'ɛ le Matusalɛmʋn. Matusalɛmʋn dɩɛ y'ɔ le Enɔkɩ. Enɔkɩ dɩɛ y'ɔ le Yelɛdɩ. Yelɛdɩ dɩɛ y'ɔ le Maleleyɛlɩ. Maleleyɛlɩ dɩɛ y'ɔ le Kenamʋn. ");
INSERT INTO any_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kenamʋn dɩɛ y'ɔ le Enɔsɩ. Enɔsɩ dɩɛ y'ɛ le Sɛtɩ. Sɛtɩ dɩɛ y'ɔ le Adamʋn. Adamʋn dɩɛ y'ɔ le Nyanmɩan. ");
INSERT INTO any_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Mɔ bɛ sɔnlɩnlɩn Zozi yuelɩ'n, Wawɛ Nwannzan-nwannzan'n tunmin'n kɔ jinlan yɩ́ nzin kpa bɔkɔɔ. Wawɛ Nwannzan-nwannzan'n kɔ fa yɩ́ fi asue Zuludɩn nɩn anʋan ɛbɛlɛ ɔ nʋn yɩ́ kɔ hɔ ɛwâ nɩn anun. ");
INSERT INTO any_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Ɛbɛlɛ, Abɔnsanmʋn kɔ sɔ Zozi kɔ nɩan dede ɛlɛbulanan. Ɛlɛbulanan sɔ nɩn anun, Zozi ngɔ li like fɩ́ɩ́. Nan mɔ tɛmʋn sɔ'n sɩnlɩn'n, ɛhɔɛ kɔ hun Zozi. ");
INSERT INTO any_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Ɛhɩ, Abɔnsanmʋn kɔ han kɔ hele yɩ́ kɛ: “Sɛ ɛ tɩ Nyanmɩan Awa sakpa a, anɩn kan kele ɛbʋɛ ɛhɩ maan ɔ káci kpaʋn.” ");
INSERT INTO any_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Zozi nwan: “Ɔ wɔ Ɛhɛlɛ Ɛjɔlɛ nɩn anun kɛ: Nán kpaʋn ala yɛ̂ sʋanlan di a, ɔ nyan ngʋan ɔ.” ");
INSERT INTO any_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Mɔ Zozi hanlɩn sɔ'n, Abɔnsanmʋn kɔ fa yɩ́ kɔ hɔ bʋka kannganlaun kʋn ati sʋ. Ɛbɛlɛ ala, ɔ kɔ fa asɩɛ nɩn asʋ mmelemgbin mân'n-mɔ kʋalaa kɔ hele Zozi. ");
INSERT INTO any_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Yɩ́ nwan: “Tunmin ɛhɩ ɔ nʋn anunminnyanmʋn'n mɔ mmelemgbin mân'n-mɔ le yɩ́'n, b'a fa yɩ́ kʋalaa b'a wula mɩ́n sa nun. Yɛ̂ sʋanlan mɔ mɩn kulo kɛ mɩn fa mɩn man yɩ́'n yɛ̂ mɩn 'fa mɩn man yɩ́ ɔ. ");
INSERT INTO any_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Yɩ́ ti, sɛ ɛ kʋtʋ mɩ́n nyunnun ɛ sʋ mɩ́n an, yɩ́ kʋalaa 'yɔ wɔ́ dɩɛ.” ");
INSERT INTO any_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Ɛhɩ a, Zozi nwan: “Ɔ wɔ Ɛhɛlɛ Ɛjɔlɛ nɩn anun kɛ: Kʋtʋ Ɛdannganman m'ɔ tɩ wɔ́ Nyanmɩan nɩn anyunnun nán sʋ yɩ́ kʋnmgba cein.” ");
INSERT INTO any_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Mɔ Zozi bualɩ yɩ́ sɔ yuelɩ'n, Abɔnsanmʋn falɩ yɩ́ biekun an, yɩ́ nʋan y'ɔ le Zoluzalɛmʋn, Nyanmɩan awulo nɩn ati sʋ. Yɩ́ nwan: “Sɛ wɔ́ nwan ɛ tɩ Nyanmɩan Awa sakpa a, yaci wɔ́ nwʋn nun, kulu tɔ asɩ, ");
INSERT INTO any_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","afɩ, ɔ wɔ Ɛhɛlɛ Ɛjɔlɛ nɩn anun kɛ: Wɔ́ dunman nun, Nyanmɩan 'ba man yɩ́ mmɔfʋɛ'n-mɔ atɩn maan bɛ nɩan wɔ́ sʋ. Ɛsɛ ɔ wɔ nun kɛ: ");
INSERT INTO any_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Bɛ 'sɔ wɔ́ bɛ́ sa nun, nán wɔ́ ja a mgbula man ɛbʋɛ.” ");
INSERT INTO any_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Mɔ Abɔnsanmʋn hanlɩn sɔ'n, Zozi nwan: “Ɛhɛlɛ Ɛjɔlɛ'n kan kɛ: N'ɛ sɔ yɛ́ Mɩn m'ɔ tɩ wɔ́ Nyanmɩan'n nɩan.” ");
INSERT INTO any_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Abɔnsanmʋn yɔlɩ butu ɔ nʋn bɛtɛ mɔ yɩ́ sa a ngan man Zozi'n, ɔ yacili yɩ́ ɛbɛlɛ ɔ hɔlɩ, ɔ 'nwʋnndɛ cɩan fʋfɔlɛ biekun. ");
INSERT INTO any_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Ɛhɩ, Zozi kɔ sa kɔ hɔ Galile mân nɩn anun. Wawɛ Nwannzan-nwannzan'n tunmin'n jin yɩ́ nzin. Galile mân nɩn anun lɩka biala, bɛ bɔ yɩ́ dunman. ");
INSERT INTO any_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Ɔ kekele menian'n-mɔ ninnge Zufʋ'n-mɔ asɔnɩn sua'n-mɔ anun yɛ̂ bɛ́ kʋalaa bɛ yɩ yɩ́ ayɛ. ");
INSERT INTO any_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Zozi kɔ hɔ Nazalɛtɩ, kulo'n mɔ bɛ talɩ yɩ́ sʋ nɩn asʋ. Ɔ kɔ wʋlʋ Zufʋ'n-mɔ asɔnɩn sua nɩn anun kɛ ɔ yɔ yɩ́ ɛnwʋnmɩan ele cɩan biala'n. Bɛ yɔlɩ asɔnɩn'n dede mɔ ɔ 'kɔ bie'n, ɔ kɔ jasʋ, ɔ lɛ ba kɩnnga Ɛhɛlɛ Ɛjɔlɛ'n. ");
INSERT INTO any_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Bɛ kɔ fa Nyanmɩan kpɔmanfʋɛ *Ezayi kalata'n mɔ b'a baka'n bɛ kɔ wula yɩ́ sa nun. Ɔ kɔ tɛlɛ nun, ɔ kɔ nwun lɩka mɔ b'a hɛlɛ kɛ: ");
INSERT INTO any_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Yɛ́ Mɩ́n Wawɛ'n wɔ mɩ́n nun ɔ'a yɩ mɩ́n kɛ m mála m mɔ́ Ɛjɔlɛkpa'n n géle ehianfʋɛ'n-mɔ. Ɔ'a sʋan mɩ́n kɛ m mála n yɩ́ bɛ́ mɔ b'a gua bɛ́ fiadɩ'n. Bɛ́ mɔ bɛ́ nyɩn a sin'n, m mán bɛ nwún asɩ. Bɛ́ mɔ bɛ lɛ kele bɛ́ ahʋlʋwa'n, m mán bɛ nyán bɛ́ ti. ");
INSERT INTO any_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Ɛsɛ m mála n gán n géle bɛ́ kɛ afʋɛ'n mɔ Nyanmɩan 'de menian'n-mɔ ati nɩn a ju. ");
INSERT INTO any_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Mɔ Zozi yuelɩ yɩ́ kɩnnga'n, ɔ kɔ baka kalata'n, ɔ kɔ fa kɔ wula sʋanlan'n m'ɔ nɩan sʋ nɩn asa nun, ɔ kɔ tanlan asɩ. Menian'n-mɔ kʋalaa mɔ bɛ wɔ asɔnɩn sua nɩn anun'n, bɛ́ nyɩn kɔ ha yɩ́ nwʋn. ");
INSERT INTO any_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Zozi kukuli yɩ́ nʋan sʋ a, yɩ́ nwan: “Ɛnɛ, Ɛhɛlɛ Ɛjɔlɛ ɛhɩ mɔ ɛmɔ a tɩ nɩn a kpɩn sʋ.” ");
INSERT INTO any_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Zozi ɛjʋjɔlɛ fɛ'n yɔlɩ bɛ́ ɛnyɩnmɩn kpa, ɔ sinlin bɛ́ nwʋn. Bɛ́ nwan: “Bian ɛhɩ muonun, asʋ nán Zozɛfʋ awa nɩn ɔ?” ");
INSERT INTO any_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Zozi nwan: “Ɔ tɩ ananhɔlɛ, ɛmɔ 'ba bu anyɩnndala ɛhɩ bɛ kele mɩ́n kɛ: ‘Sɛ wɔ́ nwan ɛ tɩ ayile ɛyɔlɛfʋɛ a, di mʋa yɔ wɔ́ nwʋn ayile.’ Ɛsɛ ɛmɔ 'ba han tʋ sʋ kɛ: ‘Ninnge'n mɔ y'a tɩ kɛ a yɔ yɩ́ Kapɛɛnawɔmʋn ɛlɔ'n, yɔ bie wɔ́ kulo nɩn asʋ ɛwa.’” ");
INSERT INTO any_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Ɛsɛ, yɩ́ nwan: “Mɩɩn kan yɩ́ ananhɔlɛ mɩn kele ɛmɔ kɛ Nyanmɩan kpɔmanfʋɛ biala le man ɛfɛlɩɛ yɩ́ muonun yɩ́ kulo. ");
INSERT INTO any_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Mɩɩn kan yɩ́ ananhɔlɛ mɩn kele ɛmɔ kɛ Nyanmɩan kpɔmanfʋɛ *Eli mɛlɛ sʋ, tɛmʋn mɔ esue nɩn a ndɔ man dede afʋɛ nsan sala nsian mɔ ɛhɔɛ kpili kpa kpɩnlɩn mân bɔndɩn nɩn anun'n, anɩn kunlannvʋɛ mmalasua dɔʋn wɔ Izalayɛ mân nɩn anun. ");
INSERT INTO any_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Nan kʋsʋ, Nyanmɩan a nzʋan man Eli a man ɔ'a ngɔ a mmʋka man bɛ́ bie fɩ́ɩ́, sannan kunlannvʋɛ ɛyɛfʋɛ balasua'n m'ɔ tɩ Salɛpɩta kulo nɩn asʋ, Sidʋn mân nɩn anun ɛlɔ'n. ");
INSERT INTO any_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Ɛsɛ Nyanmɩan kpɔmanfʋɛ Elize kʋsʋ mɛlɛ sʋ, anɩn kokobefʋɛ sʋnlɩn Izalayɛ mân nɩn anun. Nan kʋsʋ, Elize a mman bɛ́ bie fɩ́ɩ́ anwʋn a nza man, sannan Naaman m'ɔ fi Sili mân nɩn anun ɛlɔ'n.” ");
INSERT INTO any_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Bɛ́ kʋalaa mɔ bɛ wɔ asɔnɩn sua nɩn anun mɔ bɛ tɩlɩ ɛjɔlɛ sɔ'n, bɛ kɔ fɛ yɩ́ nwʋn ɛya kpa. ");
INSERT INTO any_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Bɛ kɔ jasʋ, bɛ kɔ sʋsɔ yɩ́, bɛ nʋn yɩ́ kɔ hɔ bʋka'n mɔ bɛ́ kulo'n wɔ sʋ nɩn ati afian kɛ bɛ 'kɔ a ju yɩ́ bɛ tʋ bɔnza nɩn anun bɛ kun yɩ́. ");
INSERT INTO any_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Nan Zozi wʋlʋlɩ bɛ́ sa abʋ ala, ɔ kɔ hɔ. ");
INSERT INTO any_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Mɔ Zozi fi Nazalɛtɩ bʋka nɩn asʋ ɔ juli'n, ɔ kɔ hɔ Galile mân nɩn anun kulo'n mɔ bɛ fɛlɛ yɩ́ Kapɛɛnawɔmʋn nɩn asʋ. Mɔ ɛnwʋnmɩan ele cɩan'n juli'n, Zozi kɔ hɔ asɔnɩn sua nɩn anun ɔ 'kɔ a kekele bɛ́ ninnge. ");
INSERT INTO any_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Ninnge'n-mɔ m'ɔ lɛ kekele'n kɔ sin bɛ́ nwʋn, ɔ sanlɩn kɛ ɔ kan yɩ́ ɛjɔlɛ dɩɛ'n tunmin sʋ. ");
INSERT INTO any_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Anɩn bian kʋn wɔ asɔnɩn sua nɩn anun ɛbɛlɛ. Bian sɔ'n, wawɛ ɛtɛ kʋn wɔ yɩ́ nun. Ɔ kɔ tɩan nun sɛlɛ kpa. ");
INSERT INTO any_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","Yɩ́ nwan: “E! Zozi m'ɔ fi Nazalɛtɩ, ɛ 'se yɛ́ sɛ? Ɛ walɩ yɛ́ bʋsʋ ɛbɔ anaan? Mɩn sɩ wɔ́ bɔkɔɔ! Ɛ tɩ Nyanmɩan Sʋanlan Nwannzan-nwannzan!” ");
INSERT INTO any_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Mɔ sʋanlan'n hanlɩn sɔ'n, Zozi kɔ tɩan wawɛ ɛtɛ nɩn asʋ. Yɩ́ nwan: “Muan wɔ́ nʋan nɩn asʋ, nán fi sʋanlan ɛhɩ anun fite!” Mɔ Zozi hanlɩn sɔ'n, menian'n-mɔ anyunnun ɛbɛlɛ, wawɛ ɛtɛ'n kɔ fin bian nɩn asɩ, ɔ fi yɩ́ nun kɔ fite kɔ hɔ, ɔ'a nyɔ man yɩ́ like fɩ́ɩ́. ");
INSERT INTO any_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Ɛjɔlɛ sɔ'n kɔ sin bɛ́ kʋalaa bɛ́ nwʋn, sian'n, bɛ lɛ bisa bisa bɛ́ nwʋn kɛ: “Anɩn nzu asinbɛnwʋn ɛjɔlɛ dɩɛ ahɩ? Bian ɛhɩ le yɩ́ tunmin'n ɔ fʋan wawɛ ɛtɛ'n-mɔ a, bɛ fite!” ");
INSERT INTO any_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Kɛ ɔ yɔlɩ sɔ'n, mân sɔ nɩn anun lɩka kʋalaa, anɩn bɛ lɛ kan Zozi ɛjɔlɛ. ");
INSERT INTO any_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Mɔ Zozi fi asɔnɩn sua nɩn anun fitelɩ'n, ɔ kɔ hɔ *Simʋn awulo ɛlɔ. Ɔ 'kɔ a ju a, anɩn Simʋn asebala nɩn a fʋkɛ kpa, ebunnun nɩn a yue yɩ́ cɩcɩ. Bɛ kɔ bɔ Zozi amannɩɛ kɛ ɔ tʋ́tʋn yɩ́ mán bɛ́. ");
INSERT INTO any_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Zozi kɔ hyʋɩn kɔ mantan wuluwafʋɛ'n, yɩ́ nwan: “Ebunnun, fi balasua ɛhɩ anwʋn tu!” Kɛ ɔ hanlɩn sɔ nɩn ala, ebunnun'n fi balasua nɩn anwʋn kɔ tu. Balasua'n kɔ jasʋ kɔ hɔ sɩ̂n nɩn anwʋn ɛlɔ ɔ kɔ man bɛ́ like bɛ kɔ li. ");
INSERT INTO any_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Nɔsʋba mɔ sɛnzɛ'n tɔlɩ'n, bɛ́ nʋn nwuluwafʋɛ ngacile ngacile kʋalaa kɔ 'a Zozi anwʋn ɛbɛlɛ. Ɔ kɔ fa yɩ́ sa'n kɔ fua bɛ́ nwʋn, bɛ́ nwʋn kɔ sa. ");
INSERT INTO any_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Mmɔnsanmʋn'n-mɔ fi nwuluwafʋɛ'n-mɔ dɔʋn anun bɛ kɔ fite, anɩn bɛ lɛ tɩan bɛ kan kɛ: “Wɔ́, ɛ tɩ Nyanmɩan Awa!” Nan mɔ bɛ 'kan sɔ'n, anɩn Zozi lɛ tɛtɩan bɛ́ ɔ totua bɛ́, ɔ sanlɩn kɛ bɛ́ dɩɛ, bɛ sɩ kɛ *Kilisi'n y'ɔ le yɩ́. ");
INSERT INTO any_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Mɔ alɩ́ɛ hɩnlɩn'n, Zozi kɔ tɩ yɩ́ nwʋn kɔ hɔ ahanmɩan lɩka mɔ sʋanlan fɩ́ɩ́ nnʋn man'n. Meninsʋnman kɔ kpʋnndɛ yɩ́. Nan mɔ bɛ nwunlin yɩ́'n, bɛ́ nwan: “Yɛ 'sɛlɛ wɔ́, n'ɛ kɔ lɩka fɩ́ɩ́ kʋ́n.” ");
INSERT INTO any_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Zozi nwan: “Ɔ sɛ kɛ mɩn bɔ Nyanmɩan Belemgbin Mân nɩn anwʋn Ɛjɔlɛkpa'n mɩn kele kulo nga'n-mɔ kʋsʋ. Afɩ yɩ́ sɔ ati yɛ̂ Nyanmɩan sʋanlɩn mɩ́n ɔ.” ");
INSERT INTO any_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","M'ɔ hanlɩn sɔ yuelɩ'n, ɔ kɔ hɔ Zufʋ'n-mɔ asɔnɩn sua'n-mɔ anun ɔ kɔ bɔ Ɛjɔlɛkpa'n kɔ hele bɛ́. ");
INSERT INTO any_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Cɩan kʋn Zozi kɔ hɔ *Zenezalɛtɩ asue nɩn anʋan, menian dɔʋn kɔ kpʋ yɩ́ ɛbɛlɛ, bɛ kɔ ta kɔ si kɔ yia yɩ́, bɛ 'kɔ a tie Nyanmɩan Anʋan Ɛjɔlɛ'n m'ɔ lɛ kan'n. ");
INSERT INTO any_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Zozi 'tʋ yɩ́ nyɩn an, anɩn ɛlɛɛ nnyuan sisi ɛbɛlɛ, sʋanlan fɩ́ɩ́ nnʋn man nun. Bɛ́ mɔ bɛ cɩ ejue'n, bɛ fi nun b'a ju, bɛ lɛ nwunnzin nwunnzin bɛ́ dada'n-mɔ anun. ");
INSERT INTO any_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Zozi kɔ hɔ kɔ fʋ ɛlɛɛ'n kʋn anun. Ɛlɛɛ sɔ'n tɩ Simʋn dɩɛ. Zozi kɔ sɛlɛ Simʋn kɛ ɔ tú ɛlɛɛ'n ɔ hɔ́ bunman sʋ kaan. Zozi kɔ tanlan ɛlɛɛ nɩn akunnun ɔ kɔ hehele meninsʋnman'n ninnge. ");
INSERT INTO any_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","M'ɔ yuelɩ bɛ́ ninnge kekele'n, yɩ́ nwan: “Simʋn, tu ɛlɛɛ'n kɔ bunman sʋ nán ɛ nʋn wɔ́ manngʋn'n-mɔ bɛ gúa bɛ́ dada'n.” ");
INSERT INTO any_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Mɔ Zozi hanlɩn sɔ'n, Simʋn nwan: “Kpain, ɔ bɔ yɩ́ bʋ kɔngɔɛ angʋnmɩn, y'a gua dada dede y'a njɩ man ejue fɩ́ɩ́. Nan kʋsʋ kɛmɔ wɔ́ nwan n gúa'n, mɩn 'gua.” ");
INSERT INTO any_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Ɛbɛlɛ ala, bɛ kɔ gua bɛ́ dada'n-mɔ. Bɛ kɔ hyɩ ejue dɔʋn kpa dede bɛ́ dada'n-mɔ lɛ tɩtɩ. ");
INSERT INTO any_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Mɔ bɛ nwunlin yɩ́ sɔ'n, bɛ kɔ tʋ bɛ́ sa bɛ kɔ fɛlɛ bɛ́ manngʋn'n-mɔ mɔ bɛ wɔ ɛlɛɛ ɛhɩnlɩn anun'n kɛ bɛ bála a bʋka bɛ́. Bɛ kɔ a bɛ kɔ wula bɛ́ ɛlɛɛ nnyuan'n tɩtɛkɛɛ, ɔ ka mɔ bɛ nʋan ɔ. ");
INSERT INTO any_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Mɔ Simʋn Pɩɛlɩ nwunlin yɩ́ sɔ'n, ɔ kɔ kʋtʋ Zozi anyunnun ɛbɛlɛ, yɩ́ nwan: “Yɛ́ Mɩn, n'ɛ fa wɔ́ nwʋn bɔ mɩ́n. Ɔ sanlɩn kɛ n dɩ ɛtɛfʋɛ.” ");
INSERT INTO any_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Simʋn hanlɩn sɔ, ɔ sanlɩn kɛ ejue mɔ bɛ hyɩlɩ yɩ́ cɩan sɔ'n sinlin yɩ́ nʋn yɩ́ manngʋn'n-mɔ kʋalaa anwʋn, ɛsɛ esulo hanlɩn bɛ́. ");
INSERT INTO any_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Esulo kʋnmgba sɔ'n kʋsʋ hanlɩn Zʋakɩ ɔ nʋn Zʋan, Zebede amma'n mɔ bɛ nʋn Simʋn di junman'n. Ɛhɩ a, Zozi nwan: “Simʋn, n'ɛ sulo! Nan ɛnɛ m'ɔ kɔ'n, ɛ 'ba fɛfɛlɛ menian man mɩ́n.” ");
INSERT INTO any_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Ɛjɔlɛ sɔ'n mɔ Zozi hanlɩn nɩn ati, mɔ bɛ sisili bɛ́ ɛlɛɛ'n-mɔ asɩ'n, bɛ yacili bɛ́ junman'n kʋalaatin ɛbɛlɛ, bɛ sili yɩ́ sʋ. ");
INSERT INTO any_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Cɩan kʋn Zozi kɔ hɔ kulo kʋn asʋ. Ɔ ju ɛbɛlɛ ala, kokobefʋɛ kʋn kɔ a kɔ tʋ yɩ́. Bian sɔ'n kɔ butu yɩ́ nyɩn asɩ yɩ́ nwan: “Yɛ́ Mɩn, sɛ ɛ kulo a, ɛ kʋala kɛ ɛ man mɩ́n nwʋn sa.” ");
INSERT INTO any_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Mɔ kokobefʋɛ'n hanlɩn sɔ'n, Zozi kɔ tɩnngɛ yɩ́ sa kɔ han yɩ́, yɩ́ nwan: “Mɩn kulo, man wɔ́ nwʋn tɩ́!” Ɛbɛlɛ ala, bian nɩn anwʋn kɔ sa. ");
INSERT INTO any_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Zozi nwan: “N'ɛ kan mɔ m'an yɔ nɩn anwʋn ɛjɔlɛ kele sʋanlan fɩ́ɩ́. Nan kɔ kɔ tʋ Nyanmɩan tɛɛyɩfʋɛ'n m'ɔ wɔ ɛbɛlɛ'n, fa wɔ́ nwʋn'n kele yɩ́. Ɛbɛlɛ tɛɛ'n mɔ *Moyizɩ helelɩ'n, yɩ maan bɛ́ kʋalaa bɛ nwun yɩ́ kɛ wɔ́ nwʋn a sa.” ");
INSERT INTO any_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Anɩn Zozi dunman'n lɛ fʋ. Menian dɔʋn ba tie yɩ́ ɛjɔlɛ'n m'ɔ kan'n, ɛsɛ bɛ ba yɩ́ nwʋn bɛ man bɛ́ nwʋn sa. ");
INSERT INTO any_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Nan tɛmʋn'n bie ju a, Zozi tɩ yɩ́ nwʋn kɔ ahanmɩan ɔ kɔ sɛlɛ Nyanmɩan. ");
INSERT INTO any_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Ɛcɩan kʋn anɩn Zozi lɛ kekele menian'n-mɔ ninnge. Meninsʋnman'n mɔ bɛ walɩ'n, anɩn *Falisifʋɛ'n-mɔ nʋn *mala mgbain'n-mɔ wɔ bɛ́ nun bie. Bɛ tɩtɩ asɩ Zozi anwʋn ɛbɛlɛ. Mmie-mɔ fi Galile nʋn Zude mân nun, mmie kʋsʋ fi Zoluzalɛmʋn kulo nɩn asʋ. Ɛcɩan sɔ'n, anɩn yɛ́ Mɩn tunmin'n jin Zozi anzin ɔ kɔ man nwuluwafʋɛ'n-mɔ anwʋn kɔ sa. ");
INSERT INTO any_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Kaan cɛ, menian mmie-mɔ nʋn bubuluwafʋɛ kʋn kɔ a, ɔ la ɛbɛɛ sʋ. Bɛ lɛ kpʋnndɛ atɩn bɛ sɩn bɛ fa wuluwafʋɛ'n bɛ fite Zozi anyunnun. ");
INSERT INTO any_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Meninsʋnman'n dunman nun, kɛmɔ bɛ nnyan man atɩn bɛ nzɩn man'n, bɛ kɔ fʋ sua'n mɔ Zozi wɔ nun nɩn asʋ. Bɛ kɔ kpɛ tokolo sua nɩn ati afian, bɛ kɔ fa bubuluwafʋɛ'n bɛ kɔ jula yɩ́ nʋn yɩ́ ɛbɛɛ'n Zozi anyunnun ɛbɛlɛ menian'n-mɔ kʋalaa afian. ");
INSERT INTO any_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Mɔ Zozi nwunlin bɛ́ dedi'n, ɔ kɔ han kɔ hele wuluwafʋɛ'n kɛ: “Njabian, b'a fa wɔ́ ɛtɛ'n b'a hye wɔ́.” ");
INSERT INTO any_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Ɛjɔlɛ sɔ'n m'ɔ hanlɩn nɩn ati, Falisifʋɛ'n-mɔ nʋn mala nɩn asʋ mgbain'n-mɔ lɛ kan yɩ́ bɛ́ ti akunnun kɛ: “Nwan sʋanlan dɩɛ ahɩ m'ɔ kʋala ɔ kan ɛjɔlɛ ɛtɛ sʋa tia Nyanmɩan ɔ? Sɛ nán Nyanmɩan angʋnmɩn cein an, nwan y'ɔ kʋala sʋanlan ɛtɛ fa ce yɩ́ ɔ?” ");
INSERT INTO any_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Ajʋnlɩn sɔ'n mɔ bɛ falɩ nɩn ati, Zozi nwan: “Nzukɛ ati yɛ̂ ajʋnlɩn sʋa-mɔ wɔ ɛmɔ ati anun ɔ? ");
INSERT INTO any_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Sɛ mɩn kan kɛ: ‘B'a fa wɔ́ ɛtɛ'n b'a hye wɔ́’ a, ɛmɔ nnwun man nun. Nan sɛ mɩn kan mɩn kele wuluwafʋɛ'n kɛ: ‘Jasʋ nanndɩ’ nán ɔ yɔ sɔ a, ");
INSERT INTO any_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","anɩn ɛmɔ a nwun yɩ́ kɛ *Mân Baa'n le tunmin asɩɛ nɩn asʋ ɛwa ɔ fa ɛtɛ ce.” Ɛhɩ a, ɔ kɔ han kɔ hele bubuluwafʋɛ'n kɛ: “Mɩɩn kan mɩn kele wɔ́, jasʋ, fa wɔ́ ɛbɛɛ'n nán kɔ wɔ́ awulo!” ");
INSERT INTO any_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Ɛbɛlɛ ala, bɛ́ kʋalaa bɛ́ nyunnun ɛbɛlɛ, bian'n kɔ jasʋ kɔ fa yɩ́ ɛbɛɛ'n m'ɔ lalɩ sʋ'n, ɔ kɔ hɔ yɩ́ awulo. Ɔ 'kɔ a, anɩn ɔ lɛ yɩ Nyanmɩan ayɛ. ");
INSERT INTO any_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Ɛjɔlɛ'n kɔ sin bɛ́ kʋalaa bɛ́ nwʋn. Esulo kɔ han bɛ́, bɛ lɛ yɩ Nyanmɩan ayɛ, bɛ́ nwan: “Ɛnɛ dɩɛ, fɔ́ʋ́n y'a nwun ɛnyɩnmɩan ninnge yɛ́ nyɩnsʋ!” ");
INSERT INTO any_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Ɛhɩ anzin, Zozi fi sua nɩn anun kɔ fite. Ɔ 'kɔ ju a, anɩn bian kʋn, bɛ fɛlɛ yɩ́ Levi, ɔ tɩ lɩka mɔ bɛ didi ajule'n. Levi sɔ'n, ɔ dide ajule. Zozi kɔ fɛlɛ yɩ́, yɩ́ nwan: “Levi, jasʋ, si mɩ́n sʋ!” ");
INSERT INTO any_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Ɛbɛlɛ ala, Levi kɔ jasʋ kɔ yaci yɩ́ junman'n ɔ kɔ si yɩ́ sʋ. ");
INSERT INTO any_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Levi kɔ bɔ Zozi ati ɔ kɔ man bɛ kɔ tʋn alɩɛ kpili kpa yɩ́ awulo. Mɔ bɛ 'didi'n, bɛ́ mɔ bɛ dide ajule'n nʋn menian mmiekun-mɔ dɔʋn kpa nʋn bɛ́ gugua tɔbɩlɩ nɩn anwʋn. ");
INSERT INTO any_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","*Falisifʋɛ'n-mɔ nʋn *mala nɩn asʋ mgbain'n-mɔ mɔ bɛ nʋn bɛ́ di fâ kʋn'n kɔ yue ɛya fɛ. Bɛ kɔ bisa Zozi menian'n-mɔ kɛ: “Nzu ati yɛ̂ ɛmɔ nʋn bɛ́ mɔ bɛ dide ajule'n nʋn ɛtɛfʋɛ'n-mɔ didi'n?” ");
INSERT INTO any_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Zozi nwan: “Sʋanlan mɔ ewue lɛ ngun man yɩ́'n, ɔ mgbʋnndɛ man ayile ɛyɔlɛfʋɛ. Nan sʋanlan m'ɔ lɛ wu'n y'ɔ kpʋnndɛ ayile ɛyɔlɛfʋɛ ɔ. ");
INSERT INTO any_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","M'an mma man kɛ mɩn 'ba fɛlɛ bɛ́ mɔ bɛ tɩ sɛsɛ wɔ Nyanmɩan anyunnun'n maan bɛ kaci bɛ́ abalabɔ'n. Nan bɛ́ mɔ bɛ tɩ ɛtɛfʋɛ'n-mɔ, bɛ́ ti yɛ̂ m malɩ ɔ.” ");
INSERT INTO any_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Ɛhɩ anzin, bɛ́ nun mmie-mɔ kɔ bisa Zozi kɛ: “Zʋan menian'n-mɔ nʋn Falisifʋɛ'n-mɔ dɩɛ'n-mɔ, ɔ yɔ a, bɛ di abuala bɛ sɛlɛ Nyanmɩan. Nan kʋsʋ wɔ́ dɩɛ'n-mɔ nni man abuala, tɛmʋn sɔ'n, anɩn bɛ lɛ didi bɛ nʋnnʋn.” ");
INSERT INTO any_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Mɔ Zozi tɩlɩ ɛjɔlɛ sɔ'n, yɩ́ nwan: “Mɛlɛ mɔ atɔnvɔlɛ bian'n wɔ ɛbɛlɛ'n, yɩ́ manngʋn'n-mɔ mɔ bɛ wɔ atɔnvɔlɛ nɩn abʋ'n, bɛ ngʋala man kɛ bɛ bua bɛ da ɔ. ");
INSERT INTO any_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Nan mɛlɛ bie 'ba ju, atɔnvɔlɛ bian'n fi bɛ́ sa nun ɔ 'ba tu. Mɛlɛ sɔ nɩn anun, bɛ 'ba li abuala.” ");
INSERT INTO any_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Mɔ Zozi hanlɩn sɔ yuelɩ'n, ɔ kɔ han nvandʋhʋn ɛjɔlɛ kʋn kɔ tʋ sʋ, yɩ́ nwan: “Sʋanlan fɩ́ɩ́ nzua man ɛtanlan fʋfɔlɛ ndafuin ɔ ndua man ɛtanlan daba nun tokolo. Sɛ ɔ yɔ yɩ́ sɔ a, anɩn ɔ'a sɛcɩ ɛtanlan fʋfɔlɛ'n yɛ̂ ndafuin sɔ'n nʋn ɛtanlan daba ngɔ man sʋ. ");
INSERT INTO any_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Sʋanlan fɩ́ɩ́ ngaci man nzan fʋfɔlɛ ngua man kpolo kotoku daba nun. Sɛ ɔ yɔ yɩ́ sɔ a, kpolo kotoku'n 'te, nzan'n 'butu, anɩn kpolo kotoku nɩn a yɔ mgban. ");
INSERT INTO any_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Nan nzan fʋfɔlɛ'n, bɛ fa bɛ gua kpolo kotoku fʋfɔlɛ nun. ");
INSERT INTO any_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Ɛsɛ sʋanlan biala m'ɔ nʋn nzan daba'n, ɔ mgbʋnndɛ man nzan fʋfɔlɛ. Afɩ yɩ́ nwan: ‘Nzan daba'n dɩɛ bɛ nnyan man yɩ́ nwʋn sʋ.’” ");
INSERT INTO any_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Cɩan kʋn Zozi nʋn yɩ́ menian'n-mɔ kɔ kpɛ nun *bele ebo kʋn asʋ. Cɩan sɔ'n, ɔ tɩ ɛnwʋnmɩan ele cɩan. Yɩ́ menian'n-mɔ kɔ tɩtɩ bele mma'n bie bɛ kɔ kputa yɩ́ bɛ́ sa nun bɛ kɔ yɩyɩ yɩ́ nwʋn abʋɩn'n bɛ kɔ li. ");
INSERT INTO any_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Mɔ Falisifʋɛ'n-mɔ nwunlin yɩ́ sɔ'n, bɛ́ nwan: “Nzukɛ ati yɛ̂ ɛmɔ yɔ like mɔ yɛ́ mala'n tua kɛ nán bɛ yɔ yɩ́ ɛnwʋnmɩan ele cɩan'n?” ");
INSERT INTO any_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Mɔ bɛ hanlɩn sɔ'n, Zozi kɔ bua bɛ́ kɛ: “Asʋ ɛmɔ kɩnngalɩ man like mɔ Davidi yɔlɩ, mɛlɛ mɔ ɛhɔɛ hunlin yɩ́ nʋn yɩ́ menian'n-mɔ nɩn anwʋn ɛjɔlɛ'n lé ɔ? ");
INSERT INTO any_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Davidi wʋlʋlɩ Nyanmɩan sua nɩn anun, ɔ falɩ kpaʋn'n-mɔ mɔ b'a fa b'a man Nyanmɩan'n, ɔ nʋn yɩ́ menian'n-mɔ bɛ lili. Kpaʋn sɔ'n, Zufʋ'n-mɔ mala'n kele kɛ sʋanlan ngacile biala le man atɩn ɔ nni man kɛ Nyanmɩan tɛɛyɩfʋɛ'n-mɔ ala.” ");
INSERT INTO any_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Mɔ Zozi bualɩ bɛ́ sɔ'n, nán ɔ'a han ɔ'a tʋ sʋ kɛ: “Mân Baa'n tɩ ɛnwʋnmɩan ele cɩan nɩn asʋ kpain.” ");
INSERT INTO any_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Ɛnwʋnmɩan ele cɩan kʋn biekun, Zozi kɔ wʋlʋ asɔnɩn sua kʋn anun, ɔ kɔ hehele ninnge. Anɩn bian kʋn wɔ asɔnɩn sua nɩn anun ɛbɛlɛ, yɩ́ sa fama nɩn a jɔ. ");
INSERT INTO any_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Mala nɩn asʋ mgbain'n-mɔ nʋn Falisifʋɛ'n-mɔ mɔ bɛ wɔ ɛbɛlɛ'n, anɩn bɛ lɛ nɩan sɛ Zozi kɔ man wuluwafʋɛ bie anwʋn kɔ sa ɛnwʋnmɩan ele cɩan nɩn an. Ɔ sanlɩn kɛ bɛ lɛ kpʋnndɛ atɩn bɛ sɩn sʋ bɛ tʋn yɩ́ ɛsʋan. ");
INSERT INTO any_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Nan kɛmɔ Zozi sɩ mɔ b'a jʋnlɩn'n, ɔ kɔ han kɔ hele wuluwafʋɛ'n kɛ: “Jasʋ jinlan menian'n-mɔ kʋalaa anyunnun ɛwa.” Bian'n kɔ jasʋ kɔ jinlan bɛ́ nyunnun ɛbɛlɛ. ");
INSERT INTO any_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Mɔ bian'n jasʋlɩ jinlanlɩn'n Zozi kɔ kaci yɩ́ nyɩn meninsʋnman nɩn anwʋn ɛlɔ, yɩ́ nwan: “Mɩn 'ba bisa ɛmɔ kosuan. Yɛ́ mala'n kele sɛ? Ɔ kele kɛ yɛ yɔ́ ye ɛnwʋnmɩan ele cɩan nɩn anaan yɛ yɔ́ ɛtɛ? Yɛ lé sʋanlan ati ngʋan anaan yɛ hún yɩ́ ɔ?” ");
INSERT INTO any_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Zozi kɔ nɛnɩan bɛ́ kʋalaa bɛ́ nyunnun, ɔ kɔ tʋ yɩ́ nyɩn wuluwafʋɛ nɩn anwʋn ɛlɔ, yɩ́ nwan: “Tɩnngɛ wɔ́ sa nɩn anun.” Bian'n kɔ tɩnngɛ nun, ɛbɛlɛ ala, yɩ́ sa'n kɔ yɔ kpa. ");
INSERT INTO any_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Ɛhɩ, Falisifʋɛ'n-mɔ nʋn mala nɩn asʋ mgbain'n-mɔ kɔ fɛ ɛya kpa. Sian'n bɛ lɛ bisa bisa bɛ́ nwʋn like mɔ bɛ 'yɔ nán bɛ́ sa a han Zozi'n. ");
INSERT INTO any_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Mɛlɛ sɔ nɩn anun, Zozi kɔ hɔ kɔ fʋ bʋka kʋn asʋ. Ɔ 'kɔ a sɛlɛ Nyanmɩan. Ɔ kɔ sɛlɛ Nyanmɩan kɔngɔɛ dede alɩ́ɛ kɔ hɩn. ");
INSERT INTO any_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Mɔ alɩ́ɛ hɩnlɩn'n, Zozi kɔ fɛfɛlɛ yɩ́ menian'n-mɔ bɛ kɔ yia. Ɔ kɔ nɩan bɛ́ nun kɔ yɩ bulu nʋn nnyuan ɔ kɔ tʋn bɛ́ mmɔfʋɛ. ");
INSERT INTO any_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Menian bulu nʋn nnyuan sɔ'n-mɔ y'ɔ le: Simʋn mɔ Zozi fɛlɛ yɩ́ Pɩɛlɩ'n, ɔ nʋn yɩ́ nianman Andele, Zʋakɩ nʋn Zʋan, Filipʋ nʋn Baatelemin, ");
INSERT INTO any_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matie nʋn Toma, Alɩfe awa Zʋakɩ nʋn Simʋn mɔ bɛ fɛlɛ yɩ́ *Zɛlɔtʋfʋɛ'n, ");
INSERT INTO any_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Zʋakɩ awa Zudɩ, ɔ nʋn Zudasɩ Isikaliɔtɩ mɔ ɔ 'ba yɩ Zozi man'n. ");
INSERT INTO any_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Ɛhɩ, Zozi nʋn yɩ́ mmɔfʋɛ'n-mɔ, bɛ fi bʋka nɩn asʋ, bɛ kɔ ju bɛ kɔ jinlan lɩka sɛsɛ kʋn. Lɩka sɔ'n, anɩn Zozi menian dɔʋn kpa a yia ɛbɛlɛ. Menian sɔ'n-mɔ, mmie-mɔ fi Zude mân nun. Mmie-mɔ fi Zoluzalɛmʋn. Mmie-mɔ fi jenvie nɩn anʋan ɛlɔ kulo'n-mɔ mɔ bɛ mantan mantan Tii nʋn Sidʋn nɩn asʋ. ");
INSERT INTO any_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Bɛ walɩ kɛ bɛ 'ba a tie Zozi Anʋan Ɛjɔlɛ'n, ɛsɛ bɛ man bɛ́ nwʋn sa. Bɛ́ mɔ bɛ́ kʋsʋ wawɛ ɛtɛ wɔ bɛ́ nun m'ɔ kele bɛ́ yalɛ'n, wawɛ ɛtɛ'n fi bɛ́ nun tu. ");
INSERT INTO any_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Bɛ́ kʋalaa bɛ kulo kɛ bɛ kan Zozi. Ɔ sanlɩn kɛ tunmin kʋn fi yɩ́ nun fite y'ɔ man bɛ́ nwʋn sa ɔ. ");
INSERT INTO any_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","M'ɔ yɔlɩ sɔ'n, Zozi kɔ tʋ yɩ́ nyɩn yɩ́ menian'n-mɔ ɛlɔ yɩ́ nwan: “Nyila hán ɛmɔ mɔ bɛ tɩ ehianfʋɛ'n, ɔ sanlɩn kɛ Nyanmɩan Belemgbin Mân'n tɩ ɛmɔ dɩɛ! ");
INSERT INTO any_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","“Nyila hán ɛmɔ mɔ ɛhɔɛ lɛ kun ɛmɔ kɩkaala'n, ɔ sanlɩn kɛ ɛmɔ akʋ 'ba yi. “Nyila hán ɛmɔ mɔ bɛ le sun'n, ɔ sanlɩn kɛ ɛmɔ 'ba sɩlɩ. ");
INSERT INTO any_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","“Nyila hán ɛmɔ, mɛlɛ mɔ bɛ lɛ kpɔ ɛmɔ, mɔ bɛ lɛ fʋan ɛmɔ, mɔ bɛ lɛ kpɛ ɛmɔ nzʋba, mɔ bɛ lɛ bu ɛmɔ menian mgban wɔ *Mân Baa'n dunman nun. ");
INSERT INTO any_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Mɔ bɛ 'yɔ ɛmɔ sɔ'n, ɛmɔ lí fɛ bɛ mán bɛ́ nwʋn tɛ bɛ́ bɛ sí abile bɛ húhulu. Ɔ sanlɩn kɛ ɛmɔ 'ba nyan yɩ́ nwʋn ahatua kpili kpa wɔ anwunno ɛlɔ. Afɩ daba, kɛ bɛ́ nan-mɔ helelɩ Nyanmɩan mgbɔmanfʋɛ'n-mɔ ahʋlʋwa nɩn anɩn. ");
INSERT INTO any_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“Nan ɛmɔ esikafʋɛ'n-mɔ, munnzue hán ɛmɔ! Ɔ sanlɩn kɛ ɛmɔ asa a han ɛmɔ salɩɛ dɩɛ'n dada angʋnmɩn. ");
INSERT INTO any_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","“Munnzue hán ɛmɔ mɔ bɛ́ kʋ a yi'n! Ɔ sanlɩn kɛ ɛhɔɛ 'ba hun ɛmɔ. “Ɛmɔ mɔ bɛ lɛ sɩlɩ kɩkaala'n, munnzue hán ɛmɔ! Ɔ sanlɩn kɛ alʋabɔ 'ba han ɛmɔ, ɛmɔ 'ba sun. ");
INSERT INTO any_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","“Munnzue hán ɛmɔ mɔ menian'n-mɔ kʋalaatin kan ɛmɔ anwʋn ɛjɔlɛ kpa'n. Afɩ daba, kɛ bɛ́ nan-mɔ hanlɩn ato mgbɔmanfʋɛ'n-mɔ anwʋn ɛjɔlɛ kpa nɩn anɩn. ");
INSERT INTO any_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Nan ɛmɔ mɔ bɛ lɛ tie mɩ́n'n, mɩɩn kan mɩn kele ɛmɔ kɛ: Ɛmɔ húlo bɛ́ mɔ bɛ kpɔ ɛmɔ'n. Ɛmɔ yɔ́ bɛ́ ye. ");
INSERT INTO any_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Ɛmɔ yéyila bɛ́ mɔ bɛ bɔ ɛmɔ sasan nɩn asʋ. Ɛmɔ yɔ́ asɔnɩn bɛ man bɛ́ mɔ bɛ kele ɛmɔ ahʋlʋwa'n. ");
INSERT INTO any_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Sɛ sʋanlan bie kpacɩ ɛmɔ anyɩn bɛ̂ nɩn asʋ a, bɛ káci fama'n maan ɔ kpácɩ sʋ. Sɛ sʋanlan bie de ɛmɔ taladɩɛ'n mɔ bɛ wula yɩ́ sʋ nɩn an, ɛmɔ yɩ́ mɔ ɛmɔ wula yɩ́ bʋ'n kʋsʋ bɛ mán yɩ́. ");
INSERT INTO any_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Sʋanlan biala m'ɔ kɔ sɛlɛ ɛmɔ like'n, ɛmɔ fá mán yɩ́. Sɛ sʋanlan tʋa ɛmɔ de like mɔ ɛmɔ le nɩn an, nán bɛ bisa yɩ́ bʋsʋ. ");
INSERT INTO any_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Like mɔ ɛmɔ kulo kɛ menian'n-mɔ yɔ man ɛmɔ'n, ɛmɔ kʋsʋ yɔ́ like sɔ'n bɛ mán bɛ́. ");
INSERT INTO any_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Sɛ bɛ́ mɔ bɛ kulo ɛmɔ nɩn ala yɛ̂ ɛmɔ kʋsʋ kulo bɛ́ a, nzu nvasʋɛ dɩɛ yɛ̂ ɛmɔ nyan yɩ́ sʋ ɔ? Ɛtɛfʋɛ'n-mɔ kʋsʋ kulo bɛ́ mɔ bɛ kulo bɛ́'n. ");
INSERT INTO any_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Sɛ bɛ́ mɔ bɛ yɔ ɛmɔ ye nɩn ala yɛ̂ ɛmɔ kʋsʋ yɔ bɛ́ ye a, nzu nvasʋɛ dɩɛ yɛ̂ ɛmɔ nyan yɩ́ sʋ ɔ? Ɛtɛfʋɛ'n-mɔ kʋsʋ yɔ sɔ bie. ");
INSERT INTO any_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Bɛ́ mɔ ɛmɔ bɔ bɛ́ bʋsɩa a ɛmɔ de di kɛ bɛ kʋala yɩ́ tua'n, sɛ bɛ́ ngʋnmɩn ala yɛ̂ ɛmɔ bɔ bɛ́ bʋsɩa a, nzu nvasʋɛ dɩɛ yɛ̂ ɛmɔ nyan yɩ́ sʋ ɔ? Ɛtɛfʋɛ'n-mɔ kʋsʋ bɔ bɛ́ manngʋn ɛtɛfʋɛ'n-mɔ mɔ bɛ kʋala kalɛ'n tua'n bʋsɩa. ");
INSERT INTO any_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Nan ɛmɔ dɩɛ, nán bɛ yɔ sɔ. Ɛmɔ húlo bɛ́ mɔ bɛ kpɔ ɛmɔ'n, ɛmɔ yɔ́ bɛ́ ye, ɛmɔ bɔ́ bɛ́ bʋsɩa, nán bɛ susu bɛ́ ti bɛ gua sʋ kɛ bɛ túa bɛ mán ɛmɔ. Sɛ ɛmɔ yɔ sɔ a, ɛmɔ 'ba nyan yɩ nwʋn ahatua kpili kpa, ɛsɛ ɛmɔ 'ba kaci Nyanmɩan m'ɔ wɔ anwunno anwunno ɛlɔ nɩn amma. Ɔ sanlɩn kɛ ɔ tɩ kpa man menian mɔ bɛ nzɩ man ye'n, ɔ nʋn menian kʋsʋ mɔ bɛ́ kunnun tɩ ɛtɛ'n. ");
INSERT INTO any_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Kɛmɔ ɛmɔ Asɩ'n sɩ anwunnvoe'n, ɛmɔ kʋsʋ nwún anwunnvoe. ");
INSERT INTO any_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Nán bɛ bua bɛ́ manngʋn'n-mɔ ndɛɛ nán Nyanmɩan Kpili kʋsʋ a mmua man ɛmɔ ndɛɛ. Nán bɛ bu sʋanlan fɩ́ɩ́ fʋɔ nán Nyanmɩan kʋsʋ a mmu man ɛmɔ fʋɔ. Ɛmɔ fá bɛ́ manngʋn'n-mɔ ɛtɛ'n bɛ hyé bɛ́ nán Nyanmɩan kʋsʋ a fa ɛmɔ dɩɛ nɩn a hye ɛmɔ. ");
INSERT INTO any_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Ɛmɔ hyé bɛ́ manngʋn'n-mɔ nán Nyanmɩan kʋsʋ a hye ɛmɔ bie. Bɛ 'su ninnge bɛ gua ɛmɔ taladɩɛ'n pɔsʋ kpili nɩn anun, bɛ 'tinndin sʋ kpa maan ɔ yi dede ɔ bʋ sʋ. Susulɩɛ'n mɔ ɛmɔ fa bɛ susu ninnge bɛ man bɛ́ manngʋn-mɔ'n, yɩ́ yɛ̂ Nyanmɩan 'fa susu man ɛmɔ ɔ.” ");
INSERT INTO any_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Mɔ Zozi hanlɩn sɔ yuelɩ'n, ɛsɛ ɔ kɔ bu anyɩnndala kʋn biekun kɔ hele bɛ́, yɩ́ nwan: “Anyɩnsinlinwafʋɛ, ɔ nni man yɩ́ manngʋn anyɩnsinlinwafʋɛ taataa. Sɛ ɔ yɔ yɩ́ sɔ a, bɛ́ munnyuan bɛ 'gua kunman nun. ");
INSERT INTO any_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Sʋanlan mɔ bɛ lɛ kele yɩ́ like'n, ɔ nzɩ man like ndala man yɩ́ mɩn'n m'ɔ lɛ kele yɩ́'n. Kʋsʋ sɛ ɔ suan like nán ɔ nwun yɩ́ kpa bɔkɔɔ a, ɔ kaci kɛ yɩ́ mɩn'n. ");
INSERT INTO any_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Nzukɛ ati yɛ̂ ɛ lɛ nɩan tabʋa munmuin kaan'n m'ɔ la wɔ́ nianman nɩn anyɩn nɩn asʋ, nan kʋsʋ ɛ nnwun man tabʋa ebue'n m'ɔ la wɔ́ dɩɛ nɩn asʋ'n? ");
INSERT INTO any_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Ɔ yɔ sɛ mɔ ɛ kʋala ɛ kan kele wɔ́ nianman'n kɛ: ‘Anianman, yaci mɩ́n maan n yɩ́ wɔ́ nyɩn nɩn asʋ munmuin kaan'n’, wɔ́ mɔ ɛ nnwun man kɛ tabua ebue kʋn la wɔ́ nyɩn dɩɛ nɩn asʋ'n? Ɛ bɔ wɔ́ nwʋn apoo. Di mʋa yɩ m'ɔ la wɔ́ nyɩn nɩn asʋ'n, asannan nán a nwun asɩ a yɩ m'ɔ la wɔ́ nianman'n dɩɛ nɩn asʋ'n. ");
INSERT INTO any_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Baka kpa nzu man mma ɛtɛ yɛ̂ baka ɛtɛ kʋsʋ nzu man mma kpa. ");
INSERT INTO any_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Baka biala m'ɔ jin'n, yɩ́ mma'n y'ɔ man bɛ nwun yɩ́ nzɔlɛ ɔ. Bɛ ndɩ man *figi mma eminlan mmowe'n-mɔ asʋ. Yɛ̂ bɛ ndɩ man divɩn mma kʋsʋ baka mɔ yɩ́ nwʋn le bowe nɩn asʋ. ");
INSERT INTO any_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Sʋanlan m'ɔ tɩ kpa'n, ati anun kpa ninnge y'ɔ yɔ ɔ. Sʋanlan kʋsʋ m'ɔ tɩ man kpa'n, ati anun ɛtɛ ninnge y'ɔ yɔ ɔ. Ɔ sanlɩn kɛ ɛjɔlɛ m'ɔ wɔ sʋanlan akunnun'n y'ɔ fite yɩ́ nʋan ɔ. ");
INSERT INTO any_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Nzukɛ ati yɛ̂ ɛmɔ fɛlɛ mɩ́n ‘yɛ́ Mɩn, yɛ́ Mɩn’, kʋsʋ ɛmɔ nyɔ man like mɔ n gɔ bisa'n? ");
INSERT INTO any_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Sʋanlan m'ɔ kɔ a mɩ́n nwʋn, m'ɔ kɔ tie mɩ́n nʋan ɛjɔlɛ'n, m'ɔ kɔ nanndɩ sʋ'n, ɛ 'nwun like m'ɔ soman yɩ́'n: ");
INSERT INTO any_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Ɔ soman sʋanlan m'ɔ lɛ si sua. Ɔ'a fun kunman'n maan ɔ'a hɔ mʋa ɔ'a wula yɩ́ bʋ ɔ'a si sua nɩn ɛbʋɛ nɩn asʋ. Mɔ fɔsɩɛ'n tikelɩ'n, asue'n-mɔ kɔ yi kɔ bu asɩ ɔ kɔ han sua'n, nan kʋsʋ ɔ'a ngʋala man yɩ́ bu. Ɔ sanlɩn kɛ sua sɔ'n jin bi. ");
INSERT INTO any_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Sʋanlan kʋsʋ m'ɔ tie mɩ́n Nʋan Ɛjɔlɛ'n m'ɔ nnanndɩ man sʋ'n, ɔ soman sʋanlan mɔ ɔ'a si yɩ́ sua nɩn anyʋan nɩn asʋ. Ɔ'a nwula man sua nɩn abʋ. Mɔ fɔsɩɛ'n tikelɩ'n, asue'n-mɔ kɔ yi kɔ bu asɩ ɔ kɔ han sua'n. Ɛbɛlɛ ala, sua sɔ'n kɔ bubu kɔ gua kpa bɔkɔɔ.” ");
INSERT INTO any_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Mɔ Zozi yuelɩ ɛjɔlɛ ɛhɩka kʋalaa kan kele menian'n-mɔ, ɔ kɔ hɔ Kapɛɛnawɔmʋn. ");
INSERT INTO any_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Anɩn Lɔmʋn nzalafʋ kpain'n kʋn wɔ Kapɛɛnawɔmʋn ɛbɛlɛ. Nzalafʋ kpain sɔ'n, ɔ le yɩ́ akʋa kʋn mɔ yɩ́ nwʋn cian yɩ́ kpa ɔ. Akʋa sɔ'n kɔ fʋkɛ kpa ɔ le de ewue wu. ");
INSERT INTO any_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Mɔ nzalafʋ kpain'n tɩlɩ Zozi angan'n, ɔ kɔ sʋan zufʋ mgbain'n mmie-mɔ kɛ bɛ hɔ́ fɛ́lɛ Zozi maan ɔ bála a yɔ maan yɩ́ akʋa nɩn anwʋn sa. ");
INSERT INTO any_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Bɛ kɔ hɔ Zozi anwʋn ɛlɔ bɛ kɔ bʋtʋ yɩ́. Bɛ́ nwan: “Sʋanlan sɔ'n dɩɛ, ɔ fata kɛ ɛ bʋa yɩ́. ");
INSERT INTO any_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Ɔ sanlɩn kɛ ɔ kulo yɛ́ Zufʋ mân'n. Yɩ́ yɛ̂ ɔ'a si yɛ́ Nyanmɩan sua nɩn ɔ.” ");
INSERT INTO any_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Ɛhɩ a, Zozi nʋn bɛ́ bɛ kɔ hɔ. Mɔ bɛ hɔlɩ dede bɛ ka kaan bɛ ju awulo nɩn anwʋn'n, nzalafʋ kpain'n kɔ sʋan menian kɛ bɛ hɔ́ sé Zozi kɛ: “Kpain, n'ɛ kele wɔ́ nwʋn ɛfɛ. Ɔ sanlɩn kɛ mɩn nzɛ nvata man kɛ ɛ wʋ́lʋ mɩn awulo. ");
INSERT INTO any_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Ɛhɩka ati yɛ̂ mɩ́n muonun m'an mma man wɔ́ ja sʋ ɔ, afɩ mɩn nzɛ nvata man. Nan kan ɛjɔlɛ kpɔlɛ kʋnmgba cein, mɩ́n akʋa nɩn anwʋn 'ba sa. ");
INSERT INTO any_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Mɩ́n, n ne mɩ́n nyunnun mgbain mɔ bɛ sie mɩ́n ɔ. Mɩ́n kʋsʋ, n ne nzalafʋ mɔ mɩn sie bɛ́ ɔ. Sɛ mɩn kan mɩn kele nunhan kʋn kɛ: ‘Kɔ!’ a, ɔ kɔ. Sɛ mɩn kan mɩn kele nunhan kʋn biekun kɛ: ‘Bala!’ a, ɔ ba. Sɛ mɩn kan mɩn kele mɩ́n akʋa'n kɛ: ‘Yɔ like ɛhɩ’ a, ɔ yɔ.” ");
INSERT INTO any_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Mɔ Zozi tɩlɩ ɛjɔlɛ sɔ'n, ɔ kɔ fʋa nzalafʋ kpain'n. Ɔ kɔ bɩlɩ yɩ́ nyɩn ɔ kɔ han kɔ hele menian'n-mɔ mɔ bɛ si yɩ́ sʋ'n kɛ: “Mɩɩn kan yɩ́ ananhɔlɛ mɩn kele ɛmɔ: Izalayɛ mân nɩn anun ɛwa muonun, sʋanlan m'ɔ le dedi kɛ sʋanlan ɛhɩ'n, n nwunlin man bie lé.” ");
INSERT INTO any_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Bɛ́ mɔ nzalafʋ kpain'n sʋanlɩn bɛ́'n kɔ sa kɔ hɔ awulo. Bɛ 'ju ɛlɔ a, akʋa nɩn anwʋn a sa bɔkɔɔ. ");
INSERT INTO any_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Ɛhɩ anzin, Zozi kɔ hɔ Galile mân nɩn anun kulo kʋn asʋ. Kulo sɔ'n, bɛ fɛlɛ yɩ́ Naɩn. Mɔ ɔ 'kɔ'n, yɩ́ menian'n-mɔ nʋn meninsʋnman sili yɩ́ sʋ. ");
INSERT INTO any_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Bɛ hɔlɩ dede mɔ bɛ ka kaan bɛ ju kulo nɩn anʋan nɩn anwʋn ɛbɛlɛ'n, bɛ 'nɩan an, anɩn bɛ nʋn fuin kʋn lɛ sɩn kɔ asielɩɛ sʋ. Sʋanlan'n mɔ bɛ lɛ kɔ a sie yɩ́'n, ɔ tɩ belenzua bangɔlɔ yɛ̂ yɩ́ nin tɩ kunlannvʋɛ. Kulo nɩn asʋ menian dɔʋn kpa nʋn kunlannvʋɛ balasua'n wɔ ɛbɛlɛ. ");
INSERT INTO any_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Mɔ Zozi nwunlin balasua'n, yɩ́ nwʋn kɔ yɛ yɩ́ koun nán ɔ a se yɩ́ kɛ: “N'ɛ sun kʋ́n!” ");
INSERT INTO any_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Zozi kɔ kpunnge alaka'n, ɔ kɔ fa yɩ́ sa kɔ han yɩ́. Bɛ́ mɔ bɛ lile alaka nɩn anun'n kɔ jinlan, Zozi nwan: “Kpafɛlɛ, mɩɩn kan mɩn kele wɔ́, fi ewue nun tínnge!” ");
INSERT INTO any_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Sʋanlan'n mɔ ɔ'a wu'n kɔ jasʋ kɔ tanlan asɩ ɔ lɛ jʋjɔ. Zozi kɔ fa yɩ́ kɔ man yɩ́ nin. ");
INSERT INTO any_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Esulo kɔ han bɛ́ kʋalaa, bɛ kɔ yɩ Nyanmɩan ayɛ. Bɛ́ nwan: “Nyanmɩan kpɔmanfʋɛ kpili kpa kʋn a fite yɛ́ afian ɛwa!” Ɛsɛ bɛ́ nwan: “Nyanmɩan a a yɛ́ ɛkpala.” ");
INSERT INTO any_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Like sɔ'n mɔ Zozi yɔlɩ'n, Zude mân'n lɩka kʋalaatin, ɔ nʋn mân mân mɔ bɛ mantan yɩ́'n, bɛ́ kʋalaa bɛ tɩlɩ. ");
INSERT INTO any_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Ninnge kʋalaa mɔ Zozi yɔlɩ'n, Zʋan Batisi menian'n-mɔ hɔlɩ bɔlɩ nun amannɩɛ bɛ helelɩ yɩ́. Zʋan kɔ fɛlɛ yɩ́ menian'n-mɔ anun nnyuan ");
INSERT INTO any_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","ɔ kɔ sʋan bɛ́ yɛ́ Mɩn anwʋn ɛlɔ kɛ bɛ hɔ́ bísa yɩ́ kɛ: “Sʋanlan'n mɔ yɛ sɩ kɛ ɔ lɛ ba'n y'ɔ le wɔ́ anaan sʋanlan sɔ'n tɛ wɔ sian?” ");
INSERT INTO any_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Mɔ bɛ juli Zozi anwʋn ɛbɛlɛ'n, bɛ́ nwan: “Zʋan Batisi a sʋan yɛ́ kɛ yɛ bála a bisa wɔ́ kɛ sɛ sʋanlan'n mɔ yɛ sɩ kɛ ɔ lɛ ba'n y'ɔ le wɔ́ a, sɛ kʋsʋ sʋanlan sɔ'n tɛ wɔ sian an, anɩn ɛ hán héle yɛ́.” ");
INSERT INTO any_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Tɛmʋn sɔ'n, bɛ́ mɔ ewue lɛ kun bɛ́'n, Zozi kɔ man bɛ́ nwʋn kɔ sa. Ɔ kɔ fʋan wawɛ ɛtɛ'n-mɔ mɔ bɛ wɔ menian'n-mɔ anun'n, ɛsɛ ɔ kɔ tike tike anyɩnsinlinwafʋɛ dɔʋn anyɩn'n. ");
INSERT INTO any_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","M'ɔ yɔlɩ sɔ'n, Zozi kɔ han kɔ hele bɛ́ mɔ Zʋan sʋanlɩn bɛ́'n kɛ: “Ɛmɔ hɔ́ hán mɔ ɛmɔ a tɩ'n, ɔ nʋn mɔ ɛmɔ a nwun yɩ́'n bɛ héle Zʋan. Ɛmɔ a nwun kɛ anyɩnsinlinwafʋɛ'n-mɔ anyɩn'n-mɔ a tike tike, bɛ́ mɔ bɛ tia bɛ tɔ sʋ'n-mɔ aja'n-mɔ a tɩnngɛ tɩnngɛ, kokobefʋɛ'n-mɔ anwʋn a tɩ, anzʋtiliwafʋɛ'n-mɔ tɩ ɛjɔlɛ, bɛ́ mɔ b'a wu'n-mɔ a tinnge tinnge, ehianfʋɛ'n-mɔ lɛ tɩ Ɛjɔlɛkpa'n. ");
INSERT INTO any_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Nyila hán sʋanlan mɔ ɔ mminlin man yɩ́ dedi'n m'ɔ le yɩ́ wɔ mɩ́n nun'n.” ");
INSERT INTO any_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Mɔ bɛ́ mɔ Zʋan sʋanlɩn bɛ́'n salɩ hɔlɩ'n, Zozi kɔ han Zʋan ɛjɔlɛ ɔ kɔ hele menian'n-mɔ. Yɩ́ nwan: “Nzu like dɩɛ yɛ̂ ɛmɔ hɔlɩ nɩanlɩn yɩ́ ɛwâ nɩn anun ɛlɔ ɔ? Ndɛɛ mɔ anwʋnman lɛ fita anaan? ");
INSERT INTO any_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Nan nzu like dɩɛ yɛ̂ ɛmɔ hɔlɩ nɩanlɩn ɔ? Ɛmɔ hɔlɩ nɩanlɩn sʋanlan m'ɔ wula taladɩɛ kanlanman anaan? Bɛ́ mɔ bɛ wula esikafʋɛ ndaladɩɛ mɔ bɛ tɩ lɩka kanlanman'n, menian sɔ'n-mɔ gua mmelemgbin'n-mɔ awulo. ");
INSERT INTO any_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Anɩn nzu like dɩɛ fɔ́ʋ́n yɛ̂ ɛmɔ hɔlɩ nɩanlɩn ɔ? Nyanmɩan kpɔmanfʋɛ anaan? Yuo, mɩɩn kan mɩn kele ɛmɔ kɛ ɔ tala Nyanmɩan kpɔmanfʋɛ bɔbɔ. ");
INSERT INTO any_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Ɔ sanlɩn kɛ Zʋan yɛ̂ Ɛhɛlɛ Ɛjɔlɛ'n kan yɩ́ ɛjɔlɛ kɛ: Nyanmɩan nwan: Mɩɩn sʋan mɩ́n bɔfʋɛ'n mɩn man ɔ di mʋa wɔ́ nyunnun ɔ sesie wɔ́ atɩn'n.” ");
INSERT INTO any_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Zozi kɔ han kɔ tʋ sʋ kɛ: “Mɩɩn kan yɩ́ ananhɔlɛ mɩn kele ɛmɔ kɛ bɛ wʋlɩ man sʋanlan fɩ́ɩ́ kʋ́n m'ɔ tɩ kpili tala Zʋan ɔ. Nan kʋsʋ sʋanlan bɔbɔ m'ɔ tɩ kaan sʋa Nyanmɩan Belemgbin Mân nɩn anun'n, ɔ tala Zʋan kpili.” ");
INSERT INTO any_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Bagua'n, yɩ́ lɩlɩ bɛ́ mɔ bɛ dide ajule'n, bɛ tielɩ Zʋan anʋan ɛjɔlɛ'n bɛ man ɔ sɔnɩnlɩn bɛ́. Afɩ bɛ nwunlin kɛ Nyanmɩan atɩn dɩɛ'n tɩ fɔ́ʋ́n. ");
INSERT INTO any_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Nan *Falisifʋɛ'n-mɔ nʋn *mala nɩn asʋ mgbain'n-mɔ dɩɛ, like mɔ Nyanmɩan kulo kɛ ɔ yɔ man bɛ́'n, b'a ndie man. Ɛhɩ ati b'a man Zʋan a nzɔnɩn man bɛ́. ");
INSERT INTO any_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Zozi kɔ tʋ sʋ kɛ: “Nwan bɔbɔ yɛ̂ n vá ajulisʋ menian ɛhɩ-mɔ n zusu bɛ́ ɔ? Nwan yɛ̂ bɛ soman yɩ́ ɔ? ");
INSERT INTO any_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Bɛ soman mmatʋnman nganngan mɔ bɛ gugua gua nɩn asʋ, mɔ bɛ lɛ tɛtɩan bɛ se bɛ́ manngʋn'n-mɔ kɛ: ‘Y'a bɔ abile dede ɛmɔ a nzi man! Y'a tʋ alʋabɔ ejue dede ɛmɔ a nzun man!’ ");
INSERT INTO any_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Ɔ sanlɩn kɛ Zʋan Batisi walɩ, ɔ nni man alɩɛ, ɛsɛ ɔ nnʋn man nzan, nan kʋsʋ ɛmɔ nwan: ‘Wawɛ ɛtɛ yɛ̂ ɔ wɔ yɩ́ nun ɔ!’ ");
INSERT INTO any_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Mân Baa'n kʋsʋ a a, ɔ di alɩɛ, ɔ nʋn nzan, ɛsɛ ɛmɔ nwan: ‘Bɛ nɩ́an sʋanlan ɛhɩ, yɩ́ dɩɛ, ɔ njʋnlɩn ɛjɔlɛ fɩ́ɩ́ kɛ alɩɛ nʋn nzan ɛjɔlɛ ala yɛ̂ ɔ jʋnlɩn ɔ. Yɩ́ manngʋn y'ɔ le bɛ́ mɔ bɛ dide ajule'n ɔ nʋn ɛtɛfʋɛ'n-mɔ!’ ");
INSERT INTO any_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Nan kʋsʋ bɛ́ kʋalaa mɔ bɛ de Nyanmɩan bɛ di'n, bɛ kele kɛ Nyanmɩan tɩ bɛngɛlɛfʋɛ sakpa.” ");
INSERT INTO any_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","*Falisifʋɛ kʋn fɛlɛlɩ Zozi kɛ ɔ bála a li like yɩ́ awulo. Mɛlɛ mɔ bɛ lɩla mgba nɩn asʋ tɔbɩlɩ nɩn anwʋn'n, ");
INSERT INTO any_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","kulo sɔ nɩn asʋ balasua kʋn kɔ wʋlʋ ɛbɛlɛ. Balasua sɔ'n si tutu. M'ɔ tɩlɩ kɛ Zozi wɔ Falisifʋɛ nɩn awulo ɛbɛlɛ ɔ lɛ didi'n, ɔ kɔ fa anatɩlɩ bondoman tɛkɛɛ kʋn mɔ yɩ́ gua yɔ sɩ'n kɔ a. ");
INSERT INTO any_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Balasua'n kɔ jinlan Zozi aja ngʋa. Ɔ kɔ sun ɔ kɔ fa yɩ́ nyɩn ɛmʋɩn'n ɔ kɔ lɔlʋa Zozi aja nɩn anwʋn. Ɔ kɔ fa yɩ́ ti enyuan'n ɔ kɔ cici ɔ kɔ fa Zozi aja'n ɔ kɔ bɔ yɩ́ hue sʋ, ɛsɛ ɔ kɔ fa anatɩlɩ'n ɔ kɔ bɔ yɩ́ ja nɩn anwʋn. ");
INSERT INTO any_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Mɔ Falisifʋɛ'n m'ɔ fɛlɛlɩ Zozi alɩɛ'n nwunlin yɩ́ sɔ'n, ɔ kɔ han yɩ́ ti anun kɛ: “Sɛ sʋanlan ɛhɩ tɩ Nyanmɩan kpɔmanfʋɛ sakpa a, ahan ɔ 'nwun kɛ balasua'n mɔ ɔ'a han yɩ́'n tɩ ɛtɛfʋɛ. Ɔ sanlɩn kɛ ɔ si tutu.” ");
INSERT INTO any_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Mɔ anɩn Falisifʋɛ'n lɛ kan ɛhɩ yɩ́ ti anun'n, Zozi kɔ kuku yɩ́ nʋan sʋ ɔ kɔ han kɔ hele yɩ́ kɛ: “Simʋn, man n gán ɛjɔlɛ kʋn n géle wɔ́.” Simʋn nwan: “Kpain, kan.” ");
INSERT INTO any_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Zozi nwan: “Anɩn menian nnyuan tua sʋanlan kʋn kalɛ. Nunhan kʋn tua jɛtɛ fufue mma ɛya nnun, yɛ̂ kʋn'n kʋsʋ tua jɛtɛ fufue mma abulanun. ");
INSERT INTO any_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Kɛmɔ bɛ́ menian nnyuan'n nun bie fɩ́ɩ́ ngʋala man yɩ́ kalɛ'n tua'n, sʋanlan'n m'ɔ bɔlɩ bɛ bʋsɩa'n kɔ fa kɔ hye bɛ́. Menian nnyuan sɔ'n, nunhan benin yɛ̂ ɛ de di kɛ ɔ 'kulo bian'n bʋ sʋ ɔ?” ");
INSERT INTO any_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simʋn kɔ bua yɩ́ kɛ: “Mɩn de mɩn di kɛ nunhan mɔ yɩ́ kalɛ dɩɛ'n tɩ kpili nɩn ɔ.” Zozi nwan: “Mɔ a han'n tɩ ananhɔlɛ.” ");
INSERT INTO any_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","M'ɔ hanlɩn sɔ'n, ɔ kɔ fa balasua'n kɔ hele Simʋn, yɩ́ nwan: “Simʋn, a nwun balasua ɛhɩ? Kɛ m malɩ wɔ́ awulo ɛwa'n, a mman man mɩ́n nzue m'an nwunnzin man mɩ́n ja nɩn anwʋn. Nan balasua ɛhɩ dɩɛ, ɔ le yɩ́ nyɩn ɛmʋɩn'n ɔ'a nwunnzin mɩ́n ja nɩn anwʋn, ɔ'a fa yɩ́ ti enyuan'n ɔ'a cici. ");
INSERT INTO any_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","N juli ɛwa'n, a ndɔ man mɩ́n nun. Nan yɩ́ dɩɛ, kɛ n wʋlʋlɩ ɛwa nɩn angʋnmɩn yɛ̂ ɔ falɩ mɩ́n ja'n-mɔ bɔlɩ yɩ́ hue sʋ ɔ. ");
INSERT INTO any_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","A ngua man ngo m'ɔ ban fanlan mɩ́n ti nɩn asʋ. Nan yɩ́ dɩɛ, anatɩlɩ kpa yɛ̂ ɔ'a fa ɔ'a gugua mɩ́n ja nɩn anwʋn ɔ. ");
INSERT INTO any_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Yɩ́ sɔ ati, mɩɩn kan mɩn kele wɔ́ kɛ balasua ɛhɩ, ehulo kpili'n mɔ ɔ'a hulo mɩ́n'n dunman nun, yɩ́ ɛtɛ'n kʋalaatin, yɩ́ ɛtɛ bobolobe'n kʋalaa m'ɔ sʋ'n, b'a fa yɩ́ kʋalaa b'a hye yɩ́. Nan sʋanlan mɔ yɩ́ ɛtɛ nɩn a nzʋn man mɔ bɛ kɔ fa bɛ kɔ hye yɩ́'n, ehulo'n m'ɔ le yɩ́'n tɩ kaan sʋa.” ");
INSERT INTO any_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Ɛhɩ a, Zozi kɔ han kɔ hele balasua'n kɛ: “B'a fa wɔ́ ɛtɛ'n-mɔ b'a hye wɔ́.” ");
INSERT INTO any_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Mɔ Zozi hanlɩn sɔ'n, bɛ́ mɔ bɛ́ nʋn yɩ́ gua tɔbɩlɩ nɩn anwʋn'n kɔ han yɩ́ bɛ́ ti anun kɛ: “Sʋanlan ɛhɩ muonun ɔ tɩ yɩ́ dɩɛ sɛ dede m'ɔ fa sʋanlan ɛtɛ ce yɩ́ ɔ?” ");
INSERT INTO any_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Mɔ bɛ 'kan sɔ bɛ́ ti anun'n, Zozi kɔ han kɔ hele balasua'n kɛ: “Wɔ́ dedi nɩn a le wɔ́ ngʋan, kɔ alʋacɩcɩɛ nun.” ");
INSERT INTO any_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Ɛhɩ anzin, Zozi nʋn yɩ́ menian bulu nʋn nnyuan'n, bɛ kɔ hɔ kulo kulo'n-mɔ asʋ. Bɛ kɔ hɔ kɔ han Nyanmɩan Anʋan Ɛjɔlɛ'n. Bɛ kɔ bɔ Nyanmɩan Belemgbin Mân nɩn anwʋn Ɛjɔlɛkpa'n bɛ kɔ hele menian'n-mɔ. ");
INSERT INTO any_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Zozi 'kɔ a, anɩn mmalasua mmie-mɔ m'ɔ tuli bɛ́ nun wawɛ ɛtɛ'n-mɔ ɔ man bɛ nwʋn salɩ'n si yɩ́ sʋ. Mmalasua sɔ'n-mɔ y'ɔ le: Mali m'ɔ fi Magɩdala mɔ Zozi tulɩ wawɛ ɛtɛ nsʋ yɩ́ nun'n. ");
INSERT INTO any_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Kuza m'ɔ nɩan belemgbin *Elɔdɩ Antɩpasɩ ninnge nɩn asʋ'n, yɩ́ yɩ Zʋanɩn. Suzanɩn nʋn mmalasua mmiekun-mɔ dɔʋn kpa. Bɛ fa bɛ́ anwʋndɩɛ'n bɛ bʋa Zozi nʋn yɩ́ menian'n-mɔ. ");
INSERT INTO any_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Menian'n-mɔ fi kulo kulo'n-mɔ asʋ bɛ kɔ a Zozi anwʋn ɛbɛlɛ. Nan mɔ menian dɔʋn yialɩ yɩ́ nwʋn'n, ɔ kɔ bu anyɩnndala ɛhɩ ɔ kɔ hele bɛ́. Yɩ́ nwan: ");
INSERT INTO any_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Anɩn sʋanlan kʋn wɔ ɛbɛlɛ. Cɩan kʋn, ɔ kɔ hɔ *bele egua yɩ́ ebo nɩn asʋ. Bele mma'n bie kɔ gua atɩn nɩn anʋan. Menian'n-mɔ 'sɩn an, bɛ tetia sʋ. Nnʋnman'n-mɔ kɔ suso kɔ li. ");
INSERT INTO any_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Bie kʋsʋ kɔ gua ɛbʋta nɩn asʋ. Kɛmɔ ngɛtɩɛ kpa nnʋn man ɛbɛlɛ'n, bele'n fifili a, ɔ kɔ yala. ");
INSERT INTO any_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Bie kʋsʋ kɔ gua eminlan mmowe'n-mɔ anun, bɛ nʋn bɛ́ bɛ kɔ fifi nun kʋn. Eminlan mmowe'n-mɔ kɔ fʋ sʋ. Ɔ'a man ɔ'a nyɔ man kpa. ");
INSERT INTO any_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Bie kʋsʋ kɔ gua asɩɛ kpa nɩn asʋ. Ɔ kɔ fifi ɔ kɔ su mma dɔʋn kpa. Bele baka kʋn biala kɔ su mma ɛya kʋn.” Ɛsɛ Zozi kɔ han kɔ tʋ sʋ kɛ: “Sʋanlan m'ɔ sɩ fasie'n, ɔ fá síe!” ");
INSERT INTO any_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Yɩ́ menian'n-mɔ kɔ bisa yɩ́ anyɩnndala sɔ nɩn abʋ. ");
INSERT INTO any_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Zozi kɔ bua bɛ́ kɛ: “Ɛmɔ dɩɛ, nvɩalɩɛ nun ɛjɔlɛ'n m'ɔ tʋ de Nyanmɩan Belemgbin Mân'n, Nyanmɩan a yɩ a hele ɛmɔ. Nan menian bʋ nga'n-mɔ dɩɛ, bɛ bu yɩ́ anyɩnndala nun bɛ kele bɛ́. Ɔ man bɛ nɩan yɩ́ bɛ́ nyɩnsʋ bɔbɔ a, bɛ nnwun man yɩ́. Bɛ tie bɔbɔ a, bɛ ndɩ man yɩ́ bʋ. ");
INSERT INTO any_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Anyɩnndala ɛhɩ, yɩ́ bʋ y'ɔ le kɛ: *Bele mma'n y'ɔ le Nyanmɩan Anʋan Ɛjɔlɛ'n. ");
INSERT INTO any_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Menian'n mmie-mɔ tɩ kɛ atɩn nɩn anʋan'n mɔ bele mma'n gualɩ'n. Bɛ tie Nyanmɩan Anʋan Ɛjɔlɛ'n, nan kʋsʋ Abɔnsanmʋn ba ɔ yɩ ɛjɔlɛ'n mɔ b'a tɩ'n fi bɛ́ ahʋnlɩn nɩn anun. Ɔ man bɛ nnyan man dedi nán b'a nyan ngʋan. ");
INSERT INTO any_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Mmie-mɔ kʋsʋ tɩ kɛ ɛbʋta'n mɔ bele'n gualɩ sʋ'n. Bɛ tɩ Nyanmɩan Anʋan Ɛjɔlɛ nɩn an, bɛ di yɩ́ nwʋn fɛ. Nan kʋsʋ bɛ mman man ɛjɔlɛ'n nzɔ man ndɩan. Bɛ de bɛ di mɛlɛ kaan sʋa yɛ̂ sɛ emian bie tʋ bɛ́ a, anɩn b'a yaci bɛ́ dedi'n b'a tʋ. ");
INSERT INTO any_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Bele'n m'ɔ gualɩ eminlan mmowe nɩn anun'n, y'ɔ le menian mɔ bɛ tie Nyanmɩan Anʋan Ɛjɔlɛ'n, nan kʋsʋ ɔ 'kɔ yɩ́ nyunnun an, bɛ man nzusue, anwʋndɩɛ nʋn mân elie fʋ Nyanmɩan Anʋan Ɛjɔlɛ'n mɔ b'a tɩ nɩn asʋ. Bɛ nzu man mma dede ɔ mmʋlʋ man. ");
INSERT INTO any_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Bele mma'n m'ɔ gualɩ asɩɛ kpa nɩn asʋ'n, y'ɔ le menian mɔ bɛ tie Nyanmɩan Anʋan Ɛjɔlɛ'n, bɛ fa bɛ sie bɛ́ ahʋnlɩn nɩn anun kpa, bɛ di ɛjɔlɛ nɩn asʋ, bɛ su mma. ");
INSERT INTO any_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Sʋanlan fɩ́ɩ́ nzɔ man kanlannɩɛ, ɔ nva ɔ nwula man bokiti, anaan mgba abʋ. Nan ɔ sie yɩ́ kanlannɩɛ'n baka nɩn asʋ, ɔ man bɛ́ mɔ bɛ 'wʋlʋ sua nɩn anun'n, bɛ nwun asɩ. ");
INSERT INTO any_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Like biala m'ɔ fɩa'n, ɔ 'tu fite. Nvɩalɩɛ nun ɛjɔlɛ biala 'fite jawe nun. ");
INSERT INTO any_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Ɛmɔ yɔ́ anzʋɛ, nán bɛ tíe yɩ́ kpa! Ɔ sanlɩn kɛ m'ɔ le kaan'n, bɛ 'ba man yɩ́ biekun. Nan m'ɔ le man fɩ́ɩ́'n, kaan'n m'ɔ susu kɛ ɔ kɔ nyan yɩ́'n, bɛ 'tʋa yɩ́ bɛ de.” ");
INSERT INTO any_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Zozi anin'n nʋn yɩ́ nianman'n-mɔ, bɛ kɔ a bɛ kɔ tʋ yɩ́. Nan kʋsʋ meninsʋnman'n mɔ b'a yia yɩ́ nwʋn nɩn ati, ɔ man b'a ngʋala man yɩ́ nwʋn ɛlɔ ju. ");
INSERT INTO any_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Bɛ kɔ bɔ Zozi amannɩɛ kɛ: “Wɔ́ nin nʋn wɔ́ nianman'n-mɔ jijin ahanmɩan ɛlɔ, bɛ kulo kɛ bɛ nwun wɔ́ nwʋn.” ");
INSERT INTO any_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Mɔ bɛ hanlɩn sɔ'n, nán Zozi a se bɛ́ mɔ bɛ wɔ ɛbɛlɛ'n kɛ: “Mɩ́n nin nʋn mɩ́n nianman'n-mɔ y'ɔ le menian mɔ bɛ tie Nyanmɩan Anʋan Ɛjɔlɛ'n, mɔ bɛ nanndɩ sʋ'n.” ");
INSERT INTO any_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Ɛlɛhʋn kʋn Zozi nʋn yɩ́ menian'n-mɔ kɔ fʋ ɛlɛɛ kʋn anun. Ɔ kɔ han kɔ hele bɛ́ kɛ: “Bɛ mán yɛ kpɛ́ asue'n yɛ hɔ́ yɩ́ nzin ɛlɔ ebue kʋn.” Mɔ Zozi hanlɩn sɔ'n, yɛ̂ bɛ hɔlɩ ɔ. ");
INSERT INTO any_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Nan mɔ bɛ 'kpɛ asue'n, anɩn Zozi la ɛlɛɛ nɩn anun ɔ lɛ dafɩ. Kʋnmgba ala, anwʋnman kpili kʋn kɔ tu asubula nɩn anyɩnsʋ. Asutue'n kɔ bɔ nzue kɔ gua ɛlɛɛ nɩn anun. ");
INSERT INTO any_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Ɛhɩ, yɩ́ menian'n-mɔ kɔ kpunnge yɩ́ bɛ kɔ tinnge yɩ́. Bɛ́ nwan: “Kpain, kpain, yɛ lɛ wu o!” Zozi kɔ tinnge ɔ kɔ jʋjɔ aminle sʋ kɔ hele anwʋnman'n nʋn asutue'n. Anwʋnman'n kɔ jinlan, asutue'n kɔ gua asɩ. Ɛbɛlɛ kɔ yɔ diin. ");
INSERT INTO any_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","M'ɔ yɔlɩ sɔ'n, Zozi kɔ bisa yɩ́ menian'n-mɔ kɛ: “Ɛmɔ dedi'n wɔ nin?” Ɛjɔlɛ'n kɔ sin bɛ́ nwʋn, esulo kɔ han bɛ́. Bɛ kɔ bisa bisa bɛ́ nwʋn kɛ: “Nwan sʋanlan dɩɛ y'ɔ le ɛhɩ? M'ɔ jʋjɔ kele anwʋnman nʋn asutue dede bɛ man yɩ́ anyɩnnzɔ!” ");
INSERT INTO any_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Zozi nʋn yɩ́ menian'n-mɔ, bɛ kɔ kpɛ Galile asue'n. Bɛ kɔ hɔ kɔ ju yɩ́ nzin ɛlɔ ebue kʋn, Zelazɩ'n-mɔ mân nɩn anun. Mân sɔ'n nʋn Galile mân'n, bɛ́ nyɩn'n wɔ sʋ. ");
INSERT INTO any_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Mɔ Zozi 'ju asɩ nɩn ala, kulo nɩn asʋ sʋanlan kʋn kɔ a yɩ́ nwʋn ɛbɛlɛ. Sʋanlan sɔ'n, wawɛ ɛtɛ wɔ yɩ́ nun. Yɩ́ nwʋn gua sʋ, nán ɛnɛ bie ɔ. Ɔ nna man sua ɛlɔ. Ɔ la asielɩɛ'n-mɔ asʋ. ");
INSERT INTO any_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","M'ɔ nwunlin Zozi'n, ɔ kɔ tɩan. Ɔ kɔ hɔ kɔ tu kɔ tɔ yɩ́ ja nun. Ɔ kɔ tɩan sɛlɛ kpa, Yɩ́ nwan: “Zozi, Anwunno Nyanmɩan Kpili Awa, ɛ se mɩ́n sɛ? Mɩn 'sɛlɛ wɔ́, n'ɛ se mɩ́n sa fɩ́ɩ́.” ");
INSERT INTO any_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","M'ɔ man ɔ lɛ kan sɔ'n, y'ɔ le kɛ Zozi lɛ man wawɛ ɛtɛ'n m'ɔ wɔ yɩ́ nun'n tu. Wawɛ ɛtɛ'n tɔ yɩ́ sʋ mɛlɛ'n bie anun. Bɛ fa ngɔnzɔngɔnzɔ bɛ cɩ yɩ́ sa nʋn yɩ́ ja a, ɔ bubu nun. Wawɛ ɛtɛ'n cʋɩn yɩ́ kɔ ɛwâ nɩn anun. ");
INSERT INTO any_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Zozi kɔ bisa yɩ́ kɛ: “Ɛ li sɛ?” Yɩ́ nwan: “Bɛ fɛlɛ mɩ́n nwala nwala.” Afɩ wawɛ ɛtɛ dɔʋn kpa wɔ yɩ́ nun, yɩ́ ti yɛ̂ ɔ man ɔ lɛ kan sɔ ɔ. ");
INSERT INTO any_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Wawɛ ɛtɛ sɔ'n-mɔ kɔ sɛlɛ Zozi kɛ n'ɔ man bɛ kɔ gua kunman kpʋnlʋn-mgbʋnlʋn nɩn anun. ");
INSERT INTO any_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Ɛbɛlɛ lɩka sɔ'n, anɩn mgbolike dɔʋn kpa lɛ didi bʋka nɩn asʋ. Wawɛ ɛtɛ'n-mɔ kɔ bʋtʋ Zozi kɛ ɔ mán bɛ́ atɩn maan bɛ hɔ́ wʋ́lʋ mgbolike sɔ'n-mɔ anun. Mɔ sʋanlan'n hanlɩn sɔ'n, Zozi kɔ man bɛ́ atɩn. ");
INSERT INTO any_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Wawɛ ɛtɛ'n-mɔ fi sʋanlan nɩn anun bɛ kɔ fite. Bɛ kɔ hɔ kɔ wʋlʋ mgbolike'n-mɔ anun. Mgbolike fatule kʋn'n kɔ tʋlʋ bʋka'n bɛ kɔ hɔ kɔ gua asue nɩn anun, bɛ́ kʋalaa bɛ kɔ nʋan. ");
INSERT INTO any_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Mɔ bɛ́ mɔ bɛ nɩan mgbolike'n-mɔ asʋ'n nwunlin yɩ́ sɔ'n, bɛ kɔ nwanndi. Bɛ kɔ hɔ kɔ bɔ ɛjɔlɛ sɔ'n kpayɛ kulo, ɔ nʋn nanmue'n-mɔ asʋ. ");
INSERT INTO any_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Bɛ́ mɔ bɛ tɩlɩ ɛjɔlɛ sɔ'n, bɛ walɩ nɩanlɩn kɛ ɔ kpɩnlɩn yɔlɩ'n. Bɛ 'ba ju Zozi anwʋn ɛbɛlɛ a, sʋanlan'n mɔ anɩn wawɛ ɛtɛ'n-mɔ wɔ yɩ́ nun nɩn anyɩnsʋ a tɩ. Ɔ wula taladɩɛ ɔ tɩ Zozi aja abʋ ɛbɛlɛ. Mɔ bɛ nwunlin yɩ́ sɔ'n, esulo hanlɩn bɛ́. ");
INSERT INTO any_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Kɛ ɔ kpɩnlɩn yɔlɩ mɔ wawɛ ɛtɛ'n-mɔ fi sʋanlan nɩn anun bɛ fitelɩ, mɔ bɛ hɔlɩ wʋlʋlɩ mgbolike'n-mɔ anun, mɔ bɛ 'kɔ a gua asue nɩn anun, mɔ bian nɩn anyɩnsʋ tɩ'n, bɛ́ mɔ bɛ nwunlin yɩ́ bɛ́ nyɩnsʋ'n kɔ han yɩ́ kʋalaa kɔ hele sian mma'n-mɔ. ");
INSERT INTO any_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Zelasɩ mân nɩn anun menian'n-mɔ kʋalaa kɔ sɛlɛ Zozi kɛ ɔ fi bɛ́ mân nɩn anun ɔ jásʋ. Ɔ sanlɩn kɛ anɩn esulo kpili kpa a han bɛ́. Mɔ Zozi fʋlɩ ɛlɛɛ nɩn anun mɔ ɔ 'sa kɔ Galile'n, ");
INSERT INTO any_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","sʋanlan'n mɔ wawɛ ɛtɛ'n fi yɩ́ nun tuli'n kɔ sɛlɛ Zozi kɛ ɔ 'si yɩ́ sʋ. Zozi nwan: ");
INSERT INTO any_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Sa kɔ wɔ́ awulo, nán kɔ han yɩ́ kʋalaa mɔ Nyanmɩan a yɔ a man wɔ́'n kele menian'n-mɔ.” Bian'n kʋsʋ kɔ hɔ ɔ kɔ han yɩ́ kʋalaa mɔ Zozi a yɔ a man yɩ́'n kɔ hele kulo bɔndɩn'n. ");
INSERT INTO any_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Mɔ Zozi fi Galile asue nɩn anzin ɛlɔ ɔ 'sa ba'n, menian dɔʋn kpa kɔ a yɩ́ atɩn ele. Ɔ sanlɩn kɛ bɛ́ kʋalaa bɛ́ nyɩn jin yɩ́ atɩn. ");
INSERT INTO any_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Kaan cɛ, Zufʋ'n-mɔ asɔnɩn sua nɩn asʋ kpain'n kɔ a, kpain sɔ'n, bɛ fɛlɛ yɩ́ Zʋayilusɩ. Ɔ kɔ tu kɔ tɔ Zozi aja nun ɔ kɔ sɛlɛ yɩ́ kɛ ɔ bála yɩ́ awulo ɛlɔ. ");
INSERT INTO any_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Ɔ sanlɩn kɛ yɩ́ wa balasua kʋnmgba cein'n mɔ ɔ'a li afʋɛ bulu nʋn nnyuan'n, ɔ lɛ de ewue wu. Mɔ bian'n hanlɩn sɔ'n, Zozi kɔ tie. Mɔ bɛ 'kɔ'n, menian dɔʋn si bɛ́ sʋ, anɩn bɛ 'kan Zozi bɛ mian bɛ́ afian. ");
INSERT INTO any_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Ɔ 'ba yɔ sɔ'n, anɩn balasua kʋn wɔ menian'n-mɔ afian ɛbɛlɛ. Moja tu balasua sɔ'n yɩ́ afʋɛ bulu ɔ nʋn nnyuan ahɩ. Ɔ kɔ sɛcɩ yɩ́ nwʋn esika kʋalaatin wɔ ayile ɛyɔlɛfʋɛ'n-mɔ ɛlɔ. Nan kʋsʋ yɩ́ nwʋn a nza man. ");
INSERT INTO any_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Ɔ li Zozi anzin, ɔ kɔ han yɩ́ taladɩɛ nɩn anʋan'n. Ɛbɛlɛ ala, moja'n m'ɔ tu yɩ́'n kɔ kpɛ. ");
INSERT INTO any_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Zozi kɔ bisa menian'n-mɔ kɛ: “Nwan yɛ̂ ɔ'a han mɩ́n taladɩɛ'n?” Ɛhɩ nwan “Nán mɩ́n ɔ!” Ɛhɩ nwan: “Nán mɩ́n ɔ!” Pɩɛlɩ nwan: “Kpain, a nwun kɛ menian'n-mɔ lɛ kan wɔ́ mian bɛ afian, kʋsʋ anɩn ɛ lɛ bisa ɛjɔlɛ sʋa!” ");
INSERT INTO any_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Mɔ Pɩɛlɩ hanlɩn ɛhɩ'n, Zozi nwan: “Sʋanlan bie a han mɩ́n, ɔ sanlɩn kɛ m'an nwun kɛ anwʋnsɛlɛ kʋn fi mɩ́n nun ɔ'a fite.” ");
INSERT INTO any_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Balasua'n kɔ nwun nun kɛ b'a hyɩ yɩ́. Ɛhɩ a, yɩ́ nwʋn kɔ wʋsʋ yɩ́ ɔ kɔ tu kɔ tɔ Zozi aja nun. Menian'n-mɔ kʋalaa anyunnun ɛbɛlɛ, like mɔ yɩ́ ti yɛ̂ ɔ man ɔ hanlɩn Zozi taladɩɛ'n, ɛsɛ kɛ ɔ kpɩnlɩn yɔlɩ mɔ yɩ́ nwʋn salɩ ɛbɛlɛ ala'n, ɔ kɔ han yɩ́ kʋalaa. ");
INSERT INTO any_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Mɔ yɩ́ nʋan tɔlɩ'n, Zozi nwan: “Mɩ́n wa balasua, kɔ anzʋnunjɔ nun, nán wɔ́ dedi nɩn a man wɔ́ nwʋn a sa.” ");
INSERT INTO any_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Anɩn Zozi anʋan tɛ wɔ ɛjɔlɛ sʋ. Bɔfʋɛ kʋn fi kpain Zʋayilusi awulo ɛlɔ walɩ a, yɩ́ nwan: “Zʋayilusi, wɔ́ wa nɩn a wu, yɩ́ ti n'ɛ jɩjɩ kpain kʋ́n.” ");
INSERT INTO any_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Mɔ Zozi tɩlɩ ɛjɔlɛ sɔ'n, ɔ kɔ han kɔ hele Zʋayilusi kɛ: “Zʋayilusi, gua wɔ́ ahʋnlɩn asɩ, nyan dedi ala, nán wɔ́ wa balasua'n, ɔ 'ba hɩn.” ");
INSERT INTO any_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Mɔ bɛ juli awulo ɛbɛlɛ'n, Zozi ngɔ man sʋanlan fɩ́ɩ́ atɩn kɛ ɔ wʋ́lʋ lɩka mɔ batʋnman'n la'n bie, sannan Pɩɛlɩ nʋn Zʋan, nʋn Zʋakɩ, nʋn sɩɛ'n nʋn nian'n mɔ bɛ le baa nɩn ala. ");
INSERT INTO any_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Bɛ́ kʋalaa bɛ lɛ di batʋnman nɩn anwʋn yalɛ, bɛ le sun. Mɔ Zozi nwunlin yɩ́ sɔ'n, yɩ́ nwan: “Ɛmɔ yáci esuan'n nán batʋnman'n wuli man, ɔ lɛ dafɩ.” ");
INSERT INTO any_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Mɔ Zozi hanlɩn sɔ'n, bɛ́ kʋalaa bɛ kɔ gʋlʋ yɩ́ nwʋn. Ɔ sanlɩn kɛ bɛ́ dɩɛ, bɛ sɩ yɩ́ fɔ́ʋ́n kɛ talua nɩn a wu. ");
INSERT INTO any_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Ɛhɩ a, Zozi kɔ sɔ batʋnman nɩn asa, ɔ kɔ tɩan nun. Yɩ́ nwan: “Batʋnman, jasʋ!” ");
INSERT INTO any_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Batʋnman'n kɔ tinnge, ɛbɛlɛ ala ɔ kɔ jasʋ. Zozi nwan: “Bɛ mán yɩ́ like lí.” ");
INSERT INTO any_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Ɛjɔlɛ'n kɔ sin sɩɛ'n nʋn nian nɩn anwʋn. Zozi tualɩ bɛ́ kɛ nán bɛ kan like mɔ b'a nwun yɩ́ nɩn anwʋn ɛjɔlɛ bɛ kele sʋanlan fɩ́ɩ́. ");
INSERT INTO any_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Ɛhɩ cɩan kʋn Zozi yialɩ yɩ́ menian bulu nʋn nnyuan nɩn an, ɔ kɔ man bɛ́ tunmin kɛ bɛ fʋ́an wawɛ ɛtɛ'n-mɔ, ɛsɛ bɛ mán nwuluwafʋɛ'n-mɔ anwʋn sá. ");
INSERT INTO any_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Ɔ kɔ sʋan bɛ́ kɛ bɛ hɔ́ bɔ́ Nyanmɩan Belemgbin Mân'n kpayɛ, ɛsɛ bɛ mán bɛ́ mɔ b'a fʋkɛ'n tɩ́ akpɔlɛ. ");
INSERT INTO any_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Ɔ kɔ han kɔ hele bɛ́ kɛ: “Ɛmɔ ɛhɔlɛ'n mɔ bɛ lɛ kɔ'n, nán bɛ fa like fɩ́ɩ́ bɛ sa bɛ́ nwʋn. Nán bɛ fa kpɔman, nán bɛ fa bɔ́lɛ, nán bɛ fa alɩɛ, nán bɛ fa esika, ɛsɛ nán bɛ fa taladɩɛ nnyuan. ");
INSERT INTO any_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Awulo mɔ ɛmɔ kɔ sike nun'n, ɛmɔ tánlan nun ɛbɛlɛ dede ɔ jú ɛmɔ ɛhɔlɛ cɩan. ");
INSERT INTO any_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Kulo kʋsʋ mɔ ɛmɔ kɔ hɔ sʋ mɔ b'a nne man ɛmɔ'n, ɛmɔ kpɔ́kpala bɛ́ ja nɩn abʋ anyʋan'n bɛ gúa ɛbɛlɛ bɛ hɔ́. Ɔ tɩ adanzɩɛ elie kɛ bɛ ngʋala man ɛmɔ sʋnmʋɛ bɔ.” ");
INSERT INTO any_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Mɔ Zozi hanlɩn sɔ yuelɩ'n yɛ̂ yɩ́ menian bulu nʋn nnyuan'n hɔlɩ ɔ. Bɛ hɔlɩ bɔlɩ Ɛjɔlɛkpa'n bɛ helelɩ menian'n-mɔ ɛsɛ bɛ manlɩn nwuluwafʋɛ'n-mɔ anwʋn salɩ. ");
INSERT INTO any_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Ɛhɩ *Elɔdɩ m'ɔ tɩ Galile mân nɩn asʋ belemgbin'n kɔ tɩ yɩ́ kʋalaa mɔ Zozi nʋn yɩ́ menian'n-mɔ a yɔ'n. Ɔ nnwun man m'ɔ jʋnlɩn ɔ, ɔ sanlɩn kɛ menian mmie-mɔ lɛ kele kɛ Zʋan Batisi m'ɔ wuli'n yɛ̂ ɔ'a hɩn nɩn ɔ. ");
INSERT INTO any_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Mmie-mɔ nwan: “Nyanmɩan kpɔmanfʋɛ Eli yɛ̂ ɔ'a fite ɔ.” Mmie-mɔ kʋsʋ nwan: “Daba Nyanmɩan mgbɔmanfʋɛ'n-mɔ mɔ bɛ wuli'n, bɛ́ nunhan kʋn yɛ̂ ɔ'a hɩn nɩn ɔ.” ");
INSERT INTO any_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Nan mɔ Elɔdɩ tɩlɩ yɩ́ sɔ'n, yɩ́ nwan: “M'an man b'a kpɛ Zʋan ati'n. Nan nwan sʋanlan dɩɛ yɛ̂ bɛ lɛ kan yɩ́ ɛjɔlɛ sʋa'n?” Ɛhɩka ati, ɔ kulo kɛ ɔ nwun Zozi. ");
INSERT INTO any_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Ɛhɩ Zozi mmɔfʋɛ bulu nʋn nnyuan'n hɔlɩ walɩ a, bɛ kɔ han mɔ bɛ yɔlɩ'n kʋalaa bɛ kɔ hele yɩ́. Mɔ bɛ bɔlɩ amannɩɛ yuelɩ'n, Zozi nʋn bɛ́ bɛ kɔ tɩ bɛ́ nwʋn bɛ kɔ hɔ kulo'n mɔ bɛ fɛlɛ yɩ́ Bɛtɩsayida nɩn asʋ. ");
INSERT INTO any_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Meninsʋnman'n kɔ nwun nun bɛ kɔ si bɛ́ sʋ. Zozi kɔ sɔ bɛ́ nun, ɔ kɔ han Nyanmɩan Belemgbin Mân nɩn anun ɛjɔlɛ ɔ kɔ hele bɛ́. Bɛ́ mɔ bɛ ndɩ man akpɔlɛ mɔ bɛ kulo kɛ bɛ tɩ akpɔlɛ'n, ɔ kɔ man bɛ kɔ tɩ akpɔlɛ. ");
INSERT INTO any_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Kɛmɔ anɩn alɩ́ɛ lɛ san'n, yɩ́ menian bulu nʋn nnyuan'n kpunngelɩ yɩ́ a, bɛ́ nwan “Kpain, lɩka mɔ yɛ wɔ'n tɩ fuaan. Yɩ́ ti, yaci menian'n-mɔ anun maan bɛ hɔ́ kpʋ́nndɛ alɩɛ nʋn dabɛlɛ kulo'n-mɔ nʋn nanmue'n-mɔ mɔ bɛ mantan mantan ɛwa'n-mɔ asʋ.” ");
INSERT INTO any_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Mɔ bɛ hanlɩn sɔ'n, Zozi kɔ bua bɛ́ kɛ: “Ɛmɔ muonun mán bɛ like lí!” Bɛ́ nwan: “Like mɔ yɛ le yɩ́ ɛwa nɩn ala y'ɔ le kpaʋn nnun'n ɔ nʋn ejue nnyuan'n. Sɛ kʋsʋ ɛ kulo kɛ yɛ hɔ́ tó alɩɛ yɛ bɛ́lɛ meninsʋnman ɛhɩ a?” ");
INSERT INTO any_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","(Menian mɔ b'a yia ɛbɛlɛ'n, bɛ ju menian akpɩɩ nnun.) Zozi kɔ han kɔ hele yɩ́ menian'n-mɔ kɛ: “Ɛmɔ mán bɛ tɛ́tanlan kpule abulanun abulanun.” ");
INSERT INTO any_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Yɩ́ menian'n-mɔ kɔ yɔ m'ɔ helelɩ bɛ́'n, bɛ kɔ man menian'n-mɔ kɔ tɛtanlan asɩ. ");
INSERT INTO any_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Ɛhɩ, Zozi kɔ le kpaʋn nnun'n ɔ nʋn ejue nnyuan'n. Ɔ kɔ tʋ yɩ́ nyɩn anwunno, ɔ kɔ la Nyanmɩan asɩ. Ɔ kɔ hye kɔ man yɩ́ menian'n-mɔ kɛ bɛ́ kʋsʋ bɛ hyé bɛ mán meninsʋnman'n. ");
INSERT INTO any_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Menian nwala ɛhɩ, bɛ́ kʋalaa bɛ kɔ li dede bɛ́ kʋ kɔ yi. Yɩ́ bʋ'n mɔ halɩ'n ɔ tɩ ece mma bulu nʋn nnyuan. ");
INSERT INTO any_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Cɩan kʋn Zozi kɔ tɩ yɩ́ nwʋn ɔ kɔ hɔ asɔnɩn ɛyɔlɛ, yɩ́ menian'n-mɔ kɔ kpʋ yɩ́. Zozi kɔ bisa bɛ́ kɛ: “Menian'n-mɔ muonun, bɛ bu kɛ nwan sʋanlan dɩɛ y'ɔ le mɩ́n?” ");
INSERT INTO any_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Yɩ́ menian'n-mɔ nwan: “Mmie-mɔ nwan Zʋan Batisi y'ɔ le wɔ́. Mmie-mɔ kʋsʋ nwan *Eli y'ɔ le wɔ́. Mmiekun-mɔ nwan daba Nyanmɩan mgbɔmanfʋɛ'n-mɔ mɔ bɛ wuli'n, bɛ́ nunhan kʋn yɛ̂ ɔ'a hɩn nɩn ɔ.” ");
INSERT INTO any_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Zozi kɔ bisa bɛ́ kɛ: “Nan ɛmɔ kʋsʋ lɩlɩ, ɛmɔ bu kɛ nwan sʋanlan dɩɛ y'ɔ le mɩ́n?” Pɩɛlɩ jasʋlɩ a, yɩ́ nwan: “Kilisi'n, Belemgbin Ngʋandefʋɛ'n mɔ Nyanmɩan a sʋan yɩ́'n y'ɔ le wɔ́.” ");
INSERT INTO any_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Mɔ Pɩɛlɩ hanlɩn sɔ'n, Zozi kɔ totua bɛ́ kɛ nán bɛ kan bɛ kele sʋanlan fɩ́ɩ́. ");
INSERT INTO any_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Ɔ kɔ han kɔ tʋ sʋ kɛ: “Ɔ di kɛ Mân Baa'n nwun amannɩɛ kpa. Izalayɛ mân nɩn anun mgbain'n-mɔ, nʋn Nyanmɩan tɛɛyɩfʋɛ mgbain'n-mɔ ɔ nʋn mala nɩn asʋ mgbain'n-mɔ, bɛ 'ba yɩ yɩ́ bɛ tʋ. Bɛ 'ba hun yɩ́. Bɛ kun yɩ́ a, yɩ́ cɩan nsan nɩn asʋ ɔ 'tinnge.” ");
INSERT INTO any_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Ɛhɩ anzin, Zozi kɔ han kɔ hele bɛ́ kʋalaa kɛ: “Sʋanlan m'ɔ kulo kɛ ɔ si mɩ́n sʋ'n, n'ɔ susu yɩ́ ti ɔ gua yɩ́ nwʋn sʋ. Nan alɩhɩan biala, ɔ fá yɩ́ kʋlʋwa'n ɔ tʋ́ yɩ́ kɔmɩn sʋ, nán ɔ sí mɩ́n sʋ. ");
INSERT INTO any_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Ɔ sanlɩn kɛ sʋanlan m'ɔ kulo kɛ ɔ kpʋnndɛ yɩ́ ngʋan'n, ɔ 'wu. Nan sʋanlan m'ɔ kɔ hulo mɩ́n ɔ kɔ wu wɔ mɩ́n dunman nun'n, sʋanlan sɔ'n, ɔ 'nyan ngʋan. ");
INSERT INTO any_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Sɛ sʋanlan kʋn nyan mân nɩn anun ninnge'n kʋalaatin, nan sɛ ɔ le man ngʋan an, anɩn nzu nvasʋɛ dɩɛ yɛ̂ ɔ 'nyan yɩ́ sʋ ɔ? ");
INSERT INTO any_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Sʋanlan m'ɔ kɔ sa mɩ́n nʋn mɩ́n Nʋan Ɛjɔlɛ nɩn anwʋn nyian'n, mɛlɛ mɔ Mân Baa'n 'ba a yɩ́ anunminnyanmʋn'n ɔ nʋn Sɩɛ'n nʋn yɩ́ anwʋntɩɛ mmɔfʋɛ'n-mɔ anunminnyanmʋn nɩn anun'n, ɔ 'sa sʋanlan sɔ nɩn anwʋn nyian. ");
INSERT INTO any_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Mɩɩn kan yɩ́ ananhɔlɛ mɩn kele ɛmɔ kɛ menian ɛhɩ-mɔ mɔ b'a yia ɛwa'n, bɛ́ kʋalaa bɛ ngo yue man wu, mmie-mɔ 'nwun Nyanmɩan Belemgbin Mân'n bɛ́ nyɩnsʋ.” ");
INSERT INTO any_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Mɔ Zozi hanlɩn ɛjɔlɛ sɔ'n, yɩ́ nzin mɔlɛ kʋn, ɔ nʋn Pɩɛlɩ nʋn Zʋan nʋn Zʋakɩ, bɛ kɔ fʋ bʋka kʋn asʋ bɛ 'kɔ a yɔ asɔnɩn. ");
INSERT INTO any_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Mɔ bɛ 'yɔ asɔnɩn'n, Zozi anyɩn nɩn anun kɔ kaci. Yɩ́ taladɩɛ'n m'ɔ wula'n kɔ yɔ fufue hyɩɛɩn, m'ɔ wʋwɔ bɛ́ nyɩnsʋ ɔ. ");
INSERT INTO any_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Ɛbɛlɛ ala, menian nnyuan kɔ fite fite, bɛ nʋn Zozi lɛ jʋjɔ. Menian nnyuan sɔ'n-mɔ y'ɔ le *Moyizɩ nʋn *Eli. ");
INSERT INTO any_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Bɛ wɔ Nyanmɩan anunminnyanmʋn nɩn anun. Kɛ Zozi 'kpɩn di yɩ́ junman'n dede mɔ ɔ 'fa wu Zoluzalɛmʋn kulo nɩn asʋ'n, yɩ́ nwʋn ɛjɔlɛ yɛ̂ anɩn bɛ lɛ kan ɔ. ");
INSERT INTO any_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Nafɛlɛ kɔ hun Pɩɛlɩ nʋn yɩ́ manngʋn'n-mɔ. Nan mɔ bɛ tinngelɩ'n, bɛ kɔ nwun Zozi anunminnyanmʋn'n nʋn menian nnyuan'n m'ɔ nʋn bɛ́ bɛ jijin ɛbɛlɛ'n. ");
INSERT INTO any_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Mɛlɛ mɔ menian nnyuan'n 'yaci Zozi ɛbɛlɛ bɛ kɔ'n, Pɩɛlɩ kɔ han kɔ hele Zozi kɛ: “Kpain, ɔ tɩ kpa kɛ yɛ wɔ ɛwa. Yɩ́ ti yɛ 'bɔ tantɩ nsan. Wɔ́ dɩɛ kʋn, Moyizɩ dɩɛ kʋn, yɛ̂ Eli kʋsʋ dɩɛ kʋn.” (Pɩɛlɩ nnwun man ɛjɔlɛ'n m'ɔ lɛ kan nɩn anun). ");
INSERT INTO any_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Mɛlɛ m'ɔ 'kan ɛhɩ'n, bɔlɛ́ kʋn kɔ a kɔ hala bɛ́ sʋ. Mɔ Zozi menian'n-mɔ nwunlin kɛ bɔlɛ́ nɩn a hala bɛ́ sʋ'n, esulo kɔ han bɛ́. ");
INSERT INTO any_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Bɔlɛ́ nɩn anun, bɛ kɔ tɩ anɩɛ bie. Anɩɛ sɔ'n nwan: “Sʋanlan ɛhɩ tɩ mɩ́n Wa, m'an yɩ yɩ́. Ɛmɔ tie yɩ́!” ");
INSERT INTO any_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Mɔ anɩɛ sɔ'n hanlɩn sɔ yuelɩ'n, bɛ ngɔ nwun man sʋanlan fɩ́ɩ́ kɛ Zozi angʋnmɩn ala. Yɩ́ menian'n-mɔ kɔ muan bɛ́ nʋan. Like mɔ bɛ nwunlin yɩ́ mɛlɛ sɔ nɩn anun'n, bɛ ngɔ bɔ sʋ bɛ ngɔ hele man sʋanlan fɩ́ɩ́. ");
INSERT INTO any_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Ɛhɩ anzin, alɩ́ɛ hɩnlɩn mɔ bɛ fi bʋka nɩn asʋ bɛ juli'n, menian dɔʋn kpa kɔ a kɔ kpa Zozi atɩn. ");
INSERT INTO any_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Ɛbɛlɛ ala sʋanlan kʋn kɔ tɩan menian'n-mɔ afian Yɩ́ nwan: “Kpain, mɩn 'sɛlɛ wɔ́ kpa, tʋ wɔ́ nyɩn nɩan mɩ́n wa'n, mɩ́n wa kʋnmgba cein'n! ");
INSERT INTO any_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Wawɛ bie tɔ yɩ́ sʋ. Ɔ tɔ yɩ́ sʋ ala, ɔ man ɔ tɛtɩan. Ɔ kpusu batʋnman'n sɛlɛ kpa. Ɔ man ɔ cuin ngɛsɛlɛ. Ɔ kele yɩ́ yalɛ. Ɛsɛ ɔ nyaci man yɩ́ nun fɔtɩlɩfɔ. ");
INSERT INTO any_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","M'an sɛlɛ wɔ́ menian'n-mɔ kɛ bɛ tú wawɛ ɛtɛ sɔ'n. Nan b'a mantan yɩ́ dede b'a ngʋala man yɩ́ tu.” ");
INSERT INTO any_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Zozi nwan: “Menian mɔ bɛ le man dedi, ati anun ɛtɛ mma! Mɩn nʋn ɛmɔ yɛ tánlan dede ɔ hɔ́ jú mɛlɛ benin? N zʋ́ ɛmɔ dede ɔ jú mɛlɛ benin? Fa wɔ́ wa'n bala ɛwa!” ");
INSERT INTO any_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Mɔ batʋnman'n 'cʋɩn kpunnge Zozi'n, wawɛ'n kɔ tʋ yɩ́ asɩ, ɔ kɔ kpusu yɩ́ sɛlɛ kpa. Nan m'ɔ yɔlɩ sɔ'n, Zozi kɔ jʋjɔ aminle sʋ kɔ hele wawɛ ɛtɛ'n. Zozi kɔ man batʋnman nɩn anwʋn kɔ sa ɔ kɔ fa yɩ́ ɔ kɔ man yɩ́ sɩ. ");
INSERT INTO any_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Ɛjɔlɛ'n kɔ sin bɛ́ kʋalaa bɛ́ nwʋn wɔ Nyanmɩan tunmin kpili nɩn anyunnun. Kɛmɔ Zozi ninnge'n kʋalaa mɔ yɔlɩ'n tɛ sin menian'n-mɔ anwʋn'n, ɔ kɔ han kɔ hele yɩ́ menian'n-mɔ kɛ: ");
INSERT INTO any_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Sian dɩɛ, ɛjɔlɛ'n mɔ mɩn 'ba han mɩn kele ɛmɔ'n, ɛmɔ fá bɛ síe kpa. Bɛ 'ba hyɩ *Mân Baa'n bɛ wula menian'n-mɔ asa nun.” ");
INSERT INTO any_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Yɩ́ menian'n-mɔ ngɔ tɩ man ɛjɔlɛ sɔ nɩn abʋ. Zozi ngɔ hehele man nun, ɔ man b'a ndɩ man yɩ́ bʋ. Kʋsʋ afɩ, bɛ ngɔ nyan man anwʋnsɛlɛ bɛ ngɔ bisa man yɩ́ ɛjɔlɛ sɔ nɩn anwʋn kosuan. ");
INSERT INTO any_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Akpʋlʋwa kʋn tɔlɩ Zozi menian'n-mɔ afian. Akpʋlʋwa sɔ'n y'ɔ le kɛ bɛ lɛ kpʋnndɛ sʋanlan m'ɔ tɩ kpili tala bɛ́ kʋalaa'n bɛ́ afian ɛbɛlɛ. ");
INSERT INTO any_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Mɔ bɛ 'su akpʋlʋwa sɔ'n, Zozi kɔ nwun mɔ anɩn bɛ lɛ jʋnlɩn'n. Ɛhɩ a, Zozi kɔ fa batʋnman kaan kʋn kɔ sie yɩ́ nwʋn ɛbɛlɛ, ");
INSERT INTO any_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","yɩ́ nwan: “Sʋanlan m'ɔ kɔ le batʋnman ɛhɩ mɩ́n dunman nun'n, anɩn mɩ́n muonun yɛ̂ ɔ'a le mɩ́n ɔ. Yɛ̂ sʋanlan kʋsʋ m'ɔ kɔ sɔ mɩ́n nun'n, anɩn ɔ'a sɔ sʋanlan'n m'ɔ sʋanlɩn mɩ́n nɩn anun. Ɔ sanlɩn kɛ sʋanlan m'ɔ tɩ kaan ɛmɔ kʋalaa afian ɛwa'n, yɩ́ yɛ̂ ɔ tɩ kpili tala yɩ́ manngʋn'n-mɔ ɔ.” ");
INSERT INTO any_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Zʋan jasʋlɩ a, yɩ́ nwan: “Kpain, y'a nwun bian kʋn kɛ ɔ lɛ fa wɔ́ dunman'n fʋan wawɛ ɛtɛ'n-mɔ, nan y'a totua yɩ́ kɛ nán ɔ yɔ sɔ kʋ́n. Ɔ sanlɩn kɛ ɔ nnʋn man yɛ́ nun bie.” ");
INSERT INTO any_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","M'ɔ hanlɩn sɔ'n, Zozi nwan: “Nán bɛ totua yɩ́, ɔ sanlɩn kɛ sʋanlan m'ɔ mgbɔ man ɛmɔ'n, anɩn ɔ nʋn ɛmɔ tɩ kʋn.” ");
INSERT INTO any_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Mɔ anɩn Zozi nyanmɩansʋ ɛhɔlɛ cɩan'n lɛ kpunnge'n, ɔ kɔ si yɩ́ hue kɛ ɔ 'kɔ Zoluzalɛmʋn. ");
INSERT INTO any_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Ɔ kɔ sʋan menian yɩ́ nyunnun. Bɛ kɔ hɔ kɔ ju Samali mân nɩn anun kulo kʋn asʋ. Bɛ 'kɔ a kpʋnndɛ lɩka mɔ bɛ 'sike ɔ. ");
INSERT INTO any_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Kulo sɔ nɩn asʋ menian'n-mɔ ngɔ sɔ man bɛ́ nun. Ɔ sanlɩn kɛ Zozi lɛ kpɛ nun ɛbɛlɛ ɔ kɔ Zoluzalɛmʋn. ");
INSERT INTO any_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Mɔ yɩ́ menian'n-mɔ Zʋan nʋn Zʋakɩ nwunlin yɩ́ sɔ'n, bɛ́ nwan: “Yɛ́ Mɩn, ɛ kulo kɛ yɛ man sɩ̂n fi anwunno ɔ tɔ kulo sɔ nɩn anun ɔ bɔ bɛ́ bʋsʋ ɔ?” ");
INSERT INTO any_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Mɔ bɛ bisalɩ kosuan sɔ'n, Zozi kɔ kpɛ yɩ́ nyɩn bɛ́ nwʋn ɛlɔ ɔ kɔ tu bɛ́ nyunnun. ");
INSERT INTO any_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Bɛ fi ɛbɛlɛ bɛ kɔ hɔ kulo fʋfɔlɛ asʋ. ");
INSERT INTO any_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Mɔ anɩn bɛ́ ja wɔ nun bɛ lɛ kɔ Zoluzalɛmʋn'n, sʋanlan kʋn kɔ han kɔ hele Zozi kɛ: “Yɛ́ Mɩn, lɩka kʋalaa mɔ ɛ 'kɔ'n, mɩn 'si wɔ sʋ.” ");
INSERT INTO any_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Zozi nwan: “Aminsanɩn'n-mɔ, bɛ le bɛ́ bɔɛ bɛ da nun. Nnʋnman'n-mɔ kʋsʋ le bɛ́ sâ. Nan *Mân Baa'n, yɩ́ dɩɛ, ɔ le man lɩka fɩ́ɩ́ m'ɔ da de yɩ́ ɛnwʋnmɩan ɔ.” ");
INSERT INTO any_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Zozi fɛlɛlɩ sʋanlan fʋfɔlɛ a, yɩ́ nwan: “Wɔ́, si mɩ́n sʋ.” Sʋanlan sɔ'n kʋsʋ nwan: “Kpain, man mɩ́n atɩn maan n gɔ n zie mɩ́n sɩ kʋalaaka.” ");
INSERT INTO any_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","M'ɔ hanlɩn sɔ'n, Zozi kɔ bua yɩ́ kɛ: “Yaci ewue mma maan bɛ síe bɛ́ fuin'n-mɔ, nán wɔ́ dɩɛ, kɔ bɔ Nyanmɩan Belemgbin Mân nɩn anwʋn kpayɛ'n.” ");
INSERT INTO any_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Sʋanlan fʋfɔlɛ biekun kʋsʋ kɔ han kɔ hele Zozi kɛ: “Kpain, mɩ́n dɩɛ, mɩn 'si wɔ́ sʋ o, nan kʋsʋ man mɩ́n atɩn maan n gɔ́ n gálɩ mɩ́n nvilie'n-mɔ kʋalaaka.” ");
INSERT INTO any_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Zozi nwan: “Sʋanlan m'ɔ kulo kɛ ɔ si mɩ́n sʋ'n, sɛ ɔ susu yɩ́ nzin ɛjɔlɛ a, anɩn ɔ'a nzɛ nvata man Nyanmɩan Belemgbin Mân nɩn anun junman elie sʋanlan.” ");
INSERT INTO any_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Ɛhɩ anzin, yɛ́ Mɩn kɔ yɩ menian abulasʋ nʋn nnyuan biekun. Ɔ kɔ sʋan bɛ́ nnyuan nnyuan kɛ bɛ lí mʋa kulo'n-mɔ kʋalaa asʋ ɔ nʋn lɩka kʋalaa mɔ yɩ́ muonun ɔ 'ba sɩn'n. ");
INSERT INTO any_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Yɩ́ nwan: “Mmaka mma'n mɔ bɛ 'tɩ'n tɛ sʋn, kʋsʋ ajunmanfʋ'n-mɔ a nzʋn man. Yɩ́ ti, ɛmɔ sɛ́lɛ ebo nɩn asʋ mɩnlɩan'n maan ɔ gúa ajunmanfʋ dɔʋn yɩ́ ebo nɩn asʋ. ");
INSERT INTO any_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Ɛmɔ hɔ́! Mɩɩn sʋan ɛmɔ kɛ mmʋa mma-mɔ bedi'n-mɔ afian. ");
INSERT INTO any_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Ɛhɔlɛ mɔ ɛmɔ lɛ kɔ'n, nán bɛ fa esika, nán bɛ fa bɔ́lɛ, nán bɛ fa mgbabʋa, nán bɛ jinlan atunnun bɛ bisa sʋanlan fɩ́ɩ́ ahɩn. ");
INSERT INTO any_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","“Sɛ ɛmɔ ju ɛlɔ a, awulo biala mɔ ɛmɔ kɔ wʋlʋ nun'n, ɛmɔ lí mʋa hán kɛ: ‘Alʋacɩcɩɛ hán ɛmɔ kʋalaa mɔ bɛ wɔ awulo ɛhɩ anun'n.’ ");
INSERT INTO any_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Sɛ alʋacɩcɩɛ sʋanlan wɔ awulo sɔ nɩn anun an, ɛmɔ alʋacɩcɩɛ'n 'kan yɩ́. Sɛ ɔ tɩ man sɔ a, ɛmɔ alʋacɩcɩɛ'n 'ka ɛmɔ ɛlɔ. ");
INSERT INTO any_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Ɛmɔ tánlan awulo sɔ nɩn anun ɛbɛlɛ. Alɩɛ biala mɔ bɛ kɔ fɛlɛ ɛmɔ yɩ́ nwʋn'n, ɛmɔ nʋn bɛ́ lí bɛ nʋ́n sʋ nzan'n. Afɩ ɔ fata kɛ kpafʋ biala nyan yɩ́ junman nɩn anwʋn ahatua. Nán bɛ di tutanlan. ");
INSERT INTO any_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","“Kulo biala mɔ ɛmɔ kɔ ju sʋ'n, sɛ bɛ de ɛmɔ a, like biala mɔ bɛ kɔ tʋn bɛ kɔ man ɛmɔ'n, ɛmɔ lí. ");
INSERT INTO any_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Ɛmɔ mán kulo sɔ nɩn asʋ nwuluwafʋɛ'n-mɔ anwʋn sa, ɛsɛ bɛ sé kulo mma'n-mɔ kɛ: ‘Nyanmɩan Belemgbin Mân nɩn a kpunnge ɛmɔ.’ ");
INSERT INTO any_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Nan kulo kʋsʋ mɔ ɛmɔ kɔ hɔ sʋ mɔ b'a nne man ɛmɔ'n, ɛmɔ fíte bɛ́ gua nɩn asʋ, bɛ sé kɛ: ");
INSERT INTO any_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Ɛmɔ kulo'n muonun asʋ anyʋan'n mɔ ɔ'a bɔ ɔ'a gua yɛ́ ja'n-mɔ anwʋn'n, yɛ lɛ kpɔkpala yɛ gua ɛmɔ anwʋn. Nan kʋsʋ, ɛmɔ nwún yɩ́ kɛ Nyanmɩan Belemgbin Mân nɩn a kpunnge ɛmɔ.’ ");
INSERT INTO any_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Mɩɩn kan yɩ́ ananhɔlɛ mɩn kele ɛmɔ kɛ kulo sɔ'n, ndɛɛ ebua cɩan nɩn anun, ɔ 'nwun yalɛ tala *Sodɔmʋn kulo'n.” ");
INSERT INTO any_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Ɛmɔ Kolazɩn amma, munnzue hán ɛmɔ! Ɛmɔ Bɛtɩsayida amma, munnzue hán ɛmɔ! Afɩ asinbɛnwʋn ninnge'n-mɔ mɔ bɛ yɔlɩ yɩ́ ɛmɔ afian'n, sɛ bɛ yɔlɩ yɩ́ *Tii nʋn *Sidʋn kulo'n-mɔ asʋ a, ahan ndɛ-ndɛ kpa, ɛbɛlɛ menian'n-mɔ a tanlan asɩ, b'a wula kotoku b'a bɔ nzʋan m'ɔ kele kɛ b'a nun bɛ́ nwʋn b'a kaci bɛ́ abalabɔ'n. ");
INSERT INTO any_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Ɛhɩ ati, yalɛ mɔ ɛmɔ 'ba nwun yɩ́'n, ɔ 'tala Tii nʋn Sidʋn amma'n-mɔ dɩɛ'n. ");
INSERT INTO any_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Ɛmɔ Kapɛɛnawɔmʋn amma, ɛmɔ jʋnlɩn kɛ bɛ 'kuku bɛ́ nwʋn sʋ dede bɛ́ nʋn Nyanmɩan sɛ ɔ? Cɛcɛ. Bɛ 'kan ɛmɔ asɩ dede ɛmɔ ju sɩ̂n m'ɔ le man ayuelɩɛ nɩn anun.” ");
INSERT INTO any_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Ɛsɛ Zozi kɔ han kɔ hele yɩ́ menian'n-mɔ kɛ: “Sʋanlan m'ɔ kɔ tie ɛmɔ ɛjɔlɛ'n, anɩn ɔ'a tie mɩ́n. Sʋanlan mɔ ɔ'a nzɔ man ɛmɔ nun'n, anɩn mɩ́n yɛ̂ ɔ'a nzɔ man mɩ́n nun ɔ. Yɛ̂ nunhan mɔ ɔ'a nzɔ man mɩ́n nun'n, anɩn sʋanlan'n m'ɔ sʋanlɩn mɩ́n nɩn anun yɛ̂ ɔ'a nzɔ man ɔ.” ");
INSERT INTO any_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Ɛhɩ, menian abulasʋ nʋn nnyuan'n mɔ Zozi sʋanlɩn bɛ́'n kɔ hɔ kɔ a. Bɛ 'ba a, anɩn b'a li fɛ. Bɛ́ nwan: “Yɛ́ Mɩn, yɛ bɔ wɔ́ dunman nɩn ala, wawɛ ɛtɛ'n-mɔ ngʋala man yɛ́ nyunnun jinlan!” ");
INSERT INTO any_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Zozi nwan: “Ɔ tɩ sɔ. Mɩn 'nɩan an, anɩn *Satan fi anwunno ɔ'a yɩ ɔ'a tɔ asɩ kɛ nyanmɩan'n m'ɔ lɛ kpɛ mɩaɩn ɔ. ");
INSERT INTO any_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Ɛmɔ nɩ́an, m'an man ɛmɔ tunmin kɛ ɛmɔ nánndɩ owo nʋn nyanmɩan aka'n-mɔ asʋ, m'an man ɛmɔ tunmin kɛ ɛmɔ tía ɛmɔ kpɔfʋɛ'n tunmin dɩɛ nɩn asʋ. Like fɩ́ɩ́ ngɔ hʋala man ɛmɔ yɔ. ");
INSERT INTO any_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Nan kʋsʋ nán bɛ di fɛ kɛ wawɛ ɛtɛ'n-mɔ ngʋala man ɛmɔ anyunnun jinlan, nan ɛmɔ lí fɛ kɛ b'a hɛlɛ ɛmɔ dunman'n wɔ Nyanmɩan Belemgbin Mân nɩn anun ɛlɔ.” ");
INSERT INTO any_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Mɛlɛ kʋnmgba sɔ'n, Wawɛ Nwannzan-nwannzan'n kɔ man Zozi kɔ li fɛ. Yɩ́ nwan: “Mɩ́n Sɩ, wɔ́ mɔ ɛ bɔlɩ anwunno nʋn asɩɛ'n, mɩn 'da wɔ́ asɩ. Ɔ sanlɩn kɛ a yɩ nvɩalɩɛ nun ninnge'n-mɔ a hele mmatʋnman ɛhɩ-mɔ. Nan bɛ́ mɔ bɛ́ nwan bɛ sɩ ngɛlɛ ɔ nʋn bɛ́ mɔ bɛ sɩ kalata'n, a man b'a nnwun man yɩ́. Mɩ́n Sɩ, ɔ tɩ ananhɔlɛ, a man ɔ'a yɔ sɔ. Ɔ sanlɩn kɛ mɔ ɛ hulolɩ nɩn anɩn. Yɩ́ ti, mɩn da wɔ́ asɩ. ");
INSERT INTO any_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Mɩ́n Sɩ, a fa tunmin'n kʋalaa a wula mɩ́n sa nun. Sɛ nán Sɩɛ nɩn angʋnmɩn cein an, sʋanlan fɩ́ɩ́ nzɩ man Baa'n. Yɛ̂ sɛ nán Baa'n kʋsʋ angʋnmɩn cein, ɔ nʋn kɛ bɛ́ mɔ Baa'n kulo kɛ ɔ yɩ Sɩɛ'n kele bɛ́ nɩn an, sʋanlan fɩ́ɩ́ kʋn nzɩ man Sɩɛ'n.” ");
INSERT INTO any_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Mɔ Zozi hanlɩn sɔ yuelɩ'n, ɔ kɔ kpɛ yɩ́ nyɩn yɩ́ menian'n-mɔ anwʋn ɛlɔ. Yɩ́ nwan: “Nyila hán ɛmɔ wɔ nunhan mɔ ɛmɔ anyɩn'n nwun yɩ́ nɩn anwʋn! ");
INSERT INTO any_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Afɩ mɩɩn kan yɩ́ ananhɔlɛ mɩn kele ɛmɔ kɛ daba Nyanmɩan mgbɔmanfʋɛ'n-mɔ dɔʋn kpa, nʋn daba mmelemgbin dɔʋn kpa hulolɩ kɛ ahan bɛ nwun mɔ ɛmɔ anyɩn nwun yɩ́'n, kʋsʋ bɛ́ nyɩn a nnwun man yɩ́. Bɛ hulolɩ kɛ ahan bɛ tɩ mɔ ɛmɔ lɛ tɩ'n, kʋsʋ b'a ndɩ man.” ");
INSERT INTO any_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Ɛhɩ, *mala nɩn asʋ kpain'n kʋn kɔ jasʋ, ɔ 'sɔ Zozi nɩan. Ɔ kɔ bisa yɩ́ kosuan kɛ: “Kpain, anɩn nzukɛ yɛ̂ mɩn yɔ a, n gɔ nyan nyanmɩansʋ ngʋan'n m'ɔ le man ayuelɩɛ nɩn ɔ?” ");
INSERT INTO any_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Zozi nwan: “Nzu ɛjɔlɛ dɩɛ yɛ̂ b'a hɛlɛ wɔ yɛ́ mala nɩn anun ɔ? Sɛ ɛ kɩnnga a, ɛ tɩ yɩ́ bʋ sɛ?” ");
INSERT INTO any_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Bian'n nwan: “Ɔ di kɛ ɛ fa wɔ́ ahʋnlɩn'n kʋalaa, ɔ nʋn wɔ́ ɛkala'n kʋalaa, ɔ nʋn wɔ́ anwʋnsɛlɛ'n kʋalaa, ɔ nʋn wɔ́ ajʋnlɩn'n kʋalaa, ɛ kulo yɛ́ Mɩn m'ɔ tɩ wɔ́ Nyanmɩan'n. Ɛsɛ ɔ di kɛ ɛ kulo wɔ́ manngʋn kɛ wɔ́ muonun wɔ́ nwʋn.” ");
INSERT INTO any_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","M'ɔ hanlɩn sɔ'n, Zozi nwan: “Ɩnhɩn, a bua yɩ́ kpa. Kɔ nán yɔ yɩ́ sɔ, ɛ 'ba nyan ngʋan.” ");
INSERT INTO any_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Ɛhɩ, kɛmɔ mala nɩn asʋ kpain'n kulo kɛ ɔ bu yɩ́ nwʋn bɩ nɩn ati, ɔ kɔ bisa Zozi kɛ: “Anɩn nwan lɩlɩ yɛ̂ ɔ tɩ mɩ́n manngʋn'n?” ");
INSERT INTO any_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Zozi kɔ sʋsɔ ɛjɔlɛ sʋ, yɩ́ nwan: “Anɩn bian kʋn fi Zoluzalɛmʋn, ɔ lɛ sɩn kɔ Zoliko. Atunnun, kodiawu-mɔ kɔ hyɩ yɩ́, bɛ kɔ le yɩ́ nwʋn ninnge'n kʋalaatin, bɛ kɔ bili yɩ́ dede ɔ ka m'ɔ wu, nán b'a yaci yɩ́ ɛbɛlɛ b'a hɔ. ");
INSERT INTO any_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Nyanmɩan tɛɛyɩfʋɛ kʋn kɔ fa atɩn sɔ'n. Ɔ hɔlɩ dede mɔ yɩ́ nyɩn bɔlɩ bian'n mɔ b'a li yɩ́ awue nɩn ala a, ɔ kɔ sɩn ahanmɩan, yɛ̂ ɔ kɔ hɔ. ");
INSERT INTO any_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","*Levifʋɛ kʋn kʋsʋ kɔ a kɔ ju ɛbɛlɛ, yɩ́ nyɩn bɔlɩ bian nɩn ala a, ɔ kɔ sɩn ahanmɩan, yɛ̂ ɔ kɔ hɔ. ");
INSERT INTO any_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Nan Samali bian kʋn, mɔ yɩ́ kʋsʋ ɔ lɛ kpɛ nun sɩn'n, ɔ kɔ a kɔ ju wuluwafʋɛ nɩn anwʋn ɛbɛlɛ. M'ɔ nwunlin wuluwafʋɛ'n, koun kɔ hun yɩ́ sʋnman. ");
INSERT INTO any_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Ɔ kɔ hyʋɩn kɔ kpunnge yɩ́, ɔ kɔ gugua yɩ́ nganlan'n-mɔ anun ayile, ɔ kɔ cɩcɩ sʋ. Ɛsɛ afunlunmun'n mɔ yɩ́ muonun ɔ tɩ sʋ'n, ɔ kɔ fa wuluwafʋɛ'n kɔ síe sʋ, ɔ nʋn yɩ́ kɔ hɔ kpɛnunsɩn sua kʋn anun, nán ɔ'a nɩan yɩ́. ");
INSERT INTO any_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Bɛ lalɩ alɩ́ɛ hɩnlɩn, ɔ kɔ yɩ esika kɔ man bian'n m'ɔ le kpɛnunsɩn sua'n, nán ɔ'a han ɔ'a hele yɩ́ kɛ: ‘Mɩɩn kɔ o, yɩ́ ti, nɩan bian ɛhɩ asʋ kanlanman. Mɛlɛ mɔ mɩn 'ba sa mɩn ba ɛwa'n, kalɛ biekun mɔ ɛ kɔ bɔ yɩ́ nwʋn'n, mɩn 'tua mɩn man wɔ́.’” ");
INSERT INTO any_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Ɛhɩ a, Zozi nwan: “Ɛ nɩan an, anɩn bɛ́ menian nsan'n, benin y'ɔ tɩ sʋanlan'n mɔ ahan kodiawu'n-mɔ kun yɩ́'n, yɩ́ manngʋn ɔ?” ");
INSERT INTO any_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Mala nɩn asʋ kpain'n nwan: “Nunhan m'ɔ nwunlin yɩ́ nwʋn anwunnvoe ɔ yɔlɛ yɩ́ ye nɩn ɔ.” M'ɔ bualɩ ɛhɩ'n, nán Zozi a se yɩ́ kɛ: “Wɔ́ kʋsʋ, kɔ nán yɔ yɩ́ sɔ ala.” ");
INSERT INTO any_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Kɛmɔ anɩn Zozi nʋn yɩ́ menian'n-mɔ aja wɔ atunnun'n, bɛ hɔlɩ juli kulo kʋn asʋ. Mɔ bɛ juli ɛbɛlɛ'n, balasua kʋn kɔ sike bɛ́ yɩ́ awulo. Bɛ fɛlɛ balasua sɔ'n Maatɩ. ");
INSERT INTO any_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Maatɩ le yɩ́ nianman balasua kʋn ɛbɛlɛ, bɛ fɛlɛ yɩ́ Mali. Malɩ kɔ tanlan yɛ́ Mɩn aja abʋ, ɔ lɛ tie ɛjɔlɛ'n m'ɔ lɛ kan'n, ɔ nʋn ninnge'n-mɔ m'ɔ lɛ kele'n. ");
INSERT INTO any_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Maatɩ dɩɛ, anɩn yɩ́ nyɩn a bʋlʋ kpa, ɔ lɛ yɔ like maan bɛ di. Ɔ kɔ a kɔ tʋ bɛ́. Yɩ́ nwan: “Yɛ́ Mɩn, kɛmɔ mɩ́n nianman nɩn a yaci junman'n kʋalaa a kpolo mɩ́n'n, ɔ njɩjɩ man wɔ́ ɔ? Kan kele yɩ́ kɛ ɔ bála a bʋka mɩ́n.” ");
INSERT INTO any_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Yɛ́ Mɩn kɔ bua yɩ́ kɛ: “Maatɩ, Maatɩ, ɛ lɛ susu, ɛsɛ ɛ lɛ di ninnge dɔʋn anwʋn yalɛ. ");
INSERT INTO any_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Nan kʋsʋ like kʋnmgban cein ala yɛ̂ ɔ tɩ cɩnnjɩn ɔ. M'ɔ tɩ kpa'n, yɛ̂ Mali a fa nɩn ɔ. Sʋanlan fɩ́ɩ́ ngʋala man yɩ́ tʋa de.” ");
INSERT INTO any_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Ɛlɛhʋn kʋn, Zozi hɔlɩ asɔnɩn ɛyɔlɛ lɩka bie. M'ɔ yɔlɩ asɔnɩn yuelɩ'n, yɩ́ menian'n-mɔ anun kʋn kɔ han kɔ hele yɩ́ kɛ: “Yɛ́ Mɩn kele yɛ́ kɛ bɛ kpɩn bɛ yɔ asɔnɩn'n kɛ Zʋan helelɩ yɩ́ menian'n-mɔ'n.” ");
INSERT INTO any_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Zozi kɔ bua bɛ́ kɛ: “Sɛ ɛmɔ 'yɔ asɔnɩn an, ɛmɔ hán kɛ: Mɩ́n Sɩ, man yɛ fá anyɩnnzɔ yɛ bɔ́ wɔ́ dunman nwannzan-nwannzan'n. Man wɔ́ belemgbin elie mɛlɛ'n jú. ");
INSERT INTO any_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Alɩhɩan biala alɩɛ m'ɔ fata'n, fa man yɛ́. ");
INSERT INTO any_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Fa yɛ́ ɛtɛ'n-mɔ ce yɛ́ kɛ yɛ kʋsʋ yɛ fa yɛ ce bɛ́ mɔ bɛ fʋn yɛ́'n. N'ɛ yaci Abɔnsanmʋn maan ɔ laka yɛ́.” ");
INSERT INTO any_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Ɛsɛ Zozi kɔ han kɔ hele bɛ́ biekun kɛ: “Yɛ bú yɩ́ kɛ ɛmɔ anun kʋn le yɩ́ manngʋn. Alɩmunnun ɔ'a hɔ a tʋ yɩ́ manngʋn sɔ'n, yɩ́ nwan: ‘Mɩ́n nianman, fɛ mɩ́n kpaʋn nsan. ");
INSERT INTO any_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Ɔ sanlɩn kɛ mɩ́n manngʋn kʋn fi atɩn ɔ'a a tʋ mɩ́n, n ne man like mɔ ɔ 'di ɔ.’ ");
INSERT INTO any_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","“Yɛ bú yɩ́ kɛ nunhan'n mɔ bɛ lɛ sɛlɛ yɩ́ kpaʋn'n la yɩ́ sua nɩn akunnun ɛlɔ, yɩ́ nwan: ‘Yaci mɩ́n koun! M'an tʋ mɩ́n anʋan nɩn anun. Mɩ́n nʋn mɩ́n yɩ nʋn mɩ́n mma'n-mɔ y'a la. Mɩn ngʋala man jasʋ nán m'an fa kpaʋn'n m'an man wɔ́.’ ");
INSERT INTO any_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Mɩɩn kan mɩn kele ɛmɔ kɛ, sɛ bɔbɔ bian nɩn a njasʋ man ɔ a mman man yɩ́ manngʋn'n kpaʋn an, yɩ́ manngʋn'n 'bɔ anʋan'n dede ɔ kpati jasʋ. Ɔ 'fa yɩ́ kʋalaa mɔ yɩ́ manngʋn nɩn a mian yɩ́ nwʋn'n man yɩ́. ");
INSERT INTO any_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“Mɩ́n kʋsʋ mɩɩn kan mɩn kele ɛmɔ kɛ ɛmɔ bísa nán ɛmɔ 'nyan yɩ́. Ɛmɔ kpʋ́nndɛ nán ɛmɔ 'nwun yɩ́. Ɛmɔ bɔ́ anʋan'n nán bɛ 'tike. ");
INSERT INTO any_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Ɔ sanlɩn kɛ sʋanlan biala m'ɔ kɔ bisa like'n, bɛ fa bɛ man yɩ́. M'ɔ kɔ kpʋnndɛ like'n, ɔ nwun yɩ́. M'ɔ kɔ bɔ anʋan'n kʋsʋ, bɛ tike. ");
INSERT INTO any_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","“Ɛmɔ anun benin yɛ̂ sɛ yɩ́ wa bisa yɩ́ ejue a, ɔ fa owo man yɩ́ ɔ? ");
INSERT INTO any_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Anaan sɛ yɩ́ wa'n bisa yɩ́ kolonvia a, ɔ fa nyanmɩan aka man yɩ́ ɔ? ");
INSERT INTO any_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Ɛmɔ lɩlɩ mɔ ɛmɔ tɩ ɛtɛfʋɛ'n, ɛmɔ sɩ ninnge m'ɔ tɩ mgbakpa bɛ fa bɛ man bɛ́ mma'n-mɔ. Sɩɛ'n m'ɔ wɔ anwunno ɛlɔ'n lɩlɩ yɛ̂ kanngʋ, ɔ ngɔ fa man Wawɛ Nwannzan-nwannzan'n ɔ ngɔ mman man bɛ́ mɔ bɛ lɛ bisa yɩ́ nɩn ɔ!” ");
INSERT INTO any_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Ɛlɛhʋn kʋn Zozi kɔ tu wawɛ ɛtɛ fi bian kʋn anun. Wawɛ ɛtɛ sɔ'n man bian'n tɔ amunle. Mɔ Wawɛ ɛtɛ'n fitelɩ'n, bian'n kɔ jʋjɔ. Ɛjɔlɛ'n kɔ sin menian'n-mɔ anwʋn kpili sʋnman. ");
INSERT INTO any_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","M'ɔ yɔlɩ sɔ'n, mmie-mɔ nwan: “Bɛlɩzebulu m'ɔ tɩ mmɔnsanmʋn'n-mɔ kpain'n y'ɔ man yɩ́ tunmin maan ɔ tu wawɛ ɛtɛ'n-mɔ ɔ” ");
INSERT INTO any_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Mmie-mɔ kʋsʋ kulo kɛ bɛ sua yɩ́ ngaa. Bɛ́ nwan: “Sɛ wɔ́ tunmin'n fi Nyanmɩan ɛlɔ sakpa a, anɩn yɔ asinbɛnwʋn like kʋn maan yɛ nwún yɩ́.” ");
INSERT INTO any_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Nan kɛmɔ anɩn Zozi sɩ mɔ b'a jʋnlɩn'n, yɩ́ nwan: “Belemgbin man biala mɔ nun menian'n-mɔ kpɛ bɛ́ nyɩn bɛ kʋn ɛlɔɛ'n, mân sɔ'n 'bɔ asɩ, ɛbɛlɛ sua'n-mɔ 'bubu gua. ");
INSERT INTO any_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Nan sɛ *Satan nʋn yɩ́ nwʋn kʋn ɛlɔ a, ɔ 'yɔ sɛ nán yɩ́ belemgbin mân nɩn a jinlan yɩ́ ja nun? Afɩ ɛmɔ lɛ kele kɛ n ne Bɛlɩzebulu tunmin'n yɛ̂ mɩn fa mɩn tu wawɛ ɛtɛ'n-mɔ ɔ. ");
INSERT INTO any_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Sɛ n ne Bɛlɩzebulu tunmin'n yɛ̂ mɩn fa mɩn tu wawɛ ɛtɛ'n-mɔ a, anɩn ɛmɔ amma'n-mɔ, tunmin benin yɛ̂ bɛ́ dɩɛ bɛ fa bɛ tu wawɛ ɛtɛ'n-mɔ ɔ? Ɛmɔ amma'n-mɔ muonun yɛ̂ bɛ 'bu ɛmɔ fʋɔ ɔ. ");
INSERT INTO any_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Mɩɩn kan yɩ́ ananhɔlɛ mɩn kele ɛmɔ kɛ n ne Nyanmɩan tunmin'n yɛ̂ mɩn fa mɩn tu wawɛ ɛtɛ'n-mɔ ɔ. Yɩ́ bʋ kele kɛ Nyanmɩan lɛ di yɩ́ belemgbin nɩn ɛmɔ afian ɛwa. ");
INSERT INTO any_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Mɛlɛ mɔ sʋanlan kʋn tɩ akpɔlɛ kpa, m'ɔ le ɛlɔɛ ninnge ɔ sisa yɩ́ awulo'n, bɛ ngʋala man yɩ́ wua. ");
INSERT INTO any_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Nan sɛ sʋanlan fʋfɔlɛ fite ɛbɛlɛ mɔ yɩ́ sa kʋala m'ɔ le awulo'n, ɔ tʋa yɩ́ de yɩ́ ɛlɔɛ ninnge'n kʋalaa m'ɔ susu yɩ́ ti gua sʋ'n, ɔ ce yɩ́ nwʋn ninnge'n ɔ man menian'n-mɔ. ");
INSERT INTO any_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Sʋanlan m'ɔ nnʋn man mɩ́n afan'n, anɩn ɔ kpɔ mɩ́n. Sʋanlan kʋsʋ m'ɔ nʋn mɩ́n yɛ nwohuan man ninnge'n-mɔ anʋan'n, anɩn ɔ bɔ bɛ́ asanndɩɛ. ");
INSERT INTO any_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Mɛlɛ mɔ wawɛ ɛtɛ'n fi sʋanlan kʋn anun kɔ fite'n, ɔ kɔ ɛwâ'n-mɔ anun ɛlɔ ɔ kɔ kpʋnndɛ lɩka ɔ tanlan de yɩ́ ɛnwʋnmɩan. Sɛ ɔ kɔ nán ɔ'a nnyan man bie fɩ́ɩ́ a, yɩ́ nwan: ‘Mɩn 'sa mɩn kɔ wʋlʋ mɩn sua'n mɔ n vi nun m'an fite nɩn anun biekun.’ ");
INSERT INTO any_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Sɛ ɔ ba ɔ ju ɛbɛlɛ nán ɔ nwun kɛ b'a kpekpian nun b'a sesie nun kanlanman an, ");
INSERT INTO any_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","ɔ kɔ fa wawɛ ɛtɛ nsʋ mɔ bɛ́ ti anun tɩ ɛtɛ tala yɩ́ ɔ ba. Bɛ wʋlʋ sua nɩn anun, bɛ ka ɛbɛlɛ bɛ tanlan. Yɩ́ bɛ-yue-asɩɛ, sʋanlan sɔ nɩn asɩtanlan'n yɔ esulo tala daba dɩɛ'n.” ");
INSERT INTO any_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Mɔ Zozi hanlɩn sɔ yuelɩ'n, balasua kʋn kɔ tɩan nun menian'n-mɔ afian ɛlɔ. Yɩ́ nwan: “Nyila hán balasua ɛhɩ m'ɔ wʋlɩ wɔ́ ɛsɛ ɔ nʋanlɩn wɔ́'n!” ");
INSERT INTO any_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Nan mɔ balasua nɩn anʋan tɔlɩ'n, Zozi nwan: “Nyila lɩlɩ hán bɛ́ mɔ bɛ tie Nyanmɩan Anʋan Ɛjɔlɛ'n mɔ ɛsɛ bɛ nanndɩ sʋ'n!” ");
INSERT INTO any_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Kɛmɔ anɩn menian dɔʋn kpa lɛ yia Zozi anwʋn ɛbɛlɛ'n, ɔ kɔ han kɔ hele bɛ́ kɛ: “Ajulisʋ menian'n-mɔ ati anun tɩ ɛtɛ. Bɛ kulo kɛ bɛ yɔ asinbɛnwʋn like bɛ kele bɛ́. Nan bɛ nyɔ man asinbɛnwʋn like fɩ́ɩ́ kʋn bɛ ngele man bɛ́. Asinbɛnwʋn like mɔ bɛ 'yɔ bɛ kele bɛ́'n, y'ɔ le kpɔmanfʋɛ *Zonasɩ dɩɛ'n. ");
INSERT INTO any_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Ɔ sanlɩn kɛ anɩn Zonasɩ tɩ nzɔlɛ wɔ Ninninvʋ amma'n-mɔ anyunnun. *Mân Baa'n kʋsʋ 'ba kaci nzɔlɛ wɔ ajulisʋ menian ɛhɩ-mɔ anyunnun. ");
INSERT INTO any_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Cɩan mɔ Nyanmɩan 'bua mân'n ndɛɛ'n, balasua'n mɔ anɩn ɔ tɩ Saba mân nɩn anun belemgbin'n, ɔ 'ba jasʋ jinlan ɔ bu ajulisʋ menian'n-mɔ fʋɔ. Ɔ sanlɩn kɛ ɔ fi hyʋɩ ɔ walɩ tielɩ belemgbin bɛngɛlɛfʋɛ Salomʋn ɛjɔlɛ'n. Nan kʋsʋ sʋanlan kʋn wɔ ɛwa m'ɔ tala Salomʋn ɔ! ");
INSERT INTO any_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Cɩan mɔ Nyanmɩan 'bua mân'n ndɛɛ'n, Ninninvʋ amma'n-mɔ 'ba jasʋ bɛ jinlan bɛ bu ajulisʋ menian'n-mɔ fʋɔ. Ɔ sanlɩn kɛ mɛlɛ mɔ bɛ tɩlɩ Nyanmɩan Anʋan Ɛjɔlɛ'n mɔ Zonasɩ hanlɩn helelɩ bɛ́'n, bɛ nunlin bɛ́ nwʋn bɛ kacili bɛ́ abalabɔ'n. Nan kʋsʋ sʋanlan kʋn wɔ ɛwa m'ɔ tɩ kpili tala Zonasɩ ɔ!” ");
INSERT INTO any_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Ɛsɛ Zozi nwan: “Sʋanlan fɩ́ɩ́ nzɔ kanlannɩɛ ɔ nva wula man bokiti abʋ, nan bɛ sɔ bɛ sinnze yɩ́ anwunno maan bɛ́ mɔ bɛ lɛ wʋlʋ sua nɩn anun'n nwun asɩ. ");
INSERT INTO any_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Wɔ́ nyɩn'n tɩ kɛ wɔ́ nwʋnnaan nɩn asʋ kanlannɩɛ. Sɛ wɔ́ nyɩn'n nwun asɩ a, anɩn wɔ́ lɩka kʋalaatin wɔ́ jawe nun. Nan sɛ wɔ́ nyɩn'n tɩ man kpa a, anɩn wɔ́ nwʋnnaan'n wɔ awosin nun. ");
INSERT INTO any_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Yɩ́ ti, sie wɔ́ nwʋn ye nán jawe'n mɔ ɛ tɩ nun nɩn a ngaci man awosin. ");
INSERT INTO any_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Sɛ wɔ́ nwʋnnaan'n lɩka kʋalaatin wɔ jawe nun, mɔ yɩ́ lɩka fɩ́ɩ́ nnʋn man awosin nun'n, wɔ́ nwʋnnaan'n 'ta kɛ kanlannɩɛ'n ta wɔ́ nwʋn'n.” ");
INSERT INTO any_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Ɛhɩ, mɔ Zozi anʋan tɔlɩ'n, *Falisifʋɛ kʋn kɔ fɛlɛ yɩ́ kɛ ɔ bála a li like yɩ́ awulo. Mɛlɛ mɔ bɛ lɩla mgba nɩn asʋ tɔbɩlɩ nɩn anwʋn'n, ");
INSERT INTO any_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Falisifʋɛ'n kɔ nwun kɛ Zozi a nwunnzinman yɩ́ sa kʋsʋ ɔ le fa di like. Ɛjɔlɛ'n kɔ sin Falisifʋɛ nɩn anwʋn. ");
INSERT INTO any_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Ɛhɩ a, yɛ́ Mɩn kɔ han kɔ hele yɩ́ kɛ: “Ɛmɔ Falisifʋɛ'n-mɔ, kɛ ɛmɔ tɩ yɩ́ nɩn anɩn. Ɛmɔ nwunnzin kangɔ'n nʋn talie nɩn anzin, nan kʋsʋ awue nʋn ajʋnlɩn ɛtɛ ngʋnmɩn y'ɔ wɔ ɛmɔ ati anun ɔ. ");
INSERT INTO any_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Sɛnvʋɛ tɩ kɛ ɛmɔ! Nyanmɩan m'ɔ bɔlɩ like nɩn anzin'n, nán yɩ́ kʋnmgba'n y'ɔ bɔlɩ yɩ́ kunnun nɩn ɔ? ");
INSERT INTO any_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Yɩ́ ti, ɛmɔ yɩ́ bɛ́ kunnun bɛ bɔ́ afɔlɩɛ bɛ mán ehianfʋɛ'n-mɔ. Sɛ ɛmɔ yɔ yɩ́ sɔ a, ɛmɔ asɩtanlan'n b'a yɔ nwannzan-nwannzan man ɛmɔ. ");
INSERT INTO any_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Munnzue hán ɛmɔ Falisifʋɛ'n-mɔ! Ɔ sanlɩn kɛ ɛmɔ ebo nɩn asʋ ninnge kɛ mantɩ nʋn lu ɔ nʋn munmuin munmuin'n-mɔ, sɛ ɛmɔ tɩtɩ a, ɛmɔ bu nun bulu bɛ tu kʋn bɛ man Nyanmɩan. Nan kʋsʋ ɛmɔ ngan man ananhɔlɛ ɛsɛ ɛmɔ ngulo man Nyanmɩan. Like mɔ ahan ɔ di kɛ ɛmɔ yɔ'n, ɔ nʋn yɩ́ nzin dɩɛ'n-mɔ'n, yɩ́ ahɩ. ");
INSERT INTO any_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Munnzue hán ɛmɔ Falisifʋɛ'n-mɔ! Ɔ sanlɩn kɛ ɛmɔ kulo kɛ menian'n-mɔ kʋalaa nwun ɛmɔ. Yɩ́ ti, asɔnɩn sua'n-mɔ anun bia'n-mɔ m'ɔ jijin bɛ́ nyunnun nɩn asʋ yɛ̂ ɛmɔ tɛtanlan ɔ. Gua nɩn asʋ, ɛmɔ kulo kɛ menian'n-mɔ bɛbɛlɛ bɛ́ nwʋn asɩ nán b'a bisa ɛmɔ ahɩn. ");
INSERT INTO any_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","“Munnzue hán ɛmɔ! Ɔ sanlɩn kɛ ɛmɔ tɩ kɛ asielɩɛ mɔ menian'n-mɔ nzɩ man kɛ b'a sie sʋanlan ɛbɛlɛ mɔ bɛ nanndɩ sʋ ɔ!” ");
INSERT INTO any_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Mɔ Zozi hanlɩn sɔ'n, mala nɩn asʋ kpain'n kʋn jasʋlɩ a, yɩ́ nwan: “Kpain, ɛ kan ɛjɔlɛ kɛ mɔ ɛ lɛ kan yɩ́ ɛbɛlɛ nɩn an, anɩn ɛ lɛ bɔ yɛ́ kʋsʋ yɛ́ amgba!” ");
INSERT INTO any_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Zozi nwan: “Munnzue hán ɛmɔ mala nɩn asʋ mgbain'n-mɔ kʋsʋ bie! Ɔ sanlɩn kɛ ɛmɔ man menian'n-mɔ sɔsʋa bɔ́lɛ nʋnnɔɛ nʋnnɔɛ, kʋsʋ ɛmɔ nva man bɛ́ sa bɛtɩa kʋn bɔbɔ bɛ mmʋka man bɛ́. ");
INSERT INTO any_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","“Munnzue hán ɛmɔ! Ɔ sanlɩn kɛ ɛmɔ tʋ Nyanmɩan mgbɔmanfʋɛ'n-mɔ mɔ ɛmɔ anan-mɔ hunlin bɛ́'n sɛka nɩn asʋ kanlanman kanlanman! ");
INSERT INTO any_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Ɛmɔ yɔ sɔ bɛ kele kɛ bɛ jin bɛ́ nan-mɔ anzin. Afɩ ɛmɔ anan-mɔ kun mgbɔmanfʋɛ'n-mɔ a, ɛmɔ yɛ̂ bɛ tʋ bɛ́ sɛka nɩn asʋ ɔ! ");
INSERT INTO any_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Ɛhɩka ati, Nyanmɩan m'ɔ tɩ bɛngɛlɛfʋɛ'n lɛ kele kɛ: ‘Mɩn 'sʋan mgbɔmanfʋɛ nʋn mmɔfʋɛ bɛ́ nwʋn ɛlɔ. Bɛ 'kun mmie-mɔ yɛ̂ bɛ 'kele mmie-mɔ kʋsʋ ahʋlʋwa.’ ");
INSERT INTO any_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Ɔ man kɛ Nyanmɩan bɔlɩ mân'n mɔ ɔ 'ju ɛnɛ'n, yɩ́ mgbɔmanfʋɛ'-mɔ kʋalaa mɔ b'a hun bɛ́'n, bɛ 'pinnin ajulisʋ menian ɛhɩ-mɔ wɔ yɩ́ nwʋn. ");
INSERT INTO any_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Ɔ bɔ yɩ́ bʋ Abɛlɩ ehuan dɩɛ nɩn asʋ dede ɔ kɔ ju kpɔmanfʋɛ Zakali, mɔ bɛ hunlin yɩ́ tɛɛyɩɛ mʋcɩa'n nʋn Nyanmɩan sua nɩn afian'n, mɩɩn kan yɩ́ ananhɔlɛ mɩn kele ɛmɔ kɛ, bɛ 'pinnin ajulisʋ menian ɛhɩ-mɔ kʋalaa wɔ yɩ́ nwʋn. ");
INSERT INTO any_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Munnzue hán ɛmɔ mala nɩn asʋ mgbain'n-mɔ! Ɔ sanlɩn kɛ ɛmɔ a fa ngɛlɛ sua sannvɛ nɩn a sie. Ɛmɔ muonun nwʋlʋ man nun. Bɛ́ mɔ bɛ́ kʋsʋ bɛ kulo kɛ bɛ wʋlʋ nun'n, ɛmɔ totua bɛ́ atɩn.” ");
INSERT INTO any_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Mɔ Zozi fi Falisifʋɛ nɩn awulo ɛbɛlɛ fitelɩ'n, mala nɩn asʋ mgbain'n-mɔ nʋn Falisifʋɛ'n-mɔ anyɩn kɔ bʋlʋ yɩ́ nwʋn kpa. Bɛ kɔ bisa bisa yɩ́ ɛjɔlɛ dɔʋn anwʋn kosuan. ");
INSERT INTO any_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Bɛ́ nwan bɛ 'yɔ sɔ bɛ sua yɩ́ ngaa maan ɔ tɔ nun. ");
INSERT INTO any_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Ɔ 'ba yɔ sɔ'n, menian akpɩɩ akpɩɩ kɔ yia Zozi anwʋn ɛbɛlɛ. Ɛsʋan mɔ bɛ sʋnlɩn nɩn ati, bɛ fʋfʋ bɛ́ nwʋn sʋ. Zozi kɔ li mʋa kɔ han kɔ hele yɩ́ menian'n-mɔ kɛ: “Ɛmɔ síe bɛ́ nwʋn ye wɔ *Falisifʋɛ'n-mɔ fali ayile nɩn anwʋn. Bɛ́ fali ayile sɔ'n y'ɔ le bɛ́ ato ɛnanndɩɛ'n. ");
INSERT INTO any_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Awosin nun ɛjɔlɛ'n kʋalaatin 'fite jawe nun. Nvɩalɩɛ nun ɛjɔlɛ'n kʋalaatin 'tu fite. ");
INSERT INTO any_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Ɛhɩka ati, like kʋalaa mɔ ɛmɔ kɔ yɔ yɩ́ awosin nɩn anun'n, alɩ́ɛ cɩn an, bɛ 'tɩ. Ɛjɔlɛ kʋsʋ mɔ ɛmɔ kɔ tu yɩ́ asule nun sua ɛlɔ bɛ kɔ hele sʋanlan'n, bɛ 'jinlan sua'n-mɔ ati asʋ bɛ bɔ yɩ́ kpayɛ. ");
INSERT INTO any_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Ɛmɔ mɔ ɛmɔ tɩ mɩ́n manngʋn'n, mɩɩn kan mɩn kele ɛmɔ kɛ: nán bɛ sulo bɛ́ mɔ bɛ kun anwʋnnaan'n kʋsʋ bɛ ngʋala man yɩ́ nzin like fɩ́ɩ́ yɔ'n. ");
INSERT INTO any_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Mɩn 'ba hele ɛmɔ sʋanlan'n m'ɔ di kɛ ɛmɔ sulo yɩ́'n: Ɛmɔ súlo Nyanmɩan. Afɩ, sɛ ɔ man ɛmɔ wu a, ɔ kʋala ɔ tʋ ɛmɔ sɩ̂n'n m'ɔ nnun man lé nɩn anun. Mɩɩn kan yɩ́ ananhɔlɛ mɩn kele ɛmɔ, yɩ́ dein y'ɔ di kɛ ɛmɔ sulo yɩ́ ɔ! ");
INSERT INTO any_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Asʋ bɛ tɔnɩn nnʋnman nganngan nnun an, yɩ́ esika'n ju bie? Nan kʋsʋ Nyanmɩan a lʋa nvi man bɛ́ nun kʋn. ");
INSERT INTO any_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Ɛmɔ ati enyuan'n muonun, Nyanmɩan sɩ yɩ́ kʋalaa anʋan. Yɩ́ ti, nán bɛ sulo, ɔ sanlɩn kɛ ɛmɔ anwʋn cɩan Nyanmɩan ɔ tala nnʋnman dɔʋn kpa. ");
INSERT INTO any_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Ɛsɛ mɩɩn kan mɩn kele ɛmɔ kɛ sɛ sʋanlan kʋn kan yɩ́ yuein menian'n-mɔ anyunnun kɛ ɔ tɩ mɩ́n dɩɛ a, *Mân Baa'n kʋsʋ 'kan wɔ Nyanmɩan mmɔfʋɛ'n-mɔ anyunnun ɛlɔ kɛ sʋanlan sɔ'n tɩ yɩ́ dɩɛ. ");
INSERT INTO any_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Nan sɛ sʋanlan kʋn kan yɩ́ yuein menian'n-mɔ anyunnun kɛ ɔ nzɩ man mɩ́n a, Mân Baa'n kʋsʋ 'kan wɔ Nyanmɩan mmɔfʋɛ'n-mɔ anyunnun ɛlɔ kɛ ɔ nzɩ man sʋanlan sɔ'n. ");
INSERT INTO any_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Sʋanlan biala m'ɔ kɔ han ɛjɔlɛ ɛtɛ ɔ kɔ tia Mân Baa'n, ɔ 'nyan ɛtɛ face. Nan sʋanlan m'ɔ kɔ han ɛjɔlɛ ɛtɛ ɔ kɔ tia Wawɛ Nwannzan-nwannzan'n, ɔ nnyan man ɛtɛ face. ");
INSERT INTO any_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Mɛlɛ mɔ bɛ nʋn ɛmɔ kɔ hɔ, mɔ bɛ lɛ kɔ a bua ɛmɔ ndɛɛ wɔ Zufʋ'n-mɔ asɔnɩn sua'n-mɔ anun, mgbain'n-mɔ nʋn bɛ́ mɔ bɛ le tunmin nɩn anyunnun'n, nán bɛ susu ɛjɔlɛ'n mɔ ɛmɔ 'kan bɛ sa bɛ́ nɩn nɩn anwʋn. ");
INSERT INTO any_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Ɔ sanlɩn kɛ, ɛjɔlɛ m'ɔ di mɔ ɛmɔ 'kan'n, Wawɛ Nwannzan-nwannzan'n 'ba fa wula ɛmɔ anʋan mɛlɛ sɔ nɩn anun.” ");
INSERT INTO any_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Mɔ Zozi hanlɩn sɔ yuelɩ'n, bian kʋn kɔ kuku yɩ́ nɩn sʋ meninsʋnman nɩn anun. Ɔ kɔ han kɔ hele Zozi kɛ: “Kpain, kan kele mɩ́n nianman'n kɛ ɔ bú ajâ'n mɔ yɛ́ sɩ a sie yɛ́ nɩn anun, nán ɔ fá mɩ́n dɩɛ'n ɔ mán mɩ́n.” ");
INSERT INTO any_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Mɔ bian nɩn anʋan tɔlɩ'n, Zozi kɔ bua yɩ́ kɛ: “Anianman, nwan yɛ̂ ɔ yɩlɩ mɩ́n kɛ m múa ɛmɔ ɛjɔlɛ'n, anaan n jé ɛmɔ ninnge nɩn ɔ?” ");
INSERT INTO any_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Mɔ Zozi hanlɩn ɛhɩ yuelɩ'n, ɔ kɔ han kɔ hele bɛ́ kʋalaatin kɛ: “Ɛmɔ nɩ́an bɛ́ nwʋn! Ɛmɔ síe bɛ́ nwʋn ye wɔ anwʋndɩɛ anyɩnbʋlʋ nɩn anwʋn. Ɔ sanlɩn kɛ man sʋanlan kʋn nyán yɩ́ nwʋn dede sɛɛ, nán yɩ́ anyanbɛnwʋn'n yɛ̂ ɔ man yɩ́ ngʋan ɔ.” ");
INSERT INTO any_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Ɛhɩ, ɔ kɔ bu anyɩnndala kʋn ɔ kɔ hele bɛ́. Yɩ́ nwan: “Anɩn esikafʋɛ kʋn wɔ ɛbɛlɛ. Ɔ kɔ sʋn ebo ɔ kɔ tɩ yɩ́ sɩsakaa. ");
INSERT INTO any_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Ɔ lalɩ jʋnlɩnlɩn an, ɔ kɔ se yɩ́ nwʋn kɛ: ‘Anɩn mɩn 'yɔ yɩ́ sɛ? N nne man lɩka mɔ mɩn 'sie mɩ́n ebo nɩn asʋ ninnge nɩn ɔ.’ ");
INSERT INTO any_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Ɛsɛ ɔ kɔ se yɩ́ nwʋn kɛ: ‘Ɛ 'nwun like m'ɔ di kɛ mɩn yɔ'n. Mɩn 'ba bubu mɩ́n esie'n-mɔ mɩn si yɩ́ mgbili mgbili kpa, Mɩn si ɔ yue a, mɩn 'fa mɩ́n *bele'n kʋalaatin ɔ nʋn mɩ́n ninnge'n kʋalaatin mɩn wula nun. ");
INSERT INTO any_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Afɩ sian'n, mɩn 'kan mɩn kele mɩ́n nwʋn kɛ: Eja, a li afʋɛ kɔ yɔ nyɛ nyɛ junman kpili kpa a sie. Yɩ́ ti, tanlan asɩ de wɔ́ ɛnwʋnmɩan, di alɩɛ nʋn nzan gua sʋ nán di mân.’ ");
INSERT INTO any_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","“M'ɔ hanlɩn sɔ'n, nán Nyanmɩan a han a hele yɩ́ kɛ: ‘Belenzua jibilito! Ɛnɛ kɔngɔɛ ɛhɩ dein, ɛ 'wu. Ninnge nwala'n mɔ a nyan yɩ́'n, ɛ 'fa man nwan?’” ");
INSERT INTO any_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Mɔ Zozi buli anyɩnndala sɔ'n yuelɩ'n, yɩ́ nwan: “Kɛ ɛjɔlɛ'n tɩ yɩ́ man sʋanlan m'ɔ kpʋnndɛ anyanbɛnwʋn'n ɔ man yɩ́ nwʋn nɩn anɩn. Nyanmɩan ɛlɔ a, sʋanlan sɔ'n le man like fɩ́ɩ́.” ");
INSERT INTO any_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Ɛhɩ anzin, Zozi kɔ han kɔ hele yɩ́ menian'n-mɔ kɛ: “Ɛhɩka ati, mɩɩn kan mɩn kele ɛmɔ kɛ: alɩɛ'n mɔ ɛmɔ 'di'n ɔ nʋn taladɩɛ'n mɔ ɛmɔ 'wula'n, nán bɛ susu yɩ́ nwʋn. ");
INSERT INTO any_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Ɔ sanlɩn kɛ ngʋan'n tɩ like cɩnnjɩn kpa ɔ tala alɩɛ'n. Yɛ̂ anwʋnnaan'n kʋsʋ tɩ cɩnnjɩn kpa ɔ tala taladɩɛ'n. ");
INSERT INTO any_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Ɛmɔ tʋ́ bɛ́ nyɩn bɛ nɩ́an mosunmosun kʋajɛ'n-mɔ. Bɛ nnua man like yɛ̂ bɛ ndɩ man like. Bɛ le man kunman anaan esie mɔ bɛ gua nun like ɔ, kʋsʋ Nyanmɩan ta bɛ́. Ɛmɔ anwʋn cian ɔ tala nnʋnman'n-mɔ! ");
INSERT INTO any_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Ɛmɔ anun benin yɛ̂ ɔ fa nzusue tʋ yɩ́ nwʋn an, ɔ 'cɛ asɩɛ nɩn asʋ ɔ? ");
INSERT INTO any_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Sɛ ɛmɔ ngʋala man m'ɔ tɩ kaan nɩn anun an, anɩn nzukɛ ati yɛ̂ ɛmɔ susu yɩ́ bʋ nga nɩn anwʋn ɔ? ");
INSERT INTO any_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“Ɛmɔ nɩ́an kɛ ebo nɩn anun ndile'n-mɔ mɔ bɛ le ndetele'n-mɔ kpɩn fifi'n. Bɛ nni man junman, bɛ nnwʋn man ɛtanlan. Nan kʋsʋ, mɩɩn kan mɩn kele ɛmɔ kɛ belemgbin Salomʋn muonun nʋn yɩ́ anyanbɛnwʋn'n m'ɔ nyanlɩn yɩ́'n, taladɩɛ m'ɔ tɩ kanlanman kɛ ndetele'n-mɔ, ɔ'a nwula man bie lé. ");
INSERT INTO any_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Ndile'n-mɔ mɔ bɛ wɔ ebo nɩn anun ɛnɛ, mɔ ɛhɩnman bɛ 'ju bɛ gua sɩ̂n nun'n, sɛ Nyanmɩan sesie bɛ́ sʋa, ɔ yɔ sɛ mɔ ɔ ngo nɩan man ɛmɔ ɔ ngɔ tala man bɛ́ ɔ? Ɛmɔ dedi'n tɩ kaan! ");
INSERT INTO any_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Yɩ́ ti, nán bɛ di yalɛ bɛ susu alɩɛ mɔ ɛmɔ di ɔ nʋn nzue mɔ ɛmɔ nʋn nɩn anwʋn. ");
INSERT INTO any_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Ɔ sanlɩn kɛ, ninnge sɔ'n-mɔ kʋalaatin, eyuadɩ nɩn anun menian'n-mɔ mɔ bɛ nzɩ man Nyanmɩan'n, bɛ́ yɛ̂ bɛ susu yɩ́ nwʋn ɔ. Nan ɛmɔ dɩɛ, ɛmɔ Asɩ'n sɩ kɛ ɛmɔ a hian yɩ́ nwʋn. ");
INSERT INTO any_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Ɛmɔ lí mʋa bɛ kpʋ́nndɛ Nyanmɩan Belemgbin Mân'n. Sɛ ɛmɔ nyan yɩ́ a, Nyanmɩan 'fa yɩ́ bʋ nga'n-mɔ kʋalaatin man ɛmɔ. ");
INSERT INTO any_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Ɛmɔ mɔ ɛmɔ tɩ kɛ ayɛmʋa kpule kaan'n, nán bɛ sulo. Ɔ sanlɩn kɛ ɔ'a yɔ Nyanmɩan fɛ kɛ ɛmɔ lí yɩ́ Belemgbin Mân'n bie. ");
INSERT INTO any_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","“Ɛmɔ tɔ́nɩn ɛmɔ anwʋndɩɛ'n-mɔ bɛ fá yɩ́ esika'n bɛ hyé ehianfʋɛ'n-mɔ. Ɛmɔ kpá esika kotoku m'ɔ ndɩtɩ man, mɔ nun esika'n nvo man bɛ síe Nyanmɩan Belemgbin Mân nɩn anun ɛlɔ. Awofʋɛ ngʋala man ɛlɔ kɔ kɔ wua, nvɔlɛ kʋsʋ ngʋala man yɩ́ di. ");
INSERT INTO any_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Afɩ, lɩka mɔ ɛmɔ anyanbɛnwʋn'n wɔ'n, ɛbɛlɛ kʋsʋ yɛ̂ ɛmɔ ahʋnlɩn'n wɔ ɔ. ");
INSERT INTO any_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Ɛmɔ wówula bɛ́ junman taladɩɛ'n, bɛ sʋ́sɔ bɛ́ kanlannɩɛ'n. ");
INSERT INTO any_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Ɛmɔ yɔ́ kɛ ngʋa mɔ bɛ́ mɩn a hɔ atɔnvɔlɛ mɔ bɛ lɛ nwʋnndɛ yɩ́ ɔ. Ɔ ju ɛbɛlɛ mɔ ɔ 'bɔ anʋan nɩn ala, anɩn b'a tike. ");
INSERT INTO any_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Nyila hán ngʋa ɛhɩ-mɔ mɔ bɛ́ mɩn 'ba a, anɩn bɛ lafɩlɩ man'n! Mɩɩn kan yɩ́ ananhɔlɛ mɩn kele ɛmɔ kɛ mɩnlɩan'n 'kaci yɩ́ nwʋn ɔ wula junman taladɩɛ. Ɔ 'man yɩ́ ngʋan'n-mɔ tɛtanlan asɩ tɔbɩlɩ nɩn a nwʋn ɔ man bɛ́ like bɛ di. ");
INSERT INTO any_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Sɛ ɔ sa ba alɩmunnun anaan alɩbahɩan nán ɔ ba tʋ bɛ́ kɛ bɛ lafɩlɩ man an, nyila hán bɛ́! ");
INSERT INTO any_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Ɛmɔ tɩ́ ɛjɔlɛ ɛhɩ abʋ kpa. Sɛ awulo nɩn asʋ mɩnlɩan'n sɩ dɔɛ'n mɔ awofʋɛ'n 'ba a, ahan ɔ nna man nán awofʋɛ nɩn a nyan atɩn a a bu yɩ́ sua nɩn anʋan'n. ");
INSERT INTO any_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Ɛmɔ kʋsʋ, ɛmɔ bɔ́bʋa bɛ́ nwʋn. Ɔ sanlɩn kɛ *Mân Baa'n 'ba a dɔɛ mɔ ɛmɔ nzusu man kɛ ɔ 'ba nɩn asʋ.” ");
INSERT INTO any_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Mɔ Zozi hanlɩn sɔ'n, Pɩɛlɩ kɔ bisa yɩ́ kɛ: “Yɛ́ Mɩn, asʋ yɛ́ ngʋnmɩn ala yɛ̂ ɛ lɛ bu anyɩnndala ɛhɩ ɛ kele yɛ́ ɔ, anaan ɛ lɛ bu kele menian'n-mɔ kʋalaatin ɔ?” ");
INSERT INTO any_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Yɛ́ Mɩn nwan: “Akʋa kpa'n m'ɔ sɩ ngɛlɛ'n y'ɔ le benin? Yɩ́ y'ɔ le nunhan'n mɔ yɩ́ mɩn'n 'fa yɩ́ awulo'n wula yɩ́ sa nun kɛ ɔ nɩ́an sʋ, ɛsɛ tɛmʋn'n ju a, ɔ mán yɩ́ manngʋn'n-mɔ alɩɛ. ");
INSERT INTO any_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Nyila hán akʋa sɔ'n mɔ yɩ́ mɩn 'ba ju a, anɩn yɩ́ sa wɔ́ yɩ́ nwʋn ɔ lɛ di yɩ́ junman'n! ");
INSERT INTO any_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Mɩɩn kan yɩ́ ananhɔlɛ mɩn kele ɛmɔ kɛ: yɩ́ mɩn'n 'fa yɩ́ nwʋn ninnge'n kʋalaatin wula yɩ́ sa nun. ");
INSERT INTO any_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Nan sɛ akʋa sɔ'n kan kele yɩ́ nwʋn kɛ: ‘Mɩ́n mɩn nyanlɩn walɩ man’, sɛ ɔ tɩ tɔ ngʋa ɛhɩnlɩn-mɔ asʋ ɔ bʋ bɛ́, sɛ ɔ didi, sɛ ɔ nʋn nzan ɔ bʋ a, ");
INSERT INTO any_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","yɩ́ mɩn'n 'ba cɩan ɔ nʋn dɔɛ m'ɔ nzusu man nɩn asʋ. Ɔ 'pinnin akʋa sɔ'n kpa. Ɔ m'an ɔ nwun yalɛ kɛ ngʋa'n-mɔ mɔ bɛ bɔ bala ɛtɛ'n nwun yɩ́'n. ");
INSERT INTO any_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Akʋa m'ɔ sɩ like mɔ yɩ́ mɩn kulo, m'ɔ nzesie man yɩ́ nwʋn ɔ nyɔ man like sɔ'n, bɛ 'fin yɩ́ sʋnman. ");
INSERT INTO any_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Akʋa kʋsʋ m'ɔ nzɩ man like mɔ yɩ́ mɩn kulo, m'ɔ kɔ yɔ like sɔ'n m'ɔ di ɛbʋ́ɛ'n, bɛ 'gonun bɛ fin yɩ́. Sʋanlan mɔ bɛ kɔ man yɩ́ ninnge dɔʋn'n, bɛ 'bisa yɩ́ dɔʋn. Sʋanlan kʋsʋ mɔ bɛ kɔ fa ninnge dɔʋn bɛ kɔ wula yɩ́ sa nun'n, bɛ 'bisa yɩ́ dɔʋn m'ɔ tala sʋ.” ");
INSERT INTO any_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Mɔ Zozi hanlɩn sɔ yuelɩ'n, ɛsɛ yɩ́ nwan: “M'an a m'an ju sɩ̂n m'an tʋ asɩɛ nɩn asʋ. Mɩn kulo kɛ ahan ɔ'a sɔ dada angʋnmɩn! ");
INSERT INTO any_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Ɛsɔnɩan kʋn mɔ bɛ lɛ ba sɔnɩn mɩn'n, ɔ 'ka mɩ́n ngʋnmɩn an, ahan b'a sɔnɩn mɩ́n a yue! ");
INSERT INTO any_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Ɛmɔ jʋnlɩn kɛ m malɩ menian'n-mɔ anzʋnunjɔ ɛman asɩɛ nɩn asʋ ɛwa ɔ? Mɩn 'bua ɛmɔ kɛ cɛcɛ, nan m malɩ bɛ́ afian ɛsɛcɩɛ. ");
INSERT INTO any_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Ɔ fi ɛnɛ m'ɔ kɔ'n, menian nnun mɔ bɛ wɔ awulo kʋn anun'n 'ba bu bɛ́ nwʋn nun. Menian nsan 'ba han bɔ nun bɛ nʋn nnyuan jinlan sʋ. Nnyuan'n kʋsʋ abʋ 'ba yɔ kʋn bɛ nʋn nsan'n jinlan sʋ. ");
INSERT INTO any_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Sɩɛ'n nʋn yɩ́ wa belenzua'n 'ba fʋ sʋ. Baa belenzua'n kʋsʋ nʋn yɩ́ sɩ 'ba fʋ sʋ. Nian'n nʋn yɩ́ wa balasua'n 'ba jinlan sʋ. Baa balasua'n kʋsʋ nʋn yɩ́ nin 'ba jinlan sʋ. Ahelenian'n nʋn yɩ́ helenin 'ba fʋ sʋ. Yɩ́ helenin'n kʋsʋ nʋn yɩ́ 'ba fʋ sʋ.” ");
INSERT INTO any_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Ɛsɛ Zozi kɔ han kɔ hele meninsʋnman'n kɛ: “Sɛ ɛmɔ nwun kɛ esue nɩn a munlan lɩka mɔ sɛnzɛ'n tɔ nɩn an, anɩn ɛmɔ nwan esue'n lɛ ba tɔ. Sakpa kʋsʋ, ɔ tɔ. ");
INSERT INTO any_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Yɛ̂ sɛ ɛmɔ nwun kɛ anwʋnman fi ngʋa ɔ fita kɔ sɔlɔ a, anɩn ɛmɔ nwan wawa'n lɛ ba kpɩn. Sakpa kʋsʋ, ɔ kpɩn. ");
INSERT INTO any_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Apoo mma! Ɛmɔ sɩ anwunno nʋn asɩ nzɔlɛ'n-mɔ ngʋnmɩn ngʋnmɩn. Nan ɔ yɔ sɛ mɔ ɛmɔ nnwun man mɛlɛ'n mɔ yɛ wɔ nun'n nzɔlɛ nɩn angʋnmɩn ɔ? ");
INSERT INTO any_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Nzukɛ ati yɛ̂ ɛmɔ muonun njʋnlɩn man, bɛ nyɔ man like m'ɔ sɛ kɛ bɛ yɔ'n? ");
INSERT INTO any_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Sɛ sʋanlan bie kɔ sanman wɔ́ a, mɛlɛ mɔ ɛ nʋn yɩ́ lɛ kɔ a yɩ ndɛɛ'n, bɔ mɔndɩnlɩn ɛ nʋn yɩ́ bɛ sésie bɛ́ afian. Sɛ a nyɔ man yɩ́ sɔ nán ɔ nʋn wɔ́ kɔ sʋanlan'n m'ɔ di ɛjɔlɛ nɩn aja sʋ a, sʋanlan'n m'ɔ di ɛjɔlɛ'n 'fa wɔ́ wula nzalafʋ'n-mɔ asa nun. Nzalafʋ'n-mɔ kʋsʋ 'tʋ wɔ́ fiadɩ. ");
INSERT INTO any_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Mɩɩn kan yɩ́ ananhɔlɛ mɩn kele wɔ́ kɛ, sɛ kalɛ babulu kʋn ka nán ɛ tualɩ yuelɩ man an, ɛ 'ka fiadɩ sua nɩn anun ɛbɛlɛ.” ");
INSERT INTO any_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Mɛlɛ sɔ nɩn anun, menian mmie-mɔ kɔ a kɔ han kɔ hele Zozi kɛ: “Kpain, anɩn Galile menian lɛ yɩ tɛɛ bɛ man Nyanmɩan. *Lɔmʋn kʋnmanna Pilatɩ kɔ man bɛ kɔ hun bɛ́.” ");
INSERT INTO any_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Zozi kɔ bisa kɛ: “Ɛmɔ jʋnlɩn kɛ kɛmɔ b'a hun bɛ́ sɔ nɩn ati, anɩn ɔ kele kɛ bɛ tɩ ɛtɛfʋɛ bɛ tala Galile mân nɩn anun menian bʋ nga'n-mɔ kʋalaatin ɔ? ");
INSERT INTO any_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Cɛcɛ. Nan mɩɩn kan mɩn kele ɛmɔ kɛ, sɛ ɛmɔ a nnun man bɛ́ nwʋn b'a ngaci man bɛ́ abalabɔ nɩn an, ɛmɔ kʋsʋ kʋalaatin 'wu kɛ bɛ́. ");
INSERT INTO any_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Menian bulu nʋn mɔcʋɛ'n kʋsʋ mɔ Silowe sua hyilili'n buli gualɩ bɛ́ sʋ ɔ hunlin bɛ́'n, ɛmɔ de di kɛ bɛ tɩ ɛtɛfʋɛ bɛ tala Zoluzalɛmʋn ɛbɛlɛ menian bʋ nga'n kʋalaatin ɔ? ");
INSERT INTO any_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Cɛcɛ. Nan mɩɩn kan mɩn kele ɛmɔ kɛ, sɛ ɛmɔ a nnun man bɛ́ nwʋn b'a ngaci man bɛ́ abalabɔ nɩn an, ɛmɔ kʋsʋ kʋalaatin 'wu kɛ bɛ́.” ");
INSERT INTO any_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Mɔ Zozi hanlɩn sɔ yuelɩ'n, ɔ kɔ bu anyɩnndala ɛhɩ ɔ kɔ hele bɛ́. Yɩ́ nwan: “Bian kʋn kɔ lua *figi baka kʋn yɩ́ divɩn ebo nɩn asʋ. Ɛlɛhʋn kʋn, ɔ kɔ hɔ kɔ nɛnɩan sɛ ɔ kɔ nyan figi mma sʋ o. Ɔ hɔlɩ o, ɔ ngɔ nyan man bie sʋ. ");
INSERT INTO any_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Ɛhɩ a, bian'n kɔ han kɔ hele sʋanlan'n m'ɔ tɩ yɩ́ ebo'n kɛ: ‘Yɩ́ afʋɛ nsan ahɩ. Mɩn kɔ figi baka nɩn abʋ ɛlɔ, kʋsʋ mɩn nnyan man bie sʋ. Yɩ́ ti, bu yɩ́ tʋ. Afɩ, mɩn nnwun man like ati m'ɔ man ɔ jin ɛwa ɔ.’ ");
INSERT INTO any_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","“Mɔ bian'n hanlɩn sɔ'n, sʋanlan'n m'ɔ nɩan ebo nɩn asʋ'n nwan: ‘Kpain, yaci yɩ́ maan ɔ jínlan ɛbɛlɛ afʋɛ ɛhɩ biekun. Mɩn 'ba fufun yɩ́ nwʋn mɩn gugua yɩ́ bʋ ewula. ");
INSERT INTO any_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Ɛ 'su yɩ́ akpʋlʋwa a, afʋɛ biekun ɔ 'ba su. Sɛ ɔ'a nzu man an, ɛ kɔ man bɛ kɔ bu yɩ́.’” ");
INSERT INTO any_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Ɛlɛhʋn kʋn, anɩn Zozi lɛ kele menian'n-mɔ ninnge Zufʋ'n-mɔ asɔnɩn sua kʋn anun. ");
INSERT INTO any_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Ɔ 'ba yɔ sɔ'n, anɩn balasua kʋn kʋsʋ wɔ asɔnɩn sua nɩn anun ɛbɛlɛ bie. Balasua sɔ'n ndɩ man akpɔlɛ yɩ́ afʋɛ bulu ɔ nʋn mɔcʋɛ ahɩ. Wawɛ ɛtɛ'n m'ɔ di junman sɔ nɩn a man balasua nɩn a hʋlʋ sʋ. Ɔ ngʋala man yɩ́ nwʋn nun tɩnngɛ. ");
INSERT INTO any_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Nan mɔ Zozi nwunlin balasua sɔ'n, ɔ kɔ fɛlɛ yɩ́ ɔ kɔ han kɔ hele yɩ́ kɛ: “Balasua, wɔ́ nwʋn a sa!” ");
INSERT INTO any_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Zozi kɔ fa yɩ́ sa'n kɔ fua balasua nɩn anwʋn. Ɛbɛlɛ ala, balasua'n kɔ tɩnngɛ yɩ́ nwʋn nun, ɔ kɔ yɩ Nyanmɩan ayɛ. ");
INSERT INTO any_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","M'ɔ yɔlɩ sɔ'n, asɔnɩn sua nɩn asʋ kpain'n kɔ fɛ Zozi anwʋn ɛya. Ɔ sanlɩn kɛ ɔ'a man balasua nɩn anwʋn a sa *ɛnwʋnmɩan ele cɩan nɩn anun. Ɛhɩ a, ɔ kɔ jasʋ ɔ kɔ han kɔ hele bagua'n kɛ: “Junman elie tɛmʋn'n tɩ elesian. Ɛmɔ bála tɛmʋn sɔ'n bɛ mán bɛ́ nwʋn sá. Nan nán ɛnwʋnmɩan ele cɩan nɩn anun yɛ̂ bɛ fa bɛ di junman sɔ nɩn ɔ!” ");
INSERT INTO any_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Yɛ́ Mɩn kɔ totua yɩ́ sʋ, yɩ́ nwan: “Apoo mma tɩ kɛ ɛmɔ! ɛnwʋnmɩan ele cɩan'n, ɛmɔ nunhan kʋn biala nyannjɩ yɩ́ ɛnalɛ anaan yɩ́ afunlunmun'n maan ɔ kɔ nʋn nzue. Sɛ ato e? ");
INSERT INTO any_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Balasua ɛhɩ kʋsʋ m'ɔ tɩ Abalahamʋn abie, mɔ *Satan a cɩcɩ yɩ́ dede afʋɛ bulu nʋn mɔcʋɛ'n, asʋ nán ɛnwʋnmɩan ele cɩan yɛ̂ ɔ fata kɛ bɛ nyannjɩ yɩ́ ɔ?” ");
INSERT INTO any_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Zozi mmua sɔ'n kɔ man anyunnunguasɩɛ kɔ han bɛ́ mɔ bɛ kpɔ yɩ́'n-mɔ. Nan bagua'n dɩɛ, ɛnyɩnmɩan junman'n kʋalaa mɔ Zozi lili'n yɔlɩ bɛ́ fɛ. ");
INSERT INTO any_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Ɛhɩ anzin, Zozi kɔ han kɔ hele bagua'n kɛ: “Nzu like dɩɛ yɛ̂ Nyanmɩan Belemgbin Mân'n soman yɩ́ ɔ? Nzu yɛ̂ mɩn kʋala kɛ mɩn fa mɩn susu yɩ́ ɔ? ");
INSERT INTO any_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Nyanmɩan Belemgbin Mân'n soman muntadɩ baa mɔ sʋanlan kʋn a lua yɩ́ tola nun ɔ. Muntadɩ baa sɔ nɩn a fifi ɔ a kaci dukpa. Nnʋnman'n-mɔ a nwʋn bɛ́ sâ yɩ́ sa mma'n-mɔ asʋ” ");
INSERT INTO any_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Ɛsɛ Zozi kɔ bu anyɩnndala kʋn biekun kɔ hele bɛ́ kɛ: “Nzu yɛ̂ mɩn kʋala kɛ mɩn fa Nyanmɩan Belemgbin Mân'n mɩn susu yɩ́ ɔ? ");
INSERT INTO any_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Ɔ tɩ kɛ fali ayile mɔ balasua kʋn a fa a fɔtɔ fali cilo abulaa ɔ nʋn nnun dede yɩ́ kʋalaa a tu ɔ.” ");
INSERT INTO any_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Ɛhɩ, anɩn Zozi aja wɔ atunnun ɔ lɛ kɔ Zoluzalɛmʋn. Atɩn nɩn asʋ kulo mgbili mgbili'n-mɔ ɔ nʋn nganngan'n-mɔ, ɔ kɔ sɩsɩn bɛ́ sʋ ɔ kɔ hehele menian'n-mɔ ninnge. ");
INSERT INTO any_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Bian kʋn kɔ bisa yɩ́ kɛ: “Yɛmɩnlɩn, asʋ menian kaan sʋa yɛ̂ bɛ 'nyan bɛ́ ti ɔ?” Ɛhɩ a, Zozi kɔ han kɔ hele bɛ́ kʋalaatin kɛ: ");
INSERT INTO any_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Ɛmɔ bɔ́ mɔndɩnlɩn kpa bɛ sɩ́n anʋan fɩtɩɩ nɩn anun. Afɩ, mɩɩn kan yɩ́ ananhɔlɛ mɩn kele ɛmɔ kɛ menian dɔʋn 'ba kpʋnndɛ atɩn bɛ bu sʋ, kʋsʋ bɛ ngɔ hʋala man Nyanmɩan Belemgbin Mân nɩn anun ɛlɔ kɔ. ");
INSERT INTO any_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Mɔ awulo nɩn asʋ mɩnlɩan'n 'ba jasʋ ɔ tʋ anʋan nɩn anun'n, ɛmɔ 'ba ha anʋan nzin. Ɛmɔ 'ba jinlan bɛ bɔ anʋan'n bɛ kan kɛ: ‘Yɛmɩnlɩn, tike yɛ́ anʋan.’ “Mɩnlɩan'n 'ba bua ɛmɔ kɛ: ‘Mɩn nzɩ man ɛmɔ lɩka mɔ ɛmɔ fi ɔ.’ ");
INSERT INTO any_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","“Ɛmɔ 'ba se yɩ́ kɛ: ‘Yɛ́ nʋn wɔ́ y'a didi, yɛ́ nʋn wɔ́ y'a nʋn nzue, a hehele yɛ́ ninnge yɛ́ kulo'n-mɔ gua'n-mɔ asʋ.’ ");
INSERT INTO any_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","“Yɩ́ kʋsʋ ɔ 'ba bua ɛmɔ kɛ: ‘Mɩɩn kan yɩ́ ananhɔlɛ mɩn kele ɛmɔ kɛ mɩn nzɩ man ɛmɔ lɩka mɔ ɛmɔ fi ɔ. Nyɔlɩɛtɛfʋɛ, ɛmɔ fi mɩ́n nwʋn ɛwa bɛ hɔ́ mʋa!’ ");
INSERT INTO any_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Mɛlɛ mɔ ɛmɔ 'ba nwun Abalahamʋn, Izakɩ, Zʋakɔbʋ nʋn Nyanmɩan mgbɔmanfʋɛ'n-mɔ kʋalaatin yɩ́ belemgbin mân nɩn anun ɛlɔ, mɔ ɛmɔ dɩɛ bɛ 'ba hɩhan ɛmɔ bɛ tʋ gua sʋ'n, mɛlɛ sɔ nɩn anun yɛ̂ ɛmɔ 'ba sun bɛ kʋan bɛ́ je nɩn ɔ! ");
INSERT INTO any_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Menian mmie-mɔ fi sɛnzɛ nɩn afitelɩɛ nʋn yɩ́ atɔlɩɛ, mmie-mɔ fi sɔlɔ nʋn ngʋa, bɛ́ nʋn Nyanmɩan bɛ 'ba tanlan tɔbɩlɩ kʋn anwʋn yɩ́ belemgbin mân nɩn anun ɛlɔ. ");
INSERT INTO any_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Tɛmʋn sɔ'n, bɛ́ mɔ ɛnɛ bɛ li menian'n-mɔ anzin'n, bɛ 'ba li bɛ́ ti. Yɛ̂ bɛ́ mɔ ɛnɛ bɛ li menian'n-mɔ ati'n, bɛ 'ba li bɛ́ nzin.” ");
INSERT INTO any_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Cɩan kʋnmgba sɔ'n, *Falisifʋɛ mmie-mɔ walɩ tʋlɩ Zozi a, bɛ́ nwan: “Kpain, belemgbin *Elɔdɩ nwan ɔ nyan wɔ́ a, ɔ 'man bɛ kun wɔ́. Yɩ́ ti, fi ɛwa jasʋ kɔ.” ");
INSERT INTO any_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Zozi kɔ bua bɛ́ kɛ: “Ɛmɔ hɔ́ hán héle aminsanɩn sɔ'n kɛ: ‘Mɩɩn fʋan wawɛ ɛtɛ'n-mɔ ɛnɛ nʋn ɛhɩnman mɩn man menian'n-mɔ anwʋn sa. Yɩ́ cɩan nsan nɩn asʋ, mɩn 'gua mɩ́n junman nɩn abʋ.’ ");
INSERT INTO any_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Kʋsʋ, ɔ fata kɛ mɩn tu atɩn ɛnɛ, ɛhɩnman nʋn ɛhɩnman nzin. Afɩ, ɔ nzɛ nvata man kɛ Nyanmɩan kpɔmanfʋɛ kʋn wú ahanmɩan cɛlɛkɛ Zoluzalɛmʋn. ");
INSERT INTO any_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“Zoluzalɛmʋn, Zoluzalɛmʋn, wɔ́ mɔ ɛ kun Nyanmɩan mgbɔmanfʋɛ'n-mɔ, mɔ ɛ tʋtʋ bɛ́ mɔ ɔ kɔ sʋan bɛ́ wɔ́ nwʋn ɛlɔ nɩn ɛbʋɛ ɛ kun bɛ́'n, yɩ́ kpɛ̂ nyɛ ahɩ! N gulolɩ kɛ ahan mɩn kokuan wɔ́ mma'n-mɔ anʋan kɛ akɔ ɛta'n kokuan yɩ́ mma'n-mɔ anʋan yɩ́ ndɛba nɩn abʋ'n. Kʋsʋ a ndie man. ");
INSERT INTO any_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Yɩ́ ti, bɛ 'ba yaci ɛmɔ awulo'n bɛ wula ɛmɔ asa nun. Nan kʋsʋ, mɩɩn kan yɩ́ ananhɔlɛ mɩn kele ɛmɔ kɛ ɛmɔ lɛ ngɔ nwun man mɩ́n nwʋn kʋ́n dede ɔ 'ju cɩan mɔ ɛmɔ 'se kɛ: ‘Nyila hán sʋanlan'n m'ɔ lɛ ba wɔ yɛ́ Mɩn dunman nun!’” ");
INSERT INTO any_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","*Ɛnwʋnmɩan ele cɩan kʋn, *Falisifʋɛ'n-mɔ asʋ kpain kʋn kɔ fɛlɛ Zozi alɩɛ. Ɛhɩ a, Falisifʋɛ'n-mɔ mɔ bɛ wɔ ɛbɛlɛ'n, bɛ lɛ nɩan sɛ Zozi kɔ fʋn bɛ́ mala nɩn an. ");
INSERT INTO any_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Ɛbɛlɛ ala, bian kʋn kɔ a kɔ jinlan Zozi anyunnun. Bian sɔ nɩn a yiyi. ");
INSERT INTO any_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Zozi kukuli yɩ́ nʋan sʋ, ɔ kɔ bisa mala nɩn asʋ mgbain'n-mɔ ɔ nʋn Falisifʋɛ'n-mɔ kɛ: “Asʋ yɛ̂ mala'n man atɩn kɛ bɛ mán sʋanlan tɩ́ akpɔlɛ anaan n'ɔ tɩ akpɔlɛ ɛnwʋnmɩan ele cɩan nɩn anun ɔ?” ");
INSERT INTO any_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Mɔ Zozi bisalɩ bɛ́ kosuan sɔ'n, bɛ ngɔ bua yɩ́ bie. Ɛhɩ a, Zozi kɔ fa yɩ́ sa'n kɔ fua wuluwafʋɛ nɩn anwʋn ɔ kɔ man yɩ́ nwʋn kɔ sa. Ɔ kɔ han kɔ hele yɩ́ kɛ ɔ hɔ́ awulo. ");
INSERT INTO any_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Mɔ Zozi yɔlɩ sɔ yuelɩ'n, ɔ kacili yɩ́ nyɩn bɛ́ nwʋn ɛlɔ a, yɩ́ nwan: “Ɛmɔ nunhan benin yɛ̂ sɛ yɩ́ wa kʋn anaan yɩ́ ɛnalɛ kʋn tɔ bula nun ɛnwʋnmɩan ele cɩan nɩn an, ɔ nyɩ man yɩ́ ndɛ ndɛ ɔ?” ");
INSERT INTO any_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Ɛjɔlɛ kpɔlɛ ɛhɩ, b'a ngʋala man bie bua. ");
INSERT INTO any_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Mɛlɛ mɔ bɛ 'ba tɛtanlan tɔbɩlɩ nɩn anwʋn bɛ di alɩɛ'n, Zozi nwunlin kɛ bɛ́ mɔ bɛ tʋlɩ bɛ́ sa bɛ fɛlɛlɩ bɛ́ alɩɛ'n, biala lɛ kpʋnndɛ meninkpa lɩka ɔ tanlan. ");
INSERT INTO any_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","Ɛhɩ a, Zozi kɔ bu anyɩnndala kʋn ɔ kɔ hele bɛ́. Yɩ́ nwan: “Sɛ sʋanlan tʋ yɩ́ sa fɛlɛ wɔ́ atɔnvɔlɛ alɩɛ a, n'ɛ kɔ tanlan meninkpa lɩka. Ɛ 'su yɩ́ akpʋlʋwa a, b'a fɛlɛ sʋanlan bie kʋsʋ m'ɔ tɩ kpili tala wɔ́. ");
INSERT INTO any_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Sʋanlan'n mɔ ɔ'a fɛlɛ ɛmɔ munnyuan'n ba tʋ wɔ́ a, yɩ́ nwan: ‘Ao, jasʋ maan ɔ tánlan ɛbɛlɛ.’ Sian anɩn afɩ wɔ́ nyunnun nyian, bɔʋn-bɔʋn, ɛ lɛ kɔ a tanlan bɛ́ nzin. ");
INSERT INTO any_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Nan sɛ bɛ tʋ bɛ́ sa bɛ fɛlɛ wɔ́ a, wɔ́ lɩlɩ tanlan bɛ́ nzin. Sʋanlan'n m'ɔ fɛlɛlɩ wɔ́'n nwun wɔ́ a, ɔ 'kan kele wɔ́ kɛ: ‘Eja, bala bɛ́ nyunnun ɛwa.’ Ɛbɛlɛ nɩn anun, anɩn wɔ́ nyunnun a kpaja wɔ́ bɛ́ mɔ ɛ nʋn bɛ́ bɛ gua tɔbɩlɩ nɩn anwʋn nɩn anyunnun. ");
INSERT INTO any_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Ɔ sanlɩn kɛ sʋanlan biala m'ɔ kɔ kuku yɩ́ nwʋn sʋ'n, bɛ 'kan yɩ́ asɩ. Sʋanlan kʋsʋ m'ɔ kɔ han yɩ́ nwʋn asɩ'n, bɛ 'kuku yɩ́ sʋ.” ");
INSERT INTO any_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Mɔ Zozi buli anyɩnndala sɔ'n yuelɩ'n, ɔ kɔ han kɔ hele bian'n m'ɔ fɛlɛlɩ yɩ́ alɩɛ'n kɛ: “Eyua o, nɔsʋba o, sɛ ɛ 'fɛlɛ menian alɩlie a, n'ɛ fɛlɛ wɔ́ manngʋn-mɔ, wɔ́ nianman-mɔ, wɔ́ nwʋn amma-mɔ anaan esikafʋɛ-mɔ mɔ bɛ mantan mantan wɔ́'n. Ɔ sanlɩn kɛ bɛ́ kʋsʋ bɛ kʋala kɛ bɛ fɛlɛ wɔ́ alɩɛ bɛ tua wɔ́ dɩɛ'n kalɛ. ");
INSERT INTO any_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Nan sɛ ɛ 'fɛlɛ menian alɩlie a, fɛlɛ ehianfʋɛ'n-mɔ, bubuluwafʋɛ'n-mɔ, bɛ́ mɔ bɛ tia bɛ tɔ sʋ'n-mɔ ɔ nʋn anyɩnsinlinwafʋɛ'n-mɔ. ");
INSERT INTO any_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Nyila 'kan wɔ́. Ɔ sanlɩn kɛ bɛ ngɔ nyan man yɩ́ nwʋn sʋ like bɛ ngɔ mman man wɔ́. Nan mɛlɛ mɔ Nyanmɩan 'ba man bɛ́ mɔ bɛ yɔlɩ ye'n fi ewue nun tinnge'n, mɛlɛ sɔ'n yɛ̂ Nyanmɩan 'man wɔ́ yɩ́ nwʋn ahatua ɔ.” ");
INSERT INTO any_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Mɔ bɛ́ mɔ bɛ gugua tɔbɩlɩ nɩn anwʋn'n tɩlɩ ɛjɔlɛ sɔ'n-mɔ'n, bɛ́ nunhan kʋn kɔ han kɔ hele Zozi kɛ: “Nyila hán sʋanlan m'ɔ kɔ li like Nyanmɩan Belemgbin Mân nɩn anun ɛlɔ'n!” ");
INSERT INTO any_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","M'ɔ hanlɩn sɔ'n, Zozi kɔ bu anyɩnndala ɛhɩ ɔ kɔ hele yɩ́. Yɩ́ nwan: “Bian kʋn tʋnlɩn alɩɛ kpili kpa. Ɔ kɔ fɛfɛlɛ menian dɔʋn kpa. ");
INSERT INTO any_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Mɛlɛ mɔ bɛ yuelɩ alɩɛ'n tʋn'n, ɔ kɔ sʋan yɩ́ akʋa'n kɛ ɔ hɔ́ sé menian'n-mɔ kɛ: ‘Ɛmɔ bála nán kɩkaala dɩɛ, alɩɛ nɩn a bɩn.’ ");
INSERT INTO any_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","“Akʋa'n hɔlɩ fɛlɛlɩ bɛ́ a, bɛ́ kʋalaa bɛ kɔ bɔ bɛ kɔ yɩ. Sʋanlan'n mɔ akʋa'n lili mʋa fɛlɛlɩ yɩ́'n nwan: ‘M'an to ebo kʋn. Ɔ di kɛ mɩn kɔ mɩn nɩan. Yɩ́ ti, yaci, n'ɛ fɛ ɛya.’ ");
INSERT INTO any_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","“Kʋn nwan: ‘M'an to nnalɛ bulu. Ɛnɛ dein ɔ di kɛ mɩn kɔ mɩn nɩan sɛ bɛ kʋala junman di a. Yɩ́ ti, yaci, n'ɛ fɛ ɛya.’ ");
INSERT INTO any_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","“Nunhan kʋn biekun kʋsʋ nwan: ‘Bɛlɛ mɔ m'an fa mɩ́n yɩ atɔnvɔlɛ ɔ. Mɩn ngɔ hʋala man kɔ.’ ");
INSERT INTO any_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Akʋa'n kɔ sa kɔ hɔ kɔ bɔ kʋalaa kʋalaa kɔ hele yɩ́ mɩn'n. Yɩ́ mɩn'n kɔ fɛ ɛya, ɔ kɔ han kɔ hele yɩ́ kɛ: ‘Kan wɔ́ nwʋn kɔ gua nɩn asʋ ɛlɔ kɔ fɛfɛlɛ ehianfʋɛ'n-mɔ, bubuluwafʋɛ'n-mɔ, anyɩnsinlinwafʋɛ'n-mɔ ɔ nʋn bɛ́ mɔ bɛ tia bɛ tɔ sʋ'n-mɔ maan bɛ bála ɛwa.’ ");
INSERT INTO any_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","“Akʋa'n kɔ hɔ. Kaan cɛ, ɔ kɔ a kɔ tʋ yɩ́ mɩn'n. Yɩ́ nwan: ‘Kpain, junman'n mɔ ɛ helelɩ mɩ́n'n, m'an li a yue, kʋsʋ lɩka biekun tɛ wɔ ɛbɛlɛ.’ ");
INSERT INTO any_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","“Ɛhɩ a, mɩnlɩan'n kɔ han kɔ hele yɩ́ akʋa'n kɛ: ‘Fa nanmue nanmue atɩn'n-mɔ, san ɛnwanlan'n-mɔ, sʋanlan biala mɔ ɛ nʋn yɩ́ kɔ yia'n, tinndin yɩ́ maan ɔ bála. Yɔ bɛ́ sɔ dede maan sua'n yí. ");
INSERT INTO any_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Mɩɩn kan mɩn kele ɛmɔ kɛ: Bɛ́ mɔ n nili mʋa n vɛlɛlɩ bɛ́ mɔ b'a mma man'n, bɛ́ nun fɩ́ɩ́ nni man mɩ́n alɩɛ'n bie!’” ");
INSERT INTO any_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Ɛhɩ, anɩn Zozi nʋn menian dɔʋn kpa aja wɔ atunnun. Ɔ kpɛlɩ yɩ́ nyɩn bɛ́ nwʋn ɛlɔ a, yɩ́ nwan: ");
INSERT INTO any_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","Sʋanlan mɔ yɩ́ nwan ɔ 'si mɩ́n sʋ'n, sɛ ɔ kulo yɩ́ sɩ, yɩ́ nin, yɩ́ yɩ, yɩ́ mma, yɩ́ nianman mmelenzua nʋn mmalasua ɔ nʋn yɩ́ muonun yɩ́ nwʋn ɔ tala mɩ́n an, sʋanlan sɔ'n ngʋala ɔ ngaci man mɩ́n sʋanlan. ");
INSERT INTO any_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Sʋanlan kʋsʋ m'ɔ nva man yɩ́ kʋlʋwa'n ɔ ndʋ man yɩ́ kɔmɩn sʋ ɔ nzi man mɩ́n sʋ'n, sʋanlan sɔ'n ngʋala ɔ ngaci man mɩ́n sʋanlan. ");
INSERT INTO any_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Sɛ ɛmɔ anun kʋn kulo kɛ ɔ si sua hyilili kʋn an, ɔ di mʋa ɔ tanlan asɩ ɔ tɩtɩ ɔ nɩan sɛ esika'n m'ɔ le yɩ́'n kɔ sa sua'n si e sɛ se e. ");
INSERT INTO any_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Ɔ'a ndɩtɩ ɔ'a nnɩan man sɛ ɔ bɔ sua nɩn abʋ nan ɔ a ngʋala man yɩ́ si a, bɛ́ kʋalaa mɔ bɛ kɔ nwun kɛ sua nɩn a ha ɛbɛlɛ'n, bɛ 'sɩlɩ yɩ́. ");
INSERT INTO any_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Bɛ kan kɛ: ‘Bian ɛhɩ a bɔ sua esie abʋ kʋsʋ ɔ'a ngʋala man yɩ́ bʋ gua!’ ");
INSERT INTO any_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Yɩ́ sɔ kʋsʋ ala, sɛ belemgbin kʋn kulo kɛ ɔ nʋn yɩ́ manngʋn kʋn ɛlɔɛ a, ɔ di mʋa ɔ tanlan asɩ ɔ tɩtɩ nɩan sɛ ɔ kʋala kɛ ɔ fa menian akpɩɩ bulu ɔ kɔ tʋa yɩ́ manngʋn'n m'ɔ le menian akpɩɩ abulaa'n bɛ kʋn an. ");
INSERT INTO any_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Sɛ ɔ nɩan nán ɔ ngʋala man yɩ́ sɔ yɔ a, mɛlɛ mɔ belemgbin ɛhɩnlɩn tɛ wɔ mʋa'n, ɔ yɩ menian maan bɛ kɔ li yɩ́ mgbata bɛ sesie bɛ́ afian. ");
INSERT INTO any_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Ɛhɩka ati, sʋanlan mɔ ɔ'a nyaci man ninnge'n m'ɔ le yɩ́'n ɔ'a ngua man'n, sʋanlan sɔ'n ngʋala ɔ ngaci man mɩ́n sʋanlan. ");
INSERT INTO any_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Njɩn'n tɩ like kpa. Nan kʋsʋ sɛ ɔ yɔ talɛ a, bɛ 'yɔ sɛ nán ɔ'a yɔ kpa biekun? ");
INSERT INTO any_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Bɛ ngʋala man yɩ́ fa tʋn alɩɛ, bɛ ngʋala man yɩ́ fa gua ninnge'n-mɔ anun. Asɩ ala yɛ̂ bɛ ju bɛ gua ɔ. M'ɔ sɩ fasie'n, ɔ fá ɛjɔlɛ sɔ'n ɔ síe!” ");
INSERT INTO any_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Ɛlɛhʋn kʋn, bɛ́ mɔ bɛ dide ajule'n nʋn bɛ́ mɔ bɛ bɔ bɛ́ dunman ɛtɛ'n dɔʋn kpa kɔ a Zozi anwʋn ɛbɛlɛ. Bɛ lɛ ba tie ɛjɔlɛ'n m'ɔ kan'n. ");
INSERT INTO any_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Nan mɔ *Falisifʋɛ'n-mɔ nʋn *mala nɩn asʋ mgbain'n-mɔ nwunlin yɩ́ sɔ'n, bɛ kɔ fɛ ɛya. Bɛ́ nwan: “Bian ɛhɩ dɩɛ, ɔ sɔ ɛtɛfʋɛ'n-mɔ anun, ɛsɛ ɔ nʋn bɛ́ yɛ̂ bɛ didi ɔ!” ");
INSERT INTO any_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Ɛhɩ a, Zozi kɔ bu anyɩnndala ɛhɩ ɔ kɔ hele bɛ́. Yɩ́ nwan: ");
INSERT INTO any_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Yɛ bú yɩ́ kɛ ɛmɔ anun kʋn le mmʋa ɛya kʋn. Sɛ kʋn minlin nun an, asʋ ɔ nyaci man abulahʋanlan nʋn ngʋanlan'n bɛ́ adidie lɩka ɛbɛlɛ, ɔ ngɔ mgbʋnndɛ man ɛhɩnlɩn dede ɔ nnwun man yɩ́ ɔ? ");
INSERT INTO any_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Mɛlɛ m'ɔ kɔ nwun yɩ́'n, ɔ di fɛ kpa ɔ fa yɩ́ tʋ yɩ́ kɔmɩn sʋ. ");
INSERT INTO any_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Ɔ ju awulo a, ɔ fɛfɛlɛ yɩ́ manngʋn-mɔ nʋn bɛ́ mɔ bɛ mantan mantan yɩ́ nwʋn ɛbɛlɛ'n, ɔ kan kele bɛ́ kɛ: ‘Ɛmɔ bála maan yɛ lí ndutue. Ɔ sanlɩn kɛ m'an nwun mɩ́n bʋa'n m'ɔ minlinlin'n!’ ");
INSERT INTO any_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Mɩɩn kan mɩn kele ɛmɔ kɛ nyanmɩansʋ ɛlɔ, kɛ ɔ tɩ yɩ́ nɩn ala anɩn. Sɛ ɛtɛfʋɛ kʋnmgba cein nun yɩ́ nwʋn ɔ yaci yɩ́ nyɔlɩɛ ɛtɛ'n-mɔ a, yɩ́ dunman nun, bɛ di ndutue kpili kpa nyanmɩansʋ ɛlɔ ɔ tala sɛsɛfʋɛ abulahʋanlan nʋn ngʋanlan mɔ b'a nun bɛ́ nwʋn b'a yaci bɛ́ nyɔlɩɛ ɛtɛ'n-mɔ ndutue dɩɛ'n. ");
INSERT INTO any_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Yɛ bú yɩ́ biekun kɛ balasua kʋn le jɛtɛ fufue mma bulu. Sɛ kʋn minlin nun an, asʋ ɔ nzɔ man kanlannɩɛ ɔ mgbʋnndɛ man dede ɔ nnwun man yɩ́ ɔ? ");
INSERT INTO any_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Sɛ ɔ nwun yɩ́ a, ɔ fɛfɛlɛ yɩ́ manngʋn-mɔ nʋn bɛ́ mɔ bɛ mantan mantan yɩ́ nwʋn ɛbɛlɛ'n, ɔ kan kele bɛ́ kɛ: ‘Ɛmɔ bála maan yɛ lí ndutue. Ɔ sanlɩn kɛ m'an nwun mɩ́n esika'n m'ɔ minlinlin'n!’ ");
INSERT INTO any_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Mɩɩn kan mɩn kele ɛmɔ kɛ nyanmɩansʋ ɛlɔ, kɛ ɔ tɩ yɩ́ nɩn ala anɩn. Sɛ ɛtɛfʋɛ kʋnmgba cein nun yɩ́ nwʋn ɔ yaci yɩ́ nyɔlɩɛ ɛtɛ'n-mɔ a, yɩ́ dunman nun, Nyanmɩan mmɔfʋɛ'n-mɔ di ndutue.” ");
INSERT INTO any_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Ɛsɛ Zozi kɔ bu anyɩnndala kʋn biekun kɔ hele bɛ́. Yɩ́ nwan: “Anɩn bian kʋn le yɩ́ mma mmelenzua nnyuan. ");
INSERT INTO any_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Ɛlɛhʋn kʋn, nunhan kaan'n jasʋlɩ a, ɔ kɔ fa kɔ tʋ yɩ́ sɩ anyunnun kɛ: ‘Baba, ninnge'n mɔ ɛ 'fa man yɛ́'n, bu nun nán fa mɩ́n dɩɛ man mɩ́n.’ Ɛhɩ a, sɩɛ'n kɔ hye ninnge'n ɔ kɔ man yɩ́ mma nnyuan'n. ");
INSERT INTO any_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","“Ɔ lili kɔ yɔ ɛlɛsan kʋn, baa kasian kɔ tɔnɩn yɩ́ nwʋn ninnge dɩɛ'n. Cuein, ɔ kɔ fa yɩ́ esika'n ɔ kɔ hɔ mʋa kpa mân bie anun. M'ɔ juli ɛlɔ'n, ɔ kɔ yɔ yɩ́ nwʋn basa basa ɔ kɔ sɛcɩ yɩ́ esika'n kʋalaatin. ");
INSERT INTO any_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","M'ɔ yuelɩ yɩ́ esika'n kʋalaa di'n, ɛhɔɛ kpili kʋn kɔ kpɩn mân sɔ nɩn anun. Sian dɩɛ anɩn yɩ́ nwʋn lɛ cɩlɩ yɩ́. ");
INSERT INTO any_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Ɛhɩ a, ɔ kɔ hɔ junman ɛkpʋnndɛ mân sɔ nɩn anun ɛbɛlɛ bian kʋn asa nun. Bian sɔ'n kɔ man ɔ kɔ hɔ nanmue nun kɛ ɔ hɔ́ nɩ́an yɩ́ mgbolike'n-mɔ asʋ. ");
INSERT INTO any_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Baka mma'n mɔ bɛ tɩ bɛ man mgbolike'n-mɔ di'n, kpafɛlɛ'n kulo kɛ ahan ɔ nyan bie di. Kʋsʋ sʋanlan fɩ́ɩ́ mman man yɩ́. ");
INSERT INTO any_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","“Sian'n, ɔ kɔ tanlan asɩ ɔ kɔ jʋnlɩn. Ɔ kɔ se yɩ́ nwʋn kɛ: ‘Mɩ́n sɩ ɛlɔ ajunmanfʋ'n-mɔ di alɩɛ dede bɛ ngʋala man yɩ́ di. Kʋsʋ afɩ n na ɛwa, ɛhɔɛ lɛ kun mɩ́n! ");
INSERT INTO any_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Mɩn 'sa mɩn kɔ mɩ́n sɩ anwʋn ɛlɔ, mɩn 'fa mɩn tʋ yɩ́ nyunnun kɛ: Baba, Nyanmɩan anyunnun, m'an yɔ ɛtɛ m'an tia wɔ́. ");
INSERT INTO any_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Yɩ́ ti, mɩn nzɛ nvata man kɛ ɛ fá mɩ́n ɛ yɔ́ wɔ́ wa kʋ́n. Bu mɩ́n kɛ wɔ́ ajunmanfʋ'n-mɔ anun kʋn.’ ");
INSERT INTO any_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Sakpa, ɔ kɔ jasʋ kɔ hɔ yɩ́ sɩ anwʋn. “Mɛlɛ mɔ anɩn ɔ tɛ nanndɩ mʋa kpa, m'ɔ juli man awulo nɩn anwʋn ɛbɛlɛ'n, yɩ́ sɩ kɔ nwun yɩ́. Baa nɩn anwʋn kɔ yɔ yɩ́ koun. Ɔ kɔ tutu ɛnwanndie ɔ kɔ hɔ kɔ kpa yɩ́ atɩn, ɔ kɔ tɔ yɩ́ nun ɔ kɔ sɔ yɩ́ ɔ kɔ bɔ yɩ́ nwʋn. ");
INSERT INTO any_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","“M'ɔ yɔlɩ sɔ'n, baa'n nwan: ‘Baba, Nyanmɩan anyunnun, m'an yɔ ɛtɛ m'an tia wɔ́. Yɩ́ ti, mɩn nzɛ nvata man kɛ ɛ fá mɩ́n ɛ káci wɔ́ wa kʋ́n.’ ");
INSERT INTO any_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","“M'ɔ hanlɩn sɔ yuelɩ'n, sɩɛ'n kɔ han kɔ hele yɩ́ ngʋa'n-mɔ kɛ: ‘Ɛmɔ hán bɛ́ nwʋn bɛ fá taladɩɛ kanlanman kpa'n bɛ bála maan bɛ wúla yɩ́. Bɛ wúla yɩ́ sa ngaa, bɛ wówula yɩ́ ja mgbabʋa. ");
INSERT INTO any_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Ɛnalɛ'n mɔ ɔ'a lɔ kpa'n, bɛ fá bɛ bála, bɛ hún yɩ́ maan yɛ tʋ́n ndutue alɩɛ. ");
INSERT INTO any_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Ɔ sanlɩn kɛ mɩ́n wa ɛhɩ mɔ ɛmɔ anyɩn tua yɩ́ ɛwa'n, ɔ a wu ɛsɛ ɔ'a tinnge, ɔ minlinlin yɛ̂ m'an nwun yɩ́ ɔ.’ Ɛbɛlɛ ala, bɛ kɔ bɔ ndutue elie nɩn abʋ. ");
INSERT INTO any_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Ɔ 'ba yɔ sɔ'n, anɩn baa kpain nɩn a hɔ ebolo. Ɔ walɩ dede m'ɔ ka kaan ju awulo nɩn anwʋn ɛbɛlɛ'n, ɔ 'tie a, anɩn bɛ lɛ tʋ ejue bɛ si abile. ");
INSERT INTO any_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Ɔ kɔ fɛlɛ ngʋa'n-mɔ anun kʋn ɔ bisa yɩ́ like mɔ yɩ́ ti yɛ̂ bɛ lɛ tʋ ejue bɛ si abile'n. ");
INSERT INTO any_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Akʋa'n nwan: ‘Wɔ́ nianman bian nɩn a sa a a. Kɛmɔ wɔ́ sɩ a nwun kɛ ɔ tɩ akpɔlɛ mɔ ɛjɔlɛ ɛtɛ fɩ́ɩ́ a ndʋ man yɩ́'n, ɔ a man b'a hun ɛnalɛ'n mɔ ɔ'a lɔ kpa'n.’ ");
INSERT INTO any_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","“Mɔ baa kpain'n tɩlɩ yɩ́ sʋa'n ɔ kɔ fɛ ɛya. Yɩ́ nwan ɔ nwʋlʋ man awulo. Yɩ́ sɩ kɔ fite kɔ a, ɔ kɔ kpata yɩ́ kɛ ɔ wʋ́lʋ awulo. ");
INSERT INTO any_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Baa kpain'n nwan: ‘Baba, m'an sʋ wɔ́ dede afʋɛ kɔ yɔ nyɛ, n nvʋnndʋnlʋn man wɔ́ lé. Kʋsʋ, esile bɔbɔ mgban mɔ mɩn 'fa mɩn tʋn mɩ́n nʋn mɩ́n manngʋn'n-mɔ yɛ di'n, ɛ manlɩn man mɩ́n bie lé. ");
INSERT INTO any_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Nan kɛmɔ wɔ́ wa nɩn a sa a a'n, yɩ́ mɔ ɔ nʋn tutu'n-mɔ b'a li wɔ́ esika'n, yɩ́ lɩlɩ yɛ̂ ɛ kun ɛnalɛ'n mɔ ɔ'a lɔ kpa'n man yɩ́ ɔ!’ ");
INSERT INTO any_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","“Yɩ́ sɩ nwan: ‘Mɩ́n wa, wɔ́ dɩɛ ɛ nʋn mɩ́n yɛ̂ yɛ tɩ ɛwa cɩan daa ɔ. Ninnge kʋalaa mɔ n ne yɩ́'n tɩ wɔ́ kʋsʋ wɔ́ dɩɛ. ");
INSERT INTO any_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Nan kʋsʋ, ɔ fata kɛ yɛ di ndutue. Ɔ sanlɩn kɛ wɔ́ nianman'n mɔ ɛ nwun yɩ́ ɛbɛlɛ'n, ɔ'a wu ɛsɛ ɔ'a tinnge, ɔ minlinlin yɛ̂ m'an nwun yɩ́ ɔ!’” ");
INSERT INTO any_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Ɛhɩ, Zozi kɔ bu anyɩnndala kʋn kɔ hele yɩ́ menian'n-mɔ. Yɩ́ nwan: “Anɩn esikafʋɛ bian kʋn le yɩ́ sʋanlan kʋn mɔ yɩ́ ninnge'n kʋalaa wɔ yɩ́ sa nun ɔ. Cɩan kʋn, menian kɔ a kɔ han kɔ hele esikafʋɛ'n kɛ yɩ́ sʋanlan'n lɛ fɩn yɩ́ ninnge'n gua gua sʋ. ");
INSERT INTO any_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Esikafʋɛ'n kɔ man bɛ kɔ fɛlɛ yɩ́ sʋanlan'n. Ɔ kɔ han kɔ hele yɩ́ kɛ: ‘Ɛjɔlɛ mɔ mɩn tɩtɩ yɩ́ wɔ́ nwʋn'n nyɔ man mɩ́n fɛ. Yɩ́ ti, bu wɔ́ junman nɩn anwʋn mgbʋnndan kele mɩ́n. Afɩ mɩn mma nva man mɩ́n junman'n mɩn nwula man wɔ́ sa nun kʋ́n.’ ");
INSERT INTO any_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","“Sʋanlan'n kɔ se yɩ́ nwʋn kɛ: ‘Anɩn mɩn 'yɔ mɩ́n nwʋn sɛ? Afɩ mɩ́n mɩn'n lɛ yɩ mɩ́n junman nun. N ne man anwʋnsɛlɛ nán m'an li ebolo junman. Sɛ mɩn 'nanndɩ nun mɩn sɛsɛlɛ nán m'an li alɩɛ a, ɔ tɩ mɩ́n anyunnunguasɩɛ. ");
INSERT INTO any_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Kɩkaala dɩɛ, m'an nwun kɛ mɩn 'kpɩn mɩn yɔ yɩ́'n! Yɩ́ dɩɛ, sɛ bɛ yɩ mɩ́n junman nun an, anɩn menian'n-mɔ sʋsɔ mɩ́n nun!’ ");
INSERT INTO any_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","“Ɛhɩ a, ɔ kɔ fɛfɛlɛ bɛ́ nun kʋn biala m'ɔ tua yɩ́ mɩn kalɛ'n yɩ́ nwʋn. Ɔ kɔ bisa alimʋa dɩɛ'n kɛ: ‘Kalɛ nyɛ yɛ̂ ɛ tua mɩ́n mɩn ɔ?’ ");
INSERT INTO any_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","“Yɩ́ nwan: ‘Mɩn tua wɔ́ mɩn *olivʋ ngo balugo abulaa.’ “Sʋanlan'n kɔ han kɔ hele alimʋa dɩɛ'n kɛ: ‘Ɛ 'nwun wɔ́ kalɛ kalata'n. Ndɛ-ndɛ, tanlan asɩ kɛlɛ balugo bulu kalɛ.’ ");
INSERT INTO any_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","“Ɔ fɛlɛlɩ kʋn biekun, ɔ kɔ bisa yɩ́ kɛ: ‘Wɔ́ kʋsʋ, kalɛ nyɛ yɛ̂ ɛ tua mɩ́n mɩn ɔ?’ “Kʋn sɔ'n nwan: ‘Mɩn tua wɔ́ mɩn *bele sakɩ ɛya nnun.’ “Sʋanlan'n kɔ han kɔ hele yɩ́ kɛ: ‘Ɛ 'nwun wɔ́ kalɛ kalata'n. Kɛlɛ bele sakɩ ɛya nnan kalɛ gua sʋ.’ ");
INSERT INTO any_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Mɩnlɩan'n kɔ yɩ yɩ́ sʋanlan awofʋɛ nɩn ayɛ kɛ ɔ nwunlin ɛbɛlɛ amanmuo nɩn anwʋn ngɛlɛ. Ɔ sanlɩn kɛ mân awosin ɛhɩ anun menian'n-mɔ sɩ bɛ́ nwʋn yɔ ɔ tala jawe nɩn anun menian'n-mɔ. ");
INSERT INTO any_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Mɔ mɩɩn kan mɩn kele ɛmɔ'n y'ɔ le kɛ ɛmɔ fá mân ɛhɩ anun anwʋndɩɛ'n mɔ ɛmɔ le yɩ́'n bɛ tíla amanngʋan. Yɩ́ dɩɛ, cɩan mɔ ɛmɔ asa nun kɔ yue'n, anɩn bɛ sɔ ɛmɔ nun nyanmɩansʋ ɛlɔ. ");
INSERT INTO any_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“Sʋanlan mɔ bɛ fa ninnge nganngan bɛ wula yɩ́ sa nun an, ɔ man bɛ nwun yɩ́ ti anun'n, mgbili'n-mɔ anun, ɔ 'man bɛ nwun yɩ́ ti anun. Sʋanlan kʋsʋ mɔ bɛ nnwun man yɩ́ ti anun ninnge nganngan'n-mɔ anun'n, mgbili'n-mɔ anun bɛ nnwun man yɩ́ ti anun. ");
INSERT INTO any_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Eyuadɩ ɛhɩ anun anwʋndɩɛ'n-mɔ anwʋn, sɛ b'a nnwun man ɛmɔ ati anun an, nwan sʋanlan dɩɛ yɛ̂ ɔ 'fa anwʋndɩɛ kpa'n wula ɛmɔ asa nun ɔ? ");
INSERT INTO any_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Sʋanlan fa like wula ɛmɔ asa nun nán ɔ'a nnwun man ɛmɔ ati anun an, nán Nyanmɩan yɛ̂ ɔ 'fa ɛmɔ muonun dɩɛ'n wula ɛmɔ asa nun ɔ. ");
INSERT INTO any_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Kanga fɩ́ɩ́ ngʋala nzʋ man mɩnlɩan nnyuan. Ɔ 'kpɔ kʋn nán ɔ kulo kʋn. Yɩ́ nyɩn 'sɔ kʋn, ɔ tu yɩ́ nyɩn sa kʋn. Ɛmɔ ngʋala man kɛ bɛ kan Nyanmɩan nʋn esika bɛ bɔ nun bɛ sʋ bɛ́ ɔ.” ");
INSERT INTO any_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Falisifʋɛ'n-mɔ kɔ tie ɛjɔlɛ'n kʋalaatin mɔ Zozi hanlɩn'n. Nan kɛmɔ bɛ kulo esika nɩn ati, bɛ kɔ gʋlʋ yɩ́ nwʋn. ");
INSERT INTO any_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Zozi kɔ han kɔ hele bɛ́ kɛ: “Ɛmɔ dɩɛ menian'n-mɔ anyunnun an, ɛmɔ bu bɛ́ nwʋn kɛ bɛ tɩ meninkpa. Nan Nyanmɩan sɩ ɛmɔ ahʋnlɩn nɩn anun ɛjɔlɛ. Ɔ sanlɩn kɛ like mɔ menian'n-mɔ bu yɩ́ kɛ ɔ tɩ kpa'n, Nyanmɩan anyunnun an, like sɔ'n tɩ nvuin. ");
INSERT INTO any_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Menian'n-mɔ lili *Moyizɩ mala'n ɔ nʋn mgbɔmanfʋɛ'n-mɔ ɛjɔlɛ nɩn asʋ dede ɔ juli Zʋan Batisi mɛlɛ sʋ. Ɔ fi ɛbɛlɛ m'ɔ kɔ'n, b'a bɔ Nyanmɩan Belemgbin Mân nɩn anwʋn Ɛjɔlɛkpa'n kpayɛ. Yɩ́ ti, sʋanlan kʋn biala lɛ kpɩlɩ wʋlʋ Nyanmɩan belemgbin mân nɩn anun ɛlɔ. ");
INSERT INTO any_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Anwunno nʋn asɩ'n kʋala kɛ bɛ kpɛ nun bɛ sɩn ndɛ-ndɛ tala mala nɩn anun ɛjɔlɛ kpɔlɛ sin kaan sʋa. ");
INSERT INTO any_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Belenzua biala m'ɔ kɔ yila yɩ́ yɩ ɔ kɔ ja fʋfɔlɛ'n, belenzua sɔ'n, anɩn ɔ'a tʋn aja. Sʋanlan biala kʋsʋ m'ɔ kɔ ja balasua mɔ yɩ́ hun a yila yɩ́'n, sʋanlan sɔ'n, anɩn ɔ'a tʋn ajaa. ");
INSERT INTO any_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“Ɛhɩ, anɩn esikafʋɛ bian kʋn wɔ ɛbɛlɛ. Taladɩɛ kɛ mmelemgbin'n-mɔ dɩɛ'n yɛ̂ anɩn ɔ wula ɔ. Ɔ le yɩ́ kʋalaa m'ɔ kulo ɛsɛ cɩan daa ɔ di mân. ");
INSERT INTO any_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Anɩn ehianfʋɛ kʋsʋ kʋn wɔ ɛbɛlɛ. Bɛ fɛlɛ yɩ́ Lazaa. (Dunman Lazaa'n, yɩ́ bʋ y'ɔ le kɛ sʋanlan mɔ Nyanmɩan bʋka yɩ́.) Yɩ́ nwʋn'n tɩ nganlan nganlan ngʋnmɩn. Ɔ la esikafʋɛ nɩn awulo nɩn anʋan nɩn anyunnun ɛbɛlɛ. ");
INSERT INTO any_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Ɔ kulo kɛ ahan esikafʋɛ nɩn alɩɛ nɩn abʋ mgbʋkpʋlʋka'n m'ɔ gua tɔbɩlɩ nɩn abʋ asɩ'n, ɔ nyan yɩ́ di. Kɛmɔ ɔ la ɛbɛlɛ'n, njʋa'n-mɔ ba bɛ tafɩ tafɩ yɩ́ nganlan'n-mɔ anun. ");
INSERT INTO any_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Ɔ wɔ ɛbɛlɛ dede ehianfʋɛ'n kɔ wu. Ɔ wuli a, nyanmɩansʋ mmɔfʋɛ'n-mɔ nʋn yɩ́ kɔ hɔ Abalahamʋn anwʋn ɛlɔ nyanmɩansʋ. Ɔ wɔ ɛbɛlɛ dede esikafʋɛ'n kʋsʋ kɔ wu bɛ kɔ sie yɩ́. ");
INSERT INTO any_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Ɔ kɔ hɔ sɩ̂n'n m'ɔ le man ayuelɩɛ nɩn anun, anɩn ɔ tɩ nyinlinlin kpili kpa man yɩ́. Ɔ 'tʋ yɩ́ nyɩn anwunno a, ɔ kɔ nwun Abalahamʋn mʋa ɛlɔ, Lazaa tɩ yɩ́ nwʋn ɛbɛlɛ. ");
INSERT INTO any_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Esikafʋɛ'n kɔ tɩan, yɩ́ nwan: ‘Mɩ́n sɩ Abalahamʋn, nwun mɩ́n nwʋn anwunnvoe. Sʋan Lazaa maan ɔ bɔ́ yɩ́ sa bɛtɩa kʋn nzue nɩn anun ɔ fá kpɩ́n mɩ́n tofeleman nɩn asʋ. Ɔ sanlɩn kɛ sɩ̂n'n lɛ kele mɩ́n yalɛ kpili sʋnman.’ ");
INSERT INTO any_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“M'ɔ hanlɩn sɔ'n, Abalahamʋn kɔ bua yɩ́ kɛ: ‘Mɩ́n wa, kacɩ kɛ wɔ́ anwʋndɩɛ dɩɛ'n, ɛ nyanlɩn yɩ́ mɛlɛ mɔ anɩn ɛ wɔ asɩɛ nɩn asʋ'n. Lazaa kʋsʋ a, ɛfɛ yɛ̂ ɔ tɔlɩ yɩ́ sʋ ɔ. Kɩkaala dɩɛ, yɩ́ lʋa a cɩcɩ ɛwa. Wɔ́ kʋsʋ wɔ́, ɛ lɛ nwun yalɛ. ");
INSERT INTO any_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","M'ɔ wɔ nun biekun'n y'ɔ le kɛ bɔnza kpili kʋn la yɛ́ nʋn ɛmɔ afian. Ɔ man bɛ́ mɔ bɛ wɔ ɛwa mɔ bɛ kulo kɛ bɛ kɔ ɛlɔ'n, anaan bɛ́ mɔ bɛ wɔ ɛmɔ ɛlɔ mɔ bɛ kulo kɛ bɛ ba yɛ́ ɛwa'n, bɛ ngʋala man yɩ́ sɔ yɔ.’ ");
INSERT INTO any_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“Esikafʋɛ'n nwan: ‘Mɩ́n sɩ Abalahamʋn, mɩn 'sɛlɛ wɔ́ kpa, sʋan Lazaa mɩ́n sɩ awulo ɛlɔ, ɔ sanlɩn kɛ mɩ́n nianman nnun wɔ ɛbɛlɛ. ");
INSERT INTO any_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Yɩ́ dɩɛ ɔ ju ɛlɔ a, anɩn ɔ kan kele bɛ́ kɛ mɩɩn nwun yalɛ kpa, nán bɛ́ kʋsʋ, b'a mma man ɛwa yalɛ nɩn anun bie.’ ");
INSERT INTO any_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","“Abalahamʋn kɔ bua yɩ́ kɛ: ‘Moyizɩ mala'n wɔ bɛ́ sa nun, bɛ nʋn mgbɔmanfʋɛ'n-mɔ yɛ̂ bɛ tɩ ɛlɔ ɔ. Man bɛ tíe bɛ́!’ ");
INSERT INTO any_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","“Esikafʋɛ'n nwan: ‘Cɛcɛ, mɩ́n sɩ Abalahamʋn, sɛ sʋanlan kʋn fi ewue mma afian ɛwa ɔ kɔ ɛlɔ a, bɛ 'nun bɛ́ nwʋn bɛ yaci bɛ́ nyɔlɩɛ ɛtɛ'n-mɔ.’ ");
INSERT INTO any_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","“Ɛhɩ a, Abalahamʋn kɔ han kɔ hele yɩ́ kɛ: ‘Sɛ bɛ ngulo man kɛ bɛ di Moyizɩ mala nɩn asʋ bɛ tie mgbɔmanfʋɛ'n-mɔ a, man sʋanlan fi ewue mma afian bɔbɔ ɔ hɔ́ tʋ́ bɛ́, bɛ ngɔ le bɛ ngɔ li man.’” ");
INSERT INTO any_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Ɛhɩ, Zozi kɔ han kɔ hele yɩ́ menian'n-mɔ kɛ: “Ɔ mgba man yɩ́ nwʋn, ngaa wɔ ɛbɛlɛ mɔ ɔ 'man menian'n-mɔ tɔ ɛtɛ nɩn anun ɔ. Nan munnzue hán sʋanlan m'ɔ kɔ man yɩ́ manngʋn kɔ tɔ ɛtɛ nɩn anun'n. ");
INSERT INTO any_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Ɔ tɩ kpa man yɩ́ kɛ bɛ tʋ́ yɩ́ kɔmɩn ɛbʋɛ kpili kʋn bɛ jú yɩ́ bɛ tʋ́ asue jenvie nɩn anun. Ɔ le sʋ nvasʋɛ tala kɛ ɔ kɔ man mmatʋnman ɛhɩ-mɔ anun kʋn kɔ tɔ ɛtɛ nɩn anun'n. ");
INSERT INTO any_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Yɩ́ ti, ɛmɔ síe bɛ́ nwʋn ye kpa o! “Sɛ wɔ́ nianman yɔ wɔ́ ɛtɛ a, kan yɩ́ nyɔlɩɛ ɛtɛ nɩn anwʋn ɛjɔlɛ kele yɩ́. Sɛ ɔ kaci yɩ́ abalabɔ nɩn an, yaci yɩ́ ɛtɛ'n ce yɩ́. ");
INSERT INTO any_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Sɛ ɔ yɔ wɔ́ ɛtɛ kpɛ̂ nsʋ alɩhɩan kʋn anun an, yɩ́ kʋalaa m'ɔ kɔ yɔ'n, sɛ ɔ ba tʋ wɔ́ ɔ kan kɛ: ‘Mɩn 'kaci mɩ́n abalabɔ'n,’ sɛ ɔ yɔ yɩ́ sɔ a, yaci yɩ́ ɛtɛ'n ce yɩ́.” ");
INSERT INTO any_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Mmɔfʋɛ'n-mɔ kɔ han kɔ hele yɛ́ Mɩn kɛ: “Gua yɛ́ dedi nɩn asʋ.” ");
INSERT INTO any_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Mɔ bɛ hanlɩn sɔ'n, yɛ́ Mɩn nwan: “Sɛ ɛmɔ le dedi mɔ yɩ́ kpili'n nʋn muntadɩ baa sɛ a, ɛmɔ kʋala se baka ɛhɩ kɛ: ‘Tu wɔ́ bʋ kɔ jinlan jenvie nɩn anun ɛlɔ.’ Baka sɔ'n 'tu yɩ́ bʋ ɔ kɔ jinlan jenvie nɩn anun ɛlɔ.” ");
INSERT INTO any_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Zozi nwan: “Yɛ bú yɩ́ kɛ ɛmɔ anun kʋn le yɩ́ akʋa kʋn. Yɩ́ akʋa sɔ'n di yɩ́ ebo nɩn asʋ junman anaan ɔ nɩan yɩ́ ayɛmʋa'n-mɔ asʋ. Sɛ ɔ nwun kɛ yɩ́ akʋa'n fi ebolo a a, asʋ ɔ 'kan kele yɩ́ kɛ: ‘Kan wɔ́ nwʋn, tanlan asɩ di like’? ");
INSERT INTO any_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Ɔ ngan man sɔ. Nan ɔ 'kan kele yɩ́ akʋa'n kɛ: ‘Sesie mɩ́n like'n, kɔ kaci wɔ́ nwʋn bala yɩ mɩ́n alɩɛ dɩɛ'n man mɩ́n maan n ní n nʋ́n nzue. Sɛ mɩn yue a, ɛ kɔ li wɔ́ dɩɛ ɛ kɔ nʋn nzue.’ ");
INSERT INTO any_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Junman'n mɔ ɔ'a man yɩ́ akʋa nɩn a li'n, asɩ nâ nnʋn man nun. ");
INSERT INTO any_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Kɛ ɔ tɩ yɩ́ man ɛmɔ kʋsʋ nɩn ala'n. Sɛ ɛmɔ yue junman'n kʋalaa mɔ b'a hele ɛmɔ'n di a, ɛmɔ hán kɛ: ‘Yɛ tɩ ngʋa mgban, like m'ɔ sɛ kɛ yɛ yɔ'n yɛ̂ y'a yɔ ɔ.’” ");
INSERT INTO any_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Mɔ Zozi 'kɔ Zoluzalɛmʋn'n, ɔ sɩnlɩn Samali nʋn Galile ɛyɛ nɩn asʋ. ");
INSERT INTO any_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Anɩn ɔ ka kaan ju kulo kʋn asʋ, kokobefʋɛ bulu kɔ hɔ kɔ kpa yɩ́ atɩn. Bɛ jinlanlɩn mʋa, ");
INSERT INTO any_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","anɩn bɛ lɛ tɩan bɛ kan kɛ: “Kpain Zozi, nwun yɛ́ nwʋn anwunnvoe!” ");
INSERT INTO any_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Mɔ Zozi nwunlin bɛ́'n, ɔ kɔ han kɔ hele bɛ́ kɛ: “Ɛmɔ hɔ́ bɛ fá bɛ́ nwʋn bɛ héle tɛɛyɩfʋɛ'n-mɔ.” Mɛlɛ mɔ bɛ falɩ atɩn'n mɔ bɛ 'kɔ'n, bɛ́ nwʋn kɔ sa. ");
INSERT INTO any_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Mɔ kokobefʋɛ bulu nɩn anun kʋn nwunlin kɛ yɩ́ nwʋn a sa'n, ɔ kɔ sa yɩ́ nzin. Ɔ 'ba a, anɩn ɔ lɛ tɩan ɔ yɩ Nyanmɩan ayɛ. ");
INSERT INTO any_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Ɔ kɔ tutu kɔ tɔ Zozi aja nun, ɔ kɔ butu yɩ́ nyɩn asɩ, ɔ kɔ yɔ yɩ́ mo. Kanngʋ anɩn sʋanlan sɔ'n tɩ Samali sʋanlan. ");
INSERT INTO any_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Ɛhɩ a, Zozi nwan: “Bɛ́ kokobefʋɛ bulu'n, asʋ bɛ́ kʋalaa bɛ́ nwʋn a nza man ɔ? Nan kokobefʋɛ ngʋanlan ɛhɩnlɩn, bɛ halɩ bɛ́ dɩɛ nin? ");
INSERT INTO any_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Bɛ́ nun bie fɩ́ɩ́ a nza a mma nyɩ man Nyanmɩan ayɛ kɛ ɛyɛfʋɛ ɛhɩ ala?” ");
INSERT INTO any_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","M'ɔ yɔlɩ sɔ yuelɩ'n, Zozi kɔ han kɔ hele kokobefʋɛ'n kɛ: “Jasʋ kɔ, wɔ́ dedi nɩn a le wɔ́ ngʋan.” ");
INSERT INTO any_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Ɛlɛhʋn kʋn *Falisifʋɛ'n-mɔ kɛ bisa Zozi kɛ: “Cɩan benin yɛ̂ Nyanmɩan 'di yɩ́ belemgbin nɩn ɔ?” Zozi kɔ bua bɛ́ kɛ: “Nyanmɩan belemgbin elie'n tɩ man like mɔ bɛ nwun yɩ́ bɛ́ nyɩnsʋ ɔ. ");
INSERT INTO any_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Bɛ ngan man kɛ: ‘Ɛ 'nwun yɩ́’ anaan ‘Yɩ́ ahɩ’. Afɩ ɛmɔ nwún yɩ́ kɛ Nyanmɩan lɛ di yɩ́ belemgbin nɩn ɛmɔ afian ɛwa.” ");
INSERT INTO any_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Ɛhɩ anzin, Zozi kɔ han kɔ hele yɩ́ menian'n-mɔ kɛ: “Mɛlɛ'n 'ba ju mɔ cɩan kʋn ɛmɔ alʋa 'ba lɔ *Mân Baa'n, kʋsʋ ɛmɔ ngɔ nwun man yɩ́. ");
INSERT INTO any_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Menian'n-mɔ 'ba han kele ɛmɔ kɛ: ‘Bɛ nɩ́an, ɔ wɔ ɛwa o!’ anaan ‘Bɛ nɩ́an, ɔ wɔ ɛlɔ o!’ Bɛ kan sɔ a, nán bɛ tu bɛ́ bʋ bɛ nwanndi bɛ kɔ lɩka fɩ́ɩ́. ");
INSERT INTO any_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Kɛmɔ nyanmɩan'n kpɛ mɩaɩn, ɔ fite ebue kʋn ɔ ta kɔ ebue kʋn'n, kɛ Mân Baa'n kʋsʋ ɛwalɛ cɩan'n 'ba yɔ yɩ́ nɩn anɩn. ");
INSERT INTO any_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Nan kʋsʋ ɔ di kɛ ɔ nwun yalɛ kpa, ɛsɛ ɔ di kɛ ajulisʋ menian'n-mɔ yɩ yɩ́ tʋ kʋalaaka. ");
INSERT INTO any_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","“Ɛjɔlɛ m'ɔ walɩ Nowe mɛlɛ sʋ'n, ɛjɔlɛ sɔ'n kʋnmgba yɛ̂ ɔ 'ba a Mân Baa nɩn ɛwalɛ cɩan nɩn ɔ. ");
INSERT INTO any_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Dede m'ɔ juli cɩan mɔ Nowe 'fʋ meli nɩn anun, mɔ asuyie kpili'n 'bu asɩ ɔ kun menian'n-mɔ kʋalaatin'n, anɩn Nowe mɛlɛ sʋ menian'n-mɔ lɛ didi, bɛ lɛ nʋn nzan, bɛ lɛ jija bɛ́ nwʋn, ɛsɛ anɩn bɛ lɛ fa bɛ́ mma'n-mɔ ajaa. ");
INSERT INTO any_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","“Mân Baa nɩn ɛwalɛ cɩan'n 'ba yɔ kɛ Lɔtʋ mɛlɛ sʋ. Lɔtʋ mɛlɛ sʋ, anɩn menian'n-mɔ lɛ didi, bɛ lɛ nʋn nzan, bɛ lɛ tunndo ninnge, bɛ lɛ tɔnɩn ninnge, bɛ lɛ dodua ninnge ɛsɛ anɩn bɛ lɛ sisi sua. ");
INSERT INTO any_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Nan cɩan mɔ Lɔtʋ fi *Sodɔmʋn jasʋlɩ'n, Nyanmɩan manlɩn sɩ̂n esue ɔ nʋn like kʋn, ɔ ban nvan kɛ tui ndunmunlan, bɛ tɔlɩ gualɩ bɛ hunlin menian sɔ'n-mɔ kʋalaatin. ");
INSERT INTO any_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","“Cɩan mɔ Mân Baa'n 'ba yɩ yɩ́ nwʋn kele'n, kɛ ɛjɔlɛ'n 'ba yɔ yɩ́ nɩn anɩn. ");
INSERT INTO any_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Cɩan sɔ'n, sʋanlan m'ɔ kɔ fʋ kɔ tanlan yɩ́ sua nɩn ati sʋ'n, n'ɔ ju ɔ wʋlʋ sua nɩn anun ɔ fa yɩ́ ninnge'n m'ɔ wɔ ɛbɛlɛ'n. Sʋanlan kʋsʋ m'ɔ kɔ hɔ ebolo'n, n'ɔ sa yɩ́ nzin ɔ ba kulo. ");
INSERT INTO any_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Ɛmɔ ati kácɩ Lɔtʋ ayɩ'n! ");
INSERT INTO any_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Sʋanlan m'ɔ tɩ ahyʋan ɔ kulo yɩ́ kunnun'n, ɔ nnyan man ngʋan. Nan sʋanlan mɔ eyuadɩ ɛtɛ ɛhɩ anun ɔ kulo ɛhɩnlɩn-mɔ ɔ bʋka bɛ́'n, sʋanlan sɔ'n, ɔ 'nyan nyanmɩansʋ ngʋan m'ɔ le man ayuelɩɛ'n. ");
INSERT INTO any_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Mɩɩn kan mɩn kele ɛmɔ kɛ cɩan sɔ'n kɔngɔɛ, sɛ menian nnyuan la ɛbɛɛ kʋn asʋ a, bɛ nʋn kʋn kɔ, kʋn ka ɛbɛlɛ. ");
INSERT INTO any_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Mmalasua nnyuan mɔ bɛ lɛ futu *bele bɛ yɩ yɩ́ fali'n, bɛ nʋn kʋn kɔ, kʋn ka ɛbɛlɛ.”  ");
INSERT INTO any_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Mmelenzua nnyuan mɔ bɛ kɔ hɔ ebolo'n, bɛ nʋn kʋn kɔ, bɛ yaci kʋn. ");
INSERT INTO any_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Zozi menian'n-mɔ kɔ bisa yɩ́ kɛ: “Yɛ́ Mɩn, anɩn nin lɩka dɩɛ yɛ̂ ɛjɔlɛ sɔ'n 'ba te ɔ?” Zozi kɔ bua bɛ́ kɛ: “Lɩka mɔ fuin'n la'n, ɛbɛlɛ yɛ̂ ɛkpɔtɛ'n-mɔ yia ɔ.” ");
INSERT INTO any_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Ɛhɩ anzin, Zozi kɔ bu anyɩnndala ɛhɩ ɔ kɔ hele bɛ́ kɛ bɛ yɔ́ asɔnɩn tɛmʋn biala, nán bɛ man bɛ́ nwʋn bubu bɛ́. ");
INSERT INTO any_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Yɩ́ nwan: “Anɩn sʋanlan kʋn wɔ kulo kʋn asʋ ɔ di ɛjɔlɛ. Sʋanlan sɔ'n, ɔ nzulo man Nyanmɩan ɛsɛ yɩ́ nyɩn nzɔ man sʋanlan fɩ́ɩ́. ");
INSERT INTO any_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Anɩn kunlannvʋɛ balasua kʋn kʋsʋ wɔ kulo sɔ nɩn asʋ bie. Kunlannvʋɛ sɔ'n ba tʋ sʋanlan'n m'ɔ di ɛjɔlɛ'n cɩan daa a, yɩ́ nwan: ‘Di mɩ́n ɛjɔlɛ'n m'ɔ la mɩn nʋn mɩ́n kpɔfʋɛ nɩn afian'n man mɩ́n.’ ");
INSERT INTO any_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","“Kunlannvʋɛ'n ba ɔ kan an, sʋanlan'n m'ɔ di ɛjɔlɛ'n ndɛ man yɩ́ sʋ dede ɔ'a hyɛ kpa. Cɩan kʋn, ɔ kɔ se yɩ́ nwʋn kɛ: ‘Ɔ tɩ ananhɔlɛ kɛ mɩn nzulo man Nyanmɩan ɛsɛ mɩ́n nyɩn nzɔ man sʋanlan fɩ́ɩ́. ");
INSERT INTO any_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Nan kʋsʋ, kɛmɔ kunlannvʋɛ balasua ɛhɩ man mɩn nnyan mɩn nwʋn'n, mɩn 'di yɩ́ ɛjɔlɛ'n mɩn man yɩ́. Sɛ m'an nyɔ man yɩ́ sɔ a, ɔ 'tan mɩ́n nyɩnsʋ.’” ");
INSERT INTO any_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Mɔ yɛ́ Mɩn buli anyɩnndala sɔ'n yuelɩ'n, ɔ kɔ han kɔ tʋ sʋ kɛ: “Ɛmɔ tíe ɛjɔlɛ mɔ sʋanlan ɛtɛfʋɛ ɛhɩ m'ɔ di ɛjɔlɛ'n lɛ kan'n! ");
INSERT INTO any_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Sɛ ɛtɛfʋɛ ɛhɩ m'ɔ di ɛjɔlɛ'n kʋala kɛ ɔ di sʋanlan ɛjɔlɛ maan yɩ́ kunnun jɔ a, asʋ Nyanmɩan lɩlɩ yɛ̂ yɩ́ mma'n-mɔ sun fɛlɛ yɩ́ kɔngɔɛ nʋn eyue a, ɔ nni man bɛ́ ɛjɔlɛ mman man bɛ́ ɔ? Asʋ ɔ 'cɛ nán ɔ'a bʋka bɛ́ ɔ? ");
INSERT INTO any_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Mɩɩn kan yɩ́ ananhɔlɛ mɩn kele ɛmɔ kɛ Nyanmɩan 'di bɛ́ ɛjɔlɛ'n man bɛ́ ndɛ-ndɛ. Nan *Mân Baa nɩn ɛwalɛ nun, asʋ ɔ 'ba tʋ menian'n-mɔ asɩɛ nɩn asʋ ɛwa kɛ bɛ de Nyanmɩan bɛ di ɔ?” ");
INSERT INTO any_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Zozi kɔ bu anyɩnndala ɛhɩ ɔ kɔ man bɛ́ mɔ bɛ bu bɛ́ nwʋn sɛsɛfʋɛ Nyanmɩan anyunnun, mɔ bɛ mmu man bɛ́ manngʋn-mɔ like'n. ");
INSERT INTO any_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Yɩ́ nwan: “Menian nnyuan kɔ hɔ asɔnɩn ɛyɔlɛ Nyanmɩan awulo ɛlɔ. Nunhan kʋn tɩ *Falisifʋɛ, kʋn'n dide ajule. ");
INSERT INTO any_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Falisifʋɛ nɩn a tɩ yɩ́ nwʋn ɔ'a jinlan bɛ́ nyunnun yɛ̂ ɔ lɛ sɛlɛ ɔ. Yɩ́ nwan: ‘Nyanmɩan, mɩn 'da wɔ́ asɩ, afɩ n dɩ man kɛ menian bʋ nga'n-mɔ. Bɛ́ dɩɛ, bɛ tɩ awofʋɛ, ɛtɛfʋɛ ɛsɛ bɛ tʋn ajaa. Mɩn 'da wɔ́ asɩ, afɩ n dɩ man kɛ sʋanlan ɛhɩ m'ɔ dide ajule'n. ");
INSERT INTO any_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Mɔlɛ kʋn anun, mɩn bua mɩn da kpɛ̂ nnyuan. Like mɔ n gɔ nyan yɩ́'n, mɩn bu nun bulu mɩn tu kʋn mɩn man wɔ́.’ ");
INSERT INTO any_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“Sʋanlan'n m'ɔ dide ajule'n jin bɛ́ nzin mʋa, ɔ ngulo man kɛ ɔ tʋ yɩ́ nyɩn anwunno bɔbɔ, ɔ kɔ fa yɩ́ sa kɔ bɔ yɩ́ hue sʋ, yɩ́ nwan: ‘Nyanmɩan, nwun mɩ́n nwʋn anwunnvoe. Ɔ sanlɩn kɛ n dɩ ɛtɛfʋɛ.’” ");
INSERT INTO any_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Zozi nwan: “Mɩɩn kan mɩn kele ɛmɔ kɛ mɛlɛ mɔ sʋanlan'n m'ɔ dide ajule'n 'kɔ yɩ́ awulo'n, anɩn ɔ nʋn Nyanmɩan, bɛ́ afian a sɛ. Nan Falisifʋɛ'n, ɔ nʋn Nyanmɩan, bɛ́ afian a nzɛ man. Ɔ sanlɩn kɛ sʋanlan biala m'ɔ kɔ kuku yɩ́ nwʋn sʋ'n, bɛ 'kan yɩ́ asɩ. Sʋanlan kʋsʋ m'ɔ kɔ han yɩ́ nwʋn asɩ'n, bɛ 'kuku yɩ́ sʋ.” ");
INSERT INTO any_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Menian mmie-mɔ kɔ fa mmatʋnman nganngan-mɔ bɛ kɔ bɛlɛ Zozi kɛ ɔ fá yɩ́ sa ɔ fúa bɛ́ nwʋn ɔ yéyila bɛ́ sʋ. Mɔ yɩ́ mmɔfʋɛ'n-mɔ nwunlin yɩ́ sɔ'n, bɛ kɔ totua menian sɔ'n-mɔ atɩn. ");
INSERT INTO any_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Zozi kɔ man bɛ kɔ fɛlɛ mmatʋnman'n-mɔ. Yɩ́ nwan: “Ɛmɔ yáci mmatʋnman'n-mɔ maan bɛ bála mɩ́n nwʋn! Nán bɛ totua bɛ́ atɩn. Ɔ sanlɩn kɛ Nyanmɩan Belemgbin Mân'n, ɔ tɩ bɛ́ mɔ bɛ tɩ kɛ bɛ́'n dɩɛ. ");
INSERT INTO any_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Mɩɩn kan yɩ́ ananhɔlɛ mɩn kele ɛmɔ kɛ sʋanlan mɔ ɔ'a nyɔ man yɩ́ nwʋn batʋnman ɔ'a man Nyanmɩan a nni man yɩ́ sʋ belemgbin'n, sʋanlan sɔ'n ngɔ hʋala man Nyanmɩan Belemgbin Mân nɩn anun ɛlɔ kɔ lé.” ");
INSERT INTO any_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Zufʋ kpain'n kʋn kɔ bisa Zozi kɛ: “Mɩnlɩan kpa, nzu like dɩɛ y'ɔ di kɛ mɩn yɔ nán m'an nyan ngʋan m'ɔ le man ayuelɩɛ'n?” ");
INSERT INTO any_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Zozi kɔ bua yɩ́ kɛ: “Nzukɛ ati yɛ̂ ɛ fɛlɛ mɩ́n mɩnlɩan kpa ɔ? Sʋanlan fɩ́ɩ́ tɩ man kpa, sannan Nyanmɩan angʋnmɩn cein. ");
INSERT INTO any_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Ɛ sɩ mala bulu'n: N'ɛ tʋn ajaa, n'ɛ kun sʋanlan, n'ɛ wua, n'ɛ di ato adanzɩɛ, man wɔ́ nyɩn sɔ́ wɔ́ sɩ nʋn wɔ́ nin.” ");
INSERT INTO any_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Bian'n nwan: “M mantanlɩn mala sɔ'n-mɔ asʋ elie mɩ́n mmatʋnman nun angʋnmɩn.” ");
INSERT INTO any_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Mɔ Zozi tɩlɩ ɛjɔlɛ sɔ'n, ɔ kɔ han kɔ hele yɩ́ kɛ: “Ɔ ka wɔ́ like kʋn biekun. Tɔnɩn wɔ́ nwʋn ninnge'n kʋalaatin nán ce yɩ́ esika'n man ehianfʋɛ'n-mɔ.” ");
INSERT INTO any_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Mɔ Zozi hanlɩn sɔ mɔ bian'n tɩlɩ'n, yɩ́ nwʋn kɔ bubu yɩ́. Ɔ sanlɩn kɛ ɔ tɩ esikafʋɛ kpili kpa. ");
INSERT INTO any_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Mɔ Zozi nwunlin kɛ bian nɩn anwʋn a bubu yɩ́'n, yɩ́ nwan: “Nyanmɩan Belemgbin Mân nɩn anun ɛlɔ ɛwʋlʋɛ'n yɔ sɩ man esikafʋɛ'n-mɔ o! ");
INSERT INTO any_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Ɔ yɔ sɩ man naan kpili'n mɔ bɛ fɛlɛ yɩ́ sʋamo'n kɛ ɔ wʋ́lʋ dɔlɔwa bɔɛ nun. Nan ɔ yɔ sɩ kpa man esikafʋɛ kʋn kɛ ɔ wʋ́lʋ Nyanmɩan Belemgbin Mân nɩn anun.” ");
INSERT INTO any_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Bɛ́ mɔ anɩn bɛ lɛ tie Zozi ɛjɔlɛ sɔ'n nwan: “Nan sɛ ɛjɔlɛ'n tɩ sʋa a, anɩn nwan yɛ̂ ɔ kʋala ɔ nyan yɩ́ ti ɔ?” ");
INSERT INTO any_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Zozi kɔ bua bɛ́ kɛ: “Like mɔ kulo menian'n-mɔ ngʋala man yɩ́ yɔ'n, like sɔ'n nza man Nyanmɩan yɔ.” ");
INSERT INTO any_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Ɛhɩ a, Pɩɛlɩ nwan: “Nɩan, y'a yaci yɛ́ nwʋn ninnge'n kʋalaa y'a gua y'a si wɔ́ sʋ.” ");
INSERT INTO any_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Zozi kɔ han kɔ hele bɛ́ kɛ: “Mɩɩn kan yɩ́ ananhɔlɛ mɩn kele ɛmɔ kɛ sɛ Nyanmɩan Belemgbin Mân'n dunman nun, sʋanlan kʋn yaci yɩ́ awulo, yɩ́ yɩ, yɩ́ nianman-mɔ, yɩ́ sɩ nʋn nʋn yɩ́ nin nʋn mma-mɔ a, ");
INSERT INTO any_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","ɔ 'nyan yɩ́ nwʋn sʋ dɔʋn kpa mɛlɛ ɛhɩ anun. Ɛsɛ mɛlɛ'n m'ɔ lɛ ba nɩn anun, ɔ 'nyan ngʋan m'ɔ le man ayuelɩɛ'n.” ");
INSERT INTO any_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Zozi nʋn yɩ́ menian bulu nʋn nnyuan'n kɔ tɩ bɛ́ nwʋn. Ɔ kɔ han hɔ hele bɛ́ kɛ: “Yaa, yɛ lɛ kɔ Zoluzalɛmʋn o! Ɛjɔlɛ'n kʋalaa mɔ mgbɔmanfʋɛ'n-mɔ hanlɩn m'ɔ tʋ de Mân Baa'n, ɛbɛlɛ yɛ̂ ɔ 'kpɩn sʋ ɔ. ");
INSERT INTO any_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Bɛ 'ba yɩ *Mân Baa'n bɛ man bɛ́ mɔ bɛ nzʋ man Nyanmɩan'n. Bɛ́ kʋsʋ bɛ 'ba gʋlʋ yɩ́ nwʋn, bɛ 'kpɛ yɩ́ nzʋba ɛsɛ bɛ 'tʋtʋ yɩ́ nwʋn ngɛsɛlɛ. ");
INSERT INTO any_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Bɛ 'fin yɩ́ mgbele ɛsɛ bɛ 'kun yɩ́. Nan bɛ kun yɩ́ a, yɩ́ cɩan nsan nɩn asʋ, ɔ fi ewue nun ɔ 'tinnge.” ");
INSERT INTO any_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Ɛjɔlɛ'n mɔ Zozi hanlɩn'n, yɩ́ menian'n-mɔ ngɔ tɩ man yɩ́ bʋ fɩ́ɩ́ sʋa. Ɔ sanlɩn kɛ ɛjɔlɛ'n mɔ Zozi hanlɩn'n tɩ nvɩalɩɛ nun ɛjɔlɛ bɛ́ nyɩnsʋ. Ɔ man b'a ndɩ man yɩ́ bʋ. ");
INSERT INTO any_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Anɩn Zozi ka kaan ju Zoliko. Ɔ 'ba yɔ sɔ'n, anɩn anyɩnsinlinwafʋɛ kʋn tɩ atɩn nɩn anʋan ɛbɛlɛ yɛ̂ ɔ sɛsɛlɛ ɔ. ");
INSERT INTO any_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","M'ɔ tɩlɩ kɛ meninsʋnman lɛ sɩ̂n'n, ɔ kɔ bisa nun ɛjɔlɛ. ");
INSERT INTO any_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Bɛ kɔ han bɛ kɔ hele yɩ́ kɛ Zozi m'ɔ fi Nazalɛtɩ'n y'ɔ lɛ sɩn ɛbɛlɛ ɔ. ");
INSERT INTO any_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","M'ɔ tɩlɩ kɛ bɛ́ nwan Zozi y'ɔ lɛ sɩn ɛbɛlɛ'n, ɔ kɔ tɩan. Yɩ́ nwan: “Belemgbin *Davidi Awa Zozi, nwun mɩ́n nwʋn anwunnvoe!” ");
INSERT INTO any_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Bɛ́ mɔ bɛ li bɛ́ nyunnun'n kɔ totua yɩ́ kɛ ɔ múan yɩ́ nʋan. Mɔ bɛ 'totua yɩ́'n, bɛlɛ mɔ anɩn ɔ lɛ tɩan sɛlɛ kpa ɔ. Yɩ́ nwan: “Belemgbin Davidi Awa, nwun mɩ́n nwʋn anwunnvoe!” ");
INSERT INTO any_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Zozi kɔ jinlan ɔ kɔ man atɩn kɛ bɛ fá yɩ́ bɛ bɛ́lɛ yɩ́. Mɔ anyɩnsinlinwafʋɛ'n juli ɛbɛlɛ'n, Zozi kɔ bisa yɩ́ kɛ: ");
INSERT INTO any_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Nzu yɛ̂ ɛ kulo kɛ n yɔ́ m mán wɔ́ ɔ?” Anyɩnsinlinwafʋɛ'n nwan: “Yɛmɩnlɩn, yɔ maan n nwún asɩ kɛ yɩ́ daba'n.” ");
INSERT INTO any_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","M'ɔ hanlɩn sɔ'n, Zozi kɔ han kɔ hele yɩ́ kɛ: “Nwun asɩ! Wɔ́ dedi nɩn a man wɔ́ nwʋn a sa.” ");
INSERT INTO any_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Ɛbɛlɛ ala, ɔ kɔ nwun asɩ. Ɔ kɔ yɩ Nyanmɩan ayɛ ɔ kɔ si Zozi sʋ. Mɔ bɛ́ kʋalaa bɛ nwunlin yɩ́ sɔ'n, bɛ kɔ yɩ Nyanmɩan ayɛ. ");
INSERT INTO any_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Zozi juli Zoliko kulo nɩn asʋ ɛbɛlɛ, ɔ lɛ kpɛ nun. ");
INSERT INTO any_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Anɩn bian kʋn wɔ ɛbɛlɛ. Bian sɔ'n, bɛ fɛlɛ yɩ́ Zase. Ɔ tɩ bɛ́ mɔ bɛ dide ajule'n-mɔ kpain ɛsɛ ɔ tɩ esikafʋɛ. ");
INSERT INTO any_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Ɔ kulo kɛ ɔ nwun sʋanlan'n mɔ bɛ fɛlɛ yɩ́ Zozi'n. Nan kʋsʋ kɛmɔ ɔ tɩ sʋanlan tika'n, meninsʋnman'n dunman nun, ɔ ngʋala nnwun man Zozi. ");
INSERT INTO any_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Ɛhɩ a, Zase kɔ bu bɛ́ nyunnun ɔ kɔ nwanndi ɔ kɔ hɔ kɔ fʋ baka kʋn asʋ. Baka sɔ'n, bɛ fɛlɛ yɩ́ sikomɔɔ. Yɩ́ dɩɛ anɩn ɔ nwun Zozi. Ɔ sanlɩn kɛ baka sɔ nɩn abʋ ɛbɛlɛ yɛ̂ Zozi 'sɩn ɔ. ");
INSERT INTO any_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Mɔ Zozi juli baka nɩn abʋ'n, ɔ kɔ tʋ yɩ́ nyɩn anwunno ɔ kɔ han kɔ hele Zase kɛ: “Zase, kan wɔ́ nwʋn ju asɩ. Ɔ sanlɩn kɛ ɛnɛ, wɔ́ awulo ɛlɔ yɛ̂ mɩn 'sike ɔ.” ");
INSERT INTO any_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Zase kɔ han yɩ́ nwʋn ɔ kɔ ju ɔ le fɛ elie ɔ kɔ sɔ Zozi nun. ");
INSERT INTO any_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Bɛ́ kʋalaa mɔ bɛ nwunlin yɩ́ sɔ'n kɔ fɛ ɛya. Bɛ́ nwan: “Sʋanlan ɛhɩ a hɔ a sike ɛtɛfʋɛ awulo!” ");
INSERT INTO any_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Zase kɔ jinlan yɛ́ Mɩn anyunnun, yɩ́ nwan: “Yɛmɩnlɩn, tie! Mɩn 'bu mɩ́n nwʋn ninnge nɩn anun mɩn tu yɩ́ ebue mɩn man ehianfʋɛ'n-mɔ. Sɛ n nili sʋanlan bie ndunlunmun an, mɩn 'bɔ yɩ́ nwʋn fâ nnan mɩn man yɩ́.” ");
INSERT INTO any_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Zozi kɔ han kɔ hele yɩ́ kɛ: “Ɛnɛ, awulo ɛhɩ anun menian'n-mɔ a nyan ngʋan. Ɔ sanlɩn kɛ sʋanlan ɛhɩ kʋsʋ tɩ Abalahamʋn abʋsʋ sʋanlan. ");
INSERT INTO any_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Afɩ *Mân Baa'n walɩ kɛ ɔ 'ba kpʋnndɛ bɛ́ mɔ b'a minlin'n-mɔ nán ɔ de bɛ́ ngʋan.” ");
INSERT INTO any_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Ɛsɛ Zozi kɔ bu anyɩnndala kʋn biekun ɔ kɔ hele bɛ́ mɔ anɩn bɛ lɛ tie ɛjɔlɛ sɔ'n-mɔ'n. Afɩ, kɛmɔ anɩn bɛ ka kaan bɛ ju Zoluzalɛmʋn'n, menian'n-mɔ jʋnlɩn kɛ bɛ 'ka ɛbɛlɛ ala bɛ nwun Nyanmɩan Belemgbin Mân'n. ");
INSERT INTO any_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Ɛhɩ a, Zozi nwan: “Dɩhyɩɛ kʋn fi yɩ́ mân dɩɛ anun kɔ hɔ mân bie anun. Mân sɔ'n wɔ mʋa kpa. Ɔ 'kɔ maan bɛ sie yɩ́ belemgbin nán ɔ sa ba. ");
INSERT INTO any_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Mɔ ɔ 'ba hɔ'n, ɔ kɔ fɛfɛlɛ yɩ́ ngʋa'n-mɔ anun bulu. Ɔ kɔ wowula bɛ́ nun kʋn biala asa nun esika kɔkɔlɛ mma ngʋkʋn. Yɩ́ nwan: ‘Ɛmɔ fá lí junman dede maan m mála.’ ");
INSERT INTO any_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","“Dɩhyɩɛ sɔ'n mân nɩn anun menian'n-mɔ ngulo man yɩ́ ɛjɔlɛ, bɛ kpɔ yɩ́. Nan mɔ dɩhyɩɛ'n hɔlɩ'n, bɛ kɔ yɩ menian maan bɛ kɔ si yɩ́ sʋ. Bɛ hɔlɩ juli ɛlɔ a, bɛ́ nwan: ‘Yɛ ngulo man kɛ bian ɛhɩ di yɛ́ sʋ belemgbin.’ ");
INSERT INTO any_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Bɛ kɔ sie dɩhyɩɛ sɔ'n belemgbin, ɔ kɔ sa kɔ a yɩ́ mân nɩn anun. Ɔ kɔ man bɛ kɔ fɛfɛlɛ yɩ́ ngʋa'n-mɔ m'ɔ falɩ esika'n manlɩn bɛ́'n kɛ bɛ bála a bu mgbʋnndan bɛ héle yɩ́. ");
INSERT INTO any_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","“Alimʋa akʋa'n juli ɛbɛlɛ a, yɩ́ nwan: ‘Yɛmɩnlɩn, m'an nyan bulu m'an bʋka mɔ ɛ falɩ manlɩn mɩ́n nɩn asʋ.’ ");
INSERT INTO any_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","“Belemgbin'n kɔ han kɔ hele yɩ́ kɛ: ‘Akʋa kpa, mo! Kɛmɔ ninnge kaan ɛhɩ-mɔ anun m'an nwun wɔ́ ti anun'n, mɩn 'fa wɔ́ mɩn sie kulo mgbili bulu asʋ kpain.’ ");
INSERT INTO any_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","“M'ɔ tɔ sʋ nnyuan'n kɔ a. Yɩ́ nwan: ‘Yɛmɩnlɩn, m'an nyan nnun m'an bʋka mɔ ɛ falɩ manlɩn mɩ́n nɩn asʋ.’ ");
INSERT INTO any_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","“Belemgbin kɔ han kɔ hele yɩ́ kɛ: ‘Mɩn 'fa wɔ́ kʋsʋ mɩn sie kulo mgbili nnun asʋ kpain.’ ");
INSERT INTO any_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Akʋa kʋn biekun walɩ a, yɩ́ nwan: ‘Yɛmɩnlɩn, ɛ 'nwun wɔ́ esika'n. N valɩ n vɩalɩ hanmɩntɩ duku nun. ");
INSERT INTO any_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Mɩn sulo wɔ́, ɔ sanlɩn kɛ ɛ tɩ sʋanlan mɔ wɔ́ ɛjɔlɛ elie yɔ yalɛ. Lɩka mɔ a nzie man like'n, ɛbɛlɛ like yɛ̂ ɛ fa ɔ. Lɩka mɔ a nnu a man like'n, ɛbɛlɛ like yɛ̂ ɛ tɩ ɔ.’ ");
INSERT INTO any_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","“Mɔ akʋa nɩn anʋan tɔlɩ'n, belemgbin'n nwan: ‘Akʋa ati anun ɛtɛ, wɔ́ nʋan ɛjɔlɛ nɩn anwʋn yɛ̂ mɩn 'nɩan mɩn tua wɔ́ kalɛ ɔ. Ɛ sɩ kɛ n dɩ sʋanlan mɔ yɩ́ ɛjɔlɛ elie yɔ yalɛ, lɩka mɔ m'an nzie man like'n, ɛbɛlɛ like yɛ̂ mɩn fa ɔ. Lɩka mɔ m'an nnu a man like'n, ɛbɛlɛ like yɛ̂ mɩn tɩ ɔ. ");
INSERT INTO any_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Ɔ yɔ sɛ mɔ afɩ a ngɔ a nva man mɩ́n esika nɩn a ndʋ man bankɩ ɔ? Ahan kɛ n vi ɛlɔ m malɩ'n, mɩn kʋala kɛ mɩn de sʋ nvasʋɛ'n.’ ");
INSERT INTO any_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","“Mɔ belemgbin hanlɩn sɔ yuelɩ'n, ɔ kɔ han kɔ hele bɛ́ mɔ bɛ wɔ ɛbɛlɛ'n kɛ: ‘Ɛmɔ tʋ́a yɩ́ lé esika kɔkɔlɛ mma sɔ'n bɛ mán sʋanlan'n m'ɔ le bulu'n.’ ");
INSERT INTO any_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","“Bɛ́ mɔ bɛ gua ɛbɛlɛ'n, bɛ kɔ han kɔ hele belemgbin'n kɛ: ‘Yɛmɩnlɩn, yɩ́ dɩɛ, ɔ'a li mʋa ɔ'a nyan bulu!’ ");
INSERT INTO any_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","“Belemgbin nwan: ‘Mɩɩn kan mɩn kele ɛmɔ kɛ sʋanlan m'ɔ le bie'n, bɛ 'man yɩ́ dɔʋn. Nan sʋanlan m'ɔ le man bie fɩ́ɩ́'n, kaan'n m'ɔ le'n, bɛ 'tʋa yɩ́ bɛ de. ");
INSERT INTO any_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Bɛ́ mɔ bɛ kpɔ mɩ́n mɔ b'a ngulo man kɛ mɩn sie bɛ́'n, bɛ fá bɛ́ kʋsʋ bɛ fíte mɩ́n nyunnun ɛwa bɛ hún bɛ́.’” ");
INSERT INTO any_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Mɔ Zozi buli anyɩnndala sɔ'n yuelɩ mɔ bɛ 'kɔ Zoluzalɛmʋn'n, ɔ li yɩ́ menian'n-mɔ anyunnun. ");
INSERT INTO any_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Mɔ bɛ hɔlɩ dede mɔ bɛ ka kaan bɛ ju Bɛtɩfaze nʋn Betanin kulo'n m'ɔ mantan bʋka'n mɔ bɛ fɛlɛ yɩ́ *Olivʋ bʋka'n, Zozi kɔ sʋan yɩ́ menian'n-mɔ anun nnyuan yɩ́ nyunnun. ");
INSERT INTO any_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Yɩ́ nwan: “Ɛmɔ hɔ́ kulo'n m'ɔ wɔ yɛ́ nyunnun ɛlɔ nɩn asʋ. Sɛ ɛmɔ ju ɛlɔ a, ɛmɔ 'ba nwun kɛ afunlunmun baa kʋn mɔ sʋanlan fɩ́ɩ́ fʋlɩ man sʋ lé mɩnnda ɛbɛlɛ. Ɛmɔ nyánnjɩ yɩ́ bɛ bɛ́lɛ mɩ́n ɛwa. ");
INSERT INTO any_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Sɛ sʋanlan bisa ɛmɔ kɛ: ‘Nzukɛ ati yɛ̂ ɛmɔ lɛ nyannjɩ yɩ́ ɔ?’ Ɛmɔ hán kɛ: ‘Yɛ́ Mɩn a hian yɩ́ nwʋn.’” ");
INSERT INTO any_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Bɛ́ mɔ Zozi sʋanlɩn bɛ́'n hɔlɩ nwunlin yɩ́ kʋalaa kɛ ɔ hanlɩn helelɩ bɛ́'n. ");
INSERT INTO any_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Mɛlɛ mɔ bɛ 'nyannjɩ afunlunmun baa'n, bɛ́ mɔ bɛ le yɩ́'n kɔ bisa bɛ́ kɛ: ‘Nzukɛ ati yɛ̂ ɛmɔ lɛ nyannjɩ afunlunmun baa nɩn ɔ?’ ");
INSERT INTO any_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Zozi menian nnyuan'n kɔ bua bɛ́ kɛ: ‘Yɛ́ Mɩn a hian yɩ́ nwʋn.’ ");
INSERT INTO any_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Ɛhɩ a, bɛ kɔ fa afunlunmun baa'n bɛ kɔ bɛlɛ Zozi. Bɛ kɔ yɩyɩ bɛ́ taladɩɛ'n bɛ kɔ gua sʋ. Bɛ kɔ man Zozi kɔ fʋ kɔ tanlan sʋ. ");
INSERT INTO any_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Zozi 'kɔ a, anɩn menian'n-mɔ lɛ yɩyɩ bɛ́ taladɩɛ'n-mɔ bɛ sɩsɛ yɩ́ atɩn nɩn anun. ");
INSERT INTO any_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Mɔ anɩn bɛ ka kaan bɛ ju Olivʋ bʋka atɩn'n m'ɔ tʋlʋ kɔ Zoluzalɛmʋn nɩn asʋ'n, bɛ́ kʋalaa mɔ bɛ si Zozi sʋ'n kɔ li fɛ bɛ kɔ bɔ bɛ kɔ sulo. Bɛ kɔ yɩ Nyanmɩan ayɛ ɔ fi asinbɛnwʋn ninnge'n-mɔ mɔ b'a nwun yɩ́ nɩn anwʋn. ");
INSERT INTO any_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Bɛ́ nwan: “Nyila hán belemgbin'n m'ɔ lɛ ba wɔ yɛ́ Mɩn dunman nun'n! Alʋacɩcɩɛ wɔ anwunno, anunminnyanmʋn hán Nyanmɩan!” ");
INSERT INTO any_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Anɩn *Falisifʋɛ mmie-mɔ wɔ meninsʋnman nɩn anun. Bɛ kɔ han bɛ kɔ hele Zozi kɛ: “Kpain, kan kele wɔ́ menian'n-mɔ kɛ bɛ múan bɛ́ nʋan.” ");
INSERT INTO any_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Zozi kɔ bua bɛ́ kɛ: “Mɩɩn kan mɩn kele ɛmɔ kɛ sɛ bɛ muan bɛ́ nʋan an, nyɔbʋɛ'n-mɔ 'bɔ sulo!” ");
INSERT INTO any_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Mɔ Zozi juli Zoluzalɛmʋn anwʋn ɛbɛlɛ mɔ yɩ́ nyɩn bɔlɩ kulo'n, ɔ kɔ sun kɔ gua yɩ́ nwʋn. ");
INSERT INTO any_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Yɩ́ nwan: “Sɛ ɔ tɩ kɛ ɛ tɩ ɛjɔlɛ abʋ a, ahan ɛnɛ wɔ́ kʋsʋ, ɛ 'nwun alʋacɩcɩɛ atɩn'n! Nan kʋsʋ, ɛ ngʋala man kɛ ɛ nwun yɩ́. Ɔ sanlɩn kɛ ɔ tɩ like mɔ ɔ'a fɩa wɔ́ nyɩn. ");
INSERT INTO any_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Mɛlɛ'n lɛ ba, bɛ́ mɔ bɛ kpɔ wɔ́'n, bɛ 'cɩ wɔ́ nwʋn ɛnwanlan kunngun kpa. Bɛ 'ta bɛ si bɛ yia wɔ́. Bɛ 'kele wɔ́ ahʋlʋwa wɔ́ bɛ̂ nʋn wɔ́ fama. ");
INSERT INTO any_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Bɛ 'bɔ wɔ́ bʋsʋ bɔkɔɔ, wɔ́, ɔ nʋn wɔ́ mma'n-mɔ. Bɛ 'bubu kulo'n bɔkɔɔ bɛ gua yɩ́ asɩ. Ɔ sanlɩn kɛ a nnwun man mɛlɛ'n mɔ Nyanmɩan walɩ wɔ́ ti ele'n!” ");
INSERT INTO any_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Zozi kɔ hɔ kɔ wʋlʋ Nyanmɩan awulo ɛbɛlɛ, ɔ kɔ fʋan bɛ́ mɔ anɩn bɛ lɛ di nun gua'n. ");
INSERT INTO any_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Yɩ́ nwan: “Ɛhɛlɛ Ɛjɔlɛ'n kele kɛ: Mɩ́n sua'n tɩ asɔnɩn ɛyɔlɛ sua. Nan ɛmɔ dɩɛ, ɛmɔ a fa a kaci awofʋɛ sua.” ");
INSERT INTO any_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Ɛhɩ anzin, cɩan daa, Zozi kekele like Nyanmɩan awulo nɩn anun. *Tɛɛyɩfʋɛ mgbain'n-mɔ, *mala nɩn asʋ mgbain'n-mɔ nʋn mân nɩn asʋ mgbain'n-mɔ kulo kɛ bɛ kun yɩ́. ");
INSERT INTO any_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Kʋsʋ bɛ nnwun man atɩn mɔ bɛ 'bu sʋ ɔ. Ɔ sanlɩn kɛ bagua'n yɔ anzʋɛ kpa ɔ tie ɛjɔlɛ'n mɔ Zozi kan'n. ");
INSERT INTO any_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Ɛhɩ, anɩn Zozi lɛ kekele menian'n-mɔ ninnge Nyanmɩan awulo nɩn anun, ɛsɛ anɩn ɔ lɛ bɔ Ɛjɔlɛkpa'n kele bɛ́. Kʋnmgba ala, tɛɛyɩfʋɛ mgbain'n-mɔ, mala nɩn asʋ mgbain'n-mɔ nʋn Izalayɛ mgbain'n-mɔ kɔ a ");
INSERT INTO any_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","kɔ bisa yɩ́ kɛ: “Kele yɛ́ tunmin ɛhɔlɛ kʋn'n mɔ ɛ fa yɔ ninnge ɛhɩ-mɔ'n, ɔ nʋn sʋanlan'n m'ɔ manlɩn wɔ́ yɩ́ nwʋn atɩn'n?” ");
INSERT INTO any_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Zozi kɔ bua bɛ́ kɛ: “Mɩ́n kʋsʋ mɩ́n, mɩn 'ba bisa ɛmɔ kosuan kʋn. Ɛmɔ búa mɩ́n bie. ");
INSERT INTO any_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Nwan y'ɔ sʋanlɩn Zʋan kɛ ɔ bála ɔ sɔ́nɩn menian'n-mɔ'n, Nyanmɩan anaan kulo menian ɔ?” ");
INSERT INTO any_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Mɔ Zozi bisalɩ bɛ́ kosuan sɔ'n, akpʋlʋwa kɔ tɔ bɛ́ afian. Bɛ́ nwan: “Sɛ yɛ kan kɛ: ‘Nyanmɩan y'ɔ sʋanlɩn yɩ́’ a, ɔ 'bisa yɛ́ kɛ: ‘Anɩn ɔ yɔ sɛ mɔ ɛmɔ a nne man Zʋan b'a nni man'n?’ ");
INSERT INTO any_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Nan sɛ yɛ kan kɛ: ‘Kulo menian'n-mɔ yɛ̂ bɛ sʋanlɩn yɩ́’ a, bagua bɔndɩn'n 'tʋtʋ yɛ́ ɛbʋɛ bɛ kun yɛ́. Ɔ sanlɩn kɛ, bɛ́ kʋalaa bɛ de bɛ tʋ nun kɛ Zʋan tɩ Nyanmɩan kpɔmanfʋɛ.” ");
INSERT INTO any_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Ɛhɩ a, bɛ kɔ bua Zozi kɛ: “Yɛ nzɩ man sʋanlan'n m'ɔ sʋanlɩn Zʋan'n.” ");
INSERT INTO any_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Zozi kʋsʋ nwan: “Kɛmɔ ɛmɔ nzɩ man sʋanlan'n m'ɔ sʋanlɩn Zʋan'n, mɩ́n kʋsʋ mɩn ngele man ɛmɔ tunmin ɛhɔlɛ kʋn'n mɔ mɩn fa mɩn yɔ ninnge ɛhɩ-mɔ'n.” ");
INSERT INTO any_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Ɛhɩ anzin, Zozi kɔ bu anyɩnndala ɛhɩka ɔ kɔ hele bagua'n, yɩ́ nwan: “Bian kʋn kɔ sʋn divɩn ebo. Ɔ kɔ fa kɔ wula menian asa nun, ɔ kɔ tu atɩn ɔ kɔ hyɛ ɛlɔ. ");
INSERT INTO any_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Tɛmʋn mɔ divɩn nɩn ɛtɩɛ'n juli'n, ɔ kɔ sʋan akʋa kʋn kpafʋ'n-mɔ anwʋn ɛlɔ kɛ ɔ hɔ́ lé yɩ́ dɩɛ'n bɛ́lɛ yɩ́. Akʋa'n hɔlɩ juli ɛlɔ a, kpafʋ'n-mɔ kɔ bili yɩ́ bɛ kɔ fʋan yɩ́, ɔ le yɩ́ sa to ɔ kɔ sa kɔ hɔ. ");
INSERT INTO any_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Bian'n m'ɔ le ebo'n kɔ sʋan akʋa kʋn biekun kpafʋ'n-mɔ anwʋn ɛlɔ. Kpafʋ'n-mɔ kɔ bili yɩ́ kʋsʋ, bɛ kɔ kpɩkpɛ yɩ́ nzʋba, bɛ kɔ fʋan yɩ́, ɔ le yɩ́ sa to ɔ kɔ sa kɔ hɔ. ");
INSERT INTO any_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Ɛsɛ bian'n kɔ sʋan yɩ́ akʋa'n kʋn biekun ɔ kɔ tian yɩ́ nsan kpafʋ'n-mɔ anwʋn ɛlɔ. Kpafʋ'n-mɔ kɔ bʋta bʋta yɩ́, ɛsɛ bɛ kɔ fʋan yɩ́ bɛ kɔ tʋ sʋ. ");
INSERT INTO any_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","“Ɛhɩ a, bian'n m'ɔ le ebo'n kɔ bisa yɩ́ nwʋn kɛ: ‘Anɩn nzu y'ɔ di kɛ mɩn yɔ ɔ? Mɩn 'ba sʋan mɩ́n wa'n mɔ mɩn kulo yɩ́'n bɛ́ nwʋn ɛlɔ. Kɛmɔ ɔ tɩ mɩ́n kunnun baa'n, ɛ 'su yɩ́ akpʋlʋwa a, bɛ 'ba man yɩ́ anyɩnnzɔ.’ ");
INSERT INTO any_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","“Mɔ kpafʋ'n-mɔ nwunlin yɩ́'n, bɛ kɔ han yɩ́ bɛ́ afian ɛlɔ kɛ: ‘Ɛ 'nwun bian'n koliaja'n. Yɛ hún yɩ́ maan ebo'n há yɛ́ sa nun.’ ");
INSERT INTO any_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Bɛ kɔ ju yɩ́ bɛ kɔ tʋ ahanmɩan bɛ kɔ hun yɩ́.” Zozi kɔ bisa bɛ́ kɛ: “Kɛmɔ ɛjɔlɛ nɩn a yɔ sʋa'n, bian'n m'ɔ le ebo'n, ɔ 'yɔ kpafʋ'n-mɔ sɛ? ");
INSERT INTO any_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Ɔ 'ba, ɔ 'kun kpafʋ sɔ'n-mɔ ɔ fa yɩ́ ebo'n ɔ wula menian nvʋfɔlɛ asa nun.” Mɔ menian'n-mɔ tɩlɩ ɛjɔlɛ sɔ'n, bɛ́ nwan: “Cɛcɛ, ɛjɔlɛ'n n'ɔ ba yɩ́ ɛbɛlɛ sɔ!” ");
INSERT INTO any_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Nan mɔ bɛ hanlɩn sɔ'n, Zozi kɔ nɛnɩan bɛ́. Yɩ́ nwan: “Ɛhɛlɛ Ɛjɔlɛ ɛhɩ abʋ'n kele sɛ? Ɛbʋɛ'n mɔ bɛ́ mɔ bɛ lɛ si sua'n juli tʋlɩ'n, yɩ́ yɛ̂ ɔ'a kaci ayialɩɛ nɩn asʋ ɛbʋɛ cɩnnjɩn nɩn ɔ. ");
INSERT INTO any_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Sʋanlan biala m'ɔ kɔ tɔ ɛbʋɛ sɔ nɩn asʋ'n, ɔ 'bʋta yɛ̂ sʋanlan kʋsʋ mɔ ɛbʋɛ sɔ'n kɔ tɔ yɩ́ sʋ'n, ɔ 'nunkun yɩ́.” ");
INSERT INTO any_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Mɔ Zozi buli anyɩnndala'n yuelɩ'n, *mala nɩn asʋ mgbain'n-mɔ nʋn *tɛɛyɩfʋɛ mgbain'n-mɔ kɔ nwun kɛ bɛ́ ti yɛ̂ Zozi buli anyɩnndala sɔ nɩn ɔ. Ɛbɛlɛ ala, bɛ 'kpʋnndɛ kɛ bɛ cɩ yɩ́. Nan kʋsʋ bagua'n dunman nun, bɛ sulo. ");
INSERT INTO any_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Ɛhɩ a, bɛ́ nyɩn kpala Zozi. Yɩ́ ti, bɛ kɔ sʋan menian Zozi anwʋn ɛlɔ. Menian sɔ'n-mɔ kɔ yɔ bɛ́ nwʋn kɛ sɛsɛfʋɛ-mɔ. Bɛ́ y'ɔ di kɛ bɛ sua Zozi ngaa maan ɔ tɔ nun bɛ cɩ yɩ́ bɛ man awaa ɔ. ");
INSERT INTO any_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Menian sɔ'n-mɔ kɔ bisa Zozi kosuan ɛhɩ kɛ: “Kpain, yɛ sɩ kɛ like mɔ ɛ kekele'n tɩ fɔ́ʋ́n. Ɛ nnɩan man sʋanlan anyunnun ɛ mmua man yɩ́ ndɛɛ. Atɩn mɔ Nyanmɩan kulo kɛ menian'n-mɔ nanndɩ sʋ nán yɩ́ kunnun a jɔ'n, ɛ kekele yɩ́ ananhɔlɛ. ");
INSERT INTO any_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Yɩ́ ti, kan maan yɛ tɩ́. Asʋ ɔ wɔ nun kɛ yɛ túa ajule'n yɛ mán *Lɔmʋn belemgbin *Sezaa anaan nán man yɛ tua yɛ man yɩ́?” ");
INSERT INTO any_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Zozi kɔ nwun mɔ b'a jʋnlɩn'n. Ɔ kɔ han kɔ hele bɛ́ kɛ: ");
INSERT INTO any_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Ɛmɔ fá bɛ́ esika'n kʋn bɛ héle mɩ́n. Nwan nvoninnin ɔ nʋn dunman benin y'ɔ gua sʋ ɔ?” Bɛ kɔ bua Zozi kɛ: “Belemgbin Sezaa ɔ.” ");
INSERT INTO any_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Zozi kɔ han kɔ hele bɛ́ kɛ: “Sɛ ɛjɔlɛ'n tɩ sʋa a, anɩn ɛmɔ túa m'ɔ tɩ belemgbin dɩɛ'n bɛ mán yɩ́, nunhan kʋsʋ m'ɔ tɩ Nyanmɩan dɩɛ'n, ɛmɔ túa bɛ mán Nyanmɩan.” ");
INSERT INTO any_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Kɛ Zozi kpɩnlɩn bualɩ bɛ́'n, b'a nnyan man yɩ́ nzin ɛjɔlɛ b'a ngan man wɔ bagua nɩn anyunnun. Ɔ sanlɩn kɛ Zozi mmua'n sinlin bɛ́ nwʋn. Ɔ man bɛ muanlɩn bɛ́ nʋan nɩn asʋ koun. ");
INSERT INTO any_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Ɛhɩ, *Sadusifʋɛ mmie-mɔ kɔ a Zozi anwʋn ɛbɛlɛ. Bɛ́ yɛ̂ bɛ kan kɛ ewuetinnge nnʋn man ɛbɛlɛ nɩn ɔ. Bɛ kɔ susu ɛjɔlɛ ɛhɩ bɛ kɔ hele Zozi, ");
INSERT INTO any_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","bɛ́ nwan: “Kpain, Moyizɩ a hɛlɛ mala ɛhɩ a man yɛ́ kɛ: Sɛ belenzua kʋn le yɩ́ nianman belenzua m'ɔ ja bala, sɛ ɔ nʋn yɩ́ yɩ b'a nwʋn man baa nán ɔ wu a, anɩn belenzua'n fá kunlannvʋɛ balasua'n ɔ já. Ɔ nʋn yɩ́ bɛ wʋ́ mma bɛ mán yɩ́ nianman'n. ");
INSERT INTO any_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Anɩn anianman mmelenzua nsʋ wɔ ɛbɛlɛ. Nunhan kpain'n kɔ ja bala. Ɔ nʋn bala'n b'a nwʋ man baa, ɔ kɔ wu. ");
INSERT INTO any_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","M'ɔ tɔtʋa yɩ́'n kɔ ja kunlannvʋɛ balasua sɔ'n. ");
INSERT INTO any_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","M'ɔ tian yɩ́ nsan'n kʋsʋ kɔ ja yɩ́. Bɛ́ menian'n nsʋ'n kʋalaa bɛ kɔ ja balasua sɔ'n, bɛ nʋn yɩ́ ngɔ wʋ man baa, bɛ́ kʋalaa bɛ kɔ yue wu. ");
INSERT INTO any_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Yɩ́ bɛ-yue-asɩɛ, balasua'n kʋsʋ kɔ wu. ");
INSERT INTO any_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Ewuetinnge cɩan'n, bɛ́ nunhan benin yɛ̂ ɔ 'fa bala nɩn ɔ? Afɩ bɛ́ anianman nsʋ'n kʋalaa b'a ja balasua sɔ'n bie!” ");
INSERT INTO any_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Mɔ bɛ bisalɩ kɔsuan sɔ'n, Zozi kɔ bua bɛ́ kɛ: “Mɛlɛ ɛhɩ anun menian'n-mɔ ja bɛ́ nwʋn. ");
INSERT INTO any_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Nan menian m'ɔ sɛ fata kɛ bɛ fi ewue nun bɛ tínnge bɛ tánlan mân'n m'ɔ lɛ ba nɩn anun ɛlɔ'n, bɛ́ dɩɛ bɛ nja man bɛ́ nwʋn. ");
INSERT INTO any_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Bɛ nwu man kʋ́n, ɔ sanlɩn kɛ, bɛ 'ba kaci kɛ nyanmɩansʋ mmɔfʋɛ'n-mɔ. Bɛ 'kaci Nyanmɩan amma mmelenzua, afɩ bɛ fi ewue nun b'a tinnge. ");
INSERT INTO any_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Ewuetinnge'n, yɩ́ nwʋn ɛjɔlɛ yɛ̂ Moyizɩ hanlɩn nɩn ɔ. Lɩka'n mɔ bɛ lɛ kele kɛ baka'n sɔlɩ'n, Moyizɩ fɛlɛlɩ yɛ́ Mɩn ‘Abalahamʋn Nyanmɩan, Izakɩ Nyanmɩan yɛ̂ Zʋakɔbʋ Nyanmɩan.’ ");
INSERT INTO any_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Nyanmɩan tɩ bɛ́ mɔ bɛ́ nyɩn wɔ sʋ'n Nyanmɩan, nan ɔ tɩ man ewue mma Nyanmɩan. Ɔ sanlɩn kɛ yɩ́ nyunnun, menian sɔ'n-mɔ anyɩn wɔ sʋ.” ");
INSERT INTO any_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Mɔ Zozi bualɩ bɛ sɔ'n, *mala nɩn asʋ mgbain mmie-mɔ jasʋlɩ a, bɛ́ nwan: “Kpain, a han yɩ́ fɔ́ʋ́n.” ");
INSERT INTO any_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Bɛ́ bie fɩ́ɩ́ ngɔ bisa yɩ́ kosuan kʋ́n. ");
INSERT INTO any_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Ɛhɩ anzin, Zozi kɔ bisa bɛ́ kɛ: “Ɔ yɔ sɛ mɔ bɛ kan kɛ belemgbin *Davidi anʋnman y'ɔ le Kilisi'n, Belemgbin Ngʋandefʋɛ'n? ");
INSERT INTO any_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Izalayɛ ejue ɛtʋɛ kalata nɩn anun, Davidi muonun lɛ kele kɛ: Ɛdannganman a han a hele mɩ́n Mɩn kɛ: Tanlan mɩ́n fama sʋ, ");
INSERT INTO any_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","nán mɩn 'ba fa wɔ́ mgbɔfʋɛ'n-mɔ mɩn gua wɔ́ ja abʋ. ");
INSERT INTO any_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Davidi fɛlɛ yɩ́ ‘yɛ́ Mɩn’ Ɔ yɔ sɛ m'ɔ kʋala kɛ ɔ kaci Davidi anʋnman'n?” ");
INSERT INTO any_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Mɛlɛ mɔ anɩn meninsʋnman lɛ tie ɛjɔlɛ'n, Zozi kɔ han kɔ hele yɩ́ menian'n-mɔ kɛ: ");
INSERT INTO any_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Ɛmɔ nɩ́an bɛ́ nwʋn kpa wɔ *mala nɩn asʋ mgbain'n-mɔ anwʋn. Bɛ kulo taladɩɛ ndɩnndɩɩn ewula nanndɩ menian'n-mɔ anun. Gua nɩn asʋ, bɛ kulo kɛ menian bisa bɛ́ ahɩn anyɩnnzɔ nun. Asɔnɩn sua'n-mɔ anun ɔ nʋn like elie'n-mɔ anun, menian mgbili mgbili lɩka yɛ̂ bɛ kpʋnndɛ bɛ tanlan ɔ. ");
INSERT INTO any_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Bɛ kpʋkpʋ kunlannvʋɛ mmalasua'n-mɔ anwʋn bɔkɔɔ, ɛsɛ bɛ yɔ asɔnɩn ndɩnndɩɩn bɛ gua sʋ bɛ kele kɛ bɛ tɩ kpa. Bɛ́ nyɔlɩɛ sɔ'n-mɔ anwʋn ahatua mɔ bɛ 'ba nyan yɩ́'n, ɔ tɩ kpili sʋnman!” ");
INSERT INTO any_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Ɛhɩ anzin, Zozi kɔ tʋ yɩ́ nyɩn, ɔ 'nɩan an, anɩn esikafʋɛ'n-mɔ lɛ tʋ bɛ́ esika'n Nyanmɩan awulo nɩn anun lɩka mɔ bɛ tʋ acɛdɩɛ'n. ");
INSERT INTO any_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Ɔ kɔ nwun ehianfʋɛ kunlannvʋɛ balasua kʋn kʋsʋ kɛ anɩn ɔ lɛ tʋ nun babulu ngʋnkʋn nnyuan. ");
INSERT INTO any_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Ɛhɩ a, Zozi nwan: “Mɩɩn kan yɩ́ ananhɔlɛ mɩn kele ɛmɔ kɛ, ehianfʋɛ kunlannvʋɛ balasua ɛhɩ a tʋ dɔʋn a tala ɛhɩnlɩn-mɔ kʋalaatin. ");
INSERT INTO any_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Ɔ sanlɩn kɛ yɩ́ esika kʋalaa m'ɔ ka yɩ́ sa nun mɔ ɔ 'fa to like di'n, esika sɔ'n yɛ̂ ɔ'a fa ɔ'a tʋ nun ɔ. Nan ɛhɩnlɩn-mɔ dɩɛ, esika mɔ bɛ mmianlɩn man yɩ́ nwʋn'n yɛ̂ b'a tʋ yɩ́ nun ɔ.” ");
INSERT INTO any_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Mɔ hanlɩn sɔ yuelɩ'n, menian mmie-mɔ kɔ han Nyanmɩan sua nɩn anwʋn ɛjɔlɛ. Bɛ́ nwan nyɔbʋɛ'n mɔ b'a fa b'a si'n tɩ nganlanman nganlanman. Ninnge mɔ b'a fa b'a hye Nyanmɩan, mɔ b'a fa b'a sesie yɩ́ kunnun'n, bɛ́ kʋsʋ bɛ tɩ nganlanman nganlanman. Nan mɔ Zozi tɩlɩ ɛjɔlɛ sɔ'n, yɩ́ nwan: ");
INSERT INTO any_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Mɛlɛ'n lɛ ba, ɛbʋɛ ɛhɩ-mɔ mɔ ɛmɔ nwun yɩ́'n, fɩ́ɩ́ nga man ɛbɛlɛ. Bɛ 'kan yɩ́ kʋalaa bɛ gua asɩ.” ");
INSERT INTO any_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Mɔ Zozi hanlɩn sɔ'n, bɛ kɔ bisa yɩ́ kɛ: “Anɩn cɩan benin yɛ̂ nyɔbʋɛ sɔ'n-mɔ 'kan gua asɩ ɔ? Nzɔlɛ benin yɛ̂ ɔ 'kele kɛ like sɔ'n tɛmʋn a ju ɔ?” ");
INSERT INTO any_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Zozi kɔ bua bɛ́ kɛ: “Ɛmɔ nɩ́an bɛ́ nwʋn, nán bɛ yaci bɛ́ nwʋn maan bɛ laka bɛ́. Ɔ sanlɩn kɛ, menian dɔʋn 'ba fa mɩ́n dunman bɛ ba bɛ kan kɛ: ‘Kilisi'n, Belemgbin Ngʋandefʋɛ'n, y'ɔ le mɩ́n!’ ɛsɛ bɛ 'kan kɛ: ‘Mɛlɛ nɩn a ju!’ Bɛ kan sɔ a, nán bɛ si bɛ́ sʋ. ");
INSERT INTO any_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Ɛmɔ tɩ kɛ bɛ lɛ kan ɛlɔɛ nʋn emunlutie anwʋn ɛjɔlɛ a, nán bɛ man bɛ́ nyɩnsʋ tan bɛ́. Afɩ ɔ di kɛ ɛhɩ kʋalaa di mʋa ba kʋalaaka. Nan kʋsʋ nán kɛ mân'n 'ka ɛbɛlɛ ala ɔ yue ɔ.” ");
INSERT INTO any_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Zozi kɔ han kɔ tʋ sʋ kɛ: “Mân kʋn nʋn mân fʋfɔlɛ 'ba hʋn ɛlɔɛ. Belemgbin mân kʋn nʋn belemgbin mân fʋfɔlɛ 'ba hʋn ɛlɔɛ. ");
INSERT INTO any_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Lɩka dɔʋn, asɩɛ'n 'ba kpusu kpili kpa, ɛhɔɛ 'ba kpɩn, ewue m'ɔ sa kʋsʋ 'ba ju sʋ. Bɛ 'ba nwun ninnge esulo esulo ɔ nʋn nzɔlɛ mgbili mgbili kɛ ɔ fi nyanmɩansʋ. ");
INSERT INTO any_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Nan kʋsʋ, asannan nán yɩ́ kʋalaa a ju'n, bɛ 'ba hyɩ ɛmɔ, bɛ 'kele ɛmɔ ahʋlʋwa. Bɛ 'fa ɛmɔ bɛ wula bɛ́ mɔ bɛ li Zufʋ'n-mɔ asɔnɩn nɩn ati nɩn asa nun. Bɛ́ kʋsʋ bɛ 'bua ɛmɔ ndɛɛ bɛ gua ɛmɔ fiadɩ. Kɛmɔ ɛmɔ de mɩ́n di nɩn ati, bɛ nʋn ɛmɔ 'ba hɔ mmelemgbin'n-mɔ nʋn mân mgbain'n-mɔ aja sʋ. ");
INSERT INTO any_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Ɛbɛlɛ sɔ nɩn anun, ɛmɔ 'ba li mɩ́n nwʋn adanzɩɛ bɛ kele bɛ́. ");
INSERT INTO any_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Ɛmɔ mán bɛ ti tánlan sʋ kɛ ɛjɔlɛ mɔ ɛmɔ 'kan bɛ sa bɛ́ nɩn'n, nán bɛ di yɩ́ nwʋn yalɛ. ");
INSERT INTO any_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Ɔ sanlɩn kɛ, mɩ́n bɔbɔ muonun, mɩn 'fa ɛjɔlɛ'n ɔ nʋn ngɛlɛ'n m'ɔ fata'n mɩn wula ɛmɔ anʋan. Ɔ man bɛ́ mɔ bɛ kpɔ ɛmɔ'n ngɔ hʋala man bɛ́ nyunnun jinlan nán 'ba su yɩ́ akpʋlʋwa. ");
INSERT INTO any_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Ɛmɔ asɩ-mɔ nʋn ɛmɔ anin-mɔ, ɛmɔ anianman-mɔ, ɛmɔ anwʋn amma-mɔ nʋn ɛmɔ amanngʋn-mɔ muonun, bɛ 'yɩ ɛmɔ bɛ man. Ɛsɛ bɛ 'ba man bɛ kun ɛmɔ anun mmie-mɔ dɔʋn. ");
INSERT INTO any_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Mɩ́n dunman nun, menian'n-mɔ kʋalaa 'ba fa ɛmɔ anwʋn ɛkpɔ. ");
INSERT INTO any_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Nan kʋsʋ ɛmɔ nwún yɩ́ kɛ ɛmɔ ati enyuan kʋn sʋa mminlin man. ");
INSERT INTO any_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Ɛmɔ jínlan bɛ́ ja nun. Afɩ sɛ ɛmɔ jinlan bɛ́ ja nun an, ɛmɔ 'nyan bɛ́ ti. ");
INSERT INTO any_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Mɛlɛ mɔ ɛmɔ kɔ nwun kɛ ɛlɔɛ menian a ta a si a yia Zoluzalɛmʋn kulo'n, ɛmɔ tɩ́ yɩ́ bʋ kɛ yɩ́ ebubue tɛmʋn a ju a yue. ");
INSERT INTO any_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Tɛmʋn sɔ nɩn anun, bɛ́ mɔ bɛ wɔ Zude mân nɩn anun'n, bɛ nwánndi bɛ hɔ́ mmʋka'n-mɔ asʋ ɛlɔ. Bɛ́ mɔ bɛ wɔ Zoluzalɛmʋn kulo nɩn asʋ'n, bɛ nwánndi bɛ hɔ́ mʋa. Bɛ́ mɔ bɛ́ kʋsʋ bɛ wɔ nanmue nun'n, nán bɛ ba kulo. ");
INSERT INTO any_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Ɔ sanlɩn kɛ, tɛmʋn sɔ'n tɩ ndɛɛ ebua cɩan maan Ɛhɛlɛ Ɛjɔlɛ'n kʋalaa kpɩn sʋ. ");
INSERT INTO any_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Tɛmʋn sɔ nɩn anun, nwʋnnzɛfʋɛ nʋn bɛ́ mɔ bɛ nʋan mma, bɛ́ yakɔ! Ɔ sanlɩn kɛ Nyanmɩan sikpɛ'n 'cɩ menian ɛhɩ-mɔ ɔ man alʋabɔ kpili kpa tɔ mân nɩn anun. ");
INSERT INTO any_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Bɛ́ mɔ bɛ kpɔ bɛ́'n-mɔ 'ba fa dadɩɛ bɛ kun mmie-mɔ, ɛsɛ bɛ cɩ ɛhɩnlɩn-mɔ nóle bɛ nʋn bɛ́ kɔ mân mân'n kʋalaatin anun. Bɛ́ mɔ bɛ nzɩ man Nyanmɩan'n, bɛ 'ba sɛcɩ Zoluzalɛmʋn kulo'n bɔkɔɔ dede ɔ ju bɛ́ mɛlɛ dɩɛ nɩn ayuelɩɛ. ");
INSERT INTO any_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Bɛ 'ba nwun nzɔlɛ sɛnzɛ nɩn anun, sala nɩn anun ɔ nʋn nzalama'n-mɔ anun. Esulo 'ba han asɩɛ nɩn asʋ ɛwa menian'n-mɔ. Ɔ sanlɩn kɛ bɛ 'tɩ jenvie'n nʋn yɩ́ mgbaha'n m'ɔ lɛ bɔ nɩn angan an, anɩn like bie lɛ yɔ bɛ́. ");
INSERT INTO any_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Kɛmɔ anwunno ɛlɔ ninnge'n-mɔ 'ba kpusu'n, esulo 'ba han menian'n-mɔ bɛ susu dede bɛ wu. Ɔ sanlɩn kɛ asɩɛ nɩn asʋ ɛwa yɛ̂ ninnge sɔ'n-mɔ 'ba yue ɔ. ");
INSERT INTO any_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Ɛbɛlɛ nɩn anun, bɛ 'ba nwun *Mân Baa'n kɛ ɔ le tunmin nʋn anunminnyanmʋn kpili kpa, ɔ wɔ bɔlɛ́ nɩn anun ɔ lɛ ba. ");
INSERT INTO any_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Sɛ ɛmɔ nwun yɩ́ kɛ ninnge sɔ'n-mɔ lɛ yɩ bɛ́ nwʋn an, anɩn ɛmɔ tɩ́nngɛ bɛ́ nwʋn nun bɛ kúku bɛ́ ti sʋ. Ɔ sanlɩn kɛ anɩn ɛmɔ ati ele tɛmʋn a ju a yue.” ");
INSERT INTO any_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Ɛhɩ anzin, Zozi kɔ bu anyɩnndala ɛhɩ kɔ hele bɛ́, yɩ́ nwan: “Ɛmɔ tʋ́ bɛ́ nyɩn bɛ nɩ́an *figi baka'n nʋn mmaka ɛhɩnlɩn-mɔ kʋalaatin. ");
INSERT INTO any_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Tɛmʋn mɔ ɛmɔ kɔ nwun kɛ bɛ lɛ fɩfɛ'n, anɩn ɛmɔ sɩ kɛ mɛlɛ kpa nɩn a ju a yue. ");
INSERT INTO any_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Kɛ ɔ tɩ yɩ́ nɩn anɩn, sɛ ɛmɔ nwun kɛ ninnge sɔ'n-mɔ lɛ ba a, anɩn ɛmɔ tɩ́ yɩ́ bʋ kɛ Nyanmɩan Belemgbin Mân nɩn a mantan kʋkʋ. ");
INSERT INTO any_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“Mɩɩn kan yɩ́ ananhɔlɛ mɩn kele ɛmɔ kɛ ajulisʋ menian ɛhɩ-mɔ, bɛ́ kʋalaa bɛ ngɔ yue man wu nán ɛhɩ kʋalaa a ju. ");
INSERT INTO any_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Anwunno nʋn asɩ'n 'ba kpɛ nun, nan mɩ́n nʋan ɛjɔlɛ'n, ɔ mgbɛ man nun lé. ");
INSERT INTO any_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Ɛmɔ nɩ́an bɛ́ nwʋn! Nán bɛ yaci bɛ́ nwʋn maan edidie nʋn nzan ɛnʋan ɛjɔlɛ ɔ nʋn eyuadɩ ɛhɩ anun nzusue wʋlʋ ɛmɔ ajʋnlɩn nun. Sɛ ɔ yɔ sɔ a, *Mân Baa nɩn ɛwalɛ'n 'di ɛmɔ nvu nun baa kʋnmgba. ");
INSERT INTO any_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Ɔ sanlɩn kɛ, yɩ́ ɛwalɛ'n 'ba yɔ kɛ dada mɔ bɛ lɛ tʋ bɛ gua asɩɛ nɩn asʋ menian'n-mɔ asʋ ɔ. ");
INSERT INTO any_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Ɛmɔ nɩ́an bɛ́ nwʋn, bɛ yɔ́ asɔnɩn tɛmʋn biala nán ɛmɔ a nwanndi ninnge sɔ'n-mɔ b'a hʋala Mân Baa nɩn anyunnun fite.” ");
INSERT INTO any_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Alɩhɩan nɩn anun, Zozi kekele menian'n-mɔ ninnge Nyanmɩan awulo nɩn anun. Nan nɔsʋba, ɔ kɔ bʋka'n mɔ bɛ fɛlɛ yɩ́ *Olivʋ bʋka nɩn asʋ. Ɛlɔ y'ɔ da ɔ. ");
INSERT INTO any_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Ngɛlɛmɔ, menian'n-mɔ kʋalaa ba ndɛ bɛ ba tie Zozi Anʋan Ɛjɔlɛ'n Nyanmɩan awulo ɛbɛlɛ. ");
INSERT INTO any_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Ɛhɩ, anɩn Zufʋ'n-mɔ fɛtɩ'n mɔ bɛ fɛlɛ yɩ́ *Pakɩ'n, mɔ bɛ di kpaʋn'n mɔ fali ayile nnʋn man nun'n ka kaan ju. ");
INSERT INTO any_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Kɛmɔ *tɛɛyɩfʋɛ mgbain'n-mɔ nʋn *mala nɩn asʋ mgbain'n-mɔ sulo kɛ bɛ cɩ Zozi a, bagua'n 'ba jasʋ bɛ kɔmɩn anun'n, bɛ kɔ kpʋnndɛ atɩn mɔ bɛ 'sɩn sʋ bɛ kun Zozi. ");
INSERT INTO any_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Ɛhɩ, *Satan kɔ wʋlʋ Zudasɩ mɔ bɛ fɛlɛ yɩ́ Isikaliɔtɩ nɩn anun. Zudasɩ sɔ'n, ɔ wɔ Zozi menian bulu nʋn nnyuan nɩn anun bie. ");
INSERT INTO any_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Zudasɩ kɔ hɔ kɔ tʋ tɛɛyɩfʋɛ mgbain'n-mɔ nʋn Nyanmɩan awulo nɩn asʋ nzalafʋ mgbain'n-mɔ. Ɔ nʋn bɛ́ bɛ kɔ han atɩn mɔ ɔ 'bu sʋ ɔ yɩ Zozi man bɛ́ nɩn anwʋn ɛjɔlɛ. ");
INSERT INTO any_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Mɔ Zudasɩ hanlɩn sɔ helelɩ bɛ́'n, ɔ kɔ yɔ bɛ́ fɛ sʋnman. Bɛ kɔ bɔbʋa Zudasɩ kɛ sɛ ɔ man bɛ sa kan Zozi sakpa a, bɛ 'man yɩ́ esika. ");
INSERT INTO any_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Zudasɩ kɔ tie. Ɔ kɔ kpʋnndɛ atɩn mɔ ɔ 'sɩn sʋ ɔ yɩ Zozi man bɛ́ nán bagua nɩn a nnwun man nun. ");
INSERT INTO any_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Ɛhɩ, cɩan'n mɔ bɛ di kpaʋn'n mɔ fali ayile'n nnʋn man nun'n kɔ ju. Cɩan sɔ'n y'ɔ fata kɛ bɛ kun mmʋa mma'n-mɔ mɔ bɛ 'fa bɛ tʋn *Pakɩ alɩɛ nɩn ɔ. ");
INSERT INTO any_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Zozi kɔ sʋan Pɩɛlɩ nʋn Zʋan. Yɩ́ nwan: “Ɛmɔ hɔ́ tʋ́n yɛ́ Pakɩ alɩɛ'n.” ");
INSERT INTO any_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Pɩɛlɩ nʋn Zʋan kɔ bisa yɩ́ kɛ: “Nin lɩka dɩɛ yɛ̂ ɛ kulo kɛ yɛ tʋn yɩ́ ɔ.” ");
INSERT INTO any_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Zozi kɔ bua bɛ́ kɛ: “Ɛmɔ kɔ ju kulo ɛlɔ a, ɛmɔ nʋn belenzua kʋn 'ba yia. Ɔ sʋ nzue bua nun. Ɛmɔ sí yɩ́ sʋ bɛ wʋ́lʋ awulo'n m'ɔ kɔ wʋlʋ nun nɩn anun. ");
INSERT INTO any_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Ɛmɔ ju ɛbɛlɛ a, bɛ hán bɛ héle sʋanlan'n m'ɔ le awulo'n kɛ: ‘Kpain nwan yɛ bísa wɔ́ kɛ: Nin lɩka dɩɛ yɛ̂ ɔ nʋn yɩ́ menian'n-mɔ bɛ 'di Pakɩ alɩɛ'n?’ ");
INSERT INTO any_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Sɛ ɛmɔ bisa yɩ́ a, ɔ 'kele ɛmɔ dabɛlɛ kpili kʋn awaa nɩn asʋ ɛlɔ. B'a sesie nun. Ɛmɔ sésie Pakɩ alɩɛ nɩn ɛbɛlɛ.” ");
INSERT INTO any_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Mɔ Zozi hanlɩn sɔ yuelɩ'n, yɩ́ menian nnyuan'n kɔ hɔ kɔ ju kulo nɩn asʋ. Kɛ Zozi kpɩnlɩn hanlɩn yɩ́'n, bɛ nwunlin yɩ́ kʋalaa sɔ. Bɛ kɔ tʋn Pakɩ alɩɛ'n bɛ kɔ sesie yɩ́ ɛbɛlɛ. ");
INSERT INTO any_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Mɔ alɩlie tɛmʋn'n juli'n, Zozi nʋn yɩ́ mmɔfʋɛ'n-mɔ kɔ lɩla tɔbɩlɩ nɩn anwʋn. ");
INSERT INTO any_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Yɩ́ nwan: “Mɩn kulo kɛ mɩn nʋn ɛmɔ yɛ di Pakɩ alɩɛ ɛhɩ kʋalaa nán m'an nwun mɩ́n nyunnun. ");
INSERT INTO any_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Afɩ mɩɩn kan yɩ́ ananhɔlɛ mɩn kele ɛmɔ kɛ, mɩn ngɔ li man fɩ́ɩ́ kʋ́n dede ɔ 'ju mɛlɛ mɔ bɛ 'nwun yɩ́ bʋ kpa Nyanmɩan Belemgbin Mân nɩn anun ɛlɔ'n.” ");
INSERT INTO any_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Mɔ Zozi hanlɩn sɔ yuelɩ'n, ɔ kɔ fa nzan kangɔ kʋn. Ɔ kɔ la Nyanmɩan asɩ, yɩ́ nwan: “Ɛmɔ lé ɛhɩ bɛ hyé bɛ nʋ́n. ");
INSERT INTO any_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Afɩ mɩɩn kan mɩn kele ɛmɔ kɛ, ɔ fi ɛnɛ m'ɔ kɔ'n, mɩn ngɔ nʋn man nzan fɩ́ɩ́ kʋ́n dede ɔ 'ju Nyanmɩan belemgbin elie'n tɛmʋn.” ");
INSERT INTO any_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","M'ɔ hanlɩn ɛhɩ yuelɩ'n, ɛsɛ ɔ kɔ fa kpaʋn'n. Ɔ kɔ la Nyanmɩan asɩ kɔ yue, ɔ kɔ bubu nun ɔ kɔ man bɛ́. Yɩ́ nwan: “Kpaʋn ɛhɩ tɩ mɩ́n nwʋnnaan. B'a fa b'a man ɛmɔ. Ɛmɔ yɔ́ yɩ́ sɔ bɛ kácɩ mɩ́n.” ");
INSERT INTO any_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Mɔ bɛ lili like'n yuelɩ'n, Zozi kɔ fa nzan'n kɔ man bɛ́. Yɩ́ nwan: “Nzan ɛhɩ tɩ mɩ́n moja. Moja sɔ nɩn a butu a man ɛmɔ. Ɔ di ajinlanmun kɛ Nyanmɩan nʋn ɛmɔ a li nyɩhyɛ fʋfɔlɛ. ");
INSERT INTO any_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Nan ɛmɔ nɩ́an, sʋanlan'n mɔ ɔ 'ba yɩ mɩ́n man'n, ɔ nʋn mɩ́n wɔ tɔbɩlɩ nɩn anwʋn ɛwa! ");
INSERT INTO any_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Ɔ tɩ ananhɔlɛ, *Mân Baa'n 'ba wu kɛ Nyanmɩan a kpɩn a han yɩ́'n. Nan kʋsʋ, sʋanlan'n mɔ ɔ 'ba yɩ Mân Baa'n man'n, munnzue hán yɩ́!” ");
INSERT INTO any_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Mɔ Zozi hanlɩn sɔ'n, bɛ lɛ bisa bisa bɛ́ nwʋn bɛ kpʋnndɛ sʋanlan'n mɔ ɔ 'ba li junman sɔ'n. ");
INSERT INTO any_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Ɛhɩ anzin, akpʋlʋwa kʋn kɔ tɔ mmɔfʋɛ'n-mɔ afian ɛlɔ. Bɛ́ mmɔfʋɛ bulu nʋn nnyuan nɩn anun, bɛ lɛ kpʋnndɛ sʋanlan m'ɔ tɩ kpili tala yɩ́ manngʋn'n-mɔ'n. ");
INSERT INTO any_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Zozi kɔ han kɔ hele bɛ́ kɛ: “Asɩɛ nɩn asʋ mmelemgbin'n-mɔ sie menian. Bɛ́ mɔ bɛ le tunmin'n man bɛ fɛlɛ bɛ́ ‘Defʋɛ’. ");
INSERT INTO any_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Nan ɛmɔ dɩɛ, ɔ tɩ man sɔ mman man ɛmɔ. Ɛmɔ afian, sʋanlan m'ɔ tɩ kpili'n, ɔ di kɛ ɔ bu yɩ́ nwʋn kɛ bɛ́ nunhan kaan. M'ɔ li bɛ́ ti'n kʋsʋ, ɔ di kɛ ɔ bu yɩ́ nwʋn kɛ sʋanlan m'ɔ sʋ ɛhɩnlɩn-mɔ. ");
INSERT INTO any_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Sʋanlan kʋn lɛ didi tɔbɩlɩ nɩn asʋ, kʋn lɛ yɩ alɩɛ man yɩ́. Bɛ́ munnyuan'n, benin yɛ̂ ɔ tɩ kpili ɔ? Sɛ sʋanlan'n m'ɔ tɩ tɔbɩlɩ nɩn anwʋn nɩn ɔ? Mɩ́n kʋsʋ mɩ́n, n wɔ ɛmɔ afian ɛwa kɛ sʋanlan m'ɔ lɛ sʋ ɔ! ");
INSERT INTO any_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Ɛmɔ dɩɛ, mɩ́n ɛfɛ'n-mɔ anun, ɛmɔ a bɔ mɔndɩnlɩn bɛ nʋn mɩn a tanlan nun. ");
INSERT INTO any_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Ɛhɩka ati, kɛmɔ mɩ́n Sɩ a fa Belemgbin Mân nɩn a wula mɩ́n sa nun'n, mɩ́n kʋsʋ, mɩn 'fa Belemgbin Mân'n mɩn man ɛmɔ. ");
INSERT INTO any_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Ɛmɔ 'tanlan mɩ́n tɔbɩlɩ nɩn anwʋn bɛ didi bɛ nʋnnʋn mɩ́n belemgbin mân nɩn anun. Ɛsɛ ɛmɔ 'tanlan belemgbin bia sʋ bɛ bua Izalayɛ nvilie bulu nʋn nnyuan'n ndɛɛ.” ");
INSERT INTO any_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Ɛhɩ anzin, Zozi nwan: “Simʋn, Simʋn! Nɩan wɔ́ nwʋn kpa. *Satan a sɛlɛ ɛmɔ anwʋn atɩn ɔ'a nyan yɩ́ kɛ ɔ 'sɔ ɛmɔ nɩan kɛ bɛ huhu ninnge'n-mɔ asʋ bɛ ju m'ɔ tɩ man kpa'n bɛ gua'n. ");
INSERT INTO any_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Nan m'an sɛlɛ m'an man wɔ́ nán dedi a nyue man wɔ́ nun. Mɛlɛ mɔ ɛ kɔ sa kɔ a mɩ́n nwʋn'n, wowula wɔ́ nianman'n-mɔ anwʋnsɛlɛ.” ");
INSERT INTO any_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Pɩɛlɩ kɔ han kɔ hele Zozi kɛ: “Yɛ́ Mɩn, sɛ ɔ di mɔ bɛ tʋ wɔ́ nʋn mɩ́n fiadɩ, ɛsɛ sɛ ɔ di mɔ ɛ wu a, mɩ́n nʋn wɔ́ yɛ 'wu.” ");
INSERT INTO any_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Zozi nwan: “Pɩɛlɩ, mɩɩn kan yɩ́ ananhɔlɛ mɩn kele wɔ́ kɛ ɛnɛ, ɔ nʋn dede mɔ akɔ'n 'bɔ'n, ɛ kan yɩ́ kpɛ̂ nsan kɛ ɛ nzɩ man mɩ́n” ");
INSERT INTO any_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Ɛhɩ anzin, Zozi kɔ bisa yɩ́ menian'n-mɔ kʋalaatin kɛ: “Mɛlɛ mɔ n zʋanlɩn ɛmɔ mɔ ɛmɔ a nva man esika b'a nza man bɛ́ nwʋn, b'a nva man bɔ́lɛ nʋn mgbabʋa'n, asʋ ɛmɔ mianlɩn like anwʋn ɔ?” Yɩ́ menian'n-mɔ nwan: “Cɛcɛ, y'a mmian man like anwʋn.” ");
INSERT INTO any_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Ɛhɩ a, Zozi kɔ han kɔ hele bɛ́ kɛ: “Nan kɩkaala dɩɛ, sʋanlan m'ɔ le esika'n, ɔ fá. M'ɔ le bɔ́lɛ'n, ɔ fá. M'ɔ le man dadɩɛ'n, ɔ tɔ́nɩn yɩ́ taladɩɛ kpili'n ɔ fá tó kʋn. ");
INSERT INTO any_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Afɩ, mɩɩn kan yɩ́ ananhɔlɛ mɩn kele ɛmɔ kɛ, mɩ́n nwʋn ɛjɔlɛ'n mɔ b'a hɛlɛ wɔ Ɛhɛlɛ Ɛjɔlɛ nɩn anun'n: B'a ha yɩ́ b'a wula ɛtɛfʋɛ'n-mɔ anun bie. Ɛjɔlɛ sɔ'n, ɔ fata kɛ ɔ kpɩn sʋ.” ");
INSERT INTO any_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Mɔ Zozi hanlɩn ɛhɩ'n, yɩ́ menian'n-mɔ nwan: “Yɛ́ Mɩn, ɛ 'nwun dadɩɛ nnyuan.” Zozi nwan: “Ɔ sa.” ");
INSERT INTO any_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Ɛhɩ anzin, Zozi kɔ fite kɔ hɔ Olivʋ bʋka nɩn asʋ kɛ ɔ yɔ yɩ́ titi'n. Mɔ ɔ 'kɔ'n, yɩ́ menian'n-mɔ kɔ si yɩ́ sʋ. ");
INSERT INTO any_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Mɔ Zozi juli lɩka sɔ'n, ɔ kɔ han kɔ hele bɛ́ kɛ: “Ɛmɔ yɔ́ asɔnɩn nán ɛmɔ a ndɔ man sɔnɩan nɩn anun.” ");
INSERT INTO any_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Mɔ Zozi hanlɩn sɔ ɔ helelɩ bɛ́'n, ɔ kɔ yaci bɛ́ ɛbɛlɛ ɔ kɔ hɔ yɩ́ nyunnun mʋa kaan, lɩka mɔ bɛ tʋ ɛbʋɛ a, ɔ kɔ ju'n. Ɔ kɔ kʋtʋ ɔ kɔ yɔ asɔnɩn. ");
INSERT INTO any_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Yɩ́ nwan: “Mɩ́n Sɩ, sɛ ɛ kulo a, amannɩnhunlun ɛhɩ mɔ mɩn 'ba nwun yɩ́'n, kpala gua. Kʋsʋ, yɔ mɔ wɔ́ kunnun kulo'n, nan n'ɛ yɔ mɔ mɩ́n kunnun kulo'n.”  ");
INSERT INTO any_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Nyanmɩansʋ bɔfʋɛ kʋn kɔ yɩ yɩ́ nwʋn kɔ hele yɩ́. Ɔ kɔ wowula yɩ́ anwʋnsɛlɛ. ");
INSERT INTO any_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Alʋabɔ kɔ han Zozi. Ɔ man ɔ kɔ yɔ asɔnɩn sɛlɛ kpa. Yɩ́ nwʋn efifile'n lɛ kpɩkpɩn kɛ moja. ");
INSERT INTO any_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","M'ɔ yɔlɩ asɔnɩn yuelɩ'n, ɔ kɔ sa yɩ́ nzin yɩ́ menian'n-mɔ anwʋn ɛlɔ. Ɔ 'kɔ ju a, alʋabɔ nɩn a han bɛ́ dede b'a ha nun b'a lafɩ. ");
INSERT INTO any_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Ɔ kɔ bisa bɛ́ kɛ: “Nzukɛ ati yɛ̂ ɛmɔ lɛ dafɩ ɔ? Ɛmɔ jásʋ bɛ yɔ́ asɔnɩn nán ɛmɔ a ndɔ man sɔnɩan nɩn anun!” ");
INSERT INTO any_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Anɩn Zozi anʋan tɛ wɔ sʋ, menian-mɔ kɔ fite fite ɛbɛlɛ. Mɔ bɛ 'ba'n, Zozi menian'n-mɔ anun kʋn'n mɔ bɛ fɛlɛ yɩ́ Zudasɩ Isikaliɔtɩ'n y'ɔ li bɛ́ ti ɔ. Zudasɩ kɔ hyʋɩn kɔ kpunnge Zozi ɔ kɔ tɔ yɩ́ nun. ");
INSERT INTO any_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","M'ɔ yɔlɩ sɔ'n, nán Zozi a se yɩ́ kɛ: “Yɩ́ ti, Zudasɩ, ɛ 'tɔ *Mân Baa nɩn anun nán ɛ yɩ yɩ́ man ɔ?” ");
INSERT INTO any_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Mɔ Zozi menian'n-mɔ nwunlin ɛjɔlɛ m'ɔ lɛ ba yɩ́ nzin'n, bɛ kɔ bisa Zozi kɛ: “Yɛ́ Mɩn, yɛ mán yɛ́ dadɩɛ'n-mɔ bíli ɔ?” ");
INSERT INTO any_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Bɛ 'kan sɔ ala, bɛ́ nunhan kʋn kɔ yɩ yɩ́ dadɩɛ'n, ɔ kɔ kpɛ tɛɛyɩfʋɛ kpain nɩn akʋa nɩn anzʋ fama'n. ");
INSERT INTO any_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Zozi kɔ han kɔ hele yɩ́ menian'n-mɔ kɛ: “Ɛmɔ jínlan, ɔ tɩ kpa sɔ.” Ɔ kɔ han bian sɔ nɩn anzʋ'n, ɔ kɔ man yɩ́ nwʋn kɔ sa. ");
INSERT INTO any_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Mɔ Zozi yɔlɩ sɔ'n, ɔ kɔ kaci yɩ́ nyɩn tɛɛyɩfʋɛ mgbain'n-mɔ, nʋn Nyanmɩan awulo nɩn asʋ nzalafʋ mgbain'n-mɔ nʋn Izalayɛ mgbain'n-mɔ anwʋn ɛlɔ. Yɩ́ nwan: “Ɛmɔ bu mɩ́n kɛ n dɩ kodiawu. Yɩ́ ti yɛ̂ ɛmɔ 'ba a, ɛmɔ lile dadɩɛ nʋn koloman-mɔ bɛ́ sa nun ɔ? ");
INSERT INTO any_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Cɩan daa mɩn nʋn ɛmɔ yɛ gua Nyanmɩan awulo nɩn anun, kʋsʋ ɛmɔ a njɩ man mɩ́n. Nan dɔhyʋɩlɩ ɛhɩka tɩ ɛmɔ dɔɛ, ɔ tɩ awosin tunmin dɔɛ.” ");
INSERT INTO any_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Menian'n-mɔ kɔ hyɩ Zozi, bɛ nʋn yɩ́ kɔ hɔ tɛɛyɩfʋɛ kpain nɩn awulo. Pɩɛlɩ si Zozi sʋ ɔ di yɩ́ fannvanndʋ. ");
INSERT INTO any_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Anɩn b'a huan sɩ̂n awulo nɩn afian. Pɩɛlɩ kɔ wʋlʋ ɔ kɔ tanlan bɛ́ mɔ bɛ gua sɩ̂n nɩn anwʋn nɩn afian. ");
INSERT INTO any_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Afanɩan kʋn kɔ nwun Pɩɛlɩ sɩ̂n nɩn anwʋn ɛbɛlɛ. Ɔ kɔ nɩan Pɩɛlɩ koun, yɩ́ nwan: “Sʋanlan ɛhɩ kʋsʋ si Zozi sʋ bie!” ");
INSERT INTO any_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Mɔ Pɩɛlɩ tɩlɩ ɛjɔlɛ sɔ'n, ɔ kɔ su akpʋlʋwa. Yɩ́ nwan: “Zozi sɔ'n, mɩn nzɩ man yɩ́.” ");
INSERT INTO any_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Ɔ hyɛlɩ kaan, sʋanlan kʋn biekun kɔ nwun yɩ́, yɩ́ nwan: “Wɔ́ kʋsʋ wɔ́, ɔ tɩ yɩ́ sʋanlan'n kʋn!” Mɔ Pɩɛlɩ tɩlɩ ɛjɔlɛ sɔ'n, yɩ́ nwan: “Cɛcɛ, nán yɩ́ sʋanlan'n kʋn y'ɔ le mɩ́n.” ");
INSERT INTO any_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Kɔ yɔ dɔhyʋɩlɩ kʋn kɔ sɩn. Sʋanlan kʋn biekun kɔ han kɔ tʋ sʋ kɛ: “Ɔ tɩ fɔ́ʋ́n, sʋanlan ɛhɩ tɩ Zozi sʋanlan. Ɔ sanlɩn kɛ ɔ tɩ Galile mân nɩn anun ɛlɔ sʋanlan.” ");
INSERT INTO any_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","M'ɔ hanlɩn sɔ'n, Pɩɛlɩ nwan: “Ɛjɔlɛ'n mɔ ɛ lɛ kan'n, mɩn ndɩ man yɩ́ bʋ.” Anɩn Pɩɛlɩ anʋan tɛ wɔ sʋ, kokolokoo! Akɔ kʋn kɔ bɔ. ");
INSERT INTO any_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Yɛ́ Mɩn kɔ bɩlɩ yɩ́ nyɩn ɔ kɔ nɩan Pɩɛlɩ. Mɔ Pɩɛlɩ anyɩn tɔlɩ yɛ́ Mɩn anyunnun'n, yɩ́ ti kɔ kacɩ ɛjɔlɛ'n mɔ yɛ́ Mɩn hanlɩn helelɩ yɩ́'n. Yɛ́ Mɩn nwan: “Ɛnɛ, asannan nán akɔ nɩn a bɔ'n, ɛ 'kan yɩ́ kpɛ̂ nsan kɛ ɛ nzɩ man mɩ́n.” ");
INSERT INTO any_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Pɩɛlɩ kɔ fite ɔ kɔ sun sɛlɛ kpa. ");
INSERT INTO any_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Bɛ́ mɔ anɩn bɛ nɩan Zozi asʋ'n lɛ gʋlʋ yɩ́ nwʋn. ");
INSERT INTO any_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Bɛ butu yɩ́ ti bɛ tʋtʋ yɩ́ kɔtɔlɛ anɩn bɛ lɛ bisa yɩ́ kɛ: “Nwan yɛ̂ ɔ'a tʋ wɔ́ kɔtɔlɛ'n? Kele!” ");
INSERT INTO any_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Ɛhɩ mɔ bɛ lɛ yɔ'n, anɩn ɛsɛ bɛ lɛ kan ɛjɔlɛ ɛtɛ dɔʋn bɛ tia yɩ́. ");
INSERT INTO any_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Mɔ alɩ́ɛ hɩnlɩn'n, Zufʋ mgbain'n-mɔ, nʋn tɛɛyɩfʋɛ'n-mɔ nʋn mala nɩn asʋ mgbain'n-mɔ kɔ yia. Bɛ kɔ man bɛ kɔ fa Zozi bɛ kɔ a bɛ́ ja sʋ. ");
INSERT INTO any_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Bɛ kɔ bisa bisa yɩ́ kɛ: “Kan kele yɛ́ maan yɛ tɩ́. Asʋ *Kilisi'n, Izalayɛ Belemgbin Ngʋandefʋɛ'n y'ɔ le wɔ́ ɔ?” Zozi kɔ bua bɛ́ kɛ: “Sɛ mɩn kan mɩn kele ɛmɔ a, ɛmɔ ngɔ le ngɔ li man. ");
INSERT INTO any_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Sɛ kʋsʋ mɩn bisa ɛmɔ kosuan kʋn an, ɛmɔ ngɔ bua man mɩ́n bie. ");
INSERT INTO any_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Nan kɩkaala dɩɛ, Mân Baa'n 'ba tanlan tunminfʋɛ Nyanmɩan'n fama sʋ.” ");
INSERT INTO any_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Mɔ Zozi hanlɩn sɔ'n, bɛ́ kʋalaa bɛ́ nwan: “Yɩ́ ti, Nyanmɩan Awa y'ɔ le wɔ́?” Zozi kɔ bua bɛ́ kɛ: “Ɛmɔ lɛ kan. N dɩ yɩ́ Wa.” ");
INSERT INTO any_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Ɛhɩ a, bɛ́ nwan: “Yɛ mgbʋnndɛ man adanzɩɛ kʋ́n! Yɛ́ bɔbɔ muonun y'a tɩ yɩ́ nʋan nun ɛjɔlɛ.” ");
INSERT INTO any_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Ɛhɩ, mgbain'n-mɔ kʋalaa kɔ jasʋ, bɛ nʋn Zozi kɔ hɔ *Pilatɩ aja sʋ. ");
INSERT INTO any_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Pilatɩ anyunnun ɛbɛlɛ, bɛ kɔ bɔ yɩ́ bʋ bɛ kɔ tʋn yɩ́ ɛsʋan kɛ: “Sʋanlan ɛhɩ lɛ kele yɛ́ mân nɩn anun menian'n-mɔ atɩn ɛtɛ. Ɔ kan kele bɛ́ kɛ nán man bɛ tua ajule'n bɛ man belemgbin Sezaa. Ɛsɛ yɩ́ nwan yɩ́ muonun ɔ tɩ *Kilisi, Belemgbin Ngʋandefʋɛ.” ");
INSERT INTO any_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Mɔ bɛ hanlɩn sɔ'n, Pilatɩ kɔ bisa Zozi kɛ: “Asʋ Zufʋ'n-mɔ belemgbin'n y'ɔ le wɔ́ ɔ?” Zozi kɔ bua yɩ́ kɛ: “Yɛ̂ wɔ́ nʋan wɔ sʋ m'ɔ lɛ kan nɩn ɔ.” ");
INSERT INTO any_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Mɔ Zozi bualɩ ɛhɩ'n, Pilatɩ kɔ kaci yɩ́ nyɩn tɛɛyɩfʋɛ mgbain'n-mɔ nʋn meninsʋnman nɩn anwʋn ɛlɔ. Yɩ́ nwan: “Mɩn nnwun man like ɛtɛ mɔ sʋanlan ɛhɩ a yɔ ɔ.” ");
INSERT INTO any_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Nan mɔ Pilatɩ hanlɩn sɔ'n, bɛ kɔ han bɛ kɔ fua sʋ kɛ: “Ɔ kele yɛ́ mân nɩn anun menian'n-mɔ atɩn ɛtɛ maan bɛ jasʋ awaa akɔmɩn anun. Ɔ'a bɔ yɩ́ bʋ Galile mân nɩn anun ɛlɔ, ɔ'a sɩn Zude mân'n lɩka kʋalaatin dede ɔ'a ju Zoluzalɛmʋn ɛwa.” ");
INSERT INTO any_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Mɔ Pilatɩ tɩlɩ ɛjɔlɛ sɔ'n, ɔ kɔ bisa bɛ́ kosuan kɛ: “Yɩ́ ti, sʋanlan ɛhɩ fi Galile mân nun?” ");
INSERT INTO any_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","M'ɔ tɩlɩ kɛ Zozi fi belemgbin Elɔdɩ mân nɩn anun'n, ɔ man bɛ nʋn Zozi kɔ hɔ Elɔdɩ aja sʋ ɛlɔ. Ɔ sanlɩn kɛ, tɛmʋn sɔ'n, anɩn belemgbin Elɔdɩ kʋsʋ fi Galile ɔ a Zoluzalɛmʋn ɛbɛlɛ. ");
INSERT INTO any_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Mɔ Elɔdɩ nwunlin Zozi'n, ɔ lili yɩ́ nwʋn fɛ. Ɔ sanlɩn kɛ bɛ kan Zozi ɛjɔlɛ'n m'ɔ tɩtɩ'n, nán ɛnɛ bie ɔ. Kʋsʋ ɔ nyanlɩn man atɩn bɛ́ nnyuan bɛ́ nyɩn yialɩ man lé. Elɔdɩ jʋnlɩn kɛ anɩn Zozi 'ba yɔ asinbɛnwʋn like kʋn kele yɩ́. ");
INSERT INTO any_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Ɔ kɔ bisa bisa Zozi kosuan dɔʋn kpa. Nan kʋsʋ Zozi ngɔ bua man ɛjɔlɛ fɩ́ɩ́. ");
INSERT INTO any_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Anɩn tɛɛyɩfʋɛ mgbain'n-mɔ nʋn mala nɩn asʋ mgbain'n-mɔ wɔ ɛbɛlɛ. Ɛsʋan mɔ bɛ tʋnlɩn Zozi'n, ɔ tɩ man nzɛmɩndɛ. ");
INSERT INTO any_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Elɔdɩ nʋn yɩ́ nzalafʋ'n-mɔ kɔ bu Zozi sʋanlan mgban mgban, bɛ kɔ gʋlʋ yɩ́ nwʋn. Elɔdɩ kɔ man bɛ kɔ fa taladɩɛ kanlanman kʋn bɛ kɔ wula Zozi. Ɔ kɔ man bɛ nʋn Zozi kɔ sa kɔ hɔ Pilatɩ anwʋn ɛlɔ. ");
INSERT INTO any_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Cɩan sɔ kʋnmgba'n, Elɔdɩ nʋn Pilatɩ bɛ kacili amanngʋan. Daba, anɩn bɛ́ munnyuan bɛ nni man. ");
INSERT INTO any_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Ɛhɩ, Pilatɩ kɔ yia *tɛɛyɩfʋɛ mgbain'n-mɔ, Izalayɛ mân nɩn asʋ mgbain'n-mɔ nʋn bagua'n. ");
INSERT INTO any_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Ɔ kɔ fa kɔ tʋ bɛ́ nyunnun kɛ: “Ɛmɔ a fa sʋanlan ɛhɩ a bɛlɛ mɩ́n kɛ ɔ kele menian'n-mɔ atɩn ɛtɛ. Ɛmɔ anyunnun ɛwa, m'an bisa yɩ́ kosuan. Mɩn nnwun man ɛtɛ fɩ́ɩ́ mɔ ɔ'a yɔ, mɔ yɩ́ ti yɛ̂ ɛmɔ a tʋn yɩ́ ɛsʋan'n. ");
INSERT INTO any_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Elɔdɩ kʋsʋ a nnwun man ɛtɛ mɔ ɔ'a yɔ ɔ. Ɔ sanlɩn kɛ, ɔ a man bɛ nʋn yɩ́ a sa a a yɛ́ nwʋn ɛwa. Mɔ yɛ nwun yɩ́ nun'n y'ɔ le kɛ sʋanlan ɛhɩ yɔlɩ man ɛtɛ fɩ́ɩ́ m'ɔ di kɛ bɛ kun yɩ́ ɔ. ");
INSERT INTO any_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Yɩ́ ti, mɩn 'ba man bɛ fin yɩ́ mgbele nán mɩn yaci yɩ́ nun.”  ");
INSERT INTO any_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Bɛ 'di *Pakɩ fɛtɩ biala, ɔ di kɛ Pilatɩ man bɛ yɩ bɛ́ mɔ b'a gua bɛ́ fiadɩ nɩn anun kʋn. ");
INSERT INTO any_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Nan mɔ Pilatɩ hanlɩn kɛ ɔ 'man bɛ fin Zozi mgbele nán ɔ yaci yɩ́ nun'n, bɛ́ kʋalaa bɛ́ nʋan kɔ yɔ kʋn, bɛ lɛ tɛtɩan bɛ kan kɛ: “Man bɛ hún sʋanlan ɛhɩ! Yaci Balabasɩ nun man yɛ́!” ");
INSERT INTO any_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","(Bɛ tʋlɩ Balabasɩ fiadɩ, ɔ sanlɩn kɛ ɔ kɔ man kulo nɩn asʋ menian'n-mɔ kɔ jasʋ awaa akɔmɩn anun, ɛsɛ ɔ kɔ hun sʋanlan.) ");
INSERT INTO any_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Kɛmɔ afɩ Pilatɩ kulo kɛ ɔ yaci Zozi nun'n, ɔ kɔ bisa bɛ́ kosuan biekun. ");
INSERT INTO any_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Anɩn menian'n-mɔ tɛ tɛtɩan. Bɛ́ nwan: “Bʋbɔ yɩ́ kʋlʋwa sʋ! Bʋbɔ yɩ́ kʋlʋwa sʋ!” ");
INSERT INTO any_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Ɛsɛ Pilatɩ kɔ bisa bɛ́ kosuan biekun. Yɩ́ kpɛ̂ nsan nɩn asʋ, yɩ́ nwan: “Nyɔlɩɛ ɛtɛ benin yɛ̂ ɔ'a yɔ ɔ? Mɩn nnwun man ɛtɛ mɔ ɔ'a yɔ, m'ɔ di kɛ bɛ kun yɩ́ ɔ. Ɛhɩka ati, mɩn 'ba man bɛ fin yɩ́ mgbele nán mɩn yaci yɩ́ nun.” ");
INSERT INTO any_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Bɛ ngɔ li man ɛjɔlɛ'n mɔ Pilatɩ lɛ kan kele bɛ́ nɩn anwʋn bie. Anɩn bɛ lɛ tɛtɩan sɛlɛ kpa bɛ kan bɛ kele Pilatɩ kɛ ɔ mán bɛ bʋ́bɔ Zozi kʋlʋwa sʋ. Bɛ le ɛtɛtɩan dede Pilatɩ kɔ kpati kɔ sɩn bɛ́ atɩn dɩɛ nɩn asʋ. ");
INSERT INTO any_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Ɔ kɔ le bɛ́ ɛjɔlɛ'n kɔ tʋ nun. ");
INSERT INTO any_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Ɔ kɔ yaci Balabasɩ nun. Ɔ sanlɩn kɛ Balabasɩ sɔ'n m'ɔ manlɩn menian'n-mɔ jasʋlɩ awaa akɔmɩn anun ɛsɛ ɔ hunlin sʋanlan mɔ bɛ tʋlɩ yɩ́ fiadɩ'n, yɩ́ yɛ̂ menian'n-mɔ bisalɩ Pilatɩ kɛ ɔ yáci yɩ́ nun ɔ. Mɔ Pilatɩ yɩlɩ Balabasɩ'n, ɔ falɩ Zozi wulalɩ bɛ́ sa nun kɛ bɛ yɔ́ yɩ́ kɛ bɛ kulo ɔ. ");
INSERT INTO any_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Mɛlɛ mɔ bɛ nʋn Zozi 'kɔ'n, bɛ nʋn bian kʋn kɔ yia, ɔ fi yɩ́ ebolo. Bɛ fɛlɛ bian sɔ'n Simʋn. Ɔ fi kulo'n mɔ bɛ fɛlɛ yɩ́ Silɛnɩn nɩn asʋ. Nzalafʋ'n-mɔ kɔ hyɩ yɩ́, bɛ kɔ fa Zozi kʋlʋwa'n bɛ kɔ sʋa yɩ́ kɛ ɔ fá ɔ sí Zozi sʋ. ");
INSERT INTO any_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Anɩn bagua nɩn anun menian dɔʋn kpa si Zozi sʋ, bɛ nʋn mmalasua-mɔ. Anɩn mmalasua sɔ'n-mɔ lɛ sun Zozi bɛ yɩ awɔ́lɛ. ");
INSERT INTO any_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Zozi kɔ kpɛ yɩ́ nyɩn bɛ́ nwʋn ɛlɔ, yɩ́ nwan: “Zoluzalɛmʋn mmalasua, nán bɛ sun mɩ́n! Ɛmɔ sún bɛ́ nwʋn nʋn bɛ́ mma'n-mɔ! ");
INSERT INTO any_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Ɔ sanlɩn kɛ mɛlɛ'n lɛ ba mɔ menian'n-mɔ 'ba han kɛ: ‘Nyila hán mmalasua mɔ bɛ tɩ mʋta, bɛ́ mɔ bɛ wʋlɩ man baa lé, ɔ nʋn bɛ́ mɔ bɛ nnʋanlɩn man baa lé'n!’ ");
INSERT INTO any_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Mɛlɛ sɔ'n, menian'n-mɔ 'ba han kele mmʋka'n-mɔ kɛ: ‘Mmʋka, ɛmɔ túlu bɛ gúa yɛ́ sʋ!’ Ɛsɛ bɛ 'kan bɛ kele kʋnngʋnlʋnman'n-mɔ kɛ: ‘Ɛmɔ fá yɛ́ fɩ́a!’ ");
INSERT INTO any_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Mɩ́n mɔ n dɩ kɛ baka ɛmanlan'n, sɛ bɛ lɛ yɔ mɩ́n sʋa a, anɩn ɛmɔ mɔ bɛ tɩ kɛ baka yʋlʋwa'n, yɩ́ dɩɛ bɛ ngan man ɛmɔ ɛjɔlɛ kʋ́n!” ");
INSERT INTO any_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Mɛlɛ mɔ bɛ nʋn Zozi 'kɔ'n, anɩn kodiawu nnyuan kʋsʋ wɔ nun. Bɛ lɛ kɔ a hun bɛ́. ");
INSERT INTO any_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Bɛ hɔlɩ dede mɔ bɛ juli lɩka'n mɔ bɛ fɛlɛ yɩ́ “Tile kangɔ'n”, bɛ kɔ bʋbɔ Zozi kʋlʋwa nɩn asʋ ɛbɛlɛ. Ɛsɛ bɛ kɔ bʋbɔ kodiawu nnyuan'n kʋsʋ kʋlʋwa sʋ. Nunhan kʋn wɔ Zozi fama sʋ, nunhan kʋn kʋsʋ wɔ yɩ́ bɛ̂ sʋ. ");
INSERT INTO any_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Mɔ bɛ bʋbɔlɩ Zozi kʋlʋwa nɩn asʋ'n, yɩ́ nwan: “Mɩ́n Sɩ, yaci bɛ́ nwʋn sa ce bɛ́. Ɔ sanlɩn kɛ bɛ nzɩ man mɔ bɛ lɛ yɔ ɔ.” Nzalafʋ'n-mɔ kɔ hyʋɩn tondo bɛ kɔ hye yɩ́ nwʋn taladɩɛ'n-mɔ. ");
INSERT INTO any_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Bagua'n jin ɛbɛlɛ ɔ lɛ nɩan. Zufʋ mgbain'n-mɔ lɛ kan bɛ gʋlʋ Zozi anwʋn kɛ: “Ɔ a le ɛhɩnlɩn-mɔ ati, yɩ́ mɔ yɩ́ nwan ɔ tɩ Kilisi'n, Belemgbin Ngʋandefʋɛ'n, mɔ Nyanmɩan a yɩ yɩ́'n, ɔ lé yɩ́ muonun yɩ́ nwʋn e!” ");
INSERT INTO any_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Nzalafʋ'n-mɔ kʋsʋ kɔ gʋlʋ yɩ́ nwʋn. Bɛ kɔ hyʋɩn yɩ́ nwʋn ɛlɔ, bɛ kɔ man yɩ́ nzannvin. ");
INSERT INTO any_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Bɛ́ nwan: “Sɛ Zufʋ'n-mɔ belemgbin'n y'ɔ le wɔ́ a, de wɔ́ muonun wɔ́ nwʋn e!” ");
INSERT INTO any_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Bɛ kɔ hɛlɛ ɛjɔlɛ bɛ kɔ bɔ yɩ́ ti sʋ ɛbɛlɛ kɛ: “Sʋanlan ɛhɩ tɩ Zufʋ'n-mɔ belemgbin.” ");
INSERT INTO any_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Kodiawu nnyuan'n mɔ b'a bʋbɔ bɛ́ kʋlʋwa nɩn asʋ'n, bɛ́ nunhan kʋn kɔ kpɛ yɩ́ nzʋba kɛ: “Nán Kilisi'n, Belemgbin Defʋɛ'n y'ɔ le wɔ́ ɔ? De wɔ́ ti nán de yɛ́ kʋsʋ yɛ́ ti e!” ");
INSERT INTO any_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Kodiawu kʋn'n kɔ totua yɩ́ manngʋn'n, yɩ́ nwan: “Ɛ nzulo man Nyanmɩan! ");
INSERT INTO any_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Yɛ́ epinnian dɩɛ'n mɔ bɛ lɛ pinnin yɛ́'n, yɩ́ nyɩn ɔ. Ɔ sanlɩn kɛ yɛ́ nyɔlɩɛ'n-mɔ anwʋn yɛ̂ bɛ lɛ nɩan bɛ pinnin yɛ́ ɔ. Nan yɩ́ mɔ bɛ lɛ pinnin yɩ́ kɛ yɛ́'n, ɔ'a nyɔ man like ɛtɛ.” ");
INSERT INTO any_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","M'ɔ hanlɩn sɔ yuelɩ'n, ɔ kacili yɩ́ nyɩn Zozi anwʋn ɛlɔ a, yɩ́ nwan: “Zozi, man wɔ́ ti kácɩ mɩ́n mɛlɛ mɔ ɛ 'di belemgbin'n.” ");
INSERT INTO any_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Zozi nwan: “Mɩɩn kan yɩ́ ananhɔlɛ mɩn kele wɔ́ kɛ, ɛnɛ, ɛ nʋn mɩ́n yɛ 'tanlan Nyanmɩan anwʋn ɛlɔ.” ");
INSERT INTO any_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Anɩn b'a bɔ kɔ yɔ sɛnzɛjinlan, mân nɩn anun lɩka kʋalaatin kɔ lu dede eyua dɔɛ nsan. ");
INSERT INTO any_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Sɛnzɛ'n kɔ fɩa bɔkɔɔ. Mgbenun ɛtanlan'n m'ɔ wɔ Nyanmɩan Sua Nwannzan-nwannzan nɩn anun'n kɔ sua sɛsɛ nnyuan. ");
INSERT INTO any_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Zozi kɔ tɩan nun sɛlɛ kpa, yɩ́ nwan: “Baba, mɩɩn fa mɩ́n ɛkala'n mɩn wula wɔ́ sa nun.” M'ɔ hanlɩn sɔ nɩn ala y'ɔ wuli ɔ. ");
INSERT INTO any_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Mɔ *Lɔmʋn nzalafʋ kpain'n nwʋnlin yɩ́ sɔ'n, ɔ kɔ yɩ Nyanmɩan ayɛ kɛ: “Ɔ tɩ ananhɔlɛ, sʋanlan ɛhɩ tɩ sɛsɛfʋɛ.” ");
INSERT INTO any_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Bɛ́ kʋalaa mɔ bɛ tuli woo bɛ walɩ nɩanlɩn Zozi ehuan'n, bɛ nwunlin ɛjɔlɛ m'ɔ walɩ ɔ. Sɩan'n mɔ bɛ 'sa bɛ kɔ'n, anɩn afɩ alʋabɔ a han bɛ́. ");
INSERT INTO any_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Zozi amanngʋn'n-mɔ, bɛ́ nʋn mmalasua'n-mɔ mɔ bɛ si yɩ́ sʋ sunmin Galile mân nɩn anun'n, bɛ jin mʋa yɛ̂ bɛ lɛ nɩan ɔ. ");
INSERT INTO any_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Anɩn Zufʋ'n-mɔ kpain kʋn wɔ ɛbɛlɛ. Bɛ fɛlɛ yɩ́ Zozɛfʋ. Ɔ fi Zufʋ kulo'n mɔ bɛ fɛlɛ yɩ́ Alimate nɩn asʋ. Ɔ tɩ sʋanlan mɔ yɩ́ ti anun tɩ kpa ɛsɛ ɔ tɩ sɛsɛ. ");
INSERT INTO any_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Bɛ hɔlɩ yialɩ mɔ Zufʋ mgbain'n-mɔ 'fa Zozi anwʋn ajʋnlɩn ɛtɛ'n, Zozɛfʋ sɔ nɩn a mgbɩnlɩn man. Ɔ sanlɩn kɛ yɩ́ dɩɛ, ɔ lɛ nwʋnndɛ Nyanmɩan Belemgbin Mân'n. ");
INSERT INTO any_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Ɔ kɔ hɔ kɔ tʋ Pilatɩ ɔ kɔ sɛlɛ Zozi fuin'n. ");
INSERT INTO any_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Mɔ Pilatɩ manlɩn atɩn'n, Zozɛfʋ kɔ yɩ Zozi fuin'n fi kʋlʋwa nɩn asʋ. Ɔ kɔ fa kisaan kɔ fʋfɔ yɩ́ nwʋn ɔ kɔ hɔ kɔ sie yɩ́ sɛka kʋn anun. Sɛka sɔ'n, b'a koto yɩ́ ɛbʋta nun, ɛsɛ anɩn bɛ sielɩ man sʋanlan nun lé. ");
INSERT INTO any_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Cɩan sɔ'n tɩ yâ. Yɩ́ nɔsʋba, anɩn ɛnwʋnmɩan ele cɩan'n lɛ bɔ yɩ́ bʋ. ");
INSERT INTO any_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Mmalasua'n-mɔ mɔ anɩn bɛ si Zozi sʋ sunmin Galile mân nɩn anun'n, bɛ nʋn Zozɛfʋ y'ɔ hɔlɩ sɛka nɩn asʋ ɔ. Bɛ nɩanlɩn sɛka'n ɔ nʋn kɛ bɛ kpɩnlɩn bɛ sielɩ Zozi'n. ");
INSERT INTO any_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","M'ɔ yɔlɩ sɔ yuelɩ'n, bɛ kɔ sa bɛ kɔ hɔ awulo. Bɛ kɔ kpʋnndɛ kpʋnndɛ alufanlan nʋn anatɩlɩ-mɔ mɔ bɛ 'fa bɛ sesie Zozi fuin'n. Bɛ kɔ le bɛ́ ɛnwʋnmɩan *ɛnwʋnmɩan ele cɩan'n kɛ mala'n kele'n. ");
INSERT INTO any_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Mɔlɛ nɩn alɩbahɩan, mmalasua'n-mɔ kɔ fa alufanlan'n nʋn anatɩlɩ'n-mɔ mɔ bɛ kpʋnndɛlɩ bɛ sielɩ'n bɛ kɔ hɔ Zozi sɛka nɩn asʋ. ");
INSERT INTO any_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Ɛbʋɛ'n mɔ bɛ falɩ bɛ nyinlin sɛka nɩn anʋan'n, bɛ 'kɔ a ju a, b'a kunndo ɛbʋɛ sɔ'n b'a sie ahanmɩan. ");
INSERT INTO any_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Bɛ kɔ wʋlʋ sɛka nɩn anun, kʋsʋ bɛ ngɔ nwun man yɛ́ Mɩn Zozi fuin'n. ");
INSERT INTO any_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Ɛjɔlɛ'n kɔ sin bɛ́ nwʋn. Ɛbɛlɛ ala, menian nnyuan kɔ yɩ bɛ́ nwʋn kɔ hele bɛ́. Menian nnyuan sɔ'n-mɔ wowula taladɩɛ nvufue nyɩhyɩɛɩn. ");
INSERT INTO any_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Esulo kɔ han mmalasua'n-mɔ, bɛ kɔ sisi bɛ́ ti asɩ. Menian nnyuan'n kɔ bisa bɛ́ kɛ: “Sʋanlan'n mɔ yɩ́ nyɩn wɔ sʋ'n, ɔ yɔ sɛ mɔ ewue mma'n-mɔ afian yɛ̂ ɛmɔ lɛ kpʋnndɛ yɩ́'n? ");
INSERT INTO any_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Ɔ nnʋn man ɛwa, nan ɔ fi ewue nun ɔ'a tinnge. Mɛlɛ mɔ anɩn ɔ tɛ wɔ Galile mân nɩn anun'n, ɛmɔ ati kácɩ ɛjɔlɛ'n m'ɔ hanlɩn helelɩ ɛmɔ'n. ");
INSERT INTO any_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Ɔ hanlɩn helelɩ ɛmɔ kɛ: ‘Ɔ fata kɛ bɛ yɩ Mân Baa'n bɛ man menian ɛtɛfʋɛ'n-mɔ. Bɛ 'bʋbɔ yɩ́ kʋlʋwa sʋ bɛ kun yɩ́. Nan yɩ́ cɩan nsan nɩn asʋ, ɔ fi ewue nun ɔ 'tinnge.’” ");
INSERT INTO any_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Mɔ menian nnyuan'n hanlɩn sɔ'n, mmalasua'n-mɔ ati kacɩlɩ ɛjɔlɛ sɔ'n-mɔ mɔ Zozi hanlɩn'n. ");
INSERT INTO any_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Bɛ fi sɛka nɩn asʋ, bɛ kɔ hɔ kɔ bɔ ɛjɔlɛ sɔ'n kʋalaa bɛ kɔ hele Zozi menian bulu nʋn kʋn'n ɔ nʋn ɛhɩnlɩn-mɔ kʋalaatin. ");
INSERT INTO any_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Mmalasua'n-mɔ mɔ bɛ hanlɩn ɛjɔlɛ sɔ'n bɛ helelɩ mmɔfʋɛ'n-mɔ'n y'ɔ le Mali m'ɔ fi Magɩdala'n, Zʋanɩn, Zʋakɩ anin Mali, ɔ nʋn mmalasua ɛhɩnlɩn-mɔ mɔ bɛ nʋn bɛ hɔlɩ sɛka nɩn asʋ'n. ");
INSERT INTO any_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Mmɔfʋɛ'n-mɔ buli ɛjɔlɛ'n mɔ mmalasua'n-mɔ hanlɩn helelɩ bɛ́'n kɛ ɛlalɩɛ. Ɛhɩka ati, mmɔfʋɛ'n-mɔ a nne man ɛjɔlɛ sɔ'n b'a nni man. ");
INSERT INTO any_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Nan kʋsʋ, Pɩɛlɩ jasʋlɩ, ɔ nwanndili ɔ hɔlɩ sɛka nɩn asʋ. M'ɔ juli ɛlɔ'n, ɔ hanlɩn yɩ́ nwʋn asɩ ɔ nɩanlɩn sɛka nɩn anun. Kisaan'n mɔ bɛ falɩ fʋfɔlɩ Zozi anwʋn nɩn ala yɛ̂ ɔ nwunlin yɩ́ sɛka nɩn anun ɔ. M'ɔ nwunlin yɩ́ sɔ'n, ɛjɔlɛ'n sinlin yɩ́ nwʋn, ɔ salɩ hɔlɩ yɩ́ awulo. ");
INSERT INTO any_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Mɔlɛ cɩan sɔ'n kʋnmgba, anɩn Zozi menian'n-mɔ anun nnyuan lɛ kɔ kulo'n mɔ bɛ fɛlɛ yɩ́ Emayusɩ nɩn asʋ. Zoluzalɛmʋn nʋn Emayusɩ, cilo bulu ɔ nʋn kʋn y'ɔ wɔ bɛ́ afian ɔ. ");
INSERT INTO any_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Anɩn Zozi menian nnyuan sɔ'n lɛ kan ɛjɔlɛ'n kʋalaa m'ɔ tɔlɩ Zoluzalɛmʋn nɩn anwʋn ɛjɔlɛ. ");
INSERT INTO any_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Mɛlɛ mɔ anɩn bɛ lɛ kan ɛjɔlɛ sɔ'n-mɔ bɛ su yɩ́ bʋsʋ akpʋlʋwa'n, Zozi muonun kɔ kpʋ bɛ́ ɔ nʋn bɛ́ bɛ kɔ san nun. ");
INSERT INTO any_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Nan kʋsʋ b'a nnwun man Zozi nzɔlɛ. Ɔ sanlɩn kɛ ɔ tɩ kɛ like bie a hala bɛ́ nyɩn. ");
INSERT INTO any_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Zozi kɔ bisa bɛ́ kɛ: “Nzu like dɩɛ anwʋn akpʋlʋwa yɛ̂ ɛmɔ lɛ tia kɔ a, anɩn ɛmɔ lɛ su'n?” Mɔ Zozi bisalɩ bɛ́ kosuan sɔ'n, bɛ kɔ jejinlan, bɛ́ nyunnun kunngoun. ");
INSERT INTO any_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Bɛ́ nunhan kʋn, bɛ fɛlɛ yɩ́ Keleyopasɩ, ɔ kɔ bua Zozi kɛ: “Bode'n mɔ ɔ'a si ɛlɛnyuan ɛhɩ'n, yɩ́ ti, wɔ́ ngʋnmɩn cein ala yɛ̂ ɛ wɔ Zoluzalɛmʋn ɛbɛlɛ mɔ ɛ tɩlɩ man ɛjɔlɛ sɔ nɩn ɔ?” ");
INSERT INTO any_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Zozi kɔ bisa bɛ́ kɛ: “Anɩn nzu ɛjɔlɛ dɩɛ ɔ?” Bɛ kɔ bua yɩ́ kɛ: “Ɛjɔlɛ a tʋ Zozi m'ɔ fi Nazalɛtɩ'n. Anɩn Zozi tɩ kpɔmanfʋɛ m'ɔ le tunmin. Yɩ́ nyɔlɩɛ'n-mɔ nʋn yɩ́ nʋan ɛjɔlɛ nɩn anun, ɔ'a hele wɔ Nyanmɩan nʋn menian'n-mɔ anyunnun kɛ ɔ le tunmin. ");
INSERT INTO any_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Yɛ́ tɛɛyɩfʋɛ mgbain'n-mɔ nʋn yɛ́ mân nɩn asʋ mgbain'n-mɔ, b'a yɩ yɩ́ a man maan b'a bʋbɔ yɩ́ kʋlʋwa sʋ b'a hun yɩ́. ");
INSERT INTO any_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Yɛ́ afan, yɛ lelɩ yɛ lili kɛ, yɩ́ dein yɛ̂ Nyanmɩan a sʋan yɩ́ kɛ ɔ bála a a le Izalayɛ mân nɩn ati ɔ. Nan kʋsʋ, kɛ bode sɔ'n sili'n, ɛnɛ tɩ yɩ́ cɩan nsan. ");
INSERT INTO any_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Ɔ tɩ ananhɔlɛ kɛ yɛ́ fâ nɩn anun mmalasua mmie-mɔ a han asinbɛnwʋn ɛjɔlɛ b'a hele yɛ́. Asinbɛnwʋn ɛjɔlɛ sɔ'n y'ɔ le kɛ, ɛnɛ alɩbahɩan bɛ hɔlɩ Zozi sɛka nɩn asʋ a, ");
INSERT INTO any_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","bɛ ngɔ nwun man yɩ́ fuin'n. Bɛ fi sɛka nɩn asʋ bɛ kɔ sa bɛ kɔ a. Bɛ kɔ han bɛ kɔ hele yɛ́ kɛ nyanmɩansʋ mmɔfʋɛ-mɔ a yɩ bɛ́ nwʋn a hele bɛ́. Mmɔfʋɛ sɔ'n-mɔ kɔ han kɔ hele bɛ́ kɛ Zozi anyɩn wɔ sʋ. ");
INSERT INTO any_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Yɛ́ manngʋn'n mmie-mɔ kɔ hɔ sɛka nɩn asʋ. Bɛ nwunlin ninnge'n-mɔ kʋalaa kɛ mmalasua'n-mɔ kpɩnlɩn hanlɩn yɩ́'n. Kʋsʋ, Zozi muonun dɩɛ, b'a nnwun man yɩ́.” ");
INSERT INTO any_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Ɛhɩ a, Zozi kɔ han kɔ hele bɛ́ kɛ: “Mmelenzua tomgban! ɛjɔlɛ kʋalaa mɔ Nyanmɩan mgbɔmanfʋɛ'n-mɔ a hɛlɛ'n, yɩ́ bʋ ɛtɩɛ yɔ sɩ man ɛmɔ o! ");
INSERT INTO any_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Asʋ, ɔ nzɛ nvata man kɛ *Kilisi'n, Belemgbin Ngʋandefʋɛ'n, ɔ nwún amannɩnhunlun sɔ'n nán ɔ wʋ́lʋ yɩ́ anunminnyanmʋn nɩn anun ɔ? ");
INSERT INTO any_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Mɔ Zozi hanlɩn sɔ yuelɩ'n, yɩ́ nwʋn ɛjɔlɛ m'ɔ wɔ Ɛhɛlɛ Ɛjɔlɛ nɩn anun'n, ɔ kɔ hehele bɛ́ nun. Ɔ kɔ bɔ yɩ́ bʋ Moyizɩ kalata dɩɛ'n-mɔ asʋ ɔ kɔ ju mgbɔmanfʋɛ'n-mɔ dɩɛ'n-mɔ asʋ.” ");
INSERT INTO any_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Mɔ bɛ hɔlɩ dede mɔ bɛ ka kaan bɛ ju kulo'n mɔ bɛ lɛ kɔ sʋ nɩn asʋ'n, Zozi yɔlɩ kɛ sʋanlan m'ɔ lɛ kpɛ nun ɔ kɔ mʋa ɔ. ");
INSERT INTO any_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Menian nnyuan'n kɔ hyɩ Zozi kɔ sie, bɛ́ nwan: “Da yɛ́ nwʋn ɛwa. Ɔ sanlɩn kɛ alɩ́ɛ a san a yue.” Mɔ bɛ hanlɩn sɔ'n, Zozi kɔ tie ɔ nʋn bɛ́ bɛ kɔ hɔ awulo. ");
INSERT INTO any_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Zozi nʋn bɛ́ bɛ kɔ tɛtanlan tɔbɩlɩ nɩn anwʋn. Ɔ kɔ fa kpaʋn'n ɔ kɔ la Nyanmɩan asɩ. M'ɔ lalɩ Nyanmɩan asɩ yuelɩ'n, ɔ kɔ bu kpaʋn nɩn anun ɔ kɔ man bɛ́. ");
INSERT INTO any_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Zozi falɩ kpaʋn'n manlɩn bɛ́ ala a, bɛ́ nyɩn'n kɔ buke bɛ kɔ nwun yɩ́ nzɔlɛ. Nan kʋsʋ Zozi nwannyanlɩn bɛ́ nyunnun ɛbɛlɛ. ");
INSERT INTO any_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Mɔ Zozi hɔlɩ'n, bɛ lɛ kan bɛ kele bɛ́ nwʋn kɛ: “Atunnun, mɛlɛ mɔ ɔ 'tutu Ɛhɛlɛ Ɛjɔlɛ nɩn abʋ ɔ kele yɛ́'n, yɩ́ ti yɛ̂ anɩn yɛ́ ahʋnlɩn a tɔ yɛ́ nun a man y'a li fɛ kpa nɩn ɔ.” ");
INSERT INTO any_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Ɛbɛlɛ ala, bɛ kɔ jasʋ bɛ kɔ sa bɛ́ nzin Zoluzalɛmʋn. Bɛ kɔ 'ju a, Zozi menian bulu nʋn kʋn'n nʋn bɛ́ manngʋn'n-mɔ a yia. ");
INSERT INTO any_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Bɛ lɛ kan kɛ: “Yɛ́ Mɩn fi ewue nun a tinnge sakpa! Simʋn a nwun yɩ́!” ");
INSERT INTO any_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Menian nnyuan'n mɔ bɛ́ kʋsʋ bɛ fi Emayusɩ bɛ juli ɛbɛlɛ'n, ɛjɔlɛ mɔ Zozi hanlɩn helelɩ bɛ́ atunnun, kɛ ɔ kpɩnlɩn yɔlɩ mɔ bɛ nwunlin Zozi nzɔlɛ mɛlɛ mɔ ɔ 'fa kpaʋn'n man bɛ́'n, bɛ kɔ han yɩ́ kʋalaa bɛ kɔ hele ɛhɩnlɩn-mɔ. ");
INSERT INTO any_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Mɛlɛ mɔ anɩn bɛ́ nʋan wɔ sʋ bɛ lɛ kan ɛjɔlɛ sɔ'n, fɩaɩn, Zozi kɔ fite bɛ́ afian ɛbɛlɛ, yɩ́ nwan: “Ɛmɔ mán bɛ́ lʋa cɩ́cɩ bɛ́ nwʋn!” ");
INSERT INTO any_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Mɔ bɛ nwunlin Zozi'n, esulo hanlɩn bɛ́ ɛsɛ bɛ́ nwʋn ngɔmʋa tuli. Ɔ sanlɩn kɛ bɛ jʋnlɩn kɛ b'a nwun ɛnwʋnmɩn. ");
INSERT INTO any_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Zozi kɔ bisa bɛ́ kɛ: “Nzukɛ ati yɛ̂ ɛmɔ sulo sʋa ɔ? Nzukɛ ati yɛ̂ ɛmɔ ajʋnlɩn'n tɩ nnyuan nnyuan ɔ? ");
INSERT INTO any_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Ɛmɔ nɩ́an mɩ́n sa'n-mɔ nʋn mɩ́n ja'n-mɔ! Ɛmɔ nwun yɩ́ kɛ mɩ́n ɔ! Ɛmɔ hán mɩ́n bɛ nɩ́an. Ɔ sanlɩn kɛ ɛnwʋnmɩn lɛ man anwʋnnaan ɔ nʋn bowe kɛ n ne yɩ́ mɔ ɛmɔ nwun mɩ́n'n.” ");
INSERT INTO any_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Mɔ Zozi 'kan ɛhɩ kele bɛ́'n, anɩn ɔ lɛ fa yɩ́ sa'n-mɔ nʋn yɩ́ ja'n-mɔ kele bɛ́. ");
INSERT INTO any_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Ɛjɔlɛ'n kɔ yɔ bɛ́ fɛ sʋnman, ɛsɛ ɔ kɔ sin bɛ́ nwʋn dede bɛ ngʋala bɛ nnwun man kɛ ɔ tɩ ananhɔlɛ ɔ. Ɛhɩ a, Zozi kɔ bisa bɛ́ kɛ: “Asʋ ɛmɔ le like ɛwa mɔ bɛ di ɔ?” ");
INSERT INTO any_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Mɔ Zozi bisalɩ bɛ́ kosuan sɔ'n, bɛ kɔ fa ejue ndʋan bɛ kɔ man yɩ́. ");
INSERT INTO any_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Ɔ kɔ li ejue sɔ'n bɛ́ nyunnun ɛbɛlɛ. ");
INSERT INTO any_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","M'ɔ lili yuelɩ'n, yɩ́ nwan: “Mɛlɛ mɔ anɩn mɩn nʋn ɛmɔ yɛ tɛ tɩ'n, n ganlɩn n gelelɩ ɛmɔ kɛ, mɩ́n nwʋn ɛjɔlɛ'n kʋalaatin mɔ b'a hɛlɛ wɔ Moyizɩ mala nɩn anun, mgbɔmanfʋɛ'n-mɔ kalata nɩn anun, ɔ nʋn Izalayɛ ejue ɛtʋɛ kalata nɩn anun'n, ɔ di kɛ ɔ kpɩn sʋ. Ɛjɔlɛ sɔ nɩn a kpɩn sʋ.” ");
INSERT INTO any_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Mɔ Zozi hanlɩn sɔ yuelɩ'n, ɔ kɔ buke bɛ́ ajʋnlɩn'n maan bɛ kɔ tɩ Ɛhɛlɛ Ɛjɔlɛ nɩn abʋ. ");
INSERT INTO any_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Ɛhɩka ati, Zozi kɔ han kɔ hele bɛ́ kɛ: “Ɛ 'nwun ɛjɔlɛ mɔ b'a hɛlɛ'n: ɔ di kɛ *Kilisi'n, Belemgbin Ngʋandefʋɛ'n, nwun amannɩnhunlun bɛ kun yɩ́. Bɛ kun yɩ́ a, yɩ́ cɩan nsan nɩn asʋ, ɔ fi ewue nun ɔ 'tinnge. ");
INSERT INTO any_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Ɛsɛ ɔ fata kɛ Kilisi'n, Belemgbin Ngʋandefʋɛ'n, dunman nun, bɛ bɔ yɩ́ bʋ Zoluzalɛmʋn ɛwa, bɛ bɔ Ɛjɔlɛkpa'n bɛ kele eyuadɩ nɩn anun menian'n-mɔ kʋalaatin maan bɛ kaci bɛ́ abalabɔ'n bɛ fa bɛ́ nwʋn bɛ man Nyanmɩan nán b'a nyan ɛtɛ face. ");
INSERT INTO any_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Ɛmɔ di ɛjɔlɛ sɔ nɩn anwʋn adanzɩɛ. ");
INSERT INTO any_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Like'n mɔ mɩ́n Sɩ a fa a bɔ ɛmɔ anɔhʋba'n, mɩ́n muonun mɩn 'ba man ɔ ba ɛmɔ sʋ. Nan kʋsʋ, ɛmɔ tánlan Zoluzalɛmʋn kulo nɩn asʋ ɛwa dede maan anwunno tunmin'n wʋ́lʋ ɛmɔ nun.” ");
INSERT INTO any_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Mɔ Zozi hanlɩn sɔ yuelɩ'n, ɔ nʋn bɛ́ bɛ fi kulo nɩn anun bɛ kɔ fite. Bɛ kɔ hɔ Betanin afan. Ɛbɛlɛ, Zozi kɔ kuku yɩ́ sa'n-mɔ anwunno ɔ kɔ yeyila bɛ́ sʋ. ");
INSERT INTO any_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Mɛlɛ mɔ ɔ 'yeyila bɛ́ sʋ'n, ɔ nʋn bɛ́ bɛ́ afian kɔ tɩ, ɔ kɔ fʋ kɔ hɔ nyanmɩansʋ. ");
INSERT INTO any_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Zozi menian'n-mɔ dɩɛ, mɔ bɛ sʋlɩ yɩ́ yuelɩ'n, bɛ le fɛ elie kpili kpa bɛ kɔ sa bɛ kɔ hɔ Zoluzalɛmʋn. ");
INSERT INTO any_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Tɛmʋn biala bɛ gua Nyanmɩan awulo nɩn anun bɛ yɩ yɩ́ ayɛ.");
INSERT INTO any_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Abʋbɔ nɩn anun, mɔ Nyanmɩan 'bɔ ninnge kʋalaatin'n, anɩn sʋanlan kʋn wɔ ɛbɛlɛ. Sʋanlan sɔ'n, bɛ fɛlɛ yɩ́ Nyanmɩan Anʋan Ɛjɔlɛ. Ɔ nʋn Nyanmɩan yɛ̂ bɛ tɩ ɔ. Ɔ tɩ Nyanmɩan sakpa. ");
INSERT INTO any_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Abʋbɔ nɩn anun, sʋanlan sɔ'n nʋn Nyanmɩan yɛ̂ bɛ tɩ ɔ. ");
INSERT INTO any_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Nyanmɩan nanndɩlɩ yɩ́ sʋ y'ɔ bɔlɩ ninnge kʋalaatin ɔ. Like fɩ́ɩ́ nnʋn man ɛbɛlɛ mɔ Nyanmɩan a nnanndɩ man yɩ́ sʋ ɔ'a mmɔ man ɔ. ");
INSERT INTO any_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Ngʋan baka'n y'ɔ le yɩ́. Yɛ̂ ngʋan baka sɔ'n y'ɔ tɩ menian'n-mɔ kanlannɩɛ nɩn ɔ. ");
INSERT INTO any_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Kanlannɩɛ sɔ'n lɛ ta awosin mân nɩn anun. Awosin'n nwan ɔ 'fɩa kanlannɩɛ nɩn anyɩn. Ɔ mantanlɩn yɩ́ dede a, ɔ'a ngʋala man yɩ́ nyɩn fɩa. ");
INSERT INTO any_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Ɔ wɔ ɛbɛlɛ dede a, cɩan kʋn Nyanmɩan kɔ yɩ sʋanlan kʋn asɩɛ nɩn asʋ ɛwa kɛ ɔ lí adanzɩɛ. Sʋanlan sɔ'n, bɛ fɛlɛ yɩ́ Zʋan. ");
INSERT INTO any_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Zʋan walɩ kanlannɩɛ nɩn anwʋn adanzɩɛ elie maan menian'n-mɔ kʋalaa nanndɩ yɩ́ sʋ bɛ de kanlannɩɛ sɔ'n bɛ di. ");
INSERT INTO any_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Nán kɛ yɩ́ y'ɔ tɩ kanlannɩɛ nɩn ɔ, nan ɔ walɩ kanlannɩɛ nɩn anwʋn adanzɩɛ elie. ");
INSERT INTO any_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Kanlannɩɛ kpa sɔ'n m'ɔ man menian'n-mɔ kʋalaa nwun asɩ'n lɛ ba mân nɩn anun. ");
INSERT INTO any_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Ɔ walɩ juli asɩɛ nɩn asʋ ɛwa. Yɩ́ yɛ̂ Nyanmɩan man ɔ sesielɩ eyuadɩ nɩn ɔ. Kʋsʋ menian dɔʋn a mmu man yɩ́ like. ");
INSERT INTO any_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Ɔ walɩ menian'n mɔ Nyanmɩan falɩ bɛ́ yɔlɩ yɩ́ dɩɛ'n-mɔ afian, bɛ́ kʋsʋ bɛ́ dɔʋn, b'a nne man yɩ́. ");
INSERT INTO any_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Nan kʋsʋ mmie-mɔ lelɩ yɩ́. Menian sɔ'n-mɔ kʋalaa mɔ bɛ leli yɩ́ bɛ lili'n, ɔ'a man bɛ́ atɩn maan b'a kaci Nyanmɩan amma. ");
INSERT INTO any_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Nyanmɩan mma'n mɔ b'a kaci'n, nán kulo sʋanlan tunmin nun kɛ belenzua nʋn balasua bɛ́ wa mɔ b'a wʋ yɩ́ ɔ. Nan Nyanmɩan muonun yɛ̂ ɔ'a fa ngʋan fʋfɔlɛ sɔ'n ɔ'a man bɛ́ ɔ. ");
INSERT INTO any_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Nyanmɩan Anʋan Ɛjɔlɛ nɩn a kaci yɩ́ nwʋn kulo sʋanlan, ɔ a a tanlan yɛ́ afian ɛwa. Ɔ'a nwun yɛ́ nwʋn anwunnvoe kpili kpa. Ɛsɛ ɔ'a yɩ Nyanmɩan ɔ'a hele yɛ́ yuein. Y'a nwun yɩ́ anunminnyanmʋn'n, anunminnyanmʋn'n mɔ Sɩɛ Nyanmɩan falɩ manlɩn yɩ́'n. Ɔ sanlɩn kɛ ɔ tɩ yɩ́ Bangɔlɔ. ");
INSERT INTO any_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Sʋanlan sɔ nɩn anwʋn ɛjɔlɛ yɛ̂ Zʋan tɩanlɩn nun hanlɩn nɩn ɔ. Yɩ́ nwan: “Sʋanlan ɛhɩ yɛ̂ n ganlɩn kɛ ɔ li mɩ́n nzin ɔ lɛ ba nɩn ɔ. Ɔ tɩ kpili tala mɩ́n. Ɔ sanlɩn kɛ ɔ tɩ asɩ dahuu.” ");
INSERT INTO any_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Ɛhɩ, anwunnvoe baka'n m'ɔ tɩ nɩn ati, ɔ'a yeyila yɛ́ sʋ. Ɛsɛ bɔbɔ, ɔ tɛ yeyila yɛ́ sʋ kpili kpa. ");
INSERT INTO any_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Afɩ, daba Nyanmɩan nanndɩlɩ yɛ́ nan *Moyizɩ asʋ yɛ̂ ɔ falɩ yɩ́ mala'n manlɩn yɛ́ ɔ. Nan sian dɩɛ, Nyanmɩan nanndɩ Zozi Kilisi asʋ ɔ'a nwun yɛ́ nwʋn anwunnvoe ɔ'a hele yɛ́ ananhɔlɛ atɩn'n. ");
INSERT INTO any_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Sʋanlan fɩ́ɩ́ nwunlin man Nyanmɩan lé. Nan Nyanmɩan Bangɔlɔ Zozi m'ɔ tɩ Nyanmɩan'n, m'ɔ mantan Sɩɛ'n, yɩ́ y'ɔ man yɛ nwun yɩ́ ɔ. ");
INSERT INTO any_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Ɔ 'ba yɔ sɔ'n, anɩn Zʋan lɛ sɔnɩn menian wɔ asue Zuludɩn nɩn anzin ɛlɔ lɩka kʋn. Zoluzalɛmʋn Zufʋ mgbain'n-mɔ kɔ tɩ. Cɩan kʋn, bɛ kɔ sʋan Nyanmɩan *tɛɛyɩfʋɛ mmie-mɔ nʋn *Levifʋɛ kʋsʋ mmie-mɔ, bɛ kɔ a kɔ tʋ Zʋan, bɛ́ nwan: “Zʋan, wɔ́ muonun, nwan sʋanlan dɩɛ y'ɔ le wɔ́?” ");
INSERT INTO any_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Mɔ bɛ bisalɩ kosuan sɔ'n, Zʋan kpacɩlɩ nun ɔ hanlɩn yɩ́ ananhɔlɛ yuein helelɩ bɛ́ kɛ: “Nán *Kilisi'n y'ɔ le mɩ́n.” ");
INSERT INTO any_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Mɔ Zʋan bualɩ bɛ́ sɔ'n, bɛ́ nwan: “Sɛ nán yɩ́ y'ɔ le wɔ́ a, anɩn nwan sʋanlan dɩɛ kpa y'ɔ le wɔ́? *Eli y'ɔ le wɔ́ anaan?” Zʋan nwan: “Nán Eli y'ɔ le mɩ́n.” Ɛsɛ bɛ kɔ bisa yɩ́ biekun kɛ: “Anɩn Nyanmɩan *Kpɔmanfʋɛ'n y'ɔ le wɔ́ ɔ?” Zʋan nwan: “Cɛcɛ.” ");
INSERT INTO any_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Ɛjɔlɛ ɛhɩ kɔ sin bɛ́ nwʋn, bɛ́ nwan: “A! Anɩn nwan sʋanlan dɩɛ bɔbɔ kpa y'ɔ le wɔ́? Bua yɛ́ bie maan yɛ hɔ́ hán héle bɛ́ mɔ bɛ sʋanlɩn yɛ́'n. Ɛ bu wɔ́ nwʋn kɛ nwan y'ɔ le wɔ́?” ");
INSERT INTO any_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Ɛhɩ a, Zʋan nwan: “Sʋanlan'n mɔ Nyanmɩan Kpɔmanfʋɛ *Ezayi lili mʋa hanlɩn yɩ́ nwʋn ɛjɔlɛ kɛ: Sʋanlan kʋn lɛ tɩan ɛwâ nɩn anun ɛlɔ kɛ: ‘Ɛmɔ sésie yɛ́ Mɩn atɩn'n!’ sʋanlan sɔ'n y'ɔ le mɩ́n.” ");
INSERT INTO any_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Bɛ́ mɔ bɛ sʋanlɩn bɛ́ Zʋan anwʋn ɛlɔ'n mmie-mɔ tɩ *Falisifʋɛ. ");
INSERT INTO any_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Bɛ́ nwan: “Sɛ nán Kilisi'n y'ɔ le wɔ́, sɛ nán Eli y'ɔ le wɔ́, ɛsɛ sɛ nán Nyanmɩan Kpɔmanfʋɛ'n y'ɔ le wɔ́ a, anɩn nzukɛ ati yɛ̂ ɛ sɔnɩn menian'n-mɔ ɔ?” ");
INSERT INTO any_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Mɔ bɛ bisalɩ kosuan sɔ'n, Zʋan nwan: “Mɩ́n dɩɛ, n ne nzue yɛ̂ mɩn fa mɩn sɔnɩn ɔ, nan sʋanlan kʋn wɔ ɛmɔ afian ɛbɛlɛ, ɛmɔ nzɩ man yɩ́. ");
INSERT INTO any_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Sʋanlan sɔ'n fi mɩ́n nzin ɔ lɛ ba, mɩn nzɛ nvata man kɛ mɩn nyannjɩ yɩ́ ja mgbabʋa nyanman'n bɔbɔ mgban ɔ.” ");
INSERT INTO any_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Ɛjɔlɛ ɛhɩ kʋalaa sɩnlɩn Betanin, asue Zuludɩn nɩn ebue kʋn ɛlɔ, lɩka mɔ anɩn Zʋan sɔnɩn menian'n-mɔ'n. ");
INSERT INTO any_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Mɔ bɛ hanlɩn ɛhɩ yuelɩ'n, yɩ́ alɩ́ɛ hɩnlɩn, Zʋan 'tʋ yɩ́ nyɩn an, anɩn Zozi lɛ ba yɩ́ nwʋn ɛbɛlɛ, yɩ́ nwan: “Ɛ 'nwun Nyanmɩan *Bʋa Baa'n, Nyanmɩan 'ba fa yɩ́ yɩ mân nɩn ati tɛɛ ɔ tu yɩ́ ɛtɛ'n kɔ. ");
INSERT INTO any_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Yɩ́ dein yɛ̂ n ganlɩn yɩ́ ɛjɔlɛ kɛ: ‘Sʋanlan kʋn li mɩ́n nzin ɔ lɛ ba, ɔ tɩ kpili tala mɩ́n. Ɔ sanlɩn kɛ ɔ tɩ asɩ dahuu.’ ");
INSERT INTO any_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Mɩn nzɩ man yɩ́ daba. Nan kɛmɔ ɔ fata kɛ Izalayɛ amma'n-mɔ nwun yɩ́'n, yɩ́ ti yɛ̂ Nyanmɩan a sʋan mɩ́n kɛ m mála n vá nzue n zɔ́nɩn bɛ́ ɔ.” ");
INSERT INTO any_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Ɛhɩ, Zʋan lili Zozi anwʋn adanzɩɛ kɛ: “Mɩɩn kan mɩn kele ɛmɔ kɛ, m'an nwun kɛ Wawɛ Nwannzan-nwannzan'n fi nyanmɩansʋ kɛ abubule ɔ'a ju ɔ'a tanlan yɩ́ sʋ. ");
INSERT INTO any_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Mɩ́n bɔbɔ muonun, anɩn mɩn nzɩ man yɩ́ sʋanlan ɛhɔlɛ kʋn'n, nan Nyanmɩan a han a hele mɩ́n kɛ: ‘Sʋanlan'n mɔ ɛ kɔ nwun kɛ mɩ́n Wawɛ Nwannzan-nwannzan'n kɔ ju kɔ tanlan yɩ́ sʋ'n, sʋanlan sɔ'n yɛ̂ ɔ 'fa Wawɛ sɔ'n sɔnɩn menian'n-mɔ ɔ.’ ");
INSERT INTO any_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Ɛjɔlɛ sɔ'n mɔ m'an nwun yɩ́ mɩ́n nyɩnsʋ nɩn ati, mɩn di yɩ́ nwʋn adanzɩɛ kɛ ɔ tɩ Nyanmɩan Awa sakpa.” ");
INSERT INTO any_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Ɛhɩ mɔ alɩ́ɛ hɩnlɩn'n, anɩn Zʋan nʋn yɩ́ menian'n-mɔ anun nnyuan jijin ɛbɛlɛ. ");
INSERT INTO any_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","M'ɔ nwunlin kɛ Zozi lɛ sɩn'n, yɩ́ nwan: “Ɛ 'nwun Nyanmɩan *Bʋa Baa'n.” ");
INSERT INTO any_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Mɔ yɩ́ menian nnyuan'n tɩlɩ ɛjɔlɛ sɔ'n, bɛ yacili yɩ́ ɛbɛlɛ yɛ̂ cuein, bɛ kɔ si Zozi sʋ. ");
INSERT INTO any_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Zozi hɔlɩ kaan, ɔ 'tʋ yɩ́ nyɩn yɩ́ nzin an, menian si yɩ́ sʋ. Ɔ kɔ bisa bɛ́ kɛ: “Ɛmɔ lɛ kpʋnndɛ nzu?” Bɛ́ nwan: “*Labi” (yɩ́ bʋ y'ɔ le kɛ ngehelefʋɛ), “yɛ lɛ kpʋnndɛ lɩka mɔ ɛ tɩ'n.” ");
INSERT INTO any_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Ɛhɩ a, Zozi nwan: “Ɛmɔ bála a nɩan.” Ɛbɛlɛ ala, bɛ kɔ si yɩ́ sʋ bɛ nʋn yɩ́ kɔ hɔ lɩka m'ɔ tɩ'n, bɛ nʋn yɩ́ kɔ tanlan ɛbɛlɛ dede sɛnzɛ'n kɔ tɔ. Ɔ 'ba yɔ sɔ'n, mɔ Zʋan menian nnyuan'n 'si Zozi sʋ'n, anɩn b'a bɔ nɔsʋba dɔɛ nnan. ");
INSERT INTO any_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Zʋan menian nnyuan sɔ'n, kʋn li Andele. Andele sɔ'n, yɩ́ nianman y'ɔ le Simʋn Pɩɛlɩ. ");
INSERT INTO any_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Andele y'ɔ lili mʋa hɔlɩ tʋlɩ yɩ́ nianman bian Simʋn an, yɩ́ nwan: “Mɩ́n nianman Simʋn, y'a nwun *Mesi'n.” (Yɩ́ bʋ y'ɔ le kɛ *Kilisi, Izalayɛ Belemgbin Ngʋandefʋɛ.) ");
INSERT INTO any_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Mɔ Andele hanlɩn sɔ yuelɩ'n, ɔ nʋn yɩ́ kɔ hɔ Zozi anwʋn ɛlɔ ɔ kɔ fa yɩ́ kɔ hele yɩ́. Zozi nɩanlɩn yɩ́ a, yɩ́ nwan: “Wɔ́, bɛ fɛlɛ wɔ́ Simʋn. Zʋan awa y'ɔ le wɔ́. Ɔ fi ɛnɛ m'ɔ kɔ'n, bɛ 'ba fɛlɛ wɔ́ Sefasɩ.” (Sefasɩ'n tɩ *ebele anɩɛ, yɩ́ *gɛlɛkɩ nun an, anɩn ɔ li Pɩɛlɩ. Yɩ́ bʋ y'ɔ le kɛ ɛbʋɛ.) ");
INSERT INTO any_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Ɛhɩ, mɔ alɩ́ɛ hɩnlɩn'n, Zozi nwan ɔ 'kɔ Galile mân nɩn anun ɛlɔ. M'ɔ tuli yɩ́ bʋ mɔ ɔ 'kɔ'n, ɔ kɔ hɔ kɔ tʋ Filipʋ, yɩ́ nwan: “Filipʋ, si mɩ́n sʋ!” ");
INSERT INTO any_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Filipʋ nʋn Andele nʋn Pɩɛlɩ, bɛ fi kulo kʋn. Bɛ fɛlɛ kulo sɔ'n Bɛtɩsayida. ");
INSERT INTO any_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Mɔ Zozi hanlɩn sɔ yuelɩ'n, Filipʋ kɔ hɔ kɔ tʋ Natanayɛ, yɩ́ nwan: “Sʋanlan'n mɔ *Moyizɩ hanlɩn yɩ́ nwʋn ɛjɔlɛ *Mala Kalata nɩn anun, mɔ ɛsɛ Nyanmɩan mgbɔmanfʋɛ'n-mɔ kʋsʋ hɛlɛlɩ yɩ́ nwʋn ɛjɔlɛ'n, y'a nwun yɩ́. Bɛ fɛlɛ yɩ́ Zozi. Ɔ fi Nazalɛtɩ. Yɩ́ sɩ y'ɔ le Zozɛfʋ.” ");
INSERT INTO any_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Ɛjɔlɛ sɔ'n mɔ Filipʋ hanlɩn helelɩ yɩ́'n sinlin yɩ́ nwʋn, yɩ́ nwan: “Nazalɛtɩ kulo ɛhɩ m'ɔ wɔ ɛlɔ'n, asʋ like kpa 'fite sʋ lé?” Filipʋ nwan: “Bala, ba nɩan.” ");
INSERT INTO any_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Mɔ Zozi nwunlin kɛ Natanayɛ lɛ ba yɩ́ nwʋn ɛbɛlɛ'n, yɩ́ nwan: “Ɛmɔ nɩ́an, Izalayɛ sʋanlan bɔkɔɔ y'ɔ le sʋanlan ɛhɩ, ɔ nni man ato fɩ́ɩ́.” ");
INSERT INTO any_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Ɛjɔlɛ sɔ'n kɔ sin Natanayɛ anwʋn, yɩ́ nwan: “Nan ɛ sɩ mɩ́n nin?” Zozi nwan: “Mɔ anɩn ɛ tɩ *figi baka nɩn abʋ, mɔ Filipʋ fɛlɛlɩ man wɔ́'n yɛ̂ n nwunlin wɔ́ ɔ.” ");
INSERT INTO any_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Natanayɛ nwan: “*Labi, ɛ tɩ Nyanmɩan Awa, ɛsɛ ɛ tɩ Izalayɛ Belemgbin sakpa.” ");
INSERT INTO any_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Zozi nwan: “Kɛmɔ mɩ́n nwan n nwunlin wɔ́ figi baka nɩn abʋ'n, ɔ man a le a li? Ɛ 'ba nwun ninnge dɔʋn mɔ bɛ tala ɛhɩ.” ");
INSERT INTO any_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Ɛsɛ yɩ́ nwan: “Mɩɩn kan yɩ́ ananhɔlɛ mɩn kele ɛmɔ kɛ, ɛmɔ 'ba nwun kɛ anwunno nɩn a buke yɛ̂ nyanmɩansʋ mmɔfʋɛ'n-mɔ fi *Mân Baa nɩn anwʋn asɩɛ nɩn asʋ ɛwa, mmie-mɔ lɛ fʋ a, anɩn mmie-mɔ lɛ ju.” ");
INSERT INTO any_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Mɔ Zozi fɛlɛlɩ yɩ́ menian sɔ'n-mɔ yuelɩ'n, yɩ́ nzin cɩan nsan, anɩn bɛ lɛ fa atɔnvɔlɛ kʋn Galile mân nɩn anun ɛlɔ kulo kʋn asʋ. Kulo sɔ'n, bɛ fɛlɛ yɩ́ Kana. Anɩn Zozi anin'n wɔ ɛbɛlɛ bie. ");
INSERT INTO any_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Atɔnvɔlɛ sɔ nɩn abʋ, bɛ kɔ fɛlɛ Zozi nʋn yɩ́ menian'n-mɔ. ");
INSERT INTO any_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Bɛ lili fɛtɩ'n dede mɔ ɔ 'kɔ bie'n, bɛ́ nzan'n kɔ yue. Ɛhɩ a, Zozi anin'n kɔ hɔ kɔ tʋ yɩ́, yɩ́ nwan: “Zozi, bɛ́ nzan nɩn a yue o.” ");
INSERT INTO any_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Zozi manlɩn yɩ́ nʋan sʋ a, yɩ́ nwan: “M mo, si abʋtamʋn, nán mɩ́n *dɔɛ dɩɛ'n nyan juli man.” ");
INSERT INTO any_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Ɛbɛlɛ ala, yɩ́ nin kɔ hɔ kɔ tʋ bɛ́ mɔ bɛ lɛ su nzan'n, yɩ́ nwan: “Like biala mɔ Zozi kɔ se kɛ ɛmɔ yɔ́'n, ɛmɔ kpɩ́nlɩn sʋ bɛ yɔ́.” ");
INSERT INTO any_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Anɩn, nyɔbʋɛ ɛ́tɛ́ nsian jijin ɛbɛlɛ, kʋn kʋala kɛ ɔ fa nzue elitili ɛya kʋn. Nun nzue'n, Zufʋ'n-mɔ fa nwunnzin bɛ́ sa bɛ tu bɛ́ nwʋn efian bɛ yɔ bɛ́ nwʋn nwannzan-nwannzan, ɛsɛ bɛ fa bɛ kputa bɛ́ ninnge. Afɩ, ɔ tɩ bɛ́ mala. ");
INSERT INTO any_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Zozi kɔ han kɔ hele bɛ́ mɔ bɛ lɛ su nzan'n kɛ: “Ɛmɔ sá nzue bɛ gúa ɛ́tɛ́ ɛhɩ-mɔ anun maan ɔ yí.” Mɔ Zozi hanlɩn sɔ helelɩ bɛ́'n, bɛ kɔ sa nzue bɛ kɔ gugua nun dede bɛ kɔ yi tɩtɛkɛɛ. ");
INSERT INTO any_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Zozi nwan: “Sian dɩɛ, ɛmɔ sá bie bɛ hɔ́ mán fɛtɩ nɩn asʋ kpain'n.” Ɛbɛlɛ ala, bɛ kɔ sa bie bɛ kɔ hɔ. ");
INSERT INTO any_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Fɛtɩ nɩn asʋ kpain'n 'bɔ sʋ o, nzue nɩn a kaci nzan. Bian'n nɩan an, ɔ nnwun man lɩka mɔ nzan sɔ'n fi ɔ, kʋsʋ bɛ́ mɔ bɛ lɛ su'n, bɛ dɩɛ, bɛ sɩ. ");
INSERT INTO any_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","M'ɔ bɔlɩ nzan nɩn asʋ yuelɩ'n, ɔ kɔ fɛlɛ atɔnvɔlɛ bian'n, yɩ́ nwan: “Eja, mɩn 'yɔ wɔ́ mo kpa! A bɔ mɔndɩnlɩn sakpa! Menian'n-mɔ kʋalaa, sɛ bɛ 'fa bɛ́ atɔnvɔlɛ nɩn an, bɛ di mʋa bɛ su nzan'n m'ɔ yɔ fɛ kpa'n. Bɛ nʋn dede bɛ fɛ a, bɛlɛ mɔ anɩn bɛ lɛ su m'ɔ nyɔ man fɛ kpa nɩn ɔ. Nan wɔ́ dɩɛ, mɔ a su yɩ́ sian'n yɔ fɛ tala mɔ ɛ lili mʋa suli'n.” ");
INSERT INTO any_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Anɩn kɛ ɔ kpɩnlɩn yɔlɩ mɔ Zozi yɩlɩ alimʋa asinbɛnwʋn like m'ɔ tɩ nzɔlɛ nɩn anɩn. Ɔ yɩlɩ yɩ́ wɔ Galile mân nɩn anun, kulo'n mɔ bɛ fɛlɛ yɩ́ Kana nɩn asʋ. Ɔ yɔlɩ sɔ maan bɛ nwunlin yɩ́ anunminnyanmʋn'n. Asinbɛnwʋn like sɔ'n manlɩn yɩ́ menian'n-mɔ lelɩ yɩ́ lili. ");
INSERT INTO any_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Mɔ bɛ falɩ atɔnvɔlɛ'n yuelɩ'n, Zozi nʋn yɩ́ nin nʋn yɩ́ nianman'n-mɔ nʋn yɩ́ menian'n-mɔ, bɛ hɔlɩ Kapɛɛnawɔmʋn kulo nɩn asʋ, bɛ lili kɔ yɔ ɛlɛ nnyuan kʋn ɛbɛlɛ. ");
INSERT INTO any_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Kɛmɔ anɩn Zufʋ'n-mɔ fanwʋndi fɛtɩ'n mɔ bɛ fɛlɛ yɩ́ *Pakɩ'n ka kaan ju'n, Zozi kɔ hɔ Zoluzalɛmʋn. ");
INSERT INTO any_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","M'ɔ juli ɛlɔ'n, ɔ wʋlʋlɩ Nyanmɩan awulo nɩn anun, ɔ 'kɔ a ju a, anɩn menian mmie-mɔ tɩtɩ ɛbɛlɛ, bɛ lɛ tɔnɩn bɛ́ nnalɛ nʋn bɛ́ mmʋa ɔ nʋn bɛ́ mɔlɔnʋnman. (Bɛ to ninnge sɔ'n-mɔ bɛ fa bɛ yɩ tɛɛ.) Ɔ 'tʋ yɩ́ nyɩn an, anɩn menian mmie-mɔ tɩtɩ bɛ́ tɔbɩlɩ nwʋn, bɛ lɛ di esika ɛkacie junman. ");
INSERT INTO any_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Mɔ Zozi nwunlin yɩ́ sɔ'n, ɛbɛlɛ ala, ɔ kɔ hɔ kɔ fa nyanman ɔ kɔ nwʋn mgbele. Ɔ kɔ fa kɔ fʋan bɛ́ kʋalaa kɔ fite awulo, bɛ́ nʋn bɛ́ mmʋa, nʋn bɛ́ nnalɛ'n-mɔ kʋalaa. Bɛ́ mɔ bɛ lɛ kaci bɛ́ esika'n kʋsʋ, ɔ kɔ han bɛ́ esika'n-mɔ kɔ gua asɩ, ɔ kɔ kunnzun bɛ́ tɔbɩlɩ'n-mɔ kɔ gua asɩ. ");
INSERT INTO any_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Ɔ kɔ han kɔ hele bɛ́ mɔ bɛ lɛ tɔnɩn mɔlɔnʋnman'n-mɔ kɛ: “Ɛmɔ yɩ́yɩ bɛ́ ninnge'n-mɔ kʋalaa ɛwa, nán bɛ fa mɩ́n Sɩ awulo'n bɛ kaci gua elie lɩka.” ");
INSERT INTO any_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Mɔ Zozi hanlɩn ɛjɔlɛ sɔ'n yuelɩ'n, yɩ́ menian'n-mɔ ati kɔ kpɩn *Ɛhɛlɛ Ɛjɔlɛ'n lɩka ɛhɩ asʋ: Mɩ́n Nyanmɩan, wɔ́ awulo nɩn anwʋn ehulo mɔ n ne yɩ́'n, ɔ 'ba man mɩn wu. ");
INSERT INTO any_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Ɛhɩ a, Zufʋ mgbain'n-mɔ nwan: “Nzu like dɩɛ kpa yɛ̂ ɛ kʋala yɩ́ yɔ m'ɔ kele kɛ ɛ le tunmin ɛ bɔ bala sʋa ɔ?” ");
INSERT INTO any_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Zozi nwan: “Ɛmɔ búbu sua nwannzan-nwannzan ɛhɩ, nan mɩn 'fa cɩan nsan mɩn si.” ");
INSERT INTO any_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Mɔ Zozi hanlɩn sɔ'n, Zufʋ mgbain'n-mɔ nwan: “An! *Sua Nwannzan-nwannzan ɛhɩ, mɔ b'a fa afʋɛ abulanan nʋn nsian b'a si'n, wɔ́ dɩɛ, ɛ 'fa cɩan nsan kpɛ̂ ɛ si yɩ́ fʋfɔlɛ?” ");
INSERT INTO any_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Sua nwannzan-nwannzan'n mɔ anɩn Zozi lɛ kan yɩ́ ɛjɔlɛ'n y'ɔ le yɩ́ muonun yɩ́ sʋanlan baka'n. ");
INSERT INTO any_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","M'ɔ fi ewue nun tinngelɩ'n, yɩ́ menian'n-mɔ kacɩlɩ ɛjɔlɛ sɔ'n m'ɔ hanlɩn'n. Ɔ man bɛ lelɩ *Ɛhɛlɛ Ɛjɔlɛ'n nʋn mɔ Zozi hanlɩn'n bɛ lili. ");
INSERT INTO any_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Cɩan dʋdʋ mɔ Zozi lili yɩ́ Zoluzalɛmʋn ɛbɛlɛ Zufʋ'n-mɔ *Pakɩ elie nɩn anun'n, menian dɔʋn nwunlin yɩ́ asinbɛnwʋn ninnge'n m'ɔ yɔ'n, bɛ lelɩ yɩ́ bɛ lili. ");
INSERT INTO any_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Zozi dɩɛ, ɔ'a nva man yɩ́ ajʋnlɩn ɔ'a ndʋ man bɛ́ sʋ, ɔ sanlɩn kɛ ɔ sɩ bɛ́ ahʋnlɩn nɩn anun ɛjɔlɛ'n kʋalaatin. ");
INSERT INTO any_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Ɔ mgbʋnndɛ man kɛ bɛ kan kulo sʋanlan anwʋn ɛjɔlɛ bɛ kele yɩ́ bɔbɔ, afɩ yɩ́ muonun, ɔ sɩ menian'n-mɔ ahʋnlɩn nɩn anun ɛjɔlɛ'n kʋalaatin. ");
INSERT INTO any_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Anɩn Zufʋ'n-mɔ kpain kʋn wɔ ɛbɛlɛ, bɛ fɛlɛ yɩ́ Ninkodɛmʋn. Ɔ di *Falisifʋɛ'n-mɔ fâ'n bie. ");
INSERT INTO any_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Cɩan kʋn kɔngɔɛ, ɔ kɔ a kɔ tʋ Zozi. Yɩ́ nwan: “*Labi, y'a nwun kɛ Nyanmɩan a sʋan wɔ́ sakpa kɛ ɛ bála a hehele yɛ́ ninnge. Asinbɛnwʋn ninnge'n-mɔ mɔ ɛ yɔ'n kele kɛ Nyanmɩan jin wɔ́ nzin. Afɩ sʋanlan mɔ Nyanmɩan jin man yɩ́ nzin'n, ɔ ngʋala man bie yɔ.” ");
INSERT INTO any_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Ɛhɩ a, Zozi nwan: “Mɩɩn kan yɩ́ ananhɔlɛ mɩn kele wɔ́ kɛ sʋanlan biala mɔ b'a nwʋ man yɩ́ fʋfɔlɛ biekun'n, yɩ́ nyɩn ngʋala mmɔ man Nyanmɩan Belemgbin Mân'n.” ");
INSERT INTO any_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Mɔ Zozi hanlɩn sɔ'n, Ninkodɛmʋn nwan: “Nan anɩn, sʋanlan mɔ ɔ'a yɔ kpain a yue'n, ɔ 'yɔ sɛ nán b'a wʋ yɩ́ fʋfɔlɛ biekun? Asʋ ɔ kʋala kɛ ɔ sa kɔ yɩ́ nin akunnun maan bɛ wʋ yɩ́ biekun ɔ?” ");
INSERT INTO any_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Zozi nwan: “Mɩɩn kan yɩ́ ananhɔlɛ mɩn kele wɔ́ kɛ sʋanlan mɔ b'a nva man nzue nʋn Nyanmɩan Wawɛ'n b'a mman man yɩ́ ngʋan fʋfɔlɛ'n, ɔ ngʋala man kɛ ɔ kaci Nyanmɩan Belemgbin Mân nɩn anun sʋanlan. ");
INSERT INTO any_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Sɛ kulo sʋanlan wʋ wɔ́ a, nwun yɩ́ kɛ ɛ di sʋanlan afilie. Yɛ̂ sɛ Nyanmɩan Wawɛ'n kʋsʋ wʋ wɔ́ a, nwun yɩ́ kɛ ɛ di yɩ́ Wawɛ nun afilie'n bie. ");
INSERT INTO any_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Sɛ mɩɩn kan mɩn kele wɔ́ kɛ ɔ fata kɛ bɛ wʋ́ ɛmɔ kʋalaa fʋfɔlɛ biekun an, n'ɛ man ɔ sin wɔ́ nwʋn. ");
INSERT INTO any_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Lɩka mɔ anwʋnman'n kulo'n y'ɔ fita kɔ ɔ. Ɛ tɩ yɩ́ ngan, nan sɛ ɔ fi nin e, sɛ ɔ lɛ kɔ nin e, ɛ nzɩ man. Awɔlɛ fʋfɔlɛ'n mɔ Nyanmɩan Wawɛ'n wʋ menian'n-mɔ'n, kɛ ɔ tɩ yɩ́ nɩn anɩn.” ");
INSERT INTO any_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Ɛhɩ a, Ninkodɛmʋn nwan: “Anɩn ɔ 'yɔ sɛ kpa nán ɔ'a yɔ sɔ?” ");
INSERT INTO any_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Zozi nwan: “E! Ninkodɛmʋn, wɔ́ mɔ ɛ tɩ Izalayɛ mân nɩn asʋ kpain mɔ ɛ kekele Nyanmɩan anʋan ɛjɔlɛ'n, ɛ nzɩ man ninnge sɔ'n-mɔ ɔ? ");
INSERT INTO any_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Mɩɩn kan yɩ́ ananhɔlɛ mɩn kele wɔ́ kɛ yɛ lɛ kan ninnge'n-mɔ mɔ yɛ sɩ nɩn anwʋn ɛjɔlɛ yɛ kele ɛmɔ, ɛsɛ yɛ lɛ di mɔ y'a nwun yɩ́ nɩn anwʋn adanzɩɛ, kʋsʋ ɛmɔ mmu man yɩ́ ananhɔlɛ. ");
INSERT INTO any_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Sɛ mɩn kan asɩɛ nɩn asʋ ɛwa ɛjɔlɛ mɩn kele ɛmɔ a, ɛmɔ mmu man yɩ́ ananhɔlɛ, nan sɛ mɩn kan nyanmɩansʋ ɛlɔ ɛjɔlɛ mɩn kele ɛmɔ a, ɔ 'yɔ sɛ nán ɛmɔ a le a li? ");
INSERT INTO any_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Sʋanlan fɩ́ɩ́ fʋlɩ man nyanmɩansʋ lé, cɛlɛ kɛ *Mân Baa'n m'ɔ fi nyanmɩansʋ ɔ'a ju asɩɛ nɩn asʋ ɛwa'n. ");
INSERT INTO any_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Kɛ *Moyizɩ falɩ jɛtɛ kɔkɔlɛ'n ɔ bɔlɩ owo kʋn ɔ sinnzelɩ yɩ́ baka ati ɔ kpanlanlɩn yɩ́ ɛwâ nɩn anun ɛlɔ daba'n, ɔ di kɛ bɛ fʋla Mân Baa'n kʋsʋ anwunno, ");
INSERT INTO any_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","maan sʋanlan biala m'ɔ kɔ le yɩ́ kɔ li'n, ɔ nyan nyanmɩansʋ ngʋan m'ɔ le man ayuelɩɛ'n.” ");
INSERT INTO any_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Afɩ, Nyanmɩan Kpili a hulo eyuadɩ'n dede ɔ'a fa yɩ́ Bangɔlɔ'n ɔ'a hye yɩ́ maan sʋanlan biala m'ɔ kɔ le Baa sɔ'n kɔ li'n, Nyanmɩan sikpɛ'n ngun man yɩ́, nan ɔ nyan nyanmɩansʋ ngʋan m'ɔ le man ayuelɩɛ'n. ");
INSERT INTO any_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Nyanmɩan Kpili a nzʋan man yɩ́ Wa'n kɛ ɔ bála a tua eyuadɩ nɩn ɛtɛ nɩn anwʋn kalɛ, nan ɔ sʋanlɩn yɩ́ kɛ ɔ bála a le yɩ́ ti ngʋan. ");
INSERT INTO any_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Sʋanlan m'ɔ de yɩ́ di'n, bɛ mmu man yɩ́ fʋɔ, nan sʋanlan m'ɔ nne man yɩ́ nni man'n, b'a bu yɩ́ fʋɔ dada angʋnmɩn. Ɔ sanlɩn kɛ ɔ'a nne man Nyanmɩan Bangɔlɔ'n ɔ'a nni man. ");
INSERT INTO any_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Lɩka mɔ bɛ 'fa bɛ bu menian'n-mɔ fʋɔ'n, y'ɔ le kɛ kanlannɩɛ nɩn a a mân nɩn anun, nan kʋsʋ kɛmɔ menian'n-mɔ yɔ ɛtɛ nɩn ati, bɛ kulo awosin'n bɛ tala kanlannɩɛ'n. ");
INSERT INTO any_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Sʋanlan biala m'ɔ yɔ ɛtɛ'n, ɔ kpɔ kanlannɩɛ'n, ɔ nvite man nun, afɩ ɔ sulo kɛ bɛ kɔ nwun yɩ́ nyɔlɩɛ ɛtɛ'n m'ɔ yɔ'n. ");
INSERT INTO any_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Nan sʋanlan m'ɔ yɔ nyɔlɩɛ kpa'n, yɩ́ dɩɛ, ɔ fite kanlannɩɛ nɩn anun, ɔ man bɛ nwun yɩ́ fɔ́ʋ́n kɛ ɔ yɔ like mɔ Nyanmɩan kulo'n. ");
INSERT INTO any_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Ɛhɩ anzin, Zozi nʋn yɩ́ menian'n-mɔ fi Zoluzalɛmʋn bɛ jasʋlɩ bɛ hɔlɩ Zude mân nɩn akunnun ɛlɔ. Ɔ nʋn bɛ́ kɔ li ɛbɛlɛ kɔ yɔ ɛlɛ nnyuan kʋn, ɔ kɔ sɔnɩn menian. ");
INSERT INTO any_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Ɔ 'ba yɔ sɔ'n, anɩn Zʋan wɔ kulo'n mɔ bɛ fɛlɛ yɩ́ Ɛnʋn nɩn asʋ. Kulo sɔ'n mantan Salimʋn kulo'n. Ɛbɛlɛ lɩka'n tɩ asuma ngʋnmɩn. Menian dɔʋn kpa ba yɩ́ nwʋn ɛbɛlɛ maan ɔ sɔnɩn bɛ́. ");
INSERT INTO any_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Tɛmʋn sɔ nɩn anun, anɩn bɛ tʋlɩ man Zʋan fiadɩ. ");
INSERT INTO any_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Zufʋ'n-mɔ efian etue ebialɛ nɩn anwʋn, Zʋan menian'n-mɔ nʋn Zufʋ bian kʋn suli akpʋlʋwa kpili kpa. ");
INSERT INTO any_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Bɛ kɔ hɔ bɛ kɔ tʋ Zʋan, bɛ́ nwan: “*Labi, sʋanlan'n mɔ anɩn yɛ nʋn yɩ́ wɔ asue Zuludɩn nɩn anzin ɛlɔ mɔ ɛ hanlɩn yɩ́ ɛjɔlɛ'n, sian'n, ɔ lɛ sɔnɩn menian, bɛ́ kʋalaa bɛ́ nyɩn lɛ kaci yɩ́ nwʋn.” ");
INSERT INTO any_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Zʋan nwan: “Like mɔ Nyanmɩan a nva a mman man sʋanlan'n, sʋanlan ngʋala man kɛ ɔ nyan yɩ́ ɔ. ");
INSERT INTO any_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Ɛmɔ muonun di mɩ́n adanzɩɛ kɛ mɩ́n nwan nán *Kilisi'n y'ɔ le mɩ́n, nan mɩ́n dɩɛ, b'a sʋan mɩ́n maan m'an li mʋa yɩ́ nyunnun. ");
INSERT INTO any_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Yɩ́ ti, mɩ́n dɩɛ, sʋanlan'n m'ɔ lɛ ja bala'n, n dɩ kɛ yɩ́ manngʋn m'ɔ yɔ biala maan atɔnvɔlɛ'n yɔ kanlanman. Sɛ sʋanlan'n mɔ ɔ'a ja bala'n bɔ yɩ́ amannɩɛ kɛ ajaa nɩn a yɔ kpa a, yɩ́ manngʋn'n di yɩ́ nwʋn fɛ kpili kpa. Mɩ́n kʋsʋ mɩ́n fɛ dɩɛ m'ɔ kun mɩ́n'n, kɛ ɔ tɩ yɩ́ nɩn anɩn. ");
INSERT INTO any_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Ɛhɩ ati, ɔ di kɛ yɩ́ dunman'n fʋ́, nán mɩ́n dɩɛ'n hán asɩ.” ");
INSERT INTO any_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Ɔ tɩ ananhɔlɛ, sʋanlan m'ɔ fi nyanmɩansʋ'n, ɔ tɩ kpili tala menian'n-mɔ kʋalaatin. Sʋanlan m'ɔ fi asɩɛ nɩn asʋ ɛwa'n, anɩn ɔ tɩ asɩɛ nɩn asʋ sʋanlan, yɛ̂ asɩɛ nɩn asʋ ɛwa ɛjɔlɛ y'ɔ kan ɔ. Nan sʋanlan m'ɔ fi nyanmɩansʋ'n, ɔ tala kulo sʋanlan biala. ");
INSERT INTO any_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Like mɔ ɔ'a nwun yɩ́ nyanmɩansʋ nʋn mɔ ɔ'a tɩ'n, bɛ́ nwʋn ɛjɔlɛ y'ɔ kan ɔ. Yɛ̂ yɩ́ ɛjɔlɛ m'ɔ kan'n, sʋanlan fɩ́ɩ́ nne ndʋ man nun. ");
INSERT INTO any_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Nan sʋanlan m'ɔ kɔ le yɩ́ nʋan ɛjɔlɛ'n kɔ li'n, anɩn sʋanlan sɔ'n lɛ kele kɛ mɔ Nyanmɩan kan'n tɩ ananhɔlɛ sakpa. ");
INSERT INTO any_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Ɔ sanlɩn kɛ sʋanlan mɔ Nyanmɩan Kpili a sʋan yɩ́'n, Nyanmɩan Anʋan Ɛjɔlɛ y'ɔ kan ɔ. Afɩ Nyanmɩan a fa yɩ́ Wawɛ nɩn a wula yɩ́ nun kpa bɔkɔɔ. ");
INSERT INTO any_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Sɩɛ'n kulo Baa'n, ɔ'a fa ninnge kʋalaa ɔ'a wula yɩ́ sa nun. ");
INSERT INTO any_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Sʋanlan m'ɔ kɔ susu yɩ́ ti kɔ gua Baa sɔ nɩn asʋ'n, ɔ le nyanmɩansʋ ngʋan'n. Sʋanlan mɔ ɔ'a nzusu man yɩ́ ti ɔ'a gua man yɩ́ sʋ'n, ɔ nnyan man ngʋan sɔ'n bie. Nan Nyanmɩan sikpɛ'n wɔ yɩ́ sʋ dahuu. ");
INSERT INTO any_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Ɛhɩ, bɛ wɔ ɛbɛlɛ a, yɛ́ Mɩn kɔ nwun nun kɛ *Falisifʋɛ'n-mɔ a tɩ yɩ́ nwʋn ɛjɔlɛ kɛ ɔ lɛ sɔnɩn menian tala Zʋan. ");
INSERT INTO any_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Ɔ tɩ man kɛ yɩ́ Zozi muonun y'ɔ sɔnɩn menian'n-mɔ aho, nan yɩ́ menian'n-mɔ yɛ̂ bɛ di junman sɔ nɩn ɔ. ");
INSERT INTO any_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Mɔ Zozi tɩlɩ yɩ́ sɔ'n, ɔ fi Zude mân nɩn anun ɔ kɔ hɔ Galile mân nɩn anun ɛlɔ biekun. ");
INSERT INTO any_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Ɔ fi Zude mɔ ɔ 'kɔ Galile'n, ɔ di kɛ ɔ sɩn Samali mân nun. ");
INSERT INTO any_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Ɛhɩ a, ɔ kɔ hɔ dede ɔ kɔ ju Samali kulo'n mɔ bɛ fɛlɛ yɩ́ Sisaa'n tiba, ebo'n mɔ daba Zʋakɔbʋ falɩ manlɩn yɩ́ wa Zozɛfʋ nɩn asʋ. ");
INSERT INTO any_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Ebo sɔ nɩn asʋ yɛ̂ sikala'n mɔ Zʋakɔbʋ funlin'n wɔ ɔ. Zozi nanndɩlɩ dede m'ɔ juli ɛbɛlɛ'n, anɩn ɔ'a yue fɛ. Ɛhɩ, ɔ kɔ ha sikala nɩn anʋan kɔ tanlan. Yɩ́ tɛmʋn sɔ nɩn anun, anɩn sɛnzɛ nɩn a jinlan bɛ́ ti afian. ");
INSERT INTO any_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Zozi tɩ ɛbɛlɛ kaan, ɔ 'nɩan an, Samali balasua kʋn fi Sisaa kɔ a, ɔ lɛ ba a sa yɩ́ nzue. Zozi nwan: “Mɩ́n nianman bala, sa nzue kaan maan n nʋ́n.” ");
INSERT INTO any_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Ɔ 'ba yɔ sɔ'n kʋsʋ, anɩn Zozi menian'n-mɔ a hɔ kulo ɛlɔ, bɛ lɛ kɔ a to like bɛ 'ba li. ");
INSERT INTO any_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Ɛhɩ a, balasua'n nwan: “E! Anianman bian, ɛ tɩ Zufʋ, mɩ́n kʋsʋ n dɩ Samali balasua, nan ɔ yɔ sɛ mɔ ɛ lɛ sɛlɛ mɩ́n nzue'n?” M'ɔ man balasua'n lɛ kan sɔ'n, y'ɔ le kɛ Zufʋ'n-mɔ nʋn Samali menian'n-mɔ nni man. ");
INSERT INTO any_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Zozi nwan: “Sɛ ɔ tɩ kɛ ɛ sɩ like'n mɔ Nyanmɩan fa ce menian, ɛsɛ sɛ ɛ sɩ sʋanlan'n m'ɔ lɛ sɛlɛ wɔ́ nzue nɩn an, ahan wɔ́ lɩlɩ wɔ́ yɛ̂ ɛ 'sɛlɛ yɩ́ maan ɔ man wɔ́ ngʋan nzue fɛ m'ɔ nzɩsan man lé ɔ.” ");
INSERT INTO any_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Balasua'n tɩlɩ yɩ́ sɔ a, yɩ́ nwan: “Yɛmɩnlɩn, ɛ le man bokiti, yɛ̂ sikala ɛhɩ kʋsʋ abʋ hɔlɩ, anɩn ninhan yɛ̂ ɛ 'sa ngʋan nzue fɛ sɔ'n man mɩ́n ɔ? ");
INSERT INTO any_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Yɛ́ nan Zʋakɔbʋ falɩ sikala nzue kpa ɛhɩ manlɩn yɛ́ nán ɛnɛ bie ɔ. Yɩ́ bɔbɔ muonun, ɔ nʋn yɩ́ mma'n-mɔ, nʋn yɩ́ ayɛmʋa'n-mɔ bɛ nʋnlɩn nun nzue'n bie. Nan ɛ tɩ wɔ́ dɩɛ sɛ dede mɔ ɛ 'nyan nzue biekun kpa m'ɔ tala ɛhɩ asʋ man yɛ́ ɔ? Ɛ jʋnlɩn kɛ ɛ tɩ kpa tala Zʋakɔbʋ ɔ?” ");
INSERT INTO any_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Ɛhɩ a, Zozi nwan: “Sʋanlan m'ɔ nʋn nzue ɛhɩ'n, nzuhoe 'kun yɩ́ biekun. ");
INSERT INTO any_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Nan sʋanlan m'ɔ kɔ nʋn nzue'n mɔ n gɔ sa n gɔ man yɩ́'n, yɩ́ dɩɛ, nzuhoe ngun man yɩ́ lé. Ɔ sanlɩn kɛ nzue sɔ'n mɔ n gɔ sa n gɔ man ɔ kɔ nʋn'n, ɔ 'kaci asutile mɔ nyanmɩansʋ ngʋan'n fi nun fite ɔ.” ");
INSERT INTO any_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Ɛhɩ, Samali balasua'n manlɩn yɩ́ nʋan sʋ a, yɩ́ nwan: “Yɛmɩnlɩn, sɛ yɩ́ sɔ a, anɩn man mɩ́n bie n nʋ́n nán nzuhoe a ngun mɩ́n kʋ́n. Yɩ́ dɩɛ anɩn cɩan fʋfɔlɛ mɩn mma nza man nzue ɛwa kʋ́n.” ");
INSERT INTO any_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Zozi nwan: “Balasua, kɔ fɛlɛ wɔ́ hun, ɛ nʋn yɩ́ bɛ bála ɛwa.” ");
INSERT INTO any_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Zozi hanlɩn sɔ a, balasua'n nwan: “N nja man bian.” Ɛhɩ a, Zozi nwan: “Sɛ ɛ se kɛ ɛ ja man bian an, ɔ tɩ fɔ́ʋ́n. ");
INSERT INTO any_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Afɩ mɩ́n sɩ kɛ a ja mmelenzua ngʋkʋn nnun a yila, yɛ̂ nunhan'n kʋsʋ mɔ ɛ nʋn yɩ́ bɛ wɔ ɛbɛlɛ'n, ɔ jalɩ man wɔ́. Sakpa, a han ananhɔlɛ.” ");
INSERT INTO any_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Mɔ Zozi hanlɩn ɛhɩ'n, balasua'n nwan: “Yɛmɩnlɩn, m'an nwun kɛ ɛ tɩ Nyanmɩan kpɔmanfʋɛ sakpa. ");
INSERT INTO any_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Yɛ́ nan-mɔ sʋlɩ Nyanmɩan bʋka ɛhɩ asʋ, kʋsʋ ɛmɔ Zufʋ'n-mɔ dɩɛ, ɛmɔ nwan lɩka m'ɔ fata kɛ bɛ sʋ Nyanmɩan'n y'ɔ le Zoluzalɛmʋn.” ");
INSERT INTO any_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Zozi nwan: “Balasua, de di kɛ ɔ 'ba ju mɛlɛ bie, ɛmɔ ngɔ sʋ man Sɩɛ'n bʋka ɛhɩ asʋ kʋ́n, ɔ nʋn Zoluzalɛmʋn kʋsʋ kʋ́n. ");
INSERT INTO any_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Ɛmɔ Samali amma, ɛmɔ lɛ sʋ Nyanmɩan, kʋsʋ ɛmɔ nzɩ man yɩ́. Nan yɛ́ Zufʋ'n-mɔ, yɛ́ dɩɛ, yɛ sɩ yɩ́. Ɔ sanlɩn kɛ Nyanmɩan nanndɩ Zufʋ'n-mɔ asʋ yɛ̂ ɔ de eyuadɩ nɩn ati ngʋan ɔ. ");
INSERT INTO any_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Nwun yɩ́ kɛ mɛlɛ bie lɛ ba, mɛlɛ sɔ nɩn a ju a yue bɔbɔ, mɔ bɛ́ mɔ bɛ sʋ Sɩɛ'n kpa'n, bɛ 'sʋ yɩ́ wawɛ nun nʋn ananhɔlɛ nun. Ɔ sanlɩn kɛ sɔ menian'n-mɔ yɛ̂ Sɩɛ'n lɛ kpʋnndɛ ɔ. ");
INSERT INTO any_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Nyanmɩan Kpili tɩ wawɛ. Yɩ́ ti, bɛ́ mɔ bɛ sʋ yɩ́'n, ɔ fata kɛ bɛ sʋ yɩ́ wawɛ nun nʋn ananhɔlɛ nun.” ");
INSERT INTO any_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Zozi hanlɩn ɛhɩ a, balasua'n nwan: “Mɩ́n dɩɛ, mɩn sɩ kɛ *Mesi'n, (defʋɛ'n mɔ *gɛlɛkɩ anɩɛ nɩn anun bɛ fɛlɛ yɩ́ *Kilisi'n), ɔ 'ba a. Nan sɛ ɔ ba a, ɔ 'ba hehele yɛ́ ninnge'n kʋalaatin.” ");
INSERT INTO any_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Zozi nwan: “Kilisi'n y'ɔ le mɩ́n, mɩ́n mɔ mɩɩn kan ɛjɔlɛ'n mɩn kele wɔ́ ɛwa'n.” ");
INSERT INTO any_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Kɛ Zozi anʋan 'tɔ ala, yɩ́ menian'n-mɔ kɔ ju ɛbɛlɛ. Mɔ bɛ nwunlin kɛ ɔ nʋn balasua'n lɛ jʋjɔ'n, ɔ kɔ sin bɛ́ nwʋn kpa. Kʋsʋ bɛ́ bie fɩ́ɩ́ a ngʋala man yɩ́ bisa kɛ: “Ɛ 'se bala'n sɛ?” Anaan: “Nzu ɛjɔlɛ dɩɛ yɛ̂ ɛ lɛ kan kele yɩ́ ɔ?” ");
INSERT INTO any_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Ɛhɩ a, balasua'n kɔ yaci yɩ́ bua nɩn ɛbɛlɛ ɔ kɔ hɔ kulo. Ɔ kɔ hɔ kɔ bɔ kulo mma'n-mɔ amannɩɛ. ");
INSERT INTO any_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","Yɩ́ nwan: “Ebia-mɔ, ɛmɔ bála a nɩan, bian kʋn jin yɛ́ nan Zʋakɔbʋ sikala nɩn asʋ ɛlɔ. Ɔ'a han mɩ́n ninnge'n mɔ mɩn yɔ'n kʋalaa anwʋn ɛjɔlɛ ɔ'a hele mɩ́n. Asʋ bian sɔ'n, nán Kilisi nɩn ɔ?” ");
INSERT INTO any_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Ɛhɩ a, bɛ́ mɔ bɛ tɩlɩ ɛjɔlɛ sɔ'n kʋalaa, bɛ fi kulo ɛbɛlɛ bɛ kɔ kpʋ Zozi. ");
INSERT INTO any_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Ɔ 'ba yɔ sɔ'n kʋsʋ, mɔ bala'n hɔlɩ kulo ɔ 'kɔ a bɔ kpayɛ'n, Zozi menian'n-mɔ fɛlɛlɩ yɩ́ a, bɛ́ nwan: “*Labi, di like!” ");
INSERT INTO any_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Zozi nwan: “N ne mɩ́n alɩɛ kʋn mɔ mɩn di ɔ, alɩɛ sɔ'n, ɛmɔ nzɩ man yɩ́.” ");
INSERT INTO any_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Yɩ́ menian'n-mɔ tɩlɩ yɩ́ sɔ a, bɛ kɔ bisa bisa bɛ́ nwʋn kɛ: “Asʋ sʋanlan bie a bɛlɛ yɩ́ like a li ɔ?” ");
INSERT INTO any_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Ɛhɩ a, Zozi nwan: “Mɩ́n alɩɛ'n mɔ mɩn di'n y'ɔ le junman'n mɔ mɩ́n Sɩ sʋanlɩn mɩ́n kɛ m mála n ní'n. Ɔ tɩ kpa kɛ mɩn yɔ yɩ́ ehulo like, yɩ́ ti, junman'n m'ɔ falɩ manlɩn mɩ́n'n, ɔ fata kɛ mɩn di yɩ́ kʋalaa maan ɔ yue. ");
INSERT INTO any_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Ɛmɔ dɩɛ, ɛmɔ nwan bɛ gua bɛ́ ninnge nɩn an, ɔ di sala nnan nán b'a tɩ. Ɔ tɩ man sɔ? Nan mɩ́n dɩɛ, mɩɩn kan mɩn kele ɛmɔ kɛ ɛmɔ tʋ́ bɛ́ nyɩn bɛ nɩ́an ebo ɛhɩ-mɔ, sʋ ninnge'n-mɔ kʋalaa a tin, bɛ́ ɛtɩɛ a ju. ");
INSERT INTO any_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Sʋanlan'n m'ɔ lɛ tɩ ebo'n, b'a bɔ yɩ́ bʋ bɛ lɛ tua yɩ́ kalɛ dada angʋnmɩn. Ebo nɩn asʋ ninnge'n mɔ bɛ lɛ hohuan yɩ́ nʋan nán ɔ'a nzɛcɩ man'n, ɔ tɩ kɛ menian mɔ bɛ lɛ fɛlɛ bɛ́ maan bɛ nyan nyanmɩansʋ ngʋan m'ɔ le man ayuelɩɛ'n. Ɔ man sʋanlan'n m'ɔ yɔlɩ ebo'n, ɔ nʋn sʋanlan'n m'ɔ lɛ tɩ'n, bɛ́ munnyuan bɛ di fɛ kʋn. ");
INSERT INTO any_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Bɛ kan kɛ: ‘Sʋanlan kʋn yɔ ebo nán sʋanlan fʋfɔlɛ a tɩ.’ Ɛjɔlɛ sɔ'n, ɔ tɩ ananhɔlɛ. ");
INSERT INTO any_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Nan mɩ́n dɩɛ, mɩɩn kan mɩn kele ɛmɔ kɛ, nán ɛmɔ yɛ̂ b'a li ebo nɩn asʋ junman ɔ, menian nvʋfɔlɛ yɛ̂ b'a li sʋ junman ɔ. Nan m'an sʋan ɛmɔ kɛ ɛmɔ hɔ́ fá sʋ alɩɛ.” ");
INSERT INTO any_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Ɔ nʋn Zozi anʋan mɔ ɔ 'tɔ ala, Samali menian'n-mɔ kɔ fite fite ɛbɛlɛ. Kɛmɔ balasua'n hanlɩn kɛ Zozi a han yɩ́ ninnge'n m'ɔ yɔ'n kʋalaa anwʋn ɛjɔlɛ ɔ a hele yɩ́'n, ɔ man Samali kulo nɩn asʋ menian dɔʋn lelɩ Zozi lili. ");
INSERT INTO any_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Ɛhɩ ati, mɔ Samali menian'n-mɔ walɩ Zozi anwʋn ɛbɛlɛ'n, bɛ bʋtʋlɩ yɩ́ kɛ ɔ tánlan bɛ́ nwʋn ɛbɛlɛ kaan. Mɔ bɛ hanlɩn sɔ'n, Zozi nʋn bɛ́ ngɔ su yɩ́ nwʋn akpʋlʋwa, ɔ kɔ li ɛlɛ nnyuan bɛ́ nwʋn ɛbɛlɛ. ");
INSERT INTO any_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Ɔ fi ɛjɔlɛ'n mɔ yɩ́ muonun ɔ lɛ kan nɩn ati, ɔ man mmiekun-mɔ dɔʋn kɔ le yɩ́ kɔ li. ");
INSERT INTO any_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Mɔ bɛ tɩlɩ ɛjɔlɛ'n mɔ Zozi lɛ kan'n, bɛ kpɛlɩ bɛ́ nyɩn balasua nɩn anwʋn ɛlɔ a, bɛ́ nwan: “Sian dɩɛ, nán wɔ́ ɛjɔlɛ'n mɔ ɛ hanlɩn nɩn ati y'ɔ man y'a le y'a li ɔ, nan yɛ́ muonun y'a tɩ yɩ́ nʋan nun ɛjɔlɛ. Y'a nwun yɩ́ ananhɔlɛ kɛ ɔ tɩ mân'n Ngʋandefʋɛ sakpa.” ");
INSERT INTO any_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Ɛhɩ, Zozi kɔ li cɩan nnyuan Sisaa ɛbɛlɛ, ɔ kɔ tu yɩ́ bʋ kɔ hɔ Galile mân nun. ");
INSERT INTO any_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Zozi muonun fa kan kɛ, “Nyanmɩan *kpɔmanfʋɛ biala le man anyɩnnzɔ yɩ́ muonun yɩ́ kulo.” ");
INSERT INTO any_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Nan kʋsʋ, sian'n m'ɔ hɔlɩ juli Galile'n, ɛlɔ menian'n-mɔ sɔlɩ yɩ́ nun kanlanman. Ɔ sanlɩn kɛ mɔ bɛ 'di Zufʋ'n-mɔ fɛtɩ'n mɔ bɛ fɛlɛ yɩ́ *Pakɩ'n wɔ Zoluzalɛmʋn'n, bɛ́ mɔ bɛ hɔlɩ ɛlɔ'n, bɛ nwunlin ninnge'n kʋalaa mɔ Zozi yɔlɩ yɩ́ fɛtɩ nɩn anun'n. ");
INSERT INTO any_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Mɔ Zozi juli Galile mân nɩn anun'n, ɔ hɔlɩ Kana kulo nɩn asʋ ɛlɔ biekun, lɩka m'ɔ falɩ nzue kacili nzan'n. Ɔ 'ba yɔ sɔ'n, anɩn bian kʋn wɔ Kapɛɛnawɔmʋn kulo nɩn asʋ. Bian sɔ'n tɩ Galile mân nɩn asʋ belemgbin nɩn abɩlɩba kpili kʋn. Yɩ́ wa belenzua kʋn a fʋkɛ. ");
INSERT INTO any_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Mɔ abɩlɩba sɔ'n tɩlɩ kɛ Zozi fi Zude ɔ'a a Galile'n, ɔ kɔ a kɔ tʋ Zozi Kana ɛbɛlɛ. Ɔ kɔ sɛlɛ yɩ́ kɛ yɩ́ wa'n ka kaan wu, yɩ́ ti ɔ bála nán ɔ mán yɩ́ nwʋn sá. ");
INSERT INTO any_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","M'ɔ hanlɩn sɔ'n, Zozi nwan: “Ɛmɔ dɩɛ b'a nnwun man asinbɛnwʋn ninnge ɔ nʋn nzɔlɛ angʋnmɩn an, ɛmɔ nne nni man.” ");
INSERT INTO any_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Bian'n nwan: “Yɛ́ Mɩn ajo! Man yɛ hɔ́, sɛ a mma man an, mɩ́n wa'n 'ba wu.” ");
INSERT INTO any_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Ɛhɩ a, Zozi nwan: “Kɔ awulo! Nán wɔ́ wa nɩn anwʋn a sa.” Bian'n kɔ le Zozi anʋan ɛjɔlɛ sɔ'n m'ɔ hanlɩn'n kɔ li. Ɔ kɔ sa kɔ hɔ awulo. ");
INSERT INTO any_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Mɔ ɔ 'kɔ'n, ɔ nʋn yɩ́ ngʋa'n-mɔ kɔ yia. Bɛ́ nwan: “Yɛ́ mɩn, wɔ́ wa nɩn anwʋn a sa!” ");
INSERT INTO any_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Ɛjɔlɛ'n kɔ sin bian nɩn anwʋn, yɩ́ nwan: “E! Anɩn dɔɛ benin asʋ yɛ̂ yɩ́ nwʋn salɩ ɔ?” Ngʋa'n-mɔ nwan: “Anʋ́nman eyua kɔ yɔ dɔɛ kʋn yɛ̂ ebunnun'n fi yɩ́ nwʋn tuli ɔ.” ");
INSERT INTO any_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Ɛhɩ, bian'n nwunlin kɛ dɔɛ'n mɔ Zozi hanlɩn kɛ: “Kɔ awulo nán wɔ́ wa nɩn anwʋn a sa.” Dɔɛ sɔ nɩn asʋ yɛ̂ yɩ́ wa nɩn anwʋn salɩ ɔ. Ɔ fi mɛlɛ sɔ'n, ɔ nʋn yɩ́ awulo amma'n-mɔ kʋalaa bɛ kɔ le Zozi bɛ kɔ li. ");
INSERT INTO any_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Kɛ Zozi fi Zude mân nun ɔ salɩ walɩ Galile mân nun'n, yɩ́ kpɛ̂ nnyuan asʋ m'ɔ yɔ asinbɛnwʋn like m'ɔ tɩ nzɔlɛ nɩn anɩn. ");
INSERT INTO any_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Ɛhɩ anzin, cɩan kʋn anɩn Zufʋ'n-mɔ lɛ di bɛ́ fɛtɩ bie Zoluzalɛmʋn ɛlɔ. Zozi kɔ hɔ bie. ");
INSERT INTO any_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Zoluzalɛmʋn kulo'n, b'a le yɩ́ nwʋn. Yɩ́ nwʋn anʋan'n kʋn li Mmʋa Anʋan. Anɩn nzubula kʋn wɔ mmʋa anʋan sɔ nɩn anwʋn ɛbɛlɛ. Nzubula sɔ'n bɛ fɛlɛ yɩ́ *ebele anɩɛ nɩn anun Betesada. B'a sisi yɩ́ nwʋn abalanda nnun (m'ɔ tɔ sʋ nnun'n ce nzubula nɩn anun nnyuan). ");
INSERT INTO any_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Nwuluwafʋɛ dɔʋn kpa lɩla abalanda sɔ'n-mɔ anun. Anyɩnsinlinwafʋɛ, nʋn bɛ́ mɔ bɛ tia bɛ tɔ sʋ, nʋn bubuluwafʋɛ, bɛ́ kʋalaa bɛ lɩla ɛbɛlɛ. (Bɛ lɛ nwʋnndɛ kɛ nzubula'n bɔ́ mgbaha. ");
INSERT INTO any_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Ɔ sanlɩn kɛ ɔ ju mɛlɛ'n bie a, nyanmɩansʋ bɔfʋɛ kʋn ju nzue nɩn anun ɔ bɔ yɩ́ mgbaha. Sɛ ɔ yɔ sɔ a, wuluwafʋɛ m'ɔ kɔ li mʋa kɔ tɔ nun'n, anɩn yɩ́ nwʋn a sa.) ");
INSERT INTO any_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Nwuluwafʋɛ sɔ'n-mɔ anun kʋn wɔ ɛbɛlɛ, ewue a bɔ yɩ́ dede afʋɛ abulasan nʋn mɔcʋɛ. ");
INSERT INTO any_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Zozi nɩan yɩ́ nna m'ɔ la nɩn an, anɩn ɔ'a nwun kɛ ewue'n bɔlɩ yɩ́ nán ɛnɛ bie ɔ. Ɛhɩ a, ɔ kɔ bisa yɩ́ kɛ: “Ɛ kulo kɛ wɔ́ nwʋn sa ɔ?” ");
INSERT INTO any_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Wuluwafʋɛ'n nwan: “Yɛmɩnlɩn, mɩn kulo kɛ mɩ́n nwʋn sa o, nan kʋsʋ n ne man sʋanlan fɩ́ɩ́ mɔ sɛ nzue'n bɔ mgbaha a, ɔ fa mɩ́n tʋ nun ɔ. Ɔ nʋn mɔ mɩn 'yɔ dede mɩn 'kɔ a tɔ nun'n, anɩn sʋanlan fʋfɔlɛ a li mʋa a tɔ nun.” ");
INSERT INTO any_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Zozi nwan: “Jasʋ, fa wɔ́ ɛbɛɛ'n, nanndɩ kɔ.” ");
INSERT INTO any_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Ɛbɛlɛ ala, bian nɩn anwʋn kɔ sa. Ɔ nɩanlɩn ɛbɛlɛ ɔ falɩ yɩ́ ɛbɛɛ nɩn ala, ɔ lɛ nanndɩ kɔ. Zufʋ'n-mɔ *ɛnwʋnmɩan ele cɩan nɩn anun yɛ̂ Zozi yɔlɩ like sɔ nɩn ɔ. ");
INSERT INTO any_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","M'ɔ yɔlɩ sɔ'n, Zufʋ mgbain'n-mɔ kɔ han kɔ hele bian'n mɔ yɩ́ nwʋn a sa'n kɛ: “Ɛnɛ tɩ ɛnwʋnmɩan ele cɩan, mala'n ngele man kɛ ɛ sʋ́a wɔ́ ɛbɛɛ nɩn ɛnɛ. A tʋn mala.” ");
INSERT INTO any_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Bian'n nwan: “Sʋanlan'n mɔ ɔ'a man mɩ́n nwʋn a sa'n, yɩ́ nwan n jásʋ n vá mɩ́n ɛbɛɛ'n, n nánndɩ n gɔ́.” ");
INSERT INTO any_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Bɛ́ nwan: “Nwan yɛ̂ ɔ selɩ wɔ́ kɛ ɛ fá wɔ́ ɛbɛɛ'n ɛ nánndɩ'n?” ");
INSERT INTO any_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Bian'n nnwun man sʋanlan ɛhɔlɛ kʋn'n m'ɔ manlɩn yɩ́ nwʋn salɩ'n, ɔ sanlɩn kɛ menian sʋnlɩn ɛbɛlɛ nɩn ati, Zozi kɔ jasʋ ɛbɛlɛ. ");
INSERT INTO any_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Ɛhɩ anzin, Zozi nʋn yɩ́ kɔ yia Nyanmɩan awulo nɩn anun. Yɩ́ nwan: “Nɩan, sian dɩɛ, wɔ́ nwʋn a sa, yɩ́ ti n'ɛ yɔ ɛtɛ fɩ́ɩ́ kʋ́n nán munnzue m'ɔ tala ɛhɩnlɩnka a ndʋ man wɔ́.” ");
INSERT INTO any_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Mɔ Zozi hanlɩn sɔ'n, bian'n kɔ hɔ kɔ tʋ Zufʋ mgbain'n-mɔ ɔ kɔ han kɔ hele bɛ́ kɛ Zozi y'ɔ manlɩn yɩ́ nwʋn salɩ ɔ. ");
INSERT INTO any_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Ɔ fi mɛlɛ sɔ'n yɛ̂ Zufʋ mgbain'n-mɔ mantanlɩn Zozi ɛjɩjɩɛ ɔ. Ɔ sanlɩn kɛ ɛnwʋnmɩan ele cɩan yɛ̂ Zozi yɔ ninnge sɔ'n-mɔ ɔ. ");
INSERT INTO any_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Nan m'ɔ yɔlɩ sɔ'n, Zozi kɔ han kɔ hele bɛ́ kɛ: “Ɛnɛ nʋn ɛnɛ, mɩ́n Sɩ tɛ di junman, mɩ́n kʋsʋ, mɩ́n sa wɔ junman nwʋn.” ");
INSERT INTO any_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Ɛjɔlɛ kpɔlɛ kʋnmgba ɛhɩ m'ɔ hanlɩn nɩn ati, sian dɩɛ anɩn ehuan bɔbɔ yɛ̂ Zufʋ'n-mɔ kpʋnndɛ kɛ bɛ kun yɩ́ ɔ. Nán like'n mɔ ɔ'a yɔ yɩ́ ɛnwʋnmɩan ele cɩan kʋnmgba nɩn ala ati ɔ, nan ɛsɛ ɔ'a han kɛ yɩ́ Sɩ y'ɔ le Nyanmɩan. Anɩn ɔ tɩ kɛ ɔ lɛ kele yɩ́ nwʋn kɛ ɔ nʋn Nyanmɩan sɛ. ");
INSERT INTO any_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Zozi kɔ han kɔ hele Zufʋ mgbain'n-mɔ kɛ: “Mɩɩn kan yɩ́ ananhɔlɛ mɩn kele ɛmɔ kɛ Baa'n, ɔ mmɔ man yɩ́ ti anun ɔ nyɔ man like fɩ́ɩ́. Like m'ɔ kɔ nwun kɛ Sɩɛ'n lɛ yɔ'n, yɩ́ bie y'ɔ yɔ ɔ. Like biala mɔ Sɩɛ'n yɔ'n, Baa'n kʋsʋ yɔ bie. ");
INSERT INTO any_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Ɔ sanlɩn kɛ Sɩɛ'n kulo Baa'n yɛ̂ ɔ'a hele yɩ́ ninnge'n-mɔ kʋalaatin mɔ yɩ́ muonun ɔ yɔ'n. Sɩɛ'n 'ba fa ninnge mgbili mmiekun-mɔ mɔ bɛ tala ɛhɩka maan ɔ yɔ. Sian'n, ɔ 'ba sin ɛmɔ anwʋn. ");
INSERT INTO any_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Nan kɛ menian'n-mɔ wu a, Sɩɛ'n tinnge bɛ́ ɔ man bɛ nyan ngʋan'n, yɩ́ sɔ kʋsʋ ala, sʋanlan mɔ Baa'n kulo kɛ ɔ nyan ngʋan'n, ɔ 'nyan ngʋan. ");
INSERT INTO any_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Yɛ̂ Sɩɛ'n mmua man sʋanlan fɩ́ɩ́ ndɛɛ. Nan ɔ'a man Baa'n tunmin kɛ ɔ búa menian'n-mɔ ndɛɛ ");
INSERT INTO any_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","nán menian'n-mɔ kʋalaa anyɩn a sɔ Baa'n kɛ bɛ́ nyɩn sɔ Sɩɛ'n. Sʋanlan mɔ yɩ́ nyɩn nzɔ man Baa'n, anɩn yɩ́ nyɩn nzɔ man Sɩɛ'n m'ɔ sʋanlɩn Baa'n. ");
INSERT INTO any_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Mɩɩn kan yɩ́ ananhɔlɛ mɩn kele ɛmɔ kɛ sʋanlan biala m'ɔ tie mɩ́n ɛjɔlɛ'n mɔ ɛsɛ ɔ de sʋanlan'n mɔ ɔ'a sʋan mɩ́n'n di'n, sʋanlan sɔ'n, anɩn ɔ le nyanmɩansʋ ngʋan'n. Bɛ mmu man yɩ́ fʋɔ kʋ́n. Ɔ fi ewue nun ɔ'a fite ngʋan nun. ");
INSERT INTO any_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Mɩɩn kan yɩ́ ananhɔlɛ mɩn kele ɛmɔ kɛ mɛlɛ'n lɛ ba, mɛlɛ sɔ nɩn a ju bɔbɔ, mɔ bɛ́ mɔ b'a wu'n, bɛ 'ba tɩ Nyanmɩan Awa nɩn anɩn'n. Nan bɛ́ mɔ bɛ kɔ tɩ yɩ́ nɩn'n, bɛ 'nyan nyanmɩansʋ ngʋan'n. ");
INSERT INTO any_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Kɛmɔ Sɩɛ'n muonun tɩ ngʋan baka'n, ɔ'a man yɩ́ Wa'n kʋsʋ a kaci ngʋan baka. ");
INSERT INTO any_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Ɔ'a man Baa'n tunmin kɛ ɔ búa menian'n-mɔ ndɛɛ, ɔ sanlɩn kɛ ɔ tɩ *Mân Baa. ");
INSERT INTO any_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Nán bɛ man ɛhɩ sin bɛ́ nwʋn. Ɔ sanlɩn kɛ mɛlɛ'n lɛ ba mɔ bɛ́ mɔ b'a wu'n, bɛ 'ba tɩ yɩ́ nɩn'n bɛ fi bɛ́ sɛka'n-mɔ anun bɛ fite fite. ");
INSERT INTO any_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Bɛ́ mɔ bɛ bɔlɩ bala kpa'n, bɛ fi ewue nun bɛ 'tinnge bɛ nyan nyanmɩansʋ ngʋan m'ɔ le man ayuelɩɛ'n. Nan bɛ́ mɔ bɛ bɔlɩ bala ɛtɛ'n, bɛ fi ewue nun bɛ 'tinnge bɛ tua bɛ́ nyɔlɩɛ ɛtɛ nɩn anwʋn kalɛ. ");
INSERT INTO any_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Mɩn mmɔ man mɩ́n ti anun mɩn nyɔ man like fɩ́ɩ́, yɛ̂ mɩ́n ndɛɛ'n mɔ mɩn bua'n kʋsʋ, mɔ Nyanmɩan nwan m múa'n yɛ̂ mɩn 'bua ɔ. Mɩ́n ndɛɛ ebua'n tɩ fɔ́ʋ́n, ɔ sanlɩn kɛ mɩn mgbʋnndɛ man mɔ mɩ́n muonun mɩn kulo. Sʋanlan'n m'ɔ sʋanlɩn mɩ́n'n, m'ɔ kulo'n yɛ̂ mɩn yɔ ɔ. ");
INSERT INTO any_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“Sɛ ɔ tɩ kɛ mɩ́n ngʋnmɩn yɛ̂ mɩɩn di mɩ́n muonun mɩ́n nwʋn adanzɩɛ a, ahan mɔ mɩɩn kan'n, mɩn kʋala mɩn se kɛ nán bɛ bu yɩ́ ananhɔlɛ. ");
INSERT INTO any_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Nan sʋanlan fʋfɔlɛ y'ɔ di mɩ́n nwʋn adanzɩɛ ɔ. Yɛ̂ mɩn sɩ kɛ mɩ́n nwʋn ɛjɔlɛ'n m'ɔ hanlɩn'n tɩ ananhɔlɛ. ");
INSERT INTO any_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Ɛmɔ yɩlɩ menian bɛ hɔlɩ *Zʋan anwʋn ɛlɔ, yɩ́ kʋsʋ ɔ lili ananhɔlɛ nɩn anwʋn adanzɩɛ. ");
INSERT INTO any_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Mɩ́n dɩɛ, mɩn mgbʋnndɛ man kɛ sʋanlan lí mɩ́n nwʋn adanzɩɛ. Nan mɩɩn kan ninnge sɔ'n-mɔ anwʋn ɛjɔlɛ mɩn kele ɛmɔ maan ɛmɔ nyan ngʋan. ");
INSERT INTO any_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Anɩn Zʋan tɩ kɛ kanlannɩɛ mɔ b'a sɔ m'ɔ lɛ ta ɔ. Ɛmɔ hulolɩ kɛ bɛ 'tanlan yɩ́ jawe nɩn anun nán bɛ di fɛ mɛlɛ kaan. ");
INSERT INTO any_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Nan mɩ́n dɩɛ, n ne adanzɩɛ kʋn biekun m'ɔ tala mɔ Zʋan lili'n. Junman'n mɔ Sɩɛ nɩn a fa a man mɩ́n kɛ n ní mɔ mɩɩn di'n, junman sɔ'n bɔbɔ di mɩ́n adanzɩɛ kɛ Sɩɛ'n yɛ̂ ɔ'a sʋan mɩ́n ɔ. ");
INSERT INTO any_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Yɛ̂ Sɩɛ'n kʋsʋ mɔ ɔ'a sʋan mɩ́n'n, ɔ di mɩ́n nwʋn adanzɩɛ. Ɛmɔ tɩlɩ man yɩ́ nɩn'n lé, ɛsɛ ɛmɔ nwunlin man yɩ́ nwʋn lé. ");
INSERT INTO any_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Kɛmɔ ɛmɔ nne man sʋanlan'n mɔ Sɩɛ'n sʋanlɩn yɩ́'n nni man'n, ɔ man ɛmɔ nva man yɩ́ ɛjɔlɛ'n bɛ nzie man. ");
INSERT INTO any_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Ɛmɔ suan Nyanmɩan *Ɛhɛlɛ Ɛjɔlɛ'n sɛlɛ, afɩ ɛmɔ jʋnlɩn kɛ nun yɛ̂ ɛmɔ 'nyan nyanmɩansʋ ngʋan nɩn ɔ. Ɔ tɩ ananhɔlɛ. Ɛhɛlɛ Ɛjɔlɛ'n kʋsʋ, mɩ́n nwʋn ɛjɔlɛ y'ɔ kan ɔ. ");
INSERT INTO any_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Nan kʋsʋ ɛmɔ ngulo man kɛ bɛ ba mɩ́n nwʋn nán bɛ nyan ngʋan. ");
INSERT INTO any_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Mɩn mgbʋnndɛ man kɛ sʋanlan bɔ́ mɩ́n dunman kpa. ");
INSERT INTO any_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Afɩ mɩn sɩ ɛmɔ, mɩn sɩ kɛ ɛmɔ ngulo man Nyanmɩan. ");
INSERT INTO any_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Mɩ́n Sɩ yɛ̂ ɔ'a sʋan mɩ́n maan m'an a ɔ. Kʋsʋ ɛmɔ ngulo man kɛ bɛ de mɩ́n. Nan kʋsʋ sɛ sʋanlan bie bɔ yɩ́ ti anun ba a, yɩ́ dɩɛ ɛmɔ de yɩ́. ");
INSERT INTO any_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Ɛmɔ ngulo man kɛ Nyanmɩan angʋnmɩn cein yɩ́ ɛmɔ ayɛ. Nan ɛmɔ kulo kɛ ɛmɔ muonun yɩ bɛ́ nwʋn ayɛ. Ɔ 'yɔ sɛ nán ɛmɔ a le mɩ́n a li? ");
INSERT INTO any_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Nan kʋsʋ, ɛmɔ nán bɛ jʋnlɩn kɛ mɩn 'ba bu ɛmɔ fʋɔ wɔ mɩ́n Sɩ anyunnun. Nan *Moyizɩ mɔ ɛmɔ a susu bɛ ti b'a gua yɩ́ sʋ'n, yɩ́ yɛ̂ ɔ 'bu ɛmɔ fʋɔ ɔ. ");
INSERT INTO any_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Afɩ sɛ ɔ tɩ kɛ ɛmɔ lelɩ *Moyizɩ lili sakpa a, ahan ɛmɔ 'de mɩ́n kʋsʋ bɛ di. Ɔ sanlɩn kɛ mɩ́n nwʋn ɛjɔlɛ yɛ̂ *Moyizɩ hɛlɛlɩ ɔ. ");
INSERT INTO any_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Nan sɛ ɛmɔ nne man ɛjɔlɛ'n mɔ Moyizɩ a hɛlɛ'n nni man an, ɔ 'yɔ sɛ nán ɛmɔ a le mɩ́n ɛjɔlɛ nɩn a li?” ");
INSERT INTO any_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Ɛhɩ anzin, Zozi kɔ sa kɔ hɔ Galile mân nɩn anun ɛlɔ. Cɩan kʋn ɔ kɔ kpɛ Galile asue kpili'n mɔ bɛ fɛlɛ yɩ́ biekun kɛ *Tibeliadɩ'n, ɔ kɔ hɔ yɩ́ nzin ɛlɔ. ");
INSERT INTO any_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Menian dɔʋn kpa kɔ si yɩ́ sʋ, ɔ sanlɩn kɛ bɛ nwunlin asinbɛnwʋn ninnge m'ɔ yɔlɩ manlɩn nwuluwafʋɛ'n-mɔ anwʋn salɩ'n. ");
INSERT INTO any_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Zozi nʋn yɩ́ menian'n-mɔ kɔ fʋ kɔ tanlan bʋka kʋn asʋ. ");
INSERT INTO any_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Ɔ 'ba yɔ sɔ'n, anɩn Zufʋ'n-mɔ *Pakɩ elie'n ka kaan ju biekun. ");
INSERT INTO any_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Ɛhɩ a, bɛ tɩ ɛbɛlɛ kaan mɔ ɔ 'kɔ bie'n, Zozi 'tʋ yɩ́ nyɩn nɩan an, menian dɔʋn kpa lɛ ba yɩ́ nwʋn, nán ɔ'a bisa Filipʋ kɛ: “Filipʋ, ninhan yɛ̂ yɛ 'nyan like yɛ to yɛ man menian nwala ɛhɩ di ɔ?” ");
INSERT INTO any_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Ɔ 'kan sɔ nán ɔ nɩan mɔ Filipʋ 'ba bua'n. Ɔ sanlɩn kɛ yɩ́ muonun ɔ sɩ like mɔ ɔ 'ba yɔ ɔ. ");
INSERT INTO any_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Filipʋ nwan: “Sɛ bɔbɔ yɛ fa jɛtɛ fufue mma ɛya nnyuan yɛ to kpaʋn an, ɔ nza man fɩ́ɩ́ mɔ bɛ́ nun kʋn biala nyan sin kaan sʋa di ɔ.” ");
INSERT INTO any_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","M'ɔ Filipʋ anʋan tɔlɩ'n, Zozi menian'n-mɔ anun kʋn, bɛ fɛlɛ yɩ́ Andele m'ɔ tɩ Simʋn Pɩɛlɩ anianman'n nwan: ");
INSERT INTO any_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Kpafɛlɛ kaan kʋn wɔ ɛwa, ɔ le *ɔlɩzʋ kpaʋn nnun nʋn ejue nnyuan. Nan kʋsʋ menian nwala ɛhɩ, nzukɛ yɛ̂ ɔ 'sa yɩ́ yɔ ɔ?” ");
INSERT INTO any_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Zozi nwan: “Ɛmɔ mán menian'n-mɔ kʋalaa tɛ́tanlan asɩ.” Lɩka sɔ'n tɩ tɛtɛlɛ kpa, ndile dɔʋn kʋsʋ wɔ ɛbɛlɛ. Mɔ Zozi hanlɩn sɔ'n, bɛ́ kʋalaa bɛ kɔ tɛtanlan asɩ. Bɛ́ mɔ bɛ walɩ ɛbɛlɛ'n, mmelenzua mɔ bɛ wɔ bɛ́ nun'n, bɛ ju kɔ yɔ akpɩɩ nnun. ");
INSERT INTO any_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Zozi kɔ fa kpaʋn nnun'n ɔ kɔ la Nyanmɩan asɩ ɔ kɔ hye kɔ man bɛ́. Ɛsɛ ɔ kɔ fa ejue nnyuan'n ɔ kɔ la Nyanmɩan asɩ biekun ɔ kɔ hye kɔ man bɛ́. Sʋanlan kʋn biala nyanlɩn mɔ yɩ́ kunnun jɔ yɩ́ nwʋn ɔ lili. ");
INSERT INTO any_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Mɔ bɛ́ kʋalaa bɛ yuelɩ didi'n, Zozi kɔ han kɔ hele yɩ́ menian'n-mɔ kɛ: “Ɛmɔ sɩ́sa yɩ́ bʋ'n mɔ ɔ'a ha'n, nán bɛ ju fɩ́ɩ́ bɛ tʋ.” ");
INSERT INTO any_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Ɔlɩzʋ kpaʋn nnun'n, bɛ lili dede m'ɔ halɩ yɩ́ bʋ mɔ Zozi menian'n-mɔ sɩsalɩ'n, ɔ tɩ ece mma bulu nʋn nnyuan. ");
INSERT INTO any_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Mɔ menian'n-mɔ nwunlin asinbɛnwʋn like'n mɔ Zozi yɔlɩ'n, bɛ́ nwan: “Nyanmɩan *kpɔmanfʋɛ'n mɔ bɛ kan kɛ ɔ lɛ ba'n, sakpa, yɩ́ y'ɔ le bian ɛhɩka.” ");
INSERT INTO any_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Mɔ Zozi nwunlin kɛ bɛ 'kpʋnndɛ bɛ fa yɩ́ bɛ sie bɛ́ belemgbin'n, yɩ́ ngʋnmɩn ɔ tɩlɩ yɩ́ nwʋn ɔ hɔlɩ bʋka nɩn asʋ ɛlɔ biekun. ");
INSERT INTO any_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Mɔ alɩ́ɛ'n tɔlɩ nun'n, Zozi menian'n-mɔ hɔlɩ asue nɩn anʋan ɛlɔ. ");
INSERT INTO any_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Bɛ kɔ fʋ ɛlɛɛ kʋn anun bɛ lɛ kpɛ asue'n bɛ kɔ Kapɛɛnawɔmʋn kulo nɩn asʋ. Ɔ 'ba yɔ sɔ'n, anɩn alɩ́ɛ nɩn a muan sʋ a yue, kʋsʋ Zozi a mma ndʋ man bɛ́. ");
INSERT INTO any_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Anɩn asutue kʋsʋ lɛ tu sɛlɛ kpa. ");
INSERT INTO any_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Bɛ hanlɩn ɛlɛɛ'n bɛ hɔlɩ dede kɔ yɔ cilo nnun anaan nsian'n, anɩn Zozi nanndɩ asue nɩn anyɩnsʋ ɔ lɛ ba bɛ́ nwʋn ɛbɛlɛ. Ɛbɛlɛ ala, esulo kɔ han bɛ́, bɛ jʋnlɩn kɛ like bie ɔ. ");
INSERT INTO any_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Nan m'ɔ walɩ dede m'ɔ ka kaan tʋ bɛ́'n, yɩ́ nwan: “Mɩ́n ɔ, nán bɛ sulo.” ");
INSERT INTO any_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Sian'n m'ɔ hanlɩn sɔ'n, anɩn bɛ kulo kɛ bɛ fa yɩ́ ɛlɛɛ nɩn anun. Ɛbɛlɛ ala, bɛ kɔ si asɩ, bɛ kɔ ju lɩka mɔ bɛ lɛ kɔ'n. ");
INSERT INTO any_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Ɛhɩ, meninsʋnman'n mɔ bɛ halɩ asue nɩn anzin ɛlɔ'n nwunlin kɛ mɛlɛ mɔ Zozi menian'n-mɔ 'kpɛ asue'n, anɩn ɛlɛɛ kʋnmgba cein yɛ̂ ɔ si ɛbɛlɛ ɔ. Bɛ sɩ kɛ Zozi a nvʋ man nun bie, yɩ́ menian'n-mɔ angʋnmɩn ala yɛ̂ bɛ fʋlɩ nun bɛ hɔlɩ ɔ. Kʋsʋ mɔ alɩ́ɛ hɩnlɩn'n, meninsʋnman'n 'ba ju a, anɩn Zozi nnʋn man ɛbɛlɛ. ");
INSERT INTO any_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Ɛlɛɛ mmie-mɔ kʋsʋ fi Tibeliadɩ kulo nɩn asʋ, bɛ kɔ a kɔ sisi m'ɔ mantan lɩka mɔ yɛ́ Mɩn lalɩ Nyanmɩan asɩ, ɔ falɩ kpaʋn'n manlɩn meninsʋnman'n lili'n. ");
INSERT INTO any_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Nan mɔ meninsʋnman'n nwunlin kɛ Zozi nʋn yɩ́ menian'n-mɔ nnʋn man ɛbɛlɛ'n, bɛ́ kʋsʋ bɛ kɔ fa ɛlɛɛ sɔ'n-mɔ bɛ kɔ hɔ Zozi ɛkpʋnndɛ Kapɛɛnawɔmʋn. ");
INSERT INTO any_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Menian'n-mɔ kɔ hɔ kɔ tʋ Zozi asue nɩn ebue kʋn ɛlɔ Kapɛɛnawɔmʋn kulo nɩn asʋ, bɛ́ nwan: “Labi, ɛ juli ɛwa cɩan benin?” ");
INSERT INTO any_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Zozi nwan: “Mɩɩn kan yɩ́ ananhɔlɛ mɩn kele ɛmɔ kɛ nán kɛ asinbɛnwʋn ninnge'n mɔ ɛmɔ tɩ yɩ́ bʋ nɩn ati yɛ̂ ɛmɔ lɛ kpʋnndɛ mɩ́n ɔ. Nan kpaʋn'n mɔ ɛmɔ a li dede bɛ́ kʋ a yi'n, yɩ́ ti yɛ̂ ɛmɔ lɛ kpʋnndɛ mɩ́n ɔ. ");
INSERT INTO any_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Alɩɛ'n m'ɔ sɛcɩ'n, ɛmɔ nán bɛ di yɩ́ nwʋn junman. Nan ɛmɔ lí alɩɛ'n m'ɔ man bɛ nyan ngʋan m'ɔ le man ayuelɩɛ nɩn anwʋn junman. Alɩɛ sɔ'n, *Mân Baa'n yɛ̂ ɔ fa man ɔ. Yɩ́ yɛ̂ Sɩɛ Nyanmɩan Kpili a man yɩ́ atɩn kɛ ɔ fá alɩɛ sɔ'n mán mân nɩn ɔ.” ");
INSERT INTO any_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Bɛ́ nwan: “Nzu yɛ̂ yɛ 'yɔ nán y'a li junman mɔ Nyanmɩan kulo ɔ?” ");
INSERT INTO any_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Zozi nwan: “Junman'n mɔ Nyanmɩan kulo kɛ ɛmɔ di'n y'ɔ le kɛ ɛmɔ lé sʋanlan'n mɔ ɔ'a sʋan yɩ́'n bɛ lí.” ");
INSERT INTO any_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Bɛ́ nwan: “Nzukɛ asinbɛnwʋn like dɩɛ yɛ̂ ɛ 'yɔ maan yɛ nwun yɩ́ nán y'a le wɔ́ y'a li ɔ? Nzu junman dɩɛ yɛ̂ ɛ kʋala yɩ́ di ɔ? ");
INSERT INTO any_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Daba, ɛwâ nɩn anun ɛlɔ, yɛ́ nannan-mɔ lili *mannan kɛ Ɛhɛlɛ Ɛjɔlɛ'n kan yɩ́'n. Yɩ́ nwan: Ɔ'a man bɛ́ nyanmɩansʋ kpaʋn b'a li.” ");
INSERT INTO any_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Zozi nwan: “Mɩɩn kan yɩ́ ananhɔlɛ mɩn kele ɛmɔ kɛ, kpaʋn'n mɔ *Moyizɩ falɩ manlɩn ɛmɔ anan-mɔ'n, nán nyanmɩansʋ kpaʋn kpa nɩn ɔ. Nan nyanmɩansʋ kpaʋn kpa'n y'ɔ le mɔ mɩ́n Sɩ lɛ fa man ɛmɔ'n. ");
INSERT INTO any_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Ɔ sanlɩn kɛ, kpaʋn kpa'n mɔ Nyanmɩan fa man menian'n-mɔ'n y'ɔ le sʋanlan'n m'ɔ fi nyanmɩansʋ ɔ'a ju asɩ m'ɔ man mân'n nyan ngʋan'n.” ");
INSERT INTO any_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Ɛhɩ a, bɛ́ nwan: “Yɛmɩnlɩn, anɩn fa kpaʋn sɔ'n bie man yɛ́ cɩan daa e.” ");
INSERT INTO any_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Zozi nwan: “Kpaʋn'n m'ɔ man bɛ nyan nyanmɩansʋ ngʋan'n y'ɔ le mɩ́n. Sʋanlan biala m'ɔ kɔ a mɩ́n nwʋn'n, ɛhɔɛ ngun man yɩ́ lé. Yɛ̂ sʋanlan biala m'ɔ kɔ le mɩ́n kɔ li'n, nzuhoe ngun man yɩ́ lé. ");
INSERT INTO any_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Nan m'an han m'an hele ɛmɔ, ɛmɔ a nwun mɩ́n, kʋsʋ afɩ ɛmɔ nne man mɩ́n nni man. ");
INSERT INTO any_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Sʋanlan biala mɔ Sɩɛ'n kɔ fa yɩ́ kɔ man mɩ́n'n, ɔ 'ba mɩ́n nwʋn. Yɛ̂ sʋanlan biala m'ɔ kɔ a mɩ́n nwʋn'n, cɩan bie lé, mɩn nyɩ man yɩ́. ");
INSERT INTO any_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Ɔ sanlɩn kɛ n vi nyanmɩansʋ m'an mma man kɛ mɩn 'ba yɔ like mɔ mɩn kulo ɔ. Nan m malɩ kɛ mɩn 'ba yɔ like mɔ sʋanlan'n mɔ ɔ'a sʋan mɩ́n'n kulo'n. ");
INSERT INTO any_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Like mɔ sʋanlan'n mɔ ɔ'a sʋan mɩ́n'n kulo'n y'ɔ le kɛ bɛ́ mɔ ɔ'a fa bɛ́ ɔ'a man mɩ́n'n fɩ́ɩ́ n'ɔ minlin mɩ́n sa nun. Nan cɩan m'ɔ li sian nɩn anun, n dínnge bɛ́ fi ewue nun maan bɛ nyan nyanmɩansʋ ngʋan m'ɔ le man ayuelɩɛ'n. ");
INSERT INTO any_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Like mɔ Sɩɛ'n kulo'n y'ɔ le kɛ bɛ́ kʋalaa mɔ bɛ kɔ nwun Baa'n mɔ bɛ kɔ le yɩ́ bɛ kɔ li'n, bɛ nyán nyanmɩansʋ ngʋan'n. Ɛsɛ cɩan m'ɔ li sian nɩn anun, n dínnge bɛ́ maan bɛ fi ewue nun bɛ jásʋ.” ");
INSERT INTO any_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Mɔ Zozi hanlɩn sɔ yuelɩ'n, Zufʋ'n-mɔ kɔ fɛ yɩ́ nwʋn ɛya, bɛ lɛ jʋjɔ yɩ́ bɛ́ konvin abʋ kɛ yɩ́ nwan: “Kpaʋn'n m'ɔ fi nyanmɩansʋ'n y'ɔ le mɩ́n”. ");
INSERT INTO any_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Bɛ́ nwan: “Zozi sɔ'n muonun, nán Zozɛfʋ awa dɩɛ nɩn ɔ? Yɛ sɩ yɩ́ sɩ nʋn yɩ́ nin. Yɛ̂ ɔ yɔ sɛ m'ɔ kan kɛ ɔ fi nyanmɩansʋ yɛ̂ ɔ'a ju ɔ?” ");
INSERT INTO any_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Zozi nwan: “Ɛmɔ yáci bɛ́ konvin abʋ ɛjʋjɔlɛ'n. ");
INSERT INTO any_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Sɛ ɛmɔ nwun kɛ sʋanlan kʋn lɛ ba mɩ́n nwʋn an, anɩn Sɩɛ'n mɔ ɔ'a sʋan mɩ́n'n y'ɔ nʋn yɩ́ a a ɔ. Mɩ́n kʋsʋ cɩan m'ɔ li sian nɩn anun, mɩn 'tinnge yɩ́ maan ɔ fi ewue nun jasʋ. ");
INSERT INTO any_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Afɩ b'a hɛlɛ wɔ Nyanmɩan mgbɔmanfʋɛ'n-mɔ kalata nɩn anun kɛ: Nyanmɩan 'ba hehele menian'n-mɔ kʋalaa ninnge. Yɩ́ sɔ ati, sʋanlan biala m'ɔ kɔ tie Sɩɛ'n kɔ fa yɩ́ atɩn dɩɛ nɩn asʋ'n, ɔ 'ba mɩ́n nwʋn. ");
INSERT INTO any_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Nán kɛ sʋanlan bie a nwun Sɩɛ'n lé ti ɔ, nan sʋanlan'n m'ɔ fi Nyanmɩan anwʋn ɛlɔ ɔ'a ju'n, yɩ́ ngʋnmɩn ala yɛ̂ ɔ'a nwun Sɩɛ nɩn ɔ. ");
INSERT INTO any_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Mɩɩn kan yɩ́ ananhɔlɛ mɩn kele ɛmɔ kɛ sʋanlan biala m'ɔ kɔ le mɩ́n kɔ li'n, ɔ 'nyan ngʋan m'ɔ le man ayuelɩɛ'n. ");
INSERT INTO any_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Ɔ sanlɩn kɛ alɩɛ mɔ bɛ di a, bɛ nyan ngʋan'n y'ɔ le mɩ́n. ");
INSERT INTO any_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Kɛ ɛmɔ anan-mɔ lili mannan nɩn ɛwâ nɩn asʋ ɛlɔ'n, anun bɛ halɩ ɛbɛlɛ ɔ? Ɔ yɔlɩ dede bɛ́ kʋalaa bɛ yuelɩ wu. ");
INSERT INTO any_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Nan kpaʋn'n m'ɔ fi nyanmɩansʋ'n dɩɛ, sʋanlan m'ɔ kɔ li bie'n, ɔ nwu man lé. ");
INSERT INTO any_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Ngʋan kpaʋn kpa'n m'ɔ fi nyanmɩansʋ'n y'ɔ le mɩ́n. Sʋanlan m'ɔ kɔ li kpaʋn sɔ'n bie'n, ɔ le ngʋan cɩan daa. Kpaʋn'n mɔ mɩn 'fa mɩn man'n y'ɔ le mɩ́n nwʋnnaan'n. Mɩn 'fa mɩn man maan mân nɩn anun menian'n-mɔ nyan ngʋan.” ");
INSERT INTO any_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Ɛjɔlɛ sɔ'n m'ɔ hanlɩn nɩn anwʋn, Zufʋ'n-mɔ kɔ su akpʋlʋwa kpili kpa bɛ́ afian ɛlɔ, bɛ́ nwan: “Nan sʋanlan ɛhɩ muonun, ɔ 'yɔ sɛ nán ɔ'a fa yɩ́ nwʋnnaan'n ɔ'a man y'a li?” ");
INSERT INTO any_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Zozi nwan: “Mɩɩn kan yɩ́ ananhɔlɛ mɩn kele ɛmɔ kɛ sɛ ɛmɔ a nni man *Mân Baa nɩn anwʋnnaan'n, ɛsɛ sɛ ɛmɔ a nnʋn man yɩ́ moja nɩn an, anɩn ɛmɔ le man ngʋan. ");
INSERT INTO any_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Sʋanlan m'ɔ kɔ li mɩ́n nwʋnnaan'n, m'ɔ kɔ nʋn mɩ́n moja'n, ɔ le nyanmɩansʋ ngʋan m'ɔ le man ayuelɩɛ'n, ɛsɛ cɩan m'ɔ li sian nɩn anun, mɩn 'tinnge yɩ́ maan ɔ fi ewue nun ɔ jasʋ. ");
INSERT INTO any_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Afɩ ɛmɔ nwún yɩ́ kɛ, alɩɛ kpa'n y'ɔ le mɩ́n nwʋnnaan'n yɛ̂ nzan kpa'n y'ɔ le mɩ́n moja'n. ");
INSERT INTO any_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Sʋanlan m'ɔ kɔ li mɩ́n nwʋnnaan'n, mɔ ɛsɛ ɔ kɔ nʋn mɩ́n moja'n, anɩn ɔ nʋn mɩ́n tɩ, mɩ́n kʋsʋ, mɩn nʋn yɩ́ tɩ. ");
INSERT INTO any_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Kɛmɔ Sɩɛ'n mɔ ɔ'a sʋan mɩ́n'n tɩ asɩ mɔ yɩ́ dunman nun yɛ̂ mɩ́n kʋsʋ n dɩ asɩ'n, yɩ́ sɔ kʋsʋ ala, sʋanlan m'ɔ kɔ li mɩ́n nwʋnnaan'n, mɩ́n dunman nun, ɔ 'nyan ngʋan. ");
INSERT INTO any_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Kpaʋn'n m'ɔ fi nyanmɩansʋ'n, kɛ ɔ tɩ yɩ́ nɩn anɩn. Ɔ tɩ man kɛ mɔ ɛmɔ anan-mɔ lili bɛ wuli'n. Sʋanlan m'ɔ kɔ li kpaʋn sɔ'n, ɔ 'nyan ngʋan ɔ tanlan asɩ dahuu.” ");
INSERT INTO any_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Tɛmʋn mɔ Zozi 'kan ɛjɔlɛ ɛhɩ-mɔ ɔ kekele menian'n-mɔ ninnge'n, anɩn ɔ wɔ Kapɛɛnawɔmʋn, Zufʋ'n-mɔ asɔnɩn sua nɩn anun. ");
INSERT INTO any_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Mɔ Zozi menian'n-mɔ dɔʋn tɩlɩ yɩ́ ɛjɔlɛ'n m'ɔ hanlɩn'n, bɛ́ nwan: “Hei! Ɛjɔlɛ ɛhɩ dɩɛ ɔ yɔ sɩ o! Nwan sʋanlan dɩɛ yɛ̂ ɔ kʋala sʋ di ɔ?” ");
INSERT INTO any_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Mɔ Zozi nwunlin kɛ ɛhɩ anwʋn yɛ̂ yɩ́ menian'n-mɔ lɛ jʋjɔ bɛ́ konvin abʋ'n, yɩ́ nwan: “Yɩ́ ti, ɛhɩ yɔ sɩ man ɛmɔ ɔ? ");
INSERT INTO any_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Nan anɩn sɛ cɩan bie ɛmɔ nwun kɛ *Mân Baa'n lɛ fʋ kɔ lɩka m'ɔ fi walɩ nɩn an, yɩ́ dɩɛ, ɛmɔ 'yɔ bɛ́ nwʋn sɛ? ");
INSERT INTO any_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Nyanmɩan Wawɛ'n yɛ̂ ɔ man bɛ nyan ngʋan ɔ. Anwʋnnaan'n tɩ man like fɩ́ɩ́. Ɛjɔlɛ'n mɔ m'an han m'an hele ɛmɔ'n, ɔ kele kɛ bɛ kpɩn bɛ nyan Nyanmɩan Wawɛ'n ɔ nʋn nyanmɩansʋ ngʋan'n. ");
INSERT INTO any_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Nan kʋsʋ ɛmɔ anun mmie-mɔ nne nni man.” Zozi hanlɩn kɛ menian'n mmie-mɔ nne nni man, ɔ sanlɩn kɛ mɔ ɔ 'bɔ yɩ́ junman nɩn abʋ'n, ɔ sɩ menian mɔ bɛ nne bɛ nni man'n, ɛsɛ ɔ sɩ sʋanlan'n mɔ ɔ 'kpɛ yɩ́ nwʋn atɩn maan bɛ cɩ yɩ́'n. ");
INSERT INTO any_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Mɔ Zozi hanlɩn sɔ yuelɩ'n, ɛsɛ yɩ́ nwan: “Ɛhɩka ati, sʋanlan biala mɔ mɩ́n Sɩ a nyɩ man yɩ́ kɛ ɔ bála mɩ́n nwʋn'n, ɔ ngʋala man mɩ́n nwʋn ba.” ");
INSERT INTO any_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Ɔ fi ɛbɛlɛ, yɩ́ menian'n mmie-mɔ dɔʋn yacili yɩ́ tʋlɩ, b'a nzi man yɩ́ sʋ kʋ́n. ");
INSERT INTO any_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","M'ɔ yɔlɩ sɔ'n, nán Zozi a bisa yɩ́ menian bulu nʋn nnyuan'n kɛ: “Nan ɛmɔ lɩlɩ, ɛmɔ dɩɛ bɛ ngɔ man?” ");
INSERT INTO any_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Kɛ Zozi anʋan 'tɔ ala, Simʋn Pɩɛlɩ kukuli yɩ́ nʋan sʋ a, yɩ́ nwan: “Yɛ́ Mɩn, anɩn nwan sʋanlan dɩɛ anwʋn yɛ̂ yɛ 'kɔ ɔ? Wɔ́ yɛ̂ wɔ́ nʋan ɛjɔlɛ'n man bɛ nyan nyanmɩansʋ ngʋan m'ɔ le man ayuelɩɛ nɩn ɔ. ");
INSERT INTO any_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Yɛ́ dɩɛ yɛ de wɔ́ yɛ di, ɛsɛ y'a nwun kɛ Sʋanlan Nwannzan-nwannzan'n mɔ Nyanmɩan a sʋan yɩ́'n y'ɔ le wɔ́.” ");
INSERT INTO any_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Mɔ Simʋn Pɩɛlɩ hanlɩn sɔ yuelɩ'n, Zozi nwan: “Ɛmɔ menian bulu nʋn nnyuan'n, asʋ nán mɩ́n yɛ̂ n vɛlɛlɩ ɛmɔ ɔ? Nan kʋsʋ ɛmɔ anun kʋn tɩ busuɔfʋɛ.” ");
INSERT INTO any_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Sʋanlan sɔ'n mɔ Zozi lɛ kan yɩ́ ɛjɔlɛ'n y'ɔ le Simʋn Isikaliɔtɩ awa Zudasɩ mɔ cɩan bie ɔ 'yɩ Zozi man'n. Zudasɩ sɔ'n tɩ Zozi menian bulu nʋn nnyuan nɩn anun kʋn. ");
INSERT INTO any_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Ɛhɩ anzin, Zozi kɔ hɔ mgbanza Galile mân nɩn anun kulo'n-mɔ asʋ. Mgbanza sɔ nɩn anun, ɔ'a nju man Zude mân nun, ɔ sanlɩn kɛ ɛlɔ Zufʋ mgbain'n-mɔ lɛ kpʋnndɛ yɩ́ kun yɩ́. ");
INSERT INTO any_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Nan kɛmɔ anɩn Zufʋ'n-mɔ *Kpato Bʋ Fɛtɩ'n ka kaan ju'n, ");
INSERT INTO any_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","yɩ́ nianman'n-mɔ nwan: “Zozi, jasʋ ɛwa kɔ Zude maan wɔ́ menian'n-mɔ mɔ bɛ wɔ ɛlɔ'n, bɛ́ kʋsʋ bɛ nwún wɔ́ junman'n mɔ ɛ lɛ di'n. ");
INSERT INTO any_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Sʋanlan m'ɔ kulo kɛ menian'n-mɔ nwun yɩ́ junman'n m'ɔ di'n, ɔ nni man yɩ́ nvɩalɩɛ nun. Kɛ wɔ́ lɩlɩ ɛ di junman sʋa'n, kɔ li yɩ́ ɛlɔ maan mân'n kʋalaa nwún wɔ́.” ");
INSERT INTO any_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Bɛ lɛ kan sɔ'n, afɩ yɩ́ nianman'n-mɔ muonun, bɛ nne man yɩ́ bɛ nni man. ");
INSERT INTO any_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Zozi nwan: “Mɩ́n dɩɛ, mɩ́n mɛlɛ dɩɛ kpa'n juli man, nan ɛmɔ dɩɛ, mɛlɛ kʋalaa tɩ kpa man ɛmɔ. ");
INSERT INTO any_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Ɛmɔ dɩɛ, menian'n-mɔ ngʋala man kɛ bɛ kpɔ ɛmɔ, nan mɩ́n dɩɛ, bɛ kpɔ mɩ́n. Afɩ mɩn kan kɛ bɛ́ nyɔlɩɛ'n tɩ ɛtɛ. ");
INSERT INTO any_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Ɛmɔ hɔ́, bɛ hɔ́ li fɛtɩ'n, nan mɩ́n dɩɛ, mɩn nni man fɛtɩ sɔ'n bie. Ɔ sanlɩn kɛ mɩ́n mɛlɛ dɩɛ kpa'n juli man.” ");
INSERT INTO any_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Kɛ ɔ hanlɩn sɔ helelɩ bɛ́ yuelɩ'n, ɔ kɔ ha Galile. ");
INSERT INTO any_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Mɔ Zozi anianman'n-mɔ hɔlɩ fɛtɩ elie'n, sian'n yɩ́ kʋsʋ ɔ kɔ kpʋ bɛ́. Nan kʋsʋ ɔ fɩalɩ. Ɔ'a nyɩ man yɩ́ nwʋn ɔ'a ngele man menian'n-mɔ kʋalaatin. ");
INSERT INTO any_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Mɔ bɛ 'di fɛtɩ'n, anɩn Zufʋ mgbain'n-mɔ lɛ kpʋnndɛ yɩ́. Ɛsɛ anɩn bɛ lɛ bisa bisa: “Ɔ wɔ nin? Ɔ wɔ nin?” ");
INSERT INTO any_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Meninsʋnman nɩn anun, anɩn bɛ lɛ su yɩ́ nwʋn akpʋlʋwa. Mmie-mɔ nwan: “Ɔ tɩ sʋanlan kpa.” Mmie-mɔ kʋsʋ nwan: “Cɛcɛ, nán sʋanlan kpa ɔ, ɔ lɛ laka laka menian'n-mɔ.” ");
INSERT INTO any_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Nan kʋsʋ kɛmɔ bɛ sulo Zufʋ mgbain'n-mɔ nɩn ati, bɛ ngʋala man yɩ́ jawe nun kan. ");
INSERT INTO any_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Mɔ bɛ lili fɛtɩ'n dede mɔ ɔ 'kɔ yɩ́ afian'n, Zozi kɔ hɔ Nyanmɩan awulo nɩn anun ɔ lɛ kɔ a hehele menian'n-mɔ ninnge. ");
INSERT INTO any_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Yɩ́ like'n m'ɔ lɛ kele'n kɔ sin Zufʋ'n-mɔ anwʋn, bɛ́ nwan: “Bian ɛhɩ mɔ ɔ'a ngɔ man sukulu fɩ́ɩ́'n, ɔ yɔ sɛ mɔ ɔ sɩ kalata kpili sʋa ɔ?” ");
INSERT INTO any_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Zozi nwan: “Ninnge'n mɔ mɩɩn kekele ɛmɔ ɛwa'n, nán mɩ́n muonun mɩ́n ti anun ninnge yɛ̂ mɩɩn kekele ɛmɔ ɔ, nan ɔ fi sʋanlan'n mɔ ɔ'a sʋan mɩ́n nɩn ɛlɔ. ");
INSERT INTO any_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Sʋanlan m'ɔ kulo kɛ ɔ yɔ like mɔ Nyanmɩan kulo'n, sɛ ninnge'n mɔ mɩɩn kele'n fi Nyanmɩan ɛlɔ a, anaan ɔ tɩ mɩ́n muonun mɩ́n ti anwʋn ninnge a, ɔ kʋala ɔ nwun yɩ́. ");
INSERT INTO any_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Sʋanlan m'ɔ kan yɩ́ muonun yɩ́ nwʋn ɛjɔlɛ'n, anɩn ɔ lɛ kpʋnndɛ yɩ́ muonun yɩ́ anunminnyanmʋn. Nan nunhan m'ɔ kpʋnndɛ sʋanlan'n m'ɔ sʋanlɩn yɩ́ nɩn anunminnyanmʋn'n, sʋanlan sɔ'n, ɔ tɩ sʋanlan kpa. Ɔ nni man ato fɩ́ɩ́. ");
INSERT INTO any_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","*Moyizɩ yɛ̂ ɔ falɩ mala'n manlɩn ɛmɔ ɔ. Ɔ tɩ man sɔ ɔ? Kʋsʋ ɛmɔ anun kʋn bɔbɔ nni man mala sɔ nɩn asʋ. Nzu ati yɛ̂ ɛmɔ kulo kɛ bɛ kun mɩ́n ɔ?” ");
INSERT INTO any_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Meninsʋnman'n nwan: “Wɔ́, ɛ tɩ man sʋanlan kpa fɩfɩfɩ, ɛ le baye! Nwan yɛ̂ ɔ kulo kɛ ɔ kun wɔ́ ɔ?” ");
INSERT INTO any_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Zozi nwan: “Like kʋnmgba cein ɛhɩ mɔ m'an yɔ'n, ɔ'a sin ɛmɔ anwʋn. Ɛjɔlɛ sɔ nɩn a lɔ ɛmɔ ngasi. Cɩan daa ɛmɔ bɔ sʋ. ");
INSERT INTO any_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Ɛmɔ tíe, Moyizɩ a man ɛmɔ mala kɛ bɛ kpɛ́ mmelenzua'n-mɔ mmian nun. Sakpa kʋsʋ, mmelenzua mmian nun ɛkpɛ sɔ'n, ɛmɔ anan-mɔ yɔ yɩ́ daba yɩ́ nzin nán b'a wʋ Moyizɩ. Kɛmɔ ɛmɔ kulo kɛ bɛ di mala sɔ nɩn asʋ nɩn ati, *ɛnwʋnmɩan ele cɩan'n bɔbɔ, ɛmɔ kpɛ mmelenzua'n-mɔ mmian nun. ");
INSERT INTO any_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Kɛ ɔ kɔ yɔ nán ɛmɔ a nvʋn man Moyizɩ mala nɩn ati, ɛnwʋnmɩan ele cɩan'n muonun ɛmɔ kpɛ mmelenzua'n-mɔ mmian nun. Nan sɛ ɛmɔ kpɛ mmelenzua mmian nun ɛnwʋnmɩan ele cɩan nɩn an, anɩn nzu ati yɛ̂, sɛ m'an man kulo sʋanlan dasannin kʋn anwʋn a sa ɛnwʋnmɩan ele cɩan nɩn an, anɩn ɛmɔ fɛ mɩ́n nwʋn ɛya sʋa ɔ? ");
INSERT INTO any_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Ɛmɔ nán bɛ nɩan sʋanlan anyunnun bɛ bua yɩ́ ndɛɛ, nan ɛmɔ búa ndɛɛ ananhɔlɛ nun.” ");
INSERT INTO any_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Ɛhɩ, anɩn Zoluzalɛmʋn ɛbɛlɛ menian mmie-mɔ lɛ kan kɛ: “Sʋanlan'n mɔ yɛ́ mgbain'n-mɔ lɛ kpʋnndɛ yɩ́ bɛ kun yɩ́'n, nán yɩ́ ahɩ? ");
INSERT INTO any_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Bɛ nɩ́an kɛ ɔ lɛ jʋjɔ menian'n-mɔ anun ɛwa ɔ, kʋsʋ bɛ nze man yɩ́ sa fɩ́ɩ́. Asʋ yɛ́ mgbain'n-mɔ a nwun yɩ́ ananhɔlɛ kɛ yɩ́ y'ɔ le *Kilisi'n, sʋanlan'n mɔ ɔ 'ba le yɛ́ ti nɩn ɔ? ");
INSERT INTO any_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Bian ɛhɩ dɩɛ, yɛ sɩ lɩka m'ɔ fi ɔ. Kʋsʋ bɛ́ nwan Kilisi'n dɩɛ, sɛ ɔ 'ba a, sʋanlan fɩ́ɩ́ nnwun man lɩka m'ɔ fi'n.” ");
INSERT INTO any_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Yɩ́ sɔ ati, mɔ Zozi 'kekele bɛ́ ninnge wɔ Nyanmɩan awulo nɩn anun'n, ɔ kɔ tɩan nun, yɩ́ nwan: “Asʋ ɛmɔ jʋnlɩn kɛ ɛmɔ sɩ mɩ́n ɛsɛ ɛmɔ sɩ lɩka mɔ n vi'n sakpa ɔ? Nán mɩ́n ti anwʋn atɩn yɛ̂ m'an a ɔ, nan sʋanlan'n m'ɔ sʋanlɩn mɩ́n'n tɩ ananhɔlɛfʋɛ. Kʋsʋ ɛmɔ nzɩ man yɩ́. ");
INSERT INTO any_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Mɩ́n dɩɛ mɩn sɩ yɩ́, ɔ sanlɩn kɛ n vi yɩ́ nwʋn ɛbɛlɛ yɛ̂ m'an a ɔ. Yɩ́ dein yɛ̂ ɔ sʋanlɩn mɩ́n ɔ.” ");
INSERT INTO any_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Mɔ Zozi hanlɩn sɔ'n, bɛ 'kpʋnndɛ kɛ bɛ cɩ yɩ́ ɛbɛlɛ ala. Nan sʋanlan fɩ́ɩ́ a ngʋala man yɩ́ cɩ, ɔ sanlɩn kɛ anɩn yɩ́ dɔɛ'n juli man. ");
INSERT INTO any_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Nan kʋsʋ meninsʋnman nɩn anun, menian dɔʋn lelɩ yɩ́ lili. Bɛ́ nwan: “Cɩan mɔ Kilisi'n kɔ a'n, asʋ ɔ 'yɔ asinbɛnwʋn ninnge m'ɔ tala sʋanlan ɛhɩ dɩɛ'n-mɔ ɔ?” ");
INSERT INTO any_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Ɛhɩ, Zozi anwʋn ɛjɔlɛ'n mɔ anɩn bɛ lɛ kɩkan yɩ́ nhun nhun menian nɩn anun'n, *Falisifʋɛ'n-mɔ tɩlɩ yɩ́ kʋalaa. Nyanmɩan *tɛɛyɩfʋɛ mgbain'n-mɔ nʋn Falisifʋɛ'n-mɔ kɔ yɩ Nyanmɩan awulo nɩn anun nzalafʋ'n-mɔ kɛ bɛ hɔ́ hyɩ́ Zozi. ");
INSERT INTO any_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Mɔ nzalafʋ'n-mɔ hɔlɩ juli Zozi anwʋn ɛlɔ'n, yɩ́ nwan: “Mɩn nʋn ɛmɔ yɛ 'tanlan mɛlɛ kaan biekun kʋalaaka nán m'an hɔ sʋanlan'n m'ɔ sʋanlɩn mɩ́n nɩn anwʋn ɛlɔ. ");
INSERT INTO any_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Ɛmɔ 'ba kpʋnndɛ mɩ́n, nan kʋsʋ, ɛmɔ ngɔ nwun man mɩ́n. Ɔ sanlɩn kɛ lɩka mɔ mɩn 'ba hɔ'n, ɛmɔ ngɔ hʋala man ɛlɔ kɔ.” ");
INSERT INTO any_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Zufʋ'n-mɔ lɛ bisa bisa bɛ́ nwʋn kɛ: “Anɩn ninhan lɩka dɩɛ yɛ̂ ɔ 'ba hɔ dede mɔ yɛ kpʋnndɛ yɩ́ a, yɛ nnwun man yɩ́ ɔ? Asʋ ɔ 'ba tʋa Zufʋ'n-mɔ mɔ b'a tʋ b'a sanndɩ bɛ́ mɔ bɛ tɩ man Zufʋ'n mân nun'n nán ɔ kekele bɛ́ mɔ bɛ tɩ man Zufʋ'n ninnge anaan? ");
INSERT INTO any_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Afɩ yɩ́ nwan: ‘Ɛmɔ 'ba kpʋnndɛ mɩ́n, nan kʋsʋ, ɛmɔ ngɔ nwun man mɩ́n. Ɔ sanlɩn kɛ lɩka mɔ mɩn 'ba hɔ'n, ɛmɔ ngɔ hʋala man ɛlɔ kɔ.’ Ɛjɔlɛ ɛhɩ mɔ ɔ'a han'n, yɩ́ bʋ kele sɛ?” ");
INSERT INTO any_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Zufʋ'n-mɔ fɛtɩ sɔ'n kʋsʋ, cɩan m'ɔ li sian'n yɛ̂ ɔ tɩ fɛtɩ'n cɩan kpili kpa nɩn ɔ. Cɩan sɔ'n, Zozi jasʋlɩ jinlanlɩn menian'n-mɔ kʋalaa afian an, yɩ́ nwan: “Sʋanlan mɔ nzuhoe lɛ kun yɩ́'n, ɔ bála mɩ́n nwʋn ɔ bála a nʋn nzue. ");
INSERT INTO any_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Kɛ Ɛhɛlɛ Ɛjɔlɛ'n kan yɩ́'n, biala m'ɔ kɔ le mɩ́n kɔ li'n, ngʋan nzue fʋfɔlɛ fi yɩ́ ahʋnlɩn nɩn anun ɔ 'sɩn wa wa wa.” ");
INSERT INTO any_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Ngʋan nzue sɔ'n mɔ Zozi lɛ kan yɩ́ ɛjɔlɛ ɛwa'n y'ɔ le Nyanmɩan Wawɛ'n mɔ sʋanlan biala m'ɔ kɔ le yɩ́ kɔ li nɩn asa 'kan yɩ́'n. Yɩ́ tɛmʋn sɔ nɩn anun, anɩn sʋanlan fɩ́ɩ́ asa hanlɩn man Wawɛ'n bɔbɔ. Ɔ sanlɩn kɛ anɩn bɛ wulalɩ man Zozi anunminnyanmʋn. ");
INSERT INTO any_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Mɔ Zozi hanlɩn sɔ yuelɩ'n, meninsʋnman'n kɔ bu bɛ́ nwʋn nun. Mmie-mɔ nwan: “Bian ɛhɩ tɩ Nyanmɩan kpɔmanfʋɛ'n sakpa.” ");
INSERT INTO any_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Mmie-mɔ kʋsʋ nwan: “Kilisi nɩn ɔ!” Mmiekun-mɔ kʋsʋ nwan: “Heei! Anɩn, Galile mân nun yɛ̂ Kilisi'n fi 'fite ɔ? ");
INSERT INTO any_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Ɛhɛlɛ Ɛjɔlɛ'n kan kɛ Kilisi'n, ɔ 'yɔ *Davidi abusuan nɩn anun sʋanlan, ɔ fi Betelehɛmʋn, Davidi kulo nɩn asʋ.” ");
INSERT INTO any_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Kɛ ɔ yɔlɩ mɔ Zozi dunman nun, meninsʋnman'n buli bɛ́ nwʋn nun nɩn anɩn. ");
INSERT INTO any_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Mmie-mɔ kʋsʋ dɩɛ, anɩn bɛ lɛ kpʋnndɛ yɩ́ bɛ cɩ yɩ́, nan kʋsʋ sʋanlan fɩ́ɩ́ a ngʋala man yɩ́ sa fa kan yɩ́. ");
INSERT INTO any_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Kɛ ɔ yɔlɩ sɔ'n, nzalafʋ'n-mɔ kɔ sa kɔ hɔ Nyanmɩan tɛɛyɩfʋɛ'n-mɔ nʋn Falisifʋɛ'n-mɔ anwʋn ɛlɔ. Kɛ bɛ 'ju ɛbɛlɛ ala, mgbain'n-mɔ nwan: “Ɔ yɔ sɛ mɔ ɛmɔ a njɩ man yɩ́ a mma man ɔ?” ");
INSERT INTO any_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Nzalafʋ'n-mɔ nwan: “Ɛjɔlɛ'n m'ɔ kan'n, nyanmɩnsɛmʋn, kɛ yɛ wɔ ɛwa'n, sʋanlan fɩ́ɩ́ hanlɩn man bie lé.” ");
INSERT INTO any_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Falisifʋɛ'n-mɔ nwan: “Yɩ́ ti, ɛmɔ kʋsʋ, ɛmɔ a man ɔ'a laka ɛmɔ bie ɔ? ");
INSERT INTO any_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Asʋ yɛ́ mgbain'n-mɔ nunhan kʋn anaan Falisifʋɛ'n-mɔ nunhan kʋn lelɩ yɩ́ ɔ lili man ɔ? ");
INSERT INTO any_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Meninsʋnman ɛhɩ, bɛ́ dɩɛ bɛ nzɩ man *Moyizɩ mala'n, bɛ tɩ menian mɔ b'a bɔ bɛ́ sasan!” ");
INSERT INTO any_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Falisifʋɛ sɔ'n-mɔ mɔ bɛ yialɩ ɛbɛlɛ'n, Ninkodɛmʋn m'ɔ walɩ tʋlɩ Zozi cɩan kʋn kɔngɔɛ'n, anɩn ɔ wɔ bɛ́ nun bie. ");
INSERT INTO any_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","Yɩ́ nwan: “Yɛ́ mala nɩn anun, sʋanlan mɔ bɛ nwunlin man like mɔ ɔ'a yɔ'n, bɛ mmua man yɩ́ ndɛɛ kɛ ɔ di fʋɔ ɔ.” ");
INSERT INTO any_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Ɛjɔlɛ sɔ'n mɔ Ninkodɛmʋn hanlɩn'n ngɔ yɔ man bɛ́ fɛ. Ɛhɩ a, bɛ́ nwan: “Yɩ́ ti, wɔ́ kʋsʋ wɔ́ ɛ tɩ Galile sʋanlan? Suan Ɛhɛlɛ Ɛjɔlɛ'n nán ɛ 'ba nwun kɛ Nyanmɩan kpɔmanfʋɛ fɩ́ɩ́ fi man Galile.”  ");
INSERT INTO any_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Kɛ ɔ yɔlɩ sɔ'n, ɛhɩ jasʋ a, anɩn cuein ɔ'a hɔ yɩ́ awulo, ɛhɩ jasʋ a, anɩn cuein ɔ'a hɔ yɩ́ awulo. ");
INSERT INTO any_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Ɛhɩ, Zozi fi Nyanmɩan awulo nɩn anun, ɔ kɔ fite kɔ hɔ *Olivʋ bʋka nɩn asʋ. ");
INSERT INTO any_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Yɩ́ alɩ́ɛ hɩnlɩn, ngɛlɛmɔ tutun'n, Zozi kɔ sa kɔ hɔ Nyanmɩan awulo ɛlɔ biekun. Kɛ ɔ 'wʋlʋ ɛbɛlɛ ala, meninsʋnman'n kɔ hyʋɩn kɔ kpunnge yɩ́. Zozi kɔ tanlan asɩ ɔ lɛ kekele bɛ́ ninnge. ");
INSERT INTO any_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Ɔ wɔ ɛbɛlɛ kaan an, Nyanmɩan mala nɩn asʋ mgbain'n-mɔ nʋn *Falisifʋɛ'n-mɔ nʋn balasua kʋn kɔ a kɔ tʋ yɩ́. Balasua sɔ nɩn a tʋn aja. Bɛ kɔ fa yɩ́ bɛ kɔ sie menian'n-mɔ kʋalaa anyunnun ɛbɛlɛ. ");
INSERT INTO any_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Bɛ́ nwan: “Kpain, balasua ɛhɩ a tʋn aja. Bɛ 'kɔ ju a, anɩn ɔ nʋn belenzua kʋn la. ");
INSERT INTO any_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","*Moyizɩ kʋsʋ hanlɩn wɔ yɛ́ mala nɩn anun kɛ mmalasua sʋa-mɔ, yɛ tʋ́tʋ bɛ́ ɛbʋɛ yɛ hún bɛ́. Nan wɔ́ kʋsʋ, wɔ́ nwan nzɛ?” ");
INSERT INTO any_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Bɛ 'kan sɔ bɛ tetie yɩ́ nʋan nun nán bɛ jinlan sʋ bɛ se kɛ ɔ'a yɔ ɛtɛ. Mɔ bɛ 'bisa kosuan sɔ'n, anɩn Zozi a si yɩ́ ti asɩ. Ɔ le yɩ́ sa'n ɔ lɛ kɛkɛlɛ asɩɛ nɩn anwʋn. ");
INSERT INTO any_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Kɛmɔ anɩn bɛ tɛ bisa yɩ́ kosuan'n, Zozi kɔ kuku yɩ́ ti sʋ, yɩ́ nwan: “Ɛmɔ nunhan kʋn m'ɔ yɔlɩ man ɛtɛ lé'n, ɔ lí mʋa ɔ tʋ́ ɛbʋɛ bɔ́ balasua ɛhɩ.” ");
INSERT INTO any_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Kɛ ɔ hanlɩn sɔ yuelɩ'n, ɛsɛ ɔ kɔ si yɩ́ ti asɩ biekun ɔ lɛ kɛkɛlɛ asɩɛ nɩn anwʋn. ");
INSERT INTO any_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Bɛ́ mɔ bɛ nʋn balasua'n walɩ'n, kɛ bɛ tɩlɩ ɛjɔlɛ sɔ'n, bɛ́ mgbain o, bɛ́ mgbafɛlɛ o, bɛ́ kʋalaa bɛ kɔ yaci balasua nɩn ɛbɛlɛ bɛ kɔ hɔ. Balasua nɩn angʋnmɩn kɔ ha Zozi anwʋn ɛbɛlɛ. ");
INSERT INTO any_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Zozi kɔ kuku yɩ́ ti sʋ ɔ kɔ bisa balasua'n kɛ: “Balasua, menian'n-mɔ wɔ nin? Sʋanlan fɩ́ɩ́ a ndua man wɔ́ ɛtɛ nɩn anwʋn kalɛ ɔ?” ");
INSERT INTO any_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Balasua'n nwan: “Mɩ́n mɩn, sʋanlan fɩ́ɩ́ a nze man mɩ́n sa.” Zozi nwan: “Sɛ sʋanlan fɩ́ɩ́ a nze man wɔ́ sa a, mɩ́n kʋsʋ mɩn nze man wɔ́ sa fɩ́ɩ́. Yɩ́ ti, kɔ, nan kʋsʋ n'ɛ yɔ ɛtɛ fɩ́ɩ́ kʋ́n.” ");
INSERT INTO any_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Anɩn Zozi tɛ wɔ Nyanmɩan awulo nɩn anun ɛbɛlɛ. Ɔ kacili yɩ́ nyɩn bagua nɩn anwʋn ɛlɔ biekun an, yɩ́ nwan: “Mân'n kanlannɩɛ'n y'ɔ le mɩ́n. Sʋanlan m'ɔ kɔ si mɩ́n sʋ'n, ɔ nnanndɩ man awosin nun lé, nan ɔ 'nyan kanlannɩɛ'n m'ɔ man ngʋan'n.” ");
INSERT INTO any_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","*Falisifʋɛ'n-mɔ nwan: “Wɔ́ muonun ɛ lɛ di wɔ́ nwʋn adanzɩɛ, yɩ́ sɔ ati wɔ́ ɛjɔlɛ'n mɔ ɛ lɛ kan'n tɩ ato.” ");
INSERT INTO any_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Zozi nwan: “Sɛ mɩɩn di mɩ́n nwʋn adanzɩɛ bɔbɔ a, mɩ́n ɛjɔlɛ'n mɔ mɩɩn kan'n tɩ ananhɔlɛ. Ɔ sanlɩn kɛ mɩn sɩ lɩka mɔ n vi m malɩ ɔ, ɛsɛ mɩn sɩ lɩka mɔ mɩɩn kɔ ɔ. Nan ɛmɔ dɩɛ, ɛmɔ nzɩ man lɩka mɔ n vi m malɩ ɔ, ɛsɛ ɛmɔ nzɩ man lɩka mɔ mɩɩn kɔ ɔ. ");
INSERT INTO any_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Ɛmɔ bua bɛ́ ndɛɛ'n kɛ kulo menian'n-mɔ bua yɩ́'n. Nan mɩ́n dɩɛ, mɩn mmua man sʋanlan fɩ́ɩ́ ndɛɛ. ");
INSERT INTO any_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Sɛ mɩ́n nwan mɩn 'bua ndɛɛ a, mɩ́n ndɛɛ ebua'n tɩ fɔ́ʋ́n. Ɔ sanlɩn kɛ nán mɩ́n ngʋnmɩn yɛ̂ mɩn 'bua ɔ, nan mɩn nʋn Sɩɛ'n m'ɔ sʋanlɩn mɩ́n'n yɛ̂ yɛ 'bua ɔ. ");
INSERT INTO any_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","B'a hɛlɛ wɔ mala nɩn anun kɛ sɛ menian nnyuan adanzɩɛ elie'n yɔ kʋn an, bɛ fa bɛ́ ɛjɔlɛ nɩn ananhɔlɛ. ");
INSERT INTO any_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Mɩ́n muonun mɩɩn di mɩ́n nwʋn adanzɩɛ, ɛsɛ Sɩɛ'n kʋsʋ m'ɔ sʋanlan mɩ́n'n di mɩ́n nwʋn adanzɩɛ.” ");
INSERT INTO any_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Bɛ́ nwan: “Wɔ́ sɩ sɔ'n wɔ nin?” Zozi nwan: “Sian dɩɛ, m'an nwun kɛ ɛmɔ nzɩ man mɩ́n, ɛsɛ ɛmɔ nzɩ man mɩ́n Sɩ. Nan sɛ ɛmɔ sɩ mɩ́n an, ahan ɛmɔ sɩ mɩ́n Sɩ kʋsʋ.” ");
INSERT INTO any_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Mɔ Zozi 'kan ɛjɔlɛ sɔ'n, anɩn ɔ wɔ Nyanmɩan awulo nɩn anun lɩka mɔ bɛ tʋ kɛtɩ'n. Sʋanlan fɩ́ɩ́ a nze man yɩ́ sa, ɔ sanlɩn kɛ anɩn yɩ́ dɔɛ'n juli man. ");
INSERT INTO any_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Zozi kɔ han kɔ hele bɛ́ biekun kɛ: “Mɩn 'ba hɔ mɩn yaci ɛmɔ mân'n mɩn man bɛ́. Ɛmɔ 'ba kpʋnndɛ mɩ́n, nan kʋsʋ ɛmɔ 'ka bɛ́ ɛtɛ nɩn anun bɛ wu. Lɩka mɔ mɩɩn kɔ'n, ɛmɔ ngʋala man ɛlɔ bie kɔ.” ");
INSERT INTO any_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Zufʋ'n-mɔ nwan: “Bian ɛhɩ muonun, anɩn ɔ lɛ ba hun yɩ́ nwʋn anaan? Afɩ yɩ́ nwan: ‘Lɩka mɔ mɩɩn kɔ'n, ɛmɔ ngʋala man ɛlɔ bie kɔ.’” ");
INSERT INTO any_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Zozi nwan: “Asɩ ɛwa yɛ̂ ɛmɔ fi ɔ, nan mɩ́n dɩɛ, n vi anwunno. Ɛmɔ tɩ mân ɛhɩ anun menian, nan mɩ́n dɩɛ, n dɩ man mân ɛhɩ anun sʋanlan. ");
INSERT INTO any_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Ɛhɩka ati yɛ̂ mɩ́n nwan ɛmɔ 'ka bɛ́ ɛtɛ nɩn anun bɛ wu nɩn ɔ. Afɩ mɩ́n mɔ n dɩ asɩ dahuu'n, sɛ ɛmɔ a nne man mɩ́n sʋanlan ɛhɔlɛ kʋn'n mɔ n dɩ'n b'a nni man an, ɛmɔ 'ka bɛ́ ɛtɛ nɩn anun bɛ wu.” ");
INSERT INTO any_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Mɔ Zufʋ'n-mɔ tɩlɩ ɛjɔlɛ sɔ'n, bɛ́ nwan: “Wɔ́ ejian mɔ ɛ jin ɛbɛlɛ'n, nzu sʋanlan dɩɛ y'ɔ le wɔ́?” Zozi nwan: “Kɛ m gbɩn n dɩ yɩ́'n yɛ̂ abʋbɔ nɩn anun n ganlɩn n gelelɩ ɛmɔ nɩn ɔ. ");
INSERT INTO any_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","N ne ɛmɔ anwʋn ɛjɔlɛ dɔʋn kpa mɔ mɩn kʋala mɩn kan ɛsɛ mɩn kʋala mɩn jinlan sʋ mɩn bu ɛmɔ fʋɔ. Nan kʋsʋ sʋanlan'n m'ɔ sʋanlɩn mɩ́n'n, ɔ tɩ ananhɔlɛfʋɛ. M'ɔ hanlɩn helelɩ mɩ́n'n, yɩ́ ala yɛ̂ mɩn kan mɩn kele mân nɩn ɔ.” ");
INSERT INTO any_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Ɛjɔlɛ sɔ'n mɔ Zozi hanlɩn'n, b'a ndɩ man yɩ́ bʋ kɛ yɩ́ Sɩ anwʋn ɛjɔlɛ yɛ̂ ɔ lɛ kan kele bɛ́ ɔ. ");
INSERT INTO any_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Ɛsɛ Zozi kɔ han biekun kɔ tʋ sʋ, yɩ́ nwan: “Cɩan mɔ ɛmɔ 'ba fʋla *Mân Baa nɩn anwunno'n, cɩan sɔ'n yɛ̂ ɛmɔ 'ba nwun mɩ́n sʋanlan ɛhɔlɛ kʋn'n mɔ n dɩ nɩn ɔ. Ɛmɔ 'ba nwun kɛ mɩn mmɔ man mɩ́n ti anun mɩn nyɔ man like fɩ́ɩ́, nan mɔ Sɩɛ'n helelɩ mɩ́n'n, yɩ́ nwʋn ɛjɔlɛ ala yɛ̂ mɩn kan ɔ. ");
INSERT INTO any_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Sʋanlan'n m'ɔ sʋanlɩn mɩ́n'n jin mɩ́n nzin. Ɔ yɩlɩ man mɩ́n tʋlɩ man, ɔ sanlɩn kɛ like m'ɔ kulo'n yɛ̂ cɩan daa mɩn yɔ ɔ.” ");
INSERT INTO any_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Ɛjɔlɛ sɔ'n mɔ Zozi hanlɩn nɩn ati, menian dɔʋn lelɩ yɩ́ lili. ");
INSERT INTO any_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","M'ɔ yɔlɩ sɔ'n, Zozi kɔ kpɛ yɩ́ nyɩn Zufʋ'n-mɔ mɔ b'a le yɩ́ b'a li'n-mɔ anwʋn ɛlɔ, yɩ́ nwan: “Ɛjɔlɛ'n mɔ m'an han m'an hele ɛmɔ'n, sɛ ɛmɔ sɔ nun kpa a, ɛmɔ 'kaci mɩ́n menian sakpa. ");
INSERT INTO any_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Ɛbɛlɛ nɩn anun yɛ̂ ɛmɔ 'ba nwun ananhɔlɛ'n, nán ananhɔlɛ'n kʋsʋ a man ɛmɔ a nyan bɛ́ ti b'a ngaci man nganga.” ");
INSERT INTO any_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Ɛjɔlɛ sɔ'n mɔ Zozi hanlɩn nɩn a nyɔ man Zufʋ'n mmie-mɔ fɛ. Kɛ bɛ tɩlɩ ɛjɔlɛ sɔ nɩn ala, bɛ́ nwan: “Yɛ́ dɩɛ, Abalahamʋn amma y'ɔ le yɛ́. Yɛ kacili man sʋanlan fɩ́ɩ́ nganga lé. Nan ɔ yɔ sɛ mɔ ɛ lɛ kan kɛ ɛmɔ 'ba nyan bɛ́ ti ɔ?” ");
INSERT INTO any_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Zozi nwan: “Mɩɩn kan yɩ́ ananhɔlɛ mɩn kele ɛmɔ kɛ sʋanlan biala m'ɔ yɔ ɛtɛ'n, anɩn ɔ tɩ ɛtɛ'n kanga. ");
INSERT INTO any_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Nán daa yɛ̂ kanga'n di afilie'n bie ɔ. Nan baa'n mɔ bɛ kɔ wʋ yɩ́ afilie nɩn anun'n, ɔ di afilie'n dahuu. ");
INSERT INTO any_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Sɛ Baa'n man ɛmɔ nyan bɛ́ ti a, anɩn ɛmɔ a nyan bɛ́ ti sakpa. ");
INSERT INTO any_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Mɩn sɩ kɛ Abalahamʋn abʋsʋ menian y'ɔ le ɛmɔ. Kʋsʋ ɛmɔ 'kpʋnndɛ mɩ́n bɛ kun mɩ́n, ɔ sanlɩn kɛ ɛmɔ nne man mɩ́n ɛjɔlɛ'n bɛ nni man. ");
INSERT INTO any_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Like mɔ mɩ́n Sɩ helelɩ mɩ́n nɩn anwʋn ɛjɔlɛ yɛ̂ mɩɩn kan ɔ. Nan ɛmɔ dɩɛ, like mɔ ɛmɔ asɩ nɩn a hele ɛmɔ'n yɛ̂ ɛmɔ lɛ yɔ nɩn ɔ.” ");
INSERT INTO any_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Bɛ́ nwan: “Yɛ́ sɩ yɔ le Abalahamʋn.” Zozi nwan: “Sɛ ɛmɔ asɩ y'ɔ le Abalahamʋn sakpa a, ahan yɩ́ ninnge'n m'ɔ yɔlɩ'n, bie yɛ̂ ɛmɔ yɔ ɔ. ");
INSERT INTO any_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Nan kʋsʋ ɛmɔ dɩɛ, sunnzun mɔ m'an han ananhɔlɛ'n mɔ Nyanmɩan hanlɩn helelɩ mɩ́n'n m'an hele ɛmɔ ɔ, ɛmɔ 'kpʋnndɛ mɩ́n kun mɩ́n. Like sʋa, Abalahamʋn a nyɔ man bie lé. ");
INSERT INTO any_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Junman kʋnmgba'n mɔ ɛmɔ asɩ'n di'n, yɩ́ bie yɛ̂ ɛmɔ kʋsʋ di nɩn ɔ.” Mɔ Zozi hanlɩn sɔ'n, Zufʋ'n-mɔ kɔ fɛ ɛya kpili kpa. Bɛ́ nwan: “Nán gua sʋ mma y'ɔ le yɛ́ ɛɩn! Yɛ́ Sɩ baa kʋnmgba cein'n y'ɔ le Nyanmɩan.” ");
INSERT INTO any_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Zozi nwan: “Sɛ ɛmɔ asɩ y'ɔ le Nyanmɩan sakpa a, ahan ɛmɔ kulo mɩ́n ɛjɔlɛ. Ɔ sanlɩn kɛ n vi Nyanmɩan anwʋn ɛlɔ yɛ̂ m malɩ ɔ. Yɛ̂ yɩ́ dunman nun ati yɛ̂ n wɔ ɛwa ɔ. Nán mɩ́n ngʋnmɩn mɩ́n ti anwʋn yɛ̂ m'an a ɔ. Nan yɩ́ yɛ̂ ɔ sʋanlɩn mɩ́n ɔ. ");
INSERT INTO any_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Nzukɛ ati yɛ̂ mɩn kan mɩ́n ɛjɔlɛ dɩɛ a, ɛmɔ ndɩ man yɩ́ bʋ ɔ? Afɩ ɛmɔ ngʋala man kɛ bɛ tɩ yɩ́ bʋ. ");
INSERT INTO any_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Ɛmɔ asɩ y'ɔ le *Abɔnsanmʋn. Ɛmɔ kulo kɛ bɛ yɔ like m'ɔ kulo'n. Kɛ alʋa bɔlɩ'n, kodiawu junman y'ɔ di ɔ. Ɔ hanlɩn man ananhɔlɛ lé, ɔ sanlɩn kɛ ananhɔlɛ nnʋn man yɩ́ nun. Atofʋɛ kʋn m'ɔ halɩ'n y'ɔ le yɩ́. Ato nɩn a kaci yɩ́ abalabɔ, yɩ́ alɩɛ m'ɔ di nɩn anɩn. Ɔ tɩ atofʋɛ'n-mɔ kʋalaa asɩ. ");
INSERT INTO any_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Nan kɛmɔ mɩ́n dɩɛ mɩn kan ananhɔlɛ'n, yɩ́ ti, ɔ man ɛmɔ nne man mɩ́n bɛ nni man. ");
INSERT INTO any_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Ɛmɔ nunhan benin yɛ̂ ɔ kʋala ɔ se kɛ m'an yɔ ɛtɛ ɔ? Nan sɛ mɩn kan ananhɔlɛ a, nzukɛ ati yɛ̂ ɛmɔ nne man mɩ́n nni man ɔ? ");
INSERT INTO any_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Sʋanlan m'ɔ tɩ Nyanmɩan sʋanlan'n, ɔ tie Nyanmɩan anʋan ɛjɔlɛ'n. Nan kɛmɔ ɛmɔ tɩ man Nyanmɩan dɩɛ'n, yɩ́ ti yɛ̂ ɔ man ɛmɔ ndie man mɩ́n ɛjɔlɛ nɩn ɔ.” ");
INSERT INTO any_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Zufʋ'n-mɔ nwan: “Yɛ hanlɩn kɛ ɛ tɩ man Zufʋ kpa, ɛ tɩ *Samali sʋanlan, ɛsɛ ɛ le baye, ɔ tɩ man ananhɔlɛ ɔ?” ");
INSERT INTO any_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Zozi nwan: “Cɛcɛ, n ne man baye. Mɩ́n dɩɛ, mɩ́n Sɩ yɛ̂ mɩɩn kannvʋ yɩ́ ɔ. Kʋsʋ ɛmɔ ngulo man kɛ bɛ man mɩ́n anyɩnnzɔ. ");
INSERT INTO any_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Mɩ́n dɩɛ mɩ́n muonun mɩn mgbʋnndɛ man mɩ́n anunminnyanmʋn. Sʋanlan kʋn wɔ ɛbɛlɛ m'ɔ wula mɩ́n anunminnyanmʋn ɔ. Ɛsɛ yɩ́ yɛ̂ ɔ bua ndɛɛ nɩn ɔ. ");
INSERT INTO any_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Yɩ́ ti, mɩɩn kan yɩ́ ananhɔlɛ mɩn kele ɛmɔ kɛ sʋanlan biala m'ɔ kɔ le ɛjɔlɛ'n mɔ mɩɩn kan'n kɔ li'n, sʋanlan sɔ'n, ɔ nwu man lé.” ");
INSERT INTO any_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Zufʋ'n-mɔ nwan: “Kɩkaala dɩɛ, y'a nwun yɩ́ kɛ ɛ le baye. Ɔ sanlɩn kɛ Abalahamʋn a wu, mgbɔmanfʋɛ'n-mɔ kʋsʋ a wu. Ɔ yɔ sɛ mɔ afɩ ɛ lɛ kan kɛ: ‘Sʋanlan biala m'ɔ kɔ le ɛjɔlɛ'n mɔ mɩɩn kan'n kɔ li'n, sʋanlan sɔ'n, ɔ nwun man le.’ ");
INSERT INTO any_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Yɛ́ sɩ Abalahamʋn mɔ ɔ'a wu'n, ɛ de di kɛ ɛ tɩ kpili tala yɩ́ ɔ? Mgbɔmanfʋɛ'n-mɔ kʋsʋ a wu. Ɛ tɩ wɔ́ dɩɛ sɛ?” ");
INSERT INTO any_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Zozi nwan: “Sɛ mɩ́n muonun mɩn kannvʋ mɩ́n nwʋn an, mɩ́n nwʋn ɛkannvʋɛ'n tɩ mgban. Mɩ́n Sɩ mɔ ɛmɔ nwan ɔ tɩ ɛmɔ Nyanmɩan'n, yɩ́ yɛ̂ ɔ kannvʋ mɩ́n ɔ. ");
INSERT INTO any_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Nan kʋsʋ, ɛmɔ nzɩ man yɩ́. Mɩ́n dɩɛ, mɩn sɩ yɩ́. Sɛ mɩn kan kɛ mɩn nzɩ man yɩ́ a, anɩn m'an kaci atofʋɛ kɛ ɛmɔ. Nan mɩn sɩ yɩ́, ɛsɛ mɩn de yɩ́ nʋan ɛjɔlɛ'n mɩn di. ");
INSERT INTO any_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Ɛmɔ asɩ Abalahamʋn lili fɛ kɛ ahan ɔ nwunlɩn mɩ́n ɛwalɛ cɩan'n. Ɔ nwunlin yɩ́ kʋsʋ, ɛsɛ ɔ lili yɩ́ nwʋn fɛ.” ");
INSERT INTO any_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Mɔ Zozi hanlɩn sɔ'n, Zufʋ'n-mɔ nwan: “An! Ɛ lili man afʋɛ abulanun bɔbɔ mgban, wɔ́ nwan a nwun Abalahamʋn.” ");
INSERT INTO any_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Zozi nwan: “Mɩɩn kan yɩ́ ananhɔlɛ mɩn kele ɛmɔ kɛ, asannan nán b'a wʋ Abalahamʋn'n, anɩn n wɔ ɛbɛlɛ.” ");
INSERT INTO any_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Ɛhɩ a, bɛ kɔ sɩsa nyɔbʋɛ, bɛ 'tʋtʋ bɛ bɔ Zozi. Ɔ kɔ nwanndi kɔ fɩa, ɔ fi Nyanmɩan awulo nɩn anun ɛbɛlɛ ɔ kɔ fite kɔ hɔ. ");
INSERT INTO any_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Mɔ Zozi fi Nyanmɩan awulo ɛbɛlɛ fitelɩ'n, ɔ 'kɔ kaan an, ɔ nʋn bian kʋn kɔ yia. Bian sɔ'n, bɛ 'wʋ yɩ́ a, anɩn yɩ́ nyɩn a sin. ");
INSERT INTO any_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Mɔ Zozi menian'n-mɔ nwunlin yɩ́'n, bɛ́ nwan: “*Labi, ɔ yɔ sɛ mɔ bian ɛhɩ, bɛ 'wʋ yɩ́ a, anɩn yɩ́ nyɩn a sin'n? Yɩ́ muonun yɩ́ ɛtɛ nɩn ati anaan yɩ́ sɩ nʋn yɩ́ nin ɛtɛ nɩn ati ɔ?” ");
INSERT INTO any_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Zozi nwan: “Nán ɛtɛ mɔ ɔ'a yɔ ti ɔ, yɛ̂ nán ɛtɛ mɔ yɩ́ sɩ nʋn yɩ́ nin a yɔ ti ɔ. Nan bɛ wʋlɩ yɩ́ sɔ maan Nyanmɩan nanndɩ yɩ́ sʋ ɔ yɩ yɩ́ junman'n mɔ ɔ 'ba li'n kele mân'n. ");
INSERT INTO any_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Kɛmɔ alɩ́ɛ'n tɛ wɔ sʋ'n, ɔ sɛ kɛ yɛ lí sʋanlan'n mɔ ɔ'a sʋan mɩ́n'n junman'n. Nan alɩ́ɛ'n lɛ 'ba san mɔ sʋanlan fɩ́ɩ́ ngɔ hʋala man junman di ɔ. ");
INSERT INTO any_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Mɔ n dɛ wɔ mân nɩn anun ɛwa'n, mân'n kanlannɩɛ'n y'ɔ le mɩ́n.” ");
INSERT INTO any_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Mɔ Zozi hanlɩn ɛjɔlɛ sɔ'n yuelɩ'n, ɔ kɔ tʋ ngɛsɛlɛ asɩ, ɔ kɔ fa kɔ fɔtɔ ngɛtɩɛ, ɔ kɔ han anyɩnsinlinwafʋɛ nɩn anyɩn nɩn asʋ. ");
INSERT INTO any_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Yɩ́ nwan: “Kɔ nwunnzin wɔ́ nyunnun Silowe asubula nɩn anun.” (Dunman Silowe'n, yɩ́ bʋ y'ɔ le kɛ b'a sʋan yɩ́.) Anyɩnsinlinwafʋɛ'n kɔ hɔ kɔ nwunnzin yɩ́ nyunnun. Mɔ ɔ 'sa yɩ́ nzin ba'n, anɩn yɩ́ nyɩn nɩn a tike. ");
INSERT INTO any_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","M'ɔ yɔlɩ sɔ'n, bɛ́ mɔ bɛ nʋn yɩ́ mantan mantan sʋ nʋn bɛ́ mɔ bɛ sɩ yɩ́ daba kɛ yɩ́ nyɩn a sin nán ɔ sɛlɛ sɛlɛ di'n, bɛ kɔ nwun yɩ́. Bɛ́ nwan: “Sʋanlan'n m'ɔ tanlan atɩn nɩn anʋan ɔ sɛlɛ sɛlɛ'n, asʋ nán yɩ́ ahɩ?” ");
INSERT INTO any_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Mmie-mɔ nwan: “Yɩ́ ɔ.” Mmie-mɔ kʋsʋ nwan: “Cɛcɛ, nán yɩ́ ɔ, nan ɔ soman yɩ́ hɔ ɔ.” Mɔ bian'n tɩlɩ akpʋlʋwa'n mɔ bɛ lɛ su'n, yɩ́ nwan: “Mɩ́n ɔ, mɩ́n bɔbɔ mɩ́n ahɩ.” ");
INSERT INTO any_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Ɛjɔlɛ'n kɔ sin bɛ́ nwʋn, bɛ́ nwan: “Nan anɩn ɔ yɔlɩ sɛ kpa mɔ wɔ́ nyɩn nɩn a tike'n?” ");
INSERT INTO any_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Yɩ́ nwan: “Bian'n mɔ bɛ fɛlɛ yɩ́ Zozi'n, ɔ fɔtɔlɩ ngɛtɩɛ kaan bie ɔ falɩ ɔ kputalɩ mɩ́n nyɩn nɩn asʋ nán ɔ'a se mɩ́n kɛ: ‘Kɔ Siloe kɔ nwunnzin wɔ́ nyunnun.’ N gɔlɩ mɔ n nwunnzinlin mɩ́n nyunnun yuelɩ'n yɛ̂ mɩ́n nyɩn'n tikelɩ ɔ.” ");
INSERT INTO any_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Bɛ́ nwan: “Bian sɔ'n wɔ nin?” Yɩ́ nwan: “Mɩn nzɩ man.” ");
INSERT INTO any_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Ɛhɩ a, bɛ kɔ fa bian'n mɔ yɩ́ nyɩn nɩn a tike'n bɛ kɔ hɔ *Falisifʋɛ'n-mɔ aja sʋ. ");
INSERT INTO any_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Ɔ 'ba yɔ sɔ'n kʋsʋ, Zufʋ'n-mɔ *ɛnwʋnmɩan ele cɩan nɩn anun yɛ̂ Zozi fɔtɔlɩ ngɛtɩɛ'n ɔ falɩ ɔ tikelɩ bian nɩn anyɩn nɩn ɔ. ");
INSERT INTO any_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Ɛhɩ ati yɛ̂ Falisifʋɛ'n-mɔ lɛ bisa bian'n kɛ ɔ kpɩnlɩn yɔlɩ dede mɔ sian ɔ nwun asɩ'n. Yɩ́ nwan: “Bian bie, bɛ fɛlɛ yɩ́ Zozi, ɔ falɩ ngɛtɩɛ hanlɩn mɩ́n nyɩn'n, n nwunnzinlin mɩ́n nyunnun yɛ̂ mɩ́n nyɩn'n tikelɩ ɔ. Sian dɩɛ mɩn nwun asɩ.” ");
INSERT INTO any_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Falisifʋɛ'n mmie-mɔ nwan: “Sʋanlan sɔ'n, nán Nyanmɩan sʋanlan ɔ. Ɔ nni man ɛnwʋnmɩan ele cɩan'n mala nɩn asʋ.” Mmie-mɔ kʋsʋ nwan: “Sʋanlan m'ɔ yɔ ɛtɛ'n, ɔ yɔ sɛ m'ɔ yɔ asinbɛnwʋn ninnge sʋa ɔ?” Bɛ́ nʋan a nzɛ man bɛ́ nwʋn. Bɛ kɔ bu bɛ́ nwʋn nun. ");
INSERT INTO any_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Ɛsɛ Falisifʋɛ'n-mɔ kɔ bisa yɩ́ biekun kɛ: “Sʋanlan'n m'ɔ tikelɩ wɔ́ nyɩn'n, ɛ jʋnlɩn kɛ ɔ tɩ sɛ?” Yɩ́ nwan: “Nyanmɩan kpɔmanfʋɛ ɔ.” ");
INSERT INTO any_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Zufʋ mgbain'n-mɔ bɔbɔ dɩɛ, bɛ nne bɛ nni man kɛ yɩ́ nyɩn'n sinlin daba, nan sian'n yɛ̂ yɩ́ nyɩn nɩn a tike ɔ. Ɛhɩ ati, bɛ kɔ fɛlɛ yɩ́ sɩ nʋn yɩ́ nin. ");
INSERT INTO any_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Bɛ́ nwan: “Ɛmɔ awa'n mɔ bɛ́ nwan yɩ́ nyɩn nɩn a sin'n, asʋ yɩ́ ahɩ? Ɔ yɔ sɛ m'ɔ nwun asɩ sian'n?” ");
INSERT INTO any_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Yɩ́ sɩ nʋn yɩ́ nin nwan: “Yɛ́ dɩɛ, yɛ sɩ kɛ yɛ́ wa nɩn ahɩ. Mɔ yɛ 'wʋ yɩ́'n, anɩn yɩ́ nyɩn nɩn a sin. ");
INSERT INTO any_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Nan kɛ ɔ kpɩnlɩn yɔlɩ dede mɔ yɩ́ nyɩn nɩn a tike'n, yɩ́ dɩɛ yɛ nzɩ man. Yɛ̂ sʋanlan'n mɔ ɔ'a tike yɩ́ nyɩn'n, yɛ nzɩ man yɩ́. Yɩ́ muonun yɛ̂ ɔ jin ɛbɛlɛ nɩn ɔ. Ɛmɔ bísa yɩ́, ɔ tɩ man batʋnman!” ");
INSERT INTO any_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Bɛ sulo Zufʋ mgbain'n-mɔ, yɩ́ ti yɛ̂ ɔ man bɛ lɛ kan kɛ bɛ nzɩ man nɩn ɔ. Afɩ Zufʋ mgbain'n-mɔ nwan sʋanlan m'ɔ kɔ se kɛ Zozi tɩ *Kilisi'n, bɛ 'fʋan yɩ́ bɛ́ asɔnɩn sua nɩn anun. ");
INSERT INTO any_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Yɩ́ sɔ ati yɛ̂ yɩ́ sɩ nʋn yɩ́ nin nwan ɔ tɩ man batʋnman nán bɛ bísa yɩ́ nɩn ɔ. ");
INSERT INTO any_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Ɛsɛ Falisifʋɛ'n-mɔ kɔ fɛlɛ bian'n biekun, bɛ́ nwan: “Nɩan Nyanmɩan ɛlɔ kan ananhɔlɛ. Nan yɛ́ dɩɛ, yɛ sɩ kɛ bian sɔ'n tɩ ɛtɛfʋɛ.” ");
INSERT INTO any_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Bian'n nwan: “Sɛ ɔ tɩ ɛtɛfʋɛ o, sɛ ɔ tɩ man ɛtɛfʋɛ o, mɩ́n dɩɛ, mɩn nzɩ man. Mɩ́n dɩɛ mɔ mɩn sɩ'n y'ɔ le kɛ daba mɩn nnwun man asɩ, nan sian dɩɛ, mɩn nwun asɩ.” ");
INSERT INTO any_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Bɛ́ nwan: “Anɩn ɔ yɔlɩ sɛ kpa yɛ̂ ɔ tikelɩ wɔ́ nyɩn nɩn ɔ?” ");
INSERT INTO any_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Bian'n nwan: “M'an han m'an hele ɛmɔ daba angʋnmɩn, nan ɛmɔ a ndie man. Ɔ yɔ sɛ mɔ ɛmɔ kulo kɛ mɩn kan yɩ́ biekun ɔ? Ɛmɔ kʋsʋ kulo kɛ bɛ yɔ yɩ́ menian ɔ?” ");
INSERT INTO any_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Ɔ hanlɩn sɔ ala, Falisifʋɛ'n-mɔ kɔ bɔ yɩ́ amgba kpa. Bɛ́ nwan: “Wɔ́ yɛ̂ ɛ tɩ sʋanlan sɔ'n sʋanlan ɔ, nan yɛ́ dɩɛ yɛ tɩ *Moyizɩ menian. ");
INSERT INTO any_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Moyizɩ yɛ̂ yɛ sɩ kɛ Nyanmɩan jʋjɔlɩ helelɩ yɩ́ ɔ. Nan sʋanlan ɛhɩ dɩɛ, lɩka bɔbɔ m'ɔ fi'n, yɛ nzɩ man.” ");
INSERT INTO any_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Bian'n nwan: “Nzukɛ asinbɛnwʋn ɛjɔlɛ dɩɛ ahɩ? Ɛmɔ nzɩ man lɩka m'ɔ fi'n kʋsʋ ɔ'a tike mɩ́n nyɩn'n! ");
INSERT INTO any_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Yɛ sɩ kɛ ɛtɛfʋɛ'n-mɔ, Nyanmɩan ndie man bɛ́. Nan menian mɔ bɛ́ nyɩn sɔ yɩ́ mɔ bɛ yɔ like m'ɔ kulo'n yɛ̂ ɔ tie bɛ́ ɔ. ");
INSERT INTO any_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Sʋanlan mɔ bɛ 'wʋ yɩ́ a, anɩn yɩ́ nyɩn nɩn a sin'n, yɛ tɩlɩ man kɛ sʋanlan a tike bie anyɩn'n lé. ");
INSERT INTO any_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Nan sɛ bian ɛhɩ tɩ man Nyanmɩan sʋanlan an, ahan ɔ ngʋala man like fɩ́ɩ́ yɔ.” ");
INSERT INTO any_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Bɛ́ nwan: “Wɔ́ mɔ wɔ́ busuɔfʋɛ nyɔlɩɛ nɩn ati b'a wʋ wɔ́ anyɩnsinlinwafʋɛ'n, wɔ́ lɩlɩ ɛ 'ba hele yɛ́ ngɛlɛ?” Bɛ kɔ fʋan bian'n bɛ́ asɔnɩn sua nɩn anun. ");
INSERT INTO any_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Zozi kɔ tɩ kɛ b'a fʋan bian'n bɛ́ asɔnɩn sua nɩn anun, ɔ kɔ nwun yɩ́, yɩ́ nwan: “Asʋ *Mân Baa'n, ɛ de yɩ́ di ɔ?” ");
INSERT INTO any_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Bian'n nwan: “Yɛmɩnlɩn, kele mɩ́n sʋanlan sɔ'n maan n né yɩ́ n ní.” ");
INSERT INTO any_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Zozi nwan: “Wɔ́ nyɩn tua yɩ́. Yɩ́ yɛ̂ ɔ lɛ jʋjɔ kele wɔ́ nɩn ɔ.” ");
INSERT INTO any_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Bian'n nwan: “Mɩ́n Mɩn, mɩn de mɩn di.” Ɔ kɔ kʋtʋ Zozi anyunnun ɛbɛlɛ. ");
INSERT INTO any_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Zozi nwan: “Ndɛɛ ebua nɩn ati yɛ̂ m malɩ ɔ. Mɩn 'ba nán mɩn man bɛ́ mɔ bɛ́ nyɩn a sin'n nwun asɩ. Yɛ̂ bɛ́ mɔ bɛ nwun asɩ'n kʋsʋ, mɩn man bɛ́ nyɩn'n sin.” ");
INSERT INTO any_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Anɩn *Falisifʋɛ'n mmie-mɔ nʋn yɩ́ wɔ ɛbɛlɛ. Mɔ bɛ tɩlɩ ɛjɔlɛ'n mɔ Zozi hanlɩn'n, bɛ kɔ bisa yɩ́ kɛ: “Yɩ́ ti, anɩn yɛ́ kʋsʋ yɛ́ nyɩn a sin?” ");
INSERT INTO any_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Zozi nwan: “Sɛ ɔ tɩ kɛ ɛmɔ anyɩn a sin an, ahan ɛmɔ nyɔ man ɛtɛ. Nan kɛmɔ ɛmɔ nwan bɛ nwun asɩ'n, yɩ́ ti yɛ̂ ɔ man ɛmɔ tɛ wɔ bɛ́ ɛtɛ nɩn anun ɔ.” ");
INSERT INTO any_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Ɛhɩ, mɔ Zozi hanlɩn sɔ helelɩ Falisifʋɛ'n-mɔ yuelɩ'n, ɛsɛ ɔ kɔ tʋ sʋ kɛ: “Mɩɩn kan yɩ́ ananhɔlɛ mɩn kele ɛmɔ kɛ, sʋanlan mɔ ɔ 'wʋlʋ mmʋa'n-mɔ tola nɩn anun an, ɔ nzɩn man anʋan nɩn anun, nan ɔ bu lɩka fʋfɔlɛ ɔ wʋlʋ tola nɩn anun'n, sʋanlan sɔ'n, anɩn ɔ tɩ awofʋɛ, kodiawu y'ɔ le yɩ́. ");
INSERT INTO any_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Nan sʋanlan m'ɔ kɔ sɩn anʋan nɩn anun'n, yɩ́ yɛ̂ ɔ tɩ bʋa ɛnɩanfʋɛ kpa nɩn ɔ. ");
INSERT INTO any_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Yɩ́ dɩɛ sɛ ɔ 'wʋlʋ tola nɩn anun an, sʋanlan'n m'ɔ sisa tola'n tike anʋan'n man yɩ́, yɛ̂ mmʋa'n-mɔ kʋsʋ tɩ yɩ́ nɩn'n. Bʋa ɛnɩanfʋɛ'n fa mmʋa'n-mɔ anun kʋn biala dunman'n fɛlɛ yɩ́ ɛsɛ ɔ fa bɛ́ fite awulo. ");
INSERT INTO any_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Mɔ bɛ́ kʋalaa bɛ kɔ yue fite'n, ɔ li bɛ́ nyunnun yɛ̂ mmʋa'n-mɔ si yɩ́ sʋ ɔ. Ɔ sanlɩn kɛ mmʋa'n-mɔ sɩ yɩ́ nɩn'n. ");
INSERT INTO any_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Sʋanlan mɔ bɛ nzɩ man yɩ́'n, bɛ nzi man yɩ́ sʋ lé. Sɛ bɛ nwun yɩ́ a, bɛ nwanndi yɩ́, ɔ sanlɩn kɛ bɛ nzɩ man yɩ́ nɩn'n.” ");
INSERT INTO any_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Zozi buli anyɩnndala sɔ'n helelɩ bɛ́, kʋsʋ b'a ndɩ man yɩ́ bʋ. ");
INSERT INTO any_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Kɛmɔ b'a ndɩ man yɩ́ bʋ nɩn ati, Zozi kɔ han kɔ hele bɛ́ biekun kɛ: “Mɩɩn kan yɩ́ ananhɔlɛ mɩn kele ɛmɔ kɛ, mmʋa'n-mɔ tola nɩn anʋan'n y'ɔ le mɩ́n. ");
INSERT INTO any_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Bɛ́ kʋalaa mɔ bɛ lili mʋa mɩ́n nyunnun'n, awofʋɛ nʋn kodiawu y'ɔ le bɛ́. Yɛ̂ mmʋa'n-mɔ a ndie man bɛ́ nɩn'n bɔbɔ. ");
INSERT INTO any_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Anʋan'n y'ɔ le mɩ́n. Sʋanlan m'ɔ kɔ wʋlʋ mɩ́n nun'n, ɔ 'nyan ngʋan. Ɔ kʋala ɔ wʋlʋ fite kɛ ɔ kulo ɔ, ɛsɛ ɔ 'nyan like di. ");
INSERT INTO any_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Awofʋɛ'n-mɔ dɩɛ, mmʋa'n-mɔ awue, nʋn bɛ́ ehuan, nʋn bɛ́ bʋsʋ ɛbɔ ati ala yɛ̂ bɛ ba ɔ. Nan mɩ́n dɩɛ, m malɩ kɛ m 'ba maan menian'n-mɔ nyan ngʋan, mɩn man bɛ nyan yɩ́ dede ɔ bʋ sʋ. ");
INSERT INTO any_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Bʋa ɛnɩanfʋɛ kpa'n y'ɔ le mɩ́n. Bʋa ɛnɩanfʋɛ kpa'n, ɔ de yɩ́ mmʋa'n-mɔ ati ewue ɔ wu maan bɛ nyan ngʋan. ");
INSERT INTO any_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Sʋanlan m'ɔ tɩ man bʋa ɛnɩanfʋɛ kpa'n, mɔ yɩ́ dɩɛ ɔ kan mmʋa'n-mɔ ɔ kpʋnndɛ yɩ́ esika'n, sɛ ɔ nwun kɛ bedi'n lɛ ba a, ɔ yaci mmʋa'n-mɔ ɛbɛlɛ nwanndi maan bedi'n wʋlʋ bɛ́ nun ɔ cɩ bie ɔ bɔ bɛ́ asanndɩɛ. ");
INSERT INTO any_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Sʋanlan sɔ'n yaci mmʋa'n-mɔ ɛbɛlɛ nwanndi, ɔ sanlɩn kɛ yɩ́ esika ɛkpʋnndɛ ati yɛ̂ ɔ lɛ kɩkan bɛ́ ɔ. Bɛ́ nwʋn njian man yɩ́. ");
INSERT INTO any_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Bʋa ɛnɩanfʋɛ kpa'n y'ɔ le mɩ́n. Mɩn sɩ mɩ́n mmʋa'n-mɔ, bɛ́ kʋsʋ bɛ sɩ mɩ́n ");
INSERT INTO any_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","kɛ mɩ́n Sɩ sɩ mɩ́n mɔ mɩ́n kʋsʋ mɩn sɩ yɩ́'n. Mɩn wu mɩ́n mmʋa'n-mɔ dunman nun mɩn man bɛ nyan ngʋan. ");
INSERT INTO any_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","N ne mmʋa mmiekun-mɔ, bɛ nnʋn man tola ɛhɩ anun bie. Ɔ sɛ kɛ n gókuan bɛ́ nʋan. Bɛ 'ba tɩ mɩ́n nɩn'n. Mmʋa kpule'n 'ba yɔ kʋn. Yɛ̂ sʋanlan kʋsʋ kʋn yɛ̂ ɔ 'nɩan bɛ́ sʋ ɔ. ");
INSERT INTO any_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“Mɩ́n Sɩ kulo mɩ́n, ɔ sanlɩn kɛ mɩn fa mɩ́n ngʋan'n mɩn man nán m'an nyan yɩ́ biekun. ");
INSERT INTO any_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Sʋanlan fɩ́ɩ́ ngʋala man kɛ ɔ tʋa mɩ́n de mɩ́n ngʋan nɩn ɔ. Mɩ́n muonun yɛ̂ mɩn fa mɩn man ɔ. Mɩn kʋala kɛ mɩn fa mɩ́n ngʋan'n mɩn man, ɛsɛ mɩn kʋala kɛ mɩn nyan yɩ́ biekun. Like mɔ mɩ́n Sɩ nwan n yɔ́ nɩn anɩn.” ");
INSERT INTO any_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Ɛhɩka kʋsʋ anwʋn, Zufʋ'n-mɔ anʋan a nzɛ man. ");
INSERT INTO any_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Mmie-mɔ dɔʋn nwan: “Sʋanlan'n mɔ wawɛ ɛtɛ wɔ yɩ́ nun mɔ yɩ́ ti nnʋn man ɛbɛlɛ'n, nzukɛ ati yɛ̂ ɛmɔ lɛ tie yɩ́ ɛjɔlɛ nɩn ɔ?” ");
INSERT INTO any_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Mmie-mɔ kʋsʋ nwan: “Sʋanlan mɔ wawɛ ɛtɛ wɔ yɩ́ nun'n, ɛjɔlɛ sʋa, ɔ ngʋala man yɩ́ kan. Asʋ sʋanlan mɔ wawɛ ɛtɛ wɔ yɩ́ nun'n kʋala anyɩnsinlinwafʋɛ anyɩn tike?” ");
INSERT INTO any_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Ɛhɩ, ɛyɛlɛ mɛlɛ nɩn anun, mɔ bɛ 'di Nyanmɩan awulo nɩn anwʋn *Anwʋntɩɛ fɛtɩ'n wɔ Zoluzalɛmʋn'n, ");
INSERT INTO any_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","anɩn Zozi nanndɩ Nyanmɩan awulo nɩn abalanda'n mɔ bɛ fɛlɛ yɩ́ Salomʋn abalanda nɩn anun. ");
INSERT INTO any_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Zufʋ'n-mɔ kɔ yia yɩ́ nwʋn ɛbɛlɛ, bɛ́ nwan: “Cɩan benin kpa bɔbɔ yɛ̂ ɛ 'man yɛ́ ahʋnlɩn tɔ yɛ́ kunnun ɔ? Sɛ *Kilisi'n, yɛ́ Belemgbin Ngʋandefʋɛ'n y'ɔ le wɔ́ a, kan yɩ́ ananhɔlɛ kele yɛ́.” ");
INSERT INTO any_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Zozi nwan: “M'an han m'an hele ɛmɔ daba, nan ɛmɔ nne nni man. Junman'n mɔ mɩn di wɔ mɩ́n Sɩ dunman nun'n di mɩ́n adanzɩɛ. ");
INSERT INTO any_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Nan kɛmɔ ɛmɔ nnʋn man mɩ́n mmʋa'n-mɔ anun bie nɩn ati, ɛmɔ nne mɩ́n nni man. ");
INSERT INTO any_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Mɩ́n mmʋa'n-mɔ tie mɩ́n nɩn'n, mɩn sɩ bɛ́ yɛ̂ bɛ si mɩ́n sʋ. ");
INSERT INTO any_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Mɩn man bɛ́ ngʋan m'ɔ le man ayuelɩɛ. Bɛ nwu man lé, yɛ̂ sʋanlan fɩ́ɩ́ ngʋala man bɛ́ de fi mɩ́n sa nun. ");
INSERT INTO any_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Mɩ́n Sɩ mɔ ɔ'a fa bɛ́ ɔ'a man mɩ́n'n, ɔ tɩ kpili tala ninnge'n kʋalaatin. Ninnge'n mɔ mɩ́n Sɩ le yɩ́'n, sʋanlan ngʋala man kɛ ɔ tʋa yɩ́ de bie ɔ. ");
INSERT INTO any_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Mɩn nʋn mɩ́n Sɩ, yɛ tɩ sʋanlan munmuan kʋn.” ");
INSERT INTO any_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Ɛhɩ mɔ Zozi hanlɩn nɩn ati, Zufʋ'n-mɔ kɔ sɩsa nyɔbʋɛ biekun kɛ bɛ 'kɔ a hun yɩ́. ");
INSERT INTO any_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Ɛhɩ a, Zozi nwan: “Mɩ́n Sɩ a man mɩ́n tunmin maan m'an li junman dɔʋn kpa m'an hele ɛmɔ, nan nunhan benin ati yɛ̂ ɛmɔ kulo kɛ bɛ 'tʋtʋ nyɔbʋɛ bɛ kun mɩ́n ɔ?” ");
INSERT INTO any_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Zufʋ'n-mɔ nwan: “Nán kɛ junman kpa bie mɔ a li ati yɛ̂ yɛ́ nwan yɛ 'kun wɔ́ ɔ, nan a han amannɩɛ ɛjɔlɛ wɔ Nyanmɩan anyunnun. Ɔ sanlɩn kɛ kulo sʋanlan mgban tɩ kɛ wɔ́, ɛ bu wɔ́ nwʋn kɛ ɛ tɩ Nyanmɩan.” ");
INSERT INTO any_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Zozi nwan: “B'a hɛlɛ wɔ ɛmɔ mala kalata nɩn anun kɛ Nyanmɩan nwan: Ɛmɔ tɩ kɛ mɩ́n Nyanmɩan muonun. ");
INSERT INTO any_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Ɛjɔlɛ kʋsʋ mɔ Nyanmɩan Ɛhɛlɛ Ɛjɔlɛ'n kɔ han'n, yɛ ngʋala man nun kpɛ. Yɛ sɩ kɛ bɛ́ mɔ Nyanmɩan a fɛlɛ bɛ́ ɔ'a fa yɩ́ Nʋan Ɛjɔlɛ'n ɔ'a wula bɛ́ sa nun'n, yɩ́ nwan bɛ tɩ kɛ yɩ́. ");
INSERT INTO any_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Nan sɛ ɔ tɩ sɔ sakpa a, anɩn mɩ́n kʋsʋ mɔ Sɩɛ nɩn a sie mɩ́n kʋnlʋn-ngʋnlʋn mɔ ɔ'a sʋan mɩ́n kɛ m mála mân nɩn anun'n, sɛ mɩn kan kɛ n dɩ Nyanmɩan Awa a, anɩn m'an nyan amannɩɛ ɔ? Ɔ yɔ sɛ mɔ ɛmɔ kan kɛ m'an han ɛjɔlɛ ɛtɛ m'an tia Nyanmɩan ɔ? ");
INSERT INTO any_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Sɛ mɩn nni man junman'n mɔ mɩ́n Sɩ kulo nɩn an, ɛmɔ nán bɛ de mɩ́n bɛ di. ");
INSERT INTO any_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Nan sɛ mɩn di junman sɔ'n, sɛ ɛmɔ nne man mɩ́n nni man bɔbɔ a, ɛmɔ lé nyɔlɩɛ'n-mɔ mɔ mɩn yɔ'n lɩlɩ bɛ lí, nán ɛmɔ a nwun kɛ mɩ́n Sɩ wɔ mɩ́n nun yɛ̂ mɩ́n kʋsʋ n wɔ yɩ́ nun.” ");
INSERT INTO any_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Mɔ Zozi hanlɩn sɔ yuelɩ'n, bɛ 'kpʋnndɛ bɛ cɩ yɩ́ biekun. Ɔ fi bɛ́ nun ɛbɛlɛ ɔ kɔ nwanndi, bɛ́ sa a ngan man yɩ́. ");
INSERT INTO any_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Ɛhɩ anzin, Zozi kɔ sa kɔ hɔ asue Zuludɩn nɩn anzin ɛlɔ biekun. Ɔ kɔ hɔ kɔ tanlan lɩka mɔ Zʋan sɔnɩnlɩn menian'n-mɔ daba'n. ");
INSERT INTO any_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Menian dɔʋn kpa kɔ kpʋ yɩ́ ɛlɔ, bɛ́ nwan: “Zʋan a nyɔ man asinbɛnwʋn like fɩ́ɩ́, nan kʋsʋ bian ɛhɩ anwʋn ɛjɔlɛ m'ɔ hanlɩn'n, ɔ tɩ ananhɔlɛ.” ");
INSERT INTO any_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Ɛbɛlɛ, menian dɔʋn lelɩ yɩ́ lili. ");
INSERT INTO any_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Anɩn bian kʋn wɔ Betanin kulo nɩn asʋ, bɛ fɛlɛ yɩ́ Lazaa. Lazaa sɔ'n nʋn yɩ́ nianman mmalasua nnyuan yɛ̂ bɛ tɩ Betanin ɛbɛlɛ ɔ. Kʋn li Mali yɛ̂ kʋn kʋsʋ li Maatɩ. ");
INSERT INTO any_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Mali sɔ'n, yɩ́ yɛ̂ ɔ 'ba fa anatɩlɩ ɔ nwunnzin yɛ́ Mɩn aja'n-mɔ anwʋn, ɛsɛ ɔ fa yɩ́ ti enyuan'n ɔ cici nɩn ɔ. Bɛ wɔ ɛbɛlɛ dede a, cɩan kʋn Lazaa kɔ fʋkɛ. ");
INSERT INTO any_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Yɩ́ nianman mmalasua nnyuan'n kɔ yɩ sʋanlan kɔ hɔ kɔ tʋ Zozi. Yɩ́ nwan: “Yɛ́ Mɩn, wɔ́ manngʋn'n mɔ ɛ kulo yɩ́'n nɩn a fʋkɛ. Yɩ́ ti, yɩ́ nianman mmala'n-mɔ nwan m mála m mɔ́ wɔ́ amannɩɛ.” ");
INSERT INTO any_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Mɔ Zozi tɩlɩ ɛjɔlɛ sɔ'n, yɩ́ nwan: “Lazaa ɛfʋkɛ'n mɔ ɔ'a fʋkɛ'n, ɔ tɩ man ɛfʋkɛ mɔ ɔ 'kun yɩ́ ɔ. Nan ɔ nanndɩ yɩ́ ɛfʋkɛ sɔ nɩn asʋ, Nyanmɩan 'ba man yɩ́ Wa'n yɩ yɩ́ tunmin'n nʋn yɩ́ anunminnyanmʋn'n kele mân'n.” ");
INSERT INTO any_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Zozi kulo Lazaa nʋn yɩ́ nianman mmalasua'n-mɔ kpa, nan kʋsʋ, ");
INSERT INTO any_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","m'ɔ tɩlɩ kɛ Lazaa a fʋkɛ'n, ɔ lili cɩan nnyuan biekun yɩ́ bʋsʋ ɛbɛlɛ. ");
INSERT INTO any_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Yɩ́ cɩan nnyuan nɩn asʋ, ɔ kɔ han kɔ hele yɩ́ menian'n-mɔ kɛ: “Bɛ mán yɛ sá yɛ hɔ́ Zude mân nɩn anun ɛlɔ biekun.” ");
INSERT INTO any_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","M'ɔ hanlɩn sɔ'n, yɩ́ menian'n-mɔ nwan: “Kpain, ɔ hyɛlɩ man fɩ́ɩ́ yɛ hɔlɩ ɛlɔ ahan bɛ 'tʋtʋ ɛbʋɛ bɛ kun wɔ́, yɛ̂ ɛsɛ wɔ́ nwan yɛ hɔ́ ɛlɔ biekun'n?” ");
INSERT INTO any_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Zozi nwan: “Alɩ́ɛ kʋn m'ɔ kɔ hɩn'n, nán dɔɛ bulu nʋn nnyuan yɛ̂ ɔ wɔ nun ɔ? Sʋanlan m'ɔ nanndɩ alɩhɩan nɩn anun'n, yɩ́ ja mgbula man, ɔ sanlɩn kɛ mân nɩn anun tɩ yuein. ");
INSERT INTO any_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Nan sʋanlan m'ɔ nanndɩ kɔngɔɛ'n, yɩ́ ja kpula ɔ tɔ asɩ, ɔ sanlɩn kɛ awosin nɩn anun, sʋanlan nnwun man asɩ.” ");
INSERT INTO any_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","M'ɔ hanlɩn sɔ yuelɩ'n, ɛsɛ yɩ́ nwan: “Yɛ́ manngʋn Lazaa a lafɩ, yɩ́ ti, mɩn 'kɔ a tinnge yɩ́.” ");
INSERT INTO any_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Yɩ́ menian'n-mɔ nwan: “Sɛ nafɛlɛ ala yɛ̂ ɔ lɛ dafɩ a, anɩn yɛ 'kɔ a yɔ nzu? Ɔ 'ba jasʋ.” ");
INSERT INTO any_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Ɛjɔlɛ sɔ'n mɔ Zozi hanlɩn'n kele kɛ Lazaa a wu, nan kʋsʋ yɩ́ menian'n-mɔ dɩɛ, bɛ jʋnlɩn kɛ nafɛlɛ mgban yɛ̂ ɔ lɛ dafɩ ɔ. ");
INSERT INTO any_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Yɩ́ sɔ ati, Zozi kpacɩlɩ nun hanlɩn helelɩ bɛ́ yuein kɛ: “Lazaa a wu. ");
INSERT INTO any_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Ɛmɔ dunman nun ati, ɔ yɔ mɩ́n fɛ kpa kɛ m'an ngɔ man ɛlɔ ndɛ ɔ. Ɔ sanlɩn kɛ yɩ́ ewue nɩn anzin ɛjɔlɛ mɔ ɔ 'ba a'n, ɔ 'ba man ɛmɔ de mɩ́n di. Nan ɛmɔ mán yɛ hɔ́ ɛlɔ.” ");
INSERT INTO any_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Kɛ yɩ́ nʋan 'tɔ ala, yɩ́ menian'n-mɔ anun kʋn, bɛ fɛlɛ yɩ́ Toma, bɛ fɛlɛ yɩ́ biekun Didimʋn, yɩ́ bʋ y'ɔ le kɛ nda, ɔ kɔ jasʋ, yɩ́ nwan: “Mɩ́n manngʋn-mɔ, sɛ yɩ́ sɔ a, bɛ mán yɛ́ kʋsʋ yɛ hɔ́ bie maan bɛ hún yɛ́ kʋalaa.” Kɛ ɔ hanlɩn sɔ yuelɩ'n, yɛ̂ bɛ hɔlɩ ɔ. ");
INSERT INTO any_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Mɔ Zozi 'ju Betanin'n, anɩn b'a sie Lazaa ɔ'a li ɛlɛ nnan. ");
INSERT INTO any_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Betanin nʋn Zoluzalɛmʋn kʋsʋ afian a nwa man. Cilo nsan yɛ̂ ɔ wɔ bɛ́ afian ɔ. ");
INSERT INTO any_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Yɩ́ ti, ɔ man Zufʋ'n-mɔ dɔʋn fi Zoluzalɛmʋn bɛ walɩ Betanin kulo nɩn asʋ ɛbɛlɛ, bɛ 'ba a cɩcɩ Maatɩ nʋn Mali alʋa. ");
INSERT INTO any_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Mɔ Maatɩ tɩlɩ kɛ Zozi lɛ ba'n, ɔ hɔlɩ kpalɩ yɩ́ atɩn. Mali dɩɛ, ɔ halɩ awulo ɛbɛlɛ. ");
INSERT INTO any_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Mɔ Maatɩ tʋlɩ Zozi'n, yɩ́ nwan: “Yɛ́ Mɩn, sɛ ɔ tɩ kɛ ɛ wɔ ɛwa a, ahan mɩ́n nianman nɩn a nwu man. ");
INSERT INTO any_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Nan kʋsʋ mɩn sɩ kɛ kɩkaala mɔ yɛ wɔ nun'n muonun, like biala mɔ ɛ kɔ bisa Nyanmɩan'n, ɔ 'fa man wɔ́.” ");
INSERT INTO any_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Zozi nwan: “Wɔ́ nianman'n, ɔ 'ba jasʋ.” ");
INSERT INTO any_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Maatɩ nwan: “Mɩn sɩ kɛ cɩan mɔ mân'n kɔ yue'n, mɩ́n nianman'n fi ewue nun 'jasʋ.” ");
INSERT INTO any_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Zozi nwan: “Sʋanlan'n m'ɔ cɩn menian ɔ man bɛ́ ngʋan'n y'ɔ le mɩ́n. M'ɔ kɔ le mɩ́n kɔ li'n, sɛ ɔ wu bɔbɔ a, ɔ 'nyan ngʋan. ");
INSERT INTO any_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Yɛ̂ sʋanlan mɔ yɩ́ anyɩnwɔsʋɛ nun ɔ kɔ le mɩ́n kɔ li'n, ɔ nwu man kʋ́n lé. Asʋ ɛ de ɛjɔlɛ sɔ'n di ɔ?” ");
INSERT INTO any_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Maatɩ nwan: “Yuo o, mɩn de mɩn di kɛ *Kilisi'n y'ɔ le wɔ́, Nyanmɩan Awa'n m'ɔ sɛ kɛ ɔ ba mân nɩn anun'n y'ɔ le wɔ́.” ");
INSERT INTO any_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Mɔ Maatɩ hanlɩn sɔ yuelɩ'n, ɔ kɔ sa kɔ hɔ awulo kɔ tu yɩ́ nianman bala Mali asule, yɩ́ nwan: “Yɛ́ Mɩn a a, yɩ́ nwan ɛ bála.” ");
INSERT INTO any_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Mɔ Mali tɩlɩ ɛjɔlɛ sɔ'n, ɔ kɔ jasʋ, ɔ kɔ fa atɩn'n, ɔ lɛ kpʋ Zozi. ");
INSERT INTO any_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Anɩn Zozi wʋlʋlɩ man kulo nɩn anun, lɩka kʋnmgba'n mɔ Maatɩ yacili yɩ́'n, ɛbɛlɛ yɛ̂ ɔ halɩ ɔ. ");
INSERT INTO any_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Mɔ Zufʋ'n-mɔ mɔ bɛ gua awulo ɛbɛlɛ bɛ lɛ cɩcɩ Mali alʋa'n nwunlin kɛ ɔ'a jasʋ, ɔ lɛ kɔ ndɛ-ndɛ'n, bɛ́ kʋsʋ bɛ kɔ jasʋ bɛ kɔ si yɩ́ sʋ. Bɛ jʋnlɩn kɛ Mali lɛ kɔ sɛka nɩn asʋ ɛlɔ 'kɔ sun. ");
INSERT INTO any_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Mɔ Mali juli lɩka mɔ Zozi jin'n, ɔ kɔ kʋtʋ yɩ́ nyunnun ɛbɛlɛ, yɩ́ nwan: “Yɛ́ Mɩn, sɛ ɔ tɩ kɛ ɛ wɔ ɛwa a, ahan mɩ́n nianman nɩn a nwu man.” ");
INSERT INTO any_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Kɛ Mali 'kan sɔ nɩn ala, ɔ kɔ sɩsa yɩ́ sa kɔ gua yɩ́ ti ɔ nʋn Zufʋ'n-mɔ kʋalaa bɛ lɛ yɩ awɔ́lɛ. Mɔ Zozi nwunlin kɛ bɛ lɛ yɩ awɔ́lɛ'n, ewue nɩn anwʋn ɛya kɔ hun yɩ́ dede yɩ́ nwʋn kɔ wʋsʋ yɩ́. ");
INSERT INTO any_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Yɩ́ nwan: “Ɛmɔ sielɩ yɩ́ nin?” Bɛ́ nwan: “Yɛ́ Mɩn, bala ba nɩan.” ");
INSERT INTO any_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Mɔ bɛ falɩ atɩn'n mɔ bɛ 'kɔ'n, anɩn Zozi anyɩn ɛmʋɩn lɛ ba. ");
INSERT INTO any_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Ɛbɛlɛ ala, Zufʋ'n-mɔ anun mmie-mɔ nwan: “Ɛmɔ nɩ́an, ɔ kulo Lazaa ɛjɔlɛ kpa o!” ");
INSERT INTO any_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Mmie-mɔ kʋsʋ nwan: “Yɩ́ m'ɔ tikelɩ anyɩnsinlinwafʋɛ nɩn anyɩn'n, ahan ɔ yɔlɩ maan Lazaa a wu man” ");
INSERT INTO any_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Mɔ bɛ hanlɩn sɔ'n, Zozi kɔ fɛ ɛya kpa, ɔ kɔ kpɩnlɩn yɩ́ konvin abʋ. Ɔ fi ɛbɛlɛ yɩ́ nʋan y'ɔ le sɛka nɩn asʋ. Sɛka sɔ'n, b'a koto yɩ́ bʋka kʋn anun, b'a kpɛ anʋan kʋn b'a tʋ yɩ́ nwʋn kɛ sua yɛ̂ b'a kunndo ɛbʋɛ kpili kʋn b'a fa b'a nyin yɩ́ anʋan. ");
INSERT INTO any_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Zozi nwan: “Ɛmɔ yɩ́ ɛbʋɛ'n m'ɔ nyin anʋan'n.” Mɔ Zozi anʋan tɔlɩ'n, Maatɩ nwan: “Yɛ́ Mɩn, kɛ yɛ wɔ nun'n, mɩn jʋnlɩn kɛ ɔ lɛ ban. Ɔ sanlɩn kɛ, kɛ bɛ sielɩ yɩ́'n, yɩ́ ɛlɛ nnan ahɩ.” ");
INSERT INTO any_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Zozi nwan: “M'an ngan m'an ngele man wɔ́ kɛ sɛ ɛ de di a, ɛ 'nwun Nyanmɩan anunminnyanmʋn nɩn ɔ?” ");
INSERT INTO any_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Ɛhɩ a, bɛ kɔ kunndo ɛbʋɛ'n m'ɔ nyin anʋan'n. Zozi kɔ tʋ yɩ́ ti anwunno, yɩ́ nwan: “Mɩ́n Sɩ, mɩn 'da wɔ́ asɩ kɛ a tie mɩ́n ɛjɔlɛ nɩn ɔ. ");
INSERT INTO any_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Mɩn sɩ kɛ ɛ tie mɩ́n dahuu, nan kɛ ɛ kɔ yɔ nán bɛ́ mɔ b'a ta b'a si b'a yia mɩ́n nɩn a le a li kɛ wɔ́ yɛ̂ ɛ sʋanlɩn mɩ́n'n, yɩ́ ti yɛ̂ ɔ man mɩɩn kan sɔ ɔ.” ");
INSERT INTO any_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Mɔ Zozi hanlɩn sɔ yuelɩ'n, ɔ tɩanlɩn nun sɛlɛ kpa, yɩ́ nwan: “Lazaa, fi ɛlɔ fite!” ");
INSERT INTO any_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Ɛbɛlɛ ala, Lazaa fi sɛka nɩn anun kɔ fite. Ɔ 'fite a, anɩn ɛtanlan'n mɔ bɛ falɩ bɛ sielɩ yɩ́'n tɛ fʋfɔ yɩ́ nwʋn. M'ɔ fitelɩ'n, Zozi nwan: “Ɛmɔ nyánnjɩ yɩ́ nwʋn ɛtanlan'n, nán bɛ yáci yɩ́ maan ɔ hɔ́.” ");
INSERT INTO any_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Asinbɛnwʋn like sɔ'n mɔ Zozi yɔlɩ'n, ɔ man Zufʋ'n-mɔ mɔ bɛ walɩ Mali alʋa ɛcɩcɩɛ'n, bɛ́ dɔʋn bɛ lelɩ yɩ́ bɛ lili. ");
INSERT INTO any_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Bɛ́ nun mmie-mɔ kʋsʋ hɔlɩ tʋlɩ *Falisifʋɛ'n-mɔ bɛ hanlɩn like sɔ'n mɔ Zozi yɔlɩ'n helelɩ bɛ́. ");
INSERT INTO any_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Ɛhɩ a, Falisifʋɛ'n-mɔ nʋn Nyanmɩan *tɛɛyɩfʋɛ mgbain'n-mɔ kɔ bʋbɔ Zufʋ mgbain abulasʋ'n mɔ bɛ di bɛ́ mân nɩn anun ɛjɔlɛ nɩn amannɩɛ, bɛ́ kʋalaa bɛ kɔ yia, bɛ́ nwan: “Bian ɛhɩ muonun, yɛ 'yɔ yɩ́ sɛ? Asinbɛnwʋn ninnge m'ɔ lɛ yɔ'n tɩ man nzɛmɩndɛ. ");
INSERT INTO any_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Sɛ yɛ yaci yɩ́ maan ɔ di junman sɔ ɛhɩ a, menian'n-mɔ kʋalaa 'ba le yɩ́ di, ɛsɛ ɔ 'ba man *Lɔmʋn mgbain'n-mɔ kpati sɛcɩ Nyanmɩan awulo'n nʋn yɛ́ mân'n!” ");
INSERT INTO any_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Bɛ́ nʋan a ndɔ man, bɛ́ nun kʋn kɔ jasʋ, bɛ fɛlɛ yɩ́ Kayifʋ. Afʋɛ sɔ nɩn anun, yɩ́ yɛ̂ anɩn ɔ tɩ *Tɛɛyɩfʋɛ Kpain nɩn ɔ. Yɩ́ nwan: “Ɛmɔ ndɩ man ɛjɔlɛ bʋ fɩ́ɩ́! ");
INSERT INTO any_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Asʋ ɛmɔ nnwun man kɛ sɛ sʋanlan kʋn wu menian'n-mɔ kʋalaa ati a, ɔ tɩ kpa tala kɛ mân bɔndɩn'n kɔ bɔ ɔ?” ");
INSERT INTO any_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Ɛjɔlɛ'n mɔ Kayifʋ hanlɩn'n, nán kɛ yɩ́ muonun yɩ́ ngɛlɛ yɛ̂ anɩn ɔ lɛ fa kan sɔ ɔ. Nan kɛmɔ afʋɛ sɔ nɩn anun yɩ́ yɛ̂ anɩn ɔ tɩ tɛɛyɩfʋɛ kpain'n, yɩ́ sɔ ati yɛ̂ Nyanmɩan man ɔ hanlɩn kɛ ɔ di kɛ Zozi wu maan Izalayɛ mân nɩn anun menian-mɔ kʋalaa nyan bɛ́ ti ɔ. ");
INSERT INTO any_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Nán kɛ Izalayɛ mân nɩn anun menian'n-mɔ kʋnmgba ala yɛ̂ ɔ 'wu man bɛ́ ɔ, nan ɔ 'wu nán ɔ kokuan Nyanmɩan amma'n-mɔ kʋalaa mɔ b'a bɔ asanndɩɛ nɩn anʋan. ");
INSERT INTO any_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Ɔ fi cɩan sɔ'n, Zufʋ mgbain'n-mɔ nwan bɛ 'kun Zozi. ");
INSERT INTO any_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Ɛhɩ ati, Zozi a nvite man bagua nun kʋ́n Zufʋ'n-mɔ afian. Ɔ nʋn yɩ́ menian'n-mɔ hɔlɩ kulo'n mɔ bɛ fɛlɛ yɩ́ Efalayimʋn nɩn asʋ. Ɔ mantan ɛwâ. Ɔ nʋn bɛ́, bɛ tanlanlɩn ɛbɛlɛ kaan. ");
INSERT INTO any_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","M'ɔ ka kaan nán Zufʋ'n-mɔ a li bɛ́ fɛtɩ'n mɔ bɛ fɛlɛ yɩ́ *Pakɩ'n, menian dɔʋn kpa lili mʋa Zoluzalɛmʋn bɛ hɔlɩ tuli bɛ́ nwʋn efian. ");
INSERT INTO any_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Mɔ bɛ wɔ Nyanmɩan awulo nɩn anun ɛbɛlɛ'n, anɩn bɛ lɛ kpʋnndɛ Zozi. Bɛ lɛ bisa bisa bɛ́ manngʋn'n-mɔ kɛ: “Ɔ tɩ sɛ, asʋ ɔ 'ba a fɛtɩ elie'n bie anaan ɔ ngɔ a man ɔ?” ");
INSERT INTO any_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Ɔ 'ba yɔ sɔ'n, anɩn Nyanmɩan tɛɛyɩfʋɛ mgbain'n-mɔ nʋn Falisifʋɛ'n-mɔ a man atɩn kɛ sʋanlan kʋn biala m'ɔ sɩ lɩka mɔ Zozi wɔ'n, ɔ héle bɛ́ maan bɛ hɔ́ hyɩ́ yɩ́. ");
INSERT INTO any_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Ɛhɩ, m'ɔ anɩn ɔ ka cɩan nsian nán b'a li Zufʋ'n-mɔ fɛtɩ'n mɔ bɛ fɛlɛ yɩ́ *Pakɩ'n, Zozi kɔ sa kɔ hɔ kulo'n mɔ bɛ fɛlɛ yɩ́ Betanin nɩn asʋ. Ɛbɛlɛ y'ɔ tinngelɩ Lazaa m'ɔ wuli'n fi ewue nun ɔ. ");
INSERT INTO any_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","M'ɔ juli ɛlɔ'n, yɩ́ alɩ́ɛ hɩnlɩn, nɔsʋba nun, yɩ́ manngʋn'n-mɔ kɔ tʋn alɩɛ bɛ kɔ fa bɛ kɔ sʋn yɩ́ ɛyɛfʋɛ. Anɩn Maatɩ lɛ sesie alɩɛ'n, bɛ́ mɔ bɛ lɩla tɔbɩlɩ nɩn anwʋn bɛ lɛ didi'n, Lazaa kʋsʋ wɔ bɛ́ nun bie. ");
INSERT INTO any_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Mmalasua'n-mɔ mɔ bɛ sesie alɩɛ'n, Mali kʋsʋ wɔ bɛ́ nun ɛbɛlɛ bie. M'ɔ bɛ didili dede mɔ ɔ 'kɔ bie'n, Mali kɔ hɔ kɔ fa anatɩlɩ bondoman kʋn. Anatɩlɩ sɔ'n, bɛ le baka bie bɛ fɛlɛ yɩ́ náá yɛ̂ bɛ fa bɛ yɔ ɔ. Yɩ́ gua yɔ sɩ kpa. Anatɩlɩ'n m'ɔ wɔ bondoman nɩn anun'n, ɔ tɩ elitili sin. Mali kɔ butu yɩ́ Zozi aja nɩn anwʋn, ɔ kɔ fa yɩ́ ti enyuan'n kɔ cici. Anatɩlɩ nɩn ɛfanlan'n kɔ fa sua nɩn anun. ");
INSERT INTO any_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Anɩn Zozi sʋanlan'n mɔ bɛ fɛlɛ yɩ́ Zudasɩ Isikaliɔtɩ wɔ ɛbɛlɛ. Yɩ́ yɛ̂ cian bie ɔ 'yɩ Zozi man ɔ. M'ɔ nwunlin yɩ́ sɔ'n, yɩ́ nwan: ");
INSERT INTO any_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Sɛ ɔ tɩ kɛ bɛ tɔnɩnlɩn anatɩlɩ ɛhɩ jɛtɛ fufue ɛya nsan yɛ̂ bɛ falɩ yɩ́ esika'n bɛ manlɩn ehianfʋɛ'n-mɔ a, ahan ɔ tɩ kpa.” ");
INSERT INTO any_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Nán kɛ ehianfʋɛ'n-mɔ anwʋn ɛjʋnlɩan m'ɔ jʋnlɩn ti yɛ̂ ɔ man ɔ lɛ kan sɔ ɔ, nan awofʋɛ y'ɔ le yɩ́. Esika kaan mɔ bɛ kɔ fa bɛ kɔ hye bɛ́'n, yɩ́ yɛ̂ ɔ fa sie ɔ. Bɛ fa bɛ man yɩ́ a, ɔ di. ");
INSERT INTO any_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Nan mɔ Zozi tɩlɩ ɛjɔlɛ'n mɔ Zudasɩ hanlɩn'n, yɩ́ nwan: “Yaci Mali maan ɔ yɔ́ yɩ́ like'n m'ɔ lɛ yɔ'n. Afɩ, anatɩlɩ ɛhɩ mɔ ɔ'a butu yɩ́ mɩ́n ja nɩn asʋ ɛwa'n, cɩan mɔ n gɔ wu'n, ebialɛ'n mɔ bɛ 'bia mɩ́n'n yɛ̂ ɔ lɛ di mʋa bia mɩ́n nɩn ɔ. ");
INSERT INTO any_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Ehianfʋɛ'n-mɔ dɩɛ, cɩan daa ɛmɔ nʋn bɛ́ wɔ ɛwa. Nan mɩ́n dɩɛ, mɩn nʋn ɛmɔ lɛ ndanlan man ɛwa dede ɔ nga man ɛbɛlɛ.” ");
INSERT INTO any_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Mɔ Zufʋ'n-mɔ dɔʋn tɩlɩ kɛ Zozi wɔ Betanin'n, bɛ kɔ kpʋ yɩ́ ɛlɔ. Kʋsʋ nán kɛ Zozi angʋnmɩn ati yɛ̂ bɛ hɔlɩ ɔ, nan bɛ́ nwan bɛ 'kɔ a nɩan Lazaa mɔ ɔ'a hɩn yɩ́'n. ");
INSERT INTO any_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Nyanmɩan *tɛɛyɩfʋɛ mgbain'n-mɔ nwan bɛ 'kun Lazaa kʋsʋ. ");
INSERT INTO any_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Ɔ sanlɩn kɛ yɩ́ dunman nun ati, Zufʋ'n-mɔ dɔʋn nzi man bɛ́ sʋ kʋ́n, nan Zozi yɛ̂ bɛ de yɩ́ bɛ di ɔ. ");
INSERT INTO any_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Zozi lalɩ Betanin, mɔ yɩ́ alɩ́ɛ hɩnlɩn'n, meninsʋnman'n mɔ bɛ walɩ *Pakɩ elie'n, bɛ kɔ tɩ kɛ Zozi lɛ ba Zoluzalɛmʋn. ");
INSERT INTO any_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Bɛ kɔ hɔ kɔ kpɩkpɛ aye malɛ, bɛ kɔ fa bɛ kɔ le Zozi atɩn. Bɛ 'kɔ a, anɩn bɛ lɛ tɩan bɛ tɛ bɛ fɛlɛ yɩ́. Bɛ́ nwan: “Hozanna! Nyanmɩan yíla Izalayɛ Belemgbin'n m'ɔ lɛ ba wɔ Yɛ́ Mɩn Nyanmɩan dunman nun'n!” ");
INSERT INTO any_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Zozi kɔ nyan afunlunmun baa kʋn ɔ kɔ fʋ kɔ tanlan sʋ kɛ bɛ hɛlɛlɩ yɩ́ daba wɔ *Ɛhɛlɛ Ɛjɔlɛ nɩn anun'n. Bɛ́ nwan: ");
INSERT INTO any_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Zoluzalɛmʋn menian, nán bɛ sulo. Ɛmɔ nɩ́an, ɛmɔ belemgbin'n tɩ afunlunmun baa kʋn sʋ, ɔ lɛ ba. ");
INSERT INTO any_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Ɛhɩ, alimʋa nɩn anun, Zozi menian'n-mɔ a ndɩ man ɛjɔlɛ sɔ'n-mɔ abʋ. Nan mɔ Zozi fi ewue nun tinngelɩ mɔ Nyanmɩan wulalɩ yɩ́ anunminnyanmʋn yuelɩ'n, afɩ sian'n, bɛ nwunlin kɛ yɩ́ nwʋn ɛjɔlɛ fɔ́ʋ́n yɛ̂ Ɛhɛlɛ Ɛjɔlɛ'n hanlɩn nɩn ɔ, like mɔ bɛ yɔlɩ yɩ́'n manlɩn ɛjɔlɛ sɔ'n kpɩnlɩn sʋ. ");
INSERT INTO any_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Mɔ Zozi fɛlɛlɩ Lazaa m'ɔ tinngelɩ yɩ́ fi ewue nun'n, bɛ́ kʋalaa mɔ anɩn bɛ wɔ ɛbɛlɛ'n, bɛ lili mɔ bɛ nwunlin yɩ́ nɩn anwʋn adanzɩɛ. ");
INSERT INTO any_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Nzɔlɛ ɛhɩ ati y'ɔ man menisʋnman'n walɩ kpalɩ yɩ́ atɩn ɔ. ");
INSERT INTO any_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Mɔ Falisifʋɛ'n-mɔ nwunlin yɩ́ sɔ'n, bɛ́ nwan: “Ebia-mɔ, ɛmɔ nɩ́an, y'a fɛ mgban o, sɛ yɛ hyɩlɩ yɩ́ ngɛlɛmɔ nun an, ahan yɛ nyanlɩn sʋ nvasʋɛ. Nan kɩkaala kɛ yɛ wɔ nun'n dɩɛ ɔ'a kpa yɩ́ nwʋn. Bɛ nɩ́an, mân bɔndɩn'n kʋalaa si yɩ́ sʋ!” ");
INSERT INTO any_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Bɛ́ mɔ bɛ walɩ Zoluzalɛmʋn ɛbɛlɛ fɛtɩ nɩn anun kɛ bɛ 'ba a sʋ Nyanmɩan'n, *Gɛlɛkɩ ngʋkʋn wɔ bɛ́ nun. ");
INSERT INTO any_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Gɛlɛkɩ sɔ'n-mɔ hɔ tʋlɩ Zozi sʋanlan'n kʋn, bɛ fɛlɛ yɩ́ Filipʋ. Ɔ fi Galile mân nɩn anun, kulo'n mɔ bɛ fɛlɛ yɩ́ Bɛtɩsayida nɩn asʋ. Gɛlɛkɩ sɔ'n-mɔ nwan: “Nja bian, yɛ kulo kɛ yɛ nwun Zozi anwʋn.” ");
INSERT INTO any_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Mɔ Filipʋ tɩlɩ ɛjɔlɛ sɔ'n, ɔ kɔ hɔ kɔ tʋ Andele, ɔ kɔ bɔ yɩ́ amannɩɛ. Bɛ́ munnyuan bɛ kɔ hɔ kɔ tʋ Zozi bɛ kɔ han bɛ kɔ hele yɩ́. ");
INSERT INTO any_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Mɔ Zozi tɩlɩ ɛjɔlɛ sɔ'n, yɩ́ nwan: “Sian dɩɛ, mɛlɛ'n m'ɔ sɛ kɛ bɛ wula Mân Baa nɩn anunminnyanmʋn nɩn a ju. ");
INSERT INTO any_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Nan mɩɩn kan yɩ́ ananhɔlɛ mɩn kele ɛmɔ kɛ *bele baa'n mɔ bɛ kɔ lua'n, sɛ ɔ'a mgbɔlɔ man asɩɛ nɩn abʋ a, ɔ ngʋala ɔ nvifi man ɔ nzu man mma. Cɩan daa ɔ la ɛbɛlɛ kʋnlʋn-ngʋnlʋn. ");
INSERT INTO any_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Sʋanlan m'ɔ tɩ ahyʋan ɔ kulo yɩ́ kunnun'n, ɔ nnyan man ngʋan. Nan sʋanlan m'ɔ eyuadɩ ɛtɛ ɛhɩ anun ɔ kulo ɛhɩnlɩn-mɔ ɔ bʋka bɛ́'n, ɔ 'nyan nyanmɩansʋ ngʋan m'ɔ le man ayuelɩɛ'n. ");
INSERT INTO any_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Sʋanlan biala m'ɔ kulo kɛ ɔ yɔ mɩ́n sʋanlan'n, ɔ sí mɩ́n sʋ. Yɩ́ dɩɛ anɩn lɩka mɔ n dɩ'n, yɩ́ kʋsʋ, ɔ tanlan ɛbɛlɛ bie. Sʋanlan m'ɔ sʋ mɩ́n'n, mɩ́n Sɩ 'man yɩ́ asasʋɛ. ");
INSERT INTO any_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“Kɩkaala dɩɛ, mɩ́n ti anun a sɛcɩ mɩ́n. Nan kʋsʋ nzu ɛjɔlɛ dɩɛ yɛ̂ mɩn 'kan ɔ? N ze kɛ, mɩ́n Sɩ, de mɩ́n fi yalɛ'n m'ɔ lɛ 'ba tʋ mɩ́n wɔ dɔɛ ɛhɩ anun anaan? Cɛcɛ, mɩ́n ngan man sɔ, ɔ sanlɩn kɛ yɩ́ ti yɛ̂ m malɩ ɔ. ");
INSERT INTO any_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Mɩ́n Sɩ, wula wɔ́ dunman nɩn anunminnyanmʋn!” Zozi hanlɩn sɔ ala, anɩɛ bie kɔ te anwunno ɛlɔ. Anɩɛ sɔ'n nwan: “Mɩ́n dunman'n, m'an wula yɩ́ anunminnyanmʋn dada angʋnmɩn, ɛsɛ mɛlɛ'n m'ɔ lɛ ba nɩn anun, mɩn 'wula yɩ́ biekun.” ");
INSERT INTO any_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Meninsʋnman'n mɔ bɛ jijin ɛbɛlɛ mɔ bɛ tɩlɩ anɩɛ sɔ'n, bɛ́ nun mmie-mɔ nwan: “Nyanmɩan'n lɛ kan nun.” Mmie-mɔ kʋsʋ nwan: “Nyanmɩansʋ bɔfʋɛ kʋn a han ɛjɔlɛ a hele yɩ́.” ");
INSERT INTO any_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Zozi nwan: “Nán mɩ́n ti yɛ̂ anɩɛ sɔ nɩn a te ɔ, nan ɛmɔ ati ɔ. ");
INSERT INTO any_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Bɛlɛ mɔ mân'n ndɛɛ ebua cɩan nɩn a ju ɔ. *Abɔnsanmʋn m'ɔ tɩ mân nɩn asʋ kpain'n, sian dɩɛ, bɛ 'ba ju yɩ́ bɛ tʋ gua sʋ. ");
INSERT INTO any_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Nan mɩ́n kʋsʋ, sɛ bɛ sinnze mɩ́n anwunno yue a, m 'ba hyʋɩn menian'n-mɔ kʋalaa mɩn ba mɩ́n nwʋn.” ");
INSERT INTO any_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Ɔ hanlɩn sɔ ɔ helelɩ ewue ɛhɔlɛ kʋn'n mɔ ɔ 'fa wu'n. ");
INSERT INTO any_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Kɛ yɩ́ nʋan 'tɔ ala, menian'n-mɔ nwan: “Mala kalata nɩn anun, yɛ tɩlɩ kɛ bɛ́ nwan *Kilisi'n mɔ ɔ 'ba le yɛ́ ti'n, ɔ nwu man lé. Nan ɔ yɔ sɛ mɔ wɔ́ nwan *Mân Baa'n, bɛ 'ba sinnze yɩ́ anwunno ɔ? Mân Baa'n muonun, ɔ tɩ yɩ́ dɩɛ sɛ?” ");
INSERT INTO any_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Zozi nwan: “Kɩkaala dɩɛ, kanlannɩɛ'n tɛ wɔ ɛmɔ afian ɛwa. Kɛmɔ ɛmɔ tɛ nwun asɩ'n, ɛmɔ nánndɩ atɩn'n mɔ n gelelɩ ɛmɔ nɩn asʋ. Nán awosin'n ba a, anɩn ɛmɔ a mminlin man. Ɔ sanlɩn kɛ sʋanlan m'ɔ nanndɩ awosin nun'n, ɔ nzɩ man lɩka m'ɔ lɛ kɔ ɔ. ");
INSERT INTO any_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Kɛmɔ ɛmɔ tɛ le kanlannɩɛ nɩn ɛwa'n, ɛmɔ lé yɩ́ bɛ lí, nán ɛmɔ a kaci kanlannɩɛ nɩn anun menian.” Mɔ Zozi hanlɩn ɛjɔlɛ sɔ'n yuelɩ'n, ɔ fi bagua nun ɔ nʋn yɩ́ menian'n-mɔ hɔlɩ fɩalɩ kaan. ");
INSERT INTO any_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Ɔ yɔlɩ asinbɛnwʋn ninnge'n dɔʋn menian'n-mɔ anyunnun ɛbɛlɛ, nan kʋsʋ b'a nne man yɩ́ b'a nni man. ");
INSERT INTO any_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Ɔ man ɛjɔlɛ'n mɔ Nyanmɩan Kpɔmanfʋɛ *Ezayi hanlɩn'n, kpɩnlɩn sʋ. Ezayi hanlɩn kɛ: Yɛ́ Mɩn, ɛjɔlɛ'n mɔ yɛ hanlɩn'n, nwan yɛ̂ ɔ lelɩ lili ɔ? Wɔ́ anwʋnsɛlɛ'n mɔ a yɩ a hele'n, nwan yɛ̂ ɔ buli yɩ́ like ɔ? ");
INSERT INTO any_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Bɛ ngʋala man kɛ bɛ de bɛ di, afɩ Ezayi hanlɩn biekun kɛ: ");
INSERT INTO any_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Nyanmɩan a sin bɛ́ nyɩn'n, ɔ man bɛ nnwun man asɩ kʋ́n. Ɔ'a kaci bɛ́ ajʋnlɩn'n, ɔ man bɛ ndɩ man yɩ́ ɛjɔlɛ'n kʋ́n. Afɩ, bɛ tɩ a, bɛ 'sa bɛ́ nzin bɛ ba yɩ́ nwʋn ɔ fa bɛ́ ɛtɛ'n-mɔ ce bɛ́. ");
INSERT INTO any_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Ezayi lili mʋa nwunlin Zozi anunminnyanmʋn'n daba, yɩ́ ti yɛ̂ ɔ man ɔ hanlɩn yɩ́ nwʋn ɛjɔlɛ nɩn ɔ. ");
INSERT INTO any_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Nan kʋsʋ Zufʋ mgbain'n-mɔ anun, mmie-mɔ dɔʋn lelɩ Zozi lili. Nan *Falisifʋɛ'n-mɔ dunman nun, bɛ ngan man, bɛ sulo kɛ bɛ kɔ fʋan bɛ́ asɔnɩn sua nɩn anun. ");
INSERT INTO any_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Afɩ sɛ menian'n-mɔ bɔ bɛ́ dunman kpa a, bɛ kulo bɛ tala kɛ Nyanmɩan kɔ bɔ bɛ́ dunman kpa'n. ");
INSERT INTO any_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Mɔ Zozi fi meninsʋnman nɩn anun ɔ 'ba hɔ'n, ɔ tɩanlɩn nun hanlɩn kɛ: “Sʋanlan biala m'ɔ de mɩ́n di'n, nán mɩ́n ngʋnmɩn yɛ̂ ɔ de mɩ́n di ɔ, nan anɩn ɔ de sʋanlan'n kʋsʋ m'ɔ sʋanlɩn mɩ́n'n di. ");
INSERT INTO any_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Sʋanlan m'ɔ kɔ nwun mɩ́n'n, anɩn ɔ tɩ kɛ ɔ'a nwun m'ɔ sʋanlɩn mɩ́n'n. ");
INSERT INTO any_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","M malɩ mân nɩn anun kɛ kanlannɩɛ, ɔ man sʋanlan biala m'ɔ de mɩ́n di'n, ɔ nga man awosin nun. ");
INSERT INTO any_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","“Sʋanlan m'ɔ kɔ tɩ mɩ́n ɛjɔlɛ'n, mɔ ɔ'a nne ɔ'a nni man'n, nán mɩ́n yɛ̂ mɩn 'bua yɩ́ ndɛɛ ɔ. Ɔ sanlɩn kɛ m malɩ kɛ m 'ba le mân nɩn ati ngʋan, m'an mma man kɛ m 'ba tua mân'n nyɔlɩɛ ɛtɛ nɩn anwʋn kalɛ. ");
INSERT INTO any_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Sʋanlan m'ɔ kɔ ju mɩ́n kɔ tʋ, m'ɔ nne man mɩ́n ɛjɔlɛ'n nni man'n, ɔ le yɩ́ ndɛɛ ebuafʋɛ. Cɩan m'ɔ li sian nɩn anun, ninnge'n mɔ mɩɩn kekele ɛmɔ'n, yɛ̂ bɛ 'fa bɛ bua yɩ́ ndɛɛ ɔ. ");
INSERT INTO any_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Afɩ nán mɩ́n ngʋnmɩn mɩ́n tunmin yɛ̂ m'an fa m'an han ɛjɔlɛ nɩn ɔ. Nan Sɩɛ'n m'ɔ sʋanlɩn mɩ́n'n, yɩ́ muonun yɛ̂ ɔ helelɩ mɩ́n ɛjɔlɛ'n m'ɔ di mɔ mɩn kan'n, ɔ nʋn ninnge'n m'ɔ di mɔ mɩn kekele nɩn ɔ. ");
INSERT INTO any_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Yɛ̂ mɩn sɩ kɛ like m'ɔ kɔ hele'n, ɔ man bɛ nyan ngʋan m'ɔ le man ayuelɩɛ. Yɩ́ ti, mɔ mɩɩn kan mɩn kele ɛmɔ'n, kɛ Sɩɛ'n helelɩ mɩ́n'n yɛ̂ mɩɩn kan nɩn ɔ.” ");
INSERT INTO any_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Mɔ anɩn Zufʋ'n-mɔ 'ba li bɛ́ fɛtɩ'n mɔ bɛ fɛlɛ yɩ́ *Pakɩ'n, Zozi sɩ kɛ dɔɛ'n mɔ ɔ 'fa jasʋ asɩ ɛwa kɔ yɩ́ Sɩ anwʋn ɛlɔ nɩn a ju. Yɩ́ mɛlɛ kaan'n m'ɔ lili yɩ́ asɩɛ nɩn asʋ ɛwa'n, ɔ hulolɩ yɩ́ menian'n-mɔ dede ɔ juli yɩ́ ayuelɩɛ. ");
INSERT INTO any_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Ɛhɩ, nɔsʋba nun, anɩn Zozi nʋn yɩ́ menian'n-mɔ lɩla tɔbɩlɩ nɩn anwʋn, bɛ lɛ didi. Simʋn Isikaliɔtɩ awa Zudasɩ wɔ bɛ́ nun ɛbɛlɛ bie. Ɔ 'ba yɔ sɔ'n kʋsʋ, anɩn *Abɔnsanmʋn nɩn a fa a wula Zudasɩ ahʋnlɩn nun dada kɛ ɔ yɩ́ Zozi mán. ");
INSERT INTO any_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Zozi dɩɛ, ɔ sɩ kɛ ɔ fi yɩ́ Sɩ anwʋn ɛlɔ yɛ̂ ɔ walɩ ɔ, ɔ di kɛ ɔ sá hɔ́ yɩ́ nwʋn ɛlɔ. Ɛsɛ ɔ sɩ kɛ Nyanmɩan a fa ninnge'n kʋalaa a wula yɩ́ sa nun. ");
INSERT INTO any_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Anɩn Zozi wula taladɩɛ nnyuan, kʋn wɔ yɩ́ bʋ yɛ̂ kʋn wɔ sʋ. Zozi fi tɔbɩlɩ nɩn anwʋn ɔ kɔ jasʋ, ɔ kɔ yɩ yɩ́ anwunno taladɩɛ'n m'ɔ wula sʋ'n kɔ gua yɩ́ ɛbɛlɛ, ɔ kɔ ha yɩ́ bʋ dɩɛ'n. Ɔ kɔ fa duku kʋn ɔ kɔ kpɛ yɩ́ bʋ. ");
INSERT INTO any_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Ɔ kɔ hɔ kɔ kaci nzue kɔ gua basi kʋn anun, ɛbɛlɛ ala, ɔ kɔ bɔ yɩ́ bʋ, ɔ lɛ nwunnzin yɩ́ menian'n-mɔ aja nɩn anwʋn. Ɔ 'nwunnzin anɩn ɔ lɛ fa duku'n m'ɔ kpɛ yɩ́ bʋ'n cici. ");
INSERT INTO any_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","M'ɔ nwunnzinlin bɛ́ ja'n-mɔ anwʋn dede m'ɔ tʋlɩ Simʋn Pɩɛlɩ'n, Simʋn Pɩɛlɩ nwan: “Yɛ́ Mɩn, wɔ́ yɛ̂ ɛ 'nwunnzin mɩ́n ja nɩn anwʋn ɔ?” ");
INSERT INTO any_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Zozi nwan: “Like'n mɔ mɩɩn yɔ'n, ɛ nyan tɩlɩ man yɩ́ bʋ, nan cɩan bie dede ɛ 'ba tɩ yɩ́ bʋ.” ");
INSERT INTO any_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Pɩɛlɩ nwan: “Cɛcɛ, mɩ́n dɩɛ mɩn mman ɛ nnwunnzin man mɩ́n ja nɩn anwʋn lé.” Mɔ Simʋn Pɩɛlɩ hanlɩn sɔ'n, Zozi nwan: “Simʋn Pɩɛlɩ, sɛ a mman m'an nnwunnzin man wɔ́ ja nɩn anwʋn an, anɩn ɛ nʋn mɩ́n lɛ kpacɩ.” ");
INSERT INTO any_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Simʋn Pɩɛlɩ nwan: “Sɛ yɩ́ sɔ a, anɩn nwunnzin mɩ́n sa'n-mɔ anwʋn nʋn mɩ́n ti nɩn asʋ bʋka sʋ.” ");
INSERT INTO any_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Zozi nwan: “Sʋanlan m'ɔ kɔ bia kɔ yue'n, ɔ nwunnzin yɩ́ ja nɩn anwʋn ala anɩn ɔ'a yue, ɔ sanlɩn kɛ yɩ́ nwʋn tɩ bɔkɔ-bɔkɔ. Ɛmɔ kʋsʋ, bɛ́ nwʋn a tɩ, kʋsʋ nán ɛmɔ kʋalaatin ɔ.” ");
INSERT INTO any_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Zozi sɩ sʋanlan'n m'ɔ lɛ 'ba yɩ yɩ́ man'n, yɩ́ ti yɛ̂ ɔ lɛ kan kɛ nán bɛ́ kʋalaatin yɛ̂ bɛ́ nwʋn a tɩ ɔ. ");
INSERT INTO any_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","M'ɔ nwunnzinlin bɛ́ ja'n-mɔ anwʋn yuelɩ'n, ɔ falɩ yɩ́ taladɩɛ'n m'ɔ yɩlɩ'n ɔ wulalɩ, ɔ salɩ hɔlɩ lalɩ tɔbɩlɩ nɩn anwʋn. Yɩ́ nwan: “Like'n mɔ m'an yɔ ɛmɔ'n, asʋ ɛmɔ tɩ yɩ́ bʋ ɔ? ");
INSERT INTO any_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Yɩ́ bʋ y'ɔ le kɛ, ɛmɔ fɛlɛ mɩ́n Kpain, ɛsɛ ɛmɔ fɛlɛ mɩ́n Mɩnlɩan, ɔ tɩ ananhɔlɛ, ɔ sanlɩn kɛ n dɩ yɩ́ sɔ sakpa. ");
INSERT INTO any_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Nan sɛ mɩ́n mɔ n dɩ ɛmɔ kpain, ɛsɛ n dɩ ɛmɔ amɩn'n, sɛ m'an nwunnzin ɛmɔ aja'n-mɔ anwʋn an, ɔ sɛ kɛ ɛmɔ kʋsʋ anun kʋn biala nwúnnzin ɛhɩnlɩn-mɔ aja nɩn anwʋn. ");
INSERT INTO any_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","M'an yɔ sɔ m'an hele ɛmɔ kɛ ɛmɔ kʋsʋ nɩ́an sʋ bɛ yɔ́ bie bɛ mán bɛ́ manngʋn'n-mɔ. ");
INSERT INTO any_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Nan mɩɩn kan yɩ́ ananhɔlɛ mɩn kele ɛmɔ kɛ akʋa'n tɩ man kpili ndala man yɩ́ mɩn'n. Yɛ̂ sʋanlan mɔ bɛ kɔ sʋan yɩ́'n, ɔ tɩ man kpili ɔ ndala man sʋanlan'n m'ɔ sʋanlɩn yɩ́'n. ");
INSERT INTO any_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Sian dɩɛ mɔ ɛmɔ a tɩ yɩ́ sɔ'n, sɛ ɛmɔ fa sʋ a, nyila 'kan ɛmɔ. ");
INSERT INTO any_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Nán ɛmɔ kʋalaa anwʋn ɛjɔlɛ yɛ̂ mɩɩn kan ɔ. Mɩn sɩ ɛmɔ mɔ m'an fɛlɛ bɛ́'n. Nan ɛjɔlɛ'n mɔ *Ɛhɛlɛ Ɛjɔlɛ'n hanlɩn'n, ɔ di kɛ ɔ kpɩn sʋ. Bɛ hɛlɛlɩ kɛ: Sʋanlan'n m'ɔ nʋn mɩ́n lɛ didi'n, ɔ 'ba fa mɩ́n kaci yɩ́ kpɔfʋɛ. ");
INSERT INTO any_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","“Mɩɩn di mʋa mɩn kan ɛjɔlɛ sɔ'n mɩn kele ɛmɔ, yɩ́ dɩɛ, cɩan mɔ ninnge sɔ'n-mɔ ɛyɔlɛ kɔ ju'n, anɩn ɛmɔ de sʋanlan ɛhɔlɛ kʋn'n mɔ n dɩ'n di. ");
INSERT INTO any_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Mɩɩn kan yɩ́ ananhɔlɛ mɩn kele ɛmɔ kɛ, sʋanlan biala m'ɔ kɔ le sʋanlan mɔ n gɔ sʋan yɩ́'n, anɩn mɩ́n muonun yɛ̂ ɔ'a le mɩ́n ɔ. Yɛ̂ m'ɔ kɔ le mɩ́n'n, anɩn ɔ tɩ kɛ sʋanlan'n m'ɔ sʋanlɩn mɩ́n'n yɛ̂ ɔ'a le yɩ́ ɔ.” ");
INSERT INTO any_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Mɔ Zozi hanlɩn sɔ yuelɩ'n, yɩ́ lʋa bɔlɩ yɩ́ nwʋn, nán ɔ'a se kɛ: “Mɩɩn kan yɩ́ ananhɔlɛ mɩn kele ɛmɔ kɛ ɛmɔ anun kʋn 'ba yɩ mɩ́n maan bɛ cɩ mɩ́n.” ");
INSERT INTO any_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Yɩ́ menian'n-mɔ anyɩn totua bɛ́ nyunnun, bɛ nzɩ man sʋanlan'n mɔ Zozi lɛ kan yɩ́ nwʋn ɛjɔlɛ'n. ");
INSERT INTO any_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Zozi menian'n-mɔ anun kʋsʋ, kʋn wɔ nun, yɩ́ dɩɛ Zozi kulo yɩ́ kpa. Kʋn sɔ'n lalɩ yɩ́ nwʋn ɛbɛlɛ. ");
INSERT INTO any_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Ɛbɛlɛ ala, Simʋn Pɩɛlɩ kɔ bɔ yɩ́ anyɩan kɛ ɔ bísa Zozi maan ɔ héle sʋanlan'n m'ɔ lɛ kan yɩ́ ɛjɔlɛ'n. ");
INSERT INTO any_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Kɛmɔ sʋanlan sɔ'n kʋsʋ nzɩ man mɔ ɔ 'ba yɩ Zozi man'n, yɩ́ kʋsʋ ɔ kɔ fa yɩ́ ti kɔ bɔ Zozi anwʋn ɔ kɔ bisa yɩ́ kɛ: “Anɩn, Yɛ́ Mɩn, nwan sʋanlan dɩɛ ɔ?” ");
INSERT INTO any_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Zozi nwan: “Mɩɩn fa mɩ́n kpaʋn'n mɩn bɔ tolo nɩn anun, nan sʋanlan mɔ n gɔ fa n gɔ man yɩ́'n, yɩ́ dein yɩ́ ɔ.” Kɛ yɩ́ nʋan 'tɔ ala, ɔ kɔ fa kpaʋn'n kɔ bɔ tolo nɩn anun ɔ kɔ man Simʋn m'ɔ fi Isikaliɔtɩ nɩn awa Zudasɩ. ");
INSERT INTO any_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Mɔ Zudasɩ 'de kpaʋn nɩn ala, *Abɔnsanmʋn, mɔ *ebele anɩɛ nɩn anun bɛ fɛlɛ yɩ́ *Satan'n, kɔ wʋlʋ yɩ́ nun. Nán Zozi a se yɩ́ kɛ: “Like'n mɔ ɛ 'yɔ'n, yɔ yɩ́ ndɛ-ndɛ.” ");
INSERT INTO any_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Like ati m'ɔ man ɔ hanlɩn sɔ'n, bɛ́ mɔ bɛ nʋn yɩ́ lɛ di alɩɛ'n, bɛ́ fɩ́ɩ́ b'a ndɩ man yɩ́ bʋ. ");
INSERT INTO any_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Kɛmɔ Zudasɩ yɛ̂ ɔ fa bɛ́ esika'n sie'n, bɛ́ dɔʋn kpa bɛ jʋnlɩn kɛ Zozi nwan ɔ hɔ́ tó like mɔ bɛ 'fa bɛ di fɛtɩ'n, anaan ɔ hyé ehianfʋɛ'n-mɔ like. ");
INSERT INTO any_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Kɛ Zudasɩ lelɩ kpaʋn nɩn ala, ɔ kɔ fite. Yɩ́ tɛmʋn sɔ nɩn anun, anɩn alɩ́ɛ lɛ san. ");
INSERT INTO any_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Kɛ Zudasɩ 'fite ala, Zozi nwan: “Sian dɩɛ, Nyanmɩan a wula *Mân Baa nɩn anunminnyanmʋn yɛ̂ ɔ nanndɩ *Mân Baa nɩn asʋ, anunminnyanmʋn a han Nyanmɩan. ");
INSERT INTO any_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Sɛ ɔ nanndɩ Mân Baa nɩn asʋ anunminnyanmʋn a han Nyanmɩan an, Nyanmɩan kʋsʋ 'ba wula yɩ́ anunminnyanmʋn bie. Ɔ 'ba yɔ yɩ́ sɔ kɩkaala. ");
INSERT INTO any_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","“Mɩ́n mma-mɔ, mɩn 'tanlan ɛmɔ anwʋn ɛwa mɛlɛ kaan sʋa biekun. Ɛmɔ 'ba kpʋnndɛ mɩ́n, nan mɔ n ganlɩn n gelelɩ Zufʋ'n-mɔ, mɩɩn kan mɩn kele ɛmɔ kʋsʋ sian'n. Lɩka mɔ mɩɩn kɔ'n, ɛmɔ ngʋala man ɛlɔ bie kɔ. ");
INSERT INTO any_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","“Mɩɩn man ɛmɔ mala fʋfɔlɛ: ɛmɔ húlo bɛ́ nwʋn. Ɔ sɛ kɛ ɛmɔ kulo bɛ́ nwʋn kɛ m gbɩnlɩn n gulolɩ ɛmɔ'n. ");
INSERT INTO any_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Sɛ ɛmɔ kulo bɛ́ nwʋn an, menian'n-mɔ kʋalaa 'ba nwun kɛ ɛmɔ tɩ mɩ́n menian sakpa.” ");
INSERT INTO any_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Mɔ Zozi hanlɩn sɔ'n, Simʋn Pɩɛlɩ kɔ bisa yɩ́ kɛ: “Yɛ́ Mɩn, anɩn nin kpa yɛ̂ ɛ lɛ kɔ ɔ?” Zozi nwan: “Lɩka mɔ mɩɩn kɔ'n, ɛ ngʋala man mɩ́n sʋ si kɩkaala, nan cɩan bie dede ɛ 'ba kpʋ mɩ́n.” ");
INSERT INTO any_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Pɩɛlɩ nwan: “Yɛ́ Mɩn, nzukɛ ati yɛ̂ mɩn ngʋala man wɔ́ sʋ si kɩkaala ɔ? Wɔ́ dunman nun, sɛ ɔ di mɔ mɩn wu bɔbɔ a, mɩn 'wu.” ");
INSERT INTO any_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Ɛhɩ a, Zozi nwan: “Pɩɛlɩ, asʋ wɔ́ nwan ɛ 'wu mɩ́n dunman nun sakpa? Nan nɩan, mɩɩn kan yɩ́ ananhɔlɛ mɩn kele wɔ́ kɛ ɔ nʋn dede mɔ akɔ'n 'bɔ kokolokoo'n, anɩn a han yɩ́ fâ nsan kɛ ɛ nzɩ man mɩ́n.” ");
INSERT INTO any_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Mɔ Zozi hanlɩn sɔ yuelɩ'n, ɛsɛ ɔ kɔ kpɛ yɩ́ nyɩn yɩ́ menian'n-mɔ ɛlɔ, yɩ́ nwan: “Nán bɛ man bɛ́ lʋa bɔ bɛ́ nwʋn, ɛmɔ lé Nyanmɩan bɛ lí, ɛsɛ ɛmɔ lé mɩ́n kʋsʋ bɛ lí. ");
INSERT INTO any_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Mɩ́n Sɩ awulo ɛlɔ, dabɛlɛ ngʋnmɩn wɔ ɛbɛlɛ. Mɩn 'kɔ a sesie lɩka mɩn man ɛmɔ. Sɛ ɔ tɩ man sɔ a, ahan n ganlɩn n gelelɩ ɛmɔ. ");
INSERT INTO any_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Sɛ mɩn kɔ nán mɩn sesie lɩka'n yue a, mɩn 'sa mɩn ba, mɩn fa ɛmɔ mɩn kɔ, nán lɩka mɔ n dɩ'n, ɛmɔ kʋsʋ tanlan ɛbɛlɛ bie. ");
INSERT INTO any_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Lɩka mɔ mɩɩn kɔ'n, ɛmɔ sɩ yɩ́ atɩn'n.” ");
INSERT INTO any_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Mɔ Toma tɩlɩ ɛjɔlɛ sɔ'n, yɩ́ nwan: “Yɛ́ Mɩn, yɛ nzɩ man lɩka mɔ ɛ lɛ kɔ'n, ɔ 'yɔ sɛ nán y'a nwun yɩ́ atɩn'n?” ");
INSERT INTO any_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Ɛhɩ a, Zozi kɔ bua yɩ́ kɛ: “Atɩn'n, nʋn ananhɔlɛ'n nʋn ngʋan'n y'ɔ le mɩ́n muonun. Sʋanlan fɩ́ɩ́ ngʋala man kɛ ɔ sɩn lɩka fʋfɔlɛ ɔ kɔ mɩ́n Sɩ anwʋn ɛlɔ sannan ɔ 'nanndɩ mɩ́n sʋ. ");
INSERT INTO any_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Sɛ ɔ tɩ kɛ ɛmɔ sɩ mɩ́n an, ahan ɛmɔ 'sɩ mɩ́n Sɩ. Kʋsʋ kɩkaala dɩɛ, ɛmɔ a nwun yɩ́, ɛmɔ sɩ yɩ́.” ");
INSERT INTO any_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Filipʋ nwan: “Yɛ́ Mɩn, kele yɛ́ Sɩɛ'n nán man yɛ́ ahʋnlɩn tɔ́ yɛ́ kunnun.” ");
INSERT INTO any_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","M'ɔ hanlɩn sɔ'n, Zozi nwan: “Filipʋ, yɩ́ ti, dada angʋnmɩn ɛhɩ mɔ mɩn nʋn ɛmɔ tɩ ɛwa'n, ɛ nzɩ man mɩ́n? Sʋanlan m'ɔ kɔ nwun mɩ́n'n, anɩn ɔ'a nwun mɩ́n Sɩ, nan nzukɛ ati yɛ̂ wɔ́ nwan n géle ɛmɔ Sɩɛ'n? ");
INSERT INTO any_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Ɛ nne nni man kɛ n wɔ Sɩɛ nɩn anun yɛ̂ Sɩɛ'n kʋsʋ wɔ mɩ́n nun ɔ? Ɛjɔlɛ'n mɔ mɩɩn kan mɩn kele ɛmɔ kʋalaatin ɛwa'n, ɔ fi man mɩ́n muonun. Sɩɛ'n m'ɔ wɔ mɩ́n nun'n yɛ̂ ɔ lɛ di junman sɔ nɩn ɔ. ");
INSERT INTO any_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Sɛ mɩn kan kɛ n wɔ Sɩɛ nɩn anun yɛ̂ Sɩɛ'n kʋsʋ wɔ mɩ́n nun an, ɛmɔ lé lí. Sɛ yɩ́ bɔbɔ ɛmɔ nne nni man an, ɛmɔ nɩ́an asinbɛnwʋn ninnge'n mɔ mɩn yɔ'n nán bɛ lé bɛ lí. ");
INSERT INTO any_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Mɩɩn kan yɩ́ ananhɔlɛ mɩn kele ɛmɔ kɛ sʋanlan biala m'ɔ de mɩ́n di'n, asinbɛnwʋn ninnge'n mɔ mɩn yɔ'n, yɩ́ kʋsʋ ɔ 'yɔ bie. Yɩ́ dɩɛ'n bɔbɔ mɔ ɔ 'yɔ'n, ɔ 'tala mɩ́n dɩɛ'n. Ɔ sanlɩn kɛ mɩɩn kɔ Sɩɛ nɩn anwʋn ɛlɔ. ");
INSERT INTO any_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Like biala mɔ ɛmɔ kɔ sɛlɛ wɔ mɩ́n dunman nun'n, mɩn 'fa mɩn man ɛmɔ, nán ɔ nanndɩ Baa nɩn asʋ menian'n-mɔ kʋalaa a wula Sɩɛ nɩn anunminnyanmʋn. ");
INSERT INTO any_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Ɛmɔ sɛlɛ like biala wɔ mɩ́n dunman nun an, mɩn 'yɔ mɩn man ɛmɔ.” ");
INSERT INTO any_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Ɛsɛ Zozi Nwan: “Sɛ ɛmɔ kulo mɩ́n sakpa a, ɛmɔ lí mɩ́n mala nɩn asʋ. ");
INSERT INTO any_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Mɩn 'ba sɛlɛ mɩ́n Sɩ maan ɔ man ɛmɔ *Bʋkafʋɛ fʋfɔlɛ m'ɔ nʋn ɛmɔ 'tanlan dahuu. ");
INSERT INTO any_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Ɔ tɩ Wawɛ m'ɔ kan ananhɔlɛ. Mân nɩn anun menian'n-mɔ mɔ bɛ nne man mɩ́n bɛ nni man'n, bɛ ngʋala man kɛ bɛ nyan yɩ́, ɔ sanlɩn kɛ bɛ nnwun man yɩ́, ɛsɛ bɛ nzɩ man yɩ́. Nan ɛmɔ dɩɛ, ɛmɔ sɩ yɩ́, ɔ sanlɩn kɛ ɔ nʋn ɛmɔ y'ɔ tɩ ɔ, ɛsɛ ɔ 'ba tanlan ɛmɔ anun. ");
INSERT INTO any_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Mɩn ngɔ yaci man ɛmɔ angʋnmɩn kɛ awusian. Nan mɩn 'ba sa mɩn ba ɛmɔ anwʋn biekun. ");
INSERT INTO any_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Ɔ'a ha mɛlɛ kaan bie, mân nɩn anun menian'n-mɔ ngɔ nwun man mɩ́n kʋ́n. Nan ɛmɔ dɩɛ, ɛmɔ 'ba nwun mɩ́n. Kɛmɔ mɩ́n lɩlɩ n dɩ asɩ'n, ɛmɔ kʋsʋ 'ba nyan ngʋan bɛ tanlan asɩ bie. ");
INSERT INTO any_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Sɛ cɩan sɔ'n ju a, ɛmɔ 'ba nwun kɛ n wɔ mɩ́n Sɩ anun, ɛmɔ wɔ mɩ́n nun, yɛ̂ mɩ́n kʋsʋ n wɔ ɛmɔ anun. ");
INSERT INTO any_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Like mɔ mɩn kekele ɛmɔ'n, sʋanlan mɔ yɩ́ nyɩn kɔ sɔ yɩ́ m'ɔ kɔ fa kɔ sie'n, yɩ́ yɛ̂ anɩn mɩn sɩ kɛ ɔ kulo mɩ́n ɔ. Sʋanlan sɔ'n, mɩ́n Sɩ 'kulo yɩ́, mɩ́n kʋsʋ mɩn 'kulo yɩ́, mɩn 'yɩ mɩ́n nwʋn mɩn kele yɩ́.” ");
INSERT INTO any_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Mɔ Zudɩ (nán Zudasɩ Isikaliɔtɩ ɔ) tɩlɩ ɛjɔlɛ sɔ'n, yɩ́ nwan: “Yɛ́ Mɩn, ɔ yɔ sɛ mɔ wɔ́ nwan ɛ nyɩ man wɔ́ nwʋn ɛ ngele man mân nɩn anun menian nga'n-mɔ mɔ bɛ nne wɔ́ bɛ nni man'n, nan yɛ́ ngʋnmɩn ala yɛ̂ ɛ 'yɩ wɔ́ nwʋn kele yɛ́'n?” ");
INSERT INTO any_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Ɛhɩ a, Zozi kɔ bua yɩ́ kɛ: “Sʋanlan m'ɔ kulo mɩ́n'n, ɔ di mɔ mɩn kan nɩn asʋ. Mɩn Sɩ 'kulo yɩ́, ɛsɛ mɩn nʋn mɩ́n Sɩ yɛ 'ba yɩ́ nwʋn nán yɛ nʋn yɩ́ tanlan. ");
INSERT INTO any_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Sʋanlan m'ɔ ngulo man mɩ́n'n, mɔ mɩn kan'n, ɔ nni man sʋ. Ɛjɔlɛ kʋalaa mɔ ɛmɔ tɩ kɛ mɩɩn kan'n, ɔ fi man mɩ́n muonun, nan Sɩɛ'n m'ɔ sʋanlɩn mɩ́n'n, yɩ́ yɛ̂ ɔ lɛ kan ɔ. ");
INSERT INTO any_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Mɩɩn kan ɛjɔlɛ sɔ'n mɩn kele ɛmɔ wɔ abɛlɛ mɔ n dɛ wɔ ɛmɔ afian ɛwa'n. ");
INSERT INTO any_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Nan mɩ́n dunman nun Sɩɛ'n 'ba sʋan *Bʋkafʋɛ'n, Wawɛ Nwannzan-nwannzan'n. Ɔ 'ba hehele ɛmɔ ninnge'n-mɔ kʋalaatin ɛsɛ ɔ 'ba man ɛmɔ ati kacɩ ɛjɔlɛ'n kʋalaatin mɔ m'an han m'an hele ɛmɔ'n. ");
INSERT INTO any_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Mɩɩn yaci ɛmɔ alʋacɩcɩɛ nun. Mɩ́n alʋacɩcɩɛ dɩɛ'n yɛ̂ mɩɩn fa mɩn man ɛmɔ ɔ. Alʋacɩcɩɛ'n mɔ mɩɩn fa mɩn man ɛmɔ'n, ɔ nʋn eyuadɩ nɩn anun dɩɛ'n tɩ man kʋ́n. Nán bɛ man bɛ́ lʋa bɔ bɛ́ nwʋn, ɛsɛ nán bɛ sulo. ");
INSERT INTO any_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","“Ɛmɔ a tɩ mɔ m'an han'n. M'an han m'an hele ɛmɔ kɛ mɩɩn kɔ, nan kʋsʋ mɩn 'ba sa mɩn ba ɛmɔ anwʋn biekun. Sɛ ɔ tɩ kɛ ɛmɔ kulo mɩ́n sakpa a, ahan Sɩɛ nɩn anwʋn ɛlɔ mɔ mɩɩn kɔ'n, ɛmɔ 'di yɩ́ nwʋn fɛ kpa. Ɔ sanlɩn kɛ Sɩɛ'n tɩ kpili tala mɩ́n. ");
INSERT INTO any_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","M'an li mʋa m'an han ninnge sɔ'n-mɔ kʋalaa anwʋn ɛjɔlɛ m'an hele ɛmɔ asannan nán bɛ́ ɛyɔlɛ tɛmʋn nɩn a ju sʋ. Yɩ́ dɩɛ, anɩn cɩan m'ɔ kɔ ju sʋ'n, ɛmɔ de mɔ n ganlɩn'n bɛ di. ");
INSERT INTO any_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Mɩn nʋn ɛmɔ yɛ lɛ njʋjɔ man dɔʋn kʋ́n. Ɔ sanlɩn kɛ mân ɛhɩ asʋ kpain'n lɛ ba. Ɔ le man tunmin fɩ́ɩ́ wɔ mɩ́n sʋ. ");
INSERT INTO any_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Nan ɔ fata kɛ menian'n-mɔ nwun yɩ́ kɛ mɩn kulo Sɩɛ'n yɛ̂ like mɔ mɩ́n Sɩ kɔ hele mɩ́n kɛ n yɔ́'n yɛ̂ mɩn yɔ ɔ. Yɩ́ ti, bɛ jásʋ maan yɛ hɔ́.” ");
INSERT INTO any_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Mɔ Zozi hanlɩn sɔ yuelɩ'n, ɛsɛ yɩ́ nwan: “Divɩn baka kpa'n y'ɔ le mɩ́n yɛ̂ mɩ́n Sɩ y'ɔ tɩ divɩn baka sɔ nɩn ɛnɩanfʋɛ nɩn ɔ. ");
INSERT INTO any_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Mɩ́n sa baa biala m'ɔ nzu man baa'n, mɩ́n Sɩ 'ko tʋ. Nan nunhan m'ɔ su'n, ɔ kpɩkpɛ nun kanlanman ɔ man ɔ yɔ kpa, nán ɔ'a hʋala mma biekun dɔʋn su. ");
INSERT INTO any_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Nan ɛmɔ dɩɛ, ninnge'n-mɔ mɔ n gelelɩ ɛmɔ nɩn ati, ɛmɔ anwʋn a tɩ dada angʋnmɩn. ");
INSERT INTO any_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Yɩ́ sɔ ati, ɛmɔ fá bɛ́ nwʋn bɛ bɔ́ mɩ́n, nán mɩ́n kʋsʋ, mɩn nʋn ɛmɔ a tanlan dahuu. Divɩn baka nɩn asa baa'n m'ɔ tua man yɩ́ nwʋn'n, ɔ ngʋala man baa su. Ɛmɔ kʋsʋ, sɛ ɛmɔ a nva man bɛ́ nwʋn b'a mmɔ man mɩ́n an, ɛmɔ ngʋala man like kpa fɩ́ɩ́ yɔ. ");
INSERT INTO any_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Divɩn baka'n y'ɔ le mɩ́n, yɛ̂ mɩ́n sa mma'n-mɔ y'ɔ le ɛmɔ. Nunhan mɔ ɔ'a fa yɩ́ nwʋn ɔ'a bɔ mɩ́n, m'ɔ nʋn mɩ́n tɩ daa, mɔ mɩ́n kʋsʋ mɩn nʋn yɩ́ tɩ'n, ɔ 'yɔ nyɔlɩɛ kpa dɔʋn. Afɩ sɛ n nnʋn man nun an, ɛmɔ ngʋala man like kpa fɩ́ɩ́ yɔ. ");
INSERT INTO any_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Sʋanlan biala mɔ ɔ'a nva man yɩ́ nwʋn ɔ'a mmɔ man mɩ́n'n, anɩn ɔ tɩ kɛ baka nɩn asa baa'n mɔ b'a kpɛ b'a tʋ. Ɔ 'yʋɩ bɛ fa bɛ tʋ sɩ̂n nun bɛ yala yɩ́. ");
INSERT INTO any_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Sɛ ɛmɔ fa bɛ́ nwʋn bɛ bɔ mɩ́n, nán ɛmɔ di mɩ́n ɛjɔlɛ nɩn asʋ a, ɛmɔ sɛlɛ like biala mɔ ɛmɔ kulo nɩn an, ɛmɔ 'nyan yɩ́. ");
INSERT INTO any_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Sɛ ɛmɔ yɔ nyɔlɩɛ kpa dɔʋn an, ɔ tɩ mɩ́n Sɩ anunminnyanmʋn ɛsɛ ɔ kele kɛ ɛmɔ tɩ mɩ́n menian sakpa. ");
INSERT INTO any_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","“Mɩn kulo ɛmɔ kɛ mɩ́n Sɩ kulo mɩ́n'n. Yɩ́ ti, ɛmɔ mán n gúlo bɛ́ daa. ");
INSERT INTO any_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Kɛ mɩn di mɩ́n Sɩ mala nɩn asʋ m'ɔ kulo mɩ́n'n, mɩ́n kʋsʋ, sɛ ɛmɔ di mɩ́n mala nɩn asʋ a, mɩn 'kulo ɛmɔ cɩan daa. ");
INSERT INTO any_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","M'an han sɔ m'an hele ɛmɔ maan ɛmɔ di fɛ nán ɛsɛ ɛmɔ fɛ elie'n yɔ kpili kɛ mɩ́n dɩɛ'n. ");
INSERT INTO any_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Mɩ́n mala'n y'ɔ le kɛ ɛmɔ húlo bɛ́ nwʋn kɛ mɩn kulo ɛmɔ'n. ");
INSERT INTO any_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Ehulo kpili kpa'n y'ɔ le sʋanlan m'ɔ wu yɩ́ manngʋn'n-mɔ dunman nun'n. ");
INSERT INTO any_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Sɛ ɛmɔ yɔ ninnge'n mɔ m'an hele ɛmɔ nɩn an, anɩn ɛmɔ tɩ mɩ́n manngʋn. ");
INSERT INTO any_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Mɩn mmu man ɛmɔ kɛ mɩ́n ngʋa. Ɔ sanlɩn kɛ mɩnlɩan ngan man yɩ́ nwʋn ɛjɔlɛ kʋalaa ɔ ngele man yɩ́ akʋa kɛ m'an yɔ yɩ́'n. Mɩn bu ɛmɔ kɛ mɩ́n manngʋn. Ɔ sanlɩn kɛ ninnge'n kʋalaatin mɔ mɩ́n Sɩ helelɩ mɩ́n'n, m'an hele ɛmɔ. ");
INSERT INTO any_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Nán ɛmɔ yɛ̂ b'a fɛlɛlɩ mɩ́n b'a sie mɩ́n bɛ́ kpain ɔ. Nan mɩ́n muonun yɛ̂ m'an fɛlɛ ɛmɔ mɩ́n nwʋn m'an wula ɛmɔ junman nun ɔ. M'an yɩ ɛmɔ kɛ ɛmɔ hɔ́, bɛ hɔ́ lí junman bɛ sú mma m'ɔ nzɛcɩ man lé. Like biala mɔ ɛmɔ kɔ sɛlɛ mɩ́n Sɩ wɔ mɩ́n dunman nun'n, ɔ 'fa man ɛmɔ. ");
INSERT INTO any_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Like mɔ mɩɩn kpʋnndɛ ɛmɔ ɛlɔ'n y'ɔ le kɛ ɛmɔ húlo bɛ́ nwʋn.” ");
INSERT INTO any_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Mɔ Zozi tuli yɩ́ menian'n-mɔ fʋɔ yuelɩ'n, ɔ kɔ han kɔ hele bɛ́ biekun kɛ: “Sɛ eyuadɩ'n kpɔ ɛmɔ a, ɛmɔ nwún yɩ́ kɛ bɛ lili mʋa bɛ kpɔlɩ mɩ́n. ");
INSERT INTO any_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Sɛ ɛmɔ tɩ eyuadɩ'n dɩɛ lɩlɩ a, ahan eyuadɩ nɩn anun menian'n-mɔ kulo ɛmɔ ɛjɔlɛ, ɔ sanlɩn kɛ bɛ́ bie y'ɔ le ɛmɔ. Nan kɛmɔ m'an nɩan eyuadɩ nɩn anun m'an yɩ ɛmɔ, mɔ ɛmɔ tɩ man eyuadɩ'n dɩɛ kʋ́n'n, yɩ́ ti yɛ̂ bɛ kpɔ ɛmɔ ɔ. ");
INSERT INTO any_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Ɛmɔ kácɩ mɔ n ganlɩn n gelelɩ ɛmɔ'n: ‘Akʋa biala tɩ man kpili ndala man yɩ́ mɩn'n’. Nan sɛ b'a hele mɩ́n ahʋlʋwa a, bɛ 'kele ɛmɔ kʋsʋ bie. Sɛ bɛ́ nyɩn sɔlɩ mɩ́n ninnge'n mɔ n gelelɩ bɛ́ nɩn an, ahan bɛ́ nyɩn 'sɔ ɛmɔ kʋsʋ dɩɛ'n. ");
INSERT INTO any_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Mɩ́n dunman nun ati, bɛ 'fa ninnge sɔ'n kʋalaa bɛ yɔ ɛmɔ, ɔ sanlɩn kɛ bɛ nzɩ man sʋanlan'n m'ɔ sʋanlɩn mɩ́n'n. ");
INSERT INTO any_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Sɛ ɔ tɩ kɛ m'an mma a ngan man ɛjɔlɛ fɩ́ɩ́ m'an ngele man bɛ́ a, ahan bɛ́ nwʋn saun. Nan sian dɩɛ, mɔ m'an a a han ɛjɔlɛ m'an hele bɛ́, mɔ b'a nne b'a nni man'n, bɛ nva man bɛ́ ɛtɛ'n bɛ nje man bɛ́ lé. ");
INSERT INTO any_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Sʋanlan m'ɔ kpɔ mɩ́n'n, anɩn ɔ kpɔ mɩ́n Sɩ. ");
INSERT INTO any_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Junman'n mɔ sʋanlan fɩ́ɩ́ lili man bie mân ɛhɩ anun lé'n, sɛ m'an nni man bie bɛ́ afian ɛwa a, ahan bɛ́ nwʋn saun. Nan sunnzun mɔ b'a nwun asinbɛnwʋn ninnge'n kʋalaa mɔ m'an yɔ'n, bɛ tɛ kpɔ mɩ́n nʋn mɩ́n Sɩ. ");
INSERT INTO any_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Ɛhɩka kʋalaa yɔlɩ sɔ, ɔ man ɛjɔlɛ'n mɔ bɛ hɛlɛlɩ wɔ bɛ́ *Mala kalata nɩn anun'n kpɩnlɩn sʋ. Bɛ hɛlɛlɩ yɩ́ kɛ: B'a kpɔ mɩ́n mgban. ");
INSERT INTO any_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Mɩ́n manngʋn-mɔ, *Bʋkafʋɛ'n mɔ mɩn 'ba sʋan yɩ́'n, ɔ fi Sɩɛ nɩn anwʋn ɛlɔ yɛ̂ ɔ 'ba ɔ. Yɩ́ y'ɔ le Wawɛ'n mɔ kan ananhɔlɛ'n. Sɛ ɔ ba a, ɔ 'ba li mɩ́n nwʋn adanzɩɛ. ");
INSERT INTO any_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Yɛ̂ ɛmɔ kʋsʋ 'ba li mɩ́n nwʋn adanzɩɛ, ɔ sanlɩn kɛ mɩn 'bɔ mɩ́n junman nɩn abʋ'n, ɛmɔ nʋn mɩ́n yɛ̂ yɛ sanlɩn nun ɔ. ");
INSERT INTO any_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Mɩɩn kacɩ ɛmɔ kɛ bɛ lɛ 'ba hele ɛmɔ ahʋlʋwa, yɩ́ dɩɛ sɛ mɛlɛ'n ju sʋ a, anɩn ɛmɔ mminlin man bɛ́ dedi'n. ");
INSERT INTO any_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Bɛ 'ba fʋan ɛmɔ Zufʋ'n-mɔ asɔnɩn sua'n-mɔ anun. Ɛsɛ bɔbɔ, ɔ 'ba ju mɛlɛ'n bie, bɛ́ mɔ bɛ lɛ kun ɛmɔ'n 'ba se kɛ anɩn bɛ lɛ sʋ Nyanmɩan sʋa. ");
INSERT INTO any_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Bɛ 'yɔ ɛmɔ sɔ, ɔ sanlɩn kɛ bɛ nzɩ man Sɩɛ'n, ɛsɛ bɛ nzɩ man mɩ́n. ");
INSERT INTO any_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Nan mɩɩn kan sɔ mɩn kele ɛmɔ, yɩ́ dɩɛ cɩan mɔ bɛ 'yɔ ɛmɔ sɔ'n, anɩn ɛmɔ kacɩ kɛ n ganlɩn n gelelɩ ɛmɔ. M'an ngan m'an ngele man ɛmɔ daba, afɩ anɩn mɩn nʋn ɛmɔ y'ɔ san ɔ. ");
INSERT INTO any_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","“Sian dɩɛ, mɩɩn sa mɩn kɔ sʋanlan'n m'ɔ sʋanlɩn mɩ́n nɩn anwʋn ɛlɔ, nan kʋsʋ ɛmɔ mmisa man mɩ́n kɛ: ‘Ɛ lɛ kɔ nin?’ ");
INSERT INTO any_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Kɛmɔ m'an han m'an hele ɛmɔ kɛ mɩɩn kɔ'n, ɛmɔ alʋa a bɔ bɛ́ nwʋn kpa. ");
INSERT INTO any_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Nan kʋsʋ mɩɩn kan yɩ́ ananhɔlɛ mɩn kele ɛmɔ kɛ ɔ tɩ kpa man ɛmɔ kɛ n gɔ́. Afɩ sɛ m'an ngɔ man an, Bʋkafʋɛ'n ngɔ a man ɛmɔ anwʋn. Nan sɛ mɩn kɔ a, mɩn 'ba sʋan yɩ́ ɛmɔ anwʋn. ");
INSERT INTO any_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Sɛ ɔ ba a, ɔ 'yɩ ninnge'n-mɔ yuein yuein kele eyuadɩ amma'n. Ninnge sɔ'n-mɔ, kʋn y'ɔ le ɛtɛ ɛyɔlɛ'n, kʋn y'ɔ le sɛsɛ ɛyɔlɛ'n, yɛ̂ kʋn kʋsʋ y'ɔ le ndɛɛ ebua'n mɔ Nyanmɩan 'ba bu'n. ");
INSERT INTO any_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Ɔ 'ba hele bɛ́ kɛ b'a yɔ ɛtɛ, ɔ sanlɩn kɛ b'a nne man mɩ́n b'a nni man. ");
INSERT INTO any_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Yɛ̂, kɛmɔ mɩɩn kɔ Sɩɛ nɩn anwʋn ɛlɔ mɔ ɛmɔ ngɔ nwun man mɩ́n kʋ́n'n, ɔ 'ba hele bɛ́ kɛ sɛsɛ ɛyɔlɛ yɛ̂ Sɩɛ'n lɛ kpʋnndɛ ɔ. ");
INSERT INTO any_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Afɩ, ndɛɛ ebua'n mɔ Nyanmɩan 'ba bua'n y'ɔ le kɛ ɔ'a bua mân ɛhɩ asʋ kpain'n ndɛɛ dada angʋnmɩn. ");
INSERT INTO any_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“N ne ɛjɔlɛ dɔʋn m'ɔ fata kɛ mɩn kan mɩn kele ɛmɔ, nan kʋsʋ ɛmɔ ngʋala man yɩ́ kʋalaa fa sie kɩkaala. ");
INSERT INTO any_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Nan sɛ Wawɛ'n m'ɔ kan ananhɔlɛ'n ba a, ɔ 'ba hele ɛmɔ ananhɔlɛ atɩn'n. Nán yɩ́ ngʋnmɩn yɩ́ ti anun ɛjɔlɛ yɛ̂ ɔ 'kan kele ɛmɔ ɔ, nan mɔ ɔ'a tɩ ɔ nʋn mɔ ɔ 'ba a mân nɩn anun nɩn anwʋn ɛjɔlɛ yɛ̂ ɔ 'kan kele ɛmɔ ɔ. ");
INSERT INTO any_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Ɔ 'ba wula mɩ́n anunminnyanmʋn, ɔ sanlɩn kɛ m'ɔ kɔ nwun yɩ́ mɩ́n nwʋn'n, yɩ́ nwʋn ɛjɔlɛ yɛ̂ ɔ 'kan kele ɛmɔ ɔ. ");
INSERT INTO any_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Ninnge kʋalaa mɔ mɩ́n Sɩ le'n tɩ mɩ́n dɩɛ. Yɩ́ sɔ ati yɛ̂ ɔ man mɩɩn kan kɛ mɔ Wawɛ Nwannzan-nwannzan'n kɔ nwun yɩ́ mɩ́n nwʋn'n, yɩ́ nwʋn ɛjɔlɛ yɛ̂ ɔ 'kan kele ɛmɔ ɔ.” ");
INSERT INTO any_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Ɛsɛ Zozi nwan: “Ɔ ngɔ hyɛ man, ɛmɔ lɛ mma nnwun man mɩ́n kʋ́n, ɔ cɛ kaan an, ɛmɔ 'ba nwun mɩ́n biekun.” ");
INSERT INTO any_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Mɔ yɩ́ menian'n-mɔ tɩlɩ ɛjɔlɛ sɔ'n, mmie-mɔ lɛ kan yɩ́ bɛ́ afian ɛbɛlɛ kɛ: “Anɩn ɛjɔlɛ ɛhɩ, yɩ́ bʋ y'ɔ le benin? Ɔ lɛ kan kele yɛ́ kɛ: ‘Ɔ ngɔ hyɛ man, ɛmɔ lɛ mma nnwun man mɩ́n kʋ́n, ɛsɛ ɔ cɛ kaan an, ɛmɔ 'ba nwun mɩ́n biekun,’ ɛsɛ yɩ́ nwan: ‘Mɩɩn kɔ mɩ́n Sɩ anwʋn ɛlɔ.’” ");
INSERT INTO any_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Bɛ́ nwan: “‘Ɔ ngɔ hyɛ man,’ anɩn ɛjɔlɛ ɛhɩ m'ɔ lɛ kan'n, yɩ́ bʋ y'ɔ le benin? M'ɔ lɛ kan'n, yɛ́ dɩɛ yɛ ndɩ man yɩ́ bʋ.” ");
INSERT INTO any_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Mɔ Zozi nwunlin kɛ bɛ lɛ kpʋnndɛ bɛ bisa yɩ́ ɛjɔlɛ'n, ɔ kɔ se bɛ́ kɛ: “Kɛmɔ m'an han kɛ: ‘Ɔ ngɔ hyɛ man ɛmɔ lɛ mma nnwun man mɩ́n kʋ́n, ɛsɛ ɔ cɛ kaan an, ɛmɔ 'ba nwun mɩ́n biekun,’ yɩ́ ti yɛ̂ ɛmɔ lɛ bisa bɛ́ nwʋn kosuan'n? ");
INSERT INTO any_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Mɩɩn kan yɩ́ ananhɔlɛ mɩn kele ɛmɔ kɛ ɛmɔ lɛ 'ba sun bɛ́ nyɩn ɛmʋɩn bɛ yɩ awɔ́lɛ. Nan eyuadɩ amma'n-mɔ mɔ bɛ nne man mɩ́n bɛ nni man'n, bɛ 'ba li fɛ. Ɛmɔ alʋa 'ba bɔ bɛ́ nwʋn, nan kʋsʋ ɛmɔ alʋabɔ'n 'ba kaci fɛ elie. ");
INSERT INTO any_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Sɛ balasua kʋn nwʋnnzɛ dede nán ɔ 'ba wʋ a, anɩn yɩ́ lʋa a bɔ yɩ́ nwʋn. Ɔ sanlɩn kɛ anɩn yɩ́ yalɛ elie mɛlɛ nɩn a ju. Nan sɛ ɔ wʋ yue a, anɩn yɩ́ lʋa a fi yɩ́ yalɛ'n mɔ ɔ'a nwun yɩ́'n. Ɔ sanlɩn kɛ ɔ'a wʋ baa kʋn ɔ'a tʋ asɩɛ nɩn asʋ. ");
INSERT INTO any_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Yɩ́ sɔ kʋsʋ ala, kɛ yɛ wɔ nun'n, ɛmɔ alʋa a bɔ bɛ́ nwʋn, nan mɔ yɛ 'ba nwun yɛ́ nwʋn biekun'n, ɛmɔ 'ba li fɛ kpa, sʋanlan fɩ́ɩ́ ngɔ hʋala man ɛmɔ fɛ elie'n yɩ.” ");
INSERT INTO any_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Mɔ Zozi hanlɩn sɔ yuelɩ'n ɛsɛ yɩ́ nwan: “Sɛ cɩan sɔ'n ju a, anɩn ɛmɔ mmisa man mɩ́n like fɩ́ɩ́ anwʋn kosuan kʋ́n. Mɩɩn kan yɩ́ ananhɔlɛ mɩn kele ɛmɔ kɛ like biala mɔ ɛmɔ kɔ sɛlɛ wɔ mɩ́n dunman nun'n, Sɩɛ'n 'fa man ɛmɔ. ");
INSERT INTO any_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Kɛ m mɔlɩ mɩ́n junman nɩn abʋ dede mɔ ɔ'a ju bɩcɩ'n, ɛmɔ sɛlɛlɩ man like fɩ́ɩ́ wɔ mɩ́n dunman nun. Ɛmɔ sɛ́lɛ, nán ɛmɔ asa 'kan yɩ́. Sɛ ɛmɔ asa kan yɩ́ a, ɛmɔ 'di fɛ kpili kpa. ");
INSERT INTO any_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“M'an bu ɛjɔlɛ sɔ'n-mɔ kʋalaa anyɩnndala nun, m'an hele ɛmɔ. Nan ɔ 'ba ju mɛlɛ'n bie, mɩn ngɔ mmu man yɩ́ anyɩnndala nun kʋ́n, nan mɩn 'kan mɩ́n Sɩ anwʋn ɛjɔlɛ'n yuein yuein mɩn kele ɛmɔ. ");
INSERT INTO any_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Cɩan sɔ'n ju a, yɩ́ kʋalaa mɔ ɛmɔ 'ba sɛlɛ Sɩɛ'n, ɛmɔ 'ba sɛlɛ wɔ mɩ́n dunman nun. Mɩn mmʋtʋ man mɩ́n Sɩ'n bɔbɔ nán ɔ'a fa ɔ'a man ɛmɔ. ");
INSERT INTO any_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Ɔ sanlɩn kɛ, Sɩɛ'n muonun kulo ɛmɔ. Ɔ kulo ɛmɔ, afɩ ɛmɔ kulo mɩ́n, yɛ̂ ɛmɔ de di kɛ n vi Nyanmɩan anwʋn ɛlɔ yɛ̂ m malɩ ɔ. ");
INSERT INTO any_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","N vi Sɩɛ nɩn anwʋn ɛlɔ yɛ̂ m malɩ mân nɩn anun ɔ. Sian'n mɩɩn jasʋ mân nɩn anun mɩn kɔ Sɩɛ nɩn anwʋn ɛlɔ.” ");
INSERT INTO any_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Mɔ yɩ́ menian'n-mɔ tɩlɩ yɩ́ sɔ'n, bɛ́ nwan: “Sian dɩɛ, ɛ lɛ kpacɩ nun yuein kan kele yɛ́, ɛ mmu man yɩ́ anyɩnndala nun kʋ́n. ");
INSERT INTO any_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Sian dɩɛ, yɛ sɩ kɛ ɛ sɩ ninnge'n kʋalaatin, ɛ nnwʋnndɛ man maan yɛ mmisa man wɔ́ bie anwʋn kosuan bɔbɔ nán a bua yɛ́. Ɛhɩ ati, ɔ man yɛ de yɛ di kɛ ɛ fi Nyanmɩan ɛlɔ sakpa.” ");
INSERT INTO any_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Zozi nwan: “Sian'n ɛmɔ de di? ");
INSERT INTO any_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Yaa! Mɛlɛ'n lɛ ba, ɔ'a ju bɔbɔ a yue, ɛmɔ 'ba bɔ asanndɩɛ bɛ yaci mɩ́n ngʋnmɩn, ɛmɔ anun kʋn biala 'ba nwanndi fɩa. Nan kʋsʋ cɛcɛ, ɔ nga man mɩ́n ngʋnmɩn, ɔ sanlɩn kɛ Sɩɛ'n nʋn mɩ́n y'ɔ tɩ ɔ. ");
INSERT INTO any_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","“Mɩɩn kan sɔ mɩn kele ɛmɔ, nán mɩn man ɛmɔ nyan alʋacɩcɩɛ, afɩ ɛmɔ nʋn mɩ́n a yɔ kʋn. Ɛmɔ lɛ 'ba nwun yalɛ mân nɩn anun, nan kʋsʋ ɛmɔ bɔ́ mɔndɩnlɩn, nán bɛ man bɛ́ nwʋn bubu bɛ́, ɔ sanlɩn kɛ m'an li eyuadɩ nɩn asʋ kunnunmun.” ");
INSERT INTO any_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Mɔ Zozi hanlɩn ɛhɩ yuelɩ'n, ɔ kɔ tʋ yɩ́ nyɩn anwunno, yɩ́ nwan: “Mɩ́n Sɩ, dɔɛ nɩn a ju. Wula wɔ́ Wa nɩn anunminnyanmʋn maan yɩ́ kʋsʋ ɔ wúla wɔ́ bie. ");
INSERT INTO any_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Afɩ, a man yɩ́ tunmin dasannin biala asʋ kɛ bɛ́ mɔ a fa bɛ́ a man yɩ́'n, ɔ mán bɛ nyán ngʋan m'ɔ le man ayuelɩɛ'n. ");
INSERT INTO any_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Ngʋan m'ɔ le man ayuelɩɛ'n, y'ɔ le kɛ bɛ nwún wɔ́ mɔ ɛ tɩ ananhɔlɛ Nyanmɩan'n kʋnmgba cein, ɔ nʋn Zozi Kilisi, mɔ a sʋan yɩ́'n. ");
INSERT INTO any_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","M'an wula wɔ́ anunminnyanmʋn asɩɛ nɩn asʋ ɛwa. Ɔ sanlɩn kɛ junman'n mɔ a fa a man mɩ́n kɛ n ní'n, m'an yue yɩ́ di. ");
INSERT INTO any_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Afɩ kɩkaala dɩɛ, Mɩ́n Sɩ, anunminnyanmʋn'n mɔ anɩn n ne yɩ́ wɔ́ nwʋn ɛlɔ asannan nán a sesie mân'n, maan n nyán yɩ́ kʋnmgba sɔ'n wɔ wɔ́ nyunnun. ");
INSERT INTO any_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Menian'n-mɔ mɔ a fa bɛ́ a man mɩ́n asɩɛ nɩn asʋ ɛwa'n, m'an man b'a nwun wɔ́. Bɛ tɩ wɔ́ dɩɛ, yɛ̂ a fa bɛ́ a man mɩ́n. Bɛ́ kʋsʋ, b'a li wɔ́ ɛjɔlɛ nɩn asʋ. ");
INSERT INTO any_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Sian'n, b'a nwun kɛ yɩ́ kʋalaa mɔ a fa a man mɩ́n'n, ɔ fi wɔ́ ɛlɔ. ");
INSERT INTO any_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Ɔ sanlɩn kɛ ɛjɔlɛ'n mɔ a fa a wula mɩ́n sa nun'n, mɩ́n kʋsʋ m'an fa m'an wula bɛ́ sa nun, yɛ̂ b'a sɔ nun. B'a nwun yɩ́ kɛ n vi wɔ́ nwʋn ɛlɔ sakpa, yɛ̂ b'a le b'a li kɛ a sʋan mɩ́n. ");
INSERT INTO any_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“Mɩɩn yɔ asɔnɩn wɔ wɔ́ dunman nun mɩn man bɛ́. Mɩn nyɔ man asɔnɩn mɩn mman man eyuadɩ'n. Nan bɛ́ mɔ a fa bɛ́ a man mɩ́n'n, bɛ́ ti asɔnɩn yɛ̂ mɩɩn yɔ ɔ. Ɔ sanlɩn kɛ bɛ tɩ wɔ́ dɩɛ. ");
INSERT INTO any_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Like biala mɔ ɛ le yɩ́'n tɩ mɩ́n dɩɛ, mɩ́n kʋsʋ mɩ́n dɩɛ'n kʋalaa tɩ wɔ́ dɩɛ. Bɛ nwun mɩ́n anunminnyanmʋn'n wɔ bɛ́ nun. ");
INSERT INTO any_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Mɩ́n dɩɛ m'an jasʋ mân nɩn anun a yue, nan bɛ́ dɩɛ, bɛ tɛ wɔ nun. Mɩ́n dɩɛ mɩɩn ba wɔ́ nwʋn ɛlɔ. Sɩɛ Nwannzan-nwannzan, wɔ́ dunman'n mɔ tunmin wɔ nun'n, fa nɩan bɛ́ mɔ a fa bɛ́ a man mɩ́n nɩn asʋ, maan bɛ yɔ́ kʋn kɛ mɩn nʋn wɔ́, yɛ tɩ kʋn'n. ");
INSERT INTO any_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Mɔ anɩn mɩn nʋn bɛ́ wɔ mân nɩn anun'n, mɩn nɩan bɛ́ sʋ wɔ wɔ́ dunman nun. N nɩanlɩn bɛ́ sʋ kpa, bɛ́ bie fɩ́ɩ́ a mminlin man, sannan sʋanlan'n m'ɔ sɛ kɛ ɔ mínlin nán *Ɛhɛlɛ Ɛjɔlɛ'n nɩn a kpɩn sʋ'n. ");
INSERT INTO any_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","“Sian'n, mɩɩn ba wɔ́ nwʋn ɛlɔ, nan kɛmɔ n dɛ wɔ mân nɩn anun ɛwa'n, yɩ́ ti yɛ̂ ɔ man mɩɩn kan sɔ maan bɛ di fɛ kpili kpa kɛ mɩ́n nɩn ɔ. ");
INSERT INTO any_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","M'an fa wɔ́ ɛjɔlɛ'n m'an man bɛ́, yɛ̂ mân nɩn anun menian'n-mɔ lɛ kpɔ bɛ́, ɔ sanlɩn kɛ bɛ tɩ kɛ mɩ́n, bɛ tɩ man mân ɛhɩ anun menian. ");
INSERT INTO any_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Mɩɩn nzɛlɛ man wɔ́ kɛ ɛ yɩ́ bɛ́ fi mân nɩn anun, nan mɩ́n nwan ɛ nɩ́an bɛ́ sʋ, n'ɛ man *Abɔnsanmʋn nyan bɛ́. ");
INSERT INTO any_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Bɛ tɩ kɛ mɩ́n, kɛmɔ n dɩ man mân ɛhɩ anun sʋanlan'n, bɛ́ kʋsʋ, bɛ tɩ man mân ɛtɛ ɛhɩ anun menian. ");
INSERT INTO any_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Kɛmɔ wɔ́ nʋan ɛjɔlɛ'n tɩ ananhɔlɛ'n, nanndɩ ananhɔlɛ nɩn asʋ maan bɛ káci wɔ́ menian kpa bɔkɔɔ. ");
INSERT INTO any_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Mɩɩn sʋan bɛ́ mân nɩn anun kɛ ɛ sʋanlɩn mɩ́n'n. ");
INSERT INTO any_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Bɛ́ dunman nun ati, mɩɩn fa mɩ́n nwʋn mɩn wula wɔ́ sa nun kpa bɔkɔɔ maan bɛ́ kʋsʋ bɛ kaci wɔ́ menian kpa bɔkɔɔ. ");
INSERT INTO any_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Nán kɛ bɛ́ ngʋnmɩn bɛ́ ti ala yɛ̂ mɩɩn sɛlɛ wɔ́ ɔ, nan bɛ́ kʋalaa mɔ mɩ́n menian'n-mɔ kɔ han ɛjɔlɛ kɔ hele bɛ́ mɔ bɛ kɔ le bɛ kɔ li'n, mɩɩn sɛlɛ wɔ́ mɩn man bɛ́ kʋsʋ. ");
INSERT INTO any_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Mɩɩn sɛlɛ wɔ́ kɛ ɛ mán bɛ yɔ́ kʋn. Mɩ́n Sɩ, man bɛ nʋn yɛ́, yɛ yɔ́ kʋn kɛ mɩn nʋn wɔ́, yɛ tɩ kʋn'n. Man bɛ yɔ́ kʋn nán eyuadɩ nɩn a le a li kɛ wɔ́ yɛ̂ ɛ sʋanlɩn mɩ́n ɔ. ");
INSERT INTO any_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Anunminnyanmʋn'n mɔ ɛ falɩ manlɩn mɩ́n'n, m'an fa m'an man bɛ́, yɩ́ dɩɛ anɩn bɛ́ kʋalaa bɛ yɔ kʋn kɛ mɩn nʋn wɔ́ yɛ tɩ kʋn'n. ");
INSERT INTO any_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Man mɩn nʋn bɛ́, yɛ yɔ́ kʋn kɛ wɔ́ kʋsʋ ɛ nʋn mɩ́n, yɛ tɩ kʋn'n. Man bɛ yɔ́ sʋanlan kʋn bɔkɔɔ, nán eyuadɩ nɩn a nwun kɛ a sʋan mɩ́n, ɛsɛ ɛ kulo bɛ́ kɛ ɛ kulo mɩ́n'n. ");
INSERT INTO any_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Mɩ́n Sɩ, kɛmɔ a fa bɛ́ a man mɩ́n'n, mɩ́n kʋsʋ mɩn kulo kɛ lɩka mɔ n dɩ'n, bɛ́ kʋsʋ bɛ tanlan ɛbɛlɛ bie, nán b'a nwun mɩ́n anunminnyanmʋn'n, anunminnyanmʋn'n mɔ ɛ falɩ manlɩn mɩ́n'n. Ɔ sanlɩn kɛ ɛ lili mʋa ɛ hulolɩ mɩ́n asannan nán a sesie mân'n. ");
INSERT INTO any_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Mɩ́n Sɩ, wɔ́ mɔ ɛ tɩ sɛsɛfʋɛ, eyuadɩ amma'n nzɩ man wɔ́, nan mɩ́n dɩɛ, mɩn sɩ wɔ́. Yɛ̂ mɩ́n menian'n-mɔ kʋsʋ sɩ kɛ a sʋan mɩ́n. ");
INSERT INTO any_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","M'an man b'a nwun wɔ́, ɛsɛ mɩn 'ba man bɛ nwun wɔ́ kpa biekun. Yɩ́ dɩɛ, anɩn ehulo'n mɔ ɛ kulo mɩ́n'n tanlan bɛ nun, nán mɩ́n kʋsʋ mɩn nʋn bɛ́ a yɔ kʋn.” ");
INSERT INTO any_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Mɔ Zozi sɛlɛlɩ nzɛlɛ sɔ'n m'ɔ yuelɩ'n, ɔ nʋn yɩ́ menian'n-mɔ bɛ hɔlɩ asue baa'n mɔ bɛ fɛlɛ yɩ́ Sedʋnlʋn nɩn anzin ɛlɔ. Asue sɔ'n mantan Zoluzalɛmʋn. Yɩ́ nzin ɛlɔ, tola kʋn wɔ ɛbɛlɛ, ɔ nʋn yɩ́ menian'n-mɔ hɔlɩ wʋlʋlɩ nun. ");
INSERT INTO any_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Zudasɩ mɔ ɔ 'ba yɩ yɩ́ man'n, ɔ sɩ lɩka sɔ'n, afɩ ɔ yɔ a, Zozi nʋn yɩ́ menian'n-mɔ kɔ yia ɛlɔ. ");
INSERT INTO any_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Yɩ́ ti, Zudasɩ li *Lɔmʋn nʋn Zufʋ nzalafʋ dɔʋn anyunnun, bɛ kɔ a kɔ ju ɛbɛlɛ. Zufʋ nzalafʋ sɔ'n-mɔ, Nyanmɩan *tɛɛyɩfʋɛ mgbain'n-mɔ nʋn *Falisifʋɛ'n-mɔ yɛ̂ bɛ yɩlɩ bɛ́ ɔ. Mɔ bɛ 'ba'n, bɛ le kʋan ninnge, kanlannɩɛ nʋn tɛɛ. ");
INSERT INTO any_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Nan Zozi dɩɛ, ɔ sɩ yɩ́ kʋalaa mɔ ɔ lɛ 'ba tʋ yɩ́'n sie. Ɔ fi tola nɩn anun kɔ fite, yɩ́ nwan: “Ɛmɔ lɛ kpʋnndɛ nwan?” ");
INSERT INTO any_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Bɛ́ nwan: “Yɛ lɛ kpʋnndɛ Zozi m'ɔ fi Nazalɛtɩ'n.” Zozi nwan: “Mɩ́n ahɩ.” Zudasɩ m'ɔ lɛ yɩ yɩ́ man'n, anɩn ɔ nʋn bɛ́ yɛ̂ bɛ jijin ɛbɛlɛ ɔ. ");
INSERT INTO any_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Kɛ Zozi 'se kɛ: “Mɩ́n ahɩ” nɩn ala, nzalafʋ'n-mɔ kɔ bɔ si, bɛ́ kʋalaa bɛ kɔ hyʋɩn bɛ kɔ hɔ bɛ́ nzin bɛ kɔ han bɛ kɔ gua asɩ. ");
INSERT INTO any_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Mɔ Zozi nwunlin yɩ́ sɔ'n, yɩ́ nwan: “Ɛmɔ lɛ kpʋnndɛ nwan?” Bɛ́ nwan: “Zozi m'ɔ fi Nazalɛtɩ'n.” ");
INSERT INTO any_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Zozi nwan: “M'an se ɛmɔ kɛ y'ɔ le mɩ́n. Nan sɛ mɩ́n yɛ̂ ɛmɔ lɛ kpʋnndɛ mɩ́n sakpa a, anɩn ɛmɔ yáci menian ɛhɩ-mɔ maan bɛ hɔ́.” ");
INSERT INTO any_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Zozi hanlɩn sɔ maan ɛjɔlɛ'n m'ɔ hanlɩn yɩ́ mɛlɛ mɔ ɔ 'sɛlɛ Nyanmɩan man yɩ́ menian'n-mɔ'n kpɩnlɩn sʋ. Yɩ́ nwan: “Bɛ́ mɔ a fa bɛ́ a man mɩ́n'n, m'an mminlin man fɩ́ɩ́.” ");
INSERT INTO any_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Anɩn Simʋn Pɩɛlɩ le dadɩɛ, ɔ kɔ hyʋɩn kɔ kpɛ Nyanmɩan tɛɛyɩfʋɛ kpain nɩn akʋa nɩn anzʋ fama'n. Akʋa sɔ'n, bɛ fɛlɛ yɩ́ Malikusi. ");
INSERT INTO any_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Mɔ Zozi nwunlin yɩ́ sɔ'n, yɩ́ nwan: “Simʋn Pɩɛlɩ, fa wɔ́ dadɩɛ'n wula yɩ́ bʋa nɩn anun. Ɛ jʋnlɩn kɛ yalɛ'n mɔ mɩ́n Sɩ nwan n nwún yɩ́'n, mɩn ngɔ nwun man yɩ́ ɔ?” ");
INSERT INTO any_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Ɛhɩ a, *Lɔmʋn nzalafʋ'n-mɔ nʋn bɛ́ kpain'n, nʋn Zufʋ'n-mɔ nzalafʋ dɩɛ'n-mɔ kɔ hyɩ Zozi, bɛ kɔ cɩcɩ yɩ́. ");
INSERT INTO any_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Bɛ nʋn yɩ́ kɔ li mʋa kɔ hɔ Nannan Hannɩn awulo. Hannɩn sɔ'n tɩ *tɛɛyɩfʋɛ kpain daba. Kayifʋ m'ɔ tɩ Nyanmɩan tɛɛyɩfʋɛ kpain afʋɛ sɔ nɩn anun'n, ɔ ja Hannɩn awa balasua. ");
INSERT INTO any_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Kayifʋ kʋsʋ yɛ̂ ɔ hanlɩn helelɩ Zufʋ'n-mɔ kɛ: “Sɛ sʋanlan kʋn wu a, ɔ tɩ kpa tala kɛ mân bɔndɩn'n kɔ bɔ'n.” ");
INSERT INTO any_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Mɔ bɛ nʋn Zozi 'kɔ Nyanmɩan tɛɛyɩfʋɛ kpain nɩn awulo ɛlɔ'n, Simʋn Pɩɛlɩ nʋn Zozi sʋanlan'n kʋn biekun bɛ sili yɩ́ sʋ. Zozi sʋanlan sɔ'n, tɛɛyɩfʋɛ kpain'n sɩ yɩ́. Mɔ bɛ 'wʋlʋ awulo nɩn akunnun ɛlɔ'n, ɔ wʋlʋlɩ ɛlɔ bie. ");
INSERT INTO any_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Nan Pɩɛlɩ dɩɛ, ɔ halɩ gua sʋ ɛlɔ anʋan nɩn anwʋn ɛbɛlɛ. Zozi sʋanlan kʋn'n mɔ tɛɛyɩfʋɛ kpain'n sɩ yɩ́'n kɔ fite. Ɔ kɔ han kɔ hele balasua'n m'ɔ sisa anʋan'n ɔ kɔ man Pɩɛlɩ kɔ wʋlʋ. ");
INSERT INTO any_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Afanɩan'n m'ɔ nɩan anʋan nɩn asʋ'n kɔ bisa Pɩɛlɩ kɛ: “N ja bian, asʋ wɔ́ kʋsʋ, ɛ tɩ man bian sɔ'n sʋanlan ɔ?” Simʋn Pɩɛlɩ nwan: “Cɛcɛ, nán yɩ́ sʋanlan y'ɔ le mɩ́n.” ");
INSERT INTO any_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Kɛmɔ anɩn ɛyɛlɛ wɔ nun'n, ngʋa'n-mɔ nʋn nzalafʋ'n-mɔ a huan sɩ̂n bɛ jijin yɩ́ nwʋn bɛ lɛ tɩ. Pɩɛlɩ kʋsʋ kɔ a kɔ jinlan bɛ́ nwʋn ɛbɛlɛ ɔ lɛ tɩ bie. ");
INSERT INTO any_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Mɛlɛ sɔ'n, anɩn Nyanmɩan tɛɛyɩfʋɛ kpain'n lɛ bisa Zozi yɩ́ menian'n-mɔ nʋn yɩ́ ninnge'n m'ɔ kekele nɩn anwʋn kosuan. ");
INSERT INTO any_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Zozi kɔ bua yɩ́ kɛ: “M'an han yɩ́ bagua nun m'an hele mân'n bɔndɩn'n. Mɩ́n ninnge'n kʋalaa mɩn kekele yɩ́ cɩan daa lɩka mɔ Zufʋ'n-mɔ yia'n, bɛ́ asɔnɩn sua'n-mɔ anun ɔ nʋn Nyanmɩan awulo nɩn anun. Mɩ́n ɛjɔlɛ'n kʋalaa mɔ mɩn kan'n, nán nvɩalɩɛ nun ɔ. ");
INSERT INTO any_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Nan nzukɛ ati yɛ̂ ɛ tɛ bisa mɩ́n yɩ́ nwʋn kosuan ɔ? Bisa bɛ́ mɔ n ganlɩn ɛjɔlɛ'n n gelelɩ bɛ́ mɔ bɛ tɩlɩ'n. Bɛ́ dɩɛ, bɛ sɩ ɛjɔlɛ'n mɔ n ganlɩn n gelelɩ bɛ́'n kpa bɔkɔɔ.” ");
INSERT INTO any_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Zozi anʋan a ndɔ man, nzalafʋ'n-mɔ anun kʋn m'ɔ mantan yɩ́ nwʋn ɛbɛlɛ'n kɔ kpɛ yɩ́ nyɩn nɩn asʋ. Yɩ́ nwan: “Asʋ, kɛ bɛ kan ɛjɔlɛ bɛ kele Nyanmɩan tɛɛyɩfʋɛ kpain nɩn anɩn?” ");
INSERT INTO any_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Zozi nwan: “Sɛ m'an han ɛjɔlɛ ɛtɛ a, kele mɩ́n ɛjɔlɛ ɛtɛ ɛhɔlɛ kʋn mɔ m'an han'n. Sɛ kʋsʋ m'an ngan man ɛjɔlɛ ɛtɛ a, anɩn nzukɛ ati yɛ̂ ɛ kpacɩ mɩ́n nyɩnsʋ ɔ?” ");
INSERT INTO any_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Ɛhɩ a, Hannɩn ngɔ man bɛ ngɔ nyannjɩ man Zozi, ɔ kɔ man bɛ kɔ fa yɩ́ bɛ kɔ hɔ kɔ wula Nyanmɩan tɛɛyɩfʋɛ kpain Kayifʋ asa nun. ");
INSERT INTO any_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Ɔ 'ba yɔ sɔ'n, anɩn Pɩɛlɩ tɛ jin sɩ̂n nɩn anwʋn ɛbɛlɛ. Bɛ́ mɔ bɛ jijin sɩ̂n nɩn anwʋn ɛbɛlɛ'n kɔ bisa yɩ́ kɛ: “Asʋ wɔ́ kʋsʋ wɔ́, ɛ tɩ man bian sɔ'n sʋanlan'n bie ɔ?” Pɩɛlɩ nwan: “Cɛcɛ, nán yɩ́ sʋanlan'n bie y'ɔ le mɩ́n.” ");
INSERT INTO any_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Tɛɛyɩfʋɛ kpain nɩn akʋa'n kʋn mɔ yɩ́ abie y'ɔ le nunhan'n mɔ Pɩɛlɩ kpɛlɩ yɩ́ nzʋ'n nwan: “Asʋ m'an nnwun man wɔ́ nʋn yɩ́ tola nɩn anun ɛlɔ ɔ?” ");
INSERT INTO any_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Ɛsɛ Simʋn Pɩɛlɩ nwan nán yɩ́ ɔ. Ɔ 'kan sɔ nɩn ala, kokolokoo! Akɔ kʋn kɔ bɔ. ");
INSERT INTO any_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Ngɛlɛmɔ tutun kpa, kɛ alɩ́ɛ'n hɩnlɩn ɛbɛlɛ ala, bɛ́ nʋn Zozi fi kpain Kayifʋ awulo ɛbɛlɛ, bɛ kɔ fa yɩ́ kɔ hɔ *Lɔmʋn kʋnmanna nɩn awulo ɛlɔ. Kɛmɔ ɔ tɩ man Zufʋ'n, sɛ Zufʋ'n-mɔ wʋlʋ yɩ́ awulo ɛlɔ a, anɩn efian a han bɛ́, bɛ ngʋala man *Pakɩ'n bie di, ɛhɩ ati b'a nwʋlʋ man ɛlɔ bie. ");
INSERT INTO any_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Bɛ manlɩn *Pilatɩ muonun fitelɩ walɩ bɛ́ nwʋn ɛbɛlɛ, nán ɔ'a bisa bɛ́ kɛ: “Bian ɛhɩ a yɔ nzu mɔ ɛmɔ lɛ 'ba sanman yɩ́ ɔ?” ");
INSERT INTO any_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Bɛ́ nwan: “Sɛ ɔ tɩ man ɛtɛfʋɛ a, ahan yɛ nva man yɩ́ yɛ mmɛlɛ man wɔ́.” ");
INSERT INTO any_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Pilatɩ nwan: “Ɛmɔ muonun nʋn yɩ́ hɔ́, bɛ hɔ́ búa yɩ́ ndɛɛ kɛ ɛmɔ mala'n kele'n.” Mɔ Zufʋ'n-mɔ tɩlɩ ɛjɔlɛ sɔ'n, bɛ́ nwan: “Yɛ le man atɩn kɛ yɛ kun yɩ́.” ");
INSERT INTO any_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Ɛjɔlɛ mɔ Zozi hanlɩn helelɩ ehuan ɛhɔlɛ kʋn'n mɔ bɛ 'ba hun yɩ́'n, kɛ ɔ yɔlɩ mɔ ɛjɔlɛ sɔ'n kpɩnlɩn sʋ nɩn anɩn. ");
INSERT INTO any_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Ɛhɩ a, Pilatɩ kɔ wʋlʋ sua nɩn anun ɛlɔ ɔ kɔ fɛlɛ Zozi ɔ kɔ bisa yɩ́ kɛ: “N ja bian, asʋ Zufʋ'n-mɔ belemgbin'n y'ɔ le wɔ́ ɔ?” ");
INSERT INTO any_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Zozi nwan: “Wɔ́ muonun wɔ́ ti anun yɛ̂ a bɔ mɔ ɛ lɛ kan sɔ anaan, menian yɛ̂ b'a han mɩ́n nwʋn ɛjɔlɛ b'a hele wɔ́, yɩ́ ti yɛ̂ ɔ man ɛ lɛ bisa mɩ́n kosuan sɔ nɩn ɔ?” ");
INSERT INTO any_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pilatɩ nwan: “Ɛ nɩan an, anɩn Zufʋ y'ɔ le mɩ́n ɔ? Wɔ́ mân nɩn anun menian'n-mɔ nʋn tɛɛyɩfʋɛ mgbain'n-mɔ yɛ̂ b'a fa wɔ́ b'a bɛlɛ mɩ́n ɔ. Nan ɛ yɔlɩ nzu?” ");
INSERT INTO any_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Mɔ Zozi tɩlɩ ɛjɔlɛ sɔ'n, yɩ́ nwan: “N dɩ man mân ɛhɩ anun belemgbin. Nan sɛ n dɩ mân ɛhɩ anun belemgbin an, ahan mɔ Zufʋ mgbain'n-mɔ 'cɩ mɩ́n'n, mɩ́n ngʋa'n-mɔ hʋnlɩn lelɩ mɩ́n maan b'a ngʋala man mɩ́n cɩ. Nan kʋsʋ ɔ tɩ man sɔ, mɩn nni man belemgbin mân ɛhɩ anun.” ");
INSERT INTO any_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Pilatɩ nwan: “Yɩ́ ti, belemgbin y'ɔ le wɔ́ sakpa?” Zozi nwan: “Wɔ́ nʋan wɔ sʋ ɛ lɛ kan, belemgbin y'ɔ le mɩ́n. Bɛ wʋlɩ mɩ́n, m malɩ mân nɩn anun kɛ mɩn 'ba han ananhɔlɛ nɩn anwʋn ɛjɔlɛ. Ɔ man sʋanlan biala m'ɔ tɩ ananhɔlɛ'n sʋanlan'n, ɔ tie ɛjɔlɛ'n mɔ mɩn kan'n.” ");
INSERT INTO any_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Mɔ Pilatɩ tɩlɩ ɛjɔlɛ sɔ'n, yɩ́ nwan: “Apii, ananhɔlɛ'n y'ɔ le nzu?” Kɛ Pilatɩ hanlɩn sɔ yuelɩ'n, ɔ kɔ sa kɔ hɔ Zufʋ'n-mɔ anwʋn ɛlɔ, yɩ́ nwan: “Mɩ́n dɩɛ, mɩn nnwun man like mɔ yɩ́ ti yɛ̂ ɔ di kɛ bɛ kun sʋanlan sɔ nɩn ɔ. ");
INSERT INTO any_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Nan ɔ tɩ mala wɔ ɛmɔ afian ɛwa, sɛ bɛ 'di *Pakɩ biala a, bɛ́ mɔ bɛ kɔ gua bɛ́ fiadɩ'n, mɩn yɩ kʋn. Yɩ́ ti, asʋ ɛmɔ kulo kɛ mɩn yaci Zufʋ'n-mɔ belemgbin nɩn ɔ?” ");
INSERT INTO any_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Mɔ bɛ tɩlɩ ɛjɔlɛ sɔ'n, bɛ kɔ tɛtɩan nun, bɛ́ nwan: “Cɛcɛ, nán yɩ́ yɛ̂ yɛ kulo kɛ ɛ yaci yɩ́ ɔ! Nan yɛ́ dɩɛ, Balabasɩ yɛ̂ yɛ kulo kɛ ɛ yɩ yɩ́ ɔ!” Balabasɩ sɔ'n kʋsʋ a, ɔ tɩ kodiawu. ");
INSERT INTO any_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Ɛhɩ a, Pilatɩ kɔ man nzalafʋ'n-mɔ atɩn kɛ bɛ fá Zozi bɛ hɔ́ fín yɩ́ mgbele. ");
INSERT INTO any_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Nzalafʋ'n-mɔ kɔ fin Zozi mgbele ɛsɛ bɛ kɔ nwʋn abotile kɛ mmelemgbin'n-mɔ dɩɛ'n, bɛ kɔ bɔ Zozi ati. Abotile sɔ'n, bɛ le eminlan mmowe yɛ̂ b'a nwʋn ɔ. Bɛ kɔ wula yɩ́ taladɩɛ kɔkɔlɛ kʋsʋ bɛ kɔ bʋka sʋ. ");
INSERT INTO any_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Bɛ cʋɩn bɛ mantan yɩ́, anɩn bɛ́ nwan: “Zufʋ'n-mɔ belemgbin, ahɩn o! Zufʋ'n-mɔ belemgbin, ahɩn o!” Anɩn bɛ 'kpɛ yɩ́ nyɩn nɩn asʋ. ");
INSERT INTO any_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Bɛ wɔ ɛbɛlɛ kaan an, ɛsɛ Pilatɩ kɔ fite biekun, yɩ́ nwan: “Ɛmɔ Zufʋ'n-mɔ, bɛ nɩ́an, mɩɩn fa yɩ́ mɩn bɛlɛ ɛmɔ mɩn man ɛmɔ nwun kɛ mɩn nnwun man like mɔ ɔ'a yɔ m'ɔ di kɛ bɛ kun yɩ́ ɔ.” ");
INSERT INTO any_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Kɛ Pilatɩ 'kan sɔ ala, nzalafʋ'n-mɔ nʋn Zozi kɔ fite, yɩ́ mmowe abotile'n bɔ yɩ́ ti, yɩ́ taladɩɛ kɔkɔlɛ'n wula yɩ́. Pilatɩ nwan: “Sʋanlan nɩn ahɩ o!” ");
INSERT INTO any_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Mɔ Nyanmɩan *tɛɛyɩfʋɛ mgbain'n-mɔ nʋn bɛ́ nzalafʋ'n-mɔ nwunlin yɩ́'n, bɛ lɛ tɛtɩan nun kpa, bɛ́ nwan: “Bɛ bʋ́bɔ yɩ́ kʋlʋwa sʋ, bɛ bʋ́bɔ yɩ́ kʋlʋwa sʋ!” Mɔ Zufʋ'n-mɔ hanlɩn sɔ'n, Pilatɩ nwan: “Ɛmɔ muonun fá yɩ́ hɔ́ bʋ́bɔ yɩ́ kʋlʋwa sʋ, nan mɩ́n dɩɛ, mɩn nnwun man ɛtɛ mɔ ɔ'a yɔ ɔ.” ");
INSERT INTO any_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Zufʋ'n-mɔ nwan: “Yɛ le yɛ́ mala kʋn, mala sɔ'n kele kɛ nán bɛ kan ɛjɔlɛ ɛtɛ bɛ tia Nyanmɩan Kpili. Yɩ́ kʋsʋ ɔ'a han ɛjɔlɛ ɛtɛ ɔ'a tia Nyanmɩan, afɩ yɩ́ nwan ɔ tɩ Nyanmɩan Awa, yɩ́ ti, ɔ sɛ kɛ bɛ kun yɩ́.” ");
INSERT INTO any_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Mɔ Pilatɩ tɩlɩ ɛjɔlɛ sɔ'n, esulo hanlɩn yɩ́ biekun kpa. ");
INSERT INTO any_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Ɔ kɔ sa kɔ wʋlʋ awulo ɛlɔ, ɔ kɔ bisa Zozi kɛ: “Ɛ fi nin?” Zozi ngɔ tɛ yɩ́ sʋ. ");
INSERT INTO any_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Pilatɩ nwan: “Mɩ́n yɛ̂ ɛ lɛ kpinlin mɩ́n'n? Ɛ nzɩ man kɛ mɩn kʋala kɛ mɩn man bɛ yaci wɔ́, ɛsɛ mɩn kʋala kɛ mɩn man bɛ bʋbɔ wɔ́ kʋlʋwa sʋ ɔ?” ");
INSERT INTO any_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Mɔ Pilatɩ hanlɩn sɔ'n, Zozi nwan: “Sɛ nán tunmin'n mɔ Nyanmɩan falɩ manlɩn wɔ́ nɩn ala a, ɛ le man tunmin fɩ́ɩ́ kʋ́n mɩ́n sʋ. Yɩ́ sɔ ati, Kayifʋ m'ɔ yɩlɩ mɩ́n manlɩn wɔ́'n, yɩ́ ɛtɛ dɩɛ mɔ ɔ'a yɔ'n tala wɔ́ dɩɛ'n.” ");
INSERT INTO any_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Ɛbɛlɛ ala, Pilatɩ lɛ kpʋnndɛ atɩn ɔ yaci Zozi. Mɔ Zufʋ'n-mɔ nwunlin yɩ́ sɔ'n, bɛ lɛ tɛtɩan nun sɛlɛ kpa, bɛ́ nwan: “Sɛ ɛ yaci sʋanlan ɛhɩ a, anɩn nán wɔ́ manngʋn y'ɔ le *Sezaa, afɩ sʋanlan biala m'ɔ bu yɩ́ nwʋn kɛ ɔ tɩ belemgbin'n, anɩn ɔ kpɔ belemgbin Sezaa.” ");
INSERT INTO any_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Mɔ Pilatɩ tɩlɩ ɛjɔlɛ sɔ'n, ɔ kɔ man bɛ kɔ fa Zozi bɛ nʋn yɩ́ kɔ fite Zufʋ'n-mɔ anyunnun. Yɩ́ muonun kʋsʋ ɔ kɔ tanlan yɩ́ bia nɩn asʋ, lɩka mɔ bɛ tanlan bɛ di ɛjɔlɛ'n. Lɩka sɔ'n, bɛ le nyɔbʋɛ ndɛtɛlɛ kpa yɛ̂ b'a fa b'a sɩsɛ asɩɛ nɩn anwʋn kɛ kalo. *Ebele anɩɛ nɩn anun, bɛ fɛlɛ yɩ́ “gabata”. ");
INSERT INTO any_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Cɩan sɔ'n kʋsʋ, yɩ́ alɩ́ɛ cɩn an, anɩn ɔ tɩ Zufʋ'n-mɔ ɛnwʋnmɩan ele cɩan. Anɩn sɛnzɛ nɩn a ju bɛ́ ti afian. Pilatɩ kɔ fa kɔ tʋ Zufʋ'n-mɔ anyunnun, yɩ́ nwan: “Ɛmɔ belemgbin nɩn ahɩ o!” ");
INSERT INTO any_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Mɔ Pilatɩ hanlɩn sɔ helelɩ bɛ́'n, bɛ lɛ tɛtɩan nun, bɛ́ nwan: “Bɛ hún yɩ́! Bɛ hún yɩ́! Bɛ bʋ́bɔ yɩ́ kʋlʋwa sʋ!” Pilatɩ nwan: “Yɩ́ ti, bɛ bʋ́bɔ ɛmɔ belemgbin'n kʋlʋwa sʋ?” Ɛbɛlɛ ala, Nyanmɩan tɛɛyɩfʋɛ mgbain'n-mɔ nwan: “Yɛ́ belemgbin nɩn ala y'ɔ le *Sezaa, sɛ ɛ yɩ yɩ́ a, yɛ le man belemgbin fɩ́ɩ́ kʋ́n.” ");
INSERT INTO any_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Kɛ bɛ hanlɩn sɔ yuelɩ'n, Pilatɩ manlɩn nzalafʋ'n-mɔ atɩn kɛ bɛ bʋ́bɔ Zozi kʋlʋwa sʋ. Ɛhɩ a, bɛ kɔ sɔ Zozi bɛ nʋn yɩ́ kɔ hɔ. ");
INSERT INTO any_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Ɛhɩ, Zozi muonun sʋ yɩ́ kʋlʋwa'n fi kulo nɩn asʋ ɔ kɔ fite kɔ hɔ lɩka kʋn. Lɩka sɔ'n, *ebele anɩɛ nɩn anun bɛ fɛlɛ yɩ́ “Gɔlʋgota”, yɩ́ bʋ y'ɔ le kɛ “tile kangɔ lɩka.” ");
INSERT INTO any_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Ɛbɛlɛ, nzalafʋ'n-mɔ kɔ bʋbɔ Zozi kʋlʋwa nɩn asʋ. Lɩka kʋnmgba sɔ'n, bɛ kɔ bʋbɔ kodiawu nnyuan kʋsʋ kʋlʋwa sʋ, kʋn wɔ yɩ́ bɛ̂ sʋ, kʋn kʋsʋ wɔ yɩ́ fama sʋ, yɛ̂ Zozi wɔ bɛ́ afian. ");
INSERT INTO any_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pilatɩ kɔ man bɛ kɔ hɛlɛ kalata bɛ kɔ bɔ Zozi kʋlʋwa nɩn ati sʋ kɛ: “Zozi m'ɔ fi Nazalɛtɩ, Zufʋ'n-mɔ belemgbin.” ");
INSERT INTO any_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Zufʋ'n-mɔ dɔʋn kɩnngalɩ ɛjɔlɛ sɔ'n mɔ bɛ hɛlɛlɩ'n, ɔ sanlɩn kɛ lɩka mɔ bɛ bʋbɔlɩ Zozi kʋlʋwa nɩn asʋ'n mantan kulo'n kʋkʋ. Ɛjɔlɛ sɔ'n kʋsʋ, b'a hɛlɛ yɩ́ *ebele anɩɛ nun, b'a hɛlɛ yɩ́ *latɩn anɩɛ nun, ɛsɛ b'a hɛlɛ yɩ́ *gɛlɛkɩ anɩɛ nun. ");
INSERT INTO any_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Mɔ Nyanmɩan tɛɛyɩfʋɛ mgbain'n-mɔ nwunlin ɛhɛlɛ sɔ'n, bɛ hɔlɩ tʋlɩ Pilatɩ a, bɛ́ nwan: “Pilatɩ, ahan a ngɛlɛ man yɩ́ kɛ ‘Zufʋ'n-mɔ belemgbin’, nan ahan ɛ hɛlɛlɩ yɩ́ kɛ ‘sʋanlan ɛhɩ nwan ɔ tɩ Zufʋ'n-mɔ belemgbin.’” ");
INSERT INTO any_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pilatɩ nwan: “Mɔ m'an hɛlɛ'n, bɛ ngaci man yɩ́ kʋ́n.” ");
INSERT INTO any_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Ɛhɩ, bɛ kɔ bʋbɔ Zozi kʋlʋwa nɩn asʋ, bɛ kɔ hye yɩ́ taladɩɛ'n-mɔ anun nnan bɛ kɔ fa. Bɛ́ nun kʋn biala kɔ nyan m'ɔ fata ɔ. Ɔ kɔ ha yɩ́ bubu'n. Taladɩɛ sɔ'n kʋsʋ, ɔ fa yɩ́ anwunno dede m'ɔ ju yɩ́ asɩ'n, ɔ le man mgbalɩɛ, bɛ nwʋnlɩn yɩ́ wolologɔ kʋnmgba. ");
INSERT INTO any_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Mɔ nzalafʋ'n-mɔ hyelɩ yɩ́ taladɩɛ ɛhɩnlɩn-mɔ anun yuelɩ'n, bɛ wɔ ɛbɛlɛ kaan an, nunhan kʋn kɔ fa kɔ tʋ yɩ́ manngʋn'n-mɔ anyunnun kɛ: “Ebia-mɔ, taladɩɛ kʋn ɛhɩ m'ɔ wɔ ɛwa'n, nán bɛ man yɛ sosua nun, nan bɛ mán yɛ hyʋ́ɩn tondo yɛ nwún sʋanlan m'ɔ kɔ nyan yɩ́ ɔ.” *Ɛhɛlɛ Ɛjɔlɛ nɩn anun, b'a hɛlɛ kɛ: B'a hye mɩ́n nwʋn ninnge'n-mɔ b'a fa, yɛ̂ b'a hyʋɩn tondo b'a fa mɩ́n taladɩɛ'n. Kɛ ɔ yɔlɩ mɔ ɛjɔlɛ sɔ'n kpɩnlɩn sʋ nɩn anɩn. Mɔ nzalafʋ'n-mɔ yɔlɩ nɩn anɩn. ");
INSERT INTO any_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Anɩn Zozi anin'n nʋn yɩ́ nin anianman balasua'n nʋn Kolopasɩ ayɩ Mali yɛ̂ Mali m'ɔ fi Magɩdala'n, bɛ́ kʋalaa bɛ jijin Zozi kʋlʋwa nɩn anwʋn ɛbɛlɛ. ");
INSERT INTO any_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Mɔ Zozi nwunlin kɛ sʋanlan'n m'ɔ kulo yɩ́'n jin yɩ́ nin anwʋn ɛbɛlɛ'n, ɔ kɔ fɛlɛ yɩ́ nin ɔ kɔ han kɔ hele yɩ́ kɛ: “M mo, ɛ 'nwun wɔ́ wa.” ");
INSERT INTO any_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","M'ɔ hanlɩn sɔ yuelɩ'n, ɔ kpɛlɩ yɩ́ nyɩn sʋanlan'n m'ɔ kulo yɩ́'n kʋsʋ anwʋn ɛlɔ a, yɩ́ nwan: “Ɛ 'nwun wɔ́ nin.” Ɔ fi ɛbɛlɛ, yɩ́ sʋanlan'n falɩ yɩ́ nin hɔlɩ yɩ́ awulo. ");
INSERT INTO any_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Mɔ Zozi hanlɩn sɔ yuelɩ'n, sian'n yɩ́ muonun ɔ nɩan an, anɩn yɩ́ nwʋn ɛjɔlɛ'n mɔ Ɛhɛlɛ Ɛjɔlɛ'n hanlɩn'n kʋalaa a kpɩn sʋ. Ɛbɛlɛ ala, yɩ́ nwan: “Nzuhoe lɛ kun mɩ́n.” ");
INSERT INTO any_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Anɩn bua kʋn jin ɛbɛlɛ, vinɛgɩlɩ yi yɩ́. Mɔ Zozi hanlɩn sɔ nɩn ala, nzalafʋ'n-mɔ kɔ nɩan ɛbɛlɛ bɛ kɔ fa eminlan kʋn bɛ kɔ bɔ vinɛgɩlɩ sɔ nɩn anun. Bɛ kɔ sinnze yɩ́ baka kʋn ati. Baka sɔ'n, bɛ fɛlɛ yɩ́ *Izɔpʋ. Bɛ kɔ fa bɛ kɔ han Zozi anʋan. ");
INSERT INTO any_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Mɔ vinɛgɩlɩ'n hanlɩn yɩ́ nʋan yuelɩ'n, yɩ́ nwan: “Sian dɩɛ, ɔ'a yue.” Kɛ ɔ hanlɩn sɔ mɔ ɔ 'si yɩ́ ti asɩ ala, ɔ kɔ ha nun. ");
INSERT INTO any_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Cɩan mɔ bɛ hunlin Zozi'n, yɩ́ alɩ́ɛ cɩn an, ɔ tɩ ɛnwʋnmɩan elie cɩan. Yɩ́ sɔ ati, bɛ́ mɔ b'a bʋbɔ bɛ́ kʋlʋwa sʋ'n, Zufʋ'n-mɔ ngulo man kɛ bɛ́ fuin'n ka ɛbɛlɛ dede *ɛnwʋnmɩan elie cɩan'n ju. Afɩ cɩan sɔ'n tɩ cɩan kpili kpa. Ɛhɩ kʋalaa ati, Zufʋ'n-mɔ sɛlɛlɩ *Pilatɩ kɛ ɔ mán nzalafʋ'n-mɔ búbu menian sɔ'n-mɔ aja'n, nán bɛ yɩ́ bɛ́ kʋlʋwa nɩn asʋ. ");
INSERT INTO any_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Nzalafʋ'n-mɔ walɩ a, menian nnyuan'n mɔ b'a bʋbɔ bɛ́ kʋlʋwa sʋ Zozi anwʋn ɛbɛlɛ'n, bɛ kɔ li mʋa bɛ kɔ bubu kʋn nɩn aja'n, ɛsɛ bɛ kɔ bubu kʋn'n kʋsʋ dɩɛ'n. ");
INSERT INTO any_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Bɛ́ nwan bɛ 'bubu Zozi dɩɛ'n, bɛ 'ju yɩ́ nwʋn ɛbɛlɛ a, anɩn ɔ'a wu. Yɩ́ ti, b'a mmubu man yɩ́ ja'n. ");
INSERT INTO any_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Kɛ ɔ yɔlɩ sɔ'n, nzalafʋ'n-mɔ anun kʋn falɩ yɩ́ acɔ'n wɔlɩ Zozi anvɩn nɩn anun. Ɛbɛlɛ ala, moja nʋn nzue fi nun kɔ fite. ");
INSERT INTO any_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Sʋanlan'n m'ɔ lɛ kan ɛjɔlɛ ɛhɩ kʋalaatin'n, ɔ'a nwun ninnge sɔ'n-mɔ yɩ́ muonun yɩ́ nyɩnsʋ. Yɛ̂ yɩ́ ɛjɔlɛ'n m'ɔ lɛ kan'n kʋsʋ tɩ ananhɔlɛ. Ɔ sɩ kɛ ɔ lɛ kan ananhɔlɛ, ɔ 'kan maan ɛmɔ kʋsʋ de di. ");
INSERT INTO any_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Ninnge sɔ'n yɔlɩ sɔ, ɔ man *Ɛhɛlɛ Ɛjɔlɛ'n lɩka m'ɔ lɛ kan kɛ: B'a mmu man yɩ́ bowe kʋnmgba cein anun, ɔ kpɩnlɩn sʋ. ");
INSERT INTO any_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Ɛsɛ b'a hɛlɛ wɔ lɩka fʋfɔlɛ kɛ: Bɛ 'ba kaci bɛ́ nyɩn sʋanlan'n mɔ bɛ wɔlɩ yɩ́ nvɩn nɩn anun acɔ nɩn anwʋn ɛlɔ. ");
INSERT INTO any_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Ɛhɩ anzin, Zozɛfʋ m'ɔ fi Alimate kulo nɩn asʋ'n, ɔ hɔlɩ sɛlɛlɩ Pilatɩ kɛ ɔ 'fa Zozi fuin'n ɔ 'kɔ a sie yɩ́. Zozɛfʋ sɔ'n, Zozi sʋanlan kʋn y'ɔ le yɩ́, nan kʋsʋ, kɛmɔ ɔ sulo Zufʋ mgbain'n-mɔ nɩn ati, ɔ nyɩ man yɩ́ nwʋn ɔ ngele man. Kɛ ɔ hanlɩn sɔ nɩn ala, Pilatɩ kɔ man yɩ́ atɩn. Zozɛfʋ kɔ a kɔ fa Zozi fuin'n kɔ hɔ. ");
INSERT INTO any_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Ninkodɛmʋn mɔ cɩan kʋn kɔngɔɛ ɔ walɩ Zozi anwʋn ɛbɛlɛ'n, yɩ́ kʋsʋ ɔ 'ba a, ɔ le alufanlan kɔ yɔ tonun abulasan. ");
INSERT INTO any_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Bɛ́ menian nnyuan, bɛ kɔ fa Zozi fuin'n, bɛ kɔ fa kisaan bɛ kɔ fʋfɔ yɩ́ nwʋn. Bɛ kɔ fa alufanlan sɔ'n bɛ kɔ gugua kisaan nɩn anun kɛ Zufʋ'n-mɔ 'sie sʋanlan an, bɛ yɔ yɩ́'n. ");
INSERT INTO any_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Lɩka mɔ bɛ bʋbɔlɩ Zozi kʋlʋwa nɩn asʋ'n, tola kʋn wɔ yɩ́ nwʋn ɛbɛlɛ. Tola sɔ nɩn anun, sɛka fʋfɔlɛ kʋn wɔ ɛbɛlɛ, bɛ sielɩ man sʋanlan fɩ́ɩ́ nun lé. ");
INSERT INTO any_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Kɛmɔ alɩ́ɛ cɩn an, anɩn ɔ tɩ Zufʋ'n-mɔ ɛnwʋnmɩan elie cɩan'n, mɔ ɛsɛ sɛka'n kʋsʋ mantan bɛ́ nwʋn ɛbɛlɛ ala'n, ɔ man bɛ hɔlɩ sielɩ yɩ́ nun. ");
INSERT INTO any_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Ɛhɩ, mɔlɛ'n ngɛlɛmɔ tutun kpa, anɩn mân nɩn anun yuelɩ man tɩtɩ, Mali m'ɔ fi Magɩdala'n kɔ jasʋ kɔ hɔ Zozi sɛka nɩn asʋ ɛlɔ. Ɔ 'kɔ a ju a, b'a kunndo ɛbʋta'n m'ɔ nyin sɛka nɩn anʋan'n. ");
INSERT INTO any_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Ɛhɩ a, ɔ le ɛnwanndie ɔ kɔ hɔ kɔ tʋ Simʋn Pɩɛlɩ nʋn sʋanlan'n mɔ Zozi kulo yɩ́'n, yɩ́ nwan: “B'a yɩ yɛ́ Mɩn yɩ́ sɛka nɩn anun, yɛ nnwun man lɩka mɔ bɛ nʋn yɩ́ a hɔ ɔ.” ");
INSERT INTO any_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Mɔ bɛ tɩlɩ ɛjɔlɛ sɔ'n, sʋanlan sɔ'n nʋn Pɩɛlɩ, bɛ kɔ jasʋ bɛ kɔ fa Zozi sɛka nɩn asʋ atɩn'n, bɛ lɛ kɔ a nɩan. ");
INSERT INTO any_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Bɛ́ munnyuan bɛ 'kɔ a, anɩn bɛ lɛ nwanndi. Nan kɛmɔ sʋanlan kʋn'n kʋala nwanndi tala Pɩɛlɩ'n, ɔ kɔ yaci yɩ́ kɔ hɔ, ɔ kɔ li mʋa kɔ ju sɛka nɩn asʋ ɛlɔ. ");
INSERT INTO any_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Kɛ ɔ 'ju ɛbɛlɛ ala, ɔ kɔ han yɩ́ nwʋn asɩ kɔ nɩan kunman nɩn anun. Ɔ 'nɩan an, ɛtanlan'n mɔ bɛ falɩ bɛ sielɩ Zozi'n gua ɛbɛlɛ, kʋsʋ ɔ'a nju man kunman nɩn anun. ");
INSERT INTO any_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Simʋn Pɩɛlɩ juli ɛbɛlɛ a, ɔ kɔ ju kunman nɩn anun. Ɔ 'nɩan an, kisaan'n mɔ bɛ falɩ fʋfɔlɩ Zozi anwʋn'n gua asɩ ɛbɛlɛ. ");
INSERT INTO any_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Ɛsɛ ɔ 'tʋ yɩ́ nyɩn an, ɔ kɔ nwun ɛtanlan'n mɔ bɛ falɩ gualɩ yɩ́ ti'n, b'a bubu ɔ gua yɩ́ lɩka dɩɛ angʋnmɩn. ");
INSERT INTO any_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Kaan cɛ, sʋanlan'n m'ɔ lili mʋa juli sɛka nɩn asʋ'n kʋsʋ kɔ ju nun. Kɛ sʋanlan sɔ'n 'nwun yɩ́ sɔ ala, ɔ'a nwun kɛ Zozi fi ewue nun ɔ'a tinnge. Ɛbɛlɛ ala, ɔ kɔ le Zozi kɔ li. ");
INSERT INTO any_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","(Mɛlɛ sɔ'n kʋsʋ, Ɛhɛlɛ Ɛjɔlɛ'n lɩka'n m'ɔ kele kɛ sɛ Zozi wu a, ɔ 'tinnge'n, anɩn yɩ́ menian'n-mɔ tɩlɩ man yɩ́ bʋ.) ");
INSERT INTO any_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Yɛ̂ bɛ́ munnyuan bɛ salɩ hɔlɩ awulo ɔ. ");
INSERT INTO any_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Mɔ Zozi menian nnyuan'n 'sa kɔ awulo'n, anɩn Mali jin sɛka nɩn anwʋn ɛbɛlɛ, ɔ lɛ sun. Tɛmʋn mɔ ɔ 'su'n, ɔ kɔ han asɩ ɔ kɔ nɩan kunman nɩn anun. ");
INSERT INTO any_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Ɔ 'nɩan an, anɩn nyanmɩansʋ mmɔfʋɛ nnyuan, bɛ wowula taladɩɛ nvufue hyɩhyɩɛɩn, bɛ tɩtɩ lɩka mɔ bɛ tʋlɩ Zozi'n. Kʋn tɩ yɩ́ ja ngʋa yɛ̂ kʋn tɩ yɩ́ ti sɔlɔ. ");
INSERT INTO any_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Mɔ mmɔfʋɛ'n-mɔ nwunlin Mali'n, bɛ́ nwan: “Balasua, nzukɛ ati yɛ̂ ɛ lɛ sun ɔ?” Mɔ Mali tɩlɩ kosuan sɔ'n, yɩ́ nwan: “B'a yɩ mɩ́n Mɩn ɛwa, mɩn nnwun man lɩka mɔ bɛ nʋn yɩ́ a hɔ ɔ.” ");
INSERT INTO any_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","M'ɔ hanlɩn sɔ helelɩ mmɔfʋɛ'n-mɔ yuelɩ'n, Ɔ 'tʋ yɩ́ nyɩn yɩ́ nzin an, Zozi jin yɩ́ nwʋn ɛbɛlɛ, nan kʋsʋ Mali a nnwun man kɛ yɩ́ ɔ. ");
INSERT INTO any_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Zozi kɔ bisa yɩ́ kɛ: “Balasua, nzukɛ ati yɛ̂ ɛ lɛ sun ɔ? Ɛ lɛ kpʋnndɛ nwan?” Mali jʋnlɩn kɛ sʋanlan'n m'ɔ di tola nɩn anun junman nɩn ɔ. Yɩ́ nwan: “Yɛmɩnlɩn, sɛ wɔ́ yɛ̂ a yɩ yɩ́ ɛwa a, anɩn kele mɩ́n lɩka mɔ ɛ sielɩ yɩ́'n maan n gɔ́ n vá.” ");
INSERT INTO any_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Mɔ Mali hanlɩn sɔ yuelɩ'n, Zozi kɔ fɛlɛ yɩ́: “Mali!” Mali kɔ kpɛ yɩ́ nyɩn ɔ 'nɩan an, Zozi jin yɩ́ nwʋn ɛbɛlɛ. Ɛbɛlɛ ala, Mali kɔ tɩan kɔ kpayɩ yɩ́: “*Labunin, wɔ́ ahɩ?” (Labunin'n tɩ *ebele anɩɛ, yɩ́ bʋ y'ɔ le kɛ sʋanlan m'ɔ kan Nyanmɩan anʋan ɛjɔlɛ kele menian.) ");
INSERT INTO any_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Sian'n mɔ Mali hanlɩn sɔ yuelɩ'n, ɔ kɔ tutu ɔ 'kɔ a tɔ yɩ́ nun. Zozi nwan: “N'ɛ kan mɩ́n, ɔ sanlɩn kɛ n vʋlɩ n gɔlɩ man mɩ́n Sɩ anwʋn ɛlɔ. Nan kɔ, kɔ han kele mɩ́n menian'n-mɔ kɛ mɩɩn fʋ mɩn kɔ mɩ́n Sɩ m'ɔ tɩ ɛmɔ kʋsʋ Asɩ nɩn anwʋn ɛlɔ, mɩɩn fʋ mɩn kɔ mɩ́n Nyanmɩan m'ɔ tɩ ɛmɔ kʋsʋ Nyanmɩan nɩn anwʋn ɛlɔ.” ");
INSERT INTO any_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","M'ɔ hanlɩn sɔ yuelɩ'n, Mali kɔ hɔ kɔ tʋ Zozi menian'n-mɔ, ɔ kɔ bɔ bɛ́ amannɩɛ, yɩ́ nwan: “Anianman-mɔ, m'an nwun yɛ́ Mɩn!” Ɛbɛlɛ ala, ɔ kɔ sʋsɔ sʋ kɔ han mɔ Zozi hanlɩn helelɩ yɩ́'n kɔ hele bɛ́. ");
INSERT INTO any_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Mɔlɛ cɩan kʋnmgba sɔ'n nɔsʋba, kɛmɔ Zozi menian'n-mɔ sulo Zufʋ mgbain'n-mɔ nɩn ati, bɛ́ kʋalaa bɛ kɔ tʋ bɛ́ nwʋn anʋan nun sua kʋn anun. Bɛ wɔ ɛbɛlɛ kaan ala, Zozi kɔ fite bɛ́ nun ɛbɛlɛ, ɔ jin bɛ́ kʋalaa bɛ́ afian, yɩ́ nwan: “Ɛmɔ mán bɛ́ lʋa cɩ́cɩ bɛ́ nwʋn!” ");
INSERT INTO any_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","M'ɔ hanlɩn sɔ yuelɩ'n, ɔ kɔ fa yɩ́ sa'n-mɔ anun nʋn yɩ́ nvɩn nɩn anun kafʋan'n kɔ hele bɛ́. Mɔ menian'n-mɔ nwunlin yɛ́ Mɩn'n, bɛ lili fɛ kpili kpa. ");
INSERT INTO any_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Ɛsɛ bɛ wɔ ɛbɛlɛ kaan an, Zozi nwan: “Ɛmɔ mán bɛ́ lʋa cɩcɩ bɛ́ nwʋn! Kɛ mɩ́n Sɩ sʋanlɩn mɩ́n'n, mɩ́n kʋsʋ mɩɩn sʋan ɛmɔ.” ");
INSERT INTO any_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Mɔ Zozi hanlɩn sɔ mɔ yɩ́ nʋan tɔlɩ'n, ɔ kɔ fita bɛ́ nwʋn, yɩ́ nwan: “Ɛmɔ nyán Wawɛ Nwannzan-nwannzan'n. ");
INSERT INTO any_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Menian mɔ ɛmɔ kɔ fa bɛ́ ɛtɛ'n kɔ hye bɛ́'n, bɛ 'nyan ɛtɛ face, nan bɛ́ mɔ yɛ̂ ɛmɔ a nva man bɛ́ ɛtɛ nɩn a nje man bɛ́'n, bɛ nnyan man ɛtɛ face.” ");
INSERT INTO any_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Mɔ Zozi 'ba yɩ́ menian'n-mɔ anwʋn ɛbɛlɛ'n, anɩn Toma (mɔ bɛ fɛlɛ yɩ́ Nda'n) nnʋn man ɛbɛlɛ bie. Toma sɔ'n, ɔ wɔ Zozi menian bulu nʋn nnyuan nɩn anun. ");
INSERT INTO any_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Mɔ Toma hɔlɩ dede m'ɔ walɩ'n, yɩ́ manngʋn'n-mɔ nwan: “Y'a nwun yɛ́ Mɩn!” M'ɔ tɩlɩ ɛjɔlɛ sɔ'n, ɔ ngɔ le ngɔ li man, yɩ́ nwan: “Mɩ́n dɩɛ, sɛ m'an nnwun man yɩ́ sa nɩn anun kafʋan'n, sɛ m'an nva man mɩ́n sa'n m'an ngan man yɩ́ kafʋan'n, ɛsɛ sɛ m'an nva man mɩ́n sa'n m'an nwula man yɩ́ nvɩn nɩn anun an, mɩn nne mɩn nni man lé.” ");
INSERT INTO any_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Ɛhɩ anzin mɔlɛ kʋn, ɛsɛ Zozi menian'n-mɔ kɔ hɔ kɔ yia sua sɔ nɩn anun biekun, bɛ kɔ tʋ bɛ́ nwʋn anʋan nun. Sian dɩɛ, anɩn Toma wɔ bɛ́ nun ɛbɛlɛ bie. Bɛ wɔ ɛbɛlɛ kaan an, Zozi kɔ fite bɛ́, ɔ jin bɛ́ afian ɛbɛlɛ. Yɩ́ nwan: “Ɛmɔ mán bɛ́ lʋa cɩ́cɩ bɛ́ nwʋn!” ");
INSERT INTO any_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","M'ɔ hanlɩn sɔ yuelɩ'n, ɔ kɔ kpɛ yɩ́ nyɩn Toma anwʋn ɛlɔ, yɩ́ nwan: “Toma, fa wɔ́ sa'n bala nán kan mɩ́n sa nɩn anun nɩan, ɛsɛ tɩnngɛ wɔ́ sa'n fa wula mɩ́n nvɩn nɩn anun. N'ɛ su akpʋlʋwa, nan de di.” ");
INSERT INTO any_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Mɔ Toma nwunlin yɩ́ sɔ'n, yɩ́ nwan: “Mɩ́n Mɩn, mɩ́n Nyanmɩan!” ");
INSERT INTO any_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Zozi nwan: “Kɛmɔ a nwun mɩ́n'n, sian dɩɛ, ɛ de di? Nyila hán bɛ́ mɔ b'a nnwun man mɩ́n kʋsʋ b'a le mɩ́n b'a li'n.” ");
INSERT INTO any_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Yɩ́ menian'n-mɔ anyunnun, Zozi yɔlɩ asinbɛnwʋn ninnge mmiekun-mɔ dɔʋn mɔ b'a ngɛlɛ man yɩ́ kalata ɛhɩ anun. ");
INSERT INTO any_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Nan mɔ b'a hɛlɛ yɩ́ kalata ɛhɩ anun'n, b'a hɛlɛ maan ɛmɔ de di kɛ Zozi yɛ̂ ɔ tɩ *Kilisi'n, yɩ́ yɛ̂ ɔ tɩ Nyanmɩan Awa nɩn ɔ. Ɔ man sɛ ɛmɔ de yɩ́ di a, ɛmɔ 'nyan ngʋan wɔ yɩ́ dunman nun. ");
INSERT INTO any_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Ɛhɩ anzin, cɩan kʋn Zozi kɔ yɩ yɩ́ nwʋn biekun kɔ hele yɩ́ menian'n-mɔ. Ɔ 'ba yɔ sɔ'n, anɩn yɩ́ menian'n-mɔ wɔ Galile asue'n mɔ bɛ fɛlɛ yɩ́ Tibeliadɩ nɩn anʋan. Ɛ 'nwun kɛ ɔ kpɩnlɩn yɩlɩ yɩ́ nwʋn helelɩ bɛ́'n. ");
INSERT INTO any_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Anɩn Simʋn Pɩɛlɩ nʋn Toma mɔ bɛ fɛlɛ yɩ́ Nda'n, ɔ nʋn Natanayɛ m'ɔ fi Kana, Galile mân nɩn anun'n yɛ̂ bian Zebede amma'n-mɔ, ɔ nʋn Zozi menian nnyuan biekun, bɛ́ kʋalaa bɛ gua asue nɩn anʋan ɛbɛlɛ. ");
INSERT INTO any_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Bɛ wɔ ɛbɛlɛ kaan an, Simʋn Pɩɛlɩ nwan: “Mɩ́n nianman-mɔ, mɩn 'kɔ a gua dada.” Pɩɛlɩ anʋan a ndɔ man, bɛ́ kʋalaa bɛ́ nwan: “Yɛ nʋn wɔ́ kɔ.” Ɛbɛlɛ ala, bɛ kɔ hɔ bɛ kɔ fʋ ɛlɛɛ kʋn anun. Cɩan sɔ'n kɔngɔɛ, bɛ ngɔ hyɩ man ejue fɩ́ɩ́. ");
INSERT INTO any_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Bɛ gualɩ dada'n dede mɔ alɩ́ɛ hɩnlɩn'n, Zozi kɔ a asue nɩn anʋan ɛbɛlɛ, nan kʋsʋ yɩ́ menian'n-mɔ a nnwun man kɛ yɩ́ ɔ. ");
INSERT INTO any_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Ɛhɩ a, Zozi kɔ bisa bɛ́ kɛ: “Mɩ́n mma-mɔ, ɛmɔ a hyɩ ejue ɔ?” Bɛ́ nwan: “Cɛcɛ.” ");
INSERT INTO any_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Zozi nwan: “Ɛmɔ gúa dada nɩn ɛlɛɛ'n fama sʋ, nán ɛmɔ 'ba hyɩ ejue.” Mɔ yɩ́ menian'n-mɔ tɩlɩ ɛjɔlɛ sɔ'n, bɛ kɔ li sʋ. Bɛ kɔ gua dada'n. Sakpa kʋsʋ, bɛ 'gua yɩ́ ɛbɛlɛ a, bɛ kɔ hyɩ ejue ngʋnmɩn, bɛ nnwun man kɛ bɛ kpɩn bɛ yɔ yɩ́ ɔ. Bɛ cʋɩn yɩ́ a, ɔ njʋɩn man. ");
INSERT INTO any_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Mɔ sʋanlan'n mɔ Zozi kulo yɩ́'n nwunlin yɩ́ sɔ'n, yɩ́ nwan: “Yɛ́ Mɩn ɔ!” Mɔ Simʋn Pɩɛlɩ tɩlɩ kɛ yɩ́ nwan: “Yɛ́ Mɩn ɔ!”, ɔ kɔ wula yɩ́ taladɩɛ'n, afɩ anɩn yɩ́ nwʋn gua sʋ. Ɛbɛlɛ ala, ɔ kɔ hulu kɔ tɔ asue nɩn anun. ");
INSERT INTO any_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Lɩka mɔ bɛ wɔ'n kʋsʋ nʋn fie a nwa man. Ɔ 'ba yɔ kɔ yɔ mɛtɩlɩ ɛya kʋn. Zozi menian nga'n-mɔ halɩ ɛlɛɛ nɩn anun, bɛ hyʋhyʋɩnlɩn dada'n dede bɛ walɩ sili asɩ, ejue yi yɩ́ tɛkɛɛ. ");
INSERT INTO any_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Mɔ bɛ sili asɩ'n, bɛ 'nɩan an, anɩn b'a huan sɩ̂n ɛbɛlɛ, ejue la sʋ yɛ̂ kpaʋn kʋsʋ la yɩ́ nwʋn ɛbɛlɛ. ");
INSERT INTO any_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Zozi nwan: “Ejue'n mɔ ɛmɔ a hyɩ yɩ́ kɩkaala'n, bɛ fá bie bɛ bála.” ");
INSERT INTO any_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Simʋn Pɩɛlɩ kɔ fʋ ɛlɛɛ nɩn anun, ɔ kɔ hyʋɩn dada'n mɔ ejue mgbili mgbili yi yɩ́'n kɔ gua asɩ, Yɩ́ kʋalaa tɩ ejue ɛya kʋn abulanun nʋn nsan. Bɛ hyɩlɩ ejue nwala kpa, kʋsʋ dada nɩn a ndɩtɩ man. ");
INSERT INTO any_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Zozi nwan: “Ɛmɔ bála a li like.” Yɩ́ menian sɔ'n-mɔ fɩ́ɩ́ a ngʋala a mmisa yɩ́ bɔbɔ kɛ: “Nwan sʋanlan dɩɛ y'ɔ le wɔ́?”, ɔ sanlɩn kɛ bɛ́ kʋalaa bɛ sɩ kɛ yɛ́ Mɩn ɔ. ");
INSERT INTO any_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Zozi kɔ hɔ sɩ̂n nɩn anwʋn ɛlɔ, ɔ kɔ hɔ kɔ fa kpaʋn'n nʋn ejue'n kɔ hye kɔ man bɛ́. ");
INSERT INTO any_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Kɛ Zozi fi ewue nun tinngelɩ'n, yɩ́ kpɛ̂ nsan asʋ mɔ ɔ 'yɩ yɩ́ nwʋn kele yɩ́ menian'n-mɔ nɩn ahɩ. ");
INSERT INTO any_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Mɔ bɛ lili like'n yuelɩ'n, Zozi kɔ bisa Simʋn Pɩɛlɩ kɛ: “Zʋan awa Simʋn, asʋ ɛ kulo mɩ́n kpa tala ehulo'n mɔ menian ɛhɩ-mɔ fa kulo mɩ́n nɩn ɔ?” Simʋn nwan: “Yuo o! Yɛ́ Mɩn, ɛ sɩ kɛ mɩn kulo wɔ́.” Zozi nwan: “Sɛ ɛ kulo mɩ́n an, anɩn nɩan mɩ́n mmʋa mma'n-mɔ asʋ.” ");
INSERT INTO any_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Bɛ wɔ ɛbɛlɛ kaan an, ɛsɛ Zozi kɔ fɛlɛ Simʋn Pɩɛlɩ biekun, yɩ́ nwan: “Zʋan awa Simʋn, asʋ ɛ kulo mɩ́n ɔ?” Yɩ́ nwan: “Yuo o! Yɛ́ Mɩn, ɛ sɩ kɛ mɩn kulo wɔ́.” Zozi nwan: “Anɩn nɩan mɩ́n mmʋa'n-mɔ asʋ.” ");
INSERT INTO any_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Ɔ wɔ ɛbɛlɛ kan an, ɛsɛ ɔ kɔ fɛlɛ Simʋn Pɩɛlɩ biekun, yɩ́ nwan: “Zʋan awa Simʋn, asʋ ɛ kulo mɩ́n ɔ?” Yɩ́ kpɛ̂ nsan nɩn asʋ mɔ Yɛ́ Mɩn hanlɩn kɛ: “Zʋan awa Simʋn, asʋ ɛ kulo mɩ́n ɔ?” Pɩɛlɩ anwʋn kɔ bubu yɩ́, yɩ́ nwan: “Yɛ́ Mɩn, ɛ sɩ ɛjɔlɛ biala, ɛ sɩ kɛ mɩn kulo wɔ́.” Zozi nwan: “Anɩn nɩan mɩ́n mmʋa'n-mɔ asʋ.” ");
INSERT INTO any_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Mɩɩn kan yɩ́ ananhɔlɛ mɩn kele wɔ́ kɛ, daba, mɔ anɩn ɛ tɩ kpafɛlɛ'n, wɔ́ ngʋnmɩn yɛ̂ ɛ fa wɔ́ bɛlɛtɩ'n ɛ cɩ wɔ́ nwʋn sʋ, ɛ kɔ lɩka mɔ ɛ kulo ɔ. Nan mɔ ɛ 'ba yɔ awʋlʋwa'n, ɛ 'ba kuku wɔ́ sa'n-mɔ asʋ maan sʋanlan fʋfɔlɛ fa bɛlɛtɩ'n cɩ wɔ́ nwʋn sʋ, ɔ fa wɔ́ kɔ lɩka mɔ ɛ ngulo man kɛ ɛ kɔ'n. ");
INSERT INTO any_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Zozi lɛ kan sɔ kele kɛ bɛ 'ba cɩcɩ Pɩɛlɩ, bɛ kele yɩ́ ahʋlʋwa dede bɛ kun yɩ́, nán ɔ fa ewue sɔ'n ɔ wula Nyanmɩan anunminnyanmʋn. Mɔ Zozi hanlɩn sɔ yuelɩ'n, yɩ́ nwan: “Simʋn, si mɩ́n sʋ!” ");
INSERT INTO any_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Pɩɛlɩ kɔ tʋ yɩ́ nyɩn yɩ́ nzin, ɔ 'nɩan an, anɩn sʋanlan'n mɔ Zozi kulo yɩ́'n si bɛ́ sʋ. Sʋanlan sɔ'n y'ɔ le mɔ bɛ 'di *Pakɩ alɩɛ'n m'ɔ hyɩalɩ yɩ́ nwʋn Zozi anwʋn ɛbɛlɛ ɔ bisalɩ yɩ́ kɛ: “Yɛ́ Mɩn, nwan sʋanlan dɩɛ yɛ̂ ɔ 'ba yɩ wɔ́ man ɔ?”. ");
INSERT INTO any_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Mɔ Pɩɛlɩ nwunlin kɛ sʋanlan sɔ'n si bɛ́ sʋ'n, ɔ kɔ bisa Zozi kɛ: “Yɛ́ Mɩn, yɩ́ dɩɛ, nzu ɛjɔlɛ yɛ̂ ɔ 'tʋ yɩ́ ɔ?” ");
INSERT INTO any_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Zozi nwan: “Sɛ mɩn kulo kɛ ɔ nyan ngʋan dede ɔ ju mɩ́n ɛwalɛ cɩan an, asʋ wɔ́ ɛjɔlɛ wɔ nun ɔ? Wɔ́ lɩlɩ si mɩ́n sʋ!” ");
INSERT INTO any_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Ɛjɔlɛ'n kɔ te anianman'n-mɔ afian ɛlɔ kɛ bɛ́ nwan Zozi sʋanlan sɔ'n dɩɛ ɔ ngɔ wu man lé. Kʋsʋ Zozi a ngan a ngele man Pɩɛlɩ kɛ ɔ ngɔ wu man le, nan Zozi nwan: “Sɛ mɩn kulo kɛ ɔ nyan ngʋan dede ɔ ju mɩ́n ɛwalɛ cɩan an, asʋ wɔ́ ɛjɔlɛ wɔ nun ɔ?” ");
INSERT INTO any_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Zozi sʋanlan sɔ'n lɩlɩ yɛ̂ ɔ'a nwun ɛjɔlɛ sɔ'n-mɔ ɔ'a hɛlɛ ɔ'a sie ɔ. Yɛ̂ yɛ sɩ kɛ ɛjɔlɛ'n mɔ ɔ'a han'n tɩ ananhɔlɛ. ");
INSERT INTO any_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Zozi yɔlɩ asinbɛnwʋn ninnge dɔʋn kpa mmiekun-mɔ. Nan sɛ bɛ lɛ tʋa kʋn biala bɛ kɛlɛ a, yɩ́ nwʋn kalata mɔ bɛ 'kɛlɛ'n, mɩn de mɩn di kɛ ɔ nzʋn man mân nɩn anun.");
INSERT INTO any_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Teofili, Ninnge kʋalaa mɔ Zozi yɔlɩ, ɔ nʋn m'ɔ hehelelɩ yɩ́ ngɛlɛmɔ nun ");
INSERT INTO any_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","dede m'ɔ juli cɩan m'ɔ fʋlɩ hɔlɩ nyanmɩansʋ'n, m'an han yɩ́ nwʋn ɛjɔlɛ mɩ́n alimʋa kalata nɩn anun. Asannan nán Zozi a fʋ a hɔ nyanmɩansʋ'n, Wawɛ Nwannzan-nwannzan'n tunmin nun, ɔ hehelelɩ yɩ́ mmɔfʋɛ'n-mɔ m'ɔ fɛlɛlɩ bɛ́ yɩ́ nwʋn nɩn atɩn'n. ");
INSERT INTO any_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Mɔ menian'n-mɔ hunlin yɩ́ yuelɩ'n, ɔ buli atɩn ngacile dɔʋn asʋ ɔ yɩlɩ yɩ́ nwʋn ɔ helelɩ yɩ́ mmɔfʋɛ'n-mɔ maan bɛ nwunlin yɩ́ kɛ ɔ fi ewue nun ɔ'a tinnge sakpa. Ɔ yɩlɩ yɩ́ nwʋn ɔ helelɩ bɛ́ dede cɩan abulanan, ɛsɛ ɔ hanlɩn Nyanmɩan Belemgbin Mân nɩn anwʋn ɛjɔlɛ ɔ helelɩ bɛ́. ");
INSERT INTO any_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Ɛlɛhʋn kʋn, anɩn Zozi nʋn yɩ́ mmɔfʋɛ'n-mɔ lɛ didi, ɔ kɔ han kɔ hele bɛ́ kɛ: “Nán man ɛmɔ fi Zoluzalɛmʋn ɛwa bɛ kɔ mʋa. Nan ɛmɔ tánlan bɛ nwʋ́nndɛ like'n mɔ Sɩɛ nɩn a fa a bɔ ɛmɔ anɔhʋba mɔ n ganlɩn yɩ́ nwʋn ɛjɔlɛ n gelelɩ ɛmɔ'n. ");
INSERT INTO any_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Ɔ sanlɩn kɛ, Zʋan a sɔnɩn menian'n-mɔ asue nun, nan ɛmɔ dɩɛ, ɔ ka kaan, bɛ 'ba fa Wawɛ Nwannzan-nwannzan bɛ sɔnɩn ɛmɔ.” ");
INSERT INTO any_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Mɔ Zozi hanlɩn sɔ yuelɩ'n, yɩ́ mmɔfʋɛ'n-mɔ mɔ anɩn b'a yia yɩ́ nwʋn ɛbɛlɛ'n kɔ bisa yɩ́ kɛ: “Yɛ́ Mɩn, asʋ mɛlɛ sɔ nɩn anun yɛ̂ ɛ 'sesie Izalayɛ belemgbin mân'n biekun ɔ?” ");
INSERT INTO any_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Zozi kɔ bua bɛ́ kɛ: “Mɛlɛ'n nʋn cɩan'n mɔ Sɩɛ'n muonun tunmin nun ɔ'a hele'n, nán ɛmɔ ɛjɔlɛ ɔ. ");
INSERT INTO any_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Nan Wawɛ Nwannzan-nwannzan'n 'ba a ɛmɔ sʋ ɔ wowula ɛmɔ tunmin. Ɛbɛlɛ nɩn anun, ɛmɔ 'ba li mɩ́n nwʋn adanzɩɛ wɔ Zoluzalɛmʋn kulo nɩn asʋ ɛwa, Zude nʋn Samali mân nɩn anun lɩka kʋalaatin, ɛsɛ dede ɔ kɔ ju mân nɩn ati ɛlɔ ebue kʋn kʋalaatin.” ");
INSERT INTO any_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Mɔ Zozi hanlɩn ɛjɔlɛ sɔ'n yuelɩ'n, bɛ 'nɩan an, anɩn ɔ lɛ fʋ kɔ nyanmɩansʋ. Ɛbɛlɛ ala, bɔlɛ́ kʋn kɔ fʋfɔ yɩ́ nwʋn ɔ kɔ fɩa bɛ́ nyɩn. ");
INSERT INTO any_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Mɛlɛ mɔ Zozi 'fʋ kɔ mɔ anɩn yɩ́ mmɔfʋɛ'n-mɔ tɛ nɩan anwunno'n, kʋnmgba ala menian nnyuan kɔ fite fite bɛ́ nwʋn ɛbɛlɛ. Menian nnyuan sɔ'n-mɔ wowula taladɩɛ nvufue. ");
INSERT INTO any_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Bɛ kɔ bisa Zozi mmɔfʋɛ'n-mɔ kɛ: “Galile amma, ɔ yɔ sɛ mɔ ɛmɔ jijin ɛwa bɛ lɛ nɩan anwunno ɔ? Zozi m'ɔ fi ɛmɔ afian ɛwa ɔ'a fʋ ɔ'a hɔ nyanmɩansʋ'n, ɔ 'ba sa ba kɛ ɛmɔ a nwun yɩ́ kɛ ɔ lɛ fʋ kɔ'n.” ");
INSERT INTO any_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Mɔ menian nnyuan sɔ'n-mɔ hanlɩn sɔ'n, Zozi mmɔfʋɛ'n-mɔ fi bʋka'n mɔ bɛ fɛlɛ yɩ́ “*Olivʋ bʋka” nɩn asʋ bɛ kɔ ju. Bɛ kɔ sa bɛ kɔ hɔ Zoluzalɛmʋn. Bʋka sɔ'n nʋn Zoluzalɛmʋn afian tɩ kɔ yɔ cilo kʋn. ");
INSERT INTO any_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Mɔ bɛ juli Zoluzalɛmʋn ɛbɛlɛ'n, bɛ kɔ hɔ kɔ fʋ awaa nɩn asʋ, bɛ kɔ wʋlʋ sua'n mɔ bɛ yia nun titi nɩn anun. Bɛ́ mɔ bɛ hɔlɩ yialɩ sua nɩn anun'n y'ɔ le Pɩɛlɩ, Zʋan, Zʋakɩ, Andele, Filipʋ, Toma, Baatelemin, Matie, Alɩfe awa Zʋakɩ, Simʋn m'ɔ kpʋnndɛ yɩ́ mân'n fanwʋndi'n ɔ nʋn Zʋakɩ awa Zudɩ. ");
INSERT INTO any_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Bɛ yia daa bɛ yɔ asɔnɩn, bɛ nʋn mmalasua'n-mɔ nʋn Zozi anin Mali ɔ nʋn Zozi anianman mmelenzua'n-mɔ. ");
INSERT INTO any_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Ɛlɛhʋn kʋn bɛ yialɩ, bɛ́ menian kɔ yɔ ɛya kʋn abulaa, Pɩɛlɩ jasʋlɩ a, yɩ́ nwan: ");
INSERT INTO any_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Anianman-mɔ, ɛjɔlɛ mɔ Wawɛ Nwannzan-nwannzan'n hanlɩn m'ɔ wɔ Ɛhɛlɛ Ɛjɔlɛ nɩn anun'n, ɔ di kɛ ɔ kpɩ́n sʋ. Wawɛ Nwannzan-nwannzan'n nanndɩlɩ belemgbin Davidi sʋ ɔ hanlɩn Zudasɩ anwʋn ɛjɔlɛ. Zudasɩ sɔ'n y'ɔ kpɛlɩ atɩn maan bɛ hyɩlɩ Zozi ɔ. ");
INSERT INTO any_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Anɩn Zudasɩ wɔ yɛ́ fâ nɩn anun bie. Junman'n mɔ yɛ lɛ di yɩ́ ɛwa'n, anɩn ɔ di bie. ");
INSERT INTO any_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Yɩ́ busuɔfʋɛ nyɔlɩɛ nɩn anwʋn esika mɔ bɛ tualɩ bɛ manlɩn yɩ́'n, ɔ falɩ tolɩ ebo kʋn. Ebo sɔ nɩn asʋ, ɔ kɔ fʋ anwunno ɔ kɔ lua yɩ́ ti asɩ ɔ kɔ tɔ asɩ, yɩ́ nyaa kʋalaa kɔ tulu. ");
INSERT INTO any_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Ɛjɔlɛ sɔ'n, Zoluzalɛmʋn menian'n-mɔ kʋalaa tɩlɩ. Ɔ man bɛ́ anɩɛ nɩn anun, b'a fɛlɛ ebo sɔ'n ‘Hakɛlɩdama’. Hakɛlɩdama'n, yɩ́ bʋ y'ɔ le kɛ: ‘moja ebo’. ");
INSERT INTO any_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","“Ɛ 'nwun Zudasɩ anwʋn ɛjɔlɛ'n mɔ belemgbin *Davidi hɛlɛlɩ wɔ Izalayɛ ejue ɛtʋɛ kalata nɩn anun'n: Man yɩ́ awulo'n há to, nán man sʋanlan fɩ́ɩ́ tanlan nun. Ɛsɛ b'a hɛlɛ wɔ kalata sɔ nɩn anun biekun kɛ: Man sʋanlan fʋfɔlɛ káci yɩ́. ");
INSERT INTO any_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","“Ɛhɩka ati, ɔ di kɛ sʋanlan kʋn fa yɩ́ nwʋn bɔ yɛ́ ɔ di yɛ́ Mɩn Zozi ewuetinnge nɩn anwʋn adanzɩɛ. ");
INSERT INTO any_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Sʋanlan sɔ'n, ɔ yɔ́ bɛ́ mɔ bɛ si yɛ́ sʋ nɩn anun kʋn, sunmin tɛmʋn mɔ Zʋan sɔnɩnlɩn yɛ́ Mɩn Zozi, m'ɔ sɩsɩnlɩn kulo kulo'n-mɔ asʋ, dede ɔ juli cɩan m'ɔ fʋlɩ hɔlɩ nyanmɩansʋ'n.” ");
INSERT INTO any_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Mɔ Pɩɛlɩ anʋan tɔlɩ'n, bɛ kɔ sie menian nnyuan ɛbɛlɛ. Bɛ fɛlɛ kʋn Zozɛfʋ. Kʋn'n kʋsʋ li Matiasɩ. Zozɛfʋ a, yɩ́ dunman biekun y'ɔ le Baasabasɩ mɔ yɛ̂ bɛ tʋnlɩn yɩ́ Zusutusu'n. ");
INSERT INTO any_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Mɔ bɛ sielɩ menian nnyuan sɔ nɩn ɛbɛlɛ'n, bɛ́ kʋalaa bɛ kɔ yɔ asɔnɩn. Bɛ́ nwan: “Yɛ́ Mɩn, wɔ́ mɔ ɛ sɩ menian'n-mɔ kʋalaa ahʋnlɩn nɩn anun ɛjɔlɛ'n, menian nnyuan ɛhɩ, kele yɛ́ nunhan'n mɔ a yɩ yɩ́ kɛ ");
INSERT INTO any_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","ɔ káci Zudasɩ mɔ ɔ'a yaci Zozi mmɔfʋɛ junman'n ɔ'a bɔ yɩ́ ti yɩ́ lɩka m'ɔ kulo'n.” ");
INSERT INTO any_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Ɛhɩ a, bɛ kɔ hyʋɩn tondo, ɔ kɔ tɔ Matiasɩ sʋ. Ɔ fi ɛbɛlɛ yɛ̂ bɛ falɩ Matiasɩ bɛ sɔlɩ mmɔfʋɛ bulu nʋn kʋn nɩn asʋ ɔ. ");
INSERT INTO any_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Ɛhɩ, mɔ *Pantekɔtʋ fɛtɩ cɩan'n juli'n, Zozi menian'n-mɔ kʋalaatin yialɩ lɩka kʋn. ");
INSERT INTO any_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Kʋnmgba ala, bɛ kɔ tɩ like nɩn angan kɛ anwʋnman m'ɔ lɛ tu sɛlɛ kpa ɔ. Ɔ fi anwunno huuu, ɔ kɔ wʋlʋ sua'n mɔ menian'n-mɔ gua nun nɩn anun. ");
INSERT INTO any_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Bɛ 'nɩan an, sɩ̂n tofeleman-mɔ. Bɛ kɔ tɩtɩ bɛ́ nwʋn nun, bɛ kɔ tɛtanlan bɛ́ nun kʋn biala ati nɩn asʋ. ");
INSERT INTO any_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Wawɛ Nwannzan-nwannzan'n kɔ wʋlʋ bɛ́ kʋalaa bɛ́ nun kpa bɔkɔɔ. Ɛbɛlɛ ala, bɛ lɛ kan anɩɛ ngacile ngacile mɔ Wawɛ nɩn a fa a wula bɛ́ nun kʋn biala anʋan kɛ ɔ hán'n. ");
INSERT INTO any_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Ɔ 'ba yɔ sɔ'n, anɩn Zufʋ'n-mɔ mɔ bɛ fɛlɩ Nyanmɩan kpa'n fi mân mân'n kʋalaa anun ba a, bɛ wɔ Zoluzalɛmʋn ɛbɛlɛ. ");
INSERT INTO any_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Mɔ bɛ tɩlɩ like sɔ nɩn angan'n, bɛ kɔ tutu bɛ kɔ hɔ kɔ yia yɩ́ bʋ ɛlɔ. Ɛjɔlɛ'n kɔ sin bɛ́ kʋalaa bɛ́ nwʋn dede ɔ kɔ bʋ sʋ. Ɔ sanlɩn kɛ, anɩɛ ngacile ngacile'n mɔ Zozi menian'n-mɔ lɛ kan'n, bɛ́ mɔ b'a yia ɛbɛlɛ nɩn anun kʋn biala tɩ kɛ yɩ́ kulo anɩɛ yɛ̂ bɛ lɛ kan ɔ. ");
INSERT INTO any_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Ɛjɔlɛ'n kɔ sin bɛ́ nwʋn ɛsɛ ɔ kɔ yɔ bɛ́ ɛnyɩnmɩn. Bɛ́ nwan: “Menian ɛhɩ-mɔ mɔ bɛ lɛ kan anɩɛ ngacile ngacile'n, asʋ bɛ́ kʋalaa bɛ tɩ man Galile mân nɩn anun menian ɔ? ");
INSERT INTO any_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Nan ɔ yɔ sɛ mɔ afɩ yɛ́ nun kʋn biala tɩ ɛjɔlɛ'n mɔ bɛ lɛ kan wɔ yɛ́ kulo anɩɛ nɩn anun'n? ");
INSERT INTO any_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Yɛ́ nun mmie-mɔ fi Paatɩ nʋn Medi nʋn Elamʋn mân nun. Mmie-mɔ fi Mezopotamin mân nun, Zude nʋn Kapadɔsʋ mân nun, Pʋn nʋn Azi mân nun, ");
INSERT INTO any_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Filizi nʋn Panfili mân nun, Ezipiti mân nun nʋn Libi mân nɩn anun kulo'n mɔ bɛ fɛlɛ yɩ́ Silɛnɩn nɩn afan nun. Nyɔfʋɛ'n mɔ bɛ fi Lɔmʋn kulo nɩn asʋ'n, ");
INSERT INTO any_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","b'a wʋ mmie-mɔ Zufʋ, mmie-mɔ kʋsʋ tɩ man Zufʋ, nan kʋsʋ bɛ kɔ Zufʋ'n-mɔ asɔnɩn'n bie. Mmie-mɔ fi Kɛlɛtɩ nʋn Alabi mân nun. Kʋsʋ afɩ, Nyanmɩan asinbɛnwʋn ninnge'n-mɔ anwʋn ɛjɔlɛ'n mɔ bɛ lɛ kan'n, yɛ́ kʋalaa yɛ tɩ wɔ yɛ́ kulo anɩɛ nɩn anun!” ");
INSERT INTO any_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Ɛjɔlɛ'n kɔ sin bɛ́ kʋalaa bɛ́ nwʋn dede ɔ kɔ bʋ bɛ́ nwʋn sʋ. Bɛ kɔ bisa bisa bɛ́ nwʋn kɛ: “Ɛjɔlɛ ɛhɩ abʋ kele sɛ?” ");
INSERT INTO any_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Mmie-mɔ 'bisa kosuan ɛhɩ a, anɩn mmie-mɔ kʋsʋ lɛ kan bɛ gʋlʋ Zozi menian'n-mɔ anwʋn kɛ: “Ɛhɩ-mɔ, b'a nʋn nzan b'a bʋ kpa bɔkɔɔ!” ");
INSERT INTO any_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Mɔ menian'n-mɔ 'kan sɔ'n, Pɩɛlɩ nʋn mmɔfʋɛ bulu nʋn kʋn'n kɔ jasʋ kɔ jinlan. Pɩɛlɩ kɔ kuku yɩ́ nʋan sʋ ɔ kɔ han kɔ hele bɛ́ kɛ: “Ɛmɔ Zufʋ'n-mɔ nʋn ɛmɔ kʋalaa mɔ bɛ wɔ Zoluzalɛmʋn ɛwa'n, ɛmɔ yɔ́ anzʋɛ bɛ tíe ɛjɔlɛ'n mɔ mɩn 'ba han mɩn kele ɛmɔ'n kpa. ");
INSERT INTO any_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Menian ɛhɩ-mɔ mɔ ɛmɔ jʋnlɩn kɛ b'a nʋn nzan b'a bʋ'n, bɛ nnʋnlɩn man nzan bɛ bʋlɩ man. Ɔ sanlɩn kɛ, bɛlɛ mɔ b'a bɔ ngɛlɛmɔ dɔɛ ngʋanlan ɔ. ");
INSERT INTO any_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Nan ɛjɔlɛ'n mɔ kpɔmanfʋɛ Zowɛ hanlɩn yɩ́ daba daba'n, ɛjɔlɛ sɔ'n yɛ̂ ɔ lɛ kpɩn sʋ sian nɩn ɔ. Kpɔmanfʋɛ Zowɛ hanlɩn kɛ Nyanmɩan nwan: ");
INSERT INTO any_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Mɛlɛ kasian nɩn anun, mɩn 'ce mɩn Wawɛ'n mɩn man kulo sʋanlan dasannin biala. Mɩn 'fa mɩ́n nʋan ɛjɔlɛ'n mɩn wula ɛmɔ amma mmelenzua nʋn mmalasua'n-mɔ anʋan maan bɛ kan. Mɩn 'ba man ɛmɔ mgbafɛlɛ'n-mɔ nwun ninnge'n-mɔ Wawɛ nun. Mɩn 'ba hɩn ɛmɔ mmɩlɩwa'n-mɔ ɛlalɩɛ. ");
INSERT INTO any_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Ɔ tɩ ananhɔlɛ, mɛlɛ sɔ nɩn anun, mɩn 'ce mɩ́n Wawɛ'n mɩn man mɩ́n ngʋa mmelenzua nʋn mmalasua'n-mɔ. Mɩn 'fa mɩ́n nʋan ɛjɔlɛ'n mɩn wula bɛ́ nʋan maan bɛ kan. ");
INSERT INTO any_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Mɩn 'ba man asinbɛnwʋn ninnge fite fite anwunno ɛlɔ. Ɛsɛ mɩn 'ba man asinbɛnwʋn ninnge fite fite asɩɛ nɩn asʋ ɛwa. Menian'n-mɔ 'ba nwun moja, sɩ̂n nʋn ewusanlan minndominndo. ");
INSERT INTO any_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Asannan nán yɛ́ Mɩn cɩan nɩn a ju'n, cɩan sɔ'n m'ɔ tɩ anunminnyanmʋn cɩan kpili'n, sɛnzɛ'n b'a lu tuun, sala'n kʋsʋ 'ba kaci kɔkɔlɛ kɛ moja. ");
INSERT INTO any_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Cɩan sɔ'n, wɔ́ biala mɔ ɛ kɔ sun kɔ fɛlɛ yɛ́ Mɩn'n, ɛ 'nyan wɔ́ ti.” ");
INSERT INTO any_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Ɛsɛ Pɩɛlɩ nwan: “Izalayɛ amma, ɛmɔ tíe ɛjɔlɛ'n mɔ mɩn 'ba han mɩn kele ɛmɔ'n kpa. Ɛmɔ muonun sɩ, Nyanmɩan a man ɛmɔ a nwun yɩ́ kɛ Zozi m'ɔ fi Nazalɛtɩ'n tɩ sʋanlan m'ɔ le tunmin. Nyanmɩan a man Zozi a yɔ asinbɛnwʋn ninnge mgbili mgbili kpa ɛmɔ afian ɛwa. ");
INSERT INTO any_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","B'a yɩ Zozi b'a man ɛmɔ. Nan kʋsʋ Nyanmɩan yɛ̂ ɔ lili mʋa ɔ sesielɩ yɩ́ sɔ ɔ. Ɛmɔ nʋn ɛtɛfʋɛ'n-mɔ, b'a bʋbɔ yɩ́ kʋlʋwa sʋ b'a hun yɩ́. ");
INSERT INTO any_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Nan kʋsʋ Nyanmɩan a le yɩ́ fi ewue asa nun maan ɔ fi ewue nun ɔ'a tinnge. Ɔ sanlɩn kɛ, ewue le man atɩn ɔ njɩ man yɩ́ nzie man. ");
INSERT INTO any_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Afɩ belemgbin *Davidi hanlɩn Zozi anwʋn ɛjɔlɛ kɛ: Mɩn susu mɩ́n ti mɩn gua yɛ́ Mɩn sʋ mɛlɛ biala. Ɔ di mɩ́n nzin, mɩ́n nwʋn nwʋsʋ man mɩ́n. ");
INSERT INTO any_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Ɛhɩka ati, mɩn di yɩ́ nwʋn fɛ kpa mɩ́n ahʋnlɩn nɩn anun, mɩn tʋ yɩ́ nwʋn ejue. Afɩ mɩn sɩ kɛ sɛ ewue kun mɩ́n bɔbɔ a, n ne anyɩndasʋɛ. ");
INSERT INTO any_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Ɔ sanlɩn kɛ, ɛ ngɔ yaci man mɩ́n ɛbɔlɔ ɛlɔ, ɛ ngɔ man wɔ́ anwʋntɩɛ sʋanlan nɩn anwʋnnaan'n ngɔ kpɔlɔ man. ");
INSERT INTO any_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Ɛ 'man mɩn nyan ngʋan mɩn di fɛ wɔ wɔ́ nyunnun. ");
INSERT INTO any_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“Anianman-mɔ, mɩn 'ba han belemgbin Davidi anwʋn ɛjɔlɛ kʋn mɩn kele ɛmɔ yuein. Ɛjɔlɛ sɔ'n y'ɔ le kɛ Davidi a wu, b'a sie yɩ́. Ɛnɛ nʋn ɛnɛ yɩ́ sɛka'n tɛ wɔ yɛ́ afian ɛwa. ");
INSERT INTO any_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Nan anɩn Davidi tɩ Nyanmɩan kpɔmanfʋɛ. Ɔ sɩ kɛ Nyanmɩan a bɔ yɩ́ anɔhʋba ɔ'a han ndâ ɔ'a tʋ sʋ kɛ ɔ 'man yɩ́ mma'n-mɔ anun kʋn tanlan belemgbin bia nɩn asʋ. ");
INSERT INTO any_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Davidi lili mʋa ɔ nwunlin Izalayɛ Belemgbin Ngʋandefʋɛ'n m'ɔ tɩ *Kilisi nɩn ewuetinnge'n, nán ɔ'a han yɩ́ nwʋn ɛjɔlɛ kɛ: B'a nyaci man yɩ́ maan ɔ'a nga man ɛbɔlɔ, ɛsɛ yɩ́ nwʋnnaan nɩn a mgbɔlɔ man sɛka nɩn anun. ");
INSERT INTO any_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","“Zozi anwʋn ɛjɔlɛ yɛ̂ anɩn Davidi lɛ kan ɔ. Yɛ́ mɔ yɛ gua ɛwa'n, yɛ́ kʋalaa yɛ di adanzɩɛ kɛ Nyanmɩan a man Zozi fi ewue nun a tinnge. ");
INSERT INTO any_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Nyanmɩan a sie Zozi yɩ́ fama sʋ. Wawɛ Nwannzan-nwannzan'n mɔ Sɩɛ'n falɩ bɔlɩ anɔhʋba'n, ɔ'a fa ɔ a wula Zozi asa nun. Zozi a hye a man yɛ́. Wawɛ sɔ'n yɛ̂ ɛmɔ a tɩ yɩ́ ngan mɔ ɛmɔ nwun yɩ́ kɩkaala nɩn ɔ. ");
INSERT INTO any_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","“Nán kɛ Davidi muonun fʋlɩ hɔlɩ nyanmɩansʋ ɔ, nan yɩ́ nwan: Yɛ́ Mɩn Nyanmɩan a han a hele mɩ́n Mɩn kɛ: Tanlan mɩ́n sa fama sʋ ");
INSERT INTO any_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","maan nvá wɔ́ mgbɔfʋɛ'n-mɔ n zíe wɔ ja abɔ kɛ bia mɔ belemgbin sesie yɩ́ ja sʋ ɔ. ");
INSERT INTO any_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“Izalayɛ amma'n-mɔ kʋalaa nwún yɩ́ yuein kɛ, Zozi sɔ'n mɔ ɛmɔ bʋbɔlɩ yɩ́ kʋlʋwa nɩn asʋ'n, yɩ́ yɛ̂ Nyanmɩan a sie yɩ́ Mɩnlɩan nʋn Kilisi, Izalayɛ Belemgbin Ngʋandefʋɛ nɩn ɔ!” ");
INSERT INTO any_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Mɔ Pɩɛlɩ anʋan tɔlɩ'n, ɛjɔlɛ'n m'ɔ hanlɩn'n wʋlʋlɩ bɛ́ kpa. Bɛ kɔ bisa Pɩɛlɩ nʋn mmɔfʋɛ ɛhɩnlɩn-mɔ kɛ: “Anianman-mɔ, atɩn benin yɛ̂ yɛ fá sʋ ɔ?” ");
INSERT INTO any_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Pɩɛlɩ kɔ bua bɛ́ kɛ: “Ɛmɔ nún bɛ́ nwʋn bɛ káci bɛ́ abalabɔ'n. Ɛmɔ nunhan kʋn biala maan bɛ sɔ́nɩn yɩ́ wɔ Zozi Kilisi dunman nun, nán ɛmɔ a nyan ɛtɛ face. Ɛbɛlɛ nɩn anun yɛ̂ ɛmɔ kʋsʋ 'ba nyan Wawɛ Nwannzan-nwannzan'n m'ɔ tɩ Nyanmɩan acɛdɩɛ nɩn ɔ. ");
INSERT INTO any_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Ɔ sanlɩn kɛ, anɔhʋba sɔ'n mɔ Nyanmɩan bɔlɩ'n, ɔ tɩ ɛmɔ dɩɛ, ɔ tɩ ɛmɔ amma'n-mɔ dɩɛ. Ɛsɛ bɛ́ kʋalaa mɔ bɛ wɔ mʋa mɔ yɛ́ Mɩn Nyanmɩan 'ba fɛlɛ bɛ́ yɩ́ nwʋn'n, ɔ tɩ bɛ́ kʋsʋ bɛ́ dɩɛ bie.” ");
INSERT INTO any_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","M'ɔ yɔlɩ sɔ'n, Pɩɛlɩ hanlɩn ɛjɔlɛ mmiekun-mɔ dɔʋn ɔ helelɩ bɛ́, ɔ man bɛ nwunlin yɩ́ kɛ Zozi anwʋn ɛjɔlɛ'n tɩ ananhɔlɛ, ɛsɛ ɔ wowulalɩ bɛ́ anwʋnsɛlɛ. Yɩ́ nwan: “Ajulisʋ menian ɛhɩ-mɔ mɔ b'a sɩn atɩn ɛtɛ nɩn asʋ'n, ɛmɔ nʋn bɛ́ kpácɩ nán ɛmɔ a nyan bɛ́ ti!” ");
INSERT INTO any_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Mɔ Pɩɛlɩ hanlɩn sɔ yuelɩ'n, bɛ́ dɔʋn bɛ lelɩ yɩ́ nʋan ɛjɔlɛ'n bɛ lili maan bɛ sɔnɩnlɩn bɛ́. Cɩan sɔ'n, menian kɔ yɔ akpɩɩ nsan kɔ a kɔ gua bɛ́ mɔ b'a le Zozi b'a li daba nɩn asʋ. ");
INSERT INTO any_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Ɔ fi ɛbɛlɛ, tɛmʋn biala, bɛ yia bɛ tie ɛjɔlɛ'n mɔ mmɔfʋɛ'n-mɔ kan kele bɛ́'n kpa. Bɛ tanlan wɔ anianman nun bɛ di yɛ́ Mɩn alɩɛ'n, ɛsɛ bɛ yɔ asɔnɩn. ");
INSERT INTO any_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Anɩn menian'n-mɔ anun kʋn biala man Nyanmɩan anyɩnnzɔ, ɔ sanlɩn kɛ anɩn mmɔfʋɛ'n-mɔ lɛ yɔ asinbɛnwʋn ninnge-mɔ dɔʋn kpa. ");
INSERT INTO any_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Bɛ́ kʋalaa mɔ bɛ lelɩ Zozi bɛ lili nɩn anʋan sɛ bɛ́ nwʋn, bɛ́ ninnge'n-mɔ kʋalaa wɔ lɩka kʋn. ");
INSERT INTO any_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Bɛ tɔnɩn bɛ́ anwʋndɩɛ'n-mɔ. Esika mɔ bɛ kɔ nyan yɩ́ nun'n, bɛ nɩan sʋanlan kʋn like mɔ ɔ'a hian yɩ́ nwʋn'n yɛ̂ bɛ ce esika sɔ nɩn ɔ. ");
INSERT INTO any_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Cɩan biala, bɛ yia Nyanmɩan awulo nɩn anun. Bɛ yia bɛ́ awulo'n-mɔ anun bɛ le fɛ elie yɛ̂ bɛ didi ɔ, bɛ ndu man bɛ́ nwʋn. ");
INSERT INTO any_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Bɛ yɩ Nyanmɩan ayɛ. Menian'n-mɔ kʋalaa kulo bɛ́ ɛjɔlɛ. Cɩan daa, yɛ́ Mɩn cʋɩn bɛ́ mɔ b'a nyan bɛ́ ti'n ɔ ba gua bɛ́ mɔ b'a li mʋa b'a le Zozi b'a li nɩn asʋ. ");
INSERT INTO any_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Ɛhɩ, ɛlɛhʋn kʋn, eyua dɔɛ nsan, mɔ dɔɛ'n mɔ Zufʋ'n-mɔ fa yɔ asɔnɩn'n juli'n, anɩn Pɩɛlɩ nʋn Zʋan, bɛ lɛ kɔ Nyanmɩan awulo ɛlɔ bɛ 'kɔ a yɔ asɔnɩn. ");
INSERT INTO any_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Awulo nɩn anʋan'n mɔ bɛ fɛlɛ yɩ́ “Anʋan Kanlanman” nɩn anwʋn ɛbɛlɛ, belenzua bubuluwafʋɛ kʋn tɩ ɛbɛlɛ. Belenzua sɔ'n, bɛ 'wʋ yɩ́ a, anɩn ɔ'a bubu. Cɩan biala, bɛ fa yɩ́ bɛ ba sie yɩ́ ɛbɛlɛ, maan ɔ sɛsɛlɛ bɛ́ mɔ bɛ lɛ kɔ a wʋlʋ Nyanmɩan awulo nɩn anun nɩn esika. ");
INSERT INTO any_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","M'ɔ nwunlin kɛ Pɩɛlɩ nʋn Zʋan lɛ ba wʋlʋ awulo nɩn anun'n, ɔ kɔ sɛlɛ bɛ́ esika. ");
INSERT INTO any_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Pɩɛlɩ nʋn Zʋan bɛ kɔ nɩan bian'n siin, nán Pɩɛlɩ a se yɩ́ kɛ: “Nɩan yɛ́!” ");
INSERT INTO any_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Bian'n kɔ nɩan bɛ́, afɩ ɔ jʋnlɩn kɛ Pɩɛlɩ nʋn Zʋan 'ba man yɩ́ esika. ");
INSERT INTO any_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Ɛhɩ a, Pɩɛlɩ kɔ han kɔ hele yɩ́ kɛ: “N ne esika fɩ́ɩ́. Nan nunhan mɔ n ne yɩ́'n, mɩn 'fa mɩn man wɔ́. Yɩ́ ti, Zozi Kilisi m'ɔ fi Nazalɛtɩ'n dunman nun, jasʋ nanndɩ!” ");
INSERT INTO any_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Mɔ Pɩɛlɩ hanlɩn sɔ yuelɩ'n, ɔ kɔ sɔ bian nɩn asa fama nɩn anun ɔ kɔ jasʋ yɩ́. Ɛbɛlɛ ala, bian nɩn aja'n-mɔ kɔ yɔ kpa. ");
INSERT INTO any_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Ɔ kɔ jasʋ ɔ kɔ nanndɩ. Ɔ nʋn Pɩɛlɩ nʋn Zʋan bɛ kɔ wʋlʋ awulo nɩn anun, anɩn ɔ lɛ nanndɩ ɔ lɛ kukulu ɔ yɩ Nyanmɩan ayɛ. ");
INSERT INTO any_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Menian'n-mɔ kʋalaa kɔ nwun yɩ́ kɛ ɔ lɛ nanndɩ ɔ yɩ Nyanmɩan ayɛ. ");
INSERT INTO any_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Mɛlɛ mɔ menian'n-mɔ nwunlin kɛ bian'n m'ɔ tanlan Anʋan Kanlanman nɩn anwʋn ɛbɛlɛ ɔ sɛsɛlɛ esika'n, ɛjɔlɛ'n kɔ sin bɛ́ nwʋn bɛ kɔ sulo Nyanmɩan wɔ like mɔ mmɔfʋɛ'n-mɔ a yɔ a man bian nɩn anwʋn. ");
INSERT INTO any_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Kɛmɔ bian sɔ'n mgbɔcɩ man Pɩɛlɩ nʋn Zʋan'n, ɛjɔlɛ'n kɔ sin menian'n-mɔ anwʋn. Bɛ́ kʋalaa bɛ kɔ tu woo bɛ kɔ hɔ bɛ́ nwʋn ɛlɔ lɩka'n mɔ bɛ fɛlɛ yɩ́ “Salomʋn Abalada” nɩn anun. ");
INSERT INTO any_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Mɔ Pɩɛlɩ nwunlin yɩ́ sɔ'n, yɩ́ nwan: “Izalayɛ amma, nzukɛ ati yɛ̂ bian ɛhɩ anwʋnnza'n sin ɛmɔ anwʋn ɔ? Nzukɛ ati yɛ̂ ɛmɔ lɛ nɛnɩan yɛ́ sʋa ɔ? Ɛmɔ jʋnlɩn kɛ yɛ́ muonun yɛ́ tunmɩn anaan Nyanmɩan ɛsʋ́ɛ kpa mɔ yɛ sʋ tala ɛmɔ'n y'ɔ man bian ɛhɩ anwʋn a sa ɔ? ");
INSERT INTO any_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Abalahamʋn, Izakɩ nʋn Zʋakɔbʋ Nyanmɩan'n, yɛ́ nan-mɔ Nyanmɩan'n yɛ̂ ɔ'a wula yɩ́ akʋa Zozi anunminnyanmʋn ɔ. Ɛmɔ muonun yɩlɩ Zozi bɛ manlɩn mân nɩn asʋ mgbain'n-mɔ. Pilatɩ m'ɔ kulo kɛ ahan ɔ yaci Zozi nun'n, ɛmɔ hanlɩn wɔ Pilatɩ anyunnun ɛbɛlɛ kɛ ɛmɔ mmianlɩn man Zozi anwʋn. ");
INSERT INTO any_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Zozi m'ɔ tɩ sʋanlan nwannzan-nwannzan, mɔ ɛsɛ ɔ tɩ sɛsɛfʋɛ'n, ɛmɔ a yɩ yɩ́ a tʋ. Ɛmɔ a sɛlɛ Pilatɩ kɛ ɔ yáci kodiawu'n lɩlɩ nun maan ɔ nyán yɩ́ ti. ");
INSERT INTO any_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Sakpa, ɛmɔ a man b'a hun Mɩnlɩan'n m'ɔ man ngʋan'n. Nan Nyanmɩan kʋsʋ a man ɔ fi ewue nun ɔ'a tinnge, yɛ́ kʋalaa yɛ di yɩ́ nwʋn adanzɩɛ. ");
INSERT INTO any_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Tunmin'n m'ɔ wɔ Zozi dunman nɩn anun'n, ɔ nʋn dedi'n mɔ yɛ le yɩ́ wɔ dunman sɔ nɩn anun'n, y'ɔ man sʋanlan ɛhɩ m'ɔ jin ɛmɔ anyunnun ɛwa, mɔ ɛmɔ sɩ yɩ́ nɩn a nyan anwʋnsɛlɛ ɔ. Yɩ́ ti, dedi'n mɔ yɛ le yɩ́ wɔ Zozi dunman nɩn anun'n, y'ɔ man bian ɛhɩ mɔ ɛmɔ nwun yɩ́ ɛwa nɩn a tɩ akpɔlɛ bɔkɔɔ ɔ. ");
INSERT INTO any_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Nan sian dɩɛ, anianman-mɔ, ɛmɔ nʋn ɛmɔ mgbain'n-mɔ like mɔ b'a yɔ Zozi'n, mɩn sɩ kɛ ɛmɔ nzɩ man, yɩ́ ti y'ɔ man ɛmɔ a yɔ ɔ. ");
INSERT INTO any_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Nyanmɩan manlɩn atɩn kɛ Kilisi'n, Izalayɛ Belemgbin Ngʋandefʋɛ'n, nwún amannɩnhunlun maan ɛjɔlɛ m'ɔ manlɩn yɩ́ mgbɔmanfʋɛ'n-mɔ kʋalaatin hanlɩn yɩ́ daba'n, ɛjɔlɛ sɔ'n kpɩ́n sʋ. ");
INSERT INTO any_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Yɩ́ ti, ɛmɔ nún bɛ́ nwʋn wɔ Nyanmɩan anyunnun, bɛ káci bɛ́ abalabɔ'n, nán Nyanmɩan a yaci ɛmɔ anwʋn sa ɔ'a hye ɛmɔ. ");
INSERT INTO any_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Sɛ ɛmɔ yɔ yɩ́ sɔ a, yɛ́ Mɩn 'ba man ɛmɔ nyan alʋacɩcɩɛ. Ɛsɛ *Kilisi'n, Izalayɛ Belemgbin Ngʋandefʋɛ m'ɔ lili mʋa ɔ yɩlɩ yɩ́ kɛ ɔ 'fa man ɛmɔ'n, ɔ 'man ɔ ba. Kilisi sɔ'n y'ɔ le Zozi. ");
INSERT INTO any_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","“Nan kɩkaala dɩɛ, ɔ di kɛ Zozi tanlan nyanmɩansʋ ɛlɔ. Ɔ 'tanlan ɛlɔ dede ninnge'n-mɔ kʋalaatin kaci biekun. Ɔ sanlɩn kɛ ɛjɔlɛ sɔ'n, Nyanmɩan manlɩn yɩ́ anwʋntɩɛ mgbɔmanfʋɛ'n-mɔ hanlɩn yɩ́ daba daba. ");
INSERT INTO any_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Ɛ 'nwun ɛjɔlɛ mɔ Moyizɩ hanlɩn'n: Yɛ́ Mɩn m'ɔ tɩ ɛmɔ Nyanmɩan'n, ɔ 'ba man bɛ wʋ kpɔmanfʋɛ kʋn kɛ mɩ́n ɛmɔ afian ɛwa. Yɩ́ kʋalaa m'ɔ kɔ han kɔ hele ɛmɔ'n, ɛmɔ tíe yɩ́. ");
INSERT INTO any_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Sʋanlan biala mɔ ɔ'a ndie man kpɔmanfʋɛ sɔ'n, bɛ 'kun yɩ́ bɛ yɩ yɩ́ fi Nyanmɩan menian'n-mɔ anun. ");
INSERT INTO any_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","“Ɔ fi Nyanmɩan kpɔmanfʋɛ Samiɛ mɛlɛ sʋ, mgbɔmanfʋɛ'n-mɔ mɔ bɛ tɔtʋa yɩ́'n mɛlɛ sʋ, ɛnɛ edua'n mɔ yɛ wɔ nun'n, mgbɔmanfʋɛ sɔ'n-mɔ kʋalaa hanlɩn yɩ́ nwʋn ɛjɔlɛ. ");
INSERT INTO any_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Anɔhʋba'n mɔ Nyanmɩan nanndɩlɩ mgbɔmanfʋɛ'n-mɔ asʋ ɔ bɔlɩ'n, anɔhʋba sɔ'n tɩ ɛmɔ dɩɛ. Nyɩhyɛ'n kʋsʋ m'ɔ nʋn ɛmɔ anan-mɔ hyɩhyɛlɩ'n, ɛmɔ wɔ nun bie. Afɩ, Nyanmɩan hanlɩn helelɩ Abalahamʋn kɛ: Ɔ nanndɩ wɔ́ sasʋ'n-mɔ asʋ, mɩn 'yeyila asɩɛ nɩn asʋ nvilie'n-mɔ kʋalaa asʋ. ");
INSERT INTO any_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Ɛhɩka ati, ɛmɔ kpa ɛyɔlɛ dunman nun, Nyanmɩan lili mʋa ɔ yɩlɩ yɩ́ akʋa'n, ɔ sʋanlɩn yɩ́ kɛ ɔ bála a yeyila ɛmɔ sʋ, sɛ ɛmɔ anun kʋn biala fi yɩ́ nyɔlɩɛ ɛtɛ nɩn anun jasʋ a.” ");
INSERT INTO any_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Anɩn Pɩɛlɩ nʋn Zʋan anʋan tɛ wɔ sʋ bɛ lɛ kan ɛjɔlɛ bɛ kele bagua'n, ɛbɛlɛ ala Nyanmɩan *tɛɛyɩfʋɛ'n-mɔ, Nyanmɩan awulo nɩn asʋ nzalafʋ kpain'n, ɔ nʋn *Sadusifʋɛ'n-mɔ bɛ kɔ a. ");
INSERT INTO any_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Mɔ bɛ tɩlɩ kɛ mmɔfʋɛ nnyuan'n lɛ kekele bagua'n ninnge, kɛ ewuetinnge wɔ ɛbɛlɛ, ɔ sanlɩn kɛ Zozi a wu a tinnge'n, ɛjɔlɛ nɩn a nyɔ man bɛ́ fɛ fɩ́ɩ́ sʋa. ");
INSERT INTO any_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Bɛ kɔ hyɩ Pɩɛlɩ nʋn Zʋan bɛ kɔ gua bɛ́ fiadɩ. Kɛmɔ anɩn alɩ́ɛ lɛ san'n, mmɔfʋɛ nnyuan'n kɔ la fiadɩ dede alɩ́ɛ kɔ hɩn. ");
INSERT INTO any_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Ɛhɩ nʋn ɛhɩ a, bɛ́ dɔʋn mɔ bɛ tielɩ ɛjɔlɛ'n mɔ Pɩɛlɩ nʋn Zʋan hanlɩn'n, bɛ lelɩ bɛ lili. Sɛ bɛ fa bɛ́ bɛ sɔ bɛ́ mɔ bɛ lili mʋa bɛ lelɩ Zozi bɛ lili nɩn asʋ a, bɛ́ kʋalaa bɛ́ menian lɛ kɔ kɔ yɔ akpɩɩ nnun. ");
INSERT INTO any_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Alɩ́ɛ hɩnlɩn an, Zufʋ mgbain'n-mɔ, Izalayɛ mân nɩn asʋ mgbain'n-mɔ, bɛ́ nʋn *mala nɩn asʋ mgbain'n-mɔ, bɛ kɔ yia Zoluzalɛmʋn ɛbɛlɛ. ");
INSERT INTO any_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Anyia sɔ'n, bɛ́ mɔ bɛ tɩ yɩ́ bʋ bie'n y'ɔ le tɛɛyɩfʋɛ kpain Hannɩn, Kayifʋ, Zʋan, Alɛgɩzanndɩlɩ nʋn tɛɛyɩfʋɛ kpain Hannɩn anwʋn amma'n-mɔ kʋalaatin. ");
INSERT INTO any_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Bɛ man bɛ nʋn Pɩɛlɩ nʋn Zʋan kɔ a bɛ́ ja sʋ. Bɛ kɔ bisa bɛ́ kɛ: “Ɔ nanndɩ tunmin benin anaan dunman benin asʋ yɛ̂ ɛmɔ a man sʋanlan ɛhɩ anwʋn a sa'n?” ");
INSERT INTO any_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Wawɛ Nwannzan-nwannzan'n kɔ li Pɩɛlɩ anzin. Pɩɛlɩ kɔ bua bɛ́ kɛ: “Mân mgbain, ");
INSERT INTO any_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","ɛnɛ bɛ nʋn yɛ́ a a ɛmɔ aja sʋ, ɔ sanlɩn kɛ, y'a yɔ bubuluwafʋɛ kʋn ye. Ɛmɔ lɛ bisa yɛ́ kɛ yɛ hán kɛ ɔ kpɩnlɩn yɔlɩ mɔ sʋanlan sɔ nɩn anwʋn a sa'n. ");
INSERT INTO any_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Kɛmɔ afɩ ɛmɔ kulo kɛ bɛ bisa nun bɛ tɩ yɩ́ bʋ'n, ɛmɔ nwún yɩ́ kɛ, Zozi Kilisi m'ɔ fi Nazalɛtɩ mɔ ɛmɔ a bʋbɔ yɩ́ kʋlʋwa nɩn asʋ, mɔ Nyanmɩan a man ɔ fi ewue nun ɔ'a tinnge'n, Zozi Kilisi sɔ'n dunman'n y'ɔ man sʋanlan ɛhɩ anwʋn a sa ɔ. ");
INSERT INTO any_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Ɛhɛlɛ Ɛjɔlɛ'n lɛ kan Zozi ɛjɔlɛ yuein kɛ: Ɛbʋɛ'n mɔ ɛmɔ mɔ bɛ lɛ si sua nɩn a bu yɩ́ kɛ ɔ tɩ man kpa mɔ ɛmɔ juli tʋlɩ'n, yɩ́ yɛ̂ ɔ'a kaci ɛbʋɛ kpa m'ɔ le sua nɩn anun nɩn ɔ! ");
INSERT INTO any_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Zozi angʋnmɩn ala y'ɔ kʋala kɛ ɔ man sʋanlan nyan yɩ́ ti ɔ. Ɔ sanlɩn kɛ, eyuadɩ nɩn anun, sɛ bɛ yɩ Zozi Kilisi a, Nyanmɩan a ngele man yɛ́ sʋanlan ngacile fɩ́ɩ́ kʋn m'ɔ kʋala kɛ ɔ man yɛ nyan yɛ́ ti ɔ.” ");
INSERT INTO any_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Kɛ Pɩɛlɩ nʋn Zʋan lɛ si jʋjɔ'n, ɔ kɔ sin mgbain'n-mɔ anwʋn. Ɔ sanlɩn kɛ, bɛ sɩ kɛ Pɩɛlɩ nʋn Zʋan, bɛ kalata'n mɔ bɛ si'n ngɔ man mʋa, ɛsɛ anɩn bɛ si Zozi sʋ daba. ");
INSERT INTO any_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Nan kɛmɔ bɛ nwunlin kɛ bubuluwafʋɛ nɩn anwʋn a sa, ɔ jin mmɔfʋɛ nnyuan nɩn anwʋn ɛbɛlɛ'n, bɛ ngɔ nyan man ɛjɔlɛ bɛ ngɔ bua mmɔfʋɛ nnyuan'n-mɔ. ");
INSERT INTO any_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Ɛhɩ a, mgbain'n-mɔ kɔ man bɛ́ atɩn kɛ bɛ fi sua'n mɔ bɛ di ɛjɔlɛ nun'n bɛ fíte. Mgbain'n-mɔ kɔ su akpʋlʋwa bɛ́ afian ɛlɔ. ");
INSERT INTO any_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Bɛ́ nwan: “Menian ɛhɩ-mɔ, nzu like dɩɛ yɛ̂ yɛ yɔ́ bɛ́ ɔ? Afɩ, Zoluzalɛmʋn amma'n-mɔ kʋalaatin a nwun yɩ́ yuein kɛ like mɔ mmɔfʋɛ sɔ'n-mɔ a yɔ'n, ɔ tɩ asinbɛnwʋn like kpili kpa. Ɔ man yɛ ngʋala yɛ nzu man yɩ́ nwʋn akpʋlʋwa. ");
INSERT INTO any_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Nan kɛ ɔ kɔ yɔ nán ɛjɔlɛ sɔ nɩn a ndɩnndɩn man ɔ'a ngɔ man mʋa'n, bɛ mán yɛ tótua bɛ́ kɛ, sɛ bɛ bɔ Zozi dunman'n biekun bɛ kele sʋanlan biala a, yɛ́ nʋn bɛ́ le yɩ́.” ");
INSERT INTO any_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Mɔ bɛ hanlɩn sɔ yuelɩ'n, bɛ kɔ fɛlɛ Pɩɛlɩ nʋn Zʋan, bɛ kɔ totua bɛ́ kɛ nán bɛ kekele menian'n-mɔ ninnge, ɛsɛ nán bɛ kan Zozi ɛjɔlɛ bɛ kele bɛ́ fɩ́ɩ́ kʋ́n. ");
INSERT INTO any_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Mɔ mgbain'n-mɔ anʋan tɔlɩ'n, Pɩɛlɩ nʋn Zʋan kɔ bisa bɛ́ kɛ: “Ɛmɔ tɩ́tɩ bɛ nɩ́an, Nyanmɩan anyunnun, asʋ ɔ tɩ sɛsɛ kɛ yɛ bú ɛmɔ ɔ tála Nyanmɩan ɔ? ");
INSERT INTO any_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Nan yɛ́ dɩɛ, ɛjɔlɛ mɔ y'a tɩ, mɔ yɛ́ nyɩn a nwun yɩ́'n, yɛ ngʋala yɛ mmuan man yɛ́ nʋan nɩn asʋ.” ");
INSERT INTO any_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Mgbain'n-mɔ kɔ totua bɛ́ kɛ sɛ bɛ bɔ Zozi sɔ'n dunman biekun an, bɛ nʋn bɛ́ le yɩ́. Mɔ bɛ hanlɩn sɔ yuelɩ'n, bɛ kɔ yaci Pɩɛlɩ nʋn Zʋan nun maan bɛ kɔ hɔ. Ɔ sanlɩn kɛ, mgbain'n-mɔ a nnwun man ɛjɔlɛ kpɔlɛ mɔ bɛ 'jinlan sʋ bɛ pinnin mmɔfʋɛ'n-mɔ ɔ. Afɩ, asinbɛnwʋn like'n mɔ mmɔfʋɛ'n-mɔ yɔlɩ'n dunman nun, anɩn menian'n-mɔ kʋalaa lɛ yɩ Nyanmɩan ayɛ. ");
INSERT INTO any_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Bubuluwafʋɛ'n mɔ yɩ́ nwʋn salɩ asinbɛnwʋn nun'n, ɔ tɩ sʋanlan mɔ anɩn ɔ'a li afʋɛ abulanan nʋn yɩ́ nzin. ");
INSERT INTO any_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Pɩɛlɩ nʋn Zʋan hɔlɩ tʋlɩ bɛ́ manngʋn'n-mɔ, mɛlɛ mɔ mgbain'n-mɔ yacili bɛ́ nun'n. Ɛjɔlɛ mɔ mgbain'n-mɔ hanlɩn helelɩ bɛ́'n, bɛ kɔ sʋsɔ sʋ bɛ kɔ han bɛ kɔ hele ɛhɩnlɩn-mɔ. ");
INSERT INTO any_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Mɔ Zozi menian ɛhɩnlɩn-mɔ tɩlɩ ɛjɔlɛ sɔ'n, bɛ́ kʋalaa bɛ́ bʋ kɔ yɔ kʋn. Bɛ kɔ yɔ asɔnɩn, bɛ́ nwan: “Yɛ́ Mɩn, wɔ́ yɛ̂ ɛ bɔlɩ anwunno nʋn asɩ ɔ, ɔ nʋn asue jenvie'n nʋn nun ninnge'n-mɔ kʋalaatin ɔ. ");
INSERT INTO any_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Wɔ́ yɛ̂ ɛ falɩ Wawɛ Nwannzan-nwannzan nɩn ɛ wulalɩ yɛ́ nan *Davidi anun ɔ. Ɔ manlɩn Davidi hanlɩn kɛ: Nzukɛ ati yɛ̂ mân mân'n-mɔ fa Nyanmɩan anwʋn ɛkpɔ mgban ɔ? Nzukɛ ati yɛ̂ menian'n-mɔ jasʋ Nyanmɩan akɔmɩn anun ɔ? ");
INSERT INTO any_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Asɩɛ nɩn asʋ mmelemgbin'n-mɔ nʋn mgbain'n-mɔ abʋ a yɔ kʋn, bɛ lɛ kɔ a tʋa yɛ́ Mɩn nʋn yɩ́ *Kilisi'n bɛ kʋn ɛlɔɛ. ");
INSERT INTO any_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","“Ɔ tɩ ananhɔlɛ kɛ kulo ɛhɩ asʋ, belemgbin Elɔdɩ, kʋnmanna Pʋnsʋ Pilatɩ, Zufʋ nʋn bɛ́ mɔ bɛ tɩ man Zufʋ'n, bɛ́ kʋalaa bɛ hɔlɩ wɔ́ anwʋntɩɛ akʋa Zozi m'ɔ a yɩ yɩ́ kɛ Belemgbin Ngʋandefʋɛ nɩn ati ahuan. ");
INSERT INTO any_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Ngɛlɛ'n mɔ ɛ sɩ ɔ nʋn tunmin'n mɔ ɛ le yɩ́'n, ɛjɔlɛ mɔ ɛ lili mʋa ɛ jʋnlɩnlɩn yɩ́ nwʋn ɛ sielɩ daba'n, b'a yɔ maan yɩ́ kʋalaa a kpɩn sʋ. ");
INSERT INTO any_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Sian dɩɛ, yɛ́ Mɩn, nɩan yɛ́ ti efua mɔ b'a fua'n, nán man wɔ́ ngʋa'n-mɔ anwʋnsɛlɛ kpa maan bɛ hán wɔ́ nʋan ɛjɔlɛ'n. ");
INSERT INTO any_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Fa wɔ́ sa sie nwuluwafʋɛ'n-mɔ asʋ maan bɛ́ nwʋn sá, yɔ asinbɛnwʋn ninnge maan bɛ nwún yɩ́ wɔ wɔ́ anwʋntɩɛ akʋa Zozi dunman nɩn anun.” ");
INSERT INTO any_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Mɔ bɛ yuelɩ asɔnɩn'n yɔ'n, lɩka mɔ bɛ yialɩ'n, ɛbɛlɛ asɩɛ'n kɔ kpusu. Wawɛ Nwannzan-nwannzan'n kɔ jinlan bɛ́ kʋalaa bɛ́ nzin kpa bɔkɔɔ. Bɛ kɔ nyan anwʋnsɛlɛ bɛ kɔ han Nyanmɩan Anʋan Ɛjɔlɛ'n. ");
INSERT INTO any_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Bɛ́ kʋalaa mɔ bɛ lelɩ Zozi bɛ lili nɩn anʋan sɛ bɛ́ nwʋn kpa, bɛ́ ahʋnlɩn'n tɩ kʋn, bɛ́ ajʋnlɩn'n tɩ kʋn. Bie njasʋ man ɔ ngan man kɛ like m'ɔ le yɩ́'n tɩ yɩ́ ngʋnmɩn yɩ́ dɩɛ. Nan bɛ́ afian, sʋanlan kʋn like m'ɔ le yɩ́'n tɩ bɛ́ kʋalaa bɛ́ dɩɛ. ");
INSERT INTO any_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Anɩn mmɔfʋɛ'n-mɔ le tunmin kpili kpa bɛ kan yɛ́ Mɩn Zozi ewuetinnge nɩn anwʋn ɛjɔlɛ. Nyanmɩan kʋsʋ kɔ yeyila bɛ́ sʋ kpa. ");
INSERT INTO any_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Bɛ́ nun bie fɩ́ɩ́ mmian man like anwʋn. Afɩ, bɛ́ kʋalaa mɔ bɛ le ebo anaan sua'n, bɛ tɔnɩn yɩ́ bɛ fa yɩ́ esika'n ");
INSERT INTO any_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","bɛ wula mmɔfʋɛ'n-mɔ asa nun. Bɛ nɩan like mɔ sʋanlan kʋn a mian yɩ́ nwʋn'n yɛ̂ bɛ ce esika nɩn ɔ. ");
INSERT INTO any_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Nunhan kʋn, bɛ fɛlɛ yɩ́ Zozɛfʋ, ɔ tɩ *Levifʋɛ. Mmɔfʋɛ'n-mɔ tʋnlɩn yɩ́ dunman Baanabasɩ. Baanabasɩ'n yɩ́ bʋ y'ɔ le kɛ “Sʋanlan m'ɔ wowula anwʋnsɛlɛ”. Bɛ wʋlɩ yɩ́ Sipʋlʋ mân nun. ");
INSERT INTO any_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Anɩn ɔ le yɩ́ ebo kʋn. Ɔ kɔ tɔnɩn yɩ́, ɔ kɔ fa yɩ́ esika'n kɔ bɛlɛ mmɔfʋɛ'n-mɔ. ");
INSERT INTO any_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Anɩn bian kʋn wɔ ɛbɛlɛ, bɛ fɛlɛ yɩ́ Ananiasɩ. Yɩ́ yɩ'n li Safila. Ananiasɩ nʋn yɩ́ yɩ bɛ́ nʋan kɔ sɛ bɛ́ nwʋn, ɔ kɔ tɔnɩn bɛ́ asɩɛ'n. ");
INSERT INTO any_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Ɔ tɔnɩnlɩn yɩ́ a, ɔ nʋn yɩ́ yɩ bɛ́ bʋ kɔ yɔ kʋn. Bɛ kɔ bu esika nɩn anun. Ananiasɩ kɔ fa yɩ́ ebue kɔ hɔ kɔ wula mmɔfʋɛ'n-mɔ asa nun. ");
INSERT INTO any_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Mɔ Pɩɛlɩ nwunlin esika'n, ɔ kɔ bisa Ananiasɩ kɛ: “Ananiasɩ, asɩɛ'n mɔ a tɔnɩn yɩ́ nɩn esika'n, nzukɛ ati yɛ̂ a yaci *Satan maan ɔ'a laka wɔ́ a tɩ bie a sie awulo, mɔ ɛ lɛ ba li ato ɛ kele Wawɛ Nwannzan-nwannzan nɩn ɔ? ");
INSERT INTO any_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Asɩɛ'n tɩ wɔ́ dɩɛ, b'a mmian man wɔ́ kɛ ɛ tɔ́nɩn yɩ́. Sɛ a tɔnɩn yɩ́ kʋsʋ a, yɩ́ esika'n tɩ wɔ́ dɩɛ. Nan afɩ benin ati yɛ̂ ɛ man ajʋnlɩn sʋa ba wɔ́ ti anun ɔ? Nán kulo menian yɛ̂ a li ato a hele bɛ́ ɔ, nan Nyanmɩan muonun yɛ̂ a li ato a hele yɩ́ ɔ.” ");
INSERT INTO any_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Pɩɛlɩ hanlɩn sɔ ala, kpaaa, Ananiasɩ kɔ kpɛ kɔ fin, ɔ kɔ ha ɛbɛlɛ ɔ kɔ wu. Bɛ́ kʋalaa mɔ bɛ tɩlɩ ɛjɔlɛ sɔ'n, esulo kɔ han bɛ́. ");
INSERT INTO any_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Mgbafɛlɛ'n-mɔ kɔ a kɔ fʋfɔ fuin nɩn anwʋn, bɛ kɔ fa yɩ́ kɔ hɔ kɔ sie yɩ́. ");
INSERT INTO any_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Kɔ yɔ dɔhyʋɩlɩ nsan kɔ sɩn, Safila kɔ a, ɔ'a ndɩ man kɛ yɩ́ hun a wu ɔ. ");
INSERT INTO any_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Pɩɛlɩ kɔ fɛlɛ yɩ́ kɔ bisa yɩ́ kɛ: “Safila, asʋ gua sʋa yɛ̂ ɛmɔ tɔnɩnlɩn ɛmɔ asɩɛ nɩn ɔ?” Safila kɔ bua Pɩɛlɩ kɛ: “Yuo, gua sʋa yɛ̂ yɛ tɔnɩnlɩn asɩɛ nɩn ɔ.” ");
INSERT INTO any_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Ɛhɩ a, Pɩɛlɩ kɔ bisa yɩ́ kɛ: “Ɔ yɔ sɛ mɔ ɛ nʋn wɔ́ hun, ɛmɔ abʋ a yɔ kʋn bɛ lɛ sa yɛ́ Mɩn Wawɛ'n bɛ nɩan ɔ? Nɩan, bɛ́ mɔ bɛ hɔlɩ sielɩ wɔ́ hun'n, b'a ju anʋan nun ɛbɛlɛ. Wɔ́ kʋsʋ wɔ́, bɛ nʋn wɔ́ 'ba hɔ bie.” ");
INSERT INTO any_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Ɛbɛlɛ ala, Safila kɔ kpɛ kɔ fin Pɩɛlɩ aja abʋ ɛbɛlɛ ɔ kɔ wu. Mgbafɛlɛ'n-mɔ 'ba ju a, anɩn Safila a wu. Bɛ kɔ fa yɩ́ kɔ hɔ kɔ sie yɩ́ yɩ́ hun anwʋn ɛbɛlɛ. ");
INSERT INTO any_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Asɔnɩn mma'n-mɔ kʋalaa nʋn bɛ́ kʋalaa mɔ bɛ tɩlɩ ɛjɔlɛ sɔ'n, bɛ kɔ sulo Nyanmɩan kpa. ");
INSERT INTO any_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Anɩn mmɔfʋɛ'n-mɔ lɛ yɔ asinbɛnwʋn ninnge dɔʋn kpa bagua nɩn afian. Bɛ́ kʋalaa mɔ bɛ de Zozi bɛ di'n, bɛ́ kʋalaa bɛ yia Salomʋn abalanda nɩn anun Nyanmɩan awulo ɛbɛlɛ. ");
INSERT INTO any_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Sʋanlan fɩ́ɩ́ ngulo man kɛ ɔ fa yɩ́ nwʋn ɔ bɔ Zozi menian'n-mɔ. Nan kʋsʋ bɛ́ kʋalaa bɛ kulo Zozi menian'n-mɔ ɛjɔlɛ kpa. ");
INSERT INTO any_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Mmelenzua nʋn mmalasua dɔʋn kpa kɔ le yɛ́ Mɩn bɛ kɔ li, bɛ kɔ bʋka daba dɩɛ'n-mɔ asʋ. ");
INSERT INTO any_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Bɛ fa nwuluwafʋɛ'n-mɔ bɛ fite gua nɩn asʋ, bɛ lɩla mgba sʋ ɔ nʋn ɛkpan sʋ. Yɩ́ dɩɛ, anɩn Pɩɛlɩ 'sɩn an, yɩ́ wawɛ'n sɩn bɛ́ nun bie asʋ. ");
INSERT INTO any_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Menian dɔʋn kpa fi kulo kulo'n-mɔ mɔ bɛ mantan mantan Zoluzalɛmʋn nɩn asʋ bɛ ba. Bɛ 'ba a, bɛ nʋn nwuluwafʋɛ'n-mɔ nʋn bɛ mɔ wawɛ ɛtɛ'n-mɔ lɛ kele bɛ́ yalɛ'n yɛ̂ bɛ ba ɔ. Bɛ́ kʋalaa bɛ́ nwʋn kɔ sa. ");
INSERT INTO any_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Ɛhɩ a, *tɛɛyɩfʋɛ kpain'n nʋn *Sadusifʋɛ'n-mɔ m'ɔ nʋn bɛ́ y'ɔ di fâ'n, bɛ́ kʋalaa bɛ kɔ fa mmɔfʋɛ'n-mɔ anwʋn ɛkpɔ kpa. ");
INSERT INTO any_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Bɛ kɔ hyɩ mmɔfʋɛ'n-mɔ bɛ kɔ gua bɛ́ fiadɩ. ");
INSERT INTO any_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Nan mɔ alɩ́ɛ sanlɩn'n, nyanmɩansʋ bɔfʋɛ kʋn kɔ a kɔ tike tike fiadɩ sua nɩn anʋan'n-mɔ. Ɔ kɔ man mmɔfʋɛ'n-mɔ kɔ fite, ɔ kɔ han kɔ hele bɛ́ kɛ: ");
INSERT INTO any_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Ɛmɔ hɔ́ Nyanmɩan awulo nɩn anun, ɛmɔ hán ngʋan fʋfɔlɛ nɩn anwʋn ɛjɔlɛ bɛ héle menian'n-mɔ.” ");
INSERT INTO any_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Mmɔfʋɛ'n-mɔ kɔ le ɛjɔlɛ sɔ'n kɔ tʋ nun. Ngɛlɛmɔ tutun kpa, bɛ kɔ hɔ menian'n-mɔ like ehehele Nyanmɩan awulo ɛlɔ. Tɛɛyɩfʋɛ kpain'n nʋn yɩ́ sasʋ'n-mɔ kɔ a, bɛ kɔ yia Izalayɛ mân nɩn asʋ mgbain'n-mɔ ɔ nʋn bɛ́ mɔ bɛ di ɛjɔlɛ'n. Bɛ kɔ yɩ menian kɛ bɛ hɔ́ fiadɩ sua nɩn anun ɛlɔ nán bɛ nʋn mmɔfʋɛ'n-mɔ bála. ");
INSERT INTO any_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Nzalafʋ sɔ'n-mɔ hɔlɩ juli fiadɩ sua nɩn anun ɛlɔ a, bɛ ngɔ nwun man mmɔfʋɛ'n-mɔ. Bɛ kɔ sa bɛ kɔ a kɔ tʋ mgbain'n-mɔ. ");
INSERT INTO any_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","Bɛ́ nwan: “Yɛ 'kɔ a ju a, anɩn fiadɩ sua nɩn anʋan'n nyin kanlanman kpa. Bɛ́ mɔ bɛ sisa fiadɩ sua'n kʋsʋ jijin bɛ́ bʋsʋ ɛbɛlɛ anʋan nɩn anun. Nan mɛlɛ mɔ yɛ tikelɩ tikelɩ anʋan'n-mɔ'n, y'a nnwun man sʋanlan fɩ́ɩ́ sua nɩn anun.” ");
INSERT INTO any_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Mɔ nzalafʋ kpain'n m'ɔ nɩan Nyanmɩan awulo nɩn asʋ nʋn tɛɛyɩfʋɛ mgbain'n-mɔ tɩlɩ ɛjɔlɛ sɔ'n, ɔ kɔ sin bɛ́ nwʋn. Bɛ kɔ bisa bisa bɛ́ nwʋn kɛ: “Ɛnwannyan'n mɔ mmɔfʋɛ'n-mɔ a nwannyan'n, asʋ ɛjɔlɛ ngɔ a man yɩ́ nzin ɔ?” ");
INSERT INTO any_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Kaan cɛ, sʋanlan kʋn kɔ a kɔ tʋ bɛ́. Yɩ́ nwan: “Ɛmɔ nɩ́an, menian'n-mɔ mɔ ɛmɔ gualɩ bɛ́ fiadɩ'n, bɛ gua Nyanmɩan awulo ɛlɔ, bɛ lɛ kekele menian'n-mɔ ninnge.” ");
INSERT INTO any_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Mɔ nzalafʋ kpain'n tɩlɩ kɛ mmɔfʋɛ'n-mɔ wɔ Nyanmɩan awulo ɛlɔ'n, ɔ nʋn yɩ́ nzalafʋ'n-mɔ bɛ kɔ hɔ kɔ hyɩ bɛ́ bɛ nʋn bɛ́ kɔ a. Nan kʋsʋ, nzalafʋɛ'n-mɔ a ngele man mmɔfʋɛ'n-mɔ ahʋlʋwa. Afɩ, bɛ sulo kɛ bagua'n kɔ tʋtʋ bɛ́ ɛbʋɛ. ");
INSERT INTO any_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Mɔ bɛ nʋn bɛ́ walɩ juli mgbain'n-mɔ aja sʋ'n, tɛɛyɩfʋɛ kpain'n kɔ bisa bɛ́ kɛ: ");
INSERT INTO any_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Y'a ndotua man ɛmɔ kɛ nán man ɛmɔ kekele menian'n-mɔ ninnge kʋ́n wɔ Zozi dunman nun ɔ? Ɛmɔ le dunman sɔ'n b'a hehele Zoluzalɛmʋn kulo bɔndɩn'n like. Ɛmɔ kulo kɛ yɩ́ ewue'n m'ɔ wuli'n, yɩ́ jɔwɔlɛ ka yɛ́ sʋ!” ");
INSERT INTO any_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Mɔ tɛɛyɩfʋɛ kpain'n hanlɩn sɔ'n, Pɩɛlɩ nʋn mmɔfʋɛ'n-mɔ kɔ bua bɛ́ kɛ: “Ɔ sɛ kɛ yɛ bú Nyanmɩan yɛ tála kulo menian'n-mɔ. ");
INSERT INTO any_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Zozi sɔ'n mɔ ɛmɔ bʋbɔlɩ yɩ́ kʋlʋwa nɩn asʋ bɛ hunlin yɩ́'n, yɛ́ nan-mɔ Nyanmɩan nɩn a man ɔ fi ewue nun ɔ'a tinnge. ");
INSERT INTO any_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Yɩ́ yɛ̂ Nyanmɩan a fa yɩ́ a sie yɩ́ fama sʋ kɛ Belemgbin Ngʋandefʋɛ, mɔ ɔ 'man Izalayɛ kaci yɩ́ abalabɔ'n ɔ nyan ɛtɛ face ɔ. ");
INSERT INTO any_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Yɛ nʋn Wawɛ Nwannzan-nwannzan'n mɔ Nyanmɩan a fa a man bɛ́ mɔ bɛ bu yɩ́'n, yɛ di ɛjɔlɛ sɔ'n-mɔ anwʋn adanzɩɛ.” ");
INSERT INTO any_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Mɔ mgbain'n-mɔ tɩlɩ ɛjɔlɛ sɔ'n, bɛ kɔ fɛ mmɔfʋɛ'n-mɔ anwʋn ɛya kpa. Bɛ́ nwan bɛ 'man bɛ kun bɛ́. ");
INSERT INTO any_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Anɩn Falisifʋɛ kʋn wɔ bɛ́ nun. Bɛ fɛlɛ bian sɔ'n Gamaliɛ. Ɔ tɩ mala nɩn asʋ kpain'n kʋn. Menian'n-mɔ kʋalaa fɛlɩ yɩ́. Ɔ kɔ jasʋ kɔ jinlan mgbain'n-mɔ afian, ɔ kɔ han kɔ hele bɛ́ kɛ bɛ mán mmɔfʋɛ'n-mɔ fíte kaan. ");
INSERT INTO any_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Mɔ bɛ manlɩn mmɔfʋɛ'n-mɔ fitelɩ'n, Gamaliɛ kɔ han kɔ hele mgbain'n-mɔ kɛ: “Izalayɛ amma, ɛmɔ nɩ́an bɛ́ nwʋn kpa wɔ like mɔ ɛmɔ kulo kɛ bɛ yɔ menian ɛhɩ-mɔ nɩn anwʋn. ");
INSERT INTO any_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Ɔ sanlɩn kɛ, Tedasɩ fitelɩ, ɔ hyɛlɩ man biala. Tedasɩ buli yɩ́ nwʋn kɛ ɔ tɩ sʋanlan kpili. Menian ɛya nnan kɔ si yɩ́ sʋ. Mɔ bɛ hunlin yɩ́'n, menian ɛya nnan'n bɔlɩ asanndɩɛ, bɛ́ eku'n tɔlɩ asɩ. ");
INSERT INTO any_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Bɛ yɩ Tedasɩ a, Zudasɩ m'ɔ fi Galile mân nun'n kʋsʋ fitelɩ yɩ́ dɩɛ tɛmʋn mɔ bɛ 'ka menian'n-mɔ'n. Menian sili yɩ́ sʋ. Mɔ bɛ hunlin yɩ́'n, bɛ́ mɔ anɩn bɛ si yɩ́ sʋ'n kʋalaa bɔlɩ asanndɩɛ. ");
INSERT INTO any_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Yɩ́ ti, kɩkaala dɩɛ, mɩɩn kan mɩn kele ɛmɔ kɛ ɛmɔ yáci menian sɔ'n-mɔ koun, nán bɛ tɛ bɛ́ sʋ fɩ́ɩ́ kʋ́n. Ɔ sanlɩn kɛ junman'n mɔ bɛ lɛ di'n, sɛ ɔ fi man Nyanmɩan ɛlɔ a, ɔ 'tɔ asɩ. ");
INSERT INTO any_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Nan sɛ junman'n mɔ bɛ lɛ di yɩ́ ɛbɛlɛ'n fi Nyanmɩan ɛlɔ sakpa a, ɛmɔ ngɔ hʋala man yɩ́ sɛcɩ. Yɩ́ ti, ɛmɔ nɩ́an bɛ́ nwʋn kpa nán ɛmɔ nʋn Nyanmɩan b'a ngʋn man ngondin!” ");
INSERT INTO any_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Mɔ Gamalɩɛ hanlɩn sɔ yuelɩ'n, mgbain'n-mɔ kɔ fa atɩn'n mɔ ɔ'a hele bɛ́ nɩn asʋ. Bɛ kɔ fɛlɛ mmɔfʋɛ'n-mɔ, bɛ kɔ man bɛ kɔ fin bɛ́ mgbele ɛsɛ bɛ kɔ totua bɛ́ kɛ nán bɛ bɔ Zozi dunman'n fɩ́ɩ́ kʋn asannan nán b'a yaci bɛ́ nun. ");
INSERT INTO any_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Mmɔfʋɛ'n-mɔ fi mgbain'n-mɔ anyunnun bɛ 'kɔ a, anɩn b'a li fɛ kpa kɛ Zozi dunman nun, menian'n-mɔ a hele bɛ́ yalɛ ɔ. ");
INSERT INTO any_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","M'ɔ yɔlɩ sɔ'n, cɩan daa bɛ kekele menian'n-mɔ ninnge Nyanmɩan awulo nɩn anun ɔ nʋn awulo'n-mɔ anun, bɛ bɔ Zozi m'ɔ tɩ *Kilisi nɩn anwʋn Ɛjɔlɛkpa'n. ");
INSERT INTO any_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Tɛmʋn sɔ'n, anɩn Zozi menian'n-mɔ lɛ sʋn. Zufʋ'n-mɔ mɔ bɛ kan gɛlɛkɩ anɩɛ'n kɔ jʋjɔ Zufʋ'n-mɔ mɔ bɛ kan Ebele anɩɛ'n. Ɔ sanlɩn kɛ, bɛ 'ce esika nɩn an, bɛ nnɩan man kunlannvʋɛ mmalasua'n-mɔ mɔ bɛ kan gɛlɛkɩ anɩɛ'n lɩka. ");
INSERT INTO any_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Ɛhɩ a, mmɔfʋɛ bulu nʋn nnyuan'n kɔ yia Zozi menian'n-mɔ kʋalaatin, bɛ kɔ fa bɛ kɔ tʋ bɛ́ nyunnun kɛ: “Ɔ tɩ man sɛsɛ kɛ yɛ yáci Nyanmɩan Anʋan Ɛjɔlɛ nɩn ɛhan yɛ nɩ́an alɩɛ nɩn ehye nun. ");
INSERT INTO any_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Yɩ́ ti, anianman-mɔ, ɛmɔ nɛ́nɩan ɛmɔ afian ɛlɔ, bɛ kpʋ́nndɛ menian nsʋ mɔ bɛ bɔ bɛ́ dunman kpa, mɔ Wawɛ Nwannzan-nwannzan'n wɔ bɛ́ nun, mɔ ɛsɛ bɛ sɩ ngɛlɛ. Yɛ 'fa junman sɔ'n yɛ wula bɛ́ sa nun. ");
INSERT INTO any_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Yɩ́ dɩɛ anɩn yɛ́ kʋsʋ yɛ nyan atɩn yɛ yɔ asɔnɩn ɛsɛ yɛ kan Nyanmɩan Anʋan Ɛjɔlɛ'n.” ");
INSERT INTO any_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Mɔ mmɔfʋɛ'n-mɔ hanlɩn sɔ'n, bɛ́ kʋalaa bɛ kɔ le bɛ kɔ tʋ nun. Ɛhɩ, bɛ kɔ yɩ Etiɛnɩn. Etiɛnɩn tɩ sʋanlan m'ɔ le dedi kpa, ɛsɛ Wawɛ Nwannzan-nwannzan'n wɔ yɩ́ nun. Bɛ kɔ yɩ Filipʋ, Polokɔɔ, Ninkanɔɔ, Timʋn, Paamenasɩ nʋn Ninkola. Ninkola sɔ'n fi kulo'n mɔ bɛ fɛlɛ yɩ́ Antiɔsʋ nɩn asʋ. Daba, anɩn ɔ kɔ Zufʋ'n-mɔ asɔnɩn'n bie. ");
INSERT INTO any_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Mɔ bɛ yɩlɩ menian nsʋ sɔ'n-mɔ'n, bɛ kɔ fa bɛ́ bɛ kɔ hele mmɔfʋɛ'n-mɔ. Mmɔfʋɛ'n-mɔ kɔ fa bɛ́ sa bɛ kɔ fua bɛ́ ti sʋ bɛ kɔ sɛlɛ Nyanmɩan bɛ kɔ man bɛ́. ");
INSERT INTO any_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Anɩn Nyanmɩan Anʋan Ɛjɔlɛ'n lɛ tɛlɛ kɔ, Zoluzalɛmʋn ɛbɛlɛ menian mɔ b'a fa bɛ́ nwʋn b'a man yɛ́ Mɩn Zozi'n kɔ sʋn kpa. Tɛɛyɩfʋɛ dɔʋn kɔ le Zozi kɔ li. ");
INSERT INTO any_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Anɩn Etiɛnɩn lɛ yɔ asinbɛnwʋn ninnge mgbili kpa menian'n-mɔ afian. Ɔ sanlɩn kɛ Nyanmɩan tunmin'n nʋn yɩ́ anwʋnsɛlɛ'n wɔ yɩ́ nun. ");
INSERT INTO any_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Ɛhɩ a, Zufʋ mmie-mɔ, bɛ kɔ asɔnɩn'n mɔ bɛ fɛlɛ yɩ́ “B'a kpɛ asue'n” bɛ nʋn Etiɛnɩn kɔ sota nun. Zufʋ sɔ'n-mɔ fi Silɛnɩn nʋn Alɛgɩzanndili kulo nɩn asʋ, ɔ nʋn Silisi nʋn Azi mân nun. ");
INSERT INTO any_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Kɛmɔ bɛ nɩan an, bɛ ngʋala man Etiɛnɩn, afɩ Wawɛ Nwannzan-nwannzan wɔ yɩ́ nun ɛsɛ ɔ kan ɛjɔlɛ'n ngɛlɛ sʋ'n, ");
INSERT INTO any_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","bɛ kɔ bɔ menian kpa kɛ bɛ tʋ́n yɩ́ ɛsʋan kɛ: “Etiɛnɩn a han ɛjɔlɛ ɛtɛ a tia Moyizɩ nʋn Nyanmɩan. Ɔ 'kan tia bɛ́'n, yɛ tɩ yɩ́ bʋ.” ");
INSERT INTO any_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Bɛ kɔ man bagua'n nʋn Zufʋ mgbain'n-mɔ nʋn *mala nɩn asʋ mgbain'n-mɔ kɔ jasʋ Etiɛnɩn akɔmɩn anun. Bɛ kɔ li Etiɛnɩn nvu nun bɛ kɔ hyɩ yɩ́ bɛ nʋn yɩ́ kɔ hɔ mgbain'n-mɔ aja sʋ. ");
INSERT INTO any_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Mɔ bɛ 'kɔ'n, adanzɩyua'n-mɔ wɔ bɛ́ nun. Bɛ́ nwan: “Sʋanlan ɛhɩ nyaci man Moyizɩ mala'n nʋn Nyanmɩan Awulo Nwannzan-nwannzan nɩn anwʋn ɛjɔlɛ ɛtɛ ɛhan fɩ́ɩ́ sʋa! ");
INSERT INTO any_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Y'a tɩ yɩ́ nʋan nun kɛ Zozi m'ɔ fi Nazalɛtɩ'n 'ba bubu Nyanmɩan awulo'n, ɛsɛ ɔ 'kaci mala'n mɔ Moyizɩ falɩ manlɩn yɛ́'n.” ");
INSERT INTO any_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Bɛ́ kʋalaa mɔ bɛ gua ɛjɔlɛ elie sua nɩn anun nɩn anyɩn kɔ ha Etiɛnɩn anwʋn. Ɔ sanlɩn kɛ yɩ́ nyɩn nɩn anun kacili kɛ nyanmɩansʋ mmɔfʋɛ'n-mɔ dɩɛ'n. ");
INSERT INTO any_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Ɛhɩ a, *tɛɛyɩfʋɛ kpain'n kɔ bisa Etiɛnɩn kɛ: “Asʋ ɛjɔlɛ'n mɔ bɛ lɛ kan'n tɩ ananhɔlɛ ɔ?” ");
INSERT INTO any_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Etiɛnɩn kɔ bua yɩ́ kɛ: “Mɩ́n nianman nʋn mɩ́n sɩ-mɔ, ɛmɔ tíe! Mɛlɛ mɔ anɩn yɛ́ nan *Abalahamʋn wɔ Mezopotamin mân nɩn anun'n, asannan nán ɔ'a tu ɔ'a tanlan Halan'n, Anunminnyanmʋn Nyanmɩan'n yɩlɩ yɩ́ nwʋn ɔ helelɩ yɩ́. ");
INSERT INTO any_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Nyanmɩan hanlɩn helelɩ yɩ́ kɛ: Abalahamʋn, fi wɔ́ mân nɩn anun tu, jasʋ wɔ́ afilie nɩn abʋ anwʋn nán kɔ mân'n mɔ mɩn 'ba hele wɔ́ nɩn anun. ");
INSERT INTO any_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Mɔ Nyanmɩan hanlɩn sɔ'n, sakpa Abalahamʋn fi Kalide mân nɩn anun ɔ kɔ tu, ɔ kɔ a kɔ tanlan Halan. Halan ɛbɛlɛ yɛ̂ yɩ sɩ wuli ɔ. Mɔ yɩ́ sɩ wuli'n, Nyanmɩan man ɔ fi ɛbɛlɛ ɔ kɔ tu, ɔ kɔ a kɔ tanlan mân ɛhɩ mɔ ɛnɛ ɛmɔ tɩ nun ɛwa nɩn anun. ");
INSERT INTO any_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Mân sɔ nɩn anun, Nyanmɩan a mman man yɩ́ like, ɔ'a mman man yɩ́ asɩɛ bɛ́ ja kʋn mgban. Kʋsʋ Nyanmɩan bɔlɩ yɩ́ anɔhʋba kɛ ɔ 'fa mân sɔ'n man yɩ́, ɔ nʋn yɩ́ sasʋ'n-mɔ mɔ bɛ lɛ ba a yɩ́ nzin'n. Tɛmʋn mɔ ɔ 'kan ɛjɔlɛ sɔ'n ɔ kele Abalahamʋn'n, anɩn Abalahamʋn wʋlɩ man baa. ");
INSERT INTO any_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Ɛ 'nwun ɛjɔlɛ biekun m'ɔ hanlɩn helelɩ Abalahamʋn'n: Wɔ́ sasʋ'n-mɔ mɔ bɛ lɛ ba a wɔ́ nzin'n, bɛ 'ba ha mân fʋfɔlɛ anun bɛ kaci nganga. Bɛ 'ba hele bɛ́ ahʋlʋwa dede afʋɛ ɛya nnan. ");
INSERT INTO any_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Bɛ́ mɔ bɛ kɔ fa bɛ́ bɛ kɔ yɔ bɛ́ nganga'n, mɩ́n yɛ̂ mɩn 'bua bɛ́ ndɛɛ ɔ. Mɩn yɔ yɩ́ sɔ yue a, bɛ fi mân sɔ nɩn anun bɛ 'tu bɛ ba bɛ sʋ mɩ́n ɛwa lɩka ɛhɩ anun. ");
INSERT INTO any_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Mɔ Nyanmɩan hanlɩn sɔ yuelɩ'n, ɔ nʋn Abalahamʋn bɛ kɔ li nyɩhyɛ. Nyɩhyɛ sɔ'n, yɩ́ nzɔlɛ y'ɔ le mmian nun ɛkpɛ'n. Ɛhɩka ati yɛ̂ Abalahamʋn wʋlɩ yɩ́ wa belenzua Izakɩ m'ɔ lili ɛlɛɔcʋɛ'n, ɔ kpɛlɩ yɩ́ mmian nun nɩn ɔ. Izakɩ kʋsʋ kɔ kpɛ Zʋakɔbʋ dɩɛ'n. Zʋakɔbʋ kʋsʋ kɔ kpɛ Izalayɛ nvilie bulu nʋn nnyuan'n mgbain'n-mɔ dɩɛ'n. ");
INSERT INTO any_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Mgbain sɔ'n-mɔ anun mmie-mɔ kɔ fa bɛ́ nianman Zozɛfʋ anwʋn ɛkpɔ. Bɛ kɔ tɔnɩn yɩ́. Bɛ nʋn yɩ́ kɔ hɔ Ezipiti mân nun ɔ kɔ kaci kanga. Nan kʋsʋ anɩn Nyanmɩan nʋn yɩ́ san. ");
INSERT INTO any_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Nyanmɩan kɔ le yɩ́ fi yɩ́ amannɩnhunlun'n kʋalaatin anun. Ɔ manlɩn yɩ́ ngɛlɛ ɔ manlɩn Falaʋn m'ɔ tɩ Ezipiti mân nɩn asʋ belemgbin'n kɔ bu yɩ́ sʋanlan. Falaʋn kɔ fa Zozɛfʋ kɔ sie mân nɩn asʋ ɔ nʋn yɩ́ awulo nɩn asʋ kpain. ");
INSERT INTO any_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Ɛhɔɛ kʋn kɔ kpɩn Ezipiti nʋn Kanaân mân'n kʋalaatin anun. Yɛ́ nan-mɔ nwunlin yalɛ kpa, afɩ anɩn bɛ nnyan man like fɩ́ɩ́ bɛ nni man. ");
INSERT INTO any_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","“Mɔ Zʋakɔbʋ tɩlɩ kɛ bɛ nyan *bele Ezipiti mân nun'n, ɔ kɔ li mʋa ɔ kɔ sʋan yɩ́ mma'n-mɔ mɔ bɛ tɩ yɛ́ nan nɩn ɛlɔ kʋn. ");
INSERT INTO any_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Mɔ Zʋakɔbʋ sʋanlɩn yɩ́ mma'n-mɔ Ezipiti mân nun m'ɔ tɩan yɩ́ kpɛ nnyuan'n, Zozɛfʋ kɔ yɩ yɩ́ nwʋn kɔ hele yɩ́ nianman'n-mɔ. Falaʋn kɔ nwun lɩka mɔ Zozɛfʋ fi'n, ɔ kɔ nwun Zozɛfʋ anwʋn amma. ");
INSERT INTO any_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","M'ɔ yɔlɩ sɔ'n, Zozɛfʋ kɔ yɩ yɩ́ nianman'n-mɔ kɛ bɛ hɔ́ fá bɛ́ sɩ nʋn bɛ́ nwʋn amma'n-mɔ kʋalaatin, maan bɛ bála Ezipiti mân nun. Bɛ́ kʋalaa, bɛ tɩ menian abulasʋ ɔ nʋn nnun. ");
INSERT INTO any_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Zʋakɔbʋ kɔ hɔ Ezipiti mân nun. Ɛlɔ yɛ̂ ɔ nʋn yɛ́ nan-mɔ bɛ wuli ɔ. ");
INSERT INTO any_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Bɛ nʋn bɛ́ fuin'n kɔ hɔ Sisɛmʋn. Bɛ kɔ sie bɛ́ sɛka'n mɔ Abalahamʋn tolɩ nɩn anun. Sɛka sɔ'n, Abalahamʋn tolɩ yɩ́ Emɔɔ amma'n-mɔ asa nun Sisɛmʋn ɛbɛlɛ. ");
INSERT INTO any_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Kɛmɔ anɩn anɔhʋba'n mɔ Nyanmɩan bɔlɩ Abalahamʋn'n tɛmʋn'n lɛ kpunnge'n, Izalayɛ amma'n-mɔ kɔ li ata bɛ kɔ sʋn dɔʋn dɔʋn kpa Ezipiti mân nɩn anun ɛlɔ. ");
INSERT INTO any_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Ɔ wɔ ɛbɛlɛ dede belemgbin fʋfɔlɛ kɔ tanlan bia nɩn asʋ. Belemgbin sɔ'n, ɔ'a nzɩ man Zozɛfʋ. ");
INSERT INTO any_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Ɔ kɔ laka yɛ́ nan-mɔ ɔ kɔ hele bɛ́ ahʋlʋwa. Ɔ kɔ tinndin bɛ́ maan bɛ kɔ hun bɛ́ mma ngangan'n-mɔ. ");
INSERT INTO any_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","“Mɛlɛ sɔ nɩn anun yɛ̂ bɛ wʋlɩ *Moyizɩ ɔ. Moyizɩ tɩ baa belenzua kanlanman kpa. Nyanmɩan kulo yɩ́ ɛjɔlɛ. Yɩ́ sɩ-mɔ falɩ yɩ́ fɩalɩ bɛ tɩtɩlɩ yɩ́ dede sala nsan. ");
INSERT INTO any_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Mɔ afɩ bɛ nɩan an bɛ ngʋala man yɩ́ fa fɩa kʋ́n'n, bɛ kɔ yɩ yɩ́ bɛ kɔ fite. Falaʋn awa balasua'n kɔ nwun yɩ́, ɔ kɔ fa yɩ́ ɔ kɔ tɩtɩ yɩ́ kɛ yɩ́ muonun yɩ́ kunnun baa. ");
INSERT INTO any_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Bɛ kɔ hehele Moyizɩ Ezipiti mân nɩn anun amanmuo'n kʋalaatin. Moyizɩ kɔ kaci tunminfʋɛ sʋanlan ɛjʋjɔlɛ nun nʋn junman elie nun. ");
INSERT INTO any_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Mɔ Moyizɩ nyanlɩn afʋɛ abulanan'n, cɩan kʋn yɩ́ nwan ɔ 'kɔ a fua yɩ́ nianman Izalayɛ amma'n-mɔ anwʋn. ");
INSERT INTO any_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Ɔ 'nɩan an, anɩn Ezipiti sʋanlan kʋn lɛ kele Izalayɛ amma'n-mɔ anun kun yalɛ. Moyizɩ kɔ le yɩ́ nianman nɩn ati alɔman ɔ kɔ hun Ezipiti sʋanlan'n. ");
INSERT INTO any_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Ɔ jʋnlɩn kɛ anɩn yɩ́ nianman'n-mɔ 'ba tɩ ɛjɔlɛ nɩn abʋ kɛ, ɔ nanndɩ yɩ́ sʋ, Nyanmɩan 'ba le bɛ́ ti. Kanngʋ bɛ ngɔ tɩ man ɛjɔlɛ sɔ nɩn abʋ. ");
INSERT INTO any_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Bɛ lalɩ alɩ́ɛ hɩnlɩn, Moyizɩ 'kɔ a ju a, Izalayɛ amma'n-mɔ anun nnyuan lɛ kʋn ngondin. Ɔ kɔ tila bɛ́. Yɩ́ nwan: ‘Nán bɛ kʋn, nán ɛmɔ tɩ anianman.’ ");
INSERT INTO any_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","“Mɔ Moyizɩ hanlɩn sɔ'n, nunhan'n m'ɔ lɛ bʋ yɩ́ manngʋn'n tua se Moyizɩ kɛ: Nwan sʋanlan dɩɛ y'ɔ falɩ wɔ́ sielɩ yɛ́ sʋ kpain anaan kɛ ɛ búa yɛ́ ndɛɛ ɔ? ");
INSERT INTO any_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Ɛ kulo kɛ ɛ kun mɩ́n kɛ anʋ́nman ɛ hunlin Ezipiti sʋanlan nɩn ɔ? ");
INSERT INTO any_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","“Mɔ Moyizɩ tɩlɩ ɛjɔlɛ sɔ'n, ɔ kɔ nwanndi kɔ hɔ kɔ tanlan Madian mân nun. Ɛlɔ, ɔ kɔ ja bala ɔ nʋn yɩ́ bɛ kɔ wʋ mma mmelenzua nnyuan. ");
INSERT INTO any_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Ɛhɩ anzin afʋɛ abulanan, Moyizɩ kɔ hɔ ɛwâ nun Sinayi bʋka nɩn anwʋn ɛbɛlɛ. Nyanmɩan bɔfʋɛ'n kʋn kɔ yɩ yɩ́ nwʋn kɔ hele yɩ́ sɩ̂n nun baka kʋn asʋ. ");
INSERT INTO any_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","M'ɔ nwunlin like sɔ'n, ɔ kɔ sin yɩ́ nwʋn. Nan kɛmɔ anɩn ɔ lɛ kpunnge baka nɩn anwʋn ɔ nɩan like sɔ'n kpa'n, ɔ 'tie a anɩn yɛ́ Mɩn lɛ kan kɛ: ");
INSERT INTO any_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","N dɩ wɔ́ nan-mɔ Nyanmɩan, Abalahamʋn, Izakɩ nʋn Zʋakɔbʋ Nyanmɩan. Esulo kɔ han Moyizɩ, yɩ́ nwʋn kɔ wʋsʋ yɩ́, afɩ ɔ ngulo man kɛ ɔ nɩan like sɔ'n kʋ́n. ");
INSERT INTO any_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Ɛhɩ a, yɛ́ Mɩn kɔ han kɔ hele yɩ́ kɛ: Moyizɩ, yɩyɩ wɔ́ mgbabʋa'n, ɔ sanlɩn kɛ, lɩka'n mɔ ɛ jin'n tɩ nwannzan-nwannzan. ");
INSERT INTO any_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","M'an nwun yalɛ'n mɔ mɩ́n menian'n-mɔ lɛ di ɔ nʋn ɛkpɩnlɩan mɔ bɛ lɛ kpɩnlɩn wɔ Ezipiti mân nɩn anun ɛlɔ'n. M'an ju asɩ mɩn 'ba le bɛ́ ti. Yɩ́ ti, bala maan n zʋ́an wɔ́ Ezipiti mân nɩn anun ɛlɔ. ");
INSERT INTO any_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“Moyizɩ sɔ'n, Izalayɛ amma'n-mɔ yɩlɩ yɩ́ tʋlɩ. Bɛ́ nwan: Nwan yɛ̂ ɔ sielɩ wɔ́ yɛ́ sʋ kpain anaan kɛ ɛ búa yɛ́ ndɛɛ ɔ? Yɩ́ dein yɛ̂ Nyanmɩan sʋanlɩn yɩ́ bɛ́ nwʋn ɛlɔ kɛ kpain nʋn defʋɛ ɔ. Nyanmɩan bɔfʋɛ'n m'ɔ yɩlɩ yɩ́ nwʋn helelɩ yɩ́ baka nɩn asʋ'n kɔ suan yɩ́. ");
INSERT INTO any_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Moyizɩ yɛ̂ ɔ yɩlɩ bɛ́ fi Ezipiti mân nɩn anun fitelɩ ɔ. Ɔ yɩlɩ asinbɛnwʋn ninnge nʋn atɛlɛ mân sɔ nɩn anun, jenvie kɔkɔlɛ nɩn anʋan nʋn ɛwâ nɩn anun dede afʋɛ abulanan. ");
INSERT INTO any_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","“Moyizɩ kʋnmgba sɔ'n yɛ̂ ɔ hanlɩn helelɩ Izalayɛ amma'n-mɔ kɛ: Nyanmɩan 'ba sʋan kpɔmanfʋɛ kʋn kɛ mɩ́n ɛmɔ anwʋn. Ɔ tɩ ɛmɔ afilie nɩn anun sʋanlan. ");
INSERT INTO any_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","“Mɛlɛ mɔ Izalayɛ amma'n-mɔ yialɩ ɛwâ nɩn anun ɛlɔ'n, Moyizɩ yɛ̂ anɩn ɔ di yɛ́ nan-mɔ nʋn nyanmɩansʋ bɔfʋɛ'n m'ɔ lɛ kan ɛjɔlɛ'n kele yɩ́ Sinayi bʋka nɩn asʋ nɩn asafian ɔ. Yɩ́ yɛ̂ Nyanmɩan falɩ ngʋan ɛjɔlɛ'n wulalɩ yɩ́ sa nun kɛ ɔ fá mán yɛ́ ɔ. ");
INSERT INTO any_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Kʋsʋ yɛ́ nan-mɔ ngɔ man yɩ́ anyɩnnzɔ, bɛ kɔ yɩ yɩ́ bɛ kɔ tʋ, bɛ kulo kɛ ahan bɛ sa bɛ kɔ Ezipiti mân nɩn anun ɛlɔ. ");
INSERT INTO any_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Bɛ kɔ han bɛ kɔ hele Aalʋn kɛ: Bɔ amʋan-mɔ man yɛ́, man bɛ sʋ́a bɛ lí yɛ́ nyunnun. Ɔ sanlɩn kɛ Moyizɩ sɔ'n m'ɔ yɩlɩ yɛ́ fi Ezipiti mân nɩn anun fitelɩ'n, yɛ nzɩ man ɛjɔlɛ mɔ ɔ'a tʋ yɩ́ ɔ. ");
INSERT INTO any_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","“Ɛhɩ a, bɛ kɔ bɔ amʋan kʋn, ɔ tɩ ɛnalɛ baa. Bɛ kɔ yɩ tɛɛ bɛ kɔ man amʋan'n mɔ bɛ́ muonun b'a bɔ'n, bɛ kɔ li yɩ́ nwʋn ndutue. ");
INSERT INTO any_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","“Nan mɔ bɛ yɔlɩ sɔ'n, Nyanmɩan kɔ kaci yɩ́ nzin kɔ si bɛ́. Ɔ kɔ yaci bɛ́ maan bɛ kɔ sɔ anwunno ɛlɔ ninnge'n-mɔ, kɛ b'a kpɩn b'a hɛlɛ wɔ Nyanmɩan mgbɔmanfʋɛ'n-mɔ kalata nɩn anun'n kɛ: Izalayɛ amma, kɛ ɛmɔ gua ɛwâ nɩn anun ɛwa dede mɔ yɩ́ afʋɛ abulanan ahɩ'n, asʋ mɩ́n yɛ̂ ɛmɔ a yɩ tɛɛ b'a man mɩ́n ɔ? ");
INSERT INTO any_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Cɛcɛ, nan mɩ́n yɛ̂ ɛmɔ a yɩ a man mɩ́n ɔ. Nan ɛmɔ a sʋa ɛmɔ amʋan Molɔkɩ tantɩ'n ɔ nʋn ɛmɔ amʋan Elefan nzalama'n mɔ ɛmɔ a yɔ'n, bɛ́ yɛ̂ ɛmɔ a sɔ bɛ́ ɔ. Ɛhɩka ati, mɩn 'fa ɛmɔ mɩn kɔ mʋa m'ɔ tala Babilɔnʋn mân nɩn anzin. ");
INSERT INTO any_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“Ɛwâ nɩn anun ɛlɔ, yɛ́ nan-mɔ 'tu bɛ́ bʋ a, bɛ tu nyɩhyɛ tantɩ nɩn abʋ. Ɛbɛlɛ yɛ̂ anɩn nyɔbʋɛ'n mɔ b'a se b'a hɛlɛ Nyanmɩan mala'n sʋ'n wɔ ɔ. Tantɩ sɔ'n, b'a bɔ yɩ́ kɛ nunhan'n mɔ Nyanmɩan helelɩ Moyizɩ kɛ ɔ nɩ́an sʋ ɔ bɔ́'n. ");
INSERT INTO any_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Yɛ́ nan-mɔ kɔ fa tantɩ'n kɔ wula bɛ́ nzin menian'n-mɔ asa nun. Zozie mɛlɛ sʋ, bɛ le tantɩ sɔ'n dede bɛ kɔ li kunnunmun mân'n mɔ Nyanmɩan fʋanlɩn nun menian'n-mɔ nɩn asʋ. Tantɩ'n halɩ ɛbɛlɛ dede belemgbin *Davidi mɛlɛ sʋ. ");
INSERT INTO any_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","“Nyanmɩan kɔ yɔ Davidi ye. Davidi kɔ sɛlɛ Nyanmɩan atɩn kɛ ɔ 'si sua man Zʋakɔbʋ Nyanmɩan'n. ");
INSERT INTO any_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Nyanmɩan kɔ man yɩ́ atɩn, kʋsʋ yɩ́ wa Salomʋn yɛ̂ ɔ sili Nyanmɩan sua nɩn ɔ. ");
INSERT INTO any_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“Nan Nyanmɩan'n m'ɔ wɔ anwunno'n dɩɛ, nan sua mɔ kulo menian'n-mɔ kɔ si nɩn anun yɛ̂ ɔ da ɔ. Kɛ Nyanmɩan kpɔmanfʋɛ'n hanlɩn yɩ́'n, ɔ hanlɩn kɛ Nyanmɩan nwan: ");
INSERT INTO any_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Mɩ́n bia'n wɔ nyanmɩansʋ, asɩɛ'n tɩ bia mɔ mɩn sesie mɩ́n ja sʋ ɔ. Nzu sua dɩɛ yɛ ɛmɔ kʋala si man mɩ́n ɔ? Lɩka benin yɛ̂ mɩn 'tanlan mɩn de mɩ́n ɛnwʋnmɩan ɔ? ");
INSERT INTO any_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Ninnge ɛhɩ-mɔ kʋalaatin, asʋ nán mɩ́n yɛ̂ m mɔlɩ ɔ? ");
INSERT INTO any_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","“Izalayɛ amma akɔmɩn ketee, akunnun ɛtɛ, anzʋsɛlɛ mma, tɛmʋn biala Wawɛ Nwannzan-nwannzan'n bɩlɩ ɛmɔ a, ɛmɔ mmɩlɩ man. Like mɔ ɛmɔ anan-mɔ yɔlɩ'n yɛ̂ ɛmɔ kʋsʋ lɛ yɔ ɔ. ");
INSERT INTO any_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Nyanmɩan kpɔmanfʋɛ benin yɛ̂ ɛmɔ anan-mɔ a ngele man yɩ́ ahʋlʋwa ɔ? Bɛ́ mɔ bɛ walɩ bɔlɩ sɛsɛfʋɛ kʋnmgba cein nɩn ɛwalɛ nɩn anwʋn ɛjɔlɛ'n, b'a sɔ bɛ́ b'a hun bɛ́. Sɛsɛfʋɛ kʋnmgba cein sɔ'n yɛ̂ kɩkaala ɛmɔ a tʋ yɩ́ ɛsʋan b'a hun yɩ́ nɩn ɔ. ");
INSERT INTO any_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Ɛmɔ mɔ Nyanmɩan nanndɩlɩ nyanmɩansʋ mmɔfʋɛ'n-mɔ asʋ ɔ falɩ mala'n manlɩn ɛmɔ'n, ɛmɔ a nni man mala sɔ nɩn asʋ!” ");
INSERT INTO any_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Mɔ mgbain'n-mɔ tɩlɩ ɛjɔlɛ sɔ'n, bɛ kɔ fɛ Etiɛnɩn anwʋn ɛya kpa bɛ kɔ kɩka bɛ́ nʋan. ");
INSERT INTO any_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Mɔ bɛ 'yɔ ɛhɩ'n, anɩn Wawɛ Nwannzan-nwannzan'n jin Etiɛnɩn anzin. Ɔ kɔ tʋ yɩ́ nyɩn anwunno ɔ kɔ nwun Nyanmɩan anunminnyanmʋn'n, ɔ nʋn Zozi kɛ ɔ jin Nyanmɩan fama sʋ. ");
INSERT INTO any_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Etiɛnɩn kɔ han kɔ hele bɛ́ kɛ: “M'an nwun kɛ anwunno a buke, Mân Baa'n jin Nyanmɩan fama sʋ.” ");
INSERT INTO any_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Mɔ Etiɛnɩn hanlɩn sɔ mɔ bɛ tɩlɩ'n, bɛ kɔ tɛtɩan sɛlɛ kpa, bɛ kɔ totua bɛ́ nzʋ'n. Bɛ́ kʋalaa bɛ kɔ tɩ bɛ kɔ gua Etiɛnɩn sʋ. ");
INSERT INTO any_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Bɛ kɔ hyʋɩn yɩ́ bɛ nʋn yɩ́ kɔ hɔ kulo tiba, bɛ kɔ tʋtʋ yɩ́ ɛbʋɛ bɛ kɔ hun yɩ́. Adanzɩɛ mma'n-mɔ kɔ yɩyɩ bɛ́ taladɩɛ'n-mɔ bɛ kɔ man kpafɛlɛ kʋn kɛ ɔ nɩ́an sʋ. Kpafɛlɛ sɔ'n, bɛ fɛlɛ yɩ́ Sɔlʋ. ");
INSERT INTO any_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Mɛlɛ mɔ menian'n-mɔ 'tʋtʋ Etiɛnɩn ɛbʋɛ'n, anɩn Etiɛnɩn lɛ yɔ asɔnɩn kɛ: “Yɛ́ Mɩn Zozi, de mɩ́n ɛkala'n!” ");
INSERT INTO any_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","M'ɔ hanlɩn sɔ yuelɩ'n, ɔ kɔ kʋtʋ ɔ kɔ tɩan nun sɛlɛ kpa kɛ: “Yɛ́ Mɩn, ɛtɛ ɛhɩ mɔ b'a yɔ'n, yaci ce bɛ́!” Ɔ hanlɩn sɔ ala yɛ̂ ɔ halɩ nun ɔ. ");
INSERT INTO any_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Etiɛnɩn ehuan'n mɔ bɛ hunlin yɩ́'n, Sɔlʋ de tʋ nun. Cɩan sɔ kʋnmgba'n, yɛ̂ Zoluzalɛmʋn asɔnɩn mma'n-mɔ ahʋlʋwa ehele kpili kpa'n bɔlɩ yɩ́ bʋ ɔ. Asɔnɩn mma'n-mɔ kʋalaatin kɔ bɔ asanndɩɛ Zude nʋn Samali mân nɩn anun. Mmɔfʋɛ'n-mɔ ala yɛ̂ bɛ halɩ Zoluzalɛmʋn ɛbɛlɛ ɔ. ");
INSERT INTO any_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Menian mmie-mɔ, bɛ fɛlɩ Nyanmɩan kpa, bɛ kɔ hɔ kɔ fa Etiɛnɩn fuin'n bɛ kɔ yɩ awɔ́lɛ bɛ kɔ hɔ kɔ sie yɩ́. ");
INSERT INTO any_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Sɔlʋ dɩɛ, ɛtɛ mɔ anɩn ɔ lɛ yɔ asɔnɩn mma'n-mɔ'n, ɔ tɩ man nzɛmɩndɛ. Ɔ wʋwʋlʋ awulo'n-mɔ anun, mmelenzua nʋn mmalasua mɔ bɛ de Zozi bɛ di mɔ yɩ́ sa kɔ han bɛ́'n, ɔ cɩ bɛ́ gua bɛ́ fiadɩ. ");
INSERT INTO any_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Bɛ́ mɔ bɛ bɔlɩ asanndɩɛ'n, lɩka mɔ bɛ kɔ sɩn'n, bɛ bɔ Ɛjɔlɛkpa bɛ kele menian'n-mɔ. ");
INSERT INTO any_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Ɛhɩ a, Filipʋ kɔ hɔ Samali mân nɩn anun, bɛ́ kulo kpili nɩn asʋ. Ɔ kɔ han *Kilisi nɩn anwʋn ɛjɔlɛ'n ɔ kɔ hele ɛbɛlɛ menian'n-mɔ. ");
INSERT INTO any_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Mɔ menian'n-mɔ nwunlin kɛ Filipʋ lɛ yɔ asinbɛnwʋn ninnge'n, bɛ́ kʋalaa bɛ kɔ yɔ anzʋɛ bɛ kɔ tie yɩ́ ɛjɔlɛ'n m'ɔ lɛ kan'n kpa. ");
INSERT INTO any_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Afɩ anɩn wawɛ ɛtɛ ɛtɛ dɔʋn kpa fi nwuluwafʋɛ'n-mɔ anun fite. Bɛ 'fite a, anɩn bɛ lɛ tɛtɩan kpa. Bubuluwafʋɛ nʋn bɛ́ mɔ bɛ tia bɛ tɔ sʋ'n dɔʋn kpa kʋsʋ anwʋn kɔ sa. ");
INSERT INTO any_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Kulo sɔ nɩn asʋ menian'n-mɔ kʋalaa kɔ li fɛ kpili kpa. ");
INSERT INTO any_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Ɔ 'ba yɔ sɔ'n, anɩn bian kʋn wɔ kulo sɔ nɩn asʋ ɛbɛlɛ. Bɛ fɛlɛ bian sɔ'n Simʋn. Ɔ yɩ jiliwa ɔ man ɔ sin Samali menian'n-mɔ anwʋn. Ɔ bu yɩ́ nwʋn kɛ ɔ tɩ sʋanlan kpili. ");
INSERT INTO any_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Kulo nɩn asʋ mmatʋnman o, mgbain o, bɛ́ kʋalaa bɛ de yɩ́ bɛ di kpa. Bɛ kan kɛ: “Nyanmɩan tunmin'n, nunhan'n mɔ bɛ fɛlɛ yɩ́ tunmin kpili kpa'n muonun y'ɔ wɔ bian ɛhɩ anun ɔ.” ");
INSERT INTO any_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Menian'n-mɔ de yɩ́ di kpa, ɔ sanlɩn kɛ, ɔ mantanlɩn jiliwa'n yɩ kele bɛ́'n nán ɛnɛ bie ɔ. ");
INSERT INTO any_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Nan mɔ Filipʋ bɔlɩ Nyanmɩan Belemgbin Mân'n nʋn Zozi Kilisi anwʋn ɛjɔlɛ'n helelɩ bɛ́, mɔ bɛ lelɩ bɛ lili'n, bɛ mmelenzua o, bɛ́ mmalasua o, bɛ kɔ man Filipʋ kɔ sɔnɩn bɛ́. ");
INSERT INTO any_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Simʋn muonun kɔ le kɔ li, bɛ kɔ sɔnɩn yɩ́. Ɔ kɔ fa yɩ́ nwʋn kɔ bɔ Filipʋ. Afɩ asinbɛnwʋn ninnge mgbili mgbili'n mɔ Filipʋ lɛ yɔ, ɔ nʋn atɛlɛ'n m'ɔ lɛ yɩ'n, yɩ́ kʋalaa sin Simʋn anwʋn. ");
INSERT INTO any_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Mɔ Samali amma'n-mɔ lelɩ Nyanmɩan Anʋan Ɛjɔlɛ'n lili'n, mmɔfʋɛ'n-mɔ mɔ bɛ halɩ Zoluzalɛmʋn ɛbɛlɛ'n kɔ tɩ ɛjɔlɛ sɔ'n. Ɛhɩ a, bɛ kɔ yɩ́ Pɩɛlɩ nʋn Zʋan kɛ bɛ hɔ́ bɛ́ nwʋn ɛlɔ Samali mân nɩn anun. ");
INSERT INTO any_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Mɔ Pɩɛlɩ nʋn Zʋan juli ɛlɔ'n, bɛ kɔ sɛlɛ Nyanmɩan maan Samali amma'n-mɔ kɔ nyan Wawɛ Nwannzan-nwannzan'n. ");
INSERT INTO any_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Afɩ anɩn b'a sɔnɩn bɛ́ wɔ yɛ́ Mɩn Zozi dunman nun ala, nan bɛ nyanlɩn man Wawɛ Nwannzan-nwannzan'n. ");
INSERT INTO any_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Pɩɛlɩ nʋn Zʋan kɔ fa bɛ́ sa bɛ kɔ sie bɛ́ sʋ maan bɛ kɔ nyan Wawɛ Nwannzan-nwannzan'n. ");
INSERT INTO any_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Mɔ Simʋn nwunlin kɛ mmɔfʋɛ'n-mɔ a fa bɛ́ sa b'a sie menian'n-mɔ sʋ maan b'a nyan Wawɛ Nwannzan-nwannzan'n, ɔ kɔ yɩ esika kɔ man mmɔfʋɛ'n-mɔ. ");
INSERT INTO any_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","Yɩ́ nwan: “Ɛmɔ mán mɩ́n tunmin sɔ'n bie nán sʋanlan mɔ n gɔ fa mɩ́n sa n gɔ sie yɩ́ sʋ nɩn a nyan Wawɛ Nwannzan-nwannzan'n.” ");
INSERT INTO any_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","M'ɔ hanlɩn sɔ'n, Pɩɛlɩ kɔ han kɔ hele yɩ́ kɛ: “Munnzue hán wɔ́ nʋn wɔ́ esika'n. Afɩ ɛ jʋnlɩn kɛ ɛ kʋala esika fa to Nyanmɩan acɛdɩɛ'n! ");
INSERT INTO any_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Yɩ́ ti, ɛ nnyan man bie, ɔ sanlɩn kɛ wɔ́ ajʋnlɩn tɩ ɛtɛ wɔ Nyanmɩan anyunnun. ");
INSERT INTO any_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Kaci wɔ́ ajʋnlɩn ɛtɛ sɔ'n, nán sɛlɛ yɛ́ Mɩn sɛ ɔ kɔ tie kɔ yaci wɔ́ nwʋn sa kɔ hye wɔ́ a. ");
INSERT INTO any_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Afɩ mɩn nwun yɩ́ kɛ wɔ́ ti anun tɩ ɛtɛ sʋnman, ɔ man a kaci ɛtɛ'n kanga.” ");
INSERT INTO any_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Ɛhɩ a, Simʋn kɔ han kɔ hele Pɩɛlɩ nʋn Zʋan kɛ: “Ɛmɔ muonun sɛ́lɛ yɛ́ Mɩn bɛ mán mɩ́n nán ɛjɔlɛ'n mɔ ɛmɔ a han nɩn anzin munnzue a ngan man mɩ́n.” ");
INSERT INTO any_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Mɔ mmɔfʋɛ nnyuan'n lili yɛ́ Mɩn anwʋn adanzɩɛ bɛ hanlɩn yɩ́ nʋan ɛjɔlɛ'n yuelɩ'n, bɛ kɔ sa bɛ kɔ hɔ Zoluzalɛmʋn. Mɔ bɛ 'kɔ'n, bɛ bɔlɩ Ɛjɔlɛkpa'n Samali kulo dɔʋn asʋ bɛ hele menian'n-mɔ. ");
INSERT INTO any_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Ɛlɛhʋn kʋn, yɛ́ Mɩn bɔfʋɛ'n kʋn kɔ han kɔ hele Filipʋ kɛ: “Filipʋ, jasʋ kɔ Ngʋa ɛlɔ, fa atɩn'n m'ɔ fi Zoluzalɛmʋn ɔ tʋlʋ kɔ Gaza'n. Atɩn sɔ'n tɩ fuaan.” ");
INSERT INTO any_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Mɔ nyanmɩansʋ bɔfʋɛ'n hanlɩn sɔ'n, ɛbɛlɛ ala Filipʋ kɔ jasʋ kɔ hɔ. Mɔ ɔ 'kɔ'n, ɔ kɔ nwun bian kʋn. Bian sɔ'n, ɔ fi Etiopi mân nɩn anun. Ɔ tɩ Etiopi mân nɩn asʋ belemgbin balasua'n mɔ bɛ fɛlɛ yɩ́ Kandansɩ nɩn abɩlɩba kpili kpa. Yɩ́ yɛ̂ ɔ nɩan Kandansɩ esika'n kʋalaa asʋ ɔ. Bian sɔ'n, b'a sa yɩ́. Ɔ walɩ Nyanmɩan ɛsʋɛ Zoluzalɛmʋn ");
INSERT INTO any_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","yɛ̂ ɔ lɛ sa kɔ yɩ́ mân nun. Ɔ tɩ yɩ́ hyuili nɩn anun, ɔ lɛ kɩnnga kalata'n mɔ kpɔmanfʋɛ Ezayi hɛlɛlɩ'n. ");
INSERT INTO any_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Wawɛ Nwannzan-nwannzan'n kɔ han kɔ hele Filipʋ kɛ: “Kɔ wɔ́ nyunnun nán cʋɩn mantan hyuili sɔ'n.” ");
INSERT INTO any_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Filipʋ kɔ nwanndi kɔ hyʋɩn kɔ mantan hyuili'n. Ɔ 'tie a, anɩn Etiopi sʋanlan'n lɛ kɩnnga kalata'n mɔ kpɔmanfʋɛ Ezayi hɛlɛlɩ'n. Filipʋ kɔ bisa yɩ́ kɛ: “Asʋ kalata'n mɔ ɛ lɛ kɩnnga'n, ɛ tɩ yɩ́ bʋ ɔ?” ");
INSERT INTO any_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Bian'n kɔ bua Filipʋ kɛ: “Sɛ m'an nnyan man sʋanlan mɔ ɔ 'bʋka mɩ́n an, ɔ 'yɔ sɛ mɔ mɩn 'tɩ yɩ́ bʋ ɔ?” Ɔ kɔ man Filipʋ kɔ fʋ kɔ tanlan yɩ́ nwʋn ɛbɛlɛ hyuili nɩn anun. ");
INSERT INTO any_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Kalata'n lɩka mɔ bian'n lɛ kɩnnga'n, b'a hɛlɛ yɩ́ nun kɛ: Ɔ'a yɔ kɛ bʋa mɔ bɛ nʋn yɩ́ lɛ kɔ bɛ 'kɔ a hun yɩ́ ɔ. Ɔ'a tɔ amunle kɛ bʋa baa'n tɔ amunle bɛ́ mɔ bɛ lɛ tɩtɩ yɩ́ nwʋn enyuan nɩn anyunnun'n. Ɔ'a mmuke man yɩ́ nʋan fɩ́ɩ́ sʋa. ");
INSERT INTO any_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Bɛ gualɩ yɩ́ nyunnun asɩ, b'a mman man yɩ́ dibɩ. Yɩ́ mɛlɛ sʋ menian ati anun ɛtɛ'n-mɔ, nwan yɛ̂ ɔ 'kan bɛ́ nwʋn ɛjɔlɛ ɔ? Afɩ b'a hun yɩ́ b'a yɩ yɩ́ asɩɛ nɩn asʋ. ");
INSERT INTO any_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Bian'n kɔ bisa Filipʋ kɛ: “Mɩn 'sɛlɛ wɔ́, kan kele mɩ́n, nwan anwʋn ɛjɔlɛ dɩɛ yɛ̂ kpɔmanfʋɛ'n lɛ kan yɩ́ sʋa ɔ? Asʋ yɩ́ muonun yɩ́ nwʋn ɛjɔlɛ yɛ́ ɔ lɛ kan anaan sʋanlan fʋfɔlɛ anwʋn ɛjɔlɛ ɔ?” ");
INSERT INTO any_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Ɛhɩ a, Filipʋ kɔ sʋsɔ sʋ, ɔ nanndɩ mɔ b'a hɛlɛ yɩ́ kalata nɩn anun nɩn asʋ, ɔ kɔ bɔ Zozi anwʋn Ɛjɔlɛkpa'n ɔ kɔ hele bian'n. ");
INSERT INTO any_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Kɛmɔ anɩn bɛ́ ja wɔ nun bɛ lɛ kɔ'n, bɛ juli lɩka kʋn, bɛ kɔ tʋ asue. Bian'n kɔ se Filipʋ kɛ: “Ɛ 'nwun nsue, nzu yɛ̂ ɔ jɩjɩ mɔ mɩn ngʋala man sɔnɩn ɔ?”  ");
INSERT INTO any_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Filipʋ kɔ bua yɩ́ kɛ: “Sɛ ɛ de di wɔ́ ahʋnlɩn nɩn anun sakpa a, ɛ kʋala kɛ ɛ sɔnɩn.” Mɔ Filipʋ hanlɩn sɔ'n, bian'n nwan: “Mɩn de mɩn di kɛ Zozi Kilisi tɩ Nyanmɩan Awa.” ");
INSERT INTO any_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Ɛbɛlɛ ala, bian'n kɔ man bɛ kɔ jinlan hyuili'n. Ɔ nʋn Filipʋ bɛ́ munnyuan bɛ fi nun bɛ kɔ ju bɛ kɔ hɔ asue nɩn anun. Filipʋ kɔ sɔnɩn yɩ́. ");
INSERT INTO any_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Nan mɔ bɛ fi asue nɩn anun bɛ fitelɩ'n, yɛ́ Mɩn Wawɛ'n kɔ fa Filipʋ kɔ hɔ. Bian'n ngɔ nwun man Filipʋ fɩ́ɩ́ kʋ́n. Ɔ le fɛ elie ɔ kɔ fa atɩn'n. ");
INSERT INTO any_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Yɛ́ Mɩn Wawɛ'n kɔ fa Filipʋ kʋsʋ, ɔ kɔ hɔ kɔ sie yɩ́ kulo'n mɔ bɛ fɛlɛ yɩ́ Azɔtʋ nɩn asʋ. Ɔ fi ɛbɛlɛ, ɔ kɔ sɩsɩn kulo'n-mɔ kʋalaa asʋ, ɔ kɔ bɔ Ɛjɔlɛkpa'n kɔ hele menian'n-mɔ dede ɔ kɔ fite Sezale kulo nɩn asʋ. ");
INSERT INTO any_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Ɔ 'ba yɔ sɔ'n, anɩn Sɔlʋ tɛ kele yɛ́ Mɩn menian'n-mɔ ahʋlʋwa ɛsɛ bɛ́ ehuan ɛjɔlɛ wɔ yɩ́ ajʋnlɩn nun. Ɛhɩka ati, ɔ kɔ hɔ kɔ tʋ *tɛɛyɩfʋɛ kpain'n. ");
INSERT INTO any_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","Ɔ kɔ sɛlɛ yɩ́ kɛ ɔ mán yɩ́ kalata maan ɔ hɔ́ Damasɩ kulo nɩn asʋ, Zufʋ'n-mɔ asɔnɩn sua'n-mɔ anun. Sɛ ɔ ju ɛlɔ nán ɔ nwun mmelenzua nʋn mmalasua mɔ b'a fa bɛ́ nwʋn b'a man Zozi Kilisi a, anɩn ɔ 'cɩ bɛ́ ɔ nʋn bɛ́ ba Zoluzalɛmʋn. ");
INSERT INTO any_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Tɛɛyɩfʋɛ kpain'n kɔ hɛlɛ kalata'n kɔ man yɩ́, cuein yɛ̂ ɔ hɔlɩ ɔ. Ɔ hɔlɩ dede m'ɔ ka kaan ju Damasɩ kulo nɩn asʋ'n, kʋnmgba ala, like'n fi anwunno, ɔ tɩ kɛ kanlannɩɛ, ɔ kɔ ta yɩ́ nwʋn ɛbɛlɛ. ");
INSERT INTO any_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Sɔlʋ kɔ fin asɩ. Ɔ 'tie a, anɩɛ bie nwan: “Sɔlʋ, Sɔlʋ, nzukɛ ati yɛ̂ ɛ lɛ kele mɩ́n ahʋlʋwa ɔ?” ");
INSERT INTO any_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Sɔlʋ kɔ bisa kɛ: “Wɔ́ nwan ɔ, yɛ́ Mɩn?” Anɩɛ'n kɔ bua yɩ́ kɛ: “Bɛ fɛlɛ mɩ́n Zozi. Mɩ́n yɛ̂ ɛ lɛ kele mɩ́n ahʋlʋwa nɩn ɔ. ");
INSERT INTO any_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Jasʋ kɔ kulo. Ɛ ju ɛlɔ a, bɛ 'ba hele wɔ́ like'n m'ɔ di kɛ ɛ yɔ'n.” ");
INSERT INTO any_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Bɛ́ mɔ anɩn bɛ nʋn Sɔlʋ yɛ̂ bɛ lɛ kɔ'n kɔ tɔ amunle, bɛ kɔ ha ɛbɛlɛ bɛ kɔ jinlan. Bɛ tɩ kɛ sʋanlan'n lɛ jʋjɔ, kʋsʋ bɛ nnwun man yɩ́ nwʋn. ");
INSERT INTO any_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Sɔlʋ fi asɩɛ nɩn anwʋn ɔ kɔ jasʋ. Ɔ kɔ tike yɩ́ nyɩn'n kʋsʋ ɔ ngʋala ɔ nnwun man asɩ. Bɛ kɔ sɔ yɩ́ sa bɛ nʋn yɩ́ kɔ hɔ Damasɩ. ");
INSERT INTO any_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Sɔlʋ lili cɩan nsan anɩn ɔ nwunlin man asɩ. Ɛlɛsan sɔ nɩn anun, Sɔlʋ ngo li like ɛsɛ ɔ ngɔ nʋn man nzue fɩ́ɩ́. ");
INSERT INTO any_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Ɔ 'ba yɔ sɔ'n, anɩn yɛ́ Mɩn sʋanlan'n kʋn wɔ Damasɩ ɛbɛlɛ. Bɛ fɛlɛ sʋanlan sɔ nɩn Ananiasɩ. Yɛ́ Mɩn kɔ yɩ yɩ́ nwʋn kɔ hele yɩ́ ɛlalɩɛ nun. Yɩ́ nwan: “Ananiasɩ!” Ananiasɩ kɔ sulo. Yɩ́ nwan: “Yɛ́ Mɩn, ɛ 'nwun mɩ́n.” ");
INSERT INTO any_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Yɛ́ Mɩn kɔ han kɔ hele yɩ́ kɛ: “Jasʋ, fa gota'n mɔ bɛ fɛlɛ yɩ́ ‘gota fɔ́ʋ́n'n’ kɩkaala, nán kɔ Zudasɩ awulo ɛlɔ. Bisa Sɔlʋ abʋsʋ. Sɔlʋ sɔ'n fi Talɩsɩ kulo nɩn asʋ. Ɔ lɛ sɛlɛ Nyanmɩan dɔɛ ɛhɩ asʋ. ");
INSERT INTO any_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Ɛlalɩɛ nun, Sɔlʋ 'nɩan an, anɩn sʋanlan kʋn, bɛ fɛlɛ yɩ́ Ananiasɩ, ɔ'a wʋlʋ sua nɩn anun. Ɔ'a fa yɩ́ sa ɔ'a sie yɩ́ sʋ ɔ'a man ɔ'a nwun asɩ kɛ yɩ́ daba'n.” ");
INSERT INTO any_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ananiasɩ kɔ bua yɛ́ Mɩn kɛ: “Sʋanlan ɛhɩ ɛtɛ mɔ ɔ'a yɔ wɔ́ menian'n-mɔ mɔ bɛ wɔ Zoluzalɛmʋn ɛlɔ'n, menian dɔʋn kpa a han yɩ́ kʋalaa a hele mɩ́n. ");
INSERT INTO any_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Yɩ́ ɛwalɛ mɔ ɔ'a a ɛwa'n, tɛɛyɩfʋɛ mgbain'n-mɔ a man yɩ́ tunmin kɛ ɔ hyɩ́ bɛ́ kʋalaa mɔ bɛ bɔ wɔ́ dunman kulo ɛhɩka asʋ'n.” ");
INSERT INTO any_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Mɔ Ananiasɩ anʋan tɔlɩ'n, yɛ́ Mɩn kɔ han hɔ hele yɩ́ kɛ: “Kɔ, ɔ sanlɩn kɛ, m'an yɩ sʋanlan sɔ'n kɛ ɔ hɔ́ hán mɩ́n ɛjɔlɛ ɔ héle bɛ́ mɔ bɛ tɩ man Zufʋ'n ɔ nʋn bɛ́ mmelemgbin'n-mɔ, ɔ nʋn Izalayɛ amma'n-mɔ kʋsʋ. ");
INSERT INTO any_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Mɩ́n dunman nɩn anwʋn yalɛ'n kʋalaa mɔ ɔ 'ba nwun yɩ́'n, mɩ́n muonun mɩn 'ba yɩ mɩn kele yɩ́.” ");
INSERT INTO any_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Ɛhɩ a, Ananiasɩ kɔ jasʋ kɔ hɔ kɛ yɛ́ Mɩn hanlɩn helelɩ yɩ́'n. Ɔ kɔ tʋ Sɔlʋ Zudasɩ awulo ɛbɛlɛ. Ɔ kɔ fa yɩ́ sa kɔ sie Sɔlʋ sʋ. Yɩ́ nwan: “Mɩ́n nianman Sɔlʋ, yɛ́ Mɩn Zozi mɔ ɔ'a yɩ yɩ́ nwʋn ɔ'a hele wɔ́ atɩn'n m'ɔ ba Damasɩ ɛwa nɩn asʋ'n, ɔ'a sʋan mɩ́n kɛ m mála maan ɛ nwún asɩ kɛ yɩ́ daba'n, maan Wawɛ Nwannzan-nwannzan'n wʋ́lʋ wɔ́ nun.” ");
INSERT INTO any_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Ɛbɛlɛ ala, like'n tɩ kɛ ejue abʋɩn, ɔ fi Sɔlʋ anyɩn nɩn asʋ ɔ kɔ yɩ kɔ gua. Sɔlʋ kɔ nwun asɩ kɛ yɩ́ daba'n. Ɔ kɔ jasʋ ɔ kɔ man bɛ kɔ sɔnɩn yɩ́. ");
INSERT INTO any_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Mɔ bɛ sɔnɩnlɩn yɩ́ yuelɩ'n, ɔ kɔ li like ɔ kɔ nyan anwʋnsɛlɛ. Sɔlʋ kɔ li ɛlɛnyuan kʋn yɛ́ Mɩn menian'n-mɔ mɔ bɛ wɔ Damasɩ nɩn anwʋn ɛbɛlɛ. ");
INSERT INTO any_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Ɛbɛlɛ ala, Sɔlʋ kɔ hɔ Zufʋ'n-mɔ asɔnɩn sua'n-mɔ anun, ɔ kɔ han kɔ hele menian'n-mɔ kɛ Zozi tɩ Nyanmɩan Awa. ");
INSERT INTO any_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Sɔlʋ ɛjɔlɛ'n kɔ sin bɛ́ kʋalaa bɛ́ nwʋn. Bɛ́ nwan: “Nán sʋanlan ɛhɩ yɛ̂ Zoluzalɛmʋn ɛlɔ, ɔ kele bɛ́ mɔ bɛ bɔ Zozi dunman nɩn ahʋlʋwa kpili nɩn ɔ? Yɩ́ ɛwalɛ mɔ a a ɛwa'n, asʋ ɔ lɛ man njɩ man yɛ́ Mɩn menian'n-mɔ ɔ ngɔ wula man tɛɛyɩfʋɛ mgbain'n-mɔ asa nun ati yɛ̂ ɔ a a ɛwa ɔ?” ");
INSERT INTO any_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Bɛ 'kɩkan ɛhɩ a, anɩn Sɔlʋ lɛ di junman'n tunmin sʋ ɔ kɔ yɩ́ nyunnun cɩan daa. Zufʋ'n-mɔ mɔ bɛ wɔ Damasɩ'n nnwun man ɛjɔlɛ mɔ bɛ kan ɔ. Afɩ Sɔlʋ kele nun maan bɛ nwun yɩ́ kɛ Zozi tɩ *Kilisi, Izalayɛ Belemgbin Ngʋandefʋɛ. ");
INSERT INTO any_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Ɔ wɔ ɛbɛlɛ dede yɩ́ nzin hyɛlɩ kaan. Zufʋ'n-mɔ kɔ hɔ Sɔlʋ ati ahuan kɛ bɛ 'kun yɩ́. ");
INSERT INTO any_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Abie kɔ yɩ Sɔlʋ anzʋti. Sɔlʋ ehuan ati, kɛmɔ anɩn b'a hyɩ Damasɩ kulo nɩn anwʋn'n, Zufʋ'n-mɔ sisa kulo nɩn anwʋn anʋan'n-mɔ kɔngɔɛ nʋn eyua. ");
INSERT INTO any_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Ɛhɩ, cɩan kʋn kɔngɔɛ, bɛ́ mɔ bɛ kulo Sɔlʋ ɛjɔlɛ'n kɔ fa ece kpili kpa. Bɛ kɔ mɩnnda mɩnnda yɩ́ nʋan'n nyanman, bɛ kɔ fa kɔ sɩn mɩnnzɛlɛ kʋn anun. Bɛ kɔ man Sɔlʋ kɔ fʋ nun bɛ kɔ jula yɩ́ talɛ nɩn anzin ɛlɔ bɛ kɔ man ɔ kɔ hɔ. ");
INSERT INTO any_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","M'ɔ yɔlɩ sɔ'n, Sɔlʋ kɔ sa kɔ hɔ Zoluzalɛmʋn. M'ɔ juli ɛbɛlɛ'n, anɩn ɔ kulo kɛ ɔ fa yɩ́ nwʋn ɔ bɔ yɛ́ Mɩn menian'n-mɔ. Nan kʋsʋ anɩn, yɛ́ Mɩn menian'n-mɔ kʋalaatin sulo yɩ́. Ɔ sanlɩn kɛ, menian'n-mɔ nne nni man kɛ Sɔlʋ a kaci yɛ́ Mɩn sʋanlan sakpa. ");
INSERT INTO any_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Ɛhɩ a, Baanabasɩ kɔ fa yɩ́ ɔ nʋn yɩ́ kɔ hɔ mmɔfʋɛ'n-mɔ anwʋn ɛlɔ. Kɛ ɔ kpɩnlɩn yɔlɩ mɔ yɛ́ Mɩn yɩlɩ yɩ́ nwʋn helelɩ Sɔlʋ atɩn nɩn asʋ ɔ hanlɩn ɛjɔlɛ ɔ hele yɩ́'n, anwʋnsɛlɛ mɔ Sɔlʋ nyanlɩn yɩ́ ɔ hanlɩn Zozi anwʋn ɛjɔlɛ'n ɔ helelɩ Damasɩ menian'n-mɔ, Baanabasɩ kɔ sʋsɔ sʋ ɔ kɔ han yɩ́ kʋalaa kɔ hele mmɔfʋɛ'n-mɔ. ");
INSERT INTO any_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Ɔ fi mɛlɛ sɔ'n, yɛ̂ mmɔfʋɛ'n-mɔ falɩ Sɔlʋ bɛ bɔlɩ bɛ́ nwʋn ɔ. Junman kʋalaa mɔ mmɔfʋɛ'n-mɔ 'di wɔ Zoluzalɛmʋn ɛbɛlɛ'n, Sɔlʋ nʋn bɛ́. Ɔ le anwʋnsɛlɛ ɔ bɔ yɛ́ Mɩn dunman nɩn anwʋn ɛjɔlɛ ɔ kele menian'n-mɔ. ");
INSERT INTO any_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Zufʋ'n-mɔ mɔ bɛ kan gɛlɛkɩ anɩɛ'n kulo kɛ bɛ kun Sɔlʋ. Ɔ sanlɩn kɛ ɔ kan yɛ́ Mɩn ɛjɔlɛ'n ɔ kele bɛ́ ɔ nʋn bɛ́ bɛ su yɩ́ bʋsʋ akpʋlʋwa. ");
INSERT INTO any_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Mɔ anianman'n-mɔ tɩlɩ kɛ Zufʋ'n-mɔ lɛ kpʋnndɛ Sɔlʋ bɛ kun yɩ́'n, bɛ kɔ fa yɩ́ bɛ kɔ hɔ Sezale kulo nɩn asʋ. Ɛbɛlɛ, bɛ kɔ man ɔ kɔ hɔ yɩ́ kulo Talɩsɩ. ");
INSERT INTO any_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Ɛhɩ anzin, Zude mân nun o, Galile mân nun o, ɔ nʋn Samali mân anun o, Zufʋ'n-mɔ kɔ yaci yɛ́ Mɩn menian'n-mɔ koun. Asɔnɩn mma'n-mɔ asɩtanlan nɩn anun, bɛ man yɛ́ Mɩn anyɩnnzɔ. Anɩn asɔnɩn'n lɛ jinlan yɩ́ ja nun, ɛsɛ anɩn Wawɛ Nwannzan-nwannzan'n lɛ man ɔ tɛlɛ. ");
INSERT INTO any_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Tɛmʋn sɔ'n, anɩn Pɩɛlɩ nanndɩ nun ɔ lɛ fofua yɛ́ Mɩn menian'n-mɔ mɔ bɛ wɔ kulo kulo'n-mɔ asʋ nɩn anwʋn. Cɩan kʋn, ɔ kɔ hɔ Lida menian dɩɛ'n-mɔ abʋsʋ efua. ");
INSERT INTO any_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Ɔ 'kɔ a ju a, anɩn bian kʋn a bubu ɔ la ɛbɛɛ sʋ, yɩ́ afʋɛ mɔcʋɛ ahɩ. Bian sɔ'n, bɛ fɛlɛ yɩ́ Ene. ");
INSERT INTO any_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Pɩɛlɩ kɔ han kɔ hele yɩ́ kɛ: “Ene, Zozi Kilisi a man wɔ́ nwʋn a sa. Yɩ́ ti, jasʋ nán yɩ wɔ́ ɛbɛɛ'n.” Ɛbɛlɛ ala, Ene kɔ jasʋ. ");
INSERT INTO any_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Mɔ Lida kulo nɩn asʋ menian'n-mɔ nʋn Saalʋn mgbofo nɩn anun dɩɛ'n-mɔ kʋalaa tɩlɩ kɛ Ene anwʋn a sa'n, bɛ kɔ fa bɛ́ nwʋn bɛ kɔ man yɛ́ Mɩn Zozi. ");
INSERT INTO any_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Anɩn balasua kʋn wɔ kulo'n mɔ bɛ fɛlɛ yɩ́ Zope nɩn asʋ. Balasua sɔ'n, bɛ fɛlɛ yɩ́ Tabita. Ɔ tɩ yɛ́ Mɩn Zozi sʋanlan. Gɛlɛkɩ anɩɛ nɩn anun an, anɩn Tabita'n y'ɔ le dunman Dɔlɩkasɩ, yɩ́ bʋ y'ɔ le kɛ ɛnwʋnnzanɩn. Ehianfʋɛ'n-mɔ ɛbʋka ɔ nʋn menian ye ɛyɔlɛ y'ɔ tɩ Dɔlɩkasɩ junman ɔ. ");
INSERT INTO any_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Tɛmʋn sɔ'n, anɩn Dɔlɩkasɩ ndɩ man akpɔlɛ yɛ̂ ɔ wuli ɔ. Mɔ bɛ bialɩ yɩ́ yuelɩ'n, bɛ kɔ la yɩ́ awaa nɩn asʋ dabɛlɛ kʋn anun. ");
INSERT INTO any_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Yɛ́ Mɩn menian'n-mɔ mɔ bɛ wɔ Zope'n kɔ tɩ kɛ Pɩɛlɩ wɔ Lida kulo nɩn asʋ. Lida kʋsʋ nʋn Zope afian a nwa man. Bɛ kɔ sʋan menian nnyuan Pɩɛlɩ anwʋn ɛlɔ kɛ: “Sɛ wɔ́ sa kan yɛ́ ngalɩɛ nɩn an, yɛ 'sɛlɛ wɔ́, bala yɛ́ nwʋn ɛwa ndɛ-ndɛ.” ");
INSERT INTO any_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Pɩɛlɩ tɩlɩ ngalɩɛ nɩn ala, ɔ nʋn bɛ́ bɛ kɔ hɔ. M'ɔ juli ɛlɔ'n, bɛ nʋn yɩ́ kɔ hɔ sua nɩn anun awaa nɩn asʋ ɛlɔ. Kunlannvʋɛ mmalasua'n-mɔ kʋalaatin le esuan bɛ kɔ a yɩ́ nwʋn ɛbɛlɛ. Mɛlɛ mɔ anɩn Dɔlɩkasɩ anyɩn wɔ sʋ'n, taladɩɛ'n-mɔ m'ɔ kpalɩ'n, bɛ kɔ fa bɛ kɔ hele Pɩɛlɩ. ");
INSERT INTO any_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Pɩɛlɩ kɔ man bɛ́ kʋalaa bɛ fi sua nɩn anun bɛ kɔ fite. Ɔ kɔ kʋtʋ ɔ kɔ yɔ asɔnɩn. M'ɔ yɔlɩ asɔnɩn yuelɩ'n, ɔ kɔ kaci yɩ́ nyɩn fuin nɩn anwʋn ɛlɔ, yɩ́ nwan: “Tabita, jasʋ!” Tabita kɔ tike tike yɩ́ nyɩn'n. M'ɔ nwunlin Pɩɛlɩ'n, ɔ kɔ tanlan asɩ. ");
INSERT INTO any_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Pɩɛlɩ kɔ sɔ yɩ́ sa ɔ kɔ bʋka yɩ́ kɔ man ɔ kɔ jasʋ. Ɔ kɔ fɛlɛ yɛ́ Mɩn menian'n-mɔ ɔ nʋn kunlannvʋɛ mmalasua'n-mɔ. Ɔ 'fa Tabita kele bɛ́ a, Tabita a nyɩn wɔ sʋ. ");
INSERT INTO any_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Zope kulo nɩn asʋ ɛbɛlɛ menian'n-mɔ kʋalaa kɔ nwun yɩ́ kɛ Tabita fi ewue nun ɔ'a tinnge. Ɔ man bɛ́ dɔʋn bɛ lelɩ yɛ́ Mɩn bɛ lili. ");
INSERT INTO any_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Pɩɛlɩ hyɛlɩ Zope ɛbɛlɛ kaan kpa. Anɩn ɔ tɩ bian kʋn awulo. Bian sɔ'n, bɛ fɛlɛ yɩ́ Simʋn, ɔ di naan kpolo junman. ");
INSERT INTO any_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Ɛhɩ, anɩn bian kʋn wɔ Sezale kulo nɩn asʋ ɛbɛlɛ. Bian sɔ'n, bɛ fɛlɛ yɩ́ Kɔɔnɛyɩ. Ɔ tɩ *Lɔmʋn kʋan mma'n-mɔ fâ'n mɔ bɛ fɛlɛ yɩ́ “Itali kʋan fâ” nɩn asʋ sahɩnlan. ");
INSERT INTO any_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Ɔ nʋn yɩ́ yɩ nʋn yɩ́ mma, bɛ fɛlɩ Nyanmɩan kpa, ɛsɛ bɛ sʋ yɩ́. Ɔ bʋka Zufʋ ehianfʋɛ'n-mɔ kpa ɛsɛ ɔ yɔ asɔnɩn cɩan daa. ");
INSERT INTO any_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Cɩan kʋn eyua dɔɛ nsan, ɔ kɔ nwun like kʋn kɛ ɛlalɩɛ nun. Ɔ 'nɩan an, anɩn nyanmɩansʋ bɔfʋɛ'n kʋn lɛ wʋlʋ yɩ́ awulo ɛbɛlɛ. Ɔ wʋlʋlɩ a, yɩ́ nwan: “Kɔɔnɛyɩ!” ");
INSERT INTO any_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Esulo kɔ han Kɔɔnɛyɩ, yɩ́ nyɩn tua bɔfʋɛ'n. Ɔ kɔ bisa yɩ́ kɛ: “Yɛ́ Mɩn, nzu ɛjɔlɛ ɔ?” Bɔfʋɛ'n kɔ bua yɩ́ kɛ: “Wɔ́ asɔnɩn ɛyɔlɛ'n nʋn ɛbʋka'n mɔ ɛ bʋka ehianfʋɛ'n-mɔ'n, Nyanmɩan a le a tʋ nun, yɩ́ lʋa a nvi man wɔ́. ");
INSERT INTO any_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Yɩ́ ti, sʋan menian Zope kulo nɩn asʋ ɛlɔ kɩkaala maan bɛ hɔ́ yía bian'n m'ɔ li Simʋn mɔ bɛ fɛlɛ yɩ́ Pɩɛlɩ'n maan ɔ bála. ");
INSERT INTO any_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Ɔ tɩ bian kʋn awulo. Bian sɔ'n, bɛ fɛlɛ yɩ́ Simʋn, ɔ di naan kpolo junman. Yɩ́ awulo'n wɔ jenvie nɩn anʋan.” ");
INSERT INTO any_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Mɔ bɔfʋɛ'n m'ɔ walɩ hanlɩn ɛjɔlɛ'n helelɩ yɩ́'n hɔlɩ'n, Kɔɔnɛyɩ kɔ fɛlɛ yɩ́ ngʋa'n-mɔ anun nnyuan ɔ nʋn nzalafʋ kʋn. Nzalafʋ sɔ'n, ɔ di junman Kɔɔnɛyɩ asa nun. Yɩ́ nyɩn sɔ Nyanmɩan kpa. ");
INSERT INTO any_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Kɔɔnɛyɩ kɔ sʋsɔ ɛjɔlɛ nɩn asʋ ɔ kɔ han yɩ́ kʋalaa kɔ hele bɛ́, yɛ̂ ɔ sʋanlɩn bɛ́ Zope ɔ. ");
INSERT INTO any_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Menian nsan'n la atunnun dede alɩ́ɛ kɔ hɩn. Alɩ́ɛ hɩnlɩn mɔ ɔ 'kɔ sɛnzɛjinlan'n yɛ̂ anɩn bɛ ka kaan bɛ ju Zope ɔ. Tɛmʋn sɔ'n, Pɩɛlɩ kɔ fʋ sua'n mɔ b'a sɛ yɩ́ ti sʋ nɩn asʋ, ɔ 'kɔ a yɔ asɔnɩn. ");
INSERT INTO any_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Ɔ 'ba yɔ sɔ'n, anɩn ɛhɔɛ lɛ kun yɩ́, ɔ lɛ kpʋnndɛ like di. Nan mɛlɛ mɔ bɛ 'tʋn like bɛ man yɩ́'n, ɔ kɔ nwun like kʋn kɛ ɛlalɩɛ nun. ");
INSERT INTO any_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Ɔ 'nɩan an, anɩn anwunno nɩn a buke. Like'n tɩ kɛ tɔbɩlɩ sʋ ɛtanlan kpili kpa. Bɛ lile yɩ́ nʋan nna nɩn anun, ɔ fi anwunno ɔ lɛ ju asɩ. ");
INSERT INTO any_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Naan ngacile ngacile, mɔ bɛ́ ja tɩ nnan, mɔ bɛ cʋɩn bɛ́ nwʋn asɩ nʋn nnʋnman, bɛ́ kʋalaa bɛ wɔ ɛtanlan kpili sɔ nɩn anun. ");
INSERT INTO any_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Anɩɛ kʋn kɔ se Pɩɛlɩ kɛ: “Pɩɛlɩ, jasʋ kun bie di!” ");
INSERT INTO any_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Mɔ Pɩɛlɩ tɩlɩ ɛjɔlɛ sɔ'n, yɩ́ nwan: “Cɛcɛ, yɛ́ Mɩn. Ɔ sanlɩn kɛ, like mɔ a tua yɛ́ kɛ nán yɛ di, ɔ nʋn mɔ efian a gua yɩ́ nwʋn'n, n nnili man bie lé.” ");
INSERT INTO any_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Anɩɛ'n kɔ han kɔ hele yɩ́ biekun kɛ: “Like mɔ Nyanmɩan kɔ han kɛ ɔ tɩ kpa'n, n'ɛ bu yɩ́ kɛ ɔ tɩ man kpa.” ");
INSERT INTO any_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Pɩɛlɩ kɔ nwun like sɔ'n fâ nsan. Yɩ́ fâ nsan nɩn asʋ, like'n kɔ fʋ kɔ hɔ anwunno. ");
INSERT INTO any_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Anɩn Pɩɛlɩ lɛ bisa yɩ́ nwʋn kosuan ɔ tɩ ɛlalɩɛ'n mɔ ɔ'a hɩn nɩn abʋ. Tɛmʋn sɔ'n, anɩn menian'n-mɔ mɔ Kɔɔnɛyɩ sʋanlɩn bɛ́'n kʋsʋ a bisa bisa dede b'a nwun Simʋn awulo'n b'a ju yɩ́ anʋan nun ɛbɛlɛ. ");
INSERT INTO any_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Bɛ kɔ fɛlɛ awulo nɩn anun sʋanlan'n kʋn bɛ kɔ bisa yɩ́ kɛ: “Simʋn mɔ bɛ fɛlɛ yɩ́ Pɩɛlɩ'n, asʋ ɛwa y'ɔ tɩ ɔ?” ");
INSERT INTO any_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Anɩn Pɩɛlɩ tɛ jʋjʋnlɩn ɛlalɩɛ'n m'ɔ hɩnlɩn nɩn anwʋn, Wawɛ Nwannzan-nwannzan'n kɔ han kɔ hele yɩ́ kɛ: “Pɩɛlɩ, nɩan, menian nsan lɛ kpʋnndɛ wɔ́. ");
INSERT INTO any_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Yɩ́ ti, jasʋ nán ɛ nʋn bɛ́ hɔ́ kɩkaala. Ɔ sanlɩn kɛ, mɩ́n yɛ̂ m'an sʋan bɛ́ ɔ.” ");
INSERT INTO any_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Ɛhɩ, Pɩɛlɩ kɔ ju kɔ kpʋ menian sɔ'n-mɔ. Ɔ kɔ han kɔ hele bɛ́ kɛ: “Sʋanlan'n mɔ ɛmɔ lɛ kpʋnndɛ yɩ́'n y'ɔ le mɩ́n. Nan ɛmɔ walɩ nzʋ ɛyɔlɛ?” ");
INSERT INTO any_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Bɛ kɔ bua Pɩɛlɩ kɛ: “Sahɩnlan Kɔɔnɛyɩ yɛ̂ ɔ'a sʋan yɛ́ ɔ. Ɔ tɩ sɛsɛfʋɛ sʋanlan, ɔ sʋ Nyanmɩan. Zufʋ'n-mɔ kʋalaatin kulo yɩ́ ɛjɔlɛ. Nyanmɩansʋ bɔfʋɛ'n kʋn a yɩ yɩ́ nwʋn a hele yɩ́. Bɔfʋɛ'n nwan Kɔɔnɛyɩ mán bɛ fɛ́lɛ wɔ́ nán ɔ tíe ɛjɔlɛ'n mɔ ɛ 'ba han kele yɩ́'n.” ");
INSERT INTO any_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Mɔ Pɩɛlɩ tɩlɩ ngalɩɛ'n, ɔ kɔ man bɛ kɔ wʋlʋ awulo ɔ kɔ sesie bɛ́ dabɛlɛ. Bɛ lalɩ mɔ alɩ́ɛ hɩnlɩn'n, Pɩɛlɩ kɔ jasʋ ɔ nʋn bɛ́ bɛ kɔ hɔ. Mɔ bɛ 'kɔ'n, Zope ɛbɛlɛ anianman'n mmie-mɔ hɔlɩ somanlɩn Pɩɛlɩ. Bɛ la atunnun dede alɩ́ɛ kɔ hɩn. ");
INSERT INTO any_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Alɩ́ɛ hɩnlɩn mɔ bɛ 'ju Sezale'n, anɩn Kɔɔnɛyɩ nʋn yɩ́ nwʋn amma nʋn yɩ́ manngʋn'n-mɔ m'ɔ tʋlɩ yɩ́ sa fɛlɛlɩ bɛ́'n, bɛ lɛ nwʋnndɛ bɛ́. ");
INSERT INTO any_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Mɔ Pɩɛlɩ 'ju ɛbɛlɛ'n, Kɔɔnɛyɩ kɔ jasʋ ɔ kɔ hɔ kɔ kpa yɩ́ atɩn. Ɔ kɔ tu kɔ tɔ Pɩɛlɩ aja nun ɔ kɔ bɛlɛ yɩ́ nwʋn asɩ ɔ kɔ sʋ yɩ́. ");
INSERT INTO any_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Pɩɛlɩ kɔ jasʋ yɩ́ ɔ kɔ han kɔ hele yɩ́ kɛ: “Jasʋ, n'ɛ sʋ mɩ́n, nán mɩ́n kʋsʋ, n dɩ kulo sʋanlan kɛ wɔ́.” ");
INSERT INTO any_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","M'ɔ hanlɩn sɔ yuelɩ'n, ɔ nʋn Kɔɔnɛyɩ bɛ le ɛjʋjɔlɛ dede bɛ kɔ wʋlʋ awulo. Ɔ 'ju ɛbɛlɛ a, menian dɔʋn kpa a yia. ");
INSERT INTO any_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Pɩɛlɩ kɔ han kɔ hele bɛ́ kɛ: “Ɛmɔ sɩ kɛ Zufʋ'n-mɔ mala'n mman man yɛ́ atɩn kɛ yɛ nʋn bɛ́ mɔ bɛ tɩ man Zufʋ'n sán nun ɛsɛ yɛ wʋ́lʋ bɛ́ awulo. Nan mɩ́n dɩɛ, Nyanmɩan a hele mɩ́n kɛ n nne man atɩn mɩn mmun man sʋanlan'n bie nvuin mɔ bɛ ngɔ man yɩ́ nwʋn, bie kpa mɔ bɛ kɔ yɩ́ nwʋn ɔ. ");
INSERT INTO any_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Ɛhɩka ati, kɛ ɛmɔ fɛlɛlɩ mɩ́n nɩn ala, m'an njʋnlɩn man ɛjɔlɛ ngacile fɩ́ɩ́, m'an a a. Afɩ Like'n mɔ yɩ́ ti yɛ̂ ɛmɔ a fɛlɛ mɩ́n'n, ɛmɔ hán maan n dɩ́.” ");
INSERT INTO any_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Kɔɔnɛyɩ nwan: “Ɛnɛ tɩ cɩan nsan, bɛ bɔlɩ dɔɛ nsan mɔ bɛ 'fa bɛ yɔ asɔnɩn'n, anɩn n wɔ mɩ́n awulo mɩɩn yɔ asɔnɩn. Ɛbɛlɛ ala, sʋanlan kʋn kɔ yɩ yɩ́ nwʋn kɔ hele mɩ́n. Sʋanlan sɔ'n wula taladɩɛ fufue hyɩɛɩn hyɩɛɩn. ");
INSERT INTO any_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Yɩ́ nwan: ‘Kɔɔnɛyɩ, Nyanmɩan a tie wɔ́ asɔnɩn ɛyɔlɛ'n, ɛsɛ yɩ́ lʋa a nvi man ɛbʋka'n mɔ ɛ bʋka ehianfʋɛ'n-mɔ'n. ");
INSERT INTO any_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Yɩ́ ti, sʋan menian Zope maan bɛ hɔ́ yía Simʋn mɔ bɛ fɛlɛ yɩ́ Pɩɛlɩ'n bála. Ɔ tɩ Simʋn m'ɔ di naan kpolo junman nɩn awulo. Awulo sɔ'n wɔ jenvie nɩn anʋan ɛlɔ.’ ");
INSERT INTO any_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Ɛbɛlɛ ala, n gɔ yɩ menian kɛ bɛ hɔ́ yía wɔ́. Mʋafʋɛ a a. Kɩkaala dɩɛ mɔ yɛ́ kʋalaa y'a yia ɛwa'n, Nyanmɩan anyunnun, ɛjɔlɛ mɔ yɛ́ Mɩn a fa a wula wɔ́ nʋan'n, kan nán yɛ lɛ tie.” ");
INSERT INTO any_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Ɛhɩ a, Pɩɛlɩ kɔ jasʋ kɔ sʋsɔ ɛjɔlɛ sʋ. Yɩ́ nwan: “Sian dɩɛ, m'an nwun yɩ́ yuein kɛ Nyanmɩan mgba man menian'n-mɔ nun. ");
INSERT INTO any_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Sʋanlan bia ala m'ɔ fi mân ngacile anun m'ɔ fɛlɩ Nyanmɩan, m'ɔ bu mân sɛsɛ'n, Nyanmɩan kulo yɩ́ ɛjɔlɛ. ");
INSERT INTO any_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Nyanmɩan m'ɔ tɩ kulo menian'n-mɔ Amɩn'n, ɔ nanndɩ Zozi Kilisi asʋ ɔ'a bɔ Ɛjɔlɛkpa'n m'ɔ man alʋacɩcɩɛ'n ɔ'a hele Izalayɛ amma'n-mɔ. ");
INSERT INTO any_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Ɛmɔ sɩ ɛjɔlɛ'n m'ɔ walɩ'n, ɔ nʋn kɛ ɔ kpɩnlɩn yɔlɩ mɔ Ɛjɔlɛkpa ɛhɩ a tʋ a sanndɩ Zude mân nɩn anun'n. Galile mân nɩn anun yɛ̂ yɩ́ kʋalaa lili mʋan bɔlɩ yɩ́ bʋ ɔ, mɛlɛ mɔ anɩn Zʋan lɛ fɛfɛlɛ menian'n-mɔ kɛ bɛ bála maan ɔ sɔ́nɩn bɛ́'n. ");
INSERT INTO any_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Ɛmɔ sɩ kɛ Nyanmɩan falɩ Wawɛ Nwannzan-nwannzan'n ɔ nʋn tunmin ɔ manlɩn Zozi m'ɔ fi Nazalɛtɩ'n. Zozi kɔ kulo'n-mɔ asʋ. Ɔ yɔ menian'n-mɔ ye, ɔ man bɛ́ kʋalaa mɔ bɛ wɔ Abɔnsanmʋn asa abʋ nɩn anwʋn sa. Ɔ sanlɩn kɛ, anɩn Nyanmɩan li yɩ́ nzin. ");
INSERT INTO any_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","“Junman'n kʋalaa mɔ ɔ'a li yɩ́ Zufʋ'n-mɔ mân nɩn anun nʋn Zoluzalɛmʋn kulo nɩn asʋ'n, yɛ di yɩ́ nwʋn adanzɩɛ. B'a bʋbɔ yɩ́ kʋlʋwa sʋ b'a hun yɩ́. ");
INSERT INTO any_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Nan yɩ́ cɩan nsan nɩn asʋ, Nyanmɩan man ɔ fi ewue nun ɔ a tinnge. Nyanmɩan a man ɔ'a yɩ yɩ́ nwʋn ɔ'a hele. ");
INSERT INTO any_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Nyanmɩan a man ɔ'a nyɩ man yɩ́ nwʋn ɔ'a ngele man bagua'n. Nan ɔ'a man ɔ'a yɩ yɩ́ nwʋn ɔ'a hele yɛ́ mɔ ɔ lili mʋa falɩ yɛ́ kɛ adanzɩɛ'n. Mɔ Nyanmɩan man ɔ fi ewue nun tinngelɩ'n, yɛ nʋn yɩ́ a tʋ asa. ");
INSERT INTO any_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Ɔ a han ɔ'a hele yɛ́ kɛ yɛ bɔ́ Ɛjɔlɛkpa'n yɛ héle menian'n-mɔ, ɛsɛ yɛ lí adanzɩɛ kɛ yɩ́ Zozi yɛ̂ Nyanmɩan a sie yɩ́ ngʋan mma nʋn ewue mma ndɛɛbuafʋɛ ɔ. ");
INSERT INTO any_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Mgbɔmanfʋɛ'n-mɔ kʋalaa hanlɩn yɩ́ ɛjɔlɛ kɛ, sʋanlan biala m'ɔ kɔ le yɩ́ kɔ li'n, yɩ́ dunman nun, sʋanlan sɔ'n nyan ɛtɛ face.” ");
INSERT INTO any_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Anɩn Pɩɛlɩ anʋan wɔ sʋ ɔ tɛ kan ɛjɔlɛ'n, Wawɛ Nwannzan-nwannzan'n kɔ a kɔ wʋlʋ bɛ́ kʋalaa mɔ bɛ lɛ tie ɛjɔlɛ'n mɔ Pɩɛlɩ lɛ kan nɩn anun. ");
INSERT INTO any_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Ɛjɔlɛ'n kɔ sin Zufʋ'n-mɔ mɔ b'a fa bɛ́ nwʋn b'a man yɛ́ Mɩn mɔ bɛ walɩ sɔmanlɩn Pɩɛlɩ nɩn anwʋn. Ɔ sanlɩn kɛ Nyanmɩan a fa yɩ́ Wawɛ Nwannzan-nwannzan nɩn a man bɛ́ mɔ bɛ tɩ man Zufʋ'n kʋsʋ. ");
INSERT INTO any_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Afɩ bɛ 'tie a, anɩn menian sɔ'n-mɔ lɛ kan anɩɛ ngacile ngacile bɛ yɩ Nyanmɩan Kpili ayɛ. Ɛhɩ a, Pɩɛlɩ nwan: ");
INSERT INTO any_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Menian ɛhɩ-mɔ mɔ b'a nyan Wawɛ Nwannzan-nwannzan'n kɛ yɛ́'n, asʋ sʋanlan kʋala totua bɛ́ kɛ nán bɛ sɔnɩn ɔ?” ");
INSERT INTO any_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Pɩɛlɩ kɔ man atɩn kɛ bɛ sɔ́nɩn bɛ́ wɔ Zozi Kilisi dunman nun. Mɔ bɛ sɔnɩnlɩn bɛ́ yuelɩ'n, bɛ kɔ sɛlɛ Pɩɛlɩ kɛ ɔ lí kɔ yɔ ɛlɛnyuan kʋn bɛ́ nwʋn ɛbɛlɛ. ");
INSERT INTO any_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","M'ɔ yɔlɩ sɔ'n, mmɔfʋɛ'n-mɔ nʋn anianman'n-mɔ mɔ bɛ wɔ Zude mân nɩn anun'n kɔ tɩ kɛ bɛ́ mɔ bɛ tɩ man Zufʋ'n, bɛ́ kʋsʋ b'a le Nyanmɩan Anʋan Ɛjɔlɛ'n b'a li. ");
INSERT INTO any_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Nan mɔ Pɩɛlɩ salɩ walɩ Zoluzalɛmʋn'n, Zufʋ'n-mɔ mɔ b'a fa bɛ́ nwʋn b'a man yɛ́ Mɩn'n kɔ tu yɩ́ nyunnun. ");
INSERT INTO any_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","Bɛ́ nwan: “A wʋlʋ menian mɔ bɛ tɩ man Zufʋ nɩn awulo, ɛsɛ ɛ nʋn bɛ́ a didi!” ");
INSERT INTO any_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Ɛhɩ a, Pɩɛlɩ kɔ sʋsɔ ɛjɔlɛ sʋ ɔ kɔ hehele bɛ́ nun kɛ ɛjɔlɛ'n kpɩnlɩn yɔlɩ'n. Yɩ́ nwan: ");
INSERT INTO any_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Anɩn n wɔ Zope kulo nɩn asʋ ɛbɛlɛ. Ɛlɛhʋn kʋn, mɛlɛ mɔ mɩn 'yɔ asɔnɩn'n, n gɔ nwun like kʋn kɛ ɛlalɩɛ nun. Like'n mɔ n nwunlin yɩ'n tɩ kɛ tɔbɩlɩ sʋ ɛtanlan kpili kpa. Bɛ lile yɩ́ nʋan nnan nɩn anun, ɔ fi anwunno anɩn ɔ lɛ ju ba mɩ́n nwʋn ɛbɛlɛ. ");
INSERT INTO any_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Mɩn 'nɩan ɛtanlan nɩn anun an, n gɔ nwun naan ngacile ngacile'n-mɔ kʋalaatin m'ɔ tɩ yɛ́ cilie'n. Bɛ́ mɔ bɛ́ ja tɩ nnan, bɛ́ mɔ bɛ cʋɩn bɛ́ nwʋn asɩ ɔ nʋn nnʋnman'n-mɔ. ");
INSERT INTO any_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Mɩn 'tie a, anɩn anɩɛ kʋn lɛ kan kele mɩ́n kɛ: ‘Pɩɛlɩ, jasʋ kun bie di!’ ");
INSERT INTO any_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","“Mɔ n dɩlɩ yɩ́ sɔ'n, nán m'an se kɛ: ‘Cɛcɛ, yɛ́ Mɩn! Ɔ sanlɩn kɛ like mɔ a tua kɛ nán yɛ di anaan efian a gua yɩ́ nwʋn'n, n nili man bie lé.’ ");
INSERT INTO any_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","“Ɛsɛ anɩɛ'n fi anwunno ɔ kɔ te biekun. Yɩ́ nwan: ‘Like mɔ Nyanmɩan nwan ɔ tɩ kpa'n, n'ɛ bu yɩ́ kɛ ɔ tɩ man kpa.’ ");
INSERT INTO any_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Like'n kɔ yɔ sɔ dede fâ nsan yɛ̂ ɔ salɩ fʋlɩ anwunno ɔ. ");
INSERT INTO any_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","“Tɛmʋn sɔ kʋnmgba'n, menian nsan kɔ a kɔ jinlan awulo'n mɔ anɩn n wɔ nun ɛbɛlɛ nɩn anʋan nun. Bɛ fi Sezale. B'a sʋan bɛ́ kɛ b'a a yia mɩ́n. ");
INSERT INTO any_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Wawɛ Nwannzan-nwannzan'n kɔ han kɔ hele mɩ́n kɛ nán man mɩn hyʋhyʋɩn mɩ́n bʋ asɩ, nán mɩn nʋn bɛ́ hɔ́. Anianman nsian ɛhɩ mɔ ɛmɔ nwun bɛ́ ɛwa'n, bɛ hɔlɩ somanlɩn mɩ́n Sezale. Mɩn nʋn bɛ́ yɛ̂ yɛ wʋlʋlɩ bian nɩn awulo nɩn anun ɔ. ");
INSERT INTO any_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Mɔ yɛ wʋlʋlɩ yɩ́ awulo nɩn anun'n, Kɔɔnɛyɩ kɔ han kɛ ɔ kpɩnlɩn yɔlɩ mɔ nyanmɩansʋ bɔfʋɛ kʋn yɩlɩ yɩ́ nwʋn helelɩ yɩ́ yɩ́ sua nɩn anun. Bɔfʋɛ sɔ'n hanlɩn helelɩ yɩ́ kɛ: ‘Yɩ sʋanlan maan ɔ hɔ́ yía Simʋn mɔ bɛ fɛlɛ yɩ́ Pɩɛlɩ Zope ɛlɔ bála. ");
INSERT INTO any_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Ɛjɔlɛ mɔ ɛ nʋn wɔ́ afilie'n, ɛmɔ tie a, bɛ 'nyan bɛ́ ti'n, ɔ 'ba han kele wɔ́.’ ");
INSERT INTO any_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","“N juli ɛbɛlɛ mɔ mɩn 'kan ɛjɔlɛ nɩn ala, bɛ kɔ nyan Wawɛ Nwannzan-nwannzan'n kɛ yɛ́ kʋsʋ yɛ nyanlɩn yɩ́ ngɛlɛmɔ nun'n. ");
INSERT INTO any_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","M'ɔ yɔlɩ sɔ'n, nán mɩ́n ti a kacɩ ɛjɔlɛ'n mɔ yɛ́ Mɩn hanlɩn'n. Yɩ́ nwan: ‘Zʋan a sɔnɩn menian'n-mɔ asue nun, nán ɛmɔ dɩɛ, Nyanmɩan Wawɛ Nwannzan-nwannzan'n yɛ̂ bɛ 'fa bɛ sɔnɩn ɛmɔ ɔ.’ ");
INSERT INTO any_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Acɛdɩɛ'n mɔ Nyanmɩan a fa a man yɛ́ mɔ y'a le yɛ́ Mɩn Zozi Kilisi y'a li'n, acɛdɩɛ kʋnmgba sɔ'n yɛ̂ ɔ'a fa ɔ'a man bɛ́ kʋsʋ bɛ́ ɔ. Anɩn n dɩ mɩ́n dɩɛ sɛ mɔ mɩn nʋn Nyanmɩan yɛ 'cʋɩn yɩ́ bʋsʋ mannzʋan ɔ?” ");
INSERT INTO any_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Mɔ bɛ tɩlɩ ɛjɔlɛ'n sʋa'n, bɛ kɔ muan bɛ́ nʋan bɛ kɔ yɩ Nyanmɩan ayɛ. Bɛ́ nwan: “Ɔ tɩ ananhɔlɛ, Nyanmɩan a man bɛ́ mɔ bɛ tɩ man Zufʋ'n kʋsʋ atɩn kɛ bɛ káci bɛ́ abalabɔ'n bɛ fá bɛ́ nwʋn bɛ mán yɩ́ bɛ nyán ngʋan.” ");
INSERT INTO any_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Ɛhɩ, mɛlɛ mɔ bɛ 'kele yɛ́ Mɩn menian'n-mɔ ahʋlʋwa mɔ bɛ hunlin Etiɛnɩn'n, asɔnɩn mma'n-mɔ bɔlɩ asanndɩɛ. Mmie-mɔ bɔlɩ bɛ́ ti Feninsi nʋn Sipʋlʋ mân nun. Mmie-mɔ kʋsʋ hɔlɩ kulo'n mɔ bɛ fɛlɛ yɩ́ Antiɔsʋ nɩn asʋ. Zufʋ'n-mɔ ala yɛ̂ anɩn bɛ kan Nyanmɩan Anʋan Ɛjɔlɛ'n bɛ kele bɛ́ ɔ. ");
INSERT INTO any_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Nan kʋsʋ, yɛ́ Mɩn menian'n mmie-mɔ fi Sipʋlʋ nʋn Silɛnɩn bɛ kɔ hɔ Antiɔsʋ. Mɔ bɛ juli ɛbɛlɛ'n, bɛ kɔ bɔ yɛ́ Mɩn Zozi Ɛjɔlɛkpa'n bɛ kɔ hele bɛ́ mɔ bɛ tɩ man Zufʋ'n. ");
INSERT INTO any_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Yɛ́ Mɩn kɔ fa yɩ́ sa kpa'n kɔ sie bɛ́ sʋ. Menian dɔʋn kpa kɔ le Ɛjɔlɛkpa'n bɔ kɔ li bɛ kɔ fa bɛ́ nwʋn bɛ kɔ man yɛ́ Mɩn. ");
INSERT INTO any_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Mɔ Zoluzalɛmʋn asɔnɩn nɩn anun menian'n-mɔ tɩlɩ ɛjɔlɛ sɔ'n, bɛ kɔ sʋan Baanabasɩ Antiɔsʋ ɛlɔ. ");
INSERT INTO any_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Baanabasɩ hɔlɩ juli ɛlɔ m'ɔ nwunlin junman'n mɔ Nyanmɩan a li yɩ́ ɛbɛlɛ'n, ɔ lili yɩ́ nwʋn fɛ. Ɔ kɔ wowula anianman'n-mɔ kʋalaa anwʋnsɛlɛ kɛ bɛ fá bɛ́ ahʋnlɩn'n kʋalaatin bɛ sʋ́ yɛ́ Mɩn. ");
INSERT INTO any_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Baanabasɩ tɩ sʋanlan kpa, ɔ le dedi ɛsɛ Wawɛ Nwannzan-nwannzan'n wɔ yɩ́ nun kpa. Ɛhɩ ati, menian dɔʋn kpa falɩ bɛ́ nwʋn bɛ manlɩn yɛ́ Mɩn. ");
INSERT INTO any_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Ɛhɩ anzin, Baanabasɩ hɔlɩ Sɔlʋ ɛfa Talɩsɩ. ");
INSERT INTO any_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","M'ɔ tʋlɩ Sɔlʋ'n, ɔ nʋn yɩ́ kɔ a Antiɔsʋ bɛ kɔ li ɛbɛlɛ afʋɛ kɔkɔlɛ kʋn, bɛ kɔ li junman asɔnɩn sɔ nɩn anun. Bɛ kɔ hehele menian dɔʋn kpa ninnge. Antiɔsʋ ɛbɛlɛ yɛ̂ bɛ lili mʋa bɛ fɛlɛlɩ yɛ́ Mɩn menian'n-mɔ “Kilisi amma” ɔ. ");
INSERT INTO any_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Tɛmʋn sɔ'n, yɛ́ Mɩn mgbɔmanfʋɛ mmie-mɔ fi Zoluzalɛmʋn bɛ kɔ a Antiɔsʋ. ");
INSERT INTO any_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Mgbɔmanfʋɛ sɔ'n, bɛ́ nunhan kʋn li Agabisi. Agabisi kɔ jasʋ, Wawɛ Nwannzan-nwannzan'n kɔ man ɔ kɔ han kɛ ɔ ngɔ hyɛ man, ɛhɔɛ kpili kpa 'ba kpɩn asɩɛ'n lɩka kʋalaatin. Ɛjɔlɛ sɔ'n kpɩnlɩn sʋ mɛlɛ mɔ anɩn Kulodʋ tɩ *Lɔmʋn belemgbin kpain'n. ");
INSERT INTO any_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Mɔ yɛ́ Mɩn menian'n-mɔ tɩlɩ ɛjɔlɛ sɔ'n bɛ fualɩ kɛ sʋanlan kʋn biala like mɔ yɩ́ sa kɔ tʋ yɩ́'n, ɔ fá bála maan bɛ fá bɛ nwán anianman'n-mɔ mɔ bɛ wɔ Zude mân nɩn anun ɛlɔ'n. ");
INSERT INTO any_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Bɛ kɔ yɔ yɩ́ sɔ sakpa. Bɛ kɔ yɩ Baanabasɩ nʋn Sɔlʋ kɛ bɛ fá acɛdɩɛ sɔ'n-mɔ, bɛ hɔ́ fá mán Zude mân nɩn anun ɛlɔ asɔnɩn nɩn asʋ mgbain'n-mɔ. ");
INSERT INTO any_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Ɛhɩ, mɛlɛ mɔ Baanabasɩ nʋn Sɔlʋ bɛ juli Zoluzalɛmʋn ɛbɛlɛ'n, belemgbin *Elɔdɩ kɔ bɔ yɩ́ bʋ ɔ kɔ hele asɔnɩn mma'n mmie-mɔ ahʋlʋwa. ");
INSERT INTO any_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Ɔ kɔ man bɛ kɔ fa dadɩɛ bɛ kɔ hun Zʋan anianman bian Zʋakɩ. ");
INSERT INTO any_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Kɛmɔ Elɔdɩ nɩan an, yɩ́ nyɔlɩɛ sɔ'n yɔ Zufʋ'n-mɔ ɛnyɩnmɩn'n, ɔ kɔ man bɛ kɔ hyɩ Pɩɛlɩ. Zufʋ'n-mɔ fɛtɩ'n mɔ bɛ 'di a, bɛ nni man kpaʋn'n mɔ fali ayile wɔ nun'n tɛmʋn sɔ'n yɛ̂ bɛ hyɩlɩ yɩ́ ɔ. ");
INSERT INTO any_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Mɔ bɛ hyɩlɩ Pɩɛlɩ yuelɩ'n, Elɔdɩ kɔ man bɛ kɔ tʋ yɩ́ fiadɩ. Ɔ kɔ fa yɩ́ kɔ wula nzalafʋ fatule nnan asa nun. Fatule kʋn biala, nzalafʋ nnan yɛ̂ bɛ wɔ nun ɔ. Anɩn Elɔdɩ lɛ nwʋnndɛ kɛ bɛ di Pakɩ fɛtɩ'n yue a, yɛ̂ ɔ 'fa Pɩɛlɩ fite bagua nɩn anyunnun ɔ bua yɩ́ ndɛɛ ɔ. ");
INSERT INTO any_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Anɩn Pɩɛlɩ la fiadɩ sua nɩn anun, nan asɔnɩn mma'n-mɔ kɔ sɛlɛ Pɩɛlɩ ati nzɛlɛ m'ɔ sʋ ɛbʋɛ. ");
INSERT INTO any_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Ɔ 'ba yɔ sɔ'n, alɩ́ɛ cɩn an, anɩn Elɔdɩ lɛ bua Pɩɛlɩ ndɛɛ. Bɛ kɔ fa ngɔnzɔngɔnzɔ nnyuan bɛ kɔ cɩcɩ Pɩɛlɩ, ɔ la nzalafʋ nnyuan afian ɔ lɛ dafɩ. Nzalafʋɛ'n-mɔ mɔ bɛ sisa fiadɩ sua'n jijin anʋan nɩn anyunnun ɛbɛlɛ. ");
INSERT INTO any_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Ɛbɛlɛ ala, yɛ̂ Mɩn bɔfʋɛ'n kʋn kɔ fite. Lɩka mɔ Pɩɛlɩ la'n kɔ ta yuein kɛ kanlannɩɛ. Nyanmɩansʋ bɔfʋɛ'n kɔ kpusu kpusu Pɩɛlɩ ɔ kɔ tinnge yɩ́. Yɩ́ nwan: “Pɩɛlɩ, kan wɔ́ nwʋn jasʋ!” Yɩ́ sa ngɔnzɔngɔnzɔ'n-mɔ kɔ foti kɔ gua. ");
INSERT INTO any_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Bɔfʋɛ'n nwan: “Fa wɔ́ bɛlɛtɩ'n cɩ wɔ́ nwʋn sʋ nán wowula wɔ́ mgbabʋa'n.” Pɩɛlɩ kɔ jasʋ ɔ kɔ fa yɩ́ bɛlɛtɩ'n kɔ hyɩ yɩ́ nwʋn sʋ ɔ kɔ wowula yɩ́ mgbabʋa'n. Bɔfʋɛ'n nwan: “Wula wɔ́ taladɩɛ kpili'n nán si mɩ́n sʋ.” ");
INSERT INTO any_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Pɩɛlɩ si bɔfʋɛ'n sʋ ɔ fi fiadɩ sua nɩn anun ɔ kɔ fite. Yɩ́ ajʋnlɩn nun an, anɩn ɛlalɩɛ yɛ̂ ɔ lɛ cɩn ɔ. Afɩ ɔ nwunlin man nun kɛ bɔfʋɛ'n yɛ̂ ɔ lɛ di junman sɔ'n sakpa ɔ. ");
INSERT INTO any_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Ɔ nʋn bɔfʋɛ'n, bɛ kɔ san alimʋa nzalafʋ fatule nɩn anwʋn, bɛ kɔ san m'ɔ tian yɩ́ nnyuan'n kʋsʋ anwʋn. Bɛ kɔ tʋ bulalɛ anʋan'n mɔ bɛ tʋ yɩ́ a, anɩn bɛ lɛ wʋlʋ kulo nɩn anun'n. Anʋan sɔ nɩn angʋnmɩn kɔ tike bɛ́ nyunnun ɛbɛlɛ. Bɛ kɔ fite. Bɛ kɔ sɩn gota kʋn asʋ, bɔfʋɛ'n kɔ yaci Pɩɛlɩ ɛbɛlɛ ɔ kɔ nwannyan. ");
INSERT INTO any_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Afɩ m'ɔ yɔlɩ sɔ'n, bɛlɛ mɔ Pɩɛlɩ a nwun nun ɔ. Yɩ́ nwan: “Sɩan dɩɛ, m'an nwun yɩ́ yuein. Yɛ́ Mɩn a sʋan yɩ́ bɔfʋɛ'n kɛ ɔ bála a le mɩ́n fi Elɔdɩ asa nun ɔ nʋn ɛtɛ'n kʋalaa mɔ Zufʋ'n-mɔ susu mɩ́n'n.” ");
INSERT INTO any_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","M'ɔ jʋnlɩnlɩn dede m'ɔ tɩlɩ ɛjɔlɛ nɩn abʋ'n, ɔ kɔ bɔ yɩ́ ti Zʋan mɔ bɛ fɛlɛ yɩ́ Maakɩ nɩn anin Mali awulo ɛlɔ. Ɔ 'kɔ a ju a, menian dɔʋn kpa a yia ɛbɛlɛ bɛ lɛ yɔ asɔnɩn. ");
INSERT INTO any_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Pɩɛlɩ kɔ bɔ anʋan'n. Afanɩan balasua kʋn, bɛ fɛlɛ yɩ́ Lodɩ, ɔ kɔ hɔ anʋan nɩn etike. ");
INSERT INTO any_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Mɔ Lodɩ tɩlɩ Pɩɛlɩ anɩn'n, ɔ kɔ li yɩ́ nwʋn fɛ nan kʋsʋ ɔ ngɔ tike man anʋan'n. Ɔ kɔ nwanndi kɔ hɔ kɔ bɔ amannɩɛ awulo kunnun ɛlɔ kɛ Pɩɛlɩ y'ɔ lɛ bɔ anʋan nɩn ɔ. ");
INSERT INTO any_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","M'ɔ bɔlɩ amannɩɛ sɔ'n, bɛ́ nwan: “Se kɛ ɛ lɛ sɛ!” Anɩn Lodɩ lɛ kan fua sʋ kɛ: “Sakpa, Pɩɛlɩ y'ɔ lɛ bɔ anʋan nɩn ɔ.” Bɛ́ nwan: “Sɛ kɛ yɩ́ bɔfʋɛ'n yɛ̂ ɔ'a yɩ yɩ́ nwun ɔ'a hele yɩ́ ɔ.” ");
INSERT INTO any_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Mɔ bɛ 'kɩkan ɛhɩ'n, anɩn Pɩɛlɩ tɛ jin anʋan nɩn anzin ɔ tɛ bɔ. Bɛ 'tike anʋan nɩn an, Pɩɛlɩ jin. Ɛjɔlɛ'n kɔ sin bɛ́ nwʋn. ");
INSERT INTO any_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Pɩɛlɩ kɔ bʋbʋ bɛ́ kɛ bɛ múan bɛ́ nʋan. Kɛ ɔ kpɩnlɩn yɔlɩ mɔ yɛ̂ Mɩn yɩlɩ yɩ́ fi fiadɩ sua nɩn anun'n, ɔ kɔ sʋsɔ sʋ ɔ kɔ han kɔ hele bɛ́. Ɛsɛ yɩ́ nwan: “Ɛmɔ hán ɛjɔlɛ sɔ'n bɛ hele Zʋakɩ nʋn anianman'n-mɔ.” M'ɔ hanlɩn sɔ'n, ɔ fitelɩ ɔ bɔlɩ yɩ́ ti lɩka fʋfɔlɛ. ");
INSERT INTO any_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Ɔ wɔ ɛbɛlɛ dede alɩ́ɛ kɔ hɩn. Nzalafʋ'n-mɔ kpʋnndɛ Pɩɛlɩ a, bɛ nwun Pɩɛlɩ nin. Bɛ́ nyɩn kɔ bʋlʋ. ");
INSERT INTO any_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Elɔdɩ kɔ man bɛ kɔ hɔ yɩ́ ɛkpʋnndɛ. Bɛ kɔ kpʋnndɛ yɩ́ dede ɔ tɩ man mɔ bɛ lɛ nwun yɩ́ ɔ. Ɛhɩ a, Elɔdɩ kɔ man bɛ kɔ bisa bisa nzalafʋ sɔ'n-mɔ kosuan. Yɩ́ bɛ-yue-asɩɛ, Elɔdɩ manlɩn atɩn kɛ bɛ hún bɛ́. Ɛhɩ anzin, Elɔdɩ fi Zude mân nun ɔ kɔ hɔ kɔ tanlan Sezale kaan. ");
INSERT INTO any_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Ɔ 'ba yɔ sɔ'n, anɩn Elɔdɩ a fɛ Tii nʋn Sidʋn amma'n-mɔ anwʋn ɛya kpa. Ɛhɩka ati, bɛ kɔ nwun Elɔdɩ menian'n-mɔ mɔ bɛ di yɩ́ sua nɩn anun junman nɩn asʋ kpain nɩn anwʋn bɛ nʋn yɩ́ kɔ tila amanngʋan. Bian sɔ'n, bɛ fɛlɛ yɩ́ Balasɩtusi. Bɛ́ nʋan kɔ sɛ bɛ́ nwʋn, bɛ kɔ a kɔ tʋ Elɔdɩ. Bɛ kɔ sɩn Balasɩtusi asʋ bɛ kɔ fa bɛ kɔ tʋ Elɔdɩ anyunnun kɛ bɛ kulo kɛ bɛ sesie bɛ́ afian. Ɔ sanlɩn kɛ, Elɔdɩ mân'n y'ɔ man bɛ didi ɔ. ");
INSERT INTO any_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Bɛ kɔ hele bɛ́ nwʋn cɩan. Mɔ cɩan sɔ'n juli'n, Elɔdɩ kɔ wula yɩ́ belemgbin taladɩɛ'n ɔ kɔ tanlan yɩ́ bia nɩn asʋ. Ɔ kɔ han ɛjɔlɛ dede yɩ́ nʋan kɔ tɔ. ");
INSERT INTO any_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Menian'n-mɔ kɔ bɔ bɛ́ sa nun. Bɛ́ nwan: “Nyanmɩan yɛ̂ ɔ'a jʋjɔ ɔ, nán nan kulo sʋanlan ɔ!” ");
INSERT INTO any_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Tɛmʋn sɔ'n, yɛ́ Mɩn bɔfʋɛ'n kʋn kɔ yɩ ewue kɔ tʋ Elɔdɩ anwʋn. Ɔ sanlɩn kɛ, Elɔdɩ a man b'a sʋ yɩ́ kɛ bɛ sʋ Nyanmɩan'n. Ngakʋba kɔ li Elɔdɩ bɛ kɔ hun yɩ́. ");
INSERT INTO any_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Ɛhɩ nʋn ɛhɩ a, anɩn Nyanmɩan Anʋan Ɛjɔlɛ'n lɛ tɛlɛ, menian dɔʋn lɛ fa bɛ́ nwʋn bɛ man yɛ́ Mɩn. ");
INSERT INTO any_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Baanabasɩ nʋn Sɔlʋ dɩɛ, mɔ bɛ nʋn anwan'n walɩ Zoluzalɛmʋn yuelɩ'n, bɛ kɔ sa bɛ kɔ hɔ Antiɔsʋ. Mɔ bɛ 'kɔ'n, bɛ nʋn Zʋan mɔ bɛ fɛlɛ yɩ́ Maakɩ'n yɛ̂ ɔ hɔlɩ ɔ. ");
INSERT INTO any_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Ɛhɩ, anɩn mgbɔmanfʋɛ nʋn ngehelefʋɛ wɔ Antiɔsʋ asɔnɩn nɩn anun. Ɛ 'nwun bɛ́: Baanabasɩ, Simeʋn mɔ bɛ fɛlɛ yɩ́ Bíle, Lusiyusi m'ɔ fi Silɛnɩn'n, Manahɛnɩn mɔ bɛ talɩ yɩ́ nʋn belemgbin Elɔdɩ lɩka kʋn'n yɛ̂ Sɔlʋ. ");
INSERT INTO any_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Ɛlɛhʋn kʋn, anɩn bɛ lɛ cɩ ɛhɔɛ bɛ yɔ asɔnɩn. Ɛhɩ a, Wawɛ Nwannzan-nwannzan'n kɔ han kɔ hele bɛ́ kɛ: “Ɛmɔ síe Baanabasɩ nʋn Sɔlʋ ahanmɩan maan bɛ lí junman'n mɔ yɩ́ ti yɛ̂ m'an fɛlɛ bɛ́'n.” ");
INSERT INTO any_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Mɔ Wawɛ Nwannzan-nwannzan'n hanlɩn sɔ, mɔ bɛ hyɩlɩ ɛhɔɛ bɛ yɔlɩ asɔnɩn, mɔ bɛ 'ba yue'n, bɛ kɔ fa bɛ́ sa bɛ kɔ fua Baanabasɩ nʋn Sɔlʋ anwʋn, bɛ kɔ sɛlɛ Nyanmɩan bɛ kɔ man bɛ́ bɛ kɔ yaci bɛ́ maan bɛ kɔ hɔ. ");
INSERT INTO any_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Ɛhɩ, Wawɛ Nwannzan-nwannzan'n kɔ sʋan Baanabasɩ nʋn Sɔlʋ. Bɛ kɔ ju Selesi kulo nɩn asʋ. Bɛ kɔ fa meli ɛbɛlɛ bɛ kɔ hɔ Sipʋlʋ mân'n m'ɔ wɔ asue afian nɩn anun. ");
INSERT INTO any_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Mɛlɛ mɔ bɛ juli kulo'n mɔ bɛ fɛlɛ yɩ́ Salaminnin nɩn asʋ'n, bɛ kɔ han Nyanmɩan Anʋan Ɛjɔlɛ'n Zufʋ'n-mɔ asɔnɩn sua'n-mɔ anun. Mɔ Baanabasɩ nʋn Sɔlʋ bɛ 'kɔ'n, bɛ nʋn Zʋan mɔ bɛ fɛlɛ yɩ́ Maakɩ'n y'ɔ hɔlɩ ɔ. Ɔ tɩ bɛ́ bʋkafʋɛ. ");
INSERT INTO any_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Ɛsɛ bɛ fi Salaminnin ɛbɛlɛ, bɛ kɔ kpɛ asue afian kpɔlɛ sɔ'n dede bɛ kɔ ju kulo'n mɔ bɛ fɛlɛ yɩ́ Pafɔsʋ nɩn asʋ. Bɛ tʋlɩ Zufʋ bian kʋn ɛbɛlɛ. Bian sɔ'n, bɛ fɛlɛ yɩ́ Bâ-Zozi. Ɔ yɩ jiliwa ɛsɛ ɔ bu yɩ́ nwʋn kɛ ɔ tɩ Nyanmɩan kpɔmanfʋɛ. ");
INSERT INTO any_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Anɩn Bâ-Zozi sɔ'n wɔ bian m'ɔ sie Sipʋlʋ mân nɩn anwʋn ɛbɛlɛ. Bɛ fɛlɛ bian sɔ'n Sɛɛzusu Polusu. Ɔ tɩ ngɛlɛfʋɛ. Ɔ kɔ man bɛ kɔ fɛlɛ Baanabasɩ nʋn Sɔlʋ, ɔ sanlɩn kɛ ɔ kulo kɛ ɔ tie Nyanmɩan Anʋan Ɛjɔlɛ'n. ");
INSERT INTO any_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Mɔ Sɛɛzusu Polusu man bɛ fɛlɛlɩ bɛ́'n, Bâ-Zozi mɔ gɛlɛkɩ anɩɛ nɩn anun bɛ fɛlɛ yɩ́ Elimasɩ mɔ yɩ́ bʋ y'ɔ le kɛ sʋanlan m'ɔ yɩ jiliwa, ɔ kɔ totua Baanabasɩ nʋn Sɔlʋ atɩn, ɛsɛ ɔ kɔ han kɔ hele kpain'n kɛ n'ɔ de Nyanmɩan Anʋan Ɛjɔlɛ'n di. ");
INSERT INTO any_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Ɛhɩ a, Wawɛ Nwannzan-nwannzan'n kɔ jinlan Sɔlʋ mɔ ɛsɛ bɛ fɛlɛ yɩ́ Pɔlʋ nɩn anzin. Ɔ kɔ tu yɩ́ nyɩn kɔ gua Elimasɩ anwʋn. yɩ́ nwan: ");
INSERT INTO any_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","“Apoo ati anun ɛtɛ sʋanlan, Abɔnsanmʋn awa, m'ɔ kpɔ like kʋalaa m'ɔ tɩ kpa, cɩan benin yɛ̂ Nyanmɩan ninnge m'ɔ kɔ sesie'n ɛ 'yaci yɩ́ ɛsɛcɩ ɔ. ");
INSERT INTO any_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Kɩkaala dɩɛ, nwun yɩ́ kɛ yɛ́ Mɩn 'ba fin wɔ́ like. Wɔ́ nyɩn'n 'ba sin mɛlɛ kaan sʋa, ɛ ngɔ nwun man sɛnzɛ'n kʋ́n.” Ɛbɛlɛ ala, Elimasɩ anyɩn'n kɔ sin ɔ kɔ ha awosin nun. Anɩn ɔ lɛ tʋtʋ yɩ́ sa ɔ kpʋnndɛ sʋanlan ɔ sɔ yɩ́ sa maan ɔ di yɩ́ taataa. ");
INSERT INTO any_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Mɔ kʋnmanna'n nwunlin yɩ́ sɔ'n, ɛjɔlɛ'n sinlin yɩ́ nwʋn. Ɔ kɔ le yɛ́ Mɩn Anʋan Ɛjɔlɛ'n kɔ li. ");
INSERT INTO any_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Ɛhɩ anzin, Pɔlʋ nʋn yɩ́ manngʋn'n-mɔ bɛ kɔ fʋ meli nun Pafɔsʋ ɛbɛlɛ. Bɛ kɔ bɔ bɛ́ ti Panfili mân nɩn anun. Bɛ kɔ hɔ kulo'n mɔ bɛ fɛlɛ yɩ́ Pɛlɩzʋ nɩn asʋ. Zʋan Maakɩ kɔ yaci bɛ́ ɛbɛlɛ ɔ kɔ sa yɩ́ nzin Zoluzalɛmʋn. ");
INSERT INTO any_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Pɔlʋ nʋn Baanabasɩ bɛ kɔ fa atɩn'n bɛ́ nʋan y'ɔ le Antiɔsʋ m'ɔ wɔ Pizidi mân nun'n. Ɛnwʋnmɩan ele cɩan'n, bɛ kɔ wʋlʋ Zufʋ'n-mɔ asɔnɩn sua nɩn anun bɛ kɔ tɛtanlan asɩ. ");
INSERT INTO any_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Asɔnɩn ɛyɔlɛ nɩn anun, menian kɔ kɩnnga Moyizɩ mala kalata'n nʋn mgbɔmanfʋɛ'n-mɔ dɩɛ'n. Mɔ bɛ kɩnngalɩ yuelɩ'n, asɔnɩn nɩn asʋ mgbain'n-mɔ man bɛ hanlɩn bɛ helelɩ Pɔlʋ nʋn Baanabasɩ kɛ: “Anianman mmelenzua-mɔ, sɛ ɛmɔ le ɛjɔlɛ bɛ kan bɛ wowula bɛ́ mɔ b'a yia ɛwa nɩn anwʋnsɛlɛ a, atɩn wɔ nun.” ");
INSERT INTO any_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Mɔ mgbain'n-mɔ hanlɩn sɔ'n, Pɔlʋ kɔ jasʋ, ɔ kɔ tʋ yɩ́ sa ɔ kɔ bʋbʋ bɛ́, yɩ́ nwan: “Izalayɛ amma ɔ nʋn ɛmɔ mɔ ɛmɔ anyɩn sɔ Nyanmɩan bɛ sʋ yɩ́'n, ɛmɔ tíe. ");
INSERT INTO any_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Izalayɛ amma'n-mɔ Nyanmɩan nɩn a fɛlɛ yɛ́ nan-mɔ. Ɔ a man b'a li ata bɛ́ nwʋn a sʋn mɛlɛ mɔ anɩn bɛ tɩ nyɔfʋɛ Ezipiti mân nɩn anun ɛlɔ'n. Ɛhɩ anzin, tunmin sʋ, Nyanmɩan a yɩ bɛ́ fi Ezipiti mân nɩn anun. ");
INSERT INTO any_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Mɛlɛ mɔ anɩn bɛ nanndɩ ɛwâ nɩn anun'n, Nyanmɩan gualɩ bɛ́ nʋan alɩɛ kɔ yɔ afʋɛ abulanan. ");
INSERT INTO any_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Nyanmɩan kɔ bɔ mân nsʋ abʋsʋ Kanaân mân nɩn anun ɔ kɔ fa bɛ́ lɩka'n kɔ man yɛ́ nan-mɔ kɛ bɛ́ ajâ like. ");
INSERT INTO any_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Afʋɛ kɔ yɔ ɛya nnan abulanun kɔ sɩn. “Ɛhɩ anzin, bɛ́ mɔ bɛ di ɛjɔlɛ'n buli mân'n dede ɔ juli kpɔmanfʋɛ Samiɛ mɛlɛ sʋ. ");
INSERT INTO any_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Samiɛ mɛlɛ sʋ, bɛ́ nwan bɛ kulo kɛ bɛ nyan belemgbin maan ɔ sie bɛ́. Nyanmɩan kɔ sie Kisi awa Sayuli m'ɔ fi Bɩnnzʋamɩn afilie nɩn anun'n belemgbin kɔ man bɛ́. Sayuli lili belemgbin afʋɛ abulanan. ");
INSERT INTO any_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Mɔ Nyanmɩan tuli yɩ́'n y'ɔ sielɩ Davidi belemgbin ɔ. Nyanmɩan lili Davidi anwʋn adanzɩɛ kɛ: M'an nwun yɩ́ kɛ Jese awa Davidi tɩ mɩ́n ahʋnlɩn nun sʋanlan. Like kʋalaa mɔ mɩn kulo'n yɛ̂ ɔ 'yɔ ɔ. ");
INSERT INTO any_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","“Davidi abʋsʋ sʋanlan kʋn y'ɔ le Zozi. Nyanmɩan a sie Zozi kɛ Izalayɛ mân nɩn ati Ngʋandefʋɛ. Ɔ sanlɩn kɛ Nyanmɩan bɔlɩ anɔhʋba sɔ'n. ");
INSERT INTO any_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Asannan nán Zozi a a'n, Zʋan hanlɩn helelɩ Izalayɛ mân bɔndɩn'n kɛ bɛ káci bɛ́ abalabɔ'n bɛ fá bɛ́ nwʋn bɛ mán Nyanmɩan maan ɔ sɔ́nɩn bɛ́. ");
INSERT INTO any_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Mɔ Zʋan 'kɔ yɩ́ ayuelɩɛ'n, ɔ kɔ bisa menian'n-mɔ kɛ: ‘Ɛmɔ nwan: nwan sʋanlan dɩɛ y'ɔ le mɩ́n? Sʋanlan'n mɔ ɛmɔ lɛ nwʋnndɛ yɩ́'n, nán yɩ́ y'ɔ le mɩ́n! Nan ɛmɔ tíe, sʋanlan kʋn fi mɩ́n nzin ɔ lɛ ba, mɩn nzɛ nvata man kɛ mɩn nyannjɩ yɩ́ ja mgbabʋa nyanman'n.’ ");
INSERT INTO any_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“Anianman mmelenzua, ɛmɔ mɔ bɛ tɩ Abalahamʋn abʋsʋ menian, ɔ nʋn ɛmɔ mɔ ɛmɔ tɩ man Zufʋ kʋsʋ ɛmɔ anyɩn sɔ Nyanmɩan bɛ sʋ yɩ́'n, yɛ́ dunman nun ati yɛ̂ bɛ́ ti ele ngalɩɛ ɛhɩ a a ɔ. ");
INSERT INTO any_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Afɩ, Zoluzalɛmʋn amma'n-mɔ nʋn bɛ́ mgbain'n-mɔ, b'a mmu man Zozi sʋanlan. Ɛsɛ ɛjɔlɛ mɔ mgbɔmanfʋɛ'n-mɔ hɛlɛlɩ mɔ ɛnwʋnmɩan ele biala bɛ kɩnnga'n, b'a ndɩ man yɩ́ bʋ. Nan bɛ́ dɩɛ, b'a man b'a hun Zozi. B'a man ɛjɔlɛ'n mɔ mgbɔmanfʋɛ'n-mɔ hanlɩn nɩn a kpɩn sʋ. ");
INSERT INTO any_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Bɛ si Pilatɩ sʋ kɛ ɔ mán bɛ hún yɩ́. Kʋsʋ b'a ngʋala b'a ngele man kɛ like sʋa ati yɛ̂ yɛ́ nwan bɛ́ hún yɩ́ ɔ. ");
INSERT INTO any_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Mɔ Zozi anwʋn ɛjɔlɛ'n kʋalaa m'ɔ wɔ Ɛhɛlɛ Ɛjɔlɛ nɩn anun'n kpɩnlɩn sʋ'n, bɛ kɔ yɩ yɩ́ fi kʋlʋwa nɩn asʋ bɛ kɔ hɔ kɔ sie yɩ́. ");
INSERT INTO any_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Nan Nyanmɩan man ɔ fi ewue nun ɔ'a tinnge. ");
INSERT INTO any_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Mɔ Zozi fi ewue nun tinngelɩ'n, ɔ yɩlɩ yɩ́ nwʋn cɩan kɔ yɔ nyɛ nyɛ ɔ helelɩ bɛ́ mɔ bɛ nʋn yɩ́ nanndɩlɩ'n, ɔ bɔ yɩ́ bʋ Galile mân nɩn anun ɔ kɔ ju Zoluzalɛmʋn. Menian sɔ'n-mɔ, bɛ́ yɛ̂ sian dɩɛ, bɛ lɛ di adanzɩɛ bɛ kan yɩ́ ɛjɔlɛ'n bɛ kele Izalayɛ mân nɩn ɔ. ");
INSERT INTO any_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","“Yɛ́ muonun yɛ lɛ bɔ Ɛjɔlɛkpa sɔ'n yɛ kele ɛmɔ. Ɔ tɩ like mɔ Nyanmɩan falɩ bɔlɩ yɛ́ nan-mɔ anɔhʋba ɔ. ");
INSERT INTO any_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Nyanmɩan a man anɔhʋba sɔ nɩn a kpɩn sʋ a man yɛ́ mɔ yɛ tɩ yɛ́ nan-mɔ abʋsʋ menian'n. Ɔ sanlɩn kɛ, ɔ'a man Zozi fi ewue nun a tinnge kɛ bɛ kpɩnlɩn bɛ hɛlɛlɩ yɩ́ wɔ Izalayɛ ejue ɛtʋɛ kalata nɩn ati nnyuan nɩn anun'n kɛ: Ɛ tɩ mɩ́n Wa, ɛnɛ m'ɔ kɔ'n, n dɩ wɔ́ Sɩ. ");
INSERT INTO any_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","“Nyanmɩan hanlɩn kɛ ɔ 'man ɔ fi ewue nun tinnge, ɔ 'man ɔ nwu man kʋ́n. Ɛ 'nwun kɛ ɔ kpɩnlɩn hanlɩn yɩ́'n: Anwʋntɩɛ nyila mgbakpa'n mɔ n valɩ m mɔlɩ *Davidi anɔhʋba'n yɛ̂ mɩn 'fa mɩn man ɛmɔ ɔ. ");
INSERT INTO any_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Ɛhɩka ati, lɩka kʋn biekun yɩ́ nwan: Ɛ ngɔ man man atɩn maan wɔ́ anwʋntɩɛ sʋanlan'n ngɔ kpɔlɔ man sɛka nɩn anun. ");
INSERT INTO any_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","“Mɛlɛ mɔ anɩn belemgbin Davidi tɛ tɩ asɩ'n, like mɔ Nyanmɩan bisalɩ yɩ́ kɛ ɔ yɔ́'n, ɔ yɔlɩ. Davidi a wu, b'a sie yɩ́ lɩka mɔ bɛ sielɩ yɩ́ nan-mɔ'n, ɔ'a kpɔlɔ. ");
INSERT INTO any_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Nan sʋanlan'n mɔ Nyanmɩan a man ɔ fi ewue nun ɔ a tinnge'n, ɔ'a mgbɔlɔ man. ");
INSERT INTO any_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","“Anianman mmelenzua-mɔ, ɛmɔ nwún yɩ́ kɛ Zozi dunman nun yɛ̂ ɛmɔ kʋala kɛ bɛ nyan ɛtɛ face ɔ. ");
INSERT INTO any_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Sʋanlan biala m'ɔ de yɩ́ di'n, ɔ nyan yɩ́ ti fi yɩ́ nyɔlɩɛ ɛtɛ'n-mɔ kʋalaa mɔ Moyizɩ mala nɩn a ngʋala a nne man ɛmɔ'n fi nun fite. ");
INSERT INTO any_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Ɛmɔ nɩ́an bɛ́ nwʋn kpa, nán ɛjɔlɛ'n mɔ Nyanmɩan mgbɔmanfʋɛ'n-mɔ hanlɩn nɩn a nga man ɛmɔ anwʋn. Afɩ, bɛ́ nwan: ");
INSERT INTO any_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","Atubɛnwʋn mma, ɛmɔ nɩ́an maan ɔ sín bɛ́ nwʋn, ɔ sanlɩn kɛ ɛmɔ dɩɛ a yue. Ɛmɔ mɛlɛ sʋ, mɩn 'ba yɔ like kʋn. Sɛ sʋanlan kan like sɔ nɩn anwʋn ɛjɔlɛ kele ɛmɔ a, ɛmɔ ngɔ le ngɔ li man.” ");
INSERT INTO any_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Mɔ Pɔlʋ anʋan tɔlɩ mɔ bɛ fi asɔnɩn bɛ fitelɩ'n, bɛ kɔ han bɛ kɔ hele Pɔlʋ nʋn Baanabasɩ kɛ bɛ sá bɛ bála ɛnwʋnmɩan ele cɩan fʋfɔlɛ nán bɛ hán ɛjɔlɛ sɔ'n biekun. ");
INSERT INTO any_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Mɔ bɛ sanndɩlɩ'n, Zufʋ'n-mɔ dɔʋn nʋn bɛ́ mɔ bɛ tɩ man Zufʋ nan kʋsʋ bɛ kɔ Zufʋ'n-mɔ asɔnɩn'n bie'n, bɛ kɔ fa bɛ́ nwʋn bɛ kɔ bɔ Pɔlʋ nʋn Baanabasɩ bɛ́ nʋn bɛ kɔ jʋjɔ. Pɔlʋ nʋn Baanabasɩ bɛ kɔ bʋtʋ bɛ́ kɛ Zozi anwʋn Ɛjɔlɛkpa'n mɔ b'a tɩ'n, bɛ tíla nun kpa. ");
INSERT INTO any_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Mɔ ɛnwʋnmɩan ele cɩan'n mɔ bɛ helelɩ'n juli'n, yɛ́ Mɩn Anʋan Ɛjɔlɛ nɩn etie ati, kulo bɔndɩn'n kɔ yia. ");
INSERT INTO any_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Mɔ Zufʋ'n-mɔ nwunlin yɩ́ sɔ'n, bɛ kɔ fa Pɔlʋ nʋn Baanabasɩ anwʋn ɛkpɔ. Ɛjɔlɛ'n mɔ Pɔlʋ lɛ kan'n, anɩn bɛ lɛ bɔ bɛ yɩ bɛ kpɛ yɩ́ nzʋba. ");
INSERT INTO any_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Pɔlʋ nʋn Baanabasɩ kɔ nyan anwʋnsɛlɛ bɛ kɔ han bɛ kɔ hele bɛ́ kɛ: “Ɛmɔ Zufʋ'n-mɔ, ɛmɔ yɛ̂ ɔ di kɛ bɛ di mʋa bɛ kan Nyanmɩan Anʋan Ɛjɔlɛ'n bɛ kele ɛmɔ ɔ. Nan kɛmɔ ɔ njian man ɛmɔ, mɔ ɛsɛ ɛmɔ nɩan an, ngʋan m'ɔ le man ayuelɩɛ'n nzɛ nvata man ɛmɔ'n, yɩ́ ti, kɩkaala dɩɛ, yɛ lɛ kaci yɛ́ nyɩn bɛ́ mɔ bɛ tɩ man Zufʋ'n-mɔ ɛlɔ. ");
INSERT INTO any_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Ɔ sanlɩn kɛ, ɛ 'nwun junman'n mɔ yɛ́ Mɩn a fa a wula yɛ́ sa nun'n, yɩ́ nwan: M'an sie wɔ́ kɛ kanlannɩɛ maan ɛ ta man bɛ́ mɔ bɛ tɩ man Zufʋ'n-mɔ nán ɛ bɔ ngʋan ele nɩn anwʋn ɛjɔlɛ ɛ kele asɩɛ nɩn asʋ menian'n-mɔ kʋalaatin.” ");
INSERT INTO any_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Mɔ bɛ́ mɔ bɛ tɩ man Zufʋ'n tɩlɩ ɛjɔlɛ sɔ'n, bɛ kɔ li yɩ́ nwʋn fɛ, bɛ kɔ yɩ yɛ́ Mɩn Anʋan Ɛjɔlɛ nɩn ayɛ. Bɛ́ kʋalaa mɔ Nyanmɩan a hɛlɛ bɛ́ dunman yɩ́ kalata nɩn anun kɛ bɛ nyán ngʋan m'ɔ le man ayuelɩɛ'n, menian sɔ'n-mɔ kɔ fa bɛ́ nwʋn bɛ kɔ man yɛ́ Mɩn. ");
INSERT INTO any_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Yɛ́ Mɩn Anʋan Ɛjɔlɛ'n kɔ tɛlɛ ɛbɛlɛ etin nɩn asʋ. ");
INSERT INTO any_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Ɛhɩ a, Zufʋ'n-mɔ kɔ wowula mmalasua mgbili mgbili'n-mɔ mɔ bɛ sʋ Nyanmɩan'n nʋn kulo nɩn asʋ menian mgbili mgbili'n-mɔ abʋ. Bɛ kɔ hele Pɔlʋ nʋn Baanabasɩ ahʋlʋwa bɛ kɔ fʋan bɛ́ fi bɛ́ mân nɩn anun. ");
INSERT INTO any_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Pɔlʋ nʋn Baanabasɩ bɛ kɔ wʋsʋ bɛ́ ja nɩn anun anyʋan'n bɛ kɔ gua bɛ́ kulo nɩn asʋ ɛbɛlɛ bɛ kɔ hɔ Ikoninwɔmʋn kulo nɩn asʋ. (Yɩ́ bʋ kele kɛ Zufʋ'n-mɔ mɔ bɛ ngulo man kɛ bɛ fa bɛ́ nwʋn bɛ man yɛ́ Mɩn'n, sɛ bɛ minlin an, nán Pɔlʋ nʋn Baanabasɩ ɛjɔlɛ ɔ.) ");
INSERT INTO any_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Bɛ́ mɔ b'a fa bɛ́ nwʋn b'a man yɛ́ Mɩn Antiɔsʋ ɛlɔ'n, bɛ́ dɩɛ, Wawɛ Nwannzan-nwannzan'n wɔ bɛ́ nun, ɛsɛ bɛ le fɛ elie. ");
INSERT INTO any_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Mɔ Pɔlʋ nʋn Baanabasɩ juli Ikoninwɔmʋn ɛlɔ'n, bɛ hɔlɩ Zufʋ'n-mɔ asɔnɩn sua nɩn anun. Kɛ bɛ kpɩnlɩn bɛ bɔlɩ Ɛjɔlɛkpa'n, ɔ man Zufʋ nʋn bɛ́ mɔ bɛ tɩ man Zufʋ'n, bɛ́ dɔʋn bɛ falɩ bɛ́ nwʋn bɛ manlɩn yɛ́ Mɩn. ");
INSERT INTO any_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Nan Zufʋ'n-mɔ mɔ bɛ ngulo man kɛ bɛ fa bɛ́ nwʋn bɛ man yɛ́ Mɩn'n, bɛ kɔ wowula bɛ́ mɔ bɛ tɩ man Zufʋ nɩn abʋ maan bɛ kɔ fa anianman'n-mɔ anwʋn ɛkpɔ. ");
INSERT INTO any_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Pɔlʋ nʋn Baanabasɩ dɩɛ, bɛ tanlanlɩn Ikoninwɔmʋn ɛbɛlɛ ɔ hyɛlɩ kpa. Bɛ le anwʋnsɛlɛ nʋn dedi yɛ́ Mɩn anun bɛ kan yɩ́ nʋan ɛjɔlɛ'n. Yɛ́ Mɩn man bɛ́ tunmin maan bɛ yɩ atɛlɛ bɛ yɔ asinbɛnwʋn ninnge. Ɔ yɔ yɩ́ sɔ ɔ man bɛ nwun yɩ́ kɛ yɩ́ anwunnvoe enwuan ɛjɔlɛ'n mɔ bɛ kan'n tɩ ananhɔlɛ. ");
INSERT INTO any_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Kulo nɩn asʋ ɛbɛlɛ menian'n-mɔ kɔ bu bɛ́ nwʋn nun. Mmie-mɔ jin Zufʋ'n-mɔ anzin, mmie-mɔ kʋsʋ jin mmɔfʋɛ'n-mɔ anzin. ");
INSERT INTO any_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Ɛhɩ a, Zufʋ'n-mɔ nʋn bɛ́ mɔ bɛ tɩ man Zufʋ'n nʋn bɛ́ mgbain'n-mɔ kɔ bɔbʋa bɛ́ nwʋn, bɛ lɛ ba hele Pɔlʋ nʋn Baanabasɩ ahʋlʋwa bɛ tʋtʋ bɛ́ ɛbʋɛ bɛ kun bɛ́. ");
INSERT INTO any_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Mɔ Pɔlʋ nʋn Baanabasɩ nwunlin nun'n, bɛ kɔ yɩ bɛ́ bɔ́lɛ nɩn ɛbɛlɛ. Bɔ kɔ hɔ Lisitili nʋn Dɛlɩbʋ nʋn kulo'n-mɔ mɔ bɛ mantan mantan bɛ́'n-mɔ asʋ. Lisitili nʋn Dɛlɩbʋ tɩ Likawonin mân nun kulo. ");
INSERT INTO any_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Ɛbɛlɛ, bɛ kɔ bɔ Ɛjɔlɛkpa'n bɛ kɔ hele menian'n-mɔ. ");
INSERT INTO any_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Ɔ 'ba yɔ sɔ'n, anɩn bian kʋn wɔ Lisitili kulo nɩn asʋ ɛbɛlɛ. Bian sɔ'n tɩ bubuluwafʋɛ sunmin yɩ́ mmatʋnman nun, ɔ nanndɩlɩ man lé. ");
INSERT INTO any_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Ɛlɛhʋn kʋn, anɩn ɔ lɛ tie ɛjɔlɛ'n mɔ Pɔlʋ lɛ kan kele menian'n-mɔ'n. Pɔlʋ anyɩn kɔ ha yɩ́ nwʋn. Ɔ 'nɩan an, anɩn bian'n le dedi ɔ kʋala kɛ yɩ́ nwʋn sa. ");
INSERT INTO any_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Ɛhɩ a, Pɔlʋ kɔ tɩan kɔ han kɔ hele yɩ́ kɛ: “Jasʋ jinlan fɔ́ʋ́n!” Mɔ Pɔlʋ hanlɩn sɔ'n, waka, bian'n kɔ jasʋ kɔ jinlan ɛsɛ ɔ kɔ nanndɩ. ");
INSERT INTO any_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Mɔ Menian'n-mɔ nwunlin mɔ Pɔlʋ yɔlɩ'n, bɛ kɔ bɔ bɛ kɔ sulo Likawonin anɩɛ nɩn anun kɛ: “Mmʋsʋɩn'n-mɔ a kaci bɛ́ nwʋn kulo menian b'a a yɛ́ afian ɛwa!” ");
INSERT INTO any_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Bɛ kɔ tʋn Baanabasɩ “Zesɩ” (m'ɔ tɩ bɛ́ bʋsʋɩn kpili'n) yɛ̂ bɛ kɔ tʋn Pɔlʋ kʋsʋ “Ɛlɩmɛsɩ” (m'ɔ tɩ bɛ́ mmʋsʋɩn'n-mɔ kpɔmanfʋɛ'n). Ɔ sanlɩn kɛ Pɔlʋ yɛ̂ anɩn ɔ jʋjɔ ɔ nʋn Baanabasɩ anʋan ɔ. ");
INSERT INTO any_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Mɔ ɛ 'wʋlʋ kulo nɩn anun'n, ɛbɛlɛ yɛ̂ b'a si bʋsʋɩn Zesɩ sua nɩn ɔ. Sʋanlan'n m'ɔ tʋtɔ Zesɩ'n kɔ man bɛ kɔ fa nnalɛ. Bɛ kɔ sɩsan bɛ́ sʋ nyanman bɛ kɔ sisan nun falawasɩ. Bɛ nʋn nnalɛ'n-mɔ kɔ a kulo nɩn anʋan nɩn anyunnun. Bian sɔ'n nʋn kulo mma'n kulo kɛ bɛ fa nnalɛ sɔ'n-mɔ bɛ yɩ tɛɛ bɛ man Pɔlʋ nʋn Baanabasɩ. ");
INSERT INTO any_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Mɔ Pɔlʋ nʋn Baanabasɩ tɩlɩ ɛjɔlɛ sɔ'n, bɛ kɔ sɔ taladɩɛ'n mɔ bɛ wula'n bɛ kɔ tɩtɩ nun. Bɛ le ɛnwanndie bɛ kɔ wʋlʋ menian'n-mɔ afian. Bɛ le ɛtɩan, bɛ́ nwan: ");
INSERT INTO any_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Ebia-mɔ, nzukɛ ati yɛ̂ ɛmɔ yɔ sʋa ɔ? Yɛ tɩ kulo menian kɛ ɛmɔ ala. Yɛ hanlɩn yɛ helelɩ ɛmɔ, mɛlɛ mɔ yɛ bɔlɩ Ɛjɔlɛkpa'n kɛ ɛmɔ yáci ninnge mgban mgban ɛhɩ-mɔ bɛ gúa. Nán bɛ káci bɛ́ nyɩn Tɩasɩfʋɛ Nyanmɩan nɩn anwʋn ɛlɔ. Ɔ sanlɩn kɛ yɩ́ y'ɔ bɔlɩ anwunno nʋn asɩ, asue jenvie'n nʋn nun ninnge'n kʋalaatin ɔ. ");
INSERT INTO any_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Daba, Nyanmɩan yacili mân nɩn anun menian'n-mɔ maan sʋanlan kʋn biala sɩnlɩn atɩn m'ɔ kulo nɩn asʋ. ");
INSERT INTO any_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Nan kʋsʋ tɛmʋn biala ɔ yɔ ye maan bɛ nwun yɩ́. Ɔ man esue'n tɔ maan ɛmɔ ninnge'n-mɔ yɔ kpa. Ɔ gua ɛmɔ anʋan alɩɛ ɛsɛ ɔ wula fɛ elie kpili kpa ɛmɔ ahʋnlɩn nɩn anun.” ");
INSERT INTO any_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Ɛhɩ, ɛjɔlɛ'n muonun mɔ Pɔlʋ nʋn Baanabasɩ lɛ kan maan bɛ yacɩ tɛɛ ɛyɩɛ'n, nán yɩ́ nwʋn bie yɛ̂ anɩn bɛ lɛ di ɔ. ");
INSERT INTO any_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Ɛhɩ, Zufʋ mmie-mɔ fi Antiɔsʋ m'ɔ wɔ Pizidi mân nun'n, ɔ nʋn Ikoninwɔmʋn kulo nɩn asʋ, bɛ kɔ a. Bɛ kɔ kaci kulo mma nɩn ati. Bɛ kɔ tʋtʋ Pɔlʋ ɛbʋɛ kɛ bɛ 'kun yɩ́. Mɔ bɛ yɔlɩ yɩ́ sɔ'n, bɛ jʋnlɩn kɛ anɩn ɔ'a wu. Bɛ kɔ hyʋɩn yɩ́ bɛ kɔ tʋ kulo tiba. ");
INSERT INTO any_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Nan mɔ bɛ́ mɔ bɛ de Nyanmɩan bɛ di'n yialɩ yɩ́ nwʋn'n, ɔ kɔ jasʋ, ɔ kɔ wʋlʋ kulo nɩn anun. Bɛ lalɩ mɔ alɩ́ɛ hɩnlɩn'n, Pɔlʋ nʋn Baanabasɩ kɔ hɔ kulo'n mɔ bɛ fɛlɛ yɩ́ Dɛlɩbʋ nɩn asʋ. ");
INSERT INTO any_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Ɛhɩ, mɔ Pɔlʋ nʋn Baanabasɩ juli Dɛlɩbʋ kulo nɩn asʋ'n, bɛ kɔ bɔ Ɛjɔlɛkpa'n bɛ kɔ nyan menian dɔʋn kpa ɛbɛlɛ bɛ kɔ man yɛ́ Mɩn. Bɛ fi ɛbɛlɛ bɛ kɔ sa bɛ́ nzin Lisitili, Ikoninwɔmʋn nʋn Antiɔsʋ m'ɔ wɔ Pizidi mân nun'n. ");
INSERT INTO any_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Bɛ kɔ wowula yɛ́ Mɩn menian'n-mɔ anwʋnsɛlɛ, bɛ kɔ bʋtʋ bɛ́ kɛ bɛ jínlan kpunndiin wɔ bɛ́ dedi nɩn anun. Bɛ kan bɛ kele bɛ́ kɛ: “Ɔ di kɛ yɛ nwun yɛ́ nyunnun kpa kʋalaaka nán y'a wʋlʋ Nyanmɩan Belemgbin Mân nɩn anun.” ");
INSERT INTO any_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Kulo kʋn biala asɔnɩn nɩn anun, bɛ man bɛ sie mgbain. Bɛ cɩ ɛhɔɛ bɛ yɔ asɔnɩn yue a, bɛ sɛlɛ Nyanmɩan bɛ fa bɛ́ bɛ wula yɛ́ Mɩn mɔ b'a le yɩ́ b'a li nɩn asa nun. ");
INSERT INTO any_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Ɛhɩ anzin, bɛ kɔ kpɛ nun Pizidi mân nɩn anun bɛ kɔ ju Panfili mân nɩn anun. ");
INSERT INTO any_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Bɛ kɔ han Nyanmɩan Anʋan Ɛjɔlɛ'n Pɛlɩzʋ kulo nɩn asʋ. Bɛ fi ɛbɛlɛ, bɛ kɔ hɔ Atali kulo'n kʋsʋ asʋ. ");
INSERT INTO any_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Atali ɛbɛlɛ, bɛ kɔ fʋ meli'n m'ɔ lɛ kɔ Antiɔsʋ nɩn anun. Ɔ sanlɩn kɛ Antiɔsʋ ɛbɛlɛ yɛ̂ bɛ falɩ bɛ́ bɛ wulalɩ Nyanmɩan asa nun mɔ bɛ hɔlɩ yɩ́ junman nɩn elie ɔ. ");
INSERT INTO any_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Mɔ bɛ juli Antiɔsʋ ɛbɛlɛ'n, bɛ kɔ yia asɔnɩn mma'n-mɔ. Yɩ́ kʋalaa mɔ Nyanmɩan nanndɩlɩ bɛ́ sʋ ɔ yɔlɩ, ɔ nʋn kɛ ɔ kpɩnlɩn yɔlɩ mɔ bɛ́ mɔ bɛ tɩ man Zufʋ'n lelɩ Nyanmɩan lili'n, bɛ kɔ bɔ nun amannɩɛ bɛ kɔ hele bɛ́. ");
INSERT INTO any_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Mɔ bɛ nwunlin bɛ́ nwʋn yuelɩ'n, Pɔlʋ nʋn Baanabasɩ halɩ anianman'n-mɔ anwʋn ɛbɛlɛ, bɛ hyɛlɩ Antiɔsʋ. ");
INSERT INTO any_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Ɛhɩ, menian fi Zude mân nun bɛ kɔ a Antiɔsʋ. Bɛ juli ɛbɛlɛ mɔ bɛ 'kekele anianman'n-mɔ ninnge'n, bɛ́ nwan: “Sɛ b'a mgbɛ man ɛmɔ mmian nun kɛ *Moyizɩ mala'n kpɩn kele nɩn an, ɛmɔ ngʋala bɛ nnyan man ngʋan.” ");
INSERT INTO any_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Mɔ Pɔlʋ nʋn Baanabasɩ tɩlɩ ɛjɔlɛ sɔ'n, bɛ nʋn menian sɔ'n-mɔ kɔ su yɩ́ bʋsʋ akpʋlʋwa kpa. Ɛhɩ a, ɔ kɔ yɔ mɔ Pɔlʋ nʋn Baanabasɩ nʋn anianman'n mmie-mɔ, bɛ hɔ́ Zoluzalɛmʋn bɛ hɔ́ tʋ́ mmɔfʋɛ'n-mɔ nʋn mgbain'n-mɔ wɔ ɛjɔlɛ sɔ nɩn anwʋn. ");
INSERT INTO any_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Mɔ bɛ 'kɔ'n, asɔnɩn mma'n-mɔ kɔ gua bɛ́ atɩn. Bɛ kɔ kpɛ nun Feninsi nʋn Samali mân nɩn anun. Lɩka mɔ bɛ kɔ ju'n, kɛ ɔ kpɩnlɩn yɔlɩ mɔ bɛ́ mɔ bɛ tɩ man Zufʋ'n falɩ bɛ́ nwʋn bɛ manlɩn Nyanmɩan'n, bɛ kan yɩ́ nwʋn ɛjɔlɛ a, anianman'n-mɔ di yɩ́ nwʋn fɛ kpili kpa. ");
INSERT INTO any_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Mɔ Pɔlʋ nʋn Baanabasɩ nʋn ɛhɩnlɩn-mɔ juli Zoluzalɛmʋn'n, asɔnɩn mma'n-mɔ nʋn mmɔfʋɛ'n-mɔ nʋn mgbain'n-mɔ kɔ le bɛ́ atɩn. Junman mɔ Nyanmɩan nanndɩlɩ bɛ́ sʋ ɔ lili'n, Pɔlʋ nʋn Baanabasɩ kɔ han yɩ́ kʋalaa bɛ kɔ hele bɛ́. ");
INSERT INTO any_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","M'ɔ yɔlɩ sɔ'n, Falisifʋɛ mmie-mɔ mɔ bɛ falɩ bɛ́ nwʋn bɛ manlɩn yɛ́ Mɩn'n kɔ jasʋ, bɛ́ nwan: “Ɔ di kɛ bɛ kpɛ bɛ́ mɔ bɛ tɩ man Zufʋ'n mmian nun, ɛsɛ ɔ di kɛ bɛ man bɛ di Moyizɩ mala nɩn asʋ.” ");
INSERT INTO any_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Ɛjɔlɛ sɔ nɩn anwʋn, mmɔfʋɛ'n-mɔ nʋn mgbain'n-mɔ kɔ hɔ anyia. ");
INSERT INTO any_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Bɛ basalɩ yɩ́ dede a, Pɩɛlɩ kɔ jasʋ, yɩ́ nwan: “Anianman-mɔ, ɛmɔ sɩ kɛ ɛmɔ afian ɛwa, Nyanmɩan yɩlɩ mɩ́n a hyɛ kɛ m mɔ́ Ɛjɔlɛkpa'n n géle bɛ́ mɔ bɛ tɩ man Zufʋ'n maan bɛ lé yɩ́ bɛ lí. ");
INSERT INTO any_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Nyanmɩan m'ɔ sɩ menian'n-mɔ ahʋnlɩn nɩn anun ɛjɔlɛ'n, ɔ'a fa yɩ́ Wawɛ Nwannzan-nwannzan ɔ'a man bɛ́ kɛ ɔ'a fa ɔ'a man yɛ́'n. Nyanmɩan a yɔ sɔ ɔ'a hele kɛ ɔ'a sɔ bɛ́ nun. ");
INSERT INTO any_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Yɛ́ o, bɛ́ o, Nyanmɩan a mgba man nun. Ɔ sanlɩn kɛ b'a le Nyanmɩan b'a li, ɔ'a tɩ bɛ́ ahʋnlɩn nɩn anwʋn. ");
INSERT INTO any_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Ɔ yɔ sɛ mɔ afɩ sian dɩɛ, ɛmɔ kulo kɛ bɛ sɔ Nyanmɩan bɛ nɩan'n? Bɔ́lɛ mɔ yɛ́ nan-mɔ nʋn yɛ́ y'a ngʋala man yɩ́ sʋa'n, bɛ́ kɔmɩn sʋ yɛ̂ ɔ yúe ɔ? ");
INSERT INTO any_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Nan yɛ̂ dɩɛ, yɛ de yɛ di kɛ yɛ́ ti enyan'n mɔ y'a nyan yɩ́ kɛ bɛ́ kʋsʋ b'a nyan yɩ́'n, yɛ́ Mɩn Zozi anwunnvoe'n dunman nun ɔ.” ");
INSERT INTO any_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Mɔ Pɩɛlɩ hanlɩn sɔ'n, bɛ́ kʋalaa bɛ kɔ gua didiin, bɛ kɔ tie Pɔlʋ nʋn Baanabasɩ. Atɛlɛ nʋn asinbɛnwʋn ninnge mɔ Nyanmɩan nanndɩlɩ bɛ́ sʋ ɔ yɔlɩ wɔ bɛ́ mɔ bɛ tɩ man Zufʋ nɩn afian'n, Pɔlʋ nʋn Baanabasɩ kɔ han yɩ́ ɛjɔlɛ bɛ kɔ hele bɛ́. ");
INSERT INTO any_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Mɔ Pɔlʋ nʋn Baanabasɩ anʋan tɔlɩ'n, Zʋakɩ kɔ jasʋ, yɩ́ nwan: “Anianman mmelenzua-mɔ, ɛmɔ tíe mɩ́n! ");
INSERT INTO any_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Kɛ ɔ kpɩnlɩn yɔlɩ mɔ abʋbɔ nɩn anun Nyanmɩan falɩ bɛ́ mɔ bɛ tɩ man Zufʋ nɩn anun mmie-mɔ ɔ'a kaci yɩ́ menian mɔ yɩ́ dunman la bɛ́ sʋ'n, Simʋn a han yɩ́ nwʋn ɛjɔlɛ. ");
INSERT INTO any_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Ɛjɔlɛ'n mɔ ɔ'a han'n, ɔ nʋn mɔ Nyanmɩan mgbɔmanfʋɛ'n-mɔ hanlɩn'n tɩ kʋn. Ɔ sanlɩn kɛ Ɛhɛlɛ Ɛjɔlɛ'n le kele kɛ yɛ́ Mɩn nwan: ");
INSERT INTO any_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","Ɛhɩ anzin, mɩn 'ba sa mɩn ba. Davidi sua'n mɔ ɔ'a bubu ɔ a gua'n, mɩn 'sa mɩn si yɩ́ bʋsʋ nɩn anun ɛsɛ mɩn 'tɩnngɛ yɩ́. ");
INSERT INTO any_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Mɛlɛ sɔ'n, menian bʋ nga'n kʋalaatin, bɛ 'ba kpʋnndɛ yɛ́ Mɩn anzin atɩn. Yuo, bɛ́ kʋalaa mɔ bɛ tɩ man Zufʋ mɔ m'an fɛlɛ bɛ́ kɛ bɛ káci mɩ́n menian'n, bɛ 'ba yɔ yɩ́ sɔ. ");
INSERT INTO any_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Yɛ́ Mɩn m'ɔ yɩlɩ ninnge sɔ'n-mɔ helelɩ daba daba'n, ɛjɔlɛ m'ɔ lɛ kan nɩn anɩn. ");
INSERT INTO any_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","“Ɛhɩka ati, mɩn de mɩn tʋ nun kɛ ɔ tɩ man kpa kɛ bɛ kele bɛ́ mɔ bɛ tɩ man Zufʋ mɔ b'a fa bɛ́ nwʋn b'a wula Nyanmɩan asa nun'n yalɛ. ");
INSERT INTO any_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Nan kʋsʋ, yɛ hɛ́lɛ bɛ́ kalata yɛ hán yɛ héle bɛ́ kɛ nán bɛ di amʋan sʋ naan, nán bɛ di naan bʋka yɩ́ moja'n, nán bɛ di cunmun, ɛsɛ nán bɛ yɔ satɩlɩfʋɛ nyɔlɩɛ. ");
INSERT INTO any_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Afɩ, ɔ fi tɩtɩ, kulo kʋn biala asʋ, menian kan Moyizɩ mala nɩn anun ɛjɔlɛ. Bɛ kɩnnga yɩ́ *ɛnwʋnmɩan ele cɩan daa Zufʋ-mɔ asɔnɩn sua'n-mɔ anun.” ");
INSERT INTO any_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Mɔ Zʋakɩ anʋan tɔlɩ'n, mmɔfʋɛ'n-mɔ nʋn mgbain-mɔ nʋn asɔnɩn mma'n-mɔ kʋalaa anʋan kɔ sɛ bɛ́ nwʋn. Bɛ kɔ yɩ anianman mmie-mɔ bɛ́ afian ɛbɛlɛ mɔ bɛ nʋn Pɔlʋ nʋn Baanabasɩ 'kɔ Antiɔsʋ ɔ. Bɛ́ mɔ bɛ yɩlɩ bɛ́'n-mɔ y'ɔ le Zudɩ mɔ bɛ fɛlɛ yɩ́ Baasabasɩ'n, ɔ nʋn Silasɩ. Zudɩ nʋn Silasɩ tɩ asɔnɩn nɩn anun menian mɔ anianman'n-mɔ fɛlɩ bɛ́ kpa ɔ. ");
INSERT INTO any_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Kalata'n mɔ bɛ falɩ wulalɩ bɛ́ sa nun'n, ɛ 'nwun ɛjɔlɛ m'ɔ wɔ nun'n: Anianman-mɔ, Ɛmɔ mɔ bɛ tɩ man Zufʋ mɔ bɛ wɔ Antiɔsʋ kulo nɩn asʋ, Sili nʋn Silisi mân nɩn anun'n, Zozi mmɔfʋɛ'n-mɔ nʋn asɔnɩn mgbain'n-mɔ mɔ bɛ tɩ ɛmɔ anianman'n, bɛ́ nwan bɛ 'bisa ɛmɔ ahɩn. ");
INSERT INTO any_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Y'a tɩ yɩ́ kɛ menian fi yɛ́ afian ɛwa b'a hɔ a hehele ninnge b'a sɛcɩ ɛmɔ ati anun, ɛsɛ b'a man ɛmɔ lʋa a bɔ bɛ́ nwʋn. Menian sɔ'n-mɔ, nán yɛ́ yɛ̂ yɛ sʋanlɩn bɛ́ ɔ. ");
INSERT INTO any_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Ɛhɩka ati, yɛ́ nʋan a sɛ yɛ́ nwʋn ɛwa, y'a yɩ menian kɛ bɛ hɔ́ tʋ́ ɛmɔ. Bɛ nʋn yɛ́ nianman Pɔlʋ nʋn Baanabasɩ mɔ bɛ́ nwʋn cian yɛ́'n yɛ̂ bɛ lɛ ba ɔ. ");
INSERT INTO any_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Yɛ́ Mɩn Zozi Kilisi dunman nun, ahan menian'n-mɔ 'kun Pɔlʋ nʋn Baanabasɩ. ");
INSERT INTO any_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Ɛjɔlɛ mɔ y'a hɛlɛ yɩ́ ɛwa'n, Zudɩ nʋn Silasɩ muonun, bɛ 'ba han nun ɛjɔlɛ bɛ kele ɛmɔ. ");
INSERT INTO any_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Ɔ sanlɩn kɛ yɛ nʋn Wawɛ Nwannzan-nwannzan'n, yɛ ngulo man kɛ ɛmɔ nwun ɛfɛ kʋ́n. Nan m'ɔ tɩ cɩnnjɩn'n yɛ̂ yɛ lɛ fa yɛ tʋ ɛmɔ anyunnun ɔ. ");
INSERT INTO any_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Ɛhɩka ati, nán bɛ di amʋan sʋ naan, nán bɛ di naan bʋka yɩ́ moja'n, nán bɛ di cunmun. Ɛsɛ nán bɛ yɔ satɩlɩfʋɛ nyɔlɩɛ. Sɛ ɛmɔ yaci nyɔlɩɛ sɔ'n-mɔ gua a, ɔ tɩ kpa. Yɛ wɔ cɩan fʋfɔlɛ! ");
INSERT INTO any_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Ɛhɩ, bɛ kɔ man bɛ́ mɔ bɛ yɩlɩ bɛ́ nɩn atɩn kɛ bɛ hɔ́ Antiɔsʋ. Mɔ bɛ juli ɛlɔ'n, bɛ kɔ yia yɛ́ Mɩn menian'n-mɔ kʋalaatin bɛ kɔ fa kalata'n bɛ kɔ wula bɛ́ sa nun. ");
INSERT INTO any_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Bɛ kɔ kɩnnga kalata'n. Mɔ bɛ tɩlɩ nun ɛjɔlɛ nʋn anwʋnsɛlɛ'n m'ɔ wowulalɩ bɛ́'n, bɛ́ kʋalaa bɛ kɔ li yɩ́ nwʋn fɛ. ");
INSERT INTO any_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Kɛmɔ anɩn Zudɩ nʋn Silasɩ muonun, bɛ tɩ mgbɔmanfʋɛ'n, bɛ kɔ han ɛjɔlɛ dɔʋn bɛ kɔ hele anianman'n-mɔ bɛ kɔ wowula bɛ́ anwʋnsɛlɛ bɛ kɔ cɩcɩ bɛ́ lʋa. ");
INSERT INTO any_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Zudɩ nʋn Silasɩ kɔ li kɔ yɔ ɛlɛnyuan kʋn ɛbɛlɛ. Mɔ bɛ́ ɛhɔlɛ tɛmʋn juli'n, anianman'n-mɔ nʋn bɛ́ bɛ kɔ li ngalɩɛ bɛ kɔ man bɛ́ atɩn bɛ kɔ sa bɔ kɔ hɔ bɛ́ mɔ bɛ sʋanlɩn bɛ́ nɩn anwʋn ɛlɔ.  ");
INSERT INTO any_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Nan Silasɩ dɩɛ, ɔ kɔ ha Antiɔsʋ ɛbɛlɛ. ");
INSERT INTO any_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Pɔlʋ nʋn Baanabasɩ, bɛ́ kʋsʋ bɛ kɔ ha Antiɔsʋ ɛbɛlɛ. Bɛ nʋn mmie-mɔ dɔʋn kpa bɛ kekele menian'n-mɔ ninnge ɛsɛ bɛ kan yɛ́ Mɩn Anʋan Ɛjɔlɛ'n. ");
INSERT INTO any_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","M'ɔ lili kɔ yɔ ɛlɛnyuan kʋn'n, Pɔlʋ kɔ han kɔ hele Baanabasɩ kɛ: “Kulo'n-mɔ kʋalaatin mɔ yɛ sɩnlɩn sʋ yɛ hanlɩn yɛ́ Mɩn Anʋan Ɛjɔlɛ'n, yɛ hɔ́ sʋ yɛ fófua anianman'n-mɔ anwʋn.” ");
INSERT INTO any_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Ɛhɔlɛ nɩn anun an, anɩn Baanabasɩ kulo kɛ Zʋan mɔ bɛ fɛlɛ yɩ́ Maakɩ'n nʋn bɛ́ kɔ. ");
INSERT INTO any_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Pɔlʋ nɩanlɩn an, anɩn ɔ nvata man kɛ Zʋan Maakɩ kɔ bie. Ɔ sanlɩn kɛ, ɔ yacili Pɔlʋ nʋn Baanabasɩ Panfili mân nun, ɔ a mmʋka man bɛ́ junman nɩn anun fɩ́ɩ́ kʋ́n. ");
INSERT INTO any_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Ɛhɩ a, akpʋlʋwa kɔ tɔ Pɔlʋ nʋn Baanabasɩ afian dede bɛ kɔ tɩtɩ bɛ́ nwʋn nun. Baanabasɩ kɔ fa Zʋan Maakɩ bɛ kɔ fʋ meli nun bɛ kɔ hɔ Sipʋlʋ mân nun. ");
INSERT INTO any_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Pɔlʋ kʋsʋ kɔ fa Silasɩ. Mɔ anianman'n-mɔ falɩ bɛ́ wulalɩ yɛ́ Mɩn asa nun yuelɩ'n, cuein, yɛ̂ Pɔlʋ nʋn yɩ́, bɛ hɔlɩ ɔ. ");
INSERT INTO any_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Bɛ kɔ nanndɩ Sili nʋn Silisi mân nɩn anun. Bɛ kɔ wowula asɔnɩn mma'n-mɔ anwʋnsɛlɛ. ");
INSERT INTO any_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Ɔ 'ba yɔ sɔ'n, anɩn Pɔlʋ nʋn Silasɩ b'a hɔ Dɛlɩbʋ nʋn Lisitili. Anɩn yɛ́ Mɩn sʋanlan'n kʋn wɔ Lisitili ɛbɛlɛ. Bɛ fɛlɛ yɩ́ Timote. Yɩ́ nin'n tɩ Zufʋ, ɔ de Nyanmɩan di. Nan yɩ́ sɩ'n tɩ Gɛlɛkɩ. ");
INSERT INTO any_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Anianman'n-mɔ mɔ bɛ wɔ Lisitili ɛbɛlɛ nʋn bɛ́ mɔ bɛ wɔ Ikoninwɔmʋn'n, bɛ kan kɛ Timote tɩ sʋanlan kpa. ");
INSERT INTO any_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Ɛhɩ a, Pɔlʋ nwan ɔ 'fa Timote bɔ yɩ́ nwʋn. Ɔ kɔ fa yɩ́ kɔ bɔ yɩ́ nwʋn. Zufʋ'n-mɔ mɔ bɛ wɔ ɛbɛlɛ etin dɩɛ nɩn asʋ'n dunman nun, Pɔlʋ kɔ man bɛ kɔ kpɛ Timote mmian nun. Ɔ sanlɩn kɛ bɛ́ kʋalaa bɛ sɩ kɛ Timote asɩ'n tɩ Gɛlɛkɩ. ");
INSERT INTO any_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Kulo mɔ bɛ kɔ sɩn sʋ'n, ninnge'n mɔ Zoluzalɛmʋn ɛlɔ asɔnɩn nɩn asʋ mgbain'n-mɔ nʋn mmɔfʋɛ'n-mɔ helelɩ'n, ninnge sɔ'n yɛ̂ bɛ kan bɛ kele anianman'n-mɔ kɛ bɛ lí sʋ ɔ. ");
INSERT INTO any_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Anɩn asɔnɩn mma'n-mɔ dedi'n lɛ kɔ yɩ́ nyunnun, ɛsɛ anɩn bɛ́ nwʋn lɛ sʋn. Afɩ cɩan daa menian fa bɛ́ nwʋn bɛ man yɛ́ Mɩn. ");
INSERT INTO any_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Ɛhɩ anzin, Pɔlʋ nʋn Silasɩ nʋn Timote bɛ kɔ hɔ Azi mân nun. Ɛbɛlɛ, Wawɛ Nwannzan-nwannzan nɩn a mman man bɛ́ atɩn maan b'a ngan man Nyanmɩan Anʋan Ɛjɔlɛ'n. Bɛ kɔ kpɛ nun Filizi nʋn Galasi mân nun. ");
INSERT INTO any_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Mɔ anɩn bɛ ka kaan bɛ ju Misi mân nun'n, bɛ́ nwan bɛ 'kɔ Bitinin mân nun. Nan kʋsʋ Zozi Wawɛ'n ngɔ man bɛ́ atɩn. ");
INSERT INTO any_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Ɛhɩ a, bɛ kɔ kpɛ nun Misi mân nɩn anun, bɛ kɔ hɔ Tolowasɩ kulo nɩn asʋ lɩka mɔ meli'n-mɔ jinlan'n. ");
INSERT INTO any_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Ɛbɛlɛ, kɔngɔɛ, yɛ́ Mɩn kɔ hɩn Pɔlʋ ɛlalɩɛ. Ɛlalɩɛ nɩn anun, Pɔlʋ 'nɩan an, anɩn Masedʋanɩn mân nɩn anun sʋanlan kʋn jin yɩ́ nyunnun ɛbɛlɛ, ɔ lɛ sɛlɛ yɩ́ kɛ: “Sɩn Masedʋanɩn mân nɩn anun ɛwa nán bala bʋka yɛ́!” ");
INSERT INTO any_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Mɔ Pɔlʋ hɩnlɩn ɛlalɩɛ sɔ'n yuelɩ'n, ɛbɛlɛ ala, yɛ kɔ bɔbʋa yɛ́ nwʋn mɔ yɛ 'kɔ Masedʋanɩn ɔ. Ɔ sanlɩn kɛ, anɩn y'a nwun yɩ́ fɔ́ʋ́n kɛ yɛ́ Mɩn lɛ fɛlɛ yɛ́ kɛ yɛ hɔ́ bɔ́ Ɛjɔlɛkpa'n yɛ héle ɛlɔ mân nɩn anun menian'n-mɔ. ");
INSERT INTO any_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Yɛ kɔ fʋ meli nun Tolowasɩ ɛbɛlɛ yɛ̂ cuein, yɛ́ nʋan y'ɔ le asue afian kpɔlɛ'n mɔ bɛ fɛlɛ yɩ́ Samotalasɩ nɩn asʋ. Mɔ alɩ́ɛ hɩnlɩn'n, yɛ kɔ bɔ yɛ́ ti Neyapolisi kulo nɩn asʋ. ");
INSERT INTO any_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Yɛ fi Neyapolisi ɛbɛlɛ yɛ kɔ hɔ kulo'n mɔ bɛ fɛlɛ yɩ́ Filipʋ nɩn asʋ. Filipʋ tɩ Masedʋanɩn alimʋa etin'n kulo, ɛsɛ Lɔmʋn menian wɔ ɛbɛlɛ. Yɛ lili kɔ yɔ ɛlɛsan kʋn kulo sɔ nɩn asʋ. ");
INSERT INTO any_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Mɔ *ɛnwʋnmɩan ele cɩan'n juli'n, yɛ fi kulo nɩn asʋ yɛ kɔ jasʋ. Yɛ kɔ hɔ asue kʋn anʋan. Yɛ yɔlɩ ajʋnlɩn kɛ ɛbɛlɛ yɛ̂ Zufʋ'n-mɔ yia bɛ yɔ asɔnɩn ɔ. Yɛ kɔ tɛtanlan asɩ. Yɛ kɔ han ɛjɔlɛ'n yɛ kɔ hele mmalasua'n-mɔ mɔ anɩn b'a yia ɛbɛlɛ'n. ");
INSERT INTO any_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Mɔ yɛ 'kan ɛjɔlɛ'n, anɩn balasua kʋn lɛ tie. Balasua sɔ'n, bɛ fɛlɛ yɩ́ Lidi. Ɔ fi kulo'n mɔ bɛ fɛlɛ yɩ́ Tiatili nɩn asʋ. Ɔ tɔnɩn ɛtanlan kɔkɔlɛ mɔ yɩ́ nwʋn cian. Ɔ sʋ Nyanmɩan. Yɛ́ Mɩn kɔ buke yɩ́ ajʋnlɩn maan ɔ kɔ yɔ anzʋɛ ɔ kɔ tie ɛjɔlɛ'n mɔ anɩn Pɔlʋ lɛ kan'n. ");
INSERT INTO any_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Bɛ kɔ sɔnɩn yɩ́ nʋn yɩ́ sasʋ'n-mɔ. Mɔ bɛ sɔnɩnlɩn yɩ́ yuelɩ'n, ɔ kɔ fɛlɛ yɛ́, yɩ́ nwan: “Sɛ ɛmɔ de tʋ nun kɛ mɩn de yɛ́ Mɩn mɩn di sakpa a, anɩn ɛmɔ bála a tanlan mɩ́n awulo.” Ɔ si yɛ́ sʋ dede yɛ kɔ kpati yɛ kɔ tie. ");
INSERT INTO any_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Ɛhɩ, mɔ anɩn yɛ lɛ kɔ lɩka mɔ yɛ yɔ asɔnɩn ɛlɔ'n, afanɩan kʋn kɔ a kɔ tʋ yɛ́. Balasua sɔ'n, wawɛ ɛtɛ kʋn wɔ yɩ́ nun. Wawɛ ɛtɛ sɔ'n man ɔ yɩ munnzue ɔ nyan esika dɔʋn kpa man yɩ́ mɩn-mɔ. ");
INSERT INTO any_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Afanɩan'n kɔ si yɛ́ sʋ, yɛ nʋn Pɔlʋ, ɔ lɛ tɩan kan kɛ: “Nyanmɩan'n m'ɔ wɔ anwunno ɛlɔ'n, yɩ́ ngʋa y'ɔ le menian ɛhɩ-mɔ. Atɩn'n mɔ bɛ sɩn sʋ a bɛ nyan bɛ́ ti'n, yɩ́ nwʋn ɛjɔlɛ yɛ̂ bɛ lɛ kan bɛ kele ɛmɔ ɔ!” ");
INSERT INTO any_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Afanɩan'n le yɩ́ sɔ dede kɔ yɔ cɩan nyɛ nyɛ. Yɩ́ bɛ-yue-asɩɛ, yɩ́ nyɔlɩɛ'n kɔ hun Pɔlʋ ɛya. Pɔlʋ kɔ bɩlɩ yɩ́ nyɩn ɔ kɔ han kɔ hele wawɛ ɛtɛ'n kɛ: “Zozi Kilisi dunman nun, mɩ́n nwan ɛ fi balasua nɩn anun ɛ fíte!” Mɔ Pɔlʋ hanlɩn sɔ'n, ɛbɛlɛ ala, wawɛ ɛtɛ'n fi balasua nɩn anun ɔ kɔ fite. ");
INSERT INTO any_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Sian dɩɛ mɔ afanɩan nɩn amɩn-mɔ nɩan an, ɔ nyɩ man munnzue nán b'a nyan esika'n, bɛ kɔ hyʋɩn Pɔlʋ nʋn Silasɩ asɩ dede bɛ nʋn bɛ́ kɔ hɔ lɩka mɔ bɛ di ɛjɔlɛ'n mgbain'n-mɔ aja sʋ. ");
INSERT INTO any_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Bɛ kɔ fa bɛ́ bɛ kɔ hɔ kɔ wula *Lɔmʋn awaa menian'n-mɔ asa nun. Bɛ́ nwan: “Menian ɛhɩ-mɔ lɛ sɛcɩ yɛ́ kulo'n. ");
INSERT INTO any_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Bɛ tɩ Zufʋ, ninnge mɔ bɛ kekele'n, yɛ́ mɔ yɛ tɩ *Lɔmʋn menian'n, yɛ́ mala'n mman man yɛ́ atɩn kɛ yɛ tíe anaan yɛ yɔ́.” ");
INSERT INTO any_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Bagua'n kʋsʋ kɔ jasʋ Pɔlʋ nʋn Silasɩ akɔmɩn anun. Awaa menian'n-mɔ man bɛ kɔ tʋa Pɔlʋ nʋn Silasɩ bɛ kɔ le bɛ́ taladɩɛ'n. Bɛ kɔ man atɩn kɛ bɛ fín bɛ́ mgbele. ");
INSERT INTO any_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Mɔ bɛ finlin bɛ́ mgbele yuelɩ'n, bɛ kɔ gua bɛ́ fiadɩ. Bɛ kɔ han bɛ kɔ hele nzalafʋ'n m'ɔ nɩan fiadɩ nɩn asʋ'n kɛ ɔ sísa bɛ́ kpa. ");
INSERT INTO any_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Mɔ bɛ hanlɩn sɔ bɛ helelɩ nzalafʋ'n, yɩ́ kʋsʋ ɔ kɔ gua bɛ́ fiadɩ sua nɩn akunnun ɛlɔ kpa. Ɔ kɔ fa tabʋa ɔ kɔ bɔ bɛ́ ja kpaun. ");
INSERT INTO any_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Kɔ yɔ alɩmunnun, anɩn Pɔlʋ nʋn Silasɩ lɛ yɔ asɔnɩn bɛ tʋ ejue bɛ yɩ Nyanmɩan ayɛ. Ɛhɩnlɩn-mɔ mɔ bɛ wɔ fiadɩ sua nɩn anun'n, anɩn bɛ lɛ tie. ");
INSERT INTO any_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Kʋnmgba ala, asɩɛ'n kɔ kpusu sɛlɛ kpa dede fiadɩ sua nɩn awulabɛbʋ nɩn anwʋn kɔ han. Ɛbɛlɛ ala, fiadɩ sua nɩn anʋan'n-mɔ kɔ tike tike. Bɛ́ mɔ b'a gua bɛ́ fiadɩ'n-mɔ ngɔnzɔngɔnzɔ'n-mɔ kɔ tɩtɩ tɩtɩ. ");
INSERT INTO any_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Nzalafʋ'n kɔ tinnge. M'ɔ nwunlin kɛ fiadɩ sua nɩn anʋan'n-mɔ gugua sʋ'n, ɔ kɔ hyʋɩn yɩ́ dadɩɛ'n, ɔ 'fa kun yɩ́ nwʋn. Afɩ ɔ jʋnlɩn kɛ anɩn bɛ́ mɔ bɛ wɔ fiadɩ sua nɩn anun nɩn a nwanndi nwanndi. ");
INSERT INTO any_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Mɔ Pɔlʋ nwunlin yɩ́'n, ɔ kɔ tɩan sɛlɛ kpa, yɩ́ nwan: “N'ɛ kun wɔ́ nwʋn! Yɛ́ kʋalaa yɛ wɔ ɛwa!” ");
INSERT INTO any_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Ɛhɩ a, nzalafʋ'n kɔ bisa kɛ bɛ mán yɩ́ kanlannɩɛ. Ndɛ-ndɛ, ɔ kɔ wʋlʋ sua'n mɔ Pɔlʋ nʋn Silasɩ wɔ nun nɩn anun. Esulo kɔ han yɩ́, yɩ́ nwʋn lɛ wʋsʋ yɩ́ ɔ kɔ tu kɔ tɔ Pɔlʋ nʋn Silasɩ aja nun. ");
INSERT INTO any_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","M'ɔ yɔlɩ sɔ'n, ɔ kɔ man Pɔlʋ nʋn Silasɩ kɔ fite. Ɔ kɔ bisa bɛ́ kɛ: “Nja-mɔ, mɩn 'yɔ sɛ nán m'an nyan mɩ́n ti!” ");
INSERT INTO any_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Pɔlʋ nʋn Silasɩ nwan: “De yɛ́ Mɩn Zozi di, ɛ nʋn wɔ́ nwʋn amma'n-mɔ 'ba nyan bɛ́ ti.” ");
INSERT INTO any_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Pɔlʋ nʋn Silasɩ kɔ han yɛ́ Mɩn Anʋan Ɛjɔlɛ'n bɛ kɔ hele yɩ́ nʋn yɩ́ awulo nɩn anun menian'n-mɔ kʋalaatin. ");
INSERT INTO any_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Kɔngɔɛ kpa, dɔɛ sɔ nɩn asʋ, nzalafʋ'n nʋn Pɔlʋ nʋn Silasɩ bɛ kɔ hɔ, ɔ kɔ nwunnzin bɛ́ nwʋn nganlan'n-mɔ anun. Ɔ kɔ man bɛ kɔ sɔnɩn yɩ́ nʋn yɩ́ awulo nɩn anun menian'n-mɔ kʋalaatin. ");
INSERT INTO any_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Ɔ nʋn Pɔlʋ nʋn Silasɩ kɔ hɔ awulo ɔ kɔ man bɛ́ like bɛ kɔ li. Bian sɔ'n nʋn yɩ́ nwʋn amma'n-mɔ kʋalaatin kɔ li fɛ kpa. Ɔ sanlɩn kɛ b'a le Nyanmɩan b'a li. ");
INSERT INTO any_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Mɔ alɩ́ɛ hɩnlɩn'n, Lɔmʋn awaa menian'n-mɔ kɔ yɩ menian kɛ bɛ hɔ́ hán héle nzalafʋ'n kɛ: “Yaci menian sɔ'n-mɔ nun.” ");
INSERT INTO any_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Nzalafʋ'n kɔ a kɔ han kɔ hele Pɔlʋ kɛ: “Mgbain'n-mɔ a man atɩn kɛ bɛ yáci ɛmɔ nun. Yɩ́ ti, ɛmɔ kʋala kɛ bɛ fite bɛ kɔ anzʋnunjɔ nun.” ");
INSERT INTO any_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Ɛhɩ a, Pɔlʋ kɔ han kɔ hele bɛ́ mɔ mgbain'n-mɔ yɩlɩ bɛ́'n kɛ: “Yɛ́ mɔ yɛ tɩ *Lɔmʋn menian'n, b'a mmua man yɛ́ ndɛɛ, b'a bʋ yɛ́ bagua nun ɛsɛ b'a hyɩ yɛ́ b'a gua fiadɩ! Sian anɩn afɩ bɛ kulo kɛ bɛ fɩa bɛ yɩ yɛ́ ɔ? Cɛcɛ! Ɛmɔ hɔ́ hán héle bɛ́ kɛ bɛ́ bɔbɔ muonun bɛ bála a yɩ yɛ́!” ");
INSERT INTO any_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Mɔ Pɔlʋ hanlɩn sɔ'n, menian'n-mɔ kɔ sa kɔ hɔ kɔ tʋ mgbain'n-mɔ bɛ kɔ han ɛjɔlɛ'n sʋa. Mɔ mgbain'n-mɔ tɩlɩ kɛ Pɔlʋ nʋn Silasɩ tɩ Lɔmʋn menian'n, bɛ́ nwʋn kɔ wʋsʋ bɛ́. ");
INSERT INTO any_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Bɛ́ muonun bɛ kɔ a kɔ tʋ Pɔlʋ nʋn Silasɩ. Bɛ kɔ li bɛ́ mgbata. M'ɔ yuelɩ'n, bɛ kɔ yɩ bɛ́ fi fiadɩ sua nɩn anun bɛ kɔ bʋtʋ bɛ́ kɛ bɛ fi kulo nɩn asʋ bɛ tú. ");
INSERT INTO any_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Mɔ Pɔlʋ nʋn Silasɩ fi fiadɩ sua nɩn anun fitelɩ'n, bɛ hɔlɩ Lidi awulo ɛlɔ. Mɔ bɛ nwunlin anianman'n-mɔ anwʋn bɛ wowulalɩ bɛ́ anwʋnsɛlɛ yuelɩ'n, cuein yɛ̂ bɛ hɔlɩ ɔ. ");
INSERT INTO any_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Ɛhɩ, Pɔlʋ nʋn Silasɩ kɔ kpɛ nun kɔ sɩn Anfipolisi nʋn Apolonin kulo nɩn asʋ. Bɛ kɔ hɔ kɔ ju Tesaloninki kulo nɩn asʋ. Tesaloninki ɛbɛlɛ, Zufʋ'n-mɔ le asɔnɩn sua kʋn. ");
INSERT INTO any_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Kɛ Pɔlʋ kpɩn yɔ yɩ́ daa'n, ɔ kɔ hɔ Zufʋ asɔnɩn sua nɩn anun. *Ɛnwʋnmɩan ele cɩan nsan solo sʋ, Pɔlʋ nʋn menian'n-mɔ mɔ anɩn bɛ wɔ asɔnɩn sua nɩn anun'n kɔ han Ɛhɛlɛ Ɛjɔlɛ nɩn anun ɛjɔlɛ. ");
INSERT INTO any_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Pɔlʋ kɔ hehele Ɛhɛlɛ Ɛjɔlɛ nɩn anun kɛ ɔ di kɛ *Kilisi'n nwun yɩ́ nyunnun ɔ wu ɔ fi ewue nun ɔ tinnge. Ɛsɛ ɔ kɔ han kɔ hele bɛ́ kɛ: “Zozi sɔ'n mɔ mɩɩn kan yɩ́ ɛjɔlɛ mɩn kele ɛmɔ'n, yɩ́ dein yɛ̂ ɔ tɩ Kilisi nɩn ɔ.” ");
INSERT INTO any_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Mɔ bɛ tɩlɩ yɩ́ sɔ'n, bɛ́ nun mmie-mɔ lelɩ tʋlɩ nun bɛ falɩ bɛ́ nwʋn bɛ bɔlɩ Pɔlʋ nʋn Silasɩ. Gɛlɛkɩ menian dɔʋn kpa mɔ bɛ sʋ Nyanmɩan'n, bɛ nʋn mmalasua'n-mɔ mɔ bɛ le dibɛlɛ kpa'n, bɛ́ kʋsʋ bɛ kɔ fa bɛ́ nwʋn bɛ kɔ bɔ Pɔlʋ nʋn Silasɩ. ");
INSERT INTO any_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Mɔ Zufʋ'n-mɔ nwunlin yɩ́ sɔ'n, bɛ kɔ fa bɛ́ nwʋn ɛkpɔ. Bɛ kɔ nwun tomgban mmie-mɔ gua nɩn asʋ. Bɛ kɔ hohuan bɛ́ nʋan maan bɛ kɔ tɩ bɛ kɔ wʋlʋ menian'n-mɔ anun bɛ kɔ fannyan kulo'n. Bɛ kɔ hɔ bian kʋn awulo. Bian sɔ'n, bɛ fɛlɛ yɩ́ Zʋasʋn. Bɛ 'kɔ a kpʋnndɛ Pɔlʋ nʋn Silasɩ bɛ fa bɛ́ bɛ fite bagua nɩn anyunnun. ");
INSERT INTO any_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Bɛ kɔ kpʋnndɛ Pɔlʋ nʋn Silasɩ dede bɛ ngɔ nwun man bɛ́. Ɛhɩ a, bɛ kɔ fa bɛ́ ɛjɔlɛ bɛ kɔ gua Zʋasʋn nʋn anianman'n mmie-mɔ anwʋn. Bɛ nʋn bɛ́ kɔ hɔ kulo nɩn asʋ mgbain'n-mɔ aja sʋ. Anɩn bɛ lɛ tɩan bɛ kan kɛ: “Menian ɛhɩ-mɔ a bɔ mân bɔndɩn'n. Sian'n, ɛwa yɛ̂ b'a ju ɔ! ");
INSERT INTO any_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Zʋasʋn a sike bɛ́ yɩ́ awulo! Amanmuo mɔ menian sɔ'n kʋalaa bu'n, ɔ nʋn belemgbin kpain'n mala dɩɛ'n-mɔ tɩ man kʋn. Afɩ bɛ lɛ kele kɛ belemgbin kʋn biekun wɔ ɛbɛlɛ, bɛ fɛlɛ yɩ́ Zozi.” ");
INSERT INTO any_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Mɔ kulo nɩn asʋ mgbain'n-mɔ nʋn bagua'n tɩlɩ ɛjɔlɛ sɔ'n, bɛ́ nwʋn kɔ jue bɛ́. ");
INSERT INTO any_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Mgbain'n-mɔ kɔ bɔ Zʋasʋn nʋn ɛhɩnlɩn-mɔ kalɛ kʋalaaka nán b'a yaci bɛ́ nun. ");
INSERT INTO any_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Mɔ alɩ́ɛ sanlɩn'n, anianman'n-mɔ kɔ man Pɔlʋ nʋn Silasɩ bɛ kɔ hɔ Belee kulo nɩn asʋ. Mɔ bɛ juli ɛlɔ'n, Pɔlʋ nʋn Silasɩ kɔ hɔ Zufʋ'n-mɔ asɔnɩn sua nɩn anun. ");
INSERT INTO any_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Belee ɛbɛlɛ Zufʋ'n-mɔ ati anun tɩ kpa tala Tesaloninki dɩɛ'n-mɔ. Bɛ kɔ yɔ anzʋɛ bɛ kɔ tie Nyanmɩan Anʋan Ɛjɔlɛ'n kpa. Cɩan daa bɛ nɩan Ɛhɛlɛ Ɛjɔlɛ nɩn anun bɛ nɩan sɛ ɛjɔlɛ'n mɔ Pɔlʋ kan'n nʋn yɩ́ tɩ kʋn an. ");
INSERT INTO any_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Bɛ́ nun dɔʋn kpa kɔ le Nyanmɩan Anʋan Ɛjɔlɛ'n kɔ li. Gɛlɛkɩ'n-mɔ anun, mmalasua mɔ bɛ le dibɛlɛ mgbili mgbili'n, bɛ́ nʋn mmelenzua dɔʋn kpa kʋsʋ kɔ fa bɛ́ nwʋn bɛ kɔ man yɛ́ Mɩn. ");
INSERT INTO any_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Nan mɔ Tesaloninki Zufʋ'n-mɔ tɩlɩ kɛ Pɔlʋ lɛ kan Nyanmɩan Anʋan Ɛjɔlɛ'n Belee ɛlɔ'n, bɛ kɔ a bɛ kɔ wowula menian'n-mɔ abʋ bɛ kɔ fannyan kulo'n. ");
INSERT INTO any_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Ɛbɛlɛ ala, anianman'n-mɔ kɔ man Pɔlʋ kɔ bɔ yɩ́ ti asue jenvie nɩn anʋan ɛlɔ. Nan kʋsʋ Silasɩ nʋn Timote halɩ Belee ɛbɛlɛ. ");
INSERT INTO any_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Bɛ́ mɔ anɩn bɛ nʋn Pɔlʋ lɛ kɔ'n, bɛ nʋn yɩ́ hɔlɩ dede bɛ juli Atɛnɩn kulo nɩn asʋ. Mɔ bɛ sielɩ yɩ́ Atɛnɩn ɛbɛlɛ'n yɛ̂ bɛ salɩ hɔlɩ Belee ɔ. Mɔ bɛ 'sa bɛ kɔ'n, Pɔlʋ manlɩn bɛ́ ngalɩɛ kɛ Silasɩ nʋn Timote bála ndɛ-ndɛ ba a tʋ yɩ́ Atɛnɩn ɛbɛlɛ. ");
INSERT INTO any_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Mɔ anɩn Pɔlʋ wɔ Atɛnɩn ɛbɛlɛ ɔ lɛ nwʋnndɛ Silasɩ nʋn Timote'n, kulo nɩn asʋ amʋan nwala nwala nɩn anwʋn ɛya kɔ hun yɩ́ kpa. ");
INSERT INTO any_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Pɔlʋ nʋn Zufʋ'n-mɔ nʋn bɛ́ mɔ bɛ tɩ man Zufʋ mɔ bɛ sʋ Nyanmɩan'n, ɔ nʋn bɛ́ bɛ kan Ɛhɛlɛ Ɛjɔlɛ nɩn anun ɛjɔlɛ bɛ́ asɔnɩn sua nɩn anun. Cɩan daa gua nɩn asʋ, bɛ́ mɔ Pɔlʋ nʋn bɛ́ kɔ yia'n, ɔ kan Nyanmɩan Anʋan Ɛjɔlɛ'n ɔ kele bɛ́. ");
INSERT INTO any_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Epikuli nʋn Ɛsɩtoyiki fâ'n-mɔ asʋ mgbain mmie-mɔ kʋsʋ nʋn Pɔlʋ kɔ jʋjɔ. Anɩn mmie-mɔ lɛ bisa kɛ: “Atɩba ɛhɩ nwan nzɛ?” Anɩn mmie-mɔ a sɔ sʋ kɛ: “Ɔ lɛ kan mmʋsʋɩn ngacile-mɔ anwʋn ɛjɔlɛ”. Bɛ lɛ kan sɔ, afɩ anɩn Pɔlʋ lɛ kan Zozi nʋn yɩ́ ewuetinnge nɩn anwʋn ɛjɔlɛ. ");
INSERT INTO any_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Ɛhɩ a, bɛ kɔ fɛlɛ Pɔlʋ bɛ nʋn yɩ́ kɔ hɔ mgbain'n-mɔ mɔ bɛ sie kulo nɩn anyunnun. Mgbain sɔ'n-mɔ, bɛ fɛlɛ bɛ́ “Ayelopazʋ mma”. Bɛ kɔ bisa Pɔlʋ kɛ: “Asʋ, ɛ kʋala kɛ ɛ kan ngehele fʋfɔlɛ sɔ nɩn anwʋn ɛjɔlɛ kaan kele yɛ́ ɔ? ");
INSERT INTO any_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Ɔ sanlɩn kɛ, ninnge ngacile ngacile'n mɔ ɔ lɛ kan yɩ́ nwʋn ɛjɔlɛ ɛ kele yɛ́'n, yɛ kulo kɛ ɛ tu yɩ́ bʋ.” ");
INSERT INTO any_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Ɔ 'ba yɔ sɔ'n, anɩn Atɛnɩn ɛbɛlɛ, kulomannin nʋn nyɔfʋɛ amannɩɛ ɛbɔ, ɔ nʋn amannɩɛ fʋfɔlɛ etie ala y'ɔ tɩ bɛ́ like mɔ bɛ yɔ ɔ. ");
INSERT INTO any_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Ɛhɩ, Pɔlʋ kɔ jinlan Ayelopazʋ mma'n-mɔ afian, yɩ́ nwan: “Atɛnɩn amma, m'an tʋ mɩ́n nyɩn m'an nɛnɩan dede a, anɩn ɛmɔ tɩ menian mɔ bɛ lɛ kpʋnndɛ Nyanmɩan sakpa. ");
INSERT INTO any_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Afɩ mɛlɛ mɔ mɩn 'kpannza ɛmɔ kulo nɩn asʋ mɩn nɛnɩan ɛmɔ amʋan'n-mɔ ninnge'n, m'an nwun kɛ b'a hɛlɛ b'a gua amʋan sua kʋn anwʋn kɛ: ‘Ɛhɩ tɩ bʋsʋɩn bie mɔ yɛ nzɩ man yɩ́'n dɩɛ.’ Ɩnhɩn! Like sɔ'n mɔ ɛmɔ sʋ yɩ́ nan kʋsʋ ɛmɔ nzɩ man yɩ́'n, yɩ́ nwʋn ɛjɔlɛ yɛ̂ mɩn 'ba han mɩn kele ɛmɔ nɩn ɔ. ");
INSERT INTO any_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","“Nyanmɩan Kpili m'ɔ bɔlɩ mân'n nʋn nun ninnge'n-mɔ kʋalaatin'n, ɔ tɩ anwunno nʋn asɩ'n mɩnlɩan. Sua mɔ sʋanlan kɔ si kɔ man yɩ́'n, nán nun y'ɔ da ɔ. ");
INSERT INTO any_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Ɛsɛ kʋsʋ ɔ'a nze man kɛ sʋanlan gúa yɩ́ nʋan alɩɛ. Ɔ sanlɩn kɛ yɩ́ lɩlɩ yɛ̂ ɔ man kulo menian'n-mɔ kʋalaa ngʋan, ɔ man bɛ de ɛnwʋnmɩan ɔ man bɛ́ ninnge kʋalaatin ɔ. ");
INSERT INTO any_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Ɔ nanndɩ kulo sʋanlan kʋnmgba cein asʋ yɛ̂ ɔ'a bɔ menian'n-mɔ kʋalaa mɔ bɛ wɔ asɩɛ nɩn asʋ nɩn ɔ. Ɛlʋlɔɛ nʋn lɩka mɔ bɛ 'tɛtanlan nɩn ɛyɛɛ ɛyɛɛ, ɔ'a hele yɩ́ kʋalaatin. ");
INSERT INTO any_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Ɔ a yɔ yɩ́ sɔ maan menian'n-mɔ kpʋnndɛ yɩ́, bɛ tʋtʋ bɛ́ sa dede bɛ nwun yɩ́. Afɩ Nyanmɩan wɔ yɛ́ nun kʋn biala anwʋn kʋkʋ. ");
INSERT INTO any_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Ɔ sanlɩn kɛ ‘sɛ yɛ tɩ menian an, ɔ fi yɩ́.’ Ɛjɔlɛ kʋnmgba sɔ'n yɛ̂ ɛmɔ menian'n-mɔ mɔ bɛ kele kalata'n hɛlɛlɩ ɔ. Bɛ́ nwan: ‘Yɛ́ kʋsʋ, yɛ di yɩ́ afilie'n bie.’ ");
INSERT INTO any_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","“Kɛmɔ afɩ yɛ di yɩ́ afilie'n bie'n, nán man yɛ jʋnlɩn kɛ Nyanmɩan tɩ esika ɛmanlan amʋan, jɛtɛ anaan ɛbʋɛ mɔ kulo sʋanlan a bɔ yɩ́ ti anun ɔ'a yɔ ɔ. ");
INSERT INTO any_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Nyanmɩan mmu man mɛlɛ'n mɔ anɩn menian'n-mɔ nzɩ man ɛjɔlɛ fɩ́ɩ́'n kʋ́n. Nan sian dɩɛ, ɔ lɛ fɛlɛ menian'n-mɔ mɔ bɛ wɔ lɩka kʋalaatin'n kɛ bɛ káci bɛ́ abalabɔ'n. ");
INSERT INTO any_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Afɩ, ɔ'a hele cɩan kʋn mɔ ɔ 'ba bua mân bɔndɩn'n ndɛɛ sɛsɛ sʋ ɔ. Yɩ́ ti, ɔ'a yɩ yɩ́ nwʋn sʋanlan. Sʋanlan sɔ'n, ɔ man ɔ fi ewue nun ɔ'a tinnge maan menian'n-mɔ kʋalaa a nwun yɩ́!” ");
INSERT INTO any_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Mɔ Pɔlʋ hanlɩn ewuetinnge ɛjɔlɛ mɔ bɛ tɩlɩ'n, mmie-mɔ kɔ gʋlʋ yɩ́ nwʋn, mmie-mɔ kʋsʋ nwan: “Cɩan fʋfɔlɛ yɛ kɔ tie wɔ́ ɛjɔlɛ sɔ'n.” ");
INSERT INTO any_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Anɩn kɛ ɔ kpɩnlɩn yɔlɩ mɔ Pɔlʋ fi bɛ́ nun ɛbɛlɛ ɔ jasʋlɩ nɩn anɩn. ");
INSERT INTO any_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Nan kʋsʋ, bɛ́ nun mmie-mɔ falɩ bɛ́ nwʋn bɛ bɔlɩ Pɔlʋ ɛsɛ bɛ lelɩ yɛ́ Mɩn bɛ lili. Bɛ́ mɔ bɛ lelɩ yɛ́ Mɩn bɛ lili'n mmie-mɔ y'ɔ le Deninsi m'ɔ wɔ Ayelopazʋ nɩn anun bie'n. Balasua kʋn, bɛ fɛlɛ yɩ́ Damali nʋn mmiekun-mɔ. ");
INSERT INTO any_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Ɛhɩ anzin, Pɔlʋ fi Atɛnɩn ɛbɛlɛ ɔ kɔ hɔ Kolɩntɩ kulo nɩn asʋ. ");
INSERT INTO any_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","M'ɔ juli ɛlɔ'n, ɔ kɔ tʋ Zufʋ belenzua kʋn. Belenzua sɔ'n, bɛ fɛlɛ yɩ́ Akilasɩ. Ɔ fi Pʋn mân nun. Yɩ́ yɩ'n li Pilisili. Bɛlɛ mɔ bɛ fi Itali mân nun ba a ɔ. Ɔ sanlɩn kɛ belemgbin kpain'n mɔ bɛ fɛlɛ yɩ́ Kulodʋ nɩn a han kɛ Zufʋ'n-mɔ kʋalaatin fi Lɔmʋn kulo nɩn asʋ bɛ tú. Pɔlʋ kɔ fa yɩ́ nwʋn kɔ bɔ bɛ́. ");
INSERT INTO any_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Kɛmɔ bɛ́ junman'n mɔ bɛ di'n nʋn Pɔlʋ dɩɛ'n tɩ kʋn'n, afɩ bɛ nwʋn tantɩ, Pɔlʋ nʋn bɛ́ bɛ kɔ tanlan bɛ kɔ li junman. ");
INSERT INTO any_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","*Ɛnwʋnmɩan ele cɩan daa, Pɔlʋ kan Nyanmɩan Anʋan Ɛjɔlɛ'n Zufʋ'n-mɔ asɔnɩn sua nɩn anun. Ɔ kulo kɛ Zufʋ'n-mɔ nʋn bɛ́ mɔ bɛ tɩ man Zufʋ'n de ɛjɔlɛ sɔ'n tʋ nun. ");
INSERT INTO any_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Nan mɔ Silasɩ nʋn Timote fi Masedʋanɩn mân nun bɛ walɩ tʋlɩ Pɔlʋ'n, Nyanmɩan Anʋan Ɛjɔlɛ nɩn ala yɛ̂ anɩn Pɔlʋ kan ɔ. Ɔ kan yɩ́ yuein kele Zufʋ'n-mɔ kɛ Ngʋandefʋɛ'n y'ɔ le Zozi. ");
INSERT INTO any_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Ɛjɔlɛ'n mɔ Pɔlʋ kɔ han'n, Zufʋ'n-mɔ bɔ yɩ. Bɛ kpɛ Pɔlʋ nzʋba. Ɛhɩ a, Pɔlʋ kɔ wʋsʋ yɩ́ taladɩɛ'n-mɔ anun kɔ gua bɛ́ nwʋn, ɔ kɔ han kɔ hele bɛ́ kɛ: “Sɛ ɛmɔ minlin an, ɛmɔ muonun bɛ́ ɛjɔlɛ ɔ. Mɩn nzɩ man nun. Sian dɩɛ, bɛ́ mɔ bɛ tɩ man Zufʋ nɩn anwʋn yɛ̂ mɩɩn kɔ ɔ.” ");
INSERT INTO any_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Mɔ Pɔlʋ hanlɩn sɔ yuelɩ'n, ɔ fi ɛbɛlɛ ɔ kɔ hɔ bian kʋn awulo. Bian sɔ'n, bɛ fɛlɛ yɩ́ Titiyusi Zusutusu. Ɔ sʋ Nyanmɩan. Yɩ́ awulo'n mantan Zufʋ'n-mɔ asɔnɩn sua'n. ");
INSERT INTO any_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Nunhan kʋn, bɛ fɛlɛ yɩ́ Kilisipusi, ɔ tɩ Zufʋ'n-mɔ asɔnɩn sua nɩn asʋ kpain. Ɔ nʋn yɩ́ awulo nɩn anun menian'n-mɔ kʋalaatin bɛ kɔ fa bɛ́ nwʋn bɛ kɔ man yɛ́ Mɩn. Kolɩntɩ ɛbɛlɛ menian dɔʋn mɔ bɛ tɩlɩ ɛjɔlɛ'n mɔ Pɔlʋ hanlɩn'n, bɛ falɩ bɛ́ nwʋn bɛ manlɩn yɛ́ Mɩn ɛsɛ bɛ sɔnɩnlɩn bɛ́. ");
INSERT INTO any_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Ɛhɩ, kɔngɔɛ kʋn, yɛ́ Mɩn kɔ hɩn Pɔlʋ ɛlalɩɛ ɔ kɔ han kɔ hele yɩ́ kɛ: “Pɔlʋ, n'ɛ sulo, nan wɔ́ lɩlɩ kan ɛjɔlɛ'n kɔ wɔ́ nyunnun, n'ɛ muan wɔ́ nʋan. ");
INSERT INTO any_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Ɔ sanlɩn kɛ mɩn nʋn wɔ́ yɛ̂ ɔ san ɔ. Sʋanlan fɩ́ɩ́ ngʋala man kɛ ɔ cɩ wɔ́ ɔ yɔ wɔ́ ɛtɛ. Afɩ mɩ́n menian dɔʋn kpa wɔ kulo ɛhɩka asʋ.” ");
INSERT INTO any_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Mɔ yɛ́ Mɩn hanlɩn sɔ yuelɩ'n, Pɔlʋ tanlanlɩn Kolɩntɩ ɛbɛlɛ afʋɛ kʋn sala nsian ɔ hehelelɩ menian'n-mɔ Nyanmɩan Anʋan Ɛjɔlɛ'n. ");
INSERT INTO any_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Ɛhɩ, mɛlɛ mɔ anɩn Galiʋn tɩ Lɔmʋn kʋnmanna Akayi mân nun'n, Zufʋ'n-mɔ kɔ hɔ Pɔlʋ ati ahuan. Bɛ nʋn yɩ́ kɔ hɔ awaa nun mgbain'n-mɔ aja sʋ. ");
INSERT INTO any_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Bɛ́ nwan: “Atɩn mɔ mala'n ngele man'n yɛ̂ sʋanlan ɛhɩ kele menian'n-mɔ maan bɛ sɩn sʋ bɛ sʋ Nyanmɩan ɔ.” ");
INSERT INTO any_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Nan bɛ hanlɩn ɛhɩ mɔ ahan Pɔlʋ 'buke yɩ́ nʋan'n, Galiʋn kɔ han kɔ hele Zufʋ'n-mɔ kɛ: “Sɛ sʋanlan ehuan ɛjɔlɛ anaan nyɔlɩɛ ɛtɛ bie ɛjɔlɛ a, mɩn 'sie mɩ́n nzʋ mɩn tie ɛmɔ, ɛmɔ Zufʋ'n-mɔ. ");
INSERT INTO any_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Nan kɛmɔ ɔ'a yɔ dunman nʋn ɛmɔ muonun bɛ́ mala nɩn anwʋn akpʋlʋwa esúe ɛjɔlɛ'n, yɩ́ dɩɛ ɛmɔ ɛjɔlɛ ɔ. Mɩn ngulo man kɛ mɩn di ɛjɔlɛ sʋa-mɔ!” ");
INSERT INTO any_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Mɔ Galiʋn hanlɩn sɔ yuelɩ'n, ɔ kɔ hɩhan bɛ́ nun. ");
INSERT INTO any_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Ɛhɩ a, Zufʋ'n-mɔ kʋalaatin kɔ sɔ Sɔsʋtɛnɩn m'ɔ tɩ Zufʋ'n-mɔ asɔnɩn sua nɩn asʋ kpain'n, bɛ kɔ bʋ yɩ́ awaa nun ɛbɛlɛ. Nan mɔ bɛ 'bʋ yɩ́'n, Galiʋn kɔ yɩ yɩ́ nyɩn sʋa tili. ");
INSERT INTO any_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Ɛhɩ anzin, Pɔlʋ hyɛlɩ Kolɩntɩ ɛbɛlɛ kpa. Ɛlɛhʋn kʋn, ɔ kɔ sɛlɛ anianman'n-mɔ atɩn. Mɔ bɛ manlɩn yɩ́ atɩn'n, ɔ nʋn Akilasɩ nʋn Pilisili bɛ kɔ fʋ meli kʋn anun bɛ kɔ hɔ Sili mân nun. Asannan nán b'a tu bɛ́ bʋ'n, Pɔlʋ man bɛ kpalɩ yɩ́ ti'n kulo'n mɔ bɛ fɛlɛ yɩ́ Sankele nɩn asʋ. Ɔ sanlɩn kɛ, ɔ bɔbʋalɩ Nyanmɩan. ");
INSERT INTO any_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Bɛ kɔ hɔ kɔ ju kulo'n mɔ bɛ fɛlɛ yɩ́ Efɛzɩ nɩn asʋ. Ɔ kɔ yaci Akilasɩ nʋn Pilisili ɛbɛlɛ. Ɔ kɔ hɔ Zufʋ'n-mɔ asɔnɩn sua nɩn anun ɔ nʋn bɛ́ bɛ kɔ han Nyanmɩan Anʋan Ɛjɔlɛ'n. ");
INSERT INTO any_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Bɛ kɔ han bɛ kɔ hele Pɔlʋ kɛ ɔ hyɛ́ ɛbɛlɛ kaan. Pɔlʋ nwan cɛcɛ. ");
INSERT INTO any_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Mɔ Pɔlʋ fi bɛ́ nwʋn ɛbɛlɛ ɔ 'kɔ'n, yɩ́ nwan: “Sɛ Nyanmɩan bʋa a, mɩn 'ba sa mɩn ba fua ɛmɔ anwʋn.” Ɔ kɔ fʋ meli nun Efɛzɩ ɛbɛlɛ ");
INSERT INTO any_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","ɔ kɔ hɔ Sezale. Ɔ fi Sezale ɛbɛlɛ ɔ kɔ hɔ asɔnɩn mma nɩn ahɩn ebisa Zoluzalɛmʋn ɛlɔ. Ɔ fi Zoluzalɛmʋn ɔ kɔ hɔ Antiɔsʋ. ");
INSERT INTO any_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Ɔ lili tɛmʋn kaan ɛbɛlɛ. Ɛsɛ ɔ kɔ sa kɔ fa atɩn'n biekun. Ɔ kɔ sɩnsɩn Galasi nʋn Filizi mân nɩn anun kulo kulo'n-mɔ asʋ, ɔ kɔ fofua anianman'n-mɔ kʋalaatin abʋsʋ, ɔ kɔ wowula bɛ́ anwʋnsɛlɛ, ɔ kɔ man bɛ́ dedi'n kɔ hɔ yɩ́ nyunnun. ");
INSERT INTO any_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Ɛhɩ, Zufʋ belenzua kʋn kɔ a kɔ ju Efɛzɩ ɛbɛlɛ. Belenzua sɔ'n bɛ fɛlɛ yɩ́ Apolɔsʋ. Ɔ fi Ezipiti mân nɩn anun kulo'n mɔ bɛ fɛlɛ yɩ́ Alɛgɩzanndili nɩn asʋ. Apolɔsʋ tɩ sʋanlan m'ɔ sɩ jʋjɔ ɛsɛ ɔ sɩ Ɛhɛlɛ Ɛjɔlɛ'n kpa bɔkɔɔ. ");
INSERT INTO any_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Bɛ hanlɩn yɛ́ Mɩn Anʋan Ɛjɔlɛ bɛ helelɩ yɩ́. Ɔ le anwʋnndɛlɛ ɔ kan ɛsɛ ɔ kekele menian'n-mɔ Zozi anwʋn ɛjɔlɛ'n fɔ́ʋ́n. Nan kʋsʋ, Zʋan ɛsɔnɩan dɩɛ nɩn ala y'ɔ sɩ yɩ́ ɔ. ");
INSERT INTO any_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Ɛlɛhʋn kʋn, Zufʋ'n-mɔ asɔnɩn nɩn anun, Apolɔsʋ kɔ han ɛjɔlɛ dede yɩ́ nʋan kɔ tɔ. Mɔ Pilisili nʋn Akilasɩ tɩlɩ ɛjɔlɛ'n mɔ Apolɔsʋ hanlɩn'n, bɛ kɔ fa yɩ́ bɛ kɔ bɔ bɛ́ nwʋn. Bɛ kɔ hehele yɩ́ Nyanmɩan atɩn'n yuein yuein kpa. ");
INSERT INTO any_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","M'ɔ yɔlɩ sɔ'n, Apolɔsʋ yɔlɩ ajʋnlɩn kɛ ɔ 'kɔ Akayi mân nun. Anianman'n-mɔ kɔ wowula yɩ́ anwʋnsɛlɛ. Bɛ kɔ hɛlɛ kalata kɛ ɔ fá mán Kolɩntɩ asɔnɩn mma'n-mɔ. B'a hɛlɛ yɩ́ kalata nɩn anun kɛ bɛ sɔ́ Apolɔsʋ nun kanlanman. Mɔ Apolɔsʋ hɔlɩ juli ɛlɔ'n, bɛ́ mɔ Nyanmɩan a nwun bɛ́ nwʋn anwunnvoe maan b'a kaci yɩ́ menian'n, ɔ bʋkalɩ bɛ́ kpa. ");
INSERT INTO any_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Ɔ sanlɩn kɛ ɔ kan ɛjɔlɛ'n ɔ kekele nun Zufʋ'n-mɔ anyunnun kɛ b'a fʋn. Ɔ le Ɛhɛlɛ Ɛjɔlɛ'n ɔ kele bɛ́ kɛ Zozi y'ɔ tɩ *Kilisi nɩn ɔ. ");
INSERT INTO any_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Ɛhɩ, mɛlɛ mɔ anɩn Apolɔsʋ wɔ Kolɩntɩ'n, Pɔlʋ nanndɩ Azi mân nɩn anun mmʋka'n-mɔ asʋ dede ɔ kɔ a kɔ ju Efɛzɩ kulo nɩn asʋ. M'ɔ juli ɛbɛlɛ'n, ɔ kɔ nwun anianman mmie-mɔ, b'a fa bɛ́ nwʋn b'a man yɛ́ Mɩn. ");
INSERT INTO any_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Pɔlʋ kɔ bisa bɛ́ kɛ: “Kɛ ɛmɔ falɩ bɛ́ nwʋn bɛ manlɩn yɛ́ Mɩn'n, asʋ ɛmɔ a nyan Wawɛ Nwannzan-nwannzan nɩn ɔ?” Mɔ Pɔlʋ bisalɩ bɛ́ sɔ'n, bɛ́ nwan: “Yɛ tɩlɩ man kɛ bɛ fɛlɛ like bie Wawɛ Nwannzan-nwannzan bɔbɔ.” ");
INSERT INTO any_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Ɛhɩ a, Pɔlʋ kɔ bisa bɛ́ kɛ: “Anɩn ɛsɔnɩan benin yɛ̂ bɛ sɔnɩnlɩn ɛmɔ ɔ?” Bɛ́ nwan: “Zʋan ɛsɔnɩan dɩɛ'n yɛ̂ b'a sɔnɩn yɛ́ ɔ.” ");
INSERT INTO any_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Mɔ bɛ hanlɩn sɔ'n, Pɔlʋ nwan: “Bɛ́ mɔ bɛ kɔ kaci bɛ́ abalabɔ'n mɔ bɛ kɔ fa bɛ́ nwʋn bɛ kɔ man Nyanmɩan'n, bɛ́ yɛ̂ Zʋan sɔnɩn bɛ́ ɔ. Ɛsɛ anɩn ɔ lɛ kan kele Izalayɛ mân'n kɛ sʋanlan kʋn fi yɩ́ nzin ɔ lɛ ba. Sʋanlan sɔ'n m'ɔ di kɛ bɛ de yɩ́ bɛ di'n, bɛ fɛlɛ yɩ́ Zozi.” ");
INSERT INTO any_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Mɔ Pɔlʋ hanlɩn sɔ mɔ bɛ tɩlɩ'n, bɛ kɔ man bɛ kɔ sɔnɩn bɛ́ wɔ yɛ́ Mɩn Zozi dunman nun. ");
INSERT INTO any_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Mɔ bɛ sɔnɩnlɩn bɛ́ yuelɩ'n, Pɔlʋ kɔ fa yɩ́ sa'n kɔ fua bɛ́ nwʋn bɛ kɔ nyan Wawɛ Nwannzan-nwannzan'n. Bɛ kɔ han anɩɛ ngacile ngacile ɛsɛ Nyanmɩan kɔ fa ɛjɔlɛ kɔ wula bɛ́ nʋan bɛ kɔ han. ");
INSERT INTO any_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Bɛ tɩ kɔ yɔ menian bulu nʋn nnyuan. ");
INSERT INTO any_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Ɛhɩ anzin, Pɔlʋ kɔ hɔ Zufʋ'n-mɔ asɔnɩn sua nɩn anun. Ɛbɛlɛ asʋ sala nsan, ɔ nzulo man nun, ɔ kan Nyanmɩan Belemgbin Mân nɩn anwʋn ɛjɔlɛ ɔ kele bɛ́ maan bɛ́ kʋsʋ bɛ de bɛ di. ");
INSERT INTO any_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Ɛjɔlɛ'n mɔ Pɔlʋ kan'n nvalɩ man mmie-mɔ anwʋn ɛsɛ bɛ ngulo man kɛ bɛ de bɛ di. Bɛ kan yɛ́ Mɩn atɩn nɩn anwʋn ɛjɔlɛ ɛtɛ ɛtɛ asɔnɩn sua nɩn anun. Ɛhɩ ati, Pɔlʋ kɔ yaci bɛ́. Ɔ nʋn bɛ́ mɔ b'a le yɛ́ Mɩn b'a li'n kɔ hɔ. Anɩn sukulu kʋn wɔ ɛbɛlɛ, bɛ fɛlɛ yɩ́ Tilanunsi sukulu. Sukulu sɔ nɩn anun yɛ̂ cɩan daa Pɔlʋ kan Nyanmɩan Anʋan Ɛjɔlɛ nɩn ɔ. ");
INSERT INTO any_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Ɔ helelɩ like ɛbɛlɛ dede afʋɛ nnyuan. Ɔ man bɛ́ kʋalaa mɔ bɛ wɔ Azi mân nɩn anun'n, Zufʋ o, bɛ́ mɔ bɛ tɩ man Zufʋ o, bɛ tɩlɩ yɛ́ Mɩn Anʋan Ɛjɔlɛ'n. ");
INSERT INTO any_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Ɛhɩ, anɩn Nyanmɩan nanndɩ Pɔlʋ sʋ ɔ yɔ asinbɛnwʋn ninnge mgbili mgbili kpa. ");
INSERT INTO any_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Ɔ man hanmɩntɩ duku anaan ɛtanlan m'ɔ kɔ han Pɔlʋ anwʋnnaan'n, sɛ bɛ fa bɛ kan nwuluwafʋɛ'n-mɔ a, nwuluwafʋɛ'n-mɔ anwʋn sa, ɛsɛ wawɛ ɛtɛ'n-mɔ fi bɛ́ nun tu. ");
INSERT INTO any_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Ɔ 'ba yɔ sɔ'n, anɩn Zufʋ mmie-mɔ kɔ kulo kulo'n-mɔ asʋ bɛ fʋan wawɛ ɛtɛ'n-mɔ fi nwuluwafʋɛ'n-mɔ anun. Zufʋ sɔ'n-mɔ kʋsʋ nwan bɛ 'fa yɛ́ Mɩn Zozi dunman'n bɛ fʋan wawɛ ɛtɛ'n-mɔ. Yɩ́ ti, bɛ kan bɛ kele wawɛ ɛtɛ'n-mɔ kɛ: “Zozi mɔ Pɔlʋ kan yɩ́ ɛjɔlɛ'n dunman nun, mɩ́n nwan ɛmɔ fíte!” ");
INSERT INTO any_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Bɛ́ mɔ anɩn bɛ lɛ di junman sɔ'n, bɛ tɩ mma mmelenzua nsʋ. Bɛ́ sɩ'n li Seva, ɔ tɩ Zufʋ'n-mɔ anun tɛɛyɩfʋɛ kpain'n kʋn. ");
INSERT INTO any_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Mɔ bɛ hanlɩn sɔ'n, wawɛ ɛtɛ'n nwan: “Mɩn sɩ Zozi ɛsɛ mɩn sɩ Pɔlʋ kʋsʋ. Nan ɛmɔ, nwan menian dɩɛ y'ɔ le ɛmɔ?” ");
INSERT INTO any_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Ɛhɩ a, sʋanlan'n mɔ wawɛ ɛtɛ'n wɔ yɩ́ nun'n kɔ tɩ kɔ tɔ bɛ́ sʋ. Yɩ́ sa kɔ hʋala bɛ́ kʋalaatin, ɔ kɔ hele bɛ́ yalɛ kpa dede bɛ fi sua nɩn anun bɛ 'nwanndi a, anɩn bɛ́ nwʋn gua sʋ b'a bʋta bʋta. ");
INSERT INTO any_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Efɛzɩ amma, Zufʋ o, m'ɔ tɩ man Zufʋ o, bɛ́ kʋalaa bɛ kɔ tɩ ɛjɔlɛ sɔ'n, esulo kɔ han bɛ́. Ɛsɛ bɛ kɔ man yɛ́ Mɩn Zozi anyɩnnzɔ kpa. ");
INSERT INTO any_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Bɛ́ dɔʋn mɔ bɛ falɩ bɛ́ nwʋn bɛ manlɩn yɛ́ Mɩn'n, bɛ ba bɛ kan bɛ́ nyɔlɩɛ ɛtɛ'n-mɔ bagua nɩn anun. ");
INSERT INTO any_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Menian'n-mɔ dɔʋn mɔ anɩn bɛ yɩ jiliwa'n nʋn bɛ́ jiliwa kalata'n-mɔ kɔ a. Bɛ kɔ yala yɩ́ menian'n-mɔ kʋalaa anyunnun ɛbɛlɛ. Bɛ kɔ sɩsɩn bɛ kɔ nwun kalata sɔ'n-mɔ gua, ɔ tɩ esika jɛtɛ mma akpɩɩ abulanun. ");
INSERT INTO any_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Anɩn kɛ ɔ kpɩnlɩn yɔlɩ mɔ tunmin sʋ nʋn anwʋnsɛlɛ sʋ yɛ́ Mɩn Anʋan Ɛjɔlɛ'n tɛlɛlɩ nɩn anɩn. ");
INSERT INTO any_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Ɛhɩ anzin, Pɔlʋ kɔ fua kɛ ɔ 'kpɛ nun Masedʋanɩn nʋn Akayi mân nɩn anun ɔ kɔ Zoluzalɛmʋn. Ɛhɩka ati, yɩ́ nwan: “Sɛ mɩn kɔ mɩn ju ɛlɔ a, ɔ di kɛ mɩn kɔ Lɔmʋn kʋsʋ.” ");
INSERT INTO any_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Ɛhɩ a, ɔ kɔ sʋan yɩ́ mmʋkafʋɛ'n-mɔ anun nnyuan, Timote nʋn Elasɩtɩ. Nan yɩ́ muonun yɩ́ Pɔlʋ, ɔ kɔ ha Azi mân nɩn anun ɛbɛlɛ kaan biekun. ");
INSERT INTO any_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Mɛlɛ sɔ'n, yɛ́ Mɩn Anʋan Ɛjɔlɛ'n dunman nun, Efɛzɩ kulo'n kɔ fannyan. ");
INSERT INTO any_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Anɩn bian kʋn wɔ ɛbɛlɛ, bɛ fɛlɛ yɩ́ Demetiliyusi. Ɔ tɩ junnvʋɛ. Ɔ fa jɛtɛ ɔ bɔ bʋsʋɩn balasua'n mɔ bɛ fɛlɛ yɩ́ Aateminsi'n sua mma mma. Ɔ nʋn bɛ́ mɔ bɛ di junman sɔ'n nyan nun esika kpili kpa. ");
INSERT INTO any_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Ɛlɛhʋn kʋn, Demetiliyusi kɔ yia yɩ́ menian'n-mɔ nʋn junnvʋɛ ɛhɩnlɩn-mɔ. Ɔ kɔ fa kɔ tʋ bɛ́ nyunnun kɛ: “Ebia-mɔ, ɛmɔ sɩ kɛ yɛ́ ɛkpasie'n fi junman ɛhɩ. ");
INSERT INTO any_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Nan kʋsʋ, like mɔ bian'n mɔ bɛ fɛlɛ yɩ́ Pɔlʋ yɔ'n, ɛmɔ tɩ ɛsɛ ɛmɔ nwun yɩ́. Nán kɛ Efɛzɩ ɛwa angʋnmɩn ɔ, nan Azi mân'n kʋalaa anun, Pɔlʋ sɔ'n nanndɩ nun ɔ kan kɛ amʋan'n mɔ menian'n-mɔ sɔ'n, ɔ tɩ mgban. Menian dɔʋn a le yɩ́ ɛjɔlɛ nɩn a tʋ nun. ");
INSERT INTO any_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Ɛjɔlɛ sɔ'n kʋala kɛ ɔ man yɛ́ junman'n tɔ, ɛsɛ ɔ kʋala kɛ ɔ man bʋsʋɩn kpili Aateminsi sua'n m'ɔ le dunman'n minlin. Bʋsʋɩn Aateminsi mɔ Azi mân nɩn anun nʋn eyuadɩ nɩn anun bɛ́ kʋalaa bɛ sɔ'n, sʋanlan fɩ́ɩ́ lɛ ngɔ bɔ yɩ́ dunman kʋ́n!” ");
INSERT INTO any_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Mɔ Demetiliyusi hanlɩn sɔ mɔ bɛ tɩlɩ'n, ɛya kɔ a, anɩn bɛ lɛ tɛtɩan bɛ kan kɛ: “Efɛzɩ amma, yɛ́ bʋsʋɩn Aateminsi'n tɩ kpili o! Efɛzɩ amma yɛ́ bʋsʋɩn Aateminsi'n tɩ kpili o!” ");
INSERT INTO any_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Ɛjɔlɛ sɔ'n kɔ fannyan kulo bɔndɩn nɩn anun. Bɛ́ kʋalaa bɛ kɔ tu woo bɛ kɔ hyʋɩn Gayiyusi nʋn Alisitakɩ, bɛ́ nʋan y'ɔ le lɩka mɔ bɛ yia bɛ kan bɛ́ ngɔhʋa'n. Gayiyusi nʋn Alisitakɩ fi Masedʋanɩn mân nun. Bɛ tɩ Pɔlʋ amanngʋn. Bɛ nʋn yɩ́ yɛ̂ ɔ kɔ yɩ́ atɩn'n-mɔ. ");
INSERT INTO any_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Pɔlʋ kulo kɛ ahan ɔ fite bagua nɩn anyunnun, nan yɛ́ Mɩn menian'n-mɔ a mman man yɩ́ atɩn. ");
INSERT INTO any_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Yɩ́ manngʋn mmie-mɔ kɔ bɛlɛ yɩ́ ngalɩɛ kɛ n'ɔ kɔ lɩka mɔ menian'n-mɔ a yia'n. Yɩ́ manngʋn sɔ'n-mɔ fi Azi mân nɩn anun, bɛ di awaa junman. ");
INSERT INTO any_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Tɛmʋn sɔ'n, anɩn lɩka mɔ b'a yia ɛlɔ a yɔ beje beje kpa. Menian mmie-mɔ lɛ tɩan bɛ kan ɛjɔlɛ kʋn, anɩn mmie-mɔ kʋsʋ lɛ tɩan bɛ kan ɛjɔlɛ fʋfɔlɛ. Bɛ́ nun mmie-mɔ dɔʋn nzɩ man like mɔ yɩ́ ti yɛ̂ b'a yia'n bɔbɔ. ");
INSERT INTO any_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Ɛhɩ a, bɛ kɔ sʋsɔ ɛjɔlɛ nɩn asʋ bɛ kɔ han bɛ kɔ hele Zufʋ bian kʋn. Bian sɔ'n, bɛ fɛlɛ yɩ́ Alɛgɩzanndɩlɩ. Anɩn Zufʋ'n-mɔ lɛ wowula yɩ́ bʋ kɛ ɔ fíte bagua nɩn anyunnun. Mɔ Alɛgɩzanndɩlɩ fitelɩ bagua nɩn anyunnun'n, ɔ kɔ tʋ yɩ́ sa kɛ bɛ gúa diin nán ɔ 'kan ɛjɔlɛ ɔ kele bɛ́. ");
INSERT INTO any_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Mɔ menian'n-mɔ nwunlin kɛ ɔ tɩ Zufʋ'n, bɛ́ kʋalaa bɛ́ bʋ kɔ yɔ kʋn bɛ lɛ tɩan bɛ kan kɛ: “Efɛzɩ amma, yɛ́ bʋsʋɩn Aateminsi'n tɩ kpili o! Efɛzɩ amma, yɛ́ bʋsʋɩn Aateminsi'n tɩ kpili o!” Bɛ le ɛtɩan sʋa dede kɔ yɔ dɔhyʋɩlɩ nnyuan. ");
INSERT INTO any_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Yɩ́ bɛ-yue-asɩɛ, kulo nɩn asʋ kpɔmanfʋɛ'n kɔ yɔ kɔ man bɛ kɔ gua bɛ́ ahʋnlɩn asɩ. Yɩ́ nwan: “Efɛzɩ amma, sʋanlan benin y'ɔ nzɩ man kɛ Efɛzɩ kulo'n yɛ̂ ɔ sisa bʋsʋɩn kpili Aateminsi sua'n nʋn yɩ́ abaaba'n m'ɔ fi nyanmɩansʋ ɔ'a ju nɩn ɔ? ");
INSERT INTO any_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Sʋanlan fɩ́ɩ́ ngʋala ɔ nzu man yɩ́ nwʋn akpʋlʋwa. Yɩ́ ti, ɛmɔ gúa bɛ́ ahʋnlɩn asɩ nán b'a nzɛcɩ man like. ");
INSERT INTO any_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Ɔ sanlɩn kɛ menian'n-mɔ mɔ ɛmɔ nʋn bɛ́ a a ɛwa'n, b'a nwua man amʋan sua'n-mɔ anun ninnge, ɛsɛ b'a ngan man bʋsʋɩn Aateminsi kʋsʋ anwʋn ɛjɔlɛ ɛtɛ. ");
INSERT INTO any_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Sɛ Demetiliyusi nʋn yɩ́ junnvʋɛ'n-mɔ kulo kɛ bɛ sanman sʋanlan an, ɔ le cɩan mɔ mgbain'n-mɔ tanlan asɩ bɛ di ɛjɔlɛ ɔ. Anɩn lɩka mɔ bɛ kʋala kɛ bɛ nʋn bɛ́ ɛjɔlɛ'n kɔ nɩn anɩn! ");
INSERT INTO any_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Sɛ Ɛjɔlɛ biekun wɔ ɛbɛlɛ a, anɩn mgbain'n-mɔ yia a, ɛmɔ kɔ fa kɔ tʋ bɛ́ nyunnun. ");
INSERT INTO any_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Afɩ like mɔ y'a yɔ yɩ́ ɛnɛ'n, bɛ kʋala kɛ bɛ tʋn yɛ́ ɛsʋan kɛ y'a jasʋ awaa akɔmɩn anun. Ɔ sanlɩn kɛ, sɛ bɛ bisa yɛ́ like mɔ yɩ́ ti yɛ̂ y'a yia nɩn an, yɛ ngɔ hʋala man yɩ́ nʋan tu nán y'a sa yɛ́ nɩn.” ");
INSERT INTO any_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Mɔ kpɔmanfʋɛ'n hanlɩn sɔ yuelɩ'n, ɔ kɔ man bɛ kɔ sanndɩ. ");
INSERT INTO any_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Ɛhɩ, ɔ yɔlɩ mɔ kulo nɩn anun gualɩ diin'n, Pɔlʋ kɔ yia yɛ́ Mɩn menian'n-mɔ. Ɔ kɔ wowula bɛ́ anwʋnsɛlɛ, ɔ nʋn bɛ́, bɛ kɔ li ngalɩɛ, cuein yɛ̂ ɔ hɔlɩ Masedʋanɩn mân nun ɔ. ");
INSERT INTO any_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Ɔ kɔ nanndɩ ɛbɛlɛ mân sɔ nɩn anun ɔ kɔ han ɛjɔlɛ dɔʋn ɔ kɔ wowula yɛ́ Mɩn menian'n-mɔ anwʋnsɛlɛ. Mɔ Pɔlʋ wowulalɩ bɛ́ anwʋnsɛlɛ yuelɩ'n, ɔ kɔ hɔ Gɛlɛsɩ mân nun ");
INSERT INTO any_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","ɔ kɔ li ɛbɛlɛ sala nsan. Mɛlɛ mɔ ahan ɔ fi ɛbɛlɛ ɔ 'kɔ Sili mân nun'n, bɛ kɔ yɩ yɩ́ anzʋti kɛ Zufʋ'n-mɔ a hɔ yɩ́ ti ahuan. Ɛhɩ a, Pɔlʋ kɔ yɔ ajʋnlɩn kɛ ɔ di kɛ ɔ sa yɩ́ nzin ɔ sɩn Masedʋanɩn mân nun. ");
INSERT INTO any_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Mɔ ɔ 'ba'n, menian mɔ bɛ walɩ somanlɩn yɩ́ dede bɛ juli Azi mân nun'n y'ɔ le Sopatɛɛ m'ɔ fi Belee kulo nɩn asʋ mɔ yɩ́ sɩ y'ɔ le Pilusi'n, Alisitakɩ nʋn Segʋndusi mɔ bɛ fi Tesaloninki kulo nɩn asʋ'n, Gayiyusi m'ɔ fi Dɛlɩbʋ kulo nɩn asʋ'n nʋn Timote, Tisiki nʋn Tolofimʋn mɔ bɛ fi Azi mân nun'n. ");
INSERT INTO any_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Bɛ kɔ li mʋa yɛ́ nyunnun Tolowasɩ kulo nɩn asʋ bɛ lɛ nwʋnndɛ yɛ́ ɛbɛlɛ. ");
INSERT INTO any_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Mɔ bɛ lili *Pakɩ fɛtɩ'n yuelɩ'n, mɩ́n nʋn Pɔlʋ yɛ kɔ tu yɛ́ bʋ Filipʋ kulo nɩn asʋ. Yɛ la asue nyɩnsʋ dede cɩan nnun nán y'a ju Tolowasɩ y'a tʋ ɛhɩnlɩn-mɔ. Mɔ yɛ juli Tolowasɩ'n, yɛ lili ɛbɛlɛ mɔlɛ kʋn. ");
INSERT INTO any_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Ɛhɩ, mɔlɛ'n, yɛ yialɩ yɛ́ Mɩn alɩɛ nɩn anwʋn. Pɔlʋ kɔ han ɛjɔlɛ ɔ kɔ hele asɔnɩn mma'n-mɔ. Kɛmɔ alɩ́ɛ cɩn an, anɩn ɔ di kɛ Pɔlʋ kɔ'n, ɔ kɔ han ɛjɔlɛ dede bɛ kɔ bɔ kɔ yɔ alɩmunnun. ");
INSERT INTO any_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Anɩn kanlannɩɛ dɔʋn kpa wɔ awaa nɩn asʋ sua'n mɔ y'a yia nun nɩn anun. ");
INSERT INTO any_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Mɛlɛ mɔ Pɔlʋ 'kan ɛjɔlɛ'n, anɩn kpafɛlɛ kʋn tɩ mɛnzɛlɛ nɩn anʋan ɔ lɛ dafɩ kpa. Kpafɛlɛ sɔ'n, bɛ fɛlɛ yɩ́ Etisusi. Etisusi fi awaa'n m'ɔ wɔ sʋ ngʋkʋn ngʋkʋn nsan'n, ɔ kɔ tɔ asɩ. Bɛ 'kuku yɩ́ sʋ a, Etisusi a wu. ");
INSERT INTO any_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Ɛhɩ a, Pɔlʋ kɔ ju asɩ ɔ kɔ han yɩ́ nwʋn asɩ ɔ kɔ fa Etisusi yɩ́ sa sʋ, yɩ́ nwan: “Nán bɛ di yalɛ, ɔ sanlɩn kɛ ɔ wuli man!” ");
INSERT INTO any_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","M'ɔ yɔlɩ sɔ'n, Pɔlʋ salɩ fʋlɩ awaa nɩn asʋ. Ɔ kɔ bu kpaʋn'n ɔ kɔ li. Ɔ kɔ han ɛjɔlɛ dede alɩ́ɛ kɔ hɩn. Mɔ alɩ́ɛ hɩnlɩn'n yɛ̂ ɔ hɔlɩ ɔ. ");
INSERT INTO any_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Kpafɛlɛ'n dɩɛ, bɛ nʋn yɩ́ 'ba a, anɩn yɩ́ nyɩn wɔ sʋ. Ɔ man bɛ́ kʋalaa bɛ́ lʋa cɩcɩlɩ kpa. ");
INSERT INTO any_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Ɛhɩ, Pɔlʋ kɔ fa bɛ́ ja nun atɩn'n m'ɔ kɔ kulo'n mɔ bɛ fɛlɛ yɩ́ Asɔsʋ nɩn asʋ. Yɛ́ dɩɛ, yɛ kɔ fʋ meli nun yɛ kɔ li mʋa yɩ́ nyunnun Asɔsʋ ɛlɔ. Afɩ Pɔlʋ helelɩ kɛ yɛ yía ɛbɛlɛ nán y'a fa yɩ́ meli nɩn anun. ");
INSERT INTO any_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Mɔ Pɔlʋ walɩ tʋlɩ yɛ́ Asɔsʋ ɛbɛlɛ'n nán y'a fa yɩ́ meli nɩn anun y'a hɔ kulo'n mɔ bɛ fɛlɛ yɩ́ Mintilɛnɩn nɩn asʋ. ");
INSERT INTO any_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Yɛ juli Mintilɛnɩn mɔ alɩ́ɛ hɩnlɩn'n, yɛ la sʋ dede yɛ kɔ ju kulo'n mɔ bɛ fɛlɛ yɩ́ Kio nɩn anʋan nun. Alɩ́ɛ hɩnlɩn biekun, yɛ kɔ ju kulo'n mɔ bɛ fɛlɛ yɩ́ Samɔsʋ nɩn asʋ. Alɩ́ɛ hɩnlɩn biekun, yɛ kɔ ju kulo'n mɔ bɛ fɛlɛ yɩ́ Minle nɩn asʋ. ");
INSERT INTO any_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Afɩ Pɔlʋ fualɩ kɛ bɛ ju Efɛzɩ kulo nɩn asʋ ɛbɛlɛ a, bɛ njinlan man nán b'a nga man Azi mân nɩn anun ɛbɛlɛ. Kɛ ɔ kɔ yɔ nán ɔ'a ju Zoluzalɛmʋn kulo nɩn asʋ ndɛ *Pantekɔtʋ fɛtɩ cɩan'n, ɛhɩ yɛ̂ anɩn Pɔlʋ lɛ jʋnlɩn ɔ. ");
INSERT INTO any_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Mɔ yɛ juli Minle'n, Pɔlʋ kɔ tʋ Efɛzɩ asɔnɩn nɩn asʋ mgbain'n-mɔ ngalɩɛ kɛ bɛ bála a tʋ yɛ́ Minle ɛbɛlɛ. ");
INSERT INTO any_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Bɛ walɩ juli ɛbɛlɛ a, Pɔlʋ nwan: “Ɔ bɔ yɩ́ bʋ alimʋa cɩan mɔ n juli Azi mân nɩn anun'n, kɛ m gbɩnlɩn mɩn nʋn ɛmɔ yɛ nanndɩlɩ'n, ɛmɔ sɩ. ");
INSERT INTO any_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","M'an bɛbɛlɛ mɩn nwʋn yɛ́ Mɩn ɛsʋ́ɛ nɩn anun, mɩn tɩtɩ mɩ́n nyɩn ɛmʋɩn mɩ́n sa nun, ɛsɛ Zufʋ'n-mɔ man n nwunlin amannɩnhunlun. Ɔ sanlɩn kɛ anɩn bɛ kɔ mɩ́n ti ahuan. ");
INSERT INTO any_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Ɛmɔ sɩ kɛ like m'ɔ tɩ kpa man ɛmɔ'n, m'an va man fɩ́ɩ́ m'an vɩa man ɛmɔ. M'an han yɩ́ kʋalaa m'an hele ɛmɔ bagua nun ɔ nʋn ɛmɔ awulo'n-mɔ anun. ");
INSERT INTO any_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","M'an han m'an hele bɛ́ mɔ bɛ tɩ Zufʋ nʋn bɛ́ mɔ bɛ tɩ *Gɛlɛkɩ'n kɛ bɛ nún bɛ́ nwʋn bɛ káci bɛ́ abalabɔ'n wɔ Nyanmɩan anwʋn ɛsɛ bɛ lé yɛ́ Mɩn Zozi Kilisi bɛ lí. ");
INSERT INTO any_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","“Kɩkaala dɩɛ, n dɩ kɛ sʋanlan mɔ b'a cɩcɩ yɩ́ ɔ, Wawɛ Nwannzan-nwannzan'n lɛ cʋɩn mɩ́n kɔ Zoluzalɛmʋn, mɩn nzɩ man ɛjɔlɛ mɔ ɔ 'ba tʋ mɩ́n ɛlɔ ɔ. ");
INSERT INTO any_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Mɔ mɩn sɩ nɩn ala y'ɔ le kɛ, kulo biala mɔ n gɔ ju sʋ'n, Wawɛ Nwannzan-nwannzan'n kan kele mɩ́n kɛ bɛ lɛ ba tʋ mɩ́n fiadɩ ɛsɛ mɩn 'ba nwun nyinlinlin. ");
INSERT INTO any_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Nan mɩ́n dɩɛ, nán mɩ́n ngʋan'n y'ɔ tɩ mɩ́n cɩnnjɩn ɔ. Nyanmɩan anwunnvoe ɛsɩ́ɛ Ɛjɔlɛkpa'n mɔ yɛ́ Mɩn Zozi a fa a wula mɩ́n sa nun kɛ m mɔ́ n géle menian'n-mɔ'n, kɛ ɔ kɔ yɔ nán m'an li junman sɔ'n dede m'an gua yɩ́ bʋ'n, ɛhɩ y'ɔ tɩ mɩn cɩnnjɩn ɔ. ");
INSERT INTO any_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","“Sian dɩɛ, mɩn sɩ kɛ ɛmɔ mɔ m'an tanlan ɛmɔ afian m'an bɔ Nyanmɩan Belemgbin Mân nɩn anwʋn ɛjɔlɛ m'an hele ɛmɔ'n, ɛmɔ lɛ ngɔ nwun man mɩ́n nyunnun kʋ́n. ");
INSERT INTO any_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Yɩ́ ti, mɩɩn kan mɩn kele ɛmɔ ɛnɛ kɛ ɛmɔ anun kʋn m'ɔ kɔ minlin'n, mɩn nzɩ man yɩ́ ɛjɔlɛ nun. ");
INSERT INTO any_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Ɔ sanlɩn kɛ Nyanmɩan afʋtu'n kʋalaatin, m'an tu ɛmɔ, m'an nva man fɩ́ɩ́ m'an nvɩa man ɛmɔ. ");
INSERT INTO any_vpl VALUES ("AC20_28","074_20_28","ACT","20","28",