﻿USE sofia;
DROP TABLE IF EXISTS sofia.anvNT_vpl;
CREATE TABLE anvNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES anvNT_vpl WRITE;
INSERT INTO anvNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Gɛ́ ŋwɛ mabɔ ukwéne antɛ Jisɔs Kras mpyáne mfwa Dɛvid, Dɛvid mpyáne Abraham. ");
INSERT INTO anvNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham alu ntɛ Asek, Asek alu ntɛ Jakɔb, Jakɔb alu ntɛ Juda ne aŋmɛ́ bií abi ande. ");
INSERT INTO anvNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Ne Juda alu ntɛ Pɛrɛs ne Sɛra, mmá bwɔ́ akamege Tama. Pɛrɛs alu ntɛ Hɛsrɔn, Hɛsrɔn alu ntɛ Ram. ");
INSERT INTO anvNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ne Ram alu ntɛ Aminadab, Aminadab alu ntɛ Nashyɔn, Nashyɔn alu ntɛ Salmɔn. ");
INSERT INTO anvNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmɔn alu ntɛ Boas ne mma Boas akamege Rahab. Boas alu ntɛ Obɛd, ne mmá Obɛd akamege Rut, Obɛd alu ntɛ Jɛsse. ");
INSERT INTO anvNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Jɛsse alu ntɛ mfwa Dɛvid. Ne mfwa Dɛvid alu ntɛ Solomun, mmá Solomun abɔ́ abɔɔ́ mbɛ abá lé Uriya. ");
INSERT INTO anvNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Ne Solomun alu ntɛ Rehoboam, Rehoboam alu ntɛ Abija. Abija alu ntɛ Asa. ");
INSERT INTO anvNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa alu ntɛ Jɛhoshafa, Jehoshafa alu ntɛ Joram, Joram alu ntɛ Usiya. ");
INSERT INTO anvNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Usiya alu ntɛ Jotam, Jotam alu ntɛ Ahas ne Ahas alu ntɛ Hɛsɛkya. ");
INSERT INTO anvNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hɛsɛkya alu ntɛ Manasɛ, Manasɛ alu ntɛ Ɛmɔs, ne Ɛmɔs alu ntɛ Josaya. ");
INSERT INTO anvNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Gébégé ápyɛné bɔɔ́ Isrɛli né bé ájyɛ ne ɛbwɔ́ né melɔ́ Babilɔn, Josaya abyɛ Jekonɛya ne aŋmɛ́ bií abi ande. ");
INSERT INTO anvNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Ájyɛgé ne bwɔ́ né Babilɔn, Jekonɛya abyɛ Shɛltyɛl, Shɛltyɛl alu ntɛ Sɛrubabɛl. ");
INSERT INTO anvNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Sɛrubabɛl alu ntɛ Abiud, Abiud alu ntɛ Ɛliakim ne Ɛliakim alu ntɛ Asɔh. ");
INSERT INTO anvNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Asɔh alu ntɛ Sadɔk ne Sadɔk alu ntɛ Akim ne Akim alu ntɛ Ɛliud. ");
INSERT INTO anvNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Ɛliud alu ntɛ Ɛliassa, Ɛliassa alu ntɛ Matan ne Matan alu ntɛ Jakɔb. ");
INSERT INTO anvNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Ne Jakɔb alu ntɛ Josɛf, Josɛf ayi menɔ Mɛri. Mɛri abyɛ Jisɔs Muú yi Ɛsɔwɔ akweré ji ɛlá gefwa. ");
INSERT INTO anvNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Mmyɛ ke nnó upyáne ukouko, manlɔ mbaá Abraham ɔ́kwɔ́né mbaá Dɛvid úlú nyá úfyáneúni. Manlɔ ntó mbáa Dɛvid ɔ́kwɔ́ne gébégé ájyɛ́ ne ɛbwɔ́ né Babilɔn úlú ntó úfyáneúni. Ne mámanlɔ gébégé ájyɛ́ ne ɛbwɔ́ né Babilɔn kpaá tɛ gébégé ábyɛné Kras, upyáne úlú nyá ntó úfyáneúni. ");
INSERT INTO anvNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Na ne nebyɛ́né Jisɔs Kras nekɛné. Mma wuú akamege Mɛri. Josɛf abɔ́ akpɛ mambá Meri ayi alu mambyɛ Jisɔs, nsa nnó ɛbwɔ́ ákaá ujɔ́géné atɛ, Mɛri agɛ nnó ji alu ne unɛ né utó Mendoó Ukpea. ");
INSERT INTO anvNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Josɛf akaáge nnó Mɛri alu ne unɛ, ɛlé ji Josɛf alú nyá cho né mbɛ ushu Ɛsɔwɔ, akɛ́lé fɔ́ manchyɛ ji mekpo unɔɔ́ wɔ́, ashuú manwá neba bwɔ́ bíbií. ");
INSERT INTO anvNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Ndɛre ji afɛ́rege depɔ ɛtiré mbɔ, Ɛsɔwɔ atɔ́ ɛkiɛ́nné wuú ɛ́chwɔ́ gáre ji né gejya ɛké, “Josɛf mpyáne Dɛvid, ɔfɔ́gé fɔ́ mansɛ mendée wyɛ Mɛri né neba, néndé ɛlé Mendoó Ukpea ne ɛpyɛɛ́ ji akpané unɛ. ");
INSERT INTO anvNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Ne ji abyɛne nyɛ́ maá mende, ayi áférege nyɛ bɔɔ́ bií né ɛfwyale ɛwé gabo achwɔɔ́ ne ɛwú. Getu ɛyigémbɔ, ɔbɔ mamfyɛ ji mabɔ nnó Jisɔs.” ");
INSERT INTO anvNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Unó bina uko úpyɛɛ́ nnó ɛ́bɛ́ wáwálé nkane Ɛsɔwɔ apyɛ Asaya muú ɛkpávé wuú ajɔɔ́ nnó, ");
INSERT INTO anvNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Wuúge, gembwɛ́négé mendée gékpáne nyɛ unɛ, gébyɛ́ maá mende, ákuú nyɛ ji nnó Ɛmanuɛl.” Ula útɛné nnó, “Ɛsɔwɔ alu ne ɛsé.” ");
INSERT INTO anvNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Ne Josɛf ápégé géjyá asɛ mendée wuú Meri wyɛ́ ndɛre ɛkiɛ́nné Ɛsɔwɔ ɛgaré ji. ");
INSERT INTO anvNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Yɛ́mbɔ ɛbwɔ́ ákaá ujɔ́géné atɛ wɔ́, kpaá tɛ Mɛri ábyɛné maá wuú mende. Ne Josɛf afyɛ́ ji mabɔ nnó Jisɔs. ");
INSERT INTO anvNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Ábyɛ́ Jisɔs né melɔ́ Bɛtɛlɛhɛm, né gebagé mewaá Judiya, gébé ɛyigé Hɛrɔd álú mfwa né gebagé mewaá ɛyígémbɔ. Ábyɛgé Jisɔs, ande fɔ́ abi ágií depɔré ambe átané né ɛ́gbɛ́ ɛwé ŋmɛɛ́ ɛ́tánege ákɛne áchwɔ́ɔ né Jɛrosalɛ ágíge bɔɔ́ áké, ");
INSERT INTO anvNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","“Maá mekɛ ayi ábyɛné nnó ábɛ́ mfwa bɔɔ́ Jus alu fɔ́? Ɛse degíge mbɔ, gétúgé dégɛné membe wuú mbaá ŋmɛɛ́ ɛ́tánege ayi álɛré ɛsé nnó ábyɛ́ ji, ne ɛsé déchwɔ́ manógé ji.” ");
INSERT INTO anvNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Mfwa Hɛrɔd aké awuú mechɔ ɛwe, metɔɔ́ ɛ́tyá ji mmu wyɛmbɔ ntó ne ɛ́pyɛɛ́ ne bɔɔ́ Jɛrosalɛ ako. ");
INSERT INTO anvNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Mfwa Hɛrɔd akuú, ánɔɔ́ baá ámpyɛ́ upɛ Ɛsɔwɔ ne ánlɛré mabɛ́ Ɛsɔwɔ, ɛbwɔ́ ako áchomé mbaá ama, agií ɛbwɔ́ aké, “Ndé mbaá ábɔɔ́ mambyɛ́ muú ayi ákuú ji Kras”? ");
INSERT INTO anvNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Áshuú ji meko aké, “Ábɔ́ mambyɛ́ ji né Bɛtɛlɛhɛm, fa gebagé mewaá Judiya.” Néndé, mbɔ ne Ɛsɔwɔ apyɛ bɔɔ́ ɛkpávé bií ásáme nnó, ");
INSERT INTO anvNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","“Wɔ Bɛtɛlɛhɛm, né gebagé mewaá Judiya, yɛ́ ɛlé wɔ ɔlu kɔɔ́, ɔpɔ́fɔ́ ŋénéŋéné né geluágé malɔ geŋwá ayi álu né mme Judiya. Néndé, ɛta wyɛ́ ne mfwa átánege nyɛ ayi ágbárege bɔɔ́ ba Isrɛli, nkane mémbamé mágɔ́nŋme ápɛ́le magɔ́nŋme jií.” ");
INSERT INTO anvNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Ne Hɛrɔd áwúgé mbɔ, akú aŋkɛɛ́ bimbɔ ájwɔ́lé bíbií, agií ɛbwɔ́ aké, “Gárege me gébé ɛyigé ɛnyú dégɛ́né membe yimbɔ né melɔ nyú títí.” ");
INSERT INTO anvNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Ɛ́fɛɛ́ ne Hɛrɔd átɔme ɛbwɔ́ aké, “Chóge né Bɛtɛlɛhɛm démyɛ́mmyɛ dégɛ́ mbaá ayi maá yimbɔ álú, dégɛge ji kérege meso, déchwɔ́ dégáré me nnó njyɛ́ nnógé ji ntó.” ");
INSERT INTO anvNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Ne aŋkɛɛ́ bimbɔ áwúgé genó ɛyigé mfwa yimbɔ ajɔɔ́ ne ɛbwɔ́, álɔ́ manjyɛ. Ne ndɛre ɛbwɔ́ ájyɛ́ ágɛ́ wyɛ́ membe yimbɔ ayi ɛbwɔ́ ábɔ́ ágɛne nkane ajyɛ́ɛ mbɛ, ɛbwɔ́ ákwɔ́lege ji meso. Ákwɔ́négé né Bɛtɛlɛhɛm membe yimbɔ atɛné né mfaánebuú cho né gepú ɛyigé maá yimbɔ álú. ");
INSERT INTO anvNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Ɛbwɔ́ ágɛgé membe yimbɔ ɛfɛɛ́, matɔɔ́ ágɔ ɛbwɔ́ dɔɔ́. ");
INSERT INTO anvNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Ákpɛgé né mmu gepú ɛyigémbɔ, ágɛ́ maá yimbɔ ne mmá wuú Mɛri. Ɛ́fɛɛ́ ne átomé manó mme áchyɛ́ ji ɛnogé. Ne ánené uba bwɔ́ áferé unó mabɔ áchyɛ́ ji, gémá gélú genógé gesege ŋka ɛyigé ákuú nnó gul, gémá gélú gefɔ́gé ɛmmá ɛwé ɛwyaá gebɛ gelɔ́gélɔ́ ne ɛyige fɔ gelú laménda ayi alú gefɔ́gé maweé gebɛ́ gefɔ. ");
INSERT INTO anvNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Nkane aŋkɛɛ́ bimbɔ ábɛlé ne utuú, Ɛsɔwɔ achwɔ́ kwéle ɛbwɔ́ mbeé né gejyá nnó ɛkage ákéré meso mbaá Hɛrɔd. Ɛbwɔ́ ákoó meti ɛwéchá ne ájyɛ́ né melɔ bwɔ́. ");
INSERT INTO anvNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Aŋkɛ bímbɔ áwúlégé, ɛkiɛ́nné Ɛsɔwɔ ɛ́kwɔ́ Josɛf ushu né gejya, ɛ́jɔɔ́ ne ji ɛké, “Josɛf, Kwílé ka, kpa maá yina ne mmá wuú débo dejyɛ́ né melɔ́ Ijip. Déjyɛgé láge ɛ́wu kpaá tɛ bií bí ngárege nyɛ ɛnyú nnó dékéré meso. Néndé Hɛrɔd ákɛlege maá yina manwá.” ");
INSERT INTO anvNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Josɛf apégé géjyá ne utuú bimbɔ, apyɛ wyɛ́ nkane ɛkiɛ́nné Ɛsɔwɔ ɛgaré ji ɛké. “Kpá maá yimbɔ ne mmá wuú ɔjyɛ né Ijip.” ");
INSERT INTO anvNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Akwɔ́négé Ijip, ála wyɛ́ kpaá tɛ gébégé mfwa Hɛrɔd ágboó. Unó bi na úpyɛ nnó depɔ ɛtíré Ɛsɔwɔ ápyɛ nnó muú ɛkpávé wuú agáré bɔɔ́ bií débɛ́ wáwálé, nnó, “Nkú maá wa átané né Ijip.” ");
INSERT INTO anvNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Hɛrɔd agɛ́gé nnó áŋkɛɛ́ bimbɔ ábwɔlé ji, nchyɛ anywɔ́né ji mmu. Achyɛ́ meko aké, “Áwá baá ande ako né Bɛtɛlɛhɛm né malɔ́ ayí kwɔ́kwɔ́lé, álɔ́ né baá abi ákwɔné aŋmɛ́ ápea áshúlégé.” Hɛrɔd ajɔɔ́ mbɔ gétúgé ji áfɛré nnó ɛ́lɛ́ mɛ́ aŋmɛ́ ápea ayí ji agií áŋkɛɛ́ bimbɔ gébé ɛyigé ɛbwɔ́ ágɛné membe yimbɔ. ");
INSERT INTO anvNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Mechɔ ɛwéna ɛ́pyɛmbɔ nnó, genó ɛyígé Jɛrimaya muú ɛkpávé Ɛsɔwɔ ájɔɔ́ gepyɛ wáwálé. ");
INSERT INTO anvNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Ajɔɔ́ nyá aké, “Meko negbo átanege né melɔ́ Rama ne gejamégé ɛlúlú ne dámpepe. Rashɛl alili baá bií, bɔɔ́ áfyɛɛ́ ji metɔɔ́ nnó ágɔ́ magbo, akámégé gétúgé baá bií abi ágboó.” ");
INSERT INTO anvNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Hɛrɔd ágbógé, ɛkiɛ́nné Ɛsɔwɔ ɛkwɔ́ Josɛf ushu né géjyá né Ijip, ");
INSERT INTO anvNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","ɛké “Josɛf, kwilé ka ɔ́kpá maá yina ne mma wuú, ɛnyú dékéré meso né mme Isrɛli. Bɔɔ́ abi ákɛlege manwá ji ágboó.” ");
INSERT INTO anvNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Josɛf ápégé, asɛ maá yimbɔ ne mmá wuú áfɛ́ né mme Isrɛli. ");
INSERT INTO anvNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Yɛ́mbɔ ji áwúgé nnó Achelɔs asɛ gefwagé ntɛ wuú Hɛrɔd né gebagé mewaá Judiya, abɔ́ ɛfɔ manjyɛ wyɛ́. Né gejya ɛyígé ji áma gɛ́, Ɛsɔwɔ ákwɛlé ji mbeé nnó ajyɛ né gebagé mewaá Galilií. ");
INSERT INTO anvNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Ne Josɛf ajyɛ jwɔ́le né melɔ́ Nasarɛt ɛwé ɛ́lú né gebagé mewaá ɛyigémbɔ́. Mechɔ́ wé ɛpyɛ nnó genó ɛyígé Ɛsɔwɔ abɔ́ apyɛ nnó muú ɛkpávé wuú agáré bɔɔ́ bií gébɛ́ wáwálé nnó, “Bɔɔ́ ákuú nyɛ ji nnó muú Nasarɛt.” ");
INSERT INTO anvNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Né gébé ɛyigémbɔ, ndɛre Jisɔs alu né Násarɛt, mende fɔ ayi akuú ji Jɔn menwyaá bɔɔ́ manaá Ɛsɔwɔ, alɔ́ mangaré mekomejɔɔ́ Ɛsɔwɔ né mashwɔne né gebagé mewaá Judiya aké, ");
INSERT INTO anvNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“Kwɔ́rege matɔɔ́ nyú délyá gabo néndé gébé ɛyigé Ɛsɔwɔ ágbárege gefwa ne bɔɔ́ bií géla kwɔ́kwɔ́lé.” ");
INSERT INTO anvNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Jɔn yina ne Asaya muú ɛkpávé Ɛsɔwɔ ágarege nyá átomé ne jií nnó, “Muú fɔ abɛne mbɔ né mashwɔne aké, ‘Kwyɛge meti Ata dakɛné, nyaáge ɛ́wú ɛ́bɛ́ cho’.” ");
INSERT INTO anvNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Gefɔgé nkúu ɛyígé Jɔn abɔ́ afyɛ́ ájo ne bya mpɔ mashwɔne. Awɛ́lé ɛkandá mekɔ́ menya né gebwɛ jií, ne menyɛɛ́ wuú alu nyá lé ɛ́gomé ne nwyɔɔ́. ");
INSERT INTO anvNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Ne gejamégé bɔɔ́ áchwɔ́ manwú mekomejɔɔ́ ayi Jɔn agárege. Bɔɔ́ bina átané Jɛrosalɛ, ne gebagé mewaá Judiya meko ne malɔ́ mako ayi álú kwɔ́kwɔ́lé ne ɛbɛɛ́ Jodan. ");
INSERT INTO anvNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Ndɛre ɛbwɔ́ áshuú ɛkúu né gabo ayi ɛbwɔ́ ápyɛɛ́, Jɔn awyaágé ɛbwɔ́ manaá Ɛsɔwɔ né mmu ɛbɛɛ́ Jodan. ");
INSERT INTO anvNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Ndɛre Jɔn ágárege mbɔ, agɛ́ gejamégé ɛkwɔ bɔ́ Farasi ne ɛkwɔ bɔ́ Sadusi fɔ ndɛre áchwɔɔ́ nnó ji awyaá ɛbwɔ́ manaá Ɛsɔwɔ, aké ne ɛbwɔ́, “Ɛnyú mmyɔ! Ndé muú agaré ɛnyú nnó, dekage bó ɛfwyale ɛwé Ɛsɔwɔ achwɔ́ tɔ́?” ");
INSERT INTO anvNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Yɛ́ndémuú nyú apyɛ́gé unó ɛbí úlɛré nnó akwɔré metɔɔ́ wuú alyá gabo wáwálé. ");
INSERT INTO anvNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Défɛrégé fɔ́ nnó, dekage déjwɔ́le déli mmyɛ nnó, ɛlé ɛsé délú upyáne Abraham dékágé bó ɛfwyale ɛwé ɛchwɔɔ́. Kaáge wáwálé nnó, Ɛsɔwɔ akage pyɛ mataá yina ábwɔlé upyáne Abraham. ");
INSERT INTO anvNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Yɛ nana, ɛnyú debɔ́ mankaá nnó, ábwɛɛ́ mɛ́ ɛtɔɔ́ mfaá mango yɛndé genɔɔ́ ne makaka ɛyigé gélágé wɔmé umpomé ulɔ́úlɔ́ ásɔ́ré áfɔme mmu mewɛ. ");
INSERT INTO anvNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Me nwyage ɛnyú ne manaá Ɛsɔwɔ mamimami manlɛré nnó, ɛnyú dékwɔ́ré matɔɔ́ nyú. Yɛ́mbɔ, muú fɔ achwɔ́ mbɔ me meso, ayi áŋeá gemɛ apwɔ me, nkwané yɛ́ muú ayi mkpane unó uká bií wɔ́. Achwɔgé, awyage nyɛ ɛnyú ne Mendoó Ukpea ne mewɛ. ");
INSERT INTO anvNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Achwɔɔ́ nyɛ́ ne ɛ́kɔ́riyá né ɛbwɔ wuú mánchá ɛsa. Anerégé ashwané nyɛ matoó álá pópó, afyɛ ɛsa né mmu uba abelé. Ne ukwɔɔ́ ɛbi ulaá akpane agbɛ né mewɛ ɛwé ɛ́lá nómégé. ");
INSERT INTO anvNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Ɛ́wyá yɛ́ wɔ́, Jisɔs atané gebagé mewaá Galilií achwɔ́ né ɛbɛɛ́ Jodan mbaá Jɔn nnó awyaá ji manaá Ɛsɔwɔ. ");
INSERT INTO anvNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Yɛ́mbɔ, Jɔn abɔ́ ashya ne ajɔɔ́ ne Jisɔs aké, “Nnó me nchwɔ́ ɛta wyɛ́ ɔwyaá me manaá Ɛsɔwɔ, wɔ ɔma ɔchwɔ́ ɛta wáa?” ");
INSERT INTO anvNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Jɔn ájɔ́gémbɔ, Jisɔs ashuú ji meko aké, “Gɔ́ ɛ́wú ɛ́bɛ́ mbɔ nana, ɛlɔme nnó dépyɛ́ yɛ́ndégenó ɛyigé Ɛsɔwɔ akɛ́lege. Ɛ́fɛɛ́ ne Jɔn ákamé manwyaá Jisɔs manaá Ɛsɔwɔ.” ");
INSERT INTO anvNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Tɛ́nétɛ́né ayi áwyaá Jisɔs manaá Ɛsɔwɔ, atané mmu nnyi, aké apɛle mfaánebuú anené, agɛ́ Mendoó Ɛsɔwɔ ɛ́shúlege nkane gepwine ne ɛchwɔ́ tɛ́ne ji mmyɛ́. ");
INSERT INTO anvNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Ne meko atané mfaánebuú aké, “Gɛ́ maá wa na, ngboó ne ji, apyɛɛ́ metɔɔ́ ɛgɔɔ́ me.” ");
INSERT INTO anvNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Ɛ́fɛɛ́ Mendoó Ukpea ɛ́pyɛ Jisɔs afɛ́ né mashwɔne nnó danchɔmeló ammua ji. ");
INSERT INTO anvNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Jisɔs abɛlé ɛ́wu usaá ndɔ upea, utuú ne ŋwɔmésé ayi álá nyɛɛ́ menyɛɛ́ wɔ́ ne mesa alɔ́ mammyɛ ji. ");
INSERT INTO anvNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Gébé ɛyígémbɔ ne danchɔmeló áchwɔ́ jɔɔ́ ne ji aké, “Mbɔgé wɔ ɔlu Maá Ɛsɔwɔ, garé mataá áyina ábwɔ́lé ntoó brɛd.” ");
INSERT INTO anvNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Jisɔs ashuú ji meko aké, “Ásá mmu ŋwɛ Ɛsɔwɔ nnó, menyɛɛ́ jiji fɔ́ wɔ́ awyaá ɛshyɛ mángbaré geŋwáge mekwaá wɔ́, yɛ́ndé mekomejɔɔ́ ayi Ɛsɔwɔ ajɔɔ́ awya ntó ɛshyɛ mangbaré geŋwáge mekwaá.” ");
INSERT INTO anvNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Ajɔɔ́gé mbɔ, danchɔmeló asɛ ji afɛ́ né Jɛrosalɛ melɔ ukpea, abelé ji né melu ɛwé ɛ́lú tɛtɛ mfaá ɛcha upɛ Ɛsɔwɔ. ");
INSERT INTO anvNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Ne aké ne ji, “Mbɔgé wɔ ɔlu Maá Ɛsɔwɔ, nyó chɔ mme, néndé ásá né mmu ŋwɛ Ɛsɔwɔ nnó, ‘Ɛsɔwɔ atɔme nyɛ makiɛ́nné jií nnó áchwɔ́ ábámé wɔ’, áma sá nnó: ‘Ágbárege nyɛ́ wɔ né amu bwɔ́ chánchá nnó ɔ́kagé ɔ́tó ɛnɔɔ́ geká né ntaá.’” ");
INSERT INTO anvNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Jisɔs ashuú ji meko aké, “Ŋgba, me nyogé fɔ́ néndé, ásá ntó né mmu ŋwɛ Ɛsɔwɔ nnó, ‘Mekwaá ákpelégé fɔ́ Ntɛ wuú Ɛsɔwɔ mankpea ji nnó ápyɛ́ genó.’” ");
INSERT INTO anvNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Ályágé ɛfɛɛ́, danchɔmeló ama akpá ji áfɛ né mfaá mékwɛ́ ɛwé ɛ́ŋɔgé dɔɔ́ ne alɛré ji malɔ mme mako ne gefwa ɛyi gélú wyɛ́. ");
INSERT INTO anvNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Ne alɛ́régé Jisɔs mbɔ, ajɔɔ́ ne ji aké, “Menchyɛge nyɛ wɔ unó bina uko mbɔgé ɔtogé manó mme ɔnogé me.” ");
INSERT INTO anvNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Jisɔs anyá ji aké, “Kwilé me ushuú, wɔ danchɔmeló, ása mmu ŋwɛ Ɛsɔwɔ aké, ‘Ɔbɔ́ manógé ɛlé Ntɛ wyɛ Ɛsɔwɔ jimbií ne ɔkpáné wyɛ lé ji defwɛ.’” ");
INSERT INTO anvNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Ájɔ́gé mbɔ, danchɔmeló alyá ji afɛ́. Ɛ́fɛɛ́ ne makiɛ́nné Ɛsɔwɔ áchwɔ́ póo Jisɔs. ");
INSERT INTO anvNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Jisɔs áwúgé nnó ápyɛ Jɔn menwyaá bɔɔ́ manaá Ɛsɔwɔ áfyɛɛ́ denɔ, alyá gebagé mewaá Judiya akeré né gebagé mewaá Galilií. ");
INSERT INTO anvNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Ájyɛ́gé, ábɛlé fɔ́ né Nasarɛt dɔɔ́ wɔ́, akoó kóge ajyɛ́ jwɔ́lé né Kapanɔm melɔ ɛwé ɛ́lú né mapea gentoógé mewaá Galilií né gebagé mewaá Sɛbulɔn ne Naftali. ");
INSERT INTO anvNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Ɛbɔ ɛpyɛmbɔ nnó genó ɛyigé Asaya muú ɛkpávé Ɛsɔwɔ asamé gébɛ́ wáwálé nnó, ");
INSERT INTO anvNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Mme Sɛbulɔn ne mme Naftali, mme ayi álú meti ɛbɛɛ́ mega, né ɛ́gbɛ́ ɛbɛɛ́ Jodan, gebagé mewaá Galilií ɛyigé gejamégé bɔɔ́ abi álá pɔ bɔɔ́ Jus ájwɔ́lege wyɛ. ");
INSERT INTO anvNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Bɔɔ́ abi ábɔ́ álú mmu gemua ágɛ́ gekpɛ́kpɛ́gé geŋgbɔ́. Ne bɔɔ́ bi álú nya mmu manoó negbo, nana geŋgbɔ́ gégɛné, ɛbwɔ́ átane meti.” ");
INSERT INTO anvNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Ɛlɔ́ né gébé ɛyígémbɔ, Jisɔs alɔ mangaré bɔɔ́ mekomejɔɔ́ Ɛsɔwɔ aké, “Kwɔ́rege matɔɔ́ nyú délya gabo nénde, gébé ɛyigé Ɛsɔwɔ ágbárege gefwa jií ne bɔɔ́ géla kwɔ́kwɔ́lé.” ");
INSERT INTO anvNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Bií fɔ, ndɛre Jisɔs akɛ́ne né mbále ɛbɛɛ́ mega ɛwe ɛlu né Galilií, agɛ́ áŋmɛ́ ápea mmá ama, ntɛ ama. Ama akamege Simun ayi ákuú ji ntó nnó Pita, ne meŋmo wuú Andru. Ɛbwɔ́ áŋmée utófó bwɔ́, ɛlé álu áwáné meshuú. ");
INSERT INTO anvNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Jisɔs ajɔɔ́ ne ɛbwɔ́ aké, “Kwɔ́lege me, nlɛrege nyɛ ɛnyú, ndɛre ákpálege bɔɔ́ ɛké meshuú.” ");
INSERT INTO anvNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Tɛnétɛné yimbɔ Simun ɛbwɔ́ ne meso wuú Andru ályaá utófó bwɔ́ ne ákwɔlé ji. ");
INSERT INTO anvNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Ndɛre Jisɔs ályá ɛfɛɛ́ ajyɛɛ́ mbɛ gachyɛ, áma gɛ́ áŋmó abifɔ ápeá Jɛmsi ne Jɔn meŋmo wuú ɛbwɔ́ álú baá Sɛbɛdee. Álú né mmu ɛ́kpée ne ntɛ bwɔ́ Sɛbɛdee átóme upaá utófó bwɔ́. Akuú ɛbwɔ́ nnó ákwɔ́le ji. ");
INSERT INTO anvNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Jisɔs ajɔ́gé mbɔ, yɛ́ gébé áchɔ wɔ́ ályá ɛkpée mbaá ntɛ bwɔ́ ne ákwɔlé ji. ");
INSERT INTO anvNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Ne Jisɔs akɛné gebagé mewaá Galilií geko. Ndɛre akɛne, alɛrege bɔɔ́ mekomejɔɔ́ Ɛsɔwɔ, né mmu macha mmyɛmenɛne bwɔ́. Agarege ɛbwɔ́ abya melɔ́mélɔ́ ndɛre Ɛsɔwɔ ágbárege gefwa ne bɔɔ́ bií. Ama apyɛ bɔɔ́ abi ameé mamée ufɔɔ́ ufɔɔ́ átóoge. ");
INSERT INTO anvNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Abya yi apyɛ ŋgɔ́ Jisɔs akwɔ́ kpaá akwɔné gebagé mewaá Siriya geko. Bɔɔ́ ákpáne bɔɔ́ bwɔ́ ako abi ámeé mameé úfɔɔ́ úfɔɔ́ ne abi ágɛne ɛfwyale dɔɔ́ áchwɔ́ ɛta wuú nnó ápyɛ ɛbwɔ́ átoó. Né geluágé bɔɔ́ bina, abifɔ áwyá aló nchyɛ, abifɔ ákwéne usasa ne abifɔ ámeé uchanchi. Jisɔs apyɛ ɛbwɔ́ átoó. ");
INSERT INTO anvNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Ɛwena ɛ́pyɛgémbɔ, gejamégé bɔɔ́ ako abi átané gebagé mewaá Galilií ne gebagé mewaá ɛyige ákuú nnó malɔ́ áfya ne Jɛrosalɛ ne Judiya né ɛgbɛ́ ɛbɛɛ́ Jodan, ɛbwɔ́ ako álɔ mankwɔlége Jisɔs. ");
INSERT INTO anvNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Jisɔs ágɛ́gé gejamégé bɔɔ́ abi áchwɔɔ́ matoómatoó né mbaá ayi ji alú, akwɔ́ ajyɛ jwɔle mfaá mekwɛ́. Ne baá utɔɔ́ bií ájwɔlé ánɔ ji mme. ");
INSERT INTO anvNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Ne alɔ mánlɛré ɛbwɔ́ aké: ");
INSERT INTO anvNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Ɛsɔwɔ ajé bɔɔ́ abi ágɛné nnó mbɔgé ji álá pɔ́ ɛbwɔ́ ápɔ́ yɛ́ genó; néndé gefwa ɛyigé Ɛsɔwɔ ágbárege ne bɔɔ́ bií gelú ɛyigé bwɔ́. ");
INSERT INTO anvNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Ɛsɔwɔ ajé bɔɔ́ abi álú ne masome, néndé Ɛsɔwɔ áfyɛɛ́ nyɛ ɛbwɔ́ metɔɔ́. ");
INSERT INTO anvNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Ɛsɔwɔ ajé bɔɔ́ abi alá sɛ́lé gemɛge bwɔ́ ɛke genó, néndé mme meko abɛɛ́ nyɛ́ awe bwɔ́. ");
INSERT INTO anvNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Méjé ɛlu ne bɔɔ́ abi áwyaá matɔɔ́ mampyɛ genó ɛyigé Ɛsɔwɔ akɛ́lege, néndé ji apyɛɛ́ nyɛ ɛbwɔ́ ápyɛ genó ɛyigé ɛbwɔ́ ákɛ́lege. ");
INSERT INTO anvNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Ɛsɔwɔ ajé bɔɔ́ abi ágɛne bɔɔ́ meshwɛ, néndé Ɛsɔwɔ ntó agɛne nyɛ́ ɛbwɔ́ meshwɛ. ");
INSERT INTO anvNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Ɛsɔwɔ ajé ɛbwɔ́ abi áwyá matɔɔ́ mmu pópó, néndé ágɛ́ne nyɛ Ɛsɔwɔ ne amɛ bwɔ́. ");
INSERT INTO anvNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Ɛsɔwɔ ajé bɔɔ́ abi ámmyɛɛ́ nnó bɔɔ́ ábɛ́ nesɔ ne atɛ, néndé, ákuú nyɛ ɛbwɔ́ nnó baá Ɛsɔwɔ. ");
INSERT INTO anvNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Ɛsɔwɔ ajé bɔɔ́ abi bɔɔ́ ámyɛ́ amu ne ɛbwɔ́ gétúgé ápyɛ unó ɛbí Ɛsɔwɔ akɛ́lege néndé gefwa ɛyigé Ɛsɔwɔ ágbárege ne bɔɔ́ bií gelu ɛyigé bwɔ́. ");
INSERT INTO anvNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Méjé ɛlu ne ɛnyú abi bɔɔ́ áju ɛnyú mashyɛ mmyɛ, ɛnyú abi ámmyɛɛ́ amu ne ɛnyú detúdetú ne ɛnyú abi ama ájɔɔ́ge ufɔɔ́ unó uboubo ɛbi úlú gebyɔ́ ɛta nyú gétúgé dékwɔlegé me. ");
INSERT INTO anvNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Bɛ́ge lé ne metɔɔ́ megɔmegɔ ne nechɔ́chɔ́, néndé, gekpɛ́kpɛ́gé nsá nyú alu né mfaánebuú. Kaáge ntó nnó mbɔ ne ámyɛ nyá amu ne bɔɔ́ ɛkpávɛ́ Ɛsɔwɔ abi ábɔɔ́ mbɛ ne ɛnyú.” ");
INSERT INTO anvNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Ɛnyú bi delu áŋkwɔle baá délu ɛke mega mbaá bɔɔ́ mme meko, yɛ́mbɔ mbɔgé mega ɛ́lá pɔ́ sé ne ugɔ bií, ápyɛɛ́ mbɔ nnó ne ugɔ bií ukéré? Ɛfúlé sé yɛ́ genó, ɛla lé genó ɛyigé ágbɛ́le dafyɛ bɔɔ́ ájyále ne uka. ");
INSERT INTO anvNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Ɛnyú delu geŋgbɔ mbaá bɔɔ́ mme meko, wyɛ ndɛre melɔ ɛwé átɛné mfaá mékwɛ ɛ́la ɛbígé fɔ́ mangɛ́. ");
INSERT INTO anvNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Mbɔntó ne muú alwɛ́gé ɛ́túléká álá abɔɔ́ fɔ́ gesá ákwéré ɛwú. Yɛ́mbɔ, álwɛ́gé ɛ́wú aŋma ɛwú mfaá mbaá yi ɛ́gɛ́nege yɛ́ndémuú né mmu gepú ágɛné. ");
INSERT INTO anvNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Wyɛmbɔ ntó ne ɛ́lɔme nnó délyá geŋwáge nyú gégɛ́négé ɛké mewɛ mbaá bɔɔ́ ako, nnó yɛ́ndémuú ágɛ́ ulɔ́ melu ɛbí ɛnyú dépyɛ́ ne áfɛ́gé Ntɛ nyú Ɛsɔwɔ muú alu né mfaánebuú. ");
INSERT INTO anvNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Défɛrégé fɔ́ nnó me mbɔ nchwɔ́ ɛlé mánchɔ mabɛ́ Mosis ne unó bi bɔɔ́ ɛkpávé Ɛsɔwɔ ábɔ́ álɛré. Nchwɔ́ lé nnó mpyɛ unó ɛbí mabɛ́ yimbɔ ájɔɔ́ úbɛ́ wáwálé. Nchwɔ́ fɔ́ mánchɔ ájí wɔ́. ");
INSERT INTO anvNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Ngarege ɛnyú wáwálé nnó, tɛɛ́ mfaá ne mme ábyɛɛ́, yɛ ɛkɛ́kɛ́ genó ɛyigé áférege né mabɛ́ Mosis yina gépɔ yɛ́ geŋéné nnó, kpaá tɛɛ́ unó uko ɛbi ásámé úbɛ́ɛ nyɛ wáwálé. ");
INSERT INTO anvNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Ne yɛ́ndémuú ayi abyaá ɛkɛ́kɛ́ genó né mabɛ́ ayi, nnó ɛpɔ́fɔ́ genó, ne álɛ́rege ntó nnó bɔɔ́ ábyágé ɛwu, abɛɛ́ gembyáŋkwɔ́gé muú né gefwa ɛyigé Ɛsɔwɔ ágbarege ne bɔɔ́ bií. Yɛ́mbɔ muú ayi ábélege mabɛ́ Ɛsɔwɔ ayi, ne alɛrege ntó bɔɔ́ nnó ábélégé áji abɛɛ́ nyɛ́ gekpɛ́kpɛ́gé muú né gefwa ɛyigé Ɛsɔwɔ ágbárege. ");
INSERT INTO anvNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Ngarege ɛnyú wáwálé nnó mbɔgé ɛnyú delá fyɛɛ́ mekpo mambele mabɛ́ Ɛsɔwɔ depwɔ́ ɛkwɔ bɔɔ́ Farasi ne ánlɛré mabɛ́ Ɛsɔwɔ wɔ́, degɛne fɔ́ meti mankpɛ né gefwa ɛyigé Ɛsɔwɔ ágbárege ne bɔɔ́ bií cháchá. ");
INSERT INTO anvNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Ɛnyú debɔ́ déwú nyá nkane ɛbɛ́ Mosis ɛjɔɔ́ mbaá ukwéne antɛ sé nnó, ɛ́kagé muú áwá ntɛ. Muú ayi ápyɛɛ́ mbɔ, akpɛ́ne nyɛ́ unɔɔ́ mpa. ");
INSERT INTO anvNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Yɛ́mbɔ me ngarege ɛnyú nnó, yɛ́ndémuú ayi abɔɔ́ metɔɔ́ usɔɔ́ ne ntɛ meŋmɛ́ akpɛne nyɛ unɔɔ́ mpa ɛso. Ne muú ayi ashyɛɛ́ ntɛ meŋmɛ́ nnó, “wɔ ɔlu waá?” Akpɛne nyɛ ntó ɛso ɛwe kpaá. Ne muú ayi ajɔɔ́gé ne ntɛ meŋmɛ́ ntó nnó, “Wɔ geŋkekenégé muú” akpɛne mmu mewɛ ɛwé ɛ́lá nómégé. ");
INSERT INTO anvNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Ne ndɛre ɛlúmbɔ, ɛ́bɛgé nnó muú abɔ́ ɛchyɛ manchyɛ́, né mbaá ayi áchyɛ́ge ɛchyɛ Ɛsɔwɔ, ne atɛge nnó apyɛ genó ɛyi gesɔɔ́ meŋmɛ́ wuú metɔɔ́, ");
INSERT INTO anvNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","ályá ɛchyɛ ɛwɛ́mbɔ́ ɛfɛɛ́, abɔ kpɛ mbɛ ajyɛ́ akwyɛ́ depɔ ne meŋmɛ́ wuú, ne achwɔ́ achyɛ́ ɛchyɛ wuú mbaá Ɛsɔwɔ. ");
INSERT INTO anvNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Muú abɔgé ɛfwyale ne muú mawámé wuú, akamégé fɔ́ ji ajyɛ ne ɛwú né ɛso. Akwyɛɛ́ depɔ ábɛ́ meko ama gemɛge nnó ajyɛ né ɛso. Nénde, álá pyɛ mbɔ wɔ́, gébé gékoógé ajyɛgé ne ɛ́wú né ɛso, afyɛ nyɛ ji né amú mempané mpa. Ne mempané mpa afyɛ ji né amú bɔɔ́ bɔ nku, ne bɔɔ́ nkú áfyɛɛ́ nyɛ ji denɔ. ");
INSERT INTO anvNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Ne kaáge wáwálé nnó alaá né denɔ ɛtirémbɔ, kpaá tɛ ákwɔ́le ujwɔɔ́ bimbɔ uko. ");
INSERT INTO anvNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Ɛnyú debɔ́ dewú nyá nkane ɛbɛ́ Mosis ɛjɔɔ́ nnó muú ákwegé ulɔ. ");
INSERT INTO anvNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Yɛ́mbɔ me ngarege ɛnyú nnó, muú ayi apɛ́le mendée dómee, ne abɔɔ́ nkyaá né metɔɔ́ wuú mambɛlé ne ji, akwe mɛ́ mbɔ lé ulɔ ne mendée yimbɔ né mmu metɔɔ́ wuú. ");
INSERT INTO anvNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Ne ndɛre ɛlúmbɔ, mbɔgé dambɔɔ́nnyi wyɛ́ ayi ɛbwɔnyɛ apyɛ nnó ɔ́kwé ɛbɛ́ Ɛsɔwɔ ju ji ɔféré, néndé ɛ́lú galɔ́gálɔ́ nnó gepɔ́gé menyammyɛ génó wɔ, ne nnó ɔbɛ́ ne upɔɔ́ mmyɛ uko, ɔ́jyɛ́ né mewɛ ɛwé ɛ́lá nómégé. ");
INSERT INTO anvNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Ne mbɔgé ɛbwɔnyɛ wyɛ́ ɛ́pyɛ́ wɔ nnó ɔ́kwé ɛbɛ́ Ɛsɔwɔ, sɔ́ ɛ́wú ɔfómé, néndé ɛ́lú galɔ́gálɔ́ nnó jɔgé menyammyɛ wyɛ́ génó ne nnó menyammyɛ wyɛ́ mekomeko ákpɛ́ mmu mewɛ ɛwé ɛ́lá nómégé. ");
INSERT INTO anvNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Ɛnyú dewú nyá nnó ɛbɛ́ Mosis ɛjɔɔ́ ɛ́ké muú akage wá neba ne mendée wuú mbɔgé achyɛgé ji mekpó ŋwɛ. ");
INSERT INTO anvNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Yɛ́mbɔ me ngare ɛnyú nnó, muú ayi awáne neba ne mendée wuú ɛwé mendée wuú álá kwe ulɔ wɔ́, muú yimbɔ apyɛ nnó mendée wuú akwé ulɔ mbɔgé abagé menɔ ayi chá. Ne yɛ ndé mende ayi abagé mendée ayi menɔ wuú alya ji neba akwé ntó ulɔ. ");
INSERT INTO anvNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Ɛnyú debɔ déma wú nyá nkane ɛbɛ́ Mosis ɛjɔɔ́ ne ukwéne antɛ sé nnó, ɛ́kágé muú anyɛ́meno mampyɛ genó ɛyige gélá pɔ́ ji metɔɔ́ mampyɛ. Muú abɔ́ mampyɛ genó ɛyigé ji ányɛ́meno né mbɛ ushuú Ɛsɔwɔ nnó apyɛɛ́. ");
INSERT INTO anvNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Yɛ́mbɔ me ngarege ɛnyú nnó ɛ́kagé muú akele kaŋka, yɛ ɛ́bɛ́le mannkú mabɔ mfaánebuú, néndé ɛ́lé geluɔge Ɛsɔwɔ. ");
INSERT INTO anvNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Yɛ́ ɛ́bɛlé mankele ákú mme néndé mme alu geluɔ́ ɛyige Ɛsɔwɔ ánɛ́rege uká bií wyɛ́ ágbéege mmyɛ, ne muú akelégé akú yɛ Jɛrosalɛ néndé ɛle Ɛsɔwɔ mfwa yi kpaá ne abɔɔ́ melɔ́ Jɛrosalɛ. ");
INSERT INTO anvNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Ne ɛ́kagé muú akélé yɛ́ mekpo wuú néndé ákágé bwɔle ɛŋkaá méjwɛ́ ɛma ɛ́bɛ́ pópó yɛ́ lé megilí. ");
INSERT INTO anvNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Kámélé nnó “Ɛ ɛ́” mbɔgé genó gélú ɛyigé wɔ ɔkamege ne shya ntó nnó, “Ngba” mbɔgé genó, gélú ɛyige wɔ ɔshyáa. Yɛ́ndégenó ɛyigé ɔmage gbɛɛ́ né mfaá ɛyina getané mbaá danchɔmeló. ");
INSERT INTO anvNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Ɛnyú debɔ́ dewú nyá ntó nnó ɛbɛ́ Mosis ɛ́ké muú anigé dambɔɔ́nnyi ntɛ meŋmɛ́, ánií ntó awuú. Ne yɛ́ amugé néŋɛ́né ntɛ, ámu ntó ɛnií. ");
INSERT INTO anvNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Yɛ́mbɔ me ngarege ɛnyú nnó, ɛ́kagé muú ashuú gabo mfaá gabo. Ne muú adogé wɔ ɛ́gbɛ́ ɛtaá ɛwé ɛbwɔnyɛ, bwɔ́lé ɛwé fɔ ntó ado. ");
INSERT INTO anvNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Ne mbɔgé muú aké akɛlege mampyɛ mpa ne wɔ nnó asɛ nkú wyɛ ayi mmu, chyɛɛ́ ji chonchó ne ayi dafyɛ. ");
INSERT INTO anvNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Mbɔgé muú bee agbarégé wɔ nnó ɔkpá metuú wuú ɔjyɛ mkpa nekɛ ama, chó ne ji mkpá nekɛ ɛ́peá. ");
INSERT INTO anvNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Muú akɔgé wɔ genó, chyɛɛ́ ji géji ɔ́nyogé. Ne muú achwɔgé nnó ɔ́pwɔ́ ji genó ntó ɔ́shyagé, pwɔ́ ji gejí. ");
INSERT INTO anvNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Ɛnyú debɔ́ déwú mɛ nnó ɛbɛ́ Mosis ɛké, “Gbógé ne bɔɔ́ abi dényɛɛ́ détúge ne ɛbwɔ́ ne paáge bɔɔ́ abi álá kií ɛnyú.” ");
INSERT INTO anvNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Yɛ́mbɔ me ngarege ɛnyú nnó bɔ́gé gejeé ne bɔɔ́ mawámé nyú, dénɛ́nemmyɛ mbaá Ɛsɔwɔ nnó aje bɔɔ́ abi ámmyɛ amu ne ɛnyú. ");
INSERT INTO anvNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Depyɛge mbɔ, debɛɛ́ nyɛ baá Ntɛ ɛnyú muú alú né mfaánebuú. Ji apyɛɛ́ mŋmɛɛ́ ɛ́tyɛɛ́ mbaá bɔɔ́ abi ápyɛɛ́ galɔ́gálɔ́ ne abi apyɛɛ́ gabogabo, ne manaá nnó akwéné mbaá bɔɔ́ abi ápyɛɛ́ unó bi ji ákɛ́lege ne abi álá pyɛɛ́. ");
INSERT INTO anvNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Ne mbɔgé ɛnyú dégbóo lé ne bɔɔ́ abi ágboó ne ɛnyú, ndé nsá ayi ɛnyú debɔɔ́ wyɛɛ́? Pɔ́ wyɛ́mbɔ ntó ne ánsɛlé ŋká makpo apyɛɛ́? ");
INSERT INTO anvNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Ne mbɔgé ɛnyú dedoó lé abya ne bɔɔ́ abi denyɛɛ́ detúge ne ɛbwɔ́, nde mechɔ́ ɛwé ɛnyú depyɛ mbɔ ɛwé muú alá pyɛ? Yɛ́ bɔɔ́ abi álá pɔ́ bɔɔ́ Jus; mbɔntó ne ápyɛɛ́. ");
INSERT INTO anvNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Né gétú ɛyigé na debɔ́ mambɛ́ cho ndɛre Ntɛ ɛnyú muú alú né mfaánebuú álú. ");
INSERT INTO anvNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Yɛ́mbɔ Jisɔs alɛ́régé aké, “Sɛ́ge gébé nnó ɛ́kágé délɛ́régé mmyɛ né mbɛ ushuú bɔɔ́ nnó ágɛné ɛnyú gétúgé unó Ɛsɔwɔ ɛbi depyɛɛ́. Muú apyɛ́gé mbɔ, abɔɔ́ fɔ́ nsa ayi ntɛ nyú né mfaánebuú áchyɛge. ");
INSERT INTO anvNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Getu ɛyigembɔ, yɛ́ndégébé muú nyú aké apoóge mbya muú ɛkagé ádó makáŋka melɔ́mélɔ́ nkane bɔɔ́ démbwɔlé ápyɛ, né macha mmyɛmenɛne, ne metɔɔ́ melɔ nnó bɔɔ́ áfɛ́gé ɛbwɔ́ nnó álú bɔɔ́ alɔ́álɔ́. Me ngarege ɛnyú wáwálé nnó mamfɛɛ́ ayi bɔɔ́ áfɛ́ɛge mbɔ ɛbwɔ́ gɛ́ le áwu bwɔ́ nsa ne ɛbwɔ́ abɔɔ́ mɛ mbɔ. ");
INSERT INTO anvNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Ndɛre ɛlúmbɔ, muú nyú aké apoóge mbya muú, apoó gefɔɔ́ ɛyígé yɛɛ́ muú ayi álu kwɔ́kwɔ́lé ne ji álá kaágé. ");
INSERT INTO anvNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Nnó mampoó ayi dépoóge mbya muú abɛ bíbí. Deké dépyɛmbɔ, ntɛ nyú muú alú mfaánebuú agɛne yɛndé unó bi bɔɔ́ ápyɛɛ́ bíbí achyɛge nyɛ́ nyú nsá.” ");
INSERT INTO anvNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Jisɔs afɛ mbɛ mánlɛré aké, “Ne yɛ́ndégébé, ɛnyú deké denɛnemmyɛ, dénɛ́gé fɔ́ ɛké bɔɔ́ abi ábwɔ́légé gemɛge bwɔ́ néndé, ɛbwɔ́ ágbóo mantɛné tɛ́né né macha mmyɛmenɛne ne mapeá anɔɔ́ mati ánɛ́nemmyɛ nnó bɔɔ́ ágɛ́né ɛbwɔ́. Me ngarege ɛnyú wáwálé nnó mangɛ ayi bɔɔ́ ágɛ́ne mbɔ ɛbwɔ́, gɛ́ le áwú bwɔ́ nsá ne ɛbwɔ́ ábɔɔ́ mɛ mbɔ. ");
INSERT INTO anvNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Ndɛre ɛlúmbɔ, yɛ́ndégébé muú nyú aké ákɛ́lege manɛmmyɛ, ajyɛ akpɛ mmu gepú jií, mbaá ayi ji abɛɛ́ jimbií, agbɛ́ gepú, anɛmmyɛ mbaá ntɛ wuú Ɛsɔwɔ ayi alá gɛ́né ji ne amɛ. Ne ntɛ wuú ayi agɛne yɛ́ndé unó bi bɔɔ́ ápyɛɛ́ yɛ́ndé mbaá, achyɛge nyɛ́ ji nsá. ");
INSERT INTO anvNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Ne muú nyú aké anɛnemmyɛ ájɔɔ́gé mejɔɔ́ ɛwé ɛlá pɔ́ ne mekpo ne ula ndɛre bɔɔ́ abi álá pɔ́ bɔɔ́ Jus ápyɛɛ́. Gétúgé ɛbwɔ́ áfɛ́rege nnó ájɔɔ́gé mejɔɔ́ dɔɔ́ ne Ɛsɔwɔ awú mmyɛmenɛne bwɔ́. ");
INSERT INTO anvNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Débɛgé fɔ́ ɛké ɛbwɔ́, néndé ntɛ nyú Ɛsɔwɔ akaá mɛ́ genó ɛyigé dékɛ́lege gemɛ́gé nnó degií ji. ");
INSERT INTO anvNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Ne yɛndégébé déké dénɛnémmyɛ nɛge na, Ntɛ ɛsé Ɛsɔwɔ, wɔ yi ɔ́lú mfaánebuú, pyɛ́ mabɔ mmyɛ́ mábɛ́ ne ɛ́nógé. ");
INSERT INTO anvNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Pyɛ gefwa jyɛɛ́ géchwɔ́. Pyɛ bɔɔ́ apyɛge ɛlé genó ɛyigé wɔ ɔ́kɛlege fa mme nkane ápyɛɛ́ né mfaánebuú. ");
INSERT INTO anvNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Chyɛgé ɛsé menyɛɛ́ yi dékɛ́lege bií ne bií. ");
INSERT INTO anvNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Jinte gabo yi ɛse dépyɛ ɛta wyɛ ndɛre ɛse ntó déjígente gabo yi bɔɔ́ ápyɛɛ́ ɛta ɛsé. ");
INSERT INTO anvNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Ɔ́kamégé ɛsé dékpɛ́ né mmuameno ayi apyɛ ɛsé dékwéne né gabo. Yɛ́mbɔ féré ɛsé né amu danchɔmeló. ");
INSERT INTO anvNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Mbɔ ne débɔɔ́ manɛmmyɛ. Né ɛbɛgé ɔjigé nte gabo yi atɛ bɔɔ́ apyɛ́ ne ɛta wyɛ́, Ntɛ wyɛ Ɛsɔwɔ né mfaánebuú ajigé ntó nte gabo wyɛ yi ɔpyɛ́. ");
INSERT INTO anvNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Yɛ́mbɔ ɔlá jinte gabo ayi atɛ bɔɔ́ ápyɛ́ né ɛta wyɛ́ wɔ́, Ntɛ wyɛ́ Ɛsɔwɔ ajígé nyɛ́ fɔ́ ntó nte gabo wyɛ yi ɔpyɛ.” ");
INSERT INTO anvNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Ne yɛ́ndégébé deké délyage menyɛɛ́ kpékpé gétúgé depɔré Ɛsɔwɔ, ɛkagé déla meshwɛmeshwɛ nkane bɔɔ́ abi ábwɔ́légé gemɛgé bwɔ́ ápyɛɛ́. Ɛbwɔ́ álaá meshwɛmeshwɛ ɛké bɔɔ́ abi ágɛne ɛfwyale, nnó bɔɔ́ ákaá nnó ɛbwɔ́ ályá menyɛɛ́ kpékpé. Me ngarege ɛnyú wáwálé nnó mangɛ́ ayi bɔɔ́ ágɛ́ne mbɔ ɛbwɔ́, gɛ́ le awu bwɔ́ nsá ne ɛbwɔ́ ábɔɔ́ mɛ mbɔ. ");
INSERT INTO anvNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Ne ɛ́bɛgé muú nyú alyagé menyɛɛ́ kpékpé gétúgé depɔré Ɛsɔwɔ, áshwɔ́né ushu bií, áwaá maweé, ne achá mejwɛ́ wuú. ");
INSERT INTO anvNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Muú nyú apyɛgé mbɔ, bɔɔ́ ákágé fɔ́ nnó alyá menyɛɛ́ kpékpé, ɛ́lé Ntɛ wuú Ɛsɔwɔ muú akaáge unó bi bɔɔ́ ápyɛɛ́ bíbí ne akaáge nyɛ. Ne Ntɛ wuú Ɛsɔwɔ muú agɛ́ne yɛ́ndégenó ɛyigé ji apyɛɛ́ bíbí, achyɛge nyɛ́ ji nsá.” ");
INSERT INTO anvNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Ɛkagé désɛ́lé gefwage nyú dékwígé fa mme, mbaá ayi baá menya ne nfrákáŋ ányɛ́ɛ nyɛ geji, ne ánjó ntó ágyále gepú ákpɛ ákpá yɛndé genó. ");
INSERT INTO anvNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Genó ɛyigé yɛ́ndémuú abɔɔ́ mampyɛ gelu nnó ábélé gefwa ji né mbaá yi Ɛsɔwɔ mbɔɔ́ gefwa alú, mbaá yi baá menya ne nfrákáŋ álá kaágé anyɛ ne ánjó ntó álá kágé gyá gepú ákpá yɛndégenó.” ");
INSERT INTO anvNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Nénde, mbaá ayi muú ábélege gefwa jií, ɛfɛɛ́ ntó ne metɔɔ́ wuú ɛbɛ́ɛ. ");
INSERT INTO anvNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Ámɛ́ mekwaá álu ɛke ɛtúlékáŋ né menyammyɛ wuú meko. Ne mbɔgé amɛ jyɛ́ álú chánchá, ɛbyɛnnó menyammyɛ wyɛ́ meko abɛɛ́ ne geŋgbɔ́. ");
INSERT INTO anvNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Ne ɛbɛgé amɛ jyɛ́ ala apɔ́ chánchá menyammyɛ wyɛ́ meko akwene gemuagemua. Ne mbɔgé genó ɛyi gepyɛ wɔ ɔgɛ́ne mbaá gekwege gemua, ɛ́byɛnnó menyammyɛ wyɛ́ meko alu mmu gekpɛkpɛ́gé gemua.” ");
INSERT INTO anvNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Muú ama ákágé kpá fɔ́ defwɛ́ mbaá bɔɔ́ apea gébé gemaá. Ápyɛgémbɔ, apaá nyɛ́ ama agboó ne ayifɔ. Ne ánogé nyɛ́ ama abyaá ayifɔ. Ɛnyú dekágé nógé fɔ́ Ɛsɔwɔ ne ŋka gébé gemaá. ");
INSERT INTO anvNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Gɛ́ ula bi ngarege ɛnyú nnó déchyɛgé fɔ gemɛge nyú ɛfwyale, désómégé nnó dényɛ́ nyɛ́ ndé? Dényuú nyɛ́ ndé? Ne defyɛɛ́ nyɛ́ ndé? Geŋwáge mekwaá gepwɔ menyɛɛ́ wɔ́? Ne menyammyɛ mekwaá apwɔɔ́ mandeé mamfyɛ́ wɔɔ́? ");
INSERT INTO anvNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Pɛ́ge denywɔné, detí depɛné menyɛɛ́, déferege ne débélégé mbwɛ́, yɛ́mbɔ ntɛ nyú muú álu né mfaánebuú achyɛge détí menyɛɛ́, nnó ɛnyú deŋeá gemɛ dépwɔɔ́ deti wɔɔ́? ");
INSERT INTO anvNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Déchyɛgé fɔ gemɛ nyú ɛfwyale, ndé muú nyú ayi mesóme wuú ɛkáge gbɛ́ɛ yɛɛ́ bií uma né amŋmɛ ayi Ɛsɔwɔ achyɛ́ ɛnyú nnó débɛ́lé fá mme? ");
INSERT INTO anvNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Ulannó déchyɛgé gemɛge nyú ɛfwyale gétúgé mandeé? Pɛ́ge dégɛ́ unɔɔ́ mewaá ɛbi úkome ukoó ulɔ́úlɔ́ ndɛre úwɛ́né, úpyɛ́ fɔ́ utɔɔ́, ukwyɛ́ge yɛ mandeé. ");
INSERT INTO anvNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Yɛ́mbɔ ngarege ɛnyú wáwálé nnó yɛ Mfwa *Solomun ayi abɔ́ awyá unó uko, apɔ́ yɛ ne nkú ayi alɔmé akwɔné ukoó ɛbi unɔɔ́ bina. ");
INSERT INTO anvNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Mbɔgé Ɛsɔwɔ achyɛge bya mewaá bina ukoó ulɔ́úlɔ́. Bya ɛbí fina úlú ubɛ geyá úgbó átuú áfyɛ́ mewɛ, defɛré nnó ákágé chyɛɛ́ fɔ́ ɛnyú mandeé apwɔ ndɛre ji apɛle bya mewaá? Metɔɔ́ ɛwé ɛnyú defyɛɛ́ ne Ɛsɔwɔ ɛ́ŋené kpaá ɛ́pwɔ amu. ");
INSERT INTO anvNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Désómégé sé déshaágé mmyɛ nnó dényɛ́ nyɛ́ ndé? Dényuú nyɛ́ ndé? Ne défyɛɛ́ nyɛ́ ndé? ");
INSERT INTO anvNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","ɛlé bɔɔ́ abi álá pɔ́ bɔɔ́ Jus ne anɛrege matɔɔ́ né ufɔɔ́ unó bina. Kaágé nnó Ntɛ nyú Ɛsɔwɔ muú alu mfaánebuú akaá mɛ nnó debɔ mambɛ ne ubi uko. ");
INSERT INTO anvNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Ne bɔ́ge mbɛ dékɛlé kpɛ́ meti ɛwé Ɛsɔwɔ abɛɛ́ mfwa nyú depyɛgé unó bi ji ákɛ́lege, dépyɛgé mbɔ, achyɛge nyɛ ɛnyú unó bina uko. ");
INSERT INTO anvNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Ne déchyɛgé fɔ ɛfwyale né menyammyɛ ɛnyú désómégé gétúgé unó bi geyá, yɛ́ndé bií uwyá ɛti depɔ ɛti déchwɔɔ́ ne ubi. Desɛge fɔ ɛfwyale ɛwé bií ɛbi chá décho ne ɛwe fina.” ");
INSERT INTO anvNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Dépagé mpa atɛ ne defya, nnó ɛ́kagé Ɛsɔwɔ apa awe nyú. ");
INSERT INTO anvNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Néndé gefɔɔ́ ɛyigé dépáne mpa atɛ, wyɛ́mbɔ ntó ne Ɛsɔwɔ ápáne awu nyú. Gefɔɔ́ ɛyígé démɛge genó déchyɛ́ge muú, mbɔntó ne ámɛge nyɛ áchyɛɛ́ ɛnyú. ");
INSERT INTO anvNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Ulannó ɔ́chɛ́rege ɛkɛ́kɛ́ gabo ayi alu ɛke maá gejwaá né dambɔɔ́nnyi ntɛ meŋmɛ́ wyɛ́ ɔla ɔfyɛɛ́ mekpo ne gabo ayi alu ɛke mekwɔkwɔ né dambɔɔ́nnyi awyɛ wɔmbɔɔ́? ");
INSERT INTO anvNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Ɛ́pyɛmbɔ nnó ne ɔjɔɔ́ ne meŋmɛ́ wyɛ́ nnó, ‘Lɛ́ré me nféré wɔ maá gejwaá ayi alú wɔ né dambɔɔ́nnyi’ ayi ɔ́lá gɛ́né mekwɔkwɔ ɛwé ɛkwere wɔmbɔɔ́ né dambɔɔ́nnyi? ");
INSERT INTO anvNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Wɔ muú dembwɔ́lé bɔ́ kpɛ́ mbɛ féré ntó mekwɔkwɔ ɛwe ɛlú wɔ́ né dambɔɔ́nnyi, ɔké ɔgɛne mbaá cháŋéné ne ɔféré ɛkɛ́kɛ́ gejwaá ɛwé ɛ́lú meŋmɛ́ wyɛ né dambɔɔ́nnyi. ");
INSERT INTO anvNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Débɔgé fɔ unó Ɛsɔwɔ déchyɛ́ mbaá bɔɔ́ abi álá bɔɔ́ gébé ne ji wɔ́. Álu ɛké bɔ mammyɛ. Depyɛgé mbɔ abwɔlege mmyɛ ánɔ ɛnyú. Débɔgé fɔ́ genó gelɔ́gélɔ́ déchyɛ́ge mbaá bɔɔ́ abi álú ɛké ukwende, depyɛgé mbɔ ájyárege geji ne uká ábulé né utwɔntwɔ. ");
INSERT INTO anvNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Gige wyɛ Ɛsɔwɔ gige, achyɛge nyɛ́ ɛnyú unó bi dekɛlege, kɛlege wyɛ kɛlege ápyɛ nyɛ́ ɛnyú degɛ ubi. Dóoge wyɛ menombi doó, anénege nyɛ ɛnyú ɛwú. ");
INSERT INTO anvNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Néndé muú yi agigé genó, asɛle nyɛ, ne ayi akɛlégé, agɛne nyɛ, ne muú yi adogé menómbí, ánénege nyɛ́ ji ɛ́wú. ");
INSERT INTO anvNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Ndé muú nyú ayi maá wuú agigé ji brɛd áchyɛ́ge ji ntaá? ");
INSERT INTO anvNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Ne yɛ ɛbɛ ɛlé nnó agií ji meshuú áchyɛ́ge ji mmyɔ? ");
INSERT INTO anvNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Mbɔgé ɛnyú ákwaá abi délú bɔɔ́ nchyɛ, dechyɛge unó ulɔ́úlɔ́ mbaá baá nyú, ndé gepyɛ ne Ntɛ nyú Ɛsɔwɔ muú alu né mfaánebuú alá chyɛ́gé unó ulɔ́úlɔ́ mbaá bɔɔ́ abi ágíge ji ubi? ");
INSERT INTO anvNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Depɔ deko ɛtire menjɔɔ́ mbɔ delú nnó, pyɛ́gé ɛtá bɔɔ́ wyɛ́ genó ɛyígé dekɛ́lege nnó ápyɛ ɛta nyú. Gɛ́ mémma mechɔ ɛwé mabɛ́ Mosis ne bɔɔ́ ɛkpávɛ́ Ɛsɔwɔ ábɔ́ ásamé na. ");
INSERT INTO anvNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Koóge né menómbi ɛwé ɛ́lú mámálé néndé ɛwé muú akogé wyɛ ajyɛ né meti negbo ɛlu fuú. Ne gejamégé bɔɔ́ ákwɔ́lege le ɛ́wú. ");
INSERT INTO anvNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Yɛ́mbɔ menombi ɛwé muú ákóge wyɛ́ ájyɛɛ́ né meti geŋwá ɛyi gélágé byɛ́ ɛ́lú mámálé ne meti ɛwémbɔ ɛ́pɔ́ kɔkɔge. Ne bɔɔ́ abi ágɛne ɛwu ája wɔ́. ");
INSERT INTO anvNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Sɛ́ge gébé ne bɔɔ́ gebyɔ́ abi áké álú bɔɔ́ ɛkpávɛ́ Ɛsɔwɔ. Ɔgɛgé ɛbwɔ́ né amɛ álú nyameé ɛké magɔ́nŋme, nsanjí ɛ́lé ukwaála. ");
INSERT INTO anvNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Dekage nyɛ́ ufɔɔ́ bɔɔ́ ɛbi ɛbwɔ́ álú né gepɔ ɛyigé ɛbwɔ́ áwyaá, wyɛ ndɛre ákáge genɔɔ́ né umpomé bií. Muú ákágé jyɛ fɔ́ né dánsɔ ákyɛ́ gempomé ɛyigé gegɔɔ́. Muú ajyɛ fɔ́ né agbójɛ́lé ákyɛ́ geloge sokoro. ");
INSERT INTO anvNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Unɔɔ́ ulɔ́ulɔ́ uwɔme umpomé ulɔ́úlɔ́, ɛbi uboubo uwɔme umpomé uboubo. ");
INSERT INTO anvNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Genɔɔ́ gelɔ́gélɔ́ géwɔ́mé fɔ́ umpómé uboubo ne ɛyi gebogebo géwɔ́mé fɔ́ umpomé ulɔ́úlɔ́. ");
INSERT INTO anvNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Ne yɛ́ndé genɔɔ́ ɛyí gélágé wɔ́mé umpomé ulɔ́úlɔ́ mbɔɔ́ mekɔɔ́ ákɛle geji ásɔré áfyɛ́ mewɛ. ");
INSERT INTO anvNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Mechɔ́ ɛwé me njɔɔ́ mbɔ, ɛlú nnó, dékaáge nyɛ́ bɔɔ́ gebyɔ́ abi áké álú bɔɔ́ ɛkpávé Ɛsɔwɔ né gepɔ ɛyigé ɛbwɔ́ áwyaá. ");
INSERT INTO anvNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Jisɔs ama jyɛ mbɛ mánjɔɔ́gé aké, “Ɛpɔ́fɔ́ yɛ́ndémuú ayi akúu me ‘Ata Ata’, ne anyɛɛ́ nyɛ́ gefwage Ɛsɔwɔ. Ɛle bɔɔ́ abi ápyɛ́ genó ɛyigé ntɛ wa Ɛsɔwɔ muú alu né mfaánebuú akɛ́lege ne anyɛ́ nyɛ geji. ");
INSERT INTO anvNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Ne bií mpa Ɛsɔwɔ úkwɔnégé, bɔɔ́ ájɔɔ́ge nyɛ́ ne me áké, ‘Ata Ata! Pɔ nnó ɛsé ne Ɛsɔwɔ apyɛ dégáre ná bɔɔ́ mekomejɔɔ́ ayi atané ɛta wuú né mabɔ myɛɛ́? Déma débuú gejamégé aló nchyɛ ne déma depyɛɛ́ ntó ukpɛkpɛ unó né mabɔ myɛɛ́?’ ");
INSERT INTO anvNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Bií bi mbɔ ngarege ɛbwɔ́ gbɔ́gɔ́nɔ́ nnó, ‘Kwílege me ushuú ɛnyú bɔɔ́ abi déla pyɛɛ́ unó bi Ɛsɔwɔ ákɛlege, nkágé fɔ́ ɛnyú!’ ");
INSERT INTO anvNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Ne yɛ́ndémuú ayi awuúge unó bi ngare mbɔ uko ne ápyɛɛ́ ndɛre ájɔɔ́ alu ɛké muú déŋgá ayi átɛné gepú jií né mfaá ɛtárávɛ́; ");
INSERT INTO anvNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","yɛ́ manaá ákwe, mannyi akpɛ, ne mbyo amyɛ gepú ɛyigémbɔ gekwene fɔ́, gétúgé átɛ́né géjí né mfaá ɛtárávɛ́. ");
INSERT INTO anvNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Ne yɛ́ndémuú ayi awúu mekomejɔɔ́ wa yina, ne álá pyɛɛ́ fɔ ndɛre ákɛ́lege; alu ɛké, geŋkekenegé muú ayi atɛné gepú jií né mfaá gesɔɔ́. ");
INSERT INTO anvNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Manaá ákwegé, mannyi ákpɛgé, mbyo ammyɛgé, gepú ɛyigémbɔ gékwé mme kpakpa!” ");
INSERT INTO anvNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Jisɔs anérégé manjɔɔ́ depɔ ɛtire na, gejamégé bɔɔ́ abi álú ɛ́fɛɛ́ ála mano mekpo fuú né gefɔɔ́ ɛyígé ji álɛ́rege, ");
INSERT INTO anvNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","néndé álɛ́rege ne ncha ayi atane mbaá Ɛsɔwɔ ɛ́pɔ́fɔ́ ɛke ánlɛré mabɛ́ Ɛsɔwɔ. ");
INSERT INTO anvNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Jisɔs ánérégé mánlɛre unó bina né mfaá mekwɛ́ áshulé mme. Gejamégé bɔɔ́ ákwɔlé ji. ");
INSERT INTO anvNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Áké ápɛ́le muú ubá fɔ achwɔ́ tó ji mánó mbɛ ushu, anɛ ji mmyɛ aké, “Ata mbɔgé ɔkɛlege, pyɛ me nkpea.” ");
INSERT INTO anvNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Jisɔs anyaá ɛbwɔ wuú ata ji aké, “Me nkɛlege, ubá byɛ́ ubyɛ́, kpea.” Tɛ́nétɛ́né yimbɔ mende yimbɔ akpea. ");
INSERT INTO anvNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Jisɔs ajɔɔ́ ne ji aké, “Ɛ́kagé ɔ́pyɛ muú fɔ́ akaá genó ɛyi gépyɛ ne wɔ. Chó lɛ́ré lé mmyɛ jyɛ́ mbaá mémpyɛ́ upɛ Ɛsɔwɔ áchɛ́ré agɛ́ nnó ɔtoó. Ne chyɛɛ́ genó ɛyígé ɛbɛ́ Mosis ɛ́jɔɔ́, mampyɛ bɔɔ́ ákaá nnó ɔtoó.” ");
INSERT INTO anvNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Jisɔs afɛ́ né melɔ́ Kapanɔm, ákwɔ́négé wyɛ́, muú kpaá bɔɔ́ bee né Rom ajyɛ báne Ji ne alɔ mánɛ ji mmyɛ, nnó apoó ji. ");
INSERT INTO anvNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Aké, “Átá maá defwɛ́ wa amee, akɔre ala mmu bɛ́lé ne ubalé.” ");
INSERT INTO anvNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Jisɔs ajɔɔ́ ne ji aké, “Nchwɔ́ pyɛ́ nyɛ́ ji atoó.” ");
INSERT INTO anvNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Ne muú kpaá bɔɔ́ bee yimbɔ aké, Ata nfu yɛ́ muú fɔ́ ayi ɔ́kpɛ́ne gepú ɛyá wɔ́, yɛ́mbɔ wɔ jɔɔ́ lé genó ne maá defwɛ́ wa atoge nyɛ. ");
INSERT INTO anvNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Ɛlé mentó nwya bɔɔ́ kpakpa né mbɛ, abi me nwúu ne ɛbwɔ́. Ájɔɔ́gé ne me nnó, “Mpyɛ genó ɛyi, mpyɛ. Ne nwya ntó bɔɔ́ bee abi áwúu ne me.” Yɛ́ ayi ndé ne njɔɔ́ge ne ji nnó, “Chó fa ajyɛ, njɔɔ́gé ne yimbɔ nnó chwɔ́ we, achwɔ́.” Ne njɔɔ́gé ntó ne maá defwɛ́ wa nnó pyɛ ɛyi, apyɛɛ́ géji. ");
INSERT INTO anvNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Jisɔs awúgé mbɔ, byɔ uwɔ ji mmu. Abwɔlé mmyɛ ajɔɔ́ ne bɔɔ́ abi ákwɔ́lege ji aké, “Ngarege ɛnyú wáwálé nnó, me nlú daŋgɛ́ muú ayi áfyɛɛ́ metɔɔ́ ne me na, yɛɛ́ ɛ́bɛ́lé né Isrɛli. ");
INSERT INTO anvNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Ngarege ɛnyú nnó gejamégé bɔɔ́ átánege nyɛ́ né umɛ malɔ mme mako ájwɔlé chónchó ne ukwene antɛ se, Abraham, Asek ne Jakɔb manyɛ gefwa ɛyigé Ɛsɔwɔ ágbárege. ");
INSERT INTO anvNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Ne gejamégé bɔɔ́ Isrɛli abi gefwa ɛyigé na gebɔ́ gélú ɛyigé bwɔ́ áfomege nyɛ ɛbwɔ́ dafyɛ́ ála mmu ɛpinyá gemua álíli, ányɛɛ́ máŋɛ́né.” ");
INSERT INTO anvNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Jisɔs ánérégé manjɔɔ́ unó bina ajɔɔ́ yɛ ne muú kpaá bɔɔ́ bee yimbɔ aké, “Kéré meso né gepú jyɛɛ́, ɔkamé nnó Ɛsɔwɔ akaáge pyɛ maá wyɛ́ atoó, chó yɛ́ndégenó gébɛɛ́ wyɛmbɔ.” Wyɛ ndɛre Jisɔs ajɔɔ́ mbɔ maá defwɛ́ yimbɔ atoó. ");
INSERT INTO anvNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Ne Jisɔs alyaágé ɛfɛɛ́, afɛ́ né gepúgé Pita, ndɛre akpɛné mmu, agɛ́ mmá mendée Pita né mfaá ukwɔ́ bɛ́lé, ameé njaja gefwine. ");
INSERT INTO anvNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Jisɔs ajyɛ tá ɛbwɔ wuú. Tɛ́nétɛ́né yimbɔ gefwine gebyɛ́ ji mmyɛ, akwilé ka akɛle menyɛɛ́ achyɛ́ ji. ");
INSERT INTO anvNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Nkwale akwɔ́négé bɔɔ́ áchwɔ́ ne gejamégé bɔɔ́ bwɔ́ abi aló nchyɛ áchyɛ́ge ɛbwɔ́ ɛfwyale mbaá Jisɔs. Ne Jisɔs ányá aló nchyɛ bimbɔ ne mekomejɔɔ́ wuú, átané bɔɔ́ bimbɔ mmyɛ ne apyɛ abi ámée ako átoó. ");
INSERT INTO anvNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Jisɔs apyɛ unó bi nnó genó ɛyigé Asaya muú ɛkpávé Ɛsɔwɔ ájɔɔ́ nyá átome ne ji gebɛ́ wáwálé nnó, “Aferé ɛsé né ubale, apyɛ mamée se ábyɛ́.” ");
INSERT INTO anvNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Jisɔs agɛ́gé nkane gejamégé bɔɔ́ géchwɔ́ nɔɔ́ ji mme, ajɔɔ́ ne baá utɔɔ́ bií aké, “Déchyaá gentógé mewaá dejyɛ́ ɛgbɛ́ né.” ");
INSERT INTO anvNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Gemɛge nnó ɛbwɔ́ áchyaá, menlɛré mabɛ́ Ɛsɔwɔ fɔ, achwɔ́ mbaá Jisɔs aké, “Ménlɛré, nkɛlege nnó me nkwɔ́légé wɔ déjyɛ́gé yɛ́ndé mbaá ayi ɔjyɛ́.” ");
INSERT INTO anvNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Jisɔs ashuú ji meko né nekanémejɔɔ́ aké, “Ushua úwya ambu ayi úbɛ́lege wyɛ́, denwyɔné dewyaá anywa ne me Maá Ntɛ Mekwaá mpɔ́ yɛ ne melu ɛwé nshwɔ́rege mekpo ngbeé mmyɛ.” ");
INSERT INTO anvNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Ne maá utɔɔ́ Jisɔs ayi ama ajɔɔ́ ne ji aké, “Ata gɔ́ njyɛ́ nníi kpɛ́ ntɛ wa ne nchwɔ́.” ");
INSERT INTO anvNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Jisɔs ashuú ji meko aké, “Gɔ́ bɔɔ́ abi álú ɛké áwuú bɔ́ ánií mewu bwɔ́, wɔ kwɔle me.” ");
INSERT INTO anvNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Ndɛre Jisɔs akpɛne mmu ɛ́kpe, baá utɔɔ́ bií ákwɔlé ji nnó áchyaá ájyɛ ɛ́gbɛ́ géntoógé mewaá. ");
INSERT INTO anvNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Ndɛre ɛbwɔ́ áchyaáge, mbyonnyi metometo átané mbelepo alɔ mammyɛ. Amyɛ kpaá apyɛ ŋgbannyi ado ɛ́kpe ɛla mankemanke, yɛ́mbɔ Jisɔs ábɔ́ abɛlege ji gejyá. ");
INSERT INTO anvNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Ne ɛbwɔ́ ájyɛ peé ji áké, “Ata poó ɛsé, déchwɔ́ nó nnyi.” ");
INSERT INTO anvNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Jisɔs ajɔɔ́ ne ɛbwɔ́ aké, “Défɔɔ́ ndé? Metɔɔ́ ɛwé ɛnyú défyɛɛ́ ne me ɛ́pɔ́ ne unɔ.” Ájɔɔ́gé mbɔ akwilé ka, anyá mbyo nnyi yimbɔ nnó átɛ́né! Atɛné, mbaá akwené tɔmeé. ");
INSERT INTO anvNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Mechɔ ɛwé ɛ́pyɛ baá utɔɔ́ bií ála mano mekpo fuú ájɔɔ́ge ne atɛ áké, “Ndé gefɔgé muú ná, ayi ányáge yɛ́ mbyo nnyi ne ngba nnyi áwuú ji?” ");
INSERT INTO anvNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Jisɔs ne baá utɔɔ́ bií áchyagé gentoógé mewaá, áfɛ́ né gebagé mewaá Gadarɛn. Ákwɔ́négé ɛ́wu, ande fɔ ápeá abi aló nchyɛ áchyɛge ɛbwɔ́ ɛfwyale átane né manómé bɔ́ mbaá ayi ɛbwɔ́ ájwɔlege áchwɔ́ báne Jisɔs. Ande bimbɔ ápyɛ ɛfɔ kpaá tɛ bɔɔ́ ákámégé sé mánkógé né meti ɛwémbɔ. ");
INSERT INTO anvNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Ndɛre ɛbwɔ́ ágɛné Jisɔs, álɔ mánkálegé áké, “Wɔ Maá Ɛsɔwɔ, ɔbɔ́ ndé mechɔ́ ne ɛsé? Ɔchwɔ́ chyɛ ɛsé ɛfwyale ayi gébége ɛyige Ɛsɔwɔ áchyɛ ɛsé géláge kwɔne wɔ́”? ");
INSERT INTO anvNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Ɛ́ké ɛ́pyɛmbɔ, nfɔné mekwɛnde fɔ nébɔ́ nényɛɛ́ ɛ́fɛɛ́ kwɔ́kwɔ́lé, ");
INSERT INTO anvNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","aló nchyɛ abi álú ande bimbɔ né mmyɛ ánɛ Jisɔs mmyɛ áké, “Mbɔgé ɔbuúge ɛsé, te ɛsé déjyɛ dékpɛ́ né nfɔné mekwɛnde ɛniné mbɔ.” ");
INSERT INTO anvNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Jisɔs ajɔɔ́ yɛ́ ne abi aké, “Tánége déjyɛ.” Aló nchyɛ bimbɔ átané ájyɛ kpɛ́ nfɔné mekwɛnde ɛníné mbɔ né mmyɛ. Ɛfɛɛ́ mbɔ nfɔné mekwɛnde ɛniné mbɔ nésɔɔ́ ne gatɛlé, né shulé mékwɛ né kwe mmu gentoóge mewaá né nyú manaá négbo. ");
INSERT INTO anvNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Ámbamé mekwɛnde ɛyimbɔ, ágɛ́gé ndɛre ɛpyɛɛ́, ábó gatɛlé áfɛ́ né melɔ ágaré genó ɛyi gépyɛɛ́ ne ande bimbɔ. ");
INSERT INTO anvNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Awúgé mbɔ, melɔ meko ɛtané manjyɛ báne Jisɔs, ɛ́gɛ́gé ji ɛ́nɛ ji mmyɛ nnó ályaá mewaá bwɔ́. ");
INSERT INTO anvNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Jisɔs alyágé bɔɔ́ melɔ Gadarɛn, ákeré meso né mbále gentoógé mewaá, akpɛ ɛkpée achyaá afɛ́ né melɔ ɛwé ji ájwɔlege wyɛ́. ");
INSERT INTO anvNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Ákwɔ́négé wyɛ́, bɔɔ́ fɔ ákpá muú úchánchi fɔ né ulɔ́ áfɛ́ ne ji ɛta wuú nnó apyɛ́ ji átoó. Ne Jisɔs agɛ́gé nnó bɔɔ́ bimbɔ áfyɛɛ́ matɔɔ́ ne ji wáwálé nnó ji akaáge pyɛ muú úchanchi yimbɔ atoó, áké ne mende úchánchi yimbɔ, “Maá wa, gbaré metɔɔ́, ɔ́fɔ́gé, ájiínte gabo wyɛɛ́.” ");
INSERT INTO anvNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Ɛwéna ɛpyɛ ánlɛré mabɛ́ Ɛsɔwɔ fɔ abi álú wyɛ́ álɔ mangígé atɛ nnó, “Mende yina abɔɔ́ fɔ́ mamɛɛ́ mmyɛ ne Ɛsɔwɔ wɔ́.” ");
INSERT INTO anvNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Jisɔs akaá genó ɛyigé ɛbwɔ́ áfɛ́rege, ne agií ɛbwɔ́ aké, “Ulannó ɛnyú déwya ufɛ́ré uboubo né mmu matɔɔ́ nyú? ");
INSERT INTO anvNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Ndé gelu pere manjɔɔ́, ‘Nnó ájiínte gabo wyɛ́’, waá manjɔɔ́ nnó, ‘Kwile tɛ́né kɛ’? ");
INSERT INTO anvNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Nkɛlege mámpyɛ ɛnyú dékaá nnó Maá Ntɛ Mekwaá awyaá uto fa mme manjinte gabo mekwaá. Ɛfɛɛ́ ajɔɔ́ yɛ́ ne muú úchánchi yimbɔ aké, “Kwilé ka kpa ulɔ́ byɛɛ́ chó mmu.” ");
INSERT INTO anvNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Muú úchánchi yimbɔ atoó, akwilé ka akpá ulɔ́ bií awulé né gepú jií. ");
INSERT INTO anvNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Bɔɔ́ ágɛ́gé genó ɛyigé pyɛ́, ɛfɔ́ ɛ́kwɔ́ ɛbwɔ́ matɔɔ́. Álɔ mamfɛ́gé Ɛsɔwɔ gétúgé gefɔge uto ɛbi ji achyɛɛ́ akwaá. ");
INSERT INTO anvNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Jisɔs alyágé mbaá yimbɔ, ákɛne ájyɛɛ́, agɛ́ mende fɔ ayi akamege Matyo ménsɛlé ŋkamakpo. Ji ajwɔlé né melú utɔɔ́ wuú, Jisɔs akuú ji aké, “Kwɔ́lé me.” Ne akwilé ka alɔ mankwɔlé ji. ");
INSERT INTO anvNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Ɛ́wyágé, Matyo anɛ Jisɔs né gepú jií, ndɛre Jisɔs ajwɔle ányɛɛ́ menyɛɛ́ ne baá utɔɔ́ bií, gejamégé ánsɛlé ŋkamakpo ne bɔɔ́ ubeé áchwɔ́ bane bɔ Jisɔs ányɛɛ́ menyɛɛ́ ne ɛbwɔ́. ");
INSERT INTO anvNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Bɔɔ́ Farasi fɔ ágɛ́gé mbɔ, ágií baá utɔɔ́ Jisɔs áké, “Ulannó ne ménlɛré ɛnyú anyɛɛ́ menyɛɛ́ ne ánsɛlé ŋkamakpo ne bɔɔ́ ubeé?” ");
INSERT INTO anvNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Jisɔs awúgé genó ɛyígé ɛbwɔ́ ágií baá utɔɔ́ bií, ató ɛbwɔ́ neka aké, “Bɔɔ́ abi álá meé, ákɛ́légé fɔ́ muú uka, ɛ́lé abi ámeé ne ákɛ́lege.” ");
INSERT INTO anvNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","“Chóge dégí dékaá genó ɛyigé ŋwɛ Ɛsɔwɔ agaré ɛsé. Ásá wyɛ nnó, genó ɛyigé me nkɛ́lege, gelu nnó ákwaá ágɛne atɛ meshwɛ ɛ́pɔ́fɔ́ upɛ manpyɛge ɛta wa. Kaáge nnó nchwɔ́ kú fɔ́ bɔɔ́ abi álú cho né mbɛ ushu Ɛsɔwɔ wɔ́, nchwɔ́ lé mánkú bɔɔ́ abi ápyɛɛ́ ubeé.” ");
INSERT INTO anvNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Baá utɔɔ́ Jɔn ménwyaá bɔɔ́ manaá Ɛsɔwɔ áchwɔ́ gií Jisɔs áké, “Ulannó ɛsé ne bɔɔ́ Farasi délyáge menyɛɛ́ kpékpé gétúgé depɔré Ɛsɔwɔ ne baá utɔɔ́ byɛ́ álá pyɛ fɔ́ mbɔ”? ");
INSERT INTO anvNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Jisɔs ashuú ɛbwɔ́ meko aké, “Nnó ájeé menɔ neba ályage menyɛɛ́ kpékpé ayi menɔ neba alu ne ɛbwɔ́? Cháchá. Yɛ́mbɔ gébé gebɛɛ́ nyɛ ɛyígé menɔ neba álá bɛɛ́ nyɛ́ sé ne ɛbwɔ́, ɛ́fɛɛ́ ne ályáge nyɛ́ menyɛɛ́ kpékpé né mboó gébé gétúgé depɔré Ɛsɔwɔ.” ");
INSERT INTO anvNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Ne muú akaágé sɛ́ fɔ́ gebagé ndeé gekɛ akwɔmé ɛmbu né ndeé ɛyi gekwéne. Apyɛgé mbɔ, gebagé ndeé ɛyigémbɔ génywerege nyɛ gépyɛ ndeé yimbɔ ɛgyalé dɔɔ́. ");
INSERT INTO anvNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Ɛ́lɔ́mé fɔ́ ntó nnó muú akpá mmɔɔ́ makɛ áfáné mmu ukwéne unó mmɔɔ́ ɛbi akwyɛɛ́ ne mekɔ menya. Apyɛgé mbɔ, mmɔɔ́ mimbɔ mabɛne nyɛ́ mapyɛ ukwene unó mmɔɔ́ ɛbimbɔ ugbɔ ne mmɔɔ́ mawule mme. Muú abɔgé mmɔɔ́ makɛ afyɛɛ́ lé né mmu unó mmɔɔ́ ukɛ. Apyɛgé mbɔ mmɔɔ́ ne unó mmɔɔ́ ubɛ́ɛ nyɛ cháŋéné. ");
INSERT INTO anvNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Ndɛre Jisɔs alú jɔ́ɔge ne ɛbwɔ́, aké ápɛle, muú kpaá fɔ achwɔ́ kwé ji uká, alɔ manjɔɔ́ ne ji aké, “Maá wa ayi mendée agbo mbɔ wyɛ nana. Nnɛ́ wɔ mmyɛ, Ata chwɔ́ nɛre ji ɛbwɔ mmyɛ, apege nyɛ.” ");
INSERT INTO anvNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Jisɔs akwilé ka ne baá utɔɔ́ bií ákwɔle mende yimbɔ. ");
INSERT INTO anvNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Ndɛre ájyɛɛ́, mendée yi agɛ́ne mɛ ɛfwyale dɔɔ́ ayi manoó mabɔ matanégé ji mbɛ málɛ́ aŋmɛ́ áfyá ne ápeá, achwɔ́ ji né meso ata manó nku wuú. ");
INSERT INTO anvNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Ɛlé ji abɔ afɛré mɛ né metɔɔ́ wuú nnó, “Mbɔgé ntagé yɛ́ lé nku wuú, ntoge nyɛ.” ");
INSERT INTO anvNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Jisɔs abwɔlé mmyɛ agɛ́ mendée yimbɔ ajɔɔ́ ne ji aké, “Gbaré metɔɔ́ maá wa, ɔtoó gétúgé ɔfyɛɛ́ metɔɔ́ wyɛ ne me.” Tɛ́nétɛ́né yimbɔ mendée yimbɔ atoó. ");
INSERT INTO anvNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Jisɔs akoó yɛ́ afɛ́ né gepúgé muú kpaá yimbɔ. Ákwɔ́négé né gepúge Jarɔs, agɛ́ bɔɔ́ ndɛre álíle ne gejamégé abifɔ nkane ákwéle ubeé áfɔ́mege ambya. ");
INSERT INTO anvNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Ajɔɔ́ ne ɛbwɔ́ aké, “Chógé, mesɔ́ mendée yina agbo wɔ́, abɛlege lé géjyá.” Jisɔs ajɔɔ́gé mbɔ, bɔɔ́ bimbɔ álɔ manjwáné ji jwané. ");
INSERT INTO anvNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Ne Jisɔs ábúgé bɔɔ́ bimbɔ ako átánégé dafyɛ, ákpɛ mmu ágbaré ɛbwɔ mesɔ́ mendée yimbɔ, apyɛ ji apeé, akwilé ka. ");
INSERT INTO anvNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Ne ngɔ́ mechɔ́ ɛwéná akwɔ́ akwɔné malɔ mako né gebagé mewaá ɛyígémbɔ. ");
INSERT INTO anvNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Ndɛre Jisɔs alyaá gepúgé Jarɔs ajyɛɛ́, bɔɔ́ amɛ nónómé fɔ apea álɔ mankwɔ́légé ji ábɛɛ́ge áké, “Jisɔs, Mpyáne Dɛvid gɛ́ ɛsé meshwɛ.” ");
INSERT INTO anvNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Jisɔs akwɔ́négé né mmu gepú ɛyigé ji ajwɔ́lege ande bimbɔ ájyɛ báne ji. Jisɔs agií ɛbwɔ́ aké, “Nnó ɛnyú défyɛɛ́ matɔɔ́ ne me nnó nkage pyɛ ɛnyú dégɛ́ne?” Ákamé áké, “Ata défyɛ.” ");
INSERT INTO anvNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Ákámégé mbɔ, Jisɔs ata amɛ bwɔ́ aké, “Ɛ́bɛ́ wyɛ́ ndɛre ɛnyú défyɛɛ́ metɔɔ́ ne me.” ");
INSERT INTO anvNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Bɔɔ́ bimbɔ álɔ mángɛ́né mbaá. Ne Jisɔs aji ɛbwɔ́ ɛtu aké, “Ɛ́kagé dépyɛ muú ákaá mechɔ ɛwena.” ");
INSERT INTO anvNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Yɛ́mbɔ ájyɛ́gé ákage cho metɔɔ́ ápyɛ ngɔ́ Jisɔs akwɔ́ akwɔné malɔ mako gétúgé utɔɔ́ bí ji apyɛ ɛta bwɔ́. ");
INSERT INTO anvNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Ne wyɛ ndɛre ande bina makpó ápeá ályaá ájyɛɛ́, bɔɔ́ fɔ áchwɔ́ ne muú fɔ mbaá Jisɔs ayi meló nchyɛ apyɛ́ ji álaá mbú. ");
INSERT INTO anvNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Jisɔs ábúgé meló nchyɛ yimbɔ, mbú yimbɔ alɔ mejɔɔ́ manjɔ́gé. Ne gejamégé bɔɔ́ abi álú ɛ́fɛɛ́ ágɛ́gé mbɔ, matyɛ mawá ɛbwɔ́ meno álɔ manjɔgé áké, “Délú daŋgɛ́ gefɔgé genó ɛyina gepyɛ fana né melɔ Isrɛli.” ");
INSERT INTO anvNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Yɛ́mbɔ bɔɔ́ Farasi ájɔɔ́ áké, “Ɛ́lé danchɔmeló mfwa áló nchyɛ ne achyɛɛ́ ji uto nnó ábúgé áló nchyɛ”. ");
INSERT INTO anvNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Jisɔs alyage ɛfɛɛ́ akɛne ajyɛɛ́ né malɔ ayi kɔkɔɔ́ ne ayi kpakpa, alɛrege bɔɔ́ mekomejɔɔ́ Ɛsɔwɔ né mmu macha mmyɛmenɛne bɔɔ́ Jus. Ama agarege ntó bɔɔ́ abya melɔ́mélɔ́ nkane Ɛsɔwɔ ágbárege gefwa jí. Apyɛɛ́ ntó bɔɔ́ abi ámeé mamée ufɔɔ́ufɔɔ́ átóoge. ");
INSERT INTO anvNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Ndɛre Jisɔs agɛ́né gejamégé bɔɔ́ abi áchwɔ́ɔ ɛta wuú, meshwɛ akwɔ ji metɔɔ́ dɔɔ́ gétúgé bɔɔ́ bímbɔ, néndé ɛfwyale bwɔ́ ɛjaá dɔɔ́, álá mbyambya ɛké mágɔ́ŋme ayi álá pɔ́ ne mémbamé. ");
INSERT INTO anvNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Ɛfɛɛ́ ne ájɔɔ́ ne baá utɔɔ́ bií aké, “Mbwɛ́ mamferé ajá dɔɔ́ ne bɔɔ́ utɔɔ́ abi áférege ája wɔ́. ");
INSERT INTO anvNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Nɛ́ge mmyɛ mbaá Ɛsɔwɔ mbɔɔ́ mekɔɔ́ nnó atɔ́ bɔɔ́ utɔɔ́ abifɔ nnó áchwɔ́ áferé mbwɛ́ wuú.” ");
INSERT INTO anvNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Ne bií úma Jisɔs akuú áŋgbá bií áfyáneapeá, áchwɔ́ge achyɛɛ́ ɛbwɔ́ uto ɛbi ábuú aló nchyɛ né mmyɛ bɔ́ ne mampyɛ bɔɔ́ abi ámée mamée ufɔɔ́ ufɔɔ́ átóoge. ");
INSERT INTO anvNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Gɛ́ mabɔ áŋgbá Jisɔs áfyáneápeá na. Ayi mbɛ akamege Simun (ákúu ji ntó nnó Pita) ne meŋmó wuú Andru, Jɛmsi ne Jɔn baá Sɛbɛdee. ");
INSERT INTO anvNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Filip ne Batolomyo, Tɔmasi ne Matyo ayi álú ménsɛlé ŋkamakpo, Jɛmsi maá Alfɔs, Tadiyɔs ne ");
INSERT INTO anvNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simun muú ukógé ayi ammyɛɛ́ nnó bɔɔ́ bií ábɛ́ mmyɛmmyɛ bwɔ́ ne Judas Iscarot ayi achyɛɛ́ Jisɔs maŋkwaá. ");
INSERT INTO anvNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Jisɔs agare ɛbwɔ́ bina aké, “Mentɔme ɛnyú dafyɛ. Déjyɛɛ́ mbɔ dékpɛgé fɔ́ malɔ́ bɔɔ́ abi álá pɔ́ bɔɔ́ Jus yɛ né gebagé mewaá Samariya. ");
INSERT INTO anvNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Chóge lé né mbaá bɔɔ́ Isrɛli. Ɛbwɔ́ álú ɛké mágɔ́ŋme ayi ánome. ");
INSERT INTO anvNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Dégárégé ɛbwɔ́ nnó gébé ɛyigé Ɛsɔwɔ ágbárege gefwa ne bɔɔ́ bií géla kwɔ́kwɔ́lé. ");
INSERT INTO anvNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Pyɛɛ́ge bɔɔ́ mameé átóogé, peége bɔɔ́ abi ágboó ákérégé né geŋwá, pyɛɛ́ge ntó bɔɔ́ ubá átóogé, búge áló nchyɛ abi áchyɛɛ́gé bɔɔ́ ɛfwyale né mmyɛ. Nchyɛɛ́ ɛnyú utó mampyɛ unó bi, déchyɛ́ ŋka wɔ́, chóge dépyɛ́gé ntó mbaá bɔɔ́ dégigé ŋka. ");
INSERT INTO anvNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Ɛkagé déjyɛ́ ne yɛ́ndé gefɔ́ge ŋka né mmu uba nku nyú. ");
INSERT INTO anvNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Muú nyú ákpagé fɔ́ gébagé nekɛ, yɛ́ ɛ́bɛ́lé nkú ayichá, yɛɛ́ unó uká ne metó nekɛ, néndé ábɔ́ manchyɛ́ muú utɔɔ́ genó ɛyigé ji abɔɔ́ mambɛ́ ne géjí. ");
INSERT INTO anvNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Yɛ́ndé melɔ ɛwé dékpɛné, kɛ́lege muú yi ábɔɔ́ gejeé mansɛ ɛnyú nnó déjwɔle ne ji, jwɔlégé wyɛ ɛfɛɛ́ kpaá tɛ délyáge melɔ ɛwémbɔ. ");
INSERT INTO anvNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Dekpɛgé mmu gepú ɛyimbɔ, támege bɔɔ́ abi álú mmu nnó, ‘Méjé Ɛsɔwɔ ɛ́bɛ́ ne ɛnyú.’ ");
INSERT INTO anvNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Ne mbɔgé bɔɔ́ abi álú mmu ásɛgé ɛnyú cháŋéné, nɛ́ge mmyɛ nnó méjé Ɛsɔwɔ ɛ́lá ne ɛbwɔ́, mbɔgé álá sɛ ntó ɛnyú wɔ́, nɛ́ge mmyɛ nnó Ɛsɔwɔ ásɛ́ méjé wuú. ");
INSERT INTO anvNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Mbɔgé muú álá sɛ ɛnyú yɛ́ ɛbɛ ɛlé manwú mekomejɔɔ́ nyú wɔ́, déké detanege melɔ ɛwémbɔ yɛ́ ɛbɛ lé gepú ɛyigémbɔ kwége mpúpú ɛyi ɛ́lú ɛnyú uká ne délyaá déjyɛ. ");
INSERT INTO anvNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Ne me ngarege ɛnyú wáwálé nnó, bií unɔɔ́ mpa, Ɛsɔwɔ agɛné nyɛ́ bɔɔ́ Sodom ne Gomɔra meshwɛ apwɔ bɔɔ́ melɔ ɛwé ɛ́shyaá manwú mekomejɔɔ́ ɛnyú.” ");
INSERT INTO anvNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Aké, “Wuúge, mentɔme ɛnyú mbaá bɔɔ́ mme nkane mágɔ́ŋme né mpú ukwaála, kaágé cháŋéné nkane dékɛne ne bɛ́ge nyaáme dékɛ́légé mpa. ");
INSERT INTO anvNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Sɛ́ge gébé, néndé bɔɔ́ ápyɛ́ne nyɛ ɛnyú áfɛ́ ne ɛnyú né ɛso ákpakpa melɔ ne ádóo nyɛ́ ɛnyú baá unɔɔ́ né macha mmyɛmenɛne bwɔ́. ");
INSERT INTO anvNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Ne ájame nyɛ ɛnyú áfɛ́ né mbɛ ushu bɔ gɔ́mena ne afwa melɔ gétúgé délu aŋkwɔle ba, ápyɛgé mbɔ ɛ́byɛnnó degɛ́ mbɔ lé meti mangaré ɛbwɔ́ ne bɔɔ́ abi álá pɔ́ bɔɔ́ Jus mekomejɔɔ́ wa. ");
INSERT INTO anvNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Gébégé ásɛgé ɛnyú ájyɛgé né macha ɛso, déchyɛgé menyammyɛ nyú ɛfwyale, dégígé nnó dejɔge nyɛ nnó néndé gebe ɛyígé mbɔ gékwɔnégé Ɛsɔwɔ achyɛge nyɛ́ ɛnyú genó ɛyígé débɔɔ́ manjɔɔ́. ");
INSERT INTO anvNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Njɔgé mbɔ néndé, uchu mejɔɔ́ ɛbí ɛnyú déjɔ́ge nyɛ́ úbɛɛ́ fɔ́ ɛbí nyú, ɛ́lé Mendoó Ukpea ɛwé Ntɛ nyú Ɛsɔwɔ atɔ́me nyɛ́ ne ɛ́gárege nyɛ ɛnyú genó ɛyigé débɔɔ́ manjɔɔ́. ");
INSERT INTO anvNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Ne gebé ɛyígé mbɔntó, aŋmó áchyɛ́ge nyɛ́ atɛɛ́ aŋmó nnó áwá. Antɛ áchyɛgé nyɛ́ baá bwɔ́ nnó áwá. Baá átɛ́nege nyɛ́ ukɔ́lɔ́ ne ammá bwɔ́ ne antɛ bwɔ́ mampyɛ nnó áwá ɛbwɔ́. ");
INSERT INTO anvNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Bɔɔ́ ako ápaá nyɛ ɛnyú gétúgé délú bɔɔ́ ba. Yɛ́mbɔ yɛ́ndémuú ayi akogé metɔɔ́ tɛ kwyakwya áférege nyɛ ji né ɛfwyale gabo. ");
INSERT INTO anvNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Yɛndé melɔ ɛwé bɔɔ́ áchyɛgé ɛnyú ɛfwyale kwilége wyɛ́ wáwá déjyɛ́ ɛwé chá. Kaáge wáwálé nnó, gemɛ́gé nnó dékɛ́ malɔ́ Isrɛli mako mampyɛ utɔɔ́ ba, me Maá Ntɛ Mekwaá nchwɔ́ nyɛ́. ");
INSERT INTO anvNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Kaáge nnó maá ŋwɛ akaágé fɔ́ ŋwɛ ápwɔ́ menlɛré wuú, yɛ maá defwɛ́ aŋeáge fɔ́ gemɛ apwɔ́ muú ayi abɔɔ́ ji. ");
INSERT INTO anvNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Maá ŋwɛ afɛrégé fɔ́ nnó ápyɛ́ɛ nyɛ galɔ́gálɔ́ ne ji apwɔ menlɛré wuú ne maá defwɛ ntó áfɛrégé fɔ́ nnó ápyɛɛ́ nyɛ galɔ́gálɔ́ ne ji apwɔ muú ayi abɔɔ́ ji. Mbɔgé bɔɔ́ ákage ŋea matɔɔ́ akuú me ayi nlu ntɛ ula gepú Ɛsɔwɔ nnó nlú danchɔmeló (Bɛlsɛbɔb) ne ɛnyú bɔɔ́ ula gepú ba yɛ́, ákúu nyɛ́ ɛnyú ufɔɔ́ mabɔ ufɔɔ́ ufɔɔ́ ámi mabɔɔ́ mapwɔɔ́ amu. ");
INSERT INTO anvNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Défɔgé yɛ muú fɔ́, genó fɔ́ gépɔ́ ɛyigé ákwérégé géjí bɔɔ́ álá gɛ́né nyɛ, yɛ ɛyigé ábigé bɔɔ́ álá kágé nyɛ gépɔ́. ");
INSERT INTO anvNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Unó bi ngárege mbɔ ɛnyú né metɔɔ́ utuú, gárege úbí gbɔŋɔnɔ ne ɛbi dewuú mbɔ ɛnyú ɛnyú garege ubi mbaá bɔɔ́ ako áwúu. ");
INSERT INTO anvNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Défɔgé fɔ́ bɔɔ́. Ɛbwɔ́ ákage wá lé muú wáne, ákágé wá fɔ́ méndóo wuú. Fɔ́ge lé Ɛsɔwɔ muú awyaá utó manwá muú chóncho ne méndóo áfyɛ́ mmu ntoné mewɛ. ");
INSERT INTO anvNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Gɛge baá denwyɔné abi aname ne ŋka ɛyi ɛ́lá fuú yɛ́ genó wɔ́. Yɛ́mbɔ yɛ́ ama ayi átánege né mfaá akwé ayi Ntɛ nyú Ɛsɔwɔ álá kaá wɔ́ apɔ́. ");
INSERT INTO anvNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Mbɔntó ne ɛ́lú ne ɛnyú, Ɛsɔwɔ akaá mpa déŋkaáré mejwɛ ɛti délú yɛ́ndémuú nyú mekpo. ");
INSERT INTO anvNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Défɔgé fɔ́ genó ɛyigé bɔɔ́ apyɛ́ nyɛ ɛta nyú, ɛnyú deŋeá gemɛ né mbɛ ushuú Ɛsɔwɔ dépwɔ ɛkwɔ́ denwyɔné. ");
INSERT INTO anvNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Ne yɛ́ndémuú ayi ágárege gbɔ́ŋɔ́nɔ́ né mbɛ ushu bɔɔ́ nnó alu muú wa, mentó ngarege nyɛ́ gbɔ́ŋɔ́nɔ́ mbaá Ntɛ wa muú álú né mfaánebuú nnó ji alu muú wa. ");
INSERT INTO anvNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Yɛ́mbɔ, yɛ́ndémuú ayi áshyágé né mbɛ ushu bɔɔ́ nnó ji apɔ́ fɔ́ muú wa, bií mpa Ɛsɔwɔ, mentó nshyaá nyɛ́ ji né mbɛ ushu Ntɛ wa muú alu né mfaánebuú nnó ji ápɔ́ fɔ́ muú wa. ");
INSERT INTO anvNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Ɛnyú défɛrégé fɔ́ nnó menchwɔ́ fá mme mampyɛ bɔɔ́ ábɛ́ nesɔ ne atɛ, nchwɔ́ lé mampyɛ bɔɔ́ ámmyɛ́gé ne atɛ. ");
INSERT INTO anvNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Nchwɔ́ pyɛ́ nnó maá ayi mende ámmyɛ́ ne ntɛ wuú, ayi mendée ámmyɛ ne mmá wuú. Mendée menɔ ammyɛ ne ŋmogétá wuú. ");
INSERT INTO anvNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Ne bɔɔ́ mawámé muú átanégé ɛlé né ula gepú bií. ");
INSERT INTO anvNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Muú abɔgé gejeé ne mma wuú yɛ́lé ne ntɛ wuú gépwɔgé gejeé ɛyi abɔɔ́ ne me, ɛbyɛnnó akwane fɔ́ mambɛ meŋkwɔle wa wɔ́. Ne muú abɔgé gejeé ne maá wuú ayi mende yɛ́lé ayi mendée gépwɔge gejeé ɛyi abɔɔ́ ne me ɔkwane mambɛ meŋkwɔle wa wɔ́. ");
INSERT INTO anvNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Ne mbɔgé muú álá kame mamkpa gekwa jií akwɔlege me wɔ́, ɛbyɛnnó akwane fɔ́ mambɛ meŋkwɔle wa wɔ́.” ");
INSERT INTO anvNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Muú ayi akɛ́lege mampoó geŋwá jií, ji yimbɔ ne ágbóo nyɛ, ne ayi akɛlege manií geŋwá jii getú ya ɛbyɛnnó ɔbɔɔ́ nyɛ geŋwá ɛyi gélágé byɛ́. ");
INSERT INTO anvNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Yɛ́ndémuú ayi asɛle ɛnyú ne metɔɔ́ megɔ́mégɔ́ ɛbyɛnnó asɛ mbɔ le me, ne muú ayi ásɛle me asɛ mbɔ lé Ɛsɔwɔ muú átɔme me. ");
INSERT INTO anvNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Yɛ́ndémuú ntó ayi asɛle muú ɛkpávé Ɛsɔwɔ ne metɔɔ́ megɔ́mégɔ́ ɛlé akaá nnó alu muú utɔɔ́ Ɛsɔwɔ, Ɛsɔwɔ achyɛge nyɛ ji nsa wyɛ ndɛre achyɛge muú ɛkpávé wuú. Muú ayi asɛle muú yi apyɛɛ́ genó ɛyigé Ɛsɔwɔ akɛlege, asɛle nsa wyɛ nkane ayi Ɛsɔwɔ achyɛge muú yimbɔ. ");
INSERT INTO anvNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Ne muú ayi achyɛge ŋkɔ manaá makwɛ mbaá muú ama né geluagé abi alu aŋkwɔle ba, yɛ́ ayi alú byábyá né amɛ bɔɔ́, ngarege ɛnyú wáwálé abɔɔ́ nyɛ nsa.” ");
INSERT INTO anvNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Ne gébégé Jisɔs aneré mangaré baá utɔɔ́ bií makpo áfyanéápeá genó ɛyigé ɛbwɔ́ ábɔɔ́ mampyɛ, alyaá melú ɛwémbɔ afɛ́ né malɔ́ bɔɔ́ Jus ayi fɔ né gebagé mewaá Gálilí nnó álɛ́régé ne ámá ágárégé ntó ɛbwɔ́ abya melɔ́mélɔ́. ");
INSERT INTO anvNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Né gébé ɛyigémbɔ ntó Jɔn meŋwyaá bɔɔ́ manaá Ɛsɔwɔ abɔ́ akpɛ denɔ. Áwúgé unó bi Jisɔs, Muú yi Ɛsɔwɔ akweré ji ɛlá gefwa, apyɛɛ́, atɔ́ baá utɔɔ́ bií abifɔ nnó ájyɛ ágií ákaá gefɔgé muú ayi ji álú. ");
INSERT INTO anvNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Ájyɛ́gé ágií Jisɔs áké, “Wɔ ne ɔ́lú muú ayi abɔ́ alú manchwɔ́ wá ɛsé dégilé ayichá?” ");
INSERT INTO anvNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Ne Jisɔs ashuú ɛbwɔ́ meko aké, “Choge dégare Jɔn unó bi ɛnyú déwuú bɔɔ́ ájɔge ne ɛbi ɛnyú ambɔɔ́ dékpané amɛ dégɛne. ");
INSERT INTO anvNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Bɔɔ́ amɛ nónómé ágɛ́ne, ubwéré, ukwilé úkɛ́ne, bɔɔ́ abi ámeé ubá átoó, bɔɔ́ matu gbɛ́gbɛ́ álɔ manwúgé, abi ágboó ápeé, ne ubyá bɔɔ́ úwú abya melɔ́mélɔ́. ");
INSERT INTO anvNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Meje ɛ́bɛ́ ne muú yi álá pɔ́ ne dembyɔ́ né metɔɔ́ gétú yá.” ");
INSERT INTO anvNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Ndɛre baá utɔɔ́ Jɔn ályaá ájyɛɛ́, Jisɔs alɔ manjɔɔ́ depɔre Jɔn ne gejamégé bɔɔ́ abi álu ɛfɛɛ́ aké, “Tégé gébégé ɛnyú déjyɛ nya né mashwɔne, defɛ mangɛ ndé gefɔgé muú? Déjyɛ gɛ́ le muú ayi alú ɛké mancha ami afofo akpáne áténe ɛgbɛ ɛwe ne ɛwe? ");
INSERT INTO anvNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Mbɔgé mbɔ fɔ wɔ́, defɛré nnó dejyɛ́ gɛ́ ndé gefɔɔ́gé muú? Défɛ́ manjyɛ gɛ muú ayi afyɛ mandeé malɔ́málɔ́? Chyaá-o. Dekaá fɔ́ nnó bɔɔ́ abi áfyɛɛ́ ufɔɔ́ mandeé yimbɔ ájwɔlege lé né mmu dachi afwa bɔ́ wɔ́? ");
INSERT INTO anvNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Ne ɛnyú défɛ́ yɛ́ ɛ́wú mánjyɛ gɛ́ waá? Ɛlé muú ɛkpávé Ɛsɔwɔ? Ɛh, gɛ́ muú yi ɛnyú dégɛné mbɔ. Ngare ɛnyú wáwálé nnó, aŋeá gemɛ apwɔ yɛ́ndémuú ɛkpávé Ɛsɔwɔ. ");
INSERT INTO anvNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Ɛ́lé Jɔn yina ne ábɔ́ ásamé gétú jií nnó Ɛsɔwɔ aké, ‘Wuúgé, ntɔme nyɛ́ muú dentɔɔ́ wa ayi abɔ́ nyɛ́ mbɛ ne wɔ manchwɔ kwyɛ́ meti wyɛ’.” ");
INSERT INTO anvNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Jisɔs afɛ́ mbɛ ajɔge aké, “Kaáge wáwálé nnó, né geluágé bɔɔ́ ako abi ándée ábyɛné, yɛ muú ayi aŋeá gemɛ ɛke Jɔn menwyaá bɔɔ́ manaá Ɛsɔwɔ apɔ́. Yɛ́mbɔ muú ayi álá fuú yɛ genó wɔ́ né geluágé abi Ɛsɔwɔ abɛɛ́ mfwa bwɔ́ aŋeá gemɛ apwɔ́ Jɔn. ");
INSERT INTO anvNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Gefwa ɛyigé Ɛsɔwɔ ágbárege gejyɛɛ́ mbɛ ne ɛshyɛ ɛlɔ né gébé ɛyigé Jɔn menwyaá bɔɔ́ manaá Ɛsɔwɔ agarege mekomejɔɔ́ Ɛsɔwɔ, ɛkwɔne bií ɛbi fina. Ne bɔɔ́ abi amyɛ mankpɛ wyɛ, amyɛ ne ɛshyɛ. ");
INSERT INTO anvNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Gemɛ́gé nnó Jɔn áchwɔ́ álɔɔ́ utɔɔ́ bií, bɔ ŋwɛ abi Mosis asame ne abi bɔɔ́ ɛkpávé Ɛsɔwɔ ako ábɔ́ mɛ́ mbɛ ágare unó bi upyɛɛ́ nyɛ né gébé ɛyina. ");
INSERT INTO anvNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Ne mbɔgé dékɛlege mankame ne genó ɛyigé me njɔɔ́, gɔge me ngare ɛnyú nnó Jɔn ne alu Ɛlija ayi bɔɔ́ ɛkpávé Ɛsɔwɔ abɔ ajɔɔ́ nnó achwɔɔ́.” ");
INSERT INTO anvNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Muú yi áwyaá matu mawú, áwú. ");
INSERT INTO anvNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Mmɛge na kpɛ́ njyɛ ɛnina ne ndé? Nélú nkane baá melɔ abi ájwɔle né metɔɔ́ melɔ, akuú atɛ aŋmɛ bwɔ́ aké, ");
INSERT INTO anvNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Ɛsé dékwe ɛnyú ubeé neba nnó débé, déshya mambé, dékwa makwaá negbo nnó deli déshya manlí.’” ");
INSERT INTO anvNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Njɔ́ge mbɔ néndé, Jɔn menwyaá bɔɔ́ manaá Ɛsɔwɔ achwɔɔ́ nyá, ji ányuú fɔ́ mmɔɔ́, ne gebé ɛyigé fɔ alyage menyɛɛ́ kpɛ́kpɛ́ gétúgé depɔré Ɛsɔwɔ getu ɛyigémbɔ, bɔɔ́ aké, “Awyaá meló nchyɛ.” ");
INSERT INTO anvNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","“Me Maá Ntɛ Mekwaá nchwɔ́, nnyɛ menyɛɛ́, nnyu mmɔɔ́ gbɛne, ɛnyú deké pɛ́lé muú geŋɔ ne menyuú mmɔɔ́ yi, mejeé ánsɛlé ŋkamakpo ne mejeé bɔɔ́ ubeé. Yɛ́mbɔ ákaágé nnó deŋgaré Ɛsɔwɔ ɛtiré muú áwyaá delu cho né unó ulɔ́úlɔ́ ɛbi ji ápyɛɛ́.” ");
INSERT INTO anvNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Bɔɔ́ abi álú né malɔ ayi Jisɔs ápyɛ nyá ukpɛ́kpɛ́ ufélekpá wyɛ, ályaá fɔ́ mámpyɛ́gé gabo wɔ́. Ɛwena ɛpyɛ Jisɔs alɔ manshulege ɛbwɔ́ ndo. ");
INSERT INTO anvNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Ake, “Utóŋkwa ubɛ́ nyɛ ne ɛnyú bɔɔ́ melɔ́ Korasin, utóŋkwa ubɛ́ ntó ne ɛnyú bɔɔ́ Bɛtsada néndé, ukpɛ́kpɛ́ ufélekpá ɛbi mpyɛ ɛta nyú, mbɔ mpyɛ nyá ubi mbaá bɔɔ́ Tiya ne Sidɔn mbɔ ályaá mɛ́ gabo bwɔ́ tɛ gachií, áfyɛ uchálé mandeé, áwaá matwɔ né mekpo mánlɛré nnó ályaá gabo ɛbwɔ́. ");
INSERT INTO anvNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Ngárége ɛnyú wáwálé nnó, bií unɔɔ́ mpa Ɛsɔwɔ, Ɛsɔwɔ agɛne nyɛ bɔɔ́ Tiya ne abi Sidɔn meshwɛ apwɔ ɛnyú. ");
INSERT INTO anvNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Ne ɛnyú bɔɔ́ Kapanɔm, défɛré nnó dékwɔme nyɛ ŋgɔ dɔɔ́? Gebyɔ, Ɛsɔwɔ awáne nyɛ ɛnyú gelu degbo dékwɔné melɔ áwuú bɔɔ́. Néndé, ukpɛ́kpɛ́ ufélekpá ɛbi mpyɛ na ɛta nyú, mbɔ́ mpyɛ ubi mbaá bɔɔ́ Sodom, mbɔ́ Ɛsɔwɔ áwaá nya fɔ ɛbwɔ́ wɔ́, ábɔ́ álú ábɛ tɛ́ fina. ");
INSERT INTO anvNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Ngarege ɛnyú wáwálé nno, bií unɔɔ́ mpa Ɛsɔwɔ, Ɛsɔwɔ agɛne nyɛ bɔɔ́ Sodom meshwɛ apwɔ ɛnyú.” ");
INSERT INTO anvNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Wyɛɛ́ né gébé ɛyigémbɔ, Jisɔs anɛmmyɛ aké, “Ntɛ wa, Ata ayi abɔɔ́ mfaá ne mme, mfɛɛ́ wɔ dɔɔ́, nkane ɔpyɛɛ́ nnó depɔ ɛtire detome ne me debɛ bibií mbaá bɔɔ́ deŋgá ne abi ákaá ŋwɛ dɔɔ́. Ɔ́nené deti gbɔ́gɔ́nɔ́ mbaá bɔɔ́ abi álá kaáge yɛ genó nnó ákaá. ");
INSERT INTO anvNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Ɛlu wáwálé Ntɛ wa, mbɔ ne wɔmbɔɔ́ ɔ́kɛlé nnó ɛ́bɛ́.” ");
INSERT INTO anvNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Ama jɔɔ́ ne bɔɔ́ aké, “Ntɛ wa achyɛ me unó uko ne yɛ muú ayi akaáge gefɔgé muú ayi Maá alú ápɔ́, ɛkosé Ntɛ wuú ne yɛ muú ayi akaágé gefɔgé muú ɛyigé Ntɛ alu ápɔ́ ɛkose Maá ne bɔɔ́ abi ji ájyaá nnó ápyɛ ɛbwɔ́ ákaá Ntɛ wuú. ");
INSERT INTO anvNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Ɛnyú ako abi depwaá gétúgé dékpané matuú ɛfwyale ayi ánɔɔ́ ɛnyú, chwɔge ɛta wa, nsɛle áji nchyɛ ɛnyú ugbeé mmyɛ. ");
INSERT INTO anvNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Chyɛ́ge gemɛge nyú ɛta wa degí géno ɛyige nlɛ́rege, néndé me nlu nyame ne mbwɛ́gé fɔ́ mmyɛ. Dépyɛ́gémbɔ, debɔɔ́ nyɛ ugbeé mmyɛ. ");
INSERT INTO anvNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Genó ɛyigé ngarege ɛnyú nnó dépyɛ gejwerege fɔ ne ɛyigé nchyɛ́ge ɛnyú nnó dékpá genɔɔ́ fɔ.” ");
INSERT INTO anvNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Ɛ́bɛ́lé yɛ wɔ́, né bií uwyaá fɔ Jisɔs ne baá utɔɔ́ bií ákoóge né mekɔɔ́ gefɔgé nchi fɔ ɛyi ákuú nnó wid. Mesa abɔ ammyɛ baá utɔɔ́ bií. Apyɛ ɛbwɔ́ álɔ mánkɔ́gé nchi ɛyimbɔ ányɛɛ́. ");
INSERT INTO anvNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Ɛkwɔ bɔɔ́ Farasi fɔ ágɛgé mbɔ, ájɔɔ́ ne Jisɔs áké, “Gɛ́ ɛbɛ́ se ɛ́kámé fɔ́ nnó baá utɔɔ́ byɛ́ ákɔɔ́ nchi bií uwyaá wɔ́.” ");
INSERT INTO anvNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Ne Jisɔs ashuú ɛbwɔ́ meko aké, “Ɛnyú délú daŋkú né mmu ŋwɛ Ɛsɔwɔ dékaá genó ɛyigé mfwa Dɛvid ápyɛ́ nyá gébégé mesa ámmyɛ ji ne bɔɔ́ bií wɔ́? ");
INSERT INTO anvNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Akpɛ nyá mmu ɛcha upɛ Ɛsɔwɔ abɔ́ brɛd ayi achyɛge matame mbaá Ɛsɔwɔ, anyɛ́ ne bɔɔ́ abi álu ne ji. Ɛ́lú ɛbɛ́ nnó muú yicha abɔɔ́ fɔ́ manyɛ́ menyɛ́ yimbɔ wɔ́ ɛkosé ámpyɛ upɛ Ɛsɔwɔ ne ányɛ́.” ");
INSERT INTO anvNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Ama gií aké, “Délú daŋkú ɛbɛ́ Mosis ɛwé ɛké, ámpyɛ upɛ né ɛcha upɛ Ɛsɔwɔ ákwene ɛbɛ́ bií uwyaá, ɛbɛ́ ɛwé ɛ́ké muú apyɛgé fɔ utɔɔ́ bií uwyaá. Nkane ɛbwɔ́ ápyɛ utɔɔ́ né bií uwyaá ákwe ɛbɛ ɛwémbɔ. Yɛ́mbɔ ɛbɛ́ Mosis ɛwémbɔ ɛgbaré fɔ́ ɛbwɔ́ nnó ápyɛ utɔɔ́ bií uwyaá wɔ́? ");
INSERT INTO anvNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Gɔgé ngáré yɛ ɛnyú nnó muú alu fa ayi ápwɔ yɛ bɛ́lé ɛcha upɛ Ɛsɔwɔ. ");
INSERT INTO anvNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Ŋwɛ Ɛsɔwɔ ajɔɔ́ aké, ‘Genó ɛyigé Ɛsɔwɔ ákɛ́lege gélú nnó dégɛ́né atɛ meshwɛ ɛ́pɔ́fɔ́ lé mámpyɛ upɛ ɛta wuú’. Mbɔgé debɔ́ dékaá mekomejɔɔ́ yina, mbɔ́ ɛnyú déjɔɔ́ fɔ́ nnó bɔɔ́ abi ála pyɛ gyɛɛ́ wɔ́ ákwé mpa. ");
INSERT INTO anvNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Kaáge yɛ nnó, me Maá Ntɛ Mekwaá ne nlu Ata ayi abɔɔ́ bií uwyaá.” ");
INSERT INTO anvNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Jisɔs ályágé ɛ́fɛɛ́, ajyɛ kpɛ né ɛcha mmyɛmenɛne bwɔ́. ");
INSERT INTO anvNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Mende fɔ ayi ɛbwɔ ɛgboó ji abɔ́ alú wyɛ. Ɛ́fɛɛ́ mbɔntó, bɔɔ́ fɔ́ abi ákɛ́lege meti mánjɔɔ́ nnó Jisɔs ápyɛ genó gebo álú wyɛ. Ágií Jisɔs áké, “Nnó ɛbɛ́ se ɛ́kamé nnó ápyɛɛ́ muú atoó né bií uwyaá?” ");
INSERT INTO anvNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Jisɔs ashuú ɛbwɔ́ meko aké, “Mbɔgé muú nyú awyaá ɛgɔŋme, ne ɛkwegé mmu gepyɛɛ́ bií uwyaá, nnó áférégé ɛwu?” ");
INSERT INTO anvNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Ne mekwaá áyi aŋeá gemɛ ápwɔ́ ɛgɔ́ŋme yɛ! Ndɛre ɛlúmbɔ, ɛbɛ́ ɛgbárégé fɔ́ muú nnó apoóge fɔ ntɛ meŋmɛ bií uwyaá. ");
INSERT INTO anvNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Ɛ́fɛɛ́ ne Jisɔs ájɔɔ́ ne mende ayi ɛbwɔ ɛgboó ji áké, “Nyaá ɛbwɔ wyɛ.” Ányágé, tɛ́nétɛ́né ɛbwɔ wuú ɛtoó ɛkere mebɛ nkane ɛwe fɔ. ");
INSERT INTO anvNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Bɔɔ́ Farasi abi álu ɛfɛɛ́ ágɛ́gé mbɔ, átané ájyɛ ásɔ́ mala nnó ápyɛ Jisɔs áwá. ");
INSERT INTO anvNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Ne Jisɔs akaágé nnó ájɔɔ́ geju manwá ji, alyaá mbaá yimbɔ afɛ́ mbaá yicha. Gejamégé bɔɔ́ ákwɔlé ji, apyɛ abi ámeé ako átoó. ");
INSERT INTO anvNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Ne aji ɛbwɔ́ ɛtu aké, “Ɛ́kagé ájyɛ ágáré bɔɔ́ depɔ ɛti.” ");
INSERT INTO anvNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Jisɔs ájɔɔ́ mbɔ nnó mechɔ́ ɛwé Ɛsɔwɔ apyɛɛ́ Asaya muú ɛkpávé wuú ájɔɔ́ ɛ́bɛ́ wáwálé ");
INSERT INTO anvNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","nnó, “Gɛ́ muú utɔɔ́ wa ayi njyaá na, mbɔ gejeé ne ji, apyɛ́ɛ metɔɔ́ ɛgɔɔ́ me dɔɔ́, nchyɛge nyɛ ji uto Mendoó wa, ne agarége nyɛ bɔɔ́ abi álá pɔ́ bɔɔ́ Jus nnó me mpyɛɛ́ nyɛ ɛbwɔ́ átɛne cho né mbɛ ushu wa. ");
INSERT INTO anvNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Abɛɛ́ fɔ́ muú mawáme, ne ménjɔɔ́ mejɔɔ́, abɛɛ́ muú ayi ala awuú fɔ mejɔɔ́ wuú né melɔ tametame. ");
INSERT INTO anvNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Ajɔ́gé fɔ́ mejɔɔ́ metometo ne bɔɔ́ abi áwyaá matɔɔ́ dada, ne ápyɛɛ́ fɔ́ matɔɔ́ ásɔ́ ubya bɔɔ́ ne abi ágɛne ɛfwyale. Wyɛmbɔ ne abɛɛ́ ne bɔɔ́ kpaá tɛ apyɛ nyɛ wáwálé wuú apwɔ unó uko. ");
INSERT INTO anvNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Ne bɔɔ́ malɔ mme meko ánɛrege nyɛ matɔɔ́ ne ji mambɔ geŋwá.” ");
INSERT INTO anvNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Ɛ́wyágé, bɔɔ́ fɔ áchwɔ́ ne muú ayi meló nchyɛ ápyɛ́ ji álaá mbú ne amɛ nónómé mbaá Jisɔs. Apyɛ ji atoó alɔ mángɛ́né mbaá, ajɔge mejɔɔ́. ");
INSERT INTO anvNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Genó ɛyigé Jisɔs apyɛ, gépyɛ gejamégé bɔɔ́ abi álu wyɛ matyɛ mawá ɛbwɔ́ meno álɔ mángígé atɛ áké, “Nnó mpyáne Dɛvid áwu álú mánchwɔ́ nkane mempoó se na waá?” ");
INSERT INTO anvNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Ne ɛkwɔ́ bɔɔ́ Farasi áwúgé nnó Jisɔs apyɛ muú ayi meló nchyɛ áchyɛ́ge ji ɛfwyale atoó, álɔ mánjɔɔ́ áké, “Ɛ́lé Bɛlsɛbɔb mfwa áló nchyɛ ne áchyɛ́ge ji utó nnó ábúgé bɔɔ́ áló nchyɛ mmyɛ.” ");
INSERT INTO anvNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Jisɔs ákaá genó ɛyigé ɛbwɔ́ áfɛ́rége, ajɔɔ́ ne ɛbwɔ́ aké, “Yɛ́ndé melɔ ɛwé bɔɔ́ álá pɔ́ meko ama, ɛ́tɛ́négé. Ne yɛ́ndé ulaá gepú ɛbi ummyɛ ne atɛ ulaá tyatya. ");
INSERT INTO anvNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Ne mbɔgé ntɛ meló nchyɛ aké abuú ayifɔ, ɛbyɛnnó gefwage danchɔmeló gekaré mmyɛ ne ɛ́pyɛɛ́mbɔ nnó ne geji gétɛné? ");
INSERT INTO anvNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Mbɔgé Bɛlsɛbɔb ne achyɛge me uto mamferé bɔɔ́ aló nchyɛ mmyɛ, waá achyɛ́ge bɔɔ́ ɛnyú utó mámferege bɔɔ́ aló nchyɛ mmyɛ? Ne mbɔgé ɛnyú dekame fɔ́ nnó Bɛlsɛbɔb ne achyɛ ɛbwɔ́ utó aferege bɔɔ́ aló nchyɛ ne mmyɛ wɔ́, ɛbwɔ́ ambɔɔ́ ne álɛ́rege nyɛ nnó ɛnyú délu gyɛɛ́ né genó ɛyigé dejɔ́gé mbɔ ne me.” ");
INSERT INTO anvNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Ne mbɔgé ɛ́lé né Mendoó Ɛsɔwɔ ne mbuú bɔɔ́ áló nchyɛ mmyɛ, kaáge nnó gefwage Ɛsɔwɔ gélɔ mɛ́ fá ne ɛnyú. ");
INSERT INTO anvNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Muú ákaágé kpɛ fɔ́ gepúgé meto muú ájó genó mbɔgé álá bɔmbɛ áwɛ́ ji wɔ. Ɛ́kosé nnó abɔgé mbɛ awɛge ji ne ákaáge kpɛ ajó yɛ́ndégenó. ");
INSERT INTO anvNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Yɛ́ndémuú ayi álá pɔ́ ula uma ne me, alu muú mawame wa, ne yɛ́ndémuú ntó ayi alá poóge me manyweré bɔɔ́, atya ɛbwɔ́ tyaá nnó abɛ tɛtɛ ne Ɛsɔwɔ. ");
INSERT INTO anvNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Kaáge nnó Ɛsɔwɔ ajígente yɛ́ndé gabo ne mejɔɔ́ mebomebo ɛwé bɔɔ́ ájɔ́ge ne atɛ. Yɛ́mbɔ ájígé fɔ́ nte mejɔɔ́ mebomebo ɛwé bɔɔ́ ájɔ́ge atome ne Mendoó Ukpea. ");
INSERT INTO anvNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Ɛsɔwɔ ájígé nyɛ nte yɛ́ndé mejɔɔ́ mebomebo ɛwé muú ájɔ́ge atome ne Maá Ntɛ Mekwaá yɛ́mbɔ ájígé fɔ́ nte mejɔɔ́ mebomebo ɛwé muú ajɔ́gé atome ne Mendoó Ukpea. Yɛ́ ɛbɛlé fa mme yina ne ayi achwɔɔ́. ");
INSERT INTO anvNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Désɛ́ge nnó umpome genɔɔ́ ulɔme, debɔ mansɛ ntó nnó genɔɔ́ geji ambɔɔ́ gelɔme. Ne désɛ́ge nnó genɔɔ́ gélɔme fɔ́ ɛbyɛnnó umpome bií ntó ulɔme fɔ́, néndé akaáge genɔɔ́ né mbaá umpome bií géji géwɔ́me. ");
INSERT INTO anvNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Ɛnyú abi délú ɛ́ke mmyɔ ɛ́pyɛɛ́mbɔ nnó ne déjɔɔ́ galɔ́gálɔ́ ne muú ayi ɛnyú délú bɔɔ́ abo? Néndé, genó ɛyi gélú muú metɔɔ́ géjí ne gétánege ji meno. ");
INSERT INTO anvNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Muú melɔ́mélɔ́ ájɔgé depɔ delɔ́délɔ́ ɛti délú ji né metɔɔ́, muú mebomebo ájɔgé depɔ debodebo ɛti délú ji metɔɔ́. ");
INSERT INTO anvNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Kaáge wáwálé nnó, bií unɔɔ́ mpa Ɛsɔwɔ yɛ́ndémuú ágarege nyɛ ula bi ji ajɔɔ́ yɛ́ndé gechugé mejɔɔ́ gebogebo ɛyi gétané ji meno. ");
INSERT INTO anvNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Néndé yɛ mpa akwilege wɔ, yɛ akwene wɔ, ásɔɔ́ ji lé né uchu mejɔɔ́ byɛ. ");
INSERT INTO anvNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Jisɔs ájɔ́gé mbɔ, ánlɛre mabɛ Ɛsɔwɔ ne bɔɔ́ Farasi fɔ ájɔɔ́ ne ji áké, “Ménlɛre, pyɛ ufélekpa ɛse dégɛ́, manlɛre nnó utó byɛ utané mbaá Ɛsɔwɔ.” ");
INSERT INTO anvNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Jisɔs ashuú ɛbwɔ́ meko aké, “Ɛnyú njyɛ ɛniné na debɔ, delu bɔɔ́ abi átií meso ne Ɛsɔwɔ. Dekɛlege me nlɛ́ré ɛnyú ufélekpa, yɛ́mbɔ yɛ́ uma nlɛ́régé fɔ́, wyɛ lé ufélekpa Jona muú ɛkpávé Ɛsɔwɔ ne me nlɛ́rege nyɛ ɛnyú. ");
INSERT INTO anvNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Wyɛ nkane Jona ábɛlé ndɔ ɛlɛɛ́ né mmu unɛ mekwɔle, mbɔntó ne áníge nyɛ me Maá Ntɛ Mekwaá mbɛlé ndɔ́ ɛlɛɛ́ utuú ne ŋwɔmese né mme. ");
INSERT INTO anvNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Bií unɔɔ́ mpa Ɛsɔwɔ, bɔɔ́ melɔ́ Ninɛvɛ ákwilege nyɛ áshulé ɛnyú bɔɔ́ njyɛ ɛnina ndo nnó dépyɛ gabo, néndé, ákwɔré nya matɔɔ́ bwɔ́ ákame né Ɛsɔwɔ gébégé Jona ágaré ɛbwɔ́ mekomejɔɔ́ Ɛsɔwɔ. Gɔ́ge mpyɛ ɛnyú dékaá nnó, muú alu né metɔɔ́ metɔɔ́ nyú ayi ágárége mekomejɔɔ́ apwɔ Jona yɛ́mbɔ dékɛ́légé fɔ́ mánkwɔré. ");
INSERT INTO anvNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Bií unɔɔ́ mpa Ɛsɔwɔ, mfwa mendée né melɔ Shɛba ákwilege nyɛ ashule bɔɔ́ njyɛ ɛnina ndo nnó ápyɛ gabo. Néndé, atané nya kpaá tɛtɛ ɛwu áchwɔ́ wú unó bi mfwa Solomun álɛré nya bɔɔ́ ne déŋgá. Kaáge yɛ nnó muú alu mbɔ né metɔɔ́ metɔɔ́ ɛnyú ayi álɛ́rege mekomejɔɔ́ ne déŋgá apwɔɔ́ mfwa Solomun yɛ́mbɔ défyɛɛ́ fɔ́ matu manwúge.” ");
INSERT INTO anvNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Jisɔs afɛ́ mbɛ ajɔge aké, “Ábúgé meló nchyɛ atanege muú mmyɛ, alá yia yiáge né mmu mashwɔne akɛlege melu ɛwe ajwɔlege. Ákɛlege álá gɛ wɔ́, ");
INSERT INTO anvNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","ajɔ́gé ne gemɛ jií aké, ‘Nkerege meso mbaá ayi mbɔ nlu.’ Akerege meso agɛgé nnó melu ɛwémbɔ ɛ́lú mewa, áshwa ɛla pópó ákwyɛɛ́ ábelé, ");
INSERT INTO anvNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","akerege, afɛ́ asɛ áló nchyɛ abifɔ akénéama abi abɔɔ́ apwɔɔ́ ji, ákpɛ́ ájwɔ́lé mmu. Ne gefɔɔ́ ɛyígé muú yimbɔ ábɛɛ́ gebɔ́ɔ gépwɔ ɛyígé mbɛmbɛ. Wyɛ na ne ɛpyɛ nyɛ ne ɛnyú njyɛné bɔɔ́ abo bina.” ");
INSERT INTO anvNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Ne nkane Jisɔs alú jyɛɛ́ mbɛ manjɔɔ́ mejɔɔ́ ne bɔɔ́ bimbɔ, mmá wuú ne aŋmó bií áchwɔ́ tɛ́ne dafyɛ ákɛlege manjɔɔ́ mejɔɔ́ ne ji. ");
INSERT INTO anvNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Muú fɔ akulé agare ji aké, “Gɛ mmá wyɛ ne aŋmó byɛɛ́ álú mbɔ dafyɛ tɛ́ne ákɛlege manjɔɔ́ mejɔɔ́ ne wɔ.” ");
INSERT INTO anvNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Jisɔs ashuú muú yimbɔ meko aké, “Ndé bɔ álú mmá wa ne aŋmó ba?” ");
INSERT INTO anvNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Abwɛɛ́ ɛbwɔ asá mbaá baá utɔɔ́ bií aké, “Gɛ́gé mmá wa ne aŋmó ba ná.” ");
INSERT INTO anvNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Nendé, yɛ́ndémuú ayi apyɛ genó ɛyigé Ntɛ wa muú alu né mfaánebuú ákɛlege, ji yimbɔ ne alu mmá wa ne meŋmó wa. ");
INSERT INTO anvNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Wyɛ né bií bimbɔ, Jisɔs atané né gepú ɛyigé ji abɔ́ alú wyɛ, ashulé ajyɛ jwɔ́le né mbale géntoógé mewaá. ");
INSERT INTO anvNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Gejamégé bɔɔ́ ákwɔlé ji áfɛ́ ɛwu. Ji ágɛ́gé nnó bɔɔ́ bimbɔ ájá dɔɔ́, ajyɛ kpɛ ajwɔlé mmu ɛ́kpée ɛwé ɛ́lú né mbále nnyi. Bɔɔ́ bimbɔ ako átɛné né mbale géntoógé mewaá. ");
INSERT INTO anvNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Alɔ manlɛré ɛbwɔ́ gejamégé unó né makámejɔɔ́. Ató neka ɛníné mbɛ aké, “Bií uma mempyɛ makɔɔ́ fɔ afɛ́ manjyɛ tya mbwɛ́ né mekɔɔ́ wuú. ");
INSERT INTO anvNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Ndɛre átyaá ájyɛɛ́, ámɛ́ mbwɛ́ áyifɔ́ ákwé né maá meti ayi ákoge wyɛ, denywɔné dégɛ́gé déchwɔ chwɛ́ dényɛ́. ");
INSERT INTO anvNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Ámɛ́ áyifɔ́ ákwé né mfaá mme ɛtárávɛ́ mbaá ayi mme álá jaá wyɛ wɔ́. Ɛbɛlé yɛɛ́ wɔ́ áchií. Ne ɛ́lé mme álá jaá wyɛ wɔ́, ");
INSERT INTO anvNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","ŋmɛɛ́ ɛ́tyɛ́gé, ɛdo mbwɛ́ yimbɔ, ne ɛlé maka álá kpɛ mme chánchá wɔ́, adɛ́ agbó. ");
INSERT INTO anvNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Ámɛ́ áyífɔ́ ákwé né mme ayi genkpé ntó géchíge wyɛ, áchígé, genkpé ɛyigémbɔ géwɛ́ gekweré mbwɛ́ yimbɔ meshií ɛjo agbó. ");
INSERT INTO anvNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Yɛ́mbɔ ámɛ́ ayífɔ́ ákwé né mme melɔ́mélɔ́, áchií áwɛ́, chánchá, áfyɛ ulɔ. Áyifɔ́ áfyɛ usaá ulɔ uta, áyífɔ́ áfyɛɛ́ usaá ulɔ ulɛɛ́, ne áyífɔ́ áfyɛɛ́ ulɔ ɛsaá meso ɛfya ápwɔ nkane ábɔ́ ápɛné.” ");
INSERT INTO anvNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Jisɔs ánérégé manto nekanemejɔɔ́ ɛníne na aké, “Muú yi áwyaá matu mawú, áwú”. ");
INSERT INTO anvNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Jisɔs ánérégé mántó nekanémejɔɔ́ ɛnina, baá utɔɔ́ bií ájyɛ gií ji áké, “Ata ula nnó wɔ ɔlɛ́régé bɔɔ́ bina né makamejɔɔ́”? ");
INSERT INTO anvNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Jisɔs ashuú ɛbwɔ́ meko aké, “Ɛ́lé ɛnyú ne Ɛsɔwɔ apyɛ́ nnó dékaá wáwálé depɔ ɛtiré délú nya bíbií ndɛre ji ágbárege nyɛ gefwa jií. Yɛ́mbɔ ji anene fɔ́ deti gbɔ́gɔ́nɔ́ mbaá bɔɔ́ abifɔ nnó ɛbwɔ́ akaá wɔ́. ");
INSERT INTO anvNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Nénde, yɛ́ndémuú ayi awya genó, ji ne ágbɛ́ge nyɛ́ ji ɛbwɔ nnó abɛ́ ne gejamé. Ne muú ayi álá pɔ́, yɛ́ ɛ́kɛ́kɛ́ ɛwé ji awya, ásɛ́le nyɛ ɛta wuú. ");
INSERT INTO anvNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Gɛ́gé ula bi menlɛ́rege ɛbwɔ́ né makamejɔɔ́ na, áwyaá amɛ mangɛ́, yɛ́mbɔ ágɛ́né fɔ́, áwyaá matu mánwú yɛ́mbɔ áwuú fɔ́, yɛ mankaá ákaágé fɔ́ cháchá. ");
INSERT INTO anvNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Ne ndɛre ɛbwɔ́ ápyɛɛ́ mbɔ, genó ɛyigé Ɛsɔwɔ apyɛ Asaya muú ɛkpávé wuú ajɔɔ́ nyá getane wáwálé, nnó, ‘Ɛnyú dénénége nyɛ matu manwú mekomejɔɔ́ wa yɛ́mbɔ dekaágé ula, défyɛ nyɛ amɛ mangɛ́ unó ɛbí mpyɛ yɛ́mbɔ dégɛ́né fɔ́. ");
INSERT INTO anvNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Néndé bɔɔ́ bina aŋea matɔɔ́, awyaá matu mmɛɛ́. Ákwere amɛ bwɔ́ né depɔré Ɛsɔwɔ, mbɔgé ɛpɔ́ mbɔ fɔ́ wɔ́, mbɔ ágɛ́ne mbaá ne amɛ bwɔ́, áwuú ne matu bwɔ́ ákaá chánchá ákwɔré matɔɔ́ ákeré ɛta wa nnó mpyɛ ɛbwɔ́ ápó.’ ");
INSERT INTO anvNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Ɛnyú dewya ɛ́fwɔ́, néndé, amɛ nyú ágɛne ne matu nyú ntó áwú. ");
INSERT INTO anvNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Kaáge wáwálé nnó gejamégé bɔɔ́ ɛkpávé Ɛsɔwɔ ne bɔɔ́ abi álu cho né mbɛ ushu Ɛsɔwɔ, ákɛlé nya meti mangɛ́ unó bi ɛnyú dégɛ́ne mbɔ, yɛ́mbɔ ágɛ wɔ́, ne manwú unó bi ɛnyú déwuú mbɔ yɛ́mbɔ áwuú wɔ́.” ");
INSERT INTO anvNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Jisɔs afɛ́ mbɛ mánjɔ́gé aké, “Wúge yɛ ula nekanémejɔɔ́ mentya mbwɛ. ");
INSERT INTO anvNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Mbwɛ ayi akwené né maá metí ayi ákoóge wyɛ alu ɛ́ke bɔɔ́ abi áwúgé mekomejɔɔ́ Ɛsɔwɔ ayi ágárege nkane Ɛsɔwɔ ágbárege gefwa jií álá ákaágé ula, danchɔmeló achwɔ́ aferé ji né mmu matɔɔ́ bwɔ́. ");
INSERT INTO anvNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Ne mbwɛ ayi ákwené né mfaá mme ɛtárávɛ́, álu ɛké bɔɔ́ abi áwúgé mekomejɔɔ́ Ɛsɔwɔ tɛ́nétɛ́né yimbɔ, ásɛ ji ne nechɔ́chɔ́. ");
INSERT INTO anvNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Yɛ́mbɔ, mekomejɔɔ́ yimbɔ akpɛ́ fɔ́ ɛbwɔ́ mmu matɔɔ́ chánchá wɔ́, awyágé mano. Gébégé álɔgé mangɛ́ ɛfwyale ndɛre bɔɔ́ ápaá ɛbwɔ́ gétúgé mekomejɔɔ́ Ɛsɔwɔ, ájá mmyɛ meso. ");
INSERT INTO anvNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Ne mbwɛ́ ayi ákwené né mme genkpé meshií ɛjomé, álú ɛké muú ayi áwugé mekomejɔɔ́ Ɛsɔwɔ, ufɛ́ré unó mme ne mmwɔ́lé né unó bi uchwɔɔ́ ne gefwa, ujo mekomejɔɔ́ yimbɔ upyɛɛ́ ji áwɔ umpome ulɔ́úlɔ́ wɔ́. ");
INSERT INTO anvNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Mbwɛ́ ayi ákwené né mme melɔ́mélɔ́, alu ɛké bɔɔ́ abi áwugé mekomejɔɔ́ Ɛsɔwɔ, ákaágé ula. Mekomejɔɔ́ yimbɔ akwɔrégé geŋwáge ɛbwɔ́ gebɛɛ́ ɛké mbwɛ́ ayi áchií áwɛné chánchá afyɛɛ́ gejamégé ulɔ. Ayifɔ áfyɛɛ́ usaá ulɔ uta ayifɔ usaá ulɛɛ́, ne ayifɔ ɛsaá meso ɛfya.” ");
INSERT INTO anvNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Jisɔs ama tó nekanémejɔɔ́ ɛnínefɔ́ aké, “Gefwa ɛyigé Ɛsɔwɔ ágbárege gelu ɛké nekanémejɔɔ́ ɛníné na. Mende fɔ apɛ mbwɛ́ melɔ́mélɔ́ né mekɔɔ́ wuú. ");
INSERT INTO anvNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Ne bií fɔ ndɛre mbɔɔ́ mekɔɔ́ yimbɔ, apɛne mbwɛ́ yimbɔ, muú mawámé wuú akwilé ne utuú ayi yɛ́ndémuú abɛlé geja, ajyɛ pɛ ntó mancha né mpu mbwɛ́ yimbɔ, alya afɛ́. ");
INSERT INTO anvNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Ne gébégé mbwɛ́ yimbɔ áchií áwɛne afyɛɛ́ amɛ, ne bɔɔ́ ágɛ́né nnó mancha ntó ne mawɛne mbɔ né mekɔɔ́. ");
INSERT INTO anvNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Ɛfɛɛ́ ne bɔɔ́ utɔɔ́ mende yimbɔ ájyɛ gií ji áké, ‘Ata pɔ ɔpɛna lé mbwɛ́ áyi álú melɔ́mélɔ́ né mekɔɔ́ wyɛ? Ne mancha matané ɛfɔ́ wyɛ́?’ ");
INSERT INTO anvNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Ashuú ɛbwɔ́ meko aké, ‘Ɛbɛ nyɛ lé muú mawámé wa ne ajyɛ pɛ mancha mimbɔ.’ Bɔɔ́ utɔɔ́ bimbɔ ágií ji áké, ‘Nnó ɔkɛlegé ɛse déjyɛ́ degoó mancha mimbɔ?’ ");
INSERT INTO anvNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Mende yimbɔ ashuú ɛbwɔ́ meko aké, ‘Ngba, debɔgé mangoó mancha yimbɔ nana, dechome nyɛ ne mbwɛ yimbɔ degoó. ");
INSERT INTO anvNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Gɔ́ge áji awɛ chonchó ne mbwɛ, gébégé mbwɛ ákwɔnégé mamferé ngarege nyɛ bɔɔ́ abi áferégé nnó ábɔ́ mbɛ ágoó mancha mimbɔ áwɛ́ uboubo áfyɛ́ né mewɛ, ne áferé mbwɛ áfyɛ́ mmu meke ákpá áchwɔ́ ábélé mfaá gélálé.’” ");
INSERT INTO anvNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Jisɔs ama tó neka ɛnínefɔ́ aké, “Gefwa ɛyigé Ɛsɔwɔ ágbárege gélú ɛké nekanémejɔɔ́ ɛníné na. Mende fɔ apɛ nyiné gempome genɔɔ́ ɛyigé ákuú nnó mɔsta né mekɔɔ́ wuú. ");
INSERT INTO anvNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Nnyiné gempome ɛyigémbɔ géŋené gépwɔ amɛ́ mbwɛ́ ayifɔ́. Yɛ́mbɔ gébégé néchií néwɛ́, népwɔ baá unɔɔ́ abifɔ abi ápɛné nébwɔlé gekpɛ́kpɛ́gé genɔɔ́ ɛyigé denywɔné déshíge, détɛ́nege anyua bwɔ́ wyɛ́.” ");
INSERT INTO anvNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Jisɔs ama tó nekanémejɔɔ́ ɛniné fɔ́ aké, “Gefwa ɛyigé Ɛsɔwɔ ágbárege fa mme gelú ɛké yis uka ɛbi upyɛ brɛd amualé ɛbi mendée abɔ achwaré ne gejamégé flawa abɛlé kpaá tɛ flawa meko amuále.” ");
INSERT INTO anvNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Né gejamégé ndɔ ɛyi Jisɔs abɔ́ alɛrege nya unó bina ne gejamégé ɛbifɔ́ mbaá bɔɔ́, alɛrege lé né mákámejɔɔ́. Alɛrégé nyá fɔ́ bɔɔ́ bimbɔ genóge fɔ ayi álá tómé nekanémejɔɔ́ wɔ́. ");
INSERT INTO anvNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Atome nyá makamejɔɔ́ yina nnó genó ɛyigé muú ɛkpávé Ɛsɔwɔ fɔ abɔ́ ajɔɔ́ gébɛ́ wáwálé. Ajɔɔ́ nya aké, “Me njɔ́gé nyɛ mejɔɔ́ ne ɛbwɔ́ né makamejɔɔ́, nlɛrege ɛbwɔ́ unó bi Ɛsɔwɔ abelé bibí tɛ gébégé ji akwyɛ mme.” ");
INSERT INTO anvNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Jisɔs alya gejamégé bɔɔ́ bimbɔ ajyɛ kpɛ mmu gepú ne baá utɔɔ́ bií. Ɛfɛɛ́ ne baá utɔɔ́ bií ágií ji áké, “Ntɛ sé, gare ɛse ula nekanémejɔɔ́ mancha mi muú mawámé apɛné né mekɔɔ́.” ");
INSERT INTO anvNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Ashuú ɛbwɔ́ meko aké, “Muú yi apɛne mbwɛ melɔ́mélɔ́ yimbɔ ɛlé Maá Ntɛ Mekwaá.” ");
INSERT INTO anvNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Mekɔɔ́ ɛwémbɔ ɛtɛné mbaá mme meko, ne mbwɛ melɔ́mélɔ́ yimbɔ atɛné mbaá bɔɔ́ gefwage Ɛsɔwɔ. Mancha matɛné mbaá bɔɔ́ danchɔmeló. ");
INSERT INTO anvNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Ne muú mawámé ayi apɛne mancha ɛlé dánchɔmeló. Mamferé mbwɛ atɛné mbaá gébé ɛyigé mme yina abyɛɛ́. Ne abi áférege mbwɛ yimbɔ ɛlé makiɛ́nné Ɛsɔwɔ. ");
INSERT INTO anvNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Wyɛ nkane ánywérege mancha uboubo áfyɛ́ né mewɛ, mbɔntó ne ápyɛɛ́ nyɛ ne bɔɔ́ danchɔmelo gébégé mme yina abyɛɛ́. ");
INSERT INTO anvNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Gébé ɛyigémbɔ, me Maá Ntɛ Mekwaá ntɔme nyɛ makiɛ́nné ya, áfɛ ájya bɔɔ́ abi ápyɛ atɛ ákpɛ́ne né gabo ne abi álá akpɛge mabɛ áfere né mpu bɔɔ́ gefwa ya. ");
INSERT INTO anvNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Makiɛ́nné yimbɔ áferégé ɛbwɔ́, áfomé mmu gekpɛ́kpɛ́gé ntoné mewɛ. Ɛfɛɛ́ mbɔ ne ɛbwɔ́ álilí nyɛ, ányɛ́ maŋɛ́né. ");
INSERT INTO anvNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Gébé ɛyigémbɔ gepɔgé bɔɔ́ abi álú cho né mbɛ ushu Ɛsɔwɔ gégɛ́nege nyɛ ɛké mŋmɛɛ́ né gefwage ntɛ bwɔ́ Ɛsɔwɔ. Muú ayi awyaá matu awú cháŋéné. ");
INSERT INTO anvNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Jisɔs ama tó nekanémejɔɔ́ ɛniné fɔ́ aké, “Gefwa ɛyigé Ɛsɔwɔ ágbárege fa mme gélú ɛke nekanémejɔɔ́ ɛniné na. Muú fɔ agɛ genógé ŋka ɛyigé ábií né melu mme, agɛge abí geji chánchá alya, afɛ́ ne gejamégé nechɔ́chɔ́. Akpó yɛ́ndégenó ɛyigé ji awyaá ajyɛ na melu mme ɛwémbɔ.” ");
INSERT INTO anvNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Ama ato neka ɛnínefɔ́ aké, “Gefwa ɛyigé Ɛsɔwɔ ágbárege fa mme gélú ntó ɛké nekanémejɔɔ́ ɛninéna. Menkɛne gese fɔ akɛne akɛlege mataá ayi ajamé ŋka dɔɔ́ mana. ");
INSERT INTO anvNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Agɛ́gé né máa ɛníné né jamé ŋka, ajyɛ kpo unó bi ji awya uko anna néni” ");
INSERT INTO anvNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Jisɔs ama ató neka ɛniné na aké, “Gefwa ɛyigé Ɛsɔwɔ ágbárege fa mme gélú ɛké nekanémejɔɔ́ ɛninéna. Ánwané meshuú fɔ́, ásɔ dansa né nnyi. ");
INSERT INTO anvNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Ndɛre ásɔɔ́ meshuú ɛsɛ wyɛ ufɔɔ́ufɔɔ́, ágɛ́gé nnó meshuú ɛsɛ wyɛ dɔɔ́, aja ákwɔ́ né mapea mewaá. Ájya ɛyi melɔ́mélɔ́ áfyɛ́ mmu uba ne ɛyi mebomebo atuú ágbɛ. ");
INSERT INTO anvNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Wyɛmbɔ ntó ne ɛbɛɛ́ nyɛ bií mpa Ɛsɔwɔ gébégé mme abyɛɛ́. Makiɛ́nné Ɛsɔwɔ áchwɔ́ fére nyɛ bɔɔ́ abi ápyɛɛ́ gabo né mpu abi ápyɛɛ́ genó ɛyigé Ɛsɔwɔ akɛ́lege. ");
INSERT INTO anvNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Áferégé ɛbwɔ́, áfómege mmu gekpɛ́kpɛ́gé ntoné mewɛ. Álaá wyɛ álilí, ányɛ́ maŋéné.” ");
INSERT INTO anvNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Jisɔs agií baá utɔɔ́ bií aké, “Pɔ ɛnyú dékaá depɔ ɛtiré na cháŋéné?” Ákamé áké, “Ɛh dekaá.” ");
INSERT INTO anvNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Ajɔɔ́ yɛ ne ɛbwɔ́ aké, “Yɛ́ndé menlɛré mabɛ Ɛsɔwɔ ayi ágií ndɛre Ɛsɔwɔ ágbárege gefwa jií fa mme, alu ɛké mbɔɔ́ gepú ayi akaáge unó Ɛsɔwɔ bi ukɛ ne ɛbi gekwéne ɛbi úlú né mmu maá gepú ayi ji ábélege unó bií wyɛ.” ");
INSERT INTO anvNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Jisɔs anérégé manlɛré makamejɔɔ́ yi, alyaá melu ɛwémbɔ, ");
INSERT INTO anvNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","akeré meso né melɔ wuú. Ndɛre alɔɔ́ manlɛ́régé bɔɔ́ mekomejɔɔ́ Ɛsɔwɔ né mmu ɛcha mmyɛmenɛne bwɔ́, ála mano mekpo fuú ágíge atɛ áké, “Ndé muú áchyɛɛ́ ji gefɔɔ́gé deŋgá ɛti? Ne utó mampyɛ ukpɛ́kpɛ́ ufélekpa bina? ");
INSERT INTO anvNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Pɔ maá meŋwɔné upú na? Pɔ Mɛri ne alu mma wuú? Pɔ nnó aŋmo bií abi ande ɛlé Jɛmsi, Josɛf, Simun, ne Judas? ");
INSERT INTO anvNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Ne pɔ aŋmo bií abi andée álu na fa ne ɛsé? Ne ji atané yɛ ɛfɔ́ ne gejamégé déŋga ɛtirena?” ");
INSERT INTO anvNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Né getú ɛyigémbɔ, ábya ji, yɛ́mbɔ Jisɔs ajɔɔ́ ne ɛbwɔ́ aké, “Ánoge muú ɛkpávé Ɛsɔwɔ yɛ́ndé mbaá. Wyɛlé bɔɔ́ melɔ wuú ne abi ula gepú bií ne ála nógé ji.” ");
INSERT INTO anvNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Ne tɛɛ́ mbaá ála áfyɛɛ́ fɔ́ metɔɔ́ ne ji wɔ́, ji ntó ápyɛ fɔ gejamégé ufélekpá né melɔ wuú wɔ́. ");
INSERT INTO anvNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Né gébé ɛyigémbɔ Hɛrɔd muú alu muú kpaá né gebagé mewaá Galilií, ji awúgé ŋgɔ ukpɛ́kpɛ́ unó bi Jisɔs ápyɛɛ́, ");
INSERT INTO anvNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","ajɔɔ́ ne bɔɔ́ abi apyɛɛ́ utɔɔ́ ne ji aké, “Ɛlé Jɔn menwyaá bɔɔ́ manaá Ɛsɔwɔ. Ɛsɔwɔ apyɛ ji akwilé né negbo. Gɛ ula bi ji awya utó mampyɛ ufélekpa” ");
INSERT INTO anvNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Hɛrɔd afɛré mbɔ néndé ji ne ápyɛɛ́ nnó ágbáré Jɔn áwɛ́ áfyɛ́ né mmu gepúgé denɔ, gétúgé agaré gabo ayi Hɛrɔd apyɛ́ nnó aferé Hɛrɔdyas mendée meŋmo wuú Filip abá. ");
INSERT INTO anvNT_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Né gébége Hɛrɔd asɛlé Hɛrɔdyas né neba, Jɔn agarege ji aké, “Ɛbɛ́ Ɛsɔwɔ ɛkame fɔ́ nnó wɔ ɔsɛ mendée meŋmo wyɛ ɔbá wɔ́.” ");
INSERT INTO anvNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Hɛrɔd akɛlé meti manwá Jɔn, yɛ́mbɔ afɔ bɔɔ́ Jus, néndé ɛbwɔ́ ákame nya nnó Jɔn alu muú ɛkpávɛ́ Ɛsɔwɔ. ");
INSERT INTO anvNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Ne né bií ɛbi Hɛrɔd anɛné ɛpaá mantɛ bií ɛbi ábyɛné ji, maá Hɛrɔdyas mesɔ mendée, abé mabeé malɔ́málɔ́ né mbɛ ushu bɔɔ́ abi áchwɔɔ́ nyɛ́ ɛpaá ɛwémbɔ kpaá tɛ metɔɔ́ megɔmegɔ ɛpyɛ Hɛrɔd, ");
INSERT INTO anvNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","ajɔɔ́ ne maá yimbɔ aké, “Nkelé nnó, Nchyɛge wɔ yɛ́nde genó ɛyigé ɔkɛlege nnó menchyɛ wɔ.” ");
INSERT INTO anvNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Maá yimbɔ asɛ majyɛ mma wuú ajyɛ jɔɔ́ ne mfwa Hɛrɔd aké, “Fyɛ mekpo Jɔn menwyaá bɔɔ́ manaá Ɛsɔwɔ fa né gebagé nkpagene nana.” ");
INSERT INTO anvNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Mechɔ́ ɛwéna ɛpyɛ Hɛrɔd álá jɔɔ, yɛ́mbɔ ɛlé ji akele mɛ́ né mbɛ ushu aŋkɛɛ́ bií abi áchwɔ́ ɛpaá, ákágé sé nkane amáge kwɔ́re mejɔɔ́ wuú. Aké bɔɔ́ bee ápyɛ genó ɛyigé maá yimbɔ ajɔɔ́. ");
INSERT INTO anvNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Ájyɛ ásɔ́ mekpo Jɔn né mmu gepúgé denɔ áchwɔɔ́ ne ɛwú. ");
INSERT INTO anvNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Ánérégé afyɛ́ ɛwú né gebagé nkpagene áchwɔ́ chyɛ́ maá yimbɔ mendée, asɛ ajyɛ chyɛ́ mbaá mma wuú. ");
INSERT INTO anvNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Ne baá utɔɔ́ Jɔn áchwɔɔ́ kpá geŋkwɔ jií ájyɛ nií. Ájyɛ ágare Jisɔs nkane ɛpyɛ ne Jɔn. ");
INSERT INTO anvNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Jisɔs awúgé abya negboné Jɔn, alyaá melu ɛwémbɔ ájyɛ kpɛ mmu ɛkpée ne baá utɔɔ́ bií, áfɛ́ né mbaá ayi álú bɔmbɔ, nnó ɛbwɔ́ ábɛ́ ɛwú ɛbwɔ́ ɛbwɔ́. Yɛ́mbɔ bɔɔ́ áwúgé nnó akpɛ ɛkpée ale jyɛ, átané né umɛ malɔ ákɛ ne uka ákwɔlege ji. ");
INSERT INTO anvNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Jisɔs átanégé mmu ɛkpée, maŋkwɔ́ mapea mewaá, agɛ́ gejamégé bɔɔ́, ne meshwɛ akwɔ́ ji metɔɔ́ gétúgé ɛbwɔ́, apyɛ ɛbwɔ́ atoó mbaá mameé ayi ɛbwɔ́ ábɔ́ ámée. ");
INSERT INTO anvNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Ndɛre nkwale akwɔ́nege baá utɔɔ́ bií ájyɛ́ báne ji áké, “Ata bií úfɛ́ ne mbaá yina alu ɛke mashwɔne, lyaá bɔɔ́ bina ájyɛ áná menyɛɛ́ né baá malɔ ayi álu fa kwɔ́kwɔ́lé ányɛ́.” ");
INSERT INTO anvNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Jisɔs ashuú ɛbwɔ́ meko aké, “Ngɛ́ fɔ́ ula bi ɛbwɔ́ ájyɛ kɛ́le menyɛɛ́ wɔ́. Ɛnyú ambɔɔ́ chyɛ́ge ɛbwɔ́ genó ányɛɛ́.” ");
INSERT INTO anvNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Baá utɔɔ́ bií áké, “Déwyaá lé ntó brɛd ɛ́táa ne meshuú ɛ́pea fa, yɛ genó ɛyigécha gepɔ́.” ");
INSERT INTO anvNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Jisɔs aké ne ɛbwɔ́, “Chwɔge me ne ɛ́ji.” ");
INSERT INTO anvNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Agaré gejamégé bɔɔ́ bimbɔ aké ájwɔ́lé né dambyanja, asɛ́ ntóo brɛd ɛyimbɔ ɛ́táa ne meshuú ɛ́peá, apɛ amɛ mfaánebuú achyɛɛ́ matame mbaá Ɛsɔwɔ agyá ɛ́jí ubauba achyɛɛ́ baá utɔɔ́ bií, nnó ákaré mbaá gejamégé bɔɔ́ bimbɔ. ");
INSERT INTO anvNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Yɛ́ndémuú ányɛ́ ágbeé. Ne baá utɔɔ́ bií ákɛ ányweré ayi álaá, ágbeé usá úfyáneupeá. ");
INSERT INTO anvNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Mpa bɔɔ́ abi ányɛ́ menyɛɛ́ yimbɔ mbɔgé álá gbɛɛ́ fɔ́ ándée ne baá wɔ́, ande ɛbwɔ́ ɛbwɔ́ álú dɛlé bɔɔ́ átáa. ");
INSERT INTO anvNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Ɛpyɛ́gé mbɔ, Jisɔs aké baá utɔɔ́ bií ákpɛ ɛkpée ábɔ́ mbɛ áchyaágé gentoógé mewaá. Ji ala meso agare bɔɔ́ nnó ɛbwɔ́ ákéré né upú bwɔ́. ");
INSERT INTO anvNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Ánérégé mangaré ɛbwɔ́ nnó ákéré, akwɔ́ afɛ́ mfaá mékwɛ́ jimbií manɛmmyɛ. Alu ɛ́wu jimbií kpaá tɛ nkwale akwɔné. ");
INSERT INTO anvNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Né gébé ɛyigémbɔ ɛkpée ɛwé ɛkpané baá utɔɔ́ bií ɛ́fɛ́ mɛ́ tɛtɛ metɔɔ́ nnyi. Mbyo ammyɛ ne ɛwu, apyɛɛ́ ŋgbannyi adoó ɛwu ɛgbɛ́ ɛwé ne ɛwé. ");
INSERT INTO anvNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Ɛlɔ né gejɛ́jɛ́gébí kpaá tɛ dondo, Jisɔs ákɛ́né mfaá mekɔ manaá manjyɛ báne ɛbwɔ́. ");
INSERT INTO anvNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Baá utɔɔ́ bií áké ágɛ́ne nkane ji akɛ́ne achwɔ́ mfaá mekɔ manaá, ɛfɔ ɛkwɔ́ ɛbwɔ́ matɔɔ́ ákálege áwére áké “Meló ɔ ɔ́, meló ɔ ɔ́”. ");
INSERT INTO anvNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Tɛ́nétɛ́né yimbɔ Jisɔs ajɔɔ́ ne ɛbwɔ́ aké, “Ɛlé me, gbarege matɔɔ́ nyú, défɔge.” ");
INSERT INTO anvNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Pita ashuú ji meko aké, “Ata mbɔgé nnó ɛle wɔ wáwálé pyɛ me ntó nshulé nkɛ mfaá mekɔ manaá nchwɔ́ mbané wɔ.” ");
INSERT INTO anvNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Jisɔs aké ne ji, “Shulé chwɔ́, ajɔ́ge mbɔ.” Pita atané mmu ɛkpée ashule nnyi alɔ mánkɛné mfaá mekɔ manaá manjyɛ báne ji. ");
INSERT INTO anvNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Ne nkane ágɛné mbyo nnyi ammyɛ ne ɛshyɛ, ɛfɔ ɛkwɔ́ ji metɔɔ́ ne alɔ manke mmu nnyi. Akalé áké, “Ata, poó me.” ");
INSERT INTO anvNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Jisɔs asá ɛbwɔ tɛ́nétɛ́né yimbɔ agbaré ji, ajɔɔ́ aké, “Ɛ ɛ́ metɔɔ́ ɛwé ɔfyɛɛ́ ne me ɛlú dada, waá aké wɔ ɔbɛ ne dembyɔ né metɔɔ́.” ");
INSERT INTO anvNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Ɛbwɔ́ ákpɛ́gé né mmu ɛkpée, mbyo yimbɔ apwá. ");
INSERT INTO anvNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Ɛfɛɛ́ ne bɔɔ́ abi álú mmu ɛkpée ánogé Jisɔs, ájɔɔ́gé áké, “Wáwálé wɔ ɔlu Maá Ɛsɔwɔ.” ");
INSERT INTO anvNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Bɔ Jisɔs ánérégé manchyaá gentoógé mewaá ɛyigémbɔ, ákwɔné né melɔ Gɛnɛsarɛt. ");
INSERT INTO anvNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Ne bɔɔ́ abi álu ɛfɛɛ́ ákaá nnó gɛ́ Jisɔs na, álɔ meko né malɔ ayi álú né gebagé mewaá ɛyigémbɔ geko. Bɔɔ́ bimbɔ ákpá yɛ́ bɔɔ́ abi ámeé ako áchwɔ́ ne ɛbwɔ́ mbaá Jisɔs. ");
INSERT INTO anvNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Ánɛ Jisɔs mmyɛ nnó agɔ́ ɛbwɔ́ áta lé mano nkú jií. Ne yɛ́ndémuú nemeé ayi ataá mano nkú Jisɔs atoó. ");
INSERT INTO anvNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Bɔɔ́ Farasi ne anlɛré mabɛ́ Ɛsɔwɔ fɔ átané Jɛrosalɛ áfɛ́ mbaá Jisɔs ágií ji áké, ");
INSERT INTO anvNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Ulannó ne baá utɔɔ́ byɛ ályaá mankwɔ́légé unó bi ukwene antɛ sé álɛré? Pɛ ɛbwɔ́ áshwɔ́négé fɔ́ amu gefɔɔ́ ɛyigé ukwene antɛ sé ájɔɔ́ nnó ɛsé dépyɛ́gé ne dényɛ́gé menyɛɛ́.” ");
INSERT INTO anvNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Jisɔs awúgé mbɔ ashuú ɛbwɔ́ meko aké, “Ɛnyú ntó delyaá mabɛ ayi Ɛsɔwɔ aké débélégé, dela kwɔ́lé lé unó bi ukwene antɛ nyú álɛrége? ");
INSERT INTO anvNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Desɛ ndɛre Ɛsɔwɔ ajɔɔ́ nnó, ‘Nógé mma wyɛ ne ntɛ wyɛ.’ Ne ájɔɔ́ ntó nnó, ‘Mbɔgé muú ajɔ́gé mejɔɔ́ mebo ne mma wuú yɛ́ ɛlé ne ntɛ wuú ábɔ́ manwá ji.’ ");
INSERT INTO anvNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Yɛ́mbɔ né ɛgbɛ́ ɛwé nyú, dela gáre lé nnó, mbɔgé muú abɛgé ne genó ɛyigé ji akage poó mma wuú yɛɛ́ ɛbɛ́lé ntɛ wuú ne geji, ‘Ágáré lé nnó anyɛ́ mɛ́ meno manchyɛ geji mbaá Ɛsɔwɔ.’ ");
INSERT INTO anvNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Apyɛgembɔ abɔɔ́ sé manlɛré ɛnógé, apoó mmá wuú ne ntɛ wuú manchyɛɛ́ ɛbwɔ́ geji wɔ́. Wyɛmbɔ ne ɛnyú desɛle mabɛ Ɛsɔwɔ ne gembya gétúgé gepɔ ɛyigé ukwene antɛ nyú álɛré. ");
INSERT INTO anvNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Ɛnyú bɔɔ́ dembwɔ́lé, Asaya muú ɛkpávé Ɛsɔwɔ abɔ́ alu cho gébégé agaré nyá mekomejɔɔ́ Ɛsɔwɔ atomé ne ɛnyú nnó, ");
INSERT INTO anvNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","“Bɔɔ́ bina ánógé me ne ubɔ́meno, yɛ́mbɔ ánógé fɔ́ me né mmu matɔɔ́ bwɔ́ cháchá. ");
INSERT INTO anvNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Ɛnógé ɛwé ɛbwɔ́ ánoge me ɛlú detú, nénde ásɛle unó ukwene antɛ bwɔ́ álɛrege ɛké mabɛ ya.” ");
INSERT INTO anvNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Jisɔs akuú njuné bɔɔ́ ɛniné mbɔ nechwɔ́ ɛta wuú, aké, “Wúge genó ɛyigé menkɛlege mangaré ɛnyú ne kaáge nnó. ");
INSERT INTO anvNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Unó bi upyɛ muú álá bɛɛ́ cho né mbɛ ushuú Ɛsɔwɔ, upɔ́ fɔ́ ɛbi ukpɛ́ne ji né meno, ɛlé ɛyi getanege ji né meno.” ");
INSERT INTO anvNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Jisɔs ajɔ́gé mbɔ baá utɔɔ́ bií ake mmyɛ afií ji agií áké, “Ɔkaá nnó genó ɛyigé wɔ ɔjɔɔ́ mbɔ gepyɛ bɔɔ́ Farasi ásɔ matɔɔ́ wɔ́?” ");
INSERT INTO anvNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Jisɔs ashuú ɛbwɔ́ meko aké, “Ntɛ wa muú alu né mfaánebuú agoóge nyɛ yɛ́ndé genɔɔ́ ɛyigé ji alá pɛɛ́ wɔ́. ");
INSERT INTO anvNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Dechyɛgé gemɛge nyú ɛfwyale gétúgé bɔɔ́ Farasi bimbɔ. Ɛbwɔ́ álú bɔɔ́ amɛ nónómé abi ájame abifɔ meti. Ne mbɔgé muú ayi amɛ anómé ji, ajame ntɛ muú amɛ nónómé meti, ɛbwɔ́ ako ákwéne mmu gepyɛɛ́.” ");
INSERT INTO anvNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Jisɔs ajɔ́gé mbɔ, Pita agií ji aké, “Gáré ɛsé ula nekanémejɔɔ́ ɛniné wɔ ɔtome na nnó, ɛpɔ́fɔ́ unó bi ukpɛne muú né meno ne upyɛɛ́ ji ála bɛɛ́ fɔ́ cho né mbɛ ushuú Ɛsɔwɔ.” ");
INSERT INTO anvNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Jisɔs aké ne ɛbwɔ́ nnó, Ɛnyú ntó delú defɔɔ́ pɔ́ ɛké atɛ? ");
INSERT INTO anvNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Ɛnyú dekaá fɔ́ nnó, yɛ́ndégenó ɛyi gekpɛ́ne né meno gékoóge le né unɛ ne getané wɔ́? Geji gepyɛɛ́ fɔ́ nnó muú ábɛ́ debadeba né mbɛ ushu Ɛsɔwɔ. ");
INSERT INTO anvNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Yɛ́mbɔ unó bi útánege muú né meno utanege ji né mmu metɔɔ́, ubi ne upyɛ ji abɛɛ́ debadeba né mbɛ ushuú Ɛsɔwɔ. ");
INSERT INTO anvNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Ɛlé né metɔɔ́ ne ufɛ́ré uboubo utanege, ubi ne upyɛ bɔɔ́ áwáne atɛ, ákwene malɔ, ánáne manáné tametame, ájo ɛjo, átɛnege ntɛ́sɛ́ gebyɔ, ne manchɔge mabɔ atɛ. ");
INSERT INTO anvNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Gɛ́ unó bi upyɛ́ɛ muú ála bɛɛ́ fɔ cho né mbɛ ushuú Ɛsɔwɔ na. Mbɔgé muú anyɛgé menyɛɛ́ amu deba ɛpyɛ́ fɔ́ nnó ji ábɛgé cho né mbɛ ushuú Ɛsɔwɔ. ");
INSERT INTO anvNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Bɔ Jisɔs ályaá ɛfɛɛ́, áfɛ́ né gebagé mewaá Tiya ne Sidɔn. ");
INSERT INTO anvNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Ne mendée fɔ né geluage bɔɔ́ Kanaan ajwɔlege né gebagé mewaá ɛyimbɔ, achwɔ́ báne Jisɔs anɛne ji mmyɛ aké, “Mpyáne Dɛvid, Ata gɛ me meshwɛ. Melo nchyɛ akpɛ maá wa mmyɛ, achyɛge ji ɛfwyale dɔɔ́.” ");
INSERT INTO anvNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Jisɔs ashuú yɛɛ́ ji meko wɔ́, ɛfɛɛ́ ne baá utɔɔ́ bií ajɔɔ́ ne ji áké, “Bú mendée yina ajyɛ néndé achyɛge ɛsé ɛfwyale ne mejɔɔ́.” ");
INSERT INTO anvNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Ne Jisɔs aké, “Ɛsɔwɔ atɔ me nnó nchwɔ́ le mbaá bɔɔ́ Isrɛli abi álu ɛké magɔmŋme ayi ánomé.” ");
INSERT INTO anvNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Yɛ́mbɔ mendée yimbɔ achwɔ́ tó manó né mbɛ ushuú wuú anɛne ji mmyɛ aké, “Ata poó me.” ");
INSERT INTO anvNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Jisɔs ashuú ji meko aké, “Ɛlɔ́mé fɔ́ nnó muú asɛ menyɛɛ́ ayi baá melɔ ányɛ́ achyɛɛ́ bɔ mammyɛ.” ");
INSERT INTO anvNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Mendée yimbɔ ntó ashuú ji meko aké, “Ata ɛlú wáwálé, yɛ́mbɔ bɔ mammyɛ ányɛɛ́ uchɔchɔgéré menyɛɛ́ ɛbi utanegé mfaá ɛkpókpógélé antɛ bwɔ́ ukwene mme.” ");
INSERT INTO anvNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Jisɔs awúge mbɔ, ashuú ji meko aké, “Ɛ, ɛ́, mma metɔɔ́ ɛwé ɔfyɛɛ́ ne me ɛja gɛ́. Ɛsɔwɔ apyɛ nyɛ genó ɛyigé wɔ ɔkɛ́lege.” Wyɛ né gébé ɛyigémbɔ, Ɛsɔwɔ apyɛ maá mendée yimbɔ atoó. ");
INSERT INTO anvNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Bɔ Jisɔs ályaágé yɛɛ́ ɛfɛɛ́, ákoó né mapea géntoógé mewaá Galilií. Akwɔ́ mfaá mékwɛ́ ajwɔlé ka. ");
INSERT INTO anvNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Gejamégé bɔɔ́ áchwɔ́ ɛta wuú ne ubwiré bɔ́, bɔɔ́ amɛ nónómé, bɔɔ́ uchánchi, abi álá jɔgé mejɔɔ́ álá wuú, ne gejamégé bɔɔ́ mameé abifɔ. Ábelé ɛbwɔ́ mbɛ ushuú Jisɔs ne apyɛ ɛbwɔ́ ako átoó. ");
INSERT INTO anvNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Bɔɔ́ bimbɔ álá mano mekpo fuú ndɛre ágɛné bɔɔ́ abi ábɔ́ álá jɔ́gé mejɔɔ́, ájɔɔ́ge abi ábɔɔ́ álá wuú, áwuú, bɔɔ́ uchánchi átoó, ubwiré úkɛ́ne ne abi amɛ nónómé ágɛne. Bɔɔ́ bimbɔ áfɛɛ́ Ɛsɔwɔ ayi bɔɔ́ Isrɛli ánóge. ");
INSERT INTO anvNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Jisɔs akuú baá utɔɔ́ bií ajɔɔ́ ne ɛbwɔ́ aké, “Meshwɛ apyɛɛ́ me ne bɔɔ́ bina gɛ́ néndé álɛ mbɔ fa ndɔ ɛlɛɛ́ ne me ne nana ápɔ́ yɛɛ́ ne genó ɛyigé ányɛɛ́. Nkɛ́légé fɔ́ manlyaá ɛbwɔ́ ájyɛɛ́ unɛ mesa ɛkage muú bwɔ́ fɔ átɔ́ɔ né meti.” ");
INSERT INTO anvNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Baá utɔɔ́ bií ágií ji áké, “Fa né mashwɔne ɛse degɛne mbɔ menyɛɛ́ fɔ́ ayi ákwanege njuné bɔɔ́ bina manyɛ́ né mbaá yina ayi melɔ ɛlá ɛ́pɔ́?” ");
INSERT INTO anvNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Ne Jisɔs agií ɛbwɔ́ aké, “Ɛnyú dewyaá ntoó brɛd ɛnií ɛfɛɛ́?” Áshuú ji meko áké, “Dewyaá ntoó brɛd ɛ́kénéama ne ukɛ́kɛ́ baá meshuú.” ");
INSERT INTO anvNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Ɛfɛɛ́ mbɔ ne Jisɔs agaré bɔɔ́ bimbɔ aké, “Jwɔ́lege mme.” ");
INSERT INTO anvNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Asɛ́gé yɛ ntoó brɛd ɛyimbɔ ɛ́kénéama ne ukɛ́kɛ́ baá meshuú bimbɔ, achyɛɛ́ matame ɛta Ɛsɔwɔ gétúgé menyɛɛ́ yimbɔ. Agya ji ubauba achyɛɛ́ baá utɔɔ́ bií nnó ákáré mbaá bɔɔ́ bimbɔ. ");
INSERT INTO anvNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Ɛbwɔ́ ako ányɛɛ́ ágbeé ne gébégé baá utɔɔ́ bií ánywéré uba bi ulaá ugbeé usá ukeneama. ");
INSERT INTO anvNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Mpa ande abi anyɛ́ɛ menyɛ́ yimbɔ álu bɔ dɛlé anií. Ápaá fɔ́ andée ne baá melɔ wɔ́. ");
INSERT INTO anvNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Ɛpyɛ́gémbɔ, Jisɔs ate bɔɔ́ bimbɔ áwilé. Jimbɔ ajyɛ kpɛ mmu ɛ́kpée afɛ́ né gebagé mewaá Magadon. ");
INSERT INTO anvNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Gébé ɛyigémbɔ, bɔɔ́ ɛkwɔ́ Farasi ne bɔɔ́ Sadusi áchwɔ́ mua Jisɔs áké, “Pyɛ ufélekpa ɛse dégɛ́, manlɛre nnó Ɛsɔwɔ ne atɔ́me wɔ.” ");
INSERT INTO anvNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Yɛ́mbɔ Jisɔs ashuú ɛbwɔ́ meko aké, “Nkwale akwɔnégé nebuú né gɛlege deké bií ulɔme nyɛ geyá. ");
INSERT INTO anvNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Ne dondo akwɔnégé nebuú nshulégé goge, dansama aké apyɛɛ́ deké, ‘Manaá achwɔ kwé’. Ɛnyú degɛgé nkane nebuú nélú dekaáge gefɔgé genó ɛyigé gechwɔ́ɔ pyɛ, yɛ́mbɔ ɛnyú dékaágé ula unó bi upyɛ mbɔ né gébé ɛyigé na. ");
INSERT INTO anvNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Ɛnyú njyɛ ɛniné na debɔ, delu bɔɔ́ abi átií meso ne Ɛsɔwɔ. Dekɛlege me nlɛ́ré ɛnyú ufélekpa, yɛ́mbɔ yɛ́ uma nlɛ́régé fɔ́, wyɛ lé ufélekpa Jona muú ɛkpávé Ɛsɔwɔ ne me nlɛ́rege nyɛ ɛnyú.” Ajɔɔ́gé mbɔ atané afɛ́ ji. ");
INSERT INTO anvNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Ne baá utɔɔ́ Jisɔs achyaá géntoógé mewaá afɛ́ ɛgbɛ́ ɛwé né, ndɛre ájyɛ ájinte mamkpa brɛd. ");
INSERT INTO anvNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Ndɛre ɛbwɔ́ ájyɛɛ́, Jisɔs ajɔɔ́ ne ɛbwɔ́ aké, “Sɛge gébé ne yis ɛkwɔ bɔɔ́ Farasi ne ɛkwɔ bɔɔ́ Sadusi.” ");
INSERT INTO anvNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Ɛbwɔ́ álɔ manjɔgé ɛbwɔ́ ɛbwɔ́ áké, “Ndɔfɔ ajɔ́gé mbɔ lé délá kpaá brɛd wɔ́.” ");
INSERT INTO anvNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Jisɔs akaá genó ɛyigé ɛbwɔ́ ajɔgé ne agií aké, “Ɛ ɛ́ metɔɔ́ ɛwé ɛnyú defyɛɛ́ ne me ɛlu dada. Ulannó ɛnyú dejɔɔ́ge mechɔ́ brɛd ayi ɛnyu dela pɔ́ ne ji? ");
INSERT INTO anvNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Nnó ɛnyú delu dekaá? Ɛlúmbɔ ɛké dejinte nnó me nkaáge chyɛɛ́ ɛnyú menyɛɛ́. Tege nkane nsɛlé ntoó brɛd ɛ́ta nchyɛɛ́ dɛlé bɔ ɛta ányɛɛ́ ne usá ɛbi ulaá. ");
INSERT INTO anvNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Ma tege ntó, ntoó brɛd ɛ́kénéama ɛyi nsɛlé nya nchyɛɛ́ dɛlé bɔ ɛnií ányɛɛ́ ne usá ɛbi ulaá. ");
INSERT INTO anvNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Ɛnyú dekaá nnó me mbɔ́ njɔɔ́gé fɔ́ lé gétúgé brɛd wɔ́? Gɔge me mmá nyware njɔɔ́ nnó sɛ́gé gébé ne yis ɛkwɔ bɔɔ́ Farasi ne ɛkwɔ bɔɔ́ Sadusi.” ");
INSERT INTO anvNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Ɛfɛɛ́ mbɔ ne baá utɔɔ́ bií ákaá yɛ́ nnó ji abɔ ajɔɔ́gé atome fɔ́ lé ne yis ayi apyɛ brɛd amuale. Ajɔ́ɔgé atome lé ne unó bi ɛkwɔ bɔɔ́ Farasi ne ɛkwɔ bɔɔ́ Sadusi álɛ́rege. ");
INSERT INTO anvNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Ne Jisɔs alyaáge ɛfɛɛ́, afɛ́ né gebagé mewaá Kaisaria Filipi. Akwɔ́négé wyɛ, agií baá utɔɔ́ bií aké, “Ndé gefɔgé muú ayi bɔɔ́ ájɔɔ́gé nnó me Maá Ntɛ Mekwaá nlu?” ");
INSERT INTO anvNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Baá utɔɔ́ bií ashuú ji meko áké, “Bɔɔ́ abifɔ ájɔ́ɔge nnó ɔlu mewené Jɔn menwyaá bɔɔ́ manaá Ɛsɔwɔ, abifɔ áké ɔlu Ɛlija ne abifɔ ntó áké ɔlu Jɛrimaya, ɛlá pɔ́ mbɔ fɔ́ wɔ́, ɔkage bɛ muú ɛkpávé Ɛsɔwɔ fɔ.” ");
INSERT INTO anvNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Ne ama gií ɛbwɔ́ aké, “Yɛ́ ɛnyú ambɔɔ́ deké me nlu waá?” ");
INSERT INTO anvNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Ajɔ́gé mbɔ, Simun Pita ashuú ji meko aké, “Wɔ ɔlu Muú yi Ɛsɔwɔ akweré ji ɛlá gefwa, Maá Ɛsɔwɔ muú álu mebɛ yɛ́ndégébé”. ");
INSERT INTO anvNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Ne Jisɔs ashuú ji meko aké, “Simun maá Jɔn, galɔ́gálɔ́ alu ne wɔ néndé, mechɔ́ ɛwé ɔjɔɔ́ mbɔ, ákwaá fɔ wɔ, alɛré wɔ ɛ́wú wɔ́, ɛlé Ntɛ wa né mfaánebuú ne alɛré wɔ. ");
INSERT INTO anvNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ne ngarege wɔ nnó ɔkamege ɛtaravɛ. Gébégé ntɛnegé nyɛ ɛchomele bɔɔ́ ba, ɛtaravɛ ɛwena ne ɛbɛɛ́ nebɔme. Ne negbo népɔ́ ne uto mampwɔ ɛwu. ");
INSERT INTO anvNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Ne nchyɛge nyɛ wɔ ɛgbɔ́gɔ́lɔ́ né gefwa ɛyigé Ɛsɔwɔ ágbárege. Ne yɛ́ndégenó ɛyigé wɔ ɔshyaá fa mme, ɛbyɛ́nnó Ɛsɔwɔ ntó ashya mɛ́ né mfaánebuú ne ɛyigé wɔ ɔkamégé fa mme ɛbyɛ́nnó Ɛsɔwɔ ntó akamé mɛ́ né mfaánebuú.” ");
INSERT INTO anvNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Ne aji yɛ́ baá utɔɔ́ bií ɛtu nnó ɛ́kágé ágaré muú fɔ nnó ji ne alu Kras, Muú yi Ɛsɔwɔ akweré ji ɛlá gefwa. ");
INSERT INTO anvNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Ɛfɛɛ́ ne Jisɔs alɔɔ́ mangaré baá utɔɔ́ bií pópó aké, “Mbɔ́ manjyɛ né Jɛrosalɛ, ɛfɛɛ́ ákpakpa melɔ ne anɔɔ́ baá abi ápyɛ upɛ Ɛsɔwɔ ne ánlɛré mabɛ́ Ɛsɔwɔ, ápyɛ nyɛ me ngɛ́ gejamégé ɛfwyale ne apyɛ́ɛ nyɛ bɔɔ́ áwá me. Yɛ́mbɔ ndɔ ɛlɛɛ́ ɛkwɔnégé Ɛsɔwɔ abwɛge nyɛ me nkwilé né negbó.” ");
INSERT INTO anvNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Ájɔ́gémbɔ, Pita asɛ ji átɛné babá, alɔ manshule ji ndo aké, “Cha-o! Ata Ɛsɔwɔ akamégé mechɔ́ ɛwéna ɛpyɛ ɛta wyɛ.” ");
INSERT INTO anvNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Yɛ́mbɔ Jisɔs aké ne Pita, “Kwilé me mbɛ ushu, danchɔmeló. Ɔgbɛɛ́ me meti mampyɛ genó ɛyigé Ɛsɔwɔ akɛ́lege néndé ɔfɛrégé unó nkane mekwaá, ɔfɛrégé fɔ́ ɛké Ɛsɔwɔ.” ");
INSERT INTO anvNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Jisɔs agáre yɛ́ baá utɔɔ́ bií aké, “Yɛ́ndémuú ayi akɛlege mambɛ́ menkwɔlé wa, abɔ́ manjinte gemɛ jií akpá gekwa jií nnó ákame negbo mankwɔ́lé me. ");
INSERT INTO anvNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Néndé yɛ́ndémuú ayi akɛlege mampoó geŋwá jií ɛbyɛ́nnó aníige nyɛ geji, ne mbɔgé muú akamégé manchyɛɛ́ geŋwá jií getú ya, ɛbyɛ́nnó abɔ nyɛ geji. ");
INSERT INTO anvNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Ndé nsá ayi muú ábɔ́ɔ, mbɔgé abɛge ne unó mme uko ne aníige geŋwá jií? Ndé géfɔ́gé genó ɛyigé muú akágé chyɛɛ́ mankwɔré ne geŋwá jií. ");
INSERT INTO anvNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Ngarege ɛnyú unó bina uko néndé me Maá Ntɛ Mekwaá nkerege nyɛ ne utó bi Ntɛ wa Ɛsɔwɔ achyɛɛ́ me ne makiɛ́nné ya ne nchyɛge nyɛ yɛ́ndémuú nsá wuú, ndɛre ji apyɛɛ́ utɔɔ́. ");
INSERT INTO anvNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Ngarege ɛnyú wáwálé nnó, gentɔgé bɔɔ́ álú mbɔ fáná, abi álá gbóo fɔ kpaá tɛ ágɛne nyɛ ndɛre Maá Ntɛ Mekwaá achwɔɔ́ nyɛ mangbare gefwa jií fa mme.” ");
INSERT INTO anvNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Ndɔ ɛ́kéné ɛ́kógé, Jisɔs asɛ Pita, Jɛmsi ne Jɔn meŋmo Jɛmsi ákwɔ́ áfɛ́ né mfaá mékwɛ́ ájwɔlé ɛbwɔ́ ɛbwɔ́. ");
INSERT INTO anvNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Ne áké apɛ́le Jisɔs akwɔré gefɔɔ́, ushu bií ugɛ́nege ɛké nésáné ŋmɛ ne mandeé jií abwɔlé áshwánege mané mané. ");
INSERT INTO anvNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Ɛbwɔ́ áké ápɛ́le, ágɛ́ nkane Mosis ɛbwɔ́ ne Ɛlija ákwɔmé mbélépó ájɔɔ́ge mejɔɔ́ ne Jisɔs. ");
INSERT INTO anvNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Pita ajɔɔ́ ne Jisɔs aké, “Ata ɛlɔ́ ndɛre ɛsé délú fa. Mbɔgé ɔkɛ́lege ntɛnege nyɛ ɛnyú baá óto álɛɛ́ fa, ama ɛta wyɛ, ama ɛta Mosis ne ama ɛta Ɛlija.” ");
INSERT INTO anvNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Wyɛ nkane Pita alu jɔɔ́ge mbɔ, áke ápɛ́le gekó gefɔ́ pópó gégɛ́nege mané mané gékweré ɛbwɔ́ ako mme ne meko muú atané né mmu gekó ɛyigémbɔ aké, “Gɛ́ge maá wa ayi mbwi metɔɔ́ na, metɔɔ́ ɛgɔɔ́ me ne ji, wuúge ne ji.” ");
INSERT INTO anvNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Gébégé baá utɔɔ́ bina álɛɛ́ áwuú meko yimbɔ, ɛfɔ ɛkwɔ́ ɛbwɔ́ metɔɔ́ ákwé pyó ne mashu mme. ");
INSERT INTO anvNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Yɛ́mbɔ Jisɔs achwɔ́ ta ɛbwɔ́ ne ajɔɔ́ aké, “Kwilege mme défɔ́gé sé.” ");
INSERT INTO anvNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Áké ápɛ́le ágɛ́ sé muú yicha wɔ́ ɛkosé Jisɔs ji mbií. ");
INSERT INTO anvNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Ndɛre ɛbwɔ́ áshulege mékwɛ́ ájyɛɛ́ Jisɔs áji ɛbwɔ́ ɛtu aké, “Dégarégé muú fɔ́ genó ɛyigé ɛnyú dégɛné mbɔ kpaá tɛ me Maá Ntɛ Mekwaá akwilége né negbo.” ");
INSERT INTO anvNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Jisɔs ájɔɔ́ge mbɔ, baá utɔɔ́ bií ágií yɛ́ ji áké, “Ulannó ánlɛré mabɛ́ Ɛsɔwɔ ájɔɔ́ áké Ɛlija abɔ́ mambɔ mbɛ akere meso fa mme gemɛge nnó Muú yi Ɛsɔwɔ akwere ji ɛla gefwa achwɔ́?” ");
INSERT INTO anvNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Jisɔs ajɔɔ́ aké, “Ɛlú wáwálé nnó Ɛlija abɔ́ mambɔ mbɛ achwɔ́, akwyɛɛ́ unó uko nnó ubɛ cho. ");
INSERT INTO anvNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Yɛ́mbɔ ngárege ɛnyú wáwálé nnó Ɛlija achwɔ́ mɛ́ ne bɔɔ́ ákaá fɔ gefɔgé muú ayi ji alu wɔ́, ápyɛ gabo ne ji nkane ɛjií ɛbwɔ́. Wyɛmbɔ ntó ne ɛbwɔ́ áchyɛge nyɛ Maá Ntɛ Mekwaá ɛfwyale.” ");
INSERT INTO anvNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Ɛfɛɛ́ mbɔ ne baá utɔɔ́ bií bimbɔ álé kaá yɛ́ nnó mechɔ́ ɛwé ji abɔ́ ajɔ́ge mbɔ, atome mbɔ lé ne Jɔn menwyaá bɔɔ́ manaá Ɛsɔwɔ. ");
INSERT INTO anvNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Ɛbwɔ́ ákérégé meso ábané gejamégé bɔɔ́. Mende fɔ achwɔ́ tó mano mbɛ ushu wuú, anɛ ji mmyɛ aké, ");
INSERT INTO anvNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“Ata, gɛ me meshwɛ, maá wa mende ameé gesasa. Ne nemeé ɛníné mbɔ nechyɛge ji ɛfwyale dɔɔ́. Népyɛɛ́ ji akwene yɛ́ndégébé né mewɛ né gébé ɛyigéfɔ akwene né nnyi. ");
INSERT INTO anvNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Ne nchwɔ́ ne ji mbaá baá utɔɔ́ byɛ yɛ́mbɔ ápulé nnó ápyɛ ji atoó meti ɛpɔ́.” ");
INSERT INTO anvNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Jisɔs ashuú meko aké, “Ɛ ɛ́ ɛnyú njyɛ ɛnina delu untantamé bɔɔ́ abi dela fyɛɛ́ metɔɔ́ ne Ɛsɔwɔ cháchá wɔ́. Nkoge mbɔ metɔɔ́ ne ɛnyú nnó? Mmage bɛ́ ne ɛnyú ndɔ ɛnií ne défyɛɛ́ metɔɔ́ ne Ɛsɔwɔ? Chwɔ́ge me ne maá yimbɔ.” ");
INSERT INTO anvNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Achwɔ́gé ne maá yimbɔ Jisɔs anyá meló nchyɛ yimbɔ atané ji mmyɛ. Wyɛ né gébé ɛyigémbɔ maá yimbɔ atoó. ");
INSERT INTO anvNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Ɛwyágé Jisɔs ne baá utɔɔ́ bií ála ɛbwɔ́ ɛbwɔ́ ne baá utɔɔ́ bií ágií ji áké, “Ulannó ne ɛsé dépulé meló nchyɛ yimbɔ mambuú apwɔ?” ");
INSERT INTO anvNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Jisɔs ashuú ɛbwɔ́ meko aké, “Melo nchyɛ yimbɔ apwɔ ɛnyú mambú gétúgé metɔɔ́ ɛwé défyɛɛ́ ne Ɛsɔwɔ ɛlu dada. Ngárege ɛnyú wáwálé nnó, metɔɔ́ ɛwé défyɛɛ́ ne Ɛsɔwɔ yɛ́ ɛbɛ́ ɛlé ŋénéŋéné ɛke nyiné mbwɛ́ ngboŋ, dekage gáre mékwɛ́ ɛwéna nnó, ‘Kwilé fa cho né mbaá yicha,’ ne ɛkwilége. Yɛ genó gefɔ gepwɔɔ́ fɔ́ ɛnyú mampyɛ.” ");
INSERT INTO anvNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Yɛ́mbɔ Ɛnyú dékage buú gefɔ́gé meló nchyɛ yina wyɛlé mbɔgé dénɛge mmyɛ ne délyage menyɛɛ́ kpékpé gétúgé depɔré Ɛsɔwɔ ne mmyɛmenɛne. ");
INSERT INTO anvNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Bií fɔ́ ndɛre Jisɔs ne baá utɔɔ́ bií alú melu ɛma né Galilií, ajɔɔ́ ne ɛbwɔ́ aké, “Ɛla gachyɛɛ́ áchyɛ́ge nyɛ Maá Ntɛ Mekwaá né amu bɔɔ́ nchyɛ. ");
INSERT INTO anvNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Áwáne nyɛ ji ne ndɔ ɛlɛɛ́ ɛkwɔnégé Ɛsɔwɔ apyɛ nyɛ ji akwilé né negbo. Jisɔs ajɔɔ́gé mbɔ, baá utɔɔ́ bií ála mesómé mesómé ndɛre áwuú mbɔ.” ");
INSERT INTO anvNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Jisɔs ne baá utɔɔ́ bií áchwɔ́ né melɔ Kapanɔm, ndɛre ɛbwɔ́ álu ɛwu, ánsɛlé ŋka makpo ɛcha upɛ Ɛsɔwɔ áchwɔ́ bane Pita ágií ji áké, “Nnó menlɛre nyú achyɛge fɔ ŋka makpo ɛcha upɛ Ɛsɔwɔ?” ");
INSERT INTO anvNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Pita akame aké, “Achyɛge.” Gébégé ji ákere meso né mmu gepú, gemɛgé nnó ánené meno, Jisɔs abɔ́ mɛ́ mbɛ ajɔɔ́ ne ji aké, “Simun nwyaá nkwɛ mangií wɔ. Nde ufɔɔ́ bɔɔ́ abi afwa mme ásɛle ŋka makpo ne maŋka yifɔ ɛta bwɔ́? Ásɛle na le mbaá ambɔɔ́ melɔ wa mbaá aŋkɛɛ́ bɔɔ́?” ");
INSERT INTO anvNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Pita ashuú ji meko aké, “Ásɛle mbaá aŋkɛɛ́ bɔ.” Ajɔge mbɔ Jisɔs aké, “Mbɔ ɛbyɛnnó baá ambɔɔ́ melɔ áchyɛge fɔ́ ŋka makpo. ");
INSERT INTO anvNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Yɛ́mbɔ ɛsé dekɛ́légé fɔ́ nnó depyɛ matɔɔ́ ásɔ́ bɔɔ́ abi. Shule né gentógé mewaá, ɔŋme ɛno wyɛ. Meshuú mbɛ ayi ɔbɔɔ́, néné meno wuú ɔgɛne nyɛ ŋka wyɛ, ɛkwanege machyɛɛ́ ŋka makpo ya ne ɛjyɛ. Bɔ ɛji ɔchyɛɛ́ ɛta bwɔ́.” ");
INSERT INTO anvNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Ɛwyá yɛɛ́ wɔ́, baá utɔɔ́ Jisɔs ajyɛɛ́ agií ji áké, “Ndé muú ábɛɛ́ muú kpaá né gefwa ɛyigé Ɛsɔwɔ ágbárege?” ");
INSERT INTO anvNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Jisɔs akuú maá fɔ kɔɔ́ ayi alu ɛfɛɛ́, achwɔ́gé apyɛ ji atɛ́né né metɔɔ́metɔɔ́ baá utɔɔ́ bií. ");
INSERT INTO anvNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Ne aké, “Ngarégé ɛnyú wáwálé nnó muú ála kwɔré abɛ ɛké mamane kɔɔ́ wɔ́, abɛ fɔ́ muú ayi anyɛ́ nyɛ gefwage Ɛsɔwɔ. ");
INSERT INTO anvNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Ndɛre ɛlúmbɔ, yɛ́ndémuú ayi ashulege mmyɛ ji mme nkane maá yina ne abɛɛ́ muú kpaá ayi apwɔɔ́ amu né gefwa ɛyigé Ɛsɔwɔ ágbárege. ");
INSERT INTO anvNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Yɛ́ndémuú ayi akamege mampyɛ galɔ́gálɔ́ ne mamane kɔɔ́ nkane ayina né mabɔ ma, ɛbyɛnnó asɛ mbɔ lé me. ");
INSERT INTO anvNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Yɛ́mbɔ, yɛ́ndémuú ayi apyɛɛ́ mamane kɔɔ́ nkane ayina nnó apyɛ gabo né geluagé bɔɔ́ abi áfyɛɛ́ metɔɔ́ ne me ɛlú galɔ́gálɔ́ nnó áshií ji gekpɛ́kpɛ́gé ntaá né gemɛ áŋmé ji né gentoógé ɛbɛɛ́ mega. ");
INSERT INTO anvNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Meshwɛ apyɛ́ɛ me ne bɔɔ́ mme yina gétúgé unó bi uténe ɛbwɔ́ ápyɛɛ́ gabo. Unó bina ubɔ mampyɛ, yɛ́mbɔ ɛbɔɔ́ nyɛ ne muú ayi aténe ntɛ yifɔ nnó apyɛɛ́ gabo. ");
INSERT INTO anvNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Mbɔgé ɛbwɔ wyɛ, yɛ́lé geká jyɛ ne gétene wɔ nnó ɔpyɛɛ́ gabo, sɔ́ geji ɔfómé. Ɛlú galɔ́gálɔ́ nnó ɔkpɛ né geŋwá gechúchúle ne nnó ɔkpɛ né mewɛ ɛwé ɛ́lá nómégé ne upɔ menyammyɛ byɛ uko. ");
INSERT INTO anvNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Ne mbɔgé dambɔɔ́nnyi wyɛ atene wɔ nnó ɔpyɛ gabo, pwɔ́lé ji ɔfómé, ɛ́lú galɔ́gálɔ́ nnó ɔkpɛ né geŋwá gechúchúle ne nnó ɔkpɛ né ntoné mewɛ ɛwé ɛ́lá nómégé ne amɛ́ ápeá. ");
INSERT INTO anvNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Sɛge gébé, debyagé fɔ yɛɛ́ muú ama né geluágé abi áfyɛɛ́ matɔɔ́ ne me ɛké ambáné kɔɔ́. Néndé, makiɛ́nné bwɔ́ álu yɛ́ndégébé né mbɛ ushuú ntɛ wa muú alu né mfaánebuú. ");
INSERT INTO anvNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Néndé Maá Ntɛ Mekwaá achwɔ́ mampoó bɔɔ́ abi álá ákwɔlege depɔré Ɛsɔwɔ. ");
INSERT INTO anvNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Desɛ nnó muú awyaá usaá magɔ́ŋme úta ne ɛ́ma ɛnogé apyɛɛ́ nnó? Mfɛré nnó ályágé ayi usaá uni meso nekuúneɛni né mbyɔ mékwɛ́ afɛ akɛle ɛwé ɛnomé kpaá tɛ́ ágɛ́ne. Pɔ mbɔ? ");
INSERT INTO anvNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Akɛlégé ɛwu agɛgé, ngarege ɛnyú wáwálé nnó, abɛɛ́ ne nechɔ́chɔ́ dɔɔ́ né gétúgé ɛma ɛwé ji agɛné apwɔ áyi usaá uni meso nekuúneɛni áyi ála no wɔ́. ");
INSERT INTO anvNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Wyɛ́mbɔ ntó ne Ntɛ ɛnyú muú alu né mfaánebuú alá kɛ́légé nnó yɛɛ́ muú ama ánó né geluágé abi áfyɛɛ́ metɔɔ́ ne me ɛké ambáné kɔɔ́. ");
INSERT INTO anvNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Jisɔs afɛ́ mbɛ manlɛ́régé aké, “Mbɔgé ntɛ meŋmɛ wyɛ né ɛchomele bɔɔ́ ba apyɛgé gabo ɛta wyɛɛ́, chó báné ji bíbí ɔpyɛ ji akaá gyɛɛ́ ayi ji apyɛɛ́. Mbɔgé akamégé nnó alu gyɛɛ́ ɛbyɛnnó dema sɛ atɛ ndɛre aŋmɛ. ");
INSERT INTO anvNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Ne mbɔgé alá kamé nnó genó ɛyigé ji apyɛɛ́ gélú gyɛɛ́ wɔ́, ‘sɛ muú ama yɛ́ apea ɔkere ɛta wuú nnó unó bi ɔjɔge ne ji bɔɔ́ apea yɛ alɛɛ́ ábɛ́ ndɛre bɔɔ́ ntɛsɛ́.’ ");
INSERT INTO anvNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Ne mbɔgé ake ashya wyɛ shyá nnó apɔ gyɛɛ́ né genó ɛyigé ji apyɛɛ́, kpá mechɔ́ ɛwémbɔ cho ne ɛwu né ɛchomele bɔɔ́ ba. Ne mbɔgé ɛchomele ɛpagé nnó ɔlu chó ne ji alá kámé wɔ, sɛge ji nkane muú ayi álá afyɛɛ́ metɔɔ́ ne Ɛsɔwɔ wɔ́ yɛ ɛké mensɛle ŋkamakpo.” ");
INSERT INTO anvNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Jisɔs ajɔɔ́gé mbɔ aké, “Ngárege ɛnyu wáwálé nnó yɛ́ndégenó ɛyigé ɛnyú deshaá fa mme, ɛbyɛ́nnó Ɛsɔwɔ ashyaá mɛ́ geji né mfaánebuú. Ne yɛ́ndégenó ɛyigé ɛnyú dekamégé fa mme ɛbyɛnnó Ɛsɔwɔ ntó akamé mɛ́ geji né mfaánebuú. ");
INSERT INTO anvNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Ne genó ɛyigéfɔ ɛyigé mmage gáre ɛnyú gelu nnó, yɛ́ndégébé ɛnyú ápeá fa mme dekamégé meko ama mangií Ɛsɔwɔ genó, dénɛgé mmyɛ Ntɛ wa muú alú né mfaánebuú achyɛge ɛnyú geji. ");
INSERT INTO anvNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Néndé yɛ́ndé mbaá yi bɔɔ́ ba ápeá yɛ alɛɛ́ áchomégé mbaá ama me ntó mbɛ ɛfɛɛ́ ne ɛbwɔ́.” ");
INSERT INTO anvNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Pita achwɔ́ gií yɛ́ Jisɔs aké, “Átá njíge mbɔ nte gabo ayi ntɛ meŋmɛ apyɛ́ɛ ɛta wa ndɔ ɛnií? Nnó kpaá tɛ ndɔ ɛkeneama?” ");
INSERT INTO anvNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Jisɔs ashuú ji meko aké, “Ngba, ɛpɔ́fɔ́ ndɔ ɛkénéama, ɔbɔ́ manjií ji nte usaá ndɔ ulɛɛ́ meso ɛfya né malu akeneama. ");
INSERT INTO anvNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Me ngarege ɛnyú mechɔ́ ɛwé gétúgé gefwa ɛyigé Ɛsɔwɔ ágbárege gélú ɛké abya yina. Mfwa fɔ́ abɔɔ́ mankwɔ́lé bɔɔ́ utɔɔ́ bií abifɔ áchwɔ́ ne bɔɔ́ utɔɔ́ bií ányɛɛ́ ji. ");
INSERT INTO anvNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Ndɛre alɔ ula mankwɔ́légé, bɔɔ́ utɔɔ́ bií abifɔ áchwɔ́ ne muú utɔɔ́ wuú ayifɔ ama ayi agbaré ji gejamégé ŋka ɛyi ɛpwɔ amu. ");
INSERT INTO anvNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Ne ɛlé álá kaáge kwɔ ujwɔɔ́ bií ji anyɛɛ́ mfwa yimbɔ, mfwa yimbɔ aké ákpó mende yimbɔ, mendée wuú ne baá ne yɛ́ndégenó ɛyigé ji awyaá nnó agɛ́ ŋka akwɔ ujwɔɔ́ bií. ");
INSERT INTO anvNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Ajɔɔ́ge mbɔ, muú utɔɔ́ wuú yimbɔ abogéné mmyɛ mme ne mbɛ ushu mfwa yimbɔ, anɛ ji mmyɛ aké, ‘Ata, nkpa geka jyɛ, chyɛɛ́ me gébé nkwɔle nyɛ ujwɔɔ́ byɛɛ́ uko.’ ");
INSERT INTO anvNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Apyɛ́gé mbɔ meshwɛ akwɔ mfwa yimbɔ metɔɔ́ dɔɔ́ alyaá ji nnó ajyɛɛ́ akwɔgé sé ujwɔɔ́ bimbɔ. ");
INSERT INTO anvNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Yɛ́mbɔ, ndɛre muú utɔɔ́ yimbɔ atané mbaá mfwa ajyɛɛ́ dafyɛ agɛ́ ntɛ muú utɔɔ́ ayifɔ ayi agbaré ji ɛkɛ́kɛ́ ŋka ɛwé ɛlá pɔ́ yɛɛ́ genó mamɛɛ́ ne ŋka ɛyi ji agbaré mfwa yimbɔ. Apyɛ ji anyuá amu mmwɔ́lé aké, ‘Chyɛɛ́ me ŋka ya ɛyi ɔnyɛɛ́.’ ");
INSERT INTO anvNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Ntɛ meŋmɛ yimbɔ abogéné mme anɛ ji mmyɛ aké, ‘Ntɛ, chyɛɛ́ me gébé nkwɔle nyɛ ujwɔɔ́ byɛ!’ ");
INSERT INTO anvNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Yɛ́mbɔ mende yimbɔ akame wɔ. Tɛnétɛné yimbɔ afyɛ mende yimbɔ né denɔ nnó akwɔ ujwɔɔ́ bií uko. ");
INSERT INTO anvNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Gébégé bɔɔ́ utɔɔ́ mfwa abifɔ ágɛné mechɔ́ ɛwéna, metɔɔ́ ɛsɔ́ ɛbwɔ́ dɔɔ́ ájyɛ toó mfwa yɛ́ndégenó ɛyigé gepyɛɛ́. ");
INSERT INTO anvNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Mfwa akuú muú utɔɔ́ ayi mbɔ, ayi ji abɔ́ ajɔɔ́ nnó akwɔgé sé ujwɔɔ́ bi ágbarege ji nnó achwɔ́. Achwɔ́gé, ajɔɔ́ ne ji aké, ‘Wɔ muú mebo yina, ɔnɛ me mmyɛ ngɛ́ wɔ meshwɛ, nlyaá gekpɛ́kpɛ́gé ujwɔɔ́ ɛbi ɔnyɛ́ me; ");
INSERT INTO anvNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","ɔbɔ́ ɔlu mangɛ́ ntó ntɛ meŋmɛ wyɛ meshwɛ ndɛre me ngɛné wɔ meshwɛ, pɔ́ mbɔ?’ ");
INSERT INTO anvNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Ne metɔɔ́ ɛsɔ́ mfwa yimbɔ dɔɔ́ ajɔɔ́ aké áfyɛ́ mende yimbɔ né denɔ átulé ji kpaá tɛ akwɔ́le ujwɔɔ́ ɛbi anyɛɛ́ ji uko.” ");
INSERT INTO anvNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Jisɔs ánérégé manjɔɔ́ aké, “Wyɛmbɔ ntó ne ɛbɛ nyɛ ne Ɛsɔwɔ Ntɛ wa muú alu né mfaánebuú. Mbɔgé ɔlá jinte gabo ayi ntɛ meŋmɛ wyɛ ápyɛɛ́ ne metɔɔ́ wyɛɛ́ meko wɔ́, Ɛsɔwɔ apyɛɛ́ nyɛ ne wɔ ntó wyɛ ndɛre mfwa yimbɔ abɔ́ apyɛɛ́ ne muú utɔɔ́ wuú yimbɔ.” ");
INSERT INTO anvNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Jisɔs anerege manjɔɔ́ depɔ ɛtire na deko, alyaá gebagé mewaá Galilií afɛ́ né gebagé mewaá Judiya achyaá ɛbɛɛ́ Jodan. ");
INSERT INTO anvNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Gejamege bɔɔ́ gekwɔle ji. Apyɛ abi ámeé átoó. ");
INSERT INTO anvNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Ndɛre ji alú ɛwú, bɔɔ́ Farasi fɔ áfɛ́ ɛta wuú mammua ji áké, “Nnó ɛbɛ́ ɛsé ɛkamé nnó mende awá neba ne mendée wuú né yɛ́nde ɛkɛ́ mechɔɔ́?” ");
INSERT INTO anvNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Ágíge mbɔ, Jisɔs ashuú ɛbwɔ́ meko aké, “Ɛlu wáwálé nnó ɛnyú dekú mɛ́ né mmu Ɛsɔwɔ nnó, tɛ́ ula ulɔɔ́ ɛbi Ɛsɔwɔ muú ákwyɛɛ́ nyá bɔɔ́, akwyɛɛ́ ɛbwɔ́, mende ne mendée.” ");
INSERT INTO anvNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","“Getú ɛyigé na mende alyage nyɛ mmá wuú ne ntɛ wuú afɛ́ acho mmyɛ ne mendée wuú ɛbwɔ́ ápea ákwé muú ama. ");
INSERT INTO anvNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Ɛbwɔ́ ápɔ́ sé bɔɔ́ ápeá nana, ála muú ama. Ndɛre ɛlúmbɔ bɔɔ́ abi Ɛsɔwɔ áchomé chónchó né neba ɛ́kágé muú akya nnó atyáa.” ");
INSERT INTO anvNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Bɔɔ́ Farasi abimbɔ ágií ji áké, “Ulannó ne ɛbɛ Mosis ɛjɔɔ́ ɛké mende akáge chyɛɛ́ mendée wuú mekpo ŋwɛ manlɛre nnó awá neba ne akage lyaá ji?” ");
INSERT INTO anvNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Jisɔs ajɔɔ́ ne ɛbwɔ́ aké, “Mosis akame nnó ɛnyú déwá neba ne andée nyú gétúgé mekpo meto nyú. Yɛ́mbɔ, ɛbɔ ɛpɔ́fɔ́ mbɔ gébégé Ɛsɔwɔ abɔɔ́ mbɛ akwyɛɛ́ mende ne mendée. ");
INSERT INTO anvNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","“Ne ngárege ɛnyú nnó, yɛndé mende ayi awáne neba ne mendée wuú, mbɔgé mendée yimbɔ álá kwe ulɔ wɔ́ ne ajyɛge ba mendée ayichá akwé mbɔ lé ulɔ.” ");
INSERT INTO anvNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Baá utɔɔ́ Jisɔs ájɔɔ́ ne ji áké, “Ɛbɛge nnó wyɛ mechɔ́ ulɔɔ́ ɛwuɛwu ne muú akágé wa neba ne mendée wuú, ɛlu chaŋéné nnó mende ábagé yɛ mendée cháchá.” ");
INSERT INTO anvNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Jisɔs ashuú ɛbwɔ́ meko aké, “Bɔɔ́ ako fɔ́ wɔ́ ákamégé manjwɔle ayi álá ábá neba wɔ́. Ɛkose bɔɔ́ abi Ɛsɔwɔ achyɛɛ́ ɛbwɔ́ ɛshyɛ ne ákáge jwɔle. ");
INSERT INTO anvNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Kágé nnó ábyɛ́ ande abifɔ mpɛ́, abifɔ ɛlé ákwaá ne ápyɛɛ́ ɛbwɔ́ álu mbɔ. Bɔɔ́ abifɔ ájwɔle wyɛmbɔ ɛké mpɛ́ gétúgé utɔɔ́ gefwa ɛyigé Ɛsɔwɔ ágbárege. Bɔɔ́ abi ákamégé manjwɔlé ayi ála abá neba wɔ́ ájwɔlé.” ");
INSERT INTO anvNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Bɔɔ́ fɔ áchwɔ́ ne baá bwɔ́ ɛta Jisɔs nnó anɛ́ré ɛbwɔ́ amu makpo anɛmmyɛ mbaá Ɛsɔwɔ ajé ɛbwɔ́. Baá utɔɔ́ bií ányá bɔɔ́ bimbɔ. ");
INSERT INTO anvNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Yɛ́mbɔ Jisɔs ajɔɔ́ ne ɛbwɔ́ aké, “Lyáge ambánékɔ́ áchwɔ́ ɛta wa, ɛkagé dégbɛ́ ɛbwɔ́ néndé gefwa ɛyigé Ɛsɔwɔ ágbárege gelú ɛyigé bɔɔ́ abi álu ndɛre baá bina.” ");
INSERT INTO anvNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Ajɔ́gé mbɔ, anɛre ammu né mekpo yɛ́ndé maá ajé ɛbwɔ́, anerege alyaá yɛ́ melu ɛwémbɔ afɛ́. ");
INSERT INTO anvNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Bií uma mende fɔ afɛ́ mbaá Jisɔs. Ágií ji áké, “Ménlɛré mbɔgé nkɛ́lege geŋwá ɛyi gélágé byɛɛ́, nde galɔ́gálɔ́ ayi mbɔɔ́ mampyɛ?” ");
INSERT INTO anvNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Agíge mbɔ, Jisɔs ashuú ji meko aké, “Ulannó wɔ ɔgíge me genó ɛyi gelɔ́me, Ɛsɔwɔ mbií ne alú muú ayi alɔ́me. Mbɔgé ɔkɛ́lege mambɔ geŋwá, nógé yɛ́ mabɛ Ɛsɔwɔ.” ");
INSERT INTO anvNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Ne mende yimbɔ agií Jisɔs aké, “Mabɛ ayi nde?” Jisɔs ashuú ji meko aké, “Ɔwáge muú, ɔkwége ulɔ, ɔjogé ɛjo, ɔtɛ́negé ntɛ́sɛ́ gebyɔ́. ");
INSERT INTO anvNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Nógé ntɛ wyɛɛ́ ne mmá wyɛɛ́ ne gbógé ne ntɛ méŋmɛ́ wyɛɛ́ ndɛre ɔgboó ne gemɛ jyɛɛ́.” ");
INSERT INTO anvNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Ne mende yimbɔ ashuú Jisɔs meko aké, “Nlɔ mambélé mabɛ́ yina mako, ndegecha gelaá?” ");
INSERT INTO anvNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Jisɔs ajɔɔ́ ne ji aké, “Mbɔge ɔkelege mambɛ chó, gɛ́ genó ɛyi gélaá, chó kpoó yɛ́ndégenó ɛyigé ɔwyaá, ɔchyɛɛ́ ŋka yimbɔ mbá ubya bɔɔ́, ne ɔbɛɛ́ nyɛ ne gefwa né mfaánebuú. Ɔpyɛgé mbɔ, ɔchwɔ́ ɔkwɔlé me ndɛre maá utɔɔ́ wa.” ");
INSERT INTO anvNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Mende yina awugé ndɛre Jisɔs ajɔɔ́, alyaá afɛ́ meshwɛmeshwɛ ne mesómé néndé ji awyaá gefwa dɔɔ́. ");
INSERT INTO anvNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Ne Jisɔs ajɔɔ́ ne baá utɔɔ́ bií aké, “Ngárege ɛnyú wáwálé nnó ɛjwerége ne muú ŋka akpɛ né gefwagé Ɛsɔwɔ.” ");
INSERT INTO anvNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Mmage gare ɛnyú nnó ɛlú wáwá nnó mpɔ mashwɔne áshwá né ɛmbú ábyamé ne nnó muú ŋka akpɛ né gefwagé Ɛsɔwɔ ágbárege. ");
INSERT INTO anvNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Baá utɔɔ́ bií áwúgé mbɔ matyɛ mawa ɛbwɔ́ meno ne agige atɛ aké, “Ne ndé muú yi abɔ nyɛ́ geŋwá ɛyi gélágé byɛɛ́?” ");
INSERT INTO anvNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Jisɔs apɛ ɛbwɔ́ domeé ajɔɔ́ ne ɛbwɔ́ aké, “Ákwaá ákágé pyɛ fɔ́ ufɔɔ́ unó bina, yɛ́mbɔ Ɛsɔwɔ akage pyɛ unó uko.” ");
INSERT INTO anvNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Pita ashuú yɛ ji meko aké, “Gɛ́ ɛsé delyaá unó sé uko dékwɔlege wɔ. Ndé nsá ayi ɛsé débɔɔ́ nyɛ?” ");
INSERT INTO anvNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Jisɔs ajɔɔ́ ne ɛbwɔ́ aké, “Ngarege ɛnyú wáwálé nnó, ɛnyú abi dékwɔle me dejwɔlege nyɛ́ ntó ndɛre afwa mampáné depɔ né matoó áfyáneápeá ayi bɔɔ́ Isrɛli gébégé Maá Ntɛ Mekwaá ajwɔlégé né geluɔ mamgbare gefwa jií né mme mekɛ. ");
INSERT INTO anvNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Ne yɛ́mbɔ muú ayi alyaá upú, áŋmɛ́, ntɛ ne mmá, yɛ́ baá yɛ́ lé makɔɔ́ gétúgé alu menkwɔlé wa, abɛɛ́ nyɛ ne bɔɔ́ ne gejamégé unó bi upwɔ amu. Ne Ɛsɔwɔ achyɛge nyɛ ji geŋwá ɛyi gélágé byɛɛ́. ");
INSERT INTO anvNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Yɛ́mbɔ gejamégé bɔɔ́ abi álú mbɔ mbɛ nana, meso gébé álaá nyɛ meso ne gejamé abi álu mbɔ meso nana ábɛɛ́ nyɛ mbɛ.” ");
INSERT INTO anvNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Jisɔs ama ajɔɔ́ aké, “Gefwa ɛyigé Ɛsɔwɔ ágbárege gelú ɛké nekanémejɔɔ́ ɛnina. Bií uma mende fɔ afɛ́ ntone gesé dondo ajyɛ kɛlé bɔɔ́ abi ájyɛɛ́ pyɛ utɔɔ́ né mmu mekɔɔ́ wuú. ");
INSERT INTO anvNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Ajyɛge, bɔɔ́ abi ji abɔɔ́ mbɛ ágɛne ákame nnó ji achyɛge yɛ́ndémuú ɛbwɔ́ meno ŋka ɛwé yɛ́ndémuú anyɛɛ́ mɛ́ né bií uma ne agare yɛ́ ɛbwɔ́ nnó ajyɛ alɔ utɔɔ́. ");
INSERT INTO anvNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Káláŋká ɛneéneama ɛkwɔ́négé ama jyɛɛ́ dafyɛ agɛ bɔɔ́ abifɔ átɛne wyɛ detú né ntóné gese. ");
INSERT INTO anvNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Ajɔɔ́ ne ɛbwɔ́ aké, ‘Ɛnyú ntó chogé depyɛ utɔɔ́ né mmu mekɔɔ́ wa. Nchyɛge nyɛ ɛnyú genó ɛyi gepyɛɛ́ matɔɔ́ ágɔɔ́ ɛnyú.’ ");
INSERT INTO anvNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Abimbɔ áfɛ́ manjyɛɛ́ lɔ utɔɔ́. Mbɔ́ɔ mekɔɔ́ yimbɔ apyɛɛ́ wyɛmbɔ né metɔɔ́ ŋwɔ́mésé. Né káláŋká ɛlɛɛ́ ama jyɛ́ pyɛ wyɛmbɔ. ");
INSERT INTO anvNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Genógé káláŋká ɛta né nkwale mende yimbɔ ama jyɛ né gese, ama gɛ́ bɔɔ́ átɛné wyɛ ɛfɛɛ́ detu. Agií ɛbwɔ́ aké, ‘Ɛnyú dechɔɔ́ bií bina detu, ɛlɔ mbɔ?’ ");
INSERT INTO anvNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Áshuú ji meko áké, ‘Muú fɔ ákuú ɛsé nnó depyɛ utɔɔ́ wɔ́.’ Aké ne ɛbwɔ́, ‘Ɛnyú ntó choge depyɛ utɔɔ́ né mekɔɔ́ wa.’ ");
INSERT INTO anvNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Nkwale akwɔnégé mbɔɔ́ mekɔɔ́ yimbɔ ajɔɔ́ ne mempɛlé bɔɔ́ utɔɔ́ bií aké, ‘Kuú ampyɛɛ́ utɔɔ́ bimbɔ ako áchwɔ́ ne ɔchyɛɛ́ yɛ́ndémuú ŋka jií. Bɔmbɛ chyɛ bɔɔ́ utɔɔ́ abi álaá meso, ne abi abɔ mbɛ chyɛ ɛbwɔ́ kwyakwya.’ ");
INSERT INTO anvNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Ne bɔɔ́ abi ábɔ́ áchwɔ́ né káláŋká ɛta né nkwale anyɛ́ wyɛ meno ŋka ɛma ne abi áchwɔɔ́ tɛ dondo. ");
INSERT INTO anvNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Abi ábɔ́ mbɛ áchwɔ́ge áfɛre nnó ɛbwɔ́ ányɛɛ́ nyɛ ŋka dɔɔ́ ápwɔ́ abifɔ, yɛ́mbɔ ɛbwɔ́ ntó ányɛ́ wyɛ ŋka janja. ");
INSERT INTO anvNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Ndɛre ɛbwɔ́ ásɛle ŋka ɛyimbɔ álɔ maŋménégé áshuúlege mbɔɔ́ mekɔɔ́ ndo, ");
INSERT INTO anvNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","ajɔ́ge aké, ‘bɔɔ́ abi ɔsɛle ɛbwɔ́ kwyakwya apyɛ utɔɔ́ lé né nchwanekɛ ama yɛ́mbɔ ɔchyɛɛ́ ɛbwɔ́ meno ŋka wyɛ ndɛre ɛsé abi dégɛne ɛfwyale depyɛɛ́ utɔɔ́ bií kpógele né mmu gebábálégé ŋmɛɛ́!’ ");
INSERT INTO anvNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Yɛ́mbɔ mbɔɔ́ mekɔɔ́ ashuú muú bwɔ́ ama meko aké, ‘Mejée wa me mfwale fɔ́ wɔ, wɔ́. Ɔkame mansɛ ŋka ndɛre yɛ́ndémuú anyɛɛ́ mɛ́ né bií uma, ɛpɔ mbɔ? ");
INSERT INTO anvNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Sɛ ŋka jyɛɛ́ wulege, membɔɔ́ ne nke nchyɛge muú utɔɔ́ ayi kwyakwya wyɛ ndɛre nchyɛɛ́ wɔ́. ");
INSERT INTO anvNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Nnó nlu gyɛɛ́ mampyɛ genó ɛyigé nkɛlege mampyɛ ne ŋka ya?’ Wa metɔɔ́ ɛsɔɔ́ wɔ́ ɛle nlu muú ayi nchyɛge ɛchyɛ?” ");
INSERT INTO anvNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Jisɔs anɛrege ajɔɔ́ yɛ aké, “Bɔɔ́ abi aŋea mbɔ gemɛ fina akwene nyɛ mbya né meso gébé ne abi alu mbɔ mbya fina aŋeage nyɛ gemɛ né meso gébé.” ");
INSERT INTO anvNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Ndɛre bɔ Jisɔs ákwɔme ájyɛɛ́ né Jɛrosalɛ, asɛ baá utɔɔ́ bií áfyaneápeá ɛbwɔ́ átɛné babá. ");
INSERT INTO anvNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","Ajɔɔ́ ne ɛbwɔ́ aké, “Wuúge, ɛsé dékwɔme mbɔ déjyɛɛ́ né Jɛrosalɛ, ɛwu, áfyɛɛ́ nyɛ Maá Ntɛ Mekwaá né amú anɔɔ́ baá ampyɛɛ́ upɛ Ɛsɔwɔ ne ánlɛré mabɛ́ Ɛsɔwɔ. Ɛbwɔ́ ajɔ́gé nyɛ nnó, me nkwɛ mpa, áwá me. ");
INSERT INTO anvNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Ne áfyɛɛ́ nyɛ ji né amú bɔɔ́ abi álá pɔ́ bɔɔ́ Jus. Ɛbwɔ́ ájwyaáge nyɛ ji, átulege nyɛ ji ne utó ne áwɔme nyɛ ji né gekwa agboó. Yɛ́mbɔ, ndɔ́ ɛ́lɛɛ́ ɛ́kwɔnégé Ɛsɔwɔ apyɛɛ́ nyɛ ji akwilé né negbo.” ");
INSERT INTO anvNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Wyɛ né gébé ɛyigémbɔ, mendée Sɛbɛdee afɛ́ mbaá Jisɔs ne baá bií ande ápeá, ató mano né mbɛ ushu wuú, agií Jisɔs nnó apoó ji. ");
INSERT INTO anvNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Jisɔs agí ji aké, “Ɔkɛ́lege ndé?” Ashuú ji meko aké, “Nkɛ́lege nnó, né meso gébé ɔjwɔlégé ɔke ɔgbarege gefwa jyɛɛ́ ɔpyɛ baá ba bina apea ájwɔle ntó ne wɔ né malu ɛnoge, ama né ɛgbe ɛbwɔnyɛ wyɛ ne ayifɔ né ɛgbɛ ɛbwɔbɛ wyɛ.” ");
INSERT INTO anvNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Ne Jisɔs ajɔɔ́ ne ɛbwɔ́ aké, “Ɛnyú dekage genó ɛyigé degígé mbɔ. Nnó ɛnyú dekage nyú nyɛ ŋkɔ ɛfwyale ayi me nyuú nyɛ?” Áké, “Ɛ ɛ́, ɛsé dekage.” ");
INSERT INTO anvNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Ákamege mbɔ, Jisɔs ajɔɔ́ ne ɛbwɔ́ aké, “Nkame wáwálé nnó ɛnyú dékágé gɛ́ nyɛ ɛfwyale nkane me ngɛne nyɛ, yɛ́mbɔ me fɔ́ njyaá bɔɔ́ bi ájwɔlege né ɛbwɔnyɛ wa ne abi ajwɔlege né ɛbwɔbɛ wɔ́. Malu yimbɔ alú ɛlé ayi bɔɔ́ abi Ntɛ wa ajyaá mɛ nnó ajwɔlé wyɛ.” ");
INSERT INTO anvNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Ne baá utɔɔ́ Jisɔs abi makpo áfya, áwúgé genó ɛyigé abi ápeá ápyɛ, matɔɔ́ ásɔ́ ɛbwɔ́ dɔɔ́. ");
INSERT INTO anvNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Ne Jisɔs akuú baá utɔɔ́ bií ako ajɔɔ́ ne ɛbwɔ́ aké, “Ɛnyú dekaá nnó afwa mme abi álá pɔ́ bɔɔ́ Jus ásɛlé utó bwɔ́ ápyɛɛ́ yɛ́ndégenó ɛyi géjií ɛbwɔ́ metɔɔ́ ne bɔɔ́ bwɔ́ ne yɛ́ ákpakpa melɔ áwyaá utó bi ajɔ́ge mechɔ́ ne bɔɔ́ bwɔ́ ɛ́byɛ́. ");
INSERT INTO anvNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Ne ɛ́bɛ́gé fɔ́ mbɔ ne ɛnyú. Yɛ́ndémuú nyú ayi akɛ́lege mambɛ muú kpaá abɔ́ mambɛ ménkpané defwɛ́ nyú; ");
INSERT INTO anvNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","yɛ́ndémuú nyú ayi ákɛ́lege mambɛ menɔmbɛ abɔ mambɛ́ ɛké mefwɛ́ nyú. ");
INSERT INTO anvNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Wyɛ nkane Maá Ntɛ Mekwaá, ji achwɔ́ɔ fɔ́ nnó bɔɔ́ ákpá ji defwɛ́ wɔ́, achwɔ́ lé mánkpá bɔɔ́ defwɛ́ nnó achyɛ gemɛ jií mawené gejámégé bɔɔ́ né gabo.” ");
INSERT INTO anvNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Jisɔs ne baá utɔɔ́ bií ályage Jɛriko, gejamégé bɔɔ́ ákwɔlé ɛbwɔ́. ");
INSERT INTO anvNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Wyɛ né gébé ɛyigémbɔ, ande fɔ amɛ nónómé apea abɔ ájwɔ́lé né mapea meti. Nkane bɔɔ́ ájɔɔ́gé nnó Jisɔs ale koó ande bimbɔ ábɛge áke, “Ata, Mpyáne Dɛvid gɛ́ ɛsé meshwɛ!” ");
INSERT INTO anvNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Bɔɔ́ bimbɔ ányá ɛbwɔ́ áke, “Kwɛnege nyáme”, yɛ́mbɔ ábɛɛ́ lé bɛɛ́ge ne ɛshyɛ áke, “Ata, Mpyáne Dɛvid, gɛ́ ɛse meshwɛ.” ");
INSERT INTO anvNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Jisɔs awúgé mbɔ atɛné, akuú yɛ bɔɔ́ amɛ nónómé bimbɔ apea ágií ɛbwɔ́ aké, “Ndé genó dekɛlege me mpyɛ ɛta ɛnyú?” ");
INSERT INTO anvNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Áshuú ji meko áke, “Ata, dékɛlege nnó ɔpyɛ ɛsé dégɛne mbaá!” ");
INSERT INTO anvNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Meshwɛ akwɔ́ Jisɔs metɔɔ́ getúge bwɔ́ ne ata amɛ bwɔ́. Tɛ́nétɛ́né yimbɔ álɔ mángɛ́né mbaá ne ákwɔlege ji. ");
INSERT INTO anvNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Ndɛre Jisɔs ne baá utɔɔ́ bií álɛ́ kwɔ́kwɔ́lé ne Jɛrosalɛ, ákwɔnégé Bɛtfage melɔ ɛwé ɛlu né mfaá Mékwɛ́ Olif. Jisɔs áfere baá utɔɔ́ bií makpo ápeá atɔ́ nnó ábɔ́ mbɛ. ");
INSERT INTO anvNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Ndɛre atɔme ɛbwɔ́, ajɔɔ́ aké, “Chogé né maá melɔ ayi alu mbɔ ɛnyú né mbɛ, tɛ́nétɛ́né dégɛne nyɛ maá géjuŋá ɛyigé áshií ne maá wuú ne ɛgbɛ mmyɛ. Kaáge dechwɔ́ me ne ubi. ");
INSERT INTO anvNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Ne mbɔgé muú agigé ɛnyú ula bi dekage geji, garege ji nnó, ‘Ata ne akɛ́lege ubi.’ Tɛnétɛné yimbɔ, alyágé ɛnyú dechwɔ́ ne ubi.” ");
INSERT INTO anvNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Ɛwéna ɛpyɛmbɔ nnó ɛbɛ wáwálé ndɛre muú ɛkpávé Ɛsɔwɔ abɔ ajɔɔ́ nnó, ");
INSERT INTO anvNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Gare bɔɔ́ Sayɔn nnó, Gɛge mfwa nyú, apɔ ne nepa, ajwɔ́lé mfaá géjuŋá achwɔɔ́ ne maá mbyɛne géjuŋá.” ");
INSERT INTO anvNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Baá utɔɔ́ bimbɔ ájyɛ́gé ápyɛ wyɛ ndɛre Jisɔs agare ɛbwɔ́. ");
INSERT INTO anvNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Áchwɔ́gé ne géjuŋá yimbɔ ne maá ɛtá Jisɔs, áfere mandeé bwɔ́ ágyaá ubi meso ne Jisɔs akwɔ ajwɔlé mfaá. ");
INSERT INTO anvNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Ne gejamégé bɔɔ́ abi álu ɛfɛɛ́ ágyaáge mandée bwɔ́ né meti. Ábifɔ ásɔ́rege uwɔ́ mámɛ́ ágyaáge ntó né meti nnó Jisɔs akoó mfaá. ");
INSERT INTO anvNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Gejamégé bɔɔ́ ájyɛɛ́ mbɛ abifɔ ákwɔ́lege meso ne Jisɔs alu metɔɔ́ metɔɔ. Ɛbwɔ́ ako álɔ mankálégé áke, “Matame mábɛ́ ne mpyáne Dɛvid! Mejé ɛbɛ́ ne muú ayi achwɔɔ́ né mabɔ Ata. Matame mábɛ́ ne Ɛsɔwɔ muú alu né mfaánebuú ɛniné mfaá mfaá!” ");
INSERT INTO anvNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Wyɛ ndɛre Jisɔs akpɛné né Jɛrosalɛ, melɔ meko ɛnyigé tegétegé ne bɔɔ́ álɔ mangígé áké, “Acha muú ayi achwɔɔ́ mbɔ waá yɛ?” ");
INSERT INTO anvNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Ne gejamégé bɔɔ́ abi akɛne ne Jisɔs ashuú meko áké, “Ɛlé Jisɔs muú ɛkpávé Ɛsɔwɔ ayi atané né melɔ Nasɛrɛt né gebagé mewaá Galilií.” ");
INSERT INTO anvNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Ne Jisɔs akpɛ́gé né melɔ Jɛrosalɛ akpɛ né mmu dachi ɛcha upɛ Ɛsɔwɔ, abú bɔɔ́ bi ákpóo ne abi áname unó. Atyá makpókpógélé bɔɔ́ abi ákɛne gesegé maŋka mankwɔré ne malu ujwɔ́lé bɔɔ́ ako abi ákpóo upwine melɔ ɛbi ápyɛ upɛ Ɛsɔwɔ ne ubi. ");
INSERT INTO anvNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Ndɛre Jisɔs apyɛmbɔ, agare ɛbwɔ́ aké, “Ása né mmu ŋwɛ Ɛsɔwɔ nnó, Ɛsɔwɔ aké, ‘Gepú ya ɛyíge bɔɔ́ áchómege wyɛ mamfɛɛ́ me ákuú nyɛ geji nnó gepúgé mmyɛmenɛne.’ Yɛ́mbɔ ɛnyú débwɔlé géjí gelá melu ɛwé ánjó ábige wyɛɛ́!” ");
INSERT INTO anvNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Ndɛre ji alú né mmu ɛcha upɛ Ɛsɔwɔ, bɔɔ́ amɛ nónómé ne abi ubwire áfɛ́ ɛta wuú. Apyɛ ɛbwɔ́ ako átoó. ");
INSERT INTO anvNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Ánɔɔ́ baá ampyɛɛ́ upɛ Ɛsɔwɔ ne ɛkwɔ anlɛre mabɛ Ɛsɔwɔ ágɛ́ ukpɛ́kpɛ́ unó bi Jisɔs apyɛ́ɛ ne áwú ntó ndɛre baá melɔ ákalege né mmu ɛcha upɛ Ɛsɔwɔ, nnó matame mábɛ́ ne mpyáne Dɛvid. Áwugé mbɔ matɔɔ́ ásɔ́ ɛbwɔ́. ");
INSERT INTO anvNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Ágí Jisɔs áke, “Ɔwuú mbɔ genó ɛyigé baá melɔ ájɔ́ge?” Jisɔs ashuú ɛbwɔ́ meko aké, “Ɛɛh nwu, nnó ɛnyú délu daŋkú genó ɛyigé asame né mmu ŋwɛ Ɛsɔwɔ? Ásá wyɛ nnó; ‘Ɔlɛré baá melɔ ne abi álu maka amu ndɛre áfɛ́ɛge wɔ’.” ");
INSERT INTO anvNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Jisɔs ajɔ́ge mbɔ alyá ɛbwɔ́ afɛ́ né melɔ Bɛtani ajyɛ bɛle ɛwu. ");
INSERT INTO anvNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Bií ujyágé, dondo gemua mme, ndɛre Jisɔs abɔɔ́ mankeré meso né Jɛrosalɛ, akwɔ́négé meti mesa alɔ mamyɛ ji. ");
INSERT INTO anvNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Agɛ́ genɔɔ́ ɛyigé akuú nnó fig né ɛgbɛ́ meti. Afɛ́ wyɛ nnó waá agɛne umpomé fɔ́ wyɛɛ́, yɛ́mbɔ yɛɛ́ géma agɛ wɔ ɛkosé bya ubíubí. Jisɔs ajɔɔ́ ne genɔɔ́ ɛyigémbɔ aké, “Tɛ mme abyɛɛ́, wɔ ɔmagé wɔ́ɔ sé umpomé.” Tɛ́nétɛ́né yimbɔ genɔ ɛyigémbɔ gewaŋésé gégbó. ");
INSERT INTO anvNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Ne baá utɔɔ́ Jisɔs ágɛ́gé mbɔ ála mano mekpo fuú, ágíge atɛ aké, “Genɔgé fig ɛyigé na gégbó mbɔ wáwá ndé?” ");
INSERT INTO anvNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Ne Jisɔs ashuú ɛbwɔ́ meko aké, “Ngarege ɛnyú wáwálé nnó, mbɔgé ɛnyú defyɛgé matɔɔ́ ne Ɛsɔwɔ ne déla pɔ́ ne dembyɔ né ɛshyɛ ɛwe ji awyaá, dépyɛ nyɛ unó nkane me mpyɛɛ́ mbɔ ne genɔge fig, yɛ́ ɛbɛ́ lé ɛbi upwɔɔ́ bina dépyɛ nyɛ ubi. Dékage jɔɔ́ yɛ́ ɛbɛ́ lé ne mékwɛ́ ɛwéna nnó, ‘Táné fa ɔjyɛ́ ɔkwɛ́ né mmu ɛbɛɛ́ mega’, Ɛsɔwɔ apyɛ wyɛ nkane ɛnyú déjɔɔ́. ");
INSERT INTO anvNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Mbɔgé défyɛgé matɔɔ́ nyú ne Ɛsɔwɔ ne dégíge yɛ́ndégenó né mmyɛmenɛne achyɛge nyɛ ɛnyú geji.” ");
INSERT INTO anvNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Jisɔs akeré né mmu ɛcha upɛ Ɛsɔwɔ, akpɛ́gé mmu alɔ manlɛré bɔɔ́ mekomejɔɔ́ Ɛsɔwɔ. Ndɛre alɛ́rege anɔɔ́ baá abi ápyɛɛ́ upɛ Ɛsɔwɔ ne ákpakpa melɔ áchwɔɔ́ báne ji, ágií ji áke, “Ndé uto ɛbi ɔwyaá mampyɛ unó bina? Waá achyɛɛ́ wɔ uto ubi?” ");
INSERT INTO anvNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Jisɔs ashuú ɛbwɔ́ meko aké, “Me ntó nwyaá awa nkwɛ́ mangií ɛnyú, deshúgé me meko me ngarége ɛnyú uto ɛbi me nwyaá ne mpyɛɛ́ unó bina. ");
INSERT INTO anvNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Waá achyɛ Jɔn uto manwyaá bɔɔ́ manaá Ɛsɔwɔ, Ɛsɔwɔ waá akwaá?” Jisɔs ágiígé mbɔ álɔ manyɛ́ge mbeé ne atɛ áké, “Dejɔ́gé mbɔ nyɛ nnó? Ɛ́bɛge dejɔɔ́gé nnó ɛlé Ɛsɔwɔ ne achyɛɛ́ Jɔn uto bi, agige nyɛ ɛsé aké, ‘Ulannó ne delá kamé mekomejɔɔ́ wuú wɔ́?’ ");
INSERT INTO anvNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Yɛ́mbɔ mbɔgé déjɔ́ge nnó ‘Ákwaá ne áchyɛ’ ɛbyɛ́nnó dekɛlege bɔɔ́ bina mpa. Nendé, yɛ́ndémuú abɔ́ akaá nnó Jɔn alu muú ɛkpávé Ɛsɔwɔ wáwálé.” ");
INSERT INTO anvNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Ɛpyɛ ɛbwɔ́ áshú lé Jisɔs meko áké, “Ɛsé dékaá fɔ́ muú ayi achyɛɛ́ Jɔn uto wɔ́.” Ne Jisɔs ashuú ntó ɛbwɔ́ meko aké, “Yɛ́ me ntó ngárégé fɔ́ ɛnyú muú yi achyɛ́ me uto ne mpyɛ́ unó bina.” ");
INSERT INTO anvNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Ne Jisɔs aké, “Ɛnyú défɛré mbɔ nnó ne mechɔ́ ɛwéna? Mende fɔ abɔ́ alu, awyaá baá ande makpó apea. Bií uma ákuú ayi mbɛ, ajɔɔ́ ne ji aké, ‘chó pyɛ utɔɔ́ ne mekɔɔ́ fina.’ ");
INSERT INTO anvNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Ne maá yimbɔ ashuú ji meko aké, ‘Njyɛɛ́ fɔ́’ yɛ́mbɔ ɛwyáge akwɔré metɔɔ́ wuú afɛ́. ");
INSERT INTO anvNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Mende yimbɔ afɛ mbaá ayifɔ ajɔɔ́ wyɛmbɔ ne ji. Ajɔ́gé mbɔ maá yimbɔ akamé aké, ‘Ata njyɛ.’ Yɛ́mbɔ ajyɛɛ́ ji wɔ́. ");
INSERT INTO anvNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Jisɔs ajɔ́gé mbɔ, aké, gárege me, né baá bina makpo apea, ayi ndé áwuú meko ntɛ wuú?” Áshuú ji meko áké, “Ɛlé ayi mbɛ” Ɛfɛɛ́ mbɔ Jisɔs agaré ɛbwɔ́ áké, “Mengarege ɛnyú wáwálé nnó bɔɔ́ abi álú bɔɔ́ abo nkane ansɛlé ŋka makpo ne andée ɛno, ábɔɔ́ nyɛ mbɛ agɛ meti wáwá mamkpɛ né gefwa ɛyigé Ɛsɔwɔ ágbárege ápwɔ ɛnyú abifɔ. ");
INSERT INTO anvNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Néndé Jɔn menwyaá bɔɔ́ manaá Ɛsɔwɔ achwɔ́ nya ɛta nyú bɔɔ́ Isrɛli ako alɛré ɛnyú ndɛre muú abɔɔ́ mambelé geŋwá jií ndɛre Ɛsɔwɔ akɛlege, ne ɛnyú dekamé meko wuú wɔ́; yɛ́mbɔ ansɛlé ŋka makpo ne andée ɛno ne ákamé meko wuú. Ne yɛɛ́ gébégé ɛnyú dégɛné mbɔ na, ɛnyú deti fɔ meso ne gabo nyú dekamé meko wuú wɔ́.” ");
INSERT INTO anvNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Jisɔs ama ajɔɔ́ aké, “Wuúge nekanémejɔɔ́ ɛniné fɔ́”, “Muú fɔ awyaá nya mekɔɔ́ wuú, apɛ unɔɔ́ ɛbi ákuú vine, ásɛle umpome bií mampyɛ mmɔɔ́, anɔ gebame agyaá ɛwú mme, achó ɛmbu akwyɛɛ́ ɛwú cháŋéné nnó áké áŋámege umpome ɛbimbɔ manaá makpɛ́né wyɛ. Atɛne ntó maá ɛnyɔŋ nnó membamé mekɔɔ́ ajwɔ́légé wyɛ. Asɛ bɔɔ́ uségé afyɛ́ wyɛ. Apyɛ́gé mbɔ, atané afɛ́ nekɛ né melɔ fɔ. ");
INSERT INTO anvNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Gébé gekwɔ́négé ɛyigé akyɛɛ́ umpome vine ɛbimbɔ mbɔɔ́ mekɔɔ́ atɔ baá defwɛ́ bií nnó ájyɛ ásɛ ɛbií umpome vine mbaá bɔɔ́ uségé bimbɔ. ");
INSERT INTO anvNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Baá defwɛ́ bimbɔ akwɔ́négé né mekɔɔ́, bɔɔ́ uségé ágbaré ɛbwɔ́, átulé ama, áwá ama, ne átó ayifɔ ne mataá. ");
INSERT INTO anvNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Ápyɛ́gé mbɔ, mbɔɔ́ mekɔɔ́ yimbɔ ama tɔ́ baá defwɛ́ abifɔ, abi ajamé apwɔɔ́ abi mbɛmbɛ. Ne bɔɔ́ uségé bimbɔ ápyɛ ne baá defwɛ́ bimbɔ wyɛ nkane ápyɛ ne abi mbɛ. ");
INSERT INTO anvNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Ne kwyakwya, achwɔ́ fére maá wuú atɔ́, ajɔɔ́ aké, ‘Ágɛgé nyɛ maá wa membɔɔ́ yɛ́ ɛbɛ́ nnó áchyɛge nyɛ ji ɛ́nógé.’ ");
INSERT INTO anvNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Yɛ́mbɔ bɔɔ́ uségé bimbɔ, ágɛ́gé maá awuú nkane achwɔ́ɔ, ájɔɔ́ ne atɛ áké, ‘Gɛ́ge menyɛɛ́ geteé mbɔɔ́ mekɔɔ́ na, chwɔ́ge déwá ji, ji ne alú muú ayi anyɛɛ́ nyɛ geteégé mekɔɔ́ ɛwéna, chwɔ́ge dewá denyɛ́ geteé jií!’ ");
INSERT INTO anvNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Ápyɛgé ji áfomé meso gébámé áwá. ");
INSERT INTO anvNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","“Jisɔs anérégé mantó nekanémejɔɔ́ ɛniné na, agií ákpakpa bɔɔ́ Jus abi ji agarege ɛbwɔ́ makamejɔɔ́ ayina aké, défɛré nnó mbɔɔ́ mekɔɔ́ yimbɔ akerégé meso né nekɛ nií, apyɛ nyɛ nnó ne bɔɔ́ uségé bimbɔ?” ");
INSERT INTO anvNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Áshuú ji meko áké, “Akerégé meso, apyɛ nyɛ bɔɔ́ nchyɛ bimbɔ ágbo negbo nebo. Achyɛɛ́ mekɔɔ́ ɛwémbɔ mbaá bɔɔ́ uségé abi cha, abi áchyɛge nyɛ ji ɛbí umpome vine yɛ́ndé gébégé mbwɛ.” ");
INSERT INTO anvNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Ájɔ́gé mbɔ, Jisɔs agií ɛbwɔ́ aké, “Nnó ɛnyú délú daŋkú genó ɛyige ásamé né mmu ŋwɛ Ɛsɔwɔ? Ása wyɛ nnó, ‘Ntaá ɛniné antɛné upú ashyaá nnó nélɔ́mé, néni ne nélaá menɔ ntaá ayi ágbaré ɛkwɔ gepú. Ata ne apyɛ nnó ɛwú ɛbɛ mbɔ, ne ɛlu gekpɛkpɛ genó né amɛ se!’ ");
INSERT INTO anvNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“Ndɛre ɛlúmbɔ, me ngarege ɛnyú wáwálé nnó, ɛnyú débɛɛ́ nyɛ sé bɔɔ́ bi Ɛsɔwɔ ágbárege gefwa ne ɛnyú, ala gbaré nyɛ lé ne bɔɔ́ abi ákwɔre matɔɔ́ bwɔ́ ákwane mambɛ bɔɔ́ gefwage Ɛsɔwɔ.” ");
INSERT INTO anvNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Ne yɛ́ndémuú ayi akwene mfaá ntaá ɛníne na, akɔrege nyɛ, yɛ́ndémuú ntó ayi ntaá ɛnína nekwene ji mmyɛ nechɔgéré ji yilé yilé. ");
INSERT INTO anvNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Anɔɔ́ baá abi apyɛ upɛ Ɛsɔwɔ ne bɔɔ́ Farasi áwuúgé ndɛre Jisɔs atomé maka mejɔɔ́ yimbɔ, ákaá nnó ájɔge mbɔ lé ne ɛbwɔ́. ");
INSERT INTO anvNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Ákɛlé meti mampyɛ ji, yɛ́mbɔ áfɔ́ɔ nyá gejamégé bɔɔ́ abi álú ɛfɛɛ́, néndé yɛ́ndémuú ásɛ Jisɔs nnó alu muú ɛkpávé Ɛsɔwɔ. ");
INSERT INTO anvNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Ne Jisɔs ama tó ɛbwɔ́ nekanemejɔɔ́ ɛniné fɔ aké, ");
INSERT INTO anvNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Gefwa ɛyigé Ɛsɔwɔ ágbárege gélú ɛké nekanémejɔɔ́ ɛniné na. Mfwa fɔ akpomé mmyɛ mampyɛ ɛpaá nebane maá wuú ayi mende. ");
INSERT INTO anvNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Mfwa yimbɔ anérégé, atɔ́ baá defwɛ bií nnó ájyɛ ákú bɔɔ́ abi ji agaré mɛ́ nnó achwɔ́ ɛpaá ɛlɔ, yɛ́mbɔ yɛ muú ama achwɔ́ wɔ́. ");
INSERT INTO anvNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Mfwa yimbɔ ama kéré atɔ́ baá defwɛ́ abi fɔ́ aké, ‘chóge dégáré bɔɔ́ abi me mbɔ nlɔɔ́ nnó nwá mpɔ mabɔ, ntyɛɛ́ ɛbwɔ́ menyɛɛ́ melɔ́mélɔ́, nkwyɛɛ́ yɛ́ndégenó. Áchwɔ́ wáwá, áwyagé ɛpaá ɛchwɔɔ́ ɛlɔ!’ ");
INSERT INTO anvNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Yɛ́mbɔ bɔɔ́ bimbɔ ásɛ yɛ́ ɛwémbɔ ɛké genó wɔ́. Áfɛ́ ápyɛ lé depɔ debwɔ́ ɛtiré cháchá. Abifɔ áfɛ́ makɔɔ́ bwɔ́, abifɔ áfɛ́ ne upú use bwɔ́. ");
INSERT INTO anvNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Ne abifɔ ágbaré baá defwɛ mfwa átulé ɛbwɔ́ ɛke menya, áwá. ");
INSERT INTO anvNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Ápyɛgémbɔ, metɔɔ́ ɛsɔ́ mfwa yimbɔ, atɔ́ bɔɔ́ bee bií ájyɛ wá bɔɔ́ abi áwané mbɔ baá défwɛ bií, ne ásɔ ntó melɔ bwɔ́. ");
INSERT INTO anvNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Ne agaré yɛ́ baá defwɛ́ bií aké, ‘Ɛpaá wa ɛchwɔɔ́ lɔ, ne bɔɔ́ abi me nɛne álɛre nnó ákwane fɔ́ mambɛ́ bɔɔ́ abi áchwɔɔ́ ɛpaá wa wɔ́. ");
INSERT INTO anvNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Chóge né mati mako, kuúge yɛ́ndémuú ayi dégɛ́ne nnó áchwɔ́ ɛpaá.’ ");
INSERT INTO anvNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Ne baá defwɛ́ bií mbɔ áfɛ́ ápyɛ́ɛ wyɛ nkane ji ajɔɔ́. Ákuú yɛ́ndémuú ayi ɛbwɔ́ ágɛné, abi aboabo ne abi álɔ́álɔ́ achwɔ́. Kpaá tɛ gepúgé neba gegbeé ne bɔɔ́. ");
INSERT INTO anvNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Ne gébégé mfwa yimbɔ akpené mmu mangɛ́ bɔɔ́ abi anɛné ɛbwɔ́ ɛpaá, agɛ́ mende fɔ ama ayi ala fyɛ ndée neba ɛyi ɛkwané mbaá ɛpaá ɛwémbɔ wɔ́. ");
INSERT INTO anvNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Agií ji aké, ‘Mejeé wa, wɔ ɔpyɛɛ́ nnó ne ɔkpɛné fa ne ndée ɛyi ɛla ɛkwané mbaá ɛpaá ɛwéna wɔ́?’ Ne mende yimbɔ ala bɔmbɔ. ");
INSERT INTO anvNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Ɛpyɛ mfwa agaré bɔɔ́ abi ánɛne aŋkɛɛ́ né ɛpaá aké, ‘pyɛ́ge ji déwɛ́ uka ne amu, debwɛɛ́ ji défómé dafyɛ né melu ɛwé empinya gemua ɛlu wyɛ. Ɛfɛɛ́ mbɔ ne bɔɔ́ álilí nyɛ ányɛɛ́ maŋɛ́ne.’” ");
INSERT INTO anvNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Jisɔs anérégé mantó nekanémejɔɔ́ ɛníné na, aké, “Ɛsɔwɔ akúu gejamégé bɔɔ́ yɛ́mbɔ abi ji ajyaá jaá wɔ́.” ");
INSERT INTO anvNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Ɛwya yɛ́ wɔ́, bɔɔ́ ɛkwɔ Farasi fɔ́ abi awuú genó ɛyigé Jisɔs ajɔ́gé, atane ájyɛɛ́ gbáre geju ákɛ́lege meti ɛwé ɛbwɔ́ ápyɛ ne Jisɔs akwe nekwené meno. ");
INSERT INTO anvNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Ɛbwɔ́ ako ákamé meko ama, átɔ́ baá utɔɔ́ bwɔ́ choncho ne bɔɔ́ ɛkwɔ́ Hɛrɔd, nnó ájyɛ ágií Jisɔs nkwɛ́. Ájyɛ́gé áké, “Ménlɛré, ɛsé dékaá nnó wɔ ɔlu muú ayi ɔjɔ́gé wáwálé, ne ɔlɛrege bɔɔ́ unó ndɛre Ɛsɔwɔ akɛ́lege wáwálé, ɔfɔɔ́ fɔ́ amɛ bɔɔ́ néndé, ɔsɛ́lé fɔ nnó muú ayifɔ́, aŋea gemɛ apwɔ ayifɔ. ");
INSERT INTO anvNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Nnó ɛsé delú chó manchyɛgé ŋkámakpo mbaá mfwa Rom waá déchyɛ́gé fɔ? Garé ɛsé genó ɛyigé wɔ ɔfɛre nnó gelú chó.” ");
INSERT INTO anvNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Yɛ́mbɔ Jisɔs akaá ufɛ́ré uboubo ɛbi úlú ɛbwɔ́ metɔɔ́. Ne ɛpyɛ ji aké ɛnyú bɔɔ́ dembwɔle bina, “Ndé ɛnyú dépɛ́nege me mataá? ");
INSERT INTO anvNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Lɛrege me gefɔgé ŋka ɛyi dechyɛge ŋkámakpo.” Álɛré ji, asɛ agbaré. ");
INSERT INTO anvNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Agií ɛbwɔ́ aké, “Mekpo wá na, ne mabɔ waá na ásamé né ŋka ɛyi?” ");
INSERT INTO anvNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Áshuú ji meko áké, “Ɛ́lé mekpo mfwa Rom ne mabɔ mií.” Ɛfɛɛ́ ne Jisɔs agaré ɛbwɔ́ aké, “Chyɛɛ́ge yɛ́ mfwa Rom genó ɛyi gélú ɛjií. Ne chyɛge ntó Ɛsɔwɔ genó ɛyi gélú ɛyi Ɛsɔwɔ.” ");
INSERT INTO anvNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Áwuúgé meko ayi Jisɔs ashuú ɛbwɔ́ byɔ uwɔ ɛbwɔ́ mmu ályaá ji áfɛ́. ");
INSERT INTO anvNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Wyɛ né bií bimbɔ, bɔɔ́ ɛkwɔ Sadusi fɔ́ áchwɔ́ mangií Jisɔs mechɔ́. Ɛbwɔ́ abi na álu bɔɔ́ abi ákame nya nnó muú agbogé, akwilége sé né negbo. Ágií ji áké, ");
INSERT INTO anvNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Ménlɛré, ɛbɛ́ Mosis ɛké mbɔgé muú abagé mendée ne agboge ayi ála pɔ́ ne maá, meŋmo áwuú abɔ́ mansɛ mendée yimbɔ ukwi nnó ábyɛ́gé baá ábɛ́ lé né mabɔ ami mewené meŋmo yimbɔ. ");
INSERT INTO anvNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Ɛbɔ́ ɛpyɛ nyá nnó, áŋmó fɔ ákénéama abi ande álú. Ayi mbɛ abá mendée, agboó alya ji yɛ́ maá apɔ́, ayi akwɔlege asɛ mendée yimbɔ ukwi, ");
INSERT INTO anvNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","meŋmo yimbɔ ntó agbo yɛ́ maá abyɛɛ́ ne mendée yimbɔ wɔ́. Wyɛmbɔ ne ɛpyɛ ne ayi agbeé makpo alɛɛ́ kpaá tɛ ɛbwɔ́ ákénéama ágbó ako. ");
INSERT INTO anvNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Kwyakwya, mendée yimbɔ ntó agbó.” ");
INSERT INTO anvNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Ndɛre ɛlúmbɔ, ágií Jisɔs áké, “Ɛlé mendée yina abané mbɔ ɛbwɔ́ ako, gébé ɛyigé Ɛsɔwɔ apyɛ nyɛ bɔɔ́ ákwilégé né negbo, mendée yina abɛɛ́ nyɛ ayi waá?” ");
INSERT INTO anvNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Jisɔs ashuú ɛbwɔ́ meko aké, “Ɛnyú délu gyɛɛ́ dɔɔ́ né nkwɛ́ ayi dégií, nénde dékágé fɔ́ mekomejɔɔ́ Ɛsɔwɔ ne utó bií. ");
INSERT INTO anvNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Débɔ́ mankaá nnó, gébégé Ɛsɔwɔ apyɛgé bɔɔ́ ákwilégé né negbo, ábáné fɔ́ neba ne átuú fɔ andeé neba, ábɛɛ́ ɛké makiɛ́nné Ɛsɔwɔ né mfaánebuú. ");
INSERT INTO anvNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Ne gétúgé mechɔ bɔɔ́ abi ágboó meso gébé Ɛsɔwɔ apyɛ nyɛ ɛbwɔ́ ákwilé né negbo, nnó délú dankú genó ɛyigé Ɛsɔwɔ ajɔɔ́ atome ne ukwene antɛ abi agboó mɛ? Ajɔɔ́ aké, ");
INSERT INTO anvNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Me nlu Ɛsɔwɔ ayi Abraham, ne ayi Asek ne ayi Jakɔb ánógé.’ Ɛwéna ɛlɛ́ré nnó Ɛsɔwɔ apyɛ bɔɔ́ ákwilégé né negbo néndé ji apɔ́ fɔ́ Ɛsɔwɔ awuú bɔɔ́ alu ayi bɔɔ́ abi álú abɛ.” ");
INSERT INTO anvNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Gejamégé bɔɔ́ abi álu ɛfɛɛ́ áwúge ndɛre ji ajɔɔ́ mbɔ, byɔ uwɔ ɛbwɔ́ mmu né gefɔɔ́ ɛyígé Jisɔs alɛ́rege unó. ");
INSERT INTO anvNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Bɔɔ́ ɛkwɔ Farasi áwuúgé nnó genó ɛyigé Jisɔs ajɔɔ́ ne bɔɔ́ Sadusi gépyɛ mano ágbɛ bɔɔ́ ɛkwɔ́ Sadusi, ágbaré geju mankɛlé meti ɛwéchá nnó ágií Jisɔs nkwɛ. ");
INSERT INTO anvNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Ne muú bwɔ́ áma ayi ákaá mabɛ Mosis dɔɔ́, áfɛ́ mamua Jisɔs. ");
INSERT INTO anvNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","Agií ji nkwɛ́ áké, “Ménlɛré, ndé ɛbɛ́ Mosis ɛwe ɛŋeá ɛpwɔɔ́ mabɛ jií mako?” ");
INSERT INTO anvNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Jisɔs ashuú ɛbwɔ́ meko aké, “Ɛbɛ́ ɛwé ɛŋeá ɛpwɔɔ́ mabɛ Mosis ako ɛlé ɛwé ɛjɔɔ́ nnó, ‘Gbógé ne Ata Ɛsɔwɔ wyɛɛ́ ne metɔɔ́ wyɛɛ́ meko, ne mendoó wyɛɛ́ meko ne ufɛ́ré byɛɛ́ uko.’ ");
INSERT INTO anvNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Gɛ menɔ ɛbɛ́ ayi aŋeá apwɔɔ́ mabɛ́ mako. ");
INSERT INTO anvNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ne ɛbɛ́ ɛwé ɛma kwɔ́le ɛlu wyɛ ɛké ɛwé mbɛ ne ɛjɔɔ́ ɛké, ‘gbógé ne ntɛ méŋmɛ́ wyɛɛ́ ndɛre ɔgboó ne gemɛ jyɛɛ́.’ ");
INSERT INTO anvNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Mabɛ́ ayi na apeá ne ágbaré yɛ́ndégenó, ɛyigé Ɛsɔwɔ akɛlege nnó bɔɔ́ ápyɛ ndɛre Mosis ne bɔɔ́ ɛkpávé Ɛsɔwɔ ásamé.” ");
INSERT INTO anvNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Ndɛre bɔɔ́ ɛkwɔ Farasi álú melu ɛma ne Jisɔs, agií ɛbwɔ́ nkwɛ́ áké, ");
INSERT INTO anvNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Ɛnyú defɛré nnó ne Kras, Muú yi Ɛsɔwɔ akweré ji ɛlá gefwa, ji alu maá waá?” Áshuú ji meko áké, “Alu mpyáne mfwa Dɛvid.” ");
INSERT INTO anvNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Ájɔɔ́ge mbɔ Jisɔs agií ɛbwɔ́ aké, “Mbɔgé ji alu mpyáne Dɛvid, ɛpyɛ nnó ne Mendoó Ukpea ɛpyɛɛ́ nyá mfwa Dɛvid akuú ji nnó Ata? Néndé aké, ");
INSERT INTO anvNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Ata Ɛsɔwɔ ajɔɔ́ ne Ata wa aké, jwɔlé fa né ɛgbɛ́ ɛbwɔnyɛ wa né geluɔ́ge ɛ́nógé kpaá tɛ mpyɛɛ́ bɔɔ́ mawámé byɛɛ́ álaá ɛké mboó genɔɔ́ ayi ɔnɛ́rege uká byɛɛ́ mfaá.’ ");
INSERT INTO anvNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Ne mbɔgé Dɛvid akuú Muú yi Ɛsɔwɔ akweré ji ɛlá gefwa nnó Ata, ɛpyɛɛ́mbɔ nnó ne ji amáge bɛ́ mpyáne wuú?” ");
INSERT INTO anvNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Agíge mbɔ, yɛ́ muu ama ayi akáge shuú ji meko apɔ́. Ɛlɔ né gébé ɛyigémbɔ, ɔjyɛ́ mbɛ, yɛ́ muú ayi ama mua mangií ji nkwɛ́ apɔ́. ");
INSERT INTO anvNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Ne Jisɔs ajɔɔ́ ne gejamégé bɔɔ́ bi álu ɛfɛɛ́ chóncho ne baá utɔɔ́ bií aké, ");
INSERT INTO anvNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Anlɛré mabɛ Ɛsɔwɔ ne bɔɔ́ ɛkwɔ Farasi ne abɔɔ́ manlɛré mabɛ́ Ɛsɔwɔ. ");
INSERT INTO anvNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Gétú ɛyígé na, débɔ́ mankwɔ́légé ne mampyɛ́gé yɛ́ndégenó ɛyigé ɛbwɔ́ álɛ́rege cháŋéné. Yɛ́mbɔ, ɛnyú dékwɔlégé fɔ́ gepɔge bwɔ́, néndé álɛrege mabɛ Ɛsɔwɔ ayi ɛbwɔ́ ámbɔɔ́ álá nógé áji. ");
INSERT INTO anvNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Áwɛ́le matuú ayi ánɔɔ́ ánɛ́rege bɔɔ́ né makpo, yɛ́mbɔ átárégé fɔ yɛɛ́ ɛbwɔ bwɔ́ nnó ápoó ɛbwɔ́ ákpá áji. ");
INSERT INTO anvNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Ápyɛɛ́ lé depɔré Ɛsɔwɔ deko nnó bɔɔ́ ágɛ́, áfɛɛ́gé ɛbwɔ́. Pɛɛ́ge yɛ́ ndɛre ɛbwɔ́ ápyɛ unó bi ásamé mekomejɔɔ́ Ɛsɔwɔ né mmu uŋeage ne áwɛlé né mampwɛ́ ne uloó amu bwɔ́. Áfyɛɛ́ ntó bɔ nku abi áwyaá machagele matyɛɛ́ matyɛ né mano. ");
INSERT INTO anvNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Ɛbwɔ́ ágbóo manjyágé uluɔ́ ɛ́nógé né mapaá ne áma ájyaá ntó malu alɔ́ alɔ́ né mmu macha mmyɛmenɛne ájwɔ́lege wyɛ. ");
INSERT INTO anvNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Ɛbwɔ́ ágbóo ntó nnó bɔɔ́ átámégé ɛbwɔ́ ne ɛ́nógé, ne ájyɛge né machomelé ákɛlege ntó nnó bɔɔ́ ákúgé ɛbwɔ́ nnó, ‘Anlɛré.’ ");
INSERT INTO anvNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Yɛ́mbɔ ɛkagé muú nyú fɔ akamé nnó ákuú ji nnó, ‘Ménlɛré,’ néndé ɛnyú déwyaá ɛlé menlɛré ama ne ɛnyú ako delu aŋmɛ. ");
INSERT INTO anvNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Ne dékúgé ntó muú fa mme nnó, ‘Ntɛ́’, nyú néndé déwya lé Ntɛ ama muú alu né mfaánebuú. ");
INSERT INTO anvNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Ne dékamégé ntó ákuú muú nyú nnó, ‘Ata’, néndé déwya lé Ata ama. Ata yimbɔ ɛlé Kras, Muú yi Ɛsɔwɔ akweré ji ɛlá gefwa. ");
INSERT INTO anvNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Muú ayi ábɛɛ́ muú kpaá né geluágé nyú, abɔ́ mambɛ́ lé menkpané defwɛ́ nyú. ");
INSERT INTO anvNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Yɛ́ndémuú ayi ábwɛge gemɛ jií, Ɛsɔwɔ awáne nyɛ ji gelu. Ne yɛ́ndémuú ayi asɛle mmyɛ ji nnó apɔ́ yɛɛ́ muú fɔ́, Ɛsɔwɔ apyɛ nyɛ ji akwɔ ŋgɔ́. ");
INSERT INTO anvNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Ne Jisɔs afɛ́ mbɛ manjɔ́ge aké, “Ɛfwyale ɛwé ɛgile ɛnyú anlɛré mabɛ́ Ɛsɔwɔ ne ɛnyú ɛkwɔ bɔɔ́ Farasi ɛjame nyɛ dɔɔ́. Ɛnyú délú bɔɔ́ démbwɔ́lé, nénde unó bi ɛnyú dépyɛɛ́, dégbɛɛ́ bɔɔ́ nnó ákpɛgé fɔ́ né gefwa ɛyigé Ɛsɔwɔ ágbárege. Ɛnyú ambɔɔ́ dékpɛné fɔ́ né geji ne délyágé fɔ meti nnó bɔɔ́ abi amuame makpɛ wyɛ ákpɛ. ");
INSERT INTO anvNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Ɛfwyale ɛwé ɛgile ɛnyú anlɛré mabɛ́ Ɛsɔwɔ ne ɛnyú ɛkwɔ bɔɔ́ Farasi ɛjame nyɛ dɔɔ́. Ɛnyú délú bɔɔ́ dembwɔlé, néndé ɛnyú denyɛɛ́ akwi andée upwɔɔ́ né unó bwɔ́ ɛnyú depyɛɛ́ ɛké delú cho né mbɛ ushu Ɛsɔwɔ, depyɛɛ́ mmyɛmenɛne nyú ɛ́shyaá né mbɛ ushu bɔɔ́. Né meso gébé ɛfwyale ɛwé Ɛsɔwɔ achyɛge nyɛ ɛnyú ɛjame nyɛ dɔɔ́. ");
INSERT INTO anvNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Ɛfwyale ɛwé ɛgile ɛnyú anlɛré mabɛ́ Ɛsɔwɔ ne ɛnyú ɛkwɔ́ bɔɔ́ Farasi ɛjame nyɛ dɔɔ́. Ɛnyú délu bɔɔ́ dembwɔle, néndé dékɛne déjyɛ yɛ́ndé mbaá nnó dépyɛ yɛ́ muú ama ayi álá kwɔlege Ɛsɔwɔ, akwɔlege ji. Ne muú akamege nnó akwɔlege Ɛsɔwɔ, depyɛ ji ákwɔre álá ɛlé muú ayi agɛ́ne nyɛ ɛfwyale dɔɔ́ né ntoné mewɛ apwɔɔ́ ɛnyú ambɔɔ́. ");
INSERT INTO anvNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Ɛfwyale ɛwé ɛgile ɛnyú ɛjame nyɛ dɔɔ́. Ɛnyú délu ɛké bɔɔ́ amɛ nónómé abi ájame atɛ meti. Ɛnyú délɛrege bɔɔ́ nnó, ‘Mbɔgé muú ányɛ́gémeno akelégé ɛcha upɛ Ɛsɔwɔ nnó apyɛ genó ne ála apyɛ wɔ́, ɛwémbɔ ɛpɔ́ yɛɛ́ genó. Yɛ́mbɔ mbɔgé muú akelégé unó bi ákwyɛ ne gesege ŋka ɛbi úlú né mmu ɛcha upɛ Ɛsɔwɔ nnó apyɛ genó, abɔ mampyɛ genó ɛyigé ji anyɛ́meno.’ ");
INSERT INTO anvNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Ɛnyú ukeŋkéne bɔɔ́ amɛ nónómé, ɛnyú défɛré nnó ndé genó geŋeá na dɔɔ́ gepwɔ? Genó ɛyi gélú mmu ɛcha upɛ Ɛsɔwɔ, waá ɛcha upɛ Ɛsɔwɔ ɛwé ɛpyɛɛ́ nnó genó ɛyi gélú mmu gébɛ́ ne ukpea né mbɛ ushu Ɛsɔwɔ? ");
INSERT INTO anvNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","‘Ɛnyú dema delɛrege nnó muú anyɛgémeno akelege geluɔ́ ɛyigé apyɛ́ɛ upɛ Ɛsɔwɔ wyɛ nnó apyɛ genó ne ala apyɛ geji wɔ́, genó gefɔ́ gepyɛɛ́ ji. Yɛ́mbɔ mbɔgé genó ɛyigé ji achyɛɛ́ nnó ápyɛ gepɛ né mfaá geluɔ́ ne ji akelé, abɔ́ mampyɛ genó ɛyigé ji anyɛ́meno nnó apyɛ.’ ");
INSERT INTO anvNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Ɛnyú bɔɔ́ amɛ nónómé, ɛnyú defɛré nnó ndé genó géŋeá na gepwɔ? Ɛchyɛ ɛwé ɛlú mfaá geluɔ́ ɛyigé ápyɛ́ɛ upɛ wyɛ waá, geluɔ́ ɛyigé ápyɛ gepɛ́ɛ ɛyigémbɔ ne gélú ne ukpea né mbɛ ushu Ɛsɔwɔ? ");
INSERT INTO anvNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Yɛ́mbɔ muú akelégé geluɔ́ ɛyigé apyɛɛ́ upɛ Ɛsɔwɔ wyɛ, akelé fɔ́ lé geluɔ́ ɛyigémbɔ gejigeji wɔ́. Akelé ntó yɛ́ndégenó ɛyi gélú né mfaá geluɔ́ ɛyígémbɔ. ");
INSERT INTO anvNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Ne yɛ́ndémuú ayi akelégé ɛcha upɛ Ɛsɔwɔ akelé ntó chóncho ne Ɛsɔwɔ muú ajwɔ́lége mmu ɛwu. ");
INSERT INTO anvNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Muú ayi akelége mfaánebuú akelé ntó geluɔ́ ɛyigé Ɛsɔwɔ ajwɔ́lége wyɛ chóncho ne Ɛsɔwɔ muú ajwɔ́lege mfaá geji. ");
INSERT INTO anvNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Ɛfwyale ɛwé ɛgile ɛnyú anlɛré mabɛ́ Ɛsɔwɔ ne ɛnyú ɛkwɔ́ bɔɔ́ Farasi ɛjame nyɛ dɔɔ́. Ɛnyú délu bɔɔ́ dembwɔ́lé, Ɛnyú dekarege menyɛɛ́ ayi dékpáne né makɔɔ́ nyú dékaré malú afya, déchyɛ Ɛsɔwɔ melú ɛma, yɛ́ ne utɔŋse ɛbí upyɛ́ɛ menyɛɛ́ agɔɔ́ gebɛ́. Yɛ́mbɔ delyage mampyɛ ukpɛ́kpɛ́ unó bi mabɛ́ Ɛsɔwɔ álɛrege nnó dépyɛge. Depɔ́ fɔ́ pópó ne atɛ aŋmɛ, dégɛ́né fɔ́ ɛbwɔ́ meshwɛ ne défyɛɛ́ fɔ́ matɔɔ́ ne Ɛsɔwɔ wɔ́. Pyɛge ukpɛ́kpɛ́ unó bina. Yɛ́mbɔ délyage fɔ́ manchyɛ ɛchyɛ ɛwé ɛnyú debɔ dechyɛge mɛ. ");
INSERT INTO anvNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Ndɛre demmyɛ mambele ukɛkɛ mabɛ debyaá ayi kpakpa, delu bɔɔ́ amɛ nónómé abi ájame abifɔ meti. Delu ɛké muú ayi áchɛ́rege manaá ami ji anyúu nnó ɛkagé ámé gejenchi, yɛ́mbɔ áméne mpɔ mashwɔne. ");
INSERT INTO anvNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Ɛfwyale ɛwé ɛgile ɛnyú anlɛré mabɛ́ Ɛsɔwɔ ne ɛnyú ɛkwɔ bɔɔ́ Farasi ɛjame nyɛ dɔɔ́. Néndé gepɔge nyú gélu ɛké muú ayi ashwɔnege meso amo ne uchwɛri menyɛ́ pópó, yɛ́mbɔ né mmu, abelege unó bi ji abɔɔ́ né mati mabomabo. Dépyɛ́ unó nnó bɔɔ́ áfɛ́régé nnó ɛnyú délu cho né mbɛ ushu Ɛsɔwɔ, yɛ́mbɔ matɔɔ́ nyú agbeé ne maŋwaá ne mmwɔ́lé unó unyɛɛ́. ");
INSERT INTO anvNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Ɛnyú ɛkwɔ́ Farasi délú bɔɔ́ amɛ nónómé, bɔge mbɛ déshwɔ́né mmu amo ne uchwɛri menyɛ́, depyɛgé mbɔ meso ntó akpeage nyɛ. ");
INSERT INTO anvNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Ɛfwyale ɛwé ɛgile ɛnyú anlɛré mabɛ́ Ɛsɔwɔ ne ɛnyú bɔɔ́ ɛkwɔ́ Farasi ɛjame nyɛ dɔɔ́. Ɛnyú délu bɔɔ́ dembwɔ́lé, néndé ɛnyú délu ɛké manomé ayi áwaá mbɔmé né mfaá. Ɔgɛgé áji, álu malɔ́málɔ́ né dafyɛ, yɛ́mbɔ né mmu ágbeé ne ugoó áwuú bɔɔ́ ne ufɔɔ́ufɔɔ́ umpwapwáne unó. ");
INSERT INTO anvNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Wyɛmbɔ ntó ne ɛnyú depyɛ wéna né dafyɛ nnó bɔɔ́ áfɛ́régé nnó ɛnyú delu cho né mbɛ ushu Ɛsɔwɔ, yɛ́mbɔ wáwálé alu nnó né mmu matɔɔ́ nyú ɛnyú delu bɔɔ́ dembwɔ́lé, ne degbóo mampyɛ́gé nchyɛ. ");
INSERT INTO anvNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Ɛfwyale ɛwé ɛgile ɛnyú anlɛré mabɛ́ Ɛsɔwɔ ne ɛnyú ɛkwɔ́ bɔɔ́ Farasi ɛjame nyɛ dɔɔ́. Ɛnyú bɔɔ́ dembwɔ́lé, dékwyɛge manómé bɔɔ́ ɛkpávé Ɛsɔwɔ ne ayi bɔɔ́ abi álu cho né mbɛ ushu Ɛsɔwɔ, ");
INSERT INTO anvNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","dejɔge deké, ‘Ɛsé débɔ́ débɛ́ nyá gébégé ukwene antɛ sé mbɔ debɔ́ décho fɔ́ amu manwá bɔɔ́ ɛkpávé Ɛsɔwɔ bimbɔ wɔ́.’ ");
INSERT INTO anvNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Ndɛre ɛnyú dejɔ́gé ne ukwene antɛ se mbɔ, ɛlɛré nnó ɛnyú délu upyáné bɔɔ́ abi áwané bɔɔ́ ɛkpávé Ɛsɔwɔ bimbɔ. ");
INSERT INTO anvNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Chóge yɛ́ mbɛ, dénéré mampyɛ gabo ayi nyá ukwene antɛ nyú álɔɔ́ ula mampyɛ. ");
INSERT INTO anvNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Ɛnyú mmyɔ, délú baá utɔɔ́, défɛ́ré nnó dékáge bó ɛfwyale ɛwé ɛkpane nyɛ ɛnyú dékpɛ né ntoné mewɛ ɛwé ɛlá nómégé? ");
INSERT INTO anvNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Ne gétú ɛyígé na, ntɔme nyɛ ɛnyú bɔɔ́ ɛkpávé Ɛsɔwɔ, bɔɔ́ déŋga ne anlɛré mabɛ́ Ɛsɔwɔ. Déwane nyɛ abifɔ, ne déwɔmé nyɛ abifɔ né gekwa, ágbó, détulege nyɛ abifɔ ne utó né mmu macha mmyɛmenɛne nyú ne déma déchyɛge nyɛ abifɔ ɛfwyale né malɔ́málɔ́. ");
INSERT INTO anvNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Ndɛre ɛnyú dépyɛmbɔ, gewu ɛyigé ukwene antɛ nyú áwané nyá bɔɔ́ abi álu cho né mbɛ ushu Ɛsɔwɔ fa né mme gékpɛ́ne nyɛ ɛnyú mmyɛ gelɔɔ́ ula ne manoó Ɛbɛl muú alú cho né mbɛ ushu Ɛsɔwɔ kpaá gekwɔné né ami Sakariya maá Barakia ayi ɛnyú déwané nya né metɔɔ́ metɔɔ́ ɛcha upɛ né geluɔ́ ɛyigé ápyɛ́ɛ upɛ Ɛsɔwɔ wyɛ. ");
INSERT INTO anvNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Me ngarege ɛnyú wáwálé nnó gewú ɛyigé ukwene antɛ nyú áwané nyá bɔɔ́ abi álu cho né mbɛ ushu Ɛsɔwɔ gélú ɛnyú bɔɔ́ njyɛ́ ɛniné na mmyɛ.” ");
INSERT INTO anvNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Jisɔs ajɔɔ́ge mbɔ aké, “Ɛ ɛ́, bɔɔ́ Jɛrosalɛ! Bɔɔ́ Jɛrosalɛ! Ɛnyú dewane bɔɔ́ ɛkpávé Ɛsɔwɔ ne detome abifɔ ne mataá, bɔɔ́ dentɔɔ́ abi Ɛsɔwɔ atɔmé ɛta nyú! Mmua mɛ́ ndɔndɔ ne ndɔ manyweré ɛnyú nkwere nkane mekwɔ akwérege baá bií, yɛ́mbɔ ɛnyú dékɛ́légé fɔ́. ");
INSERT INTO anvNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Gɛ́ge yɛ́ nnó, melɔ nyú ɛ́la mɛ́ mábɔ́mé, ɛ́la mewa. ");
INSERT INTO anvNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Néndé ngarege ɛnyú nnó, ɛlɔ fina ɛjyɛ́gé mbɛ, ɛnyú démágé gɛ́sé me kpaá tɛ bií ɛbi ɛnyú dejɔ́ge nyɛ nnó, ‘Mejé ɛ́bɛ́ ne muú ayi achwɔ́ɔ né mabɔ Atá.’” ");
INSERT INTO anvNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Jisɔs ajɔɔ́gé mbɔ, alyaá ɛcha upɛ Ɛsɔwɔ. Ndɛre ji ajyɛɛ́ baá utɔɔ́ bií ákɛ áfií ji nnó álɛre ji upú ɛbí átɛné né mmu dachi ɛcha upɛ Ɛsɔwɔ. ");
INSERT INTO anvNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Yɛ́mbɔ Jisɔs ashuú ɛbwɔ́ meko aké, “Pɔ ɛnyú dégɛ mbɔ uchánchá upú bina uko? Ngarege ɛnyú wáwálé nnó ámuú nyɛ ubi uko kpá, tɛ́ ne mataá ne mataá yɛɛ́ ntaá némaá ɛni nélaá nyɛ mfaá ntɛ népɔ́.” ");
INSERT INTO anvNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Ɛwyágé Jisɔs ajyɛ jwɔ́le né mfaá Mékwɛ Olif. Baá utɔɔ́ bií ɛbwɔ́ ɛbwɔ́ ájyɛ́ bane ji, ágií ji áké, “Garé ɛsé, nde gébé ɛyige depɔ tiré na depyɛ́ nyɛ? Ne ndé ufɔɔ́ unó upyɛ nyɛ ne ɛsé dékaá gébé ɛyigé wɔ ɔchwɔ́ ne gébé ɛyigé mme ábyɛɛ́?” ");
INSERT INTO anvNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Ágígé mbɔ, Jisɔs ashuú ɛbwɔ́ meko aké, “Sɛ́ge gébé nnó ɛkagé muú fɔ ábwɔ́lé ɛnyú dénó mewaá. ");
INSERT INTO anvNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Nénde, gejamégé bɔɔ́ ásɛ́le nyɛ mabɔ ma áchwɔ́ ɛta nyú. Adoó nyɛ ɛbwɔ ɛwɔ́mé ájɔ́ɔge áké, ‘Me ne nlú Kras, Muú yi Ɛsɔwɔ akweré ji ɛlá gefwa.’ Ápyɛ nyɛ mbɔ ábwɔlé gejamégé bɔɔ́ ánó mewaá. ");
INSERT INTO anvNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Ne déwuú nyɛ ntó abya be kwɔ́kwɔ́lé ne ɛnyú, ne ɛbi ámmyɛ tɛtɛ. Yɛ́mbɔ gébégé unó bina uké upyɛɛ́, débɛgé fɔ́ ne ɛfɔ. Néndé unó bina ubɔ mampyɛ ne ɛpɔ́fɔ́ nnó mme yina achwɔ kwya wɔ́. ");
INSERT INTO anvNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Gébé ɛyigémbɔ ntó malɔ kpakpa ámmyɛ nyɛ ne atɛ ne atɛ afwa ne bɔɔ́ bwɔ́ ámmyɛ nyɛ ne atɛ, ɛmímí mesa ɛkwene nyɛ malumalu. Mme yina anyíge nyɛ́ ne ɛshyɛ abwɔlé né gejamégé malu. ");
INSERT INTO anvNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Ɛwéna ɛbɛ́ nyɛ ɛké lé ula ulɔ ubalé bi mendée awúu gébégé nebyɛ neké nemmyɛ ji. ");
INSERT INTO anvNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Gébé ɛyígémbɔ ápyɛ́ne nyɛ ɛnyú áfyɛ́ né amu bɔɔ́ abi áchyɛge ɛnyú ɛfwyale ne áwáne nyɛ ɛnyú. Malɔ mme meko ápaá nyɛ ɛnyú gétúgé délú áŋkwɔlé ba. ");
INSERT INTO anvNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Ɛwéna ɛpyɛ́ɛ nyɛ gejamégé bɔɔ́ ája mmyɛ meso, áferé metɔɔ́ ɛwé áfyɛɛ́ ne Ɛsɔwɔ, áchyɛge nyɛ atɛ maŋkwaá ne ápaá nyɛ ntó atɛ. ");
INSERT INTO anvNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","“Ne gejamégé bɔɔ́ ɛkpávé Ɛsɔwɔ abi gebyɔ́ áchwɔɔ́ nyɛ, ábwɔlé gejamégé bɔɔ́ ánó mewaá. ");
INSERT INTO anvNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Ne gétúgé nchyɛ ayi bɔɔ́ ápyɛ ájame nyɛ dɔɔ́, gejeé ɛyigé bɔɔ́ abɔɔ́ gebɛ nyɛ sé dɔɔ́. ");
INSERT INTO anvNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Yɛ́mbɔ yɛ́ndémuú ayi akogé metɔɔ́ tɛ kwyakwyaá áférege nyɛ ji né ɛfwyale gabo.” ");
INSERT INTO anvNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Abya melɔ́mélɔ́ yina, ayi Ɛsɔwɔ ágbárege nyɛ gefwa ne bɔɔ́ bií, aŋkwɔle ba agarege mɛ ji mbaá bɔɔ́ mme meko nnó malɔ mako né mme ákaá ji, gébé ɛyigémbɔ ne mme akwyage nyɛ. ");
INSERT INTO anvNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Danɛl muú ɛkpávé Ɛsɔwɔ abɔ́ ajɔɔ́ nya atoó ne ‘geboboge genó ɛyi gechyɛge mekpo unɔɔ́ mbaá Ɛsɔwɔ.’ Degɛne nyɛ ndɛre genó ɛyigémbɔ gepyɛɛ́ né mmu ɛcha upɛ Ɛsɔwɔ.” (Yɛ́ndémuú ayi akuú malɔ ŋwɛ ayina akaá ula). ");
INSERT INTO anvNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","“Gébé ɛyigémbɔ, bɔɔ́ abi álu né Judiya ábó ájyɛ ákwɔ́ mfaá makwɛ ábií. ");
INSERT INTO anvNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Yɛɛ́ muú ayi alú mfaá gepú ɛkagé akyaá nnó ashulege mme, ajyɛ bɔ́ genó né mmu gepú jií. ");
INSERT INTO anvNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Muú ayi alú ntó né mekɔɔ́ áchɔgé yɛ́ gébé nnó akere mmú achwɔɔ́ bɔ nku gefwene wuú ne ábó. ");
INSERT INTO anvNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Ɛ ɛ́ ɛbɛ́ɛ nyɛ mbɔ nnó ne andeé abi álú ne manɛ yɛ́ ne abi áchyɛ́ge baá mámbɛ. ");
INSERT INTO anvNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Nɛɛ́ge mmyɛ mbaá Ɛsɔwɔ nnó gébé gebo ɛyigémbɔ, gébɛgé fɔ́ ne metɔɔ́ nshwɔne. Yɛ́ ɛbɛ́ lé bií uwyaá. ");
INSERT INTO anvNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Néndé gébé ɛyigémbɔ, gebɛ́ɛ nyɛ lé gébégé gekpɛ́kpɛ́gé ɛfwyale ɛwé tɛ́ Ɛsɔwɔ akwyɛ mme yina bɔɔ́ álá álu daŋgɛ́ ɛwú. Ne yɛ́ ɛwé ɛmage bɛ sé ɛké ɛwémbɔ ɛpɔ́. ");
INSERT INTO anvNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Ne wáwálé alu nnó mbɔgé Ɛsɔwɔ ala asɔɔ́ ndɔ ɛfwyale ɛyimbɔ ɛla mboó wɔ́, ɛbyɛ́nnó yɛɛ́ muú ayi apome nyɛ apɔ́. Yɛ́mbɔ gétúgé bɔɔ́ abi Ɛsɔwɔ ájyaá nnó ábɛ́ abií, asɔrege nyɛ ndɔ ɛyimbɔ ɛla mboó. ");
INSERT INTO anvNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Ne mbɔgé muú agaré ɛnyú nnó, ‘Gɛ́ge Kras, Muú yi Ɛsɔwɔ akweré ji ɛlá gefwa alu fana,’ yɛɛ́ agaré lé ɛnyú nnó, ‘Alu né’, dékamégé fɔ́ ne ji. ");
INSERT INTO anvNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Néndé bɔɔ́ gebyɔ abi áké álu Kras ne bɔɔ́ gebyɔ abi ake alu bɔɔ́ ɛkpávé Ɛsɔwɔ ntó áchwɔɔ́ nyɛ. Áchwɔgé ápyɛɛ́ nyɛ ukpɛ́kpɛ́ ufélekpá ɛbi upwɔ amu. Ápyɛmbɔ nnó ábwɔ́lé bɔɔ́ ako ne mbɔgé meti ɛbɛge yɛ́ ɛbɛ́lé bɔɔ́ abi Ɛsɔwɔ ajyaá nnó ábɛ́ abií, ábwɔlé ɛbwɔ́ ánó mewaá. ");
INSERT INTO anvNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Kaáge yɛ́ nnó mbɔ́ mɛ́ mbɛ ngaré ɛnyú unó bina, gemɛ́gé nnó upyɛ́gé. ");
INSERT INTO anvNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Yɛ́ muú achwɔɔ́ agaré ɛnyú nnó, ‘Gɛ́ge ji alu mbɔ né mewaá’, déjyɛgé wyɛ. Yɛ́ agaré lé nnó, ‘Gɛ́ge abií mbɔ né mmu baá upú’, dékamégé fɔ́ nnó ɛlú wáwálé. ");
INSERT INTO anvNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Néndé ndɛre dasama akɛ́le mamma, ne nebuú négɛ́nege, álɔ ne ɛgbɛ́ ɛbwɔnyɛ akwɔné ne ɛbwɔbɛ bɔɔ́ ako ágɛ́ne, wyɛmbɔ ntó ne Maá Ntɛ Mekwaá achwɔɔ́ nyɛ. ");
INSERT INTO anvNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","“Yɛ́ndé mbaá ayi geŋkwɔ́gé genó gebɛɛ́, ɛfɛɛ́ mbɔ ne denwyɔne ɛtire denyɛɛ́ uŋkwɔ unó dénwérege.” ");
INSERT INTO anvNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Ɛfwyale ɛwéna ɛchwɔgé, tɛ́nétɛ́né ayi ɛbyɛɛ́, ŋmɛɛ́ ɛkwene nyɛ gemuagemua. Mfaá ágɛ́négé sé, ambe ntó ánómege nyɛ, ne unó bi uwyaá uto né mfaánebuú unyíge nyɛ. ");
INSERT INTO anvNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Gébé ɛyigémbɔ genó ɛyi gelɛ́re nnó Maá Ntɛ Mekwaá achwɔɔ́, gegɛ́negé nyɛ né mfaánebuú. Ne bɔɔ́ malɔ mme meko áfyɛ́ɛ nyɛ gepúgé negbo álíle. Ne ágɛ́ne nyɛ nkane Maá Ntɛ Mekwaá achwɔɔ́ né mmu gekó ne uto bií, ne gekpɛ́kpɛ́gé ɛ́nógé. ");
INSERT INTO anvNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Ndɛre ji achwɔɔ́ áfɔmege nyɛ gekpɛ́kpɛ́ mbá, ne atɔme nyɛ makiɛ́nné jií nnó ájyɛ́ anyweré bɔɔ́ abi ji ájyaá né mme meko ábɛ́ abií mbaá ama. ");
INSERT INTO anvNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Pɛge gepɔge genɔɔ́ge fig degí genó wyɛ. Gébégé mata jií álɔgé mántó bya ukɛ ɛnyú dekaá nnó nshwɔné achwɔ shúle. ");
INSERT INTO anvNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Wyɛ́mbɔ ntó ne gébégé ɛnyú dégɛ́gé unó bina uko uke upyɛɛ́, débɔ́ mankaá nnó gébé ɛyígémbɔ géla kwɔ́kwɔ́lé. ");
INSERT INTO anvNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Ngarege ɛnyú wáwálé nnó njyɛ ɛníné na négboó fɔ́ kpaá tɛ unó bina ukó úpyɛɛ́. ");
INSERT INTO anvNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Mfaá ne mme ábyɛɛ́ nyɛ, yɛ́mbɔ mekomejɔɔ́ wa alaá tɛ kwyakwya. ");
INSERT INTO anvNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Yɛ́ muú ayi ákaá bií ne gébé ɛyígé unó bina úpyɛ́ɛ nyɛ apɔ́. Makiɛ́nné Ɛsɔwɔ ne mfaánebuú ákaágé fɔ́, yɛ́ Maá Ɛsɔwɔ jimbɔɔ́ ákaá wɔ́. Ɛkosé wyɛ Ntɛ wuú ji mbií ne ákaá. ");
INSERT INTO anvNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Ndɛre ɛpyɛɛ́ nyá né gébégé Nowa, wyɛ́mbɔ ntó ne ɛpyɛ́ nyɛ́ gébégé Maá Ntɛ Mekwaá aké akerege meso fa mme. ");
INSERT INTO anvNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Ne gébé ɛyigémbɔ, gemɛ́gé nnó genyagé nnyi geshwa nyá bɔɔ́, bɔɔ́ abɔ́ ányɛ́, ányuú, ápyɛɛ́ maba ne átuú baá né maba. Ányɛ́ kpaá tɛ bií bi Nowa ákpɛné mmu ɛ́kpe. ");
INSERT INTO anvNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Ndɛre apyɛmbɔ, abɔ ákaá nya genó ɛyi gepyɛ wɔ́, kpaá tɛ genyage nnyi geshwané ɛbwɔ́ ako. Wyɛ́mbɔ ntó ne ɛpyɛ́ nyɛ gébégé Maá Ntɛ Mekwaá akérege meso fá mme. ");
INSERT INTO anvNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Né gébé ɛyigémbɔ ntó, ande apea ábɛgé ne mekɔɔ́ aké apyɛ utɔɔ́, Maá Ntɛ Mekwaá akpane nyɛ ama alyaá ama. ");
INSERT INTO anvNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Andée apea ábɛgé né mbaá ayi ákwɔɔ́ unó, akpane nyɛ ama alyaá ama. ");
INSERT INTO anvNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“Gétú ɛyigé na, débɔ mambɛ peé dégílé néndé, dekaá fɔ́ bií bi Ata nyú akérege meso wɔ́. ");
INSERT INTO anvNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Kaáge nnó mbɔgé mbɔɔ́ gepú akaáge gébé ɛyigé menjó achwɔɔ́ ne utuú manchwɔ́ gya gepú jií, mbɔ abɛɛ́ peé abame geji nnó ɛkáge menjó achwɔ́ agyá akpɛ́ mmu. ");
INSERT INTO anvNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Ɛnyú ntó kpómege mmyɛ gétúgé Maá Ntɛ Mekwaá akerege nyɛ́ɛ meso né gébé ɛyígé délá dékágé. ");
INSERT INTO anvNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Bɛge ndɛre maá defwɛ́ ayi awyaá deŋga, apyɛ utɔɔ́ bií chánchá. Ntɛ wuú alyaáge ji ne baá defwɛ́ abifɔ nnó apɛ́lé ɛbwɔ́, achyɛge ɛbwɔ́ menyɛ́ chánchá né gébé gelɔ́gélɔ́. ");
INSERT INTO anvNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Galɔ́gálɔ́ abɛɛ́ nyɛ ne maá defwɛ́ yimbɔ, gébégé ntɛ wuú akerégé meso agɛ́ne nyɛ nnó ji apyɛ utɔɔ́ bií chánchá. ");
INSERT INTO anvNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Ngarege ɛnyú wáwálé nnó ntɛ wuú abelege nyɛ ji ndɛre muú kpaá né unó bi ji awyaá uko nnó apɛ́lé. ");
INSERT INTO anvNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Ne mbɔgé maá utɔɔ́ yimbɔ abɛgé ayi áwyaá gepɔ gebogebo, ajɔ́ge nyɛ ne gemɛ jií aké, ‘Ntɛ wa abɛlege nyɛ dɔɔ́ ne achwɔ́.’ ");
INSERT INTO anvNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Alɔ mantúlégé atɛ aŋmɛ abifɔ, anyɛɛ́ anyú mmɔɔ́ ne atɛ anyuú mmɔɔ́ ne abifɔ ákwene. ");
INSERT INTO anvNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Mbɔgé apyɛ́gé mbɔ, ntɛ maá utɔɔ́ yimbɔ achwɔ kwɔ́ nyɛ ji neŋmé né gébé ɛyígé ji álá kaá nnó achwɔ́ wɔ́. ");
INSERT INTO anvNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Abanégé ji mbɔ, achyɛge nyɛ ji gekpɛ́kpɛ́ ɛfwyale ɛwé ɛbɔɔ́ ɛpwɔɔ́ amu, afyɛ ji né melu ɛwé Ɛsɔwɔ afyɛ́ɛ nyɛ bɔɔ́ dembwɔ́lé. Ne bɔɔ́ alilé nyɛ anyɛɛ́ maŋɛ́né ɛwú. ");
INSERT INTO anvNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Jisɔs afɛ́ mbɛ ajɔ́ge aké, “Gefwa ɛyigé Ɛsɔwɔ ágbárege gelu ɛké asɔ́ andée makpo afya abi álwɛɛ́ mátúléká manjyɛɛ́ bane menɔ neba. ");
INSERT INTO anvNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Né geluágé ɛbwɔ́, abi ata awyaá defɔɔ́ ne abi ata akénege. ");
INSERT INTO anvNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Abi ata abi akénege álwɛɛ́ mátúléká, yɛ́mbɔ ama kpá sé maweé ami fɔ́ nnó ámi malu mmu mátúléká mábyɛ́ge ámá áfyɛ́ wɔ́. ");
INSERT INTO anvNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Ne abi awyaá defɔɔ́ akpa maweé nnó ami malu mmu mátúléká bwɔ́ mábyɛgé ɛbwɔ́ ama afyɛ. ");
INSERT INTO anvNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Ne ɛlé menɔ neba yimbɔ alá achwɔɔ́ wáwá wɔ́, géjá gékpá ɛbwɔ́ ábɛlé. ");
INSERT INTO anvNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Ne metɔɔ́ utuú ɛké ɛkwɔ́nege ɛbwɔ́ awú nkane bɔɔ́ ákálege áké, ‘Menɔ neba achwɔ́ chwɔ́ge débáne ji.’ ");
INSERT INTO anvNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Baá ásɔandée bimbɔ áwúge mbɔ ákwilé ati mátúléká bwɔ́. ");
INSERT INTO anvNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Ne abi akénege ajyɛ kɔ maweé mbaá abi áwyaá défɔɔ́ áké, ‘Chyɛge ɛsé ɛkɛ́kɛ́ maweé defyɛ né mátúléká sé áchwɔɔ́ nómé.’ ");
INSERT INTO anvNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Abi áwyaá défɔɔ́ áshuú ɛbwɔ́ meko áké, ‘Ngba maweé amina makwánégé fɔ́ ɛsé ne ɛnyú, chóge mbaá bɔɔ́ abi ákpoó né melɔ déna amí nyú.’ ");
INSERT INTO anvNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Ne ndɛre ájyɛ mana maweé, menɔ neba yimbɔ achwɔ́. Achwɔ́gé asɛ abi ata abi ákpomé mmyɛ álú ɛfɛɛ́ ágilé ji, áfɛ́ ákpɛ né mmu gepú ɛpaá neba ágbɛ́ menombi. ");
INSERT INTO anvNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Ɛwyágé abifɔ ata abi ájyɛ na maweé áchwɔɔ́. Ála dafyɛ ádoó menombi ákuú áké, ‘Ata Ata! néné ɛsé menombi.’ ");
INSERT INTO anvNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Ne menɔ neba ashuú ɛbwɔ́ meko aké, ‘Me ngarége ɛnyú wáwálé nnó nkágé fɔ́ ɛnyú.’” ");
INSERT INTO anvNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Jisɔs anérégé mantó nekanémejɔɔ́ ɛníné na aké, “Sɛge yɛ́ gébé néndé dekaágé fɔ́ bií ne gébé ɛyigé me nkerege meso. ");
INSERT INTO anvNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Gefwa ɛyigé Ɛsɔwɔ ágbárege ne bɔɔ́ bií gelu ɛké nekanémejɔɔ́ ɛniné na: Mende fɔ abɔ́ ajyɛɛ́ nekɛ, gébégé ji achwɔ́ɔ jyɛɛ́, akuú baá defwɛ́ bií ako, akaré ɛbwɔ́ ŋka nnó ákɛ gese ne ɛji. ");
INSERT INTO anvNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Achyɛɛ́ ama uba ŋka uta, achyɛ ayifɔ uba upea ne achyɛ ntó ayifɔ geba géma. Akare ɛbwɔ́ ŋka ɛyina ndɛre yɛ́ndémuú akáge gbáre atane afɛ nekɛ. ");
INSERT INTO anvNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Ayi asɛlé uba ŋka uta, achɔ sé gébé wɔ́, ajyɛ lɔ́ gese mankɛ. Abɔ́ ntó nsa uba ŋka uta. ");
INSERT INTO anvNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Wyɛmbɔ ntó ne ayi asɛlé uba upea apyɛɛ́. Ji ntó abɔ́ nsa uba ŋka upea. ");
INSERT INTO anvNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Yɛ́mbɔ ayi asɛlé geba géma ajyɛ cho mme anií ŋka ntɛ wuú. ");
INSERT INTO anvNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Ɛbɛ́lɛ́gé ntɛ bwɔ́ akeré meso né nekɛ ɛniné ji abɔ́ ájyɛɛ́. Akuú ɛbwɔ́ ako nnó áchɛ́ré ágɛ ndɛre yɛ́ndémuú ápyɛɛ́ ne ɛjií ŋka. ");
INSERT INTO anvNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Ne ayi achyɛɛ́ ji uba ŋka uta achwɔ́ tɛ́né mbɛ ushu ntɛ bwɔ́, ajɔɔ́ ne ji aké, ‘Ata ɔchyɛɛ́ nyá me uba ŋka uta, nkɛ gese ne ɛji, mbɔ nsa uba ɛbifɔ́ uta gɛ́ ɛji na.’ ");
INSERT INTO anvNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Ntɛ wuú ashuú ji meko aké, ‘Ɔpyɛ dɔɔ́, ɔlu maá defwɛ́ melɔ́mélɔ́, muú akage nɛre metɔɔ́ ne wɔ. Tɛ ndɛre ɔlɛré nnó ɔkage gbáre ɛkɛ́kɛ́ ŋka chánchá, mbelege nyɛ wɔ né melu ɛwé ɔgbárege gejamégé ŋka. Chwɔ́ kpɛ mmu denyɛ́ ɛpaá wa ne metɔɔ́ megɔmegɔ!’ ");
INSERT INTO anvNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Ne maá defwɛ́ ayi achyɛɛ́ ji uba ŋka upea achwɔ́ ntó mbaá ntɛ bwɔ́. Ajɔɔ́ ne ji aké, ‘Ata ɔchyɛ nyá ntó me uba ŋka upea, nkɛ gese ne ɛji. Mbɔ́ nsa uba ɛbifɔ́ upeá gɛ́ ɛji na.’ ");
INSERT INTO anvNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Ntɛ bwɔ́ ashuú ji meko aké, ‘Ɔpyɛ dɔɔ́ ɔlu maá defwɛ melɔ́mélɔ́, muú akage nɛré metɔɔ́ ne wɔ. Tɛ mbaá ɔlɛré nnó ɔkage gbáre ɛkɛ́kɛ́ ŋka chánchá, mbelege nyɛ wɔ né melu ɛwé ɔgbárege gejamégé ŋka. Chwɔ́ kpɛ mmu denyɛ́ ɛpaá wa ne metɔɔ́ megɔmegɔ!’ ");
INSERT INTO anvNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Ne kwyakwya ayi achyɛɛ́ ji gébagé ŋka géma achwɔ́ ntó ɛta ntɛ bwɔ́. Ajɔɔ́ ne ji aké, ‘Ata menkaá nnó depɔ tyɛɛ́ demmyɛ amba. Ɔlu ɛké muú ayi agóme menyɛɛ́ né mekɔɔ́ ayi nlá kágé meso yi ápɛ́ne. ");
INSERT INTO anvNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Getú ɛyigémbɔ, mbɔ́ ɛfɔ nnó ŋka jyɛ ɛnógé ɔchyɛge nyɛ me ɛfwyale. Njyɛ cho mme nnií ɛjí wyɛ nnó ɛkagé ɛnó. Gɛ́ ŋka jyɛ na sɛ.’ ");
INSERT INTO anvNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“Ne ntɛ bwɔ́ ashuú ji meko aké, ‘Wɔ ɔlu maá defwɛ́ mebomebo, ne mémbwá, ɔjɔɔ́gé ɔke me nlu ɛké muú ayi agóme menyɛɛ́ né mekɔɔ́ ayi nlá kágé meso ayi ápɛ́ne ne nkyɛɛ́ mbwɛ́ né mbaá ayi nlá ntyaá depomé wɔ́. ");
INSERT INTO anvNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Gétú ɛyigémbɔ, mbɔ́ ɔbɔ ɔfyɛ́ ŋka ya né gepúgé ŋka nnó nkeregé meso nsɛ ɛji ne nsa mfaá.’ ");
INSERT INTO anvNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Ajɔɔ́gé mbɔ, agaré baá defwɛ́ abifɔ aké, ‘Tɛ mbaá ji alɛré nnó akaáge gbáre fɔ́ ŋka ɛyimbɔ, sɛ́ge ɛji déchyɛɛ́ muú ayi awyaá uba ufya. ");
INSERT INTO anvNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Kaáge nnó muú ayi abɔgé nsá né genó, ji ne ámáge gbɛɛ́ ji ɛbwɔ nnó ji abɔ gejamégé unó. Yɛ́mbɔ muú ntó ayi álá abɔɔ́ nsá né genó ɛyigé me nchyɛɛ́ ji wɔ́, yɛ́ ɛ́kɛ́kɛ́ genó ɛwé ji awya, ásɛ́lé nyɛ́ geji ɛta wuú, nnó álá amu mawa. ");
INSERT INTO anvNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ne áfomé ji ntó né ɛpinyá gemua né dafyɛ, mbaá ayi ji awuú nyɛ ubalé, alíle anyɛɛ́ máŋɛ́né.’ ");
INSERT INTO anvNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Gébégé Maá Ntɛ Mekwaá achwɔgé ne ɛnógé, chóncho ne makiɛ́nné jií ako, ajwɔlege nyɛ né mfaá geluɔ́gé gefwa jií ɛyi gewyaá ɛnógé, ");
INSERT INTO anvNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","ne bɔɔ́ átanege nyɛ né malɔ mme mako anyweré né mbɛ ushuú wuú. Ɛfɛɛ́ mbɔ, akarege nyɛ ɛbwɔ́ matoó apea nkane membamé magɔŋme aferege magɔ́ŋme ayi álú choncho ne meŋmené ŋme. ");
INSERT INTO anvNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Abelege nyɛ ntoó nema né ɛgbɛ́ ɛbwɔnyɛ wuú, nema né ɛgbɛ́ ɛbwɔɛbɛ wuú. ");
INSERT INTO anvNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Ne mfwa ajɔɔ́ge nyɛ ne bɔɔ́ abi alú né ɛgbɛ ɛbwɔnyɛ wuú aké, ‘Chwɔ́ge ɛnyú bɔɔ́ abi Ntɛ wa ajéle ɛnyú. Denyɛ́ gefwa ɛyigé ji akwyɛɛ́ mɛ́ abelé ɛta nyú tɛɛ́ gébégé mme alɔɔ́. ");
INSERT INTO anvNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Néndé mesa abɔ́ ámmyɛ me, déchyɛɛ́ me menyɛɛ́, mmwɔ́lé manaá ɛpyɛ me, déchyɛɛ́ me manaá nyú, dégɛ me ndɛre meŋkɛɛ́, désɛ me. ");
INSERT INTO anvNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Mpɔ ne mandeé mamfyɛ́, déchyɛɛ́ me mandeé, mbɔ́ mmeé dépɛle me, nkpɛ denɔ dekɛne degɛne me.’ ");
INSERT INTO anvNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Ɛfɛɛ́ mbɔ ne bɔɔ́ abi alú cho né mbɛ ushu Ɛsɔwɔ ashúge nyɛ ji meko áké, ‘Ata ndé gébé ɛsé degɛne mesa ammyɛ wɔ, dechyɛɛ́ wɔ menyɛɛ́, mmwɔ́lé manaá ɛpyɛɛ́ wɔ déchyɛɛ́ wɔ manaá ɔnyuú, ");
INSERT INTO anvNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","ne ndé gébé ntó dégɛné wɔ ndɛre meŋkɛɛ́, dénɛné wɔ, ɔlú gejɔ́géné dechyɛɛ́ wɔ mandeé ɔfyɛɛ́? ");
INSERT INTO anvNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Ndé mbaá dégɛné wɔ ɔmée, dépɛlé wɔ, ɔkpɛné denɔ ɛsé dékɛné dégɛné wɔ?’ ");
INSERT INTO anvNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Ne mfwa ashúge nyɛ ɛbwɔ́ meko aké, ‘Me ngarege ɛnyú wáwálé nnó tɛ mbaá ɛnyú depyɛ unó bina ne aŋmɛ ba, yɛ́ ɛbɛ́lé mbaá muú ama ayi álá aŋea gemɛ wɔ né geluage aŋmɛ ba ɛbyɛ́nnó depyɛ mbɔ lé ne me!’ ");
INSERT INTO anvNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Ne abwɔlége nyɛ mmyɛ ajɔɔ́ ne abi alú ji né ɛgbɛ́ ɛbwɔɛbɛ aké, ‘Kwilege me ushu, ɛnyú abi mfaánebuú ashule ɛnyú mmyɛ, débɔ́ manjyɛ né ntoné mewɛ ɛwé ɛlá nómégé, ɛwé me nkwɛɛ́ mɛ́ mbelé mbaá danchɔmeló ne makiɛ́nné jií. ");
INSERT INTO anvNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Néndé mbɔ́ nlu mesa déchyɛɛ́ me menyɛɛ́ wɔ́, mmwɔ́lé manaá ɛpyɛɛ́ me, déchyɛ me manaá nnó nyú wɔ́, ");
INSERT INTO anvNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","dégɛ́ me ndɛre meŋkɛɛ́, dénɛ me wɔ́, nlu gejɔ́géné dechyɛɛ́ me mandeé nnó mfyɛ wɔ́, mmeé dechwɔ́ gɛ́ me wɔ́, nkpɛ denɔ dekɛɛ́ dégɛ́né me wɔ́.’ ");
INSERT INTO anvNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Ɛfɛɛ́ mbɔ ne ɛbwɔ́ áshuge nyɛ ji meko áké, ‘Ata ndé gébé ɛsé dégɛné mesa ammyɛɛ́ wɔ́, mmwɔ́lé manaá ɛpyɛɛ́ wɔ́, ɛsé délá poó wɔ wɔ́? Ne ndé gebe ntó degɛne wɔ nkane meŋkɛɛ́, ɔmeé, ne ɔkpɛne denɔ ɛsé délá depoó wɔ wɔ́?’ ");
INSERT INTO anvNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Ne ashuge nyɛ ɛbwɔ́ meko aké, ‘Me ngarége ɛnyú wáwálé nnó, tɛ mbaá ɛnyú délá poó yɛɛ́ muú ama ayi álá aŋea gemɛ né geluágé aŋmɛ ba bina wɔ́, ɛbyɛ́nnó depoó fɔ́ me wɔ́.’ ");
INSERT INTO anvNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Gétú ɛyigéna, bɔɔ́ bimbɔ ákpɛne nyɛ né ɛfwyale ɛwé ɛlá ɛbyɛɛ́ yɛ́mbɔ abi alu cho né mbɛ ushu Ɛsɔwɔ anyɛ́ nyɛ geŋwá ɛyi gélágé byɛ́.” ");
INSERT INTO anvNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Jisɔs anérégé manlɛre unó bina uko, ajɔɔ́ ne baá utɔɔ́ bií ");
INSERT INTO anvNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","aké, “Ɛnyú dékaá mɛ nnó ɛpaá koó upú ɛlú ndɔ fi ɛlɛɛ́, né bií bimbɔ, achyɛgé nyɛ me Maá Ntɛ Mekwaá maŋkwaá nnó áwɔ me né gekwa.” ");
INSERT INTO anvNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Wyɛ né gébé ɛyigémbɔ anɔɔ́ baá ámpyɛɛ́ upɛ Ɛsɔwɔ chóncho ne ákpakpa melɔ ágbare ujwɔle né gepúgé Kaifas ayi alu ɛtukpɛ ámpyɛɛ́ upɛ Ɛsɔwɔ, ");
INSERT INTO anvNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","ájɔɔ́ geju ndɛre ɛbwɔ́ apyɛɛ́ ne apyɛ Jisɔs né defya awá. ");
INSERT INTO anvNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Yɛ́mbɔ áfɛré áké, “Dépyɛgé fɔ́ ji gébégé ɛpaá ɛwéna, ɛ́kágé bɔɔ́ áŋme ummyɛ né melɔ.” ");
INSERT INTO anvNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Né gébé ɛyígémbɔ, Jisɔs alu né melɔ Bɛtani né mmu gepúge Simun ayi abɔ ameé uba, akuú ji nnó ɛbwɔ́ ájyɛ anyɛ́ menyɛɛ́. ");
INSERT INTO anvNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Ndɛre ɛbwɔ́ anyɛ́ menyɛɛ́, mendée fɔ akpɛ ne maweé gebɛ́ ami majamé ŋka dɔɔ́. Maweé amibɔ malu né mmu ɛkpómé ɛwé akwyɛɛ́ ne genó ɛyigé akuú nnó alabasta. Akpɛ́gé mbɔ amo Jisɔs maweé ami mbɔ né mekpó. ");
INSERT INTO anvNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Ne baá utɔɔ́ Jisɔs ágɛ́gé mbɔ, matɔɔ́ ásɔ́ ɛbwɔ́ mmu tɛ ágígé atɛ áké, “Ulannó ji áchɔɔ́ maweé amina? ");
INSERT INTO anvNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Mbɔ ákpoó mami ásɛ gejamégé ŋka, áchyɛɛ́ mbaá ubyá bɔɔ́.” ");
INSERT INTO anvNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Jisɔs akaá mɛ́ genó ɛyigé ɛbwɔ́ áfɛ́rege né mmu matɔɔ́ bwɔ́, ashuú ɛbwɔ́ meko aké, “Ulannó ɛnyú déchyɛ́ge mendée yina ɛfwyale? Ji apyɛ́mbɔ lé genchánchágé genó ɛta wa. ");
INSERT INTO anvNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Ubyá bɔɔ́ úlú ne ɛnyú yɛ́ndégébé yɛ́mbɔ gébé ɛyigé me mbɛɛ́ ne ɛnyú géjá sé wɔ́. ");
INSERT INTO anvNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Mendée yina amo me maweé mina mmyɛ nnó gébégé ngboge ánií me niíge. ");
INSERT INTO anvNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Ne me ngarége ɛnyú wáwálé nnó yɛ́ndé mbaá ayi bɔɔ́ ágárege nyɛ Abya melɔ́mélɔ́ yina né mme meko, ágárege nyɛ ntó genó ɛyígé mendée yina apyɛ. Nkane ágárege, mbɔntó ne áteé nyɛ ji yɛ́ndégébé.” ");
INSERT INTO anvNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Ɛwyágé, maá utɔɔ́ Jisɔs ama né geluágé abi áfyaneápeá ayi akuú ji nnó Judas Iscarot ajyɛ báne anɔɔ́ baá ámpyɛɛ́ upɛ Ɛsɔwɔ, ");
INSERT INTO anvNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","ajɔɔ́ ne ɛbwɔ́ aké, “Mbɔgé me mfyɛgé Jisɔs né amu nyú déchyɛge me ndé?” Ajɔɔ́gé mbɔ, ápa uba ŋgba bɔ sɛre ɛsaá meso ɛfya áchyɛ ji. ");
INSERT INTO anvNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Ɛfɛɛ́ ne Judas álɔɔ́ mankɛ́légé meti ɛwé ji apyɛɛ́ ne Jisɔs akpɛ ɛbwɔ́ né ámu. ");
INSERT INTO anvNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Né bií mbɛ, ɛbi ɛpaá brɛd yi álá muálé ɛlɔ́ɔ, baá utɔɔ́ Jisɔs ájyɛ gií ji áké, “Ndé mbaá ayi ɔkɛ́lege nnó ɛsé déjyɛ́ détyɛɛ́ menyɛɛ́ ɛpaá koó upú wyɛɛ́?” ");
INSERT INTO anvNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Ágigé mbɔ Jisɔs ashuú ɛbwɔ́ aké, “Chóge né melɔ́ kpaá, déjyɛgé dégɛ́ne nyɛ mende fɔ, gárege ji nnó, ‘Ménlɛré aké, gébé ya gékwané; ne me nkɛ́lege manyɛ́ menyɛɛ́ ɛpaá koó upú ne baá utɔɔ́ ba né gepú jyɛ́.’” ");
INSERT INTO anvNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Ne baá utɔɔ́ Jisɔs apyɛ wyɛ ndɛre ji agaré ɛbwɔ́, átyɛ́ menyɛɛ́ ɛpaá koó upú. ");
INSERT INTO anvNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Nkwale ákwɔ́négé Jisɔs ne baá utɔɔ́ bií áfyaneápeá, ájwɔlé ka manyɛ́ menyɛɛ́. ");
INSERT INTO anvNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Ne ndɛre ányɛɛ́, Jisɔs ajɔɔ́ ne ɛbwɔ́ aké, “Me ngarege ɛnyú wáwálé nnó, muú nyú ama achyɛge nyɛ me maŋkwaá.” ");
INSERT INTO anvNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Mechɔ́ ɛwé ɛpyɛ ɛbwɔ́ ábɔ́ ɛfwyale né matɔɔ́ ne alɔ mangií ji ama, ama áké, “Ata nnó ɛ́lé me?” ");
INSERT INTO anvNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Ágígé mbɔ Jisɔs ashuú ɛbwɔ́ meko aké, “Ɛlé muú ayi ɛbwɔ wuú ne ɛwa ɛtuúge né mmu akpáŋkpa ne akpoó nyɛ me. ");
INSERT INTO anvNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Ne Maá Ntɛ Mekwaá agbóo nyɛ wyɛ ndɛre ŋwɛ Ɛsɔwɔ abɔ́ ajɔɔ́ mɛ́ tɛ gachií, utoŋkwa ubɛ ne muú ayi akpóo nyɛ Maá Ntɛ Mekwaá. Ɛ ɛ́! Mbɔgé nnó ábɛ́ dambyɛ́ muú yimbɔ, mbɔ ɛlɔ́ kpaá ɛpwɔ.” ");
INSERT INTO anvNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Jisɔs ájɔ́gé mbɔ Judas ayi alú mankpóo ji achwɔ́ gií ji ntó áké, “Ménlɛré nnó ɛ́lé me?” Jisɔs ashuú ji meko aké, “Mbɔ ne wɔ ɔjɔɔ́.” ");
INSERT INTO anvNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Ne ndɛre ɛbwɔ́ álú nyɛ́ɛ menyɛɛ́ yimbɔ, Jisɔs abɔ́ ntó brɛd, anɛmmyɛ, achyɛɛ́ matame mbaá Ɛsɔwɔ. Agyá ntó brɛd yimbɔ uba uba, akaré mbaá baá utɔɔ́ bií ajɔɔ́ aké, “Gɛ́ge menyammyɛ wa na. Sɛ́ge dényɛ́.” ");
INSERT INTO anvNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Ne abɔ́ ntó amo ne mmɔɔ́ mmu, anɛmmyɛ achyɛɛ́ matamé mbaá Ɛsɔwɔ, achyɛɛ́ ɛbwɔ́ aké, “Sɛ́ge dényú ɛnyú ako. ");
INSERT INTO anvNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Gɛ́ge manoó ma na, amí malu menomenyɛɛ́ ɛwé Ɛsɔwɔ anyɛɛ́ nyɛ ne bɔɔ́ bií. Magbɛ́lege nyɛ́ né mme mampyɛ nnó Ɛsɔwɔ ájiínte gabo ayi gejamégé bɔɔ́ ápyɛɛ́.” ");
INSERT INTO anvNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Ama ajɔɔ́ ne ɛbwɔ́ aké, “Ngarege ɛnyú wáwálé nnó ndɛre nnyú mbɔ mmɔɔ́ mína kwyakwya, mmagé nyú sé amícha kpaá tɛ nnyú nyɛ ami makɛ ne ɛnyú né gefwa ɛyigé Ntɛ wa agbárege.” ");
INSERT INTO anvNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Ne ɛbwɔ́ ánérégé, ákwá ɛkwɔ áfɛɛ́ Ɛsɔwɔ átané ákwɔ́ mfaá Mekwɛ Olif. ");
INSERT INTO anvNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Ɛwyágé Jisɔs ajɔɔ́ ne ɛbwɔ́ aké, “Ɛnyú ako deboó nyɛ delyaá me ne utuú bina mbɔ ne ásáme né mmu ŋwɛ Ɛsɔwɔ nnó Ɛsɔwɔ aké, ‘Nwane nyɛ membame mágɔ́ŋme ne ɛkwɔ́ mágɔ́ŋme ɛláa nyɛ tyátyá.’ ");
INSERT INTO anvNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Ne nkwílégé né negbo, mbɔ nyɛ mbɛ ne ɛnyú né gebagé mewaá Galilií.” ");
INSERT INTO anvNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Ajɔɔ́gé mbɔ Pita ashuú ji meko aké, “Yɛ́ ɛbɛ́lé nnó bɔɔ́ ako ábó alyaá wɔ, me nlyágé fɔ́ wɔ.” ");
INSERT INTO anvNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Ne Jisɔs ntó ashuú ji meko aké, “Pita, gɔ́ ngaré wɔ wáwálé nnó utuú bina gemɛ́gé nnó menɔ mekwɔ akú, wɔ ɔshyaá nyɛ ndɔ ɛlɛɛ́ nnó wɔ ɔ́kágé me.” ");
INSERT INTO anvNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Ndɛre Jisɔs ajɔɔ́ mbɔ, Pita anyɛ́menó aké, “Yɛ́ ɛbɛ́ lé negbo, ngbóo ne wɔ, nshyáá fɔ́ wɔ.” Wyɛ́mbɔ ntó ne baá utɔɔ́ abifɔ anyɛ́meno mampyɛ. ");
INSERT INTO anvNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Ánérégé ɛfɛɛ́ Jisɔs asɛ́ ɛbwɔ́ áfɛ́ né melu ɛwé ákuú nnó Getsɛmanɛ wyɛɛ́ né mékwɛ́ ɛwémbɔ. Ákwɔ́négé ɛ́wu, agaré ɛbwɔ́ aké, “Jwɔ́lege fa, mente mmyɛ mbɛ gachyɛ́ manɛ́némmyɛ.” ");
INSERT INTO anvNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Ndɛre ji atené mmyɛ mbɛ manɛ́mmyɛ asɛ́ Pita ne baá Sɛbɛdee apeá (Jɛmsi ɛbwɔ́ ne Jɔn) ndɛre ɛbwɔ́ ájyɛ meshwɛ ne masómé makwɔ́ Jisɔs metɔɔ́. ");
INSERT INTO anvNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Ne ajɔɔ́ ne ɛbwɔ́ aké, “Masómé amí malú me metɔɔ́ maténe me meti negbo. Yɛ́mbɔ jwɔ́lege fa, debɛ peé ne me.” ");
INSERT INTO anvNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Atégé yɛɛ́ mmyɛ mbɛ gachyɛɛ́ ató mano mme, amo ushuú mme anɛmmyɛ aké, “Ntɛ wa mbɔgé ɛlú kɔkɔge féré amó ɛfwyale yina átáné me mmyɛ, yɛ́mbɔ pyɛ genó ɛyigé wɔ ɔkɛlege ɛ́pɔ́ fɔ́ ɛyigé me nkɛ́lege.” ");
INSERT INTO anvNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Ne ákerégé meso né mbaá ayi baá utɔɔ́ bií abi alɛɛ́ álú, abané ɛbwɔ́ ndɛre ábɛ́lege géjyá. Ajɔɔ́ ne Pita aké, “Nnó ɛnyú dékágé bɛ́fɔ́ peé ne me, yɛɛ́ lé né nchwanekɛ ama? ");
INSERT INTO anvNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Bɛɛ́ge peé, dénɛ́némmyɛ mbaá Ɛsɔwɔ nnó ɛ́kágé ɛnyú dékpɛ́ né mmuameno. Matɔɔ́ nyú ákɛ́lege nnó ɛnyú dénɛ́némmyɛ yɛ́mbɔ menyammyɛ nyú áwyá gepwá.” ");
INSERT INTO anvNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Ajɔɔ́gé mbɔ ama akéré meso manɛmmyɛ aké, “Ntɛ wa, mbɔgé ɔkɛ́légé fɔ́ manke ŋkɔ ɛfwyale ayina akoó me, gɔ́ me nyú ji ndɛre wɔ ɔkɛle.” ");
INSERT INTO anvNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Ne amá akérégé ndɔ ɛyi ɛgbeé ɛpeá né mbaá baá utɔɔ́ bií álú, abané wyɛ ndɛre ɛbwɔ́ ábɛ́lege géjyá néndé géjyá gejá ɛbwɔ́ amɛ dɔɔ́. ");
INSERT INTO anvNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Ne Jisɔs amágé lyaágé ɛbwɔ́, ajyɛ nɛmmyɛ ndɔ ɛyi ɛgbeé ɛlɛɛ́ annyuaré wyɛ mmyɛmenɛne ɛyimbɔ. ");
INSERT INTO anvNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Ne ama kérégé mbaá baá utɔɔ́ bií ajɔɔ́ ne ɛbwɔ́ aké, “Délú bɛ́lege géjyá, degbeége mmyɛ? Gɛ́ge gébé gekwané ɛyigé áchyɛgé nyɛ Maá Ntɛ Mekwaá maŋkwaá ne áfyɛ́ ji né amu bɔɔ́ ubeé. ");
INSERT INTO anvNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Kwilege mme déjyɛ́, gɛ́ge muú ayi achyɛge nyɛ me maŋkwa mbɔ alé chwɔ́.” ");
INSERT INTO anvNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Wyɛ ndɛre Jisɔs alú jɔɔ́ge mbɔ, maá utɔɔ́ wuú ama ayi akámege Judas né geluágé abi áfyaneápeá achwɔ́ ne njuné bɔɔ́. Bɔɔ́ bimbɔ ágbaré bɔ aparanja ne mámbó unɔɔ́. Bɔɔ́ bi átɔmé ɛbwɔ́ ɛ́lé anɔɔ́ baá ámpyɛɛ́ upɛ Ɛsɔwɔ ne ákpakpa melɔ. ");
INSERT INTO anvNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Ɛké ɛpyɛmbɔ, Judas abɔ́ mɛ́ mbɛ agaré ɛbwɔ́ aké, “Muú ayi me ntyaáge gɛ́ge ji mbɔ pyɛ́ge.” ");
INSERT INTO anvNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Ákwɔ́négé, yɛ́ gébé achɔ sé wɔ́, akoó cho afɛ́ mbaá Jisɔs aké, “Ménlɛré ntamé,” akpá ji atyaá. ");
INSERT INTO anvNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Atyágé ji mbɔ, Jisɔs ajɔɔ́ ne ji aké, “Mejeé wa, chó mbɛ ne utɔɔ́ byɛɛ́.” Ajɔɔ́gé mbɔ bɔɔ́ bimbɔ áchwɔ́ ápyɛ ji agbaré ji ne amu matomato. ");
INSERT INTO anvNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Ágbárégé Jisɔs mbɔ, muú ama né geluágé abi álú ne Jisɔs, ajuú aparanja asɔ́ ɛtu memfwɛ́ ɛtukpɛ ámpyɛɛ́ upɛ Ɛsɔwɔ. ");
INSERT INTO anvNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Ne Jisɔs ajɔɔ́ ne ji aké, “Shwɔ́ré aparanja wyɛ né mmu mekɔ́, néndé bɔɔ́ ako abi ámmyɛ umyɛ ne aparanja, agboó negbone aparanja. ");
INSERT INTO anvNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Ɔfɛré nnó nnɛgé mmyɛ mbaá Ntɛ wa nnó apoó me, atɔ́mé fɔ́ gejamégé makiɛ́nné ji nnó áchwɔ́ apoó me? ");
INSERT INTO anvNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Yɛ́mbɔ, me mpyɛgé mbɔ, ɛpyɛ mbɔ́ nnó ne unó bi ŋwɛ Ɛsɔwɔ ajɔɔ́ upyɛ wáwálé?” ");
INSERT INTO anvNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Wyɛ né gébé ɛyigémbɔ, Jisɔs ajɔɔ́ ne gejamége bɔɔ́ bimbɔ aké, “Ɛnyú dechwɔ́ na ne bɔ aparanja ne mámbó unɔɔ́ mampyɛ me nnó me nlu menjó? Me nlú fa ne ɛnyú yɛ́ndé bií, nlɛrégé mekomejɔɔ́ Ɛsɔwɔ né ɛcha upɛ, nnó débɔ́ degɛɛ́ me mampyɛ wɔ́? ");
INSERT INTO anvNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Yɛ́mbɔ, depɔ ɛtiré depyɛ mbɔ na, nnó unó bi bɔɔ́ ɛkpávɛ́ Ɛsɔwɔ ásamé ubɛ́ wáwálé.” Ɛfɛɛ́ ne baá utɔɔ́ bií ako áboó ályaá ji. ");
INSERT INTO anvNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Ne baá utɔɔ́ bií alyágé ji mbɔ, bɔɔ́ abi ápyɛne ji, asɛ ji áfɛ́ né gepúgé Kaifas ayi alu ɛtúkpɛ ampyɛ upɛ Ɛsɔwɔ. Ɛfɛɛ́ mbɔ nto ne anlɛré mabɛ́ Ɛsɔwɔ chóncho ne ákpakpa melɔ anyweré. ");
INSERT INTO anvNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Ne ndɛre ájyɛ, Pita akwɔlege ɛbwɔ́ meso gachyɛɛ́, gachyɛɛ́ kpaá tɛ akpɛné né mmu dachi ɛtukpe ampyɛ upɛ Ɛsɔwɔ. Akpɛ́gé, ajyɛ jwɔ́le ne ámbamé dachi ɛtukpɛ mangɛ́ genó ɛyigé apyɛ mbaá Jisɔs. ");
INSERT INTO anvNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Anɔɔ́ baá ampyɛ upɛ Ɛsɔwɔ ne bɔɔ́ ako abi ájwɔlé mmu ɛcha ɛso, ákɛlé ammá mpa gebyɔ́ mamma Jisɔs mmyɛ nnó áwá ji. Yɛ́mbɔ ágɛ́ yɛɛ́ ɛma wɔ́. ");
INSERT INTO anvNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Ne gejamégé bɔ́ ntɛ́sɛ́ gebyɔ́ átané áma Jisɔs depɔ mmyɛ, yɛ́mbɔ yɛɛ́ mémá ɛma ɛwé ɛlɛré nnó Jisɔs akwé mpa ɛpɔ́. Ɛwyágé, bɔ ntɛ́sɛ́ gebyɔ́ apeá achwɔ́, ");
INSERT INTO anvNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","ne ájɔɔ́ áké, “Maá mende yina ji aké, me nkagé mú ɛcha upɛ Ɛsɔwɔ ne gemɛ́gé nnó ndɔ ɛlɛɛ́ ɛkwɔ́né mmagé ntɛ́ne ɛwú.” ");
INSERT INTO anvNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Ɛfɛɛ́ mbɔ ne ɛtúkpɛ ampyɛ upɛ Ɛsɔwɔ akwilé ajɔɔ́ ne Jisɔs aké, “Wɔ ntó ɔpɔ́ ne meko manshuú né depɔ ɛtire bɔɔ́ ájɔɔ́ge mbɔ nnó ɔpyɛ?” ");
INSERT INTO anvNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Yɛ́mbɔ, yɛɛ́ meko Jisɔs ashuú ji wɔ́, ɛtukpe ɛma ŋmɛ́re ɛjɔɔ́ ɛké, “Me ngígé wɔ né mabɔ Ata Ɛsɔwɔ, muú alú mebɛ yɛ́ndégébé, mbɔgé wɔ ne ɔ́lú Maá Ɛsɔwɔ, Muú yi Ɛsɔwɔ akweré ji ɛlá gefwa gáré.” ");
INSERT INTO anvNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Agígé mbɔ, Jisɔs akamé aké, “Mbɔ ne wɔ ɔjɔɔ́. Yɛ́mbɔ mengaregé ɛnyú wáwálé nnó: meso gébé degɛ́ne nyɛ ndɛre Maá Ntɛ Mekwaá ajwɔlé né ɛgbɛ́ ɛbwɔnyɛ Ɛsɔwɔ ayi apwɔɔ́ amu ne dégɛne nyɛ ntó ndɛre achwɔ́ɔ né mmu gekógé mfaánebuú!” ");
INSERT INTO anvNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Jisɔs ajɔɔ́gé mbɔ, ɛtúkpɛ ampyɛ upɛ Ɛsɔwɔ agyá mandeé jií né mmyɛ manlɛré nnó metɔɔ́ ɛsɔ́ ji dɔɔ́, akálé aké, “Amɛge mmyɛ ne Ɛsɔwɔ! Ndé gécha démage kɛ́le bɔ ntɛ́sɛ́? Ɛnyú ambɔɔ́ dewú mɛ́ ndɛre ji ámɛ́ge mmyɛ ne Ɛsɔwɔ! ");
INSERT INTO anvNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Défɛré nnó ápyɛɛ́ nnó ne ji?” Agígé mbɔ, bɔɔ́ ako áwya áké, “Akwe mpa ne abɔ́ mangbó.” ");
INSERT INTO anvNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Ɛfɛɛ́ ne álɔɔ́ mankpó Jisɔs matyɛ ushu ádoó ji ukpɛ́kpɛ́ ne bɔɔ́ abifɔ ádoó ji maka, ");
INSERT INTO anvNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","ájwyagé ji áké, “Wɔ ɔlu Kras, Muú yi Ɛsɔwɔ akweré ji ɛlá gefwa. Garé ɛsé, Waá adoó wɔ?” ");
INSERT INTO anvNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Ndɛre ɛpyɛmbɔ, Pita alú wyɛ ka né dachi ɛtúkpɛ ampyɛ upɛ Ɛsɔwɔ, aké apɛlé maá mesɔ mendée fɔ alú maá defwɛ́ ɛtúkpɛ ampyɛɛ́ upɛ Ɛsɔwɔ, achwɔ́ jɔɔ́ ne ji aké, “Wɔ ntó ɔbɔ́ ɔlú ne Jisɔs muú Galilií.” ");
INSERT INTO anvNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Ájɔɔ́gé mbɔ, Pita ashya né mbɛ ushu ɛbwɔ́ ako aké, “Chaá-ó nkaá yɛ́ geno ɛyigé ɔ́jɔge mbɔ wɔ́.” ");
INSERT INTO anvNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Ashyágémbɔ akwilé afɛ́ né menombi gébámé. Ɛfɛɛ́ maá mesɔ mendée ayi fɔ agɛ́gé ji ajɔɔ́ ne bɔɔ́ abi átɛné ɛfɛɛ́ aké, “Mende yina abɔ́ alú ne Jisɔs muú Nasarɛt.” ");
INSERT INTO anvNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Yɛ́mbɔ Pita ama shya wyɛ shya afyɛ́ amu mewɛ aké, “Wáwálé nkaágé fɔ́ mende yimbɔ.” ");
INSERT INTO anvNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Ɛké ɛwyage bɔɔ́ bi átɛné ɛfɛɛ́ áchwɔ́ jɔɔ́ ne ji áké, “Wáwálé gebií gepɔ́ mmu, wɔ ntó ɔlú muú bwɔ́ ama néndé nénɔ́me mejɔɔ́ neé nélɛré mbaá ayi wɔ ɔtané.” ");
INSERT INTO anvNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Ndɛre ájɔɔ́ mbɔ Pita aké. Me nkaá kpɛ́ mende yimbɔ tɛ mfaánebuú. Wyɛ ndɛre ji akélege mbɔ, aké awúu menɔ mekwɔ akú kɔkɔgɔlɔ́kɔɔ́. ");
INSERT INTO anvNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Ne tɛ́nétɛ́né yimbɔ Pita ate mekomejɔɔ́ ayi Jisɔs abɔ́ ájɔɔ́ ne ji nnó, “Gemɛ́gé nnó menɔ mekwɔ akú, ɔshya nyɛ ndɔ ɛlɛɛ́ nnó ɔkaágé fɔ́ me.” Ne atané dafyɛ anyɔ meko ngbó ali segé segé. ");
INSERT INTO anvNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Bií ujyágé ne dondo, anɔɔ́ baá ampyɛ upɛ Ɛsɔwɔ ne ákpakpa melɔ áchomé, ásɔ mala ndɛre ápyɛ ne áwá Jisɔs. ");
INSERT INTO anvNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Ne ánérégé mansɔ mala, áwɛ́ Jisɔs amu ásɛ ji áfɛ́ mbaá Palɛt gɔmena bɔɔ́ Rom. ");
INSERT INTO anvNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Judas muú akpoó Jisɔs ágɛ́gé nnó ásɔ́ mpa nnó áwáne Jisɔs, byɔ ukɔré ji mmu, afɛré nnó ji apyɛ gabo, akpá uba ŋgba sére ɛsaá meso ɛfya ɛyi ji abɔ́ akpoó Jisɔs ajyɛ shuú ɛtukpe ampyɛ upɛ Ɛsɔwɔ ne ákpákpá melɔ. ");
INSERT INTO anvNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Ajɔɔ́ ne ɛbwɔ́ aké, “Mpyɛ gabo manchyaá manoó ntɛ mekwaá ayi álá apyɛɛ́ gabo wɔ.” Bɔɔ́ bimbɔ áshuú ji meko áké, “Ɛwémbɔ ɛta ɛsé ndɛre ndé? Gabo ayi mbɔ akpa wɔ.” ");
INSERT INTO anvNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Ájɔɔ́gé mbɔ, Judas atyá ŋka ɛyimbɔ ɛfɛɛ́ né metɔɔ́ gepú ɛcha upɛ Ɛsɔwɔ atané ajyɛ shií gemɛ jií. ");
INSERT INTO anvNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Ne anɔɔ́ baá ampyɛ upɛ Ɛsɔwɔ ápwɛ́ ŋka ɛyimbɔ. Ájɔɔ́ áké ŋka ɛyina ɛlé ŋka manoó, ne ɛ́bɛ́ sé ɛkamé fɔ́ nnó décho ŋka ɛyina melu ɛma ne ɛyi ɛlu ne mmu mekwa ŋka ɛcha upɛ Ɛsɔwɔ wɔ́. ");
INSERT INTO anvNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Áfyɛ́gé makpo bwɔ́ mbaá ama, áke ábɔɔ́ ŋka ɛyina ána melu mme mbaá menkwyɛ unje mesɛɛ́ anigé aŋkɛ bɔɔ́ wyɛ. ");
INSERT INTO anvNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Ɛlɔ né gébé ɛyigémbɔ kpaá tɛ fina álú ákuú melu mme ɛwémbɔ nnó mewaá manoó. ");
INSERT INTO anvNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Ɛpyɛɛ́mbɔ nnó mekomejɔɔ́ ayi Jɛrimaya muú ɛkpávé Ɛsɔwɔ abɔ́ ajɔɔ́ abɛ wáwálé. Ji ajɔɔ́ nya aké ásɛ uba ŋgba bɔ sére ɛsaá meso ɛfya ɛyi ɛlú gese ɛyi bɔɔ́ Isrɛli ákamé mana ji, ");
INSERT INTO anvNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","ápyɛ wyɛ ndɛre Ɛsɔwɔ agaré me ana melu mme mbaá menkwyɛɛ́ ujemesɛɛ́. ");
INSERT INTO anvNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Ndɛre Jisɔs atɛné né mbɛ ushu Palɛt gɔmena bɔɔ́ Rom, Palɛt agií ji aké, “Wɔ ne ɔlú mfwa bɔɔ́ Jus?” Ne Jisɔs ashuú ji meko aké, “Ɛlu nkane ɔjɔɔ́.” ");
INSERT INTO anvNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Yɛ́mbɔ gebyɔ́ ɛyigé anɔɔ́ baá ampyɛ upɛ Ɛsɔwɔ ne ákpakpa melɔ ámalé ji mmyɛ, yɛɛ́ meko Jisɔs ashuú ji wɔ́. Ajwɔlé wyɛ ji nyámé. ");
INSERT INTO anvNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Ne Palɛt agií yɛ́ ji aké, “Nnó wɔ ɔwuú mbɔ fɔ́ depɔ ɛtiré bɔɔ́ bi áké wɔ ɔpyɛ?” ");
INSERT INTO anvNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Yɛ́mbɔ Jisɔs ajwɔlé wyɛ ji nyámé. Ɛwéna ɛpyɛ mfwa bɔɔ́ Rom akwe tametame. ");
INSERT INTO anvNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Ne gepɔ́gé gɔ́mená bɔɔ́ Rom, gélú nnó yɛ́ndé ŋmɛ, gébégé ɛpaá koó upú, áferégé muú denɔ ama né gepúgé denɔ, ndɛre bɔɔ́ ákɛ́lege. ");
INSERT INTO anvNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Ne wyɛ né gébégé ɛpaá koó upú ɛwémbɔ, mende fɔ ayi bɔɔ́ akaá ji dɔɔ́ gétúgé depɔ ɛtiré ji apyɛ́ɛ abɔ́ akpɛ denɔ. Akamege Barabas. ");
INSERT INTO anvNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Ne ndɛre melɔ meko ɛchomé né dachi Palɛt, Palɛt agií ɛbwɔ́ aké, “Ɛnyú dekɛ́lege me mferé ndé muú né denɔ; Barabas waá Jisɔs muú ayi ákuú ji ntó nnó Kras?” ");
INSERT INTO anvNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Palɛt agií mbɔ néndé akaá cháŋéné nnó ɛlé wyɛ né nchyɛ detú ne ákpakpa bɔɔ́ Jus ápyɛné Jisɔs áchwɔ́ ne ji ɛta wuú. ");
INSERT INTO anvNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Ne ndɛre Palɛt ajwɔlé né mmu ɛcha ɛso apane mpa yina, mendée wuú atɔ́ áchwɔ́ gáre ji aké, “Féré amu né mpa mende yimbɔ, néndé apyɛ gabo fɔ́ wɔ́. Genó ɛyigé Ɛsɔwɔ alɛre me né géjya gétú jií fina gechyɛ me ɛfwyale dɔɔ́.” ");
INSERT INTO anvNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Yɛ́mbɔ anɔɔ́ baá ampyɛ upɛ Ɛsɔwɔ ne ákpakpa melɔ áfyɛ ɛshyɛ nnó ájɔɔ́ nnó Palɛt aféré Barabas né denɔ, alyaá Jisɔs nnó áwá. ");
INSERT INTO anvNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Ne Palɛt ama agií ɛbwɔ́ aké, “Ɛbwɔ́ bina apeá, ndé muú ayi ɛnyú dékɛ́lege nnó mféré ji né denɔ?” Áshuú ji meko áké, “Ɛsé dekɛ́lege nnó wɔ ɔféré Barabas.” ");
INSERT INTO anvNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Palɛt ama aŋmɛre agií ɛbwɔ́ aké, “Ɛnyú dékɛlege me mpyɛ yɛɛ́ nnó ne Jisɔs ayi ákuú ji ntó nnó Kras?” Áma áshuú ji meko áké, “Gɔ́ áwɔ́ ji né gekwa.” ");
INSERT INTO anvNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Ájɔɔ́gé mbɔ, Palɛt ama gií ɛbwɔ́ aké, “Ulannó ɛnyú dékɛ́lege nnó áwá ji? Ndé gabo ayi ji ápyɛɛ́?” Yɛ́mbɔ, ɛbwɔ́ áwya wyale ne ɛshyɛ áké, “Gɔ́ áwɔ́ ji né gekwa!” ");
INSERT INTO anvNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Ne Palɛt agɛ́gé nnó ji atulege mmyɛ detú ɛfwyale ɛkagé tane mbɔgé ji álá akamé nnó áwá Jisɔs wɔ́, Atɔ́ ájyɛ chwɛ́ manaá, áchwɔɔ́ chyɛ́ɛ ji ashwɔné amu né mbɛ ushu bɔɔ́ bimbɔ aké, “Amu ya apɔ́ né negboné mende yina, gɛ́ ɛfwyale nyú mbɔ”. ");
INSERT INTO anvNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Ajɔɔ́gé mbɔ, bɔɔ́ bimbɔ ákamé áké, “Gɔ́ gewu ɛyigémbɔ gewilé ɛsé mmyɛ chóncho ne baá ɛsé.” ");
INSERT INTO anvNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Palɛt aférégé Barabas né denɔ. Atulé Jisɔs ne geto ne álé lyaá nnó bɔɔ́ bee Rom ája ji ájyɛ́ áwɔ́ ji né gekwa. ");
INSERT INTO anvNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Palɛt alyágé Jisɔs nnó áwɔ́ ji né gekwa, bɔɔ́ bee bií ásɛ Jisɔs áfɛ́ ne ji né ɛcha gɔmena, ákuú bɔɔ́ bee ako áchwɔ́ nɔ́ ji mme, ");
INSERT INTO anvNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","áferé ji mandeé mmyɛ, áfyɛ́ ji ɛwulé megɛ́lé ɛwé ɛlú ɛké nkúu afwa. ");
INSERT INTO anvNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Átɔ ɛlá meshií áfaá Jisɔs né mekpo ne áfyɛ ji ntó meto né ɛbwɔ́ ɛké meto gefwa. Ápyɛ́gé mbɔ, átóme manó né mbɛ ushu wuú ne ájwaáge ji áké, “Wɔ Mfwa bɔɔ́ Jus neki nébɛ́ ne wɔ.” ");
INSERT INTO anvNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Ndɛre ájwyáge ji mbɔ, ákpóo ji matyɛ́ mmyɛ, ne áfɔɔ́ meto ɛwémbɔ né ɛbwɔ wuú ádo ji né mekpo. ");
INSERT INTO anvNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Ánérégé mánjwya ji, áferé nkúu megɛ́lé yimbɔ ákeré áfyɛ ji mandeé jií né menyammyɛ wuú. Ája ji ájyɛ wɔ́ né gekwa. ");
INSERT INTO anvNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Ndɛre ájyɛɛ́, átuú ne mende fɔ né meti ayi ákuú ji nnó Simun muú melɔ Sɛren, ápyɛ ji ne utó nnó akpá gekwagé Jisɔs. ");
INSERT INTO anvNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Akwɔnégé né melú ɛ́wé ákúu nnó Golgota, mabɔ ami matɛne nnó “Melú Uŋkɔ́ŋkɔ́ Makpo” ");
INSERT INTO anvNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","áchyɛɛ́ Jisɔs mmɔɔ́ amí áchwaré ne genó ɛyi génywɔ́nege nnó anyú ne afwɔ́régé mami, ashya manyú. ");
INSERT INTO anvNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Ɛbwɔ́ áwɔ́gé ji, áŋme gefɔ́gé megyaá fɔ nnó ákáré mandeé jií. ");
INSERT INTO anvNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Ánérégé ájyɛ jwɔ́le mme ábáme Jisɔs ɛfɛɛ́. ");
INSERT INTO anvNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Ndɛre ɛbɔ́ ɛpyɛ́ɛ mbɔ ásá genó ɛyigé áké Jisɔs apyɛ né gebagé genɔɔ́ awɔ né mekpo gekwa ɛyigé áwɔmé Jisɔs wyɛɛ́. Ásá wyɛ áké, “Gɛ́ Jisɔs Mfwa bɔɔ́ Jus na.” ");
INSERT INTO anvNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Wyɛ né bií ɛbií mbɔ, áwɔ́ nyá ntó anjo apeá né ɛbi bwɔ́ ukwa. Áwɔ́ ama né ɛjií gekwa né ɛgbɛ́ ɛbwɔnyɛ Jisɔs ne ama né ɛgbɛ́ ɛbwɔbɛ wuú. ");
INSERT INTO anvNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Ne bɔɔ́ abi ákoge koógé ájúu Jisɔs mashyɛ mmyɛ, ákamege ne makpo ájwyage ji áke, ");
INSERT INTO anvNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","“Wɔ muú ɔké ɔmugé ɛcha upɛ Ɛsɔwɔ, gemɛ́gé nnó ndɔ ɛlɛɛ́ ɛkwɔ́né wɔ ɔmage tɛ́ne ɛwéchá, mbɔgé nnó ɔlu Maá Ɛsɔwɔ, poó gemɛ jyɛ́, ɔtáné mfaá gekwa ɔshulé mme.” ");
INSERT INTO anvNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Wyɛ́mbɔ ntó ne anɔɔ́ baá ampyɛ upɛ Ɛsɔwɔ ne ánlɛré mabɛ́ Ɛsɔwɔ chóncho ne ákpakpa melɔ ájwyaá ntó Jisɔs áké, ");
INSERT INTO anvNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Apoóge bɔɔ́ bí chachá, yɛ́mbɔ akaágé poó gemɛ́ jií? Pɔ nnó ji aké na ji alu Mfwa bɔɔ́ Isrɛli? Gɔge ji átáné mfaá gekwa áshuúlé mme ne ɛsé défyɛɛ́ matɔɔ́ se ne ji. ");
INSERT INTO anvNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Ji áfyɛɛ́ metɔɔ́ ne Ɛsɔwɔ, ne Ɛsɔwɔ áchwɔ ápoó yɛ́ ji mbɔgé ágboó ne ji, néndé ji ajɔ́gé aké ji alú Maá Ɛsɔwɔ.” ");
INSERT INTO anvNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Yɛ́ bɔɔ́ ubée abi áwɔ́mé ntó ɛbwɔ́ né ukwa, wyɛmbɔ ntó ne ájúu Jisɔs mashyɛ mmyɛ. ");
INSERT INTO anvNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Káláŋká ɛfyáneɛ́peá ɛké ɛ́kwɔ́nege, ŋmɛɛ́ ɛnomé, gemmua gékwé né melɔ meko kpaá tɛ káláŋká ɛlɛɛ́. ");
INSERT INTO anvNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Wyɛ né káláŋká ɛyimbɔ ɛlɛɛ́, Jisɔs alɔ máŋkalé kéŋké aké, “Ɛli, Ɛli lama sabatani” ula ɛtɛné nnó Ɛsɔwɔ wa Ɛsɔwɔ wa, ndé ɔlyaá me mbií né ɛfwyale? ");
INSERT INTO anvNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Ne bɔɔ́ abifɔ abi átɛné ɛfɛɛ́, áwúgé ndɛre Jisɔs ajɔ́ge mbɔ, áfɛré áké, “Akuú mbɔ lé Ɛlija muú ɛkpávé Ɛsɔwɔ.” ");
INSERT INTO anvNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Ne muú ama né geluágé abi átɛné ɛfɛɛ́, alomé gatɛlé ajyɛ bɔ́ ɛkochá anyua né mmu mmɔɔ́ amí mamyáme, ajo né genɔɔ́ abwɛɛ́ asa né ubɔɔ́ meno Jisɔs nnó ányú. ");
INSERT INTO anvNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Yɛ́mbɔ abifɔ áké, “Gɔ́ ji ábɛ́ ɛwú dégɛ́ kpɛ́ nnó Ɛlija achwɔ́ poó nyɛ ji!” ");
INSERT INTO anvNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Ne Jisɔs ama akále kéŋké afyɛ gemɛ jií né amu Ntɛ wuú Ɛsɔwɔ. ");
INSERT INTO anvNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Wyɛ ndɛre metɔɔ́ ɛkwené Jisɔs mbɔ́, ndeé ɛyi ɛkaré ɛcha upɛ Ɛsɔwɔ ɛgyalé uba upeá tɛ mfaá gba-ra-ra-ra ɛtya mme, mme anyigé, tegetege matárávɛ́ agyalé ubauba. ");
INSERT INTO anvNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Manome ánené alá fuúfuú ne gejamégé bɔɔ́ Ɛsɔwɔ abi agboó mɛ́ tɛ gachi, ákwilé né negbo. ");
INSERT INTO anvNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Gébégé Jisɔs akwilé né negbo. Bɔɔ́ Ɛsɔwɔ bimbɔ, átané né manome áfɛ́ né Jɛrosalɛ melɔ ukpea. Álɛré mmyɛ mbaá gejamégé bɔɔ́. ");
INSERT INTO anvNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Ne muú kpaá bɔɔ́ bee ne bɔɔ́ bee abifɔ abi álú ɛfɛɛ́ ábáme Jisɔs, ágɛ́gé ndɛre mme anyigé, ne unó bifɔ́ ɛbi upyɛɛ́ ɛfɔ ɛkwɔ́ ɛbwɔ́ matɔɔ́. Ájɔɔ́ge áké, “Wáwálé mende yina abɔ́ alu Maá Ɛsɔwɔ.” ");
INSERT INTO anvNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Gébé ɛyigémbɔ ntó, gejamégé andée, átɛné tɛtɛ ágɛ́né yɛ́ndégenó ɛyi gepyɛ́. Andée bina átané ne Jisɔs kpaá tɛ né Galilií ákwɔlé ji, ápóge Jisɔs, achyɛge ji unó bi akɛ́lege. ");
INSERT INTO anvNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Né geluage andée bina ɛlé, Mɛri ayi atané melɔ Magdala, Mɛri mmá Jɛmsi ɛbwɔ́ ne Josɛf, ne Mɛri mma baá Sɛbɛdee. ");
INSERT INTO anvNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Ne nkwale akwɔnege, muú ŋka fɔ ayi atane melɔ Arimatya akuú ji nnó Josɛf achwɔ́. Ji ntó alú nyá maá utɔɔ́ Jisɔs ama. ");
INSERT INTO anvNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Áchwɔ́gé, ajyɛ bane Palɛt agií ji nnó achyɛ ji utó ji ajyɛ afere geŋkwɔ́gé Jisɔs anií. Ne Palɛt achyɛɛ́ utó nnó afere geŋkwɔ́gé Jisɔs áchyɛ ji. ");
INSERT INTO anvNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Ne Josɛf asɛ́gé geŋkwɔ́gé Jisɔs, afyalé géjí ne ɛ́shyɛ́ ndeé pópó ");
INSERT INTO anvNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","abwɛɛ́ ajyɛ béle né mmu menome mekɛ ɛwé ji apyɛ bɔɔ́ akwyɛɛ́ né ɛba ntaá. Ábélégé, apelé gekpɛ́kpɛ́gé ntaá akweré meno menome ɛwémbɔ alyaá awilé ji. ");
INSERT INTO anvNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Ndɛre ji apyɛɛ́ unó bina, Mɛri muú melɔ Magdala ne Mɛri ayifɔ ájwɔlé toitoi ne menome ɛwémbɔ ápɛ́lé. ");
INSERT INTO anvNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Ne bií ujyage, mmyɛke bií ɛbi bɔɔ́ Jus ákpomege mmyɛ manyɛ́ uwyaá bwɔ́ ukoge, anɔɔ́ baá ampyɛ upɛ Ɛsɔwɔ ne ɛkwɔ́ bɔɔ́ Farasi ájyɛ báne Palɛt, ");
INSERT INTO anvNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","ágaré ji áké, “Ata, délu tée mbɔ ndɛre muú dembwɔ́lé yimbɔ ajɔɔ́ nyá gébégé ji alú mebɛ nnó, ‘Ndɔ ɛlɛɛ́ ɛkwɔnégé Ɛsɔwɔ abwɛge nyɛ me nkwílé né negbo.’ ");
INSERT INTO anvNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Ndɛre ɛlúmbɔ ɛsé dekɛlégé nnó wɔ ɔfyɛ bɔɔ́ ábámé menome ɛwémbɔ kpaá tɛ ndɔ ɛyimbɔ ɛlɛɛ́ ɛkóge. Ɛwéna ɛpyɛ nyɛ nnó ɛkagé baá utɔɔ́ bií ájó genkwɔ́ ji, ne meso gébé agarege gebyɔ nnó Ɛsɔwɔ apyɛ ji akwilé né negbo. Mbɔgé ɔlá ɔpyɛ mbɔ wɔ́, ne ájogé genkwɔ jií, dembwɔlé ɛtire nana depwɔɔ́ nyɛ ɛtiré mbɛmbɛ.” ");
INSERT INTO anvNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Ajɔɔ́gé mbɔ Palɛt aké, “Pyɛ ndɛre wɔ ɔkágé pyɛ, kwyɛɛ́ bɔɔ́ bee ɔbele ábámé menome ɛwémbɔ cháŋéné.” ");
INSERT INTO anvNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Ne ájyɛ́gé afyɛ gelo né menome ɛwémbɔ nnó ɛ́kágé muú anene ɛwu, afyɛ bɔɔ́ bee ábámé ɛwu. ");
INSERT INTO anvNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Bií uwyaá bwɔ́ ukógé, ndɛre bií ujyáge, Mɛri muú melɔ Magdala ne Mɛri ayifɔ átané ájyɛ chɛre ndɛre menome Jisɔs ɛlú. ");
INSERT INTO anvNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Aké apɛle mme abɔ anyígé ne ɛshyɛ. Ɛkiɛ́nné Ɛsɔwɔ ɛtané mfaánebuú, ɛchwɔ́ bógene ntaá ɛniné mbɔ ɛbelé babá ɛjwɔlé mfaá. ");
INSERT INTO anvNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Menyammyɛ wuú agɛ́nege manémané ɛké gasama, ne mandeé jií ashwánege pópó ɛké ɛshyɛ́ɛ ndeé. ");
INSERT INTO anvNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Ɛpyɛ́gé mbɔ, bɔɔ́ bee abi ábáme menome ɛwémbɔ áwe jaja ne ɛfɔ metɔɔ́ getu jií, ákwé ɛké uŋkwɔ́ bɔɔ́. ");
INSERT INTO anvNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Ne ɛkiɛ́nné Ɛsɔwɔ ɛwémbɔ ɛjɔɔ́ ne andée bimbɔ ɛké, “Défɔgé. Nkaá nnó ɛnyú dékɛlege mbɔ lé Jisɔs, ayi ábɔ́ áwɔmé ji né gekwa. ");
INSERT INTO anvNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Ji apɔ́sé fana, akwilé né negbo wyɛ nkane ji abɔ́ ajɔɔ́ nnó ɛpyɛ nyɛ. Chwɔ́ge dégɛ́ melú ɛwé ábɔɔ́ ábelé ji. ");
INSERT INTO anvNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Ne kérege meso wáwá, dégaré baá utɔɔ́ bií nnó, ‘Ɛsɔwɔ apyɛ ji akwilé né negbo. Abɔ́ mɛ́ mbɛ ne ɛnyú afɛ́ né Galilií; dégɛné nyɛ ji ɛwú!’ Gɛ́ge genó ɛyigé me mbɔɔ́ mangaré ɛnyú mbɔ.” ");
INSERT INTO anvNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Andée bimbɔ átané né menome ne gatɛlé, ne ɛfɔ metɔɔ́, yɛ́mbɔ ájyɛɛ́ ne nechɔ́chɔ́. Ákɛ wáwá manjyɛ gáre baá utɔɔ́ Jisɔs meko ayi ɛkiɛ́nné ɛgaré ɛbwɔ́. ");
INSERT INTO anvNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Ne ndɛre ɛbwɔ́ ájyɛ, Jisɔs abané ɛbwɔ́ né meti, atamé ɛbwɔ́ aké mejé ɛbɛ́ ne ɛnyú. Andée bimbɔ ákwé ji né uká ánoge ji. ");
INSERT INTO anvNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Ne Jisɔs afyɛ́ɛ yɛ ɛbwɔ́ metɔɔ́ aké, “Défɔgé, choge dégáré aŋmɛ́ ba nnó ájyɛ ne Galilií, ágɛ́ne nyɛ me ɛwú.” ");
INSERT INTO anvNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Ndɛre andée bina ájyɛ né melɔ manjyɛ gáre baá utɔɔ́ Jisɔs genó ɛyigé Jisɔs ne ɛkiɛ́nné Ɛsɔwɔ ájɔɔ́, bɔɔ́ bee fɔ́ abi ábɔ́ ábáme menome Jisɔs, áfɛ́ ntó né melɔ manjyɛ gáre ánɔɔ́ baá ampyɛ upɛ Ɛsɔwɔ yɛ́ndégenó ɛyi gepyɛ́. ");
INSERT INTO anvNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Apyɛgembɔ, anɔɔ́ baá ampyɛ upɛ Ɛsɔwɔ choncho ne ákpakpa melɔ, áchomé mbaá ama, ásɔ́ mala akpa gejamégé ŋka áchyɛɛ́ unyɛ́lé mbaá bɔɔ́ bee bimbɔ ");
INSERT INTO anvNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Ágaré ɛbwɔ́ áké, “Débɔ́ mangaré bɔɔ́ nnó, baá utɔɔ́ Jisɔs achwɔ́ jo genkwɔ́ jií ne utuú gébégé ɛnyú débɛ́lege gejyá. ");
INSERT INTO anvNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Ne mbɔgé gɔmena awúgé mechɔ́ ɛwé, ɛsé dékagé nyɛ ndɛre dégárege ji, nnó ɛkagé ɛnyú dékpɛ ɛfwyale.” ");
INSERT INTO anvNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Bɔɔ́ bee ásɛ́gé ŋka ɛyimbɔ, ájyɛ gáre wyɛ ndɛre anɔɔ́ baá ampyɛ upɛ Ɛsɔwɔ áké ɛbwɔ́ ágáré. Ne abya yina atyaá akpɛ né gebagé mewaá bɔɔ́ Jus geko, yɛɛ́ tɛ fina abya yina álu asanege né gebage mewaá bɔɔ́ Jus. ");
INSERT INTO anvNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Baá utɔɔ́ Jisɔs afyaneama áwugé meko ayi Jisɔs alɔɔ́ ɛbwɔ́, áfɛ́ né mfaá mékwɛ́ né gebage mewaá Galilií ndɛre Jisɔs agaré ɛbwɔ́. ");
INSERT INTO anvNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Ne ɛbwɔ́ ágɛgé ji, ánoge ji yɛ́mbɔ abifɔ áwyaá dembyɔ́ né metɔɔ́. ");
INSERT INTO anvNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Jisɔs ajɔɔ́ ne bwɔ́ aké, “Ɛsɔwɔ achyɛɛ́ me uto né unó uko bi úlú, né mfaánebuú ne fa mme.” ");
INSERT INTO anvNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Ndɛre ɛlúmbɔ chóge yɛ né malɔ mme meko dépyɛ bɔɔ́ ábɛ́ aŋkwɔlé ba. Abi akemege mambɛ́ aŋkwɔlé ba, wyagé ɛbwɔ́ manaá Ɛsɔwɔ né mabɔ Ɛsɔwɔ ntɛ ne ami maá ne Mendoó Ukpea. ");
INSERT INTO anvNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Lɛ́régé ɛbwɔ́ nnó akwɔlege majyɛɛ́ ami me nchyɛɛ́ ɛnyú. Ne kaágé wáwálé nnó me mbɛ́ɛ wyɛ́ ne ɛnyú yɛ́ndégébé kpaá tɛ mme abyɛɛ́.");
INSERT INTO anvNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Gɛ́ náne abya melɔ́mélɔ́ ayi Jisɔs Kras, Maá Ɛsɔwɔ ákɛ́né. ");
INSERT INTO anvNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Abya yina alɔ wyɛ nkane Asaya muú ɛkpávé Ɛsɔwɔ abɔ ásámé nnó, “Ɛsɔwɔ aké, ‘Wuúgé, ntɔme nyɛ́ muú dentɔɔ́ wa ayi abɔɔ́ mbɛ ne wɔ manchwɔ kwyɛ́ meti wyɛ.’ Asaya ama asá ntó nnó, ");
INSERT INTO anvNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","muú fɔ abɛne mbɔ né mashwɔne aké, ‘Kwyɛge meti Ata dakɛné. Nyaáge ɛ́wú ɛ́bɛ́ cho!’” ");
INSERT INTO anvNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Bií fɔ Jɔn achwɔ́ né mashwɔne agarege yɛ́ndémuú nnó ákwɔré metɔɔ́ wuú álya gabo ne áwyaá ji manaá Ɛsɔwɔ nnó, Ɛsɔwɔ ajinte gabo wuú. ");
INSERT INTO anvNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Yɛ́ndégébé gejamégé bɔɔ́ átanege né gebagé mewaá Judiya ne bɔɔ́ Jɛrosalɛ áko ájyɛ́ wu mekomejɔɔ́ Jɔn, áshuú ɛkúu né gabo ayi ɛbwɔ́ ápyɛɛ́, Jɔn awyaágé ɛbwɔ́ manaá Ɛsɔwɔ né Ɛbɛɛ́ Jodan. ");
INSERT INTO anvNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Jɔn afyɛ́ mandeé ayi átɔ́ɔ ne bya mpɔ mashwɔne. Awɛ́lé ɛkandá mekɔ́ menya né gebwɛ jií, ne menyɛɛ́ wuú alu nyá lé ɛ́gomé ne nwyɔɔ́. ");
INSERT INTO anvNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Jɔn agarege bɔɔ́ aké, “Muú fɔ achwɔ́ mbɔ me meso ayi áŋeá gemɛ apwɔ́ me, nkwané yɛ́ muú ayi nkage mbyɛ́le mme nkaá manyií unó uka bií wɔ́.” ");
INSERT INTO anvNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Ama jɔɔ́ aké, “Me nwyage ɛnyú ne manaá Ɛsɔwɔ mamímamí ne ji ayi áchwɔ awyage nyɛ ɛnyú ne Mendoó Ukpea.” ");
INSERT INTO anvNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Né gébé ɛyimbɔ, Jisɔs atané né melɔ Nasarɛt né gebagé mewaá Galilií achwɔ́ nnó Jɔn awyaá ji manaá Ɛsɔwɔ né Ɛbɛɛ́ Jodan. ");
INSERT INTO anvNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Gébégé awyaá ji manaá Ɛsɔwɔ átánege né mmu nnyi, agɛ́ mfaanebuú anené Mendoó Ukpea ɛtané mfaá ɛ́shúlege ji mmyɛ nkane gepwine. ");
INSERT INTO anvNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Ne meko atané mfaánebuú aké, “Wɔ ɔlu maá metɔɔ́ wa, metɔɔ́ ɛgɔɔ́ me ne wɔ dɔɔ́.” ");
INSERT INTO anvNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Tɛ́nétɛ́né yimbɔ Mendoó Ukpea ɛ́pyɛ ji afɛ́ né mashwɔne. ");
INSERT INTO anvNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Jisɔs abɛlé ɛwu usaá ndɔ upea, ne danchɔmeló achwɔ kpelé ji. Mbaá ayi ji alu, menya mebomebo ntó ɛlu wyɛ ne makiɛ́nné Ɛsɔwɔ áchwɔ́ poó Jisɔs. ");
INSERT INTO anvNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Ɛwyagé Hɛrɔd apyɛɛ́ Jɔn áfyɛ denɔ. Jisɔs atáné né gebagé mewaá Judiya afɛ́ né Galilií agarege abya melɔ́mélɔ́ ayi atané mbaá Ɛsɔwɔ. ");
INSERT INTO anvNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Ajɔɔ́ge aké, “Lyage gabo nyú dékámé ne abya Ɛsɔwɔ melɔ́mélɔ́ ɛlé gébé ɛyigé Ɛsɔwɔ ágbarege gefwa jií gelá kwɔ́kwɔ́lé.” ");
INSERT INTO anvNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Bií fɔ Jisɔs abɔ́ akoóge né mbále ɛbɛɛ́ mega ɛwé ɛlu né Galilií, agɛ́ Simun ne meŋmó wuú Andru, áŋmée utófó bwɔ́, ɛlé álu áwáné meshuú. ");
INSERT INTO anvNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Jisɔs ajɔɔ́ ne ɛbwɔ́ aké, “Kwɔ́lege me, nlɛrege nyɛ ɛnyú ndɛre ákpálege bɔɔ́ ɛké meshuú.” ");
INSERT INTO anvNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Tɛ́nétɛ́né yimbɔ, ɛbwɔ́ álya utófó ɛbwɔ́, ne ákwɔlé ji. ");
INSERT INTO anvNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Ndɛre Jisɔs ályá ɛfɛɛ́ ajyɛɛ́ mbɛ gachyɛ, agɛ́ Jɛmsi ne Jɔn meŋmo wuú, ɛbwɔ́ álú baá Sɛbɛdee. Ábɔ́ álú mmu ɛ́kpée átome upaá utófó bwɔ́. ");
INSERT INTO anvNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Akuú ɛbwɔ́, ne yɛ́ gébé áchɔ wɔ́ álya ntɛ ɛbwɔ́ Sɛbɛdee né mmu ɛ́kpée ne bɔɔ́ utɔɔ́ abi ɛbwɔ́ ásɛlé, ne ákwɔlé ji. ");
INSERT INTO anvNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Jisɔs ne baá utɔɔ́ bií áfɛ́ né Kapanɔm, bií uwyaá bɔɔ́ Jus ukwɔ́négé afɛ́ né ɛcha mmyɛmenɛne alɔ mánlɛ́régé. ");
INSERT INTO anvNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Bɔɔ́ áwu nkane ji alɛ́rege ála mano mekpo fuú né gefɔɔ́ ɛyígé ji álɛ́rege néndé álɛ́rege ne ncha ayi atane mbaá Ɛsɔwɔ ɛ́pɔ́fɔ́ ɛke ánlɛré mabɛ́ Ɛsɔwɔ. ");
INSERT INTO anvNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Mende fɔ ayi awya meló nchyɛ abɔ alu ntó mmu ɛcha mmyɛmenɛne, aké agɛ́ne Jisɔs alɔ mánkalégé aké, ");
INSERT INTO anvNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Jisɔs ayi Nasarɛt, ɔkɛlege mampyɛ ɛsé ndé? Ɔchwɔ́ manií ɛsé mbwɛ? Nkage wɔ, ɔlu Muú Ukpea ayi atané mbaá Ɛsɔwɔ.” ");
INSERT INTO anvNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Jisɔs anyá meló nchyɛ yimbɔ aké, “Kwéné mejɔɔ́, táné ji mmyɛ.” ");
INSERT INTO anvNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Meló nchyɛ yimbɔ apyɛ ji akalé akwé mme achu gbokgbok ne atané ji mmyɛ. ");
INSERT INTO anvNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Bɔɔ́ ako ágɛ́gé gefɔɔ́ yina ala mano mekpo fuú ne ágige atɛ áké, “Ɛwé ɛtané ɛfɔ́? Ndɔfɔ ɛlé gefɔgé geno ɛyi gekɛ ne utoó? Mende yina awya uto mányá áló nchyɛ ne áwúu ji.” ");
INSERT INTO anvNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Ɛwya wɔ́, ngɔ́ Jisɔs akwɔ́ akwɔné gebagé mewaá Galilií geko. ");
INSERT INTO anvNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Jisɔs, Jɛmsi ne Jɔn ályágé ɛcha mmyɛmenɛne, ɛbwɔ́ ako áfɛ́ cho né gepúgé Simun ne Andru. ");
INSERT INTO anvNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Ne mmá mendée Simun ameé njaja gefwine abɛlé mfaá ukwɔ́, ágare Jisɔs nnó mendée yimbɔ ameé. ");
INSERT INTO anvNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Awuúge mbɔ atɛne ji nekune mmyɛ agbaré ji ɛbwɔ abwɛ ji akwilé ajwɔle ka. Tɛ́nétɛ́né yimbɔ gefwine gebyɛ́ ji mmyɛ ne mendée yimbɔ achyɛ́ ɛbwɔ́ menyɛɛ́. ");
INSERT INTO anvNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Ne nkwale akwɔnege, gébégé mŋmɛɛ́ ɛpwyaá, bɔɔ́ áchwɔ́ ne bɔɔ́ mameé ako ne yɛ abi aló nchyɛ áchyɛ́ge ɛbwɔ́ ɛfwyale mbaá Jisɔs. ");
INSERT INTO anvNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Ne gemɛge melɔ geko gechwɔ́ chóme né menombi gepú ɛyige Jisɔs álu. ");
INSERT INTO anvNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Ɛfɛɛ́ ne Jisɔs apyɛ́ gejamégé bɔɔ́ bi ámeé ufɔɔ́ mameé atoó ne ama féré abifɔ gejamégé aló nchyɛ mmyɛ. Akámé fɔ́ aló nchyɛ abifɔ ájɔɔ́ mejɔɔ́ wɔ́ néndé ákaá gefɔ́gé muú yi ji álu. ");
INSERT INTO anvNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Dondo gemuá mme Jisɔs akwile afɛ́ né melu ɛ́wé bɔɔ́ álá pɔ́ wyɛɛ́, anɛnemmyɛ. ");
INSERT INTO anvNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Simun ne abifɔ álɔ ji mánkɛlé. ");
INSERT INTO anvNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Ágɛ́gé ji áké, “Yɛ́ndémuú akɛlege wɔ.” ");
INSERT INTO anvNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Jisɔs aké ne ɛbwɔ́, “Ɛsé debɔ manjyɛ ntó mata malɔ ayifɔ nnó ngaré ntó ɛbwɔ́ mekomejɔɔ́ Ɛsɔwɔ nende gɛ́ genó ɛyi gepyɛ́ me nchwɔ́ mbɔ.” ");
INSERT INTO anvNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Ne Jisɔs akɛ né gebagé mewaá Galilií geko agarege mekomejɔɔ́ Ɛsɔwɔ né mmu macha mmyɛmenɛne bwɔ́ ne aférégé bɔɔ́ aló nchyɛ mmyɛ. ");
INSERT INTO anvNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Bií uma, muú ubá fɔ achwɔ́ tó mánó mbɛ ushu Jisɔs, anɛ ji mmyɛ aké, “Mbɔgé ɔkɛlege, pyɛ me nkpea.” ");
INSERT INTO anvNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Jisɔs áwuúgembɔ meshwɛ akwɔ́ ji metɔɔ́, anyaá ɛbwɔ wuú ata ji aké, “Nkɛlege, kpea.” ");
INSERT INTO anvNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Ájɔ́gémbɔ ubá mende yimbɔ ubyɛ, akpea. ");
INSERT INTO anvNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Jisɔs anerege, aké alyaáge mende yimbɔ nnó ajyɛ, aji ji ɛtu, ");
INSERT INTO anvNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","ajɔɔ́ ne ji aké, “Ɛ́kagé ɔ́pyɛ muú fɔ́ akaá genó ɛyi gépyɛ ne wɔ. Chó lɛ́ré lé mmyɛ jyɛ́ mbaá mémpyɛ́ upɛ Ɛsɔwɔ áchɛ́ré agɛ́ nnó ɔtoó. Ne chyɛɛ́ genó ɛyígé ɛbɛ́ Mosis ɛ́jɔɔ́, mampyɛ bɔɔ́ ákaá nnó ɔtoó.” ");
INSERT INTO anvNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Yɛ́mbɔ mende yina ajyɛge akɛ agaré abya yina mbaá meko, ne gegare ɛyi gepyɛ Jisɔs kpɛné sé melɔ gbɔ́gɔ́nɔ́ ajwɔle shushu, ne yɛ́mbɔ bɔɔ́ átánege yɛ́ndé mbaá áchwɔ́ wyɛ ɛta wuú. ");
INSERT INTO anvNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Jisɔs ábɛ́légé ɛ́wu mboó ndɔ, ama akéré meso né Kapanɔm ne bɔɔ́ áwú nnó alú mmu. ");
INSERT INTO anvNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Gejamégé bɔɔ́ áchwɔ chome né mmu gepú, ágbeé kpaá melu ɛpɔ́ sé yɛ́ né menombi. Ne Jisɔs abɔ́ agaregé ɛbwɔ́ mekomejɔɔ́ Ɛsɔwɔ. ");
INSERT INTO anvNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Ndɛre alɛrege ande fɔ aníi, ákpá muú úchánchi né ulɔ́ áchwɔ ne ji mbaá Jisɔs. ");
INSERT INTO anvNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Ákwɔnégé ágɛ́ fɔ́ meti mánkpɛ ne ji mmu gepú wɔ́, gétúgé bɔɔ́ ájamé dɔɔ́, ákwɔ́ mfaá gepú átí ɛmbu né mfaá nchu mbaá yi Jisɔs alu. Ánérégé ábwɛ mende yimbɔ ne gebɔ, ápyɛ́ ji ashule mme. ");
INSERT INTO anvNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Jisɔs agɛ́gé ndɛre bɔɔ́ bimbɔ áfyɛɛ́ matɔɔ́ ne ji, aké ne mende úchánchi yimbɔ, “Maá wa, ájiínte gabo wyɛɛ́.” ");
INSERT INTO anvNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Ɛke ɛpyɛɛ́mbɔ ánlɛré mabɛ́ Ɛsɔwɔ fɔ abɔ́ alú ɛfɛɛ́, áwúgembɔ álɔ mangígé né matɔɔ́ ɛbwɔ́ nnó ndé muú na? ");
INSERT INTO anvNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Ɛpyɛ nnó ne mende yina ábyaá Ɛsɔwɔ. Ajɔɔ́ ɛké ji alu Ɛsɔwɔ. Ɛsɔwɔ mbií ne akage jinte gabo muú.” ");
INSERT INTO anvNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Jisɔs akaá mɛ genó ɛyige ɛbwɔ́ áfɛ́régé né mmu matɔɔ́ bwɔ́, agií ɛbwɔ́ aké, “Ulannó ɛnyú déwya gefɔgé ufɛ́ré bimbɔ né matɔɔ́ nyú? ");
INSERT INTO anvNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Ndé gelu pere manjɔɔ́ ne muú uchánchi, ‘Nnó ájiínte gabo wyɛ́,’ waá manjɔɔ́ nnó, ‘Kwile tɛ́né, pwi gebɔ jyɛ kɛ ɔ́jyɛ.’ ");
INSERT INTO anvNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Nkɛlege mámpyɛ ɛnyú dékaá nnó Maá Ntɛ Mekwaá awyaá uto fa mme manjinte gabo mekwaá.” Jisɔs aké ne mende úchánchi yimbɔ, ");
INSERT INTO anvNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Kwile tɛ́né, pwi gebɔ jyɛ́, ɔjyɛ mmu.” ");
INSERT INTO anvNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Ajɔgembɔ, mende yimbɔ akwilé tɛ́né mbɛ ushu bwɔ́ ako, apwi gebɔ awulé né gepú jií. Ne bɔɔ́ ako alá mano mekpo fuú, áfɛɛ́ge Ɛsɔwɔ ake, “Ɛse delú daŋgɛ́ gefɔ́ geno ɛyige na.” ");
INSERT INTO anvNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Bií fɔ́ Jisɔs ama jyɛ né mbále géntoógé mewaá Galilií. Ne gejamégé bɔɔ́ áchwɔ nɔ́ ji mme, alɔ manlɛré ɛbwɔ́ mekomejɔɔ́ Ɛsɔwɔ. ");
INSERT INTO anvNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Ndɛre Jisɔs álya ɛfɛɛ́ akɛne ajyɛ, agɛ́ Lɛvi maá Alfɔs. Ajwɔlé né melú utɔɔ́ wuú ásɛle ŋkámakpo. Jisɔs akuú ji aké, “Kwɔ́lé me.” Ne akwilé ka alɔ mankwɔlé ji. ");
INSERT INTO anvNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Ɛ́wyágé ndɛre Jisɔs ajwɔle ányɛɛ́ menyɛɛ́ ne baá utɔɔ́ bií né gepúgé Lɛvi, gejamégé ánsɛlé ŋkámakpo ne bɔɔ́ ubeé ne gejámégé bɔɔ́ abifɔ abi ákwɔlege Jisɔs, abɔ́ ányɛɛ́ ntó menyɛɛ́ ne ji. ");
INSERT INTO anvNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Ne ánlɛré mabɛ́ Ɛsɔwɔ fɔ́ abi alú bɔɔ́ Farasi, ágɛ́gé nkane Jisɔs anyɛɛ́ menyɛɛ́ ne ánsɛlé ŋká makpo ne bɔɔ́ ubeé, ágií baá utɔɔ́ bií áké, “Ulannó ne Jisɔs anyɛɛ́ menyɛɛ́ ne ánsɛlé ŋkámakpo ne bɔɔ́ ubeé?” ");
INSERT INTO anvNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Jisɔs awúgé genó ɛyígé ɛbwɔ́ ágií baá utɔɔ́ bií, ató ɛbwɔ́ neka aké, “Bɔɔ́ abi álá meé, ákɛ́légé fɔ́ muú uka, ɛ́lé abi ámeé ne ákɛ́lege. Ne me nchwɔ́ fɔ́ fa mme mánkú bɔɔ́ abi álu cho né Ɛsɔwɔ wɔ́, nchwɔ́ lé mánku bɔɔ́ abi ápyɛɛ́ ubeé.” ");
INSERT INTO anvNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Bií fɔ́ baá utɔɔ́ Jɔn ménwyaá bɔɔ́ manaá Ɛsɔwɔ ne abi bɔɔ́ Farasi, ályá menyɛɛ́ kpékpé getúgé depɔré Ɛsɔwɔ. Ne bɔɔ́ fɔ́ ágɛ́gé mbɔ áchwɔ gíi Jisɔs áké, “Ulannó baá utɔɔ́ Jɔn ne abi bɔɔ́ Farasi ályage menyɛɛ́ kpékpé, ne abyɛɛ́ álá pyɛ mbɔ?” ");
INSERT INTO anvNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Ne Jisɔs ashuú ɛbwɔ́ meko aké, “Nnó ájeé menɔ neba ályage menyɛɛ́ kpékpé ayi menɔ neba alú ne ɛbwɔ́? Ákáge lyaá fɔ́. ");
INSERT INTO anvNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Yɛ́mbɔ gébé gebɛɛ́ nyɛ ɛyígé menɔ neba álá bɛɛ́ nyɛ́ sé ne ɛbwɔ́, ɛ́fɛɛ́ ne ályáge nyɛ́ menyɛɛ́ kpékpé né mboó gébé gétúgé depɔré Ɛsɔwɔ.” ");
INSERT INTO anvNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Jisɔs ama tó makámejɔɔ́ ayifɔ́ aké, “Ne muú akaágé sɛ́ fɔ́ gebagé ndeé gekɛ akwɔmé ɛmbu né ndeé ɛyi gekwéne. Apyɛgé mbɔ gebagé ndeé ɛyigembɔ génywerege nyɛ gépyɛ ndeé yimbɔ ɛgyalé dɔɔ́. ");
INSERT INTO anvNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Ne muú akpané fɔ́ mmɔɔ́ makɛ áfyɛ né ukwéne unó mmɔɔ́ ɛbi akwyɛɛ́ ne mekɔ menya. Apyɛgé mbɔ, mmɔɔ́ mimbɔ mamuale nyɛ mapyɛ unó mmɔɔ́ bímbɔ úgbɔ́. Mmɔɔ́ ne unó mmɔɔ́ ɛbimbɔ uchɔge nyɛ detú. Áfyɛ le mmɔɔ́ makɛ né unó ukɛ.” ");
INSERT INTO anvNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Né bií uwyaá bɔɔ́ Jus fɔ, Jisɔs ne baá utɔɔ́ bií ákoóge né mekɔɔ́ gefɔgé nchi fɔ ɛyi ákuú nnó wid. Ndɛre ɛbwɔ́ ákoóge né mmu mekɔ wembɔ, baá utɔɔ́ bií álɔ mánkɔ́gé gefɔgé nchi ɛyimbɔ álálege ányɛɛ́. ");
INSERT INTO anvNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Ne bɔɔ́ Farasi fɔ ágɛgé mbɔ, ájɔɔ́ ne Jisɔs áké, “Gɛ́ ɛbɛ́ se ɛ́kámé fɔ́ nnó baá utɔɔ́ byɛ́ ákɔɔ́ nchi bií uwyaá wɔ́.” ");
INSERT INTO anvNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Jisɔs ashuú ɛbwɔ́ meko aké, “Ɛnyú délú danjɔɔ́ né mmu ŋwɛ Ɛsɔwɔ dékaá genó ɛyigé mfwa Dɛvid ápyɛ́ nyá gébégé mesa ámmyɛ ji ne bɔɔ́ bií wɔ́? ");
INSERT INTO anvNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Akpɛ nyá mmu ɛcha upɛ Ɛsɔwɔ, abɔ́ brɛd ayi abɔ́ ájelé áchyɛ mbaá Ɛsɔwɔ ányɛ́. Ɛwe ɛbɛ se ɛké muú yicha anyɛ fɔ́ menyɛɛ́ yi ajéle áchyɛ mbaá Ɛsɔwɔ, ɛkose ámpyɛ upɛ Ɛsɔwɔ wɔ́. Yɛ́ mbɔ Dɛvid ábɔ́ anyɛ́ achyɛ ntó bɔɔ́ bií.” Mechɔ́ ɛwe ɛpyɛ gébégé Abyata alu mfwa ámpyɛ́ upɛ Ɛsɔwɔ. ");
INSERT INTO anvNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Jisɔs aŋmɛre ajɔɔ́ ne ɛbwɔ́ aké, “Ákwyɛ́ fɔ́ mekwaá gétúgé bií uwyaá wɔ́, ákwyɛ́ lé bií uwyaá gétúgé mekwaá. ");
INSERT INTO anvNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Nkɛlege mangaré ɛnyú nnó Maá Ntɛ Mekwaá ne alú Ata ayi abɔɔ́ utó mangaré mekwaá genó yi abɔ mampyɛ bií uwyaá bɔɔ́ Jus.” ");
INSERT INTO anvNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Jisɔs ama jyɛ né ɛcha mmyɛmenɛne ne mende ayi ɛbwɔ ɛgboó ji abɔ́ alú wyɛ. ");
INSERT INTO anvNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Ɛ́fɛɛ́ mbɔntó, bɔɔ́ fɔ́ abi ákɛ́lege meti mánjɔɔ́ nnó Jisɔs ápyɛ genó gebo álú wyɛ ápɛ́le ji dome mangɛ nnó apyɛ nyɛ mende yimbɔ atoó né bií uwyaá bwɔ́ ne ájɔɔ́ nnó ákwé ɛbɛ́. ");
INSERT INTO anvNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Jisɔs aké ne mende yimbɔ, “Kwilé, chwɔ́ tɛ́né mbɛ ushu bwɔ́.” ");
INSERT INTO anvNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Agií ɛbwɔ́ aké, “Ɛbɛ́ ɛsé ɛké depyɛ ndé né bií uwyaá? Ɛke dépyɛ galɔ́gálɔ́ wá gabogabo? Mampyɛ mekwaá apó wá mánlyaá ji agbó?” Ne yɛ́ muú ayi anené meko apɔ́. ");
INSERT INTO anvNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Metɔɔ́ ɛsɔɔ́ Jisɔs dɔɔ́ apɛ ɛbwɔ́ agyaá yɛ́mbɔ meshwɛ akwɔ́ ji metɔɔ́ gétúgé áŋeá matɔɔ́. Ajɔɔ́ ne mende yimbɔ aké, “Nyaá ɛbwɔ wyɛ.” Ányágé ɛbwɔ wuú ɛtoó. ");
INSERT INTO anvNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Tɛ́nétɛ́né yimbɔ bɔɔ́ Farasi átáné dafyɛ ájyɛ báne ɛkwɔ́ Hɛrɔd, ásɔ́ mala nnó ápyɛ Jisɔs áwá. ");
INSERT INTO anvNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Jisɔs ne baá utɔɔ́ bií ályaá áfɛ́ ne mbále gentoge mewaá Galilií, né gejamégé bɔɔ́ ákwɔlége ji abi átáné gebage mewaá Galilií, Judiya, ");
INSERT INTO anvNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Jɛrosalɛ, Idumiya, abi átáné ɛgbɛ́ ɛbɛɛ́ Jodan, ne gebagé mewaá ɛyi gelu kwɔ́kwɔ́lé ne Tiya ne Sidɔn. Bɔɔ́ bina áko ábɔ́ áchwɔ ɛfɛɛ́ gétúgé áwú unó bi Jisɔs ápyɛɛ́. ");
INSERT INTO anvNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Jisɔs agaré baá utɔɔ́ bií nnó ákwyɛ ɛkpeé ji akpɛ mmu, néndé bɔɔ́ ája dɔɔ́ ɛkagé áŋmɛ́ré ji mme. ");
INSERT INTO anvNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Ne gétúgé ji apyɛ gejamégé bɔɔ́ atoó, bɔɔ́ mameé ako ámmyɛ mánchwɔ́ ji mmyɛ nnó áta ji. ");
INSERT INTO anvNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Yɛ́ndégébé bɔɔ́ bi áwya aló nchyɛ ágɛgé Jisɔs, aló nchyɛ bimbɔ ápyɛ ɛbwɔ́ akwéne mme mbɛ ushu wuú ákálege áké, “Wɔ ɔlu Maá Ɛsɔwɔ.” ");
INSERT INTO anvNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Yɛ́mbɔ Jisɔs anyáne abi nnó ɛ́kágé ájyɛ ágáré bɔɔ́ ákaá gefɔge muú yi ji alu. ");
INSERT INTO anvNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Ɛ́wyagé Jisɔs afɛ́ mfaá mekwɛ́, akuú bɔɔ́ bí ji akɛlege nnó ákwɔ́le ji, áchwɔ́gé, ");
INSERT INTO anvNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","ajya bɔɔ́ áfyanéápeá nnó ábɛ́ ne ji, achyɛ ɛbwɔ́ mabo nnó áŋgbá. Agare ɛbwɔ́ aké, “Ntɔ́me nyɛ ɛnyú dafyɛ nnó déjyɛ́ degarége mekomejɔɔ́ Ɛsɔwɔ melɔ́mélɔ́, ");
INSERT INTO anvNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","ne uto bií déférégé aló nchyɛ bi áchyɛge bɔɔ́ ɛfwyale mmyɛ.” ");
INSERT INTO anvNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Gɛ mabɔ bɔɔ́ abi ji ajyá na, Simun ayi Jisɔs achyɛ ji mabɔ amifɔ nnó Pita, ");
INSERT INTO anvNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Jɛmsi ne meŋmɛ wuú Jɔn baá Sɛbɛdee, Jisɔs achyɛ bwɔ́ mabɔ nnó Banagis, ula útɛné nnó baá nénfée. ");
INSERT INTO anvNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andru, Filip, Batolomyo, Matyo, Tɔmasi, Jɛmsi maá Alfɔs, Tadyɔs ne Simun ayi alu muú ɛkwɔ bɔɔ́ Kanɛnia, ");
INSERT INTO anvNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","ne Judas Iscarot ayi meso gébé achyɛ́ Jisɔs maŋkwaá. ");
INSERT INTO anvNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Ndɛre bɔ Jisɔs akérégé mmu, gejamégé bɔɔ́ ama chwɔ́ ɛfɛɛ́ ája kpaá ápyɛ ji ne ákwɔlé bií gébé gepɔ́ ɛyi ɛbwɔ́ ákáge nyɛɛ́ yɛ́ menyɛɛ́. ");
INSERT INTO anvNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Bɔɔ́ ula gepú Jisɔs áwuúge ndɛre bɔɔ́ ájɔ́ge nnó Jisɔs alé meé gebwɔ́ áfɛ́ manjyɛ sɛ ji. ");
INSERT INTO anvNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Ne ánlɛré mabɛ́ Ɛsɔwɔ fɔ abi átané Jɛrosalɛ ábɔ́ ájɔɔ́ge áké, “Jisɔs awya melo nchyɛ ayi ákuú nnó Bɛlsɛbɔb mfwa áló nchyɛ. Ji ne achyɛ́gé Jisɔs utó nnó ábúgé aló nchyɛ.” ");
INSERT INTO anvNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Jisɔs awúgembɔ, akúu bɔɔ́ bimbɔ nnó áchwɔ́, áchwɔ́ge alɔ mántó ɛbwɔ́ makámejɔɔ́ aké, “Danchɔmeló ákáge bú mbɔ gemɛ jií nnó? ");
INSERT INTO anvNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Mbɔgé melɔ ɛkarégé ɛké ɛmyɛ́ ne atɛ, melɔ ɛwémbɔ ɛtɛ́négé. ");
INSERT INTO anvNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Mbɔgé ula gepú ukarégé, uké umyɛ ne atɛ utyage. ");
INSERT INTO anvNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Ne mbɔgé danchɔmeló aké amyɛ ne bɔɔ́ bií, ɛbyɛnnó ɛwú ɛbyɛ. ");
INSERT INTO anvNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“Muú ákaágé kpɛ fɔ́ gepúgé meto muú ájó genó mbɔgé álá bɔmbɛ áwɛ́ ji wɔ. Ɛ́kosé nnó abɔgé mbɛ awɛge ji ne ákaáge kpɛ ajó yɛ́ndégenó. ");
INSERT INTO anvNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Ne ɛnyú kaáge wáwálé nnó Ɛsɔwɔ ajigente gabo yi muú apyɛ ne mejɔɔ́ mebomebo ɛwé ɛ́tánege ji meno. ");
INSERT INTO anvNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Yɛ́mbɔ ájígé fɔ́ nte muú ayi ájɔ́gé mejɔɔ́ mebomebo ne Mendoó Ukpea, gabo yimbɔ alaá ji mmyɛ tɛ kwyakwya.” ");
INSERT INTO anvNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","(Jisɔs ajɔ́mbɔ gétúgé bɔɔ́ ábɔ́ ájɔgé nnó, “Ji awyaá meló nchyɛ.”) ");
INSERT INTO anvNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Mmá Jisɔs ne aŋmó bií áchwɔ́ tɛ́ne dafyɛ, átɔ́ muú nnó akúu ji. ");
INSERT INTO anvNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Ne gejamégé bɔɔ́ bí ájwɔ́lé ánɔɔ́ Jisɔs mme, ágaré ji áke, “Mmá wyɛ ne aŋmó byɛɛ́ álú dafyɛ ákɛ́lege wɔ.” ");
INSERT INTO anvNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Jisɔs ashuú ɛbwɔ́ meko aké, “Gɔge me ngaré ɛnyú ntó muú ayi alú mmá wa ne áŋmó ba”. ");
INSERT INTO anvNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Abwɔlé apɛ bɔɔ́ bí ájwɔlé ánɔɔ́ ji mme aké, Gɛ́ge mmá wa ne aŋmó ba na. ");
INSERT INTO anvNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Yɛ́ndémuú ayi awuú ne ápyɛ́ genó ɛyígé Ɛsɔwɔ ákɛlege, ji ne alú meŋmó wa ne mmá wa. ");
INSERT INTO anvNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Gébé gefɔ́ Jisɔs afɛ né mbale géntoógé mewaá Galilií, alɔ mánlɛre mekomejɔɔ́ Ɛsɔwɔ ɛwu. Gejamégé bɔɔ́ ákwɔlé ji áfɛ́ ɛwu. Ji ágɛ́gé nnó bɔɔ́ bimbɔ ájá dɔɔ́, ajyɛ kpɛ ajwɔlé mmu ɛ́kpée ɛwé ɛ́lú mbále mewaá. Bɔɔ́ bimbɔ álaá né mbale gentóo mewaá. ");
INSERT INTO anvNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Álɛrege ɛbwɔ́ gejamégé unó né makámejɔɔ́. Ndɛre ábɔ́ alɛ́rege aké, ");
INSERT INTO anvNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Wuúge! Bií uma mempyɛ makɔɔ́ fɔ afɛ́ manjyɛ tya mbwɛ́ né mekɔɔ́ wuú. ");
INSERT INTO anvNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Ndɛre átyaá ájyɛɛ́, ámɛ́ mbwɛ́ áyifɔ́ ákwé né maá meti ayi bɔɔ́ akoge wyɛ, denywɔné dégɛ́gé déchwɔ chwɛ́ dényɛ́. ");
INSERT INTO anvNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Ámɛ́ áyifɔ́ ákwé né mfaá mme ɛtárávɛ́ mbaá ayi mme álá jaá wyɛ wɔ́. Ɛbɛlé yɛɛ́ wɔ́ áchií. Ne ɛ́lé mme álá jaá wyɛ wɔ́. ");
INSERT INTO anvNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Ŋmɛɛ́ ɛ́tyɛ́gé, ɛdo mbwɛ́ yimbɔ, ne ɛlé maka álá kpɛ mme chánchá wɔ́, adɛ́ agbó. ");
INSERT INTO anvNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Ámɛ́ ayífɔ́ ákwé né mme ayi genkpé ntó géchíge wyɛ, áchígé, genkpé ɛyigémbɔ géwɛ́ gekweré mbwɛ́ yimbɔ, meshií ɛjo agbó, mbwɛ́ yimbɔ áfyɛ́ ulɔ wɔ́. ");
INSERT INTO anvNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Yɛ́mbɔ ámɛ́ ayífɔ́ ákwé né mme melɔ́mélɔ́, awɛ́gé áfyɛ́ ulɔ, ayifɔ áfyɛ ulɔ ɛsaá mesó ɛfya, ayifɔ áfyɛ usaá ulɛ́ɛ ne ayifɔ usaá uta apwɔ nkane ábɔ́ átyá.” ");
INSERT INTO anvNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Jisɔs ánérégé manto nekanemejɔɔ́ ɛníne na aké, “Muú yi áwyaá matu mawú, áwú.” ");
INSERT INTO anvNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Ɛwyágé Jisɔs alyaá gejamégé bɔɔ́ bimbɔ ala mmyɛmmyɛ jií, áŋgba bií áfyáneápea ne bɔɔ́ bifɔ abi álu kwɔ́kwɔ́le ne ji ágií ji ula bi ji atome makamejɔɔ́. ");
INSERT INTO anvNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Aké ne ɛbwɔ́, “Ɛ́lé ɛnyú ne Ɛsɔwɔ apyɛ́ nnó dékaá gbɔgɔnɔ unó bi úlú nya bibí né gefwa jií, ne abi álá pɔ́ né gelua genyú, ntome lé ɛbwɔ́ makamejɔɔ́, ");
INSERT INTO anvNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","nnó, ‘Ápɛle wyɛ́ pɛle yɛ́mbɔ ágɛgé fɔ́; ne awuúge lé wúu, yɛ́mbɔ ákágé fɔ́ ula; Nnó ɛkágé ákéré meso mbaá Ɛsɔwɔ ajige nte gabo bwɔ́.’” ");
INSERT INTO anvNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Ne Jisɔs aké ne ɛbwɔ́, “Ɛnyú delá ká mbɔ ula nekanémejɔɔ́ ɛni na wɔ́, depyɛmbɔ nnó ne dekaá ayifɔ?” ");
INSERT INTO anvNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Mbwɛ ayi mempyɛ́ mekɔɔ́ atyá mbɔ, ɛ́lé mekomejɔɔ́ Ɛsɔwɔ. ");
INSERT INTO anvNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Gejamégé bɔɔ́ bifɔ álu ɛké mbwɛ́ ayi ákwené meti, ɛbwɔ́ áwúgé mekomejɔɔ́ Ɛsɔwɔ, tɛ́nétɛ́né danchɔmeló achwɔ́ aféré mekomejɔɔ́ yimbɔ né mmu matɔɔ́ bwɔ́. ");
INSERT INTO anvNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Bɔɔ́ ábifɔ álu ɛké mbwɛ́ ayi ákwené né mfaá mme ɛtárávɛ́, áwúgé mekomejɔɔ́ Ɛsɔwɔ tɛ́nétɛ́né yimbɔ, ásɛ ji ne nechɔ́chɔ́. ");
INSERT INTO anvNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Yɛ́mbɔ mekomejɔɔ́ Ɛsɔwɔ ájwɔle ɛbwɔ́ né mmu metɔɔ́ wɔ́ néndé álú ɛke genɔɔ́ ɛyi gelá gepɔ́ ne maka né mme. Ne ábɔgé ɛfwyale mangɛ́ ndɛre bɔɔ́ ápaá ɛbwɔ́ gétúgé mekomejɔɔ́ yimbɔ, tɛ́nétɛ́né ájá mmyɛ meso. ");
INSERT INTO anvNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","“Bɔɔ́ abifɔ álu ɛké mbwɛ́ ayi ákwené né mme genkpé meshií ɛjomé. Ɛbwɔ́ bina álú ɛké bɔɔ́ abi áwugé mekomejɔɔ́ Ɛsɔwɔ, ");
INSERT INTO anvNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","yɛ́mbɔ ɛlé ɛbwɔ́ áwyá mmwɔlé né unó mme, ábɔɔ́ gejeé ne ŋka ne ufɔɔ́ unó uko bí ɛbwɔ́ ákɛ́lege, unó bina ujo mekomejɔɔ́ yimbɔ upyɛɛ́ ɛbwɔ́ áwɔ umpome ulɔ́úlɔ́ wɔ́. ");
INSERT INTO anvNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Yɛ́mbɔ bɔɔ́ abifɔ álú ɛké mme melɔ́mélɔ́, ɛbwɔ́ áwúgé mekomejɔɔ́ Ɛsɔwɔ ásɛ ji áfyɛ mmu geŋwáge bwɔ́, áwɔme umpome ulɔ́úlɔ́, abifɔ áfyɛ ulɔ ɛsaá meso áfya, abifɔ usaá ulɔ ulɛɛ́, ne abifɔ ntó usaá ulɔ uta ɛpwɔ́ nkane abɔ́ ápɛné.” ");
INSERT INTO anvNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Jisɔs ama jɔɔ́ ne ɛbwɔ́ aké, “Muú akágé lwɛ fɔ́ ɛ́túléŋká abɔ gesá ákweré yɛ́ mambelé ɛ́wú né nteé ukwɔ́. Aŋma ɛwú mfaá. ");
INSERT INTO anvNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Yɛ́ genó ɛyi gebɛɛ́ biíbí bɔɔ́ álá kágé nyɛ gépɔ́. Ne genó fɔ́ gépɔ́ ɛyigé ákwérégé gejí bɔɔ́ álá kágé. ");
INSERT INTO anvNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Mbɔgé muú awya matu, awú.” ");
INSERT INTO anvNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Ajɔɔ́ ntó ne ɛbwɔ́ aké, “Sɛ́ge gébé nkane ɛnyú déwúu depɔ. Gefɔɔ́ ɛyígé démɛge genó déchyɛ́ge muú, mbɔntó ne ámɛge nyɛ áchyɛɛ́ ɛnyú. Ne achyɛ́ge nyɛ ntó ɛnyú ɛyi géjame gepwɔɔ́. ");
INSERT INTO anvNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Muú ayi awya genó, ji ne ágbɛ́ge nyɛ́ ji ɛbwɔ, ne muú ayi álá pɔ́, yɛ́ ɛ́kɛ́kɛ́ ɛwé ji awya, ásɛ́le nyɛ ɛta wuú.” ");
INSERT INTO anvNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Jisɔs ama jɔɔ́ aké, “Gefwage Ɛsɔwɔ gélú nkane mbwɛ́ ayi mempyɛ́ makɔɔ́ ápɛne. ");
INSERT INTO anvNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Alyaá afɛ́ apyɛ unó bií ɛbicha agɛ́ne ndɛre mbwɛ́ wuú áwɛ́ne, ne yɛ́ genó ɛyi gepyɛ mbwɛ́ wuú áwɛ́ne akágé. ");
INSERT INTO anvNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Ɛlé mme ne apyɛ nnó amɛ́ mbwɛ́ áchií, áwɛ́ ákwɔ́né áfyɛ́ ulɔ. ");
INSERT INTO anvNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Ne gébé ɛyígé mbwɛ́ yimbɔ ágɛ́légé mɛ mempyɛ makɔɔ́ achwɔ́ alɔ mansɔré ne ɛsaá nende gébé gekwɔné.” ");
INSERT INTO anvNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Ne Jisɔs ama agií ntó aké, “Ɛse dejɔge nnó gefwage Ɛsɔwɔ gélú nkane nde? Mmɛ́ge nyɛ́ geji ne ndé nekanémejɔɔ́? ");
INSERT INTO anvNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Gélú nkane mbeé mbwɛ́ ayí ákuú mɔsta, ápɛge alu ŋénéŋéné ɛke nyiné mbwɛ́ ngboŋ. ");
INSERT INTO anvNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Ɛ́bɛ́légé ndɛre ápɛ́ne néchií, néwɛ́, nébwɔlé gekpɛ́kpɛ́gé genɔɔ́ ɛyi gepwɔɔ́ unɔɔ́ uko, gefyɛ mata ayí denwyɔné débígé ŋmɛɛ́, détɛ́nege anyua bwɔ́ wyɛ́.” ");
INSERT INTO anvNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Jisɔs agaré bɔɔ́ mekomejɔɔ́ Ɛsɔwɔ né gejámégé makámejɔɔ́ alɛré ɛbwɔ́ né gefɔ ɛyige ɛbwɔ́ ákage káa ula. ");
INSERT INTO anvNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Ajɔ́gé fɔ́ ne ɛbwɔ́ ayi álá tómé makámejɔɔ́, yɛ́mbɔ gébégé abɛgé ji mbi ne baá utɔɔ́ bií ágarege ɛbwɔ́ úla yɛ́ndé mechɔ́. ");
INSERT INTO anvNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Ne nkwale Jisɔs ajɔɔ́ ne baá utɔɔ́ bií aké, “Déchyaá gentógé mewaá dejyɛ́ ɛgbɛ́ né.” ");
INSERT INTO anvNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Ne ɛbwɔ́ álya gejamégé bɔɔ́ ɛfɛɛ́, ne Jisɔs ajyɛ jwɔle mɛ́ mmu ɛ́kpe, ne baá utɔɔ́ bií achwɔ́ kpɛ́. Ɛbwɔ́ álɔ mánchya ne mákpée ayifɔ ákwɔlege. ");
INSERT INTO anvNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Ndɛre ájyɛ, mbyonnyi metometo áchwɔ́ bule nnyi ne ngba nnyi apyɛ nnyi nébúlege, apyɛ ɛ́kpe ɛnyige ne uto ne manaá malɔ mankpɛ́ne né ɛ́kpe, ɛla mankemanke. ");
INSERT INTO anvNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Jisɔs abɔ́ alú né meso ɛ́kpe, anɛré mekpo né genɔɔ́ge mekpo, abɛlege. Ne baá utɔɔ́ bií ájyɛ pe ji ájɔge áké, “Ménlɛré ɔbɔ gébé nnó ɛse dechwɔ́ gbó wɔ́?” ");
INSERT INTO anvNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Ne Jisɔs akwilé ka, anyá mbyo nnyi yimbɔ ajɔɔ́ aké, “Mgbannyi tɛné nyámeé.” Mbyo nnyi yimbɔ átɛné, mbaá akwené tɔmeé. ");
INSERT INTO anvNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Ɛwyage Jisɔs agií ɛbwɔ́ aké, “Défɔɔ́ ndé? Défyɛɛ́ fɔ́ matɔɔ́ ne Ɛsɔwɔ wɔ́?” ");
INSERT INTO anvNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Ála mano mekpo fuú áwére ne ɛfɔ metɔɔ́ ágíge atɛ áké, “Ndé gefɔgé muú na? Yɛ́ mbyo nnyi ne mgbannyi áwuú ji?” ");
INSERT INTO anvNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Jisɔs ne baá utɔɔ́ bií áchyagé gentoógé mewaá Galilií, ákwɔné mbale nnyi kwɔ́kwɔ́lé né gebagé mewaá Garɛsɛne. ");
INSERT INTO anvNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Ndɛre Jisɔs átané né ɛ́kpe ashule né mbale nnyi, mende fɔ yi awya meló nchyɛ atané né manome ayi áchomé né ɛtárávɛ́ abó gatɛlé áchwɔ́ báne ji, ");
INSERT INTO anvNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","ji ajwɔlege le né manome. Yɛ́ muú yi akáge wɛ́ se ji ne bɔ mkpokovɛ apɔ́, ");
INSERT INTO anvNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Ndɔ ndɔ ne ndɔ ábɔ́ áwɛ́le mɛ́ ji uka ne amu yɛ́mbɔ asɔrege bɔ ŋkpɔkovɛ ne use bi úlú ji uka agbɛ. Mende yina atoó kpaá apwɔ́ ayi muú álá kágé ba ji mme awɛ. ");
INSERT INTO anvNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Utuú ne nwɔmésé mende yimbɔ akɛne tametame né manome ne mfaá makwɛ, akalege ne asɔrege menyammyɛ wuú ne mataá awuú ubale. ");
INSERT INTO anvNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Aké agɛne Jisɔs tɛtɛ, abó gatɛlé, ajyɛ tó manó né mbɛ ushu Jisɔs. ");
INSERT INTO anvNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Apyɛgé mbɔ, alile akalege kéŋké aké, “Ɛ ɛ́ Jisɔs, Maá Ɛsɔwɔ Anyata! Ɔbɔ́ ndé mechɔ́ ne me? Kélé mabɔ Ɛsɔwɔ nnó ɔchyɛgé fɔ́ me ɛfwyale.” ");
INSERT INTO anvNT_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Ajɔgembɔ ɛlé Jisɔs abɔ́ anyane ji nnó, “Wɔ meló nchyɛ táné mende yina mmyɛ.” ");
INSERT INTO anvNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Ɛwyagé Jisɔs agií ji aké, “Mabɔ myɛ makamege nnó?” Mende yimbɔ ashuú ji meko aké, “Nkamege ‘Gejamé’, néndé ɛse delú gejamé.” ");
INSERT INTO anvNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ne aló nchyɛ anɛ Jisɔs mmyɛ nnó ɛkágé ábú ɛbwɔ́ átané né gebagé mewaá ɛyigémbɔ. ");
INSERT INTO anvNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Wyɛ ɛfɛɛ́, nfɔné mekwɛnde fɔ nébɔ́ nényɛɛ́ kwɔ́kwɔ́lé né mbyɔ Mékwɛ. ");
INSERT INTO anvNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Aló nchyɛ bimbɔ ánɛ Jisɔs mmyɛ nnó álya ɛbwɔ́ ájyɛ́ kpɛ mekwɛnde ɛyimbɔ mmyɛ. ");
INSERT INTO anvNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Jisɔs akamé. Aló nchyɛ bimbɔ átané ájyɛ kpɛ́ nfɔné mekwɛnde ɛníné mbɔ né mmyɛ. Ákpɛgé mbɔ, nébó néshulé Mékwɛ, nékwé mmu gentoóge mewaá néke. Nfɔné mekwɛnde ɛniné mbɔ nelú genógé bɔ dɛlé ápea. ");
INSERT INTO anvNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Ámbamé mekwɛnde yimbɔ ágɛ́gé, ábó afɛ́ né melɔ́ mangaré genó ɛyi gepyɛɛ́, abifɔ afɛ́ né makɔɔ́ ágarege abya yimbɔ. Ne bɔɔ́ átané nnó áchwɔ́ ágɛ mechɔ ɛwé ɛpyɛɛ́. ");
INSERT INTO anvNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Ne ɛbwɔ́ ákwɔ́négé mbaá ayi Jisɔs alu, ágɛ́ ntó mende ayi abɔ awya gejamégé aló nchyɛ ndɛre ajwɔlé ɛfɛɛ́ ne mandeé jií mmyɛ, akéré menyammyɛ wuú. Ɛbwɔ́ ágɛ́gé mbɔ ɛfɔ ɛkwɔ́ ɛbwɔ́ matɔɔ́. ");
INSERT INTO anvNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Bɔɔ́ bí abɔ ágɛné genó ɛyígé pyɛ́ álɔ mangaré mechɔ ɛwé ɛpyɛ ne mende yi abɔ́ awya aló nchyɛ, ágarege ntó mechɔ ɛwé ɛpyɛ ne mekwɛnde. ");
INSERT INTO anvNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Ne ɛbwɔ́ álɔ mánɛ Jisɔs mmyɛ nnó ályaá gebagé bwɔ́ ájyɛ. ");
INSERT INTO anvNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Ndɛre Jisɔs ábɔ́ akpɛ́ne mmu ɛkpée, mende yi abɔ awya aló nchyɛ anɛ Jisɔs mmyɛ nnó agɔ ji akwɔ́lé ji. ");
INSERT INTO anvNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Yɛ́mbɔ Jisɔs akamé wɔ́. Agare le ji aké, “Kere meso mbaá bɔɔ́ byɛ ne ɔgare ntó ɛbwɔ́ nkane Ɛsɔwɔ agɛné wɔ meshwɛ, apoó wɔ ne unó uko bi ápyɛɛ́ ɛta wyɛ́.” ");
INSERT INTO anvNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Mende yimbɔ afɛ́ né gebagé mewaá ɛyigé ákuú geji nnó Dekapolis, mme malɔ ufya, alɔ mankɛné ne agarege galɔ́gálɔ́ ayi Jisɔs ápyɛɛ́ ɛta wuú. Mechɔ ɛwena ɛ́pyɛ yɛ́ndémuú ayi awuú ala meno mekpo fuú. ");
INSERT INTO anvNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Bɔ Jisɔs ama kpɛ ɛ́kpe áchyá ákéré ɛgbɛ́ gentógé mewaá Galilií. Ne ndɛre atɛné mapeá nnyi, njuné bɔɔ́ néchwɔ́ nɔ́ ji mme. ");
INSERT INTO anvNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Ne Jarɔs muú kpaá né ɛcha mmyɛmenɛne ɛwe ɛlu ɛfɛɛ́ abɔ́ alu nto geluage bɔɔ́ bimbɔ. Gébégé agɛné Jisɔs, ajyɛ tó manó mbɛ ushu wuú. ");
INSERT INTO anvNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Alɔ manɛné Jisɔs mmyɛ ne metɔɔ́ wuú meko nnó apoó ji. Aké, “Maá wa ayi kɔɔ́ mendée ameé ne achwɔ́ gbó. Ata, chwɔ́ nɛre ji ɛbwɔ mmyɛ, apege nyɛ.” ");
INSERT INTO anvNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Jisɔs alya, alɔ manjyɛ ne Jarɔs. Ne njuné bɔɔ́ nekwɔlege ji, ɛgbɛ we ne ɛwe áŋmerege atɛ mme. ");
INSERT INTO anvNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Né geluage bɔɔ́ bimbɔ mendée fɔ abɔ́ alu ayi manoó mátánege ji mbɛ, málɛ́ aŋmɛ́ áfyáneápeá. ");
INSERT INTO anvNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Mendée yina agɛ́ mɛ ɛfwyale dɔɔ́, achɔ ŋka mbaá bɔ maka kpaá yɛɛ́ galɔ́gálɔ́ apɔ́. Yɛ́mbɔ ɛ́bɔ́ɔ wyɛ bɔ́ɔ. ");
INSERT INTO anvNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Mendée yimbɔ abɔ áwuú ngɔ Jisɔs akɛ né mpu ɛkwɔ́ bɔɔ́ ɛwémbɔ, achwɔ́ ji né meso, anyaá ɛbwɔ, atá nku wuú. ");
INSERT INTO anvNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Ajɔge ne gemɛ jií aké, “Mbɔgé ntagé yɛ́ lé mandée jií, ntoge nyɛ.” ");
INSERT INTO anvNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Atágé mbɔ, tɛ́nétɛ́né manoó mansɔ́. Ne awuú menyammyɛ wuú nnó atoó. ");
INSERT INTO anvNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Wyɛ né gébé ɛyigémbɔ Jisɔs awuú nnó uto útané ji mmyɛ, ábwɔlé mmyɛ ne njuné bɔɔ́ aké, “Waá ataá mandeé ya”? ");
INSERT INTO anvNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Baá utɔɔ́ bií áké ne ji, “Gɛ nkane gejámégé bɔɔ́ ánɔ́ɔ wɔ mme, ɛpyɛɛ́mbɔ nnó ne ɔgige nnó waá ataá wɔ?” ");
INSERT INTO anvNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Yɛ́ lé ɛbwɔ́ ájɔɔ́mbɔ, Jisɔs ashií wyɛ mampɛle agyage, agíge muú yi abɔ ataá ji. ");
INSERT INTO anvNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Mendée yimbɔ ákaáge genó ɛyigé gepyɛɛ́ né menyammyɛ wuú, atané metɔɔ́metɔɔ́ bɔɔ́ bimbɔ awere ne ɛfɔ metɔɔ́ achwɔ́ kwé mbɛ ushu Jisɔs. Apyɛge mbɔ, agare ji abya wuú meko. ");
INSERT INTO anvNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Ne Jisɔs aké ne ji, “Maá wa, ɔtoó getúgé ɔfyɛɛ́ metɔɔ́ wyɛ ne me. Ɔ́mágé wú sé ubale. Kɛ pere.” ");
INSERT INTO anvNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Ndɛre Jisɔs abɔ alú jɔɔ́ge ne mendée yimbɔ, bɔɔ́ dentɔɔ́ átané né gepúgé Jarɔs áchwɔ́ gáre Jarɔs áké, “Maá wyɛ agbó mɛ́, ɔchyɛgé sé ménlɛré ɛfwyale detú.” ");
INSERT INTO anvNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Ne Jisɔs afyɛɛ́ mekpo né depɔ ɛtiré ájɔgé wɔ́, yɛ́mbɔ aké ne Jarɔs, “Ɔfɔgé, fyɛ́ lé metɔɔ́ ne me.” ");
INSERT INTO anvNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Akamé fɔ́ nnó muú yicha akwɔlé ji wɔ́ ɛ́kosé Pita ne Jɛmsi ne meŋmó wuú Jɔn. ");
INSERT INTO anvNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Ákɛ́gé ákwɔ́négé gepúge Jarɔs, Jisɔs agɛ nkane bɔɔ́ ákwené tametame áyiáge, ádorege mmyɛ mme álíle keŋke. ");
INSERT INTO anvNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Jisɔs akpɛ́ mmu aké ne ɛbwɔ́, “Ndé ɛnyú déyiáge délíle? Maá mesɔ́ mendée yina agbo wɔ́, abɛlege lé géjyá.” ");
INSERT INTO anvNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Áwúgé mbɔ álɔ manjwáné ji jwané, ɛfɛɛ́ ne alé bú ɛbwɔ́ ako átané dafyɛ, asɛ́ le mma ne ntɛ maá yimbɔ ne baá utɔɔ́ bií alɛɛ́, ájyɛ́ kpɛ mbaá ayi ábelé maá yimbɔ. ");
INSERT INTO anvNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Ne Jisɔs agbare ji ɛbwɔ ajɔɔ́ né meko aramaic aké, “Tabita kumi. Ula utɛné nnó, mesɔ mendée njɔge ne wɔ nnó kwilé ka.” ");
INSERT INTO anvNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Maá yimbɔ akwilé, tɛ́nétɛ́né alɔ mankɛné. Mesɔ mendée yimbɔ alu aŋmɛ́ áfyanéápeá. Bɔɔ́ bi ágɛne mechɔ ɛwé, mano áwule ɛbwɔ́ mmu ukokó. ");
INSERT INTO anvNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Jisɔs aji ɛbwɔ́ matu nnó ɛkagé ágaré muú yicha mechɔ́ ɛwe. Anérégé aké ne ɛbwɔ́, “Chyɛge maá yimbɔ menyɛɛ́ anyɛɛ́.” ");
INSERT INTO anvNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Jisɔs alyaá melu ɛwémbɔ, akéré né melɔ wuú ne baá utɔɔ́ bií. ");
INSERT INTO anvNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Ne bií uwyaá bɔɔ́ Jus ukwɔnégé, afɛ́ mmu ɛcha mmyɛmenɛne, alɔ́ manlɛré bɔɔ́ depɔré Ɛsɔwɔ. Gejamégé bɔɔ́ bi áwuú unó bi alɛrégé ála mano mekpo fuú ne áké, “Ɛwéna ɛlúmbɔ nno? Nde mbaá, atáné ne unó uko? Ndé muú áchyɛɛ́ ji gefɔɔ́gé deŋgá ti ne utó nnó apyɛgé ufelekpa? ");
INSERT INTO anvNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Pɔ́ memwɔmé upú ayi alu maá Mɛri na? Pɔ́ aŋmó bií álú Jɛmsi, ne Jose, Judas ne Simun? Pɔ́ aŋmó bií abi andée álú fa ne ɛsé.” Ɛpyɛ bwɔ́ áfyɛɛ́ matɔɔ́ ne Jisɔs wɔ́ ne ábya ji. ");
INSERT INTO anvNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Ne Jisɔs ajɔɔ́ ne ɛbwɔ́ aké, “Ánoge bɔɔ́ ɛkpávé Ɛsɔwɔ yɛ́ndé mbaá. Yɛ́mbɔ wyɛlé bɔɔ́ melɔ bwɔ́ ne ula gepú bwɔ́ ne áŋmɛ bwɔ́ ne álá nógé ɛbwɔ́” ");
INSERT INTO anvNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Ɛwena ɛpyɛ ji abɔ fɔ́ gébé mampyɛ ufélekpa ɛfɛɛ́ wɔ́, ɛkosé ukɛ́kɛ bɔɔ́ mamée abi ji anɛré ɛbwɔ́ amu mmyɛ atoó. ");
INSERT INTO anvNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Ji ala meno mekpo fuú ndɛre agɛne nnó bɔɔ́ bina áfyɛɛ́ fɔ́ metɔɔ́ ne ji wɔ́. Ne Jisɔs atánégé melɔ wuú, afɛ́ né mata malɔ ayifɔ, alɛrege bɔɔ́ mekomejɔɔ́ Ɛsɔwɔ. ");
INSERT INTO anvNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Akuú áŋgbá bií áfyáneapeá ako, áchwɔgé atɔ́ ɛbwɔ́ dafyɛ apea apea. Achyɛ́ ɛbwɔ́ uto mamférégé aló nchyɛ né mmyɛ bɔɔ́. ");
INSERT INTO anvNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Ndɛre ɛbwɔ́ achwɔ́ jyɛ, Jisɔs aké ne ɛbwɔ́, “Ɛkagé débɔ́ yɛɛ́ genó, bɔgé le meto ɛwu ɛwu, dékpágé fɔ́ menyɛɛ́, yɛ́ gébagé nekɛ, yɛ́ ŋka, ");
INSERT INTO anvNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","yɛ́ gekwɔrégé ndeé, yɛ́mbɔ fyɛ́ge lé unó uka.” ");
INSERT INTO anvNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Ama jɔɔ́ ne ɛbwɔ́ aké, “Dekwɔnégé yɛ́nde melɔ, gepú ɛyigé dékpɛ́gé, ásɛge ɛnyú ne metɔɔ́ megɔmegɔ bɛ́ge wyɛ ɛfɛɛ́ kpaá tɛ délyáge. ");
INSERT INTO anvNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Mbɔge melɔ ɛlá sɛɛ́ ɛnyú wɔ́, yɛ́ manwu mekomejɔɔ́ nyú wɔ́, lyáge déjyɛ detɛne né metɔɔ́ melɔ́, dekwe uka mme nnó mpupu ɛyi ɛbalé ɛnyú uka ɛ́táné, ne ɛlɛrege nyɛ nnó ákwele ɛbwɔ́ mbeé.” ");
INSERT INTO anvNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Ne baá utɔɔ́ bií atáné áfɛ́, álɔ mangárégé bɔɔ́ mekomejɔɔ́ Ɛsɔwɔ. ");
INSERT INTO anvNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Ɛbwɔ́ áfere gejamégé aló nchyɛ né mmyɛ bɔ, áma ápyɛ bɔɔ́ mameé átoó ndɛre ágbɛle ɛbwɔ́ maweé mmyɛ. ");
INSERT INTO anvNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Mfwa Hɛrɔd Antipas ayi awáne baá gebégé ábyɛné Jisɔs awú ŋgɔ ukpɛ́kpɛ́ depɔ tiré Jisɔs apyɛ́ deko. Nendé yɛ́nde mbaá bɔɔ́ ágaré abya wuú. Bɔɔ́ bifɔ ájɔge áke, “Jɔn menwyaá bɔɔ́ manaá Ɛsɔwɔ ne akwilé né negbo nkaáwu ne awya utó mampyɛ ufélekpa.” ");
INSERT INTO anvNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Yɛ́mbɔ abifɔ áké, “Jisɔs alu mewené Ɛlija muú ɛkpávé Ɛsɔwɔ.” Abifɔ áké, “Jisɔs alu gekwénegé muú ɛkpávé Ɛsɔwɔ.” ");
INSERT INTO anvNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Ne Hɛrɔd awúge ngɔ Jisɔs aké, “Ndɔfɔ ɛlé Jɔn menwyaá bɔɔ́ manaá Ɛsɔwɔ ayi mbɔ nsɔɔ́ ji mekpo ne ákwilé né negbo achwɔɔ́.” ");
INSERT INTO anvNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Ɛpyɛmbɔ Hɛrɔd atɔ bɔɔ́ nnó ágbáré Jɔn áwɛ́ áfyɛ́ né mmu gepúgé denɔ, gétúgé agaré gabo ayi Hɛrɔd apyɛ́ nnó aferé Hɛrɔdyas mendée meŋmo wuú Filip abá. ");
INSERT INTO anvNT_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Jɔn abɔ ajɔ́gé ne Hɛrɔd nnó, “Ɛlɔme fɔ́ manfere mendée meŋmó wyɛ ɔbá.” ");
INSERT INTO anvNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Né gétú ɛyigémbɔ Hɛrɔdyas abɔ apaá Jɔn ne akɛlé meti manwá ji yɛ́mbɔ ágɛ́ meti wɔ́. ");
INSERT INTO anvNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Hɛrɔd abɔ ánógé Jɔn ne ákɛlégé fɔ́ nnó awá ji. Akaá nnó Jɔn alu muú melɔ́mélɔ́ ne alu cho né mbɛ ushu Ɛsɔwɔ. Yɛ́lé unó bi Jɔn ajɔ́ge úlú tametame né metɔɔ́ wuú, yɛ́mbɔ metɔɔ́ ɛ́gɔɔ́ ji manwúge Jɔn yɛ́ndégébé. ");
INSERT INTO anvNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Bií uma Hɛrɔdyas agɛ meti mawá Jɔn. Gébégé Hɛrɔd apyɛ ɛpaá bií ɛbi ábyɛ́né ji, akú ákpakpa melɔ ne afwa bɔɔ́ bee né gebage mewaá Galilií. ");
INSERT INTO anvNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Ne maá Hɛrɔdyas mesɔ mendée achwɔ́ bee gefɔ́gé mabeé ɛyigé gégɔɔ́ Hɛrɔd ne aŋkɛɛ́ bií matɔɔ́, ɛfɛɛ́ ne Hɛrɔd aké ne ji, “Gare me yɛ́nde genó ɛyige ɔkɛlege, nchyɛ wɔ.” ");
INSERT INTO anvNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Nkelé nnó, “Nchyɛge wɔ yɛ́nde genó ɛyigé ɔkɛlege, yɛ ɛbɛ le gebagé melɔ wá.” ");
INSERT INTO anvNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Maá yimbɔ atané ajyɛ gií mma wuú aké, “Mma, ngaré mfwa nnó nkɛlege nde”? Mma aké, “Mekpo Jɔn menwyaá bɔɔ́ manaá Ɛsɔwɔ.” ");
INSERT INTO anvNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Maá yimbɔ abó akéré, agaré Hɛrɔd aké, “Nkɛlege nnó ɔchyɛ me mekpo Jɔn menwyaá bɔɔ́ manaá Ɛsɔwɔ fa né gebagé nkpagene nana.” ");
INSERT INTO anvNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Mechɔ ɛwé ɛpyɛ mfwa Hɛrɔd byɔ ukɔré ji mmu yɛ́mbɔ akágé shya manchyɛ ji gétúgé abɔ́ akele mɛ né mbɛ ushu aŋkɛɛ́ bií. ");
INSERT INTO anvNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Tɛ́nétɛ́né yimbɔ, Hɛrɔd atɔ membame wuú ayi ama nnó, ájyɛ ásɔ́ mekpo Jɔn né gepúgé denɔ. Ne ájyɛ sɔ́ áchwɔ́ ne ɛwu. ");
INSERT INTO anvNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Mende yimbɔ anérégé, abɔ́ mekpo ɛwu afyɛ́ né gebagé nkpagene ajyɛ́ chyɛ maá yimbɔ mendée, ne maá yimbɔ ajyɛ chyɛ mbaá mma wuú. ");
INSERT INTO anvNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Ne baá utɔɔ́ Jɔn áwúge nnó áwá ntɛ bwɔ́, ájyɛ kpá geŋkwɔ jií, anií né menome ɛwe áchomé né ɛtárávɛ́. ");
INSERT INTO anvNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Áŋgbá Jisɔs ákéré meso né nekɛ ɛniné ji abɔ́ atɔme ɛbwɔ́. Ágaré Jisɔs ufɔɔ́ unó bí ɛbwɔ́ ápyɛ́ ne álɛré. ");
INSERT INTO anvNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Ɛwyágé bɔɔ́ áchwɔɔ́ mbaá Jisɔs, abi áchwɔɔ́, ne abi ájyɛ, ájá kpaá ápyɛ Jisɔs ne baá utɔɔ́ bií ápɔ́ yɛ́ ne gébé manyɛɛ́ menyɛɛ́. Ɛfɛɛ́ ne Jisɔs aké ne baá utɔɔ́ bií, “Déjyɛ́ né melú ɛwé bɔɔ́ álá pɔ́, nnó ɛnyú degbeé mmyɛ gachyɛ́.” ");
INSERT INTO anvNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Ɛ́fɛɛ́ ájyɛ kpɛ mmu ɛ́kpée ɛbwɔ́ ɛbwɔ́, álɔ manjyɛ né mbaá ayi álú bɔmbɔ. ");
INSERT INTO anvNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Yɛ́mbɔ gejamégé bɔɔ́ ágɛ́ ɛbwɔ́ ndɛre átané ájyɛ ákaá Jisɔs ne bɔɔ́ bí ne melu ɛwé ɛbwɔ́ ájyɛ. Ne ɛbwɔ́ átané malɔ́malɔ́, ásɔ́ mewaá mewaá, ábɔ́ mbɛ ne Jisɔs ne baá utɔɔ́ bií. ");
INSERT INTO anvNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Jisɔs átanégé mmu ɛkpée, agɛ́ gejamégé bɔɔ́, ne meshwɛ akwɔ́ ji metɔɔ́, gétúgé álu ɛké magɔŋme ayi álá pɔ́ ne membámé. Ɛfɛɛ́ alɔ manlɛré ɛbwɔ́ gejamégé unó. ");
INSERT INTO anvNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Ndɛre bií ulɔ mangíle baá utɔɔ́ Jisɔs ájyɛ jɔɔ́ ne ji áké, “Átá bií úfɛ́ ne mbaá yina alu ɛke mashwɔne. ");
INSERT INTO anvNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Gɔ bɔɔ́ bina ájyɛ nnó ɛbwɔ́ ákáge jyɛ ne makɔɔ́ né baá malɔ ayi álú kwɔ́kwɔ́lé, áná menyɛɛ́ ányɛɛ́.” ");
INSERT INTO anvNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Ne Jisɔs ashuú ɛbwɔ́ meko aké, “Ɛnyú ambɔɔ́ chyɛ́ge ɛbwɔ́ genó ányɛɛ́.” Ne ɛbwɔ áké, “Átá ɔkaá fɔ́ nnó ŋka yi ɛse dénáme bɔɔ́ bina menyɛɛ́ ɛ́káge bɛ genóge uba ŋka upea wɔ́?” ");
INSERT INTO anvNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Jisɔs aké, “Ɛnyú dewya ntó brɛd ɛníi? Choge depɛ́.” Ájyɛ gɛ́, ne áké, “Ɛse dewya ntó brɛd ɛta ne meshuú ɛpea.” ");
INSERT INTO anvNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Ne Jisɔs agare ɛbwɔ́ nnó ákaré bɔɔ́ bimbɔ matoómatoó, ájwɔ́lé né dambyanja. ");
INSERT INTO anvNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Apyɛ ɛbwɔ́ ájwɔ́lé, mbaá ayifɔ álu usaá bɔɔ́ uta ne ayifɔ alu usaá bɔɔ́ upea meso ɛfya. ");
INSERT INTO anvNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Ájwɔ́légé Jisɔs abɔ́ ntóo brɛd ɛ́táa ne meshuú ɛ́peá, apɛ amɛ mfaánebuú, achyɛ́ matame mbaá Ɛsɔwɔ. Agya brɛd achyɛ́ mbaá baá utɔɔ́ bií nnó ákaré mbaá bɔɔ́ bimbɔ. Ne ákaré ntó meshuú ɛpea mbaá ɛbwɔ́ ako. ");
INSERT INTO anvNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Yɛ́ndémuú ányɛ́ ágbeé. ");
INSERT INTO anvNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Ne baá utɔɔ́ Jisɔs ányweré brɛd ne meshuú ágbeé usá úfyáneupeá ɛbi ányɛɛ́ ulaá. ");
INSERT INTO anvNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Bɔɔ́ bi ányɛ́ menyɛɛ́ álú dɛlé bɔɔ́ átáa. ");
INSERT INTO anvNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Ɛ́wyágé Jisɔs apyɛ baá utɔɔ́ bií ákpɛ ɛ́kpée nnó ábɔ́ mbɛ áchyá gentoógé mewaá ájyɛ́ né melɔ Bɛtsada. Ji ala meso agare bɔɔ́ nnó ɛbwɔ́ ákéré né upú bwɔ́. ");
INSERT INTO anvNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Ajɔgé mɛ́ né bɔɔ́ nnó ákɛ cháŋéné, afɛ né mfaá Mekwɛ manɛmmyɛ. ");
INSERT INTO anvNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Nkwále akwɔnégé, ɛkpée ɛlú né metɔɔ́ gentógé mewaá Galilií, ɛle Jisɔs mbií ne álaá né mapeá nnyi. ");
INSERT INTO anvNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Jisɔs agɛ́ nnó baá utɔɔ́ bií ágɛ́ne ɛfwyale ndɛre mbyo nnyi atané ɛbwɔ́ mbɛ ushú ápélege ɛ́kpée bwɔ́. Ɛlɔ né gejɛ́jɛ́gébí kpaá tɛ dondo, Jisɔs ákɛ́né mfaá mekɔ manaá achwɔ́ ɛta bwɔ́, ɛla gachyɛ ake apyáme ɛbwɔ́ akoó. ");
INSERT INTO anvNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Ɛbwɔ́ áké ágɛ́ne nkane Jisɔs akɛ́ne mfaá mekɔ manaá achwɔ́, áfɛré nnó ɛle muú nefoó ne alɔ máŋkalégé. ");
INSERT INTO anvNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Ɛbwɔ́ ako ágɛgé ji ɛfɔɔ́ ɛkwɔ ɛbwɔ́ matɔɔ́. Yɛ́mbɔ áké ne ɛbwɔ́ tɛnetɛne yimbɔ, “Ɛlé me, gbarege matɔɔ́ nyú, défɔge.” ");
INSERT INTO anvNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Jisɔs akpɛge né mmu ɛkpée ne ɛbwɔ́, mbyo yimbɔ apwá. Agɛge mbɔ ala mano mekpo fuú. ");
INSERT INTO anvNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Yɛle Jisɔs abɔ achyɛ dɛle bɔɔ́ atá brɛd ányɛɛ́, akaá fɔ gefɔge muú ɛyige ji alu wɔ́; néndé aŋea matɔɔ́. ");
INSERT INTO anvNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Jisɔs ne baá utɔɔ́ bií áchyagé gentóogé mewaá, áchwɔ́ kwɔ́ne né melɔ Gɛnɛsárɛt, né gentó ɛyigémbɔ ne ɛbwɔ́ áshií ɛ́kpée ɛfɛɛ́. ");
INSERT INTO anvNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Tɛ́nétɛ́né yi ɛbwɔ́ átané mmu ɛ́kpée, bɔɔ́ ákaá nnó gɛ́ Jisɔs na. ");
INSERT INTO anvNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Álomé gatɛlé, áfɛ melɔ meko ne baá mata malɔ, áfɛ ákpane bɔɔ́ mameé bwɔ́ áchwɔ́ ne ɛbwɔ́, ne yɛ́nde mbaá ayi áwuúge nnó Jisɔs alú wyɛ. ");
INSERT INTO anvNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Ne yɛ́nde mbaá ayi Jisɔs ákwɔné, yɛ́ né malɔ ayi kɔ́kɔ́ yɛ ayi kpákpá ne yɛ né makɔɔ́ ákpané bɔɔ́ mameé ánywérege malú malú yɛ́ né ntoné gese, ne ánɛné Jisɔs mmyɛ nnó alya ɛbwɔ́ atá mano nkú jií. Ne yɛ́ndémuú nemeé ayi ataá mano nkú Jisɔs atoó. ");
INSERT INTO anvNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Bɔɔ́ Farasi ne anlɛré mabɛ́ Ɛsɔwɔ fɔ átané Jɛrosalɛ áchwɔ́ nɔ́ Jisɔs mme. ");
INSERT INTO anvNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Ndɛre ɛbwɔ́ álu ɛfɛɛ́, ágɛ́ nnó baá utɔɔ́ Jisɔs abifɔ anyɛɛ́ menyɛɛ́ amu debadeba ayi álá shwɔnége amu ndɛre gepɔ gebwɔ́ gelɛrége wɔ́. ");
INSERT INTO anvNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Bɔɔ́ Farasi ne bɔɔ́ Jus ako abi ákwɔ́lege unó bina dɔɔ́, ushuú bɔɔ́ Farasi cháchá ányɛɛ́ fɔ́ menyɛɛ́ ayi álá bɔmbɛ áshwɔ́né amu bwɔ́ ndɛre gepɔgé ukwene antɛ bwɔ́ gelu wɔ́. ");
INSERT INTO anvNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Yɛɛ́ muú bwɔ́ ayi anyɛɛ́ genó ɛyígé ánáme né gese ayi álá shwɔné cháŋéné apɔ́. Ɛbwɔ́ ábelege ntó gejamégé mabɛ bwɔ́ nkane manshwɔ́négé amó, mesɛɛ́ ne mámba. ");
INSERT INTO anvNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Ne Bɔɔ́ Farasi ne anlɛré mabɛ́ Ɛsɔwɔ ágií Jisɔs áke, “Ulannó ne baá utɔɔ́ byɛ álá kwɔ́légé unó bi ukwene antɛ sé álɛré? Ulannó ɛbwɔ́ ányɛɛ́ menyɛɛ́ ayi álá shwɔ́négé amu”? ");
INSERT INTO anvNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Jisɔs ashuú ɛbwɔ́ meko aké, “Ɛnyú bɔɔ́ dembwɔ́lé. Asaya, muú ɛkpávé Ɛsɔwɔ abɔ́ alu cho gébégé agaré nyá mekomejɔɔ́ Ɛsɔwɔ atomé ne ɛnyú nnó, ‘Bɔɔ́ bina ánógé me ne ubɔ́meno yɛ́mbɔ ánógé fɔ́ me né mmu matɔɔ́ bwɔ́ cháchá. ");
INSERT INTO anvNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Ɛnógé ɛwé ɛbwɔ́ ánoge me, ɛlú detú nénde ásɛle unó ukwene antɛ bwɔ́ álɛrege ɛké mabɛ ya!’” ");
INSERT INTO anvNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Jisɔs aké ne ɛbwɔ́, “Ɛnyú désɛ mabɛ́ Ɛsɔwɔ, deke debélé ɛgbɛ ɛma nnó dénógé unó bi ákwaá álɛ́rege.” ");
INSERT INTO anvNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Jisɔs afɛ mbɛ manjɔɔ́ aké, “Dewyá mati malɔ́malɔ́ mánlya mabɛ́ Ɛsɔwɔ nnó dékwɔ́légé le unó bi ukwene antɛ nyú álɛrége. ");
INSERT INTO anvNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Gébégé Mosis alɛrege mabɛ Ɛsɔwɔ, abɔ́ ajɔɔ́ aké, ‘Nógé mma wyɛ ne ntɛ wyɛ’. Ama jɔɔ́ ntó nnó, ‘Mbɔgé muú ajɔ́gé mejɔɔ́ mebo ne mma wuú yɛ́ ɛlé ne ntɛ wuú, ábɔ́ manwá ji.’ ");
INSERT INTO anvNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Yɛ́mbɔ né ɛgbɛ́ ɛwé nyú, dela gáre lé nnó, mbɔgé muú abɛgé ne genó ɛyigé ji akage poó mma wuú yɛɛ́ ɛbɛ́lé ntɛ wuú ne geji, ajɔɔ́ le nnó, ‘Ɛ́lé ɛchyɛ Ɛsɔwɔ.’ ");
INSERT INTO anvNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Wyɛmbɔ ne dégbɛɛ́ bɔɔ́ nnó ápoóge fɔ́ ammá bwɔ́ ne antɛ bwɔ́. ");
INSERT INTO anvNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Ɛnyú dépyɛ mabɛ́ Ɛsɔwɔ áfu sé yɛ́ genó wɔ́ getúgé unó bi ɛnyú délɛ́rege. Gɛ wyɛ gepɔ gema na me njɔɔ́ mbɔ gejamégé gabo alú ayi ɛnyú dépyɛ wyɛ na.” ");
INSERT INTO anvNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Ne Jisɔs ama akuú njuné bɔɔ́ nnó áchwɔ́ ɛta wuú. Áchwɔ́ge aké, “Ɛnyú ako wuúge, ne yɛ́ndémuú ákaá genó ɛyigé njɔ́gé. ");
INSERT INTO anvNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Genó ɛyigé muú ányɛ́ge gejyɛ ji unɛ gepyɛ fɔ́ muú ábɛɛ́ debadeba né mbɛ ushuú Ɛsɔwɔ, ɛlé ɛyi getanege ji né meno.” ");
INSERT INTO anvNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Ne mbɔge muú awyá matu manwú áwú. ");
INSERT INTO anvNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Jisɔs anérégé, ji ne baá utɔɔ́ bií ályá bɔɔ́ bimbɔ, áfɛ́ né mmu gepú, ne ɛbwɔ́ ágií ji ulá nekanemejɔɔ́ ɛnina. ");
INSERT INTO anvNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Jisɔs ashuú ɛbwɔ́ meko aké, “Ɛnyú delú defɔɔ́ pɔ́ ɛké atɛ? Ɛnyú dékaá wáwálé nnó dényɛgé menyɛɛ́ ákágé pyɛ fɔ́ ɛnyú debɛ́ debadeba. ");
INSERT INTO anvNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Menyɛɛ́ wu ákpéné fɔ́ né matɔɔ́ nyú, ájyɛ le né unɛ, ne átane né menyammyɛ.” Ndɛre Jisɔs ajɔɔ́ mbɔ ɛbyɛnnó ufɔɔ́ menyɛɛ́ uko ukwané manyɛɛ́. ");
INSERT INTO anvNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Ne Jisɔs aké, “Ufɛré ɛbi utánege muú metɔɔ́ ne upyɛ muú abɛɛ́ debadeba né mbɛ ushuú Ɛsɔwɔ.” ");
INSERT INTO anvNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Ama jɔɔ́ aké, “Ufɛ́ré uboubo, ubɛlé tametame, ɛjo ne manwáné bɔɔ́. Unó bina uko utánege né metɔɔ́, ");
INSERT INTO anvNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","mankwéné ulɔ, use, ne nchyɛ, mambwɔ́lege bɔɔ́, ɛŋmeŋmené, mansɔge metɔɔ́ nnó bɔɔ́ ábɔ́ unó ápwɔ ɛnyú, manchɔge bɔɔ́ mambɔ, nepa ne ukéŋkéné. ");
INSERT INTO anvNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Unó bina uko utanege né metɔɔ́ ne ubi ne úpyɛɛ́ muú ábɛɛ́ debadeba né mbɛ ushuú Ɛsɔwɔ.” ");
INSERT INTO anvNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Ne Jisɔs atané afɛ́ né gebagé mewaá bɔɔ́ Jus ɛyi gelú kwɔ́kwɔ́lé ne melɔ Tiya ne Sidɔn. Jisɔs ajyɛ kpɛ mmu gepú gefɔ ne akɛ́légé fɔ́ nnó muú akaá nnó ji alu ɛfɛɛ́, yɛ́mbɔ meti ɛpɔ́ ɛwe ji ákáge bií. ");
INSERT INTO anvNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Mendée fɔ ayi maá wuú yi mendée awya meló nchyɛ, áwuúgé nnó Jisɔs alu ɛfɛɛ́, atané tɛ́nétɛ́né achwɔ́ tó manó né mbɛ ushuú wuú. ");
INSERT INTO anvNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Mendée yina apɔ́ fɔ́ muú Jus alu muú Grek ne ábɔ́ ábyɛ́ ji títí né gebagé mewaá Siriya né Sirofɔnishya. Anɛ Jisɔs mmyɛ nnó aféré meló nchyɛ yimbɔ né mmyɛ maá wuú. ");
INSERT INTO anvNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Yɛ́mbɔ Jisɔs aké, “Gɔ ɛsé debɔ mbɛ dechyɛ baá melɔ menyɛɛ́, ɛlɔ́mé fɔ́ nnó muú asɛ menyɛɛ́ ayi baá melɔ ányɛ́ achyɛɛ́ bɔ mammyɛ.” ");
INSERT INTO anvNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Ne mendée yimbɔ ashuú ji meko aké, “Ata, yɛ́mbɔ bɔ mammyɛ ányɛɛ́ uchɔchɔgéré ɛbi utánege né ɛkpókpógélé ukwéne mme gébégé ambané áke ányɛɛ́ menyɛɛ́.” ");
INSERT INTO anvNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Jisɔs aké ne ji, “Ɛlé wáwálé, chó, ɔgɛne nyɛ ndɛre meló nchyɛ yimbɔ atané mɛ́ maá wyɛ mmyɛ.” ");
INSERT INTO anvNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Gébégé mendée yimbɔ akéré né gepú jií, agɛ́ maá wuú ndɛre ábɛlé né ukwɔ ne meló nchyɛ atané mɛ́ ji mmyɛ. ");
INSERT INTO anvNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Ne Jisɔs atánege melɔ Tiya akoó né meti Sidɔn afɛ́ né ɛbɛɛ́ mega Galilií. Afɛ́ né mme Dekapolis, mme malɔ afya. ");
INSERT INTO anvNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Bɔɔ́ fɔ áchwɔ́ ne mende ayi alu matu gbɛ́gbɛ́ ne akágé jɔɔ́ fɔ mejɔɔ́. Ɛbwɔ́ ánɛ Jisɔs mmyɛ nnó anɛré ji ɛbwɔ mmyɛ. ");
INSERT INTO anvNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Jisɔs asɛ ji né metɔɔ́ metɔɔ́ gejamégé bɔɔ́, afɛ́ né melu ɛwé ɛlu bibií ɛfɛɛ́ ne afyɛ denɔré amu né matu mende yimbɔ, akpó matyɛ ne ata nenɔme nií. ");
INSERT INTO anvNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Ne Jisɔs apɛ amɛ mfaánebuú ne ashuúle gefere, ajɔɔ́ né meko aramaic aké, “Ɛffata” ula úlú nnó, “Néné”. ");
INSERT INTO anvNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Tɛ́nétɛ́né mende yimbɔ alɔ manwu ne alɔ ntó manjɔɔ́ mejɔɔ́ ayi álá pɔ́ se ne ɛfwyale. ");
INSERT INTO anvNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Ne Jisɔs akwelé ɛbwɔ́ mbeé nnó ɛ́kagé ágaré muú. Yɛ́mbɔ ndɛre ákwelé ɛbwɔ́ mbeé dɔɔ́, mbɔ nto ne bɔɔ́ ágarege abya wuú ájyɛ. ");
INSERT INTO anvNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Ɛbwɔ́ ako abɔ, álá manó mekpo fuú ájɔge áké, “Yɛ́ndé genó ɛyige ji apyɛɛ́ gelú gelɔ́gelɔ́.” Apyɛ bɔɔ́ matu gbɛ́gbɛ́ áwuú ne abi álá jɔge, ájɔge. ");
INSERT INTO anvNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Ɛwyage gejamégé bɔɔ́ gema chwɔ́ nɔ́ Jisɔs mme. Bɔɔ́ bina abɔ́ akpá fɔ́ menyɛɛ́ ayi ányɛɛ́ wɔ́. Ne Jisɔs akuú baá utɔɔ́ bií ne aké, ");
INSERT INTO anvNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Meshwɛ apyɛɛ́ me ne bɔɔ́ bina, néndé ɛbwɔ́ álé mbɔ ndɔ ɛlɛɛ́ ne me ayi álá ányɛɛ́ yɛ genó fɔ́ wɔ́. ");
INSERT INTO anvNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Mbɔgé ngarege ɛbwɔ́ nnó ájyɛɛ́ unɛ mesa, átɔ́ɔ né meti gétúgé abifɔ nekɛne bwɔ́ néshya.” ");
INSERT INTO anvNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Baá utɔɔ́ bií ágií ji áké, “Fa né mashwɔne muú agɛne mbɔ menyɛɛ́ ɛfɔ́ ayi ákwanege bɔɔ́ bina ako?” ");
INSERT INTO anvNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Ne Jisɔs agií ɛbwɔ́ aké, “Ɛnyú dewyaá ntoó brɛd ɛnií ɛfɛɛ́”? Áké, “Dewyaá ntoó brɛd ɛ́kénéama.” ");
INSERT INTO anvNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Ɛwyage Jisɔs agaré bɔɔ́ bimbɔ aké, “Jwɔ́lege mme”. Ne asɛ́ ntoó brɛd ɛyimbɔ ɛ́kénéama áchyɛge matame mbaá Ɛsɔwɔ, agya, achyɛɛ́ baá utɔɔ́ bií nnó ákáré mbaá bɔɔ́ bina, ne ápyɛ wyɛmbɔ. ");
INSERT INTO anvNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Ne ɛbwɔ́ ábɔ́ awya ntó ukɛkɛ baá meshuú. Jisɔs asɛ achyɛɛ́ matame mbaá Ɛsɔwɔ né uno bi, agaré baá utɔɔ́ bií nnó ákáré mbaá bɔɔ́. ");
INSERT INTO anvNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Yɛ́ndémuú ányɛɛ́ ágbeé ne baá utɔɔ́ Jisɔs ánywéré uba bi ulaá ugbeé usá ukeneama. ");
INSERT INTO anvNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Mpa bɔɔ́ bi ányɛ́ alú dɛlé bɔɔ́ anií. Ánérégé Jisɔs aké ákere meso né upú bwɔ́. ");
INSERT INTO anvNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Tɛ́nétɛ́né yimbɔ Jisɔs ne baá utɔɔ́ bií ákpɛ mmu ɛ́kpée áchyaá áfɛ́ né gebagé mewaá ɛyigé akuú nnó Dalmanuta. ");
INSERT INTO anvNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Bɔɔ́ Farasi fɔ ábɔ́ áfɛ́ mbaá Jisɔs álɔ manyɛ́ mbeé ne ji. Ɛbwɔ́ abɔ akɛle meti mamua ji. Ágií ji áké, “Pyɛ ufélekpa ɛse dégɛ́, manlɛre nnó Ɛsɔwɔ ne atɔ́me wɔ.” ");
INSERT INTO anvNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Jisɔs awuúgémbɔ, ashulé gefere ne agií ɛbwɔ́ aké, “Ulannó njyɛ ɛnina fi nekɛlege ufélekpa? Ngarege ɛnyú wáwálé nnó yɛ́ úma degɛné fɔ́.” ");
INSERT INTO anvNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Ájɔgé mbɔ alya ɛbwɔ́, áma jyɛ kpɛ mmu ɛkpeé, achya afɛ́ ɛgbɛ gentógé mewaá. ");
INSERT INTO anvNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Baá utɔɔ́ Jisɔs ábɔ́ ájinte mankpa gejamégé brɛd ne ábɔ́ áwya le maá ntó brɛd ama né ɛkpeé. ");
INSERT INTO anvNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Jisɔs akwelé ɛbwɔ́ mbeé aké, “Sɛge gébé ne yis bɔɔ́ Farasi ne mfwa Hɛrɔd.” ");
INSERT INTO anvNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Ne ɛbwɔ́ álɔ manjɔgé ɛbwɔ́ ɛbwɔ́ áké, “Ndɔfɔ ajɔ́gé mbɔ lé délá depɔ́ yɛ́ ne brɛd?” ");
INSERT INTO anvNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Jisɔs akaá genó ɛyigé ɛbwɔ́ ajɔgé ne agií aké, “Ulannó ɛnyú dejɔge mechɔ brɛd ayi ɛnyú dela pɔ́ ne ji? Nnó ɛnyú delú daŋkaá ula mechɔ ɛwé? Matɔɔ́ nyú álu wyɛ séséleé? Délú daŋkaá gefɔ́ge muú ayi me nlu? ");
INSERT INTO anvNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Ɛnyú déwyaá amɛ dégɛne fɔ́ mbaá? Ɛnyú déwyaá matu déwuú fɔ́? Dékágé fɛre fɔ́ depɔ tiré na? ");
INSERT INTO anvNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Gébégé nkare ntoó brɛd ɛ́ta mbaá bɔɔ́ dɛle bɔ́ átáa ányɛɛ́, ayi ábɔ́ álaá gbeé usa unií?” Ne ɛbwɔ́ áshuú ji meko aké, “Usá úfyaneupeá.” ");
INSERT INTO anvNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Jisɔs ama agií ɛbwɔ́ nnó, “Ne gébégé nkaré ntó, ntoó brɛd yimbɔ ɛ́kénéama mbaá bɔ dɛlé bɔɔ́ ani ányɛɛ́, ayi alaá ɛnyú dénywere nyá, álaá usá unií?” Ɛbwɔ́ áshuú meko áké, “Usá ukeneama.” ");
INSERT INTO anvNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Jisɔs agií ɛbwɔ́ ake, “Ɛnyú degɛ nkane nsɛle baá nto brɛd nchyɛɛ́ gejame bɔɔ́ menyɛɛ́ wɔ́, tɛ fi, délu daŋkaá gefɔ́gé muú ɛyi me nlu?” ");
INSERT INTO anvNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Gébégé Jisɔs ne baá utɔɔ́ bií ákwɔne né Bɛtsada, bɔɔ́ fɔ ásɛ muú amɛ nónómé áfɛ́ ne ji mbaá Jisɔs ánɛ ji mmyɛ nnó atá ji. ");
INSERT INTO anvNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Jisɔs agbaré ji ɛbwɔɛbwɔ áfɛ́ mekpo meti, ɛfɛɛ́ ne akpó ji matyɛ amɛ. Anɛré ji amu né amɛ, agií ji aké, “Nnó ɔgɛne mbɔ genó fɔ́?” ");
INSERT INTO anvNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Mende yimbɔ apɛ amɛ mfaá aké, “Ngɛne bɔɔ́ yɛ́mbɔ álu lé ɛké unɔɔ́ ɛbi ukɛne ugyage.” ");
INSERT INTO anvNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Ama ata ji amu né amɛ nana mende yimbɔ aké apɛle amɛ ji ánené alɔ mángɛne mbaá, ne agɛne yɛ́nde genó cháŋéné. ");
INSERT INTO anvNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Jisɔs agare nnó, “Cho mmu gepú jyɛ, ɛkagé ɔkere né melɔ.” ");
INSERT INTO anvNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Jisɔs ne baá utɔɔ́ bií ájyɛ́ né baá malɔ́ fɔ kwɔ́kwɔ́lé ne melɔ Kaisaria Filipi. Ndɛre ɛbwɔ́ akɛne ájyɛ, agií baá utɔɔ́ bií aké, “Ndé gefɔgé muú ayi bɔɔ́ ájɔɔ́gé nnó me nlu?” ");
INSERT INTO anvNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Baá utɔɔ́ bií áshuú ji meko áké, “Bɔɔ́ bifɔ áke ɔlu Jɔn menwyaá bɔɔ́ manaá Ɛsɔwɔ, abifɔ áke ɔlu Ɛlija ne abifɔ áke ɔlu muú ɛkpávé Ɛsɔwɔ ama.” ");
INSERT INTO anvNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Ajɔ́gémbɔ, Jisɔs agií ɛbwɔ́ aké ne “Yɛ́ ɛnyú ambɔɔ́ deké me nlu waá”? Pita ashuú ji meko aké, “Wɔ ɔlu Muú yi Ɛsɔwɔ akweré ji ɛlá gefwa.” ");
INSERT INTO anvNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Jisɔs akwelé baá utɔɔ́ bií mbeé nnó ɛ́kágé ágaré muú fɔ, muú ayi ji alu. ");
INSERT INTO anvNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Jisɔs alɔ mangaré nnó, Maá Ntɛ Mekwaá abɔ́ mangɛ́ gejamégé ɛfwyale, ɛle ákpakpa melɔ, ne anɔɔ́ baá bi ápyɛ upɛ ne anlɛré mabɛ Ɛsɔwɔ, áshya nyɛ ji, áwáne nyɛ ji. Yɛ́mbɔ ndɔ ɛlɛɛ́ ɛkwɔnegé akwilege nyɛ né negbo. ");
INSERT INTO anvNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Ne Jisɔs agaré ɛbwɔ́ mechɔ ɛwe gbɔgɔnɔ. Ajɔ́ge mbɔ, Pita asɛ ji átɛné ɛgbɛ. Alɔ manshule ji ndo nnó ajɔge se gefɔge mechɔ ɛwémbɔ. ");
INSERT INTO anvNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Yɛ́mbɔ Jisɔs abwɔlé ushu apɛ baá utɔɔ́ bií ne ashule Pita ndo aké ne ji, “Kwilé me mbɛ ushu danchɔmeló. Ɔfɛ́rege unó nkane mekwaá, ɔfɛrégé fɔ́ ɛké Ɛsɔwɔ.” ");
INSERT INTO anvNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Ne Jisɔs akuú gejamégé bɔɔ́ bimbɔ ne baá utɔɔ́ bií, ajɔɔ́ ne ɛbwɔ́ aké, “Yɛ́ mbɔgé muú ɛnyú akɛlege mambɛ menkwɔle wa, abɔ manjinte gemɛ jií akpa gekwa ji akame yɛ negbo ne akwɔ́légé me. ");
INSERT INTO anvNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Mbɔgé muú akɛlege mampoó geŋwá jií ɛbyɛ́nnó aníige nyɛ geji, ne mbɔgé muú akamégé manchyɛɛ́ geŋwá jií getú ya ne abya melɔ́mélɔ́, apomé nyɛ. ");
INSERT INTO anvNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Ndé nsá ayi muú ábɔ́ɔ, mbɔgé abɛge ne unó mme uko ne aníige geŋwá jií? ");
INSERT INTO anvNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Ndé genó muú ákage bɔ achyɛ mankwɔré ne geŋwá jií? ");
INSERT INTO anvNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Kaáge nnó mbɔgé mmyɛ́ ɛ́gbóo muú gétuú ya ne mekomejɔɔ́ wa né mbɛ ushu njyɛ ɛniné na, ɛniné nétií meso ne Ɛsɔwɔ, népyɛɛ́ gabogabo, mbɔntó ne Maá Ntɛ Mekwaá mmyɛ ɛgbóo nyɛ́ ji mansɛ muú yimbɔ ndɛre muú wuú gébégé aké achwɔ́ ne makiɛ́nné ukpea jií ne ɛnoge ɛwé Ntɛ wuú achyɛɛ́ ji.” ");
INSERT INTO anvNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Jisɔs ama jɔɔ́ ne bɔɔ́ bimbɔ aké, “Ngarege ɛnyú wáwálé nnó, gentɔgé bɔɔ́ álú mbɔ fáná, abi álá gbóo fɔ kpaá tɛ ágɛne nyɛ gefwage Ɛsɔwɔ ndɛre gechwɔɔ́ ne ɛshyɛ wuú.” ");
INSERT INTO anvNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Ndɔ ɛ́kéné ɛ́kógé Jisɔs asɛ Pita, Jɛmsi ne Jɔn ákwɔ́ áfɛ́ mfaá Mekwɛ fɔ kpaá. Ájyɛge ájwɔlé ɛbwɔ́ ɛbwɔ́ áke ápɛle menyammyɛ Jisɔs alɔ manshwanege né mbɛ ushu bwɔ́. ");
INSERT INTO anvNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Gefɔɔ́ ɛyigé mandeé ji akpea yɛ muú ayi akage shwɔne áji nnó ábɛ́ pópó mbɔ apɔ́, yɛ ɛ́bɛ́lé ne uka. ");
INSERT INTO anvNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Áké ápɛ́le ágɛ́ Ɛlija ne Mosis ákwɔ fwɛ́ɛ ájɔɔ́ge mejɔɔ́ ne Jisɔs. ");
INSERT INTO anvNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Pita ajɔɔ́ ne Jisɔs aké, “Ata, ɛlɔ́ ndɛre ɛsé délú fa, gɔ́ ɛse détɛ́né óto úlɛɛ́, géma ɛta wyɛ, géma ɛta Mosis, géma ɛta Ɛlija.” ");
INSERT INTO anvNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Pita akágé se genó ɛyigé ji ajɔ́ɔge néndé ɛfɔ́ ɛ́kwɔ́ ɛbwɔ́ matɔɔ́ dɔɔ́. ");
INSERT INTO anvNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Ndɛre ajɔɔ́ge mbɔ, áké ápɛlé gekó gekweré ɛbwɔ́ mme ne meko atané né mmu gekó ɛyigembɔ aké, “Gɛ́ge maá wa ayi mbwi metɔɔ́ na, wuúge ne ji.” ");
INSERT INTO anvNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Tɛ́nétɛ́né yimbɔ áké amagé pɛ ágɛ sé yɛ muú fɔ wɔ́ ɛkosé Jisɔs jimbií ne ɛbwɔ́ ambɔɔ́. ");
INSERT INTO anvNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Ndɛre ɛbwɔ́ áshulege mékwɛ́ ájyɛɛ́, Jisɔs áji ɛbwɔ́ ɛtu aké ɛ́kagé ágáré muú fɔ genó ɛyige ɛbwɔ́ ágɛné kpaá tɛ ji Maá Ntɛ Mekwaá akwilége né negbo. ");
INSERT INTO anvNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Áwúgé depɔ tire Jisɔs ajɔɔ́, ábele wyɛ́ détí né mmu matɔɔ́ bwɔ́, ne ágiíge atɛ nkane ulaá mankwilé né negbo útɛné. ");
INSERT INTO anvNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Ne baá utɔɔ́ Jisɔs bimbɔ ágií ji áké, “Ulannó ánlɛré mabɛ́ Ɛsɔwɔ ájɔɔ́ áké Ɛlija abɔ́ mambɔ mbɛ achwɔ́ ne Muú yi Ɛsɔwɔ akwere ji ɛla gefwa?” ");
INSERT INTO anvNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Ɛfɛɛ́ Jisɔs akamé aké, “Ɛ́lú wáwálé nnó, Ɛlija abɔ́ mambɔ mbɛ achwɔ́ akwyɛɛ́ unó uko abelé, yɛ́mbɔ ulannó ásáme ntó né mmu ŋwɛ Ɛsɔwɔ nnó, ‘Maá Ntɛ Mekwaá abɔ mangɛ gejamégé ɛfwyale ne ápaá nyɛ ji, áma shyá jí?’ ");
INSERT INTO anvNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Yɛ́mbɔ ngárege ɛnyú wáwálé nnó, Ɛlija achwɔ́ mɛ́ ne bɔɔ́ ápyɛ gabo ne ji nkane ɛjií ɛbwɔ́ wyɛ ndɛre abɔ asamé né mmu ŋwɛ Ɛsɔwɔ atomé ne ji.” ");
INSERT INTO anvNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Ɛbwɔ́ ákérégé meso, ágɛ gejamégé bɔɔ́ ndɛre ánɔɔ́ baá utɔɔ́ abifɔ né mme ánlɛre mabɛ Ɛsɔwɔ anyɛɛ́ mbeé ne ɛbwɔ́. ");
INSERT INTO anvNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Ne bɔɔ́ bimbɔ áké agɛ́ne Jisɔs ácháné ala ámɛ makpo faŋ álomé ájyɛ táme ji. ");
INSERT INTO anvNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Jisɔs agií ánlɛré mabɛ Ɛsɔwɔ aké, “Nde ɛnyú denyɛɛ́ mbeé ne ɛbwɔ́?” ");
INSERT INTO anvNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Ne mende fɔ né geluagé njune bɔɔ́ bimbɔ aké, “Ménlɛré nchwɔ́ ne maá wa né ɛta wyɛ ayi meló nchyɛ apyɛ́ ji álá jɔ́gé mejɔɔ́. ");
INSERT INTO anvNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Yɛ́ndégébé meló nchyɛ yimbɔ akwilégé ji mmyɛ, apyɛ ji akwe mme, génfwéné gétánege ji meno, anyɛ́ máŋɛ́né ala nɔ́geé. Nnɛ baá utɔɔ́ byɛ mmyɛ nnó áféré meló nchyɛ yimbɔ, ápulé ɛ́pwɔ.” ");
INSERT INTO anvNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Jisɔs ashuú ɛbwɔ́ meko aké, “Ɛ ɛ́ ndé gefɔge njyɛ ɛni nelá fyɛɛ́ metɔɔ́ ne Ɛsɔwɔ? Nkoge mbɔ metɔɔ́ ne ɛnyú nnó? Mmage bɛ́ ne ɛnyú ndɔ ɛnií ne défyɛɛ́ matɔɔ́ ne Ɛsɔwɔ? Chwɔ́ge me ne maá yimbɔ.” ");
INSERT INTO anvNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Áchwɔ́ ne maá yimbɔ mbaá Jisɔs. Ndɛre meló nchyɛ yimbɔ agɛ́né Jisɔs, apyɛ maá yimbɔ akwé mme achuú gbok! gbok, genfwéné getanege meno. ");
INSERT INTO anvNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Jisɔs agɛ́gé mbɔ agií ntɛ maá yimbɔ aké, “Nemeé niné na nébɛle mɛ́ ji mmyɛ nnó?” Mende yimbɔ aké, “Nelɔ ji tɛ dembáné.” ");
INSERT INTO anvNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","“Meló nchyɛ yimbɔ ákɛ́lege manwá ji, apyɛ́ ji akwéne gébé ɛyigé fɔ né mewɛ gebé ɛyifɔ né nnyi, Áta gɛ́ ɛsé meshwɛ ɔpoó ɛsé mbɔgé ɔkage pyɛ.” ");
INSERT INTO anvNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Jisɔs agií ji aké, “Ndé genó wɔ ɔ́jɔ́ge! Nnó mbɔgé ɔkage pyɛ? Ɛsɔwɔ apyɛ yɛ́ndégenó ɛyi gejwɛregé ne muú ayi áfyɛɛ́ metɔɔ́ ne ji.” ");
INSERT INTO anvNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Ntɛ maá yimbɔ ala tɛ́nétɛ́né aké, “Me nkamé ne Ɛsɔwɔ, Ata, poó me nkame ne metɔɔ́ ɛma.” ");
INSERT INTO anvNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Gébégé Jisɔs agɛ́né nnó gejamégé bɔɔ́ áboó áchwɔɔ́ ji mmyɛ, anyá meló nchyɛ yimbɔ aké, “Wɔ mbú ne álú, nnyá wɔ tánege ji mmyɛ. Ɔjyɛ́ mbɔ ɔkerege sé.” ");
INSERT INTO anvNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Meló nchyɛ yimbɔ apyɛ maá yimbɔ akalé akwé mme ne alé táne ji mmyɛ. Átánégé, maá yimbɔ ala mme nyamé ɛké mewu muú ne bɔɔ́ ágɛ́gé mbɔ áfɛ́rege nnó ágbó. ");
INSERT INTO anvNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Jisɔs agbaré ji ɛbwɔ, abwɛɛ́ ji akwilé tɛné. ");
INSERT INTO anvNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Ne Jisɔs ne baá utɔɔ́ bií ákerégé mmu, ágií ji bibií aké, “Ulannó ne ɛsé dépulé meló nchyɛ yimbɔ mambuú apwɔ?” ");
INSERT INTO anvNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Jisɔs agare ɛbwɔ́ aké, wyɛ lé mmyɛmenɛne ne ɛkage fɛré gefɔgé meló nchyɛ yina. ");
INSERT INTO anvNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Jisɔs ne baá utɔɔ́ bií ályá mbaá yimbɔ ákoó koóge né gebagé mewaá Galilií. Ji ákɛ́légé fɔ́ nnó muú akaá mbaá ayi ji alú. ");
INSERT INTO anvNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Nénde ji abɔ́ alɛrege ɛbwɔ́ nnó, “Meso gébé áchyɛ́ge nyɛ Maá Ntɛ Mekwaá né amu bɔɔ́ nchyɛ, áwáne nyɛ ji. Yɛ́mbɔ ndɔ ɛlɛɛ́ ɛkwɔnégé, ji akwilege nyɛ né negbo.” ");
INSERT INTO anvNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Yɛlé ji agaré neka ɛni, baá utɔɔ́ bií ákaá ula wɔ́, ne ámá áfɔ́ɔ mangií ji ula neka ɛníné na. ");
INSERT INTO anvNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Ɛbwɔ́ ákwɔ́négé né melɔ Kapanɔm, ájyɛ kpɛ né gepú ɛyige ɛbwɔ́ ájwɔle. Jisɔs agií baá utɔɔ́ bií aké, “Ndé ɛnyú denyɛ́ nyɛ mbeé né meti gébégé dechwɔɔ́.” ");
INSERT INTO anvNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Áwúgé mbɔ, ákwené nyámé getúgé ɛbwɔ́ ábɔ́ ányɛɛ́ mbeé mechɔ́ dékpakpa. ");
INSERT INTO anvNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Ájwɔ́légé ka, akuú baá utɔɔ́ bií makpo áfyaneápeá, áchwɔge, ajɔɔ́ ne ɛbwɔ́ aké, “Mbɔge muú akɛlege mambɛ́ muú kpaá né geluage nyú, abɔ́ mambɛ ndɛre maá defwɛ́ akpáné defwɛ mbaá abifɔ.” ");
INSERT INTO anvNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Ajɔge mbɔ, akuú maá fɔ kɔɔ́ achwɔ́ tɛ́né né metɔɔ́ metɔɔ́ ɛbwɔ́, akpa maá yimbɔ né amu jií ajɔɔ́ ne baá utɔɔ́ bií aké, ");
INSERT INTO anvNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Yɛ́ndémuú ayi akamege mampyɛ galɔ́gálɔ́ ne mamane kɔɔ́ nkane ayina né mabɔ ma, ɛbyɛnnó apyɛmbɔ lé ne me ne yɛ́ndémuú ayi apyɛ galɔ́gálɔ́ ne me ntó, ɛbyɛnnó apyɛmbɔ lé ne ntɛ waá yi átɔmé me.” ");
INSERT INTO anvNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Ne Jɔn akuú Jisɔs aké, “Ménlɛré, ɛsé degɛ́ mende fɔ asɛle mabɔ myɛɛ́ aferege bɔɔ́ aló nchyɛ né mmyɛ. Degɛ́gémbɔ, dégbɛ́ ji gétúgé álá pɔ́ fɔ́ né geluá gesé.” ");
INSERT INTO anvNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Jisɔs ajɔɔ́ ne ɛbwɔ́ aké, “Dégbɛgé fɔ gefɔgé muú yimbɔ. Néndé yɛ muú yi asɛle mabɔ ma apyɛɛ́ ufélekpá ne ɛ́wyagé ajɔge gabo getú ya apɔ́, ");
INSERT INTO anvNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","nénde muú yi álá paá ɛsé, alu awesé. ");
INSERT INTO anvNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Ngarege ɛnyú wáwálé nnó yɛ muú ayi achyɛge ɛnyú ŋkɔ manaá né mabɔ ama gétúgé délu bɔɔ́ ba ayi álá abɔɔ́ nyɛ nsá apɔ́.” ");
INSERT INTO anvNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Jisɔs ámá jɔɔ́ aké, “Yɛ́ndémuú ayi apyɛɛ́ mamane kɔɔ́ nkane ayina ayi áfyɛɛ́ metɔɔ́ ne me nnó apyɛ gabo, ɛ́lú galɔ́gálɔ́ nnó áshií ji gekpɛ́kpɛ́gé ntaá né gemɛ, áŋmé ji né gentoógé ɛbɛɛ́ mega. ");
INSERT INTO anvNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","Ama jyɛ mbɛ aké, mbɔgé ɛbwɔ wyɛ ɛpyɛ́ wɔ nnó ɔkwéné mabɛ́ Ɛsɔwɔ, sɔ́ ɛwu ɔfómé, ɛ́lú galɔ́gálɔ́ nnó ɔkpɛ né geŋwá gechúchúle ne nnó ɔkpɛ né ntoné mewɛ ɛwé ɛ́lá nómégé ne amu apea. ");
INSERT INTO anvNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","Ne mbɔgé geká jyɛ ne gétene wɔ nnó ɔkwéné mabɛ́ Ɛsɔwɔ, sɔ́ geji ɔfómé, ɛ́lú galɔ́gálɔ́ nnó ɔkpɛ né geŋwá geká géma ɛpwɔ nnó ɔkpɛ uka upea né ntoné mewɛ ɛwé ɛ́lá nómégé ne bɔ dámmwɔ́lé bií ntó ala gboó. ");
INSERT INTO anvNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Ne mbɔgé dambɔɔ́nnyi wyɛ atene wɔ nnó ɔkwéné mabɛ́ Ɛsɔwɔ, pwɔ́lé ji ɔfómé, ɛ́lú galɔ́gálɔ́ nnó ɔkpɛ né gefwa ɛyigé Ɛsɔwɔ ágbárege gechúchúle ne nnó ɔkpɛ né ntoné mewɛ ɛwé ɛ́lá nómégé ne amɛ́ ápeá. ");
INSERT INTO anvNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","‘Mbaá yi bɔ dámmwɔ́lé bí álá gboó, ne mewɛ ɛwu ntó ɛla nomege.’ ");
INSERT INTO anvNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Yɛ́ndémuú awuú nyɛ mewɛ né menyammyɛ wuú wyɛ nkane muú áchwarege mega né menyɛɛ́ nnó ɛ́kágé áchɔɔ́. ");
INSERT INTO anvNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","“Mega ɛ́lú genó gelɔ́gélɔ́, ne mbɔgé mega ɛ́lá pɔ́ sé ne ugɔ bií, ápyɛɛ́ mbɔ nnó ne ɛwu ɛma ɛgɔɔ́? “Ɛwéna ɛ́lɛré nnó ɛnyú débɛ́ ɛké mega, dényɛgé nesɔ ne atɛ.” ");
INSERT INTO anvNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Ɛfɛɛ́ Jisɔs alyaá Kapɛnum, afɛ́ né gebagé mewaá Judiya, achyaá ɛbɛɛ́ Jodan. Ndɛre akwɔné ɛ́wu, gejámégé bɔɔ́ áma chwɔ́ nɔ ji mme ne alɔ mánlɛré ɛbwɔ́ nkane ji apyɛ mɛ́ yɛ́ndégébé. ");
INSERT INTO anvNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Bɔɔ́ Farasi fɔ áfɛ́ ɛta wuú mammua ji, ágií ji áké, “Nnó ɛbɛ́ ɛsé ɛkamé nnó mende awá neba ne mendée wuú?” ");
INSERT INTO anvNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Jisɔs ashuú ɛbwɔ́ meko aké, “Ɛbɛ ɛwé Mosis achyɛ́ ɛnyú gétúgé neba ɛjɔɔ́ nnó?” ");
INSERT INTO anvNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Ɛbwɔ́ áshuú meko áké, “Mosis abɔ agaré ɛsé nnó mende akáge chyɛɛ́ mendée wuú mekpo ŋwɛ manlɛre nnó awá neba ne akage lyaá ji.” ");
INSERT INTO anvNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Ne Jisɔs ajɔɔ́ ne ɛbwɔ́ aké, “Ɛlé gétúgé mekpo meto nyú ne ɛpyɛ Mosis achyɛɛ́ ɛnyú ɛbɛ́ ɛwéna. ");
INSERT INTO anvNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Tɛ ula ulɔɔ́ ɛbi Ɛsɔwɔ alɔɔ́ mankwyɛ mme, akwyɛɛ́ ɛbwɔ́, mende ne mendée. ");
INSERT INTO anvNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Getú ɛyigé na mende alyage mmá wuú ne ntɛ wuú, afɛ́ acho mmyɛ ne mendée wuú, ");
INSERT INTO anvNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","ɛbwɔ́ ápea ákwé muú ama. Ɛbwɔ́ ápɔ́ sé bɔɔ́ ápeá nana, ála muú ama. ");
INSERT INTO anvNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Ndɛre ɛlúmbɔ, bɔɔ́ abi Ɛsɔwɔ áchomé chónchó né neba ɛ́kágé muú akya nnó atyáa.” ");
INSERT INTO anvNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Jisɔs ne baá utɔɔ́ bií ákérégé mmu, ɛwyage baá utɔɔ́ bií áma gií ji mechɔ́ nebá ɛwé. ");
INSERT INTO anvNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Ajɔɔ́ ne ɛbwɔ́ aké, “Muú yi awáne neba ne mendée wuú, ajyɛ́ bá ayichá, akwé mbɔ lé ulɔ, ");
INSERT INTO anvNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","ne mendée ayi atanege menɔ wuú neba, ajyɛge ba ayichá, akwé mbɔntó lé ulɔ.” ");
INSERT INTO anvNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Bií uma bɔɔ́ fɔ ákpa baá bwɔ́ áfɛ mbaá Jisɔs nnó anɛ́ré ɛbwɔ́ amu mmyɛ, ajé ɛbwɔ́. Baá utɔɔ́ bií ágɛ́gé mbɔ, ányá ɛbwɔ́. ");
INSERT INTO anvNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Yɛ́mbɔ Jisɔs agɛ́gé mbɔ, metɔɔ́ ɛ́sɔ́ ji ajɔɔ́ ne ɛbwɔ́ aké, “Lyáge ambánékɔ́ áchwɔ́ ɛta wa, ɛkagé dégbɛ́ ɛbwɔ́ néndé gefwa ɛyigé Ɛsɔwɔ ágbárege gelú ɛyigé bɔɔ́ abi álu ndɛre baá bina. ");
INSERT INTO anvNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Gɔge me ngare ɛnyú wáwálé nnó muú yi álá kamé nnó Ɛsɔwɔ ábɛ́ mfwa wuú nkane mamane kɔɔ́ wɔ́, akpɛ́né fɔ́ né gefwa jií.” ");
INSERT INTO anvNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Ɛfɛɛ́ Jisɔs akpa baá bimbɔ ama ama né uwyaá, anɛre ɛbwɔ́ amu mmyɛ ajé ɛbwɔ́. ");
INSERT INTO anvNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Jisɔs alɔ mánjyɛ nekɛ, ndɛre ájyɛ́ mendefɔ alomé gatɛle achwɔ́ kwé ji uká aké, “Ménlɛré melɔ́mélɔ́, mpyɛɛ́ nnó ne mbɔ́ geŋwá ɛyi gélágé byɛɛ́?” ");
INSERT INTO anvNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Jisɔs ashuú ji meko aké, “Ulannó ɔkuú me muú melɔ́mélɔ́? Yɛ́ muú ayi alɔ́mé metɔɔ́ apɔ́, ɛkosé Ɛsɔwɔ mbií ne alu melɔ́mélɔ́. ");
INSERT INTO anvNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Pɔ́ ɔkage mabɛ́ Ɛsɔwɔ ayi áke, ‘Ɛkagé ɔwá muú, ɛkagé ɔkwé ulɔ, ɔjogé ɛjo, ɛkagé ɔ́tɛ́né ntɛ́sɛ́ gebyɔ́. Ɔnyɛgé manwaá, nógé ntɛ wyɛɛ́ ne mmá wyɛɛ́.’” ");
INSERT INTO anvNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Mende yimbɔ aké, “Ménlɛré nlɔ mambélé mabɛ́ yina mako tɛ dembáné ta.” ");
INSERT INTO anvNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Ájɔ́gémbɔ, Jisɔs apɛ ji domée ne gejeé aké, “Ɛla wɔ genó géma. Chó kpó unó byɛ́ uko, ɔchyɛ ŋka yimbɔ mbaá bɔɔ́ gekpo, ɔbɛɛ́ nyɛ ne gefwa né mfaánebuú, ɔchwɔ́ ɔkwɔlé me.” ");
INSERT INTO anvNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Mende yina awugé mechɔ́ ɛwé Jisɔs ajɔɔ́ apwa, alyaá afɛ́ meshwɛmeshwɛ ne mesómé néndé ji awyaá gefwa dɔɔ́. ");
INSERT INTO anvNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Jisɔs abwɔlé mmyɛ apɛ baá utɔɔ́ bií aké, “Ɛ́jweré ne muú ŋka akpɛ né gefwagé Ɛsɔwɔ.” ");
INSERT INTO anvNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Baá utɔɔ́ bií áwúgé mbɔ álá mano makpo fuú, yɛ́mbɔ Jisɔs ama jɔɔ́ ne ɛbwɔ́ aké, baá ba ɛjwéré mankpɛ né gefwagé Ɛsɔwɔ! ");
INSERT INTO anvNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Ɛ́lú wáwá nnó mpɔ mashwɔne áshwá né ɛmbú ábyamé ɛpwɔ nnó muú ŋka akpɛ né gefwagé Ɛsɔwɔ ágbárege. ");
INSERT INTO anvNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Baá utɔɔ́ bií áwúgémbɔ byɔ ukɔre ɛbwɔ́ mmu ágígé atɛ aké, “Ne ndé muú yi abɔ nyɛ́ geŋwá ɛyi gélágé byɛɛ́?” ");
INSERT INTO anvNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Jisɔs apɛ ɛbwɔ́ domeé ajɔɔ́ ne ɛbwɔ́ aké, “Unó bi upwɔɔ́ ákwaá mampyɛ, upwɔɔ́ fɔ́ Ɛsɔwɔ, néndé Ɛsɔwɔ akage pyɛ unó uko.” ");
INSERT INTO anvNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Pita alɔ manjɔɔ́ aké, “Gɛ́, ɛsé delyaá unó sé uko dékwɔlege wɔ.” ");
INSERT INTO anvNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Ne Jisɔs ashuú meko aké, “Ngarege ɛnyú wáwálé nnó, yɛ́ndémuú ayi alyaá gepú jií, yɛ́ lé áŋmɛ́ bií abi andée ne abi ande, ammá bií ne antɛ bií, baá bií ne makɔɔ́ jií né gétú ya ne gétúgé abya melɔ́mélɔ́, ");
INSERT INTO anvNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","Ɛsɔwɔ achyɛge nyɛ ji bɔɔ́ ne gejame unó fa mme yina ɛpwɔ nkane abɔ awyaá, yɛ́ úpú, áŋmɛ́ abi andée ne abi ande, ammá bií ne baá bií ne makɔɔ́ jií ne áchyɛge nyɛ ji ntó gejamégé ɛfwyale né gétú ya. Ne abɔɔ́ nyɛ ntó geŋwá ɛyi gélágé byɛɛ́ né mme ayi áchwɔ́. ");
INSERT INTO anvNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Yɛ́mbɔ gejamégé bɔɔ́ abi alú mbɔ mbɛ nana, meso gébé álaá nyɛ meso ne gejamé abi álu mbɔ meso nana ábɛɛ́ nyɛ mbɛ.” ");
INSERT INTO anvNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Jisɔs ne baá utɔɔ́ bií alyá ákwɔme ájyɛɛ́ né Jɛrosalɛ, Jisɔs alu ɛbwɔ́ mbɛ ne baá utɔɔ́ bií akwe tametame, ɛfɔ ɛpyɛ bɔɔ́ bi akwɔlege ɛbwɔ́. Ne Jisɔs asɛ baá utɔɔ́ bií makpo áfyaneápeá átɛné babá ne alɔ mangaré ɛbwɔ́ unó bi upyɛ nyɛ ne ji, ");
INSERT INTO anvNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","alɔ mangaré ɛbwɔ́ aké, “Wuúge, ɛsé dékwɔme mbɔ déjyɛɛ́ né Jɛrosalɛ, ɛwu, áfyɛɛ́ nyɛ Maá Ntɛ Mekwaá né amú anɔɔ́ baá ampyɛɛ́ upɛ Ɛsɔwɔ ne ánlɛré mabɛ́ Ɛsɔwɔ. Ɛbwɔ́ ajɔ́gé nyɛ nnó, me nkwɛ mpa, áwá me, ne áfyɛɛ́ nyɛ ji né amú bɔɔ́ abi álá pɔ́ bɔɔ́ Jus. ");
INSERT INTO anvNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Ájwyaáge nyɛ ji, ákpóo ji matyɛ mmyɛ, átulé ji ne áwá ji. Yɛ́mbɔ ndɔ́ kpogele ɛ́lɛɛ́ ɛ́kwɔnégé, akwilége nyɛ né negbo.” ");
INSERT INTO anvNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Jɛmsi ne Jɔn baá Sɛbɛdee áfɛ mbaá Jisɔs áké, “Ménlɛré dekɛlege nnó wɔ ɔpyɛ ɛse genó gefɔ.” ");
INSERT INTO anvNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Jisɔs agií ɛbwɔ́ nnó, “Ɛnyú dekɛ́lege mpyɛ nyú ndé?” ");
INSERT INTO anvNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Áshuú ji meko áké, “Ɛse dekɛlege gébégé ɔjwɔlégé né geluɔge ɛnóge, ɔpyɛ ɛsé dejwɔlé ne wɔ, muú ama né ɛgbɛ ɛbwɔnyɛ wyɛ ne ama né ɛgbɛ ɛbwɔbɛ.” ");
INSERT INTO anvNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Yɛ́mbɔ Jisɔs ajɔɔ́ ne ɛbwɔ́ aké, “Nnó ɛnyú dekage genó ɛyigé degígé mbɔ. Nnó ɛnyú dekage nyú nyɛ ŋkɔ ɛfwyale ayi me nyuú nyɛ? Nnó ɛnyú dekage wɔ nyɛ manaá ɛfwyale ami me nwɔɔ́ nyɛ?” ");
INSERT INTO anvNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Áshuú ji meko áké, “Ɛse dekage pyɛmbɔ.” Jisɔs ajɔɔ́ ne ɛbwɔ́ aké, “Ɛnyú denyuú nyɛ né ŋkɔ ayi nnyú nyɛ ne dewɔɔ́ nyɛ manaá ɛfwyale ami me nwɔɔ́. ");
INSERT INTO anvNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Yɛ́mbɔ, me fɔ́ wɔ njyaá bɔɔ́ bi ájwɔlege né ɛbwɔnyɛ wa ne abi ajwɔlege né ɛbwɔbɛ wɔ́. Malu yimbɔ alú mbaá bɔɔ́ bi abɔ manjwɔlé wyɛɛ́.” ");
INSERT INTO anvNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Baá utɔɔ́ Jisɔs abi makpo áfya áwúgé genó ɛyigé Jɛmsi ne Jɔn ájɔɔ́ mbɔ, álɔ mansɔ́ matɔɔ́ ne ɛbwɔ́. ");
INSERT INTO anvNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Jisɔs akuú ɛbwɔ́ ako ajɔɔ́ ne ɛbwɔ́ aké, Ɛnyú dekaá nnó ákpakpa bɔɔ́ abi álá pɔ́ bɔɔ́ Jus áwyaá utó mampyɛ ne bɔɔ́ bwɔ́ nkane ɛjií ɛbwɔ́. Yɛ́ ákpakpa melɔ áwyaá utó bi ajɔ́ge mechɔ́ ne bɔɔ́ bwɔ́ ɛ́byɛ́. ");
INSERT INTO anvNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Ne ɛ́bɛ́gé fɔ́ mbɔ ne ɛnyú. Yɛ́ndémuú nyú ayi akɛ́lege mambɛ muú kpaá abɔ́ mambɛ ménkpané defwɛ́ nyú, ");
INSERT INTO anvNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","yɛ́ndémuú nyú ayi ákɛ́lege mambɛ menɔmbɛ abɔ mambɛ́ ɛké mefwɛ́ mbaá bɔɔ́ ako. ");
INSERT INTO anvNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Pɛge gekpɛkpɛgé muú ndɛre Maá Ntɛ Mekwaá, ji achwɔ́ɔ fɔ́ nnó bɔɔ́ ákpá ji defwɛ́ wɔ́, achwɔ́ lé mánkpá bɔɔ́ defwɛ́ nnó achyɛ gemɛ jií mawené gejámégé bɔɔ́ né gabo. ");
INSERT INTO anvNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Jisɔs ne baá utɔɔ́ bií akwɔné né Jɛriko. Ndɛre ályaá ajyɛɛ́, gejamégé bɔɔ́ ákwɔ́lege ɛbwɔ́ meso. Muú amɛ nónómé fɔ akamege Batimus maá Timɔs ajwɔ́lé né mapea meti akɔɔ́ dekɔ. ");
INSERT INTO anvNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Awúgé nnó Jisɔs ayi Nasarɛt ne akoóge mbɔ alɔ mankalé aké, “Jisɔs mpyáne Dɛvid, gɛ́ me meshwɛ.” ");
INSERT INTO anvNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Gejamégé bɔɔ́ áweé ji áké jwɔle nyame, yɛ́mbɔ akálege wyɛ kálege ne ɛshyɛ aké, “Mpyáne Dɛvid gɛ me meshwɛ.” ");
INSERT INTO anvNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Jisɔs awúgé mbɔ atɛné, ajɔɔ́ aké, “kuúge ji achwɔ́.” Ájyɛ kuú ji áké, “Kwilé ka chwɔ́ ɔfɔge, ákuú wɔ.” ");
INSERT INTO anvNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Muú amɛ nónómé yimbɔ afɛre nkú gefwine wuú aŋmé, anyo akwilé ka ája ji áfɛ́ mbaá Jisɔs. ");
INSERT INTO anvNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Jisɔs agií ji aké, “Ndé genó wɔ ɔkɛ́lege nnó me mpyɛ ɛta wyɛ́?” Muú amɛ nónómé yimbɔ ashuú meko aké, “Ata, nkɛlege nnó ɔpyɛ́ me ngɛ́né mbaá.” ");
INSERT INTO anvNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Jisɔs ajɔɔ́ ne ji aké, “Chó mmu gepú jyɛ, metɔɔ́ ɛwé wɔ ɔfyɛɛ́ ne me ɛpyɛ wɔ ɔtoó.” Tɛ́nétɛ́né yimbɔ alɔ mángɛ́né mbaá ne akwɔlege ji. ");
INSERT INTO anvNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Ndɛre Jisɔs ne baá utɔɔ́ bií álɛ́ kwɔ́kwɔ́lé ne Jɛrosalɛ, ákwɔnégé Bɛtfage ne Bɛtani baá malɔ áyi álú mfaá Mékwɛ́ Olif, atɔ́ baá utɔɔ́ bií makpo ápeá nnó ábɔ́ mbɛ. ");
INSERT INTO anvNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Ajɔɔ́ ne ɛbwɔ́ aké, “Chogé né maá melɔ ayi alu mbɔ ɛnyú né mbɛ. Ndɛre dékpɛne wyɛ, dégɛne nyɛ maá géjuŋá ayi áshií muú álú daŋkɛ́ wyɛ. Kaáge, déchwɔ́ ne geji. ");
INSERT INTO anvNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Ne mbɔgé muú agigé ɛnyú nnó waá aké dekaá, garege ji nnó, Ata ne akɛ́lege, ne anérégé atɔmé nyɛ gekéré wáwá.” ");
INSERT INTO anvNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Ájyɛ́gé, ágɛ́ maá géjuŋá yimbɔ ndɛre áshií né mbɛ menombi ɛgbɛ menɔ meti. Álɔ mánkaá geji, ");
INSERT INTO anvNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","ndɛre ákaágé bɔɔ́ abi álú ɛfɛɛ́ ágií ɛbwɔ́ áké, “Dekaáge géjuŋá yimbɔ ndé?” ");
INSERT INTO anvNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Baá utɔɔ́ Jisɔs ágaré bɔɔ́ bimbɔ wyɛ nkane Jisɔs abɔ́ ajɔɔ́ gébégé atɔme ɛbwɔ́, ne ályaá ɛbwɔ́ ájyɛ ne geji. ");
INSERT INTO anvNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Áchwɔ́gé ne géjuŋá yimbɔ mbaá Jisɔs, áfere mandeé bwɔ́ ágyaá géjuŋá yimbɔ né meso, Jisɔs akwɔ ajwɔlé mfaá. ");
INSERT INTO anvNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Gejamégé bɔɔ́ ágyaáge mandeé bwɔ́ né meti nnó géjuŋá yimbɔ gekɛné mfaá, abifɔ ásɔ́rege uwɔ́ mámɛ́ ágyaáge meti ntó. ");
INSERT INTO anvNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Ndɛre ajyɛ bɔɔ́ abi álu mbɛ ne abi álu meso ákálege áké, “Matame mábɛ́ ne Ɛsɔwɔ! Mejé ɛbɛ́ ne muú ayi achwɔ́ né mabɔ Ata.” ");
INSERT INTO anvNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Mejé ɛbɛ ne gefwage ntɛ sé Dɛvid ɛyi gechwɔɔ́ mbɔ! Matame mábɛ́ ne Ɛsɔwɔ ayi alú né mfaánebuú ɛniné mfaá mfaá! ");
INSERT INTO anvNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Ndɛre Jisɔs akpɛné né Jɛrosalɛ, ajyɛ kpɛ né mmú ɛcha upɛ Ɛsɔwɔ apɛ yɛ́ndégenó. Ágɛ́gé nnó gébé gekoó, asɛ baá utɔɔ́ bií áfyanéápeá ákeré né melɔ Bɛtani manjyɛ bɛle wyɛ. ");
INSERT INTO anvNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Bií ujyágé, ndɛre ɛbwɔ́ ályaá Bɛtani ákérégé meso, mesa alɔ mamyɛ ji. ");
INSERT INTO anvNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Atɛne tɛtɛ agɛ́ genɔɔ́ fig ne gejámégé bya wyɛ, afɛ́ apɛ nnó agɛne nyɛ gempome fɔ wyɛ. Akwɔ́négé agɛ́ yɛ́ gefɔ́ wɔ́ ɛkosé bya ubíubí néndé gébé ɛyigé unɔɔ́ fig uwɔ́me umpomé gelu gakwáne. ");
INSERT INTO anvNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Jisɔs ajɔɔ́ ne genɔɔ́ fig ɛyigembɔ aké, “Tɛ mme abyɛɛ́ muú amage nyɛɛ́ sé gempome jyɛɛ́.” Baá utɔɔ́ bií áwuú genó ɛyigé ji ajɔɔ́. ");
INSERT INTO anvNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Ɛbwɔ́ ákwɔnégé né Jɛrosalɛ, Jisɔs akpɛ né mmu ɛcha upɛ Ɛsɔwɔ, alɔ mambu bɔɔ́ abi ákpóo ne abi ánáme unó né mmu. Atyá makpókpógélé bɔɔ́ abi ákɛne gesegé maŋka mankwɔré ne malu ujwɔ́lé bɔɔ́ ako abi ákpóo upwine melɔ ɛbi ápyɛ upɛ Ɛsɔwɔ ne ubi. ");
INSERT INTO anvNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Ne ama kame sé nnó muú áma kpá genó gese akoó yɛ ne geji né mmu ɛcha upɛ Ɛsɔwɔ wɔ́. ");
INSERT INTO anvNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Ne alɔ manlɛre bɔɔ́ aké, “Ása mmu ŋwɛ Ɛsɔwɔ nnó Ɛsɔwɔ aké, ‘Gepú ya ákuú nyɛ geji nnó gepúgé mmyɛmenɛne mbaá umɛ malɔ mako.’? Yɛ́mbɔ ɛnyú débwɔlé géjí gelá melu ɛwé ánjó ábige wyɛɛ́.” ");
INSERT INTO anvNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Anɔɔ́ baá abi ápyɛɛ́ upɛ Ɛsɔwɔ ne ánlɛré mabɛ́ Ɛsɔwɔ áwúge depɔ tiré Jisɔs apyɛ, álɔ mánkɛle meti nnó áwá ji. Áfɔɔ́ ji gétúgé gejamégé bɔɔ́ álaá meno mekpo fuú né unó bi Ji alɛrege. ");
INSERT INTO anvNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Nkwale akwɔnege, Jisɔs ne baá utɔɔ́ bií álya melɔ kpaá áfɛ ábɛlé mbaá ayicha. ");
INSERT INTO anvNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Ne dondo ayi Jisɔs ne baá utɔɔ́ bií ákerege meso, ágɛ genɔɔ́gé fig ɛyi Jisɔs abɔ jɔɔ́ nnó gemage wɔ se umpome nkane gegbó mɛ. ");
INSERT INTO anvNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Pita atege genó ɛyigé Jisɔs abɔ ajɔɔ́ ne genɔ́ge fig yimbɔ, ajɔɔ́ ne ji aké, “Ménlɛré, gɛ́ genɔɔ́ ɛyigé ɔ́bɔ́ ɔjɔɔ́ nnó gemage wɔ sé umpome gégbó.” ");
INSERT INTO anvNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Ne Jisɔs ashuú ɛbwɔ́ meko aké, “Fyɛge matɔɔ́ nyú ne Ɛsɔwɔ. ");
INSERT INTO anvNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Ngarege ɛnyú wáwálé nnó, muú ajɔ́ɔge ne mékwɛ́ ɛwéna nnó, ‘Kwilé fa ɔkwéné mmu ɛbɛɛ́ mega,’ ayi ála pɔ́ ne dembyɔ né metɔɔ́ ne akamege nnó genó ɛyigé ji ajɔɔ́ gepyɛɛ́ nyɛ, Ɛsɔwɔ apyɛ wyɛ nkane ji ajɔɔ́. ");
INSERT INTO anvNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Ngarege ɛnyú nnó dégíge yɛ́ndégenó né mmyɛmenɛne mbaá Ɛsɔwɔ, kamege nnó désɛ mɛ́ geji, ne gebɛɛ́ nyɛ ɛyigé nyú. ");
INSERT INTO anvNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Ne yɛndé gebé ɛnyú deke denɛnemmyɛ, debɔ́ manjinte gabo yi bɔɔ́ ápyɛɛ́ ɛta nyú nnó Ntɛ nyú yi alu né mfaánebuú ajinte gabo awu nyú ntó. ");
INSERT INTO anvNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Yɛ́mbɔ dela jinté gabo yi bɔɔ́ ápyɛ ɛtá nyú wɔ́, ntɛ nyú yi alu né mfaánebuú ajígé fɔ́ nte gabo awu nyú.” ");
INSERT INTO anvNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Jisɔs ne baá utɔɔ́ bií ákéré meso né Jɛrosalɛ. Ndɛre akwɔ́ne, akpɛ né ɛcha upɛ Ɛsɔwɔ alɔ mankɛ́ne né mmu, anɔɔ́ baá abi ápyɛɛ́ upɛ Ɛsɔwɔ ne ánlɛré mabɛ́ Ɛsɔwɔ chóncho ne ákpakpa melɔ ájyɛ gií ji áké, ");
INSERT INTO anvNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","“Wɔ ɔpyɛ unó bina ne ndé uto, ne waá achyɛɛ́ wɔ uto ubi?” ");
INSERT INTO anvNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Jisɔs ashuú ɛbwɔ́ meko aké, “Me ntó nwyaá awa nkwɛ́ mangií ɛnyú, dégarege me, me ntó ngare ɛnyú uto bi me nwyaá ne mpyɛɛ́ unó bina. ");
INSERT INTO anvNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Agií ɛbwɔ́ aké, Waá achyɛ Jɔn uto manwyaá bɔɔ́ manaá Ɛsɔwɔ, Ɛsɔwɔ waá akwaá? Shuúge me meko.” ");
INSERT INTO anvNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Álɔ manyɛ́ge mbeé ne atɛ áké, “Dejɔ́gé mbɔ nyɛ nnó? Ɛ́bɛge dejɔɔ́gé nnó, ‘Ɛlé Ɛsɔwɔ ne achyɛɛ́ Jɔn uto bí,’ agige nyɛ ɛsé aké, ‘ulannó ne delá kamé mekomejɔɔ́ wuú wɔ́?’ ");
INSERT INTO anvNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Nnó dejɔɔ́ nnó utó bií utané mbaá ákwaá?” Ákage jɔɔ́ fɔ́ mbɔ gétúgé áfɔɔ́ bɔɔ́ bi álu ɛfɛɛ́ nendé yɛ́ndémuú ajɔɔ́ge nnó Jɔn abɔ́ alu muú ɛkpávé Ɛsɔwɔ wáwálé. ");
INSERT INTO anvNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Ɛwéna ɛpyɛ ɛbwɔ́ áshuú Jisɔs meko áké, “Ɛsé dekaá wɔ́”. Jisɔs ashuú ntó ɛbwɔ́ meko aké, “Yɛ́ me ntó ngárégé fɔ́ ɛnyú muú yi achyɛɛ́ me uto ne mpyɛ́ unó bina.” ");
INSERT INTO anvNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Ɛfɛɛ́ Jisɔs alɔ manto ɛbwɔ́ nekanemejɔɔ́ aké, “Mende fɔ abɔ atɔ́ mekɔɔ́ wuú, apɛ unɔɔ́ ɛbi ákuú vine, ábɔgé umpome bií ápyɛɛ́ mmɔɔ́, anɔ gebame agyaá ɛwú mme, achó ɛmbu, akwyɛɛ́ mbaá ayi áŋámege umpome mampyɛ mmɔɔ́. Atɛne ɛnyɔŋ mbaá ayi muú ájwɔ́lege ábamé mekɔɔ́. Asɛ bɔɔ́ uségé afyɛ́ né mekɔɔ́ ɛwémbɔ. Atane afɛ́ nekɛ né melɔ fɔ. ");
INSERT INTO anvNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Gébé gekwɔ́négé ɛyigé ásɔrege umpome ɛbimbɔ, mbɔɔ́ mekɔɔ́ atɔ́ maá defwɛ́ wuú ama nnó áchyɛɛ́ ɛbií unó mbwɛ́ ɛbi utane né mekɔɔ́ ɛwémbɔ. ");
INSERT INTO anvNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Yɛ́mbɔ bɔɔ́ uségé bimbɔ áchyɛɛ́ wɔ́, ágbaré maá defwɛ́ yimbɔ átulé, ábú ji akéré amuamu. ");
INSERT INTO anvNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Mbɔɔ́ mekɔɔ́ ama tɔ́ maá defwɛ́ ayifɔ, bɔɔ́ bimbɔ ápyɛ ji ntó átulé, ákɛre ji upa mekpo, áchyɛɛ́ ji mekpo genɔɔ́. ");
INSERT INTO anvNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Ama kere atɔ́ ayi agbeé makpo alɛɛ́, ji yimbɔ ágbare áwá. Atɔ gejamege abifɔ, átulé abifɔ, áwá abifɔ. ");
INSERT INTO anvNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Ɛlá le maá wuú ayi mende ama ayi abɔɔ́ gejeé ne ji dɔɔ́, kwyakwya achwɔ́ fére maá yimbɔ atɔ́, afɛrege nnó áchyɛge nyɛ ji ɛ́nógé. ");
INSERT INTO anvNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Yɛ́mbɔ bɔɔ́ uségé bimbɔ ágɛ́gé ji álɔ mánjɔɔ́gé áké ne atɛ, ‘Gɛ́ge menyɛɛ́ geteé mbɔɔ́ mekɔɔ́ na, chwɔ́ge déwá ji, geteé jií gelaá ɛyigé ɛsé.’ ");
INSERT INTO anvNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Ápyɛgé maá mbɔɔ́ mekɔɔ́ yimbɔ, áwá, ábwɛɛ́ geŋkwɔ́ áfomé meso gébámé.” ");
INSERT INTO anvNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Jisɔs ánerege agií ɛbwɔ́ aké, “Ɛnyú defɛré nnó mbɔɔ́ mekɔɔ́ yimbɔ apyɛ nyɛ nnó ne bɔɔ́ uségé bimbɔ? Abɔ́ manchwɔ́ awá bɔɔ́ bimbɔ achyɛɛ́ mekɔɔ́ ɛwémbɔ mbaá bɔɔ́ abicha. ");
INSERT INTO anvNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Ɛnyú dejɔɔ́ mɛ né mmu ŋwɛ Ɛsɔwɔ nnó, ‘Ntaá ɛniné antɛné upú ashyaá nnó nélɔ́mé, néni ne nélaá menɔ ntaá ayi ágbaré ɛkwɔ gepú. ");
INSERT INTO anvNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Ata ne apyɛ nnó ɛwú ɛbɛ mbɔ, ne ɛlu gekpɛkpɛ genó né amɛ se.’” ");
INSERT INTO anvNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Jisɔs ánerege mántó nekanemejɔɔ́ ɛni, ákpakpa bɔɔ́ Jus ákaá nnó ajɔge mbɔ lé ne ɛbwɔ́. Ákɛlé meti mampyɛ ji, yɛ́mbɔ áfɔ́ɔ nyá gejamégé bɔɔ́ abi álú ɛfɛɛ́ ályaá ji áfɛ́. ");
INSERT INTO anvNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Ɛwyage átɔ bɔɔ́ Farasi fɔ ne ɛkwɔ́ Hɛrɔd nnó ájyɛ ágií Jisɔs gejamégé bɔ nkwɛ́ nnó akwegé nekwené meno, ágbaré ji. ");
INSERT INTO anvNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Ájyɛ́gé mbaá Jisɔs ájɔɔ́ ne ji áké, “Ménlɛré ɛsé dékaá nnó ɔlu muú wáwálé. Ɔsɛle yɛ́ndémuú janja, ɔfɔɔ́ fɔ́ amɛ bɔɔ́. Ɔlɛrege bɔɔ́ unó ndɛre Ɛsɔwɔ akɛ́lege wáwálé. Garé ɛsé, nnó ɛbɛ́ se ɛkame nnó déchyɛ́gé ŋkámakpo mbaá mfwa Rom waá déchyɛ́gé? ");
INSERT INTO anvNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Nnó déchyɛ waá déchyɛgé?” Yɛ́mbɔ Jisɔs agɛ́ mɛ defyá debwɔ́, agií ɛbwɔ́ aké, “Ndé ɛnyú dépɛ́nege me mataá? Chwɔ́ge me ne sére me nchɛ́re.” ");
INSERT INTO anvNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Áchwɔ́gé ne ji, agií ɛbwɔ́ aké, “Mekpo wá na ne mabɔ waá na ásamé né ŋka ɛyi?” Áshuú ji meko áké, “Ɛ́lé mekpo mfwa Rom ne mabɔ mií.” ");
INSERT INTO anvNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Jisɔs agaré ɛbwɔ́ aké, “Chyɛɛ́ge mfwa Rom genó ɛyi gélú ɛjií ne chyɛɛ́ge ntó Ɛsɔwɔ genó ɛyi gélú ɛyi Ɛsɔwɔ.” Áwuúgé meko ayi Jisɔs ashuú ɛbwɔ́ álaá mano mekpo fuú. ");
INSERT INTO anvNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Ɛ́wyágé bɔɔ́ Sadusi fɔ áchwɔɔ́ mbaá Jisɔs. Ɛbwɔ́ ákame nnó muú agbogé, akwilége sé né negbo. Ájɔɔ́ ne Jisɔs áké, ");
INSERT INTO anvNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Ménlɛré, Mosis abɔ asá né mmu ŋwɛ ɛbɛ́ se nnó, ‘Muú agbogé alyage mendée wuú ayi álá byɛ baá ne ji wɔ́, meŋmó wuú abɔ mansɛ mekwi mendée yimbɔ nnó ábyɛ́gé baá ábɛ́ lé né mabɔ ami mewené meŋmo yimbɔ.’ ");
INSERT INTO anvNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Né gébégé fɔ́ áŋmó fɔ ákénéama abi ande álú, ayi mbɛ abá mendée agboó yɛ́ maá apɔ́. ");
INSERT INTO anvNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Ayi akwɔ́lege ji asɛ mendée yimbɔ né ukwi ji ntó agboó yɛ́ maá apɔ́. Wyɛmbɔ ne ɛpyɛ ne ayi agbeé makpo álɛɛ́. ");
INSERT INTO anvNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Mbɔ ne ɛpyɛ ne aŋmó bimbɔ akénéama. Ɛbwɔ́ ako ágbó ayi yɛ muú alá byɛ maá ne mendée yimbɔ wɔ́. Ɛ́bɛ́légé mendée yimbɔ ntó agbó. ");
INSERT INTO anvNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Ne ndɛre ɛbwɔ́ ako ábáné mbɔ mendée yina, gébégé ákwilégé né negbo, mendée yina abɛɛ́ nyɛ ayi waá?” ");
INSERT INTO anvNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Jisɔs ashuú ɛbwɔ́ meko aké, “Ɛnyú dékaá nnó delu gyɛɛ́ wɔ́? Delu gyɛɛ́ nénde dékágé fɔ́ mekomejɔɔ́ Ɛsɔwɔ ne utó bií. ");
INSERT INTO anvNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Ama jɔɔ́ ne ɛbwɔ́ aké, gébégé bɔɔ́ ákwilégé né negbo, neba nébɛɛ́ se. Álaá le nkane makiɛ́nné Ɛsɔwɔ né mfaánebuú. ");
INSERT INTO anvNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Ne gétúgé mechɔ bɔɔ́ ágbógé ákwilégé né negbo, ɛnyú delu danjɔɔ́ genó ɛyigé ásámé mmu ŋwɛ Mosis? Né abya genɔɔ́ ɛyigé mewɛ ɛbɔ ɛluli wyɛ gélá sɔɔ́ge, Ɛsɔwɔ ajɔɔ́ ne Mosis aké, ‘Me nlu Ɛsɔwɔ ayi Abraham, ne ayi Asek ne ayi Jakɔb’. ");
INSERT INTO anvNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Ɛsɔwɔ apɔ́ fɔ́ ayi awuú bɔɔ́, alú Ɛsɔwɔ ayi bɔɔ́ abi álú abɛ. Ɛnyú bɔɔ́ Sadusi ako delu gyɛ́ɛ né mechɔ́ ɛwéna.” ");
INSERT INTO anvNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Ménlɛré mabɛ́ Ɛsɔwɔ fɔ ayi alú ɛfɛɛ́ gébégé Jisɔs ajɔɔ́ge ne bɔɔ́ Sadusi, ágɛ́gé nnó Jisɔs ashuú ɛbwɔ́ meko ne deŋga ágií ji áké, “Ɛbɛ́ Ɛsɔwɔ ɛwéndé ɛŋea ɛpwɔ́ɔ mabɛ́ mako?” ");
INSERT INTO anvNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Jisɔs ashuú ji meko aké, “Ɛbɛ́ ɛwé ɛpwɔ́ɔ mabɛ mako ɛle ɛwé ɛjɔɔ́ nnó, bɔɔ́ Isrɛli wuúge Ɛsɔwɔ ntɛ se ayi abɔ ɛsé ako alu ama, ");
INSERT INTO anvNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","gbógé ne Ata Ɛsɔwɔ wyɛɛ́ ne metɔɔ́ wyɛɛ́ meko, ne mendoó wyɛɛ́ meko ne ufɛ́ré byɛɛ́ uko. Tégé wyɛɛ́ lé ji yɛ́ndégébé, pyɛ́gé utɔɔ́ bií ne ɛshyɛ wyɛɛ́ meko, ");
INSERT INTO anvNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","ne ɛwé ɛgbeé apeá ɛke, gbógé ne ntɛ méŋmɛ́ wyɛɛ́ ndɛre ɔgboó ne gemɛ jyɛɛ́. Yɛ́ ɛbɛ́ ɛwé ɛŋeá ɛpwɔ́ɔ ayina apeá ɛ́pɔ́.” ");
INSERT INTO anvNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Ménlɛré mabɛ́ Ɛsɔwɔ yimbɔ ajɔɔ́ ne Jisɔs aké, “Ménlɛré, ɔjɔɔ́ cháŋéné, ɛlu wáwálé nkane ɔjɔɔ́ nnó Ɛsɔwɔ alu ama ayichá apɔ́. ");
INSERT INTO anvNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Ne ɛ́lú ntó wáwálé nnó ɔbɔ́ mambɔ́gé gejee ne Ɛsɔwɔ ne metɔɔ́ wyɛɛ́ meko, ɔbɔ mántégé wyɛ lé ji yɛ́ndégébé, ɔbɔ mámpyɛ́gé utɔɔ́ bií ne ɛshyɛ wyɛɛ́ meko. Ne ɔbɔ mambɔ gejeé ne atɛ bɔɔ́ nkane ɔbɔ gejeé ne gemɛ jyɛɛ́. Ɔbelege mabɛ́ ayina apeá ɛlɔ ɛpwɔ yɛ́ndé gefɔgé upɛ ne ɛchyɛ ɛwé ɔsɔɔ́ né mewɛ ɔchyɛge mbaá Ɛsɔwɔ nkane ɛchyɛ.” ");
INSERT INTO anvNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Jisɔs agɛgé nnó menlɛré mabɛ Ɛsɔwɔ ayina ashuú meko melɔ́mélɔ́, ajɔɔ́ ne ji aké, “Ɛla wɔ gachyɛ́ ne ɔkpɛ́ né gefwage Ɛsɔwɔ. Ɛlɔ né gébé ɛyigémbɔ yɛ́ muú ayi ama mua mangií ji nkwɛ́ apɔ́.” ");
INSERT INTO anvNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Ndɛre Jisɔs alɛ́rege bɔɔ́ né ɛcha upɛ Ɛsɔwɔ, ajɔɔ́ aké, “Ɛpyɛ nnó ne ánlɛré mabɛ́ Ɛsɔwɔ áké Muú yi Ɛsɔwɔ akweré ji ɛlá gefwa alu mpyáne mfwa Dɛvid? ");
INSERT INTO anvNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Mendoó Ukpea ne ɛpyɛ mfwa Dɛvid jimbɔ abɔ ajɔɔ́ nnó, ‘Ata Ɛsɔwɔ aké ne Ata wa, jwɔlé fa né ɛgbɛ́ ɛbwɔnyɛ wa né geluɔ́ge ɛ́nógé kpaá tɛ mpyɛɛ́ bɔɔ́ mawámé byɛɛ́ álaá ɛké mboó genɔɔ́ ayi ɔnɛ́rege uká byɛɛ́ mfaá.’ ");
INSERT INTO anvNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Ne mbɔgé mfwa Dɛvid akú Muú yi Ɛsɔwɔ akweré ji ɛlá gefwa nnó ‘Ata wuú’, ɛpyɛɛ́mbɔ nnó ne muú yimbɔ ámágé bɛ́ mpyáne wuú?” Ndɛre Jisɔs alɛrege mbɔ mmyɛ muú ayi alu ɛfɛɛ́ matɔɔ́ ágɔ́ɔ ɛbwɔ́ manwúgé unó bi ji álɛrege. ");
INSERT INTO anvNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Ndɛre Jisɔs alu lɛ́rege aké, “Sɛ́ge gébé ne gepɔgé ánlɛré mabɛ́ Ɛsɔwɔ. Ɛbwɔ́ ágboó mámfyɛ́gé bɔ nkúu átyɛ́ átyɛ́, ákɛ́né ágyaáge ntoné gese nnó bɔɔ́ átámégé ɛbwɔ́ ne ɛ́nógé. ");
INSERT INTO anvNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Ɛbwɔ́ ágboó ntó mánjwɔ́lé né malu ɛ́nógé né mmu macha mmyɛmenɛne, ne ájyɛ́gé ɛpaá, ájyaá lé malu afwa ne ájwɔ́lege. ");
INSERT INTO anvNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Ɛbwɔ́ ányɛ́ ákwi ándée upwɔɔ́, ánɛ́ne mmyɛ áwyáge mámbwɔlé bɔɔ́ nnó álú bɔɔ́ alɔ́álɔ́. Ndɛre ápyɛmbɔ ɛfwyale ɛbwɔ́ ɛjame nyɛ ɛpwɔ.” ");
INSERT INTO anvNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Jisɔs anérégé manlɛre, ajyɛ jwɔlé toitoi ne mekwa ɛwé áfyɛɛ́ ŋka apɛle ndɛre bɔɔ́ áchwɔɔ́ áfyɛ maŋka bwɔ́ mmu genó ɛyigé áfyɛ ŋka Ɛsɔwɔ. Agɛ́ ndɛre gejámégé bɔɔ́ maŋka áchwɔ́ áfyɛ́ɛ gejamégé ŋka. ");
INSERT INTO anvNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Ɛwyage mbya mekwi mendée fɔ achwɔ́ fyɛ́ ntó baá ubaá ŋgba ápeá abi álá fuú yɛ genó wɔ́. ");
INSERT INTO anvNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Mekwi mendée yimbɔ achyɛge mbɔ, Jisɔs akú baá utɔɔ́ bií aké, “Ngarege ɛnyú wáwálé nnó ɛchyɛ ɛwé mbya mekwi mendée yina achyɛɛ́ ɛpwɔ ɛwé yɛ́ndémuú áchyɛɛ́. ");
INSERT INTO anvNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Yɛ́ndémuú áferé ɛkɛkɛ ŋka né gejamé ɛyi ji awyaá achyɛ́, yɛ́mbɔ, yɛ lé mekwi mendée yina alu mbya, akwe ula géba jií achyɛɛ́.” ");
INSERT INTO anvNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Jisɔs ályáge ɛcha upɛ Ɛsɔwɔ, maá utɔɔ́ wuú ama ajɔɔ́ ne ji aké, “Ménlɛré, pɛ uchánchá upú ɛbi átɛné ne uchánchá mataá.” ");
INSERT INTO anvNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Anérégé, Jisɔs ashuú ji meko aké, “Pɔ́ ɔgɛ́ mbɔ ukpɛ́kpɛ́ upú bina? Umúge nyɛ kpá ne mataá ne mataá. Yɛɛ́ ntaá némaá ɛni nélaá nyɛ mfaá ntɛ népɔ́.” ");
INSERT INTO anvNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Ɛwyage ndɛre Jisɔs ajyɛ jwɔ́le né mfaá Mékwɛ Olif ɛ́wé ɛ́lú toitoi ne ɛcha upɛ Ɛsɔwɔ. Pita, Jɛmsi, Jɔn ne Andru áfɛ́ mesomeso ájyɛ gií ji áké, ");
INSERT INTO anvNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Garé ɛse, nde gébé ɛyige depɔ tiré na depyɛ́ nyɛ? Ne ndé gepɔ ɛse dégɛ́ne nyɛ ne dékaá nnó unó bina uko upyɛ nyɛ wáwálé?” ");
INSERT INTO anvNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Jisɔs alɔ mangaré ɛbwɔ́ aké, “Sɛ́ge gébé ɛkagé muú fɔ ábwɔ́lé ɛnyú dénó mewaá. ");
INSERT INTO anvNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Njɔge mbɔ, néndé gejamégé bɔɔ́ ásɛ́le nyɛ mabɔ ma áchwɔ́ ɛta nyú. Adoó nyɛ ɛbwɔ ɛwɔ́mé ájɔ́ɔge áké, ‘Me ne nlú’ Ápyɛ nyɛ mbɔ ábwɔlé gejamégé bɔɔ́ ánó mewaá. ");
INSERT INTO anvNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Ne déwuú nyɛ ntó abya be kwɔ́kwɔ́lé ne ɛnyú, ne ɛbi ámmyɛ tɛtɛ, Yɛ́mbɔ gébégé unó bina uké upyɛɛ́, débɛgé fɔ́ ne ɛfɔ. Néndé unó bina ubɔ mampyɛ ne ɛpɔ́fɔ́ nnó mme yina achwɔ kwya wɔ́. ");
INSERT INTO anvNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Gébé ɛyigémbɔ ntó malɔ kpakpa ámmyɛ nyɛ ne atɛ ne atɛ afwa ne bɔɔ́ bwɔ́ ámmyɛ nyɛ ne atɛ, ɛmímí mesa ɛkwene nyɛ malumalu. Mme yina anyíge nyɛ́ ne ɛshyɛ abwɔlé né gejamégé malu. Ɛwéna ɛbɛ́ nyɛ ɛké lé ula ulɔ ubalé ɛbi mendée awúu gébégé nebyɛ neké nemmyɛ ji. ");
INSERT INTO anvNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Sɛ́gé gébé, kaáge nnó ápyɛ́ne nyɛ ɛnyú áfyɛ́ né amu ákpakpa melɔ ápa mpa ɛnyú mmu macha ɛso. Átúlege nyɛ ɛnyú né macha mmyɛmenɛne. Né getú ya, ájáme nyɛ ɛnyú détɛne né mbɛ ushu bɔ gɔ́mena ne afwa melɔ. Ápyɛgémbɔ kaáge nnó degɛ mbɔ lé meti mangaré ɛbwɔ́ mekomejɔɔ́ wa. ");
INSERT INTO anvNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Ne gemɛ́gé nnó mme yina akwya, bɔɔ́ ábɔ́ mangaré abya Ɛsɔwɔ melɔ́mélɔ́ né malɔ mako. ");
INSERT INTO anvNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Gébége ápyɛgé ɛnyú ɛkagé dedorégé mmyɛ mankɛlé uchuú mejɔɔ́ ɛbi déjɔɔ́ge. Gébé gékwɔnégé jɔ́gé uchu mejɔɔ́ ɛbi uchwɔ́ ɛnyú meno, néndé uchu mejɔɔ́ ɛbi déjɔ́gé upɔ́fɔ́ ɛbi ɛnyú ɛlé Mendoó Ukpea ne ɛ́chyɛ́ge nyɛ ɛnyú. ");
INSERT INTO anvNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Ne gebé ɛyígémbɔ ntó, aŋmó áchyɛ́ge nyɛ́ atɛɛ́ aŋmó nnó áwá. Antɛ áchyɛgé nyɛ́ baá bwɔ́ nnó áwá. Baá átɛ́nege nyɛ́ ukɔ́lɔ́ ne ammá bwɔ́ ne antɛ bwɔ́ mampyɛ nnó áwá ɛbwɔ́. ");
INSERT INTO anvNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Bɔɔ́ ako ápaá nyɛ ɛnyú gétúgé délú áŋkwɔlé ba. Yɛ́mbɔ yɛ́ndémuú ayi akogé metɔɔ́ tɛ kwyakwyaá, áférege nyɛ ji né ɛfwyale gabo. ");
INSERT INTO anvNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Jisɔs afɛ mbɛ mánjɔge aké, “Gebobogé genó ɛyi gechyɛge mekpo unɔɔ́ mbaá Ɛsɔwɔ, gepyɛɛ́ nyɛ́ né malu ayi géláge pɔ mampyɛ. (Muú ayi akúu ŋwɛ yina asɛ gebé nnó ɛfwyale ɛchwɔɔ́.) Gébé ɛyigémbɔ, bɔɔ́ abi álu né gebagé mewaá Judiya ábó ájyɛ ákwɔ́ mfaá makwɛ ábií. ");
INSERT INTO anvNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Yɛɛ́ muú ayi alú mfaá gepú ɛkagé akyaá nnó ashulege mme ajyɛ bɔ́ genó né mmu gepú jií. ");
INSERT INTO anvNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Muú ayi alú ntó né mekɔɔ́ áchɔgé yɛ́ gébé nnó akere mmú achwɔɔ́ bɔ nku gefwene wuú ne ábó. ");
INSERT INTO anvNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Ɛ ɛ́ ɛbɛ́ɛ nyɛ mbɔ nnó ne andeé abi álú ne manɛ yɛ́ ne abi áchyɛ́ge baá mámbɛ. ");
INSERT INTO anvNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Nɛ́ge mmyɛ mbaá Ɛsɔwɔ nnó ɛkagé unó bina upyɛ gébégé néba, ");
INSERT INTO anvNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","néndé ɛfwyale ɛwé ɛchwɔ nyɛ, ɛbɛɛ́ gekpɛ́kpɛ́gé ɛfwyale ɛwé délá lú daŋgɛ́ tɛ Ɛsɔwɔ akwyɛ mme yina ne yɛ́ ɛwé ɛmage bɛ sé ɛké ɛwémbɔ ɛpɔ́. ");
INSERT INTO anvNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Mbɔgé Ɛsɔwɔ álá sɔré ndɔ yimbɔ ɛla mboó wɔ́, ɛbyɛ́nnó yɛɛ́ muú ayi apome nyɛ apɔ́. Yɛ́mbɔ gétúgé bɔɔ́ abi Ɛsɔwɔ ájyaá nnó ábɛ́ abií, asɔrege nyɛ ndɔ ɛyimbɔ ɛla mboó. ");
INSERT INTO anvNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Gébégé yimbɔ, mbɔgé muú agaré ɛnyú nnó, ‘Gɛ́ge Kras, Muú yi Ɛsɔwɔ akweré ji ɛlá gefwa alu fa,’ yɛɛ́ agaré lé ɛnyú nnó, ‘Alu né’, dékamégé fɔ́ ne ji. ");
INSERT INTO anvNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Njɔ́ge mbɔ mampyɛ ɛnyú dekaá nnó, bɔɔ́ gebyɔ abi áké álu Kras ne bɔɔ́ gebyɔ abi áke álu bɔɔ́ ɛkpávé Ɛsɔwɔ ntó áchwɔɔ́ nyɛ. Áchwɔgé ápyɛɛ́ nyɛ ukpɛ́kpɛ́ ufélekpá ɛbi upwɔ amu. Ápyɛmbɔ nnó ábwɔ́lé bɔɔ́ ako ne mbɔgé meti ɛbɛge yɛ́ ɛbɛ́lé bɔɔ́ abi Ɛsɔwɔ ajyaá nnó ábɛ́ abií, ábwɔlé ɛbwɔ́ ánó mewaá. ");
INSERT INTO anvNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Sɛ́ge yɛ gébé! Dekaá nnó mbɔ́ mɛ́ mbɛ ngaré ɛnyú depɔ ɛtíré na gemɛge nnó dépyɛgé. ");
INSERT INTO anvNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Gébégé ɛfwyale ɛwéna ɛchwɔgé, tɛ́nétɛ́né ayi ɛbyɛɛ́, ŋmɛɛ́ ɛkwene nyɛ gemuagemua. Mfaá ágɛ́négé sé. ");
INSERT INTO anvNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Ambe ntó ánómege nyɛ, ne unó bi uwyaá uto né mfaánebuú unyíge nyɛ. ");
INSERT INTO anvNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Ɛfɛɛ́ ne ágɛ́ne nyɛ nkane Maá Ntɛ Mekwaá achwɔɔ́ né mmu gekó ashúlege achwɔɔ́ ne gekpɛ́kpɛ́gé uto ne ɛ́nógé. ");
INSERT INTO anvNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Wyɛ né gébé ɛyígémbɔ, atɔme nyɛ makiɛ́nné jií nnó ájyɛ́ anyweré bɔɔ́ abi ji ájyaá né mme meko nnó ábɛ́ abií mbaá ama.” ");
INSERT INTO anvNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Jisɔs ajɔɔ́ ne baá utɔɔ́ bií aké, “Pɛge gepɔge genɔɔ́ge fig degií genó wyɛ. Gébégé mata jií álɔgé mántó bya ukɛ ɛnyú dekaá nnó nshwɔné achwɔ shúle. ");
INSERT INTO anvNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Wyɛ́mbɔ ntó ne gébégé ɛnyú dégɛ́gé nkane unó bina upyɛɛ́, débɔ́ mankaá nnó gébé ɛyígémbɔ géla kwɔ́kwɔ́lé. ");
INSERT INTO anvNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Ngarege ɛnyú wáwálé nnó njyɛ ɛníné na négboó fɔ́ kpaá tɛ unó bina ukó úpyɛɛ́. ");
INSERT INTO anvNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Mfaá ne mme ákoóge nyɛ yɛ́mbɔ mekomejɔɔ́ wa alaá tɛ kwyakwya. ");
INSERT INTO anvNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Yɛ́ muú ayi ákaá bií né gébé ɛyígé unó bina úpyɛ́ɛ nyɛ apɔ́. Makiɛ́nné Ɛsɔwɔ ne mfaánebuú ákaágé fɔ, yɛ́ Maá Ɛsɔwɔ jimbɔɔ́ ákaá wɔ́. Ɛkosé wyɛ Ntɛ wuú ji mbií ne ákaá. ");
INSERT INTO anvNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Sɛ́gé gébé dékpómé mmyɛ, debɛ́ peé dégílé néndé ɛnyú dékaáge fɔ́ gébé ɛyígé unó bina upyɛɛ́ nyɛ.” ");
INSERT INTO anvNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Aké, “Ɛlú ɛké mende fɔ abɔ́ ajyɛɛ́ nekɛ, alyaá gepú jií ne baá défwɛ bií nnó ápɛle. Achyɛɛ́ yɛ́ndémuú ɛbi utɔɔ́, ajɔɔ́ ne ayi ábáme gepú aké, ‘Bɛ́ peé, ɔ́gílé’. ");
INSERT INTO anvNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Wyɛmbɔ ntó ne ɛnyú débɔ mambɛ peé dégílé néndé dekaá fɔ́ gébé ɛyígé mbɔɔ́ gepú akerege meso wɔ́. Akage chwɔ́ ne nkwale, metɔɔ́ utuú, gejyɛ́jyɛ́gé bií, yɛɛ́ ɛbɛ́le dondo. ");
INSERT INTO anvNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Ɛkáge akwɔ ɛnyú neŋmé ndɛre debɛ́lege dékwánege. ");
INSERT INTO anvNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Ndɛre ngarege mbɔ ɛnyú, mbɔntó ne ngárege yɛ́ndémuú nnó, Bɛ́ge peé”. ");
INSERT INTO anvNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Ndɔ ɛla ɛpea ɛyí bɔɔ́ Jus ányɛ́ɛ ɛpaá koó upú ne ɛpaá brɛd yi álá muálé. Ánɔɔ́ baá ámpyɛɛ́ upɛ Ɛsɔwɔ ne ánlɛré mabɛ́ Ɛsɔwɔ ájwɔle geju ákɛ́lege meti nnó áwá Jisɔs bibí. ");
INSERT INTO anvNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Ájɔɔ́ ne atɛ áké, “Dépyɛgé fɔ́ ji gébégé ɛpaá ɛwéna, ɛ́kágé bɔɔ́ áŋme ummyɛ né melɔ.” ");
INSERT INTO anvNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Ndɛre Jisɔs alu né melɔ́ Bɛtani mmu gepúgé Simun muú ubá anyɛ́ɛ menyɛɛ́, mendée fɔ achwɔ́ kpɛ́ mmu ne ɛ́kpómé maweé gebɛ́ ami majame ŋka dɔɔ́, ɛle lamɛ́nda ayi ɛbwɔ́ ákuú nnó nard. Anené meno ɛ́kpómé ɛwémbɔ agbɛ maweé mimbɔ né mekpo Jisɔs. ");
INSERT INTO anvNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Mendée yina apyɛge mbɔ, matɔɔ́ ásɔ́ bɔɔ́ fɔ abi álu ɛfɛɛ́ kpaá tɛ ájɔ́ge ne atɛ áké, “Mendée yina achɔɔ́ mbɔ maweé mína ndé? ");
INSERT INTO anvNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Mawée amí ákáge kpó, ásɛ gejamégé ŋka ɛyi ɛpwɔɔ́ ŋka ɛyi muu akage pyɛ né ŋmɛ, áchyɛɛ́ mbaá ubyá bɔɔ́ ne wɔ mendée yina ɔ́chɔ́ɔ mbɔ?” ");
INSERT INTO anvNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Jisɔs ajɔɔ́ ne ɛbwɔ́ ake, “Gɔgé ji abɛ nyame, ndé ɛnyú dechyɛ́ge ji ɛfwyale? Apyɛ mbɔ lé me genchánchágé genó ɛta wa. ");
INSERT INTO anvNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Ubyá bɔɔ́ úlú ne ɛnyú, dékáge poó ɛbwɔ́ yɛ́ndégébé ɛyi dékɛ́lege. Ne me mbɛɛ́ nyɛ fɔ́ ne ɛnyú gébé geko. ");
INSERT INTO anvNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Mendée yina apyɛ me genó ɛyigé ji akaáge pyɛ, abɔ́ mbɛ agbɛ me maweé mmyɛ nnó gébégé ngboge ánií me niíge. ");
INSERT INTO anvNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Ngarege ɛnyú wáwálé nnó yɛ́ndé mbaá ayi bɔɔ́ ágárege nyɛ Abya melɔ́mélɔ́ ayina né mme meko, ágárege nyɛ ntó genó ɛyígé mendée yina apyɛ. Nkane ágárege, mbɔntó ne áteé nyɛ ji yɛ́ndégébé.” ");
INSERT INTO anvNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Judas Iscarot ayi alú maá utɔɔ́ Jisɔs ama né géluágé abi áfyaneápeá, ajyɛ báne anɔɔ́ baá ámpyɛɛ́ upɛ Ɛsɔwɔ nnó ákpoó ɛbwɔ́ Jisɔs. ");
INSERT INTO anvNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Ɛbwɔ́ awuúgé gejuge Judas, matɔɔ́ ágɔ ɛbwɔ́ ányɛmeno nnó áchyɛ́ge ji ŋka. Ɛfɛɛ́ ne Judas álɔɔ́ mankɛ́légé meti ɛwé ji apyɛɛ́ ne Jisɔs akpɛ ɛbwɔ́ né ámu. ");
INSERT INTO anvNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Bií mbɛ ɛbí ányɛ́ɛ ɛpaá brɛd yi álá muálé, gébé ɛyígémbɔ ne áwáne mágɔ́nŋmé gepɛ nnó ányɛ́ ɛpaá koó upú. Baá utɔɔ́ Jisɔs ájyɛ gií ji áké, “Átá ndé mbaá yi ɔ́kɛ́lege nnó ɛsé déjyɛ́ détyɛɛ́ menyɛɛ́ ɛpaá koó upú wyɛɛ́?” ");
INSERT INTO anvNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Ágigémbɔ Jisɔs áferé baá utɔɔ́ bií ápeá, atɔ́ aké, “Chóge né melɔ́ kpaá, detuge nyɛ ne mende fɔ ayi ákpané ŋkwɔ́ manaá né mekpo, kwɔ́lege ji. ");
INSERT INTO anvNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Dekwɔnégé né gepú ɛyígé ji akpɛné, jɔ́ge ne mbɔɔ́ gepú nnó, ‘Ménlɛré aké dégií wɔ nnó, maá gepú áŋkɛɛ́ alɛ́ nnó ji achwɔgé ajwɔ́lé anyɛ́ menyɛɛ́ ɛpaá koó upú ne baá utɔɔ́ bií?’ ");
INSERT INTO anvNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Ne mbɔɔ́ gepú yimbɔ alɛrege nyɛ ɛnyú maá gepú ayi ákwyɛ́ mɛ́ ábélé né mfaá ɛnyɔ́ŋ, tyɛ́ge menyɛɛ́ sé ɛfɛɛ́.” ");
INSERT INTO anvNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Baá utɔɔ́ bimbɔ ájyɛge, ágɛ́ wyɛ yɛ́ndégenó nkane Jisɔs ajɔɔ́, átyɛ́ menyɛɛ́ ɛpaá koó upú bwɔ́ ɛfɛɛ́ ábele. ");
INSERT INTO anvNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Nkwale akwɔ́négé, Jisɔs ne baá utɔɔ́ bií makpo áfyaneápeá, áfɛ́ manyɛ́ menyɛɛ́ yimbɔ. ");
INSERT INTO anvNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Ndɛre ájwɔlé ányɛɛ́ menyɛɛ́ Jisɔs ajɔɔ́ ne ɛbwɔ́ aké, “Ngarege ɛnyú wáwálé nnó muú nyú ama achyɛge nyɛ me maŋkwaá.” Mbɔɔ́ yimbɔ alu mbɔ fa anyɛ́ menyɛɛ́ ne me. ");
INSERT INTO anvNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Baá utɔɔ́ bií áwúgé mbɔ, ála mmyɛ meshwɛmeshwɛ, yɛ́ndémuú agige ji áké, “Ata nnó ɛ́lé me?” ");
INSERT INTO anvNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Jisɔs ashuú ɛbwɔ́ meko aké, “Ɛlé muú ayi ɛse ne ji détúge nyɛ amu manta mbya né mmu akpáŋkpa. ");
INSERT INTO anvNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Ne Maá Ntɛ Mekwaá agbóo nyɛ wyɛ ndɛre ŋwɛ Ɛsɔwɔ abɔ́ ajɔɔ́ mɛ́ tɛ gachií. Utoŋkwa ubɛ ne muú ayi akpóo nyɛ Maá Ntɛ Mekwaá. Ɛ ɛ́! Mbɔgé nnó ábɛ́ dambyɛ́ muú yimbɔ, mbɔ ɛlɔ́ kpaá ɛpwɔ.” ");
INSERT INTO anvNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Ndɛre Jisɔs ne baá utɔɔ́ bií ányɛ́ɛ menyɛɛ́, abɔ́ ntó brɛd áchyɛgé matame mbaá Ɛsɔwɔ né mmyɛmenɛ́ne, agyá ntó brɛd yimbɔ ubauba, akaré mbaá baá utɔɔ́ bií ajɔ́ge aké, “Gɛ́ge menyammyɛ wa na. Sɛ́ge dényɛ́.” ");
INSERT INTO anvNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Jisɔs abwɛɛ́ ntó amó ne mmɔɔ́ né mmu, achyɛ́gé matame mbaá Ɛsɔwɔ, achyɛ baá utɔɔ́ bií ányú átu atɛ. ");
INSERT INTO anvNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Ajɔɔ́ ne ɛbwɔ́ aké, “Gɛ́ge manoó ma amí magbɛ́le mbaá gejamégé bɔɔ́ gétúgé menomenyɛ ɛwé Ɛsɔwɔ ányɛ́ ne ákwaá. ");
INSERT INTO anvNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Ngarege ɛnyú wáwálé nnó ndɛre nnyú mbɔ mmɔɔ́ mína kwyakwya, mmagé nyú sé amícha kpaá tɛ nnyú nyɛ ami makɛ gébégé Ɛsɔwɔ aké agbarege gefwa jií.” ");
INSERT INTO anvNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Ne ɛbwɔ́ ánérégé, ákwá ɛkwɔ áfɛɛ́ Ɛsɔwɔ átané ákwɔ́ mfaá Mekwɛ Olif. ");
INSERT INTO anvNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Jisɔs ajɔɔ́ ne baá utɔɔ́ bií aké, “Ɛnyú ako deboó nyɛ delyaá me ndɛre ásámé mmu ŋwɛ Ɛsɔwɔ nnó, Ɛsɔwɔ aké, ‘Nwane nyɛ membame mágɔ́ŋme ne ɛkwɔ́ mágɔ́ŋme ɛláa nyɛ tyátyá.’ ");
INSERT INTO anvNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Ne nkwílégé né negbo, mbɔ nyɛ mbɛ ne ɛnyú né gebagé mewaá Galilií.” ");
INSERT INTO anvNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Ájɔgémbɔ, Pita aké, “Yɛ́ bɔɔ́ ako ne ábó alyaá wɔ, me nlyágé fɔ́ wɔ.” ");
INSERT INTO anvNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Jisɔs ashuú ji meko aké, “Pita gɔ́ ngaré wɔ nnó utuú bina fí gemɛ́gé nnó menɔ mekwɔ akú ukúkúle upea, wɔ ɔshyaá nyɛ ukúkúle ulɛɛ́ nnó ɔ́kágé me.” ");
INSERT INTO anvNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Yɛ́mbɔ Pita aké, “Yɛ́ ɛbɛ́ lé negbo, ngbóo ne wɔ, nshyáá fɔ́ wɔ.” Wyɛ́mbɔ ntó ne abifɔ ako ájɔɔ́. ");
INSERT INTO anvNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Jisɔs ne baá utɔɔ́ bií ako áfɛ́ né melu ɛwé ákuú nnó Getsɛmanɛ. Ákwɔ́négé ɛ́wu, agaré ɛbwɔ́ aké, “Jwɔ́lege fa, kpaá tɛ nnérege manɛ́némmyɛ.” ");
INSERT INTO anvNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Ajɔgémbɔ asɛ́ Pita, Jɛmsi ne Jɔn nnó akwɔ́lé ji. Nkane ájyɛ alɔ mambɔ gejamégé meshwɛ ne masómé né metɔɔ́. ");
INSERT INTO anvNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Ajɔɔ́ ne ɛbwɔ́ aké, “Masómé amí malú me metɔɔ́, maténe me meti negbo. Yɛ́mbɔ jwɔ́lege fa debɛ peé.” ");
INSERT INTO anvNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Atégé yɛɛ́ mmyɛ mbɛ gachyɛɛ́ ató mano mme, amo ushuú mme, anɛmmyɛ nnó mbɔgé meti ɛ́lú, Ɛsɔwɔ apyɛ ɛfwyale ɛwémbɔ ɛkoó ji koóge. ");
INSERT INTO anvNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Anɛnemmyɛ aké, “Ntɛ, Ntɛ yɛɛ́ genó ɛyi gepwɔ́ɔ wɔ gepɔ́. Nnɛne wɔ mmyɛ féré amó ɛfwyale yina átáné me mmyɛ. Yɛ́mbɔ pyɛ genó ɛyigé wɔ ɔkɛlege ɛ́pɔ́ fɔ́ ɛyigé me nkɛ́lege.” ");
INSERT INTO anvNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Ánérégé akeré meso mbaá ayi bɔ Pita álú, achwɔ báne ɛbwɔ́ ndɛre ábɛ́lege géjyá. Ape Pita, agií ji aké, “Simun, nnó ɛnyú dékágé bɛ́fɔ́ peé ne me, yɛɛ́ lé né nchwanekɛ ama? ");
INSERT INTO anvNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Bɛɛ́ge peé, dénɛ́némmyɛ mbaá Ɛsɔwɔ nnó ɛ́kágé ɛnyú dékpɛ́ né mmuameno. Matɔɔ́ nyú ákɛ́lege nnó ɛnyú dénɛ́némmyɛ yɛ́mbɔ menyammyɛ nyú áwyá gepwá.” ");
INSERT INTO anvNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Ama lya ɛbwɔ́ akéré meso manɛmmyɛ wyɛ gefɔ́ge mmyɛmenɛ́ne ɛyigé ji abɔ anɛ́ne. ");
INSERT INTO anvNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Ne amá akérégé ndɔ ɛyi ɛgbeé ɛpeá né mbaá baá utɔɔ́ bií álú, abané wyɛ ndɛre ɛbwɔ́ ábɛ́lege géjyá néndé géjyá gejá ɛbwɔ́ amɛ dɔɔ́, ne ákaá se meko ayi áshuúge ji wɔ́. ");
INSERT INTO anvNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Jisɔs ama ákérégé ndɔ ɛyi ɛgbeé ɛlɛɛ́, abané wyɛ́ ɛbwɔ́ ndɛre ábɛ́lege, anyá ɛbwɔ́ aké, “Délú bɛ́lege géjyá, degbeége mmyɛ? Gékwyá mbɔ, gɛ gébé gekwané ɛyigé áfyɛ nyɛ Maá Ntɛ Mekwaá né amú bɔɔ́ ubeé. ");
INSERT INTO anvNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Kwilége ka, déjyɛ, gɛ́ muú ayi akpóo me mbɔ, alé chwɔ́ mɛ́.” ");
INSERT INTO anvNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Ndɛre Jisɔs álú jɔɔ́gembɔ, Judas maá utɔɔ́ wuú ayi ama né geluágé abi áfyaneápeá achwɔ́ ne njuné bɔɔ́ ɛnine negbáre bɔ aparanja ne mámbó unɔɔ́. Bɔɔ́ bina ɛ́lé anɔɔ́ baá ámpyɛɛ́ upɛ Ɛsɔwɔ ne ánlɛré mabɛ́ Ɛsɔwɔ chóncho ne ákpakpa melɔ ne átɔmé ɛbwɔ́ nnó áchwɔ́ apyɛ Jisɔs. ");
INSERT INTO anvNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Ɛké ɛpyɛmbɔ, Judas abɔ́ mɛ́ mbɛ agaré ɛbwɔ́ aké, “Muú ayi me ntyaáge gɛ́ge ji mbɔ pyɛ́ge, défyɛɛ́ metɔɔ́ metɔɔ́ nyú, déjyɛ ne ji.” ");
INSERT INTO anvNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Judas ákwɔ́négé yɛ́ gébé achɔ sé wɔ́, akoó cho afɛ́ mbaá Jisɔs aké, “Ménlɛré ntamé,” akpá ji atyaá. ");
INSERT INTO anvNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Bɔɔ́ bina ágɛ́gé, áchwɔ́ ápyɛ ji agbaré ji ne amu matomato. ");
INSERT INTO anvNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Ápyɛ́gé Jisɔs, metɔɔ́ ɛsɔ́ maá utɔɔ́ wuú ama ajuú aparanja asɔ́ ɛtu memfwɛ́ ɛtukpɛ ámpyɛɛ́ upɛ Ɛsɔwɔ. ");
INSERT INTO anvNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Ɛfɛɛ́ ne Jisɔs agií ɛbwɔ́ aké, “Ɛnyú dechwɔ́ na ne bɔ aparanja ne mámbó unɔɔ́ mampyɛ me nnó me nlu menjó? ");
INSERT INTO anvNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Me nlú fa ne ɛnyú yɛ́ndé bií, nlɛrégé mekomejɔɔ́ Ɛsɔwɔ né ɛcha upɛ, nnó débɔ́ degɛɛ́ me mampyɛ wɔ́? Yɛ́mbɔ genó ɛyigé ásame mmu ŋwɛ Ɛsɔwɔ gebɔ́ mampyɛ́.” ");
INSERT INTO anvNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Baá utɔɔ́ bií ágɛ́gé mbɔ, áboó, ályaá ji. ");
INSERT INTO anvNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Nkane ájyɛ ne Jisɔs, njyɛ gesa fɔ afyale metyɛɛ́ ndeé né menyammyɛ akwɔlege ɛbwɔ́. Áké ágɛ́ne ji, ágbare ndeé yimbɔ nnó ápyɛ ji, ");
INSERT INTO anvNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","apalé ɛji, alyaá abó afɛ́ gejɔ́ŋéné. ");
INSERT INTO anvNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Ásɛ Jisɔs áfɛ ne ji mbaá ɛtúkpɛ ampyɛ upɛ Ɛsɔwɔ, ánɔɔ́ baá abi ápyɛ upɛ Ɛsɔwɔ, ánlɛré mabɛ́ Ɛsɔwɔ chóncho ne ákpakpa melɔ ájyɛ chome wyɛ. ");
INSERT INTO anvNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Pita ntó akwɔlege ɛbwɔ́ meso gachyɛ, gachyɛ kpaá tɛ akpɛne né mmu dachi ɛtúkpɛ ampyɛ upɛ Ɛsɔwɔ. Ɛfɛɛ́ ne ajyɛ bane ámbamé dachi ɛtukpɛ nnó awyagé mewɛ. ");
INSERT INTO anvNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Anɔɔ́ baá ampyɛ upɛ Ɛsɔwɔ ne bɔɔ́ ako abi ájwɔlé mmu ɛcha ɛso, ákɛlé ammá mpa gebyɔ́ mamma Jisɔs mmyɛ nnó áwá ji. Yɛ́mbɔ ágɛ́ yɛɛ́ ɛma wɔ́. ");
INSERT INTO anvNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Gejamégé bɔɔ́ ákwyɛ depɔ mámma Jisɔs mmyɛ yɛ́mbɔ ɛlé gebyɔ́ néndé ɛbwɔ́ ako ápɔ́ nya meko ama. ");
INSERT INTO anvNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Bɔɔ́ abifɔ ákwilé ka, ábyɔge ji gebyɔ́ mmyɛ áké, ");
INSERT INTO anvNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Ɛse déwú ndɛre ji ashuú mmyɛ nnó ji ammu nyɛ ɛcha upɛ Ɛsɔwɔ ɛwéna ɛwé akwaá átɛné ne ámu, ne ndɔ ɛlɛɛ́ ɛkwɔnégé átɛnege ɛwéchá ɛwé álá tɛné fɔ́ ne ámu wɔ́.” ");
INSERT INTO anvNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Yɛ́mbɔ ɛbwɔ́ ako apɔ́ meko ama. ");
INSERT INTO anvNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Ɛfɛɛ́ ne ɛtúkpɛ ampyɛ upɛ Ɛsɔwɔ ákwile ka né mbɛ ushuú bɔɔ́ ako ágií Jisɔs áké, “Wɔ ntó ɔpɔ́ ne meko manshuú né depɔ ɛtire bɔɔ́ ájɔɔ́ge mbɔ nnó ɔpyɛ?” ");
INSERT INTO anvNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Yɛ́mbɔ Jisɔs akwene bɔmbɔ yɛ́ meko ashuú ji wɔ́. Ɛtukpɛ ɛma ŋmɛ́re ɛgií ji ɛké, “Wɔ ne ɔ́lú Maá Ɛsɔwɔ, Muú yi Ɛsɔwɔ akweré ji ɛlá gefwa?” ");
INSERT INTO anvNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Jisɔs akamé aké, “Me ne nlú, dégɛne nyɛ ndɛre Maá Ntɛ Mekwaá ajwɔlé né geluɔge ɛnógé né ɛgbɛ́ ɛbwɔnyɛ Ɛsɔwɔ ne ndɛre achwɔ́ nyɛ né mfaánebuú mmu geko.” ");
INSERT INTO anvNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Ɛtúkpɛ ampyɛ upɛ Ɛsɔwɔ agyá mandeé jií né mmyɛ manlɛré nnó metɔɔ́ ɛsɔ́ ji dɔɔ́, agií ɛso aké, “Ndé gécha démage kɛ́le bɔ ntɛ́sɛ́? ");
INSERT INTO anvNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Pɔ déwú depɔ ɛtiré ji ajɔɔ́ge? Amɛge mmyɛ ne Ɛsɔwɔ, nana deké depyɛ nnó ne ji?” Bɔɔ́ ako akame áké, ɛkwane nnó, “Áwá ji wáne.” ");
INSERT INTO anvNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Ɛfɛɛ́ ne bɔɔ́ abifɔ álɔ mánkpo ji matyɛ mmyɛ, áwɛ́ ji ndeé amɛ, átúlege ji, ájɔ́ge aké, “Garé ɛsé muú ayi adoó wɔ?” Ámbamé ɛcha ɛso áchwɔ sɛ Jisɔs ádoó ji maka. ");
INSERT INTO anvNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Ndɛre Pita álu né dachi yimbɔ, maá mesɔ mendée fɔ ama né geluage abi ákpáne defwɛ́ mbaá ɛtúkpɛ ampyɛ upɛ Ɛsɔwɔ achwɔ ɛfɛɛ́, ");
INSERT INTO anvNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","agɛ́ ndɛre Pita ájwɔlé áwyáa mewɛ. Apɛ ji dómeé, ajɔɔ́ aké, “Wɔ ntó ɔlu gelua ne Jisɔs muú Nasarɛn yimbɔ.” ");
INSERT INTO anvNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Pita ashya aké, “Chaá-ó nkaá yɛ́ geno ɛyigé ɔ́jɔge mbɔ wɔ́.” Ndɛre Pita akwilé manjyɛ né meno gébámé, menɔmekwɔ mbɛ akú. ");
INSERT INTO anvNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Mesɔ mendée yimbɔ ámá ágɛgé Pita wyɛ alɔ mamma jɔɔ́ ne bɔɔ́ abi átɛné ɛfɛɛ́ aké, “Mende yina alu muú bwɔ́ ama.” ");
INSERT INTO anvNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Pita ama shya wyɛ shya ɛké ɛwyage, bɔɔ́ abi átɛné ɛfɛɛ́ álɔ mánjɔɔ́ ne Pita áké, “Wáwálé gebií gepɔ́ mmu, ɔkágé shya fɔ́ néndé ɔlu muú Galilií.” ");
INSERT INTO anvNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Yɛ́mbɔ Pita álɔ mánkalé aké, “Mbɔgé mbyɔgé le gebyɔ́ mfaánebuú áshulé me mmyɛ, nkágé fɔ́ mende ayi ɛnyú déjɔ́ge mbɔ.” ");
INSERT INTO anvNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Tɛ́nétɛ́né yimbɔ menɔ mekwɔ akú ukúkúle upeá kɔkɔgɔlɔ́kɔɔ́. Pita ate mekomejɔɔ́ ayi Jisɔs abɔ́ ájɔɔ́ ne ji nnó, “Gemɛ́gé nnó menɔ mekwɔ akú ukúkúle upeá ɔshya nyɛ máŋáne alɛɛ́ nnó ɔkaágé me.” Ateége mbɔ anyɔ meko ngbó ali segé segé. ");
INSERT INTO anvNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Wyɛ ndɛre bií ujyaá dondo, anɔɔ́ baá ampyɛ upɛ Ɛsɔwɔ, ákpakpa melɔ ne ánlɛré mabɛ́ Ɛsɔwɔ áchomé ne bɔɔ́ ɛso ako, ájwɔle ájɔɔ́ geju. Ɛfɛɛ́ ne ágbaré Jisɔs áwɛ́le, ásɛ ji, áfɛ́ mbaá gɔmena Palɛt. ");
INSERT INTO anvNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Ákwɔ́négé Palɛt agií Jisɔs aké, “Wɔ ɔlu Mfwa bɔɔ́ Jus wáwálé?” Jisɔs aké, “Ɛlu nkane ɔjɔɔ́.” ");
INSERT INTO anvNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Ájɔ́gémbɔ, anɔɔ́ baá ampyɛ upɛ Ɛsɔwɔ álɔ mammálé Jisɔs depɔ́ mmyɛ matimati. ");
INSERT INTO anvNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Palɛt ama gií Jisɔs aké, “Ɔpɔ́ ne meko manshuú? Ɔwuú fɔ depɔ́ ɛtíré ámmálé wɔ mmyɛ nnó ɔpyɛ?” ");
INSERT INTO anvNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Ne yɛɛ́ meko Jisɔs ashuú ji wɔ́, ɛwena ɛpyɛ Palɛt alaá meno mekpo fuú. ");
INSERT INTO anvNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Gepɔge Palɛt gelu nnó yɛ́ndé ŋmɛ gébégé ɛpaá koó upú bɔɔ́ Jus ábɔ́ mamferé muú ama né denɔ ndɛre bɔɔ́ ákɛ́lege. ");
INSERT INTO anvNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Né gébé ɛyígémbɔ muú denɔ fɔ alú ɛfɛɛ́, ákuú ji Barabas. Ji ne abifɔ ákpɛ denɔ gétúgé bɔɔ́ abi ɛbwɔ́ áwané né ɛfwyale ɛwé ɛbwɔ́ áchwɔɔ́ ne ɛ́wú né melɔ. ");
INSERT INTO anvNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Ndɛre ɛlúmbɔ, gejamégé bɔɔ́ ájyɛ báne Palɛt nnó áferé muú denɔ ama ndɛre ápyɛ mɛ́ yɛ́ndé ɛpaá ɛwémbɔ. ");
INSERT INTO anvNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Palɛt agií ɛbwɔ́ aké, “Ɛnyú dékɛlege nnó mferé Mfwa bɔɔ́ Jus?” ");
INSERT INTO anvNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Palɛt agií mbɔ ɛlé ji akaá cháŋéné nnó ɛlé wyɛ né nchyɛ detú ne anɔɔ́ baá ampyɛ upɛ Ɛsɔwɔ ápyɛné Jisɔs áchwɔ́ ne ji ɛta wuú. ");
INSERT INTO anvNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Yɛ́mbɔ anɔɔ́ baá ampyɛ upɛ Ɛsɔwɔ ágaré ɛkwɔ́ bɔɔ́ ɛwémbɔ nnó ágaré Palɛt aferé lé Barabas. ");
INSERT INTO anvNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Palɛt ama agií ɛbwɔ́ aké, “Ɛnyú dékɛlege me mpyɛ yɛɛ́ nnó ne mende yina ayi ákuú ji Mfwa bɔɔ́ Jus?” ");
INSERT INTO anvNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Ne ɛbwɔ́ ako ákalé kéŋké áké, “Wɔ́ ji né gekwa.” ");
INSERT INTO anvNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Palɛt ama gií ɛbwɔ́ aké, “Ndé gabo ayi ji ápyɛɛ́?” Yɛ́mbɔ ákpɛ kále kéŋké né ɛshyɛ áké, “Áwɔ́ ji né gekwa.” ");
INSERT INTO anvNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Nnó Palɛt apyɛ matɔɔ́ ágɔɔ́ bɔɔ́ Jus, aferé Barabas né denɔ. Agaré bɔɔ́ bee bií nnó átulé Jisɔs ne geto, áneregé, áwɔ́ ji né gekwa. ");
INSERT INTO anvNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Bɔɔ́ bee bimbɔ ánérégé mantulé Jisɔs, ája ji áfɛ́ mmu ɛcha gɔmena. Ákuú bɔɔ́ bee ako né geluá gebwɔ́. ");
INSERT INTO anvNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Áfyɛ́ ji nkúu megɛ́lé, átɔ ɛla meshií ɛke ɛla mfwa ákweré ji mekpo. ");
INSERT INTO anvNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Ápyɛgémbɔ, álɔ manjwyagé ji áké, “Mfwa bɔɔ́ Jus, neki nébɛ́ ne wɔ.” ");
INSERT INTO anvNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Ne álɔ mándógé ji unɔɔ́ né mekpo. Ákpó ji matyɛ́ mmyɛ, átó manó mme mampyɛ ɛké anóge ji. ");
INSERT INTO anvNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Ánérégé mánjwya ji, áferé nkúu megɛ́lé yimbɔ ákeré áfyɛ ji mandeé jií né menyammyɛ wuú. Ája ji átane né melɔ manjyɛ wɔ́ né gekwa. ");
INSERT INTO anvNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Ndɛre ájyɛɛ́ átuú ne mende fɔ ayi akamege Simun muú melɔ Sɛren nkane atané melɔ wuú ajyɛɛ́ né Jɛrosalɛ. Bɔɔ́ bee bimbɔ ágbaré ji kpékpé nnó akpá gekwagé Jisɔs. Simun alu ntɛ bɔ Aleksanda ne Rufɔs. ");
INSERT INTO anvNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Áfɛ́ né Jisɔs né mbaá ayi ákúu nnó Golgota. Ula utané nnó melú Uŋkɔ́ŋkɔ́ makpo. ");
INSERT INTO anvNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Áchyɛɛ́ ji mmɔɔ́ amí áchwaré ne uka ɛbí ákuú nnó myrrh Yɛ́mbɔ Jisɔs ashya manyú. ");
INSERT INTO anvNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Ála wyɛ ɛfɛɛ́ mbɔ, áwɔ́ ji né gekwa, áŋme gefɔ́gé megyaá fɔ nnó ákáré mandeé jií ɛyi yɛ́ndémuú asɛ́le. ");
INSERT INTO anvNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Áwɔ́ Jisɔs né gekwa né káláŋka ɛneneama né dondo. ");
INSERT INTO anvNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Ábɔ́ gebagé genɔɔ́ áwɔ mfaá mekpo gekwa ɛyigé áwɔmé Jisɔs wyɛɛ́, ásá genó ɛyigé áké ji apyɛ ne áwɔme ji. Áké, “Mfwa bɔɔ́ Jus.” ");
INSERT INTO anvNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Áwɔ́ ntó ánjo apea gébégé gema ne Jisɔs, ama alu né ɛgbɛ́ ɛbwɔnyɛ wuú ayifɔ né ɛgbɛ́ ɛbwɔbɛ wuú. Yɛ́ndémuú bwɔ́ álu né mfaá gekwa jií. ");
INSERT INTO anvNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Mechɔ ɛwéna ɛ́pyɛ nnó ɛ́bɛ́ wáwálé nkane mekomejɔɔ́ Ɛsɔwɔ ájɔɔ́ nnó áfyɛ ji mmu mpa bɔɔ́ ubeé. ");
INSERT INTO anvNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Ne bɔɔ́ abi ákoge koógé ájúu Jisɔs mashyɛ mmyɛ, ákamege ne makpo, ákálege áké, “Ɛ ɛ́, Pɔ́ wɔ ne ɔké ɔmmu nyɛ ɛcha upɛ Ɛsɔwɔ gemɛ́gé nnó ndɔ ɛlɛɛ́ ɛkwɔ́né wɔ ɔmage tɛ́ne ɛwéchá? ");
INSERT INTO anvNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Poó gemɛ jyɛ́ ɔtáné mfaá gekwa ɔshulé mme.” ");
INSERT INTO anvNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Wyɛ́mbɔ ntó ne anɔɔ́ baá ampyɛ upɛ Ɛsɔwɔ ne ánlɛré mabɛ́ Ɛsɔwɔ ntó ájwyáge ji áké, “Apoóge bɔɔ́ bí chachá, akaáge poó fɔ gemɛ jií. ");
INSERT INTO anvNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Áké ji alu Muú yi Ɛsɔwɔ akweré ji ɛlá gefwa, áma jɔɔ́ áke ji alu Mfwa bɔɔ́ Isrɛli, átáné mfaá gekwa áshuúlé mme. Apyɛgé mbɔ, ɛse défyɛɛ́ matɔɔ́ ne ji.” Ánjo bimbɔ abi áwɔ́mé ntó ɛbwɔ́ né ukwa, ájúu Jisɔs mashyɛ mmyɛ. ");
INSERT INTO anvNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Metɔɔ́ ŋwɔmese, káláŋká ɛfyáneɛ́peá ɛké ɛ́kwɔ́nege, ŋmɛɛ́ ɛnomé, gemmua gékwé né melɔ meko kpaá tɛ káláŋká ɛlɛɛ́. ");
INSERT INTO anvNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Káláŋka ɛlɛɛ́ ɛyimbɔ, Jisɔs alɔ mánkalé kéŋké aké, “Ɛloi, ɛloi lama saba tani, ula utɛné nnó Ɛsɔwɔ wa, Ɛsɔwɔ wa, ndé ɔlyaá me mbií né ɛfwyale?” ");
INSERT INTO anvNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Bɔɔ́ abifɔ abi átɛné ɛfɛɛ́ áwúgé ndɛre Jisɔs ajɔ́ge mbɔ áfɛré áké, “Akuú mbɔ lé Ɛlija muú ɛkpávé Ɛsɔwɔ.” ");
INSERT INTO anvNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Muú ama né geluage bɔɔ́ bimbɔ abó gatɛlé ajyɛ bɔ́ ɛkochá, áwɛ ne genɔɔ́ anyua né mmú mmɔɔ́ amí mamyáme, abwɛɛ́ até Jisɔs né ubɔɔ́ meno nnó ányú. Ajɔɔ́ aké, “Degɛ́ kpɛ́ nnó Ɛlija achwɔ feré nyɛ ji mfaá gekwa yi.” ");
INSERT INTO anvNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Ne Jisɔs ama akále kéŋké, ashulé kwyakwya geféré h-ɛ-m metɔɔ́ ɛkwé. ");
INSERT INTO anvNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Wyɛ́ ndɛre Jisɔs ágbó, ndeé ɛyi ɛkaré ɛcha upɛ Ɛsɔwɔ, ɛgyalé uba upeá tɛ mfaá gba-ra-ra-ra ɛtya mme. ");
INSERT INTO anvNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Muú kpaá bɔɔ́ bee ayi atɛne ɛfɛɛ́ agɛgé gefɔɔ́ ɛyige Jisɔs akalé ne ale gbó aké, “Wáwálé mende yina alu Maá Ɛsɔwɔ.” ");
INSERT INTO anvNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Gébé ɛyigémbɔ ntó, andée fɔ átɛné nya tɛtɛ ágɛ́né yɛ́ndégenó ɛyi gepyɛ́ ne Jisɔs. Né geluage andée bina Mɛri ayi atané melɔ Magdala, Salɔmɛ, ne Mɛri mma Jɛmsi ayi mamane kɔ ɛbwɔ́ ne Jose álu ntó wyɛ. ");
INSERT INTO anvNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Gébégé Jisɔs alu né Galilií andée bina ábɔ́ ákwɔ́lege ji, ama ápóge ji ntó, andée abifɔ abi átane Jɛrosalɛ ákwɔle Jisɔs álu ntó wyɛ. ");
INSERT INTO anvNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Jisɔs agbó bií bí bɔɔ́ Jus ako ákpomége mmyɛ nnó né nkwale álɔ mányɛ́ uwyaá bwɔ́. Ndɛre bií ule koó, ");
INSERT INTO anvNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","mende fɔ ayi ákuú ji Josɛf achwɔ́. Alu muú melɔ Arimatya, alu muú ayi anoge ji dɔɔ́ né ɛso bɔɔ́ Jus, ji abɔ agile ntó gébé ɛyigé Ɛsɔwɔ achwɔ gbáre nyɛ gefwa jií. Akpome mmyɛ nkane mende, ajyɛ báne Palɛt agií ji nnó achyɛ ji utó nnó ajyɛ áferé geŋkwɔ́gé Jisɔs né mfaá gekwa. ");
INSERT INTO anvNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Ágigé mbɔ, Palɛt alaá meno fuú mánwu nnó Jisɔs agbó mɛ. Akú muú kpaá bɔɔ́ bee agií ji wá Jisɔs agbóo mɛ́. ");
INSERT INTO anvNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Muú kpaa bɔɔ́ bee yimbɔ akamé nnó agbo, ɛfɛɛ́ ne Pálɛt akamé nnó Josɛf akáge jyɛ feré geŋkwɔ́gé Jisɔs né gekwa. ");
INSERT INTO anvNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Josɛf ajyɛ na ɛ́shyɛ́ ndeé pópó, aféré geŋkwɔ́gé Jisɔs né gekwa, afyalé géjí ne ɛshyɛ́ɛ ndeé ɛyimbɔ, akpa ajyɛ fyɛ mmu menome ɛwé áchomé mmu ɛtárávɛ́. Abogéné gekpɛ́kpɛ́gé ntaá agbɛ́ meno menome ɛwembɔ. ");
INSERT INTO anvNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Mɛri muú melɔ Magdala ne Mɛri ayi mmá Jose ágɛ́ mbaá ayi ábelé geŋkwɔ́gé Jisɔs. ");
INSERT INTO anvNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Bií uwyaá bwɔ́ ukógé, Mɛri muú melɔ Magdala, Salɔmɛ ne Mɛri mmá Jɛmsi ájyɛ na maweé gebɛɛ́ nnó ájyɛ gbɛre né geŋkwɔ́gé Jisɔs. ");
INSERT INTO anvNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Ne dondo bií mbɛ né uwyaá, ndɛre mbɛ ŋmɛ atane, ɛbwɔ́ ájyɛ né menome ɛwé anií Jisɔs. ");
INSERT INTO anvNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Ágíge atɛ áké, “Waá ábogéné nyɛ ɛsé gekpɛ́kpɛ́ ntaá ɛníné ágbɛ mbɔ menome”? ");
INSERT INTO anvNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Áké ákwɔnege wyɛ, ágɛ nnó ábogéné mɛ́ ntaá ɛnínémbɔ néla babá nelu gekpɛ́kpɛ́gé ntaá. ");
INSERT INTO anvNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Ndɛre ɛbwɔ́ ákpɛne mmu menome ɛwémbɔ, ágɛ njyɛ gesa fɔ ajwɔlé né ɛgbɛ́ ɛbwɔnyɛ bwɔ́, afyɛ ɛwule pópó. Ɛbwɔ́ ágɛ́gé mbɔ álá mano mekpo fuú. ");
INSERT INTO anvNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Njyɛ gesa yimbɔ ajɔɔ́ ne ɛbwɔ́ aké, “Défɔgé. Nkaá nnó dékɛlege mbɔ lé Jisɔs muú Nasarɛt ayi ábɔ́ áwɔmé nya ji né gekwa, apɔ́ sé fa, Ɛsɔwɔ apyɛ ji akwilé né negbo. Gɛ́ge melú ɛwé ábɔɔ́ ábelé ji. ");
INSERT INTO anvNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Kéregé meso dégaré Pita ne baá utɔɔ́ bií abifɔ nnó ji abɔ́ mɛ́ mbɛ ne ɛnyú afɛ́ né Galilií; dégɛné nyɛ ji ɛwú wyɛ ndɛre ji abɔ́ agaré ɛnyú.” ");
INSERT INTO anvNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Andée bimbɔ átáné né menome ne gatɛlé, áwére ne ɛfɔ metɔɔ́, ne yɛɛ́ muú fɔ ágaré ɛbwɔ́ geno ɛyíge pyɛ wɔ́ gétúgé ɛfɔ ɛwe ɛlú ɛbwɔ́ matɔɔ́. ");
INSERT INTO anvNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Dondo bií mbɛ uwyaá ɛbi Jisɔs akwilé né negbó, abɔ mbɛ alɛré mmyɛ mbaá Mɛri muú melɔ Magdala. Jisɔs abɔ́ aferé nya ji aló nchyɛ akénéama mmyɛ. ");
INSERT INTO anvNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Mɛri afɛ agáre ájeé bií abi ɛbwɔ́ ábɔ́ ákɛne nya ne Jisɔs ne ábane ɛbwɔ́ ndɛre álíle, ásómege. ");
INSERT INTO anvNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Yɛ́ lé ɛbwɔ́ áwuú nnó Jisɔs álú mebɛ Mɛri muú melɔ Magdala agɛ́ ji, ákamé fɔ́ nnó ɛlu wáwálé wɔ́. ");
INSERT INTO anvNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Ɛwyágé Jisɔs akwɔ́ mbɛ ushuú baá utɔɔ́ bií apea né gefɔɔ́ ɛyigé álá kaáge sé ji gébégé ɛbwɔ́ akɛne ájyɛ né meti. ");
INSERT INTO anvNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Ɛbwɔ́ ákaáge nnó muú yi ágɛne mbɔ ɛle Jisɔs, ákeré meso ájyɛ garé baá utɔɔ́ bifɔ yɛ́mbɔ yɛ muú bwɔ́ yi ákamé nnó ɛ́lú wáwálé ápɔ́. ");
INSERT INTO anvNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Ɛma ɛwyagé ndɛre baá utɔɔ́ bií ájwɔlé ányɛ́ɛ menyɛɛ́, akwɔ ɛbwɔ́ ushuú alɔ maweé ɛbwɔ́ gétúgé álá pɔ né ukáme ne matɔɔ́ ayi ɛbwɔ́ áŋea álá kamé mekomejɔɔ́ bɔɔ́ abi ágɛné nnó ji akwilé né negbo wɔ́. ");
INSERT INTO anvNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Ajɔɔ́ ne bwɔ́ aké, “Chóge né malɔ mme meko dégárégé bɔɔ́ abya Ɛsɔwɔ melɔ́mélɔ́. ");
INSERT INTO anvNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Muú ayi akamégé mekomejɔɔ́ yina ne áwyaáge ji manaá Ɛsɔwɔ, áférege nyɛ ji né ɛfwyale gabo. Ne muú ayi álá kamé mekomejɔɔ́ yina wɔ́, ákwéne nyɛ mpa Ɛsɔwɔ. ");
INSERT INTO anvNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Gɛ́ unó bi upyɛ nyɛ ne bɔɔ́ abi ákamé ne Ɛsɔwɔ na. Né mabɔ ma ábuú nyɛ aló nchyɛ, ájɔge nyɛ ufɔɔ́ mejɔɔ́ ɛbi álá kaáge fɔ. ");
INSERT INTO anvNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Ágbárége nyɛ mmyɔ ne ámu ne yɛ ányú le uka ubo yɛɛ́ geno ɛyi gepyɛ ɛbwɔ́ gepɔ́. Ánɛrégé bɔɔ́ mameé amu mmyɛ, átóge.” ");
INSERT INTO anvNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Ata Jisɔs anérégé mánjɔɔ́ depɔ tire na, Ɛsɔwɔ asɛ ji akwɔ́ afɛ né mfaánebuú. Ajwɔlé né geluɔge ɛnógé né ɛgbɛ́ ɛbwɔnyɛ ntɛ wuú Ɛsɔwɔ. ");
INSERT INTO anvNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Baá utɔɔ́ bií ntó álá mbɔ ákeré, ákɛné ágarége bɔɔ́ mekomejɔɔ́ Ɛsɔwɔ né malɔ mme mako. Atá Jisɔs ntó alu ne ɛbwɔ́ achyɛge ɛbwɔ́ utó ápyɛɛ́ ufélekpá mánlɛré nnó mekomejɔɔ́ bwɔ́ alu wáwálé.");
INSERT INTO anvNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Átá Tyɔ́filɔs, gejamégé bɔɔ́ ámua mɛ́ mansá abya unó bí úpyɛ́ né metɔɔ́ metɔɔ́ ɛsé. ");
INSERT INTO anvNT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Ɛbwɔ́ ásá wyɛ́ ndɛre ɛbwɔ́ ábɔ́ áwuú mbaá bɔɔ́ bí ákpané amɛ ɛbwɔ́ ágɛné ndɛre unó biná ulɔɔ́ mampyɛ ne ukwyá, ne ɛké ɛ́wyage álɔɔ́ mangare abya yi. ");
INSERT INTO anvNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Ndɛre me ntó mbɔ́ nkwɔlege unó bina uko cháŋéné tɛ gachií, mbɔ́ ngɛ́ nnó ɛ́lú galɔ́gálɔ́ nnó nsá wɔ unó bi ndɛre nsámé nkwyɛ ubi nkane úpyɛ́ géma géma. ");
INSERT INTO anvNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Mpyɛ́ na nnó wɔ ɔkaá nnó, unó bí ábɔ́ ágií wɔ́ úlú wáwálé. ");
INSERT INTO anvNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Gébégé Hɛrɔd abɔ́ alú mfwa né gebagé mewaá Judiya, Mempyɛ́ upɛ Ɛsɔwɔ fɔ abɔ́ alu wyɛ́, ákuú ji Sakariya. Ji ne ampyɛ́ upɛ abifɔ ápyɛ utɔɔ́ né geluágé Abija. Mendée wuú Ɛlisabɛt alu ntó mpyáne *Ɛrɔn. Ábi álú ntó ámpyɛ upɛ Ɛsɔwɔ. ");
INSERT INTO anvNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Ɛbwɔ́ apeá álú cho né mbɛ ushu Ɛsɔwɔ, áwuú mekomejɔɔ́ wuú áma ábélege mabɛ jií, ákwéné yɛ ɛma ");
INSERT INTO anvNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","ɛbwɔ́ ako ákwɔ ukoó ne ápɔ́ ne maá, gétúgé Ɛlisabɛt alú ménkwɔ́ɔ. ");
INSERT INTO anvNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Bií uma, ɛ́lé gebégé utɔɔ́ Sakariya ne ɛkwɔ wuú, Mampyɛ utɔɔ́ bií nkane mempyɛ upɛ Ɛsɔwɔ. ");
INSERT INTO anvNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Náná ɛlú lé gepɔge bwɔ́ ámpyɛ́ upɛ Ɛsɔwɔ manyú nkwu nnó, Ɛsɔwɔ ajyá genó ɛyígé yɛ́ndémuú abɔɔ́ mampyɛ. Ápyɛ́gé mbɔ ajya Sakariya, nnó ji ne akpɛ́ mmu ɛcha upɛ Ɛsɔwɔ mansɔ́ genó ɛyígé géwya gebɛ́ nkane ɛlu. ");
INSERT INTO anvNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Gébé gékwɔ́négé ɛyígé Sakariya ajyɛ́ sɔ́ geno gebɛ́ ɛyígémbɔ, gejamégé bɔɔ́ gélú dafyɛ génɛ́nemmyɛ. ");
INSERT INTO anvNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Wyɛ́ gébé ɛyigembɔ, aké apɛle ɛkiɛ́nné Ɛsɔwɔ ɛkwɔ́ ji ushu, ɛ́tɛné ɛ́gbɛ́ ɛbwɔnyɛ wuú kwɔ́kwɔ́lé ne geluɔ́ ɛyígé asɔ́ uno ubɛ́ bimbɔ. ");
INSERT INTO anvNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Agɛ́gé mbɔ ɛfɔ́ ɛ́kwɔ́ ji metɔɔ́, ala amɛ mekpo faŋ. ");
INSERT INTO anvNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Yɛ́mbɔ ɛkiɛ́nné Ɛsɔwɔ ɛ́ké ne ji, “Sakariya ɔ́fɔgé, néndé Ɛsɔwɔ awú mmyɛmenɛne jyɛ́ ne mendée wyɛ́ Ɛlisabɛt akpane nyɛ́ unɛ ne abyɛne nyɛ́ maá mende ne ɔbɔ́ mankuú ji nnó Jɔn. ");
INSERT INTO anvNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Ɔbɛ nyɛ ne metɔɔ́ megɔmegɔ, ne gejamégé bɔɔ́ ábɛɛ́ nyɛ́ ne nechɔ́chɔ́ gétúgé nebyɛ́ níi. ");
INSERT INTO anvNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Ji maá yina abɛ nyɛ́ gekpɛ́kpɛ́gé muú né mbɛ ushu Ata Ɛsɔwɔ, ne ji anyú fɔ́ mmɔɔ́, yɛ amí bɔgebɔge, yɛ ami matomato, ne ɛ́lɔ tɛ bií ɛbi ábyɛné ji Mendoó Ukpea ɛgbége nyɛ ji metɔɔ́, ");
INSERT INTO anvNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","ne ji abwɔlége nyɛ́ matɔɔ́ bɔɔ́ Isrɛli nnó ákwɔ́lé Ata Ɛsɔwɔ bwɔ́. ");
INSERT INTO anvNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Maá yimbɔ abɔ nyɛ́ mbɛ ne Ata Ɛsɔwɔ ndɛre muú dentɔɔ́. Ɛsɔwɔ achyɛ́ge nyɛ ji uto mendoó wyɛ́ nkane abɔ achyɛ́ Ɛlija, nnó apyɛ́ ántɛ ábɔ́ gejeé ne baá bwɔ́ ne apyɛ nyɛ́ abi átoó makpo ásɛ́ gepɔ ɛyígé abi átɛné cho. Apyɛ nyɛ́ unó bí uko nnó bɔɔ́ ákpómé mmyɛ mangílí Ata Ɛsɔwɔ.” ");
INSERT INTO anvNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Sakariya agií ɛkiɛ́nné Ɛsɔwɔ aké, “Mpyɛ nnó ne nkaá nnó mechɔ́ ɛwéná ɛbɛ́ɛ nyɛ wáwálé néndé ɛsé ne mendée wa dékwɔ mɛ́ ukoó?” ");
INSERT INTO anvNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Ɛkiɛ́nné ɛwémbɔ ɛ́ké, “Me Gabriya, ne ntɛné fáná gétúgé Ɛsɔwɔ atɔmé me nnó nchwɔ́ ngáré wɔ abya melɔ́mélɔ́ yina. ");
INSERT INTO anvNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Gɛ́ ɔ́bɛ nyɛ́ mbú, ɔjɔ́gése mejɔɔ́ kpaá tɛ depɔ ɛtí dépyɛ nyɛ́ gétúgé ɔlá ɔkamé uchwú mejɔɔ́ bá ɛbi ubɛ nyɛ́ wáwálé né meso gébé wɔ́.” ");
INSERT INTO anvNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Ndɛre Sakariya alú wyáge mmu, bɔɔ́ bí ábɔ́ álú dafyɛ ánɛ́nemmyɛ akwé tametame, álɔ memfɛré genó ɛyi gepyɛ ji mmu ɛcha upɛ Ɛsɔwɔ. ");
INSERT INTO anvNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Gébégé ji atané dafyɛ, amua manjɔɔ́ mejɔɔ́ meti ɛ́pɔ́. Ala mɛ́ɛ lé ne amu ɛlé alaá mbú, ɛbwɔ́ ágɛ́gé mbɔ ákaá nnó agɛ́ lé amɛ́ géjyá né mmu ɛcha upɛ Ɛsɔwɔ. ");
INSERT INTO anvNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Gébégé néŋáne utɔɔ́ bií né byɛ́gé, akere melɔ wuú. ");
INSERT INTO anvNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Ɛ́ké ɛ́bɛlege, mendée wuú Ɛlisabɛt akpa unɛ, ala mmu bibií né amfaá áta. ");
INSERT INTO anvNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Ne aké, “Nána nkaá nnó Ɛsɔwɔ agɛ́ me meshwɛ, aferé me neshyɛ mmyɛ nnó bɔɔ́ ájwyágé sé me déŋkwɔ.” ");
INSERT INTO anvNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Gébégé Ɛlisabɛt alú ne unɛ amfaá akéné, Ɛsɔwɔ atɔ́ Gabriya ɛkiɛ́nné wuú né melɔ́ Nasarɛt ɛwé ɛlú né gebagé mewaá Galilií. ");
INSERT INTO anvNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Atɔ́ ɛwú nnó ɛjyɛ́ ɛtá gébwɛ́ne mesɔ́ mendée ayi ákúu ji Mɛri, ayi ɛbwɔ́ ne Josɛf ányɛ́meno mambá atɛ. Josɛf alu mpyáne mfwa *Dɛvid. ");
INSERT INTO anvNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Ɛkiɛ́nné Ɛsɔwɔ ɛ́fɛ́ ɛta Mɛri ɛ́ké, “Mmá ɔjwɔle, Ɛsɔwɔ alu ne wɔ amá agbo ne wɔ dɔɔ́.” ");
INSERT INTO anvNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Mɛri awúgé mbɔ́ akwé tametame, afɛrege, agige né metɔɔ́ wuú nnó ndé gefɔgé matame na? ");
INSERT INTO anvNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Ɛkiɛ́nné ɛwémbɔ ɛ́ké ne ji, “Mɛri Ɔ́fɔgé, Ɛsɔwɔ agboó ne wɔ ne achyɛ́ wɔ nebɔ. ");
INSERT INTO anvNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Gɛ́, ɔkpane nyɛ́ unɛ, ɔbyɛ́ maá mende ne ɔkuú nyɛ́ ji nnó Jisɔs. ");
INSERT INTO anvNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Abɛ nyɛ́ gekpɛ́kpɛ́ge muú ne ákuú nyɛ ji Maá Anyátá Ɛsɔwɔ. Ata Ɛsɔwɔ apyɛ nyɛ́ ji ajwɔlé né geluɔ́gé Mfwa Dɛvid, gekwénegé ntɛ wuú. ");
INSERT INTO anvNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Agbarege nyɛ́ gefwa mbaá upyáne Jakɔb uko tɛ kwyakwyá. Ne gefwa jií gébyɛ́ fɔ.” ");
INSERT INTO anvNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Mɛri awúgé mbɔ, agií ɛwú aké, “Ɛ́kɛ́ne mbɔ nnó ne nkpá unɛ nkane nlá nlú dankáa mende?” ");
INSERT INTO anvNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Ɛkiɛ́nné Ɛsɔwɔ ɛshuú ji meko ɛ́ké, “Mendoó Ukpea ɛchwɔ nyɛ́ wɔ mmyɛ ne uto bí Anyátá Ɛsɔwɔ upyɛ nyɛ́ wɔ ɔkpá unɛ. Né gétú yina maá yi ɔbyɛ́ne nyɛ́ abɛ ne ukpeá ákúu nyɛ́ ji Maá Ɛsɔwɔ. ");
INSERT INTO anvNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Gɛ́, meŋmó wyɛ́ Ɛlisabɛt yɛ ɛlé akwɔ ukoó ne bɔɔ́ abɔ ákúu ji meŋkwɔ́ mendée, nana akwɔré gefɔɔ́ alɛ́ amfaá akéné ne abyɛne nyɛ́ maá mende. ");
INSERT INTO anvNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Ne kaá nnó genó gefɔ́ ɛyí gépwɔ́ Ɛsɔwɔ gepɔ́.” ");
INSERT INTO anvNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Ɛkiɛ́nné Ɛsɔwɔ ɛjɔ́gé mbɔ, Mɛri aké ne ɛwú, “Nlu lé maá utɔɔ́ Ɛsɔwɔ, ɛ́bɛ́ wyɛ́ nkane ɔjɔɔ́.” Mɛri ajɔ́gé mbɔ, ɛkiɛ́nné ɛwémbɔ ɛ́seé. ");
INSERT INTO anvNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Depɔ ɛti dépyɛ́gé, Mɛri akpomé mmyɛ akwilé wá akwɔ́ afɛ́ né melɔ fɔ́ ɛwé, ɛlú né gebagé mewaá Judiya. ");
INSERT INTO anvNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Akwɔ́négé, akpɛ mmu gepúgé Sakariya, atamé mendée wuú Ɛlisabɛt. ");
INSERT INTO anvNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Gébégé Ɛlisabɛt awuú matame Mɛri, maá yi alú ji unɛ akwilé melu ujwɔ́lé ne ɛshyɛ, ne Mendoó Ukpea ɛchwɔ́ gbée Ɛlisabɛt metɔɔ́. ");
INSERT INTO anvNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Ji ado ɛlúlú ajɔɔ́ ne mɛri aké, “Wɔ ɔwya ɛ́fwɔ́ ɔpwɔ andée ako, ne mejé Ɛsɔwɔ ɛ́bɛ́ ne maá yi wɔ ɔbyɛ́ne nyɛ. ");
INSERT INTO anvNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Nlu kpɛ́ waá ayi Ɛsɔwɔ anógé me ne mmá Ata wa achwɔ gɛ́ me uŋkɛɛ́? ");
INSERT INTO anvNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Wyɛ ɔké ɔtamege me mbɔ, nechɔ́chɔ́ népyɛ maá akwilé né melú ujwɔlé. ");
INSERT INTO anvNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Méjé Ɛsɔwɔ ɛ́bɛ́ ne ji yi akamé nnó mechɔ́ ɛwé Ata ajɔɔ́ mbɔ, ɛbɛ nyɛ́ wáwálé.” ");
INSERT INTO anvNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Mɛri aké: “Metɔɔ́ wa ɛgɔ́ɔ me ne Ata. ");
INSERT INTO anvNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Ne metɔɔ́ wa ɛlú ne nechɔ́chɔ́ gétúgé Ɛsɔwɔ Mempoó wa. ");
INSERT INTO anvNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Ji ate me yɛ ɛlé nlú lé meŋkpané defwɛ́ wuú. Lɔ nána ɔjyɛ́gé mbɛ, bɔɔ́ ako akúu nyɛ́ me nnó muú yi abɔɔ́ nebɔ, ");
INSERT INTO anvNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","nendé Ɛsɔwɔ yi awya uto uko, apyɛ me gekpɛ́kpɛ́gé mechɔ́. Ɛ́nógé ɛ́bɛ́ ne ji kpaá tɛ kwyakwyá, ");
INSERT INTO anvNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","agɛ́ne meshwɛ mbaá bɔɔ́ bi anóge ji, ɛlɔ́ né antɛ bwɔ́ ɛkwɔ́né né upyáne. ");
INSERT INTO anvNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Alɛré ɛshyɛ ne ɛbwɔ wuú mantyá bɔɔ́ nepá ne ufɔɔ́ unó bí ɛbwɔ́ áfɛ́rege. ");
INSERT INTO anvNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Aferé afwa né malú ujwɔ́lé bwɔ́, ne afyɛ́ ubyá bɔɔ́ né malu bwɔ́. ");
INSERT INTO anvNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Achyɛ́ menyɛɛ́ mbaá bɔɔ́ bí alú mesa, ne abú afwa áfɛ́ amu máwa. ");
INSERT INTO anvNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Ate menomenyɛ ɛwé ji abɔ́ anyɛɛ́ ne ukwéne antɛ sé, ne náná achwɔ́ mampoó baá Isrɛli, bɔɔ́ utɔɔ́ bií. Apyɛ wyɛ ndɛre ji abɔ́ anyɛ́meno nnó agɛne Abraham meshwɛ, ne upyáne bií tɛ kwyakwya!” ");
INSERT INTO anvNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Mɛri ajɔ́gé mbɔ, abɛlé ne Ɛlisabɛt genógé amfaá alɛɛ́, ne ákeré meso melɔ wuú. ");
INSERT INTO anvNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Gébé gékwɔ́négé ɛyígé Ɛlisabɛt ábyɛ́ne, abyɛ maá mende. ");
INSERT INTO anvNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Atɛ áŋmɛ́ ne bɔɔ́ ulagepú bií, aké áwúu nnó Ata Ɛsɔwɔ agɛ́ ji meshwɛ achyɛ́ ji nebɔ, matɔɔ́ ágɔ bwɔ́ ako. ");
INSERT INTO anvNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Ne ndɔ́ ɛ́nee ɛ́kwɔ́négé áchwɔ́ mansɔ́ ji nsɔ́ ne ábɔ́ álú mamfyɛ ji mabɔ ntɛ wuú Sakariya. ");
INSERT INTO anvNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Mma wuú aké ŋgba, “Ákúu ji Jɔn.” ");
INSERT INTO anvNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Yɛ́mbɔ áké ne ji, “Yɛ́ muú ula gepú wyɛ́ fɔ ayi awya mabɔ mímbɔ apɔ́.” ");
INSERT INTO anvNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Ne ámɛɛ́ ne amu ágií ntɛ wuú áké, ndé mabɔ mí ji akɛ́lege nnó áfyɛ́ maá yimbɔ. ");
INSERT INTO anvNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Amɛɛ́ ne amu nnó áchyɛ́ ji genó gefɔ́ ásá wyɛ́. Áchwɔ́ ne géjí asá, “Mabɔ maá yimbɔ nnó Jɔn.” Bɔɔ́ ágɛ́gé mbɔ ála mano mekpo, fuú. ");
INSERT INTO anvNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Sakariya áságé mbɔ, tɛ́nétɛ́né ama lɔ manjɔɔ́ mejɔɔ́ ne alɔ mamfɛɛ́ Ɛsɔwɔ. ");
INSERT INTO anvNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Gébégé bɔɔ́ melɔ wuú, áwuú nnó Sakariya ama lɔ́ manjɔɔ́ mejɔɔ́, mechɔ ɛwéna ɛpwɔ bwɔ́ amu. Gegáré mechɔ́ ɛwé, gékwɔ́ gékwɔné malɔ́ mekwɛ́ mako né gebagé mewaá Judiya. ");
INSERT INTO anvNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Bɔɔ́ ako abi áwuú mechɔ́ ɛwé, áfyɛ né matɔɔ́ bwɔ́ áfɛrege nnó, “Maá yi abɛɛ́ nyɛ́ ndé gefɔɔ́?” Áfɛ́rege mbɔ ɛlé ágɛné nnó Ɛsɔwɔ alu ne ji. ");
INSERT INTO anvNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Né gébé ɛyígémbɔ Mendoó Ukpea ɛchwɔ gbée Sakariya mmu metɔɔ́ awú meko mejɔɔ́ Ɛsɔwɔ ne alɔ mangaré aké: ");
INSERT INTO anvNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Gɔ́ ɛbwɔ́ áfɛɛ́ Ata Ɛsɔwɔ, ntɛ bɔɔ́ Isrɛli! Gétúgé achwɔ́ mamferé bɔɔ́ bií né defwɛ́. ");
INSERT INTO anvNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Achyɛ́ ɛsé gekpɛ́kpɛ́gé ménchyɛ́ geŋwá ayi átané ula gepú Mfwa Dɛvid maá utɔɔ́ wuú, ");
INSERT INTO anvNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","wyɛ́ ndɛre abɔ́ ányɛ́meno mbaá bɔɔ́ ɛkpávɛ Ɛsɔwɔ abi gekwéne nnó, ");
INSERT INTO anvNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","ji apoóge nyɛ ɛsé, mbaá bɔɔ́ bi ákɛlege manwá ɛsé, ne aferege nyɛ ɛsé né amú bɔɔ́ mawámé ɛsé. ");
INSERT INTO anvNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Abɔ́ anyɛ́meno mangɛ́ meshwɛ mbaá ukwéne antɛ sé, ne ate menomenyɛ ukpea ɛwé jimbɔɔ́ abɔ́ anyɛɛ́ ne ɛbwɔ́. ");
INSERT INTO anvNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Abɔ́ agaré gekwéne ntɛ sé Abraham ne akelé nnó, ");
INSERT INTO anvNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","aferege nyɛ ɛsé né amú bɔɔ́ mawámé ɛsé, nnó dépyɛ́ utɔɔ́ bií débɛgé ne ɛfɔ, ");
INSERT INTO anvNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","mambɛ́ bɔɔ́ ukpea bií wáwálé ne mantɛné cho né mbɛ ushu wuú, ndɔ meko kpaá tɛ dégboó. ");
INSERT INTO anvNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Wɔ, maá wa, ákúu nyɛ́ wɔ *Muú Ɛkpávé Anyátá Ɛsɔwɔ. Ɔbɔ nyɛ́ mbɛ ne Ata Ɛsɔwɔ nnó, ɔkwyɛ́ mati jií. ");
INSERT INTO anvNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Ɔpyɛ nyɛ́ bɔɔ́ Ɛsɔwɔ ákaá nnó, Ɛsɔwɔ akɛlege manjiínte gabo bwɔ́ ne áféré ɛbwɔ́ né ɛfwyale gabo. ");
INSERT INTO anvNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Gétúgé ji ágɛ́ne meshwɛ dɔɔ́ mbaá bɔɔ́ yɛ́ndégébé, ji atɔme nyɛ́ muú yi achyɛge ɛsé geŋwá, achwɔ́ ayi atánege né mfaánebuú ayi mfaá mfaá nkane mŋmɛɛ́ ɛwé ɛ́tyɛ dondo, ");
INSERT INTO anvNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","ɛwú ɛ́chyɛ́ge nyɛ́ geŋgbɔ́ mbaá bɔɔ́ bí álú né gemua, ne ɛ́chyɛ́ge nyɛ́ geŋwá mbaá bɔɔ́ abi álú né manó negbo, ne manlɛré ɛsé meti ɛwé ɛ́chwɔ ne geŋwágé nesɔ.” ");
INSERT INTO anvNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Ne maá Sakariya yimbɔ alu ne ɛkwɔ wuú, awɛne ne menyammyɛ ne deŋgá, ne Mendoó Ɛsɔwɔ ɛlú ne ji. Awɛ́gé, ajyɛ jwɔ́le né *mashwɔne, ne gébé gekwɔ́nége, álɛre mmyɛ jií gbɔ́gɔ́nɔ́ mbaá bɔɔ́ *Isrɛli. ");
INSERT INTO anvNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Né gébé ɛyigémbɔ, Ɔgɔstɔs abɔ́ alu *Mfwa kpaa né malɔ yi álú ntente *Rom. Afyɛ́ ɛbɛ́ nnó ápá bɔɔ́ ako abi álú né malɔ ayi ábɔ́ álú nte gefwa jií. Gɛ́ ndɔ mbɛ ayi alɔ mampáné bɔɔ́ na, ");
INSERT INTO anvNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","né gébé ɛyigembɔ Kwirinɔs alu gɔmena né gebagé mewaá Siriya. ");
INSERT INTO anvNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Ndɛre ɛlúmbɔ, yɛ́ndémuú afɛ́ né gebagé melɔ wuú mansá mabɔ mií mmu bɔ ŋwɛ abi ápáne bɔɔ́. ");
INSERT INTO anvNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","5","Josɛf atané melɔ́ Nasarɛt né gebagé mewaá Galilií, asɛ Mɛri ayi ɛbwɔ́ ányɛ́meno mambá atɛ, áfɛ́ né Bɛtɛlɛhɛm mmu Judiya mbaá ayi abɔ́ ábyɛné Dɛvid mfwa nyá *Isrɛli, mánsá mabɔ bwɔ́. Josɛf afɛ́ ɛ́wu gétúgé alú mpyáné Dɛvid. Gébé yimbɔ ntó Meri alu ne unɛ. ");
INSERT INTO anvNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Ndɛre ɛbwɔ́ álú ɛwú, gébé gekwáné ɛyígé Mɛri abyɛ́né maá yimbɔ. ");
INSERT INTO anvNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Ne abyɛ maá mbɛ wuú mende. Afyalé ji ne ubaá mandeé, abelé ji mmu gekú mbaá utú unyɛɛ́ menyɛɛ́, néndé melu ɛpɔ́ nyá ɛwé ɛbwɔ́ achwɔgé ábélege mmu. ");
INSERT INTO anvNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Ɛké ɛpyɛmbɔ, ande fɔ́ álú né mewaá kwɔ́kwɔ́lé ne Bɛtɛlɛhɛm, ábáme magɔ́ŋme bwɔ́ ne utuú. ");
INSERT INTO anvNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Ne áké ápɛ́le *Ɛkiɛ́nné Ɛsɔwɔ ɛkwɔ́ ɛbwɔ́ mbɛ ushu ne geŋgbɔ́gé Ata gégɛné gegyá ɛbwɔ́ mme. Ɛfɔ ɛkwɔ́ ɛbwɔ́ metɔɔ́ dɔɔ́. ");
INSERT INTO anvNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Yɛ́mbɔ Ɛkiɛ́nné Ɛsɔwɔ ɛke, “Défɔgé, nchwɔ́ ɛnyú ne genchánchágé abya ayi álú ne gejamégé nechɔ́chɔ́ mbaá bɔɔ́ ako. ");
INSERT INTO anvNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Fina né melɔ Mfwa Dɛvid, ábyɛ́ Mempoó nyú, alu Ata, Muú yi Ɛsɔwɔ akweré ji ɛlá gefwa. ");
INSERT INTO anvNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Ne gepɔ ɛyi gelɛ́rege nyɛ́ ɛnyú nnó gɛ́ maá yimbɔ na, gélú nnó degɛne nyɛ maá yi áfyálé ji ne ubaá mandeé, ábelé ji mmu gekú, melu ɛwé utú unyɛɛ́ menyɛɛ́.” ");
INSERT INTO anvNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Wyɛ́ mbélépó mbɔ, áké ápɛ́lé, ɛkwɔ́ makiɛ́nné Ɛsɔwɔ ɛtané mfaánebuú ɛchwɔ cho ne ɛwé ɛbɔɔ́ mbɛ, álɔ mánkwáné, áfɛ́ɛge Ɛsɔwɔ ake: ");
INSERT INTO anvNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Ngɔ́ ábɛ́ ne Ata Ɛsɔwɔ ayí álú né mfaánebuú ayi mfaá mfaá, achyɛ́ nesɔ ne bɔɔ́ mme néndé agboó ne ɛbwɔ́.” ");
INSERT INTO anvNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Makiɛ́nné yimbɔ ályágé ɛbwɔ́, ákéré meso né mfaanebuú. Ne ámbamé magɔ́nŋme áke ne atɛ, “Déjyɛ́ dégɛ́ geno ɛyi gépyɛ́ né Bɛtɛlɛhɛm ɛyígé Ata Ɛsɔwɔ agaré ɛsé.” ");
INSERT INTO anvNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Mbɔntó ne ɛbwɔ́ ákwilé wáwá ákwɔ́négé, ágɛ́ Josɛf ne Mɛri chóncho ne maá yimbɔ ndɛre ábelé ji mmu gekú. ");
INSERT INTO anvNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Ndɛre ágɛné ɛbwɔ́, álɔ mangaré unó uko ɛbí ɛkiɛ́nné Ɛsɔwɔ ɛjɔɔ́, gétúgé maá yina. ");
INSERT INTO anvNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Bɔɔ́ ako bí áwuú mechɔ́ ɛwé ámbamé magɔ́ŋme ájɔɔ́, ála mano mekpo fuú. ");
INSERT INTO anvNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Yɛ́mbɔ Mɛri awuúgé depɔ ɛti deko, afyɛ mmu metɔɔ́ wuú afɛ́régé yɛ́ndégébé. ");
INSERT INTO anvNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Bɔɔ́ bi ábáme mágɔ́nŋme, ákérégé meso, áchyɛge ngɔ́ ne áfɛ́ɛge Ɛsɔwɔ mbaá depɔ tiré bwɔ́ áwuú ne ágɛné. Unó bi upyɛ janja ndɛre ɛkiɛ́nné Ɛsɔwɔ ɛgaré bwɔ́. ");
INSERT INTO anvNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Uwyá ukoó, ne gébé ɛyígé ɛbwɔ́ ásɔ maá *nsɔ́ gékwané, ne ɛbwɔ́ áfyɛ́ ji mabɔ nnó Jisɔs, mabɔ mí Ɛkiɛ́nné Ɛsɔwɔ ɛbɔ́ ɛfyɛ́ ji ne mma wuú alé kpá unɛ bií. ");
INSERT INTO anvNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Ne gébégé gepúgé buú getyaágé, gébé gékwané ɛyígé Josɛf ne *Mɛri ájyɛ pyɛ́ *Gepɛ ndɛre ásámé né mabɛ Mosis, ne ákpa maá bwɔ́ manjyɛ mfaá Jɛrosalɛ nnó álɛré ji mbaá Ɛsɔwɔ. ");
INSERT INTO anvNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Ndɛre ásamé né ŋwɛ Ɛsɔwɔ nnó, “Yɛnde mambɛ maá ayi alú mende, ábɔ́ manchyɛ́ ji mbaá Ɛsɔwɔ.” ");
INSERT INTO anvNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Ne áfɛ́ ntó áchyɛɛ́ *gepɛ ɛyigémbɔ ɛyigé gelú, “upwene mewaá upea, mbɔgé upɔ́ áchyɛge baá upwene melɔ ápeá nnó ápyɛ́ gepɛ wyɛ́ ndɛre asamé né ŋwɛ Ɛsɔwɔ.” ");
INSERT INTO anvNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Né gébé ɛyigémbɔ, mende fɔ alu nyá né Jɛrosalɛ ákúu ji nnó Simyɔn; alu cho né ɛ́gbɛ́ Ɛsɔwɔ ne anoge ji, ne ji ntó abɔ agile Ɛsɔwɔ nnó áféré bɔɔ́ Isrɛli né mbaá ɛfwyale. *Mendoó Ukpea ɛlú nyá ne ji. ");
INSERT INTO anvNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Mendoó Ukpea ɛbɔ́ ɛpyɛ Simyɔn akaá nnó aságé gbó ayi álá gɛ́ fɔ́ *Muú yi Ɛsɔwɔ akweré ji ɛlá gefwa, ayi Ɛsɔwɔ abɔ́ anyɛ́meno nnó atɔme. ");
INSERT INTO anvNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Bií bi Mɛri ne Josɛf ábɔ́ áchwɔ né Jɛrosalɛ, manlɛré Jisɔs mbaá Ɛsɔwɔ ndɛre ɛbɛ́ Mosis ɛgaré, Mendoó Ukpea ɛpyɛ́ Simyɔn afɛ́ né ɛcha upɛ Ɛsɔwɔ. Ndɛre akpɛné agɛ́ maá yimbɔ, ");
INSERT INTO anvNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","asɛ ji né amu jií, alɔ manchyɛ́gé matame ne mamfɛ́gé Ɛsɔwɔ ake: ");
INSERT INTO anvNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Ata menomenyɛɛ́ wyɛ́ ɛlú nana wáwálé, mbɔgé ɛjií wɔ ɔkaáge lya maá utɔɔ́ wyɛ́ agbó pere, ");
INSERT INTO anvNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","néndé nkpá amɛ ya ngɛ́ Menchyɛ Geŋwá ayi ɔbɔ́ ɔnyɛ́meno. ");
INSERT INTO anvNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Ne wɔ ɔtɔ ji nnó bɔɔ́ ako ágɛ́ ji. ");
INSERT INTO anvNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Abɛ nyɛ mewɛ́ mbaá bɔɔ́ abi álá pɔ́ bɔɔ́ Jus, nnó ɛbwɔ́ ákaá wɔ ntó. Apyɛ nyɛ melɔ́ Isrɛli ɛ́kwɔ́ ŋgɔ.” ");
INSERT INTO anvNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Mma ne ntɛ áwuúgé mechɔ ɛwe Simyɔn ajɔɔ́ gétúgé maá bwɔ́, ála meno mekpo fuú. ");
INSERT INTO anvNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simyɔn anérége manjɔɔ́ depɔ ɛtire na, achyɛɛ́ ɛbwɔ́ mejé Ɛsɔwɔ. Ɛké ɛwyágé ama kuú Mɛri mmá Jisɔs aké, “Wuúgé! Ɛsɔwɔ ajyá maá yiná nnó apyɛ́ gejamé bɔɔ́ Isrɛli ákwé ne mambwɛɛ́ abifɔ mfaá. Abɛ nyɛ ntó ndɛre gepɔ ɛyígé Ɛsɔwɔ jimbɔɔ́, ne gejamégé bɔɔ́ áshyá nyɛ ji. ");
INSERT INTO anvNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Apyɛgé mbɔ, ɛlɛrege gbɔ́gɔ́nɔ́ depɔ ɛtiré ɛbwɔ́ ábií mmu matɔɔ́ bwɔ́. Ne mesómé maá wyɛ́ yina ɛbɛ́ɛ nyɛ wɔ metɔɔ́ ɛké aparaja ne ájómé wɔ.” ");
INSERT INTO anvNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Gébé ɛyigémbɔ ntó, mekoó mendée fɔ, alu né Jerósálɛ akamege Ana. Alu muú ɛkpave Ɛsɔwɔ ayi mendée. Ɛsɔwɔ agárege ji depɔ mangárégé bɔɔ́ bií. Alu maá Fanuɛl ayi alú mpyáne Ɛkwɔ́ Ashyɛ. Abá menɔ abɛlé aŋmɛ́ akénéama ne menɔ́ wuú ágbó. ");
INSERT INTO anvNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Tɛ́ gébé ɛyigémbɔ ala mekwí mendée. Yɛ́ndégébé alu mmu ɛcha upɛ Ɛsɔwɔ, afɛge Ɛsɔwɔ ne anɛnemmyɛ, utuú ne ŋwɔmésé, alyage menyɛɛ́ kpékpé. Né gébé ɛyigémbɔ, alu usaá aŋmɛ uni meso ɛníi. ");
INSERT INTO anvNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Ama chwɔ́ né ɛcha upɛ Ɛsɔwɔ, wyɛ́ gébé yimbɔ ntó ne Mɛri ne Josɛf achwɔ́ ne maá bwɔ́. Ana agɛ́gé maá yina, alɔ mánfɛɛ́gé Ɛsɔwɔ, agarege depɔ ɛtíré maá yi mbaá bɔɔ́ ako abi ágili nnó Ɛsɔwɔ áféré bɔɔ́ Jɛrosalɛ né ɛfwyale. ");
INSERT INTO anvNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Josɛf ne Mɛri ánérégé yɛndé genó ndɛre ɛbɛ Ɛsɔwɔ ɛgaré, ákpá maá bwɔ́ ákéré meso né Nasarɛt *gebagé mewaá Galilií. ");
INSERT INTO anvNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Maá yimbɔ alu ɛfɛɛ́, awɛne wyɛ́ wɛ́ne ne gelu, ne ɛshyɛ chóncho ne deŋgá. Ne mejé Ɛsɔwɔ ɛlú ne ji. ");
INSERT INTO anvNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Yɛ́ndé nŋmɛ, mmá ne ntɛ Jisɔs ájyɛ né Jɛrosalɛ manjyɛ nyɛ́ ɛpaá *koó upú ɛwé Ɛsɔwɔ aferé nyá bɔɔ́ Isrɛli né defwɛ́. ");
INSERT INTO anvNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Jisɔs akwɔ́négé aŋmɛ́ áfyanéápeá, áfɛ́ ndɛre ɛbwɔ́ ájyɛ mɛ́, ndɛre ɛbwɔ́ ájyɛ ásɛ ntó Jisɔs. ");
INSERT INTO anvNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Ɛpaá ɛ́byɛgé, álɔ mankeré meso melɔ bwɔ́. Ne Jisɔs alá meso né Jɛrosalɛ ayi mmá wúu ne ntɛ wuú álá kaá wɔ́. ");
INSERT INTO anvNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Ábɔ́ áfɛre nnó akɛ geluá ne bɔɔ́ abifɔ. Ákɛ kpaá bií kpogele. Ne gébégé ákɛlé ji né geluágé aŋmɛ́ ne ajeé bwɔ́, ");
INSERT INTO anvNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","ágɛ ji wɔ́. Álɔ mankere meso né Jɛrosalɛ mankɛ́légé ji. ");
INSERT INTO anvNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Né ndɔ ɛ́lɛɛ́ ɛkwɔnegé ágɛ́ ji mmu ɛcha upɛ Ɛsɔwɔ. Abɔ́ alu geluá ne *Ánlɛré mabɛ́ Ɛsɔwɔ. Awuú genó ɛyige álɛ́rege ne amá agige ntó bwɔ́ bɔ nkwɛ. ");
INSERT INTO anvNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Bɔɔ́ ako abi áwuú genó ɛyigé ji ajɔ́ɔge álá mano mekpo fuú néndé awya uchánchá dɔɔ́ ne ashuúge ɛbwɔ́ meko ne déŋga. ");
INSERT INTO anvNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Ndɛre mmá wuú ne ntɛ wuú ágɛné ji, matyɛ mawá ɛbwɔ́ meno. Mmá aké, “Maá wa ɔpyɛ mbɔ ɛsé nnó? Ɛ́sé ne ntɛ wyɛ́ dekɛlé wɔ́ kaá depwaá, delɔ manfɔ nnó ndɔ fɔ genó ne gepyɛ́ wɔ.” ");
INSERT INTO anvNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Ashuú bwɔ́ meko aké, “Ulannó ɛnyú dékɛ́lege mɛ, dekágé fɔ́ nnó mbɔ́ mambɛ́ fa mmu ɛcha ntɛ waá wɔ́?” ");
INSERT INTO anvNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Yɛ́lé ashuú ɛbwɔ́ meko yimbɔ, ákaá fɔ́ ula mechɔ́ ɛwé ji ajɔɔ́ wɔ́. ");
INSERT INTO anvNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Jisɔs akéré meso ne ɛbwɔ́ né melɔ bwɔ́ Nasarɛt, alu ne bwɔ́, awuú majyɛɛ́ chánchá. Ndɛre depɔ ti depyɛ mbɔ́, Mmá wuú afyɛ́ deti deko né metɔɔ́ wuú ne ateé yɛndégébé. ");
INSERT INTO anvNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Ɛfɛɛ́, Jisɔs awɛne ne menyamyɛ ne deŋgá ne gelú, awya mejé né ɛ́gbɛ́ Ɛsɔwɔ ne bɔɔ́ agbóo ne ji. ");
INSERT INTO anvNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","2","Gébé ɛyíge *Jɔn maá Sakariya alú né *mashwɔ́né, Ata Ɛsɔwɔ achyɛ́ɛ mekomejɔɔ́ wuú. Wyɛ́ gébé ɛyígémbɔ ntó ne Tibarɔs alú aŋmɛ́ nekuú né gefwa jií né *Rom. Pɔntyɔs *Palɛt alu nyá gɔmena né *gebagé mewaá Judiya, *Hɛrɔd Antipa alu mémgbaré gebagé mewaá Galilií, meŋmɛ́ wuú Filip alu nyá mémgbáré gebagé mewaá Itura ne Trakonitis. Lysanias alu mfwa melɔ Abilɛn gébé ɛyigémbɔ ntó, Anas ɛbwɔ́ ne Kaifas álú nyá *Matúkpɛ ampyɛ upɛ Ɛsɔwɔ. ");
INSERT INTO anvNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Wyɛ́ ndɛre Ɛsɔwɔ abɔ́ atɔmé Jɔn mbɔ, alɔ mankɛ́né malɔ yi álú kwɔ́kwɔ́lé né ɛbɛɛ́ Jodan, agarege yɛ́ndémuú nnó ákwɔré metɔɔ́ wuú álya gabo ne áwyaá ji manaá Ɛsɔwɔ nnó Ɛsɔwɔ ajinte gabo wuú. ");
INSERT INTO anvNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Ndɛre abɔ́ agárege mbɔ, ɛlú wyɛ́ nkane Asaya muú ɛkpávé Ɛsɔwɔ asámé mmu ŋwɛ wuú nnó, “Muú fɔ abɛne mbɔ né mashwɔne aké: Kwyɛge meti Ata dakɛné, nyaáge ɛ́wú ɛ́bɛ́ cho! ");
INSERT INTO anvNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Sɔ́rege yɛ́ndé mékwɛ́ ɛwé kpaá ne ɛwé kɔɔ́, nnó degbɛɛ́ yɛ́nde geŋkɔ. Nyaáge mati ufwé ábɛ́ cho, pyɛ́gé malu yi álú gbérégbéré ábɛ́ dɔgédɔgé. ");
INSERT INTO anvNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Ne bɔɔ́ ako ágɛ́ne nyɛ nkane Ɛsɔwɔ áférege ɛbwɔ́ né ɛfwyale gabo.” ");
INSERT INTO anvNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Nkane Jɔn agárege mbɔ, gejamégé bɔɔ́ áchwɔ́ ɛta wuú nnó ji áwyaá bwɔ́ manaá Ɛsɔwɔ, aké ne bwɔ́, “Ɛnyú mmyɔ! Ndémuú agaré ɛnyú nnó dekage bó ɛfwyale ɛwé Ɛsɔwɔ achwɔ́ tɔ́? ");
INSERT INTO anvNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Pyɛ́ge unó bí úlɛ́rege nnó dekwɔ́re matɔɔ́ nyú wáwálé. Défɛrégé fɔ́ nnó dekage déjwɔ́le déli mmyɛ nnó, ɛsé délú upyáne *Abraham. Ɛwémbɔ ɛfú yɛ́ genó né ɛta Ɛsɔwɔ wɔ́. Kaáge wáwálé nnó, Ɛsɔwɔ akage pyɛ mataá yina ábwɔlé upyáne Abraham. ");
INSERT INTO anvNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Yɛ nana, ɛnyú debɔ́ mankaá nnó, ábwɛɛ́ mɛ́ ɛtɔɔ́ mfaá mango yɛndé genɔɔ́ ne makaka ɛyi gélágé wɔmé umpomé ulɔ́úlɔ́ ásɔ́ré áfɔme mmu mewɛ.” ");
INSERT INTO anvNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Ne gejamégé bɔɔ́ áwúge mbɔ, ágií Jɔn áké, “Nana ɛsé dépyɛ́ nnó?” ");
INSERT INTO anvNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Jɔn ashuú ɛbwɔ́ meko aké, “Muú abɛgé ne bɔ nkwú ápeá, akáré achyɛ́ nte meŋmɛ́ ayi ala pɔ́ ne nkwu, ne ayi abɛgé ne menyɛɛ́, akáré achyɛ́ ayi ala pɔ́ yɛ ne genó.” ");
INSERT INTO anvNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Yɛ́ ansɛlé ŋkámakpo ntó áchwɔ nnó Jɔn áwyaá ɛbwɔ́ manaá Ɛsɔwɔ ágií ji áke, “Ménlɛré, ɛse ntó depyɛ́ nnó?” ");
INSERT INTO anvNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Ashuú ɛbwɔ́ meko aké, “Désɛgé fɔ́ ŋka ɛ́pwɔ́ ndɛre ɛbɛ́ ɛ́kɛ́.” ");
INSERT INTO anvNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Bɔɔ́ bee áchwɔ gíi ntó áke, “Ne ɛsé dépyɛ́ nnó?” Agaré bwɔ́ aké, “Dényɛgé manwaá, yɛ maáma muú mechɔ́ detú, sɛ́ge wyɛ́ ŋka utɔɔ́ nyú ne metɔɔ́ megɔmegɔ.” ");
INSERT INTO anvNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Jɔn agárege mbɔ, bɔɔ́ ábɔ́ ágíle mɛ *Muú yi Ɛsɔwɔ akweré ji ɛlá gefwa, ɛfɛɛ́ ɛbwɔ́ álu ne dembyɔ́ né matɔɔ́ bwɔ́, ábélege umɛɛ́ nnó ndɔfɔ ji ne alú Muú ayi Ɛsɔwɔ akweré ji ɛlá gefwa. ");
INSERT INTO anvNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Jɔn ashuú ɛbwɔ́ ako meko aké, “Me nwyage ɛnyú ne manaá Ɛsɔwɔ mamímamí yɛ́mbɔ, muú ayi áŋeá gemɛ apwɔ́ me achwɔ́ mbɔ me meso. Ne nkwané yɛ́ muú ayi ntóme manó mme nkaá manyií unó uká bií wɔ́. Achwɔgé, awyage ɛnyú ne *Mendoó Ukpea ne mewɛ. ");
INSERT INTO anvNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Achwɔɔ́ nyɛ́ ne ɛ́kɔ́riyá né ɛbwɔ wuú mánchá ɛsa. Anerégé ashwané nyɛ matoó álá pópó, afyɛ ɛsa né mmu uba abelé. Ne ukwɔɔ́ ɛbi ulaá akpane agbɛ né mewɛ ɛwé ɛ́lá nómégé.” ");
INSERT INTO anvNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Na ne Jɔn agaré *abya Ɛsɔwɔ melɔ́mélɔ́ mbaá bɔɔ́, ne aji bwɔ́ matu né gejamégé majyɛ́ amí ama chyɛɛ́ bwɔ́. ");
INSERT INTO anvNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Jɔn ashulé ntó ndo mbaá Hɛrɔd ayi alú gɔ́mena, gétúgé abané Hɛrɔdyas, mendée meŋmɛ́ wuú jimbɔ, ne géjámégé ubée bí ama pyɛ. ");
INSERT INTO anvNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Hɛrɔd aké awúu mbɔ, ama jyɛ mbɛ́ mampyɛ gabo, apyɛ Jɔn afyɛ́ denɔ. ");
INSERT INTO anvNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Nsá nnó Jɔn akpɛ́ denɔ, abɔ́ awyage mɛ́ bɔɔ́ manaá Ɛsɔwɔ. Bií fɔ́ anérége Jisɔs achwɔ́ ntó nnó Jɔ́n awyaá ji manaá Ɛsɔwɔ. Aké atanege mmu nnyi, anɛnemmyɛ mfaánebuú anené. ");
INSERT INTO anvNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Anénégé mbɔ, *Mendoó Ukpea ɛ́shulé ɛchwɔ́ ji mmyɛ ɛ́lú wyɛ́ ɛké gepwine. Ne meko atané mfaánebuú aké, “Ɔ́lu maá metɔɔ́ wa, metɔɔ́ ɛgɔɔ́ me ne wɔ dɔɔ́.” ");
INSERT INTO anvNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Gébégé Jisɔs alɛré mmyɛ manlɔ utɔɔ́ bií alu aŋmɛ ɛsaá meso ɛfyá. Bɔɔ́ ábɔ́ áfɛre nnó alu maá Josɛ́p ne Josɛf abɔ́ alu maá Hɛli. ");
INSERT INTO anvNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Hɛli abɔ́ alu maá Matat, Matat abɔ́ alu maá Lɛvi, Lɛvi maá Mɛlki, Mɛlki abɔ́ alu maá Jana, Jana ayi alu maá Josɛf. ");
INSERT INTO anvNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Josɛf alu maá Matatyas, Matatyas alú maá Ɛmɔs, Ɛmɔs maá Nahum, Nahum maá Ɛseli, Ɛseli ayi alú maá Nagay, ");
INSERT INTO anvNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagay alu maá Mat, Mat maá Mattatya, Mattatya maá Sɛmɛn, Sɛmɛn, maá Josɛch, Josɛch maá Joda, ");
INSERT INTO anvNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Joda maá Joanan, Joanan maá Rɛsa, Rɛsa maá Sɛrubabɛl, Sɛrubabɛl maá Shɛltyɛl, Shɛltyɛl alu maá Nɛri. ");
INSERT INTO anvNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Nɛri maá Mɛlki, Mɛlki maá Adi, Adi maá Kɔsam, Kɔsam maá Ɛlmada, Ɛlmada alu maá Ɛre. ");
INSERT INTO anvNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Ɛre maá Joshua, Joshua maá Ɛlyssa, Ɛlyssa maá Jorim, Jorim ayi alú maá Matat, Matat maá Lɛvi. ");
INSERT INTO anvNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Lɛvi maá Simyɔn, Simyɔn maá Juda, Juda maá Josɛf, Josɛf maá Jonam, Jonam yi alú maá Ɛliakim, ");
INSERT INTO anvNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Ɛliakim maá Meleya, Meleya maá Menna, Menna maá Matata, Matata maá Natan, Natan alu maá Dɛvid. ");
INSERT INTO anvNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Dɛvid maá Jɛsse, Jɛsse maá Obɛd, Obɛd maá Boas, Boas maá Salmɔn, Salmɔn alu maá Nashyɔn. ");
INSERT INTO anvNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nashyɔn maá Aminadab, Aminadab maá Admin, Admin maá Ani, Ani maá Hɛsrɔn, Hɛsrɔn maá Pɛrɛs, Pɛrɛs alu maá Juda. ");
INSERT INTO anvNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Juda maá Jakɔb, Jakɔb maá Asek, Asek maá Abraham, Abraham maá Tɛra, Tɛra maá Náhɔ. ");
INSERT INTO anvNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Náhɔ alu maá Sɛrug, Sɛrug maá Ru, Ru maá Pɛlɛg, Pɛlɛg maá Ɛbɛ, Ɛbɛ maá Shɛla. ");
INSERT INTO anvNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Shɛla maá Kenan, Kenan maá Afasad, Afasad maá Shɛm, Shɛm maá Nowa, Nowa alu maá Lamek, ");
INSERT INTO anvNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamek maá Metusɛla, Metusɛla maá Ɛnɔk, Ɛnɔk maá Jarɛ, Jarɛ maá Mahalalɛ, Mahalalɛ alu maá Kɛnan. ");
INSERT INTO anvNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kɛnan alu maá Ɛnɔs, Ɛnɔs maá Sɛt, Sɛt maá Adam, Adam abɔ́ alu Maá Ɛsɔwɔ. ");
INSERT INTO anvNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Ndɛre Jɔn ábɔ́ áwyaá Jisɔs manaá Ɛsɔwɔ né ɛbɛɛ́ Jodan, Mendoó Ukpea ɛgbɛɛ́ Jisɔs metɔɔ́ ne ɛ́pyɛ ji afɛ́ né mashwɔne. ");
INSERT INTO anvNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Ɛ́bá ji né usaá ndɔ upeá, nnó danchɔmeló ammua ji. Jisɔs abɛlé né mashwɔne wyɛ́mbɔ yɛ menyɛɛ́ anyɛɛ́ wɔ́. Gébégé ndɔ yimbɔ ɛkwyágé mesa alɔ́ mammyɛ ji. ");
INSERT INTO anvNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","*Danchɔmeló áchwɔ́ ɛta wuú ajɔɔ́ aké, “Mbɔgé wɔ ɔlu *Maá Ɛsɔwɔ, garé mataá áyina ábwɔ́lé ntoó brɛd.” ");
INSERT INTO anvNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Jisɔs ashuú ji meko aké, “Ásá mmu ŋwɛ Ɛsɔwɔ nnó, ‘Menyɛɛ́ jiji fɔ́ wɔ́ awyaá ɛshyɛ mángbaré geŋwágé mekwaá wɔ́.’” ");
INSERT INTO anvNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Danchɔmeló akpá ji ákwɔ́ tɛ mfaá melu fɔ́ ɛwé ɛ́ŋɔgé ne alɛré ji malɔ mme mako ne gefwa. Jisɔs agɛ ájí gébé dáma. ");
INSERT INTO anvNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Ne ajɔɔ́ ne Jisɔs aké, “Áchyɛ me mme yiná meko ne nkage chyɛ́ yɛ́ waá ayi ajigé me metɔɔ́. Menchyɛge nyɛ wɔ uto ne gefwa yí gélú fá né mme yina. ");
INSERT INTO anvNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Mbɔgé ɔtógé mánó mbɛ ushu wa ne ɔnogé me nkane Ɛsɔwɔ, mme yiná meko abɛɛ́ nyɛ́ awyɛ́.” ");
INSERT INTO anvNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Jisɔs ashuú ji meko aké, “Ása né mmu ŋwɛ Ɛsɔwɔ nnó, ‘Ɔbɔ́ manógé ɛlé Ntɛ wyɛ Ɛsɔwɔ jimbií ne ɔkpáné wyɛ lé ji defwɛ’.” ");
INSERT INTO anvNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Dánchɔmeló ama asɛ Jisɔs afɛ́ né Jɛrosalɛ abelé ji né melu ɛwé ɛ́lú tɛtɛ mfaá ɛcha upɛ Ɛsɔwɔ né Jɛrosalɛ ne aké ne ji, “Mbɔgé wɔ ɔlu Maá Ɛsɔwɔ nyó chɔ mme. ");
INSERT INTO anvNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Néndé ásá né mmu ŋwɛ Ɛsɔwɔ nnó: ‘Ɛsɔwɔ atɔme nyɛ́ makiɛ́nné jií nnó áchwɔ́ ábámé wɔ.’ ");
INSERT INTO anvNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Áma sá nnó: ‘Ágbárege nyɛ́ wɔ né amu bwɔ́ chánchá nnó ɔ́kagé ɔ́tó ɛnɔɔ́ geká né ntaá.’” ");
INSERT INTO anvNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Jisɔs ashuú ji meko aké, “Ájɔɔ́ nnó: ‘Mekwaá ákpelégé fɔ́ Ntɛ wuú Ɛsɔwɔ mankpea ji nnó ápyɛ́ genó.’” ");
INSERT INTO anvNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Danchɔmeló ánérégé mámua Jisɔs alyá ji, afɛ́ kpɛ́. ");
INSERT INTO anvNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Jisɔs ályágé melu ɛwémbɔ akeré meso né Gálilí, ne uto Mendoó Ukpea úlú ne ji. Ngɔ́ wuú akwɔ́ né malɔ́ Galilií yimbɔ mako, ");
INSERT INTO anvNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","gétúgé ábɔ́ álɛ́rege bɔɔ́ né mmu macha mmyɛmenɛne ne bɔɔ́ ako bi awuú, áfɛ́ɛge ji. ");
INSERT INTO anvNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Né gébé gefɔ́ Jisɔs afɛ́ ntó né Nasarɛt mbaá yi áwɛɛ́ ji. Bií uwyaá bwɔ́ úkwɔ́négé afɛ́ mmu ɛcha mmyɛmenɛne ndɛre gepɔ jií gélu mɛ́. Ɛ́ké ɛ́wyáge akwilé ka mankwuú ŋwɛ Ɛsɔwɔ. ");
INSERT INTO anvNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Áchyɛ́ ji ŋwɛ yi Asaya *Muú Ɛkpávé Ɛsɔwɔ ásamé. Anené ji, apɛ melu fɔ́ né mmu, akú melu ɛwémbɔ ɛ́ké: ");
INSERT INTO anvNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Mendoó Ata Ɛsɔwɔ ɛlú ne me, gétúgé abɔ́ ajyá me nnó ngaré abya Ɛsɔwɔ melɔ́mélɔ́ mbaá bɔɔ́ gekpo. Ama tɔ́ me nnó ngare mekomejɔɔ́ Ɛsɔwɔ mbaá bɔɔ́ bí ákpɛné denɔré bee nnó ɛbwɔ́ átánege nyɛ ne mangaré mbaá bɔɔ́ amɛ nónómé nnó ɛbwɔ́ ámáge lɔ́ nyɛ́ mangɛ́, átɔ́ me ntó nnó mféré ntó abi álú né ɛfwyale, ");
INSERT INTO anvNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","ne mangaré nnó gébé gékwɔné ɛyígé Átá ápóoge nyɛ́ bɔɔ́ bií.” ");
INSERT INTO anvNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Jisɔs ájɔ́gé ŋwɛ yimbɔ, akweré, ashuú ɛtá mémbelé, ajwɔlé ka. Bɔɔ́ ako né mmu ɛcha mmyɛmenɛne átó ji amɛ mmyɛ. ");
INSERT INTO anvNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Alɔ mangaré ɛbwɔ́ aké, “Mekomejɔɔ́ yi déwuú fina né mmu ŋwɛ Ɛsɔwɔ alu wáwálé.” ");
INSERT INTO anvNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Bɔɔ́ áwúgé deŋgare mejɔɔ́ melɔ́mélɔ́ ɛwé ájɔɔ́, matɔɔ́ ágɔ bwɔ́ dɔɔ́. Ákamé nnó alu cho ne ákwéne dembyɔ́ áké, “Pɔ́ maá Josɛf na?” ");
INSERT INTO anvNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Jisɔs aké ne ɛbwɔ́, “Ɛ́la gachyɛ́ ɛnyú déto me maka mmyɛ nnó, ‘Mémpyɛ́ mamée, poó gemɛ jyɛ́, ufélekpá ɛbí ɔ́lɛrege né Kapanɔm, lɛ́ré úbí ntó fá né melɔ wyɛ́.’” ");
INSERT INTO anvNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Jisɔs ama jɔɔ́ ne ɛbwɔ́ aké, “Ngarege ɛnyú wáwálé nnó bɔɔ́ ɛkpávé Ɛsɔwɔ apɔ́ ne ɛ́nógé né melɔ bwɔ́”. ");
INSERT INTO anvNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Ama ŋmɛ́re aké, “Wuúge gébégé Ɛlija álú Muú Ɛkpávé Ɛsɔwɔ, Ɛsɔwɔ apyɛ mekwyɛ́ abɛlé né áŋmɛ́ álɛɛ́ ne geba ne mesa akwé malɔ mako. Dekaá ntó nnó gejamégé akwí andée álú nyá né gébé ɛyigémbɔ fá melɔ́ Isrɛli, ");
INSERT INTO anvNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Ɛsɔwɔ átɔ fɔ́ *Ɛlija nnó ájyɛ́ ápoó afɔ wɔ́. Atɔ lé ji mbaá mekwí mendée yi ajwɔ́lege né Sarifat né gebagé mewaá Sidɔn ne apoó ji. ");
INSERT INTO anvNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Gébégé *Ɛlishya alú *Muú Ɛkpávé Ɛsɔwɔ gefɔɔ́ genó ɛyígémbɔ gépyɛ ntó. Né mme Isrɛli, gejamégé bɔɔ́ ábɔ́ ámeé ubá ne Ɛlishya apoó yɛ́ muú bwɔ́ ama wɔ́. Apoó ɛ́lé *Naman ayi alú lé muú Siriya.” ");
INSERT INTO anvNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Bɔɔ́ bí alú né mmu Ɛcha Mmyɛmenɛne awuúgé depɔ ɛti, nchyɛ anwyɔné ɛbwɔ́, ");
INSERT INTO anvNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","ákwilé ka, ágbaré Jisɔs, ája ji áfɛ́ nnó ámmú ji akwé né nteé géŋkɔ. Ábɔ́ átɛné melɔ bwɔ́ né mfaa mekwɛ, ɛgbɛ ɛma ɛbɔ ɛ́lú nteé géŋkɔ. ");
INSERT INTO anvNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Ndɛre ájyɛ ne ji abwɔlé mmyɛ akoó kóoge metɔɔ́ metɔɔ́ bwɔ́ afɛ́ ɛgbɛ́ wuú. ");
INSERT INTO anvNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Jisɔs ashulé afɛ́ né Kapanɔm, melɔ kpaa ɛwú né gebagé mewaá Galilií, ne yɛ́ndé bií uwyaá bɔɔ́ Jus ukwɔnégé, alɛrege ɛbwɔ́ mekomejɔɔ́ Ɛsɔwɔ. ");
INSERT INTO anvNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Ɛbwɔ́ ála mano mekpo fuú, né gefɔɔ́ ɛyígé ji álɛ́rege gétúgé ajɔ́ge ne uto. ");
INSERT INTO anvNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Mende fɔ abɔ́ alu ɛ́fɛɛ́ né Ɛcha Mmyɛmenɛne ayi meló achyɛ́ge ɛfwyale. Ɛ́wyá wɔ́, alɔ mánkalé ne ɛshyɛ aké, ");
INSERT INTO anvNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Ɛ ɛ́ Jisɔs ayi Nasarɛt, ɔkɛlege mampyɛ ɛsé ndé? Ɔchwɔ́ manií ɛsé mbwɛ? Nkage wɔ, ɔlu Muú Ukpea ayi atané mbaá Ɛsɔwɔ.” ");
INSERT INTO anvNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Jisɔs anyá meló nchyɛ yimbɔ aké, “Kwéné mejɔɔ́, táné ji mmyɛ.” Meló nchyɛ apyɛ mende yimbɔ akwé né mbɛ ushu bɔɔ́, ne atané ji mmyɛ. Yɛ́mbɔ achwu ji wɔ́. ");
INSERT INTO anvNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Bɔɔ́ ako ágɛ́gé gefɔɔ́ yina ala mano mekpo fuú ne ágige atɛ áké, “Mekomejɔɔ́ Jisɔs alu mbɔ nnó? Awya uto mányá áló nchyɛ átáné bɔɔ́ mmyɛ.” ");
INSERT INTO anvNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Ngɔ́ Jisɔs akwɔ́ malɔ mako né gebagé mewaá ɛyigémbɔ. ");
INSERT INTO anvNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Jisɔs ályágé ɛcha mmyɛmenɛne, afɛ́ gepúgé Símun. Ɛ́fɛɛ́ mmá mendée Simun ameé njaja gefwine. Bɔɔ́ bí álú mmu gepu áke né Jisɔs: Ata pyɛ ji atoó. ");
INSERT INTO anvNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Ájɔ́gé mbɔ, Jisɔs akwilé ajyɛ tɛne ji né nékuú né mmyɛ né mbaá yi abɛlé. Anyá dámáa gefwine gebyɛ́ ji mmyɛ ne mendée yimbɔ akwilé ka achyɛ́ ɛbwɔ́ menyɛɛ́. ");
INSERT INTO anvNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Nkwale aké akwɔnege bɔɔ́ bí áwya bɔɔ́ bi ámeé ufɔɔ́ mameé né upú bwɔ́ áchwɔ́ ne ɛbwɔ́ mbaá Jisɔs. Ji ata bwɔ́ amu mmyɛ, ɛbwɔ́ ako átoó. ");
INSERT INTO anvNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Yɛ́mbɔ gejamégé bɔɔ́ abɔ́ álú ábí áló nchyɛ áchyɛ́ge bwɔ́ ɛfwyale. Gébégé áló nchyɛ bimbɔ átanégé ɛbwɔ né mmyɛ, ábó ákálege áke, “Jisɔs, ɔlu Maá Ɛsɔwɔ.” Jisɔs anyá ábí nnó ákwéné mejɔɔ́, akámé fɔ́ ábí ájɔɔ́ mejɔɔ́ wɔ́ néndé ákaá nnó alu *Muú yi Ɛsɔwɔ akweré ji ɛlá gefwa. ");
INSERT INTO anvNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Bií ujyágé alyá afɛ́ né melu ɛ́wé bɔɔ́ álá pɔ́ wyɛɛ́. Aké ajyɛ mbɔ, bɔɔ́ ála meso mákɛ́légé ji ne ágɛ ji wɔ́. Gébégé ágɛné ji alu mɛ́ tɛ́né manjyɛ. Ɛ́fɛɛ́ ne ánɛné ji mmyɛ nnó ajwɔ́lé ɛ́fɛɛ́ ne ɛbwɔ́ ");
INSERT INTO anvNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Ashya aké ne ɛbwɔ́, “Mbɔ́ ntó manjyɛ né malɔ ayichá mangaré abya melɔ́mélɔ́ ayi agarege ndɛre gefwage Ɛsɔwɔ gélú. Ɛsɔwɔ atɔ́ me fá mme yina gétú ɛyígémbɔ.” ");
INSERT INTO anvNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Ajɔ́gé mbɔ ne ji alyá ájyɛ́ melɔ Nasarɛt meko, mángárége abya yimbɔ né mmu macha mmyɛmenɛne Judiya. ");
INSERT INTO anvNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Bií fɔ́ Jisɔs abɔ́ atɛné né mapeá géntoógé mewaá Gɛnɛsarɛt. Bɔɔ́ áchwɔ́ nɔ ji mme, áŋmɛ́rege ji ákɛ́lege manwú meko mejɔɔ́ Ɛsɔwɔ. ");
INSERT INTO anvNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Agɛ́ mákpée ápeá né mapea géntoógé mewaá ne ambɔɔ́ mákpée átané ájyɛ shwɔ́ne utófu bwɔ́. ");
INSERT INTO anvNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Ajyɛ kpɛ né ɛkpée ɛ́ma ɛ́wé Simun, ne ajɔɔ́ ne ji aké, “Áté ɛkpée ɛ́jyɛ́ dachyɛ́ ne nnyi. Áté Jisɔs ajwɔlé mmu ɛkpée, bɔɔ́ ála mbale nnyi, Jisɔs alɔ yɛ́ manlɛregé bwɔ́.” ");
INSERT INTO anvNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Ánérégé mánlɛré, aké ne Simun, “Té ɛkpée ɛ́jyɛ́ mbaá yi nnyi négomé ne wɔ ne bɔɔ́ byɛ́ ŋmége utófú nyú manwá meshuú.” ");
INSERT INTO anvNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simun ashuú ji meko aké, “Ata dépyɛ utɔɔ́ ne utuú kpaá yɛ genó déwa wɔ́. Yɛ́mbɔ, ndɛre wɔ ne ɔjɔɔ́ mmage njyɛ́ mua.” ");
INSERT INTO anvNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Ɛbwɔ́ áfɛ́, áŋme utófú bwɔ́, meshuú ɛ́sɛ gejámé tɛ utófú úke úgyálé. ");
INSERT INTO anvNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Ɛpwɔ́gé ɛbwɔ́, áfu amu nnó atɛ ajeé abi alú mmu ɛ́kpe ɛwé fɔ́ áchwɔ poó bwɔ́. Áchwɔ́gé áferé gejamégé meshuú, áfyɛ́ makpée bwɔ́ apea ágbeé tɛ ákɛ́lege mánke. ");
INSERT INTO anvNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Simun ayi akúu ji ntó nnó Pita agɛ́gé genó ɛyi gepyɛ mbɔ, ajyɛ tó manó mme mbɛ ushu Jisɔs aké, “Atá kwilé lyá me, néndé nlu mémpyɛɛ́ ubeé.” ");
INSERT INTO anvNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Abɔ́ ajɔge mbɔ gétúgé ji ne bɔɔ́ bií ágɛné gejámégé meshuú ɛyí ɛbwɔ́ áwané, ɛfɔ́ ɛ́kwɔ́ bwɔ́ matɔɔ́. ");
INSERT INTO anvNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Ajeé bií Jɛmsi ne Jɔn abi álú baá Sɛbɛdee ála ntó mano makpo fuú. Ne Jisɔs ajɔɔ́ ne Simun aké, “Ɔ́fɔgé, nana ɔlɔ nyɛ́ manywérégé lé bɔɔ́.” ");
INSERT INTO anvNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Ɛbwɔ́ áwúgé mbɔ ája mákpée bwɔ́ ákwɔ́ mewaá, ályá yɛndégenó ne ákwɔlé ji. ");
INSERT INTO anvNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Né gébé gefɔ́ Jisɔs abɔ́ álu né melɔ́ kpaa fɔ́ ne muú fɔ álu wyɛ́ ayi amée *ubá. Agɛ́gé Jisɔs ajyɛ tó mánó mme, akpá ji geká aké, “Ata mbɔgé ɔkɛlege, pyɛ me nkpea.” ");
INSERT INTO anvNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Jisɔs anyaá ɛbwɔ wuú ata ji aké, “Nkɛlege, kpea.” Wyɛ ndɛre ájɔɔ́ mbɔ ubá bimbɔ úbyɛ́ ");
INSERT INTO anvNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Jisɔs aké né ji ɛkagé ɔgáré muú fɔ́, “Chó lɛ́ré lé mmyɛ jyɛ́ mbaá mémpyɛ́ upɛ Ɛsɔwɔ, chyɛ́ ntó genó ɛyige ápyɛ gepɛ ndɛre Mosis ábɔ́ ájɔɔ́ nnó muú amegé ubá atoógé áchyɛ́ge, mampyɛ bɔɔ́ ákaá nnó ɔtoó.” ");
INSERT INTO anvNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Yɛ́ ɛlé Jisɔs afyɛ ji ɛbɛ́, mende yina agaré abya wuú mme meko kpaá gejamégé bɔɔ́ gechwɔ́ chóme mbaá Jisɔs, manwú nkane alɛ́rege ne nnó apyɛ ntó abi ámeé átoó. ");
INSERT INTO anvNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Yɛ́mbɔ Jisɔs ályá ɛbwɔ́ né mboó gébé manjyɛ nɛ́mmyɛ né melu ɛwé bɔɔ́ álá pɔ́ wyɛ́. ");
INSERT INTO anvNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Né bií fɔ́ Jisɔs abɔ́ alɛrege bɔɔ́, Atá Ɛsɔwɔ áchyɛgé ji uto ne ji apyɛ bɔɔ́ mamée átóogé. Bɔɔ́ bí ákúu bwɔ́ Farasi ne Ánlɛré mabɛ Ɛsɔwɔ álú wyɛ́, ne abɔ́ átané né malɔ́ Galilií mako ne Judiya chóncho ne Jɛrosalɛ. ");
INSERT INTO anvNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Bɔɔ́ fɔ́ akpá muú úchánchi né ulɔ́. Ábɔ́ áchwɔ́ nnó ákpɛ mmu gepú ne ábélé ji mbɛ ushu Jisɔs. ");
INSERT INTO anvNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Yɛ́mbɔ ágɛ meti mankpɛ ne ji wɔ́, gétúgé bɔɔ́ ájamé dɔɔ́, kpaá áŋmɛ́rege atɛ. Ɛfɛɛ́ ne ákwɔmé mfaá nchwu, ábeá mekpo ŋkɔ́, áshulé mende yimbɔ né ulɔ́ né mbɛ ushu Jisɔs. ");
INSERT INTO anvNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Jisɔs agɛ́gé nnó bɔɔ́ bimbɔ áfyɛɛ́ matɔɔ́ ne ji áké ne mende úchánchi yimbɔ, “Mejeé wa ájiínte gabo wyɛɛ́.” ");
INSERT INTO anvNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Ánlɛré mabɛ́ Ɛsɔwɔ fɔ, ne abi akuú bwɔ́ Farasi áŋménege ne matɔɔ́ usɔɔ́ áke, “Mende yina áfɛré nnó álu waá. Ákɛlege mamɛɛ́ mmyɛ ne Ɛsɔwɔ? Ɛ́lé Ɛsɔwɔ mbií ne akage jinte gabo muú.” ");
INSERT INTO anvNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Jisɔs akaá ula bí ɛbwɔ́ áŋménege ne ágií ɛbwɔ́ áké, “Ulannó ɛnyú déwya gefɔgé ufɛ́ré bímbɔ né matɔɔ́ nyú? ");
INSERT INTO anvNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Ndé gelu pere manjɔɔ́, ‘Nnó ájiínte gabo wyɛ́’, waá manjɔɔ́ nnó, ‘Kwile tɛ́né kɛ’? ");
INSERT INTO anvNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Nkɛlege mámpyɛ ɛnyú dékaá nnó *Maá Ntɛ Mekwaá awyaá uto fa mme manjinte gabo mekwaá.” Ajɔ́gé mbɔ, akuú mende úchánchi yimbɔ aké, “Kwile tɛ́né. Kpá ulɔ́ byɛɛ́, chó mmu.” ");
INSERT INTO anvNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Akwilé tɛ́né mbɛ ushu bɔɔ́, akpá ulɔ́ bií awulé né gepú jií afɛ́ɛge Ɛsɔwɔ. ");
INSERT INTO anvNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Bɔɔ́ ako ágɛ́ge ɛwe ɛpyɛ na, ɛfɔ́ ɛ́kwɔ́ bwɔ́ matɔɔ́ dɔɔ́. Ála mano mekpo fuú ne áfɛɛ́ge Ɛsɔwɔ áké, “Dégɛ́ ufɔɔ́ unó fina.” ");
INSERT INTO anvNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Jisɔs ályá ɛ́fɛɛ́ manjyɛ dafyɛ, gébégé ajyɛ agɛ́ mende fɔ ayi ákúu ji Lɛvi; ménsɛlé ŋkámakpo, ajwɔlé melú utɔɔ́ wuú. Jisɔs akuú ji aké, “Kwɔ́lé me.” ");
INSERT INTO anvNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Ajɔ́gé mbɔ Lɛ́vi alyá yɛ́ndégenó, akwilé ka alɔ mankwɔlé ji. ");
INSERT INTO anvNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Ɛ́ké ɛ́wyage Lɛvi akuú gekpɛ́kpɛ́gé ɛpaá né gepú jií nnó ɛbwɔ́ ne Jisɔs ábɛ́ mmu nechɔ́chɔ́. Gejame ánsɛlé ŋkámakpo ne bɔɔ́ bífɔ́ abi bɔɔ́ Jus ásɛlé ndɛre bɔ ápɔ́ mpa, ɛbwɔ́ ako abɔ́ ányɛɛ́ menyɛɛ́ ne Jisɔs. ");
INSERT INTO anvNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Bɔɔ́ Farasi ne Ánlɛré mabɛ́ Ɛsɔwɔ abifɔ ágɛ́ge mbɔ, álɔ máŋmené áké ne baá utɔɔ́ Jisɔs, “Ulannó ɛnyú dényɛ menyɛɛ́ ne ánsɛlé ŋkámakpo ne bɔɔ́ ubeé.” ");
INSERT INTO anvNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Jisɔs ató ɛbwɔ́ neka áké, “Bɔɔ́ abi álá meé, ákɛ́légé fɔ́ muú uka, ɛ́lé abi ámeé ne ákɛ́lege. ");
INSERT INTO anvNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Ne me nchwɔ́ fɔ́ fa mme mánkú bɔɔ́ abi álu cho ne Ɛsɔwɔ wɔ́, nchwɔ́ lé mánku bɔɔ́ abi ápyɛɛ́ ubeé nnó ákwɔre matɔɔ́ bwɔ́.” ");
INSERT INTO anvNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Áma gíi Jisɔs nkwɛ́ yina nnó, “Baá utɔɔ́ Jɔn ályage *menyɛɛ́ kpékpé né mboó gébé gétúgé depɔré Ɛsɔwɔ. Baá utɔɔ́ bɔɔ́ Farasi ápyɛ ntó wyɛ́mbɔ ne abyɛɛ́ ápyɛ́ fɔ́ mbɔ. Ɛbwɔ́ ákɛ́ne ányɛ́, ányúu.” ");
INSERT INTO anvNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Jisɔs ashuú ɛbwɔ́ meko aké, “Nnó bɔɔ́ ájyɛgé ɛpaá neba muú akage pyɛɛ́ ajeé menɔ neba ályage menyɛɛ́ kpékpé ayi menɔ neba alú ne ɛbwɔ́? ");
INSERT INTO anvNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Yɛ́mbɔ gébé gebɛɛ́ nyɛ ɛyígé menɔ neba álá bɛɛ́ nyɛ́ sé ne ɛbwɔ́, ɛ́fɛɛ́ ne ályáge nyɛ́ menyɛɛ́ kpékpé né mboó gébé gétúgé depɔré Ɛsɔwɔ.” ");
INSERT INTO anvNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Ama tó neka ɛníne fɔ́ aké, “Ɛ́lɔ́mé fɔ́ nnó muú ágyá ndeé mekɛ ákwɔmé ndeé ɛyi gekwéne. Apyɛgé mbɔ achɔɔ́ ndeé yi mekɛ, ne nkwɔmé yimbɔ ábálé ne gekwénegé ndeé. ");
INSERT INTO anvNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Ɛ́lɔ́mé fɔ́ ntó nnó muú ákpa mmɔɔ́ makɛ, áfáné mmu ukwéne unó mmɔɔ́ ɛbi akwyɛɛ́ ne mekɔ menya. Mbɔgé apyɛgé mbɔ gébégé mmɔɔ́ mí makɛ maké mabɛ́ne unó mmɔɔ́ bimbɔ úfúle nyɛ́, mmɔɔ́ magbɛ́légé nyɛ́ mme ne unó mmɔɔ́ uchɔ́gé nyɛ ntó. ");
INSERT INTO anvNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Muú abɔ́ mamfyɛ́ mmɔɔ́ makɛ yɛ́ndégébé mmu unó mmɔɔ́ ɛbí ukɛ. ");
INSERT INTO anvNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Ɛ́pɔ́ kɔkɔge nnó muú yi abeá mɛ́ mányú akí mmɔɔ́ ámá ákwɔ́ré ányúgé mpwa mmɔɔ́. Akɛ́lege wyɛ́ akí mmɔɔ́.” ");
INSERT INTO anvNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Né bií uwyaá bɔɔ́ Jus fɔ, Jisɔs ne baá utɔɔ́ bií ákoóge né mekɔɔ́ gefɔgé nchi fɔ ɛyi ákuú nnó wid. Baá utɔɔ́ bií álɔ mánkɔ́gé ulɔnchi fɔ́ álálege ányɛɛ́. ");
INSERT INTO anvNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Bɔɔ́ Farasi ágɛ́gé mbɔ ágií áké, “Ulannó ɛnyú dépyɛɛ́ genó ɛyígé ɛbɛ́ ɛla ɛ́kamé nnó muú apyɛ bií uwyaá wɔ́?” ");
INSERT INTO anvNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Jisɔs agií ɛbwɔ́ awuú nkwɛ́ aké, “Ɛnyú délú danjɔɔ́ né mmu ŋwɛ Ɛsɔwɔ ndɛre mfwa Dɛvid ápyɛ́ nyá gébégé mesa ámmyɛ ji ne bɔɔ́ bií wɔ́? ");
INSERT INTO anvNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Akpɛ mmu ɛcha upɛ Ɛsɔwɔ ábɔ́ menyɛɛ́ yi ábɔ́ áchyɛ́ mbaá Ɛsɔwɔ, ányɛ́ ne áchyɛ́ ntó bɔɔ́ bií wɔ́? Ɛbɛ́ ɛjɔɔ́ nyá nnó muú ányɛgé fɔ menyɛɛ́ yimbɔ, ɛ́kosé mémpyɛ́ upɛ Ɛsɔwɔ.” ");
INSERT INTO anvNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Jisɔs ama jɔɔ́ ne bwɔ́ aké, “Ɛle *Maá Ntɛ Mekwaá ne akáge gáre genó yí muú ábɔɔ́ mampyɛ né bií uwyaá.” ");
INSERT INTO anvNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Bií uwyaá ɛbifɔ́ úkwɔ́négé, Jisɔs ajyɛ kpɛ́ mmu Ɛcha mmyɛmenɛne, alɔ mánlɛ́régé bɔɔ́. Mende fɔ abɔ́ alú ɛfɛɛ́, ayi ɛbwɔnyɛ wuú ɛgboó. ");
INSERT INTO anvNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","*Ánlɛré mabɛ́ Ɛsɔwɔ ne bɔɔ́ Farasi ábɔ́ ábáme Jisɔs nnó ámá ji mechɔ́ mmyɛ. Ápɛ́le ji dome mangɛ nnó apyɛ nyɛ mende yimbɔ atoó né bií uwyaá bwɔ́ ne ájɔɔ́ nnó ákwé ɛbɛ́. ");
INSERT INTO anvNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Yɛ́mbɔ Jisɔs akaá genó ɛyígé ɛbwɔ́ áfɛ́rege aké ne mende yimbɔ, “Kwilé chwɔ́ tɛ́né mbɛ ushu bwɔ́.” Ne akwilé achwɔ tɛ́ne ɛfɛɛ́. ");
INSERT INTO anvNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Mende yimbɔ átɛ́négé ɛfɛɛ́, Jisɔs agií ɛbwɔ́ aké, “Ɛbɛ́ ɛsé ɛké depyɛ ndé né bií uwyaá? Ɛke dépyɛ galɔ́gálɔ́ wá gabogabo? Mampyɛ mekwaá apó wá mánlyaá ji agbó?” ");
INSERT INTO anvNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Apɛ ɛbwɔ́ bɔɔ ne álé jɔ́ɔ ne mende yimbɔ aké, “Nyaá ɛbwɔ wyɛ.” Tɛ́netɛ́ne mende yimbɔ anyágé, ɛbwɔ wuú ɛtoó. ");
INSERT INTO anvNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Ɛwéna ɛpwɔ ɛbwɔ́ amu, matɔɔ́ ásɔ́ ɛbwɔ́ ájyɛ chó mánsɔ́ mala nnó áwá Jisɔs. ");
INSERT INTO anvNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Né gébé ɛyígémbɔ, Jisɔs alyá melɔ akwɔ́ mékwɛ́ fɔ́ mánɛmmyɛ mbaá Ɛsɔwɔ ne ala ɛwú anɛnemmyɛ utuú uko. ");
INSERT INTO anvNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Gébégé bií úkaá, akú baá utɔɔ́ bií; áchwɔ́gé ajya áfyanéápeá abi akúu ɛbwɔ́ nnó áŋgbá. ");
INSERT INTO anvNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Abi ájya ɛ́lé Simun ayi ákuú ntó nnó Pita ne Andru meŋmó Simun. Abifɔ álú Jɛmsi ne Jɔn, Filip ne Batolomyo. ");
INSERT INTO anvNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matyo ne Tɔmasi, Jɛmsi maá Alfɔs, Simun ayi ákúu ji muú ukógé. ");
INSERT INTO anvNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Judas ayi maá Jɛmsi, ne Judas Iscarot ayi né meso gébé áchyɛ́ Jisɔs maŋkwaá. ");
INSERT INTO anvNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Ánérégé manjya ɛbwɔ́ alɔ mánshulé mekwɛ. Ashúlé akwya né mbaá ayi alú dɛdɛ, ne gejamégé bɔɔ́ gébɔ́ géchomé ɛ́fɛɛ́. Ábɔ́ átané malɔ mako ayi Judiya ne Jɛrosalɛ ne malɔ Tiya ne Sidɔn ayi álú mbále ɛbɛɛ́ mega. ");
INSERT INTO anvNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Ábɔ́ áchwɔ́ mánwú nkane Jisɔs álɛ́rege ne nnó ápyɛ mamée bwɔ́ ábyɛ́. Bɔɔ́ bí áló nchyɛ áchyɛ́ge ɛbwɔ́ ɛfwyale áchwɔ́ ntó, ne Jisɔs apyɛ ɛbwɔ́ átoó. ");
INSERT INTO anvNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Wyɛ́mbɔ ne gejamégé bɔɔ́ geŋmɛ́regé atɛ manjyɛ tá Jisɔs gétúgé uto bí útánege ji menyamyɛ úpyɛ́ bɔɔ́ mamée ako átóoge. ");
INSERT INTO anvNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Né gébé gefɔ́ Jisɔs apɛ baá utɔɔ́ bií dómeé aké: “Méjé ɛ́lú ne ɛnyú bí délú gekpo, néndé *Gefwa ɛyigé Ɛsɔwɔ ágbárege gelú ɛyigé nyú. ");
INSERT INTO anvNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Méjé ɛ́lú ne ɛnyú bí mesa ámyɛ́ nyú nana, denyɛ nyɛ́ menyɛɛ́ degbeé. Méjé ɛ́lú ne ɛnyú bí delíle mbɔ náná, ɛnyú dejwane nyɛ. ");
INSERT INTO anvNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","“Méjé ɛlu ne ɛnyú mbɔgé dekwɔlege Maá Ntɛ Mekwaá, ne bɔɔ́ aké ápáa ɛnyú, áfwéne ɛnyú, áshyɛ nyú ne ákúu nyú mabɔ mabomabo. ");
INSERT INTO anvNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Bɛ́ge ne nechɔ́chɔ́ gébégé gefɔɔ́ genó ɛyígé ná gépyɛgé, gétúgé Ɛsɔwɔ akwyɛ́ mɛ́ gekpɛ́kpɛ́gé nsá nyú alu né mfaánebuú. Kaáge nnó wyɛ́mbɔ ne ukwéne antɛ bɔɔ́ bína áfwyalé nyá ukwéne bɔɔ́ ɛkpávé Ɛsɔwɔ. ");
INSERT INTO anvNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“Yɛ́mbɔ utóŋkwa úlú ne ɛnyú bi delú mbɔ né gefwa nana, néndé débɔ́ mɛ́ nsá nyú. ");
INSERT INTO anvNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Utóŋkwa úlú ne ɛnyú bí dényɛɛ́ dégbéege náná, néndé debɛɛ́ nyɛ́ mesa. Utóŋkwa úlú ne ɛnyú bí déjwáne náná, néndé delile nyɛ́ né masómé. ");
INSERT INTO anvNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","“Utóŋkwa úlú ne ɛnyú gébégé bɔɔ́ ako áké áfɛɛ́ge ɛnyú, wyɛ́mbɔ ntó ne antɛ bwɔ́ abi mbɛ ábɔ́ ápyɛ ne bɔɔ́ ɛkpávé Ɛsɔwɔ abi gebyɔ́. ");
INSERT INTO anvNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Yɛ́mbɔ ɛnyú bí déwúu mekomejɔɔ́ wa ngarege ɛnyú nnó, bɔ́gé gejeé ne bɔɔ́ mawámé nyú, pyɛ́ge galɔ́gálɔ́ ne bɔɔ́ bí ápáa ɛnyú. ");
INSERT INTO anvNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Yɛndégébé bɔɔ́ álwɛrégé ɛnyú, nɛ́gemmyɛ nnó Ɛsɔwɔ agɛ́ ɛbwɔ́ meshwɛ ájé bwɔ́, máge dénɛ́nemmyɛ mbaá Ɛsɔwɔ gétúgé bɔɔ́ bí áshyɛ́ ɛnyú. ");
INSERT INTO anvNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Mbɔgé muú adogé wɔ neka né ɛtá ɛ́ma, bwɔ́lé ɛwé fɔ ntó ádo. Mbɔgé ɔfyɛgé bɔ nkú apeá né mmyɛ ne muú afɔɔ́gé ayi mfaá, kpɛ chyɛ́ ji ayi nteé. ");
INSERT INTO anvNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Muú akɔgé wɔ genó, chyɛɛ́ ji. Afɔɔ́gé genó jyɛ, ɔsɛgé sé géjí. ");
INSERT INTO anvNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Pyɛ́gé ɛtá bɔɔ́ wyɛ́ genó ɛyígé dekɛ́lege nnó ápyɛ ɛta nyú. ");
INSERT INTO anvNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Mbɔgé ɛnyú degboó lé ne bɔɔ́ abi ágboó ne ɛnyú ndé nsá ayi ɛnyú debɔɔ́? Yɛ bɔɔ́ abi ápyɛɛ́ gabo, ágboó ne bɔɔ́ bi ágboó ne ɛbwɔ́. ");
INSERT INTO anvNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Ne mbɔgé ɛnyú depyɛ ɛ́lé galɔ́gálɔ́ ne bɔɔ́ bí apyɛ́ galɔ́gálɔ́ ne ɛnyú nsá nyú alu ɛ́fɔ́? Yɛ́ bɔɔ́ abi ápyɛɛ́ gabo, mbɔntó ne apyɛ́ɛ. ");
INSERT INTO anvNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Mbɔgé depwɔle unó mbaá bɔɔ́ bí dékaá nnó áshúuge nyɛ́ ɛta ɛnyú galɔ́gálɔ́ yi ɛnyú dépyɛ alɛ́? Abi deké álú bɔɔ́ ubeé ápyɛ ntó gefɔɔ́ gémá. Yɛ́ndémuú apwɔle genó ɛtá mejií wuú, akaáge nnó ashuge nyɛ́ geko. ");
INSERT INTO anvNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Genó ɛyigé débɔɔ́ mampyɛ gélú nnó gbógé ne bɔɔ́ mawámé ɛnyú ne pyɛ́ge galɔ́gálɔ́ ne ɛbwɔ́, depwɔ́ge ɛbwɔ́ ɛpwɔ, dégigé nnó áshuú. Debɔɔ́ nyɛ́ gekpɛ́kpɛ́gé nsá ne debɛɛ́ nyɛ baá Anyátá Ɛsɔwɔ. Néndé alɔme ne bɔɔ́ ubée ne abi álá támégé ji. ");
INSERT INTO anvNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Gɛ́ge bɔɔ́ meshwɛ wyɛ́ ndɛre Ntɛ nyú Ɛsɔwɔ agɛ́ne nyú meshwɛ. ");
INSERT INTO anvNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Dépagé mpa muú ne ufyá ɛ́kagé Ɛsɔwɔ ápá ntó awu nyú mbɔ. Déchɔge muú mabɔ nnó apyɛ ubée ɛ́kagé Ɛsɔwɔ áchɔ́ ntó ami nyú. Jiíge nte gabo ayi bɔɔ́ ápyɛ́ ɛta nyú nnó Ɛsɔwɔ ajií ntó nte gabo awu nyú. ");
INSERT INTO anvNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Chyɛ́ge bɔɔ́ genó ɛyigé ɛbwɔ́ akɛ́lege, Ɛsɔwɔ achyɛ́ge nyɛ ntó ɛnyú. Yɛ́ndégébé aké achyɛgé, amɛge chánchá, akwyɛge aŋmɛrege nnó gégbeé gégbɛ́légé mme. Gefɔɔ́ ɛyígé démɛge genó déchyɛ́ge muú, mbɔntó ne ámɛge nyɛ áchyɛɛ́ ɛnyú.” ");
INSERT INTO anvNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Jisɔs ama tó ɛbwɔ́ neka nnó, “Ɛpɔfɔ kɔkɔge nnó muú amɛ nónómé ájáa ntɛ ayifɔ meti. Mbɔgé apyɛ́gé mbɔ, ɛbwɔ́ ako ákwéne mmu gepyɛɛ́. ");
INSERT INTO anvNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Kaáge nnó maá ŋwɛ akaágé fɔ́ ŋwɛ ápwɔ́ menlɛré wuú. Yɛ́mbɔ, gébégé aneregé mángií ŋwɛ, abɛɛ́ nyɛ́ ntó ndɛre ménlɛré wuú. ");
INSERT INTO anvNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Ulannó ɔ́chɛ́rege ɛkɛ́kɛ́ gabo ayi alu ɛke maá gejwaá né dambɔɔ́nnyi ntɛ meŋmɛ́ wyɛ́ ɔla ɔfyɛɛ́ mekpo né gabo ayi alu ɛke mekwɔkwɔ né dambɔɔ́nnyi awyɛ wɔ mbɔɔ́? ");
INSERT INTO anvNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Ɛ́pyɛmbɔ nnó ne ɔjɔɔ́ ne meŋmɛ́ wyɛ́ nnó, ‘Té mmyɛ we mfére wɔ gejwaá né dambɔɔ́nnyi ayi ɔla kaágé nnó mekwɔkwɔ ɛlú né dambɔɔ́nnyi wyɛ́.’ Wɔ muú dembwɔ́lé bɔ́ mbɛ féré ntó mekwɔkwɔ ɛwé ɛlú wɔ né dambɔɔ́nnyi, ne ɔkaá nkane ɔférége ɛkɛ́kɛ́ gejwaá ɛyigé lú meŋmɛ́ wyɛ né dambɔɔ́nnyi.” ");
INSERT INTO anvNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Jisɔs ama jɔɔ aké, “Genɔɔ́ yí gelɔ́gelɔ́ géwɔ́mé fɔ́ umpomé uboubo ne ɛyí gebogebo ntó géwɔ́mé fɔ́ umpomé ulɔ́úlɔ́. ");
INSERT INTO anvNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Yɛ́ndémuú akaágé genɔɔ́ né umpóme bí géjí géwɔ́me, muú ajyɛ fɔ́ ákyɛ́ genchɔ́gélé ɛyigé mbɔ́ mfaá genchɔ́gélé denywɔné. Muú ajyɛ fɔ́ né nepe ákyɛ́ ɛ́kɛ́. ");
INSERT INTO anvNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Muú melɔ́mélɔ́ ájɔgé depɔ delɔ́délɔ́ ɛti délú ji né metɔɔ́, muú mebomebo ájɔgé depɔ debodebo ɛti délú ji metɔɔ́. Ná ne ɛlú gétúgé genó ɛyi gélú muú né metɔɔ́ géjí ne gétánege ji meno.” ");
INSERT INTO anvNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Jisɔs ama gií aké, “Ulannó ɛnyú dekuú me Ata Ata! ne dela dépyɛ́ genó ɛyígé me njɔɔ́ge. ");
INSERT INTO anvNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Muú yi achwɔ́ awúu mekomejɔɔ́ wa ne ajyɛgé ápyɛɛ́ ndɛre ájɔɔ́, ");
INSERT INTO anvNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","muú yimbɔ alu ɛké mende yi álɔɔ́ mantɛné gepú jií, ne abɔ mbɛ achó mme, afyɛ́ mataá chánchá ne ale tɛ́né géjí. Meso gébé geneágé nnyi géchwɔgé mammu géjí yɛ́mbɔ genyígé fɔ́ gétúgé átɛ́né géjí chánchá. ");
INSERT INTO anvNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Yɛ́mbɔ muú yi awuú mekomejɔɔ́ wa ne álá pyɛɛ́ ndɛre ákɛ́lege alu ɛké muú ayi atɛné gepú jií né nébɔ́me ɛniné álá cho áfyɛ́ mataá wɔ́. Meso gébé nnyi negbeégé né mmu gepú ɛyigémbɔ gékwé mme gbang.” ");
INSERT INTO anvNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Jisɔs aneré manlɛ́régé bɔɔ́ unó bimbɔ ne atané afɛ́ né melɔ́ Kapanɔm. ");
INSERT INTO anvNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Muú kpaa bɔɔ́ bee *Rom fɔ́ abɔ́ alu né melɔ wémbɔ ne abɔ́ awya maá defwɛ́ ayi agbo ne ji dɔɔ́. Maá defwɛ́ yimbɔ akwé nemé ala mangbómangbó ");
INSERT INTO anvNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Mende yimbɔ awúgé abya Jisɔs, atɔ́ ákpakpa bɔɔ́ Jus nnó ájyɛ́ ákuú ji áchwɔ́ ápyɛɛ́ maá defwɛ́ wuú átoó. ");
INSERT INTO anvNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Ájyɛ́gé, ágɛ́ Jisɔs ákwé ji uká áké, “Atá chó poó muú kpaá yimbɔ. Alu muú yi ɔ́kage *pó ji. ");
INSERT INTO anvNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Agboó ne ɛsé bɔɔ́ Jus dɔɔ́ tɛ atɛné ɛsé ɛcha mmyɛmenɛne.” ");
INSERT INTO anvNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Ɛbwɔ́ ájɔ́gé mbɔ Jisɔs afɛ́ ne ɛbwɔ́. Ndɛre álɛ́ kwɔ́kwɔ́lé ne dachi muú kpaá yimbɔ, atɔ́ ajeé bií bichá ájyɛ́gé átuú ne Jisɔs áké, “Muú kpaá aké dégáré wɔ́ nnó, ‘Ata, ɔ́wagé mmyɛ jyɛ́ detú mánkwɔné gepú ya, nfu yɛɛ́ muú fɔ́ ayi ɔ́kpɛ́ne gepú ɛyá wɔ́.’ ");
INSERT INTO anvNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Gɛ́ ula úbí jimbɔɔ́ alá chwɔ báne wɔ wɔ́. ‘Wɔ jɔɔ́ lé genó, ne maá defwɛ́ wuú átoó.’ ");
INSERT INTO anvNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Ɛlé mentó nwya bɔɔ́ kpakpa né mbɛ, abi me nwuú ne ɛbwɔ́. Ájɔɔ́gé ne me nnó, ‘Mpyɛ genó ɛyi’, mpyɛ. Ne nwya ntó bɔɔ́ bee abi áwúu ne me. Yɛ́ ayi ndé ne njɔɔ́ge ne ji nnó, ‘Chó fa ajyɛ, njɔɔ́gé ne ayimbɔ nnó chwɔ́ we, achwɔ́.’ Ne njɔɔ́gé ntó ne maá defwɛ́ wa nnó pyɛ ɛyi, apyɛɛ́ géji.” ");
INSERT INTO anvNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Jisɔs awúgé mbɔ, akwé dembyɔ́, abwɔlé ushu mbaá ɛkwɔ́ bɔɔ́ bi ákwɔlege ji aké, “Ngarege nyú nnó me nlú daŋgɛ́ muú yi áfyɛɛ́ metɔɔ́ ne me na, yɛɛ́ ɛ́bɛ́lé né Isrɛli.” ");
INSERT INTO anvNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Ajeé muú kpaá yimbɔ abi ji atɔ́mé, aké akérege meso mmú gepú ágɛ́ nnó maá defwɛ́ mende yimbɔ atoó. ");
INSERT INTO anvNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Mechɔ́ ɛwémbɔ ɛ́kógé, Jisɔs ne baá utɔɔ́ bií álɔ mánjyɛ né melɔ ɛwé ákúu Nɛn. Ne gejamége bɔ́ ntó abɔ́ akwɔ́lege ji. ");
INSERT INTO anvNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Áfɛ́, áké ákwɔ́nege mekpó meti, ágɛ́ ndɛre bɔɔ́ fɔ́ ákpané mewu muú ájyɛ́ níi. Mende yi agboó mbɔ, mmá wuú abɔ́ abyɛ lé ji mbií. Ne mmá yimbɔ alu mekwi mendée. Ndɛre ɛbwɔ́ ajyɛ mbɔ, gejamégé bɔɔ́ né melɔ ɛwémbɔ ákwɔlege mekwí mendée yimbɔ. ");
INSERT INTO anvNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Atá Jisɔs agɛ́gé mendée yimbɔ́ meshwɛ akwɔ́ ji metɔɔ́ tɛ ajɔɔ́ ne ji ake, mma “Ɔ́ligé se.” ");
INSERT INTO anvNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Ajɔgé mbɔ, aŋme uká afɛ́ mbɛ, atágé ulɔ́, bɔɔ́ abi ákpané genkwɔ́gé muú ɛyigémbɔ átɛne. Jisɔs aké, “Gesagé muú ngaré wɔ́ nnó kwilé ka.” ");
INSERT INTO anvNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Mende yi agboó mbɔ, akwilé ka alɔ manjɔɔ́ mejɔɔ́. Jisɔs agbaré ji achyɛ́ mbaá mma wuú. ");
INSERT INTO anvNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Bɔɔ́ ako ágɛ́gé na, ɛfɔ́ ɛ́kwɔ́ bwɔ́ matɔɔ́. Álɔ manfɛɛ́ Ɛsɔwɔ áké, “Gekpɛ́kpɛ́gé *Muú Ɛkpávé Ɛsɔwɔ achwɔ́ mámbɛ́ ne ɛsé. Ɛsɔwɔ achwɔ́ póo bɔɔ́ bií.” ");
INSERT INTO anvNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Abya mechɔ́ ɛwé Jisɔs apyɛ́ na afɛ́ né malɔ́ bɔɔ́ Jus mako ne máta malɔ ayifɔ. ");
INSERT INTO anvNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Baá utɔɔ́ Jɔn ntó áwuú depɔ ɛtiré na deko ne ále garé ji. ");
INSERT INTO anvNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Ágárégé mbɔ, Jɔn aferé ɛbwɔ́ makpó apeá atɔ́ mbaá Atá Jisɔs nnó ájyɛ́ gií ji nnó, “Ɔlu *Ménkwɔlé Gewu ayi abɔ́ alú manchwɔ́ wá ɛsé dégilé ayichá?” ");
INSERT INTO anvNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Ájyɛ́gé ágɛ́ Jisɔs áké, “*Jɔn menwyaá bɔɔ́ manaá Ɛsɔwɔ atɔ́ ɛsé né ɛta wyɛ́ nnó déchwɔ́ dégií wɔ nnó, ‘Ɔlu Ménkwɔlé Gewu ayi abɔ́ alú manchwɔ́ wá ɛsé dégilé ayichá?’” ");
INSERT INTO anvNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Wyɛ́ né gébé ɛyigémbɔ, Jisɔs abɔ́ apóge bɔɔ́ mamée mámpyɛ́ mamée bwɔ́ ábyɛ́. Aferege ntó áló nchyɛ abi áchyɛge bɔɔ́ ɛfwyale ne apyɛ bɔɔ́ amɛ nónómé ágɛ́ne. ");
INSERT INTO anvNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Ɛfɛɛ́ ne ashuú baá dentɔɔ́ bimbɔ meko aké, “Choge dégare Jɔn unó bi ɛnyú déwuú bɔɔ́ ájɔge ne ɛbi ɛnyú ambɔɔ́ dékpané amɛ dégɛne. Bɔɔ́ amɛ nónómé ágɛ́ne, ubwéré ukwilé úkɛ́ne, bɔɔ́ abi ámeé ubá átoó, bɔɔ́ matu gbɛ́ gbɛ́ álɔ manwúgé, abi ágboó ápeé, ne ubyá bɔɔ́ úwú abya melɔ́mélɔ́. ");
INSERT INTO anvNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Metɔɔ́ megɔmegɔ ɛ́bɛ́ ne muú yi álá pɔ́ ne dembyɔ́ né metɔɔ́ gétú yá.” ");
INSERT INTO anvNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Baá dentɔɔ́ Jɔn ákérégé meso, Jisɔs alɔ mángare bɔɔ́ depɔ tiré Jɔn, ake, “Tégé gébégé ɛnyú déjyɛ nya né mashwɔne, defɛ mangɛ ndé gefɔgé muú? Déjyɛ gɛ́ le muú ayi alú ɛké mancha ami afofo akpáne áténe ɛgbɛ ɛwe ne ɛwe? ");
INSERT INTO anvNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Mbɔ́ge mbɔ fɔ́ wɔ́, defɛré nnó dejyɛ́ gɛ́ ndé gefɔɔ́gé muú? Défɛ́ manjyɛ gɛ muú ayi afyɛ mandeé malɔ́málɔ́ yɛndégébé ápyɛ́ gesa? Bɔɔ́ bi áfyɛ́ mandeé malɔ́málɔ́ ne ányɛɛ́ geŋwá, ájwɔ́lege né dachi afwa. ");
INSERT INTO anvNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Gárege me, ɛnyú défɛ́ yɛ́ ɛ́wú mánjyɛ gɛ́ waá? Ɛlé muú ɛkpávé Ɛsɔwɔ? Ɛh, gɛ́ muú yi ɛnyú dégɛné mbɔ. Ngare ɛnyú wáwálé nnó aŋeá gemɛ apwɔ yɛ́ndémuú ɛkpávé Ɛsɔwɔ. ");
INSERT INTO anvNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Ɛ́lé Jɔn yina ne abɔ́ ásamé gétú jií nnó Ɛsɔwɔ aké, ‘Wuúgé, ntɔme nyɛ́ muú dentɔɔ́ wa ayi abɔ́ nyɛ́ mbɛ ne wɔ manchwɔ kwyɛ́ meti wyɛ ne ɔchwɔ́gé.’ ");
INSERT INTO anvNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Jisɔs ama jɔɔ́ aké, Jɔn aŋeá gemɛ apwɔ yɛ́ndémuú yi mendée ábyɛné ji fá mme. Yɛ́mbɔ Jɔn agɛ́ lé *ugɛ́né ámɛ́, ne muú ayi mejé gefwage Ɛsɔwɔ ɛ́lɔɔ́ ne ji, yɛ alu kɔɔ́ apwɔ ji Jɔn.” ");
INSERT INTO anvNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Bɔɔ́ áwúgé mechɔ́ ɛwéná ákamé nnó, depɔ tiré Ɛsɔwɔ abɔ́ akwyɛ́ na delú cho, gejamégé bɔ́ bina abifɔ alu ansɛlé ŋkámakpo. Akamé wyɛ́mbɔ, gétúgé ábɔ́ ákamé depɔ tiré Jɔn ajɔɔ́, ne alé wyaá ɛbwɔ́ manaá Ɛsɔ́wɔ. ");
INSERT INTO anvNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Yɛ́mbɔ bɔɔ́ Farasi ne Ánlɛré mabɛ́ Ɛsɔwɔ né matɔɔ́ bwɔ́ áma áshyá wyɛ́ shyá depɔ tiré Ɛsɔ́wɔ akwyɛ. Ɛbwɔ́ áshya mbɔ, ɛ́lé ábɔ́ áshyá ntó nnó Jɔn awyágé fɔ ɛbwɔ́ manaá Ɛsɔwɔ. ");
INSERT INTO anvNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Jisɔs awyágé agií gemɛ jií aké, “Mmɛge na bɔɔ́ njyɛ ɛnina ne ndé? Álú mbɔ nnó? ");
INSERT INTO anvNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Agígé mbɔ aké, álú ɛké ambáné bi álú né metɔɔ́ melɔ ápyɛ metu, ákuú átɛ, áké: ‘Ɛ́sé dékwe ɛnyú ubeé neba nnó débé, déshya mambé, Ɛsé dékwa makwaá negbo nnó deli déshya manlí.’ ");
INSERT INTO anvNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Wyɛ́mbɔ ne ɛnyú depyɛ ntó. Jɔn menwyaá bɔɔ́ manaá Ɛsɔwɔ, abɔ́ achwɔ́ ajwɔlé mesa, anyuú mmɔɔ́ wɔ́, ne deshyɛ ji deké, ‘Awyaá meló nchyɛ.’ ");
INSERT INTO anvNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Me *Maá Ntɛ Mekwaá nchwɔ́ nnyɛ menyɛɛ́, nnyu mmɔɔ́ deshyɛ me ntó deké, ‘Nlú muú geŋɔ ne menyuú mmɔɔ́, ne dékií me deké me nlu mejeé ánsɛlé ŋkámakpo ne “Bɔɔ́ ubeé”.’ ");
INSERT INTO anvNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Yɛ́mbɔ ákaágé nnó deŋgaré Ɛsɔwɔ ɛtiré muú áwyaá delu cho né unó ulɔ́úlɔ́ ɛbi ji ápyɛɛ́.” ");
INSERT INTO anvNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Né gébé gefɔ́ muú Farasi akuú Jisɔs nnó ajyɛ ányɛ́ menyɛɛ́ né gepú jií. Jisɔs akamé ajyɛ nyɛ́ menyɛɛ́ ne ji. ");
INSERT INTO anvNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Mendée fɔ abɔ́ alu né melɔ wémbɔ, bɔɔ́ akií ji gétúgé ányɛɛ́ ɛno. Awúgé nnó Jisɔs anyɛɛ́ menyɛɛ́ né gepúgé mende Farasi, abɔ́ maá ɛkpómé lamɛ́nda afɛ́ ne ji ɛfɛɛ́. ");
INSERT INTO anvNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Akpɛ́gé mmu gepú atɛné né nénkúné mmyɛ Jisɔs, mmyɛ́ ɛ́gbó ji, alɔ manli, mánsé áshúlege áchyɛ́ɛge né uká Jisɔs. Ɛfɛɛ́ ne amoó mekpo mme atile uká Jisɔs ne méjwɛ́ wuú, anywalé ubí ne alé awaá lamɛ́nda yimbɔ wyɛ́. ");
INSERT INTO anvNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Mende Farasi ayi akuú Jisɔs né gepú jií, agɛ́gé mbɔ, ajɔɔ́ né metɔɔ́ wuú aké, “Mbɔgé Jisɔs ábɔ́ ábɛ́ *Muú Ɛkpávé Ɛsɔwɔ wáwálé mbɔ́ abɔ́ akaá gefɔgé mendée yi atáa mbɔ ji nnó alu mendée ɛno.” ");
INSERT INTO anvNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Tɛ́nétɛ́né Jisɔs akuú mende Farasi yimbɔ aké, “Simun nwya mechɔ́ mangaré wɔ.” Aké “Ɛ ɛ́” “Ménlɛré” “gáré me.” ");
INSERT INTO anvNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Ɛ́fɛɛ́ Jisɔs alɔ mangaré abya nnó, “Gébé gefɔ́ nyá mende fɔ apwɔ bɔɔ́ ápeá ŋka. Apwɔ ama uba ŋka útá, ayifɔ mboó géba. ");
INSERT INTO anvNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Aka mánsɛ ŋka jií meti ɛ́pɔ́, agɛgé nnó ujwɔɔ́ bi na úpwɔ ɛbwɔ́ mankwɔ, ajinte ɛbwɔ́ ako. Jisɔs agárégé mbɔ agií, Simun ake, né umɛɛ́ byɛ́ ɛbwɔ́ bina makpó apeá, ayindé agbóo nyɛ́ ne mbɔɔ́ ujwɔɔ́ dɔ́ɔ?” ");
INSERT INTO anvNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Ashuú ji meko aké, “Ɛ́lé muú yi abɔ́ ájinte ujwɔɔ́ bií dɔ́ɔ.” Jisɔs aké, “Ɔjɔɔ́ cho.” ");
INSERT INTO anvNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Jisɔs abwɔlé ushu apɛ mendée yimbɔ ne ama kuú Simun aké, “Pɛ mendée yiná gɛ́! Tɛ mekoó nkpɛné fá gepú jyɛ, ɔchyɛ́ me manaá nnó nshwɔ́ne uká bá wɔ́. Yɛ́mbɔ, mendée yina ashwɔné uká ba ne mánsé jií, ne ati úbí ne méjwɛ́ wuú. ");
INSERT INTO anvNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Ɔtamé fɔ́ me ɔkpá ɔtya wɔ́. Yɛ́mbɔ tɛ mekoó nkpɛné fá, mendée yi alú danlya mánywálé me uká. ");
INSERT INTO anvNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ɔwaá me yɛ maweé amma né mekpo wɔ́. Yɛ́mbɔ mendée yina awaá me lamɛ́nda né uká ba. ");
INSERT INTO anvNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Kaá nnó mendée yina alɛré mbɔ gekpɛ́kpɛ́gé gejee ɛyigé na, Ɛsɔwɔ ajiínte gejamége gabo ayi abɔ́ apyɛ́. Yɛ́mbɔ, muú yi afɛré nnó Ɛsɔwɔ abɔ́ manjinte gabo ayi ji apyɛ dachyɛ, mbɔntó ne alɛrégé gejeé ne Ɛsɔwɔ dachyɛ.” ");
INSERT INTO anvNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Wyɛ́ ɛ́fɛɛ́ Jisɔs ajɔɔ́ ne mendée yimbɔ aké, “Ájiínte *gabo wyɛ́.” ");
INSERT INTO anvNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Bɔɔ́ bi abɔ́ ányɛ́ɛ menyɛɛ́ ne ji ɛ́fɛɛ́ álɔ máŋmené nnó, “Mende yina afɛré nnó alu ndé gefɔgé muú, ayi akáge jɔ́ɔ nnó ji ajiínte gabo muú?” ");
INSERT INTO anvNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Ɛ́fɛɛ́ Jisɔs ama ŋmɛ́ré aké ne mendée yimbɔ, “Chó chánchá, Ɛsɔwɔ apoó wɔ́ gétúgé ɔfyɛɛ́ metɔɔ́ wyɛ́ ne me.” ");
INSERT INTO anvNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Ɛbɛlé yɛ wɔ́, Jisɔs ne baá utɔɔ́ bií makpó áfyanéápeá álɔ mánkɛ́né né malɔ ayi kɔkɔɔ́ ne ayi kpakpa. Ágárege abya Ɛsɔwɔ melɔ́mélɔ́ nkane gefwage Ɛsɔwɔ gélú. ");
INSERT INTO anvNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Andée fɔ́ ntó áfɛ́ ne ɛbwɔ́, ɛbwɔ́ abɔ́ álú andée bi Jisɔs apyɛ mamée bwɔ́ ábyɛ́. Abifɔ abú aló nchyɛ abi áchyɛgé ɛbwɔ́ ɛfwyale. Ama akamege *Mɛri ayi atané melɔ́ Magdala ayi Jisɔs ábuú aló nchyɛ ákénéneama. ");
INSERT INTO anvNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Ayifɔ akámége Joana mendée Chusa ayi alú mammyɛ dentɔɔ́ mfwa Hɛrɔd. Ayifɔ Susana, ne gejamégé andée bifɔ́ ntó. Andée bina ako ápoóge Jisɔs ne baá utɔɔ́ bií ne máŋka bwɔ́. ");
INSERT INTO anvNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Ndɛre Jisɔs ákɛ́ne mbɔ, bɔɔ́ átánege malɔ́málɔ́ áchwɔ́ gɛ́ ji. Gejamégé bɔɔ́ géchómégé, alɔ mangaré ɛbwɔ́ nekanémejɔɔ́ ɛni. ");
INSERT INTO anvNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","Nébɔ́ nélú nnó, “Bií uma mempyɛ makɔɔ́ fɔ afɛ́ manjyɛ tya mbwɛ́ né mekɔɔ́ wuú, ndɛre átyaá, ámɛ́ ayifɔ́ ákwé né maá meti. Ɛwyágé bɔɔ́ ákógé ájyále, ne denywɔné ntó déchwɔ́ dechwɛ́re denyɛɛ́. ");
INSERT INTO anvNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Ámɛ́ ayifɔ́ ákwé né mfaá mme ɛtárávɛ́ áchií ne ɛwyá wɔ́ áwaŋgésé getúgé mbaá yimbɔ alú kpɔ́gɔ́lɔ́. ");
INSERT INTO anvNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Ámɛ́ ayifɔ́ ákwé né mme ayi genkpé ntó géchíge wyɛ, áchígé, genkpé ɛyigémbɔ géwɛ́ gekweré mbwɛ́ yimbɔ meshií ɛjo ji. ");
INSERT INTO anvNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Ámɛ́ ayifɔ́ ákwé né mme melɔ́mélɔ́, áchiígé, áwɛ́, áfyɛ́ úsaá amɛ uta ápwɔ nkane ábɔ́ ápɛ́né.” Jisɔs ánérégé ake, “Fwɔregé! Muú yi áwyaá matu manwú, áwú.” ");
INSERT INTO anvNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Ɛwyágé baá utɔɔ́ Jisɔs ágií ji ula nekanémejɔɔ́ ɛníné abɔ́ atómé mbɔ. ");
INSERT INTO anvNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Ake ne ɛbwɔ́, “Ɛ́lé ɛnyú ne Ɛsɔwɔ apyɛ́ nnó dékaá unó bi. Yɛ́mbɔ bɔɔ́ bifɔ áwúu gefwa jií ɛyi gébɔ́ gélú nyá bibí né mákámejɔɔ́ jií. Ɛsɔwɔ apyɛ wyɛmbɔ nnó ɛ́bɛ́ nkane abɔ́ ásámé nyá mmu bɔ ŋwɛ nnó: ‘Ápɛ́le ágɛ́né fɔ́, áwúu ákaágé fɔ́ ula’.” ");
INSERT INTO anvNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Ake, “ula nekanémejɔɔ́ ɛniné na nelú nnó, mbwɛ́ yimbɔ ɛ́lé mekomejɔɔ́ Ɛsɔwɔ. ");
INSERT INTO anvNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Amɛ́ mbwɛ́ ayi ákwéne meti álú bɔɔ́ bi áwúu mekomejɔɔ́ Ɛsɔwɔ, ɛwyágé danchɔmeló achwɔ́ féré mekomejɔɔ́ yimbɔ né matɔɔ́ bwɔ́ nnó ɛkáge ɛbwɔ́ ákámé ne Ɛsɔwɔ aferé ɛbwɔ́ né ɛfwyale gabo. ");
INSERT INTO anvNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Amɛ́ mbwɛ́ ayi ákwené né mfaá mme ɛtárávɛ́ álú bɔɔ́ bi áwúgé mekomejɔɔ́ Ɛsɔwɔ, tɛ́nétɛ́né ásɛ ji ne nechɔ́chɔ́. Yɛ́mbɔ álya fɔ́ nnó mekomejɔɔ́ Ɛsɔwɔ akpɛ́ mmu matɔɔ́ bwɔ́ wɔ́. Mekomejɔɔ́ Ɛsɔwɔ yimbɔ alu ɛta bwɔ́ ɛké genɔɔ́ ɛyi gélá gepɔ́ ne maka. Gébégé mmuameno achwɔgé gétúgé mekomejɔɔ́ Ɛsɔwɔ, ájá mmyɛ meso. ");
INSERT INTO anvNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Ne mbwɛ́ ayi ákwené né mme genkpé meshií ɛjomé, álu nkane bɔɔ́ abi áwuúgé mekomejɔɔ́ Ɛsɔwɔ, ufɛ́ré unó mme ne mmwɔ́lé né unó bi uchwɔɔ́ ne gefwa ujo mekomejɔɔ́ yimbɔ. Mbɔntó ne mekomejɔɔ́ Ɛsɔwɔ anómé mmu matɔɔ́ bwɔ́ detú. ");
INSERT INTO anvNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Amɛ́ mbwɛ́ ayi ákwené mme melɔ́mélɔ́ álú ntó ɛké bɔɔ́ bi áwuú mekomejɔɔ́ Ɛsɔwɔ, ágbáré ji metɔɔ́ ɛ́má ne ápyɛ́ genó ɛyigé mekomejɔɔ́ ágaré, ne ájyɛ́ wyɛ́ mbɛmbɛ. ");
INSERT INTO anvNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Muú álwɛ́gé fɔ́ ɛ́túléká ne abɔ́ genó akwéré ɛ́wú. Akágé bɔ́ ntó ɛwú afyɛ́ nteé ukwɔ́. Yɛndegébé muú alwɛ́gé ɛ́túléká, aŋma ɛwú mfaá, nnó, bɔɔ́ ákpɛgé mmu gepú ágɛ́né mbaá. ");
INSERT INTO anvNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Kaáge nnó depɔ deko ɛtiré débɔ́ délú bibí, dégɛnege nyɛ́ ne ɛtiré délú né gemmua déchwɔ́ nyɛ́ né geŋgbɔ́. ");
INSERT INTO anvNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Yɛndé gébé ayi ɛnyú dewuúgé mekomejɔɔ́ Ɛsɔwɔ, fwɔ́rege chánchá nnó dekaá depɔ ɛtiré delú mmu. Kaáge nnó muú yi awya genó, ámáge gbɛ́ɛ nyɛ́ ji ɛyigéfɔ. Muú yi álá pɔ́ ne geji, ásɛ́le nyɛ́ yɛ ɛ́kɛ́kɛ́ ɛwé ji awya nnó akpɛ́ alá amuamu.” ");
INSERT INTO anvNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Ndɛre Jisɔs abɔ́ álú alɛrege mbɔ, mmá wuú ne aŋmó bií áchwɔ́ mangɛ́ ji. Yɛ́mbɔ áka mankpɛ meti ɛpɔ́ gétúgé bɔɔ́ ájamé dɔɔ́ né menómbí. ");
INSERT INTO anvNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Muú fɔ́ agare ji nnó, “Mmá wyɛ́ ne aŋmó byɛɛ́ álú dafyɛ ákɛ́lege mangɛ́ wɔ́.” ");
INSERT INTO anvNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Jisɔs agáré ɛbwɔ́ aké, “Mmá wa ne aŋmó ba ɛ́lɛ́ bɔɔ́ abi áwúu mekomejɔɔ́ Ɛsɔwɔ ne ápyɛ genó ɛyigé mekomejɔɔ́ yimbɔ ákɛ́lege.” ");
INSERT INTO anvNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Bií bifɔ́ Jisɔs ákpɛ mmu ɛ́kpe ne baá utɔɔ́ bií, ne ájɔɔ́ ne ɛbwɔ́ aké, “Déchyaá gentógé mewaá dejyɛ́ ɛgbɛ́ né.” Ɛfɛɛ́ ɛbwɔ́ álɔ manjyɛge. ");
INSERT INTO anvNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Ndɛre ɛbwɔ́ áchyaáge, Jisɔs akwé gejyá. Mbyonnyi átáné wyɛ mbɛ́lépó né mfaá achwɔ́ ne ɛshyɛ né gentógé mewaá, apyɛ mbyo nnyi ado ɛ́kpe, manaá malɔ mánkpɛ mmu. Manɛ magyálege ɛbwɔ́ nnó áchwɔ́ kée. ");
INSERT INTO anvNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Ne ɛbwɔ́ ájyɛ peé ji áké, “Atá, Atá déchwɔ́ nó nnyi.” Jisɔs akwilé ka anyá mbyo nnyi yimbɔ akwené, mbaá akwené tɔmeé. ");
INSERT INTO anvNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Ɛwyágé Jisɔs agií bwɔ́ aké, “Matɔɔ́ nyú ayí défyɛɛ́ ne me álɛ́?” Yɛ́mbɔ ɛfɔ ɛ́wú ɛ́wú ne ɛlaá ɛbwɔ́ matɔɔ́ ne ála mano mekpo fuú, ágíge atɛ áké, “Ndé gefɔgé muú na ayi anyagé mbyo ne ngba nnyi áwuú ji?” ");
INSERT INTO anvNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Áké ánérege manchyá gentógé mewaá, ákwɔné gebagé mewaá Garɛsɛne ɛyí gélú toitoi né *gebagé mewaá Galilií. ");
INSERT INTO anvNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Jisɔs aké atanege né ɛ́kpe, akwɔne kwɔ́kwɔ́lé né melɔ fɔ́, mende fɔ yi átané melɔ ɛwémbɔ, ayi aló nchyɛ áchyɛ́ge ji ɛfwyale áchwɔ́ báne ji. Tɛ mekoó mende yina abɔ́ álú wyɛ́ gejɔ́géné, alyá upú ne abɛlege lé mmu manome ayi áchomé né ɛtárávɛ́. ");
INSERT INTO anvNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Aké agɛne Jisɔs ajyɛ kwé ji uká, alile akalege kéŋké aké, “Jisɔs Maá Ɛsɔwɔ Anyata! Ɔbɔ́ ndé mechɔ́ ne me? Nkpá wɔ́ geká, ɔ́chyɛgé fɔ́ me ɛfwyale.” ");
INSERT INTO anvNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Ajɔɔ́ mbɔ gétúgé Jisɔs abɔ́ anyane ji nnó, tané mende yina mmyɛ. Mende yina yɛ́ndégébé meló nchyɛ yimbɔ akwilégé ji mmyɛ́, bɔɔ́ áfwénege ji ne ápyɛ. Yɛ́ lé áwɛ́le ji uká ne amu ne bɔ ŋkpɔkɔvɛ́, ábelé ji nkane muú denɔ, asɔrégé abi, meló yimbɔ ápyɛ́ ji abó akpɛ mewaá. ");
INSERT INTO anvNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Ɛ́fɛɛ́ ne Jisɔs agií mende yimbɔ aké, “Mabɔ myɛ makamege nnó?” Ashuú ji meko aké, “Nkamege gejamé.” Ajɔɔ́ mbɔ gétúgé gejamé aló nchyɛ ábɔ́ álú ji mmyɛ. ");
INSERT INTO anvNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Aló nchyɛ bímbɔ ákwɔ Jisɔs mata nnó ɛ́kagé ábú abi akeré mmu gepyɛɛ́ ɛyi geláge pɔ́ ne kwyakwya nnó ágɛ́né ɛfwyale. ");
INSERT INTO anvNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Ɛ́fɛɛ́ kwɔ́kwɔ́lé, nfɔné mekwɛnde fɔ nébɔ́ nényɛɛ́ né mbyɔ mékwɛ. Aló nchyɛ bimbɔ ágɛ́gé nfɔné mekwɛnde ɛniné mbɔ ánɛ Jisɔs mmyɛ nnó agɔ́ bwɔ́ ákpɛ mekwɛnde yimbɔ mmyɛ, Jisɔs akamé. ");
INSERT INTO anvNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Aló nchyɛ bimbɔ átané ájyɛ kpɛ́ nfɔné mekwɛnde ɛníné mbɔ né mmyɛ. Nfɔné mekwɛnde ɛniné mbɔ nésɔɔ́ ne gatɛlé, né shulé mékwɛ nékwé mmu géntógé mewaá né nyú manaá néke. ");
INSERT INTO anvNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Ámbamé mekwɛnde yimbɔ ágɛ́gé ndɛre ɛpyɛɛ́, ábó ákeré meso melɔ bwɔ́, mangaré abya yimbɔ. Ndɛre ájyɛ́, ágaré ntó abya yina né baá malɔ ne bɔ dachi né gebagé mewaá ɛyígémbɔ. ");
INSERT INTO anvNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Bɔɔ́ áwúgé abya yi, áchwɔ mangɛ́ genó ɛyigé gébɔ́ gépyɛ́, ákwɔ́négé mbaá ayi Jisɔs alu, ágɛ́ mende yimbɔ, ayi aló nchyɛ átane ji mmyɛ ne nana ajwɔlé né ɛgbɛ mmyɛ Jisɔs, ne mandeé jií mmyɛ, akéré menyammyɛ wuú. Ɛbwɔ́ ágɛ́gé mbɔ ɛfɔ ɛkwɔ́ ɛbwɔ́ matɔɔ́. ");
INSERT INTO anvNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Bɔɔ́ bí abɔ ágɛné genó ɛyígé pyɛ́ álɔ mangaré abi áchwɔ ndɛre ɛ́pyɛ́gé ne mende yimbɔ alé tóo. ");
INSERT INTO anvNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Bɔɔ́ ako né geba ɛyígémbɔ gétúgé ábɔɔ́ ɛfɔ anɛ́ Jisɔs mmyɛ nnó ályaá melɔ bwɔ́. Ájɔ́gé mbɔ, Jisɔs akpɛ mmu ɛkpé manjyɛ. ");
INSERT INTO anvNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Jisɔs ákwilégé manjyɛ, mende ayi aló nchyɛ abɔ́ achyɛ́ge ji ɛfwyale, anɛ Jisɔs mmyɛ nnó agɔ ji akwɔ́lé ji. Jisɔs ashya aké, ");
INSERT INTO anvNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Kéré meso. Ndɛre ɔ́jyɛ mbɔ, gáré bɔɔ́ gekpɛ́kpɛ́gé genó ɛyígé Ɛsɔwɔ ápyɛɛ́ ɛta wyɛ́.” Jisɔs ajɔ́gé mbɔ mende yimbɔ afɛ́, akɛ melɔ́ kpaa ɛwémbɔ meko agarege yɛ́ndémuú galɔ́gálɔ́ ayi Jisɔs ápyɛɛ́ ɛta wuú. ");
INSERT INTO anvNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Jisɔs achyá akeré ɛ́gbɛ́ géntoógé mewaá. Ɛ́fɛɛ́ ɛkwɔ́ bɔɔ́ ábɔ́ ágile ji ne áchwɔ́gé ásɛ ji ne metɔɔ́ megɔmegɔ. ");
INSERT INTO anvNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Mende fɔ achwɔ́, ayi ákúu ji Jarɔs, alu muú kpaá né ɛcha mmyɛmenɛne. Ajyɛ kpá Jisɔs geká nnó ajyɛ́ né gepú jií, ");
INSERT INTO anvNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","gétúgé maá wuú áchwɔ́ gbó. Awya lé maá yiná ama mendée, ne alu aŋmɛ́ afyáneapeá. Ne Jisɔs alɔ manjyɛ, ndɛre ajyɛ́ bɔɔ́ ákwɔlege ji ɛ́gbɛ́ ɛwé ne ɛwé. ");
INSERT INTO anvNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Né geluage bɔɔ́ bimbɔ mendée fɔ abɔ́ alu ayi manoó mátánege ji mbɛ, málɛ́ aŋmɛ́ áfyáneápeá; bɔɔ́ maka apyɛ kpá meti ɛpɔ́ mantoó. ");
INSERT INTO anvNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Né geluage bɔɔ́ bimbɔ mendée yimbɔ akɛ né mpu bɔɔ́ achwɔ́ ji né meso anyaá ɛbwɔ ata manó nku wuú. Wyɛ́ ndɛre ataá mbɔ manoó mimbɔ masɔ́. ");
INSERT INTO anvNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Jisɔs agií aké, “Waá taá me?” Yɛ́ndémuú ashya, Pita aké, “Ata ɔ́gɛ́né fɔ́ ndɛre bɔɔ́ ánɔ wɔ́ mme áŋmɛ́rege wɔ?” ");
INSERT INTO anvNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Yɛ́mbɔ Jisɔs ató wyɛ́ ɛshyɛ ajɔɔ́ aké, “Muú fɔ ata me néndé nwú ndɛre uto útané me mmyɛ.” ");
INSERT INTO anvNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Mendée yi agɛ́gé nnó ula úgyá ji achwɔ́ mbɛ ushu Jisɔs awere, akwé ji uká. Ɛ́fɛɛ́ alɔ mangaré mbɛ ushu bɔɔ́ ako genó ɛyígé pyɛ́ ne ji ataá Jisɔs. Ne ama gáre ntó ndɛre ji atágé Jisɔs nemée nií nébyɛ́ tɛ́nétɛ́né. ");
INSERT INTO anvNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Jisɔs aké ne ji, “Maá wa ɔtoó gétúgé ɔfyɛɛ́ metɔɔ́ wyɛ ne me, kɛ pere.” ");
INSERT INTO anvNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Ndɛre Jisɔs abɔ alú jɔɔ́ge ne mendée yimbɔ, muú fɔ átané né gepúgé Jarɔs áchwɔ́ gáre Jarɔs áké, “Maá wyɛ agbó mɛ́, ɔchyɛgé sé ménlɛré ɛfwyale detú.” ");
INSERT INTO anvNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Ndɛre ajɔ́ge mbɔ, Jisɔs awú ne aké ne Jarɔs, “Ɔfɔgé, fyɛ́ lé metɔɔ́ ne me, maá wyɛ apome nyɛ́.” ");
INSERT INTO anvNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Jisɔs ne Jarɔs átané áfɛ́. Ákwɔ́négé né gepúge Jarɔs, Jisɔs akamé fɔ́ nnó muú yicha akpɛ mmu wɔ́, ɛ́kosé Pita ne Jɛmsi ne Jɔn ne mma ne ntɛ maá yimbɔ. ");
INSERT INTO anvNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Bɔɔ́ ako bí ábɔ́ álú ɛ́fɛɛ́, álíli, ádórege mmyɛ́ mme. Jisɔs aké ne ɛbwɔ́, “Deligé sé, mesɔ́ mendée yina agbo wɔ́, abɛlege lé géjyá.” ");
INSERT INTO anvNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Ɛbwɔ́ álɔ manjwáné Jisɔs jwané gétúgé ákaá nnó maá awú agbó mɛ́. ");
INSERT INTO anvNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Jisɔs afɛ́ né melu ɛwé ábelé maá yimbɔ, agbaré ji ɛbwɔ, akú ji aké, “Mensɔ mendée kwilé ka.” ");
INSERT INTO anvNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Maá yimbɔ mendoó wuú ɛkeré, apeé akwilé ajwɔlé ka. Jisɔs aké ne bwɔ́ kɛ́lege menyɛɛ́ chyɛ́ge ji anyɛ́. ");
INSERT INTO anvNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Mmá maá yimbɔ ne ntɛ wuú áké ágɛ́ne mbɔ, matyɛ mawá ɛbwɔ́ meno. Jisɔs afyɛ ɛbwɔ́ ɛbɛ́ nnó ɛ́kagé ápyɛ́ muú akaá genó ɛyí gépyɛ́. ");
INSERT INTO anvNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Né gébé géfɔ́ Jisɔs akuú áŋgbá bií áfyáneapeá. Áchwɔ́gé, achyɛɛ́ ɛbwɔ́ uto mámbú aló nchyɛ ako abi áchyɛ́ge bɔɔ́ ɛfwyale ne mampyɛ bɔɔ́ mamée átoóge. ");
INSERT INTO anvNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Ne atɔ́ ɛbwɔ́ nnó ájyɛ́ ágáré abya gefwage Ɛsɔwɔ ne mámpyɛ bɔɔ́ mamée átoó. ");
INSERT INTO anvNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Ama jɔ́ɔ ne ɛbwɔ́ nnó, “Deké dejyɛ dékpagé yɛ genó. Dégbarégé meto yɛ menyɛɛ́ yɛ gebá yɛ ŋka. Ɛ́kagé muú abɔ́ ndeé ɛyichá. ");
INSERT INTO anvNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Dekwɔnégé yɛndé melɔ yɛ́ndé gepú ɛyigé dékpɛ́gé, bɛ́ge wyɛ kpaá tɛ délyáge géjí. ");
INSERT INTO anvNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Mbɔgé melɔ́ ɛ́shagé mánsɛ ɛnyú, lyáge ɛ́wú. Deke delyage, nóge uká mme nnó mpúpú ɛyi ɛ́balé ɛnyú né uká ɛ́táné mambɛ nkane gepɔ ɛyi gelɛ́rege gabo yi bɔɔ́ biná ápyɛ́.” ");
INSERT INTO anvNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Wyɛ́mbɔ ne ályá, álɔ mankɛ́né malɔ́málɔ́ ágárege Abya Ɛsɔwɔ melɔ́mélɔ́ ne ápyɛ́ bɔɔ́ mamée átóoge mbaá meko. ");
INSERT INTO anvNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Né gébé ɛyigémbɔ, Hɛrɔd muú alu muú kpaá né gebagé mewaá Galilií, ji awú ŋgɔ ukpɛ́kpɛ́ unó bí baá utɔɔ́ Jisɔs ápyɛ. Akwé tametame, gétúgé bɔɔ́ fɔ́ ájɔ́ge áké Jisɔs yina alu lé mewené Jɔn menwyaá bɔɔ́ manaá Ɛsɔwɔ ne akwilé né negbo. ");
INSERT INTO anvNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Abifɔ áké: Ɛlija *Muú Ɛkpávé Ɛsɔwɔ ne ámá chwɔ́ lɛ́re mmyɛ mbaá bɔɔ́, abifɔ áké: Ɛ́lé gekwénegé muú ɛkpávé Ɛsɔwɔ ne ámá kwilé né negbo. ");
INSERT INTO anvNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Hɛrɔd awúgé mbɔ aké, “Jɔn nsɔɔ́ ji mekpo ne waá chá me mmage wúmbɔ ufélekpa ɛbí apyɛ.” Ne akɛlé meti mangɛ́ Jisɔs yimbɔ. ");
INSERT INTO anvNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","*Áŋgbá Jisɔs bimbɔ áfɛ nekɛ ákérégé meso, ádo ji abya ufɔɔ́ unó bí ɛbwɔ́ ápyɛ́. Aferé ɛbwɔ́ né gelúagé bɔɔ́ asɛ ɛbwɔ́ áfɛ́ ɛbwɔ́ ɛbwɔ́ né melɔ́ kpaa ɛwé ákúu Bɛtsada. ");
INSERT INTO anvNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Yɛ́mbɔ gejamégé bɔɔ́ áwúgé nnó áfɛ́, álɔ mankwɔlé ji. Agɛ́gé ɛbwɔ́, asɛ wyɛ́ ɛbwɔ́ ako ne alɔ mangárégé ɛbwɔ́ ndɛre gefwage Ɛsɔwɔ gélú ne mampyɛ bɔɔ́ mamée átóoge. ");
INSERT INTO anvNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Nkwale aké akwɔnege baá utɔɔ́ bií áfyáneápeá ágaré ji áké, “Ɛse delu fá né mashwɔne. Gáré bɔɔ́ bina ájyɛ ákɛ́lé né malɔ nnó ágɛ́ne genó ɛyigé ányɛ́ɛ ne malú ubɛ́lé.” ");
INSERT INTO anvNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Jisɔs ashuú ɛbwɔ́ meko aké, “Ɛnyú ambɔɔ́ chyɛ́ge ɛbwɔ́ menyɛɛ́ ányɛ́.” Áshuú ji meko áké, “Déwyaá lé ntó brɛd ɛ́táa ne meshuú ɛ́pea, wá ɔ́kɛlege nnó ɛsé déjyɛ́ déná menyɛɛ́ yi ákwánege gejamégé bɔɔ́ bi?” ");
INSERT INTO anvNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Ábɔ́ ájɔ́ɔge mbɔ gétúgé bɔɔ́ álú ɛké ushyɛ. Ande ɛbwɔ́ ɛbwɔ́ álú *dɛlé bɔɔ́ átáa. Jisɔs ake ne baá utɔɔ́ bií, “Gáré ɛbwɔ́ ájwɔ́lé matoó matoó, yɛndé ntoó usa bɔɔ́ úpéa mesó ɛ́fya.” ");
INSERT INTO anvNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Ájɔ́gé mbɔ, bɔɔ́ bimbɔ ájwɔlé mme. ");
INSERT INTO anvNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Jisɔs abɔ́ ntóo brɛd ɛyimbɔ ɛ́táa ne meshuú ɛ́peá, apɛ amɛ mfaánebuú, achyɛ́ matame mbaá Ɛsɔwɔ, agyá ɛ́jí ubauba achyɛ́ baá utɔɔ́ bií nnó ákáré mbaá bɔɔ́ bimbɔ ányɛ́. ");
INSERT INTO anvNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Ɛbwɔ́ ako ányɛɛ́ ágbeé. Ne ánérégé, ányweré ayi álaá ágbeé usá úfyáneupeá. ");
INSERT INTO anvNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Bií úmá ɛbí Jisɔs anɛ́nemmyɛ jimbí, baá utɔɔ́ bií ábɔ́ álú kwɔ́kwɔ́lé ne ji. Aké anerege agií ɛbwɔ́ ake, “Ndé gefɔgé muú njune bɔɔ́ ájɔɔ́gé nnó me nlu?” ");
INSERT INTO anvNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Ɛbwɔ akeré meko áké, “Bɔɔ́ bi fɔ́ áké ɔlu mewené Jɔn menwyaá bɔɔ́ manaá Ɛsɔwɔ, abi fɔ́ áke ɔlu Ɛlija abifɔ ntó áke ɔlu muú ɛkpávé Ɛsɔwɔ ayi ábɔ́ agboó ne ama pée.” ");
INSERT INTO anvNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Jisɔs ama gíi ɛbwɔ́ aké, “Yɛ́ ɛnyú deké nlu waá?” Pita ashuú ji meko aké, “Wɔ ɔlu *Muú yi Ɛsɔwɔ akweré ji ɛlá gefwa.” ");
INSERT INTO anvNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Jisɔs afyɛ ɛbwɔ́ ɛbɛ́ nnó ɛ́kágé ágaré muú fɔ nnó ji alu Muú yi Ɛsɔwɔ akweré ji ɛlá gefwa. ");
INSERT INTO anvNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Ama jɔ́ɔ ne ɛbwɔ́ aké, “*Maá Ntɛ Mekwaá abɔ́ mangɛ́ ɛfwyale dɔɔ́. *Ákpakpa melɔ chóncho ne ámpyɛ́ upɛ Ɛsɔwɔ ne *Ánlɛré mabɛ́ Ɛsɔwɔ áshyá nyɛ́ ji ne áwáne ji. Yɛ́mbɔ ndɔ ɛ́lɛɛ́ ɛ́kwɔnégé akwilege nyɛ́ né negbo.” ");
INSERT INTO anvNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Ne ama jɔɔ́ ne bɔɔ́ áko aké, “Yɛ́ mbɔgé muú nyú akɛlege mambɛ menkwɔle wa, abɔ manjinte gemɛ jií akpa gekwa ji akame yɛ negbo ne akwɔ́légé me. ");
INSERT INTO anvNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Mbɔgé muú akɛlege mampoó geŋwá jií ɛbyɛ́nnó aníige nyɛ geji, ne mbɔgé muú akamégé manchyɛɛ́ geŋwá jií getú ya, ɛbyɛ́nnó apomé nyɛ. ");
INSERT INTO anvNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Ama gií aké: Ndé nsá ayi muú ábɔ́ɔ, mbɔgé abɛge ne unó mme uko ne aníige geŋwá jií? ");
INSERT INTO anvNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Kaáge nnó mbɔgé mmyɛ́ ɛ́gbóo muú gétuú ya ne mekomejɔɔ́ wa, wyɛ́mbɔ ne *Maá Ntɛ Mekwaá mmyɛ́ ɛgbóo nyɛ́ ji mansɛ muú yimbɔ ndɛre muú wuú né gébégé aké achwɔ́ ne geŋgbɔ́ gefwa jií ne ɛyi gélú ntó ɛyigé Ɛsɔwɔ ne makiɛ́nné ukpea jií. ");
INSERT INTO anvNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Kaáge wáwálé nnó gentɔgé bɔɔ́ álú mbɔ fáná, abi álá gbóo fɔ kpaá tɛ ágɛne nyɛ gefwage Ɛsɔwɔ.” ");
INSERT INTO anvNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Genógé ndɔ ɛ́nee ɛ́kógé ɛyi *Jisɔs abɔ́ ajɔɔ́ unó bi, asɛ Pita, ne Jɔn ne Jɛmsi akwɔ́ ne ɛbwɔ́ mfaá mekwɛ fɔ́ nno ajyɛ anɛ́mmyɛ ɛ́wu. ");
INSERT INTO anvNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Afɛ́, ne ndɛre abɔ ánɛ́nemmyɛ ushu bií ulɔ mánkwɔré ne úla gefɔɔ́ géchá. Mandeé jií ntó ákwɔré ála pópó ashwánege. ");
INSERT INTO anvNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Wyɛ́ mbélépó bɔɔ́ ápéa ákwɔ́ fwɛɛ́, ɛfɛɛ́ ájɔɔ́ge mejɔɔ́ ne Jisɔs. Bɔɔ́ bímbɔ ɛ́lé Mosis ne *Ɛlija, ");
INSERT INTO anvNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","ne geŋgbɔ́gé Ɛsɔwɔ gebɔ gegɛ́nege mbaá yi ɛbwɔ́ abɔ álú. Ɛbwɔ́ ájɔ́ge ndɛre Jisɔs ajyɛ gbó nyɛ́ né Jɛrosalɛ ndɛre Ɛsɔwɔ aké ɛ́bɛ́. ");
INSERT INTO anvNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Ndɛre ɛbwɔ́ ábɔ́ jɔ́ge ne Jisɔs, Pita ne Jɛmsi ne Jɔn ábɔ́ ákwé géjya. Áké ápɛ́le ágɛ́ ndɛre Geŋgbɔ́ge Ɛsɔwɔ géshwánege né menyamyɛ Jisɔs ne ande bimbɔ ápéa abi átɛné ne ji. ");
INSERT INTO anvNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Wyɛ́ ndɛre ande bimbɔ ályá Jisɔs ájyɛ, Pita aké ne Jisɔs, “Ata, ɛlɔ́ ndɛre ɛsé délú fa. Ɛsé détɛnege nyɛ́ óto úlɛɛ́, géma ɛta wyɛ, géma ɛta Mosis ne géma ɛta Ɛlija.” Pita ajɔge mbɔ, akaá wɔ́. ");
INSERT INTO anvNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Wyɛ́ ndɛre Pita ajɔ́gé mbɔ, gekó géchwɔ kweré bwɔ́ ne ɛ́fɔ́ ɛ́kwɔ́ bwɔ́ matɔɔ́ ");
INSERT INTO anvNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Meko muú fɔ atané mmu gekó aké, “Gɛ́ge maá wa ayi me njyá na, wuúge ne ji.” ");
INSERT INTO anvNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Meko yimbɔ aké akwyage ágɛ́ nnó Jisɔs ala jimbií. Ɛbwɔ́ ákérégé meso ála bɔmbɔ né gébé ɛyígémbɔ, ágaré yɛ muú fɔ unó bí úpyɛ́ né mfaá mékwɛ́ wɔ́. ");
INSERT INTO anvNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Bií újyágé ndɛre Jisɔs ne áŋgbá bií áshúlege mekwɛ ɛwémbɔ áchwɔ, gejamégé bɔɔ́ áchwɔ báne ɛbwɔ́. ");
INSERT INTO anvNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Muú ama akalé né mmu gejamégé bɔ́ɔ bimbɔ aké, “Ménlɛré, nkpa wɔ geká pɛ maá wa. Nwya ɛ́le maá yiná ama, alu mende. ");
INSERT INTO anvNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","*Meló nchyɛ achyɛ́ge ji ɛfwyale. Yɛ́ndégébé akwilégé ji akalé, akwé mme achuú, akpane upa, ne genfwéné getánege ji meno, meló nchyɛ yimbɔ alyágé ji kɔkɔge. ");
INSERT INTO anvNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Nnɛ baá utɔɔ́ byɛ mmyɛ nnó áféré meló nchyɛ yina ne ápulé ɛ́pwɔ.” ");
INSERT INTO anvNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Jisɔs awúgé mbɔ aké, “Ɛ ɛ́ ɛnyú njyɛ ɛnina delu untantamé bɔɔ́ abi dela fyɛɛ́ matɔɔ́ ne Ɛsɔwɔ cháchá wɔ́. Nkoge mbɔ metɔɔ́ ne ɛnyú nnó? Mmage bɛ́ ne ɛnyú ndɔ ɛnií ne défyɛɛ́ matɔɔ́ ne Ɛsɔwɔ? Ajɔ́gembɔ, aké ne mende yimbɔ, chwɔ́ ne maá wyɛ fa.” ");
INSERT INTO anvNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Ndɛre ákɛ́ne achwɔ́ɔ ne maá yimbɔ meló nchyɛ yimbɔ, apyɛ ji akwé mme achwu gbokgbok. Jisɔs anyá meló nchyɛ yimbɔ atané maá yimbɔ mmyɛ atoó. Jisɔs ashuú ji mbaá ntɛ wuú. ");
INSERT INTO anvNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Bɔɔ́ áko ágɛ́gé uto bí Ɛsɔwɔ awya matyɛ mawá ɛbwɔ́ meno. Yɛ́ndémuú ala meno mekpo fuú né ukpɛ́kpɛ́ unó bí Jisɔs apyɛ, abwɔlé ajɔɔ́ ne baá utɔɔ́ bií ake, ");
INSERT INTO anvNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Nénege matu déwú mechɔ́ ɛwé nchwɔ́ɔ gare ɛnyú. Áchyɛ́ge nyɛ Maá Ntɛ Mekwaá né amu bɔɔ́ nchyɛ nnó ápyɛ́ ne jí ndɛre ɛ́jií bwɔ́.” ");
INSERT INTO anvNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Yɛ́ ndɛre Jisɔs ajɔɔ́ mbɔ, baá utɔɔ́ bií ákaá ula mechɔ́ ɛwéna wɔ́. Genó gefɔ́ géwá ɛbwɔ́ matɔɔ́ nnó yɛ áwú ákaágé ula. Ne ɛbwɔ́ ábɔ́ ntó ɛfɔ má mangíi ji. ");
INSERT INTO anvNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Ɛ́ké ɛ́wyage mbeé akwé baá utɔɔ́ Jisɔs ɛbwɔ́ ɛbwɔ́ nnó waá alú muú kpaá? ");
INSERT INTO anvNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Jisɔs akaá ufɛ́ré bwɔ́ ɛ́fɛɛ́ ne asɛlé maá fɔ kɔɔ́ atɛ́né ne ji né néŋkwú né mmyɛ, ");
INSERT INTO anvNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","ne aké ne ɛbwɔ́, “Yɛ́ndémuú ayi akamege mampyɛ galɔ́gálɔ́ ne mamane kɔɔ́ nkane ayina né mabɔ ma ɛbyɛnnó asɛ mbɔ lé me, ne muú yi asɛgé me ɛbyɛnnó asɛ mbɔ lé muú yi atɔmé me. Kaáge nnó muu yi asɛ́le menyamyɛ wuú nnó ji apɔ́ yɛ muú fɔ né geluáge nyú ɛlé ji ne alú muú kpaá.” ");
INSERT INTO anvNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Jɔn akwilé ne ɛwú aké, “Ata debɔ́ degɛ́ mende fɔ aferege aló nchyɛ né mabɔ myɛɛ́ ne dégbɛ́ ji gétúgé álá pɔ́ fɔ́ né geluá gesé.” ");
INSERT INTO anvNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Jisɔs ajɔɔ́ ne ɛbwɔ́ aké, “Dégbɛgé gefɔgé muú yimbɔ gétúgé muú yi álá paá ɛnyú alu lé awu nyú.” ");
INSERT INTO anvNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Gébé gélágé kwɔ́kwɔ́lé ɛyígé Ɛsɔwɔ asɛ́le nyɛ́ Jisɔs mánjyɛ mfaánebuú, Jisɔs awya metɔɔ́ nnó abɔ́ manjyɛ né Jɛrosalɛ. ");
INSERT INTO anvNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Ndɛre alɔɔ́ mánjyɛ, atɔ́ bɔɔ́ fɔ́ né mbɛ. Ákwɔ́négé melɔ fɔ́ né gebage Samariya, álɔ mánkɛlé melu ɛwé Jisɔs achwɔgé ábɛ́lege. ");
INSERT INTO anvNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Bɔɔ́ bimbɔ ágɛ́gé nnó Jisɔs akoge mánjyɛ Jɛrosalɛ, áshya mánsɛ ji. ");
INSERT INTO anvNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Jɛmsi ne Jɔn, áwúgé mbɔ ágií Jisɔs áke, “Ata, nnó déjɔ́ mewɛ́ ɛ́táné mfaánebuú ɛ́shulé ɛ́chwɔ́ ɛ́sɔ́ bɔɔ́ bi ágbó?” ");
INSERT INTO anvNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Jisɔs abwɔlé ushu ashulé ɛbwɔ́ ndo. ");
INSERT INTO anvNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Ne alyágé ɛ́fɛɛ́ afɛ́ melɔ ɛwéchá ne baá utɔɔ́ bií. ");
INSERT INTO anvNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Wyɛ́ ndɛre ákɛ́ne ájyɛ né meti, mende fɔ achwɔ́ jɔ́ɔ ne Jisɔs aké, “Nkwɔ́légé wɔ déjyɛ́gé yɛ́ndé mbaá ayi ɔjyɛ́.” ");
INSERT INTO anvNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Jisɔs ashuú ji meko né nekanémejɔɔ́ aké, “Ushua úwya ambu ayi úbɛ́lege wyɛ́, denwyɔné dewyaá anywa ne me Maá Ntɛ Mekwaá mpɔ́ yɛ ne melu ɛwé nshwɔ́rege mekpo ngbeé mmyɛ.” ");
INSERT INTO anvNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Ɛ́ké ɛ́wyáge Jisɔs aké ne mende yicha, “Kwɔ́lé me.” Mende yimbɔ aké, “Ata gɔ́ njyɛ́ nníi kpɛ́ ntɛ wa ne nchwɔ́.” ");
INSERT INTO anvNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Jisɔs ashuú ji meko aké, “Lyá abi álú ɛké áwuú bɔ́ ánií mewu bwɔ́; ne wɔ chó ɔ́jyɛ́ ɔ́gáré ndɛre gefwage Ɛsɔwɔ gélú.” ");
INSERT INTO anvNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Muú yifɔ ama jɔ́ɔ ne ji aké, “Ata nkwɔlege nyɛ́ wɔ, yɛ́mbɔ gɔ́ kpɛ́ njyɛ́ ngaré ulagepú ba nnó ɛsé détámé atɛ ne nchwɔ́.” ");
INSERT INTO anvNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Jisɔs ashuú ji meko aké, “Muú yi agbarégé mɛ́ géká mankyá mekɔɔ́ ne amagé ja mmyɛ meso akwané fɔ́ mambɛ́ muú utɔɔ́ gébégé Ɛsɔwɔ agbarégé gefwa ji wɔ́?” ");
INSERT INTO anvNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Depɔ ɛtíré na dékógé, Ata Jisɔs ajya usaá bɔɔ́ úlɛɛ́ mesó ɛfyanepéa, atɔ́ ɛbwɔ́ ápéa ápéa nnó ábɔ́ mbɛ né malɔ ayi jimbɔɔ́ akoge nyɛ́ wyɛɛ́. ");
INSERT INTO anvNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Ndɛre atɔ́mé ɛbwɔ́ aké, “Mbwɛ́ manferé ajá dɔɔ́ ne bɔɔ́ utɔɔ́ abi áférege ája wɔ́. Nɛ́ge mmyɛ mbaá Ɛsɔwɔ mbɔɔ́ mekɔɔ́ nnó atɔ́ bɔɔ́ utɔɔ́ abifɔ nnó áchwɔ́ áferé mbwɛ́ wuú. ");
INSERT INTO anvNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Chóge, ndɛre déjyɛ́ mbɔ kaáge nnó mentɔme ɛnyú mbaá bɔɔ́ mme nkane mágɔ́ŋme né mpú ukwaála. ");
INSERT INTO anvNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Deké dejyɛ debɔgé ŋka, yɛ géba yɛ unó uká ɛbífɔ́. Deké dejyɛ né menɔ meti détɛnégé fɔ détámé muú ");
INSERT INTO anvNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Yɛ́ndé melɔ ɛwé dekwɔnégé, gepú ɛyigé dékpɛ́ne, bɔ́ge mbɛ détámé bɔɔ́ abi álú né mmu nnó, ‘Nesɔ nébɛ́ né gepú yina’ ");
INSERT INTO anvNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Mbɔgé muú alú né gepú ɛyigémbɔ ayi apyɛ́ fɔ nesɔ, nesɔ neláa nyɛ́ ne ji, mbɔge ápyɛ́ nesɔ, nesɔ nékérege nyɛ́ ɛta nyú. ");
INSERT INTO anvNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Dekpɛgé né gepú ɛyigémbɔ bɛ́ge wyɛ́ ɛ́fɛɛ́, dékpɛgé fɔ upú upú. Yɛ́ndégenó ɛyígé áchyɛgé nyú nyɛ́ge lé nyɛɛ́ ne ɛyigé manyú nyúge, getúgé muú utɔɔ́ abɔ́ mambɛ́ ne nsá. ");
INSERT INTO anvNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Yɛ́ndé melɔ ɛwé dekwɔnégé ásɛgé nyú ábelégé mmu gepú déshagé fɔ́ menyɛɛ́ yi áchyɛ́ge ɛnyú. ");
INSERT INTO anvNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Pyɛ́ge bɔɔ́ mamée átóo né melɔ ɛwémbɔ, ne gárege ntó ɛbwɔ́ mekomejɔɔ́ Ɛsɔwɔ nnó, ‘Gefwage Ɛsɔwɔ gechwɔ́ kwɔ́kwɔ́lé ne nyú.’ ");
INSERT INTO anvNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Yɛ́ndé melɔ ɛwé dekwɔnégé ne áshagé mansɛ ɛnyú, chóge né metɔɔ́ melɔ déjɔɔ́ nnó, ");
INSERT INTO anvNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Yɛ́ mpúpú ɛ́yí dékpané né melɔ ɛnyú, gɛ́ge ɛ́jíná ndɛre dékwele uká nnó ɛ́táné. Yɛ́mbɔ kaáge nnó Gefwage Ɛsɔwɔ gechwɔ́ kwɔ́kwɔ́lé.’ ");
INSERT INTO anvNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Ńgarege ɛnyú nnó bií únɔɔ́ mpa, Ɛsɔwɔ agɛne nyɛ́ melɔ Sodom meshwɛ apwɔ melɔ ɛwémbɔ.” ");
INSERT INTO anvNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Ake, “Utóŋkwa ubɛ́ nyɛ ne ɛnyú bɔɔ́ melɔ́ Korasin, utóŋkwa ubɛ́ ntó ne ɛnyú bɔɔ́ Bɛtsada néndé, ukpɛ́kpɛ́ ufélekpá ɛbi mpyɛ ɛta nyú, mbɔ mpyɛ nyá ubi mbaá bɔɔ́ Tiya ne Sidɔn mbɔ ályaá mɛ́ gabo bwɔ́ tɛ gachií, áfyɛ uchálé mandeé, áwaá matwɔ né mekpo mánlɛré nnó ályaá gabo ɛbwɔ́. ");
INSERT INTO anvNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Kaáge nnó bií unɔɔ́ mpa Ɛsɔwɔ agɛne nyɛ bɔɔ́ Tiya ne Sidɔn meshwɛ apwɔ ɛnyú. ");
INSERT INTO anvNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Chyá ɛnyú bɔɔ́ Kapanɔm, défɛré nno ngɔ́ nyú akwɔme nyɛ́ tɛ mfaá mfaá? Ngba! Áshúlege nyɛ́ ɛnyú mme kpátɛ dékwɔ́nege melɔ áwuú bɔɔ́.” ");
INSERT INTO anvNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Jisɔs aké achwɔ nére, ajɔɔ́ ne abi ji atɔmé aké, “Muú yi awugé ɛnyú ɛbyɛnnó awú mbɔ ɛ́lé me, ne muú yi ashyagé ɛnyú ɛbyɛnnó ashya mbɔ ɛ́lé me; ne muú yi ashyagé me ɛ́lɛré nnó ashya mbɔ lé Ɛsɔwɔ muú átɔme me.” ");
INSERT INTO anvNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Baá dentɔɔ́ Jisɔs bimbɔ usaá ulɛɛ́ mesó ɛfyanepea ákeré meso ne nechɔ́chɔ́ áké ne Jisɔs, “Átá yɛ aló nchyɛ áwuú ɛ́sé gébégé dényané abi né mabɔ myɛ́.” ");
INSERT INTO anvNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Jisɔs akeré bwɔ́ meko aké, “Ɛ́lú wáwálé, ngɛ́ *danchɔmeló ndɛre atáné mfaánebuú ɛké dasama akwe né mme. ");
INSERT INTO anvNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Wuúge! Nchyɛ́ ɛnyú uto ɛbí dékáge jyá mmyɔ ne ngát ne mma nchyɛɛ́ ɛnyú uto bí upwɔ́ yɛ uto ɛbi Danchɔmeló ne genó gefɔ́ ɛyí gépyɛ́ ɛnyú gépɔ́. ");
INSERT INTO anvNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Yɛ́mbɔ débɛ́gé fɔ ne nechɔ́chɔ́ gétúgé aló nchyɛ áwúu ɛnyú. Bɛ́ge lé ne nechɔ́chɔ́ nnó Ɛsɔwɔ asá mabɔ nyú né mmu ŋwɛ ayi alú né mfaánebuú.” ");
INSERT INTO anvNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Né gebé ɛyigé Jisɔs ájɔɔ́ge depɔ ti, Mendoó Ukpea ɛ́pyɛ ji agbeé ne nechɔ́chɔ ne ajɔɔ́ aké, “Ntɛ wa, Ata ayi abɔɔ́ mfaá ne mme, mfɛɛ́ wɔ dɔɔ́, nkane ɔpyɛɛ́ nnó depɔ ɛtire detome ne me debɛ bibií mbaá bɔɔ́ deŋgá ne abi ákaá ŋwɛ dɔɔ́. Ɔ́nené deti gbɔ́gɔ́nɔ́ mbaá bɔɔ́ abi álá kaáge yɛ genó nnó ákaá. Ɛlu wáwálé Ntɛ wa, mbɔ ne wɔ mbɔɔ́ ɔ́kɛlé nnó ɛ́bɛ́.” ");
INSERT INTO anvNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Jisɔs ama jɔ́ɔ aké, “Ntɛ wa achyɛ me unó uko. Muú ayi akaáge gefɔgé muú ayi Maá alú ápɔ́, ɛkosé Ntɛ wuú ne yɛ muú ayi akaágé gefɔgé muú ayi Ntɛ alu ápɔ́ ɛkose Maá ne bɔɔ́ abi ji ájyaá nnó ápyɛ ɛbwɔ́ ákaá Ntɛ wuú.” ");
INSERT INTO anvNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Ɛké ɛ́wyage abwɔlé ushu ajɔɔ́ ne baá utɔɔ́ bií aké, “Ɛnyú dewya ɛ́fwɔ́ mangɛ́ unó bí dégɛ́ne mbɔ. ");
INSERT INTO anvNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Ngarege ɛnyú nnó gejamégé bɔɔ́ ɛkpávé Ɛsɔwɔ ne afwa ntó abɔ ákɛlé mangɛ́ unó bi ɛnyú dégɛ́ne mbɔ ne manwú unó bi ɛnyú déwuú mbɔ yɛ́mbɔ áwuú wɔ́.” ");
INSERT INTO anvNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Ɛ́ké ɛwyáge *Ménlɛré mabɛ́ Ɛsɔwɔ fɔ́ achwɔ́ ne defyá né metɔɔ́ mámua Jisɔs aké, “Ménlɛré, mpyɛ nnó ne mbɔ́ geŋwá ɛyi gélágé byɛ́?” ");
INSERT INTO anvNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Jisɔs agií ji aké, “Ásá né mmu ŋwɛ Ɛsɔwɔ nnó? Ɔjɔɔ́ wyɛ́ ɔwú nnó?” ");
INSERT INTO anvNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Ashuú Jisɔs meko ake, “Gbógé ne Ata Ɛsɔwɔ wyɛɛ́ ne metɔɔ́ wyɛɛ́ meko, ne mendoó wyɛɛ́ meko ne ufɛ́ré byɛɛ́ uko, pyɛ́gé utɔɔ́ bií ne ɛshyɛ wyɛɛ́ meko, tégé wyɛɛ́ lé ji yɛ́ndégébé, ne gbógé ne ntɛ méŋmɛ́ wyɛɛ́ ndɛre ɔgboó ne gemɛ jyɛɛ́.” ");
INSERT INTO anvNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Jisɔs aké ne ji, “Ɔlu cho Pyɛmbɔ ne ɔ́bɔ́ geŋwá.” ");
INSERT INTO anvNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Mende yimbɔ, manlɛré nnó nkwɛ́ wuú alu cho, agií ji aké, “Mpyɛ nnó ne nkaá ntɛ meŋmɛ́ wa?” ");
INSERT INTO anvNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Jisɔs agaré lé ji nekanémejɔɔ́ aké, “Né bií fɔ́ mende fɔ atané Jɛrosalɛ ashulege ajyɛ né Jɛriko, aké akwɔnege meti ánjó apyɛ ji, átule ji, áfɔɔ́ unó bií uko, ályá ji ala máŋgbómaŋgbó, ábó áfɛ́. ");
INSERT INTO anvNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Ɛ́ké ɛ́pyɛmbɔ, *mémpyɛ upɛ Ɛsɔwɔ ashulege ajyɛ né meti ɛwémbɔ aké agɛne mende yimbɔ apyamé akoó. ");
INSERT INTO anvNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Wyɛ́mbɔ ntó ne muú Lɛvi áchwɔɔ́, alu mempoó ámpyɛ́ upɛ Ɛsɔwɔ, akwɔ́négé ɛ́fɛɛ́, agɛ́ mende yimbɔ ji ntó akoó ɛ́gbɛ́ ɛwé chá. ");
INSERT INTO anvNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Ɛ́ké ɛwyage mende *Samariya fɔ ayi ɛbwɔ álá túgé ne bɔɔ́ Jus akwɔ́ne ɛ́fɛɛ́ aké agɛne mende yimbɔ meshwɛ akwɔ́ ji metɔɔ́. ");
INSERT INTO anvNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Ajyɛ báne ji, ashwɔné upa bímbɔ ne mmɔɔ́ , ata maweé wyɛ́ awɛ́ úbí ne ubaá mándée. Abwɛɛ́ ji anɛré mfaá *géjuŋá jií, afɛ́ ne ji né gepú ɛyígé aŋkɛɛ́ ábɛ́lege áchyɛ́ge maŋka, ɛ́fɛɛ́ ne apɛlé ji. ");
INSERT INTO anvNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Bií ujyágé aferé nka achyɛ́ mbɔɔ́ gepú aké ne ji, ‘Pɛ́lé me mende yiná. Mbɔgé ɔchɔgé ŋka ɛ́pwɔgé ɛyí, nkerégé meso nshuge nyɛ́ wɔ ɛ́jí’.” ");
INSERT INTO anvNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Jisɔs agárégé ji mbɔ, agií ji aké, “Né ɛbwɔ́ bímbɔ álɛɛ́ ayi ndé álɛ́re nnó ji alu ntɛ meŋmɛ́ mende yi ánjó átulé mbɔ ji? Garé me.” ");
INSERT INTO anvNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","*Ménlɛré mabɛ Ɛsɔwɔ ashuú ji meko ake, “Ɛ́lé ayi agɛné mbɔ ji meshwɛ.” Jisɔs agaré ji aké chó, “Pyɛ wyɛ́mbɔ.” ");
INSERT INTO anvNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Ɛwyágé Jisɔs ne baá utɔɔ́ bií átane ájyɛ kwɔ́ne né melɔ fɔ́. Mendée fɔ ajwɔlege ɛ́fɛɛ́ ayi akamege Mata. Anɛ Jisɔs mmyɛ nnó achwɔ́ né gepú jií. ");
INSERT INTO anvNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Mata abɔ́ awya meso wuú yi alú mendée ayi akámege Mɛri. Ndɛre Jisɔs abɔ́ akpɛné mmu, Mɛri ajwɔle ji né neŋkúné mmyɛ, afwɔrege unó bí Jisɔs alɛ́rege, ");
INSERT INTO anvNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","yɛ́mbɔ Mata né ɛ́gbɛ́ ɛwuú amyɛ le maŋkɛle genó ɛyígé Jisɔs anyɛɛ́. Ɛke ɛwyage Mata ajyɛ jɔ́ɔ ne Jisɔs aké, “Átá Ɔgɛ́né ndɛre Mɛri alyá me nnó mpyɛ utɔɔ́ me mbií? Gáré ji áchwɔ apóo me.” ");
INSERT INTO anvNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Ata Jisɔs akuú ji aké, “Wɔ Mata ɔ́wane mmyɛ jyɛ mampyɛ gejamégé unó ne ɔ́ma ɔ́chyɛge gemɛ jyɛ ɛfwyale; ");
INSERT INTO anvNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Yɛ́mbɔ genó gelu géma ɛ́lé Mɛri ne ajyá genó ɛyígémbɔ. Ámage sɛ́ sé gejí ɛta wuú.” ");
INSERT INTO anvNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Né gébé gefɔ́ Jisɔs abɔ́ anɛnemmyɛ né mbaá fɔ. Aké anerege maá utɔɔ́ wuú ama achwɔ jɔ́ɔ ne ji áke, “Ata lɛré ɛse ndɛre debɔɔ́ manɛmmyɛ mbaá Ɛsɔwɔ wyɛ ndɛre Jɔn abɔ́ alɛré baá utɔɔ́ bií.” ");
INSERT INTO anvNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Ɛ́fɛɛ́ Jisɔs alɛré baá utɔɔ́ bií ako aké, “Yɛndégébé deké denɛnemmyɛ jɔɔ́ge nnó: Ntɛ sé, pyɛ́ mabɔ mmyɛ́ mábɛ́ ne ɛ́nógé Pyɛ gefwa jyɛɛ́ géchwɔ́. ");
INSERT INTO anvNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Chyɛgé ɛsé menyɛɛ́ yi dékɛ́lege bií ne bií. ");
INSERT INTO anvNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Jinte gabo yi ɛse depyɛ ɛta wyɛ́, ndɛre ɛsé ntó déjígente gabo yi bɔɔ́ ápyɛɛ́ ɛta ɛsé. Ɔ́kamégé ɛsé dékpɛ́ né mmuameno.” ");
INSERT INTO anvNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Ne Jisɔs amɛɛ́ aké désɛ nnó, “Mbɔgé ɔlu ne mejeé ne ɔjyɛgé gáre ji ne metɔɔ́ utuú ɔké, ‘Mejeé pwɔ me ntó brɛd ɛ́lɛɛ́. ");
INSERT INTO anvNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Meŋkɛɛ́ wa achwɔ, mpɔ ne genó ɛyigé nchyɛge ji, mejeé wyɛ́ ajɔɔ́ge nyɛ́ nnó’? ");
INSERT INTO anvNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Ndɔfɔ ɛbɛ́ɛ nnó ji ashuge ji meko né mmu gepu aké, ‘Ɔchyɛge me ɛfwyale. Ngbɛ́ mɛ́ gepú ya mbɛlé ne baá ba, nkwilégé sé ka mankɛlé genó nchyɛ́ wɔ.’ ");
INSERT INTO anvNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Jisɔs aké, mende yiná ashyá mánkwilé ka achyɛ́ ji menyɛɛ́, yɛ́ lé alú mejeé wuú yɛ́mbɔ ngarege wɔ nnó yɛ ɛ́pyɛ́ nnó, gétúgé adoó menómbí dɔɔ́ dɔɔ́, mejeé wuú akwilege nyɛ́ ka manchyɛ́ ji yɛndé genó ɛyígé akɛ́lege ájyɛ́. ");
INSERT INTO anvNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“Mbɔ ne ngarege ɛnyú nnó, ‘Gige wyɛ Ɛsɔwɔ gige, achyɛge nyɛ́ ɛnyú unó bi dekɛlege, kɛlege wyɛ kɛlege ápyɛ nyɛ́ ɛnyú degɛ ubi. Dóoge wyɛ menombi doó, anénege nyɛ ɛnyú ɛwú.’ ");
INSERT INTO anvNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Kaáge nnó muú yi agigé genó, asɛle nyɛ, ne ayi akɛlégé, agɛne nyɛ, ne muú yi anogé menómbí, ánénege nyɛ́ ji ɛ́wú. ");
INSERT INTO anvNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Ndé muú nyú ayi abɛgé ntɛ, ne maá wuú agigé ji meshuú, áchyɛ́ge le ji mmyɔ? ");
INSERT INTO anvNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Wá mbɔgé akɔgé nekwanchií, achyɛge lé ji ngat? ");
INSERT INTO anvNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Mbɔgé ɛnyú ákwaá abi délú bɔɔ́ nchyɛ, dechyɛge unó ulɔ́úlɔ́ mbaá baá nyú, ndé gepyɛ ne Ntɛ nyú yi alú né mfaánebuú alá chyɛ́gé Mendoó Ukpea mbaá bɔɔ́ abi ágíge ji?” ");
INSERT INTO anvNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Né gébé gefɔ́ Jisɔs aféré meló nchyɛ ayi apyɛ́ mende fɔ álaá mbú. Meló yimbɔ aké atanege ji mmyɛ mende yimbɔ alɔ manjɔɔ́ mejɔɔ́. Gejamégé bɔɔ́ bí awuú ndɛre mende yimbɔ ajɔ́ge mejɔɔ́ matyɛ mawá ɛbwɔ́ meno. ");
INSERT INTO anvNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Yɛ́mbɔ abifɔ aké, “Abuú áló nchyɛ né menyamyɛ bɔɔ́, ɛlé Bɛlsɛbɔb mfwa áló nchyɛ ne achyɛ́ge ji uto nkawu ne ábuú áló nchyɛ.” ");
INSERT INTO anvNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Abifɔ akɛle meti mamua Jisɔs. Ágií ji áké, “Pyɛ ufélekpa ɛse dégɛ́, manlɛre nnó Ɛsɔwɔ ne atɔ́me wɔ.” ");
INSERT INTO anvNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Jisɔs ákaá genó ɛyigé ɛbwɔ́ áfɛ́rége, ajɔɔ́ ne ɛbwɔ́ aké, “Yɛ́ndé melɔ ɛwé bɔɔ́ álá pɔ́ meko ama, ɛ́tɛ́négé. Mbɔgé ula gepú ukarégé, uké umyɛ ne atɛ utyage. ");
INSERT INTO anvNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Mbɔntó ne ɛ́lú ne danchɔmelo, mbɔgé bɔɔ́ bií ákarégé aké ámyɛ́ ne atɛ gefwa jií gétɛ́négé. Njɔɔ́ mbɔ, gétúgé ɛnyú deke uto ba utanege mbaá danchɔmeló, ne nkáge mfére aló nchyɛ. ");
INSERT INTO anvNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Deké mférege aló nchyɛ né uto bí dánchɔmeló. Ndɛre ɛnyú deké mbɔ, bɔɔ́ nyú áferege né uto bí wá? Ɛ́byɛnnó ɛbwɔ́ ambɔɔ́ álɛ́rege ɛnyú nnó delu gyɛ́. ");
INSERT INTO anvNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Yɛ́mbɔ, mbɔgé ɛ́lé utó bí Ɛsɔwɔ ne mbuú áló nchyɛ, kaáge nnó Gefwage Ɛsɔwɔ gélɔ mɛ́ fá ne ɛnyú. ");
INSERT INTO anvNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Ɛnyú dekaá nnó, mbɔgé meto muú akpomégé mmyɛ ne unó bee mámbá gepú jií, unó bií uko ubɛ́ɛ cháŋéné. ");
INSERT INTO anvNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Yɛ́mbɔ mbɔgé muú yi atóo apwɔ́ɔ ji, achwɔgé kpá ji ne umyɛ, afɔge nyɛ́ unó umyɛ bií ɛbí ji abɔ́ anɛré metɔɔ́ wuú wyɛ́, akaré ne ajeé bií. ");
INSERT INTO anvNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Muú yi ashyagé mantɛné né depɔ ta, ɛ́byɛnnó atya lé détí. Mbɔgé muú ashyagé mampoó me nnó apyɛ́ bɔɔ́ ákaá Ɛsɔwɔ, ɛ́byɛ́nnó achɔ mbɔ ɛ́lé utɔɔ́ ba. ");
INSERT INTO anvNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Gepɔgé meló nchyɛ gélú nnó, gébégé atanégé muú né mmyɛ akɛ́ne akɛ́lege melu mangbeé mmyɛ né mmu mewaá. ‘Mbɔgé alá gɛ melu wɔ́, ajɔge aké nkerege meso né mbaá yi ntané.’ ");
INSERT INTO anvNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Mbɔgé akerege meso ne agɛgé nnó gepú yimbɔ gela gewa, ákwyɛ́ áshwa mɛ́ géjí, ");
INSERT INTO anvNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","akerege, afɛ́ asɛ áló nchyɛ abifɔ akénéama abi abɔɔ́ apwɔɔ́ ji, ákpɛ́ ájwɔ́lé mmu. Ne gefɔɔ́ ɛyígé muú yimbɔ ábɛɛ́ gebɔ́ɔ gépwɔ ɛyígé mbɛmbɛ.” ");
INSERT INTO anvNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Jisɔs ajɔɔ́gé depɔ ɛtí, mendée fɔ né mmu geluage bɔɔ́ bimbɔ ado ɛlúlú aké, “Metɔɔ́ megɔmegɔ ɛlú ne mendée yi ábyɛné wɔ ne awɛɛ́ wɔ ne mámbɛ́ jií.” ");
INSERT INTO anvNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Jisɔs akeré meko ake, “Géjamégé metɔɔ́ megɔmegɔ gélú lé ne bɔɔ́ bí awúu mekomejɔɔ́ Ɛsɔwɔ, ne apyɛ ndɛré aké.” ");
INSERT INTO anvNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Ndɛre Jisɔs ajɔ́ge depɔ tí gejamégé bɔ́ɔ áchwɔ chóme áwúu. Ne Jisɔs ajɔɔ́ ne ɛbwɔ́ aké, “Ɛnyú njyɛ ɛniné na debɔ. Dekɛlege me nlɛ́ré ɛnyú ufélekpa, yɛ́mbɔ yɛ́ uma nlɛ́régé fɔ́, wyɛ lé ufélekpa ɛbi *Jona. ");
INSERT INTO anvNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Wyɛ́ ndɛre Ɛsɔwɔ abɔ́ apyɛ́ ufélekpa né mmyɛ Jona manlɛré utó bií mbaá bɔɔ́ Ninɛvɛ, mbɔntó ne álɛ́rege nyɛ né mmyɛ Maá Ntɛ Mekwaá, ne njyɛ ɛniné na négɛ́ne nyɛ. ");
INSERT INTO anvNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Bií unɔɔ́ mpa Ɛsɔwɔ, mfwa mendée né melɔ Shɛba ákwilege nyɛ ashule bɔɔ́ njyɛ ɛnina ndo nnó ápyɛ gabo. Néndé, atané nya kpaá tɛtɛ ɛwu áchwɔ́ wú unó bi mfwa *Solomun álɛré nya bɔɔ́ ne déŋgá. Kaáge yɛ nnó muú alu mbɔ né metɔɔ́ metɔɔ́ ɛnyú ayi álɛ́rege mekomejɔɔ́ ne déŋgá apwɔɔ́ mfwa Solomun yɛ́mbɔ défyɛɛ́ fɔ́ matu manwúge wɔ́. ");
INSERT INTO anvNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Bií mpa, bɔɔ́ Ninɛvɛ ntó áshulege nyɛ́ ndo mbaá njɛ ɛníné fí gétúgé ɛbwɔ́ abɔ́ awúu mekomejɔɔ́ Ɛsɔwɔ ayi Jona abɔ agare ne ákwɔré matɔɔ́ bwɔ́. Muú yichá alu fá nána ayi mekomejɔɔ́ wuú apwɔɔ́ ayi Jona, ne ɛnyú dewuú fɔ́ ji. ");
INSERT INTO anvNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Muú álwɛ́gé fɔ́ ɛ́túléká ábele bíbí. Yɛ́ gesá akpáné fɔ akwéré ɛwú. Aŋma ɛwú mfaá nnó bɔɔ́ ákpɛgé mmu gepú ágɛ́né mbaá. ");
INSERT INTO anvNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Ámɛ́ mekwaá álu ɛke ɛtúlékáŋ né menyammyɛ wuú meko. Mbɔgé amɛ jyɛ́ álú cháŋéné, kaá nnó menyammyɛ wyɛ́ meko abɛɛ́ ne geŋgbɔ́, ne mbɔgé amɛ jií apɔ́ chánchá agɛne gemua mbaá meko. ");
INSERT INTO anvNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Muú abɔ manchɛré chánchá agɛ́ nnó geŋgbɔ́ ɛyigé ji afɛré nnó agɛne gépɔ́ fɔ́ lé gemua. ");
INSERT INTO anvNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Mbɔgé muú akwɔlégé geŋgbɔ́ wáwálé, ayi depɔ tií délá pɔ́ né gemua, geŋwá jií geko gebɛ́ɛ nyɛ́ pópó ndɛre mewɛ́ ɛgɛ́nege né gemua.” ");
INSERT INTO anvNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Ndɛre Jisɔs alú ajɔ́ge mbɔ, muú Farasi fɔ akú ji nnó ajyɛ́ anyɛ́ menyɛɛ́ ne ji né gepú jií. Ajyɛ kpɛ́ ajwɔlé, ɛbwɔ́ álɔ manyɛ́ menyɛɛ́. ");
INSERT INTO anvNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Muú Farasi yimbɔ agɛ́gé nnó Jisɔs alɔ manyɛ́ menyɛɛ́ ayi álá shwɔné amu wɔ́ ala meno mekpo fuú. ");
INSERT INTO anvNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Jisɔs aké ne ji, “Ɛnyú bɔɔ́ Farasi dewya matɔɔ́ nchyɛ ne usée. Néndé gepɔge nyú gélu ɛké muú ayi ashwɔnege meso amo ne uchwɛri menyɛ́, yɛ́mbɔ né mmu, abelege unó bi ji abɔɔ́ né mati mabomabo. ");
INSERT INTO anvNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Ama jɔ́ɔ aké: Ɛnyú delu ukeŋkené bɔɔ́. Ɛnyú dekaá fɔ́ nnó Ɛsɔwɔ yi akwyɛ́ meso genó ji ne akwyɛ́ ntó mmu wɔ́? ");
INSERT INTO anvNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Genó ɛyigé ɛnyú débɔɔ́ mampyɛ gélú nnó, bɔ́ge genó ɛyigé gelu mmu bɔ akpáŋkpa menyɛɛ́ nyú déchyɛ́ mbaá bɔɔ́ gekpo. Ɛ́fɛɛ́ matɔɔ́ nyú ntó ábɛ́ nyɛ́ pópó né depɔ deko. ");
INSERT INTO anvNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Utóŋkwa úlú ne ɛnyú bɔɔ́ Farasi. Ɛnyú dekarege menyɛɛ́ yi dékpáne né makɔɔ́ nyú dékaré malú afya, déchyɛ Ɛsɔwɔ melú ɛma. Yɛ́mbɔ depyɛ́ unó ɛbí úlú cho mbaá bɔɔ́ ne dejinte mangbógé ne Ɛsɔwɔ. Pyɛge ukpɛ́kpɛ́ unó bina. Yɛ́mbɔ délyage fɔ́ manchyɛ ɛchyɛ ɛwé ɛnyú debɔ dechyɛge mɛ. ");
INSERT INTO anvNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Utoŋkwa úlú ne ɛnyú bɔɔ́ Farasi degboó mánjwɔ́lé malú ujwɔ́lé ayi ɛ́nógé né mmu macha mmyɛmenɛne ne dekɛlege nnó bɔɔ́ átámégé ɛnyú ne ɛ́nógé ne matoó gese. ");
INSERT INTO anvNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","“Utóŋkwa úlú ne ɛnyú, délu ɛké manome ayi álu bibi. Bɔɔ́ ákɛ́ne mfaá ákaá fɔ́ nnó ákpáne mbɔ lé getoó wɔ.” ");
INSERT INTO anvNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Jisɔs anérégé manjɔɔ́ depɔ ɛtí, Ménlɛré mabɛ́ Ɛsɔwɔ ama aké, “Ménlɛré ɔ́jɔɔ́ge mbɔ depɔ ɛtíré na, ɔshyɛ mbɔntó ɛsé.” ");
INSERT INTO anvNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Jisɔs ashuú ji meko ake, “Utóŋkwa úlú ntó ne ɛnyú Ánlɛré mabɛ́ Ɛsɔwɔ, ɛnyú denɛrege bɔɔ́ matuú ayi ánɔɔ́ nnó ákpa, mánwɔ́ ɛbwɔ́ yɛ́ dachyɛ́ déwɔ́lé. ");
INSERT INTO anvNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","“Utóŋkwa úlú ne ɛnyú; ɛnyú dékwyɛge manómé bɔɔ́ ɛkpávé Ɛsɔwɔ abi antɛ nyú abɔ́ áwané, yɛ́mbɔ deshya meko mejɔɔ́ ɛbwɔ́. ");
INSERT INTO anvNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Mámpyɛ mbɔ ɛnyú degame mbɔ lé antɛ nyú né unó bi ɛbwɔ́ ábɔ́ ápyɛ́. Áwá bɔɔ́ ɛkpávé Ɛsɔwɔ, nána dékwyɛge manome bwɔ́. ");
INSERT INTO anvNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Ɛsɔwɔ mfwa déŋgá né gétú ɛyígé mbɔ aké, ‘Ntɔme nyɛ́ ɛbwɔ́ bɔɔ́ ɛkpávé ne áŋgbá bá. Ɛbwɔ́ áchyɛ́ge nyɛ gentɔgé bɔɔ́ ba bimbɔ ɛfwyale ne áwáne nyɛ́ abifɔ.’ ");
INSERT INTO anvNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Ɛlé njɛ ɛníné na ne Ɛsɔwɔ agíge nyɛ́ ɛbwɔ́ gewu ɛyigé bɔɔ́ ɛkpávé bií, abi bɔɔ́ álɔɔ́ manwáné tɛ mme yina alɔɔ́ úla, kpaá tɛ nána. ");
INSERT INTO anvNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Álɔ nyɛ́ mángii manoó mewené Ɛbɛl ákwɔné ami Sakariya ayi ɛbwɔ́ áwáné ji né mmu ɛcha upɛ Ɛsɔwɔ, metɔɔ́metɔɔ́ geluɔ́ ɛyigé ápyɛ upɛ ne melu ɛwé bɔɔ́ álá kpɛ́né tametame. Ngarege ɛnyú wáwálé nnó Ɛsɔwɔ alɔ nyɛ́ mángígé njɛ ɛniné na gewugé bɔɔ́ abi áwané. ");
INSERT INTO anvNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Utóŋkwa úlú ne ɛnyú Ánlɛré mabɛ́ Ɛsɔwɔ. Debí ɛgbɔ́gɔ́lɔ́ menómbi ɛwé muú akoógé ne akaá Ɛsɔwɔ. Ɛnyú ambɔɔ́ dékɛ́légé fɔ mankoó wyɛ́ dekaá uchánchá bii, wyɛmbɔ ntó ne dégbɛɛ́ bɔɔ́ abi akɛlégé mankoó wyɛ.” ");
INSERT INTO anvNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Jisɔs anérégé uno ɛbi manjɔɔ́, ɛké ɛwyage atané dafyɛ, Ánlɛré mabɛ́ Ɛsɔwɔ ne bɔɔ Farasi áshulé ji mmyɛ, ágií ji bɔ nkwɛ́ ne gejamégé depɔ nnó áwú ɛwé ɛ́tánege nyɛ ji meno. ");
INSERT INTO anvNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Ágige ji mbɔ nnó akwegé nekwené menó ne ɛbwɔ́ ammá ji mechɔ mmyɛ. ");
INSERT INTO anvNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Ndɛre Jisɔs alú jɔ́ɔge depɔ ɛti, gejamégé bɔɔ́ áchwɔ nɔ́ ji mme, ájá ɛké ushyɛ tɛ áŋmɛ́rege atɛ. Jisɔs abwɔlé kpɛ́ ushu ne baá utɔɔ́ bií aké, “Sɛge gébé ne gepɔ ɛyigé bɔɔ́ Farasi áwyá, álú lé bɔɔ́ dembwɔ́lé. ");
INSERT INTO anvNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Kaáge nnó genó gefɔ gépɔ́ ɛyigé ákwérégé gejí, bɔɔ́ álá gɛ́né nyɛ ne ɛyígé ábigé ntó géjí bɔɔ́ álá kágé nyɛ gépɔ́. ");
INSERT INTO anvNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Ɛ́byɛnnó, depɔ deko ɛtiré ɛnyú dejɔ́ɔge lé né metɔɔ́ utuú, áwúu nyɛ́ détí bií gbɔɔ́. Ne depɔ ɛtiré ɛnyú degbɛ gepú dejɔ́ɔge geju, bɔɔ́ ako áwúu nyɛ́ détí. ");
INSERT INTO anvNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Ajeé ba, ngarege ɛnyú nnó défɔ́gé fɔ́ bɔɔ́. Ákáge wá lé muú wáne ne ákáge pyɛ́ ɛsé genó ɛyigéchá. ");
INSERT INTO anvNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Ngarege nyɛ́ ɛnyú muú yi debɔɔ́ mamfɔ. Fɔ́ge lé Ɛsɔwɔ ayi awagé muú, alú wyá uto mamfúmé muú yimbɔ né mewɛ ɛwé ɛ́lá nómégé. Ngarege ɛnyú wáwálé nnó ji ne alú muú ayi debɔɔ́ mamfɔ. ");
INSERT INTO anvNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“Pɔ ɛnyú dekaá nnó akpóo baá denywɔné átá ne ŋka ɛyi ɛ́lá fuú yɛ́ genó wɔ́. Yɛ́mbɔ Ɛsɔwɔ abya yɛ maá ɛnwyɔ́né ama wɔ́. ");
INSERT INTO anvNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Ne ɛnyú, Ɛsɔwɔ akaá mpa déŋkaáré mejwɛ ɛti délú yɛ́ndémuú nyú mekpo. Dechyɛgé gemɛ genyú ɛfwyale néndé deŋeá gemɛ né mbɛ ushuú Ɛsɔwɔ dépwɔ ɛkwɔ́ denwyɔné. ");
INSERT INTO anvNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Ngarege ɛnyú nnó yɛ́ndémuú ayi ágárege gbɔ́ŋɔ́nɔ́ né mbɛ ushu bɔɔ́ nnó alu muú wa, Maá Ntɛ Mekwaá ntó akamege nyɛ́ né mbɛ ushu makiɛ́nné Ɛsɔwɔ nnó muú yimbɔ alu awuú. ");
INSERT INTO anvNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Yɛ́mbɔ, yɛ́ndémuú ayi áshyágé né mbɛ ushu bɔɔ́ nnó akágé me, nshyaá nyɛ́ ntó ji né mbɛ ushu makiɛ́nné Ɛsɔwɔ. ");
INSERT INTO anvNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“Génó géma ɛyigé débɔɔ́ mankaá gélú nnó, Ɛsɔwɔ akage jiínte gabo muú ayi ájɔɔ́ge mejɔɔ́ mebomebo ne Maá Ntɛ Mekwaá, yɛ́mbɔ muú ayi ájɔ́gé mejɔɔ́ mebomebo ne Mendoó Ukpea, Ɛsɔwɔ ájígé fɔ́ nte gabo wuú. ");
INSERT INTO anvNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Kaáge nnó gébé gékwɔ́nege nyɛ ɛyígé ápyɛ́ne ɛnyú muú ama ama mánjyɛ tɛ́ne unɔɔ́ mpa né macha mmyɛmenɛne, ámáge sɛ́ ɛnyú nnó détɛ́né mbɛ ushu afwa melɔ ne bɔ gɔ́mena. Gébé ɛyígémbɔ gekwɔnégé, désomégé fɔ́ nnó depyɛ nyɛ́ nnó ne dépoó gemɛ genyú, yɛ nnó dejɔ́ge nyɛ́ nnó. ");
INSERT INTO anvNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Né gébé ɛyigembɔ, Mendoó Ukpea ɛ́gárege nyɛ́ ɛnyú genó ɛyígé débɔɔ́ manjɔɔ́.” ");
INSERT INTO anvNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Ndɛre Jisɔs abɔ́ achyɛ́ge baá utɔɔ́ bií majyɛɛ́ na, muú fɔ né mmu ɛkwɔ́ bɔɔ́ ajɔɔ́ ake, “Ménlɛré, gáré meŋmɛ́ wa akáré geteégé ntɛ sé achyɛ́ ɛya.” ");
INSERT INTO anvNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Jisɔs akuú ji aké, “Mejeé, waá ake me mpáné bɔ mpa nyú ne nkáré geteé genyú?” ");
INSERT INTO anvNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Abwɔlé, ajɔɔ́ ne bɔɔ́ ako aké, “Sɛ́ge gébé, ɛkagé dénɛ́ré matɔɔ́ né unó mme dɔɔ́, néndé, geŋwágé muú gepɔ́ fɔ́ lé né unó bi ji awya. Yɛ́ ábɛ́ lé ne gefwa nnó?” ");
INSERT INTO anvNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Jisɔs ajɔ́ge mbɔ, ató ɛbwɔ́ nekanemejɔɔ́ ake, “Mfwa fɔ abɔ́ alu ayi awyá mekɔɔ́ wuú ɛwé ɛ́lɔmé menyɛɛ́ dɔɔ́. ");
INSERT INTO anvNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Agií gemɛ jií ake, ‘Mpyɛ nyɛ́ nnó? Mpɔ́ sé ne melú ɛwé mbélégé menyɛɛ́ wa. ");
INSERT INTO anvNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Ɛwyage ake, ‘Genó ɛyígé mpyɛ nyɛ́ gélú nnó.’ Mmu nyɛ utó ba, ntɛné ɛbi uŋea; mbélége nyɛ́ menyɛɛ́ ne mbwɛ́ menyɛɛ́ wa meko ɛfɛɛ́. ");
INSERT INTO anvNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Mpyɛgé mbɔ, njɔ́ge nyɛ́ ne gemɛ yá nnó nana njyɛ́ gbée mmyɛ. Nwya gejamé menyɛɛ́ ayi nnyɛɛ́ né gejamégé aŋmɛ. Njyɛ nyɛ́gé, nnyúgé mmɔɔ́ ne nnyɛ́gé geŋwá.’ ");
INSERT INTO anvNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Ndɛre áfɛ́régé mbɔ, Ɛsɔwɔ akuú mende yimbɔ ake, ‘Wɔ geŋkekenegé muú ásɛ́le geŋwá jyɛ́ ne utuú bína ne unó byɛ́ ɛbí ɔbelé, ulá nyɛ́ ɛbi wa?’” ");
INSERT INTO anvNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Jisɔs aké ne ɛbwɔ, “Wyɛ́ na ne ɛpyɛ́ nyɛ́ ne muú yi akɛ́légé unó uko nnó ubɛ́ ɛbií ayi álá akɛ́légé unó ɛbí mampyɛ depɔré Ɛsɔwɔ.” ");
INSERT INTO anvNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Jisɔs anérégé aké ne baá utɔɔ́ bií, “Ndɛre ɛlúmbɔ́, ngarege ɛnyú nnó dechyɛ́gé fɔ́ gemɛ ɛnyú ɛfwyalé mankɛlé genó ɛyigé dényɛ́ ne mandeé ayi défyɛɛ́ nyɛ. ");
INSERT INTO anvNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Kaáge nnó geŋwá ɛnyú geŋeá gepwɔ menyɛɛ́ ayi dényɛɛ́ ne menyammyɛ ɛnyú aŋeá apwɔ mandeé ayí défyɛɛ́. ");
INSERT INTO anvNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Pɛ́ge denywɔné, detí depɛné menyɛɛ́, déferege ne débélégé mbwɛ́. Dépɔ́ yɛ ne malu ayí débelege menyɛɛ́, ɛ́lé Ɛsɔwɔ ne achyɛ́ge détí menyɛɛ́. Ne ɛnyú deŋeá dɔ́ né amɛ Ɛsɔwɔ depwɔ́ denywɔné. ");
INSERT INTO anvNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Déchyɛgé gemɛ nyú ɛfwyale, ndé muú nyú ayi mesóme wuú ɛkáge gbɛ́ɛ yɛɛ́ bií uma né aŋmɛ ayi Ɛsɔwɔ achyɛ́ jí nnó débɛ́lé fá mme? ");
INSERT INTO anvNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Ɛpyɛ́ nnó ne ji amyɛ mambɛ́ ne unó uko ɛbi úchyɛ́ge ji geŋwá, ayi álá kaágé pyɛ́ yɛ ɛkɛ́kɛ́ genó ɛwéna? ");
INSERT INTO anvNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Pɛ́ge dégɛ́ unɔɔ́ mewaá ɛbi úkome ukoó ulɔ́úlɔ́ ndɛre úwɛ́né, úpyɛ́ fɔ́ utɔɔ́, ukwyɛ́ge yɛ mandeé. Yɛ́mbɔ ngarege ɛnyú wáwálé nnó yɛ Mfwa *Solomun ayi abɔ́ awyá unó uko, apɔ́ yɛ ne nkú ayi alɔmé akwɔné ukoó ɛbi unɔɔ́ bina. ");
INSERT INTO anvNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Mbɔgé Ɛsɔwɔ achyɛge bya mewaá bina ukoó ulɔ́úlɔ́. Bya ɛbí fina úlú ubɛ geyá úgbó atuú áfyɛ́ mewɛ, defɛré nnó ákágé chyɛɛ́ fɔ́ ɛnyú mandeé apwɔ ndɛre ji apɛle bya mewaá? Metɔɔ́ ɛwé ɛnyú defyɛɛ́ ne Ɛsɔwɔ ɛ́ŋené kpaá ɛ́pwɔ amu. ");
INSERT INTO anvNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Ɛbɛgé mbɔ, dechyɛ́gé fɔ́ gemɛ ɛnyú ɛfwyale mankɛ́légé genó ɛyigé dényɛɛ́ ne ɛyigé dényúu nyɛ́. ");
INSERT INTO anvNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Ɛ́lé bɔɔ́ bi álá kaágé Ɛsɔwɔ ne áchyɛ́ge gemɛ bwɔ́ ɛfwyale yɛndegébé mankɛ́légé unó bina. Kaágé nnó Ntɛ nyú Ɛsɔwɔ akaá mɛ nnó debɔ mambɛ ne ubi uko. ");
INSERT INTO anvNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Ne myɛ́ge mangɛ meti ɛwé Ɛsɔwɔ abɛɛ́ mfwa nyú, dépyɛgé mbɔ, achyɛge nyɛ ɛnyú unó bina uko. ");
INSERT INTO anvNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Baá ba, défɔgé, yɛ lé délá déja wɔ́, Ata Ɛsɔwɔ ajya mɛ́ ɛnyú nnó dényɛɛ́ geŋwá né mmu gefwa jií. ");
INSERT INTO anvNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Kpóge unó bi déwya uko, déchyɛ ŋka yimbɔ mbaá ubyá bɔɔ́. Kɛlege úba ɛbi ulá chɔ́gé, ɛwéna ɛlɛré nnó debéle gefwa genyú né mfaánebuú mbaá yi genó gélá kaáge ta. Yɛ́ menjó álá kaágé jó, yɛ ukyɛ úla kaágé nyɛ́. ");
INSERT INTO anvNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Kaáge nnó mbaá ayi muú ábélege gefwa jií, ɛfɛɛ́ ntó ne metɔɔ́ wuú ɛbɛ́ɛ. ");
INSERT INTO anvNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Kpómege mmyɛ lwɛge mawɛ álúli, ");
INSERT INTO anvNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","dégíle ndɛré bɔɔ́ ágíle ntɛ bwɔ́ nnó akéré meso né ɛpaá neba ɛwé ji ajyɛ́. Akérégé meso adogé menómbí ákáge néne ji ɛ́wu tɛ́nétɛ́né. ");
INSERT INTO anvNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Ɛ́fwɔ́ ɛ́lú né baá defwɛ́ abi ntɛ bwɔ́ akerégé meso, ábánege ɛbwɔ́ peé! Ngarege ɛnyú wáwálé nnó, akpomege nyɛ́ mmyɛ, agaré ɛbwɔ́ nno ájwɔ́lé ka ji akpá menyɛɛ́ achyɛ́ ɛbwɔ́ ányɛ́. ");
INSERT INTO anvNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Ɛ́fwɔ́ ɛ́lú né baá defwɛ́ abi mbɔgé mbɔɔ́ gepú achwɔgé, yɛ ne metɔɔ́ utuú yɛ gejyɛ́jyɛ́gé bí, ábánege ɛbwɔ́ peé. ");
INSERT INTO anvNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","“Kaáge nnó mbɔgé mbɔɔ́ gepú akaáge gébé ɛyigé menjó achwɔɔ́ gyá nyɛ́ geji akpɛ́ mmu, mbɔ́ ajwɔlé abame géjí nnó menjó akáge achwɔ́ agyá akpɛ́ mmu. ");
INSERT INTO anvNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Ɛnyú ntó kpómege mmyɛ, gétúgé Maá Ntɛ Mekwaá akerege nyɛ́ meso né gébé ɛyígé délá dékágé.” ");
INSERT INTO anvNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Pita akuú Jisɔs aké: Átá, “Ɔtó mbɔ nekanémejɔɔ́ ɛni né ɛta ɛsé waá mbaá bɔɔ́ ako?” ");
INSERT INTO anvNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Ata ama lɔ́ mangaré ɛbwɔ́ ake, “Bɛge ndɛre maá utɔɔ́ ayi awyaá deŋga, apyɛ utɔɔ́ bií chánchá. Ntɛ wuú alyaáge ji ne baá defwɛ́ abifɔ nnó apɛ́lé ɛbwɔ́, achyɛge ɛbwɔ́ menyɛ́ chánchá né gébé gelɔ́gélɔ́. Maá utɔɔ́ yiná alu ndé gefɔgé muú? ");
INSERT INTO anvNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Galɔ́gálɔ́ abɛɛ́ nyɛ ne maá defwɛ́ yimbɔ, gébégé ntɛ wuú akerégé meso agɛ́ne nyɛ nnó ji apyɛ utɔɔ́ bií chánchá. ");
INSERT INTO anvNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Ngarege ɛnyú wáwálé nnó ntɛ wuú abelege nyɛ ji ndɛre muú kpaá né unó bi ji awyaá uko nnó apɛ́lé. ");
INSERT INTO anvNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Ne mbɔgé maá utɔɔ́ yimbɔ abɛgé ayi áwyaá gepɔ gebogebo, ajɔ́ge nyɛ ne gemɛ jií aké, ‘Ntɛ wa abɛlege nyɛ dɔɔ́ ne achwɔ́,’ ne alɔ nyɛ́ mantúlégé baá defwɛ́ abifɔ, andée ne ande ne manyɛɛ́gé menyɛɛ́ ne manyúgé mmɔɔ́ tɛ mapyɛ́ne ji. ");
INSERT INTO anvNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Mbɔgé apyɛ́gé mbɔ, ntɛ maá utɔɔ́ yimbɔ achwɔ kwɔ́ nyɛ ji neŋmé né gébé ɛyígé ji álá kaá nnó achwɔ́ wɔ́. Abanégé ji mbɔ, achyɛge nyɛ ji gekpɛ́kpɛ́ ɛfwyale ɛwé ɛbɔɔ́ ɛpwɔɔ́ amu nnó ájyɛ́ ábáné bɔɔ́ ubée ");
INSERT INTO anvNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Maá defwɛ́ ayi akaágé genó ɛyígé ntɛ wuú akɛ́lege nnó ji apyɛ ne álá pyɛ géjí wɔ́, ntɛ wuú agarege nnó ábwɔ́lé ji ula ádó cháŋéné. ");
INSERT INTO anvNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Mbɔgé maá utɔɔ́ alu ayi apyɛgé gyɛ́ né mechɔ́ ɛwé akpáne matúlé, yɛ́mbɔ ɛlé alá kaá genó ɛyígé ntɛ wuú akɛ́lege wɔ́, ajií matúlé ájámé. Ɛnyú debɔ́ mankaá nnó muú yi áchyɛgé ji gekpɛ́kpɛ́gé genó, ji ne amɛ mako apɛ́le. Muú yi áchyɛ́ge ji genó ɛyígé mbɔ́, ji ne áchɛ́rege ji cháŋéné.” ");
INSERT INTO anvNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Jisɔs ama jɔɔ́ nnó, “Nchwɔ́ né mme yiná manlwɛɛ́ mewɛ, ne mbɔgé ɛ́bɔ́ ɛ́lɔ mɛ́ manlúlé, mbɔ́ metɔɔ́ ɛ́gɔ́ɔ me. ");
INSERT INTO anvNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Áfyɛ́ nyɛ́ me né ɛfwyale wyɛ́ ndɛre áfyɛ́ muú mmú nnyi nnó awɔ́ manaá Ɛsɔwɔ. Wyɛ́ kpaá depɔ ɛtí dékogé ne metɔɔ́ wa ɛ́kwené. ");
INSERT INTO anvNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","“Ɛnyú defɛré nnó nchwɔ́ fá mme mámpyɛ nnó bɔɔ́ ábɛ́ nesɔ ne atɛ? Kaáge nnó nchwɔ lé mampyɛ bɔɔ́ áfá mbwa ne atɛ. ");
INSERT INTO anvNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Lɔ nána ɔjyɛ́gé mbɛ, bɔɔ́ ábɛgé makpó áta né ulá gepú, ákárege nyɛ́, álɛ́ ábɛɛ́ nyɛ́ né ɛ́gbɛ́ wá, ápea áshyá nyɛ́ me. Mbɔgé ápea álú ɛ́gbɛ́ wá, álɛɛ́ áshyá nyɛ́ me. ");
INSERT INTO anvNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Ntɛ ashya nyɛ́ manwú mechɔ́ ne maá wuú ayi mende, maá ayi mende ntó ashya nyɛ́ manwú mechɔ́ ne ntɛ wuú. Mmá ashya nyɛ́ ɛwé maá wuú ayi mendée, maá ntó ashya nyɛ́ ɛwé mmá. Ŋmogétá ashya nyɛ́ ɛwé mendée maá wuu, mendée maá wuú ntó ashya nyɛ́ ɛwé ŋmogétá wuú.” ");
INSERT INTO anvNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Jisɔs ama jɔɔ́ ne ɛkwɔ́ bɔɔ́ aké, “Ɛnyú degɛgé gekó yɛndégébé géké génywérege dejɔgé deké, ‘Manaá achwɔ kwé. Ne akwene ntó.’ ");
INSERT INTO anvNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Yɛ́ndégébé degɛgé nnó, ‘Gefwene nebá gélé chwɔ́’ dekaá nnó genɔme gechwɔ jyá. Ne mbɔntó ne ɛ́bɛ́ɛ. ");
INSERT INTO anvNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Ɛnyú bɔɔ́ dembwɔ́lé, ndɛre dépɛ́le mfaá ne mme délóo ndɛre bií ubɛ́ nyɛ́. Ɛpyɛ nnó ne ɛnyú delá gɛ́né unó bí Ɛsɔwɔ apyɛ́ mbɔ né gébé ɛyí? ");
INSERT INTO anvNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Ɛnyú ambɔɔ́ dekágé fɛ́re fɔ́, dékáa genó ɛyí gélú cho ɛyígé débɔɔ́ mampyɛ? ");
INSERT INTO anvNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Mbɔgé muú nyú abɔgé ɛfwyale ne muú mawámé wuú, ne muú yimbɔ ajyɛge kpó ji né ɛso, abɔ mankwɔ́ ji mata nnó ajá mechɔ́ ɛwémbɔ meso ndɛre ɛbwɔ́ alú jyɛ́ɛ jyɛ́ɛ. Ɛ́bɛgé alá pyɛ́mbɔ wɔ́ mbɔɔ́ ujwɔɔ́ ajyɛ nyɛ́ ne ji mbaá mémpané mpa. Ne mempané mpa afyɛ ji né amú bɔɔ́ bɔ nku, ne bɔɔ́ nkú áfyɛɛ́ nyɛ ji denɔ. ");
INSERT INTO anvNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Ngarege ɛnyú nnó, átánégé nyɛ́ denɔ ɛtirémbɔ kpaá tɛ ákwɔ́le ujwɔɔ́ bimbɔ uko.” ");
INSERT INTO anvNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Né gébé ɛyigémbɔ, bɔɔ́ áchwɔ gáre Jisɔs mechɔ́ fɔ́ ɛwé ɛbɔ́ ɛpyɛɛ́ ne bɔɔ́ Galilií fɔ́. Ndɛre ɛbwɔ ápyɛ́ upɛ, Palɛt Gɔ́mena né Rom, atɔ́ bɔɔ́ nnó áwá ɛbwɔ́. Ájyɛge áwá bɔɔ́ bimbɔ ne manoó bwɔ́ macho ne amí menya ɛyí ápyɛ́ upɛ. ");
INSERT INTO anvNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Jisɔs awúgé mbɔ agií aké, “Défɛré nnó bɔɔ́ abi ágbó mbɔ, ɛlé ápyɛɛ́ ubeé ápwɔɔ́ bɔɔ́ Gálilí abifɔ? ");
INSERT INTO anvNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Ɛpɔ́fɔ́ mbɔ. Ngarege ɛnyú nnó: Mbɔgé délá *kwɔré matɔɔ́ nyú wɔ́, deniíge nyɛ́ gemɛ nyu geko nka ama. ");
INSERT INTO anvNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Tége genó ɛyí gépyɛ́ né melɔ́ Silɔm. Ɛnyɔŋ ɛkwé ɛ́wá bɔɔ́ nekwuneálɛ́ɛ. Défɛré nnó bɔɔ́ bí ágbó mbɔ, ɛ́lé ɛbwɔ́ ápyɛɛ́ ubeé dɔɔ́ ápwɔ́ bɔɔ́ Jɛrosalɛ abifɔ? ");
INSERT INTO anvNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Ɛpɔ́fɔ́ mbɔ. Ngarege ɛnyú nnó, Mbɔgé delá kwɔré matɔɔ́ nyú wɔ́, deniíge nyɛ́ gemɛ nyu geko nka ama.” ");
INSERT INTO anvNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Ne Jisɔs agaré ɛbwɔ́ nekanémejɔɔ́ ɛni ake, “Mende fɔ abɔ́ apɛ genɔɔ́ gefɔ́ né mekɔɔ́ wuú, gébé gékwɔ́négé ajyɛ pɛ nnó genɔɔ́ ɛyigémbɔ gewɔ ne ji akyɛ́ umpomé ne yɛ géma agɛ́ wɔ́. ");
INSERT INTO anvNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Né gébé ɛyigéfɔ, ajɔɔ́ ne muú utɔɔ́ wuú aké, ‘Aŋmɛ́ álɛ́ mbɔ alɛɛ́ ayi nchwɔ́ɔ mankyɛ́ umpomé fá né genɔɔ́ ɛyi ne yɛ gefɔ́ ngɛ́né. Kɛ géjí gékwé, géfɔɔ́ mbaá detú.’ ");
INSERT INTO anvNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Muú utɔɔ́ aké, ‘Atá, nnɛ wɔ mmyɛ, ma lyaá géjí gébɛ́ né ŋmɛ néma. Nchome nyɛ́ ula bií ngyá, ngbɛle ujwaá wyɛ́. ");
INSERT INTO anvNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Mbɔgé ŋmɛ néchá gewɔgé ɛlɔ́, gélágé wɔ wɔ́ ɔkágé kɛ́ geji ɔŋmé mme.’” ");
INSERT INTO anvNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Bií uwyaá bɔɔ́ Jus fɔ́ úkwɔ́négé Jisɔs abɔ́ alɛrege bɔɔ́ né mmu ɛcha mmyɛmenɛne. ");
INSERT INTO anvNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Mendée fɔ abɔ́ alu ɛ́fɛɛ́, ayi meló nchyɛ ájyálé ji gempyó, ála kɛ pyópyó. Ameé né aŋmɛ nekúuneálɛɛ́ ne akágé nyaá mmyɛ akɛ́ cho. ");
INSERT INTO anvNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Jisɔs agɛ mendée yimbɔ, akuú ji ne aké ne ji, “Mmá lɔ nána ɔjyɛ́gé mbɛ nemée nɛɛ́ nébyɛ́.” ");
INSERT INTO anvNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Ajɔ́ge mbɔ anɛré ji ɛbwɔ mmyɛ, tɛ́né tɛ́né mendée yimbɔ atoó, anyaá mmyɛ atɛné cho, alɔ mamfɛ́gé Ɛsɔwɔ. ");
INSERT INTO anvNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Muú kpaá né ɛcha mmyɛmenɛne agɛ́gé nnó Jisɔs apyɛ mendée yiná atoó bií uwyaá bwɔ, metɔɔ́ ɛ́sɔ́ ji. Alɔ manwégé bɔɔ́ aké, “Ndɔ́ ɛ́lú ɛ́kéné ɛyí bɔɔ́ ápyɛ utɔɔ́. Chwɔ́ge lé né ndɔ yimbɔ nnó ápyɛ ɛnyú detoó. Muú amagé chwɔ́ sé né bií uwyaá.” ");
INSERT INTO anvNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Átá Jisɔs aké ne ji, “Ɛnyú bɔɔ́ dembwɔ́lé! Yɛ́ndé bií uwyaá, yɛ́ndémuú nyú, akágé ná mpɔ wuú nnó ajyɛ́ ányú manaá? ");
INSERT INTO anvNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Mechɔ́ ɛwé mendée yina ɛ́lú nnó alu mpyáne Abraham, ne danchɔmeló afyɛ ji né ɛfwyale né aŋmɛ nekúuneálɛ́ɛ. Ɛ́pɔ́ galɔ́gálɔ́ nno áféré ji né ɛfwyale bií uwyaá?” ");
INSERT INTO anvNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Jisɔs ajɔ́gé mbɔ, bɔɔ́ mawámé bií mmyɛ́ ɛ́gbó ɛbwɔ́ yɛ́mbɔ gejamégé bɔ́ álú ne nechɔ́chɔ́ né ufélekpá ɛbi Jisɔs apyɛ́ɛ. ");
INSERT INTO anvNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Ne Jisɔs agií gemɛ jií aké, “Gefwage Ɛsɔwɔ gélú mbɔ nnó? Mmɛge ná geji ne ndé? ");
INSERT INTO anvNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Gélú nkane mbeé mbwɛ́ ayí ákuú mɔsta, ɛníné muú abɔɔ́ apɛné né mekɔɔ́ wuú. Néchígé, néwɛ́, nébwɔlé gekpɛ́kpɛ́gé genɔɔ́ ne denywɔné détɛ́nege anyua bwɔ́ wyɛ́.” ");
INSERT INTO anvNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Jisɔs ama gíi gemɛ jií aké: “Mmage mɛ́ɛ na gefwage Ɛsɔwɔ ne ndé? ");
INSERT INTO anvNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Gelú ntó nkane yis uka ɛbi upyɛ brɛd amualé ɛbi mendée abɔ achwaré ne gejamégé flawa abɛlé kpaá tɛ flawa meko amuále.” ");
INSERT INTO anvNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Jisɔs alú kɛ́ne ajyɛ né Jɛrosalɛ. Ndɛre ajyɛ́, akoge malɔ́málɔ́, alɛrege bɔɔ́ mekomejɔɔ́ Ɛsɔwɔ. ");
INSERT INTO anvNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Muú fɔ agií ji aké, “Ata, bɔɔ́ bií ányɛɛ́ nyɛ́ geŋwá ɛyí gélá gébyɛ́ ábɛɛ́ nyɛ́ ɛ́lé gachyɛ́?” Ne Jisɔs aké ne bɔɔ́ ako, ");
INSERT INTO anvNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Ɛnyú myɛ́ge lé mamkpɛ né menómbi ɛwé ɛ́lú mámálé nnó depó. Néndé ngarege ɛnyú nnó gejamégé bɔɔ́ ámuáme nyɛ mamkpɛ, ne metí ɛ́bɛ́ nyɛ. ");
INSERT INTO anvNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Gébé gékwɔ́nege nyɛ, ɛyígé mbɔɔ́ gepú akwilege ka, agbɛ́ menómbi. Gébégé agbɛgé ɛwú, ɛnyú bí délaá dafyɛ denóme nyɛ menómbi dekuú nnó, ‘Ata, néné ɛsé menombi.’ Ne ajɔge nyɛ ne ɛnyú aké, ‘Nkágé fɔ́ mbaá yi ɛnyú detané.’ ");
INSERT INTO anvNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Ɛnyú delɔ nyɛ manɛné mmyɛ deké, ‘Pɔ́ ɛsé debɔ́ dejwɔlé mbaá ama ne wɔ, denyɛ́ menyɛɛ́, denyú mmɔɔ́? Pɔ́ ɔbɔ́ ɔ́chwɔ́ né melɔ sé ɔgarege bɔɔ́ mekomejɔɔ́ Ɛsɔwɔ?’ ");
INSERT INTO anvNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Yɛ́mbɔ ashúge nyɛ ɛnyú meko nnó, ‘Ngarege ɛnyú, nkágé fɔ́ mbaá yi détané. Kwílege me ushuú. Ɛnyú dekɛne depyɛ nchyɛ!’ ");
INSERT INTO anvNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Ne degɛne nyɛ Abraham, Asek, ne Jakɔb chónchó ne bɔɔ́ ɛkpávé Ɛsɔwɔ ako ndɛre ájwɔlé mbaá ayi Ɛsɔwɔ ágbárége gefwa jií, ɛnyú delile nyɛ, ne denyɛɛ́ máŋɛ́né ne matɔɔ́ usɔɔ́. ");
INSERT INTO anvNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Né gébé ɛyígémbɔ bɔɔ́ átánege nyɛ né umɛ malɔ mme mako, manyɛ gefwa ɛyigé Ɛsɔwɔ ágbárege. ");
INSERT INTO anvNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Kaáge nnó bɔɔ́ fɔ abi anóge mbɔ ɛbwɔ́, álaá nyɛ bɔ apɔ́ mpa ne bɔɔ́ abi álu bɔ apɔ mpa álaá nyɛ afwa.” ");
INSERT INTO anvNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Wyɛ́ né gébé ɛyígémbɔ, bɔɔ́ Farasi fɔ́ áchwɔ garé Jisɔs áké, “Kwélé fa chó geba ɛyigéchá néndé Mfwa *Hɛrɔd akɛlege manwá wɔ.” ");
INSERT INTO anvNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Jisɔs aké ne ɛbwɔ́, “Chóge dégáré muú defyá yimbɔ nnó, ji akaá nnó mferege aló nchyɛ fína mmage mpyɛ bɔɔ́ mamée átoó ne wyɛ́mbɔ ne mmáge pyɛ́ geyá. Fí ndɔ ɛ́lɛ́ ne nnérege utɔɔ́ ba. ");
INSERT INTO anvNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Yɛ́mbɔ yɛlé mbɔ́ njɔɔ́, mbɔ́ manlyá fina njyɛ Jɛrosalɛ, nkɛne nekɛ geyá ne ndɔ́ ɛpéa. Ɛ́lɔ́mé fɔ nnó áwá muú ɛkpávɛ́ Ɛsɔwɔ né mbaá yichá ɛ́kosé né Jɛrósálɛ wɔ́.” ");
INSERT INTO anvNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Jisɔs alɔ mánsómégé ake, “Ɛ ɛ́ Jɛrosalɛ, Ɛ ɛ́ Jɛrosalɛ, dewane bɔɔ́ ɛkpávé Ɛsɔwɔ ne detome abifɔ ne mataá, bɔɔ́ dentɔɔ́ abi Ɛsɔwɔ atɔmé ɛta nyú! Mmua mɛ́ ndɔ ndɔ ne ndɔ, manyweré ɛnyú nkwere nkane mekwɔ akwérege baá bií, yɛ́mbɔ ɛnyú dékɛ́légé fɔ́. ");
INSERT INTO anvNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Gɛ́ge yɛ́ nnó, melɔ nyú ɛ́la mɛ́ mábɔ́mé. Ne ngarege ɛnyú nnó, ɛlɔ fina ɛjyɛ́gé mbɛ, ɛnyú démágé gɛ́sé me kpaá tɛ bií ɛbi ɛnyú dejɔ́ge nyɛ nnó, ‘Mejé ɛ́bɛ́ ne muú ayi achwɔ́ɔ né mabɔ Atá!’” ");
INSERT INTO anvNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Né bií uwyaá ɛbífɔ́, Jisɔs ajyɛ nyɛ́ menyɛɛ́ né gepúgé mende fɔ. Mende yimbɔ abɔ́ alu muú kpaá bɔɔ́ Farasi. Ndɛre Jisɔs alú ɛ́fɛɛ́, bɔɔ́ ápɛ́le ji chwɛchwɛ, nnó ágɛ́ genó ɛyíge ji apyɛ nyɛ bií bimbɔ. ");
INSERT INTO anvNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Ɛ́fɛɛ́ mende fɔ ayi uká ne amu úmualé, abɔ́ atɛné mbɛ ushu Jisɔs, ");
INSERT INTO anvNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Jisɔs agií bɔɔ́ Farasi ne Ánlɛré mabɛ́ Ɛsɔwɔ abi álú ntó ɛfɛɛ́ aké, “Ɛbɛ́ ɛsé ɛgaré nnó muú akage pyɛ muú nemée atoó né bií uwyaá?” ");
INSERT INTO anvNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Yɛ́mbɔ ɛbwɔ́ akeré yɛ ji meko wɔ́. Ne Jisɔs agbaré mende yimbɔ apyɛ ji atoó, agaré ji nnó ajyɛ́. ");
INSERT INTO anvNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Ɛké ɛ́wyage Jisɔs agií ɛbwɔ aké, “Mbɔgé muú nyú fɔ ne maá wuú akwegé né gepyɛ́gé manaá bií uwyaá, yɛ ɛ́lé mpɔ wuú ne akwené, muú yimbɔ anyógé wáwá akpɛ́ mmu aféré ji?” ");
INSERT INTO anvNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Nkwɛ́ yiná apwɔ ɛbwɔ́ amu, apyɛ ɛbwɔ́ ála bɔmbɔ. ");
INSERT INTO anvNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Jisɔs agɛ́gé nnó bɔɔ́ abi álɔɔ́ bwɔ́ ɛpaá, áchwɔ́ge ájyá lé malu ujwɔlé malɔ́malɔ́, agaré ɛbwɔ́ nekanémejɔɔ́ ɛni aké: ");
INSERT INTO anvNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Yɛ́ndegébé ákugé muu né ɛpaá neba ajwɔ́lé lé né melu ɛwé bɔɔ́ ako ájwɔ́lege. Akɛlégé fɔ́ melú ɛ́nógé. Mbɔgé ɔjwɔlégé wyɛ́, ɛ́káge bɛ́ nnó ákuú mbɔntó muú yi apwɔɔ́ wɔ. ");
INSERT INTO anvNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Gébégé muú yimbɔ achwɔgé, mbɔɔ́ ɛpaá agarege nyɛ́ wɔ nnó, ‘kwílé melu ujwɔ́lé ɛwe, muú kpaa ajwɔ́lé.’ Mbɔgé ɛ́pyɛ́gé mbɔ ɔjwɔlege nyɛ́ né melú ɛwé ɛ́lá pɔ́ ne ɛ́nógé, ɛ́fɛɛ́ mmyɛ́ ɛ́gbóo nyɛ́ wɔ. ");
INSERT INTO anvNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Yɛ́ndégébé ɔjyɛgé ɛpaá, jwɔ́lé né melu ɛwé ɛ́lá pɔ́ ne ɛ́nógé. Gébégé muú yi alɔ wɔ́ ɛpaá achwɔgé gɛ́ wɔ́ ɛ́fɛɛ́, ajɔge nyɛ́ ne wɔ nnó, ‘Mejeé wa, kwílé fá chó jwɔlé né melú ɛ́nógé.’ Gébégé ɛ́pyɛgémbɔ ɔbɛɛ nyɛ ne ɛ́nógé né mbɛ ushu bɔɔ́. ");
INSERT INTO anvNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Wyɛ́mbɔ ne Ɛsɔwɔ áwane nyɛ́ muú ayi ábwɛge mmyɛ gelu ne ábwɛge nyɛ́ lé ayi álá lɛ́régé mmyɛ.” ");
INSERT INTO anvNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Jisɔs ama jɔɔ́ ne mbɔɔ́ ɛpaá yi akuú ji aké, “Yɛndégébé ɔké ɔpyɛ ɛpaá, ɔkugé fɔ wyɛ́ lé ajeé byɛ́, aŋmɛ́ byɛ́ ne bɔɔ́ ula gepú byɛ́. Ɔkugé fɔ wyɛ lé afwa melɔ gétúgé ɛbwɔ́ ákáge kuú nyɛ́ wɔ ntó né ɛwu bwɔ́ ɛpaá. Ápyɛgémbɔ áshúge wɔ galɔ́gálɔ́ ayi ɔpyɛ́ ɛta bwɔ́. ");
INSERT INTO anvNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Ɔké ɔpyɛ ɛpaá, kuú lé bɔɔ́ gekpo, ubwéré, ukɔ́kɔ́ré bɔɔ́ ne abi amɛ nónómé. ");
INSERT INTO anvNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Mbɔgé ɔpyɛgé mbɔ, ɔbɛ nyɛ́ ne metɔɔ́ megɔmegɔ gétúgé bɔɔ́ bimbɔ ákágé shúu fɔ galɔ́gálɔ́ ayi ɔpyɛ́ ɛta bwɔ́. Galɔ́gálɔ́ wyɛ́ atanege nyɛ́ mbaá Ɛsɔwɔ né gébé ɛyígé bɔɔ́ abi álu cho ákwilege nyɛ né negbo.” ");
INSERT INTO anvNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Ndɛre Jisɔs ajɔge mbɔ, muú fɔ ama ayi abɔ́ anyɛɛ́ menyɛɛ́ ne ji akame ake, “Wáwálé galɔ́gálɔ́ alu ne muú yi anyɛɛ́ nyɛ́ menyɛɛ́ né mbaá ayi Ɛsɔwɔ ágbárege gefwa jií.” ");
INSERT INTO anvNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Jisɔs awúgé mbɔ, alɔ mangare ji abya aké, “Né gébé gefɔ́ mende fɔ abɔ apyɛ gekpɛ́kpɛ́gé ɛpaá, akuú gejamégé bɔɔ́. ");
INSERT INTO anvNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Gébé gékwɔ́négé, atɔ́ maá defwɛ́ wuú nnó ajyɛ́ agáré bɔɔ́ bi ji akuú bwɔ́ ɛpaá nnó, ‘Áchwɔ́ ɛpaá ɛ́chwɔ́ lɔ.’ ");
INSERT INTO anvNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Ajyɛ́gé, agɛ́ muú ama ama ne yɛ́ndémuú alɔ mandoré úbɔ́meno agare wyɛ́ ɛwú. Muú ayi mbɛ aké, ‘Wyɛ́ náná ne nnamé mekɔɔ́ wa nkɛlege manjyɛ gɛ́ ɛwú. Chó gáré ntɛ wyɛ́ nnó ɛkagé asɔ́ metɔɔ́ nnó nchwɔ ɛpaá wuú wɔ́.’ ");
INSERT INTO anvNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Ama jyɛ́ gɛ́ ayifɔ, mende yimbɔ ntó aké, ‘Wyɛ́ náná ne nnamé mpɔ ɛyí ɛkyá makɔɔ́ ɛfya, nlu mɛ́ tɛ́né manjyɛ muá ɛ́jí wá ɛpyɛ́ utɔɔ́. Nkpa ɛnyú geká, ɛkage désɔ́ metɔɔ́ nnó nchwɔ wɔ́.’ ");
INSERT INTO anvNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Ama jyɛ́ gɛ́ ayifɔ, mende yimbɔ ake, ‘Wyɛ́ náná ne mbané mendée wa gétú ɛyige na nchwɔ́ fɔ.’ ");
INSERT INTO anvNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Maá defwɛ́ yimbɔ akérégé meso, agaré depɔ ɛtíré na deko mbaá ntɛ wuú; ayi akuú ɛpaá, ne aké awuú mbɔ metɔɔ́ ɛsɔ́ ji dɔɔ́. Ama tɔ́ maá defwɛ́ wuú aké, ‘Chó né metɔɔ́ melɔ ne anɔɔ́ mati ayí kɔ́kɔ́ ne ayí kpakpa, ɔkuú ubwéré, abi amɛ nónómé, ukɔ́kɔ́ré bɔɔ́ ne abi gekpo nnó achwɔ́ gepú ya.’ ");
INSERT INTO anvNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Maá defwɛ́ ajyɛ́gé, akeré meso aké, ‘Ata mpyɛ mɛ́ ndɛre ɔjɔɔ́ ne gepú gélú daŋbée.’ ");
INSERT INTO anvNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Ntɛ wuú, ama gáre ji aké, ‘Chó náná né baá malɔ ne bɔ dachi ako ne mati ayi kɔ́kɔ́, ɔgaré bɔɔ́ áchwɔ́ ápyɛ́ gepú yá gégbeé. ");
INSERT INTO anvNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Kaá nnó bɔɔ́ bi mbɔ́ nkuú mɛ́ ɛbwɔ́, áshyá manchwɔ́ yɛ muú ayi áfwɔ́rege menyɛɛ́ wa ayí ntyɛɛ́ apɔ́.’” ");
INSERT INTO anvNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Ndɛre Jisɔs ama lɔ manjyɛ́gé nekɛ nií, gejamége bɔɔ́ ákwɔ́lege ji. Ɛ́ké ɛ́wyage atɛné, abwɔlé ushu, ajɔɔ́ ne ɛbwɔ́ aké, ");
INSERT INTO anvNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Muú akágé bɛ́ fɔ ménkwɔlé wa mbɔgé álá agboó ne me apwɔ́ mmá wuú ne ntɛ wuú ne amá agbógé ne me apwɔ́ mendée wuú, baá bií ne aŋmɛ́ bií. Ne amá agbógé ne me apwɔ́ gemɛ jií. ");
INSERT INTO anvNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Muú akágé bɛ́fɔ ntó ménkwɔlé wa mbɔgé alá kamé negbo akpá ɛjií gekwa akwɔlé me ne gejí wɔ́. ");
INSERT INTO anvNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Mbɔgé muú nyú ama ashuú mantɛné ɛnyɔŋ, abɔ́ kpɛ́ mbɛ ajwɔ́lé, afɛ́ré chánchá meno ŋka ɛyi gepú ɛyigémbɔ genyɛ́ɛ nyɛ ne akaá wa abɛ nyɛ́ ne ŋka ɛyi ɛkwanege maneré géjí? ");
INSERT INTO anvNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Mbɔgé alá fɛré mbɔ wɔ́, ɛ́bɛ́ nyɛ́ nnó anérégé fɔ gepú ɛyígémbɔ, atɛnege nyɛ́ lé nébɔ́mé, bɔɔ́ bi ákóoge ɛfɛɛ́ ágɛgé nebɔ́mé ɛniné mbɔ, álɔ manjwáné áke: ");
INSERT INTO anvNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","‘Gɛ́ muú yi aké atɛnege ɛnyɔ́ŋ, ɛ́pwɔ ji.’ ");
INSERT INTO anvNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Ɛkáge bɛ́ nnó mfwa ajyɛ myɛ́ bee ne mfwa ayifɔ. Mbɔgé akwilege manjyɛ, gɛ́ nnó Mfwa ayifɔ achwɔ ne bɔɔ́ gejamé abi apwɔɔ́ abií né malú ápéa, apyɛ nnó? Nnó abɔ́ kpɛ́ mbɛ ajwɔ́lé ne bɔɔ́ bií afɛré wa ákáge myɛ́ nyɛ́ bee ne bɔɔ́ bimbɔ? ");
INSERT INTO anvNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Mbɔgé agɛgé nnó úpwɔɔ nyɛ ɛbwɔ́, aferege nyɛ́ bɔɔ́ atɔ́ nnó ajyɛ́ ábáné mfwa yimbɔ ndɛre alú tɛtɛ, akwɔ́ ji mata nnó ágáré ɛ́lé genó ɛyígé ji akɛ́lege nnó ɛbwɔ́ áchyɛ́ ne álya ɛbwɔ́ ábɛ́ né nesɔ. ");
INSERT INTO anvNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Wyɛ́ na ntó ne ɛnyú debɔɔ́ mankpomé mmyɛ.” “Muú akágé bɛ́ fɔ ménkwɔlé wa mbɔgé alá kámé mánlyá unó uko wɔ́. ");
INSERT INTO anvNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Mega ɛ́lú genó gelɔ́gélɔ́ ne mbɔgé mega ɛ́lá pɔ́ sé ne ugɔ bií, ápyɛɛ́ mbɔ nnó ne ugɔ bií ukéré? ");
INSERT INTO anvNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Ɛfúlé sé genó. Muú akágé gbɛ́ɛ fɔ ɛ́wú né mekɔɔ́, yɛ́ ama áchwáré ne ujwaá ne ágbɛ né mekɔɔ́ ɛ́lɔ́mé fɔ́. Ágbɛ́le lé ɛ́wú gbɛ́le. Muú yi awyá matu áwú.” ");
INSERT INTO anvNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Bií uma ánsɛlé ŋka makpo ne abifɔ abi ápyɛɛ́ ubeé, áchwɔ mánwú mekomejɔɔ́ Jisɔs. ");
INSERT INTO anvNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Ne bɔɔ́ bi akúu ɛbwɔ́ Farasi abi áfɛré nnó álú cho né ɛbɛ́ Ɛsɔwɔ ne *Ánlɛré mabɛ́ Ɛsɔwɔ ágɛ́gé na matɔɔ́ ásɔ́ ɛbwɔ́ áke, “Mende yina alu geluá ne bɔɔ́ ubeé ne amá anyɛ́ɛ menyɛ́ɛ ne ɛbwɔ́.” ");
INSERT INTO anvNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Ɛ́fɛɛ́ Jisɔs ató ɛbwɔ́ nekanémejɔɔ́ ɛni aké, ");
INSERT INTO anvNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Mbɔgé muú nyú awyaá usaá magɔ́nŋme úta ne ɛ́ma ɛnogé apyɛɛ́ nnó? Nnó ályágé fɔ ayi usaá uni meso nekuúneɛni ne ajyɛ́ ákɛ́légé ɛwé ɛnomé kpaá tɛ́ ágɛ́ne? ");
INSERT INTO anvNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Gébégé akɛlégé, agɛgé, akpane anɛré mankɔɔ́ abene. ");
INSERT INTO anvNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Achwɔgé mmu akú ajeé ne atɛ áŋmɛ́ aké, ‘chwɔge débé mabeé. Ɛgɔ́ŋme wa ɛwé ɛbɔ́ ɛnómé, ngɛ́.’” ");
INSERT INTO anvNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Ne Jisɔs aké: “Ngarege wɔ nnó wyɛ́mbɔ ntó ne matɔɔ́ agɔɔ́ bɔɔ dɔɔ́ né mfaánebuú gétúgé muú ubeé ama ayi ákwɔré metɔɔ́ wuú ne geŋwá jií ɛpwɔ gejame bɔɔ́ abi álu cho álá bɔ mankwɔre matɔɔ́ bwɔ́ wɔ́. ");
INSERT INTO anvNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Mbɔgé ntó mendée fɔ awya bɔ sére áfya ne ama anogé apyɛ́ nnó? Alwɛ́gé mewɛ áshwá gepú jií, ápéa akɛ́lé kpaa tɛ agɛ́ne? ");
INSERT INTO anvNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Ne akɛ́légé agɛgé akú ajeé bií aké chwɔ́ge debé mabeé, sére wa ayi abɔ́ ánomé, ngɛ́ ji.” ");
INSERT INTO anvNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Ne Jisɔs aké: “Ngarégé wɔ nnó. Wyɛmbɔ ntó ne makiɛ́nné Ɛsɔwɔ ábɛɛ́ ne nechɔ́chɔ́ gétúgé muú ubeé ama ayi akwɔré metɔɔ́ wuú ne geŋwá jií.” ");
INSERT INTO anvNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Jisɔs ama jɔɔ́ aké, “Mende fɔ abɔ́ awya baá ande ápeá. ");
INSERT INTO anvNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Bií uma ayi meso aké ne ntɛ wuú, ‘Atá káré geteé chyɛ́ ɛya.’ Ɛfɛɛ́ ne ntɛ wuú akaré achyɛ́ ɛjií. ");
INSERT INTO anvNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Ásɛ́gé gebagé geteé jií ɛ́bɛlé yɛ mboó ndɔ wɔ́, akpó asɛ ŋka, alyá melɔ wuú, afɛ́ nekɛ tɛtɛ né melɔ́ kpaá ɛwéchá, ɛ́fɛɛ́ ne akwené menya anyɛɛ́ ŋka meko. ");
INSERT INTO anvNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Ányɛ́gé ŋka jií ɛ́byɛgé ɛkɛ́ getú ne mesa ayi ákwené né melɔ ɛwémbɔ álá ámu amu. ");
INSERT INTO anvNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Ɛfɛɛ́ ajyɛ gɛ́ mende fɔ né melɔ wembɔ, ákwe ji uká ne mende yimbɔ asɛ wyɛ́ ji sɛ́le né utɔɔ́ mámbámé mekwɛnde jií né mekɔɔ́ wuú. ");
INSERT INTO anvNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Afɛ́ mámbámé ne muú ayi achyɛ́ge ji menyɛɛ́ ápɔ́, mesa amyɛ ji dɔɔ́ ne akɛlege yɛ manyɛɛ́ ntó uchachuú gasala ɛbi ukwɛ́ndé unyɛɛ́ ");
INSERT INTO anvNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Gébégé ji afɛré defɔɔ́ tií dékeré aké, ‘Bɔɔ́ utɔɔ́ ntɛ wa ányɛ́ ágbége, ayifɔ alaá, nlu fá ndɛre mesa. ");
INSERT INTO anvNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Nkerege meso mbaá ntɛ wa nnɛ́ ji mmyɛ nnó, Ata, mpyɛ gabo né ɛ́gbɛ́ Ɛsɔwɔ, ne gyɛ́ ɛta wyɛ́. ");
INSERT INTO anvNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Mfu sé ayi mbɛɛ́ maá wyɛ́ wɔ́. Sɛ le me nkane muú utɔɔ́ wyɛ́ ama.’ ");
INSERT INTO anvNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Ajɔ́gé mbɔ, akwilé afɛ́ mbaá ntɛ wuú. “Ndɛre álú tɛtɛ ntɛ wuú agɛ́ ji nkane achwɔ́ɔ, gejeé ne meshwɛ gekwɔ́ ji metɔɔ́, alomé ajyɛ kpá ji atyá ábogéné mme. ");
INSERT INTO anvNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Maá aké, ‘Ata mpyɛ gabo né ɛ́gbɛ́ Ɛsɔwɔ ne ɛta wyɛ́. Mfu sé mambɛ́ maá wyɛ́ wɔ́.’ ");
INSERT INTO anvNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Ajɔ́gé mbɔ, ntɛ wuú aké ne baá defwɛ́ bií, chóge wáwá dépɛ nkwú melɔ́mélɔ́ dechwɔ défyɛ́ ji mmyɛ, ‘Ma fyɛ́ge ji ŋkpáganɛré ne unó uká. ");
INSERT INTO anvNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Ma chwɔ́ge ne mpɔ mabɔ déwá depyɛ́ ɛpaá. ");
INSERT INTO anvNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Mbɔ́ mfɛré nnó maá wa yiná agbó, ne alu mebɛ, abɔ́ anó ne mmangɛ́ ji, ɛfɛɛ́ ne ɛpaá ɛ́lɔɔ́.’ ");
INSERT INTO anvNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Gébégé ányɛ́ ɛpaá ɛwémbɔ, mámbɛ mende yimbɔ alu né mekɔɔ́ aké akerege meso alɛ́ kwɔ́kwɔ́lé ne gepú, awú ubeé né dachi bwɔ́ ");
INSERT INTO anvNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Ne atɛné agií maá defwɛ́ aké ndé mechɔ́ ɛ́lú dachi sé? ");
INSERT INTO anvNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Ágiígé mbɔ, maá defwɛ́ agaré ji ake, ‘Meŋmó wyɛ́ ne ákeré meso mebɛ ne ntɛ wyɛ́ metɔɔ́ ɛgɔɔ́ ji awané ji mpɔ mabɔ.’ ");
INSERT INTO anvNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Awúge mbɔ metɔɔ́ ɛsɔ́ ji kpaa ashya mánkpɛ mmu dachi, ɛ́fɛɛ́ ne ntɛ wuú achwɔ́ nɛ́ ji mmyɛ nnó akpɛ́ mmu. ");
INSERT INTO anvNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Yɛ́mbɔ atɛné ɛ́shyɛ́né ne ntɛ wuú aké, ‘Gejame aŋmɛ ayi me nkwené na nkane memfwɛ́ ɛta wyɛ́, nlú dantó mekpo yɛ dámáa, ɔchyɛ́ me ndé? Yɛ maá mbyɛ́né mŋme yi ɔchyɛ́ me nnó nnyɛ ne ajeé ba ne metɔɔ́ megɔmegɔ apɔ́. ");
INSERT INTO anvNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Ne gébégé maá wyɛ́ yi akwené menya anyɛɛ́ ŋka ne andée deno ake achwɔ́ ɔwá ji mpɔ mabɔ?’ ");
INSERT INTO anvNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Ntɛ wuú akú ji aké, ‘Maá wa ɔlu ne me fá yɛndégebé ne unó uko ɛbí nwya ɛ́lé ɛbyɛ́ ");
INSERT INTO anvNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Yɛ́mbɔ ɛsé abi mmu debɔ mampyɛ ɛpaá ne metɔɔ́ megɔmegɔ gétúgé meŋmó wyɛ́ ayi débɔ́ défɛré nnó agbó ne alu mebɛ, abɔ́ anó ne dégɛ́ ji nána.’” ");
INSERT INTO anvNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Jisɔs ama garé baá utɔɔ́ bií nekanémejɔɔ́ ɛniné fɔ aké, “Muú ŋka fɔ abɔ́ alu, ayi awyá muú utɔɔ́ wuú ayi apɛ́le unó ŋka bií uko. Gébé gefɔ, bɔɔ́ fɔ́ áchwɔ́ garé ji nnó muú utɔɔ́ wuú achɔɔ́ ŋka jií. ");
INSERT INTO anvNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Ne akú muú utɔɔ́ yimbɔ, achwɔ́gé, agií aké, ‘Ndé gefɔ́ genó ɛyi nwuú mbɔ nnó ɔpyɛ́ɛ? Chó, chwɔ́ ne bɔ ŋwɛ ako abi ɔ́samé unó ba, ɔshuú me nende ɔpɔ́ sé muú utɔɔ́ wa.’ ");
INSERT INTO anvNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","“Muú utɔɔ́ yimbɔ agige gemɛ jií ake, ‘Mpyɛ mbɔ nyɛ nnó, nana ayi ntɛ wa áchwɔ féré me né utɔɔ́? Mpɔ ne ɛshyɛ mangbaré ɛsaá, yɛ dekɔ degbóo me mmyɛ.’ ");
INSERT INTO anvNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Ɛké ɛwyáge ake: ‘Nana nkaá genó ɛyigé mpyɛ nyɛ, nnó gébégé ntɛ wa aférége me né utɔɔ́, mbɛ ne ajeé abi ápoóge me né upú bwɔ́.’ ");
INSERT INTO anvNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","“Ɛfɛɛ́, ne muú utɔɔ́ yimbɔ alɔ mankuúge bɔɔ́ abi ágbárege ntɛ wuú ujwɔɔ́ ama ama. Agií muú ayi mbɛ aké, ‘Ɔgbaré ntɛ wa nnó?’ ");
INSERT INTO anvNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Muú yimbɔ aké, ‘Ngbarege ji usaá ndá maweé uta.’ Muú utɔɔ́ yimbɔ aké, ‘Gɛ́ ŋwɛ ayi ɔbɔ́ samé wyɛ́, sɛ wáwá jwɔ́lé mme, ɔkwɔ́ré, ɔsá usaá ndá maweé upéa meso ɛ́fya.’ ");
INSERT INTO anvNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Ama agií ayifɔ ake, ‘Wɔ gbare ntɛ wa ujwɔɔ́ nnó’? Aké, ‘Ngbarege ji usaá úba Ɛrise uta.’ Muú utɔɔ́ yimbɔ ake, ‘Gɛ́ ŋwɛ ayi ɔbɔ́ samé wyɛ́ na, kwɔ́ré, sá usaá úba uni.’ ");
INSERT INTO anvNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Ntɛ muú utɔɔ́ yimbɔ agɛ́gé nnó muú utɔɔ́ wuú anyɛ́ ji upwɔ, akame ake, ntɛ mende yina akpaá. Jisɔs anerege nekanémejɔɔ́ ɛni ake, bɔɔ́ mme bina ápyɛ uno bwɔ́ ne defɔɔ́ ápwɔ nkane bɔɔ́ Ɛsɔwɔ ápyɛ́ ɛbi bwɔ́. ");
INSERT INTO anvNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Ŋka ɛlúmbɔ, ndɔ yifɔ ɛpyɛ gabo. Ne nchyɛge ɛnyú majyɛ́ nnó debɔ́ ŋka ɛyi déwyaá dépyɛ́ dejeé ne Ɛsɔwɔ nnó gébégé ŋka yina ɛ́byɛgé ásɛle nyɛ́ ɛnyú, ábelé né melu ɛwé geŋwá ɛyi gélá gébyɛɛ́. ");
INSERT INTO anvNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“Muú yi anɛrege metɔɔ́ ne ji né ɛkɛ́kɛ́ genó mbɔntó ne anɛrege metɔɔ́ ne ji né ɛyigé kpaá. Ne muú yi áfwalege muú né ɛkɛ́kɛ́ genó mbɔntó ne áfwálége muú né ɛyigé kpaá. ");
INSERT INTO anvNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Mbɔgé ɛnyú dekágé béle fɔ́ ŋka cháŋéné ɛyi ndɔfɔ́ ɛ́pyɛ́ gabo, ɛpyɛɛ́mbɔ nnó ne áchyɛ ɛnyú genó gembɔ́? ");
INSERT INTO anvNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Mbɔgé dekágé chɛ́ré genó ɛyígé muú ayichá cháŋéné, ndé muú ábɔɔ́ genó áchyɛ́ge nnó gébɛ́ ɛyigé ɛnyú? ");
INSERT INTO anvNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Maá defwɛ́ ama ákágé kpá fɔ́ defwɛ́ mbaá bɔɔ́ apea gébé gemaá. Ápyɛgémbɔ, apaá nyɛ́ ama agboó ne ayifɔ. Ne ánogé nyɛ́ ama abyaá ayifɔ. Ɛnyú dekágé nógé fɔ́ Ɛsɔwɔ ne ŋka gébé gemaá.” ");
INSERT INTO anvNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Bɔɔ́ Farasi fɔ́ abi abɔ́ álú ɛfɛɛ́ áwuúge mechɔ́ ɛwé Jisɔs ajɔɔ́, álɔ manshwá meshwá gétúgé ɛbwɔ́ ágbóo ne ŋka dɔɔ́. ");
INSERT INTO anvNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Ɛfɛɛ́ Jisɔs ake ne ɛbwɔ́, “Ɛnyú delu bɔɔ́ abi débwɔ́lege bɔɔ́ nnó ɛnyú delu cho, yɛ́mbɔ Ata Ɛsɔwɔ akage matɔɔ́ ɛnyú. Kaáge nnó unó bi bɔɔ́ afɛ́ge nnó úlɔ́, úlú ukweŋkwe né mbɛ ushu Ɛsɔwɔ.” ");
INSERT INTO anvNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Jisɔs amá aké, “Gébé genyá, bɔɔ́ áwúu le *Mabɛ́ Mosis ne unó bi bɔɔ́ ɛkpávé Ɛsɔwɔ ábɔ́ ásamé. Lɔ né gébé ɛyigé Jɔn achwɔɔ́, bɔɔ́ ágárege abya melɔ́mélɔ́ gefwa ɛyigé Ɛsɔwɔ ágbárege ne bɔɔ́ ako ámyɛ́ ne ɛshyɛ mankpɛ mmu gefwa yimbɔ. ");
INSERT INTO anvNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Yɛ́mbɔ, ɛpɔ́fɔ́ nnó ɛbɛ́ Mosis ɛlá detú. Ɛ́lú wáwá nnó mfaá ne mme ákwyá ɛpwɔ nnó ɛkɛ́ mansá ŋwɛ né ɛbɛ́ ɛwémbɔ ɛlá detú.” ");
INSERT INTO anvNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Wyɛ́mbɔ ne ɛ́lú nnó yɛndé mende ayi awáne neba ne mendée wuú, ne abagé ayichá, akwé mbɔ lé ulɔ. Mende ayi abagé ntó mendée ayi menɔ wuú ábuú ji, akwé mbɔ lé ulɔ.” ");
INSERT INTO anvNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Jisɔs ama garé abya yiná aké, “Mende fɔ abɔ alu ayi awyá gefwa. Afyɛ uchánchá mandée, anyɛɛ́ geŋwá yɛndé bií. ");
INSERT INTO anvNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Ne mbyá muú fɔ, abɔ́ alu ntó ayi akúu ji Lasarɔs. Ayi abɔ́ amée mansa. Yɛ́ndégébé abɛlege wyɛ́ né menómbi muú gefwa yimbɔ, ");
INSERT INTO anvNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","anyagé gemɛ, apɛle wa muú ŋka yimbɔ, alɔ mɛ́ manyɛ́ge menyɛɛ́ nnó ɛkɛ ɛkwéne yɛ mme, ji abɔ́ anyɛ́. Ne mbaá ayi ji abɛlé, bɔ mamyɛ áchwɔ́ álárege upa bií. ");
INSERT INTO anvNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Ne bií uma Lasarɔs agbó, makiɛ́nné Ɛsɔwɔ áchwɔ kpa ji, áfɛ́ né mfaánebuú. Ajwɔlé né néŋkúné mmyɛ Abraham, ɛfɛɛ́ Lasarɔs alɔ manyɛ́ menyɛɛ́ ne ji. Ɛbɛ́légé muú ŋka yimbɔ ntó agbó, ánií ji. ");
INSERT INTO anvNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Afɛ́ né melɔ áwuú bɔɔ́, ɛfɛɛ́ alɔ mangɛ́né ɛfwyalé ɛwé mebo. Né gébé gefɔ́ aŋme amɛ agɛ́ Lasarɔs tɛtɛ, ndɛre ajwɔlé né neŋkuné mmyɛ Abraham. ");
INSERT INTO anvNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Agɛ́ge mbɔ, akuú ake, ‘Ata *Abraham, gɛ́ me meshwɛ, tɔ́ Lasarɔs ajyɛ́ fyɛ ɛnɔ́ bwɔ wuú mmu manaá achwɔ́ pyɛ metɔɔ́ wa ɛkwené, ngɛne gebégé ɛfwyale né mewɛ ɛwéna.’ ");
INSERT INTO anvNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“Abraham ashuú ji meko aké, ‘Maá wa, te ndɛré ɔlu nyá né mme, ɔbɔ́ ɔlu gbɛne, ɔnyɛɛ́ ɔbwɔlege ayi Lasarɔs álá pɔ́ yɛ ne genó, agɛne lé ɛfwyale. Nana Lasarɔs anyɛɛ́ geŋwá fa ayi wɔ gɛné gebégé ɛfwyale ɛwu. ");
INSERT INTO anvNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Ɛpɔ́fɔ́ yɛ́mbɔ, newú nékaré ɛsé nnó muú ayi akɛlege manchya áchwɔ wena agɛ́ge fɔ meti ne ayi akɛlege manchya ntó áchwɔ ɛwu agɛge fɔ meti.’ ");
INSERT INTO anvNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Muú ŋka yimbɔ, ama kwɔ ji mata ake, ‘Ntɛ ɛse Abraham, tɔ́ Lasarɔs né dachi ntɛ wa, ");
INSERT INTO anvNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","nnó ajyɛ́ ajií aŋmɛ́ ba áta matu nnó ɛkagé ɛbwɔ́ ákwɔ́lé gepɔ ya, áchwɔ́ né melú ubalé ɛwé.’ ");
INSERT INTO anvNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","“Abraham ashuú le ji meko aké, ‘Ɛbwɔ́ áwya ŋwɛ Mosis ne abi bɔɔ́ ɛkpávé Ɛsɔwɔ ásamé. Gɔ́ ɛbwɔ́ áwuú geno ɛyigé bɔɔ́ ɛkpávé Ɛsɔwɔ ajɔ́ge.’ ");
INSERT INTO anvNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Muú gefwa yimbɔ ashya ake, ‘Ŋgba, Atá Abraham, mbɔgé muú ayi agboó mɛ́ ne abɔ́ ajyɛgé gáre ɛbwɔ́, ákwɔ́rege nyɛ́ matɔɔ́.’ ");
INSERT INTO anvNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Yɛ́mbɔ Abraham aké ne ji, ‘Mbɔge ɛbwɔ́ áshyagé manwú mekomejɔɔ́ Mosis ne ayi bɔɔ́ ɛkpávé Ɛsɔwɔ yɛ lé mewu muú ne ajyɛ gáré ɛbwɔ́, awuú nyɛ́ fɔ́.’” ");
INSERT INTO anvNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Jisɔs ajɔɔ́ ne baá utɔɔ́ bií ake, “Unó úlú ɛbi úbwɔlege bɔɔ́ nnó ápyɛ́ *gabo. Yɛ́mbɔ utóŋkwa úlú ne muú ayi ábwɔ́lege nyɛ́ ayifɔ nnó apyɛ́ gabo. ");
INSERT INTO anvNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Ɛbɔ ɛlɔ nnó áshií muú yimbɔ gekpɛ́kpɛ́gé ntaá né gemɛ, áŋmé ji né gentoógé ɛbɛɛ́ mega, ne nnó ábɛ́ mebɛ, ábwɔlégé yɛ muú ama né bɔɔ́ bi alú ɛké ambáné nnó apyɛ́ gabo. ");
INSERT INTO anvNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","“Sɛge gébé nnó ɛkagé depyɛ gyɛɛ́ mbaá depɔ tiré na. Mbɔgé meŋmɛ́ wyɛ́ apyɛ́gé gabo, ɔbɔ́ mankuú ji ɔjɔɔ́ ne ji ne akamégé nnó alu gyɛɛ́, ɔbɔ́ manjií ji nte. ");
INSERT INTO anvNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Yɛ apyɛ́ge gyɛɛ́ ɛta wyɛ́ máŋáne akénéama né bií, ne achwɔ́gé akamégé yɛ́ndégébé nnó, ‘Alu gyɛɛ́,’ ɔbɔ manjinte né ndɔ yimbɔ meko.” ");
INSERT INTO anvNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","*Áŋgbá Jisɔs áwyágé áké ne ji, “Ata poó ɛsé nnó défyɛɛ́ matɔɔ́ ne Ɛsɔwɔ dépwɔ ndɛre debɔ défyɛɛ́ mɛ́.” ");
INSERT INTO anvNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Ne Ata Jisɔs ashuú ɛbwɔ́ meko ake, “Metɔɔ́ ɛwé défyɛɛ́ ne Ɛsɔwɔ yɛ́ ɛbɛ́ ɛlé ŋénéŋéné ɛke nyiné mbwɛ́ ngboŋ, dekage jɔɔ́ ne genɔɔ́ ɛyina nnó, ‘Kwilé fa ɔjyɛ tɛ́né né ɛbɛɛ́ mega.’ Genɔɔ́ ɛyimbɔ gébɔ́ mampyɛ́ nkane dejɔɔ́. ");
INSERT INTO anvNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Désɛ́ nnó muú nyú ama awya muú utɔɔ́ wuú. Ne apyɛgé utɔɔ́ bii uko né mekɔɔ́ yɛlé membame magɔnŋmé. Nnó achwɔge mmu agarege ji tɛ́nétɛ́né nnó, ‘Chó, kpá menyɛɛ́ wyɛ́, ɔnyɛ́’? ");
INSERT INTO anvNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Ŋgba agarege nyɛ le ji nnó, ‘Chó, kwɔ́ré mandeé jyɛ́, ɔtyɛ́ menyɛɛ́, ɔchyɛ́ me nyɛ́.’ Nnerégé mɛ́, ɔchwɔ́, ɔféré unó ne ɔfɛ́ ɔnyɛ́ awyɛ́. ");
INSERT INTO anvNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Mbɔgé apyɛgé ndɛre ágaré ji, nnó ntɛ wuú ala nyɛ́ wyɛ́ mantámégé ji? ");
INSERT INTO anvNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Ɛ́lú wyɛ́ genó gémá ne ɛnyú, depyɛgé utɔɔ́ ɛbi áchyɛ́ge ɛnyú denérégé, debɔ́ manjɔɔ́ nnó, ‘Ɛse delu lé baá defwɛ́. Depyɛ lé utɔɔ́ ɛbi debɔɔ́ mampyɛ.’” ");
INSERT INTO anvNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Ndɛre Jisɔs abɔ́ alu akɛ́ne ajyɛ né Jɛrosalɛ, akoó melɛre ayi bɔɔ́ Samariya ne bɔɔ́ Galilií. ");
INSERT INTO anvNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Gébégé Jisɔs áchwɔ kwɔ́ne né maá melɔ fɔ, agɛ́ ande fɔ́ afya abi amée ubá, ágɛ́gé ji átɛné tɛtɛ, ");
INSERT INTO anvNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","ne álɔ mankuú ji áke, “Ata Jisɔs, gɛ ɛsé meshwɛ.” ");
INSERT INTO anvNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Jisɔs ake agɛne ɛbwɔ́, áké, “Choge délɛ́ré lé mmyɛ nyú mbaá ámpyɛ́ upɛ Ɛsɔwɔ nnó áchɛ́ré ɛnyú.” Ndɛre bɔɔ́ bina akɛne ájyɛ́ né meti, ágɛ́ nnó ɛbwɔ́ ako atoó. ");
INSERT INTO anvNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Ne muú ama né geluágé bɔɔ́ bimbɔ agɛ́gé nnó atoó, alɔ mankeré meso, akwane kéŋké, afɛɛ́ge Ɛsɔwɔ, manchwɔ táme Jisɔs. ");
INSERT INTO anvNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Akwɔ́négé, ató manó mme né mbɛ ushu Jisɔs, atamege ji. Mende yina abɔ́ alu lé muú Samariya. ");
INSERT INTO anvNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Jisɔs agɛ́gé ji, alɔ mangií gemɛ jií aké, “Pɔ́ mbɔ mpyɛ ná bɔɔ́ áfya átoó ne abi aneneéama álɛ́? ");
INSERT INTO anvNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Wyɛ́ lé menkɛɛ́ yiná ne akeré meso manchwɔ́ táme Ɛsɔwɔ?” ");
INSERT INTO anvNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Ne Jisɔs ake ne mende yimbɔ, “Kwilé, chó ɛjyɛ́ geba, ɔtoó mbɔ gétúgé ɔfyɛɛ́ metɔɔ́ ne me.” ");
INSERT INTO anvNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Né gébé gefɔ́ bɔɔ́ Farasi, ágií Jisɔs ake, “Ndé gébé ɛyige Ɛsɔwɔ áchwɔɔ́ gbáre nyɛ́ gefwa jií fá mme? Ashuú ɛbwɔ́ meko ake, ‘Unó fɔ́ upɔ́ se ɛbi ulɛ́rege nyɛ́ nnó Ɛsɔwɔ achwɔ́ gbáre gefwa jií.’ ");
INSERT INTO anvNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Muú fɔ apɔ́ ayi akaáge gáre nyɛ́ wáwálé nnó, ‘Gɛ́ Ɛsɔwɔ na ɛlé agbaré mɛ́ gefwa jií fa!’ ‘Gɛ Ɛsɔwɔ mbɔ ɛlé agbare mɛ́ Gefwa jií ɛwu!’ Kaáge nnó *Gefwage Ɛsɔwɔ gelú mɛ́ ne ɛnyú.” ");
INSERT INTO anvNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Ne ajɔɔ́ ne baá utɔɔ́ bií ake, “Gébé gekwɔ́nege nyɛ́ ɛyigé ɛnyú dékɛ́lege mangɛ́ Maá Ntɛ Mekwaá yɛ né bii uma, yɛ́mbɔ degɛné nyɛ fɔ ji. ");
INSERT INTO anvNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Né gébé ɛyigembɔ, bɔɔ́ bifɔ́ ajɔɔ́ge nyɛ́ ne ɛnyú nnó, ‘Gɛ́ge ji alu fa,’ ‘Gɛ́ge ji alu ɛ́wu.’ Yɛ ájɔɔ́ge mbɔ déjyɛgé fɔ mankɛ́le ji. ");
INSERT INTO anvNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Gébége Maá Ntɛ Mekwaá ake achwɔɔ́, bɔɔ́ ágɛ́ne nyɛ́ ji wyɛ nkane dasama akɛ́le mamma, ɛgbɛ ɛwe ne ɛwe, ne nebuú négɛ́nege. ");
INSERT INTO anvNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Yɛ́mbɔ nsá nnó ji ájyɛ́ achwɔ́, abɔ́ mangɛ́ gejamégé ɛfwyale ne njyɛ ɛniné na néshyá nyɛ́ ji. ");
INSERT INTO anvNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Ndɛre ɛpyɛɛ́ nyá né gébégé Nowa, wyɛ́mbɔ ntó ne ɛpyɛ́ nyɛ́ gébégé Maá Ntɛ Mekwaá aké akerege fa mme. ");
INSERT INTO anvNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Bɔɔ́ ábɔ ányɛ́, anyúu, abifɔ ábáne andée, ne átuú baá né maba. Ányɛ́ kpaá tɛ bií ɛbi Nowa ákpɛné mmu ɛ́kpe. Ɛfɛɛ́ ne manaá akwené dɔɔ́, manyi ákpɛ ne genyágé nnyi, gechwɔ shwa bɔɔ́ bimbɔ ako, ágbó. ");
INSERT INTO anvNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Ɛpyɛ nyɛ́ ntó wyɛ́ nkane ɛbɔ́ ɛpyɛ́ né gébé ɛyigé *Lɔt alu mebɛ, bɔɔ́ ábɔ́ ányɛ́, ányúu, abifɔ akpóo unó, abifɔ ánáme, bɔɔ́ bifɔ́ ápyɛ́ makɔɔ́, abifɔ átɛ́nege upú, ");
INSERT INTO anvNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","ne bií ɛbi Lɔt alyá melɔ Sodom, Ɛsɔwɔ apyɛ́ ndoó mewɛ atané mfaánebuú achwɔ sɔ́ melɔ Sodom meko ɛke *mewɛ dáwá ");
INSERT INTO anvNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Wyɛ́mbɔ ntó ne ɛpyɛ́ nyɛ́ mbaá bɔɔ́ né gébé ɛyigé Maá Ntɛ Mekwaá akérege meso fá mme. ");
INSERT INTO anvNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“Né bií bimbɔ, mbɔgé muú abɛgé mfaá gepú, ɛkagé ashúlé mme nnó abɔɔ́ genó né gepú jií, ábó ájyɛ́. Wyɛ́mbɔ ntó muú yi ajyɛgé mekɔɔ́ ɛkagé ama kéré mmu gepú jií. ");
INSERT INTO anvNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Tége genó ɛyigé gébɔ́ gepyɛ́ ne mendée Lɔt. ");
INSERT INTO anvNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Muú ayi akɛ́lege mampoó geŋwá jií ɛbyɛ́nnó aníige nyɛ geji, ne mbɔgé muú akamégé manchyɛɛ́ geŋwá jií getú ya, apóme nyɛ.” ");
INSERT INTO anvNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Jisɔs ama jɔɔ́ ake, “Ngarege ɛnyú nnó né utuú bimbɔ, bɔɔ́ ábɛlégé né ukwɔ́ apea, ákpáne nyɛ́ ama, ályaá ayifɔ. ");
INSERT INTO anvNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Yɛ́ andée apeá ake ákwɔ́ɔ nchi mbaá ama, ákpáne nyɛ́ ama, ályaá ayifɔ.” ");
INSERT INTO anvNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Yɛ́ mbɔgé bɔɔ́ apeá ábɛgé né mekɔɔ́, áke ápyɛ́ utɔɔ́, ákpáne nyɛ́ ama, ályaá ayifɔ. ");
INSERT INTO anvNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Baá utɔɔ́ bií áwúgé depɔ ɛtirena ágií ji áke, “Ata unó bína úpyɛ́ nyɛ́ ɛ́fɔ́.” Ne Jisɔs ashuú ɛbwɔ́ meko ne neka ɛnína ake, “Yɛ́ndé mbaá ayi geŋkwɔ́gé genó gebɛɛ́, ɛfɛɛ́ mbɔ ne denwyɔne ɛtire denyɛɛ́ uŋkwɔ unó dénwérege.” ");
INSERT INTO anvNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Jisɔs agáré baá utɔɔ́ bií nekanémejɔɔ́ ɛníne fɔ́ manlɛré ɛbwɔ́ nnó, muú ábɔɔ́ fɔ́ mampwa manɛ́némmyɛ mbaá ntɛ wuú Ɛsɔwɔ́. ");
INSERT INTO anvNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Aké, “Mémpané mpa fɔ abɔ́ alú né melɔ fɔ ayi álá afɔɔ́ Ɛsɔwɔ ne yɛ gébé ne bɔɔ́ abɔ wɔ́. ");
INSERT INTO anvNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Mekwi mendée fɔ abɔ́ alu ntó né melɔ ɛwémbɔ. Mendée yimbɔ ajyɛ́ yɛ́ndégébé, agige mémpané mpa yimbɔ nnó, ‘Akwyɛ́ mechɔ́ bwɔ́ ne muú mawámé wuú!’ ");
INSERT INTO anvNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Ndɔ mbɛ yi mendée yina alɔ manjɔɔ́ ne ji, abɔ́ ashya manwú ne ɛ́wyágé, agií gemɛ jií aké, ‘Yɛ́ ɛlé nlá fɔɔ́ Ɛsɔwɔ ne nlá bɔ gébé ne muú wɔ́, ");
INSERT INTO anvNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","yɛ́mbɔ gétúgé mendée yina achwɔ́ yɛ́ndégébé, achyɛ́ge me ɛfwyale, nkwyɛge nyɛ mechɔ́ wuú, mbɔge nlá pyɛmbɔ wɔ́, agɔɔ́ nyɛ́ me mbélé géjyá’.” ");
INSERT INTO anvNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Ne Ata Jisɔs ájɔ́gémbɔ aké ne ɛbwɔ́, “Pɔ ɛnyú dewú nkane muú defyá mémpané mpa yiná ajɔɔ́? ");
INSERT INTO anvNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Ndɛre mémpané mpa ápoó mendée yina, nnó Ata Ɛsɔwɔ achɔɔ́ nyɛ gébé mampoó bɔɔ́ bi ájyá abi álile ɛta wuú utuú ne nwɔmésé? Alyágé nyɛ́ ɛbwɔ́ né ɛfwyale? ");
INSERT INTO anvNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Kaáge, nnó Ɛsɔwɔ achɔɔ́ nyɛ gébé mampa mpa achyɛ ɛbwɔ́. Yɛ́mbɔ gébégé Maá Ntɛ Mekwaá akerege meso, nnó agɛne nyɛ́ bɔɔ́ bi áfyɛɛ́ matɔɔ́ ne Ɛsɔwɔ?” ");
INSERT INTO anvNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Jisɔs ama gáre nekanémejɔɔ́ ɛníne fɔ́, mbaá bɔɔ́ abi álɛ́rege mmyɛ nnó ɛbwɔ́ álú cho ne ápɛ́le abifɔ nnó ápɔ́ bɔɔ́. ");
INSERT INTO anvNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Bií fɔ́, ande fɔ́ apeá, áfɛ́ né ɛcha upɛ Ɛsɔwɔ ɛwé ɛ́lú né Jerósálɛ manɛmmyɛ. Mende ayi ama, alu muú Farasi ne ayifɔ alu ménsɛlé ŋkamakpo. ");
INSERT INTO anvNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Gébégé ɛbwɔ́ akpɛ́né mmu ɛcha, muú Farasi yimbɔ ajyɛ tɛ́ne né melu ɛwé bɔɔ́ akó ákáge gɛ́ ji, alɔ manɛ́némmyɛ aké, ‘Ata Ɛsɔwɔ ntamé wɔ nnó mpɔ́ fɔ́ nkane bɔɔ́ abifɔ, yɛ ɛké ménsɛlé ŋkámakpo yimbɔ. Me mfɔ́gé fɔ́ genógé muú detú, nnyɛ́ fɔ́ manwaá ne nkwéné fɔ́ ulɔ ne mendée muú. ");
INSERT INTO anvNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Nlyage menyɛɛ́ kpékpé né depɔ tyɛ́, ndɔ ɛpéa yɛ́ndé uwyaá, mma nkarege unó ba né malú afya, nchyɛge wɔ melú ɛma.’ ");
INSERT INTO anvNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Mensɛ́lé ŋkámakpo yimbɔ, atɛné meso, akparé amu mekpo, amo mekpo mme, ajɔge ake, ‘Ata Ɛsɔwɔ, gɛ́ me meshwɛ, nlu muú yi mpyɛ́ gabo’.” ");
INSERT INTO anvNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Jisɔs anérégé, ake ne ɛbwɔ́, “Bɔɔ́ bina ákerege meso, muú ayi alú cho mbɛ ushu Ɛsɔwɔ ɛ́lé Ménsɛlé ŋkámakpo ɛ́pɔ́ fɔ́ muú Farasi. Nende muú ayi awya nepá, Ɛsɔwɔ awane nyɛ́ ji gelu ne apyɛ́ nyɛ́ ayi álá pɔ́ ne nepá, akwɔ́ ngɔ́.” ");
INSERT INTO anvNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Né gébé géfɔ́, bɔɔ́ fɔ ákpá ambáné kɔ́ áchwɔ́ ɛtá Jisɔs nnó anɛ́ré ɛbwɔ́ amu makpo ama ama ne ajé ɛbwɔ́. Baá utɔɔ́ bií ágɛ́gé ndɛre ɛbwɔ́ áchwɔɔ́, ányá ɛbwɔ́. ");
INSERT INTO anvNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Jisɔs awúgé mbɔ, akú bɔɔ́ bimbɔ nnó áchwɔ́ ne baá bwɔ́. Ne ajɔɔ́ ne baá utɔɔ́ bii aké, “Lyáge ambánékɔ́ áchwɔ́ ɛta wa, ɛkagé dégbɛ́ ɛbwɔ́ néndé gefwa ɛyigé Ɛsɔwɔ ágbárege gelú ɛyigé bɔɔ́ abi álu ndɛre baá bina. ");
INSERT INTO anvNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Ngarégé ɛnyú wáwálé nnó: muú yi álá kamé nnó Ɛsɔwɔ ábɛ́ mfwa wuú, nkane mamane kɔɔ́ wɔ́ akpɛ́né fɔ́ né gefwa jií.” ");
INSERT INTO anvNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Muú kpaá fɔ achwɔ gií Jisɔs ake: “Ménlɛré melɔ́mélɔ́, mpyɛɛ́ mbɔ nnó ne mbɔ́ geŋwá ɛyi gélágé byɛɛ́?” ");
INSERT INTO anvNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Jisɔs agií ji ake, “Ulannó ɔkuú me muú melɔ́mélɔ́? Yɛ́ muú yi alɔ́mé metɔɔ́ apɔ́, ɛkosé Ɛsɔwɔ mbií ne alu melɔ́mélɔ́. ");
INSERT INTO anvNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Pɔ́ ɔkage mabɛ́ Ɛsɔwɔ ayi áke, ‘ɛkagé ɔwá muú, ɛkagé ɔkwé ulɔ, ɔjogé ɛjo, ɛkagé ɔ́tɛ́né ntɛ́sɛ́ gebyɔ́. Ɔnyɛgé manwaá, nógé ntɛ wyɛɛ́ ne mmá wyɛɛ́’.” ");
INSERT INTO anvNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Mende yimbɔ aké, “Nlɔ mambélé mabɛ́ yina mako tɛ dembáné.” ");
INSERT INTO anvNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Jisɔs áwuúgémbɔ, ake ne ji, “Ɛ́la genó gema ɛyi ɔbɔɔ́ mampyɛ, cho, kpó unó byɛ́ uko ɔkáré ŋka yimbɔ mbaá bɔɔ́ gekpo, ne ɔ́lɔ́ mankwɔlé me. Mbɔgé ɔpyɛ́gémbɔ, ɔbɛɛ́ nyɛ ne gefwa né mfaánebuú.” ");
INSERT INTO anvNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Mende yina awugé mechɔ́ ɛwé, byɔ úkɔré ji, alɔ mansomé gefwa jií. ");
INSERT INTO anvNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Jisɔs agɛ́gé nnó metɔɔ́ ɛgɔɔ́ ji wɔ́, aké, “Ɛ́jweré ne muú ŋka akpɛ né gefwagé Ɛsɔwɔ. ");
INSERT INTO anvNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Ɛ́lú wáwá nnó *mpɔ mashwɔne áshwá né ɛmbú ábyamé, ne nnó muú ŋka akpɛ né gefwagé Ɛsɔwɔ ágbárege.” ");
INSERT INTO anvNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Bɔɔ́ abi awuú mechɔ ɛwé ágií áké, “Ne ndé muú yi abɔ nyɛ́ geŋwá ɛyi gélágé byɛɛ́.” ");
INSERT INTO anvNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Jisɔs ashuú ɛbwɔ́ meko aké, “Genó ɛyi gepwɔgé ákwaá, gepwɔ́ fɔ́ Ɛsɔwɔ.” ");
INSERT INTO anvNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Ne Pita ajɔɔ́ aké, “Gɛ́ ɛsé delyaá unó sé uko, dékwɔlege wɔ.” ");
INSERT INTO anvNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Ajɔ́gé mbɔ, Jisɔs ake ne baá utɔɔ́ bií, “Ngarege ɛnyú wáwálé nnó muú ayi alyagé gepú jií, yɛ mendée wuú, yɛ baá bií, yɛ aŋmɛ́ bií, yɛ mma wuú ne ntɛ wuú gétúgé gefwage Ɛsɔwɔ, ");
INSERT INTO anvNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","abɛ nyɛ́ ne bɔɔ́ ne gejamégé unó né mme yina, upwɔ ɛbi ji abɔ alyaá ne abɛ nyɛ́ ne geŋwá ɛyi gélágé byɛɛ́ né mme ayi áchwɔ́ nyɛ.” ");
INSERT INTO anvNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Né gébé gefɔ́, Jisɔs asɛ baá utɔɔ́ bií áfyaneápeá, ájyɛ tɛ́ne melu ɛwéchá, ɛfɛɛ́ alɔ mangaré ɛbwɔ́ aké, “Wuúge ɛsé dékwɔme mbɔ déjyɛɛ́ né Jɛrosalɛ, dekwɔnégé ɛ́wú, unó uko ɛbí bɔɔ́ ɛkpávé Ɛsɔwɔ ábɔ́ ásamé útaá Maá Ntɛ Mekwaá, ubɛ́ɛ nyɛ́ wáwálé. ");
INSERT INTO anvNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Ásá nnó áfyɛ́ nyɛ́ ji né amú bɔɔ́ abi álá pɔ́ bɔɔ́ Jus, abi ájwyaáge nyɛ ji, áshyɛ́ ji, ákpóo ji matyɛ mmyɛ. ");
INSERT INTO anvNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Átúlege nyɛ́ ji, ne áwá ji, yɛ́mbɔ ndɔ́ ɛ́lɛɛ́ ɛ́kwɔnégé, akwilége nyɛ né negbo.” ");
INSERT INTO anvNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Yɛ́ ndɛre Jisɔs ajɔɔ́ mbɔ, áŋgbá bií ákaá fɔ́ ula mechɔ́ ɛwíná wɔ́, ɛbwɔ́ álá tametame yɛ genó gema ágbaré né metɔɔ́ wɔ́. ");
INSERT INTO anvNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Jisɔs aké akwɔnege né mekpó meti Jɛriko, muú amɛ nónómé fɔ, ajwɔ́lé né mapea meti akɔɔ́ ŋka. ");
INSERT INTO anvNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Awúgé nkane gejamégé bɔɔ́ áwyále, ákóge, mende yimbɔ agií aké, Ndé mechɔ ɛchwɔɔ́? ");
INSERT INTO anvNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Ágaré ji áké, “Jisɔs ayi Nasarɛt ne akóge.” ");
INSERT INTO anvNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Mende yimbɔ awúgé mbɔ, alɔ mankálégé aké, “Jisɔs, mpyáne Dɛvid, gɛ́ me meshwɛ.” ");
INSERT INTO anvNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Bɔɔ́ abi abɔ ájyɛ́ mbɛ, álɔ manyáné ji nnó akwéné mejɔɔ́. Ndɛre ányáne mbɔ ji, ɛ́lú ɛké áchyɛ́ lé ji ɛshyɛ nnó akálé kéŋké. Ne aké, “Mpyáne mfwa Dɛvid, nkpá wɔ geká, gɛ́ me meshwɛ.” ");
INSERT INTO anvNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Jisɔs awúgé mbɔ atɛné, atɔ́ bɔɔ́ nnó ajyɛ́ achwɔ́ ne muú amɛ nónómé yimbɔ. Ɛbwɔ́ áchwɔ́gé ne ji, Jisɔs agií ji ake, ");
INSERT INTO anvNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Ndé genó wɔ ɔkɛ́lege mpyɛ́ ɛta wyɛ́?” Mende yina aké, “Ata, nkɛlege nnó ɔpyɛ́ me ngɛ́né mbaá.” ");
INSERT INTO anvNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Ne Jisɔs aké ne ji, “Lɔ yɛ́ mangɛ́né. Ɔtoó mbɔ gétúgé ɔfyɛɛ́ metɔɔ́ wyɛ́ ne me.” ");
INSERT INTO anvNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Tɛ́nétɛ́né yimbɔ alɔ mángɛ́né mbaá ne akwɔlege ji, ne afɛge Ɛsɔwɔ. Bɔɔ́ ako ágɛ́gé mbɔ, álɔ ntó mamfɛɛ́ Ɛsɔwɔ. ");
INSERT INTO anvNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Jisɔs akwɔ́négé melɔ Jɛriko, alɔ maŋkogé. ");
INSERT INTO anvNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Muú kpaa *ánsɛlé ŋkamakpo fɔ, abɔ́ alu ɛfɛɛ́ ayi akamege Sakiyɔs. Alu muú ŋka. ");
INSERT INTO anvNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Awúgé nnó Jisɔs akoge né melɔ bwɔ́, afɛ́ mangɛ́ gefɔgé muú ayi Jisɔs alú, yɛ́mbɔ agɛ ji wɔ́ gétúgé bɔɔ́ ájamé ne alu mboó. ");
INSERT INTO anvNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Ɛfɛɛ́ ne áboó gatɛlé ajyɛ́ kwɔ́ mfaá genɔɔ́ né mbaá yi Jisɔs akóge nyɛ́ nnó agɛ ji. ");
INSERT INTO anvNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Jisɔs akwɔ́négé né genɔɔ́ yimbɔ, apɛ amɛ mfaá, agɛ́ ji. Atɛné akú ji aké, “Sakiyɔs shúlé mme wáwá. Fina mbɔ́ mankpɛ wɔ uŋkɛɛ́.” ");
INSERT INTO anvNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Sakiyɔs awúgé mbɔ ashúlé mme tɛ́nétɛ́né, asɛ Jisɔs ne metɔɔ́ megɔmegɔ. ");
INSERT INTO anvNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Bɔɔ́ ágɛ́gé nkane Jisɔs ajyɛ́ ne Sakiyɔs, álɔ maŋmené aké, “Mende yiná ajyɛ́ kpɛ́ uŋkɛɛ́ mbaá muú ubeé.” ");
INSERT INTO anvNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Ɛbwɔ́ ne ji ájwɔ́légé mmu, ɛwyage Sakiyɔs akwilé tɛ́né aké, “Ata nkarege nyɛ́ unó ba nchyɛ́ geba mbaá bɔɔ́ gekpo, yɛ nnyɛ́ lé muú maŋwaá, nshúge nyɛ́ mbɔɔ́ genó ɛyimbɔ né malu ani.” ");
INSERT INTO anvNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Jisɔs awuúge mbɔ ake, “Ngarege ɛnyú nnó, fina bɔɔ́ bi álu né gepú yina átane né ɛfwyale gabo, gétúgé mende yina alú ntó mpyáne Abraham. ");
INSERT INTO anvNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Maá Ntɛ Mekwaá, achwɔ́ le mankɛle bɔɔ́ bi ánómé né ɛgbɛ ɛwe Ɛsɔwɔ nnó apyɛ́ ɛbwɔ́ átáné né ɛfwyale gabo.” ");
INSERT INTO anvNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Ndɛre bɔɔ́ ábɔ́ áwuú mechɔ́ ɛwé, Jisɔs ama gáre ɛbwɔ́ nekanémejɔɔ́ ɛníné fɔ́, getúgé ji alɛ́ mɛ́ kwɔ́kwɔ́lé ne Jɛrosalɛ ne bɔɔ́ afɛ́rege nnó *Gefwage Ɛsɔwɔ géchwɔ́ lɔ́ tɛ́nétɛ́né fa mme. ");
INSERT INTO anvNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Ajɔɔ́ aké, “Né gébé gefɔ́ maá mfwa fɔ alyá melɔ wuú, afɛ́ nekɛ né melɔ fɔ́ ɛwé ɛ́lú tɛtɛ nnó ákwéré ji ɛlá gefwa ne achwɔgé ábɛ́ mfwa né melɔ wuú. ");
INSERT INTO anvNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Gébé ɛyige achwɔ́ jyɛ́, akú baá defwɛ́ bií afya, akaré ɛbwɔ́ ŋka. Achyɛ́ yɛ́ndémuú gébagé ŋka, ne aké ne ɛbwɔ́, ‘Delagé fa, kɛ́ge gese ne ŋka yimbɔ kpaá tɛ nkérege.’ ");
INSERT INTO anvNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","“Ne ályaá ájyɛ́, yɛ́mbɔ bɔɔ́ melɔ wuú ápá ji dɔɔ́ tɛ átɔ́ bɔɔ́ nnó ájyɛ́ garé nnó, ‘Ɛbwɔ́ ákɛ́lege fɔ́ mende yimbɔ ábɛ́ mfwa bwɔ́.’ ");
INSERT INTO anvNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Yɛ́mbɔ ndɛre mende yimbɔ ajyɛ́, ákwéré ji ɛla ɛwémbɔ nnó achwɔ́ ábɛ́ mfwa. Ákérégé meso, akú baá defwɛ́ bií abi ji abɔ achyɛ́ ɛbwɔ́ ŋka nnó áchwɔ́ lɛré ji nsá ayi ɛbwɔ́ abɔɔ́ né ŋka yimbɔ. ");
INSERT INTO anvNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Maá utɔɔ́ ayi mbɛ achwɔ́gé aké, ‘Ata gébagé ŋka ɛyi ɔbɔ́ chyɛ́ me, gépyɛ mbɔ́ nsá úba ŋka úfya.’ ");
INSERT INTO anvNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Mende yina awúgé mbɔ, metɔɔ́ ɛgɔ ji ne aké, ‘Ɔpyɛ dɔɔ́, ɔlu maá utɔɔ́ melɔ́mélɔ́, muú akage nɛre metɔɔ́ ne wɔ. Ndɛre ɔpɛ́lé ɛkɛ́ genó ɛwé cháŋéné, nchyɛge nyɛ́ wɔ uto né malɔ́ áfya nnó ɔ́pɛ́lé ájí.’ ");
INSERT INTO anvNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Ayifɔ achwɔ́gé aké, ‘Ata gébagé ŋka ɛyi ɔchyɛ́ me, gépyɛ mbɔ nsá uba ŋka úta.’ ");
INSERT INTO anvNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Ne ajɔɔ́ ne ayimbɔ aké, ‘Nchyɛge nyɛ́ wɔ malɔ áta nnó ɔ́pɛ́lé ájí.’ ");
INSERT INTO anvNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Ne ayifɔ achwɔ́gé aké, ‘Ata gɛ́ gébagé ŋka jyɛ́. Mbɔ mpwé né gebágé ndeé mbelé. ");
INSERT INTO anvNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Mbélé ɛji gétúgé nkaá nnó gepɔ jyɛ́ getóo ne mfɔ́ɔ wɔ. Ne gébé ɛyigé fɔ́ ɔsɛle unó detú. Ɔkpane menyɛɛ́ né mekɔɔ́ ayi ɔlá kágé meso yi ápɛ́ne.’” ");
INSERT INTO anvNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Mende yimbɔ ake né maá defwɛ́ yimbɔ, ‘Ɔbɔ́ gepɔ, uchuú mejɔɔ́ ɛbi ɔjɔɔ́ ne nsɛ́le mpa, mpa wyɛ́. Ɔkaá nnó gepɔ yá getóo ne mma nsɛ́le unó detú ne mkpane menyɛɛ́ né mekɔɔ́ ayi nlá kágé meso yi ápɛ́ne. ");
INSERT INTO anvNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Ndɛre ɔkaá mbɔ, ndé ɔ́bɔ́ ɔlá fyɛ́ ŋka yá né gepúgé ŋka nnó nkeregé meso nsɛ ɛji ne nsa wɔ́?’ ");
INSERT INTO anvNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","“Ɛké ɛwyage ajɔɔ́ ne bɔɔ́ abi átɛ́né ɛfɛɛ́ aké, ‘Sɛ́ge gébagé ŋka yimbɔ, déchyɛɛ́ muú ayi awyaá uba ufya.’ ");
INSERT INTO anvNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Bɔɔ́ bimbɔ áshya áké, ‘Ata, ji awya mɛ́ úba ŋka úfya.’ ");
INSERT INTO anvNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Ajɔɔ́ ne ɛbwɔ́ aké, ‘Kaáge nnó muú ayi abɔgé nsá né genó, ji ne ámáge gbɛɛ́ ji ɛbwɔ, ne ayi álá abɔɔ́ nsá yɛ́ ɛ́kɛ́kɛ́ genó ɛwé ji awya, ásɛ́lé nyɛ́ geji ɛta wuú, nnó álá amu mawa. ");
INSERT INTO anvNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Nána bɔɔ́ mawámé ba, abi áshya nnó mbɛgé fɔ́ mfwa bwɔ́, chwɔ́ge ne ɛbwɔ́, dewá né mbɛ ushu wa.’” ");
INSERT INTO anvNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Jisɔs anérégé manjɔɔ́ nekanémejɔɔ́ ɛni, alɔ mankwɔ́ ajyɛ́ né Jɛrosalɛ. ");
INSERT INTO anvNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Ákwɔ́négé kwɔ́kwɔ́lé né melɔ́ Bɛtfage ne Bɛtani baá malɔ áyi alú mfaá mékwɛ́ ɛwé ákuú nnó Olif, atɔ́ baá utɔɔ́ makpo ápeá nnó ábɔ́ mbɛ, ");
INSERT INTO anvNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","aké ne ɛbwɔ́, “Chogé né maá melɔ ayi alu mbɔ ɛnyú né mbɛ, dekwɔnégé dégɛne nyɛ maá géjuŋá ayi áshií ji ne muú álú dankɛ́ wyɛ, kaágé déchwɔ́ ne geji fa. ");
INSERT INTO anvNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Ne mbɔgé muú agigé ɛnyú nnó, ‘Waá aké dekaá *géjuŋá yimbɔ?’, gárege ji nnó, ‘Ata ne akɛ́lege.’” ");
INSERT INTO anvNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Ne baá utɔɔ́ bimbɔ áfɛ́, ájyɛ́gé ágɛ́ yɛ́ndégenó ndɛre Jisɔs abɔ́ ajɔɔ́. ");
INSERT INTO anvNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Gébégé ákaágé maá géjuŋá yimbɔ, mbɔɔ́ géjuŋá achwɔ́ gií ɛbwɔ́ aké, “Waá aké ɛnyú dekaá géjuŋá yimbɔ?” ");
INSERT INTO anvNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Áshuú ji meko áké, “Ata ne akɛ́lege.” ");
INSERT INTO anvNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Áchwɔ́gé ne géjuŋá yimbɔ mbaá Jisɔs, áfere mandeé bwɔ́ ágyaá mfaá, ábwɛɛ́ ji ajwɔlé mfaá. ");
INSERT INTO anvNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Ndɛre Jisɔs ajyɛ́, bɔɔ́ ájyɛ ji mbɛ ágyaáge mandeé bwɔ́ né meti nnó ji akógé wyɛ́. ");
INSERT INTO anvNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Ákwɔ́négé mekpó Mekwɛ Olif, alɔ manshúle, ndɛre alɛ́ kwɔ́kwɔ́lé ne Jɛrosalɛ, ne gejamégé áŋkwɔlé bií, áchwɔɔ́ ji meso ákwáne kéŋké, áfɛ́ɛge Ɛsɔwɔ né ufélekpá ɛbi ɛbwɔ́ ágɛné. ");
INSERT INTO anvNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","“Mejé ɛbɛ́ ne Mfwa ayi áchwɔɔ́ né mabɔ Ata ayi alú né mfaánebuú, ɛniné mfaá mfaá, ji ne achyɛ́ge nesɔ.” ");
INSERT INTO anvNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Ne bɔɔ́ Farasi bifɔ́ áké, “Ménlɛré weé baá utɔɔ́ byɛ́ ákwéné mejɔɔ́.” ");
INSERT INTO anvNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Jisɔs ashuú ɛbwɔ́ meko aké, “Kaáge nnó yɛ mbɔgé bɔɔ́ bina ákwenégé mejɔɔ́, yɛ mataá ákálege nyɛ́ áfɛ́ɛge Ɛsɔwɔ.” ");
INSERT INTO anvNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Ndɛre Jisɔs akwɔné kwɔ́kwɔ́lé ne Jɛrosalɛ, apɛ ɛwu dómee, meshwɛ akwɔ́ ji metɔɔ́, alɔ manlilé ajɔge ");
INSERT INTO anvNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","aké, “Ɛ ɛ́ bɔɔ́ Jɛrosalɛ, fina ɛnyú debɔ́ dekaá genó ɛyi géchyɛ́ge ɛnyú nesɔ, ne nana dekágé sé gejí. ");
INSERT INTO anvNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Gébé gekwɔ́nege nyɛ ɛyigé bɔɔ́ mawámé nyú, áchwɔgé átɛ́né ɛkwɔ́ gepú ágyaá melɔ nyú mme, ákelé ɛnyú mmu. ");
INSERT INTO anvNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Ápyɛ́gémbɔ, ákpɛ́ne nyɛ mmu áwá ɛnyú ako, áma amú upú ɛnyú uko ne mbaá ala nyɛ dɛdɛ nnó yɛ ntaá nema nélagé mfaá ɛníne fɔ́. Mbɔ ne ɛbɛ́ɛ nyɛ́ néndé ɛnyú deshá mankaá bií bi Ɛsɔwɔ áchwɔɔ́ mampóo ɛnyú.” ");
INSERT INTO anvNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Jisɔs alyágé melu ɛwémbɔ, akpɛ né mmu ɛcha upɛ Ɛsɔwɔ, alɔ mamfwéné bɔɔ́ abi ákpóo unó né mmu. ");
INSERT INTO anvNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Ndɛre ábuú ɛbwɔ́ aké, “Ásá né mmu ŋwɛ Ɛsɔwɔ nnó, Ɛsɔwɔ aké, ‘Gepú ya gebɛ́ɛ nyɛ́ lé gepúgé mmyɛmenɛne.’ Ne nana ɛnyú débwɔlé géjí gelá melu ɛwé ánjó ábige wyɛɛ́.” ");
INSERT INTO anvNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Ne Jisɔs alɛrege wyɛ́ bɔɔ́ mmu ɛcha upɛ Ɛsɔwɔ yɛ́ndé bií. Né gébé yimbɔ anɔɔ́ baá abi ápyɛɛ́ upɛ Ɛsɔwɔ chóncho ne ánlɛré mabɛ́ Ɛsɔwɔ ne ákpakpa melɔ ákɛ́lege meti nnó áwá ji. ");
INSERT INTO anvNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Yɛ́mbɔ ɛbwɔ́ ágɛ meti wɔ́ néndé bɔɔ́ ájwɔlége yɛ́ndégébé áwú mekomejɔɔ́ Jisɔs ne ákɛlege fɔ́ nnó gechu jií gema gekoó mme detú. ");
INSERT INTO anvNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Bií fɔ́ Jisɔs abɔ́ alɛrege bɔɔ́ né ɛcha upɛ Ɛsɔwɔ, ágarege ɛbwɔ́ abya melɔ́mélɔ́ ayi atané mbaá Ɛsɔwɔ. Ndɛre ájɔ́gembɔ, anɔɔ́ baá abi ápyɛɛ́ upɛ Ɛsɔwɔ chóncho ne Ánlɛré mabɛ́ Ɛsɔwɔ, ne ákpakpa melɔ, áchwɔ chóo ne bɔɔ́ bimbɔ, ");
INSERT INTO anvNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","ágií Jisɔs aké, “Ndé uto ɛbi ɔwyaá mampyɛ unó bina? Waá achyɛɛ́ wɔ uto ubi?” ");
INSERT INTO anvNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Jisɔs ashuú ɛbwɔ́ meko aké “Me ntó nwyaá awa nkwɛ́ mangií ɛnyú ayi debɔ́ɔ manshuú me”. ");
INSERT INTO anvNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Ne agií ɛbwɔ́ aké, “Waá achyɛ Jɔn uto manwyaá bɔɔ́ manaá Ɛsɔwɔ, Ɛsɔwɔ waá akwaá?” ");
INSERT INTO anvNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Álɔ manjɔɔ́ ne atɛ áké, “Ɛ́bɛge dejɔɔ́gé nnó ɛlé Ɛsɔwɔ ne achyɛɛ́ Jɔn uto bi, agige nyɛ ɛsé aké, ‘Ulannó ne delá kamé mekomejɔɔ́ wuú wɔ́.’ ");
INSERT INTO anvNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Ne mbɔgé dejɔgé nnó, ‘Útané mbaá akwaá,’ bɔɔ́ ako áwáne nyɛ́ ɛsé ne mataá gétúgé ɛbwɔ́ ákaá wáwálé nnó Jɔn abɔ́ alu *Muú Ɛkpávé Ɛsɔwɔ.” ");
INSERT INTO anvNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Ne áké ne ji, “Ɛse dekaá fɔ mbaá yi uto bií utane wɔ́.” ");
INSERT INTO anvNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Ne Jisɔs ashuú ntó ɛbwɔ́ meko aké, “Yɛ́ me ntó ngárégé fɔ́ ɛnyú muú yi achyɛ́ me uto ne mpyɛ́ unó bina.” ");
INSERT INTO anvNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Jisɔs alɔ mangaré bɔɔ́ bina nekanémejɔɔ́ ake, “Mende fɔ abɔ atɔ́ mekɔɔ́, apɛ unɔɔ́ ɛbi ákuú vine, ábɔgé umpome bií ápyɛ mmɔɔ́. Asɛ bɔɔ́ uségé afyɛ́ wyɛ. Atane afɛ́ nekɛ né melɔ fɔ, ɛwú ne ábɛ́lé dɔɔ́. ");
INSERT INTO anvNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Gébé gekwɔ́négé ɛyigé ákyɛ́ umpómé bimbɔ, mbɔɔ́ mekɔɔ́ atɔ́ maá defwɛ́ wuú ama mbaá bɔɔ́ uségé bimbɔ nnó áchyɛ ɛbií unó mbwɛ́ ɛbi utane né mekɔɔ́ ɛwémbɔ. Yɛ́mbɔ ɛbwɔ́ átulé maá defwɛ́ yimbɔ, ábú ji akéré amu amu. ");
INSERT INTO anvNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Ama tɔ́ ayifɔ, ɛbwɔ́ ágɛ́gé ji, ásɛ ji ne matúlé, áchyɛ́ ji mekpo unɔɔ́, ábú ntó ji akéré amuamu. ");
INSERT INTO anvNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Mende yimbɔ ama tɔ́ maá defwɛ́ ayifɔ, bɔɔ́ bimbɔ átulé ji, afyɛ́ ji upa mmyɛ, ne ája ji mmemme átó ji dafyɛ. ");
INSERT INTO anvNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Ne mbɔɔ́ mekɔɔ́ yimbɔ aké, ‘Mpyɛ nyɛ́ nnó? Ɛlú galɔ́gálɔ́ nnó ntɔ́ nana maá wa ayi ngboó ne ji dɔɔ́, ndɔfɔ ágɛgé nyɛ ji, áchyɛge ji ɛ́nógé.’ ");
INSERT INTO anvNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Maá yimbɔ afɛ́, ne ndɛre álɛ́ kwɔ́kwɔ́lé, bɔɔ́ bimbɔ ágɛ́ ji ne áké ne atɛ, ‘Gɛ́ge menyɛɛ́ geteé mbɔɔ́ mekɔɔ́ na, chwɔ́ge déwá ji, geteé jií geláa ɛyigé ɛsé.’ ");
INSERT INTO anvNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Ákpɛ́gé mmu mekɔɔ́, ája ji átó dafyɛ, áwá ji.” Jisɔs anerege nekanémejɔɔ́ ɛni, agií bɔɔ́ abi alú ɛfɛɛ́ ake, “Ɛnyú defɛré nnó mbɔɔ́ mekɔɔ́ yimbɔ apyɛ nyɛ nnó ne bɔɔ́ uségé bimbɔ? ");
INSERT INTO anvNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Ɛlú wáwálé nnó, abɔ́ manchwɔ́ awá bɔɔ́ bimbɔ achyɛɛ́ mekɔɔ́ ɛwémbɔ mbaá bɔɔ́ abi cha.” Bɔɔ́ bina áwúge mbɔ aferé ubée áké, “Ɛsɔwɔ akamégé.” ");
INSERT INTO anvNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Jisɔs apɛ ɛbwɔ́ dómeé ne agií aké, “Ne nana genó ɛyigé ásáme mmu ŋwɛ Ɛsɔwɔ geke nnó? Ásá nnó: ‘Ntaá ɛniné antɛné upú ashyaá nnó nélɔ́mé, néni ne nélaá menɔ ntaá ayi ágbaré ɛkwɔ gepú.’ ");
INSERT INTO anvNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Muú akwegé mfaá ntaá ɛnine mbɔ, atyáge nyɛ ubauba ne mbɔgé nekwége muú mmyɛ, muú yimbɔ alá nyɛ yiliyili.” ");
INSERT INTO anvNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Jisɔs agárégé nekanémejɔɔ́ ɛni, *Ánlɛré mabɛ́ Ɛsɔwɔ ne anɔɔ́ baá bi apyɛ upɛ Ɛsɔwɔ áwúgé, ákaá nnó ajɔge mbɔ lé ne ɛbwɔ́, ábɔ́ álú mampyɛ Jisɔs wyɛ́ né gébé ɛyigémbɔ, yɛ́mbɔ ágɔ́ gétúgé áfɔ́ɔ amɛ́ bɔɔ́. ");
INSERT INTO anvNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Bɔɔ́ bina ámalɔ́ mankɛ́lé meti ɛwéchá, ne átɔ́ bɔɔ́ nnó ájyɛ́ pyɛ́ ɛké ábɔɔ́ mechɔ́ ne Jisɔs wɔ́, nnó mbɔgé Jisɔs akwegé nekwené meno, ɛbwɔ́ ágbáré ji ájyɛ́ mbaá ámpané mpa abi átɔ́mé nyɛ ji mbaá gɔ́mena ayi Rom. ");
INSERT INTO anvNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Bɔɔ́ bimbɔ ájyɛ́gé ákú Jisɔs áké, “Ménlɛré, ɛsé dékaá nnó depɔ ɛtiré ɔgárege ne ɔlɛ́rege délú wáwálé. Ɔpɔ́ fɔ́ meso ama. Ɔlɛrege bɔɔ́ unó ndɛre Ɛsɔwɔ akɛ́lege wáwálé.” ");
INSERT INTO anvNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Ɛsé dekaá wɔ́, “Nnó ɛbɛ́ sé ɛké nnó déchyɛ́gé ŋkámakpo mbaá mfwa Rom waá déchyɛ́gé?” ");
INSERT INTO anvNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Jisɔs akágé nnó ápɛné mbɔ ji lé metáa, aké ne ɛbwɔ́, ");
INSERT INTO anvNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Chwɔ́ge me ne sére ama. Áchwɔ́gé ne ji, agií ɛbwɔ́ aké, Mekpo wá na ne mabɔ waá na ásamé né ŋka ɛyi?” Áké ne Jisɔs, “Ɛ́lé mekpo mfwa Rom ne mabɔ mií.” ");
INSERT INTO anvNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Ne Jisɔs aké ne ɛbwɔ́, “Chyɛge Mfwa Rom genó ɛyí gélú ɛjií ne chyɛge ntó Ɛsɔwɔ genó ɛyi gélú ɛyi Ɛsɔwɔ.” ");
INSERT INTO anvNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Gefɔɔ́ ɛyigé Jisɔs akwyɛ́ meko ashuú ɛbwɔ́ gepyɛ byɔ úkɔré ɛbwɔ́ mmu, álá nyámé néndé ágɛ́ fɔ́ genó ɛyigé ji apyɛɛ́ wɔ́. ");
INSERT INTO anvNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","*Bɔɔ́ Jus fɔ́ abi ákú bwɔ́ *Sadusi. Ɛbwɔ́ alú bɔɔ́ bi áké muú agbógé akwilége sé né negbo. Áchwɔ́ gií Jisɔs áké, ");
INSERT INTO anvNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Ménlɛré, Mosis abɔ asá ɛbɛ́ ɛwéna mmú ŋwɛ mabɛ́ sé nnó ‘Mbɔgé muú abagé mendée wuú ne agbógé alyagé mendée yimbɔ ayi ɛbwɔ́ álá byɛ́ maá wɔ́, meŋmó wuú abɔ́ mansɛ mendée yimbɔ né ukwi, nnó ábyɛ́gé baá ábɛ́lé né mabɔ ami mewené meŋmo yimbɔ.’ ");
INSERT INTO anvNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Ágare ji neka ɛni áké, áŋmó fɔ ákénéama abi ande álú abi átané ntɛ ama. Meŋmó yi muú kpaa abɔ́ abá mendée wuú ne agbó ayi ɛbwɔ́ álá byɛ maá wɔ́. ");
INSERT INTO anvNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Ayi akwɔ́lege ji asɛ mendée yimbɔ né ukwi. Ayi mbɔ agbó ntó ayi ɛbwɔ́ álá byɛ́ maá wɔ́. ");
INSERT INTO anvNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Ɛpyɛ wyɛ́mbɔ kpaá ɛbwɔ́ ákénéama ágbó ako. Yɛ́ muú yi ábyɛné maá ne mendée yimbɔ apɔ́. ");
INSERT INTO anvNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Ɛ́bɛ́légé mendée yimbɔ ntó agbó.” ");
INSERT INTO anvNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Ájɔgémbɔ, ágií Jisɔs áké, “Ndɛre aŋmó bina ákénéama ábɔ́ ábané mendée yina, gébégé ɛbwɔ́ ako ákwilégé né negbo, mendée yina abɛɛ́ nyɛ ayi waá?” ");
INSERT INTO anvNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Ne Jisɔs ashuú ɛbwɔ́ meko ake, “Né mme yina ande ábáné andée ne andée átɔ́ anɔ́. ");
INSERT INTO anvNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Yɛ́mbɔ gébégé bɔɔ́ abi Ɛsɔwɔ asɛ́lé nnó ákwáné, bɔɔ́ ákwilégé né negbo, ákpɛgé né mme yi achwɔ́ nyɛ, gébé ɛyigembɔ, yɛ neba nébɛɛ́ se. ");
INSERT INTO anvNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Ndɛre Ɛsɔwɔ apyɛ ɛbwɔ́ ákwilégé né negbo, ámágé gbó sé, néndé álú nkane makiɛ́nné Ɛsɔwɔ, ne álú baá Ɛsɔwɔ tɛ kwyakwyá. ");
INSERT INTO anvNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Mosis ntó alɛré wáwálé nkane muú ágbógé ákwilégé né negbo. Asá abya genɔɔ́ ɛyigé mewɛ ɛbɔ ɛluli wyɛ gélá sɔɔ́ge ne akuú Ata Ɛsɔwɔ né melu ɛwémbɔ mmu ŋwɛ wuú nnó, Ɛsɔwɔ ayi Abraham ne ayi Asek ne ayi Jakɔb. ");
INSERT INTO anvNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Mosis akúgé ji mbɔ, ɛ́lɛré nnó Ɛsɔwɔ alu ayi bɔɔ́ abi álú abɛ. Ɛsɔwɔ apɔ́ fɔ́ Ɛsɔwɔ ayi awuú bɔɔ́, alu ayi bɔɔ́ abi álú abɛ, néndé bɔɔ́ ako álú abɛ né mbɛ ushu wuú.” ");
INSERT INTO anvNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Jisɔs ajɔ́gé mbɔ, Ánlɛré mabɛ́ Ɛsɔwɔ abifɔ áké ne ji, “Ménlɛré ɔlu cho.” ");
INSERT INTO anvNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Ɛbwɔ́ áwúgé mbɔ, mano bwɔ́ ákpɛ né mekɔ́, yɛ́ muú ayi ama mua mangií ji nkwɛ́ apɔ́. ");
INSERT INTO anvNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Ɛwyage Jisɔs ntó agií ɛbwɔ́ awuú nkwɛ́ aké, “Bɔɔ́ ájɔge nnó Muú yi Ɛsɔwɔ akweré ji ɛlá gefwa alu mpyáne mfwa Dɛvid, ɛwena ɛ́bɛ́ɛ mbɔ nnó? ");
INSERT INTO anvNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Ɛnyú dekaá nnó mfwa Dɛvid asá né ŋwɛ makwa wuú nnó: ‘Ata Ɛsɔwɔ ajɔɔ́ ne Ata wa nnó, jwɔlé fa né ɛgbɛ́ ɛbwɔnyɛ wa, ");
INSERT INTO anvNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","kpaá tɛ gébé gékwɔ́nege nyɛ́ ɛyigé mpyɛ bɔɔ́ mawámé byɛɛ́, álaá ɛké mboó genɔɔ́ nnó ɔ́nɛ́ré uká byɛɛ́ mfaá.’ ");
INSERT INTO anvNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Ɛwéna ɛ́lɛré nnó Mfwa Dɛvid akuú Muú yi Ɛsɔwɔ akweré ji ɛlá gefwa nnó Ata wuú. Ɛpyɛmbɔ nnó ne *Muú yi Ɛsɔwɔ akweré ji ɛlá gefwa ama alú mpyáne Dɛvid?” ");
INSERT INTO anvNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Nana Jisɔs ajɔge lé ne baá utɔɔ́ bií ne bɔɔ́ ako áwúu ntó, aké, ");
INSERT INTO anvNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Sɛ́ge gébé ne gepɔgé ánlɛré mabɛ́ Ɛsɔwɔ. Ɛbwɔ́ ágbóo mamfyɛ́gé bɔ nkúu átyɛ́ átyɛ́, ákɛ́né, ágyaáge ntoné gese nnó bɔɔ́ átámégé ɛbwɔ́ ne ɛ́nógé. Ágboó ntó mánjwɔ́lé né malu ɛ́nógé né mmu macha mmyɛmenɛne. Ájyɛ́gé ɛpaá, ájyaá lé malu afwa ne ájwɔ́lege. ");
INSERT INTO anvNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Yɛ́mbɔ, mmyɛ́ ɛgbóo ɛbwɔ́, áfwyálege akwi andée, áfɔ́ɔge upú bwɔ́, ne ama ákɛ́ne malumalu, ánɛ́nemmyɛ áwyáge dɔɔ́ nnó ágilégé bɔɔ́ amɛ. Ndɛre ápyɛ́ mbɔ, áfyɛ́ lé getoó né mmyɛ bwɔ́. Ákpɛ́ne nyɛ́ né ɛfwyale ɛwé mebo.” ");
INSERT INTO anvNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Ndɛre Jisɔs alú mmu ɛcha upɛ Ɛsɔwɔ, apɛle dómee nkane bɔɔ́ ŋka áchwɔ́ áfyɛ maŋka bwɔ́ mmu genó ɛyigé áfyɛ ŋka Ɛsɔwɔ. ");
INSERT INTO anvNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Agɛ́ ntó mbya mekwi mendée fɔ ndɛre afyɛ́ baá ubaá ŋgba ápeá. ");
INSERT INTO anvNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Ágɛ́gémbɔ aké, “Kaáge wáwálé nnó ŋka yi mbyá mekwi mendée yina afyɛ, ɛjá ɛpwɔ ɛyi bɔɔ́ ako áfyɛ́. ");
INSERT INTO anvNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Yɛ́ndémuú áferé ɛkɛkɛ ŋka né gejamé ɛyi ji awyaá achyɛ́, yɛ́mbɔ, yɛ lé mekwi mendée yina alu mbya, akwe ula géba jií achyɛɛ́.” ");
INSERT INTO anvNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Baá utɔɔ́ bifɔ́ álɔ mamfɛ́gé ɛcha upɛ Ɛsɔwɔ nkane átɛné ɛwú ne uchánchá mataá, ne ama afɛ́ge uchánchá unó bi achyɛ́ nnó ánógé Ɛsɔwɔ. Ɛfɛɛ́ Jisɔs aké ne ɛbwɔ, ");
INSERT INTO anvNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Ɛnyú degɛne unó bi, dema defɛɛ́ge yɛ́mbɔ gébé gékwɔ́négé nyɛ́ ɛyigé amúu ɛwú ne yɛɛ́ ntaá némaá ɛni nélaá mfaá ntɛ népɔ́.” ");
INSERT INTO anvNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Ágií ji áké, “Menlɛ́ré, nde gébé ɛyige depɔ tiré na depyɛ́ nyɛ? Nde genó ɛyi gélɛ́rege nyɛ́ nnó unó bi uchwɔɔ́ pyɛ́?” ");
INSERT INTO anvNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Jisɔs ashuú ɛbwɔ́ meko aké, “Sɛ́ge gébé nnó ɛ́kagé muú fɔ ábwɔ́lé ɛnyú dénó mewaá. Nénde, gejamégé bɔɔ́ ásɛ́le nyɛ mabɔ ma áchwɔ́ ɛta nyú, áké, ‘Me ne nlú’ ne ájɔɔ́ge nyɛ́ nnó, ‘Gébé gékwɔné.’ Ájɔɔ́ge depɔ tí, déwugé fɔ́ ɛbwɔ́. ");
INSERT INTO anvNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Ne déwuú nyɛ ntó abya be kwɔ́kwɔ́lé ne ɛnyú, ne ɛbi ámmyɛ tɛtɛ, défɔgé fɔ́. Unó bina uko ubɔ́ɔ mbɛ upyɛ ne ɛpɔ́fɔ́ nnó mme yina achwɔ kwyá tɛ́nétɛ́né wɔ́.” ");
INSERT INTO anvNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Jisɔs amajɔɔ́ ne ɛbwɔ́ ake, “Malɔ kpakpa ámmyɛ nyɛ ne atɛ ne atɛ afwa ne bɔɔ́ bwɔ́ ámmyɛ nyɛ ne atɛ, ");
INSERT INTO anvNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Ukpɛ́kpɛ́ unó upyɛɛ́ nyɛ́ mme yina anyíge ne ɛshyɛ abwɔlé né gejamégé malu. Ɛmímí mesa ɛkwéne nyɛ́ né malumalu, ne mamée áwáne nyɛ́ bɔɔ́. Unó bi úgyálege manɛ upyɛ́ nyɛ́ né nebuú manlɛré ubée unó bi uchwɔ pyɛ. ");
INSERT INTO anvNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Gemɛ́gé nnó unó bi upyɛ; kaáge nnó bɔɔ́ ápyɛ́ne nyɛ ɛnyú, áma átulé ɛnyú. Dekpɛne nyɛ́ unɔɔ́ mpa né macha mmyɛmenɛne ne áfyɛ́ nyɛ́ ɛnyú denɔ. Ájyɛ́ nyɛ́ ne ɛnyú né mbɛ ushu afwa ne bɔ gɔ́mena gétúgé dékamé nnó delu bɔɔ́ ba. ");
INSERT INTO anvNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Gébégé detɛnégé mbɛ ushu bɔɔ́ bimbɔ, kaáge nnó debɔ́ mbɔ ɛ́lé meti mangaré ɛbwɔ́ mekomejɔɔ́ Ɛsɔwɔ. ");
INSERT INTO anvNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Yɛ́mbɔ ɛkagé dechyɛ́ gemɛ nyú ɛfwyale, mamfɛ́régé unó bi dejɔ́ge nyɛ́. ");
INSERT INTO anvNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Gébé gekwɔnégé, nchyɛge nyɛ́ ɛnyú deŋgaré mejɔɔ́ ɛti déjɔ́gé yɛ muú mawame nyú ayi anénége geyɔ́ yɛ manyɛ́ mbeé ábɛɛ́. ");
INSERT INTO anvNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Kaáge nnó bɔɔ́ ɛnyú ne ákpóo nyɛ́ ɛnyú, yɛ ɛ́bɛ́lé ántɛ nyú, yɛ áŋmɛ́ nyú yɛ bɔɔ́ ula gepú nyú, yɛ ajeé nyú. Áchyɛ́ge nyɛ ɛnyú mbaá ákpakpa melɔ, nnó détɛ́né unɔɔ́ mpa ne áwáne nyɛ ɛnyú bífɔ́. ");
INSERT INTO anvNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Bɔɔ́ ako ápaá nyɛ ɛnyú gétúgé délú áŋkwɔlé ba. ");
INSERT INTO anvNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Yɛ ɛŋkaá mejwɛ ɛwé ɛ́júge nyɛ́ né mekpo nyú ɛkwé, ɛnó ɛpɔ́. ");
INSERT INTO anvNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Dekamégé metɔɔ́ ɛma, dekpɛ́ne nyɛ́ mmu geŋwá ɛyi gelá gebyɛ́. ");
INSERT INTO anvNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Gébégé degɛgé nnó bɔɔ́ bee ánɔ melɔ Jɛrosalɛ mme, kaáge nnó gébé gekwɔné ɛyigé áchwɔ chɔ́ ɛwu. ");
INSERT INTO anvNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Gébégé mechɔ́ ɛwé ɛpyɛgé, bɔɔ́ ako abi né gebagé mewaá Judiya ábó ajyɛ́ bií mfaá makwɛ. Bɔɔ́ abi álú né melɔ ɛwémbɔ áboó ntó. Yɛ́ndémuú ayi atanégé mekɔɔ́, ɛkage akyaá nnó ajyɛ́ mmu. ");
INSERT INTO anvNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Kaáge nnó gébé ɛyigémbɔ, ɛ́lé bií bi Ɛsɔwɔ atɔ́me nyɛ́ ɛfwyale né melɔ Jɛrosalɛ mampyɛ nnó unó bi ásáme mmu ŋwɛ wuú ubɛ́ wáwálé. ");
INSERT INTO anvNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Ɛ ɛ́ ɛbɛ́ɛ nyɛ mbɔ nnó ne andeé abi álú ne manɛ yɛ́ ne abi áchyɛ́ge baá mámbɛ. Ɛsɔwɔ asɔ nyɛ́ metɔɔ́ ne melɔ ɛwé, ne bɔɔ́ ako ágɛ́ne nyɛ́ gebégé ɛfwyale. ");
INSERT INTO anvNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Áwáne nyɛ́ abifɔ ne desaá, ásɛ́le nyɛ́ abifɔ nkane bɔɔ́ denɔré bee, ákaré átɔ́ né malɔ mako. Ne bɔɔ́ abi álá pɔ́ bɔɔ́ Jus ápwɔ nyɛ́ melɔ Jɛrosalɛ, ne áchyɛ́ge nyɛ́ ɛbwɔ́ ɛfwyale, kpaá gébé bwɔ́ gébyɛ́. ");
INSERT INTO anvNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Né gébé ɛyigémbɔ, ágɛ́né nyɛ ufɔɔ́ unó bi upyɛ né ŋmɛɛ́ ne mfaá ne ambe. Né mme, gewyágé mgbannyi ɛyi gétánege né ɛbɛɛ́ mega, gepyɛ́ nyɛ́ gejamégé malɔ áfɔ́ɔ nnó ɛbɛɛ́ ɛ́chwɔ kpá ɛbwɔ́. ");
INSERT INTO anvNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Bɔɔ́ áwére nyɛ́ ne ɛfɔ né metɔɔ́ getúge ákaá nnó unó bi ugyálege manɛ uchwɔ́ pyɛ́ né malɔ mako. Ne unó bi uwyaá uto né mfaánebuú unyíge nyɛ, ");
INSERT INTO anvNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","ne ágɛ́ne nyɛ nkane Maá Ntɛ Mekwaá achwɔɔ́ né mmu gekó ne uto bií, ne gekpɛ́kpɛ́gé ɛ́nógé. ");
INSERT INTO anvNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Degɛ́gé nnó unó bi úlɔ mampyɛ, tɛ́nege, dégilé gétúgé dekaá nnó gébé gékwɔné ɛyigé Ɛsɔwɔ achwɔ féré ɛnyú né ɛfwyale.” ");
INSERT INTO anvNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Ne Jisɔs agaré ɛbwɔ́ nekanémejɔɔ́ ake, “Pɛge gepɔge genɔɔ́ge fig ne unɔɔ́ uko ɛbi úlálege bya. ");
INSERT INTO anvNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Gébégé degɛgé nnó unɔɔ́ bimbɔ úlɔ mantó bya ukɛ, dekaá nnó nshwɔné alé chwɔ́ lɔ́ɔ. ");
INSERT INTO anvNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Wyɛ́mbɔ ntó, gébégé ɛnyú dégɛ́gé nnó unó bina upyɛɛ́, débɔ́ mankaá nnó Ɛsɔwɔ achwɔ gbaré Gefwa jií. ");
INSERT INTO anvNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“Ngarege ɛnyú wáwálé nnó njyɛ ɛníné na négboó fɔ́ kpaá tɛ unó bina ukó úpyɛɛ́. ");
INSERT INTO anvNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Mfaá ne mme ákwyáge nyɛ, yɛ́mbɔ mekomejɔɔ́ wa alaá tɛ kwyakwya. ");
INSERT INTO anvNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Sɛ́ge gébé nnó dékagé dényɛ́gé geŋwá, ne dényúgé mmɔɔ́ dékwéné, ɛ́kagé matɔɔ́ nyú átáné ne Ɛsɔwɔ. Ɛ́kagé dénɛ́régé matɔɔ́ né geŋwágé mme yina nnó ɛ́kagé bií bimbɔ úbáné ɛnyú nkane menya akwéne metaá. ");
INSERT INTO anvNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Ne depɔ ɛtiré bií bimbɔ dégbárege nyɛ́ bɔɔ́ ako abi álú fá mme. ");
INSERT INTO anvNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Kpómege mmyɛ, dénɛ́némmyɛ mbaá Ɛsɔwɔ yɛ́ndégébé, nnó ji achyɛ́ ɛnyú ɛshyɛ dékoó né ɛfwyale ɛwé ɛchwɔ́ nyɛ. Depyɛgé mbɔ, detɛnege nyɛ́ mbɛ ushu Maá Ntɛ Mekwaá ayi déla pɔ́ ne deba.” ");
INSERT INTO anvNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Yɛ́ndé bií Jisɔs alɛrege wyɛ́ bɔɔ́ né ɛcha upɛ Ɛsɔwɔ. Anerégé, yɛndé nkwale ajyɛ né Mekwɛ́ Olif. ");
INSERT INTO anvNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Ne yɛndé dondo bɔɔ́ ako áchwɔ, ajwɔ́lege mmu ɛcha upɛ Ɛsɔwɔ manwú mekomejɔɔ́ wuú. ");
INSERT INTO anvNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Ne gébé gébɔ́ géfií ɛyigé ányɛɛ́ ɛpaá koó upú ne ɛpaá brɛd yi álá muálé. ");
INSERT INTO anvNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Né gébé ɛyigémbɔ, anɔɔ́ baá ámpyɛɛ́ upɛ Ɛsɔwɔ ne ánlɛré mabɛ́ Ɛsɔwɔ, ábɔ́ ákɛ́lege meti nnó áwá Jisɔs bibí, nendé, áfɔɔ́ nya bɔɔ́ melɔ. ");
INSERT INTO anvNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Ne danchɔmeló akpɛ mmu metɔɔ́ Judas ayi ákuú ji ntó Iscarot, maá utɔɔ́ ama né geluágé abi áfyaneápeá. ");
INSERT INTO anvNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Ajyɛ sɔ́ ula ne Anɔɔ́ baá ámpyɛɛ́ upɛ Ɛsɔwɔ ne bɔɔ́ kpakpa abi ábáme ɛcha upɛ Ɛsɔwɔ, nnó ákpoó ɛbwɔ́ Jisɔs. ");
INSERT INTO anvNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Ɛbwɔ áwúgémbɔ, matɔɔ́ ágɔ ɛbwɔ́ ne ákamé nnó áchyɛ́ge Judas ŋka. ");
INSERT INTO anvNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Judas akamé mechɔ́ ɛwé ájɔɔ́ ne álɔɔ́ mankɛ́légé meti ɛwé ji apyɛɛ́ ne Jisɔs akpɛ ɛbwɔ́ né ámu nkane gejamégé bɔɔ́ álá kágé. ");
INSERT INTO anvNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Bií ɛbi áwáne maá ɛgɔ́ŋme gepɛ mbaá ɛpaá brɛd yi álá muálé, úkwɔ́négé, ");
INSERT INTO anvNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Jisɔs atɔ́ Pita ne Jɔn aké, “Chógé depyɛ́ menyɛɛ́ ɛpaá *koó upú nnó ɛsé dejyɛ́ dényɛ́ ɛ́wú.” ");
INSERT INTO anvNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Ágií ji áké, “Ɔkɛlege nnó ɛsé dejyɛ́ detyɛɛ́ menyɛɛ́ ɛ́fɔ́?” ");
INSERT INTO anvNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Ashuú ɛbwɔ́ meko ake: “Wuúge, mbɔgé dejyɛgé, dekpɛgé né melɔ́ kpaá, degɛne nyɛ mende fɔ ne ŋkwɔ́ manaá né mekpo, kwɔ́lege ji né gepú ɛyigé ji akpɛ́ne. ");
INSERT INTO anvNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Gébégé ɛnyú dekpɛ́gé, gárege mbɔɔ́ gepú nnó: ‘Ménlɛré aké, lɛ́ré ɛsé maá gepú áŋkɛɛ́, ayi ji anyɛɛ́ nyɛ́ menyɛɛ́ ɛpaá koó upú ne baá utɔɔ́ bií.’ ");
INSERT INTO anvNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Ne mbɔɔ́ gepú yimbɔ alɛrege nyɛ ɛnyú maá gepú ayi alú tɛ mfaá ɛnyɔ́ŋ ayi ákwyɛ́ mɛ́ ábélé. Pyɛ́gé menyɛɛ́ yimbɔ ɛ́wu.” ");
INSERT INTO anvNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Áfɛ́, ágɛ́ wyɛ yɛ́ndégenó nkane Jisɔs abɔ́ agaré ɛbwɔ́. Ne átyɛ́ ntó menyɛɛ́ ɛpaá koó upú yimbɔ. ");
INSERT INTO anvNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Gébé gékwɔ́négé, Jisɔs ne áŋgbá bií áchwɔ́ álɔ manyɛ́ menyɛɛ́ yimbɔ. ");
INSERT INTO anvNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Ne Jisɔs aké ne ɛbwɔ́: “Mbɔ́ gejigé metɔɔ́ manjwɔlé chóncho ne ɛnyú nnó dényɛ́ ɛpaá koó upú ne ngɛ́ ɛfwyale. ");
INSERT INTO anvNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Kaáge nnó me mmáge nyɛ́ sé ɛpaá ɛwéná kpaá tɛ depɔ ɛtiré ɛpaá ɛwé débɛ́ɛ wáwálé, gébégé Ɛsɔwɔ agbárege nyɛ́ gefwa jií.” ");
INSERT INTO anvNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Ne abwɛɛ́ amó ne mmɔɔ́ né mmu, achyɛ́gé matame mbaá Ɛsɔwɔ, achyɛɛ́ mmɔɔ́ mimbɔ mbaá áŋgbá bií aké: “Sɛ́ge dényú, déchuú átɛ. ");
INSERT INTO anvNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Ngarege ɛnyú wáwálé nnó, ɛ́lɔ nana ɛjyɛ́gé mbɛ, nnyú sé mmɔɔ́ mina tɛ gébé ɛyígé Ɛsɔwɔ aké agbarege gefwa jií.” ");
INSERT INTO anvNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Abɔ́ ntó brɛd, áchyɛgé matame mbaá Ɛsɔwɔ, agyá nto brɛd yimbɔ ubauba achyɛɛ́ bwɔ́ aké, “Gɛ́ge menyammyɛ wa ayi nchyɛ́ge né gétúgé ɛnyú. Pyɛ́gé wyɛ́ na mantégé negbo na.” ");
INSERT INTO anvNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Áke ánérege manyɛɛ́ menyɛɛ́, ama bɔ́ amó ne mmɔɔ́ né mmu, aké, “Amo yina, ɛ́lé *menomenyɛɛ́ mekɛ ɛwé Ɛsɔwɔ anyɛɛ́ nyɛ ndɛre manoó ma magbɛ́lege nyɛ́ né mme né gétúgé ɛnyú. ");
INSERT INTO anvNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Yɛ́lé njɔ́gembɔ, muú ayi akpóo nyɛ́ me alu fá né ujwɔ́lé bina. ");
INSERT INTO anvNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Kaáge nnó Maá Ntɛ Mekwaá agbóo nyɛ wyɛ nkane Ɛsɔwɔ amɛɛ́ abelé, yɛ́mbɔ utoŋkwa ubɛ ne muú ayi akpóo nyɛ́ ji.” ");
INSERT INTO anvNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Áŋgbá bií áwúgé mbɔ, álɔ mangií atɛ áké, “Waá álú né geluáge sé ayi apyɛ́ nyɛ́ gefɔɔ́ genó ɛyígé na?” ");
INSERT INTO anvNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Né gébé gefɔ́, áŋgbá Jisɔs álɔ mbeé manyɛ́gé ne atɛ, nnó waá alú muú kpaa né geluáge bwɔ́. ");
INSERT INTO anvNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Jisɔs awúgé mbeé bwɔ́, ajɔɔ́ ne ɛbwɔ́ aké, “Gɛ́ na ne afwa mme abi álá pɔ́ bɔɔ́ Jus ápyɛɛ́. Ágárege nnó uto melɔ meko úlú ɛbwɔ́ né ámú, ájyárege bɔɔ́ ne uká, ne ama ákɛ́lege nnó bɔɔ́ ákwáné galɔ́gálɔ́ ayi ɛbwɔ́ ápyɛ. ");
INSERT INTO anvNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Yɛ́mbɔ, ɛ́bɛ́gé fɔ́ mbɔ ne ɛnyú. Muú kpaá nyú abɛ nkane mamáné ne menɔmbɛ abɛɛ́ nkane ménkpané defwɛ́. ");
INSERT INTO anvNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Waá alú muú kpaá? Muú ayi áchóge ji menyɛɛ́ nnó anyɛ́ waá muú ayi áchwɔ ne menyɛɛ́? Ɛ́lé ji ayi áchóge ji menyɛɛ́ nnó anyɛ́ pɔ́ mbɔ? Yɛ́mbɔ me nlu né geluágé ɛnyú ndɛre menkpané menyɛɛ́.” ");
INSERT INTO anvNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Jisɔs aké, “Yɛ́ ndɛre ngɛ́ne ɛfwyale, ɛnyú ne délú wyɛ́ ne me. ");
INSERT INTO anvNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Gétú ɛyigémbɔ, mpyɛ nyɛ́ ɛnyú nnó débɛ́ afwa wyɛ́ nkane ntɛ wa apyɛ me ntó nlú Mfwa. ");
INSERT INTO anvNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Denyɛ nyɛ́, denyú ne me né gefwa ya. Dejwɔlege nyɛ́ ntó ndɛre afwa mampáné depɔ né matoó áfyáneápeá ayi bɔɔ́ Isrɛli.” ");
INSERT INTO anvNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Jisɔs akú Pita aké, “Simun, Simun! Gɛ́ ngarege wɔ nnó danchɔmeló asɛ uto nnó amuá ɛnyú, mamféré matɔɔ́ nyú ne me nkane ácháge ɛsa, áférege ukwɔɔ́. ");
INSERT INTO anvNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Ne me nnɛnemmyɛ mbaá Ɛsɔwɔ nnó ɛ́kagé wɔ ɔféré metɔɔ́ wyɛ́ ne me káŋká. Metɔɔ́ wyɛ ɛmagé bɛ́ne, fyɛ́ aŋmɛ́ byɛ́ ɛshyɛ.” ");
INSERT INTO anvNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Pita ajɔɔ́ ake, “Ata, me mkpomé mmyɛ manjyɛ denɔ ne wɔ ne yɛ mangbó ne wɔ.” ");
INSERT INTO anvNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Jisɔs ake, “Pita gɛ́, gɔ́ ngáré wɔ nnó, gemɛ́gé nnó menɔ mekwɔ akú fína wɔ ɔshyaá nyɛ nnó ɔ́kágé me kpaátɛ ukúkúle ulɛɛ́.” ");
INSERT INTO anvNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Ne Jisɔs ama jɔɔ́ ne áŋgbá bií aké, “Tége nkane ntɔmé nyá ɛnyú nekɛ ŋka pɔ́, geba pɔ́ ne unó uká ɛbichá pɔ́, genó geli nya ɛnyú?” Ne ɛbwɔ́ áke, “Ngba, yɛ genó ɛyi geli ɛsé gepɔ́.” ");
INSERT INTO anvNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Agaré ɛbwɔ́ áke, “Nana muú yi awya ŋká menyɛɛ́ jií abɔ́, ne geba ntó. Ne muú yi álá pɔ́ ne ɛsaá akpó nkú wuú asɛ́ ŋka yimbɔ ana ɛsaá. ");
INSERT INTO anvNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Wuúge, Ásá genó gefɔ́ mmu ŋwɛ Ɛsɔwɔ nnó, ‘Áfyɛ nyɛ́ ji né geluágé bɔɔ́ nchyɛ.’ Genó yina gépyɛ nyɛ́ me wáwálé. Ɛnyú debɔ́ mankaá nnó yɛndé genó ɛyigé ajɔɔ́ atome ne me gébɔ́ mambɛ́ wáwálé.” ");
INSERT INTO anvNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Ne áŋgbá bi áké, “Ata dewyá desaá depeá fa.” Jisɔs ake, “Lyáge mechɔ́ ɛwémbɔ.” ");
INSERT INTO anvNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Jisɔs ályágé gepú ɛyigémbɔ, afɛ́ né Mekwɛ Olif nkane ji apyɛ mɛ́, ne baá utɔɔ́ bií, ákwɔlé ji ntó. ");
INSERT INTO anvNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Áké ákwɔnege né melu ɛwémbɔ, agaré ɛbwɔ́ aké, “Nɛ́gemmyɛ mbaá Ɛsɔwɔ nnó ɛ́kágé ɛnyú dékpɛ́ né mmuameno.” ");
INSERT INTO anvNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Ne alyá ɛbwɔ́ afɛ́ mbɛ gachyɛ́, ató manó mme alɔ manɛmmyɛ mbaá Ɛsɔwɔ aké, ");
INSERT INTO anvNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Ntɛ, mbɔgé ɛjigé wɔ, féré amó ɛfwyale yina né ɛta wa ábɛ́ tɛtɛ, yɛ́mbɔ pyɛ genó ɛyigé wɔ ɔkɛlege, ɛpɔ́fɔ́ ɛyigé me nkɛ́lege.” ");
INSERT INTO anvNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Gébégé anɛ́nemmyɛ mbaá Ɛsɔwɔ, ɛkiɛ́nné Ɛsɔwɔ ɛ́tané mfaánebuú ɛchwɔ fyɛ́ ji metɔɔ́. ");
INSERT INTO anvNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Ne gekpɛ́kpɛ́gé mesómé né metɔɔ́, Jisɔs anɛmmyɛ ne ɛshyɛ kpaá njúnjú atáné ji mmyɛ achyɛge mme nkane deŋkáré manoó. ");
INSERT INTO anvNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Ji ánérégé mánɛmmyɛ, akwilé akeré mbaá yi áŋgbá bií álú. Abané ɛbwɔ́ ndɛre ábɛ́lege géjyá gétúgé ápwá né masómé. ");
INSERT INTO anvNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Ape ɛbwɔ́ agií aké, “Debɛlege nde? Kwélégé ka, nɛ́gemmyɛ mbaá Ɛsɔwɔ nnó ɛ́kágé dékpɛ́ né mmuameno.” ");
INSERT INTO anvNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Ndɛre Jisɔs alu jɔɔ́ge, njuné bɔɔ́ néchwɔ́ ne Judas, ŋgba ama né geluágé abi áfyaneápeá. Judas aja ɛbwɔ́ meti, achwɔ́gé, afɛ́ mbɛ atyá Jisɔs. ");
INSERT INTO anvNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Atyágé ji mbɔ, Jisɔs ajɔɔ́ ne ji aké, “Judas ɔkpó lé Maá Ntɛ Mekwaá né mantyá ji nnó bɔɔ́ ákaá ne ápyɛ ji?” ");
INSERT INTO anvNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Gébégé áŋgbá Jisɔs ágɛné nnó mechɔ́ kpaa ɛ́lé chwɔ, ágií áké, “Ata debɔ́ desaá delɔ úmyɛ?” ");
INSERT INTO anvNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Ne ŋgbá Jisɔs ama né geluágé bwɔ́, ajuú aparanja, alɔ mankɛ́ memfwɛ́ *Ɛtúkpɛ ámpyɛɛ́ upɛ Ɛsɔwɔ, asɔ́ ɛtu ɛwé ɛgbɛ́ ɛbwɔnyɛ. ");
INSERT INTO anvNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Ne Jisɔs agaré bɔɔ́ bií aké, “Dépyɛgé sé mbɔ, lyáge ɛbwɔ́.” Aferé ɛbwɔ́ wuú ata ɛtu memfwɛ yimbɔ, ɛfɛré. ");
INSERT INTO anvNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Ne Jisɔs abwɔlé ɛta *Anɔɔ́ baá ampyɛɛ́ upɛ Ɛsɔwɔ ne ámbamé ɛcha upɛ Ɛsɔwɔ ne ákpakpa melɔ abi áchwɔ mampyɛ ji. Agií ɛbwɔ́ aké, “Ɛnyú dechwɔ́ na ne bɔ aparanja ne mámbó unɔɔ́ mampyɛ me nnó me nlu menjó? ");
INSERT INTO anvNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Ndɔ ndɔ ne ndɔ njwɔlege ne ɛnyú né ɛcha upɛ, ɛnyú deta me ɛbwɔ mmyɛ wɔ́. Yɛ́mbɔ gébé ɛyige nyú gékwané nana, dechwɔ́ né uto dánchɔmeló ayi mfwa utuú.” ");
INSERT INTO anvNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Ne bɔɔ́ bina ápyɛ Jisɔs áfɛ́ ne ji né dachi ɛtúkpɛ ampyɛ upɛ Ɛsɔwɔ. Ne Pita ala tɛ meso, akwɔlege ɛbwɔ́ gachyɛɛ́, gachyɛ. ");
INSERT INTO anvNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Ákwɔ́négé, abané bɔɔ́ bí ásené mewɛ né dachi áwyá. Pita achwɔ jwɔ́le ntó né geluáge ɛbwɔ́. ");
INSERT INTO anvNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Ménkpané defwɛ́ ama né dachi yimbɔ ayi alú mendée, agɛ́gé Pita né geŋgbɔ́gé mewɛ nkane ajwɔle, apɛ ji domeé, aké, “Mende yina ntó abɔ́ alu ne Jisɔs.” ");
INSERT INTO anvNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Pita ake, “Chaá-ó! Mesɔ mendée nkágé ji.” ");
INSERT INTO anvNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Ɛwya yɛ wɔ́, mende fɔ agɛ́ Pita ake, “Wɔ́ ntó ɔlu muú bwɔ́ ama.” Pita ake, “Me detuú-o!” ");
INSERT INTO anvNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Ɛwya genógé nchwánekɛ, mende ayifɔ aké, “Wáwálé gebií gepɔ́ mmu mende yiná ntó abɔ́ alu ne Jisɔs, ji ntó atané gebagé Galilií.” ");
INSERT INTO anvNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Ne Pita ake, “Gɛ da, me kágé ɛwe wɔ jɔ́ge mbɔ.” Wyɛ nkane ji alú jɔ́ge mbɔ, menɔ mekwɔ akú kɔkɔgɔlɔ́kɔɔ́. ");
INSERT INTO anvNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Ata Jisɔs akɔ́ gemɛ apɛ́ Pita. Amɛ bwɔ́ átuú, ne Pita ate mekomejɔɔ́ ayi Ata Jisɔs abɔ́ agaré ji nnó, “Gemɛ́gé nnó menɔ mekwɔ ákú, ɔshya nyɛ́ ukúkúle ulɛɛ́ nnó ɔkágé me.” ");
INSERT INTO anvNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Gébégé Pita áteé mekomejɔɔ́ yimbɔ, afɛ dafyɛ, anyɔ meko ngbó ali segé segé. ");
INSERT INTO anvNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Bɔɔ́ bi ábáme Jisɔs, álɔ manjwyá Jisɔs, ne átúlege ji. ");
INSERT INTO anvNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Áwɛ́ ji ndeé né amɛ, ne ágíige ji áké, “Waá adoó wɔ? Garé ɛsé mbɔgé ɔkage.” ");
INSERT INTO anvNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Ne ɛbwɔ́ áma jú ji mashyɛ mmyɛ né gejamégé mati. ");
INSERT INTO anvNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Bií újyágé, *ákpakpa melɔ, ne Anɔɔ́ baá ampyɛ upɛ Ɛsɔwɔ ne *Ánlɛré mabɛ́ Ɛsɔwɔ áchomé né ɛso. Áchwɔ́ ne Jisɔs né mbɛ ushu bwɔ́. ");
INSERT INTO anvNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Ágií ji áké, “Wɔ ne ɔ́lú Muú yi Ɛsɔwɔ akweré ji ɛlá gefwa?” Jisɔs ashuú ɛbwɔ́ meko aké, “Mbɔge ngarégé ɛnyú, dekámégé nyɛ fɔ ne me. ");
INSERT INTO anvNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Ne mbɔgé ngiígé ɛnyú nkwɛ́ dekámégé nyɛ́ fɔ manshuú me meko. ");
INSERT INTO anvNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Yɛ́mbɔ lɔ nana chó mbɛ, Ɛsɔwɔ ayi áwya uto uko abelege Maá Ntɛ Mekwaá né mfaá geluɔ́gé ɛ́nógé né ɛgbɛ́ ɛbwɔnyɛ wuú.” ");
INSERT INTO anvNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Ajɔ́gé mbɔ, ɛbwɔ́ ako ágií áké, “Wɔ ne ɔ́lú Maá Ɛsɔwɔ?” Jisɔs aké, “Ɛ́lú wyɛ́ nkane ɛnyú dejɔɔ́ mbɔ.” ");
INSERT INTO anvNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Ne ɛbwɔ́ áke ne atɛ, “Ndé gécha démage kɛ́le bɔ ntɛ́sɛ́? Ɛsé ambɔɔ́ dewú mɛ́ genó ɛyi getané jimbɔ meno.” ");
INSERT INTO anvNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Ɛbwɔ́ ájɔ́gé mbɔ, ɛchomele meko ɛkwelé ká ɛfɛ́ ne Jisɔs mbaá Palɛt. ");
INSERT INTO anvNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Ákwɔ́négé ɛ́wu, álɔ maáma ji depɔ mmyɛ áké, “Dépyɛ́ ményákwɔ́ yi ndɛrɛ achɔɔ́ melɔ ɛsé, achoge bɔɔ́ uká mme nnó áchyɛgé fɔ ŋkamakpo mbaá Mfwa Rom, ne ama garege bɔɔ́ nnó ji ne alú Muú yi Ɛsɔwɔ akweré ji ɛlá gefwa.” ");
INSERT INTO anvNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Palɛt agií Jisɔs aké, “Wɔ ɔlu Mfwa bɔɔ́ Jus wáwálé?” Jisɔs aké, “Ɛlu nkane ɔjɔɔ́.” ");
INSERT INTO anvNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Ne Palɛt ajɔɔ́ ne anɔɔ́ baá abi ápyɛ upɛ Ɛsɔwɔ ne gejamégé bɔɔ́, áké, “Ngɛ́fɔ́ gabo ayi mende yina apyɛ́ wɔ́.” ");
INSERT INTO anvNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Yɛ́mbɔ áshií wyɛ́ ne ɛwú aké mende yina achoge bɔɔ́ uká mme, alɛré né mme Judiya meko, alɔ né melɔ Galilií kpaá akwɔné fá melɔ ɛwe. ");
INSERT INTO anvNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Palɛt awúgé mbɔ, agií aké, “Mende yina ɛle muú Galilií?” ");
INSERT INTO anvNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Ákámégé, Palɛt atɔ́ Jisɔs mbaá Hɛrɔd néndé Hɛrɔd ne agbaré mboó melɔ yimbɔ. Né gébé ɛyigembɔ Hɛrɔd abɔ́ alu né Jɛrosalɛ. ");
INSERT INTO anvNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Gébégé Hɛrɔd agɛné Jisɔs, metɔɔ́ ɛgɔ ji dɔɔ́, ɛlé ji abɔ akɛlege mɛ́ mangɛ́ ji tɛ gachií, néndé, ji abɔ́ awuú mɛ́ ŋgɔ Jisɔs. Ne abɔ́ awya umɛɛ́ nnó ji agɛ́ ufélekpá ɛbi Jisɔs apyɛ. ");
INSERT INTO anvNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Ɛwyágé Hɛrɔd agií Jisɔs bɔ ŋkwɛ́ dɔɔ́, ne yɛɛ́ meko Jisɔs ashuú ji wɔ́. ");
INSERT INTO anvNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Agígé mbɔ, *Anɔɔ́ baá ampyɛ upɛ Ɛsɔwɔ ne *Ánlɛré mabɛ́ Ɛsɔwɔ áwɔ áchwɔ́ mbɛ, álɔ manjɔɔ́ depɔ ɛti Jisɔs apyɛ́ ne ɛshyɛ. ");
INSERT INTO anvNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Mfwa Hɛrɔd ne bɔɔ́ bee bií álɔ manjwyagé Jisɔs, áchyɛge ji mekpo unɔɔ́. Ábɔ́ nkúu mfwa áfyɛ́ ji mmyɛ, ámá átɔ́ ji akeré meso mbaá Palɛt. ");
INSERT INTO anvNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Né bií ɛbi mbɔ dejeé Palɛt ne Hɛrɔd delɔ. Tɛ gachi ɛbwɔ́ ábɔ́ alú máwámé ne atɛ. ");
INSERT INTO anvNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Gébégé ákeré meso ne Jisɔs, Palɛt akú ánɔɔ́ baá abi ápyɛ́ upɛ Ɛsɔwɔ, ne ákpakpa melɔ, ");
INSERT INTO anvNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","áchwɔgé, áké ne bwɔ́, “Mbɛ mbɛ, ɛnyú desɛ mɛ́ mende yina dechwɔ ne ji ɛta wa deké achɔɔ́ melɔ. Ngií ji bɔ nkwɛ́ né mbɛ ushu nyú, yɛ́mbɔ ngɛfɔ́ gabo yi mende yina apyɛ́ né depɔ ɛtiré ɛnyú déké ji akwé ɛbɛ wɔ́. ");
INSERT INTO anvNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Yɛ́ Mfwa Hɛrɔd ntó agɛ nnó mende yina akwé ɛbɛ́ wɔ́, nkawú ne ji akeré meso ɛta ɛsé. Gɔ́ge ngáré ɛnyú nnó mende yina apyɛ́ yɛ gabo fɔ́ ayi abɔ maŋgbó wɔ́. ");
INSERT INTO anvNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Yɛ́mbɔ nchyɛge nyɛ́ ɛnyú ɛbwɔnyɛ nnó átúlé ji ályá ji, ajyɛ́.” ");
INSERT INTO anvNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Nkane gepɔgé gébé yimbɔ gélú, yɛndégébége ɛpaá kwyakwya defwɛ́, Palɛt aferege muú denɔ ama nkane bɔɔ́ bií ákɛlege. ");
INSERT INTO anvNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Ne ákalé ɛbwɔ́ ako áké, “Wá mende yina, ɛsé dekɛlege ɛ́lé Barabas.” ");
INSERT INTO anvNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","(Barabas abɔ́ akpɛ denɔ gétúgé achwɔɔ́ ne ɛfwyale né melɔ ne muú ayi ji ama wá.) ");
INSERT INTO anvNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Palɛt akɛlege meti manlyá Jisɔs ajyɛ́, ne ama ajɔ́ɔ ne ɛbwɔ́. ");
INSERT INTO anvNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Ne ɛbwɔ́ ako ákalé áke, “Wɔ́ ji né gekwa, wɔ́ ji né gekwa.” ");
INSERT INTO anvNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Né maŋáne alɛɛ́ Palɛt ama gií ake, áwɔ́ ji nnó apyɛ nnó? “Ndé gabo ayi ji ápyɛɛ́?” Ngɛ yɛ genó ɛyigé ji apyɛ́ ne njɔɔ́ nnó áwɔ́ ji né gekwa wɔ́. Ngarege ádó ji ályá ji ajyɛ́. ");
INSERT INTO anvNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Né ɛbwɔ́ ádo delúlú áké, “Áwɔ́ ji né gekwa.” Makálé bwɔ́ áwerí uto Palɛt. ");
INSERT INTO anvNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Akamé ne asɔ́ mpa aké, “Ápyɛ ne Jisɔs ndɛre ɛbwɔ́ ákɛlege.” ");
INSERT INTO anvNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Aferé muú yi ɛbwɔ́ ákɛ́lege ayi abɔ́ akpɛné denɔ gétúgé, ɛfwyale ɛwe ji achyɛ́ ne muú ayi ji awáné. Gébégé áféré ji, Palɛt agbaré Jisɔs achyɛ́ ɛbwɔ́, nnó ápyɛ ndɛre ɛjií ɛbwɔ́. ");
INSERT INTO anvNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Bɔɔ́ bee ásɛ Jisɔs né dachi Palɛt ále jyɛɛ́, ne nkane ɛbwɔ́ ákɛ́ne ájyɛɛ́, átuú ne mende fɔ ayi akú ji Simun, muú melɔ Sɛren, atané dondo yimbɔ né mewaá ajyɛɛ́ Jɛrosalɛ. Ágbaré ji ánɛ́ré ji gekwagé Jisɔs né máŋkɔɔ́ nnó ji akpá akwɔ́lege Jisɔs meso. ");
INSERT INTO anvNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Ne gejamégé bɔɔ́ ákwɔ́lege ji meso. Abifɔ ɛ́lé andée, abi ákparé amú mekpo, álile, áyiage ne masómé ndɛre áteé ɛfwyale wuú. ");
INSERT INTO anvNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Ne Jisɔs abwɔlé aké ne ɛbwɔ́, “Andée Jɛrosalɛ, déligé sé gétú ya, líge lé gemɛ ɛnyú ne baá ɛnyú. ");
INSERT INTO anvNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Kaáge nnó né meso gébé bɔɔ́ ájɔ́ge nyɛ́ nnó, ‘Ɛ́fwɔ́ ɛ́bɛ́ ne andée abi ákwené déŋkwɔ ne abi ála alú danchyɛɛ́ baá mámbɛ́!’ ");
INSERT INTO anvNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Né gébé ɛyigémbɔ, bɔɔ́ áshyáge nyɛ́ mmyɛ nnó, ‘Ɛ́chyɛ mfaánebuú ashulé ɛsé mmyɛ, yɛ mme anií ɛse.’ ");
INSERT INTO anvNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Ápyɛgémbɔ na ne genɔɔ́ ɛyi gélú gebɛ, ne ɛbɛɛ́ nyɛ nnó ne gegbógbógé genɔɔ́?” ");
INSERT INTO anvNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Gébégé ájyɛ wɔ́ Jisɔs, ásɛ ntó bɔɔ́ ubée apéa manjyɛ wá choncho ne ji. ");
INSERT INTO anvNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Ákwɔ́négé melú ɛwé ákuú nnó, “Uŋkɔ́ŋkɔ́ makpo,” áwɔ́ Jisɔs né gekwa. Ne ama wɔ́ bɔɔ́ ubée bimbɔ mfaá ukwa upea, ama né ɛgbɛ́ ɛbwɔnyɛ wuú, ne ayifɔ né ɛgbɛ́ ɛbwɔbɛ wuú. ");
INSERT INTO anvNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Jisɔs aké, “Ntɛ́, gɛ́ ɛbwɔ́ meshwɛ, jinte gabo áyi ɛbwɔ́ ápyɛ́mbɔ, néndé ákágé.” Bɔɔ́ bee bina, ákpyá megyaá ákáré mandeé Jisɔs áfyɛ́ atɛ amú. ");
INSERT INTO anvNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Bɔɔ́ átɛné ɛ́fɛɛ́ ápɛ́le nkane áwɔ́me Jisɔs né gekwa. Ne ákpakpa bɔɔ́ Jus, álɔ manjwyágé ji áké, “Apoóge bɔɔ́ bí chachá, akaágé poó fɔ́ ntó gemɛ jií mbɔgé alú Muú yi Ɛsɔwɔ akweré ji ɛlá gefwa.” ");
INSERT INTO anvNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Bɔɔ́ bee ntó ájwyá Jisɔs, áchyɛɛ́ ji mmɔɔ́ amí mamyáme, ");
INSERT INTO anvNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","ne áké, “Mbɔgé nnó ɔlu Mfwa bɔɔ́ Jus wáwálé, poó gemɛ jyɛ́.” ");
INSERT INTO anvNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Ásá ntó ŋwɛ́ ába né gekwa né mfaá mekpo Jisɔs. Ásá wyɛɛ́ áké, “Gɛ́ Mfwa bɔɔ́ Jus na.” ");
INSERT INTO anvNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Muú ubée ama ayi áwɔmé ji ntó né gekwa ɛjí, alɔ manjwya ntó Jisɔs aké, “Pɔ́ ɔlu Muú yi Ɛsɔwɔ akweré ji ɛlá gefwa? Poó yɛ́ gémɛ́ jyɛ́, ɔpoó ɛsé ntó.” ");
INSERT INTO anvNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Ne ayifɔ ashúlé ji yimbɔ ndo aké, “Wɔ ɔfɔɔ́ fɔ́ Ɛsɔwɔ? Ɔlu ntó mmú ɛfwyale nkane mende yina. ");
INSERT INTO anvNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Ɛsé ne wɔ debɔ́ nsá né gabo ayi ɛsé depyɛ́, nkawú ne dégɛ́ne ɛfwyale ɛwé. Ne mende yina apyɛ́ gabo wɔ́.” ");
INSERT INTO anvNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Ne ajɔ́ɔ ne Jisɔs aké, “Ata te me gébégé ɔchwɔgé gbáre gefwa jyɛ́.” ");
INSERT INTO anvNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Jisɔs áshuú ji meko aké, “Ngarege wɔ wáwálé nnó fina ɔbɛ nyɛ́ ne me né melɔ́ Ɛsɔwɔ.” ");
INSERT INTO anvNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Káláŋká ɛfyáneɛ́peá ɛké ɛ́kwɔ́nege, ŋmɛɛ́ ɛnomé, gemmua gékwé né melɔ meko kpaá tɛ káláŋká ɛlɛɛ́. ");
INSERT INTO anvNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Ŋmɛɛ́ ɛ́nómégé, ɛkat ɛwé ɛkaré metɔɔ́ ɛcha upɛ Ɛsɔwɔ ɛgyalé ubaá úpeá. ");
INSERT INTO anvNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Ɛké ɛ́wyáge, Jisɔs alɔ mankálé kéŋké aké, “Nte mfyɛ gemɛ ya né amú jyɛ́.” Ajɔgé mbɔ, ashulé kwyakwya geféré h-ɛ-m metɔɔ́ ɛkwé. ");
INSERT INTO anvNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Muú kpaá bɔɔ́ bee ayi abɔ́ atɛné ɛfɛɛ́, agɛ́gé genó ɛyi gepyɛ́, afɛɛ́ Ɛsɔwɔ aké, “Wáwálé, mende yina abɔ́ apyɛ́ gabo wɔ́.” ");
INSERT INTO anvNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Gejámégé bɔɔ́ abi ábɔ́ áchomé ɛfɛɛ́ ápɛ́le, ákeré upú bwɔ́ amu meso kpákpáré, mashu mme tóntó né genó ɛyigé ɛbwɔ́ ágɛné. ");
INSERT INTO anvNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Ajeé Jisɔs ako átɛ́né tɛtɛ ágɛ́ne depɔ ɛtiré na. Abifɔ alú andée abi ábɔ́ átané Galilií ákwɔlé ji. ");
INSERT INTO anvNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Mendefɔ abɔ́ alu, akamege Josɛf, atané né melɔ́ Arimatya né gebagé mewaá Judiya. Alu nyá muú ayi alu cho, ne abelege mabɛ́ Ɛsɔwɔ. Abɔ́ agile gébé ɛyigé Ɛsɔwɔ achwɔ́ gbáre gefwa jií. Yɛ́ ɛ́lé alú ntó muú ama né geluágé ákpakpa bɔɔ́ Jus, apɔ́ nyá meko ama ne ɛbwɔ́ nnó áwá Jisɔs. ");
INSERT INTO anvNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Nkane Jisɔs agboó, afɛ́ mbaá Palɛt, ajyɛ gíi nnó achyɛ́ ji geŋkwɔ́gé Jisɔs. ");
INSERT INTO anvNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Palɛt achyɛ́gé ji ɛbwɔnyɛ, ajyɛ féré geŋkwɔ́gé Jisɔs né mfaá gekwa, afyalé géjí ne ɛ́shyɛ́ ndeé, ajyɛ nií mmu menome ɛwé ábɔ́ áchomé tɛ gachií mmu ɛtaravɛ́, ɛwé ála álu ganíi muú wyɛ. ");
INSERT INTO anvNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Afyɛ́ ji mmu menome, nénde ákpomege mmyɛ nnó bií uwyaá ɛbwɔ́ ɛbi ulɔ nkwale yimbɔ. ");
INSERT INTO anvNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Andée abi átane ne Jisɔs né Galilií, ákwɔlé Josɛf ne ágɛ́ ntó menome ne áma ágɛ́ ntó nkane áfyɛ́ ji né mmu. ");
INSERT INTO anvNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Ákérégé meso né úpú bwɔ́ ákwyɛ́ maweé gébɛ́ ami malɔ́málɔ́ ami awáage mewu muú. Bií uwyaá bwɔ́ úkwɔ́négé, ɛbwɔ́ ágbeé mmyɛ nkane ɛbɛ́ bwɔ́ ɛ́lú. ");
INSERT INTO anvNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Bií mbɛ né uwyaá, andée bimbɔ ákpá maweé gebɛ́ ami ɛbwɔ́ ákwyɛ́, dondo gemmuá mme áfɛ́ né menome ɛwé anií Jisɔs. ");
INSERT INTO anvNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Ákwɔ́négé wyɛ́, ágɛ nnó, ábogéné mɛ́ ntaá ɛ́gbɛ́ ɛ́ma ɛniné ábɔ́ ákweré ɛmbú menome. ");
INSERT INTO anvNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Ne gébégé ákpɛné mmu menome, ákɛlé geŋkwɔ́gé Atá Jisɔs ágɛ wɔ́, ");
INSERT INTO anvNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","ákwé tametame, áké ápɛ́lé ágɛ́ bɔɔ́ makpó apéa ne mandeé áyi áshwánege átɛné ɛbwɔ́ neŋkuné mmyɛ. ");
INSERT INTO anvNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Ɛfɔ́ ɛkwɔ́ bwɔ́ metɔɔ́, ámmo makpo mme. Bɔɔ́ bimbɔ ágií bwɔ́ áké, “Ndé ɛnyú dékɛlege muú yi alú mebɛ né geluágé abi ágboó? ");
INSERT INTO anvNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Apɔ́ fa, akwilé né negbó, atane. Tɛ́ge genó ɛyigé ji agaré ɛnyú gébégé ɛnyú delú né Galilií. ");
INSERT INTO anvNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","“Abɔ́ aké, ‘Áchyɛ́ge nyɛ́ Maá Ntɛ Mekwaá mbaá bɔɔ́ ubeé, áwɔ́me nyɛ́ ji né gekwa, ne ɛkwɔnégé ndɔ ɛlɛɛ́, akwilége nyɛ́ né negbo’.” ");
INSERT INTO anvNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Andée bina áte unó bí Jisɔs abɔ́ ajɔɔ́, ");
INSERT INTO anvNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","átané né menome áfɛ́ mangaré unó bi úpyɛ́ mbaá áŋgbá bií abi álaá áfyaneama, ne áma garé ntó áŋkwɔlé Jisɔs ako. ");
INSERT INTO anvNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Andée bimbɔ ɛ́lé, Mɛri muú melɔ Magdala, ne Joana ne Mɛri ayi Mmá Jɛmsi chóncho ne andée abifɔ ntó, ágaré áŋgbá Jisɔs genó ɛyigé ɛbwɔ́ ágɛné. ");
INSERT INTO anvNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Ne áŋgbá ákamé wɔ́, ásɛ nnó ɛ́lú gebyɔ́. ");
INSERT INTO anvNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Yɛ́mbɔ, Pita akwilé ka abó afɛ́ né menome, abyɛlé mme apɛ, agɛ́ lé mandeé áyi abɔ́ afyalé geŋkwɔ́gé Jisɔs. Ala meno mekpo fuú, ne akere meso mmu gepú jií. ");
INSERT INTO anvNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Wyɛ́ bií bimbɔ, bɔɔ́ abi ákamé ne Jisɔs apéa, álya melɔ́ Jɛrosalɛ ájyɛ né maá melɔ ayi ákú Ɛmeus. Nekɛ nelu genógé *ŋkpá nekɛ ɛkénéama. ");
INSERT INTO anvNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Ndɛre ájyɛ́, ádóo abya né depɔ deko ɛtiré depyɛ́. ");
INSERT INTO anvNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Nkane ádóo abya ákɛ́ne ajyɛ, Jisɔs atané ɛbwɔ́ né meso ne alɔ mankɛ́ ne ɛbwɔ́. ");
INSERT INTO anvNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Yɛ́mbɔ ágɛ ji, ne ákaá fɔ́ nnó ɛlé Jisɔs wɔ́. ");
INSERT INTO anvNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Jisɔs agií bwɔ́ aké, “Nde abya ayi ɛnyú dékɛ́ne dédóo ne dembyɔ́ né matɔɔ́ ɛnyú?” Átɛné nyámeé, mmyɛ meshwɛ́ meshwɛ́. ");
INSERT INTO anvNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Muú bwɔ́ ama, ayi ákú ji Klyopas agií ji aké, “Wɔ mbi ne ɔlu meŋkɛɛ́ fá melɔ́ Jɛrosalɛ ayi ɔlá kágé depɔ ɛtiré depyɛ́ mboó ndɔ ɛyína?” ");
INSERT INTO anvNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Jisɔs agií aké, “Nde depɔ depyɛ?” Áshuú ji meko áké, “Depɔ ɛti depyɛ mbaá mende yi akámege Jisɔs ayi muú Nasarɛt. Alu nyá gekpɛ́kpɛ́gé *Muú Ɛkpávé Ɛsɔwɔ. Ne apyɛ ukpɛ́kpɛ́ ufélekpá ne agarege nyá meko mejɔɔ́ Ɛsɔwɔ. Ɛsɔwɔ afɛɛ́ utɔɔ́ bií, yɛ bɔɔ́ ntó afɛɛ́ utɔɔ́ bií. ");
INSERT INTO anvNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Yɛ́mbɔ anɔɔ́ baá abi ápyɛ upɛ Ɛsɔwɔ ne ákpakpa melɔ ágbare ji áchyɛɛ́ nnó áwá ne áwɔ́ ji né gekwa. ");
INSERT INTO anvNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Ne ɛsé debɔ́ débelé umɛɛ́ nnó ji ne Ɛsɔwɔ atɔme nnó achwɔ́ áféré bɔɔ́ Isrɛli né ɛfwyale. Ɛlɛ́ mbɔ ndɔ́ ɛ́lɛɛ́ fi, ɛyi depɔ ɛtíré na depyɛ́. ");
INSERT INTO anvNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Ɛkwyá mbɔ wɔ́, andée fɔ́ abi alú né geluágé sé ápyɛ ɛsé dela meno mekpo fuú. Áfɛ́ né menomé gejyɛ́jyɛ́gé bí. ");
INSERT INTO anvNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Yɛ́mbɔ ágɛ fɔ geŋkwɔ́gé Jisɔs wɔ́, ne ákere meso, ágare ɛsé nnó ɛbwɔ́ ábɔ́ ágɛ makiɛ́nné Ɛsɔwɔ ɛké ɛlé *amɛ gejyá, ágaré ɛbwɔ́ nnó Jisɔs alu mebɛ. ");
INSERT INTO anvNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Bɔɔ́ bifɔ́ abi álu né geluágé ɛsé áfɛ́ né menome ne ágɛ́ yɛ́ndégenó wyɛ́ nkane andée bimbɔ abɔ́ ájɔɔ́, yɛ́mbɔ ɛbwɔ́ ágɛ Jisɔs wɔ́.” ");
INSERT INTO anvNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Jisɔs aké ne ɛbwɔ́, “Ɛnyú dekenege, matɔɔ́ nyú álu dembyɔ́ mankamé unó bi bɔɔ́ ɛkpávé Ɛsɔwɔ ásámé. ");
INSERT INTO anvNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Ɛnyú dekaá fɔ́ nnó Muú yi Ɛsɔwɔ akweré ji ɛlá gefwa abɔ́ mangɛ́ ɛfwyale ne akpɛ́ mmu gefwa jií wɔ́?” ");
INSERT INTO anvNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Jisɔs alɔ mampyɛ nnó ɛbwɔ́ ákaá unó uko ɛbí ásamé átome ne ji né mmu ŋwɛ Ɛsɔwɔ, manlɔ né ŋwɛ ayi Mosis asamé, ɔkwɔ́né né abi bɔɔ́ ɛkpávé Ɛsɔwɔ ntó ásámé. ");
INSERT INTO anvNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Wyɛ́ nkane ála kwɔ́kwɔ́lé ne melɔ ɛwé ɛbwɔ́ abɔ́ ájyɛ́ɛ, Jisɔs apyɛ ɛké achwɔ koó, ");
INSERT INTO anvNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","ɛbwɔ́ ágbɛ́ ji áké, “Bɛ́lé fá ne ɛsé néndé bií ukoó, gemmua gélé chwɔ́.” Akame, ne afɛ́ mámbɛlé ne ɛbwɔ́. ");
INSERT INTO anvNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Gébégé ajwɔlé ka mányɛ́ menyɛɛ́ ne ɛbwɔ́, abɔ́ nto brɛd achyɛ́ matame mbaá Ɛsɔwɔ agyá achyɛ́ ɛbwɔ́. ");
INSERT INTO anvNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Tɛ́netɛ́ne yimbɔ amɛ ákaá ɛbwɔ́ mekpo, ɛbwɔ́ ákaá nnó gɛ́ Jisɔs na. Ne ɛke ɛwyage aseé ɛbwɔ́ né amɛ. ");
INSERT INTO anvNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Álágé meso, áké ne atɛ, “Pɔ manɛ magyalé ɛsé gébégé ábáné ɛsé né meti agárege ɛse depɔ ɛtiré délú mmu ŋwɛ Ɛsɔwɔ?” ");
INSERT INTO anvNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Tɛ́nétɛné yimbɔ, ákwilé, ákere meso né Jɛrosalɛ, ágɛ baá utɔɔ́ afyaneama choncho ne áŋkwɔlé Jisɔs abifɔ. ");
INSERT INTO anvNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Abi afyaneama áke, “Ɛ́lú wáwálé, Ata akwilé né negbo, Simun agɛ́ ji mebɛ.” ");
INSERT INTO anvNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Abimbɔ ápeá ágaré ntó ɛbwɔ́ ɛwé ɛbɔ́ ɛ́pyɛ́ né meti, ne gébége Jisɔs agyálé brɛd ne ɛbwɔ́ álé ká ji. ");
INSERT INTO anvNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Gébégé ɛbwɔ́ álu garégé depɔ tí, Jisɔs jimbɔ akpɛ atɛné metɔɔ́ metɔɔ́ bwɔ́ aké, “Nesɔ nébɛ́ ne ɛnyú.” ");
INSERT INTO anvNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Yɛ́mbɔ ɛbwɔ́ ábɔ́ ɛfɔ, áfɛrege nnó ɛbwɔ́ ágɛ́ne mbɔ le muú nefoó. ");
INSERT INTO anvNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Jisɔs agií ɛbwɔ́ aké, “Nde manɛ magyálege ɛnyú? Ɛnyú debyɔme mbɔ ndé? ");
INSERT INTO anvNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Pɛ́ge amu ya, ne uká bá ne dekaá nnó ɛlé me mbɔɔ́. Tage menyammyɛ wa dewú ndɛre alú, muú nefoó ábɛɛ́ fɔ́ ne menyammyɛ ne ugoó nkane ɛnyú degɛne mbɔ me.” ");
INSERT INTO anvNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Jisɔs ajɔ́gé mbɔ, alɛré ɛbwɔ́ amu jií ne majya jií. ");
INSERT INTO anvNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Yɛ́mbɔ ákwé tametame mmu nechɔ́chɔ́ ne ákɛ́légé fɔ́ mankamé. Ɛfɛɛ́ mbɔ Jisɔs agií bwɔ́ aké, “Dewyaá menyɛɛ́ fɔ fá manyɛ́?” ");
INSERT INTO anvNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Ábɔ́ mboó meshuú ayi ábɔ́ átyɛ́, áchyɛɛ́ ji. ");
INSERT INTO anvNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Asɛ anyɛ́ né mbɛ ushu bwɔ́. ");
INSERT INTO anvNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Ake yɛ́ ne ɛbwɔ́, “Genó ɛyigé ɛnyú dégɛ́ne fina ɛ́lé ɛyigémbɔ́ ngaré ɛnyú gébégé debɔ́ délú choncho. Nké unó uko ɛbi ábɔ́ ásamé átome ne me né mmu ŋwɛ Mosis ne abi bɔɔ́ ɛkpávé Ɛsɔwɔ ne ɛbi ásamé nto né mmu ŋwɛ makwa Ɛsɔwɔ, úbɔ́ mambɛ́ wáwálé.” ");
INSERT INTO anvNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Ndɛre Jisɔs ajɔɔ́ mbɔ, anené ɛbwɔ́ defɔɔ́ nnó ákaá mekomejɔɔ́ ayi alú né mmu ŋwɛ Ɛsɔwɔ. ");
INSERT INTO anvNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Ne ajɔɔ́ ne bwɔ́ aké, “Ábɔ́ ásá nnó, Muú yi Ɛsɔwɔ akweré ji ɛlá gefwa abɔ́ mangɛ́ ɛfwyale ne ágbó, ne ndɔ́ ɛkwɔnégé ɛlɛɛ́, akwilege nyɛ́ né negbo. ");
INSERT INTO anvNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Álɔ nyɛ né Jɛrosalɛ ne ájyɛ né malɔ mako mangárégé mekomejɔɔ́ Ɛsɔwɔ né mabɔ mií nnó bɔɔ́ ákwɔ́ré matɔɔ́ bwɔ́ ne Ɛsɔwɔ ajinte gabo bwɔ́. ");
INSERT INTO anvNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Ɛnyú delu bɔɔ́ bí degɛ́né unó bina, ne debɔ́ mangaré bɔɔ́ ubi. ");
INSERT INTO anvNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Ntɔ́me nyɛ́ ɛnyú ɛchyɛ ɛwé ntɛ wa abɔ́ anyɛ́meno manchyɛ ɛnyú. Yɛ́mbɔ jwɔ́lege fa né melɔ́ kpa ɛwé, kpaá tɛ́ gébé gékwɔ́nege nyɛ́ ɛyigé uto bimbɔ utánege mfaánebuú uchwɔ ɛnyú mmyɛ.” ");
INSERT INTO anvNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Jisɔs asɛ ɛbwɔ́ áfɛ́ kwɔ́kwɔ́lé né melɔ Bɛtani, ɛfɛɛ́ mbɔ abwɛɛ́ amu mfaá ajé ɛbwɔ́. ");
INSERT INTO anvNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Ndɛre ajéle ɛbwɔ́, alya bwɔ́ alɔ mankwɔ́ ajyɛ né mfaánebuú. ");
INSERT INTO anvNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Ɛfɛmbɔ́, baá utɔɔ́ bi álɔ mamfɛɛ́ ji ne ákeré meso né Jɛrosalɛ ne gejamégé nechɔ́chɔ́. ");
INSERT INTO anvNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Ne yɛndégébé ájwɔ́lege mmu ɛcha upɛ Ɛsɔwɔ, áfɛ́ɛge Ɛsɔwɔ.");
INSERT INTO anvNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Gemɛgé nnó mme yina alɔ, mekomejɔɔ́ abɔ alú mɛ. Mekomejɔɔ́ yimbɔ abɔ alu ne Ɛsɔwɔ ne mekomejɔɔ́ yimbɔ abɔ alu Ɛsɔwɔ. ");
INSERT INTO anvNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Abɔ́ alú mɛ́ ne Ɛsɔwɔ tɛ́ ula ulɔɔ́. ");
INSERT INTO anvNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Unó uko ɛbi Ɛsɔwɔ akwyɛɛ́ ukɛ́ ne ji. Ji ábɛ́ dampɔ, mmbɔ yɛ́ geno gema gepɔ. ");
INSERT INTO anvNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Mekomejɔɔ́ yimbɔ ne awyaa geŋwá. Ne geŋwá ɛyigémbɔ gelú lé geŋgbɔ mbaá akwaá. ");
INSERT INTO anvNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Geŋgbɔ ɛyigémbɔ gegɛnégé né mmu gemmua, yɛ́mbɔ gemua gékágé kweré gejí. ");
INSERT INTO anvNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Ɛsɔwɔ abɔ́ atɔ mende fɔ ayi ákuú ji nnó Jɔn, ");
INSERT INTO anvNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Jɔn achwɔ́ ndɛre ntɛsɛ, mangaré akwaá genó ɛyigé geŋgbɔ ɛyigémbɔ gelú, nnó ɛbwɔ́ awú áfyɛɛ́ metɔɔ́ ne gejí. ");
INSERT INTO anvNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Jimbɔɔ́ apɔ́fɔ́ geŋgbɔ́ ɛyigémbɔ, achwɔ́ lé nkane ntɛsɛ mampyɛ akwaá ákaá geŋgbɔ́ ɛyigémbɔ. ");
INSERT INTO anvNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Geŋgbɔ ɛyigé wáwálé, ɛyi gegɛnégé mbaá yɛ́ndémuú, gebɔ gechwɔɔ́ fa né mme. ");
INSERT INTO anvNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Ji abɔ́ alú fa mme, ne yɛ́ ɛlé mme ayi Ɛsɔwɔ akwyɛ akɛné ne jí, bɔɔ́ mme akaá fɔ́ ji wɔ́. ");
INSERT INTO anvNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Ji achwɔ́ né melɔ wuú, bɔɔ́ melɔ wuú ásɛ́ fɔ́ jí wɔ. ");
INSERT INTO anvNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Yɛ́mbɔ bɔɔ́ ako abi ásɛ́lé ji, áfyɛɛ́ matɔɔ́ ne ji, áchyɛɛ́ ɛbwɔ́ ɛbwɔnyɛ mambɛ baá Ɛsɔwɔ. ");
INSERT INTO anvNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Gefɔɔ́ ɛyigé ábyɛ́né ɛbwɔ́, gepɔ́fɔ́ ndɛre akwaá ábyɛne baá. Ne ɛpɔ́fɔ́ ntó ndɛre akwaá ákɛlegé, ɛpɔ́fɔ́ ntó ndɛre ntɛ akɛlege. Nebyɛne bwɔ́ netane mbaá Ɛsɔwɔ. ");
INSERT INTO anvNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Mekomejɔɔ́ yimbɔ, abwɔlé mekwaá, ajwɔle fa mme ne ɛse, alɛre galɔ́gálɔ́ ayi apwɔ amu ne ajɔ́gé depɔ ɛtire delú wáwálé. Degɛ́ ɛnoge ɛwé ji awyaá, ɛwé ji asɛ́le mbaá Ntɛ wuú ndɛre danchi Maá. ");
INSERT INTO anvNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Jɔn agarege bɔɔ́ geno ɛyigé ji agɛne getóme ne Jisɔs, ajɔ́gé keŋke aké, “Gɛgé muú ayi njɔɔ́gé nya nnó, ‘Ji ayi achwɔɔ́ mbɔ me meso apwɔ́ me, néndé gemɛgé nnó ábyɛ́ me, ji abɔ alu mɛ́.’” ");
INSERT INTO anvNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Ne gétúgé galɔ́gálɔ́ wuú apyɛ ɛse ako debɔ́ nebɔ matimati. ");
INSERT INTO anvNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Mabɛ́ Ɛsɔwɔ akɛ́ ne Mosis yɛ́mbɔ galɔ́gálɔ́ ne wáwálé ákɛ ne Jisɔs Kras. ");
INSERT INTO anvNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Yɛ́ muú ama ayi agɛne mɛ Ɛsɔwɔ apɔ́ ɛkose danchi maá wuú. Ji alu ntó ɛke Ɛsɔwɔ. Ji ayi alu fií ne ntɛ wuú ne apyɛ bɔɔ́ akaá gefɔɔ́ ɛyigé ntɛ alu. ");
INSERT INTO anvNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Ákpakpa bɔɔ́ Jus né Jɛrosalɛ átɔ ámpyɛɛ́ upɛ Ɛsɔwɔ ne ámpoó ámpyɛɛ́ upɛ Ɛsɔwɔ nnó áchwɔ́ ágií Jɔn nnó ji alú waá? Agigé mbɔ, ");
INSERT INTO anvNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Jɔn ashya fɔ́ mangaré ɛbwɔ́ wáwálé wɔ́. Gɛ na ne ji agare, aké “Me mpɔ́fɔ́ Muú yi Ɛsɔwɔ akweré ji ɛlá gefwa.” ");
INSERT INTO anvNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Ágí ji áké, “Ne wɔ ɔlu waá? Nnó wɔ ɔlu ɛlé Ɛlija.” Ne Jɔn ashuú ɛbwɔ́ meko aké, “Ngba me mpɔ́.” Áma ágií ji áké, “Nnó wɔ ɔlu muú ɛkpávé Ɛsɔwɔ?” Ama ashuú ɛbwɔ́ meko aké, “Ngba.” ");
INSERT INTO anvNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Áké, “Wɔ ɔlu waá yɛɛ́, shuú ɛsé meko ayi dejyɛ garé bɔɔ́ abi atɔmé ɛsé. Wɔ mbɔɔ́ ɔké ɔlu waá?” ");
INSERT INTO anvNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Ne Jɔn ashuú ɛbwɔ́ meko aké, “Me nlu meko muú fɔ́ ayi ábɛ́ne né mashwɔne nnó, nyage meti Ata ɛbɛ cho; mbɔ ne Asaya muú ɛkpávé Ɛsɔwɔ abɔ ajɔɔ́.” ");
INSERT INTO anvNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Bɔɔ́ dentɔɔ́ bina álu ntó ɛkwɔ bɔɔ́ Farasi, ");
INSERT INTO anvNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Ne ágií Jɔn áké, “Ulannó wɔ ɔwyagé bɔɔ́ manaá Ɛsɔwɔ mbɔgé ɔpɔ́fɔ́ Muú yi Ɛsɔwɔ akweré ji ɛlá gefwa, yɛ́ ɛlé Ɛlija yɛ́ ɛbɛ́ ɛlé muú ɛkpávé Ɛsɔwɔ ayi abɔ agare nnó achwɔɔ́?” ");
INSERT INTO anvNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Jɔn ashuú ɛbwɔ́ meko aké, “Me, nwyage ɛnyú ne manaá Ɛsɔwɔ mamímamí, yɛ́mbɔ muú fɔ alú fa metɔɔ́ metɔɔ́ ɛnyú ayi délá kágé ji. ");
INSERT INTO anvNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Achwɔɔ́ mbɔ me meso, me nkwané yɛ́ muú ayi akágé manyií unó uka ɛbií wɔ́.” ");
INSERT INTO anvNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Unó bi na uko upyɛ né melɔ Bɛtani né ɛgbɛ́ ɛbɛɛ́ Jodan mbaá Jɔn awyagé bɔɔ́ manaá Ɛsɔwɔ. ");
INSERT INTO anvNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Bií ujyagé Jɔn agɛ́ ndɛre Jisɔs achwɔ́ɔ ɛta wuú, aké, “Gɛgé maá ɛgɔŋme Ɛsɔwɔ ayi akpáné gabo akwaá fa mme. ");
INSERT INTO anvNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Ji ne me mbɔ njɔɔ́ge ntome ne ji nnó, ‘Muú fɔ achwɔ́ɔ mbɔ me meso ayi apwɔɔ́ me néndé gemɛ́ge nnó ábyɛ́ me ji abɔ́ alu mɛ́.’ ");
INSERT INTO anvNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Me mbɔɔ́, mbɔ nkaá fɔ́ ji wɔ́. Yɛ́mbɔ ula bi me nwyagé bɔɔ́ manaá Ɛsɔwɔ úlú ɛlé mampyɛ bɔɔ́ Isrɛli akaá ji.” ");
INSERT INTO anvNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Ne Jɔn agaré bɔɔ́ geno ɛyigé ji agɛne, aké, “Ngɛ́ Mendoó Ukpea ndɛre ɛtané mfaánebuú ɛké gepwine ɛchwɔ́ tɛ́ne ji mmyɛ. ");
INSERT INTO anvNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Me mbɔɔ́, nkaá fɔ ji wɔ́, yɛ́mbɔ muú ayi atɔmé me nnó nwyaá bɔɔ́ manaá agaré me aké, ‘Muú ayi ɔgɛné Mendoó Ukpea ɛ́shúlege ɛtɛné ji mmyɛ, ji yi mbɔ ne alú muú ayi awyagé bɔɔ́ ne Mendoó Ukpea.’ ");
INSERT INTO anvNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Me ngɛ́ ndɛre ɛpyɛmbɔ ne Jisɔs, ne ngarege ɛnyú nnó ji alú Maá Ɛsɔwɔ.” ");
INSERT INTO anvNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Bií ɛbifɔ́ ujyágé, Jɔn ama atɛné ɛfɛɛ́ ne baá utɔɔ́ bií apea. ");
INSERT INTO anvNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Ndɛre agɛ́ne Jisɔs akɛne ajyɛ, ajɔɔ́ ne baá utɔɔ́ bií aké, “Gɛ́gé maá ɛgɔŋme gepɛgé Ɛsɔwɔ mbɔ.” ");
INSERT INTO anvNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Ne baá utɔɔ́ bií bimbɔ apeá áwúgé ndɛre Jɔn ajɔɔ́ mbɔ, ákwɔlé Jisɔs. ");
INSERT INTO anvNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Jisɔs ábwɔ́légé ushu meso agɛ́ ɛbwɔ́ ndɛre akwɔlégé ji, ágií ɛbwɔ́ aké, “Ɛnyú dekɛlégé ndé?” Ɛbwɔ́ aké ne ji “Rabi wɔ ɔjwɔlege ɛfɔ́” (Ula Rabi utɛne nnó menlɛré). ");
INSERT INTO anvNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Aké ne ɛbwɔ́, “Chwɔ́ge dégɛ́ mbaá ayi me njwɔlege.” Ɛbwɔ́ ákwɔlé yɛ́ ji ájyɛ gɛ́ mbaá awu, álá ɛwú ábɛlé ne ji bií bimbɔ. Gébé ɛyigémbɔ gébɔ́ gélú káláŋká ɛni né nkwale. ");
INSERT INTO anvNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Ne baá utɔɔ́ bina apeá abi áwuú ndɛre Jɔn ajɔɔ́ ákwɔlé Jisɔs, ama ɛle Andru meŋmo Simun Pita. ");
INSERT INTO anvNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Andru abɔ́ mbɛ akɛlé meŋmo wuú Simun. Agɛ́gé ji, agaré ji aké, “Ɛsé degɛ́ Muú yi Ɛsɔwɔ akweré ji ɛlá gefwa.” Mabɔ ami na, malu wyɛ mabɔ mami mamaá ne Kras. ");
INSERT INTO anvNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Asɛ́ yɛ́ Simun afɛ́ mbaá Jisɔs ne Jisɔs apɛ́ ji domeé, aké, “Wɔ ɔkamege Simun maá Jɔn, akuú nyɛ ntó wɔ nnó Sɛfas.” Sɛfas alu wyɛ mabɔ mami mamaá ne Pita. (Ula Pita utɛne nnó ɛtárávɛ́.) ");
INSERT INTO anvNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Bií ɛbifɔ ujyagé, Jisɔs akpome mmyɛ manjyɛ Galilií, ndɛre ajyɛɛ́ agɛ́ Filip, ajɔɔ́ ne ji aké, “Kwɔlé me.” ");
INSERT INTO anvNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Filip ntó atané Bɛtsada maá melɔ ayi Andru ɛbwɔ́ ne Pita atane wyɛ. ");
INSERT INTO anvNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Filip akɛle Nataniɛl. Agɛ́gé ji, agaré ji aké, “Ɛsé dégɛ́ muú ayi Mosis asamé né mabɛ́ atome ne ji ne bɔɔ́ ɛkpávé Ɛsɔwɔ ntó ásá ato ne ji. Alu Jisɔs muú Nasarɛt maá Josɛf.” ");
INSERT INTO anvNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Nataniɛl akale aké, “Ɛ ɛ́! Genó gelɔ́gélɔ́ ntó gétánege né Nasarɛt.” Filip aké, “Chwɔ́ kpa amɛ jyɛ ɔgɛ́.” ");
INSERT INTO anvNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Jisɔs agɛ́gé ndɛre Nataniɛl achwɔɔ́ ɛta wuú, aké, “Gɛ́ maá Isrɛli ayi wáwálé na. abwɔlége fɔ dembwɔle.” ");
INSERT INTO anvNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Nataniɛl agií ji aké, “Ɔpyɛ nnó ne ɔkaá me?” Jisɔs ashuú ji meko aké, “Gemɛgé nnó Filip akú wɔ, me ngɛ́ mɛ wɔ né ulaá genɔɔ́ ɛyigé ákuú nnó fig.” ");
INSERT INTO anvNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Nataniɛl awúgé mbɔ, aké, “Ménlɛré wɔ ɔlu Maá Ɛsɔwɔ, ɔlu nto mfwa bɔɔ́ Isrɛli.” ");
INSERT INTO anvNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Jisɔs aké ne ji, gétúgé ngaré wɔ nnó ngɛ́ wɔ né ulaá genɔɔ́ ɛyigémbɔ, “Ne ɔfyɛɛ́ metɔɔ́ ne me? Ɔgɛ́ne nyɛ ukpɛ́kpɛ́ unó bi upwɔɔ́ ɛbi.” ");
INSERT INTO anvNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Ama ajɔɔ́ aké, “Ngarége ɛnyu wáwálé nnó, dégɛ́ne nyɛ nkane mfaánebuú anenege ne makiɛ́nné Ɛsɔwɔ akwɔme áshulege ne mfaa Maá Ntɛ Mekwaá.” ");
INSERT INTO anvNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Bií ɛbifɔ́ ujyagé, né ndɔ ɛyi ɛgbeé ɛlɛɛ́, neba nefɔ́ nebɔ́ nélú né melɔ Kana né gebagé mewaá Galilií, mma Jisɔs abɔ́ alú wyɛ. ");
INSERT INTO anvNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Álɔ ntó Jisɔs ne baá utɔɔ́ bií né neba ɛníné mbɔ. ");
INSERT INTO anvNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Ne mmɔɔ́ ɛpaá ɛwémbɔ mabyɛgé mma Jisɔs ajɔɔ́ ne ji aké, “Mmɔɔ́ bwɔ́ mabyɛ.” ");
INSERT INTO anvNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Ne Jisɔs ajɔɔ́ ne ji aké, “Mma ɔgarégé fɔ́ me genó ɛyigé mbɔɔ́ mampyɛ, gébé ya gélú gakwáne.” ");
INSERT INTO anvNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Yɛ́mbɔ mma Jisɔs ajɔɔ́ ne baá defwɛ abi ánɛne aŋkɛɛ́ aké, “Pyɛgé yɛ́ndégenó ɛyigé ji agarege ɛnyú nnó dépyɛ.” ");
INSERT INTO anvNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Ɛké ɛpyɛɛ́mbɔ, bɔ nkwɔ́ manaá fɔ akené álú ɛfɛɛ́ kwɔ́kwɔ́lé abi bɔɔ́ Jus áchwɛle manaá wyɛ ne áshwɔ́nege byɔ bwɔ́ manɛmmyɛ mbaá Ɛsɔwɔ ndɛre gepɔgé bwɔ́ gélú. Nkwɔ́ ama akpɛne baá bɔ nda manaá ɛsaá yɛ́ ɛsaá meso ɛfya. ");
INSERT INTO anvNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Jisɔs ajɔɔ́ ne baá defwɛ abi ánɛ́ne aŋkɛɛ́ aké, “Fyɛgé manaá magbeé né bɔ ŋkwɔ́ bimbɔ.” Áfyɛgé manaá magbégé lábé lábé, ");
INSERT INTO anvNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","aké ne ɛbwɔ́, “Chwɛgé amifɔ déchyɛ memgbare ɛpaá.” Ne ápyɛ wyɛ ndɛre ji ájɔɔ́. ");
INSERT INTO anvNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Ne memgbare ɛpaá afwɔ́régé manaá amimbɔ, ami mabwɔlé mmɔɔ́, akaá fɔ́ mbaá ayi mami matané wɔ́. Yɛ́mbɔ bɔɔ́ abi áchwɛlé manaá amimbɔ ákaá. Ne megbare ɛpaá akuú menɔ neba atɛné baba, ");
INSERT INTO anvNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","ajɔɔ́ ne ji aké, “Yɛ́ndémuú anɛgé ɛpaá, abɔɔ́ kpɛ mbɛ achwɔ́ ne mmɔɔ́ malɔ́málɔ́. Bɔɔ́ ányúgé mɛ kpaá ápwagé ne achwɔ́ ne ami mabomabo. Ne wɔ ɔbelé mmɔɔ́ ami malɔ́málɔ́ mala kpaá tɛ́ nana”? ");
INSERT INTO anvNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Gɛ gepɔge ufélekpa mbɛ ɛyigé Jisɔs apyɛɛ na. Ápyɛ geji né Kana né gebagé mewaá Galilií. Apyɛ mbɔ manlɛre gepɔgé uto bií. Ne baá utɔɔ́ bií ágɛ́gé mbɔ áfyɛɛ́ matɔɔ́ ne ji. ");
INSERT INTO anvNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Ɛpaá ɛwémbɔ ɛbyɛ́gé, Jisɔs ashulé afɛ́ né Kapanɔm ne mma wuú, aŋmo bií ne baá utɔɔ́ bií, ɛfɛɛ́ ne ɛbwɔ́ ábɛlé mboó ndɔ. ");
INSERT INTO anvNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Ɛpaá koó upú bɔɔ́ Jus ɛlágé kwɔ́kwɔ́lé Jisɔs akwɔ́ afɛ́ né Jɛrosalɛ. ");
INSERT INTO anvNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Akwɔ́négé, akpɛ né mmu dachi ɛcha upɛ Ɛsɔwɔ. Agɛ́ ndɛre bɔɔ́ abi ákpóo mpɔ, magɔŋme, upwene mampyɛ upɛ mbaa Ɛsɔwɔ, ne abi ájwɔlé ákwɔ́rege maŋka. ");
INSERT INTO anvNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Agɛ́gé mbɔ, abɔ́ manyií akwyɛ getó, abú bɔɔ́ bimbɔ ako átané wyɛ chónchó ne magɔŋme, ne mpɔ. Atyá maŋka ayi bɔɔ́ abi ákɛne gesegé maŋka mankwɔré, amu makpókpógélé bwɔ́ agbɛ́. ");
INSERT INTO anvNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Ne anyá bɔɔ́ abi akpoó upwene aké, “Kpagé ubi détáné fa, débɔ́fɔ́ mambwɔlé gepúgé Ntɛ wa gélá ntoné gese wɔ́.” ");
INSERT INTO anvNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Jisɔs apyɛgé mbɔ, baá utɔɔ́ bií áte meko mejɔɔ́ ayi asamé né mmu ŋwɛ Ɛsɔwɔ nnó, “Géchyɛɛ́ ɛyigé me nwyaá né gepú jyɛ gesɔɔ́ me mmu ɛké mewɛ.” ");
INSERT INTO anvNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Ákpákpá bɔɔ́ Jus áchwɔ́ɔ jɔɔ́ ne Jisɔs áké, “Ndé gefɔgé gepɔ ɛyigé wɔ ɔkagé lɛré mampyɛ ɛsé dékaá nnó ɛlé Ɛsɔwɔ ne achyɛ wɔ ɛshyɛ mampyɛ depɔ ɛti.” ");
INSERT INTO anvNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Jisɔs ashuú ɛbwɔ́ meko aké, “Muúgé ɛcha upɛ ɛwéna, nsɛlé ndɔ ɛlɛɛ́ mpyɛ ɛwú ɛkere meso ndɛre ɛbɔ ɛlu”. ");
INSERT INTO anvNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Bɔɔ́ bimbɔ áké, “Ɔké ndeé? Ɛcha upɛ ɛwé, ɛsɛlé ɛsé usaá ŋmɛ upeá meso ɛkené mantɛné, ne wɔ ɔké ɔsɛlé ndɔ ɛlɛɛ́ mantɛné ɛwú?” ");
INSERT INTO anvNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Yɛ́mbɔ ɛcha upɛ ɛwé Jisɔs ajɔɔ́ mbɔ, ató ɛlé ne menyammyɛ wuú jimbɔɔ́. ");
INSERT INTO anvNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Jisɔs akwilégé né negbo, baá utɔɔ́ bií áte nnó ji abɔ́ ajɔɔ́ mɛ́ mechɔ́ ɛwé. Ákamé ne genó ɛyigé ŋwɛ Ɛsɔwɔ ajɔɔ́ ne ɛyigé Jisɔs ajɔɔ́. ");
INSERT INTO anvNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Ne gébégé Jisɔs alú né Jɛrosalɛ anyɛɛ́ ɛpaá koó upú, apyɛ gejamégé bɔɔ́ áfyɛɛ́ matɔɔ́ ne ji gétúgé ufɔɔ́ unó ne ufélekpa ɛbi ji apyɛɛ́. ");
INSERT INTO anvNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Yɛ́mbɔ Jisɔs afyɛɛ́ fɔ́ matɔɔ́ ne ɛbwɔ́ wɔ́, néndé akaá ndɛre mekwaá alú. ");
INSERT INTO anvNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Ɛpɔ́sé ɛwé muú agarégé ji néndé jimbɔɔ́ akaá mɛ́ genó ɛyi gélú mekwaá metɔɔ́. ");
INSERT INTO anvNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Muú kpaá bɔɔ́ Jus fɔ abɔ́ alú, ayi ákuú ji Nikodɛmus. Alú muú ɛkwɔ́ bɔɔ́ Farasi. ");
INSERT INTO anvNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Mende yimbɔ achwɔ́ bané Jisɔs ne utuú, ajɔɔ́ ne ji aké, “Ménlɛré ɛsé dékaá nnó Ɛsɔwɔ ne atɔmé wɔ, néndé muú fɔ akágé pyɛ unó bi wɔ ɔpyɛ́ɛ, mbɔgé Ɛsɔwɔ álá pɔ́ ne ji.” ");
INSERT INTO anvNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Ne Jisɔs ashuú ji meko aké, “Ngarégé wɔ wáwálé nnó, mbɔgé álá ábyɛ́ muú mambyɛ ayi mekɛ wɔ́, agɛne fɔ́ gefwa ɛyigé Ɛsɔwɔ ágbárege.” ");
INSERT INTO anvNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Ajɔɔ́gé mbɔ, Nikodɛmus agií ji aké, “Muú akwɔ́gé mbɔ mɛ́ ukoó, ápyɛɛ́ mbɔ nnó ne ámá ábyɛ́ ji?” nno amage kpɛ né mmu unɛ mma wuú ábyɛ́ ji? ");
INSERT INTO anvNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Jisɔs ashuú ji meko aké, “Ngarégé wɔ wáwálé nnó mbɔgé álá ábyɛɛ́ muú nebyɛɛ́ né manaá ne Mendoó wɔ́, anyɛɛ́ fɔ́ gefwage Ɛsɔwɔ. ");
INSERT INTO anvNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Mekwaá abyɛne ɛle ntɛ mekwaá, Mendoó ntó ɛbyɛne ɛlé Mendoó. ");
INSERT INTO anvNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Ɛ́kágé ɔlá meno mekpo fuú, ɛlé njɔɔ́ ne wɔ nnó, abɔ́ mambyɛ́ muú mambyɛ́ ayi mekɛ. ");
INSERT INTO anvNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Mbyo amyɛ yɛ́ndé mbaá ayi akɛlégé, muú awuú gewya jií, yɛ́mbɔ ákágé fɔ mbaá ayi atané ne mbaá ayi ajyɛ. Wyɛmbɔ ntó ne ɛlu ne muú ayi ábyɛ́ne ji né Mendoó. Muu ákaáge gare fɔ́ ndɛre Mendoó ɛbyɛne Mendoó.” ");
INSERT INTO anvNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nikodɛmus awúgé mbɔ, agií Jisɔs aké, “Ɛwéna ɛbɛɛ mbɔ nnó?” ");
INSERT INTO anvNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Jisɔs ashuú ji meko aké, “Wɔ ɔlú gekpɛ́kpɛ́gé menlɛré bɔɔ́ Isrɛli nnó ɔkágé unó bi?” ");
INSERT INTO anvNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Ngaregé wɔ wáwálé nnó, ɛsé dejɔɔ́ge depɔ ɛtiré dékágé, ne dégarege unó bi ɛsé dégɛ́ne, yɛ́mbɔ ɛnyú dékɛlege fɔ manwú. ");
INSERT INTO anvNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Ngarege ɛnyú unó bi upyɛ fa mme ɛnyú dékámégé, nnó ngare ɛnyú ɛbi upyɛ́ɛ né mfaánebuú ne dékámegé? ");
INSERT INTO anvNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Yɛ́ muú ayi akwɔmé mɛ́ ájyɛɛ́ né mfaánebuú apɔ́, ɛkosé wyɛ Maá Ntɛ Mekwaá ne atané mfaánebuú achwɔ́ɔ fa mme. ");
INSERT INTO anvNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Ndɛre Mosis abwɛɛ́ nyá mmyɔ né mashwɔne wyɛmbɔ ntó ne abɔɔ́ mambwɛ Maá Ntɛ Mekwaá né mfaá ");
INSERT INTO anvNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Ne yɛ́ndémuú ayi áfyɛɛ́ metɔɔ́ ne ji, abɔ́ geŋwá ɛyi gélágé byɛ́. ");
INSERT INTO anvNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Ɛsɔwɔ abɔ́ gejeé ne bɔɔ́ mme, nkáwú ne atɔmé danchi maá wuú nnó yɛ́ndémuú ayi áfyɛɛ́ metɔɔ́ ne ji, anomé fɔ́ mme detu, abɔ́ geŋwá ɛyi gélágé byɛ́. ");
INSERT INTO anvNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Ɛsɔwɔ átɔɔ́ fɔ́ Maá wuú fa mme nnó áchwɔ́ ágare nnó bɔɔ́ mme ákwe mpa wɔ́. Atɔ́ lé ji nnó áchwɔ́ áfere ɛbwɔ́ né ɛfwyale gabo. ");
INSERT INTO anvNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Yɛ́ndémuú ayi áfyɛɛ́ metɔɔ́ ne ji akwene fɔ́ mpa, yɛ́mbɔ muú ayi álá áfyɛɛ́ metɔɔ́ ne ji wɔ́ akwe mɛ́ mpa néndé áfyɛɛ́ fɔ́ metɔɔ́ ne danchi Maá Ɛsɔwɔ wɔ́. ");
INSERT INTO anvNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Gɛ́ na ne mpa ayi mbɔ abɛɛ́ nyɛ. Geŋgbɔ́ gechwɔ́ fa mme, yɛ́mbɔ bɔɔ́ ágbóo ne gemua ápwɔ geŋgbɔ́ néndé unó bi ɛbwɔ́ abɔ ápyɛ ulɔmé fɔ. ");
INSERT INTO anvNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Ne yɛ́ndémuú ayi apyɛ́ɛ gabo akií fɔ geŋgbɔ́, ne akɛ́légé fɔ́ manchwɔ́ né geŋgbɔ́ nnó ɛkágé gabo wuú agɛ́né. ");
INSERT INTO anvNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Yɛ́mbɔ muú ayi apyɛ́ɛ galɔ́gálɔ́, achwɔɔ́ né geŋgbɔ́, nnó galɔ́gálɔ́ wuú agɛ́né ágɛ́ nnó ji apyɛ́ɛ ndɛre Ɛsɔwɔ akɛ́lege. ");
INSERT INTO anvNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Ɛwyágé Jisɔs ne baá utɔɔ́ bií alyaá Jɛrosalɛ, áfɛ́ né gebagé mewaá Judiya ábɛlé ɛwú mboó ndɔ awyagé bɔɔ́ manaá Ɛsɔwɔ. ");
INSERT INTO anvNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Né gébé ɛyigémbɔ, Jɔn menwyaá bɔɔ́ manaá Ɛsɔwɔ abɔ́ awyagé ntó bɔɔ́ manaá Ɛsɔwɔ né melɔ Ɛnɔn ɛwé ɛlú kwɔ́kwɔ́lé ne melɔ Salim, ɛlé manaá malú ɛwú dɔɔ́. Bɔɔ́ ájyɛ ɛta wuú awyagé ɛbwɔ́ manaá Ɛsɔwɔ. ");
INSERT INTO anvNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","(Né gébé ɛyigémbɔ, ábɔ́ álú danfyɛ Jɔn né denɔ.) ");
INSERT INTO anvNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Ɛwyágé muú Jus fɔ alɔ́ manyɛ mbeé ne baá utɔɔ́ Jɔn, gétúgé gefɔɔ́ ɛyigé muú abɔɔ́ manshwɔné mmyɛ ne ábɛ́ pópó né mbɛ ushu Ɛsɔwɔ. ");
INSERT INTO anvNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Ne baá utɔɔ́ Jɔn achwɔ́ ɛta wuú agaré ji aké, “Ménlɛré, mende ayi nyá ɔbɔ́ ɔlu ne ji né ɛgbɛ́ ɛbɛɛ́ Jodan ɛwé né, ayi ɔbɔ ɔgarege bɔɔ́ gétú jií, alú mbɔ fa ne bɔɔ́ ako ájyɛɛ́ ɛta wuú awyagé ɛbwɔ́ manaá Ɛsɔwɔ.” ");
INSERT INTO anvNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Ájɔɔ́gé mbɔ, Jɔn ashuú ɛbwɔ́ meko aké, “Muú fɔ akágé bɔ́ genó ɛkose nno Ɛsɔwɔ achyɛge ji geji. ");
INSERT INTO anvNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Ɛnyú ambɔɔ́ délú bɔ ntɛ́sɛ́ ba gébégé ngaré nnó, ‘Me mpɔ́ fɔ́ Muú yi Ɛsɔwɔ akweré ji ɛlá gefwa. Ɛsɔwɔ atɔ me nnó mbɔ́ mbɛ ne ji.’ ");
INSERT INTO anvNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Menɔ neba ne awyaá mendée neba, yɛ́mbɔ mejeé menɔ neba, muú ajwɔlege awuú meko menɔ neba, abɛɛ́ ne nechɔ́chɔ́ gétúgé meko menɔ neba ayi ji awuú. Nechɔ́nchɔ́ ɛnina nelú ɛna, ne nana metɔɔ́ ɛgɔɔ́ me gétúgé mende yina. ");
INSERT INTO anvNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Ji abɔ́ mankwɔ́ ŋgɔ́, me mbɔ́ magbó gelú.” ");
INSERT INTO anvNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","“Muú yi atané mfaánebuú aŋea gemɛ apwɔ bɔɔ́ ako. Muú mme, abyɛ wyɛ muú mme ne ajɔɔ́gé lé depɔ ndɛre bɔɔ́ mme ájɔɔ́ge. Ji ayi atané mfaánbeuú apwɔ bɔɔ́ ako. ");
INSERT INTO anvNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Ji agarege unó bi ji awuú ne ɛbi agɛ́ne, yɛ́mbɔ yɛ́ muú yi akamege meko wuú apɔ́. ");
INSERT INTO anvNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Yɛ́ndémuú ayi akámege meko mejɔɔ́ wuú alɛrege nnó genó ɛyigé Ɛsɔwɔ ajɔɔ́ gelú wáwálé. ");
INSERT INTO anvNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Ne muú yi Ɛsɔwɔ atɔmé, ajɔɔ́gé ɛlé depɔré Ɛsɔwɔ néndé Ɛsɔwɔ achyɛge ji uto Mendoó wuú byágébyágé. ");
INSERT INTO anvNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Ntɛ agboó ne Maá, ne afyɛ ji unó uko né amu. ");
INSERT INTO anvNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Ne yɛ́ndémuú ayi áfyɛɛ́ metɔɔ́ ne Maá yimbɔ, awyaá geŋwá ɛyi gélágé byɛ́. Yɛ́mbɔ, yɛ́ndémuú ayi atoó mekpo mamfyɛ metɔɔ́ ne ji agɛ́né fɔ́ geŋwá ɛyigémbɔ, metɔɔ́ usɔɔ́ Ɛsɔwɔ ɛlu ne muú yimbɔ tɛ kwyákwyá.” ");
INSERT INTO anvNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Ɛkwɔ́ bɔɔ́ Farasi áwú nnó bɔɔ́ abi ajyɛɛ mbaa Jisɔs, ji awyage ɛbwɔ́ manaá Ɛsɔwɔ aja apwɔ abi ajyɛɛ mbaá Jɔn. ");
INSERT INTO anvNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Yembɔ wáwálé alú nnó Jisɔs jimbɔ awyáge fɔ́ bɔɔ́ manaá Ɛsɔwɔ, ɛlé baá utɔɔ́ bií ne áwyáge. ");
INSERT INTO anvNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Ne Jisɔs awúgé nnó bɔɔ́ Farasi áwu nnó bɔɔ́ abi áchwɔɔ́ ɛta wuú aja apwɔ abi Jɔn, alyaá Judiya akeré meso né Galilií, ");
INSERT INTO anvNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","abɔ́ mankoó wyɛ né gebage mewaá Samariya ne afɛ́ né gebagé mewaá Galilií. ");
INSERT INTO anvNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Ákwɔ́négé né gebagé mewaá Samariya akwɔné melɔ ɛwé ákuú nnó Sikar. Sikar alú kwɔ́kwɔ́lé ne melú mme ɛwé Jakɔb abɔ́ achyɛ́ɛ maá wuú Josɛf. ");
INSERT INTO anvNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Ɛmbu manaá ɛwé Jakɔb abɔ́ áchomé ɛlú ntó ɛfɛɛ́. Jisɔs ákɛgé ápwagé, ajyɛ jwɔ́lé wyɛ. Gébé gélú kalaŋká ɛfyánéɛpeá ne ŋwɔmese ɛyigé Jisɔs akwɔné né mbaá yimbɔ. ");
INSERT INTO anvNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Ɛké ɛwyáge, mendée Samariya fɔ achwɔ́ ɛfɛɛ́ manchwɛ́ manaá. Jisɔs ajɔɔ́ ne ji aké, “Chyɛɛ́ me manaá nyú.” ");
INSERT INTO anvNT_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Gébé ɛyigémbɔ, baá utɔɔ́ bií áfɛ́ né melɔ manjyɛ na menyɛɛ́. ");
INSERT INTO anvNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Mendée Samariya yimbɔ aké, ne ji “Wɔ ɔlú muú Jus, me nlú muú Samariya, ɛpyɛɛ́mbɔ nnó ne ɔgií me manaá manyú?” Ajɔɔ́ mbɔ néndé bɔɔ́ Jus ne bɔɔ́ Samariya átuúgé fɔ. ");
INSERT INTO anvNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Jisɔs ashuú ji meko aké, “Wɔ ɔbɔ́ ɔkaá mbɔ ɛchyɛ ɛwé Ɛsɔwɔ achyɛgé ne gefɔgé muú ayi agií mbɔ wɔ manaá, mbɔ ɔgií ji, ne ji abɔ́ achyɛgé wɔ manaá ami machyɛge geŋwá.” ");
INSERT INTO anvNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Mendée yimbɔ ajɔɔ́ ne ji aké, “Ata ɔpɔ́ ne genó manchwɛ́ manaá, ne ɛmbu manaá ɛwéna ɛgomé. Ɔpyɛ́ɛ mbɔ nnó ne ɔgɛ́ manaá ami machyɛgé geŋwá? ");
INSERT INTO anvNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Nnó wɔ ɔŋeá gemɛ ɔpwɔ gekwenege ntɛ sé Jakɔb muú áchomé ɛsé ɛmbu manaá ɛwéna? Ɛwé jimbɔ, baá bií ne utú bií anyuú manaá wyɛ.” ");
INSERT INTO anvNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Jisɔs aké ne ji, “Yɛ́ndémuú ayi anyú manaá amina, mmwɔ́lé manaá ɛmágé pyɛ ji, ");
INSERT INTO anvNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","yɛ́mbɔ, yɛ́ndémuú ayi anyúu manaá ami me nchyɛge nyɛ, mmwɔ́lé manaá ɛmágé pyɛ sé ji tɛ kwyakwya. Ne manaá ami me nchyɛge ji, mabwɔlége nyɛ mala ɛta wuú ɛké ɛmbu nnyi ɛwé ɛtanege manaá ami machyɛ́ge geŋwá ɛyi gélágé byɛ́.” ");
INSERT INTO anvNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Mendée yimbɔ aké, “Ata chyɛɛ́ me manaá amimbɔ nnó mmwɔ́lé manaá ɛpyɛgé sé me, ne nnó nchwɔ́ge sé fa manchwɛ́ manaá.” ");
INSERT INTO anvNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Jisɔs ajɔɔ́ ne ji, aké, “Chó kuú menɔ wyɛ ɛnyú déchwɔ́.” ");
INSERT INTO anvNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Ne mendée yimbɔ ashuú ji meko aké, “Me mmpɔ ne menɔ”, Jisɔs aké, “Wɔ ɔlú cho ndɛre ɔké ɔpɔ́ ne menɔ, ");
INSERT INTO anvNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","néndé ɔbɔ́ ɔbá mɛ́ anɔ ata, ne ayi ɔlú mbɔ ne ji nana, apɔ́ fɔ́ menɔ wyɛ. Genó ɛyigé wɔ ɔjɔɔ́ mbɔ gélú wáwálé.” ");
INSERT INTO anvNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Mendée yimbɔ ajɔɔ́ ne ji aké, “Ata ɛlúmbɔ ɛké wɔ ɔlú muú ɛkpávé Ɛsɔwɔ. ");
INSERT INTO anvNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Ukwene antɛ sé ábɔ́ ánógé Ɛsɔwɔ né mekwɛ ɛwéna, yɛ́mbɔ ɛnyú bɔɔ́ Jus deké ánógé ɛlé Ɛsɔwɔ né melɔ Jɛrosalɛ.” ");
INSERT INTO anvNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Jisɔs ajɔɔ́ ne ji aké, “Kámé genó ɛyigé me njɔɔ́gé, gébé gechwɔ́ nyɛ ɛyigé ɛnyú délá nógé sé Ɛsɔwɔ fa né mekwɛ ɛwéna, yɛɛ́ ɛbɛ́lé né Jɛrosalɛ. ");
INSERT INTO anvNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Ɛnyú bɔɔ́ Samariya dénógé genó ɛyigé délá kaágé, ɛsé bɔɔ́ Jus dénógé genó ɛyigé dékaágé néndé muú ayi áférege akwaá né ɛfwyale gabo atanege nyɛ ɛlé né mbaá bɔɔ́ Jus. ");
INSERT INTO anvNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Yɛ́mbɔ gébé gechwɔ́ɔ, ne géchwɔ́ mɛ́, ɛyige bɔɔ́ abi anógé Ntɛ sɛ wáwálé anoge nyɛ ji né gefɔɔ́ ɛyi gelu wáwálé ndɛre Mendoó Ɛsɔwɔ ɛlɛrege. Gɛ́ ufɔɔ́ bɔɔ́ abi Ɛsɔwɔ akɛ́lege nnó ánoógé ji mbɔ. ");
INSERT INTO anvNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Ɛsɔwɔ alú Mendoó ne bɔɔ́ abi anógé ji abɔ́ manógé ji né gefɔɔ́ ɛyi gelu wáwálé ndɛre Mendoó Ɛsɔwɔ ɛlɛrege.” ");
INSERT INTO anvNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Ne mendée yimbɔ aké, “Nkaá nnó Muú yi Ɛsɔwɔ akweré ji ɛlá gefwa, ayi akuú ji Kras achwɔ́ɔ, gébégé achwɔ́gé agarege nyɛ ɛsé yɛ́ndégenó cháŋéné.” ");
INSERT INTO anvNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Jisɔs agaré yɛ́ ji aké, “Me yi njɔ́ge mbɔ nlu ji awu.” ");
INSERT INTO anvNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Ɛké ɛwyágé baá utɔɔ́ Jisɔs áchwɔ́; ne álá meno mekpo fuú nkane ágɛ́né ji ajɔɔ́ge mejɔɔ́ ne mendée yɛ́mbɔ yɛ́ muú ayi agií ji nnó ɔkɛlege ndé, yɛ́ ɛbɛ́ ɛlé nnó ulannó ɔjɔɔ́ge mejɔɔ́ ne mendée yina apɔ́. ");
INSERT INTO anvNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Mendée yimbɔ alyaá yɛ́ ŋkwɔ́ manaá wuú ɛfɛɛ́ afɛ́ né melɔ ajyɛ gáré bɔɔ́ aké, ");
INSERT INTO anvNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Chwɔ́ge dégɛ́ mende ayi agaré me yɛ́ndégenó ɛyige me mbɔ mpyɛ́ɛ. Nnó ji ne alu Muú yi Ɛsɔwɔ akweré ji ɛlá gefwa?” ");
INSERT INTO anvNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Ne bɔɔ́ átané né melɔ ájyɛ́ɛ gɛ́ Jisɔs. ");
INSERT INTO anvNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Né gébé ɛyigé mendée yimbɔ ajyɛɛ né melɔ, baá utɔɔ́ Jisɔs ákpeáge ji áké, “Ménlɛré nyɛ́ menyɛɛ́.” ");
INSERT INTO anvNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Yɛ́mbɔ Jisɔs ajɔɔ́ ne ɛbwɔ́ aké, “Me nwya menyɛɛ́ manyɛ́ ayi ɛnyú délá kaá wɔ́.” ");
INSERT INTO anvNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Ajɔɔ́gé mbɔ, baá utɔɔ́ bií ájɔɔ́ ne atɛ aké, “Nnó muú fɔ achwɔ́ ji ne menyɛɛ́?” ");
INSERT INTO anvNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Ndɛre ájɔɔ́gé mbɔ, Jisɔs aké, “Menyɛɛ́ wa alú ɛlé mampyɛ genó ɛyigé muú ayi atɔmé me akɛ́lege ne mampyɛ utɔɔ́ bií nnéré chánchá. ");
INSERT INTO anvNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Pɔ́ ɛnyú déjɔɔ́ge na nnó, ‘Ɛla amfaá ani ne mbwɛ́ ákwɔ́né mamferé?’ Yɛ́mbɔ me ngarege ɛnyú nnó bwɛge amɛ dépɛ makɔɔ́, mbwɛ akwɔné mɛ́ mamferé. ");
INSERT INTO anvNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Yɛ nana muú ayi aférégé mbwɛ́ abɔɔ́ nsa wuú ne anywerege mbwɛ́ yimbɔ́ ne mbwɛ́ yimbɔ ɛle geŋwá ɛyi gélágé byɛ́. Ɛ́bɛgé mbɔ, mempɛné ne memferé ábɛɛ́ ne nechɔ́chɔ́ chónchó. ");
INSERT INTO anvNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Ɛ́pyɛgémbɔ, nekanemejɔɔ́ ɛniné ajɔɔ́ nnó, ‘Mempɛné apɛgé, memferé aféré’ nelú wáwálé. ");
INSERT INTO anvNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Me ntɔ́ ɛnyú nnó déjyɛɛ́ déféré mbwɛ́ né mekɔɔ́ ɛwé ɛnyú déla dépɛ́ɛ mbwɛ́ wyɛ wɔ́. Bɔɔ́ abi chá ápyɛ utɔɔ́, ɛnyú débɔ́ nsá né utɔɔ́ bwɔ́.” ");
INSERT INTO anvNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Né gébé ɛyigémbɔ gejamégé bɔɔ́ Samariya, áfyɛ́ metɔɔ́ ne Jisɔs gétúgé genó ɛyigé mendée yimbɔ agaré ɛbwɔ́ nnó, “Ágaré me yɛ́ndégenó ɛyigé mbɔ́ mpyɛ́ɛ.” ");
INSERT INTO anvNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Bɔɔ́ Samariya bimbɔ, ágɛ́gé Jisɔs, ánɛ́ ji mmyɛ nnó ajwɔ́lé ne ɛbwɔ́, ne Jisɔs abɛlé ne ɛbwɔ́ ndɔ ɛpeá. ");
INSERT INTO anvNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Né mboó ndɔ ɛyimbɔ, gejamégé bɔɔ́ ama áfyɛ́ metɔɔ́ ne Jisɔs gétúgé mekomejɔɔ́ ayi ji ágaré. ");
INSERT INTO anvNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Ne ájɔɔ́ ne mendée yimbɔ aké, “Ɛsé défyɛɛ́ metɔɔ́ ne Jisɔs nana ɛpɔ́sé gétúgé mekomejɔɔ́ ayi ɔgaré ɛsé néndé ɛsé ambɔɔ́ déwú ne dékaá nnó ji alu Mempoó bɔɔ́ mme wáwálé.” ");
INSERT INTO anvNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Ndɔ yimbɔ ɛpea ɛkógé, Jisɔs alyaá melɔ Samariya afɛ́ né Galilií. ");
INSERT INTO anvNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Jisɔs jimbɔɔ́ abɔ́ ajɔɔ́ mɛ́ aké, “Muú ɛkpávé Ɛsɔwɔ apɔ́ ne ɛ́nógé né melɔ wuú.” ");
INSERT INTO anvNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Ákwɔ́négé né Galilií bɔɔ́ melɔ Galilií ásɛ́ ji amu apeá néndé ɛbwɔ́ ágɛ́ yɛ́ndégenó ɛyigé Ji apyɛɛ́ né Jɛrosalɛ gébégé ɛpaá koó upú. Ɛlé ɛbwɔ́ ntó ábɔ́ álú wyɛ. ");
INSERT INTO anvNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Ne Jisɔs ama ajyɛ́ɛ né melɔ Kana ɛwé ji abɔ́ apyɛɛ́ manaá mábwɔ́lé mmɔɔ́ né gebagé mewaá Galilií. Ne muú kpaá gɔ́mena fɔ abɔ́ alú né melɔ Kapanɔm ayi maá wuú abɔ amée. ");
INSERT INTO anvNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Mende yimbɔ awúgé nnó Jisɔs atané melɔ Judiya achwɔ́ né Galilií, ajyɛ́ nɛ ji mmyɛ nnó áchwɔ́ ápyɛɛ́ maá wuú ayi amée álá magbómagbó átoó. ");
INSERT INTO anvNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Ne Jisɔs ajɔɔ́ yɛ́ ne ji aké, “Me nlá mpyɛ́ gepɔgé ufélékpá ɛbi ulɛ́rege utó Ɛsɔwɔ wɔ́, ɛnyú défyɛɛ́ fɔ́ matɔɔ́ ne me.” ");
INSERT INTO anvNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Ajɔɔ́gé mbɔ, muú kpaá yimbɔ aké, “Ata chwɔ́ déjyɛ́ ɛkágé maá wa agbó.” ");
INSERT INTO anvNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Ne Jisɔs ajɔɔ́ ne ji aké, “Chó maá wyɛ́ atoge nyɛ.” Ne mende yimbɔ akamé ne mekomejɔɔ́ ayi Jisɔs ajɔɔ́ mbɔ, afɛ́. ");
INSERT INTO anvNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Ndɛre mende yimbɔ ajyɛ́ɛ, baá défwɛ bií átuú ne ji né meti, ágaré ji áké, “Maá wyɛ alu mebɛ.” ");
INSERT INTO anvNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Ne mende yimbɔ agií ɛbwɔ́ gébé ɛyigé maá yimbɔ atoó. Áké, “Gefwene yimbɔ gébyɛ́ ji mmyɛ njuna né kalaŋká ama.” ");
INSERT INTO anvNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Ágárégé ji mbɔ, ate nnó ɛlé wyɛ né gébé ɛyigémbɔ ne Jisɔs abɔ́ ajɔɔ́ ne ji nnó, “Maá wyɛ atógé nyɛ.” Ndɛre ɛpyɛɛ́mbɔ mende yimbɔ ne ula gepú bií uko áfyɛ́ metɔɔ́ ne Jisɔs. ");
INSERT INTO anvNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Gɛ́ ndɔ ayi agbeé maŋáne apea ayi Jisɔs alɛré gepɔgé ufélékpá né Galilií gébégé atané né Judiya. ");
INSERT INTO anvNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Ndɔfɔ́ ɛkógé, Jisɔs alyaá Galilií akwɔ́ afɛ́ né Jɛrosalɛ manjyɛ nyɛ́ ɛpaá bɔɔ́ Jus fɔ́. ");
INSERT INTO anvNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Né melɔ Jɛrosalɛ, géntoógé manaá fɔ́ gélú wyɛ́ ɛyigé anɔ geji nebɔ agbá ata, Kwɔ́kwɔ́lé ne menombi ɛwé magɔ́ŋme ákóge wyɛ. Ákuú geji né mejɔɔ́ Hibru nnó Bɛtsata. ");
INSERT INTO anvNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Gejamégé bɔɔ́ abi amée, ájwɔlége wyɛ. Abi amɛ nónómé, ubwéré, ne abi amée unchanchi. Ágile nnó Nnyi nebulé. ");
INSERT INTO anvNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Ɛkiɛ́nné Ɛsɔwɔ fɔ́ ɛchwɔ́ɔ, gébégébé ɛbúlege géntoógé manaá ɛyimbɔ. Ne muú ayi ábɔɔ́ mbɛ ashúlége né mmu manaá mimbɔ, yɛ́ndé nemée ɛniné ji amée nebyɛɛ́. ");
INSERT INTO anvNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Mende fɔ ntó ayi abɔ́ amée né aŋmɛ ɛsaá meso nekuúnelɛɛ́ abɔ alu ɛfɛɛ́. ");
INSERT INTO anvNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Jisɔs agɛ́gé ji ndɛre álú ɛ́fɛɛ́ bɛ́lé, akaá nnó amée mɛ́ né gejamégé aŋmɛ. Agií ji aké, “Ɔkɛlege nemée nyɛ́ɛ nebyɛ?” ");
INSERT INTO anvNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Mende yimbɔ ashuú ji meko aké, “Ata, mpɔ́ ne muú ayi akpané me afyɛɛ́ né mmu gentoó ɛyigémbɔ gébégé nnyi nébulégé. Yɛ́ndégébé nkulégé manjyɛ, muú yicha abɔ́ mbɛ.” ");
INSERT INTO anvNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Ajɔɔ́gé mbɔ, Jisɔs aké ne ji, “Kwilé ka, pwi gebɔ jyɛ́, ɔjyɛ mmu.” ");
INSERT INTO anvNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Ne tɛ́nétɛ́né ayi Jisɔs ajɔɔ́ mbɔ mende yimbɔ atoó, akwilé ka, apwi gébɔ jií akɛne. Mechɔ́ ɛwéna ɛpyɛ́ né bií uwyaá bɔɔ́ Jus. ");
INSERT INTO anvNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Ɛpyɛ́gémbɔ, ákpakpa bɔɔ́ Jus ájɔɔ́ ne mende yi atoó mbɔ áké, “Fina ɛlé bií uwyaá, ne ɛbɛ́ sé ɛkamé fɔ́ nnó muú akpá gébɔ né bií uwyaá wɔ́.” ");
INSERT INTO anvNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Ne mende yimbɔ ashuú ɛbwɔ́ meko aké, “Muú ayi apyɛ me ntoó ne agaré me nnó nkpá gébɔ ya nkɛ njyɛ.” ");
INSERT INTO anvNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Ákpakpa bimbɔ, ágií ji áké, “Ndé muú awú agaré wɔ nnó ɔkpá gébɔ jyɛ ɔkɛné”? ");
INSERT INTO anvNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Mende yimbɔ akagé sé muú ayi apyɛ ji atoó, néndé gejamégé bɔɔ́ abɔ́ alú ɛfɛɛ́, ne Jisɔs akpɛ né mpú bwɔ́. ");
INSERT INTO anvNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Ɛwyagé Jisɔs ama agɛ́ ji né mmu ɛcha upɛ Ɛsɔwɔ, ajɔɔ́ ne ji aké, “Gɛ́, nana ɔtoó, ɔpyɛgé sé gabo, ɛ́kágé mechɔ́ kpáa ɛshúlí wɔ mmyɛ.” ");
INSERT INTO anvNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Ne mende yimbɔ ajyɛ garé yɛ́ ákpakpa bɔɔ́ Jus bimbɔ nnó ɛlé Jisɔs ne abɔ́ apyɛɛ́ ji atoó. ");
INSERT INTO anvNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Ɛfɛɛ́ mbɔ ne ákpakpa bɔɔ́ Jus álɔɔ́ manchyɛgé Jisɔs ɛfwyale gétúgé ji apyɛɛ́ muú atoó né bií uwyaá. ");
INSERT INTO anvNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Jisɔs ajɔɔ́ ne ɛbwɔ́ aké, “Ntɛ wa apyɛ utɔɔ́ yɛ́ndégébé, mentó mbɔ mampyɛge utɔɔ́.” ");
INSERT INTO anvNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Ajɔɔ́gé mbɔ, matɔɔ́ ásɔ́ ákpakpa bɔɔ́ Jus kpaá, ányɛ́meno nnó ábɔ́ manwá ji. Néndé ji akwé fɔ́ ɛbɛ́ bií uwyaá ɛwú ɛwú wɔ́, amɛɛ́ ntó mmyɛ ne Ɛsɔwɔ gétúgé ajɔɔ́ nnó Ɛsɔwɔ alú ntɛ wuú. ");
INSERT INTO anvNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Jisɔs ajɔɔ́ ne ɛbwɔ́ aké, “Me ngaré ɛnyú wáwálé nnó me Maá ntɛ́négé fɔ́ ushu ushu ba mampyɛ genó, ɛkosé unó bi me ngɛ́ne Ntɛ wa apyɛ́ɛ ne me ntó mpyɛ néndé yɛ́ndégenó ɛyigé Ntɛ apyɛ, geji ntó ne Maá apyɛɛ́. ");
INSERT INTO anvNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Ɛlé Ntɛ agboó ne me Maá alɛ́rege me unó uko ɛbi jimbɔɔ́ apyɛɛ́. Ne amágé lɛ́re nyɛ me ukpɛ́kpɛ́ unó bi upwɔɔ́ bina. Ne ɛnyú délaá nyɛ mano mekpo fuú. ");
INSERT INTO anvNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Ne wyɛ ndɛre Ntɛ apyɛ bɔɔ́ abi ágboó ákwilege ne negbo, achyɛ ɛbwɔ́ geŋwá, mbɔntó ne Maá achyɛgé geŋwá mbaá yɛ́ndémuú ayi ji Ntɛ akɛ́lege. ");
INSERT INTO anvNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Ne yɛ́ muú ayi Ntɛ wa asɔ́ɔ mpa wuú apɔ́. Yɛ́mbɔ achyɛ me Maá wuú utó nnó nsɔ́gé mpa bɔɔ́ akó. ");
INSERT INTO anvNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Nnó bɔɔ́ ako ánógé Maá wyɛ ndɛre ánógé Ntɛ. Muú ayi álá anógé Maá wɔ́, ɛbyɛnnó ánógé fɔ́ ntó Ntɛ muú atɔmé ji. ");
INSERT INTO anvNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Ne me ngarége ɛnyú wáwálé nnó yɛ́ndémuú yi awuú mekomejɔɔ́ wa ayina, ne áfyɛɛ́ metɔɔ́ ne muú ayi atɔmé me, awya geŋwá ɛyi gélágé byɛ́. Muú yimbɔ ntó akpɛ́né fɔ́ unɔɔ́ mpa, atané mɛ né meti negbo akpɛ né meti geŋwá. ");
INSERT INTO anvNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Ngarége ɛnyú wáwálé nnó gébé géchwɔɔ́, ne géchwɔ́ mɛ́ ɛyigé bɔɔ́ abi álú ne meti negboó awuú nyɛ meko Maá Ɛsɔwɔ. Ne bɔɔ́ abi awuú ne áfyɛɛ́ metɔɔ́ ne ji, ákerege nyɛ́ né meti geŋwá. ");
INSERT INTO anvNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Ndɛre Ntɛ wa jimbɔ alú menchyɛɛ́ geŋwá mbɔntó ne ji apyɛ me Maá wuú nnó mbɛ́ menchyɛɛ́ geŋwá. ");
INSERT INTO anvNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Ne achyɛɛ́ mɛ Maá wuú uto mansɔ́ mpa akwaá, néndé melú Maá Ntɛ Mekwaá. ");
INSERT INTO anvNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","“Ɛ́kágé délá mano mekpo fuú gétúgé mechɔ́ ɛwé. Gébé géchwɔ́ɔ ɛyigé áwuú bɔɔ́ abi álú né mmu manome áwúu nyɛ mekomejɔɔ́ Maá Ntɛ Mekwaá ");
INSERT INTO anvNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Áwúgé átánege nyɛ mmu manome. Abi ápyɛɛ́ unó bi Ɛsɔwɔ ákɛ́lege, ákwilége nyɛ ákpɛ né geŋwá ɛyi gélágé byɛɛ́. Ne abi ápyɛɛ́ gabo ákwilége nyɛ ákpɛ né unɔɔ́ mpa. ");
INSERT INTO anvNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Nkágé tɛ́ne fɔ́ ushu ushu ba mpyɛ genó. Nkane Ntɛ wa agárege me mbɔntó ne nsɔ́ɔ mpa. Ne gefɔɔ́ ɛyigé me nsɔ́ɔ mpa gelú cho, néndé nkɛlege lé mampyɛ genó ɛyigé muú ayi atɔmé me akɛ́lege nnó mpyɛ, ɛpɔ́fɔ́ ndɛre me nkɛ́lege mampyɛ. ");
INSERT INTO anvNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“Mbɔgé me mbɔɔ́ nke ngarege bɔɔ́ depɔ ɛtiré détome ne uto ba ɛbyɛ́nnó unó bi me ngarege mbɔ úlú detú. ");
INSERT INTO anvNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Muú fɔ ntó alú ayi alú ntɛ́sɛ́ wa, ne nkaá nnó unó bi ji agarege átóme ne me, úlú wáwálé. ");
INSERT INTO anvNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Ɛnyú detɔ́ nyá bɔɔ́ dentɔɔ́ mbaá Jɔn menwyaá bɔɔ́ manaá Ɛsɔwɔ, ne ji agaré ɛnyú wáwálé gefɔgé muú ayi me nlú. ");
INSERT INTO anvNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Me nkɛlege fɔ́ nnó bɔɔ́ ákaá gefɔgé muú ayi me nlu. Me njɔ́gé mbɔ ntome ne Jɔn, nkɛlege ɛlé nnó ɛnyú dewu nnó ɛ́kágé dekwe mpa Ɛsɔwɔ. ");
INSERT INTO anvNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Ji Jɔn abɔ́ alú ɛké ɛtulekaŋ ɛwé ɛ́lúlí ɛ́gɛ́nege. Ne mboó gébé fɔ́ ɛnyú debɔ désɛ́ geŋgbɔ́ jií ne nechɔ́chɔ́. ");
INSERT INTO anvNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Me nwya unó bi úlɛ́rege gefɔgé muú ayi me nlú, ɛbi uŋea upwɔ ɛbi Jɔn ágaré. Ɛlé wyɛ utɔɔ́ ubi, ɛbi Ntɛ wa afyɛɛ́ me né amu nnó nnéré, ubi ne mpyɛ́ɛ. Ne ubi ne úlɛ́rege nnó Ntɛ wa ne atɔmé me. ");
INSERT INTO anvNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Ne Ntɛ wa muú atɔmé me, agaré ntó gefɔgé muú ayi me nlú. Ɛnyú délú danwú meko wuú, ne yɛ gefɔgé muú ayi ji alú délú daŋgɛ́. ");
INSERT INTO anvNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Ne ɛnyú debelé fɔ́ mekomejɔɔ́ wuú né matɔɔ́ nyú wɔ́, néndé genó ɛyi gelɛrege mbɔ ɛlé metɔɔ́ ɛwé ɛnyú dela défyɛɛ́ fɔ ne muú ayi ji atɔmé wɔ́. ");
INSERT INTO anvNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Ɛnyú dechɛrege uno ɛbi ásame né muu ŋwɛ Ɛsɔwɔ ayi défɛré nnó ji ne apyɛ́ɛ ɛnyú débɔ́ geŋwá ɛyi gélágé byɛ́ ne mekomejɔɔ́ yimbɔ ajɔɔ́gé atome ɛlé ne me. ");
INSERT INTO anvNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Yɛ́mbɔ ɛnyú dékɛ́légé fɔ́ manchwɔ́ ɛta wa nnó débɔ́ geŋwá ɛyi gélágé byɛ́. ");
INSERT INTO anvNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Me nkɛ́légé fɔ́ nnó ákwaá áfɛɛ́ me. ");
INSERT INTO anvNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Yɛ́mbɔ ndɛre me nkaá ɛnyú, ɛnyú débɔɔ́ fɔ́ gejeé ne Ɛsɔwɔ wɔ́. ");
INSERT INTO anvNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Me nchwɔ́ né mabɔ Ntɛ wa, ɛnyú déshya mansɛ me. Yɛ́mbɔ muú yi chá achwɔ́ge né mabɔ amií jimbɔɔ́, ɛnyú désɛlé nyɛ ji. ");
INSERT INTO anvNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Ɛnyú dékɛ́lege nnó atɛ bɔɔ́ ne áfɛge ɛnyú dékɛ́lege fɔ́ nnó muú yi ji mbií ne alú Ɛsɔwɔ, afɛɛ́ ɛnyú. Ɛpyɛmbɔ nnó ne ɛnyú défyɛɛ́ matɔɔ́ ne me. ");
INSERT INTO anvNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","“Yɛ́mbɔ défɛrégé fɔ́ nnó me ne nkúu nyɛ ɛnyú mpa né mbɛ ushu Ntɛ wa, ɛlé Mosis ayi ɛnyú dénɛré matɔɔ́ ne ji ne akuú nyɛ ɛnyú mpa. ");
INSERT INTO anvNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Mbɔgé ɛnyú débɔ́ défyɛɛ́ matɔɔ́ ne Mosis wáwálé, mbɔ́ défyɛɛ́ ntó matɔɔ́ ne me, néndé unó bi ji asamé, útoó ne me. ");
INSERT INTO anvNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Tɛɛ́ ndɛre ɛnyú délá kamé nnó unó bi Mosis asamé úlú wáwálé wɔ́, ɛpyɛmbɔ nnó ne dekame nnó ɛbi me njɔ́gé úlú wáwálé?” ");
INSERT INTO anvNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Ɛ́bɛ́légé, Jisɔs achyaá géntoógé mewaá Galilií ɛyigé ákuú ntó nnó géntoógé Tibɛras. ");
INSERT INTO anvNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Ne gejamégé bɔɔ́ ákwɔ́lege ji gétúgé ágɛné gepɔgé ufélekpá ɛbi ji apyɛɛ́ bɔɔ́ mameé átoó. ");
INSERT INTO anvNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Jisɔs ne baá utɔɔ́ bií ákwɔ́ ájyɛ jwɔ́le né mfaá mekwɛ. ");
INSERT INTO anvNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Gébé ɛyigémbɔ, ɛpaá bɔɔ́ Jus ɛwé ákuú nnó ɛpaá koó upú, ɛ́la kwɔ́kwɔ́lé. ");
INSERT INTO anvNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Ne Jisɔs ábwɛ́gé amɛ agɛ́ ndɛre gejamégé bɔɔ́ áchwɔɔ́ ɛta wuú, ajɔɔ́ ne Filip aké, “Déname mbɔ brɛd ɛfɔ́ ayi akwánege bɔɔ́ bina manyɛ́?” ");
INSERT INTO anvNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Agií mbɔ manwú meko yi Filip ashúge nyɛ, néndé jimbɔɔ́ akaá mɛ́ genó ɛyigé ji abɔɔ́ mampyɛ. ");
INSERT INTO anvNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Filip ashuú ji meko aké, “Yɛ́ dékpá ɛlé ŋká ɛyi muú utɔɔ́ anyɛɛ́ né ámfaá aneé ne déna brɛd dékáré ukɛ́kɛ́ ukɛ́kɛ́ mbaá bɔɔ́ bina, akwánégé fɔ́ ɛbwɔ́ ako.” ");
INSERT INTO anvNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Ne maá utɔɔ́ Jisɔs ayifɔ ayi akúu ji nnó Andru meŋmo Simun Pita, aké, ");
INSERT INTO anvNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Njyɛ gesa fɔ, alú fana ayi awyaá ntó brɛd ɛta ɛyi ápyɛ ne bɛle ne meshuú ɛpea, yɛ́mbɔ ɛkwánege mbɔ bɔɔ́ bina nnó?” ");
INSERT INTO anvNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Ajɔɔ́gé mbɔ, Jisɔs aké, “Gáré yɛ́ndémuú ájwɔ́lé ka.” Melú ɛwémbɔ ɛjá dambyanja dɔɔ́, bɔɔ́ abi ájwɔlé wyɛ ande ɛbwɔ́ ɛbwɔ́ álú genógé dɛlé bɔɔ́ átáa. ");
INSERT INTO anvNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Ne Jisɔs asɛ́ ntóo brɛd ɛyímbɔ, achyɛ́ matamé mbaá Ɛsɔwɔ, akaré mbaá bɔɔ́ abi ajwɔlé ɛfɛɛ́. Wyɛmbɔ ntó ne apyɛ ne meshuú ɛyimbɔ ɛ́peá ne yɛ́ndémuú asɛ ndɛre ji akɛlege. ");
INSERT INTO anvNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Ányɛ́gé agbégé, Jisɔs agaré baá utɔɔ́ bií aké, “Nywerege ayi álaá ɛkágé délyaá yɛɛ́ genógefɔ́” ");
INSERT INTO anvNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Ne ányweré ayi álaá ágbeé usá úfyáneupeá yɛ́ ɛlé ntó brɛd ɛbɔ ɛlú ɛlé ɛta. ");
INSERT INTO anvNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Ne bɔɔ́ bina ágɛ́gé gepɔge ufélekpá bina, ɛbí Jisɔs apyɛ́mbɔ, áké, “Gɛ́ muú ɛkpávé Ɛsɔwɔ wáwálé na, ayi alú manchwɔ́ fa mme.” ");
INSERT INTO anvNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Jisɔs ákágé nnó bɔɔ́ bimbɔ ákɛ́lege mangbaré ji ne utó ápyɛ ji ábɛ́ mfwa, alyaá ɛbwɔ́ ama akwɔ́ afɛ́ tɛ mfaá mekwɛ jimbií. ");
INSERT INTO anvNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Nkwalé akwɔ́négé baá utɔɔ́ Jisɔs áshulé áfɛ́ né mbale géntoógé mewaá ɛyigémbɔ, ");
INSERT INTO anvNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","ákpɛ ɛ́kpe manchyaá ájyɛ́ né melɔ Kapanɔm. Gébé ɛyigémbɔ utuú ugi, ne Jisɔs abɔ́ alú danchwɔ́ báne ɛbwɔ́. ");
INSERT INTO anvNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Ndɛre ajyɛ́ɛ mbyo metometo ammyɛ apyɛ mgbannyi akwɔme. ");
INSERT INTO anvNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Ɛbwɔ́ ájyɛ́gé genógé ŋkpa nekɛ ɛni, áké ágɛ́ne nkane Jisɔs akɛ́ne mfaá mekɔ manaá achwɔ́ɔ kwɔ́kwɔ́lé ne ɛkpée, ábɔ́ ɛfɔ. ");
INSERT INTO anvNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Ne Jisɔs ajɔɔ́ ne ɛbwɔ́ aké, “Défɔgé, ɛlé me.” ");
INSERT INTO anvNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Ajɔ́ɔgé mbɔ matɔɔ́ ágɔ ɛbwɔ́ mansɛ ji akpɛ né mmu ɛkpée, áké ápɛ́le ɛ́kpe ɛtaré mɛ́ mbale mewaá né mbaá ayi ɛbwɔ́ ájyɛ́ɛ. ");
INSERT INTO anvNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Bií ujyage, gejamégé bɔɔ́ abɔ alu né ɛgbɛ́ géntoógé mewaá ɛwefɔ, ágɛ́ nnó ɛlé ɛ́kpe ɛma ne ɛbɔ́ ɛlú né mbale nnyi. Ápɛ ágɛ sé Jisɔs wɔ́, ne ate nnó ji abɔ́ akpɛɛ́ fɔ́ ɛ́kpe ɛwémbɔ ne baá utɔɔ́ bií wɔ́, baá utɔɔ́ bií ábɔ́ áfɛ́ ɛbwɔ́ ambií. ");
INSERT INTO anvNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Wyɛ né bií bimbɔ, makpe fɔ́ átané né melɔ Tibɛras achwɔ́ táré né mapea gentoge mewaa kwɔ́kwɔ́lé ne mbaá ayi Ata Jisɔs abɔ́ ajelé brɛd bɔɔ́ anyɛ́ɛ. ");
INSERT INTO anvNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Ápɛ́ Jisɔs ne baá utɔɔ́ bií né makpe yimbɔ ágɛ́ wɔ́. Akpɛ makpe yimbɔ áchyaá géntoógé mewaá ɛyigémbɔ áfɛ́ né melɔ Kapanɔm ákɛ́lege Jisɔs. ");
INSERT INTO anvNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Agɛ́gé ji, ágií ji aké, “Ménlɛré ndé gébé wɔ ɔchyaá géntoógé mewaá ɔchwɔɔ́ wé?” ");
INSERT INTO anvNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Jisɔs ashuú ɛbwɔ́ meko aké, “Me ngarégé ɛnyú wáwálé nnó dékɛ́légé fɔ́ me gétúge gepɔge ufélekpá ɛbi ɛnyú dégɛné. Dékɛ́lege ɛlé me gétúgé dényɛɛ́ brɛd dégbeé. ");
INSERT INTO anvNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Détulégé fɔ́ mmyɛ dékɛ́légé menyɛɛ́ ayi áchɔ́ge, mmyɛ́ge mmyɛ dékɛ́légé ɛlé menyɛɛ́ ayi achyɛgé geŋwá ɛyi gélágé byɛ́. Ji yimbɔ ne me Maá Ntɛ Mekwaá nchyɛgé nyɛ ɛnyú. Ntɛ wa Ɛsɔwɔ apyɛ ukpɛkpɛ uno fɔ ne alɛ́rege nnó ji achyɛɛ́ me utó bií, nnó nchyɛge bɔɔ́ geŋwá ɛyigembɔ.” ");
INSERT INTO anvNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Ne bɔɔ́ bimbɔ ágií ji áké, “Ɛsé dépyɛɛ́mbɔ nnó ne dépyɛ́ɛ utɔɔ́ Ɛsɔwɔ?” ");
INSERT INTO anvNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Jisɔs ashuú ɛbwɔ́ meko aké, “Utɔɔ Ɛsɔwɔ bimbɔ úlú nnó ɛnyú défyɛɛ́ metɔɔ́ ne muú ayi ji atɔmé.” ");
INSERT INTO anvNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Bɔɔ́ bimbɔ ama agií ji áké, “Ndé ufélekpá ɛbi wɔ ɔmáge pyɛ nnó ɛsé dégɛ́ ne dékámé ne genó ɛyigé wɔ ɔjɔɔ́ge? ");
INSERT INTO anvNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Ukwéne antɛ sé anyɛ́ nyá mana né mashwɔ́ne, wyɛ ndɛre asamé né mmu bɔ ŋwɛ Ɛsɔwɔ nnó, ‘Achyɛɛ́ ɛbwɔ́ brɛd ayi atané né mfaánebuú ányɛ́’.” ");
INSERT INTO anvNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Ne Jisɔs aké ne ɛbwɔ́, “Me ngarége ɛnyú wáwálé nnó ɛpɔ́fɔ́ Mosis ne achyɛɛ́ ɛnyú brɛd ayi átané mfaánebuú, ɛlé Ntɛ wa ne achyɛ́ge ushuú brɛd ayi mbɔɔ́ ayi atané né mfaánebuú. ");
INSERT INTO anvNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Brɛd ayi Ɛsɔwɔ achyɛge ɛlé muú ayi atané mfaánebuú ne achyɛgé bɔɔ́ geŋwá ɛyi gélá gébyɛɛ́.” ");
INSERT INTO anvNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Jisɔs ajɔɔ́ge mbɔ, bɔɔ́ bimbɔ áké, “Ata chyɛ́gé ɛsé brɛd yimbɔ yɛ́ndégébé.” ");
INSERT INTO anvNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Ne Jisɔs agaré yɛ́ ɛbwɔ́ aké, “Me ne nlú brɛd ayi achyɛ́ge geŋwá. Yɛ́ndémuú ayi achwɔ́ɔ ɛta wa mesa ammyɛ sé ji, ne muu ayi áfyɛɛ́ metɔɔ́ ne me mmwɔ́lé manaá nto ɛpyɛ sé ji. ");
INSERT INTO anvNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Ne ngare mɛ́ ɛnyú nnó ɛnyú dégɛ́ me yɛ́mbɔ défyɛɛ́ matɔɔ́ ne me wɔ́. ");
INSERT INTO anvNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Yɛ́ndémuú ayi Ntɛ wa achyɛ́ge me, achwɔ́ɔ nyɛ ɛta wa, ne yɛ́ndémuú ayi achwɔ́ɔ ɛta wa, me mbuú fɔ́ ji. ");
INSERT INTO anvNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Néndé me ntané fɔ́ mfaánebuú manchwɔ́ pyɛ ndɛre nkɛ́lege wɔ́, nchwɔ́lé mampyɛ ndɛre muú ayi atɔmé me akɛ́lege. ");
INSERT INTO anvNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Ne genó ɛyigé muú ayi atɔmé me akɛ́lege nnó, mpyɛ gélú nnó ɛkágé mpyɛ yɛɛ́ muú ama anó né geluágé bɔɔ́ ako abi ji achyɛɛ́ me. Mpyɛ ɛlé ɛbwɔ́ akwilé né negbo né bií bi kwyakwya. ");
INSERT INTO anvNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Néndé genó ɛyigé Ntɛ wa akɛ́lege gélú nnó, yɛ́ndémuú ayi agɛ́né me Maá wuú ne áfyɛɛ́ metɔɔ́ ne me, abɔ́ geŋwá ɛyi gélágé byɛ́. Ne me mpyɛ nyɛ ji akwilé né negbo né bií ɛbi kwyakwya.” ");
INSERT INTO anvNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Jisɔs ajɔɔ́gé mbɔ, bɔɔ́ bimbɔ álɔ maŋménégé gétúgé ji ajɔɔ́ aké, ‘Me nlú brɛd ayi atané mfaánebuú ashulé mme’. ");
INSERT INTO anvNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Áké pɔ́ nnó Jisɔs maá Josɛf na? Ɛsé dékage mma wuú ne ntɛ wuú. Ɛpyɛmbɔ nnó ne ji aké atané mfaánebuú ashulé mme? ");
INSERT INTO anvNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Ne Jisɔs ashuú yɛ́ ɛbwɔ́ meko aké, “Gɔ́gé maŋménégé ne atɛ, ");
INSERT INTO anvNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","yɛɛ́ muú ayi ákágé chwɔ́ ɛta wa ayi ntɛ wa muú atɔmé me álá aja ji áchwɔ wɔ́ apɔ́. Ne ayi achwɔ́ɔ ɛta wa, mpyɛ nyɛ ji akwilé né negbo né bií bi kwyakwya. ");
INSERT INTO anvNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Muú ɛkpávé Ɛsɔwɔ fɔ abɔ́ asá nnó, ‘Ɛsɔwɔ alɛ́rege nyɛ bɔɔ́ ako meti.’ Ɛwena ɛtɛne nno yɛ́ndémuú ayi awuú ne agií genó ɛyigé Ntɛ wa akɛ́lege, achwɔ́ɔ ɛta wa. ");
INSERT INTO anvNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Menjɔɔ́ mbɔ, ɛpɔ́fɔ́ nnó muú fɔ agɛ́ mɛ́ Ntɛ wa wɔ́, ɛkosé me muú ntané ɛta wuú ne ngɛ́ne ji. ");
INSERT INTO anvNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Ngaré ɛnyú wáwálé nnó yɛ́ndémuú ayi áfyɛɛ́ metɔɔ́ ne me abɔɔ́ geŋwá ɛyi gélá gébyɛɛ́. ");
INSERT INTO anvNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Me nlú brɛd ayi achyɛge geŋwá. ");
INSERT INTO anvNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Ukwéne antɛ nyú anyɛ́ nya mana né mashwɔ́ne, yɛ́mbɔ ágbó. ");
INSERT INTO anvNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Ne gɛ́ brɛd ayi atané mfaánebuú ashulé mme, ji ne alu gefɔɔ́ ɛyigé yɛ́ndémuú ayi anyɛ́ ji agboó fɔ́. ");
INSERT INTO anvNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Me nlú brɛd ayi achyɛgé geŋwá, ayi atané mfaánebuú ashulé mme. Yɛ́ndémuú ayi ányɛɛ́ brɛd yina abɛɛ́ ne geŋwá ɛyi gélágé byɛ́. Ne brɛd yina ɛlé menyammyɛ wa ayi nchyɛ́ge nyɛ mbaá bɔɔ́ mme mekó manwene geŋwáge bwɔ́.” ");
INSERT INTO anvNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Jisɔs ajɔɔ́gé mbɔ, bɔɔ́ Jus álɔ́ manyɛ́ mbeé metometo ne atɛ áké, “Mende yina achyɛge mbɔ ɛsé menyammyɛ wuú nnó dényɛ nnó?” ");
INSERT INTO anvNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Jisɔs ajɔɔ́ yɛ́ ne ɛbwɔ́ aké, “Ngarége ɛnyú wáwálé nnó, mbɔgé ɛnyú délá dényɛɛ́ menyammyɛ Maá Ntɛ Mekwaá ne dényúu manoó mií wɔ́, débɔ́ fɔ́ geŋwá. ");
INSERT INTO anvNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Ne yɛ́ndémuú ayi anyɛ́ɛ menyammyɛ wa ne anyúu manoó ma, abɔɔ́ geŋwá ɛyi gélágé byɛ́, ne mpyɛ nyɛ ji akwilé né negbo né bií bi kwyakwya. ");
INSERT INTO anvNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Néndé menyammyɛ wa alú menyɛɛ́ wáwálé ne manoó ma ntó málú genó ɛyigé ányú wáwálé. ");
INSERT INTO anvNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Yɛ́ndémuú ayi anyɛ́ɛ menyammyɛ wa ne anyú manoó ma, abɛɛ́ muú ama ne me, ne me ntó mbɛɛ muu ama ne ji. ");
INSERT INTO anvNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Ntɛ wa menchyɛ geŋwá atɔ́ me, Me ntó nwyaá geŋwá gétú jií. Mbɔntó ne yɛ́ndémuú ayi anyɛ́ɛ menyammyɛ wa abɔɔ́ geŋwá gétú ya. ");
INSERT INTO anvNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Gɛ́ brɛd ayi atané mfaánebuú ashulé mme na. Apɔ́fɔ́ ɛké mana ayi ukwéne antɛ nyú ányɛ́ nyá ne ábɛlégé ágboó. Yɛ́ndémuú ayi ányɛ́ɛ brɛd yina abɛɛ́ mebɛ tɛ kwyakwya.” ");
INSERT INTO anvNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Jisɔs ajɔɔ́ depɔ ɛtiré na né Kapanɔm, gébégé alɛ́rege bɔɔ́ unó né mmu ɛcha mmyɛmenɛne. ");
INSERT INTO anvNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Gejamégé aŋkwɔlé Jisɔs áwúgé genó ɛyigé ji alɛ́régé áké, “Genó ɛyigé mende yi alɛ́rege getoó. Yɛɛ́ muú ayi akámege gefɔgé genó ɛyigé na apɔ́.” ");
INSERT INTO anvNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Yɛ́mbɔ Jisɔs akágé né mmu metɔɔ́ wuú nnó aŋkwɔle bií áŋmɛ́nége gétúgé mechɔ́ ɛwé ji ajɔɔ́. Aké, ne bwɔ, “nnó mechɔ ɛwéna ɛpyɛ nnó ɛnyú deja mmyɛ meso? ");
INSERT INTO anvNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Ɛ́bɛgé mbɔ, ɛnyú defɛrege nyɛ nnó mbɔgé dégɛ́gé Me Maá Ntɛ Mekwaá ndɛre nkérége meso mbaá ayi ntané yɛ́? ");
INSERT INTO anvNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Ɛ́lé Mendoó ne ɛ́chyɛ́ge geŋwá. Menyammyɛ mekwaá apyɛ yɛ genó cháchá! Unó bi Me njɔɔ́ mbɔ ne ɛnyú, utané mbaá Mendoó ne ubi ne uchyɛge geŋwá ɛyi gélágé byɛ́. ");
INSERT INTO anvNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Yɛ́mbɔ, ɛnyú abifɔ défyɛɛ́ matɔɔ́ ne me wɔ́.” (Jisɔs akaá mɛ́ tɛ ula ulɔ́ bɔɔ́ abi álá fyɛ matɔɔ́ ne ji wɔ́, ne muú ayi achyɛge nyɛ ji maŋkwaá) ");
INSERT INTO anvNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Ne ajɔɔ́ ne ɛbwɔ́ aké, “Gɛ́ ula bí ngaré ɛnyú nnó, muú akágé chwɔ́ fɔ ɛta wa, mbɔgé Ntɛ wa álá lɛré ji meti wɔ́.” ");
INSERT INTO anvNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Ɛlɔ né gébé ɛyigé na, gejamégé aŋkwɔlé bií ája mmyɛ meso, ámágé kwɔ́le sé ji. ");
INSERT INTO anvNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Ne ɛpyɛ́gémbɔ, Jisɔs aké ne áŋbá bií áfyáneapeá, “Nnó ɛnyú ntó dékɛ́légé manlyaá me?” ");
INSERT INTO anvNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Simun Pita ashuú ji meko aké, “Ata, ɛsé demágé lya wɔ défɛ́ ɛfɔ? ɛle wɔ ne uwyaá mekomejɔɔ́ ayi achyɛ́ge geŋwá ɛyi gélágé byɛɛ́. ");
INSERT INTO anvNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Ɛsé défyɛɛ́ matɔɔ́ ne wɔ ne dékaá nnó wɔ ne ɔlu Muú Ukpea ayi Ɛsɔwɔ átɔmé.” ");
INSERT INTO anvNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Jisɔs ashuú ɛbwɔ́ meko aké, “Me ne njyá ɛnyú áfyáneapeá, yɛ́mbɔ muú nyú ama alú danchɔmeló.” ");
INSERT INTO anvNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Jisɔs ajɔɔ́ mbɔ ato lé ne Judas maá Simun Iscarot, yɛ́lé alú né geluágé abi áfyáneapeá, ji ne achyɛge nyɛ Jisɔs maŋkwaá. ");
INSERT INTO anvNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Jisɔs ánérégé manlɛ́ré unó bi, alɔ́ mankɛ́né né gebagé mewaá Galilií, ákɛ́légé fɔ́ manjyɛ né gebagé mewaá Judiya gétúgé ákpakpa bɔɔ́ Jus ákɛ́lege manwá ji. ");
INSERT INTO anvNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Gébé ɛyigémbɔ ɛpaá bɔɔ́ Jus ɛwé ákuú nnó ɛpaá baá otó ɛlá kwɔ́kwɔ́lé. ");
INSERT INTO anvNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Ne aŋmo Jisɔs abi ande áké, “Lyaá fa ɔjyɛ né gebagé mewaá Judiya ɔpyɛ ufélekpá aŋkwɔlé byɛ ágɛ́. ");
INSERT INTO anvNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Néndé muú aké akɛ́lege nnó bɔɔ́ ákaá gefɔgé muú ayi ji alú, apyɛɛ́ fɔ́ utɔɔ́ bií bíbí. Tɛ́ ndɛre ɔkágé pyɛ ufélekpá ɛbi, ɛ́lɔme nnó ɔpyɛ ubi mbaá ayi bɔɔ́ ako ágɛ́ne.” ");
INSERT INTO anvNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Aŋmo bií ájɔɔ́ge mbɔ yɛ ɛbwɔ́ ntó áfyɛɛ́ fɔ́ matɔɔ́ ne Jisɔs wɔ́. ");
INSERT INTO anvNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Jisɔs ashuú ɛbwɔ́ meko aké, “Ɛya gébé gélu daŋkwɔ́ne, né ɛgbɛ́ ɛwé nyú dékágé jyɛ yɛ́ndégébé. ");
INSERT INTO anvNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Bɔɔ́ mme akage paá fɔ́ ɛnyú, ápaá ɛlé me, néndé me ngarege gabo ayi ɛbwɔ́ ápyɛ́ɛ gbɔ́gɔ́nɔ́. ");
INSERT INTO anvNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Ɛnyú chóge ɛpaá ɛwéná me njyɛɛ́ fɔ́ nana néndé gébé ya gélú daŋkwɔ́ne.” ");
INSERT INTO anvNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Ajɔɔ́gé mbɔ ama abɛ́le mboó ndɔ né Galilií. ");
INSERT INTO anvNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Aŋmo Jisɔs ájyɛ́gé ji alá meso akwɔlé ɛbwɔ́ afɛ́ bíbí, ɛpɔ́fɔ́ gbɔ́gɔ́nɔ́. ");
INSERT INTO anvNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Ndɛre bɔɔ́ ányɛ́ɛ ɛpaá ɛwémbɔ, ákpakpa bɔɔ́ Jus álɔ mankɛlé Jisɔs, ágigé atɛ bɔɔ́ áké, “Mende yimbɔ alɛ́?” ");
INSERT INTO anvNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Bɔɔ́ abi áchwɔɔ́ ɛpaá ɛwémbɔ, áŋménege ákuú Jisɔs meno. Abifɔ áké, “Alú muú melɔ́mélɔ́,” abifɔ ntó áké, “Ŋgba” “achɔɔ́ bɔɔ́ makpo.” ");
INSERT INTO anvNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Yɛ́mbɔ yɛɛ́ muú ayi akuú Jisɔs meno gbɔ́gɔ́nɔ́ apɔ́ néndé áfɔ́ɔ ákpakpa bɔɔ́ Jus. ");
INSERT INTO anvNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Ányɛ́gé ɛpaá ɛkárégé mmyɛ, Jisɔs afɛ́ né mmu ɛcha upɛ Ɛsɔwɔ alɛ́rege meko mejɔɔ́ Ɛsɔwɔ. ");
INSERT INTO anvNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Ne ákpakpa bɔɔ́ Jus áwúgé ndɛre Jisɔs alɛ́rege, mano álá ɛbwɔ́ mekpo fuú ágígé atɛ áké, “Déŋgá ɛtire na détané mende yina ɛfɔ́, ayi yɛɛ́ ŋwɛ ji alá agi dɔɔ wɔ́?” ");
INSERT INTO anvNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Ájɔɔ́gé mbɔ, Jisɔs ashuú ɛbwɔ́ meko aké, “Unó bi me nlɛ́rege mbɔ utáné fɔ́ me né metɔɔ́ wɔ́ utané lé mbaá muú ayi atɔmé me. ");
INSERT INTO anvNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Muú ayi awyaá metɔɔ́ mampyɛ genó ɛyigé Ɛsɔwɔ akɛ́lege, ji ne akágé nyɛ mbaá yi unó bi me nlɛ́rege mbɔ utánege. Yɛɛ́ utanége lé mbaá Ɛsɔwɔ yɛɛ́ lé né metɔɔ́ wa, akáge nyɛ. ");
INSERT INTO anvNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Muú ayi ajɔɔ́ge unó bi utánege ji né metɔɔ́, akɛ́lege lé nnó ŋgɔ́ wuú akwɔ́. Yɛ́mbɔ muú ayi akɛ́lege nnó muú ayi atɔme ji akwɔ́ ŋgɔ́, ajɔge genó ɛyi gelu wáwálé, ábyɔ́gé fɔ́ gebyɔ́ cháchá. ");
INSERT INTO anvNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Mosis abɔ́ achyɛ́ ɛnyú mabɛ́, wá mbɔ fɔ́ wɔ́? Yɛ́mbɔ, yɛɛ́ muú nyú ama ayi abelé aji apɔ́. Ulannó ɛnyú demuame manwá me?” ");
INSERT INTO anvNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Jisɔs ajɔɔ́gé mbɔ, bɔɔ́ bimbɔ áshuú ji meko áké, “Melo nchyɛ achyɛgé wɔ ɛfwyale, ndé bɔɔ́ amuame manwá wɔ?” ");
INSERT INTO anvNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Ji ntó ashuú ɛbwɔ́ meko aké, “Me mpyɛ muú atoó bií uwyaá, ɛnyú délá mano mekpo fuú. ");
INSERT INTO anvNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Ɛle Mosis ne achyɛɛ́ ɛnyú ɛbɛ́ nnó desɔ́gé nsɔ́. Yɛ lé ɛla ɛlɔ fɔ́ ne ji wɔ́, ɛlɔ ne ukwéne antɛ nyu, ɛnyu desɔɔ baá nyu nsɔ né bií uwyaá. ");
INSERT INTO anvNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Ne mbɔgé bií ɛbi asɔ́ɔ maá nsɔ́ ukwegé bií uwyaá, ɛnyú desɔ́ɔ ji nsɔ́ nnó ɛkágé dékwé ɛbɛ́ Mosis, ulánnó ɛnyú désɔ́ɔ matɔɔ́ ne me gétúgé me mpyɛ menyammyɛ muú meko atoó né bií uwyaá? ");
INSERT INTO anvNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Muú apyɛgé genó ɛ́kágé débɔ́ mbɛ déjɔɔ́ nnó ji apyɛ gabo ndɛre bɔɔ́ ako ágɛne, ayi délá débɔ́ɔ mbɛ dékaá ulá wɔ́. Chɛrége dékaá né meti ɛwé ɛlú cho ne desɔ mpa wuu.” ");
INSERT INTO anvNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Ndɛre Jisɔs alɛ́rege bɔɔ́ Jɛrosalɛ, abifɔ álɔ mangigé atɛ áké, “Pɔ́ mende yi ákɛ́lege na ji manwá na? ");
INSERT INTO anvNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Pɛ ndɛre ji ajɔɔ́gé mejɔɔ́ né mbɛ ushu bɔɔ́ ako ne yɛɛ́ muú ayi apɛ́gé meko apɔ́, nnó ákpakpa sé ágɛ́ nnó ji ne alú Muú yi Ɛsɔwɔ akweré ji ɛlá gefwa waá? ");
INSERT INTO anvNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Ndɔfɔ ji fɔ́ wɔ́ néndé Muú yi Ɛsɔwɔ akweré ji ɛlá gefwa aké achwɔ́ɔ muú akágé fɔ mbaá ayi ji atánégé yɛ́mbɔ ɛsé dékaá mbaá yi mende yina atané.” ");
INSERT INTO anvNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Ndɛre Jisɔs alú lɛ́rege né mmu ɛcha upɛ Ɛsɔwɔ, abwɛɛ́ meko mfaá aké “Ɛlú wáwálé nnó ɛnyú dékaá me ne dékaá ntó mbaá yi me ntané yɛ́mbɔ me nchwɔ́ fɔ́ fa né utó ba wɔ́, nchwɔ́lé gétúgé muú ayi atɔmé me. Ɛlu wawale nno ji ne atɔmé me ne ɛnyú dékágé fɔ́ ji. ");
INSERT INTO anvNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Me nkágé ji néndé me ntané lé ɛta wuú. Ji ne atɔmé me nnó nchwɔ́.” ");
INSERT INTO anvNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Ajɔɔ́gé mbɔ, bɔɔ́ bimbɔ ákwilé nnó ápyɛ́ ji yɛ́mbɔ yɛɛ́ muú ayi ataá ji ɛbwɔ mmyɛ apɔ́, ɛlé gébé ɛjií gélá gelú daŋkwɔ́ne. ");
INSERT INTO anvNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Yɛ́mbɔ né geluáge bɔɔ́ bimbɔ gejame abi áfyɛɛ́ metɔɔ́ ne ji ájɔɔ́gé áké, “Muú yi Ɛsɔwɔ akweré ji ɛlá gefwa achwɔ́gé nnó amáge pyɛ gepɔge ufelekpa upwɔɔ́ ɛbi mende yina apyɛ́ɛ?” ");
INSERT INTO anvNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Bɔɔ́ ɛkwɔ́ Farasi abi alú ɛfɛɛ́ áwúgé ndɛre bɔɔ́ aŋménege gétúgé Jisɔs, ácho ula ne anɔɔ́ baá ampyɛɛ́ upɛ Ɛsɔwɔ, átɔ́ ámbamé ɛcha upɛ Ɛsɔwɔ nnó ajyɛ apyɛ́ Jisɔs. ");
INSERT INTO anvNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Ne Jisɔs ajɔɔ aké, “Me mbɛlege sé ne ɛnyú dɔɔ́, ɛla gachyɛɛ́ me nkerege meso mbaá muú ayi atɔmé me. ");
INSERT INTO anvNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Ɛnyú dékɛ́lege nyɛ me, yɛ́mbɔ degɛ́ne fɔ́ me. Mbaá ayi me mbɛ́ɛ ɛnyú dékágé chwɔ́ fɔ́ wyɛ.” ");
INSERT INTO anvNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Ajɔɔ́gé mbɔ, ákpakpa bɔɔ́ Jus álɔ mangígé atɛ áké, “Ndé mbaá yi mende yina afɛré nnó ji ajyɛ, ayi yɛɛ́ dékɛ́lé ji délá dégɛ́né? Nnó ajyɛ jwɔ́le nyɛ ɛlé né gebagé mewaá Greek ne malɔ ayi bɔɔ́ sé ájwɔ́lege, alɛrege bɔɔ́ Grek mekomejɔɔ́ Ɛsɔwɔ?” ");
INSERT INTO anvNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Ajɔɔ́ mbɔ, aké, “Ɛnyú dékɛ́lege nyɛ me dégɛ́né, ne mbaá yi me mbɛ́ɛ, ɛnyú dékágé chwɔ́ fɔ́ wyɛ. Ula utɛne mbɔ nnó?” ");
INSERT INTO anvNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Kwyakwya bií bi ányɛɛ́ ɛpaá ɛwémbɔ, úlú gekpɛkpɛge bií. Né bií bimbɔ Jisɔs akwilé ka ajɔɔ́ keŋke aké, “Yɛ́ndémuú ayi mmwɔ́lé manaá ɛpyɛɛ́ ji achwɔ́ anyú ɛta wa. ");
INSERT INTO anvNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Muú afyɛgé metɔɔ́ ne me, genó ɛyi gepyɛ ne ji gebɛɛ́ wyɛ ndɛre ásamé né mmu ŋwɛ Ɛsɔwɔ nnó, ‘Genó ɛyi gétánege ji tɛ metɔɔ́ gebɛ́ɛ ɛké nnyi ɛniné néwya manaá ami machyɛgé geŋwá.’” ");
INSERT INTO anvNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Manaá ami machyɛgé geŋwá ami Jisɔs ajɔɔ́ mbɔ matɛné mbaá Mendoó Ukpea ɛwé bɔɔ́ abi áfyɛɛ́ matɔɔ́ ne Jisɔs ábɔɔ́ nyɛ. Né gébé ɛyigémbɔ, Ɛsɔwɔ abɔ́ alú danchyɛɛ́ ɛbwɔ́ Mendoó Ukpea, néndé Jisɔs abɔ́ alú dangbó akéré meso mfaánebuú mbaá ayi Ɛsɔwɔ achyɛgé ji ɛnógé. ");
INSERT INTO anvNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Bɔɔ́ bimbɔ áwuúgé genó ɛyigé Jisɔs ajɔɔ́, abifɔ áké, “Ɛlú wáwálé nnó mende yina alú muú ɛkpavé Ɛsɔwɔ ayi débɔ́ dégilé.” ");
INSERT INTO anvNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Abifɔ áké, “Alú Muú yi Ɛsɔwɔ akweré ji ɛlá gefwa.” Yɛ́mbɔ abifɔ aké, “Ɛpyɛmbɔ nnó ne Muú yi Ɛsɔwɔ akweré ji ɛlá gefwa átanégé né Galilií. ");
INSERT INTO anvNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Pɔ́ ŋwɛ Ɛsɔwɔ aké na, Muú yi Ɛsɔwɔ akweré ji ɛlá gefwa abɛɛ́ mpyáne mfwa Dɛvid ne ábyɛ́ne ji né Bɛtɛlɛhɛm, melɔ ɛwé mfwa Dɛvid atané wyɛ?” ");
INSERT INTO anvNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Ndɛre ɛlúmbɔ, bɔɔ́ abifɔ ájɔɔ́gé ágáme Jisɔs, abifɔ ágáme fɔ́. ");
INSERT INTO anvNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Bɔɔ́ abifɔ ábɔ́ álú mampyɛ́ ji, yɛ́mbɔ yɛ́ muú ayi ataá ji ɛbwɔ mmyɛ apɔ́. ");
INSERT INTO anvNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Ambamé ɛcha upɛ Ɛsɔwɔ abi ábɔ́ átɔmé ɛbwɔ́ nnó ájyɛ apyɛ́ Jisɔs, ákeré meso amuamu mbaá anɔɔ́ baá ampyɛ upɛ Ɛsɔwɔ ne ɛkwɔ́ bɔɔ́ Farasi. Áchwɔ́gé ákpakpa bimbɔ ágií ɛbwɔ́ áké, “Ulannó ɛnyú délá chwɔ́ ne ji wɔ́?” ");
INSERT INTO anvNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Ambamé bimbɔ áshuú ɛbwɔ́ meko áké, “Ɛsé délú danwú muú fɔ ajɔɔ́ gefɔgé depɔ ɛtiré mende yimbɔ ajɔɔ́gé.” ");
INSERT INTO anvNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Ɛkwɔ́ bɔɔ́ Farasi áshuú ɛbwɔ́ meko áké, “Nnó abwɔlé ɛnyú ntó?” ");
INSERT INTO anvNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Ɛbwɔ́ ama gíi áké, “Nnó ɛnyú dékaá yɛɛ́ muú sé ama né geluágé ákpakpa, yɛ́ ɛbɛ́lé muú ɛkwɔ́ Farasi ayi áfyɛɛ́ metɔɔ́ ne ji? ");
INSERT INTO anvNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Ngba! Ɛkosé bɔɔ́ abi álá kaágé mabɛ sé ne áfyɛɛ́ metɔɔ́ ne ji. Ne ɛbwɔ bimbɔ alu bɔɔ́ abo né mbɛ ushu Ɛsɔwɔ.” ");
INSERT INTO anvNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Muú Farasi fɔ ayi ɛbwɔ́ ákuú ji Nikodɛmus muú yi abɔ́ ájyɛ mbaá Jisɔs, abɔɔ́ alu ntó né geluage bwɔ́. Agií ɛbwɔ́ aké, ");
INSERT INTO anvNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Nnó ɛbɛ́ sé ɛgbarege muú nnó alú gyɛɛ́ ayi bɔɔ́ álá lu danwú mpa wuú akaá mechɔ ɛwe ji apyɛ?” ");
INSERT INTO anvNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Ákpakpa bimbɔ áshuú ji meko áké, “Ɛlú ɛké wɔ ntó ɔlu muú Galilií. Chó gií né mmu ŋwɛ Ɛsɔwɔ ne ɔkaá nnó muú ɛkpavé Ɛsɔwɔ atanégé fɔ né Galilií.” ");
INSERT INTO anvNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Ájɔɔ́gé mbɔ, yɛ́ndémuú atyaá akeré meso né gepú jií. ");
INSERT INTO anvNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Jisɔs akwɔ́ afɛ ji né Mekwɛ Olif. ");
INSERT INTO anvNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Ne bií ujyágé ji ama kéré meso né dachi ɛcha upɛ Ɛsɔwɔ. Gejamégé bɔɔ́ áchwɔ́ anɔ ji mme ne ajwɔlé ka alɔ́ manlɛ́régé ɛbwɔ́. ");
INSERT INTO anvNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Ndɛre ji ajɔɔ́gé, anlɛ́ré mabɛ́ Ɛsɔwɔ ne ɛkwɔ́ bɔɔ́ Farasi áchwɔ́ ne mendée ayi akwené ulɔ. Áchoó ji né mbɛ ushuú bɔɔ́ ako abi álú ɛfɛɛ́. ");
INSERT INTO anvNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Áké ne Jisɔs, “Ménlɛré, ɛsé dépyɛ mendée yina nkane akwéne ulɔ. ");
INSERT INTO anvNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Ásá né mmu ŋwɛ mabɛ́ Mosis nnó ábɔ́ manwá gefɔgé mendée yina ne mataá. Ne wɔ ɔjɔɔ́ nnó?” ");
INSERT INTO anvNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Nkwɛ́ yi ɛbwɔ́ agií mbɔ ɛlé metaá né ɛbwɔ́ ápɛné nnó Jisɔs akwegé, ɛbwɔ́ ágɛ́ meti manjɔɔ́ nnó apyɛ gyɛɛ́. Yɛ́mbɔ Jisɔs abyɛlé mme asamé genó gefɔ́ ne ɛnɔɔ́ ɛbwɔ wuú. ");
INSERT INTO anvNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Ndɛre ɛbwɔ́ álú ágigé wyɛ ji gigé, Jisɔs anyaá mmyɛ mfaá aké ne ɛbwɔ́, “Mbɔgé muú nyú fɔ alú dampyɛ gabo, abɔ́ mbɛ abɔ́ ntaá ató ji.” ");
INSERT INTO anvNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Ajɔɔ́gé mbɔ, ama byɛ́le mme asamé genó ne ɛnɔɔ́ ɛbwɔ wuú. ");
INSERT INTO anvNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Bɔɔ́ abi achwɔɔ́ ne mendée yimbɔ, áwuúgé nkane Jisɔs ajɔɔ́, alɔ manjyɛ ama ama. Bɔɔ́ kpakpa ne ábɔɔ́ mbɛ alɔɔ́ manjyɛ. Afɛ́ kpá ályá mendée yimbɔ tɛ́né né mbɛ ushuú Jisɔs. ");
INSERT INTO anvNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Jisɔs anyaá mmyɛ mfaá aké ne mendée yimbɔ, “Bɔɔ́ bimbɔ alɛ́? Nnó yɛɛ́ muú fɔ ajɔɔ́ nnó wɔ nkwe mpa wɔ́?” ");
INSERT INTO anvNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Mendée yimbɔ ashuú ji meko aké, “Ata yɛɛ́ muú ajɔɔ́ wɔ́.” Ajɔɔ́gé mbɔ, Jisɔs ajɔɔ́ yɛ́ aké, “Yɛ́ me ntó mpyɛɛ́ wɔ genó, chó, ɔpyɛgé sé gabo.” ");
INSERT INTO anvNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Ɛwyágé Jisɔs ama jɔɔ́ ne ɛkwɔ bɔɔ bimbɔ aké, “Me nlú geŋbɔ́ mbaá bɔɔ́ mme, muú yi akwɔ́lege me, akɛ́né fɔ́ né gemua, agɛ́ne nyɛ lé geŋgbɔ́ ɛyi gechyɛge geŋwá.” ");
INSERT INTO anvNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Ne ɛkwɔ́ bɔɔ́ Farasi áké ne ji, “Gɛ́ yɛ́ nkane ɔtɛné ntɛ́sɛ́ né gemɛ jyɛ, ɛbyɛnnó depɔ ɛtiré wɔ ɔgárege mbɔ delu detu.” ");
INSERT INTO anvNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Jisɔs ashuú ɛbwɔ́ meko aké, “Yɛ́ me ntɛ́né lé ntɛ́sé né gemɛ ya, depɔ ɛtiré me ngarege mbɔ dépɔ́ fɔ́ detu, néndé me nkaáge mbaá ayi ntané ne mbaá ayi njyɛ́ɛ. Yɛ́mbɔ ɛnyú dékaágé fɔ mbaá ayi ntané, yɛ́ mbaá ayi njyɛɛ́ dékaágé. ");
INSERT INTO anvNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Ɛnyú dechɛrege depɔ ndɛre akwaá áchɛ́rege, me nchɛ́régé yɛɛ́ mechɔ́ muú fɔ. ");
INSERT INTO anvNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Ne yɛɛ́ ɛbɛ́lé nnó nchɛrégé, uchɛ́chɛ́re ba úlú cho néndé nchɛ́régé fɔ́ me mbií, Ntɛ wa muú atɔmé me alú ne me. ");
INSERT INTO anvNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Ásá né mmu mabɛ́ nyú nnó bɔ ntɛ́sé apeá ájɔɔ́gé genó gema, ɛbyɛ́nnó mechɔ́ ɛwémbɔ ɛpɔ fɔ detú. ");
INSERT INTO anvNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Me ntɛné ntɛ́sé né gemɛ ya, ne Ntɛ wa muú atɔmé me alú ntó ntɛ́sé wa.” ");
INSERT INTO anvNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Ajɔɔ́gé mbɔ, ɛbwɔ́ ágií yɛ́ ji aké, “Ntɛ wyɛ alú ɛfɔ́?” Jisɔs ashuú ɛbwɔ́ meko aké, “Ɛsé ne ntɛ wa yɛɛ́ muú ayi ɛnyú dékágé ápɔ́. Mbɔgé ɛnyú debɔ dékaá me, mbɔ dékaá ntó Ntɛ wa.” ");
INSERT INTO anvNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Jisɔs abɔ́ ajɔɔ́gé depɔ ɛtiré na gébégé ji álɛ́rege bɔɔ́ né dachi ɛcha upɛ Ɛsɔwɔ kwɔ́kwɔ́lé ne mbaá ayi ábélege makwa ayi áfyɛ́ɛ ŋka Ɛsɔwɔ wyɛ. Yɛ́mbɔ yɛɛ́ muú ayi apyɛné ji apɔ́ néndé gébé jií gélú dankwɔ́né. ");
INSERT INTO anvNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Ɛwyágé Jisɔs ama jɔɔ́ ne ɛkwɔ́ bɔɔ́ bimbɔ aké, “Me njyɛ nyɛ mbaá fɔ, ɛnyú dékɛlégé nyɛ me dégɛ́né, ne dégbóo nyɛ né mmu gabo ɛnyú. Ne mbaá ayi me njyɛ́ɛ ɛnyú dékaágé chwɔ́ fɔ́ wyɛ.” ");
INSERT INTO anvNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Ákpakpa bɔɔ́ Jus áwuúgé mbɔ ágií atɛ áké, “Nnó ájyɛ wá nyɛ gemɛ jií waá? Mbɔgé mbɔ fɔ́ wɔ́, ula bi ji ajɔɔ́gé nnó ‘mbaá ayi ji ajyɛ nyɛ ɛsé dékaágé jyɛ́ɛ wyɛ utɛné nnó?’” ");
INSERT INTO anvNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Jisɔs ashuú ɛbwɔ́ meko aké, “Ɛnyú détané fa mme yina, me ntané mfaánebuú, ɛnyú délú bɔɔ́ mme, me mpɔ́ fɔ́ muú mme. ");
INSERT INTO anvNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Gɛ́ ula bi mbɔ́ njɔɔ́ ne ɛnyú nnó, dégbóo nyɛ né mmu gabo nyú. Ne mbɔgé ɛnyú délá kamé nnó, ‘Me Nlú Muu ayi Me Nké Nlú wɔ́, dégbóo nyɛ né mmu gabo nyú wáwálé.’” ");
INSERT INTO anvNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Ɛbwɔ́ ágií yɛɛ́ ji áké, “Wɔ ɔlú waá?” Jisɔs ashuú ɛbwɔ́ meko aké, “Me nlú muú yi mbɔ́ ngárege mɛ́ ɛnyú tɛ gachií nnó nlú. ");
INSERT INTO anvNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Nwya gejamégé unó bi njɔɔ́gé ulɛ́rege nnó ɛnyú dékwé mpa. Yɛ́mbɔ muú ayi atɔmé me ajɔɔ́gé wáwálé ne genó ɛyigé nwúgé ɛta wuú géji ne ngárege bɔɔ́ mme.” ");
INSERT INTO anvNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Ndɛre Jisɔs abɔ ajɔge mbɔ ɛbwɔ́ ábɔ́ akaá fɔ́ nnó ajɔɔ́gé mbɔ atome lé ne Ntɛ wuú wɔ́. ");
INSERT INTO anvNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Ne Jisɔs ajɔɔ́ yɛ́ ne ɛbwɔ́ aké, “Gébégé abwɛge nyɛ me Maá Ntɛ Mekwaá né mfaa, gébé ɛyigémbɔ ne dékáage nyɛ nnó, ‘Me Nlú Muú ayi Me Nké Nlú’ ne dékaáge nyɛ ntó nnó me njɔge fɔ́ genó gefɔ́ né ushu ushu ba, mpyɛ lé ɛyigé Ntɛ wa alɛré me nnó mpyɛ. ");
INSERT INTO anvNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Ne ji muú atɔmé me alú ne me, alyaá fɔ́ me mbií wɔ́ néndé mpyɛ unó bi ujigé ji metɔɔ́.” ");
INSERT INTO anvNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Ne gejámé bɔɔ́ abi áwuú ndɛre Jisɔs ajɔɔ́gé unó bina ákamé nnó úlú wáwálé. ");
INSERT INTO anvNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Jisɔs ajɔɔ́ ne bɔɔ́ Jus abi ákamé ne ji aké, “Dégbarégé amu né unó bi nlɛrege ɛnyú, débɛ aŋkwɔlé ba wáwálé. ");
INSERT INTO anvNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Ne dékáage nyɛ wáwálé ne wáwálé, yimbɔ apyɛ nyɛ ɛnyú dela mmyɛmmyɛ nyu.” ");
INSERT INTO anvNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Ɛbwɔ́ ashuú ji meko áké, “Ɛsé délú upyáne Abraham ne délú dambɛ́ afwɛ́ ɛta muú fɔ, ulannó wɔ ɔké ɛsé détanege nyɛ né ɛfwyale.” ");
INSERT INTO anvNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Jisɔs ashuú ɛbwɔ́ meko aké, “Me ngarege ɛnyú wáwálé nnó, yɛ́ndémuú ayi apyɛ́ɛ gabo, abwɔlé mefwɛ́ gabo. ");
INSERT INTO anvNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Ne mefwɛ́ alaá fɔ́ né ula gepú ɛyigé ji akpane défwɛ́ wyɛ tɛ kwyakwya ɛlé maá mbɔɔ́ gepú ne ala. ");
INSERT INTO anvNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Nkane ɛlúmbɔ, mbɔgé Maá apyɛge wɔ ɔlage mmyɛmmyɛ jyɛɛ, ɛbyɛ́nnó ɔla mmyɛmmyɛ jyɛ wawale. ");
INSERT INTO anvNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Me nkaá nnó ɛnyú délú upyáne Abraham. Yɛ́mbɔ dékɛlégé manwá me néndé ɛnyú debɔɔ́ fɔ gébé ne mekomejɔɔ́ wa chacha wɔ́. ");
INSERT INTO anvNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Me ngarege ɛnyú genó ɛyigé me ngɛné mbaá Ntɛ wa, ɛnyú dépyɛ́ɛ lé genó ɛyigé ntɛ nyú agaré ɛnyú.” ");
INSERT INTO anvNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Bɔɔ́ Jus bimbɔ ashuú ji meko áké, “Abraham alú gekwéne ntɛ sé.” Ájɔɔ́gé mbɔ Jisɔs aké ne ɛbwɔ́, “Mbɔgé ɛnyú débɔ́ débɛ́ upyáne Abraham wáwálé, mbɔ́ dépyɛ́ɛ unó bi ji abɔ́ apyɛɛ́. ");
INSERT INTO anvNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Yɛ́mbɔ ɛnyú dékɛlege manwá me ayi ngárege ɛnyú mekomejɔɔ́ ayi wáwálé, ayi nwuú ne Ɛsɔwɔ. Abraham abɔ́ apyɛɛ́ fɔ́ mbɔ wɔ́. ");
INSERT INTO anvNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Ɛnyú depyɛ́ɛ genó ɛyigé ntɛ nyú apyɛ́ɛ.” Ɛbwɔ́ áké ne ji, “Ɛsé depɔ́ fɔ́ baá ulɔ, Ɛsɔwɔ ne alú Ntɛ sé wáwálé.” ");
INSERT INTO anvNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Ájɔɔ́gé mbɔ, Jisɔs aké ne ɛbwɔ́, “Mbɔgé Ɛsɔwɔ abɔ́ ábɛ́ Ntɛ nyú wáwálé, mbɔ́ dégbóo ne me néndé ntané ɛta wuú ne nchwɔ́ fa. Nchwɔɔ́ fɔ́ fa né ushu ushu ba wɔ́, ji ne atɔmé me. ");
INSERT INTO anvNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Ɛpyɛnnó ne ɛnyú delá kaágé genó ɛyigé me njɔɔ́gé? Ndɔfɔ ɛlé délá kɛ́légé manwú genó ɛyigé me njɔɔ́ge. ");
INSERT INTO anvNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Ntɛ nyú ɛlé danchomeló, ɛnyú dékɛlege lé mampyɛ́gé unó bi ujigé ji metɔɔ́. Tɛ ula ulɔɔ́ geŋwá jií, ji alú lé muú ayi awáne bɔɔ́, ne akií fɔ genó ɛyi gélú wáwálé, néndé jimbɔɔ́ ajɔɔ́gé fɔ́ wáwálé. Áke abyɔge gebyɔ akwɔlege lé gepɔ jií, néndé gebyɔ geko gelɔ ne ji. ");
INSERT INTO anvNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Ɛlé me ngarege genó ɛyi gélú wáwálé, ɛnyú dekámégé fɔ́ ne genó ɛyigé me njɔɔ́gé. ");
INSERT INTO anvNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Nnó muu nyu fɔ akage gare yɛ gabo ayi me mpyɛɛ? Ne mbɔgé me ngarege ɛnyú genó ɛyi gélu wáwálé, ulannó ɛnyu déla dékámégé ne me? ");
INSERT INTO anvNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Yɛ́ndémuú ayi alu muu Ɛsɔwɔ, awúu genó ɛyigé Ɛsɔwɔ ajɔɔ́gé. Ɛlú wáwálé nnó ɛnyú depɔ́ fɔ́ baá Ɛsɔwɔ, gɛ́ ula bi ɛnyú délá wuú fɔ́ me mbɔ.” ");
INSERT INTO anvNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Ajɔɔ́gé mbɔ, ákpakpa bɔɔ́ Jus áshuú ji meko áké, “Ɛsé depɔ́ fɔ́ gyɛ manjɔɔ́ nnó wɔ ɔlu muú Samariya ne melo nchyɛ achyɛge wɔ ɛfwyale.” ");
INSERT INTO anvNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Ne Jisɔs ashuú ɛbwɔ́ meko aké, “Meló nchyɛ achyɛge fɔ́ me ɛfwyale. Me nnogé Ntɛ wa yɛ́mbɔ ɛnyú dénógé fɔ́ me. ");
INSERT INTO anvNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Me mpyɛɛ́ fɔ́ unó nnó bɔɔ́ áfɛɛ́gé me, yɛ́mbɔ muú alú wyɛ ayi afɛ́ge me. Ji ne alú muú ayi asɔ́ɔ mpa bɔɔ́. ");
INSERT INTO anvNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Ne me ngarege ɛnyú wáwálé nnó muú ayi ábélege mekomejɔɔ́ ayi me nlɛrege agboó fɔ́ chacha.” ");
INSERT INTO anvNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Ajɔɔ́gé mbɔ bɔɔ́ Jus áké, “Nana ɛsé dékaá nnó ɔmée gebwɔ́ wáwálé. Abraham agbó wyɛ ndɛre bɔɔ́ ɛkpávé Ɛsɔwɔ abifɔ agbóo, wɔ ɔké mbɔgé muú abelégé unó bi wɔ ɔlɛ́rege agboó fɔɔ́? ");
INSERT INTO anvNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Nnó wɔ ɔŋeá gemɛ ɔpwɔ ntɛsé Abraham ayi agbóo wa nnó? Bɔɔ́ ɛkpávé Ɛsɔwɔ ntó agbóo, wɔ ɔfɛré nnó ɔlú waá?” ");
INSERT INTO anvNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Ne Jisɔs ashuú ntó ɛbwɔ́ meko aké, “Mbɔgé me nfɛ́ɛgé gemɛ ɛyá, ufɛfɛ́ɛ ɛbimbɔ unó mme detú. Muú ayi afɛ́ɛge me ɛlé Ntɛ wa muú ɛnyú désɛlé nnó alú Ɛsɔwɔ nyú. ");
INSERT INTO anvNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Yɛ́ ɛlé ɛnyú délá dékaá yɛɛ́ ji kaŋka wɔ́. Me nkáge ji. Mbɔgé me njɔ́gé nnó nkaágé fɔ́ ji, ɛbyɛnnó me nlú muú gebyɔ nkane ɛnyú. Me nkaá ji wáwálé, ne nwúu ne ji. ");
INSERT INTO anvNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Ntɛ nyú Abraham abɔɔ́ mɛ́ mbɛ akaá nnó, me nchwɔ́ɔ nyɛ ne metɔɔ ɛgɔ ji. Agɛge mbɔ metɔɔ́ ɛgɔ ji dɔɔ́.” ");
INSERT INTO anvNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Ne bɔɔ́ Jus áshuú meko áké, “Ɔlú dankwɔ́ne yɛ́ usaá aŋmɛ upeá meso ɛfya, ɔpyɛmbɔ nnó ne ɔkaá Abraham.” ");
INSERT INTO anvNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Ne Jisɔs aké, “Me ngarege ɛnyú wáwálé nnó, gemɛ́gé nnó ábyɛ́ Abraham, me nlú.” ");
INSERT INTO anvNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Ajɔɔ́gé mbɔ, ɛbwɔ́ abɔ́ mataá nnó ató ji, yɛ́mbɔ Jisɔs abií atané né mmu ɛcha upɛ Ɛsɔwɔ. ");
INSERT INTO anvNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Ndɛre Jisɔs akɛ́ne ajyɛɛ́, agɛ́ mende fɔ ayi ábyɛné ji amɛ nónómé. ");
INSERT INTO anvNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Ne baá utɔɔ́ bií agií ji aké, “Ménlɛré, gabo ayi ndé muú apyɛɛ́ ábyɛné mende yina amɛ nónómé? Awuú jimbɔɔ́? Waá ayi mma wuú ne ntɛ wuú.” ");
INSERT INTO anvNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Jisɔs ashuú ɛbwɔ́ meko aké, “Amɛ anómé fɔ́ mende yina gétúgé gabo ayi ji apyɛɛ́ wɔ́. Ne ɛ́pɔ́fɔ́ ntó gétúgé gabo ayi mma wuú ne ntɛ wuú ápyɛɛ́. Ábyɛ́ mende yina amɛ nónómé nnó Ɛsɔwɔ alɛ́ré ndɛre utó bi upyɛ́ɛ utɔɔ́ né menyammyɛ wuú. ");
INSERT INTO anvNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Debɔ mampyɛ utɔɔ́ Átá muú atɔmé me ndɛre bií úlú gbɔɔ́, néndé utuú ugigé yɛ muu akage pyɛ se ubi. ");
INSERT INTO anvNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Tɛ ndɛre me nlú fa mme yina, me nlú geŋgbɔ́ mbaá bɔɔ́ mme.” ");
INSERT INTO anvNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Ajɔɔ́gé mbɔ akpó matyɛ mme, apyɛ gentwɔtwɔ awaá mende yimbɔ né amɛ ");
INSERT INTO anvNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","ajɔɔ́ ne ji aké, “Chó shwɔ́né ushu byɛ né gentoógé manaá ɛyigé ákuú nnó Silɔm” (Ula Silɔm utɛné nnó átɔ). Ne mende yimbɔ afɛ́, ashwɔné ushu bií, aké achwɔɔ́, alɔ́ mangɛ́né mbaá. ");
INSERT INTO anvNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Ɛpyɛ́gémbɔ, bɔɔ́ abi ájwɔ́lege dachi ama ne ji, ne abi abɔ́ ágɛ́ne mɛ́ ji ndɛre akɔɔ́ dekɔ, ágɛ́gé ji, áké, “Pɔ́ mende ayi ajwɔ́lege na akɔɔ́ dekɔ yɛ́ndégébé na?” ");
INSERT INTO anvNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Abifɔ áké, “Ɛlé ji,” abifɔ ntó áké, “Ŋgba muú yimbɔ afú ɛlé fulé.” Ne mende yimbɔ ajɔɔ́gé wyɛ aké, “Ɛlé me mbɔɔ́.” ");
INSERT INTO anvNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Ajɔɔ́gé mbɔ, bɔɔ́ bimbɔ agií ji áké, “Ɛkɛ nnó ne wɔ ɔlɔ́ɔ mangɛ́?” ");
INSERT INTO anvNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Ashuú ɛbwɔ́ meko aké, “Mende fɔ ayi akámege Jisɔs, ne apyɛ gentwɔtwɔ awaá me né amɛ, ajɔɔ́ ne me aké, chó shwɔ́né ushu byɛ né géntoógé manaá ɛyigé ákuú nnó Silɔm. Njyɛ́gé, nshwɔné ne nlɔɔ́ mbaá maŋgɛ́né.” ");
INSERT INTO anvNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Ne bɔɔ́ bimbɔ agií ji aké, “Mende awú alú fɔ́? Aké ne ɛbwɔ́ me nkaá wɔ́”. ");
INSERT INTO anvNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Mende yimbɔ ajɔɔ́gé mbɔ, ákpá ji áfɛ́ mbaá ɛkwɔ bɔɔ́ Farasi. ");
INSERT INTO anvNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Bií bi Jisɔs apyɛ getwɔtwɔ mende yimbɔ alɔɔ́ mbaá mangɛ́né, ɛlé bií uwyaá. ");
INSERT INTO anvNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Ne ɛkwɔ bɔɔ́ Farasi ntó ama ágií mende yimbɔ ndɛre ɛpyɛ́gé ne ji alɔɔ́ mbaá mangɛ́né. Ne mende yimbɔ agaré ɛbwɔ́ aké, “Awaá me gentwɔtwɔ né amɛ, nshwɔné ushu ba ne nana ngɛ́ne mbaá”. ");
INSERT INTO anvNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Ajɔɔ́gé mbɔ, ɛkwɔ bɔɔ́ Farasi abifɔ áké, “Mende yina ayi ákuú ji Jisɔs atané fɔ́ mbaá Ɛsɔwɔ wɔ́, néndé ábélégé fɔ́ ɛbɛ́ ɛwé aké muú apyɛ́gé fɔ utɔɔ́ bií uwyaá”. Yɛ́mbɔ abifɔ aké, “Ɛpyɛmbɔ nnó ne muú ayi apyɛɛ́ gabo, apyɛɛ́ ufɔɔ́ ufélekpá bina?” Ɛwéna ɛpyɛ ɛbwɔ́ ábɔ́ ufɛ́ré ucháchá. ");
INSERT INTO anvNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Ne áma ágií mende yimbɔ áké, “Ne wɔ mbɔɔ́ ɔjɔɔ́ nnó, gétúgé mende yina ayi apyɛ amɛ jyɛ ánené?” Ashuú meko aké, “Ji alu muú ɛkpávé Ɛsɔwɔ.” ");
INSERT INTO anvNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Yɛ́mbɔ ákpakpa bɔɔ́ Jus ákɛ́légé fɔ́ mankamé nnó ábɔ́ ábyɛ́ mende yina amɛ nónómé ne alɔɔ́ mbaá mangɛ́né. Ákuú mma wuú ne ntɛ wuú. ");
INSERT INTO anvNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Áchwɔ́gé ágií ɛbwɔ́ áké, “Maá nyú na? Ɛnyú déké débyɛ́ ji amɛ nónómé? Ɛpyɛ́gé nnó ne ji agɛ́ne nana?” ");
INSERT INTO anvNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Mma wuú ne ntɛ wuú ágaré ɛbwɔ́ áké, “Ɛsé dékaá nnó gɛ́ maá sé na, débɔ́ débyɛ́ ji amɛ nónómé. ");
INSERT INTO anvNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Ne genó ɛyi gépyɛ́gé ne ji alɔɔ́ mangɛ́né mbaá, ɛsé dékaá wɔ́. Yɛɛ́ muú ayi anené ji amɛ, ɛsé dékaágé fɔ́. Gígé jimbɔɔ́ agáré ɛnyú, apɔ́ sé mamane kɔ.” ");
INSERT INTO anvNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Ɛbwɔ́ ájɔɔ́ mbɔ gétúgé áfɔɔ́ ákpakpa bɔɔ́ Jus, abi ábɔ́ ajɔɔ́ mɛ́ nnó muú ayi ajɔge nnó Jisɔs alu Muú yi Ɛsɔwɔ akweré ji ɛlá gefwa, áfyɛ́ɛ ji ɛbɛ́ nnó akpɛgé sé né mmu ɛcha mmyɛmenɛne. ");
INSERT INTO anvNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Gɛ́ genó ɛyi gepyɛɛ́ mma wuú ne ntɛ wuú ajɔɔ́ áké, “Ji apɔ́ sé mamáné kɔ, gíge jimbɔɔ́ agáré ɛnyú.” ");
INSERT INTO anvNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Ne ákpakpa bɔɔ́ Jus áma kuú mende yi amɛ́ abɔ́ ánómé ji, ájɔɔ́ ne ji áké, “Gáré wáwálé wyɛ né mbɛ ushu Ɛsɔwɔ, néndé ɛsé dékaá nnó mende yina alú muú ayi apyɛɛ́ gabo.” ");
INSERT INTO anvNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Ne mende yimbɔ ashuú ɛbwɔ́ meko aké, “Waá ji alú muú ayi apyɛɛ́ gabo ah, waá apɔɔ́ ah, genó gema ɛyigé me nkaá gélú nnó me mbɔ nlú amɛ nónómé ne nana ngɛ́ne mbaá.” ");
INSERT INTO anvNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Ne ágií ji áké, “Apyɛ́ nnó, ne wɔ? Apyɛ nno ne wɔ ɔlɔɔ́ mangɛ́né mbaá?” ");
INSERT INTO anvNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Ashuú ɛbwɔ́ meko aké, “Pɔ́ me mbɔ́ ngáré mɛ́ ɛnyú? Yɛ́mbɔ dékɛ́légé fɔ́ manwú, ulannó ɛnyú dékɛ́légé mámanwú? Ndɔfɔ ɛnyú ntó dékɛ́légé mambɛ́ aŋkwɔlé bií?” ");
INSERT INTO anvNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Ajɔɔ́gé mbɔ, bɔɔ́ bimbɔ álɔ manju ji mashyɛ mmyɛ, áké, “Wɔ ne ɔlú menkwɔlé wuú. Ɛsé délú aŋkwɔlé Mosis. ");
INSERT INTO anvNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Ɛsé dékaá nnó Ɛsɔwɔ ajɔɔ́ nyá mejɔɔ́ ne Mosis, ne ushuú mbaá menya muú yina atané ɛsé dekaá wɔ́.” ");
INSERT INTO anvNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Mende yimbɔ aké, “Mechɔ́ ɛwé ɛgboó me mmyɛ. Ɛnyú déké dékaá fɔ́ mbaá ayi ji atané wɔ́ yɛ́mbɔ apyɛ me ngɛ́né mbaá. ");
INSERT INTO anvNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Dékaá nnó Ɛsɔwɔ awuú fɔ́ mmyɛmenɛné bɔɔ́ abi ápyɛɛ́ gabo, yɛ́mbɔ yɛ́ndémuú ayi ánogé Ɛsɔwɔ ne ápyɛ́ɛ unó bi Ɛsɔwɔ ákɛ́lege, Ɛsɔwɔ awuú mmyɛmenɛne jií. ");
INSERT INTO anvNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Tɛ mme álɔɔ́ délú danwú nnó muú fɔ ánené ámɛ́ muú ayi ábyɛné ji amɛ́ nónómé. ");
INSERT INTO anvNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Mende yina ábɛ́ dantáne mbaá Ɛsɔwɔ mbɔ yɛ genó ji apyɛɛ́ wɔ́.” ");
INSERT INTO anvNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Ajɔɔ́gé mbɔ, áshuú ji meko áké, “Ábyɛ́ wɔ ɔwɛ́ né mmu gabo. Ndé genó wɔ ɔ́kɛ́lege manlɛré ɛsé?” Ájɔɔ́gé mbɔ, áfyɛ́ ji ɛbɛ́ nnó ákpɛ́gé sé mmu ɛcha mmyɛmenɛne. ");
INSERT INTO anvNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Ne Jisɔs awuúgé nnó afyɛ́ mende yimbɔ ɛbɛ́, akɛlé ji agɛ́, agií ji aké, “Nnó wɔ ɔfyɛ metɔɔ́ ne Maá Ntɛ Mekwaá?” ");
INSERT INTO anvNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Ne mende yimbɔ ashuú ji meko aké, “Ata, Maá Ntɛ Mekwaá ɛlé waá? Garé me mmfyɛ́ metɔɔ́ ne ji.” ");
INSERT INTO anvNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Jisɔs ajɔɔ́ ne ji aké, “Wɔ ɔgɛ́ mɛ́ ji nana. Ji ne ajɔɔ́gé mbɔ mejɔɔ́ ne wɔ.” ");
INSERT INTO anvNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Mende yimbɔ ajɔɔ́ yɛ́ ne Jisɔs aké, “Ata me mmfyɛ́ metɔɔ́ ne wɔ”, ne anógé ji. ");
INSERT INTO anvNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Ne Jisɔs ajɔɔ́ ne ji aké, “Me nchwɔ́ fa mme mampyɛ gabo bɔɔ agɛne gbɔgɔnɔ, nnó bɔɔ́, abi álú amɛ nónómé ágɛ́né mbaá ne nnó abi afɛré nnó ɛbwɔ́ ágɛ́ne, abɛ amɛ nónómé.” ");
INSERT INTO anvNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Ajɔɔ́gé mbɔ, bɔɔ́ ɛkwɔ Farasi abi álú ɛfɛɛ́, áwuú, ágií ji áké, “Ɛsé défɛré nnó wɔ ɔjɔɔ́gé fɔ́ lé ne ɛsé nnó délú ntó amɛ́ nónómé?” ");
INSERT INTO anvNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Ne Jisɔs ashuú ɛbwɔ́ meko aké, “Ɛnyú débɔ́ dékámé nnó délú amɛ nónómé mbɔ abɔ ajɔɔ fɔ nno ɛnyu depyɛ gabo wɔ́. Tɛ mbaá ɛnyú déké dégɛ́ne, gabo nyú alá ɛnyú mmyɛ.” ");
INSERT INTO anvNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Ngarege ɛnyú wáwálé nnó, “Muú ayi akwɔme mfaá gebame akpɛne né mmu gebamege magɔŋme, álá koge né meno gebame alú menjo. Ɛlá pɔ́ mbɔ fɔ́ wɔ́, alú muú yi afɔgé unó bɔɔ́. ");
INSERT INTO anvNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Ne muú yi akogé né meno gebame akpɛ né mmu gebamege magɔŋme alú mbɔɔ́ magɔŋme yimbɔ. ");
INSERT INTO anvNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Mebame meno gebame ánénégé ji meno gebame, ji akpɛ né mmu, ne magɔŋme awuú meko wuú. Ne ji akuú magɔŋme jií né mabɔ ne asɛ áji afɛ́ dafyɛ. ");
INSERT INTO anvNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Ne asɛ́gé magɔŋme jií ako atanege dafyɛ, ji ajyɛ mbɛ aji akwɔlege ji meso, néndé ákáge meko wuú. ");
INSERT INTO anvNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Yɛ́mbɔ áji akwɔlege fɔ meŋkɛɛ́, áboó lé ji boó nénde ákáge fɔ meko wuú.” ");
INSERT INTO anvNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Jisɔs ató ɛbwɔ́ nekané mejɔɔ́ ɛníné na, yɛ́mbɔ, ɛbwɔ́ ákáge fɔ geno ɛyige ji agarege ɛbwɔ. ");
INSERT INTO anvNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Ne Jisɔs ama ajɔɔ́ aké, “Me ngarege ɛnyú wáwálé nnó me ne nlú meno gebamege magɔŋme. ");
INSERT INTO anvNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Ne bɔɔ́ ako abi abɔɔ́ mbɛ achwɔɔ́ ne me, álú lé anjo, ne bɔɔ́ abi afɔgé unó bɔɔ́ fɔge, magɔŋme awuú fɔ ɛbwɔ́. ");
INSERT INTO anvNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Me ne nlú meno gebame, yɛ́ndémuú ayi akoógé ɛta wa ne akpɛ né mmu, Ɛsɔwɔ aferege nyɛ ji né ɛfwyale gabo. Ne akpɛne nyɛ mmu atanege dafyɛ agɛne yɛ́ndégenó ɛyi gelií ji. ");
INSERT INTO anvNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Menjo achwɔɔ́ lé nnó ajo unó, awá bɔɔ́ ne áchɔ unó, yɛ́mbɔ me nchwɔ lé nnó mmpyɛ bɔɔ́ abɔ geŋwá abɛ gbɛne né mati mako. ");
INSERT INTO anvNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Me nlú membame magɔŋme melɔ́mélɔ́. Membame magɔŋme melɔ́mélɔ́ achyɛge gemɛ jií gétúgé magɔŋme jií. ");
INSERT INTO anvNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Muú usege apɔ́ fɔ́ membamé magɔŋme, muú áwyaá magɔŋme, ndɛre ɛlúmbɔ, gébégé agɛge mekwala aké achwɔɔ́, aboó alyaá magɔŋme, mekwala afwené áji álá tyátyá. ");
INSERT INTO anvNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Muú yimbɔ, aboó alyaá magɔŋme yimbɔ néndé ji alú lé muú usege, abɔɔ́ fɔ́ gébé ne áji wɔ́. ");
INSERT INTO anvNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Me nlú membame magɔŋme melɔ́mélɔ́, me nkágé magɔŋme ya ne magɔŋme ya ntó ákáge me. ");
INSERT INTO anvNT_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Wyɛ ndɛre Ntɛ wa akaa me, me ntó nkaa ji. Me nchyɛge gemɛ ya gétúgé magɔŋme ya. ");
INSERT INTO anvNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Ne nwya magɔŋme ayifɔ, ayi álá pɔ́ né geluage ayina, mbɔ́ mansɛ áji ncho ne ayina. Áji ntó áwuú nyɛ meko wa, ne mpyɛ nyɛ áji ábɛ ɛkwɔ magɔŋme ɛma ne ábɛɛ́ nyɛ ne membame ama. ");
INSERT INTO anvNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“Ula bi ntɛ wa agboó ne me úlú nnó nchyɛge gemɛ ya nnó áwá gétúgé bɔɔ́ ba ne nnó kwyakwya me mma mbɔ́ geji. ");
INSERT INTO anvNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Yɛ́ muú ayi akágé wa me apɔ́, yɛ́mbɔ me mbɔɔ́ ne nchyɛge gemɛ ya nnó awá. Ne me nwyaá uto manchyɛ gemɛ ya nnó áwá ne nwya ntó uto mamma mbɔ geŋwá ya. Gɛ geno ɛyige Ntɛ wa agare me mbɔ” ");
INSERT INTO anvNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Jisɔs ajɔ́gé mbɔ, bɔɔ́ Jus ábɔ́ ufɛre ucháucha. ");
INSERT INTO anvNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Abifɔ ájɔ́gé áké, “Melo nchyɛ achyɛge Jisɔs ɛfwyale ne ameé gebwɔɔ́, déwúgé ji.” ");
INSERT INTO anvNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Ne abifɔ ntó ájɔ́gé áké, “Muú ayi melo nchyɛ achyɛgé ji ɛfwyale ajɔ́gé fɔ ufɔɔ́ unó bina. Nnó muú ayi meló nchyɛ achyɛgé ji ɛfwyale, akaáge apyɛɛ́ ntó muú amɛ nónómé agɛne mbaá?” ");
INSERT INTO anvNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Ne gébégé bɔɔ́ Jus ányɛɛ́ ɛpaá ɛwe ɛbwɔ́ áteé ndɛre áfyɛɛ ɛcha upɛ né amu Ɛsɔwɔ, Jisɔs abɔ alu né Jɛrosalɛ. Gébé ɛyigémbɔ nebá nelu. ");
INSERT INTO anvNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Ndɛre Ji alú né dachi ɛcha upɛ Ɛsɔwɔ, akɛne né agbá ayi akuú nnó agba Solomun. ");
INSERT INTO anvNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Bɔɔ́ Jus áchwɔ́ nɔ ji né mme, ágií ji áké, “Wɔ ɔlyagé mbɔ ɛsé né mmu dembyɔ nnó? Mbɔgé wɔ ɔlú Muú yi Ɛsɔwɔ akweré ji ɛlá gefwa gare ɛse gbɔŋɔnɔ.” ");
INSERT INTO anvNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Ne Jisɔs ashuú ɛbwɔ́ meko aké, “Me mbɔ ngare mɛ ɛnyú, yɛ́mbɔ ɛnyú dékame ne me wɔ. Utɔɔ́ ɛbi mempyɛɛ́ né mabɔ Ntɛ wa, ubi ne ulɛrege gefɔge muú ayi me nlú. ");
INSERT INTO anvNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Yɛ́mbɔ ɛnyú dékamege néndé depɔ fɔ́ né geluage magɔŋme ya. ");
INSERT INTO anvNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Magɔŋme ya, ákágé meko wa. Me nkágé áji ne áji ntó ákwɔlege me. ");
INSERT INTO anvNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Me nchyɛge áji geŋwá ɛyi gélágé byɛɛ́. Áji ánome fɔ́ mme detu ne yɛ́ muú ayi ákágé fɔɔ́ áji né amu ya ápɔ́. ");
INSERT INTO anvNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Néndé Ntɛ wa muú áfyɛɛ́ me áji né amu, aŋea gemɛ apwɔ bɔɔ́ ako, ne yɛ́ muú ayi ákágé fɔɔ́ aji né amu Ntɛ wa apɔ́. ");
INSERT INTO anvNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Me ne ntɛ wa Ɛsɔwɔ delu muú ama.” ");
INSERT INTO anvNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Jisɔs ajɔ́gé mbɔ, bɔɔ́ Jus ama ábɔ́ mataá nnó áto ji áwá. ");
INSERT INTO anvNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Ne Jisɔs ajɔɔ́ ne ɛbwɔ́ aké, “Me mpyɛ gejamégé utɔɔ́ ulɔ́úlɔ́ ɛbi Ntɛ wa achyɛɛ́ me utó nnó mpyɛ, ɛnyú degɛ. Né ɛbi ndé ne ɛnyú dékɛlege manto me ne mataá?” ");
INSERT INTO anvNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Bɔɔ́ Jus bimbɔ áshuú ji meko aké, “Ɛpɔfɔ gétúgé utɔɔ́ ulɔ́úlɔ́ ɛbi wɔ ɔpyɛɛ́ ne ɛse detome wɔ ne mataá. Ɛlé gétúgé wɔ ɔbyaá Ɛsɔwɔ. wɔ ɔlú lé mekwaá, yɛ́mbɔ ɔsɛ gemɛ jyɛɛ́ nnó wɔ ɔlú Ɛsɔwɔ.” ");
INSERT INTO anvNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Ne Jisɔs ajɔɔ́ ne ɛbwɔ́ aké, “Pɔ nnó asa né mmu ŋwɛ Ɛsɔwɔ nnó, ‘Me nke ɛnyú delu bɔ ɛsɔwɔ?’ ");
INSERT INTO anvNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Ɛse dékaá nnó mekomejɔɔ́ Ɛsɔwɔ akwɔrégé fɔ́. Ne mbɔgé Ɛsɔwɔ akú bɔɔ́ abi ji achyɛɛ́ ɛbwɔ́ mekomejɔɔ́ nnó álú bɔ ɛsɔwɔ. ");
INSERT INTO anvNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Ɛpyɛmbɔ nnó ne me muú Ɛsɔwɔ ajyaá atɔme fa mme, njɔ́gé nnó nlú Maá Ɛsɔwɔ, ɛnyú déké me mbyaá Ɛsɔwɔ? ");
INSERT INTO anvNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Mbɔgé me mpyɛɛ́ fɔ́ utɔɔ́ ɛbi Ntɛ wa achyɛɛ́ me nnó mpyɛge, dékamegé fɔ́ ne me. ");
INSERT INTO anvNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Ne mbɔgé me mpyɛ lé ubi, yɛ́ lé ɛnyú déla dékame nnó genó ɛyigé me njɔ́gé gelú wáwálé wɔ́, kamegé ne utɔɔ́ ɛbi me mpyɛɛ́. Dépyɛge mbɔ, dégɛne nyɛ nnó me nlu muú ama ne Ntɛ wa, ne Ntɛ alu muú ama ne me.” ");
INSERT INTO anvNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Ajɔ́gé mbɔ, bɔɔ́ Jus bimbɔ ama amua mampyɛ ji, yɛ́mbɔ aloó ɛbwɔ́ né amu. ");
INSERT INTO anvNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Achyaá afɛ né ɛgbɛ ɛbɛɛ́ Jodan ɛwefɔ mbaá ayi Jɔn abɔ awyage nya bɔɔ́ manaá Ɛsɔwɔ, ajwɔlege ɛwú. ");
INSERT INTO anvNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Ne gejamégé bɔɔ́ ákwɔle ji, ájɔ́gé ne atɛ áké, “Jɔn apyɛ yɛ́ ufélekpa fɔ́ wɔ́, yɛ́mbɔ yɛ́ndégenó ɛyigé ji ajɔɔ́ atome ne mende yina gelú wáwálé.” ");
INSERT INTO anvNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Ɛfɛɛ́ ne gejamégé bɔɔ́ áfyɛɛ́ metɔɔ́ ne Jisɔs. ");
INSERT INTO anvNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Gébégé fɔ, mende fɔ abɔ ameé, akuú ji nnó Lasarɔs. Ji alu muú Bɛtani. Bɛtani ɛle melɔ Mɛri ɛbwɔ ne meŋmo wuú Mata. ");
INSERT INTO anvNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Ɛlé Mɛri yina ne abɔ ágbɛlé nya lamɛnda né uka Ata, atile ne mejwɛ wuú. Ji ne meŋmo wuú Lasarɔs abɔ́ ameé. ");
INSERT INTO anvNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Gétúgé Lasarɔs ameé, aŋmɛ bií átɔ́ meko mbaá Jisɔs aké, “Ata mejeé wyɛɛ́ ayi ɔgboó ne ji dɔɔ́ ameé.” ");
INSERT INTO anvNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Jisɔs awúgé meko ayi alɔɔ́ ji, aké, “Nemeé ɛniné Lasarɔs ameé mbɔ, nepɔ́ fɔ́ ɛni netene ji aló nelú ɛle nnó, bɔɔ́ áfɛge Maá Ɛsɔwɔ nnó ŋgɔ Ɛsɔwɔ akwɔ. Getu ɛyigembɔ bɔɔ́ áfɛge nyɛ Maá Ɛsɔwɔ.” ");
INSERT INTO anvNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Jisɔs agboó ne Mata, ne meŋmo wuu Mɛri ne Lasarɔs. ");
INSERT INTO anvNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","awuge nnó Lasarɔs ameé ama bɛle né melɔ ɛwé ji abɔ alú wyɛɛ́ ndɔ ɛpea. ");
INSERT INTO anvNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Ne ndɔ yimbɔ ɛpea ɛkógé, ajɔɔ́ ne baá utɔɔ́ bií aké, “Déma déjyɛ né gebage mewaá Judiya.” ");
INSERT INTO anvNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Baá utɔɔ́ bií ájɔɔ́ ne ji áké, “Ménlɛré ɛlú dambɛle ayi bɔɔ́ bimbɔ áké áto wɔ ne mataá áwá, ne wɔ ɔkɛlege nnó déma dékeré ɛwú?” ");
INSERT INTO anvNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Ájɔ́gé mbɔ, Jisɔs ashuú ɛbwɔ́ meko né nekanémejɔɔ́ aké. “Yɛ́ndé bií uwyaá nchwanekɛ ɛfyánéɛpeá ne utuú ugi, wa mbɔ fɔ́ wɔ́? Bɔɔ́ áké ákɛne ne bií gbɔɔ́, ákparege fɔ́ nekwe néndé ágɛne mbaá. ");
INSERT INTO anvNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Yɛ́mbɔ bɔɔ́ abi akɛne ne utuú ákpárege nekwe néndé geŋgbɔ gepɔ́.” ");
INSERT INTO anvNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Ajɔ́gé mbɔ, aké ne ɛbwɔ́, “Meŋmɛ se Lasarɔs akwe gejya, yɛ́mbɔ me njyɛ ɛwú nnó pyɛ ji apeé gejya.” ");
INSERT INTO anvNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Ajɔ́gé mbɔ, baá utɔɔ́ bií áké ne ji, “Ata mbɔgé abɛlé gejya ɛbyɛnnó alé atoó.” ");
INSERT INTO anvNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Jisɔs abɔ agarege mbɔ lé ɛbwɔ́ negbone Lasarɔs, yɛ́mbɔ ɛbwɔ́ áfɛre nnó ajɔ́gé mbɔ lé mechɔ gejya ɛyigémbɔ. ");
INSERT INTO anvNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Jisɔs agare yɛ́ ɛbwɔ́ gbɔgɔnɔ aké, “Lasarɔs agbo. ");
INSERT INTO anvNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Ne metɔɔ́ ɛgɔɔ́ me gétúgé nyú nnó me mbɔ́ mpɔ́ fɔ́ ɛwú ne ji. Genó ɛyigé mempyɛ nyɛ, gepyɛ nyɛ ɛnyú défyɛɛ́ metɔɔ́ ne me cháŋéné. Kwilege mme déjyɛ dégɛ ji.” ");
INSERT INTO anvNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Ajɔ́gé mbɔ, Tɔmasi maá gefa, ajɔɔ́ ne atɛ baá utɔɔ́ aké, “Kwilege déjyɛ, yɛ́ ɛbɛ lé negbo, degbo ne ji”. ");
INSERT INTO anvNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Jisɔs akwɔnege né melɔ Bɛtani, agɛ nnó anií Lasarɔs né mmu ɛba ntaá alɛ mɛ ndɔ ɛni. ");
INSERT INTO anvNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Nekɛne Bɛtani ne Jɛrosalɛ nelú genóge ŋkpa nekɛ ɛpea. ");
INSERT INTO anvNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Ne gejamégé bɔɔ́ Jus áfɛ́ manjwyɛ Mata ɛbwɔ́ ne Mɛri mmyɛ gétúgé negbone meŋmo bwɔ́. ");
INSERT INTO anvNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Mata awúgé nnó Jisɔs achwɔɔ́, atane ajyɛ bane ji, Mɛri álá ji né mmu gepú. ");
INSERT INTO anvNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Mata ábánégé Jisɔs ajɔɔ́ ne Ji aké, “Ata mbɔgé wɔ ɔbɔ́ ɔbɛ fa, mbɔ meŋmó wa agboó wɔ́.” ");
INSERT INTO anvNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Yɛ́mbɔ, yɛ́ ɛbɛ ɛlé nana, nkaá nnó, yɛ́ndégenó ɛyigé wɔ ɔgigé Ɛsɔwɔ, achyɛge wɔ geji. ");
INSERT INTO anvNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Ne Jisɔs ajɔɔ́ ne ji aké, “Meŋmó wyɛ akwilege nyɛ né negbo.” ");
INSERT INTO anvNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Ne Mata aké, “Nkaá nnó akerege nyɛ meso né geŋwá gébégé bɔɔ́ áké ákwilege nyɛ né negbo né bií bi kwyakwya.” ");
INSERT INTO anvNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Ajɔ́gé mbɔ, Jisɔs aké, “Me ne mbwyɛge bɔɔ́ ákwilege né negbo, ne me ne nchyɛge bɔɔ́ geŋwá. Yɛ́ndémuú ayi áfyɛɛ́ metɔɔ́ ne me, yɛ́ agbo akerege né geŋwá. ");
INSERT INTO anvNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Ne yɛ́ndémuú ayi alú mebɛ, áfyɛɛ́ metɔɔ́ ne me ágboó fɔ́, Mata ɔkamé nnó ɛlé wáwálé?” ");
INSERT INTO anvNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Mata aké, “Ɛh Ata nkamé, nnó wɔ ne ɔlú Muú yi Ɛsɔwɔ akweré ji ɛlá gefwa, Maá Ɛsɔwɔ ayi ábɔɔ́ manchwɔ fa mme.” ");
INSERT INTO anvNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Mata ajɔ́gé mbɔ, ajyɛ kú meŋmo wuú Mɛri ajɔɔ́ ne ji bibi aké, “Ménlɛré achwɔ, akɛlege mangɛ wɔ.” ");
INSERT INTO anvNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Mɛri awúgé mbɔ, akwilé mme wáwá, ajyɛ bane Jisɔs. ");
INSERT INTO anvNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Jisɔs abɔ alú dankwɔne yɛ́ né melɔ, alú wyɛ né mbaá ayi Mata abané ji. ");
INSERT INTO anvNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Ne bɔɔ́ Jus abi alú né mmu gepúge negbo áfyɛɛ́ Mɛri metɔɔ́ né negbone meŋmo wuú, ágɛge ndɛre Mɛri akwilé ka wáwá átane dafyɛ, ɛbwɔ́ ntó ákwilé ákwɔle ji, néndé áfɛre nnó ji ajyɛɛ́ mbɔ lé né menome meŋmo wuú Lasarɔs manli negbo. ");
INSERT INTO anvNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Mɛri akwɔnege, agɛ Jisɔs, akwe ji né uka aké, “Ata wɔ ɔbɔ ɔbɛ fa, mbɔ meŋmo wa abɔ́ agboó wɔ́.” ");
INSERT INTO anvNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Jisɔs ágɛ́gé ndɛre Mɛri álíli chonchó ne bɔɔ́ Jus abi ákwɔlege ji, ɛta ji mmu ne meshwɛ akwɔ ji metɔɔ́. ");
INSERT INTO anvNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Agií ɛbwɔ́ aké, “Ɛnyú dénií ji ɛfɔ́?” Áshuú ji meko aké, “Ata, chwɔ gɛ mbaá wuú.” ");
INSERT INTO anvNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Jisɔs asɔ manse. ");
INSERT INTO anvNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Bɔɔ́ Jus bimbɔ, ágɛgé mbɔ, áké, “Ɛ́ ɛ́, gɛge ndɛre ji abɔɔ́ gejeé ne Lasarɔs.” ");
INSERT INTO anvNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Yɛ́mbɔ abifɔ ájɔ́gé áké, “Nnó ji muú apyɛɛ́ muú amɛ nónómé agɛne, abɔ́ akágé pyɛ fɔ́ nnó Lasarɔs agboge?” ");
INSERT INTO anvNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Ne nchyɛ ama anywɔne Jisɔs né mmu, afɛ́ né menome. Menome ɛwémbɔ, ɛlú lé ɛmbu ɛbá ntaá, agbɛ ɛwú ne ntaá. ");
INSERT INTO anvNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Jisɔs aké, “Ferege ntaá ɛniné mbɔ né meno menome.” Mata meŋmɛ Lasarɔs ashuú ji meko aké, “Ata, agbo mbɔ alɛ fina ndɔ ɛni, gébé ɛyi, gebɛ gebogebo geja gepwɔ amu.” ");
INSERT INTO anvNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Ne Jisɔs ajɔɔ́ ne ji aké, “Mata, pɔ́ me ngaré na wɔ nnó ɔfyɛge metɔɔ́ ne Ɛsɔwɔ, ɔgɛne nyɛ genó ɛyigé utó ba upyɛɛ́?” ");
INSERT INTO anvNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Áférégé ntaá ɛniné mbɔ, Jisɔs abwɛɛ́ amɛ apɛ mfaá anɛmmyɛ aké, “Ntɛ wa, ntame wɔ néndé ɔwú mmyɛmenɛne ya. ");
INSERT INTO anvNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Nkaá nnó wɔ ɔwuú mmyɛmenɛne ya yɛ́ndégébé. Yɛ́mbɔ, njɔɔ́ mbɔ gétúgé bɔɔ́ abi álú fa, nnó ɛbwɔ́ ákamé nnó wɔ ne ɔtɔme me.” ");
INSERT INTO anvNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Anerege manjɔɔ́ mbɔ, anyá ne meko metometo aké, “Lasarɔs táné chwɔ fa.” ");
INSERT INTO anvNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Tɛnétɛné yimbɔ, Lasarɔs atane dafyɛ, uka bií ne amu, úlú wyɛ wɛ́wɛ́ né mmu uba mandée ɛbií áni ji né mmyɛ chonchó ne ushu. Ne Jisɔs aké, “Kaáge ji ajyɛ.” ");
INSERT INTO anvNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Ne gejamégé bɔɔ́ Jus abi ábɔ́ álú ɛfɛɛ́ áchwɔɔ́ áchwɛɛ́ Mɛri mmyɛ́, ágɛge ndɛre Jisɔs apyɛɛ́ Lasarɔs apeé né negbo, áfyɛɛ́ matɔɔ́ ne Jisɔs. ");
INSERT INTO anvNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Yɛ́mbɔ, abifɔ ájyɛ gare bɔɔ́ Farasi fɔ genó ɛyigé Jisɔs apyɛɛ́. ");
INSERT INTO anvNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Ne anɔ ba ampyɛɛ́ upɛ Ɛsɔwɔ ne ɛkwɔ bɔɔ́ Farasi fɔ, ákú ujwɔlé, áchomé né ɛso ájɔɔ́ aké, “Nana ɛsé dépyɛmbɔ nnó? Mende yina apyɛɛ́ mbɔ ufélekpa ufɔɔ́ ufɔɔ́ ajyɛɛ́. ");
INSERT INTO anvNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Mbɔgé délyage ji nnó ajyɛɛ́ mbɛ mampyɛ ubi, melɔ meko ɛfyɛɛ́ nyɛ metɔɔ́ ne ji, ne bɔɔ́ Rom áchwɔ chɔ nyɛ ɛcha upɛ se chonchó ne melɔ.” ");
INSERT INTO anvNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Ne muú bwɔ́ ama, ayi akamege Kaifas, ji ne alú ɛtukpe ampyɛ upɛ Ɛsɔwɔ né ŋmɛ ɛniné mbɔ. Ajɔɔ́ aké, “Ɛnyú dékage yɛ́ genó kaŋka, ");
INSERT INTO anvNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","dekaá fɔ́ nnó ɛlú galɔ́gálɔ́ ɛta nyú nnó muú ama agbo gétúgé bɔɔ́ ako ɛpwɔ nnó melɔ meko ɛ́nómé wɔ́?” ");
INSERT INTO anvNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Mejɔɔ́ ɛwé Kaifas ajɔɔ́ mbɔ, ɛtane fɔ́ jimbɔɔ́ né metɔɔ́ wɔ́. Ndɛre ji alú ɛtukpe ampyɛɛ́ upɛ Ɛsɔwɔ né ŋmɛ ɛniné mbɔ, Ɛsɔwɔ apyɛ nnó ji agare nnó Jisɔs abɔ magbo gétúgé melɔ meko. ");
INSERT INTO anvNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Ne ɛpɔ́fɔ́ gétúgé melɔ ɛwú ɛwú wɔ́, agbo ntó nnó apyɛ bɔɔ́ Ɛsɔwɔ abi álaá tyátyá né mme meko anywɛre akwe muú ama. ");
INSERT INTO anvNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Ɛlɔ né gébé ɛyigémbɔ, ákpakpa bɔɔ́ Jus asɔ mala ndɛre ápyɛɛ́ ne áwa Jisɔs. ");
INSERT INTO anvNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Né getú ɛyigémbɔ, Jisɔs amáge kɛ sé gbɔŋɔnɔ né géluage bɔɔ́ Jus. Alyaá Jɛrosalɛ afɛ́ né maá melɔ fɔ́ ayi akuú nnó Ɛfrɛm kwɔ́kwɔ́lé ne mashwɔne. Ɛwúmbɔ ne ji ne baá utɔɔ́ bií ájwɔlége. ");
INSERT INTO anvNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Ne gébégé ɛpaá bɔɔ́ Jus ɛwé ákuú nnó ɛpaá koó upú ɛlá kwɔ́kwɔ́lé, gejamégé bɔɔ́ áfɛ́ né Jɛrosalɛ nnó akpome mmyɛ ndɛre ɛbwɔ́ apyɛ mɛ gemɛge nnó ɛpaá ɛwémbɔ ɛkwɔne. ");
INSERT INTO anvNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Ne ndɛre ɛbwɔ anywere né mmu ɛcha upɛ Ɛsɔwɔ, ápɛle mbɔgé agɛne nyɛ Jisɔs. Ájɔ́ge ne atɛ áké, “Ɛnyú défɛre mbɔ nnó? Nnó ji achwɔɔ́ nyɛ né ɛpaá ɛwéna waá achwɔɔ́?” ");
INSERT INTO anvNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Gemɛge nnó ɛpyɛmbɔ ɛtukpe ampyɛ upɛ Ɛsɔwɔ ne ɛkwɔ bɔɔ́ Farasi fɔ, ábɔ́ áchyɛɛ́ mɛ meko nnó muú ayi akaáge mbaá ayi Jisɔs alú ágare, ájyɛ apyɛ ji. ");
INSERT INTO anvNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Ɛpaá koó upú ɛlágé ndɔ ɛkene, Jisɔs afɛ né melɔ Bɛtani melɔ ɛwé Lasarɔs muú Jisɔs apyɛ ji apeé né negbo ajwɔlége. ");
INSERT INTO anvNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Ɛfɛɛ́ ne anɛne Jisɔs ne menyɛɛ́. Mata ne afaá menyɛɛ́ yimbɔ ne Lasarɔs alú muú ama né geluage bɔɔ́ abi ájwɔle agií mmyɛ né ɛkpókpógélé ne Jisɔs. ");
INSERT INTO anvNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Ndɛre ájwɔle mbɔ, Mɛri akpa ɛkpómé maweé Lamɛnda ami majame ŋka dɔɔ́, amo Jisɔs né uka. Gepú geko geka ne gebɛge lamɛnda, ne asɛ mejwɛ wuú ati uka Jisɔs. Maweé amina malu mmyɛ po. Ákwyɛɛ́ mami ne genó ɛyigé akuú nnó, “Nard.” ");
INSERT INTO anvNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Ne Judas Iscarot, maá utɔɔ́ Jisɔs ama ayi abɔɔ́ manchyɛɛ́ Jisɔs maŋkwaá, agɛge geno ɛyi meri apyɛmbɔ, aké, ");
INSERT INTO anvNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Mbɔ ákpoó maweé lamɛnda amina, ásɛ gejamégé ŋka, ɛyi ɛpwɔɔ́ ŋka ɛyi muu akage pyɛ né ŋmɛ áchyɛɛ́ mbaá ubyá bɔɔ́.” ");
INSERT INTO anvNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Mejɔɔ́ ɛwé Judas ajɔɔ́ mbɔ na, ɛpɔ́fɔ́ nnó ji agboó ne ubya bɔ, ɛlé gétúgé ji alú menjo ne ajɔɔ́ mbɔ. Ji ne ábélege mekwa ŋka baá utɔɔ́ Jisɔs. Ne gébé ɛyigé fɔ, ajoó ŋka wyɛ. ");
INSERT INTO anvNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Judas ajɔ́gé mbɔ, Jisɔs aké, “Gɔgé ji abɛ nyame, ji apyɛ́mbɔ nnó me ngboge ánií me niíge. ");
INSERT INTO anvNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Ubyá bɔɔ́ úlú fa ne ɛnyú yɛ́ndégébé, yɛ́mbɔ me mbɛɛ́ nyɛ fɔ́ ne ɛnyú gébé geko.” ");
INSERT INTO anvNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Ne gejamégé bɔɔ́ Jus áwúgé nnó Jisɔs alú ɛfɛɛ́ né melɔ Bɛtani, ákwɔle áfɛ ɛwú. Ájyɛ nya fɔ mangɛ lé Jisɔs jimbií wɔ́, áfɛ ntó nnó ágɛ Lasarɔs muú Jisɔs apyɛ ji apeé né negbo. ");
INSERT INTO anvNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Ndɛre ɛlúmbɔ, anɔɔ́ baá ampyɛɛ́ upɛ Ɛsɔwɔ asɔ mala nnó áwa Lasarɔs. ");
INSERT INTO anvNT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","néndé ɛlé getú jií ne gejame bɔɔ́ Jus ályaá ɛbwɔ́ áfyɛɛ́ metɔɔ́ ne Jisɔs. ");
INSERT INTO anvNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Bií ujyage, gejamégé bɔɔ́ abi áchwɔɔ́ manyɛ́ ɛpaá koó upú, áwú nnó Jisɔs achwɔɔ́ né Jɛrosalɛ. ");
INSERT INTO anvNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Ásɔ mammɛ́ɛ, átane ájyɛ bane ji meti. Áwyále áké, “Matame mábɛ́ ne Ɛsɔwɔ. Mejé ɛbɛ́ ne muú ayi achwɔɔ́ né mabɔ Ata. Ɛfwɔ́ ɛbɛ ne Mfwa bɔɔ́ Isrɛli!” ");
INSERT INTO anvNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Jisɔs agɛ́ge maá géjuŋá, akwɔ ajwɔle né mfaá. Ne genó ɛyigé ábɔ́ ásamé né mmu ŋwɛ Ɛsɔwɔ getane wáwálé nnó, ");
INSERT INTO anvNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Ɛnyú bɔɔ́ Sayɔn défɔge, gɛ́ge mfwa nyú achwɔɔ́, ajwɔlé mbɔ né mfaá maá géjuŋá” ");
INSERT INTO anvNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Ndɛre Jisɔs akpɛne né Jɛrosalɛ, baá utɔɔ́ bií ákaá fɔ́ nnó uno bi ábɔ ásame mɛ né mmu ŋwɛ Ɛsɔwɔ úlú wawale wɔ́. Yɛ́mbɔ gébégé Jisɔs akwɔme ajyɛɛ́ né mfaánebuú, ne ɛbwɔ́ ateé nnó abɔ asa né mmu ŋwɛ Ɛsɔwɔ nnó unó bina upyɛɛ́ nyɛ ne ji. Ne ápyɛ ntó ubi ne ji. ");
INSERT INTO anvNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Ne bɔɔ́ abi abɔ alú ne Jisɔs gébégé ji apyɛ Lasarɔs apeé né negbo, akpa gegare ɛyigémbɔ, ájyɛɛ́ ne geji. ");
INSERT INTO anvNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Genó ɛyigé na ne gepyɛ gejamégé bɔɔ́ ájyɛɛ́ bane Jisɔs né meti gétúgé áwuú gepɔge ufélekpa ɛbi ji apyɛɛ́. ");
INSERT INTO anvNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Ne ɛkwɔ bɔɔ́ Farasi, ájɔ́gé ne atɛ aké, “Yɛ mekpo ne ula ɛsé dégɛne fɔ né mechɔ ɛwe desɔɔ mbɔ mala manwa Jisɔs. Gɛgé, gemɛge melɔ geko gela kwɔle ɛlé ji.” ");
INSERT INTO anvNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Né geluage bɔɔ́ abi ájyɛ né Jɛrosalɛ manogé Ɛsɔwɔ gébégé ɛpaá koó upú, ne abi ákú ɛbwɔ́ nnó bɔɔ́ Grek álú wyɛ. ");
INSERT INTO anvNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Bɔɔ́ Grek bina áchwɔ mbaá Filip muú melɔ Bɛtsada né gebage mewaá Galilií, ájɔɔ́ ne ji áké, “Ata ɛsé dékɛlege mangɛ Jisɔs.” ");
INSERT INTO anvNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Filip awúgé mbɔ, ajyɛ gare Andru, ne ɛbwɔ́ ne Andru ájyɛ gare Jisɔs. ");
INSERT INTO anvNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Ne Jisɔs ashuú ɛbwɔ́ meko aké, “Gébé gekwane ɛyigé bɔɔ ágɛne nyɛ nnó Maá Ntɛ Mekwaá apwɔ amu. ");
INSERT INTO anvNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Me ngarege ɛnyú wáwálé nnó nyine nchi nelaá wyɛ nyine nchi nemaá, mbɔgé muú álá apɛɛ́ néní né mme degbo wɔ́. Negboge ne nechií nefyɛ gejame amɛ nchi. ");
INSERT INTO anvNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Muú ayi asɛle geŋwá jií nnó geŋeá gemɛ dɔɔ́, geŋwá jii genóme nyɛ mme detu. Ne muú ayi asɛle nnó geŋwá jií geŋeá fɔ gemɛ né mme yina wɔ́, abɛɛ́ nyɛ ne geŋwá ɛyi gélágé byɛ́. ");
INSERT INTO anvNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Mbɔgé muú akɛlege mampyɛge utɔɔ́ ba, abɔ́ mankwɔle me. Ne yɛ́ndé mbaá ayi me mbɛɛ, muú utɔɔ́ wa ntó abɛɛ́ wyɛɛ́ ne me. Ne yɛ́ndémuú ayi apógé me mampyɛ utɔɔ́ ba, Ntɛ wa anoge nyɛ ji. ");
INSERT INTO anvNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“Nana ufɛre ba úlú uyaá uyaá. Ɛwena njɔge mbɔ nnó? Nnɛne mbɔ ɛlé mmyɛ nnó, ‘Ntɛ wa aféré me né ɛfwyale ɛwé ɛchwɔɔ́ mbɔ me né mbɛ waá?’ Ngba, nnɛne fɔ́ mbɔ, néndé ula bi me nchwɔɔ́ fa mme úlú nnó ngɛ ɛfwyale ɛwéna. ");
INSERT INTO anvNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Ntɛ wa, pyɛ bɔɔ́ ákaá nnó wɔ ɔpwɔ amu.” Ajɔ́gé mbɔ, meko fɔ atane né mfaánebuú aké, “Me mpyɛ mɛ́ bɔɔ́ akaá nnó me mpwɔ amu, ne mmage pyɛ wyɛmbɔ.” ");
INSERT INTO anvNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Ne gejamégé bɔɔ́ abi átɛne ɛfɛɛ́, áwúgé meko yimbɔ, abifɔ aké, ɛlé nemfe, abifɔ aké, ɛlé ɛkiɛ́nné Ɛsɔwɔ ne ɛjɔɔ́ mejɔɔ́ ne Jisɔs. ");
INSERT INTO anvNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Ne Jisɔs ajɔɔ́ ne ɛbwɔ́ aké, “Meko ayi déwuú mbɔ́ alú lé né galɔ́gálɔ́ nyú, ɛpɔ́fɔ́ awa. ");
INSERT INTO anvNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Nana, gébé ɛyigé Ɛsɔwɔ apyɛɛ́ bɔɔ́ mme ákpɛ né unɔɔ́ mpa gekwɔne, gébé gekwɔne ɛyigé ábuú danchɔmeló mfwa bɔɔ́ mme, ");
INSERT INTO anvNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","né geluɔge gefwa jií. Ne abwɛge me né mbaá gekwa, njame nyɛ bɔɔ́ ako achwɔ́ ɛta wa.” ");
INSERT INTO anvNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Jisɔs ajɔɔ́ mbɔ, manlɛre gefɔge negbo ɛniné ji agboó nyɛ. ");
INSERT INTO anvNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Ne bɔɔ́ bimbɔ, ájɔɔ́ áké, “ŋwɛ mabɛ ɛsɔwɔ agare ɛse nnó Muú yi Ɛsɔwɔ akweré ji ɛlá gefwa, abɛ mebɛ tɛ kwyakwyaá, ɛpyɛɛ́mbɔ nnó ne wɔ ɔke ábɔ́ mambwyɛ Maá Ntɛ Mekwaá né mfaá gekwa, waá álú Maá Ntɛ Mekwaá yimbɔ?” ");
INSERT INTO anvNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Jisɔs ashuú ɛbwɔ́ meko aké, “Geŋgbɔ gelú gegɛnege ɛta nyú né mboó gébé, kɛ́ge nana ndɛre geŋgbɔ gelú gegɛnege nnó ɛ́kágé gemua gewere ɛnyú. Muú ayi akɛne né gemua ákágé fɔ́ mbaá ayi ji ajyɛɛ́. ");
INSERT INTO anvNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Fyɛ́ge metɔɔ́ ne muú ayi achyɛgé geŋgbɔ nana ayi ji alú ne ɛnyú, nnó debɛ bɔɔ́ abi achyɛge geŋgbɔ. Jisɔs ajɔ́gé mbɔ, alyaá ɛbwɔ́ ajyɛ bií.” ");
INSERT INTO anvNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Ne yɛ́ lé Jisɔs apyɛ gejamégé ufɔɔ́ ufélekpa ɛbwɔ́ ágɛné, áfyɛɛ́ fɔ́ matɔɔ́ ne ji wɔ́. ");
INSERT INTO anvNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Ɛpyɛmbɔ nnó genó ɛyigé Asaya muú ɛkpave Ɛsɔwɔ abɔ ajɔɔ́ getane wáwálé. Asaya abɔ ajɔɔ́ nya aké, “Ata, ndé muú ákamé ne mekomejɔɔ́ ayi ɛsé dégare. Ne ndé muú ayi Ata alɛre ji gefɔge utó bi ji awyaá?” ");
INSERT INTO anvNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Ula bi ɛbwɔ́ álá ákame nya ne mekomejɔɔ́ yimbɔ wɔ́, úlú wyɛ ndɛre, Asaya muú ɛkpave Ɛsɔwɔ abɔ ajɔɔ́ nya nnó Ɛsɔwɔ aké, ");
INSERT INTO anvNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Ngilége ɛbwɔ́ amɛ nnó ɛ́kágé ágɛne unó ne amɛ, ne mpyɛ bwɔ́ áŋea matɔɔ́ nnó ɛ́kágé ɛbwɔ́ ákaá genó ɛyigé mekomejɔɔ́ yimbɔ ágaré. Ɛsɔwɔ aké, ‘Me mpyɛ mbɔ nnó ɛ́kágé ɛbwɔ́ áti meso ne gabo bwɔ́, áchwɔ́ ɛta wá nnó me mfɛre ɛbwɔ́ né ɛfwyale’.” ");
INSERT INTO anvNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Asaya ajɔɔ́ mejɔɔ́ ɛwéna ato ne Jisɔs, néndé ji abɔ agɛ mɛ nnó Jisɔs abɛɛ́ nyɛ muú ayi apwɔɔ́ amu. ");
INSERT INTO anvNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Ne yɛ́ ɛlé gejamégé bɔɔ́ álú abi ála áfyɛɛ́ fɔ matɔɔ ne Jisɔs wɔ, abifɔ áfyɛ, yɛ́ ákpakpa bɔɔ́ Jus abifɔ áfyɛ́ ntó metɔɔ́ ne Jisɔs, yɛ́mbɔ álɛrege fɔ́ gbɔgɔnɔ nnó áfyɛɛ́ metɔɔ́ ne ji gétúgé áfɔɔ́ nnó álɛrege, bɔɔ́ Farasi ábuú nyɛ ɛbwɔ́ né ɛcha mmyɛmenɛne. ");
INSERT INTO anvNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Néndé ɛbwɔ́ ágbóo lé nnó akwaá áfɛge ɛbwɔ́ ápwɔ nnó Ɛsɔwɔ ne afɛge ɛbwɔ́. ");
INSERT INTO anvNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Ne Jisɔs ajɔɔ́ keŋke, aké, “Yɛ́ndémuú ayi áfyɛɛ́ metɔɔ́ ne me, áfyɛ́ fɔ́ metɔɔ́ ne me mbií wɔ́, afyɛ́ ntó ne muú yi atɔme me. ");
INSERT INTO anvNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Muú agɛgé me, ɛbyɛnnó agɛ ntó muú ayi atɔme me. ");
INSERT INTO anvNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Me nchwɔ ndɛre muú yi alɛrege geŋgbɔ mbaá bɔɔ́ mme, nnó ɛ́kágé bɔɔ́ abi áfyɛɛ́ metɔɔ́ ne me álá kenékéné ɛké muú ayi alú mmu gemua. ");
INSERT INTO anvNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Mbɔgé muú awúgé mekomejɔɔ́ ayi me ngare ne álá apyɛɛ́ fɔ́ genó ɛyigé me nké ji apyɛ wɔ́, me njɔ́gé fɔ́ nnó ji akwe mpa, néndé me nchwɔɔ́ fɔ́ fa mensɔ mpá bɔɔ́ mme wɔ́ nchwɔ́ lé mamfere ɛbwɔ́ né ɛfwyale gabo. ");
INSERT INTO anvNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Muú yi ashyaá nnó ji ákágé me, ne álá apyɛ genó ɛyigé me njɔɔ́, genó ɛyi gesɔ mpa wuú gelú wyɛɛ́. Ne genó ɛyi gesɔɔ́ mpá wuú né bií bi kwyakwya, ɛlé mekomejɔɔ́ wa ayi ngare. ");
INSERT INTO anvNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Nende Me njɔ́gé fɔ́ né uto ba. Ntɛ wa muú atɔme me agare me genó ɛyi me njɔ́gé ne ndɛre me mbɔɔ́ manjɔɔ́. ");
INSERT INTO anvNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Ne nkaá nnó genó ɛyigé ji aké me ngare gechwɔɔ́ ne geŋwá ɛyi gélágé byɛ́. Né getú ɛyigémbɔ, me njɔ́gé lé genó ɛyigé Ntɛ wa agare me nnó njɔɔ́.” ");
INSERT INTO anvNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Wyɛ ndɛre ɛpaá koó upú ɛlaá kwɔ́kwɔ́lé Jisɔs akaá nnó gébé ɛyigé ji alyagé mme yina nnó akere meso mbaá Ntɛ wuú gekwɔne. Ne ɛlé ji abɔɔ́ gejeé ne bɔɔ́ bií abi alú fa mme, alɛre ɛbwɔ́ gefɔɔ́ ɛyigé ji abɔɔ́ gejeé ne ɛbwɔ́. ");
INSERT INTO anvNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Ne ndɛre Jisɔs ajwɔle anyɛɛ́ menyɛɛ́ ne baá utɔɔ́ bií ne nkwale, danchomeló anyú mɛ metɔɔ́ maá utɔɔ́ Jisɔs ayi ama nnó achyɛɛ́ Jisɔs maŋkwaá. Ákuú maá utɔɔ́ yimbɔ nnó Judas Iscarot, maá Simun. ");
INSERT INTO anvNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Jisɔs akaá nnó Ntɛ wuú Ɛsɔwɔ afyɛ ji yɛ́ndégenó né amu. Akaá ntó nnó ji abɔ atane mbaá Ɛsɔwɔ ne ji akerege meso mbaá Ɛsɔwɔ. ");
INSERT INTO anvNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Ndɛre álú ányɛ́ menyɛ́, Jisɔs akwile tɛ́né, afeé nku yi mfaa abelé. Ani agbogbo né gebwɛ. ");
INSERT INTO anvNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Afane manaá né mmu geku, alɔ manshwɔne uka baá utɔɔ́ bií, ne atile ubi ne agbogbo ayi ji anií né gebwɛ. ");
INSERT INTO anvNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Akwɔnégé mbaá Simun Pita, Simun agií ji aké, “Ata ɔkɛlege manshwɔne me uka?” ");
INSERT INTO anvNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Ne Jisɔs ashuú ji meko aké, “Genó ɛyigé me mpyɛ mbɔ, ɛnyú dékáge fɔ́ ula nana, meso gébé dékage nyɛ.” ");
INSERT INTO anvNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Ajɔ́gémbɔ, Pita aké, “Ngba, wɔ ɔbɔ fɔ́ manshwɔne uka ɛba wɔ́.” Ne Jisɔs aké ne Pita, “Mbɔgé me nlá nshwɔne wɔ wɔ́, ɔchome fɔ́ mbwa ne me.” ");
INSERT INTO anvNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Ajɔ́gé mbɔ Simun Pita aké, “Ata ɔshwɔnege fɔ́ lé uka ba ubiubi, shwɔne ntó amu ya chonchó ne mekpo wa.” ");
INSERT INTO anvNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Jisɔs aké, “Muú yi awɔɔ́ mɛ manaá ábɔ́ mashwɔne lé uka bií ubiubi néndé menyammyɛ wuú alu mɛ pópó. Ne ɛnyú délu mɛ pópó, yɛ́mbɔ ɛnyú ako fɔ́ wɔ́.” ");
INSERT INTO anvNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Jisɔs ajɔɔ́ mbɔ, ji akaá mɛ muú ayi achyɛgé nyɛ ji maŋkwaá, ŋkaawu ne ji aké, “Ɛnyú ako depɔ fɔ́ pópó.” ");
INSERT INTO anvNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Ne ji anerege manshwɔne uka baá utɔɔ́ bií, abɔ nku wuú afyɛ, akere ajwɔle ká. Agií ɛbwɔ́ aké, “Ɛnyú dékaá ulaá genó ɛyigé mempyɛ mbɔ né ɛnyú?” ");
INSERT INTO anvNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","“Ɛnyú dékuú me menlɛre ne Ata. Ɛnyú délu cho mankú me mbɔ, néndé gɛ muú ayi me nlú mbɔ. ");
INSERT INTO anvNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Ne mbɔgé me, Ata ne menlɛre ɛnyú, nshwɔne ɛnyú uka, ɛnyú ntó debɔ manshwɔnege uka atɛ. ");
INSERT INTO anvNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Me nlɛre ɛnyú genó ɛyigé debɔɔ́ mampyɛge nnó dépyɛge geji ne atɛ ndɛre me mpyɛɛ́ ne ɛnyú. ");
INSERT INTO anvNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Me ngaregé ɛnyú wáwálé nnó, maá utɔɔ́ aŋeáge fɔ́ gemɛ apwɔ ntɛ wuú. Yɛ́ maá déntɔɔ́ ntó aŋeáge fɔ́ gemɛ apwɔ muú ayi atɔme ji. ");
INSERT INTO anvNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Nana ayi ɛnyú dékaá unó bina, déké dépyɛɛ́ ubi, débɛɛ́ ne metɔɔ́ megɔmegɔ. ");
INSERT INTO anvNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Me njɔ́gé mbɔ, ntome fɔ́ ne ɛnyú ako. Me nkaá ufɔɔ́ bɔɔ́ abi me njyaá. Yɛ́mbɔ mpyɛ mbɔ nnó genó ɛyigé ásame né mmu ŋwɛ Ɛsɔwɔ gétáné wawale. Ása wyɛ nno, ‘Muu yi ɛsé ne ji déchome ɛbwɔ menyɛɛ́, abwɔlé atɛne ummyɛ ne me’ ");
INSERT INTO anvNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Me ngarege ɛnyú genó ɛyigé na nana gemɛge nnó gepyɛ. Ne gébégé gepyɛge, ɛnyú dekamege nyɛ nnó, ‘Me Nlú gefɔge Muú ayi Me Nké Me Nlú.’ ");
INSERT INTO anvNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Me ngarege ɛnyú wáwálé nnó yɛ́ndémuú ayi asɛle muú dentɔɔ́ wa ne metɔɔ́ megɔ́mégɔ́, ɛbyɛnnó asɛ mbɔ lé me mbɔɔ́. Ne muú ayi asɛle me, asɛ mbɔ lé Ɛsɔwɔ muú átɔme me.” ");
INSERT INTO anvNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Jisɔs ajɔ́gé unó bina, metɔɔ́ ɛsɔ ji, agare gbɔgɔnɔ aké, “Me ngarege ɛnyú wáwálé, muú nyú ama achyɛge nyɛ me maŋkwaá.” ");
INSERT INTO anvNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Ajɔ́gé mbɔ baá utɔɔ́ bií álá meno mekpo fuú ápɛ atɛ ne amɛ ne amɛ. Ákágé yɛ́ muú ayi ji ajɔɔ́ atome ne ji. ");
INSERT INTO anvNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Ne maá utɔɔ́ ama, ayi Jisɔs agboó ne ji, agií mmyɛ né ɛkpokpogele kwɔ́kwɔ́lé ne uwyaá Jisɔs. ");
INSERT INTO anvNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Ne Simun Pita anyú meno aké, ne ji “Gií Jisɔs muú ayi ji ajɔɔ́ mbɔ atome ne ji.” ");
INSERT INTO anvNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Ndɛre maá utɔɔ́ yimbɔ, ajwɔle agií kwɔ́kwɔ́lé ne uwyaá Jisɔs, akɔ gemɛ agií Jisɔs aké, “Ata waá achyɛge nyɛ wɔ maŋkwaá?” ");
INSERT INTO anvNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Jisɔs ashuú ji meko aké, “ɛle muú ayi me nyuale brɛd yina né mmu akpáŋkpa nchyɛge ji. Jisɔs ajɔge mbɔ abɔ gekpɔge brɛd, anyuá né mmu akpáŋkpa achyɛ Judas Iscarot, maá Simun.” ");
INSERT INTO anvNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Tɛnétɛné ayi Judas asɛle gekpɔge brɛd ɛyigémbɔ, danchɔmeló anyú ji metɔɔ́. Ne Jisɔs ajɔɔ́ ne Judas aké, “Genó ɛyigé wɔ ɔkɛlege mampyɛ, pyɛ geji wáwá.” ");
INSERT INTO anvNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Né geluage bɔɔ́ abi ajwɔle agií né ɛkpokpogele, yɛ muú ama ayi akaá ulaá mejɔɔ́ ɛwé Jisɔs ajɔɔ́ mbɔ ne Judas apɔ. ");
INSERT INTO anvNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Ne ɛlé Judas ne ábélege mekwa ŋka bwɔ́. Baá utɔɔ́ abifɔ áfere nnó Jisɔs ajɔɔ́ mbɔ lé nnó Judas ajyɛ ána unó ɛbifɔ ɛbi ɛbwɔ́ ákɛlege. Ɛla ɛpɔ mbɔ wɔ́, ndɔfɔ Jisɔs ajɔɔ́ mbɔ lé nnó Judas ajyɛ achyɛ genó gefɔ mbaá ubya bɔɔ́. ");
INSERT INTO anvNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Ne Judas asɛge gekpɔge brɛd ɛyigé Jisɔs achyɛ ji, atane afɛ́. Gébé ɛyigémbɔ utuú ugi mɛ. ");
INSERT INTO anvNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Judas atanege ajyɛge, Jisɔs aké, “Nana bɔɔ́ agɛne nyɛ ndɛre Maá Ntɛ Mekwaá apwɔɔ́ amu. Ne ji apyɛ nyɛ bɔɔ́ agɛ ndɛre Ɛsɔwɔ apwɔɔ́ amu. ");
INSERT INTO anvNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Ne mbɔgé Maá Ntɛ Mekwaá apyɛɛ́ bɔɔ́ agɛ ndɛre Ɛsɔwɔ apwɔ amu, Ɛsɔwɔ ntó apyɛɛ́ nyɛ bɔɔ́ ágɛ́ ndɛre Maá Ntɛ Mekwaá apwɔɔ́ amu, ne achɔɔ́ sé gébé. ");
INSERT INTO anvNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Baá ba, me mbɛlege sé ne ɛnyú dɔɔ́, ɛnyú dékɛlege nyɛ me, ne wyɛ ndɛre me mbɔ ngare ákpakpa bɔɔ́ Jus, mbɔntó ne ngarege ɛnyú nana nnó, ‘Mbaá ayi me njyɛ ɛnyú dékage chwɔ́ fɔ́ wyɛɛ́.’ ");
INSERT INTO anvNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Ajɔ́gé mbɔ, aké, nana nchyɛge ɛnyú ɛbɛ ɛwé mekɛ́, “Bɔɔ́gé gejeé ne atɛ. Ndɛre me ngboó ne ɛnyú mbɔntó ne ɛnyú debɔɔ́ mangboge ne atɛ. ");
INSERT INTO anvNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Ne mbɔgé deké débɔɔ́ gejeé ne atɛ, yɛ́ndémuú ákáge nyɛ nnó ɛnyú délú baá utɔɔ́ ba.” ");
INSERT INTO anvNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Ne Simun Pita agií ji aké, “Ata, wɔ ɔjyɛ ɛfɔ?” Jisɔs aké, “Mbaá ayi me njyɛ ɔkágé kwɔle me nana, yɛ́mbɔ ɔkwɔlege nyɛ me meso gébé.” ");
INSERT INTO anvNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Pita agií ji aké, “Ata ulannó ne me nla nkágé kwɔle fɔ́ wɔ nana? Me nkpome mmyɛ mangbó gétú jyɛɛ́.” ");
INSERT INTO anvNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Ne Jisɔs ashuú Pita meko aké, “Pita nnó ɔkpome mmyɛ magbo gétú ya? Gɔ me ngare wɔ wáwálé nnó gemɛ nnó menɔ mekwɔ akú, wɔ ɔshyaá nyɛ máŋáne alɛɛ́ nnó wɔ ɔ́kágé me.” ");
INSERT INTO anvNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","“Dekamege fɔ́ mesome ɛbɛ ɛnyú né metɔɔ́. Fyɛgé metɔɔ́ ne Ɛsɔwɔ, fyɛgé ntó metɔɔ́ ne me. ");
INSERT INTO anvNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Baá upú alú gejame né gepúge Ntɛ wa; mbɔgé abɛ dampɔ mbɔ, mbɔ me ngare fɔ́ ɛnyú mbɔ wɔ́. Me njyɛ kwyɛɛ́ melú mbele ɛnyú. ");
INSERT INTO anvNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Nnerege mankwyɛɛ́ melú ɛwémbɔ, nkerege, nchwɔ́ nsɛ ɛnyú nnó mbaá ayi me mbɛɛ́ ɛnyú ntó débɛ wyɛɛ́. ");
INSERT INTO anvNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Ɛnyú dékaá meti ɛwé ɛjyɛɛ́ né mbaá yi me njyɛɛ́.” ");
INSERT INTO anvNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Ne Tɔmasi ajɔɔ́ ne Jisɔs aké, “Ata ɛse dékaá yɛ́ mbaá yi wɔ ɔjyɛɛ́ wɔ́, ɛpyɛmbɔ nnó ne dékaá meti ɛwé ɛjyɛ wyɛɛ́?” ");
INSERT INTO anvNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Jisɔs ashuú ji meko aké, “Me ne nlú meti ɛwú. Me ne ngarege bɔɔ́ wáwálé. Ne me ne nchyɛgé geŋwá. Yɛ́ muú fɔ ákágé chwɔ́ fɔ mbaá Ntɛ wa mbɔgé álá akoó ɛta wa wɔ. ");
INSERT INTO anvNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Mbɔgé ɛnyú débɔ dékaá me cháŋéné, mbɔ debɔ dékaá ntó ntɛ wa. Manlɔ́ nana déjyɛgé mbɛ, dékaá mɛ ji ne degɛ mɛ ji.” ");
INSERT INTO anvNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Ne Filip aké, “Ata lɛre ɛsé Ntɛ wyɛ awu, nnó matɔɔ́ akwene ɛse mmu.” ");
INSERT INTO anvNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Jisɔs ashuú ji meko aké, “Mbɔ tɛ me nlú mbɔ fana ne ɛnyú, delú daŋkaá me Filip? Yɛ́ndémuú yi agɛne me, ɛbyɛnnó agɛ ntó Ntɛ wa. Waá ulannó wɔ ɔké me nlɛre ɛnyú Ntɛ wa? ");
INSERT INTO anvNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Ɛnyú dékame fɔ́ nnó me ncho mmyɛ ne Ntɛ, ne Ntɛ wa ntó acho mmyɛ ne me wɔ? Depɔ ɛtire me njɔ́gé mbɔ, detanege fɔ́ me mbɔɔ́ né metɔɔ́, ɛlé Ntɛ wa mmu áchomé mmyɛ ne me ne apyɛɛ́ utɔɔ́ bií. ");
INSERT INTO anvNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Kamege ne me nnó genó ɛyigé me ngarege ɛnyú gelú wáwálé nnó me ncho mmyɛ ne Ntɛ wa ne Ntɛ wa ntó acho mmyɛ ne me. Ne mbɔgé ɛwéna ɛla ɛkwane ɛnyú metɔɔ́ wɔ, kamege nnó ɛlú wáwálé gétúgé ufélekpa ɛbi me mpyɛɛ́. ");
INSERT INTO anvNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Me ngarege ɛnyú wáwálé nnó, yɛ́ndémuú ayi áfyɛɛ́ metɔɔ́ ne me, apyɛɛ́ ntó unó bi me mpyɛɛ́ mbɔ. Yɛ́ ɛbɛ lé ɛbi uŋea upwɔ ɛbi, apyɛ nyɛ néndé me njyɛ́ mbaá Ntɛ wa. ");
INSERT INTO anvNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Ne yɛ́ndégenó ɛyigé ɛnyú dégigé né mabɔ ma, mpyɛ geji nnó metɔɔ́ ɛgɔ Ntɛ wa gétú ya. ");
INSERT INTO anvNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Ndɛre ɛlúmbɔ, mbɔgé dégige yɛ́ndégenó né mabɔ ma, mpyɛɛ́ geji. ");
INSERT INTO anvNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Mbɔgé ɛnyú dégbóo ne me, belege mabɛ ya. ");
INSERT INTO anvNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Dépyɛge mbɔ, me nnɛne nyɛ mmyɛ mbaá Ntɛ wa, ne ji atɔme nyɛ ɛnyú muú majyɛɛ́ ayifɔ, ayi abɛ nyɛ ne ɛnyú tɛ kwyakwya. ");
INSERT INTO anvNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Muú majyɛ yimbɔ ɛlé Mendoó Ukpea muú alɛrege ɛnyú wáwálé ayi Ɛsɔwɔ. Bɔɔ́ mme akamege fɔ ne ji néndé agɛne fɔ́ ji ne akage ji. Yɛ́mbɔ ɛnyú dékage ji, néndé ji ajwɔlege ne ɛnyú ne alú ɛnyú né mmyɛ. ");
INSERT INTO anvNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Njyɛge, nlyage fɔ ɛnyú gelame, nmáge kere nchwɔ ɛta nyú. ");
INSERT INTO anvNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Ɛla gachyɛɛ́ bɔɔ́ mme amage gɛ sé me. Ɛnyú ne dégɛne nyɛ me. Ne tɛ ndɛre me nwyaá geŋwá, ɛnyú ntó debɛɛ́ nyɛ ne geŋwá. ");
INSERT INTO anvNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Bií bimbɔ ukwɔnege, ɛnyú dékage nyɛ nnó mencho mmyɛ ne Ntɛ, Ntɛ wa acho mmyɛ ne me, ne me ntó ncho mmyɛ ne ɛnyú. ");
INSERT INTO anvNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Yɛ́ndémuú ayi awúgé mabɛ ya abelégé áji, ji yimbɔ ne abɔɔ́ gejeé ne me, Ntɛ wa ntó abɔɔ́ gejeé ne ji. Me ntó mbɔɔ́ nyɛ gejeé ne ji, ne me mbɔɔ́ nlɛrege nyɛ gemɛ ya ɛtaá wuú.” ");
INSERT INTO anvNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Ne Judas (ayi álá pɔ́ fɔ́ Judas Iscarot) ajɔɔ́ ne Jisɔs aké, “Ata nde gepyɛɛ wɔ ɔlɛrege gemɛ jyɛ lé ɛta sé, ayi ɔla ɔlɛrege fɔ́ ntó mbaá bɔɔ́ mme meko?” ");
INSERT INTO anvNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Jisɔs ashuú ji meko aké, “Muú ayi abɔɔ́ gejeé ne me, apyɛ geno ɛyigé me ngarege, Ntɛ wa gboó nyɛ ne ji. Ne ɛsé ne Ntɛ wa déchwɔ bane nyɛ ji déjwɔlé ne ji mbaá ama. ");
INSERT INTO anvNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Muú yi álá agboó ne me, apyɛ fɔ geno ɛyigé me ngarege. Ne unó bi ɛnyú déwuú mbɔ utane fɔ membɔɔ́ né metɔɔ́ wɔ, utane lé mbaá ntɛ wa muú atɔme me. ");
INSERT INTO anvNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Me ngare mbɔ ɛnyú unó bina nana yi me nlú ne ɛnyú. ");
INSERT INTO anvNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Yɛ́mbɔ Ntɛ wa atɔme nyɛ Menchyɛɛ́ majyɛɛ́ né mabɔ ma. Menchyɛɛ́ majyɛɛ́ yimbɔ ɛlé Mendoó Ukpea achwɔgé alɛrege nyɛ ɛnyú unó uko ne ateé nyɛ ɛnyú yɛ́ndégenó ɛyigé me ngare ɛnyú. ");
INSERT INTO anvNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“Ndɛre me njyɛ nchyɛge ɛnyú nesɔ, ne nesɔ na ne me nchyɛge ɛnyú. Me nchyɛge fɔ́ ɛnyú nesɔ na nkane bɔɔ́ mme achyɛge genó. Dekamégé fɔ matɔɔ achyɛge ɛnyú ɛfwyale, ne debɛge fɔ́ ntó ne ɛfɔ. ");
INSERT INTO anvNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Ɛnyú dewú nkane me nké, ‘Me nlyage ɛnyú. Yɛ́mbɔ nmage kere nyɛ nchwɔ ɛta nyú.’ Ɛbɛge nnó ɛnyú débɔɔ́ gejeé ne me, mbɔ́ débɛɛ́ ne metɔɔ́ megɔ́mégɔ́ ɛlé me njyɛɛ́ mbaá Ntɛ wa muú aŋea gemɛ apwɔɔ́ me. ");
INSERT INTO anvNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Me mbɔ́ mɛ mbɛ ngare ɛnyú unó bina gemɛge nnó ubi upyɛge, nnó meso gébé, upyɛge ɛnyú dekame nnó unó bi me njɔɔ́ úlú wáwálé. ");
INSERT INTO anvNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Me mpɔ sé ne gejamégé gébé manjɔɔ́ mejɔɔ́ ne ɛnyú néndé mfwa bɔɔ́ mme alé chwɔ. Ji apɔ́ fɔ́ ne ɛshyɛ apwɔ me. ");
INSERT INTO anvNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Yɛ́mbɔ me mpyɛɛ́ lé genó ɛyigé Ntɛ wa agare me nnó mpyɛ, nnó bɔɔ́ mme akaá nnó me mbɔɔ́ gejeé ne Ntɛ wa. “Kwilege mme déjyɛgé.” ");
INSERT INTO anvNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","“Me ne nlú genɔge vin geji ambɔɔ́, ne Ntɛ wa ne alú muú ayi áchɛ́rege geji. ");
INSERT INTO anvNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Yɛ́ndé ɛta ɛwé ɛtome ne me, mbɔgé ɛlá ɛwɔme fɔ́ umpome, ji asɔɔ́ ɛwuú afɔme mme, ne yɛ́ndé ɛta ɛwé ɛwɔme umpome, ji akwyɛge ɛwú nnó ɛwɔme gejamégé umpome. ");
INSERT INTO anvNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Mekomejɔɔ́ ayi me ngare ɛnyú apyɛ ɛnyú dela mɛ pópó ɛké ɛta genɔɔ́ ɛyigé akwyɛɛ́. ");
INSERT INTO anvNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Chogé wyɛ mmyɛ ne me, me nchome mmyɛ ne ɛnyú. Ɛta genɔɔ́ ɛ́kágé wɔ fɔ́ umpome mbɔgé ɛlá cho mmyɛ ne mbyɔ genɔɔ́ geji mbɔɔ́ wɔ́. Wyɛmbɔ ntó ne ɛnyú déla dekágé pyɛ genó gefɔ mbɔgé dela decho mmyɛ ne me wɔ́. ");
INSERT INTO anvNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Me ne nlú genɔɔ́ ɛyigémbɔ, ɛnyú ntó ne delú mata jií. Muú achogé mmyɛ ne me, ne me ntó nchoge mmyɛ ne ji, ji ne apyɛ nyɛ gejamégé unó néndé me nla mpɔ ɛnyú dékage pyɛ fɔ yɛ́ genó. ");
INSERT INTO anvNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Ne muú álá cho mmyɛ ne me wɔ, alú ɛké ɛta genɔɔ́ ɛwé ásɔgé afomege ɛ́wáŋese ɛgbo. Ufɔɔ́ mata unɔɔ́ yina anywerege áji áfyɛ né mewɛ, ásɔ. ");
INSERT INTO anvNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Mbɔgé ɛnyú déchogé wyɛ mmyɛ ne me, ne deké débelege mekomejɔɔ́ wa né matɔɔ́ nyú, yɛ́ndégenó ɛyi ɛnyú degige nno Ntɛ wa apyɛ, geji ne ji apyɛ́ ɛta nyu. ");
INSERT INTO anvNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Ɛnyú deké dépyɛ gejamégé unó ulɔúlɔ́ Ntɛ wa abɛɛ́ ne ŋgɔ. Ne ɛwéna ɛlɛrege nnó ɛnyú delu baá utɔɔ́ ba. ");
INSERT INTO anvNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Ndɛre Ntɛ wa abɔɔ́ gejeé ne me, mbɔntó ne me mbɔɔ́ gejeé ne ɛnyú. Bɔgé wyɛ gejeé ne atɛ wyɛ ndɛre me mbɔɔ́ ne ɛnyú. ");
INSERT INTO anvNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Mbɔgé ɛnyú deké depyɛ genó ɛyige me njɔɔ́, me mbɔɔ́ nyɛ gejeé ne ɛnyú wyɛ ndɛre Ntɛ wa abɔɔ́ gejeé ne me gétúgé mpyɛɛ́ genó ɛyigé ji akɛlege. ");
INSERT INTO anvNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Me ngaré ɛnyú unó bina nnó ɛnyú débɛ ne metɔɔ́ megɔmegɔ wyɛ ndɛre me nwyaá. Ne nnó metɔɔ́ megɔmegɔ nyú ɛja ɛpwɔ amu. ");
INSERT INTO anvNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Gɛgé genó ɛyigé me nkɛlege nnó ɛnyú dépyɛge na: Bɔgé gejeé ne atɛ wyɛ ndɛre me mbɔɔ́ ne ɛnyú. ");
INSERT INTO anvNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Gejeé ɛyigé cha gepɔ, ɛyigé muú alɛrege, ɛyi gepwɔɔ́ gejeé ɛyigé muú ágbóo gétúgé ajeé bií. ");
INSERT INTO anvNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Ɛnyú débɛɛ́ ajeé ba mbɔgé dépyɛ unó bi me ngaré ɛnyú. ");
INSERT INTO anvNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Me mmagé kú se ɛnyú nnó baá défwɛ néndé maá défwɛ ákágé fɔ́ genó ɛyigé ntɛ wuú apyɛɛ́. Me nkuú ɛnyú ajeé ba néndé yɛ́ndégenó ɛyigé Ntɛ wa agare me, geji ne me nto ngare ɛnyú. ");
INSERT INTO anvNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Ɛnyú fɔ́ wɔ déjyaá me wɔ, ɛlé me ne njyaá ɛnyú ne ntɔme ɛnyú nnó dépyɛgé unó ulɔ́úlɔ́ ne nnó unó bimbɔ ubɛɛ́ tɛ kwyakwya. Ne yɛ́ndégenó ɛyi ɛnyú dégige Ntɛ wa né mabɔ ma achyɛge ɛnyú geji. ");
INSERT INTO anvNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Gɛge yɛ mma ngare ɛnyú nnó bɔge gejeé ne atɛ. ");
INSERT INTO anvNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Mbɔgé bɔɔ́ mme apaá ɛnyú, kaáge nnó abɔ mɛ mbɛ apa mɛ me ne alé pa ɛnyú. ");
INSERT INTO anvNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Ɛnyú debɔ débɛ́ bɔɔ́ mme, mbɔ bɔɔ́ mme agboó ne ɛnyú ɛké atɛ bɔɔ́ mme. Ne ɛnyú depɔ néndé me njya ɛnyú né geluage bɔɔ́ mme, getu ɛyigémbɔ ne bɔɔ́ mme apaá ɛnyú. ");
INSERT INTO anvNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Tege genó ɛyigé me ngare ɛnyú nnó, ‘Maá défwɛ aŋeage fɔ́ gemɛ apwɔ ntɛ wuú.’ Tɛ ndɛre ɛbwɔ́ achyɛ me ɛfwyale, áchyɛge nyɛ ntó ɛnyú ɛfwyale. Ne ɛbwɔ́ abɔ awú mekomejɔɔ́ wa mbɔ áwuú ntó awe nyú. ");
INSERT INTO anvNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Ɛbwɔ́ apyɛ nyɛ unó bina uko ɛta nyú gétúgé ɛnyú délu bɔɔ́ ba. Néndé ɛbwɔ́ ákágé fɔ́ muú yi atɔme me. ");
INSERT INTO anvNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Me mbɛ danchwɔ́ gare ɛbwɔ́ mekomejɔɔ́, mbɔ akwe fɔ mpa wɔ́, yɛ́mbɔ nana yi ngare ɛbwɔ mekomejɔɔ Ɛsɔwɔ, yɛ meti ɛwe áboó gabo bwɔ́ ɛpɔ́sé ");
INSERT INTO anvNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Ne yɛ́ndémuú yi apaá me, ɛbyɛnnó apaá ntó Ntɛ wa. ");
INSERT INTO anvNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Me mbɛ dampyɛ ukpɛkpɛ unó né metɔɔ́ metɔɔ́ bwɔ́, ɛbwɔ́ agɛ wɔ́, ɛbi yɛ́ muú fɔ́ álá alú dampyɛ, mbɔ Ɛsɔwɔ agarege nyɛ fɔ́ ɛbwɔ́ nnó ápyɛ gabo ákwe mpa. Yɛ́ ndɛre ɛbwɔ́ ágɛne unó bi me mpyɛ, ápaá me chonchó ne Ntɛ wa. ");
INSERT INTO anvNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Unó bina ubɔ mampyɛ nnó, genó ɛyigé asame né mmu ŋwɛ Ɛsɔwɔ gebɛ wáwálé. Ása wyɛ nnó, ‘Ɛbwɔ́ ápaá me ula pɔ́.’ ");
INSERT INTO anvNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Menchyɛɛ́ majyɛɛ́ achwɔɔ́, ji alú Mendoó Ukpea muú alɛrege wáwálé yi Ɛsɔwɔ. Me ntɔme nyɛ ji atane mbaá Ntɛ wa, achwɔgé agarege nyɛ ɛnyú muú yi me nlú. ");
INSERT INTO anvNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Ɛnyú ntó dégarege nyɛ bɔɔ́ muú yi me nlú néndé delu ne me tɛ ula ulɔɔ́. ");
INSERT INTO anvNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Me ngare mɛ ɛnyú unó bina nnó ɛ́kágé deja mmyɛ meso. ");
INSERT INTO anvNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Ábuú nyɛ ɛnyú né macha mmyɛmenɛne. Ne gébé gechwɔɔ́ ɛyigé yɛ́ndémuú yi awáne ɛnyú afɛrege nnó ji apyɛmbɔ ɛlé utɔɔ́ Ɛsɔwɔ. ");
INSERT INTO anvNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Ápyɛ nyɛ unó bina ne ɛnyú néndé ákágé Ntɛ wa, yɛ́ me ntó ákágé. ");
INSERT INTO anvNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Me mbɔ mbɛ ngare ɛnyú nnó gébé ɛyigémbɔ gekwɔnége ɛnyú détege nnó me mbɔ ngare mɛ ɛnyú nnó unó bina upyɛɛ́ nyɛ. “Me mbɔ́ ngare ɛnyú unó bina mbɛmbɛ wɔ́, néndé me mbɔ nlú ne ɛnyú. ");
INSERT INTO anvNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Ne nana me nkerege meso mbaá muú yi atɔme me, yɛ́mbɔ yɛ́ muú nyú yi agige mme nnó, “Ɔjyɛ ɛfɔ́?” Apɔ. ");
INSERT INTO anvNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Ne gétúgé me ngare ɛnyú unó bina, matɔɔ́ nyú álá meshwɛmeshwɛ. ");
INSERT INTO anvNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Yɛ́mbɔ ngarege ɛnyú wáwálé. Ɛlú ɛlé né galɔ́gálɔ́ awe nyú nnó me njyɛ, néndé me nla njyɛ wɔ́ menchyɛɛ́ majyɛɛ́ achwɔɔ́ fɔ́ ɛta nyú. Yɛ́mbɔ me njyɛge ntɔme nyɛ ji achwɔ ɛta nyú. ");
INSERT INTO anvNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Achwɔgé apyɛɛ́ nyɛ bɔɔ́ mme akaá nnó ufɛre bwɔ́ né gabo ayi ɛbwɔ́ apyɛɛ́ úlú gyɛ. Apyɛ nyɛ ɛbwɔ́ akaá nnó ufɛre bwɔ́ né ndɛre muú abɛɛ́ cho né mbɛ ushu Ɛsɔwɔ úlú gyɛɛ́, ne apyɛ nyɛ ntó ɛbwɔ́ akaá nnó ufɛ́ré bwɔ́ né ndɛre Ɛsɔwɔ ásɔɔ́ nyɛ mpa úlú gyɛɛ́. ");
INSERT INTO anvNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Né ɛgbɛ ɛwé gabo, ɛbwɔ́ alú gyɛɛ́ néndé áfyɛɛ́ fɔ́ metɔɔ́ ne me wɔ́. ");
INSERT INTO anvNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Né ɛgbɛ ɛwé mambɛ cho né mbɛ ushu Ɛsɔwɔ, apyɛ nyɛ ɛbwɔ́ akaá nnó me nlú cho néndé me nkerege meso mbaá Ntɛ wa ne ɛnyú demage gɛ nyɛ se me. ");
INSERT INTO anvNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Né ɛgbɛ ɛwé mpa ayi Ɛsɔwɔ ásɔɔ́, apyɛ nyɛ bɔɔ́ mme akaá nnó alu gyɛɛ́ né gefɔɔ́ ɛyigé ásɔɔ́ mpa wa, néndé danchɔmeló mfwa bɔɔ́ mme akwe mɛ mpa. ");
INSERT INTO anvNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Me nlú wyaá gejamégé unó mangare ɛnyú, yɛ́mbɔ ɛnyú dékage gbare nyɛ fɔ matɔɔ́ gétúgé ubi. ");
INSERT INTO anvNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Yɛ́mbɔ gébégé Mendoó Ukpea muú alɛrege wáwálé achwɔge, apyɛ nyɛ ɛnyú dékaá wáwálé meko. Agarege nyɛ fɔ́ unó bi utanege ji metɔɔ́, genó ɛyigé ji awúgé geji ne ji ágarege. Ne apyɛɛ́ nyɛ ɛnyú dékaá unó bi upyɛɛ́ nyɛ meso gébé. ");
INSERT INTO anvNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Ji apyɛ́ nyɛ me mbɔ ŋgɔ néndé genó ɛyi getanege me metɔɔ́ geji ne ji asɛle agarege ɛnyú. ");
INSERT INTO anvNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Yɛ́ndé genó ɛyigé Ntɛ wa awyaá ɛlé ɛya, getú ɛyigémbɔ ne me nké genó ɛyi gelú me metɔɔ́ geji ne ji agarege nyɛ ɛnyú. ");
INSERT INTO anvNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“Ɛlá gachyɛɛ́ ɛnyú demage gɛ sé me, ne ɛmage wyaá sé ntó ndɔɔ́ ɛnyú degɛne nyɛ me.” ");
INSERT INTO anvNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Ajɔ́gé mbɔ, baá utɔɔ́ bií abifɔ alɔ mangigé atɛ aké, “Ajɔɔ́ aké, ‘Ɛla gachyɛ ɛnyú degɛne sé me,’ ne ama aké, ‘Ɛmage wyaá se ntó dɔɔ́ ɛnyú dégɛne nyɛ me’, ula utɛne mbɔ nno? ne ulaa me njyɛ mbaá ntɛ wa. ");
INSERT INTO anvNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Ulaá ɛla gachyɛɛ́ utɛne mbɔ nnó? Ɛsé dekágé fɔ́ genó ɛyigé ji ajɔ́gé mbɔ.” ");
INSERT INTO anvNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Ndɛre ɛbwɔ́ áferege mbɔ, Jisɔs akaá mɛ nnó ɛbwɔ́ akɛlege mangií ji ulaá mejɔɔ́ ɛwé ji ajɔɔ́ mbɔ. Ajɔɔ́ ne ɛbwɔ́ aké, “Ɛnyú degige mbɔ ɛlé atɛ ulaá mejɔɔ́ ɛwé me njɔɔ́ nnó, ‘ɛla gachyɛɛ́ ɛnyú demage gɛ sé me ne nnó ɛmage wyaá sé ntó dɔɔ́ ɛnyú dégɛne nyɛ me?’ ");
INSERT INTO anvNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Me ngarege ɛnyú wáwálé nnó ɛnyú delilí nyɛ desɔɔ́ manse gétúgé unó bi upyɛ nyɛ. Ne bɔɔ́ mme ábɛɛ́ ne nechɔ́chɔ́, Ɛnyú debɛɛ́ ne masome né matɔɔ́, yɛ́mbɔ masome nyú abwɔlege nyɛ nechɔ́chɔ́. ");
INSERT INTO anvNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Nebyɛɛ́ neke nemmyɛ mendée, unɛ ugyalege ji néndé gébé ɛyigé ji awuú ubale gekwɔne. Ne abyɛgé mɛ maá, amage te se ubale, abɛɛ́ ɛlé ne nechɔ́chɔ́ nnó ji agbɛɛ́ muú ama fa mme. ");
INSERT INTO anvNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Wyɛmbɔ ntó ne ɛlú ne ɛnyú. Nana ɛnyú delú ne masome né matɔɔ́, yɛ́mbɔ me mmage gɛ nyɛ ɛnyú, ne ɛnyú debɛɛ́ nyɛ ne nechɔ́chɔ́ né matɔɔ́. Ne yɛ́ muú ayi akágé fere gefɔ nechɔ́chɔ́ ɛniné na né matɔɔ́ nyú ápɔ́. ");
INSERT INTO anvNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Bií bi mbɔ ukwɔnege, demage gii se me yɛ mechɔ fɔ́. Me ngarege ɛnyú wáwálé nnó, yɛ́ndégenó ɛyi degige ntɛ wa né mabɔ ma, achyɛge ɛnyú geji. ");
INSERT INTO anvNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Kpaá tɛ gébé ɛyigé na, ɛnyú delu dangií yɛ́ genó gefɔ́ né mabɔ ma. Gige achyɛge nyɛ ɛnyú, ne nechɔ́chɔ́ nyú nejame nyɛ kpaá nepwɔ́. ");
INSERT INTO anvNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Me ngare ɛnyú unó bina né makamejɔɔ́, yɛ́mbɔ gébé gechwɔɔ́ nyɛ ɛyigé me nla ngarege sé ɛnyú depɔ né makamejɔɔ́. Me ngarege nyɛ ɛnyú uno bi utome ne Ntɛ wa gbɔgɔnɔ. ");
INSERT INTO anvNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Gébé ɛyigémbɔ gekwɔnege ɛnyú degige nyɛ Ntɛ wa unó né mabɔ ma. Me njɔɔ́ mbɔ fɔ́ nnó ngige nyɛ Ntɛ wa genó gefɔ gétúgé nyú wɔ́. ");
INSERT INTO anvNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Néndé Ntɛ wa jimbɔɔ́ abɔ gejeé ne ɛnyú gétúgé ɛnyú debɔɔ́ gejeé ne me, ne dékame nnó me ntane mbaá Ɛsɔwɔ. ");
INSERT INTO anvNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Wáwálé me ntane mbaá Ntɛ wa nchwɔɔ́ fa mme. Nana me lé nlyaá mme nkerege meso mbaá Ntɛ wa.” ");
INSERT INTO anvNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Ajɔ́gé mbɔ, baá utɔɔ́ bií aké, “Nana wɔ ɔlé jɔɔ́ yɛ́ mejɔɔ́ gbɔgɔnɔ, ɔjɔ́gé sé né makamejɔɔ́. ");
INSERT INTO anvNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Ɛsé dékaá nana nnó wɔ ɔkaá unó uko, wɔ ɔkage yɛ ɛbɛ lé unó bi bɔɔ́ awyaa né metɔɔ mangií wɔ. Ɛwéna ɛpyɛ ɛsé dékamé nnó wɔ ɔtane mbaá Ɛsɔwɔ.” ");
INSERT INTO anvNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Ne Jisɔs ashuú ɛbwɔ́ meko aké, “Pɔ́ ɛnyú dékamé ne me, naná? ");
INSERT INTO anvNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Gébé gechwɔɔ́ nyɛ, ne géfií mɛ ɛyigé ɛnyú ako délaá nyɛ tyátyá, yɛ́ndémuú nyú abɔɔ́ nyɛ meti gepú jií, délyaá membií. Yɛ́mbɔ me mpɔ fɔ́ me mbií, Ntɛ wa alú ne me. ");
INSERT INTO anvNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Me ngare ɛnyú unó bina nnó ɛnyu delií mmyɛ ne me debɛ ne nesɔ. Bɔɔ́ mme apyɛ nyɛ ɛnyú degɛ ɛfwyale yɛ́mbɔ gbarege matɔɔ́ nyú néndé mmyɛ mɛ mpwɔ bɔɔ́ mme.” ");
INSERT INTO anvNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Jisɔs anerege manjɔɔ́ unó bina, abwɛɛ́ amɛ apɛ né mfaánebuú, anɛmmyɛ aké, “Ntɛ wa gébé gekwɔne pyɛ me maá wyɛɛ́ mbɔ ŋgɔ nnó me ntó mpyɛ wɔ ɔbɛ ne ɛnoge. ");
INSERT INTO anvNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Wɔ ɔchyɛɛ́ me uto bi upwɔ bɔɔ́ ako nnó me nchyɛɛ́ geŋwá ɛyi gélágé byɛ́ mbaá bɔɔ́ ako abi wɔ ɔchyɛɛ́ me. ");
INSERT INTO anvNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Geŋwá ɛyi gélágé byɛ́ gelu nnó ɛbwɔ́ akaá ɛlé wɔ mbií muú ɔlu Ɛsɔwɔ ayi wáwálé, ne me Jisɔs Kras muú wɔ ɔtɔme fa mme. ");
INSERT INTO anvNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Mpyɛ wɔ ɔbɔ ɛnógé fa né mme, gétúge me nɛre mampyɛ utɔɔ́ bi wɔ ɔchyɛɛ́ me nnó mpyɛ. ");
INSERT INTO anvNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Ntɛ wa, pyɛ me mbɛ ne ɛnóge né mbɛ ushu wyɛ nana, gefɔ́gé ɛnógé ɛwé me mbɔ nwya nya gébégé nlú ne wɔ, gemɛge nnó mme álɔ. ");
INSERT INTO anvNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Me mpyɛ bɔɔ́ abi wɔɔ jyaá fa mme ɔchyɛɛ́ me akaá wɔ. Ábɔ́ álú bɔɔ́ byɛɛ́, wɔ ɔchyɛɛ́ me ɛbwɔ́ ne ɛbwɔ ábele mekomejɔɔ́ wyɛɛ́. ");
INSERT INTO anvNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Ne nana ɛbwɔ ákaá nnó ufɔɔ́ unó uko bi wɔ ɔchyɛɛ́ me utane ɛta wyɛ. ");
INSERT INTO anvNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Ngare ɛbwɔ́ mekomejɔɔ́ ayi wɔ ɔchyɛɛ́ me, ásɛ ji amu apea ne ákaá wáwálé nnó me ntane ɛta wyɛɛ́ ne ákame nnó wɔ ne ɔtɔme me. ");
INSERT INTO anvNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“Nnɛnemmyɛ gétúgé ɛbwɔ́. Nnɛne fɔ́ mmyɛ gétúgé bɔɔ́ mme, nnɛne lé gétúgé bɔɔ́ abi wɔ ɔchyɛɛ́ me, néndé álú bɔɔ́ byɛɛ́. ");
INSERT INTO anvNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Yɛ́ndé genó ɛyi nwyaá ɛlé ɛjyɛɛ́ ne yɛ́ndégenó ɛyi wɔ ɔwyaá, ɛle ɛya. Ne ɛle bɔɔ́ bina ne apyɛɛ́ me mbɔɔ́ ɛnógé. ");
INSERT INTO anvNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Mbɛɛ́ sé fa mme, yɛ́mbɔ ɛbwɔ́ alú fa mme. Nchwɔɔ́ ɛta wyɛɛ́ Ntɛ wa, Muú Ukpea, nnɛnemmyɛ nnó wɔ ɔbame ɛbwɔ́ né uto mabɔ mmyɛɛ́, ami wɔ ɔchyɛɛ́ me, nnó ɔpyɛ ɛbwɔ́ ábɛ́ muú ama ndɛre ɛsé ne wɔ delu muú ama. ");
INSERT INTO anvNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Gébégé nlú ne ɛbwɔ́, mbáme ɛbwɔ́ né utó mabɔ ami wɔ ɔchyɛɛ́ me. Mbá ɛbwɔ́ cháŋéné, ne yɛ́ muú bwɔ́ ama anó mme detu wɔ́ ɛkose muú ayi abɔ alú mɛ nnó anome mme detu nnó genó ɛyigé ásame né mekomejɔɔ́ wyɛɛ́ gebɛ wáwálé. ");
INSERT INTO anvNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","“Ne nana me nlé chwɔɔ́ ɛta wyɛɛ́. Ne njɔ́gé unó bina ndɛre me nlú fa mme, nnó mpyɛ ɛbwɔ́ abɛ ne nechɔ́chɔ́ gbɛne wyɛ ndɛre me nwyaá nechɔ́chɔ́ gbɛne. ");
INSERT INTO anvNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Me ngare ɛbwɔ́ mekomejɔɔ́ wyɛɛ́ ne bɔɔ́ mme apaá ɛbwɔ́ néndé ɛbwɔ́ ápɔ́fɔ́ mbwa ama ne bɔɔ́ mme wyɛ ndɛre me nlá pɔ́ fɔ́ mbwa ama ne bɔɔ́ mme. ");
INSERT INTO anvNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Me nnɛne fɔ́ mmyɛ nnó wɔ ɔfere ɛbwɔ́ fa mme. Nnɛne lé nnó wɔ ɔbame ɛbwɔ́ ɛ́kágé ɛbwɔ́ akpɛ né amu muú nchyɛ. ");
INSERT INTO anvNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Ɛbwɔ́ apɔ́ fɔ́ mbwa ama ne bɔɔ́ mme wyɛ ndɛre me nlá pɔ́ fɔ́ mbwa ama ne bɔɔ́ mme. ");
INSERT INTO anvNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Pyɛ ɛbwɔ́ áchyɛɛ́ gemɛ́ge bwɔ́ wáwálé ɛta wyɛ. Ne wáwálé yimbɔ ɛlé mekomejɔɔ́ wyɛɛ́. ");
INSERT INTO anvNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Ndɛre wɔ ɔtɔme me fa né mme, mbɔntó ne me ntɔme ɛbwɔ́. ");
INSERT INTO anvNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Me nchyɛ gemɛ ya mampyɛ utɔɔ́ byɛɛ́. Me mpyɛ mbɔ gétúgé bwɔ́, nnó ɛbwɔ́ ntó áchyɛɛ́ gemɛ́ge bwɔ́ wáwálé mampyɛ utɔɔ́ byɛɛ́. ");
INSERT INTO anvNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Me nnɛne fɔ́ mmyɛ gétúgé baá utɔɔ́ baá bina ɛbwɔ́ bwɔ́, nnɛne ntó gétúgé bɔɔ́ abi áfyɛ nyɛ metɔɔ́ ne me ɛlé áwuú mekomejɔɔ́ wyɛ ayi baá utɔɔ́ ba ágarege nyɛ. ");
INSERT INTO anvNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Me nnɛnemmyɛ nnó wɔ ɔpyɛ́ ɛbwɔ́ ako abɛ muú ama, wyɛ ndɛre wɔ Ntɛ wa ɔlu muú ama ne me, me ntó nlu muú ama ne wɔ. Pyɛ ɛbwɔ́ abɛ muú ama ne ɛsé nnó, bɔɔ́ mme ákamé nnó wɔ ne ɔtɔme me. ");
INSERT INTO anvNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Ɛnógé ɛwé wɔ ɔchyɛɛ́ me, ɛwú ntó ne me nchyɛɛ́ ɛbwɔ́. Mpyɛ mbɔ nnó ɛbwɔ́ abɛ muú ama wyɛ ndɛre ɛsé ne wɔ delú muú ama. ");
INSERT INTO anvNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Me nlu muú ama ne ɛbwɔ́, wɔ ntó ɔlu muú ama ne me. Dépyɛ mbɔ nnó ɛbwɔ́ ntó abɛ muú ama cháŋéné. Ndɛre ɛlúmbɔ bɔɔ́ mme ákágé nyɛ nnó wɔ ne ɔtɔme me, ne ákágé nyɛ ntó nnó wɔ ɔbɔɔ́ gejeé ne ɛbwɔ́ wyɛ ndɛre wɔ ɔbɔɔ́ gejeé ne me. ");
INSERT INTO anvNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Ntɛ wa, nkɛlege ntó nnó bɔɔ́ abi wɔ ɔchyɛɛ́ me, ábɛ ne me né mbaá yi me mbɛɛ́ nyɛ, nnó ágɛ́ ntó ɛnógé wa. Wɔ ɔchyɛɛ́ me ɛnógé ɛwéna gétúgé gejeé ɛyigé wɔ ɔbɔɔ́ ne me gemɛge nnó mme alɔ. ");
INSERT INTO anvNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","“Ɛh, Ntɛ wa muú ɔlú cho, wáwálé, bɔɔ́ mme ákágé fɔ́ wɔ, yɛ́mbɔ me nkágé wɔ. Ne bɔɔ́ bina, abi wɔ ɔchyɛɛ́ me ákaá ntó nnó wɔ ne ɔtɔme me. ");
INSERT INTO anvNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Me mpyɛ ɛbwɔ́ ákaá wɔ, ne mpyɛ nyɛ wyɛ ɛbwɔ́ ákágé wɔ yɛ́ndégébé nnó gejeé ɛyigé wɔ ɔbɔɔ́ ne me ɔbɔ ntó ne ɛbwɔ́ ne nnó me mbɛ muú ama ne ɛbwɔ́.” ");
INSERT INTO anvNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Jisɔs anerege mmyɛmenɛne, ji ne baá utɔɔ́ bií ályaá melu ɛwémbɔ, achyaá geŋkɔ ɛyigé akuú nnó Kidrɔn ajyɛ kpɛ mmu maá mekɔɔ́ fɔ. ");
INSERT INTO anvNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Ne Judas muú achyɛge nyɛ Jisɔs maŋkwaá abɔ akaá ntó melu ɛwémbɔ néndé ɛbwɔ́ abɔ áchómege mɛ wyɛ. ");
INSERT INTO anvNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Ndɛre ɛlúmbɔ, ji asɛ ɛkwɔ bɔɔ́ bee ne ambame ɛcha upɛ Ɛsɔwɔ abi anɔɔ́ baá ámpyɛɛ́ upɛ Ɛsɔwɔ ne Farasi átɔme áchwɔ́ né maá mekɔɔ́ yimbɔ. Gébégé ájyɛɛ́ ákpomé mmyɛ ne unó ummyɛ, alwɛɛ́ desá ne bɔ akpɔgéfo. ");
INSERT INTO anvNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Ne ɛlé Jisɔs akaá mɛ yɛ́ndégenó ɛyigé ápyɛ nyɛ ne ji, ake mmyɛ afií ɛbwɔ́, agií ɛbwɔ́ aké, “Ɛnyú dékɛlege ndé muú?” ");
INSERT INTO anvNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Ashuú ji meko aké, “Dékɛlege Jisɔs muú Nasarɛt.” Ji aké, “Me ne nlu ji.” Judas muú achyɛɛ́ Jisɔs maŋkwaá alú ntó ɛfɛɛ́ tɛné ne ɛbwɔ́. ");
INSERT INTO anvNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Jisɔs ajɔ́gé ne ɛbwɔ́ nnó, “Me ne nlu ji,” ája mmyɛ meso ákwe mme gbaram. ");
INSERT INTO anvNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Ne ama agií ɛbwɔ́ aké, “Ɛnyú déke dékɛlege wa?” Áké, “Dékɛlege Jisɔs muú Nasarɛt.” ");
INSERT INTO anvNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Aké, “Pɔ́ me ngare ɛnyú nnó me ne nlu ji? Ne mbɔgé nnó ɛlé me ne ɛnyú dékɛlege, lyage bɔɔ́ bina ájyɛ. ");
INSERT INTO anvNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Ajɔɔ́ mbɔ nnó meko ayi ji abɔ ajɔɔ ábɛ́ wáwálé. Ji abɔ ajɔɔ́ aké, Ntɛ yɛ́ muú ama ayi anome mme detú né geluage bɔɔ́ abi ɔchyɛɛ́ me ápɔ́.” ");
INSERT INTO anvNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Ne Simun Pita ajú yɛ́ aparanja ayi ji awyaá, asɔ́ ɛtu ɛwé ɛgbɛ́ ɛbwɔnyɛ ɛwé memfwɛ́ ɛtukpɛ ámpyɛɛ́ upɛ Ɛsɔwɔ. Mabɔ memfwɛ́ yimbɔ makamege Malkɔs. ");
INSERT INTO anvNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Pita apyɛgé mbɔ, Jisɔs ajɔɔ́ ne ji aké, “Shwɔ́ré aparanja wyɛ yimbɔ né mmu mekɔ́, wɔ ɔkɛlege fɔ́ nnó me ngɛ ɛfwyale ndɛre ntɛ wa ake ngɛ?” ");
INSERT INTO anvNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Ndɛre ɛlúmbɔ, muú kpaá bɔɔ́ bee ne bɔɔ́ bee bií chonchó ne ambame ɛcha upɛ Ɛsɔwɔ apyɛ Jisɔs awɛ ji amu. ");
INSERT INTO anvNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Asɛ ji ábɔ́ mbɛ afɛ né mbaá Anas ntɛ Mendée Kaifas. Kaifas yina ne alú ɛtúkpɛ ampyɛ upɛ Ɛsɔwɔ né ŋmɛ ɛniné mbɔ. ");
INSERT INTO anvNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Ɛlé Kaifas yina ntó ne abɔ achyɛɛ́ nya bɔɔ́ Jus majyɛɛ́ nnó, “Ɛlú galɔ́gálɔ́ nnó muú ama agbo gétúgé bɔɔ́ ako.” ");
INSERT INTO anvNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simun Pita ɛbwɔ́ ne maá utɔɔ́ Jisɔs yifɔ ama akwɔle Jisɔs meso. Ɛtukpe ampyɛ upɛ Ɛsɔwɔ akaá maá utɔɔ́ yimbɔ cháŋéné, getu ɛyigémbɔ ályaá maá utɔɔ́ yimbɔ akpɛ ne Jisɔs né mmu dachi ɛtukpe ampyɛɛ́ upɛɛ́ Ɛsɔwɔ, ");
INSERT INTO anvNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Pita álá né dafyɛ. Ndɛre Pita atɛne né dafyɛ, maá utɔɔ́ ayi ɛtukpe ampyɛ upɛ Ɛsɔwɔ akaá ji, ajyɛ bane mesɔ mendée ayi alú menombi gébame, ajɔɔ́ mejɔɔ́ ne ji ne mesɔ mendée yimbɔ alyaá Pita akpɛ muu. ");
INSERT INTO anvNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Mesɔ mendée yimbɔ né meno gebame agií Pita aké, “Nnó wɔ ɔpɔ́fɔ́ maá utɔɔ́ ama né geluage baá utɔɔ́ Jisɔs?” Pita ashuú ji meko aké, “Ɛɛh, me mpɔ́.” ");
INSERT INTO anvNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Gébé ɛyigémbɔ ntó gefwene gemmyɛɛ́, baá défwɛ ne ambame dachi ɛtukpe ásené mewɛ né dafyɛ átɛne áwyaá. Pita ntó abɔ alú ne ɛbwɔ́ áwyaá mewɛ. ");
INSERT INTO anvNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Ɛtukpɛ ɛgií Jisɔs depɔ ɛtiré détóme ne baá utɔɔ́ bií ne unó bi ji álɛ́rege. ");
INSERT INTO anvNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Jisɔs ashuú ji meko aké, “Me njɔ́gé mɛ mejɔɔ́ gbɔgɔnɔ mbaá bɔɔ́ ako. Me nlɛrege unó yɛ́ndégébé né mmu macha mmyɛmenɛne ne ɛcha upɛ Ɛsɔwɔ mbaá ayi bɔɔ́ Jus ako áchómege. Yɛ́ genó gefɔ ɛyigé me njɔɔ́ bibí gepɔ́. ");
INSERT INTO anvNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Ulannó wɔ ɔgigé me bɔ ŋkwɛ bina? Gií ɛlé bɔɔ́ abi awuú genó ɛyigé me ngare ɛbwɔ́, neńdé ákaá uno bi me njɔɔ́.” ");
INSERT INTO anvNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Jisɔs ajɔ́gé mbɔ, membame dachi ɛtukpe ayi alu fií ado ji né ushu. Agií ji aké, “Mbɔ ne wɔ ɔbɔɔ́ manshuú ɛtukpe meko?” ");
INSERT INTO anvNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Jisɔs ashuú ji meko aké, “Mbɔgé mechɔ ɛwé me njɔɔ́ ɛlú gyɛɛ́, gare gabo ayi me njɔɔ́. Ne mbɔgé ɛlú cho, ulannó wɔ ɔdoó me.” ");
INSERT INTO anvNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Ɛfɛɛ́ ne Anas atɔme yɛ́ Jisɔs wyɛ amuú wɛwɛ mbaá Kaifas ɛtukpe ampyɛ upɛ Ɛsɔwɔ. ");
INSERT INTO anvNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Ndɛre ɛpyɛmbɔ, Pita abɔ alú né dafyɛ tɛné awyaá mewɛ. Ágií ji aké, “Nnó wɔ ntó ɔpɔ́ fɔ́ maá utɔɔ́ ama né geluage baá utɔɔ́ Jisɔs?” Pita ashya aké, “Ɛɛh me mpɔ́”. ");
INSERT INTO anvNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Maá defwɛ ɛtukpe ampyɛ upɛɛ́ Ɛsɔwɔ ama ayi alú meŋmɛ muú ayi Pita asɔɔ́ ji ɛtu, agií Pita aké, “Nnó me ngɛ fɔ́ wɔ né mmu maá mekɔɔ́ ne mende yimbɔ wɔ́?” ");
INSERT INTO anvNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Pita ama ashya wyɛ shyá. Wyɛ né gébé ɛyigémbɔ menɔ mekwɔ akú kɔkɔgɔlɔ́kɔɔ́. ");
INSERT INTO anvNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Bií ujyagé ne dondo gemua mme ákpakpa bɔɔ́ Jus asɛ yɛ́ Jisɔs né gepúge Kaifas afɛ́ ne ji né ɛcha gɔmena bɔɔ́ Rom. Ɛbwɔ́ ambɔɔ́ akpɛ wyɛ wɔ́. Apyɛ mbɔ nnó ɛ́kágé ɛbwɔ́ ábɛ́ ne deba né mbɛ ushu Ɛsɔwɔ néndé akɛlege manyɛ́ ɛpaá koó upú. ");
INSERT INTO anvNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Ndɛre ɛlúmbɔ Palɛt muú alú ngɔmena atané, aké ne ɛbwɔ́, “ɛnyú deké mende yina apyɛ nnó?” ");
INSERT INTO anvNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Ɛbwɔ́ ashuú ji meko aké, “Mbɔgé mende yina apɔ́ muú mebo fɔ́ wɔ́, mbɔ ɛsé defyɛ fɔ ji né amu jyɛ wɔ.” ");
INSERT INTO anvNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Palɛt aké ne ɛbwɔ́, “Sɛge ji ɛnyú ambɔɔ́ depa mpa wuú ndɛre ɛbɛ nyú ɛjɔɔ́.” Ákpakpa bɔɔ́ Jus ashuú ji meko aké, “Ɛbɛ́ nyu bɔɔ́ Rom ɛkamege fɔ nnó ɛsé desɔ́ mpa nnó áwá muú.” ");
INSERT INTO anvNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Genó ɛyigé ɛbwɔ́ ajɔɔ́ gepyɛ nnó genó ɛyigé Jisɔs abɔ ajɔɔ atome ne gefɔgé negbo ɛniné ji agboó nyɛ getane wáwálé. ");
INSERT INTO anvNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Ne Palɛt akere meso né mmu ɛcha, mfwa akú Jisɔs agií ji aké, “Wɔ ne ɔlú mfwa bɔɔ́ Jus?” ");
INSERT INTO anvNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Jisɔs aké, “Wɔ mbɔɔ́ ne ɔfere mbɔ, waá nnó bɔɔ́ fɔ ne agare wɔ mmu ayi me nlú?” ");
INSERT INTO anvNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Palɛt ashuú ji meko aké, “Me, ɔfɛre nnó me nlú muú Jus? Ɛlé bɔɔ́ byɛ ne anɔɔ́ baá ampyɛ upɛ Ɛsɔwɔ ne afyɛ wɔ́ ne amu ya. Ndé mechɔ wɔ ɔpyɛɛ́?” ");
INSERT INTO anvNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Ne Jisɔs ashuú ji meko aké, “Gefwa ya gepɔ fɔ́ ɛyigé bɔɔ́ mme. Mbɔge gebɔ́ gebɛ ɛyigé bɔɔ́ mme, mbɔ baá defwɛ ba ammyɛ nnó ɛ́kágé me nkpɛ né ámu bɔɔ́ Jus, yɛ́mbɔ gefwa ya getane mbaá yicha.” ");
INSERT INTO anvNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Ndɛre ji ajɔɔ́ mbɔ Palɛt aké ne ji, “Mmyɛké wɔ ɔlú mfwa?” Ne Jisɔs ashuú ji meko aké, “Wɔ ɔlú cho manjɔɔ́ nnó menlú mfwa. Gɛ ula bi ábyɛné me mbɔ, ne getu ɛyigémbɔ ne nchwɔ́ fa mme nno ngáre bɔɔ wáwálé. Ne yɛ́ndémuú ayi agboó ne wáwálé, awuú mekomejɔɔ́ wa.” ");
INSERT INTO anvNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Ne Palɛt agií ji aké, “Wáwálé ɛlé ndé?” Agige mbɔ ama akere meso né dafyɛ, mbaá bɔɔ́ Jus aké, “Me ngɛ fɔ́ gabo ayi mende yina apyɛɛ́ wɔ́. ");
INSERT INTO anvNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Yɛ́mbɔ gepɔge nyú gelú nno, yɛ́ndé ŋmɛ gébégé ɛpaá koó upu me mbɔ mamferé muú denɔ ama ndɛre ɛnyú dékɛlege. Ndɛre ɛlúmbɔ nnó ɛnyú dékɛlege nnó mferé Mfwa bɔɔ́ Jus?” ");
INSERT INTO anvNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Palɛt ajɔ́gé mbɔ, ɛbwɔ́ ákalé ne meko metometo, áké, “Ɔferege fɔ́ mende yina fere ɛlé Barabas.” Barabas abɔ alú mmu ayi achyɛge ɛfwyale né melɔ. ");
INSERT INTO anvNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Palɛt achyɛɛ Jisɔs nnó, átule ji ne getó. ");
INSERT INTO anvNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Ne bɔɔ́ bee átɔ ɛla ɛwé ɛlú meshií áfaá Jisɔs né mekpo, áfyɛ ji nkúu megɛ́lé né mmyɛ ɛke mfwa. ");
INSERT INTO anvNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Ájwyage ji aké, “Geŋwá gétyɛɛ́ getyɛɛ́ gebɛ ne wɔ Mfwa bɔɔ́ Jus” ne ádo ji ukpɛ kpɛ né ushu. ");
INSERT INTO anvNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Palɛt ama akere achwɔ́ ajɔɔ́ ne bɔɔ́ bimbɔ aké, “Nana me nchwɔ ne ji né mbɛ ushu nyu yɛ́mbɔ kaáge nnó me ngɛ fɔ́ gabo ayi ji apyɛɛ́ wɔ́.” ");
INSERT INTO anvNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Jisɔs atane né dafyɛ ne ɛla ɛwé ɛlú meshií meshií né mekpo ne nkúu megɛ́lé né mmyɛ. Ne Palɛt ajɔɔ́ ne bɔɔ́ bimbɔ aké, “Gɛgé mende yimbɔ na.” ");
INSERT INTO anvNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Anɔɔ́ baá ampyɛ upɛ Ɛsɔwɔ ne ambame ɛcha upɛ agɛge Jisɔs, alɔ makale ne meko metometo aké, “Áwɔ ji né gekwa, áwɔ ji né gekwa.” Ajɔ́gé mbɔ, Palɛt ajɔɔ́ ne ɛbwɔ́ aké, “Ɛnyú ambɔɔ́ sɛge ji dewɔ né gekwa, néndé me ngɛ fɔ́ gabo ayi ji apyɛɛ́ wɔ́.” ");
INSERT INTO anvNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Yɛ́mbɔ bɔɔ́ Jus atome wyɛ ɛshyɛ ajɔ́gé aké, “Ɛsé déwya ɛbɛ ɛwé ɛjɔɔ́ nnó ji abɔ magbo. Néndé ji aké alú Maá Ɛsɔwɔ.” ");
INSERT INTO anvNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Palɛt awúgé mechɔ ɛwéna, ɛfɔ ɛkwɔ ji metɔɔ́ dɔɔ́. ");
INSERT INTO anvNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Akere meso né mmu ɛcha wuú, ama agií Jisɔs aké, “Wɔ ɔtane ɛfɔ?” Yɛ́mbɔ Jisɔs ashuú ji meko wɔ́. ");
INSERT INTO anvNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Ne Palɛt ajɔɔ́ ne Jisɔs aké, “Wɔ ukɛlege fɔ́ manjɔɔ́ mejɔɔ́ ne me? Wɔ ɔkaá fɔ́ nnó me nwyaá utó manlyaá wɔ ɔjyɛ ne nwyaá uto manwɔ wɔ né gekwa wɔ́?” ");
INSERT INTO anvNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Jisɔs ashuú ji meko aké, “Wɔ ɔ́pɔ́fɔ́ ne utó mampyɛ me genó mbɔgé uto bimbɔ ulá utane fɔ́ né mfaánebuú wɔ́. Ne getu ɛyigémbɔ muú ayi afyɛɛ́ me né amu nyú, gabo awuú aŋea apwɔɔ́.” ");
INSERT INTO anvNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Palɛt awúgé mbɔ, abɔ akɛle meti nnó ályaá Jisɔs ajyɛɛ́ yɛ́mbɔ bɔɔ́ Jus akalege aké, “Mbɔgé wɔ ɔlyage mende yina, ɛbyɛnnó wɔ ɔ́pɔ́ fɔ́ mejeé Sɛsa. Yɛ́ndémuú ayi asɛle gemɛ jií nnó alú mfwa ɛbyɛnnó akɛlege mankare gefwa ne mfwa Sɛsa mfwa Rom.” ");
INSERT INTO anvNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Ne Palɛt awúgé mejɔɔ́ ɛwéna, asɛ Jisɔs afɛ ne ji né dafyɛ. Jimbɔɔ́ ajwɔlé né geluɔge mpa né mbaá ayi ákuú nnó, “Melu Mataá.” (Né Hibru ákuú mbaá yimbɔ nnó “Gabata”.) ");
INSERT INTO anvNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Bií bimbɔ úlú ɛlé bií bi bɔɔ́ Jus akpomege mmyɛ manyɛ́ ɛpaá koó upu. Ne metɔɔ́ ŋwɔmese, Palɛt ajɔɔ́ ne ɛbwɔ́ aké, “Gɛ́ge Mfwa nyú na.” ");
INSERT INTO anvNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Yɛ́mbɔ ɛbwɔ́ ákálé aké cho ne ji ɛwú, cho ne ji ɛwú, awɔ ji né gekwa. Ne Palɛt ama gií ɛbwɔ́ aké, “Dékɛlege me nwɔ́ mfwa nyú né gekwa?” Anɔɔ́ baá ampyɛ upɛ Ɛsɔwɔ, aké, “Ɛsé depɔ sé ne mfwa yicha ɛkosé Sɛsa wɔ́”. ");
INSERT INTO anvNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Ne kwyakwyaá, Palɛt achyɛɛ yɛ́ Jisɔs né amu bwɔ́ nnó áwɔ́ ji né gekwa. Bɔɔ bee ásɛ́ Jisɔs áfɛ́ ne ji. ");
INSERT INTO anvNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Jisɔs jimbɔɔ́ ne akpane gekwa jií afɛ́ né melú ɛwé ákuú nnó, “Melú Uŋkɔ́kɔ́ makpo.” (Bɔɔ́ Hibru akuú ntó melu ɛwémbɔ nnó “Golgota.”) ");
INSERT INTO anvNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Ɛlé né melu ɛwéna ne awɔme Jisɔs né gekwa. Áwɔ ntó anjo makpo apea né ɛbi bwɔ́ ukwa. Áwɔ ama né ɛgbɛ́ ɛbwɔɛbɛ, ama ɛgbɛ́ ɛbwɔnyɛ ne Jisɔs né metɔɔ́ metɔɔ́. ");
INSERT INTO anvNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Palɛt asá ntó genó gefɔ́ aba né mekpo gekwa ɛyigé áwɔmé Jisɔs. Ásá wyɛɛ́ nnó, “Jisɔs muú Nasarɛt Mfwa bɔɔ́ Jus.” ");
INSERT INTO anvNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Ne gejamégé bɔɔ́ Jus ájɔ́gé genó ɛyigé ásamé ábalé né mfaá mekpo gekwa néndé mbaá ayi awɔme Jisɔs né gekwa alú kwɔ́kwɔ́lé ne Jɛrosalɛ. Ása mansa ŋwɛ amimbɔ né mekómejɔɔ́ Hibru, Latin ne Grek. ");
INSERT INTO anvNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Anɔɔ́ bá ampyɛɛ́ upɛ Ɛsɔwɔ, ájɔɔ́ ne Palɛt aké, “Ɔsage fɔ́ nnó Jisɔs alú mfwa bɔɔ́ Jus, sa ɛlé nnó ji ajɔɔ́ aké, ‘Me nlu mfwa bɔɔ́ Jus’.” ");
INSERT INTO anvNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Ne Palɛt aké ne ɛbwɔ́, “Genó ɛyigé me nsame, nsa mɛ.” ");
INSERT INTO anvNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Bɔɔ́ bee ánerege manwɔ Jisɔs né gekwa abɔ mandée jií akare malu ani yɛ́ndémuú bee asɛ melu ɛma. Ásɛ nto nku wuú ayi ji áfyɛɛ́ ne áfyɛɛ́ ɛwule. Nku yimbɔ apɔ ne nkwɔmé. ");
INSERT INTO anvNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Bɔɔ́ bee bimbɔ ajɔɔ́ ne atɛ aké, “Dekarege fɔ́ nku yina, déŋmeé lé megyaá wyɛɛ́ mankaá muú ayi asɛlé ji.” Ápyɛ́ mbɔ nnó genó ɛyigé ásame né mekomejɔɔ́ Ɛsɔwɔ gebɛ wáwálé. Ása wyɛ áké, “Ákare mandeé ya áfyɛ atɛ amu, ásɛ nku wa áŋme megyaá wyɛɛ́.” Gɛ́ genó ɛyigé bɔɔ́ bee ápyɛmbɔ. ");
INSERT INTO anvNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Ne bɔɔ́ fɔ abi atɛne kwɔ́kwɔ́lé ne gekwa ɛyi awɔme Jisɔs wyɛ, ɛlé mma Jisɔs, meŋmɛ mma Jisɔs ayi mendée, Mɛri mendée Klopas, ne Mɛri Magdala. ");
INSERT INTO anvNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Jisɔs ágɛgé ndɛre mma wuú átɛne ɛfɛɛ́ kwɔ́kwɔ́lé ne maá utɔɔ́ ayi jimbɔɔ́ Jisɔs agboó ne ji dɔɔ́, ajɔɔ́ ne mma wuú aké, “Mma, gɛ maá wyɛ na.” ");
INSERT INTO anvNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Ne ajɔɔ́ ntó ne maá utɔɔ́ yimbɔ aké, “Gɛ mma wyɛ na.” Ɛlɔ né gébé ɛyigémbɔ maá utɔɔ́ yimbɔ asɛ mma Jisɔs afɛ ne ji né gepú jií, nnó ajwɔlege ne ji. ");
INSERT INTO anvNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Ɛwyagé, Jisɔs akaá nnó ji anere mɛ yɛ́ndégenó ɛyigé ji abɔɔ́ mampyɛ, ne nnó genó ɛyigé mekomejɔɔ́ Ɛsɔwɔ ajɔɔ́ gebɛ wáwále, ajɔɔ́ aké, “Mmwɔ́lé manaá ɛpyɛɛ́ me.” ");
INSERT INTO anvNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Ɛké ɛpyɛɛ́mbɔ, nkwɔ fɔ́ alú ɛfɛɛ́, ayi áfyɛ mmɔɔ́ amí mamyáme magbeé wyɛɛ. Ásɛ ɛkochá, ányua né mmu mmɔɔ́ amibɔ, áfaá né ɛta maá genɔɔ́ ɛyigé akuú hisɔp, ábwɛɛ́ até Jisɔs né ubɔɔ́ meno. ");
INSERT INTO anvNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Ne gébégé Jisɔs anyú mmɔɔ́ amimbɔ aké, “Nnere utɔɔ́ ba.” Ajɔ́gé mbɔ, amo mekpo mme, afyɛ gemɛ jií né amu Ntɛ wuú Ɛsɔwɔ. ");
INSERT INTO anvNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Bií bimbɔ, ɛle bií ɛbi bɔɔ́ Jus ákpomege mmyɛ manyɛ́ uwyaá bwɔ́. Ɛbwɔ́ akɛlege fɔ́ nnó bií bimbɔ ubane uŋkwɔ bɔɔ́ abi awɔme né ukwa. Ajyɛ jɔɔ́ ne Palɛt nnó achyɛɛ́ ɛbwɔ́ uto ájyɛ ákɔre uka bɔɔ́ bimbɔ né mfaá ukwa, áfere uŋkwɔ ɛbwɔ́. ");
INSERT INTO anvNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Ne bɔɔ́ bee achwɔ́ akɔre uka bɔɔ́ apea abi awɔme ɛbwɔ́ ne Jisɔs. ");
INSERT INTO anvNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Áchwɔgé mbaá Jisɔs, ákɔre sé uka bií wɔ néndé agɛ nnó ji agbo mɛ. ");
INSERT INTO anvNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Yɛ́mbɔ muú bee ama ajo ɛgbɛ amba wuú ne nekɔ. Tɛnétɛné yimbɔ manoó ne manaá matanege. ");
INSERT INTO anvNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Muú yi agɛne unó bina ne agaré. Ne unó bi ji agare úlú wáwálé. Ne jimbɔɔ́ akaá nnó ji agarege wáwálé nnó apyɛ ɛnyú ntó défyɛ metɔɔ́ ne Jisɔs. ");
INSERT INTO anvNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Unó bina upyɛ nnó genó ɛyigé ásame né mmu ŋwɛ Ɛsɔwɔ ubɛ wáwálé. Ása wyɛ aké, “Yɛ́ gegoó jií gemma akɔɔ́ fɔ́.” ");
INSERT INTO anvNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Ne ama ása ntó né melu ŋwɛ Ɛsɔwɔ ɛwé fɔ́ aké, “Ápɛle nyɛ muú ayi ɛbwɔ́ ájomé.” ");
INSERT INTO anvNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Unó bina upyɛge, Josɛf muú melɔ Arimatya ajyɛ gií ne Palɛt nnó agɔ ji afere geŋkwɔ́gé Jisɔs né gekwa. Josɛf abɔ alú maá utɔɔ́ Jisɔs ama, yɛ́mbɔ akwɔlege ji bibií néndé afɔɔ́ ákpakpa bɔɔ́ Jus. Palɛt akamege, Josɛf ajyɛ fere geŋkwɔ́gé Jisɔs né gekwa afɛ́ ne geji. ");
INSERT INTO anvNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Josɛf afɛ́ ɛbwɔ́ ne Nikodɛmus muú abɔ́ achwɔ́ gɛ́ Jisɔs ne utuú. Nekodɛmus achwɔ́ ntó ne gejamégé maka gebɛ. Akwyɛɛ́ mami ne unó bi akuú nnó merrh ne alose. Manɔɔ́ genógé bɔ kilo usaá upea meso ɛfya. ");
INSERT INTO anvNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Ɛbwɔ́ ákpa geŋkwɔ́gé Jisɔs, afyɛge ji unó ɛbimbɔ ne mmyɛ aní ne ɛ́shyɛ́ ndeé. Gɛ́ mbɔ ne bɔɔ́ Jus ákwyɛge geŋkwɔ́gé muú ne anií. ");
INSERT INTO anvNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Né mbaá yi awɔme Jisɔs né gekwa, maá mekɔɔ́ alú wyɛ. Né mmu maá mekɔɔ́ yimbɔ ntó, menome mekɛ ɛwé álá alú danií muú fɔ ɛbɔ ɛlú wyɛ. ");
INSERT INTO anvNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Ánií Jisɔs né mmu menome ɛwémbɔ néndé mbaá yimbɔ, alu kwɔ́kwɔ́lé. Ne bií bimbɔ ntó bɔɔ́ Jus ákpomege mmyɛ nnó bií ujyage ɛbwɔ́ ányɛ́ uwyaá bwɔ́. ");
INSERT INTO anvNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Bií mbɛ né uwyaá, ne dondo gemua mme Mɛri muú melɔ Magdala afɛ́ né menome ɛwé abɔ́ anií Jisɔs. Ajyɛge, agɛ nnó áferé ntaá ɛniné ábɔ́ ákweré ɛmbú menome. ");
INSERT INTO anvNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Ndɛre ágɛne mbɔ Meri muú melɔ Magdala abó gatɛlé akere ajyɛ garé Simun Pita ɛbwɔ́ ne maá utɔɔ́ ayifɔ ayi Jisɔs ágboó ne ji dɔɔ́ aké, “Áfere Ata né mmu menome, ne ɛsé dékaá fɔ́ mbaá ayi ájyɛ belé ji wɔ́.” ");
INSERT INTO anvNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Ajɔ́gé mbɔ, Pita ɛbwɔ́ ne maá utɔɔ́ yimbɔ átane áfɛ né menome. ");
INSERT INTO anvNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Ndɛre ájyɛ, álómege gatɛle. Yɛ́mbɔ maá utɔɔ́ yimbɔ alome apwɔ Pita, ne abɔ́ mbɛ akwɔne né menome. ");
INSERT INTO anvNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Akwɔnege wyɛ, asé mmyɛ mme apɛ né mmu menome, agɛ ubaá ɛ́shyɛ́ ndeé ɛbi ábɔ́ anií Jisɔs ne ubi yɛ́mbɔ, akpɛ fɔ́ né mmu menome wɔ́. ");
INSERT INTO anvNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Ne Simun Pita muú abɔ alú meso akwɔnege, akpɛ né mmu menome, agɛ ubaá ɛ́shyɛ́ ndeé ɛbimbɔ ɛfɛɛ́. ");
INSERT INTO anvNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Agɛ́ ntó gebagé ndeé ɛyigé abɔ anií Jisɔs né mekpo ndɛre gelú pwipwi né mbaá awuú cha. Ɛpɔ́fɔ́ mbaá ama ne uba ɛ́shyɛ́ ndeé ɛbimbɔ. ");
INSERT INTO anvNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Ne maá utɔɔ́ ayi abɔ abɔɔ́ mbɛ akwɔne né menome, akpɛ ntó né mmu menome Jisɔs, agɛ unó bi upyɛ, akame nnó ɛlú wawale. ");
INSERT INTO anvNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","(Yɛ́ ɛlé ɛbwɔ́ ágɛne unó bina, álu wyɛ dankaá genó ɛyi mekomejɔɔ́ Ɛsɔwɔ abɔ ajɔɔ́ nnó Jisɔs abɔ mankwilé né negbo.) ");
INSERT INTO anvNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Ne baá utɔɔ bií agɛge mbɔ áma akere meso né upú bwɔ́. ");
INSERT INTO anvNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Yɛ́mbɔ Mɛri álá dafyɛ tɛ́né né alilé. Ndɛre alilé abyɛlé mmyɛ mme apɛ́ né mmu menome, ");
INSERT INTO anvNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","agɛ makiɛ́nné Ɛsɔwɔ apea ne mandeé pópó mmyɛ, ájwɔle né mbaá yi abɔ ábelé geŋkwɔ́gé Jisɔs. Ɛma né mekpo, ɛma né uka. ");
INSERT INTO anvNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Makiɛ́nné yimbɔ, ágií Mɛri áké, “Mma wɔ ɔlilé ndé?” Ashuú ɛbwɔ́ meko aké, “Ákpa Ata wa ne me nkaá fɔ́ mbaá yi ájyɛ bele ji wɔ!” ");
INSERT INTO anvNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Ajɔ́gé mbɔ, abwɔlé mmyɛ ake apɛle agɛ ndɛre Jisɔs atɛne, yɛ́mbɔ akaá fɔ nnó ɛlé Jisɔs ne atɛne mbɔ wɔ́. ");
INSERT INTO anvNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Jisɔs agií ji aké, “Mma wɔ ɔlilé ndé? Ndé muú wɔ ɔkɛlege?” Mɛri afɛre nnó ɛlé mbɔɔ́ maá mekɔɔ́ yimbɔ ne ji agɛne mbɔ, ajɔɔ́ ne ji aké, “Ata mbɔgé wɔ ne ɔkpane geŋkwɔ jii lɛre me mbaá ayi wɔ ɔbele geji, me njyɛ mkpa.” ");
INSERT INTO anvNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Ajɔ́gé mbɔ, Jisɔs akú ji aké, “Mɛri” abwɔlé mmyɛ apɛ Jisɔs, ajɔɔ́ né mekómejɔɔ́ Hibru aké, “Rabɔni” (ula Rabɔni utɛné nnó “Ménlɛré.”) ");
INSERT INTO anvNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Jisɔs ajɔɔ́ ne ji aké, “Ɔtage me, néndé me nlú dankwɔ njyɛ mbaá Ntɛ wa. Cho gare ɛlé aŋmɛ́ ba nnó me nlé nkwɔ njyɛ́ mbaá Ntɛ wa muú alú Ntɛ nyú ntó. Ɛsɔwɔ wa ne Ɛsɔwɔ nyú ntó.” ");
INSERT INTO anvNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Mɛri muú melɔ Magdala ajyɛ gare baá utɔɔ́ Jisɔs aké, “Me ngɛ Ata.” Ne agare ntó ɛbwɔ́ unó bi ji ajɔɔ́ ne ji. ");
INSERT INTO anvNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Né nkwalé bií mbɛ né uwyaá, baá utɔɔ́ Jisɔs ányweré mbaá ama, ágbɛ mano mbií néndé áfɔɔ́ bɔɔ́ Jus. Ne Jisɔs akpɛ atɛné né metɔɔ́ metɔɔ́ bwɔ́ aké, “Nesɔ nébɛ́ ne ɛnyú.” ");
INSERT INTO anvNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Ajɔ́gé mbɔ, alɛre ɛbwɔ́ mabɔme upa né amu jií ne ɛgbɛ mmyɛ wuú. Baá utɔɔ́ bií ágɛge ji mbɔ álu ne nechɔchɔ́ ndɛre ágɛné Atá. ");
INSERT INTO anvNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Jisɔs ama ajɔɔ́ ne ɛbwɔ́ aké, “Nesɔ nebɛ ne ɛnyú, ndɛre Ntɛ wa atɔme me, mbɔntó ne me ntɔme ɛnyú.” ");
INSERT INTO anvNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Ajɔ́gé mbɔ afɔ ɛbwɔ́ gejulé né mmyɛ aké “Sɛge Mendoó Ukpea. ");
INSERT INTO anvNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Yɛndemuu ayi ɛnyu dejigente gabo wuu, Ɛsɔwɔ ajigente gabo muu yimbɔ, ne yɛnde muu ayi ɛnyu dela dejinte gabo wuu wɔ, Ɛsɔwɔ nto ajige fɔ nte gabɔ wuu.” ");
INSERT INTO anvNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Gébégé Jisɔs achwɔ́ lɛre mmyɛ mbaá baá utɔɔ́ bií, ŋgba wuú ama né geluage abi áfyanéápeá ayi akuú ji nnó, Tɔmasi maá gefa abɔ apɔ́. ");
INSERT INTO anvNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Tɔmasi achwɔgé baá utɔɔ́ abifɔ ágare ji aké, “Ɛse degɛ Ata.” Tɔmasi aké, “Me nla ngɛ́ fɔ mabɔme upaá mpi né maka amu jií me nta ɛnɔ ɛbwɔ wa wyɛ, mma nta nto ɛbwɔ wa né nebɔmé gepa ɛnií nélú ji nɛ́ ɛ́gbɛ́ amba wɔ me nkamege fɔ.” ");
INSERT INTO anvNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Ndɔ ɛneé ɛkógé, baá utɔɔ́ Jisɔs ama anywere, né mmu gepú. Ne Tɔmasi alu ne ɛbwɔ́. Ágbɛ́ manombi, ne aké apɛle Jisɔs achwɔ́ tɛne né metɔɔ́ metɔɔ́ bwɔ́ aké, “Nesɔ nebɛ ne ɛnyú.” ");
INSERT INTO anvNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Ajɔɔ́ ntó ne Tɔmasi aké, “Fyɛ ɛnɔbwɔ wyɛɛ́ fa. Pɛ amu ya. Nyaá ɛbwɔ wyɛɛ́ ɔta ɛgbɛ amba wá. Ɔbɛgé sé ne dembyɔ kamé wyɛ kamege ne me.” ");
INSERT INTO anvNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Ne Tɔmasi ashuú ji meko aké, “Ata wa ne Ɛsɔwɔ wa.” ");
INSERT INTO anvNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Jisɔs ajɔɔ́ ne ji aké, “Ɛlé wɔ ɔgɛne me, ne ɔkame nnó ɛlé me? Metɔɔ́ megɔmegɔ ɛbɛɛ́ ne bɔɔ́ abi álá agɛ me wɔ, yɛ́mbɔ áfyɛɛ́ matɔɔ́ bwɔ́ ne me!” ");
INSERT INTO anvNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Ne Jisɔs apyɛ gejamégé upɔɔ́ ufélekpa né mbɛ ushu baá utɔɔ́ bií ɛbi álá ása fɔ́ ubi né mmu ŋwɛ yina wɔ́. ");
INSERT INTO anvNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Yɛ́mbɔ ása lé bina nnó upyɛ ɛnyú dékamé nnó Jisɔs ne alú Muú yi Ɛsɔwɔ akweré ji ɛlá gefwa, nnó ji alú Maá Ɛsɔwɔ. Ne nnó dekamege mbɔ debɔɔ́ geŋwá ɛyi gélágé byɛ́ gétúgé mabɔ mií. ");
INSERT INTO anvNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Mboó ndɔ fɔ́ ɛkoge, Jisɔs ama alɛre mmyɛ mbaá baá utɔɔ́ bií né ɛbɛɛ́ mega ɛwé ákuú nnó Tibɛras. Gɛ́ na ne Jisɔs alɛre mmyɛ mbaá baá utɔɔ́ bií. ");
INSERT INTO anvNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Simun Pita, Tɔmasi maá gefa, Nataniɛl muú melɔ Kana né gebage mewaá Galilií, baá Sɛbɛdee ne baá utɔɔ́ abifɔ makpo apea ábɔ́ álú mbaá ama. ");
INSERT INTO anvNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Ne Simun Pita ajɔɔ́ ne ɛbwɔ́ aké “Me nkɛlege manjyɛ ntofó.” Ɛbwɔ́ ntó aké, “Ɛse ntó déjyɛ ne wɔ.” Ɛbwɔ́ ako ajyɛ kpɛ mmu ɛkpeé. Né utuú bimbɔ yɛ́ genó ɛbwɔ́ áwa wɔ́. ");
INSERT INTO anvNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Ndɛre bií ujyage, Jisɔs achwɔ atɛne né mapea ɛbɛɛ mega, baá utɔɔ́ bií agɛge ji akaá fɔ jí wɔ́ ");
INSERT INTO anvNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Jisɔs akú ɛbwɔ́ aké, “Baá ba, déwaá meshuu fɔ wɔ?” Ɛbwɔ́ áshuú ji meko, “Déwa wɔ́.” ");
INSERT INTO anvNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Ajɔɔ́ ne ɛbwɔ́ aké, “Ŋmégé ntofo nyú né ɛgbɛ ɛbwɔnyɛ ɛ́kpe, déwane nyɛ meshuú.” Áŋmégé, meshuú ɛyi ɛsɛle, ɛpwɔ ɛbwɔ́ manja afyɛ mmu ɛ́kpe néndé ɛja dɔɔ́. ");
INSERT INTO anvNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Ɛpyɛge mbɔ, maá utɔɔ́ ayi Jisɔs abɔɔ́ gejeé ne ji dɔɔ́, ajɔɔ́ ne Pita aké, “Muú ayi ajɔ́gé mbɔ ne ɛsé ɛlé Ata.” Simun Pita awúge ndɛre maa utɔɔ yimbɔ ajɔɔ ake “Muú ayi ajɔɔ mbɔ mejɔɔ ne ɛse ɛle Ata” Akwyɛ afyɛ mandeé mmyɛ (néndé abɔ afere áji) Anyo achɔ né nnyi. ");
INSERT INTO anvNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Baá utɔɔ́ abifɔ álá né mmu ɛkpeé ajame dansa ne gejamégé meshuú ɛyi ɛlú wyɛ nnó achwɔ́ né mapea nnyi. Mantane né mapea nnyi ɔkwɔne mbaá ayi ɛbwɔ́ ajame dansa alú genógé matyɛɛ́ amu usaá upea meso ɛfya. ");
INSERT INTO anvNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Ájágé dansa yimbɔ akwɔnege né mapea nnyi, agɛ ujenjeé mewɛ ne brɛd wyɛ nɛre. ");
INSERT INTO anvNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Jisɔs ajɔɔ́ ne ɛbwɔ́ aké, “Chwɔge me ne meshuú fɔ́ ɛyi ɛnyú déwane mbɔ.” ");
INSERT INTO anvNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Simun Pita akwɔ akpɛ mmu ɛkpeé aja dansa yɛ́mbɔ achwɔ́ ne ji né mewaá. Dansa yimbɔ agbeé ne gejamégé meshuú kpakpa. Meshuú ɛlú usaá ukenéama meso ɛfyane ɛlɛɛ́ (153). Ne yɛ́ ɛlé meshuú ɛjame, dansa yimbɔ agyalé wɔ́. ");
INSERT INTO anvNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Ne Jisɔs ajɔɔ́ ne ɛbwɔ́ aké, “Chwɔge dégbáré unɛ dondo”. Ne yɛ́ maá utɔɔ́ ama ayi aŋea metɔɔ́ mangií ji nnó, “Ɔlu wa?” apɔ́; néndé ɛbwɔ́ ákaá nnó ɛlé Ata. ");
INSERT INTO anvNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Jisɔs ajyɛ bɔ brɛd yimbɔ ne meshuu ntó achyɛɛ́ ɛbwɔ́. ");
INSERT INTO anvNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Gɛ́ maŋáne alɛɛ́ na ayi Jisɔs alɛre mmyɛ mbaá baá utɔɔ bií gébégé ji akwilé né negbo. ");
INSERT INTO anvNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Ɛbwɔ́ anerege mangbaré unɛ, Jisɔs agií Simun Pita aké, “Simun, maá Jɔn nnó wɔ ɔbɔ gejeé ne me dɔɔ́, ɔpwɔ abifɔ na?” Ne Pita ashuú Jisɔs meko aké, “Ɛh Ata, wɔ ɔkaá nnó me mbɔ gejeé ne wɔ.” Jisɔs ajɔɔ́ ne ji aké, “Pɛle baá magɔŋme ya.” ");
INSERT INTO anvNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Jisɔs ama agií ji maŋáne apea aké, “Simun Pita maá Jɔn nnó ɔbɔɔ́ gejeé ne me?” Pita akame aké, “Ɛh Ata wɔ mbɔ ɔkaá nnó mbɔɔ́ gejeé ne wɔ”. Jisɔs aké, “Pɛle magɔŋme ya”. ");
INSERT INTO anvNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Ama agií Pita ne maŋáne ayi ágbeé alɛɛ́ aké, “Simun maá Jɔn nnó wɔ ɔbɔ gejeé ne me.” Agigé mbɔ, metɔɔ́ ɛsɔ Pita gétúgé agií ji tɛ́ maŋáne alɛɛ nnó, “Pita nnó wɔ ɔbɔ gejeé ne me?” Getu ɛyigémbɔ Pita ashuú ji meko aké, “Ata wɔ ɔkágé unó uko, ɔkaá cháŋéné nnó me mbɔ gejeé ne wɔ.” Jisɔs ajɔɔ́ ne ji aké, “Pɛle magɔŋme ya.” ");
INSERT INTO anvNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Ngarege wɔ wáwálé nnó, “Gébégé wɔ ɔlu gesage muú, wɔ mbɔɔ́ ɔfyɛ mandeé ɔjyɛɛ́ yɛ́nde mbaá ayi wɔ ɔkɛlege, yɛ́mbɔ gébégé ɔkwɔge ukoó, ula bwyɛ ɛlé amu mfaá ne ɛlé muu yicha ne afyɛɛ́ wɔ mandeé ágbárege wɔ ɛbwɔ aja wɔ meti ɔjyɛɛ mbaá ayi wɔ ɔlá ɔkɛlege fɔ manjyɛ.” ");
INSERT INTO anvNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Jisɔs ajɔɔ́ mejɔɔ́ ɛwéna ne Pita mampyɛ ji ákaá gefɔge negbo ɛniné Pita agboó nyɛ ne achyɛɛ́ Ɛsɔwɔ ŋgɔ. Jisɔs ajɔ́gé mbɔ aké ne Pita, “Kwɔle me.” ");
INSERT INTO anvNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Pita abwɔlége mmyɛ, agɛ ndɛre maá utɔɔ́ ayi Jisɔs abɔɔ́ gejeé ne ji dɔɔ́ akwɔlege ɛbwɔ́. Ɛlé maá utɔɔ́ yina ne abɔ ajwɔlé nya agií Jisɔs né ɛgbɛ mmyɛ, gébégé ɛbwɔ́ anyɛɛ́ menyɛɛ́, agií Jisɔs nnó, “Ata ndé muú wɔ ɔke achyɛge nyɛ wɔ maŋkwaá?” ");
INSERT INTO anvNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Pita agɛ́ge ji agií Jisɔs aké, “Ata ji ntó yɛ́?” ");
INSERT INTO anvNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Ne Jisɔs ashuú Pita meko aké, “Mbɔgé me nkɛlege nnó ji abɛ mebɛ kpaá tɛ me nchwɔɔ́, wɔ ɔbɔ ndé mechɔ wyɛɛ́? Wɔ kwɔle ɛlé me.” ");
INSERT INTO anvNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Ajɔ́gé mbɔ, mechɔ ɛwéna ɛkɛ ɛkwɔne mbaá baá utɔɔ́ abifɔ nnó Jisɔs aké maá utɔɔ́ yina agboó fɔ. Yɛ́mbɔ Jisɔs ajɔɔ́ fɔ́ nnó maá utɔɔ́ yimbɔ agboó fɔ́ wɔ́. Ajɔɔ́ ɛlé nnó, “Mbɔgé me nkɛlege nnó ji abɛ mebɛ kpaá tɛ me nchwɔɔ́, ɔbɔ ndé mechɔ wyɛɛ́?” ");
INSERT INTO anvNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Gɛ ɛlé maá utɔɔ́ awú ne agarege unó bina. Asá ubi né mme ne ɛsé dékaá nnó unó bi ji agarege úlú wáwálé. ");
INSERT INTO anvNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Gejamege unó ɛbifɔ úlú ntó ɛbi Jisɔs apyɛɛ́. Mbɔgé abɔ ása ubi uko né mme, mbɔ melú ɛbɛɛ́ fɔ́ fa mme ɛwé ábélege bɔ ŋwɛ abi ásame ubi.");
INSERT INTO anvNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Ata Tyɔfilɔs, né ŋwɛ mbɛ yimbɔ ntɔme wɔ, nsá uno uko ɛbí Jisɔs abɔ apyɛ́ ne alɛ́ré bɔɔ́, lɔ né gébé ɛyige ji alɔɔ́ utɔɔ́ bií, ");
INSERT INTO anvNT_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","kpaá tɛ gébé ɛyige ji ajyɛ́ mfaánebuú. Gemɛge nnó ji ajyɛ́ né mfaánebuú, achyɛ bɔɔ́ bií ji ajyá nnó ábɛ́ áŋgbá bií majyɛ né uto Mendoó Ukpea. ");
INSERT INTO anvNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Gébégé Jisɔs akwilé né negbo, abɛlé fa mme usaá ndɔ upéa. Né ndɔ yimbɔ, alɛrege aŋgbá bií mmyɛ né gejamégé mati ayi ɛbwɔ́ álá kagé bɛ sé ne dembyɔ nnó ji alu mebɛ. Ne agare ɛbwɔ́ mechɔ ɛwé Ɛsɔwɔ ágbárege nyɛ gefwa jií. ");
INSERT INTO anvNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Ne nkane ji alu chóncho ne ɛbwɔ́, afyɛ́ ɛbwɔ́ ɛbɛ ake, “Jwɔlege fa né Jɛrosalɛ, degilé ɛchyɛ ɛwé Ntɛ wa abɔ anyɛ́meno nnó atɔme nyɛ nkane me mbɔ ngare ɛnyú. ");
INSERT INTO anvNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Geno ɛyige njɔgémbɔ gelu nnó, ndɔ ɛja sé dɔɔ́ wɔ́ ɛyi Ɛsɔwɔ afyɛ́ nyɛ ɛnyú né amu Mendoó Ukpea wyɛ nkane Jɔn abɔ afyɛ nya bɔɔ́ né mmu nnyi.” ");
INSERT INTO anvNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Gébégé baá utɔɔ́ Jisɔs áma jwɔle chóncho ne Jisɔs ágií ji áke, “Átá gébé gekwané ɛyigé ɔmage pyɛ nnó ɛsé bɔɔ́ Isrɛli dégbáré gefwage sé”? ");
INSERT INTO anvNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Ne Jisɔs ashuú ɛbwɔ́ meko aké, “Ntɛ wa akwyɛ mɛ abɛlé né uto bií gébé ɛyigé unó bina upyɛ nyɛ, ne ɛpɔ́fɔ́ ɛwé ɛnyú dekaáge gébé ɛyigémbɔ. ");
INSERT INTO anvNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Ne genó ɛyigé debɔ́ mankaá gelu nnó, Mendoó Ukpea ɛchwɔgé ɛnyú mmyɛ, ɛchyɛge nyɛ ɛnyú uto ne ɛnyú degarege bɔɔ́ né Jɛrosalɛ gefɔge muú yi me nluú, ne demage garege nyɛ né malɔ bɔɔ́ Jus ako, ne degarege wyɛ dejyɛ né melɔ́ Samariya kpaá tɛ dekwɔ́nege mbaá yi mme akwya.” ");
INSERT INTO anvNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Ndɛre Jisɔs ajɔ́gé depɔ tire na, Ɛsɔwɔ alɔ mansɛ́ ji ajyɛ né mfaánebuú, ne baá utɔɔ́ bií ála ápɛlé amɛ mfaa. Akwɔ́ afɛ kpaá gekó gekweré ji. ");
INSERT INTO anvNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Ndɛre ɛbwɔ́ álu áfyɛ́ amɛ mangɛ ji, ɛké ɛwyage ágɛ ande fɔ apéa ne mandeé pópó mmyɛ, átɛné kwɔ́kwɔ́lé ne ɛbwɔ́. ");
INSERT INTO anvNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Ɛ́wyagé ande bimbɔ áké ne ɛbwɔ́, “Bɔɔ́ Galilií, ɛnyú detɛné fa depɛle amɛ mfaá nde? Jisɔs yina ayi alya ɛnyú akwɔme mbɔ mfaánebuú fi, amage kéré nyɛ meso wyɛ nkane degɛ́né mbɔ ji ajyɛɛ́.” ");
INSERT INTO anvNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Ne aŋgbá Jisɔs ályágé mekwɛ Olif, ákéré né Jɛrosalɛ, nekɛ nélu genógé ɛbwɔ ne meno. ");
INSERT INTO anvNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Ákwɔ́négé né melɔ́ Jɛrosalɛ, ákwɔ mfaá ɛnyɔŋ ákpɛ mmu maá gepú ayi ɛbwɔ́ ábɛ́lege. Ɛbwɔ́ alu Pita ne Jɔn, Jɛmsi ne Andru, Filip ne Tɔmasi, Batolomyo ne Matyo, Jɛmsi maa Alfɔs, Simun ayi ákuú ji muú ukógé ne Judas ayi maá Jɛmsi. ");
INSERT INTO anvNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Ɛbwɔ́ ako áchómege yɛndégébé ánɛnemmyɛ metɔɔ́ ɛma chóncho ne andeé fɔ abi ábɔ́ ákwɔlege Jisɔs, ne aŋmɛ́ Jisɔs ne mma wuú Mɛri. ");
INSERT INTO anvNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Né bífɔ́ bɔɔ́ abi akame ne Jisɔs áchomé ɛbwɔ́ ako, alu genógé usaá ukene. Ne Pita akwile ka aké ne ɛbwɔ́, ");
INSERT INTO anvNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Áŋmɛ ba, geno ɛyige ŋwɛ Ɛsɔwɔ ajɔɔ́ nya gebɔ nyɛ mambɛ wáwálé, Mendoó Ukpea ɛbɔ́ ɛpyɛ́ɛ Mfwa Dɛvid nnó abɔ mbɛ agare geno gefɔ getuge Judas ayi abɔ́ ajamé bɔɔ́ meti nnó apyɛ́ Jisɔs. ");
INSERT INTO anvNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Judas abɔ́ alu muú ama né geluagé ɛsé, Jisɔs abɔ́ ajya ji nnó apyɛge gefɔge utɔɔ́ uma ne ɛsé.” ");
INSERT INTO anvNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Ndɛre Pita abɔ ajɔge mbɔ, ɛlu nnó Judas apyɛge geboboge mechɔ ɛwé, ásɛ ŋka ji, ájyɛ na melu mme, ɛfɛɛ́ ne akwené ushú mme, unɛ ugbɔgé, mbwé unɛ ɛwɔ. ");
INSERT INTO anvNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Bɔɔ́ ako bi alú né Jɛrosalɛ, áwúge mechɔ́ ɛwé, ákuú melu mme ɛwémbɔ né mejɔɔ́ bwɔ́ nnó Akɛldama. Ula utɛné nnó, “Mewaá gewu.” ");
INSERT INTO anvNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Pita ama jɔɔ́ aké, “Mfwa Dɛvid abɔ́ asá né ŋwɛ makwa jií nnó, ‘Achyɛ gepú jií gelá gewa,’ Achyɛ muú amage ajwɔle sé mmu. Ne ama sá nnó, ‘ɛchyɛ muú ayicha asɛ melu utɔɔ́ wuú.’ ");
INSERT INTO anvNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","“Ndɛre ɛlúmbɔ, muú ayicha abɔ́ mambané ɛsé nnó décho, dégárégé nkane Átá Jisɔs akwilé né negbo. Yɛ́mbɔ́ muú yimbɔ abɔ mambɛ ayi abɔ akɛ́né ne ɛsé ne Jisɔs, lɔ né gébé ɛyige Jɔn abɔ́ awyáge bɔɔ́ manaá Ɛsɔwɔ kpaá ɛkwɔne né gébé ɛyigé Ɛsɔwɔ asɛlé Jisɔs né ɛta sé ajyɛ mfaánebuú.” ");
INSERT INTO anvNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Ɛfɛɛ́ ne ɛbwɔ́ ajya bɔɔ́ apéa, muú yi ama akamege Josɛf ayi ákuú ntó ji Basabas ne ama ákuú ji ntó Justɔs. Ne ayifɔ akamege Matyas. ");
INSERT INTO anvNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Ne ɛbwɔ́ anɛmmyɛ áké, “Átá wɔ ne ɔkaáge matɔɔ́ bɔɔ́ ako. Lɛré ɛsé muú yi ɔjya, ");
INSERT INTO anvNT_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","nnó ábɛ́ ŋgbá Jisɔs ne asɛ melu utɔɔ́ Judas maá utɔɔ́ wyɛ ayi ji alya ajyɛ mbaá yi akwane ne ji.” ");
INSERT INTO anvNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Ánɛ́gemmyɛ mbɔ, áŋme megya nnó ájya muú ama. Ne alɛré nnó Matyas ne ábɛɛ́. Ne ásɛ ji ágbɛɛ́ ne áŋgbá Jisɔs abi afyaneama. ");
INSERT INTO anvNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Bií ɛpaá ɛwé ákuú Pɛntikos ukwɔ́négé, bɔɔ́ bi áfyɛ́ matɔɔ́ ne Jisɔs ako abɔ áchomé melu ɛma ne meko ɛbwɔ́ ama. ");
INSERT INTO anvNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Áke áwuú gewyage genó gefɔ́ getané mfaá ɛké mbyo gechwɔ́ gekpɛ mmu gegbeé gepú ɛyige ɛbwɔ́ abɔ́ alu. ");
INSERT INTO anvNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Áké ápɛ́le ágɛ́ genó ɛyi gelu nkane manɔ́mé mewɛ. Átya, ájyɛ́ tɛne, yɛ́ndémuú mmyɛ. ");
INSERT INTO anvNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Ne Ɛsɔwɔ apyɛɛ́ Mendoó Ukpea ɛchwɔ kpɛ ɛgbeé bwɔ́ matɔɔ́ ne ɛpyɛ bwɔ́ alɔ manjɔɔ́ ufɔɔ́ mejɔɔ́ ufɔɔ́ ufɔɔ́. ");
INSERT INTO anvNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Né gébé ɛyigémbɔ, bɔɔ́ Jus ne bɔɔ́ bi ánoge Ɛsɔwɔ ábɔ́ átané né malɔ mako áchwɔ́ né Jɛrosalɛ. ");
INSERT INTO anvNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Áwuúge gewya ɛyigembɔ, gejamégé bɔɔ́ áchwɔ́ nɔ bɔɔ́ bi áfyɛ́ metɔɔ́ ne Jisɔs mme. Áwuúge nkane bɔɔ́ Jisɔs ájɔge unó ne yɛ́ndémuú awúgé né mejɔɔ́ wuú, ɛpwɔ ji uto. ");
INSERT INTO anvNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Ála amɛ mekpo fuú ájɔge ne atɛ áke, “Bɔɔ́ bi ájɔge na ako, átané gebagé Galilií. ");
INSERT INTO anvNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Ne ɛpyɛ nnó ne ɛbwɔ́ ájɔge mejɔɔ́ ɛsé? ");
INSERT INTO anvNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Ɛsé bifɔ detane Patiyans, Mɛdis ne Ɛlam, abifɔ átané Mesopotemya Judiya ne Kapadosia ne abifɔ átané nto Pɔntɔs ne Ɛsya. ");
INSERT INTO anvNT_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Abifɔ átané Frigiya ne Pamfilya, abifɔ átané Ijip ne gebage mewaá Libya kwɔ́kwɔ́lé ne Sɛren. Abifɔ átané Rom, abi álu bɔɔ́ Jus, ne abifɔ álaá bɔɔ́ Jus. ");
INSERT INTO anvNT_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Abifɔ átané Kret ne Arabyan. Yɛ́mbɔ ɛsé ako dewuú bɔɔ́ bimbɔ nkane ájɔge ufɔɔ́ mejɔɔ́ ɛsé, ágarege ukpɛkpɛ unó bi Ɛsɔwɔ apyɛ́ɛ.” ");
INSERT INTO anvNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Álá mano mekpo fuú ne ɛlú wyɛ ɛbwɔ́ matɔɔ́ tametame, ágige wyɛ atɛ áké, “Ɛwéna ɛtɛné mbɔ nnó”? ");
INSERT INTO anvNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Yɛ́mbɔ abifɔ álɔ manjwya le jwyage áké, “Bɔɔ́ Galilií bina, mmɔɔ́ mapyɛ ɛbwɔ́.” ");
INSERT INTO anvNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Ne Pita akwile ka ne aŋgbá abifɔ afyaneama, ajɔgé ne njune bɔɔ́ bimbɔ áké, “Ɛnyú bɔɔ́ Jus ne bɔɔ́ ako abi alu né Jɛrosalɛ, wuúge, nkɛlege mangaré ɛnyú ula mechɔ ɛwé. ");
INSERT INTO anvNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Gébé gelú mbɔ le káláŋká ɛneneama dondo, bɔɔ́ bina alu danyú mmɔɔ́ fɔ́ nkane ɛnyú defɛrege. ");
INSERT INTO anvNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Geno ɛyi gepyɛɛ́ mbɔ nana, ɛlé ɛyigé Joel muú ɛkpave Ɛsɔwɔ abɔ́ ajɔɔ́ tɛ gachi nnó, ");
INSERT INTO anvNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Ɛsɔwɔ aké, ‘Meso gébé nchyɛge nyɛ Mendoó wa mbaá bɔɔ́ ako. Ne baá nyú abi andeé ne ande áwuú nyɛ depɔ ne me, ágárege. Njɛ usa nyú agɛ́ne nyɛ depɔ ta ne ágárege, ne akoó ande nyú agɛne nyɛ ujya. ");
INSERT INTO anvNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Né gébé ɛyigémbɔ nchyɛge nyɛ nto Mendoó wa mbaá baá utɔɔ́ ba ako, yɛ mendée yɛ mende ne ɛbwɔ́ áwuú nyɛ depɔ ne me, ágárege. ");
INSERT INTO anvNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Mpyɛ nyɛ bɔɔ́ ágɛ ufelekpa né mfaánebuú, ne ukpɛkpɛ uno né mme. Ágɛ́ne nyɛ manoó, mewɛ ne gelógé amuawɛ ne mfaá álá nyɛ chuchu ɛke manoó, ");
INSERT INTO anvNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","ŋmɛɛ́ ɛ́nómege nyɛ gemua gekwé ne mfaá álá nyɛ chuchu ɛke manoó, gemɛge nnó bií Átá Ɛsɔwɔ ɛbi upwɔ́ amu ukwɔne. ");
INSERT INTO anvNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Ne ɛlé bɔɔ́ bi ánɛge Átá mmyɛ, ne áférege ɛbwɔ́ né ɛfwyale gabo.’” ");
INSERT INTO anvNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Pita amajɔɔ́ aké, “Bɔɔ́ Isrɛli wuúge, Jisɔs ayi Nasarɛt alu muú yi Ɛsɔwɔ alɛre ɛnyú cháŋéné nnó, ji ne atɔme ji getuge ɛnyú degɛ ndɛrɛ abɔ́ apyɛ́ɛ ukpɛkpɛ uno bi ulɛre nnó Ɛsɔwɔ ne achyɛge ji uto. Ɛnyú dekaá nénde uno bina ubɔ́ upyɛ metɔɔ́ metɔɔ́ ɛnyú. ");
INSERT INTO anvNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Jisɔs yina, ɛle ayi ɛnyú dechyɛ ɛta bɔɔ́ nchyɛ nnó áwɔ́ né gekwa. Yɛ́mbɔ ɛle Ɛsɔwɔ ne abɔ́ ámɛɛ́ mɛ ábelé ne akaá nnó mbɔ ne ɛpyɛ nyɛ. ");
INSERT INTO anvNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Ne apyɛ Jisɔs akwilé né negbo, atane ne manome nénde negbo nebɔ nepɔ́ ne ɛshyɛ mangbaré ji, álá nkane muú denɔ. ");
INSERT INTO anvNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Ne Mfwa Dɛvid abɔ́ ajɔɔ́ depɔ ti getúgé Jisɔs aké, ‘Ngɛne Átá Ɛsɔwɔ né mbɛ ushu wa né gébé geko. Alu me ɛ́gbɛ́ ɛbwɔnyɛ nnó mbɛgé ne ɛfɔɔ́. ");
INSERT INTO anvNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Né getú ɛyigémbɔ nlu ne nechɔ́chɔ́ né metɔɔ́ nkwane, mbene. Me nlu mekwaá ne ngboó nyɛ, yɛ́mbɔ nwya umɛɛ́, ");
INSERT INTO anvNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","gétúgé nkaá nnó wɔ yi ɔlu Ɛsɔwɔ, ɔlyage nyɛ fɔ́ mendoó wa ɛlá né melɔ áwuú bɔɔ́, ɔlyágé nyɛ fɔ́ Maá utɔɔ́ wyɛ yi apyɛɛ́ utɔɔ́ cháŋéné apwané mmu menome. ");
INSERT INTO anvNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Wɔ ɔlɛré me meti ɛwé mbɔɔ́ mankoó ne mbɔ́ geŋwá. Mbɛ nyɛ́ né mbɛ ushu wyɛ, ne metɔɔ́ megɔmegɔ.’” ");
INSERT INTO anvNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Ne Pita ama jɔɔ́ aké, “Aŋmɛ́ ba, mbɔ́ mangaré ɛnyú gbɔgɔnɔ nnó gekwenege ntɛ ɛsé, Mfwa Dɛvid yɛlé abɔ ajɔɔ́ mbɔ agbó, ánií ji, ne menome wuú ɛlu fa tɛ fina. ");
INSERT INTO anvNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Abɔ́ alu muú ɛkpávé Ɛsɔwɔ ne abɔ́ akaá menomenyɛɛ́ ɛwé Ɛsɔwɔ abɔ́ anyɛɛ́ ne ji. Ne Ɛsɔwɔ jimbɔɔ́ ashu meko aké, ‘Ji apyɛ nyɛ mpyáne Dɛvid ama nnó ábɛ́ Mfwa nkane Dɛvid jimbɔɔ́ abɔ́ alu.’ ");
INSERT INTO anvNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Ɛbyɛnnó Dɛvid abɔ́ abɔ mbɛ agɛ genó ɛyige Ɛsɔwɔ apyɛɛ́ nyɛ meso gébé; ne alɛre nnó Ɛsɔwɔ apyɛ nyɛ Muú yi Ɛsɔwɔ akweré ji ɛlá gefwa nnó akwile né negbo. Gɛ́ wyɛ genó geji ne ji abɔ́ jɔɔ́ nnó ji alá fɔ́ né melɔ áwuú bɔɔ́, ne geŋkwɔ ji gepwánege fɔ́ mmu menome. ");
INSERT INTO anvNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Muú ayi Dɛvid abɔ́ ajɔɔ́ bɔ ɛlé Jisɔs. Ɛsɔwɔ apyɛ ji akwile né negbo ne ɛsé ako abi delu aŋkwɔle bií dékpá amɛ dégɛ́ ji wáwále. ");
INSERT INTO anvNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Ntɛ wuú Ɛsɔwɔ apyɛgé ji akwile né negbo, apyɛ ji ajwɔle ne geluɔge ɛnogé ɛyi gelu né ɛgbɛ ɛbwɔnyɛ wuú, ne achyɛ ji Mendoó Ukpea nkane ji abɔ́ anyɛ́meno nnó apyɛ. Genó ɛyigé ɛnyú dewuú né degɛne mbɔ, ɛle Ɛsɔwɔ Mendoó Ukpea ɛwu ne Jisɔs atɔ́mé mbaá bɔɔ́ bií. ");
INSERT INTO anvNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Dɛvid ajyɛ mfaánebuú wɔ́; yɛ́mbɔ aké, ‘Ata Ɛsɔwɔ ajɔɔ́ ne ntɛ wa nnó, jwɔle fa né geluɔ ɛyi gelu me ɛgbɛ ɛbwɔnyɛ, ");
INSERT INTO anvNT_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","kpaá tɛ gébé gekwɔnege nyɛ ɛyige mpwɔ́ bɔɔ́ mawame byɛ, mpyɛ bwɔ́ ála ɛké mboó ɛweé nnó ɔnɛré uka mfaá.’ ");
INSERT INTO anvNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“Bɔɔ́ Isrɛli ako ábɔ́ mankaá cháŋéné nnó Jisɔs ayi ɛnyú dewɔ́mé mbɔ né gekwa, ɛle ji ne alú Muú yi Ɛsɔwɔ akweré ji ɛlá gefwa ne alu ntó Átá ayi abɔ́ bɔɔ́ ako.” ");
INSERT INTO anvNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Bɔɔ́ bina áwuúgé mekomejɔɔ́ yimbɔ, anyií ɛbwɔ́ matɔɔ́ ne ágií Pita ne áŋgbá abifɔ aké, “Aŋmɛ ɛsé, nana ɛse depyɛ nnó”? ");
INSERT INTO anvNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Pita ashuú bwɔ́ meko ake, “Yɛ́ndémuú nyú abɔ́ mankwɔre metɔɔ́ wuú ne áwyaá ji manaá Ɛsɔwɔ né mabɔ Jisɔs Kras. Depyɛ́gémbɔ, Ɛsɔwɔ ajíge nyɛ nte gabo nyú ne achyɛge nyɛ ɛnyú ɛchyɛ wuú ɛwé ɛlu Mendoó Ukpea. ");
INSERT INTO anvNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Ɛsɔwɔ abɔ́ anyɛ́meno ɛwéna né ɛta nyú ne baá nyú ne mbaá bɔɔ́ ako abi alu malɔ ayicha. Menomenyɛɛ́ ɛwé ɛlu mbaá bɔɔ́ ako bi Ata se Ɛsɔwɔ akuú nnó abɛ abií.” ");
INSERT INTO anvNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Ne Pita ama gare ɛbwɔ́ gejame depɔ, ne achyɛ ɛbwɔ́ majyɛ́ aké, “Poóge gemɛ nyú né ɛfwyalé ɛwe Ɛsɔwɔ atɔ́me nyɛ mbaá bɔɔ́ njyɛne ubeé ɛnine na.” ");
INSERT INTO anvNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Bɔɔ́ awuúge mekomejɔɔ́ Pita, gejame ákamé ne áwyaá ɛbwɔ́ manaá Ɛsɔwɔ. Bií bimbɔ, dɛlé bɔɔ́ alɛɛ́ (3.000) ácho né geluage bɔɔ́ abi akame ne Jisɔs. ");
INSERT INTO anvNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Ne ɛbwɔ́ áfyɛ́ makpo bwɔ́ né uno bi áŋgbá Jisɔs álɛrege, ájwɔlege melu ɛma, ányɛɛ́ menyɛɛ́ ne ánɛnemmyɛ chóncho. ");
INSERT INTO anvNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Ne áŋgbá Jisɔs ápyɛ́ɛ ufélekpa ne ukpɛkpɛ unó bi ulɛre utó Ɛsɔwɔ, ne bɔɔ́ ágɛgé ubi áfɔ́, ne áchyɛge bwɔ́ ɛnoge. ");
INSERT INTO anvNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Bɔɔ́ ako abi ákamé né Jisɔs alú chóncho metɔɔ́ ɛma, ne ákárege unó bwɔ́ ne atɛ. ");
INSERT INTO anvNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Gébé ɛyige fɔ́, ákpóo uno bwɔ́, akarege ŋka yimbɔ ne atɛ nkane yɛ́ndémuú akɛlege. ");
INSERT INTO anvNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Ɛbwɔ́ áchónege yɛndé bií né ɛcha upɛ Ɛsɔwɔ, anɛ́nemmyɛ chóncho ne anyɛɛ́ ntó menyɛɛ́ né úpú atɛ, áchyɛge atɛ unó metɔɔ́ ɛma, ");
INSERT INTO anvNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","ne ákwáne makwa, áfɛ́ɛge Ɛsɔwɔ yɛndégébe. Bɔɔ́ ako ágɛ́ne nkane gepɔ gelɔ́gélɔ́ bwɔ́ gelu ne gejeége ɛbwɔ́ matɔɔ́. Ne yɛ́ndé bií Ɛsɔwɔ aférege bɔɔ́ né ɛfwyale gabo, ne agbɛge ɛbwɔ́ né ɛchomele bɔɔ́ Jisɔs. ");
INSERT INTO anvNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Bií bifɔ Pita ne Jɔn ákwɔ́me ájyɛ́ né ɛcha upɛ Ɛsɔwɔ, ne gébé gebɔ́ gelu káláŋká ɛlɛɛ́ ne nwɔmésé, ɛle gébé ɛyige mmyɛmenɛne. ");
INSERT INTO anvNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Ne ndɛre ɛbwɔ́ áchwɔ kpɛ né menombí ɛwé ákuú menombí melɔ́mélɔ́, ágɛ́ mende fɔ ayi abɔ́ alu mbwéré tɛ ábyɛné ji ndɛre ajwɔlé ɛfɛɛ́. Bɔɔ́ ákpáne ji yɛ́ndé bií, ábélege né menombi ɛwémbɔ nnó akɔgé dekɔ mbaá bɔɔ́ abi ákóoge akpɛne mmu ɛcha upɛ Ɛsɔwɔ. ");
INSERT INTO anvNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Mende yimbɔ agɛ́gé Pita ne Jɔn ndɛre ájyɛ kpɛ wyɛ, akɔ ɛbwɔ́ nnó áchyɛ́ ji genó gefɔ. ");
INSERT INTO anvNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Ápɛ ji domeé, ne Pita aké ne ji, “Pɛ ɛsé.” ");
INSERT INTO anvNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Ne apɛ ɛbwɔ́, afɛ́rege nnó áchyɛge nyɛ ji genó gefɔ. ");
INSERT INTO anvNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Pita aké ne ji, “Mpɔ́ yɛ ne ŋka, yɛ́mbɔ nchyɛge nyɛ wɔ genó ɛyige nwya. Ngarege wɔ né mabɔ Jisɔs Kras ayi Nasarɛt, kwile ka, lɔ mankɛ.” ");
INSERT INTO anvNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Ne Pita agbare ji ɛbwɔnyɛ abwɛ. Tɛnetɛne yimbɔ, uka mende yimbɔ utoó, ");
INSERT INTO anvNT_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","anyó atɛne, alɔ mankɛne agyage. Akwɔlé ɛbwɔ́, ákpɛ mmu ɛcha upɛ Ɛsɔwɔ, akɛne, anyóge achɔge, afɛɛ́ge Ɛsɔwɔ. ");
INSERT INTO anvNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Bɔɔ́ ako bi ábɔ́ álu ɛfɛɛ́, ágɛ́ge nkane mende yimbɔ akɛ́ne afɛɛ́ge Ɛsɔwɔ, ");
INSERT INTO anvNT_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","ákaá nnó ɛlé mende yi ajwɔ́lege yɛndégébé né menombi ɛwé akuú Menombi Melɔ́melɔ́ ɛcha upɛ, akɔ dekɔ, ála amɛ mekpo fuú ne ákwé tametame nkane ágɛ́né mende yimbɔ akɛ́né. ");
INSERT INTO anvNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Mende yimbɔ atome wyɛ ɛshyɛ, akwɔlege Pita ne Jɔn. Bɔɔ́ ako abi ágɛné ji, ála mano mekpo fuú, ábó, ájyɛ bane ɛbwɔ́ né ɛcha ɛwé ákuú ɛcha Solomun. ");
INSERT INTO anvNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Pita agɛ́gé nkane bɔɔ́ áchwɔ́ nɔɔ́ ɛbwɔ́ mme, agií ɛbwɔ́ aké, “Bɔɔ́ Isrɛli, ndé ɛnyú détóme ɛsé amɛ mmyɛ, ne ndé déla mano mekpo fuú né mechɔ ɛwé? Ɛnyú defɛrége nnó ɛle uto sé ne upyɛ́ mende yina alɔ mankɛ́né? Wa gétúgé ɛse depyɛɛ́ unó bi ugɔɔ́ Ɛsɔwɔ metɔɔ́? ");
INSERT INTO anvNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Ɛlé Ɛsɔwɔ ne apyɛ́ nnó ŋgɔ́ Jisɔs maá utɔɔ́ wuú akwɔ́. Ji Ɛsɔwɔ, alu Ɛsɔwɔ ayi ukwene antɛ sé. Alu Ɛsɔwɔ ayi Abraham alu nto ayi Asek, ne ayi Jakɔb. Ne Jisɔs yimbɔ ɛle ayi ɛnyú debɔ́ dekpane, dechoó né mbɛ ushu ampané mpa. Gébégé Palɛt akɛlege manlya ji ajyɛ, ɛnyú deshya wyɛ shya. ");
INSERT INTO anvNT_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Jisɔs abɔ alu Muú Ukpea ne Muú ayi Cho. Yɛ́mbɔ ɛnyú bina deshya ji ne denɛ Palɛt mmyɛ nnó alya muú gewu ajyɛ. ");
INSERT INTO anvNT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Dépyɛge mbɔ, dewá muú yi achyɛge bɔɔ́ geŋwá. Yɛ́mbɔ Ɛsɔwɔ apyɛ ji akwile né negbo ne ɛsé delu bɔɔ́ bi dekpané amɛ degɛ́né, ne nana degarege bɔɔ́ mechɔ ɛwé. ");
INSERT INTO anvNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Ɛlé uto Jisɔs yimbɔ ne upyɛ mbwéré mende yina atoó. Genó ɛyigé ɛnyú degɛ́ne ne dekaá nnó gepyɛ, ɛlé gétúgé ɛsé défyɛɛ́ matɔɔ́ ne Jisɔs yimbɔ. Ɛlé matɔɔ́ ɛsé ayi défyɛɛ́ ne ji, ne ápyɛ mbwéré mende yina akɛ́ne mbɔ ɛnyú degɛ́ne. ");
INSERT INTO anvNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Nana aŋmɛ́ ba, nkaá nnó genó ɛyigé ɛnyú debɔ́ dechomé ne ákpakpa melɔ depyɛ́ɛ mbaá Jisɔs debɔ́ dekaá wɔ́. ");
INSERT INTO anvNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Ɛsɔwɔ abɔ́ agare bɔɔ́ ɛkpávé bií tɛ gachí nkane Muú yi Ɛsɔwɔ akweré ji ɛlá gefwa abɔ́ mangɛ ɛfwyale, ne apyɛ nnó mechɔ ɛwé ɛbɛ́ wáwálé nkane Ɛsɔwɔ abɔ ajɔɔ́ mɛ́. ");
INSERT INTO anvNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Ne kwɔrege matɔɔ́ nyú, dekéré meso mbaá ntɛ nyú Ɛsɔwɔ nnó ji ajinte gabo ɛnyú. ");
INSERT INTO anvNT_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Depyɛge mbɔ́, Átá Ɛsɔwɔ apyɛ nyɛ matɔɔ́ nyú akwené, ne atɔme nyɛ Jisɔs Muú yi Ɛsɔwɔ akweré ji ɛlá gefwa, ayi ji abɔ́ ajya nnó áchwɔ pyɛ ɛnyú depó. ");
INSERT INTO anvNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Ji abɔ manjwɔle né mfaánebuú kpaá tɛ gébé gekwɔnege nyɛ ɛyigé Ɛsɔwɔ apyɛ nyɛ unó uko, ukéré ukɛ nkane ji abɔ apyɛ ukwéné bɔɔ́ ɛkpave bií ágaré. ");
INSERT INTO anvNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Ne Mosis abɔ́ ajɔɔ́ nya aké, ‘Átá Ɛsɔwɔ atɔme nyɛ muú ɛkpávé wuu, wyɛ nkane abɔ́ atɔme me. Atanege nyɛ né melɔ nyú, ne debɔ́ manwu yɛ́ndé genó ɛyige ji agarege ɛnyú. ");
INSERT INTO anvNT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Mbɔge muú ashyage maŋwu mekomejɔɔ́ wuú, ábɔ́ mamféré ji né geluage bɔɔ́ Ɛsɔwɔ, áwá ji.’ ");
INSERT INTO anvNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Wyɛ meti ɛwu ɛma ne bɔɔ́ ɛkpave Ɛsɔwɔ ako abɔ́ ágaré mechɔ ɛwé ɛpyɛ́ɛ mbɔ fi. Lɔ né gébé ɛyi Samuele ɔkwɔne né abi akwɔle ji meso. ");
INSERT INTO anvNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Unó uko ɛbi Ɛsɔwɔ abɔ apyɛ bɔɔ́ ɛkpave bií agaré, úlú ɛbi nyú. Ɛnyú ntó delu né menomenyɛ ɛwé Ɛsɔwɔ abɔ́ anyɛɛ́ ne ukwene antɛ nyú. Gétúgé Ɛsɔwɔ abɔ ajɔɔ́ nya ne Abraham aké, ‘Mpyɛ nyɛ upyáne byɛ uchwɔ́ ne galɔ́gálɔ́ mbaá bɔɔ́ ako fa mme.’ ");
INSERT INTO anvNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Ne Ɛsɔwɔ ajyagé maá utɔɔ́ wuú, abɔ́ mbɛ atɔ́ ji ɛta nyú nnó apyɛ ɛnyú delya gabo ayi ɛnyú depyɛɛ́ nnó galɔ́gálɔ́ akwɔ́lé ɛnyú.” ");
INSERT INTO anvNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Ndɛre Pita ne Jɔn alu jɔ́ge, ampyɛ upɛ Ɛsɔwɔ fɔ́ chóncho ne muú kpaá bɔɔ́ bi ábáme ɛcha upɛ Ɛsɔwɔ ne bɔɔ́ Sadusi fɔ́ áchwɔ sɔ́ ɛbwɔ́ mejɔɔ́ meno. ");
INSERT INTO anvNT_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Ne matɔɔ́ asɔ́ bɔɔ́ bina dɔɔ́ gétúge Pita ne Jɔn abɔ́ agarege nnó, tɛ mbaá Jisɔs akwíle né negbo, bɔɔ́ ako bi akame ne Jisɔs ákwilé nyɛ ntó. ");
INSERT INTO anvNT_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Ne ágbaré Pita ne Jɔn áfɛ́. Ndɛre nkwale akwɔne, ɛbwɔ́ ájyɛ fɛ́ bwɔ́ né denɔ, nnó mechɔ ɛwémbɔ ɛla wyɛ geya. ");
INSERT INTO anvNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Yɛ́mbɔ bɔɔ́ bi áwuú mekomejɔɔ́ Pita ne Jɔn, gejamé ákáme, ne ácho né geluage bɔɔ́ bi áfyɛɛ́ matɔɔ́ ne Jisɔs, ɛbwɔ́ álú nana genógé bɔ dɛle ata. ");
INSERT INTO anvNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Bií ujyagé, afwa melɔ ne ákpakpa melɔ ne anlɛré mabɛ Ɛsɔwɔ ábɔ́ áchwɔ́ cho melu ɛma né Jɛrosalɛ. ");
INSERT INTO anvNT_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Anas ayi abɔ alu ɛtukpɛ ampyɛ upɛ Ɛsɔwɔ abɔ́ alu wyɛ, ne Kaifas, ne Jɔn ne Aleksanda ne bɔɔ́ abifɔ abi átané ntó ula gepu ɛtukpɛ ampyɛ upɛ Ɛsɔwɔ. ");
INSERT INTO anvNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Ne ɛbwɔ́ ája Pita ne Jɔn, áchwɔ tɛ́ne mbɛ ushu bwɔ́, ne agií bwɔ́ aké, “Ɛkɛ nnó ne ɛnyú depyɛ́ɛ mechɔ ɛwena njuú? Utó nyú utané ɛfɔ́? Ɛnyú depyɛ́ geno ɛyige na né mabɔ wá?” ");
INSERT INTO anvNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Wyɛ né gébé ɛyigémbɔ, Mendoó Ukpea ɛgbeé Pita metɔɔ́ ne aké ne ɛbwɔ́, “Ɛnyú afwa ne ákpakpa melɔ, ");
INSERT INTO anvNT_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","nnó geno ɛyige ɛse depyɛ mbaá mbweré mende yina gelɔ wɔ́? Ɛnyú degige ɛse fina nnó dekaá fɔ́ genó ɛyi gepyɛ ne ji akɛne mbɔ wɔ́? ");
INSERT INTO anvNT_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Gɔge degaré ɛnyú ne bɔɔ́ Isrɛli ako nnó, ɛle uto Jisɔs Kras ayi atane Nasarɛt ne upyɛ́ mende yi atɛ́né mbɔ mbɛ ushu ɛnyu, atoó cháncha. Ɛlé Jisɔs yina ne ɛnyú debɔ dewɔ́mé né gekwa, ne Ɛsɔwɔ apyɛ ji akwíle né negbo. ");
INSERT INTO anvNT_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Ji ne alu ntaá ɛni ŋwɛ Ɛsɔwɔ aké, ‘Ntaá ɛni ɛnyú antɛné upú debɔ́ déshya neni nela ɛnine negbaré nékúné gepú.’ ");
INSERT INTO anvNT_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Jisɔs yina jimbí ne akage féré bɔɔ́ né ɛfwyale gabo. Nendé muú yicha ápɔ́ sé fa mme yina ayi Ɛsɔwɔ atɔmé nnó áchwɔ áféré ɛsé né ɛfwyale gabo.” ");
INSERT INTO anvNT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Ákpakpa bimbɔ áwuúge nkane Pita ne Jɔn ajɔ́ge ayi álá pɔ́ ne ɛfɔ metɔɔ́, ála mano mekpo fuú, gétúgé ákaá nnó ɛbwɔ́ ápɔ́ bɔɔ́ ne ájyɛ ŋwɛ wɔ́. Ne ɛbwɔ́ átɛ nnó Pita ne Jɔn ájɔ́ge mbɔ gétúgé ábɔ́ akɛné mɛ́ ne Jisɔs. ");
INSERT INTO anvNT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Ne ɛbwɔ́ abɔ ákagé shya fɔ́ geno ɛyige Pita ne Jɔn ábɔ́ ápyɛ́ getúgé ɛbwɔ́ ágɛné mende yi atoó mbɔ nkane atɛné nekúné aŋgbá Jisɔs bimbɔ. ");
INSERT INTO anvNT_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Ɛfɛɛ́ ne afwa ne ákpakpa melɔ bimbɔ ágaré Pita ne Jɔn nnó átané kpɛ́ dafyɛ, ne ɛbwɔ́ álagé meso, alɔ mangií atɛ áké, ");
INSERT INTO anvNT_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","“Ɛsé depyɛ nyɛ nnó ne ande bina? Yɛ́ndémuú fa né Jɛrosalɛ ákaá nnó gekpɛkpɛge ufélekpá bi, ɛle ɛbwɔ́ ne apyɛɛ́ ne ɛse dékágé shya sé. ");
INSERT INTO anvNT_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Yɛmbɔ mampyɛ nnó mechɔ ɛwé ɛmage ɛjyɛ se mbɛ, debɔ́ mamfyɛ́ bwɔ́ mema ne ɛbwɔ nnó ɛkage ákyaá manjɔɔ́ ne muú fɔ́ né mbaá mabɔ Jisɔs.” ");
INSERT INTO anvNT_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Ájɔɔ́ge mbɔ, ákuú Pita ne Jɔn ákéré mmu ne ákwelé ɛbwɔ́ mbeé nnó, “Ɛkagé ama atyaá mabɔ Jisɔs yɛ manlɛré mekomejɔɔ́ wuú mbaá muú.” ");
INSERT INTO anvNT_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Ne Pita ne Jɔn áshuú bwɔ́ meko aké, “Ɛnyú ambɔɔ́ fɛrege mechɔ ɛwé, ɛlu cho né mbɛ ushu Ɛsɔwɔ, manwu ne Ɛsɔwɔ wa manwu ne ɛnyú? ");
INSERT INTO anvNT_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Ɛse debɔ mangárégé genó ɛyi ɛsé dewuú ne dégɛné.” ");
INSERT INTO anvNT_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Ne afwa ɛso ama áfélé ɛbwɔ́ amɛ ne ályá ɛbwɔ́ nnó ájyɛ. Ɛbwɔ́ ágɛ́ fɔ meti manchyɛ bɔɔ́ Jisɔs ɛfwyale wɔ́, nendé bɔɔ́ áko áfɛ́ɛge Ɛsɔwɔ né mechɔ ɛwé ɛbɔ́ ɛpyɛ́. ");
INSERT INTO anvNT_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Ɛlé ufélekpá wáwálé, mende yi ápyɛ́mbɔ ji atoó apwɔ usaá aŋmɛ upéa. ");
INSERT INTO anvNT_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Ndɛre bɔɔ́ bimbɔ álya Pita ne Jɔn ákérége meso, ágaré ɛkwɔ bwɔ́ genó ɛyige anɔɔ́ baá bií apyɛ upɛ Ɛsɔwɔ ne ákpakpa melɔ abɔ ajɔɔ́. ");
INSERT INTO anvNT_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Bɔɔ́ Jisɔs awúge mbɔ, ácho melu ɛma anɛnemmyɛ mbaá Ɛsɔwɔ aké, “Átá yi apwɔ amu, wɔ yi ɔkwyɛ́ mfaa ne mme ne manyi ne unó uko bi úlú wyɛ. ");
INSERT INTO anvNT_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Ɔpyɛ gekwenege ntɛ ɛsé Dɛvid, maa utɔɔ́ wyɛ, ajɔɔ́ né uto Mendoó Ukpea nnó, ‘Ulannó bɔɔ́ abi álá pɔ́ bɔɔ́ Jus matɔɔ́ ásɔ́ bwɔ́ dɔɔ́? Ulannó bɔɔ́ melɔ átɛnege ukɔlɔ ne Ɛsɔwɔ detuú? ");
INSERT INTO anvNT_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Afwa abi mme ákpómege mmyɛ mámyɛ bee, ne ákpakpa melɔ átɛnege ukɔ́lɔ́ mamyɛ ne Ɛsɔwɔ ne muú yi ji ajyá nnó abɛ Muú yi Ɛsɔwɔ akweré ji ɛlá gefwa.’ ");
INSERT INTO anvNT_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Genó ɛyigé Dɛvid abɔ́ ajɔɔ́ mbɔ, gepyɛ wáwálé fa melɔ ɛwé. Mfwa Hɛrɔd ne Pontyɔs Palɛt, chóncho ne abifɔ abi álá pɔ́ bɔɔ́ Jus ne bɔɔ́ Isrɛli ásɔ mala manwá Jisɔs, Jisɔs muú utɔɔ́ melɔ́mélɔ́ wyɛ ayi ɔbɔ ɔjyaá nnó abɛ Muú yi wɔ ɔkwere ji ɛlá gefwa. ");
INSERT INTO anvNT_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Ɛbwɔ áchomé mbɔ, ápyɛ le geno ɛyige wɔ Ɛsɔwɔ né uto byɛ, ɔbɔ́ ɔkwyɛ mɛ́ ɔbɛlé nnó ubɔ mampyɛ́. ");
INSERT INTO anvNT_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Átá nana gɛ́ nkane ɛbwɔ́ áfelege ɛse amɛ. Pyɛ ɛsé, baá utɔɔ́ byɛ dégarégé mekomejɔɔ́ wyɛ débɛgé fɔ́ ne ɛfɔ́ɔ metɔɔ́. ");
INSERT INTO anvNT_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Pyɛ ɛse, depyɛge bɔɔ́ mamée atoóge ne dema depyɛgé ufélekpá né utó bi Jisɔs, muú utɔɔ́ melɔ́mélɔ́ wyɛ, nnó bɔɔ́ ákpá amɛ ágɛ́ utó byɛ.” ");
INSERT INTO anvNT_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Gébégé ánéré manɛmmyɛ, mme meko anyií né mbaá yi ɛbwɔ́ alú. Mendoó Ukpea ɛchwɔ gbeé ɛbwɔ́ metɔɔ́ ne ɛpyɛ ɛbwɔ́ alɔ mangare mekomejɔɔ́ Ɛsɔwɔ ayi álá pɔ́ ne ɛfɔ́. ");
INSERT INTO anvNT_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Né ɛchomele bɔɔ́ abi áfyɛɛ́ metɔɔ́ ne Jisɔs, álu meko ama ne metɔɔ́ ɛma. Muú ɛbwɔ́ fɔ ayi ájɔge nnó genó ɛyigé na ɛlé ɛya apɔ́. Ne genó ɛyigé muú ama awya, gelu ɛyigé bɔɔ́ akó. ");
INSERT INTO anvNT_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Áŋgbá Jisɔs ágarege ájyɛ ne ɛshyɛ mampyɛ bɔɔ́ ákaá nnó, Ata Jisɔs akwilé né negbo. Ne Ɛsɔwɔ apoóge ɛbwɔ́ ako dɔɔ́. ");
INSERT INTO anvNT_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Yɛ muú ayi genó gelií ji apɔ́. Ɛwyage bɔɔ́ ákpóo makɔɔ́ yɛ upú bwɔ, ");
INSERT INTO anvNT_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","ne áchwɔ́ ne manka yimbɔ mbaá áŋgbá Jisɔs. Ɛbwɔ́ ákaré manka mbaá bɔɔ́ bi ákamé ne Jisɔs ako nkane yɛ́ndémuú ákɛlege. ");
INSERT INTO anvNT_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Mende fɔ ntó abɔ́ alu ɛfɛɛ́ ayi ákuú ji Josɛf, atane ula gepú ámpyɛɛ́ upɛ Ɛsɔwɔ. Ábyɛ́ ji né melɔ Syaprɔs ne áŋgbá Jisɔs ntó akuú ji Banabas. (Ula utɛne nnó Memfyɛ́ bɔɔ́ ɛshyɛ.) ");
INSERT INTO anvNT_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Ne akpó ntó mekɔɔ́ wuú ɛwé ɛma achwɔ ne ŋka yimbɔ mbaá áŋgbá Jisɔs. ");
INSERT INTO anvNT_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Ne mende fɔ ayi ákuú ji, Ananiya ne mendée wuú Safira abɔ́ ákame maŋkpó melu mme bwɔ́ ɛma. ");
INSERT INTO anvNT_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Yɛ́mbɔ ɛbwɔ́ ne mendée wuú ákame mambi ŋka ɛyifɔ, ne ákpá ɛyi ɛlaá áchwɔ chyɛ́ɛ áŋgbá Jisɔs. ");
INSERT INTO anvNT_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Ne Pita agií Ananiya aké, “Ulannó ɔlyaá danchɔmeló akpɛne mmu metɔɔ́ wyɛ? Nde gepyɛ́ɛ ɔbií gebagé ŋka ɛyigé ɔsɛle ne ɔchwɔ́ byɔ gebyɔ mbaá Mendoó Ukpea? ");
INSERT INTO anvNT_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Mekɔɔ́ ɛwé ɔkpoó ɛbɔ ɛlu ɛwyɛ, ne ŋka yi ɔsɛle ɛle ɛjyɛ. Nde gepyɛɛ́ ɔpyɛ gefɔge mechɔ ɛwéna? Ɔfɛré nnó ɔbwɔlege mbɔ le bɔɔ́ ayi ɔbyɔge mbɔ le gebyɔ mbaá Ɛsɔwɔ.” ");
INSERT INTO anvNT_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","6","Ananiya awúge mbɔ, akwé mme, agbó. Njyɛ usa akɛle ndeé, afyale geŋkwɔ́ jií, ákpá ájyɛ nií. Bɔɔ́ ako bi áwuú mechɔ ɛwé, ɛfɔ́ɔ ɛkwɔ́ ɛbwɔ́ matɔɔ́. ");
INSERT INTO anvNT_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Nchwanekɛ ɛlɛɛ́ ɛke ɛkwɔnege mendée wuú achwɔ kpɛ mmu, ayi álá kaá mechɔ ɛwé ɛpyɛ menɔ wuú wɔ́. ");
INSERT INTO anvNT_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Ne Pita agií ji aké, “Gare me wáwálé wyɛ, nnó ŋka ɛyi ɛnyú ne menɔ wyɛ desɛlé né mekɔɔ́ ɛwé dekpó ná”? Ne Safira akame aké ɛbyɛmbɔ. ");
INSERT INTO anvNT_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Ne Pita ama gií ji aké, “Ndé gepyɛ ɛnyú ne menɔ wyɛ dekame manchwɔ mua Mendoó Ata Ɛsɔwɔ? Gɛ́ majyá bɔɔ́ né menombi, ɛlé bɔɔ́ bi ajyɛ nií menɔ wyɛ, ákpáne nyɛ wɔ ntó áfɛ́ anií.” ");
INSERT INTO anvNT_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Pita ajɔge mbɔ, tɛ́netɛne Safira akwé mbɛ ushu wuú, agbó. Njɛ usa bimbɔ ákpɛgé mmu, ágɛ́ nnó ágbo ne ákpá, ji ajyɛ nii kwɔ́kwɔ́lé ne menomé menɔ wuú. ");
INSERT INTO anvNT_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Bɔɔ́ Jisɔs ne bɔɔ́ bifɔ́ ako abi abɔ́ áwuú mechɔ ɛwé, ábɔ́ ɛfɔ́ɔ. ");
INSERT INTO anvNT_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Áŋgbá Jisɔs ábɔ ápyɛ́ɛ gejamégé ufélekpa ne ukpɛ́kpɛ́ uno ɛbi ulɛré utó Ɛsɔwɔ né metɔɔ́ metɔɔ́ bɔɔ́. Ɛbwɔ́ ne bɔɔ́ bi akame ne Jisɔs ako achwɔ́ yɛndégébé né ɛcha upɛ Ɛsɔwɔ, ajwɔlege né melu ɛwé ákuú ɛgbɛ ɛwé Solomun. ");
INSERT INTO anvNT_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Yɛ muú yi akya manchó ne ɛbwɔ́ apɔ́. Yɛ́mbɔ bɔɔ́ ako áfɛ́ge bwɔ́ dɔɔ́. ");
INSERT INTO anvNT_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Yɛ nkane ɛlúmbɔ gejamégé bɔɔ́ áfyɛɛ́ matɔɔ́ ne Jisɔs ne gejamégé andée ne ande akpɛ́ne né ɛchomele bɔɔ́ bií. ");
INSERT INTO anvNT_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Gétúgé ufélekpá ɛbi aŋgbá Jisɔs apyɛ́ɛ, bɔɔ́ ákpáne bɔɔ́ mameé bwɔ́ né ulɔ́ ne ábélege né anɔɔ́ mati nnó Pita ake akóge ɛfɛɛ́, mendoó wuú ɛkage kóo ɛbwɔ́ mmyɛ. ");
INSERT INTO anvNT_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Ne gejamégé bɔɔ́ ntó ábɔ́ átané né malɔ ayi álu kwɔ́kwɔ́lé ne Jɛrosalɛ, áchwɔ́ ne bɔɔ́ mameé ne abi aló nchyɛ achyɛge bwɔ́ ɛfwyale mbaá áŋgba Jisɔs, ápyɛ ɛbwɔ́ ako átóoge. ");
INSERT INTO anvNT_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Ɛtukpɛ ampyɛ upɛ Ɛsɔwɔ ne ɛkwɔ wuú, abi alu né geluage bɔɔ́ Sadusi awya gembya né matɔɔ́ bwɔ́ ne aŋgbá Jisɔs, ");
INSERT INTO anvNT_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","ne átɔ́ bɔɔ́ ájyɛ pyɛ áŋgbá Jisɔs, áfyɛ́ denɔ. ");
INSERT INTO anvNT_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Yɛ́mbɔ, né utuú bimbɔ, ɛkiɛ́nné Ɛsɔwɔ ɛchwɔ néné manombi gepúge denɔ ɛbwɔ́ átané ne ɛké ne ɛbwɔ́, ");
INSERT INTO anvNT_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Chóge mmu ɛcha upɛ Ɛsɔwɔ, detɛne, degare bɔɔ́ bi alu ɛfɛɛ́ mekomejɔɔ́ yi áchwɔ ne geŋwá gekɛ.” ");
INSERT INTO anvNT_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Ne ɛbwɔ́ áwúge mbɔ ujyage ájyɛ kpɛ mmu ɛcha upɛ Ɛsɔwɔ, alɔ manlɛrege bɔɔ́. Ɛke ɛwyage ɛtukpɛ ampyɛ́ɛ upɛ Ɛsɔwɔ ne ɛkwɔ wuú ne ákpakpa bɔɔ́ Isrɛli áchomé né ɛso. Átɔ́ bɔɔ́ bee né gepúge denɔ nnó ajyɛ gbaré aŋgbá Jisɔs bimbɔ áchwɔ ne ɛbwɔ́. ");
INSERT INTO anvNT_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Ɛbwɔ́ ájyɛ́gé ɛwu ágɛ́ bwɔ wɔ́, ne ákeré meso áké, ");
INSERT INTO anvNT_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Ɛse defɛ́ né gepúge denɔ, degɛ́ nnó ágbɛ́ manombi chancha, ne bɔɔ́ bi ábáme átɛné wyɛ. Ne gébégé ɛbwɔ́ ánené manombi, degɛ yɛ muú né mmu wɔ́.” ");
INSERT INTO anvNT_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Muu kpa bɔɔ́ bi ábáme ɛcha upɛ Ɛsɔwɔ ne anɔ́ baá bi apyɛ upɛ Ɛsɔwɔ áwuge mbɔ makpo átya bwɔ́ mmu. Ne álɔ mangií gemɛ bwɔ́ áké, “Mechɔ ɛwé ɛbɛ nyɛ nnó?” ");
INSERT INTO anvNT_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Wyɛ gébé ɛyigembɔ muú fɔ́ atané né dafyɛ, áchwɔ ajɔɔ́ aké, “Gɛge bɔɔ́ abi ɛnyú degbɛ́ mmu gepúge denɔ, álu nana mmu ɛcha upɛ Ɛsɔwɔ, álɛrege bɔɔ́.” ");
INSERT INTO anvNT_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Ájɔge mbɔ muu kpa bɔɔ́ abi ábáme ɛcha upɛ ne ɛkwɔ wuu áfɛ́ ásɛ́ ɛbwɔ́ alɔ manchwɔ. Yɛ́mbɔ ája bwɔ́ jame wɔ́, getúgé áfɔ́ɔ nnó bɔɔ́ bi álu mmu, átóme nyɛ ɛbwɔ́ né mataá. ");
INSERT INTO anvNT_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Áchwɔgé ne ɛbwɔ́, ápyɛ aŋgbá Jisɔs átɛné mbɛ ushu ákpakpa melɔ. Ne ɛtukpɛ ampyɛ́ɛ upɛ Ɛsɔwɔ agií bwɔ́ ake, ");
INSERT INTO anvNT_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Pɔ ɛsé debɔ́ dekwelé ɛnyú mbeé nnó degarege sé bɔɔ́ depɔré Jisɔs. Ne nana depyɛ mekomejɔɔ́ ayi akɛ agyaá Jɛrosalɛ meko, ɛnyú dekɛlege nnó bɔɔ́ áshúle ɛsé ndo nnó ɛsé dékaá ula negboné Jisɔs.” ");
INSERT INTO anvNT_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Pita ne áŋgbá Jisɔs abifɔ áshuú meko áke, “Ɛse debɔ́ mampyɛ le genó ɛyige Ɛsɔwɔ akɛlege, ɛpɔ́fɔ́ ɛyigé akwaá ákɛlege. ");
INSERT INTO anvNT_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Ɛsɔwɔ yi ukwené antɛ sé, ne apyɛ Jisɔs akwíle né negbo, Jisɔs ayi ɛnyú dewáné né gekwa. ");
INSERT INTO anvNT_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Ne Ɛsɔwɔ abwɛ mabɔ mií, apyɛ ji ajwɔle né geluɔ ɛyi gelu né ɛ́gbɛ́ ɛbwɔnyɛ́ wuú nnó ji abɛ Menɔmbɛ ne Menchyɛ́ geŋwá. Apyɛ mbɔ nnó bɔɔ́ Isrɛli ákwɔre matɔɔ́ bwɔ́, ne ji ajinte gabo bwɔ́. ");
INSERT INTO anvNT_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Ɛse delu bɔɔ́ abi áfyɛ nnó degarege uno bi, ne ɛse degarege chóncho ne Mendoó Ukpea ɛwé Ɛsɔwɔ abɔ achyɛ mbaá bɔɔ́ abi awuú ne ji.” ");
INSERT INTO anvNT_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Bɔɔ́ ɛso áwuge mbɔ, nchyɛ anwyɔné ɛbwɔ́ tɛ ábɔ́ ákɛlege manwá áŋgbá Jisɔs. ");
INSERT INTO anvNT_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Gamalya, muú ama né geluage bwɔ akwile ka aké, ásɛ́ kpɛ́ bɔɔ́ bimbɔ átáné dafyɛ. Gamalya alu muú Farasi ne ménlɛré mabɛ́ Ɛsɔwɔ, bɔɔ́ ako ntó anogé ji, ajɔɔ́ aké, ásɛ bɔɔ́ bimbɔ átané kpɛ dafyɛ. ");
INSERT INTO anvNT_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Ɛwyagé ajɔɔ́ ne bɔɔ́ ɛso aké, “Bɔɔ́ Isrɛli fɛrege mechɔ ɛwé dekɛlege mampyɛ ne bɔɔ́ bina cháŋéné. ");
INSERT INTO anvNT_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Tɛge, gébé gefɔ́, mende fɔ ayi ákuú ji Tɛudas, alomé ne ɛwu nnó ji alu menɔ muú. Bɔɔ́ bi akwɔle ji, álu genóge melɛɛ́. Gébégé áwáné ji, bɔɔ́ bi átyaá uchome bií ukwé. ");
INSERT INTO anvNT_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Ne mende fɔ nto abɔ́ ama lome ne ɛwu né gébé ɛyige ápáné bɔɔ, ákuú ji Judas abɔ atane melɔ Galilií. Apyɛ gejamégé bɔɔ́ ákwɔlé ji. Yɛ́mbɔ gébégé áwané ji, bɔɔ́ bi átyaá ne mabɔ mií mánó. ");
INSERT INTO anvNT_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Ndɛre mechɔ ɛwé ɛlúmbɔ, nchyɛge ɛnyú majyɛ́ nnó delya bɔɔ́ bi ajyɛ, ɛ́kágé dépyɛ ɛbwɔ́ genó. Mbɔgé unó bi ɛbwɔ́ ágarege ne ápyɛ utané né amu ákwaá, unómé nyɛ. ");
INSERT INTO anvNT_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Ne mbɔgé utané né amu Ɛsɔwɔ, dekágé tɛne fɔ ukɔ́lɔ́ ne ɛbwɔ́. Ɛnyú dekage gɛ́ nnó demyɛ mbɔ le ne Ɛsɔwɔ. Ne bɔɔ́ ɛso ako awúge mbɔ, ákamé ne ji.” ");
INSERT INTO anvNT_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Ne ɛbwɔ́ áku áŋgbá Jisɔs nnó ákéré mmu, áchwɔge ásɛ́ bwɔ́ ne matúle, ne ákwelé bwɔ́ mbeé nnó ámage gare se bɔɔ́ mechɔ Jisɔs. Ɛfɛɛ́ ne álya bwɔ́ nno ájyɛ́. ");
INSERT INTO anvNT_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Ndɛre ɛbwɔ́ átané né ɛso, ájyɛ́, álu ne metɔɔ́ megɔmegɔ, nnó Ɛsɔwɔ agɛ́ nnó ɛbwɔ́ ákwane mankpa mekpo genɔɔ́ né getuge Jisɔs. ");
INSERT INTO anvNT_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Yɛndé bií álɛrege bɔɔ́ né ɛcha upɛ Ɛsɔwɔ ne ákɛne ntó upú upú ágarege bɔɔ́ abya melɔ́mélɔ́ nnó Jisɔs alu Muú yi Ɛsɔwɔ akweré ji ɛlá gefwa. ");
INSERT INTO anvNT_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Né gébé ɛyigembɔ, ɛchomele bɔɔ́ Jisɔs ɛwɛ́ne ɛjyɛ́ mbɛmbɛ nkane gejamégé bɔɔ́ ábánege bwɔ́. Abi ajɔge mejɔɔ́ Grek abɔ ásɔɔ́ matɔɔ́ ne abi Hibru nnó áfwalege akwi andeé bwɔ́ né uno bi ákarege yɛndé bií. ");
INSERT INTO anvNT_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Ne aŋgbá Jisɔs afyaneapéa ákuú bɔɔ́ Jisɔs ako ne ake ne ɛbwɔ́, “Ɛpɔ́fɔ́ chó nnó ɛsé delyaá mangaré mekomejɔɔ́ Ɛsɔwɔ, depane le depɔre menyɛɛ́ mankaré. ");
INSERT INTO anvNT_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Ne aŋmɛ́ sé, ndɛre ɛlúmbɔ, ɛlɔ́ nnó ɛnyú déjyá bɔɔ́ akeneama nnó ápyɛgé utɔɔ́ ɛbi. Bɔɔ́ bina abɔ́ mambɛ abi bɔɔ́ ako ákamé nnó awya gepɔ gelɔ́gelɔ́ ne ákaáge geno cháŋéné ne Mendoó Ukpea ɛgbeé bwɔ́ matɔɔ́. ");
INSERT INTO anvNT_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Ne ɛsé aŋgbá Jisɔs dechyɛge nyɛ gemɛ se geko né mmyɛ manɛne ne mangarege mekomejɔɔ́ Ɛsɔwɔ.” ");
INSERT INTO anvNT_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Ne bɔɔ́ ako áwúge mbɔ, matɔɔ́ agɔ́ bwɔ́. Ne ajya Stɛfɛn ayi áfyɛɛ́ metɔɔ́ ne Jisɔs dɔɔ́ ne Mendoó Ukpea ɛgbeé ji metɔɔ́. Abifɔ alú Filip ne Prokɔrɔs, Nikanɔ ne Timɔn, Pamɛnas ne Nikolyɔs ayi atané melɔ Antiɔk ayi alaá muú Jus. ");
INSERT INTO anvNT_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Ɛbwɔ́ áchwɔ ne bɔɔ́ bimbɔ né mbɛ ushu áŋgbá Jisɔs, ne áŋgbá Jisɔs ánɛre bwɔ́ amu mmyɛ anɛmmyɛ ɛta bwɔ́. ");
INSERT INTO anvNT_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Ne mekomejɔɔ́ Ɛsɔwɔ akɛne agyage, ne ɛchomele bɔɔ́ Jisɔs ɛwé ɛlu né Jɛrosalɛ ɛwɛne ɛjyɛ mbɛ, ne gejamégé ampyɛ upɛ Ɛsɔwɔ ákwɔ́lege ntó depɔré Jisɔs. ");
INSERT INTO anvNT_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Stɛfɛn yina ayi ɛbwɔ́ ábɔ́ ajya, alu muú yi mejé Ɛsɔwɔ ɛbɔ́ ɛlu ne ji ne Ɛsɔwɔ achyɛge ji uto apyɛ ufélekpá ne ukpɛkpɛ uno né metɔɔ́ metɔɔ́ bɔɔ́. ");
INSERT INTO anvNT_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Bɔɔ́ Jus fɔ́ áchwɔ́, álɔ manyɛɛ́ mbeé ne Stɛfɛn. Ɛbwɔ́ ne áwya ɛcha mmyɛmenɛne ɛwé akuú ɛcha bɔɔ́ bi átané defwɛ́. Ɛbwɔ́ abɔ átané melɔ Sɛren ne Aleksanda ne abifɔ nto atané gebagé mewaá Silisya ne Ɛsya. ");
INSERT INTO anvNT_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Ɛbwɔ́ ápulé mankwɔre depɔ tire Stɛfɛn agare meti ɛpɔ́, getuge Mendoó Ukpea ɛbɔ ɛchyɛge ji deŋgare mejɔɔ́. ");
INSERT INTO anvNT_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Ne ɛbwɔ́ achyɛ́ bɔɔ́ fɔ́ unyiɛlé nnó áchwɔ́ byɔ gebyɔ nnó ɛbwɔ́ abɔ́ áwuú nkane Stɛfɛn ájɔɔ́ge mejɔɔ́ mebomebo ne Ɛsɔwɔ ne Mosis. ");
INSERT INTO anvNT_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Mechɔ ɛwé ɛsɔ́ bɔɔ́ matɔɔ́ chóncho ne ákpakpa melɔ ne anlɛre mabɛ́ Ɛsɔwɔ. Ne ájyɛ pyɛ́ Stɛfɛn áchwɔ né mbɛ ushu ɛchomele ákpakpa bɔɔ́ Jus. ");
INSERT INTO anvNT_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Bɔɔ́ bina áchwɔ ne bɔɔ́ bifɔ abi ágaré gebyɔ ake, “Mende yina ajɔɔ́ge mejɔɔ́ mebomebo mbaá ɛcha upɛ Ɛsɔwɔ se yɛndé bií ne mabɛ́ Mosis. ");
INSERT INTO anvNT_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Ɛsé debɔ́ dewú ji ajɔɔ́ ake, Jisɔs, mende Nasarɛt ammuú nyɛ ɛcha upɛ Ɛsɔwɔ ne akwɔrege nyɛ ntó gepɔge melɔ geko ɛyi Mosis abɔ́ alɛré ɛsé.” ");
INSERT INTO anvNT_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Bɔɔ́ ako abi abɔ́ alu né ɛcha ɛso ɛwémbɔ, átó Stɛfɛn amɛ mmyɛ ne ágɛ́ nnó ushu bi ukwɔré úlú ɛke ɛbi ɛkiɛ́nné Ɛsɔwɔ. ");
INSERT INTO anvNT_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Ne ɛtukpɛ ampyɛ́ upɛ Ɛsɔwɔ ɛgií Stɛfɛn ɛke, “Unó bi bɔɔ́ bina ájɔge nnó úlú wáwálé?” ");
INSERT INTO anvNT_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Stɛfɛn ashuú ɛbwɔ́ meko ake, “Antɛ ba ne aŋmɛ ba wuúge, gemɛ́gé nnó gekwenege ntɛ ɛsé Abraham awile gebu né melɔ Haran, Ɛsɔwɔ, Mfwa geŋbɔ́ alɛré nya mmyɛ gébégé Abraham abɔ́ alú né melɔ́ Mesopotemya. ");
INSERT INTO anvNT_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Ne abɔ́ ajɔɔ́ nya ne ji ake, ‘Lyaá ula gepú byɛ ne melɔ wyɛ, cho né melɔ ɛwé nlɛrege nyɛ wɔ.’ ");
INSERT INTO anvNT_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Tɛ́nétɛ́né yimbɔ, Abraham alyaá melɔ Chalda ajyɛ jwɔle né melɔ́ Haran. Ne ntɛ Abraham ágbógé nya, Ɛsɔwɔ apyɛ Abraham nnó alyaá melɔ ɛwémbɔ achwɔ́ né melɔ ɛwé ɛsé delu mbɔ wyɛ nana. ");
INSERT INTO anvNT_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Ndɛre abɔ alu fɛɛ́, Ɛsɔwɔ achyɛ fɔ́ ji yɛ ɛkɛkɛ melu mme nnó ɛbɛ ɛwu wɔ́. Yɛ́mbɔ Ɛsɔwɔ anyɛ́meno nnó achyɛge ji melɔ ɛwena nnó ɛbɛ́ ɛwú ne upyáne bií. Ɛsɔwɔ abɔ́ ajɔɔ́ depɔ ti gébégé Abraham álá pɔ́ yɛ ne maá. ");
INSERT INTO anvNT_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Ne Ɛsɔwɔ ama jɔɔ́ ne ji ake, ‘Upyáne byɛ ubɛɛ́ nyɛ aŋkɛɛ́ né melɔ ɛwéchá, ubɛɛ́ nyɛ nkane afwɛ ne bɔɔ́ áfwalege nyɛ bwɔ́ né usaá aŋmɛ ɛsaá. ");
INSERT INTO anvNT_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Yɛ́mbɔ nchyɛge nyɛ bɔɔ́ melɔ ɛwémbɔ gekpɛ́kpɛ́gé ɛfwyale ne upyáne byɛ ulyagé melɔ ɛwémbɔ uchwɔ́ unóge me fa.’ ");
INSERT INTO anvNT_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Ne Ɛsɔwɔ abɔ achyɛ Abraham gepɔgé menomenyɛɛ́ ɛwémbɔ ɛyi gelu mansɔ nsɔ. Ne Abraham ábyɛ́gé nya Asek, ndɔ ɛnée ɛ́kwɔ́négé, asɔ ji nsɔ. Isek ntó asɔ́ nya maá wuú Jakɔb nsɔ ne Jakɔb ntó asɔ́ nya baá bi afyaneapéa nsɔ abi álú nto ukwene antɛ se abi nana. ");
INSERT INTO anvNT_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Ɛwyágé, ukwéne antɛ sé bina, ákɛ́légé sé mangɛ́ meŋmɛ́ bwɔ́ Josɛf ne ákpó Jɔsɛp nkane mefwɛ né melɔ Ijip. Yɛ́mbɔ Ɛsɔwɔ abɔ abame wyɛ ji, ");
INSERT INTO anvNT_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","ne aféré ji né ɛfwyale meko ɛwé ji abɔ́ agɛ́ne. Achyɛ́ ntó deŋga ɛti depyɛ Fɛro mfwa bɔɔ́ Ijip agboó ne ji. Fɛro apyɛ́ ji ala muú kpaá melɔ Ijip ne apɛlé ntó ula gepú bií. ");
INSERT INTO anvNT_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Ɛ́wyágé ɛmímí mesa akwé né melɔ Ijip chóncho ne melɔ Kanaan, bɔɔ́ ágɛ́ ɛfwyale dɔɔ́ ne ukwéne antɛ se upɔ́ nya ne menyɛɛ́. ");
INSERT INTO anvNT_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Ne Jakɔb awuúgé nnó menyɛɛ́ alu né melɔ Ijip, atɔ́ baá bií abi alu ukwéne antɛ se ɛwu. Gɛ ndɔ mbɛ ayi ɛbwɔ́ ájyɛ ɛwu na. ");
INSERT INTO anvNT_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Ne ndɔ ayifɔ yi ɛbwɔ́ ajyɛ, Josɛf apyɛ aŋmɛ́ bií akaá ji, ne Fɛro Mfwa bɔɔ́ Ijip ntó achwɔ́ kaá ula gepú Josɛf. ");
INSERT INTO anvNT_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Ne Josɛf atɔ́ bɔɔ́ nnó ájyɛ́ sɛ ntɛ wuú Jakɔb ne ula gepú bií uko áchwɔ́ jwɔlé né Ijip. Bɔɔ́ ula gepú bií ako abɔ́ álú usaá ulɛɛ́ meso nekuú né gébé ɛyigembɔ. ");
INSERT INTO anvNT_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Jakɔb awuúge mbɔ, akpá ulagepú bií uko, ashulé afɛ né Ijip. Ji ne baá bi abi alu ukwéne antɛ ɛsé ála nya ɛwu ágbó ɛbwɔ́ ako. ");
INSERT INTO anvNT_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Ɛ́wyágé bɔɔ́ ákpá uŋkwɔ́ bwɔ́, áfɛ́ né melɔ Shechɛm, ánií né manome ayi alu muú mataravɛ́ ne melu ɛwé Abraham abɔ anamé ne ŋka mbaá matoó Hamɔ ntɛ Shɛkɛm. ");
INSERT INTO anvNT_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Gemɛge nnó gébé gekwɔné ɛyigé Ɛsɔwɔ áchwɔ pyɛ genó ɛyigé ji abɔ anyɛ́meno ne Abraham, bɔɔ́ ɛsé abi abɔ́ alu né melɔ Ijip, ája kpaá apwɔ amu. ");
INSERT INTO anvNT_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Ne áfyɛ́ mfwa ayicha né Ijip ayi álá kaágé Josɛf. ");
INSERT INTO anvNT_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Mfwa yina achwɔ́ ne defya mbaá bɔɔ́ sé. Afwalege ɛbwɔ́ ne apyɛ́ɛ bwɔ́ nnó abelégé baá bwɔ́ abi kɔkɔ né dafyɛ nnó agbó. ");
INSERT INTO anvNT_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Wyɛ né gébé ɛyigembɔ ne ábyɛné ntó Mosis. Mosis abɔ alú maá yi alɔme ulɔɔ́ dɔɔ́ né amɛ Ɛsɔwɔ. Áwɛɛ́ ji né ámfaá álɛɛ́ né gepú bwɔ́. ");
INSERT INTO anvNT_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Ne gébégé alyá ji dafyɛ, maá mfwa Fɛro ayi mendée achwɔ́ akware ji, awɛɛ́ ji ne asɛ́ nkane maá wuú. ");
INSERT INTO anvNT_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Ne ɛbwɔ́ álɛre Mosis deŋgare bɔɔ́ Ijip deko ne awɛɛ́ abɔ alu gekpɛ́kpɛ́gé muú ne awya mekomejɔɔ́ meno melɔ́mélɔ́, ne mempyɛ unó. ");
INSERT INTO anvNT_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Mosis akwɔnege nya usaá aŋmɛ upéa, ɛkwɔ́ ji metɔɔ́ nnó ajyɛ gɛ́ aŋmɛ́ bií; bɔɔ́ Isrɛli. ");
INSERT INTO anvNT_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Ndɛre ajyɛ́, agɛ́ nkane muú Ijip fɔ́ atulege muú Isrɛli, achwɔ́ geŋgá ne awá muú Ijip yimbɔ. ");
INSERT INTO anvNT_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Mosis abɔ afɛré nnó aŋmɛ́ bií abɔ ákaáge nyɛ nnó Ɛsɔwɔ atɔ́me nyɛ ji nnó achwɔ́ féré ɛbwɔ́ né ɛfwyale. Yɛ́mbɔ ákaá wɔ́. ");
INSERT INTO anvNT_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Bií ujyagé ama ajyɛ gɛ́ bɔɔ́ Isrɛli apéa nkane amyɛ ne atɛ. Amua mangbaré ɛbwɔ́ ne ajɔɔ́ ne ɛbwɔ́ aké, ‘Ɛnyú delu aŋmɛ́, demyɛ ndé?’ ");
INSERT INTO anvNT_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Yɛ́mbɔ muú ayi abɔ akɛlé meŋmɛ́ wuú mpa, ammu Mosis ne agií ji ake, ‘Nde muú afyɛ́ wɔ nnó ɔbɛ́ Mfwa ɛsé ne ɔpane depɔré ɛsé?’ ");
INSERT INTO anvNT_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","‘Ɔkɛlege ntó manwá me nkane ɔbɔ ɔwané muú Ijip yimbɔ njuú?’ ");
INSERT INTO anvNT_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Mosis awuúge mbɔ, ɛfɔ́ ɛkwɔ ji metɔɔ́ ne alyaá Ijip, abó afɛ́ né melɔ́ Midiyan. Alá ɛwu, abá mendée, abyɛ baá ande apéa. ");
INSERT INTO anvNT_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Usaá aŋmɛ́ upéa ukoóge, Mosis agɛ́ ɛkiɛ́nné Ɛsɔwɔ né mewɛ ɛwé ɛbɔ ɛlúle né genɔɔ́. Ɛwena ɛpyɛ né mashwɔne, kwɔ́kwɔ́lé ne mekwɛ Sinay. ");
INSERT INTO anvNT_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Mosis agɛgé mewɛ ɛwémbɔ, ala meno mekpo fuú. Ne ndɛre ajyɛ kwɔ́kwɔ́lé mangɛ ɛwu cháŋéné, Átá Ɛsɔwɔ jɔɔ́ ɛfɛɛ ake, ");
INSERT INTO anvNT_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Ɛlé me Ɛsɔwɔ ayi ukwene antɛ byɛ, Ɛsɔwɔ ayi Abraham, ne ayi Asek ne Jakɔb.’ Mosis awuúge mbɔ, alɔ maŋweré ne ɛfɔɔ́ ne akɛlege sé mampɛ melu ɛwémbɔ. ");
INSERT INTO anvNT_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Ne Ɛsɔwɔ ama jɔɔ́ ne ji ake, ‘Féré uno uka byɛ nende melu ɛwé ɔtɛné mbɔ ɛlé melu ukpea. ");
INSERT INTO anvNT_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Me ngɛ́ gekpɛ́kpɛ́gé ɛfwyale ɛwé áchyɛge bɔɔ́ ba né Ijip, ne nwú magbo ayi ɛbwɔ́ alile ne mesómé. Nkawu ne nshulé mme nnó nchwɔ́ mféré ɛbwɔ́ né ɛfwyale ɛwémbɔ. Nana cho, ntɔme wɔ né Ijip.’ ");
INSERT INTO anvNT_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“Ne Ɛsɔwɔ atɔ́ Mosis yina nnó ájyɛ́ ábɛ́ memféré bɔɔ́ Isrɛli né ɛfwyale ne amá bɛ mfwa bwɔ́. Ji ne bɔɔ́ Isrɛli abɔ́ ashya agií ji aké, ‘Nde muú afyɛ wɔ mfwa ne mepane depɔré ɛsé?’ Ne nana Ɛsɔwɔ abɔ́ atɔ́ ɛkiɛ́nné wuú ɛwé Mosis agɛ́né nkane mewɛ né genɔɔ́ ɛyigémbɔ nnó ɛchyɛ Mosis ɛshyɛ mampyɛ utɔɔ́ bií. ");
INSERT INTO anvNT_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Ne Mosis ajyɛ́ apyɛ gejamége ufélekpá ne ukpɛ́kpɛ́ unó né Ijip ne alé féré bɔɔ́ Isrɛli. Ama pyɛ gejamégé ufélekpá né ɛbɛɛ́ megɛlé, ne mashwɔné ayi ɛbwɔ́ ábɔ́ ábɛlé wyɛ usaá aŋmɛ upéa. ");
INSERT INTO anvNT_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Wyɛ Mosis yina ne abɔ́ ajɔɔ́ ne bɔɔ́ Isrɛli nno, ‘Ɛsɔwɔ atɔme nyɛ ɛnyú Muú ɛkpávé wuú ayifɔ wyɛ nkane atɔme me ne atanege nyɛ né ntone ɛnyú.’ ");
INSERT INTO anvNT_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Ɛma ɛlu wyɛ Mosis yina ne ɛkiɛ́nné Ɛsɔwɔ ɛbɔ́ ɛjɔɔ́ mejɔɔ́ ne ji né mfaá mekwɛ Sinay, gébégé ji ne ukwene antɛ ɛsé abɔ́ áchomé né mashwɔne. Ne ɛkiɛ́nné Ɛsɔwɔ ɛwémbɔ ɛchyɛ́ ji mabɛ Ɛsɔwɔ ayi alu tɛ kwyakwya nnó achyɛ ɛse. ");
INSERT INTO anvNT_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Né gébé géfɔ́ ukwene antɛ sé bina akɛlege sé manwu Mosis ne áke ji ábélé babá, ne ábɔ́ ákɛlege mankéré né Ijip. ");
INSERT INTO anvNT_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Ne ɛbwɔ́ ájɔɔ́ ne Ɛrɔn áké, ‘Kwyɛ́ ɛsé áló uka nnó ájámé ɛsé meti, Mosis ayi aféré ɛsé né Ijip, dekaá fɔ́ genó ɛyi gepyɛ́ ji né mfaá mekwɛ wɔ́.’ ");
INSERT INTO anvNT_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Ála mbɔ ákwyɛ́ meló uka ayi áfulé mpɔ, áwané menya, ápyɛɛ́ upɛ ájele meló uka yimbɔ nkane uka bwɔ́, ne matɔɔ́ agɔɔ́ bwɔ́ yɛndégébé né genó ɛyigé ákwyɛ́ ne amu. ");
INSERT INTO anvNT_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Ne Ɛsɔwɔ agɛge mbɔ, ati meso ne ɛbwɔ́ ne alyaá ɛbwɔ́ nnó ápyɛ nkané ɛji ɛbwɔ́. Ne ɛbwɔ anoge mŋmɛɛ́, mfaá, ne ambe wyɛ nkane ábɔ́ ásámé né ŋwɛ bɔɔ́ ɛkpávé bií nnó, ‘Bɔɔ́ Isrɛli, ɛnyú dekɛne né mashwɔne né usaá aŋmɛ upea, dewane menya depyɛ́ upɛ, yɛ́mbɔ depyɛ́ fɔ́ upɛ bimbɔ né ɛta wa. ");
INSERT INTO anvNT_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Depyɛ le ɛta áló uka abi ɛnyu dekwyɛ ne amu. Dekpane gétogé melo uka ayi ákuu Molɔk, ne dekpane ntó membe melo uka ayi ákuu Refan. Né getú ɛyige na mbúu nyɛ ɛnyú défɛ́ tɛtɛ dekoó Babilɔn.’ ");
INSERT INTO anvNT_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“Ne nkane ukwene antɛ ɛse bina ábɔ́ ála né mashwɔne mbɔ ábɔ́ áwya gétogé upɛ ɛyi gelɛré nnó Ɛsɔwɔ abɔ álú ne ɛbwɔ́. Mosis ne abɔ́ akwyɛ́ geto ɛyina wyɛ nkane ɛyige Ɛsɔwɔ abɔ́ alɛré ji nnó apyɛ. ");
INSERT INTO anvNT_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Ɛbɛ́légé baá bwɔ́ ásɛ gétógé upɛ ɛyigembɔ mbaá ukwene antɛ ɛsé bimbɔ, ákpa geji gébégé ábɔ́ ákɛ́né ájyɛ ne Joshua áfɔɔ́ge mme bɔɔ́ abi alu ɛfɛɛ́. Ndɛre ájyɛ, Ɛsɔwɔ alu bwɔ́ mbɛ abuú bɔɔ́ bimbɔ né malɔ. Ne geto yina gela fa kpaá tɛ gébé ɛyige Mfwa Dɛvid agbaré melɔ ɛwé. ");
INSERT INTO anvNT_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Dɛvid abɔ alu muú yi Ɛsɔwɔ abɔ́ ájelé ji dɔɔ. Né gébé géfɔ́ ji anɛmmyɛ nnó Ɛsɔwɔ agɔ ji atɛ́né ji gepu, ji ayi alu Ɛsɔwɔ Jakɔb. ");
INSERT INTO anvNT_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Yɛ́mbɔ ɛle Solomun, maá mfwa Dɛvid, ne abɔ atɛné gepúgé Ɛsɔwɔ. ");
INSERT INTO anvNT_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“Yɛ́mbɔ ɛpɔfɔ nnó Anyátá Ɛsɔwɔ ajwɔlege né upú ɛbi bɔɔ́ atɛné, wyɛ nkane Muu Ɛkpávé Ɛsɔwɔ abɔ́ asamé nnó Ɛsɔwɔ ake, ");
INSERT INTO anvNT_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Mfaánebuú alu geluɔ́ ya ne mme alu genɔɔ́ ɛyige nnɛ́rege uka ba. Nde gefɔɔ́ gepú ɛyigé muú akage atɛne nnó mbɛ́ wyɛ? Melu fɔ́ ɛlu ɛwé nkage jwɔle wyɛ? ");
INSERT INTO anvNT_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Pɔ́ me mbɔɔ́ ne nkwyɛ unó bina ukó?’ ");
INSERT INTO anvNT_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","“Stɛfɛn ájɔ́gé mbɔ, aké ne ɛbwɔ́, “Ɛnyu antoó makpo, ne bɔɔ́ bi áŋeáge matɔɔ́, ɛnyú degbɛ́ matu ɛke bɔɔ́ bi ála kage Ɛsɔwɔ. Ɛnyú deshya yɛndé gebé genó ɛyigé Mendoó Ukpea ɛjɔ́ge wyɛ nkane ukwéne antɛ ɛnyu ábɔ́ ápyɛ́. ");
INSERT INTO anvNT_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Muú ɛkpávé Ɛsɔwɔ fɔ alu ayi ukwene antɛ nyú abɔ álá kɛlé manchɔ ji geŋwá wɔ́? Ábɔ́ áwá bɔɔ́ bi Ɛsɔwɔ atɔmé nnó ábɔ́ mbɛ ágaré nnó Maá utɔɔ́ Ɛsɔwɔ ayi wáwálé achwɔ. Ne achwɔ́gé ɛnyú dechyɛ́ ji maŋkwá ne dewá ji. ");
INSERT INTO anvNT_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Wyɛ ɛnyú abi depyɛ mbɔ ne debɔ́ desɛlé mabɛ ayi makiɛ́nné Ɛsɔwɔ áchyɛ ɛnyú ne nána deshya mambélé aji.” ");
INSERT INTO anvNT_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Bɔɔ́ kpakapa melɔ áwuge depɔ́ ɛtiré Stɛfɛn ajɔɔ́, nchyɛ anwyɔné ɛbwɔ́, amɛ ágɛlé ɛbwɔ́ mekpo. ");
INSERT INTO anvNT_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Yɛ́mbɔ Stɛfɛn apɛ nfaánebuú domeé, Mendoó Ukpea ɛgbeé ji metɔɔ́ ne agɛ́ geŋgbɔge Ɛsɔwɔ ne ama gɛ Jisɔs nkane atɛné né ɛgbɛ ɛbwɔnyɛ Ɛsɔwɔ. ");
INSERT INTO anvNT_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Ne Stɛfɛn aké, “Pɛge degɛ́, ngɛ́ mbɔ memombi mfaanebuú ɛnené, ne Maá Ntɛ Mekwaá atɛ́né né ɛgbɛ ɛbwɔnyɛ́ Ɛsɔwɔ.” ");
INSERT INTO anvNT_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Áwuúgé mbɔ, ágbɛ́ amu matu, ádo ɛlúlú, awɔ achwɔ́ ji mmyɛ ágbaré ji, ");
INSERT INTO anvNT_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","ája ji, áfɛ́ mekpo meti, álɔ mantome ji mataá nnó áwá ji. Ne bɔɔ́ abi ábɔ́ ámalé Stɛfɛn mechɔ mmyɛ, áferé mandeé bwɔ́ áchyɛ gesagé muú ayi ákuú ji Sɔl ne álɔ Stɛfɛn mántó. ");
INSERT INTO anvNT_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Ne nkane átome ji, Stɛfɛn anɛmmyɛ áké, “Átá Jisɔs sɛ mendoó wa.” ");
INSERT INTO anvNT_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Ɛwyágé ató mánó mme, akalé keŋké ake, “Atá Ɔfyɛgé fɔ́ bɔɔ́ bina mmu metɔɔ́ né gabo ayi ɛbwɔ́ ápyɛ́ɛ mbɔ.” Ajɔgé mbɔ metɔɔ́ ɛkwé, ne Sɔl atɛné ɛfɛɛ́ akamege ne mekpo nnó áwá ji. ");
INSERT INTO anvNT_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Wyɛ né bii bimbɔ, bɔɔ́ álɔ mankɛlé mati manchɔ geŋwágé bɔɔ́ Jisɔs né Jɛrosalɛ. Ne ɛbwɔ́ ábó átyaá áfɛ́ né gebagé mewaá Judiya ne Samariya. Wyɛ áŋgbá Jisɔs ne áláa né Jɛrosalɛ. ");
INSERT INTO anvNT_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Nkane Stɛfɛn abɔ agbó, bɔɔ́ fɔ́ abi ánoge Ɛsɔwɔ abi áláa né Jɛrosalɛ ákpá geŋkwɔ́ ji anií ne ali ji ne gekpɛ́kpɛ́gé mesóme. ");
INSERT INTO anvNT_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Yɛ́mbɔ Sɔl amyɛ ɛle nnó ánii mbwɛ bɔɔ́ Jisɔs ako. Akpɛne upú upú apyɛne andeé ne ande áfyɛ́ né denɔ. ");
INSERT INTO anvNT_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Ne bɔɔ́ áŋkwɔlé Jisɔs abi ábɔ́ átyaá, ákɛne malumalu ágarege mekomejɔɔ́ Ɛsɔwɔ. ");
INSERT INTO anvNT_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Filip abɔ ashulé áfɛ́ né melɔ Samariya ɛwé kpaá, agarege depɔré Muú yi Ɛsɔwɔ akweré ji ɛlá gefwa. ");
INSERT INTO anvNT_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Bɔɔ́ áwuú depɔ ɛtire ji ajɔge, ne ágɛ́ gejamégé ufélekpá ɛbi ji abɔ apyɛ, ne áta matu ákɛlege nno agarege wyɛ ɛbwɔ́ garege. ");
INSERT INTO anvNT_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Ne aló nchyɛ átanege gejamégé bɔɔ́ mmyɛ ákalege, ne bɔɔ́ átoógé. Bɔɔ́ uchanchi ne ubwéré bɔɔ́ átoó ntó ");
INSERT INTO anvNT_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Ne bɔɔ́ melɔ ɛwémbɔ álú ne gejamégé nechɔ́chɔ́. ");
INSERT INTO anvNT_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Mende fɔ abɔ́ alu ɛfɛɛ́ ayi ákuú ji Simun. Abɔ́ akpea megya tɛ gachi ne bɔɔ́ Samariya ako ála mano mekpo fuú. Ne asɛle gemɛ ji nnó alu menɔ muú. ");
INSERT INTO anvNT_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Bɔɔ́ ako, ambané ne bɔɔ́ kpakpa átá matu awuú genó ɛyigé Simun ajɔge, ɛbwɔ́ áké: “Mende yina awya uto Ɛsɔwɔ ɛbi upwɔ amu.” ");
INSERT INTO anvNT_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Ne ɛbwɔ́ afwɔrege wyɛmbɔ néndé abwɔlége mɛ ɛbwɔ́ tɛ gachi né megya ayi ji akpea. ");
INSERT INTO anvNT_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Ne Filip achwɔ́gé, agarege bɔɔ́ abya melɔ́mélɔ́ nkane gefwage Ɛsɔwɔ gelu, ne depɔré Jisɔs Kras, bɔɔ́ ákamé ne ji andée ne ande ne áwyaá bwɔ́ manaá Ɛsɔwɔ. ");
INSERT INTO anvNT_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Simun jimbɔɔ́ ntó áfyɛɛ́ metɔɔ́ ne Jisɔs ne áwyaá ji manaá Ɛsɔwɔ. Ne ji ajwɔlé fií ne Filip, agɛne ufélekpá ne ukpɛ́kpɛ́ unó bi ji apyɛ́ ne aláa meno mekpo fuú. ");
INSERT INTO anvNT_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Ne áŋgbá Jisɔs abi abɔ áláa né Jɛrosalɛ, áwuúge nnó bɔɔ́ Samariya nto ákamé mekomejɔɔ́ Ɛsɔwɔ, átɔ́ Pita ne Jɔn ɛwu. ");
INSERT INTO anvNT_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Ájyɛge, ágɛ́ bɔɔ́ bi ákame ne Jisɔs ɛwu ne álɔ manɛmmyɛ nnó Ɛsɔwɔ átɔ́ bwɔ́ Mendoó Ukpea, ");
INSERT INTO anvNT_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","nendé Mendoó Ukpea ɛ́lú dankpɛ́ ɛbwɔ́ mmyɛ. Ábɔ́ áwyaá ɛbwɔ́ manaá Ɛsɔwɔ mamímamí nkane bɔɔ́ bi ákwɔlege Átá Jisɔs. ");
INSERT INTO anvNT_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Pita ne Jɔn ánerege manɛmmyɛ, ánɛ́ré ɛbwɔ́ amu mmyɛ ne Mendoó Ukpea ɛchwɔ ɛbwɔ́ mmyɛ. ");
INSERT INTO anvNT_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Simun agɛ́gé nkane áŋgbá Jisɔs ánéré bɔɔ́ amu mmyɛ ne Mendoó Ukpea ɛkpɛné ɛbwɔ́ mmyɛ, achyɛ́ ɛbwɔ́ ŋka, ");
INSERT INTO anvNT_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","ake, “Kpoge me uto bina nnó nnɛrégé muú ɛbwɔ́ mmyɛ Mendoó Ukpea ɛkpɛ ji mmyɛ.” ");
INSERT INTO anvNT_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Ne Pita ajɔɔ́ ne ji aké, “Ɛchyɛ wɔ ɔnó ne ŋka jyɛ. Ɔféré nnó muú akage na ɛchyɛ Ɛsɔwɔ ne ŋká? ");
INSERT INTO anvNT_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Ɔbɔ́ mechɔ né utɔɔ́ ɛbi wɔ́, nende metɔɔ́ wyɛ ɛpɔ́ pópó né mbɛ ushu Ɛsɔwɔ. ");
INSERT INTO anvNT_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Ne nana kwɔre metɔɔ́ wyɛ né ubobo unó bi ɔferege, ne ɔnɛmmyɛ nnó Ɛsɔwɔ ajinte gabo yina ayi ɔmɛɛ́ mampyɛ. ");
INSERT INTO anvNT_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Ngɛ nnó ɔkií fɔ́ galɔ́gálɔ́, ne gabo awɛ́ wɔ nkane muú denɔ.” ");
INSERT INTO anvNT_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Ne Simun akwɔ Pita ne Jɔn mata nnó, “Ɛbwɔ́ ánɛ́mmyɛ mbaá Átá Ɛsɔwɔ nnó ɛkage geno gemá ɛyige ɛbwɔ́ ajɔɔ́ gepyɛ́ ji.” ");
INSERT INTO anvNT_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Pita ne Jɔn ánérégé mangaré mekomejɔɔ́ Ɛsɔwɔ, álɔ mankéré né Jɛrosalɛ. Ne ndɛre ájyɛ́, ágarege abya Ɛsɔwɔ melɔ́mélɔ́ né gejamgé malɔ bɔɔ́ Samariya. ");
INSERT INTO anvNT_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Filip alagé meso, ɛkiɛ́nné Ɛsɔwɔ ɛchwɔ́ ɛjɔɔ́ ne ji ɛké, “Kwili, shule ɔjyɛ́ né ntɛ melɔ. Ɔkwɔnégé ɛwu, kwɔlé meti ɛwé ɛtane Jɛrosalɛ ɛjyɛ Gasa. Meti ɛwé ji ajɔgembɔ bɔɔ́ ákɛ́né sé wyɛ dɔɔ́ dɔɔ́.” ");
INSERT INTO anvNT_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","28","Filip awugé mbɔ ashule afɛ́ ɛwu. Agɛ́ mende fɔ abɔ ajyɛ nóge Ɛsɔwɔ né Jɛrosalɛ, akerege né mekɔ wuú, ajwɔle né mboó gese uka upea ayi géjuŋá ne gejame. Abɔ́ alu muu kpaá né melɔ Ɛtopya ji agbarége ɛgbɔgɔlɔ mekwa ŋka ɛwe Kandise Mfwa mendée ayi abɔɔ́ melɔ ɛwémbɔ. Abɔ́ ajwɔle ajɔge ŋwɛ ayi Asaya muu ɛkpavé Ɛsɔwɔ asámé. ");
INSERT INTO anvNT_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Ne Mendoó Ukpea ɛjɔɔ́ ne Filip ɛké, “Kɛ chó bané mboó gese yimbɔ.” ");
INSERT INTO anvNT_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Ɛfɛɛ́ ne Filip abó ajyɛ bané ji ne awuú ndɛre mende yimbɔ ajɔge ŋwɛ Asaya. Filip agií ji aké, “Ɔkagembɔ genó ɛyige ɔjɔge?” ");
INSERT INTO anvNT_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Mende yimbɔ aké, “Mpyɛ mbɔ nnó ne nkaá ayi muú álá pɔ́ mangaré me ula wɔ́.” Ne akuú Filip nnó akwɔ́ mfaá mboó gese, ajwɔle ne ji. ");
INSERT INTO anvNT_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Melu ŋwɛ ɛwé ji ajɔge mbɔ ɛké, “Abɔ́ alu nkane ɛgɔŋme ɛwé ágbaré ájyɛ wá, yɛ mankale ɛkále wɔ́ wyɛ nkane maá ɛgɔŋme ayi ákpálege ji bya mmyɛ álá kálégé. ");
INSERT INTO anvNT_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Áchyɛ́ ji mekpo genɔɔ́ ne yɛ muú yi apané mpa wú cho apɔ́. Wáa akuú nyɛ́ mabɔ baá bii nkane áchɔɔ́ mbɔ ji geŋwá”? ");
INSERT INTO anvNT_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Muú kpaá yimbɔ agií Filip aké, “Garé me, Muú ɛkpávé Ɛsɔwɔ yina ajɔge mbɔ depɔ ti getuge wáa? Ajɔgémbɔ le ne gemɛ jii waá ne muú yichá?” ");
INSERT INTO anvNT_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Ne Filip alɔ mangaré ji né ŋwɛ yina, abya melɔ́mélɔ́ ayi akɛné atúu ne Jisɔs. ");
INSERT INTO anvNT_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Ndɛre ákɛne ájyɛ́, ákwɔné mbaá yi nnyi nélú, muú kpaá yimbɔ ake, “Gɛ́ nnyi na, ndé gemage gbɛ́ nnó ɔwyaágé me manaá Ɛsɔwɔ?” ");
INSERT INTO anvNT_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Filip ashuú ji meko aké, “Mbɔge ɔfyɛgé metɔɔ́ meko ne Jisɔs nkage wyaá wɔ manaá Ɛsɔwɔ”. Ne ake: “Nkame nnó Jisɔs alu Maá Ɛsɔwɔ”. ");
INSERT INTO anvNT_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Ne Muú kpaá yimbɔ aké ápyɛ mboó gese atɛné ɛbwɔ́ ne Filip áshulé áfɛ́ né nnyi, ne Filip awyaá ji manaá Ɛsɔwɔ. ");
INSERT INTO anvNT_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Ɛbwɔ́ átánégé mmu nnyi, Mendoó Ata ɛkpa Filip ayi mende yimbɔ álá gɛ sé ji wɔ́. Yɛ́mbɔ akɛné wyɛ ajyɛ ne nechɔ́chɔ́. ");
INSERT INTO anvNT_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Filip ake apɛle agɛ́ nnó ji alu né Asɔtus, ne akɛne ajyɛ, agarege abya melɔ́mélɔ́ né malɔ ayi álú né gebagé mewaá ɛyigembɔ kpaá tɛ akwɔné melɔ Kaisaria. ");
INSERT INTO anvNT_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Yɛ́mbɔ Sɔl alú tóme ɛshyɛ, afelege bɔɔ́ Jisɔs amɛ nnó awane ɛbwɔ́, nká wu ne ajyɛ agɛ́ ɛtukpɛ ampyɛ́ upɛ Ɛsɔwɔ, ");
INSERT INTO anvNT_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","nnó asá bɔ ŋwɛ atɔ́ né macha mmyɛmenɛne bɔɔ́ Jus áyi álú né melɔ Damaskɔs nnó mbɔgé ajyɛgé agɛ́gé bɔɔ́ bi akwɔlege meti Jisɔs, apyɛ bwɔ́, awɛ́, achwɔ́ ne ɛbwɔ́ né Jɛrosalɛ. ");
INSERT INTO anvNT_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Ndɛre alya ajyɛ́, gébégé alɛ kwɔ́kwɔ́lé ne Damaskɔs wyɛ mbélépó geŋgbɔ́ gétané mfaánebuú, geshwané gegyá ji mme. ");
INSERT INTO anvNT_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Geŋgbɔ́ ɛyimbɔ gékpɛ́gé ji amɛ, akwé mme ne awú nkane muú fɔ akuú ji aké, “Sɔl, Sɔl, ndé ɔkɛlege manchɔ me geŋwá?” ");
INSERT INTO anvNT_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Sɔl agií aké, “Wɔ waá Átá?” Meko yimbɔ aké, “Ɛ́lé me Jisɔs ayi ɔkɛlege manchɔ ji geŋwá. ");
INSERT INTO anvNT_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Yɛ́mbɔ kwili ka, kwɔné né melɔ ɛwémbɔ, ɛfɛɛ́ ágárege nyɛ́ wɔ geno ɛyige ɔbɔɔ́ mampyɛ.” ");
INSERT INTO anvNT_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Bɔɔ bi ábɔ́ ákɛ́ne ne Sɔl áwúgé meko yimbɔ, ágɛ́ muú fɔ wɔ́, matyɛ mawá bwɔ́ meno. ");
INSERT INTO anvNT_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Sɔl akwilege tɛné, agɛ́né sé mbaá. Ágbaré ji ɛbwɔ áfɛ́ ne ji né Damaskɔs. ");
INSERT INTO anvNT_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Abɛlé ndɔ ɛlɛɛ́ né melɔ ɛwémbɔ, yɛ mbaá agɛné, menyɛɛ́ anyɛɛ́, manaá anyú. ");
INSERT INTO anvNT_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Muú Jisɔs fɔ abɔ́ alú né Damaskɔs yimbɔ ákuú ji Ananya. Ne bií fɔ́ agɛ́ Jisɔs né amɛ gejyá, ne Jisɔs akuú ji aké, “Ananya” ne Ananya ashuú ji meko aké, “Átá gɛ́ me na.” ");
INSERT INTO anvNT_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Ne Jisɔs aké ne ji, “Kwile ka, ɔjyɛ́ né menɔ meti ayi ákuú nnó Cho. Ɔkwɔnégé né gepú Judas, gií mende fɔ ayi atané melɔ Tasɔs, ákuú ji Sɔl. Alu ɛfɛɛ́ anɛnemmyɛ, ");
INSERT INTO anvNT_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","ne abɔ́ agɛ́ amɛ gejyá ndɛre mende yi ákuú ji Ananya achwɔ nɛre ji amu mmyɛ nnó ama lɔ́ mangɛné.” ");
INSERT INTO anvNT_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Yɛ́mbɔ Ananya aké, “Átá, gejamégé bɔɔ́ ágaré mɛ́ me nkane mende yina akɛlege manií mbwɛ bɔɔ́ byɛ né Jɛrosalɛ. ");
INSERT INTO anvNT_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Ne anɔɔ́ baá áchyɛ́ ji uto nnó áchwɔ pyɛ bɔɔ́ ako bi anɛ́nemmyɛ ákuú mabɔ myɛ.” ");
INSERT INTO anvNT_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Ne Átá Jisɔs aké ne ji, “Chó wyɛ ɛwu néndé njya mende yimbɔ nkane muú utɔɔ́ wa nnó agaré mekomejɔɔ́ wa mbaá bɔɔ́ abi álá pɔ́ bɔɔ́ Jus ne afwa bwɔ́ ne bɔɔ́ Isrɛli ntó. ");
INSERT INTO anvNT_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Me nlɛrege nyɛ ji nkane ábɔɔ́ mangɛ́ gejamégé ɛfwyale getú ya.” ");
INSERT INTO anvNT_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Ne Ananya ajyɛ kpɛ́ mmu gepú ɛyigé Sɔl alu wyɛ, anɛ́ré ji amu mmyɛ ne ajɔɔ́ ne ji aké, “Meŋmɛ́ wa Sɔl, ɛle Ata Jisɔs ayi ɔbɔ́ ɔgɛné né meti gébégé ɔchwɔ fa, ne atɔmé me nnó nchwɔ́ mpyɛ wɔ ɔma ɔgɛ́né ne nnó Mendoó Ukpea ɛchwɔ kpɛ ɛgbeé wɔ metɔɔ́.” ");
INSERT INTO anvNT_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Wyɛ tɛnétɛné yimbɔ, Sɔl awuú unó fɔ́ ɛké ufá meshuú utané ji amɛ ne alɔ mangɛ́né. Ne akwili ka, áwyá ji manaá Ɛsɔwɔ. ");
INSERT INTO anvNT_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Ne ama lɔ menyɛɛ́ manyɛɛ́, anyɛge abɔ́ ɛshyɛ. Sɔl abɛlé mboó ndɔ́ né Damaskɔs ne bɔɔ́ Jisɔs, ");
INSERT INTO anvNT_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","afɛ́ tɛnétɛné né macha mmyɛmenɛne bɔɔ́ Jus, agarege bɔɔ́ nnó Jisɔs alu Maá Ɛsɔwɔ. ");
INSERT INTO anvNT_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Bɔɔ́ áwúgé mbɔ, ɛpwɔ́ ɛbwɔ uto ne ágigé atɛ áké, “Pɔ́ mende yi akɛ́ne, awáne bɔɔ́ bi akwɔlege Jisɔs né Jɛrosalɛ na? Pɔ́ achwɔ fa manwɛ́ bɔɔ́ ájyɛ ne ɛbwɔ́ né Jerúsalɛ”? ");
INSERT INTO anvNT_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Yɛ́mbɔ Sɔl ajyɛ wyɛ mbɛ, agarege mekomejɔɔ́ Jisɔs ne ɛshyɛ ne apyɛ bɔɔ́ ákaá né gejamégé mati nnó Jisɔs alu Muú yi Ɛsɔwɔ akweré ji ɛlá gefwa. Ɛwémbɔ ɛpyɛ bɔɔ́ Jus abi álu ɛfɛɛ́ né Damaskɔs ápɔ́ sé ne meko manshuú ji. ");
INSERT INTO anvNT_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Ɛbɛ́légé gejamégé ndɔ, bɔɔ́ Jus áchomé ásɔ́ mala manwá Sɔl. ");
INSERT INTO anvNT_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Yɛ́mbɔ Sɔl áwuú geju nnó bɔɔ́ Jus ájwɔlé né mano geŋkagé melɔ, ábáme nnó ágɛ́gé ji awá. ");
INSERT INTO anvNT_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Yɛ́mbɔ bɔɔ́ bi akamé mekomejɔɔ́ Sɔl, ásɛ ji utuú uma, afyɛ né gésá, ápyɛ ji achyá mfaá geŋka, áshulé ji mme nnó ábó ajyɛ. ");
INSERT INTO anvNT_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Sɔl akérége né Jɛrosalɛ, afɛ́ mancho ne bɔɔ́ Jisɔs, ɛbwɔ́ ábó néndé ɛbwɔ́ ákamé fɔ́ nnó Sɔl áfyɛɛ́ metɔɔ́ ne Jisɔs wɔ́. ");
INSERT INTO anvNT_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Yɛ́mbɔ Banabas achwɔ́ sɛ ji, áfɛ́ mbaá áŋgbá Jisɔs. Ne agaré ɛbwɔ́ nkane Sɔl agɛné Átá Jisɔs né meti Damaskɔs, ne nkane Atá Jisɔs ajɔɔ́ mejɔɔ́ ne ji. Ama garé nkane Sɔl abɔ́ agaré depɔ ɛtire Jisɔs gbɔgɔnɔ né melɔ ɛwémbɔ. ");
INSERT INTO anvNT_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Ɛfɛɛ́ alɔ mankɛné ne bɔɔ́ Jisɔs ako né Jɛrosalɛ, agarege depɔré Jisɔs ayi álá pɔ ne ɛfɔ. ");
INSERT INTO anvNT_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Gébé ɛyi gefɔ, Sɔl agarege bɔɔ́ Jus abi ajɔge Grek ne anyɛ mbeé ne ɛbwɔ́ né depɔré Jisɔs. Ne ɛbwɔ́ ákɛ́lege meti manwá ji. ");
INSERT INTO anvNT_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Bɔɔ́ Jisɔs áwúgé geju ɛyigembɔ, ásɛ ji áshulé áfɛ́ né melɔ Kaisaria ne até ji nnó ajyɛ melɔ́ Tasɔs. ");
INSERT INTO anvNT_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Né gébé ɛyigembɔ machomele bɔɔ́ Jisɔs ayi álu né gebagé mewaá Judiya, né Galilií ne Samariya ápɔ́ sé ne ɛfɔ metɔɔ́. Ɛbwɔ́ ánóge Ɛsɔwɔ ne áwuú le mekomejɔɔ́ wú. Mendoó Ukpea ɛfyɛɛ́ bwɔ́ ɛshyɛ ne machomele bwɔ́ áwɛne ájyɛ mbɛ. ");
INSERT INTO anvNT_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Pita abɔ akɛne malɔmalɔ agɛne bɔɔ́ Ɛsɔwɔ. Ne bií uma afɛ́ né melɔ Lyda mangɛ́ bɔɔ́ Jisɔs abi alu ɛwu. ");
INSERT INTO anvNT_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Ɛfɛɛ́ agɛ́ mende fɔ ayi ameé uchanchi, ákuú ji Ɛnias. Nemeé ɛni néba ji mme né aŋmɛ́ aneé. ");
INSERT INTO anvNT_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Ne Pita ajɔɔ́ ne ji aké, “Ɛnias, Jisɔs Kras alɔ mampyɛ wɔ nnó ɔtoó, kwili ka, pwi gébɔ jyɛ.” Tɛnétɛné yimbɔ Ɛnias akwili ka. ");
INSERT INTO anvNT_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Ne bɔɔ́ ako abi alú né Lyda ágɛgé nnó mende yimbɔ atoó, ɛbwɔ́ áfyɛ́ matɔɔ́ ne Jisɔs wyɛmbɔ ntó ne bɔɔ́ bi álú né gebage mewaá Sharɔn áwuúge mbɔ áfyɛ ntó matɔɔ́ ne Jisɔs. ");
INSERT INTO anvNT_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Mendée fɔ abɔ alu né melɔ Jopa, ákuú ji Tabita, alu maá utɔɔ́ Jisɔs. (Ne ákuú ji né meko Grek nnó Dokas, ula utɛné nnó mekwɔbu.) Abɔ́ apyɛ galɔ́gálɔ́ yɛndegébé, apoóge ubyá bɔɔ́. ");
INSERT INTO anvNT_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Né gébé ɛyigémbɔ, akwé nemée, ala mbɔ agbó. Ne áshwɔné geŋkwɔ ji ábɛlé mmu maá gepú né mfaá ɛyɔŋ. ");
INSERT INTO anvNT_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Jopa yina alu kwɔ́kwɔ́lé ne Lyda. Bɔɔ́ Jisɔs áwuúgé nnó Pita alu né Lyda átɔ́ ande apea ɛwu, ájyɛgé áké ne ji, “Ntɛ ɛsé, chwɔ́ wáwá.” ");
INSERT INTO anvNT_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Ne Pita akpomé mmyɛ, akwili, afɛ́ ne ɛbwɔ́. Ákwɔ́négé ásɛ ji akwɔ́ mfaá ɛyɔŋ. Ne akwi andée ako abi alu ɛfɛɛ́, áchomé ánɔ ji mme, álíli álɛrege Pita ufɔɔ́ mandeé ayi Dokas ájomé ɛbwɔ́ gébégé ji alu mebɛ. ");
INSERT INTO anvNT_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Pita abú ɛbwɔ́ ako atané dafyɛ, ató manó mme anɛnemyɛ mbaá Ɛsɔwɔ. Ɛké ɛwyage apɛ geŋkwɔ́gé mendée yimbɔ ama akuú ji ake, “Tabita, kwili ka”. Tabita anene amɛ, agɛ́gé Pita, akwili, ajwɔlé ka. ");
INSERT INTO anvNT_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Pita agbaré ji ɛbwɔ, apoó ji akwili tɛ́né. Akuú bɔɔ́ Jisɔs ne akwi andé bimbɔ, áchwɔ́gé achyɛ ji ɛta bwɔ́ ");
INSERT INTO anvNT_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Bɔɔ́ ako né gebagé Jopa áwu abya yina ne gejámé áfyɛɛ́ matɔɔ́ ne Ata. ");
INSERT INTO anvNT_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Ne Pita abɛlé gejamégé ndɔ né Jopa né gepúgé Simun, mende yi apame mekɔ́menya. ");
INSERT INTO anvNT_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Mende fɔ abɔ alu né melɔ Kaisaria. Ákuú ji Kɔnɛlyos. Abɔ́ alu muú kpáá bɔɔ́ bee né melɔ Rom. Ji ne anyáne uchome bɔɔ́ bee ɛbi ákuú nnó abi átané Itali. ");
INSERT INTO anvNT_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Ji ne bɔɔ́ dachi wú ako, ánóge Ɛsɔwɔ. Anɛnemmyɛ yɛndégébé ne apyɛ galɔ́gálɔ́ dɔɔ́ mampoó bɔɔ́ Jus abi álú mbya. ");
INSERT INTO anvNT_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Bií fɔ́ genógé káláŋká ɛlɛɛ́ ne nwɔmésé, agɛ́ amɛ gejya nkane ɛkiɛ́nné Ɛsɔwɔ ɛchwɔ kuú ji nnó, “Kɔnɛlyos.” ");
INSERT INTO anvNT_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Ɛfɔ ɛkwɔ́ ji metɔɔ́ ne ató ɛwu amɛ mmyɛ agií aké, “Átá ndé”? Ɛkiɛ́nné Ɛsɔwɔ ɛshuú ji meko ɛké, “Ɛsɔwɔ awú mmyɛmenɛné jyɛ ne agɛ́ ntó utɔɔ́ ulɔ́ulɔ́ ɛbi ɔpyɛ ne atée wɔ. ");
INSERT INTO anvNT_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Nána tɔ́ bɔɔ́ ájyɛ né melɔ́ Jopa, ákuú mende fɔ ayi akamege Simun Pita. ");
INSERT INTO anvNT_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Ji ajwɔlege ne Simun, mende yi apame mekɔmenya. Gepú jií gelú né mbale ɛbɛɛ́ mega.” ");
INSERT INTO anvNT_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Ɛkiɛ́nné Ɛsɔwɔ ɛjɔ́gé mbɔ ɛkwili ɛfɛ́, ne Kɔnɛlyos akuú bɔɔ́ utɔɔ́ bií abifɔ apeá ne akuú ntó muú bee ama né geluage abi ábamé ji ayi anoge ntó Ɛsɔwɔ. ");
INSERT INTO anvNT_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Ɛbwɔ́ achwɔ́gé agaré ɛbwɔ́ yɛndé genó ɛyi gebɔ́ gepyɛ́ ji ne átɔ́ ɛbwɔ́ né Jopa. ");
INSERT INTO anvNT_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Bií ujyágé, bɔɔ́ bimbɔ átané áfɛ́, ne káláŋká ɛfyanepea ɛké ɛkwɔnege, ɛbwɔ́ alɛ kwɔ́kwɔ́lé ne Jopa. Gébé ɛyigémbɔ ntó Pita abɔ akwɔ́ mfaá ɛyɔŋ manɛmmyɛ. ");
INSERT INTO anvNT_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Ne mesa alɔ mamyɛ ji, akɛlege menyɛɛ́ manyɛɛ́, yɛ́mbɔ menyɛɛ́ alú gambɛ́. Gébé ɛyigémbɔ ne abɔ agɛné amɛ gejyá. ");
INSERT INTO anvNT_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Agɛ́ nkane menombi mfaánebuú ɛnené, geno gefɔ ɛké gekpɛkpɛge gebagé ndé getané mfaá, geshúlege ɛké ágbaré geji né maŋkú ani. ");
INSERT INTO anvNT_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Né gebagé ndé yimbɔ ufɔɔ́ menya ufɔɔ́ ufɔɔ́, mmyɔ ne denywɔné delú wyɛ. ");
INSERT INTO anvNT_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Ne awuú meko muú fɔ aké, “Pita, kwilé ka, wá nyɛɛ́.” ");
INSERT INTO anvNT_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Pita ake, “Ŋgba Átá, tɛ ntané aló nlú ganyɛ genó ɛyigé ɛbɛɛ́ ɛsé ɛ́shyaá.” ");
INSERT INTO anvNT_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Meko yimbɔ ama jɔɔ́ ne ji aké, “Pita, ɔshyagé fɔ́ geno ɛyige Ɛsɔwɔ ake gelɔme nnó gelɔ́mé fɔ́.” ");
INSERT INTO anvNT_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Meko yimbɔ ajɔɔ́ ne ji né maŋáne alɛɛ́, ne geno yimbɔ gekwɔ́ gekéré mfaánebuú. ");
INSERT INTO anvNT_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Ndɛre Pita alu fɛ́rege ula amɛ géjya ayi ji agɛné, bɔɔ́ bi Kɔnɛlyos ábɔ́ átɔmé, ákage gepúgé Simun, áchwɔ́ tɛ́né né menó gébámé. ");
INSERT INTO anvNT_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Ɛbwɔ́ ágií áké, “Meŋkɛ́ fɔ alú fa ayi akuú ji Sinun Pita”? ");
INSERT INTO anvNT_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Ndɛre Pita alu fɛ́rege ula amɛ gejya ayi ji agɛné, Mendoó Ukpea ɛké ne ji, “Gɛ, ande fɔ alɛɛ́ alu dafyɛ, ápɛ́le wɔ. ");
INSERT INTO anvNT_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Kpóme mmyɛ, ɔshúlé ɔjyɛ ne ɛbwɔ́, ɔchɔge gébé nénde me ne ntómé ɛbwɔ́ ɛta wyɛ́.” ");
INSERT INTO anvNT_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Ne Pita ashúlé, ajyɛ báne ande bimbɔ aké, “Me ne nlú muú ayi ɛnyú dekɛlege. Nde mechɔ ɛnyu dechwɔ́?” ");
INSERT INTO anvNT_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Ɛbwɔ́ áshuú ji meko áké, “Ɛlé Kɔnɛlyos, muú kpaá bɔɔ́ bee ne atomé ɛsé nnó dechwɔ́ kuú wɔ. Ji alu muú metɔɔ́ melɔ́mélɔ́ ne anóge Ɛsɔwɔ ne bɔɔ́ Jus ako afɛɛ́ge ji. Ɛkiɛ́nné ukpea ɛchwɔ gare ji nnó akuú wɔ ɔchwɔ né gepú ji nnó ji awuú mekomejɔɔ́ wyɛ́.” ");
INSERT INTO anvNT_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Ne Pita asɛ ɛbwɔ́, ájyɛ bɛ́le ne ji. Ujyágé, Pita ne ande bimbɔ álɔ manjyɛ ne bɔɔ́ bifɔ bi ákamé ne Jisɔs abi álú melɔ Jopa áfɛ́ ntó ne ɛbwɔ́. ");
INSERT INTO anvNT_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Ákɛ́ne wyɛ ájyɛ, ujyágé ákɛ ákwɔné melɔ Kaisaria. Ne Kɔnɛlyos abɔ akuú bɔɔ́ ula gepú bii ne ajeé bií ne ɛbwɔ́ ako ábɔ́ ájwɔlé ágili Pita. ");
INSERT INTO anvNT_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Ndɛre Pita achwɔ́ kpɛ́ mmú, Kɔnɛlyos ajyɛ bane ji, ató manó mbɛ ushu wuú, alɔ manogé ji. ");
INSERT INTO anvNT_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Yɛ́mbɔ Pita agaré ji aké, “Kwilé tɛ́né, me nlu wyɛ mekwaá nkane wɔ.” ");
INSERT INTO anvNT_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Kɔnɛlyos akwili ka, Pita alɔ manjɔɔ́ ne ji ajyɛ mmu. Ndɛre akpɛné mmu, Pita agɛ́ gejamégé bɔɔ́ áchomé. ");
INSERT INTO anvNT_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Ne ajɔɔ́ ne ɛbwɔ́ aké, “Ɛnyú dekaá cháŋéné ɛbɛ́ ɛsé bɔɔ́ Jus ɛké muú Jus achónégé fɔ menyammyɛ wuú ne muú ayi álá pɔ́ muú Jus yɛ manjyɛ né gepú jí. Yɛ́mbɔ Ɛsɔwɔ alɛré me nnó mbyágé fɔ́ muú yɛ manshyɛ ji nnó alɔ́me. ");
INSERT INTO anvNT_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Ne nchwɔ́ nkane ɔkuú me yɛ gébé nchɔ́ wɔ́. Nnó ɔkage garé me ula bi ɔkuú me?” ");
INSERT INTO anvNT_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Ne Kɔnɛlyos ashuú ji meko aké, “Ndɔ ɛlɛ ɛní né gefɔ gébé yina káláŋká ɛlɛɛ́ ne nwɔmésé, mbɔ nlú mmu nnɛnemmyɛ. Ɛké ɛwyage ngɛ́ mende fɔ ayi afyɛ mandeé yi áshwánege, achwɔ tɛne me mbɛ ushu. ");
INSERT INTO anvNT_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Akuú me aké, ‘Kɔnɛlyos, Ɛsɔwɔ awuú mmyɛmenɛne jyɛ ne atée nkane ɔpoóge ubyá bɔɔ́ yɛndégébé. ");
INSERT INTO anvNT_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Tɔ́ muú fɔ né melɔ́ Jopa ajyɛ kú mende fɔ ayi akamege Simun ákuú ji ntó Pita. Alu né gepúgé Simun ayi apame mekɔ́menya, gepú jií gelu né mbale ɛbɛɛ́ mega’. ");
INSERT INTO anvNT_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Ne nwuúgé mbɔ ntɔ́ bɔɔ́ tɛ́netɛ́ne nnó áchwɔ́ ákuú wɔ́, ɛlɔ́ ndɛre ɔchwɔ́. Nana gɛ́, ɛse delu né mbɛ ushu Ɛsɔwɔ degili nnó dewuú unó uko ɛbi Átá agaré wɔ nnó ɔgaré ɛsé.” ");
INSERT INTO anvNT_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Ne Pita ajɔɔ́ aké, “Nána nkaá wáwálé nnó Ɛsɔwɔ apɔ́ fɔ́ ne aŋgyá ne bɔɔ́ bifɔ́. ");
INSERT INTO anvNT_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Mbɔgé muú anóge Ɛsɔwɔ ne ake apyɛ unó bi úlú cho yɛ atané le ndé geba, Ɛsɔwɔ asɛle ji nnó alu muú wuú. ");
INSERT INTO anvNT_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Ɛnyú debɔ́ dewuú ntó mekɔmejɔɔ́ ayi Ɛsɔwɔ atómé mbaá bɔɔ́ Isrɛli nnó Jisɔs Kras ne alu muú yi abɔ achwɔ́ pyɛ bɔɔ́ ábɛ́ nesɔ ne Ɛsɔwɔ. Kras yina ne alu Atá yi abɔɔ́ bɔɔ́ ako. ");
INSERT INTO anvNT_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Mekomejɔɔ ayi abɔ́ akwɔlé ayi Jɔn abɔ agaré ne awyaáge bɔɔ́ manaá Ɛsɔwɔ. Mekomejɔɔ́ yina álɔ né Galilií akɛ akwɔné malɔ bɔɔ́ Jus ako. ");
INSERT INTO anvNT_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Ɛnyú dekaá nkane Ɛsɔwɔ abɔ́ ajyá Jisɔs ayi Nasarɛt, apyɛ Mendoó Ukpea ɛchwɔ́ ji mmyɛ ne ama chyɛ ji uto. Akɛ mbaá meko apyɛ galɔ́gálɔ́, aféré bɔɔ́ bi alu né amu danchɔmeló apyɛ ɛbwɔ́ atóo. Ne Ɛsɔwɔ abɔ alu ne ji. ");
INSERT INTO anvNT_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Ɛsé delú bɔɔ́ bi dekpané amɛ degɛné unó uko ɛbi ji apyɛ né Jɛrosalɛ ne malɔ bɔɔ́ Jus ako. Ne bɔɔ́ Jus áwɔ́ ji mfaá gekwa, ne áwá ji. ");
INSERT INTO anvNT_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Yɛ́mbɔ ndɔ ɛlɛɛ́ ɛkwɔ́négé, Ɛsɔwɔ apyɛ ji akwile né negbo ne apyɛ Jisɔs alɛré mmyɛ mbaá bɔɔ́. ");
INSERT INTO anvNT_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Ne bɔɔ́ ako fɔ́ ágɛné ji wɔ́, ɛlé ɛsé bi Ɛsɔwɔ abɔ́ ajyá nnó meso gébé degarége mekomejɔɔ́ wuú ne degɛné ji. Ɛsé debɔ́ denyɛ́ ne denyú ne ji gébégé Ɛsɔwɔ apyɛ ji akwile né negbo. ");
INSERT INTO anvNT_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Agaré ɛsé nnó degarege mekomejɔɔ́ mbaá bɔɔ́, nnó Ɛsɔwɔ ajya ji nkane muú yi apane nyɛ mpa ayi bɔɔ́ bi alu abɛ ne abi agbó. ");
INSERT INTO anvNT_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Wyɛ Jisɔs yina ne bɔɔ́ ɛkpávé Ɛsɔwɔ ako abɔ ágaré nkane ji alu, nnó muú afyɛgé metɔɔ́ ne ji, Ɛsɔwɔ ajige nyɛ nte gabo yi muú yimbɔ apyɛ getúgé Jisɔs.” ");
INSERT INTO anvNT_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Ndɛre Pita alu ájɔge ne bɔɔ́ ako bi alu ɛfɛɛ́ áwuú, Mendoó Ukpea ɛkpɛ ɛbwɔ́ mmyɛ. ");
INSERT INTO anvNT_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","46","Bɔɔ́ bi ákamé ne Jisɔs abi ábɔ́ áchwɔ ne Pita, álu bɔɔ́ Jus. Áwuúgé nkane bɔɔ́ bimbɔ ájɔge ufɔɔ́ mejɔɔ́, áfɛ́ɛge Ɛsɔwɔ nnó aŋeá dɔɔ́. Ála mano mekpo fuú nnó Ɛsɔwɔ achyɛ́ ɛchyɛ wuú ɛwé Mendoó Ukpea mbaá bɔɔ́ abi álá pɔ bɔɔ́ Jus. Ne Pita ajɔɔ́ aké, ");
INSERT INTO anvNT_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Tɛ́ ndɛre Mendoó Ukpea ɛchwɔ́ bɔɔ́ bina mmyɛ wyɛ nkane ɛbɔ́ ɛchwɔ ɛta ɛsé, nnó muú fɔ akage gbɛ́ nnó áwyáge ɛbwɔ́ manaá Ɛsɔwɔ?” ");
INSERT INTO anvNT_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Ne Pita ake ájyɛ áwyaá ɛbwɔ́ manaá Ɛsɔwɔ né mabɔ Jisɔs Kras. Ɛwyagé bɔɔ́ bina ákwɔ Pita mata nnó abɛlé ne ɛbwɔ́ né mboó ndɔ. ");
INSERT INTO anvNT_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Ɛbɛ́légé áŋgbá Jisɔs ne bɔɔ́ Jisɔs ako, abi álú né gebagé mewaá Judiya áwuú nnó bɔɔ́ abi álá pɔ́ bɔɔ́ Jus ákamé ntó mekomejɔɔ́ Ɛsɔwɔ. ");
INSERT INTO anvNT_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Ne gepɔgé bɔɔ́ Jus gelu nnó ábɔ́ mansɔ́ muú nsɔ́ ne ákwáné mambɛ́ muú Ɛsɔwɔ. Ɛbɛ́légé Pita akérégé né Jɛrosalɛ, bɔɔ́ Jisɔs abi ágbaré gepɔ ɛyigémbɔ álɔ manwamé ne ji, ");
INSERT INTO anvNT_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","aké, “Ulannó ɔjyɛ mbaá bɔɔ́ bi álá sɔ ɛbwɔ́ nsɔ wɔ́ tɛ ɔnyɛ́ menyɛɛ́ ne ɛbwɔ́”? ");
INSERT INTO anvNT_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Ne Pita alɔ mangaré ɛbwɔ́ unó uko bi ubɔ́ upyɛ́ɛ, gema, gema aké, ");
INSERT INTO anvNT_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Ndɛre mbɔ nlu né melɔ Jopa, nnɛ́nemmyɛ, ɛké ɛwyage ngɛ́ amɛ gejya nkane genó fɔ́ getané mfaánebuú geshulege mme. Gelu ɛké gekpɛ́kpɛ́gé gebagé ndé ɛyi ágbaré manóo ani, gechwɔ́ tɛ́ne kwɔ́kwɔ́lé ne me. ");
INSERT INTO anvNT_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Né gebagé ndé yimbɔ, ngɛ́ ufɔɔ́ menya ufɔɔ́ ufɔɔ́, ɛbi bɔɔ́ asée, ɛyi mewaá, ɛyi melɔ, ne ɛyi nnyi ne denywɔné. ");
INSERT INTO anvNT_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Ne nwuú meko muú fɔ akuú me aké: ‘Pita, kwile ka, wá nyɛ.’ ");
INSERT INTO anvNT_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Nké, ‘Ŋgba Átá, tɛ ntané aló nlu danyɛ genó ɛyigé ɛbɛ́ ɛsé ɛshyá’. ");
INSERT INTO anvNT_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Ne meko yimbɔ ama jɔɔ́ ne me aké, ‘Pita ɔshyagé fɔ́ geno ɛyige Ɛsɔwɔ ake gelɔme nnó gelɔ́mé fɔ’. ");
INSERT INTO anvNT_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Meko yimbɔ ajɔɔ́ né maŋáne alɛɛ́ ne geno ɛyigémbɔ gekwɔ́ gekéré mfaánebuú. ");
INSERT INTO anvNT_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","“Wyɛ né gébé ɛyigémbɔ, ande fɔ álɛɛ́ áchwɔ́ ne gepú ɛyigé mbɔ́ njwɔlege. Muú fɔ né Kaisaria ne abɔ atɔ́mé ɛbwɔ́ nnó áchwɔ́ ákuú me. ");
INSERT INTO anvNT_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Ne Mendoó Ukpea ɛké njyɛ ne ɛbwɔ́, mbɛge fɔ́ né aŋgyá. Ne áŋmɛ́ bina akéné abi átané melɔ Jopa, akwɔle me defɛ́ né gepúge Kɔnɛlyos. ");
INSERT INTO anvNT_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Ne dékpɛ́gé mmu, Kɔnɛlyos alɔ mangaré ɛsé nkane ji abɔ́ agɛné ɛkiɛ́nné Ɛsɔwɔ né gepú jií. Ɛgaré ji nnó atɔ́ muú fɔ ajyɛ né Jopa, ákuú mende fɔ yi mabɔ mií amibɔ makamege Simun, ");
INSERT INTO anvNT_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","ne achwɔge, agarege nyɛ ji ne ɛkwɔ wuú mekomejɔɔ́ ayi aférege nyɛ ɛbwɔ́ né ɛfwyale gabo. ");
INSERT INTO anvNT_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Ne nlɔ mangaré mekomejɔɔ́ Ɛsɔwɔ, ndɛre njɔge, Mendoó Ukpea ɛchwɔ́ ɛbwɔ́ mmyɛ wyɛ nkane ɛbɔ nya mbɛ ɛchwɔ́ ɛta ɛsé. ");
INSERT INTO anvNT_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Ngɛ́gé mbɔ, ntée genó ɛyi Átá Jisɔs abɔ ajɔɔ́ ne ɛsé nnó, ‘Jɔn abɔ́ fyɛ́ bɔɔ́ né nnyi yɛ́mbɔ Ɛsɔwɔ afyɛɛ́ nyɛ ɛnyú né amu Mendoó Ukpea.’ ");
INSERT INTO anvNT_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Ne mbɔge Ɛsɔwɔ achyɛ́ bɔɔ́ bimbɔ gefɔge ɛchyɛ ɛwé ji abɔ achyɛ́ ɛsé gébégé défyɛɛ́ matɔɔ́ ne Ata Jisɔs Kras, me nlu waá mangbɛ́ ji nnó apyɛ́ge geno yi gejeé ji metɔɔ́.” ");
INSERT INTO anvNT_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Bɔɔ́ bina áwúgé mechɔ ɛwé, matɔɔ́ akwené bwɔ́ ne álɔ mamfɛɛ́ Ɛsɔwɔ áke, “Mbɔ ɛwé ɛtɛne nno Ɛsɔwɔ achyɛ́ bɔɔ́ abi álá pɔ́ bɔɔ́ Jus gébé nnó ákwɔré matɔɔ́ ne ábɔ́ geŋwá.” ");
INSERT INTO anvNT_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Ndɛre ábɔ́ achyɛ́ge bɔɔ́ abi ákamé ne Jisɔs ɛfwyale gébégé áwáné Stɛfɛn, ɛpyɛ ɛbwɔ́ átyaá malɔmalɔ. Abifɔ áfɛ́ melɔ Fonisiya, abifɔ áfɛ́ melɔ Syaprɔs ne abifɔ áfɛ́ Antiɔk. Ájyɛgé mbɔ, ágarege abya Jisɔs wyɛ mbaa bɔɔ́ Jus. ");
INSERT INTO anvNT_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Bɔɔ́ Jisɔs bifɔ átané né melɔ Syaprɔs ne Sɛren, áfɛ́ ntó né Antiɔk. Ákwɔ́négé ɛwu, ágaré abya Jisɔs mbaá bɔɔ́ Grek. ");
INSERT INTO anvNT_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Ɛsɔwɔ apoó bwɔ́ dɔɔ́ ne apyɛ gejamégé bɔɔ́ áfyɛɛ́ matɔɔ́ ne Jisɔs. ");
INSERT INTO anvNT_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Ne ɛchomele bɔɔ́ Jisɔs abi alu né Jɛrosalɛ, áwuúgé abya yina, átɔ́ Banabas né melɔ Antiɔk. ");
INSERT INTO anvNT_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Banabas ajyɛgé ɛwu, agɛ́ nnó Ɛsɔwɔ alɛ́ré ɛbwɔ́ ulɔɔ́ melu dɔɔ́, metɔɔ́ ɛgɔ ji, afyɛ́ bwɔ́ ako ɛshyɛ nnó, “Ágbarégé depɔré Jisɔs metɔɔ́ ɛma. ");
INSERT INTO anvNT_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Banabas yina alu muú yi awya gepɔ gelɔ́gelɔ́, uto Mendoó Ukpea ujá ji mmyɛ ne áfyɛɛ́ metɔɔ́ ne Ɛsɔwɔ.” Gejamégé bɔɔ́ áma ákamé abya Jisɔs né melɔ Antiɔk ne ɛchomele bwɔ́ ɛwɛ́ne ɛjyɛ mbɛ. ");
INSERT INTO anvNT_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Ɛ́bɛ́légé Banabas ajyɛ kɛ́le Sɔl né melɔ Tasɔs. ");
INSERT INTO anvNT_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Agɛ́gé Sɔl, asɛ ji, ɛbwɔ́ áfɛ́ né Antiɔk. Ábɛlé ɛfɛɛ́ ŋmɛ kpogele ne ɛchomele bɔɔ́ Kras, álɛ́rege gejamégé bɔɔ́ depɔré Ɛsɔwɔ. Ɛ́lé né Antiɔk ne álɔ mankuú bɔɔ́ bi ákamé ne Jisɔs nnó *áŋkwɔlé Kras. ");
INSERT INTO anvNT_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Né gébé ɛyigembɔ bɔɔ́ ɛkpávé Ɛsɔwɔ fɔ átané Jɛrosalɛ áshulé áfɛ́ né Antiɔk. ");
INSERT INTO anvNT_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Ne Mendoó Ukpea ɛpyɛ muú bwɔ́ ama ayi akamege Agabos akwile ka, agaré nkane mesa akwéne nyɛ mme meko. Ne ɛbɛ́légé mesa yimbɔ akwé gébégé Klodyos alu mfwa né Rom. ");
INSERT INTO anvNT_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Ndɛre bɔɔ́ Jisɔs abi álú né Antiɔk ábɔ́ áwuú mekomejɔɔ́ yina, áke, “Yɛ́ndémuú áchwɔ ŋká nkane ji awya, ɛbwɔ́ apoó aŋmɛ́ bi alu né mme Judiya.” ");
INSERT INTO anvNT_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Ɛbwɔ́ ánywérégé ŋka yimbɔ, átɔ́ Banabas ne Sɔl nnó ájyɛ́ áchyɛ́ ákpákpá ɛchomele bɔɔ́ Jisɔs né Jɛrosalɛ. ");
INSERT INTO anvNT_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Né gébé ɛyigémbɔ, mfwa Hɛrɔd alɔ mankɛlé mati manchɔ geŋwágé bɔɔ́ bifɔ́ abi álú né ɛchomele bɔɔ́ Jisɔs. ");
INSERT INTO anvNT_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Agaré nnó áwá Jɛmsi meŋmɛ́ Jɔn ne aparaja. ");
INSERT INTO anvNT_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Mfwa Hɛrɔd, agɛ́gé nnó ɛgɔ bɔɔ́ Jus matɔɔ́, agaré ntó nnó ápyɛ Pita. Ne ápyɛ ji né bii bi ányɛ ɛpaá brɛd ayi álá mualé. ");
INSERT INTO anvNT_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Ápyɛge Pita, áfyɛ́ denɔ, ne ábélé bɔɔ́ bee matoó aneé nnó ábámé ji, yɛndé ntoó neluú bɔɔ́ ani. Hɛrɔd abɔ ashu abelé nnó ɛpaá kwyakwya defwɛ ɛkogé, asɛle Pita afɛ́ mbɛ ushu bɔɔ́ nnó ápa mechɔ wuú. ");
INSERT INTO anvNT_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Ndɛre Pita alu né denɔ, ɛchomele bɔɔ́ Jisɔs ánɛnemmyɛ dɔɔ́ mbaá Ɛsɔwɔ ne ɛshyɛ yɛndégébé né getú ji. ");
INSERT INTO anvNT_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Né utuú bi Hɛrɔd abɔ́ ashuú nnó ujyage aférége Pita né denɔ, ápa mpa wuú, Pita abɔ abɛlege metɔɔ́ metɔɔ́ bɔɔ́ bee apea. Ɛbwɔ́ ábɔ́ awɛ́ ji amu ne bɔ mkpɔkɔvɛ́ apea. Bɔɔ́ bee bifɔ́ álú dafyɛ ábáme gepúgé denɔ. ");
INSERT INTO anvNT_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Wyɛ né utuú bimbɔ ɛkiɛ́nné Ɛsɔwɔ ɛkwɔ́ mmu gepúgé denɔ mbélépó, ne mbaá meko agɛné. Ɛnyigé Pita né neŋkɔɔ́, Pita apée gejyá, ɛké ne ji, “kwile ka wáwá”. Tɛ́nétɛ́né yimbɔ bɔ mkpɔkɔvɛ́ átané Pita amu ákwé mme. ");
INSERT INTO anvNT_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Ɛma jɔɔ́ ne ji ɛké: “Fyɛ mandeé jyɛ ne unó uká byɛ, ɔwɛ́ ɛkanda ɔkwɔ́lé me.” ");
INSERT INTO anvNT_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Pita akwɔlé ji ne ndɛre ɛbwɔ́ átanege dafyɛ, ji akaá fɔ nnó geno ɛyige ɛkiɛ́nné Ɛsɔwɔ ɛpyɛ ɛta wú gelú wáwálé wɔ́, afɛré nnó agɛ́né mbɔ le gejya. ");
INSERT INTO anvNT_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Pita ne ɛkiɛ́nné ɛwémbɔ ákoó ntoné bɔɔ́ bee ɛniné mbɛ, ama koó ɛniné nekwɔlege, ne áchwɔ́ kwɔne nana né menombi geŋká ɛwé ɛlu gesegese, ɔnenégé ɛwu ne ɔfɛ́ mbɛ melɔ. Menombi ɛwémbɔ ɛnené ɛwu ambɔɔ́, ne ɛbwɔ́ átané dafyɛ. Ákɛ́gé gachyɛ, ɛkiɛ́nné ɛwémbɔ ɛlyaá Pita ɛ́fɛ́. ");
INSERT INTO anvNT_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Ne Pita akérégé né defɔɔ́ ti aké: “Nkaá wáwálé nnó Ata Ɛsɔwɔ átɔ́ ɛkiɛ́nné wuú nnó ɛchwɔ féré me né amu Hɛrɔd ne uno bi bɔɔ́ Jus abɔ́ ashuú mampyɛ me.” ");
INSERT INTO anvNT_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Ndɛre Pita akaá geno ɛyi gebɔ gepyɛ́ ji, afɛ́ né gepúgé Mɛri ayi alu mma Jɔn Makɔs ne gejamégé bɔɔ́ ábɔ́ áchomé ɛfɛɛ́ ánɛ́nemmyɛ mbaá Ɛsɔwɔ. ");
INSERT INTO anvNT_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Ádogé menombi, geŋka, mesɔ mendée yi apyɛ utɔɔ́ né gepú yimbɔ achwɔ́ gii ne ákamege Ruda. ");
INSERT INTO anvNT_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Ákaágé nnó gɛ́ meko Pita mbɔ, metɔɔ́ ɛgɔ ji dɔɔ́ tɛ ajinte manene menombi, abó ajyɛ garé bɔɔ́ bimbɔ nnó Pita alu mbɔ dafyɛ. ");
INSERT INTO anvNT_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Ɛbwɔ́ aké ne ji, “Ɔmée gebwɔ.” Yɛ́mbɔ atome wyɛ ɛshyɛ ajɔge nnó ɛ́lé Pita. Ne ɛbwɔ́ ake: “Ndɔfɔ ɛlé mekpɛ́ɛ wuú.” ");
INSERT INTO anvNT_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Ne Pita alu dó wyɛ doó, ánené menombí ágɛ́gé nnó ɛ́lé Pita wáwálé mátyɛ mawa ɛbwɔ́ meno. ");
INSERT INTO anvNT_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Pita akpɛgé mmu, afu ɛbwɔ́ ɛbwɔ nnó akwéné mejɔɔ́. Ne alɔ mangaré ɛbwɔ́ nkane Ɛsɔwɔ aféré ji né denɔ. Anérégé ake: “Ágaré Jɛmsi ne bɔɔ́ Jisɔs bifɔ́ ntó.” Ne atané afɛ́ geba ɛyigé chá. ");
INSERT INTO anvNT_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Bií ujyagé bɔɔ́ bee álɔ maŋkɛlé Pita ne ágɛ́ ji wɔ́, matɔɔ́ atyá bwɔ́ mmu ála yayaya ne ágige gemɛ gebwɔ́ aké: “Nde gepyɛ ne Pita?” ");
INSERT INTO anvNT_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Mfwa Hɛrɔd awúgé mbɔ, atɔ́ bɔɔ́ nnó ákɛ́lé ji ne ágɛ́ wɔ́. Akuú bɔɔ́ bee bimbɔ, agií bwɔ́ bɔ ŋkwɛ. Anérégé ake ajyɛ wá ɛbwɔ́. Ɛpyɛgé mbɔ Hɛrɔd alyá gebagé Judiya afɛ́ kpɛ́ né melɔ Kaisaria. ");
INSERT INTO anvNT_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Né gébé ɛyigémbɔ, mfwa Hɛrɔd abɔ awamege ne bɔɔ́ Tiya ne Sidɔn. Bɔɔ bimbɔ ácho, áchwɔ́ mangɛ́ ji. Áchwɔ́gé ábɔ́ mbɛ ágbaré Blastus dejeé. Blastus alu muú yi ágbárege dachi mfwa. Ne ɛbwɔ́ áké ji anɛ mfwa mmyɛ, nnó ɛbwɔ́ abɛ né nesɔ, nendé menyɛɛ́ atanege le né melɔ mfwa. ");
INSERT INTO anvNT_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Bii ɛbi Mfwa Hɛrɔd abɔ akwyɛ ukwɔnege, afyɛ mandeé gefwa jií, ajwɔlé né geluɔ, agare bɔɔ́ bimbɔ mekomejɔɔ́. ");
INSERT INTO anvNT_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Ne ɛbwɔ́ álɔ maŋkalé áké: “Ɛ́lé Ɛsɔwɔ ne ajɔge ɛpɔ́fɔ́ mekwaá.” ");
INSERT INTO anvNT_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Tɛnétɛné yimbɔ ɛkiɛ́nné Ɛsɔwɔ ɛchwɔ ŋmé mfwa Hɛrɔd nemée mmyɛ gétúgé álá shuú ɛnogé ɛwémbɔ mbaá Ɛsɔwɔ wɔ́. Bɔ dámmwɔ́lé ányɛ ji mbwi unɛ, agbó. ");
INSERT INTO anvNT_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Yɛ nkane depɔ tire na depyɛ, mekomejɔɔ́ Ɛsɔwɔ awɛne ajyɛ mbɛmbɛ, ne gejamégé bɔɔ́ áfyɛ́ɛ matɔɔ́ ne Jisɔs. ");
INSERT INTO anvNT_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Ndɛre ábɔ́ átɔ́mé Sɔl ne Banabas né Jɛrosalɛ, ɛbwɔ́ anéré utɔɔ́ bwɔ́ gébégé akerege né Antiɔk, ásɛ Jɔn Makɔs áfɛ́ ne ji. ");
INSERT INTO anvNT_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Bɔɔ́ fɔ́ ábɔ́ álú né ɛchomele bɔɔ́ Jisɔs né Antiɔk, abi fɔ́ álú bɔɔ́ ɛkpavé Ɛsɔwɔ ne abi fɔ́ álú anlɛré ɛbwɔ́ álú: Banabas, Simyɔn ayi ákuú ji Niger ne Lukiɔs ayi atané melɔ Sɛren ne Manɛn ayi ɛbwɔ́ ne mfwa Hɛrɔd áwɛ́né mbaa ama ne Sɔl. ");
INSERT INTO anvNT_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Né gébé gefɔ́ bɔɔ́ Jisɔs bimbɔ ako álya menyɛɛ́ kpékpé, áfɛ́ɛge Ɛsɔwɔ. Ɛwyágé Mendoó Ukpea ɛké ne ɛbwɔ́: “Férege Sɔl ne Banabas né geluage nyú ájyɛ́ pyɛ utɔɔ́ bi njyá ɛbwɔ́ nnó ápyɛ́.” ");
INSERT INTO anvNT_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Ne áwuúge mbɔ, áma lyaá menyɛɛ́ kpékpé, ánɛ mmyɛ mbaá Ɛsɔwɔ. Anérégé, ánɛré ɛbwɔ́ amu mmyɛ ne átɔ́ ɛbwɔ nnó ájyɛ́. ");
INSERT INTO anvNT_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Ndɛre Mendoó Ukpea ɛbɔ́ ɛtɔmé ɛbwɔ́, átané áfɛ́ né melɔ Sɛlusha. Ákwɔ́négé, ákpɛ ɛ́kpe, áchyá áfɛ́ melɔ Syaprɔs. ");
INSERT INTO anvNT_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Ɛbwɔ́ ákwɔ́négé melɔ Salamis, ályá ɛ́kpe bwɔ́ ɛfɛɛ́, ákɛ́ne agarege mekomejɔɔ́ Ɛsɔwɔ né macha mmyɛmenɛne bɔɔ́ Jus. Jɔn Mak akɛne ne ɛbwɔ́, apoge né utɔɔ́. ");
INSERT INTO anvNT_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Ákɛ kpaá áchyá ákwɔné melɔ Pafɔs. Ɛfɛɛ́ ábané muú megya fɔ ayi ákuú ji Ba-Jisɔs. Alu muú Jus ne akɛne abyɔge gebyɔ nnó ji alu muú ɛkpávé Ɛsɔwɔ. ");
INSERT INTO anvNT_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Ne Ba-Jisɔs yina alu mejeé Sɛgɔs Pɔlɔs ayi alu gɔmena né gebagé mewaá ɛyimbɔ. Gɔmena yina abɔ́ alu muú yi awya defɔɔ́ ne akuú Banabas ne Sɔl getúgé akɛ́lege manwú mekomejɔɔ́ Ɛsɔwɔ. ");
INSERT INTO anvNT_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Yɛ́mbɔ ɛbwɔ́ áchwɔgé muú megya yimbɔ, ayi ákuú ji Ɛlimas né meko Grek, alɔ manyɛ mbeé né mekomejɔɔ́ bwɔ́ ne amyɛ mangbɛ́ nnó gɔmena yimbɔ afyɛgé fɔ́ metɔɔ́ né depɔré Jisɔs ɛtiré ɛbwɔ́ ágárege ji. ");
INSERT INTO anvNT_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Ne Mendoó Ukpea ɛgbeé Sɔl metɔɔ, ákuú ji ntó Pɔl, apɛ mende yimbɔ lu lu lu, ");
INSERT INTO anvNT_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","ne aké: “Wɔ maá danchɔmelo. Ɔkií fɔ́ genó gelɔ́gelɔ́ ne defya degbeé wɔ unɛ. Yɛndégébé ɔmuame mambwɔlé depɔré Ɛsɔwɔ ɛti delu cho nnó délá gebyɔ. ");
INSERT INTO anvNT_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Gɔ́ ngaré wɔ nnó mfaánebuú akwene nyɛ wɔ mmyɛ. Nana ɔbɛ nyɛ amɛ nónómé ne ɔgɛné nyɛ se mbaá né mboó ndɔ.” Tɛ́nétɛ́né yimbɔ, gemua gekwé Ɛlymas amɛ. Akɛne agyage, akɛlege muú yi ágbárege ji ɛbwɔ. ");
INSERT INTO anvNT_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Gɔmena yimbɔ agɛgé mechɔ́ ɛwé ɛpyɛ, áfyɛɛ́ metɔɔ́ ne Jisɔs, ne ɛkwɔné ji metɔɔ́ nkane agɛné uto bi úlú né mekomejɔɔ́ Jisɔs. ");
INSERT INTO anvNT_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Pɔl ne bɔɔ́ bií ákpɛ ɛ́kpe né melɔ Pafɔs áfɛ́ né melɔ Pɛga ɛwé ɛlu né gebagé mewaá Pamfilya. Ɛfɛɛ́ ne Jɔn Mak álya ɛbwɔ́, akéré né Jɛrosalɛ. ");
INSERT INTO anvNT_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Átánégé melɔ Pɛga, ákɛ ákwɔne melɔ Antiɔk ɛwé ɛlú kwɔ́kwɔ́lé ne gebagé mewaá Pisidiya. Bii uwyaá bɔɔ́ Jus ukwɔ́négé, ájyɛ kpɛ mmu ɛcha mmyɛmenɛne bɔɔ́ Jus ajwɔlé. ");
INSERT INTO anvNT_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Muú fɔ akuúgé malɔ ŋwɛ né ŋwɛ mabɛ́ Mosis ne abi bɔɔ́ ɛkpávé Ɛsɔwɔ ásamé, ákpakpa abi ɛcha mmyɛmenɛne átɔ́ muú nnó ájyɛ́ jɔɔ́ ne ɛbwɔ́ nnó, “Aŋmɛ́, mbɔge ɛnyu dewya majyɛ manchyɛ́ ɛsé chyɛ́ge.” ");
INSERT INTO anvNT_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Ne Pɔl akwile tɛ́né, afu ɛbwɔ nnó ákwéné mejɔɔ́, ne alɔ manjɔɔ́ aké: “Bɔɔ́ Isrɛli ne abi álá pɔ bɔɔ́ Isrɛli abi ánoge ntó Ɛsɔwɔ; nenege matu dewu. ");
INSERT INTO anvNT_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Ɛsɔwɔ yi bɔɔ́ Isrɛli abɔ́ ajya ukwene antɛ ɛsé ne apyɛ ɛbwɔ́ aŋeá gébégé ábɔ́ alu aŋkɛɛ́ né melɔ Ijip. Ne aféré ɛbwɔ́ né melɔ ɛwémbɔ ne gekpɛ́kpɛ́gé ɛshyɛ wuú, ");
INSERT INTO anvNT_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","ne abɔ́ achó wyɛ metɔɔ́ ne gepɔge bwɔ́ né usaá aŋmɛ upéá gébégé ɛbwɔ́ álú né mashwɔne. ");
INSERT INTO anvNT_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Ɛbwɔ́ ábɔ́ ákwɔ́négé nyá né mme ayi akuú Kanaan, apyɛ áwá bɔɔ́ bi álú né malɔ ákéné ama né mme yimbɔ. Ne achyɛ́ mme yimbɔ mbaá bɔɔ́ Isrɛli. ");
INSERT INTO anvNT_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Ɛlu nana (450) usaá aŋmɛ ɛsaá meso usaá upea meso ɛfya ayi Ɛsɔwɔ ajyá ɛbwɔ́. Afyɛ bɔɔ́ kpakpa gébé ne gébé nnó ápɛ́lé melɔ. Ápɛ melɔ kpaá ɛkwɔne gébé ɛyigé Samuele, muú ɛkpávé Ɛsɔwɔ alɔ ntó mampɛle melɔ. ");
INSERT INTO anvNT_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Né gébé géfɔ́, ágii nnó áchyɛ́ ɛbwɔ́ mfwa. Ne Ɛsɔwɔ ajya Sɔl, maá Kish nnó abɛ mfwa bwɔ́. Atané ntoné Benjamɛn ne agbaré melɔ né usaá aŋmɛ upea. ");
INSERT INTO anvNT_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Ne Ɛsɔwɔ aférégé ji né gefwa, áfyɛ́ Dɛvid nnó ábɛ́ mfwa bwɔ́. Gɛ́ genó ɛyigé Ɛsɔwɔ abɔ́ ajɔɔ́ getúgé Dɛvid na, ake: Ngɛ Dɛvid maá Jɛsse, alu me metɔɔ́ chi chi chi. Apyɛ nyɛ unó uko ɛbi ngarege ji. ");
INSERT INTO anvNT_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Ne nana Ɛsɔwɔ achyɛ́ ɛsé bɔɔ́ Isrɛli Mpyáné mfwa Dɛvid nnó ábɛɛ́ Menchyɛ́ geŋwá ndɛre ji abɔ́ anyɛ́meno. Ne muú yina ɛ́lé Jisɔs. ");
INSERT INTO anvNT_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Gemɛ́gé nnó Jisɔs ɛyina alɔ utɔɔ́ bii, Jɔn abɔ́ agarege mɛ́ mekomejɔɔ́ Ɛsɔwɔ mbaá gejamégé bɔɔ́ Isrɛli nnó ákwɔré matɔɔ́ bwɔ́ ne ji awyaá ɛbwɔ́ manaá Ɛsɔwɔ. ");
INSERT INTO anvNT_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Ne ndɛre Jɔn áchwɔ néré utɔɔ́ bii, agií ɛbwɔ́ ake, Ɛnyú defɛré nnó me nlu waá? Mpɔ́fɔ́ muú yi ɛnyú degili nnó achwɔ́. Yɛ́mbɔ kaáge nnó muú yi achwɔ́ nyɛ me meso, nkwané fɔ́ muú yi nkaáge manyi unó uká bii wɔ́.” ");
INSERT INTO anvNT_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Pɔl ama kuú ɛbwɔ́ ake: “Aŋmɛ́ ba, ɛnyú bi delú upyáne Abraham ne ɛnyú ako abi dénoge ntó Ɛsɔwɔ, Ɛsɔwɔ abɔ́ atɔ́ ɛlé ɛsé mekomejɔɔ́ yina ayi akage fére ɛsé né ɛfwyale gabo. ");
INSERT INTO anvNT_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Bɔɔ́ Jɛrosalɛ ne ákpakpa bwɔ́ ábɔ́ ákaá fɔ́ nnó Jisɔs alu menchyɛ geŋwá wɔ́. Yɛ unó bɔɔ́ ɛkpávé Ɛsɔwɔ ɛbi ɛbwɔ́ ákuú yɛndé bií né uwyaá bwɔ́, ákage ula. Ɛbwɔ́ ápyɛgé mbɔ, ásɔ́ mpa Jisɔs nno áwá ji ne ápyɛ uno bi bɔɔ́ ɛkpavé Ɛsɔwɔ ásámé nnó ubɛ́ wáwálé. ");
INSERT INTO anvNT_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Yɛ le ɛbwɔ́ ábɔ́ álá gɛ́ mechɔ ɛwé ji apyɛ ɛwé ábɔ́ mangbó wɔ́ ákwɔ Palɛt mata nnó awá ji. ");
INSERT INTO anvNT_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Ɛbwɔ́ anérégé unó uko bi ŋwɛ Ɛsɔwɔ bɔ́ ajɔɔ́ getúgé Jisɔs, áféré ji né gekwa, ájyɛ bele ji né menome ɛwé áchomé né ɛtaravɛ́. ");
INSERT INTO anvNT_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Yɛ́mbɔ Ɛsɔwɔ apyɛɛ́ ji akwilé né negbo. ");
INSERT INTO anvNT_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Né gejamégé ndɔ, alɛré mmyɛ jií mbaá bɔɔ́ bi ábɔ́ átané ne ji né Galilií, ájyɛ́ né Jɛrosalɛ. Ɛbwɔ́ ne nana ágarege mekomejɔɔ́ wuú mbaá bɔɔ́ Isrɛli. ");
INSERT INTO anvNT_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Ne ɛsé dechwɔ́ nana mangaré ɛnyu ntó abya melɔ́mélɔ́ yina. Abya yina ɛ́lé unó bi Ɛsɔwɔ abɔ anyɛ́meno nnó apyɛ mbaá ukwene antɛ sé. ");
INSERT INTO anvNT_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Unó bina upyɛ wáwálé né gébé ɛyigé ɛsé bi delú upyáne bwɔ́, nkane ji apyɛɛ́ Jisɔs akwilé né negbo. Ábɔ́ ásá ntó unó bi né ŋwɛ makwa uba ŋwɛ upéá nnó Ɛsɔwɔ aké: ‘Wɔ ɔlu maá wa, ne fina nla ntɛ wyɛ.’ ");
INSERT INTO anvNT_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Ndɛre Ɛsɔwɔ apyɛɛ́ Jisɔs akwilé né negbo nnó amágé gbó se, Ɛsɔwɔ jimbɔɔ́ aké: ‘Mpyɛ nyɛ ɛnyú degɛ́ galɔ́gálɔ́ wyɛ ndɛre mbɔ́ nyɛɛ́meno ne Dɛvid.’ ");
INSERT INTO anvNT_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Ábɔ́ ásá ntó né melu ŋwɛ makwa ayi fɔ nnó: ‘Ɔlyágé nyɛ fɔ́ Maá utɔɔ́ wyɛ yi apyɛɛ́ utɔɔ́ cháŋéné apwané mmu menome.’ ");
INSERT INTO anvNT_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Né ɛgbɛ ɛwé mfwa Dɛvid, abɔ́ apyɛ utɔɔ́ ɛbi Ɛsɔwɔ achyɛ́ ji né gébé jií, agbó, ne anií ji kwɔ́kwɔ́lé ne menóme ukwéne antɛ bii, ala ɛfɛɛ́ apwane. ");
INSERT INTO anvNT_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Yɛ́mbɔ muú yi Ɛsɔwɔ apyɛɛ́ ji akwilé né negbo, apwáné fɔ́ né menome wɔ́. ");
INSERT INTO anvNT_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Ne aŋmɛ́ ba, debɔ́ mankaá wáwálé nnó abya ayi ɛnyú dewuú nnó Ɛsɔwɔ ajigente gabo bɔɔ́, ɛ́lé getúgé Jisɔs yina. ");
INSERT INTO anvNT_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Ne muú yi afyɛgé metɔɔ́ ne Jisɔs apome nyɛ né gabo wuú ayi mabɛ́ Mosis álá kage pyɛ ji apó. ");
INSERT INTO anvNT_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Ne sɛ́ge gébé nnó unó bi ásamé mmu bɔ ŋwɛ bɔɔ́ ɛkpávé Ɛsɔwɔ ɛ́kágé upyɛ́ ɛta nyú. Ásá ɛfɛɛ́ nno: ");
INSERT INTO anvNT_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","Ɛnyú bi déjwáge Ɛsɔwɔ, ‘Wuge. Dela nyɛ amɛ mekpo fuú, degbó. Mpyɛ nyɛ geno fɔ né gébé nyú, ɛnyú dewuúgé geji, dékámégé fɔ́.’” ");
INSERT INTO anvNT_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Ndɛre Pɔl ne Banabas áchwɔ́ táne né ɛcha mmyɛmenɛne, bɔɔ́ bimbɔ ákwɔ bwɔ́ mata nnó ama chwɔ́ ágaré ɛbwɔ́ uno bifɔ́ né bii uwyaá bɔɔ́ Jus ɛbicha. ");
INSERT INTO anvNT_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Ndɛre bɔɔ́ átyage né ɛcha mmyɛmenɛne, gejamégé bɔɔ́ Jus ne abifɔ bi asɛlé gepɔgé bɔɔ́ Jus ákwɔlege Pɔl ne Banabas. Ne Pɔl ne Banabas áfyɛ ɛbwɔ́ metɔɔ́ nnó ágbaré wyɛ mekomejɔɔ́ Ɛsɔwɔ ndɛre Ɛsɔwɔ ápoógé ɛbwɔ́. ");
INSERT INTO anvNT_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Bií uwyaá bɔɔ́ Jus ɛbifɔ́ ukwɔ́négé, melɔ meko ɛjyɛ chóme manwú mekomejɔɔ́ Ɛsɔwɔ. ");
INSERT INTO anvNT_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Ne bɔɔ́ Jus abifɔ ágɛ́gé nkane gejamégé bɔɔ́ áchomé, matɔɔ́ ásɔ́ bwɔ́, álɔ manjɔɔ́ nnó mekomejɔɔ́ Pɔl alu gebyɔ́ ne áshyɛ ji. ");
INSERT INTO anvNT_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Yɛ́mbɔ Pɔl ne Banabas ágaré ɛbwɔ́ gbɔŋéné áké: “Ɛse debɔ́ débɔ́ mbɛ degaré ɛnyú bɔɔ́ Jus mekomejɔɔ́ Ɛsɔwɔ. Ne tɛ ɛnyú délá fyɛ́ makpo wɔ́, desɛ gemɛ nyú nnó dekwané fɔ́ manyɛ geŋwá ɛyi gélágé byɛɛ́, ne ɛlu galɔ́gálɔ́ nnó ɛsé debwɔ́lé ushu degare mekomejɔɔ́ yina mbaá bɔɔ́ abi álá pɔ́ bɔɔ́ Jus. ");
INSERT INTO anvNT_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Gɛ́ genó ɛyigé Átá Ɛsɔwɔ abɔ́ ajɔɔ́ ne ɛsé getúgé Jisɔs ake: ‘Mpyɛ wɔ ɔbɛ́ geŋgbɔ́ mbaá bɔɔ́ abi álá pɔ́ bɔɔ́ Jus nnó ɔpyɛ bɔɔ́ mme ako átane né ɛfwyale gabo’.” ");
INSERT INTO anvNT_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Bɔɔ́ abi álá pɔ́ bɔɔ́ Jus áwúge mbɔ, matɔɔ́ ágɔ ɛbwɔ́ ne afɛɛ́ Ɛsɔwɔ né mekomejɔɔ́ wuú. Ne bɔɔ́ bi Ɛsɔwɔ abɔ́ ájya nnó ányɛ geŋwá ɛyi gélágé byɛ́, ɛle abi ákamé ne Jisɔs. ");
INSERT INTO anvNT_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Ne mekomejɔɔ́ Ata akɛ agyaá gebagé mewaá ɛyimbɔ geko. ");
INSERT INTO anvNT_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Yɛ́mbɔ bɔɔ́ Jus ájyɛ fyɛ́ ákpakpa melɔ ne afwa andée abi ánoge Ɛsɔwɔ mewɛ ula, ɛbwɔ́ ápyɛ bɔɔ́ álɔ mankɛle mati manchɔ geŋwagé Pɔl ne Banabas átané né gebagé mewaá bwɔ́. ");
INSERT INTO anvNT_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Ndɛre ɛbwɔ́ áchwɔ́ ájyɛ́, ákwe uká nnó mpúpú ɛyi ɛbalé wyɛ ɛtané mambɛ́ nkane gepɔ ɛyi gelɛrege gabo ayi bɔɔ́ bimbɔ ápyɛɛ́. Ne áfɛ́ né melɔ Ikɔnyɔm. ");
INSERT INTO anvNT_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Ne bɔɔ́ Jisɔs bimbɔ álagé meso, Mendoó Ukpea ɛgbeé ɛbwɔ́ matɔɔ́ ne álú ne nechɔ́chɔ́. ");
INSERT INTO anvNT_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Ndɛre Pɔl ne Banabas ájyɛ́ né melɔ Ikɔnyɔm, ápyɛ wyɛ nkane ábɔ́ ápyɛ́ né Antiɔk. Ɛbwɔ ájyɛ́ kpɛ mmu ɛcha mmyɛmenɛne bɔɔ́ Jus, álɔ mangaré depɔré Jisɔs né gefɔ́ ɛyi gepyɛ́ gejamégé bɔɔ́ Jus ne abi álá pɔ́ bɔɔ́ Jus ákamé ne Jisɔs. ");
INSERT INTO anvNT_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Yɛ́mbɔ bɔɔ́ Jus abi áshyá mekomejɔɔ́ yimbɔ, áfyɛ abifɔ abi álá pɔ́ bɔɔ́ Jus mewɛ ula nnó ásɔ́gé matɔɔ́ né bɔɔ́ bi ákamé ne Jisɔs. ");
INSERT INTO anvNT_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Pɔl ne Banabas ábɛlé gejamégé ndɔ ɛ́fɛɛ́, ágárege depɔré Jisɔs gbɔŋéné nkane ji álɛ́régé galɔ́gálɔ́ mbaá bɔɔ́. Jisɔs ne achyɛ bwɔ́ uto ne, ápyɛ́ ufélekpa ɛbi ulɛré nnó depɔ ɛti ɛbwɔ́ agarege delu wáwálé. ");
INSERT INTO anvNT_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Ndɛre ɛbwɔ́ ágarege mbɔ, bɔɔ́ melɔ ɛwémbɔ ákaré malu apea. Abifɔ álú ne áŋgbá Jisɔs, abifɔ álú ne bɔɔ́ Jus abi áshyá mekomejɔɔ́ yimbɔ. ");
INSERT INTO anvNT_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Ɛbɛ́légé bɔɔ́ Jus ne abi álá pɔ́ bɔɔ́ Jus chóncho ne ákpakpa bwɔ́ ajyɛ sɔ́ mala nnó áfwalé aŋgbá Jisɔs ne áwá bwɔ́ ne mataá. ");
INSERT INTO anvNT_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","7","Ne aŋgbá Jisɔs áwuúgé geju bwɔ́, ábó áfɛ́ né gebagé mewaá Lykania, ákɛne né malɔ Lystra ne Debe ne malɔ ayifɔ ayi álú né geba yimbɔ, ágarege abya Ɛsɔwɔ melɔ́mélɔ́ ɛwu. ");
INSERT INTO anvNT_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Mende fɔ abɔ alu né melɔ Lystra, ayi tɛ ábyɛné ji, alu mbwɛ́ré. ");
INSERT INTO anvNT_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Bií fɔ ajwɔlé awuú mekomejɔɔ́ Ɛsɔwɔ ayi Pɔl agarege. Pɔl agɛ́ge nnó mende yina áfyɛɛ́ metɔɔ́ nnó Ɛsɔwɔ akage apyɛ ji atoó, ");
INSERT INTO anvNT_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","akuú ji ne ɛshyɛ aké: “Kwile tɛ́né cho.” Tɛ́nétɛ́né yimbɔ mende yina anyó atɛné, alɔ mankɛne agyage. ");
INSERT INTO anvNT_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Ne gejamégé bɔɔ́ ágɛ́gé genó ɛyigé Pɔl apyɛ́, ádo ɛlúlú, ájɔɔ́ né mejɔɔ́ bwɔ́ Lykania áké: “Áló ábwɔlé bɔɔ́ áshulé, áchwɔ́ gɛ́ ɛsé.” ");
INSERT INTO anvNT_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Ne ákuú Banabas nnó Sɛus, mabɔ meló bwɔ́ yi kpa, ákuú nto Pɔl nnó Hɛmɛs nende ji ne atɛné mbɛ ajɔge mejɔɔ́. ");
INSERT INTO anvNT_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Gepúge upɛ meló yi ákuú ji Sɛus gelu kwɔ́kwɔ́lé ne melɔ. Ne mempyɛɛ́ upɛ wuú achwɔ́ ne bɔ mpɔ ne ukoó genɔɔ́. ");
INSERT INTO anvNT_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Pɔl ne Banabas ágɛ́gé genó ɛyigé bɔɔ́ bimbɔ ákɛ́lege mampyɛ, ágyá mandeé mmyɛ manlɛré nnó genó ɛyigé bɔɔ́ bina achwɔ́ pyɛ gelɔ wɔ́, ábó ájyɛ kpɛ metɔɔ́ metɔɔ́ bwɔ́ ákálege áké: ");
INSERT INTO anvNT_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Bɔɔ́ bina, ndé genó ɛnyú dépyɛ́ mbɔ? Ɛsé delu wyɛ akwaá nkane ɛnyú. Ɛse dechwɔ́ fa mangaré ɛnyú mekomejɔɔ́ Ɛsɔwɔ nnó ɛnyú delyaá aló abi ɛnyú dénoge mbɔ, dékwɔ́lé Ɛsɔwɔ yi alu mebɛ. Ji akwyɛ mfaa ne mme ne manyi ne unó uko bi úlú wyɛ. ");
INSERT INTO anvNT_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Mbɛ mbɛ Ɛsɔwɔ alyá bɔɔ́ nnó apyɛge uno bi ujii ɛbwɔ́ matɔɔ́. ");
INSERT INTO anvNT_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Yɛ le bɔɔ́ ábɔ́ ápyɛmbɔ, ji áchyɛ́ge ɛbwɔ́ unó ulɔ́úlɔ́ mampyɛ ɛbwɔ́ akaá nnó ji alu mebɛ. Apyɛ manaá akwene né gébé gelɔ́gelɔ́ mampyɛ uno nyú uwɛ́né chancha. Achyɛge ɛnyú menyɛɛ́ ne apyɛ matɔɔ́ ágɔ́ ɛnyú.” ");
INSERT INTO anvNT_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Yɛ nkane Pɔl ne Banabas ájɔge mbɔ, ɛlu ɛké ágbɛle manaá meso mekwalé, bɔɔ́ bina átome wyɛ ɛshyɛ mampyɛ gepɛ ɛyigembɔ ɛta bwɔ́. ");
INSERT INTO anvNT_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Ɛké ɛwyage bɔɔ́ Jus fɔ átané melɔ Antiɔk ne melɔ Ikɔnyɔm, ápyɛ gejamégé bɔɔ́ ákamé ne ɛbwɔ́. Ne ɛbwɔ́ átó Pɔl ne mataá, ája ji mmemme, atané melɔ bwɔ́, ályá ji áfɛ́rége nnó agbó. ");
INSERT INTO anvNT_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Yɛ́mbɔ gébégé bɔɔ́ bi ákamé ne Jisɔs áchwɔ nɔ́ Pɔl mme, ɛwyágé akwili ka, akwɔle ɛbwɔ́ akéré né melɔ ɛwémbɔ. Ujyagé Pɔl ne Banabas áfɛ́ né melɔ Debe. ");
INSERT INTO anvNT_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Ne ɛbwɔ́ ágaré abya Ɛsɔwɔ melɔ́mélɔ́ né melɔ́ Debe, ápyɛ gejamégé bɔɔ́ ákame ne Jisɔs. Ɛbɛ́légé mboó ndɔ, ɛbwɔ́ ákeré né melɔ Lystra ne Ikɔnyɔm ne Antiɔk ayi alu kwɔ́kwɔ́le ne gebagé mewaá Pisidya. ");
INSERT INTO anvNT_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Ɛbwɔ́ ákɛ́ne, áfyɛ́ bɔɔ́ Jisɔs ɛshyɛ ne áchyɛge ɛbwɔ́ majyɛ nnó ákwɔ́légé wyɛ depɔré Jisɔs cháŋéné ne ákaá nnó abɔ́ mangɛ gejamégé ɛfwyale ne ányɛ geŋwá gébégé Ɛsɔwɔ ágbárege gefwa jií. ");
INSERT INTO anvNT_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Ɛbwɔ́ ájya bɔɔ́ nnó ábɛ́ ákpakpa né ɛchomele bɔɔ́ Jisɔs né yɛndé melɔ, ánerege ályage menyɛɛ́ kpékpé, ánɛmmyɛ ne áfyɛ́ ɛbwɔ́ né amu Jisɔs ayi ɛbwɔ́ ákame ne ji. ");
INSERT INTO anvNT_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Ne ɛbwɔ́ ákógé né gebagé mewaá Pisidiya, áfɛ́ né gebagé mewaá Pamfilya, ");
INSERT INTO anvNT_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","ɛfɛɛ́ ágaré mekomejɔɔ́ Ɛsɔwɔ né melɔ Pɛga. Ánérégé ɛfɛɛ́, áshulé áfɛ́ né melɔ Atalya. ");
INSERT INTO anvNT_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Átánégé melɔ ɛwémbɔ akpɛ ɛ́kpe, ákeré né melɔ Antiɔk, melɔ ɛwé ábɔ́ áfyɛ́ ɛbwɔ́ né amu Ɛsɔwɔ nnó ápoógé ɛbwɔ́, ajyɛ́ pyɛ́ utɔɔ́ bi nana ánéré. ");
INSERT INTO anvNT_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Ɛbwɔ́ ákwɔ́négé né Antiɔk, ánywéré ɛchomele bɔɔ́ Jisɔs melu ɛma ne ágaré ɛbwɔ́ nkane ɛbwɔ́ ákɛné ne nkane Ɛsɔwɔ abɔ́ apoó ɛbwɔ́, anené matɔɔ bɔɔ́ abi álá pɔ́ bɔɔ́ Jus nnó áfyɛɛ́ metɔɔ́ ne Jisɔs. ");
INSERT INTO anvNT_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Ne Pɔl ne Banabas ánérégé manjɔɔ́ depɔ tí, ɛbwɔ́ ábɛlé ne bɔɔ́ Jisɔs abi alu ɛfɛɛ́ né gejamégé ndɔ. ");
INSERT INTO anvNT_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Ɛbɛlégé bɔɔ́ fɔ átané gebagé mewaá Judiya áchwɔ́ né melɔ Antiɔk, alɔ manlɛrege bɔɔ́ bi ákamé ne Jisɔs nnó, “Mbɔgé álá sɔ́ muú nsɔ nkane ɛbɛ́ Mosis ɛjɔɔ́ wɔ́, Ɛsɔwɔ akagé pyɛ fɔ́ muú yimbɔ apó.” ");
INSERT INTO anvNT_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Pɔl ne Banabas anyɛ mbeé ne bɔɔ́ bimbɔ, yɛ mekpo ne ula ɛpɔ́. Ɛpwɔ́gé ɛbwɔ́, áfyɛ́ ndɔ nnó Pɔl ne Banabas ne abifɔ ájyɛ́ né Jɛrosalɛ, ágii mechɔ ɛwé cháŋéné mbaá áŋgbá Jisɔs ne ákpakpa bɔɔ́ ɛchomele Jisɔs. ");
INSERT INTO anvNT_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Ne ɛchomele bɔɔ́ Jisɔs átɔ́ ɛbwɔ́. Ndɛre ɛbwɔ́ ajyɛ, akoóge malɔ Fonisiya ne Samariya, ágarége bɔɔ́ bi ákamé ne Jisɔs nkane bɔɔ́ abi álá pɔ́ bɔɔ́ Jus ákamé mekomejɔɔ́ Ɛsɔwɔ. Abya yina apyɛ matɔɔ́ agɔ bɔɔ́ Jisɔs ako dɔɔ́. ");
INSERT INTO anvNT_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Ɛbwɔ́ ákwɔnege Jɛrosalɛ, ɛchomele bɔɔ́ Jisɔs ne áŋgbá Jisɔs ne ákpakpa bwɔ́, ásɛ ɛbwɔ amu apéa. Pɔl ne Banabas ágaré ɛbwɔ́ uno uko ɛbi Ɛsɔwɔ abɔ apoó ɛbwɔ́ ápyɛ. ");
INSERT INTO anvNT_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Ne bɔɔ́ Jisɔs fɔ abɔ alu ɛfɛɛ́, ɛbwɔ́ alu ne ɛkwɔ́ bɔɔ́ Farasi, ɛbwɔ́ ákwile ka áké: “Abɔ́ mansɔ bɔɔ́ bi álá pɔ bɔɔ́ Jus nsɔ ne ágaré ɛbwɔ́ ábélé mabɛ́ Mosis ako.” ");
INSERT INTO anvNT_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Ndɛre ɛbwɔ́ ábɔ́ ájɔɔ́ bɔ, áŋgbá Jisɔs ne ákpakpa bɔɔ́ ɛchomele bwɔ́, ájwɔlé mampɛ mechɔ ɛwéna cháŋéné. ");
INSERT INTO anvNT_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Ɛbwɔ́ ádóregé makpo áwyage, Pita akwile tɛ́ne aké: “Aŋmɛ́ ba, ɛnyu dekaá nnó me ne Ɛsɔwɔ abɔ mbɛ ajya né metɔɔ́ metɔɔ́ ɛsé nnó ngaré abya melɔ́mélɔ́ yina mbaá bɔɔ́ abi álá pɔ́ bɔɔ́ Jus nnó áwuúge ntó, áfyɛɛ́ matɔɔ́ ne Jisɔs. ");
INSERT INTO anvNT_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Ne Ɛsɔwɔ yi akaáge metɔɔ́ yɛ́ndémuú, alɛré nnó ɛbwɔ́ ntó álú bɔɔ́ bií. Apyɛ Mendoó Ukpea ɛchwɔ ɛbwɔ́ mmyɛ wyɛ nkane ɛbɔ́ ɛchwɔ́ ɛsé mmyɛ. ");
INSERT INTO anvNT_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Ne aji ntó nte gabo bwɔ́ gétúgé ɛbwɔ́ áfyɛɛ́ metɔɔ́ ne Jisɔs. Agya fɔ́ aŋgya wɔ́. ");
INSERT INTO anvNT_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Ne nkane ɛlúmbɔ, ulannó ɛnyú déjyale bɔɔ́ bina ukpɛ́kpɛ́ matuú ayi ukwene antɛ ɛse ne ɛse ambɔɔ́ delá kage kpa? Nkane depyɛmbɔ dekane mbɔ le Ɛsɔwɔ kane. ");
INSERT INTO anvNT_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Yɛ́mbɔ ɛsé défyɛɛ́ metɔɔ́ nnó Ɛsɔwɔ aférege ɛse né ɛfwyale gabo gétúgé galɔ́gálɔ́ ayi Átá Jisɔs alɛré ɛse, wyɛmbɔ ntó ne bɔɔ́ bina átánege né ɛfwyale gabo.” ");
INSERT INTO anvNT_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Pita anérégé manjɔɔ́ mbɔ, yɛndé mmu akwené mejɔɔ́, áwuú mekomejɔɔ́ Pɔl ne Banabas. Ágaré ɛbwɔ́ nkane ɛbwɔ́ abɔ́ akɛné mbaá bɔɔ́ abi álá pɔ́ bɔɔ́ Jus ne Ɛsɔwɔ achyɛ́ ɛbwɔ́ uto nnó apyɛge ufélekpa ne ukpɛ́kpɛ́ unó. ");
INSERT INTO anvNT_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Ne ɛbwɔ ánerege manjɔɔ́ yɛndé genó, Jɛmsi alɔ manjɔɔ́ ake: “Aŋmɛ́ ba, nenege matu dewú. ");
INSERT INTO anvNT_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Simun Pita ágaré mɛ nkane Ɛsɔwɔ alɔɔ́ manlɛré nnó agboó ne bɔɔ́ abi álá pɔ́ bɔɔ́ Jus ne ajya abifɔ nnó ábɛ́ bɔɔ́ bií. ");
INSERT INTO anvNT_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Ne ɛwéna ɛkɛ ɛtuú ne unó bi bɔɔ́ ɛkpávé Ɛsɔwɔ abɔ́ ásamé nyá nnó: ");
INSERT INTO anvNT_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘Meso gébé mmage chwɔ́ tɛ́ne nyɛ gepúge Dɛvid ɛyi gebɔ́ gekwené. Nkwyɛge nyɛ unó bi uchɔ́ wyɛ nnó ubɛ́ nkane ubɔ́ úlú. ");
INSERT INTO anvNT_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Ne bɔɔ́ abi álá pɔ́ bɔɔ́ Jus ágɛgé nyɛ ubi, ne ɛbwɔ́ álɔ nyɛ ntó mankɛlé Ɛsɔwɔ. Ɛbɛ́ nyɛ ɛ́lé bɔɔ́ ako abi nkuú nnó ábɛ bɔɔ́ ba ne ákɛ́lege nyɛ me.’ ");
INSERT INTO anvNT_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Gɛ na ne Ɛsɔwɔ ajɔɔ́, ji ayi apyɛ nnó bɔɔ́ akaá unó bina tɛ gachí.” ");
INSERT INTO anvNT_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Ne Jɛmsi aké: “Né metɔɔ́ wa mfɛré nnó ɛsé dechyɛge sé ɛfwyale mbaá bɔɔ́ abi álá pɔ́ bɔɔ́ Jus abi akwɔlege meti Ɛsɔwɔ. ");
INSERT INTO anvNT_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Yɛ́mbɔ ɛse desá lé ɛbwɔ́ ŋwɛ nnó ályá depɔre manáne, ányɛge sé menyɛɛ́ ayi ajélé maka wyɛ yɛ menya ayi muú alá kɛ kɛle wɔ́, ne anyɛ́gé nto manoó menya. ");
INSERT INTO anvNT_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Desá ɛbwɔ́ mbɔ, nende áwuú mɛ nkane bɔɔ́ ágarege mabɛ́ Mosis yina tɛ gachi né malɔ mako. Ne álu ágárege aji né macha mmyɛmenɛne yɛndé bií uwyaá bɔɔ́ Jus.” ");
INSERT INTO anvNT_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Ne áŋgbá Jisɔs ne ákpakpa ɛchomele bɔɔ́ Jisɔs ako, ákamé meko Jɛmsi ne ájya bɔ́ fɔ́ né geluage bwɔ́ nnó ájyɛ́ ne Banabas ne Pɔl né melɔ Antiɔk. Ɛbwɔ́ ájya Silas ne Judas ayi akuú ji ntó Basabas, ɛbwɔ́ bina apeá álú anɔ ɛchomele bɔɔ́ Jisɔs. ");
INSERT INTO anvNT_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Ásá ŋwɛ awu áké: “Ɛsé aŋmɛ́ nyú; áŋgbá Jisɔs ne ákpakpa ɛchomele bɔɔ́ Jisɔs detamege ɛnyú, aŋmɛ́ sé abi álá pɔ́ bɔɔ́ Jus abi delú né melɔ́ Antiɔk ne abi malɔ Siriya ne Silisya. ");
INSERT INTO anvNT_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Ɛsé debɔ́ dewu nnó bɔɔ́ fɔ né geluage sé, áchwɔ́ chyɛ́ ɛnyu ɛfwyale né mejɔɔ́ ɛwé ɛbwɔ́ ájɔɔ́ ne ɛpyɛ́ ɛnyú dékwé tametame ayi ɛsé delá tɔ́ ɛbwɔ́ wɔ́. ");
INSERT INTO anvNT_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Ne ɛse ako debɔ́ dechome, dejɔɔ́, deké: Déjya bɔɔ́ fɔ detɔ́ ɛta nyú ne ɛbwɔ́ áchwɔ́ nyɛ ne Pɔl ne Banabas abi ɛse dégbóo ne ɛbwɔ́ dɔɔ́, ");
INSERT INTO anvNT_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","ɛbwɔ́ alú bɔɔ́ bi ákamé negbo getúge mekomejɔɔ́ Ata Jisɔs Kras. ");
INSERT INTO anvNT_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Ne ɛse detɔme ɛnyú Silas ne Judas, áchwɔ́ge, ágarege nyɛ ɛnyú wyɛ unó bi ɛsé desámé né ŋwɛ yina. ");
INSERT INTO anvNT_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Ɛlé Mendoó Ukpea ne ɛpyɛ ɛsé dekaá nnó debɔ́ fɔ́ mánjya ɛnyu bi delá pɔ́ bɔɔ́ Jus matuú ayicha wɔ́, ɛkose wyɛ uchancha uno bina: ");
INSERT INTO anvNT_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Ɛnyú denyɛgé fɔ́ yɛndé menyɛɛ́ upɛ, denyɛgé fɔ́ menya ayi álá kɛ kɛle wɔ́ ne denyɛgé fɔ́ ntó manoó menya, lyáge depɔré manáné. Mbɔgé delyagé unó bina, debɛ nyɛ cháŋéné. Bɛ́ge pere!” ");
INSERT INTO anvNT_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Bɔɔ́ bina ánérégé mansá mbɔ, áchyɛ Pɔl ne ɛkwɔ wuú. Ɛbwɔ́ ákwɔ́négé né Antiɔk, ánywéré ɛchomele bɔɔ́ Jisɔs áchyɛ ɛbwɔ́ ŋwɛ yimbɔ. ");
INSERT INTO anvNT_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Ne ɛbwɔ́ ákuúgé ŋwɛ yimbɔ matɔɔ́ ágɔ ɛbwɔ́ dɔɔ́ né ɛshyɛ ɛwé mekomejɔɔ́ yimbɔ afyɛ́ bwɔ́. ");
INSERT INTO anvNT_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Judas ne Silas álú ntó bɔɔ́ ɛkpávé Ɛsɔwɔ ne áma ágarege ɛbwɔ́ gejamégé unó bifɔ́ manchyɛ́ bɔɔ́ Jisɔs majyɛ́ ne áfyɛ́ ntó ɛbwɔ́ ɛshyɛ. ");
INSERT INTO anvNT_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Ɛbwɔ́ ábɛlé ɛfɛɛ́ dɔɔ́, ne bɔɔ́ Jisɔs ajyɛ tii ɛbwɔ́ nnó ákɛ pere, ɛbwɔ́ ákéré mbaá bɔɔ́ bi ábɔ́ átɔmé ɛbwɔ́. ");
INSERT INTO anvNT_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Yɛ́mbɔ ɛgɔ Silas nnó ala né melɔ ɛwémbɔ. ");
INSERT INTO anvNT_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Pɔl ne Banabas álú wyɛ né Antiɔk. Ɛbwɔ́ ne gejamégé bɔɔ́ Jisɔs abifɔ ágarege ne álɛrege bɔɔ́ depɔré Jisɔs. ");
INSERT INTO anvNT_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Ɛbɛ́légé Pɔl ajɔɔ́ ne Banabas aké: “Dema dejyɛ́ malɔ mako ayi debɔ́ dégaré mekomejɔɔ́ Ɛsɔwɔ nnó degɛ́ bɔɔ́ Jisɔs abi álú ɛwu ne nkane ɛbwɔ́ álú.” ");
INSERT INTO anvNT_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Ne Banabas abɔ́ akɛlege nnó Jɔn Makɔs ajyɛ ne ɛbwɔ́, ");
INSERT INTO anvNT_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","ne metɔɔ́ ɛgɔ Pɔl cháchá wɔ́ gétúgé Jɔn Makɔs abɔ́ ábó mɛ ɛbwɔ́ né gebagé mewaá Pamfilya ne abɔ́ anéré fɔ́ utɔɔ́ ɛbi ɛbwɔ́ ajyɛ mampyɛ wɔ́. ");
INSERT INTO anvNT_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Pɔl ne Banabas anyɛ mbeé né mechɔ ɛwéna kpaá tɛ áfa mbwa ne atɛ. Banabas asɛ Jɔn Makɔs ajyɛ́ kpɛ́ ɛ́kpe áfɛ́ né melɔ Syaprɔs. ");
INSERT INTO anvNT_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Ne Pɔl ajya Silas, ne ndɛre ɛbwɔ́ áchwɔ́ jyɛ, bɔɔ́ Jisɔs anɛmmyɛ, áfyɛ́ ɛbwɔ́ né amu Ɛsɔwɔ nnó ji ápoógé ɛbwɔ́. ");
INSERT INTO anvNT_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Ne Pɔl asɛ Silas afɛ́, akɛ́ne ajyɛ gebagé mewaá Syria ne Silisya afyɛ́ bɔɔ́ Jisɔs ɛshyɛ nnó átɛné cháŋéné. ");
INSERT INTO anvNT_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Ne Pɔl ajyɛ kwɔne melɔ Debe, ɛwyage afɛ́ né melɔ Lystra. Mende fɔ abɔ alu ɛfɛɛ́ ayi ákamé ne Jisɔs, ákuú ji Timɔti. Mma wuú alu muú Jus ne akamé ntó ne Jisɔs ne ntɛ wuú alu muú Grek. ");
INSERT INTO anvNT_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Ne Timɔti alu ntó muú yi bɔɔ́ Jisɔs né Lystra ne Ikɔnyɔm áfɛ́ge ji. ");
INSERT INTO anvNT_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Pɔl abɔ akɛlege nnó Timɔti akɛné ne ɛbwɔ́ ɛwémbɔ ɛpyɛ ji Pɔl asɔ ji nsɔ nkane gepɔge bɔɔ́ Jus gelú nendé bɔɔ́ Jus ako né gebagé mewaá ɛyigé mbɔ́ ákaá chaŋéné nnó ntɛ Timɔti abɔ alu nya muú Grek. ");
INSERT INTO anvNT_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Ne ɛbwɔ́ ályá ákɛ́ne malɔmalɔ ágarege bɔɔ́ Jisɔs unó bi áŋgbá Jisɔs ne ákpakpa ɛchomele bɔɔ́ Jisɔs ájwɔlé né Jɛrosalɛ ájɔɔ́. Ne ágaré ɛbwɔ́ nnó ábelé ubi cháŋéné. ");
INSERT INTO anvNT_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Ɛwéna ɛpyɛ ɛchomele bɔɔ́ Jisɔs ɛwé ɛlu yɛndé melɔ áfyɛɛ́ wyɛ metɔɔ́ ne Jisɔs dɔɔ́ ne yɛndé bií gejamégé bɔɔ́ áchwɔ́ áchome ne ɛbwɔ́. ");
INSERT INTO anvNT_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Pɔl ne bɔɔ́ bií ákɛ́ne ájyɛ, né gébégé áchwɔ́ kwɔne né gebagé mewaá Ɛsya, Mendoó Ukpea ɛkamé fɔ́ nnó ji agare mekomejɔɔ́ Ɛsɔwɔ ɛfɛɛ́ wɔ. Ne ɛbwɔ́ ákoge né gebagé mewaá, Frigiya ne Galasiya, ajyɛ. ");
INSERT INTO anvNT_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Ndɛre áchwɔ́ kwɔne gebage mewaá Misiya, ábɔ́ ákɛlege mankpɛ né gebagé mewaá Bɛtinya, yɛ́mbɔ Mendoó Jisɔs ɛkamé wɔ́. ");
INSERT INTO anvNT_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Ne ɛbwɔ́ ákogé melɔ Misiya, áshúle áfɛ́ né melɔ Truus. ");
INSERT INTO anvNT_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Wyɛ bií bimbɔ ne utuú, Pɔl agɛ́ amɛ gejya nkane mende Masedonia fɔ atɛné ɛgbɛ ɛbɛ́ɛ mega afu amu nnó Pɔl achya, ajyɛ poó ɛbwɔ́. ");
INSERT INTO anvNT_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Ndɛre abɔ́ agɛ́né amɛ gejya yimbɔ, ɛse ne ɛbwɔ́ dekaá nnó Ɛsɔwɔ akɛlege nnó dejyɛ degaré mekomejɔɔ́ wuú né melɔ Masedonia. Ne ɛsé dekpome mmyɛ majyɛ. ");
INSERT INTO anvNT_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Ne ɛsé dekpɛ ɛ́kpe né melɔ Truus, dekɛ nnyinnyi dekwɔné melɔ Samɔtras, bii ujyage, dekwɔné melɔ Niapolis. ");
INSERT INTO anvNT_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Détánégé ɛfɛɛ́, dekɛ mewaá mewaá dekwɔné melɔ Filippi ɛwe ɛlu melɔ kpa né gebage mewaá Masedonia ne ɛlu ntó melɔ ɛwé gejamégé bɔɔ́ Rom abɔ ájwɔ́lege wyɛ. Debɛlé mboó ndɔ wyɛ. ");
INSERT INTO anvNT_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Bií uwyaá bɔɔ́ Jus ukwɔ́négé, delya melɔ defɛ́ né mbale ɛbɛ́ɛ, ɛsé debɔ́ defɛré nnó ɛfɛɛ́ ne bɔɔ́ Jus áchómege anɛnemmyɛ. Dékwɔ́négé ɛwu, degɛ́ andée fɔ́ áchomé ne ɛsé dejwɔlé ka, dégaré ɛbwɔ́ mekomejɔɔ́ Ɛsɔwɔ. ");
INSERT INTO anvNT_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Mendée fɔ abɔ alu ɛfɛɛ́ ayi ákuú ji Lydiya, apɔ́ muú Jus ne ánoge Ɛsɔwɔ. Ji atané melɔ Tayatira ne akɛne gesege ufɔɔ́ mandeé ayi ájamé ŋka dɔɔ́. Ndɛre awuú geno ɛyigé Pɔl ajɔge, Ɛsɔwɔ anené ji metɔɔ́ nnó akame. ");
INSERT INTO anvNT_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Áwyage ji manaá Ɛsɔwɔ ne ɛkwɔ wuú, anɛ ɛsé mmyɛ nnó dejyɛ debɛlé né gepú jií mbɔgé ɛsé dekamé wáwálé nnó ji áfyɛɛ́ metɔɔ́ ne Jisɔs. Ájɔge mbɔ ɛsé defɛ́. ");
INSERT INTO anvNT_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Bií fɔ́, ndɛre ɛse debɔ́ dejyɛ né melu ɛwé ánɛnemmyɛ mbaá Ɛsɔwɔ, detuú ne mesɔ mendée ayi alu memfwɛ. Abɔ́ awya melo nchyɛ ayi apyɛ ji agarege depɔ ti depyɛ nyɛ meso gébé. Bɔɔ́ bi awya ji, ásɛle ŋka né depɔ ɛtiré ji ágarege. ");
INSERT INTO anvNT_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Mesɔ́ mendée yimbɔ agɛ́ge Pɔl ne Ɛse alɔ mánkalé, akwɔlege ɛse ake: “Bɔɔ́ bina álú bɔɔ́ útɔɔ́ Ɛsɔwɔ Anyatá. Ɛbwɔ́ áchwɔ́ mangaré nkane Ɛsɔwɔ áférege nyɛ ɛnyu né ɛfwyale gabo.” ");
INSERT INTO anvNT_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Ne mesɔ́ mendée yina apyɛ́ wyɛmbɔ né gejamégé ndɔ. Ne bii uma metɔɔ́ ɛsɔ Pɔl, anyá meló nchyɛ yimbɔ aké: “Ngarege wɔ mbaá mabɔ Jisɔs Kras, tané ji mmyɛ.” Ne tɛ́nétɛ́né yimbɔ atané. ");
INSERT INTO anvNT_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Bɔɔ́ bi awya maá memfwɛ yimbɔ, ágɛ́ge nnó meti ŋka bwɔ́ ɛwé ánɛre metɔɔ́ wyɛ ɛnó, ágbaré Pɔl ne Silas ája áfɛ́ né mbaá yi ákpakpa melɔ ápane mpa. ");
INSERT INTO anvNT_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Ájyɛge, ápyɛ ɛbwɔ́ átɛ́ne mbɛ ushu ampane mpa abi alu bɔɔ́ Rom aké: “Bɔɔ́ bina alú bɔɔ́ Jus, ne achyɛge ɛfwyale né melɔ ɛsé. ");
INSERT INTO anvNT_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Ɛbwɔ́ álɛrege uno bi ɛbɛ́ ɛse ɛlá ɛkamé wɔ́. Ɛse delu bɔɔ́ Rom; desɛ́lé fɔ depɔ ɛbwɔ́.” ");
INSERT INTO anvNT_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Gejamégé bɔɔ́ ɛyi gebɔ́ gelú ɛfɛɛ, geshulé Pɔl ne Silas mmyɛ ne ampané mpa ágyá ɛbwɔ́ mandeé mmyɛ, ne ágare nnó ádo ɛbwɔ́ ne unɔɔ́. ");
INSERT INTO anvNT_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Ne ádogé ɛbwɔ́ cháŋéné, ájyɛ áfyɛ́ ɛbwɔ́ né denɔ ne ágaré membamé gepúge denɔ nnó, ábámé ɛbwɔ́ cháncha. ");
INSERT INTO anvNT_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Membame yimbɔ awugembɔ, asɛ ɛbwɔ, ajyɛ fyɛ né maá gepú ayi tɛ mmu gepúge denɔ. Ɛfɛɛ́ ne afyɛ ɛbwɔ́ ufwɔlé. ");
INSERT INTO anvNT_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Ne metɔɔ́ utuú, Pɔl ne Silas anɛnemmyɛ, ákwáne makwa, áfɛ́ge Ɛsɔwɔ ne bɔɔ́ denɔ bi fɔ áwuú. ");
INSERT INTO anvNT_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Áké ápɛ́le, mme alɔ manyi ne gepúge denɔ genyi gekwɔné né tɛ mala dekwɔ́re gepu. Manombi gepú yimbɔ ánené, ne bɔ ŋkpɔkɔvɛ bimbɔ ásɔré ákwé mme. ");
INSERT INTO anvNT_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Membame gepú yimbɔ apégé gejya, agɛ́ nkane manombi alaá fuú, afɛré nnó bɔɔ́ denɔ ako ábó. Ajú aparaja wuú nnó awá gemɛ jií. ");
INSERT INTO anvNT_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Pɔl agɛ́gé mbɔ akalé kéŋké aké: “Ɔwágé gemɛ jyɛ, ɛsé ako delu fa.” ");
INSERT INTO anvNT_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Ne membamé gepúge denɔ ákuú muú fɔ nnó achwɔ́ ji ne mewɛ. Gébégé áchwɔ́ ne ɛwú, asɛ, akpɛ́ mmu wáwá. Átó mano mme mbɛ ushu Pɔl ne Silas awere ne ɛfɔ metɔɔ́. ");
INSERT INTO anvNT_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Ne asɛ ɛbwɔ́ átané dafyɛ, agií ɛbwɔ́ ake: “Antɛ ba, mpyɛ nnó ne áféré me né ɛfwyale gabo?” ");
INSERT INTO anvNT_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Ɛbwɔ́ ashú ji meko aké: “Fyɛ́ metɔɔ́ wyɛ ne Jisɔs, Wɔ ne ula gepú byɛ detánege nyɛ né ɛfwyale gabo.” ");
INSERT INTO anvNT_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Ne ɛbwɔ́ ágaré ji ne bɔɔ́ ako bi alu ji mmu depɔré Jisɔs. ");
INSERT INTO anvNT_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Wyɛ ne utuú bimbɔ, mende yimbɔ asɛ ɛbwɔ́, ajyɛ shwɔ́ne upa bwɔ́. Wyɛ tɛ́nétɛ́né yimbɔ pɔl ne Silas áwyaá ji manaá Ɛsɔwɔ ne bɔɔ́ bií. ");
INSERT INTO anvNT_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Ne asɛ ɛbwɔ́ áfɛ́ né gepú jií achyɛ ɛbwɔ́ menyɛɛ́. Ji ne bɔɔ́ bi matɔɔ́ ágɔ bwɔ́ dɔɔ́ gétúgé áfyɛɛ́ metɔɔ́ ne Ɛsɔwɔ. ");
INSERT INTO anvNT_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Bií ujyage, ampané mpa abi Rom átɔ́ bɔɔ́ bee nnó ájyɛ garé membame gepúge denɔ nno, “Lyáge andé bimbɔ ájyɛ́.” ");
INSERT INTO anvNT_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Ne mende yina awugembɔ, ajyɛ garé Pɔl aké: “Ámpané mpa átɔ́ bɔɔ́ achwɔ́ gare me nnó nlya ɛnyú dejyɛ. Nana kɛ́ge pere.” ");
INSERT INTO anvNT_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Yɛ́mbɔ Pɔl ajɔɔ́ ne bɔɔ́ bee bimbɔ aké: “Átulé ɛsé né mbɛ ushu bɔɔ́ ayi álá lú dampa mpa ɛsé yɛlé ábɔ́ áchyɛ́ ɛsé ɛbwɔnyɛ nnó debɛ bɔɔ́ Rom.” ");
INSERT INTO anvNT_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Ne bɔɔ́ bee bimbɔ ákéré ájyɛ́ gare ámpané mpa genó ɛyigé Pɔl abɔ́ ajɔɔ́. Ɛbwɔ́ áwúgé nnó Pɔl ne Silas alú ntó bɔɔ́ Rom manɛ magyalé ɛbwɔ́. ");
INSERT INTO anvNT_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Ne ɛbwɔ́ áchwɔ́ kwɔ Pɔl ne Silas mata né gyɛ́ ayi ɛbwɔ́ ápyɛ́ɛ, áféré ɛbwɔ́ ne áké álya melɔ bwɔ́. ");
INSERT INTO anvNT_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Pɔl ne Silas átanege gepú denɔ, áfɛ́ né gepúge Lydiya. Ɛfɛɛ́ ne ábané bɔɔ bi ákamé ne Jisɔs. Áchyɛge ɛbwɔ majyɛ́, ne álya ájyɛ. ");
INSERT INTO anvNT_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Pɔl ne Silas ákoóge melɔ Amfipolis ne melɔ Apolonia áchwɔ́ né melɔ Tɛssalonika mbaá ayi ɛcha mmyɛmenɛne bɔɔ́ Jus ɛwé fɔ́ ɛlu. ");
INSERT INTO anvNT_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Ne Pɔl ajyɛ kpɛ né ɛcha ɛwémbɔ nkane ji abɔ apyɛ́ mɛ́, ne agare bɔɔ́ depɔ ɛtire delú mmu ŋwɛ Ɛsɔwɔ né mawyaá bɔɔ́ Jus málɛɛ́. ");
INSERT INTO anvNT_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Apyɛ ɛbwɔ́ ákaá cháŋéné nnó Muú yi Ɛsɔwɔ akweré ji ɛlá gefwa, ayi ɛbwɔ́ ábɔ́ ágili, abɔ́ mangɛ́ ɛfwyale ne akwilé né negbo. Ne aké Jisɔs ayi ji agarege mbɔ ɛbwɔ́, ji ne alu Muú yi Ɛsɔwɔ akweré ji ɛlá gefwa. ");
INSERT INTO anvNT_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Bɔɔ́ bifɔ abi áwuú depɔti, ásɛ detí amu apeá ne ácho ne Pɔl ne Silas. Gejamégé bɔɔ́ Grek abi ánóge Ɛsɔwɔ chóncho ne afwa andée ácho ntó ne ɛbwɔ́. ");
INSERT INTO anvNT_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Ne bɔɔ́ Jus abi ábɔ́ ashya mekomejɔɔ́ yi, agɛge mbɔ matɔɔ́ ásɔ́ ɛbwɔ́ ne Pɔl ne Silas. Ájyɛ nywéré bɔɔ́ bi álá pɔ́ ne genó mampyɛ né metɔɔ́ melɔ, áchwɔ́ ne ɛfwyale. Ɛbwɔ álɔ mamwyalé mejɔɔ́ ne ájyɛ́ do gepúgé mende fɔ ayi áku ji Jasɔn ágyá nnó ája Pɔl ne Silas átó dafyɛ. ");
INSERT INTO anvNT_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Ndɛre álá gɛ́ ɛbwɔ́ wɔ́, ája Jasɔn ne bɔɔ́ Jisɔs abifɔ áfɛ mbɛ ushu ákpakpa melɔ, ákálege áké: “Bɔɔ́ bina ákɛ́ne achyɛge ɛfwyale malɔmalɔ ne náná áchwɔ́ ntó fa melɔ ɛsé, ");
INSERT INTO anvNT_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","ne Jasɔn asɛ ɛbwɔ́, abelé mmu. Ɛbwɔ́ átyá mabɛ́ Mfwa Rom, ájɔ́ge áké mfwa ayicha alu ayi ákuú ji Jisɔs.” ");
INSERT INTO anvNT_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Ákpakpa melɔ ne bɔɔ́ bi áchomé ɛfɛɛ́ áwúgé mbɔ, mewɛ ɛtya ɛbwɔ unɛ. ");
INSERT INTO anvNT_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Ágbaré Jasɔn ne bɔɔ́ Jisɔs nnó áchwɔ́ kwɔ ne amage pyɛ sé gefɔ genó yimbɔ ndɔ yichá ne álya ɛbwɔ́ nnó ájyɛ́. ");
INSERT INTO anvNT_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Wyɛ né utuú ɛbimbɔ, bɔɔ́ Jisɔs ágaré Pɔl ne Silas nnó ájyɛ né melɔ Bɛrya. Ɛbwɔ́ ákwɔ́négé ɛwu, ájyɛ kpɛ né ɛcha mmyɛmenɛne bɔɔ́ Jus. ");
INSERT INTO anvNT_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Bɔɔ́ Jus abi alu ɛfɛɛ́ awya defɔɔ́ apwɔ́ abi melɔ Tɛssalonika. Ɛbwɔ́ áfyɛ́ matɔɔ́ dɔɔ́ manwu genó ɛyi Pɔl ajɔge. Ne yɛndé bií ɛbwɔ́ ágii mekomejɔɔ́ Ɛsɔwɔ mangɛ mbɔge uno ɛbi Pɔl ajɔge úlú wáwálé. ");
INSERT INTO anvNT_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Ɛ́wyágé gejamégé bɔɔ́ áfyɛɛ́ matɔɔ́ ne Jisɔs. Abi fɔ́ alu afwa andé bɔɔ́ Grek ne gejamégé bɔɔ́ Grek abi ande áfyɛɛ́ ntó matɔɔ́ ne Jisɔs. ");
INSERT INTO anvNT_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Ɛbɛlege bɔɔ́ Jus abi alu né melɔ Tɛssalonika áwugé nnó Pɔl agarege mekomejɔɔ́ Ɛsɔwɔ né melɔ Bɛrya, áchwɔ nyi bɔɔ́ matɔɔ́ nnó achwɔ́ ne ɛfwyale. ");
INSERT INTO anvNT_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Ne tɛ́nétɛ́né yimbɔ, bɔɔ́ Jisɔs átɔ́ Pɔl né mbale ɛbɛɛ́ mega. Bɔɔ́ fɔ ntó ákwɔlé ji. Ne Silas ɛbwɔ́ ne Timɔti ála né Bɛrya. ");
INSERT INTO anvNT_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Bɔɔ́ bi ájyɛ́ tí Pɔl, áfɛ́ kpaá ákwɔ́né melɔ Atɛns. Gébégé ɛbwɔ́ ákérégé Pɔl alɔ ɛbwɔ́ meko nnó ágaré Silas ne Timɔti ábané ji wáwá. ");
INSERT INTO anvNT_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Ndɛre Pɔl alu gili Silas ne Timɔti né melɔ Atɛns, metɔɔ́ ɛgɔ ji wɔ́ gébégé agɛné nnó aló uka ájá né melɔ ɛwémbɔ. ");
INSERT INTO anvNT_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Ne afɛ́ né ɛcha mmyɛmenɛne bɔɔ́ Jus alɔ mando abya né mechɔ́ ɛwé ne ɛbwɔ́ ne abifɔ abi anóge nto Ɛsɔwɔ, nno ápyɛ ɛbwɔ́ ákame ne ji. Ne yɛndé bií ajyɛ ntó né ntóné gese, ajɔge ne bɔɔ bi ákoóge né melu ɛwé ji alu. ");
INSERT INTO anvNT_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Anlɛré fɔ ágɛ́ ji, ɛbwɔ́ álú bɔɔ́ bi álɛ́rege depɔré Ɛpikuryan ne ɛtiré ákuú Stɔk. Ɛbwɔ́ áwuúgé nkane Pɔl alɛrege bɔɔ́ depɔré Jisɔs, ama garege nkane bɔɔ́ akwilege nyɛ né negbo, álɔ manshyɛ ji ake: “Ndé menya yina adorege ne ubɔ́meno?” Abi fɔ áké: “Ɛlu ɛké akɛlege mangaré abya aló abi ákɛ.” ");
INSERT INTO anvNT_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Ne ásɛ Pɔl áfɛ́ ne ji né ɛchomele melɔ ɛwé ákuú nnó Aropagus ne bɔɔ́ áké ne ji: Nana ɛsé dekɛlege manwú cháŋéné unó ukɛ ɛbi ɔlɛ́rege. ");
INSERT INTO anvNT_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Unó bifɔ ɛbi ɔlɛrege úlú chá ne ɛsé dekɛlege mankaá nkane ubi úlú. ");
INSERT INTO anvNT_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Ɛbwɔ́ ábɔ́ ajɔge mbɔ néndé ɛbwɔ́ bɔɔ́ Atɛns ne aŋkɛɛ́ abi alu ɛfɛɛ́, ágbó lé manjwɔ́légé áwugé ne ágarégé unó ukɛ ɛbi ɛbwɔ́ áwuú né abya. ");
INSERT INTO anvNT_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Ne Pɔl atɛné mbɛ shuú ɛchomele Aropagus ake: “Ɛnyu bɔɔ́ Atɛns, ngɛ nnó depyɛ upɛ mbaá aló dɔɔ́, ne demuame manogé Ɛsɔwɔ.” ");
INSERT INTO anvNT_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Ndɛre nkɛ́ne ngyáge melɔ nyú, mpɛle matoó ayi ɛnyú depyɛ upɛ, ngɛ́ ntoó nema ɛni ásámé nnó: “Mbaá Ɛsɔwɔ, ayi ɛsé dela dekage ji.” Ɛsɔwɔ ayi ɛnyú depyɛ upɛ ne delá kágé, ji ne nkɛlege mangaré ɛnyú nana. ");
INSERT INTO anvNT_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","“Ɛsɔwɔ ne alu Ata ayi abɔ mfaá ne mme nende ji ne akwyɛ́ mme meko ne unó uko ɛbi úlú wyɛ́. Yɛ́mbɔ ji ajwɔ́légé fɔ́ né matoó ayi akwaá ákwyɛ́ ne amu. ");
INSERT INTO anvNT_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Yɛ mankɛle nnó mekwaá achyɛ ji geno ɛke gefɔ́ geli ji. Ji mbɔ́ɔ ne achyɛge akwaá geŋwá ne gejuli ne unó uko. ");
INSERT INTO anvNT_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Apyɛ ufɔɔ́ bɔɔ́ cháchá átané mbaá muú ama ayi ji akwyɛ né ula ulɔ. Akwyɛ gébé gakɛné ɛyigé yɛndé ufɔɔ́ bɔɔ́ ábɛ́lege fa mme yina ne malu ayi ɛbwɔ́ ábɛɛ́. ");
INSERT INTO anvNT_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Ne ji apyɛmbɔ nnó bɔɔ́ akɛlege ji, ne ndɛre ámuame mankɛlé ji ábɛɛ́ ne umɛɛ́ nnó ndɔ fɔ ákage gɛ́ ji. Yɛ́mbɔ Ɛsɔwɔ apɔ́ fɔ́ tɛtɛ ne ɛsé. ");
INSERT INTO anvNT_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Ɛlu wyɛ ndɛre muú fɔ aké: ‘Né uto Ɛsɔwɔ ne ɛsé dégbege gejulé, delú abɛ, dekɛne.’ Mbɔntó ne muú deŋga nyú asámé aké: ‘Ɛsé ako ntó delu baá bií.’ ");
INSERT INTO anvNT_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","“Tɛ ɛsé delu baá Ɛsɔwɔ ɛkágé defɛré nnó Ɛsɔwɔ alu aló abi akwaá akwyɛge, yɛ akwyɛ ne gese, yɛ ne ntaá, yɛ ne genɔɔ́, ji apɔ́fɔ́ mbɔ. ");
INSERT INTO anvNT_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Nyá mbɛmbɛ Ɛsɔwɔ afyɛ́ fɔ́ mekpo né unó bi bɔɔ́ abɔ apyɛ ayi álá kagé ji. Ne nana agarege yɛ́ndémuú nnó alya unó ɛbimbɔ ɛbi úlá pɔ́ ne nsá. ");
INSERT INTO anvNT_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Ji ajɔge mbɔ gétúgé ji ábelé mɛ bií ɛbi bɔɔ́ akpɛ́ne unɔɔ mpa ne ásɔɔ́ nyɛ mpa bɔɔ́ ayi defya delá debɛ́ mmu. Ji abɔ ajya mɛ muu yi ásɔɔ́ nyɛ mpa yimbɔ ne apyɛ ji akwilé né negbo, mampyɛ bɔɔ́ akaá nnó mechɔ́ ɛwéna ɛpyɛ nyɛ wáwálé.” ");
INSERT INTO anvNT_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Ɛbwɔ́ áwúgé nkane Pɔl ajɔɔ́ nnó muú fɔ akwilé né negbó, ájwyá ji. Ne abi fɔ́ áké, “Ɛsé dekɛlege manwú ɔdo ɛsé abya yina ndɔ yicha.” ");
INSERT INTO anvNT_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Ne Pɔl alya ɛbwɔ́, atané. ");
INSERT INTO anvNT_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Yɛ́mbɔ bɔɔ́ bi ákamé mekomejɔɔ́ wuú ácho ne ji. Muú bwɔ́ ama akamege Dyonasɔs ayi alu ntó né ɛchomele ɛwémbɔ ɛwe ákuú Aropagat. Ne ayifɔ alu mendée ayi ákuú ji Damaris ne bɔɔ́ bifɔ ntó. ");
INSERT INTO anvNT_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Pɔl anérégé manjɔɔ́ depɔti né ujwɔ́lé Aropagɔs, Pɔl alya Atɛns afɛ́ né melɔ Kɔrɛnt. ");
INSERT INTO anvNT_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Ɛfɛɛ́ abané muú Jus fɔ ayi ákuú ji Akwila, ábɔ́ ábyɛ́ ji né melɔ Pɔntus. Ɛbwɔ́ ne mendée wuú Prisila abɔ́ átané mbɔ lé gebagé mewaá Itali getúgé Klodyos, mfwa kpa abɔ́ abú bɔɔ́ Jus ako né Rom. Ne Pɔl ajyɛ gɛ́ ɛbwɔ́ ujyá. ");
INSERT INTO anvNT_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Pɔl agɛ́gé nnó ɛbwɔ́ nto ákwyɛ́ge mekɔ menya ɛyi akwerege oto, ɛyi ji akwyɛge, ajwɔlé akwyɛge ne ɛbwɔ́. ");
INSERT INTO anvNT_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Ne yɛndé bií uwyaá bɔɔ́ Jus, ajyɛ mmu ɛcha mmyɛmenɛne, ne ajɔɔ́ge ne bɔɔ́ Jus ne abi Grek abi áchwɔ́ ɛfɛɛ́ nnó ji ammyɛ apyɛ ɛbwɔ́ ákamé mekomejɔɔ́ Jisɔs. ");
INSERT INTO anvNT_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Ɛwyagé Silas ne Timɔti átané melɔ Masedonia áchwɔ́ né melɔ Kɔrɛnt, ɛfɛɛ́ ne Pɔl alya ɛbwɔ́ utɔɔ́ ɛbimbɔ, ala agarege lé mekomejɔɔ́ Ɛsɔwɔ jiji. Apyɛ mbɔ nnó bɔɔ́ Jus akaá cháŋéné nnó Jisɔs ne alu Muú yi Ɛsɔwɔ akweré ji ɛlá gefwa. ");
INSERT INTO anvNT_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Ɛké ɛwyage ɛbwɔ́ áshya mekomejɔɔ́ wuú álɔ manshyɛ ji. Ne Pɔl apea amu jií ake, “Mbɔge ɛnyú depyɛge ɛfwyale Ɛsɔwɔ ɛchwɔge ɛnyú mmyɛ, me mpɔ́ wyɛ. Lɔ nana ɔjyɛ mbɛ, nla garé mekomejɔɔ́ Ɛsɔwɔ mbaá bɔɔ́ abi álá pɔ́ bɔɔ́ Jus.” ");
INSERT INTO anvNT_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Pɔl alyage ɛbwɔ́, atané nto né gepú ɛyigé ji abɔ́ ajwɔlege, ajyɛ jwɔle ne mende fɔ yi anoge Ɛsɔwɔ ne álá pɔ́ muú Jus. Mende yina akamege Titiyɔs Justɔs ayi gepú jií gelu kwɔ́kwɔ́lé ne ɛcha mmyɛmenɛne bɔɔ́ Jus. ");
INSERT INTO anvNT_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Ɛwyage Kripus ayi alu muú kpaá né ɛcha mmyɛmenɛne ɛwémbɔ áfyɛɛ́ metɔɔ́ wuú ne Jisɔs chóncho ne bɔɔ́ ula gepú bií ako. Ne Pɔl agarege wyɛ abya Jisɔs ne bɔɔ́ Kɔrɛnt ako abi áwuú, gejame ákamé ne ála wyɛmbɔ áwyaá bwɔ manaá Ɛsɔwɔ. ");
INSERT INTO anvNT_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Bií fɔ ne utuú, Pɔl agɛ́ amɛ gejya nkane Átá Jisɔs ake ne ji, “Ɔfɔgé fɔ́, chó mbɛ ne mekomejɔɔ́ wa, ɔbɛge bɔmbɔ. ");
INSERT INTO anvNT_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Nlu ne wɔ yɛndégébé ne muú akágé pyɛ wɔ geno. Gejamégé bɔɔ́ álu fa melɔ ɛwe abi alu aba.” ");
INSERT INTO anvNT_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Ne Pɔl abɛlé né melɔ Kɔrɛnt ŋmɛ ne geba alɛrege bɔɔ́ mekomejɔɔ́ Ɛsɔwɔ. ");
INSERT INTO anvNT_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Né gébé ɛyigé bɔɔ́ Rom abɔ́ áfyɛ́ Galyo nnó ábɛ́ gɔmena né gebagé mewaá Akaya, bɔɔ́ Jus abi alu ɛfɛɛ́, ásɔ mala, ágbare Pɔl ájyɛ ne ji né ɛso, ");
INSERT INTO anvNT_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","ajɔɔ́ ne Galyo aké, “Mende yina apyɛ bɔɔ́ nnó ánoge Ɛsɔwɔ né meti ɛwé ɛbɛ́ se ɛlá garé wɔ́.” ");
INSERT INTO anvNT_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Wyɛ ndɛre Pɔl abɔ alú manjɔɔ́, Galyo ake ne ɛbwɔ́. “Ɛnyú bɔɔ́ Jus, mbɔge mechɔ ɛwé ɛbɔ́ ɛtá mabɛ́ melɔ mbɔ nsɛ gébé manwu geno ɛyige dekɛlege manjɔɔ́. ");
INSERT INTO anvNT_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Tɛ mbaá ɛnyú denyɛ lé mbeé né uchu mejɔɔ́ ne mabɔ ne mabɛ nyú, ɛnyú ambɔɔ́ kage nkane dejɔge. Nkpɛ́né fɔ né depɔ nkane ɛti.” ");
INSERT INTO anvNT_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Ajɔge mbɔ, abú ɛbwɔ́ átané né ɛcha ɛso. ");
INSERT INTO anvNT_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Ne bɔɔ́ ako ágbaré Sɔstɛnis ayi alu muú kpaá né ɛcha mmyɛmenɛne álɔ mantulé ji, yɛ́mbɔ Galyo abɔɔ́ gébé wɔ́. ");
INSERT INTO anvNT_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Ɛpyɛ́gé mbɔ, Pɔl ama bɛ́lé gejamégé ndɔ ne bɔɔ́ bi ákamé ne Jisɔs né melɔ Kɔrɛnt, ne ale jyɛ kpɛ ɛ́kpe manjyɛ né melɔ Siriya. Ndɛre áchwɔ ajyɛ, Prisila ne Akwila akwɔlé ji. Gébégé ɛbwɔ́ ákwɔné né Sɛnkrea, melu ɛwé ákpɛ́ne ɛ́kpe, Pɔl akpalé mekpo gétúgé depɔ ɛtiré ji abɔ anyɛ́meno mampyɛ mbaá Ɛsɔwɔ. ");
INSERT INTO anvNT_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Ɛbwɔ́ ákwɔ́négé né melɔ Ɛfɛsɔs, Pɔl alya Akwila ɛfɛɛ́. Ajyɛ kpɛ mmu ɛcha mmyɛmenɛne, manjɔɔ́ mejɔɔ́ ne bɔɔ́ Jus. ");
INSERT INTO anvNT_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Ne ɛbwɔ́ ákwɔ ji mata nnó ábɛ́lé gejamégé ndɔ ne ɛbwɔ́, ashya. ");
INSERT INTO anvNT_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Gébégé achwɔ́ jyɛ, aké ne ɛbwɔ́, “Mbɔge Ɛsɔwɔ apyɛge, mmage nchwɔ gɛ ɛnyú.” Ajɔge mbɔ, alya Ɛfɛsɔs akpɛ ɛ́kpe, afɛ́. ");
INSERT INTO anvNT_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Pɔl akwɔ́négé né melɔ Kaisaria, akwɔ́ afɛ́ né melɔ Jɛrosalɛ manjyɛ tame ɛchomele bɔɔ́ Jisɔs abi alu ɛfɛɛ́ ne ale shule ajyɛ né melɔ Antiɔk. ");
INSERT INTO anvNT_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Ábɛ́légé mboó ndɔ ɛfɛɛ́, átane áfɛ́ né malɔ ayi álú né gebage mewaá Galasiya ne Frigiya, afyɛ́ bɔɔ́ bi ákame ne Jisɔs ɛshyɛ. ");
INSERT INTO anvNT_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Ne muú Jus fɔ achwɔ́ né melɔ Ɛfɛsɔs, ákuú ji Apolos ne ábɔ́ ábyɛ́ ji né melɔ Aleksandra. Alu muú yi mejɔɔ́ ɛgɔɔ́ ji meno ne akaá mekomejɔɔ́ Ɛsɔwɔ chanchá. ");
INSERT INTO anvNT_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Ábɔ́ ági ji depɔré Jisɔs ne agbaré deti metɔɔ́ ɛma, agarege depɔ ɛtiré mbɔ chánchá. Yɛ́mbɔ abɔ akaá le unó bi Jɔn abɔ agaré ndɛre awyage bɔɔ́ manaá Ɛsɔwɔ. ");
INSERT INTO anvNT_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Ndɛre áchwɔ né melɔ Ɛfɛsɔs, agarege bɔɔ́ Jus depɔ ɛtirena gbɔŋéné né ɛcha mmyɛmenɛne. Akwila ne Prisila awuúge unó bi Apolos agarege, ásɛ ji áfɛ́ né gepú bwɔ́ ne agaré ji depɔré Ɛsɔwɔ nana cháŋéné. ");
INSERT INTO anvNT_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Ɛbɛ́légé Apolos afɛre nnó ji ajyɛ né melɔ Akaya. Ne ɛchomele bɔɔ́ Jisɔs apoó ji ásá ŋwɛ achyɛ ji mbaá bɔɔ́ Jisɔs né melɔ Akaya nnó Apolos akwɔnege ɛwu, ɛbwɔ́ ásɛ ji cháŋéné. Ne akwɔ́négé ɛfɛɛ́, apoó bɔɔ́ bi Ɛsɔwɔ alɛ́ré ɛbwɔ́ galɔ́gálɔ́ ákamé ne Jisɔs dɔɔ́ abi Ɛsɔwɔ apoó nnó áfyɛ matɔɔ́ ne Jisɔs. ");
INSERT INTO anvNT_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Abɔ́ anyɛɛ́ mbeé ne bɔɔ́ Jus né depɔré Jisɔs gbɔgɔnɔ ne apwɔ wyɛ ɛbwɔ́ ndɛre alɛrege ɛbwɔ́ cháŋéné né ŋwɛ Ɛsɔwɔ nnó Jisɔs alu Muú yi Ɛsɔwɔ akweré ji ɛlá gefwa. ");
INSERT INTO anvNT_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Né gébé ɛyige Apolos abɔ́ álú né melɔ Kɔrɛnt, Pɔl abɔ akɛne né malɔ ayi alu né gebage mewaá Ɛsya. Akwɔnege melɔ Ɛfɛsɔs, agɛ́ bɔɔ́ bi fɔ abi áfyɛ matɔɔ́ ne Jisɔs, ");
INSERT INTO anvNT_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","ne agií ɛbwɔ́ aké, “Mendoó Ukpea ɛchwɔ mɛ ɛnyú mmyɛ gébégé dekame ne Jisɔs?” Ɛbwɔ́ áshuú meko áké, “Ɛse delu danwu nnó Mendoó Ukpea ɛlu.” ");
INSERT INTO anvNT_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Ne Pɔl ama gií ɛbwɔ́ aké, “Ndé gefɔge manaá Ɛsɔwɔ ami áwyaá ɛnyú?” Ne ɛbwɔ́ áké, “Áwyaá le ɛse ami Jɔn.” ");
INSERT INTO anvNT_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Ájɔgé mbɔ, Pɔl alɔ yɛ mangaré ɛbwɔ́ aké, “Jɔn abɔ́ awyaá bɔɔ́ manaá Ɛsɔwɔ manlɛre nnó ɛbwɔ́ álya gabo. Ne ji abɔ́ agaré bɔɔ́ Isrɛli nnó muú fɔ achwɔɔ́ nyɛ ji meso ne ɛbwɔ́ abɔ mamfyɛ́ matɔɔ́ ne ji. Muú yimbɔ, ákuú ji Jisɔs.” ");
INSERT INTO anvNT_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Ɛbwɔ́ áwúgembɔ, ákame mekomejɔɔ́ yina ne áwyaá bwɔ́ manaá Ɛsɔwɔ né mabɔ Atá Jisɔs. ");
INSERT INTO anvNT_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Ɛwyage, Pɔl anɛré ɛbwɔ́ amu makpo ne Mendoó Ukpea ɛchwɔ ɛbwɔ́ mmyɛ ne álɔ manjɔɔ́ ufɔɔ́ mejɔɔ́, ama ágaregé mekomejɔɔ́ ayi ɛbwɔ́ awuú ne Ɛsɔwɔ. ");
INSERT INTO anvNT_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Bɔɔ́ bina ako alu genóge makpo áfyanéápeá. ");
INSERT INTO anvNT_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Ne Pɔl abɛlé né Ɛfɛsɔs né amfaá alɛɛ́, akɛne né ɛcha mmyɛmenɛne yɛndégébé, agarege ɛbwɔ́ mekomejɔɔ́ Ɛsɔwɔ ayi alá pɔ́ ne ɛfɔ metɔɔ́ mampyɛ ɛbwɔ́ akaá ndɛre gefwage Ɛsɔwɔ gelu. ");
INSERT INTO anvNT_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Yɛ́mbɔ bɔɔ́ bifɔ áshyá mekomejɔɔ́ yina ne álɔ manjɔɔ́ depɔ debodebo né mbɛ ushu bɔɔ́ né meti Jisɔs. Ne Pɔl asɛ bɔɔ́ abi ákame áfɛ́ né gepúge ŋwɛ ɛyigé Tiranɔs awya, alɛrege ɛbwɔ́ mekomejɔɔ́ Ɛsɔwɔ yɛndé bií. ");
INSERT INTO anvNT_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Apyɛ wyɛmbɔ né aŋmɛ́ apea ne bɔɔ́ ako né gebagé mewaá Ɛsya, bɔɔ́ Jus ne bɔɔ́ Grek áwuú mekomejɔɔ́ Ata Ɛsɔwɔ. ");
INSERT INTO anvNT_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Ndɛre Pɔl abɔ alu lɛrege mbɔ, Ɛsɔwɔ achyɛ ji uto mampyɛ ufélekpá ɛbi bɔɔ́ ábɔ́ álú daŋgɛ́. ");
INSERT INTO anvNT_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Yɛ uno bi ji abɔ afyɛ né mmyɛ, upyɛ́ bɔɔ́ mameé átoóge. Bɔɔ́ ákɛlege mandeé utɔɔ́ jií ne bɔ afyáfoŋ áfɛ́ ánɛré bɔɔ́ mameé mmyɛ ne ápyɛ ɛbwɔ́ atoó. Ne aló nchyɛ nto atanege abifɔ mmyɛ. ");
INSERT INTO anvNT_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Bɔɔ́ Jus fɔ abɔ́ álú ɛfɛɛ́ abi akɛne malɔmalɔ áférege aló nchyɛ ayi achyɛge bɔɔ́ ɛfwyale. Ɛbwɔ́ amuame mankuú mabɔ Ata Jisɔs ne apyɛ aló nchyɛ átané bɔɔ́ mmyɛ. Muú bwɔ́ ajɔɔ́ge ne meló nchyɛ aké, “Ngarege wɔ nnó ɔtané né mabɔ Jisɔs ami Pɔl akuú.” ");
INSERT INTO anvNT_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Ne bɔɔ́ akeneama abi abɔ́ ápyɛ depɔ ti, ɛlé baá Skɛva ayi alu ɛtukpe ampyɛ upɛ Ɛsɔwɔ bɔɔ́ Jus. ");
INSERT INTO anvNT_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Ɛbwɔ́ ajɔge mbɔ ne meló nchyɛ ashuú ɛbwɔ́ meko gébé gefɔ aké, “Me nkaáge Jisɔs, mma nkaáge Pɔl ne ɛnyú delu ndé bɔɔ́?” ");
INSERT INTO anvNT_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Mende ayi awya meló nchyɛ akwile tɛ́né, asɛ ɛbwɔ́ ne matulé, apwɔ ɛbwɔ́ ne agya ɛbwɔ́ mandeé mmyɛ, ábó átané gejɔ́gene ne upa mmyɛ. ");
INSERT INTO anvNT_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Bɔɔ́ Ɛfɛsɔs, ne bɔɔ́ Jus ako ne bɔɔ́ Grek abi alu ɛfɛɛ́ áwúgé abya yina ɛfɔ́ ɛkwɔ́ ɛbwɔ́ matɔɔ́. Ne bɔɔ́ álɔ manchyɛge ɛnogé dɔɔ́ né mabɔ Áta Jisɔs. ");
INSERT INTO anvNT_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Ne gejamégé bɔɔ́ bi áfyɛɛ́ matɔɔ́ ne Jisɔs áchwɔ́ shu ɛkwu, ágaré depɔ ɛtiré ɛbwɔ́ ábɔ́ ápyɛɛ́. ");
INSERT INTO anvNT_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Bɔɔ́ bifɔ abi ábɔ́ ápyɛ́ mabu maka amu áchwɔ ne bɔ ŋwɛ maka, aló uka ne bɔ ŋkpáganɛré ásɔ́ gbɔ́gɔ́nɔ́. Unó bina uko, ne unó bi fɔ afɛrege ukáge bɛɛ́ meno ŋka genóge usaá uba upea meso ɛfya. ");
INSERT INTO anvNT_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Ne mekomejɔɔ́ Ɛsɔwɔ awɛne ajyɛ mbɛ nkane gejamégé bɔɔ́ ákamege yɛndégébé. ");
INSERT INTO anvNT_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Depɔ tiré na depyɛge, Pɔl afɛre né metɔɔ́ wuú mankoó né melɔ Masedonia ne melɔ Akaya manjyɛ né Jɛrosalɛ. Ne ama jɔɔ́ aké, “Nkwɔnégé Jɛrosalɛ, mbɔ manjyɛ gɛ́ nto melɔ Rom.” ");
INSERT INTO anvNT_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Ne atɔ́ Timɔti ne Ɛrastus nnó ábɔ́ mbɛ né gebagé mewaá Masedonia ɛbwɔ́ álú bɔɔ́ apea abi apoóge ji ne Pɔl jimbɔ alu bɛlege mboó ndɔ né gebagé mewaá Ɛsya. ");
INSERT INTO anvNT_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Wyɛ né gébé ɛyigémbɔ, ɛfwyale ɛchwɔ dɔɔ́ né melɔ Ɛfɛsɔs getúge bɔɔ́ bi akwɔlege meti Jisɔs. ");
INSERT INTO anvNT_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Muú ɛte fɔ abɔ́ alú ɛfɛɛ́ ayi ákuú ji Demetrɔs. Ji akwyɛge unó bi úlú ɛké gepúgé meló uka ayi ákuú Atemis. Utɔɔ́ bina upyɛ ji ne bɔɔ́ ɛte bifɔ ágɛ́ne gejamégé nsa. ");
INSERT INTO anvNT_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Né gébé géfɔ́ akuú atɛ bɔɔ́ ɛte ne bɔɔ́ utɔɔ́ abi gefɔge utɔɔ́ ɛbwɔ́ gelu gema aké, “Ɛnyú kaáge nnó ɛsé deŋeá mbɔ gefwa gétúgé utɔɔ́ bina. ");
INSERT INTO anvNT_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Ɛnyú ako déwuú ne degɛ geno ɛyigé Pɔl menya kwɔ yimbɔ apyɛ fa melɔ Ɛfɛsɔs ne gebagé mewaá Ɛsya geko. Akɛne malɔmalɔ ajɔge aké aló uka abi ákwyɛ́ge ne amu, ápɔ́ yɛ aló uka chá chá. Ne apyɛ gejamégé bɔɔ́ akwɔre matɔɔ́. ");
INSERT INTO anvNT_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Ne ngɛ́ nnó apyɛ nyɛ gesege ɛse gekwé ne apyɛ nyɛ ntó nnó gepúgé meló uka Atemis gebɛgé sé ne ɛnogé. Mbɔgé ɛpyɛge mbɔ, ɛbyɛnnó mekpo unɔɔ́ ɛbɛ nyɛ ne gekpɛ́kpɛ́ge melo uka yina ayi bɔɔ́ Ɛsya ne mme meko ánóge.” ");
INSERT INTO anvNT_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Bɔɔ́ bimbɔ awugé geno ɛyige Demetrɔs ajɔɔ́, matɔɔ́ achɔɔ́ ɛbwɔ́ mmu ne alɔ mankálé áké, “Atemis ayi bɔɔ́ Ɛfɛsɔs alu gekpɛ́kpɛ́gé melo uka.” ");
INSERT INTO anvNT_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Ne melɔ meko ɛwugé makalé yina, ɛkwé tametame. Ɛchwɔ cho melu ɛma, bɔɔ́ ágbaré Gayɔs ne Aristakɔs ande bi Pɔl átané ne ɛbwɔ́ né melɔ Masedonia, ája áfɛ́ ne ɛbwɔ́ né ɛcha uchome melɔ. ");
INSERT INTO anvNT_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Pɔl abɔ́ alu manjyɛ jɔɔ́ mejɔɔ́ ne bɔɔ́ bimbɔ, yɛ́mbɔ bɔɔ́ Jisɔs ágbɛ́ ji. ");
INSERT INTO anvNT_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Ákpakpa melɔ abifɔ abi alu ajeé Pɔl álɔ ntó ji meko nnó ɛkagé asá ushu né ɛcha ɛwémbɔ. ");
INSERT INTO anvNT_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Bɔɔ́ bimbɔ ákálege wyɛ tametame. Abi ákálege ɛgbɛ́ ɛwú ɛbwɔ́ ne abifɔ ákálege ɛwu bwɔ́ ɛgbɛ, gejamégé bɔɔ́ ákaá fɔ́ genó ɛyi gepyɛ ɛbwɔ́ áchomé ɛfɛɛ́ wɔ́. ");
INSERT INTO anvNT_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Bɔɔ́ bi fɔ ágɛ́ge nkane bɔɔ́ Jus átɛné Aleksanda mbɛ, áfɛré nnó ji ne alu ne mechɔ ɛwé. Ne Aleksanda afu ɛbwɔ nnó ɛbwɔ́ ákwéné mejɔɔ́ ne ji ashya gemɛ jií. ");
INSERT INTO anvNT_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Ne ɛbwɔ́ ákaáge nnó ji alu muú Jus, ɛbwɔ́ ako ákálé meko ama aké, “Atemis ayi bɔɔ́ Ɛfɛsɔs alu gekpɛ́kpɛ́gé melo uka.” Ne ákálege wyɛmbɔ né nchwánekɛ́ ɛpeá. ");
INSERT INTO anvNT_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Ɛwyagé muú ayi asáme depɔré melɔ, apyɛ bɔɔ́ bimbɔ ákwené mejɔɔ́ ne ajɔɔ́ ne ɛbwɔ́ aké, “Ɛnyú bɔɔ́ Ɛfɛsɔs, yɛ́ndémuú ákaá nnó melɔ Ɛfɛsɔs ne ɛbelé gepúgé gekpɛ́kpɛ́gé Atemis ne ɛma bélé ntaá meló uka wuú, ɛnine nétané mfaánebuú nékwené mme. ");
INSERT INTO anvNT_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Tɛ ɛnyú dekaá nnó muú fɔ akaágé shya mechɔ ɛwéna, kwenege nyamé, ɛkágé depyɛ genó gefɔ́ geŋchogeŋcho. ");
INSERT INTO anvNT_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Ɛnyú dechwɔ ne bɔɔ́ bina fa, abi álá jó genó gefɔ́ né matoó aló uka ɛsé wɔ́, yɛ mejɔɔ́ mebomebo mbaá megyɛɛ́ meló uka ɛsé ájɔɔ́ wɔ́. ");
INSERT INTO anvNT_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Mbɔgé Demetrɔs ne bɔɔ́ bií abɔ́ mechɔ́ ne bɔɔ́ bina, ákage kpa ɛwu áfɛ́ né ɛso né mbɛ ushu ámpané mpa nnó yɛndé bɔɔ́ ágaré mechɔ́ ɛwé ɛbwɔ́ ápyɛɛ́ ne atɛ. ");
INSERT INTO anvNT_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Ne mbɔgé mechɔ ɛwé chá ɛlu ɛwé ɛpwɔ́ ɛwé, ɛlu galɔ́gálɔ́ nnó ɛbwɔ́ áchwɔ́ né bií bi ákpakpa melɔ áchomege. ");
INSERT INTO anvNT_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Njɔge mbɔ getúgé mfɔ́ɔ nnó bɔɔ́ Rom ashulege nyɛ ɛsé ndo nnó déchwɔ ne ɛfwyale né melɔ. Ne ɛpyɛge mbɔ, muú fɔ ábɛɛ́ nyɛ ne meko ayi akerege.” ");
INSERT INTO anvNT_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Anérégé manjɔɔ́ depɔ ti, aké, yɛ́ndémuú atyá. ");
INSERT INTO anvNT_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Ɛfwyale ɛwémbɔ ɛbyɛgé, ɛbɛlégé mboó ndɔ, Pɔl akuú bɔɔ́ Jisɔs achyɛ ɛbwɔ́ majyɛ, atamé ɛbwɔ́ ne alyá afɛ́ né gebagé mewaá Masedonia. ");
INSERT INTO anvNT_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Akɛne né geba ɛyigémbɔ geko afyɛ́ɛ bɔɔ́ Jisɔs ɛshyɛ ne ájyɛ́ né gebagé mewaá Gresse. ");
INSERT INTO anvNT_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Akwɔ́négé ɛwu, abɛlé amfaá alɛɛ́. Ne nkane abɔ alu mankpɛ ɛ́kpe ajyɛ né gebagé mewaá Siriya, awu nnó bɔɔ́ Jus ásɔ́ mala manwá ji. Ɛfɛɛ́ ne ajya mankéré meso, ne akoóge ne ɛgbɛ Masedonia akéré meso. ");
INSERT INTO anvNT_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Ndɛre ajyɛ bɔɔ́ abi álu gelua ne ji ɛle Sopata maá Pyrhɔs ayi atané melɔ Bɛroa; Aristakɔs ne Sɛkundɔs abi átané melɔ Tɛssalonika ne Gayɔs ayi atané melɔ Debe, Timɔti, Tikikɔs ne Trɔfimɔs abi átané gebagé mewaá Ɛsya. ");
INSERT INTO anvNT_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Ɛbwɔ́ abɔgé mbɛ, ákwɔ́négé né Truus ágií ɛsé. Ɛse dela né Filipi. Ne gébégé ɛpaá brɛd ayi alá muale ɛkoógé, ");
INSERT INTO anvNT_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","ɛse dekpɛ ɛ́kpe né Filipi mankwɔlé ɛbwɔ́. Ɛsé dekɛ nnyinnyi né ndɔ ɛta. Débanégé ɛbwɔ́ né melɔ Truus, debɛlé ɛfɛɛ́ uwyaá kpogele. ");
INSERT INTO anvNT_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Bií mbɛ né uwyaá ukwɔnege, ɛse ne ɛchomele bɔɔ́ Jisɔs déjwɔlé melu ɛma manyɛ menyɛɛ́ gejeé. Ndɛre Pɔl alu manjyɛ dondo, alɔ mangaré mekomejɔɔ́ Ɛsɔwɔ, ne ashií garégé garégé kpaá tɛ metɔɔ́ utuú. ");
INSERT INTO anvNT_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Ábɔ́ álwɛ́ gejamégé mawɛ né maá gepu né mfaá ɛyɔŋ mbaá ayi ɛsé debɔ́ déchome. ");
INSERT INTO anvNT_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Gesagé muú ayi akuú ji Yutikɔs abɔ́ ajwɔlé né maá menombí. Ndɛre Pɔl agarege mekomejɔɔ́ Ɛsɔwɔ ajyɛ mbɛ, maá yimbɔ alɔ mambɛlé gejya. Abɛlé kpaá aloó mfaá maŋɔ́ɔ ɛyɔŋ alɛɛ́ akwé mme. Áké ájyɛ bwɛ ji, agbo mɛ́. ");
INSERT INTO anvNT_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Pɔl akwɔlé ɛbwɔ́ ajyɛ fyále gesagé muú yimbɔ mme ne aké ne abi atɛné, “Deligé sé, agbó wɔ́, alu mebɛ!” ");
INSERT INTO anvNT_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Ne Pɔl akéré mfaá ɛyɔŋ anyɛɛ́ge menyɛɛ́ gejeé, ama lɔ mangaré mekomejɔɔ́ Ɛsɔwɔ kpaá tɛ bií ujya ne ale ajyɛ. ");
INSERT INTO anvNT_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Ɛwyagé ɛbwɔ́ ágbaré gesagé muú yimbɔ áfɛ́ ne ji mmu mebɛ ne matɔɔ́ bwɔ́ ákwené. ");
INSERT INTO anvNT_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Ɛsé ako abi dekɛne ne Pɔl, dejyɛ kpɛ́ ɛ́kpe, defɛ́ né melɔ Asos gétúgé Pɔl abɔ́ agaré ɛsɛ́ nnó debɔ mbɛ, ji akɛne mewaá mewaá abané ɛsé ɛwu. ");
INSERT INTO anvNT_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Ábánégé ɛsé né Assɔs, ɛse desɛ ji dekpɛ ɛ́kpe defɛ né melɔ Mitylɛn. ");
INSERT INTO anvNT_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Bií ujyagé ɛsé dema kpɛ́ ɛ́kpe dekɛ nnyinnyi dekwɔné kwɔ́kwɔ́lé ne Kiɔs ne dékɛne wyɛ dejyɛ. Bií ujyagé dékwɔné né Samɔs. Bií ɛbi fɔ ujyagé ɛsé dékɛ dekwɔné Miletus. ");
INSERT INTO anvNT_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Ɛsé debɔ́ dékɛné mbɔ, dekoó Ɛfɛsɔs koóge getúgé Pɔl abɔ akɛlege nnó dejyɛ wáwá, déchɔ́ge sé gébé né Ɛsya nnó ji akwɔ́né Jɛrosalɛ nsa nnó bií ɛpaá Pɛntikos ukwɔne. ");
INSERT INTO anvNT_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Ndɛre dekwɔné Miletus, Pɔl alɔ meko né Ɛfɛsɔs nnó ágaré ákpakpa ɛchomele bɔɔ́ Jisɔs nnó áchwɔ́ ábané ji ɛfɛɛ́. ");
INSERT INTO anvNT_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Ɛbwɔ́ áchwɔge, alɔ manjɔɔ́ ne ɛbwɔ́ aké, “Ɛnyú dekaá nkane ɛsé delu mɛ́ chóncho, lɔ né bií mbɛ ɛbi nkwɔne né mme Ɛsya kpaá tɛ fi. ");
INSERT INTO anvNT_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Mbɔ mpyɛ utɔɔ́ ba nkane maá defwɛ Ɛsɔwɔ ne mpɔ́ fɔ́ ne nepa, nlu ne gejamégé manse né amɛ. Ngɛ́ ntó gekpɛ́kpɛ́gé ɛfwyale ne gébé gefɔ́ nlu ne manse né amɛ gétúgé gekpɛ́kpɛ́gé ɛfwyale ɛwé bɔɔ́ Jus achyɛge me. ");
INSERT INTO anvNT_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Ɛnyú dekaá nkane mbɔ ngarege ɛnyu mekomejɔɔ́ Ɛsɔwɔ ne nkɛne upú, upú nlɛrege ɛnyú ne mbi fɔ geno ɛyige gekage póo ɛnyú wɔ́. ");
INSERT INTO anvNT_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Wyɛ meko wu ama ne mbɔ́ ngaré bɔɔ́ Jus ne bɔɔ́ Grek nnó ábɔ́ manlyá gabo, akéré mbaá Ɛsɔwɔ ne áfyɛ matɔɔ́ ne Ata Jisɔs Kras ɛsé. ");
INSERT INTO anvNT_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Ne nana njyɛ né Jɛrosalɛ nkane Mendoó Ukpea ɛgaré me ne nkaá fɔ́ genó ɛyi gepyɛ nyɛ me ɛwu wɔ́. ");
INSERT INTO anvNT_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Genó ɛyigé nkaá gelu nnó yɛndé melɔ ɛwé nkwɔnégé, Mendoó Ukpea ɛgarege me nnó áchyɛge nyɛ me ɛfwyale ne áfyɛ nyɛ me denɔ né Jɛrosalɛ. ");
INSERT INTO anvNT_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Yɛ́mbɔ nsɛ yɛ gemɛ ya nnó nlu muú wɔ́, nkɛlege le manéré utɔɔ́ ɛbi Ata Jisɔs afyɛ me amu nnó ngaré abya melɔ́mélɔ́ nkane Ɛsɔwɔ alɛré bɔɔ́ galɔ́gálɔ́ nnó ɛbwɔ́ ápó. ");
INSERT INTO anvNT_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","“Ne mbɔ nkɛne metɔɔ́ metɔɔ́ ɛnyú ngarege nkane gefwage Ɛsɔwɔ gelu, ne nkaá nnó ɛnyú degɛné sé me. ");
INSERT INTO anvNT_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Gɔge me ngaré ɛnyú nana nnó muú alagé meso, anogé né ɛgbɛ ɛwé Ɛsɔwɔ, ji mbɔɔ́ ne akaá, me mpɔ́ wyɛ. ");
INSERT INTO anvNT_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Mbɔ ngaré mɛ ɛnyú yɛndé genó ɛyigé Ɛsɔwɔ akɛlege mampyɛ ne mbi fɔ́ yɛ genó gema wɔ́. ");
INSERT INTO anvNT_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Delagé meso. Bage gemɛ nyú ne bɔɔ́ Ɛsɔwɔ abi Mendoó Ukpea ɛfyɛ ɛnyú né amu. Pɛge ɛbwɔ́ wyɛ nkane membamé magɔŋme ápɛle magɔŋme jií, tege nnó Ɛsɔwɔ akwɔ mɛ gewugé ɛchomelé bɔɔ́ Jisɔs ne manoó maá wuú nnó ábɛ́ bɔɔ́ bií. ");
INSERT INTO anvNT_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Njɔge mbɔ nendé nkaá nnó ntigé nyɛ meso, ukwala utanege nyɛ dafyɛ uchwɔ́ báne ɛnyú ne uchwɔge ulyágé fɔ́ magɔŋme yina. ");
INSERT INTO anvNT_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Ne bɔɔ́ fɔ átanege nyɛ ntó metɔɔ́ metɔɔ́ nyú nnó abwɔlé bɔɔ́ Jisɔs akwɔlé ɛbwɔ́. ");
INSERT INTO anvNT_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Sɛ́ge gébé détégé nkane mbɔ́ nchyɛge yɛ́ndémuú majyɛ́ né aŋmɛ́ alɛɛ́ utuú ne ŋwɔmese ne manse. ");
INSERT INTO anvNT_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","“Ne náná ayi áfyɛɛ́ ɛnyú né amu Ɛsɔwɔ, nchyɛge ɛnyú majyɛ́ nnó dewuge le mekomejɔɔ́ wuú ayi álɛrege nkane ápyɛ ɛnyú debɔɔ́ nyɛ ɛshyɛ, ne debɔ nyɛ ntó mejé ɛwé Ɛsɔwɔ ábelé mbaá bɔɔ́ bií ako. Ɛnyú dekaá nkane geŋwá ya gelu. ");
INSERT INTO anvNT_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Ɛnyú dekaá nkane mbɔ nlu ne ɛnyú, nnɛrege fɔ́ mwɔle né ŋka muú yɛ mandeé jií. ");
INSERT INTO anvNT_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Mbɔ mpyɛ utɔɔ́ ne amu ya ne ɛse ne bɔɔ́ ba degɛ́ne geno ɛyige dekɛlege. ");
INSERT INTO anvNT_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Unó uko ɛbi mbɔ mpyɛ ulɛré nnó muú abɔ́ mampyɛ utɔɔ́ ne amu jií nnó apoó bɔɔ́ bi álá pɔ́ ne ɛshyɛ. Tege ntó nkane Ata Jisɔs abɔ́ ajɔɔ́ nnó, ‘Méjé ɛlu ne muú yi achyɛge ɛchyɛ ɛpwɔ́ muú yi agile nnó áchyɛgé ji chyɛge.’” ");
INSERT INTO anvNT_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Ne Pɔl anerege manjɔɔ́ unó bi, ɛbwɔ́ ako ató mano mme, anɛmmyɛ. ");
INSERT INTO anvNT_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Ne ɛbwɔ́ ako alɔ manli, átyaá ji ne átamé ji nnó akɛ́ pere! ");
INSERT INTO anvNT_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Ɛbwɔ́ ábɔ́ ásomege dɔɔ́ gétúgé Pɔl abɔ aké, Ɛbwɔ́ ámágé gɛ́ sé ji ne ɛbwɔ́ ájyɛ tí ji ákwɔné né mbaá ayi akpɛ́ne ɛ́kpe. ");
INSERT INTO anvNT_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Ɛsé ako ne Pɔl delyage ɛbwɔ́, dekpɛ ɛ́kpe defɛ́ cho né Kɔs. Ne újyágé dekwɔné Rudis, detanege ɛfɛɛ́ dejyɛ né Patara. ");
INSERT INTO anvNT_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Ne dekwɔné ɛfɛɛ́, degɛ́ ɛ́kpe ɛwécha ɛwé ɛjyɛ melɔ Fonisiya. Dekpɛ ɛwu dekɛ nnyinnyi. ");
INSERT INTO anvNT_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Dékwɔ́négé né melu ɛwé degɛ́ne melɔ Syaprɔs, delya ɛwu ne ɛgbɛ ɛbwɔbɛ, degya dejyɛ né Siriya. Dékwɔ́négé Tiya, ɛ́kpe ɛtaré ɛsé detané nende gɛ mbaá yi áférege metuú mbɔ. ");
INSERT INTO anvNT_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Détánégé dejyɛ kɛ́le bɔɔ́ Jisɔs. Degɛ́gé ɛbwɔ́, debɛlé ne ɛbwɔ́ né uwyaá kpogele. Mendoó Ukpea ɛpyɛ ɛbwɔ́ agaré Pɔl nnó ajyɛgé fɔ né Jɛrosalɛ. ");
INSERT INTO anvNT_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Ndɔ ɛyi ɛsé delu manjyɛ ɛkwɔ́négé, detane nnó dejyɛ. Bɔɔ́ Jisɔs ako chóncho ne andée bwɔ́ ne baá bwɔ́, ájyɛ tí ɛsé ákoó melɔ ákwɔné mbále nnyi. Ne detó mano mme ɛfɛɛ́ denɛmmyɛ. ");
INSERT INTO anvNT_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Ɛsé detamé atɛ ne ɛsé dejyɛ kpɛ ɛ́kpe, ɛbwɔ́ akéré meso mmu. ");
INSERT INTO anvNT_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Délyágé melɔ Tiya, dekwɔné melɔ Ptolɛmɛs ne dema táne né ɛ́kpe dejyɛ tame bɔɔ́ Jisɔs abi alu ɛfɛɛ́. Debɛlé ne ɛbwɔ́ dama. ");
INSERT INTO anvNT_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Bií újyagé dejyɛ dekpɛ ɛ́kpe defɛ́ né melɔ Kaisaria. Dékwɔ́négé ɛwu, dekpɛ né gepúge Filip, debɛlé ne ji. Alu muú yi akɛne agarege mekomejɔɔ́ Ɛsɔwɔ, ne alu ntó muú ama né gelúagé bɔɔ́ utɔɔ́ akénéama abi abɔ ajya né Jɛrosalɛ. ");
INSERT INTO anvNT_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Ji abɔ́ áwya baá andée ani ne apɔ́ fɔ ne anɔ, álu bɔɔ́ bi áwuú meko ayi atáne mbaá Ɛsɔwɔ ne ágarege. ");
INSERT INTO anvNT_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Ndɛre ɛsé delú ɛfɛɛ́ né gejamégé ndɔ, muú ɛkpavé Ɛsɔwɔ fɔ ayi akuú ji Agabos atané Judiya achwɔ́. ");
INSERT INTO anvNT_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Áchwɔgé agɛ́ ɛsé, abɔ́ ɛkanda Pɔl awɛ uka ne amu jií. Ne aké, “Mendoó Ukpea ɛké gɛ na ne bɔɔ́ Jus apyɛ nyɛ ne mbɔɔ́ ɛkanda ɛwé né Jɛrosalɛ ne afyɛ nyɛ ji né amu bɔɔ́ abi álá pɔ́ bɔɔ́ Jus.” ");
INSERT INTO anvNT_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Ne ɛsé ako dewuúge mbɔ, dekwɔ Pɔl mata nnó ajyɛgé né Jɛrosalɛ. ");
INSERT INTO anvNT_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Pɔl ashuú ɛsé meko ake, “Nde ɛnyú delilí, defyɛ me gepwa né metɔɔ́? Nkpome mɛ́ mmyɛ manjyɛ denɔ né Jɛrosalɛ yɛ mangbo getúge Ata Jisɔs.” ");
INSERT INTO anvNT_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Tɛ ndɛre ɛsé delá káge kwɔre metɔɔ́ wuú, delya yɛndé geno nnó Ata Ɛsɔwɔ apyɛ ndɛre ɛjií ji. ");
INSERT INTO anvNT_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Ne ɛbɛ́légé mboó ndɔ, dénywéré unó sé dekwɔ́ défɛɛ́ né Jɛrosalɛ. ");
INSERT INTO anvNT_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Ne bɔɔ́ Jisɔs fɔ abi atané Kaisaria áfɛ́ ntó ne ɛsé ne ásɛ ɛsé ábelé né gepúge Mnasen mbaá ayi ábele nnó dejwɔlege. Mende yina atané melɔ Syaprɔs ne abɔ́ áfyɛɛ́ metɔɔ́ ne Jisɔs gébégé depɔre Jisɔs delɔ lɔ. ");
INSERT INTO anvNT_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Ndɛre ɛsé dekwɔne né Jɛrosalɛ, bɔɔ́ Jisɔs abi alu ɛfɛɛ́ ásɛ ɛsé cháŋéné. ");
INSERT INTO anvNT_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Bií ujyage ɛsé ako ne Pɔl dejyɛ gɛ́ Jɛmsi ne ákpakpa bɔɔ́ ɛchomele Jisɔs ako alu ntó ɛfɛɛ́. ");
INSERT INTO anvNT_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Ne Pɔl atámégé ɛbwɔ́, alɔ mangaré unó gemagema ɛbi Ɛsɔwɔ abɔ apyɛ́ metɔɔ́ metɔɔ́ bɔɔ́ abi álá pɔ́ bɔɔ́ Jus gébégé ji agarege ɛbwɔ́ mekomejɔɔ́ Ɛsɔwɔ. ");
INSERT INTO anvNT_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Ne ɛbwɔ́ áwuúge mbɔ, áfɛɛ́ Ɛsɔwɔ ne ákuú Pɔl aké, “Meŋmɛ, pɛ́ gejame bɔɔ́ Jus áfyɛɛ́ matɔɔ́ ne Jisɔs. Ne kaá nnó ɛbwɔ́ álu kpáne gechyɛ́ né mabɛ Mosis. ");
INSERT INTO anvNT_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Ɛbwɔ́ ama áwuú nnó ɔkɛne ɔgarege bɔɔ́ Jus abi álú né malɔ bɔɔ́ abi álá pɔ́ bɔɔ́ Jus nnó ásɔgé sé baá bwɔ́ nsɔ ne yɛ mankwɔlé gepɔge bɔɔ́ Jus ákwɔlégé. ");
INSERT INTO anvNT_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Ɛsé dekaá nnó bɔɔ́ áwuú nyɛ nnó ɔchwɔ́ fa, nana ɛsé depyɛ nnó? ");
INSERT INTO anvNT_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Ntɛ pyɛ ndɛre ɛsé dekɛlege mangaré wɔ. Ande fɔ ani alu fa abi anerege mampyɛ depɔ ɛtire ɛbwɔ́ abɔ anyɛ́meno mbaá Ɛsɔwɔ. ");
INSERT INTO anvNT_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Chó ne ɛbwɔ́ ɛnyú depyɛ gepɛ mamféré ɛfwyale ɛwe ɛlu ɛnyú mmyɛ, ne chyɛ unó uko ɛbi abɔ́ manchyɛ né gepɛ ɛyigembɔ ne ákpalé ɛbwɔ́ makpo. Ɔpyɛge mbɔ bɔɔ́ ako ágɛ́ne nyɛ nnó wɔ mbɔɔ́ ɔbelege mabɛ́ Mosis. Ne bɔɔ́ ákage nyɛ nnó unó bi bɔɔ́ ajɔɔ́ getu jyɛ úlú gebyɔ. ");
INSERT INTO anvNT_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Ɛsé desá ŋwɛ detɔ́ mbaá bɔɔ́ Jisɔs abi álá pɔ́ bɔɔ́ Jus, nnó ábɔ́ fɔ́ manyɛ menyɛɛ́ ayi ápyɛɛ́ upɛ wyɛ wɔ́, ne anyɛɛ́gé manoó menya ne álya ntó manáné tametame.” ");
INSERT INTO anvNT_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Ne Pɔl asɛ bɔɔ́ bimbɔ, bií újyage ɛbwɔ́ ájyɛ lɔ depɔ ɛtire mamféré ɛfwyalé ɛwé ɛlu ɛbwɔ́ mmyɛ. Ne Pɔl akpɛ mmu ɛcha upɛ Ɛsɔwɔ mangaré bií ɛbi depɔ ɛtiré na debyɛ nyɛ, ne yɛ́ndémuú bwɔ́ achyɛge nyɛ unó upɛ bi mbaá Ɛsɔwɔ. ");
INSERT INTO anvNT_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Gepɛ ɛyigémbɔ gebɛ́lege ndɔ ɛkeneama, ne bií ɛbi ndɔ ɛyimbɔ ɛchwɔ́ byɛ, bɔɔ́ Jus fɔ abi átané gebagé mewaá Ɛsya ágɛ Pɔl né ɛcha upɛ Ɛsɔwɔ. Ánnyi gejamégé bɔɔ́ matɔɔ́ ne ápyɛ ji. ");
INSERT INTO anvNT_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","Ákalege áké, “Bɔɔ́ Isrɛli chwɔ́ge depoó ɛse, depyɛ mende yina. Gɛ mende yi akɛ́ne yɛndé mbaá ágarege bɔɔ́ nnó ábyágé melɔ ɛsé, ne mabɛ́ Mosis ne ɛcha upɛ Ɛsɔwɔ ɛwéna. Ne nana akpɛ ne bɔɔ́ Grek né ɛcha upɛ Ɛsɔwɔ, nkane apyɛmbɔ afyɛ deba né melu ukpea ɛwe.” ");
INSERT INTO anvNT_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Ɛbwɔ́ ájɔge mbɔ gétúgé abɔ́ ágɛné Pɔl akɛne ne Trɔfimɔs ayi atane Ɛfɛsɔs né metɔɔ́ melɔ, ne áfɛ́rege nnó Pɔl akpɛ ne ji né ɛcha upɛ Ɛsɔwɔ. ");
INSERT INTO anvNT_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Ndɛre ɛbwɔ́ ákálé mbɔ, melɔ meko ɛkwé tametame, bɔɔ́ ako ábó áchwɔ́ chome mbaá ama. Ágbaré Pɔl, ája ji átané né ɛcha upɛ. Ndɛré ɛbwɔ́ ábɔ́ atane, bɔɔ́ ala tɛ́netɛ́ne ágbɛ́ manombi. ");
INSERT INTO anvNT_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Ne bɔɔ́ bina álɔ mantule Pɔl ne ákɛ́lege manwá ji. Menɔ muú bɔɔ́ bee Rom awuúge nnó melɔ Jɛrosalɛ meko ɛlu né ɛfwyale, ");
INSERT INTO anvNT_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","ala mbɔ asɛ bɔɔ́ bee ne ákpakpa bwɔ́, álomé áchwɔ́ kpɛ metɔɔ́ metɔɔ́ gejamégé bɔɔ́ bimbɔ. Bɔɔ́ bina ágɛ́gé ndɛre ɛbwɔ́ áchwɔ́, álya mantule Pɔl. ");
INSERT INTO anvNT_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Ne muú kpaá yimbɔ achwɔ́ gbaré Pɔl aké, “Áwɛ́ ji bɔ mkpɔkovɛ́ apeá ne agií bɔɔ́ bimbɔ gefɔɔ́gé muú ayi Pɔl alu ne genó ɛyige ji apyɛ́.” ");
INSERT INTO anvNT_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Agige mbɔ, bɔɔ́ álɔ manwyale, abi ápáne ɛwé, abifɔ ápáne ɛwechá. Ápyɛ́ muú kpaá bɔɔ́ bee yimbɔ akwé tametame yɛ tógésé genó ɛyi gepyɛ akaá wɔ́, ne ajɔɔ́ ne bɔɔ́ bií nnó ásɛ Pɔl ájyɛ né dachi bɔɔ́ bee. ");
INSERT INTO anvNT_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Ndɛre ájyɛ ákwɔ́négé melu ɛwé akwɔme mfaá gepú, bɔɔ́ bee abwɛ ji gétúgé bɔɔ́ bimbɔ áchwɔ́ ne ncha. ");
INSERT INTO anvNT_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Ɛbwɔ́ ako ákwɔ́lege Pɔl meso ákálege nnó áwá ji. ");
INSERT INTO anvNT_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Ndɛre áchwɔ́ kpɛ ne Pɔl né dachi bɔɔ́ bee, Pɔl agií menɔ muú bɔɔ́ bee. “Nnó ɔkaáge chyɛ me gébé njɔɔ́ genó fɔ ne wɔ?” Mende yimbɔ awuúge Pɔl ajɔge Grek agií aké, “Mbɔ ne ɔkaáge